-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_5_station_131
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_5_station_131`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_5_station_131` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_5_station_131`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3249 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (3241,3022,'',0,'6.1','5','131','CASH','','2021-03-06 01:41:38',5,0.00,0.00,'','600','2021-03-06 01:41:38','600',0,1),(3242,4006,'',0,'22','5','131','PURCHASES','','2021-03-06 01:42:03',5,0.00,0.00,'','600','2021-03-06 01:42:03','600',0,1),(3243,4020,'',0,'20','5','131','SALES','','2021-03-06 01:42:26',5,0.00,0.00,'','600','2021-03-06 01:42:26','600',0,1),(3244,30158,'',0,'24','5','131','SALARIES & WAGES','','2021-03-06 01:43:01',5,0.00,0.00,'','600','2021-03-06 01:43:01','600',0,1),(3245,30159,'',0,'24','5','131','PURCHASES','','2021-03-06 01:43:24',5,0.00,0.00,'','600','2021-03-06 01:43:24','600',0,1),(3246,4028,'',0,'2','5','131','UBA-1021732970','','2021-03-06 01:44:24',5,0.00,0.00,'','600','2021-03-06 01:44:24','600',0,1),(3247,4029,'',0,'2','5','131','JA\'IZ-0010037957','','2022-03-02 19:12:03',5,0.00,0.00,'','600','2022-03-02 19:12:03','600',0,0),(3248,2000,'',0,'6','5','131','INVENTORY VALUE ADJUSTMENT','','2023-02-06 10:37:06',5,0.00,0.00,'','600','2023-02-06 10:37:06','600',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=82900 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
INSERT INTO `accounts_vouchers_items` VALUES (80368,'5','131',43593,3241,'daily expenses',6000.00),(80369,'5','131',43593,3241,'gen repair',10000.00),(80370,'5','131',43594,3241,'daily expenses',6000.00),(80371,'5','131',43595,3241,'daily expenses',6000.00),(80501,'5','131',43712,3241,'daily expenses',6300.00),(80502,'5','131',43714,3241,'daily expenses',6300.00),(80503,'5','131',43715,3241,'daily expenses',6300.00),(80504,'5','131',43715,3241,'by head of retail to manager ',30000.00),(80505,'5','131',43716,3241,'daily expenses',6300.00),(80506,'5','131',43717,3241,'daily expenses',6300.00),(80507,'5','131',43718,3241,'daily expenses',6300.00),(80515,'5','131',43724,3241,'daily expenses',6100.00),(80516,'5','131',43725,3241,'daily expenses',6100.00),(80517,'5','131',43726,3241,'daily expenses',6300.00),(80518,'5','131',43726,3241,'pumps refair ',57000.00),(80519,'5','131',43728,3241,'daily expenses',6300.00),(80520,'5','131',43729,3241,'daily expenses',6300.00),(80522,'5','131',43731,3241,'daily expenses',6300.00),(80523,'5','131',43732,3241,'daily expenses',6300.00),(80524,'5','131',43733,3241,'Daily Expenses ',6300.00),(80525,'5','131',43733,3241,'Gen Repair',5000.00),(80532,'5','131',43740,3241,'Daily Expenses ',6300.00),(80533,'5','131',43741,3241,'Daily Expenses ',6300.00),(80534,'5','131',43741,3241,'Weight Measure ',50000.00),(80536,'5','131',43743,3241,'Daily Expenses ',6300.00),(80537,'5','131',43743,3242,'Data ',1000.00),(80541,'5','131',43746,3241,'Daily Expenses ',6300.00),(80542,'5','131',43746,3241,'pumps refair ',28600.00),(80543,'5','131',43747,3241,'Daily Expenses ',6300.00),(80625,'5','131',43819,3241,'Daily Expenses ',6300.00),(80626,'5','131',43820,3241,'Daily Expenses ',6300.00),(80666,'5','131',43854,3241,'Daily Expenses ',6300.00),(80667,'5','131',43855,3241,'Daily Expenses ',6300.00),(80668,'5','131',43856,3241,'Daily Expenses ',6300.00),(80669,'5','131',43856,3241,'Audit Logistics ',10000.00),(80670,'5','131',43857,3241,'Daily Expenses ',6300.00),(80890,'5','131',44030,3241,'Daily Expenses ',6300.00),(80891,'5','131',44030,3241,'gen repair',15000.00),(80892,'5','131',44030,3241,'bulbs ',46800.00),(80893,'5','131',44031,3241,'Daily Expenses ',6300.00),(80894,'5','131',44032,3241,'Daily Expenses ',6300.00),(80895,'5','131',44033,3241,'daily expenses',6300.00),(80896,'5','131',44034,3241,'Daily Expenses ',6300.00),(80897,'5','131',44035,3241,'Daily Expenses ',6300.00),(80898,'5','131',44035,3241,'Salary',260000.00),(80899,'5','131',44036,3241,'Daily Expenses ',6300.00),(80900,'5','131',44037,3241,'Daily Expenses ',6300.00),(80901,'5','131',44037,3241,'pumps refair',15500.00),(80927,'5','131',44057,3241,'Daily Expenses ',6300.00),(80929,'5','131',44059,3241,'Daily Expenses ',6300.00),(80930,'5','131',44060,3241,'Daily Expenses ',6300.00),(80953,'5','131',44080,3241,'Daily Expenses ',6300.00),(80966,'5','131',44093,3241,'Daily Expenses ',6300.00),(80972,'5','131',44099,3241,'Daily Expenses ',6300.00),(80985,'5','131',44113,3241,'Daily Expenses ',6300.00),(80986,'5','131',44113,3241,'Gen Repair/service ',12000.00),(81018,'5','131',44141,3241,'Daily Expenses ',6300.00),(81019,'5','131',44142,3241,'Daily Expenses ',6300.00),(81020,'5','131',44143,3241,'Daily Expenses ',6300.00),(81021,'5','131',44144,3241,'Daily Expenses ',6300.00),(81022,'5','131',44145,3241,'Daily Expenses ',6300.00),(81030,'5','131',44151,3241,'Daily Expenses ',6300.00),(81042,'5','131',44162,3241,'Daily Expenses ',6300.00),(82887,'5','131',45865,3241,'Daily Expenses ',6900.00),(82888,'5','131',45866,3241,'Daily Expenses ',6900.00),(82889,'5','131',45866,3241,'Eng. Peter For Pumps Repairs  ',101000.00),(82893,'5','131',45871,3241,'Daily Expenses ',6900.00),(82894,'5','131',45871,3241,'Eng. Peter For Pumps Repairs  ',110000.00),(82899,'5','131',45875,3241,'Daily Expenses ',6900.00);
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=17464 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('5','131',16773,'745',1350.00,3500.00,'2021-10-03','','2021-10-11 15:01:58','628','628',2021,'628','2021-10-11 15:01:58',5),('5','131',16774,'744',150.00,740.00,'2021-10-03','','2021-10-11 15:03:22','628','628',2021,'628','2021-10-11 15:03:22',5),('5','131',16888,'744',1224.42,1150.00,'2021-10-23','To be withdrawn on my next purchase ','2021-10-23 17:50:37','628','628',2021,'628','2021-10-23 17:50:37',5),('5','131',17463,'744',3642.41,3765.00,'2021-11-04','','2021-11-04 07:46:03','628','628',2021,'628','2021-11-04 07:46:03',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2091 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('5','131','744',2084,'5','PMS PUMP 1',611703.79,'PMS DESPENSER','',NULL,NULL,'',5,'2021-03-05 15:26:45','600'),('5','131','744',2085,'5','PMS PUMP 2',1116336.32,'PMS DESPENSER','',NULL,NULL,'',5,'2021-03-05 15:28:10','600'),('5','131','744',2086,'5','PMS PUMP 4',394221.84,'PMS DESPENSER','',NULL,NULL,'',5,'2021-03-05 15:29:51','600'),('5','131','745',2087,'5','PMS PUMP 3',806563.29,'PMS DESPENSER','',NULL,NULL,'',5,'2021-03-05 15:28:47','600'),('5','131','745',2088,'5','PMS PUMP 5',607829.78,'PMS DESPENSER','',NULL,NULL,'',5,'2021-03-05 15:30:47','600'),('5','131','745',2089,'5','PMS PUMP 6',83599.99,'PMS DESPENSER','',NULL,NULL,'',5,'2021-03-05 15:31:59','600'),('5','131','747',2090,'5','AGO PUMP 7',126718.86,'AGO DESPENSER','',NULL,NULL,'',5,'2021-03-05 15:32:43','600');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=257702 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('5','131',181745,'FULL','2021-03-01','2021-03-01 00:00:00',NULL,'600',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','131',182968,'daily shift       ','2021-03-04','2021-03-04 00:00:00',NULL,'475',0.00,857766.42,'475','2021-03-07 18:14:39','600','2021-03-07 18:17:03',10,0),('5','131',182972,'daily shift       ','2021-03-06','2021-03-06 00:00:00',NULL,'475',0.00,632839.71,'475','2021-03-07 18:27:04','600','2021-03-07 18:44:22',10,0),('5','131',182973,'daily shift       ','2021-03-07','2021-03-07 00:00:00',NULL,'475',0.00,33940.00,'475','2021-03-07 18:47:58','605','2021-03-08 05:16:08',10,0),('5','131',186255,'daily shift       ','2021-03-08','2021-03-08 00:00:00',NULL,'475',0.00,100893.45,'475','2021-03-23 15:44:36','605','2021-03-23 15:47:58',10,0),('5','131',186258,'daily shift       ','2021-03-09','2021-03-09 00:00:00',NULL,'475',0.00,64381.75,'475','2021-03-23 15:52:15','605','2021-03-23 15:53:32',10,0),('5','131',186259,'daily shift       ','2021-03-10','2021-03-10 00:00:00',NULL,'475',0.00,119183.75,'475','2021-03-23 15:57:13','605','2021-03-23 15:58:09',10,0),('5','131',186262,'daily shift       ','2021-03-11','2021-03-11 00:00:00',NULL,'475',0.00,53977.85,'475','2021-03-23 16:01:41','605','2021-03-23 16:02:53',10,0),('5','131',186265,'daily shift       ','2021-03-12','2021-03-12 00:00:00',NULL,'475',0.00,22999.35,'475','2021-03-23 16:05:31','605','2021-03-23 16:06:16',10,0),('5','131',186266,'daily shift       ','2021-03-12','2021-03-12 00:00:00',NULL,'475',0.00,32517.60,'475','2021-03-23 16:09:31','605','2021-03-23 16:10:30',10,0),('5','131',186268,'daily shift       ','2021-03-13','2021-03-13 00:00:00',NULL,'475',0.00,117613.65,'475','2021-03-23 16:12:33','605','2021-03-23 16:13:32',10,0),('5','131',186274,'daily shift       ','2021-03-14','2021-03-14 00:00:00',NULL,'475',538995.36,650843.46,'475','2021-03-24 10:39:46','605','2021-03-24 10:55:29',10,0),('5','131',186403,'daily shift       ','2021-03-15','2021-03-15 00:00:00',NULL,'475',403579.85,516057.80,'475','2021-03-24 11:06:41','605','2021-03-24 11:10:36',10,0),('5','131',186409,'daily shift       ','2021-03-16','2021-03-16 00:00:00',NULL,'475',0.00,138373.20,'475','2021-03-24 11:13:36','605','2021-03-24 11:16:30',10,0),('5','131',186411,'daily shift       ','2021-03-17','2021-03-17 00:00:00',NULL,'475',405320.69,467664.59,'475','2021-03-24 11:21:50','605','2021-03-24 11:41:31',10,0),('5','131',186422,'daily shift       ','2021-03-18','2021-03-18 00:00:00',NULL,'475',1408836.71,1478301.16,'475','2021-03-24 11:48:20','605','2021-03-24 11:57:32',10,0),('5','131',186423,'daily shift       ','2021-03-19','2021-03-19 00:00:00',NULL,'475',1316062.00,1406758.25,'475','2021-03-24 12:03:39','605','2021-03-24 16:03:24',10,0),('5','131',186475,'daily shift       ','2021-03-20','2021-03-20 00:00:00',NULL,'475',823746.58,923951.03,'475','2021-03-24 16:07:13','605','2021-03-24 16:08:27',10,0),('5','131',186477,'daily shift       ','2021-03-21','2021-03-21 00:00:00',NULL,'475',1345123.27,1345123.27,'475','2021-03-25 10:06:52','605','2021-03-25 11:07:10',10,0),('5','131',186602,'daily shift       ','2021-03-22','2021-03-22 00:00:00',NULL,'475',1467366.75,1467366.75,'475','2021-03-25 11:15:16','605','2021-03-25 11:34:16',10,0),('5','131',186608,'daily shift       ','2021-03-23','2021-03-23 00:00:00',NULL,'475',990968.28,990968.28,'600','2021-03-25 12:54:31','605','2021-03-25 13:15:34',10,0),('5','131',186651,'daily shift       ','2021-03-24','2021-03-24 00:00:00',NULL,'475',763514.82,763514.82,'600','2021-03-25 14:27:49','605','2021-03-25 14:40:34',10,0),('5','131',186724,'daily shift       ','2021-03-25','2021-03-25 00:00:00',NULL,'475',1474036.71,1474036.71,'475','2021-03-30 09:04:25','605','2021-03-30 10:03:46',10,0),('5','131',187660,'daily shift       ','2021-03-26','2021-03-26 00:00:00',NULL,'475',1380112.85,1380112.85,'475','2021-03-30 10:53:47','605','2021-03-30 11:50:07',10,0),('5','131',187692,'MORNING','2021-03-27','2021-03-27 00:00:00',NULL,'475',1468980.45,1468980.45,'475','2021-03-30 12:14:38','605','2021-03-30 12:20:48',10,0),('5','131',187701,'MORNING','2021-03-28','2021-03-28 00:00:00',NULL,'475',1326388.05,1326388.05,'475','2021-03-30 12:54:52','605','2021-03-30 14:23:06',10,0),('5','131',187857,'MORNING','2021-03-29','2021-03-29 00:00:00',NULL,'475',1537947.38,1537947.38,'475','2021-03-31 09:13:21','605','2021-04-01 00:20:50',10,0),('5','131',188109,'daily shift       ','2021-03-30','2021-03-30 00:00:00',NULL,'475',101296.35,101296.35,'475','2021-04-01 11:40:27','605','2021-04-01 11:42:49',10,0),('5','131',188111,'daily shift       ','2021-03-31','2021-03-31 00:00:00',NULL,'475',665698.52,665698.52,'475','2021-04-01 11:47:22','605','2021-04-01 11:48:31',10,0),('5','131',188113,'daily shift       ','2021-04-01','2021-04-01 00:00:00',NULL,'475',1663444.34,1663444.34,'475','2021-04-02 10:29:31','605','2021-04-03 09:02:05',10,0),('5','131',188566,'daily shift       ','2021-04-02','2021-04-02 00:00:00',NULL,'475',1986251.17,1986251.17,'475','2021-04-03 18:15:44','605','2021-04-03 18:17:40',10,0),('5','131',188568,'daily shift       ','2021-04-03','2021-04-03 00:00:00',NULL,'475',1624109.18,1679356.38,'475','2021-04-04 08:37:13','605','2021-04-04 08:40:04',10,0),('5','131',188645,'daily shift       ','2021-04-04','2021-04-04 00:00:00',NULL,'475',1156238.70,1156238.70,'475','2021-04-05 09:13:54','605','2021-04-05 14:29:00',10,0),('5','131',188942,'daily shift       ','2021-04-05','2021-04-05 00:00:00',NULL,'475',1778947.78,1778947.78,'475','2021-04-05 19:00:39','605','2021-04-06 04:53:10',10,0),('5','131',189159,'daily shift       ','2021-04-06','2021-04-06 00:00:00',NULL,'475',2296866.11,2296866.11,'475','2021-04-06 18:41:51','605','2021-04-06 20:09:42',10,0),('5','131',189252,'daily shift       ','2021-04-07','2021-04-07 00:00:00',NULL,'475',2009937.67,2009937.67,'475','2021-04-07 18:54:03','605','2021-04-07 21:43:22',10,0),('5','131',189524,'daily shift       ','2021-04-08','2021-04-08 00:00:00',NULL,'475',117635.55,117635.55,'475','2021-04-08 18:42:51','605','2021-04-08 19:53:41',10,0),('5','131',189689,'daily shift       ','2021-04-09','2021-04-09 00:00:00',NULL,'475',73948.25,73948.25,'475','2021-04-09 18:25:19','605','2021-04-10 04:44:20',10,0),('5','131',189970,'daily shift       ','2021-04-10','2021-04-10 00:00:00',NULL,'475',79391.35,79391.35,'475','2021-04-10 18:34:28','605','2021-04-11 07:59:26',10,0),('5','131',190108,'daily shift       ','2021-04-11','2021-04-11 00:00:00',NULL,'475',44949.30,44949.30,'475','2021-04-11 18:36:43','605','2021-04-12 08:36:30',10,0),('5','131',190252,'daily shift       ','2021-04-12','2021-04-12 00:00:00',NULL,'475',99515.45,99515.45,'475','2021-04-12 18:33:56','605','2021-04-12 18:55:11',10,0),('5','131',190486,'daily shift       ','2021-04-13','2021-04-13 00:00:00',NULL,'475',50233.40,50233.40,'475','2021-04-13 17:52:51','605','2021-04-14 08:45:53',10,0),('5','131',190756,'daily shift       ','2021-04-14','2021-04-14 00:00:00',NULL,'475',151688.65,151688.65,'475','2021-04-14 17:50:15','605','2021-04-15 07:28:15',10,0),('5','131',190942,'daily shift       ','2021-04-15','2021-04-15 00:00:00',NULL,'475',105994.70,105994.70,'475','2021-04-16 10:10:36','605','2021-04-16 12:02:06',10,0),('5','131',191195,'daily shift       ','2021-04-16','2021-04-16 00:00:00',NULL,'475',54900.05,54900.05,'475','2021-04-16 17:42:09','605','2021-04-17 09:04:04',10,0),('5','131',191457,'daily shift       ','2021-04-17','2021-04-17 00:00:00',NULL,'475',35401.35,35401.35,'475','2021-04-17 17:45:51','605','2021-04-18 12:56:45',10,0),('5','131',191608,'daily shift       ','2021-04-18','2021-04-18 00:00:00',NULL,'475',57955.50,57955.50,'475','2021-04-18 17:49:16','605','2021-04-18 18:19:43',10,0),('5','131',191905,'daily shift       ','2021-04-19','2021-04-19 00:00:00',NULL,'475',110534.15,110534.15,'475','2021-04-19 17:54:42','605','2021-04-20 08:41:44',10,0),('5','131',191984,'daily shift       ','2021-04-20','2021-04-20 00:00:00',NULL,'475',100631.10,100631.10,'475','2021-04-20 17:38:52','605','2021-04-21 07:28:35',10,0),('5','131',192189,'daily shift       ','2021-04-21','2021-04-21 00:00:00',NULL,'475',160219.00,160219.00,'475','2021-04-21 17:40:09','605','2021-04-21 20:33:04',10,0),('5','131',192338,'daily shift       ','2021-04-22','2021-04-22 00:00:00',NULL,'475',1271506.56,1284797.10,'475','2021-04-23 09:54:44','605','2021-04-23 10:28:08',10,0),('5','131',192725,'daily shift       ','2021-04-23','2021-04-23 00:00:00',NULL,'475',1523681.12,1541334.90,'475','2021-04-25 17:05:35','605','2021-04-26 07:57:28',10,0),('5','131',193502,'daily shift       ','2021-04-24','2021-04-24 00:00:00',NULL,'475',1191677.46,1204657.70,'475','2021-04-27 11:58:42','605','2021-04-28 08:46:12',10,0),('5','131',193988,'daily shift       ','2021-04-25','2021-04-25 00:00:00',NULL,'475',1048261.90,1060357.20,'475','2021-04-29 13:02:30','605','2021-04-29 13:22:33',10,0),('5','131',194132,'daily shift       ','2021-04-26','2021-04-26 00:00:00',NULL,'475',899924.61,909456.65,'475','2021-05-07 09:20:48','605','2021-05-07 09:23:39',10,0),('5','131',195587,'daily shift       ','2021-04-27','2021-04-27 00:00:00',NULL,'475',1057685.20,1057685.20,'475','2021-05-07 09:27:03','605','2021-05-07 09:29:09',10,0),('5','131',195590,'daily shift       ','2021-04-28','2021-04-28 00:00:00',NULL,'475',251682.85,251682.85,'475','2021-05-07 09:31:47','605','2021-05-07 09:37:41',10,0),('5','131',195593,'daily shift       ','2021-04-29','2021-04-29 00:00:00',NULL,'475',106689.00,106689.00,'475','2021-05-07 09:39:46','605','2021-05-07 09:40:21',10,0),('5','131',195596,'daily shift       ','2021-04-30','2021-04-30 00:00:00',NULL,'475',87455.30,87455.30,'475','2021-05-07 09:42:48','605','2021-05-07 09:45:18',10,0),('5','131',195599,'daily shift       ','2021-05-01','2021-05-01 00:00:00',NULL,'475',121136.80,121136.80,'475','2021-05-07 09:47:00','605','2021-05-07 09:50:21',10,0),('5','131',195600,'daily shift       ','2021-05-02','2021-05-02 00:00:00',NULL,'475',419049.30,419049.30,'475','2021-05-07 09:53:03','605','2021-05-07 09:55:12',10,0),('5','131',195602,'daily shift       ','2021-05-03','2021-05-03 00:00:00',NULL,'475',746483.80,746483.80,'475','2021-05-07 09:59:50','605','2021-05-07 10:04:52',10,0),('5','131',195605,'daily shift       ','2021-05-04','2021-05-04 00:00:00',NULL,'475',768669.20,768669.20,'475','2021-05-07 10:08:36','605','2021-05-07 10:09:46',10,0),('5','131',195609,'daily shift       ','2021-05-05','2021-05-05 00:00:00',NULL,'475',898368.10,898368.10,'475','2021-05-07 10:14:50','605','2021-05-07 10:16:06',10,0),('5','131',195610,'daily shift       ','2021-05-06','2021-05-06 00:00:00',NULL,'475',819716.00,819716.00,'475','2021-05-07 10:18:50','605','2021-05-07 10:29:21',10,0),('5','131',195666,'daily shift       ','2021-05-07','2021-05-07 00:00:00',NULL,'475',734087.75,734087.75,'475','2021-05-07 17:43:38','605','2021-05-08 04:52:11',10,0),('5','131',195936,'daily shift       ','2021-05-08','2021-05-08 00:00:00',NULL,'475',516750.90,516750.90,'475','2021-05-08 17:30:01','605','2021-05-09 06:37:55',10,0),('5','131',196049,'daily shift       ','2021-05-09','2021-05-09 00:00:00',NULL,'475',800771.35,800771.35,'475','2021-05-10 09:44:54','605','2021-05-11 08:23:36',10,0),('5','131',196533,'daily shift       ','2021-05-10','2021-05-10 00:00:00',NULL,'475',800024.55,800024.55,'475','2021-05-11 10:43:11','605','2021-05-11 18:35:22',10,0),('5','131',196738,'daily shift       ','2021-05-11','2021-05-11 00:00:00',NULL,'475',643069.55,643069.55,'475','2021-05-12 10:23:20','605','2021-05-12 13:58:02',10,0),('5','131',196834,'daily shift       ','2021-05-12','2021-05-12 00:00:00',NULL,'475',425908.70,425908.70,'475','2021-05-12 17:44:27','605','2021-05-14 05:07:29',10,0),('5','131',197048,'daily shift       ','2021-05-14','2021-05-14 00:00:00',NULL,'475',303013.00,303013.00,'475','2021-05-14 20:29:50','605','2021-05-16 08:44:59',10,0),('5','131',197432,'Daily Shift ','2021-05-15','2021-05-15 00:00:00',NULL,'475',826415.35,826415.35,'600','2021-05-16 15:52:30','605','2021-05-17 12:11:32',10,0),('5','131',197713,'Daily Shift ','2021-05-16','2021-05-16 00:00:00',NULL,'475',1148738.45,1148738.45,'475','2021-05-17 13:29:48','605','2021-05-18 06:03:29',10,0),('5','131',198305,'Daily Shift ','2021-05-18','2021-05-18 00:00:00',NULL,'628',239817.70,239920.50,'628','2021-05-19 17:07:06','605','2021-05-19 17:13:00',10,0),('5','131',198308,'Daily Shift ','2021-05-19','2021-05-19 00:00:00',NULL,'628',589091.95,590374.20,'628','2021-05-20 08:26:12','605','2021-05-20 08:28:38',10,0),('5','131',198511,'Daily Shift ','2021-05-20','2021-05-20 00:00:00',NULL,'628',878203.95,881712.00,'628','2021-05-21 09:36:24','605','2021-05-21 15:29:33',10,0),('5','131',198760,'Daily Shift ','2021-05-21','2021-05-21 00:00:00',NULL,'628',737114.65,612607.05,'628','2021-05-23 09:37:27','605','2021-05-23 19:36:44',10,0),('5','131',199184,'Daily Shift ','2021-05-22','2021-05-22 00:00:00',NULL,'628',562284.30,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','131',199269,'Daily shift ','2021-05-22','2021-05-22 00:00:00',NULL,'628',564655.05,564655.05,'628','2021-05-24 08:35:08','605','2021-05-24 08:39:19',10,0),('5','131',199282,'Daily Shift ','2021-05-23','2021-05-23 00:00:00',NULL,'628',784302.00,784302.00,'628','2021-05-24 08:45:13','605','2021-05-24 08:46:57',10,0),('5','131',199285,'Daily Shift ','2021-05-24','2021-05-24 00:00:00',NULL,'628',944656.65,944656.65,'628','2021-05-25 12:30:16','605','2021-05-25 12:35:23',10,0),('5','131',199553,'Daily Shift ','2021-05-25','2021-05-25 00:00:00',NULL,'628',904933.65,904933.65,'628','2021-05-25 18:33:24','605','2021-05-26 04:47:16',10,0),('5','131',199758,'Daily Shift ','2021-05-26','2021-05-26 00:00:00',NULL,'628',942731.25,942731.25,'628','2021-05-26 22:47:25','605','2021-05-27 04:26:25',10,0),('5','131',199903,'Daily Shift ','2021-05-27','2021-05-27 00:00:00',NULL,'628',575126.10,575126.10,'628','2021-05-27 18:51:52','605','2021-05-28 05:51:37',10,0),('5','131',200098,'Daily Shift ','2021-05-28','2021-05-28 00:00:00',NULL,'628',1043620.95,1043620.95,'628','2021-05-28 18:57:02','605','2021-05-29 08:41:59',10,0),('5','131',200344,'Daily Shift ','2021-05-29','2021-05-29 00:00:00',NULL,'628',1063752.75,1063752.75,'628','2021-05-30 16:59:44','605','2021-05-31 08:27:35',10,0),('5','131',200745,'Daily Shift ','2021-05-30','2021-05-30 00:00:00',NULL,'628',987567.30,987567.30,'628','2021-05-31 08:47:27','605','2021-05-31 13:23:59',10,0),('5','131',200841,'Daily Shift ','2021-05-31','2021-05-31 00:00:00',NULL,'628',996202.95,996202.95,'628','2021-05-31 19:20:40','605','2021-06-01 04:37:27',10,0),('5','131',200915,'Daily Shift ','2021-06-01','2021-06-01 00:00:00',NULL,'628',887329.35,887329.35,'628','2021-06-01 18:29:19','605','2021-06-02 06:08:11',10,0),('5','131',201193,'Daily Shift ','2021-06-02','2021-06-02 00:00:00',NULL,'628',1066552.50,1066552.50,'628','2021-06-02 20:39:45','605','2021-06-03 05:10:01',10,0),('5','131',201316,'Daily Shift ','2021-06-03','2021-06-03 00:00:00',NULL,'628',842454.45,842454.45,'628','2021-06-04 06:20:25','605','2021-06-04 09:01:33',10,0),('5','131',201713,'Daily Shift ','2021-06-04','2021-06-04 00:00:00',NULL,'628',903125.40,903125.40,'628','2021-06-04 19:25:06','605','2021-06-05 07:46:23',10,0),('5','131',202009,'Daily Shift ','2021-06-05','2021-06-05 00:00:00',NULL,'628',922791.65,922791.65,'628','2021-06-05 21:45:28','605','2021-06-06 06:35:39',10,0),('5','131',202041,'Daily Shift ','2021-06-06','2021-06-06 00:00:00',NULL,'628',858310.75,858310.75,'628','2021-06-06 21:25:03','605','2021-06-06 21:45:08',10,0),('5','131',202407,'Daily Shift ','2021-06-07','2021-06-07 00:00:00',NULL,'628',843108.20,843108.20,'628','2021-06-07 22:19:56','605','2021-06-08 05:04:50',10,0),('5','131',202420,'Daily Shift ','2021-06-08','2021-06-08 00:00:00',NULL,'628',934547.90,934547.90,'628','2021-06-08 20:40:26','605','2021-06-08 21:37:07',10,0),('5','131',202643,'Daily Shift ','2021-06-09','2021-06-09 00:00:00',NULL,'628',919977.85,919977.85,'628','2021-06-09 19:15:41','605','2021-06-10 04:49:50',10,0),('5','131',202880,'Daily Shift ','2021-06-10','2021-06-10 00:00:00',NULL,'628',703460.45,703460.45,'628','2021-06-10 22:41:43','605','2021-06-11 08:15:33',10,0),('5','131',203188,'Daily Shift ','2021-06-11','2021-06-11 00:00:00',NULL,'628',949812.05,949812.05,'628','2021-06-11 19:23:30','605','2021-06-12 02:33:46',10,0),('5','131',203293,'Daily Shift ','2021-06-12','2021-06-12 00:00:00',NULL,'628',916186.15,916186.15,'628','2021-06-12 18:55:15','605','2021-06-12 23:44:03',10,0),('5','131',203513,'Daily Shift ','2021-06-13','2021-06-13 00:00:00',NULL,'628',873619.45,873619.45,'628','2021-06-13 19:05:48','605','2021-06-13 22:01:06',10,0),('5','131',203714,'Daily Shift ','2021-06-14','2021-06-14 00:00:00',NULL,'628',925395.35,925395.35,'628','2021-06-14 21:47:08','605','2021-06-15 04:27:45',10,0),('5','131',203992,'Daily Shift ','2021-06-15','2021-06-15 00:00:00',NULL,'628',742920.20,742920.20,'628','2021-06-15 18:34:31','605','2021-06-16 04:47:14',10,0),('5','131',204180,'Daily Shift ','2021-06-16','2021-06-16 00:00:00',NULL,'628',850961.10,850961.10,'628','2021-06-16 18:47:29','605','2021-06-17 06:18:25',10,0),('5','131',204431,'Daily Shift ','2021-06-17','2021-06-17 00:00:00',NULL,'628',830495.60,830495.60,'628','2021-06-17 19:51:43','605','2021-06-17 22:21:58',10,0),('5','131',204601,'Daily Shift ','2021-06-18','2021-06-18 00:00:00',NULL,'628',901605.65,901605.65,'628','2021-06-18 21:27:14','605','2021-06-18 22:45:25',10,0),('5','131',204853,'Daily Shift ','2021-06-19','2021-06-19 00:00:00',NULL,'628',648194.25,648194.25,'628','2021-06-19 17:55:24','605','2021-06-19 18:20:50',10,0),('5','131',205088,'Daily Shift ','2021-06-20','2021-06-20 00:00:00',NULL,'628',666583.50,666583.50,'628','2021-06-20 18:24:47','605','2021-06-21 07:21:32',10,0),('5','131',205290,'Daily Shift ','2021-06-21','2021-06-21 00:00:00',NULL,'628',799822.65,799822.65,'628','2021-06-21 18:48:41','605','2021-06-22 08:44:37',10,0),('5','131',205532,'Daily Shift ','2021-06-22','2021-06-22 00:00:00',NULL,'628',621431.25,621431.25,'628','2021-06-23 07:48:06','605','2021-06-23 11:14:40',10,0),('5','131',205879,'Daily Shift ','2021-06-23','2021-06-23 00:00:00',NULL,'628',773378.10,773378.10,'628','2021-06-23 19:04:05','605','2021-06-24 05:38:28',10,0),('5','131',205942,'Daily Shift ','2021-06-24','2021-06-24 00:00:00',NULL,'628',800197.20,800197.20,'628','2021-06-24 18:33:31','605','2021-06-25 09:10:16',10,0),('5','131',206207,'Daily Shift ','2021-06-25','2021-06-25 00:00:00',NULL,'628',937996.95,937996.95,'628','2021-06-25 19:02:58','605','2021-06-26 06:20:25',10,0),('5','131',206596,'Daily Shift ','2021-06-26','2021-06-26 00:00:00',NULL,'628',1049050.20,1049050.20,'628','2021-06-27 07:53:46','605','2021-06-27 10:26:03',10,0),('5','131',206646,'Daily Shift ','2021-06-27','2021-06-27 00:00:00',NULL,'628',748799.70,748799.70,'628','2021-06-27 19:00:21','605','2021-06-27 22:33:13',10,0),('5','131',206781,'Daily Shift ','2021-06-28','2021-06-28 00:00:00',NULL,'628',718563.45,718563.45,'628','2021-06-29 08:24:19','605','2021-06-29 08:31:37',10,0),('5','131',207102,'Daily Shift ','2021-06-29','2021-06-29 00:00:00',NULL,'628',258861.90,258861.90,'628','2021-06-29 22:35:07','605','2021-06-30 04:39:35',10,0),('5','131',207325,'Daily Shift ','2021-06-30','2021-06-30 00:00:00',NULL,'628',0.00,0.00,'628','2021-06-30 18:37:47','605','2021-07-01 07:15:25',10,0),('5','131',207666,'Daily Shift ','2021-07-01','2021-07-01 00:00:00',NULL,'628',344978.70,344978.70,'628','2021-07-01 18:48:38','605','2021-07-01 18:59:46',10,0),('5','131',207713,'Daily Shift ','2021-07-02','2021-07-02 00:00:00',NULL,'628',730347.75,730347.75,'628','2021-07-02 21:49:53','605','2021-07-03 04:29:13',10,0),('5','131',208224,'Daily Shift ','2021-07-03','2021-07-03 00:00:00',NULL,'628',780709.05,780709.05,'628','2021-07-04 13:07:02','605','2021-07-04 16:54:40',10,0),('5','131',208300,'Daily Shift ','2021-07-04','2021-07-04 00:00:00',NULL,'628',660513.15,660513.15,'628','2021-07-04 20:37:47','605','2021-07-05 06:42:06',10,0),('5','131',208451,'Daily Shift ','2021-07-05','2021-07-05 00:00:00',NULL,'628',784327.50,784327.50,'628','2021-07-05 19:53:17','605','2021-07-05 20:59:19',10,0),('5','131',208664,'Daily Shift ','2021-07-06','2021-07-06 00:00:00',NULL,'628',711862.80,711862.80,'628','2021-07-07 07:04:01','605','2021-07-07 08:04:38',10,0),('5','131',208876,'Daily Shift ','2021-07-07','2021-07-07 00:00:00',NULL,'628',694514.70,694514.70,'628','2021-07-07 20:27:58','605','2021-07-08 05:21:12',10,0),('5','131',209084,'Daily Shift ','2021-07-08','2021-07-08 00:00:00',NULL,'628',502660.95,502660.95,'628','2021-07-08 19:36:08','605','2021-07-09 09:08:52',10,0),('5','131',209399,'Daily Shift ','2021-07-09','2021-07-09 00:00:00',NULL,'628',669852.15,669852.15,'628','2021-07-09 18:49:52','605','2021-07-10 05:22:03',10,0),('5','131',209621,'Daily Shift ','2021-07-10','2021-07-10 00:00:00',NULL,'628',884657.40,884657.40,'628','2021-07-10 20:25:37','605','2021-07-11 05:38:51',10,0),('5','131',209844,'Daily Shift ','2021-07-11','2021-07-11 00:00:00',NULL,'628',877062.45,877062.45,'628','2021-07-11 21:53:55','605','2021-07-12 05:15:11',10,0),('5','131',210080,'Daily Shift ','2021-07-12','2021-07-12 00:00:00',NULL,'628',716621.35,716621.35,'628','2021-07-12 21:01:22','605','2021-07-13 04:28:41',10,0),('5','131',210261,'Daily Shift ','2021-07-13','2021-07-13 00:00:00',NULL,'628',701959.50,701959.50,'628','2021-07-13 18:45:08','605','2021-07-14 04:32:54',10,0),('5','131',210386,'Daily Shift ','2021-07-14','2021-07-14 00:00:00',NULL,'628',726253.02,726253.02,'628','2021-07-14 18:41:27','605','2021-07-15 07:56:46',10,0),('5','131',210626,'Daily Shift ','2021-07-15','2021-07-15 00:00:00',NULL,'628',660688.05,652679.71,'628','2021-07-15 18:46:08','605','2021-07-15 19:55:38',10,0),('5','131',210849,'Daily Shift ','2021-07-16','2021-07-16 00:00:00',NULL,'628',641371.50,633597.30,'628','2021-07-16 18:44:05','605','2021-07-17 05:57:40',10,0),('5','131',210945,'Daily Shift ','2021-07-17','2021-07-17 00:00:00',NULL,'628',556132.50,549391.50,'628','2021-07-17 18:49:35','605','2021-07-17 22:25:51',10,0),('5','131',211344,'Daily Shift ','2021-07-18','2021-07-18 00:00:00',NULL,'628',806421.00,796646.20,'628','2021-07-18 19:47:08','605','2021-07-19 08:35:19',10,0),('5','131',211445,'Daily Shift ','2021-07-19','2021-07-19 00:00:00',NULL,'628',1023363.00,1010958.60,'628','2021-07-19 21:40:20','605','2021-07-19 22:07:40',10,0),('5','131',211744,'Daily Shift ','2021-07-20','2021-07-20 00:00:00',NULL,'628',442186.80,436826.96,'628','2021-07-20 19:48:52','605','2021-07-21 05:37:08',10,0),('5','131',211791,'Daily Shift ','2021-07-21','2021-07-21 00:00:00',NULL,'628',700832.55,692337.61,'628','2021-07-21 22:49:43','605','2021-07-22 08:53:30',10,0),('5','131',212172,'Daily Shift ','2021-07-22','2021-07-22 00:00:00',NULL,'628',671536.80,663396.96,'628','2021-07-22 19:10:15','605','2021-07-22 22:11:43',10,0),('5','131',212435,'Daily Shift ','2021-07-23','2021-07-23 00:00:00',NULL,'628',570801.00,563882.20,'628','2021-07-23 20:29:23','605','2021-07-24 06:31:59',10,0),('5','131',212472,'Daily Shift ','2021-07-24','2021-07-24 00:00:00',NULL,'628',272144.40,268845.68,'628','2021-07-24 18:31:54','605','2021-07-25 06:26:52',10,0),('5','131',212750,'Daily Shift ','2021-07-25','2021-07-25 00:00:00',NULL,'628',625696.50,618112.30,'628','2021-07-25 19:48:30','605','2021-07-26 04:54:07',10,0),('5','131',212866,'Daily Shift ','2021-07-26','2021-07-26 00:00:00',NULL,'628',425665.35,420505.77,'628','2021-07-26 18:33:59','605','2021-07-27 05:11:55',10,0),('5','131',213199,'Daily Shift ','2021-07-27','2021-07-27 00:00:00',NULL,'628',633159.45,625484.79,'628','2021-07-27 18:41:24','605','2021-07-27 22:13:06',10,0),('5','131',213520,'Daily Shift ','2021-07-28','2021-07-28 00:00:00',NULL,'628',599235.45,591971.99,'628','2021-07-28 18:44:08','605','2021-07-29 04:44:54',10,0),('5','131',213751,'Daily Shift ','2021-07-29','2021-07-29 00:00:00',NULL,'628',846207.45,835950.39,'628','2021-07-30 12:07:10','605','2021-07-31 15:40:12',10,0),('5','131',214255,'Daily Shift ','2021-07-30','2021-07-30 00:00:00',NULL,'628',753976.06,753976.06,'628','2021-07-31 15:42:32','605','2021-07-31 15:44:33',10,0),('5','131',214257,'Daily Shift ','2021-07-31','2021-07-31 00:00:00',NULL,'628',918560.42,918560.42,'628','2021-07-31 18:35:28','605','2021-08-01 06:26:53',10,0),('5','131',214348,'Daily Shift ','2021-08-01','2021-08-01 00:00:00',NULL,'628',699152.64,699152.64,'628','2021-08-01 18:32:18','605','2021-08-02 06:16:13',10,0),('5','131',214598,'Daily Shift ','2021-08-02','2021-08-02 00:00:00',NULL,'628',717040.26,717040.26,'628','2021-08-02 18:45:25','605','2021-08-03 08:16:22',10,0),('5','131',214822,'Daily Shift ','2021-08-03','2021-08-03 00:00:00',NULL,'628',670006.61,670006.61,'628','2021-08-03 19:16:27','605','2021-08-03 20:49:40',10,0),('5','131',215111,'Daily Shift ','2021-08-04','2021-08-04 00:00:00',NULL,'628',633967.31,633967.31,'628','2021-08-04 19:40:01','605','2021-08-05 05:45:04',10,0),('5','131',215372,'Daily Shift ','2021-08-05','2021-08-05 00:00:00',NULL,'628',678094.67,678094.67,'628','2021-08-05 18:47:00','605','2021-08-06 00:11:40',10,0),('5','131',215608,'Daily Shift ','2021-08-06','2021-08-06 00:00:00',NULL,'628',567202.51,567202.51,'628','2021-08-06 18:39:44','605','2021-08-07 04:58:07',10,0),('5','131',215710,'Daily Shift ','2021-08-07','2021-08-07 00:00:00',NULL,'628',449457.83,449457.83,'628','2021-08-07 22:12:40','605','2021-08-08 06:20:46',10,0),('5','131',215945,'Daily Shift ','2021-08-08','2021-08-08 00:00:00',NULL,'628',340451.58,340451.58,'628','2021-08-09 09:14:10','605','2021-08-10 05:42:23',10,0),('5','131',216313,'Daily Shift ','2021-08-09','2021-08-09 00:00:00',NULL,'628',783816.47,783816.47,'628','2021-08-10 11:41:19','605','2021-08-11 05:31:28',10,0),('5','131',216544,'Daily Shift ','2021-08-10','2021-08-10 00:00:00',NULL,'628',655199.69,655199.69,'628','2021-08-11 05:55:45','605','2021-08-12 05:15:57',10,0),('5','131',216777,'Daily Shift ','2021-08-11','2021-08-11 00:00:00',NULL,'628',618588.26,618588.26,'628','2021-08-12 05:45:59','605','2021-08-13 06:33:57',10,0),('5','131',217047,'Daily Shift ','2021-08-12','2021-08-12 00:00:00',NULL,'628',29579.61,29579.61,'628','2021-08-13 08:12:25','605','2021-08-13 10:47:26',10,0),('5','131',217127,'Daily Shift ','2021-08-13','2021-08-13 00:00:00',NULL,'628',787743.14,787743.14,'628','2021-08-13 19:50:02','605','2021-08-14 06:51:19',10,0),('5','131',217301,'Daily Shift ','2021-08-14','2021-08-14 00:00:00',NULL,'628',909269.42,909269.42,'628','2021-08-14 18:46:29','605','2021-08-15 18:18:28',10,0),('5','131',217666,'Daily Shift ','2021-08-15','2021-08-15 00:00:00',NULL,'628',754605.24,754605.24,'628','2021-08-15 19:43:06','605','2021-08-15 21:02:58',10,0),('5','131',217727,'Daily Shift ','2021-08-16','2021-08-16 00:00:00',NULL,'628',750905.14,750905.14,'628','2021-08-16 18:11:37','605','2021-08-16 22:43:35',10,0),('5','131',218020,'Daily Shift ','2021-08-17','2021-08-17 00:00:00',NULL,'628',640277.04,640277.04,'628','2021-08-17 18:35:46','605','2021-08-18 05:50:52',10,0),('5','131',218317,'Daily Shift ','2021-08-18','2021-08-18 00:00:00',NULL,'628',683602.44,683602.44,'628','2021-08-18 19:31:38','605','2021-08-19 04:36:27',10,0),('5','131',218467,'Daily Shift ','2021-08-19','2021-08-19 00:00:00',NULL,'628',791845.85,791845.85,'628','2021-08-19 18:29:07','605','2021-08-20 05:21:11',10,0),('5','131',218686,'Daily Shift ','2021-08-20','2021-08-20 00:00:00',NULL,'628',793779.03,793779.03,'628','2021-08-20 18:32:56','605','2021-08-21 05:09:36',10,0),('5','131',218910,'Daily Shift ','2021-08-21','2021-08-21 00:00:00',NULL,'628',598984.25,598984.25,'628','2021-08-21 17:26:12','605','2021-08-21 19:18:08',10,0),('5','131',219114,'Daily Shift ','2021-08-22','2021-08-22 00:00:00',NULL,'628',1149073.39,1149073.39,'628','2021-08-22 19:40:39','605','2021-08-23 06:24:55',10,0),('5','131',219380,'Daily Shift ','2021-08-23','2021-08-23 00:00:00',NULL,'628',643783.17,643783.17,'628','2021-08-23 18:36:00','605','2021-08-23 22:30:43',10,0),('5','131',219657,'Daily Shift ','2021-08-24','2021-08-24 00:00:00',NULL,'628',752293.90,752293.90,'628','2021-08-25 04:46:05','605','2021-08-25 06:11:24',10,0),('5','131',219809,'Daily Shift ','2021-08-25','2021-08-25 00:00:00',NULL,'628',777863.71,777863.71,'628','2021-08-25 18:43:59','605','2021-08-25 21:30:08',10,0),('5','131',220044,'Daily Shift ','2021-08-26','2021-08-26 00:00:00',NULL,'628',892765.67,892765.67,'628','2021-08-26 18:55:06','605','2021-08-27 06:56:36',10,0),('5','131',220263,'Daily Shift ','2021-08-27','2021-08-27 00:00:00',NULL,'628',907649.20,907649.20,'628','2021-08-27 18:43:36','605','2021-08-28 06:34:42',10,0),('5','131',220499,'Daily Shift ','2021-08-28','2021-08-28 00:00:00',NULL,'628',816700.09,816700.09,'628','2021-08-28 18:35:00','605','2021-08-29 06:55:41',10,0),('5','131',220701,'Daily Shift ','2021-08-29','2021-08-29 00:00:00',NULL,'628',631724.43,631724.43,'628','2021-08-29 18:25:41','605','2021-08-30 04:41:24',10,0),('5','131',220932,'Daily Shift ','2021-08-30','2021-08-30 00:00:00',NULL,'628',679315.54,679315.54,'628','2021-08-30 19:05:57','605','2021-08-30 21:05:14',10,0),('5','131',221146,'Daily Shift ','2021-08-31','2021-08-31 00:00:00',NULL,'628',853094.73,853094.73,'628','2021-08-31 18:48:49','605','2021-09-01 04:57:34',10,0),('5','131',221442,'Daily Shift ','2021-09-01','2021-09-01 00:00:00',NULL,'628',870604.19,870604.19,'628','2021-09-01 18:48:29','605','2021-09-02 06:26:29',10,0),('5','131',221652,'Daily Shift ','2021-09-02','2021-09-02 00:00:00',NULL,'628',943518.98,943518.98,'628','2021-09-02 19:00:54','605','2021-09-03 09:11:08',10,0),('5','131',221923,'Daily Shift ','2021-09-03','2021-09-03 00:00:00',NULL,'628',932875.08,932875.08,'628','2021-09-03 19:17:16','605','2021-09-04 08:54:11',10,0),('5','131',222183,'Daily Shift ','2021-09-04','2021-09-04 00:00:00',NULL,'628',877236.66,877236.66,'628','2021-09-04 18:31:08','605','2021-09-05 05:40:20',10,0),('5','131',222321,'Daily Shift ','2021-09-05','2021-09-05 00:00:00',NULL,'628',1046561.06,1046561.06,'628','2021-09-05 18:44:04','605','2021-09-06 04:06:50',10,0),('5','131',222629,'Daily Shift ','2021-09-06','2021-09-06 00:00:00',NULL,'628',492592.52,492592.52,'628','2021-09-06 18:47:23','605','2021-09-07 06:35:12',10,0),('5','131',222798,'Daily Shift ','2021-09-07','2021-09-07 00:00:00',NULL,'628',619706.44,619706.44,'628','2021-09-07 18:18:48','605','2021-09-08 12:14:04',10,0),('5','131',224374,'Daily Shift ','2021-09-08','2021-09-08 00:00:00',NULL,'628',0.00,0.00,'628','2021-09-14 09:04:15','664','2021-09-14 09:07:57',10,0),('5','131',224378,'Daily Shift ','2021-09-09','2021-09-09 00:00:00',NULL,'628',0.00,0.00,'628','2021-09-14 09:16:17','664','2021-09-14 15:52:58',10,0),('5','131',224511,'Daily Shift ','2021-09-10','2021-09-10 00:00:00',NULL,'628',0.00,0.00,'628','2021-09-14 21:38:23','664','2021-09-15 07:20:18',10,0),('5','131',224570,'Daily Shift ','2021-09-11','2021-09-11 00:00:00',NULL,'628',0.00,0.00,'628','2021-09-15 08:21:30','664','2021-09-15 08:41:50',10,0),('5','131',224582,'Daily Shift ','2021-09-12','2021-09-12 00:00:00',NULL,'628',0.00,0.00,'628','2021-09-15 08:43:59','664','2021-09-15 08:45:07',10,0),('5','131',224586,'Daily Shift ','2021-09-13','2021-09-13 00:00:00',NULL,'628',0.00,0.00,'628','2021-09-15 08:52:52','664','2021-09-15 08:57:43',10,0),('5','131',224596,'Daily Shift ','2021-09-14','2021-09-14 00:00:00',NULL,'628',0.00,0.00,'628','2021-09-15 09:17:43','664','2021-09-15 09:21:01',10,0),('5','131',224644,'Daily Shift ','2021-09-15','2021-09-15 00:00:00',NULL,'628',914258.85,914258.85,'628','2021-09-15 19:46:39','664','2021-09-16 05:41:36',10,0),('5','131',224860,'Daily Shift ','2021-09-16','2021-09-16 00:00:00',NULL,'628',805229.78,805229.78,'628','2021-09-17 11:42:08','664','2021-09-17 11:56:55',10,0),('5','131',225217,'Daily Shift ','2021-09-17','2021-09-17 00:00:00',NULL,'628',631528.83,631528.83,'628','2021-09-17 19:27:35','664','2021-09-17 21:49:34',10,0),('5','131',225257,'Daily Shift ','2021-09-18','2021-09-18 00:00:00',NULL,'628',526760.58,526760.58,'628','2021-09-18 18:43:58','664','2021-09-19 08:43:43',10,0),('5','131',225537,'Daily Shift ','2021-09-19','2021-09-19 00:00:00',NULL,'628',679907.23,679907.23,'628','2021-09-19 18:26:19','664','2021-09-20 07:25:26',10,0),('5','131',225843,'Daily Shift ','2021-09-20','2021-09-20 00:00:00',NULL,'628',619753.71,619753.71,'628','2021-09-20 23:33:11','664','2021-09-21 06:31:00',10,0),('5','131',226083,'Daily Shift ','2021-09-21','2021-09-21 00:00:00',NULL,'628',665512.70,665512.70,'628','2021-09-21 18:38:03','664','2021-09-21 21:40:10',10,0),('5','131',226323,'Daily Shift ','2021-09-22','2021-09-22 00:00:00',NULL,'628',616319.30,616319.30,'628','2021-09-22 21:06:04','664','2021-09-23 05:09:53',10,0),('5','131',226535,'Daily Shift ','2021-09-23','2021-09-23 00:00:00',NULL,'628',792434.28,792434.28,'628','2021-09-23 18:31:33','664','2021-09-23 20:38:14',10,0),('5','131',226751,'Daily Shift ','2021-09-24','2021-09-24 00:00:00',NULL,'628',695141.21,695141.21,'628','2021-09-24 22:03:45','664','2021-09-25 05:22:50',10,0),('5','131',226988,'Daily Shift ','2021-09-25','2021-09-25 00:00:00',NULL,'628',627895.56,627895.56,'628','2021-09-25 18:40:37','664','2021-09-26 04:37:18',10,0),('5','131',227193,'Daily Shift ','2021-09-26','2021-09-26 00:00:00',NULL,'628',518718.16,518718.16,'628','2021-09-26 18:16:44','664','2021-09-27 06:42:13',10,0),('5','131',227388,'Daily Shift ','2021-09-27','2021-09-27 00:00:00',NULL,'628',811001.61,811001.61,'628','2021-09-27 18:31:15','664','2021-09-28 06:18:26',10,0),('5','131',227617,'Daily Shift ','2021-09-28','2021-09-28 00:00:00',NULL,'628',548569.98,548569.98,'628','2021-09-29 05:10:53','664','2021-09-29 05:41:34',10,0),('5','131',227849,'Daily Shift ','2021-09-29','2021-09-29 00:00:00',NULL,'628',0.00,0.00,'628','2021-09-29 22:14:12','664','2021-10-05 17:44:37',10,0),('5','131',229385,'Daily Shift ','2021-09-30','2021-09-30 00:00:00',NULL,'628',0.00,0.00,'628','2021-10-05 19:12:34','664','2021-10-06 05:20:35',10,0),('5','131',229417,'Daily Shift ','2021-10-01','2021-10-01 00:00:00',NULL,'628',0.00,0.00,'628','2021-10-06 08:13:57','664','2021-10-06 08:38:48',10,0),('5','131',229463,'Daily Shift ','2021-10-02','2021-10-02 00:00:00',NULL,'628',0.00,0.00,'628','2021-10-06 09:02:42','600','2021-10-11 14:16:00',10,0),('5','131',230680,'Daily Shift ','2021-10-03','2021-10-03 00:00:00',NULL,'628',568964.54,568964.54,'628','2021-10-11 15:04:36','664','2021-10-11 15:08:47',10,0),('5','131',230710,'Daily Shift ','2021-10-04','2021-10-04 00:00:00',NULL,'628',530199.88,530199.88,'628','2021-10-11 15:54:33','664','2021-10-11 18:15:00',10,0),('5','131',230763,'Daily Shift ','2021-10-05','2021-10-05 00:00:00',NULL,'628',609481.45,609481.45,'628','2021-10-11 21:17:22','664','2021-10-12 06:26:31',10,0),('5','131',230821,'Daily Shift ','2021-10-06','2021-10-06 00:00:00',NULL,'628',470879.29,470879.29,'628','2021-10-12 08:13:59','664','2021-10-12 10:04:12',10,0),('5','131',230933,'Daily Shift ','2021-10-07','2021-10-07 00:00:00',NULL,'628',310638.88,310638.88,'628','2021-10-12 12:48:38','664','2021-10-12 13:18:37',10,0),('5','131',230937,'Daily Shift ','2021-10-08','2021-10-08 00:00:00',NULL,'628',0.00,0.00,'628','2021-10-12 13:21:47','664','2021-10-12 14:06:23',10,0),('5','131',230963,'Daily Shift ','2021-10-09','2021-10-09 00:00:00',NULL,'628',0.00,0.00,'628','2021-10-12 14:13:50','664','2021-10-12 20:26:33',10,0),('5','131',231048,'Daily Shift ','2021-10-10','2021-10-10 00:00:00',NULL,'628',0.00,0.00,'628','2021-10-13 04:54:44','664','2021-10-13 05:53:59',10,0),('5','131',231071,'Daily Shift ','2021-10-11','2021-10-11 00:00:00',NULL,'628',0.00,0.00,'628','2021-10-13 06:37:02','664','2021-10-13 07:40:33',10,0),('5','131',231096,'Daily Shift ','2021-10-12','2021-10-12 00:00:00',NULL,'628',916824.47,916824.47,'628','2021-10-13 07:49:51','664','2021-10-13 08:32:49',10,0),('5','131',231119,'Daily Shift ','2021-10-13','2021-10-13 00:00:00',NULL,'628',793433.47,793433.47,'628','2021-10-13 21:44:04','664','2021-10-14 05:14:33',10,0),('5','131',231363,'Daily Shift ','2021-10-14','2021-10-14 00:00:00',NULL,'628',860853.53,860853.53,'628','2021-10-15 05:03:29','664','2021-10-15 09:26:15',10,0),('5','131',231709,'Daily Shift ','2021-10-15','2021-10-15 00:00:00',NULL,'628',922223.03,922223.03,'628','2021-10-15 21:40:16','664','2021-10-16 16:32:51',10,0),('5','131',232070,'Daily Shift ','2021-10-16','2021-10-16 00:00:00',NULL,'628',797037.40,797037.40,'628','2021-10-16 20:42:12','664','2021-10-17 15:14:51',10,0),('5','131',232263,'Daily Shift ','2021-10-17','2021-10-17 00:00:00',NULL,'628',591649.25,591649.25,'628','2021-10-18 08:10:39','664','2021-10-18 08:25:12',10,0),('5','131',232392,'Daily Shift ','2021-10-18','2021-10-18 00:00:00',NULL,'628',675115.03,675115.03,'628','2021-10-18 18:26:15','664','2021-10-19 05:06:01',10,0),('5','131',232669,'Daily Shift ','2021-10-19','2021-10-19 00:00:00',NULL,'628',694552.78,694552.78,'628','2021-10-19 18:17:44','664','2021-10-20 08:24:20',10,0),('5','131',232911,'Daily Shift ','2021-10-20','2021-10-20 00:00:00',NULL,'628',627703.22,627703.22,'628','2021-10-20 17:54:48','664','2021-10-21 06:39:05',10,0),('5','131',233127,'Daily Shift ','2021-10-21','2021-10-21 00:00:00',NULL,'628',415627.18,415627.18,'628','2021-10-22 04:20:13','664','2021-10-22 08:48:36',10,0),('5','131',233432,'Daily Shift ','2021-10-22','2021-10-22 00:00:00',NULL,'628',942951.74,942951.74,'628','2021-10-22 18:21:47','664','2021-10-23 04:04:48',10,0),('5','131',233688,'Daily Shift ','2021-10-23','2021-10-23 00:00:00',NULL,'628',890915.62,890915.62,'628','2021-10-24 05:31:48','664','2021-10-24 06:48:21',10,0),('5','131',233994,'Daily Shift ','2021-10-24','2021-10-24 00:00:00',NULL,'628',874552.05,874552.05,'628','2021-10-24 18:39:13','664','2021-10-25 13:14:54',10,0),('5','131',234480,'Daily Shift ','2021-10-25','2021-10-25 00:00:00',NULL,'628',809979.60,809979.60,'628','2021-10-26 14:03:42','664','2021-10-26 15:29:16',10,0),('5','131',234512,'Daily Shift ','2021-10-26','2021-10-26 00:00:00',NULL,'628',71154.39,72027.45,'628','2021-10-26 17:16:02','664','2021-10-27 06:13:46',10,0),('5','131',234636,'Daily Shift ','2021-10-27','2021-10-27 00:00:00',NULL,'628',0.00,0.00,'628','2021-10-27 20:35:03','664','2021-10-29 04:39:14',10,0),('5','131',235081,'Daily Shift ','2021-10-28','2021-10-28 00:00:00',NULL,'628',0.00,0.00,'628','2021-10-29 06:25:31','664','2021-10-29 21:58:19',10,0),('5','131',235335,'Daily Shift ','2021-10-29','2021-10-29 00:00:00',NULL,'628',0.00,0.00,'628','2021-10-30 07:20:09','664','2021-10-30 16:53:17',10,0),('5','131',235533,'Daily Shift ','2021-10-30','2021-10-30 00:00:00',NULL,'628',0.00,0.00,'628','2021-10-31 06:03:34','664','2021-10-31 08:48:43',10,0),('5','131',235673,'Daily Shift ','2021-10-31','2021-10-31 00:00:00',NULL,'628',1526961.15,1526961.15,'628','2021-10-31 19:25:12','664','2021-11-01 11:30:07',10,0),('5','131',235928,'Daily Shift ','2021-11-01','2021-11-01 00:00:00',NULL,'628',1284496.95,1284496.95,'628','2021-11-01 18:20:03','664','2021-11-03 05:00:11',10,0),('5','131',236352,'Daily Shift ','2021-11-02','2021-11-02 00:00:00',NULL,'628',1293408.60,1293408.60,'628','2021-11-03 10:51:48','664','2021-11-03 17:52:30',10,0),('5','131',236461,'Daily Shift ','2021-11-03','2021-11-03 00:00:00',NULL,'628',853924.50,853924.50,'628','2021-11-04 07:46:52','664','2021-11-04 18:06:46',10,0),('5','131',236802,'Daily Shift ','2021-11-04','2021-11-04 00:00:00',NULL,'628',0.00,0.00,'628','2021-11-05 08:50:31','664','2021-11-05 15:12:24',10,0),('5','131',236895,'Daily Shift ','2021-11-05','2021-11-05 00:00:00',NULL,'628',0.00,0.00,'628','2021-11-05 16:50:07','664','2021-11-06 06:38:06',10,0),('5','131',237082,'Daily Shift ','2021-11-06','2021-11-06 00:00:00',NULL,'628',0.00,0.00,'628','2021-11-06 13:36:02','664','2021-11-07 07:09:57',10,0),('5','131',237257,'Daily Shift ','2021-11-07','2021-11-07 00:00:00',NULL,'628',0.00,0.00,'628','2021-11-08 08:22:22','664','2021-11-08 21:42:13',10,0),('5','131',237599,'Daily Shift ','2021-11-08','2021-11-08 00:00:00',NULL,'628',0.00,0.00,'628','2021-11-09 05:20:51','664','2021-11-09 10:51:25',10,0),('5','131',237714,'Daily Shift ','2021-11-09','2021-11-09 00:00:00',NULL,'628',0.00,0.00,'628','2021-11-09 15:52:50','664','2021-11-09 18:34:39',10,0),('5','131',237861,'Daily Shift ','2021-11-10','2021-11-10 00:00:00',NULL,'628',0.00,0.00,'628','2021-11-10 20:24:10','664','2021-11-11 09:43:20',10,0),('5','131',238232,'Daily Shift ','2021-11-11','2021-11-11 00:00:00',NULL,'628',110518.65,110518.65,'628','2021-11-12 13:35:04','664','2021-11-13 05:53:23',10,0),('5','131',238611,'Daily Shift ','2021-11-12','2021-11-12 00:00:00',NULL,'628',929684.25,929684.25,'628','2021-11-13 06:16:22','664','2021-11-14 09:02:14',10,0),('5','131',238903,'Daily Shift ','2021-11-13','2021-11-13 00:00:00',NULL,'628',930585.15,930585.15,'628','2021-11-14 10:13:23','664','2021-11-15 07:24:03',10,0),('5','131',239113,'Daily Shift ','2021-11-14','2021-11-14 00:00:00',NULL,'628',338987.55,338987.55,'628','2021-11-15 07:46:05','664','2021-11-16 08:08:06',10,0),('5','131',239356,'Daily Shift ','2021-11-15','2021-11-15 00:00:00',NULL,'628',65917.50,65917.50,'628','2021-11-16 08:47:05','664','2021-11-17 05:38:50',10,0),('5','131',239550,'Daily Shift ','2021-11-16','2021-11-16 00:00:00',NULL,'628',0.00,0.00,'628','2021-11-17 06:53:04','664','2021-11-17 18:25:25',10,0),('5','131',239750,'Daily Shift ','2021-11-17','2021-11-17 00:00:00',NULL,'628',0.00,0.00,'628','2021-11-18 04:52:44','664','2021-11-18 06:24:33',10,0),('5','131',239795,'Daily Shift ','2021-11-18','2021-11-18 00:00:00',NULL,'628',0.00,0.00,'628','2021-11-18 20:14:25','664','2021-11-19 04:42:02',10,0),('5','131',239979,'Daily Shift ','2021-11-19','2021-11-19 00:00:00',NULL,'628',469566.90,469566.90,'628','2021-11-19 18:01:56','664','2021-11-20 06:37:43',10,0),('5','131',240222,'Daily Shift ','2021-11-20','2021-11-20 00:00:00',NULL,'628',1174809.90,1174809.90,'628','2021-11-20 18:15:50','664','2021-11-20 20:42:37',10,0),('5','131',240446,'Daily Shift ','2021-11-21','2021-11-21 00:00:00',NULL,'628',504584.85,504584.85,'628','2021-11-21 16:24:15','664','2021-11-22 06:20:00',10,0),('5','131',240709,'Daily Shift ','2021-11-22','2021-11-22 00:00:00',NULL,'628',53662.95,53662.95,'628','2021-11-23 05:36:24','664','2021-11-23 05:37:13',10,0),('5','131',240968,'Daily Shift ','2021-11-23','2021-11-23 00:00:00',NULL,'628',1287107.25,1287107.25,'628','2021-11-23 18:13:52','664','2021-11-24 07:04:35',10,0),('5','131',241297,'Daily Shift ','2021-11-24','2021-11-24 00:00:00',NULL,'628',1517827.58,1517827.58,'628','2021-11-24 17:24:14','664','2021-11-25 05:53:04',10,0),('5','131',241492,'Daily Shift ','2021-11-25','2021-11-25 00:00:00',NULL,'628',1686476.55,1686476.55,'628','2021-11-25 19:54:14','664','2021-11-26 05:57:39',10,0),('5','131',241740,'Daily Shift ','2021-11-26','2021-11-26 00:00:00',NULL,'628',1312637.70,1312637.70,'628','2021-11-26 18:08:23','664','2021-11-27 06:12:02',10,0),('5','131',242022,'Daily Shift ','2021-11-27','2021-11-27 00:00:00',NULL,'628',1240900.65,1240900.65,'628','2021-11-27 17:57:59','664','2021-11-28 07:30:51',10,0),('5','131',242239,'Daily Shift ','2021-11-28','2021-11-28 00:00:00',NULL,'628',285331.20,285331.20,'628','2021-11-28 19:34:45','664','2021-11-29 04:58:03',10,0),('5','131',242515,'Daily Shift ','2021-11-29','2021-11-29 00:00:00',NULL,'628',0.00,0.00,'628','2021-11-29 20:04:36','664','2021-11-30 06:53:52',10,0),('5','131',242772,'Daily Shift ','2021-11-30','2021-11-30 00:00:00',NULL,'628',0.00,0.00,'628','2021-11-30 21:16:59','664','2021-12-01 05:25:43',10,0),('5','131',242963,'Daily Shift ','2021-12-01','2021-12-01 00:00:00',NULL,'628',0.00,0.00,'628','2021-12-01 18:57:39','664','2021-12-01 20:00:51',10,0),('5','131',243162,'Daily Shift ','2021-12-02','2021-12-02 00:00:00',NULL,'628',1022749.20,1022749.20,'628','2021-12-02 18:12:26','664','2021-12-03 05:33:59',10,0),('5','131',243423,'Daily Shift ','2021-12-03','2021-12-03 00:00:00',NULL,'628',1561797.60,1561797.60,'628','2021-12-04 05:05:06','664','2021-12-04 17:39:52',10,0),('5','131',243797,'Daily Shift ','2021-12-04','2021-12-04 00:00:00',NULL,'628',1741352.25,1741352.25,'628','2021-12-07 06:13:23','664','2021-12-07 06:15:56',10,0),('5','131',244309,'Daily Shift ','2021-12-05','2021-12-05 00:00:00',NULL,'628',580242.30,580242.30,'628','2021-12-07 06:50:37','664','2021-12-07 16:19:12',10,0),('5','131',244498,'Daily Shift ','2021-12-06','2021-12-06 00:00:00',NULL,'628',0.00,0.00,'628','2021-12-08 04:43:39','664','2021-12-08 07:06:46',10,0),('5','131',244569,'Daily Shift ','2021-12-07','2021-12-07 00:00:00',NULL,'628',389706.90,389706.90,'628','2021-12-08 08:02:33','664','2021-12-08 13:09:44',10,0),('5','131',244683,'Daily Shift ','2021-12-08','2021-12-08 00:00:00',NULL,'628',1602654.90,1602654.90,'628','2021-12-08 18:26:08','664','2021-12-09 08:26:09',10,0),('5','131',244811,'Daily Shift ','2021-12-09','2021-12-09 00:00:00',NULL,'628',1996039.65,1996039.65,'628','2021-12-09 18:43:38','664','2021-12-10 09:22:03',10,0),('5','131',245068,'Daily Shift ','2021-12-10','2021-12-10 00:00:00',NULL,'628',1405958.40,1405958.40,'628','2021-12-11 05:01:39','664','2021-12-11 17:29:20',10,0),('5','131',245401,'Daily Shift ','2021-12-11','2021-12-11 00:00:00',NULL,'628',1158309.90,1158309.90,'628','2021-12-11 20:12:02','664','2021-12-11 20:37:06',10,0),('5','131',245620,'Daily Shift ','2021-12-12','2021-12-12 00:00:00',NULL,'628',0.00,0.00,'628','2021-12-12 18:52:11','664','2021-12-13 11:11:50',10,0),('5','131',246052,'Daily Shift ','2021-12-13','2021-12-13 00:00:00',NULL,'628',0.00,0.00,'628','2021-12-14 12:38:44','664','2021-12-14 14:35:18',10,0),('5','131',246178,'Daily Shift ','2021-12-14','2021-12-14 00:00:00',NULL,'628',0.00,0.00,'628','2021-12-15 05:32:41','664','2021-12-15 09:02:49',10,0),('5','131',246328,'Daily Shift ','2021-12-15','2021-12-15 00:00:00',NULL,'628',0.00,0.00,'628','2021-12-15 19:24:46','664','2021-12-16 08:39:45',10,0),('5','131',246519,'Daily Shift ','2021-12-16','2021-12-16 00:00:00',NULL,'628',0.00,0.00,'628','2021-12-16 20:16:44','664','2021-12-17 09:09:56',10,0),('5','131',246789,'Daily Shift ','2021-12-17','2021-12-17 00:00:00',NULL,'628',847327.80,847327.80,'628','2021-12-18 08:43:06','664','2021-12-19 17:33:20',10,0),('5','131',247352,'Daily Shift ','2021-12-18','2021-12-18 00:00:00',NULL,'628',1400584.35,1400584.35,'628','2021-12-19 18:58:12','664','2021-12-20 06:12:32',10,0),('5','131',247422,'Daily Shift ','2021-12-19','2021-12-19 00:00:00',NULL,'628',1623849.15,1623849.15,'628','2021-12-20 06:49:31','664','2021-12-20 18:03:32',10,0),('5','131',248082,'Daily Shift ','2021-12-20','2021-12-20 00:00:00',NULL,'628',863152.95,863152.95,'628','2021-12-22 17:21:11','664','2021-12-23 04:54:46',10,0),('5','131',248234,'Daily Shift ','2021-12-21','2021-12-21 00:00:00',NULL,'628',149999.85,149999.85,'628','2021-12-23 09:26:54','664','2021-12-23 09:42:40',10,0),('5','131',248267,'Daily Shift ','2021-12-22','2021-12-22 00:00:00',NULL,'628',0.00,0.00,'628','2021-12-23 12:06:53','664','2021-12-24 14:08:30',10,0),('5','131',248527,'Daily Shift ','2021-12-23','2021-12-23 00:00:00',NULL,'628',0.00,0.00,'628','2021-12-24 14:12:47','664','2021-12-25 17:06:20',10,0),('5','131',248872,'Daily Shift ','2021-12-24','2021-12-24 00:00:00',NULL,'628',0.00,0.00,'628','2021-12-26 06:22:46','664','2021-12-26 07:24:52',10,0),('5','131',248972,'Daily Shift ','2021-12-25','2021-12-25 00:00:00',NULL,'628',0.00,0.00,'628','2021-12-26 12:26:02','664','2021-12-27 05:57:54',10,0),('5','131',249119,'Daily Shift ','2021-12-26','2021-12-26 00:00:00',NULL,'628',0.00,0.00,'628','2021-12-27 06:30:18','664','2021-12-28 09:21:26',10,0),('5','131',249498,'Daily Shift ','2021-12-27','2021-12-27 00:00:00',NULL,'628',0.00,0.00,'628','2021-12-28 14:12:28','664','2021-12-29 06:57:52',10,0),('5','131',249626,'Daily Shift ','2021-12-28','2021-12-28 00:00:00',NULL,'628',0.00,0.00,'628','2021-12-29 07:17:09','664','2021-12-30 06:45:10',10,0),('5','131',249906,'Daily Shift ','2021-12-29','2021-12-29 00:00:00',NULL,'628',0.00,0.00,'628','2021-12-30 08:12:13','664','2021-12-31 09:24:48',10,0),('5','131',250177,'Daily Shift ','2021-12-30','2021-12-30 00:00:00',NULL,'628',0.00,0.00,'628','2021-12-31 09:38:56','664','2021-12-31 11:42:36',10,0),('5','131',250217,'Daily Shift ','2021-12-31','2021-12-31 00:00:00',NULL,'628',0.00,0.00,'628','2021-12-31 16:57:11','664','2022-01-01 07:41:45',10,0),('5','131',250390,'Daily Shift ','2022-01-01','2022-01-01 00:00:00',NULL,'628',0.00,0.00,'628','2022-01-01 19:00:53','664','2022-01-02 08:06:12',10,0),('5','131',250606,'Daily Shift ','2022-01-02','2022-01-02 00:00:00',NULL,'628',0.00,0.00,'628','2022-01-02 18:17:25','664','2022-01-03 06:57:41',10,0),('5','131',250829,'Daily Shift ','2022-01-03','2022-01-03 00:00:00',NULL,'628',0.00,0.00,'628','2022-01-03 19:46:22','664','2022-01-04 08:41:51',10,0),('5','131',251085,'Daily Shift ','2022-01-04','2022-01-04 00:00:00',NULL,'628',0.00,0.00,'628','2022-01-04 15:58:27','664','2022-01-06 09:24:25',10,0),('5','131',251586,'Daily Shift ','2022-01-05','2022-01-05 00:00:00',NULL,'628',701141.10,701141.10,'628','2022-01-06 09:36:09','664','2022-01-06 12:25:53',10,0),('5','131',251670,'Daily Shift ','2022-01-06','2022-01-06 00:00:00',NULL,'628',1866833.10,1866833.10,'628','2022-01-07 07:40:19','664','2022-01-07 10:15:28',10,0),('5','131',251841,'Daily Shift ','2022-01-07','2022-01-07 00:00:00',NULL,'628',1254115.50,1254115.50,'628','2022-01-08 07:10:29','664','2022-01-08 08:07:19',10,0),('5','131',252053,'Daily Shift ','2022-01-08','2022-01-08 00:00:00',NULL,'628',1295322.60,1295322.60,'628','2022-01-08 21:02:25','664','2022-01-09 15:50:17',10,0),('5','131',252831,'Daily Shift ','2022-01-09','2022-01-09 00:00:00',NULL,'628',1034437.80,1034437.80,'628','2022-01-11 13:43:17','664','2022-01-11 14:02:41',10,0),('5','131',252856,'Daily Shift ','2022-01-10','2022-01-10 00:00:00',NULL,'628',517839.30,517839.30,'628','2022-01-11 14:39:05','664','2022-01-11 14:46:22',10,0),('5','131',252898,'Daily Shift ','2022-01-11','2022-01-11 00:00:00',NULL,'628',0.00,0.00,'628','2022-01-11 17:37:37','664','2022-01-12 08:12:46',10,0),('5','131',253050,'Daily Shift ','2022-01-12','2022-01-12 00:00:00',NULL,'628',0.00,0.00,'628','2022-01-13 07:58:09','664','2022-01-13 08:28:55',10,0),('5','131',253320,'Daily Shift ','2022-01-13','2022-01-13 00:00:00',NULL,'628',0.00,0.00,'628','2022-01-13 22:17:39','664','2022-01-14 06:37:01',10,0),('5','131',253525,'Daily Shift ','2022-01-14','2022-01-14 00:00:00',NULL,'628',822401.25,822401.25,'628','2022-01-14 19:06:37','664','2022-01-15 09:07:32',10,0),('5','131',253778,'Daily Shift ','2022-01-15','2022-01-15 00:00:00',NULL,'628',923632.05,923632.05,'628','2022-01-15 19:36:34','664','2022-01-16 06:38:51',10,0),('5','131',254037,'Daily Shift ','2022-01-16','2022-01-16 00:00:00',NULL,'628',227365.05,227365.05,'628','2022-01-16 20:08:06','664','2022-01-17 07:07:50',10,0),('5','131',254257,'Daily Shift ','2022-01-17','2022-01-17 00:00:00',NULL,'628',0.00,0.00,'628','2022-01-17 16:59:52','664','2022-01-18 07:06:53',10,0),('5','131',254465,'Daily Shift ','2022-01-18','2022-01-18 00:00:00',NULL,'628',0.00,0.00,'628','2022-01-18 18:14:40','664','2022-01-19 06:03:33',10,0),('5','131',254746,'Daily Shift ','2022-01-19','2022-01-19 00:00:00',NULL,'628',0.00,0.00,'628','2022-01-19 20:59:19','664','2022-01-20 06:33:55',10,0),('5','131',255004,'Daily Shift ','2022-01-20','2022-01-20 00:00:00',NULL,'628',0.00,0.00,'628','2022-01-20 17:24:33','664','2022-01-21 11:15:39',10,0),('5','131',255327,'Daily Shift ','2022-01-21','2022-01-21 00:00:00',NULL,'628',0.00,0.00,'628','2022-01-21 20:05:19','664','2022-01-21 22:35:43',10,0),('5','131',255511,'Daily Shift ','2022-01-22','2022-01-22 00:00:00',NULL,'628',0.00,0.00,'628','2022-01-22 17:15:30','664','2022-01-23 07:28:49',10,0),('5','131',255855,'Daily Shift ','2022-01-23','2022-01-23 00:00:00',NULL,'628',0.00,0.00,'628','2022-01-23 15:31:51','664','2022-01-24 07:30:20',10,0),('5','131',255985,'Daily Shift ','2022-01-24','2022-01-24 00:00:00',NULL,'628',0.00,0.00,'628','2022-01-24 16:35:58','664','2022-01-25 08:22:24',10,0),('5','131',256296,'Daily Shift ','2022-01-25','2022-01-25 00:00:00',NULL,'628',0.00,0.00,'628','2022-01-25 22:28:41','664','2022-01-26 06:10:38',10,0),('5','131',256689,'Daily Shift ','2022-01-26','2022-01-26 00:00:00',NULL,'628',0.00,0.00,'628','2022-01-26 21:53:23','664','2022-01-27 07:06:51',10,0),('5','131',256781,'Daily Shift ','2022-01-27','2022-01-27 00:00:00',NULL,'628',0.00,0.00,'628','2022-01-27 17:20:26','664','2022-01-28 06:36:34',10,0),('5','131',257026,'Daily Shift ','2022-01-28','2022-01-28 00:00:00',NULL,'628',0.00,0.00,'628','2022-01-28 17:23:49','664','2022-01-29 07:12:40',10,0),('5','131',257478,'Daily Shift ','2022-01-29','2022-01-29 00:00:00',NULL,'628',0.00,0.00,'628','2022-01-30 06:21:00','664','2022-01-30 06:56:07',10,0),('5','131',257509,'Daily Shift ','2022-01-30','2022-01-30 00:00:00',NULL,'628',969200.10,969200.10,'628','2022-01-31 07:49:46','664','2022-01-31 09:18:08',10,0),('5','131',257510,'Daily Shift ','2022-01-31','2022-01-31 00:00:00',NULL,'628',933822.45,933822.45,'628','2022-02-01 06:21:58','664','2022-02-02 19:19:20',10,0),('5','131',257511,'Daily Shift ','2022-02-01','2022-02-01 00:00:00',NULL,'628',864296.40,864296.40,'628','2022-02-02 19:38:18','664','2022-02-02 19:43:05',10,0),('5','131',257512,'Daily Shift ','2022-02-02','2022-02-02 00:00:00',NULL,'628',858356.40,858356.40,'628','2022-02-02 20:03:53','664','2022-02-03 07:56:45',10,0),('5','131',257513,'Daily Shift ','2022-02-03','2022-02-03 00:00:00',NULL,'628',789454.05,789454.05,'628','2022-02-03 20:31:09','664','2022-02-03 20:39:52',10,0),('5','131',257514,'Daily Shift ','2022-02-04','2022-02-04 00:00:00',NULL,'628',848642.85,848642.85,'628','2022-02-04 19:24:11','664','2022-02-05 06:56:30',10,0),('5','131',257517,'Daily Shift ','2022-02-05','2022-02-05 00:00:00',NULL,'628',984109.50,984109.50,'628','2022-02-05 19:12:05','664','2022-02-05 22:41:09',10,0),('5','131',257518,'Daily Shift ','2022-02-06','2022-02-06 00:00:00',NULL,'628',879034.20,879034.20,'628','2022-02-06 19:33:19','664','2022-02-07 07:21:10',10,0),('5','131',257519,'Daily Shift ','2022-02-07','2022-02-07 00:00:00',NULL,'628',899466.15,899466.15,'628','2022-02-07 21:32:17','664','2022-02-08 07:18:13',10,0),('5','131',257520,'Daily Shift ','2022-02-08','2022-02-08 00:00:00',NULL,'628',933190.50,933190.50,'628','2022-02-08 19:14:12','664','2022-02-08 20:42:11',10,0),('5','131',257521,'Daily Shift ','2022-02-09','2022-02-09 00:00:00',NULL,'628',967083.15,967083.15,'628','2022-02-09 17:35:20','664','2022-02-09 20:55:54',10,0),('5','131',257522,'Daily Shift ','2022-02-10','2022-02-10 00:00:00',NULL,'628',1010709.15,1010709.15,'628','2022-02-10 18:15:41','664','2022-02-10 21:43:43',10,0),('5','131',257523,'Daily Shift ','2022-02-11','2022-02-11 00:00:00',NULL,'628',977699.25,977699.25,'628','2022-02-11 18:19:50','664','2022-02-11 20:21:07',10,0),('5','131',257524,'Daily Shift ','2022-02-12','2022-02-12 00:00:00',NULL,'628',1206455.25,1206455.25,'628','2022-02-12 19:35:09','664','2022-02-13 08:47:45',10,0),('5','131',257525,'Daily Shift ','2022-02-13','2022-02-13 00:00:00',NULL,'628',1054303.80,1054303.80,'628','2022-02-13 21:08:16','664','2022-02-14 06:09:28',10,0),('5','131',257526,'Daily Shift ','2022-02-14','2022-02-14 00:00:00',NULL,'628',725538.00,725538.00,'628','2022-02-14 18:06:58','664','2022-02-14 23:48:08',10,0),('5','131',257527,'Daily Shift ','2022-02-15','2022-02-15 00:00:00',NULL,'628',502735.20,502735.20,'628','2022-02-15 16:55:42','664','2022-02-16 06:11:36',10,0),('5','131',257528,'Daily Shift ','2022-02-16','2022-02-16 00:00:00',NULL,'628',1613229.75,1613229.75,'628','2022-02-17 22:04:07','664','2022-02-18 07:58:22',10,0),('5','131',257529,'Daily Shift ','2022-02-17','2022-02-17 00:00:00',NULL,'628',822010.20,822010.20,'628','2022-02-18 09:17:10','664','2022-02-18 10:13:50',10,0),('5','131',257530,'Daily Shift ','2022-02-18','2022-02-18 00:00:00',NULL,'628',479085.75,479085.75,'628','2022-02-18 21:27:44','664','2022-02-19 07:18:53',10,0),('5','131',257531,'Daily Shift ','2022-02-19','2022-02-19 00:00:00',NULL,'628',0.00,0.00,'628','2022-02-19 20:20:55','664','2022-02-19 21:53:59',10,0),('5','131',257532,'Daily Shift ','2022-02-20','2022-02-20 00:00:00',NULL,'628',0.00,0.00,'628','2022-02-20 18:26:00','664','2022-02-21 07:22:57',10,0),('5','131',257533,'Daily Shift ','2022-02-21','2022-02-21 00:00:00',NULL,'628',2015714.25,2015714.25,'628','2022-02-21 23:31:20','664','2022-02-22 06:55:22',10,0),('5','131',257534,'Daily Shift ','2022-02-22','2022-02-22 12:10:29','2022-02-23 12:10:29','628',1844751.15,1844751.15,'628','2022-02-23 06:51:12','664','2022-02-23 07:12:18',10,0),('5','131',257535,'Daily Shift ','2022-02-23','2022-02-23 14:15:45','2022-02-24 14:15:45','628',972450.60,972450.60,'628','2022-02-24 11:16:43','664','2022-02-24 15:42:05',10,0),('5','131',257536,'Daily Shift ','2022-02-24','2022-02-24 19:06:16','2022-02-25 19:06:16','628',1342880.55,1342880.55,'628','2022-02-24 19:06:54','664','2022-02-25 06:47:17',10,0),('5','131',257537,'Daily Shift ','2022-02-25','2022-02-25 11:36:58','2022-02-26 11:36:58','628',522033.60,522033.60,'628','2022-02-25 18:42:20','664','2022-02-26 07:17:26',10,0),('5','131',257538,'Daily Shift ','2022-02-26','2022-02-26 08:53:29','2022-02-27 08:53:29','628',15658.50,15658.50,'628','2022-02-27 08:14:39','664','2022-02-27 09:12:01',10,0),('5','131',257539,'Daily Shift ','2022-02-27','2022-02-27 19:53:17','2022-02-28 19:53:17','628',0.00,0.00,'628','2022-02-27 19:53:32','664','2022-02-27 23:58:39',10,0),('5','131',257540,'Daily Shift ','2022-02-28','2022-02-28 07:10:00','2022-03-01 07:10:00','628',0.00,0.00,'628','2022-03-01 08:55:42','664','2022-03-02 09:41:25',10,0),('5','131',257541,'Daily Shift ','2022-03-01','2022-03-02 16:52:39','2022-03-03 16:52:39','628',1170048.00,1170048.00,'628','2022-03-02 16:53:51','664','2022-03-02 21:00:27',10,0),('5','131',257542,'Daily Shift ','2022-03-02','2022-03-03 07:20:50','2022-03-04 07:20:50','628',878791.65,878791.65,'628','2022-03-03 07:22:33','664','2022-03-03 08:08:17',10,0),('5','131',257543,'Daily Shift ','2022-03-03','2022-03-03 11:41:01','2022-03-04 11:41:01','628',618751.65,618751.65,'628','2022-03-03 22:23:45','664','2022-03-04 08:20:02',10,0),('5','131',257544,'Daily Shift ','2022-03-04','2022-03-04 22:41:21','2022-03-05 22:41:21','628',0.00,0.00,'628','2022-03-04 22:41:35','664','2022-03-05 06:50:35',10,0),('5','131',257545,'Daily Shift ','2022-03-05','2022-03-05 07:16:43','2022-03-06 07:16:43','628',0.00,0.00,'628','2022-03-05 19:47:11','664','2022-03-06 06:03:03',10,0),('5','131',257546,'Daily Shift ','2022-03-06','2022-03-06 06:30:28','2022-03-07 06:30:28','628',0.00,0.00,'628','2022-03-06 18:25:16','664','2022-03-06 23:35:40',10,0),('5','131',257547,'Daily Shift ','2022-03-07','2022-03-07 07:13:36','2022-03-08 07:13:36','628',0.00,0.00,'628','2022-03-07 19:42:25','664','2022-03-07 20:09:38',10,0),('5','131',257548,'Daily Shift ','2022-03-08','2022-03-08 07:11:47','2022-03-09 07:11:47','628',0.00,0.00,'628','2022-03-08 19:17:40','664','2022-03-09 07:51:44',10,0),('5','131',257549,'Daily Shift ','2022-03-09','2022-03-09 08:00:05','2022-03-10 08:00:05','628',0.00,0.00,'628','2022-03-09 20:30:53','664','2022-03-10 07:40:08',10,0),('5','131',257550,'Daily Shift ','2022-03-10','2022-03-10 08:57:06','2022-03-11 08:57:06','628',0.00,0.00,'628','2022-03-10 19:51:15','664','2022-03-11 08:55:23',10,0),('5','131',257551,'Daily Shift ','2022-03-11','2022-03-11 11:02:24','2022-03-12 11:02:24','628',0.00,0.00,'628','2022-03-11 18:33:05','664','2022-03-12 07:40:18',10,0),('5','131',257552,'Daily Shift ','2022-03-12','2022-03-12 15:22:56','2022-03-13 15:22:56','628',0.00,0.00,'628','2022-03-12 15:23:20','664','2022-03-13 12:15:05',10,0),('5','131',257553,'Daily Shift ','2022-03-13','2022-03-13 20:09:54','2022-03-14 20:09:54','628',0.00,0.00,'628','2022-03-13 20:10:13','664','2022-03-14 06:05:42',10,0),('5','131',257554,'Daily Shift ','2022-03-14','2022-03-15 00:21:29','2022-03-16 00:21:29','628',0.00,0.00,'628','2022-03-15 00:21:48','664','2022-03-15 05:59:57',10,0),('5','131',257555,'Daily Shift ','2022-03-15','2022-03-15 07:28:31','2022-03-16 07:28:31','628',2251814.40,2251814.40,'628','2022-03-16 06:15:16','664','2022-03-16 08:13:36',10,0),('5','131',257556,'Daily Shift ','2022-03-16','2022-03-16 14:15:02','2022-03-17 14:15:02','628',1065698.70,1065698.70,'628','2022-03-16 20:22:08','664','2022-03-17 08:10:31',10,0),('5','131',257557,'Daily Shift ','2022-03-17','2022-03-17 14:08:44','2022-03-18 14:08:44','628',1019297.40,1019297.40,'628','2022-03-17 21:50:25','664','2022-03-18 07:38:13',10,0),('5','131',257558,'Daily Shift ','2022-03-18','2022-03-18 12:02:35','2022-03-19 12:02:35','628',526617.30,526617.30,'628','2022-03-18 21:23:22','664','2022-03-19 07:06:55',10,0),('5','131',257559,'Daily Shift ','2022-03-19','2022-03-19 08:28:33','2022-03-20 08:28:33','628',0.00,0.00,'628','2022-03-19 17:57:11','664','2022-03-20 08:38:30',10,0),('5','131',257560,'Daily Shift p','2022-03-20','2022-03-20 11:45:49','2022-03-21 11:45:49','628',0.00,0.00,'628','2022-03-20 20:30:04','664','2022-03-21 07:06:33',10,0),('5','131',257561,'Daily Shift ','2022-03-21','2022-03-21 17:38:26','2022-03-22 17:38:26','628',0.00,0.00,'628','2022-03-21 17:38:56','664','2022-03-22 07:31:45',10,0),('5','131',257562,'Daily Shift ','2022-03-22','2022-03-22 08:01:09','2022-03-23 08:01:09','628',0.00,0.00,'628','2022-03-22 17:38:36','664','2022-03-23 07:54:11',10,0),('5','131',257563,'Daily Shift ','2022-03-23','2022-03-23 17:18:25','2022-03-24 17:18:25','628',0.00,0.00,'628','2022-03-23 17:18:41','664','2022-03-24 07:59:21',10,0),('5','131',257564,'Daily Shift ','2022-03-24','2022-03-25 00:18:25','2022-03-26 00:18:25','628',932055.30,932055.30,'628','2022-03-25 00:19:15','664','2022-03-25 06:45:13',10,0),('5','131',257565,'Daily Shift ','2022-03-25','2022-03-25 07:13:56','2022-03-26 07:13:56','628',867244.95,867244.95,'628','2022-03-25 21:34:20','664','2022-03-26 04:54:42',10,0),('5','131',257566,'Daily Shift ','2022-03-26','2022-03-26 07:23:25','2022-03-27 07:23:25','628',378876.30,378876.30,'628','2022-03-26 21:57:13','664','2022-03-27 07:55:41',10,0),('5','131',257567,'Daily Shift ','2022-03-27','2022-03-27 08:52:09','2022-03-28 08:52:09','628',0.00,0.00,'628','2022-03-27 19:37:45','664','2022-03-28 06:57:56',10,0),('5','131',257568,'Daily Shift ','2022-03-28','2022-03-28 18:14:28','2022-03-29 18:14:28','628',0.00,0.00,'628','2022-03-28 18:14:43','664','2022-03-29 07:53:02',10,0),('5','131',257569,'Daily Shift ','2022-03-29','2022-03-29 20:34:20','2022-03-30 20:34:20','628',0.00,0.00,'628','2022-03-29 20:35:04','664','2022-03-30 06:37:01',10,0),('5','131',257570,'Daily Shift ','2022-03-30','2022-03-30 07:27:04','2022-03-31 07:27:04','628',0.00,0.00,'628','2022-03-30 22:17:20','664','2022-03-31 10:56:48',10,0),('5','131',257571,'Daily Shift ','2022-03-31','2022-03-31 11:31:46','2022-04-01 11:31:46','628',0.00,0.00,'628','2022-03-31 19:20:49','664','2022-04-01 10:04:13',10,0),('5','131',257572,'Daily Shift ','2022-04-01','2022-04-01 16:42:31','2022-04-02 16:42:31','628',0.00,0.00,'628','2022-04-01 16:43:04','664','2022-04-02 08:35:52',10,0),('5','131',257573,'Daily Shift ','2022-04-02','2022-04-02 17:07:40','2022-04-03 17:07:40','628',0.00,0.00,'628','2022-04-02 17:08:12','664','2022-04-03 04:09:12',10,0),('5','131',257574,'Daily Shift ','2022-04-03','2022-04-03 15:14:49','2022-04-04 15:14:49','628',0.00,0.00,'628','2022-04-03 15:15:18','664','2022-04-04 07:44:53',10,0),('5','131',257575,'Daily Shift ','2022-04-04','2022-04-04 16:51:27','2022-04-05 16:51:27','628',0.00,0.00,'628','2022-04-04 16:51:39','664','2022-04-05 09:04:04',10,0),('5','131',257576,'Daily Shift ','2022-04-05','2022-04-05 16:46:02','2022-04-06 16:46:02','628',0.00,0.00,'628','2022-04-05 16:46:18','664','2022-04-06 08:20:28',10,0),('5','131',257577,'Daily Shift ','2022-04-06','2022-04-06 18:33:04','2022-04-07 18:33:04','628',0.00,0.00,'628','2022-04-06 18:33:37','664','2022-04-07 07:48:29',10,0),('5','131',257578,'Daily Shift ','2022-04-07','2022-04-07 21:46:29','2022-04-08 21:46:29','628',0.00,0.00,'628','2022-04-07 21:46:49','664','2022-04-08 04:07:43',10,0),('5','131',257579,'Daily Shift ','2022-04-08','2022-04-08 17:17:38','2022-04-09 17:17:38','628',0.00,0.00,'628','2022-04-08 17:17:56','664','2022-04-09 09:34:24',10,0),('5','131',257580,'Daily Shift ','2022-04-09','2022-04-09 17:56:12','2022-04-10 17:56:12','628',0.00,0.00,'628','2022-04-09 17:56:27','664','2022-04-10 00:15:08',10,0),('5','131',257581,'Daily Shift ','2022-04-10','2022-04-10 16:26:40','2022-04-11 16:26:40','628',0.00,0.00,'628','2022-04-10 16:27:02','664','2022-04-11 03:58:26',10,0),('5','131',257582,'Daily Shift ','2022-04-11','2022-04-11 19:14:46','2022-04-12 19:14:46','628',0.00,0.00,'628','2022-04-11 19:15:12','664','2022-04-12 12:47:38',10,0),('5','131',257583,'Daily Shift ','2022-04-12','2022-04-12 21:38:05','2022-04-13 21:38:05','628',82496.70,82496.70,'628','2022-04-12 21:38:52','664','2022-04-13 04:04:17',10,0),('5','131',257584,'Daily Shift ','2022-04-13','2022-04-13 07:04:16','2022-04-14 07:04:16','628',997152.75,997152.75,'628','2022-04-15 12:10:29','664','2022-04-16 05:12:48',10,0),('5','131',257585,'Daily Shift ','2022-04-14','2022-04-16 09:27:47','2022-04-17 09:27:47','628',801461.10,801461.10,'628','2022-04-16 09:29:17','664','2022-04-16 11:41:03',10,0),('5','131',257586,'Daily Shift ','2022-04-15','2022-04-16 14:44:55','2022-04-17 14:44:55','628',573162.15,573162.15,'628','2022-04-16 14:45:37','664','2022-04-16 14:47:18',10,0),('5','131',257587,'Daily Shift ','2022-04-16','2022-04-16 14:47:39','2022-04-17 14:47:39','628',0.00,0.00,'628','2022-04-16 16:46:08','664','2022-04-17 09:54:36',10,0),('5','131',257588,'Daily Shift ','2022-04-17','2022-04-17 17:55:55','2022-04-18 17:55:55','628',0.00,0.00,'628','2022-04-17 17:56:20','664','2022-04-17 23:59:36',10,0),('5','131',257589,'Daily Shift ','2022-04-18','2022-04-18 21:21:26','2022-04-19 21:21:26','628',0.00,0.00,'628','2022-04-18 21:21:43','664','2022-04-18 23:49:14',10,0),('5','131',257590,'Daily Shift ','2022-04-19','2022-04-19 10:20:11','2022-04-20 10:20:11','628',0.00,0.00,'628','2022-04-19 18:38:51','664','2022-04-20 04:50:35',10,0),('5','131',257591,'Daily Shift ','2022-04-20','2022-04-20 06:52:44','2022-04-21 06:52:44','628',0.00,0.00,'628','2022-04-20 22:52:47','664','2022-04-21 04:23:51',10,0),('5','131',257592,'Daily Shift ','2022-04-21','2022-04-21 05:08:46','2022-04-22 05:08:46','628',833226.90,833226.90,'628','2022-04-21 19:04:19','664','2022-04-22 06:10:01',10,0),('5','131',257593,'Daily Shift ','2022-04-22','2022-04-22 07:29:14','2022-04-23 07:29:14','628',0.00,0.00,'628','2022-04-22 18:21:44','664','2022-04-23 05:47:11',10,0),('5','131',257594,'Daily Shift ','2022-04-23','2022-04-23 07:55:05','2022-04-24 07:55:05','628',0.00,0.00,'628','2022-04-23 17:26:38','664','2022-04-24 03:08:32',10,0),('5','131',257595,'Daily Shift ','2022-04-24','2022-04-24 09:16:58','2022-04-25 09:16:58','628',0.00,0.00,'628','2022-04-24 20:32:04','664','2022-04-25 03:48:21',10,0),('5','131',257596,'Daily Shift ','2022-04-25','2022-04-25 08:03:05','2022-04-26 08:03:05','628',0.00,0.00,'628','2022-04-25 17:24:17','664','2022-04-26 02:16:34',10,0),('5','131',257597,'Daily Shift ','2022-04-26','2022-04-26 07:15:07','2022-04-27 07:15:07','628',0.00,0.00,'628','2022-04-26 17:58:50','664','2022-04-27 03:36:04',10,0),('5','131',257598,'Daily Shift ','2022-04-27','2022-04-27 07:34:29','2022-04-28 07:34:29','628',0.00,0.00,'628','2022-04-27 23:27:54','664','2022-04-28 01:27:01',10,0),('5','131',257599,'Daily Shift ','2022-04-28','2022-04-28 09:54:27','2022-04-29 09:54:27','628',394977.00,394977.00,'628','2022-04-28 23:49:05','664','2022-04-29 06:03:12',10,0),('5','131',257600,'Daily Shift ','2022-04-29','2022-04-29 08:00:33','2022-04-30 08:00:33','628',857572.65,857572.65,'628','2022-04-29 20:57:06','664','2022-04-30 00:03:42',10,0),('5','131',257601,'Daily Shift ','2022-04-30','2022-05-09 14:11:55','2022-05-10 14:11:55','628',1273476.60,1273476.60,'628','2022-05-09 14:12:57','664','2022-05-09 14:26:26',10,0),('5','131',257602,'Daily Shift ','2022-05-01','2022-05-09 15:01:48','2022-05-10 15:01:48','628',1017030.30,1017030.30,'628','2022-05-09 15:02:20','664','2022-05-09 15:06:00',10,0),('5','131',257603,'Daily Shift ','2022-05-02','2022-05-09 15:09:02','2022-05-10 15:09:02','628',508038.30,508038.30,'628','2022-05-09 15:09:55','664','2022-05-09 15:27:29',10,0),('5','131',257604,'Daily Shift ','2022-05-03','2022-05-09 15:32:55','2022-05-10 15:32:55','628',1338097.20,1338097.20,'628','2022-05-09 15:33:50','664','2022-05-09 15:59:44',10,0),('5','131',257605,'Daily Shift ','2022-05-04','2022-05-09 16:08:02','2022-05-10 16:08:02','628',1348056.60,1348056.60,'628','2022-05-09 19:18:40','664','2022-05-09 19:20:12',10,0),('5','131',257606,'Daily Shift ','2022-05-08','2022-05-09 19:21:38','2022-05-10 19:21:38','628',1453390.95,1453390.95,'628','2022-05-09 19:22:59','664','2022-05-09 19:23:24',10,0),('5','131',257607,'Daily Shift ','2022-05-09','2022-05-09 19:26:06','2022-05-10 19:26:06','628',0.00,0.00,'628','2022-05-09 19:47:28','664','2022-05-09 19:50:17',10,0),('5','131',257608,'Daily Shift ','2022-05-05','2022-05-09 19:54:10','2022-05-10 19:54:10','628',0.00,0.00,'628','2022-05-09 19:54:27','664','2022-05-09 19:56:33',10,0),('5','131',257609,'Daily Shift ','2022-05-06','2022-05-09 19:57:16','2022-05-10 19:57:16','628',0.00,0.00,'628','2022-05-09 19:57:32','664','2022-05-09 20:01:39',10,0),('5','131',257610,'Daily Shift ','2022-05-07','2022-05-09 20:03:20','2022-05-10 20:03:20','628',0.00,0.00,'628','2022-05-09 20:27:43','664','2022-05-09 20:37:49',10,0),('5','131',257611,'Daily Shift ','2022-05-09','2022-05-09 20:43:54','2022-05-10 20:43:54','628',1083132.60,1083132.60,'628','2022-05-09 20:44:48','664','2022-05-09 20:50:15',10,0),('5','131',257612,'Daily Shift ','2022-05-10','2022-05-10 06:18:20','2022-05-11 06:18:20','628',554520.45,554520.45,'628','2022-05-10 17:45:30','664','2022-05-10 22:52:34',10,0),('5','131',257613,'Daily Shift ','2022-05-11','2022-05-11 06:25:03','2022-05-12 06:25:03','628',171657.75,171657.75,'628','2022-05-11 18:19:05','664','2022-05-12 05:31:43',10,0),('5','131',257614,'Daily Shift ','2022-05-12','2022-05-12 06:30:24','2022-05-13 06:30:24','628',0.00,0.00,'628','2022-05-12 17:47:44','664','2022-05-12 18:45:16',10,0),('5','131',257615,'Daily Shift ','2022-05-13','2022-05-13 06:45:11','2022-05-14 06:45:11','628',0.00,0.00,'628','2022-05-13 17:19:55','664','2022-05-13 22:26:23',10,0),('5','131',257616,'Daily Shift ','2022-05-14','2022-05-14 06:39:59','2022-05-15 06:39:59','628',0.00,0.00,'628','2022-05-14 18:30:02','664','2022-05-15 06:10:50',10,0),('5','131',257617,'Daily Shift ','2022-05-15','2022-05-15 06:39:34','2022-05-16 06:39:34','628',0.00,0.00,'628','2022-05-15 19:22:40','664','2022-05-16 06:03:07',10,0),('5','131',257618,'Daily Shift ','2022-05-16','2022-05-16 07:25:50','2022-05-17 07:25:50','628',0.00,0.00,'628','2022-05-16 19:52:05','600','2022-05-17 06:12:33',10,0),('5','131',257619,'Daily Shift ','2022-05-17','2022-05-17 09:59:20','2022-05-18 09:59:20','628',0.00,0.00,'628','2022-05-17 18:14:34','600','2022-05-18 06:12:37',10,0),('5','131',257620,'Daily Shift ','2022-05-18','2022-05-18 07:16:51','2022-05-19 07:16:51','628',599001.15,599001.15,'628','2022-05-18 19:19:26','600','2022-05-18 21:30:50',10,0),('5','131',257621,'Daily Shift ','2022-05-19','2022-05-19 08:54:22','2022-05-20 08:54:22','628',797784.90,797784.90,'628','2022-05-20 04:04:41','664','2022-05-20 05:23:51',10,0),('5','131',257622,'Daily Shift ','2022-05-20','2022-05-20 09:26:37','2022-05-21 09:26:37','628',848017.50,848017.50,'628','2022-05-21 05:52:09','600','2022-05-22 08:14:52',10,0),('5','131',257623,'Daily Shift ','2022-05-21','2022-05-22 10:30:24','2022-05-23 10:30:24','628',747077.10,747077.10,'628','2022-05-22 10:31:20','664','2022-05-23 05:16:52',10,0),('5','131',257624,'Daily Shift ','2022-05-22','2022-05-23 09:53:32','2022-05-24 09:53:32','628',0.00,0.00,'628','2022-05-23 09:54:03','600','2022-05-23 12:49:07',10,0),('5','131',257625,'Daily Shift ','2022-05-23','2022-05-23 12:55:45','2022-05-24 12:55:45','628',0.00,0.00,'628','2022-05-23 17:53:13','600','2022-05-23 22:00:17',10,0),('5','131',257626,'Daily Shift ','2022-05-24','2022-05-24 11:12:51','2022-05-25 11:12:51','628',0.00,0.00,'628','2022-05-24 22:12:51','600','2022-05-25 06:11:21',10,0),('5','131',257627,'Daily Shift ','2022-05-25','2022-05-25 11:07:54','2022-05-26 11:07:54','628',0.00,0.00,'628','2022-05-25 22:38:57','664','2022-05-26 05:21:58',10,0),('5','131',257628,'Daily Shift ','2022-05-26','2022-05-26 06:36:53','2022-05-27 06:36:53','628',0.00,0.00,'628','2022-05-26 18:13:10','600','2022-05-26 20:40:23',10,0),('5','131',257629,'Daily Shift ','2022-05-27','2022-05-27 10:23:22','2022-05-28 10:23:22','628',0.00,0.00,'628','2022-05-27 21:50:04','664','2022-05-28 04:58:47',10,0),('5','131',257630,'Daily Shift ','2022-05-28','2022-05-28 10:48:14','2022-05-29 10:48:14','628',0.00,0.00,'628','2022-05-28 22:16:00','600','2022-05-29 08:18:02',10,0),('5','131',257631,'Daily Shift ','2022-05-29','2022-05-29 21:57:17','2022-05-30 21:57:17','628',0.00,0.00,'628','2022-05-29 21:57:47','664','2022-05-30 05:00:05',10,0),('5','131',257632,'Daily Shift ','2022-05-30','2022-05-30 17:49:26','2022-05-31 17:49:26','628',0.00,0.00,'628','2022-05-30 17:50:15','664','2022-05-31 00:20:50',10,0),('5','131',257633,'Daily Shift ','2022-05-31','2022-05-31 21:44:55','2022-06-01 21:44:55','628',0.00,0.00,'628','2022-05-31 21:45:25','664','2022-06-01 07:04:48',10,0),('5','131',257634,'Daily Shift ','2022-06-01','2022-06-01 21:28:19','2022-06-02 21:28:19','628',0.00,0.00,'628','2022-06-01 21:28:49','664','2022-06-02 05:01:37',10,0),('5','131',257635,'Daily Shift ','2022-06-02','2022-06-02 22:57:48','2022-06-03 22:57:48','628',0.00,0.00,'628','2022-06-02 22:58:09','664','2022-06-03 06:47:16',10,0),('5','131',257636,'Daily Shift ','2022-06-03','2022-06-03 20:18:29','2022-06-04 20:18:29','628',0.00,0.00,'628','2022-06-03 20:19:16','664','2022-06-04 06:07:10',10,0),('5','131',257637,'Daily Shift ','2022-06-04','2022-06-04 19:42:11','2022-06-05 19:42:11','628',0.00,0.00,'628','2022-06-04 19:42:42','664','2022-06-05 06:07:48',10,0),('5','131',257638,'Daily Shift ','2022-06-05','2022-06-05 13:00:44','2022-06-06 13:00:44','628',681651.30,681651.30,'628','2022-06-05 19:17:56','664','2022-06-06 06:29:41',10,0),('5','131',257639,'Daily Shift ','2022-06-06','2022-06-06 12:49:37','2022-06-07 12:49:37','628',853064.85,853064.85,'628','2022-06-06 21:03:07','664','2022-06-07 07:27:00',10,0),('5','131',257640,'Daily Shift ','2022-06-07','2022-06-08 06:07:22','2022-06-09 06:07:22','628',625812.00,625812.00,'628','2022-06-08 06:08:08','664','2022-06-08 10:32:13',10,0),('5','131',257641,'Daily Shift ','2022-06-08','2022-06-08 20:45:26','2022-06-09 20:45:26','628',307414.80,307414.80,'628','2022-06-08 21:22:06','664','2022-06-09 06:01:18',10,0),('5','131',257642,'Daily Shift ','2022-06-09','2022-06-09 16:30:08','2022-06-10 16:30:08','628',0.00,0.00,'628','2022-06-09 16:30:36','664','2022-06-10 05:28:40',10,0),('5','131',257643,'Daily Shift ','2022-06-10','2022-06-10 14:46:30','2022-06-11 14:46:30','628',0.00,0.00,'628','2022-06-10 18:11:29','664','2022-06-10 21:45:43',10,0),('5','131',257644,'Daily Shift ','2022-06-11','2022-06-11 21:04:51','2022-06-12 21:04:51','628',0.00,0.00,'628','2022-06-11 21:05:27','664','2022-06-12 08:31:21',10,0),('5','131',257645,'Daily Shift ','2022-06-12','2022-06-12 14:37:39','2022-06-13 14:37:39','628',0.00,0.00,'628','2022-06-12 18:42:32','664','2022-06-13 06:54:58',10,0),('5','131',257646,'Daily Shift ','2022-06-13','2022-06-13 20:31:55','2022-06-14 20:31:55','628',0.00,0.00,'628','2022-06-13 20:32:11','664','2022-06-14 08:59:01',10,0),('5','131',257647,'Daily Shift ','2022-06-14','2022-06-14 16:31:07','2022-06-15 16:31:07','628',0.00,0.00,'628','2022-06-14 16:31:25','664','2022-06-14 22:18:27',10,0),('5','131',257648,'Daily Shift ','2022-06-15','2022-06-15 07:06:45','2022-06-16 07:06:45','628',0.00,0.00,'628','2022-06-15 19:48:05','664','2022-06-16 07:03:00',10,0),('5','131',257649,'Daily Shift ','2022-06-16','2022-06-16 07:42:02','2022-06-17 07:42:02','628',0.00,0.00,'628','2022-06-16 19:59:16','664','2022-06-17 06:00:55',10,0),('5','131',257650,'Daily Shift ','2022-06-17','2022-06-17 19:44:41','2022-06-18 19:44:41','628',0.00,0.00,'628','2022-06-17 19:44:54','664','2022-06-18 07:04:31',10,0),('5','131',257651,'Daily Shift ','2022-06-18','2022-06-18 12:07:31','2022-06-19 12:07:31','628',0.00,0.00,'628','2022-06-18 17:54:06','664','2022-06-18 22:49:32',10,0),('5','131',257652,'Daily Shift ','2022-06-19','2022-06-19 10:25:27','2022-06-20 10:25:27','628',0.00,0.00,'628','2022-06-19 18:49:30','664','2022-06-20 06:47:12',10,0),('5','131',257653,'Daily Shift ','2022-06-20','2022-06-20 14:20:55','2022-06-21 14:20:55','628',0.00,0.00,'628','2022-06-20 18:45:01','664','2022-06-21 07:55:09',10,0),('5','131',257654,'Daily Shift ','2022-06-21','2022-06-21 17:02:07','2022-06-22 17:02:07','628',0.00,0.00,'628','2022-06-21 17:02:34','664','2022-06-21 22:47:09',10,0),('5','131',257655,'Daily Shift ','2022-06-22','2022-06-22 08:44:48','2022-06-23 08:44:48','628',0.00,0.00,'628','2022-06-23 04:28:16','664','2022-06-23 07:07:54',10,0),('5','131',257656,'Daily Shift ','2022-06-23','2022-06-23 14:12:29','2022-06-24 14:12:29','628',0.00,0.00,'628','2022-06-23 20:42:05','664','2022-06-23 22:55:09',10,0),('5','131',257657,'Daily Shift ','2022-06-24','2022-06-24 07:13:01','2022-06-25 07:13:01','628',0.00,0.00,'628','2022-06-24 18:02:46','664','2022-06-25 06:14:46',10,0),('5','131',257658,'Daily Shift ','2022-06-25','2022-06-25 09:40:06','2022-06-26 09:40:06','628',0.00,0.00,'628','2022-06-25 21:36:39','664','2022-06-26 07:16:22',10,0),('5','131',257659,'Daily Shift ','2022-06-26','2022-06-26 08:16:05','2022-06-27 08:16:05','628',0.00,0.00,'628','2022-06-26 18:35:44','664','2022-06-27 07:36:21',10,0),('5','131',257660,'Daily Shift ','2022-06-27','2022-06-27 07:43:38','2022-06-28 07:43:38','628',0.00,0.00,'628','2022-06-27 19:47:01','664','2022-06-28 07:23:18',10,0),('5','131',257661,'Daily Shift ','2022-06-28','2022-06-28 09:51:36','2022-06-29 09:51:36','628',0.00,0.00,'628','2022-06-28 17:40:48','664','2022-06-29 08:03:07',10,0),('5','131',257662,'Daily Shift ','2022-06-29','2022-06-29 09:27:28','2022-06-30 09:27:28','628',0.00,0.00,'628','2022-06-29 17:36:27','664','2022-06-30 06:25:23',10,0),('5','131',257663,'Daily Shift ','2022-06-30','2022-06-30 07:10:36','2022-07-01 07:10:36','628',0.00,0.00,'628','2022-06-30 18:50:43','664','2022-07-01 07:10:36',10,0),('5','131',257664,'Daily Shift ','2022-07-01','2022-07-01 07:17:48','2022-07-02 07:17:48','628',0.00,0.00,'628','2022-07-01 18:40:24','664','2022-07-02 05:49:45',10,0),('5','131',257665,'Daily Shift ','2022-07-02','2022-07-02 08:15:06','2022-07-03 08:15:06','628',0.00,0.00,'628','2022-07-03 06:12:11','664','2022-07-03 06:30:36',10,0),('5','131',257666,'Daily Shift ','2022-07-03','2022-07-03 08:17:13','2022-07-04 08:17:13','628',0.00,0.00,'628','2022-07-03 17:58:38','664','2022-07-03 23:25:44',10,0),('5','131',257667,'Daily Shift ','2022-07-04','2022-07-04 07:24:59','2022-07-05 07:24:59','628',0.00,0.00,'628','2022-07-04 16:52:18','664','2022-07-04 22:36:09',10,0),('5','131',257668,'Daily Shift ','2022-07-05','2022-07-05 06:40:35','2022-07-06 06:40:35','628',0.00,0.00,'628','2022-07-05 18:33:16','664','2022-07-06 07:50:14',10,0),('5','131',257669,'Daily Shift ','2022-07-06','2022-07-06 07:54:58','2022-07-07 07:54:58','628',0.00,0.00,'628','2022-07-06 18:48:52','664','2022-07-07 05:27:42',10,0),('5','131',257670,'Daily Shift ','2022-07-07','2022-07-07 07:29:46','2022-07-08 07:29:46','628',0.00,0.00,'628','2022-07-08 06:19:20','664','2022-07-08 07:08:17',10,0),('5','131',257671,'Daily Shift ','2022-07-08','2022-07-08 08:08:50','2022-07-09 08:08:50','628',0.00,0.00,'628','2022-07-08 18:21:11','664','2022-07-08 22:42:41',10,0),('5','131',257672,'Daily Shift ','2022-07-09','2022-07-09 10:33:34','2022-07-10 10:33:34','628',0.00,0.00,'628','2022-07-09 16:51:26','664','2022-07-10 07:04:53',10,0),('5','131',257673,'Daily Shift ','2022-07-10','2022-07-10 08:11:54','2022-07-11 08:11:54','628',0.00,0.00,'628','2022-07-10 20:19:11','664','2022-07-11 07:01:19',10,0),('5','131',257674,'Daily Shift ','2022-07-11','2022-07-11 07:18:11','2022-07-12 07:18:11','628',0.00,0.00,'628','2022-07-11 21:14:57','664','2022-07-12 05:23:27',10,0),('5','131',257675,'Daily Shift ','2022-07-12','2022-07-12 08:39:36','2022-07-13 08:39:36','628',0.00,0.00,'628','2022-07-12 18:32:27','664','2022-07-13 07:18:42',10,0),('5','131',257676,'Daily Shift ','2022-07-13','2022-07-13 07:29:33','2022-07-14 07:29:33','628',0.00,0.00,'628','2022-07-13 21:14:10','664','2022-07-14 06:33:27',10,0),('5','131',257677,'Daily Shift ','2022-07-14','2022-07-14 08:18:14','2022-07-15 08:18:14','628',0.00,0.00,'628','2022-07-14 18:33:34','664','2022-07-15 07:18:33',10,0),('5','131',257678,'Daily Shift ','2022-07-15','2022-07-15 08:46:19','2022-07-16 08:46:19','628',0.00,0.00,'628','2022-07-15 19:13:32','664','2022-07-16 06:54:34',10,0),('5','131',257679,'Daily Shift ','2022-07-16','2022-07-16 07:16:42','2022-07-17 07:16:42','628',0.00,0.00,'628','2022-07-16 17:34:33','664','2022-07-17 05:30:18',10,0),('5','131',257680,'Daily Shift ','2022-07-17','2022-07-17 15:32:57','2022-07-18 15:32:57','628',0.00,0.00,'628','2022-07-17 18:21:26','664','2022-07-18 07:35:54',10,0),('5','131',257681,'Daily Shift ','2022-07-18','2022-07-18 09:35:46','2022-07-19 09:35:46','628',0.00,0.00,'628','2022-07-18 17:04:16','664','2022-07-18 20:02:28',10,0),('5','131',257682,'Daily Shift ','2022-07-19','2022-07-19 07:47:30','2022-07-20 07:47:30','628',0.00,0.00,'628','2022-07-19 20:33:04','664','2022-07-20 07:40:48',10,0),('5','131',257683,'Daily Shift ','2022-07-20','2022-07-20 07:56:51','2022-07-21 07:56:51','628',1316990.95,1316990.95,'628','2022-07-21 07:36:26','664','2022-07-21 07:59:20',10,0),('5','131',257684,'Daily Shift ','2022-07-21','2022-07-21 08:14:08','2022-07-22 08:14:08','628',1319658.65,1319658.65,'628','2022-07-21 18:32:39','664','2022-07-21 23:14:39',10,0),('5','131',257685,'Daily Shift ','2022-07-22','2022-07-22 07:30:58','2022-07-23 07:30:58','628',1025780.60,1025780.60,'628','2022-07-22 15:43:30','664','2022-07-23 06:55:43',10,0),('5','131',257686,'Daily Shift ','2022-07-23','2022-07-23 09:52:47','2022-07-24 09:52:47','628',1291490.55,1291490.55,'628','2022-07-23 17:42:48','664','2022-07-24 08:32:51',10,0),('5','131',257687,'Daily Shift ','2022-07-24','2022-07-24 08:45:16','2022-07-25 08:45:16','628',1297449.40,1297449.40,'628','2022-07-24 17:53:52','664','2022-07-25 06:45:21',10,0),('5','131',257688,'Daily Shift ','2022-07-25','2022-07-25 06:56:39','2022-07-26 06:56:39','628',825771.55,736498.95,'628','2022-07-25 18:54:20','664','2022-07-26 05:54:26',10,0),('5','131',257689,'Daily Shift ','2022-07-26','2022-07-26 06:52:02','2022-07-27 06:52:02','628',945037.35,945037.35,'628','2022-07-26 17:19:14','664','2022-07-27 06:05:10',10,0),('5','131',257690,'Daily Shift ','2022-07-27','2022-07-27 07:25:27','2022-07-28 07:25:27','628',346958.25,346958.25,'628','2022-07-27 20:57:04','664','2022-07-28 06:54:52',10,0),('5','131',257691,'Daily Shift ','2022-07-28','2022-07-28 07:54:04','2022-07-29 07:54:04','628',0.00,0.00,'628','2022-07-28 22:10:48','664','2022-07-29 07:12:57',10,0),('5','131',257692,'Daily Shift ','2022-07-29','2022-07-29 07:32:16','2022-07-30 07:32:16','628',0.00,0.00,'628','2022-07-30 06:56:03','664','2022-07-30 09:12:39',10,0),('5','131',257693,'Daily Shift ','2022-07-30','2022-07-30 17:32:38','2022-07-31 17:32:38','628',0.00,0.00,'628','2022-07-30 17:32:54','664','2022-07-31 05:23:36',10,0),('5','131',257694,'Daily Shift ','2022-07-31','2022-07-31 08:50:01','2022-08-01 08:50:01','628',0.00,0.00,'628','2022-07-31 20:49:43','664','2022-08-01 07:49:32',10,0),('5','131',257695,'Daily Shift ','2022-08-01','2022-08-01 08:02:52','2022-08-02 08:02:52','628',0.00,0.00,'628','2022-08-01 20:07:09','664','2022-08-02 05:39:01',10,0),('5','131',257696,'Daily Shift ','2022-08-02','2022-08-02 08:22:10','2022-08-03 08:22:10','628',0.00,0.00,'628','2022-08-03 09:57:46','664','2022-08-03 10:30:26',10,0),('5','131',257697,'Daily Shift ','2022-08-03','2022-08-03 10:58:55','2022-08-04 10:58:55','628',0.00,0.00,'628','2022-08-03 20:58:11','664','2022-08-04 06:15:39',10,0),('5','131',257698,'Daily Shift ','2022-08-04','2022-08-04 06:59:47','2022-08-05 06:59:47','628',0.00,0.00,'628','2022-08-04 18:28:17','664','2022-08-04 21:54:25',10,0),('5','131',257699,'Daily Shift ','2022-08-05','2022-08-05 07:04:13','2022-08-06 07:04:13','628',0.00,0.00,'628','2022-08-05 21:04:11','664','2022-08-06 06:55:22',10,0),('5','131',257700,'Daily Shift ','2022-08-06','2022-08-06 08:16:10','2022-08-07 08:16:10','628',0.00,0.00,'628','2022-08-06 17:37:53','664','2022-08-07 05:37:26',10,0),('5','131',257701,'Daily Shift ','2022-08-07','2022-08-07 06:42:19','2022-08-08 06:42:19','628',0.00,0.00,'628','2022-08-07 21:09:52','606','2022-10-26 12:27:44',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4905027 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('5','131','744','181745',3568709,'2084','308',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','181745',3568710,'2085','308',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','181745',3568711,'2086','308',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','181745',3568712,'2087','308',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','181745',3568713,'2088','308',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','181745',3568714,'2089','308',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','181745',3568715,'2090','309',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','748','181745',3568716,'2091','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','182968',3591183,'2084','308',393672.52,393672.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','182968',3591184,'2085','308',449178.51,449178.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','182968',3591185,'2086','308',199403.01,199403.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','182968',3591186,'2087','308',355890.64,358894.46,3003.82,489622.66,0.00,0.00,0.00,0.00,0.00),('5','131','745','182968',3591187,'2088','308',603325.64,605449.16,2123.52,346133.76,0.00,0.00,0.00,0.00,0.00),('5','131','745','182968',3591188,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','182968',3591189,'2090','309',95278.88,95366.92,88.04,22010.00,0.00,0.00,0.00,0.00,0.00),('5','131','748','182968',3591190,'2091','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','182972',3591265,'2084','308',393672.52,393672.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','182972',3591266,'2085','308',449178.51,449178.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','182972',3591267,'2086','308',199403.01,199403.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','182972',3591268,'2087','308',358894.46,360739.74,1845.28,300780.64,0.00,0.00,0.00,0.00,0.00),('5','131','745','182972',3591269,'2088','308',605449.16,607228.05,1778.89,289959.07,0.00,0.00,0.00,0.00,0.00),('5','131','745','182972',3591270,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','182972',3591271,'2090','309',95366.92,95535.32,168.40,42100.00,0.00,0.00,0.00,0.00,0.00),('5','131','748','182972',3591272,'2091','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','182973',3591273,'2084','308',393672.52,393672.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','182973',3591274,'2085','308',449178.51,449178.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','182973',3591275,'2086','308',199403.01,199403.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','182973',3591276,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','182973',3591277,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','182973',3591278,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','182973',3591279,'2090','309',95535.32,95671.08,135.76,33940.00,0.00,0.00,0.00,0.00,0.00),('5','131','748','182973',3591280,'2091','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','186255',3649784,'2084','308',393672.52,393672.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','186255',3649785,'2085','308',449178.51,449178.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','186255',3649786,'2086','308',199403.01,199403.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186255',3649787,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186255',3649788,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186255',3649789,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','186255',3649790,'2090','309',95671.08,96051.81,380.73,100893.45,0.00,0.00,0.00,0.00,0.00),('5','131','748','186255',3649791,'2091','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','186258',3649831,'2084','308',393672.52,393672.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','186258',3649832,'2085','308',449178.51,449178.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','186258',3649833,'2086','308',199403.01,199403.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186258',3649834,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186258',3649835,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186258',3649836,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','186258',3649837,'2090','309',96051.81,96294.76,242.95,64381.75,0.00,0.00,0.00,0.00,0.00),('5','131','748','186258',3649838,'2091','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','186259',3649839,'2084','308',393672.52,393672.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','186259',3649840,'2085','308',449178.51,449178.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','186259',3649841,'2086','308',199403.01,199403.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186259',3649842,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186259',3649843,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186259',3649844,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','186259',3649845,'2090','309',96294.76,96744.51,449.75,119183.75,0.00,0.00,0.00,0.00,0.00),('5','131','748','186259',3649846,'2091','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','186262',3649906,'2084','308',393672.52,393672.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','186262',3649907,'2085','308',449178.51,449178.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','186262',3649908,'2086','308',199403.01,199403.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186262',3649909,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186262',3649910,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186262',3649911,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','186262',3649912,'2090','309',96744.51,96948.20,203.69,53977.85,0.00,0.00,0.00,0.00,0.00),('5','131','748','186262',3649913,'2091','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','186265',3649952,'2084','308',393672.52,393672.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','186265',3649953,'2085','308',449178.51,449178.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','186265',3649954,'2086','308',199403.01,199403.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186265',3649955,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186265',3649956,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186265',3649957,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','186265',3649958,'2090','309',96948.20,97034.99,86.79,22999.35,0.00,0.00,0.00,0.00,0.00),('5','131','748','186265',3649959,'2091','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','186266',3649960,'2084','308',393672.52,393672.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','186266',3649961,'2085','308',449178.51,449178.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','186266',3649962,'2086','308',199403.01,199403.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186266',3649963,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186266',3649964,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186266',3649965,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','186266',3649966,'2090','309',97034.99,97162.51,127.52,32517.60,0.00,0.00,0.00,0.00,0.00),('5','131','748','186266',3649967,'2091','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','186268',3649981,'2084','308',393672.52,393672.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','186268',3649982,'2085','308',449178.51,449178.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','186268',3649983,'2086','308',199403.01,199403.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186268',3649984,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186268',3649985,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186268',3649986,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','186268',3649987,'2090','309',97162.51,97623.74,461.23,117613.65,0.00,0.00,0.00,0.00,0.00),('5','131','748','186268',3649988,'2091','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','186274',3650011,'2084','308',393672.52,393672.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','186274',3650012,'2085','308',449178.51,452485.23,3306.72,538995.36,0.00,0.00,0.00,0.00,0.00),('5','131','744','186274',3650013,'2086','308',199403.01,199403.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186274',3650014,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186274',3650015,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186274',3650016,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','186274',3650017,'2090','309',97623.74,98062.36,438.62,111848.10,0.00,0.00,0.00,0.00,0.00),('5','131','748','186274',3650018,'2091','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','186403',3652007,'2084','308',393672.52,393672.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','186403',3652008,'2085','308',452485.23,454961.18,2475.95,403579.85,0.00,0.00,0.00,0.00,0.00),('5','131','744','186403',3652009,'2086','308',199403.01,199403.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186403',3652010,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186403',3652011,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186403',3652012,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','186403',3652013,'2090','309',98062.36,98503.45,441.09,112477.95,0.00,0.00,0.00,0.00,0.00),('5','131','748','186403',3652014,'2091','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','186409',3652116,'2084','308',393672.52,393672.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','186409',3652117,'2085','308',454961.18,454961.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','186409',3652118,'2086','308',199403.01,199403.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186409',3652119,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186409',3652120,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186409',3652121,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','186409',3652122,'2090','309',98503.45,99046.09,542.64,138373.20,0.00,0.00,0.00,0.00,0.00),('5','131','748','186409',3652123,'2091','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','186411',3652146,'2084','308',393672.52,394980.60,1308.08,213217.04,0.00,0.00,0.00,0.00,0.00),('5','131','744','186411',3652147,'2085','308',454961.18,455933.01,971.83,158408.29,0.00,0.00,0.00,0.00,0.00),('5','131','744','186411',3652148,'2086','308',199403.01,199609.73,206.72,33695.36,0.00,0.00,0.00,0.00,0.00),('5','131','745','186411',3652149,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186411',3652150,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186411',3652151,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','186411',3652152,'2090','309',99046.09,99281.35,235.26,62343.90,0.00,0.00,0.00,0.00,0.00),('5','131','748','186411',3652153,'2091','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','186422',3652326,'2084','308',394980.60,397345.33,2364.73,385450.99,0.00,0.00,0.00,0.00,0.00),('5','131','744','186422',3652327,'2085','308',455933.01,459566.85,3633.84,592315.92,0.00,0.00,0.00,0.00,0.00),('5','131','744','186422',3652328,'2086','308',199609.73,202254.33,2644.60,431069.80,0.00,0.00,0.00,0.00,0.00),('5','131','745','186422',3652329,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186422',3652330,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186422',3652331,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','186422',3652332,'2090','309',99281.35,99543.48,262.13,69464.45,0.00,0.00,0.00,0.00,0.00),('5','131','748','186422',3652333,'2091','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','186423',3652334,'2084','308',397345.33,398177.59,832.26,135658.38,0.00,0.00,0.00,0.00,0.00),('5','131','744','186423',3652335,'2085','308',459566.85,463742.43,4175.58,680619.54,0.00,0.00,0.00,0.00,0.00),('5','131','744','186423',3652336,'2086','308',202254.33,205320.49,3066.16,499784.08,0.00,0.00,0.00,0.00,0.00),('5','131','745','186423',3652337,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186423',3652338,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186423',3652339,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','186423',3652340,'2090','309',99543.48,99885.73,342.25,90696.25,0.00,0.00,0.00,0.00,0.00),('5','131','748','186423',3652341,'2091','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','186475',3653426,'2084','308',398177.59,398185.04,7.45,1214.35,0.00,0.00,0.00,0.00,0.00),('5','131','744','186475',3653427,'2085','308',463742.43,466331.76,2589.33,422060.79,0.00,0.00,0.00,0.00,0.00),('5','131','744','186475',3653428,'2086','308',205320.49,207777.37,2456.88,400471.44,0.00,0.00,0.00,0.00,0.00),('5','131','745','186475',3653429,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186475',3653430,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186475',3653431,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','186475',3653432,'2090','309',99885.73,100263.86,378.13,100204.45,0.00,0.00,0.00,0.00,0.00),('5','131','748','186475',3653433,'2091','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','186477',3653434,'2084','308',398185.04,400498.58,2313.54,377107.02,0.00,0.00,0.00,0.00,0.00),('5','131','744','186477',3653435,'2085','308',466331.76,468725.75,2393.99,390220.37,0.00,0.00,0.00,0.00,0.00),('5','131','744','186477',3653436,'2086','308',207777.37,211322.13,3544.76,577795.88,0.00,0.00,0.00,0.00,0.00),('5','131','745','186477',3653437,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186477',3653438,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186477',3653439,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','186477',3653440,'2090','309',100263.86,100263.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','748','186477',3653441,'2091','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','186602',3655553,'2084','308',400498.58,402767.27,2268.69,369796.47,0.00,0.00,0.00,0.00,0.00),('5','131','744','186602',3655554,'2085','308',468725.75,472944.56,4218.81,687666.03,0.00,0.00,0.00,0.00,0.00),('5','131','744','186602',3655555,'2086','308',211322.13,213836.88,2514.75,409904.25,0.00,0.00,0.00,0.00,0.00),('5','131','745','186602',3655556,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186602',3655557,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186602',3655558,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','186602',3655559,'2090','309',100263.86,100263.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','748','186602',3655560,'2091','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','186608',3655704,'2084','308',402767.27,402767.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','186608',3655705,'2085','308',472944.56,477991.52,5046.96,822654.48,0.00,0.00,0.00,0.00,0.00),('5','131','744','186608',3655706,'2086','308',213836.88,214869.48,1032.60,168313.80,0.00,0.00,0.00,0.00,0.00),('5','131','745','186608',3655707,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186608',3655708,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186608',3655709,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','186608',3655710,'2090','309',100263.86,100263.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','748','186608',3655711,'2091','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','186651',3656369,'2084','308',402767.27,402775.09,7.82,1274.66,0.00,0.00,0.00,0.00,0.00),('5','131','744','186651',3656370,'2085','308',477991.52,481978.00,3986.48,649796.24,0.00,0.00,0.00,0.00,0.00),('5','131','744','186651',3656371,'2086','308',214869.48,215559.32,689.84,112443.92,0.00,0.00,0.00,0.00,0.00),('5','131','745','186651',3656372,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186651',3656373,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186651',3656374,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','186651',3656375,'2090','309',100263.86,100263.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','748','186651',3656376,'2091','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','186724',3657752,'2084','308',402775.09,402775.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','186724',3657753,'2085','308',481978.00,486789.62,4811.62,784294.06,0.00,0.00,0.00,0.00,0.00),('5','131','744','186724',3657754,'2086','308',215559.32,219790.87,4231.55,689742.65,0.00,0.00,0.00,0.00,0.00),('5','131','745','186724',3657755,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186724',3657756,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','186724',3657757,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','186724',3657758,'2090','309',100263.86,100263.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','748','186724',3657759,'2091','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','187660',3673921,'2084','308',402775.09,402775.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','187660',3673922,'2085','308',486789.62,491541.60,4751.98,774572.74,0.00,0.00,0.00,0.00,0.00),('5','131','744','187660',3673923,'2086','308',219790.87,223505.84,3714.97,605540.11,0.00,0.00,0.00,0.00,0.00),('5','131','745','187660',3673924,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','187660',3673925,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','187660',3673926,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','187660',3673927,'2090','309',100263.86,100263.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','748','187660',3673928,'2091','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','187692',3674562,'2084','308',402775.09,404168.71,1393.62,227160.06,0.00,0.00,0.00,0.00,0.00),('5','131','744','187692',3674563,'2085','308',491541.60,495833.12,4291.52,699517.76,0.00,0.00,0.00,0.00,0.00),('5','131','744','187692',3674564,'2086','308',223505.84,226832.85,3327.01,542302.63,0.00,0.00,0.00,0.00,0.00),('5','131','745','187692',3674565,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','187692',3674566,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','187692',3674567,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','187692',3674568,'2090','309',100263.86,100263.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','187701',3674697,'2084','308',404168.71,406717.70,2548.99,415485.37,0.00,0.00,0.00,0.00,0.00),('5','131','744','187701',3674698,'2085','308',495833.12,499582.11,3748.99,611085.37,0.00,0.00,0.00,0.00,0.00),('5','131','744','187701',3674699,'2086','308',226832.85,228672.22,1839.37,299817.31,0.00,0.00,0.00,0.00,0.00),('5','131','745','187701',3674700,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','187701',3674701,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','187701',3674702,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','187701',3674703,'2090','309',100263.86,100263.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','187857',3677325,'2084','308',406717.70,407797.81,1080.11,176057.93,0.00,0.00,0.00,0.00,0.00),('5','131','744','187857',3677326,'2085','308',499582.11,504285.33,4703.22,766624.86,0.00,0.00,0.00,0.00,0.00),('5','131','744','187857',3677327,'2086','308',228672.22,232324.15,3651.93,595264.59,0.00,0.00,0.00,0.00,0.00),('5','131','745','187857',3677328,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','187857',3677329,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','187857',3677330,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','187857',3677331,'2090','309',100263.86,100263.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','188109',3681775,'2084','308',407797.81,408116.69,318.88,51977.44,0.00,0.00,0.00,0.00,0.00),('5','131','744','188109',3681776,'2085','308',504285.33,504393.16,107.83,17576.29,0.00,0.00,0.00,0.00,0.00),('5','131','744','188109',3681777,'2086','308',232324.15,232518.89,194.74,31742.62,0.00,0.00,0.00,0.00,0.00),('5','131','745','188109',3681778,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','188109',3681779,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','188109',3681780,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','188109',3681781,'2090','309',100263.86,100263.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','188111',3681805,'2084','308',408116.69,409135.46,1018.77,166059.51,0.00,0.00,0.00,0.00,0.00),('5','131','744','188111',3681806,'2085','308',504393.16,506006.15,1612.99,262917.37,0.00,0.00,0.00,0.00,0.00),('5','131','744','188111',3681807,'2086','308',232518.89,233971.17,1452.28,236721.64,0.00,0.00,0.00,0.00,0.00),('5','131','745','188111',3681808,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','188111',3681809,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','188111',3681810,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','188111',3681811,'2090','309',100263.86,100263.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','188113',3681843,'2084','308',409135.46,411967.66,2832.20,461648.60,0.00,0.00,0.00,0.00,0.00),('5','131','744','188113',3681844,'2085','308',506006.15,510047.37,4041.22,658718.86,0.00,0.00,0.00,0.00,0.00),('5','131','744','188113',3681845,'2086','308',233971.17,237302.93,3331.76,543076.88,0.00,0.00,0.00,0.00,0.00),('5','131','745','188113',3681846,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','188113',3681847,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','188113',3681848,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','188113',3681849,'2090','309',100263.86,100263.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','188566',3689830,'2084','308',411967.66,414893.89,2926.23,476975.49,0.00,0.00,0.00,0.00,0.00),('5','131','744','188566',3689831,'2085','308',510047.37,515223.31,5175.94,843678.22,0.00,0.00,0.00,0.00,0.00),('5','131','744','188566',3689832,'2086','308',237302.93,241386.35,4083.42,665597.46,0.00,0.00,0.00,0.00,0.00),('5','131','745','188566',3689833,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','188566',3689834,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','188566',3689835,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','188566',3689836,'2090','309',100263.86,100263.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','188568',3689856,'2084','308',414893.89,416139.21,1245.32,202987.16,0.00,0.00,0.00,0.00,0.00),('5','131','744','188568',3689857,'2085','308',515223.31,520750.38,5527.07,900912.41,0.00,0.00,0.00,0.00,0.00),('5','131','744','188568',3689858,'2086','308',241386.35,244577.82,3191.47,520209.61,0.00,0.00,0.00,0.00,0.00),('5','131','745','188568',3689859,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','188568',3689860,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','188568',3689861,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','188568',3689862,'2090','309',100263.86,100472.34,208.48,55247.20,0.00,0.00,0.00,0.00,0.00),('5','131','744','188645',3690968,'2084','308',416139.21,416654.46,515.25,83985.75,0.00,0.00,0.00,0.00,0.00),('5','131','744','188645',3690969,'2085','308',520750.38,524983.14,4232.76,689939.88,0.00,0.00,0.00,0.00,0.00),('5','131','744','188645',3690970,'2086','308',244577.82,246745.31,2167.49,353300.87,0.00,0.00,0.00,0.00,0.00),('5','131','745','188645',3690971,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','188645',3690972,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','188645',3690973,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','188645',3690974,'2090','309',100472.34,100581.82,109.48,29012.20,0.00,0.00,0.00,0.00,0.00),('5','131','744','188942',3696448,'2084','308',416654.46,418830.40,2175.94,354678.22,0.00,0.00,0.00,0.00,0.00),('5','131','744','188942',3696449,'2085','308',524983.14,531135.28,6152.14,1002798.82,0.00,0.00,0.00,0.00,0.00),('5','131','744','188942',3696450,'2086','308',246745.31,249049.99,2304.68,375662.84,0.00,0.00,0.00,0.00,0.00),('5','131','745','188942',3696451,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','188942',3696452,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','188942',3696453,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','188942',3696454,'2090','309',100581.82,100754.68,172.86,45807.90,0.00,0.00,0.00,0.00,0.00),('5','131','744','189159',3700300,'2084','308',418830.40,424374.71,5544.31,903722.53,0.00,0.00,0.00,0.00,0.00),('5','131','744','189159',3700301,'2085','308',531135.28,536657.44,5522.16,900112.08,0.00,0.00,0.00,0.00,0.00),('5','131','744','189159',3700302,'2086','308',249049.99,251649.39,2599.40,423702.20,0.00,0.00,0.00,0.00,0.00),('5','131','745','189159',3700303,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','189159',3700304,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','189159',3700305,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','189159',3700306,'2090','309',100754.68,101016.30,261.62,69329.30,0.00,0.00,0.00,0.00,0.00),('5','131','744','189252',3701856,'2084','308',424374.71,425655.31,1280.60,208737.80,0.00,0.00,0.00,0.00,0.00),('5','131','744','189252',3701857,'2085','308',536657.44,543924.91,7267.47,1184597.61,0.00,0.00,0.00,0.00,0.00),('5','131','744','189252',3701858,'2086','308',251649.39,254523.91,2874.52,468546.76,0.00,0.00,0.00,0.00,0.00),('5','131','745','189252',3701859,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','189252',3701860,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','189252',3701861,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','189252',3701862,'2090','309',101016.30,101575.00,558.70,148055.50,0.00,0.00,0.00,0.00,0.00),('5','131','744','189524',3706781,'2084','308',425655.31,425655.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','189524',3706782,'2085','308',543924.91,543976.64,51.73,8431.99,0.00,0.00,0.00,0.00,0.00),('5','131','744','189524',3706783,'2086','308',254523.91,254599.23,75.32,12277.16,0.00,0.00,0.00,0.00,0.00),('5','131','745','189524',3706784,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','189524',3706785,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','189524',3706786,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','189524',3706787,'2090','309',101575.00,101940.76,365.76,96926.40,0.00,0.00,0.00,0.00,0.00),('5','131','744','189689',3709631,'2084','308',425655.31,425655.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','189689',3709632,'2085','308',543976.64,543976.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','189689',3709633,'2086','308',254599.23,254599.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','189689',3709634,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','189689',3709635,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','189689',3709636,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','189689',3709637,'2090','309',101940.76,102219.81,279.05,73948.25,0.00,0.00,0.00,0.00,0.00),('5','131','744','189970',3715006,'2084','308',425655.31,425655.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','189970',3715007,'2085','308',543976.64,543976.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','189970',3715008,'2086','308',254599.23,254599.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','189970',3715009,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','189970',3715010,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','189970',3715011,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','189970',3715012,'2090','309',102219.81,102519.40,299.59,79391.35,0.00,0.00,0.00,0.00,0.00),('5','131','744','190108',3717672,'2084','308',425655.31,425655.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','190108',3717673,'2085','308',543976.64,543976.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','190108',3717674,'2086','308',254599.23,254599.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','190108',3717675,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','190108',3717676,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','190108',3717677,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','190108',3717678,'2090','309',102519.40,102689.02,169.62,44949.30,0.00,0.00,0.00,0.00,0.00),('5','131','744','190252',3720247,'2084','308',425655.31,425655.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','190252',3720248,'2085','308',543976.64,543976.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','190252',3720249,'2086','308',254599.23,254599.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','190252',3720250,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','190252',3720251,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','190252',3720252,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','190252',3720253,'2090','309',102689.02,103064.55,375.53,99515.45,0.00,0.00,0.00,0.00,0.00),('5','131','744','190486',3724541,'2084','308',425655.31,425655.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','190486',3724542,'2085','308',543976.64,543976.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','190486',3724543,'2086','308',254599.23,254599.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','190486',3724544,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','190486',3724545,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','190486',3724546,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','190486',3724547,'2090','309',103064.55,103254.11,189.56,50233.40,0.00,0.00,0.00,0.00,0.00),('5','131','744','190756',3729756,'2084','308',425655.31,425655.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','190756',3729757,'2085','308',543976.64,543976.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','190756',3729758,'2086','308',254599.23,254599.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','190756',3729759,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','190756',3729760,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','190756',3729761,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','190756',3729762,'2090','309',103254.11,103826.52,572.41,151688.65,0.00,0.00,0.00,0.00,0.00),('5','131','744','190942',3732883,'2084','308',425655.31,425655.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','190942',3732884,'2085','308',543976.64,543976.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','190942',3732885,'2086','308',254599.23,254599.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','190942',3732886,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','190942',3732887,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','190942',3732888,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','190942',3732889,'2090','309',103826.52,104226.50,399.98,105994.70,0.00,0.00,0.00,0.00,0.00),('5','131','744','191195',3737441,'2084','308',425655.31,425655.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','191195',3737442,'2085','308',543976.64,543976.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','191195',3737443,'2086','308',254599.23,254599.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','191195',3737444,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','191195',3737445,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','191195',3737446,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','191195',3737447,'2090','309',104226.50,104433.67,207.17,54900.05,0.00,0.00,0.00,0.00,0.00),('5','131','744','191457',3742284,'2084','308',425655.31,425655.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','191457',3742285,'2085','308',543976.64,543976.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','191457',3742286,'2086','308',254599.23,254599.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','191457',3742287,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','191457',3742288,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','191457',3742289,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','191457',3742290,'2090','309',104433.67,104567.26,133.59,35401.35,0.00,0.00,0.00,0.00,0.00),('5','131','744','191608',3745023,'2084','308',425655.31,425655.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','191608',3745024,'2085','308',543976.64,543976.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','191608',3745025,'2086','308',254599.23,254599.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','191608',3745026,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','191608',3745027,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','191608',3745028,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','191608',3745029,'2090','309',104567.26,104785.96,218.70,57955.50,0.00,0.00,0.00,0.00,0.00),('5','131','744','191905',3751118,'2084','308',425655.31,425655.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','191905',3751119,'2085','308',543976.64,543976.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','191905',3751120,'2086','308',254599.23,254599.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','191905',3751121,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','191905',3751122,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','191905',3751123,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','191905',3751124,'2090','309',104785.96,105203.07,417.11,110534.15,0.00,0.00,0.00,0.00,0.00),('5','131','744','191984',3752174,'2084','308',425655.31,425655.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','191984',3752175,'2085','308',543976.64,543976.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','191984',3752176,'2086','308',254599.23,254599.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','191984',3752177,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','191984',3752178,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','191984',3752179,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','191984',3752180,'2090','309',105203.07,105582.81,379.74,100631.10,0.00,0.00,0.00,0.00,0.00),('5','131','744','192189',3755874,'2084','308',425655.31,425655.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','192189',3755875,'2085','308',543976.64,543976.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','192189',3755876,'2086','308',254599.23,254599.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','192189',3755877,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','192189',3755878,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','192189',3755879,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','192189',3755880,'2090','309',105582.81,106187.41,604.60,160219.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','192338',3758850,'2084','308',425655.31,428000.11,2344.80,386892.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','192338',3758851,'2085','308',543976.64,546589.05,2612.41,431047.65,0.00,0.00,0.00,0.00,0.00),('5','131','744','192338',3758852,'2086','308',254599.23,256287.29,1688.06,278529.90,0.00,0.00,0.00,0.00,0.00),('5','131','745','192338',3758853,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','192338',3758854,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','192338',3758855,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','192338',3758856,'2090','309',106187.41,106898.08,710.67,188327.55,0.00,0.00,0.00,0.00,0.00),('5','131','744','192725',3765791,'2084','308',428000.11,431271.02,3270.91,539700.15,0.00,0.00,0.00,0.00,0.00),('5','131','744','192725',3765792,'2085','308',546589.05,550957.24,4368.19,720751.35,0.00,0.00,0.00,0.00,0.00),('5','131','744','192725',3765793,'2086','308',256287.29,257475.08,1187.79,195985.35,0.00,0.00,0.00,0.00,0.00),('5','131','745','192725',3765794,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','192725',3765795,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','192725',3765796,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','192725',3765797,'2090','309',106898.08,107218.45,320.37,84898.05,0.00,0.00,0.00,0.00,0.00),('5','131','744','193502',3780499,'2084','308',431271.02,434318.50,3047.48,502834.20,0.00,0.00,0.00,0.00,0.00),('5','131','744','193502',3780500,'2085','308',550957.24,553899.14,2941.90,485413.50,0.00,0.00,0.00,0.00,0.00),('5','131','744','193502',3780501,'2086','308',257475.08,257975.82,500.74,82622.10,0.00,0.00,0.00,0.00,0.00),('5','131','745','193502',3780502,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','193502',3780503,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','193502',3780504,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','193502',3780505,'2090','309',107218.45,107723.31,504.86,133787.90,0.00,0.00,0.00,0.00,0.00),('5','131','744','193988',3789176,'2084','308',434318.50,436628.28,2309.78,381113.70,0.00,0.00,0.00,0.00,0.00),('5','131','744','193988',3789177,'2085','308',553899.14,556928.97,3029.83,499921.95,0.00,0.00,0.00,0.00,0.00),('5','131','744','193988',3789178,'2086','308',257975.82,258683.86,708.04,116826.60,0.00,0.00,0.00,0.00,0.00),('5','131','745','193988',3789179,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','193988',3789180,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','193988',3789181,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','193988',3789182,'2090','309',107723.31,107959.14,235.83,62494.95,0.00,0.00,0.00,0.00,0.00),('5','131','744','194132',3791621,'2084','308',436628.28,436633.41,5.13,846.45,0.00,0.00,0.00,0.00,0.00),('5','131','744','194132',3791622,'2085','308',556928.97,559943.04,3014.07,497321.55,0.00,0.00,0.00,0.00,0.00),('5','131','744','194132',3791623,'2086','308',258683.86,260430.68,1746.82,288225.30,0.00,0.00,0.00,0.00,0.00),('5','131','745','194132',3791624,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','194132',3791625,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','194132',3791626,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','194132',3791627,'2090','309',107959.14,108423.53,464.39,123063.35,0.00,0.00,0.00,0.00,0.00),('5','131','744','195587',3818174,'2084','308',436633.41,436633.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','195587',3818175,'2085','308',559943.04,563613.14,3670.10,605566.50,0.00,0.00,0.00,0.00,0.00),('5','131','744','195587',3818176,'2086','308',260430.68,262509.53,2078.85,343010.25,0.00,0.00,0.00,0.00,0.00),('5','131','745','195587',3818177,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','195587',3818178,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','195587',3818179,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','195587',3818180,'2090','309',108423.53,108835.26,411.73,109108.45,0.00,0.00,0.00,0.00,0.00),('5','131','744','195590',3818214,'2084','308',436633.41,436633.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','195590',3818215,'2085','308',563613.14,564309.12,695.98,114836.70,0.00,0.00,0.00,0.00,0.00),('5','131','744','195590',3818216,'2086','308',262509.53,262851.14,341.61,56365.65,0.00,0.00,0.00,0.00,0.00),('5','131','745','195590',3818217,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','195590',3818218,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','195590',3818219,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','195590',3818220,'2090','309',108835.26,109138.96,303.70,80480.50,0.00,0.00,0.00,0.00,0.00),('5','131','744','195593',3818250,'2084','308',436633.41,436633.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','195593',3818251,'2085','308',564309.12,564309.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','195593',3818252,'2086','308',262851.14,262851.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','195593',3818253,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','195593',3818254,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','195593',3818255,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','195593',3818256,'2090','309',109138.96,109541.56,402.60,106689.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','195596',3818304,'2084','308',436633.41,436633.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','195596',3818305,'2085','308',564309.12,564309.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','195596',3818306,'2086','308',262851.14,262851.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','195596',3818307,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','195596',3818308,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','195596',3818309,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','195596',3818310,'2090','309',109541.56,109871.58,330.02,87455.30,0.00,0.00,0.00,0.00,0.00),('5','131','744','195599',3818407,'2084','308',436633.41,436633.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','195599',3818408,'2085','308',564309.12,564309.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','195599',3818409,'2086','308',262851.14,262851.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','195599',3818410,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','195599',3818411,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','195599',3818412,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','195599',3818413,'2090','309',109871.58,110328.70,457.12,121136.80,0.00,0.00,0.00,0.00,0.00),('5','131','744','195600',3818414,'2084','308',436633.41,437566.99,933.58,154040.70,0.00,0.00,0.00,0.00,0.00),('5','131','744','195600',3818415,'2085','308',564309.12,565307.66,998.54,164759.10,0.00,0.00,0.00,0.00,0.00),('5','131','744','195600',3818416,'2086','308',262851.14,262851.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','195600',3818417,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','195600',3818418,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','195600',3818419,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','195600',3818420,'2090','309',110328.70,110707.00,378.30,100249.50,0.00,0.00,0.00,0.00,0.00),('5','131','744','195602',3818461,'2084','308',437566.99,438963.74,1396.75,230463.75,0.00,0.00,0.00,0.00,0.00),('5','131','744','195602',3818462,'2085','308',565307.66,566971.94,1664.28,274606.20,0.00,0.00,0.00,0.00,0.00),('5','131','744','195602',3818463,'2086','308',262851.14,263719.53,868.39,143284.35,0.00,0.00,0.00,0.00,0.00),('5','131','745','195602',3818464,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','195602',3818465,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','195602',3818466,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','195602',3818467,'2090','309',110707.00,111077.30,370.30,98129.50,0.00,0.00,0.00,0.00,0.00),('5','131','744','195605',3818513,'2084','308',438963.74,441239.38,2275.64,375480.60,0.00,0.00,0.00,0.00,0.00),('5','131','744','195605',3818514,'2085','308',566971.94,566971.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','195605',3818515,'2086','308',263719.53,265787.88,2068.35,341277.75,0.00,0.00,0.00,0.00,0.00),('5','131','745','195605',3818516,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','195605',3818517,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','195605',3818518,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','195605',3818519,'2090','309',111077.30,111273.19,195.89,51910.85,0.00,0.00,0.00,0.00,0.00),('5','131','744','195609',3818596,'2084','308',441239.38,443985.07,2745.69,453038.85,0.00,0.00,0.00,0.00,0.00),('5','131','744','195609',3818597,'2085','308',566971.94,566971.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','195609',3818598,'2086','308',265787.88,268032.33,2244.45,370334.25,0.00,0.00,0.00,0.00,0.00),('5','131','745','195609',3818599,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','195609',3818600,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','195609',3818601,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','195609',3818602,'2090','309',111273.19,111556.19,283.00,74995.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','195610',3818603,'2084','308',443985.07,446319.39,2334.32,385162.80,0.00,0.00,0.00,0.00,0.00),('5','131','744','195610',3818604,'2085','308',566971.94,566971.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','195610',3818605,'2086','308',268032.33,269996.66,1964.33,324114.45,0.00,0.00,0.00,0.00,0.00),('5','131','745','195610',3818606,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','195610',3818607,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','195610',3818608,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','195610',3818609,'2090','309',111556.19,111972.94,416.75,110438.75,0.00,0.00,0.00,0.00,0.00),('5','131','744','195666',3819367,'2084','308',446319.39,448333.27,2013.88,332290.20,0.00,0.00,0.00,0.00,0.00),('5','131','744','195666',3819368,'2085','308',566971.94,566971.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','195666',3819369,'2086','308',269996.66,271984.83,1988.17,328048.05,0.00,0.00,0.00,0.00,0.00),('5','131','745','195666',3819370,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','195666',3819371,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','195666',3819372,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','195666',3819373,'2090','309',111972.94,112251.24,278.30,73749.50,0.00,0.00,0.00,0.00,0.00),('5','131','744','195936',3824350,'2084','308',448333.27,448983.19,649.92,107236.80,0.00,0.00,0.00,0.00,0.00),('5','131','744','195936',3824351,'2085','308',566971.94,566971.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','195936',3824352,'2086','308',271984.83,273907.15,1922.32,317182.80,0.00,0.00,0.00,0.00,0.00),('5','131','745','195936',3824353,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','195936',3824354,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','195936',3824355,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','195936',3824356,'2090','309',112251.24,112599.66,348.42,92331.30,0.00,0.00,0.00,0.00,0.00),('5','131','744','196049',3826293,'2084','308',448983.19,451538.80,2555.61,421675.65,0.00,0.00,0.00,0.00,0.00),('5','131','744','196049',3826294,'2085','308',566971.94,566971.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','196049',3826295,'2086','308',273907.15,275850.21,1943.06,320604.90,0.00,0.00,0.00,0.00,0.00),('5','131','745','196049',3826296,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','196049',3826297,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','196049',3826298,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','196049',3826299,'2090','309',112599.66,112820.38,220.72,58490.80,0.00,0.00,0.00,0.00,0.00),('5','131','744','196533',3835328,'2084','308',451538.80,454802.42,3263.62,538497.30,0.00,0.00,0.00,0.00,0.00),('5','131','744','196533',3835329,'2085','308',566971.94,566971.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','196533',3835330,'2086','308',275850.21,277058.49,1208.28,199366.20,0.00,0.00,0.00,0.00,0.00),('5','131','745','196533',3835331,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','196533',3835332,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','196533',3835333,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','196533',3835334,'2090','309',112820.38,113054.95,234.57,62161.05,0.00,0.00,0.00,0.00,0.00),('5','131','744','196738',3838882,'2084','308',454802.42,456210.59,1408.17,232348.05,0.00,0.00,0.00,0.00,0.00),('5','131','744','196738',3838883,'2085','308',566971.94,566971.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','196738',3838884,'2086','308',277058.49,279194.41,2135.92,352426.80,0.00,0.00,0.00,0.00,0.00),('5','131','745','196738',3838885,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','196738',3838886,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','196738',3838887,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','196738',3838888,'2090','309',113054.95,113274.93,219.98,58294.70,0.00,0.00,0.00,0.00,0.00),('5','131','744','196834',3840748,'2084','308',456210.59,456210.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','196834',3840749,'2085','308',566971.94,566971.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','196834',3840750,'2086','308',279194.41,281364.70,2170.29,358097.85,0.00,0.00,0.00,0.00,0.00),('5','131','745','196834',3840751,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','196834',3840752,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','196834',3840753,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','196834',3840754,'2090','309',113274.93,113530.82,255.89,67810.85,0.00,0.00,0.00,0.00,0.00),('5','131','744','197048',3844433,'2084','308',456210.59,456210.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','197048',3844434,'2085','308',566971.94,567569.53,597.59,98602.35,0.00,0.00,0.00,0.00,0.00),('5','131','744','197048',3844435,'2086','308',281364.70,282135.98,771.28,127261.20,0.00,0.00,0.00,0.00,0.00),('5','131','745','197048',3844436,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','197048',3844437,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','197048',3844438,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','197048',3844439,'2090','309',113530.82,113821.95,291.13,77149.45,0.00,0.00,0.00,0.00,0.00),('5','131','744','197432',3850816,'2084','308',456210.59,458593.91,2383.32,393247.80,0.00,0.00,0.00,0.00,0.00),('5','131','744','197432',3850817,'2085','308',567569.53,567569.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','197432',3850818,'2086','308',282135.98,284493.09,2357.11,388923.15,0.00,0.00,0.00,0.00,0.00),('5','131','745','197432',3850819,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','197432',3850820,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','197432',3850821,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','197432',3850822,'2090','309',113821.95,113988.91,166.96,44244.40,0.00,0.00,0.00,0.00,0.00),('5','131','744','197713',3855889,'2084','308',458593.91,458593.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','197713',3855890,'2085','308',567569.53,571303.79,3734.26,616152.90,0.00,0.00,0.00,0.00,0.00),('5','131','744','197713',3855891,'2086','308',284493.09,287685.58,3192.49,526760.85,0.00,0.00,0.00,0.00,0.00),('5','131','745','197713',3855892,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','197713',3855893,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','197713',3855894,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','197713',3855895,'2090','309',113988.91,114240.89,21.98,5824.70,0.00,0.00,230.00,0.00,0.00),('5','131','744','198305',3866389,'2084','308',458593.91,459334.16,740.25,122141.25,0.00,0.00,0.00,0.00,0.00),('5','131','744','198305',3866390,'2085','308',571303.79,571983.96,680.17,112228.05,0.00,0.00,0.00,0.00,0.00),('5','131','744','198305',3866391,'2086','308',287685.58,287685.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','198305',3866392,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','198305',3866393,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','198305',3866394,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','198305',3866395,'2090','309',114240.89,114261.45,20.56,5551.20,0.00,0.00,0.00,0.00,0.00),('5','131','744','198308',3866436,'2084','308',459334.16,459716.66,382.50,63112.50,0.00,0.00,0.00,0.00,0.00),('5','131','744','198308',3866437,'2085','308',571983.96,573612.11,1628.15,268644.75,0.00,0.00,0.00,0.00,0.00),('5','131','744','198308',3866438,'2086','308',287685.58,288833.31,1147.73,189375.45,0.00,0.00,0.00,0.00,0.00),('5','131','745','198308',3866439,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','198308',3866440,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','198308',3866441,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','198308',3866442,'2090','309',114261.45,114517.90,256.45,69241.50,0.00,0.00,0.00,0.00,0.00),('5','131','744','198511',3869933,'2084','308',459716.66,460300.05,583.39,96259.35,0.00,0.00,0.00,0.00,0.00),('5','131','744','198511',3869934,'2085','308',573612.11,575224.31,1612.20,266013.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','198511',3869935,'2086','308',288833.31,290833.34,2000.03,330004.95,0.00,0.00,0.00,0.00,0.00),('5','131','745','198511',3869936,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','198511',3869937,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','198511',3869938,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','198511',3869939,'2090','309',114517.90,115219.51,701.61,189434.70,0.00,0.00,0.00,0.00,0.00),('5','131','744','198760',3874030,'2084','308',460300.05,460300.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','198760',3874031,'2085','308',575224.31,578010.84,2786.53,459777.45,0.00,0.00,0.00,0.00,0.00),('5','131','744','198760',3874032,'2086','308',290833.34,291759.58,926.24,152829.60,0.00,0.00,0.00,0.00,0.00),('5','131','745','198760',3874033,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','198760',3874034,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','198760',3874035,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','198760',3874036,'2090','309',115219.51,115689.35,469.84,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','199184',3881555,'2084','308',460300.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','199184',3881556,'2085','308',578010.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','199184',3881557,'2086','308',291759.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','199184',3881558,'2087','308',360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','199184',3881559,'2088','308',607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','199184',3881560,'2089','308',83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','199184',3881561,'2090','309',115689.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','199269',3882686,'2084','308',460300.05,460300.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','199269',3882687,'2085','308',578010.84,579328.10,1317.26,217347.90,0.00,0.00,0.00,0.00,0.00),('5','131','744','199269',3882688,'2086','308',291759.58,293088.59,1329.01,219286.65,0.00,0.00,0.00,0.00,0.00),('5','131','745','199269',3882689,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','199269',3882690,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','199269',3882691,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','199269',3882692,'2090','309',115689.35,116163.50,474.15,128020.50,0.00,0.00,0.00,0.00,0.00),('5','131','744','199282',3882782,'2084','308',460300.05,461331.50,1031.45,170189.25,0.00,0.00,0.00,0.00,0.00),('5','131','744','199282',3882783,'2085','308',579328.10,581074.26,1746.16,288116.40,0.00,0.00,0.00,0.00,0.00),('5','131','744','199282',3882784,'2086','308',293088.59,294205.30,1116.71,184257.15,0.00,0.00,0.00,0.00,0.00),('5','131','745','199282',3882785,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','199282',3882786,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','199282',3882787,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','199282',3882788,'2090','309',116163.50,116688.46,524.96,141739.20,0.00,0.00,0.00,0.00,0.00),('5','131','744','199285',3882796,'2084','308',461331.50,462146.10,814.60,134409.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','199285',3882797,'2085','308',581074.26,582852.51,1778.25,293411.25,0.00,0.00,0.00,0.00,0.00),('5','131','744','199285',3882798,'2086','308',294205.30,296450.70,2245.40,370491.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','199285',3882799,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','199285',3882800,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','199285',3882801,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','199285',3882802,'2090','309',116688.46,117230.48,542.02,146345.40,0.00,0.00,0.00,0.00,0.00),('5','131','744','199553',3887460,'2084','308',462146.10,463349.63,1203.53,198582.45,0.00,0.00,0.00,0.00,0.00),('5','131','744','199553',3887461,'2085','308',582852.51,584671.53,1819.02,300138.30,0.00,0.00,0.00,0.00,0.00),('5','131','744','199553',3887462,'2086','308',296450.70,298286.54,1835.84,302913.60,0.00,0.00,0.00,0.00,0.00),('5','131','745','199553',3887463,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','199553',3887464,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','199553',3887465,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','199553',3887466,'2090','309',117230.48,117613.07,382.59,103299.30,0.00,0.00,0.00,0.00,0.00),('5','131','744','199758',3890645,'2084','308',463349.63,463349.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','199758',3890646,'2085','308',584671.53,587094.01,2422.48,399709.20,0.00,0.00,0.00,0.00,0.00),('5','131','744','199758',3890647,'2086','308',298286.54,300396.57,2110.03,348154.95,0.00,0.00,0.00,0.00,0.00),('5','131','745','199758',3890648,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','199758',3890649,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','199758',3890650,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','199758',3890651,'2090','309',117613.07,118334.80,721.73,194867.10,0.00,0.00,0.00,0.00,0.00),('5','131','744','199903',3892961,'2084','308',463349.63,464664.96,1315.33,217029.45,0.00,0.00,0.00,0.00,0.00),('5','131','744','199903',3892962,'2085','308',587094.01,588498.05,1404.04,231666.60,0.00,0.00,0.00,0.00,0.00),('5','131','744','199903',3892963,'2086','308',300396.57,300838.42,441.85,72905.25,0.00,0.00,0.00,0.00,0.00),('5','131','745','199903',3892964,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','199903',3892965,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','199903',3892966,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','199903',3892967,'2090','309',118334.80,118533.04,198.24,53524.80,0.00,0.00,0.00,0.00,0.00),('5','131','744','200098',3896781,'2084','308',464664.96,464664.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','200098',3896782,'2085','308',588498.05,591365.40,2867.35,473112.75,0.00,0.00,0.00,0.00,0.00),('5','131','744','200098',3896783,'2086','308',300838.42,303979.90,3141.48,518344.20,0.00,0.00,0.00,0.00,0.00),('5','131','745','200098',3896784,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','200098',3896785,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','200098',3896786,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','200098',3896787,'2090','309',118533.04,118726.24,193.20,52164.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','200344',3900932,'2084','308',464664.96,464664.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','200344',3900933,'2085','308',591365.40,594223.13,2857.73,471525.45,0.00,0.00,0.00,0.00,0.00),('5','131','744','200344',3900934,'2086','308',303979.90,307157.48,3177.58,524300.70,0.00,0.00,0.00,0.00,0.00),('5','131','745','200344',3900935,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','200344',3900936,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','200344',3900937,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','200344',3900938,'2090','309',118726.24,118977.82,251.58,67926.60,0.00,0.00,0.00,0.00,0.00),('5','131','744','200745',3908304,'2084','308',464664.96,466137.64,1472.68,242992.20,0.00,0.00,0.00,0.00,0.00),('5','131','744','200745',3908305,'2085','308',594223.13,597119.38,2896.25,477881.25,0.00,0.00,0.00,0.00,0.00),('5','131','744','200745',3908306,'2086','308',307157.48,308409.29,1251.81,206548.65,0.00,0.00,0.00,0.00,0.00),('5','131','745','200745',3908307,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','200745',3908308,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','200745',3908309,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','200745',3908310,'2090','309',118977.82,119200.58,222.76,60145.20,0.00,0.00,0.00,0.00,0.00),('5','131','744','200841',3910208,'2084','308',466137.64,466137.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','200841',3910209,'2085','308',597119.38,600023.93,2904.55,479250.75,0.00,0.00,0.00,0.00,0.00),('5','131','744','200841',3910210,'2086','308',308409.29,310773.57,2364.28,390106.20,0.00,0.00,0.00,0.00,0.00),('5','131','745','200841',3910211,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','200841',3910212,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','200841',3910213,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','200841',3910214,'2090','309',119200.58,119670.38,469.80,126846.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','200915',3911446,'2084','308',466137.64,467301.63,1163.99,192058.35,0.00,0.00,0.00,0.00,0.00),('5','131','744','200915',3911447,'2085','308',600023.93,602537.98,2514.05,414818.25,0.00,0.00,0.00,0.00,0.00),('5','131','744','200915',3911448,'2086','308',310773.57,311904.32,1130.75,186573.75,0.00,0.00,0.00,0.00,0.00),('5','131','745','200915',3911449,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','200915',3911450,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','200915',3911451,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','200915',3911452,'2090','309',119670.38,120018.08,347.70,93879.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','201193',3915867,'2084','308',467301.63,469906.88,2605.25,429866.25,0.00,0.00,0.00,0.00,0.00),('5','131','744','201193',3915868,'2085','308',602537.98,605363.91,2825.93,466278.45,0.00,0.00,0.00,0.00,0.00),('5','131','744','201193',3915869,'2086','308',311904.32,311904.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','201193',3915870,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','201193',3915871,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','201193',3915872,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','201193',3915873,'2090','309',120018.08,120649.22,631.14,170407.80,0.00,0.00,0.00,0.00,0.00),('5','131','744','201316',3918087,'2084','308',469906.88,471177.95,1271.07,209726.55,0.00,0.00,0.00,0.00,0.00),('5','131','744','201316',3918088,'2085','308',605363.91,607379.40,2015.49,332555.85,0.00,0.00,0.00,0.00,0.00),('5','131','744','201316',3918089,'2086','308',311904.32,313278.65,1374.33,226764.45,0.00,0.00,0.00,0.00,0.00),('5','131','745','201316',3918090,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','201316',3918091,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','201316',3918092,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','201316',3918093,'2090','309',120649.22,120921.10,271.88,73407.60,0.00,0.00,0.00,0.00,0.00),('5','131','744','201713',3925780,'2084','308',471177.95,473430.41,2252.46,371655.90,0.00,0.00,0.00,0.00,0.00),('5','131','744','201713',3925781,'2085','308',607379.40,609925.28,2545.88,420070.20,0.00,0.00,0.00,0.00,0.00),('5','131','744','201713',3925782,'2086','308',313278.65,313278.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','201713',3925783,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','201713',3925784,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','201713',3925785,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','201713',3925786,'2090','309',120921.10,121333.69,412.59,111399.30,0.00,0.00,0.00,0.00,0.00),('5','131','744','202009',3931397,'2084','308',473430.41,476230.62,2800.21,462034.65,0.00,0.00,0.00,0.00,0.00),('5','131','744','202009',3931398,'2085','308',609925.28,609925.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','202009',3931399,'2086','308',313278.65,315783.15,2504.50,413242.50,0.00,0.00,0.00,0.00,0.00),('5','131','745','202009',3931400,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','202009',3931401,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','202009',3931402,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','202009',3931403,'2090','309',121333.69,121506.47,172.78,47514.50,0.00,0.00,0.00,0.00,0.00),('5','131','744','202041',3931729,'2084','308',476230.62,478278.00,2047.38,337817.70,0.00,0.00,0.00,0.00,0.00),('5','131','744','202041',3931730,'2085','308',609925.28,609977.90,52.62,8682.30,0.00,0.00,0.00,0.00,0.00),('5','131','744','202041',3931731,'2086','308',315783.15,318227.70,2444.55,403350.75,0.00,0.00,0.00,0.00,0.00),('5','131','745','202041',3931732,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','202041',3931733,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','202041',3931734,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','202041',3931735,'2090','309',121506.47,121900.87,394.40,108460.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','202407',3938180,'2084','308',478278.00,480224.70,1946.70,321205.50,0.00,0.00,0.00,0.00,0.00),('5','131','744','202407',3938181,'2085','308',609977.90,610372.84,394.94,65165.10,0.00,0.00,0.00,0.00,0.00),('5','131','744','202407',3938182,'2086','308',318227.70,320444.34,2216.64,365745.60,0.00,0.00,0.00,0.00,0.00),('5','131','745','202407',3938183,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','202407',3938184,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','202407',3938185,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','202407',3938186,'2090','309',121900.87,122231.75,330.88,90992.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','202420',3938355,'2084','308',480224.70,480994.78,770.08,127063.20,0.00,0.00,0.00,0.00,0.00),('5','131','744','202420',3938356,'2085','308',610372.84,612339.13,1966.29,324437.85,0.00,0.00,0.00,0.00,0.00),('5','131','744','202420',3938357,'2086','308',320444.34,322672.53,2228.19,367651.35,0.00,0.00,0.00,0.00,0.00),('5','131','745','202420',3938358,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','202420',3938359,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','202420',3938360,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','202420',3938361,'2090','309',122231.75,122651.37,419.62,115395.50,0.00,0.00,0.00,0.00,0.00),('5','131','744','202643',3942173,'2084','308',480994.78,480995.84,1.06,174.90,0.00,0.00,0.00,0.00,0.00),('5','131','744','202643',3942174,'2085','308',612339.13,615127.19,2788.06,460029.90,0.00,0.00,0.00,0.00,0.00),('5','131','744','202643',3942175,'2086','308',322672.53,324800.30,2127.77,351082.05,0.00,0.00,0.00,0.00,0.00),('5','131','745','202643',3942176,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','202643',3942177,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','202643',3942178,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','202643',3942179,'2090','309',122651.37,123046.61,395.24,108691.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','202880',3946233,'2084','308',480995.84,481984.66,988.82,163155.30,0.00,0.00,0.00,0.00,0.00),('5','131','744','202880',3946234,'2085','308',615127.19,617116.54,1989.35,328242.75,0.00,0.00,0.00,0.00,0.00),('5','131','744','202880',3946235,'2086','308',324800.30,325475.76,675.46,111450.90,0.00,0.00,0.00,0.00,0.00),('5','131','745','202880',3946236,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','202880',3946237,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','202880',3946238,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','202880',3946239,'2090','309',123046.61,123412.47,365.86,100611.50,0.00,0.00,0.00,0.00,0.00),('5','131','744','203188',3952146,'2084','308',481984.66,483041.05,1056.39,174304.35,0.00,0.00,0.00,0.00,0.00),('5','131','744','203188',3952147,'2085','308',617116.54,619787.18,2670.64,440655.60,0.00,0.00,0.00,0.00,0.00),('5','131','744','203188',3952148,'2086','308',325475.76,326949.45,1473.69,243158.85,0.00,0.00,0.00,0.00,0.00),('5','131','745','203188',3952149,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','203188',3952150,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','203188',3952151,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','203188',3952152,'2090','309',123412.47,123745.90,333.43,91693.25,0.00,0.00,0.00,0.00,0.00),('5','131','744','203293',3954322,'2084','308',483041.05,484086.21,1045.16,172451.40,0.00,0.00,0.00,0.00,0.00),('5','131','744','203293',3954323,'2085','308',619787.18,622455.61,2668.43,440290.95,0.00,0.00,0.00,0.00,0.00),('5','131','744','203293',3954324,'2086','308',326949.45,328163.82,1214.37,200371.05,0.00,0.00,0.00,0.00,0.00),('5','131','745','203293',3954325,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','203293',3954326,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','203293',3954327,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','203293',3954328,'2090','309',123745.90,124120.71,374.81,103072.75,0.00,0.00,0.00,0.00,0.00),('5','131','744','203513',3958226,'2084','308',484086.21,485115.92,1029.71,169902.15,0.00,0.00,0.00,0.00,0.00),('5','131','744','203513',3958227,'2085','308',622455.61,624582.94,2127.33,351009.45,0.00,0.00,0.00,0.00,0.00),('5','131','744','203513',3958228,'2086','308',328163.82,329276.16,1112.34,183536.10,0.00,0.00,0.00,0.00,0.00),('5','131','745','203513',3958229,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','203513',3958230,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','203513',3958231,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','203513',3958232,'2090','309',124120.71,124735.88,615.17,169171.75,0.00,0.00,0.00,0.00,0.00),('5','131','744','203714',3961893,'2084','308',485115.92,486542.40,1426.48,235369.20,0.00,0.00,0.00,0.00,0.00),('5','131','744','203714',3961894,'2085','308',624582.94,625683.63,1100.69,181613.85,0.00,0.00,0.00,0.00,0.00),('5','131','744','203714',3961895,'2086','308',329276.16,331450.98,2174.82,358845.30,0.00,0.00,0.00,0.00,0.00),('5','131','745','203714',3961896,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','203714',3961897,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','203714',3961898,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','203714',3961899,'2090','309',124735.88,125279.76,543.88,149567.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','203992',3966400,'2084','308',486542.40,487860.27,1317.87,217448.55,0.00,0.00,0.00,0.00,0.00),('5','131','744','203992',3966401,'2085','308',625683.63,627656.33,1972.70,325495.50,0.00,0.00,0.00,0.00,0.00),('5','131','744','203992',3966402,'2086','308',331450.98,332297.59,846.61,139690.65,0.00,0.00,0.00,0.00,0.00),('5','131','745','203992',3966403,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','203992',3966404,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','203992',3966405,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','203992',3966406,'2090','309',125279.76,125498.98,219.22,60285.50,0.00,0.00,0.00,0.00,0.00),('5','131','744','204180',3970291,'2084','308',487860.27,489330.08,1469.81,242518.65,0.00,0.00,0.00,0.00,0.00),('5','131','744','204180',3970292,'2085','308',627656.33,629960.84,2304.51,380244.15,0.00,0.00,0.00,0.00,0.00),('5','131','744','204180',3970293,'2086','308',332297.59,332889.31,591.72,97633.80,0.00,0.00,0.00,0.00,0.00),('5','131','745','204180',3970294,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','204180',3970295,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','204180',3970296,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','204180',3970297,'2090','309',125498.98,125973.76,474.78,130564.50,0.00,0.00,0.00,0.00,0.00),('5','131','744','204431',3974455,'2084','308',489330.08,491799.43,2469.35,407442.75,0.00,0.00,0.00,0.00,0.00),('5','131','744','204431',3974456,'2085','308',629960.84,631987.28,2026.44,334362.60,0.00,0.00,0.00,0.00,0.00),('5','131','744','204431',3974457,'2086','308',332889.31,332889.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','204431',3974458,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','204431',3974459,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','204431',3974460,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','204431',3974461,'2090','309',125973.76,126296.27,322.51,88690.25,0.00,0.00,0.00,0.00,0.00),('5','131','744','204601',3977863,'2084','308',491799.43,493157.25,1357.82,224040.30,0.00,0.00,0.00,0.00,0.00),('5','131','744','204601',3977864,'2085','308',631987.28,634577.23,2589.95,427341.75,0.00,0.00,0.00,0.00,0.00),('5','131','744','204601',3977865,'2086','308',332889.31,333701.50,812.19,134011.35,0.00,0.00,0.00,0.00,0.00),('5','131','745','204601',3977866,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','204601',3977867,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','204601',3977868,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','204601',3977869,'2090','309',126296.27,126718.86,422.59,116212.25,0.00,0.00,0.00,0.00,0.00),('5','131','744','204853',3981783,'2084','308',493157.25,493157.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','204853',3981784,'2085','308',634577.23,636748.59,2171.36,358274.40,0.00,0.00,0.00,0.00,0.00),('5','131','744','204853',3981785,'2086','308',333701.50,335458.59,1757.09,289919.85,0.00,0.00,0.00,0.00,0.00),('5','131','745','204853',3981786,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','204853',3981787,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','204853',3981788,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','204853',3981789,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','205088',3985877,'2084','308',493157.25,494316.73,1159.48,191314.20,0.00,0.00,0.00,0.00,0.00),('5','131','744','205088',3985878,'2085','308',636748.59,637799.43,1050.84,173388.60,0.00,0.00,0.00,0.00,0.00),('5','131','744','205088',3985879,'2086','308',335458.59,337288.17,1829.58,301880.70,0.00,0.00,0.00,0.00,0.00),('5','131','745','205088',3985880,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','205088',3985881,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','205088',3985882,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','205088',3985883,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','205290',3989611,'2084','308',494316.73,495367.10,1050.37,173311.05,0.00,0.00,0.00,0.00,0.00),('5','131','744','205290',3989612,'2085','308',637799.43,640575.99,2776.56,458132.40,0.00,0.00,0.00,0.00,0.00),('5','131','744','205290',3989613,'2086','308',337288.17,338308.65,1020.48,168379.20,0.00,0.00,0.00,0.00,0.00),('5','131','745','205290',3989614,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','205290',3989615,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','205290',3989616,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','205290',3989617,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','205532',3993984,'2084','308',495367.10,496829.62,1462.52,241315.80,0.00,0.00,0.00,0.00,0.00),('5','131','744','205532',3993985,'2085','308',640575.99,641837.54,1261.55,208155.75,0.00,0.00,0.00,0.00,0.00),('5','131','744','205532',3993986,'2086','308',338308.65,339350.83,1042.18,171959.70,0.00,0.00,0.00,0.00,0.00),('5','131','745','205532',3993987,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','205532',3993988,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','205532',3993989,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','205532',3993990,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','205879',4000478,'2084','308',496829.62,498546.20,1716.58,283235.70,0.00,0.00,0.00,0.00,0.00),('5','131','744','205879',4000479,'2085','308',641837.54,643284.60,1447.06,238764.90,0.00,0.00,0.00,0.00,0.00),('5','131','744','205879',4000480,'2086','308',339350.83,340874.33,1523.50,251377.50,0.00,0.00,0.00,0.00,0.00),('5','131','745','205879',4000481,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','205879',4000482,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','205879',4000483,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','205879',4000484,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','205942',4001555,'2084','308',498546.20,500179.07,1632.87,269423.55,0.00,0.00,0.00,0.00,0.00),('5','131','744','205942',4001556,'2085','308',643284.60,644843.61,1559.01,257236.65,0.00,0.00,0.00,0.00,0.00),('5','131','744','205942',4001557,'2086','308',340874.33,342532.13,1657.80,273537.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','205942',4001558,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','205942',4001559,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','205942',4001560,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','205942',4001561,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','206207',4006179,'2084','308',500179.07,501420.99,1241.92,204916.80,0.00,0.00,0.00,0.00,0.00),('5','131','744','206207',4006180,'2085','308',644843.61,647682.03,2838.42,468339.30,0.00,0.00,0.00,0.00,0.00),('5','131','744','206207',4006181,'2086','308',342532.13,344136.62,1604.49,264740.85,0.00,0.00,0.00,0.00,0.00),('5','131','745','206207',4006182,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','206207',4006183,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','206207',4006184,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','206207',4006185,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','206596',4012886,'2084','308',501420.99,502616.69,1195.70,197290.50,0.00,0.00,0.00,0.00,0.00),('5','131','744','206596',4012887,'2085','308',647682.03,650530.78,2848.75,470043.75,0.00,0.00,0.00,0.00,0.00),('5','131','744','206596',4012888,'2086','308',344136.62,346450.05,2313.43,381715.95,0.00,0.00,0.00,0.00,0.00),('5','131','745','206596',4012889,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','206596',4012890,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','206596',4012891,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','206596',4012892,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','206646',4013805,'2084','308',502616.69,503779.28,1162.59,191827.35,0.00,0.00,0.00,0.00,0.00),('5','131','744','206646',4013806,'2085','308',650530.78,652989.28,2458.50,405652.50,0.00,0.00,0.00,0.00,0.00),('5','131','744','206646',4013807,'2086','308',346450.05,347367.14,917.09,151319.85,0.00,0.00,0.00,0.00,0.00),('5','131','745','206646',4013808,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','206646',4013809,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','206646',4013810,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','206646',4013811,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','206781',4016326,'2084','308',503779.28,503779.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','206781',4016327,'2085','308',652989.28,655473.97,2484.69,409973.85,0.00,0.00,0.00,0.00,0.00),('5','131','744','206781',4016328,'2086','308',347367.14,349237.38,1870.24,308589.60,0.00,0.00,0.00,0.00,0.00),('5','131','745','206781',4016329,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','206781',4016330,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','206781',4016331,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','206781',4016332,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','207102',4021860,'2084','308',503779.28,503779.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','207102',4021861,'2085','308',655473.97,656309.71,835.74,137897.10,0.00,0.00,0.00,0.00,0.00),('5','131','744','207102',4021862,'2086','308',349237.38,349970.50,733.12,120964.80,0.00,0.00,0.00,0.00,0.00),('5','131','745','207102',4021863,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','207102',4021864,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','207102',4021865,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','207102',4021866,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','207325',4025945,'2084','308',503779.28,503779.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','207325',4025946,'2085','308',656309.71,656309.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','207325',4025947,'2086','308',349970.50,349970.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','207325',4025948,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','207325',4025949,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','207325',4025950,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','207325',4025951,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','207666',4031996,'2084','308',503779.28,504868.95,1089.67,179795.55,0.00,0.00,0.00,0.00,0.00),('5','131','744','207666',4031997,'2085','308',656309.71,656710.15,400.44,66072.60,0.00,0.00,0.00,0.00,0.00),('5','131','744','207666',4031998,'2086','308',349970.50,350571.17,600.67,99110.55,0.00,0.00,0.00,0.00,0.00),('5','131','745','207666',4031999,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','207666',4032000,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','207666',4032001,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','207666',4032002,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','207713',4032695,'2084','308',504868.95,505139.13,270.18,44579.70,0.00,0.00,0.00,0.00,0.00),('5','131','744','207713',4032696,'2085','308',656710.15,659204.20,2494.05,411518.25,0.00,0.00,0.00,0.00,0.00),('5','131','744','207713',4032697,'2086','308',350571.17,352233.29,1662.12,274249.80,0.00,0.00,0.00,0.00,0.00),('5','131','745','207713',4032698,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','207713',4032699,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','207713',4032700,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','207713',4032701,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','208224',4041721,'2084','308',505139.13,505139.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','208224',4041722,'2085','308',659204.20,661521.10,2316.90,382288.50,0.00,0.00,0.00,0.00,0.00),('5','131','744','208224',4041723,'2086','308',352233.29,354647.96,2414.67,398420.55,0.00,0.00,0.00,0.00,0.00),('5','131','745','208224',4041724,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','208224',4041725,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','208224',4041726,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','208224',4041727,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','208300',4043271,'2084','308',505139.13,505139.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','208300',4043272,'2085','308',661521.10,663608.93,2087.83,344491.95,0.00,0.00,0.00,0.00,0.00),('5','131','744','208300',4043273,'2086','308',354647.96,356563.24,1915.28,316021.20,0.00,0.00,0.00,0.00,0.00),('5','131','745','208300',4043274,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','208300',4043275,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','208300',4043276,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','208300',4043277,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','208451',4045546,'2084','308',505139.13,505139.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','208451',4045547,'2085','308',663608.93,666214.47,2605.54,429914.10,0.00,0.00,0.00,0.00,0.00),('5','131','744','208451',4045548,'2086','308',356563.24,358711.20,2147.96,354413.40,0.00,0.00,0.00,0.00,0.00),('5','131','745','208451',4045549,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','208451',4045550,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','208451',4045551,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','208451',4045552,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','208664',4049317,'2084','308',505139.13,505139.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','208664',4049318,'2085','308',666214.47,668422.74,2208.27,364364.55,0.00,0.00,0.00,0.00,0.00),('5','131','744','208664',4049319,'2086','308',358711.20,360817.25,2106.05,347498.25,0.00,0.00,0.00,0.00,0.00),('5','131','745','208664',4049320,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','208664',4049321,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','208664',4049322,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','208664',4049323,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','208876',4053003,'2084','308',505139.13,505139.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','208876',4053004,'2085','308',668422.74,670571.49,2148.75,354543.75,0.00,0.00,0.00,0.00,0.00),('5','131','744','208876',4053005,'2086','308',360817.25,362877.68,2060.43,339970.95,0.00,0.00,0.00,0.00,0.00),('5','131','745','208876',4053006,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','208876',4053007,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','208876',4053008,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','208876',4053009,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','209084',4056512,'2084','308',505139.13,505139.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','209084',4056513,'2085','308',670571.49,672301.30,1729.81,285418.65,0.00,0.00,0.00,0.00,0.00),('5','131','744','209084',4056514,'2086','308',362877.68,364194.30,1316.62,217242.30,0.00,0.00,0.00,0.00,0.00),('5','131','745','209084',4056515,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','209084',4056516,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','209084',4056517,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','209084',4056518,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','209399',4062367,'2084','308',505139.13,505139.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','209399',4062368,'2085','308',672301.30,674447.05,2145.75,354048.75,0.00,0.00,0.00,0.00,0.00),('5','131','744','209399',4062369,'2086','308',364194.30,366108.26,1913.96,315803.40,0.00,0.00,0.00,0.00,0.00),('5','131','745','209399',4062370,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','209399',4062371,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','209399',4062372,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','209399',4062373,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','209621',4066287,'2084','308',505139.13,505139.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','209621',4066288,'2085','308',674447.05,677592.15,3145.10,518941.50,0.00,0.00,0.00,0.00,0.00),('5','131','744','209621',4066289,'2086','308',366108.26,368324.72,2216.46,365715.90,0.00,0.00,0.00,0.00,0.00),('5','131','745','209621',4066290,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','209621',4066291,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','209621',4066292,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','209621',4066293,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','209844',4070239,'2084','308',505139.13,505139.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','209844',4070240,'2085','308',677592.15,680547.37,2955.22,487611.30,0.00,0.00,0.00,0.00,0.00),('5','131','744','209844',4070241,'2086','308',368324.72,370685.03,2360.31,389451.15,0.00,0.00,0.00,0.00,0.00),('5','131','745','209844',4070242,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','209844',4070243,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','209844',4070244,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','209844',4070245,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','210080',4074484,'2084','308',505139.13,505139.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','210080',4074485,'2085','308',680547.37,682809.18,2261.81,368675.03,0.00,0.00,0.00,0.00,0.00),('5','131','744','210080',4074486,'2086','308',370685.03,372819.67,2134.64,347946.32,0.00,0.00,0.00,0.00,0.00),('5','131','745','210080',4074487,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','210080',4074488,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','210080',4074489,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','210080',4074490,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','210261',4077498,'2084','308',505139.13,505139.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','210261',4077499,'2085','308',682809.18,684741.46,1932.28,314961.64,0.00,0.00,0.00,0.00,0.00),('5','131','744','210261',4077500,'2086','308',372819.67,375193.89,2374.22,386997.86,0.00,0.00,0.00,0.00,0.00),('5','131','745','210261',4077501,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','210261',4077502,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','210261',4077503,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','210261',4077504,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','210386',4079652,'2084','308',505139.13,505139.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','210386',4079653,'2085','308',684741.46,686744.00,2002.54,326414.02,0.00,0.00,0.00,0.00,0.00),('5','131','744','210386',4079654,'2086','308',375193.89,377646.89,2453.00,399839.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','210386',4079655,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','210386',4079656,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','210386',4079657,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','210386',4079658,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','210626',4084103,'2084','308',505139.13,505139.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','210626',4084104,'2085','308',686744.00,689260.80,2516.80,410238.40,0.00,0.00,0.00,0.00,0.00),('5','131','744','210626',4084105,'2086','308',377646.89,379134.26,1487.37,242441.31,0.00,0.00,0.00,0.00,0.00),('5','131','745','210626',4084106,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','210626',4084107,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','210626',4084108,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','210626',4084109,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','210849',4087921,'2084','308',505139.13,505139.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','210849',4087922,'2085','308',689260.80,693147.90,3887.10,633597.30,0.00,0.00,0.00,0.00,0.00),('5','131','744','210849',4087923,'2086','308',379134.26,379134.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','210849',4087924,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','210849',4087925,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','210849',4087926,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','210849',4087927,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','210945',4089621,'2084','308',505139.13,505368.64,229.51,37410.13,0.00,0.00,0.00,0.00,0.00),('5','131','744','210945',4089622,'2085','308',693147.90,696288.89,3140.99,511981.37,0.00,0.00,0.00,0.00,0.00),('5','131','744','210945',4089623,'2086','308',379134.26,379134.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','210945',4089624,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','210945',4089625,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','210945',4089626,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','210945',4089627,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','211344',4096821,'2084','308',505368.64,506945.90,1577.26,257093.38,0.00,0.00,0.00,0.00,0.00),('5','131','744','211344',4096822,'2085','308',696288.89,699569.03,3280.14,534662.82,0.00,0.00,0.00,0.00,0.00),('5','131','744','211344',4096823,'2086','308',379134.26,379164.26,30.00,4890.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','211344',4096824,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','211344',4096825,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','211344',4096826,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','211344',4096827,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','211445',4098462,'2084','308',506945.90,510066.16,3120.26,508602.38,0.00,0.00,0.00,0.00,0.00),('5','131','744','211445',4098463,'2085','308',699569.03,702650.97,3081.94,502356.22,0.00,0.00,0.00,0.00,0.00),('5','131','744','211445',4098464,'2086','308',379164.26,379164.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','211445',4098465,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','211445',4098466,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','211445',4098467,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','211445',4098468,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','211744',4103717,'2084','308',510066.16,511463.23,1397.07,227722.41,0.00,0.00,0.00,0.00,0.00),('5','131','744','211744',4103718,'2085','308',702650.97,703933.82,1282.85,209104.55,0.00,0.00,0.00,0.00,0.00),('5','131','744','211744',4103719,'2086','308',379164.26,379164.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','211744',4103720,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','211744',4103721,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','211744',4103722,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','211744',4103723,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','211791',4104191,'2084','308',511463.23,513375.75,1912.52,311740.76,0.00,0.00,0.00,0.00,0.00),('5','131','744','211791',4104192,'2085','308',703933.82,705969.88,2036.06,331877.78,0.00,0.00,0.00,0.00,0.00),('5','131','744','211791',4104193,'2086','308',379164.26,379463.15,298.89,48719.07,0.00,0.00,0.00,0.00,0.00),('5','131','745','211791',4104194,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','211791',4104195,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','211791',4104196,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','211791',4104197,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','212172',4111106,'2084','308',513375.75,515496.87,2121.12,345742.56,0.00,0.00,0.00,0.00,0.00),('5','131','744','212172',4111107,'2085','308',705969.88,707918.68,1948.80,317654.40,0.00,0.00,0.00,0.00,0.00),('5','131','744','212172',4111108,'2086','308',379463.15,379463.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','212172',4111109,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','212172',4111110,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','212172',4111111,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','212172',4111112,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','212435',4116009,'2084','308',515496.87,517645.79,2148.92,350273.96,0.00,0.00,0.00,0.00,0.00),('5','131','744','212435',4116010,'2085','308',707918.68,709229.16,1310.48,213608.24,0.00,0.00,0.00,0.00,0.00),('5','131','744','212435',4116011,'2086','308',379463.15,379463.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','212435',4116012,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','212435',4116013,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','212435',4116014,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','212435',4116015,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','212472',4116503,'2084','308',517645.79,518472.59,826.80,134768.40,0.00,0.00,0.00,0.00,0.00),('5','131','744','212472',4116504,'2085','308',709229.16,710051.72,822.56,134077.28,0.00,0.00,0.00,0.00,0.00),('5','131','744','212472',4116505,'2086','308',379463.15,379463.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','212472',4116506,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','212472',4116507,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','212472',4116508,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','212472',4116509,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','212750',4121449,'2084','308',518472.59,521859.04,3386.45,551991.35,0.00,0.00,0.00,0.00,0.00),('5','131','744','212750',4121450,'2085','308',710051.72,710052.02,0.30,48.90,0.00,0.00,0.00,0.00,0.00),('5','131','744','212750',4121451,'2086','308',379463.15,379868.50,405.35,66072.05,0.00,0.00,0.00,0.00,0.00),('5','131','745','212750',4121452,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','212750',4121453,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','212750',4121454,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','212750',4121455,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','212866',4123605,'2084','308',521859.04,523573.54,1714.50,279463.50,0.00,0.00,0.00,0.00,0.00),('5','131','744','212866',4123606,'2085','308',710052.02,710052.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','212866',4123607,'2086','308',379868.50,380733.79,865.29,141042.27,0.00,0.00,0.00,0.00,0.00),('5','131','745','212866',4123608,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','212866',4123609,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','212866',4123610,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','212866',4123611,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','213199',4129211,'2084','308',523573.54,523573.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','213199',4129212,'2085','308',710052.02,710052.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','213199',4129213,'2086','308',380733.79,384571.12,3837.33,625484.79,0.00,0.00,0.00,0.00,0.00),('5','131','745','213199',4129214,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','213199',4129215,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','213199',4129216,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','213199',4129217,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','213520',4134494,'2084','308',523573.54,524814.42,1240.88,202263.44,0.00,0.00,0.00,0.00,0.00),('5','131','744','213520',4134495,'2085','308',710052.02,710052.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','213520',4134496,'2086','308',384571.12,386961.97,2390.85,389708.55,0.00,0.00,0.00,0.00,0.00),('5','131','745','213520',4134497,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','213520',4134498,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','213520',4134499,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','213520',4134500,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','213751',4138361,'2084','308',524814.42,527656.57,2842.15,463270.45,0.00,0.00,0.00,0.00,0.00),('5','131','744','213751',4138362,'2085','308',710052.02,710052.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','213751',4138363,'2086','308',386961.97,389248.35,2286.38,372679.94,0.00,0.00,0.00,0.00,0.00),('5','131','745','213751',4138364,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','213751',4138365,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','213751',4138366,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','213751',4138367,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','214255',4147035,'2084','308',527656.57,530062.17,2405.60,392112.80,0.00,0.00,0.00,0.00,0.00),('5','131','744','214255',4147036,'2085','308',710052.02,710052.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','214255',4147037,'2086','308',389248.35,391468.37,2220.02,361863.26,0.00,0.00,0.00,0.00,0.00),('5','131','745','214255',4147038,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','214255',4147039,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','214255',4147040,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','214255',4147041,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','214257',4147054,'2084','308',530062.17,533088.69,3026.52,493322.76,0.00,0.00,0.00,0.00,0.00),('5','131','744','214257',4147055,'2085','308',710052.02,710052.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','214257',4147056,'2086','308',391468.37,394077.19,2608.82,425237.66,0.00,0.00,0.00,0.00,0.00),('5','131','745','214257',4147057,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','214257',4147058,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','214257',4147059,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','214257',4147060,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','214348',4148477,'2084','308',533088.69,537233.32,4144.63,675574.69,0.00,0.00,0.00,0.00,0.00),('5','131','744','214348',4148478,'2085','308',710052.02,710052.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','214348',4148479,'2086','308',394077.19,394221.84,144.65,23577.95,0.00,0.00,0.00,0.00,0.00),('5','131','745','214348',4148480,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','214348',4148481,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','214348',4148482,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','214348',4148483,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','214598',4152626,'2084','308',537233.32,541632.34,4399.02,717040.26,0.00,0.00,0.00,0.00,0.00),('5','131','744','214598',4152627,'2085','308',710052.02,710052.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','214598',4152628,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','214598',4152629,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','214598',4152630,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','214598',4152631,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','214598',4152632,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','214822',4156608,'2084','308',541632.34,545742.81,4110.47,670006.61,0.00,0.00,0.00,0.00,0.00),('5','131','744','214822',4156609,'2085','308',710052.02,710052.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','214822',4156610,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','214822',4156611,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','214822',4156612,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','214822',4156613,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','214822',4156614,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','215111',4161411,'2084','308',545742.81,549632.18,3889.37,633967.31,0.00,0.00,0.00,0.00,0.00),('5','131','744','215111',4161412,'2085','308',710052.02,710052.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','215111',4161413,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','215111',4161414,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','215111',4161415,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','215111',4161416,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','215111',4161417,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','215372',4165963,'2084','308',549632.18,553792.27,4160.09,678094.67,0.00,0.00,0.00,0.00,0.00),('5','131','744','215372',4165964,'2085','308',710052.02,710052.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','215372',4165965,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','215372',4165966,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','215372',4165967,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','215372',4165968,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','215372',4165969,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','215608',4169921,'2084','308',553792.27,553965.45,173.18,28228.34,0.00,0.00,0.00,0.00,0.00),('5','131','744','215608',4169922,'2085','308',710052.02,713358.61,3306.59,538974.17,0.00,0.00,0.00,0.00,0.00),('5','131','744','215608',4169923,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','215608',4169924,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','215608',4169925,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','215608',4169926,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','215608',4169927,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','215710',4171511,'2084','308',553965.45,553965.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','215710',4171512,'2085','308',713358.61,716116.02,2757.41,449457.83,0.00,0.00,0.00,0.00,0.00),('5','131','744','215710',4171513,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','215710',4171514,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','215710',4171515,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','215710',4171516,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','215710',4171517,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','215945',4175615,'2084','308',553965.45,553965.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','215945',4175616,'2085','308',716116.02,718204.68,2088.66,340451.58,0.00,0.00,0.00,0.00,0.00),('5','131','744','215945',4175617,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','215945',4175618,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','215945',4175619,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','215945',4175620,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','215945',4175621,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','216313',4182214,'2084','308',553965.45,556622.93,2657.48,433169.24,0.00,0.00,0.00,0.00,0.00),('5','131','744','216313',4182215,'2085','308',718204.68,720355.89,2151.21,350647.23,0.00,0.00,0.00,0.00,0.00),('5','131','744','216313',4182216,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','216313',4182217,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','216313',4182218,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','216313',4182219,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','216313',4182220,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','216544',4186239,'2084','308',556622.93,558633.06,2010.13,327651.19,0.00,0.00,0.00,0.00,0.00),('5','131','744','216544',4186240,'2085','308',720355.89,722365.39,2009.50,327548.50,0.00,0.00,0.00,0.00,0.00),('5','131','744','216544',4186241,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','216544',4186242,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','216544',4186243,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','216544',4186244,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','216544',4186245,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','216777',4190412,'2084','308',558633.06,558633.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','216777',4190413,'2085','308',722365.39,726160.41,3795.02,618588.26,0.00,0.00,0.00,0.00,0.00),('5','131','744','216777',4190414,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','216777',4190415,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','216777',4190416,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','216777',4190417,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','216777',4190418,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','217047',4194809,'2084','308',558633.06,558633.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','217047',4194810,'2085','308',726160.41,726341.88,181.47,29579.61,0.00,0.00,0.00,0.00,0.00),('5','131','744','217047',4194811,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','217047',4194812,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','217047',4194813,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','217047',4194814,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','217047',4194815,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','217127',4196305,'2084','308',558633.06,560592.27,1959.21,319351.23,0.00,0.00,0.00,0.00,0.00),('5','131','744','217127',4196306,'2085','308',726341.88,729215.45,2873.57,468391.91,0.00,0.00,0.00,0.00,0.00),('5','131','744','217127',4196307,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','217127',4196308,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','217127',4196309,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','217127',4196310,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','217127',4196311,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','217301',4199674,'2084','308',560592.27,562568.59,1976.32,322140.16,0.00,0.00,0.00,0.00,0.00),('5','131','744','217301',4199675,'2085','308',729215.45,732817.47,3602.02,587129.26,0.00,0.00,0.00,0.00,0.00),('5','131','744','217301',4199676,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','217301',4199677,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','217301',4199678,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','217301',4199679,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','217301',4199680,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','217666',4206157,'2084','308',562568.59,563864.80,1296.21,211282.23,0.00,0.00,0.00,0.00,0.00),('5','131','744','217666',4206158,'2085','308',732817.47,736150.74,3333.27,543323.01,0.00,0.00,0.00,0.00,0.00),('5','131','744','217666',4206159,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','217666',4206160,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','217666',4206161,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','217666',4206162,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','217666',4206163,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','217727',4206948,'2084','308',563864.80,564644.67,779.87,127118.81,0.00,0.00,0.00,0.00,0.00),('5','131','744','217727',4206949,'2085','308',736150.74,739977.65,3826.91,623786.33,0.00,0.00,0.00,0.00,0.00),('5','131','744','217727',4206950,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','217727',4206951,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','217727',4206952,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','217727',4206953,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','217727',4206954,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','218020',4212218,'2084','308',564644.67,565182.54,537.87,87672.81,0.00,0.00,0.00,0.00,0.00),('5','131','744','218020',4212219,'2085','308',739977.65,743367.86,3390.21,552604.23,0.00,0.00,0.00,0.00,0.00),('5','131','744','218020',4212220,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','218020',4212221,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','218020',4212222,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','218020',4212223,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','218020',4212224,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','218317',4217457,'2084','308',565182.54,566541.66,1359.12,221536.56,0.00,0.00,0.00,0.00,0.00),('5','131','744','218317',4217458,'2085','308',743367.86,746202.62,2834.76,462065.88,0.00,0.00,0.00,0.00,0.00),('5','131','744','218317',4217459,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','218317',4217460,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','218317',4217461,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','218317',4217462,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','218317',4217463,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','218467',4220000,'2084','308',566541.66,568650.91,2109.25,343807.75,0.00,0.00,0.00,0.00,0.00),('5','131','744','218467',4220001,'2085','308',746202.62,748951.32,2748.70,448038.10,0.00,0.00,0.00,0.00,0.00),('5','131','744','218467',4220002,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','218467',4220003,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','218467',4220004,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','218467',4220005,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','218467',4220006,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','218686',4224065,'2084','308',568650.91,570893.42,2242.51,365529.13,0.00,0.00,0.00,0.00,0.00),('5','131','744','218686',4224066,'2085','308',748951.32,751578.62,2627.30,428249.90,0.00,0.00,0.00,0.00,0.00),('5','131','744','218686',4224067,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','218686',4224068,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','218686',4224069,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','218686',4224070,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','218686',4224071,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','218910',4228010,'2084','308',570893.42,572482.56,1589.14,259029.82,0.00,0.00,0.00,0.00,0.00),('5','131','744','218910',4228011,'2085','308',751578.62,753664.23,2085.61,339954.43,0.00,0.00,0.00,0.00,0.00),('5','131','744','218910',4228012,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','218910',4228013,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','218910',4228014,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','218910',4228015,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','218910',4228016,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','219114',4231526,'2084','308',572482.56,573950.62,1468.06,239293.78,0.00,0.00,0.00,0.00,0.00),('5','131','744','219114',4231527,'2085','308',753664.23,759245.70,5581.47,909779.61,0.00,0.00,0.00,0.00,0.00),('5','131','744','219114',4231528,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','219114',4231529,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','219114',4231530,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','219114',4231531,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','219114',4231532,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','219380',4235900,'2084','308',573950.62,573950.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','219380',4235901,'2085','308',759245.70,763195.29,3949.59,643783.17,0.00,0.00,0.00,0.00,0.00),('5','131','744','219380',4235902,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','219380',4235903,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','219380',4235904,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','219380',4235905,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','219380',4235906,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','219657',4240757,'2084','308',573950.62,575363.67,1413.05,230327.15,0.00,0.00,0.00,0.00,0.00),('5','131','744','219657',4240758,'2085','308',763195.29,766397.54,3202.25,521966.75,0.00,0.00,0.00,0.00,0.00),('5','131','744','219657',4240759,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','219657',4240760,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','219657',4240761,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','219657',4240762,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','219657',4240763,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','219809',4243716,'2084','308',575363.67,577614.16,2250.49,366829.87,0.00,0.00,0.00,0.00,0.00),('5','131','744','219809',4243717,'2085','308',766397.54,768919.22,2521.68,411033.84,0.00,0.00,0.00,0.00,0.00),('5','131','744','219809',4243718,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','219809',4243719,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','219809',4243720,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','219809',4243721,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','219809',4243722,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','220044',4247901,'2084','308',577614.16,580174.00,2559.84,417253.92,0.00,0.00,0.00,0.00,0.00),('5','131','744','220044',4247902,'2085','308',768919.22,771836.47,2917.25,475511.75,0.00,0.00,0.00,0.00,0.00),('5','131','744','220044',4247903,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','220044',4247904,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','220044',4247905,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','220044',4247906,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','220044',4247907,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','220263',4251643,'2084','308',580174.00,582675.54,2501.54,407751.02,0.00,0.00,0.00,0.00,0.00),('5','131','744','220263',4251644,'2085','308',771836.47,774903.33,3066.86,499898.18,0.00,0.00,0.00,0.00,0.00),('5','131','744','220263',4251645,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','220263',4251646,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','220263',4251647,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','220263',4251648,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','220263',4251649,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','220499',4255900,'2084','308',582675.54,584398.51,1722.97,280844.11,0.00,0.00,0.00,0.00,0.00),('5','131','744','220499',4255901,'2085','308',774903.33,778190.79,3287.46,535855.98,0.00,0.00,0.00,0.00,0.00),('5','131','744','220499',4255902,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','220499',4255903,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','220499',4255904,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','220499',4255905,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','220499',4255906,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','220701',4259437,'2084','308',584398.51,584398.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','220701',4259438,'2085','308',778190.79,782066.40,3875.61,631724.43,0.00,0.00,0.00,0.00,0.00),('5','131','744','220701',4259439,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','220701',4259440,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','220701',4259441,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','220701',4259442,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','220701',4259443,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','220932',4263501,'2084','308',584398.51,585932.11,1533.60,249976.80,0.00,0.00,0.00,0.00,0.00),('5','131','744','220932',4263502,'2085','308',782066.40,784700.38,2633.98,429338.74,0.00,0.00,0.00,0.00,0.00),('5','131','744','220932',4263503,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','220932',4263504,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','220932',4263505,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','220932',4263506,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','220932',4263507,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','221146',4267401,'2084','308',585932.11,588429.98,2497.87,407152.81,0.00,0.00,0.00,0.00,0.00),('5','131','744','221146',4267402,'2085','308',784700.38,787436.22,2735.84,445941.92,0.00,0.00,0.00,0.00,0.00),('5','131','744','221146',4267403,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','221146',4267404,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','221146',4267405,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','221146',4267406,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','221146',4267407,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','221442',4272554,'2084','308',588429.98,591048.46,2618.48,426812.24,0.00,0.00,0.00,0.00,0.00),('5','131','744','221442',4272555,'2085','308',787436.22,790158.87,2722.65,443791.95,0.00,0.00,0.00,0.00,0.00),('5','131','744','221442',4272556,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','221442',4272557,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','221442',4272558,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','221442',4272559,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','221442',4272560,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','221652',4276507,'2084','308',591048.46,593955.81,2907.35,473898.05,0.00,0.00,0.00,0.00,0.00),('5','131','744','221652',4276508,'2085','308',790158.87,793039.98,2881.11,469620.93,0.00,0.00,0.00,0.00,0.00),('5','131','744','221652',4276509,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','221652',4276510,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','221652',4276511,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','221652',4276512,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','221652',4276513,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','221923',4281293,'2084','308',593955.81,596789.85,2834.04,461948.52,0.00,0.00,0.00,0.00,0.00),('5','131','744','221923',4281294,'2085','308',793039.98,795929.10,2889.12,470926.56,0.00,0.00,0.00,0.00,0.00),('5','131','744','221923',4281295,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','221923',4281296,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','221923',4281297,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','221923',4281298,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','221923',4281299,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','222183',4285990,'2084','308',596789.85,599399.68,2609.83,425402.29,0.00,0.00,0.00,0.00,0.00),('5','131','744','222183',4285991,'2085','308',795929.10,798701.09,2771.99,451834.37,0.00,0.00,0.00,0.00,0.00),('5','131','744','222183',4285992,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','222183',4285993,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','222183',4285994,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','222183',4285995,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','222183',4285996,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','222321',4288130,'2084','308',599399.68,602661.34,3261.66,531650.58,0.00,0.00,0.00,0.00,0.00),('5','131','744','222321',4288131,'2085','308',798701.09,801860.05,3158.96,514910.48,0.00,0.00,0.00,0.00,0.00),('5','131','744','222321',4288132,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','222321',4288133,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','222321',4288134,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','222321',4288135,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','222321',4288136,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','222629',4293700,'2084','308',602661.34,603131.75,470.41,76676.83,0.00,0.00,0.00,0.00,0.00),('5','131','744','222629',4293701,'2085','308',801860.05,804411.68,2551.63,415915.69,0.00,0.00,0.00,0.00,0.00),('5','131','744','222629',4293702,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','222629',4293703,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','222629',4293704,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','222629',4293705,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','222629',4293706,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','222798',4296765,'2084','308',603131.75,603131.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','222798',4296766,'2085','308',804411.68,808213.56,3801.88,619706.44,0.00,0.00,0.00,0.00,0.00),('5','131','744','222798',4296767,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','222798',4296768,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','222798',4296769,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','222798',4296770,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','222798',4296771,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','224374',4325053,'2084','308',603131.75,603131.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','224374',4325054,'2085','308',808213.56,808213.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','224374',4325055,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','224374',4325056,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','224374',4325057,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','224374',4325058,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','224374',4325059,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','224378',4325090,'2084','308',603131.75,603131.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','224378',4325091,'2085','308',808213.56,808213.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','224378',4325092,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','224378',4325093,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','224378',4325094,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','224378',4325095,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','224378',4325096,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','224511',4327744,'2084','308',603131.75,603131.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','224511',4327745,'2085','308',808213.56,808213.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','224511',4327746,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','224511',4327747,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','224511',4327748,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','224511',4327749,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','224511',4327750,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','224570',4328440,'2084','308',603131.75,603131.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','224570',4328441,'2085','308',808213.56,808213.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','224570',4328442,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','224570',4328443,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','224570',4328444,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','224570',4328445,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','224570',4328446,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','224582',4328687,'2084','308',603131.75,603131.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','224582',4328688,'2085','308',808213.56,808213.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','224582',4328689,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','224582',4328690,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','224582',4328691,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','224582',4328692,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','224582',4328693,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','224586',4328759,'2084','308',603131.75,603131.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','224586',4328760,'2085','308',808213.56,808213.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','224586',4328761,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','224586',4328762,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','224586',4328763,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','224586',4328764,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','224586',4328765,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','224596',4328914,'2084','308',603131.75,603131.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','224596',4328915,'2085','308',808213.56,808213.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','224596',4328916,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','224596',4328917,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','224596',4328918,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','224596',4328919,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','224596',4328920,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','224644',4329869,'2084','308',603131.75,606111.80,2980.05,485748.15,0.00,0.00,0.00,0.00,0.00),('5','131','744','224644',4329870,'2085','308',808213.56,810842.46,2628.90,428510.70,0.00,0.00,0.00,0.00,0.00),('5','131','744','224644',4329871,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','224644',4329872,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','224644',4329873,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','224644',4329874,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','224644',4329875,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','224860',4333545,'2084','308',606111.80,607288.85,1177.05,191859.15,0.00,0.00,0.00,0.00,0.00),('5','131','744','224860',4333546,'2085','308',810842.46,814605.47,3763.01,613370.63,0.00,0.00,0.00,0.00,0.00),('5','131','744','224860',4333547,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','224860',4333548,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','224860',4333549,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','224860',4333550,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','224860',4333551,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','225217',4340178,'2084','308',607288.85,607288.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','225217',4340179,'2085','308',814605.47,818479.88,3874.41,631528.83,0.00,0.00,0.00,0.00,0.00),('5','131','744','225217',4340180,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','225217',4340181,'2087','308',360739.74,360739.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','225217',4340182,'2088','308',607228.05,607228.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','225217',4340183,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','225217',4340184,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','225257',4340977,'2084','308',607288.85,608937.29,1648.44,268695.72,0.00,0.00,0.00,0.00,0.00),('5','131','744','225257',4340978,'2085','308',818479.88,820054.13,1574.25,256602.75,0.00,0.00,0.00,0.00,0.00),('5','131','744','225257',4340979,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','225257',4340980,'2087','308',360739.74,360743.38,3.64,593.32,0.00,0.00,0.00,0.00,0.00),('5','131','745','225257',4340981,'2088','308',607228.05,607233.38,5.33,868.79,0.00,0.00,0.00,0.00,0.00),('5','131','745','225257',4340982,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','225257',4340983,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','225537',4345960,'2084','308',608937.29,611431.08,2493.79,406487.77,0.00,0.00,0.00,0.00,0.00),('5','131','744','225537',4345961,'2085','308',820054.13,821731.55,1677.42,273419.46,0.00,0.00,0.00,0.00,0.00),('5','131','744','225537',4345962,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','225537',4345963,'2087','308',360743.38,360743.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','225537',4345964,'2088','308',607233.38,607233.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','225537',4345965,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','225537',4345966,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','225843',4351220,'2084','308',611431.08,611703.79,272.71,44451.73,0.00,0.00,0.00,0.00,0.00),('5','131','744','225843',4351221,'2085','308',821731.55,824428.58,2697.03,439615.89,0.00,0.00,0.00,0.00,0.00),('5','131','744','225843',4351222,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','225843',4351223,'2087','308',360743.38,361419.61,676.23,110225.49,0.00,0.00,0.00,0.00,0.00),('5','131','745','225843',4351224,'2088','308',607233.38,607389.58,156.20,25460.60,0.00,0.00,0.00,0.00,0.00),('5','131','745','225843',4351225,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','225843',4351226,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','226083',4355384,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','226083',4355385,'2085','308',824428.58,828511.48,4082.90,665512.70,0.00,0.00,0.00,0.00,0.00),('5','131','744','226083',4355386,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','226083',4355387,'2087','308',361419.61,361419.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','226083',4355388,'2088','308',607389.58,607389.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','226083',4355389,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','226083',4355390,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','226323',4359784,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','226323',4359785,'2085','308',828511.48,831411.03,2899.55,472626.65,0.00,0.00,0.00,0.00,0.00),('5','131','744','226323',4359786,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','226323',4359787,'2087','308',361419.61,362301.16,881.55,143692.65,0.00,0.00,0.00,0.00,0.00),('5','131','745','226323',4359788,'2088','308',607389.58,607389.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','226323',4359789,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','226323',4359790,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','226535',4363409,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','226535',4363410,'2085','308',831411.03,833810.06,2399.03,391041.89,0.00,0.00,0.00,0.00,0.00),('5','131','744','226535',4363411,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','226535',4363412,'2087','308',362301.16,364763.69,2462.53,401392.39,0.00,0.00,0.00,0.00,0.00),('5','131','745','226535',4363413,'2088','308',607389.58,607389.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','226535',4363414,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','226535',4363415,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','226751',4367477,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','226751',4367478,'2085','308',833810.06,836747.16,2937.10,478747.30,0.00,0.00,0.00,0.00,0.00),('5','131','744','226751',4367479,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','226751',4367480,'2087','308',364763.69,366091.26,1327.57,216393.91,0.00,0.00,0.00,0.00,0.00),('5','131','745','226751',4367481,'2088','308',607389.58,607389.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','226751',4367482,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','226751',4367483,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','226988',4371650,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','226988',4371651,'2085','308',836747.16,839468.67,2721.51,443606.13,0.00,0.00,0.00,0.00,0.00),('5','131','744','226988',4371652,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','226988',4371653,'2087','308',366091.26,367221.87,1130.61,184289.43,0.00,0.00,0.00,0.00,0.00),('5','131','745','226988',4371654,'2088','308',607389.58,607389.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','226988',4371655,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','226988',4371656,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','227193',4375321,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','227193',4375322,'2085','308',839468.67,841580.72,2112.05,344264.15,0.00,0.00,0.00,0.00,0.00),('5','131','744','227193',4375323,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','227193',4375324,'2087','308',367221.87,368292.14,1070.27,174454.01,0.00,0.00,0.00,0.00,0.00),('5','131','745','227193',4375325,'2088','308',607389.58,607389.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','227193',4375326,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','227193',4375327,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','227388',4378721,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','227388',4378722,'2085','308',841580.72,842818.38,1237.66,201738.58,0.00,0.00,0.00,0.00,0.00),('5','131','744','227388',4378723,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','227388',4378724,'2087','308',368292.14,372029.95,3737.81,609263.03,0.00,0.00,0.00,0.00,0.00),('5','131','745','227388',4378725,'2088','308',607389.58,607389.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','227388',4378726,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','227388',4378727,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','227617',4382659,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','227617',4382660,'2085','308',842818.38,842818.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','227617',4382661,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','227617',4382662,'2087','308',372029.95,375395.41,3365.46,548569.98,0.00,0.00,0.00,0.00,0.00),('5','131','745','227617',4382663,'2088','308',607389.58,607389.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','227617',4382664,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','227617',4382665,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','227849',4386911,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','227849',4386912,'2085','308',842818.38,842818.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','227849',4386913,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','227849',4386914,'2087','308',375395.41,375395.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','227849',4386915,'2088','308',607389.58,607389.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','227849',4386916,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','227849',4386917,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','229385',4415899,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','229385',4415900,'2085','308',842818.38,842818.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','229385',4415901,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','229385',4415902,'2087','308',375395.41,375395.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','229385',4415903,'2088','308',607389.58,607389.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','229385',4415904,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','229385',4415905,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','229417',4416342,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','229417',4416343,'2085','308',842818.38,842818.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','229417',4416344,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','229417',4416345,'2087','308',375395.41,375395.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','229417',4416346,'2088','308',607389.58,607389.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','229417',4416347,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','229417',4416348,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','229463',4417022,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','229463',4417023,'2085','308',842818.38,842818.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','229463',4417024,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','229463',4417025,'2087','308',375395.41,375395.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','229463',4417026,'2088','308',607389.58,607389.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','229463',4417027,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','229463',4417028,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','230680',4440537,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','230680',4440538,'2085','308',842818.38,843554.94,736.56,120059.28,0.00,0.00,0.00,0.00,0.00),('5','131','744','230680',4440539,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','230680',4440540,'2087','308',375395.41,378149.43,2754.02,448905.26,0.00,0.00,0.00,0.00,0.00),('5','131','745','230680',4440541,'2088','308',607389.58,607389.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','230680',4440542,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','230680',4440543,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','230710',4441158,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','230710',4441159,'2085','308',843554.94,843554.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','230710',4441160,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','230710',4441161,'2087','308',378149.43,381402.19,3252.76,530199.88,0.00,0.00,0.00,0.00,0.00),('5','131','745','230710',4441162,'2088','308',607389.58,607389.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','230710',4441163,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','230710',4441164,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','230763',4441993,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','230763',4441994,'2085','308',843554.94,843554.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','230763',4441995,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','230763',4441996,'2087','308',381402.19,385141.34,3739.15,609481.45,0.00,0.00,0.00,0.00,0.00),('5','131','745','230763',4441997,'2088','308',607389.58,607389.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','230763',4441998,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','230763',4441999,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','230821',4442575,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','230821',4442576,'2085','308',843554.94,843554.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','230821',4442577,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','230821',4442578,'2087','308',385141.34,388030.17,2888.83,470879.29,0.00,0.00,0.00,0.00,0.00),('5','131','745','230821',4442579,'2088','308',607389.58,607389.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','230821',4442580,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','230821',4442581,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','230933',4444598,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','230933',4444599,'2085','308',843554.94,843554.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','230933',4444600,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','230933',4444601,'2087','308',388030.17,389935.93,1905.76,310638.88,0.00,0.00,0.00,0.00,0.00),('5','131','745','230933',4444602,'2088','308',607389.58,607389.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','230933',4444603,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','230933',4444604,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','230937',4444654,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','230937',4444655,'2085','308',843554.94,843554.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','230937',4444656,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','230937',4444657,'2087','308',389935.93,389935.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','230937',4444658,'2088','308',607389.58,607389.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','230937',4444659,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','230937',4444660,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','230963',4445286,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','230963',4445287,'2085','308',843554.94,843554.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','230963',4445288,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','230963',4445289,'2087','308',389935.93,389935.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','230963',4445290,'2088','308',607389.58,607389.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','230963',4445291,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','230963',4445292,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','231048',4446845,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','231048',4446846,'2085','308',843554.94,843554.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','231048',4446847,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','231048',4446848,'2087','308',389935.93,389935.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','231048',4446849,'2088','308',607389.58,607389.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','231048',4446850,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','231048',4446851,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','231071',4447017,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','231071',4447018,'2085','308',843554.94,843554.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','231071',4447019,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','231071',4447020,'2087','308',389935.93,389935.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','231071',4447021,'2088','308',607389.58,607389.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','231071',4447022,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','231071',4447023,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','231096',4447437,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','231096',4447438,'2085','308',843554.94,848589.69,5034.75,820664.25,0.00,0.00,0.00,0.00,0.00),('5','131','744','231096',4447439,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','231096',4447440,'2087','308',389935.93,390525.87,589.94,96160.22,0.00,0.00,0.00,0.00,0.00),('5','131','745','231096',4447441,'2088','308',607389.58,607389.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','231096',4447442,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','231096',4447443,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','231119',4447898,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','231119',4447899,'2085','308',848589.69,851264.38,2674.69,435974.47,0.00,0.00,0.00,0.00,0.00),('5','131','744','231119',4447900,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','231119',4447901,'2087','308',390525.87,392718.87,2193.00,357459.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','231119',4447902,'2088','308',607389.58,607389.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','231119',4447903,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','231119',4447904,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','231363',4451736,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','231363',4451737,'2085','308',851264.38,853767.21,2502.83,407961.29,0.00,0.00,0.00,0.00,0.00),('5','131','744','231363',4451738,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','231363',4451739,'2087','308',392718.87,395497.35,2778.48,452892.24,0.00,0.00,0.00,0.00,0.00),('5','131','745','231363',4451740,'2088','308',607389.58,607389.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','231363',4451741,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','231363',4451742,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','231709',4457684,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','231709',4457685,'2085','308',853767.21,856186.88,2419.67,394406.21,0.00,0.00,0.00,0.00,0.00),('5','131','744','231709',4457686,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','231709',4457687,'2087','308',395497.35,398639.28,3141.93,512134.59,0.00,0.00,0.00,0.00,0.00),('5','131','745','231709',4457688,'2088','308',607389.58,607485.79,96.21,15682.23,0.00,0.00,0.00,0.00,0.00),('5','131','745','231709',4457689,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','231709',4457690,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','232070',4464528,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','232070',4464529,'2085','308',856186.88,857026.98,840.10,136936.30,0.00,0.00,0.00,0.00,0.00),('5','131','744','232070',4464530,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','232070',4464531,'2087','308',398639.28,402685.57,4046.29,659545.27,0.00,0.00,0.00,0.00,0.00),('5','131','745','232070',4464532,'2088','308',607485.79,607489.20,3.41,555.83,0.00,0.00,0.00,0.00,0.00),('5','131','745','232070',4464533,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','232070',4464534,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','232263',4467764,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','232263',4467765,'2085','308',857026.98,857673.50,646.52,105382.76,0.00,0.00,0.00,0.00,0.00),('5','131','744','232263',4467766,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','232263',4467767,'2087','308',402685.57,405662.81,2977.24,485290.12,0.00,0.00,0.00,0.00,0.00),('5','131','745','232263',4467768,'2088','308',607489.20,607495.19,5.99,976.37,0.00,0.00,0.00,0.00,0.00),('5','131','745','232263',4467769,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','232263',4467770,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','232392',4469805,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','232392',4469806,'2085','308',857673.50,859449.55,1776.05,289496.15,0.00,0.00,0.00,0.00,0.00),('5','131','744','232392',4469807,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','232392',4469808,'2087','308',405662.81,408028.57,2365.76,385618.88,0.00,0.00,0.00,0.00,0.00),('5','131','745','232392',4469809,'2088','308',607495.19,607495.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','232392',4469810,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','232392',4469811,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','232669',4475160,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','232669',4475161,'2085','308',859449.55,861242.50,1792.95,292250.85,0.00,0.00,0.00,0.00,0.00),('5','131','744','232669',4475162,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','232669',4475163,'2087','308',408028.57,410496.68,2468.11,402301.93,0.00,0.00,0.00,0.00,0.00),('5','131','745','232669',4475164,'2088','308',607495.19,607495.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','232669',4475165,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','232669',4475166,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','232911',4479303,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','232911',4479304,'2085','308',861242.50,864045.53,2803.03,456893.89,0.00,0.00,0.00,0.00,0.00),('5','131','744','232911',4479305,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','232911',4479306,'2087','308',410496.68,411544.59,1047.91,170809.33,0.00,0.00,0.00,0.00,0.00),('5','131','745','232911',4479307,'2088','308',607495.19,607495.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','232911',4479308,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','232911',4479309,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','233127',4483170,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','233127',4483171,'2085','308',864045.53,866264.84,2219.31,361747.53,0.00,0.00,0.00,0.00,0.00),('5','131','744','233127',4483172,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','233127',4483173,'2087','308',411544.59,411872.00,327.41,53367.83,0.00,0.00,0.00,0.00,0.00),('5','131','745','233127',4483174,'2088','308',607495.19,607498.33,3.14,511.82,0.00,0.00,0.00,0.00,0.00),('5','131','745','233127',4483175,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','233127',4483176,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','233432',4488586,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','233432',4488587,'2085','308',866264.84,869283.96,3019.12,492116.56,0.00,0.00,0.00,0.00,0.00),('5','131','744','233432',4488588,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','233432',4488589,'2087','308',411872.00,414637.86,2765.86,450835.18,0.00,0.00,0.00,0.00,0.00),('5','131','745','233432',4488590,'2088','308',607498.33,607498.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','233432',4488591,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','233432',4488592,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','233688',4493304,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','233688',4493305,'2085','308',869283.96,870427.49,1143.53,186395.39,0.00,0.00,0.00,0.00,0.00),('5','131','744','233688',4493306,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','233688',4493307,'2087','308',414637.86,418628.62,3990.76,650493.88,0.00,0.00,0.00,0.00,0.00),('5','131','745','233688',4493308,'2088','308',607498.33,607829.78,331.45,54026.35,0.00,0.00,0.00,0.00,0.00),('5','131','745','233688',4493309,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','233688',4493310,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','233994',4499072,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','233994',4499073,'2085','308',870427.49,870427.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','233994',4499074,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','233994',4499075,'2087','308',418628.62,423993.97,5365.35,874552.05,0.00,0.00,0.00,0.00,0.00),('5','131','745','233994',4499076,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','233994',4499077,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','233994',4499078,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','234480',4507721,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','234480',4507722,'2085','308',870427.49,870427.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','234480',4507723,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','234480',4507724,'2087','308',423993.97,428963.17,4969.20,809979.60,0.00,0.00,0.00,0.00,0.00),('5','131','745','234480',4507725,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','234480',4507726,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','234480',4507727,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','234512',4508277,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','234512',4508278,'2085','308',870427.49,870427.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','234512',4508279,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','234512',4508280,'2087','308',428963.17,429399.70,436.53,72027.45,0.00,0.00,0.00,0.00,0.00),('5','131','745','234512',4508281,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','234512',4508282,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','234512',4508283,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','234636',4510523,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','234636',4510524,'2085','308',870427.49,870427.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','234636',4510525,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','234636',4510526,'2087','308',429399.70,429399.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','234636',4510527,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','234636',4510528,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','234636',4510529,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','235081',4518330,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','235081',4518331,'2085','308',870427.49,870427.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','235081',4518332,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','235081',4518333,'2087','308',429399.70,429399.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','235081',4518334,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','235081',4518335,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','235081',4518336,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','235335',4522687,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','235335',4522688,'2085','308',870427.49,870427.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','235335',4522689,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','235335',4522690,'2087','308',429399.70,429399.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','235335',4522691,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','235335',4522692,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','235335',4522693,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','235533',4526187,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','235533',4526188,'2085','308',870427.49,870427.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','235533',4526189,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','235533',4526190,'2087','308',429399.70,429399.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','235533',4526191,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','235533',4526192,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','235533',4526193,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','235673',4528724,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','235673',4528725,'2085','308',870427.49,874333.16,3905.67,644435.55,0.00,0.00,0.00,0.00,0.00),('5','131','744','235673',4528726,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','235673',4528727,'2087','308',429399.70,434748.34,5348.64,882525.60,0.00,0.00,0.00,0.00,0.00),('5','131','745','235673',4528728,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','235673',4528729,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','235673',4528730,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','235928',4533057,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','235928',4533058,'2085','308',874333.16,878469.32,4136.16,682466.40,0.00,0.00,0.00,0.00,0.00),('5','131','744','235928',4533059,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','235928',4533060,'2087','308',434748.34,438397.01,3648.67,602030.55,0.00,0.00,0.00,0.00,0.00),('5','131','745','235928',4533061,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','235928',4533062,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','235928',4533063,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','236352',4540738,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','236352',4540739,'2085','308',878469.32,881791.55,3322.23,548167.95,0.00,0.00,0.00,0.00,0.00),('5','131','744','236352',4540740,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','236352',4540741,'2087','308',438397.01,442913.62,4516.61,745240.65,0.00,0.00,0.00,0.00,0.00),('5','131','745','236352',4540742,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','236352',4540743,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','236352',4540744,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','236461',4542624,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','236461',4542625,'2085','308',881791.55,885555.56,3764.01,621061.65,0.00,0.00,0.00,0.00,0.00),('5','131','744','236461',4542626,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','236461',4542627,'2087','308',442913.62,444324.91,1411.29,232862.85,0.00,0.00,0.00,0.00,0.00),('5','131','745','236461',4542628,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','236461',4542629,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','236461',4542630,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','236802',4548450,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','236802',4548451,'2085','308',885555.56,885555.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','236802',4548452,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','236802',4548453,'2087','308',444324.91,444324.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','236802',4548454,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','236802',4548455,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','236802',4548456,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','236895',4550040,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','236895',4550041,'2085','308',885555.56,885555.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','236895',4550042,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','236895',4550043,'2087','308',444324.91,444324.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','236895',4550044,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','236895',4550045,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','236895',4550046,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','237082',4553399,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','237082',4553400,'2085','308',885555.56,885555.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','237082',4553401,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','237082',4553402,'2087','308',444324.91,444324.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','237082',4553403,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','237082',4553404,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','237082',4553405,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','237257',4556371,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','237257',4556372,'2085','308',885555.56,885555.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','237257',4556373,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','237257',4556374,'2087','308',444324.91,444324.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','237257',4556375,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','237257',4556376,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','237257',4556377,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','237599',4562708,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','237599',4562709,'2085','308',885555.56,885555.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','237599',4562710,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','237599',4562711,'2087','308',444324.91,444324.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','237599',4562712,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','237599',4562713,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','237599',4562714,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','237714',4564733,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','237714',4564734,'2085','308',885555.56,885555.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','237714',4564735,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','237714',4564736,'2087','308',444324.91,444324.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','237714',4564737,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','237714',4564738,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','237714',4564739,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','237861',4567047,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','237861',4567048,'2085','308',885555.56,885555.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','237861',4567049,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','237861',4567050,'2087','308',444324.91,444324.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','237861',4567051,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','237861',4567052,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','237861',4567053,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','238232',4573144,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','238232',4573145,'2085','308',885555.56,886225.37,669.81,110518.65,0.00,0.00,0.00,0.00,0.00),('5','131','744','238232',4573146,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','238232',4573147,'2087','308',444324.91,444324.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','238232',4573148,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','238232',4573149,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','238232',4573150,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','238611',4579406,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','238611',4579407,'2085','308',886225.37,891859.82,5634.45,929684.25,0.00,0.00,0.00,0.00,0.00),('5','131','744','238611',4579408,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','238611',4579409,'2087','308',444324.91,444324.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','238611',4579410,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','238611',4579411,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','238611',4579412,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','238903',4584727,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','238903',4584728,'2085','308',891859.82,897499.73,5639.91,930585.15,0.00,0.00,0.00,0.00,0.00),('5','131','744','238903',4584729,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','238903',4584730,'2087','308',444324.91,444324.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','238903',4584731,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','238903',4584732,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','238903',4584733,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','239113',4588425,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','239113',4588426,'2085','308',897499.73,899554.20,2054.47,338987.55,0.00,0.00,0.00,0.00,0.00),('5','131','744','239113',4588427,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','239113',4588428,'2087','308',444324.91,444324.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','239113',4588429,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','239113',4588430,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','239113',4588431,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','239356',4592544,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','239356',4592545,'2085','308',899554.20,899953.70,399.50,65917.50,0.00,0.00,0.00,0.00,0.00),('5','131','744','239356',4592546,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','239356',4592547,'2087','308',444324.91,444324.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','239356',4592548,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','239356',4592549,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','239356',4592550,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','239550',4595774,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','239550',4595775,'2085','308',899953.70,899953.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','239550',4595776,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','239550',4595777,'2087','308',444324.91,444324.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','239550',4595778,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','239550',4595779,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','239550',4595780,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','239750',4599534,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','239750',4599535,'2085','308',899953.70,899953.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','239750',4599536,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','239750',4599537,'2087','308',444324.91,444324.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','239750',4599538,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','239750',4599539,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','239750',4599540,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','239795',4600108,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','239795',4600109,'2085','308',899953.70,899953.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','239795',4600110,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','239795',4600111,'2087','308',444324.91,444324.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','239795',4600112,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','239795',4600113,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','239795',4600114,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','239979',4603485,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','239979',4603486,'2085','308',899953.70,899953.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','239979',4603487,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','239979',4603488,'2087','308',444324.91,447170.77,2845.86,469566.90,0.00,0.00,0.00,0.00,0.00),('5','131','745','239979',4603489,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','239979',4603490,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','239979',4603491,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','240222',4607558,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','240222',4607559,'2085','308',899953.70,900354.20,400.50,66082.50,0.00,0.00,0.00,0.00,0.00),('5','131','744','240222',4607560,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','240222',4607561,'2087','308',447170.77,453890.33,6719.56,1108727.40,0.00,0.00,0.00,0.00,0.00),('5','131','745','240222',4607562,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','240222',4607563,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','240222',4607564,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','240446',4611235,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','240446',4611236,'2085','308',900354.20,900354.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','240446',4611237,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','240446',4611238,'2087','308',453890.33,456948.42,3058.09,504584.85,0.00,0.00,0.00,0.00,0.00),('5','131','745','240446',4611239,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','240446',4611240,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','240446',4611241,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','240709',4615195,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','240709',4615196,'2085','308',900354.20,900354.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','240709',4615197,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','240709',4615198,'2087','308',456948.42,457273.65,325.23,53662.95,0.00,0.00,0.00,0.00,0.00),('5','131','745','240709',4615199,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','240709',4615200,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','240709',4615201,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','240968',4619940,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','240968',4619941,'2085','308',900354.20,905745.94,5391.74,889637.10,0.00,0.00,0.00,0.00,0.00),('5','131','744','240968',4619942,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','240968',4619943,'2087','308',457273.65,459682.56,2408.91,397470.15,0.00,0.00,0.00,0.00,0.00),('5','131','745','240968',4619944,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','240968',4619945,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','240968',4619946,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','241297',4625697,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','241297',4625698,'2085','308',905745.94,909226.14,3480.20,574233.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','241297',4625699,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','241297',4625700,'2087','308',459682.56,465401.32,5718.76,943594.58,0.00,0.00,0.00,0.00,0.00),('5','131','745','241297',4625701,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','241297',4625702,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','241297',4625703,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','241492',4629052,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','241492',4629053,'2085','308',909226.14,913173.12,3946.98,651251.70,0.00,0.00,0.00,0.00,0.00),('5','131','744','241492',4629054,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','241492',4629055,'2087','308',465401.32,471675.41,6274.09,1035224.85,0.00,0.00,0.00,0.00,0.00),('5','131','745','241492',4629056,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','241492',4629057,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','241492',4629058,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','241740',4633395,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','241740',4633396,'2085','308',913173.12,914956.49,1783.37,294256.05,0.00,0.00,0.00,0.00,0.00),('5','131','744','241740',4633397,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','241740',4633398,'2087','308',471675.41,477847.42,6172.01,1018381.65,0.00,0.00,0.00,0.00,0.00),('5','131','745','241740',4633399,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','241740',4633400,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','241740',4633401,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','242022',4638170,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','242022',4638171,'2085','308',914956.49,915294.17,337.68,55717.20,0.00,0.00,0.00,0.00,0.00),('5','131','744','242022',4638172,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','242022',4638173,'2087','308',477847.42,485030.35,7182.93,1185183.45,0.00,0.00,0.00,0.00,0.00),('5','131','745','242022',4638174,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','242022',4638175,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','242022',4638176,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','242239',4641998,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','242239',4641999,'2085','308',915294.17,915294.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','242239',4642000,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','242239',4642001,'2087','308',485030.35,486759.63,1729.28,285331.20,0.00,0.00,0.00,0.00,0.00),('5','131','745','242239',4642002,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','242239',4642003,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','242239',4642004,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','242515',4646882,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','242515',4646883,'2085','308',915294.17,915294.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','242515',4646884,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','242515',4646885,'2087','308',486759.63,486759.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','242515',4646886,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','242515',4646887,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','242515',4646888,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','242772',4651404,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','242772',4651405,'2085','308',915294.17,915294.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','242772',4651406,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','242772',4651407,'2087','308',486759.63,486759.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','242772',4651408,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','242772',4651409,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','242772',4651410,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','242963',4654584,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','242963',4654585,'2085','308',915294.17,915294.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','242963',4654586,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','242963',4654587,'2087','308',486759.63,486759.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','242963',4654588,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','242963',4654589,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','242963',4654590,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','243162',4657960,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','243162',4657961,'2085','308',915294.17,921492.65,6198.48,1022749.20,0.00,0.00,0.00,0.00,0.00),('5','131','744','243162',4657962,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','243162',4657963,'2087','308',486759.63,486759.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','243162',4657964,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','243162',4657965,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','243162',4657966,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','243423',4662710,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','243423',4662711,'2085','308',921492.65,928805.70,7313.05,1206653.25,0.00,0.00,0.00,0.00,0.00),('5','131','744','243423',4662712,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','243423',4662713,'2087','308',486759.63,488912.02,2152.39,355144.35,0.00,0.00,0.00,0.00,0.00),('5','131','745','243423',4662714,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','243423',4662715,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','243423',4662716,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','243797',4669509,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','243797',4669510,'2085','308',928805.70,930292.90,1487.20,245388.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','243797',4669511,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','243797',4669512,'2087','308',488912.02,497978.47,9066.45,1495964.25,0.00,0.00,0.00,0.00,0.00),('5','131','745','243797',4669513,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','243797',4669514,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','243797',4669515,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','244309',4677863,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','244309',4677864,'2085','308',930292.90,930292.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','244309',4677865,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','244309',4677866,'2087','308',497978.47,501495.09,3516.62,580242.30,0.00,0.00,0.00,0.00,0.00),('5','131','745','244309',4677867,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','244309',4677868,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','244309',4677869,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','244498',4681537,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','244498',4681538,'2085','308',930292.90,930292.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','244498',4681539,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','244498',4681540,'2087','308',501495.09,501495.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','244498',4681541,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','244498',4681542,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','244498',4681543,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','244569',4682443,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','244569',4682444,'2085','308',930292.90,931020.68,727.78,120083.70,0.00,0.00,0.00,0.00,0.00),('5','131','744','244569',4682445,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','244569',4682446,'2087','308',501495.09,503129.17,1634.08,269623.20,0.00,0.00,0.00,0.00,0.00),('5','131','745','244569',4682447,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','244569',4682448,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','244569',4682449,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','244683',4684624,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','244683',4684625,'2085','308',931020.68,935695.89,4675.21,771409.65,0.00,0.00,0.00,0.00,0.00),('5','131','744','244683',4684626,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','244683',4684627,'2087','308',503129.17,508167.02,5037.85,831245.25,0.00,0.00,0.00,0.00,0.00),('5','131','745','244683',4684628,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','244683',4684629,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','244683',4684630,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','244811',4686718,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','244811',4686719,'2085','308',935695.89,941531.85,5835.96,962933.40,0.00,0.00,0.00,0.00,0.00),('5','131','744','244811',4686720,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','244811',4686721,'2087','308',508167.02,514428.27,6261.25,1033106.25,0.00,0.00,0.00,0.00,0.00),('5','131','745','244811',4686722,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','244811',4686723,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','244811',4686724,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','245068',4691252,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','245068',4691253,'2085','308',941531.85,941531.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','245068',4691254,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','245068',4691255,'2087','308',514428.27,522949.23,8520.96,1405958.40,0.00,0.00,0.00,0.00,0.00),('5','131','745','245068',4691256,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','245068',4691257,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','245068',4691258,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','245401',4697216,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','245401',4697217,'2085','308',941531.85,943193.29,1661.44,274137.60,0.00,0.00,0.00,0.00,0.00),('5','131','744','245401',4697218,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','245401',4697219,'2087','308',522949.23,528307.85,5358.62,884172.30,0.00,0.00,0.00,0.00,0.00),('5','131','745','245401',4697220,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','245401',4697221,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','245401',4697222,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','245620',4701105,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','245620',4701106,'2085','308',943193.29,943193.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','245620',4701107,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','245620',4701108,'2087','308',528307.85,528307.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','245620',4701109,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','245620',4701110,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','245620',4701111,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','246052',4707766,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','246052',4707767,'2085','308',943193.29,943193.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','246052',4707768,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','246052',4707769,'2087','308',528307.85,528307.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','246052',4707770,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','246052',4707771,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','246052',4707772,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','246178',4709987,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','246178',4709988,'2085','308',943193.29,943193.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','246178',4709989,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','246178',4709990,'2087','308',528307.85,528307.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','246178',4709991,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','246178',4709992,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','246178',4709993,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','246328',4712281,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','246328',4712282,'2085','308',943193.29,943193.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','246328',4712283,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','246328',4712284,'2087','308',528307.85,528307.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','246328',4712285,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','246328',4712286,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','246328',4712287,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','246519',4715665,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','246519',4715666,'2085','308',943193.29,943193.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','246519',4715667,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','246519',4715668,'2087','308',528307.85,528307.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','246519',4715669,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','246519',4715670,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','246519',4715671,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','246789',4720360,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','246789',4720361,'2085','308',943193.29,945337.26,2143.97,353755.05,0.00,0.00,0.00,0.00,0.00),('5','131','744','246789',4720362,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','246789',4720363,'2087','308',528307.85,531299.20,2991.35,493572.75,0.00,0.00,0.00,0.00,0.00),('5','131','745','246789',4720364,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','246789',4720365,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','246789',4720366,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','247352',4730447,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','247352',4730448,'2085','308',945337.26,949900.71,4563.45,752969.25,0.00,0.00,0.00,0.00,0.00),('5','131','744','247352',4730449,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','247352',4730450,'2087','308',531299.20,535224.14,3924.94,647615.10,0.00,0.00,0.00,0.00,0.00),('5','131','745','247352',4730451,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','247352',4730452,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','247352',4730453,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','247422',4731284,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','247422',4731285,'2085','308',949900.71,954605.85,4705.14,776348.10,0.00,0.00,0.00,0.00,0.00),('5','131','744','247422',4731286,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','247422',4731287,'2087','308',535224.14,540360.51,5136.37,847501.05,0.00,0.00,0.00,0.00,0.00),('5','131','745','247422',4731288,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','247422',4731289,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','247422',4731290,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','248082',4742626,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','248082',4742627,'2085','308',954605.85,958401.76,3795.91,626325.15,0.00,0.00,0.00,0.00,0.00),('5','131','744','248082',4742628,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','248082',4742629,'2087','308',540360.51,541795.83,1435.32,236827.80,0.00,0.00,0.00,0.00,0.00),('5','131','745','248082',4742630,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','248082',4742631,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','248082',4742632,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','248234',4745121,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','248234',4745122,'2085','308',958401.76,958401.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','248234',4745123,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','248234',4745124,'2087','308',541795.83,542704.92,909.09,149999.85,0.00,0.00,0.00,0.00,0.00),('5','131','745','248234',4745125,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','248234',4745126,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','248234',4745127,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','248267',4745750,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','248267',4745751,'2085','308',958401.76,958401.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','248267',4745752,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','248267',4745753,'2087','308',542704.92,542704.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','248267',4745754,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','248267',4745755,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','248267',4745756,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','248527',4750191,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','248527',4750192,'2085','308',958401.76,958401.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','248527',4750193,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','248527',4750194,'2087','308',542704.92,542704.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','248527',4750195,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','248527',4750196,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','248527',4750197,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','248872',4755966,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','248872',4755967,'2085','308',958401.76,958401.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','248872',4755968,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','248872',4755969,'2087','308',542704.92,542704.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','248872',4755970,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','248872',4755971,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','248872',4755972,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','248972',4757611,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','248972',4757612,'2085','308',958401.76,958401.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','248972',4757613,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','248972',4757614,'2087','308',542704.92,542704.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','248972',4757615,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','248972',4757616,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','248972',4757617,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','249119',4759913,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','249119',4759914,'2085','308',958401.76,958401.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','249119',4759915,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','249119',4759916,'2087','308',542704.92,542704.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','249119',4759917,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','249119',4759918,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','249119',4759919,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','249498',4766562,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','249498',4766563,'2085','308',958401.76,958401.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','249498',4766564,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','249498',4766565,'2087','308',542704.92,542704.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','249498',4766566,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','249498',4766567,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','249498',4766568,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','249626',4768477,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','249626',4768478,'2085','308',958401.76,958401.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','249626',4768479,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','249626',4768480,'2087','308',542704.92,542704.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','249626',4768481,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','249626',4768482,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','249626',4768483,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','249906',4773255,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','249906',4773256,'2085','308',958401.76,958401.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','249906',4773257,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','249906',4773258,'2087','308',542704.92,542704.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','249906',4773259,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','249906',4773260,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','249906',4773261,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','250177',4777941,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','250177',4777942,'2085','308',958401.76,958401.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','250177',4777943,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','250177',4777944,'2087','308',542704.92,542704.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','250177',4777945,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','250177',4777946,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','250177',4777947,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','250217',4778578,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','250217',4778579,'2085','308',958401.76,958401.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','250217',4778580,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','250217',4778581,'2087','308',542704.92,542704.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','250217',4778582,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','250217',4778583,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','250217',4778584,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','250390',4781333,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','250390',4781334,'2085','308',958401.76,958401.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','250390',4781335,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','250390',4781336,'2087','308',542704.92,542704.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','250390',4781337,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','250390',4781338,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','250390',4781339,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','250606',4784957,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','250606',4784958,'2085','308',958401.76,958401.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','250606',4784959,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','250606',4784960,'2087','308',542704.92,542704.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','250606',4784961,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','250606',4784962,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','250606',4784963,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','250829',4788867,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','250829',4788868,'2085','308',958401.76,958401.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','250829',4788869,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','250829',4788870,'2087','308',542704.92,542704.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','250829',4788871,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','250829',4788872,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','250829',4788873,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','251085',4793361,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','251085',4793362,'2085','308',958401.76,958401.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','251085',4793363,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','251085',4793364,'2087','308',542704.92,542704.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','251085',4793365,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','251085',4793366,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','251085',4793367,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','251586',4802038,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','251586',4802039,'2085','308',958401.76,959887.07,1485.31,245076.15,0.00,0.00,0.00,0.00,0.00),('5','131','744','251586',4802040,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','251586',4802041,'2087','308',542704.92,545468.95,2764.03,456064.95,0.00,0.00,0.00,0.00,0.00),('5','131','745','251586',4802042,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','251586',4802043,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','251586',4802044,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','251670',4803813,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','251670',4803814,'2085','308',959887.07,964069.78,4182.71,690147.15,0.00,0.00,0.00,0.00,0.00),('5','131','744','251670',4803815,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','251670',4803816,'2087','308',545468.95,552600.38,7131.43,1176685.95,0.00,0.00,0.00,0.00,0.00),('5','131','745','251670',4803817,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','251670',4803818,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','251670',4803819,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','251841',4806641,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','251841',4806642,'2085','308',964069.78,969538.91,5469.13,902406.45,0.00,0.00,0.00,0.00,0.00),('5','131','744','251841',4806643,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','251841',4806644,'2087','308',552600.38,554731.95,2131.57,351709.05,0.00,0.00,0.00,0.00,0.00),('5','131','745','251841',4806645,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','251841',4806646,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','251841',4806647,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','252053',4810172,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','252053',4810173,'2085','308',969538.91,971196.89,1657.98,273566.70,0.00,0.00,0.00,0.00,0.00),('5','131','744','252053',4810174,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','252053',4810175,'2087','308',554731.95,560924.41,6192.46,1021755.90,0.00,0.00,0.00,0.00,0.00),('5','131','745','252053',4810176,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','252053',4810177,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','252053',4810178,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','252831',4823770,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','252831',4823771,'2085','308',971196.89,971196.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','252831',4823772,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','252831',4823773,'2087','308',560924.41,567193.73,6269.32,1034437.80,0.00,0.00,0.00,0.00,0.00),('5','131','745','252831',4823774,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','252831',4823775,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','252831',4823776,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','252856',4824250,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','252856',4824251,'2085','308',971196.89,971196.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','252856',4824252,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','252856',4824253,'2087','308',567193.73,570332.15,3138.42,517839.30,0.00,0.00,0.00,0.00,0.00),('5','131','745','252856',4824254,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','252856',4824255,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','252856',4824256,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','252898',4824971,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','252898',4824972,'2085','308',971196.89,971196.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','252898',4824973,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','252898',4824974,'2087','308',570332.15,570332.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','252898',4824975,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','252898',4824976,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','252898',4824977,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','253050',4827406,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','253050',4827407,'2085','308',971196.89,971196.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','253050',4827408,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','253050',4827409,'2087','308',570332.15,570332.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','253050',4827410,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','253050',4827411,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','253050',4827412,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','253320',4831927,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','253320',4831928,'2085','308',971196.89,971196.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','253320',4831929,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','253320',4831930,'2087','308',570332.15,570332.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','253320',4831931,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','253320',4831932,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','253320',4831933,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','253525',4835402,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','253525',4835403,'2085','308',971196.89,971196.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','253525',4835404,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','253525',4835405,'2087','308',570332.15,575316.40,4984.25,822401.25,0.00,0.00,0.00,0.00,0.00),('5','131','745','253525',4835406,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','253525',4835407,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','253525',4835408,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','253778',4839823,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','253778',4839824,'2085','308',971196.89,971196.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','253778',4839825,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','253778',4839826,'2087','308',575316.40,580914.17,5597.77,923632.05,0.00,0.00,0.00,0.00,0.00),('5','131','745','253778',4839827,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','253778',4839828,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','253778',4839829,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','254037',4844444,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','254037',4844445,'2085','308',971196.89,971196.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','254037',4844446,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','254037',4844447,'2087','308',580914.17,582292.14,1377.97,227365.05,0.00,0.00,0.00,0.00,0.00),('5','131','745','254037',4844448,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','254037',4844449,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','254037',4844450,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','254257',4848258,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','254257',4848259,'2085','308',971196.89,971196.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','254257',4848260,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','254257',4848261,'2087','308',582292.14,582292.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','254257',4848262,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','254257',4848263,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','254257',4848264,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','254465',4851824,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','254465',4851825,'2085','308',971196.89,971196.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','254465',4851826,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','254465',4851827,'2087','308',582292.14,582292.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','254465',4851828,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','254465',4851829,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','254465',4851830,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','254746',4856601,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','254746',4856602,'2085','308',971196.89,971196.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','254746',4856603,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','254746',4856604,'2087','308',582292.14,582292.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','254746',4856605,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','254746',4856606,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','254746',4856607,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','255004',4861031,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','255004',4861032,'2085','308',971196.89,971196.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','255004',4861033,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','255004',4861034,'2087','308',582292.14,582292.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','255004',4861035,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','255004',4861036,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','255004',4861037,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','255327',4866974,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','255327',4866975,'2085','308',971196.89,971196.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','255327',4866976,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','255327',4866977,'2087','308',582292.14,582292.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','255327',4866978,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','255327',4866979,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','255327',4866980,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','255511',4869678,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','255511',4869679,'2085','308',971196.89,971196.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','255511',4869680,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','255511',4869681,'2087','308',582292.14,582292.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','255511',4869682,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','255511',4869683,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','255511',4869684,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','255855',4875592,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','255855',4875593,'2085','308',971196.89,971196.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','255855',4875594,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','255855',4875595,'2087','308',582292.14,582292.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','255855',4875596,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','255855',4875597,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','255855',4875598,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','255985',4877562,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','255985',4877563,'2085','308',971196.89,971196.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','255985',4877564,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','255985',4877565,'2087','308',582292.14,582292.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','255985',4877566,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','255985',4877567,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','255985',4877568,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','256296',4882548,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','256296',4882549,'2085','308',971196.89,971196.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','256296',4882550,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','256296',4882551,'2087','308',582292.14,582292.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','256296',4882552,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','256296',4882553,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','256296',4882554,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','256689',4889532,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','256689',4889533,'2085','308',971196.89,971196.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','256689',4889534,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','256689',4889535,'2087','308',582292.14,582292.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','256689',4889536,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','256689',4889537,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','256689',4889538,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','256781',4890766,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','256781',4890767,'2085','308',971196.89,971196.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','256781',4890768,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','256781',4890769,'2087','308',582292.14,582292.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','256781',4890770,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','256781',4890771,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','256781',4890772,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257026',4895025,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257026',4895026,'2085','308',971196.89,971196.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257026',4895027,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257026',4895028,'2087','308',582292.14,582292.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257026',4895029,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257026',4895030,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257026',4895031,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257478',4903422,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257478',4903423,'2085','308',971196.89,971196.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257478',4903424,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257478',4903425,'2087','308',582292.14,582292.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257478',4903426,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257478',4903427,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257478',4903428,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257509',4903690,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257509',4903691,'2085','308',971196.89,971196.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257509',4903692,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257509',4903693,'2087','308',582292.14,588166.08,5873.94,969200.10,0.00,0.00,0.00,0.00,0.00),('5','131','745','257509',4903694,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257509',4903695,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257509',4903696,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257510',4903697,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257510',4903698,'2085','308',971196.89,971196.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257510',4903699,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257510',4903700,'2087','308',588166.08,593825.61,5659.53,933822.45,0.00,0.00,0.00,0.00,0.00),('5','131','745','257510',4903701,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257510',4903702,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257510',4903703,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257511',4903704,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257511',4903705,'2085','308',971196.89,971196.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257511',4903706,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257511',4903707,'2087','308',593825.61,599063.77,5238.16,864296.40,0.00,0.00,0.00,0.00,0.00),('5','131','745','257511',4903708,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257511',4903709,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257511',4903710,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257512',4903711,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257512',4903712,'2085','308',971196.89,971196.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257512',4903713,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257512',4903714,'2087','308',599063.77,604265.93,5202.16,858356.40,0.00,0.00,0.00,0.00,0.00),('5','131','745','257512',4903715,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257512',4903716,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257512',4903717,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257513',4903718,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257513',4903719,'2085','308',971196.89,971196.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257513',4903720,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257513',4903721,'2087','308',604265.93,609050.50,4784.57,789454.05,0.00,0.00,0.00,0.00,0.00),('5','131','745','257513',4903722,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257513',4903723,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257513',4903724,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257514',4903725,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257514',4903726,'2085','308',971196.89,971196.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257514',4903727,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257514',4903728,'2087','308',609050.50,614193.79,5143.29,848642.85,0.00,0.00,0.00,0.00,0.00),('5','131','745','257514',4903729,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257514',4903730,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257514',4903731,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257517',4903732,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257517',4903733,'2085','308',971196.89,971196.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257517',4903734,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257517',4903735,'2087','308',614193.79,620158.09,5964.30,984109.50,0.00,0.00,0.00,0.00,0.00),('5','131','745','257517',4903736,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257517',4903737,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257517',4903738,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257518',4903739,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257518',4903740,'2085','308',971196.89,971196.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257518',4903741,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257518',4903742,'2087','308',620158.09,625485.57,5327.48,879034.20,0.00,0.00,0.00,0.00,0.00),('5','131','745','257518',4903743,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257518',4903744,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257518',4903745,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257519',4903746,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257519',4903747,'2085','308',971196.89,971196.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257519',4903748,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257519',4903749,'2087','308',625485.57,630936.88,5451.31,899466.15,0.00,0.00,0.00,0.00,0.00),('5','131','745','257519',4903750,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257519',4903751,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257519',4903752,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257520',4903753,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257520',4903754,'2085','308',971196.89,973417.81,2220.92,366451.80,0.00,0.00,0.00,0.00,0.00),('5','131','744','257520',4903755,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257520',4903756,'2087','308',630936.88,634371.66,3434.78,566738.70,0.00,0.00,0.00,0.00,0.00),('5','131','745','257520',4903757,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257520',4903758,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257520',4903759,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257521',4903760,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257521',4903761,'2085','308',973417.81,978363.04,4945.23,815962.95,0.00,0.00,0.00,0.00,0.00),('5','131','744','257521',4903762,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257521',4903763,'2087','308',634371.66,635287.54,915.88,151120.20,0.00,0.00,0.00,0.00,0.00),('5','131','745','257521',4903764,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257521',4903765,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257521',4903766,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257522',4903767,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257522',4903768,'2085','308',978363.04,984488.55,6125.51,1010709.15,0.00,0.00,0.00,0.00,0.00),('5','131','744','257522',4903769,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257522',4903770,'2087','308',635287.54,635287.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257522',4903771,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257522',4903772,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257522',4903773,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257523',4903774,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257523',4903775,'2085','308',984488.55,990414.00,5925.45,977699.25,0.00,0.00,0.00,0.00,0.00),('5','131','744','257523',4903776,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257523',4903777,'2087','308',635287.54,635287.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257523',4903778,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257523',4903779,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257523',4903780,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257524',4903781,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257524',4903782,'2085','308',990414.00,997725.85,7311.85,1206455.25,0.00,0.00,0.00,0.00,0.00),('5','131','744','257524',4903783,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257524',4903784,'2087','308',635287.54,635287.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257524',4903785,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257524',4903786,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257524',4903787,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257525',4903788,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257525',4903789,'2085','308',997725.85,1004115.57,6389.72,1054303.80,0.00,0.00,0.00,0.00,0.00),('5','131','744','257525',4903790,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257525',4903791,'2087','308',635287.54,635287.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257525',4903792,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257525',4903793,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257525',4903794,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257526',4903795,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257526',4903796,'2085','308',1004115.57,1008512.77,4397.20,725538.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257526',4903797,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257526',4903798,'2087','308',635287.54,635287.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257526',4903799,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257526',4903800,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257526',4903801,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257527',4903802,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257527',4903803,'2085','308',1008512.77,1011559.65,3046.88,502735.20,0.00,0.00,0.00,0.00,0.00),('5','131','744','257527',4903804,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257527',4903805,'2087','308',635287.54,635287.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257527',4903806,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257527',4903807,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257527',4903808,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257528',4903809,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257528',4903810,'2085','308',1011559.65,1015669.31,4109.66,678093.90,0.00,0.00,0.00,0.00,0.00),('5','131','744','257528',4903811,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257528',4903812,'2087','308',635287.54,640955.03,5667.49,935135.85,0.00,0.00,0.00,0.00,0.00),('5','131','745','257528',4903813,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257528',4903814,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257528',4903815,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257529',4903816,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257529',4903817,'2085','308',1015669.31,1016539.55,870.24,143589.60,0.00,0.00,0.00,0.00,0.00),('5','131','744','257529',4903818,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257529',4903819,'2087','308',640955.03,645066.67,4111.64,678420.60,0.00,0.00,0.00,0.00,0.00),('5','131','745','257529',4903820,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257529',4903821,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257529',4903822,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257530',4903823,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257530',4903824,'2085','308',1016539.55,1016539.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257530',4903825,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257530',4903826,'2087','308',645066.67,647970.22,2903.55,479085.75,0.00,0.00,0.00,0.00,0.00),('5','131','745','257530',4903827,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257530',4903828,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257530',4903829,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257531',4903830,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257531',4903831,'2085','308',1016539.55,1016539.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257531',4903832,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257531',4903833,'2087','308',647970.22,647970.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257531',4903834,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257531',4903835,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257531',4903836,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257532',4903837,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257532',4903838,'2085','308',1016539.55,1016539.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257532',4903839,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257532',4903840,'2087','308',647970.22,647970.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257532',4903841,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257532',4903842,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257532',4903843,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257533',4903844,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257533',4903845,'2085','308',1016539.55,1023154.57,6615.02,1091478.30,0.00,0.00,0.00,0.00,0.00),('5','131','744','257533',4903846,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257533',4903847,'2087','308',647970.22,653571.65,5601.43,924235.95,0.00,0.00,0.00,0.00,0.00),('5','131','745','257533',4903848,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257533',4903849,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257533',4903850,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257534',4903851,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257534',4903852,'2085','308',1023154.57,1029018.08,5863.51,967479.15,0.00,0.00,0.00,0.00,0.00),('5','131','744','257534',4903853,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257534',4903854,'2087','308',653571.65,658888.45,5316.80,877272.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257534',4903855,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257534',4903856,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257534',4903857,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257535',4903858,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257535',4903859,'2085','308',1029018.08,1029911.60,893.52,147430.80,0.00,0.00,0.00,0.00,0.00),('5','131','744','257535',4903860,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257535',4903861,'2087','308',658888.45,663888.57,5000.12,825019.80,0.00,0.00,0.00,0.00,0.00),('5','131','745','257535',4903862,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257535',4903863,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257535',4903864,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257536',4903865,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257536',4903866,'2085','308',1029911.60,1029911.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257536',4903867,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257536',4903868,'2087','308',663888.57,672027.24,8138.67,1342880.55,0.00,0.00,0.00,0.00,0.00),('5','131','745','257536',4903869,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257536',4903870,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257536',4903871,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257537',4903872,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257537',4903873,'2085','308',1029911.60,1029911.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257537',4903874,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257537',4903875,'2087','308',672027.24,675191.08,3163.84,522033.60,0.00,0.00,0.00,0.00,0.00),('5','131','745','257537',4903876,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257537',4903877,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257537',4903878,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257538',4903879,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257538',4903880,'2085','308',1029911.60,1029911.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257538',4903881,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257538',4903882,'2087','308',675191.08,675285.98,94.90,15658.50,0.00,0.00,0.00,0.00,0.00),('5','131','745','257538',4903883,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257538',4903884,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257538',4903885,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257539',4903886,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257539',4903887,'2085','308',1029911.60,1029911.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257539',4903888,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257539',4903889,'2087','308',675285.98,675285.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257539',4903890,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257539',4903891,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257539',4903892,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257540',4903893,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257540',4903894,'2085','308',1029911.60,1029911.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257540',4903895,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257540',4903896,'2087','308',675285.98,675285.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257540',4903897,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257540',4903898,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257540',4903899,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257541',4903900,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257541',4903901,'2085','308',1029911.60,1029911.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257541',4903902,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257541',4903903,'2087','308',675285.98,682377.18,7091.20,1170048.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257541',4903904,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257541',4903905,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257541',4903906,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257542',4903907,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257542',4903908,'2085','308',1029911.60,1029911.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257542',4903909,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257542',4903910,'2087','308',682377.18,687703.19,5326.01,878791.65,0.00,0.00,0.00,0.00,0.00),('5','131','745','257542',4903911,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257542',4903912,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257542',4903913,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257543',4903914,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257543',4903915,'2085','308',1029911.60,1029911.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257543',4903916,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257543',4903917,'2087','308',687703.19,691453.20,3750.01,618751.65,0.00,0.00,0.00,0.00,0.00),('5','131','745','257543',4903918,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257543',4903919,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257543',4903920,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257544',4903921,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257544',4903922,'2085','308',1029911.60,1029911.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257544',4903923,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257544',4903924,'2087','308',691453.20,691453.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257544',4903925,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257544',4903926,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257544',4903927,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257545',4903928,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257545',4903929,'2085','308',1029911.60,1029911.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257545',4903930,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257545',4903931,'2087','308',691453.20,691453.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257545',4903932,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257545',4903933,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257545',4903934,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257546',4903935,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257546',4903936,'2085','308',1029911.60,1029911.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257546',4903937,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257546',4903938,'2087','308',691453.20,691453.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257546',4903939,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257546',4903940,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257546',4903941,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257547',4903942,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257547',4903943,'2085','308',1029911.60,1029911.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257547',4903944,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257547',4903945,'2087','308',691453.20,691453.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257547',4903946,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257547',4903947,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257547',4903948,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257548',4903949,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257548',4903950,'2085','308',1029911.60,1029911.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257548',4903951,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257548',4903952,'2087','308',691453.20,691453.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257548',4903953,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257548',4903954,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257548',4903955,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257549',4903956,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257549',4903957,'2085','308',1029911.60,1029911.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257549',4903958,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257549',4903959,'2087','308',691453.20,691453.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257549',4903960,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257549',4903961,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257549',4903962,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257550',4903963,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257550',4903964,'2085','308',1029911.60,1029911.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257550',4903965,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257550',4903966,'2087','308',691453.20,691453.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257550',4903967,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257550',4903968,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257550',4903969,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257551',4903970,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257551',4903971,'2085','308',1029911.60,1029911.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257551',4903972,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257551',4903973,'2087','308',691453.20,691453.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257551',4903974,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257551',4903975,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257551',4903976,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257552',4903977,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257552',4903978,'2085','308',1029911.60,1029911.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257552',4903979,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257552',4903980,'2087','308',691453.20,691453.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257552',4903981,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257552',4903982,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257552',4903983,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257553',4903984,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257553',4903985,'2085','308',1029911.60,1029911.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257553',4903986,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257553',4903987,'2087','308',691453.20,691453.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257553',4903988,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257553',4903989,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257553',4903990,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257554',4903991,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257554',4903992,'2085','308',1029911.60,1029911.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257554',4903993,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257554',4903994,'2087','308',691453.20,691453.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257554',4903995,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257554',4903996,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257554',4903997,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257555',4903998,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257555',4903999,'2085','308',1029911.60,1036066.82,6155.22,1015611.30,0.00,0.00,0.00,0.00,0.00),('5','131','744','257555',4904000,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257555',4904001,'2087','308',691453.20,698945.34,7492.14,1236203.10,0.00,0.00,0.00,0.00,0.00),('5','131','745','257555',4904002,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257555',4904003,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257555',4904004,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257556',4904005,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257556',4904006,'2085','308',1036066.82,1036066.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257556',4904007,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257556',4904008,'2087','308',698945.34,705404.12,6458.78,1065698.70,0.00,0.00,0.00,0.00,0.00),('5','131','745','257556',4904009,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257556',4904010,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257556',4904011,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257557',4904012,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257557',4904013,'2085','308',1036066.82,1042244.38,6177.56,1019297.40,0.00,0.00,0.00,0.00,0.00),('5','131','744','257557',4904014,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257557',4904015,'2087','308',705404.12,705404.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257557',4904016,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257557',4904017,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257557',4904018,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257558',4904019,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257558',4904020,'2085','308',1042244.38,1044600.89,2356.51,388824.15,0.00,0.00,0.00,0.00,0.00),('5','131','744','257558',4904021,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257558',4904022,'2087','308',705404.12,706239.23,835.11,137793.15,0.00,0.00,0.00,0.00,0.00),('5','131','745','257558',4904023,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257558',4904024,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257558',4904025,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257559',4904026,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257559',4904027,'2085','308',1044600.89,1044600.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257559',4904028,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257559',4904029,'2087','308',706239.23,706239.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257559',4904030,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257559',4904031,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257559',4904032,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257560',4904033,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257560',4904034,'2085','308',1044600.89,1044600.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257560',4904035,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257560',4904036,'2087','308',706239.23,706239.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257560',4904037,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257560',4904038,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257560',4904039,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257561',4904040,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257561',4904041,'2085','308',1044600.89,1044600.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257561',4904042,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257561',4904043,'2087','308',706239.23,706239.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257561',4904044,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257561',4904045,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257561',4904046,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257562',4904047,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257562',4904048,'2085','308',1044600.89,1044600.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257562',4904049,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257562',4904050,'2087','308',706239.23,706239.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257562',4904051,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257562',4904052,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257562',4904053,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257563',4904054,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257563',4904055,'2085','308',1044600.89,1044600.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257563',4904056,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257563',4904057,'2087','308',706239.23,706239.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257563',4904058,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257563',4904059,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257563',4904060,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257564',4904061,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257564',4904062,'2085','308',1044600.89,1044600.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257564',4904063,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257564',4904064,'2087','308',706239.23,711888.05,5648.82,932055.30,0.00,0.00,0.00,0.00,0.00),('5','131','745','257564',4904065,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257564',4904066,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257564',4904067,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257565',4904068,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257565',4904069,'2085','308',1044600.89,1044600.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257565',4904070,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257565',4904071,'2087','308',711888.05,717144.08,5256.03,867244.95,0.00,0.00,0.00,0.00,0.00),('5','131','745','257565',4904072,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257565',4904073,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257565',4904074,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257566',4904075,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257566',4904076,'2085','308',1044600.89,1044600.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257566',4904077,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257566',4904078,'2087','308',717144.08,719440.30,2296.22,378876.30,0.00,0.00,0.00,0.00,0.00),('5','131','745','257566',4904079,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257566',4904080,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257566',4904081,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257567',4904082,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257567',4904083,'2085','308',1044600.89,1044600.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257567',4904084,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257567',4904085,'2087','308',719440.30,719440.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257567',4904086,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257567',4904087,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257567',4904088,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257568',4904089,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257568',4904090,'2085','308',1044600.89,1044600.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257568',4904091,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257568',4904092,'2087','308',719440.30,719440.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257568',4904093,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257568',4904094,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257568',4904095,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257569',4904096,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257569',4904097,'2085','308',1044600.89,1044600.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257569',4904098,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257569',4904099,'2087','308',719440.30,719440.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257569',4904100,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257569',4904101,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257569',4904102,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257570',4904103,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257570',4904104,'2085','308',1044600.89,1044600.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257570',4904105,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257570',4904106,'2087','308',719440.30,719440.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257570',4904107,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257570',4904108,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257570',4904109,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257571',4904110,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257571',4904111,'2085','308',1044600.89,1044600.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257571',4904112,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257571',4904113,'2087','308',719440.30,719440.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257571',4904114,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257571',4904115,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257571',4904116,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257572',4904117,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257572',4904118,'2085','308',1044600.89,1044600.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257572',4904119,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257572',4904120,'2087','308',719440.30,719440.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257572',4904121,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257572',4904122,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257572',4904123,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257573',4904124,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257573',4904125,'2085','308',1044600.89,1044600.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257573',4904126,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257573',4904127,'2087','308',719440.30,719440.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257573',4904128,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257573',4904129,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257573',4904130,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257574',4904131,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257574',4904132,'2085','308',1044600.89,1044600.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257574',4904133,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257574',4904134,'2087','308',719440.30,719440.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257574',4904135,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257574',4904136,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257574',4904137,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257575',4904138,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257575',4904139,'2085','308',1044600.89,1044600.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257575',4904140,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257575',4904141,'2087','308',719440.30,719440.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257575',4904142,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257575',4904143,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257575',4904144,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257576',4904145,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257576',4904146,'2085','308',1044600.89,1044600.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257576',4904147,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257576',4904148,'2087','308',719440.30,719440.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257576',4904149,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257576',4904150,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257576',4904151,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257577',4904152,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257577',4904153,'2085','308',1044600.89,1044600.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257577',4904154,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257577',4904155,'2087','308',719440.30,719440.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257577',4904156,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257577',4904157,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257577',4904158,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257578',4904159,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257578',4904160,'2085','308',1044600.89,1044600.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257578',4904161,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257578',4904162,'2087','308',719440.30,719440.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257578',4904163,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257578',4904164,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257578',4904165,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257579',4904166,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257579',4904167,'2085','308',1044600.89,1044600.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257579',4904168,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257579',4904169,'2087','308',719440.30,719440.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257579',4904170,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257579',4904171,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257579',4904172,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257580',4904173,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257580',4904174,'2085','308',1044600.89,1044600.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257580',4904175,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257580',4904176,'2087','308',719440.30,719440.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257580',4904177,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257580',4904178,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257580',4904179,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257581',4904180,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257581',4904181,'2085','308',1044600.89,1044600.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257581',4904182,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257581',4904183,'2087','308',719440.30,719440.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257581',4904184,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257581',4904185,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257581',4904186,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257582',4904187,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257582',4904188,'2085','308',1044600.89,1044600.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257582',4904189,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257582',4904190,'2087','308',719440.30,719440.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257582',4904191,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257582',4904192,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257582',4904193,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257583',4904194,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257583',4904195,'2085','308',1044600.89,1044600.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257583',4904196,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257583',4904197,'2087','308',719440.30,719940.28,499.98,82496.70,0.00,0.00,0.00,0.00,0.00),('5','131','745','257583',4904198,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257583',4904199,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257583',4904200,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257584',4904201,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257584',4904202,'2085','308',1044600.89,1044600.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257584',4904203,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257584',4904204,'2087','308',719940.28,725983.63,6043.35,997152.75,0.00,0.00,0.00,0.00,0.00),('5','131','745','257584',4904205,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257584',4904206,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257584',4904207,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257585',4904208,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257585',4904209,'2085','308',1044600.89,1044600.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257585',4904210,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257585',4904211,'2087','308',725983.63,730840.97,4857.34,801461.10,0.00,0.00,0.00,0.00,0.00),('5','131','745','257585',4904212,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257585',4904213,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257585',4904214,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257586',4904215,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257586',4904216,'2085','308',1044600.89,1044600.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257586',4904217,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257586',4904218,'2087','308',730840.97,734314.68,3473.71,573162.15,0.00,0.00,0.00,0.00,0.00),('5','131','745','257586',4904219,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257586',4904220,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257586',4904221,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257587',4904222,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257587',4904223,'2085','308',1044600.89,1044600.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257587',4904224,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257587',4904225,'2087','308',734314.68,734314.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257587',4904226,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257587',4904227,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257587',4904228,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257588',4904229,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257588',4904230,'2085','308',1044600.89,1044600.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257588',4904231,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257588',4904232,'2087','308',734314.68,734314.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257588',4904233,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257588',4904234,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257588',4904235,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257589',4904236,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257589',4904237,'2085','308',1044600.89,1044600.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257589',4904238,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257589',4904239,'2087','308',734314.68,734314.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257589',4904240,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257589',4904241,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257589',4904242,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257590',4904243,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257590',4904244,'2085','308',1044600.89,1044600.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257590',4904245,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257590',4904246,'2087','308',734314.68,734314.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257590',4904247,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257590',4904248,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257590',4904249,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257591',4904250,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257591',4904251,'2085','308',1044600.89,1044600.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257591',4904252,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257591',4904253,'2087','308',734314.68,734314.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257591',4904254,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257591',4904255,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257591',4904256,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257592',4904257,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257592',4904258,'2085','308',1044600.89,1044600.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257592',4904259,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257592',4904260,'2087','308',734314.68,739364.54,5049.86,833226.90,0.00,0.00,0.00,0.00,0.00),('5','131','745','257592',4904261,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257592',4904262,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257592',4904263,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257593',4904264,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257593',4904265,'2085','308',1044600.89,1044600.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257593',4904266,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257593',4904267,'2087','308',739364.54,739364.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257593',4904268,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257593',4904269,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257593',4904270,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257594',4904271,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257594',4904272,'2085','308',1044600.89,1044600.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257594',4904273,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257594',4904274,'2087','308',739364.54,739364.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257594',4904275,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257594',4904276,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257594',4904277,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257595',4904278,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257595',4904279,'2085','308',1044600.89,1044600.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257595',4904280,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257595',4904281,'2087','308',739364.54,739364.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257595',4904282,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257595',4904283,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257595',4904284,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257596',4904285,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257596',4904286,'2085','308',1044600.89,1044600.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257596',4904287,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257596',4904288,'2087','308',739364.54,739364.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257596',4904289,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257596',4904290,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257596',4904291,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257597',4904292,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257597',4904293,'2085','308',1044600.89,1044600.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257597',4904294,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257597',4904295,'2087','308',739364.54,739364.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257597',4904296,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257597',4904297,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257597',4904298,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257598',4904299,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257598',4904300,'2085','308',1044600.89,1044600.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257598',4904301,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257598',4904302,'2087','308',739364.54,739364.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257598',4904303,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257598',4904304,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257598',4904305,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257599',4904306,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257599',4904307,'2085','308',1044600.89,1044600.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257599',4904308,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257599',4904309,'2087','308',739364.54,741758.34,2393.80,394977.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257599',4904310,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257599',4904311,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257599',4904312,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257600',4904313,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257600',4904314,'2085','308',1044600.89,1044950.32,349.43,57655.95,0.00,0.00,0.00,0.00,0.00),('5','131','744','257600',4904315,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257600',4904316,'2087','308',741758.34,746606.32,4847.98,799916.70,0.00,0.00,0.00,0.00,0.00),('5','131','745','257600',4904317,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257600',4904318,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257600',4904319,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257601',4904320,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257601',4904321,'2085','308',1044950.32,1050962.19,6011.87,991958.55,0.00,0.00,0.00,0.00,0.00),('5','131','744','257601',4904322,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257601',4904323,'2087','308',746606.32,748312.49,1706.17,281518.05,0.00,0.00,0.00,0.00,0.00),('5','131','745','257601',4904324,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257601',4904325,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257601',4904326,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257602',4904327,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257602',4904328,'2085','308',1050962.19,1057126.01,6163.82,1017030.30,0.00,0.00,0.00,0.00,0.00),('5','131','744','257602',4904329,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257602',4904330,'2087','308',748312.49,748312.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257602',4904331,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257602',4904332,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257602',4904333,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257603',4904334,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257603',4904335,'2085','308',1057126.01,1060205.03,3079.02,508038.30,0.00,0.00,0.00,0.00,0.00),('5','131','744','257603',4904336,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257603',4904337,'2087','308',748312.49,748312.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257603',4904338,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257603',4904339,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257603',4904340,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257604',4904341,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257604',4904342,'2085','308',1060205.03,1068314.71,8109.68,1338097.20,0.00,0.00,0.00,0.00,0.00),('5','131','744','257604',4904343,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257604',4904344,'2087','308',748312.49,748312.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257604',4904345,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257604',4904346,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257604',4904347,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257605',4904348,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257605',4904349,'2085','308',1068314.71,1076484.75,8170.04,1348056.60,0.00,0.00,0.00,0.00,0.00),('5','131','744','257605',4904350,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257605',4904351,'2087','308',748312.49,748312.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257605',4904352,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257605',4904353,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257605',4904354,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257606',4904355,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257606',4904356,'2085','308',1076484.75,1082809.35,6324.60,1043559.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257606',4904357,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257606',4904358,'2087','308',748312.49,750796.32,2483.83,409831.95,0.00,0.00,0.00,0.00,0.00),('5','131','745','257606',4904359,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257606',4904360,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257606',4904361,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257607',4904362,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257607',4904363,'2085','308',1082809.35,1082809.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257607',4904364,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257607',4904365,'2087','308',750796.32,750796.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257607',4904366,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257607',4904367,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257607',4904368,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257608',4904369,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257608',4904370,'2085','308',1082809.35,1082809.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257608',4904371,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257608',4904372,'2087','308',750796.32,750796.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257608',4904373,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257608',4904374,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257608',4904375,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257609',4904376,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257609',4904377,'2085','308',1082809.35,1082809.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257609',4904378,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257609',4904379,'2087','308',750796.32,750796.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257609',4904380,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257609',4904381,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257609',4904382,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257610',4904383,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257610',4904384,'2085','308',1082809.35,1082809.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257610',4904385,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257610',4904386,'2087','308',750796.32,750796.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257610',4904387,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257610',4904388,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257610',4904389,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257611',4904390,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257611',4904391,'2085','308',1082809.35,1089373.79,6564.44,1083132.60,0.00,0.00,0.00,0.00,0.00),('5','131','744','257611',4904392,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257611',4904393,'2087','308',750796.32,750796.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257611',4904394,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257611',4904395,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257611',4904396,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257612',4904397,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257612',4904398,'2085','308',1089373.79,1092734.52,3360.73,554520.45,0.00,0.00,0.00,0.00,0.00),('5','131','744','257612',4904399,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257612',4904400,'2087','308',750796.32,750796.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257612',4904401,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257612',4904402,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257612',4904403,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257613',4904404,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257613',4904405,'2085','308',1092734.52,1092734.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257613',4904406,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257613',4904407,'2087','308',750796.32,751836.67,1040.35,171657.75,0.00,0.00,0.00,0.00,0.00),('5','131','745','257613',4904408,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257613',4904409,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257613',4904410,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257614',4904411,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257614',4904412,'2085','308',1092734.52,1092734.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257614',4904413,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257614',4904414,'2087','308',751836.67,751836.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257614',4904415,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257614',4904416,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257614',4904417,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257615',4904418,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257615',4904419,'2085','308',1092734.52,1092734.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257615',4904420,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257615',4904421,'2087','308',751836.67,751836.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257615',4904422,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257615',4904423,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257615',4904424,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257616',4904425,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257616',4904426,'2085','308',1092734.52,1092734.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257616',4904427,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257616',4904428,'2087','308',751836.67,751836.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257616',4904429,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257616',4904430,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257616',4904431,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257617',4904432,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257617',4904433,'2085','308',1092734.52,1092734.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257617',4904434,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257617',4904435,'2087','308',751836.67,751836.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257617',4904436,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257617',4904437,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257617',4904438,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257618',4904439,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257618',4904440,'2085','308',1092734.52,1092734.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257618',4904441,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257618',4904442,'2087','308',751836.67,751836.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257618',4904443,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257618',4904444,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257618',4904445,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257619',4904446,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257619',4904447,'2085','308',1092734.52,1092734.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257619',4904448,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257619',4904449,'2087','308',751836.67,751836.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257619',4904450,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257619',4904451,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257619',4904452,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257620',4904453,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257620',4904454,'2085','308',1092734.52,1094463.01,1728.49,285200.85,0.00,0.00,0.00,0.00,0.00),('5','131','744','257620',4904455,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257620',4904456,'2087','308',751836.67,753738.49,1901.82,313800.30,0.00,0.00,0.00,0.00,0.00),('5','131','745','257620',4904457,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257620',4904458,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257620',4904459,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257621',4904460,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257621',4904461,'2085','308',1094463.01,1096816.75,2353.74,388367.10,0.00,0.00,0.00,0.00,0.00),('5','131','744','257621',4904462,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257621',4904463,'2087','308',753738.49,756219.81,2481.32,409417.80,0.00,0.00,0.00,0.00,0.00),('5','131','745','257621',4904464,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257621',4904465,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257621',4904466,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257622',4904467,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257622',4904468,'2085','308',1096816.75,1096816.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257622',4904469,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257622',4904470,'2087','308',756219.81,761359.31,5139.50,848017.50,0.00,0.00,0.00,0.00,0.00),('5','131','745','257622',4904471,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257622',4904472,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257622',4904473,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257623',4904474,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257623',4904475,'2085','308',1096816.75,1100648.74,3831.99,632278.35,0.00,0.00,0.00,0.00,0.00),('5','131','744','257623',4904476,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257623',4904477,'2087','308',761359.31,762055.06,695.75,114798.75,0.00,0.00,0.00,0.00,0.00),('5','131','745','257623',4904478,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257623',4904479,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257623',4904480,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257624',4904481,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257624',4904482,'2085','308',1100648.74,1100648.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257624',4904483,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257624',4904484,'2087','308',762055.06,762055.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257624',4904485,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257624',4904486,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257624',4904487,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257625',4904488,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257625',4904489,'2085','308',1100648.74,1100648.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257625',4904490,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257625',4904491,'2087','308',762055.06,762055.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257625',4904492,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257625',4904493,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257625',4904494,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257626',4904495,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257626',4904496,'2085','308',1100648.74,1100648.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257626',4904497,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257626',4904498,'2087','308',762055.06,762055.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257626',4904499,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257626',4904500,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257626',4904501,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257627',4904502,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257627',4904503,'2085','308',1100648.74,1100648.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257627',4904504,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257627',4904505,'2087','308',762055.06,762055.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257627',4904506,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257627',4904507,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257627',4904508,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257628',4904509,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257628',4904510,'2085','308',1100648.74,1100648.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257628',4904511,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257628',4904512,'2087','308',762055.06,762055.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257628',4904513,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257628',4904514,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257628',4904515,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257629',4904516,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257629',4904517,'2085','308',1100648.74,1100648.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257629',4904518,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257629',4904519,'2087','308',762055.06,762055.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257629',4904520,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257629',4904521,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257629',4904522,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257630',4904523,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257630',4904524,'2085','308',1100648.74,1100648.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257630',4904525,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257630',4904526,'2087','308',762055.06,762055.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257630',4904527,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257630',4904528,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257630',4904529,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257631',4904530,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257631',4904531,'2085','308',1100648.74,1100648.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257631',4904532,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257631',4904533,'2087','308',762055.06,762055.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257631',4904534,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257631',4904535,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257631',4904536,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257632',4904537,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257632',4904538,'2085','308',1100648.74,1100648.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257632',4904539,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257632',4904540,'2087','308',762055.06,762055.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257632',4904541,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257632',4904542,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257632',4904543,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257633',4904544,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257633',4904545,'2085','308',1100648.74,1100648.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257633',4904546,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257633',4904547,'2087','308',762055.06,762055.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257633',4904548,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257633',4904549,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257633',4904550,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257634',4904551,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257634',4904552,'2085','308',1100648.74,1100648.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257634',4904553,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257634',4904554,'2087','308',762055.06,762055.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257634',4904555,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257634',4904556,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257634',4904557,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257635',4904558,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257635',4904559,'2085','308',1100648.74,1100648.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257635',4904560,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257635',4904561,'2087','308',762055.06,762055.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257635',4904562,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257635',4904563,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257635',4904564,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257636',4904565,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257636',4904566,'2085','308',1100648.74,1100648.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257636',4904567,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257636',4904568,'2087','308',762055.06,762055.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257636',4904569,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257636',4904570,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257636',4904571,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257637',4904572,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257637',4904573,'2085','308',1100648.74,1100648.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257637',4904574,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257637',4904575,'2087','308',762055.06,762055.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257637',4904576,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257637',4904577,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257637',4904578,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257638',4904579,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257638',4904580,'2085','308',1100648.74,1101116.12,467.38,77117.70,0.00,0.00,0.00,0.00,0.00),('5','131','744','257638',4904581,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257638',4904582,'2087','308',762055.06,765718.90,3663.84,604533.60,0.00,0.00,0.00,0.00,0.00),('5','131','745','257638',4904583,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257638',4904584,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257638',4904585,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257639',4904586,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257639',4904587,'2085','308',1101116.12,1101116.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257639',4904588,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257639',4904589,'2087','308',765718.90,770888.99,5170.09,853064.85,0.00,0.00,0.00,0.00,0.00),('5','131','745','257639',4904590,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257639',4904591,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257639',4904592,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257640',4904593,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257640',4904594,'2085','308',1101116.12,1101116.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257640',4904595,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257640',4904596,'2087','308',770888.99,774681.79,3792.80,625812.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257640',4904597,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257640',4904598,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257640',4904599,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257641',4904600,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257641',4904601,'2085','308',1101116.12,1101116.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257641',4904602,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257641',4904603,'2087','308',774681.79,776544.91,1863.12,307414.80,0.00,0.00,0.00,0.00,0.00),('5','131','745','257641',4904604,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257641',4904605,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257641',4904606,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257642',4904607,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257642',4904608,'2085','308',1101116.12,1101116.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257642',4904609,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257642',4904610,'2087','308',776544.91,776544.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257642',4904611,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257642',4904612,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257642',4904613,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257643',4904614,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257643',4904615,'2085','308',1101116.12,1101116.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257643',4904616,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257643',4904617,'2087','308',776544.91,776544.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257643',4904618,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257643',4904619,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257643',4904620,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257644',4904621,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257644',4904622,'2085','308',1101116.12,1101116.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257644',4904623,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257644',4904624,'2087','308',776544.91,776544.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257644',4904625,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257644',4904626,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257644',4904627,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257645',4904628,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257645',4904629,'2085','308',1101116.12,1101116.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257645',4904630,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257645',4904631,'2087','308',776544.91,776544.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257645',4904632,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257645',4904633,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257645',4904634,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257646',4904635,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257646',4904636,'2085','308',1101116.12,1101116.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257646',4904637,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257646',4904638,'2087','308',776544.91,776544.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257646',4904639,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257646',4904640,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257646',4904641,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257647',4904642,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257647',4904643,'2085','308',1101116.12,1101116.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257647',4904644,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257647',4904645,'2087','308',776544.91,776544.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257647',4904646,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257647',4904647,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257647',4904648,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257648',4904649,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257648',4904650,'2085','308',1101116.12,1101116.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257648',4904651,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257648',4904652,'2087','308',776544.91,776544.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257648',4904653,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257648',4904654,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257648',4904655,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257649',4904656,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257649',4904657,'2085','308',1101116.12,1101116.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257649',4904658,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257649',4904659,'2087','308',776544.91,776544.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257649',4904660,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257649',4904661,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257649',4904662,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257650',4904663,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257650',4904664,'2085','308',1101116.12,1101116.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257650',4904665,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257650',4904666,'2087','308',776544.91,776544.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257650',4904667,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257650',4904668,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257650',4904669,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257651',4904670,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257651',4904671,'2085','308',1101116.12,1101116.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257651',4904672,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257651',4904673,'2087','308',776544.91,776544.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257651',4904674,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257651',4904675,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257651',4904676,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257652',4904677,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257652',4904678,'2085','308',1101116.12,1101116.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257652',4904679,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257652',4904680,'2087','308',776544.91,776544.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257652',4904681,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257652',4904682,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257652',4904683,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257653',4904684,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257653',4904685,'2085','308',1101116.12,1101116.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257653',4904686,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257653',4904687,'2087','308',776544.91,776544.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257653',4904688,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257653',4904689,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257653',4904690,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257654',4904691,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257654',4904692,'2085','308',1101116.12,1101116.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257654',4904693,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257654',4904694,'2087','308',776544.91,776544.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257654',4904695,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257654',4904696,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257654',4904697,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257655',4904698,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257655',4904699,'2085','308',1101116.12,1101116.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257655',4904700,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257655',4904701,'2087','308',776544.91,776544.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257655',4904702,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257655',4904703,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257655',4904704,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257656',4904705,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257656',4904706,'2085','308',1101116.12,1101116.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257656',4904707,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257656',4904708,'2087','308',776544.91,776544.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257656',4904709,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257656',4904710,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257656',4904711,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257657',4904712,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257657',4904713,'2085','308',1101116.12,1101116.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257657',4904714,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257657',4904715,'2087','308',776544.91,776544.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257657',4904716,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257657',4904717,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257657',4904718,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257658',4904719,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257658',4904720,'2085','308',1101116.12,1101116.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257658',4904721,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257658',4904722,'2087','308',776544.91,776544.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257658',4904723,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257658',4904724,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257658',4904725,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257659',4904726,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257659',4904727,'2085','308',1101116.12,1101116.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257659',4904728,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257659',4904729,'2087','308',776544.91,776544.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257659',4904730,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257659',4904731,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257659',4904732,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257660',4904733,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257660',4904734,'2085','308',1101116.12,1101116.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257660',4904735,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257660',4904736,'2087','308',776544.91,776544.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257660',4904737,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257660',4904738,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257660',4904739,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257661',4904740,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257661',4904741,'2085','308',1101116.12,1101116.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257661',4904742,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257661',4904743,'2087','308',776544.91,776544.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257661',4904744,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257661',4904745,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257661',4904746,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257662',4904747,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257662',4904748,'2085','308',1101116.12,1101116.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257662',4904749,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257662',4904750,'2087','308',776544.91,776544.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257662',4904751,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257662',4904752,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257662',4904753,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257663',4904754,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257663',4904755,'2085','308',1101116.12,1101116.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257663',4904756,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257663',4904757,'2087','308',776544.91,776544.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257663',4904758,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257663',4904759,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257663',4904760,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257664',4904761,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257664',4904762,'2085','308',1101116.12,1101116.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257664',4904763,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257664',4904764,'2087','308',776544.91,776544.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257664',4904765,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257664',4904766,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257664',4904767,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257665',4904768,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257665',4904769,'2085','308',1101116.12,1101116.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257665',4904770,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257665',4904771,'2087','308',776544.91,776544.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257665',4904772,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257665',4904773,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257665',4904774,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257666',4904775,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257666',4904776,'2085','308',1101116.12,1101116.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257666',4904777,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257666',4904778,'2087','308',776544.91,776544.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257666',4904779,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257666',4904780,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257666',4904781,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257667',4904782,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257667',4904783,'2085','308',1101116.12,1101116.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257667',4904784,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257667',4904785,'2087','308',776544.91,776544.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257667',4904786,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257667',4904787,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257667',4904788,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257668',4904789,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257668',4904790,'2085','308',1101116.12,1101116.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257668',4904791,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257668',4904792,'2087','308',776544.91,776544.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257668',4904793,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257668',4904794,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257668',4904795,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257669',4904796,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257669',4904797,'2085','308',1101116.12,1101116.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257669',4904798,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257669',4904799,'2087','308',776544.91,776544.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257669',4904800,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257669',4904801,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257669',4904802,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257670',4904803,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257670',4904804,'2085','308',1101116.12,1101116.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257670',4904805,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257670',4904806,'2087','308',776544.91,776544.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257670',4904807,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257670',4904808,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257670',4904809,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257671',4904810,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257671',4904811,'2085','308',1101116.12,1101116.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257671',4904812,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257671',4904813,'2087','308',776544.91,776544.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257671',4904814,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257671',4904815,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257671',4904816,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257672',4904817,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257672',4904818,'2085','308',1101116.12,1101116.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257672',4904819,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257672',4904820,'2087','308',776544.91,776544.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257672',4904821,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257672',4904822,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257672',4904823,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257673',4904824,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257673',4904825,'2085','308',1101116.12,1101116.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257673',4904826,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257673',4904827,'2087','308',776544.91,776544.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257673',4904828,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257673',4904829,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257673',4904830,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257674',4904831,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257674',4904832,'2085','308',1101116.12,1101116.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257674',4904833,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257674',4904834,'2087','308',776544.91,776544.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257674',4904835,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257674',4904836,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257674',4904837,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257675',4904838,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257675',4904839,'2085','308',1101116.12,1101116.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257675',4904840,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257675',4904841,'2087','308',776544.91,776544.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257675',4904842,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257675',4904843,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257675',4904844,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257676',4904845,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257676',4904846,'2085','308',1101116.12,1101116.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257676',4904847,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257676',4904848,'2087','308',776544.91,776544.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257676',4904849,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257676',4904850,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257676',4904851,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257677',4904852,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257677',4904853,'2085','308',1101116.12,1101116.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257677',4904854,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257677',4904855,'2087','308',776544.91,776544.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257677',4904856,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257677',4904857,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257677',4904858,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257678',4904859,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257678',4904860,'2085','308',1101116.12,1101116.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257678',4904861,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257678',4904862,'2087','308',776544.91,776544.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257678',4904863,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257678',4904864,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257678',4904865,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257679',4904866,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257679',4904867,'2085','308',1101116.12,1101116.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257679',4904868,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257679',4904869,'2087','308',776544.91,776544.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257679',4904870,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257679',4904871,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257679',4904872,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257680',4904873,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257680',4904874,'2085','308',1101116.12,1101116.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257680',4904875,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257680',4904876,'2087','308',776544.91,776544.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257680',4904877,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257680',4904878,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257680',4904879,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257681',4904880,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257681',4904881,'2085','308',1101116.12,1101116.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257681',4904882,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257681',4904883,'2087','308',776544.91,776544.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257681',4904884,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257681',4904885,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257681',4904886,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257682',4904887,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257682',4904888,'2085','308',1101116.12,1101116.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257682',4904889,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257682',4904890,'2087','308',776544.91,776544.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257682',4904891,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257682',4904892,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257682',4904893,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257683',4904894,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257683',4904895,'2085','308',1101116.12,1101116.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257683',4904896,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257683',4904897,'2087','308',776544.91,783663.78,7118.87,1316990.95,0.00,0.00,0.00,0.00,0.00),('5','131','745','257683',4904898,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257683',4904899,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257683',4904900,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257684',4904901,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257684',4904902,'2085','308',1101116.12,1104127.69,3011.57,557140.45,0.00,0.00,0.00,0.00,0.00),('5','131','744','257684',4904903,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257684',4904904,'2087','308',783663.78,787785.50,4121.72,762518.20,0.00,0.00,0.00,0.00,0.00),('5','131','745','257684',4904905,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257684',4904906,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257684',4904907,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257685',4904908,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257685',4904909,'2085','308',1104127.69,1104127.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257685',4904910,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257685',4904911,'2087','308',787785.50,793330.26,5544.76,1025780.60,0.00,0.00,0.00,0.00,0.00),('5','131','745','257685',4904912,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257685',4904913,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257685',4904914,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257686',4904915,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257686',4904916,'2085','308',1104127.69,1104888.93,761.24,140829.40,0.00,0.00,0.00,0.00,0.00),('5','131','744','257686',4904917,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257686',4904918,'2087','308',793330.26,799550.05,6219.79,1150661.15,0.00,0.00,0.00,0.00,0.00),('5','131','745','257686',4904919,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257686',4904920,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257686',4904921,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257687',4904922,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257687',4904923,'2085','308',1104888.93,1104888.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257687',4904924,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257687',4904925,'2087','308',799550.05,806563.29,7013.24,1297449.40,0.00,0.00,0.00,0.00,0.00),('5','131','745','257687',4904926,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257687',4904927,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257687',4904928,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257688',4904929,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257688',4904930,'2085','308',1104888.93,1109352.56,4463.63,736498.95,0.00,0.00,0.00,0.00,0.00),('5','131','744','257688',4904931,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257688',4904932,'2087','308',806563.29,806563.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257688',4904933,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257688',4904934,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257688',4904935,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257689',4904936,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257689',4904937,'2085','308',1109352.56,1114460.87,5108.31,945037.35,0.00,0.00,0.00,0.00,0.00),('5','131','744','257689',4904938,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257689',4904939,'2087','308',806563.29,806563.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257689',4904940,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257689',4904941,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257689',4904942,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257690',4904943,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257690',4904944,'2085','308',1114460.87,1116336.32,1875.45,346958.25,0.00,0.00,0.00,0.00,0.00),('5','131','744','257690',4904945,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257690',4904946,'2087','308',806563.29,806563.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257690',4904947,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257690',4904948,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257690',4904949,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257691',4904950,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257691',4904951,'2085','308',1116336.32,1116336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257691',4904952,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257691',4904953,'2087','308',806563.29,806563.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257691',4904954,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257691',4904955,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257691',4904956,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257692',4904957,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257692',4904958,'2085','308',1116336.32,1116336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257692',4904959,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257692',4904960,'2087','308',806563.29,806563.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257692',4904961,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257692',4904962,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257692',4904963,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257693',4904964,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257693',4904965,'2085','308',1116336.32,1116336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257693',4904966,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257693',4904967,'2087','308',806563.29,806563.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257693',4904968,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257693',4904969,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257693',4904970,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257694',4904971,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257694',4904972,'2085','308',1116336.32,1116336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257694',4904973,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257694',4904974,'2087','308',806563.29,806563.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257694',4904975,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257694',4904976,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257694',4904977,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257695',4904978,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257695',4904979,'2085','308',1116336.32,1116336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257695',4904980,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257695',4904981,'2087','308',806563.29,806563.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257695',4904982,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257695',4904983,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257695',4904984,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257696',4904985,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257696',4904986,'2085','308',1116336.32,1116336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257696',4904987,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257696',4904988,'2087','308',806563.29,806563.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257696',4904989,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257696',4904990,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257696',4904991,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257697',4904992,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257697',4904993,'2085','308',1116336.32,1116336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257697',4904994,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257697',4904995,'2087','308',806563.29,806563.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257697',4904996,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257697',4904997,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257697',4904998,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257698',4904999,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257698',4905000,'2085','308',1116336.32,1116336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257698',4905001,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257698',4905002,'2087','308',806563.29,806563.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257698',4905003,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257698',4905004,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257698',4905005,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257699',4905006,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257699',4905007,'2085','308',1116336.32,1116336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257699',4905008,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257699',4905009,'2087','308',806563.29,806563.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257699',4905010,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257699',4905011,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257699',4905012,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257700',4905013,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257700',4905014,'2085','308',1116336.32,1116336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257700',4905015,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257700',4905016,'2087','308',806563.29,806563.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257700',4905017,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257700',4905018,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257700',4905019,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257701',4905020,'2084','308',611703.79,611703.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257701',4905021,'2085','308',1116336.32,1116336.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','744','257701',4905022,'2086','308',394221.84,394221.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257701',4905023,'2087','308',806563.29,806563.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257701',4905024,'2088','308',607829.78,607829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','745','257701',4905025,'2089','308',83599.99,83599.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','131','747','257701',4905026,'2090','309',126718.86,126718.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=730237 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('5','131','181745','308',0.00,0.00,0.00,0.00,0.00,0.00,0.00,533054),('5','131','181745','309',0.00,0.00,0.00,0.00,0.00,0.00,0.00,533055),('5','131','181745','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,533056),('5','131','182968','308',0.00,163.00,5127.34,0.00,0.00,0.00,0.00,536346),('5','131','182968','309',0.00,250.00,88.04,0.00,0.00,0.00,0.00,536347),('5','131','182968','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,536348),('5','131','182972','308',0.00,163.00,3624.17,0.00,0.00,0.00,0.00,536358),('5','131','182972','309',0.00,250.00,168.40,0.00,0.00,0.00,0.00,536359),('5','131','182972','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,536360),('5','131','182973','308',163.00,163.00,0.00,0.00,0.00,0.00,0.00,536361),('5','131','182973','309',0.00,250.00,135.76,0.00,0.00,0.00,0.00,536362),('5','131','182973','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,536363),('5','131','186255','308',163.00,0.00,0.00,0.00,0.00,0.00,0.00,544989),('5','131','186255','309',0.00,265.00,380.73,0.00,0.00,0.00,0.00,544990),('5','131','186255','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,544991),('5','131','186258','308',163.00,0.00,0.00,0.00,0.00,0.00,0.00,544998),('5','131','186258','309',0.00,265.00,242.95,0.00,0.00,0.00,0.00,544999),('5','131','186258','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,545000),('5','131','186259','308',163.00,0.00,0.00,0.00,0.00,0.00,0.00,545001),('5','131','186259','309',0.00,265.00,449.75,0.00,0.00,0.00,0.00,545002),('5','131','186259','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,545003),('5','131','186262','308',163.00,0.00,0.00,0.00,0.00,0.00,0.00,545008),('5','131','186262','309',0.00,265.00,203.69,0.00,0.00,0.00,0.00,545009),('5','131','186262','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,545010),('5','131','186265','308',163.00,0.00,0.00,0.00,0.00,0.00,0.00,545016),('5','131','186265','309',0.00,265.00,86.79,0.00,0.00,0.00,0.00,545017),('5','131','186265','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,545018),('5','131','186266','308',163.00,0.00,0.00,0.00,0.00,0.00,0.00,545019),('5','131','186266','309',0.00,255.00,127.52,0.00,0.00,0.00,0.00,545020),('5','131','186266','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,545021),('5','131','186268','308',163.00,0.00,0.00,0.00,0.00,0.00,0.00,545025),('5','131','186268','309',0.00,255.00,461.23,0.00,0.00,0.00,0.00,545026),('5','131','186268','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,545027),('5','131','186274','308',163.00,163.00,3306.72,0.00,0.00,0.00,0.00,545031),('5','131','186274','309',0.00,255.00,438.62,0.00,0.00,0.00,0.00,545032),('5','131','186274','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,545033),('5','131','186403','308',163.00,163.00,2475.95,0.00,0.00,0.00,0.00,545366),('5','131','186403','309',0.00,255.00,441.09,0.00,0.00,0.00,0.00,545367),('5','131','186403','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,545368),('5','131','186409','308',163.00,163.00,0.00,0.00,0.00,0.00,0.00,545383),('5','131','186409','309',0.00,255.00,542.64,0.00,0.00,0.00,0.00,545384),('5','131','186409','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,545385),('5','131','186411','308',163.00,163.00,2486.63,0.00,0.00,0.00,0.00,545389),('5','131','186411','309',0.00,265.00,235.26,0.00,0.00,0.00,0.00,545390),('5','131','186411','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,545391),('5','131','186422','308',163.00,163.00,8643.17,0.00,0.00,0.00,0.00,545420),('5','131','186422','309',0.00,265.00,262.13,0.00,0.00,0.00,0.00,545421),('5','131','186422','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,545422),('5','131','186423','308',163.00,163.00,8074.00,0.00,0.00,0.00,0.00,545423),('5','131','186423','309',0.00,265.00,342.25,0.00,0.00,0.00,0.00,545424),('5','131','186423','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,545425),('5','131','186475','308',163.00,163.00,5053.66,0.00,0.00,0.00,0.00,545569),('5','131','186475','309',0.00,265.00,378.13,0.00,0.00,0.00,0.00,545570),('5','131','186475','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,545571),('5','131','186477','308',163.00,163.00,8252.29,0.00,0.00,0.00,0.00,545573),('5','131','186477','309',0.00,265.00,0.00,0.00,0.00,0.00,0.00,545574),('5','131','186477','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,545575),('5','131','186602','308',163.00,163.00,9002.25,0.00,0.00,0.00,0.00,545895),('5','131','186602','309',0.00,265.00,0.00,0.00,0.00,0.00,0.00,545896),('5','131','186602','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,545897),('5','131','186608','308',163.00,163.00,6079.56,0.00,0.00,0.00,0.00,545913),('5','131','186608','309',0.00,265.00,0.00,0.00,0.00,0.00,0.00,545914),('5','131','186608','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,545915),('5','131','186651','308',163.00,163.00,4684.14,0.00,0.00,0.00,0.00,546010),('5','131','186651','309',0.00,265.00,0.00,0.00,0.00,0.00,0.00,546011),('5','131','186651','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,546012),('5','131','186724','308',163.00,163.00,9043.17,0.00,0.00,0.00,0.00,546214),('5','131','186724','309',0.00,265.00,0.00,0.00,0.00,0.00,0.00,546215),('5','131','186724','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,546216),('5','131','187660','308',163.00,163.00,8466.95,0.00,0.00,0.00,0.00,548648),('5','131','187660','309',0.00,265.00,0.00,0.00,0.00,0.00,0.00,548649),('5','131','187660','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,548650),('5','131','187692','308',163.00,163.00,9012.15,0.00,0.00,0.00,0.00,548734),('5','131','187692','309',0.00,0.00,0.00,0.00,0.00,0.00,0.00,548735),('5','131','187692','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,548736),('5','131','187701','308',163.00,163.00,8137.35,0.00,0.00,0.00,0.00,548757),('5','131','187701','309',0.00,0.00,0.00,0.00,0.00,0.00,0.00,548758),('5','131','187701','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,548759),('5','131','187857','308',163.00,163.00,9435.26,0.00,0.00,0.00,0.00,549164),('5','131','187857','309',0.00,0.00,0.00,0.00,0.00,0.00,0.00,549165),('5','131','187857','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,549166),('5','131','188109','308',163.00,163.00,621.45,0.00,0.00,0.00,0.00,549819),('5','131','188109','309',0.00,0.00,0.00,0.00,0.00,0.00,0.00,549820),('5','131','188109','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,549821),('5','131','188111','308',163.00,163.00,4084.04,0.00,0.00,0.00,0.00,549825),('5','131','188111','309',0.00,0.00,0.00,0.00,0.00,0.00,0.00,549826),('5','131','188111','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,549827),('5','131','188113','308',163.00,163.00,10205.18,0.00,0.00,0.00,0.00,549831),('5','131','188113','309',0.00,0.00,0.00,0.00,0.00,0.00,0.00,549832),('5','131','188113','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,549833),('5','131','188566','308',163.00,163.00,12185.59,0.00,0.00,0.00,0.00,551002),('5','131','188566','309',0.00,265.00,0.00,0.00,0.00,0.00,0.00,551003),('5','131','188566','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,551004),('5','131','188568','308',163.00,163.00,9963.86,0.00,0.00,0.00,0.00,551008),('5','131','188568','309',0.00,265.00,208.48,0.00,0.00,0.00,0.00,551009),('5','131','188568','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,551010),('5','131','188645','308',163.00,163.00,6915.50,0.00,0.00,0.00,0.00,551193),('5','131','188645','309',265.00,265.00,109.48,0.00,0.00,0.00,0.00,551194),('5','131','188645','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,551195),('5','131','188942','308',163.00,163.00,10632.76,0.00,0.00,0.00,0.00,551992),('5','131','188942','309',265.00,265.00,172.86,0.00,0.00,0.00,0.00,551993),('5','131','188942','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,551994),('5','131','189159','308',163.00,163.00,13665.87,0.00,0.00,0.00,0.00,552566),('5','131','189159','309',265.00,265.00,261.62,0.00,0.00,0.00,0.00,552567),('5','131','189159','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,552568),('5','131','189252','308',163.00,163.00,11422.59,0.00,0.00,0.00,0.00,552796),('5','131','189252','309',265.00,265.00,558.70,0.00,0.00,0.00,0.00,552797),('5','131','189252','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,552798),('5','131','189524','308',163.00,163.00,127.05,0.00,0.00,0.00,0.00,553507),('5','131','189524','309',265.00,265.00,365.76,0.00,0.00,0.00,0.00,553508),('5','131','189524','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,553509),('5','131','189689','308',163.00,163.00,0.00,0.00,0.00,0.00,0.00,553930),('5','131','189689','309',265.00,265.00,279.05,0.00,0.00,0.00,0.00,553931),('5','131','189689','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,553932),('5','131','189970','308',163.00,163.00,0.00,0.00,0.00,0.00,0.00,554670),('5','131','189970','309',265.00,265.00,299.59,0.00,0.00,0.00,0.00,554671),('5','131','189970','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,554672),('5','131','190108','308',163.00,163.00,0.00,0.00,0.00,0.00,0.00,555023),('5','131','190108','309',265.00,265.00,169.62,0.00,0.00,0.00,0.00,555024),('5','131','190108','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,555025),('5','131','190252','308',163.00,163.00,0.00,0.00,0.00,0.00,0.00,555394),('5','131','190252','309',265.00,265.00,375.53,0.00,0.00,0.00,0.00,555395),('5','131','190252','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,555396),('5','131','190486','308',163.00,163.00,0.00,0.00,0.00,0.00,0.00,556010),('5','131','190486','309',265.00,265.00,189.56,0.00,0.00,0.00,0.00,556011),('5','131','190486','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556012),('5','131','190756','308',163.00,165.00,0.00,0.00,0.00,0.00,0.00,556732),('5','131','190756','309',265.00,265.00,572.41,0.00,0.00,0.00,0.00,556733),('5','131','190756','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556734),('5','131','190942','308',163.00,165.00,0.00,0.00,0.00,0.00,0.00,557210),('5','131','190942','309',265.00,265.00,399.98,0.00,0.00,0.00,0.00,557211),('5','131','190942','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,557212),('5','131','191195','308',163.00,165.00,0.00,0.00,0.00,0.00,0.00,557890),('5','131','191195','309',265.00,265.00,207.17,0.00,0.00,0.00,0.00,557891),('5','131','191195','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,557892),('5','131','191457','308',163.00,165.00,0.00,0.00,0.00,0.00,0.00,558584),('5','131','191457','309',265.00,265.00,133.59,0.00,0.00,0.00,0.00,558585),('5','131','191457','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,558586),('5','131','191608','308',163.00,165.00,0.00,0.00,0.00,0.00,0.00,558979),('5','131','191608','309',265.00,265.00,218.70,0.00,0.00,0.00,0.00,558980),('5','131','191608','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,558981),('5','131','191905','308',163.00,165.00,0.00,0.00,0.00,0.00,0.00,559785),('5','131','191905','309',265.00,265.00,417.11,0.00,0.00,0.00,0.00,559786),('5','131','191905','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,559787),('5','131','191984','308',163.00,165.00,0.00,0.00,0.00,0.00,0.00,559974),('5','131','191984','309',265.00,265.00,379.74,0.00,0.00,0.00,0.00,559975),('5','131','191984','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,559976),('5','131','192189','308',163.00,165.00,0.00,0.00,0.00,0.00,0.00,560518),('5','131','192189','309',265.00,265.00,604.60,0.00,0.00,0.00,0.00,560519),('5','131','192189','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,560520),('5','131','192338','308',163.00,165.00,6645.27,0.00,0.00,0.00,0.00,560913),('5','131','192338','309',265.00,265.00,710.67,0.00,0.00,0.00,0.00,560914),('5','131','192338','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,560915),('5','131','192725','308',163.00,165.00,8826.89,0.00,0.00,0.00,0.00,561930),('5','131','192725','309',265.00,265.00,320.37,0.00,0.00,0.00,0.00,561931),('5','131','192725','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,561932),('5','131','193502','308',163.00,165.00,6490.12,0.00,0.00,0.00,0.00,563963),('5','131','193502','309',265.00,265.00,504.86,0.00,0.00,0.00,0.00,563964),('5','131','193502','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,563965),('5','131','193988','308',163.00,165.00,6047.65,0.00,0.00,0.00,0.00,565183),('5','131','193988','309',265.00,265.00,235.83,0.00,0.00,0.00,0.00,565184),('5','131','193988','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,565185),('5','131','194132','308',163.00,165.00,4766.02,0.00,0.00,0.00,0.00,565544),('5','131','194132','309',265.00,265.00,464.39,0.00,0.00,0.00,0.00,565545),('5','131','194132','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,565546),('5','131','195587','308',165.00,165.00,5748.95,0.00,0.00,0.00,0.00,569300),('5','131','195587','309',265.00,265.00,411.73,0.00,0.00,0.00,0.00,569301),('5','131','195587','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,569302),('5','131','195590','308',165.00,165.00,1037.59,0.00,0.00,0.00,0.00,569309),('5','131','195590','309',265.00,265.00,303.70,0.00,0.00,0.00,0.00,569310),('5','131','195590','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,569311),('5','131','195593','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,569318),('5','131','195593','309',265.00,265.00,402.60,0.00,0.00,0.00,0.00,569319),('5','131','195593','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,569320),('5','131','195596','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,569327),('5','131','195596','309',265.00,265.00,330.02,0.00,0.00,0.00,0.00,569328),('5','131','195596','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,569329),('5','131','195599','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,569335),('5','131','195599','309',265.00,265.00,457.12,0.00,0.00,0.00,0.00,569336),('5','131','195599','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,569337),('5','131','195600','308',165.00,165.00,1932.12,0.00,0.00,0.00,0.00,569338),('5','131','195600','309',265.00,265.00,378.30,0.00,0.00,0.00,0.00,569339),('5','131','195600','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,569340),('5','131','195602','308',165.00,165.00,3929.42,0.00,0.00,0.00,0.00,569344),('5','131','195602','309',265.00,265.00,370.30,0.00,0.00,0.00,0.00,569345),('5','131','195602','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,569346),('5','131','195605','308',165.00,165.00,4343.99,0.00,0.00,0.00,0.00,569353),('5','131','195605','309',265.00,265.00,195.89,0.00,0.00,0.00,0.00,569354),('5','131','195605','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,569355),('5','131','195609','308',165.00,165.00,4990.14,0.00,0.00,0.00,0.00,569363),('5','131','195609','309',265.00,265.00,283.00,0.00,0.00,0.00,0.00,569364),('5','131','195609','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,569365),('5','131','195610','308',165.00,165.00,4298.65,0.00,0.00,0.00,0.00,569366),('5','131','195610','309',265.00,265.00,416.75,0.00,0.00,0.00,0.00,569367),('5','131','195610','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,569368),('5','131','195666','308',165.00,165.00,4002.05,0.00,0.00,0.00,0.00,569481),('5','131','195666','309',265.00,265.00,278.30,0.00,0.00,0.00,0.00,569482),('5','131','195666','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,569483),('5','131','195936','308',165.00,165.00,2572.24,0.00,0.00,0.00,0.00,570184),('5','131','195936','309',265.00,265.00,348.42,0.00,0.00,0.00,0.00,570185),('5','131','195936','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,570186),('5','131','196049','308',165.00,165.00,4498.67,0.00,0.00,0.00,0.00,570468),('5','131','196049','309',265.00,265.00,220.72,0.00,0.00,0.00,0.00,570469),('5','131','196049','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,570470),('5','131','196533','308',165.00,165.00,4471.90,0.00,0.00,0.00,0.00,571704),('5','131','196533','309',265.00,265.00,234.57,0.00,0.00,0.00,0.00,571705),('5','131','196533','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,571706),('5','131','196738','308',165.00,165.00,3544.09,0.00,0.00,0.00,0.00,572232),('5','131','196738','309',265.00,265.00,219.98,0.00,0.00,0.00,0.00,572233),('5','131','196738','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,572234),('5','131','196834','308',165.00,165.00,2170.29,0.00,0.00,0.00,0.00,572489),('5','131','196834','309',265.00,265.00,255.89,0.00,0.00,0.00,0.00,572490),('5','131','196834','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,572491),('5','131','197048','308',165.00,165.00,1368.87,0.00,0.00,0.00,0.00,573032),('5','131','197048','309',265.00,265.00,291.13,0.00,0.00,0.00,0.00,573033),('5','131','197048','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,573034),('5','131','197432','308',165.00,165.00,4740.43,0.00,0.00,0.00,0.00,573965),('5','131','197432','309',265.00,265.00,166.96,0.00,0.00,0.00,0.00,573966),('5','131','197432','310',0.00,250.00,0.00,0.00,0.00,0.00,0.00,573967),('5','131','197713','308',165.00,165.00,6926.75,0.00,0.00,0.00,0.00,574683),('5','131','197713','309',265.00,265.00,21.98,0.00,0.00,0.00,0.00,574684),('5','131','197713','310',0.00,260.00,0.00,0.00,0.00,0.00,0.00,574685),('5','131','198305','308',165.00,165.00,1420.42,0.00,0.00,0.00,0.00,576239),('5','131','198305','309',265.00,270.00,20.56,0.00,0.00,0.00,0.00,576240),('5','131','198305','310',0.00,270.00,0.00,0.00,0.00,0.00,0.00,576241),('5','131','198308','308',165.00,165.00,3158.38,0.00,0.00,0.00,0.00,576248),('5','131','198308','309',265.00,270.00,256.45,0.00,0.00,0.00,0.00,576249),('5','131','198308','310',0.00,270.00,0.00,0.00,0.00,0.00,0.00,576250),('5','131','198511','308',165.00,165.00,4195.62,0.00,0.00,0.00,0.00,576789),('5','131','198511','309',265.00,270.00,701.61,0.00,0.00,0.00,0.00,576790),('5','131','198511','310',0.00,270.00,0.00,0.00,0.00,0.00,0.00,576791),('5','131','198760','308',165.00,165.00,3712.77,0.00,0.00,0.00,0.00,577395),('5','131','198760','309',265.00,0.00,469.84,0.00,0.00,0.00,0.00,577396),('5','131','198760','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,577397),('5','131','199184','308',165.00,0.00,0.00,0.00,0.00,0.00,0.00,578475),('5','131','199184','309',265.00,0.00,0.00,0.00,0.00,0.00,0.00,578476),('5','131','199184','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,578477),('5','131','199269','308',165.00,165.00,2646.27,0.00,0.00,0.00,0.00,578670),('5','131','199269','309',270.00,270.00,474.15,0.00,0.00,0.00,0.00,578671),('5','131','199269','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,578672),('5','131','199282','308',165.00,165.00,3894.32,0.00,0.00,0.00,0.00,578690),('5','131','199282','309',270.00,270.00,524.96,0.00,0.00,0.00,0.00,578691),('5','131','199282','310',0.00,250.00,0.00,0.00,0.00,0.00,0.00,578692),('5','131','199285','308',165.00,165.00,4838.25,0.00,0.00,0.00,0.00,578697),('5','131','199285','309',270.00,270.00,542.02,0.00,0.00,0.00,0.00,578698),('5','131','199285','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,578699),('5','131','199553','308',165.00,165.00,4858.39,0.00,0.00,0.00,0.00,579391),('5','131','199553','309',270.00,270.00,382.59,0.00,0.00,0.00,0.00,579392),('5','131','199553','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,579393),('5','131','199758','308',165.00,165.00,4532.51,0.00,0.00,0.00,0.00,579878),('5','131','199758','309',270.00,270.00,721.73,0.00,0.00,0.00,0.00,579879),('5','131','199758','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,579880),('5','131','199903','308',165.00,165.00,3161.22,0.00,0.00,0.00,0.00,580238),('5','131','199903','309',270.00,270.00,198.24,0.00,0.00,0.00,0.00,580239),('5','131','199903','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,580240),('5','131','200098','308',165.00,165.00,6008.83,0.00,0.00,0.00,0.00,580763),('5','131','200098','309',270.00,270.00,193.20,0.00,0.00,0.00,0.00,580764),('5','131','200098','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,580765),('5','131','200344','308',165.00,165.00,6035.31,0.00,0.00,0.00,0.00,581395),('5','131','200344','309',270.00,270.00,251.58,0.00,0.00,0.00,0.00,581396),('5','131','200344','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,581397),('5','131','200745','308',165.00,165.00,5620.74,0.00,0.00,0.00,0.00,582443),('5','131','200745','309',270.00,270.00,222.76,0.00,0.00,0.00,0.00,582444),('5','131','200745','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,582445),('5','131','200841','308',165.00,165.00,5268.83,0.00,0.00,0.00,0.00,582697),('5','131','200841','309',270.00,270.00,469.80,0.00,0.00,0.00,0.00,582698),('5','131','200841','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,582699),('5','131','200915','308',165.00,165.00,4808.79,0.00,0.00,0.00,0.00,582881),('5','131','200915','309',270.00,270.00,347.70,0.00,0.00,0.00,0.00,582882),('5','131','200915','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,582883),('5','131','201193','308',165.00,165.00,5431.18,0.00,0.00,0.00,0.00,583582),('5','131','201193','309',270.00,270.00,631.14,0.00,0.00,0.00,0.00,583583),('5','131','201193','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,583584),('5','131','201316','308',165.00,165.00,4660.89,0.00,0.00,0.00,0.00,583905),('5','131','201316','309',270.00,270.00,271.88,0.00,0.00,0.00,0.00,583906),('5','131','201316','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,583907),('5','131','201713','308',165.00,165.00,4798.34,0.00,0.00,0.00,0.00,584961),('5','131','201713','309',270.00,270.00,412.59,0.00,0.00,0.00,0.00,584962),('5','131','201713','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,584963),('5','131','202009','308',165.00,165.00,5304.71,0.00,0.00,0.00,0.00,585745),('5','131','202009','309',275.00,275.00,172.78,0.00,0.00,0.00,0.00,585746),('5','131','202009','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,585747),('5','131','202041','308',165.00,165.00,4544.55,0.00,0.00,0.00,0.00,585813),('5','131','202041','309',275.00,275.00,394.40,0.00,0.00,0.00,0.00,585814),('5','131','202041','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,585815),('5','131','202407','308',165.00,165.00,4558.28,0.00,0.00,0.00,0.00,586761),('5','131','202407','309',275.00,275.00,330.88,0.00,0.00,0.00,0.00,586762),('5','131','202407','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,586763),('5','131','202420','308',165.00,165.00,4964.56,0.00,0.00,0.00,0.00,586788),('5','131','202420','309',275.00,275.00,419.62,0.00,0.00,0.00,0.00,586789),('5','131','202420','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,586790),('5','131','202643','308',165.00,165.00,4916.89,0.00,0.00,0.00,0.00,587359),('5','131','202643','309',275.00,275.00,395.24,0.00,0.00,0.00,0.00,587360),('5','131','202643','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,587361),('5','131','202880','308',165.00,165.00,3653.63,0.00,0.00,0.00,0.00,587955),('5','131','202880','309',275.00,275.00,365.86,0.00,0.00,0.00,0.00,587956),('5','131','202880','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,587957),('5','131','203188','308',165.00,165.00,5200.72,0.00,0.00,0.00,0.00,588773),('5','131','203188','309',275.00,275.00,333.43,0.00,0.00,0.00,0.00,588774),('5','131','203188','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,588775),('5','131','203293','308',165.00,165.00,4927.96,0.00,0.00,0.00,0.00,589060),('5','131','203293','309',275.00,275.00,374.81,0.00,0.00,0.00,0.00,589061),('5','131','203293','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,589062),('5','131','203513','308',165.00,165.00,4269.38,0.00,0.00,0.00,0.00,589611),('5','131','203513','309',275.00,275.00,615.17,0.00,0.00,0.00,0.00,589612),('5','131','203513','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,589613),('5','131','203714','308',165.00,165.00,4701.99,0.00,0.00,0.00,0.00,590134),('5','131','203714','309',275.00,275.00,543.88,0.00,0.00,0.00,0.00,590135),('5','131','203714','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,590136),('5','131','203992','308',165.00,165.00,4137.18,0.00,0.00,0.00,0.00,590829),('5','131','203992','309',275.00,275.00,219.22,0.00,0.00,0.00,0.00,590830),('5','131','203992','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,590831),('5','131','204180','308',165.00,165.00,4366.04,0.00,0.00,0.00,0.00,591347),('5','131','204180','309',275.00,275.00,474.78,0.00,0.00,0.00,0.00,591348),('5','131','204180','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,591349),('5','131','204431','308',165.00,165.00,4495.79,0.00,0.00,0.00,0.00,591978),('5','131','204431','309',275.00,275.00,322.51,0.00,0.00,0.00,0.00,591979),('5','131','204431','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,591980),('5','131','204601','308',165.00,165.00,4759.96,0.00,0.00,0.00,0.00,592427),('5','131','204601','309',275.00,275.00,422.59,0.00,0.00,0.00,0.00,592428),('5','131','204601','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,592429),('5','131','204853','308',165.00,165.00,3928.45,0.00,0.00,0.00,0.00,593027),('5','131','204853','309',275.00,275.00,0.00,0.00,0.00,0.00,0.00,593028),('5','131','204853','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,593029),('5','131','205088','308',165.00,165.00,4039.90,0.00,0.00,0.00,0.00,593626),('5','131','205088','309',275.00,275.00,0.00,0.00,0.00,0.00,0.00,593627),('5','131','205088','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,593628),('5','131','205290','308',165.00,165.00,4847.41,0.00,0.00,0.00,0.00,594160),('5','131','205290','309',275.00,275.00,0.00,0.00,0.00,0.00,0.00,594161),('5','131','205290','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,594162),('5','131','205532','308',165.00,165.00,3766.25,0.00,0.00,0.00,0.00,594771),('5','131','205532','309',280.00,275.00,0.00,0.00,0.00,0.00,0.00,594772),('5','131','205532','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,594773),('5','131','205879','308',165.00,165.00,4687.14,0.00,0.00,0.00,0.00,595687),('5','131','205879','309',280.00,280.00,0.00,0.00,0.00,0.00,0.00,595688),('5','131','205879','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,595689),('5','131','205942','308',165.00,165.00,4849.68,0.00,0.00,0.00,0.00,595844),('5','131','205942','309',280.00,275.00,0.00,0.00,0.00,0.00,0.00,595845),('5','131','205942','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,595846),('5','131','206207','308',165.00,165.00,5684.83,0.00,0.00,0.00,0.00,596519),('5','131','206207','309',290.00,290.00,0.00,0.00,0.00,0.00,0.00,596520),('5','131','206207','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,596521),('5','131','206596','308',165.00,165.00,6357.88,0.00,0.00,0.00,0.00,597503),('5','131','206596','309',290.00,290.00,0.00,0.00,0.00,0.00,0.00,597504),('5','131','206596','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,597505),('5','131','206646','308',165.00,165.00,4538.18,0.00,0.00,0.00,0.00,597632),('5','131','206646','309',290.00,290.00,0.00,0.00,0.00,0.00,0.00,597633),('5','131','206646','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,597634),('5','131','206781','308',165.00,165.00,4354.93,0.00,0.00,0.00,0.00,597995),('5','131','206781','309',290.00,290.00,0.00,0.00,0.00,0.00,0.00,597996),('5','131','206781','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,597997),('5','131','207102','308',165.00,165.00,1568.86,0.00,0.00,0.00,0.00,598816),('5','131','207102','309',290.00,290.00,0.00,0.00,0.00,0.00,0.00,598817),('5','131','207102','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,598818),('5','131','207325','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,599398),('5','131','207325','309',290.00,290.00,0.00,0.00,0.00,0.00,0.00,599399),('5','131','207325','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,599400),('5','131','207666','308',165.00,165.00,2090.78,0.00,0.00,0.00,0.00,600272),('5','131','207666','309',290.00,290.00,0.00,0.00,0.00,0.00,0.00,600273),('5','131','207666','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,600274),('5','131','207713','308',165.00,165.00,4426.35,0.00,0.00,0.00,0.00,600383),('5','131','207713','309',290.00,290.00,0.00,0.00,0.00,0.00,0.00,600384),('5','131','207713','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,600385),('5','131','208224','308',165.00,165.00,4731.57,0.00,0.00,0.00,0.00,601698),('5','131','208224','309',290.00,290.00,0.00,0.00,0.00,0.00,0.00,601699),('5','131','208224','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,601700),('5','131','208300','308',165.00,165.00,4003.11,0.00,0.00,0.00,0.00,601907),('5','131','208300','309',290.00,290.00,0.00,0.00,0.00,0.00,0.00,601908),('5','131','208300','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,601909),('5','131','208451','308',165.00,165.00,4753.50,0.00,0.00,0.00,0.00,602279),('5','131','208451','309',290.00,290.00,0.00,0.00,0.00,0.00,0.00,602280),('5','131','208451','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,602281),('5','131','208664','308',165.00,165.00,4314.32,0.00,0.00,0.00,0.00,602827),('5','131','208664','309',290.00,290.00,0.00,0.00,0.00,0.00,0.00,602828),('5','131','208664','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,602829),('5','131','208876','308',165.00,165.00,4209.18,0.00,0.00,0.00,0.00,603351),('5','131','208876','309',290.00,290.00,0.00,0.00,0.00,0.00,0.00,603352),('5','131','208876','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,603353),('5','131','209084','308',165.00,165.00,3046.43,0.00,0.00,0.00,0.00,603884),('5','131','209084','309',290.00,290.00,0.00,0.00,0.00,0.00,0.00,603885),('5','131','209084','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,603886),('5','131','209399','308',165.00,165.00,4059.71,0.00,0.00,0.00,0.00,604705),('5','131','209399','309',290.00,290.00,0.00,0.00,0.00,0.00,0.00,604706),('5','131','209399','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,604707),('5','131','209621','308',165.00,165.00,5361.56,0.00,0.00,0.00,0.00,605277),('5','131','209621','309',290.00,290.00,0.00,0.00,0.00,0.00,0.00,605278),('5','131','209621','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,605279),('5','131','209844','308',165.00,165.00,5315.53,0.00,0.00,0.00,0.00,605854),('5','131','209844','309',290.00,290.00,0.00,0.00,0.00,0.00,0.00,605855),('5','131','209844','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,605856),('5','131','210080','308',163.00,163.00,4396.45,0.00,0.00,0.00,0.00,606465),('5','131','210080','309',290.00,290.00,0.00,0.00,0.00,0.00,0.00,606466),('5','131','210080','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,606467),('5','131','210261','308',163.00,163.00,4306.50,0.00,0.00,0.00,0.00,606926),('5','131','210261','309',290.00,290.00,0.00,0.00,0.00,0.00,0.00,606927),('5','131','210261','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,606928),('5','131','210386','308',163.00,163.00,4455.54,0.00,0.00,0.00,0.00,607237),('5','131','210386','309',290.00,290.00,0.00,0.00,0.00,0.00,0.00,607238),('5','131','210386','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,607239),('5','131','210626','308',165.00,163.00,4004.17,0.00,0.00,0.00,0.00,607878),('5','131','210626','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,607879),('5','131','210626','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,607880),('5','131','210849','308',165.00,163.00,3887.10,0.00,0.00,0.00,0.00,608455),('5','131','210849','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,608456),('5','131','210849','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,608457),('5','131','210945','308',165.00,163.00,3370.50,0.00,0.00,0.00,0.00,608710),('5','131','210945','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,608711),('5','131','210945','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,608712),('5','131','211344','308',165.00,163.00,4887.40,0.00,0.00,0.00,0.00,609746),('5','131','211344','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,609747),('5','131','211344','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,609748),('5','131','211445','308',165.00,163.00,6202.20,0.00,0.00,0.00,0.00,610002),('5','131','211445','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,610003),('5','131','211445','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,610004),('5','131','211744','308',165.00,163.00,2679.92,0.00,0.00,0.00,0.00,610773),('5','131','211744','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,610774),('5','131','211744','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,610775),('5','131','211791','308',165.00,163.00,4247.47,0.00,0.00,0.00,0.00,610876),('5','131','211791','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,610877),('5','131','211791','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,610878),('5','131','212172','308',165.00,163.00,4069.92,0.00,0.00,0.00,0.00,611893),('5','131','212172','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,611894),('5','131','212172','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,611895),('5','131','212435','308',165.00,163.00,3459.40,0.00,0.00,0.00,0.00,612584),('5','131','212435','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,612585),('5','131','212435','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,612586),('5','131','212472','308',165.00,163.00,1649.36,0.00,0.00,0.00,0.00,612665),('5','131','212472','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,612666),('5','131','212472','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,612667),('5','131','212750','308',165.00,163.00,3792.10,0.00,0.00,0.00,0.00,613404),('5','131','212750','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,613405),('5','131','212750','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,613406),('5','131','212866','308',165.00,163.00,2579.79,0.00,0.00,0.00,0.00,613709),('5','131','212866','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,613710),('5','131','212866','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,613711),('5','131','213199','308',165.00,163.00,3837.33,0.00,0.00,0.00,0.00,614575),('5','131','213199','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,614576),('5','131','213199','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614577),('5','131','213520','308',165.00,163.00,3631.73,0.00,0.00,0.00,0.00,615409),('5','131','213520','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,615410),('5','131','213520','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615411),('5','131','213751','308',165.00,163.00,5128.53,0.00,0.00,0.00,0.00,616017),('5','131','213751','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,616018),('5','131','213751','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,616019),('5','131','214255','308',163.00,163.00,4625.62,0.00,0.00,0.00,0.00,617337),('5','131','214255','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,617338),('5','131','214255','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,617339),('5','131','214257','308',163.00,163.00,5635.34,0.00,0.00,0.00,0.00,617343),('5','131','214257','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,617344),('5','131','214257','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,617345),('5','131','214348','308',163.00,163.00,4289.28,0.00,0.00,0.00,0.00,617569),('5','131','214348','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,617570),('5','131','214348','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,617571),('5','131','214598','308',163.00,163.00,4399.02,0.00,0.00,0.00,0.00,618216),('5','131','214598','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,618217),('5','131','214598','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,618218),('5','131','214822','308',163.00,163.00,4110.47,0.00,0.00,0.00,0.00,618800),('5','131','214822','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,618801),('5','131','214822','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,618802),('5','131','215111','308',163.00,163.00,3889.37,0.00,0.00,0.00,0.00,619557),('5','131','215111','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,619558),('5','131','215111','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,619559),('5','131','215372','308',163.00,163.00,4160.09,0.00,0.00,0.00,0.00,620232),('5','131','215372','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,620233),('5','131','215372','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,620234),('5','131','215608','308',163.00,163.00,3479.77,0.00,0.00,0.00,0.00,620834),('5','131','215608','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,620835),('5','131','215608','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,620836),('5','131','215710','308',163.00,163.00,2757.41,0.00,0.00,0.00,0.00,621090),('5','131','215710','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,621091),('5','131','215710','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,621092),('5','131','215945','308',163.00,163.00,2088.66,0.00,0.00,0.00,0.00,621691),('5','131','215945','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,621692),('5','131','215945','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,621693),('5','131','216313','308',163.00,163.00,4808.69,0.00,0.00,0.00,0.00,622661),('5','131','216313','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,622662),('5','131','216313','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,622663),('5','131','216544','308',163.00,163.00,4019.63,0.00,0.00,0.00,0.00,623279),('5','131','216544','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,623280),('5','131','216544','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,623281),('5','131','216777','308',163.00,163.00,3795.02,0.00,0.00,0.00,0.00,623888),('5','131','216777','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,623889),('5','131','216777','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,623890),('5','131','217047','308',163.00,163.00,181.47,0.00,0.00,0.00,0.00,624577),('5','131','217047','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,624578),('5','131','217047','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,624579),('5','131','217127','308',163.00,163.00,4832.78,0.00,0.00,0.00,0.00,624795),('5','131','217127','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,624796),('5','131','217127','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,624797),('5','131','217301','308',163.00,163.00,5578.34,0.00,0.00,0.00,0.00,625246),('5','131','217301','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,625247),('5','131','217301','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,625248),('5','131','217666','308',163.00,163.00,4629.48,0.00,0.00,0.00,0.00,626216),('5','131','217666','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,626217),('5','131','217666','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,626218),('5','131','217727','308',163.00,163.00,4606.78,0.00,0.00,0.00,0.00,626356),('5','131','217727','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,626357),('5','131','217727','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,626358),('5','131','218020','308',163.00,163.00,3928.08,0.00,0.00,0.00,0.00,627127),('5','131','218020','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,627128),('5','131','218020','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,627129),('5','131','218317','308',163.00,163.00,4193.88,0.00,0.00,0.00,0.00,627921),('5','131','218317','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,627922),('5','131','218317','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,627923),('5','131','218467','308',163.00,163.00,4857.95,0.00,0.00,0.00,0.00,628301),('5','131','218467','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,628302),('5','131','218467','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,628303),('5','131','218686','308',163.00,163.00,4869.81,0.00,0.00,0.00,0.00,628877),('5','131','218686','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,628878),('5','131','218686','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,628879),('5','131','218910','308',163.00,163.00,3674.75,0.00,0.00,0.00,0.00,629465),('5','131','218910','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,629466),('5','131','218910','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,629467),('5','131','219114','308',163.00,163.00,7049.53,0.00,0.00,0.00,0.00,629997),('5','131','219114','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,629998),('5','131','219114','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,629999),('5','131','219380','308',163.00,163.00,3949.59,0.00,0.00,0.00,0.00,630683),('5','131','219380','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,630684),('5','131','219380','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,630685),('5','131','219657','308',163.00,163.00,4615.30,0.00,0.00,0.00,0.00,631415),('5','131','219657','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,631416),('5','131','219657','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,631417),('5','131','219809','308',163.00,163.00,4772.17,0.00,0.00,0.00,0.00,631820),('5','131','219809','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,631821),('5','131','219809','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,631822),('5','131','220044','308',163.00,163.00,5477.09,0.00,0.00,0.00,0.00,632448),('5','131','220044','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,632449),('5','131','220044','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,632450),('5','131','220263','308',163.00,163.00,5568.40,0.00,0.00,0.00,0.00,633020),('5','131','220263','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,633021),('5','131','220263','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,633022),('5','131','220499','308',163.00,163.00,5010.43,0.00,0.00,0.00,0.00,633638),('5','131','220499','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,633639),('5','131','220499','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,633640),('5','131','220701','308',163.00,163.00,3875.61,0.00,0.00,0.00,0.00,634159),('5','131','220701','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,634160),('5','131','220701','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,634161),('5','131','220932','308',163.00,163.00,4167.58,0.00,0.00,0.00,0.00,634759),('5','131','220932','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,634760),('5','131','220932','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,634761),('5','131','221146','308',163.00,163.00,5233.71,0.00,0.00,0.00,0.00,635318),('5','131','221146','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,635319),('5','131','221146','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,635320),('5','131','221442','308',163.00,163.00,5341.13,0.00,0.00,0.00,0.00,636091),('5','131','221442','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,636092),('5','131','221442','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,636093),('5','131','221652','308',163.00,163.00,5788.46,0.00,0.00,0.00,0.00,636637),('5','131','221652','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,636638),('5','131','221652','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,636639),('5','131','221923','308',163.00,163.00,5723.16,0.00,0.00,0.00,0.00,637343),('5','131','221923','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,637344),('5','131','221923','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,637345),('5','131','222183','308',163.00,163.00,5381.82,0.00,0.00,0.00,0.00,638021),('5','131','222183','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,638022),('5','131','222183','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,638023),('5','131','222321','308',163.00,163.00,6420.62,0.00,0.00,0.00,0.00,638368),('5','131','222321','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,638369),('5','131','222321','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,638370),('5','131','222629','308',163.00,163.00,3022.04,0.00,0.00,0.00,0.00,639177),('5','131','222629','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,639178),('5','131','222629','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,639179),('5','131','222798','308',163.00,163.00,3801.88,0.00,0.00,0.00,0.00,639614),('5','131','222798','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,639615),('5','131','222798','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,639616),('5','131','224374','308',163.00,163.00,0.00,0.00,0.00,0.00,0.00,643669),('5','131','224374','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,643670),('5','131','224374','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,643671),('5','131','224378','308',163.00,163.00,0.00,0.00,0.00,0.00,0.00,643679),('5','131','224378','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,643680),('5','131','224378','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,643681),('5','131','224511','308',163.00,163.00,0.00,0.00,0.00,0.00,0.00,644057),('5','131','224511','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,644058),('5','131','224511','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,644059),('5','131','224570','308',163.00,163.00,0.00,0.00,0.00,0.00,0.00,644189),('5','131','224570','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,644190),('5','131','224570','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,644191),('5','131','224582','308',163.00,163.00,0.00,0.00,0.00,0.00,0.00,644224),('5','131','224582','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,644225),('5','131','224582','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,644226),('5','131','224586','308',163.00,163.00,0.00,0.00,0.00,0.00,0.00,644236),('5','131','224586','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,644237),('5','131','224586','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,644238),('5','131','224596','308',163.00,163.00,0.00,0.00,0.00,0.00,0.00,644263),('5','131','224596','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,644264),('5','131','224596','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,644265),('5','131','224644','308',163.00,163.00,5608.95,0.00,0.00,0.00,0.00,644387),('5','131','224644','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,644388),('5','131','224644','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,644389),('5','131','224860','308',163.00,163.00,4940.06,0.00,0.00,0.00,0.00,644933),('5','131','224860','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,644934),('5','131','224860','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,644935),('5','131','225217','308',163.00,163.00,3874.41,0.00,0.00,0.00,0.00,645868),('5','131','225217','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,645869),('5','131','225217','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,645870),('5','131','225257','308',163.00,163.00,3231.66,0.00,0.00,0.00,0.00,645967),('5','131','225257','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,645968),('5','131','225257','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,645969),('5','131','225537','308',163.00,163.00,4171.21,0.00,0.00,0.00,0.00,646679),('5','131','225537','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,646680),('5','131','225537','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,646681),('5','131','225843','308',163.00,163.00,3802.17,0.00,0.00,0.00,0.00,647484),('5','131','225843','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,647485),('5','131','225843','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647486),('5','131','226083','308',163.00,163.00,4082.90,0.00,0.00,0.00,0.00,648106),('5','131','226083','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,648107),('5','131','226083','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,648108),('5','131','226323','308',163.00,163.00,3781.10,0.00,0.00,0.00,0.00,648726),('5','131','226323','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,648727),('5','131','226323','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,648728),('5','131','226535','308',163.00,163.00,4861.56,0.00,0.00,0.00,0.00,649254),('5','131','226535','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,649255),('5','131','226535','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,649256),('5','131','226751','308',163.00,163.00,4264.67,0.00,0.00,0.00,0.00,649816),('5','131','226751','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,649817),('5','131','226751','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,649818),('5','131','226988','308',163.00,163.00,3852.12,0.00,0.00,0.00,0.00,650443),('5','131','226988','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,650444),('5','131','226988','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,650445),('5','131','227193','308',163.00,163.00,3182.32,0.00,0.00,0.00,0.00,650975),('5','131','227193','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,650976),('5','131','227193','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,650977),('5','131','227388','308',163.00,163.00,4975.47,0.00,0.00,0.00,0.00,651469),('5','131','227388','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,651470),('5','131','227388','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,651471),('5','131','227617','308',163.00,163.00,3365.46,0.00,0.00,0.00,0.00,652059),('5','131','227617','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,652060),('5','131','227617','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,652061),('5','131','227849','308',163.00,163.00,0.00,0.00,0.00,0.00,0.00,652669),('5','131','227849','309',290.00,295.00,0.00,0.00,0.00,0.00,0.00,652670),('5','131','227849','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,652671),('5','131','229385','308',163.00,163.00,0.00,0.00,0.00,0.00,0.00,656655),('5','131','229385','309',290.00,300.00,0.00,0.00,0.00,0.00,0.00,656656),('5','131','229385','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,656657),('5','131','229417','308',163.00,163.00,0.00,0.00,0.00,0.00,0.00,656727),('5','131','229417','309',290.00,300.00,0.00,0.00,0.00,0.00,0.00,656728),('5','131','229417','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,656729),('5','131','229463','308',163.00,163.00,0.00,0.00,0.00,0.00,0.00,656839),('5','131','229463','309',290.00,300.00,0.00,0.00,0.00,0.00,0.00,656840),('5','131','229463','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,656841),('5','131','230680','308',163.00,163.00,3490.58,0.00,0.00,0.00,0.00,659993),('5','131','230680','309',300.00,310.00,0.00,0.00,0.00,0.00,0.00,659994),('5','131','230680','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,659995),('5','131','230710','308',163.00,163.00,3252.76,0.00,0.00,0.00,0.00,660077),('5','131','230710','309',300.00,310.00,0.00,0.00,0.00,0.00,0.00,660078),('5','131','230710','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,660079),('5','131','230763','308',163.00,163.00,3739.15,0.00,0.00,0.00,0.00,660214),('5','131','230763','309',300.00,310.00,0.00,0.00,0.00,0.00,0.00,660215),('5','131','230763','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,660216),('5','131','230821','308',163.00,163.00,2888.83,0.00,0.00,0.00,0.00,660335),('5','131','230821','309',300.00,310.00,0.00,0.00,0.00,0.00,0.00,660336),('5','131','230821','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,660337),('5','131','230933','308',163.00,163.00,1905.76,0.00,0.00,0.00,0.00,660640),('5','131','230933','309',300.00,320.00,0.00,0.00,0.00,0.00,0.00,660641),('5','131','230933','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,660642),('5','131','230937','308',163.00,163.00,0.00,0.00,0.00,0.00,0.00,660653),('5','131','230937','309',300.00,320.00,0.00,0.00,0.00,0.00,0.00,660654),('5','131','230937','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,660655),('5','131','230963','308',163.00,163.00,0.00,0.00,0.00,0.00,0.00,660727),('5','131','230963','309',300.00,320.00,0.00,0.00,0.00,0.00,0.00,660728),('5','131','230963','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,660729),('5','131','231048','308',163.00,163.00,0.00,0.00,0.00,0.00,0.00,660967),('5','131','231048','309',300.00,320.00,0.00,0.00,0.00,0.00,0.00,660968),('5','131','231048','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,660969),('5','131','231071','308',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661011),('5','131','231071','309',300.00,320.00,0.00,0.00,0.00,0.00,0.00,661012),('5','131','231071','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661013),('5','131','231096','308',163.00,163.00,5624.69,0.00,0.00,0.00,0.00,661071),('5','131','231096','309',300.00,320.00,0.00,0.00,0.00,0.00,0.00,661072),('5','131','231096','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661073),('5','131','231119','308',163.00,163.00,4867.69,0.00,0.00,0.00,0.00,661137),('5','131','231119','309',300.00,320.00,0.00,0.00,0.00,0.00,0.00,661138),('5','131','231119','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661139),('5','131','231363','308',163.00,163.00,5281.31,0.00,0.00,0.00,0.00,661801),('5','131','231363','309',300.00,320.00,0.00,0.00,0.00,0.00,0.00,661802),('5','131','231363','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661803),('5','131','231709','308',163.00,163.00,5657.81,0.00,0.00,0.00,0.00,662697),('5','131','231709','309',300.00,320.00,0.00,0.00,0.00,0.00,0.00,662698),('5','131','231709','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,662699),('5','131','232070','308',163.00,163.00,4889.80,0.00,0.00,0.00,0.00,663690),('5','131','232070','309',300.00,327.00,0.00,0.00,0.00,0.00,0.00,663691),('5','131','232070','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,663692),('5','131','232263','308',163.00,163.00,3629.75,0.00,0.00,0.00,0.00,664181),('5','131','232263','309',300.00,327.00,0.00,0.00,0.00,0.00,0.00,664182),('5','131','232263','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,664183),('5','131','232392','308',163.00,163.00,4141.81,0.00,0.00,0.00,0.00,664502),('5','131','232392','309',300.00,327.00,0.00,0.00,0.00,0.00,0.00,664503),('5','131','232392','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,664504),('5','131','232669','308',163.00,163.00,4261.06,0.00,0.00,0.00,0.00,665248),('5','131','232669','309',300.00,320.00,0.00,0.00,0.00,0.00,0.00,665249),('5','131','232669','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,665250),('5','131','232911','308',163.00,163.00,3850.94,0.00,0.00,0.00,0.00,665884),('5','131','232911','309',300.00,330.00,0.00,0.00,0.00,0.00,0.00,665885),('5','131','232911','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,665886),('5','131','233127','308',163.00,163.00,2549.86,0.00,0.00,0.00,0.00,666437),('5','131','233127','309',300.00,330.00,0.00,0.00,0.00,0.00,0.00,666438),('5','131','233127','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,666439),('5','131','233432','308',163.00,163.00,5784.98,0.00,0.00,0.00,0.00,667240),('5','131','233432','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,667241),('5','131','233432','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,667242),('5','131','233688','308',163.00,163.00,5465.74,0.00,0.00,0.00,0.00,667912),('5','131','233688','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,667913),('5','131','233688','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,667914),('5','131','233994','308',163.00,163.00,5365.35,0.00,0.00,0.00,0.00,668731),('5','131','233994','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,668732),('5','131','233994','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,668733),('5','131','234480','308',163.00,163.00,4969.20,0.00,0.00,0.00,0.00,670024),('5','131','234480','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,670025),('5','131','234480','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,670026),('5','131','234512','308',163.00,165.00,436.53,0.00,0.00,0.00,0.00,670110),('5','131','234512','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,670111),('5','131','234512','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,670112),('5','131','234636','308',163.00,165.00,0.00,0.00,0.00,0.00,0.00,670420),('5','131','234636','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,670421),('5','131','234636','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,670422),('5','131','235081','308',163.00,165.00,0.00,0.00,0.00,0.00,0.00,671619),('5','131','235081','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,671620),('5','131','235081','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,671621),('5','131','235335','308',163.00,165.00,0.00,0.00,0.00,0.00,0.00,672269),('5','131','235335','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,672270),('5','131','235335','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,672271),('5','131','235533','308',163.00,165.00,0.00,0.00,0.00,0.00,0.00,672778),('5','131','235533','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,672779),('5','131','235533','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,672780),('5','131','235673','308',165.00,165.00,9254.31,0.00,0.00,0.00,0.00,673152),('5','131','235673','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,673153),('5','131','235673','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,673154),('5','131','235928','308',165.00,165.00,7784.83,0.00,0.00,0.00,0.00,673818),('5','131','235928','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,673819),('5','131','235928','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,673820),('5','131','236352','308',165.00,165.00,7838.84,0.00,0.00,0.00,0.00,674937),('5','131','236352','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,674938),('5','131','236352','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,674939),('5','131','236461','308',165.00,165.00,5175.30,0.00,0.00,0.00,0.00,675233),('5','131','236461','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,675234),('5','131','236461','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,675235),('5','131','236802','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,676101),('5','131','236802','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,676102),('5','131','236802','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,676103),('5','131','236895','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,676355),('5','131','236895','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,676356),('5','131','236895','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,676357),('5','131','237082','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,676828),('5','131','237082','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,676829),('5','131','237082','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,676830),('5','131','237257','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,677270),('5','131','237257','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,677271),('5','131','237257','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,677272),('5','131','237599','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,678168),('5','131','237599','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,678169),('5','131','237599','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,678170),('5','131','237714','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,678462),('5','131','237714','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,678463),('5','131','237714','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,678464),('5','131','237861','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,678856),('5','131','237861','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,678857),('5','131','237861','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,678858),('5','131','238232','308',165.00,165.00,669.81,0.00,0.00,0.00,0.00,679803),('5','131','238232','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,679804),('5','131','238232','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,679805),('5','131','238611','308',165.00,165.00,5634.45,0.00,0.00,0.00,0.00,680786),('5','131','238611','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,680787),('5','131','238611','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,680788),('5','131','238903','308',165.00,165.00,5639.91,0.00,0.00,0.00,0.00,681539),('5','131','238903','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,681540),('5','131','238903','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,681541),('5','131','239113','308',165.00,165.00,2054.47,0.00,0.00,0.00,0.00,682079),('5','131','239113','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,682080),('5','131','239113','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,682081),('5','131','239356','308',165.00,165.00,399.50,0.00,0.00,0.00,0.00,682718),('5','131','239356','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,682719),('5','131','239356','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,682720),('5','131','239550','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,683220),('5','131','239550','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,683221),('5','131','239550','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,683222),('5','131','239750','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,683763),('5','131','239750','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,683764),('5','131','239750','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,683765),('5','131','239795','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,683860),('5','131','239795','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,683861),('5','131','239795','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,683862),('5','131','239979','308',165.00,165.00,2845.86,0.00,0.00,0.00,0.00,684353),('5','131','239979','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,684354),('5','131','239979','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,684355),('5','131','240222','308',165.00,165.00,7120.06,0.00,0.00,0.00,0.00,684962),('5','131','240222','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,684963),('5','131','240222','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,684964),('5','131','240446','308',165.00,165.00,3058.09,0.00,0.00,0.00,0.00,685561),('5','131','240446','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,685562),('5','131','240446','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,685563),('5','131','240709','308',165.00,165.00,325.23,0.00,0.00,0.00,0.00,686191),('5','131','240709','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,686192),('5','131','240709','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,686193),('5','131','240968','308',165.00,165.00,7800.65,0.00,0.00,0.00,0.00,686898),('5','131','240968','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,686899),('5','131','240968','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,686900),('5','131','241297','308',165.00,165.00,9198.96,0.00,0.00,0.00,0.00,687747),('5','131','241297','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,687748),('5','131','241297','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,687749),('5','131','241492','308',165.00,165.00,10221.07,0.00,0.00,0.00,0.00,688280),('5','131','241492','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,688281),('5','131','241492','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,688282),('5','131','241740','308',165.00,165.00,7955.38,0.00,0.00,0.00,0.00,688932),('5','131','241740','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,688933),('5','131','241740','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,688934),('5','131','242022','308',165.00,165.00,7520.61,0.00,0.00,0.00,0.00,689660),('5','131','242022','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,689661),('5','131','242022','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,689662),('5','131','242239','308',165.00,165.00,1729.28,0.00,0.00,0.00,0.00,690225),('5','131','242239','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,690226),('5','131','242239','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,690227),('5','131','242515','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,690929),('5','131','242515','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,690930),('5','131','242515','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,690931),('5','131','242772','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,691602),('5','131','242772','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,691603),('5','131','242772','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,691604),('5','131','242963','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,692099),('5','131','242963','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,692100),('5','131','242963','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,692101),('5','131','243162','308',165.00,165.00,6198.48,0.00,0.00,0.00,0.00,692617),('5','131','243162','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,692618),('5','131','243162','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,692619),('5','131','243423','308',165.00,165.00,9465.44,0.00,0.00,0.00,0.00,693309),('5','131','243423','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,693310),('5','131','243423','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,693311),('5','131','243797','308',165.00,165.00,10553.65,0.00,0.00,0.00,0.00,694293),('5','131','243797','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,694294),('5','131','243797','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,694295),('5','131','244309','308',165.00,165.00,3516.62,0.00,0.00,0.00,0.00,695601),('5','131','244309','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,695602),('5','131','244309','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,695603),('5','131','244498','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,696110),('5','131','244498','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,696111),('5','131','244498','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,696112),('5','131','244569','308',165.00,165.00,2361.86,0.00,0.00,0.00,0.00,696271),('5','131','244569','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,696272),('5','131','244569','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,696273),('5','131','244683','308',165.00,165.00,9713.06,0.00,0.00,0.00,0.00,696584),('5','131','244683','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,696585),('5','131','244683','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,696586),('5','131','244811','308',165.00,165.00,12097.21,0.00,0.00,0.00,0.00,696909),('5','131','244811','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,696910),('5','131','244811','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,696911),('5','131','245068','308',165.00,165.00,8520.96,0.00,0.00,0.00,0.00,697572),('5','131','245068','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,697573),('5','131','245068','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,697574),('5','131','245401','308',165.00,165.00,7020.06,0.00,0.00,0.00,0.00,698444),('5','131','245401','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,698445),('5','131','245401','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,698446),('5','131','245620','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699012),('5','131','245620','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,699013),('5','131','245620','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,699014),('5','131','246052','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,700128),('5','131','246052','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,700129),('5','131','246052','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,700130),('5','131','246178','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,700456),('5','131','246178','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,700457),('5','131','246178','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,700458),('5','131','246328','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,700853),('5','131','246328','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,700854),('5','131','246328','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,700855),('5','131','246519','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,701341),('5','131','246519','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,701342),('5','131','246519','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,701343),('5','131','246789','308',165.00,165.00,5135.32,0.00,0.00,0.00,0.00,702042),('5','131','246789','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,702043),('5','131','246789','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,702044),('5','131','247352','308',165.00,165.00,8488.39,0.00,0.00,0.00,0.00,703510),('5','131','247352','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,703511),('5','131','247352','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,703512),('5','131','247422','308',165.00,165.00,9841.51,0.00,0.00,0.00,0.00,703662),('5','131','247422','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,703663),('5','131','247422','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,703664),('5','131','248082','308',165.00,165.00,5231.23,0.00,0.00,0.00,0.00,705394),('5','131','248082','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,705395),('5','131','248082','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,705396),('5','131','248234','308',165.00,165.00,909.09,0.00,0.00,0.00,0.00,705771),('5','131','248234','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,705772),('5','131','248234','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,705773),('5','131','248267','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,705865),('5','131','248267','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,705866),('5','131','248267','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,705867),('5','131','248527','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,706532),('5','131','248527','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,706533),('5','131','248527','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,706534),('5','131','248872','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,707426),('5','131','248872','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,707427),('5','131','248872','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,707428),('5','131','248972','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,707677),('5','131','248972','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,707678),('5','131','248972','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,707679),('5','131','249119','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,708048),('5','131','249119','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,708049),('5','131','249119','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,708050),('5','131','249498','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,709024),('5','131','249498','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,709025),('5','131','249498','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,709026),('5','131','249626','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,709337),('5','131','249626','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,709338),('5','131','249626','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,709339),('5','131','249906','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,710059),('5','131','249906','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,710060),('5','131','249906','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,710061),('5','131','250177','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,710755),('5','131','250177','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,710756),('5','131','250177','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,710757),('5','131','250217','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,710862),('5','131','250217','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,710863),('5','131','250217','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,710864),('5','131','250390','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,711289),('5','131','250390','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,711290),('5','131','250390','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,711291),('5','131','250606','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,711845),('5','131','250606','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,711846),('5','131','250606','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,711847),('5','131','250829','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,712422),('5','131','250829','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,712423),('5','131','250829','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,712424),('5','131','251085','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,713082),('5','131','251085','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,713083),('5','131','251085','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,713084),('5','131','251586','308',165.00,165.00,4249.34,0.00,0.00,0.00,0.00,714396),('5','131','251586','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,714397),('5','131','251586','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,714398),('5','131','251670','308',165.00,165.00,11314.14,0.00,0.00,0.00,0.00,714630),('5','131','251670','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,714631),('5','131','251670','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,714632),('5','131','251841','308',165.00,165.00,7600.70,0.00,0.00,0.00,0.00,715068),('5','131','251841','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,715069),('5','131','251841','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,715070),('5','131','252053','308',165.00,165.00,7850.44,0.00,0.00,0.00,0.00,715616),('5','131','252053','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,715617),('5','131','252053','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,715618),('5','131','252831','308',165.00,165.00,6269.32,0.00,0.00,0.00,0.00,717641),('5','131','252831','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,717642),('5','131','252831','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,717643),('5','131','252856','308',165.00,165.00,3138.42,0.00,0.00,0.00,0.00,717712),('5','131','252856','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,717713),('5','131','252856','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,717714),('5','131','252898','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,717827),('5','131','252898','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,717828),('5','131','252898','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,717829),('5','131','253050','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,718201),('5','131','253050','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,718202),('5','131','253050','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,718203),('5','131','253320','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,718922),('5','131','253320','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,718923),('5','131','253320','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,718924),('5','131','253525','308',165.00,165.00,4984.25,0.00,0.00,0.00,0.00,719443),('5','131','253525','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,719444),('5','131','253525','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,719445),('5','131','253778','308',165.00,165.00,5597.77,0.00,0.00,0.00,0.00,720099),('5','131','253778','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,720100),('5','131','253778','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,720101),('5','131','254037','308',165.00,165.00,1377.97,0.00,0.00,0.00,0.00,720777),('5','131','254037','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,720778),('5','131','254037','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,720779),('5','131','254257','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,721342),('5','131','254257','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,721343),('5','131','254257','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,721344),('5','131','254465','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,721884),('5','131','254465','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,721885),('5','131','254465','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,721886),('5','131','254746','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,722586),('5','131','254746','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,722587),('5','131','254746','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,722588),('5','131','255004','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,723244),('5','131','255004','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,723245),('5','131','255004','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,723246),('5','131','255327','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,724090),('5','131','255327','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,724091),('5','131','255327','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,724092),('5','131','255511','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,724521),('5','131','255511','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,724522),('5','131','255511','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,724523),('5','131','255855','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,725404),('5','131','255855','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,725405),('5','131','255855','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,725406),('5','131','255985','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,725728),('5','131','255985','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,725729),('5','131','255985','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,725730),('5','131','256296','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,726487),('5','131','256296','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,726488),('5','131','256296','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,726489),('5','131','256689','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,727538),('5','131','256689','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,727539),('5','131','256689','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,727540),('5','131','256781','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,727744),('5','131','256781','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,727745),('5','131','256781','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,727746),('5','131','257026','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728383),('5','131','257026','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,728384),('5','131','257026','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,728385),('5','131','257478','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729598),('5','131','257478','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729599),('5','131','257478','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729600),('5','131','257509','308',165.00,165.00,5873.94,0.00,0.00,0.00,0.00,729663),('5','131','257509','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729664),('5','131','257509','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729665),('5','131','257510','308',165.00,165.00,5659.53,0.00,0.00,0.00,0.00,729666),('5','131','257510','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729667),('5','131','257510','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729668),('5','131','257511','308',165.00,165.00,5238.16,0.00,0.00,0.00,0.00,729669),('5','131','257511','309',345.00,360.00,0.00,0.00,0.00,0.00,0.00,729670),('5','131','257511','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729671),('5','131','257512','308',165.00,165.00,5202.16,0.00,0.00,0.00,0.00,729672),('5','131','257512','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729673),('5','131','257512','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729674),('5','131','257513','308',165.00,165.00,4784.57,0.00,0.00,0.00,0.00,729675),('5','131','257513','309',345.00,365.00,0.00,0.00,0.00,0.00,0.00,729676),('5','131','257513','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729677),('5','131','257514','308',165.00,165.00,5143.29,0.00,0.00,0.00,0.00,729678),('5','131','257514','309',345.00,365.00,0.00,0.00,0.00,0.00,0.00,729679),('5','131','257514','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729680),('5','131','257517','308',165.00,165.00,5964.30,0.00,0.00,0.00,0.00,729682),('5','131','257517','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729683),('5','131','257517','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729684),('5','131','257518','309',345.00,390.00,0.00,0.00,0.00,0.00,0.00,729685),('5','131','257518','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729686),('5','131','257518','308',165.00,165.00,5327.48,0.00,0.00,0.00,0.00,729687),('5','131','257519','309',345.00,390.00,0.00,0.00,0.00,0.00,0.00,729688),('5','131','257519','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729689),('5','131','257519','308',165.00,165.00,5451.31,0.00,0.00,0.00,0.00,729690),('5','131','257520','308',165.00,165.00,5655.70,0.00,0.00,0.00,0.00,729691),('5','131','257520','309',345.00,390.00,0.00,0.00,0.00,0.00,0.00,729692),('5','131','257520','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729693),('5','131','257521','308',165.00,165.00,5861.11,0.00,0.00,0.00,0.00,729694),('5','131','257521','309',345.00,390.00,0.00,0.00,0.00,0.00,0.00,729695),('5','131','257521','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729696),('5','131','257522','308',165.00,165.00,6125.51,0.00,0.00,0.00,0.00,729697),('5','131','257522','309',345.00,415.00,0.00,0.00,0.00,0.00,0.00,729698),('5','131','257522','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729699),('5','131','257523','308',165.00,165.00,5925.45,0.00,0.00,0.00,0.00,729700),('5','131','257523','309',345.00,415.00,0.00,0.00,0.00,0.00,0.00,729701),('5','131','257523','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729702),('5','131','257524','308',165.00,165.00,7311.85,0.00,0.00,0.00,0.00,729703),('5','131','257524','309',345.00,415.00,0.00,0.00,0.00,0.00,0.00,729704),('5','131','257524','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729705),('5','131','257525','308',165.00,165.00,6389.72,0.00,0.00,0.00,0.00,729706),('5','131','257525','309',345.00,915.00,0.00,0.00,0.00,0.00,0.00,729707),('5','131','257525','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729708),('5','131','257526','309',345.00,915.00,0.00,0.00,0.00,0.00,0.00,729709),('5','131','257526','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729710),('5','131','257526','308',165.00,165.00,4397.20,0.00,0.00,0.00,0.00,729711),('5','131','257527','308',165.00,165.00,3046.88,0.00,0.00,0.00,0.00,729712),('5','131','257527','309',345.00,915.00,0.00,0.00,0.00,0.00,0.00,729713),('5','131','257527','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729714),('5','131','257528','308',165.00,165.00,9777.15,0.00,0.00,0.00,0.00,729715),('5','131','257528','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729716),('5','131','257528','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729717),('5','131','257529','308',165.00,165.00,4981.88,0.00,0.00,0.00,0.00,729718),('5','131','257529','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729719),('5','131','257529','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729720),('5','131','257530','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729721),('5','131','257530','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729722),('5','131','257530','308',165.00,165.00,2903.55,0.00,0.00,0.00,0.00,729723),('5','131','257531','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729724),('5','131','257531','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729725),('5','131','257531','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729726),('5','131','257532','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729727),('5','131','257532','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729728),('5','131','257532','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729729),('5','131','257533','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729730),('5','131','257533','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729731),('5','131','257533','308',165.00,165.00,12216.45,0.00,0.00,0.00,0.00,729732),('5','131','257534','308',165.00,165.00,11180.31,0.00,0.00,0.00,0.00,729733),('5','131','257534','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729734),('5','131','257534','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729735),('5','131','257535','308',165.00,165.00,5893.64,0.00,0.00,0.00,0.00,729736),('5','131','257535','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729737),('5','131','257535','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729738),('5','131','257536','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729739),('5','131','257536','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729740),('5','131','257536','308',165.00,165.00,8138.67,0.00,0.00,0.00,0.00,729741),('5','131','257537','308',165.00,165.00,3163.84,0.00,0.00,0.00,0.00,729742),('5','131','257537','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729743),('5','131','257537','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729744),('5','131','257538','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729745),('5','131','257538','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729746),('5','131','257538','308',165.00,165.00,94.90,0.00,0.00,0.00,0.00,729747),('5','131','257539','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729748),('5','131','257539','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729749),('5','131','257539','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729750),('5','131','257540','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729751),('5','131','257540','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729752),('5','131','257540','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729753),('5','131','257541','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729754),('5','131','257541','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729755),('5','131','257541','308',165.00,165.00,7091.20,0.00,0.00,0.00,0.00,729756),('5','131','257542','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729757),('5','131','257542','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729758),('5','131','257542','308',165.00,165.00,5326.01,0.00,0.00,0.00,0.00,729759),('5','131','257543','308',165.00,165.00,3750.01,0.00,0.00,0.00,0.00,729760),('5','131','257543','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729761),('5','131','257543','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729762),('5','131','257544','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729763),('5','131','257544','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729764),('5','131','257544','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729765),('5','131','257545','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729766),('5','131','257545','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729767),('5','131','257545','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729768),('5','131','257546','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729769),('5','131','257546','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729770),('5','131','257546','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729771),('5','131','257547','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729772),('5','131','257547','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729773),('5','131','257547','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729774),('5','131','257548','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729775),('5','131','257548','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729776),('5','131','257548','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729777),('5','131','257549','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729778),('5','131','257549','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729779),('5','131','257549','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729780),('5','131','257550','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729781),('5','131','257550','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729782),('5','131','257550','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729783),('5','131','257551','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729784),('5','131','257551','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729785),('5','131','257551','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729786),('5','131','257552','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729787),('5','131','257552','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729788),('5','131','257552','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729789),('5','131','257553','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729790),('5','131','257553','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729791),('5','131','257553','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729792),('5','131','257554','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729793),('5','131','257554','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729794),('5','131','257554','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729795),('5','131','257555','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729796),('5','131','257555','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729797),('5','131','257555','308',165.00,165.00,13647.36,0.00,0.00,0.00,0.00,729798),('5','131','257556','308',165.00,165.00,6458.78,0.00,0.00,0.00,0.00,729799),('5','131','257556','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729800),('5','131','257556','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729801),('5','131','257557','308',165.00,165.00,6177.56,0.00,0.00,0.00,0.00,729802),('5','131','257557','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729803),('5','131','257557','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729804),('5','131','257558','308',165.00,165.00,3191.62,0.00,0.00,0.00,0.00,729805),('5','131','257558','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729806),('5','131','257558','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729807),('5','131','257559','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729808),('5','131','257559','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729809),('5','131','257559','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729810),('5','131','257560','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729811),('5','131','257560','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729812),('5','131','257560','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729813),('5','131','257561','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729814),('5','131','257561','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729815),('5','131','257561','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729816),('5','131','257562','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729817),('5','131','257562','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729818),('5','131','257562','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729819),('5','131','257563','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729820),('5','131','257563','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729821),('5','131','257563','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729822),('5','131','257564','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729823),('5','131','257564','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729824),('5','131','257564','308',165.00,165.00,5648.82,0.00,0.00,0.00,0.00,729825),('5','131','257565','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729826),('5','131','257565','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729827),('5','131','257565','308',165.00,165.00,5256.03,0.00,0.00,0.00,0.00,729828),('5','131','257566','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729829),('5','131','257566','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729830),('5','131','257566','308',165.00,165.00,2296.22,0.00,0.00,0.00,0.00,729831),('5','131','257567','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729832),('5','131','257567','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729833),('5','131','257567','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729834),('5','131','257568','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729835),('5','131','257568','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729836),('5','131','257568','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729837),('5','131','257569','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729838),('5','131','257569','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729839),('5','131','257569','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729840),('5','131','257570','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729841),('5','131','257570','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729842),('5','131','257570','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729843),('5','131','257571','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729844),('5','131','257571','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729845),('5','131','257571','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729846),('5','131','257572','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729847),('5','131','257572','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729848),('5','131','257572','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729849),('5','131','257573','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729850),('5','131','257573','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729851),('5','131','257573','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729852),('5','131','257574','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729853),('5','131','257574','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729854),('5','131','257574','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729855),('5','131','257575','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729856),('5','131','257575','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729857),('5','131','257575','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729858),('5','131','257576','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729859),('5','131','257576','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729860),('5','131','257576','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729861),('5','131','257577','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729862),('5','131','257577','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729863),('5','131','257577','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729864),('5','131','257578','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729865),('5','131','257578','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729866),('5','131','257578','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729867),('5','131','257579','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729868),('5','131','257579','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729869),('5','131','257579','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729870),('5','131','257580','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729871),('5','131','257580','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729872),('5','131','257580','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729873),('5','131','257581','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729874),('5','131','257581','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729875),('5','131','257581','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729876),('5','131','257582','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729877),('5','131','257582','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729878),('5','131','257582','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729879),('5','131','257583','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729880),('5','131','257583','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729881),('5','131','257583','308',165.00,165.00,499.98,0.00,0.00,0.00,0.00,729882),('5','131','257584','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729883),('5','131','257584','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729884),('5','131','257584','308',165.00,165.00,6043.35,0.00,0.00,0.00,0.00,729885),('5','131','257585','308',165.00,165.00,4857.34,0.00,0.00,0.00,0.00,729886),('5','131','257585','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729887),('5','131','257585','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729888),('5','131','257586','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729889),('5','131','257586','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729890),('5','131','257586','308',165.00,165.00,3473.71,0.00,0.00,0.00,0.00,729891),('5','131','257587','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729892),('5','131','257587','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729893),('5','131','257587','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729894),('5','131','257588','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729895),('5','131','257588','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729896),('5','131','257588','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729897),('5','131','257589','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729898),('5','131','257589','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729899),('5','131','257589','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729900),('5','131','257590','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729901),('5','131','257590','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729902),('5','131','257590','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729903),('5','131','257591','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729904),('5','131','257591','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729905),('5','131','257591','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729906),('5','131','257592','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729907),('5','131','257592','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729908),('5','131','257592','308',165.00,165.00,5049.86,0.00,0.00,0.00,0.00,729909),('5','131','257593','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729910),('5','131','257593','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729911),('5','131','257593','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729912),('5','131','257594','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729913),('5','131','257594','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729914),('5','131','257594','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729915),('5','131','257595','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729916),('5','131','257595','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729917),('5','131','257595','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729918),('5','131','257596','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729919),('5','131','257596','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729920),('5','131','257596','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729921),('5','131','257597','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729922),('5','131','257597','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729923),('5','131','257597','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729924),('5','131','257598','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729925),('5','131','257598','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729926),('5','131','257598','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729927),('5','131','257599','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729928),('5','131','257599','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729929),('5','131','257599','308',165.00,165.00,2393.80,0.00,0.00,0.00,0.00,729930),('5','131','257600','308',165.00,165.00,5197.41,0.00,0.00,0.00,0.00,729931),('5','131','257600','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729932),('5','131','257600','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729933),('5','131','257601','308',165.00,165.00,7718.04,0.00,0.00,0.00,0.00,729934),('5','131','257601','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729935),('5','131','257601','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729936),('5','131','257602','308',165.00,165.00,6163.82,0.00,0.00,0.00,0.00,729937),('5','131','257602','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729938),('5','131','257602','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729939),('5','131','257603','308',165.00,165.00,3079.02,0.00,0.00,0.00,0.00,729940),('5','131','257603','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729941),('5','131','257603','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729942),('5','131','257604','308',165.00,165.00,8109.68,0.00,0.00,0.00,0.00,729943),('5','131','257604','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729944),('5','131','257604','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729945),('5','131','257605','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729946),('5','131','257605','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729947),('5','131','257605','308',165.00,165.00,8170.04,0.00,0.00,0.00,0.00,729948),('5','131','257606','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729949),('5','131','257606','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729950),('5','131','257606','308',165.00,165.00,8808.43,0.00,0.00,0.00,0.00,729951),('5','131','257607','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729952),('5','131','257607','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729953),('5','131','257607','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729954),('5','131','257608','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729955),('5','131','257608','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729956),('5','131','257608','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729957),('5','131','257609','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729958),('5','131','257609','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729959),('5','131','257609','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729960),('5','131','257610','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729961),('5','131','257610','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729962),('5','131','257610','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729963),('5','131','257611','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729964),('5','131','257611','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729965),('5','131','257611','308',165.00,165.00,6564.44,0.00,0.00,0.00,0.00,729966),('5','131','257612','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729967),('5','131','257612','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729968),('5','131','257612','308',165.00,165.00,3360.73,0.00,0.00,0.00,0.00,729969),('5','131','257613','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729970),('5','131','257613','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729971),('5','131','257613','308',165.00,165.00,1040.35,0.00,0.00,0.00,0.00,729972),('5','131','257614','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729973),('5','131','257614','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729974),('5','131','257614','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729975),('5','131','257615','309',345.00,670.00,0.00,0.00,0.00,0.00,0.00,729976),('5','131','257615','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729977),('5','131','257615','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729978),('5','131','257616','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729979),('5','131','257616','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729980),('5','131','257616','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729981),('5','131','257617','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729982),('5','131','257617','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729983),('5','131','257617','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729984),('5','131','257618','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729985),('5','131','257618','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729986),('5','131','257618','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729987),('5','131','257619','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729988),('5','131','257619','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729989),('5','131','257619','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729990),('5','131','257620','308',165.00,165.00,3630.31,0.00,0.00,0.00,0.00,729991),('5','131','257620','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729992),('5','131','257620','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729993),('5','131','257621','309',345.00,700.00,0.00,0.00,0.00,0.00,0.00,729994),('5','131','257621','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729995),('5','131','257621','308',165.00,165.00,4835.06,0.00,0.00,0.00,0.00,729996),('5','131','257622','308',165.00,165.00,5139.50,0.00,0.00,0.00,0.00,729997),('5','131','257622','309',345.00,700.00,0.00,0.00,0.00,0.00,0.00,729998),('5','131','257622','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729999),('5','131','257623','308',165.00,165.00,4527.74,0.00,0.00,0.00,0.00,730000),('5','131','257623','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730001),('5','131','257623','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730002),('5','131','257624','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730003),('5','131','257624','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730004),('5','131','257624','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730005),('5','131','257625','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730006),('5','131','257625','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730007),('5','131','257625','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730008),('5','131','257626','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730009),('5','131','257626','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730010),('5','131','257626','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730011),('5','131','257627','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730012),('5','131','257627','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730013),('5','131','257627','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730014),('5','131','257628','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730015),('5','131','257628','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730016),('5','131','257628','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730017),('5','131','257629','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730018),('5','131','257629','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730019),('5','131','257629','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730020),('5','131','257630','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730021),('5','131','257630','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730022),('5','131','257630','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730023),('5','131','257631','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730024),('5','131','257631','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730025),('5','131','257631','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730026),('5','131','257632','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730027),('5','131','257632','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730028),('5','131','257632','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730029),('5','131','257633','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730030),('5','131','257633','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730031),('5','131','257633','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730032),('5','131','257634','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730033),('5','131','257634','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730034),('5','131','257634','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730035),('5','131','257635','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730036),('5','131','257635','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730037),('5','131','257635','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730038),('5','131','257636','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730039),('5','131','257636','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730040),('5','131','257636','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730041),('5','131','257637','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730042),('5','131','257637','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730043),('5','131','257637','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730044),('5','131','257638','308',165.00,165.00,4131.22,0.00,0.00,0.00,0.00,730045),('5','131','257638','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730046),('5','131','257638','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730047),('5','131','257639','308',165.00,165.00,5170.09,0.00,0.00,0.00,0.00,730048),('5','131','257639','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730049),('5','131','257639','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730050),('5','131','257640','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730051),('5','131','257640','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730052),('5','131','257640','308',165.00,165.00,3792.80,0.00,0.00,0.00,0.00,730053),('5','131','257641','308',165.00,165.00,1863.12,0.00,0.00,0.00,0.00,730054),('5','131','257641','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730055),('5','131','257641','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730056),('5','131','257642','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730057),('5','131','257642','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730058),('5','131','257642','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730059),('5','131','257643','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730060),('5','131','257643','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730061),('5','131','257643','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730062),('5','131','257644','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730063),('5','131','257644','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730064),('5','131','257644','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730065),('5','131','257645','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730066),('5','131','257645','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730067),('5','131','257645','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730068),('5','131','257646','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730069),('5','131','257646','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730070),('5','131','257646','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730071),('5','131','257647','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730072),('5','131','257647','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730073),('5','131','257647','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730074),('5','131','257648','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730075),('5','131','257648','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730076),('5','131','257648','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730077),('5','131','257649','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730078),('5','131','257649','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730079),('5','131','257649','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730080),('5','131','257650','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730081),('5','131','257650','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730082),('5','131','257650','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730083),('5','131','257651','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730084),('5','131','257651','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730085),('5','131','257651','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730086),('5','131','257652','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730087),('5','131','257652','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730088),('5','131','257652','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730089),('5','131','257653','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730090),('5','131','257653','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730091),('5','131','257653','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730092),('5','131','257654','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730093),('5','131','257654','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730094),('5','131','257654','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730095),('5','131','257655','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730096),('5','131','257655','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730097),('5','131','257655','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730098),('5','131','257656','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730099),('5','131','257656','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730100),('5','131','257656','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730101),('5','131','257657','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730102),('5','131','257657','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730103),('5','131','257657','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730104),('5','131','257658','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730105),('5','131','257658','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730106),('5','131','257658','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730107),('5','131','257659','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730108),('5','131','257659','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730109),('5','131','257659','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730110),('5','131','257660','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730111),('5','131','257660','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730112),('5','131','257660','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730113),('5','131','257661','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730114),('5','131','257661','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730115),('5','131','257661','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730116),('5','131','257662','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730117),('5','131','257662','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730118),('5','131','257662','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730119),('5','131','257663','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730120),('5','131','257663','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730121),('5','131','257663','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730122),('5','131','257664','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730123),('5','131','257664','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730124),('5','131','257664','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730125),('5','131','257665','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730126),('5','131','257665','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730127),('5','131','257665','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730128),('5','131','257666','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730129),('5','131','257666','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730130),('5','131','257666','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730131),('5','131','257667','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730132),('5','131','257667','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730133),('5','131','257667','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730134),('5','131','257668','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730135),('5','131','257668','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730136),('5','131','257668','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730137),('5','131','257669','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730138),('5','131','257669','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730139),('5','131','257669','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730140),('5','131','257670','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730141),('5','131','257670','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730142),('5','131','257670','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730143),('5','131','257671','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730144),('5','131','257671','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730145),('5','131','257671','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730146),('5','131','257672','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730147),('5','131','257672','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730148),('5','131','257672','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730149),('5','131','257673','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730150),('5','131','257673','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730151),('5','131','257673','308',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730152),('5','131','257674','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730153),('5','131','257674','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730154),('5','131','257674','308',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730155),('5','131','257675','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730156),('5','131','257675','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730157),('5','131','257675','308',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730158),('5','131','257676','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730159),('5','131','257676','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730160),('5','131','257676','308',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730161),('5','131','257677','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730162),('5','131','257677','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730163),('5','131','257677','308',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730164),('5','131','257678','308',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730165),('5','131','257678','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730166),('5','131','257678','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730167),('5','131','257679','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730168),('5','131','257679','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730169),('5','131','257679','308',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730170),('5','131','257680','308',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730171),('5','131','257680','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730172),('5','131','257680','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730173),('5','131','257681','308',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730174),('5','131','257681','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730175),('5','131','257681','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730176),('5','131','257682','308',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730177),('5','131','257682','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730178),('5','131','257682','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730179),('5','131','257683','308',185.00,185.00,7118.87,0.00,0.00,0.00,0.00,730180),('5','131','257683','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730181),('5','131','257683','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730182),('5','131','257684','308',185.00,185.00,7133.29,0.00,0.00,0.00,0.00,730183),('5','131','257684','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730184),('5','131','257684','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730185),('5','131','257685','308',185.00,185.00,5544.76,0.00,0.00,0.00,0.00,730186),('5','131','257685','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730187),('5','131','257685','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730188),('5','131','257686','308',185.00,185.00,6981.03,0.00,0.00,0.00,0.00,730189),('5','131','257686','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730190),('5','131','257686','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730191),('5','131','257687','308',185.00,185.00,7013.24,0.00,0.00,0.00,0.00,730192),('5','131','257687','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730193),('5','131','257687','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730194),('5','131','257688','309',345.00,185.00,0.00,0.00,0.00,0.00,0.00,730195),('5','131','257688','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730196),('5','131','257688','308',185.00,165.00,4463.63,0.00,0.00,0.00,0.00,730197),('5','131','257689','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730198),('5','131','257689','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730199),('5','131','257689','308',185.00,185.00,5108.31,0.00,0.00,0.00,0.00,730200),('5','131','257690','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730201),('5','131','257690','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730202),('5','131','257690','308',185.00,185.00,1875.45,0.00,0.00,0.00,0.00,730203),('5','131','257691','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730204),('5','131','257691','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730205),('5','131','257691','308',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730206),('5','131','257692','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730207),('5','131','257692','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730208),('5','131','257692','308',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730209),('5','131','257693','308',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730210),('5','131','257693','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730211),('5','131','257693','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730212),('5','131','257694','308',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730213),('5','131','257694','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730214),('5','131','257694','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730215),('5','131','257695','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730216),('5','131','257695','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730217),('5','131','257695','308',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730218),('5','131','257696','308',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730219),('5','131','257696','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730220),('5','131','257696','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730221),('5','131','257697','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730222),('5','131','257697','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730223),('5','131','257697','308',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730224),('5','131','257698','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730225),('5','131','257698','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730226),('5','131','257698','308',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730227),('5','131','257699','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730228),('5','131','257699','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730229),('5','131','257699','308',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730230),('5','131','257700','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730231),('5','131','257700','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730232),('5','131','257700','308',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730233),('5','131','257701','309',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730234),('5','131','257701','310',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730235),('5','131','257701','308',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730236);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=291 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('5',290,'131','PRODUCT TANKS','TANKS CONTAINING PRODUCTS.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=748 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('5','131','290',744,0,'308','PMS TANK 1',46000.00,1.00,9880.08,'TANK CONTAINING PMS','475','2020-03-23 14:04:37','2021-03-02 18:08:53','475',5,1),('5','131','290',745,0,'308','PMS TANK 2',46000.00,1.00,18248.00,'TANK CONTAINING PMS','475','2020-03-23 14:11:01','2020-03-23 14:11:01','475',5,1),('5','131','290',747,0,'309','TANK 3 AGO',46000.00,1.00,1192.00,'TANK CONTAINING AGO','475','2020-03-23 14:24:47','2020-03-23 14:24:47','475',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2649878 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2131923,'5','131',NULL,308,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,2491500.00,15100.00,0.00,0.00,'2021-12-02 16:45:16','',''),(2132597,'5','131',NULL,308,'Reception corrector for bridging 125968',0.00,0.00,0.00,15100.00,0.00,'2021-12-02 17:25:49','',''),(2132598,'5','131','744',308,'Received from bridging 125968',0.00,0.00,15100.00,0.00,0.00,'2021-12-02 17:25:49','',''),(2133806,'5','131','744',308,'Sale Id shift 243162',0.00,0.00,0.00,6198.48,0.00,'2021-12-03 05:33:59','',''),(2133807,'5','131',NULL,308,'Sale Id shift 243162',1022749.20,0.00,0.00,0.00,0.00,'2021-12-03 05:33:59','',''),(2144693,'5','131',NULL,308,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,2496450.00,15130.00,0.00,0.00,'2021-12-03 16:36:17','',''),(2160449,'5','131','744',308,'Sale Id shift 243423',0.00,0.00,0.00,7313.05,0.00,'2021-12-04 17:39:52','',''),(2160450,'5','131','745',308,'Sale Id shift 243423',0.00,0.00,0.00,2152.39,0.00,'2021-12-04 17:39:52','',''),(2160451,'5','131',NULL,308,'Sale Id shift 243423',1561797.60,0.00,0.00,0.00,0.00,'2021-12-04 17:39:52','',''),(2186529,'5','131',NULL,308,'Reception corrector for bridging 126092',0.00,0.00,0.00,15130.00,0.00,'2021-12-06 18:48:30','',''),(2186530,'5','131','745',308,'Received from bridging 126092',0.00,0.00,15130.00,0.00,0.00,'2021-12-06 18:48:30','',''),(2187309,'5','131','744',308,'Sale Id shift 243797',0.00,0.00,0.00,1487.20,0.00,'2021-12-07 06:15:56','',''),(2187310,'5','131','745',308,'Sale Id shift 243797',0.00,0.00,0.00,9066.45,0.00,'2021-12-07 06:15:56','',''),(2187311,'5','131',NULL,308,'Sale Id shift 243797',1741352.25,0.00,0.00,0.00,0.00,'2021-12-07 06:15:56','',''),(2197572,'5','131','745',308,'Sale Id shift 244309',0.00,0.00,0.00,3516.62,0.00,'2021-12-07 16:19:12','',''),(2197573,'5','131',NULL,308,'Sale Id shift 244309',580242.30,0.00,0.00,0.00,0.00,'2021-12-07 16:19:12','',''),(2197847,'5','131',NULL,308,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,6600000.00,40000.00,0.00,0.00,'2021-12-07 16:32:00','',''),(2199220,'5','131',NULL,308,'Reception corrector for bridging 126489',0.00,0.00,0.00,13000.00,0.00,'2021-12-07 18:52:17','',''),(2199221,'5','131','744',308,'Received from bridging 126489',0.00,0.00,13000.00,0.00,0.00,'2021-12-07 18:52:17','',''),(2199222,'5','131',NULL,308,'Reception corrector for bridging 126490',0.00,0.00,0.00,27000.00,0.00,'2021-12-07 18:52:32','',''),(2199223,'5','131','745',308,'Received from bridging 126490',0.00,0.00,27000.00,0.00,0.00,'2021-12-07 18:52:32','',''),(2206170,'5','131','744',308,'Sale Id shift 244569',0.00,0.00,0.00,727.78,0.00,'2021-12-08 13:09:44','',''),(2206171,'5','131','745',308,'Sale Id shift 244569',0.00,0.00,0.00,1634.08,0.00,'2021-12-08 13:09:44','',''),(2206172,'5','131',NULL,308,'Sale Id shift 244569',389706.90,0.00,0.00,0.00,0.00,'2021-12-08 13:09:44','',''),(2214587,'5','131','744',308,'Sale Id shift 244683',0.00,0.00,0.00,4675.21,0.00,'2021-12-09 08:26:09','',''),(2214588,'5','131','745',308,'Sale Id shift 244683',0.00,0.00,0.00,5037.85,0.00,'2021-12-09 08:26:09','',''),(2214589,'5','131',NULL,308,'Sale Id shift 244683',1602654.90,0.00,0.00,0.00,0.00,'2021-12-09 08:26:09','',''),(2228561,'5','131','744',308,'Sale Id shift 244811',0.00,0.00,0.00,5835.96,0.00,'2021-12-10 09:22:03','',''),(2228562,'5','131','745',308,'Sale Id shift 244811',0.00,0.00,0.00,6261.25,0.00,'2021-12-10 09:22:03','',''),(2228563,'5','131',NULL,308,'Sale Id shift 244811',1996039.65,0.00,0.00,0.00,0.00,'2021-12-10 09:22:03','',''),(2250823,'5','131','745',308,'Sale Id shift 245068',0.00,0.00,0.00,8520.96,0.00,'2021-12-11 17:29:20','',''),(2250824,'5','131',NULL,308,'Sale Id shift 245068',1405958.40,0.00,0.00,0.00,0.00,'2021-12-11 17:29:20','',''),(2251762,'5','131','744',308,'Sale Id shift 245401',0.00,0.00,0.00,1661.44,0.00,'2021-12-11 20:37:06','',''),(2251763,'5','131','745',308,'Sale Id shift 245401',0.00,0.00,0.00,5358.62,0.00,'2021-12-11 20:37:06','',''),(2251764,'5','131',NULL,308,'Sale Id shift 245401',1158309.90,0.00,0.00,0.00,0.00,'2021-12-11 20:37:06','',''),(2307005,'5','131',NULL,308,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,4950000.00,30000.00,0.00,0.00,'2021-12-17 15:45:22','',''),(2310071,'5','131',NULL,308,'Reception corrector for bridging 127773',0.00,0.00,0.00,15000.00,0.00,'2021-12-18 07:48:02','',''),(2310072,'5','131','745',308,'Received from bridging 127773',0.00,0.00,15000.00,0.00,0.00,'2021-12-18 07:48:02','',''),(2310074,'5','131',NULL,308,'Reception corrector for bridging 127772',0.00,0.00,0.00,15000.00,0.00,'2021-12-18 07:48:16','',''),(2310075,'5','131','744',308,'Received from bridging 127772',0.00,0.00,15000.00,0.00,0.00,'2021-12-18 07:48:16','',''),(2325595,'5','131','744',308,'Sale Id shift 246789',0.00,0.00,0.00,2143.97,0.00,'2021-12-19 17:33:20','',''),(2325596,'5','131','745',308,'Sale Id shift 246789',0.00,0.00,0.00,2991.35,0.00,'2021-12-19 17:33:20','',''),(2325597,'5','131',NULL,308,'Sale Id shift 246789',847327.80,0.00,0.00,0.00,0.00,'2021-12-19 17:33:20','',''),(2326180,'5','131','744',308,'Sale Id shift 247352',0.00,0.00,0.00,4563.45,0.00,'2021-12-20 06:12:32','',''),(2326181,'5','131','745',308,'Sale Id shift 247352',0.00,0.00,0.00,3924.94,0.00,'2021-12-20 06:12:32','',''),(2326182,'5','131',NULL,308,'Sale Id shift 247352',1400584.35,0.00,0.00,0.00,0.00,'2021-12-20 06:12:32','',''),(2332827,'5','131','744',308,'Sale Id shift 247422',0.00,0.00,0.00,4705.14,0.00,'2021-12-20 18:03:32','',''),(2332828,'5','131','745',308,'Sale Id shift 247422',0.00,0.00,0.00,5136.37,0.00,'2021-12-20 18:03:32','',''),(2332829,'5','131',NULL,308,'Sale Id shift 247422',1623849.15,0.00,0.00,0.00,0.00,'2021-12-20 18:03:32','',''),(2349438,'5','131','744',308,'Sale Id shift 248082',0.00,0.00,0.00,3795.91,0.00,'2021-12-23 04:54:46','',''),(2349439,'5','131','745',308,'Sale Id shift 248082',0.00,0.00,0.00,1435.32,0.00,'2021-12-23 04:54:46','',''),(2349440,'5','131',NULL,308,'Sale Id shift 248082',863152.95,0.00,0.00,0.00,0.00,'2021-12-23 04:54:46','',''),(2351849,'5','131','745',308,'Sale Id shift 248234',0.00,0.00,0.00,909.09,0.00,'2021-12-23 09:42:40','',''),(2351850,'5','131',NULL,308,'Sale Id shift 248234',149999.85,0.00,0.00,0.00,0.00,'2021-12-23 09:42:40','',''),(2446885,'5','131',NULL,308,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,6509250.00,39450.00,0.00,0.00,'2022-01-05 17:36:22','',''),(2447997,'5','131',NULL,308,'Reception corrector for bridging 129876',0.00,0.00,0.00,13300.00,0.00,'2022-01-06 00:45:06','',''),(2447998,'5','131','744',308,'Received from bridging 129876',0.00,0.00,13300.00,0.00,0.00,'2022-01-06 00:45:06','',''),(2447999,'5','131',NULL,308,'Reception corrector for bridging 129877',0.00,0.00,0.00,26150.00,0.00,'2022-01-06 00:45:17','',''),(2448000,'5','131','745',308,'Received from bridging 129877',0.00,0.00,26150.00,0.00,0.00,'2022-01-06 00:45:17','',''),(2451321,'5','131','744',308,'Sale Id shift 251586',0.00,0.00,0.00,1485.31,0.00,'2022-01-06 12:25:53','',''),(2451322,'5','131','745',308,'Sale Id shift 251586',0.00,0.00,0.00,2764.03,0.00,'2022-01-06 12:25:53','',''),(2451323,'5','131',NULL,308,'Sale Id shift 251586',701141.10,0.00,0.00,0.00,0.00,'2022-01-06 12:25:53','',''),(2457629,'5','131','744',308,'Sale Id shift 251670',0.00,0.00,0.00,4182.71,0.00,'2022-01-07 10:15:28','',''),(2457630,'5','131','745',308,'Sale Id shift 251670',0.00,0.00,0.00,7131.43,0.00,'2022-01-07 10:15:28','',''),(2457631,'5','131',NULL,308,'Sale Id shift 251670',1866833.10,0.00,0.00,0.00,0.00,'2022-01-07 10:15:28','',''),(2463500,'5','131','744',308,'Sale Id shift 251841',0.00,0.00,0.00,5469.13,0.00,'2022-01-08 08:07:20','',''),(2463501,'5','131','745',308,'Sale Id shift 251841',0.00,0.00,0.00,2131.57,0.00,'2022-01-08 08:07:20','',''),(2463502,'5','131',NULL,308,'Sale Id shift 251841',1254115.50,0.00,0.00,0.00,0.00,'2022-01-08 08:07:20','',''),(2477080,'5','131','744',308,'Sale Id shift 252053',0.00,0.00,0.00,1657.98,0.00,'2022-01-09 15:50:17','',''),(2477081,'5','131','745',308,'Sale Id shift 252053',0.00,0.00,0.00,6192.46,0.00,'2022-01-09 15:50:17','',''),(2477082,'5','131',NULL,308,'Sale Id shift 252053',1295322.60,0.00,0.00,0.00,0.00,'2022-01-09 15:50:17','',''),(2490125,'5','131','745',308,'Sale Id shift 252831',0.00,0.00,0.00,6269.32,0.00,'2022-01-11 14:02:41','',''),(2490126,'5','131',NULL,308,'Sale Id shift 252831',1034437.80,0.00,0.00,0.00,0.00,'2022-01-11 14:02:41','',''),(2490613,'5','131','745',308,'Sale Id shift 252856',0.00,0.00,0.00,3138.42,0.00,'2022-01-11 14:46:22','',''),(2490614,'5','131',NULL,308,'Sale Id shift 252856',517839.30,0.00,0.00,0.00,0.00,'2022-01-11 14:46:22','',''),(2511226,'5','131',NULL,308,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,2145000.00,13000.00,0.00,0.00,'2022-01-14 10:10:25','',''),(2514558,'5','131',NULL,308,'Reception corrector for bridging 130866',0.00,0.00,0.00,13000.00,0.00,'2022-01-14 16:22:47','',''),(2514559,'5','131','745',308,'Received from bridging 130866',0.00,0.00,13000.00,0.00,0.00,'2022-01-14 16:22:47','',''),(2517884,'5','131','745',308,'Sale Id shift 253525',0.00,0.00,0.00,4984.25,0.00,'2022-01-15 09:07:32','',''),(2517885,'5','131',NULL,308,'Sale Id shift 253525',822401.25,0.00,0.00,0.00,0.00,'2022-01-15 09:07:32','',''),(2525723,'5','131','745',308,'Sale Id shift 253778',0.00,0.00,0.00,5597.77,0.00,'2022-01-16 06:38:51','',''),(2525724,'5','131',NULL,308,'Sale Id shift 253778',923632.05,0.00,0.00,0.00,0.00,'2022-01-16 06:38:51','',''),(2534120,'5','131','745',308,'Sale Id shift 254037',0.00,0.00,0.00,1377.97,0.00,'2022-01-17 07:07:50','',''),(2534121,'5','131',NULL,308,'Sale Id shift 254037',227365.05,0.00,0.00,0.00,0.00,'2022-01-17 07:07:50','',''),(2612814,'5','131',NULL,310,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2612822,'5','131',NULL,309,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,270000.00,1800.00,900.00,0.00,'2021-11-30 23:59:59','',''),(2612827,'5','131',NULL,308,'Balance from closing inventory values 2021-11-31 23:59:59',30242127.45,30593275.00,372850.00,370705.21,0.00,'2021-11-30 23:59:59','',''),(2613331,'5','131','744',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,77755.00,77492.62,0.00,'2021-11-30 23:59:59','',''),(2613401,'5','131','745',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,117825.00,113154.42,0.00,'2021-11-30 23:59:59','',''),(2613785,'5','131','747',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,900.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2645173,'5','131',NULL,308,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,3679500.00,22300.00,0.00,0.00,'2022-01-30 12:32:27','',''),(2649674,'5','131',NULL,308,'Reception corrector for bridging 132692',0.00,0.00,0.00,22300.00,0.00,'2022-01-30 17:40:40','',''),(2649675,'5','131','745',308,'Received from bridging 132692',0.00,0.00,22300.00,0.00,0.00,'2022-01-30 17:40:40','',''),(2649676,'5','131','745',308,'Sale Id shift 257509',0.00,0.00,0.00,5873.94,0.00,'2022-01-31 09:18:08','',''),(2649677,'5','131',NULL,308,'Sale Id shift 257509',969200.10,0.00,0.00,0.00,0.00,'2022-01-31 09:18:08','',''),(2649678,'5','131','745',308,'Sale Id shift 257510',0.00,0.00,0.00,5659.53,0.00,'2022-02-02 19:19:20','',''),(2649679,'5','131',NULL,308,'Sale Id shift 257510',933822.45,0.00,0.00,0.00,0.00,'2022-02-02 19:19:20','',''),(2649680,'5','131','745',308,'Sale Id shift 257511',0.00,0.00,0.00,5238.16,0.00,'2022-02-02 19:43:05','',''),(2649681,'5','131',NULL,308,'Sale Id shift 257511',864296.40,0.00,0.00,0.00,0.00,'2022-02-02 19:43:05','',''),(2649682,'5','131','745',308,'Sale Id shift 257512',0.00,0.00,0.00,5202.16,0.00,'2022-02-03 07:56:45','',''),(2649683,'5','131',NULL,308,'Sale Id shift 257512',858356.40,0.00,0.00,0.00,0.00,'2022-02-03 07:56:45','',''),(2649684,'5','131',NULL,308,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,4925250.00,29850.00,0.00,0.00,'2022-02-03 20:39:04','',''),(2649685,'5','131',NULL,308,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-02-03 20:39:21','',''),(2649686,'5','131','745',308,'Sale Id shift 257513',0.00,0.00,0.00,4784.57,0.00,'2022-02-03 20:39:52','',''),(2649687,'5','131',NULL,308,'Sale Id shift 257513',789454.05,0.00,0.00,0.00,0.00,'2022-02-03 20:39:52','',''),(2649688,'5','131',NULL,308,'Reception corrector for bridging 132693',0.00,0.00,0.00,29850.00,0.00,'2022-02-03 22:04:59','',''),(2649689,'5','131','745',308,'Received from bridging 132693',0.00,0.00,29850.00,0.00,0.00,'2022-02-03 22:04:59','',''),(2649690,'5','131',NULL,308,'Reception corrector for bridging 132694',0.00,0.00,0.00,45000.00,0.00,'2022-02-03 22:05:11','',''),(2649691,'5','131','744',308,'Received from bridging 132694',0.00,0.00,45000.00,0.00,0.00,'2022-02-03 22:05:11','',''),(2649692,'5','131','745',308,'Sale Id shift 257514',0.00,0.00,0.00,5143.29,0.00,'2022-02-05 06:56:30','',''),(2649693,'5','131',NULL,308,'Sale Id shift 257514',848642.85,0.00,0.00,0.00,0.00,'2022-02-05 06:56:30','',''),(2649694,'5','131','745',308,'Sale Id shift 257517',0.00,0.00,0.00,5964.30,0.00,'2022-02-05 22:41:09','',''),(2649695,'5','131',NULL,308,'Sale Id shift 257517',984109.50,0.00,0.00,0.00,0.00,'2022-02-05 22:41:09','',''),(2649696,'5','131','745',308,'Sale Id shift 257518',0.00,0.00,0.00,5327.48,0.00,'2022-02-07 07:21:10','',''),(2649697,'5','131',NULL,308,'Sale Id shift 257518',879034.20,0.00,0.00,0.00,0.00,'2022-02-07 07:21:10','',''),(2649698,'5','131','745',308,'Sale Id shift 257519',0.00,0.00,0.00,5451.31,0.00,'2022-02-08 07:18:13','',''),(2649699,'5','131',NULL,308,'Sale Id shift 257519',899466.15,0.00,0.00,0.00,0.00,'2022-02-08 07:18:13','',''),(2649700,'5','131','744',308,'Sale Id shift 257520',0.00,0.00,0.00,2220.92,0.00,'2022-02-08 20:42:11','',''),(2649701,'5','131','745',308,'Sale Id shift 257520',0.00,0.00,0.00,3434.78,0.00,'2022-02-08 20:42:11','',''),(2649702,'5','131',NULL,308,'Sale Id shift 257520',933190.50,0.00,0.00,0.00,0.00,'2022-02-08 20:42:11','',''),(2649703,'5','131','744',308,'Sale Id shift 257521',0.00,0.00,0.00,4945.23,0.00,'2022-02-09 20:55:54','',''),(2649704,'5','131','745',308,'Sale Id shift 257521',0.00,0.00,0.00,915.88,0.00,'2022-02-09 20:55:54','',''),(2649705,'5','131',NULL,308,'Sale Id shift 257521',967083.15,0.00,0.00,0.00,0.00,'2022-02-09 20:55:54','',''),(2649706,'5','131','744',308,'Sale Id shift 257522',0.00,0.00,0.00,6125.51,0.00,'2022-02-10 21:43:43','',''),(2649707,'5','131',NULL,308,'Sale Id shift 257522',1010709.15,0.00,0.00,0.00,0.00,'2022-02-10 21:43:43','',''),(2649708,'5','131','744',308,'Sale Id shift 257523',0.00,0.00,0.00,5925.45,0.00,'2022-02-11 20:21:07','',''),(2649709,'5','131',NULL,308,'Sale Id shift 257523',977699.25,0.00,0.00,0.00,0.00,'2022-02-11 20:21:07','',''),(2649710,'5','131','744',308,'Sale Id shift 257524',0.00,0.00,0.00,7311.85,0.00,'2022-02-13 08:47:45','',''),(2649711,'5','131',NULL,308,'Sale Id shift 257524',1206455.25,0.00,0.00,0.00,0.00,'2022-02-13 08:47:45','',''),(2649712,'5','131','744',308,'Sale Id shift 257525',0.00,0.00,0.00,6389.72,0.00,'2022-02-14 06:09:28','',''),(2649713,'5','131',NULL,308,'Sale Id shift 257525',1054303.80,0.00,0.00,0.00,0.00,'2022-02-14 06:09:28','',''),(2649714,'5','131','744',308,'Sale Id shift 257526',0.00,0.00,0.00,4397.20,0.00,'2022-02-14 23:48:08','',''),(2649715,'5','131',NULL,308,'Sale Id shift 257526',725538.00,0.00,0.00,0.00,0.00,'2022-02-14 23:48:08','',''),(2649716,'5','131','744',308,'Sale Id shift 257527',0.00,0.00,0.00,3046.88,0.00,'2022-02-16 06:11:36','',''),(2649717,'5','131',NULL,308,'Sale Id shift 257527',502735.20,0.00,0.00,0.00,0.00,'2022-02-16 06:11:36','',''),(2649718,'5','131',NULL,308,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,2128500.00,12900.00,0.00,0.00,'2022-02-17 12:06:30','',''),(2649719,'5','131',NULL,308,'Reception corrector for bridging 132695',0.00,0.00,0.00,12900.00,0.00,'2022-02-17 19:16:40','',''),(2649720,'5','131','745',308,'Received from bridging 132695',0.00,0.00,12900.00,0.00,0.00,'2022-02-17 19:16:40','',''),(2649721,'5','131','744',308,'Sale Id shift 257528',0.00,0.00,0.00,4109.66,0.00,'2022-02-18 07:58:22','',''),(2649722,'5','131','745',308,'Sale Id shift 257528',0.00,0.00,0.00,5667.49,0.00,'2022-02-18 07:58:22','',''),(2649723,'5','131',NULL,308,'Sale Id shift 257528',1613229.75,0.00,0.00,0.00,0.00,'2022-02-18 07:58:22','',''),(2649724,'5','131','744',308,'Sale Id shift 257529',0.00,0.00,0.00,870.24,0.00,'2022-02-18 10:13:50','',''),(2649725,'5','131','745',308,'Sale Id shift 257529',0.00,0.00,0.00,4111.64,0.00,'2022-02-18 10:13:50','',''),(2649726,'5','131',NULL,308,'Sale Id shift 257529',822010.20,0.00,0.00,0.00,0.00,'2022-02-18 10:13:50','',''),(2649727,'5','131','745',308,'Sale Id shift 257530',0.00,0.00,0.00,2903.55,0.00,'2022-02-19 07:18:53','',''),(2649728,'5','131',NULL,308,'Sale Id shift 257530',479085.75,0.00,0.00,0.00,0.00,'2022-02-19 07:18:53','',''),(2649729,'5','131',NULL,308,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,6534000.00,39600.00,0.00,0.00,'2022-02-21 10:03:20','',''),(2649730,'5','131',NULL,308,'Reception corrector for bridging 132696',0.00,0.00,0.00,13300.00,0.00,'2022-02-21 16:31:44','',''),(2649731,'5','131','744',308,'Received from bridging 132696',0.00,0.00,13300.00,0.00,0.00,'2022-02-21 16:31:44','',''),(2649732,'5','131',NULL,308,'Reception corrector for bridging 132697',0.00,0.00,0.00,26300.00,0.00,'2022-02-21 16:32:06','',''),(2649733,'5','131','745',308,'Received from bridging 132697',0.00,0.00,26300.00,0.00,0.00,'2022-02-21 16:32:06','',''),(2649734,'5','131','744',308,'Sale Id shift 257533',0.00,0.00,0.00,6615.02,0.00,'2022-02-22 06:55:22','',''),(2649735,'5','131','745',308,'Sale Id shift 257533',0.00,0.00,0.00,5601.43,0.00,'2022-02-22 06:55:22','',''),(2649736,'5','131',NULL,308,'Sale Id shift 257533',2015714.25,0.00,0.00,0.00,0.00,'2022-02-22 06:55:22','',''),(2649737,'5','131','744',308,'Sale Id shift 257534',0.00,0.00,0.00,5863.51,0.00,'2022-02-23 07:12:18','',''),(2649738,'5','131','745',308,'Sale Id shift 257534',0.00,0.00,0.00,5316.80,0.00,'2022-02-23 07:12:18','',''),(2649739,'5','131',NULL,308,'Sale Id shift 257534',1844751.15,0.00,0.00,0.00,0.00,'2022-02-23 07:12:18','',''),(2649740,'5','131','744',308,'Sale Id shift 257535',0.00,0.00,0.00,893.52,0.00,'2022-02-24 15:42:05','',''),(2649741,'5','131','745',308,'Sale Id shift 257535',0.00,0.00,0.00,5000.12,0.00,'2022-02-24 15:42:05','',''),(2649742,'5','131',NULL,308,'Sale Id shift 257535',972450.60,0.00,0.00,0.00,0.00,'2022-02-24 15:42:05','',''),(2649743,'5','131','745',308,'Sale Id shift 257536',0.00,0.00,0.00,8138.67,0.00,'2022-02-25 06:47:17','',''),(2649744,'5','131',NULL,308,'Sale Id shift 257536',1342880.55,0.00,0.00,0.00,0.00,'2022-02-25 06:47:17','',''),(2649745,'5','131','745',308,'Sale Id shift 257537',0.00,0.00,0.00,3163.84,0.00,'2022-02-26 07:17:26','',''),(2649746,'5','131',NULL,308,'Sale Id shift 257537',522033.60,0.00,0.00,0.00,0.00,'2022-02-26 07:17:26','',''),(2649747,'5','131','745',308,'Sale Id shift 257538',0.00,0.00,0.00,94.90,0.00,'2022-02-27 09:12:01','',''),(2649748,'5','131',NULL,308,'Sale Id shift 257538',15658.50,0.00,0.00,0.00,0.00,'2022-02-27 09:12:01','',''),(2649749,'5','131',NULL,308,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,2805000.00,17000.00,0.00,0.00,'2022-03-02 14:35:02','',''),(2649750,'5','131',NULL,308,'Reception corrector for bridging 132698',0.00,0.00,0.00,17000.00,0.00,'2022-03-02 16:08:40','',''),(2649751,'5','131','745',308,'Received from bridging 132698',0.00,0.00,17000.00,0.00,0.00,'2022-03-02 16:08:40','',''),(2649752,'5','131','745',308,'Sale Id shift 257541',0.00,0.00,0.00,7091.20,0.00,'2022-03-02 21:00:27','',''),(2649753,'5','131',NULL,308,'Sale Id shift 257541',1170048.00,0.00,0.00,0.00,0.00,'2022-03-02 21:00:27','',''),(2649754,'5','131','745',308,'Sale Id shift 257542',0.00,0.00,0.00,5326.01,0.00,'2022-03-03 08:08:17','',''),(2649755,'5','131',NULL,308,'Sale Id shift 257542',878791.65,0.00,0.00,0.00,0.00,'2022-03-03 08:08:17','',''),(2649756,'5','131','745',308,'Sale Id shift 257543',0.00,0.00,0.00,3750.01,0.00,'2022-03-04 08:20:02','',''),(2649757,'5','131',NULL,308,'Sale Id shift 257543',618751.65,0.00,0.00,0.00,0.00,'2022-03-04 08:20:02','',''),(2649758,'5','131',NULL,308,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,4950000.00,30000.00,0.00,0.00,'2022-03-14 19:44:27','',''),(2649759,'5','131',NULL,308,'Reception corrector for bridging 132699',0.00,0.00,0.00,15000.00,0.00,'2022-03-15 20:54:20','',''),(2649760,'5','131','744',308,'Received from bridging 132699',0.00,0.00,15000.00,0.00,0.00,'2022-03-15 20:54:20','',''),(2649761,'5','131',NULL,308,'Reception corrector for bridging 132700',0.00,0.00,0.00,15000.00,0.00,'2022-03-15 20:54:35','',''),(2649762,'5','131','745',308,'Received from bridging 132700',0.00,0.00,15000.00,0.00,0.00,'2022-03-15 20:54:35','',''),(2649763,'5','131','744',308,'Sale Id shift 257555',0.00,0.00,0.00,6155.22,0.00,'2022-03-16 08:13:36','',''),(2649764,'5','131','745',308,'Sale Id shift 257555',0.00,0.00,0.00,7492.14,0.00,'2022-03-16 08:13:36','',''),(2649765,'5','131',NULL,308,'Sale Id shift 257555',2251814.40,0.00,0.00,0.00,0.00,'2022-03-16 08:13:36','',''),(2649766,'5','131','745',308,'Sale Id shift 257556',0.00,0.00,0.00,6458.78,0.00,'2022-03-17 08:10:31','',''),(2649767,'5','131',NULL,308,'Sale Id shift 257556',1065698.70,0.00,0.00,0.00,0.00,'2022-03-17 08:10:31','',''),(2649768,'5','131','744',308,'Sale Id shift 257557',0.00,0.00,0.00,6177.56,0.00,'2022-03-18 07:38:13','',''),(2649769,'5','131',NULL,308,'Sale Id shift 257557',1019297.40,0.00,0.00,0.00,0.00,'2022-03-18 07:38:13','',''),(2649770,'5','131','744',308,'Sale Id shift 257558',0.00,0.00,0.00,2356.51,0.00,'2022-03-19 07:06:55','',''),(2649771,'5','131','745',308,'Sale Id shift 257558',0.00,0.00,0.00,835.11,0.00,'2022-03-19 07:06:55','',''),(2649772,'5','131',NULL,308,'Sale Id shift 257558',526617.30,0.00,0.00,0.00,0.00,'2022-03-19 07:06:55','',''),(2649773,'5','131',NULL,308,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,2227500.00,13500.00,0.00,0.00,'2022-03-24 12:46:53','',''),(2649774,'5','131',NULL,308,'Reception corrector for bridging 132701',0.00,0.00,0.00,13500.00,0.00,'2022-03-24 22:53:16','',''),(2649775,'5','131','745',308,'Received from bridging 132701',0.00,0.00,13500.00,0.00,0.00,'2022-03-24 22:53:16','',''),(2649776,'5','131','745',308,'Sale Id shift 257564',0.00,0.00,0.00,5648.82,0.00,'2022-03-25 06:45:13','',''),(2649777,'5','131',NULL,308,'Sale Id shift 257564',932055.30,0.00,0.00,0.00,0.00,'2022-03-25 06:45:13','',''),(2649778,'5','131','745',308,'Sale Id shift 257565',0.00,0.00,0.00,5256.03,0.00,'2022-03-26 04:54:42','',''),(2649779,'5','131',NULL,308,'Sale Id shift 257565',867244.95,0.00,0.00,0.00,0.00,'2022-03-26 04:54:42','',''),(2649780,'5','131','745',308,'Sale Id shift 257566',0.00,0.00,0.00,2296.22,0.00,'2022-03-27 07:55:41','',''),(2649781,'5','131',NULL,308,'Sale Id shift 257566',378876.30,0.00,0.00,0.00,0.00,'2022-03-27 07:55:41','',''),(2649782,'5','131','745',308,'Sale Id shift 257583',0.00,0.00,0.00,499.98,0.00,'2022-04-13 04:04:17','',''),(2649783,'5','131',NULL,308,'Sale Id shift 257583',82496.70,0.00,0.00,0.00,0.00,'2022-04-13 04:04:17','',''),(2649784,'5','131',NULL,308,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,2475000.00,15000.00,0.00,0.00,'2022-04-13 04:04:48','',''),(2649785,'5','131',NULL,308,'Reception corrector for bridging 132702',0.00,0.00,0.00,15000.00,0.00,'2022-04-15 09:12:08','',''),(2649786,'5','131','745',308,'Received from bridging 132702',0.00,0.00,15000.00,0.00,0.00,'2022-04-15 09:12:08','',''),(2649787,'5','131','745',308,'Sale Id shift 257584',0.00,0.00,0.00,6043.35,0.00,'2022-04-16 05:12:48','',''),(2649788,'5','131',NULL,308,'Sale Id shift 257584',997152.75,0.00,0.00,0.00,0.00,'2022-04-16 05:12:48','',''),(2649789,'5','131','745',308,'Sale Id shift 257585',0.00,0.00,0.00,4857.34,0.00,'2022-04-16 11:41:03','',''),(2649790,'5','131',NULL,308,'Sale Id shift 257585',801461.10,0.00,0.00,0.00,0.00,'2022-04-16 11:41:03','',''),(2649791,'5','131','745',308,'Sale Id shift 257586',0.00,0.00,0.00,3473.71,0.00,'2022-04-16 14:47:18','',''),(2649792,'5','131',NULL,308,'Sale Id shift 257586',573162.15,0.00,0.00,0.00,0.00,'2022-04-16 14:47:18','',''),(2649793,'5','131',NULL,308,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,2227500.00,13500.00,0.00,0.00,'2022-04-21 11:15:14','',''),(2649794,'5','131','745',308,'Sale Id shift 257592',0.00,0.00,0.00,5049.86,0.00,'2022-04-22 06:10:01','',''),(2649795,'5','131',NULL,308,'Sale Id shift 257592',833226.90,0.00,0.00,0.00,0.00,'2022-04-22 06:10:01','',''),(2649796,'5','131',NULL,308,'Reception corrector for bridging 132703',0.00,0.00,0.00,13500.00,0.00,'2022-04-26 15:25:55','',''),(2649797,'5','131','745',308,'Received from bridging 132703',0.00,0.00,13500.00,0.00,0.00,'2022-04-26 15:25:55','',''),(2649798,'5','131','745',308,'Sale Id shift 257599',0.00,0.00,0.00,2393.80,0.00,'2022-04-29 06:03:12','',''),(2649799,'5','131',NULL,308,'Sale Id shift 257599',394977.00,0.00,0.00,0.00,0.00,'2022-04-29 06:03:12','',''),(2649800,'5','131',NULL,308,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,4950000.00,30000.00,0.00,0.00,'2022-04-29 14:47:25','',''),(2649801,'5','131','744',308,'Sale Id shift 257600',0.00,0.00,0.00,349.43,0.00,'2022-04-30 00:03:42','',''),(2649802,'5','131','745',308,'Sale Id shift 257600',0.00,0.00,0.00,4847.98,0.00,'2022-04-30 00:03:42','',''),(2649803,'5','131',NULL,308,'Sale Id shift 257600',857572.65,0.00,0.00,0.00,0.00,'2022-04-30 00:03:42','',''),(2649804,'5','131',NULL,308,'Reception corrector for bridging 132704',0.00,0.00,0.00,30000.00,0.00,'2022-05-09 13:59:12','',''),(2649805,'5','131','744',308,'Received from bridging 132704',0.00,0.00,30000.00,0.00,0.00,'2022-05-09 13:59:12','',''),(2649806,'5','131',NULL,308,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-05-09 14:01:49','',''),(2649807,'5','131','744',308,'Sale Id shift 257601',0.00,0.00,0.00,6011.87,0.00,'2022-05-09 14:26:26','',''),(2649808,'5','131','745',308,'Sale Id shift 257601',0.00,0.00,0.00,1706.17,0.00,'2022-05-09 14:26:26','',''),(2649809,'5','131',NULL,308,'Sale Id shift 257601',1273476.60,0.00,0.00,0.00,0.00,'2022-05-09 14:26:26','',''),(2649810,'5','131','744',308,'Sale Id shift 257602',0.00,0.00,0.00,6163.82,0.00,'2022-05-09 15:06:00','',''),(2649811,'5','131',NULL,308,'Sale Id shift 257602',1017030.30,0.00,0.00,0.00,0.00,'2022-05-09 15:06:00','',''),(2649812,'5','131','744',308,'Sale Id shift 257603',0.00,0.00,0.00,3079.02,0.00,'2022-05-09 15:27:29','',''),(2649813,'5','131',NULL,308,'Sale Id shift 257603',508038.30,0.00,0.00,0.00,0.00,'2022-05-09 15:27:29','',''),(2649814,'5','131','744',308,'Sale Id shift 257604',0.00,0.00,0.00,8109.68,0.00,'2022-05-09 15:59:44','',''),(2649815,'5','131',NULL,308,'Sale Id shift 257604',1338097.20,0.00,0.00,0.00,0.00,'2022-05-09 15:59:44','',''),(2649816,'5','131',NULL,308,'Reception corrector for bridging 132705',0.00,0.00,0.00,26500.00,0.00,'2022-05-09 19:13:47','',''),(2649817,'5','131','744',308,'Received from bridging 132705',0.00,0.00,26500.00,0.00,0.00,'2022-05-09 19:13:47','',''),(2649818,'5','131',NULL,308,'Reception corrector for bridging 132706',0.00,0.00,0.00,13500.00,0.00,'2022-05-09 19:14:00','',''),(2649819,'5','131','745',308,'Received from bridging 132706',0.00,0.00,13500.00,0.00,0.00,'2022-05-09 19:14:00','',''),(2649820,'5','131','744',308,'Sale Id shift 257605',0.00,0.00,0.00,8170.04,0.00,'2022-05-09 19:20:12','',''),(2649821,'5','131',NULL,308,'Sale Id shift 257605',1348056.60,0.00,0.00,0.00,0.00,'2022-05-09 19:20:12','',''),(2649822,'5','131','744',308,'Sale Id shift 257606',0.00,0.00,0.00,6324.60,0.00,'2022-05-09 19:23:24','',''),(2649823,'5','131','745',308,'Sale Id shift 257606',0.00,0.00,0.00,2483.83,0.00,'2022-05-09 19:23:24','',''),(2649824,'5','131',NULL,308,'Sale Id shift 257606',1453390.95,0.00,0.00,0.00,0.00,'2022-05-09 19:23:24','',''),(2649825,'5','131','744',308,'Sale Id shift 257611',0.00,0.00,0.00,6564.44,0.00,'2022-05-09 20:50:15','',''),(2649826,'5','131',NULL,308,'Sale Id shift 257611',1083132.60,0.00,0.00,0.00,0.00,'2022-05-09 20:50:15','',''),(2649827,'5','131','744',308,'Sale Id shift 257612',0.00,0.00,0.00,3360.73,0.00,'2022-05-10 22:52:34','',''),(2649828,'5','131',NULL,308,'Sale Id shift 257612',554520.45,0.00,0.00,0.00,0.00,'2022-05-10 22:52:34','',''),(2649829,'5','131','745',308,'Sale Id shift 257613',0.00,0.00,0.00,1040.35,0.00,'2022-05-12 05:31:43','',''),(2649830,'5','131',NULL,308,'Sale Id shift 257613',171657.75,0.00,0.00,0.00,0.00,'2022-05-12 05:31:43','',''),(2649831,'5','131','744',308,'Sale Id shift 257620',0.00,0.00,0.00,1728.49,0.00,'2022-05-18 21:30:50','',''),(2649832,'5','131','745',308,'Sale Id shift 257620',0.00,0.00,0.00,1901.82,0.00,'2022-05-18 21:30:50','',''),(2649833,'5','131',NULL,308,'Sale Id shift 257620',599001.15,0.00,0.00,0.00,0.00,'2022-05-18 21:30:50','',''),(2649834,'5','131','744',308,'Sale Id shift 257621',0.00,0.00,0.00,2353.74,0.00,'2022-05-20 05:23:51','',''),(2649835,'5','131','745',308,'Sale Id shift 257621',0.00,0.00,0.00,2481.32,0.00,'2022-05-20 05:23:51','',''),(2649836,'5','131',NULL,308,'Sale Id shift 257621',797784.90,0.00,0.00,0.00,0.00,'2022-05-20 05:23:51','',''),(2649837,'5','131','745',308,'Sale Id shift 257622',0.00,0.00,0.00,5139.50,0.00,'2022-05-22 08:14:52','',''),(2649838,'5','131',NULL,308,'Sale Id shift 257622',848017.50,0.00,0.00,0.00,0.00,'2022-05-22 08:14:52','',''),(2649839,'5','131','744',308,'Sale Id shift 257623',0.00,0.00,0.00,3831.99,0.00,'2022-05-23 05:16:52','',''),(2649840,'5','131','745',308,'Sale Id shift 257623',0.00,0.00,0.00,695.75,0.00,'2022-05-23 05:16:52','',''),(2649841,'5','131',NULL,308,'Sale Id shift 257623',747077.10,0.00,0.00,0.00,0.00,'2022-05-23 05:16:52','',''),(2649842,'5','131',NULL,308,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,2475000.00,15000.00,0.00,0.00,'2022-06-05 13:04:30','',''),(2649843,'5','131',NULL,308,'Reception corrector for bridging 132707',0.00,0.00,0.00,15000.00,0.00,'2022-06-05 17:02:06','',''),(2649844,'5','131','745',308,'Received from bridging 132707',0.00,0.00,15000.00,0.00,0.00,'2022-06-05 17:02:06','',''),(2649845,'5','131','744',308,'Sale Id shift 257638',0.00,0.00,0.00,467.38,0.00,'2022-06-06 06:29:41','',''),(2649846,'5','131','745',308,'Sale Id shift 257638',0.00,0.00,0.00,3663.84,0.00,'2022-06-06 06:29:41','',''),(2649847,'5','131',NULL,308,'Sale Id shift 257638',681651.30,0.00,0.00,0.00,0.00,'2022-06-06 06:29:41','',''),(2649848,'5','131','745',308,'Sale Id shift 257639',0.00,0.00,0.00,5170.09,0.00,'2022-06-07 07:27:00','',''),(2649849,'5','131',NULL,308,'Sale Id shift 257639',853064.85,0.00,0.00,0.00,0.00,'2022-06-07 07:27:00','',''),(2649850,'5','131','745',308,'Sale Id shift 257640',0.00,0.00,0.00,3792.80,0.00,'2022-06-08 10:32:13','',''),(2649851,'5','131',NULL,308,'Sale Id shift 257640',625812.00,0.00,0.00,0.00,0.00,'2022-06-08 10:32:13','',''),(2649852,'5','131','745',308,'Sale Id shift 257641',0.00,0.00,0.00,1863.12,0.00,'2022-06-09 06:01:18','',''),(2649853,'5','131',NULL,308,'Sale Id shift 257641',307414.80,0.00,0.00,0.00,0.00,'2022-06-09 06:01:18','',''),(2649854,'5','131',NULL,308,'2022-07-10 08:12:48',0.00,60094.00,0.00,0.00,0.00,'2022-07-10 08:12:48','',''),(2649855,'5','131',NULL,308,'Purchased from SALBAS OIL & GAS NIG. LTD',0.00,8306500.00,44900.00,0.00,0.00,'2022-07-20 14:56:14','',''),(2649856,'5','131',NULL,308,'Reception corrector for bridging 132709',0.00,0.00,0.00,29200.00,0.00,'2022-07-21 07:31:52','',''),(2649857,'5','131','745',308,'Received from bridging 132709',0.00,0.00,29200.00,0.00,0.00,'2022-07-21 07:31:52','',''),(2649858,'5','131',NULL,308,'Reception corrector for bridging 132708',0.00,0.00,0.00,15700.00,0.00,'2022-07-21 07:32:03','',''),(2649859,'5','131','744',308,'Received from bridging 132708',0.00,0.00,15700.00,0.00,0.00,'2022-07-21 07:32:03','',''),(2649860,'5','131','745',308,'Sale Id shift 257683',0.00,0.00,0.00,7118.87,0.00,'2022-07-21 07:59:20','',''),(2649861,'5','131',NULL,308,'Sale Id shift 257683',1316990.95,0.00,0.00,0.00,0.00,'2022-07-21 07:59:20','',''),(2649862,'5','131','744',308,'Sale Id shift 257684',0.00,0.00,0.00,3011.57,0.00,'2022-07-21 23:14:40','',''),(2649863,'5','131','745',308,'Sale Id shift 257684',0.00,0.00,0.00,4121.72,0.00,'2022-07-21 23:14:40','',''),(2649864,'5','131',NULL,308,'Sale Id shift 257684',1319658.65,0.00,0.00,0.00,0.00,'2022-07-21 23:14:40','',''),(2649865,'5','131','745',308,'Sale Id shift 257685',0.00,0.00,0.00,5544.76,0.00,'2022-07-23 06:55:43','',''),(2649866,'5','131',NULL,308,'Sale Id shift 257685',1025780.60,0.00,0.00,0.00,0.00,'2022-07-23 06:55:43','',''),(2649867,'5','131','744',308,'Sale Id shift 257686',0.00,0.00,0.00,761.24,0.00,'2022-07-24 08:32:51','',''),(2649868,'5','131','745',308,'Sale Id shift 257686',0.00,0.00,0.00,6219.79,0.00,'2022-07-24 08:32:51','',''),(2649869,'5','131',NULL,308,'Sale Id shift 257686',1291490.55,0.00,0.00,0.00,0.00,'2022-07-24 08:32:51','',''),(2649870,'5','131','745',308,'Sale Id shift 257687',0.00,0.00,0.00,7013.24,0.00,'2022-07-25 06:45:21','',''),(2649871,'5','131',NULL,308,'Sale Id shift 257687',1297449.40,0.00,0.00,0.00,0.00,'2022-07-25 06:45:21','',''),(2649872,'5','131','744',308,'Sale Id shift 257688',0.00,0.00,0.00,4463.63,0.00,'2022-07-26 05:54:26','',''),(2649873,'5','131',NULL,308,'Sale Id shift 257688',825771.55,0.00,0.00,0.00,0.00,'2022-07-26 05:54:26','',''),(2649874,'5','131','744',308,'Sale Id shift 257689',0.00,0.00,0.00,5108.31,0.00,'2022-07-27 06:05:10','',''),(2649875,'5','131',NULL,308,'Sale Id shift 257689',945037.35,0.00,0.00,0.00,0.00,'2022-07-27 06:05:10','',''),(2649876,'5','131','744',308,'Sale Id shift 257690',0.00,0.00,0.00,1875.45,0.00,'2022-07-28 06:54:52','',''),(2649877,'5','131',NULL,308,'Sale Id shift 257690',346958.25,0.00,0.00,0.00,0.00,'2022-07-28 06:54:52','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_balances`
--

DROP TABLE IF EXISTS `inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_balances`
--

LOCK TABLES `inventory_balances` WRITE;
/*!40000 ALTER TABLE `inventory_balances` DISABLE KEYS */;
/*!40000 ALTER TABLE `inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1749741 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (555068,'5','131',308,'Sale Id shift 182968',0.00,0.00,163.00,835756.42,835756.42,'2021-03-07 18:17:03'),(555069,'5','131',309,'Sale Id shift 182968',0.00,0.00,250.00,22010.00,22010.00,'2021-03-07 18:17:03'),(555072,'5','131',308,'Sale Id shift 182972',0.00,0.00,163.00,590739.71,590739.71,'2021-03-07 18:44:22'),(555073,'5','131',309,'Sale Id shift 182972',0.00,0.00,250.00,42100.00,42100.00,'2021-03-07 18:44:22'),(555095,'5','131',309,'Sale Id shift 182973',0.00,0.00,250.00,33940.00,33940.00,'2021-03-08 05:16:08'),(601839,'5','131',309,'Sale Id shift 186255',0.00,0.00,265.00,100893.45,100893.45,'2021-03-23 15:47:58'),(601873,'5','131',309,'Sale Id shift 186258',0.00,0.00,265.00,64381.75,64381.75,'2021-03-23 15:53:32'),(601901,'5','131',309,'Sale Id shift 186259',0.00,0.00,265.00,119183.75,119183.75,'2021-03-23 15:58:09'),(601930,'5','131',309,'Sale Id shift 186262',0.00,0.00,265.00,53977.85,53977.85,'2021-03-23 16:02:53'),(601958,'5','131',309,'Sale Id shift 186265',0.00,0.00,265.00,22999.35,22999.35,'2021-03-23 16:06:16'),(601992,'5','131',309,'Sale Id shift 186266',0.00,0.00,255.00,32517.60,32517.60,'2021-03-23 16:10:30'),(602020,'5','131',309,'Sale Id shift 186268',0.00,0.00,255.00,117613.65,117613.65,'2021-03-23 16:13:32'),(603658,'5','131',308,'Sale Id shift 186274',0.00,538995.36,163.00,538995.36,0.00,'2021-03-24 10:55:29'),(603659,'5','131',309,'Sale Id shift 186274',0.00,0.00,255.00,111848.10,111848.10,'2021-03-24 10:55:29'),(603726,'5','131',308,'Sale Id shift 186403',0.00,403579.85,163.00,403579.85,0.00,'2021-03-24 11:10:36'),(603727,'5','131',309,'Sale Id shift 186403',0.00,0.00,255.00,112477.95,112477.95,'2021-03-24 11:10:36'),(603750,'5','131',309,'Sale Id shift 186409',0.00,0.00,255.00,138373.20,138373.20,'2021-03-24 11:16:30'),(603865,'5','131',308,'Sale Id shift 186411',0.00,405320.69,163.00,405320.69,0.00,'2021-03-24 11:41:31'),(603866,'5','131',309,'Sale Id shift 186411',0.00,0.00,265.00,62343.90,62343.90,'2021-03-24 11:41:31'),(603913,'5','131',308,'Sale Id shift 186422',0.00,1408836.71,163.00,1408836.71,0.00,'2021-03-24 11:57:32'),(603914,'5','131',309,'Sale Id shift 186422',0.00,0.00,265.00,69464.45,69464.45,'2021-03-24 11:57:32'),(605190,'5','131',308,'Sale Id shift 186423',0.00,1316062.00,163.00,1316062.00,0.00,'2021-03-24 16:03:24'),(605191,'5','131',309,'Sale Id shift 186423',0.00,0.00,265.00,90696.25,90696.25,'2021-03-24 16:03:24'),(605228,'5','131',308,'Sale Id shift 186475',0.00,823746.58,163.00,823746.58,0.00,'2021-03-24 16:08:27'),(605229,'5','131',309,'Sale Id shift 186475',0.00,0.00,265.00,100204.45,100204.45,'2021-03-24 16:08:27'),(606955,'5','131',308,'Sale Id shift 186477',0.00,1345123.27,163.00,1345123.27,0.00,'2021-03-25 11:07:10'),(607048,'5','131',308,'Sale Id shift 186602',0.00,1467366.75,163.00,1467366.75,0.00,'2021-03-25 11:34:16'),(607436,'5','131',308,'Sale Id shift 186608',0.00,990968.28,163.00,990968.28,0.00,'2021-03-25 13:15:34'),(607774,'5','131',308,'Sale Id shift 186651',0.00,763514.82,163.00,763514.82,0.00,'2021-03-25 14:40:34'),(621849,'5','131',308,'Sale Id shift 186724',0.00,1474036.71,163.00,1474036.71,0.00,'2021-03-30 10:03:46'),(622333,'5','131',308,'Sale Id shift 187660',0.00,1380112.85,163.00,1380112.85,0.00,'2021-03-30 11:50:07'),(622453,'5','131',308,'Sale Id shift 187692',0.00,1468980.45,163.00,1468980.45,0.00,'2021-03-30 12:20:48'),(623040,'5','131',308,'Sale Id shift 187701',0.00,1326388.05,163.00,1326388.05,0.00,'2021-03-30 14:23:06'),(628072,'5','131',308,'Sale Id shift 187857',0.00,1537947.38,163.00,1537947.38,0.00,'2021-04-01 00:20:50'),(629724,'5','131',308,'Sale Id shift 188109',0.00,101296.35,163.00,101296.35,0.00,'2021-04-01 11:42:49'),(629748,'5','131',308,'Sale Id shift 188111',0.00,665698.52,163.00,665698.52,0.00,'2021-04-01 11:48:31'),(637021,'5','131',308,'Sale Id shift 188113',0.00,1663444.34,163.00,1663444.34,0.00,'2021-04-03 09:02:05'),(639268,'5','131',308,'Sale Id shift 188566',0.00,1986251.17,163.00,1986251.17,0.00,'2021-04-03 18:17:40'),(639802,'5','131',308,'Sale Id shift 188568',0.00,1624109.18,163.00,1624109.18,0.00,'2021-04-04 08:40:04'),(639803,'5','131',309,'Sale Id shift 188568',0.00,0.00,265.00,55247.20,55247.20,'2021-04-04 08:40:04'),(645327,'5','131',308,'Sale Id shift 188645',0.00,1127226.50,163.00,1127226.50,0.00,'2021-04-05 14:29:00'),(645328,'5','131',309,'Sale Id shift 188645',0.00,29012.20,265.00,29012.20,0.00,'2021-04-05 14:29:00'),(646459,'5','131',308,'Sale Id shift 188942',0.00,1733139.88,163.00,1733139.88,0.00,'2021-04-06 04:53:10'),(646460,'5','131',309,'Sale Id shift 188942',0.00,45807.90,265.00,45807.90,0.00,'2021-04-06 04:53:10'),(649422,'5','131',308,'Sale Id shift 189159',0.00,2227536.81,163.00,2227536.81,0.00,'2021-04-06 20:09:42'),(649423,'5','131',309,'Sale Id shift 189159',0.00,69329.30,265.00,69329.30,0.00,'2021-04-06 20:09:42'),(653065,'5','131',308,'Sale Id shift 189252',0.00,1861882.17,163.00,1861882.17,0.00,'2021-04-07 21:43:22'),(653066,'5','131',309,'Sale Id shift 189252',0.00,148055.50,265.00,148055.50,0.00,'2021-04-07 21:43:22'),(656238,'5','131',308,'Sale Id shift 189524',0.00,20709.15,163.00,20709.15,0.00,'2021-04-08 19:53:41'),(656239,'5','131',309,'Sale Id shift 189524',0.00,96926.40,265.00,96926.40,0.00,'2021-04-08 19:53:41'),(659798,'5','131',309,'Sale Id shift 189689',0.00,73948.25,265.00,73948.25,0.00,'2021-04-10 04:44:20'),(664172,'5','131',309,'Sale Id shift 189970',0.00,79391.35,265.00,79391.35,0.00,'2021-04-11 07:59:26'),(668437,'5','131',309,'Sale Id shift 190108',0.00,44949.30,265.00,44949.30,0.00,'2021-04-12 08:36:30'),(672113,'5','131',309,'Sale Id shift 190252',0.00,99515.45,265.00,99515.45,0.00,'2021-04-12 18:55:11'),(677978,'5','131',309,'Sale Id shift 190486',0.00,50233.40,265.00,50233.40,0.00,'2021-04-14 08:45:53'),(681411,'5','131',309,'Sale Id shift 190756',0.00,151688.65,265.00,151688.65,0.00,'2021-04-15 07:28:15'),(686292,'5','131',309,'Sale Id shift 190942',0.00,105994.70,265.00,105994.70,0.00,'2021-04-16 12:02:06'),(688469,'5','131',309,'Sale Id shift 191195',0.00,54900.05,265.00,54900.05,0.00,'2021-04-17 09:04:04'),(692945,'5','131',309,'Sale Id shift 191457',0.00,35401.35,265.00,35401.35,0.00,'2021-04-18 12:56:45'),(694490,'5','131',309,'Sale Id shift 191608',0.00,57955.50,265.00,57955.50,0.00,'2021-04-18 18:19:43'),(698722,'5','131',309,'Sale Id shift 191905',0.00,110534.15,265.00,110534.15,0.00,'2021-04-20 08:41:44'),(701105,'5','131',309,'Sale Id shift 191984',0.00,100631.10,265.00,100631.10,0.00,'2021-04-21 07:28:35'),(703389,'5','131',309,'Sale Id shift 192189',0.00,160219.00,265.00,160219.00,0.00,'2021-04-21 20:33:04'),(707543,'5','131',308,'Sale Id shift 192338',0.00,1083179.01,165.00,1096469.55,13290.54,'2021-04-23 10:28:08'),(707544,'5','131',309,'Sale Id shift 192338',0.00,188327.55,265.00,188327.55,0.00,'2021-04-23 10:28:08'),(716427,'5','131',308,'Sale Id shift 192725',0.00,1438783.07,165.00,1456436.85,17653.78,'2021-04-26 07:57:28'),(716428,'5','131',309,'Sale Id shift 192725',0.00,84898.05,265.00,84898.05,0.00,'2021-04-26 07:57:28'),(722486,'5','131',308,'Sale Id shift 193502',0.00,1057889.56,165.00,1070869.80,12980.24,'2021-04-28 08:46:12'),(722487,'5','131',309,'Sale Id shift 193502',0.00,133787.90,265.00,133787.90,0.00,'2021-04-28 08:46:12'),(726422,'5','131',308,'Sale Id shift 193988',0.00,985766.95,165.00,997862.25,12095.30,'2021-04-29 13:22:33'),(726423,'5','131',309,'Sale Id shift 193988',0.00,62494.95,265.00,62494.95,0.00,'2021-04-29 13:22:33'),(749576,'5','131',308,'Sale Id shift 194132',0.00,776861.26,165.00,786393.30,9532.04,'2021-05-07 09:23:39'),(749577,'5','131',309,'Sale Id shift 194132',0.00,123063.35,265.00,123063.35,0.00,'2021-05-07 09:23:39'),(749603,'5','131',308,'Sale Id shift 195587',0.00,948576.75,165.00,948576.75,0.00,'2021-05-07 09:29:09'),(749604,'5','131',309,'Sale Id shift 195587',0.00,109108.45,265.00,109108.45,0.00,'2021-05-07 09:29:09'),(749640,'5','131',308,'Sale Id shift 195590',0.00,171202.35,165.00,171202.35,0.00,'2021-05-07 09:37:41'),(749641,'5','131',309,'Sale Id shift 195590',0.00,80480.50,265.00,80480.50,0.00,'2021-05-07 09:37:41'),(749663,'5','131',309,'Sale Id shift 195593',0.00,106689.00,265.00,106689.00,0.00,'2021-05-07 09:40:21'),(749685,'5','131',309,'Sale Id shift 195596',0.00,87455.30,265.00,87455.30,0.00,'2021-05-07 09:45:18'),(749712,'5','131',309,'Sale Id shift 195599',0.00,121136.80,265.00,121136.80,0.00,'2021-05-07 09:50:21'),(749730,'5','131',308,'Sale Id shift 195600',0.00,318799.80,165.00,318799.80,0.00,'2021-05-07 09:55:12'),(749731,'5','131',309,'Sale Id shift 195600',0.00,100249.50,265.00,100249.50,0.00,'2021-05-07 09:55:12'),(749785,'5','131',308,'Sale Id shift 195602',0.00,648354.30,165.00,648354.30,0.00,'2021-05-07 10:04:52'),(749786,'5','131',309,'Sale Id shift 195602',0.00,98129.50,265.00,98129.50,0.00,'2021-05-07 10:04:52'),(749813,'5','131',308,'Sale Id shift 195605',0.00,716758.35,165.00,716758.35,0.00,'2021-05-07 10:09:46'),(749814,'5','131',309,'Sale Id shift 195605',0.00,51910.85,265.00,51910.85,0.00,'2021-05-07 10:09:46'),(749859,'5','131',308,'Sale Id shift 195609',0.00,823373.10,165.00,823373.10,0.00,'2021-05-07 10:16:06'),(749860,'5','131',309,'Sale Id shift 195609',0.00,74995.00,265.00,74995.00,0.00,'2021-05-07 10:16:06'),(749942,'5','131',308,'Sale Id shift 195610',0.00,709277.25,165.00,709277.25,0.00,'2021-05-07 10:29:21'),(749943,'5','131',309,'Sale Id shift 195610',0.00,110438.75,265.00,110438.75,0.00,'2021-05-07 10:29:21'),(752141,'5','131',308,'Sale Id shift 195666',0.00,660338.25,165.00,660338.25,0.00,'2021-05-08 04:52:11'),(752142,'5','131',309,'Sale Id shift 195666',0.00,73749.50,265.00,73749.50,0.00,'2021-05-08 04:52:11'),(755896,'5','131',308,'Sale Id shift 195936',0.00,424419.60,165.00,424419.60,0.00,'2021-05-09 06:37:55'),(755897,'5','131',309,'Sale Id shift 195936',0.00,92331.30,265.00,92331.30,0.00,'2021-05-09 06:37:55'),(763238,'5','131',308,'Sale Id shift 196049',0.00,742280.55,165.00,742280.55,0.00,'2021-05-11 08:23:36'),(763239,'5','131',309,'Sale Id shift 196049',0.00,58490.80,265.00,58490.80,0.00,'2021-05-11 08:23:36'),(766032,'5','131',308,'Sale Id shift 196533',0.00,737863.50,165.00,737863.50,0.00,'2021-05-11 18:35:22'),(766033,'5','131',309,'Sale Id shift 196533',0.00,62161.05,265.00,62161.05,0.00,'2021-05-11 18:35:22'),(768411,'5','131',308,'Sale Id shift 196738',0.00,584774.85,165.00,584774.85,0.00,'2021-05-12 13:58:02'),(768412,'5','131',309,'Sale Id shift 196738',0.00,58294.70,265.00,58294.70,0.00,'2021-05-12 13:58:02'),(771146,'5','131',308,'Sale Id shift 196834',0.00,358097.85,165.00,358097.85,0.00,'2021-05-14 05:07:29'),(771147,'5','131',309,'Sale Id shift 196834',0.00,67810.85,265.00,67810.85,0.00,'2021-05-14 05:07:29'),(773903,'5','131',308,'Sale Id shift 197048',0.00,225863.55,165.00,225863.55,0.00,'2021-05-16 08:44:59'),(773904,'5','131',309,'Sale Id shift 197048',0.00,77149.45,265.00,77149.45,0.00,'2021-05-16 08:44:59'),(776011,'5','131',308,'Sale Id shift 197432',0.00,782170.95,165.00,782170.95,0.00,'2021-05-17 12:11:32'),(776012,'5','131',309,'Sale Id shift 197432',0.00,44244.40,265.00,44244.40,0.00,'2021-05-17 12:11:32'),(777332,'5','131',308,'Sale Id shift 197713',0.00,1142913.75,165.00,1142913.75,0.00,'2021-05-18 06:03:29'),(777333,'5','131',309,'Sale Id shift 197713',0.00,5824.70,265.00,5824.70,0.00,'2021-05-18 06:03:29'),(783126,'5','131',308,'Sale Id shift 198305',0.00,234369.30,165.00,234369.30,0.00,'2021-05-19 17:13:00'),(783127,'5','131',309,'Sale Id shift 198305',0.00,5448.40,270.00,5551.20,102.80,'2021-05-19 17:13:00'),(783797,'5','131',308,'Sale Id shift 198308',0.00,521132.70,165.00,521132.70,0.00,'2021-05-20 08:28:38'),(783798,'5','131',309,'Sale Id shift 198308',0.00,67959.25,270.00,69241.50,1282.25,'2021-05-20 08:28:38'),(788885,'5','131',308,'Sale Id shift 198511',0.00,692277.30,165.00,692277.30,0.00,'2021-05-21 15:29:33'),(788886,'5','131',309,'Sale Id shift 198511',0.00,185926.65,270.00,189434.70,3508.05,'2021-05-21 15:29:33'),(797136,'5','131',308,'Sale Id shift 198760',0.00,612607.05,165.00,612607.05,0.00,'2021-05-23 19:36:44'),(797137,'5','131',309,'Sale Id shift 198760',0.00,124507.60,0.00,0.00,-124507.60,'2021-05-23 19:36:44'),(797713,'5','131',308,'Sale Id shift 199269',0.00,436634.55,165.00,436634.55,0.00,'2021-05-24 08:39:19'),(797714,'5','131',309,'Sale Id shift 199269',0.00,128020.50,270.00,128020.50,0.00,'2021-05-24 08:39:19'),(797744,'5','131',308,'Sale Id shift 199282',0.00,642562.80,165.00,642562.80,0.00,'2021-05-24 08:46:57'),(797745,'5','131',309,'Sale Id shift 199282',0.00,141739.20,270.00,141739.20,0.00,'2021-05-24 08:46:57'),(801939,'5','131',308,'Sale Id shift 199285',0.00,798311.25,165.00,798311.25,0.00,'2021-05-25 12:35:23'),(801940,'5','131',309,'Sale Id shift 199285',0.00,146345.40,270.00,146345.40,0.00,'2021-05-25 12:35:23'),(803688,'5','131',308,'Sale Id shift 199553',0.00,801634.35,165.00,801634.35,0.00,'2021-05-26 04:47:16'),(803689,'5','131',309,'Sale Id shift 199553',0.00,103299.30,270.00,103299.30,0.00,'2021-05-26 04:47:16'),(807047,'5','131',308,'Sale Id shift 199758',0.00,747864.15,165.00,747864.15,0.00,'2021-05-27 04:26:25'),(807048,'5','131',309,'Sale Id shift 199758',0.00,194867.10,270.00,194867.10,0.00,'2021-05-27 04:26:25'),(810296,'5','131',308,'Sale Id shift 199903',0.00,521601.30,165.00,521601.30,0.00,'2021-05-28 05:51:37'),(810297,'5','131',309,'Sale Id shift 199903',0.00,53524.80,270.00,53524.80,0.00,'2021-05-28 05:51:37'),(813838,'5','131',308,'Sale Id shift 200098',0.00,991456.95,165.00,991456.95,0.00,'2021-05-29 08:41:59'),(813839,'5','131',309,'Sale Id shift 200098',0.00,52164.00,270.00,52164.00,0.00,'2021-05-29 08:41:59'),(821319,'5','131',308,'Sale Id shift 200344',0.00,995826.15,165.00,995826.15,0.00,'2021-05-31 08:27:35'),(821320,'5','131',309,'Sale Id shift 200344',0.00,67926.60,270.00,67926.60,0.00,'2021-05-31 08:27:35'),(822587,'5','131',308,'Sale Id shift 200745',0.00,927422.10,165.00,927422.10,0.00,'2021-05-31 13:23:59'),(822588,'5','131',309,'Sale Id shift 200745',0.00,60145.20,270.00,60145.20,0.00,'2021-05-31 13:23:59'),(824067,'5','131',308,'Sale Id shift 200841',0.00,869356.95,165.00,869356.95,0.00,'2021-06-01 04:37:27'),(824068,'5','131',309,'Sale Id shift 200841',0.00,126846.00,270.00,126846.00,0.00,'2021-06-01 04:37:27'),(828467,'5','131',308,'Sale Id shift 200915',0.00,793450.35,165.00,793450.35,0.00,'2021-06-02 06:08:11'),(828468,'5','131',309,'Sale Id shift 200915',0.00,93879.00,270.00,93879.00,0.00,'2021-06-02 06:08:11'),(832611,'5','131',308,'Sale Id shift 201193',0.00,896144.70,165.00,896144.70,0.00,'2021-06-03 05:10:01'),(832612,'5','131',309,'Sale Id shift 201193',0.00,170407.80,270.00,170407.80,0.00,'2021-06-03 05:10:01'),(837103,'5','131',308,'Sale Id shift 201316',0.00,769046.85,165.00,769046.85,0.00,'2021-06-04 09:01:33'),(837104,'5','131',309,'Sale Id shift 201316',0.00,73407.60,270.00,73407.60,0.00,'2021-06-04 09:01:33'),(840286,'5','131',308,'Sale Id shift 201713',0.00,791726.10,165.00,791726.10,0.00,'2021-06-05 07:46:23'),(840287,'5','131',309,'Sale Id shift 201713',0.00,111399.30,270.00,111399.30,0.00,'2021-06-05 07:46:23'),(844313,'5','131',308,'Sale Id shift 202009',0.00,875277.15,165.00,875277.15,0.00,'2021-06-06 06:35:39'),(844314,'5','131',309,'Sale Id shift 202009',0.00,47514.50,275.00,47514.50,0.00,'2021-06-06 06:35:39'),(847930,'5','131',308,'Sale Id shift 202041',0.00,749850.75,165.00,749850.75,0.00,'2021-06-06 21:45:08'),(847931,'5','131',309,'Sale Id shift 202041',0.00,108460.00,275.00,108460.00,0.00,'2021-06-06 21:45:08'),(852029,'5','131',308,'Sale Id shift 202407',0.00,752116.20,165.00,752116.20,0.00,'2021-06-08 05:04:50'),(852030,'5','131',309,'Sale Id shift 202407',0.00,90992.00,275.00,90992.00,0.00,'2021-06-08 05:04:50'),(855658,'5','131',308,'Sale Id shift 202420',0.00,819152.40,165.00,819152.40,0.00,'2021-06-08 21:37:07'),(855659,'5','131',309,'Sale Id shift 202420',0.00,115395.50,275.00,115395.50,0.00,'2021-06-08 21:37:07'),(859595,'5','131',308,'Sale Id shift 202643',0.00,811286.85,165.00,811286.85,0.00,'2021-06-10 04:49:50'),(859596,'5','131',309,'Sale Id shift 202643',0.00,108691.00,275.00,108691.00,0.00,'2021-06-10 04:49:50'),(864020,'5','131',308,'Sale Id shift 202880',0.00,602848.95,165.00,602848.95,0.00,'2021-06-11 08:15:33'),(864021,'5','131',309,'Sale Id shift 202880',0.00,100611.50,275.00,100611.50,0.00,'2021-06-11 08:15:33'),(867214,'5','131',308,'Sale Id shift 203188',0.00,858118.80,165.00,858118.80,0.00,'2021-06-12 02:33:46'),(867215,'5','131',309,'Sale Id shift 203188',0.00,91693.25,275.00,91693.25,0.00,'2021-06-12 02:33:46'),(870637,'5','131',308,'Sale Id shift 203293',0.00,813113.40,165.00,813113.40,0.00,'2021-06-12 23:44:03'),(870638,'5','131',309,'Sale Id shift 203293',0.00,103072.75,275.00,103072.75,0.00,'2021-06-12 23:44:03'),(874864,'5','131',308,'Sale Id shift 203513',0.00,704447.70,165.00,704447.70,0.00,'2021-06-13 22:01:06'),(874865,'5','131',309,'Sale Id shift 203513',0.00,169171.75,275.00,169171.75,0.00,'2021-06-13 22:01:06'),(878659,'5','131',308,'Sale Id shift 203714',0.00,775828.35,165.00,775828.35,0.00,'2021-06-15 04:27:45'),(878660,'5','131',309,'Sale Id shift 203714',0.00,149567.00,275.00,149567.00,0.00,'2021-06-15 04:27:45'),(881803,'5','131',308,'Sale Id shift 203992',0.00,682634.70,165.00,682634.70,0.00,'2021-06-16 04:47:14'),(881804,'5','131',309,'Sale Id shift 203992',0.00,60285.50,275.00,60285.50,0.00,'2021-06-16 04:47:14'),(885721,'5','131',308,'Sale Id shift 204180',0.00,720396.60,165.00,720396.60,0.00,'2021-06-17 06:18:25'),(885722,'5','131',309,'Sale Id shift 204180',0.00,130564.50,275.00,130564.50,0.00,'2021-06-17 06:18:25'),(889427,'5','131',308,'Sale Id shift 204431',0.00,741805.35,165.00,741805.35,0.00,'2021-06-17 22:21:58'),(889428,'5','131',309,'Sale Id shift 204431',0.00,88690.25,275.00,88690.25,0.00,'2021-06-17 22:21:58'),(893070,'5','131',308,'Sale Id shift 204601',0.00,785393.40,165.00,785393.40,0.00,'2021-06-18 22:45:25'),(893071,'5','131',309,'Sale Id shift 204601',0.00,116212.25,275.00,116212.25,0.00,'2021-06-18 22:45:25'),(896672,'5','131',308,'Sale Id shift 204853',0.00,648194.25,165.00,648194.25,0.00,'2021-06-19 18:20:50'),(900554,'5','131',308,'Sale Id shift 205088',0.00,666583.50,165.00,666583.50,0.00,'2021-06-21 07:21:32'),(904077,'5','131',308,'Sale Id shift 205290',0.00,799822.65,165.00,799822.65,0.00,'2021-06-22 08:44:37'),(907971,'5','131',308,'Sale Id shift 205532',0.00,621431.25,165.00,621431.25,0.00,'2021-06-23 11:14:40'),(910146,'5','131',308,'Sale Id shift 205879',0.00,773378.10,165.00,773378.10,0.00,'2021-06-24 05:38:28'),(914405,'5','131',308,'Sale Id shift 205942',0.00,800197.20,165.00,800197.20,0.00,'2021-06-25 09:10:16'),(917038,'5','131',308,'Sale Id shift 206207',0.00,937996.95,165.00,937996.95,0.00,'2021-06-26 06:20:25'),(921702,'5','131',308,'Sale Id shift 206596',0.00,1049050.20,165.00,1049050.20,0.00,'2021-06-27 10:26:03'),(924326,'5','131',308,'Sale Id shift 206646',0.00,748799.70,165.00,748799.70,0.00,'2021-06-27 22:33:13'),(928801,'5','131',308,'Sale Id shift 206781',0.00,718563.45,165.00,718563.45,0.00,'2021-06-29 08:31:37'),(931996,'5','131',308,'Sale Id shift 207102',0.00,258861.90,165.00,258861.90,0.00,'2021-06-30 04:39:35'),(940361,'5','131',308,'Sale Id shift 207666',0.00,344978.70,165.00,344978.70,0.00,'2021-07-01 18:59:46'),(943981,'5','131',308,'Sale Id shift 207713',0.00,730347.75,165.00,730347.75,0.00,'2021-07-03 04:29:13'),(951911,'5','131',308,'Sale Id shift 208224',0.00,780709.05,165.00,780709.05,0.00,'2021-07-04 16:54:40'),(952360,'5','131',308,'Sale Id shift 208300',0.00,660513.15,165.00,660513.15,0.00,'2021-07-05 06:42:06'),(956349,'5','131',308,'Sale Id shift 208451',0.00,784327.50,165.00,784327.50,0.00,'2021-07-05 20:59:19'),(960917,'5','131',308,'Sale Id shift 208664',0.00,711862.80,165.00,711862.80,0.00,'2021-07-07 08:04:38'),(964464,'5','131',308,'Sale Id shift 208876',0.00,694514.70,165.00,694514.70,0.00,'2021-07-08 05:21:12'),(969169,'5','131',308,'Sale Id shift 209084',0.00,502660.95,165.00,502660.95,0.00,'2021-07-09 09:08:52'),(972272,'5','131',308,'Sale Id shift 209399',0.00,669852.15,165.00,669852.15,0.00,'2021-07-10 05:22:03'),(976924,'5','131',308,'Sale Id shift 209621',0.00,884657.40,165.00,884657.40,0.00,'2021-07-11 05:38:51'),(981020,'5','131',308,'Sale Id shift 209844',0.00,877062.45,165.00,877062.45,0.00,'2021-07-12 05:15:11'),(984253,'5','131',308,'Sale Id shift 210080',0.00,716621.35,163.00,716621.35,0.00,'2021-07-13 04:28:41'),(987981,'5','131',308,'Sale Id shift 210261',0.00,701959.50,163.00,701959.50,0.00,'2021-07-14 04:32:54'),(991701,'5','131',308,'Sale Id shift 210386',0.00,726253.02,163.00,726253.02,0.00,'2021-07-15 07:56:46'),(994504,'5','131',308,'Sale Id shift 210626',0.00,660688.05,163.00,652679.71,-8008.34,'2021-07-15 19:55:38'),(998042,'5','131',308,'Sale Id shift 210849',0.00,641371.50,163.00,633597.30,-7774.20,'2021-07-17 05:57:40'),(1002450,'5','131',308,'Sale Id shift 210945',0.00,556132.50,163.00,549391.50,-6741.00,'2021-07-17 22:25:51'),(1006924,'5','131',308,'Sale Id shift 211344',0.00,806421.00,163.00,796646.20,-9774.80,'2021-07-19 08:35:19'),(1010229,'5','131',308,'Sale Id shift 211445',0.00,1023363.00,163.00,1010958.60,-12404.40,'2021-07-19 22:07:40'),(1012576,'5','131',308,'Sale Id shift 211744',0.00,442186.80,163.00,436826.96,-5359.84,'2021-07-21 05:37:08'),(1016607,'5','131',308,'Sale Id shift 211791',0.00,700832.55,163.00,692337.61,-8494.94,'2021-07-22 08:53:30'),(1019017,'5','131',308,'Sale Id shift 212172',0.00,671536.80,163.00,663396.96,-8139.84,'2021-07-22 22:11:43'),(1022363,'5','131',308,'Sale Id shift 212435',0.00,570801.00,163.00,563882.20,-6918.80,'2021-07-24 06:31:59'),(1025900,'5','131',308,'Sale Id shift 212472',0.00,272144.40,163.00,268845.68,-3298.72,'2021-07-25 06:26:52'),(1028939,'5','131',308,'Sale Id shift 212750',0.00,625696.50,163.00,618112.30,-7584.20,'2021-07-26 04:54:07'),(1032112,'5','131',308,'Sale Id shift 212866',0.00,425665.35,163.00,420505.77,-5159.58,'2021-07-27 05:11:55'),(1036009,'5','131',308,'Sale Id shift 213199',0.00,633159.45,163.00,625484.79,-7674.66,'2021-07-27 22:13:06'),(1039335,'5','131',308,'Sale Id shift 213520',0.00,599235.45,163.00,591971.99,-7263.46,'2021-07-29 04:44:54'),(1050601,'5','131',308,'Sale Id shift 213751',0.00,846207.45,163.00,835950.39,-10257.06,'2021-07-31 15:40:12'),(1050633,'5','131',308,'Sale Id shift 214255',0.00,753976.06,163.00,753976.06,0.00,'2021-07-31 15:44:33'),(1051455,'5','131',308,'Sale Id shift 214257',0.00,918560.42,163.00,918560.42,0.00,'2021-08-01 06:26:53'),(1055136,'5','131',308,'Sale Id shift 214348',0.00,699152.64,163.00,699152.64,0.00,'2021-08-02 06:16:13'),(1059966,'5','131',308,'Sale Id shift 214598',0.00,717040.26,163.00,717040.26,0.00,'2021-08-03 08:16:22'),(1063720,'5','131',308,'Sale Id shift 214822',0.00,670006.61,163.00,670006.61,0.00,'2021-08-03 20:49:40'),(1067364,'5','131',308,'Sale Id shift 215111',0.00,633967.31,163.00,633967.31,0.00,'2021-08-05 05:45:04'),(1070552,'5','131',308,'Sale Id shift 215372',0.00,678094.67,163.00,678094.67,0.00,'2021-08-06 00:11:40'),(1074745,'5','131',308,'Sale Id shift 215608',0.00,567202.51,163.00,567202.51,0.00,'2021-08-07 04:58:07'),(1078858,'5','131',308,'Sale Id shift 215710',0.00,449457.83,163.00,449457.83,0.00,'2021-08-08 06:20:46'),(1086661,'5','131',308,'Sale Id shift 215945',0.00,340451.58,163.00,340451.58,0.00,'2021-08-10 05:42:23'),(1090436,'5','131',308,'Sale Id shift 216313',0.00,783816.47,163.00,783816.47,0.00,'2021-08-11 05:31:28'),(1093617,'5','131',308,'Sale Id shift 216544',0.00,655199.69,163.00,655199.69,0.00,'2021-08-12 05:15:57'),(1097086,'5','131',308,'Sale Id shift 216777',0.00,618588.26,163.00,618588.26,0.00,'2021-08-13 06:33:57'),(1098401,'5','131',308,'Sale Id shift 217047',0.00,29579.61,163.00,29579.61,0.00,'2021-08-13 10:47:26'),(1101338,'5','131',308,'Sale Id shift 217127',0.00,787743.14,163.00,787743.14,0.00,'2021-08-14 06:51:19'),(1109646,'5','131',308,'Sale Id shift 217301',0.00,909269.42,163.00,909269.42,0.00,'2021-08-15 18:18:28'),(1109762,'5','131',308,'Sale Id shift 217666',0.00,754605.24,163.00,754605.24,0.00,'2021-08-15 21:02:58'),(1113628,'5','131',308,'Sale Id shift 217727',0.00,750905.14,163.00,750905.14,0.00,'2021-08-16 22:43:35'),(1117549,'5','131',308,'Sale Id shift 218020',0.00,640277.04,163.00,640277.04,0.00,'2021-08-18 05:50:52'),(1121037,'5','131',308,'Sale Id shift 218317',0.00,683602.44,163.00,683602.44,0.00,'2021-08-19 04:36:27'),(1125179,'5','131',308,'Sale Id shift 218467',0.00,791845.85,163.00,791845.85,0.00,'2021-08-20 05:21:11'),(1128858,'5','131',308,'Sale Id shift 218686',0.00,793779.03,163.00,793779.03,0.00,'2021-08-21 05:09:36'),(1133113,'5','131',308,'Sale Id shift 218910',0.00,598984.25,163.00,598984.25,0.00,'2021-08-21 19:18:08'),(1137345,'5','131',308,'Sale Id shift 219114',0.00,1149073.39,163.00,1149073.39,0.00,'2021-08-23 06:24:55'),(1141228,'5','131',308,'Sale Id shift 219380',0.00,643783.17,163.00,643783.17,0.00,'2021-08-23 22:30:43'),(1145056,'5','131',308,'Sale Id shift 219657',0.00,752293.90,163.00,752293.90,0.00,'2021-08-25 06:11:24'),(1148793,'5','131',308,'Sale Id shift 219809',0.00,777863.71,163.00,777863.71,0.00,'2021-08-25 21:30:08'),(1152640,'5','131',308,'Sale Id shift 220044',0.00,892765.67,163.00,892765.67,0.00,'2021-08-27 06:56:36'),(1155997,'5','131',308,'Sale Id shift 220263',0.00,907649.20,163.00,907649.20,0.00,'2021-08-28 06:34:42'),(1159802,'5','131',308,'Sale Id shift 220499',0.00,816700.09,163.00,816700.09,0.00,'2021-08-29 06:55:41'),(1164016,'5','131',308,'Sale Id shift 220701',0.00,631724.43,163.00,631724.43,0.00,'2021-08-30 04:41:24'),(1168113,'5','131',308,'Sale Id shift 220932',0.00,679315.54,163.00,679315.54,0.00,'2021-08-30 21:05:14'),(1172050,'5','131',308,'Sale Id shift 221146',0.00,853094.73,163.00,853094.73,0.00,'2021-09-01 04:57:34'),(1175917,'5','131',308,'Sale Id shift 221442',0.00,870604.19,163.00,870604.19,0.00,'2021-09-02 06:26:29'),(1180987,'5','131',308,'Sale Id shift 221652',0.00,943518.98,163.00,943518.98,0.00,'2021-09-03 09:11:08'),(1185181,'5','131',308,'Sale Id shift 221923',0.00,932875.08,163.00,932875.08,0.00,'2021-09-04 08:54:11'),(1188319,'5','131',308,'Sale Id shift 222183',0.00,877236.66,163.00,877236.66,0.00,'2021-09-05 05:40:20'),(1192142,'5','131',308,'Sale Id shift 222321',0.00,1046561.06,163.00,1046561.06,0.00,'2021-09-06 04:06:50'),(1195213,'5','131',308,'Sale Id shift 222629',0.00,492592.52,163.00,492592.52,0.00,'2021-09-07 06:35:12'),(1197345,'5','131',308,'Sale Id shift 222798',0.00,619706.44,163.00,619706.44,0.00,'2021-09-08 12:14:04'),(1223420,'5','131',308,'Sale Id shift 224644',0.00,914258.85,163.00,914258.85,0.00,'2021-09-16 05:41:36'),(1229000,'5','131',308,'Sale Id shift 224860',0.00,805229.78,163.00,805229.78,0.00,'2021-09-17 11:56:55'),(1230400,'5','131',308,'Sale Id shift 225217',0.00,631528.83,163.00,631528.83,0.00,'2021-09-17 21:49:34'),(1234331,'5','131',308,'Sale Id shift 225257',0.00,526760.58,163.00,526760.58,0.00,'2021-09-19 08:43:43'),(1237311,'5','131',308,'Sale Id shift 225537',0.00,679907.23,163.00,679907.23,0.00,'2021-09-20 07:25:26'),(1240226,'5','131',308,'Sale Id shift 225843',0.00,619753.71,163.00,619753.71,0.00,'2021-09-21 06:31:00'),(1243485,'5','131',308,'Sale Id shift 226083',0.00,665512.70,163.00,665512.70,0.00,'2021-09-21 21:40:10'),(1246166,'5','131',308,'Sale Id shift 226323',0.00,616319.30,163.00,616319.30,0.00,'2021-09-23 05:09:53'),(1249609,'5','131',308,'Sale Id shift 226535',0.00,792434.28,163.00,792434.28,0.00,'2021-09-23 20:38:14'),(1253185,'5','131',308,'Sale Id shift 226751',0.00,695141.21,163.00,695141.21,0.00,'2021-09-25 05:22:50'),(1256625,'5','131',308,'Sale Id shift 226988',0.00,627895.56,163.00,627895.56,0.00,'2021-09-26 04:37:18'),(1259808,'5','131',308,'Sale Id shift 227193',0.00,518718.16,163.00,518718.16,0.00,'2021-09-27 06:42:13'),(1262890,'5','131',308,'Sale Id shift 227388',0.00,811001.61,163.00,811001.61,0.00,'2021-09-28 06:18:26'),(1265700,'5','131',308,'Sale Id shift 227617',0.00,548569.98,163.00,548569.98,0.00,'2021-09-29 05:41:34'),(1307962,'5','131',308,'Sale Id shift 230680',0.00,568964.54,163.00,568964.54,0.00,'2021-10-11 15:08:47'),(1308772,'5','131',308,'Sale Id shift 230710',0.00,530199.88,163.00,530199.88,0.00,'2021-10-11 18:15:00'),(1308988,'5','131',308,'Sale Id shift 230763',0.00,609481.45,163.00,609481.45,0.00,'2021-10-12 06:26:31'),(1309894,'5','131',308,'Sale Id shift 230821',0.00,470879.29,163.00,470879.29,0.00,'2021-10-12 10:04:12'),(1310603,'5','131',308,'Sale Id shift 230933',0.00,310638.88,163.00,310638.88,0.00,'2021-10-12 13:18:37'),(1312292,'5','131',308,'Sale Id shift 231096',0.00,916824.47,163.00,916824.47,0.00,'2021-10-13 08:32:49'),(1314701,'5','131',308,'Sale Id shift 231119',0.00,793433.47,163.00,793433.47,0.00,'2021-10-14 05:14:33'),(1318569,'5','131',308,'Sale Id shift 231363',0.00,860853.53,163.00,860853.53,0.00,'2021-10-15 09:26:15'),(1323677,'5','131',308,'Sale Id shift 231709',0.00,922223.03,163.00,922223.03,0.00,'2021-10-16 16:32:51'),(1326457,'5','131',308,'Sale Id shift 232070',0.00,797037.40,163.00,797037.40,0.00,'2021-10-17 15:14:51'),(1327716,'5','131',308,'Sale Id shift 232263',0.00,591649.25,163.00,591649.25,0.00,'2021-10-18 08:25:12'),(1330813,'5','131',308,'Sale Id shift 232392',0.00,675115.03,163.00,675115.03,0.00,'2021-10-19 05:06:01'),(1334595,'5','131',308,'Sale Id shift 232669',0.00,694552.78,163.00,694552.78,0.00,'2021-10-20 08:24:20'),(1337536,'5','131',308,'Sale Id shift 232911',0.00,627703.22,163.00,627703.22,0.00,'2021-10-21 06:39:05'),(1341710,'5','131',308,'Sale Id shift 233127',0.00,415627.18,163.00,415627.18,0.00,'2021-10-22 08:48:36'),(1344278,'5','131',308,'Sale Id shift 233432',0.00,942951.74,163.00,942951.74,0.00,'2021-10-23 04:04:48'),(1348271,'5','131',308,'Sale Id shift 233688',0.00,890915.62,163.00,890915.62,0.00,'2021-10-24 06:48:21'),(1353315,'5','131',308,'Sale Id shift 233994',0.00,874552.05,163.00,874552.05,0.00,'2021-10-25 13:14:54'),(1357445,'5','131',308,'Sale Id shift 234480',0.00,809979.60,163.00,809979.60,0.00,'2021-10-26 15:29:16'),(1358154,'5','131',308,'Sale Id shift 234512',0.00,71154.39,165.00,72027.45,873.06,'2021-10-27 06:13:46'),(1375546,'5','131',308,'Sale Id shift 235673',0.00,1526961.15,165.00,1526961.15,0.00,'2021-11-01 11:30:07'),(1379099,'5','131',308,'Sale Id shift 235928',0.00,1284496.95,165.00,1284496.95,0.00,'2021-11-03 05:00:11'),(1382663,'5','131',308,'Sale Id shift 236352',0.00,1293408.60,165.00,1293408.60,0.00,'2021-11-03 17:52:30'),(1387488,'5','131',308,'Sale Id shift 236461',0.00,853924.50,165.00,853924.50,0.00,'2021-11-04 18:06:46'),(1425911,'5','131',308,'Sale Id shift 238232',0.00,110518.65,165.00,110518.65,0.00,'2021-11-13 05:53:23'),(1431616,'5','131',308,'Sale Id shift 238611',0.00,929684.25,165.00,929684.25,0.00,'2021-11-14 09:02:14'),(1435601,'5','131',308,'Sale Id shift 238903',0.00,930585.15,165.00,930585.15,0.00,'2021-11-15 07:24:03'),(1440054,'5','131',308,'Sale Id shift 239113',0.00,338987.55,165.00,338987.55,0.00,'2021-11-16 08:08:06'),(1443101,'5','131',308,'Sale Id shift 239356',0.00,65917.50,165.00,65917.50,0.00,'2021-11-17 05:38:50'),(1456124,'5','131',308,'Sale Id shift 239979',0.00,469566.90,165.00,469566.90,0.00,'2021-11-20 06:37:43'),(1460872,'5','131',308,'Sale Id shift 240222',0.00,1174809.90,165.00,1174809.90,0.00,'2021-11-20 20:42:37'),(1465778,'5','131',308,'Sale Id shift 240446',0.00,504584.85,165.00,504584.85,0.00,'2021-11-22 06:20:00'),(1470473,'5','131',308,'Sale Id shift 240709',0.00,53662.95,165.00,53662.95,0.00,'2021-11-23 05:37:13'),(1475450,'5','131',308,'Sale Id shift 240968',0.00,1287107.25,165.00,1287107.25,0.00,'2021-11-24 07:04:35'),(1479085,'5','131',308,'Sale Id shift 241297',0.00,1517828.40,165.00,1517828.40,0.00,'2021-11-25 05:53:04'),(1483408,'5','131',308,'Sale Id shift 241492',0.00,1686476.55,165.00,1686476.55,0.00,'2021-11-26 05:57:39'),(1487855,'5','131',308,'Sale Id shift 241740',0.00,1312637.70,165.00,1312637.70,0.00,'2021-11-27 06:12:02'),(1493044,'5','131',308,'Sale Id shift 242022',0.00,1240900.65,165.00,1240900.65,0.00,'2021-11-28 07:30:51'),(1497385,'5','131',308,'Sale Id shift 242239',0.00,285331.20,165.00,285331.20,0.00,'2021-11-29 04:58:03'),(1517028,'5','131',308,'Sale Id shift 243162',0.00,1022749.20,165.00,1022749.20,0.00,'2021-12-03 05:33:59'),(1527283,'5','131',308,'Sale Id shift 243423',0.00,1561797.60,165.00,1561797.60,0.00,'2021-12-04 17:39:52'),(1537909,'5','131',308,'Sale Id shift 243797',0.00,1741352.25,165.00,1741352.25,0.00,'2021-12-07 06:15:56'),(1542142,'5','131',308,'Sale Id shift 244309',0.00,580242.30,165.00,580242.30,0.00,'2021-12-07 16:19:12'),(1545439,'5','131',308,'Sale Id shift 244569',0.00,389706.90,165.00,389706.90,0.00,'2021-12-08 13:09:44'),(1548638,'5','131',308,'Sale Id shift 244683',0.00,1602654.90,165.00,1602654.90,0.00,'2021-12-09 08:26:09'),(1554208,'5','131',308,'Sale Id shift 244811',0.00,1996039.65,165.00,1996039.65,0.00,'2021-12-10 09:22:03'),(1562886,'5','131',308,'Sale Id shift 245068',0.00,1405958.40,165.00,1405958.40,0.00,'2021-12-11 17:29:20'),(1563139,'5','131',308,'Sale Id shift 245401',0.00,1158309.90,165.00,1158309.90,0.00,'2021-12-11 20:37:06'),(1604499,'5','131',308,'Sale Id shift 246789',0.00,847327.80,165.00,847327.80,0.00,'2021-12-19 17:33:20'),(1604746,'5','131',308,'Sale Id shift 247352',0.00,1400584.35,165.00,1400584.35,0.00,'2021-12-20 06:12:32'),(1609893,'5','131',308,'Sale Id shift 247422',0.00,1623849.15,165.00,1623849.15,0.00,'2021-12-20 18:03:32'),(1620941,'5','131',308,'Sale Id shift 248082',0.00,863152.95,165.00,863152.95,0.00,'2021-12-23 04:54:46'),(1622392,'5','131',308,'Sale Id shift 248234',0.00,149999.85,165.00,149999.85,0.00,'2021-12-23 09:42:40'),(1694122,'5','131',308,'Sale Id shift 251586',0.00,701141.10,165.00,701141.10,0.00,'2022-01-06 12:25:53'),(1698483,'5','131',308,'Sale Id shift 251670',0.00,1866833.10,165.00,1866833.10,0.00,'2022-01-07 10:15:28'),(1702551,'5','131',308,'Sale Id shift 251841',0.00,1254115.50,165.00,1254115.50,0.00,'2022-01-08 08:07:20'),(1712135,'5','131',308,'Sale Id shift 252053',0.00,1295322.60,165.00,1295322.60,0.00,'2022-01-09 15:50:17'),(1721518,'5','131',308,'Sale Id shift 252831',0.00,1034437.80,165.00,1034437.80,0.00,'2022-01-11 14:02:41'),(1721838,'5','131',308,'Sale Id shift 252856',0.00,517839.30,165.00,517839.30,0.00,'2022-01-11 14:46:22'),(1739733,'5','131',308,'Sale Id shift 253525',0.00,822401.25,165.00,822401.25,0.00,'2022-01-15 09:07:32'),(1744938,'5','131',308,'Sale Id shift 253778',0.00,923632.05,165.00,923632.05,0.00,'2022-01-16 06:38:51'),(1749672,'5','131',308,'Sale Id shift 254037',0.00,227365.05,165.00,227365.05,0.00,'2022-01-17 07:07:50'),(1749673,'5','131',308,'Sale Id shift 257509',0.00,969200.10,165.00,969200.10,0.00,'2022-01-31 09:18:08'),(1749674,'5','131',308,'Sale Id shift 257510',0.00,933822.45,165.00,933822.45,0.00,'2022-02-02 19:19:20'),(1749675,'5','131',308,'Sale Id shift 257511',0.00,864296.40,165.00,864296.40,0.00,'2022-02-02 19:43:05'),(1749676,'5','131',308,'Sale Id shift 257512',0.00,858356.40,165.00,858356.40,0.00,'2022-02-03 07:56:45'),(1749677,'5','131',308,'Sale Id shift 257513',0.00,789454.05,165.00,789454.05,0.00,'2022-02-03 20:39:52'),(1749678,'5','131',308,'Sale Id shift 257514',0.00,848642.85,165.00,848642.85,0.00,'2022-02-05 06:56:30'),(1749679,'5','131',308,'Sale Id shift 257517',0.00,984109.50,165.00,984109.50,0.00,'2022-02-05 22:41:09'),(1749680,'5','131',308,'Sale Id shift 257518',0.00,879034.20,165.00,879034.20,0.00,'2022-02-07 07:21:10'),(1749681,'5','131',308,'Sale Id shift 257519',0.00,899466.15,165.00,899466.15,0.00,'2022-02-08 07:18:13'),(1749682,'5','131',308,'Sale Id shift 257520',0.00,933190.50,165.00,933190.50,0.00,'2022-02-08 20:42:11'),(1749683,'5','131',308,'Sale Id shift 257521',0.00,967083.15,165.00,967083.15,0.00,'2022-02-09 20:55:54'),(1749684,'5','131',308,'Sale Id shift 257522',0.00,1010709.15,165.00,1010709.15,0.00,'2022-02-10 21:43:43'),(1749685,'5','131',308,'Sale Id shift 257523',0.00,977699.25,165.00,977699.25,0.00,'2022-02-11 20:21:07'),(1749686,'5','131',308,'Sale Id shift 257524',0.00,1206455.25,165.00,1206455.25,0.00,'2022-02-13 08:47:45'),(1749687,'5','131',308,'Sale Id shift 257525',0.00,1054303.80,165.00,1054303.80,0.00,'2022-02-14 06:09:28'),(1749688,'5','131',308,'Sale Id shift 257526',0.00,725538.00,165.00,725538.00,0.00,'2022-02-14 23:48:08'),(1749689,'5','131',308,'Sale Id shift 257527',0.00,502735.20,165.00,502735.20,0.00,'2022-02-16 06:11:36'),(1749690,'5','131',308,'Sale Id shift 257528',0.00,1613229.75,165.00,1613229.75,0.00,'2022-02-18 07:58:22'),(1749691,'5','131',308,'Sale Id shift 257529',0.00,822010.20,165.00,822010.20,0.00,'2022-02-18 10:13:50'),(1749692,'5','131',308,'Sale Id shift 257530',0.00,479085.75,165.00,479085.75,0.00,'2022-02-19 07:18:53'),(1749693,'5','131',308,'Sale Id shift 257533',0.00,2015714.25,165.00,2015714.25,0.00,'2022-02-22 06:55:22'),(1749694,'5','131',308,'Sale Id shift 257534',0.00,1844751.15,165.00,1844751.15,0.00,'2022-02-23 07:12:18'),(1749695,'5','131',308,'Sale Id shift 257535',0.00,972450.60,165.00,972450.60,0.00,'2022-02-24 15:42:05'),(1749696,'5','131',308,'Sale Id shift 257536',0.00,1342880.55,165.00,1342880.55,0.00,'2022-02-25 06:47:17'),(1749697,'5','131',308,'Sale Id shift 257537',0.00,522033.60,165.00,522033.60,0.00,'2022-02-26 07:17:26'),(1749698,'5','131',308,'Sale Id shift 257538',0.00,15658.50,165.00,15658.50,0.00,'2022-02-27 09:12:01'),(1749699,'5','131',308,'Sale Id shift 257541',0.00,1170048.00,165.00,1170048.00,0.00,'2022-03-02 21:00:27'),(1749700,'5','131',308,'Sale Id shift 257542',0.00,878791.65,165.00,878791.65,0.00,'2022-03-03 08:08:17'),(1749701,'5','131',308,'Sale Id shift 257543',0.00,618751.65,165.00,618751.65,0.00,'2022-03-04 08:20:02'),(1749702,'5','131',308,'Sale Id shift 257555',0.00,2251814.40,165.00,2251814.40,0.00,'2022-03-16 08:13:36'),(1749703,'5','131',308,'Sale Id shift 257556',0.00,1065698.70,165.00,1065698.70,0.00,'2022-03-17 08:10:31'),(1749704,'5','131',308,'Sale Id shift 257557',0.00,1019297.40,165.00,1019297.40,0.00,'2022-03-18 07:38:13'),(1749705,'5','131',308,'Sale Id shift 257558',0.00,526617.30,165.00,526617.30,0.00,'2022-03-19 07:06:55'),(1749706,'5','131',308,'Sale Id shift 257564',0.00,932055.30,165.00,932055.30,0.00,'2022-03-25 06:45:13'),(1749707,'5','131',308,'Sale Id shift 257565',0.00,867244.95,165.00,867244.95,0.00,'2022-03-26 04:54:42'),(1749708,'5','131',308,'Sale Id shift 257566',0.00,378876.30,165.00,378876.30,0.00,'2022-03-27 07:55:41'),(1749709,'5','131',308,'Sale Id shift 257583',0.00,82496.70,165.00,82496.70,0.00,'2022-04-13 04:04:17'),(1749710,'5','131',308,'Sale Id shift 257584',0.00,997152.75,165.00,997152.75,0.00,'2022-04-16 05:12:48'),(1749711,'5','131',308,'Sale Id shift 257585',0.00,801461.10,165.00,801461.10,0.00,'2022-04-16 11:41:03'),(1749712,'5','131',308,'Sale Id shift 257586',0.00,573162.15,165.00,573162.15,0.00,'2022-04-16 14:47:18'),(1749713,'5','131',308,'Sale Id shift 257592',0.00,833226.90,165.00,833226.90,0.00,'2022-04-22 06:10:01'),(1749714,'5','131',308,'Sale Id shift 257599',0.00,394977.00,165.00,394977.00,0.00,'2022-04-29 06:03:12'),(1749715,'5','131',308,'Sale Id shift 257600',0.00,857572.65,165.00,857572.65,0.00,'2022-04-30 00:03:42'),(1749716,'5','131',308,'Sale Id shift 257601',0.00,1273476.60,165.00,1273476.60,0.00,'2022-05-09 14:26:26'),(1749717,'5','131',308,'Sale Id shift 257602',0.00,1017030.30,165.00,1017030.30,0.00,'2022-05-09 15:06:00'),(1749718,'5','131',308,'Sale Id shift 257603',0.00,508038.30,165.00,508038.30,0.00,'2022-05-09 15:27:29'),(1749719,'5','131',308,'Sale Id shift 257604',0.00,1338097.20,165.00,1338097.20,0.00,'2022-05-09 15:59:44'),(1749720,'5','131',308,'Sale Id shift 257605',0.00,1348056.60,165.00,1348056.60,0.00,'2022-05-09 19:20:12'),(1749721,'5','131',308,'Sale Id shift 257606',0.00,1453390.95,165.00,1453390.95,0.00,'2022-05-09 19:23:24'),(1749722,'5','131',308,'Sale Id shift 257611',0.00,1083132.60,165.00,1083132.60,0.00,'2022-05-09 20:50:15'),(1749723,'5','131',308,'Sale Id shift 257612',0.00,554520.45,165.00,554520.45,0.00,'2022-05-10 22:52:34'),(1749724,'5','131',308,'Sale Id shift 257613',0.00,171657.75,165.00,171657.75,0.00,'2022-05-12 05:31:43'),(1749725,'5','131',308,'Sale Id shift 257620',0.00,599001.15,165.00,599001.15,0.00,'2022-05-18 21:30:50'),(1749726,'5','131',308,'Sale Id shift 257621',0.00,797784.90,165.00,797784.90,0.00,'2022-05-20 05:23:51'),(1749727,'5','131',308,'Sale Id shift 257622',0.00,848017.50,165.00,848017.50,0.00,'2022-05-22 08:14:52'),(1749728,'5','131',308,'Sale Id shift 257623',0.00,747077.10,165.00,747077.10,0.00,'2022-05-23 05:16:52'),(1749729,'5','131',308,'Sale Id shift 257638',0.00,681651.30,165.00,681651.30,0.00,'2022-06-06 06:29:41'),(1749730,'5','131',308,'Sale Id shift 257639',0.00,853064.85,165.00,853064.85,0.00,'2022-06-07 07:27:00'),(1749731,'5','131',308,'Sale Id shift 257640',0.00,625812.00,165.00,625812.00,0.00,'2022-06-08 10:32:13'),(1749732,'5','131',308,'Sale Id shift 257641',0.00,307414.80,165.00,307414.80,0.00,'2022-06-09 06:01:18'),(1749733,'5','131',308,'Sale Id shift 257683',0.00,1316990.95,185.00,1316990.95,0.00,'2022-07-21 07:59:20'),(1749734,'5','131',308,'Sale Id shift 257684',0.00,1319658.65,185.00,1319658.65,0.00,'2022-07-21 23:14:40'),(1749735,'5','131',308,'Sale Id shift 257685',0.00,1025780.60,185.00,1025780.60,0.00,'2022-07-23 06:55:43'),(1749736,'5','131',308,'Sale Id shift 257686',0.00,1291490.55,185.00,1291490.55,0.00,'2022-07-24 08:32:51'),(1749737,'5','131',308,'Sale Id shift 257687',0.00,1297449.40,185.00,1297449.40,0.00,'2022-07-25 06:45:21'),(1749738,'5','131',308,'Sale Id shift 257688',0.00,825771.55,165.00,736498.95,-89272.60,'2022-07-26 05:54:26'),(1749739,'5','131',308,'Sale Id shift 257689',0.00,945037.35,185.00,945037.35,0.00,'2022-07-27 06:05:10'),(1749740,'5','131',308,'Sale Id shift 257690',0.00,346958.25,185.00,346958.25,0.00,'2022-07-28 06:54:52');
/*!40000 ALTER TABLE `inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices`
--

DROP TABLE IF EXISTS `invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `expirydate` date NOT NULL,
  `notes` text,
  `status` int NOT NULL DEFAULT '0',
  `email` varchar(200) DEFAULT NULL,
  `email_sent_at` datetime DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `payment_method` varchar(50) DEFAULT NULL,
  `payment_details` text,
  `payment_status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `status` (`status`,`company_id`,`station_id`),
  KEY `email_sent_at` (`email_sent_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices`
--

LOCK TABLES `invoices` WRITE;
/*!40000 ALTER TABLE `invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices_items`
--

DROP TABLE IF EXISTS `invoices_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices_items` (
  `id` int NOT NULL AUTO_INCREMENT,
  `invoice_id` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(200) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `item_type` varchar(50) NOT NULL,
  `item_id` varchar(100) NOT NULL,
  `item_details` longtext,
  PRIMARY KEY (`id`),
  KEY `name` (`name`,`invoice_id`,`station_id`),
  KEY `companycode` (`company_id`),
  KEY `status` (`status`,`item_type`,`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices_items`
--

LOCK TABLES `invoices_items` WRITE;
/*!40000 ALTER TABLE `invoices_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ledgers`
--

DROP TABLE IF EXISTS `ledgers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ledgers` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` int NOT NULL AUTO_INCREMENT,
  `ledgertype` varchar(10) NOT NULL,
  `accounttype` varchar(50) NOT NULL,
  `accountid` varchar(50) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `details` varchar(1000) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `accounttype` (`accounttype`,`accountid`,`credit`,`debit`,`thedate`),
  KEY `cooperative` (`company_id`),
  KEY `depot_id` (`station_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=4959772 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ledgers`
--

LOCK TABLES `ledgers` WRITE;
/*!40000 ALTER TABLE `ledgers` DISABLE KEYS */;
INSERT INTO `ledgers` VALUES ('5','131',3505354,'','20','3243',0.00,0.00,'Sales from shift 229385 on 2021-10-06 05:20:35 ','2021-10-06 05:20:35','',''),('5','131',3505355,'','6.1','3241',0.00,0.00,'Sales from shift 229385 on 2021-10-06 05:20:35 ','2021-10-06 05:20:35','',''),('5','131',3506583,'','20','3243',0.00,0.00,'Sales from shift 229417 on 2021-10-06 08:38:48 ','2021-10-06 08:38:48','',''),('5','131',3506584,'','6.1','3241',0.00,0.00,'Sales from shift 229417 on 2021-10-06 08:38:48 ','2021-10-06 08:38:48','',''),('5','131',3555373,'','24','3245',0.00,244500.00,'Purchase Id 78065 for 1,500.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2021-10-11 14:13:30','',''),('5','131',3555374,'','supplier','140',244500.00,0.00,'Purchase Id 78065 for 1,500.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2021-10-11 14:13:30','',''),('5','131',3555379,'','24','3245',0.00,270000.00,'Purchase Id 78064 for 900.00 litters of Diesel - AGO from SALBAS OIL & GAS NIG. LTD','2021-10-11 14:13:49','',''),('5','131',3555380,'','supplier','140',270000.00,0.00,'Purchase Id 78064 for 900.00 litters of Diesel - AGO from SALBAS OIL & GAS NIG. LTD','2021-10-11 14:13:49','',''),('5','131',3555408,'','20','3243',0.00,0.00,'Sales from shift 229463 on 2021-10-11 14:16:00 ','2021-10-11 14:16:00','',''),('5','131',3555409,'','6.1','3241',0.00,0.00,'Sales from shift 229463 on 2021-10-11 14:16:00 ','2021-10-11 14:16:00','',''),('5','131',3556133,'','20','3243',568964.54,0.00,'Sales from shift 230680 on 2021-10-11 15:08:47 ','2021-10-11 15:08:47','',''),('5','131',3556134,'','6.1','3241',0.00,568964.54,'Sales from shift 230680 on 2021-10-11 15:08:47 ','2021-10-11 15:08:47','',''),('5','131',3556139,'','24','3245',0.00,2453150.00,'Purchase Id 78068 for 15,050.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2021-10-11 15:09:24','',''),('5','131',3556140,'','supplier','140',2453150.00,0.00,'Purchase Id 78068 for 15,050.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2021-10-11 15:09:24','',''),('5','131',3558158,'','20','3243',530199.88,0.00,'Sales from shift 230710 on 2021-10-11 18:15:00 ','2021-10-11 18:15:00','',''),('5','131',3558159,'','6.1','3241',0.00,530199.88,'Sales from shift 230710 on 2021-10-11 18:15:00 ','2021-10-11 18:15:00','',''),('5','131',3558740,'','20','3243',609481.45,0.00,'Sales from shift 230763 on 2021-10-12 06:26:31 ','2021-10-12 06:26:31','',''),('5','131',3558741,'','6.1','3241',0.00,609481.45,'Sales from shift 230763 on 2021-10-12 06:26:31 ','2021-10-12 06:26:31','',''),('5','131',3561453,'','20','3243',470879.29,0.00,'Sales from shift 230821 on 2021-10-12 10:04:12 ','2021-10-12 10:04:12','',''),('5','131',3561454,'','6.1','3241',0.00,470879.29,'Sales from shift 230821 on 2021-10-12 10:04:12 ','2021-10-12 10:04:12','',''),('5','131',3563955,'','20','3243',310638.88,0.00,'Sales from shift 230933 on 2021-10-12 13:18:37 ','2021-10-12 13:18:37','',''),('5','131',3563956,'','6.1','3241',0.00,310638.88,'Sales from shift 230933 on 2021-10-12 13:18:37 ','2021-10-12 13:18:37','',''),('5','131',3563965,'','24','3245',0.00,6520000.00,'Purchase Id 78099 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2021-10-12 13:19:27','',''),('5','131',3563966,'','supplier','140',6520000.00,0.00,'Purchase Id 78099 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2021-10-12 13:19:27','',''),('5','131',3564565,'','20','3243',0.00,0.00,'Sales from shift 230937 on 2021-10-12 14:06:23 ','2021-10-12 14:06:23','',''),('5','131',3564566,'','6.1','3241',0.00,0.00,'Sales from shift 230937 on 2021-10-12 14:06:23 ','2021-10-12 14:06:23','',''),('5','131',3568365,'','20','3243',0.00,0.00,'Sales from shift 230963 on 2021-10-12 20:26:33 ','2021-10-12 20:26:33','',''),('5','131',3568366,'','6.1','3241',0.00,0.00,'Sales from shift 230963 on 2021-10-12 20:26:33 ','2021-10-12 20:26:33','',''),('5','131',3568559,'','20','3243',0.00,0.00,'Sales from shift 231048 on 2021-10-13 05:53:59 ','2021-10-13 05:53:59','',''),('5','131',3568560,'','6.1','3241',0.00,0.00,'Sales from shift 231048 on 2021-10-13 05:53:59 ','2021-10-13 05:53:59','',''),('5','131',3568563,'','6.1','3241',7200.00,0.00,'Payment Id 343185 for invoice:230933, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-10-13 05:54:31','',''),('5','131',3568564,'','supplier','140',0.00,7200.00,'Payment Id 343185 for invoice:230933, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-10-13 05:54:31','',''),('5','131',3568565,'','2','3246',303430.00,0.00,'Payment Id 343183 for invoice:230933, receipt: 026 by SALBAS OIL & GAS NIG. LTD','2021-10-13 05:54:31','',''),('5','131',3568566,'','supplier','140',0.00,303430.00,'Payment Id 343183 for invoice:230933, receipt: 026 by SALBAS OIL & GAS NIG. LTD','2021-10-13 05:54:31','',''),('5','131',3568567,'','2','3246',463670.00,0.00,'Payment Id 342947 for invoice:230821, receipt: 022 by SALBAS OIL & GAS NIG. LTD','2021-10-13 05:54:31','',''),('5','131',3568568,'','supplier','140',0.00,463670.00,'Payment Id 342947 for invoice:230821, receipt: 022 by SALBAS OIL & GAS NIG. LTD','2021-10-13 05:54:31','',''),('5','131',3568569,'','6.1','3241',7000.00,0.00,'Payment Id 342945 for invoice:230763, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-10-13 05:54:31','',''),('5','131',3568570,'','supplier','140',0.00,7000.00,'Payment Id 342945 for invoice:230763, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-10-13 05:54:31','',''),('5','131',3568571,'','2','3246',602480.00,0.00,'Payment Id 342941 for invoice:230763, receipt: 0026 by SALBAS OIL & GAS NIG. LTD','2021-10-13 05:54:31','',''),('5','131',3568572,'','supplier','140',0.00,602480.00,'Payment Id 342941 for invoice:230763, receipt: 0026 by SALBAS OIL & GAS NIG. LTD','2021-10-13 05:54:31','',''),('5','131',3568573,'','2','3246',523500.00,0.00,'Payment Id 342713 for invoice:230710, receipt: 026 by SALBAS OIL & GAS NIG. LTD','2021-10-13 05:54:31','',''),('5','131',3568574,'','supplier','140',0.00,523500.00,'Payment Id 342713 for invoice:230710, receipt: 026 by SALBAS OIL & GAS NIG. LTD','2021-10-13 05:54:31','',''),('5','131',3568575,'','6.1','3241',11700.00,0.00,'Payment Id 342710 for invoice:230680, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-10-13 05:54:31','',''),('5','131',3568576,'','supplier','140',0.00,11700.00,'Payment Id 342710 for invoice:230680, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-10-13 05:54:31','',''),('5','131',3568577,'','2','3246',550260.00,0.00,'Payment Id 342709 for invoice:230680, receipt: 022 by SALBAS OIL & GAS NIG. LTD','2021-10-13 05:54:31','',''),('5','131',3568578,'','supplier','140',0.00,550260.00,'Payment Id 342709 for invoice:230680, receipt: 022 by SALBAS OIL & GAS NIG. LTD','2021-10-13 05:54:31','',''),('5','131',3569613,'','20','3243',0.00,0.00,'Sales from shift 231071 on 2021-10-13 07:40:33 ','2021-10-13 07:40:33','',''),('5','131',3569614,'','6.1','3241',0.00,0.00,'Sales from shift 231071 on 2021-10-13 07:40:33 ','2021-10-13 07:40:33','',''),('5','131',3570121,'','20','3243',916824.47,0.00,'Sales from shift 231096 on 2021-10-13 08:32:49 ','2021-10-13 08:32:49','',''),('5','131',3570122,'','6.1','3241',0.00,916824.47,'Sales from shift 231096 on 2021-10-13 08:32:49 ','2021-10-13 08:32:49','',''),('5','131',3573199,'','6.1','3241',219000.00,0.00,'Payment Id 343624 for invoice:231096, receipt: 022 by SALBAS OIL & GAS NIG. LTD','2021-10-13 12:35:52','',''),('5','131',3573200,'','supplier','140',0.00,219000.00,'Payment Id 343624 for invoice:231096, receipt: 022 by SALBAS OIL & GAS NIG. LTD','2021-10-13 12:35:52','',''),('5','131',3573201,'','6.1','3241',7400.00,0.00,'Payment Id 343621 for invoice:231096, receipt: 022 by SALBAS OIL & GAS NIG. LTD','2021-10-13 12:35:52','',''),('5','131',3573202,'','supplier','140',0.00,7400.00,'Payment Id 343621 for invoice:231096, receipt: 022 by SALBAS OIL & GAS NIG. LTD','2021-10-13 12:35:52','',''),('5','131',3573203,'','2','3246',690420.00,0.00,'Payment Id 343619 for invoice:231096, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2021-10-13 12:35:52','',''),('5','131',3573204,'','supplier','140',0.00,690420.00,'Payment Id 343619 for invoice:231096, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2021-10-13 12:35:52','',''),('5','131',3578496,'','20','3243',793433.47,0.00,'Sales from shift 231119 on 2021-10-14 05:14:33 ','2021-10-14 05:14:33','',''),('5','131',3578497,'','6.1','3241',0.00,793433.47,'Sales from shift 231119 on 2021-10-14 05:14:33 ','2021-10-14 05:14:33','',''),('5','131',3584923,'','6.1','3241',5000.00,0.00,'Payment Id 344160 for invoice:231119, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-10-14 14:38:28','',''),('5','131',3584924,'','supplier','140',0.00,5000.00,'Payment Id 344160 for invoice:231119, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-10-14 14:38:28','',''),('5','131',3584925,'','6.1','3241',7400.00,0.00,'Payment Id 344157 for invoice:231119, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-10-14 14:38:28','',''),('5','131',3584926,'','supplier','140',0.00,7400.00,'Payment Id 344157 for invoice:231119, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-10-14 14:38:28','',''),('5','131',3584927,'','2','3246',781030.00,0.00,'Payment Id 344156 for invoice:231119, receipt: 024 by SALBAS OIL & GAS NIG. LTD','2021-10-14 14:38:28','',''),('5','131',3584928,'','supplier','140',0.00,781030.00,'Payment Id 344156 for invoice:231119, receipt: 024 by SALBAS OIL & GAS NIG. LTD','2021-10-14 14:38:28','',''),('5','131',3590807,'','20','3243',860853.53,0.00,'Sales from shift 231363 on 2021-10-15 09:26:15 ','2021-10-15 09:26:15','',''),('5','131',3590808,'','6.1','3241',0.00,860853.53,'Sales from shift 231363 on 2021-10-15 09:26:15 ','2021-10-15 09:26:15','',''),('5','131',3595735,'','6.1','3241',7400.00,0.00,'Payment Id 344773 for invoice:231363, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-10-15 15:14:01','',''),('5','131',3595736,'','supplier','140',0.00,7400.00,'Payment Id 344773 for invoice:231363, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-10-15 15:14:01','',''),('5','131',3595737,'','2','3246',853450.00,0.00,'Payment Id 344770 for invoice:231709, receipt: 231363 by SALBAS OIL & GAS NIG. LTD','2021-10-15 15:14:01','',''),('5','131',3595738,'','supplier','140',0.00,853450.00,'Payment Id 344770 for invoice:231709, receipt: 231363 by SALBAS OIL & GAS NIG. LTD','2021-10-15 15:14:01','',''),('5','131',3606637,'','20','3243',922223.03,0.00,'Sales from shift 231709 on 2021-10-16 16:32:51 ','2021-10-16 16:32:51','',''),('5','131',3606638,'','6.1','3241',0.00,922223.03,'Sales from shift 231709 on 2021-10-16 16:32:51 ','2021-10-16 16:32:51','',''),('5','131',3615940,'','20','3243',797037.40,0.00,'Sales from shift 232070 on 2021-10-17 15:14:51 ','2021-10-17 15:14:51','',''),('5','131',3615941,'','6.1','3241',0.00,797037.40,'Sales from shift 232070 on 2021-10-17 15:14:51 ','2021-10-17 15:14:51','',''),('5','131',3618962,'','24','3245',0.00,2192350.00,'Purchase Id 78518 for 13,450.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2021-10-18 08:01:10','',''),('5','131',3618963,'','supplier','140',2192350.00,0.00,'Purchase Id 78518 for 13,450.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2021-10-18 08:01:10','',''),('5','131',3619218,'','20','3243',591649.25,0.00,'Sales from shift 232263 on 2021-10-18 08:25:12 ','2021-10-18 08:25:12','',''),('5','131',3619219,'','6.1','3241',0.00,591649.25,'Sales from shift 232263 on 2021-10-18 08:25:12 ','2021-10-18 08:25:12','',''),('5','131',3627556,'','6.1','3241',7540.00,0.00,'Payment Id 346496 for invoice:232263, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-10-18 18:19:59','',''),('5','131',3627557,'','supplier','140',0.00,7540.00,'Payment Id 346496 for invoice:232263, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-10-18 18:19:59','',''),('5','131',3627558,'','2','3246',584100.00,0.00,'Payment Id 346495 for invoice:232263, receipt: 022 by SALBAS OIL & GAS NIG. LTD','2021-10-18 18:19:59','',''),('5','131',3627559,'','supplier','140',0.00,584100.00,'Payment Id 346495 for invoice:232263, receipt: 022 by SALBAS OIL & GAS NIG. LTD','2021-10-18 18:19:59','',''),('5','131',3627560,'','6.1','3241',2000.00,0.00,'Payment Id 346493 for invoice:232070, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-10-18 18:19:59','',''),('5','131',3627561,'','supplier','140',0.00,2000.00,'Payment Id 346493 for invoice:232070, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-10-18 18:19:59','',''),('5','131',3627562,'','6.1','3241',7540.00,0.00,'Payment Id 346491 for invoice:232070, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-10-18 18:19:59','',''),('5','131',3627563,'','supplier','140',0.00,7540.00,'Payment Id 346491 for invoice:232070, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-10-18 18:19:59','',''),('5','131',3627564,'','2','3246',787490.00,0.00,'Payment Id 346489 for invoice:232070, receipt: 022 by SALBAS OIL & GAS NIG. LTD','2021-10-18 18:19:59','',''),('5','131',3627565,'','supplier','140',0.00,787490.00,'Payment Id 346489 for invoice:232070, receipt: 022 by SALBAS OIL & GAS NIG. LTD','2021-10-18 18:19:59','',''),('5','131',3627566,'','6.1','3241',7400.00,0.00,'Payment Id 346485 for invoice:231709, receipt: 022 by SALBAS OIL & GAS NIG. LTD','2021-10-18 18:19:59','',''),('5','131',3627567,'','supplier','140',0.00,7400.00,'Payment Id 346485 for invoice:231709, receipt: 022 by SALBAS OIL & GAS NIG. LTD','2021-10-18 18:19:59','',''),('5','131',3627568,'','2','3246',914780.00,0.00,'Payment Id 346484 for invoice:231709, receipt: 022 by SALBAS OIL & GAS NIG. LTD','2021-10-18 18:19:59','',''),('5','131',3627569,'','supplier','140',0.00,914780.00,'Payment Id 346484 for invoice:231709, receipt: 022 by SALBAS OIL & GAS NIG. LTD','2021-10-18 18:19:59','',''),('5','131',3627888,'','20','3243',675115.03,0.00,'Sales from shift 232392 on 2021-10-19 05:06:01 ','2021-10-19 05:06:01','',''),('5','131',3627889,'','6.1','3241',0.00,675115.03,'Sales from shift 232392 on 2021-10-19 05:06:01 ','2021-10-19 05:06:01','',''),('5','131',3638613,'','20','3243',694552.78,0.00,'Sales from shift 232669 on 2021-10-20 08:24:20 ','2021-10-20 08:24:20','',''),('5','131',3638614,'','6.1','3241',0.00,694552.78,'Sales from shift 232669 on 2021-10-20 08:24:20 ','2021-10-20 08:24:20','',''),('5','131',3647927,'','6.1','3241',7540.00,0.00,'Payment Id 347581 for invoice:232669, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-10-20 16:53:45','',''),('5','131',3647928,'','supplier','140',0.00,7540.00,'Payment Id 347581 for invoice:232669, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-10-20 16:53:45','',''),('5','131',3647929,'','2','3246',687000.00,0.00,'Payment Id 347580 for invoice:232669, receipt: 032 by SALBAS OIL & GAS NIG. LTD','2021-10-20 16:53:45','',''),('5','131',3647930,'','supplier','140',0.00,687000.00,'Payment Id 347580 for invoice:232669, receipt: 032 by SALBAS OIL & GAS NIG. LTD','2021-10-20 16:53:45','',''),('5','131',3647931,'','6.1','3241',7540.00,0.00,'Payment Id 347579 for invoice:232392, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-10-20 16:53:45','',''),('5','131',3647932,'','supplier','140',0.00,7540.00,'Payment Id 347579 for invoice:232392, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-10-20 16:53:45','',''),('5','131',3647933,'','2','3246',667570.00,0.00,'Payment Id 347576 for invoice:232392, receipt: 032 by SALBAS OIL & GAS NIG. LTD','2021-10-20 16:53:45','',''),('5','131',3647934,'','supplier','140',0.00,667570.00,'Payment Id 347576 for invoice:232392, receipt: 032 by SALBAS OIL & GAS NIG. LTD','2021-10-20 16:53:45','',''),('5','131',3649195,'','20','3243',627703.22,0.00,'Sales from shift 232911 on 2021-10-21 06:39:05 ','2021-10-21 06:39:05','',''),('5','131',3649196,'','6.1','3241',0.00,627703.22,'Sales from shift 232911 on 2021-10-21 06:39:05 ','2021-10-21 06:39:05','',''),('5','131',3659905,'','20','3243',415627.18,0.00,'Sales from shift 233127 on 2021-10-22 08:48:36 ','2021-10-22 08:48:36','',''),('5','131',3659906,'','6.1','3241',0.00,415627.18,'Sales from shift 233127 on 2021-10-22 08:48:36 ','2021-10-22 08:48:36','',''),('5','131',3660223,'','24','3245',0.00,2188275.00,'Purchase Id 78869 for 13,425.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2021-10-22 09:11:10','',''),('5','131',3660224,'','supplier','140',2188275.00,0.00,'Purchase Id 78869 for 13,425.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2021-10-22 09:11:10','',''),('5','131',3660238,'','6.1','3241',7600.00,0.00,'Payment Id 348650 for invoice:232911, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-10-22 09:12:22','',''),('5','131',3660239,'','supplier','140',0.00,7600.00,'Payment Id 348650 for invoice:232911, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-10-22 09:12:22','',''),('5','131',3660240,'','2','3246',620100.00,0.00,'Payment Id 348649 for invoice:232911, receipt: 034 by SALBAS OIL & GAS NIG. LTD','2021-10-22 09:12:22','',''),('5','131',3660241,'','supplier','140',0.00,620100.00,'Payment Id 348649 for invoice:232911, receipt: 034 by SALBAS OIL & GAS NIG. LTD','2021-10-22 09:12:22','',''),('5','131',3661591,'','6.1','3241',7900.00,0.00,'Payment Id 348653 for invoice:233127, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-10-22 10:35:51','',''),('5','131',3661592,'','supplier','140',0.00,7900.00,'Payment Id 348653 for invoice:233127, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-10-22 10:35:51','',''),('5','131',3661593,'','2','3246',407720.00,0.00,'Payment Id 348651 for invoice:233127, receipt: 045 by SALBAS OIL & GAS NIG. LTD','2021-10-22 10:35:51','',''),('5','131',3661594,'','supplier','140',0.00,407720.00,'Payment Id 348651 for invoice:233127, receipt: 045 by SALBAS OIL & GAS NIG. LTD','2021-10-22 10:35:51','',''),('5','131',3668832,'','20','3243',942951.74,0.00,'Sales from shift 233432 on 2021-10-23 04:04:48 ','2021-10-23 04:04:48','',''),('5','131',3668833,'','6.1','3241',0.00,942951.74,'Sales from shift 233432 on 2021-10-23 04:04:48 ','2021-10-23 04:04:48','',''),('5','131',3679418,'','20','3243',890915.62,0.00,'Sales from shift 233688 on 2021-10-24 06:48:21 ','2021-10-24 06:48:21','',''),('5','131',3679419,'','6.1','3241',0.00,890915.62,'Sales from shift 233688 on 2021-10-24 06:48:21 ','2021-10-24 06:48:21','',''),('5','131',3692855,'','20','3243',874552.05,0.00,'Sales from shift 233994 on 2021-10-25 13:14:54 ','2021-10-25 13:14:54','',''),('5','131',3692856,'','6.1','3241',0.00,874552.05,'Sales from shift 233994 on 2021-10-25 13:14:54 ','2021-10-25 13:14:54','',''),('5','131',3692861,'','6.1','3241',7900.00,0.00,'Payment Id 350291 for invoice:23394, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-10-25 13:15:16','',''),('5','131',3692862,'','supplier','140',0.00,7900.00,'Payment Id 350291 for invoice:23394, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-10-25 13:15:16','',''),('5','131',3692863,'','2','3246',866650.00,0.00,'Payment Id 350290 for invoice:23394, receipt: 022 by SALBAS OIL & GAS NIG. LTD','2021-10-25 13:15:16','',''),('5','131',3692864,'','supplier','140',0.00,866650.00,'Payment Id 350290 for invoice:23394, receipt: 022 by SALBAS OIL & GAS NIG. LTD','2021-10-25 13:15:16','',''),('5','131',3692865,'','6.1','3241',7900.00,0.00,'Payment Id 350289 for invoice:233688, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-10-25 13:15:16','',''),('5','131',3692866,'','supplier','140',0.00,7900.00,'Payment Id 350289 for invoice:233688, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-10-25 13:15:16','',''),('5','131',3692867,'','2','3246',883000.00,0.00,'Payment Id 350288 for invoice:233688, receipt: 022 by SALBAS OIL & GAS NIG. LTD','2021-10-25 13:15:16','',''),('5','131',3692868,'','supplier','140',0.00,883000.00,'Payment Id 350288 for invoice:233688, receipt: 022 by SALBAS OIL & GAS NIG. LTD','2021-10-25 13:15:16','',''),('5','131',3692869,'','6.1','3241',25000.00,0.00,'Payment Id 350287 for invoice:233432, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-10-25 13:15:16','',''),('5','131',3692870,'','supplier','140',0.00,25000.00,'Payment Id 350287 for invoice:233432, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-10-25 13:15:16','',''),('5','131',3692871,'','6.1','3241',7900.00,0.00,'Payment Id 350286 for invoice:233432, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-10-25 13:15:16','',''),('5','131',3692872,'','supplier','140',0.00,7900.00,'Payment Id 350286 for invoice:233432, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-10-25 13:15:16','',''),('5','131',3692873,'','2','3246',910000.00,0.00,'Payment Id 350285 for invoice:233432, receipt: 022 by SALBAS OIL & GAS NIG. LTD','2021-10-25 13:15:16','',''),('5','131',3692874,'','supplier','140',0.00,910000.00,'Payment Id 350285 for invoice:233432, receipt: 022 by SALBAS OIL & GAS NIG. LTD','2021-10-25 13:15:16','',''),('5','131',3706062,'','6.1','3241',20500.00,0.00,'Payment Id 350951 for invoice:234480, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-10-26 15:28:54','',''),('5','131',3706063,'','supplier','140',0.00,20500.00,'Payment Id 350951 for invoice:234480, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-10-26 15:28:54','',''),('5','131',3706064,'','6.1','3241',7900.00,0.00,'Payment Id 350949 for invoice:234480, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-10-26 15:28:54','',''),('5','131',3706065,'','supplier','140',0.00,7900.00,'Payment Id 350949 for invoice:234480, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-10-26 15:28:54','',''),('5','131',3706066,'','2','3246',781570.00,0.00,'Payment Id 350947 for invoice:234480, receipt: 022 by SALBAS OIL & GAS NIG. LTD','2021-10-26 15:28:54','',''),('5','131',3706067,'','supplier','140',0.00,781570.00,'Payment Id 350947 for invoice:234480, receipt: 022 by SALBAS OIL & GAS NIG. LTD','2021-10-26 15:28:54','',''),('5','131',3706082,'','20','3243',809979.60,0.00,'Sales from shift 234480 on 2021-10-26 15:29:16 ','2021-10-26 15:29:16','',''),('5','131',3706083,'','6.1','3241',0.00,809979.60,'Sales from shift 234480 on 2021-10-26 15:29:16 ','2021-10-26 15:29:16','',''),('5','131',3708918,'','20','3243',72027.45,0.00,'Sales from shift 234512 on 2021-10-27 06:13:46 ','2021-10-27 06:13:46','',''),('5','131',3708919,'','6.1','3241',0.00,72027.45,'Sales from shift 234512 on 2021-10-27 06:13:46 ','2021-10-27 06:13:46','',''),('5','131',3719255,'','6.1','3241',10000.00,0.00,'Payment Id 351346 for invoice:234512, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-10-27 19:18:30','',''),('5','131',3719256,'','supplier','140',0.00,10000.00,'Payment Id 351346 for invoice:234512, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-10-27 19:18:30','',''),('5','131',3719257,'','6.1','3241',7900.00,0.00,'Payment Id 351343 for invoice:234512, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-10-27 19:18:30','',''),('5','131',3719258,'','supplier','140',0.00,7900.00,'Payment Id 351343 for invoice:234512, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-10-27 19:18:30','',''),('5','131',3719259,'','2','3246',54100.00,0.00,'Payment Id 351341 for invoice:234512, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-10-27 19:18:30','',''),('5','131',3719260,'','supplier','140',0.00,54100.00,'Payment Id 351341 for invoice:234512, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-10-27 19:18:30','',''),('5','131',3729537,'','20','3243',0.00,0.00,'Sales from shift 234636 on 2021-10-29 04:39:14 ','2021-10-29 04:39:14','',''),('5','131',3729538,'','6.1','3241',0.00,0.00,'Sales from shift 234636 on 2021-10-29 04:39:14 ','2021-10-29 04:39:14','',''),('5','131',3738324,'','20','3243',0.00,0.00,'Sales from shift 235081 on 2021-10-29 21:58:19 ','2021-10-29 21:58:19','',''),('5','131',3738325,'','6.1','3241',0.00,0.00,'Sales from shift 235081 on 2021-10-29 21:58:19 ','2021-10-29 21:58:19','',''),('5','131',3747431,'','20','3243',0.00,0.00,'Sales from shift 235335 on 2021-10-30 16:53:17 ','2021-10-30 16:53:17','',''),('5','131',3747432,'','6.1','3241',0.00,0.00,'Sales from shift 235335 on 2021-10-30 16:53:17 ','2021-10-30 16:53:17','',''),('5','131',3750562,'','20','3243',0.00,0.00,'Sales from shift 235533 on 2021-10-31 08:48:43 ','2021-10-31 08:48:43','',''),('5','131',3750563,'','6.1','3241',0.00,0.00,'Sales from shift 235533 on 2021-10-31 08:48:43 ','2021-10-31 08:48:43','',''),('5','131',3755960,'','24','3245',0.00,4933500.00,'Purchase Id 79489 for 29,900.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2021-10-31 15:08:04','',''),('5','131',3755961,'','supplier','140',4933500.00,0.00,'Purchase Id 79489 for 29,900.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2021-10-31 15:08:04','',''),('5','131',3756879,'','24','3245',0.00,16500.00,'Purchase Id 79492 for 100.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2021-10-31 16:15:21','',''),('5','131',3756880,'','supplier','140',16500.00,0.00,'Purchase Id 79492 for 100.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2021-10-31 16:15:21','',''),('5','131',3762110,'','20','3243',1526961.15,0.00,'Sales from shift 235673 on 2021-11-01 11:30:07 ','2021-11-01 11:30:07','',''),('5','131',3762111,'','6.1','3241',0.00,1526961.15,'Sales from shift 235673 on 2021-11-01 11:30:07 ','2021-11-01 11:30:07','',''),('5','131',3766041,'','6.1','3241',3000.00,0.00,'Payment Id 354048 for invoice:235673, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-01 17:48:06','',''),('5','131',3766042,'','supplier','140',0.00,3000.00,'Payment Id 354048 for invoice:235673, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-01 17:48:06','',''),('5','131',3766043,'','6.1','3241',7900.00,0.00,'Payment Id 354045 for invoice:235673, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-01 17:48:06','',''),('5','131',3766044,'','supplier','140',0.00,7900.00,'Payment Id 354045 for invoice:235673, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-01 17:48:06','',''),('5','131',3766045,'','2','3246',1532500.00,0.00,'Payment Id 354044 for invoice:235673, receipt: 026 by SALBAS OIL & GAS NIG. LTD','2021-11-01 17:48:06','',''),('5','131',3766046,'','supplier','140',0.00,1532500.00,'Payment Id 354044 for invoice:235673, receipt: 026 by SALBAS OIL & GAS NIG. LTD','2021-11-01 17:48:06','',''),('5','131',3767328,'','20','3243',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','131',3768412,'','24','3244',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','131',3768504,'','24','3245',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','131',3768885,'','6.1','3241',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','131',3769648,'','2','3246',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','131',3770189,'','22','3242',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','131',3778122,'','20','3243',1284496.95,0.00,'Sales from shift 235928 on 2021-11-03 05:00:11 ','2021-11-03 05:00:11','',''),('5','131',3778123,'','6.1','3241',0.00,1284496.95,'Sales from shift 235928 on 2021-11-03 05:00:11 ','2021-11-03 05:00:11','',''),('5','131',3778124,'','6.1','3241',11700.00,0.00,'Payment Id 354464 for invoice:235928, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-03 05:00:28','',''),('5','131',3778125,'','supplier','140',0.00,11700.00,'Payment Id 354464 for invoice:235928, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-03 05:00:28','',''),('5','131',3778126,'','6.1','3241',7900.00,0.00,'Payment Id 354462 for invoice:235928, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-03 05:00:28','',''),('5','131',3778127,'','supplier','140',0.00,7900.00,'Payment Id 354462 for invoice:235928, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-03 05:00:28','',''),('5','131',3778128,'','2','3246',1264800.00,0.00,'Payment Id 354461 for invoice:235928, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2021-11-03 05:00:28','',''),('5','131',3778129,'','supplier','140',0.00,1264800.00,'Payment Id 354461 for invoice:235928, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2021-11-03 05:00:28','',''),('5','131',3788941,'','6.1','3241',8000.00,0.00,'Payment Id 355006 for invoice:236352, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-03 17:52:08','',''),('5','131',3788942,'','supplier','140',0.00,8000.00,'Payment Id 355006 for invoice:236352, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-03 17:52:08','',''),('5','131',3788943,'','6.1','3241',7900.00,0.00,'Payment Id 355005 for invoice:236352, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-03 17:52:08','',''),('5','131',3788944,'','supplier','140',0.00,7900.00,'Payment Id 355005 for invoice:236352, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-03 17:52:08','',''),('5','131',3788945,'','2','3246',1277500.00,0.00,'Payment Id 355003 for invoice:236352, receipt: 0026 by SALBAS OIL & GAS NIG. LTD','2021-11-03 17:52:08','',''),('5','131',3788946,'','supplier','140',0.00,1277500.00,'Payment Id 355003 for invoice:236352, receipt: 0026 by SALBAS OIL & GAS NIG. LTD','2021-11-03 17:52:08','',''),('5','131',3788949,'','20','3243',1293408.60,0.00,'Sales from shift 236352 on 2021-11-03 17:52:30 ','2021-11-03 17:52:30','',''),('5','131',3788950,'','6.1','3241',0.00,1293408.60,'Sales from shift 236352 on 2021-11-03 17:52:30 ','2021-11-03 17:52:30','',''),('5','131',3804012,'','20','3243',853924.50,0.00,'Sales from shift 236461 on 2021-11-04 18:06:46 ','2021-11-04 18:06:46','',''),('5','131',3804013,'','6.1','3241',0.00,853924.50,'Sales from shift 236461 on 2021-11-04 18:06:46 ','2021-11-04 18:06:46','',''),('5','131',3813550,'','20','3243',0.00,0.00,'Sales from shift 236802 on 2021-11-05 15:12:24 ','2021-11-05 15:12:24','',''),('5','131',3813551,'','6.1','3241',0.00,0.00,'Sales from shift 236802 on 2021-11-05 15:12:24 ','2021-11-05 15:12:24','',''),('5','131',3813619,'','6.1','3241',7900.00,0.00,'Payment Id 355592 for invoice:236461, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-05 15:17:03','',''),('5','131',3813620,'','supplier','140',0.00,7900.00,'Payment Id 355592 for invoice:236461, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-05 15:17:03','',''),('5','131',3813621,'','2','3246',846000.00,0.00,'Payment Id 355591 for invoice:236461, receipt: 026 by SALBAS OIL & GAS NIG. LTD','2021-11-05 15:17:03','',''),('5','131',3813622,'','supplier','140',0.00,846000.00,'Payment Id 355591 for invoice:236461, receipt: 026 by SALBAS OIL & GAS NIG. LTD','2021-11-05 15:17:03','',''),('5','131',3817087,'','20','3243',0.00,0.00,'Sales from shift 236895 on 2021-11-06 06:38:06 ','2021-11-06 06:38:06','',''),('5','131',3817088,'','6.1','3241',0.00,0.00,'Sales from shift 236895 on 2021-11-06 06:38:06 ','2021-11-06 06:38:06','',''),('5','131',3828703,'','20','3243',0.00,0.00,'Sales from shift 237082 on 2021-11-07 07:09:57 ','2021-11-07 07:09:57','',''),('5','131',3828704,'','6.1','3241',0.00,0.00,'Sales from shift 237082 on 2021-11-07 07:09:57 ','2021-11-07 07:09:57','',''),('5','131',3849957,'','20','3243',0.00,0.00,'Sales from shift 237257 on 2021-11-08 21:42:13 ','2021-11-08 21:42:13','',''),('5','131',3849958,'','6.1','3241',0.00,0.00,'Sales from shift 237257 on 2021-11-08 21:42:13 ','2021-11-08 21:42:13','',''),('5','131',3854972,'','20','3243',0.00,0.00,'Sales from shift 237599 on 2021-11-09 10:51:25 ','2021-11-09 10:51:25','',''),('5','131',3854973,'','6.1','3241',0.00,0.00,'Sales from shift 237599 on 2021-11-09 10:51:25 ','2021-11-09 10:51:25','',''),('5','131',3863270,'','20','3243',0.00,0.00,'Sales from shift 237714 on 2021-11-09 18:34:39 ','2021-11-09 18:34:39','',''),('5','131',3863271,'','6.1','3241',0.00,0.00,'Sales from shift 237714 on 2021-11-09 18:34:39 ','2021-11-09 18:34:39','',''),('5','131',3880035,'','20','3243',0.00,0.00,'Sales from shift 237861 on 2021-11-11 09:43:20 ','2021-11-11 09:43:20','',''),('5','131',3880036,'','6.1','3241',0.00,0.00,'Sales from shift 237861 on 2021-11-11 09:43:20 ','2021-11-11 09:43:20','',''),('5','131',3897011,'','24','3245',0.00,2475000.00,'Purchase Id 80342 for 15,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2021-11-12 13:21:50','',''),('5','131',3897012,'','supplier','140',2475000.00,0.00,'Purchase Id 80342 for 15,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2021-11-12 13:21:50','',''),('5','131',3902927,'','6.1','3241',3000.00,0.00,'Payment Id 359686 for invoice:238232, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-13 05:52:59','',''),('5','131',3902928,'','supplier','140',0.00,3000.00,'Payment Id 359686 for invoice:238232, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-13 05:52:59','',''),('5','131',3902929,'','6.1','3241',7900.00,0.00,'Payment Id 359685 for invoice:238232, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-13 05:52:59','',''),('5','131',3902930,'','supplier','140',0.00,7900.00,'Payment Id 359685 for invoice:238232, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-13 05:52:59','',''),('5','131',3902931,'','2','3246',99600.00,0.00,'Payment Id 359684 for invoice:238232, receipt: 032 by SALBAS OIL & GAS NIG. LTD','2021-11-13 05:52:59','',''),('5','131',3902932,'','supplier','140',0.00,99600.00,'Payment Id 359684 for invoice:238232, receipt: 032 by SALBAS OIL & GAS NIG. LTD','2021-11-13 05:52:59','',''),('5','131',3902937,'','20','3243',110518.65,0.00,'Sales from shift 238232 on 2021-11-13 05:53:23 ','2021-11-13 05:53:23','',''),('5','131',3902938,'','6.1','3241',0.00,110518.65,'Sales from shift 238232 on 2021-11-13 05:53:23 ','2021-11-13 05:53:23','',''),('5','131',3918321,'','20','3243',929684.25,0.00,'Sales from shift 238611 on 2021-11-14 09:02:14 ','2021-11-14 09:02:14','',''),('5','131',3918322,'','6.1','3241',0.00,929684.25,'Sales from shift 238611 on 2021-11-14 09:02:14 ','2021-11-14 09:02:14','',''),('5','131',3928511,'','20','3243',930585.15,0.00,'Sales from shift 238903 on 2021-11-15 07:24:03 ','2021-11-15 07:24:03','',''),('5','131',3928512,'','6.1','3241',0.00,930585.15,'Sales from shift 238903 on 2021-11-15 07:24:03 ','2021-11-15 07:24:03','',''),('5','131',3937913,'','6.1','3241',7900.00,0.00,'Payment Id 361264 for invoice:239113, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-15 19:10:11','',''),('5','131',3937914,'','supplier','140',0.00,7900.00,'Payment Id 361264 for invoice:239113, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-15 19:10:11','',''),('5','131',3937915,'','2','3246',331000.00,0.00,'Payment Id 361262 for invoice:239113, receipt: 032 by SALBAS OIL & GAS NIG. LTD','2021-11-15 19:10:11','',''),('5','131',3937916,'','supplier','140',0.00,331000.00,'Payment Id 361262 for invoice:239113, receipt: 032 by SALBAS OIL & GAS NIG. LTD','2021-11-15 19:10:11','',''),('5','131',3937917,'','6.1','3241',7900.00,0.00,'Payment Id 361256 for invoice:238902, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-15 19:10:11','',''),('5','131',3937918,'','supplier','140',0.00,7900.00,'Payment Id 361256 for invoice:238902, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-15 19:10:11','',''),('5','131',3937919,'','2','3246',922680.00,0.00,'Payment Id 361254 for invoice:238902, receipt: 032 by SALBAS OIL & GAS NIG. LTD','2021-11-15 19:10:11','',''),('5','131',3937920,'','supplier','140',0.00,922680.00,'Payment Id 361254 for invoice:238902, receipt: 032 by SALBAS OIL & GAS NIG. LTD','2021-11-15 19:10:11','',''),('5','131',3937921,'','6.1','3241',200000.00,0.00,'Payment Id 361251 for invoice:238611, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-15 19:10:11','',''),('5','131',3937922,'','supplier','140',0.00,200000.00,'Payment Id 361251 for invoice:238611, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-15 19:10:11','',''),('5','131',3937923,'','6.1','3241',219000.00,0.00,'Payment Id 361250 for invoice:238611, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-15 19:10:11','',''),('5','131',3937924,'','supplier','140',0.00,219000.00,'Payment Id 361250 for invoice:238611, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-15 19:10:11','',''),('5','131',3937925,'','6.1','3241',7900.00,0.00,'Payment Id 361249 for invoice:238611, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-15 19:10:11','',''),('5','131',3937926,'','supplier','140',0.00,7900.00,'Payment Id 361249 for invoice:238611, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-15 19:10:11','',''),('5','131',3937927,'','2','3246',502780.00,0.00,'Payment Id 361247 for invoice:238611, receipt: 022 by SALBAS OIL & GAS NIG. LTD','2021-11-15 19:10:11','',''),('5','131',3937928,'','supplier','140',0.00,502780.00,'Payment Id 361247 for invoice:238611, receipt: 022 by SALBAS OIL & GAS NIG. LTD','2021-11-15 19:10:11','',''),('5','131',3940348,'','20','3243',338987.55,0.00,'Sales from shift 239113 on 2021-11-16 08:08:06 ','2021-11-16 08:08:06','',''),('5','131',3940349,'','6.1','3241',0.00,338987.55,'Sales from shift 239113 on 2021-11-16 08:08:06 ','2021-11-16 08:08:06','',''),('5','131',3949930,'','6.1','3241',7900.00,0.00,'Payment Id 361521 for invoice:239356, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-16 20:38:46','',''),('5','131',3949931,'','supplier','140',0.00,7900.00,'Payment Id 361521 for invoice:239356, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-16 20:38:46','',''),('5','131',3949932,'','2','3246',58000.00,0.00,'Payment Id 361519 for invoice:239356, receipt: 022 by SALBAS OIL & GAS NIG. LTD','2021-11-16 20:38:46','',''),('5','131',3949933,'','supplier','140',0.00,58000.00,'Payment Id 361519 for invoice:239356, receipt: 022 by SALBAS OIL & GAS NIG. LTD','2021-11-16 20:38:46','',''),('5','131',3950190,'','20','3243',65917.50,0.00,'Sales from shift 239356 on 2021-11-17 05:38:50 ','2021-11-17 05:38:50','',''),('5','131',3950191,'','6.1','3241',0.00,65917.50,'Sales from shift 239356 on 2021-11-17 05:38:50 ','2021-11-17 05:38:50','',''),('5','131',3961814,'','20','3243',0.00,0.00,'Sales from shift 239550 on 2021-11-17 18:25:25 ','2021-11-17 18:25:25','',''),('5','131',3961815,'','6.1','3241',0.00,0.00,'Sales from shift 239550 on 2021-11-17 18:25:25 ','2021-11-17 18:25:25','',''),('5','131',3962539,'','20','3243',0.00,0.00,'Sales from shift 239750 on 2021-11-18 06:24:33 ','2021-11-18 06:24:33','',''),('5','131',3962540,'','6.1','3241',0.00,0.00,'Sales from shift 239750 on 2021-11-18 06:24:33 ','2021-11-18 06:24:33','',''),('5','131',3974868,'','20','3243',0.00,0.00,'Sales from shift 239795 on 2021-11-19 04:42:02 ','2021-11-19 04:42:02','',''),('5','131',3974869,'','6.1','3241',0.00,0.00,'Sales from shift 239795 on 2021-11-19 04:42:02 ','2021-11-19 04:42:02','',''),('5','131',3979267,'','24','3245',0.00,2145000.00,'Purchase Id 80931 for 13,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2021-11-19 10:46:44','',''),('5','131',3979268,'','supplier','140',2145000.00,0.00,'Purchase Id 80931 for 13,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2021-11-19 10:46:44','',''),('5','131',3986466,'','20','3243',469566.90,0.00,'Sales from shift 239979 on 2021-11-20 06:37:43 ','2021-11-20 06:37:43','',''),('5','131',3986467,'','6.1','3241',0.00,469566.90,'Sales from shift 239979 on 2021-11-20 06:37:43 ','2021-11-20 06:37:43','',''),('5','131',3999240,'','20','3243',1174809.90,0.00,'Sales from shift 240222 on 2021-11-20 20:42:37 ','2021-11-20 20:42:37','',''),('5','131',3999241,'','6.1','3241',0.00,1174809.90,'Sales from shift 240222 on 2021-11-20 20:42:37 ','2021-11-20 20:42:37','',''),('5','131',4012370,'','20','3243',504584.85,0.00,'Sales from shift 240446 on 2021-11-22 06:20:00 ','2021-11-22 06:20:00','',''),('5','131',4012371,'','6.1','3241',0.00,504584.85,'Sales from shift 240446 on 2021-11-22 06:20:00 ','2021-11-22 06:20:00','',''),('5','131',4023493,'','6.1','3241',7900.00,0.00,'Payment Id 364616 for invoice:240446, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-22 17:32:48','',''),('5','131',4023494,'','supplier','140',0.00,7900.00,'Payment Id 364616 for invoice:240446, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-22 17:32:48','',''),('5','131',4023495,'','2','3246',496680.00,0.00,'Payment Id 364614 for invoice:240446, receipt: 0345 by SALBAS OIL & GAS NIG. LTD','2021-11-22 17:32:48','',''),('5','131',4023496,'','supplier','140',0.00,496680.00,'Payment Id 364614 for invoice:240446, receipt: 0345 by SALBAS OIL & GAS NIG. LTD','2021-11-22 17:32:48','',''),('5','131',4023497,'','6.1','3241',7900.00,0.00,'Payment Id 364612 for invoice:240222, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-22 17:32:48','',''),('5','131',4023498,'','supplier','140',0.00,7900.00,'Payment Id 364612 for invoice:240222, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-22 17:32:48','',''),('5','131',4023499,'','2','3246',1166900.00,0.00,'Payment Id 364610 for invoice:240222, receipt: 0345 by SALBAS OIL & GAS NIG. LTD','2021-11-22 17:32:48','',''),('5','131',4023500,'','supplier','140',0.00,1166900.00,'Payment Id 364610 for invoice:240222, receipt: 0345 by SALBAS OIL & GAS NIG. LTD','2021-11-22 17:32:48','',''),('5','131',4023501,'','6.1','3241',7900.00,0.00,'Payment Id 364608 for invoice:239979, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-22 17:32:48','',''),('5','131',4023502,'','supplier','140',0.00,7900.00,'Payment Id 364608 for invoice:239979, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-22 17:32:48','',''),('5','131',4023503,'','2','3246',461600.00,0.00,'Payment Id 364606 for invoice:239979, receipt: 0345 by SALBAS OIL & GAS NIG. LTD','2021-11-22 17:32:48','',''),('5','131',4023504,'','supplier','140',0.00,461600.00,'Payment Id 364606 for invoice:239979, receipt: 0345 by SALBAS OIL & GAS NIG. LTD','2021-11-22 17:32:48','',''),('5','131',4024088,'','20','3243',53662.95,0.00,'Sales from shift 240709 on 2021-11-23 05:37:13 ','2021-11-23 05:37:13','',''),('5','131',4024089,'','6.1','3241',0.00,53662.95,'Sales from shift 240709 on 2021-11-23 05:37:13 ','2021-11-23 05:37:13','',''),('5','131',4026934,'','24','3245',0.00,7425000.00,'Purchase Id 85450 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2021-11-23 08:43:59','',''),('5','131',4026935,'','supplier','140',7425000.00,0.00,'Purchase Id 85450 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2021-11-23 08:43:59','',''),('5','131',4037559,'','6.1','3241',7900.00,0.00,'Payment Id 365323 for invoice:240709, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-23 21:31:40','',''),('5','131',4037560,'','supplier','140',0.00,7900.00,'Payment Id 365323 for invoice:240709, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-23 21:31:40','',''),('5','131',4037561,'','2','3246',45760.00,0.00,'Payment Id 365320 for invoice:240709, receipt: 022 by SALBAS OIL & GAS NIG. LTD','2021-11-23 21:31:40','',''),('5','131',4037562,'','supplier','140',0.00,45760.00,'Payment Id 365320 for invoice:240709, receipt: 022 by SALBAS OIL & GAS NIG. LTD','2021-11-23 21:31:40','',''),('5','131',4038496,'','20','3243',1287107.25,0.00,'Sales from shift 240968 on 2021-11-24 07:04:35 ','2021-11-24 07:04:35','',''),('5','131',4038497,'','6.1','3241',0.00,1287107.25,'Sales from shift 240968 on 2021-11-24 07:04:35 ','2021-11-24 07:04:35','',''),('5','131',4049577,'','6.1','3241',10000.00,0.00,'Payment Id 365858 for invoice:240968, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-25 05:52:45','',''),('5','131',4049578,'','supplier','140',0.00,10000.00,'Payment Id 365858 for invoice:240968, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-25 05:52:45','',''),('5','131',4049579,'','6.1','3241',7900.00,0.00,'Payment Id 365857 for invoice:240968, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-25 05:52:45','',''),('5','131',4049580,'','supplier','140',0.00,7900.00,'Payment Id 365857 for invoice:240968, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-25 05:52:45','',''),('5','131',4049581,'','2','3246',1269200.00,0.00,'Payment Id 365854 for invoice:240968, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2021-11-25 05:52:45','',''),('5','131',4049582,'','supplier','140',0.00,1269200.00,'Payment Id 365854 for invoice:240968, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2021-11-25 05:52:45','',''),('5','131',4049583,'','20','3243',1517827.58,0.00,'Sales from shift 241297 on 2021-11-25 05:53:04 ','2021-11-25 05:53:04','',''),('5','131',4049584,'','6.1','3241',0.00,1517827.58,'Sales from shift 241297 on 2021-11-25 05:53:04 ','2021-11-25 05:53:04','',''),('5','131',4062877,'','6.1','3241',1000.00,0.00,'Payment Id 366361 for invoice:241297, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-26 05:57:19','',''),('5','131',4062878,'','supplier','140',0.00,1000.00,'Payment Id 366361 for invoice:241297, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-26 05:57:19','',''),('5','131',4062879,'','6.1','3241',7900.00,0.00,'Payment Id 366358 for invoice:241297, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-26 05:57:19','',''),('5','131',4062880,'','supplier','140',0.00,7900.00,'Payment Id 366358 for invoice:241297, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-26 05:57:19','',''),('5','131',4062881,'','2','3246',1508900.00,0.00,'Payment Id 366352 for invoice:241297, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2021-11-26 05:57:19','',''),('5','131',4062882,'','supplier','140',0.00,1508900.00,'Payment Id 366352 for invoice:241297, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2021-11-26 05:57:19','',''),('5','131',4062883,'','20','3243',1686476.55,0.00,'Sales from shift 241492 on 2021-11-26 05:57:39 ','2021-11-26 05:57:39','',''),('5','131',4062884,'','6.1','3241',0.00,1686476.55,'Sales from shift 241492 on 2021-11-26 05:57:39 ','2021-11-26 05:57:39','',''),('5','131',4075037,'','6.1','3241',7900.00,0.00,'Payment Id 366973 for invoice:241492, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-27 06:11:39','',''),('5','131',4075038,'','supplier','140',0.00,7900.00,'Payment Id 366973 for invoice:241492, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-27 06:11:39','',''),('5','131',4075039,'','2','3246',1678500.00,0.00,'Payment Id 366972 for invoice:241492, receipt: 026 by SALBAS OIL & GAS NIG. LTD','2021-11-27 06:11:39','',''),('5','131',4075040,'','supplier','140',0.00,1678500.00,'Payment Id 366972 for invoice:241492, receipt: 026 by SALBAS OIL & GAS NIG. LTD','2021-11-27 06:11:39','',''),('5','131',4075043,'','20','3243',1312637.70,0.00,'Sales from shift 241740 on 2021-11-27 06:12:02 ','2021-11-27 06:12:02','',''),('5','131',4075044,'','6.1','3241',0.00,1312637.70,'Sales from shift 241740 on 2021-11-27 06:12:02 ','2021-11-27 06:12:02','',''),('5','131',4089324,'','20','3243',1240900.65,0.00,'Sales from shift 242022 on 2021-11-28 07:30:51 ','2021-11-28 07:30:51','',''),('5','131',4089325,'','6.1','3241',0.00,1240900.65,'Sales from shift 242022 on 2021-11-28 07:30:51 ','2021-11-28 07:30:51','',''),('5','131',4100595,'','20','3243',285331.20,0.00,'Sales from shift 242239 on 2021-11-29 04:58:03 ','2021-11-29 04:58:03','',''),('5','131',4100596,'','6.1','3241',0.00,285331.20,'Sales from shift 242239 on 2021-11-29 04:58:03 ','2021-11-29 04:58:03','',''),('5','131',4113301,'','20','3243',0.00,0.00,'Sales from shift 242515 on 2021-11-30 06:53:52 ','2021-11-30 06:53:52','',''),('5','131',4113302,'','6.1','3241',0.00,0.00,'Sales from shift 242515 on 2021-11-30 06:53:52 ','2021-11-30 06:53:52','',''),('5','131',4113306,'','6.1','3241',7900.00,0.00,'Payment Id 368766 for invoice:242239, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-30 06:54:15','',''),('5','131',4113307,'','supplier','140',0.00,7900.00,'Payment Id 368766 for invoice:242239, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-30 06:54:15','',''),('5','131',4113308,'','2','3246',277430.00,0.00,'Payment Id 368764 for invoice:242239, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2021-11-30 06:54:15','',''),('5','131',4113309,'','supplier','140',0.00,277430.00,'Payment Id 368764 for invoice:242239, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2021-11-30 06:54:15','',''),('5','131',4113310,'','6.1','3241',7900.00,0.00,'Payment Id 368763 for invoice:242022, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-30 06:54:15','',''),('5','131',4113311,'','supplier','140',0.00,7900.00,'Payment Id 368763 for invoice:242022, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-30 06:54:15','',''),('5','131',4113312,'','2','3246',1233000.00,0.00,'Payment Id 368762 for invoice:242022, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2021-11-30 06:54:15','',''),('5','131',4113313,'','supplier','140',0.00,1233000.00,'Payment Id 368762 for invoice:242022, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2021-11-30 06:54:15','',''),('5','131',4113314,'','6.1','3241',7900.00,0.00,'Payment Id 368758 for invoice:241740, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-30 06:54:15','',''),('5','131',4113315,'','supplier','140',0.00,7900.00,'Payment Id 368758 for invoice:241740, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-11-30 06:54:15','',''),('5','131',4113316,'','2','3246',1304700.00,0.00,'Payment Id 368757 for invoice:241740, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2021-11-30 06:54:15','',''),('5','131',4113317,'','supplier','140',0.00,1304700.00,'Payment Id 368757 for invoice:241740, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2021-11-30 06:54:15','',''),('5','131',4126484,'','20','3243',0.00,0.00,'Sales from shift 242772 on 2021-12-01 05:25:43 ','2021-12-01 05:25:43','',''),('5','131',4126485,'','6.1','3241',0.00,0.00,'Sales from shift 242772 on 2021-12-01 05:25:43 ','2021-12-01 05:25:43','',''),('5','131',4138894,'','20','3243',0.00,0.00,'Sales from shift 242963 on 2021-12-01 20:00:51 ','2021-12-01 20:00:51','',''),('5','131',4138895,'','6.1','3241',0.00,0.00,'Sales from shift 242963 on 2021-12-01 20:00:51 ','2021-12-01 20:00:51','',''),('5','131',4151744,'','24','3245',0.00,2491500.00,'Purchase Id 86191 for 15,100.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2021-12-02 16:45:16','',''),('5','131',4151745,'','supplier','140',2491500.00,0.00,'Purchase Id 86191 for 15,100.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2021-12-02 16:45:16','',''),('5','131',4153563,'','20','3243',1022749.20,0.00,'Sales from shift 243162 on 2021-12-03 05:33:59 ','2021-12-03 05:33:59','',''),('5','131',4153564,'','6.1','3241',0.00,1022749.20,'Sales from shift 243162 on 2021-12-03 05:33:59 ','2021-12-03 05:33:59','',''),('5','131',4164871,'','24','3245',0.00,2496450.00,'Purchase Id 86306 for 15,130.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2021-12-03 16:36:17','',''),('5','131',4164872,'','supplier','140',2496450.00,0.00,'Purchase Id 86306 for 15,130.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2021-12-03 16:36:17','',''),('5','131',4178481,'','20','3243',1561797.60,0.00,'Sales from shift 243423 on 2021-12-04 17:39:52 ','2021-12-04 17:39:52','',''),('5','131',4178482,'','6.1','3241',0.00,1561797.60,'Sales from shift 243423 on 2021-12-04 17:39:52 ','2021-12-04 17:39:52','',''),('5','131',4205491,'','6.1','3241',11700.00,0.00,'Payment Id 371044 for invoice:243162, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-12-07 06:15:25','',''),('5','131',4205492,'','supplier','140',0.00,11700.00,'Payment Id 371044 for invoice:243162, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-12-07 06:15:25','',''),('5','131',4205493,'','6.1','3241',7900.00,0.00,'Payment Id 371042 for invoice:243162, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-12-07 06:15:25','',''),('5','131',4205494,'','supplier','140',0.00,7900.00,'Payment Id 371042 for invoice:243162, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-12-07 06:15:25','',''),('5','131',4205495,'','2','3246',1003140.00,0.00,'Payment Id 371040 for invoice:243162, receipt: 022 by SALBAS OIL & GAS NIG. LTD','2021-12-07 06:15:25','',''),('5','131',4205496,'','supplier','140',0.00,1003140.00,'Payment Id 371040 for invoice:243162, receipt: 022 by SALBAS OIL & GAS NIG. LTD','2021-12-07 06:15:25','',''),('5','131',4205501,'','20','3243',1741352.25,0.00,'Sales from shift 243797 on 2021-12-07 06:15:56 ','2021-12-07 06:15:56','',''),('5','131',4205502,'','6.1','3241',0.00,1741352.25,'Sales from shift 243797 on 2021-12-07 06:15:56 ','2021-12-07 06:15:56','',''),('5','131',4217820,'','20','3243',580242.30,0.00,'Sales from shift 244309 on 2021-12-07 16:19:12 ','2021-12-07 16:19:12','',''),('5','131',4217821,'','6.1','3241',0.00,580242.30,'Sales from shift 244309 on 2021-12-07 16:19:12 ','2021-12-07 16:19:12','',''),('5','131',4218091,'','24','3245',0.00,6600000.00,'Purchase Id 86582 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2021-12-07 16:32:00','',''),('5','131',4218092,'','supplier','140',6600000.00,0.00,'Purchase Id 86582 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2021-12-07 16:32:00','',''),('5','131',4219816,'','6.1','3241',5000.00,0.00,'Payment Id 372894 for invoice:244309, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-12-07 21:44:27','',''),('5','131',4219817,'','supplier','140',0.00,5000.00,'Payment Id 372894 for invoice:244309, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-12-07 21:44:27','',''),('5','131',4219818,'','6.1','3241',7900.00,0.00,'Payment Id 372892 for invoice:244309, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-12-07 21:44:27','',''),('5','131',4219819,'','supplier','140',0.00,7900.00,'Payment Id 372892 for invoice:244309, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-12-07 21:44:27','',''),('5','131',4219820,'','2','3246',572340.00,0.00,'Payment Id 372891 for invoice:244309, receipt: 022 by SALBAS OIL & GAS NIG. LTD','2021-12-07 21:44:27','',''),('5','131',4219821,'','supplier','140',0.00,572340.00,'Payment Id 372891 for invoice:244309, receipt: 022 by SALBAS OIL & GAS NIG. LTD','2021-12-07 21:44:27','',''),('5','131',4219822,'','6.1','3241',7900.00,0.00,'Payment Id 372889 for invoice:243797, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-12-07 21:44:27','',''),('5','131',4219823,'','supplier','140',0.00,7900.00,'Payment Id 372889 for invoice:243797, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-12-07 21:44:27','',''),('5','131',4219824,'','2','3246',1733450.00,0.00,'Payment Id 372888 for invoice:243797, receipt: 022 by SALBAS OIL & GAS NIG. LTD','2021-12-07 21:44:27','',''),('5','131',4219825,'','supplier','140',0.00,1733450.00,'Payment Id 372888 for invoice:243797, receipt: 022 by SALBAS OIL & GAS NIG. LTD','2021-12-07 21:44:27','',''),('5','131',4219826,'','6.1','3241',9500.00,0.00,'Payment Id 372886 for invoice:243423, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-12-07 21:44:27','',''),('5','131',4219827,'','supplier','140',0.00,9500.00,'Payment Id 372886 for invoice:243423, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-12-07 21:44:27','',''),('5','131',4219828,'','6.1','3241',5000.00,0.00,'Payment Id 372884 for invoice:243423, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-12-07 21:44:27','',''),('5','131',4219829,'','supplier','140',0.00,5000.00,'Payment Id 372884 for invoice:243423, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-12-07 21:44:27','',''),('5','131',4219830,'','6.1','3241',7900.00,0.00,'Payment Id 372883 for invoice:243423, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-12-07 21:44:27','',''),('5','131',4219831,'','supplier','140',0.00,7900.00,'Payment Id 372883 for invoice:243423, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-12-07 21:44:27','',''),('5','131',4219832,'','2','3246',1561797.60,0.00,'Payment Id 372881 for invoice:243423, receipt: 022 by SALBAS OIL & GAS NIG. LTD','2021-12-07 21:44:27','',''),('5','131',4219833,'','supplier','140',0.00,1561797.60,'Payment Id 372881 for invoice:243423, receipt: 022 by SALBAS OIL & GAS NIG. LTD','2021-12-07 21:44:27','',''),('5','131',4220747,'','20','3243',0.00,0.00,'Sales from shift 244498 on 2021-12-08 07:06:46 ','2021-12-08 07:06:46','',''),('5','131',4220748,'','6.1','3241',0.00,0.00,'Sales from shift 244498 on 2021-12-08 07:06:46 ','2021-12-08 07:06:46','',''),('5','131',4226379,'','20','3243',389706.90,0.00,'Sales from shift 244569 on 2021-12-08 13:09:44 ','2021-12-08 13:09:44','',''),('5','131',4226380,'','6.1','3241',0.00,389706.90,'Sales from shift 244569 on 2021-12-08 13:09:44 ','2021-12-08 13:09:44','',''),('5','131',4234713,'','20','3243',1602654.90,0.00,'Sales from shift 244683 on 2021-12-09 08:26:09 ','2021-12-09 08:26:09','',''),('5','131',4234714,'','6.1','3241',0.00,1602654.90,'Sales from shift 244683 on 2021-12-09 08:26:09 ','2021-12-09 08:26:09','',''),('5','131',4234719,'','6.1','3241',219000.00,0.00,'Payment Id 373641 for invoice:244569, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-12-09 08:26:35','',''),('5','131',4234720,'','supplier','140',0.00,219000.00,'Payment Id 373641 for invoice:244569, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-12-09 08:26:35','',''),('5','131',4234721,'','6.1','3241',7900.00,0.00,'Payment Id 373639 for invoice:244569, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-12-09 08:26:35','',''),('5','131',4234722,'','supplier','140',0.00,7900.00,'Payment Id 373639 for invoice:244569, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-12-09 08:26:35','',''),('5','131',4234723,'','2','3246',162800.00,0.00,'Payment Id 373637 for invoice:244569, receipt: 032 by SALBAS OIL & GAS NIG. LTD','2021-12-09 08:26:35','',''),('5','131',4234724,'','supplier','140',0.00,162800.00,'Payment Id 373637 for invoice:244569, receipt: 032 by SALBAS OIL & GAS NIG. LTD','2021-12-09 08:26:35','',''),('5','131',4245721,'','6.1','3241',50000.00,0.00,'Payment Id 373972 for invoice:244683, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-12-09 18:16:39','',''),('5','131',4245722,'','supplier','140',0.00,50000.00,'Payment Id 373972 for invoice:244683, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-12-09 18:16:39','',''),('5','131',4245723,'','6.1','3241',7900.00,0.00,'Payment Id 373969 for invoice:244683, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-12-09 18:16:39','',''),('5','131',4245724,'','supplier','140',0.00,7900.00,'Payment Id 373969 for invoice:244683, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-12-09 18:16:39','',''),('5','131',4245725,'','2','3246',1543750.00,0.00,'Payment Id 373967 for invoice:244683, receipt: 026 by SALBAS OIL & GAS NIG. LTD','2021-12-09 18:16:39','',''),('5','131',4245726,'','supplier','140',0.00,1543750.00,'Payment Id 373967 for invoice:244683, receipt: 026 by SALBAS OIL & GAS NIG. LTD','2021-12-09 18:16:39','',''),('5','131',4249547,'','20','3243',1996039.65,0.00,'Sales from shift 244811 on 2021-12-10 09:22:03 ','2021-12-10 09:22:03','',''),('5','131',4249548,'','6.1','3241',0.00,1996039.65,'Sales from shift 244811 on 2021-12-10 09:22:03 ','2021-12-10 09:22:03','',''),('5','131',4271605,'','20','3243',1405958.40,0.00,'Sales from shift 245068 on 2021-12-11 17:29:20 ','2021-12-11 17:29:20','',''),('5','131',4271606,'','6.1','3241',0.00,1405958.40,'Sales from shift 245068 on 2021-12-11 17:29:20 ','2021-12-11 17:29:20','',''),('5','131',4271609,'','6.1','3241',7900.00,0.00,'Payment Id 374490 for invoice:244811, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-12-11 17:29:34','',''),('5','131',4271610,'','supplier','140',0.00,7900.00,'Payment Id 374490 for invoice:244811, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-12-11 17:29:34','',''),('5','131',4271611,'','2','3246',1989130.00,0.00,'Payment Id 374489 for invoice:244811, receipt: 022 by SALBAS OIL & GAS NIG. LTD','2021-12-11 17:29:34','',''),('5','131',4271612,'','supplier','140',0.00,1989130.00,'Payment Id 374489 for invoice:244811, receipt: 022 by SALBAS OIL & GAS NIG. LTD','2021-12-11 17:29:34','',''),('5','131',4272598,'','20','3243',1158309.90,0.00,'Sales from shift 245401 on 2021-12-11 20:37:06 ','2021-12-11 20:37:06','',''),('5','131',4272599,'','6.1','3241',0.00,1158309.90,'Sales from shift 245401 on 2021-12-11 20:37:06 ','2021-12-11 20:37:06','',''),('5','131',4290595,'','20','3243',0.00,0.00,'Sales from shift 245620 on 2021-12-13 11:11:50 ','2021-12-13 11:11:50','',''),('5','131',4290596,'','6.1','3241',0.00,0.00,'Sales from shift 245620 on 2021-12-13 11:11:50 ','2021-12-13 11:11:50','',''),('5','131',4306016,'','20','3243',0.00,0.00,'Sales from shift 246052 on 2021-12-14 14:35:18 ','2021-12-14 14:35:18','',''),('5','131',4306017,'','6.1','3241',0.00,0.00,'Sales from shift 246052 on 2021-12-14 14:35:18 ','2021-12-14 14:35:18','',''),('5','131',4306026,'','6.1','3241',12000.00,0.00,'Payment Id 376510 for invoice:245401, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-12-14 14:35:38','',''),('5','131',4306027,'','supplier','140',0.00,12000.00,'Payment Id 376510 for invoice:245401, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-12-14 14:35:38','',''),('5','131',4306028,'','6.1','3241',7900.00,0.00,'Payment Id 376509 for invoice:245401, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-12-14 14:35:38','',''),('5','131',4306029,'','supplier','140',0.00,7900.00,'Payment Id 376509 for invoice:245401, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-12-14 14:35:38','',''),('5','131',4306030,'','2','3246',1138400.00,0.00,'Payment Id 376508 for invoice:245401, receipt: 022 by SALBAS OIL & GAS NIG. LTD','2021-12-14 14:35:38','',''),('5','131',4306031,'','supplier','140',0.00,1138400.00,'Payment Id 376508 for invoice:245401, receipt: 022 by SALBAS OIL & GAS NIG. LTD','2021-12-14 14:35:38','',''),('5','131',4306032,'','6.1','3241',7900.00,0.00,'Payment Id 376504 for invoice:245068, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-12-14 14:35:38','',''),('5','131',4306033,'','supplier','140',0.00,7900.00,'Payment Id 376504 for invoice:245068, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-12-14 14:35:38','',''),('5','131',4306034,'','2','3246',1398000.00,0.00,'Payment Id 376503 for invoice:245068, receipt: 022 by SALBAS OIL & GAS NIG. LTD','2021-12-14 14:35:38','',''),('5','131',4306035,'','supplier','140',0.00,1398000.00,'Payment Id 376503 for invoice:245068, receipt: 022 by SALBAS OIL & GAS NIG. LTD','2021-12-14 14:35:38','',''),('5','131',4312780,'','20','3243',0.00,0.00,'Sales from shift 246178 on 2021-12-15 09:02:49 ','2021-12-15 09:02:49','',''),('5','131',4312781,'','6.1','3241',0.00,0.00,'Sales from shift 246178 on 2021-12-15 09:02:49 ','2021-12-15 09:02:49','',''),('5','131',4327337,'','20','3243',0.00,0.00,'Sales from shift 246328 on 2021-12-16 08:39:45 ','2021-12-16 08:39:45','',''),('5','131',4327338,'','6.1','3241',0.00,0.00,'Sales from shift 246328 on 2021-12-16 08:39:45 ','2021-12-16 08:39:45','',''),('5','131',4342350,'','20','3243',0.00,0.00,'Sales from shift 246519 on 2021-12-17 09:09:56 ','2021-12-17 09:09:56','',''),('5','131',4342351,'','6.1','3241',0.00,0.00,'Sales from shift 246519 on 2021-12-17 09:09:56 ','2021-12-17 09:09:56','',''),('5','131',4349396,'','24','3245',0.00,4950000.00,'Purchase Id 87434 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2021-12-17 15:45:22','',''),('5','131',4349397,'','supplier','140',4950000.00,0.00,'Purchase Id 87434 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2021-12-17 15:45:22','',''),('5','131',4381689,'','20','3243',847327.80,0.00,'Sales from shift 246789 on 2021-12-19 17:33:20 ','2021-12-19 17:33:20','',''),('5','131',4381690,'','6.1','3241',0.00,847327.80,'Sales from shift 246789 on 2021-12-19 17:33:20 ','2021-12-19 17:33:20','',''),('5','131',4382372,'','20','3243',1400584.35,0.00,'Sales from shift 247352 on 2021-12-20 06:12:32 ','2021-12-20 06:12:32','',''),('5','131',4382373,'','6.1','3241',0.00,1400584.35,'Sales from shift 247352 on 2021-12-20 06:12:32 ','2021-12-20 06:12:32','',''),('5','131',4394454,'','6.1','3241',7900.00,0.00,'Payment Id 379611 for invoice:247422, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-12-20 18:03:10','',''),('5','131',4394455,'','supplier','140',0.00,7900.00,'Payment Id 379611 for invoice:247422, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-12-20 18:03:10','',''),('5','131',4394456,'','2','3246',1615900.00,0.00,'Payment Id 379609 for invoice:247422, receipt: 032 by SALBAS OIL & GAS NIG. LTD','2021-12-20 18:03:10','',''),('5','131',4394457,'','supplier','140',0.00,1615900.00,'Payment Id 379609 for invoice:247422, receipt: 032 by SALBAS OIL & GAS NIG. LTD','2021-12-20 18:03:10','',''),('5','131',4394458,'','6.1','3241',5000.00,0.00,'Payment Id 379606 for invoice:247352, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-12-20 18:03:10','',''),('5','131',4394459,'','supplier','140',0.00,5000.00,'Payment Id 379606 for invoice:247352, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-12-20 18:03:10','',''),('5','131',4394460,'','6.1','3241',7900.00,0.00,'Payment Id 379603 for invoice:247352, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-12-20 18:03:10','',''),('5','131',4394461,'','supplier','140',0.00,7900.00,'Payment Id 379603 for invoice:247352, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-12-20 18:03:10','',''),('5','131',4394462,'','2','3246',1387600.00,0.00,'Payment Id 379602 for invoice:247352, receipt: 032 by SALBAS OIL & GAS NIG. LTD','2021-12-20 18:03:10','',''),('5','131',4394463,'','supplier','140',0.00,1387600.00,'Payment Id 379602 for invoice:247352, receipt: 032 by SALBAS OIL & GAS NIG. LTD','2021-12-20 18:03:10','',''),('5','131',4394464,'','2','3246',1387600.00,0.00,'Payment Id 379601 for invoice:247352, receipt: 032 by SALBAS OIL & GAS NIG. LTD','2021-12-20 18:03:10','',''),('5','131',4394465,'','supplier','140',0.00,1387600.00,'Payment Id 379601 for invoice:247352, receipt: 032 by SALBAS OIL & GAS NIG. LTD','2021-12-20 18:03:10','',''),('5','131',4394466,'','6.1','3241',7900.00,0.00,'Payment Id 379599 for invoice:247422, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-12-20 18:03:10','',''),('5','131',4394467,'','supplier','140',0.00,7900.00,'Payment Id 379599 for invoice:247422, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-12-20 18:03:10','',''),('5','131',4394468,'','2','3246',839420.00,0.00,'Payment Id 379597 for invoice:246789, receipt: 032 by SALBAS OIL & GAS NIG. LTD','2021-12-20 18:03:10','',''),('5','131',4394469,'','supplier','140',0.00,839420.00,'Payment Id 379597 for invoice:246789, receipt: 032 by SALBAS OIL & GAS NIG. LTD','2021-12-20 18:03:10','',''),('5','131',4394472,'','20','3243',1623849.15,0.00,'Sales from shift 247422 on 2021-12-20 18:03:32 ','2021-12-20 18:03:32','',''),('5','131',4394473,'','6.1','3241',0.00,1623849.15,'Sales from shift 247422 on 2021-12-20 18:03:32 ','2021-12-20 18:03:32','',''),('5','131',4426102,'','20','3243',863152.95,0.00,'Sales from shift 248082 on 2021-12-23 04:54:46 ','2021-12-23 04:54:46','',''),('5','131',4426103,'','6.1','3241',0.00,863152.95,'Sales from shift 248082 on 2021-12-23 04:54:46 ','2021-12-23 04:54:46','',''),('5','131',4426104,'','6.1','3241',70000.00,0.00,'Payment Id 381003 for invoice:248082, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-12-23 04:55:02','',''),('5','131',4426105,'','supplier','140',0.00,70000.00,'Payment Id 381003 for invoice:248082, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-12-23 04:55:02','',''),('5','131',4426106,'','6.1','3241',7900.00,0.00,'Payment Id 381002 for invoice:248082, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-12-23 04:55:02','',''),('5','131',4426107,'','supplier','140',0.00,7900.00,'Payment Id 381002 for invoice:248082, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-12-23 04:55:02','',''),('5','131',4426108,'','2','3246',785250.00,0.00,'Payment Id 381001 for invoice:248082, receipt: 026 by SALBAS OIL & GAS NIG. LTD','2021-12-23 04:55:02','',''),('5','131',4426109,'','supplier','140',0.00,785250.00,'Payment Id 381001 for invoice:248082, receipt: 026 by SALBAS OIL & GAS NIG. LTD','2021-12-23 04:55:02','',''),('5','131',4430072,'','20','3243',149999.85,0.00,'Sales from shift 248234 on 2021-12-23 09:42:40 ','2021-12-23 09:42:40','',''),('5','131',4430073,'','6.1','3241',0.00,149999.85,'Sales from shift 248234 on 2021-12-23 09:42:40 ','2021-12-23 09:42:40','',''),('5','131',4430106,'','6.1','3241',7900.00,0.00,'Payment Id 381254 for invoice:248234, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-12-23 09:44:03','',''),('5','131',4430107,'','supplier','140',0.00,7900.00,'Payment Id 381254 for invoice:248234, receipt:  by SALBAS OIL & GAS NIG. LTD','2021-12-23 09:44:03','',''),('5','131',4430108,'','2','3246',142100.00,0.00,'Payment Id 381253 for invoice:248234, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2021-12-23 09:44:03','',''),('5','131',4430109,'','supplier','140',0.00,142100.00,'Payment Id 381253 for invoice:248234, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2021-12-23 09:44:03','',''),('5','131',4453095,'','20','3243',0.00,0.00,'Sales from shift 248267 on 2021-12-24 14:08:30 ','2021-12-24 14:08:30','',''),('5','131',4453096,'','6.1','3241',0.00,0.00,'Sales from shift 248267 on 2021-12-24 14:08:30 ','2021-12-24 14:08:30','',''),('5','131',4470891,'','20','3243',0.00,0.00,'Sales from shift 248527 on 2021-12-25 17:06:20 ','2021-12-25 17:06:20','',''),('5','131',4470892,'','6.1','3241',0.00,0.00,'Sales from shift 248527 on 2021-12-25 17:06:20 ','2021-12-25 17:06:20','',''),('5','131',4472083,'','20','3243',0.00,0.00,'Sales from shift 248872 on 2021-12-26 07:24:52 ','2021-12-26 07:24:52','',''),('5','131',4472084,'','6.1','3241',0.00,0.00,'Sales from shift 248872 on 2021-12-26 07:24:52 ','2021-12-26 07:24:52','',''),('5','131',4480676,'','20','3243',0.00,0.00,'Sales from shift 248972 on 2021-12-27 05:57:54 ','2021-12-27 05:57:54','',''),('5','131',4480677,'','6.1','3241',0.00,0.00,'Sales from shift 248972 on 2021-12-27 05:57:54 ','2021-12-27 05:57:54','',''),('5','131',4493849,'','20','3243',0.00,0.00,'Sales from shift 249119 on 2021-12-28 09:21:26 ','2021-12-28 09:21:26','',''),('5','131',4493850,'','6.1','3241',0.00,0.00,'Sales from shift 249119 on 2021-12-28 09:21:26 ','2021-12-28 09:21:26','',''),('5','131',4502770,'','20','3243',0.00,0.00,'Sales from shift 249498 on 2021-12-29 06:57:52 ','2021-12-29 06:57:52','',''),('5','131',4502771,'','6.1','3241',0.00,0.00,'Sales from shift 249498 on 2021-12-29 06:57:52 ','2021-12-29 06:57:52','',''),('5','131',4514991,'','20','3243',0.00,0.00,'Sales from shift 249626 on 2021-12-30 06:45:10 ','2021-12-30 06:45:10','',''),('5','131',4514992,'','6.1','3241',0.00,0.00,'Sales from shift 249626 on 2021-12-30 06:45:10 ','2021-12-30 06:45:10','',''),('5','131',4533353,'','20','3243',0.00,0.00,'Sales from shift 249906 on 2021-12-31 09:24:48 ','2021-12-31 09:24:48','',''),('5','131',4533354,'','6.1','3241',0.00,0.00,'Sales from shift 249906 on 2021-12-31 09:24:48 ','2021-12-31 09:24:48','',''),('5','131',4536090,'','20','3243',0.00,0.00,'Sales from shift 250177 on 2021-12-31 11:42:36 ','2021-12-31 11:42:36','',''),('5','131',4536091,'','6.1','3241',0.00,0.00,'Sales from shift 250177 on 2021-12-31 11:42:36 ','2021-12-31 11:42:36','',''),('5','131',4544043,'','20','3243',0.00,0.00,'Sales from shift 250217 on 2022-01-01 07:41:45 ','2022-01-01 07:41:45','',''),('5','131',4544044,'','6.1','3241',0.00,0.00,'Sales from shift 250217 on 2022-01-01 07:41:45 ','2022-01-01 07:41:45','',''),('5','131',4555008,'','20','3243',0.00,0.00,'Sales from shift 250390 on 2022-01-02 08:06:12 ','2022-01-02 08:06:12','',''),('5','131',4555009,'','6.1','3241',0.00,0.00,'Sales from shift 250390 on 2022-01-02 08:06:12 ','2022-01-02 08:06:12','',''),('5','131',4563958,'','20','3243',0.00,0.00,'Sales from shift 250606 on 2022-01-03 06:57:41 ','2022-01-03 06:57:41','',''),('5','131',4563959,'','6.1','3241',0.00,0.00,'Sales from shift 250606 on 2022-01-03 06:57:41 ','2022-01-03 06:57:41','',''),('5','131',4577052,'','20','3243',0.00,0.00,'Sales from shift 250829 on 2022-01-04 08:41:51 ','2022-01-04 08:41:51','',''),('5','131',4577053,'','6.1','3241',0.00,0.00,'Sales from shift 250829 on 2022-01-04 08:41:51 ','2022-01-04 08:41:51','',''),('5','131',4602363,'','24','3245',0.00,6509250.00,'Purchase Id 88913 for 39,450.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-01-05 17:36:22','',''),('5','131',4602364,'','supplier','140',6509250.00,0.00,'Purchase Id 88913 for 39,450.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-01-05 17:36:22','',''),('5','131',4606356,'','20','3243',0.00,0.00,'Sales from shift 251085 on 2022-01-06 09:24:25 ','2022-01-06 09:24:25','',''),('5','131',4606357,'','6.1','3241',0.00,0.00,'Sales from shift 251085 on 2022-01-06 09:24:25 ','2022-01-06 09:24:25','',''),('5','131',4609651,'','20','3243',701141.10,0.00,'Sales from shift 251586 on 2022-01-06 12:25:53 ','2022-01-06 12:25:53','',''),('5','131',4609652,'','6.1','3241',0.00,701141.10,'Sales from shift 251586 on 2022-01-06 12:25:53 ','2022-01-06 12:25:53','',''),('5','131',4617402,'','6.1','3241',11700.00,0.00,'Payment Id 388355 for invoice:251586, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-01-07 07:01:56','',''),('5','131',4617403,'','supplier','140',0.00,11700.00,'Payment Id 388355 for invoice:251586, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-01-07 07:01:56','',''),('5','131',4617404,'','6.1','3241',219000.00,0.00,'Payment Id 388353 for invoice:251586, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-01-07 07:01:56','',''),('5','131',4617405,'','supplier','140',0.00,219000.00,'Payment Id 388353 for invoice:251586, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-01-07 07:01:56','',''),('5','131',4617406,'','6.1','3241',7900.00,0.00,'Payment Id 388350 for invoice:251586, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-01-07 07:01:56','',''),('5','131',4617407,'','supplier','140',0.00,7900.00,'Payment Id 388350 for invoice:251586, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-01-07 07:01:56','',''),('5','131',4617408,'','2','3246',470400.00,0.00,'Payment Id 388348 for invoice:251586, receipt: 026 by SALBAS OIL & GAS NIG. LTD','2022-01-07 07:01:56','',''),('5','131',4617409,'','supplier','140',0.00,470400.00,'Payment Id 388348 for invoice:251586, receipt: 026 by SALBAS OIL & GAS NIG. LTD','2022-01-07 07:01:56','',''),('5','131',4620508,'','20','3243',1866833.10,0.00,'Sales from shift 251670 on 2022-01-07 10:15:28 ','2022-01-07 10:15:28','',''),('5','131',4620509,'','6.1','3241',0.00,1866833.10,'Sales from shift 251670 on 2022-01-07 10:15:28 ','2022-01-07 10:15:28','',''),('5','131',4630837,'','20','3243',1254115.50,0.00,'Sales from shift 251841 on 2022-01-08 08:07:19 ','2022-01-08 08:07:19','',''),('5','131',4630838,'','6.1','3241',0.00,1254115.50,'Sales from shift 251841 on 2022-01-08 08:07:19 ','2022-01-08 08:07:19','',''),('5','131',4630856,'','6.1','3241',7900.00,0.00,'Payment Id 388973 for invoice:251670, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-01-08 08:08:07','',''),('5','131',4630857,'','supplier','140',0.00,7900.00,'Payment Id 388973 for invoice:251670, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-01-08 08:08:07','',''),('5','131',4630858,'','2','3246',1851040.00,0.00,'Payment Id 388972 for invoice:251670, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2022-01-08 08:08:07','',''),('5','131',4630859,'','supplier','140',0.00,1851040.00,'Payment Id 388972 for invoice:251670, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2022-01-08 08:08:07','',''),('5','131',4654068,'','20','3243',1295322.60,0.00,'Sales from shift 252053 on 2022-01-09 15:50:17 ','2022-01-09 15:50:17','',''),('5','131',4654069,'','6.1','3241',0.00,1295322.60,'Sales from shift 252053 on 2022-01-09 15:50:17 ','2022-01-09 15:50:17','',''),('5','131',4678802,'','20','3243',1034437.80,0.00,'Sales from shift 252831 on 2022-01-11 14:02:41 ','2022-01-11 14:02:41','',''),('5','131',4678803,'','6.1','3241',0.00,1034437.80,'Sales from shift 252831 on 2022-01-11 14:02:41 ','2022-01-11 14:02:41','',''),('5','131',4679866,'','20','3243',517839.30,0.00,'Sales from shift 252856 on 2022-01-11 14:46:22 ','2022-01-11 14:46:22','',''),('5','131',4679867,'','6.1','3241',0.00,517839.30,'Sales from shift 252856 on 2022-01-11 14:46:22 ','2022-01-11 14:46:22','',''),('5','131',4686702,'','20','3243',0.00,0.00,'Sales from shift 252898 on 2022-01-12 08:12:46 ','2022-01-12 08:12:46','',''),('5','131',4686703,'','6.1','3241',0.00,0.00,'Sales from shift 252898 on 2022-01-12 08:12:46 ','2022-01-12 08:12:46','',''),('5','131',4686704,'','6.1','3241',7900.00,0.00,'Payment Id 391337 for invoice:252856, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-01-12 08:13:14','',''),('5','131',4686705,'','supplier','140',0.00,7900.00,'Payment Id 391337 for invoice:252856, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-01-12 08:13:14','',''),('5','131',4686706,'','2','3246',509900.00,0.00,'Payment Id 391336 for invoice:252856, receipt: 032 by SALBAS OIL & GAS NIG. LTD','2022-01-12 08:13:14','',''),('5','131',4686707,'','supplier','140',0.00,509900.00,'Payment Id 391336 for invoice:252856, receipt: 032 by SALBAS OIL & GAS NIG. LTD','2022-01-12 08:13:14','',''),('5','131',4686708,'','6.1','3241',7900.00,0.00,'Payment Id 391172 for invoice:252053, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-01-12 08:13:14','',''),('5','131',4686709,'','supplier','140',0.00,7900.00,'Payment Id 391172 for invoice:252053, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-01-12 08:13:14','',''),('5','131',4686710,'','2','3246',1287400.00,0.00,'Payment Id 391169 for invoice:252053, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2022-01-12 08:13:14','',''),('5','131',4686711,'','supplier','140',0.00,1287400.00,'Payment Id 391169 for invoice:252053, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2022-01-12 08:13:14','',''),('5','131',4686712,'','6.1','3241',7900.00,0.00,'Payment Id 391166 for invoice:251841, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-01-12 08:13:14','',''),('5','131',4686713,'','supplier','140',0.00,7900.00,'Payment Id 391166 for invoice:251841, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-01-12 08:13:14','',''),('5','131',4686714,'','2','3246',1246215.00,0.00,'Payment Id 391163 for invoice:251841, receipt: 026 by SALBAS OIL & GAS NIG. LTD','2022-01-12 08:13:14','',''),('5','131',4686715,'','supplier','140',0.00,1246215.00,'Payment Id 391163 for invoice:251841, receipt: 026 by SALBAS OIL & GAS NIG. LTD','2022-01-12 08:13:14','',''),('5','131',4686716,'','6.1','3241',7900.00,0.00,'Payment Id 391160 for invoice:252831, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-01-12 08:13:14','',''),('5','131',4686717,'','supplier','140',0.00,7900.00,'Payment Id 391160 for invoice:252831, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-01-12 08:13:14','',''),('5','131',4686718,'','2','3246',1026500.00,0.00,'Payment Id 391159 for invoice:252831, receipt: 022 by SALBAS OIL & GAS NIG. LTD','2022-01-12 08:13:14','',''),('5','131',4686719,'','supplier','140',0.00,1026500.00,'Payment Id 391159 for invoice:252831, receipt: 022 by SALBAS OIL & GAS NIG. LTD','2022-01-12 08:13:14','',''),('5','131',4701710,'','20','3243',0.00,0.00,'Sales from shift 253050 on 2022-01-13 08:28:55 ','2022-01-13 08:28:55','',''),('5','131',4701711,'','6.1','3241',0.00,0.00,'Sales from shift 253050 on 2022-01-13 08:28:55 ','2022-01-13 08:28:55','',''),('5','131',4714240,'','20','3243',0.00,0.00,'Sales from shift 253320 on 2022-01-14 06:37:01 ','2022-01-14 06:37:01','',''),('5','131',4714241,'','6.1','3241',0.00,0.00,'Sales from shift 253320 on 2022-01-14 06:37:01 ','2022-01-14 06:37:01','',''),('5','131',4717497,'','24','3245',0.00,2145000.00,'Purchase Id 89521 for 13,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-01-14 10:10:25','',''),('5','131',4717498,'','supplier','140',2145000.00,0.00,'Purchase Id 89521 for 13,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-01-14 10:10:25','',''),('5','131',4729809,'','20','3243',822401.25,0.00,'Sales from shift 253525 on 2022-01-15 09:07:32 ','2022-01-15 09:07:32','',''),('5','131',4729810,'','6.1','3241',0.00,822401.25,'Sales from shift 253525 on 2022-01-15 09:07:32 ','2022-01-15 09:07:32','',''),('5','131',4743798,'','20','3243',923632.05,0.00,'Sales from shift 253778 on 2022-01-16 06:38:51 ','2022-01-16 06:38:51','',''),('5','131',4743799,'','6.1','3241',0.00,923632.05,'Sales from shift 253778 on 2022-01-16 06:38:51 ','2022-01-16 06:38:51','',''),('5','131',4757737,'','20','3243',227365.05,0.00,'Sales from shift 254037 on 2022-01-17 07:07:50 ','2022-01-17 07:07:50','',''),('5','131',4757738,'','6.1','3241',0.00,227365.05,'Sales from shift 254037 on 2022-01-17 07:07:50 ','2022-01-17 07:07:50','',''),('5','131',4767335,'','6.1','3241',45000.00,0.00,'Payment Id 394484 for invoice:254037, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-01-17 16:36:55','',''),('5','131',4767336,'','supplier','140',0.00,45000.00,'Payment Id 394484 for invoice:254037, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-01-17 16:36:55','',''),('5','131',4767337,'','6.1','3241',7900.00,0.00,'Payment Id 394483 for invoice:254037, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2022-01-17 16:36:55','',''),('5','131',4767338,'','supplier','140',0.00,7900.00,'Payment Id 394483 for invoice:254037, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2022-01-17 16:36:55','',''),('5','131',4767339,'','2','3246',174460.00,0.00,'Payment Id 394481 for invoice:254037, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2022-01-17 16:36:55','',''),('5','131',4767340,'','supplier','140',0.00,174460.00,'Payment Id 394481 for invoice:254037, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2022-01-17 16:36:55','',''),('5','131',4767341,'','6.1','3241',7900.00,0.00,'Payment Id 394479 for invoice:253778, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-01-17 16:36:55','',''),('5','131',4767342,'','supplier','140',0.00,7900.00,'Payment Id 394479 for invoice:253778, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-01-17 16:36:55','',''),('5','131',4767343,'','2','3246',915700.00,0.00,'Payment Id 394478 for invoice:253778, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2022-01-17 16:36:55','',''),('5','131',4767344,'','supplier','140',0.00,915700.00,'Payment Id 394478 for invoice:253778, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2022-01-17 16:36:55','',''),('5','131',4767345,'','6.1','3241',7900.00,0.00,'Payment Id 394477 for invoice:253525, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-01-17 16:36:55','',''),('5','131',4767346,'','supplier','140',0.00,7900.00,'Payment Id 394477 for invoice:253525, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-01-17 16:36:55','',''),('5','131',4767347,'','2','3246',814500.00,0.00,'Payment Id 394475 for invoice:253525, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2022-01-17 16:36:55','',''),('5','131',4767348,'','supplier','140',0.00,814500.00,'Payment Id 394475 for invoice:253525, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2022-01-17 16:36:55','',''),('5','131',4770985,'','20','3243',0.00,0.00,'Sales from shift 254257 on 2022-01-18 07:06:53 ','2022-01-18 07:06:53','',''),('5','131',4770986,'','6.1','3241',0.00,0.00,'Sales from shift 254257 on 2022-01-18 07:06:53 ','2022-01-18 07:06:53','',''),('5','131',4785277,'','20','3243',0.00,0.00,'Sales from shift 254465 on 2022-01-19 06:03:33 ','2022-01-19 06:03:33','',''),('5','131',4785278,'','6.1','3241',0.00,0.00,'Sales from shift 254465 on 2022-01-19 06:03:33 ','2022-01-19 06:03:33','',''),('5','131',4800693,'','20','3243',0.00,0.00,'Sales from shift 254746 on 2022-01-20 06:33:55 ','2022-01-20 06:33:55','',''),('5','131',4800694,'','6.1','3241',0.00,0.00,'Sales from shift 254746 on 2022-01-20 06:33:55 ','2022-01-20 06:33:55','',''),('5','131',4820444,'','20','3243',0.00,0.00,'Sales from shift 255004 on 2022-01-21 11:15:39 ','2022-01-21 11:15:39','',''),('5','131',4820445,'','6.1','3241',0.00,0.00,'Sales from shift 255004 on 2022-01-21 11:15:39 ','2022-01-21 11:15:39','',''),('5','131',4831318,'','20','3243',0.00,0.00,'Sales from shift 255327 on 2022-01-21 22:35:43 ','2022-01-21 22:35:43','',''),('5','131',4831319,'','6.1','3241',0.00,0.00,'Sales from shift 255327 on 2022-01-21 22:35:43 ','2022-01-21 22:35:43','',''),('5','131',4846982,'','20','3243',0.00,0.00,'Sales from shift 255511 on 2022-01-23 07:28:49 ','2022-01-23 07:28:49','',''),('5','131',4846983,'','6.1','3241',0.00,0.00,'Sales from shift 255511 on 2022-01-23 07:28:49 ','2022-01-23 07:28:49','',''),('5','131',4860461,'','20','3243',0.00,0.00,'Sales from shift 255855 on 2022-01-24 07:30:20 ','2022-01-24 07:30:20','',''),('5','131',4860462,'','6.1','3241',0.00,0.00,'Sales from shift 255855 on 2022-01-24 07:30:20 ','2022-01-24 07:30:20','',''),('5','131',4874824,'','20','3243',0.00,0.00,'Sales from shift 255985 on 2022-01-25 08:22:24 ','2022-01-25 08:22:24','',''),('5','131',4874825,'','6.1','3241',0.00,0.00,'Sales from shift 255985 on 2022-01-25 08:22:24 ','2022-01-25 08:22:24','',''),('5','131',4890467,'','20','3243',0.00,0.00,'Sales from shift 256296 on 2022-01-26 06:10:38 ','2022-01-26 06:10:38','',''),('5','131',4890468,'','6.1','3241',0.00,0.00,'Sales from shift 256296 on 2022-01-26 06:10:38 ','2022-01-26 06:10:38','',''),('5','131',4903973,'','20','3243',0.00,0.00,'Sales from shift 256689 on 2022-01-27 07:06:51 ','2022-01-27 07:06:51','',''),('5','131',4903974,'','6.1','3241',0.00,0.00,'Sales from shift 256689 on 2022-01-27 07:06:51 ','2022-01-27 07:06:51','',''),('5','131',4919826,'','20','3243',0.00,0.00,'Sales from shift 256781 on 2022-01-28 06:36:34 ','2022-01-28 06:36:34','',''),('5','131',4919827,'','6.1','3241',0.00,0.00,'Sales from shift 256781 on 2022-01-28 06:36:34 ','2022-01-28 06:36:34','',''),('5','131',4935402,'','20','3243',0.00,0.00,'Sales from shift 257026 on 2022-01-29 07:12:40 ','2022-01-29 07:12:40','',''),('5','131',4935403,'','6.1','3241',0.00,0.00,'Sales from shift 257026 on 2022-01-29 07:12:40 ','2022-01-29 07:12:40','',''),('5','131',4951226,'','20','3243',0.00,0.00,'Sales from shift 257478 on 2022-01-30 06:56:07 ','2022-01-30 06:56:07','',''),('5','131',4951227,'','6.1','3241',0.00,0.00,'Sales from shift 257478 on 2022-01-30 06:56:07 ','2022-01-30 06:56:07','',''),('5','131',4959036,'','24','3245',0.00,3679500.00,'Purchase Id 90757 for 22,300.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-01-30 12:32:27','',''),('5','131',4959037,'','supplier','140',3679500.00,0.00,'Purchase Id 90757 for 22,300.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-01-30 12:32:27','',''),('5','131',4959038,'','20','3243',969200.10,0.00,'Sales from shift 257509 on 2022-01-31 09:18:08 ','2022-01-31 09:18:08','',''),('5','131',4959039,'','6.1','3241',0.00,969200.10,'Sales from shift 257509 on 2022-01-31 09:18:08 ','2022-01-31 09:18:08','',''),('5','131',4959040,'','20','3243',933822.45,0.00,'Sales from shift 257510 on 2022-02-02 19:19:20 ','2022-02-02 19:19:20','',''),('5','131',4959041,'','6.1','3241',0.00,933822.45,'Sales from shift 257510 on 2022-02-02 19:19:20 ','2022-02-02 19:19:20','',''),('5','131',4959042,'','6.1','3241',8200.00,0.00,'Payment Id 394488 for invoice:257510, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-02 19:23:23','',''),('5','131',4959043,'','supplier','140',0.00,8200.00,'Payment Id 394488 for invoice:257510, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-02 19:23:23','',''),('5','131',4959044,'','2','3246',925600.00,0.00,'Payment Id 394487 for invoice:257510, receipt: 026 by SALBAS OIL & GAS NIG. LTD','2022-02-02 19:23:23','',''),('5','131',4959045,'','supplier','140',0.00,925600.00,'Payment Id 394487 for invoice:257510, receipt: 026 by SALBAS OIL & GAS NIG. LTD','2022-02-02 19:23:23','',''),('5','131',4959046,'','6.1','3241',7900.00,0.00,'Payment Id 394486 for invoice:257509, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-02 19:23:23','',''),('5','131',4959047,'','supplier','140',0.00,7900.00,'Payment Id 394486 for invoice:257509, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-02 19:23:23','',''),('5','131',4959048,'','2','3246',961300.00,0.00,'Payment Id 394485 for invoice:257509, receipt: 0220 by SALBAS OIL & GAS NIG. LTD','2022-02-02 19:23:23','',''),('5','131',4959049,'','supplier','140',0.00,961300.00,'Payment Id 394485 for invoice:257509, receipt: 0220 by SALBAS OIL & GAS NIG. LTD','2022-02-02 19:23:23','',''),('5','131',4959050,'','20','3243',864296.40,0.00,'Sales from shift 257511 on 2022-02-02 19:43:05 ','2022-02-02 19:43:05','',''),('5','131',4959051,'','6.1','3241',0.00,864296.40,'Sales from shift 257511 on 2022-02-02 19:43:05 ','2022-02-02 19:43:05','',''),('5','131',4959052,'','20','3243',858356.40,0.00,'Sales from shift 257512 on 2022-02-03 07:56:45 ','2022-02-03 07:56:45','',''),('5','131',4959053,'','6.1','3241',0.00,858356.40,'Sales from shift 257512 on 2022-02-03 07:56:45 ','2022-02-03 07:56:45','',''),('5','131',4959054,'','6.1','3241',11700.00,0.00,'Payment Id 394493 for invoice:257511, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-03 07:57:14','',''),('5','131',4959055,'','supplier','140',0.00,11700.00,'Payment Id 394493 for invoice:257511, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-03 07:57:14','',''),('5','131',4959056,'','6.1','3241',12000.00,0.00,'Payment Id 394492 for invoice:257511, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-03 07:57:14','',''),('5','131',4959057,'','supplier','140',0.00,12000.00,'Payment Id 394492 for invoice:257511, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-03 07:57:14','',''),('5','131',4959058,'','6.1','3241',10000.00,0.00,'Payment Id 394491 for invoice:257511, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-03 07:57:14','',''),('5','131',4959059,'','supplier','140',0.00,10000.00,'Payment Id 394491 for invoice:257511, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-03 07:57:14','',''),('5','131',4959060,'','6.1','3241',8200.00,0.00,'Payment Id 394490 for invoice:257511, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-03 07:57:14','',''),('5','131',4959061,'','supplier','140',0.00,8200.00,'Payment Id 394490 for invoice:257511, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-03 07:57:14','',''),('5','131',4959062,'','2','3246',822390.00,0.00,'Payment Id 394489 for invoice:257511, receipt: 026 by SALBAS OIL & GAS NIG. LTD','2022-02-03 07:57:14','',''),('5','131',4959063,'','supplier','140',0.00,822390.00,'Payment Id 394489 for invoice:257511, receipt: 026 by SALBAS OIL & GAS NIG. LTD','2022-02-03 07:57:14','',''),('5','131',4959064,'','6.1','3241',8200.00,0.00,'Payment Id 394495 for invoice:257512, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-03 14:44:26','',''),('5','131',4959065,'','supplier','140',0.00,8200.00,'Payment Id 394495 for invoice:257512, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-03 14:44:26','',''),('5','131',4959066,'','2','3246',850150.00,0.00,'Payment Id 394494 for invoice:257512, receipt: 032 by SALBAS OIL & GAS NIG. LTD','2022-02-03 14:44:26','',''),('5','131',4959067,'','supplier','140',0.00,850150.00,'Payment Id 394494 for invoice:257512, receipt: 032 by SALBAS OIL & GAS NIG. LTD','2022-02-03 14:44:26','',''),('5','131',4959068,'','24','3245',0.00,4925250.00,'Purchase Id 90758 for 29,850.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-02-03 20:39:04','',''),('5','131',4959069,'','supplier','140',4925250.00,0.00,'Purchase Id 90758 for 29,850.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-02-03 20:39:04','',''),('5','131',4959070,'','24','3245',0.00,7425000.00,'Purchase Id 90759 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-02-03 20:39:21','',''),('5','131',4959071,'','supplier','140',7425000.00,0.00,'Purchase Id 90759 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-02-03 20:39:21','',''),('5','131',4959072,'','20','3243',789454.05,0.00,'Sales from shift 257513 on 2022-02-03 20:39:52 ','2022-02-03 20:39:52','',''),('5','131',4959073,'','6.1','3241',0.00,789454.05,'Sales from shift 257513 on 2022-02-03 20:39:52 ','2022-02-03 20:39:52','',''),('5','131',4959074,'','6.1','3241',8300.00,0.00,'Payment Id 394497 for invoice:257513, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-04 16:49:34','',''),('5','131',4959075,'','supplier','140',0.00,8300.00,'Payment Id 394497 for invoice:257513, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-04 16:49:34','',''),('5','131',4959076,'','2','3246',781150.00,0.00,'Payment Id 394496 for invoice:257513, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2022-02-04 16:49:34','',''),('5','131',4959077,'','supplier','140',0.00,781150.00,'Payment Id 394496 for invoice:257513, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2022-02-04 16:49:34','',''),('5','131',4959078,'','20','3243',848642.85,0.00,'Sales from shift 257514 on 2022-02-05 06:56:30 ','2022-02-05 06:56:30','',''),('5','131',4959079,'','6.1','3241',0.00,848642.85,'Sales from shift 257514 on 2022-02-05 06:56:30 ','2022-02-05 06:56:30','',''),('5','131',4959080,'','20','3243',984109.50,0.00,'Sales from shift 257517 on 2022-02-05 22:41:09 ','2022-02-05 22:41:09','',''),('5','131',4959081,'','6.1','3241',0.00,984109.50,'Sales from shift 257517 on 2022-02-05 22:41:09 ','2022-02-05 22:41:09','',''),('5','131',4959082,'','20','3243',879034.20,0.00,'Sales from shift 257518 on 2022-02-07 07:21:10 ','2022-02-07 07:21:10','',''),('5','131',4959083,'','6.1','3241',0.00,879034.20,'Sales from shift 257518 on 2022-02-07 07:21:10 ','2022-02-07 07:21:10','',''),('5','131',4959084,'','6.1','3241',8800.00,0.00,'Payment Id 394503 for invoice:257518, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-08 07:17:50','',''),('5','131',4959085,'','supplier','140',0.00,8800.00,'Payment Id 394503 for invoice:257518, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-08 07:17:50','',''),('5','131',4959086,'','2','3246',870230.00,0.00,'Payment Id 394502 for invoice:257518, receipt: 026 by SALBAS OIL & GAS NIG. LTD','2022-02-08 07:17:50','',''),('5','131',4959087,'','supplier','140',0.00,870230.00,'Payment Id 394502 for invoice:257518, receipt: 026 by SALBAS OIL & GAS NIG. LTD','2022-02-08 07:17:50','',''),('5','131',4959088,'','6.1','3241',8800.00,0.00,'Payment Id 394501 for invoice:257517, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-08 07:17:50','',''),('5','131',4959089,'','supplier','140',0.00,8800.00,'Payment Id 394501 for invoice:257517, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-08 07:17:50','',''),('5','131',4959090,'','2','3246',975300.00,0.00,'Payment Id 394500 for invoice:257517, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2022-02-08 07:17:50','',''),('5','131',4959091,'','supplier','140',0.00,975300.00,'Payment Id 394500 for invoice:257517, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2022-02-08 07:17:50','',''),('5','131',4959092,'','6.1','3241',8300.00,0.00,'Payment Id 394499 for invoice:257514, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-08 07:17:50','',''),('5','131',4959093,'','supplier','140',0.00,8300.00,'Payment Id 394499 for invoice:257514, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-08 07:17:50','',''),('5','131',4959094,'','2','3246',840340.00,0.00,'Payment Id 394498 for invoice:257514, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2022-02-08 07:17:50','',''),('5','131',4959095,'','supplier','140',0.00,840340.00,'Payment Id 394498 for invoice:257514, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2022-02-08 07:17:50','',''),('5','131',4959096,'','20','3243',899466.15,0.00,'Sales from shift 257519 on 2022-02-08 07:18:13 ','2022-02-08 07:18:13','',''),('5','131',4959097,'','6.1','3241',0.00,899466.15,'Sales from shift 257519 on 2022-02-08 07:18:13 ','2022-02-08 07:18:13','',''),('5','131',4959098,'','20','3243',933190.50,0.00,'Sales from shift 257520 on 2022-02-08 20:42:11 ','2022-02-08 20:42:11','',''),('5','131',4959099,'','6.1','3241',0.00,933190.50,'Sales from shift 257520 on 2022-02-08 20:42:11 ','2022-02-08 20:42:11','',''),('5','131',4959100,'','6.1','3241',5000.00,0.00,'Payment Id 394507 for invoice:257519, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-08 20:44:15','',''),('5','131',4959101,'','supplier','140',0.00,5000.00,'Payment Id 394507 for invoice:257519, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-08 20:44:15','',''),('5','131',4959102,'','6.1','3241',234000.00,0.00,'Payment Id 394506 for invoice:257519, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-08 20:44:15','',''),('5','131',4959103,'','supplier','140',0.00,234000.00,'Payment Id 394506 for invoice:257519, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-08 20:44:15','',''),('5','131',4959104,'','6.1','3241',8800.00,0.00,'Payment Id 394505 for invoice:257519, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-08 20:44:15','',''),('5','131',4959105,'','supplier','140',0.00,8800.00,'Payment Id 394505 for invoice:257519, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-08 20:44:15','',''),('5','131',4959106,'','2','3246',651600.00,0.00,'Payment Id 394504 for invoice:257519, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2022-02-08 20:44:15','',''),('5','131',4959107,'','supplier','140',0.00,651600.00,'Payment Id 394504 for invoice:257519, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2022-02-08 20:44:15','',''),('5','131',4959108,'','6.1','3241',35000.00,0.00,'Payment Id 394510 for invoice:257520, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-09 20:55:32','',''),('5','131',4959109,'','supplier','140',0.00,35000.00,'Payment Id 394510 for invoice:257520, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-09 20:55:32','',''),('5','131',4959110,'','6.1','3241',8800.00,0.00,'Payment Id 394509 for invoice:257520, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-09 20:55:32','',''),('5','131',4959111,'','supplier','140',0.00,8800.00,'Payment Id 394509 for invoice:257520, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-09 20:55:32','',''),('5','131',4959112,'','2','3246',889390.00,0.00,'Payment Id 394508 for invoice:257520, receipt: 0220 by SALBAS OIL & GAS NIG. LTD','2022-02-09 20:55:32','',''),('5','131',4959113,'','supplier','140',0.00,889390.00,'Payment Id 394508 for invoice:257520, receipt: 0220 by SALBAS OIL & GAS NIG. LTD','2022-02-09 20:55:32','',''),('5','131',4959114,'','20','3243',967083.15,0.00,'Sales from shift 257521 on 2022-02-09 20:55:54 ','2022-02-09 20:55:54','',''),('5','131',4959115,'','6.1','3241',0.00,967083.15,'Sales from shift 257521 on 2022-02-09 20:55:54 ','2022-02-09 20:55:54','',''),('5','131',4959116,'','6.1','3241',9300.00,0.00,'Payment Id 394512 for invoice:257521, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-10 21:43:20','',''),('5','131',4959117,'','supplier','140',0.00,9300.00,'Payment Id 394512 for invoice:257521, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-10 21:43:20','',''),('5','131',4959118,'','2','3246',957700.00,0.00,'Payment Id 394511 for invoice:257521, receipt: 0220 by SALBAS OIL & GAS NIG. LTD','2022-02-10 21:43:20','',''),('5','131',4959119,'','supplier','140',0.00,957700.00,'Payment Id 394511 for invoice:257521, receipt: 0220 by SALBAS OIL & GAS NIG. LTD','2022-02-10 21:43:20','',''),('5','131',4959120,'','20','3243',1010709.15,0.00,'Sales from shift 257522 on 2022-02-10 21:43:43 ','2022-02-10 21:43:43','',''),('5','131',4959121,'','6.1','3241',0.00,1010709.15,'Sales from shift 257522 on 2022-02-10 21:43:43 ','2022-02-10 21:43:43','',''),('5','131',4959122,'','6.1','3241',9300.00,0.00,'Payment Id 394514 for invoice:257522, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-11 20:20:45','',''),('5','131',4959123,'','supplier','140',0.00,9300.00,'Payment Id 394514 for invoice:257522, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-11 20:20:45','',''),('5','131',4959124,'','2','3246',1001400.00,0.00,'Payment Id 394513 for invoice:257522, receipt: 032 by SALBAS OIL & GAS NIG. LTD','2022-02-11 20:20:45','',''),('5','131',4959125,'','supplier','140',0.00,1001400.00,'Payment Id 394513 for invoice:257522, receipt: 032 by SALBAS OIL & GAS NIG. LTD','2022-02-11 20:20:45','',''),('5','131',4959126,'','20','3243',977699.25,0.00,'Sales from shift 257523 on 2022-02-11 20:21:07 ','2022-02-11 20:21:07','',''),('5','131',4959127,'','6.1','3241',0.00,977699.25,'Sales from shift 257523 on 2022-02-11 20:21:07 ','2022-02-11 20:21:07','',''),('5','131',4959128,'','20','3243',1206455.25,0.00,'Sales from shift 257524 on 2022-02-13 08:47:45 ','2022-02-13 08:47:45','',''),('5','131',4959129,'','6.1','3241',0.00,1206455.25,'Sales from shift 257524 on 2022-02-13 08:47:45 ','2022-02-13 08:47:45','',''),('5','131',4959130,'','20','3243',1054303.80,0.00,'Sales from shift 257525 on 2022-02-14 06:09:28 ','2022-02-14 06:09:28','',''),('5','131',4959131,'','6.1','3241',0.00,1054303.80,'Sales from shift 257525 on 2022-02-14 06:09:28 ','2022-02-14 06:09:28','',''),('5','131',4959132,'','2','3246',828172.00,0.00,'Payment Id 394515 for invoice:257526, receipt: 2416 by SALBAS OIL & GAS NIG. LTD','2022-02-14 14:32:32','',''),('5','131',4959133,'','supplier','140',0.00,828172.00,'Payment Id 394515 for invoice:257526, receipt: 2416 by SALBAS OIL & GAS NIG. LTD','2022-02-14 14:32:32','',''),('5','131',4959134,'','20','3243',725538.00,0.00,'Sales from shift 257526 on 2022-02-14 23:48:08 ','2022-02-14 23:48:08','',''),('5','131',4959135,'','6.1','3241',0.00,725538.00,'Sales from shift 257526 on 2022-02-14 23:48:08 ','2022-02-14 23:48:08','',''),('5','131',4959136,'','6.1','3241',3000.00,0.00,'Payment Id 394522 for invoice:257525, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-14 23:51:00','',''),('5','131',4959137,'','supplier','140',0.00,3000.00,'Payment Id 394522 for invoice:257525, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-14 23:51:00','',''),('5','131',4959138,'','6.1','3241',9300.00,0.00,'Payment Id 394521 for invoice:257525, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-14 23:51:00','',''),('5','131',4959139,'','supplier','140',0.00,9300.00,'Payment Id 394521 for invoice:257525, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-14 23:51:00','',''),('5','131',4959140,'','2','3246',1042000.00,0.00,'Payment Id 394520 for invoice:257525, receipt: 032 by SALBAS OIL & GAS NIG. LTD','2022-02-14 23:51:00','',''),('5','131',4959141,'','supplier','140',0.00,1042000.00,'Payment Id 394520 for invoice:257525, receipt: 032 by SALBAS OIL & GAS NIG. LTD','2022-02-14 23:51:00','',''),('5','131',4959142,'','6.1','3241',9300.00,0.00,'Payment Id 394519 for invoice:257524, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-14 23:51:00','',''),('5','131',4959143,'','supplier','140',0.00,9300.00,'Payment Id 394519 for invoice:257524, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-14 23:51:00','',''),('5','131',4959144,'','2','3246',1197150.00,0.00,'Payment Id 394518 for invoice:257524, receipt: 026 by SALBAS OIL & GAS NIG. LTD','2022-02-14 23:51:00','',''),('5','131',4959145,'','supplier','140',0.00,1197150.00,'Payment Id 394518 for invoice:257524, receipt: 026 by SALBAS OIL & GAS NIG. LTD','2022-02-14 23:51:00','',''),('5','131',4959146,'','6.1','3241',9300.00,0.00,'Payment Id 394517 for invoice:257523, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-14 23:51:00','',''),('5','131',4959147,'','supplier','140',0.00,9300.00,'Payment Id 394517 for invoice:257523, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-14 23:51:00','',''),('5','131',4959148,'','2','3246',968390.00,0.00,'Payment Id 394516 for invoice:257523, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2022-02-14 23:51:00','',''),('5','131',4959149,'','supplier','140',0.00,968390.00,'Payment Id 394516 for invoice:257523, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2022-02-14 23:51:00','',''),('5','131',4959150,'','6.1','3241',3000.00,0.00,'Payment Id 394525 for invoice:257526, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-16 06:10:36','',''),('5','131',4959151,'','supplier','140',0.00,3000.00,'Payment Id 394525 for invoice:257526, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-16 06:10:36','',''),('5','131',4959152,'','6.1','3241',9300.00,0.00,'Payment Id 394524 for invoice:257526, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-16 06:10:36','',''),('5','131',4959153,'','supplier','140',0.00,9300.00,'Payment Id 394524 for invoice:257526, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-16 06:10:36','',''),('5','131',4959154,'','2','3246',713230.00,0.00,'Payment Id 394523 for invoice:257526, receipt: 026 by SALBAS OIL & GAS NIG. LTD','2022-02-16 06:10:36','',''),('5','131',4959155,'','supplier','140',0.00,713230.00,'Payment Id 394523 for invoice:257526, receipt: 026 by SALBAS OIL & GAS NIG. LTD','2022-02-16 06:10:36','',''),('5','131',4959156,'','20','3243',502735.20,0.00,'Sales from shift 257527 on 2022-02-16 06:11:36 ','2022-02-16 06:11:36','',''),('5','131',4959157,'','6.1','3241',0.00,502735.20,'Sales from shift 257527 on 2022-02-16 06:11:36 ','2022-02-16 06:11:36','',''),('5','131',4959158,'','6.1','3241',106300.00,0.00,'Payment Id 394528 for invoice:257527, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-16 21:34:51','',''),('5','131',4959159,'','supplier','140',0.00,106300.00,'Payment Id 394528 for invoice:257527, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-16 21:34:51','',''),('5','131',4959160,'','6.1','3241',9300.00,0.00,'Payment Id 394527 for invoice:257527, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-16 21:34:51','',''),('5','131',4959161,'','supplier','140',0.00,9300.00,'Payment Id 394527 for invoice:257527, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-16 21:34:51','',''),('5','131',4959162,'','2','3246',387135.00,0.00,'Payment Id 394526 for invoice:257527, receipt: 6734 by SALBAS OIL & GAS NIG. LTD','2022-02-16 21:34:51','',''),('5','131',4959163,'','supplier','140',0.00,387135.00,'Payment Id 394526 for invoice:257527, receipt: 6734 by SALBAS OIL & GAS NIG. LTD','2022-02-16 21:34:51','',''),('5','131',4959164,'','24','3245',0.00,2128500.00,'Purchase Id 90760 for 12,900.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-02-17 12:06:30','',''),('5','131',4959165,'','supplier','140',2128500.00,0.00,'Purchase Id 90760 for 12,900.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-02-17 12:06:30','',''),('5','131',4959166,'','20','3243',1613229.75,0.00,'Sales from shift 257528 on 2022-02-18 07:58:22 ','2022-02-18 07:58:22','',''),('5','131',4959167,'','6.1','3241',0.00,1613229.75,'Sales from shift 257528 on 2022-02-18 07:58:22 ','2022-02-18 07:58:22','',''),('5','131',4959168,'','20','3243',822010.20,0.00,'Sales from shift 257529 on 2022-02-18 10:13:50 ','2022-02-18 10:13:50','',''),('5','131',4959169,'','6.1','3241',0.00,822010.20,'Sales from shift 257529 on 2022-02-18 10:13:50 ','2022-02-18 10:13:50','',''),('5','131',4959170,'','20','3243',479085.75,0.00,'Sales from shift 257530 on 2022-02-19 07:18:53 ','2022-02-19 07:18:53','',''),('5','131',4959171,'','6.1','3241',0.00,479085.75,'Sales from shift 257530 on 2022-02-19 07:18:53 ','2022-02-19 07:18:53','',''),('5','131',4959172,'','6.1','3241',24800.00,0.00,'Payment Id 394533 for invoice:257529, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-19 07:19:12','',''),('5','131',4959173,'','supplier','140',0.00,24800.00,'Payment Id 394533 for invoice:257529, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-19 07:19:12','',''),('5','131',4959174,'','6.1','3241',9300.00,0.00,'Payment Id 394532 for invoice:257529, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-19 07:19:12','',''),('5','131',4959175,'','supplier','140',0.00,9300.00,'Payment Id 394532 for invoice:257529, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-19 07:19:12','',''),('5','131',4959176,'','2','3246',787910.00,0.00,'Payment Id 394531 for invoice:257529, receipt: 0220 by SALBAS OIL & GAS NIG. LTD','2022-02-19 07:19:12','',''),('5','131',4959177,'','supplier','140',0.00,787910.00,'Payment Id 394531 for invoice:257529, receipt: 0220 by SALBAS OIL & GAS NIG. LTD','2022-02-19 07:19:12','',''),('5','131',4959178,'','6.1','3241',9300.00,0.00,'Payment Id 394530 for invoice:257528, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-19 07:19:12','',''),('5','131',4959179,'','supplier','140',0.00,9300.00,'Payment Id 394530 for invoice:257528, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-19 07:19:12','',''),('5','131',4959180,'','2','3246',1603900.00,0.00,'Payment Id 394529 for invoice:257528, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2022-02-19 07:19:12','',''),('5','131',4959181,'','supplier','140',0.00,1603900.00,'Payment Id 394529 for invoice:257528, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2022-02-19 07:19:12','',''),('5','131',4959182,'','20','3243',0.00,0.00,'Sales from shift 257531 on 2022-02-19 21:53:59 ','2022-02-19 21:53:59','',''),('5','131',4959183,'','6.1','3241',0.00,0.00,'Sales from shift 257531 on 2022-02-19 21:53:59 ','2022-02-19 21:53:59','',''),('5','131',4959184,'','20','3243',0.00,0.00,'Sales from shift 257532 on 2022-02-21 07:22:57 ','2022-02-21 07:22:57','',''),('5','131',4959185,'','6.1','3241',0.00,0.00,'Sales from shift 257532 on 2022-02-21 07:22:57 ','2022-02-21 07:22:57','',''),('5','131',4959186,'','24','3245',0.00,6534000.00,'Purchase Id 90761 for 39,600.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-02-21 10:03:20','',''),('5','131',4959187,'','supplier','140',6534000.00,0.00,'Purchase Id 90761 for 39,600.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-02-21 10:03:20','',''),('5','131',4959188,'','20','3243',2015714.25,0.00,'Sales from shift 257533 on 2022-02-22 06:55:22 ','2022-02-22 06:55:22','',''),('5','131',4959189,'','6.1','3241',0.00,2015714.25,'Sales from shift 257533 on 2022-02-22 06:55:22 ','2022-02-22 06:55:22','',''),('5','131',4959190,'','6.1','3241',10000.00,0.00,'Payment Id 394538 for invoice:257533, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-22 13:13:34','',''),('5','131',4959191,'','supplier','140',0.00,10000.00,'Payment Id 394538 for invoice:257533, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-22 13:13:34','',''),('5','131',4959192,'','6.1','3241',9300.00,0.00,'Payment Id 394537 for invoice:257533, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-22 13:13:34','',''),('5','131',4959193,'','supplier','140',0.00,9300.00,'Payment Id 394537 for invoice:257533, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-22 13:13:34','',''),('5','131',4959194,'','2','3246',1996400.00,0.00,'Payment Id 394536 for invoice:257533, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2022-02-22 13:13:34','',''),('5','131',4959195,'','supplier','140',0.00,1996400.00,'Payment Id 394536 for invoice:257533, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2022-02-22 13:13:34','',''),('5','131',4959196,'','6.1','3241',9300.00,0.00,'Payment Id 394535 for invoice:257530, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-22 13:13:34','',''),('5','131',4959197,'','supplier','140',0.00,9300.00,'Payment Id 394535 for invoice:257530, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-22 13:13:34','',''),('5','131',4959198,'','2','3246',469785.00,0.00,'Payment Id 394534 for invoice:257530, receipt: 0220 by SALBAS OIL & GAS NIG. LTD','2022-02-22 13:13:34','',''),('5','131',4959199,'','supplier','140',0.00,469785.00,'Payment Id 394534 for invoice:257530, receipt: 0220 by SALBAS OIL & GAS NIG. LTD','2022-02-22 13:13:34','',''),('5','131',4959200,'','20','3243',1844751.15,0.00,'Sales from shift 257534 on 2022-02-23 07:12:18 ','2022-02-23 07:12:18','',''),('5','131',4959201,'','6.1','3241',0.00,1844751.15,'Sales from shift 257534 on 2022-02-23 07:12:18 ','2022-02-23 07:12:18','',''),('5','131',4959202,'','6.1','3241',9300.00,0.00,'Payment Id 394540 for invoice:257534, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-24 07:58:21','',''),('5','131',4959203,'','supplier','140',0.00,9300.00,'Payment Id 394540 for invoice:257534, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-24 07:58:21','',''),('5','131',4959204,'','2','3246',1835450.00,0.00,'Payment Id 394539 for invoice:257534, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2022-02-24 07:58:21','',''),('5','131',4959205,'','supplier','140',0.00,1835450.00,'Payment Id 394539 for invoice:257534, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2022-02-24 07:58:21','',''),('5','131',4959206,'','20','3243',972450.60,0.00,'Sales from shift 257535 on 2022-02-24 15:42:05 ','2022-02-24 15:42:05','',''),('5','131',4959207,'','6.1','3241',0.00,972450.60,'Sales from shift 257535 on 2022-02-24 15:42:05 ','2022-02-24 15:42:05','',''),('5','131',4959208,'','6.1','3241',9300.00,0.00,'Payment Id 394542 for invoice:257535, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-25 06:46:50','',''),('5','131',4959209,'','supplier','140',0.00,9300.00,'Payment Id 394542 for invoice:257535, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-25 06:46:50','',''),('5','131',4959210,'','2','3246',963150.00,0.00,'Payment Id 394541 for invoice:257535, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2022-02-25 06:46:50','',''),('5','131',4959211,'','supplier','140',0.00,963150.00,'Payment Id 394541 for invoice:257535, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2022-02-25 06:46:50','',''),('5','131',4959212,'','20','3243',1342880.55,0.00,'Sales from shift 257536 on 2022-02-25 06:47:17 ','2022-02-25 06:47:17','',''),('5','131',4959213,'','6.1','3241',0.00,1342880.55,'Sales from shift 257536 on 2022-02-25 06:47:17 ','2022-02-25 06:47:17','',''),('5','131',4959214,'','20','3243',522033.60,0.00,'Sales from shift 257537 on 2022-02-26 07:17:26 ','2022-02-26 07:17:26','',''),('5','131',4959215,'','6.1','3241',0.00,522033.60,'Sales from shift 257537 on 2022-02-26 07:17:26 ','2022-02-26 07:17:26','',''),('5','131',4959216,'','6.1','3241',9300.00,0.00,'Payment Id 394544 for invoice:257536, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-26 07:17:49','',''),('5','131',4959217,'','supplier','140',0.00,9300.00,'Payment Id 394544 for invoice:257536, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-26 07:17:49','',''),('5','131',4959218,'','2','3246',1333580.00,0.00,'Payment Id 394543 for invoice:257536, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2022-02-26 07:17:49','',''),('5','131',4959219,'','supplier','140',0.00,1333580.00,'Payment Id 394543 for invoice:257536, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2022-02-26 07:17:49','',''),('5','131',4959220,'','20','3243',15658.50,0.00,'Sales from shift 257538 on 2022-02-27 09:12:01 ','2022-02-27 09:12:01','',''),('5','131',4959221,'','6.1','3241',0.00,15658.50,'Sales from shift 257538 on 2022-02-27 09:12:01 ','2022-02-27 09:12:01','',''),('5','131',4959222,'','20','3243',0.00,0.00,'Sales from shift 257539 on 2022-02-27 23:58:39 ','2022-02-27 23:58:39','',''),('5','131',4959223,'','6.1','3241',0.00,0.00,'Sales from shift 257539 on 2022-02-27 23:58:39 ','2022-02-27 23:58:39','',''),('5','131',4959224,'','6.1','3241',9300.00,0.00,'Payment Id 394548 for invoice:257538, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-28 21:36:50','',''),('5','131',4959225,'','supplier','140',0.00,9300.00,'Payment Id 394548 for invoice:257538, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-28 21:36:50','',''),('5','131',4959226,'','2','3246',6360.00,0.00,'Payment Id 394547 for invoice:257538, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2022-02-28 21:36:50','',''),('5','131',4959227,'','supplier','140',0.00,6360.00,'Payment Id 394547 for invoice:257538, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2022-02-28 21:36:50','',''),('5','131',4959228,'','6.1','3241',9300.00,0.00,'Payment Id 394546 for invoice:257537, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-28 21:36:50','',''),('5','131',4959229,'','supplier','140',0.00,9300.00,'Payment Id 394546 for invoice:257537, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-02-28 21:36:50','',''),('5','131',4959230,'','2','3246',512700.00,0.00,'Payment Id 394545 for invoice:257537, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2022-02-28 21:36:50','',''),('5','131',4959231,'','supplier','140',0.00,512700.00,'Payment Id 394545 for invoice:257537, receipt: 220 by SALBAS OIL & GAS NIG. LTD','2022-02-28 21:36:50','',''),('5','131',4959232,'','20','3243',0.00,0.00,'Sales from shift 257540 on 2022-03-02 09:41:25 ','2022-03-02 09:41:25','',''),('5','131',4959233,'','6.1','3241',0.00,0.00,'Sales from shift 257540 on 2022-03-02 09:41:25 ','2022-03-02 09:41:25','',''),('5','131',4959234,'','24','3245',0.00,2805000.00,'Purchase Id 90762 for 17,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-03-02 14:35:02','',''),('5','131',4959235,'','supplier','140',2805000.00,0.00,'Purchase Id 90762 for 17,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-03-02 14:35:02','',''),('5','131',4959236,'','20','3243',1170048.00,0.00,'Sales from shift 257541 on 2022-03-02 21:00:27 ','2022-03-02 21:00:27','',''),('5','131',4959237,'','6.1','3241',0.00,1170048.00,'Sales from shift 257541 on 2022-03-02 21:00:27 ','2022-03-02 21:00:27','',''),('5','131',4959238,'','6.1','3241',10520.00,0.00,'Payment Id 394551 for invoice:257541, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-02 21:00:47','',''),('5','131',4959239,'','supplier','140',0.00,10520.00,'Payment Id 394551 for invoice:257541, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-02 21:00:47','',''),('5','131',4959240,'','6.1','3241',9300.00,0.00,'Payment Id 394550 for invoice:257541, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-02 21:00:47','',''),('5','131',4959241,'','supplier','140',0.00,9300.00,'Payment Id 394550 for invoice:257541, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-02 21:00:47','',''),('5','131',4959242,'','2','3247',1150200.00,0.00,'Payment Id 394549 for invoice:257541, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-02 21:00:47','',''),('5','131',4959243,'','supplier','140',0.00,1150200.00,'Payment Id 394549 for invoice:257541, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-02 21:00:47','',''),('5','131',4959244,'','20','3243',878791.65,0.00,'Sales from shift 257542 on 2022-03-03 08:08:17 ','2022-03-03 08:08:17','',''),('5','131',4959245,'','6.1','3241',0.00,878791.65,'Sales from shift 257542 on 2022-03-03 08:08:17 ','2022-03-03 08:08:17','',''),('5','131',4959246,'','20','3243',618751.65,0.00,'Sales from shift 257543 on 2022-03-04 08:20:02 ','2022-03-04 08:20:02','',''),('5','131',4959247,'','6.1','3241',0.00,618751.65,'Sales from shift 257543 on 2022-03-04 08:20:02 ','2022-03-04 08:20:02','',''),('5','131',4959248,'','6.1','3241',9500.00,0.00,'Payment Id 394556 for invoice:257542, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-04 08:20:19','',''),('5','131',4959249,'','supplier','140',0.00,9500.00,'Payment Id 394556 for invoice:257542, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-04 08:20:19','',''),('5','131',4959250,'','6.1','3241',11700.00,0.00,'Payment Id 394555 for invoice:257542, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-04 08:20:20','',''),('5','131',4959251,'','supplier','140',0.00,11700.00,'Payment Id 394555 for invoice:257542, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-04 08:20:20','',''),('5','131',4959252,'','6.1','3241',28000.00,0.00,'Payment Id 394554 for invoice:257542, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-04 08:20:20','',''),('5','131',4959253,'','supplier','140',0.00,28000.00,'Payment Id 394554 for invoice:257542, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-04 08:20:20','',''),('5','131',4959254,'','6.1','3241',9300.00,0.00,'Payment Id 394553 for invoice:257542, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-04 08:20:20','',''),('5','131',4959255,'','supplier','140',0.00,9300.00,'Payment Id 394553 for invoice:257542, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-04 08:20:20','',''),('5','131',4959256,'','2','3247',820290.00,0.00,'Payment Id 394552 for invoice:257542, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-04 08:20:20','',''),('5','131',4959257,'','supplier','140',0.00,820290.00,'Payment Id 394552 for invoice:257542, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-04 08:20:20','',''),('5','131',4959258,'','20','3243',0.00,0.00,'Sales from shift 257544 on 2022-03-05 06:50:35 ','2022-03-05 06:50:35','',''),('5','131',4959259,'','6.1','3241',0.00,0.00,'Sales from shift 257544 on 2022-03-05 06:50:35 ','2022-03-05 06:50:35','',''),('5','131',4959260,'','6.1','3241',235000.00,0.00,'Payment Id 394559 for invoice:257543, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-05 06:50:51','',''),('5','131',4959261,'','supplier','140',0.00,235000.00,'Payment Id 394559 for invoice:257543, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-05 06:50:51','',''),('5','131',4959262,'','6.1','3241',9500.00,0.00,'Payment Id 394558 for invoice:257543, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-05 06:50:51','',''),('5','131',4959263,'','supplier','140',0.00,9500.00,'Payment Id 394558 for invoice:257543, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-05 06:50:51','',''),('5','131',4959264,'','2','3247',374250.00,0.00,'Payment Id 394557 for invoice:257543, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-05 06:50:51','',''),('5','131',4959265,'','supplier','140',0.00,374250.00,'Payment Id 394557 for invoice:257543, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-05 06:50:51','',''),('5','131',4959266,'','20','3243',0.00,0.00,'Sales from shift 257545 on 2022-03-06 06:03:03 ','2022-03-06 06:03:03','',''),('5','131',4959267,'','6.1','3241',0.00,0.00,'Sales from shift 257545 on 2022-03-06 06:03:03 ','2022-03-06 06:03:03','',''),('5','131',4959268,'','20','3243',0.00,0.00,'Sales from shift 257546 on 2022-03-06 23:35:40 ','2022-03-06 23:35:40','',''),('5','131',4959269,'','6.1','3241',0.00,0.00,'Sales from shift 257546 on 2022-03-06 23:35:40 ','2022-03-06 23:35:40','',''),('5','131',4959270,'','20','3243',0.00,0.00,'Sales from shift 257547 on 2022-03-07 20:09:38 ','2022-03-07 20:09:38','',''),('5','131',4959271,'','6.1','3241',0.00,0.00,'Sales from shift 257547 on 2022-03-07 20:09:38 ','2022-03-07 20:09:38','',''),('5','131',4959272,'','20','3243',0.00,0.00,'Sales from shift 257548 on 2022-03-09 07:51:44 ','2022-03-09 07:51:44','',''),('5','131',4959273,'','6.1','3241',0.00,0.00,'Sales from shift 257548 on 2022-03-09 07:51:44 ','2022-03-09 07:51:44','',''),('5','131',4959274,'','20','3243',0.00,0.00,'Sales from shift 257549 on 2022-03-10 07:40:08 ','2022-03-10 07:40:08','',''),('5','131',4959275,'','6.1','3241',0.00,0.00,'Sales from shift 257549 on 2022-03-10 07:40:08 ','2022-03-10 07:40:08','',''),('5','131',4959276,'','20','3243',0.00,0.00,'Sales from shift 257550 on 2022-03-11 08:55:23 ','2022-03-11 08:55:23','',''),('5','131',4959277,'','6.1','3241',0.00,0.00,'Sales from shift 257550 on 2022-03-11 08:55:23 ','2022-03-11 08:55:23','',''),('5','131',4959278,'','20','3243',0.00,0.00,'Sales from shift 257551 on 2022-03-12 07:40:18 ','2022-03-12 07:40:18','',''),('5','131',4959279,'','6.1','3241',0.00,0.00,'Sales from shift 257551 on 2022-03-12 07:40:18 ','2022-03-12 07:40:18','',''),('5','131',4959280,'','20','3243',0.00,0.00,'Sales from shift 257552 on 2022-03-13 12:15:05 ','2022-03-13 12:15:05','',''),('5','131',4959281,'','6.1','3241',0.00,0.00,'Sales from shift 257552 on 2022-03-13 12:15:05 ','2022-03-13 12:15:05','',''),('5','131',4959282,'','20','3243',0.00,0.00,'Sales from shift 257553 on 2022-03-14 06:05:42 ','2022-03-14 06:05:42','',''),('5','131',4959283,'','6.1','3241',0.00,0.00,'Sales from shift 257553 on 2022-03-14 06:05:42 ','2022-03-14 06:05:42','',''),('5','131',4959284,'','24','3245',0.00,4950000.00,'Purchase Id 90763 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-03-14 19:44:27','',''),('5','131',4959285,'','supplier','140',4950000.00,0.00,'Purchase Id 90763 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-03-14 19:44:27','',''),('5','131',4959286,'','20','3243',0.00,0.00,'Sales from shift 257554 on 2022-03-15 05:59:57 ','2022-03-15 05:59:57','',''),('5','131',4959287,'','6.1','3241',0.00,0.00,'Sales from shift 257554 on 2022-03-15 05:59:57 ','2022-03-15 05:59:57','',''),('5','131',4959288,'','20','3243',2251814.40,0.00,'Sales from shift 257555 on 2022-03-16 08:13:36 ','2022-03-16 08:13:36','',''),('5','131',4959289,'','6.1','3241',0.00,2251814.40,'Sales from shift 257555 on 2022-03-16 08:13:36 ','2022-03-16 08:13:36','',''),('5','131',4959290,'','20','3243',1065698.70,0.00,'Sales from shift 257556 on 2022-03-17 08:10:31 ','2022-03-17 08:10:31','',''),('5','131',4959291,'','6.1','3241',0.00,1065698.70,'Sales from shift 257556 on 2022-03-17 08:10:31 ','2022-03-17 08:10:31','',''),('5','131',4959292,'','6.1','3241',38000.00,0.00,'Payment Id 394562 for invoice:257555, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-17 08:10:57','',''),('5','131',4959293,'','supplier','140',0.00,38000.00,'Payment Id 394562 for invoice:257555, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-17 08:10:57','',''),('5','131',4959294,'','6.1','3241',13800.00,0.00,'Payment Id 394561 for invoice:257555, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-17 08:10:57','',''),('5','131',4959295,'','supplier','140',0.00,13800.00,'Payment Id 394561 for invoice:257555, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-17 08:10:57','',''),('5','131',4959296,'','2','3247',2200000.00,0.00,'Payment Id 394560 for invoice:257555, receipt: 1263589 by SALBAS OIL & GAS NIG. LTD','2022-03-17 08:10:57','',''),('5','131',4959297,'','supplier','140',0.00,2200000.00,'Payment Id 394560 for invoice:257555, receipt: 1263589 by SALBAS OIL & GAS NIG. LTD','2022-03-17 08:10:57','',''),('5','131',4959298,'','20','3243',1019297.40,0.00,'Sales from shift 257557 on 2022-03-18 07:38:13 ','2022-03-18 07:38:13','',''),('5','131',4959299,'','6.1','3241',0.00,1019297.40,'Sales from shift 257557 on 2022-03-18 07:38:13 ','2022-03-18 07:38:13','',''),('5','131',4959300,'','6.1','3241',13800.00,0.00,'Payment Id 394564 for invoice:257556, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-18 07:38:33','',''),('5','131',4959301,'','supplier','140',0.00,13800.00,'Payment Id 394564 for invoice:257556, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-18 07:38:33','',''),('5','131',4959302,'','2','3247',1051890.00,0.00,'Payment Id 394563 for invoice:257556, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-18 07:38:33','',''),('5','131',4959303,'','supplier','140',0.00,1051890.00,'Payment Id 394563 for invoice:257556, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-18 07:38:33','',''),('5','131',4959304,'','20','3243',526617.30,0.00,'Sales from shift 257558 on 2022-03-19 07:06:55 ','2022-03-19 07:06:55','',''),('5','131',4959305,'','6.1','3241',0.00,526617.30,'Sales from shift 257558 on 2022-03-19 07:06:55 ','2022-03-19 07:06:55','',''),('5','131',4959306,'','6.1','3241',13800.00,0.00,'Payment Id 394566 for invoice:257557, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-19 07:07:12','',''),('5','131',4959307,'','supplier','140',0.00,13800.00,'Payment Id 394566 for invoice:257557, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-19 07:07:12','',''),('5','131',4959308,'','2','3247',1005490.00,0.00,'Payment Id 394565 for invoice:257557, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-19 07:07:12','',''),('5','131',4959309,'','supplier','140',0.00,1005490.00,'Payment Id 394565 for invoice:257557, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-19 07:07:12','',''),('5','131',4959310,'','20','3243',0.00,0.00,'Sales from shift 257559 on 2022-03-20 08:38:30 ','2022-03-20 08:38:30','',''),('5','131',4959311,'','6.1','3241',0.00,0.00,'Sales from shift 257559 on 2022-03-20 08:38:30 ','2022-03-20 08:38:30','',''),('5','131',4959312,'','20','3243',0.00,0.00,'Sales from shift 257560 on 2022-03-21 07:06:33 ','2022-03-21 07:06:33','',''),('5','131',4959313,'','6.1','3241',0.00,0.00,'Sales from shift 257560 on 2022-03-21 07:06:33 ','2022-03-21 07:06:33','',''),('5','131',4959314,'','20','3243',0.00,0.00,'Sales from shift 257561 on 2022-03-22 07:31:45 ','2022-03-22 07:31:45','',''),('5','131',4959315,'','6.1','3241',0.00,0.00,'Sales from shift 257561 on 2022-03-22 07:31:45 ','2022-03-22 07:31:45','',''),('5','131',4959316,'','20','3243',0.00,0.00,'Sales from shift 257562 on 2022-03-23 07:54:11 ','2022-03-23 07:54:11','',''),('5','131',4959317,'','6.1','3241',0.00,0.00,'Sales from shift 257562 on 2022-03-23 07:54:11 ','2022-03-23 07:54:11','',''),('5','131',4959318,'','6.1','3241',13800.00,0.00,'Payment Id 394568 for invoice:257558, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-23 07:54:34','',''),('5','131',4959319,'','supplier','140',0.00,13800.00,'Payment Id 394568 for invoice:257558, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-23 07:54:34','',''),('5','131',4959320,'','2','3247',512800.00,0.00,'Payment Id 394567 for invoice:257558, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-23 07:54:34','',''),('5','131',4959321,'','supplier','140',0.00,512800.00,'Payment Id 394567 for invoice:257558, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-23 07:54:34','',''),('5','131',4959322,'','20','3243',0.00,0.00,'Sales from shift 257563 on 2022-03-24 07:59:21 ','2022-03-24 07:59:21','',''),('5','131',4959323,'','6.1','3241',0.00,0.00,'Sales from shift 257563 on 2022-03-24 07:59:21 ','2022-03-24 07:59:21','',''),('5','131',4959324,'','24','3245',0.00,2227500.00,'Purchase Id 90764 for 13,500.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-03-24 12:46:53','',''),('5','131',4959325,'','supplier','140',2227500.00,0.00,'Purchase Id 90764 for 13,500.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-03-24 12:46:53','',''),('5','131',4959326,'','20','3243',932055.30,0.00,'Sales from shift 257564 on 2022-03-25 06:45:13 ','2022-03-25 06:45:13','',''),('5','131',4959327,'','6.1','3241',0.00,932055.30,'Sales from shift 257564 on 2022-03-25 06:45:13 ','2022-03-25 06:45:13','',''),('5','131',4959328,'','2','3247',33000.00,0.00,'Payment Id 394571 for invoice:257564, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-26 04:54:02','',''),('5','131',4959329,'','supplier','140',0.00,33000.00,'Payment Id 394571 for invoice:257564, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-26 04:54:02','',''),('5','131',4959330,'','6.1','3241',13800.00,0.00,'Payment Id 394570 for invoice:257564, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-26 04:54:02','',''),('5','131',4959331,'','supplier','140',0.00,13800.00,'Payment Id 394570 for invoice:257564, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-26 04:54:02','',''),('5','131',4959332,'','2','3247',918250.00,0.00,'Payment Id 394569 for invoice:257564, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-26 04:54:02','',''),('5','131',4959333,'','supplier','140',0.00,918250.00,'Payment Id 394569 for invoice:257564, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-26 04:54:02','',''),('5','131',4959334,'','20','3243',867244.95,0.00,'Sales from shift 257565 on 2022-03-26 04:54:42 ','2022-03-26 04:54:42','',''),('5','131',4959335,'','6.1','3241',0.00,867244.95,'Sales from shift 257565 on 2022-03-26 04:54:42 ','2022-03-26 04:54:42','',''),('5','131',4959336,'','20','3243',378876.30,0.00,'Sales from shift 257566 on 2022-03-27 07:55:41 ','2022-03-27 07:55:41','',''),('5','131',4959337,'','6.1','3241',0.00,378876.30,'Sales from shift 257566 on 2022-03-27 07:55:41 ','2022-03-27 07:55:41','',''),('5','131',4959338,'','20','3243',0.00,0.00,'Sales from shift 257567 on 2022-03-28 06:57:56 ','2022-03-28 06:57:56','',''),('5','131',4959339,'','6.1','3241',0.00,0.00,'Sales from shift 257567 on 2022-03-28 06:57:56 ','2022-03-28 06:57:56','',''),('5','131',4959340,'','20','3243',0.00,0.00,'Sales from shift 257568 on 2022-03-29 07:53:02 ','2022-03-29 07:53:02','',''),('5','131',4959341,'','6.1','3241',0.00,0.00,'Sales from shift 257568 on 2022-03-29 07:53:02 ','2022-03-29 07:53:02','',''),('5','131',4959342,'','6.1','3241',13800.00,0.00,'Payment Id 394575 for invoice:257566, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-29 07:53:24','',''),('5','131',4959343,'','supplier','140',0.00,13800.00,'Payment Id 394575 for invoice:257566, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-29 07:53:24','',''),('5','131',4959344,'','2','3247',378876.30,0.00,'Payment Id 394574 for invoice:257566, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-29 07:53:24','',''),('5','131',4959345,'','supplier','140',0.00,378876.30,'Payment Id 394574 for invoice:257566, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-29 07:53:24','',''),('5','131',4959346,'','6.1','3241',13800.00,0.00,'Payment Id 394573 for invoice:257565, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-29 07:53:24','',''),('5','131',4959347,'','supplier','140',0.00,13800.00,'Payment Id 394573 for invoice:257565, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-29 07:53:24','',''),('5','131',4959348,'','2','3247',853400.00,0.00,'Payment Id 394572 for invoice:257565, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-29 07:53:24','',''),('5','131',4959349,'','supplier','140',0.00,853400.00,'Payment Id 394572 for invoice:257565, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-03-29 07:53:24','',''),('5','131',4959350,'','20','3243',0.00,0.00,'Sales from shift 257569 on 2022-03-30 06:37:01 ','2022-03-30 06:37:01','',''),('5','131',4959351,'','6.1','3241',0.00,0.00,'Sales from shift 257569 on 2022-03-30 06:37:01 ','2022-03-30 06:37:01','',''),('5','131',4959352,'','20','3243',0.00,0.00,'Sales from shift 257570 on 2022-03-31 10:56:48 ','2022-03-31 10:56:48','',''),('5','131',4959353,'','6.1','3241',0.00,0.00,'Sales from shift 257570 on 2022-03-31 10:56:48 ','2022-03-31 10:56:48','',''),('5','131',4959354,'','20','3243',0.00,0.00,'Sales from shift 257571 on 2022-04-01 10:04:13 ','2022-04-01 10:04:13','',''),('5','131',4959355,'','6.1','3241',0.00,0.00,'Sales from shift 257571 on 2022-04-01 10:04:13 ','2022-04-01 10:04:13','',''),('5','131',4959356,'','20','3243',0.00,0.00,'Sales from shift 257572 on 2022-04-02 08:35:52 ','2022-04-02 08:35:52','',''),('5','131',4959357,'','6.1','3241',0.00,0.00,'Sales from shift 257572 on 2022-04-02 08:35:52 ','2022-04-02 08:35:52','',''),('5','131',4959358,'','20','3243',0.00,0.00,'Sales from shift 257573 on 2022-04-03 04:09:12 ','2022-04-03 04:09:12','',''),('5','131',4959359,'','6.1','3241',0.00,0.00,'Sales from shift 257573 on 2022-04-03 04:09:12 ','2022-04-03 04:09:12','',''),('5','131',4959360,'','20','3243',0.00,0.00,'Sales from shift 257574 on 2022-04-04 07:44:53 ','2022-04-04 07:44:53','',''),('5','131',4959361,'','6.1','3241',0.00,0.00,'Sales from shift 257574 on 2022-04-04 07:44:53 ','2022-04-04 07:44:53','',''),('5','131',4959362,'','20','3243',0.00,0.00,'Sales from shift 257575 on 2022-04-05 09:04:04 ','2022-04-05 09:04:04','',''),('5','131',4959363,'','6.1','3241',0.00,0.00,'Sales from shift 257575 on 2022-04-05 09:04:04 ','2022-04-05 09:04:04','',''),('5','131',4959364,'','20','3243',0.00,0.00,'Sales from shift 257576 on 2022-04-06 08:20:28 ','2022-04-06 08:20:28','',''),('5','131',4959365,'','6.1','3241',0.00,0.00,'Sales from shift 257576 on 2022-04-06 08:20:28 ','2022-04-06 08:20:28','',''),('5','131',4959366,'','20','3243',0.00,0.00,'Sales from shift 257577 on 2022-04-07 07:48:29 ','2022-04-07 07:48:29','',''),('5','131',4959367,'','6.1','3241',0.00,0.00,'Sales from shift 257577 on 2022-04-07 07:48:29 ','2022-04-07 07:48:29','',''),('5','131',4959368,'','20','3243',0.00,0.00,'Sales from shift 257578 on 2022-04-08 04:07:43 ','2022-04-08 04:07:43','',''),('5','131',4959369,'','6.1','3241',0.00,0.00,'Sales from shift 257578 on 2022-04-08 04:07:43 ','2022-04-08 04:07:43','',''),('5','131',4959370,'','20','3243',0.00,0.00,'Sales from shift 257579 on 2022-04-09 09:34:24 ','2022-04-09 09:34:24','',''),('5','131',4959371,'','6.1','3241',0.00,0.00,'Sales from shift 257579 on 2022-04-09 09:34:24 ','2022-04-09 09:34:24','',''),('5','131',4959372,'','20','3243',0.00,0.00,'Sales from shift 257580 on 2022-04-10 00:15:08 ','2022-04-10 00:15:08','',''),('5','131',4959373,'','6.1','3241',0.00,0.00,'Sales from shift 257580 on 2022-04-10 00:15:08 ','2022-04-10 00:15:08','',''),('5','131',4959374,'','20','3243',0.00,0.00,'Sales from shift 257581 on 2022-04-11 03:58:26 ','2022-04-11 03:58:26','',''),('5','131',4959375,'','6.1','3241',0.00,0.00,'Sales from shift 257581 on 2022-04-11 03:58:26 ','2022-04-11 03:58:26','',''),('5','131',4959376,'','20','3243',0.00,0.00,'Sales from shift 257582 on 2022-04-12 12:47:38 ','2022-04-12 12:47:38','',''),('5','131',4959377,'','6.1','3241',0.00,0.00,'Sales from shift 257582 on 2022-04-12 12:47:38 ','2022-04-12 12:47:38','',''),('5','131',4959378,'','20','3243',82496.70,0.00,'Sales from shift 257583 on 2022-04-13 04:04:17 ','2022-04-13 04:04:17','',''),('5','131',4959379,'','6.1','3241',0.00,82496.70,'Sales from shift 257583 on 2022-04-13 04:04:17 ','2022-04-13 04:04:17','',''),('5','131',4959380,'','24','3245',0.00,2475000.00,'Purchase Id 90765 for 15,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-04-13 04:04:48','',''),('5','131',4959381,'','supplier','140',2475000.00,0.00,'Purchase Id 90765 for 15,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-04-13 04:04:48','',''),('5','131',4959382,'','6.1','3241',14200.00,0.00,'Payment Id 394577 for invoice:257583, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-04-14 03:29:42','',''),('5','131',4959383,'','supplier','140',0.00,14200.00,'Payment Id 394577 for invoice:257583, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-04-14 03:29:42','',''),('5','131',4959384,'','2','3247',68290.00,0.00,'Payment Id 394576 for invoice:257583, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-04-14 03:29:42','',''),('5','131',4959385,'','supplier','140',0.00,68290.00,'Payment Id 394576 for invoice:257583, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-04-14 03:29:42','',''),('5','131',4959386,'','6.1','3241',235000.00,0.00,'Payment Id 394580 for invoice:257584, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-04-15 05:48:26','',''),('5','131',4959387,'','supplier','140',0.00,235000.00,'Payment Id 394580 for invoice:257584, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-04-15 05:48:26','',''),('5','131',4959388,'','6.1','3241',14200.00,0.00,'Payment Id 394579 for invoice:257584, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-04-15 05:48:26','',''),('5','131',4959389,'','supplier','140',0.00,14200.00,'Payment Id 394579 for invoice:257584, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-04-15 05:48:26','',''),('5','131',4959390,'','2','3247',747940.00,0.00,'Payment Id 394578 for invoice:257584, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-04-15 05:48:26','',''),('5','131',4959391,'','supplier','140',0.00,747940.00,'Payment Id 394578 for invoice:257584, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-04-15 05:48:26','',''),('5','131',4959392,'','20','3243',997152.75,0.00,'Sales from shift 257584 on 2022-04-16 05:12:48 ','2022-04-16 05:12:48','',''),('5','131',4959393,'','6.1','3241',0.00,997152.75,'Sales from shift 257584 on 2022-04-16 05:12:48 ','2022-04-16 05:12:48','',''),('5','131',4959394,'','20','3243',801461.10,0.00,'Sales from shift 257585 on 2022-04-16 11:41:03 ','2022-04-16 11:41:03','',''),('5','131',4959395,'','6.1','3241',0.00,801461.10,'Sales from shift 257585 on 2022-04-16 11:41:03 ','2022-04-16 11:41:03','',''),('5','131',4959396,'','20','3243',573162.15,0.00,'Sales from shift 257586 on 2022-04-16 14:47:18 ','2022-04-16 14:47:18','',''),('5','131',4959397,'','6.1','3241',0.00,573162.15,'Sales from shift 257586 on 2022-04-16 14:47:18 ','2022-04-16 14:47:18','',''),('5','131',4959398,'','20','3243',0.00,0.00,'Sales from shift 257587 on 2022-04-17 09:54:36 ','2022-04-17 09:54:36','',''),('5','131',4959399,'','6.1','3241',0.00,0.00,'Sales from shift 257587 on 2022-04-17 09:54:36 ','2022-04-17 09:54:36','',''),('5','131',4959400,'','20','3243',0.00,0.00,'Sales from shift 257588 on 2022-04-17 23:59:36 ','2022-04-17 23:59:36','',''),('5','131',4959401,'','6.1','3241',0.00,0.00,'Sales from shift 257588 on 2022-04-17 23:59:36 ','2022-04-17 23:59:36','',''),('5','131',4959402,'','20','3243',0.00,0.00,'Sales from shift 257589 on 2022-04-18 23:49:14 ','2022-04-18 23:49:14','',''),('5','131',4959403,'','6.1','3241',0.00,0.00,'Sales from shift 257589 on 2022-04-18 23:49:14 ','2022-04-18 23:49:14','',''),('5','131',4959404,'','6.1','3241',14200.00,0.00,'Payment Id 394586 for invoice:257586, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-04-19 14:53:28','',''),('5','131',4959405,'','supplier','140',0.00,14200.00,'Payment Id 394586 for invoice:257586, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-04-19 14:53:28','',''),('5','131',4959406,'','2','3247',558960.00,0.00,'Payment Id 394585 for invoice:257586, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-04-19 14:53:28','',''),('5','131',4959407,'','supplier','140',0.00,558960.00,'Payment Id 394585 for invoice:257586, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-04-19 14:53:28','',''),('5','131',4959408,'','6.1','3241',9500.00,0.00,'Payment Id 394584 for invoice:257585, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-04-19 14:53:28','',''),('5','131',4959409,'','supplier','140',0.00,9500.00,'Payment Id 394584 for invoice:257585, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-04-19 14:53:28','',''),('5','131',4959410,'','6.1','3241',11700.00,0.00,'Payment Id 394583 for invoice:257585, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-04-19 14:53:28','',''),('5','131',4959411,'','supplier','140',0.00,11700.00,'Payment Id 394583 for invoice:257585, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-04-19 14:53:28','',''),('5','131',4959412,'','6.1','3241',14200.00,0.00,'Payment Id 394582 for invoice:257585, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-04-19 14:53:28','',''),('5','131',4959413,'','supplier','140',0.00,14200.00,'Payment Id 394582 for invoice:257585, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-04-19 14:53:28','',''),('5','131',4959414,'','2','3247',766060.00,0.00,'Payment Id 394581 for invoice:257585, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-04-19 14:53:28','',''),('5','131',4959415,'','supplier','140',0.00,766060.00,'Payment Id 394581 for invoice:257585, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-04-19 14:53:28','',''),('5','131',4959416,'','20','3243',0.00,0.00,'Sales from shift 257590 on 2022-04-20 04:50:35 ','2022-04-20 04:50:35','',''),('5','131',4959417,'','6.1','3241',0.00,0.00,'Sales from shift 257590 on 2022-04-20 04:50:35 ','2022-04-20 04:50:35','',''),('5','131',4959418,'','20','3243',0.00,0.00,'Sales from shift 257591 on 2022-04-21 04:23:51 ','2022-04-21 04:23:51','',''),('5','131',4959419,'','6.1','3241',0.00,0.00,'Sales from shift 257591 on 2022-04-21 04:23:51 ','2022-04-21 04:23:51','',''),('5','131',4959420,'','24','3245',0.00,2227500.00,'Purchase Id 90766 for 13,500.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-04-21 11:15:14','',''),('5','131',4959421,'','supplier','140',2227500.00,0.00,'Purchase Id 90766 for 13,500.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-04-21 11:15:14','',''),('5','131',4959422,'','20','3243',833226.90,0.00,'Sales from shift 257592 on 2022-04-22 06:10:01 ','2022-04-22 06:10:01','',''),('5','131',4959423,'','6.1','3241',0.00,833226.90,'Sales from shift 257592 on 2022-04-22 06:10:01 ','2022-04-22 06:10:01','',''),('5','131',4959424,'','20','3243',0.00,0.00,'Sales from shift 257593 on 2022-04-23 05:47:11 ','2022-04-23 05:47:11','',''),('5','131',4959425,'','6.1','3241',0.00,0.00,'Sales from shift 257593 on 2022-04-23 05:47:11 ','2022-04-23 05:47:11','',''),('5','131',4959426,'','6.1','3241',27000.00,0.00,'Payment Id 394589 for invoice:257595, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-04-23 05:47:32','',''),('5','131',4959427,'','supplier','140',0.00,27000.00,'Payment Id 394589 for invoice:257595, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-04-23 05:47:32','',''),('5','131',4959428,'','6.1','3241',14200.00,0.00,'Payment Id 394588 for invoice:257595, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-04-23 05:47:32','',''),('5','131',4959429,'','supplier','140',0.00,14200.00,'Payment Id 394588 for invoice:257595, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-04-23 05:47:32','',''),('5','131',4959430,'','2','3247',792000.00,0.00,'Payment Id 394587 for invoice:257595, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-04-23 05:47:32','',''),('5','131',4959431,'','supplier','140',0.00,792000.00,'Payment Id 394587 for invoice:257595, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-04-23 05:47:32','',''),('5','131',4959432,'','20','3243',0.00,0.00,'Sales from shift 257594 on 2022-04-24 03:08:32 ','2022-04-24 03:08:32','',''),('5','131',4959433,'','6.1','3241',0.00,0.00,'Sales from shift 257594 on 2022-04-24 03:08:32 ','2022-04-24 03:08:32','',''),('5','131',4959434,'','20','3243',0.00,0.00,'Sales from shift 257595 on 2022-04-25 03:48:21 ','2022-04-25 03:48:21','',''),('5','131',4959435,'','6.1','3241',0.00,0.00,'Sales from shift 257595 on 2022-04-25 03:48:21 ','2022-04-25 03:48:21','',''),('5','131',4959436,'','20','3243',0.00,0.00,'Sales from shift 257596 on 2022-04-26 02:16:34 ','2022-04-26 02:16:34','',''),('5','131',4959437,'','6.1','3241',0.00,0.00,'Sales from shift 257596 on 2022-04-26 02:16:34 ','2022-04-26 02:16:34','',''),('5','131',4959438,'','20','3243',0.00,0.00,'Sales from shift 257597 on 2022-04-27 03:36:04 ','2022-04-27 03:36:04','',''),('5','131',4959439,'','6.1','3241',0.00,0.00,'Sales from shift 257597 on 2022-04-27 03:36:04 ','2022-04-27 03:36:04','',''),('5','131',4959440,'','20','3243',0.00,0.00,'Sales from shift 257598 on 2022-04-28 01:27:01 ','2022-04-28 01:27:01','',''),('5','131',4959441,'','6.1','3241',0.00,0.00,'Sales from shift 257598 on 2022-04-28 01:27:01 ','2022-04-28 01:27:01','',''),('5','131',4959442,'','20','3243',394977.00,0.00,'Sales from shift 257599 on 2022-04-29 06:03:12 ','2022-04-29 06:03:12','',''),('5','131',4959443,'','6.1','3241',0.00,394977.00,'Sales from shift 257599 on 2022-04-29 06:03:12 ','2022-04-29 06:03:12','',''),('5','131',4959444,'','24','3245',0.00,4950000.00,'Purchase Id 90767 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-04-29 14:47:25','',''),('5','131',4959445,'','supplier','140',4950000.00,0.00,'Purchase Id 90767 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-04-29 14:47:25','',''),('5','131',4959446,'','20','3243',857572.65,0.00,'Sales from shift 257600 on 2022-04-30 00:03:42 ','2022-04-30 00:03:42','',''),('5','131',4959447,'','6.1','3241',0.00,857572.65,'Sales from shift 257600 on 2022-04-30 00:03:42 ','2022-04-30 00:03:42','',''),('5','131',4959448,'','6.1','3241',14200.00,0.00,'Payment Id 394591 for invoice:257599, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-09 14:00:48','',''),('5','131',4959449,'','supplier','140',0.00,14200.00,'Payment Id 394591 for invoice:257599, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-09 14:00:48','',''),('5','131',4959450,'','2','3247',380700.00,0.00,'Payment Id 394590 for invoice:257599, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-09 14:00:48','',''),('5','131',4959451,'','supplier','140',0.00,380700.00,'Payment Id 394590 for invoice:257599, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-09 14:00:48','',''),('5','131',4959452,'','24','3245',0.00,6600000.00,'Purchase Id 90768 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-05-09 14:01:49','',''),('5','131',4959453,'','supplier','140',6600000.00,0.00,'Purchase Id 90768 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-05-09 14:01:49','',''),('5','131',4959454,'','20','3243',1273476.60,0.00,'Sales from shift 257601 on 2022-05-09 14:26:26 ','2022-05-09 14:26:26','',''),('5','131',4959455,'','6.1','3241',0.00,1273476.60,'Sales from shift 257601 on 2022-05-09 14:26:26 ','2022-05-09 14:26:26','',''),('5','131',4959456,'','20','3243',1017030.30,0.00,'Sales from shift 257602 on 2022-05-09 15:06:00 ','2022-05-09 15:06:00','',''),('5','131',4959457,'','6.1','3241',0.00,1017030.30,'Sales from shift 257602 on 2022-05-09 15:06:00 ','2022-05-09 15:06:00','',''),('5','131',4959458,'','20','3243',508038.30,0.00,'Sales from shift 257603 on 2022-05-09 15:27:29 ','2022-05-09 15:27:29','',''),('5','131',4959459,'','6.1','3241',0.00,508038.30,'Sales from shift 257603 on 2022-05-09 15:27:29 ','2022-05-09 15:27:29','',''),('5','131',4959460,'','20','3243',1338097.20,0.00,'Sales from shift 257604 on 2022-05-09 15:59:44 ','2022-05-09 15:59:44','',''),('5','131',4959461,'','6.1','3241',0.00,1338097.20,'Sales from shift 257604 on 2022-05-09 15:59:44 ','2022-05-09 15:59:44','',''),('5','131',4959462,'','6.1','3241',14200.00,0.00,'Payment Id 394600 for invoice:257604, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-09 18:59:43','',''),('5','131',4959463,'','supplier','140',0.00,14200.00,'Payment Id 394600 for invoice:257604, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-09 18:59:43','',''),('5','131',4959464,'','2','3247',1323890.00,0.00,'Payment Id 394599 for invoice:257604, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-09 18:59:43','',''),('5','131',4959465,'','supplier','140',0.00,1323890.00,'Payment Id 394599 for invoice:257604, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-09 18:59:43','',''),('5','131',4959466,'','6.1','3241',14200.00,0.00,'Payment Id 394598 for invoice:257603, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-09 18:59:43','',''),('5','131',4959467,'','supplier','140',0.00,14200.00,'Payment Id 394598 for invoice:257603, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-09 18:59:43','',''),('5','131',4959468,'','2','3247',493830.00,0.00,'Payment Id 394597 for invoice:257603, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-09 18:59:43','',''),('5','131',4959469,'','supplier','140',0.00,493830.00,'Payment Id 394597 for invoice:257603, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-09 18:59:43','',''),('5','131',4959470,'','6.1','3241',235000.00,0.00,'Payment Id 394596 for invoice:257602, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-09 18:59:43','',''),('5','131',4959471,'','supplier','140',0.00,235000.00,'Payment Id 394596 for invoice:257602, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-09 18:59:43','',''),('5','131',4959472,'','6.1','3241',14200.00,0.00,'Payment Id 394595 for invoice:257602, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-09 18:59:43','',''),('5','131',4959473,'','supplier','140',0.00,14200.00,'Payment Id 394595 for invoice:257602, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-09 18:59:43','',''),('5','131',4959474,'','6.1','3241',14200.00,0.00,'Payment Id 394594 for invoice:257601, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-09 18:59:43','',''),('5','131',4959475,'','supplier','140',0.00,14200.00,'Payment Id 394594 for invoice:257601, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-09 18:59:43','',''),('5','131',4959476,'','2','3247',767830.00,0.00,'Payment Id 394593 for invoice:257602, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-09 18:59:43','',''),('5','131',4959477,'','supplier','140',0.00,767830.00,'Payment Id 394593 for invoice:257602, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-09 18:59:43','',''),('5','131',4959478,'','2','3247',1259270.00,0.00,'Payment Id 394592 for invoice:257601, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-09 18:59:43','',''),('5','131',4959479,'','supplier','140',0.00,1259270.00,'Payment Id 394592 for invoice:257601, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-09 18:59:43','',''),('5','131',4959480,'','20','3243',1348056.60,0.00,'Sales from shift 257605 on 2022-05-09 19:20:12 ','2022-05-09 19:20:12','',''),('5','131',4959481,'','6.1','3241',0.00,1348056.60,'Sales from shift 257605 on 2022-05-09 19:20:12 ','2022-05-09 19:20:12','',''),('5','131',4959482,'','20','3243',1453390.95,0.00,'Sales from shift 257606 on 2022-05-09 19:23:24 ','2022-05-09 19:23:24','',''),('5','131',4959483,'','6.1','3241',0.00,1453390.95,'Sales from shift 257606 on 2022-05-09 19:23:24 ','2022-05-09 19:23:24','',''),('5','131',4959484,'','20','3243',0.00,0.00,'Sales from shift 257607 on 2022-05-09 19:50:17 ','2022-05-09 19:50:17','',''),('5','131',4959485,'','6.1','3241',0.00,0.00,'Sales from shift 257607 on 2022-05-09 19:50:17 ','2022-05-09 19:50:17','',''),('5','131',4959486,'','20','3243',0.00,0.00,'Sales from shift 257608 on 2022-05-09 19:56:33 ','2022-05-09 19:56:33','',''),('5','131',4959487,'','6.1','3241',0.00,0.00,'Sales from shift 257608 on 2022-05-09 19:56:33 ','2022-05-09 19:56:33','',''),('5','131',4959488,'','20','3243',0.00,0.00,'Sales from shift 257609 on 2022-05-09 20:01:39 ','2022-05-09 20:01:39','',''),('5','131',4959489,'','6.1','3241',0.00,0.00,'Sales from shift 257609 on 2022-05-09 20:01:39 ','2022-05-09 20:01:39','',''),('5','131',4959490,'','20','3243',0.00,0.00,'Sales from shift 257610 on 2022-05-09 20:37:49 ','2022-05-09 20:37:49','',''),('5','131',4959491,'','6.1','3241',0.00,0.00,'Sales from shift 257610 on 2022-05-09 20:37:49 ','2022-05-09 20:37:49','',''),('5','131',4959492,'','20','3243',1083132.60,0.00,'Sales from shift 257611 on 2022-05-09 20:50:15 ','2022-05-09 20:50:15','',''),('5','131',4959493,'','6.1','3241',0.00,1083132.60,'Sales from shift 257611 on 2022-05-09 20:50:15 ','2022-05-09 20:50:15','',''),('5','131',4959494,'','6.1','3241',14200.00,0.00,'Payment Id 394606 for invoice:257611, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-10 17:47:08','',''),('5','131',4959495,'','supplier','140',0.00,14200.00,'Payment Id 394606 for invoice:257611, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-10 17:47:08','',''),('5','131',4959496,'','2','3247',1068930.00,0.00,'Payment Id 394605 for invoice:257611, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-10 17:47:09','',''),('5','131',4959497,'','supplier','140',0.00,1068930.00,'Payment Id 394605 for invoice:257611, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-10 17:47:09','',''),('5','131',4959498,'','6.1','3241',14200.00,0.00,'Payment Id 394604 for invoice:257606, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-10 17:47:09','',''),('5','131',4959499,'','supplier','140',0.00,14200.00,'Payment Id 394604 for invoice:257606, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-10 17:47:09','',''),('5','131',4959500,'','2','3247',1439190.00,0.00,'Payment Id 394603 for invoice:257606, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-10 17:47:09','',''),('5','131',4959501,'','supplier','140',0.00,1439190.00,'Payment Id 394603 for invoice:257606, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-10 17:47:09','',''),('5','131',4959502,'','6.1','3241',14200.00,0.00,'Payment Id 394602 for invoice:257605, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-10 17:47:09','',''),('5','131',4959503,'','supplier','140',0.00,14200.00,'Payment Id 394602 for invoice:257605, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-10 17:47:09','',''),('5','131',4959504,'','2','3247',1333850.00,0.00,'Payment Id 394601 for invoice:257605, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-10 17:47:09','',''),('5','131',4959505,'','supplier','140',0.00,1333850.00,'Payment Id 394601 for invoice:257605, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-10 17:47:09','',''),('5','131',4959506,'','20','3243',554520.45,0.00,'Sales from shift 257612 on 2022-05-10 22:52:34 ','2022-05-10 22:52:34','',''),('5','131',4959507,'','6.1','3241',0.00,554520.45,'Sales from shift 257612 on 2022-05-10 22:52:34 ','2022-05-10 22:52:34','',''),('5','131',4959508,'','20','3243',171657.75,0.00,'Sales from shift 257613 on 2022-05-12 05:31:43 ','2022-05-12 05:31:43','',''),('5','131',4959509,'','6.1','3241',0.00,171657.75,'Sales from shift 257613 on 2022-05-12 05:31:43 ','2022-05-12 05:31:43','',''),('5','131',4959510,'','20','3243',0.00,0.00,'Sales from shift 257614 on 2022-05-12 18:45:16 ','2022-05-12 18:45:16','',''),('5','131',4959511,'','6.1','3241',0.00,0.00,'Sales from shift 257614 on 2022-05-12 18:45:16 ','2022-05-12 18:45:16','',''),('5','131',4959512,'','6.1','3241',14200.00,0.00,'Payment Id 394610 for invoice:257613, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-12 22:41:24','',''),('5','131',4959513,'','supplier','140',0.00,14200.00,'Payment Id 394610 for invoice:257613, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-12 22:41:24','',''),('5','131',4959514,'','2','3247',157450.00,0.00,'Payment Id 394609 for invoice:257613, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-12 22:41:24','',''),('5','131',4959515,'','supplier','140',0.00,157450.00,'Payment Id 394609 for invoice:257613, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-12 22:41:24','',''),('5','131',4959516,'','6.1','3241',14200.00,0.00,'Payment Id 394608 for invoice:257612, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-12 22:41:24','',''),('5','131',4959517,'','supplier','140',0.00,14200.00,'Payment Id 394608 for invoice:257612, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-12 22:41:24','',''),('5','131',4959518,'','2','3247',528620.00,0.00,'Payment Id 394607 for invoice:257612, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-12 22:41:24','',''),('5','131',4959519,'','supplier','140',0.00,528620.00,'Payment Id 394607 for invoice:257612, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-12 22:41:24','',''),('5','131',4959520,'','20','3243',0.00,0.00,'Sales from shift 257615 on 2022-05-13 22:26:23 ','2022-05-13 22:26:23','',''),('5','131',4959521,'','6.1','3241',0.00,0.00,'Sales from shift 257615 on 2022-05-13 22:26:23 ','2022-05-13 22:26:23','',''),('5','131',4959522,'','20','3243',0.00,0.00,'Sales from shift 257616 on 2022-05-15 06:10:50 ','2022-05-15 06:10:50','',''),('5','131',4959523,'','6.1','3241',0.00,0.00,'Sales from shift 257616 on 2022-05-15 06:10:50 ','2022-05-15 06:10:50','',''),('5','131',4959524,'','20','3243',0.00,0.00,'Sales from shift 257617 on 2022-05-16 06:03:07 ','2022-05-16 06:03:07','',''),('5','131',4959525,'','6.1','3241',0.00,0.00,'Sales from shift 257617 on 2022-05-16 06:03:07 ','2022-05-16 06:03:07','',''),('5','131',4959526,'','20','3243',0.00,0.00,'Sales from shift 257618 on 2022-05-17 06:12:33 ','2022-05-17 06:12:33','',''),('5','131',4959527,'','6.1','3241',0.00,0.00,'Sales from shift 257618 on 2022-05-17 06:12:33 ','2022-05-17 06:12:33','',''),('5','131',4959528,'','20','3243',0.00,0.00,'Sales from shift 257619 on 2022-05-18 06:12:37 ','2022-05-18 06:12:37','',''),('5','131',4959529,'','6.1','3241',0.00,0.00,'Sales from shift 257619 on 2022-05-18 06:12:37 ','2022-05-18 06:12:37','',''),('5','131',4959530,'','20','3243',599001.15,0.00,'Sales from shift 257620 on 2022-05-18 21:30:50 ','2022-05-18 21:30:50','',''),('5','131',4959531,'','6.1','3241',0.00,599001.15,'Sales from shift 257620 on 2022-05-18 21:30:50 ','2022-05-18 21:30:50','',''),('5','131',4959532,'','6.1','3241',15000.00,0.00,'Payment Id 394612 for invoice:257620, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-19 20:59:23','',''),('5','131',4959533,'','supplier','140',0.00,15000.00,'Payment Id 394612 for invoice:257620, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-19 20:59:23','',''),('5','131',4959534,'','2','3247',584000.00,0.00,'Payment Id 394611 for invoice:257620, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-19 20:59:23','',''),('5','131',4959535,'','supplier','140',0.00,584000.00,'Payment Id 394611 for invoice:257620, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-19 20:59:23','',''),('5','131',4959536,'','20','3243',797784.90,0.00,'Sales from shift 257621 on 2022-05-20 05:23:51 ','2022-05-20 05:23:51','',''),('5','131',4959537,'','6.1','3241',0.00,797784.90,'Sales from shift 257621 on 2022-05-20 05:23:51 ','2022-05-20 05:23:51','',''),('5','131',4959538,'','6.1','3241',15000.00,0.00,'Payment Id 394614 for invoice:257621, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-20 17:14:56','',''),('5','131',4959539,'','supplier','140',0.00,15000.00,'Payment Id 394614 for invoice:257621, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-20 17:14:56','',''),('5','131',4959540,'','2','3247',782780.00,0.00,'Payment Id 394613 for invoice:257621, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-20 17:14:56','',''),('5','131',4959541,'','supplier','140',0.00,782780.00,'Payment Id 394613 for invoice:257621, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-20 17:14:56','',''),('5','131',4959542,'','20','3243',848017.50,0.00,'Sales from shift 257622 on 2022-05-22 08:14:52 ','2022-05-22 08:14:52','',''),('5','131',4959543,'','6.1','3241',0.00,848017.50,'Sales from shift 257622 on 2022-05-22 08:14:52 ','2022-05-22 08:14:52','',''),('5','131',4959544,'','20','3243',747077.10,0.00,'Sales from shift 257623 on 2022-05-23 05:16:52 ','2022-05-23 05:16:52','',''),('5','131',4959545,'','6.1','3241',0.00,747077.10,'Sales from shift 257623 on 2022-05-23 05:16:52 ','2022-05-23 05:16:52','',''),('5','131',4959546,'','20','3243',0.00,0.00,'Sales from shift 257624 on 2022-05-23 12:49:07 ','2022-05-23 12:49:07','',''),('5','131',4959547,'','6.1','3241',0.00,0.00,'Sales from shift 257624 on 2022-05-23 12:49:07 ','2022-05-23 12:49:07','',''),('5','131',4959548,'','6.1','3241',330000.00,0.00,'Payment Id 394622 for invoice:257623, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-23 21:57:03','',''),('5','131',4959549,'','supplier','140',0.00,330000.00,'Payment Id 394622 for invoice:257623, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-23 21:57:03','',''),('5','131',4959550,'','6.1','3241',15000.00,0.00,'Payment Id 394621 for invoice:257623, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-23 21:57:03','',''),('5','131',4959551,'','supplier','140',0.00,15000.00,'Payment Id 394621 for invoice:257623, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-23 21:57:03','',''),('5','131',4959552,'','2','3247',402000.00,0.00,'Payment Id 394620 for invoice:257623, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-23 21:57:03','',''),('5','131',4959553,'','supplier','140',0.00,402000.00,'Payment Id 394620 for invoice:257623, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-23 21:57:03','',''),('5','131',4959554,'','6.1','3241',10000.00,0.00,'Payment Id 394619 for invoice:257622, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-23 21:57:03','',''),('5','131',4959555,'','supplier','140',0.00,10000.00,'Payment Id 394619 for invoice:257622, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-23 21:57:03','',''),('5','131',4959556,'','6.1','3241',3000.00,0.00,'Payment Id 394618 for invoice:257622, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-23 21:57:03','',''),('5','131',4959557,'','supplier','140',0.00,3000.00,'Payment Id 394618 for invoice:257622, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-23 21:57:03','',''),('5','131',4959558,'','6.1','3241',200000.00,0.00,'Payment Id 394617 for invoice:257622, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-23 21:57:03','',''),('5','131',4959559,'','supplier','140',0.00,200000.00,'Payment Id 394617 for invoice:257622, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-23 21:57:03','',''),('5','131',4959560,'','6.1','3241',15000.00,0.00,'Payment Id 394616 for invoice:257622, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-23 21:57:03','',''),('5','131',4959561,'','supplier','140',0.00,15000.00,'Payment Id 394616 for invoice:257622, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-23 21:57:03','',''),('5','131',4959562,'','2','3247',620000.00,0.00,'Payment Id 394615 for invoice:257622, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-23 21:57:03','',''),('5','131',4959563,'','supplier','140',0.00,620000.00,'Payment Id 394615 for invoice:257622, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-05-23 21:57:03','',''),('5','131',4959564,'','20','3243',0.00,0.00,'Sales from shift 257625 on 2022-05-23 22:00:17 ','2022-05-23 22:00:17','',''),('5','131',4959565,'','6.1','3241',0.00,0.00,'Sales from shift 257625 on 2022-05-23 22:00:17 ','2022-05-23 22:00:17','',''),('5','131',4959566,'','20','3243',0.00,0.00,'Sales from shift 257626 on 2022-05-25 06:11:21 ','2022-05-25 06:11:21','',''),('5','131',4959567,'','6.1','3241',0.00,0.00,'Sales from shift 257626 on 2022-05-25 06:11:21 ','2022-05-25 06:11:21','',''),('5','131',4959568,'','20','3243',0.00,0.00,'Sales from shift 257627 on 2022-05-26 05:21:58 ','2022-05-26 05:21:58','',''),('5','131',4959569,'','6.1','3241',0.00,0.00,'Sales from shift 257627 on 2022-05-26 05:21:58 ','2022-05-26 05:21:58','',''),('5','131',4959570,'','20','3243',0.00,0.00,'Sales from shift 257628 on 2022-05-26 20:40:23 ','2022-05-26 20:40:23','',''),('5','131',4959571,'','6.1','3241',0.00,0.00,'Sales from shift 257628 on 2022-05-26 20:40:23 ','2022-05-26 20:40:23','',''),('5','131',4959572,'','20','3243',0.00,0.00,'Sales from shift 257629 on 2022-05-28 04:58:47 ','2022-05-28 04:58:47','',''),('5','131',4959573,'','6.1','3241',0.00,0.00,'Sales from shift 257629 on 2022-05-28 04:58:47 ','2022-05-28 04:58:47','',''),('5','131',4959574,'','20','3243',0.00,0.00,'Sales from shift 257630 on 2022-05-29 08:18:02 ','2022-05-29 08:18:02','',''),('5','131',4959575,'','6.1','3241',0.00,0.00,'Sales from shift 257630 on 2022-05-29 08:18:02 ','2022-05-29 08:18:02','',''),('5','131',4959576,'','20','3243',0.00,0.00,'Sales from shift 257631 on 2022-05-30 05:00:05 ','2022-05-30 05:00:05','',''),('5','131',4959577,'','6.1','3241',0.00,0.00,'Sales from shift 257631 on 2022-05-30 05:00:05 ','2022-05-30 05:00:05','',''),('5','131',4959578,'','20','3243',0.00,0.00,'Sales from shift 257632 on 2022-05-31 00:20:50 ','2022-05-31 00:20:50','',''),('5','131',4959579,'','6.1','3241',0.00,0.00,'Sales from shift 257632 on 2022-05-31 00:20:50 ','2022-05-31 00:20:50','',''),('5','131',4959580,'','20','3243',0.00,0.00,'Sales from shift 257633 on 2022-06-01 07:04:48 ','2022-06-01 07:04:48','',''),('5','131',4959581,'','6.1','3241',0.00,0.00,'Sales from shift 257633 on 2022-06-01 07:04:48 ','2022-06-01 07:04:48','',''),('5','131',4959582,'','20','3243',0.00,0.00,'Sales from shift 257634 on 2022-06-02 05:01:37 ','2022-06-02 05:01:37','',''),('5','131',4959583,'','6.1','3241',0.00,0.00,'Sales from shift 257634 on 2022-06-02 05:01:37 ','2022-06-02 05:01:37','',''),('5','131',4959584,'','20','3243',0.00,0.00,'Sales from shift 257635 on 2022-06-03 06:47:16 ','2022-06-03 06:47:16','',''),('5','131',4959585,'','6.1','3241',0.00,0.00,'Sales from shift 257635 on 2022-06-03 06:47:16 ','2022-06-03 06:47:16','',''),('5','131',4959586,'','20','3243',0.00,0.00,'Sales from shift 257636 on 2022-06-04 06:07:10 ','2022-06-04 06:07:10','',''),('5','131',4959587,'','6.1','3241',0.00,0.00,'Sales from shift 257636 on 2022-06-04 06:07:10 ','2022-06-04 06:07:10','',''),('5','131',4959588,'','20','3243',0.00,0.00,'Sales from shift 257637 on 2022-06-05 06:07:48 ','2022-06-05 06:07:48','',''),('5','131',4959589,'','6.1','3241',0.00,0.00,'Sales from shift 257637 on 2022-06-05 06:07:48 ','2022-06-05 06:07:48','',''),('5','131',4959590,'','24','3245',0.00,2475000.00,'Purchase Id 90769 for 15,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-06-05 13:04:30','',''),('5','131',4959591,'','supplier','140',2475000.00,0.00,'Purchase Id 90769 for 15,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-06-05 13:04:30','',''),('5','131',4959592,'','20','3243',681651.30,0.00,'Sales from shift 257638 on 2022-06-06 06:29:41 ','2022-06-06 06:29:41','',''),('5','131',4959593,'','6.1','3241',0.00,681651.30,'Sales from shift 257638 on 2022-06-06 06:29:41 ','2022-06-06 06:29:41','',''),('5','131',4959594,'','6.1','3241',15000.00,0.00,'Payment Id 394624 for invoice:257638, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-06-06 20:54:07','',''),('5','131',4959595,'','supplier','140',0.00,15000.00,'Payment Id 394624 for invoice:257638, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-06-06 20:54:07','',''),('5','131',4959596,'','2','3247',666650.00,0.00,'Payment Id 394623 for invoice:257638, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-06-06 20:54:07','',''),('5','131',4959597,'','supplier','140',0.00,666650.00,'Payment Id 394623 for invoice:257638, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-06-06 20:54:07','',''),('5','131',4959598,'','20','3243',853064.85,0.00,'Sales from shift 257639 on 2022-06-07 07:27:00 ','2022-06-07 07:27:00','',''),('5','131',4959599,'','6.1','3241',0.00,853064.85,'Sales from shift 257639 on 2022-06-07 07:27:00 ','2022-06-07 07:27:00','',''),('5','131',4959600,'','20','3243',625812.00,0.00,'Sales from shift 257640 on 2022-06-08 10:32:13 ','2022-06-08 10:32:13','',''),('5','131',4959601,'','6.1','3241',0.00,625812.00,'Sales from shift 257640 on 2022-06-08 10:32:13 ','2022-06-08 10:32:13','',''),('5','131',4959602,'','6.1','3241',15000.00,0.00,'Payment Id 394626 for invoice:257639, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-06-08 10:34:15','',''),('5','131',4959603,'','supplier','140',0.00,15000.00,'Payment Id 394626 for invoice:257639, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-06-08 10:34:15','',''),('5','131',4959604,'','2','3247',838060.00,0.00,'Payment Id 394625 for invoice:257639, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-06-08 10:34:15','',''),('5','131',4959605,'','supplier','140',0.00,838060.00,'Payment Id 394625 for invoice:257639, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-06-08 10:34:15','',''),('5','131',4959606,'','20','3243',307414.80,0.00,'Sales from shift 257641 on 2022-06-09 06:01:18 ','2022-06-09 06:01:18','',''),('5','131',4959607,'','6.1','3241',0.00,307414.80,'Sales from shift 257641 on 2022-06-09 06:01:18 ','2022-06-09 06:01:18','',''),('5','131',4959608,'','6.1','3241',11700.00,0.00,'Payment Id 394630 for invoice:257640, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-06-09 10:48:38','',''),('5','131',4959609,'','supplier','140',0.00,11700.00,'Payment Id 394630 for invoice:257640, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-06-09 10:48:38','',''),('5','131',4959610,'','6.1','3241',205000.00,0.00,'Payment Id 394629 for invoice:257640, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-06-09 10:48:38','',''),('5','131',4959611,'','supplier','140',0.00,205000.00,'Payment Id 394629 for invoice:257640, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-06-09 10:48:38','',''),('5','131',4959612,'','6.1','3241',15000.00,0.00,'Payment Id 394628 for invoice:257640, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-06-09 10:48:38','',''),('5','131',4959613,'','supplier','140',0.00,15000.00,'Payment Id 394628 for invoice:257640, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-06-09 10:48:38','',''),('5','131',4959614,'','2','3247',394100.00,0.00,'Payment Id 394627 for invoice:257640, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-06-09 10:48:38','',''),('5','131',4959615,'','supplier','140',0.00,394100.00,'Payment Id 394627 for invoice:257640, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-06-09 10:48:38','',''),('5','131',4959616,'','20','3243',0.00,0.00,'Sales from shift 257642 on 2022-06-10 05:28:40 ','2022-06-10 05:28:40','',''),('5','131',4959617,'','6.1','3241',0.00,0.00,'Sales from shift 257642 on 2022-06-10 05:28:40 ','2022-06-10 05:28:40','',''),('5','131',4959618,'','6.1','3241',15000.00,0.00,'Payment Id 394632 for invoice:257641, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-06-10 05:28:58','',''),('5','131',4959619,'','supplier','140',0.00,15000.00,'Payment Id 394632 for invoice:257641, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-06-10 05:28:58','',''),('5','131',4959620,'','2','3247',292400.00,0.00,'Payment Id 394631 for invoice:257641, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-06-10 05:28:58','',''),('5','131',4959621,'','supplier','140',0.00,292400.00,'Payment Id 394631 for invoice:257641, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-06-10 05:28:58','',''),('5','131',4959622,'','20','3243',0.00,0.00,'Sales from shift 257643 on 2022-06-10 21:45:43 ','2022-06-10 21:45:43','',''),('5','131',4959623,'','6.1','3241',0.00,0.00,'Sales from shift 257643 on 2022-06-10 21:45:43 ','2022-06-10 21:45:43','',''),('5','131',4959624,'','20','3243',0.00,0.00,'Sales from shift 257644 on 2022-06-12 08:31:21 ','2022-06-12 08:31:21','',''),('5','131',4959625,'','6.1','3241',0.00,0.00,'Sales from shift 257644 on 2022-06-12 08:31:21 ','2022-06-12 08:31:21','',''),('5','131',4959626,'','20','3243',0.00,0.00,'Sales from shift 257645 on 2022-06-13 06:54:58 ','2022-06-13 06:54:58','',''),('5','131',4959627,'','6.1','3241',0.00,0.00,'Sales from shift 257645 on 2022-06-13 06:54:58 ','2022-06-13 06:54:58','',''),('5','131',4959628,'','20','3243',0.00,0.00,'Sales from shift 257646 on 2022-06-14 08:59:01 ','2022-06-14 08:59:01','',''),('5','131',4959629,'','6.1','3241',0.00,0.00,'Sales from shift 257646 on 2022-06-14 08:59:01 ','2022-06-14 08:59:01','',''),('5','131',4959630,'','20','3243',0.00,0.00,'Sales from shift 257647 on 2022-06-14 22:18:27 ','2022-06-14 22:18:27','',''),('5','131',4959631,'','6.1','3241',0.00,0.00,'Sales from shift 257647 on 2022-06-14 22:18:27 ','2022-06-14 22:18:27','',''),('5','131',4959632,'','20','3243',0.00,0.00,'Sales from shift 257648 on 2022-06-16 07:03:00 ','2022-06-16 07:03:00','',''),('5','131',4959633,'','6.1','3241',0.00,0.00,'Sales from shift 257648 on 2022-06-16 07:03:00 ','2022-06-16 07:03:00','',''),('5','131',4959634,'','20','3243',0.00,0.00,'Sales from shift 257649 on 2022-06-17 06:00:55 ','2022-06-17 06:00:55','',''),('5','131',4959635,'','6.1','3241',0.00,0.00,'Sales from shift 257649 on 2022-06-17 06:00:55 ','2022-06-17 06:00:55','',''),('5','131',4959636,'','20','3243',0.00,0.00,'Sales from shift 257650 on 2022-06-18 07:04:31 ','2022-06-18 07:04:31','',''),('5','131',4959637,'','6.1','3241',0.00,0.00,'Sales from shift 257650 on 2022-06-18 07:04:31 ','2022-06-18 07:04:31','',''),('5','131',4959638,'','20','3243',0.00,0.00,'Sales from shift 257651 on 2022-06-18 22:49:32 ','2022-06-18 22:49:32','',''),('5','131',4959639,'','6.1','3241',0.00,0.00,'Sales from shift 257651 on 2022-06-18 22:49:32 ','2022-06-18 22:49:32','',''),('5','131',4959640,'','20','3243',0.00,0.00,'Sales from shift 257652 on 2022-06-20 06:47:12 ','2022-06-20 06:47:12','',''),('5','131',4959641,'','6.1','3241',0.00,0.00,'Sales from shift 257652 on 2022-06-20 06:47:12 ','2022-06-20 06:47:12','',''),('5','131',4959642,'','20','3243',0.00,0.00,'Sales from shift 257653 on 2022-06-21 07:55:09 ','2022-06-21 07:55:09','',''),('5','131',4959643,'','6.1','3241',0.00,0.00,'Sales from shift 257653 on 2022-06-21 07:55:09 ','2022-06-21 07:55:09','',''),('5','131',4959644,'','20','3243',0.00,0.00,'Sales from shift 257654 on 2022-06-21 22:47:09 ','2022-06-21 22:47:09','',''),('5','131',4959645,'','6.1','3241',0.00,0.00,'Sales from shift 257654 on 2022-06-21 22:47:09 ','2022-06-21 22:47:09','',''),('5','131',4959646,'','20','3243',0.00,0.00,'Sales from shift 257655 on 2022-06-23 07:07:54 ','2022-06-23 07:07:54','',''),('5','131',4959647,'','6.1','3241',0.00,0.00,'Sales from shift 257655 on 2022-06-23 07:07:54 ','2022-06-23 07:07:54','',''),('5','131',4959648,'','20','3243',0.00,0.00,'Sales from shift 257656 on 2022-06-23 22:55:09 ','2022-06-23 22:55:09','',''),('5','131',4959649,'','6.1','3241',0.00,0.00,'Sales from shift 257656 on 2022-06-23 22:55:09 ','2022-06-23 22:55:09','',''),('5','131',4959650,'','20','3243',0.00,0.00,'Sales from shift 257657 on 2022-06-25 06:14:46 ','2022-06-25 06:14:46','',''),('5','131',4959651,'','6.1','3241',0.00,0.00,'Sales from shift 257657 on 2022-06-25 06:14:46 ','2022-06-25 06:14:46','',''),('5','131',4959652,'','20','3243',0.00,0.00,'Sales from shift 257658 on 2022-06-26 07:16:22 ','2022-06-26 07:16:22','',''),('5','131',4959653,'','6.1','3241',0.00,0.00,'Sales from shift 257658 on 2022-06-26 07:16:22 ','2022-06-26 07:16:22','',''),('5','131',4959654,'','20','3243',0.00,0.00,'Sales from shift 257659 on 2022-06-27 07:36:21 ','2022-06-27 07:36:21','',''),('5','131',4959655,'','6.1','3241',0.00,0.00,'Sales from shift 257659 on 2022-06-27 07:36:21 ','2022-06-27 07:36:21','',''),('5','131',4959656,'','20','3243',0.00,0.00,'Sales from shift 257660 on 2022-06-28 07:23:18 ','2022-06-28 07:23:18','',''),('5','131',4959657,'','6.1','3241',0.00,0.00,'Sales from shift 257660 on 2022-06-28 07:23:18 ','2022-06-28 07:23:18','',''),('5','131',4959658,'','20','3243',0.00,0.00,'Sales from shift 257661 on 2022-06-29 08:03:07 ','2022-06-29 08:03:07','',''),('5','131',4959659,'','6.1','3241',0.00,0.00,'Sales from shift 257661 on 2022-06-29 08:03:07 ','2022-06-29 08:03:07','',''),('5','131',4959660,'','20','3243',0.00,0.00,'Sales from shift 257662 on 2022-06-30 06:25:23 ','2022-06-30 06:25:23','',''),('5','131',4959661,'','6.1','3241',0.00,0.00,'Sales from shift 257662 on 2022-06-30 06:25:23 ','2022-06-30 06:25:23','',''),('5','131',4959662,'','20','3243',0.00,0.00,'Sales from shift 257663 on 2022-07-01 07:10:36 ','2022-07-01 07:10:36','',''),('5','131',4959663,'','6.1','3241',0.00,0.00,'Sales from shift 257663 on 2022-07-01 07:10:36 ','2022-07-01 07:10:36','',''),('5','131',4959664,'','20','3243',0.00,0.00,'Sales from shift 257664 on 2022-07-02 05:49:45 ','2022-07-02 05:49:45','',''),('5','131',4959665,'','6.1','3241',0.00,0.00,'Sales from shift 257664 on 2022-07-02 05:49:45 ','2022-07-02 05:49:45','',''),('5','131',4959666,'','20','3243',0.00,0.00,'Sales from shift 257665 on 2022-07-03 06:30:36 ','2022-07-03 06:30:36','',''),('5','131',4959667,'','6.1','3241',0.00,0.00,'Sales from shift 257665 on 2022-07-03 06:30:36 ','2022-07-03 06:30:36','',''),('5','131',4959668,'','20','3243',0.00,0.00,'Sales from shift 257666 on 2022-07-03 23:25:44 ','2022-07-03 23:25:44','',''),('5','131',4959669,'','6.1','3241',0.00,0.00,'Sales from shift 257666 on 2022-07-03 23:25:44 ','2022-07-03 23:25:44','',''),('5','131',4959670,'','20','3243',0.00,0.00,'Sales from shift 257667 on 2022-07-04 22:36:09 ','2022-07-04 22:36:09','',''),('5','131',4959671,'','6.1','3241',0.00,0.00,'Sales from shift 257667 on 2022-07-04 22:36:09 ','2022-07-04 22:36:09','',''),('5','131',4959672,'','20','3243',0.00,0.00,'Sales from shift 257668 on 2022-07-06 07:50:14 ','2022-07-06 07:50:14','',''),('5','131',4959673,'','6.1','3241',0.00,0.00,'Sales from shift 257668 on 2022-07-06 07:50:14 ','2022-07-06 07:50:14','',''),('5','131',4959674,'','20','3243',0.00,0.00,'Sales from shift 257669 on 2022-07-07 05:27:42 ','2022-07-07 05:27:42','',''),('5','131',4959675,'','6.1','3241',0.00,0.00,'Sales from shift 257669 on 2022-07-07 05:27:42 ','2022-07-07 05:27:42','',''),('5','131',4959676,'','20','3243',0.00,0.00,'Sales from shift 257670 on 2022-07-08 07:08:17 ','2022-07-08 07:08:17','',''),('5','131',4959677,'','6.1','3241',0.00,0.00,'Sales from shift 257670 on 2022-07-08 07:08:17 ','2022-07-08 07:08:17','',''),('5','131',4959678,'','20','3243',0.00,0.00,'Sales from shift 257671 on 2022-07-08 22:42:41 ','2022-07-08 22:42:41','',''),('5','131',4959679,'','6.1','3241',0.00,0.00,'Sales from shift 257671 on 2022-07-08 22:42:41 ','2022-07-08 22:42:41','',''),('5','131',4959680,'','20','3243',0.00,0.00,'Sales from shift 257672 on 2022-07-10 07:04:53 ','2022-07-10 07:04:53','',''),('5','131',4959681,'','6.1','3241',0.00,0.00,'Sales from shift 257672 on 2022-07-10 07:04:53 ','2022-07-10 07:04:53','',''),('5','131',4959682,'','24','3245',0.00,60094.00,'Inventory value adjustment for product Id 308 from 165.00 to 185.00','2022-07-10 08:12:48','',''),('5','131',4959683,'','supplier','140',60094.00,0.00,'Inventory value adjustment for product Id 308 from 165.00 to 185.00','2022-07-10 08:12:48','',''),('5','131',4959684,'','20','3243',0.00,0.00,'Sales from shift 257673 on 2022-07-11 07:01:19 ','2022-07-11 07:01:19','',''),('5','131',4959685,'','6.1','3241',0.00,0.00,'Sales from shift 257673 on 2022-07-11 07:01:19 ','2022-07-11 07:01:19','',''),('5','131',4959686,'','20','3243',0.00,0.00,'Sales from shift 257674 on 2022-07-12 05:23:27 ','2022-07-12 05:23:27','',''),('5','131',4959687,'','6.1','3241',0.00,0.00,'Sales from shift 257674 on 2022-07-12 05:23:27 ','2022-07-12 05:23:27','',''),('5','131',4959688,'','20','3243',0.00,0.00,'Sales from shift 257675 on 2022-07-13 07:18:42 ','2022-07-13 07:18:42','',''),('5','131',4959689,'','6.1','3241',0.00,0.00,'Sales from shift 257675 on 2022-07-13 07:18:42 ','2022-07-13 07:18:42','',''),('5','131',4959690,'','20','3243',0.00,0.00,'Sales from shift 257676 on 2022-07-14 06:33:27 ','2022-07-14 06:33:27','',''),('5','131',4959691,'','6.1','3241',0.00,0.00,'Sales from shift 257676 on 2022-07-14 06:33:27 ','2022-07-14 06:33:27','',''),('5','131',4959692,'','20','3243',0.00,0.00,'Sales from shift 257677 on 2022-07-15 07:18:33 ','2022-07-15 07:18:33','',''),('5','131',4959693,'','6.1','3241',0.00,0.00,'Sales from shift 257677 on 2022-07-15 07:18:33 ','2022-07-15 07:18:33','',''),('5','131',4959694,'','20','3243',0.00,0.00,'Sales from shift 257678 on 2022-07-16 06:54:34 ','2022-07-16 06:54:34','',''),('5','131',4959695,'','6.1','3241',0.00,0.00,'Sales from shift 257678 on 2022-07-16 06:54:34 ','2022-07-16 06:54:34','',''),('5','131',4959696,'','20','3243',0.00,0.00,'Sales from shift 257679 on 2022-07-17 05:30:18 ','2022-07-17 05:30:18','',''),('5','131',4959697,'','6.1','3241',0.00,0.00,'Sales from shift 257679 on 2022-07-17 05:30:18 ','2022-07-17 05:30:18','',''),('5','131',4959698,'','20','3243',0.00,0.00,'Sales from shift 257680 on 2022-07-18 07:35:54 ','2022-07-18 07:35:54','',''),('5','131',4959699,'','6.1','3241',0.00,0.00,'Sales from shift 257680 on 2022-07-18 07:35:54 ','2022-07-18 07:35:54','',''),('5','131',4959700,'','20','3243',0.00,0.00,'Sales from shift 257681 on 2022-07-18 20:02:28 ','2022-07-18 20:02:28','',''),('5','131',4959701,'','6.1','3241',0.00,0.00,'Sales from shift 257681 on 2022-07-18 20:02:28 ','2022-07-18 20:02:28','',''),('5','131',4959702,'','20','3243',0.00,0.00,'Sales from shift 257682 on 2022-07-20 07:40:48 ','2022-07-20 07:40:48','',''),('5','131',4959703,'','6.1','3241',0.00,0.00,'Sales from shift 257682 on 2022-07-20 07:40:48 ','2022-07-20 07:40:48','',''),('5','131',4959704,'','24','3245',0.00,8306500.00,'Purchase Id 90770 for 44,900.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-07-20 14:56:14','',''),('5','131',4959705,'','supplier','140',8306500.00,0.00,'Purchase Id 90770 for 44,900.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LTD','2022-07-20 14:56:14','',''),('5','131',4959706,'','20','3243',1316990.95,0.00,'Sales from shift 257683 on 2022-07-21 07:59:20 ','2022-07-21 07:59:20','',''),('5','131',4959707,'','6.1','3241',0.00,1316990.95,'Sales from shift 257683 on 2022-07-21 07:59:20 ','2022-07-21 07:59:20','',''),('5','131',4959708,'','6.1','3241',205000.00,0.00,'Payment Id 394635 for invoice:257683, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-07-21 19:57:55','',''),('5','131',4959709,'','supplier','140',0.00,205000.00,'Payment Id 394635 for invoice:257683, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-07-21 19:57:55','',''),('5','131',4959710,'','6.1','3241',17000.00,0.00,'Payment Id 394634 for invoice:257683, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-07-21 19:57:55','',''),('5','131',4959711,'','supplier','140',0.00,17000.00,'Payment Id 394634 for invoice:257683, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-07-21 19:57:55','',''),('5','131',4959712,'','2','3247',1094990.00,0.00,'Payment Id 394633 for invoice:257683, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-07-21 19:57:55','',''),('5','131',4959713,'','supplier','140',0.00,1094990.00,'Payment Id 394633 for invoice:257683, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-07-21 19:57:55','',''),('5','131',4959714,'','20','3243',1319658.65,0.00,'Sales from shift 257684 on 2022-07-21 23:14:39 ','2022-07-21 23:14:39','',''),('5','131',4959715,'','6.1','3241',0.00,1319658.65,'Sales from shift 257684 on 2022-07-21 23:14:39 ','2022-07-21 23:14:39','',''),('5','131',4959716,'','20','3243',1025780.60,0.00,'Sales from shift 257685 on 2022-07-23 06:55:43 ','2022-07-23 06:55:43','',''),('5','131',4959717,'','6.1','3241',0.00,1025780.60,'Sales from shift 257685 on 2022-07-23 06:55:43 ','2022-07-23 06:55:43','',''),('5','131',4959718,'','6.1','3241',17000.00,0.00,'Payment Id 394637 for invoice:257684, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-07-23 10:02:10','',''),('5','131',4959719,'','supplier','140',0.00,17000.00,'Payment Id 394637 for invoice:257684, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-07-23 10:02:10','',''),('5','131',4959720,'','2','3247',1302660.00,0.00,'Payment Id 394636 for invoice:257684, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-07-23 10:02:10','',''),('5','131',4959721,'','supplier','140',0.00,1302660.00,'Payment Id 394636 for invoice:257684, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-07-23 10:02:10','',''),('5','131',4959722,'','20','3243',1291490.55,0.00,'Sales from shift 257686 on 2022-07-24 08:32:51 ','2022-07-24 08:32:51','',''),('5','131',4959723,'','6.1','3241',0.00,1291490.55,'Sales from shift 257686 on 2022-07-24 08:32:51 ','2022-07-24 08:32:51','',''),('5','131',4959724,'','20','3243',1297449.40,0.00,'Sales from shift 257687 on 2022-07-25 06:45:21 ','2022-07-25 06:45:21','',''),('5','131',4959725,'','6.1','3241',0.00,1297449.40,'Sales from shift 257687 on 2022-07-25 06:45:21 ','2022-07-25 06:45:21','',''),('5','131',4959726,'','6.1','3241',17000.00,0.00,'Payment Id 394643 for invoice:257687, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-07-25 18:47:31','',''),('5','131',4959727,'','supplier','140',0.00,17000.00,'Payment Id 394643 for invoice:257687, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-07-25 18:47:31','',''),('5','131',4959728,'','2','3247',1280440.00,0.00,'Payment Id 394642 for invoice:257687, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-07-25 18:47:31','',''),('5','131',4959729,'','supplier','140',0.00,1280440.00,'Payment Id 394642 for invoice:257687, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-07-25 18:47:31','',''),('5','131',4959730,'','6.1','3241',17000.00,0.00,'Payment Id 394641 for invoice:257686, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-07-25 18:47:31','',''),('5','131',4959731,'','supplier','140',0.00,17000.00,'Payment Id 394641 for invoice:257686, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-07-25 18:47:31','',''),('5','131',4959732,'','2','3247',1274490.00,0.00,'Payment Id 394640 for invoice:257686, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-07-25 18:47:31','',''),('5','131',4959733,'','supplier','140',0.00,1274490.00,'Payment Id 394640 for invoice:257686, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-07-25 18:47:31','',''),('5','131',4959734,'','6.1','3241',17000.00,0.00,'Payment Id 394639 for invoice:257685, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-07-25 18:47:31','',''),('5','131',4959735,'','supplier','140',0.00,17000.00,'Payment Id 394639 for invoice:257685, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-07-25 18:47:31','',''),('5','131',4959736,'','2','3247',1008780.00,0.00,'Payment Id 394638 for invoice:257685, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-07-25 18:47:31','',''),('5','131',4959737,'','supplier','140',0.00,1008780.00,'Payment Id 394638 for invoice:257685, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-07-25 18:47:31','',''),('5','131',4959738,'','20','3243',736498.95,0.00,'Sales from shift 257688 on 2022-07-26 05:54:26 ','2022-07-26 05:54:26','',''),('5','131',4959739,'','6.1','3241',0.00,736498.95,'Sales from shift 257688 on 2022-07-26 05:54:26 ','2022-07-26 05:54:26','',''),('5','131',4959740,'','6.1','3241',17000.00,0.00,'Payment Id 394645 for invoice:257688, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-07-26 18:18:34','',''),('5','131',4959741,'','supplier','140',0.00,17000.00,'Payment Id 394645 for invoice:257688, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-07-26 18:18:34','',''),('5','131',4959742,'','2','3247',808770.00,0.00,'Payment Id 394644 for invoice:257688, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-07-26 18:18:34','',''),('5','131',4959743,'','supplier','140',0.00,808770.00,'Payment Id 394644 for invoice:257688, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-07-26 18:18:34','',''),('5','131',4959744,'','20','3243',945037.35,0.00,'Sales from shift 257689 on 2022-07-27 06:05:10 ','2022-07-27 06:05:10','',''),('5','131',4959745,'','6.1','3241',0.00,945037.35,'Sales from shift 257689 on 2022-07-27 06:05:10 ','2022-07-27 06:05:10','',''),('5','131',4959746,'','20','3243',346958.25,0.00,'Sales from shift 257690 on 2022-07-28 06:54:52 ','2022-07-28 06:54:52','',''),('5','131',4959747,'','6.1','3241',0.00,346958.25,'Sales from shift 257690 on 2022-07-28 06:54:52 ','2022-07-28 06:54:52','',''),('5','131',4959748,'','20','3243',0.00,0.00,'Sales from shift 257691 on 2022-07-29 07:12:57 ','2022-07-29 07:12:57','',''),('5','131',4959749,'','6.1','3241',0.00,0.00,'Sales from shift 257691 on 2022-07-29 07:12:57 ','2022-07-29 07:12:57','',''),('5','131',4959750,'','20','3243',0.00,0.00,'Sales from shift 257692 on 2022-07-30 09:12:39 ','2022-07-30 09:12:39','',''),('5','131',4959751,'','6.1','3241',0.00,0.00,'Sales from shift 257692 on 2022-07-30 09:12:39 ','2022-07-30 09:12:39','',''),('5','131',4959752,'','20','3243',0.00,0.00,'Sales from shift 257693 on 2022-07-31 05:23:36 ','2022-07-31 05:23:36','',''),('5','131',4959753,'','6.1','3241',0.00,0.00,'Sales from shift 257693 on 2022-07-31 05:23:36 ','2022-07-31 05:23:36','',''),('5','131',4959754,'','20','3243',0.00,0.00,'Sales from shift 257694 on 2022-08-01 07:49:32 ','2022-08-01 07:49:32','',''),('5','131',4959755,'','6.1','3241',0.00,0.00,'Sales from shift 257694 on 2022-08-01 07:49:32 ','2022-08-01 07:49:32','',''),('5','131',4959756,'','20','3243',0.00,0.00,'Sales from shift 257695 on 2022-08-02 05:39:01 ','2022-08-02 05:39:01','',''),('5','131',4959757,'','6.1','3241',0.00,0.00,'Sales from shift 257695 on 2022-08-02 05:39:01 ','2022-08-02 05:39:01','',''),('5','131',4959758,'','20','3243',0.00,0.00,'Sales from shift 257696 on 2022-08-03 10:30:26 ','2022-08-03 10:30:26','',''),('5','131',4959759,'','6.1','3241',0.00,0.00,'Sales from shift 257696 on 2022-08-03 10:30:26 ','2022-08-03 10:30:26','',''),('5','131',4959760,'','20','3243',0.00,0.00,'Sales from shift 257697 on 2022-08-04 06:15:39 ','2022-08-04 06:15:39','',''),('5','131',4959761,'','6.1','3241',0.00,0.00,'Sales from shift 257697 on 2022-08-04 06:15:39 ','2022-08-04 06:15:39','',''),('5','131',4959762,'','20','3243',0.00,0.00,'Sales from shift 257698 on 2022-08-04 21:54:25 ','2022-08-04 21:54:25','',''),('5','131',4959763,'','6.1','3241',0.00,0.00,'Sales from shift 257698 on 2022-08-04 21:54:25 ','2022-08-04 21:54:25','',''),('5','131',4959764,'','20','3243',0.00,0.00,'Sales from shift 257699 on 2022-08-06 06:55:22 ','2022-08-06 06:55:22','',''),('5','131',4959765,'','6.1','3241',0.00,0.00,'Sales from shift 257699 on 2022-08-06 06:55:22 ','2022-08-06 06:55:22','',''),('5','131',4959766,'','20','3243',0.00,0.00,'Sales from shift 257700 on 2022-08-07 05:37:26 ','2022-08-07 05:37:26','',''),('5','131',4959767,'','6.1','3241',0.00,0.00,'Sales from shift 257700 on 2022-08-07 05:37:26 ','2022-08-07 05:37:26','',''),('5','131',4959768,'','20','3243',0.00,0.00,'Sales from shift 257701 on 2022-10-26 12:27:44 ','2022-10-26 12:27:44','',''),('5','131',4959769,'','6.1','3241',0.00,0.00,'Sales from shift 257701 on 2022-10-26 12:27:44 ','2022-10-26 12:27:44','',''),('5','131',4959770,'','6.1','3241',0.00,235000.00,'Payment Id 394596 for invoice:257602, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-10-26 12:29:27','',''),('5','131',4959771,'','supplier','140',235000.00,0.00,'Payment Id 394596 for invoice:257602, receipt:  by SALBAS OIL & GAS NIG. LTD','2022-10-26 12:29:27','','');
/*!40000 ALTER TABLE `ledgers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `options`
--

DROP TABLE IF EXISTS `options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `options` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` bigint NOT NULL,
  `station_id` bigint NOT NULL,
  `option_key` varchar(200) NOT NULL,
  `option_value` longtext,
  `thedate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `station_id` (`station_id`,`option_key`),
  KEY `company_id` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `options`
--

LOCK TABLES `options` WRITE;
/*!40000 ALTER TABLE `options` DISABLE KEYS */;
/*!40000 ALTER TABLE `options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products`
--

DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `measurement` varchar(20) NOT NULL,
  `quantity2` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`code`,`name`,`measurement`,`quantity2`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `cleanup` (`cleanup`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB AUTO_INCREMENT=311 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products`
--

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (308,'5','131','PMS','Petrol','Litres',1,185.00,165.00,165.00,165.00,0.00,0,'2020-03-23 14:04:37','475','475','2020-03-23 14:04:37',1),(309,'5','131','AGO','Diesel','Litres',1,345.00,345.00,345.00,345.00,0.00,0,'2020-03-23 14:24:47','475','475','2020-03-23 14:24:47',1),(310,'5','131','DPK','Kerosene','Litres',1,0.00,0.00,0.00,0.00,0.00,0,'2020-03-23 14:28:53','475','475','2020-03-23 14:28:53',1);
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_changevalues`
--

DROP TABLE IF EXISTS `products_changevalues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_changevalues` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `change_id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity` bigint NOT NULL,
  `oldrate` decimal(20,2) NOT NULL,
  `newrate` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`change_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_changevalues`
--

LOCK TABLES `products_changevalues` WRITE;
/*!40000 ALTER TABLE `products_changevalues` DISABLE KEYS */;
INSERT INTO `products_changevalues` VALUES ('5','131',1,'308','257673',2868,165.00,185.00,'','628','2022-07-10 08:12:48');
/*!40000 ALTER TABLE `products_changevalues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_prices`
--

DROP TABLE IF EXISTS `products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB AUTO_INCREMENT=16648 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_prices`
--

LOCK TABLES `products_prices` WRITE;
/*!40000 ALTER TABLE `products_prices` DISABLE KEYS */;
INSERT INTO `products_prices` VALUES (12596,'5','131',308,163.00,0.00,0.00,0.00,'Cost from purchase id #63111','2021-03-07 18:22:42','600'),(13177,'5','131',309,265.00,0.00,0.00,0.00,'Cost from purchase id #65246','2021-04-03 18:20:17','605'),(13440,'5','131',308,165.00,0.00,0.00,0.00,'Cost from purchase id #67108','2021-04-30 13:32:53','605'),(13604,'5','131',309,270.00,270.00,270.00,270.00,'AGO NEW PRICE','2021-05-24 08:03:40','600'),(13605,'5','131',308,165.00,165.00,165.00,165.00,'PMS NEW PRICE','2021-05-24 08:04:46','600'),(13829,'5','131',309,275.00,275.00,275.00,275.00,'','2021-06-05 21:41:16','628'),(14128,'5','131',309,290.00,290.00,290.00,290.00,'AGO  NEW PRICE','2021-06-25 09:10:37','600'),(14485,'5','131',308,165.00,165.00,0.00,0.00,'Cost from purchase id #72415','2021-07-14 10:44:10','605'),(14731,'5','131',308,163.00,165.00,0.00,0.00,'Cost from purchase id #73434','2021-07-30 06:14:09','605'),(15992,'5','131',309,300.00,290.00,0.00,0.00,'Cost from purchase id #78064','2021-10-11 14:13:49','600'),(16366,'5','131',309,345.00,345.00,345.00,345.00,'','2021-10-21 09:09:54','600'),(16647,'5','131',308,165.00,165.00,0.00,0.00,'Cost from purchase id #79489','2021-10-31 15:08:04','664');
/*!40000 ALTER TABLE `products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_reconciliations`
--

DROP TABLE IF EXISTS `products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_reconciliations`
--

LOCK TABLES `products_reconciliations` WRITE;
/*!40000 ALTER TABLE `products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_shortages`
--

DROP TABLE IF EXISTS `products_shortages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_shortages` (
  `shortage_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shortagedate` date NOT NULL,
  `product_id` varchar(10) NOT NULL,
  `type` int NOT NULL DEFAULT '0',
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`shortage_id`),
  KEY `companycode` (`company_id`,`shortagedate`,`product_id`,`rate`,`quantity`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_shortages`
--

LOCK TABLES `products_shortages` WRITE;
/*!40000 ALTER TABLE `products_shortages` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_shortages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pts_nozzles`
--

DROP TABLE IF EXISTS `pts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pts_nozzles` (
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pts_id` int NOT NULL,
  `pump` varchar(20) NOT NULL,
  `code` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `last_volume` decimal(20,2) NOT NULL,
  `last_price` decimal(20,2) NOT NULL,
  `last_amount` decimal(20,2) NOT NULL,
  `last_transaction` int NOT NULL DEFAULT '0',
  `total_volume` decimal(20,2) NOT NULL,
  `total_amount` decimal(20,2) NOT NULL,
  `total_transactions` decimal(20,2) NOT NULL,
  `lastconnect` datetime NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `terminal_id` (`pts_id`,`pump`,`code`,`lastconnect`),
  KEY `companycode` (`company_id`,`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pts_nozzles`
--

LOCK TABLES `pts_nozzles` WRITE;
/*!40000 ALTER TABLE `pts_nozzles` DISABLE KEYS */;
/*!40000 ALTER TABLE `pts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases`
--

DROP TABLE IF EXISTS `purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=90771 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases`
--

LOCK TABLES `purchases` WRITE;
/*!40000 ALTER TABLE `purchases` DISABLE KEYS */;
INSERT INTO `purchases` VALUES (78064,'5','131','2021-10-01',309,140,300.00,900.00,0.00,0.00,270000.00,0.00,'','NIL','NIL','','','','2021-10-11 14:08:16',15,'','600','','0000-00-00 00:00:00','600','2021-10-11 14:13:49'),(78065,'5','131','2021-10-01',308,140,163.00,1500.00,0.00,0.00,244500.00,0.00,'','NIL','NIL','','','','2021-10-11 14:13:07',15,'','600','','0000-00-00 00:00:00','600','2021-10-11 14:13:30'),(78068,'5','131','2021-10-03',308,140,163.00,15050.00,0.00,0.00,2453150.00,0.00,'','','MKA 901 ZE ','','','','2021-10-11 15:05:29',15,'','628','','0000-00-00 00:00:00','664','2021-10-11 15:09:24'),(78099,'5','131','2021-10-11',308,140,163.00,40000.00,0.00,0.00,6520000.00,0.00,'','2207','KMC 32 XX ','','','','2021-10-12 08:32:39',15,'','628','','0000-00-00 00:00:00','664','2021-10-12 13:19:27'),(78518,'5','131','2021-10-17',308,140,163.00,13450.00,0.00,0.00,2192350.00,0.00,'','2062','NSR 186 ZU ','','','','2021-10-17 16:01:14',15,'','628','','0000-00-00 00:00:00','664','2021-10-18 08:01:10'),(78869,'5','131','2021-10-22',308,140,163.00,13425.00,0.00,0.00,2188275.00,0.00,'','2447','TRN 184 ZG ','','','','2021-10-22 04:21:43',15,'','628','','0000-00-00 00:00:00','664','2021-10-22 09:11:10'),(79489,'5','131','2021-10-31',308,140,165.00,29900.00,0.00,0.00,4933500.00,0.00,'','','LSD 602 XY ','','','','2021-10-31 15:02:07',15,'','628','','0000-00-00 00:00:00','664','2021-10-31 15:08:04'),(79492,'5','131','2021-10-31',308,140,165.00,100.00,0.00,0.00,16500.00,0.00,'','2216','LSD 602 XY ','','','','2021-10-31 15:42:08',15,'','628','','0000-00-00 00:00:00','664','2021-10-31 16:15:21'),(80342,'5','131','2021-11-11',308,140,165.00,15000.00,0.00,0.00,2475000.00,0.00,'','3356','LSD 602 XY ','','','','2021-11-11 19:33:59',15,'','628','','0000-00-00 00:00:00','664','2021-11-12 13:21:50'),(80931,'5','131','2021-11-19',308,140,165.00,13000.00,0.00,0.00,2145000.00,0.00,'','1944','NSR 105 ZQ','','','','2021-11-19 10:45:03',15,'','628','','0000-00-00 00:00:00','664','2021-11-19 10:46:44'),(85450,'5','131','2021-11-23',308,140,165.00,45000.00,0.00,0.00,7425000.00,0.00,'','2222 ','Kmc 39 xx ','','','','2021-11-23 08:04:32',15,'','628','','0000-00-00 00:00:00','664','2021-11-23 08:43:59'),(86191,'5','131','2021-12-02',308,140,165.00,15100.00,0.00,0.00,2491500.00,0.00,'','2065','Kmc 38 xx ','','','','2021-12-02 06:49:46',15,'','628','','0000-00-00 00:00:00','664','2021-12-02 16:45:16'),(86306,'5','131','2021-12-03',308,140,165.00,15130.00,0.00,0.00,2496450.00,0.00,'','2067','BCH 743 XA ','','','','2021-12-03 15:13:04',15,'','628','','0000-00-00 00:00:00','664','2021-12-03 16:36:17'),(86582,'5','131','2021-12-07',308,140,165.00,40000.00,0.00,0.00,6600000.00,0.00,'','2069','TRN 181 ZG ','','','','2021-12-07 15:26:37',15,'','628','','0000-00-00 00:00:00','664','2021-12-07 16:32:00'),(87434,'5','131','2021-12-17',308,140,165.00,30000.00,0.00,0.00,4950000.00,0.00,'','2071','LSD 769 XY ','','','','2021-12-17 13:13:05',15,'','628','','0000-00-00 00:00:00','664','2021-12-17 15:45:22'),(88913,'5','131','2022-01-05',308,140,165.00,39450.00,0.00,0.00,6509250.00,0.00,'','2075','RAN 550 XA ','','','','2022-01-05 17:02:24',15,'','628','','0000-00-00 00:00:00','664','2022-01-05 17:36:22'),(89521,'5','131','2022-01-13',308,140,165.00,13000.00,0.00,0.00,2145000.00,0.00,'','2073','NSR 34 ZU ','','','','2022-01-13 22:19:01',15,'','628','','0000-00-00 00:00:00','664','2022-01-14 10:10:25'),(90757,'5','131','2022-01-30',308,140,165.00,22300.00,0.00,0.00,3679500.00,0.00,'','2080','BCH 735 XA ','','','','2022-01-30 07:52:51',15,'','628','','0000-00-00 00:00:00','664','2022-01-30 12:32:27'),(90758,'5','131','2022-02-01',308,140,165.00,29850.00,0.00,0.00,4925250.00,0.00,'','2076','LSD 763 XY ','','','','2022-02-01 20:56:08',15,'','628','','0000-00-00 00:00:00','664','2022-02-03 20:39:04'),(90759,'5','131','2022-02-03',308,140,165.00,45000.00,0.00,0.00,7425000.00,0.00,'','2082','LSD 602 XY ','','','','2022-02-03 20:37:47',15,'','628','','0000-00-00 00:00:00','664','2022-02-03 20:39:21'),(90760,'5','131','2022-02-15',308,140,165.00,12900.00,0.00,0.00,2128500.00,0.00,'','8079','NSR 105 ZQ','','','','2022-02-15 19:52:20',15,'','628','','0000-00-00 00:00:00','664','2022-02-17 12:06:30'),(90761,'5','131','2022-02-21',308,140,165.00,39600.00,0.00,0.00,6534000.00,0.00,'','2084','Kmc 32 XX ','','','','2022-02-21 09:56:58',15,'','628','','0000-00-00 00:00:00','664','2022-02-21 10:03:20'),(90762,'5','131','2022-02-27',308,140,165.00,17000.00,0.00,0.00,2805000.00,0.00,'','2030','GGE 591 XY ','','','','2022-02-27 08:15:56',15,'','628','','0000-00-00 00:00:00','664','2022-03-02 14:35:02'),(90763,'5','131','2022-03-14',308,140,165.00,30000.00,0.00,0.00,4950000.00,0.00,'','1949','LSD 602 XY ','','','','2022-03-14 10:45:52',15,'','628','','0000-00-00 00:00:00','664','2022-03-14 19:44:27'),(90764,'5','131','2022-03-24',308,140,165.00,13500.00,0.00,0.00,2227500.00,0.00,'','2096','KMC 604 ZU ','','','','2022-03-24 12:26:49',15,'','628','','0000-00-00 00:00:00','664','2022-03-24 12:46:53'),(90765,'5','131','2022-04-12',308,140,165.00,15000.00,0.00,0.00,2475000.00,0.00,'','1181','DKA 289 ZU ','','','','2022-04-12 21:40:13',15,'','628','','0000-00-00 00:00:00','664','2022-04-13 04:04:48'),(90766,'5','131','2022-04-21',308,140,165.00,13500.00,0.00,0.00,2227500.00,0.00,'','1160','TRN 148 ZQ ','','','','2022-04-21 11:13:41',15,'','628','','0000-00-00 00:00:00','664','2022-04-21 11:15:14'),(90767,'5','131','2022-04-29',308,140,165.00,30000.00,0.00,0.00,4950000.00,0.00,'','1708','KMC 38 XX ','','','','2022-04-29 07:55:06',15,'','628','','0000-00-00 00:00:00','664','2022-04-29 14:47:25'),(90768,'5','131','2022-05-03',308,140,165.00,40000.00,0.00,0.00,6600000.00,0.00,'','1652','TRN 183 ZG ','','','','2022-05-09 07:36:48',15,'','628','','0000-00-00 00:00:00','664','2022-05-09 14:01:49'),(90769,'5','131','2022-06-05',308,140,165.00,15000.00,0.00,0.00,2475000.00,0.00,'','1655','LSD 763 XY ','','','','2022-06-05 13:00:21',15,'','628','','0000-00-00 00:00:00','664','2022-06-05 13:04:30'),(90770,'5','131','2022-07-19',308,140,185.00,44900.00,0.00,0.00,8306500.00,0.00,'','1653','NSR 596 ZD ','','','','2022-07-19 20:38:32',15,'','628','','0000-00-00 00:00:00','664','2022-07-20 14:56:14');
/*!40000 ALTER TABLE `purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_payments`
--

DROP TABLE IF EXISTS `purchases_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `supplier_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`supplier_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=394647 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_payments`
--

LOCK TABLES `purchases_payments` WRITE;
/*!40000 ALTER TABLE `purchases_payments` DISABLE KEYS */;
INSERT INTO `purchases_payments` VALUES (342709,'5','131','2021-10-03',140,'022','','5',550260.00,'230680','','','3246','Zaria 2 ','41679',568964.54,'2021-10-11 15:57:40',5,'','628','','0000-00-00 00:00:00','664','2021-10-13 05:54:31'),(342710,'5','131','2021-10-03',140,'','','2',11700.00,'230680','','','','','',0.00,'2021-10-11 15:59:13',5,'','628','','0000-00-00 00:00:00','664','2021-10-13 05:54:31'),(342713,'5','131','2021-10-04',140,'026','','5',523500.00,'230710','','','3246','Zaria 2 ','46742',530525.88,'2021-10-11 16:02:15',5,'','628','','0000-00-00 00:00:00','664','2021-10-13 05:54:31'),(342941,'5','131','2021-10-05',140,'0026','','5',602480.00,'230763','','','3246','Zaria 2 ','005374',609481.45,'2021-10-12 08:28:00',5,'','628','','0000-00-00 00:00:00','664','2021-10-13 05:54:31'),(342945,'5','131','2021-10-05',140,'','','2',7000.00,'230763','','','','','',0.00,'2021-10-12 08:29:04',5,'','628','','0000-00-00 00:00:00','664','2021-10-13 05:54:31'),(342947,'5','131','2021-10-06',140,'022','','5',463670.00,'230821','','','3246','Zaria 2 ','75425',470879.29,'2021-10-12 08:30:09',5,'','628','','0000-00-00 00:00:00','664','2021-10-13 05:54:31'),(343183,'5','131','2021-10-07',140,'026','','5',303430.00,'230933','','','3246','Zaria 2 ','5643',310638.88,'2021-10-12 12:52:41',5,'','628','','0000-00-00 00:00:00','664','2021-10-13 05:54:31'),(343185,'5','131','2021-10-07',140,'','','2',7200.00,'230933','','','','','',0.00,'2021-10-12 12:53:19',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2021-10-13 05:54:31'),(343619,'5','131','2021-10-12',140,'220','','5',690420.00,'231096','','','3246','Zaria 2 ','230933',916824.47,'2021-10-13 10:16:41',5,'','628','','0000-00-00 00:00:00','664','2021-10-13 12:35:52'),(343621,'5','131','2021-10-12',140,'022','','2',7400.00,'231096','','','','','',0.00,'2021-10-13 10:17:37',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2021-10-13 12:35:52'),(343624,'5','131','2021-10-12',140,'022','','2',219000.00,'231096','','','','','',0.00,'2021-10-13 10:19:42',5,'Salary payment ','628','','0000-00-00 00:00:00','664','2021-10-13 12:35:52'),(344156,'5','131','2021-10-13',140,'024','','5',781030.00,'231119','','','3246','Zaria 2 ','007705',793433.47,'2021-10-14 09:50:41',5,'','628','','0000-00-00 00:00:00','664','2021-10-14 14:38:28'),(344157,'5','131','2021-10-13',140,'','','2',7400.00,'231119','','','','','',0.00,'2021-10-14 09:51:24',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2021-10-14 14:38:28'),(344160,'5','131','2021-10-13',140,'','','2',5000.00,'231119','','','','','',0.00,'2021-10-14 09:52:18',5,'Pump repair ','628','','0000-00-00 00:00:00','664','2021-10-14 14:38:28'),(344770,'5','131','2021-10-15',140,'231363','','5',853450.00,'231709','','','3246','Zaria 2 ','00035',860853.53,'2021-10-15 09:39:06',5,'','628','','0000-00-00 00:00:00','664','2021-10-15 15:14:01'),(344773,'5','131','2021-10-14',140,'','','2',7400.00,'231363','','','','','',0.00,'2021-10-15 09:40:37',5,'','628','','0000-00-00 00:00:00','664','2021-10-15 15:14:01'),(346484,'5','131','2021-10-15',140,'022','','5',914780.00,'231709','','','3246','Zaria 2 ','00063',922180.65,'2021-10-18 12:21:09',5,'','628','','0000-00-00 00:00:00','664','2021-10-18 18:19:59'),(346485,'5','131','2021-10-15',140,'022','','2',7400.00,'231709','','','','Zaria 2 ','',0.00,'2021-10-18 12:23:30',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2021-10-18 18:19:59'),(346489,'5','131','2021-10-16',140,'022','','5',787490.00,'232070','','','3246','Zaria 2 ','09764',797037.40,'2021-10-18 12:24:41',5,'','628','','0000-00-00 00:00:00','664','2021-10-18 18:19:59'),(346491,'5','131','2021-10-16',140,'','','2',7540.00,'232070','','','','','',0.00,'2021-10-18 12:25:17',5,'','628','','0000-00-00 00:00:00','664','2021-10-18 18:19:59'),(346493,'5','131','2021-10-16',140,'','','2',2000.00,'232070','','','','','',0.00,'2021-10-18 12:25:43',5,'','628','','0000-00-00 00:00:00','664','2021-10-18 18:19:59'),(346495,'5','131','2021-10-17',140,'022','','5',584100.00,'232263','','','3246','Zaria 2 ','00065',591649.25,'2021-10-18 12:26:44',5,'','628','','0000-00-00 00:00:00','664','2021-10-18 18:19:59'),(346496,'5','131','2021-10-17',140,'','','2',7540.00,'232263','','','','','',0.00,'2021-10-18 12:27:13',5,'','628','','0000-00-00 00:00:00','664','2021-10-18 18:19:59'),(347576,'5','131','2021-10-18',140,'032','','5',667570.00,'232392','','','3246','Zaria 2 ','003628',675115.04,'2021-10-20 12:25:48',5,'','628','','0000-00-00 00:00:00','664','2021-10-20 16:53:45'),(347579,'5','131','2021-10-18',140,'','','2',7540.00,'232392','','','','','',0.00,'2021-10-20 12:26:24',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2021-10-20 16:53:45'),(347580,'5','131','2021-10-19',140,'032','','5',687000.00,'232669','','','3246','Zaria 2 ','003626',694552.78,'2021-10-20 12:28:24',5,'','628','','0000-00-00 00:00:00','664','2021-10-20 16:53:45'),(347581,'5','131','2021-10-19',140,'','','2',7540.00,'232669','','','','','',0.00,'2021-10-20 12:29:07',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2021-10-20 16:53:45'),(348649,'5','131','2021-10-20',140,'034','','5',620100.00,'232911','','','3246','Zaria 2 ','00466',627703.22,'2021-10-22 08:59:20',5,'','628','','0000-00-00 00:00:00','664','2021-10-22 09:12:22'),(348650,'5','131','2021-10-20',140,'','','2',7600.00,'232911','','','','','',0.00,'2021-10-22 08:59:59',5,'','628','','0000-00-00 00:00:00','664','2021-10-22 09:12:22'),(348651,'5','131','2021-10-21',140,'045','','5',407720.00,'233127','','','3246','Zaria 2 ','00774',415627.18,'2021-10-22 09:01:24',5,'','628','','0000-00-00 00:00:00','664','2021-10-22 10:35:51'),(348653,'5','131','2021-10-21',140,'','','2',7900.00,'233127','','','','','',0.00,'2021-10-22 09:02:07',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2021-10-22 10:35:51'),(350285,'5','131','2021-10-22',140,'022','','5',910000.00,'233432','','','3246','Zaria 2 ','005383',942951.74,'2021-10-25 11:35:02',5,'','628','','0000-00-00 00:00:00','664','2021-10-25 13:15:16'),(350286,'5','131','2021-10-22',140,'','','2',7900.00,'233432','','','','','',0.00,'2021-10-25 11:35:59',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2021-10-25 13:15:16'),(350287,'5','131','2021-10-22',140,'','','2',25000.00,'233432','','','','','',0.00,'2021-10-25 11:36:32',5,'Peter ','628','','0000-00-00 00:00:00','664','2021-10-25 13:15:16'),(350288,'5','131','2021-10-23',140,'022','','5',883000.00,'233688','','','3246','Zaria 2 ','007993',890915.62,'2021-10-25 11:37:43',5,'','628','','0000-00-00 00:00:00','664','2021-10-25 13:15:16'),(350289,'5','131','2021-10-23',140,'','','2',7900.00,'233688','','','','','',0.00,'2021-10-25 11:38:34',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2021-10-25 13:15:16'),(350290,'5','131','2021-10-24',140,'022','','5',866650.00,'23394','','','3246','Zaria 2 ','007509',874552.05,'2021-10-25 11:40:25',5,'','628','','0000-00-00 00:00:00','664','2021-10-25 13:15:16'),(350291,'5','131','2021-10-24',140,'','','2',7900.00,'23394','','','','','',0.00,'2021-10-25 11:41:22',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2021-10-25 13:15:16'),(350947,'5','131','2021-10-25',140,'022','','5',781570.00,'234480','','','3246','Zaria 2 ','000246',809979.60,'2021-10-26 14:06:02',5,'','628','','0000-00-00 00:00:00','664','2021-10-26 15:28:54'),(350949,'5','131','2021-10-25',140,'','','2',7900.00,'234480','','','','','',0.00,'2021-10-26 14:06:38',5,'','628','','0000-00-00 00:00:00','664','2021-10-26 15:28:54'),(350951,'5','131','2021-10-25',140,'','','2',20500.00,'234480','','','','','',0.00,'2021-10-26 14:07:14',5,'Gen services ','628','','0000-00-00 00:00:00','664','2021-10-26 15:28:54'),(351341,'5','131','2021-10-26',140,'','','5',54100.00,'234512','','','3246','Zaria 2 ','007783',72027.45,'2021-10-27 09:37:32',5,'','628','','0000-00-00 00:00:00','664','2021-10-27 19:18:30'),(351343,'5','131','2021-10-26',140,'','','2',7900.00,'234512','','','','','',0.00,'2021-10-27 09:38:02',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2021-10-27 19:18:30'),(351346,'5','131','2021-10-26',140,'','','2',10000.00,'234512','','','','','',0.00,'2021-10-27 09:38:35',5,'Gen services ','628','','0000-00-00 00:00:00','664','2021-10-27 19:18:30'),(354044,'5','131','2021-10-31',140,'026','','5',1532500.00,'235673','','','3246','Zaria 2 ','007704',1543461.15,'2021-11-01 14:02:11',5,'','628','','0000-00-00 00:00:00','664','2021-11-01 17:48:06'),(354045,'5','131','2021-10-31',140,'','','2',7900.00,'235673','','','','','',0.00,'2021-11-01 14:02:52',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2021-11-01 17:48:06'),(354048,'5','131','2021-10-31',140,'','','2',3000.00,'235673','','','','','',0.00,'2021-11-01 14:03:50',5,'Lawal Ds ','628','','0000-00-00 00:00:00','664','2021-11-01 17:48:06'),(354461,'5','131','2021-11-01',140,'220','','5',1264800.00,'235928','','','3246','Zaria 2 ','00054',1284496.95,'2021-11-02 10:40:52',5,'','628','','0000-00-00 00:00:00','664','2021-11-03 05:00:28'),(354462,'5','131','2021-11-01',140,'','','2',7900.00,'235928','','','','','',0.00,'2021-11-02 10:41:22',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2021-11-03 05:00:28'),(354464,'5','131','2021-11-01',140,'','','2',11700.00,'235928','','','','','',0.00,'2021-11-02 10:42:04',5,'Monthly Expenses ','628','','0000-00-00 00:00:00','664','2021-11-03 05:00:28'),(355003,'5','131','2021-11-02',140,'0026','','5',1277500.00,'236352','','','3246','Zaria 2 ','006432',1293408.60,'2021-11-03 10:53:04',5,'','628','','0000-00-00 00:00:00','664','2021-11-03 17:52:08'),(355005,'5','131','2021-11-02',140,'','','2',7900.00,'236352','','','','','',0.00,'2021-11-03 10:53:36',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2021-11-03 17:52:08'),(355006,'5','131','2021-11-02',140,'','','2',8000.00,'236352','','','','','',0.00,'2021-11-03 10:54:23',5,'Pump 3 Repair ','628','','0000-00-00 00:00:00','664','2021-11-03 17:52:08'),(355591,'5','131','2021-11-04',140,'026','','5',846000.00,'236461','','','3246','Zaria 2 ','000755',853924.50,'2021-11-04 10:58:50',5,'','628','','0000-00-00 00:00:00','664','2021-11-05 15:17:03'),(355592,'5','131','2021-11-03',140,'','','2',7900.00,'236461','','','','Zaria 2 ','',0.00,'2021-11-04 11:00:31',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2021-11-05 15:17:03'),(359684,'5','131','2021-11-11',140,'032','','5',99600.00,'238232','','','3246','Zaria 2 ','03567',110518.65,'2021-11-12 13:37:16',5,'','628','','0000-00-00 00:00:00','664','2021-11-13 05:52:59'),(359685,'5','131','2021-11-11',140,'','','2',7900.00,'238232','','','','','',0.00,'2021-11-12 13:38:34',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2021-11-13 05:52:59'),(359686,'5','131','2021-11-11',140,'','','2',3000.00,'238232','','','','','',0.00,'2021-11-12 13:39:09',5,'Lawal Ds ','628','','0000-00-00 00:00:00','664','2021-11-13 05:52:59'),(361247,'5','131','2021-11-12',140,'022','','5',502780.00,'238611','','','3246','Zaria 2 ','00865',929684.25,'2021-11-15 16:02:18',5,'','628','','0000-00-00 00:00:00','664','2021-11-15 19:10:11'),(361249,'5','131','2021-11-12',140,'','','2',7900.00,'238611','','','','','',0.00,'2021-11-15 16:03:04',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2021-11-15 19:10:11'),(361250,'5','131','2021-11-12',140,'','','2',219000.00,'238611','','','','','',0.00,'2021-11-15 16:03:44',5,'Salary payment ','628','','0000-00-00 00:00:00','664','2021-11-15 19:10:11'),(361251,'5','131','2021-11-12',140,'','','2',200000.00,'238611','','','','','',0.00,'2021-11-15 16:04:30',5,'House Rent payment ','628','','0000-00-00 00:00:00','664','2021-11-15 19:10:11'),(361254,'5','131','2021-11-13',140,'032','','5',922680.00,'238902','','','3246','Zaria 2 ','00096',930585.15,'2021-11-15 16:06:36',5,'','628','','0000-00-00 00:00:00','664','2021-11-15 19:10:11'),(361256,'5','131','2021-11-13',140,'','','2',7900.00,'238902','','','','','',0.00,'2021-11-15 16:07:19',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2021-11-15 19:10:11'),(361262,'5','131','2021-11-14',140,'032','','5',331000.00,'239113','','','3246','Zaria 2 ','00324',338987.55,'2021-11-15 16:10:07',5,'','628','','0000-00-00 00:00:00','664','2021-11-15 19:10:11'),(361264,'5','131','2021-11-14',140,'','','2',7900.00,'239113','','','','','',0.00,'2021-11-15 16:10:42',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2021-11-15 19:10:11'),(361519,'5','131','2021-11-15',140,'022','','5',58000.00,'239356','','','3246','Zaria 2 ','0096',65917.50,'2021-11-16 08:48:30',5,'','628','','0000-00-00 00:00:00','664','2021-11-16 20:38:46'),(361521,'5','131','2021-11-15',140,'','','2',7900.00,'239356','','','','','',0.00,'2021-11-16 08:49:07',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2021-11-16 20:38:46'),(364606,'5','131','2021-11-19',140,'0345','','5',461600.00,'239979','','','3246','Zaria 2 ','000755',469566.90,'2021-11-22 12:23:46',5,'','628','','0000-00-00 00:00:00','664','2021-11-22 17:32:48'),(364608,'5','131','2021-11-19',140,'','','2',7900.00,'239979','','','','Zaria 2 ','',0.00,'2021-11-22 12:26:19',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2021-11-22 17:32:48'),(364610,'5','131','2021-11-20',140,'0345','','5',1166900.00,'240222','','','3246','Zaria 2 ','088644',1174809.90,'2021-11-22 12:27:55',5,'','628','','0000-00-00 00:00:00','664','2021-11-22 17:32:48'),(364612,'5','131','2021-11-20',140,'','','2',7900.00,'240222','','','','','',0.00,'2021-11-22 12:28:56',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2021-11-22 17:32:48'),(364614,'5','131','2021-11-21',140,'0345','','5',496680.00,'240446','','','3246','Zaria 2 ','098054',504584.85,'2021-11-22 12:30:20',5,'','628','','0000-00-00 00:00:00','664','2021-11-22 17:32:48'),(364616,'5','131','2021-11-21',140,'','','2',7900.00,'240446','','','','','',0.00,'2021-11-22 12:30:57',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2021-11-22 17:32:48'),(365320,'5','131','2021-11-22',140,'022','','5',45760.00,'240709','','','3246','Zaria 2 ','00208',53662.95,'2021-11-23 11:37:55',5,'','628','','0000-00-00 00:00:00','664','2021-11-23 21:31:40'),(365323,'5','131','2021-11-22',140,'','','2',7900.00,'240709','','','','','',0.00,'2021-11-23 11:38:22',5,'','628','','0000-00-00 00:00:00','664','2021-11-23 21:31:40'),(365854,'5','131','2021-11-23',140,'220','','5',1269200.00,'240968','','','3246','Zaria 2 ','0005664',1287107.25,'2021-11-24 09:03:32',5,'','628','','0000-00-00 00:00:00','664','2021-11-25 05:52:45'),(365857,'5','131','2021-11-23',140,'','','2',7900.00,'240968','','','','','',0.00,'2021-11-24 09:04:16',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2021-11-25 05:52:45'),(365858,'5','131','2021-11-23',140,'','','2',10000.00,'240968','','','','','',0.00,'2021-11-24 09:05:20',5,'Weight and measure ','628','','0000-00-00 00:00:00','664','2021-11-25 05:52:45'),(366352,'5','131','2021-11-24',140,'220','','5',1508900.00,'241297','','','3246','Zaria 2 ','006959',1517827.58,'2021-11-25 07:51:05',5,'','628','','0000-00-00 00:00:00','664','2021-11-26 05:57:19'),(366358,'5','131','2021-11-24',140,'','','2',7900.00,'241297','','','','','',0.00,'2021-11-25 07:52:13',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2021-11-26 05:57:19'),(366361,'5','131','2021-11-17',140,'','','2',1000.00,'241297','','','','','',0.00,'2021-11-25 07:53:01',5,'Transport ','628','','0000-00-00 00:00:00','664','2021-11-26 05:57:19'),(366972,'5','131','2021-11-25',140,'026','','5',1678500.00,'241492','','','3246','Zaria 2 ','00453',1686476.55,'2021-11-26 08:41:08',5,'','628','','0000-00-00 00:00:00','664','2021-11-27 06:11:39'),(366973,'5','131','2021-11-25',140,'','','2',7900.00,'241492','','','','','',0.00,'2021-11-26 08:44:07',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2021-11-27 06:11:39'),(368757,'5','131','2021-11-26',140,'220','','5',1304700.00,'241740','','','3246','Zaria 2 ','004930',1312637.70,'2021-11-29 14:18:10',5,'','628','','0000-00-00 00:00:00','664','2021-11-30 06:54:15'),(368758,'5','131','2021-11-26',140,'','','2',7900.00,'241740','','','','','',0.00,'2021-11-29 14:19:06',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2021-11-30 06:54:15'),(368762,'5','131','2021-11-27',140,'220','','5',1233000.00,'242022','','','3246','Zaria 2 ','004061',1240900.65,'2021-11-29 14:20:16',5,'','628','','0000-00-00 00:00:00','664','2021-11-30 06:54:15'),(368763,'5','131','2021-11-27',140,'','','2',7900.00,'242022','','','','','',0.00,'2021-11-29 14:20:44',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2021-11-30 06:54:15'),(368764,'5','131','2021-11-28',140,'220','','5',277430.00,'242239','','','3246','Zaria 2 ','004931',285331.20,'2021-11-29 14:21:58',5,'','628','','0000-00-00 00:00:00','664','2021-11-30 06:54:15'),(368766,'5','131','2021-11-28',140,'','','2',7900.00,'242239','','','','','',0.00,'2021-11-29 14:22:34',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2021-11-30 06:54:15'),(371040,'5','131','2021-12-02',140,'022','','5',1003140.00,'243162','','','3246','Zaria 2 ','00653',1022749.20,'2021-12-03 15:15:23',5,'','628','','0000-00-00 00:00:00','664','2021-12-07 06:15:25'),(371042,'5','131','2021-12-02',140,'','','2',7900.00,'243162','','','','','',0.00,'2021-12-03 15:16:05',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2021-12-07 06:15:25'),(371044,'5','131','2021-12-02',140,'','','2',11700.00,'243162','','','','','',0.00,'2021-12-03 15:16:52',5,'MONTHLY Expenses ','628','','0000-00-00 00:00:00','664','2021-12-07 06:15:25'),(372881,'5','131','2021-12-03',140,'022','','5',1561797.60,'243423','','','3246','Zaria 2 ','00567',1539300.00,'2021-12-07 11:14:17',5,'','628','','0000-00-00 00:00:00','664','2021-12-07 21:44:27'),(372883,'5','131','2021-12-03',140,'','','2',7900.00,'243423','','','','','',0.00,'2021-12-07 11:15:21',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2021-12-07 21:44:27'),(372884,'5','131','2021-12-03',140,'','','2',5000.00,'243423','','','','','',0.00,'2021-12-07 11:16:04',5,'Lawal Ds ','628','','0000-00-00 00:00:00','664','2021-12-07 21:44:27'),(372886,'5','131','2021-12-03',140,'','','2',9500.00,'243423','','','','','',0.00,'2021-12-07 11:16:51',5,'Gen services ','628','','0000-00-00 00:00:00','664','2021-12-07 21:44:27'),(372888,'5','131','2021-12-04',140,'022','','5',1733450.00,'243797','','','3246','Zaria 2 ','000678',1741352.25,'2021-12-07 11:18:05',5,'','628','','0000-00-00 00:00:00','664','2021-12-07 21:44:27'),(372889,'5','131','2021-12-04',140,'','','2',7900.00,'243797','','','','','',0.00,'2021-12-07 11:18:49',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2021-12-07 21:44:27'),(372891,'5','131','2021-12-05',140,'022','','5',572340.00,'244309','','','3246','Zaria 2 ','000674',580242.30,'2021-12-07 11:20:10',5,'','628','','0000-00-00 00:00:00','664','2021-12-07 21:44:27'),(372892,'5','131','2021-12-05',140,'','','2',7900.00,'244309','','','','','',0.00,'2021-12-07 11:20:51',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2021-12-07 21:44:27'),(372894,'5','131','2021-12-05',140,'','','2',5000.00,'244309','','','','','',0.00,'2021-12-07 11:21:28',5,'Lawal Ds ','628','','0000-00-00 00:00:00','664','2021-12-07 21:44:27'),(373637,'5','131','2021-12-07',140,'032','','5',162800.00,'244569','','','3246','Zaria 2 ','000753',389706.90,'2021-12-08 16:53:25',5,'','628','','0000-00-00 00:00:00','664','2021-12-09 08:26:35'),(373639,'5','131','2021-12-07',140,'','','2',7900.00,'244569','','','','','',0.00,'2021-12-08 16:54:10',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2021-12-09 08:26:35'),(373641,'5','131','2021-12-07',140,'','','2',219000.00,'244569','','','','','',0.00,'2021-12-08 16:55:45',5,'Salary payment ','628','','0000-00-00 00:00:00','664','2021-12-09 08:26:35'),(373967,'5','131','2021-12-08',140,'026','','5',1543750.00,'244683','','','3246','Zaria 2 ','000321',1602654.90,'2021-12-09 11:41:13',5,'','628','','0000-00-00 00:00:00','664','2021-12-09 18:16:39'),(373969,'5','131','2021-12-08',140,'','','2',7900.00,'244683','','','','','',0.00,'2021-12-09 11:41:48',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2021-12-09 18:16:39'),(373972,'5','131','2021-12-08',140,'','','2',50000.00,'244683','','','','','',0.00,'2021-12-09 11:42:32',5,'Lawal Ds ','628','','0000-00-00 00:00:00','664','2021-12-09 18:16:39'),(374489,'5','131','2021-12-09',140,'022','','5',1989130.00,'244811','','','3246','Zaria 2 ','001234',1996039.65,'2021-12-10 10:37:43',5,'','628','','0000-00-00 00:00:00','664','2021-12-11 17:29:34'),(374490,'5','131','2021-12-09',140,'','','2',7900.00,'244811','','','','','',0.00,'2021-12-10 10:39:16',5,'','628','','0000-00-00 00:00:00','664','2021-12-11 17:29:34'),(376503,'5','131','2021-12-10',140,'022','','5',1398000.00,'245068','','','3246','Zaria 2 ','00567',1405958.40,'2021-12-14 12:41:10',5,'','628','','0000-00-00 00:00:00','664','2021-12-14 14:35:38'),(376504,'5','131','2021-12-10',140,'','','2',7900.00,'245068','','','','','',0.00,'2021-12-14 12:41:51',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2021-12-14 14:35:38'),(376508,'5','131','2021-12-11',140,'022','','5',1138400.00,'245401','','','3246','Zaria 2 ','00678',1158309.90,'2021-12-14 12:43:15',5,'','628','','0000-00-00 00:00:00','664','2021-12-14 14:35:38'),(376509,'5','131','2021-12-11',140,'','','2',7900.00,'245401','','','','','',0.00,'2021-12-14 12:43:50',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2021-12-14 14:35:38'),(376510,'5','131','2021-12-11',140,'','','2',12000.00,'245401','','','','','',0.00,'2021-12-14 12:44:42',5,'Pump repair ','628','','0000-00-00 00:00:00','664','2021-12-14 14:35:38'),(379597,'5','131','2021-12-17',140,'032','','5',839420.00,'246789','','','3246','Zaria 2 ','00356',847327.80,'2021-12-20 11:50:17',5,'','628','','0000-00-00 00:00:00','664','2021-12-20 18:03:10'),(379599,'5','131','2021-12-17',140,'','','2',7900.00,'247422','','','','','',0.00,'2021-12-20 11:50:50',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2021-12-20 18:03:10'),(379601,'5','131','2021-12-18',140,'032','','5',1387600.00,'247352','','','3246','Zaria 2 ','00982',1400584.35,'2021-12-20 11:52:58',5,'','628','','0000-00-00 00:00:00','664','2021-12-20 18:03:10'),(379602,'5','131','2021-12-18',140,'032','','5',1387600.00,'247352','','','3246','Zaria 2 ','00982',1400584.35,'2021-12-20 11:52:58',5,'','628','','0000-00-00 00:00:00','664','2021-12-20 18:03:10'),(379603,'5','131','2021-12-18',140,'','','2',7900.00,'247352','','','','','',0.00,'2021-12-20 11:53:34',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2021-12-20 18:03:10'),(379606,'5','131','2021-12-18',140,'','','2',5000.00,'247352','','','','','',0.00,'2021-12-20 11:54:23',5,'Lawal DS ','628','','0000-00-00 00:00:00','664','2021-12-20 18:03:10'),(379609,'5','131','2021-12-19',140,'032','','5',1615900.00,'247422','','','3246','Zaria 2 ','00909',1623849.15,'2021-12-20 11:55:44',5,'','628','','0000-00-00 00:00:00','664','2021-12-20 18:03:10'),(379611,'5','131','2021-12-19',140,'','','2',7900.00,'247422','','','','','',0.00,'2021-12-20 11:56:23',5,'','628','','0000-00-00 00:00:00','664','2021-12-20 18:03:10'),(381001,'5','131','2021-12-20',140,'026','','5',785250.00,'248082','','','3246','Zaria 2 ','00708',863152.95,'2021-12-22 17:22:54',5,'','628','','0000-00-00 00:00:00','664','2021-12-23 04:55:03'),(381002,'5','131','2021-12-20',140,'','','2',7900.00,'248082','','','','','',0.00,'2021-12-22 17:23:51',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2021-12-23 04:55:02'),(381003,'5','131','2021-12-20',140,'','','2',70000.00,'248082','','','','','',0.00,'2021-12-22 17:24:31',5,'Weight and measure ','628','','0000-00-00 00:00:00','664','2021-12-23 04:55:02'),(381253,'5','131','2021-12-21',140,'220','','5',142100.00,'248234','','','3246','Zaria 2 ','00210',149999.85,'2021-12-23 09:27:56',5,'','628','','0000-00-00 00:00:00','664','2021-12-23 09:44:03'),(381254,'5','131','2021-12-21',140,'','','2',7900.00,'248234','','','','','',0.00,'2021-12-23 09:28:41',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2021-12-23 09:44:03'),(388348,'5','131','2022-01-05',140,'026','','5',470400.00,'251586','','','3246','Zaria 2 ','0076',701141.10,'2022-01-06 09:37:27',5,'','628','','0000-00-00 00:00:00','664','2022-01-07 07:01:56'),(388350,'5','131','2022-01-05',140,'','','2',7900.00,'251586','','','','','',0.00,'2022-01-06 09:38:08',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2022-01-07 07:01:56'),(388353,'5','131','2022-01-05',140,'','','2',219000.00,'251586','','','','','',0.00,'2022-01-06 09:38:42',5,'Salary Payment ','628','','0000-00-00 00:00:00','664','2022-01-07 07:01:56'),(388355,'5','131','2022-01-05',140,'','','2',11700.00,'251586','','','','','',0.00,'2022-01-06 09:39:33',5,'Monthly Expenses ','628','','0000-00-00 00:00:00','664','2022-01-07 07:01:56'),(388972,'5','131','2022-01-06',140,'220','','5',1851040.00,'251670','','','3246','Zaria 2 ','004075',1866833.10,'2022-01-07 11:08:06',5,'','628','','0000-00-00 00:00:00','664','2022-01-08 08:08:07'),(388973,'5','131','2022-01-06',140,'','','2',7900.00,'251670','','','','','',0.00,'2022-01-07 11:08:44',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2022-01-08 08:08:07'),(391159,'5','131','2022-01-09',140,'022','','5',1026500.00,'252831','','','3246','Zaria 2 ','0067',1034437.80,'2022-01-11 13:44:40',5,'','628','','0000-00-00 00:00:00','664','2022-01-12 08:13:14'),(391160,'5','131','2022-01-09',140,'','','2',7900.00,'252831','','','','','',0.00,'2022-01-11 13:45:28',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2022-01-12 08:13:14'),(391163,'5','131','2022-01-07',140,'026','','5',1246215.00,'251841','','','3246','Zaria 2 ','00863',1254115.50,'2022-01-11 13:49:29',5,'','628','','0000-00-00 00:00:00','664','2022-01-12 08:13:14'),(391166,'5','131','2022-01-07',140,'','','2',7900.00,'251841','','','','','',0.00,'2022-01-11 13:50:13',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2022-01-12 08:13:14'),(391169,'5','131','2022-01-08',140,'220','','5',1287400.00,'252053','','','3246','Zaria 2 ','00313',1295322.60,'2022-01-11 13:51:41',5,'','628','','0000-00-00 00:00:00','664','2022-01-12 08:13:14'),(391172,'5','131','2022-01-08',140,'','','2',7900.00,'252053','','','','','',0.00,'2022-01-11 13:52:20',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2022-01-12 08:13:14'),(391336,'5','131','2022-01-10',140,'032','','5',509900.00,'252856','','','3246','Zaria 2 ','00906',517839.30,'2022-01-11 17:42:15',5,'','628','','0000-00-00 00:00:00','664','2022-01-12 08:13:14'),(391337,'5','131','2022-01-10',140,'','','2',7900.00,'252856','','','','','',0.00,'2022-01-11 17:43:22',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2022-01-12 08:13:14'),(394475,'5','131','2022-01-14',140,'220','','5',814500.00,'253525','','','3246','Zaria 2 ','00567',822401.25,'2022-01-17 11:57:37',5,'','628','','0000-00-00 00:00:00','664','2022-01-17 16:36:55'),(394477,'5','131','2022-01-14',140,'','','2',7900.00,'253525','','','','','',0.00,'2022-01-17 12:00:04',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2022-01-17 16:36:55'),(394478,'5','131','2022-01-15',140,'220','','5',915700.00,'253778','','','3246','Zaria 2 ','00866',923632.05,'2022-01-17 12:01:35',5,'','628','','0000-00-00 00:00:00','664','2022-01-17 16:36:55'),(394479,'5','131','2022-01-15',140,'','','2',7900.00,'253778','','','','','',0.00,'2022-01-17 12:02:12',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2022-01-17 16:36:55'),(394481,'5','131','2022-01-16',140,'220','','5',174460.00,'254037','','','3246','Zaria 2 ','00905',227365.05,'2022-01-17 12:03:39',5,'','628','','0000-00-00 00:00:00','664','2022-01-17 16:36:55'),(394483,'5','131','2022-01-16',140,'220','','2',7900.00,'254037','','','','','',0.00,'2022-01-17 12:04:32',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2022-01-17 16:36:55'),(394484,'5','131','2022-01-16',140,'','','2',45000.00,'254037','','','','','',0.00,'2022-01-17 12:05:15',5,'Gen Repair ','628','','0000-00-00 00:00:00','664','2022-01-17 16:36:55'),(394485,'5','131','2022-01-30',140,'0220','','5',961300.00,'257509','','','3246','Zaria 2 ','001589',969200.10,'2022-01-31 10:50:31',5,'','628','','0000-00-00 00:00:00','664','2022-02-02 19:23:23'),(394486,'5','131','2022-01-30',140,'','','2',7900.00,'257509','','','','','',0.00,'2022-01-31 10:51:01',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2022-02-02 19:23:23'),(394487,'5','131','2022-01-31',140,'026','','5',925600.00,'257510','','','3246','Zaria 2 ','00764',933822.45,'2022-02-01 13:54:27',5,'','628','','0000-00-00 00:00:00','664','2022-02-02 19:23:23'),(394488,'5','131','2022-01-31',140,'','','2',8200.00,'257510','','','','','',0.00,'2022-02-01 13:55:37',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2022-02-02 19:23:23'),(394489,'5','131','2022-02-01',140,'026','','5',822390.00,'257511','','','3246','Zaria 2 ','000467',864296.40,'2022-02-02 19:52:07',5,'','628','','0000-00-00 00:00:00','664','2022-02-03 07:57:14'),(394490,'5','131','2022-02-01',140,'','','2',8200.00,'257511','','','','','',0.00,'2022-02-02 19:52:38',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2022-02-03 07:57:14'),(394491,'5','131','2022-02-01',140,'','','2',10000.00,'257511','','','','','',0.00,'2022-02-02 19:53:10',5,'Weight and measure ','628','','0000-00-00 00:00:00','664','2022-02-03 07:57:14'),(394492,'5','131','2022-02-01',140,'','','2',12000.00,'257511','','','','','',0.00,'2022-02-02 19:53:53',5,'Audit logistics ','628','','0000-00-00 00:00:00','664','2022-02-03 07:57:14'),(394493,'5','131','2022-02-01',140,'','','2',11700.00,'257511','','','','','',0.00,'2022-02-02 19:54:29',5,'MONTHLY Expenses ','628','','0000-00-00 00:00:00','664','2022-02-03 07:57:14'),(394494,'5','131','2022-02-02',140,'032','','5',850150.00,'257512','','','3246','Zaria 2 ','00908',858356.40,'2022-02-03 12:55:51',5,'','628','','0000-00-00 00:00:00','664','2022-02-03 14:44:26'),(394495,'5','131','2022-02-02',140,'','','2',8200.00,'257512','','','','','',0.00,'2022-02-03 12:56:31',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2022-02-03 14:44:26'),(394496,'5','131','2022-02-03',140,'220','','5',781150.00,'257513','','','3246','Zaria 2 ','00320',789454.05,'2022-02-04 12:04:34',5,'','628','','0000-00-00 00:00:00','664','2022-02-04 16:49:34'),(394497,'5','131','2022-02-03',140,'','','2',8300.00,'257513','','','','','',0.00,'2022-02-04 12:05:08',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2022-02-04 16:49:34'),(394498,'5','131','2022-02-04',140,'220','','5',840340.00,'257514','','','3246','Zaria 2 ','5678',848642.85,'2022-02-07 13:18:03',5,'','628','','0000-00-00 00:00:00','664','2022-02-08 07:17:50'),(394499,'5','131','2022-02-04',140,'','','2',8300.00,'257514','','','','','',0.00,'2022-02-07 13:19:00',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2022-02-08 07:17:50'),(394500,'5','131','2022-02-05',140,'220','','5',975300.00,'257517','','','3246','Zaria 2 ','00525',984109.50,'2022-02-07 13:28:56',5,'','628','','0000-00-00 00:00:00','664','2022-02-08 07:17:50'),(394501,'5','131','2022-02-05',140,'','','2',8800.00,'257517','','','','','',0.00,'2022-02-07 13:29:38',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2022-02-08 07:17:50'),(394502,'5','131','2022-02-06',140,'026','','5',870230.00,'257518','','','3246','Zaria 2 ','0080',879034.20,'2022-02-07 13:31:33',5,'','628','','0000-00-00 00:00:00','664','2022-02-08 07:17:50'),(394503,'5','131','2022-02-06',140,'','','2',8800.00,'257518','','','','','',0.00,'2022-02-07 13:32:12',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2022-02-08 07:17:50'),(394504,'5','131','2022-02-07',140,'220','','5',651600.00,'257519','','','3246','Zaria 2 ','006348',899466.15,'2022-02-08 13:19:17',5,'','628','','0000-00-00 00:00:00','664','2022-02-08 20:44:15'),(394505,'5','131','2022-02-07',140,'','','2',8800.00,'257519','','','','','',0.00,'2022-02-08 13:20:19',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2022-02-08 20:44:15'),(394506,'5','131','2022-02-07',140,'','','2',234000.00,'257519','','','','','',0.00,'2022-02-08 13:20:59',5,'Salary Payment ','628','','0000-00-00 00:00:00','664','2022-02-08 20:44:15'),(394507,'5','131','2022-02-07',140,'','','2',5000.00,'257519','','','','','',0.00,'2022-02-08 13:21:43',5,'PHCN Monthly Bill ','628','','0000-00-00 00:00:00','664','2022-02-08 20:44:15'),(394508,'5','131','2022-02-08',140,'0220','','5',889390.00,'257520','','','3246','Zaria 2 ','008090',933190.50,'2022-02-09 12:28:42',5,'','628','','0000-00-00 00:00:00','664','2022-02-09 20:55:32'),(394509,'5','131','2022-02-08',140,'','','2',8800.00,'257520','','','','','',0.00,'2022-02-09 12:29:05',5,'','628','','0000-00-00 00:00:00','664','2022-02-09 20:55:32'),(394510,'5','131','2022-02-08',140,'','','2',35000.00,'257520','','','','','',0.00,'2022-02-09 12:29:39',5,'Eng. Peter ','628','','0000-00-00 00:00:00','664','2022-02-09 20:55:32'),(394511,'5','131','2022-02-09',140,'0220','','5',957700.00,'257521','','','3246','Zaria 2 ','00750',967083.15,'2022-02-10 10:01:09',5,'','628','','0000-00-00 00:00:00','664','2022-02-10 21:43:20'),(394512,'5','131','2022-02-09',140,'','','2',9300.00,'257521','','','','','',0.00,'2022-02-10 10:01:48',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2022-02-10 21:43:20'),(394513,'5','131','2022-02-10',140,'032','','5',1001400.00,'257522','','','3246','Zaria 2 ','00108',1010709.15,'2022-02-11 11:04:27',5,'','628','','0000-00-00 00:00:00','664','2022-02-11 20:20:45'),(394514,'5','131','2022-02-10',140,'','','2',9300.00,'257522','','','','','',0.00,'2022-02-11 11:05:04',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2022-02-11 20:20:45'),(394515,'5','131','2022-02-14',140,'2416','','5',828172.00,'257526','','','3246','Zaria2','2416',0.00,'2022-02-14 14:32:22',5,'','600','','0000-00-00 00:00:00','600','2022-02-14 14:32:32'),(394516,'5','131','2022-02-11',140,'220','','5',968390.00,'257523','','','3246','Zaria 2 ','0078',977699.25,'2022-02-14 17:59:33',5,'','628','','0000-00-00 00:00:00','664','2022-02-14 23:51:00'),(394517,'5','131','2022-02-11',140,'','','2',9300.00,'257523','','','','','',0.00,'2022-02-14 18:00:18',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2022-02-14 23:51:00'),(394518,'5','131','2022-02-12',140,'026','','5',1197150.00,'257524','','','3246','Zaria 2 ','0970',1206455.25,'2022-02-14 18:02:09',5,'','628','','0000-00-00 00:00:00','664','2022-02-14 23:51:00'),(394519,'5','131','2022-02-12',140,'','','2',9300.00,'257524','','','','','',0.00,'2022-02-14 18:02:39',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2022-02-14 23:51:00'),(394520,'5','131','2022-02-13',140,'032','','5',1042000.00,'257525','','','3246','Zaria 2 ','09078',1054303.80,'2022-02-14 18:04:10',5,'','628','','0000-00-00 00:00:00','664','2022-02-14 23:51:00'),(394521,'5','131','2022-02-13',140,'','','2',9300.00,'257525','','','','','',0.00,'2022-02-14 18:04:57',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2022-02-14 23:51:00'),(394522,'5','131','2022-02-13',140,'','','2',3000.00,'257525','','','','','',0.00,'2022-02-14 18:05:40',5,'Lawal 3','628','','0000-00-00 00:00:00','664','2022-02-14 23:51:00'),(394523,'5','131','2022-02-14',140,'026','','5',713230.00,'257526','','','3246','Zaria 2 ','00789',725538.00,'2022-02-15 11:44:03',5,'','628','','0000-00-00 00:00:00','664','2022-02-16 06:10:36'),(394524,'5','131','2022-02-14',140,'','','2',9300.00,'257526','','','','','',0.00,'2022-02-15 11:44:40',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2022-02-16 06:10:36'),(394525,'5','131','2022-02-14',140,'','','2',3000.00,'257526','','','','','',0.00,'2022-02-15 11:45:30',5,'Lawal Ds ','628','','0000-00-00 00:00:00','664','2022-02-16 06:10:36'),(394526,'5','131','2022-02-14',140,'6734','','5',387135.00,'257527','','','3246','ZARIA 2','08945',502735.20,'2022-02-16 11:26:51',5,'','628','','0000-00-00 00:00:00','664','2022-02-16 21:34:51'),(394527,'5','131','2022-02-15',140,'','','2',9300.00,'257527','','','','','',0.00,'2022-02-16 11:27:56',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2022-02-16 21:34:51'),(394528,'5','131','2022-02-15',140,'','','2',106300.00,'257527','','','','','',0.00,'2022-02-16 11:29:26',5,'','628','','0000-00-00 00:00:00','664','2022-02-16 21:34:51'),(394529,'5','131','2022-02-16',140,'220','','5',1603900.00,'257528','','','3246','ZARIA 2','00689',1613229.75,'2022-02-17 22:05:33',5,'','628','','0000-00-00 00:00:00','664','2022-02-19 07:19:12'),(394530,'5','131','2022-02-16',140,'','','2',9300.00,'257528','','','','','',0.00,'2022-02-17 22:06:20',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2022-02-19 07:19:12'),(394531,'5','131','2022-02-17',140,'0220','','5',787910.00,'257529','','','3246','ZARIA 2','0007548',822010.20,'2022-02-18 11:13:13',5,'','628','','0000-00-00 00:00:00','664','2022-02-19 07:19:12'),(394532,'5','131','2022-02-17',140,'','','2',9300.00,'257529','','','','ZARIA 2','',0.00,'2022-02-18 11:15:11',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2022-02-19 07:19:12'),(394533,'5','131','2022-02-17',140,'','','2',24800.00,'257529','','','','','',0.00,'2022-02-18 11:16:18',5,'Gen Repair ','628','','0000-00-00 00:00:00','664','2022-02-19 07:19:12'),(394534,'5','131','2022-02-18',140,'0220','','5',469785.00,'257530','','','3246','ZARIA 2','00689',479085.75,'2022-02-22 12:06:38',5,'','628','','0000-00-00 00:00:00','664','2022-02-22 13:13:34'),(394535,'5','131','2022-02-18',140,'','','2',9300.00,'257530','','','','','',0.00,'2022-02-22 12:07:18',5,'','628','','0000-00-00 00:00:00','664','2022-02-22 13:13:34'),(394536,'5','131','2022-02-21',140,'220','','5',1996400.00,'257533','','','3246','ZARIA 2','08945',2015714.25,'2022-02-22 12:08:26',5,'','628','','0000-00-00 00:00:00','664','2022-02-22 13:13:34'),(394537,'5','131','2022-02-21',140,'','','2',9300.00,'257533','','','','','',0.00,'2022-02-22 12:08:55',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2022-02-22 13:13:34'),(394538,'5','131','2022-02-21',140,'','','2',10000.00,'257533','','','','','',2015714.25,'2022-02-22 12:09:47',5,'Weight and measure ','628','','0000-00-00 00:00:00','664','2022-02-22 13:13:34'),(394539,'5','131','2022-02-22',140,'220','','5',1835450.00,'257534','','','3246','ZARIA 2','00785',1844751.15,'2022-02-23 14:14:22',5,'','628','','0000-00-00 00:00:00','664','2022-02-24 07:58:21'),(394540,'5','131','2022-02-22',140,'','','2',9300.00,'257534','','','','','',0.00,'2022-02-23 14:15:00',5,'','628','','0000-00-00 00:00:00','664','2022-02-24 07:58:21'),(394541,'5','131','2022-02-23',140,'220','','5',963150.00,'257535','','','3246','ZARIA 2','000304',972450.60,'2022-02-24 19:08:54',5,'','628','','0000-00-00 00:00:00','664','2022-02-25 06:46:50'),(394542,'5','131','2022-02-23',140,'','','2',9300.00,'257535','','','','','',0.00,'2022-02-24 19:09:38',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2022-02-25 06:46:50'),(394543,'5','131','2022-02-24',140,'220','','5',1333580.00,'257536','','','3246','ZARIA 2','000305',1342880.55,'2022-02-25 11:33:57',5,'','628','','0000-00-00 00:00:00','664','2022-02-26 07:17:49'),(394544,'5','131','2022-02-24',140,'','','2',9300.00,'257536','','','','','',0.00,'2022-02-25 11:34:32',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2022-02-26 07:17:49'),(394545,'5','131','2022-02-25',140,'220','','5',512700.00,'257537','','','3246','ZARIA 2','000308',522033.60,'2022-02-28 13:36:25',5,'','628','','0000-00-00 00:00:00','664','2022-02-28 21:36:50'),(394546,'5','131','2022-02-25',140,'','','2',9300.00,'257537','','','','','',0.00,'2022-02-28 13:37:12',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2022-02-28 21:36:50'),(394547,'5','131','2022-02-26',140,'220','','5',6360.00,'257538','','','3246','ZARIA 2','000306',15658.50,'2022-02-28 13:38:38',5,'','628','','0000-00-00 00:00:00','664','2022-02-28 21:36:50'),(394548,'5','131','2022-02-26',140,'','','2',9300.00,'257538','','','','','',0.00,'2022-02-28 13:39:24',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2022-02-28 21:36:50'),(394549,'5','131','2022-03-01',140,'','','5',1150200.00,'257541','','','3247','ZARIA 2','1147936',1170048.00,'2022-03-02 19:50:15',5,'','628','','0000-00-00 00:00:00','664','2022-03-02 21:00:47'),(394550,'5','131','2022-03-01',140,'','','2',9300.00,'257541','','','','','',0.00,'2022-03-02 19:50:50',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2022-03-02 21:00:47'),(394551,'5','131','2022-03-01',140,'','','2',10520.00,'257541','','','','','',0.00,'2022-03-02 19:51:50',5,'Retail Logistics ','628','','0000-00-00 00:00:00','664','2022-03-02 21:00:47'),(394552,'5','131','2022-03-02',140,'','','5',820290.00,'257542','','','3247','ZARIA 2','1147913',878791.65,'2022-03-03 11:37:33',5,'','628','','0000-00-00 00:00:00','664','2022-03-04 08:20:20'),(394553,'5','131','2022-03-02',140,'','','2',9300.00,'257542','','','','','',0.00,'2022-03-03 11:38:06',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2022-03-04 08:20:20'),(394554,'5','131','2022-03-02',140,'','','2',28000.00,'257542','','','','','',0.00,'2022-03-03 11:39:02',5,'Peter Water Removal ','628','','0000-00-00 00:00:00','664','2022-03-04 08:20:20'),(394555,'5','131','2022-03-02',140,'','','2',11700.00,'257542','','','','','',0.00,'2022-03-03 11:39:42',5,'MONTHLY Expenses ','628','','0000-00-00 00:00:00','664','2022-03-04 08:20:20'),(394556,'5','131','2022-03-02',140,'','','2',9500.00,'257542','','','','','',0.00,'2022-03-03 11:40:19',5,'Gen Services ','628','','0000-00-00 00:00:00','664','2022-03-04 08:20:19'),(394557,'5','131','2022-03-03',140,'','','5',374250.00,'257543','','','3247','ZARIA 2','1247559',618751.65,'2022-03-04 22:39:22',5,'','628','','0000-00-00 00:00:00','664','2022-03-05 06:50:51'),(394558,'5','131','2022-03-03',140,'','','2',9500.00,'257543','','','','','',0.00,'2022-03-04 22:39:57',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2022-03-05 06:50:51'),(394559,'5','131','2022-03-03',140,'','','2',235000.00,'257543','','','','','',0.00,'2022-03-04 22:40:35',5,'Salary Payment ','628','','0000-00-00 00:00:00','664','2022-03-05 06:50:51'),(394560,'5','131','2022-03-15',140,'1263589','','5',2200000.00,'257555','','','3247','ZARIA 2','126458',2251814.40,'2022-03-16 14:12:57',5,'','628','','0000-00-00 00:00:00','664','2022-03-17 08:10:57'),(394561,'5','131','2022-03-15',140,'','','2',13800.00,'257555','','','','','',0.00,'2022-03-16 14:13:37',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2022-03-17 08:10:57'),(394562,'5','131','2022-03-15',140,'','','2',38000.00,'257555','','','','','',0.00,'2022-03-16 14:14:11',5,'Eng. Peter ','628','','0000-00-00 00:00:00','664','2022-03-17 08:10:57'),(394563,'5','131','2022-03-16',140,'','','5',1051890.00,'257556','','','3247','ZARIA 2','1147535',1065698.70,'2022-03-17 14:07:47',5,'','628','','0000-00-00 00:00:00','664','2022-03-18 07:38:33'),(394564,'5','131','2022-03-16',140,'','','2',13800.00,'257556','','','','','',0.00,'2022-03-17 14:08:14',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2022-03-18 07:38:33'),(394565,'5','131','2022-03-17',140,'','','5',1005490.00,'257557','','','3247','ZARIA 2','1147062',1019297.40,'2022-03-18 12:01:07',5,'','628','','0000-00-00 00:00:00','664','2022-03-19 07:07:12'),(394566,'5','131','2022-03-17',140,'','','2',13800.00,'257557','','','','','',0.00,'2022-03-18 12:01:48',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2022-03-19 07:07:12'),(394567,'5','131','2022-03-18',140,'','','5',512800.00,'257558','','','3247','ZARIA 2','1147063',526617.30,'2022-03-22 07:59:21',5,'','628','','0000-00-00 00:00:00','664','2022-03-23 07:54:34'),(394568,'5','131','2022-03-18',140,'','','2',13800.00,'257558','','','','','',0.00,'2022-03-22 07:59:57',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2022-03-23 07:54:34'),(394569,'5','131','2022-03-24',140,'','','5',918250.00,'257564','','','3247','ZARIA 2','1147550',932053.65,'2022-03-25 13:06:54',5,'','628','','0000-00-00 00:00:00','664','2022-03-26 04:54:02'),(394570,'5','131','2022-03-24',140,'','','2',13800.00,'257564','','','','','',0.00,'2022-03-25 13:07:32',5,'','628','','0000-00-00 00:00:00','664','2022-03-26 04:54:02'),(394571,'5','131','2022-03-24',140,'','','5',33000.00,'257564','','','3247','ZARIA 2','1151822',0.00,'2022-03-25 13:08:45',5,'','628','','0000-00-00 00:00:00','664','2022-03-26 04:54:02'),(394572,'5','131','2022-03-25',140,'','','5',853400.00,'257565','','','3247','ZARIA 2','115637',867246.60,'2022-03-28 20:55:36',5,'','628','','0000-00-00 00:00:00','664','2022-03-29 07:53:24'),(394573,'5','131','2022-03-25',140,'','','2',13800.00,'257565','','','','','',0.00,'2022-03-28 20:57:43',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2022-03-29 07:53:24'),(394574,'5','131','2022-03-26',140,'','','5',378876.30,'257566','','','3247','ZARIA 2','119065',365070.00,'2022-03-28 20:59:02',5,'','628','','0000-00-00 00:00:00','664','2022-03-29 07:53:24'),(394575,'5','131','2022-03-26',140,'','','2',13800.00,'257566','','','','','',0.00,'2022-03-28 20:59:36',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2022-03-29 07:53:24'),(394576,'5','131','2022-04-12',140,'','','5',68290.00,'257583','','','3247','ZARIA 2','1147525',82496.70,'2022-04-13 11:45:05',5,'','628','','0000-00-00 00:00:00','664','2022-04-14 03:29:42'),(394577,'5','131','2022-04-12',140,'','','2',14200.00,'257583','','','','','',0.00,'2022-04-13 11:45:43',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2022-04-14 03:29:42'),(394578,'5','131','2022-04-13',140,'','','5',747940.00,'257584','','','3247','ZARIA 2','112235',997149.45,'2022-04-14 12:36:01',5,'','628','','0000-00-00 00:00:00','664','2022-04-15 05:48:26'),(394579,'5','131','2022-04-13',140,'','','2',14200.00,'257584','','','','','',0.00,'2022-04-14 12:36:22',5,'','628','','0000-00-00 00:00:00','664','2022-04-15 05:48:26'),(394580,'5','131','2022-04-13',140,'','','2',235000.00,'257584','','','','','',0.00,'2022-04-14 12:37:04',5,'','628','','0000-00-00 00:00:00','664','2022-04-15 05:48:26'),(394581,'5','131','2022-04-14',140,'','','5',766060.00,'257585','','','3247','ZARIA 2','111096',801469.35,'2022-04-19 12:36:46',5,'','628','','0000-00-00 00:00:00','664','2022-04-19 14:53:28'),(394582,'5','131','2022-04-14',140,'','','2',14200.00,'257585','','','','','',0.00,'2022-04-19 12:37:44',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2022-04-19 14:53:28'),(394583,'5','131','2022-04-14',140,'','','2',11700.00,'257585','','','','','',0.00,'2022-04-19 12:38:34',5,'MONTHLY Expenses ','628','','0000-00-00 00:00:00','664','2022-04-19 14:53:28'),(394584,'5','131','2022-04-14',140,'','','2',9500.00,'257585','','','','','',0.00,'2022-04-19 12:39:15',5,'Gen Services ','628','','0000-00-00 00:00:00','664','2022-04-19 14:53:28'),(394585,'5','131','2022-04-15',140,'','','5',558960.00,'257586','','','3247','ZARIA 2','1111093',573162.15,'2022-04-19 12:42:15',5,'','628','','0000-00-00 00:00:00','664','2022-04-19 14:53:28'),(394586,'5','131','2022-04-15',140,'','','2',14200.00,'257586','','','','','',0.00,'2022-04-19 12:43:01',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2022-04-19 14:53:28'),(394587,'5','131','2022-04-21',140,'','','5',792000.00,'257595','','','3247','ZARIA 2','1112134',833226.90,'2022-04-23 04:04:44',5,'','628','','0000-00-00 00:00:00','664','2022-04-23 05:47:32'),(394588,'5','131','2022-04-21',140,'','','2',14200.00,'257595','','','','','',0.00,'2022-04-23 04:05:20',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2022-04-23 05:47:32'),(394589,'5','131','2022-04-21',140,'','','2',27000.00,'257595','','','','','',0.00,'2022-04-23 04:06:40',5,'Fire extinguishers refilling  ','628','','0000-00-00 00:00:00','664','2022-04-23 05:47:32'),(394590,'5','131','2022-04-28',140,'','','5',380700.00,'257599','','','3247','ZARIA 2','1147526',394977.00,'2022-04-29 20:59:20',5,'','628','','0000-00-00 00:00:00','664','2022-05-09 14:00:48'),(394591,'5','131','2022-04-28',140,'','','2',14200.00,'257599','','','','','',0.00,'2022-04-29 21:00:20',5,'','628','','0000-00-00 00:00:00','664','2022-05-09 14:00:48'),(394592,'5','131','2022-04-30',140,'','','5',1259270.00,'257601','','','3247','ZARIA 2','1147063',1273476.60,'2022-05-09 15:05:00',5,'','628','','0000-00-00 00:00:00','664','2022-05-09 18:59:43'),(394593,'5','131','2022-05-01',140,'','','5',767830.00,'257602','','','3247','ZARIA 2','1124682',1017030.30,'2022-05-09 15:06:20',5,'','628','','0000-00-00 00:00:00','664','2022-05-09 18:59:43'),(394594,'5','131','2022-04-30',140,'','','2',14200.00,'257601','','','','','',0.00,'2022-05-09 15:07:08',5,'','628','','0000-00-00 00:00:00','664','2022-05-09 18:59:43'),(394595,'5','131','2022-05-01',140,'','','2',14200.00,'257602','','','','','',0.00,'2022-05-09 15:08:24',5,'','628','','0000-00-00 00:00:00','664','2022-05-09 18:59:43'),(394596,'5','131','2022-05-01',140,'','','2',235000.00,'257602','','','','','',0.00,'2022-05-09 15:10:56',2,'','628','','0000-00-00 00:00:00','664','2022-05-09 18:59:43'),(394597,'5','131','2022-05-02',140,'','','5',493830.00,'257603','','','3247','ZARIA 2','25692157',508038.30,'2022-05-09 15:11:58',5,'','628','','0000-00-00 00:00:00','664','2022-05-09 18:59:43'),(394598,'5','131','2022-05-02',140,'','','2',14200.00,'257603','','','','','',0.00,'2022-05-09 15:12:24',5,'','628','','0000-00-00 00:00:00','664','2022-05-09 18:59:43'),(394599,'5','131','2022-05-03',140,'','','5',1323890.00,'257604','','','3247','ZARIA 2','1267123',1338097.20,'2022-05-09 15:36:27',5,'','628','','0000-00-00 00:00:00','664','2022-05-09 18:59:43'),(394600,'5','131','2022-05-03',140,'','','2',14200.00,'257604','','','','','',0.00,'2022-05-09 15:37:06',5,'','628','','0000-00-00 00:00:00','664','2022-05-09 18:59:43'),(394601,'5','131','2022-05-07',140,'','','5',1333850.00,'257605','','','3247','ZARIA 2','110980',1348056.60,'2022-05-10 17:37:57',5,'','628','','0000-00-00 00:00:00','664','2022-05-10 17:47:09'),(394602,'5','131','2022-05-07',140,'','','2',14200.00,'257605','','','','','',0.00,'2022-05-10 17:38:41',5,'','628','','0000-00-00 00:00:00','664','2022-05-10 17:47:09'),(394603,'5','131','2022-05-08',140,'','','5',1439190.00,'257606','','','3247','ZARIA 2','1207803',1453390.95,'2022-05-10 17:40:25',5,'','628','','0000-00-00 00:00:00','664','2022-05-10 17:47:09'),(394604,'5','131','2022-05-08',140,'','','2',14200.00,'257606','','','','','',0.00,'2022-05-10 17:41:03',5,'','628','','0000-00-00 00:00:00','664','2022-05-10 17:47:09'),(394605,'5','131','2022-05-09',140,'','','5',1068930.00,'257611','','','3247','ZARIA 2','11154136',1083132.60,'2022-05-10 17:43:10',5,'','628','','0000-00-00 00:00:00','664','2022-05-10 17:47:09'),(394606,'5','131','2022-05-09',140,'','','2',14200.00,'257611','','','','','',0.00,'2022-05-10 17:43:46',5,'','628','','0000-00-00 00:00:00','664','2022-05-10 17:47:08'),(394607,'5','131','2022-05-10',140,'','','5',528620.00,'257612','','','3247','ZARIA 2','1190563',554520.45,'2022-05-11 17:26:03',5,'','628','','0000-00-00 00:00:00','664','2022-05-12 22:41:24'),(394608,'5','131','2022-05-10',140,'','','2',14200.00,'257612','','','','','',0.00,'2022-05-11 17:26:33',5,'','628','','0000-00-00 00:00:00','664','2022-05-12 22:41:24'),(394609,'5','131','2022-05-11',140,'','','5',157450.00,'257613','','','3247','ZARIA 2','1107607',171657.75,'2022-05-12 08:42:07',5,'','628','','0000-00-00 00:00:00','664','2022-05-12 22:41:24'),(394610,'5','131','2022-05-11',140,'','','2',14200.00,'257613','','','','','',0.00,'2022-05-12 08:43:20',5,'','628','','0000-00-00 00:00:00','664','2022-05-12 22:41:24'),(394611,'5','131','2022-05-18',140,'','','5',584000.00,'257620','','','3247','ZARIA 2','113423',599001.15,'2022-05-19 08:57:01',5,'','628','','0000-00-00 00:00:00','600','2022-05-19 20:59:23'),(394612,'5','131','2022-05-18',140,'','','2',15000.00,'257620','','','','','',0.00,'2022-05-19 08:57:47',5,'','628','','0000-00-00 00:00:00','600','2022-05-19 20:59:23'),(394613,'5','131','2022-05-19',140,'','','5',782780.00,'257621','','','3247','ZARIA 2','1119919',797784.90,'2022-05-20 09:24:18',5,'','628','','0000-00-00 00:00:00','600','2022-05-20 17:14:56'),(394614,'5','131','2022-05-19',140,'','','2',15000.00,'257621','','','','','',0.00,'2022-05-20 09:25:40',5,'','628','','0000-00-00 00:00:00','600','2022-05-20 17:14:56'),(394615,'5','131','2022-05-20',140,'','','5',620000.00,'257622','','','3247','ZARIA 2','1119910',848017.50,'2022-05-23 21:02:37',5,'','628','','0000-00-00 00:00:00','600','2022-05-23 21:57:03'),(394616,'5','131','2022-05-20',140,'','','2',15000.00,'257622','','','','','',0.00,'2022-05-23 21:03:14',5,'','628','','0000-00-00 00:00:00','600','2022-05-23 21:57:03'),(394617,'5','131','2022-05-20',140,'','','2',200000.00,'257622','','','','','',0.00,'2022-05-23 21:04:02',5,'0ver payment ','628','','0000-00-00 00:00:00','600','2022-05-23 21:57:03'),(394618,'5','131','2022-05-20',140,'','','2',3000.00,'257622','','','','','',0.00,'2022-05-23 21:04:34',5,'Lawal ','628','','0000-00-00 00:00:00','600','2022-05-23 21:57:03'),(394619,'5','131','2022-05-20',140,'','','2',10000.00,'257622','','','','','',0.00,'2022-05-23 21:05:09',5,'Weight and measure ','628','','0000-00-00 00:00:00','600','2022-05-23 21:57:03'),(394620,'5','131','2022-05-21',140,'','','5',402000.00,'257623','','','3247','ZARIA 2','111930',747077.10,'2022-05-23 21:07:37',5,'','628','','0000-00-00 00:00:00','600','2022-05-23 21:57:03'),(394621,'5','131','2022-05-21',140,'','','2',15000.00,'257623','','','','','',0.00,'2022-05-23 21:08:08',5,'Daily Expenses ','628','','0000-00-00 00:00:00','600','2022-05-23 21:57:03'),(394622,'5','131','2022-05-21',140,'','','2',330000.00,'257623','','','','','',0.00,'2022-05-23 21:08:56',5,'ZARIA 1 ','628','','0000-00-00 00:00:00','600','2022-05-23 21:57:03'),(394623,'5','131','2022-06-05',140,'','','5',666650.00,'257638','','','3247','ZARIA 2','1114753',681651.30,'2022-06-06 12:47:50',5,'','628','','0000-00-00 00:00:00','664','2022-06-06 20:54:07'),(394624,'5','131','2022-06-05',140,'','','2',15000.00,'257638','','','','','',0.00,'2022-06-06 12:48:23',5,'Daily Expenses ','628','','0000-00-00 00:00:00','664','2022-06-06 20:54:07'),(394625,'5','131','2022-06-06',140,'','','5',838060.00,'257639','','','3247','ZARIA 2','1119926',853064.85,'2022-06-08 06:06:08',5,'','628','','0000-00-00 00:00:00','664','2022-06-08 10:34:15'),(394626,'5','131','2022-06-06',140,'','','2',15000.00,'257639','','','','ZARIA 2','',0.00,'2022-06-08 06:06:50',5,'','628','','0000-00-00 00:00:00','664','2022-06-08 10:34:15'),(394627,'5','131','2022-06-07',140,'','','5',394100.00,'257640','','','3247','ZARIA 2','1117523',625812.00,'2022-06-08 20:36:06',5,'','628','','0000-00-00 00:00:00','664','2022-06-09 10:48:38'),(394628,'5','131','2022-06-07',140,'','','2',15000.00,'257640','','','','','',0.00,'2022-06-08 20:36:40',5,'','628','','0000-00-00 00:00:00','664','2022-06-09 10:48:38'),(394629,'5','131','2022-06-07',140,'','','2',205000.00,'257640','','','','','',0.00,'2022-06-08 20:37:06',5,'','628','','0000-00-00 00:00:00','664','2022-06-09 10:48:38'),(394630,'5','131','2022-06-07',140,'','','2',11700.00,'257640','','','','','',0.00,'2022-06-08 20:41:17',5,'','628','','0000-00-00 00:00:00','664','2022-06-09 10:48:38'),(394631,'5','131','2022-06-08',140,'','','5',292400.00,'257641','','','3247','ZARIA 2','1119912',307414.80,'2022-06-09 16:28:59',5,'','628','','0000-00-00 00:00:00','664','2022-06-10 05:28:58'),(394632,'5','131','2022-06-08',140,'','','2',15000.00,'257641','','','','','',0.00,'2022-06-09 16:29:23',5,'','628','','0000-00-00 00:00:00','664','2022-06-10 05:28:58'),(394633,'5','131','2022-07-20',140,'','','5',1094990.00,'257683','','','3247','ZARIA 2','1119922',1316990.00,'2022-07-21 10:31:45',5,'','628','','0000-00-00 00:00:00','664','2022-07-21 19:57:55'),(394634,'5','131','2022-07-20',140,'','','2',17000.00,'257683','','','','','',0.00,'2022-07-21 10:32:30',5,'','628','','0000-00-00 00:00:00','664','2022-07-21 19:57:55'),(394635,'5','131','2022-07-20',140,'','','2',205000.00,'257683','','','','','',0.00,'2022-07-21 10:33:04',5,'','628','','0000-00-00 00:00:00','664','2022-07-21 19:57:55'),(394636,'5','131','2022-07-21',140,'','','5',1302660.00,'257684','','','3247','ZARIA 2','1119929',1319660.00,'2022-07-23 09:51:34',5,'','628','','0000-00-00 00:00:00','664','2022-07-23 10:02:10'),(394637,'5','131','2022-07-21',140,'','','2',17000.00,'257684','','','','','',0.00,'2022-07-23 09:52:16',5,'','628','','0000-00-00 00:00:00','664','2022-07-23 10:02:10'),(394638,'5','131','2022-07-22',140,'','','5',1008780.00,'257685','','','3247','ZARIA 2','1119930',1025780.00,'2022-07-25 16:25:56',5,'','628','','0000-00-00 00:00:00','664','2022-07-25 18:47:31'),(394639,'5','131','2022-07-22',140,'','','2',17000.00,'257685','','','','','',0.00,'2022-07-25 16:26:33',5,'','628','','0000-00-00 00:00:00','664','2022-07-25 18:47:31'),(394640,'5','131','2022-07-23',140,'','','5',1274490.00,'257686','','','3247','ZARIA 2','1119931',1291490.00,'2022-07-25 16:27:45',5,'','628','','0000-00-00 00:00:00','664','2022-07-25 18:47:31'),(394641,'5','131','2022-07-23',140,'','','2',17000.00,'257686','','','','','',0.00,'2022-07-25 16:28:07',5,'','628','','0000-00-00 00:00:00','664','2022-07-25 18:47:31'),(394642,'5','131','2022-07-24',140,'','','5',1280440.00,'257687','','','3247','ZARIA 2','11156326',1297449.00,'2022-07-25 16:29:22',5,'','628','','0000-00-00 00:00:00','664','2022-07-25 18:47:31'),(394643,'5','131','2022-07-24',140,'','','2',17000.00,'257687','','','','','',0.00,'2022-07-25 16:29:47',5,'','628','','0000-00-00 00:00:00','664','2022-07-25 18:47:31'),(394644,'5','131','2022-07-25',140,'','','5',808770.00,'257688','','','3247','ZARIA 2','1772549',825771.55,'2022-07-26 10:56:49',5,'','628','','0000-00-00 00:00:00','664','2022-07-26 18:18:34'),(394645,'5','131','2022-07-25',140,'','','2',17000.00,'257688','','','','','',0.00,'2022-07-26 10:57:18',5,'','628','','0000-00-00 00:00:00','664','2022-07-26 18:18:34'),(394646,'5','131','2022-10-26',140,'2634','','2',22148.10,'257701','','','','','',0.00,'2022-10-26 13:11:05',0,'FSM CLEARED BALANCE AMOUNT','606','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `purchases_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_receptions`
--

DROP TABLE IF EXISTS `purchases_receptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_receptions` (
  `bridge_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `purchase_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `loadingdate` datetime NOT NULL,
  `loadingpoint` varchar(100) DEFAULT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `received` decimal(20,2) NOT NULL,
  `distributed` decimal(20,2) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `vessel` varchar(50) NOT NULL,
  `drivername` varchar(30) NOT NULL,
  `driverphone` varchar(30) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`bridge_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`supplier_id`,`loadingdate`,`quantity`,`waybill`,`meterno`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`purchase_id`),
  KEY `truck_id` (`tank_id`)
) ENGINE=InnoDB AUTO_INCREMENT=132710 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_receptions`
--

LOCK TABLES `purchases_receptions` WRITE;
/*!40000 ALTER TABLE `purchases_receptions` DISABLE KEYS */;
INSERT INTO `purchases_receptions` VALUES (96470,'5',63111,'131',308,140,'2021-03-07 00:00:00','depot ',13500.00,13500.00,0.00,'1254','','745','GWL 66 YT','garba yaro ','','',5,'2021-03-07 18:42:25','475','0000-00-00 00:00:00','','2021-03-10 05:42:13','604'),(98322,'5',64324,'131',308,140,'2021-03-23 00:00:00','depot ',30000.00,30000.00,0.00,'1202','','744','dka 783 xf','lawal isha','','',5,'2021-03-23 16:46:47','475','0000-00-00 00:00:00','','2021-03-24 00:33:28','604'),(98464,'5',64380,'131',308,140,'2021-03-24 00:00:00','depot ',28000.00,28000.00,0.00,'','','744','MKA 560 ZB','jamilu Exchange ','','',5,'2021-03-24 16:14:21','475','0000-00-00 00:00:00','','2021-03-25 03:55:00','604'),(98587,'5',64469,'131',308,140,'2021-03-25 00:00:00','Deport ',45000.00,44700.00,0.00,'','','744','DKA 756 YF ','Yusuf EXCHANGE ','','',2,'2021-03-25 14:35:14','475','2021-03-27 02:17:10','604','2021-03-27 02:15:42','604'),(99074,'5',64469,'131',308,140,'2021-03-29 00:00:00','depot ',44700.00,44700.00,0.00,'','','744','DKA 756 YF ','Yusuf Exchange ','','',5,'2021-03-29 13:30:59','475','0000-00-00 00:00:00','','2021-03-29 13:42:08','604'),(99076,'5',62716,'131',308,140,'2021-03-29 00:00:00','depot ',13250.00,13250.00,0.00,'','','744','kmc 139 yt','','','',5,'2021-03-29 13:34:01','475','0000-00-00 00:00:00','','2021-03-31 02:05:16','604'),(99761,'5',65126,'131',308,140,'2021-04-03 00:00:00','depot ',39550.00,39550.00,0.00,'1771','','744','TRN 750 ZG','salisu ','','',5,'2021-04-03 18:13:15','475','0000-00-00 00:00:00','','2021-04-03 20:39:18','604'),(99762,'5',65246,'131',309,140,'2021-04-03 00:00:00','depot ',26500.00,26500.00,0.00,'','','747','KZR 499 XA ','anas ','','',5,'2021-04-03 18:22:29','475','0000-00-00 00:00:00','','2021-04-03 20:38:57','604'),(100246,'5',65580,'131',308,140,'2021-04-07 00:00:00','depot ',40000.00,40000.00,0.00,'1964','','744','RAN 551 XA ','sani abdulllahi ','07033293166','',5,'2021-04-07 13:36:01','475','0000-00-00 00:00:00','','2021-04-07 16:28:11','604'),(102911,'5',67108,'131',308,140,'2021-04-30 00:00:00','depot ',39400.00,39400.00,0.00,'1931','','744','RAN 554 XA ','babannan ','','',5,'2021-04-30 16:05:30','475','0000-00-00 00:00:00','','2021-05-02 03:14:46','604'),(103775,'5',67799,'131',308,140,'2021-05-08 00:00:00','depot ',30000.00,30000.00,0.00,'2469','','744','LSD 604 XY','Aminu wadata','','',5,'2021-05-08 17:17:55','475','0000-00-00 00:00:00','','2021-05-10 09:41:14','604'),(104995,'5',68547,'131',308,140,'2021-05-19 00:00:00','Deport ',14950.00,14950.00,0.00,'','','744','KTN 479 XZ ','Tanimu ','Nil ','',5,'2021-05-19 17:16:26','628','0000-00-00 00:00:00','','2021-05-20 12:23:16','604'),(105186,'5',68753,'131',308,140,'2021-05-21 00:00:00','Deport ',24000.00,24000.00,0.00,'2431  ','','744','BCH 733 XA ','Yahaya ','NIL ','',5,'2021-05-21 16:37:08','628','0000-00-00 00:00:00','','2021-05-21 18:55:17','604'),(106116,'5',69337,'131',308,140,'2021-05-30 00:00:00','Deport ',44600.00,44600.00,0.00,'1300','','744','KMC 136 YT ','Yusuf ','','',5,'2021-05-30 10:52:11','628','0000-00-00 00:00:00','','2021-05-31 08:31:04','604'),(107048,'5',69990,'131',308,140,'2021-06-08 00:00:00','Deport ',44930.00,44930.00,0.00,'1596','','744','MKA 769 ZU ','Hassan ','','',5,'2021-06-08 05:23:41','628','0000-00-00 00:00:00','','2021-06-08 17:45:01','604'),(108216,'5',70578,'131',308,140,'2021-06-18 00:00:00','Deport ',45000.00,45000.00,0.00,'1910','','744','MKA 556 ZB ','Lawal ','','',5,'2021-06-18 11:07:59','628','0000-00-00 00:00:00','','2021-06-18 11:11:49','604'),(109283,'5',71360,'131',308,140,'2021-06-29 00:00:00','Deport ',44800.00,44800.00,0.00,'1402','','744','MKA 769 ZU ','Hassan ','','',5,'2021-06-29 04:31:54','628','0000-00-00 00:00:00','','2021-06-29 07:04:57','604'),(110746,'5',72033,'131',308,140,'2021-07-12 00:00:00','Deport ',30000.00,30000.00,0.00,'1762','','744','LSD 767 XY ','Garba ','','',5,'2021-07-12 18:53:58','628','0000-00-00 00:00:00','','2021-07-12 19:55:16','604'),(111519,'5',72415,'131',308,140,'2021-07-19 00:00:00','Deport ',40000.00,40000.00,0.00,'1796','','744','KZR 576 XA ','Sani ','','',5,'2021-07-19 09:35:08','628','0000-00-00 00:00:00','','2021-07-19 10:32:32','604'),(112618,'5',73434,'131',308,140,'2021-07-30 00:00:00','Deport ',39450.00,39450.00,0.00,'198059','','744','MKA 467 ZE ','Hassan ','','',5,'2021-07-30 08:49:00','628','0000-00-00 00:00:00','','2021-07-30 11:46:05','604'),(113668,'5',74002,'131',308,140,'2021-08-09 00:00:00','Deport ',45000.00,45000.00,0.00,'1402','','744','KJA 364 XN ','Lawal ','','',5,'2021-08-09 09:15:08','628','0000-00-00 00:00:00','','2021-08-10 10:04:56','604'),(114769,'5',74758,'131',308,140,'2021-08-19 00:00:00','Deport ',14950.00,14950.00,0.00,'1452','','744','BCH 744XA ','Tasiu','','',5,'2021-08-19 11:49:44','628','0000-00-00 00:00:00','','2021-08-19 17:41:56','604'),(115016,'5',74867,'131',308,140,'2021-08-22 00:00:00','Deport ',22320.00,22320.00,0.00,'1160','','744','BCH 739 XA ','Saidu','','',5,'2021-08-22 08:38:29','628','0000-00-00 00:00:00','','2021-08-22 09:47:52','604'),(115424,'5',75177,'131',308,140,'2021-08-26 00:00:00','Deport ',30000.00,30000.00,0.00,'0312','','744','LSD 766 XY ','Dan shi\'a ','','',5,'2021-08-26 07:21:07','628','0000-00-00 00:00:00','','2021-08-26 09:44:24','604'),(116014,'5',75519,'131',308,140,'2021-09-01 00:00:00','Deport ',29950.00,29950.00,0.00,'2080','','744','LSD 602 XY ','','','',5,'2021-09-01 09:03:32','628','0000-00-00 00:00:00','','2021-09-02 08:26:42','604'),(117544,'5',76497,'131',308,140,'2021-09-17 00:00:00','Deport ',14850.00,14850.00,0.00,'1938','','744','LSD 763 XY ','Tasiu','','',5,'2021-09-17 08:45:12','628','0000-00-00 00:00:00','','2021-09-17 10:19:35','604'),(117947,'5',76752,'131',308,140,'2021-09-21 00:00:00','Deport ',44800.00,44800.00,0.00,'2060','','744','TRN 103 ZG ','Dauda ','','',5,'2021-09-21 11:04:34','628','0000-00-00 00:00:00','','2021-09-21 14:04:06','604'),(120001,'5',78064,'131',309,140,'2021-10-11 00:00:00','AA RANO DEPOT',900.00,900.00,0.00,'NIL','','747','NIL','NIL','0802','AGO RECIEVED',5,'2021-10-11 14:14:12','600','0000-00-00 00:00:00','','2021-10-11 14:14:32','600'),(120004,'5',78065,'131',308,140,'2021-10-11 00:00:00','AA RANO DEPOT',150.00,150.00,0.00,'NIL','','744','NIL','NIL','0802','PMS RECIEVED',5,'2021-10-11 14:17:49','600','00