-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_5_station_107
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_5_station_107`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_5_station_107` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_5_station_107`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3530 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (2027,30015,'',0,'24','5','107','SALARIES AND WAGES','','2019-09-19 07:14:43',5,0.00,0.00,'','447','2019-09-19 07:14:43','447',0,1),(2028,4000,'',0,'24','5','107','PURCHASES','','2019-09-19 07:15:53',5,0.00,0.00,'2019-09-19','447','2019-09-19 07:18:22','447',0,1),(2029,3004,'',0,'6.1','5','107','CASH','','2019-09-19 07:16:09',5,0.00,0.00,'','447','2019-09-19 07:16:09','447',0,1),(2030,4002,'',0,'20','5','107','SALES','','2019-09-19 07:18:56',5,0.00,0.00,'','447','2019-09-19 07:18:56','447',0,1),(3514,4013,'',0,'22','5','107','PURCHASES','','2021-07-27 17:38:17',5,0.00,0.00,'','447','2021-07-27 17:38:17','447',0,1),(3515,30180,'',0,'24','5','107','PUBLIC RELATION','','2021-07-27 17:38:41',5,0.00,0.00,'','447','2021-07-27 17:38:41','447',0,1),(3516,30181,'',0,'24','5','107','DIESEL INTERNAL CONSUMPTION (G','','2021-07-27 17:40:15',5,0.00,0.00,'','447','2021-07-27 17:40:15','447',0,1),(3517,30182,'',0,'24','5','107','CLEANING & SANITARY ITEMS','','2021-07-27 17:40:50',5,0.00,0.00,'','447','2021-07-27 17:40:50','447',0,1),(3518,30183,'',0,'24','5','107','TRANSPORT FARES','','2021-07-27 17:41:08',5,0.00,0.00,'','447','2021-07-27 17:41:08','447',0,1),(3519,30184,'',0,'24','5','107','OTHER OPERATING EXPENSES','','2021-07-27 17:41:36',5,0.00,0.00,'','447','2021-07-27 17:41:36','447',0,1),(3520,30185,'',0,'24','5','107','GENERATOR REPAIRS & MAINTENANC','','2021-07-27 17:42:13',5,0.00,0.00,'','447','2021-07-27 17:42:13','447',0,1),(3521,30186,'',0,'24','5','107','WEIGHT AND MEASURE','','2021-07-27 17:42:43',5,0.00,0.00,'','447','2021-07-27 17:42:43','447',0,1),(3522,30187,'',0,'24','5','107','DPR EXPENSES','','2021-07-27 17:43:01',5,0.00,0.00,'','447','2021-07-27 17:43:01','447',0,1),(3523,30188,'',0,'24','5','107','TRAVELLING EXPENSES','','2021-07-27 17:43:24',5,0.00,0.00,'','447','2021-07-27 17:43:24','447',0,1),(3524,30189,'',0,'24','5','107','MEDICAL EXPENSES','','2021-07-27 17:43:43',5,0.00,0.00,'','447','2021-07-27 17:43:43','447',0,1),(3525,30190,'',0,'24','5','107','OFFICIAL CAR FUEL & REPAIRS','','2021-07-27 17:44:18',5,0.00,0.00,'','447','2021-07-27 17:44:18','447',0,1),(3526,4045,'',0,'2','5','107','ZB:EBILLS-1016650302','','2021-07-27 17:45:40',5,0.00,0.00,'','447','2021-07-27 17:45:40','447',0,1),(3527,4046,'',0,'2','5','107','JA\'IZ-0010037957','','2022-03-02 19:12:48',5,0.00,0.00,'','600','2022-03-02 19:12:48','600',0,0),(3528,4047,'',0,'2','5','107','TAJ-0001807373','','2022-12-14 16:52:38',5,0.00,0.00,'','446','2022-12-14 16:52:38','446',0,0),(3529,2000,'',0,'6','5','107','INVENTORY VALUE ADJUSTMENT','','2023-02-06 10:37:59',5,0.00,0.00,'','600','2023-02-06 10:37:59','600',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
INSERT INTO `accounts_transactions` VALUES (1,'5','107','0000-00-00','2023-02-08 15:51:55',10,'606','','0000-00-00 00:00:00','606','2023-02-08 15:53:20'),(2,'5','107','0000-00-00','2023-02-08 15:56:24',10,'606','','0000-00-00 00:00:00','606','2023-02-08 15:57:19'),(3,'5','107','0000-00-00','2023-03-14 10:24:00',10,'606','','0000-00-00 00:00:00','606','2023-03-14 10:26:55');
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
INSERT INTO `accounts_transactions_items` VALUES (1,'5','107','1','118','supplier',0.00,'Price decrease of AGO from 830 to 820 dipping is 111,840',1118040.00,'2023-02-08'),(2,'5','107','1','3529','6',1118040.00,'Price decrease of AGO from 830 to 820 dipping is 111,840',0.00,'2023-02-08'),(3,'5','107','2','118','supplier',0.00,'Price decrease of AGO from 860 to 830 dipping is 165,554',4966632.00,'2023-01-14'),(4,'5','107','2','3529','6',4966632.00,'Price decrease of AGO from 860 to 830 dipping is 165,554',0.00,'2023-02-08'),(5,'5','107','3','118','supplier',0.00,'Price decrease of AGO from 820 to 800 dipping is 73,220',1464406.00,'2023-03-05'),(7,'5','107','3','3529','6',1464406.00,'Price decrease of AGO from 820 to 800 dipping is 73,220',0.00,'2023-03-05');
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=45822 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
INSERT INTO `accounts_vouchers` VALUES (45821,'5','107','2021-09-07','','2027',0.00,'2021-09-07 16:00:26',5,'600','','0000-00-00 00:00:00','600','2021-09-07 16:02:32');
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=82841 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
INSERT INTO `accounts_vouchers_items` VALUES (82840,'5','107',45821,2027,'sal',1000.00);
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=18660 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('5','107',16099,'708',49086.56,25701.00,'2021-08-18','','2021-08-18 13:52:40','600','600',2021,'600','2021-08-18 13:52:40',5),('5','107',16100,'706',100590.22,138916.00,'2021-08-18','','2021-08-18 13:54:06','600','600',2021,'600','2021-08-18 13:54:06',5),('5','107',16101,'708',41631.00,25701.00,'2021-08-18','','2021-08-18 13:54:31','600','600',2021,'600','2021-08-18 13:54:31',5),('5','107',16102,'699',20458.08,36000.00,'2021-08-18','','2021-08-18 13:55:08','600','600',2021,'600','2021-08-18 13:55:08',5),('5','107',16103,'700',43427.18,39900.00,'2021-08-18','','2021-08-18 13:55:39','600','600',2021,'600','2021-08-18 13:55:39',5),('5','107',16104,'702',15851.94,5539.00,'2021-08-18','','2021-08-18 13:56:09','600','600',2021,'600','2021-08-18 13:56:09',5),('5','107',16105,'703',37360.06,32050.00,'2021-08-18','','2021-08-18 13:56:36','600','600',2021,'600','2021-08-18 13:56:36',5),('5','107',16106,'704',39963.00,40000.00,'2021-08-18','','2021-08-18 13:56:53','600','600',2021,'600','2021-08-18 13:56:53',5),('5','107',16107,'696',22870.90,21250.00,'2021-08-18','','2021-08-18 13:58:30','600','600',2021,'600','2021-08-18 13:58:30',5),('5','107',16108,'697',2850.65,1500.00,'2021-08-18','','2021-08-18 13:58:51','600','600',2021,'600','2021-08-18 13:58:51',5),('5','107',16109,'698',40329.06,39350.00,'2021-08-18','','2021-08-18 13:59:16','600','600',2021,'600','2021-08-18 13:59:16',5),('5','107',16112,'701',2007.77,1743.00,'2021-08-18','','2021-08-18 20:25:23','600','600',2021,'600','2021-08-18 20:25:23',5),('5','107',16113,'705',48516.11,45900.00,'2021-08-18','','2021-08-18 20:25:57','600','600',2021,'600','2021-08-18 20:25:57',5),('5','107',17019,'708',1492.42,5000.00,'2021-10-27','','2021-10-27 18:53:17','600','600',2021,'600','2021-10-27 18:53:17',5),('5','107',17024,'708',2493.15,5000.00,'2021-10-28','','2021-10-28 07:53:51','600','600',2021,'600','2021-10-28 07:53:51',5),('5','107',17106,'700',21029.50,36000.00,'2021-10-29','','2021-10-29 08:34:52','600','600',2021,'600','2021-10-29 08:34:52',5),('5','107',18115,'702',6585.24,10000.00,'2021-12-19','','2021-12-19 07:48:58','600','600',2021,'600','2021-12-19 07:48:58',5),('5','107',18116,'702',2663.38,10000.00,'2021-12-19','','2021-12-19 08:31:46','600','600',2021,'600','2021-12-19 08:31:46',5),('5','107',18189,'704',11817.23,20000.00,'2021-12-25','','2021-12-25 09:12:55','600','600',2021,'600','2021-12-25 09:12:55',5),('5','107',18190,'704',4654.59,20000.00,'2021-12-25','','2021-12-25 09:14:36','600','600',2021,'600','2021-12-25 09:14:36',5),('5','107',18325,'703',10943.46,20000.00,'2022-01-02','','2022-01-02 16:04:41','600','600',2022,'600','2022-01-02 16:04:41',5),('5','107',18396,'703',19221.94,25000.00,'2022-01-09','','2022-01-09 21:07:17','600','600',2022,'600','2022-01-09 21:07:17',5),('5','107',18397,'703',3807.70,25000.00,'2022-01-09','','2022-01-09 21:26:07','600','600',2022,'600','2022-01-09 21:26:07',5),('5','107',18428,'703',1819.50,10000.00,'2022-01-12','','2022-01-12 17:25:31','600','600',2022,'600','2022-01-12 17:25:31',5),('5','107',18454,'708',1283.23,20000.00,'2022-01-16','','2022-01-16 17:44:30','600','600',2022,'600','2022-01-16 17:44:30',5),('5','107',18481,'703',3922.62,13000.00,'2022-01-17','','2022-01-17 20:58:04','600','600',2022,'600','2022-01-17 20:58:04',5),('5','107',18592,'706',6974.81,14000.00,'2022-01-29','','2022-01-29 17:40:08','600','600',2022,'600','2022-01-29 17:40:08',5),('5','107',18593,'706',33905.88,42000.00,'2022-02-05','','2022-02-05 10:27:03','600','600',2022,'600','2022-02-05 10:27:03',5),('5','107',18594,'703',6774.66,30000.00,'2022-06-07','','2022-06-07 10:17:33','600','600',2022,'600','2022-06-07 10:17:33',5),('5','107',18595,'708',850.09,10000.00,'2022-06-13','','2022-06-13 14:35:00','600','600',2022,'600','2022-06-13 14:35:00',5),('5','107',18596,'696',13747.40,20000.00,'2022-06-18','','2022-06-18 15:03:10','600','600',2022,'600','2022-06-18 15:03:10',5),('5','107',18597,'699',5280.39,20000.00,'2022-06-18','','2022-06-18 15:03:26','600','600',2022,'600','2022-06-18 15:03:26',5),('5','107',18598,'699',10188.49,13000.00,'2022-06-27','','2022-06-27 12:29:15','600','600',2022,'600','2022-06-27 12:29:15',5),('5','107',18599,'699',480.89,4000.00,'2022-06-27','','2022-06-27 13:19:14','600','600',2022,'600','2022-06-27 13:19:14',5),('5','107',18600,'702',14071.44,19000.00,'2022-06-27','','2022-06-27 13:19:32','600','600',2022,'600','2022-06-27 13:19:32',5),('5','107',18601,'708',7766.95,9000.00,'2022-07-05','','2022-07-05 14:18:33','600','600',2022,'600','2022-07-05 14:18:33',5),('5','107',18602,'708',2294.14,23000.00,'2022-08-03','','2022-08-03 13:54:36','600','600',2022,'600','2022-08-03 13:54:36',5),('5','107',18603,'696',21661.55,599.00,'2022-08-01','','2022-08-03 15:12:13','600','600',2022,'600','2022-08-03 15:12:13',5),('5','107',18604,'697',23285.34,3415.00,'2022-08-01','','2022-08-03 15:12:38','600','600',2022,'600','2022-08-03 15:12:38',5),('5','107',18605,'698',30678.33,1092.00,'2022-08-03','','2022-08-03 15:13:05','600','600',2022,'600','2022-08-03 15:13:05',5),('5','107',18606,'699',8037.17,10540.00,'2022-08-01','','2022-08-03 15:13:47','600','600',2022,'600','2022-08-03 15:13:47',5),('5','107',18607,'700',38877.96,2882.00,'2022-08-03','','2022-08-03 15:14:24','600','600',2022,'600','2022-08-03 15:14:24',5),('5','107',18608,'701',26849.19,1000.00,'2022-08-01','','2022-08-03 15:14:43','600','600',2022,'600','2022-08-03 15:14:43',5),('5','107',18609,'702',10568.96,1179.00,'2022-08-01','','2022-08-03 15:15:22','600','600',2022,'600','2022-08-03 15:15:22',5),('5','107',18610,'703',28072.77,1666.00,'2022-08-01','','2022-08-03 15:15:59','600','600',2022,'600','2022-08-03 15:15:59',5),('5','107',18611,'704',24841.99,1000.00,'2022-08-01','','2022-08-03 15:16:19','600','600',2022,'600','2022-08-03 15:16:19',5),('5','107',18612,'705',42606.82,4248.00,'2022-08-01','','2022-08-03 15:16:46','600','600',2022,'600','2022-08-03 15:16:46',5),('5','107',18613,'706',67513.50,61412.00,'2022-08-01','','2022-08-03 15:17:42','600','600',2022,'600','2022-08-03 15:17:42',5),('5','107',18614,'708',234.69,227.00,'2022-08-01','','2022-08-03 15:18:10','600','600',2022,'600','2022-08-03 15:18:10',5),('5','107',18615,'703',11182.99,13000.00,'2022-08-05','','2022-08-05 11:06:17','600','600',2022,'600','2022-08-05 11:06:17',5),('5','107',18616,'706',27283.13,47000.00,'2022-12-14','','2022-12-14 12:25:24','600','600',2022,'600','2022-12-14 12:25:24',5),('5','107',18617,'706',47000.00,53000.00,'2022-12-14','','2022-12-14 12:37:29','600','600',2022,'600','2022-12-14 12:37:29',5),('5','107',18618,'703',3200.47,20000.00,'2022-12-15','','2022-12-15 12:09:52','600','600',2022,'600','2022-12-15 12:09:52',5),('5','107',18619,'701',3403.07,20000.00,'2022-12-15','','2022-12-15 13:36:36','600','600',2022,'600','2022-12-15 13:36:36',5),('5','107',18620,'701',9180.98,30000.00,'2022-12-16','','2022-12-16 16:11:31','600','600',2022,'600','2022-12-16 16:11:31',5),('5','107',18621,'708',141.64,2000.00,'2022-12-16','','2022-12-16 16:15:11','600','600',2022,'600','2022-12-16 16:15:11',5),('5','107',18622,'708',2000.00,5000.00,'2022-12-16','','2022-12-16 16:31:28','600','600',2022,'600','2022-12-16 16:31:28',5),('5','107',18623,'708',1938.63,30000.00,'2022-12-17','','2022-12-17 12:01:42','600','600',2022,'600','2022-12-17 12:01:42',5),('5','107',18624,'706',15455.41,70000.00,'2022-12-18','','2022-12-18 17:44:04','600','600',2022,'600','2022-12-18 17:44:04',5),('5','107',18625,'696',27404.62,9500.00,'2022-12-20','','2022-12-20 10:39:23','600','600',2022,'600','2022-12-20 10:39:23',5),('5','107',18626,'697',43415.00,3297.00,'2022-12-20','','2022-12-20 10:40:44','600','600',2022,'600','2022-12-20 10:40:44',5),('5','107',18627,'698',1092.00,1022.00,'2022-12-20','','2022-12-20 10:41:20','600','600',2022,'600','2022-12-20 10:41:20',5),('5','107',18628,'699',30392.16,31651.00,'2022-12-20','','2022-12-20 10:42:44','600','600',2022,'600','2022-12-20 10:42:44',5),('5','107',18629,'700',19978.12,2569.00,'2022-12-20','','2022-12-20 10:44:02','600','600',2022,'600','2022-12-20 10:44:02',5),('5','107',18630,'701',43651.91,15875.00,'2022-12-20','','2022-12-20 10:44:30','600','600',2022,'600','2022-12-20 10:44:30',5),('5','107',18631,'702',27688.99,46200.00,'2022-12-20','','2022-12-20 10:44:57','600','600',2022,'600','2022-12-20 10:44:57',5),('5','107',18632,'703',36942.00,30751.00,'2022-12-20','','2022-12-20 10:45:19','600','600',2022,'600','2022-12-20 10:45:19',5),('5','107',18633,'704',19936.28,1059.00,'2022-12-20','','2022-12-20 10:45:43','600','600',2022,'600','2022-12-20 10:45:43',5),('5','107',18634,'705',9411.41,976.00,'2022-12-20','','2022-12-20 10:46:01','600','600',2022,'600','2022-12-20 10:46:01',5),('5','107',18635,'706',143445.55,75847.00,'2022-12-20','','2022-12-20 10:46:39','600','600',2022,'600','2022-12-20 10:46:39',5),('5','107',18636,'708',40728.36,40500.00,'2022-12-20','','2022-12-20 10:47:33','600','600',2022,'600','2022-12-20 10:47:33',5),('5','107',18637,'696',1363.94,599.00,'2023-01-19','','2023-01-19 16:11:18','600','600',2023,'600','2023-01-19 16:11:18',5),('5','107',18638,'697',3297.00,3297.00,'2023-01-19','','2023-01-19 16:11:49','600','600',2023,'600','2023-01-19 16:11:49',5),('5','107',18639,'698',1022.00,1000.00,'2023-01-19','','2023-01-19 16:12:32','600','600',2023,'600','2023-01-19 16:12:32',5),('5','107',18640,'699',14490.46,805.00,'2023-01-19','','2023-01-19 16:12:55','600','600',2023,'600','2023-01-19 16:12:55',5),('5','107',18641,'701',1719.65,935.00,'2023-01-19','','2023-01-19 16:13:23','600','600',2023,'600','2023-01-19 16:13:23',5),('5','107',18642,'702',27289.41,1852.00,'2023-01-19','','2023-01-19 16:13:45','600','600',2023,'600','2023-01-19 16:13:45',5),('5','107',18643,'703',4588.45,1109.00,'2023-01-19','','2023-01-19 16:14:11','600','600',2023,'600','2023-01-19 16:14:11',5),('5','107',18644,'704',1059.00,988.00,'2023-01-19','','2023-01-19 16:14:46','600','600',2023,'600','2023-01-19 16:14:46',5),('5','107',18645,'705',976.00,881.00,'2023-01-19','','2023-01-19 16:15:09','600','600',2023,'600','2023-01-19 16:15:09',5),('5','107',18646,'706',100807.41,23640.00,'2023-01-19','','2023-01-19 16:15:41','600','600',2023,'600','2023-01-19 16:15:41',5),('5','107',18647,'708',24216.50,23640.00,'2023-01-19','','2023-01-19 16:16:53','600','600',2023,'600','2023-01-19 16:16:53',5),('5','107',18648,'706',23640.00,96189.00,'2023-01-19','','2023-01-19 16:17:30','600','600',2023,'600','2023-01-19 16:17:30',5),('5','107',18649,'699',8753.49,13000.00,'2023-01-24','','2023-01-24 13:41:07','600','600',2023,'600','2023-01-24 13:41:07',5),('5','107',18650,'699',14005.94,9700.00,'2023-01-27','','2023-01-27 13:43:04','600','600',2023,'600','2023-01-27 13:43:04',5),('5','107',18651,'699',200.25,9000.00,'2023-01-28','','2023-01-28 14:58:06','600','600',2023,'600','2023-01-28 14:58:06',5),('5','107',18652,'699',717.36,2854.00,'2023-01-28','','2023-01-28 15:37:30','600','600',2023,'600','2023-01-28 15:37:30',5),('5','107',18653,'700',2569.00,805.00,'2023-01-28','','2023-01-28 15:38:09','600','600',2023,'600','2023-01-28 15:38:09',5),('5','107',18654,'702',1823.55,1241.00,'2023-01-28','','2023-01-28 15:39:01','600','600',2023,'600','2023-01-28 15:39:01',5),('5','107',18655,'703',4603.83,8050.00,'2023-01-28','','2023-01-28 15:40:00','600','600',2023,'600','2023-01-28 15:40:00',5),('5','107',18656,'707',0.00,23500.00,'2023-01-28','','2023-01-28 15:42:35','600','600',2023,'600','2023-01-28 15:42:35',5),('5','107',18657,'708',474.37,4000.00,'2023-02-08','','2023-02-08 13:40:59','600','600',2023,'600','2023-02-08 13:40:59',5),('5','107',18658,'702',27531.80,29000.00,'2023-03-05','','2023-03-05 14:42:26','600','600',2023,'600','2023-03-05 14:42:26',5),('5','107',18659,'702',12789.37,14500.00,'2023-03-08','','2023-03-08 16:26:27','600','600',2023,'600','2023-03-08 16:26:27',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3037 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('5','107','696',1875,'5','PMS PUMP 13',1487.02,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 08:55:59','600'),('5','107','696',1876,'5','PMS PUMP 14',1410.98,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 08:56:54','600'),('5','107','696',1877,'5','PMS PUMP 15',1267879.59,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 08:57:43','600'),('5','107','696',1878,'5','PMS PUMP 16',944100.29,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 08:58:27','600'),('5','107','696',1879,'5','PMS PUMP 17',1141231.35,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 08:59:38','600'),('5','107','696',1880,'5','PMS PUMP 18',438205.82,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 09:00:31','600'),('5','107','697',1881,'5','PMS PUMP 9',1226419.89,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 09:01:34','600'),('5','107','697',1882,'5','PMS PUMP 10',1300204.66,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 09:02:22','600'),('5','107','697',1883,'5','PMS PUMP 11',799799.29,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 09:05:08','600'),('5','107','697',1884,'5','PMS PUMP 12',173765.57,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 09:04:19','600'),('5','107','697',1885,'5','PMS PUMP 5',1119.90,'PMS DESPENSER',NULL,NULL,NULL,NULL,5,'2019-10-04 10:27:00','450'),('5','107','697',1886,'5','PMS PUMP 6',2416425.34,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 09:07:06','600'),('5','107','697',1887,'5','PMS PUMP 7',206189.38,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 09:08:00','600'),('5','107','697',1888,'5','PMS PUMP 8',304585.47,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 09:09:15','600'),('5','107','696',1889,'5','PMS PUMP 1',3642372.68,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 09:10:09','600'),('5','107','696',1890,'5','PMS PUMP 2',682755.56,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 09:10:53','600'),('5','107','696',1891,'5','PMS PUMP 3',1089.49,'PMS DESPENSER',NULL,NULL,NULL,NULL,5,'2019-10-04 10:24:07','450'),('5','107','696',1892,'5','PMS PUMP 4',1110.50,'PMS DESPENSER',NULL,NULL,NULL,NULL,5,'2019-10-04 10:25:38','450'),('5','107','698',1893,'5','PMS PUMP 31',1081.79,'PMS DESPENSER',NULL,NULL,NULL,NULL,5,'2019-10-15 10:48:58','450'),('5','107','698',1894,'5','PMS PUMP 32',1188.03,'PMS DESPENSER',NULL,NULL,NULL,NULL,5,'2019-10-15 10:49:41','450'),('5','107','698',1895,'5','PMS PUMP 33',688388.49,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 09:12:19','600'),('5','107','698',1896,'5','PMS PUMP 34',268599.90,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 09:13:07','600'),('5','107','698',1897,'5','PMS PUMP 35',416979.10,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 09:13:54','600'),('5','107','698',1898,'5','PMS PUMP 36',65942.00,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 09:15:03','600'),('5','107','699',1899,'5','PMS PUMP 27',2468386.01,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 09:17:04','600'),('5','107','699',1900,'5','PMS PUMP 28',1063274.66,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 09:18:16','600'),('5','107','699',1901,'5','PMS PUMP 29',2583046.13,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 09:19:15','600'),('5','107','699',1902,'5','PMS PUMP 30',1303755.79,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 09:21:00','600'),('5','107','700',1903,'5','PMS PUMP 23',1921657.11,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 09:21:51','600'),('5','107','700',1904,'5','PMS PUMP 24',1131083.01,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 09:22:51','600'),('5','107','700',1905,'5','PMS PUMP 25',2176877.24,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 09:23:44','600'),('5','107','700',1906,'5','PMS PUMP 26',765377.62,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 09:24:29','600'),('5','107','701',1907,'5','PMS PUMP 19',2111873.01,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 09:25:26','600'),('5','107','701',1908,'5','PMS PUMP 20',1088560.30,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 09:26:41','600'),('5','107','701',1909,'5','PMS PUMP 21',827573.12,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 09:27:36','600'),('5','107','701',1910,'5','PMS PUMP 22',1438725.13,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 09:28:27','600'),('5','107','702',1911,'5','PMS PUMP 49',1846272.96,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 09:29:36','600'),('5','107','702',1912,'5','PMS PUMP 50',1501909.09,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 09:30:24','600'),('5','107','702',1913,'5','PMS PUMP 51',1593314.48,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 09:31:17','600'),('5','107','702',1914,'5','PMS PUMP 52',435519.28,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 09:32:25','600'),('5','107','702',1915,'5','PMS PUMP 53',1641575.14,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 09:33:21','600'),('5','107','702',1916,'5','PMS PUMP 54',22810.70,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 09:34:18','600'),('5','107','703',1917,'5','PMS PUMP 45',1080682.74,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 09:35:32','600'),('5','107','703',1918,'5','PMS PUMP 46',1364290.58,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 09:36:24','600'),('5','107','703',1919,'5','PMS PUMP 47',903787.33,'PMS DESPENSER','',NULL,NULL,'',5,'2022-12-13 11:13:07','600'),('5','107','703',1920,'5','PMS PUMP 48',716368.24,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 09:38:15','600'),('5','107','704',1921,'5','PMS PUMP 41',1127092.46,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 09:39:05','600'),('5','107','704',1922,'5','PMS PUMP 42',205943.51,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 09:39:58','600'),('5','107','704',1923,'5','PMS PUMP 43',1271791.45,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 09:40:51','600'),('5','107','704',1924,'5','PMS PUMP 44',231195.68,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 09:41:50','600'),('5','107','705',1925,'5','PMS PUMP 37',2345768.99,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 09:43:47','600'),('5','107','705',1926,'5','PMS PUMP 38',45087.24,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 09:44:36','600'),('5','107','705',1927,'5','PMS PUMP 39',590155.88,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 09:45:17','600'),('5','107','705',1928,'5','PMS PUMP 40',637098.26,'PMS DESPENSER','',NULL,NULL,'',5,'2021-08-05 09:46:03','600'),('5','107','706',1929,'5','AGO PUMP 55',3116168.51,'AGO DESPENSER','',NULL,NULL,'',5,'2022-01-13 16:16:28','600'),('5','107','706',1930,'5','AGO PUMP 56',2840747.38,'AGO DESPENSER','',NULL,NULL,'',5,'2022-01-13 16:17:03','600'),('5','107','706',1931,'5','AGO PUMP 57',2223604.21,'AGO DESPENSER','',NULL,NULL,'',5,'2022-01-13 16:18:19','600'),('5','107','706',1932,'5','AGO PUMP 58',2085260.40,'AGO DESPENSER','',NULL,NULL,'',5,'2022-01-13 16:19:27','600'),('5','107','706',1933,'5','DPK PUMP 61',2065827.97,'DPK DESPENSER','',NULL,NULL,'',5,'2022-01-13 16:20:07','600'),('5','107','708',1934,'5','DPK PUMP 60',3203952.86,'DPK DESPENSER','',NULL,NULL,'',5,'2022-12-13 11:11:14','600'),('5','107','706',2898,'5','AGO PUMP 62',1597698.27,'AGO DISPENSE PUMP','',NULL,NULL,'',5,'2022-01-13 16:20:49','600'),('5','107','708',2899,'5','DPK PUMP 59',3339081.51,'AGO DISPENSE PUMP','',NULL,NULL,'',5,'2021-08-05 14:07:23','600'),('5','107','706',3035,'5','PUMP 63',1863209.36,'AGO DISPENSER','',NULL,NULL,'',5,'2021-11-25 08:21:54','600'),('5','107','706',3036,'5','PUMP 64',1999622.83,'AGO DISPENSER','',NULL,NULL,'',5,'2021-11-25 08:21:15','600');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=263 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
INSERT INTO `depots_nozzles_tanks` VALUES (241,'5','107','1875','696','PMS TANKS CONNECTION CORRECTION.','2021-08-05 13:44:01',0,'600'),(242,'5','107','1876','696','PMS TANKS CONNECTION CORRECTION.','2021-08-05 13:44:47',0,'600'),(243,'5','107','1877','696','PMS TANKS CONNECTION CORRECTION.','2021-08-05 13:45:13',0,'600'),(244,'5','107','1878','696','PMS TANKS CONNECTION CORRECTION.','2021-08-05 13:45:37',0,'600'),(245,'5','107','1879','696','PMS TANKS CONNECTION CORRECTION.','2021-08-05 13:46:13',0,'600'),(246,'5','107','1880','696','PMS TANKS CONNECTION CORRECTION.','2021-08-05 13:46:37',0,'600'),(247,'5','107','1881','697','PMS TANKS CONNECTION CORRECTION.','2021-08-05 13:47:21',0,'600'),(248,'5','107','1882','697','PMS TANKS CONNECTION CORRECTION.','2021-08-05 13:47:46',0,'600'),(249,'5','107','1883','697','PMS TANKS CONNECTION CORRECTION.','2021-08-05 13:48:17',0,'600'),(250,'5','107','1884','697','PMS TANKS CONNECTION CORRECTION.','2021-08-05 13:49:21',0,'600'),(251,'5','107','1885','697','PMS TANKS CONNECTION CORRECTION.','2021-08-05 13:52:21',0,'600'),(252,'5','107','1886','697','PMS TANKS CONNECTION CORRECTION.','2021-08-05 13:52:48',0,'600'),(253,'5','107','1887','697','PMS TANKS CONNECTION CORRECTION.','2021-08-05 13:53:17',0,'600'),(254,'5','107','1888','697','PMS TANKS CONNECTION CORRECTION.','2021-08-05 13:53:47',0,'600'),(255,'5','107','1889','696','PMS TANKS CONNECTION CORRECTION.','2021-08-05 13:54:41',0,'600'),(256,'5','107','1890','696','PMS TANKS CONNECTION CORRECTION.','2021-08-05 13:55:23',0,'600'),(257,'5','107','1891','696','PMS TANKS CONNECTION CORRECTION.','2021-08-05 13:55:54',0,'600'),(258,'5','107','1892','696','PMS TANKS CONNECTION CORRECTION.','2021-08-05 13:56:22',0,'600'),(259,'5','107','1931','706','AGO TANKS CONNECTION CORRECTION.','2021-08-05 14:01:56',0,'600'),(260,'5','107','1932','706','AGO TANKS CONNECTION CORRECTION.','2021-08-05 14:02:38',0,'600'),(261,'5','107','1933','706','AGO TANKS CONNECTION CORRECTION.','2021-08-05 14:03:17',0,'600'),(262,'5','107','2898','706','AGO TANKS CONNECTION CORRECTION.','2021-08-05 14:04:06',0,'600');
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
INSERT INTO `depots_pumps` VALUES ('5','107',6,'SALBAS','SALBAS','AGO PUMP 62','','','','600','2021-08-05 09:56:27','2021-08-05 09:56:27','600',5);
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=257839 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('5','107',216677,'DAILY','2021-08-01','2021-08-01 00:00:00',NULL,'447',15156123.10,15156123.10,'447','2021-08-11 13:55:33','600','2021-08-11 14:04:11',10,0),('5','107',216698,'DAILY','2021-08-02','2021-08-02 00:00:00',NULL,'447',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','107',216722,'DAILY','2021-08-02','2021-08-02 00:00:00',NULL,'600',20196912.30,20196912.30,'447','2021-08-12 15:11:08','600','2021-08-12 15:12:47',10,0),('5','107',216954,'DAILY','2021-08-03','2021-08-03 00:00:00',NULL,'447',16355054.00,16355054.00,'447','2021-08-13 09:48:40','600','2021-08-13 10:10:56',10,0),('5','107',217103,'DAILY','2021-08-04','2021-08-04 00:00:00',NULL,'447',19028134.25,19028134.25,'447','2021-08-13 10:34:17','600','2021-08-13 10:41:33',10,0),('5','107',217116,'DAILY','2021-08-05','2021-08-05 00:00:00',NULL,'447',12345952.55,12345952.55,'447','2021-08-13 11:09:47','600','2021-08-13 11:15:22',10,0),('5','107',217135,'DAILY','2021-08-06','2021-08-06 00:00:00',NULL,'447',22184720.30,22184720.30,'447','2021-08-13 11:43:30','600','2021-08-13 12:24:57',10,0),('5','107',217156,'DAILY','2021-08-07','2021-08-07 00:00:00',NULL,'447',19806355.15,19806355.15,'447','2021-08-13 12:50:56','600','2021-08-13 13:20:01',10,0),('5','107',217183,'DAILY','2021-08-08','2021-08-08 00:00:00',NULL,'447',14612273.85,14612273.85,'447','2021-08-13 14:25:04','600','2021-08-13 14:31:14',10,0),('5','107',217195,'DAILY','2021-08-09','2021-08-09 00:00:00',NULL,'447',15888925.90,15888925.90,'447','2021-08-13 14:57:46','600','2021-08-13 15:15:44',10,0),('5','107',217205,'DAILY','2021-08-10','2021-08-10 00:00:00',NULL,'447',16106155.65,16106155.65,'447','2021-08-13 16:32:45','600','2021-08-13 16:39:08',10,0),('5','107',217227,'DAILY','2021-08-11','2021-08-11 00:00:00',NULL,'447',17438390.65,17438390.65,'447','2021-08-13 17:12:54','600','2021-08-13 17:17:43',10,0),('5','107',217236,'DAILY','2021-08-12','2021-08-12 00:00:00',NULL,'447',14843012.30,14843012.30,'447','2021-08-13 17:47:24','600','2021-08-13 18:08:41',10,0),('5','107',217300,'DAILY','2021-07-13','2021-07-13 00:00:00',NULL,'447',13829249.50,13829249.50,'447','2021-08-14 07:44:19','600','2021-08-14 07:51:22',10,0),('5','107',217685,'DAILY','2021-08-14','2021-08-14 00:00:00',NULL,'447',16644082.95,16644082.95,'447','2021-08-16 10:24:55','600','2021-08-16 10:31:30',10,0),('5','107',217820,'DAILY','2021-08-15','2021-08-15 00:00:00',NULL,'447',14219404.30,14219404.30,'447','2021-08-16 15:38:30','600','2021-08-16 15:45:57',10,0),('5','107',217918,'DAILY','2021-08-16','2021-08-16 00:00:00',NULL,'447',13879367.10,13879367.10,'447','2021-08-18 10:11:42','600','2021-08-18 10:20:33',10,0),('5','107',218311,'DAILY','2021-08-17','2021-08-17 00:00:00',NULL,'447',15201357.30,15201357.30,'447','2021-08-18 10:49:51','600','2021-08-18 10:55:46',10,0),('5','107',218491,'DAILY','2021-08-18','2021-08-18 00:00:00',NULL,'447',15445123.95,15445123.95,'447','2021-08-19 08:45:56','600','2021-08-19 08:49:42',10,0),('5','107',218499,'DAILY','2021-08-19','2021-08-19 00:00:00',NULL,'447',16506597.75,16506597.75,'447','2021-08-20 08:04:04','600','2021-08-20 09:23:08',10,0),('5','107',218746,'DAILY','2021-08-20','2021-08-20 00:00:00',NULL,'447',15221381.45,15221381.45,'447','2021-08-21 18:28:47','604','2021-08-21 21:52:24',10,0),('5','107',219209,'DAILY','2021-08-21','2021-08-21 00:00:00',NULL,'447',18904041.35,18904041.35,'447','2021-08-23 14:30:58','604','2021-08-24 09:43:21',10,0),('5','107',219677,'DAILY','2021-08-22','2021-08-22 00:00:00',NULL,'447',14648979.80,14648979.80,'447','2021-08-24 10:16:16','604','2021-08-24 11:25:20',10,0),('5','107',219697,'DAILY','2021-08-23','2021-08-23 00:00:00',NULL,'447',15617032.70,15617032.70,'447','2021-08-24 11:54:21','604','2021-08-24 13:01:04',10,0),('5','107',219846,'DAILY','2021-07-24','2021-07-24 00:00:00',NULL,'447',14673674.05,14673674.05,'447','2021-08-25 08:25:08','604','2021-08-25 08:35:38',10,0),('5','107',219862,'DAILY','2021-08-25','2021-08-25 00:00:00',NULL,'447',16491055.15,16491055.15,'447','2021-08-26 08:11:48','604','2021-08-26 09:43:32',10,0),('5','107',220272,'DAILY','2020-08-08','2020-08-08 00:00:00',NULL,'447',16149736.20,16149736.20,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','107',220406,'DAILY','2021-08-26','2021-08-26 00:00:00',NULL,'447',16149736.20,16149736.20,'447','2021-08-27 15:36:19','604','2021-08-27 15:41:33',10,0),('5','107',220414,'DAILY','2021-08-27','2021-08-27 00:00:00',NULL,'447',14785672.70,14785672.70,'447','2021-08-28 08:19:17','604','2021-08-29 14:31:58',10,0),('5','107',220819,'DAILY','2021-08-28','2021-08-28 00:00:00',NULL,'447',14786048.50,14786048.50,'447','2021-08-29 14:58:53','604','2021-08-29 16:14:01',10,0),('5','107',220974,'DAILY','2021-08-29','2021-08-29 00:00:00',NULL,'447',13304537.35,13304537.35,'447','2021-08-30 09:26:25','604','2021-08-30 09:55:42',10,0),('5','107',221008,'DAILY','2021-08-30','2021-08-30 00:00:00',NULL,'447',18796083.45,18796083.45,'447','2021-08-31 08:14:50','604','2021-08-31 09:33:41',10,0),('5','107',221249,'DAILY','2021-08-31','2021-08-31 00:00:00',NULL,'447',15415904.50,15415904.50,'447','2021-09-01 09:18:05','604','2021-09-01 10:47:22',10,0),('5','107',221507,'DAILY','2021-09-01','2021-09-01 00:00:00',NULL,'447',13681320.60,13681320.60,'447','2021-09-02 07:19:30','604','2021-09-02 12:20:46',10,0),('5','107',221730,'DAILY','2021-09-02','2021-09-02 00:00:00',NULL,'447',17193154.45,17193154.45,'447','2021-09-03 07:58:22','604','2021-09-03 09:10:53',10,0),('5','107',221884,'DAILY','2021-09-03','2021-09-03 00:00:00',NULL,'447',14007836.65,14007836.65,'447','2021-09-04 08:11:12','604','2021-09-04 08:53:42',10,0),('5','107',222425,'DAILY','2021-09-04','2021-09-04 00:00:00',NULL,'447',15175045.55,15175045.55,'447','2021-09-05 16:02:28','604','2021-09-05 17:47:17',10,0),('5','107',222527,'DAILY','2021-09-05','2021-09-05 00:00:00',NULL,'447',15094045.70,15094045.70,'447','2021-09-06 11:59:58','604','2021-09-06 12:03:56',10,0),('5','107',222608,'DAILY','2021-09-06','2021-09-06 00:00:00',NULL,'447',12798554.00,12798554.00,'447','2021-09-07 10:18:10','604','2021-09-07 10:21:44',10,0),('5','107',222829,'DAILY','2021-09-07','2021-09-07 00:00:00',NULL,'447',13149819.60,13149819.60,'447','2021-09-08 07:09:17','604','2021-09-08 09:55:08',10,0),('5','107',223042,'DAILY','2021-09-08','2021-09-08 00:00:00',NULL,'447',15881148.85,15881148.85,'447','2021-09-09 10:33:42','604','2021-09-09 12:04:52',10,0),('5','107',223293,'DAILY','2021-09-09','2021-09-09 00:00:00',NULL,'447',16520172.60,16520172.60,'447','2021-09-10 14:30:13','604','2021-09-10 14:35:29',10,0),('5','107',223561,'DAILY','2021-09-10','2021-09-10 00:00:00',NULL,'447',16729640.25,16729640.25,'447','2021-09-11 10:27:50','604','2021-09-11 10:45:58',10,0),('5','107',223744,'DAILY','2021-09-11','2021-09-11 00:00:00',NULL,'447',16753748.80,16753748.80,'447','2021-09-12 11:00:28','604','2021-09-12 15:36:26',10,0),('5','107',224026,'DAILY','2021-09-12','2021-09-12 00:00:00',NULL,'447',12916760.95,12916760.95,'447','2021-09-13 16:08:03','604','2021-09-14 08:12:29',10,0),('5','107',224373,'DAILY','2021-09-13','2021-09-13 00:00:00',NULL,'447',16529546.55,16529546.55,'447','2021-09-14 09:31:10','604','2021-09-14 17:34:34',10,0),('5','107',224553,'DAILY','2021-09-14','2021-09-14 00:00:00',NULL,'447',15159668.60,15159668.60,'447','2021-09-15 08:09:57','604','2021-09-15 10:28:47',10,0),('5','107',224632,'DAILY','2021-09-15','2021-09-15 00:00:00',NULL,'447',13000508.25,13000508.25,'447','2021-09-16 08:08:40','604','2021-09-16 08:41:54',10,0),('5','107',224836,'DAILY','2021-09-16','2021-09-16 00:00:00',NULL,'447',2868087.75,2868087.75,'447','2021-09-17 09:53:52','600','2021-09-17 10:06:23',10,0),('5','107',225104,'AFTERN00N','2021-09-16','2021-09-16 00:00:00',NULL,'447',14812870.93,14812870.93,'447','2021-09-17 10:35:24','600','2021-09-18 10:21:45',10,0),('5','107',225352,'DAILY','2021-09-17','2021-09-17 00:00:00',NULL,'447',14326351.93,14326351.93,'447','2021-09-18 10:56:40','600','2021-09-18 11:02:13',10,0),('5','107',225363,'DAILY','2021-09-18','2021-09-18 00:00:00',NULL,'447',15565474.85,15565474.85,'447','2021-09-19 08:39:28','604','2021-09-19 18:47:42',10,0),('5','107',225909,'DAILY','2021-09-19','2021-09-19 00:00:00',NULL,'447',13779017.33,13779017.33,'447','2021-09-20 16:00:55','600','2021-09-21 09:07:15',10,0),('5','107',226039,'DAILY','2021-09-20','2021-09-20 00:00:00',NULL,'447',17103699.88,17103699.88,'447','2021-09-21 10:25:22','600','2021-09-21 10:33:41',10,0),('5','107',226080,'DAILY','2021-09-21','2021-09-21 00:00:00',NULL,'447',16639507.58,16639507.58,'447','2021-09-22 10:08:50','604','2021-09-23 06:42:10',10,0),('5','107',226502,'DAILY','2021-09-22','2021-09-22 00:00:00',NULL,'447',14353553.23,14353553.23,'447','2021-09-23 07:57:23','604','2021-09-24 08:17:48',10,0),('5','107',226797,'DAILY','2021-09-23','2021-09-23 00:00:00',NULL,'447',14394110.00,14394110.00,'447','2021-09-24 09:19:13','600','2021-09-24 09:22:35',10,0),('5','107',226808,'DAILY','2021-09-24','2021-09-24 00:00:00',NULL,'447',14042379.68,14042379.68,'447','2021-09-25 08:15:41','604','2021-09-25 09:30:24',10,0),('5','107',227140,'DAILY','2021-09-25','2021-09-25 00:00:00',NULL,'447',19501060.47,19501060.47,'447','2021-09-26 10:02:23','604','2021-09-26 11:08:52',10,0),('5','107',227333,'DAILY','2021-09-26','2021-09-26 00:00:00',NULL,'447',15075550.74,15075550.74,'447','2021-09-27 08:27:38','604','2021-09-27 16:51:11',10,0),('5','107',227637,'DAILY','2021-08-27','2021-08-27 00:00:00',NULL,'447',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','107',227663,'DAILY','2021-08-27','2021-08-27 00:00:00',NULL,'447',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','107',227665,'Daily','2021-09-27','2021-09-27 00:00:00',NULL,'600',15920451.06,15920451.06,'447','2021-09-28 10:01:25','604','2021-09-29 09:33:22',10,0),('5','107',227982,'Daily','2021-09-29','2021-09-29 00:00:00',NULL,'600',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','107',227986,'Daily','2021-09-28','2021-09-28 00:00:00',NULL,'600',16347615.90,16347615.90,'447','2021-09-29 13:26:13','604','2021-09-29 16:13:03',10,0),('5','107',228071,'DAILY','2021-09-29','2021-09-29 00:00:00',NULL,'447',14911483.80,14911483.80,'447','2021-10-05 13:51:16','600','2021-10-05 13:59:33',10,0),('5','107',229320,'DAILY','2021-09-30','2021-09-30 00:00:00',NULL,'447',19387175.11,19387175.11,'447','2021-10-07 14:14:36','604','2021-10-07 14:18:33',10,0),('5','107',229801,'DAILY','2021-10-01','2021-10-01 00:00:00',NULL,'447',15156167.25,15156167.25,'447','2021-10-07 14:42:31','604','2021-10-07 15:02:38',10,0),('5','107',229812,'DAILY','2021-10-02','2021-10-02 00:00:00',NULL,'447',18169414.08,18169414.08,'447','2021-10-07 15:35:39','604','2021-10-07 15:54:18',10,0),('5','107',229828,'DAILY','2021-10-03','2021-10-03 00:00:00',NULL,'447',17451783.07,17451783.07,'447','2021-10-07 16:39:17','600','2021-10-07 16:42:21',10,0),('5','107',229832,'DAILY','2021-10-04','2021-10-04 00:00:00',NULL,'447',19252036.44,19252036.44,'447','2021-10-07 17:04:31','600','2021-10-07 17:07:56',10,0),('5','107',229836,'DAILY','2021-10-05','2021-10-05 00:00:00',NULL,'447',2602233.00,2518290.00,'447','2021-10-07 17:15:31','600','2021-10-07 17:19:35',10,0),('5','107',229840,'DAILY','2021-10-05','2021-10-05 00:00:00',NULL,'447',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','107',229845,'DAILY','2021-10-05','2021-10-05 00:00:00',NULL,'447',17438287.31,17438287.31,'447','2021-10-07 18:22:18','600','2021-10-07 18:36:44',10,0),('5','107',230036,'DAILY','2021-10-06','2021-10-06 00:00:00',NULL,'447',19527601.09,19527601.09,'447','2021-10-08 16:56:54','600','2021-10-08 17:09:29',10,0),('5','107',230040,'DAILY','2021-10-07','2021-10-07 00:00:00',NULL,'447',20620093.92,20620093.92,'447','2021-10-08 17:52:15','604','2021-10-09 18:17:17',10,0),('5','107',230250,'DAILY','2021-09-08','2021-09-08 00:00:00',NULL,'447',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','107',230254,'DAILY','2021-10-08','2021-10-08 00:00:00',NULL,'600',18917852.31,18917852.31,'447','2021-10-09 19:24:37','600','2021-10-09 19:26:57',10,0),('5','107',230258,'DAILY','2021-10-09','2021-10-09 00:00:00',NULL,'447',19593606.92,19593606.92,'447','2021-10-10 17:58:30','604','2021-10-11 08:55:50',10,0),('5','107',230690,'DAILY','2021-10-10','2021-10-10 00:00:00',NULL,'447',22049731.70,22049731.70,'447','2021-10-11 15:12:21','604','2021-10-12 10:01:44',10,0),('5','107',230910,'DAILY','2021-10-11','2021-10-11 00:00:00',NULL,'447',21607107.76,21169975.26,'447','2021-10-12 12:23:10','604','2021-10-13 03:00:24',10,0),('5','107',231083,'DAILY','2021-10-12','2021-10-12 00:00:00',NULL,'447',19716215.64,19333866.04,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','107',231532,'DAILY','2021-10-12','2021-10-12 00:00:00',NULL,'447',19716196.08,19716196.08,'447','2021-10-14 14:12:53','604','2021-10-14 14:14:39',10,0),('5','107',231543,'DAILY','2021-10-13','2021-10-13 00:00:00',NULL,'447',18850794.37,18850794.37,'447','2021-10-14 14:35:35','604','2021-10-14 15:52:55',10,0),('5','107',231761,'DAILY','2021-10-14','2021-10-14 00:00:00',NULL,'447',23296335.96,23296335.96,'447','2021-10-15 15:55:09','604','2021-10-16 15:45:31',10,0),('5','107',232037,'DAILY','2021-10-15','2021-10-15 00:00:00',NULL,'447',19342257.92,19342257.92,'447','2021-10-16 16:33:00','600','2021-10-17 16:10:03',10,0),('5','107',232276,'DAILY','2021-10-16','2021-10-16 00:00:00',NULL,'447',22513383.62,22753118.87,'447','2021-10-17 17:57:06','604','2021-10-18 08:44:34',10,0),('5','107',232519,'DAILY','2021-10-17','2021-10-17 00:00:00',NULL,'447',18301677.96,18301677.96,'447','2021-10-18 16:15:49','604','2021-10-19 01:34:26',10,0),('5','107',232631,'DAILY','2021-10-18','2021-10-18 00:00:00',NULL,'447',20337444.96,20337444.96,'447','2021-10-19 19:37:59','604','2021-10-20 07:17:34',10,0),('5','107',232875,'DAILY','2021-10-19','2021-10-19 00:00:00',NULL,'447',24603426.20,24603426.20,'447','2021-10-20 07:35:31','604','2021-10-20 08:34:51',10,0),('5','107',233048,'DAILY','2021-10-20','2021-10-20 00:00:00',NULL,'447',2570462.40,2570462.40,'447','2021-10-20 16:10:47','600','2021-10-20 16:12:47',10,0),('5','107',233055,'DAILY','2021-10-20','2021-10-20 00:00:00',NULL,'447',17275986.39,17275986.39,'447','2021-10-21 07:39:59','604','2021-10-21 09:50:32',10,0),('5','107',233278,'DAILY','2021-10-21','2021-10-21 00:00:00',NULL,'447',20699162.24,20699162.24,'447','2021-10-22 10:25:00','604','2021-10-22 11:26:47',10,0),('5','107',233546,'DAILY','2021-10-22','2021-10-22 00:00:00',NULL,'447',25924239.45,25924239.45,'447','2021-10-23 08:55:13','600','2021-10-24 09:35:37',10,0),('5','107',233899,'DAILY','2021-10-23','2021-10-23 00:00:00',NULL,'447',23541159.94,23541159.94,'447','2021-10-25 07:24:49','600','2021-10-25 07:25:59',10,0),('5','107',234086,'DAILY','2021-10-24','2021-10-24 00:00:00',NULL,'447',20403680.37,20403680.37,'447','2021-10-25 07:41:21','600','2021-10-26 11:29:03',10,0),('5','107',234427,'DAILY','2021-10-25','2021-10-25 00:00:00',NULL,'447',22485851.22,22485851.22,'447','2021-10-26 11:51:07','604','2021-10-26 16:43:20',10,0),('5','107',234525,'DAILY','2021-10-26','2021-10-26 00:00:00',NULL,'447',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','107',234612,'DAILY','2021-10-26','2021-10-26 00:00:00',NULL,'447',22277062.05,22277062.05,'447','2021-10-27 18:59:40','600','2021-10-27 19:02:16',10,0),('5','107',234775,'DAILY','2021-10-27','2021-10-27 00:00:00',NULL,'447',20239817.10,20239817.10,'600','2021-10-29 08:45:34','604','2021-10-29 08:48:18',10,0),('5','107',235154,'DAILY','2021-10-28','2021-10-28 00:00:00',NULL,'447',24200888.25,24200888.25,'447','2021-10-29 09:59:23','600','2021-10-30 09:16:58',10,0),('5','107',235377,'DAILY','2021-10-29','2021-10-29 00:00:00',NULL,'447',28373059.80,28373059.80,'447','2021-10-30 10:01:18','604','2021-10-31 08:42:53',10,0),('5','107',235671,'DAILY','2021-10-30','2021-10-30 00:00:00',NULL,'447',27009868.65,27009868.65,'447','2021-11-01 16:16:21','600','2021-11-01 16:28:54',10,0),('5','107',235953,'DAILY','2021-10-31','2021-10-31 00:00:00',NULL,'447',26444754.60,26444754.60,'447','2021-11-02 11:33:56','600','2021-11-02 11:36:44',10,0),('5','107',236125,'DAILY','2021-11-01','2021-11-01 00:00:00',NULL,'447',25828346.85,25828346.85,'447','2021-11-02 14:24:29','604','2021-11-02 15:26:13',10,0),('5','107',236428,'DAILY','2021-11-02','2021-11-02 00:00:00',NULL,'447',29431534.05,29431534.05,'447','2021-11-03 16:34:18','600','2021-11-03 16:38:33',10,0),('5','107',236435,'DAILY','2021-11-03','2021-11-03 00:00:00',NULL,'447',23805480.60,23805480.60,'447','2021-11-04 14:22:24','600','2021-11-04 20:52:05',10,0),('5','107',236781,'DAILY','2021-11-04','2021-11-04 00:00:00',NULL,'447',26723023.50,26723023.50,'447','2021-11-05 13:25:31','604','2021-11-06 02:38:52',10,0),('5','107',237118,'DAILY','2021-11-05','2021-11-05 00:00:00',NULL,'447',28266339.30,28266339.30,'447','2021-11-07 16:16:37','600','2021-11-07 16:17:41',10,0),('5','107',237320,'DAILY','2021-11-06','2021-11-06 00:00:00',NULL,'447',32532617.40,32532617.40,'447','2021-11-07 16:44:46','600','2021-11-07 16:51:51',10,0),('5','107',237538,'DAILY','2021-11-07','2021-11-07 00:00:00',NULL,'447',18161429.10,18161429.10,'447','2021-11-08 16:38:29','604','2021-11-09 08:41:07',10,0),('5','107',237775,'DAILY','2021-11-08','2021-11-08 00:00:00',NULL,'447',27635202.30,27635202.30,'447','2021-11-09 15:49:51','604','2021-11-10 04:51:25',10,0),('5','107',237945,'DAILY','2021-11-09','2021-11-09 00:00:00',NULL,'447',22646954.25,22646954.25,'447','2021-11-11 09:19:09','600','2021-11-11 11:05:23',10,0),('5','107',238279,'DAILY','2020-11-10','2020-11-10 00:00:00',NULL,'447',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','107',238295,'DAILY','2021-11-10','2021-11-10 00:00:00',NULL,'600',24974492.70,24974492.70,'447','2021-11-11 17:53:16','600','2021-11-12 08:23:07',10,0),('5','107',238492,'DAILY','2021-11-11','2021-11-11 00:00:00',NULL,'447',29685810.30,29685810.30,'447','2021-11-12 13:23:55','600','2021-11-12 15:43:31',10,0),('5','107',238669,'DAILY','2021-11-12','2021-11-12 00:00:00',NULL,'447',26048488.20,26048488.20,'447','2021-11-14 11:03:52','600','2021-11-14 11:06:58',10,0),('5','107',238917,'DAILY','2021-11-13','2021-11-13 00:00:00',NULL,'447',27882058.50,27882058.50,'447','2021-11-14 11:48:07','604','2021-11-14 14:58:36',10,0),('5','107',239013,'DAILY','2021-11-14','2021-11-14 00:00:00',NULL,'447',25790698.50,25790698.50,'447','2021-11-15 15:12:23','604','2021-11-16 07:26:19',10,0),('5','107',239391,'DAILY','2021-11-15','2021-11-15 00:00:00',NULL,'447',30610076.85,30610076.85,'447','2021-11-16 12:33:29','604','2021-11-17 09:49:23',10,0),('5','107',239695,'DAILY','2021-11-16','2021-11-16 00:00:00',NULL,'447',27379074.60,27379074.60,'447','2021-11-17 16:31:17','600','2021-11-18 18:05:50',10,0),('5','107',239942,'DAILY','2021-11-17','2021-11-17 00:00:00',NULL,'447',29217317.85,29217317.85,'447','2021-11-18 18:58:27','604','2021-11-19 08:54:19',10,0),('5','107',240082,'DAILY','2021-11-18','2021-11-18 00:00:00',NULL,'447',33407636.40,33407636.40,'447','2021-11-20 08:14:33','600','2021-11-20 08:21:51',10,0),('5','107',240245,'DAILY','2021-11-19','2021-11-19 00:00:00',NULL,'447',30412788.60,30412788.60,'447','2021-11-20 08:44:42','604','2021-11-21 08:31:22',10,0),('5','107',240613,'DAILY','2021-11-20','2021-11-20 00:00:00',NULL,'447',28158289.95,28158289.95,'447','2021-11-21 19:15:57','604','2021-11-22 09:24:58',10,0),('5','107',240813,'DAILY','2021-11-21','2021-11-21 00:00:00',NULL,'447',26835603.75,26835603.75,'447','2021-11-22 13:49:58','604','2021-11-23 10:33:48',10,0),('5','107',241148,'DAILY','2021-11-22','2021-11-22 00:00:00',NULL,'447',31554731.55,31554731.55,'447','2021-11-23 16:31:33','604','2021-11-24 10:54:52',10,0),('5','107',241402,'DAILY','2021-11-23','2021-11-23 00:00:00',NULL,'447',28492495.80,28492495.80,'447','2021-11-24 16:22:43','600','2021-11-25 07:44:48',10,0),('5','107',241535,'DAILY','2021-11-24','2021-11-24 00:00:00',NULL,'447',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','107',241576,'DAILY','2021-11-24','2021-11-24 00:00:00',NULL,'447',29961064.50,29961064.50,'447','2021-11-25 11:46:50','604','2021-11-25 18:54:52',10,0),('5','107',241780,'DAILY','2021-11-25','2021-11-25 00:00:00',NULL,'447',29454848.55,29454848.55,'447','2021-11-26 07:56:58','600','2021-11-27 07:55:06',10,0),('5','107',242017,'DAILY','2021-11-26','2021-11-26 00:00:00',NULL,'447',29621275.50,29621275.50,'447','2021-11-27 08:24:40','604','2021-11-27 11:14:00',10,0),('5','107',242243,'DAILY','2021-11-27','2021-11-27 00:00:00',NULL,'447',31114599.90,31114599.90,'447','2021-11-28 08:18:02','600','2021-11-28 13:44:30',10,0),('5','107',242561,'DAILY','2021-11-29','2021-11-29 00:00:00',NULL,'447',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','107',243057,'DAILY','2021-11-28','2021-11-28 00:00:00',NULL,'447',25884451.35,25884451.35,'447','2021-12-01 15:55:58','600','2021-12-01 16:13:34',10,0),('5','107',243061,'DAILY','2021-11-29','2021-11-29 00:00:00',NULL,'447',28828158.60,28828158.60,'447','2021-12-01 16:31:25','600','2021-12-01 16:53:22',10,0),('5','107',243077,'DAILY','2021-11-30','2021-11-30 00:00:00',NULL,'447',34327936.20,34327936.20,'447','2021-12-03 08:07:40','604','2021-12-03 08:33:54',10,0),('5','107',243441,'DAILY','2021-12-01','2021-12-01 00:00:00',NULL,'447',26888742.00,26888742.00,'447','2021-12-03 09:46:59','604','2021-12-03 15:34:07',10,0),('5','107',243522,'DAILY','2021-12-02','2021-12-02 00:00:00',NULL,'447',34007263.65,34007263.65,'447','2021-12-03 16:40:23','600','2021-12-04 13:26:45',10,0),('5','107',243752,'DAILY','2021-12-03','2021-12-03 00:00:00',NULL,'447',33717637.80,33717637.80,'447','2021-12-07 10:22:53','604','2021-12-07 11:02:00',10,0),('5','107',244388,'DAILY','2021-12-04','2021-12-04 00:00:00',NULL,'447',33271293.30,33271293.30,'447','2021-12-07 11:22:10','604','2021-12-07 11:44:25',10,0),('5','107',244395,'DAILY','2021-12-05','2021-12-05 00:00:00',NULL,'447',27776288.40,27776288.40,'447','2021-12-10 08:26:42','604','2021-12-10 08:46:56',10,0),('5','107',245044,'DAILY','2021-12-06','2021-12-06 00:00:00',NULL,'447',33111126.15,33111126.15,'447','2021-12-10 09:18:08','604','2021-12-10 11:08:38',10,0),('5','107',245130,'DAILY','2021-12-07','2021-12-07 00:00:00',NULL,'447',30301456.05,30301456.05,'447','2021-12-10 15:23:30','604','2021-12-10 15:27:20',10,0),('5','107',245138,'DAILY','2021-12-08','2021-12-08 00:00:00',NULL,'447',26666173.05,26666173.05,'447','2021-12-10 19:01:57','604','2021-12-11 13:32:12',10,0),('5','107',245341,'DAILY','2021-12-09','2021-12-09 00:00:00',NULL,'447',37429560.15,37429560.15,'447','2021-12-11 14:59:20','604','2021-12-11 15:47:18',10,0),('5','107',245355,'DAILY','2021-12-10','2021-12-10 00:00:00',NULL,'447',31717649.70,31717649.70,'447','2021-12-15 15:04:35','604','2021-12-15 15:15:41',10,0),('5','107',246380,'DAILY','2021-12-11','2021-12-11 00:00:00',NULL,'447',31526678.85,31526678.85,'447','2021-12-15 16:01:12','604','2021-12-15 17:31:40',10,0),('5','107',246395,'DAILY','2021-12-12','2021-12-12 00:00:00',NULL,'447',29096163.90,29096163.90,'447','2021-12-15 18:00:47','604','2021-12-15 19:18:48',10,0),('5','107',246477,'DAILY','2021-12-13','2021-12-13 00:00:00',NULL,'447',37020139.95,37020139.95,'447','2021-12-17 07:43:12','600','2021-12-17 08:00:53',10,0),('5','107',246756,'DAILY','2021-12-14','2021-12-14 00:00:00',NULL,'447',33112259.55,33112259.55,'447','2021-12-17 08:41:52','600','2021-12-17 08:46:21',10,0),('5','107',246770,'DAILY','2021-12-15','2021-12-15 00:00:00',NULL,'447',36396437.55,36396437.55,'447','2021-12-19 07:49:47','600','2021-12-19 07:50:37',10,0),('5','107',247208,'DAILY','2021-12-16','2021-12-16 00:00:00',NULL,'447',32946886.05,32946886.05,'447','2021-12-19 08:32:52','600','2021-12-19 08:35:33',10,0),('5','107',247218,'DAILY','2021-12-17','2021-12-17 00:00:00',NULL,'447',32968022.70,32968022.70,'447','2021-12-19 09:08:24','600','2021-12-19 09:18:07',10,0),('5','107',247234,'AFTERN00N','2021-12-18','2021-12-18 00:00:00',NULL,'447',34728020.25,34728020.25,'447','2021-12-20 13:15:38','600','2021-12-20 13:20:12',10,0),('5','107',247551,'DAILY','2021-12-19','2021-12-19 00:00:00',NULL,'447',32302217.25,32302217.25,'447','2021-12-21 19:31:39','600','2021-12-21 19:43:11',10,0),('5','107',247860,'DAILY','2021-12-20','2021-12-20 00:00:00',NULL,'447',37852830.15,37852830.15,'447','2021-12-22 14:38:53','600','2021-12-22 14:39:36',10,0),('5','107',248065,'DAILY','2021-12-21','2021-12-21 00:00:00',NULL,'447',36180610.35,36180610.35,'447','2021-12-22 15:21:46','604','2021-12-22 17:26:21',10,0),('5','107',248096,'DAILY','2021-12-22','2021-12-22 00:00:00',NULL,'447',33473775.60,33473775.60,'447','2021-12-23 18:00:23','600','2021-12-24 08:13:12',10,0),('5','107',248466,'DAILY','2021-12-23','2021-12-23 00:00:00',NULL,'447',30319233.00,30319233.00,'447','2021-12-25 09:13:00','600','2021-12-25 09:13:48',10,0),('5','107',248710,'DAILY','2021-12-24','2021-12-24 00:00:00',NULL,'447',29448957.45,29448957.45,'447','2021-12-25 09:33:54','604','2021-12-26 12:04:36',10,0),('5','107',249026,'DAILY','2021-12-25','2021-12-25 00:00:00',NULL,'447',27993644.85,27993644.85,'447','2021-12-27 12:56:42','600','2021-12-27 12:59:43',10,0),('5','107',249235,'DAILY','2021-12-26','2021-12-26 00:00:00',NULL,'447',27935158.65,27935158.65,'447','2021-12-27 16:36:46','600','2021-12-28 12:27:24',10,0),('5','107',249768,'DAILY','2021-12-27','2021-12-27 00:00:00',NULL,'447',30584156.85,30584156.85,'447','2021-12-29 16:15:55','604','2021-12-29 16:43:41',10,0),('5','107',249776,'DAILY','2021-12-28','2021-12-28 00:00:00',NULL,'447',32403227.85,32403227.85,'447','2021-12-31 08:19:50','600','2021-12-31 08:37:54',10,0),('5','107',250165,'DAILY','2021-12-29','2021-12-29 00:00:00',NULL,'447',27491319.90,27491319.90,'447','2022-01-02 16:05:20','600','2022-01-02 16:07:24',10,0),('5','107',250727,'DAILY','2021-12-30','2021-12-30 00:00:00',NULL,'447',32230169.85,32230169.85,'447','2022-01-02 16:28:17','600','2022-01-02 16:30:40',10,0),('5','107',250732,'DAILY','2021-12-31','2021-12-31 00:00:00',NULL,'447',30137918.40,30137918.40,'447','2022-01-02 16:47:39','604','2022-01-02 18:56:33',10,0),('5','107',250756,'DAILY','2022-01-01','2022-01-01 00:00:00',NULL,'447',27526522.80,27526522.80,'447','2022-01-04 11:21:08','600','2022-01-04 11:23:39',10,0),('5','107',251127,'DAILY','2022-01-02','2022-01-02 00:00:00',NULL,'447',28151130.15,28151130.15,'447','2022-01-04 12:15:20','604','2022-01-04 15:16:25',10,0),('5','107',251201,'DAILY','2022-01-03','2022-01-03 00:00:00',NULL,'447',32626587.30,32626587.30,'447','2022-01-06 10:11:45','600','2022-01-06 10:35:29',10,0),('5','107',251610,'DAILY','2022-01-04','2022-01-04 00:00:00',NULL,'447',25385868.45,25385868.45,'447','2022-01-06 11:22:11','600','2022-01-06 11:29:04',10,0),('5','107',251616,'DAILY','2022-01-05','2022-01-05 00:00:00',NULL,'447',26836636.05,26836636.05,'447','2022-01-09 21:10:13','600','2022-01-09 21:11:19',10,0),('5','107',252431,'DAILY','2022-01-06','2022-01-06 00:00:00',NULL,'447',29670887.55,29670887.55,'447','2022-01-09 21:27:37','600','2022-01-09 21:30:50',10,0),('5','107',252436,'DAILY','2022-01-07','2022-01-07 00:00:00',NULL,'447',27725545.05,27725545.05,'447','2022-01-09 21:56:07','600','2022-01-09 22:01:24',10,0),('5','107',252443,'DAILY','2022-01-08','2022-01-08 00:00:00',NULL,'447',32810714.40,32810714.40,'447','2022-01-13 14:17:54','600','2022-01-13 14:31:38',10,0),('5','107',253389,'DAILY','2022-01-09','2022-01-09 00:00:00',NULL,'447',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','107',253409,'DAILY','2022-01-09','2022-01-09 00:00:00',NULL,'447',23964410.85,23964410.85,'447','2022-01-14 18:03:19','600','2022-01-14 21:12:05',10,0),('5','107',253767,'DAILY','2022-01-10','2022-01-10 00:00:00',NULL,'447',28755316.50,28755316.50,'447','2022-01-15 10:32:01','600','2022-01-15 10:53:29',10,0),('5','107',253801,'DAILY','2022-01-11','2022-01-11 00:00:00',NULL,'447',27450252.60,27450252.60,'447','2022-01-16 09:37:47','600','2022-01-16 09:43:08',10,0),('5','107',254011,'DAILY','2022-01-12','2022-01-12 00:00:00',NULL,'447',30405828.30,30405828.30,'447','2022-01-16 10:04:47','600','2022-01-16 10:07:07',10,0),('5','107',254015,'DAILY','2022-01-13','2022-01-13 00:00:00',NULL,'447',29433479.10,29433479.10,'447','2022-01-16 17:44:57','600','2022-01-16 17:47:19',10,0),('5','107',254125,'DAILY','2022-01-14','2022-01-14 00:00:00',NULL,'447',27934785.60,27934785.60,'447','2022-01-16 18:06:39','600','2022-01-16 18:09:49',10,0),('5','107',254130,'DAILY','2022-01-15','2022-01-15 00:00:00',NULL,'447',31896092.10,31896092.10,'447','2022-01-16 18:23:26','604','2022-01-17 10:11:35',10,0),('5','107',254294,'DAILY','2022-01-16','2022-01-16 00:00:00',NULL,'447',25411395.00,25411395.00,'447','2022-01-18 09:00:14','604','2022-01-18 09:14:45',10,0),('5','107',254506,'DAILY','2022-01-17','2022-01-17 00:00:00',NULL,'447',28009388.97,28009388.97,'447','2022-01-18 09:26:10','604','2022-01-18 15:25:03',10,0),('5','107',254770,'DAILY','2022-01-18','2022-01-18 00:00:00',NULL,'447',27537554.25,27537554.25,'447','2022-01-19 09:41:39','604','2022-01-19 19:34:16',10,0),('5','107',255109,'DAILY','2022-01-19','2022-01-19 00:00:00',NULL,'447',27792427.95,27792427.95,'447','2022-01-21 11:36:21','600','2022-01-21 11:54:20',10,0),('5','107',255286,'DAILY','2022-01-20','2022-01-20 00:00:00',NULL,'447',27179744.70,27179744.70,'447','2022-01-21 12:08:49','604','2022-01-21 21:52:57',10,0),('5','107',255635,'DAILY','2022-01-21','2022-01-21 00:00:00',NULL,'447',26328063.90,26328063.90,'447','2022-01-23 19:21:41','604','2022-01-23 19:23:44',10,0),('5','107',255907,'DAILY','2022-01-22','2022-01-22 00:00:00',NULL,'447',31996908.30,31996908.30,'447','2022-01-23 20:26:08','604','2022-01-24 09:30:22',10,0),('5','107',256040,'DAILY','2022-01-23','2022-01-23 00:00:00',NULL,'447',28045109.55,28045109.55,'447','2022-01-24 17:42:49','600','2022-01-25 08:30:38',10,0),('5','107',256244,'DAILY','2022-01-24','2022-01-24 00:00:00',NULL,'447',26622154.55,26622154.55,'447','2022-01-25 08:40:52','600','2022-01-25 09:08:59',10,0),('5','107',256392,'DAILY','2022-01-25','2022-01-25 00:00:00',NULL,'447',30549335.30,30549335.30,'447','2022-01-28 18:01:14','600','2022-01-28 18:01:32',10,0),('5','107',257169,'DAILY','2022-01-26','2022-01-26 00:00:00',NULL,'447',33375802.05,33375802.05,'447','2022-01-28 18:16:59','600','2022-01-28 18:20:04',10,0),('5','107',257170,'DAILY','2022-01-27','2022-01-27 00:00:00',NULL,'447',31424194.20,31424194.20,'447','2022-01-28 18:32:07','600','2022-01-29 13:28:21',10,0),('5','107',257410,'DAILY','2022-01-28','2022-01-28 00:00:00',NULL,'447',4669350.50,4735116.00,'447','2022-01-29 17:40:44','600','2022-01-29 17:41:11',10,0),('5','107',257414,'DAILY','2022-01-28','2022-01-28 00:00:00',NULL,'447',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','107',257415,'DAILY','2022-01-28','2022-01-28 00:00:00',NULL,'447',27504777.60,27504777.60,'447','2022-02-02 17:54:53','600','2022-02-02 18:00:21',10,0),('5','107',257416,'DAILY','2022-01-29','2022-01-29 00:00:00',NULL,'447',28254513.03,28254513.03,'447','2022-02-02 18:20:09','600','2022-02-02 18:21:33',10,0),('5','107',257417,'DAILY','2022-01-30','2022-01-30 00:00:00',NULL,'447',29084229.60,29084229.60,'447','2022-02-02 18:52:16','604','2022-02-02 20:23:23',10,0),('5','107',257418,'DAILY','2022-01-31','2022-01-31 00:00:00',NULL,'447',33841916.40,33841916.40,'447','2022-02-03 14:38:11','600','2022-02-03 14:46:51',10,0),('5','107',257419,'DAILY','2022-02-01','2022-02-01 00:00:00',NULL,'447',24950273.55,24950273.55,'447','2022-02-03 15:44:18','600','2022-02-03 16:26:36',10,0),('5','107',257420,'DAILY','2022-02-02','2022-02-02 00:00:00',NULL,'447',33744476.40,33744476.40,'447','2022-02-03 17:24:54','604','2022-02-03 21:56:02',10,0),('5','107',257421,'DAILY','2022-02-03','2022-02-03 00:00:00',NULL,'447',20457718.50,20457718.50,'447','2022-02-04 09:58:40','604','2022-02-04 22:24:02',10,0),('5','107',257422,'DAILY','2022-02-04','2022-02-04 00:00:00',NULL,'447',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','107',257423,'DAILY','2022-02-04','2022-02-04 00:00:00',NULL,'447',27664954.80,27664954.80,'447','2022-02-06 21:46:37','600','2022-02-06 21:49:24',10,0),('5','107',257424,'DAILY','2022-02-05','2022-02-05 00:00:00',NULL,'447',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','107',257425,'DAILY','2022-02-05','2022-02-05 00:00:00',NULL,'447',34273480.41,34273480.41,'447','2022-02-06 22:18:22','600','2022-02-06 22:19:00',10,0),('5','107',257426,'DAILY','2022-02-06','2022-02-06 00:00:00',NULL,'447',28343103.25,27278336.25,'447','2022-02-12 10:43:46','600','2022-02-12 10:48:13',10,0),('5','107',257427,'DAILY','2022-02-07','2022-02-07 00:00:00',NULL,'447',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','107',257428,'DAILY','2022-02-07','2022-02-07 00:00:00',NULL,'600',31702834.65,31702834.65,'447','2022-02-13 17:06:03','600','2022-02-13 17:07:26',10,0),('5','107',257429,'DAILY','2022-02-08','2022-02-08 00:00:00',NULL,'600',28664212.35,28664212.35,'447','2022-02-13 17:15:55','600','2022-02-13 17:17:05',10,0),('5','107',257430,'DAILY','2022-02-09','2022-02-09 00:00:00',NULL,'600',26340467.45,26340467.45,'447','2022-02-13 17:29:05','600','2022-02-13 17:30:10',10,0),('5','107',257431,'DAILY','2022-02-10','2022-02-10 00:00:00',NULL,'600',27390831.35,27390831.35,'447','2022-02-16 15:01:05','600','2022-02-16 15:03:46',10,0),('5','107',257432,'DAILY','2022-02-11','2022-02-11 00:00:00',NULL,'447',32362322.10,32362322.10,'447','2022-02-16 15:28:32','600','2022-02-16 15:33:55',10,0),('5','107',257433,'DAILY','2022-02-12','2022-02-12 00:00:00',NULL,'447',26379166.58,26379166.58,'447','2022-02-17 09:20:31','600','2022-02-17 09:22:49',10,0),('5','107',257434,'DAILY','2022-02-13','2022-02-13 00:00:00',NULL,'447',20882451.25,20882451.25,'447','2022-02-17 09:32:10','600','2022-02-17 09:49:19',10,0),('5','107',257435,'DAILY','2022-02-14','2022-02-14 00:00:00',NULL,'447',22843041.70,22843041.70,'447','2022-02-17 10:03:53','600','2022-02-17 14:13:44',10,0),('5','107',257436,'DAILY','2022-02-15','2022-02-15 00:00:00',NULL,'447',18070355.35,18070355.35,'447','2022-02-17 14:27:58','604','2022-02-17 19:18:36',10,0),('5','107',257437,'DAILY','2022-02-16','2022-02-16 00:00:00',NULL,'447',28403228.40,28403228.40,'447','2022-02-18 10:35:04','600','2022-02-18 10:47:35',10,0),('5','107',257438,'DAILY','2022-02-17','2022-02-17 00:00:00',NULL,'447',28018487.20,28018487.20,'447','2022-02-18 11:01:31','600','2022-02-18 11:04:19',10,0),('5','107',257439,'DAILY','2022-02-18','2022-02-18 00:00:00',NULL,'447',29856961.85,29856961.85,'447','2022-02-19 17:14:58','600','2022-02-20 08:52:40',10,0),('5','107',257440,'DAILY','2022-02-19','2022-02-19 00:00:00',NULL,'447',32223213.50,32223213.50,'447','2022-02-21 15:02:56','600','2022-02-21 15:04:57',10,0),('5','107',257441,'DAILY','2022-02-20','2022-02-20 00:00:00',NULL,'447',21123191.52,21123191.52,'447','2022-02-21 15:12:44','600','2022-02-21 15:13:55',10,0),('5','107',257442,'DAILY','2022-02-21','2022-02-21 00:00:00',NULL,'447',28744336.35,28744336.35,'447','2022-02-23 11:39:37','600','2022-02-23 12:17:23',10,0),('5','107',257443,'DAILY','2022-02-22','2022-02-23 12:19:45','2022-02-24 12:19:45','447',27154068.75,27154068.75,'447','2022-02-23 12:31:04','600','2022-02-23 14:43:45',10,0),('5','107',257444,'DAILY','2022-02-23','2022-02-23 17:37:32','2022-02-24 17:37:32','447',27100559.80,27100559.80,'447','2022-02-24 16:34:24','600','2022-02-25 09:34:49',10,0),('5','107',257445,'DAILY','2022-02-24','2022-02-25 09:35:17','2022-02-26 09:35:17','447',32877496.65,32877496.65,'447','2022-02-25 09:50:50','600','2022-02-25 16:51:42',10,0),('5','107',257446,'DAILY','2022-02-25','2022-02-26 11:03:26','2022-02-27 11:03:26','447',26348587.85,26348587.85,'447','2022-02-26 11:12:22','604','2022-02-26 21:44:55',10,0),('5','107',257447,'DAILY','2022-02-26','2022-02-28 15:21:28','2022-03-01 15:21:28','447',25314274.85,25314274.85,'447','2022-02-28 15:33:50','600','2022-02-28 15:36:59',10,0),('5','107',257448,'DAILY','2022-02-27','2022-02-28 15:37:59','2022-03-01 15:37:59','447',24473741.85,24473741.85,'447','2022-02-28 15:45:56','600','2022-03-02 09:36:18',10,0),('5','107',257449,'DAILY','2022-02-28','2022-03-02 09:37:03','2022-03-03 09:37:03','447',31295963.65,31295963.65,'447','2022-03-02 09:49:09','600','2022-03-02 09:50:25',10,0),('5','107',257450,'DAILY','2022-03-01','2022-03-02 09:52:34','2022-03-03 09:52:34','447',23666805.60,23666805.60,'447','2022-03-03 11:50:29','600','2022-03-03 12:23:15',10,0),('5','107',257451,'DAILY','2022-03-02','2022-03-03 12:51:42','2022-03-04 12:51:42','447',25989329.40,25989329.40,'447','2022-03-03 13:07:26','600','2022-03-04 15:55:39',10,0),('5','107',257452,'DAILY','2022-03-03','2022-03-04 16:12:31','2022-03-05 16:12:31','447',34571465.10,34571465.10,'447','2022-03-07 12:48:52','600','2022-03-07 12:50:04',10,0),('5','107',257453,'DAILY','2022-03-04','2022-03-07 12:51:20','2022-03-08 12:51:20','447',27158650.20,27158650.20,'447','2022-03-07 13:03:36','600','2022-03-07 13:04:45',10,0),('5','107',257454,'DAILY','2022-03-05','2022-03-07 13:06:10','2022-03-08 13:06:10','447',23254363.10,23254363.10,'447','2022-03-07 13:16:06','600','2022-03-08 10:09:24',10,0),('5','107',257455,'DAILY','2022-03-06','2022-03-08 12:21:38','2022-03-09 12:21:38','447',25805307.75,25805307.75,'447','2022-03-11 12:11:12','600','2022-03-11 12:13:21',10,0),('5','107',257456,'DAILY','2022-03-07','2022-03-11 12:14:36','2022-03-12 12:14:36','447',29270377.95,24465762.75,'447','2022-03-11 12:24:04','600','2022-03-11 12:36:35',10,0),('5','107',257457,'DAILY','2022-03-08','2022-03-11 12:41:04','2022-03-12 12:41:04','447',36906053.35,30654154.55,'447','2022-03-11 15:17:16','600','2022-03-11 15:18:50',10,0),('5','107',257458,'DAILY','2022-03-09','2022-03-11 15:19:59','2022-03-12 15:19:59','447',17309732.10,17309732.10,'447','2022-03-11 15:28:45','600','2022-03-11 15:29:57',10,0),('5','107',257459,'DAILY','2022-03-10','2022-03-11 15:30:58','2022-03-12 15:30:58','447',21027117.20,21027117.20,'447','2022-03-11 16:01:52','600','2022-03-12 18:18:29',10,0),('5','107',257460,'DAILY','2022-03-11','2022-03-12 18:21:14','2022-03-13 18:21:14','447',17858585.40,17858585.40,'447','2022-03-12 19:09:22','600','2022-03-13 12:00:17',10,0),('5','107',257461,'DAILY','2022-03-12','2022-03-13 12:02:29','2022-03-14 12:02:29','447',33409419.25,33409419.25,'447','2022-03-14 20:43:11','600','2022-03-14 20:44:22',10,0),('5','107',257462,'DAILY','2022-03-13','2022-03-14 20:45:31','2022-03-15 20:45:31','447',19055952.95,19055952.95,'447','2022-03-14 20:57:40','600','2022-03-14 20:58:29',10,0),('5','107',257463,'DAILY','2022-03-14','2022-03-14 20:59:11','2022-03-15 20:59:11','447',26669664.55,26669664.55,'447','2022-03-15 14:27:18','600','2022-03-16 16:39:10',10,0),('5','107',257464,'DAILY','2022-03-15','2022-03-17 11:26:01','2022-03-18 11:26:01','447',41391513.80,41391513.80,'447','2022-03-17 11:37:03','600','2022-03-17 11:43:38',10,0),('5','107',257465,'DAILY','2022-03-16','2022-03-17 11:44:04','2022-03-18 11:44:04','447',41684304.60,41684304.60,'447','2022-03-17 15:28:58','600','2022-03-17 15:30:12',10,0),('5','107',257466,'DAILY','2022-03-17','2022-03-17 15:34:07','2022-03-18 15:34:07','447',34396733.95,34396733.95,'447','2022-03-18 09:06:01','600','2022-03-18 09:22:41',10,0),('5','107',257467,'DAILY','2022-03-18','2022-03-19 09:49:28','2022-03-20 09:49:28','447',35322090.10,35322090.10,'447','2022-03-19 10:00:26','600','2022-03-20 13:19:00',10,0),('5','107',257468,'DAILY','2022-03-19','2022-03-21 09:18:12','2022-03-22 09:18:12','447',35244546.15,35244546.15,'447','2022-03-21 09:33:32','600','2022-03-21 10:14:19',10,0),('5','107',257469,'DAILY','2022-03-20','2022-03-21 14:17:50','2022-03-22 14:17:50','447',31497003.15,31497003.15,'447','2022-03-21 14:29:36','600','2022-03-22 11:31:17',10,0),('5','107',257470,'DAILY','2022-03-21','2022-05-16 12:04:52','2022-05-17 12:04:52','447',37585913.60,37585913.60,'447','2022-05-17 13:04:20','604','2022-05-17 13:06:37',10,0),('5','107',257471,'daily','2022-03-22','2022-05-17 13:28:59','2022-05-18 13:28:59','447',23991562.40,23991562.40,'447','2022-05-17 13:37:05','604','2022-05-17 13:37:35',10,0),('5','107',257472,'daily','2022-03-23','2022-05-17 13:38:29','2022-05-18 13:38:29','447',35205067.70,35205067.70,'447','2022-05-18 15:18:23','600','2022-05-18 15:21:12',10,0),('5','107',257473,'DAILY','2022-03-24','2022-05-18 15:23:48','2022-05-19 15:23:48','447',41674333.80,41674333.80,'447','2022-05-18 15:31:34','600','2022-05-18 15:34:55',10,0),('5','107',257474,'DAILY','2022-03-25','2022-05-18 15:35:49','2022-05-19 15:35:49','447',38944318.80,39871636.20,'447','2022-05-18 15:47:21','600','2022-05-18 15:48:37',10,0),('5','107',257475,'DAILY','2022-03-26','2022-05-18 15:49:54','2022-05-19 15:49:54','447',40090425.00,41122996.20,'447','2022-05-19 14:36:37','604','2022-05-19 14:37:57',10,0),('5','107',257476,'DAILY','2022-03-27','2022-05-19 14:40:21','2022-05-20 14:40:21','447',34297504.35,35151103.35,'447','2022-05-19 14:50:49','604','2022-05-19 14:54:59',10,0),('5','107',257477,'DAILY','2022-03-28','2022-05-19 14:55:42','2022-05-20 14:55:42','447',38149159.50,39166323.90,'447','2022-05-19 15:05:12','604','2022-05-19 15:08:02',10,0),('5','107',257478,'DAILY','2022-03-29','2022-05-19 15:09:42','2022-05-20 15:09:42','447',31586681.60,32372458.80,'447','2022-05-19 15:16:07','604','2022-05-19 15:18:06',10,0),('5','107',257479,'DAILY','2022-03-30','2022-05-19 15:18:28','2022-05-20 15:18:28','447',37190931.10,38192210.10,'447','2022-05-20 11:52:30','600','2022-05-20 11:59:04',10,0),('5','107',257480,'DAILY','2022-03-31','2022-05-20 11:59:38','2022-05-21 11:59:38','447',48733582.35,48733582.35,'447','2022-05-20 14:35:16','600','2022-05-20 14:37:21',10,0),('5','107',257481,'DAILY','2022-04-01','2022-05-20 14:39:01','2022-05-21 14:39:01','447',44052933.30,44052933.30,'447','2022-05-20 14:52:55','600','2022-05-20 14:53:50',10,0),('5','107',257482,'DAILY','2022-04-02','2022-05-20 14:55:59','2022-05-21 14:55:59','447',38009338.20,38009338.20,'447','2022-05-20 15:03:50','600','2022-05-20 15:04:55',10,0),('5','107',257483,'DAILY','2022-04-03','2022-05-20 15:05:33','2022-05-21 15:05:33','447',37462080.15,37462080.15,'447','2022-05-20 15:29:26','600','2022-05-20 15:41:37',10,0),('5','107',257484,'DAILY','2022-04-04','2022-05-20 15:42:28','2022-05-21 15:42:28','447',38411531.40,38411531.40,'447','2022-05-20 15:50:48','600','2022-05-20 15:52:00',10,0),('5','107',257485,'DAILY','2022-04-05','2022-05-20 15:52:36','2022-05-21 15:52:36','447',41940581.25,41940581.25,'447','2022-05-20 15:59:34','600','2022-05-20 16:00:34',10,0),('5','107',257486,'DAILY','2022-04-06','2022-05-20 16:08:51','2022-05-21 16:08:51','447',46660150.20,42276687.80,'447','2022-05-27 16:05:12','600','2022-05-27 16:07:38',10,0),('5','107',257487,'daily','2022-04-07','2022-05-27 16:10:14','2022-05-28 16:10:14','447',55775031.48,54524486.34,'447','2022-05-27 16:23:13','600','2022-05-27 16:24:35',10,0),('5','107',257488,'daily','2022-04-08','2022-05-27 16:25:47','2022-05-28 16:25:47','447',42543940.35,38927682.75,'447','2022-05-27 16:38:02','600','2022-05-27 16:49:23',10,0),('5','107',257489,'daily','2022-04-09','2022-05-27 16:51:49','2022-05-28 16:51:49','447',38859437.10,38025480.90,'447','2022-05-27 17:05:56','600','2022-05-27 17:18:02',10,0),('5','107',257490,'daily','2022-04-10','2022-05-27 17:22:55','2022-05-28 17:22:55','447',0.00,0.00,'600','2022-05-27 17:27:14','600','2022-05-27 17:27:30',10,0),('5','107',257491,'daily','2022-04-10','2022-05-27 17:30:47','2022-05-28 17:30:47','447',36709261.38,36709261.38,'447','2022-05-31 16:12:17','600','2022-05-31 16:14:08',10,0),('5','107',257492,'daily','2022-04-11','2022-05-31 16:18:49','2022-06-01 16:18:49','447',45017879.50,41312789.10,'447','2022-05-31 17:41:59','600','2022-05-31 17:43:42',10,0),('5','107',257493,'daily','2022-04-12','2022-05-31 18:42:56','2022-06-01 18:42:56','447',60253494.30,54876488.70,'447','2022-05-31 19:04:44','600','2022-05-31 19:06:37',10,0),('5','107',257494,'daily','2022-04-13','2022-05-31 19:07:53','2022-06-01 19:07:53','447',45157938.25,40990456.65,'447','2022-06-01 18:36:29','600','2022-06-01 18:51:15',10,0),('5','107',257495,'daily','2022-04-14','2022-06-01 19:30:34','2022-06-02 19:30:34','447',48226223.80,44236731.00,'447','2022-06-01 19:42:35','600','2022-06-01 19:47:59',10,0),('5','107',257496,'daily','2022-04-15','2022-06-01 19:49:01','2022-06-02 19:49:01','447',45526070.40,42082735.20,'447','2022-06-01 19:59:26','600','2022-06-02 09:24:53',10,0),('5','107',257497,'daily','2022-04-16','2022-06-02 11:24:52','2022-06-03 11:24:52','447',41075926.95,37600482.15,'447','2022-06-02 18:08:59','600','2022-06-03 09:31:27',10,0),('5','107',257498,'daily','2022-04-17','2022-06-03 10:33:38','2022-06-04 10:33:38','447',33231743.80,30765339.00,'447','2022-06-03 11:19:09','606','2022-06-03 11:20:20',10,0),('5','107',257499,'daily','2022-04-18','2022-06-03 11:20:56','2022-06-04 11:20:56','447',33855836.85,31170085.65,'447','2022-06-03 11:30:52','606','2022-06-03 11:31:19',10,0),('5','107',257500,'daily','2022-04-19','2022-06-03 11:31:47','2022-06-04 11:31:47','447',47444236.05,43514092.05,'447','2022-06-03 11:40:23','606','2022-06-03 11:41:56',10,0),('5','107',257501,'daily','2022-04-20','2022-06-03 11:42:38','2022-06-04 11:42:38','447',48499828.25,44211164.25,'447','2022-06-03 11:51:29','606','2022-06-03 11:51:53',10,0),('5','107',257502,'daily','2022-04-21','2022-06-03 11:52:27','2022-06-04 11:52:27','447',34658302.10,31265430.90,'447','2022-06-03 11:58:54','600','2022-06-03 11:59:11',10,0),('5','107',257503,'daily','2022-04-22','2022-06-03 11:59:58','2022-06-04 11:59:58','447',37557931.85,34377916.65,'447','2022-06-03 12:18:16','600','2022-06-03 12:18:53',10,0),('5','107',257504,'daily','2022-04-23','2022-06-03 12:19:22','2022-06-04 12:19:22','447',37994739.70,34819847.70,'447','2022-06-03 12:30:44','600','2022-06-03 12:31:30',10,0),('5','107',257505,'daily','2022-04-24','2022-06-03 12:32:48','2022-06-04 12:32:48','447',40734132.10,37435203.30,'447','2022-06-03 14:16:55','600','2022-06-03 15:18:59',10,0),('5','107',257506,'daily','2022-04-25','2022-06-03 15:19:55','2022-06-04 15:19:55','447',35671095.90,32700990.30,'447','2022-06-03 15:29:36','600','2022-06-03 15:30:29',10,0),('5','107',257507,'daily','2022-04-26','2022-06-03 15:31:22','2022-06-04 15:31:22','447',33261868.90,30460640.10,'447','2022-06-03 15:39:54','600','2022-06-03 15:41:06',10,0),('5','107',257508,'daily','2022-04-27','2022-06-03 15:41:54','2022-06-04 15:41:54','447',38175776.25,34822796.25,'447','2022-06-03 15:51:38','600','2022-06-03 15:52:07',10,0),('5','107',257509,'daily','2022-04-28','2022-06-03 15:52:41','2022-06-04 15:52:41','447',20415744.60,18838980.60,'447','2022-06-03 15:57:08','600','2022-06-03 16:04:10',10,0),('5','107',257510,'DAILY','2022-04-29','2022-06-04 15:56:39','2022-06-05 15:56:39','447',0.00,0.00,'600','2022-06-07 09:38:08','600','2022-06-07 09:38:40',10,0),('5','107',257511,'DAILY','2022-04-29','2022-06-07 09:44:21','2022-06-08 09:44:21','447',44709591.90,40669572.90,'447','2022-06-07 12:54:29','600','2022-06-07 12:56:15',10,0),('5','107',257512,'DAILY','2022-04-30','2022-06-07 12:57:32','2022-06-08 12:57:32','447',36652953.75,33934099.65,'447','2022-06-07 13:23:59','600','2022-06-07 13:28:37',10,0),('5','107',257513,'DAILY SHIFT','2022-06-07','2022-06-07 18:22:06','2022-06-08 18:22:06','447',0.00,0.00,'600','2022-06-08 10:11:40','600','2022-06-08 10:11:57',10,0),('5','107',257514,'DAILY','2022-05-01','2022-06-08 10:28:29','2022-06-09 10:28:29','447',19975791.00,18481009.80,'447','2022-06-08 10:49:15','600','2022-06-08 11:06:28',10,0),('5','107',257515,'DAILY','2022-05-02','2022-06-08 11:12:19','2022-06-09 11:12:19','447',29469724.05,26666067.45,'447','2022-06-08 11:23:38','600','2022-06-08 11:24:38',10,0),('5','107',257516,'DAILY','2022-05-03','2022-06-08 11:25:57','2022-06-09 11:25:57','447',17405325.60,16242309.60,'447','2022-06-08 11:40:12','600','2022-06-08 11:41:10',10,0),('5','107',257517,'DAILY','2022-05-04','2022-06-08 11:49:10','2022-06-09 11:49:10','447',23396453.70,21484953.60,'447','2022-06-08 12:39:53','600','2022-06-08 12:41:29',10,0),('5','107',257518,'DAILY','2022-05-05','2022-06-08 12:42:36','2022-06-09 12:42:36','447',40813073.10,37414733.40,'447','2022-06-09 15:19:44','600','2022-06-09 15:22:03',10,0),('5','107',257519,'DAILY SHIFT','2022-05-06','2022-06-09 15:24:07','2022-06-10 15:24:07','447',30538634.70,27565923.00,'447','2022-06-09 15:35:57','600','2022-06-09 15:38:31',10,0),('5','107',257520,'DAILY SHIFT','2022-05-07','2022-06-09 15:40:06','2022-06-10 15:40:06','447',34280346.30,30986142.00,'447','2022-06-10 12:02:09','600','2022-06-10 12:03:54',10,0),('5','107',257521,'DAILY','2022-05-08','2022-06-10 12:07:19','2022-06-11 12:07:19','447',48598318.35,43656342.35,'447','2022-06-10 12:33:16','600','2022-06-10 13:49:18',10,0),('5','107',257522,'DAILY','2022-05-09','2022-06-10 14:02:48','2022-06-11 14:02:48','447',51486900.45,45126654.45,'447','2022-06-10 14:41:22','600','2022-06-10 14:49:57',10,0),('5','107',257523,'DAILY','2022-05-10','2022-06-10 14:55:54','2022-06-11 14:55:54','447',53522882.70,47842081.70,'447','2022-06-11 09:58:15','600','2022-06-11 10:04:50',10,0),('5','107',257524,'DAILY','2022-05-11','2022-06-11 10:06:13','2022-06-12 10:06:13','447',54259778.70,49487224.30,'447','2022-06-11 10:32:00','600','2022-06-11 10:44:37',10,0),('5','107',257525,'DAILY','2022-05-12','2022-06-11 10:48:20','2022-06-12 10:48:20','447',73983317.85,66934879.45,'447','2022-06-11 14:18:32','600','2022-06-11 14:19:46',10,0),('5','107',257526,'DAILY','2022-05-13','2022-06-11 14:23:36','2022-06-12 14:23:36','447',67122652.95,62565693.15,'447','2022-06-11 14:35:56','600','2022-06-11 14:37:36',10,0),('5','107',257527,'DAILY','2022-05-14','2022-06-11 14:39:38','2022-06-12 14:39:38','447',81131735.40,75489108.60,'447','2022-06-11 15:17:03','600','2022-06-11 15:18:15',10,0),('5','107',257528,'DAILY','2022-05-15','2022-06-11 15:26:55','2022-06-12 15:26:55','447',50238580.65,48639221.55,'447','2022-06-11 16:13:44','600','2022-06-11 16:15:10',10,0),('5','107',257529,'DAILY','2022-05-16','2022-06-11 16:16:28','2022-06-12 16:16:28','447',45139108.50,43634335.20,'447','2022-06-11 19:13:57','600','2022-06-11 19:30:06',10,0),('5','107',257530,'DAILY','2022-05-17','2022-06-11 22:42:39','2022-06-12 22:42:39','447',54802644.30,52964558.70,'447','2022-06-12 14:39:43','600','2022-06-12 14:41:49',10,0),('5','107',257531,'DAILY','2022-05-18','2022-06-12 14:43:27','2022-06-13 14:43:27','447',51557842.50,49798247.70,'447','2022-06-12 15:51:59','600','2022-06-12 15:54:44',10,0),('5','107',257532,'DAILY','2022-05-19','2022-06-12 16:57:54','2022-06-13 16:57:54','447',47123356.35,45496113.75,'447','2022-06-12 17:38:59','600','2022-06-12 17:40:34',10,0),('5','107',257533,'DAILY','2022-05-20','2022-06-12 18:07:05','2022-06-13 18:07:05','447',14615493.75,14615493.75,'447','2022-06-12 18:12:14','600','2022-06-12 18:14:22',10,0),('5','107',257534,'DAILY','2022-05-21','2022-06-12 18:31:45','2022-06-13 18:31:45','447',54776229.45,52782251.85,'447','2022-06-12 21:52:24','600','2022-06-12 21:53:48',10,0),('5','107',257535,'DAILY','2022-05-22','2022-06-12 21:55:11','2022-06-13 21:55:11','447',50327003.10,48702376.80,'447','2022-06-12 22:12:41','600','2022-06-12 22:13:42',10,0),('5','107',257536,'DAILY','2022-05-23','2022-06-12 22:15:32','2022-06-13 22:15:32','447',17490174.15,17027652.45,'447','2022-06-12 22:23:50','600','2022-06-12 22:24:47',10,0),('5','107',257537,'DAILY','2022-05-24','2022-06-12 22:26:01','2022-06-13 22:26:01','447',33101543.25,32765891.75,'447','2022-06-13 06:54:52','600','2022-06-13 09:29:02',10,0),('5','107',257538,'DAILY SHIFT','2022-05-25','2022-06-13 14:29:16','2022-06-14 14:29:16','447',43051066.25,40928188.75,'447','2022-06-13 14:56:14','600','2022-06-13 14:58:05',10,0),('5','107',257539,'DAILY SHIFT','2022-05-26','2022-06-14 12:36:43','2022-06-15 12:36:43','447',26237325.25,25372883.75,'447','2022-06-16 09:25:32','600','2022-06-16 09:27:06',10,0),('5','107',257540,'DAILY','2022-05-27','2022-06-16 09:28:36','2022-06-17 09:28:36','447',52357041.95,49718806.45,'447','2022-06-16 09:41:02','600','2022-06-16 09:42:15',10,0),('5','107',257541,'DAILY','2022-05-28','2022-06-16 09:44:05','2022-06-17 09:44:05','447',23467750.15,22541798.15,'447','2022-06-16 10:04:39','600','2022-06-16 12:47:54',10,0),('5','107',257542,'DAILY','2022-05-29','2022-06-16 12:50:06','2022-06-17 12:50:06','447',31759547.95,30057650.45,'447','2022-06-16 14:20:17','600','2022-06-16 14:28:12',10,0),('5','107',257543,'DAILY','2022-05-30','2022-06-16 14:29:17','2022-06-17 14:29:17','447',25384501.90,24106304.90,'447','2022-06-16 14:35:56','600','2022-06-16 14:36:53',10,0),('5','107',257544,'DAILY','2022-05-31','2022-06-16 14:37:39','2022-06-17 14:37:39','447',55287493.90,47851085.70,'447','2022-06-16 21:45:23','600','2022-06-16 21:49:58',10,0),('5','107',257545,'DAILY','2022-06-01','2022-06-16 21:53:43','2022-06-17 21:53:43','447',55349209.85,51658595.45,'447','2022-06-16 21:58:39','600','2022-06-16 22:01:39',10,0),('5','107',257546,'DAILY','2022-06-02','2022-06-16 22:08:19','2022-06-17 22:08:19','447',37921408.00,35551320.00,'447','2022-06-16 22:12:20','600','2022-06-16 22:18:12',10,0),('5','107',257547,'DAILY','2022-06-03','2022-06-16 22:20:22','2022-06-17 22:20:22','447',45647873.90,42901884.90,'447','2022-06-16 22:25:27','600','2022-06-17 09:58:52',10,0),('5','107',257548,'DAILY','2022-06-04','2022-06-17 10:00:07','2022-06-18 10:00:07','447',50237426.15,48536910.95,'447','2022-06-17 10:08:38','600','2022-06-17 10:16:09',10,0),('5','107',257549,'DAILY','2022-06-05','2022-06-17 10:20:30','2022-06-18 10:20:30','447',11848683.10,11731993.90,'447','2022-06-17 10:41:55','600','2022-06-17 10:46:29',10,0),('5','107',257550,'DAILY','2022-06-06','2022-06-17 10:50:16','2022-06-18 10:50:16','447',14072065.45,13937943.63,'447','2022-06-17 11:00:06','600','2022-06-17 11:10:00',10,0),('5','107',257551,'DAILY','2022-06-07','2022-06-17 11:11:51','2022-06-18 11:11:51','447',56665616.65,55807194.75,'447','2022-06-17 15:20:11','600','2022-06-17 15:21:18',10,0),('5','107',257552,'DAILY','2022-06-08','2022-06-17 15:22:33','2022-06-18 15:22:33','447',49578660.40,48859827.18,'447','2022-06-17 15:50:04','600','2022-06-17 16:16:49',10,0),('5','107',257553,'DAILY','2022-06-09','2022-06-17 16:44:32','2022-06-18 16:44:32','447',57266212.95,56631538.95,'447','2022-06-17 17:09:12','600','2022-06-17 21:30:37',10,0),('5','107',257554,'DAILY SHIFT','2022-06-10','2022-06-18 08:38:11','2022-06-19 08:38:11','447',51491188.55,50892584.35,'447','2022-06-18 08:45:29','600','2022-06-18 09:50:00',10,0),('5','107',257555,'DAILY SHIFT','2022-06-11','2022-06-18 10:48:24','2022-06-19 10:48:24','447',35773928.00,35326753.90,'447','2022-06-18 10:53:48','600','2022-06-18 10:55:58',10,0),('5','107',257556,'DAILY SHIFT','2022-06-12','2022-06-18 10:57:24','2022-06-19 10:57:24','447',43655009.70,43128193.50,'447','2022-06-18 11:02:31','600','2022-06-18 11:03:33',10,0),('5','107',257557,'DAILY SHIFT','2022-06-13','2022-06-18 11:05:07','2022-06-19 11:05:07','447',18322746.10,18166801.70,'447','2022-06-18 15:41:58','600','2022-06-18 17:17:50',10,0),('5','107',257558,'DAILY SHIFT','2022-06-14','2022-06-19 06:35:42','2022-06-20 06:35:42','447',31947212.30,31947212.30,'447','2022-06-19 06:58:49','600','2022-06-19 09:35:45',10,0),('5','107',257559,'DAILY','2022-06-21','2022-06-21 12:05:31','2022-06-22 12:05:31','447',0.00,0.00,'600','2022-06-21 12:12:35','600','2022-06-21 12:13:13',10,0),('5','107',257560,'DAILY','2022-06-15','2022-06-21 12:14:30','2022-06-22 12:14:30','447',37198965.00,37198965.00,'447','2022-06-21 12:19:22','600','2022-06-21 12:22:23',10,0),('5','107',257561,'DAILY','2022-06-16','2022-06-21 12:23:21','2022-06-22 12:23:21','447',33571230.45,33571230.45,'447','2022-06-21 12:29:16','600','2022-06-21 12:30:12',10,0),('5','107',257562,'DAILY','2022-06-17','2022-06-21 12:30:56','2022-06-22 12:30:56','447',29229948.35,29229948.35,'447','2022-06-21 12:46:31','600','2022-06-21 13:21:41',10,0),('5','107',257563,'DAILY','2022-06-18','2022-06-21 16:43:56','2022-06-22 16:43:56','600',0.00,0.00,'600','2022-06-21 16:57:27','600','2022-06-21 16:57:42',10,0),('5','107',257564,'DAILY','2022-06-18','2022-06-21 16:58:56','2022-06-22 16:58:56','600',38300565.30,38300565.30,'447','2022-06-21 21:21:27','600','2022-06-21 21:22:56',10,0),('5','107',257565,'DAILY','2022-06-19','2022-06-21 21:24:54','2022-06-22 21:24:54','600',48603330.15,47728280.55,'447','2022-06-21 21:31:53','600','2022-06-21 21:34:10',10,0),('5','107',257566,'DAILY','2022-06-20','2022-06-21 21:34:43','2022-06-22 21:34:43','600',48751500.70,47702622.50,'447','2022-06-21 21:50:20','600','2022-06-21 21:51:46',10,0),('5','107',257567,'DAILY','2022-06-21','2022-06-21 21:55:17','2022-06-22 21:55:17','600',35244954.05,34537772.05,'447','2022-06-22 12:33:39','600','2022-06-22 19:48:20',10,0),('5','107',257568,'DAILY SHIFT','2022-06-22','2022-06-22 21:01:55','2022-06-23 21:01:55','447',36836077.85,36836077.85,'447','2022-06-24 13:19:53','600','2022-06-24 13:22:38',10,0),('5','107',257569,'DAILY','2022-06-23','2022-06-24 13:24:26','2022-06-25 13:24:26','600',43519797.75,42624732.15,'447','2022-06-24 13:30:30','600','2022-06-24 13:38:34',10,0),('5','107',257570,'DAILY','2022-06-24','2022-06-24 13:39:17','2022-06-25 13:39:17','600',42266098.50,41369582.70,'447','2022-06-27 11:47:31','600','2022-06-27 12:08:01',10,0),('5','107',257571,'DAILY SHIFT','2022-06-25','2022-06-27 12:11:49','2022-06-28 12:11:49','447',44718380.20,44718380.20,'447','2022-06-27 12:35:59','600','2022-06-27 12:47:45',10,0),('5','107',257572,'DAILY SHIFT','2022-06-26','2022-06-27 12:55:55','2022-06-28 12:55:55','447',30755148.50,30755148.50,'447','2022-06-27 13:20:47','600','2022-06-27 13:23:23',10,0),('5','107',257573,'DAILY SHIFT','2022-06-27','2022-06-27 19:20:01','2022-06-28 19:20:01','447',39935172.60,39935172.60,'447','2022-06-28 16:42:37','600','2022-06-28 20:56:03',10,0),('5','107',257574,'DAILY SHIFT','2022-06-28','2022-06-28 21:04:06','2022-06-29 21:04:06','447',40074564.40,40074564.40,'447','2022-06-29 17:03:48','600','2022-06-29 20:59:22',10,0),('5','107',257575,'DAILY SHIFT','2022-06-29','2022-06-29 21:03:42','2022-06-30 21:03:42','447',33386628.00,33386628.00,'447','2022-06-30 19:23:38','600','2022-06-30 21:17:06',10,0),('5','107',257576,'DAILY SHIFT','2022-06-30','2022-06-30 22:08:43','2022-07-01 22:08:43','447',41016900.20,41016900.20,'447','2022-07-01 13:28:59','600','2022-07-01 20:30:45',10,0),('5','107',257577,'DAILY SHIFT','2022-07-01','2022-07-01 20:31:43','2022-07-02 20:31:43','447',33128073.80,33128073.80,'447','2022-07-02 17:50:01','600','2022-07-02 18:11:52',10,0),('5','107',257578,'DAILY SHIFT','2022-07-02','2022-07-02 21:54:56','2022-07-03 21:54:56','447',42305182.95,42305182.95,'447','2022-07-03 21:48:58','600','2022-07-03 21:54:58',10,0),('5','107',257579,'DAILY SHIFT','2022-07-03','2022-07-03 22:14:28','2022-07-04 22:14:28','447',39974936.45,39974936.45,'447','2022-07-04 18:44:38','600','2022-07-04 21:40:07',10,0),('5','107',257580,'DAILY SHIFT','2022-07-04','2022-07-04 21:42:08','2022-07-05 21:42:08','447',39192706.90,39192706.90,'447','2022-07-05 14:29:06','606','2022-07-05 14:44:21',10,0),('5','107',257581,'DAILY SHIFT','2022-07-05','2022-07-05 14:54:18','2022-07-06 14:54:18','447',29757025.15,29757025.15,'447','2022-07-06 22:39:30','606','2022-07-06 22:45:19',10,0),('5','107',257582,'DAILY SHIFT','2022-07-06','2022-07-06 22:46:13','2022-07-07 22:46:13','447',31594769.50,31594769.50,'447','2022-07-07 09:33:50','606','2022-07-07 10:19:12',10,0),('5','107',257583,'DAILY SHIFT','2022-07-07','2022-07-07 16:09:13','2022-07-08 16:09:13','447',26674687.70,26674687.70,'447','2022-07-08 16:33:08','606','2022-07-08 17:36:28',10,0),('5','107',257584,'DAILY SHIFT','2022-07-08','2022-07-08 19:55:18','2022-07-09 19:55:18','447',19917973.50,19917973.50,'447','2022-07-09 19:40:48','606','2022-07-09 19:45:59',10,0),('5','107',257585,'DAILY','2022-07-09','2022-07-09 19:56:12','2022-07-10 19:56:12','447',8342934.35,8237511.55,'447','2022-07-10 06:54:37','606','2022-07-10 23:17:57',10,0),('5','107',257586,'DAILY SHIFT','2022-07-10','2022-07-11 05:39:50','2022-07-12 05:39:50','447',6351468.65,6231645.25,'447','2022-07-11 11:45:24','606','2022-07-11 15:16:39',10,0),('5','107',257587,'DAILY SHIFT re re','2022-07-11','2022-07-11 18:18:29','2022-07-12 18:18:29','447',15430073.70,15074233.50,'447','2022-07-12 13:30:33','606','2022-07-12 18:54:57',10,0),('5','107',257588,'DAILY SHIFT ','2022-07-12','2022-07-12 22:05:52','2022-07-13 22:05:52','447',25352891.20,24834419.00,'447','2022-07-14 15:35:18','606','2022-07-14 15:36:34',10,0),('5','107',257589,'DAILY SHIFT','2022-07-13','2022-07-14 15:37:58','2022-07-15 15:37:58','447',33321836.85,33321836.85,'447','2022-07-14 15:46:46','606','2022-07-14 15:59:29',10,0),('5','107',257590,'DAILY SHIFT','2022-07-14','2022-07-14 21:48:41','2022-07-15 21:48:41','447',29769010.55,29769010.55,'447','2022-07-15 07:24:57','606','2022-07-15 12:41:47',10,0),('5','107',257591,'DAILY SHIFT','2022-07-15','2022-07-15 16:47:30','2022-07-16 16:47:30','447',32831614.40,32831614.40,'447','2022-07-16 15:43:35','606','2022-07-16 22:19:53',10,0),('5','107',257592,'DAILY SHIFT','2022-07-16','2022-07-16 22:57:35','2022-07-17 22:57:35','447',50099711.15,50099711.15,'447','2022-07-17 17:52:21','606','2022-07-17 17:54:55',10,0),('5','107',257593,'DAILY SHIFT','2022-07-17','2022-07-17 17:59:16','2022-07-18 17:59:16','447',33332970.00,33332970.00,'447','2022-07-18 12:12:55','606','2022-07-18 22:31:30',10,0),('5','107',257594,'DAILY SHIFT','2022-07-18','2022-07-18 22:33:54','2022-07-19 22:33:54','447',43535130.15,43535130.15,'447','2022-07-19 17:46:15','606','2022-07-19 18:12:03',10,0),('5','107',257595,'DAILY SHIFT','2022-07-19','2022-07-19 18:37:33','2022-07-20 18:37:33','447',45473068.60,45473068.60,'447','2022-07-20 08:26:06','606','2022-07-20 08:38:32',10,0),('5','107',257596,'DAILY SHIFT','2022-07-20','2022-07-20 17:47:07','2022-07-21 17:47:07','447',44994142.30,44994142.30,'447','2022-07-21 17:57:33','606','2022-07-21 20:58:42',10,0),('5','107',257597,'DAILY SHIFT','2022-07-21','2022-07-21 21:11:30','2022-07-22 21:11:30','447',38963707.85,38963707.85,'447','2022-07-22 20:49:11','606','2022-07-22 20:54:24',10,0),('5','107',257598,'DAILY SHIFT','2022-07-22','2022-07-22 23:40:47','2022-07-23 23:40:47','447',38520835.55,38520835.55,'447','2022-07-23 15:28:29','606','2022-07-23 18:42:16',10,0),('5','107',257599,'DAILY SHIFT','2022-07-23','2022-07-23 21:45:41','2022-07-24 21:45:41','447',41358646.20,41358646.20,'447','2022-07-24 18:27:33','606','2022-07-24 22:17:07',10,0),('5','107',257600,'DAILY SHIFT','2022-07-24','2022-07-25 00:21:21','2022-07-26 00:21:21','447',38354087.00,38354087.00,'447','2022-07-25 08:42:03','606','2022-07-25 10:03:01',10,0),('5','107',257601,'DAILY SHIFT','2022-07-25','2022-07-26 01:14:42','2022-07-27 01:14:42','447',36506840.00,36506840.00,'447','2022-07-26 16:11:23','606','2022-07-26 16:25:53',10,0),('5','107',257602,'DAILY SHIFT ','2022-07-26','2022-07-26 19:22:03','2022-07-27 19:22:03','447',32231675.25,32231675.25,'447','2022-07-27 18:35:51','606','2022-07-27 19:02:04',10,0),('5','107',257603,'DAILY SHIFT','2022-07-27','2022-07-27 20:17:26','2022-07-28 20:17:26','447',26216186.35,26216186.35,'447','2022-07-28 10:13:58','606','2022-07-28 13:41:01',10,0),('5','107',257604,'DAILY SHIFT ','2022-07-28','2022-07-28 17:39:08','2022-07-29 17:39:08','447',32021611.40,32021611.40,'447','2022-08-02 18:37:48','606','2022-08-02 20:02:01',10,0),('5','107',257605,'DAILY SHIFTp','2022-07-29','2022-08-03 14:19:26','2022-08-04 14:19:26','447',45303432.45,45303432.45,'447','2022-08-03 14:26:10','606','2022-08-03 14:28:31',10,0),('5','107',257606,'DAILY SHIFT','2022-07-30','2022-08-03 14:41:45','2022-08-04 14:41:45','447',35792925.35,35792925.35,'447','2022-08-03 14:47:51','606','2022-08-03 14:52:41',10,0),('5','107',257607,'DAILY SHIFT','2022-07-31','2022-08-03 14:58:14','2022-08-04 14:58:14','447',25341802.45,25341802.45,'447','2022-08-03 15:08:29','606','2022-08-03 15:10:40',10,0),('5','107',257608,'DAILY SHIFT','2022-08-01','2022-08-03 15:23:26','2022-08-04 15:23:26','447',36795473.10,36795473.10,'447','2022-08-04 10:39:47','606','2022-08-04 10:42:05',10,0),('5','107',257609,'DAILY SHIFT','2022-08-02','2022-08-04 11:30:52','2022-08-05 11:30:52','447',30149181.05,30149181.05,'447','2022-08-04 11:41:01','606','2022-08-04 11:52:35',10,0),('5','107',257610,'DAILY SHIFT','2022-08-03','2022-08-05 10:40:05','2022-08-06 10:40:05','447',31737574.65,31737574.65,'447','2022-08-05 11:26:46','606','2022-08-05 11:35:36',10,0),('5','107',257611,'DAILY SHIFT','2022-08-04','2022-08-05 12:47:21','2022-08-06 12:47:21','447',38580234.50,38580234.50,'447','2022-08-05 12:53:11','606','2022-08-05 13:20:13',10,0),('5','107',257612,'DAILY SHIFT','2022-08-05','2022-08-05 21:45:44','2022-08-06 21:45:44','447',47019807.85,47019807.85,'447','2022-08-07 08:31:52','606','2022-08-07 10:46:21',10,0),('5','107',257613,'DAILY SHIFT','2022-08-06','2022-08-07 17:14:20','2022-08-08 17:14:20','447',39303396.90,39303396.90,'447','2022-10-07 10:23:55','600','2022-10-07 10:25:03',10,0),('5','107',257614,'DAILY SHIFT','2022-08-07','2022-10-07 11:46:03','2022-10-08 11:46:03','447',35738873.25,35738873.25,'447','2022-10-07 11:57:01','606','2022-10-07 11:57:54',10,0),('5','107',257615,'DAILY SHIFT','2022-08-08','2022-10-07 11:59:49','2022-10-08 11:59:49','447',36710209.40,36710209.40,'447','2022-10-07 12:08:38','600','2022-10-07 12:13:07',10,0),('5','107',257616,'DAILY SHIFT','2022-08-09','2022-10-07 12:15:39','2022-10-08 12:15:39','447',47423311.70,47423311.70,'447','2022-10-07 12:25:35','600','2022-10-07 12:31:53',10,0),('5','107',257617,'DAILY SHIFT','2022-08-10','2022-10-07 13:37:18','2022-10-08 13:37:18','447',47377736.20,47377736.20,'447','2022-11-30 11:59:06','606','2022-11-30 12:03:02',10,0),('5','107',257618,'daly shift','2022-08-11','2022-11-30 12:18:41','2022-12-01 12:18:41','447',46090622.30,44176490.75,'447','2022-11-30 12:25:27','606','2022-11-30 12:27:05',10,0),('5','107',257619,'DAILY SHIFT','2022-08-12','2022-11-30 12:29:06','2022-12-01 12:29:06','447',44712654.70,44712654.70,'447','2022-11-30 12:35:10','606','2022-11-30 12:36:16',10,0),('5','107',257620,'DAILY SHIFT','2022-08-13','2022-11-30 12:41:33','2022-12-01 12:41:33','447',37782978.10,37782978.10,'447','2022-11-30 12:50:04','606','2022-11-30 12:50:45',10,0),('5','107',257621,'DAILY SHIFT','2022-08-14','2022-11-30 12:51:54','2022-12-01 12:51:54','447',40312958.70,40312958.70,'447','2022-11-30 13:11:58','606','2022-11-30 13:12:39',10,0),('5','107',257622,'DAILY SHIFT','2022-08-15','2022-11-30 13:14:52','2022-12-01 13:14:52','447',29357861.20,29357861.20,'447','2022-11-30 13:41:51','606','2022-11-30 13:43:33',10,0),('5','107',257623,'DAILY SHIFT','2022-08-16','2022-11-30 13:45:14','2022-12-01 13:45:14','447',42997812.10,42997812.10,'447','2022-11-30 13:58:32','606','2022-11-30 14:01:23',10,0),('5','107',257624,'DAILY SHIFT','2022-08-17','2022-11-30 14:05:59','2022-12-01 14:05:59','447',40493927.70,38793107.25,'447','2022-11-30 14:14:43','606','2022-11-30 14:23:15',10,0),('5','107',257625,'DAILY SHIFT','2022-08-18','2022-11-30 14:24:23','2022-12-01 14:24:23','447',34032238.80,32502870.60,'447','2022-11-30 14:54:16','606','2022-11-30 16:19:56',10,0),('5','107',257626,'DAILY SHIFT','2022-08-19','2022-11-30 16:24:23','2022-12-01 16:24:23','447',40905709.80,39009024.60,'447','2022-11-30 19:18:47','606','2022-11-30 19:22:52',10,0),('5','107',257627,'DAILY SHIFT','2022-08-20','2022-11-30 19:25:39','2022-12-01 19:25:39','447',37390373.00,35667992.00,'447','2022-11-30 19:34:50','606','2022-11-30 19:47:49',10,0),('5','107',257628,'DAILY SHIFT','2022-08-21','2022-11-30 19:49:52','2022-12-01 19:49:52','447',41091500.10,39315306.90,'447','2022-11-30 20:01:01','606','2022-11-30 20:07:45',10,0),('5','107',257629,'DAILY SHIFT','2022-08-22','2022-11-30 20:31:34','2022-12-01 20:31:34','447',28576335.60,27543456.00,'447','2022-11-30 20:36:00','606','2022-11-30 20:38:16',10,0),('5','107',257630,'DAILY SHIFT','2022-08-23','2022-11-30 20:39:56','2022-12-01 20:39:56','447',0.00,0.00,'447','2022-12-01 12:16:43','600','2022-12-01 12:26:14',10,0),('5','107',257631,'DAILY SHIFT','2022-08-23','2022-12-01 12:28:04','2022-12-02 12:28:04','447',39677613.40,37866315.10,'447','2022-12-01 12:36:38','600','2022-12-01 12:39:57',10,0),('5','107',257632,'DAILY SHIFT','2022-08-24','2022-12-01 12:41:38','2022-12-02 12:41:38','447',38557729.80,36796991.40,'447','2022-12-01 13:06:21','600','2022-12-01 13:07:08',10,0),('5','107',257633,'DAILY SHIFT','2022-08-25','2022-12-01 13:10:42','2022-12-02 13:10:42','447',34431839.70,32814551.55,'447','2022-12-01 13:36:46','600','2022-12-01 13:39:34',10,0),('5','107',257634,'DAILY SHIFT','2022-08-26','2022-12-01 13:53:32','2022-12-02 13:53:32','447',42037381.50,40127673.30,'447','2022-12-01 14:14:16','600','2022-12-01 14:14:49',10,0),('5','107',257635,'DAILY SHIFT','2022-08-27','2022-12-01 14:17:56','2022-12-02 14:17:56','447',40826457.50,38943107.45,'447','2022-12-01 14:25:46','600','2022-12-01 14:27:02',10,0),('5','107',257636,'DAILY SHIFT','2022-08-28','2022-12-01 14:31:10','2022-12-02 14:31:10','447',28201523.50,26989818.40,'447','2022-12-01 14:38:47','600','2022-12-01 14:39:40',10,0),('5','107',257637,'DAILY SHIFT','2022-08-29','2022-12-01 14:42:40','2022-12-02 14:42:40','447',30486600.10,29245381.15,'447','2022-12-01 14:49:30','600','2022-12-01 14:50:20',10,0),('5','107',257638,'DAILY SHIFT','2022-08-30','2022-12-01 14:51:35','2022-12-02 14:51:35','447',33917568.20,32332392.20,'447','2022-12-01 15:00:13','600','2022-12-01 15:01:08',10,0),('5','107',257639,'DAILY SHIFT','2022-08-31','2022-12-01 15:05:31','2022-12-02 15:05:31','447',41111230.30,39517476.25,'447','2022-12-01 15:10:47','600','2022-12-01 15:11:39',10,0),('5','107',257640,'DAILY SHIFT','2022-09-01','2022-12-01 15:19:08','2022-12-02 15:19:08','447',46398602.00,43423413.00,'447','2022-12-01 15:26:22','600','2022-12-01 15:28:03',10,0),('5','107',257641,'DAILY SHIFT','2022-09-02','2022-12-01 16:26:41','2022-12-02 16:26:41','447',31341488.40,30822431.85,'447','2022-12-01 16:37:36','600','2022-12-01 16:38:27',10,0),('5','107',257642,'DAILY SHIFT','2022-09-03','2022-12-01 16:40:21','2022-12-02 16:40:21','447',22238493.60,22161089.70,'447','2022-12-01 16:50:06','600','2022-12-01 16:50:31',10,0),('5','107',257643,'DAILY SHIFT','2022-09-04','2022-12-01 16:53:08','2022-12-02 16:53:08','447',29265846.00,29128156.80,'447','2022-12-01 16:58:02','600','2022-12-01 16:58:36',10,0),('5','107',257644,'DAILY SHIFT','2022-09-05','2022-12-01 21:14:04','2022-12-02 21:14:04','447',38340293.40,38340293.40,'447','2022-12-01 21:24:54','600','2022-12-01 21:27:01',10,0),('5','107',257645,'DAILY SHIFT','2022-09-06','2022-12-01 21:30:27','2022-12-02 21:30:27','447',41437934.40,41437934.40,'447','2022-12-01 21:42:08','600','2022-12-02 06:16:02',10,0),('5','107',257646,'DAILY SHIFT','2022-09-07','2022-12-02 11:04:32','2022-12-03 11:04:32','447',49497693.60,49497693.60,'447','2022-12-02 11:12:51','600','2022-12-02 11:13:55',10,0),('5','107',257647,'DAILY SHIFT','2022-09-08','2022-12-02 11:15:26','2022-12-03 11:15:26','447',41252271.60,41252271.60,'447','2022-12-02 11:23:47','600','2022-12-02 11:24:52',10,0),('5','107',257648,'DAILY SHIFT','2022-09-09','2022-12-02 11:26:28','2022-12-03 11:26:28','447',44058536.40,44058536.40,'447','2022-12-02 12:01:12','600','2022-12-02 12:01:42',10,0),('5','107',257649,'DAILY SHIFT','2022-09-10','2022-12-02 12:07:51','2022-12-03 12:07:51','447',36011193.60,36011193.60,'447','2022-12-05 10:18:45','600','2022-12-05 10:19:06',10,0),('5','107',257650,'DAILY SHIFT','2022-09-11','2022-12-05 10:20:14','2022-12-06 10:20:14','447',33172819.20,33172819.20,'447','2022-12-05 10:27:13','600','2022-12-05 10:29:53',10,0),('5','107',257651,'DAILY SHIFT','2022-09-12','2022-12-05 10:31:15','2022-12-06 10:31:15','447',35703922.80,35703922.80,'447','2022-12-05 10:36:49','600','2022-12-05 10:38:02',10,0),('5','107',257652,'DAILY SHIFT','2022-09-13','2022-12-05 10:42:57','2022-12-06 10:42:57','447',35006227.20,35006227.20,'447','2022-12-05 10:58:43','600','2022-12-05 10:59:30',10,0),('5','107',257653,'DAILY SHIFT','2022-09-14','2022-12-05 11:01:08','2022-12-06 11:01:08','447',41749211.40,41749211.40,'447','2022-12-05 11:09:11','600','2022-12-05 11:09:47',10,0),('5','107',257654,'DAILY SHIFT','2022-09-15','2022-12-05 11:10:59','2022-12-06 11:10:59','447',43521777.60,43521777.60,'447','2022-12-05 11:18:06','600','2022-12-05 11:18:45',10,0),('5','107',257655,'DAILY SHIFT','2022-09-16','2022-12-05 11:25:33','2022-12-06 11:25:33','447',35543959.80,35543959.80,'447','2022-12-05 11:38:04','600','2022-12-05 11:38:38',10,0),('5','107',257656,'DAILY SHIFT','2022-09-17','2022-12-05 11:44:51','2022-12-06 11:44:51','447',19350699.60,19350699.60,'447','2022-12-05 11:58:43','600','2022-12-05 12:03:10',10,0),('5','107',257657,'DAILY SHIFT','2022-09-18','2022-12-07 13:41:43','2022-12-08 13:41:43','447',25239137.40,25239137.40,'447','2022-12-07 15:40:17','606','2022-12-07 15:56:58',10,0),('5','107',257658,'DAILY SHIFT','2022-09-19','2022-12-07 16:13:08','2022-12-08 16:13:08','447',53428538.70,53428538.70,'447','2022-12-07 16:27:26','600','2022-12-07 16:28:52',10,0),('5','107',257659,'DAILY SHIFT','2022-09-20','2022-12-07 16:32:52','2022-12-08 16:32:52','447',13686462.45,13686462.45,'447','2022-12-07 17:01:04','600','2022-12-07 17:01:35',10,0),('5','107',257660,'DAILY SHIFT','2022-09-21','2022-12-08 09:22:15','2022-12-09 09:22:15','447',50645710.20,50645710.20,'447','2022-12-08 09:56:44','600','2022-12-08 09:58:58',10,0),('5','107',257661,'DAILY SHIFT','2022-09-22','2022-12-08 10:01:19','2022-12-09 10:01:19','447',32470503.95,32470503.95,'447','2022-12-08 10:56:32','600','2022-12-08 10:56:57',10,0),('5','107',257662,'DAILY SHIFT','2022-09-23','2022-12-08 11:06:47','2022-12-09 11:06:47','447',37403750.95,37403750.95,'447','2022-12-08 11:16:36','606','2022-12-08 11:18:52',10,0),('5','107',257663,'DAILY SHIFT','2022-09-24','2022-12-08 11:20:26','2022-12-09 11:20:26','447',46703692.10,46703692.10,'447','2022-12-08 12:42:25','600','2022-12-08 12:42:45',10,0),('5','107',257664,'DAILY SHIFT','2022-09-25','2022-12-08 12:43:36','2022-12-09 12:43:36','447',37895632.55,37895632.55,'447','2022-12-08 13:23:05','606','2022-12-08 13:25:17',10,0),('5','107',257665,'DAILY SHIFT','2022-09-26','2022-12-08 13:26:38','2022-12-09 13:26:38','447',41029345.70,41029345.70,'447','2022-12-08 14:30:04','600','2022-12-08 14:30:51',10,0),('5','107',257666,'DAILY SHIFT','2022-09-27','2022-12-08 14:31:41','2022-12-09 14:31:41','447',39308801.70,39308801.70,'447','2022-12-08 14:45:58','606','2022-12-08 14:48:36',10,0),('5','107',257667,'DAILY SHIFT','2022-09-28','2022-12-08 14:49:40','2022-12-09 14:49:40','447',43262522.70,43262522.70,'447','2022-12-08 15:02:15','600','2022-12-08 15:03:17',10,0),('5','107',257668,'DAILY SHIFT','2022-09-29','2022-12-08 15:14:45','2022-12-09 15:14:45','447',45153240.05,45153240.05,'447','2022-12-08 15:28:47','606','2022-12-08 15:39:29',10,0),('5','107',257669,'DAILY SHIFT','2022-09-30','2022-12-08 15:40:16','2022-12-09 15:40:16','447',42208047.10,42208047.10,'447','2022-12-08 16:18:36','600','2022-12-08 16:19:00',10,0),('5','107',257670,'DAILY SHIFT','2022-10-01','2022-12-08 16:21:57','2022-12-09 16:21:57','447',37031228.45,37031228.45,'447','2022-12-08 16:34:39','606','2022-12-08 16:37:37',10,0),('5','107',257671,'DAILY SHIFT','2022-10-02','2022-12-08 16:39:50','2022-12-09 16:39:50','447',36066010.65,36066010.65,'447','2022-12-08 17:01:36','606','2022-12-08 17:03:42',10,0),('5','107',257672,'DAILY SHIFT','2022-10-03','2022-12-09 08:57:44','2022-12-10 08:57:44','447',34712129.90,34712129.90,'447','2022-12-09 09:11:15','600','2022-12-09 09:11:49',10,0),('5','107',257673,'DAILY SHIFT','2022-10-04','2022-12-09 09:14:48','2022-12-10 09:14:48','447',29928578.00,29928578.00,'447','2022-12-09 09:25:38','600','2022-12-09 09:26:16',10,0),('5','107',257674,'DAILY SHIFT','2022-10-05','2022-12-09 09:31:01','2022-12-10 09:31:01','447',24621508.60,24621508.60,'447','2022-12-09 09:56:10','600','2022-12-09 09:56:49',10,0),('5','107',257675,'DAILY SHIFT','2022-10-06','2022-12-09 09:58:18','2022-12-10 09:58:18','447',31274263.95,31274263.95,'447','2022-12-09 10:05:28','600','2022-12-09 10:39:19',10,0),('5','107',257676,'DAILY SHIFT','2022-10-07','2022-12-09 10:40:53','2022-12-10 10:40:53','447',19172817.95,19172817.95,'447','2022-12-09 10:45:29','606','2022-12-09 10:52:01',10,0),('5','107',257677,'DAILY SHIFT','2022-10-08','2022-12-09 10:53:18','2022-12-10 10:53:18','447',26033765.05,26033765.05,'447','2022-12-09 11:12:48','600','2022-12-09 11:13:04',10,0),('5','107',257678,'DAILY SHIFT','2022-10-09','2022-12-09 11:13:55','2022-12-10 11:13:55','447',24042899.35,24042899.35,'447','2022-12-09 11:19:40','606','2022-12-09 11:24:13',10,0),('5','107',257679,'DAILY SHIFT','2022-10-10','2022-12-09 11:26:23','2022-12-10 11:26:23','447',24944786.50,24944786.50,'447','2022-12-09 11:31:06','606','2022-12-09 11:34:19',10,0),('5','107',257680,'DAILY SHIFT','2022-10-11','2022-12-09 11:36:48','2022-12-10 11:36:48','447',33484925.45,33484925.45,'447','2022-12-09 12:10:25','606','2022-12-09 12:11:23',10,0),('5','107',257681,'DAILY SHIFT','2022-10-12','2022-12-09 12:19:04','2022-12-10 12:19:04','447',26133288.70,26133288.70,'447','2022-12-09 12:24:51','606','2022-12-09 12:30:23',10,0),('5','107',257682,'DAILY SHIFT','2022-10-13','2022-12-09 13:22:14','2022-12-10 13:22:14','447',31406461.30,31406461.30,'447','2022-12-09 13:30:05','606','2022-12-09 13:32:20',10,0),('5','107',257683,'DAILY SHIFT','2022-10-14','2022-12-09 13:34:12','2022-12-10 13:34:12','447',25047383.10,25047383.10,'447','2022-12-09 13:41:20','606','2022-12-09 13:44:16',10,0),('5','107',257684,'DAILY SHIFT','2022-10-15','2022-12-09 13:45:13','2022-12-10 13:45:13','447',29937831.30,29937831.30,'447','2022-12-09 14:03:02','606','2022-12-09 14:05:23',10,0),('5','107',257685,'DAILY SHIFT','2022-10-16','2022-12-09 14:06:21','2022-12-10 14:06:21','447',23640872.10,23640872.10,'447','2022-12-09 14:14:48','606','2022-12-09 14:16:33',10,0),('5','107',257686,'DAILY SHIFT','2022-10-17','2022-12-09 14:20:58','2022-12-10 14:20:58','447',21843442.70,21843442.70,'447','2022-12-09 14:33:39','606','2022-12-09 14:34:48',10,0),('5','107',257687,'DAILY SHIFT','2022-10-18','2022-12-09 14:36:08','2022-12-10 14:36:08','447',14862270.50,14862270.50,'447','2022-12-09 14:42:42','606','2022-12-09 14:43:43',10,0),('5','107',257688,'DAILY SHIFT','2022-10-19','2022-12-09 14:45:39','2022-12-10 14:45:39','447',23693694.60,23693694.60,'447','2022-12-09 14:57:52','606','2022-12-09 14:58:27',10,0),('5','107',257689,'DAILY SHIFT','2022-10-20','2022-12-09 14:59:33','2022-12-10 14:59:33','447',33385123.80,33385123.80,'447','2022-12-09 15:07:15','606','2022-12-09 15:07:51',10,0),('5','107',257690,'DAILY SHIFT','2022-10-21','2022-12-09 15:09:19','2022-12-10 15:09:19','447',42164823.00,42164823.00,'447','2022-12-09 15:29:35','600','2022-12-09 15:30:11',10,0),('5','107',257691,'DAILY SHIFT','2022-10-22','2022-12-09 15:31:14','2022-12-10 15:31:14','447',42423933.00,42423933.00,'447','2022-12-09 15:42:45','600','2022-12-09 15:55:22',10,0),('5','107',257692,'DAILY SHIFT','2022-10-23','2022-12-09 15:57:26','2022-12-10 15:57:26','447',25259124.40,25259124.40,'447','2022-12-09 16:04:23','600','2022-12-09 16:08:51',10,0),('5','107',257693,'DAILY SHIFT','2022-10-24','2022-12-09 16:10:12','2022-12-10 16:10:12','447',36791742.00,36791742.00,'447','2022-12-09 16:17:01','600','2022-12-09 16:17:51',10,0),('5','107',257694,'DAILY SHIFT','2022-10-25','2022-12-09 16:18:34','2022-12-10 16:18:34','447',41202555.50,41202555.50,'447','2022-12-09 16:31:55','606','2022-12-09 16:33:48',10,0),('5','107',257695,'DAILY SHIFT','2022-10-26','2022-12-09 16:34:31','2022-12-10 16:34:31','447',45197693.70,45197693.70,'447','2022-12-12 10:33:43','600','2022-12-12 10:34:45',10,0),('5','107',257696,'DAILY SHIFT','2022-10-27','2022-12-12 10:35:39','2022-12-13 10:35:39','447',44650299.20,44650299.20,'447','2022-12-12 11:25:10','600','2022-12-12 11:29:10',10,0),('5','107',257697,'DAILY SHIFT','2022-10-28','2022-12-12 11:29:55','2022-12-13 11:29:55','447',47732138.80,47732138.80,'447','2022-12-12 11:56:58','600','2022-12-12 11:57:59',10,0),('5','107',257698,'DAILY SHIFT','2022-10-29','2022-12-12 11:58:39','2022-12-13 11:58:39','447',41984074.70,41984074.70,'447','2022-12-12 12:09:00','600','2022-12-12 12:09:37',10,0),('5','107',257699,'DAILY SHIFT','2022-10-30','2022-12-12 12:10:30','2022-12-13 12:10:30','447',36342471.70,36342471.70,'447','2022-12-12 12:19:54','600','2022-12-12 12:20:39',10,0),('5','107',257700,'DAILY SHIFT','2022-10-31','2022-12-12 12:21:34','2022-12-13 12:21:34','447',39846980.60,39846980.60,'600','2022-12-12 14:06:11','600','2022-12-12 14:06:35',10,0),('5','107',257701,'DAILY SHIFT','2022-11-01','2022-12-12 14:08:35','2022-12-13 14:08:35','447',45351137.60,45351137.60,'447','2022-12-12 15:13:07','600','2022-12-12 15:13:39',10,0),('5','107',257702,'DAILY SHIFT','2022-11-02','2022-12-12 15:14:29','2022-12-13 15:14:29','447',42845589.70,42845589.70,'447','2022-12-12 15:32:26','600','2022-12-12 15:33:04',10,0),('5','107',257703,'DAILY SHIFT','2022-11-03','2022-12-12 15:33:48','2022-12-13 15:33:48','447',43814278.40,43814278.40,'447','2022-12-12 16:21:04','600','2022-12-12 16:23:20',10,0),('5','107',257704,'DAILY SHIFT','2022-11-04','2022-12-12 16:23:57','2022-12-13 16:23:57','447',46783351.50,46783351.50,'447','2022-12-13 10:28:04','600','2022-12-13 10:29:27',10,0),('5','107',257705,'DAILY SHIFT','2022-11-05','2022-12-13 10:30:42','2022-12-14 10:30:42','447',34995234.70,34995234.70,'447','2022-12-13 11:06:37','600','2022-12-13 11:09:08',10,0),('5','107',257706,'DAILY SHIFT','2022-11-06','2022-12-13 11:30:10','2022-12-14 11:30:10','447',43511793.30,43511793.30,'447','2022-12-13 12:15:27','600','2022-12-13 12:16:16',10,0),('5','107',257707,'DAILY SHIFT','2022-11-07','2022-12-13 12:17:47','2022-12-14 12:17:47','447',61576418.60,61576418.60,'447','2022-12-13 13:19:07','600','2022-12-13 13:19:36',10,0),('5','107',257708,'DAILY SHIFT','2022-11-08','2022-12-13 13:20:35','2022-12-14 13:20:35','447',58615805.80,58615805.80,'447','2022-12-13 13:31:35','600','2022-12-13 13:32:35',10,0),('5','107',257709,'DAILY SHIFT','2022-11-09','2022-12-13 13:41:35','2022-12-14 13:41:35','447',68841626.20,68841626.20,'447','2022-12-13 14:16:32','600','2022-12-13 14:17:06',10,0),('5','107',257710,'DAILY SHIFT','2022-11-10','2022-12-13 14:17:46','2022-12-14 14:17:46','447',51810162.30,51810162.30,'447','2022-12-13 14:28:48','600','2022-12-13 14:29:18',10,0),('5','107',257711,'DAILY SHIFT','2022-11-11','2022-12-13 14:41:59','2022-12-14 14:41:59','447',55521138.70,55521138.70,'447','2022-12-13 14:55:57','600','2022-12-13 14:56:35',10,0),('5','107',257712,'DAILY SHIFT','2022-11-12','2022-12-13 14:57:20','2022-12-14 14:57:20','447',45543666.90,45543666.90,'447','2022-12-13 15:06:29','600','2022-12-13 15:06:56',10,0),('5','107',257713,'DAILY SHIFT','2022-11-13','2022-12-13 15:08:22','2022-12-14 15:08:22','447',33216462.90,33216462.90,'447','2022-12-13 15:19:40','600','2022-12-13 15:23:46',10,0),('5','107',257714,'DAILY SHIFT','2022-11-14','2022-12-13 15:26:07','2022-12-14 15:26:07','447',44607573.20,44607573.20,'447','2022-12-13 15:36:18','600','2022-12-13 15:37:34',10,0),('5','107',257715,'DAILY SHIFT','2022-11-15','2022-12-14 10:02:27','2022-12-15 10:02:27','447',54841054.80,54841054.80,'447','2022-12-14 10:08:45','600','2022-12-14 10:09:46',10,0),('5','107',257716,'DAILY SHIFT','2022-11-16','2022-12-14 10:11:02','2022-12-15 10:11:02','447',43723727.70,43723727.70,'447','2022-12-14 10:24:22','600','2022-12-14 10:25:06',10,0),('5','107',257717,'DAILY SHIFT','2022-11-17','2022-12-14 10:26:48','2022-12-15 10:26:48','447',57182481.90,57182481.90,'447','2022-12-14 10:35:42','600','2022-12-14 10:36:09',10,0),('5','107',257718,'DAILY SHIFT','2022-11-18','2022-12-14 10:39:19','2022-12-15 10:39:19','447',48364598.10,48364598.10,'447','2022-12-14 10:49:21','600','2022-12-14 10:49:53',10,0),('5','107',257719,'DAILY SHIFT','2022-11-19','2022-12-14 10:53:52','2022-12-15 10:53:52','447',55162625.70,55162625.70,'447','2022-12-14 11:18:06','600','2022-12-14 11:18:27',10,0),('5','107',257720,'DAILY SHIFT','2022-11-20','2022-12-14 11:19:10','2022-12-15 11:19:10','447',15249588.90,15249588.90,'447','2022-12-14 11:29:41','600','2022-12-14 11:30:33',10,0),('5','107',257721,'DAILY SHIFT','2022-11-21','2022-12-14 11:32:22','2022-12-15 11:32:22','447',34670945.10,34670945.10,'447','2022-12-14 11:39:53','600','2022-12-14 11:40:44',10,0),('5','107',257722,'DAILY SHIFT','2022-11-22','2022-12-14 11:41:23','2022-12-15 11:41:23','447',35954329.20,35954329.20,'447','2022-12-14 11:51:37','600','2022-12-14 11:53:02',10,0),('5','107',257723,'DAILY SHIFT','2022-11-23','2022-12-14 11:57:33','2022-12-15 11:57:33','447',47888734.65,47888734.65,'447','2022-12-14 12:05:09','600','2022-12-14 12:05:48',10,0),('5','107',257724,'DAILY SHIFT','2022-11-24','2022-12-14 12:06:34','2022-12-15 12:06:34','447',51296759.40,51296759.40,'447','2022-12-14 12:37:40','600','2022-12-14 12:38:25',10,0),('5','107',257725,'DAILY SHIFT','2022-11-25','2022-12-14 14:49:02','2022-12-15 14:49:02','447',23869098.60,23869098.60,'447','2022-12-14 14:58:49','600','2022-12-14 14:59:28',10,0),('5','107',257726,'DAILY SHIFT','2022-11-26','2022-12-14 15:00:39','2022-12-15 15:00:39','447',24602649.30,24602649.30,'447','2022-12-14 15:08:20','600','2022-12-14 15:08:58',10,0),('5','107',257727,'DAILY SHIFT','2022-11-27','2022-12-14 15:11:44','2022-12-15 15:11:44','447',31229033.20,31229033.20,'447','2022-12-14 15:32:44','600','2022-12-14 15:33:05',10,0),('5','107',257728,'DAILY SHIFT','2022-11-28','2022-12-14 15:33:41','2022-12-15 15:33:41','447',4480905.60,4480905.60,'447','2022-12-14 15:42:38','600','2022-12-14 15:42:56',10,0),('5','107',257729,'DAILY SHIFT','2022-11-29','2022-12-14 15:44:39','2022-12-15 15:44:39','447',5149596.60,5149596.60,'447','2022-12-14 16:07:40','600','2022-12-14 16:09:54',10,0),('5','107',257730,'DAILY SHIFT','2022-11-30','2022-12-14 16:12:18','2022-12-15 16:12:18','447',5996167.20,5996167.20,'447','2022-12-14 16:15:49','600','2022-12-14 16:19:19',10,0),('5','107',257731,'DAILY SHIFT','2022-12-01','2022-12-14 16:20:14','2022-12-15 16:20:14','447',3467102.40,3467102.40,'447','2022-12-14 16:41:16','600','2022-12-14 16:41:51',10,0),('5','107',257732,'DAILY SHIFT','2022-12-02','2022-12-15 10:03:14','2022-12-16 10:03:14','447',47730442.20,47730442.20,'447','2022-12-15 10:38:39','600','2022-12-15 10:40:20',10,0),('5','107',257733,'DAILY SHIFT','2022-12-03','2022-12-15 10:41:00','2022-12-16 10:41:00','447',27254332.90,27254332.90,'447','2022-12-15 10:49:20','600','2022-12-15 10:50:00',10,0),('5','107',257734,'DAILY SHIFT','2022-12-04','2022-12-15 10:51:21','2022-12-16 10:51:21','447',41070874.50,41288784.60,'447','2022-12-15 10:59:58','600','2022-12-15 11:01:50',10,0),('5','107',257735,'DAILY SHIFT','2022-12-05','2022-12-15 11:03:08','2022-12-16 11:03:08','447',37925799.00,38104325.20,'447','2022-12-15 11:12:42','600','2022-12-15 11:13:16',10,0),('5','107',257736,'DAILY SHIFT','2022-12-06','2022-12-15 11:13:54','2022-12-16 11:13:54','447',50378285.40,50628818.80,'447','2022-12-15 11:29:21','600','2022-12-15 11:29:52',10,0),('5','107',257737,'DAILY SHIFT','2022-12-07','2022-12-15 11:30:48','2022-12-16 11:30:48','447',39238217.10,39432636.00,'447','2022-12-15 12:09:59','600','2022-12-15 12:10:25',10,0),('5','107',257738,'DAILY SHIFT','2022-12-08','2022-12-15 12:11:01','2022-12-16 12:11:01','447',41635579.35,41847818.90,'447','2022-12-15 12:19:59','600','2022-12-15 12:23:39',10,0),('5','107',257739,'DAILY SHIFT','2022-12-09','2022-12-15 12:25:00','2022-12-16 12:25:00','447',33353870.70,33353870.70,'447','2022-12-15 12:34:04','600','2022-12-15 12:38:05',10,0),('5','107',257740,'DAILY SHIFT','2022-12-10','2022-12-15 12:38:52','2022-12-16 12:38:52','447',34846777.65,34846777.65,'447','2022-12-15 12:44:31','600','2022-12-15 13:06:55',10,0),('5','107',257741,'DAILY SHIFT','2022-12-11','2022-12-15 13:09:04','2022-12-16 13:09:04','447',31606102.35,31606102.35,'447','2022-12-15 13:16:20','600','2022-12-15 13:16:50',10,0),('5','107',257742,'DAILY SHIFT','2022-12-12','2022-12-15 13:18:56','2022-12-16 13:18:56','447',31724313.90,31724313.90,'447','2022-12-15 13:24:46','600','2022-12-15 13:25:18',10,0),('5','107',257743,'DAILY SHIFT','2022-12-13','2022-12-15 13:25:50','2022-12-16 13:25:50','447',37762791.00,37762791.00,'447','2022-12-15 13:36:41','600','2022-12-15 13:37:03',10,0),('5','107',257744,'DAILY SHIFT','2022-12-14','2022-12-15 13:39:38','2022-12-16 13:39:38','447',52563533.55,52563533.55,'447','2022-12-15 13:49:20','600','2022-12-15 13:49:54',10,0),('5','107',257745,'Daily shift','2022-12-15','2022-12-16 13:43:59','2022-12-17 13:43:59','447',49190662.65,49190662.65,'447','2022-12-16 16:31:35','606','2022-12-17 07:41:45',10,0),('5','107',257746,'Daily shift','2022-12-16','2022-12-17 10:45:50','2022-12-18 10:45:50','447',54024789.60,54024789.60,'447','2022-12-17 12:22:01','606','2022-12-17 12:44:24',10,0),('5','107',257747,'Daily shift','2022-12-17','2022-12-18 11:49:59','2022-12-19 11:49:59','447',55095391.80,55095391.80,'447','2022-12-18 17:44:52','606','2022-12-18 21:38:17',10,0),('5','107',257748,'Daily shift','2022-12-18','2022-12-19 07:54:08','2022-12-20 07:54:08','447',46309273.80,46309273.80,'447','2022-12-20 10:22:35','600','2022-12-20 10:25:34',10,0),('5','107',257749,'Daily shift','2022-12-19','2022-12-20 10:26:55','2022-12-21 10:26:55','447',60619177.05,60619177.05,'447','2022-12-20 14:09:56','606','2022-12-20 15:40:39',10,0),('5','107',257750,'Daily shift','2022-12-20','2022-12-20 20:39:06','2022-12-21 20:39:06','447',58975147.20,58975147.20,'447','2022-12-21 13:21:26','606','2022-12-21 13:27:02',10,0),('5','107',257751,'Daily shift','2022-12-21','2022-12-21 13:29:35','2022-12-22 13:29:35','447',59052682.20,59052682.20,'447','2022-12-22 09:48:38','606','2022-12-22 10:25:39',10,0),('5','107',257752,'Daily shift','2022-12-22','2022-12-23 09:53:02','2022-12-24 09:53:02','447',53344738.95,53344738.95,'447','2022-12-23 11:14:56','606','2022-12-23 13:27:10',10,0),('5','107',257753,'Daily shift','2022-12-23','2022-12-24 07:14:17','2022-12-25 07:14:17','447',48952432.35,48952432.35,'447','2022-12-24 13:03:48','606','2022-12-25 07:30:47',10,0),('5','107',257754,'Daily shift','2022-12-24','2022-12-25 09:57:12','2022-12-26 09:57:12','447',42811724.55,42811724.55,'447','2022-12-25 10:03:13','606','2022-12-25 19:24:20',10,0),('5','107',257755,'Daily shift','2022-12-25','2022-12-26 09:51:10','2022-12-27 09:51:10','447',37613500.05,37613500.05,'447','2022-12-26 10:41:45','606','2022-12-26 20:15:22',10,0),('5','107',257756,'Daily shift','2022-12-26','2022-12-27 09:32:34','2022-12-28 09:32:34','447',41405636.55,41405636.55,'447','2022-12-27 10:06:48','606','2022-12-28 11:02:57',10,0),('5','107',257757,'Daily shift','2022-12-27','2022-12-28 11:31:19','2022-12-29 11:31:19','447',39861355.80,39861355.80,'447','2022-12-28 11:36:03','606','2022-12-28 11:37:19',10,0),('5','107',257758,'Daily shift','2022-12-28','2022-12-28 11:38:19','2022-12-29 11:38:19','447',43280544.45,43280544.45,'447','2022-12-30 09:16:13','606','2022-12-30 10:10:36',10,0),('5','107',257759,'Daily shift','2022-12-29','2022-12-30 10:54:39','2022-12-31 10:54:39','447',40917444.00,40917444.00,'447','2022-12-30 12:26:12','606','2022-12-30 12:41:24',10,0),('5','107',257760,'Daily shift','2022-12-30','2022-12-31 10:01:20','2023-01-01 10:01:20','447',41769982.20,41769982.20,'447','2022-12-31 10:55:02','606','2023-01-01 11:26:06',10,0),('5','107',257761,'Daily shift','2022-12-31','2023-01-01 14:42:28','2023-01-02 14:42:28','447',36511816.65,36511816.65,'447','2023-01-02 10:30:45','606','2023-01-02 10:45:40',10,0),('5','107',257762,'Daily shift','2023-01-01','2023-01-02 10:47:23','2023-01-03 10:47:23','447',38644188.75,38644188.75,'447','2023-01-03 09:29:31','606','2023-01-03 10:35:43',10,0),('5','107',257763,'Daily shift','2023-01-02','2023-01-03 12:09:58','2023-01-04 12:09:58','447',41481007.80,42686851.05,'447','2023-01-03 15:53:40','606','2023-01-03 15:56:17',10,0),('5','107',257764,'Daily shift','2023-01-03','2023-01-03 16:31:49','2023-01-04 16:31:49','447',40506963.20,41684491.20,'447','2023-01-04 10:16:40','606','2023-01-04 10:26:06',10,0),('5','107',257765,'Daily shift','2023-01-04','2023-01-04 10:38:05','2023-01-05 10:38:05','447',44774051.00,46075622.25,'447','2023-01-05 10:41:32','606','2023-01-05 10:49:10',10,0),('5','107',257766,'Daily shift','2023-01-05','2023-01-05 11:27:36','2023-01-06 11:27:36','447',61024077.80,62798033.55,'447','2023-01-06 18:45:36','606','2023-01-06 20:29:56',10,0),('5','107',257767,'Daily shift','2023-01-06','2023-01-06 20:45:18','2023-01-07 20:45:18','447',0.00,0.00,'600','2023-01-07 10:21:40','600','2023-01-07 10:21:58',10,0),('5','107',257768,'Daily Shift ','2023-01-06','2023-01-07 10:22:33','2023-01-08 10:22:33','600',39583306.00,39583306.00,'447','2023-01-07 10:46:19','606','2023-01-07 15:37:11',10,0),('5','107',257769,'Daily shift','2023-01-07','2023-01-07 16:46:41','2023-01-08 16:46:41','447',51841109.60,51841109.60,'447','2023-01-08 11:02:55','606','2023-01-08 11:15:41',10,0),('5','107',257770,'Daily shift','2023-01-08','2023-01-08 11:53:43','2023-01-09 11:53:43','447',38083767.00,38083767.00,'447','2023-01-09 09:37:03','606','2023-01-09 10:06:28',10,0),('5','107',257771,'Daily shift','2023-01-09','2023-01-09 11:27:42','2023-01-10 11:27:42','447',35007555.60,35007555.60,'447','2023-01-10 09:47:08','606','2023-01-10 09:51:17',10,0),('5','107',257772,'Daily shift','2023-01-10','2023-01-10 13:51:14','2023-01-11 13:51:14','447',56157908.20,56157908.20,'447','2023-01-11 10:04:41','606','2023-01-11 10:53:26',10,0),('5','107',257773,'Daily shift','2023-01-11','2023-01-11 11:29:05','2023-01-12 11:29:05','447',55252533.20,55252533.20,'447','2023-01-12 10:00:11','606','2023-01-12 10:59:55',10,0),('5','107',257774,'Daily shift','2023-01-12','2023-01-12 14:50:15','2023-01-13 14:50:15','447',37931834.60,37931834.60,'447','2023-01-13 12:15:27','606','2023-01-13 12:18:35',10,0),('5','107',257775,'Daily shift','2023-01-13','2023-01-13 12:27:56','2023-01-14 12:27:56','447',28281495.60,28281495.60,'447','2023-01-14 10:13:55','606','2023-01-14 10:24:17',10,0),('5','107',257776,'Daily shift','2023-01-14','2023-01-14 11:10:26','2023-01-15 11:10:26','447',50355889.60,50355889.60,'447','2023-01-15 10:55:03','606','2023-01-15 11:33:37',10,0),('5','107',257777,'Daily shift','2023-01-15','2023-01-15 12:36:14','2023-01-16 12:36:14','447',51499690.60,51499690.60,'447','2023-01-16 09:54:53','606','2023-01-16 10:01:39',10,0),('5','107',257778,'Daily shift','2023-01-16','2023-01-16 10:06:33','2023-01-17 10:06:33','447',55631329.80,55631329.80,'447','2023-01-17 10:07:33','606','2023-01-17 10:21:23',10,0),('5','107',257779,'Daily shift','2023-01-17','2023-01-17 13:33:40','2023-01-18 13:33:40','447',59206806.90,59206806.90,'447','2023-01-18 11:29:36','606','2023-01-18 11:45:02',10,0),('5','107',257780,'Daily shift','2023-01-18','2023-01-18 14:44:37','2023-01-19 14:44:37','447',60872173.90,60872173.90,'447','2023-01-19 11:07:13','606','2023-01-19 11:24:02',10,0),('5','107',257781,'Daily shift','2023-01-19','2023-01-19 11:49:55','2023-01-20 11:49:55','447',54580476.30,54580476.30,'447','2023-01-20 09:07:06','606','2023-01-20 11:14:36',10,0),('5','107',257782,'Daily shift','2023-01-20','2023-01-20 14:26:43','2023-01-21 14:26:43','447',53357695.40,53357695.40,'447','2023-01-21 11:51:14','606','2023-01-21 12:18:58',10,0),('5','107',257783,'Daily shift','2023-01-21','2023-01-21 16:20:24','2023-01-22 16:20:24','447',74802957.60,73334222.00,'447','2023-01-22 13:17:02','606','2023-01-22 13:20:10',10,0),('5','107',257784,'Daily shift','2023-01-22','2023-01-22 13:33:28','2023-01-23 13:33:28','447',52087073.40,51071272.60,'447','2023-01-23 14:47:52','606','2023-01-23 14:49:25',10,0),('5','107',257785,'Daily shift','2023-01-23','2023-01-23 16:26:43','2023-01-24 16:26:43','447',57000171.60,57000171.60,'447','2023-01-24 14:03:13','606','2023-01-24 14:35:38',10,0),('5','107',257786,'Daily shift','2023-01-24','2023-01-24 14:40:30','2023-01-25 14:40:30','447',60819882.40,60819882.40,'447','2023-01-25 09:53:48','606','2023-01-25 10:00:51',10,0),('5','107',257787,'Daily shift','2023-01-25','2023-01-25 10:06:46','2023-01-26 10:06:46','447',47397410.30,47397410.30,'447','2023-01-26 10:21:26','606','2023-01-26 10:30:14',10,0),('5','107',257788,'Daily shift','2023-01-26','2023-01-26 10:52:21','2023-01-27 10:52:21','447',62270961.40,62270961.40,'447','2023-01-27 14:50:56','606','2023-01-27 15:09:13',10,0),('5','107',257789,'Daily shift','2023-01-27','2023-01-27 15:46:30','2023-01-28 15:46:30','447',43890728.50,43890728.50,'447','2023-01-28 15:12:33','600','2023-01-28 15:36:24',10,0),('5','107',257790,'Daily shift','2023-01-28','2023-01-28 23:04:35','2023-01-29 23:04:35','447',54953641.80,55602994.50,'447','2023-01-29 09:10:08','606','2023-01-29 09:23:59',10,0),('5','107',257791,'Daily shift','2023-01-30','2023-01-30 11:09:04','2023-01-31 11:09:04','447',37559583.40,38017627.10,'447','2023-01-30 11:17:56','606','2023-01-30 13:39:58',10,0),('5','107',257792,'Daily shift','2023-01-30','2023-01-30 13:57:47','2023-01-31 13:57:47','447',48402574.60,48992849.90,'447','2023-01-31 10:07:02','606','2023-01-31 10:14:05',10,0),('5','107',257793,'Daily shift','2023-01-31','2023-01-31 10:18:37','2023-02-01 10:18:37','447',59077744.60,59798204.90,'447','2023-02-01 10:59:16','606','2023-02-01 12:11:33',10,0),('5','107',257794,'Daily shift','2023-02-01','2023-02-01 12:54:48','2023-02-02 12:54:48','447',46142708.20,46652727.50,'447','2023-02-02 09:42:37','606','2023-02-02 10:39:59',10,0),('5','107',257795,'Daily shift','2023-02-02','2023-02-02 11:08:20','2023-02-03 11:08:20','447',51255688.40,51825454.60,'447','2023-02-03 08:27:29','606','2023-02-03 09:11:21',10,0),('5','107',257796,'Daily shift','2023-02-03','2023-02-03 09:23:40','2023-02-04 09:23:40','447',39187797.60,39641272.50,'447','2023-02-04 10:17:37','606','2023-02-04 10:19:23',10,0),('5','107',257797,'Daily shift','2023-02-04','2023-02-04 10:43:24','2023-02-05 10:43:24','447',57351888.80,57983846.00,'447','2023-02-05 09:21:33','606','2023-02-05 09:41:05',10,0),('5','107',257798,'Daily shift','2023-02-05','2023-02-05 12:56:04','2023-02-06 12:56:04','447',44109306.60,44625039.10,'447','2023-02-06 10:15:01','606','2023-02-06 10:19:31',10,0),('5','107',257799,'Daily shift','2023-02-06','2023-02-06 10:59:51','2023-02-07 10:59:51','447',40368460.60,40860758.90,'447','2023-02-07 10:29:01','606','2023-02-07 10:44:15',10,0),('5','107',257800,'Daily shift','2023-02-07','2023-02-07 14:57:36','2023-02-08 14:57:36','447',54766945.20,55311788.40,'600','2023-02-08 13:41:06','606','2023-02-08 15:46:56',10,0),('5','107',257801,'Daily shift','2023-02-08','2023-02-09 11:33:02','2023-02-10 11:33:02','447',53199803.20,53788903.90,'447','2023-02-09 11:43:37','606','2023-02-09 12:45:57',10,0),('5','107',257802,'Daily shift','2023-02-09','2023-02-09 18:07:51','2023-02-10 18:07:51','447',63907848.80,64580456.20,'447','2023-02-10 11:32:25','606','2023-02-10 11:35:01',10,0),('5','107',257803,'Daily shift','2023-02-10','2023-02-10 14:27:25','2023-02-11 14:27:25','447',46217619.00,46781248.50,'447','2023-02-11 14:49:59','606','2023-02-11 15:09:46',10,0),('5','107',257804,'Daily shift','2023-02-11','2023-02-11 22:40:09','2023-02-12 22:40:09','447',46853356.80,47424739.20,'447','2023-02-12 09:31:29','606','2023-02-12 09:40:13',10,0),('5','107',257805,'Daily shift','2023-02-12','2023-02-12 12:15:43','2023-02-13 12:15:43','447',39270669.20,39749579.80,'447','2023-02-13 10:14:34','606','2023-02-13 10:23:40',10,0),('5','107',257806,'Daily shift','2023-02-13','2023-02-14 10:16:26','2023-02-15 10:16:26','447',34456137.60,34876334.40,'447','2023-02-14 10:21:24','606','2023-02-14 10:37:51',10,0),('5','107',257807,'Daily shift','2023-02-14','2023-02-14 11:18:08','2023-02-15 11:18:08','447',44240648.20,44780168.30,'447','2023-02-15 08:19:16','606','2023-02-16 08:35:14',10,0),('5','107',257808,'Daily shift','2023-02-15','2023-02-16 09:24:18','2023-02-17 09:24:18','447',40062141.40,40550704.10,'447','2023-02-16 09:45:14','606','2023-02-16 09:52:29',10,0),('5','107',257809,'Daily shift','2023-02-16','2023-02-16 09:58:33','2023-02-17 09:58:33','447',43476678.80,44006882.20,'447','2023-02-18 11:01:21','606','2023-02-18 11:14:15',10,0),('5','107',257810,'DAILY SHIFT','2023-02-17','2023-02-20 10:05:28','2023-02-21 10:05:28','447',27518117.60,27518117.60,'447','2023-02-20 10:57:13','606','2023-02-20 11:02:17',10,0),('5','107',257811,'DAILY SHIFT','2023-02-18','2023-02-20 11:04:58','2023-02-21 11:04:58','447',22348714.60,22348714.60,'447','2023-02-20 11:42:10','606','2023-02-20 11:49:50',10,0),('5','107',257812,'DAILY SHIFT','2023-02-19','2023-02-20 14:50:52','2023-02-21 14:50:52','447',22601061.40,22601061.40,'447','2023-02-22 12:41:24','606','2023-02-22 12:43:21',10,0),('5','107',257813,'Daily shift','2023-02-20','2023-02-22 12:45:33','2023-02-23 12:45:33','447',19224252.20,19458694.30,'447','2023-02-22 12:50:03','606','2023-02-22 13:04:21',10,0),('5','107',257814,'Daily shift','2023-02-21','2023-02-22 13:08:00','2023-02-23 13:08:00','447',21668368.80,21932617.20,'447','2023-02-22 13:14:15','606','2023-02-22 14:51:39',10,0),('5','107',257815,'Daily shift','2023-02-22','2023-02-22 16:22:58','2023-02-23 16:22:58','447',23482897.60,23769274.40,'447','2023-02-23 12:42:05','606','2023-02-23 13:17:07',10,0),('5','107',257816,'Daily shift','2023-02-23','2023-02-24 10:57:11','2023-02-25 10:57:11','447',8660659.60,8766277.40,'447','2023-02-24 11:04:38','606','2023-02-24 13:53:24',10,0),('5','107',257817,'Daily shift','2023-02-24','2023-02-24 13:54:18','2023-02-25 13:54:18','447',3240951.60,3280475.40,'447','2023-02-26 17:03:39','606','2023-02-27 09:46:07',10,0),('5','107',257818,'Daily shift','2023-02-27','2023-02-27 10:57:34','2023-02-28 10:57:34','447',16598381.80,16976219.80,'447','2023-02-28 11:09:21','606','2023-02-28 12:02:01',10,0),('5','107',257819,'Daily shift','2023-02-28','2023-03-01 10:22:38','2023-03-02 10:22:38','447',17012159.20,17311771.80,'447','2023-03-02 10:03:25','606','2023-03-02 10:05:31',10,0),('5','107',257820,'Daily shift','2023-03-01','2023-03-02 10:07:40','2023-03-03 10:07:40','447',30909788.40,30909788.40,'447','2023-03-02 10:19:51','606','2023-03-02 10:23:32',10,0),('5','107',257821,'Daily shift','2023-03-02','2023-03-02 10:25:53','2023-03-03 10:25:53','447',43217519.70,43217519.70,'447','2023-03-03 10:57:15','606','2023-03-03 11:26:24',10,0),('5','107',257822,'Daily shift','2023-03-03','2023-03-04 10:44:41','2023-03-05 10:44:41','447',45958257.00,45958257.00,'447','2023-03-04 12:59:15','606','2023-03-04 13:23:41',10,0),('5','107',257823,'Daily shift','2023-03-04','2023-03-04 20:44:04','2023-03-05 20:44:04','447',59724803.90,59724803.90,'447','2023-03-05 14:57:37','606','2023-03-05 16:46:29',10,0),('5','107',257824,'Daily shift','2023-03-05','2023-03-06 11:22:06','2023-03-07 11:22:06','447',45294574.10,44351988.70,'447','2023-03-07 10:11:08','606','2023-03-07 10:11:57',10,0),('5','107',257825,'Daily shift','2023-03-06','2023-03-07 12:28:41','2023-03-08 12:28:41','447',66629734.50,65317297.50,'447','2023-03-08 07:04:10','606','2023-03-08 07:11:51',10,0),('5','107',257826,'Daily shift','2023-03-07','2023-03-08 07:14:44','2023-03-09 07:14:44','447',55950492.20,55950492.20,'447','2023-03-08 16:43:44','606','2023-03-08 17:03:26',10,0),('5','107',257827,'Daily shift','2023-03-08','2023-03-08 17:13:00','2023-03-09 17:13:00','447',40522110.00,40522110.00,'447','2023-03-09 12:09:44','606','2023-03-09 12:34:43',10,0),('5','107',257828,'Daily shift','2023-03-09','2023-03-09 13:49:00','2023-03-10 13:49:00','447',42727938.10,42727938.10,'447','2023-03-10 12:28:00','606','2023-03-10 12:32:49',10,0),('5','107',257829,'Daily shift','2023-03-10','2023-03-10 14:37:51','2023-03-11 14:37:51','447',45653623.90,45653623.90,'447','2023-03-11 10:21:46','606','2023-03-12 07:02:03',10,0),('5','107',257830,'Daily shift','2023-03-11','2023-03-12 10:57:40','2023-03-13 10:57:40','447',43354448.90,43354448.90,'447','2023-03-12 11:06:03','606','2023-03-12 11:27:40',10,0),('5','107',257831,'Daily shift','2023-03-12','2023-03-12 11:30:09','2023-03-13 11:30:09','447',53130395.10,53130395.10,'447','2023-03-13 13:39:26','606','2023-03-13 13:45:37',10,0),('5','107',257832,'Daily shift','2023-03-13','2023-03-13 20:21:54','2023-03-14 20:21:54','447',51612420.50,51612420.50,'447','2023-03-14 09:42:24','606','2023-03-14 09:46:56',10,0),('5','107',257833,'daily shift','2023-03-14','2023-03-15 10:47:52','2023-03-16 10:47:52','447',42196408.00,42196408.00,'447','2023-03-15 14:12:24','606','2023-03-15 14:15:48',10,0),('5','107',257834,'Daily shift','2023-03-15','2023-03-15 14:16:19','2023-03-16 14:16:19','447',43720744.00,43720744.00,'447','2023-03-16 11:17:46','606','2023-03-16 11:26:21',10,0),('5','107',257835,'Daily shift','2023-03-16','2023-03-16 11:39:47','2023-03-17 11:39:47','447',42714408.00,42714408.00,'447','2023-03-17 10:26:34','606','2023-03-17 10:40:16',10,0),('5','107',257836,'Daily shift','2023-03-17','2023-03-17 10:45:05','2023-03-18 10:45:05','447',21550296.00,21550296.00,'447','2023-03-19 11:33:10','606','2023-03-20 08:27:29',10,0),('5','107',257837,'Daily shift','2023-03-19','2023-03-20 08:35:17','2023-03-21 08:35:17','447',23060096.00,23060096.00,'447','2023-03-20 08:45:57','606','2023-03-20 08:47:35',10,0),('5','107',257838,'daily shift','2023-03-20','2023-03-20 08:50:03','2023-03-21 08:50:03','447',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4929582 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('5','107','694','110682',2195237,'1875','290',1208.31,1300.13,91.82,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','694','110682',2195238,'1876','290',1150.90,1250.01,99.11,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','694','110682',2195239,'1877','290',1096.32,1196.32,100.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','694','110682',2195240,'1878','290',1094.78,1195.01,100.23,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','694','110682',2195241,'1879','290',1057.63,1157.16,99.53,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','694','110682',2195242,'1880','290',1108.41,1206.41,98.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','695','110682',2195243,'1881','290',1510.60,1610.60,100.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','695','110682',2195244,'1882','290',1401.13,1501.13,100.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','695','110682',2195245,'1883','290',1156.95,1256.95,100.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','695','110682',2195246,'1884','290',1189.22,1289.22,100.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','110682',2195247,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','110682',2195248,'1886','290',1018.56,1018.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','110682',2195249,'1887','290',1191.39,1191.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','110682',2195250,'1888','290',1333.72,1333.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','110682',2195251,'1889','290',1069.41,1069.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','110682',2195252,'1890','290',1121.23,1121.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','110682',2195253,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','110682',2195254,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','110682',2195255,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','110682',2195256,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','110682',2195257,'1895','290',1312.26,1312.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','110682',2195258,'1896','290',1303.58,1303.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','110682',2195259,'1897','290',1159.45,1159.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','110682',2195260,'1898','290',1074.95,1074.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','110682',2195261,'1899','290',1172.35,1272.35,100.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','110682',2195262,'1900','290',1418.17,1518.17,100.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','110682',2195263,'1901','290',1044.25,1144.25,100.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','110682',2195264,'1902','290',1083.44,1182.04,98.60,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','110682',2195265,'1903','290',1175.40,1175.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','110682',2195266,'1904','290',1051.75,1051.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','110682',2195267,'1905','290',1324.40,1324.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','110682',2195268,'1906','290',1051.34,1051.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','110682',2195269,'1907','290',1032.99,1032.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','110682',2195270,'1908','290',1162.13,1162.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','110682',2195271,'1909','290',1211.84,1211.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','110682',2195272,'1910','290',1174.08,1174.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','110682',2195273,'1911','290',1295.89,1295.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','110682',2195274,'1912','290',1061.49,1061.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','110682',2195275,'1913','290',1079.79,1079.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','110682',2195276,'1914','290',1110.69,1110.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','110682',2195277,'1915','290',1062.69,1062.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','110682',2195278,'1916','290',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','110682',2195279,'1917','290',1292.88,1292.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','110682',2195280,'1918','290',1253.88,1253.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','110682',2195281,'1919','290',1030.79,1030.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','110682',2195282,'1920','290',1093.65,1093.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','110682',2195283,'1921','290',1202.16,1202.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','110682',2195284,'1922','290',1109.56,1109.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','110682',2195285,'1923','290',1023.18,1023.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','110682',2195286,'1924','290',1054.01,1054.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','110682',2195287,'1925','290',1130.54,1230.11,99.57,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','110682',2195288,'1926','290',1195.83,1295.83,100.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','110682',2195289,'1927','290',1003.58,1106.10,102.52,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','110682',2195290,'1928','290',1025.29,1124.91,99.62,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','110682',2195291,'1929','291',1990.97,1990.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','110682',2195292,'1930','291',1979.32,1979.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','707','110682',2195293,'1931','291',1086.32,1086.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','707','110682',2195294,'1932','291',1277.19,1277.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','110682',2195295,'1933','291',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','110682',2195296,'1934','291',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','694','114489',2272239,'1875','290',1300.13,1300.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','694','114489',2272240,'1876','290',1250.01,1250.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','694','114489',2272241,'1877','290',1196.32,1196.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','694','114489',2272242,'1878','290',1195.01,1346.67,151.66,21232.40,0.00,0.00,0.00,0.00,0.00),('5','107','694','114489',2272243,'1879','290',1157.16,1157.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','694','114489',2272244,'1880','290',1206.41,1247.14,40.73,5702.20,0.00,0.00,0.00,0.00,0.00),('5','107','695','114489',2272245,'1881','290',1610.60,1610.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','695','114489',2272246,'1882','290',1501.13,1510.19,9.06,1268.40,0.00,0.00,0.00,0.00,0.00),('5','107','695','114489',2272247,'1883','290',1256.95,1256.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','695','114489',2272248,'1884','290',1289.22,1289.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','114489',2272249,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','114489',2272250,'1886','290',1018.56,1018.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','114489',2272251,'1887','290',1191.39,1191.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','114489',2272252,'1888','290',1333.72,1333.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','114489',2272253,'1889','290',1069.41,1069.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','114489',2272254,'1890','290',1121.23,1121.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','114489',2272255,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','114489',2272256,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','114489',2272257,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','114489',2272258,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','114489',2272259,'1895','290',1312.26,1312.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','114489',2272260,'1896','290',1303.58,1303.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','114489',2272261,'1897','290',1159.45,1159.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','114489',2272262,'1898','290',1074.95,1074.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','114489',2272263,'1899','290',1272.35,1272.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','114489',2272264,'1900','290',1518.17,1523.87,5.70,798.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','114489',2272265,'1901','290',1144.25,1144.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','114489',2272266,'1902','290',1182.04,1182.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','114489',2272267,'1903','290',1175.40,1175.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','114489',2272268,'1904','290',1051.75,1051.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','114489',2272269,'1905','290',1324.40,1324.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','114489',2272270,'1906','290',1051.34,1051.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','114489',2272271,'1907','290',1032.99,1032.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','114489',2272272,'1908','290',1162.13,1162.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','114489',2272273,'1909','290',1211.84,1211.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','114489',2272274,'1910','290',1174.08,1174.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','114489',2272275,'1911','290',1295.89,1295.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','114489',2272276,'1912','290',1061.49,1061.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','114489',2272277,'1913','290',1079.79,1079.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','114489',2272278,'1914','290',1110.69,1110.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','114489',2272279,'1915','290',1062.69,1062.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','114489',2272280,'1916','290',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','114489',2272281,'1917','290',1292.88,1292.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','114489',2272282,'1918','290',1253.88,1253.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','114489',2272283,'1919','290',1030.79,1030.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','114489',2272284,'1920','290',1093.65,1093.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','114489',2272285,'1921','290',1202.16,1202.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','114489',2272286,'1922','290',1109.56,1109.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','114489',2272287,'1923','290',1023.18,1023.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','114489',2272288,'1924','290',1054.01,1054.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','114489',2272289,'1925','290',1230.11,1230.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','114489',2272290,'1926','290',1295.83,1300.93,5.10,714.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','114489',2272291,'1927','290',1106.10,1106.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','114489',2272292,'1928','290',1124.91,1124.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','114489',2272293,'1929','291',1990.97,2676.67,685.70,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','114489',2272294,'1930','291',1979.32,1979.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','707','114489',2272295,'1931','291',1086.32,1086.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','707','114489',2272296,'1932','291',1277.19,1277.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','114489',2272297,'1933','291',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','114489',2272298,'1934','291',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','694','114491',2272342,'1875','290',1300.13,1300.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','694','114491',2272343,'1876','290',1250.01,1250.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','694','114491',2272344,'1877','290',1196.32,1674.33,478.01,66921.40,0.00,0.00,0.00,0.00,0.00),('5','107','694','114491',2272345,'1878','290',1346.67,1346.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','694','114491',2272346,'1879','290',1157.16,1813.32,656.16,91862.40,0.00,0.00,0.00,0.00,0.00),('5','107','694','114491',2272347,'1880','290',1247.14,1247.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','695','114491',2272348,'1881','290',1610.60,2344.62,734.02,102762.80,0.00,0.00,0.00,0.00,0.00),('5','107','695','114491',2272349,'1882','290',1510.19,1510.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','695','114491',2272350,'1883','290',1256.95,1256.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','695','114491',2272351,'1884','290',1289.22,1289.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','114491',2272352,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','114491',2272353,'1886','290',1018.56,1018.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','114491',2272354,'1887','290',1191.39,1191.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','114491',2272355,'1888','290',1333.72,1333.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','114491',2272356,'1889','290',1069.41,1069.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','114491',2272357,'1890','290',1121.23,1121.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','114491',2272358,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','114491',2272359,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','114491',2272360,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','114491',2272361,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','114491',2272362,'1895','290',1312.26,1312.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','114491',2272363,'1896','290',1303.58,1303.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','114491',2272364,'1897','290',1159.45,1159.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','114491',2272365,'1898','290',1074.95,1074.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','114491',2272366,'1899','290',1272.35,1496.96,224.61,31445.40,0.00,0.00,0.00,0.00,0.00),('5','107','699','114491',2272367,'1900','290',1523.87,1523.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','114491',2272368,'1901','290',1144.25,1144.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','114491',2272369,'1902','290',1182.04,1182.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','114491',2272370,'1903','290',1175.40,1175.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','114491',2272371,'1904','290',1051.75,1051.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','114491',2272372,'1905','290',1324.40,1324.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','114491',2272373,'1906','290',1051.34,1051.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','114491',2272374,'1907','290',1032.99,1032.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','114491',2272375,'1908','290',1162.13,1162.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','114491',2272376,'1909','290',1211.84,1211.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','114491',2272377,'1910','290',1174.08,1174.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','114491',2272378,'1911','290',1295.89,1295.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','114491',2272379,'1912','290',1061.49,1061.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','114491',2272380,'1913','290',1079.79,1079.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','114491',2272381,'1914','290',1110.69,1110.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','114491',2272382,'1915','290',1062.69,1062.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','114491',2272383,'1916','290',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','114491',2272384,'1917','290',1292.88,1292.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','114491',2272385,'1918','290',1253.88,1253.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','114491',2272386,'1919','290',1030.79,1030.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','114491',2272387,'1920','290',1093.65,1093.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','114491',2272388,'1921','290',1202.16,1202.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','114491',2272389,'1922','290',1109.56,1109.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','114491',2272390,'1923','290',1023.18,1023.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','114491',2272391,'1924','290',1054.01,1054.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','114491',2272392,'1925','290',1230.11,2416.30,1186.19,166066.60,0.00,0.00,0.00,0.00,0.00),('5','107','705','114491',2272393,'1926','290',1300.93,1300.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','114491',2272394,'1927','290',1106.10,1106.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','114491',2272395,'1928','290',1124.91,1124.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','114491',2272396,'1929','291',2676.67,2676.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','114491',2272397,'1930','291',1979.32,2663.45,684.13,147087.95,0.00,0.00,0.00,0.00,0.00),('5','107','707','114491',2272398,'1931','291',1086.32,1086.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','707','114491',2272399,'1932','291',1277.19,1277.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','114491',2272400,'1933','291',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','114491',2272401,'1934','291',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','694','114494',2272448,'1875','290',1300.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','694','114494',2272449,'1876','290',1250.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','694','114494',2272450,'1877','290',1674.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','694','114494',2272451,'1878','290',1346.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','694','114494',2272452,'1879','290',1813.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','694','114494',2272453,'1880','290',1247.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','695','114494',2272454,'1881','290',2344.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','695','114494',2272455,'1882','290',1510.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','695','114494',2272456,'1883','290',1256.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','695','114494',2272457,'1884','290',1289.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','114494',2272458,'1885','290',1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','114494',2272459,'1886','290',1018.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','114494',2272460,'1887','290',1191.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','114494',2272461,'1888','290',1333.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','114494',2272462,'1889','290',1069.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','114494',2272463,'1890','290',1121.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','114494',2272464,'1891','290',1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','114494',2272465,'1892','290',1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','114494',2272466,'1893','290',1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','114494',2272467,'1894','290',1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','114494',2272468,'1895','290',1312.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','114494',2272469,'1896','290',1303.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','114494',2272470,'1897','290',1159.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','114494',2272471,'1898','290',1074.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','114494',2272472,'1899','290',1496.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','114494',2272473,'1900','290',1523.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','114494',2272474,'1901','290',1144.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','114494',2272475,'1902','290',1182.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','114494',2272476,'1903','290',1175.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','114494',2272477,'1904','290',1051.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','114494',2272478,'1905','290',1324.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','114494',2272479,'1906','290',1051.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','114494',2272480,'1907','290',1032.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','114494',2272481,'1908','290',1162.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','114494',2272482,'1909','290',1211.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','114494',2272483,'1910','290',1174.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','114494',2272484,'1911','290',1295.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','114494',2272485,'1912','290',1061.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','114494',2272486,'1913','290',1079.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','114494',2272487,'1914','290',1110.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','114494',2272488,'1915','290',1062.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','114494',2272489,'1916','290',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','114494',2272490,'1917','290',1292.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','114494',2272491,'1918','290',1253.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','114494',2272492,'1919','290',1030.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','114494',2272493,'1920','290',1093.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','114494',2272494,'1921','290',1202.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','114494',2272495,'1922','290',1109.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','114494',2272496,'1923','290',1023.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','114494',2272497,'1924','290',1054.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','114494',2272498,'1925','290',2416.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','114494',2272499,'1926','290',1300.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','114494',2272500,'1927','290',1106.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','114494',2272501,'1928','290',1124.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','114494',2272502,'1929','291',2676.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','114494',2272503,'1930','291',2663.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','707','114494',2272504,'1931','291',1086.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','707','114494',2272505,'1932','291',1277.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','114494',2272506,'1933','291',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','114494',2272507,'1934','291',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','216677',4188305,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','216677',4188306,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','216677',4188307,'1877','290',712234.14,716507.93,4273.79,705175.35,0.00,0.00,0.00,0.00,0.00),('5','107','696','216677',4188308,'1878','290',174203.11,174203.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','216677',4188309,'1879','290',820226.77,820937.58,710.81,117283.65,0.00,0.00,0.00,0.00,0.00),('5','107','696','216677',4188310,'1880','290',103641.69,103641.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','216677',4188311,'1881','290',1200266.69,1200266.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','216677',4188312,'1882','290',1009628.29,1009628.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','216677',4188313,'1883','290',505646.82,505646.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','216677',4188314,'1884','290',113480.65,113480.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','216677',4188315,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','216677',4188316,'1886','290',1884066.27,1884066.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','216677',4188317,'1887','290',205734.14,205734.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','216677',4188318,'1888','290',114175.98,114175.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','216677',4188319,'1889','290',2774653.00,2782308.75,7655.75,1263198.75,0.00,0.00,0.00,0.00,0.00),('5','107','696','216677',4188320,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','216677',4188321,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','216677',4188322,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','216677',4188323,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','216677',4188324,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','216677',4188325,'1895','290',655546.49,656365.83,819.34,135191.10,0.00,0.00,0.00,0.00,0.00),('5','107','698','216677',4188326,'1896','290',196896.16,200473.75,3577.59,590302.35,0.00,0.00,0.00,0.00,0.00),('5','107','698','216677',4188327,'1897','290',386159.54,386867.65,708.11,116838.15,0.00,0.00,0.00,0.00,0.00),('5','107','698','216677',4188328,'1898','290',63143.69,63143.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','216677',4188329,'1899','290',1801744.01,1801744.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','216677',4188330,'1900','290',401704.38,401704.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','216677',4188331,'1901','290',980763.56,980763.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','216677',4188332,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','216677',4188333,'1903','290',1053551.30,1053551.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','216677',4188334,'1904','290',1019544.92,1019544.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','216677',4188335,'1905','290',1480015.54,1480015.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','216677',4188336,'1906','290',515521.96,515521.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','216677',4188337,'1907','290',1808777.38,1808777.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','216677',4188338,'1908','290',597930.87,597930.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','216677',4188339,'1909','290',441355.40,441355.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','216677',4188340,'1910','290',368531.48,368531.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','216677',4188341,'1911','290',983612.88,987067.61,3454.73,570030.45,0.00,0.00,0.00,0.00,0.00),('5','107','702','216677',4188342,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','216677',4188343,'1913','290',539870.36,545156.89,5286.53,872277.45,0.00,0.00,0.00,0.00,0.00),('5','107','702','216677',4188344,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','216677',4188345,'1915','290',219416.96,220534.11,1117.15,184329.75,0.00,0.00,0.00,0.00,0.00),('5','107','702','216677',4188346,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','216677',4188347,'1917','290',868111.65,873338.72,5227.07,862466.55,0.00,0.00,0.00,0.00,0.00),('5','107','703','216677',4188348,'1918','290',132925.87,132925.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','216677',4188349,'1919','290',417420.57,418650.30,1229.73,202905.45,0.00,0.00,0.00,0.00,0.00),('5','107','703','216677',4188350,'1920','290',95447.88,95447.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','216677',4188351,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','216677',4188352,'1922','290',68216.25,68216.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','216677',4188353,'1923','290',720977.72,720977.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','216677',4188354,'1924','290',69026.52,69026.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','216677',4188355,'1925','290',1401426.71,1404880.81,3454.10,569926.50,0.00,0.00,0.00,0.00,0.00),('5','107','705','216677',4188356,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','216677',4188357,'1927','290',411687.78,414143.11,2455.33,405129.45,0.00,0.00,0.00,0.00,0.00),('5','107','705','216677',4188358,'1928','290',98426.66,98426.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','216677',4188359,'1929','291',3105914.43,3113814.49,7900.06,2330517.70,0.00,0.00,0.00,0.00,0.00),('5','107','706','216677',4188360,'1930','291',2151951.84,2155462.93,3511.09,1035771.55,0.00,0.00,0.00,0.00,0.00),('5','107','706','216677',4188361,'1931','291',3339081.51,3344194.61,5113.10,1508364.50,0.00,0.00,0.00,0.00,0.00),('5','107','706','216677',4188362,'1932','291',2865926.63,2868806.69,2880.06,849617.70,0.00,0.00,0.00,0.00,0.00),('5','107','706','216677',4188363,'1933','291',2613307.81,2616055.32,2747.51,810515.45,0.00,0.00,0.00,0.00,0.00),('5','107','708','216677',4188364,'1934','291',1407262.27,1409536.38,2274.11,670862.45,0.00,0.00,0.00,0.00,0.00),('5','107','706','216677',4188365,'2898','291',3800168.91,3804763.55,4594.64,1355418.80,0.00,0.00,0.00,0.00,0.00),('5','107','708','216677',4188366,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','216698',4188722,'1875','290',1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','216698',4188723,'1876','290',1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','216698',4188724,'1877','290',716507.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','216698',4188725,'1878','290',174203.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','216698',4188726,'1879','290',820937.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','216698',4188727,'1880','290',103641.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','216698',4188728,'1881','290',1200266.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','216698',4188729,'1882','290',1009628.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','216698',4188730,'1883','290',505646.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','216698',4188731,'1884','290',113480.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','216698',4188732,'1885','290',1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','216698',4188733,'1886','290',1884066.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','216698',4188734,'1887','290',205734.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','216698',4188735,'1888','290',114175.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','216698',4188736,'1889','290',2782308.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','216698',4188737,'1890','290',682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','216698',4188738,'1891','290',1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','216698',4188739,'1892','290',1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','216698',4188740,'1893','290',1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','216698',4188741,'1894','290',1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','216698',4188742,'1895','290',656365.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','216698',4188743,'1896','290',200473.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','216698',4188744,'1897','290',386867.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','216698',4188745,'1898','290',63143.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','216698',4188746,'1899','290',1801744.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','216698',4188747,'1900','290',401704.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','216698',4188748,'1901','290',980763.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','216698',4188749,'1902','290',36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','216698',4188750,'1903','290',1053551.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','216698',4188751,'1904','290',1019544.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','216698',4188752,'1905','290',1480015.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','216698',4188753,'1906','290',515521.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','216698',4188754,'1907','290',1808777.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','216698',4188755,'1908','290',597930.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','216698',4188756,'1909','290',441355.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','216698',4188757,'1910','290',368531.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','216698',4188758,'1911','290',987067.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','216698',4188759,'1912','290',196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','216698',4188760,'1913','290',545156.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','216698',4188761,'1914','290',64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','216698',4188762,'1915','290',220534.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','216698',4188763,'1916','290',22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','216698',4188764,'1917','290',873338.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','216698',4188765,'1918','290',132925.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','216698',4188766,'1919','290',418650.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','216698',4188767,'1920','290',95447.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','216698',4188768,'1921','290',922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','216698',4188769,'1922','290',68216.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','216698',4188770,'1923','290',720977.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','216698',4188771,'1924','290',69026.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','216698',4188772,'1925','290',1404880.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','216698',4188773,'1926','290',45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','216698',4188774,'1927','290',414143.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','216698',4188775,'1928','290',98426.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','216698',4188776,'1929','291',3113814.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','216698',4188777,'1930','291',2155462.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','216698',4188778,'1931','291',3344194.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','216698',4188779,'1932','291',2868806.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','216698',4188780,'1933','291',2616055.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','216698',4188781,'1934','291',1409536.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','216698',4188782,'2898','291',3804763.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','216698',4188783,'2899','291',3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','216722',4189298,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','216722',4189299,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','216722',4189300,'1877','290',716507.93,718478.88,1970.95,325206.75,0.00,0.00,0.00,0.00,0.00),('5','107','696','216722',4189301,'1878','290',174203.11,175330.29,1127.18,185984.70,0.00,0.00,0.00,0.00,0.00),('5','107','696','216722',4189302,'1879','290',820937.58,821871.94,934.36,154169.40,0.00,0.00,0.00,0.00,0.00),('5','107','696','216722',4189303,'1880','290',103641.69,104424.43,782.74,129152.10,0.00,0.00,0.00,0.00,0.00),('5','107','697','216722',4189304,'1881','290',1200266.69,1200266.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','216722',4189305,'1882','290',1009628.29,1009628.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','216722',4189306,'1883','290',505646.82,505646.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','216722',4189307,'1884','290',113480.65,113480.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','216722',4189308,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','216722',4189309,'1886','290',1884066.27,1884066.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','216722',4189310,'1887','290',205734.14,205734.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','216722',4189311,'1888','290',114175.98,114175.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','216722',4189312,'1889','290',2782308.75,2786557.72,4248.97,701080.05,0.00,0.00,0.00,0.00,0.00),('5','107','696','216722',4189313,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','216722',4189314,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','216722',4189315,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','216722',4189316,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','216722',4189317,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','216722',4189318,'1895','290',656365.83,658760.77,2394.94,395165.10,0.00,0.00,0.00,0.00,0.00),('5','107','698','216722',4189319,'1896','290',200473.75,203137.46,2663.71,439512.15,0.00,0.00,0.00,0.00,0.00),('5','107','698','216722',4189320,'1897','290',386867.65,389312.49,2444.84,403398.60,0.00,0.00,0.00,0.00,0.00),('5','107','698','216722',4189321,'1898','290',63143.69,63143.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','216722',4189322,'1899','290',1801744.01,1801744.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','216722',4189323,'1900','290',401704.38,401704.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','216722',4189324,'1901','290',980763.56,980763.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','216722',4189325,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','216722',4189326,'1903','290',1053551.30,1053551.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','216722',4189327,'1904','290',1019544.92,1024438.04,4893.12,807364.80,0.00,0.00,0.00,0.00,0.00),('5','107','700','216722',4189328,'1905','290',1480015.54,1480015.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','216722',4189329,'1906','290',515521.96,520065.98,4544.02,749763.30,0.00,0.00,0.00,0.00,0.00),('5','107','701','216722',4189330,'1907','290',1808777.38,1808777.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','216722',4189331,'1908','290',597930.87,597930.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','216722',4189332,'1909','290',441355.40,441355.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','216722',4189333,'1910','290',368531.48,368531.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','216722',4189334,'1911','290',987067.61,992502.98,5435.37,896836.05,0.00,0.00,0.00,0.00,0.00),('5','107','702','216722',4189335,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','216722',4189336,'1913','290',545156.89,549469.79,4312.90,711628.50,0.00,0.00,0.00,0.00,0.00),('5','107','702','216722',4189337,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','216722',4189338,'1915','290',220534.11,221901.32,1367.21,225589.65,0.00,0.00,0.00,0.00,0.00),('5','107','702','216722',4189339,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','216722',4189340,'1917','290',873338.72,873338.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','216722',4189341,'1918','290',132925.87,132925.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','216722',4189342,'1919','290',418650.30,418650.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','216722',4189343,'1920','290',95447.88,95447.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','216722',4189344,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','216722',4189345,'1922','290',68216.25,68216.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','216722',4189346,'1923','290',720977.72,720977.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','216722',4189347,'1924','290',69026.52,69026.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','216722',4189348,'1925','290',1404880.81,1410166.72,5285.91,872175.15,0.00,0.00,0.00,0.00,0.00),('5','107','705','216722',4189349,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','216722',4189350,'1927','290',414143.11,414143.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','216722',4189351,'1928','290',98426.66,99750.81,1324.15,218484.75,0.00,0.00,0.00,0.00,0.00),('5','107','706','216722',4189352,'1929','291',3113814.49,3120111.99,6297.50,1857762.50,0.00,0.00,0.00,0.00,0.00),('5','107','706','216722',4189353,'1930','291',2155462.93,2159495.10,4032.17,1189490.15,0.00,0.00,0.00,0.00,0.00),('5','107','706','216722',4189354,'1931','291',3344194.61,3349872.90,5678.29,1675095.55,0.00,0.00,0.00,0.00,0.00),('5','107','706','216722',4189355,'1932','291',2868806.69,2873052.58,4245.89,1252537.55,0.00,0.00,0.00,0.00,0.00),('5','107','706','216722',4189356,'1933','291',3804763.55,3810673.21,5909.66,1743349.70,0.00,0.00,0.00,0.00,0.00),('5','107','708','216722',4189357,'1934','291',1409536.38,1421920.48,12384.10,3653309.50,0.00,0.00,0.00,0.00,0.00),('5','107','706','216722',4189358,'2898','291',2616055.32,2621512.46,5457.14,1609856.30,0.00,0.00,0.00,0.00,0.00),('5','107','708','216722',4189359,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','216954',4193391,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','216954',4193392,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','216954',4193393,'1877','290',718478.88,718478.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','216954',4193394,'1878','290',175330.29,175330.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','216954',4193395,'1879','290',821871.94,821871.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','216954',4193396,'1880','290',104424.43,104424.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','216954',4193397,'1881','290',1200266.69,1200266.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','216954',4193398,'1882','290',1009628.29,1011280.80,1652.51,272664.15,0.00,0.00,0.00,0.00,0.00),('5','107','697','216954',4193399,'1883','290',505646.82,506716.52,1069.70,176500.50,0.00,0.00,0.00,0.00,0.00),('5','107','697','216954',4193400,'1884','290',113480.65,113480.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','216954',4193401,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','216954',4193402,'1886','290',1884066.27,1888586.01,4519.74,745757.10,0.00,0.00,0.00,0.00,0.00),('5','107','697','216954',4193403,'1887','290',205734.14,205734.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','216954',4193404,'1888','290',114175.98,114175.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','216954',4193405,'1889','290',2786557.72,2786557.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','216954',4193406,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','216954',4193407,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','216954',4193408,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','216954',4193409,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','216954',4193410,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','216954',4193411,'1895','290',658760.77,658760.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','216954',4193412,'1896','290',203137.46,206615.76,3478.30,573919.50,0.00,0.00,0.00,0.00,0.00),('5','107','698','216954',4193413,'1897','290',389312.49,391612.88,2300.39,379564.35,0.00,0.00,0.00,0.00,0.00),('5','107','698','216954',4193414,'1898','290',63143.69,63143.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','216954',4193415,'1899','290',1801744.01,1801744.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','216954',4193416,'1900','290',401704.38,401704.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','216954',4193417,'1901','290',980763.56,980781.33,17.77,2932.05,0.00,0.00,0.00,0.00,0.00),('5','107','699','216954',4193418,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','216954',4193419,'1903','290',1053551.30,1053551.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','216954',4193420,'1904','290',1024438.04,1029268.69,4830.65,797057.25,0.00,0.00,0.00,0.00,0.00),('5','107','700','216954',4193421,'1905','290',1480015.54,1480015.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','216954',4193422,'1906','290',520065.98,522953.64,2887.66,476463.90,0.00,0.00,0.00,0.00,0.00),('5','107','701','216954',4193423,'1907','290',1808777.38,1808784.60,7.22,1191.30,0.00,0.00,0.00,0.00,0.00),('5','107','701','216954',4193424,'1908','290',597930.87,600795.42,2864.55,472650.75,0.00,0.00,0.00,0.00,0.00),('5','107','701','216954',4193425,'1909','290',441355.40,441355.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','216954',4193426,'1910','290',368531.48,370016.78,1485.30,245074.50,0.00,0.00,0.00,0.00,0.00),('5','107','702','216954',4193427,'1911','290',992502.98,995438.24,2935.26,484317.90,0.00,0.00,0.00,0.00,0.00),('5','107','702','216954',4193428,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','216954',4193429,'1913','290',549469.79,550630.16,1160.37,191461.05,0.00,0.00,0.00,0.00,0.00),('5','107','702','216954',4193430,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','216954',4193431,'1915','290',221901.32,221901.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','216954',4193432,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','216954',4193433,'1917','290',873338.72,876162.89,2824.17,465988.05,0.00,0.00,0.00,0.00,0.00),('5','107','703','216954',4193434,'1918','290',132925.87,132925.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','216954',4193435,'1919','290',418650.30,418650.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','216954',4193436,'1920','290',95447.88,95447.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','216954',4193437,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','216954',4193438,'1922','290',68216.25,68216.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','216954',4193439,'1923','290',720977.72,720977.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','216954',4193440,'1924','290',69026.52,69026.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','216954',4193441,'1925','290',1410166.72,1414875.85,4709.13,777006.45,0.00,0.00,0.00,0.00,0.00),('5','107','705','216954',4193442,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','216954',4193443,'1927','290',414143.11,414143.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','216954',4193444,'1928','290',99750.81,100922.94,1172.13,193401.45,0.00,0.00,0.00,0.00,0.00),('5','107','706','216954',4193445,'1929','291',3120111.99,3129095.86,8983.87,2650241.65,0.00,0.00,0.00,0.00,0.00),('5','107','706','216954',4193446,'1930','291',2159495.10,2163599.30,4104.20,1210739.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','216954',4193447,'1931','291',3349872.90,3355116.46,5243.56,1546850.20,0.00,0.00,0.00,0.00,0.00),('5','107','706','216954',4193448,'1932','291',2873052.58,2878392.75,5340.17,1575350.15,0.00,0.00,0.00,0.00,0.00),('5','107','706','216954',4193449,'1933','291',3810673.21,3816279.87,5606.66,1653964.70,0.00,0.00,0.00,0.00,0.00),('5','107','708','216954',4193450,'1934','291',1421920.48,1421954.37,33.89,9997.55,0.00,0.00,0.00,0.00,0.00),('5','107','706','216954',4193451,'2898','291',2621512.46,2626434.36,4921.90,1451960.50,0.00,0.00,0.00,0.00,0.00),('5','107','708','216954',4193452,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217103',4195753,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217103',4195754,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217103',4195755,'1877','290',718478.88,718478.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217103',4195756,'1878','290',175330.29,175330.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217103',4195757,'1879','290',821871.94,821871.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217103',4195758,'1880','290',104424.43,104424.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217103',4195759,'1881','290',1200266.69,1200266.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217103',4195760,'1882','290',1011280.80,1014854.20,3573.40,589611.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217103',4195761,'1883','290',506716.52,507908.73,1192.21,196714.65,0.00,0.00,0.00,0.00,0.00),('5','107','697','217103',4195762,'1884','290',113480.65,113480.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217103',4195763,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217103',4195764,'1886','290',1888586.01,1895104.05,6518.04,1075476.60,0.00,0.00,0.00,0.00,0.00),('5','107','697','217103',4195765,'1887','290',205734.14,205734.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217103',4195766,'1888','290',114175.98,114175.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217103',4195767,'1889','290',2786557.72,2786557.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217103',4195768,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217103',4195769,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217103',4195770,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217103',4195771,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217103',4195772,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217103',4195773,'1895','290',658760.77,658760.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217103',4195774,'1896','290',206615.76,208098.95,1483.19,244726.35,0.00,0.00,0.00,0.00,0.00),('5','107','698','217103',4195775,'1897','290',391612.88,393002.07,1389.19,229216.35,0.00,0.00,0.00,0.00,0.00),('5','107','698','217103',4195776,'1898','290',63143.69,63143.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','217103',4195777,'1899','290',1801744.01,1801744.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','217103',4195778,'1900','290',401704.38,401704.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','217103',4195779,'1901','290',980781.33,980781.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','217103',4195780,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','217103',4195781,'1903','290',1053551.30,1053551.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','217103',4195782,'1904','290',1029268.69,1033915.42,4646.73,766710.45,0.00,0.00,0.00,0.00,0.00),('5','107','700','217103',4195783,'1905','290',1480015.54,1480015.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','217103',4195784,'1906','290',522953.64,528160.61,5206.97,859150.05,0.00,0.00,0.00,0.00,0.00),('5','107','701','217103',4195785,'1907','290',1808784.60,1813647.68,4863.08,802408.20,0.00,0.00,0.00,0.00,0.00),('5','107','701','217103',4195786,'1908','290',600795.42,600795.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','217103',4195787,'1909','290',441355.40,441355.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','217103',4195788,'1910','290',370016.78,370016.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217103',4195789,'1911','290',995438.24,998739.51,3301.27,544709.55,0.00,0.00,0.00,0.00,0.00),('5','107','702','217103',4195790,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217103',4195791,'1913','290',550630.16,550941.57,311.41,51382.65,0.00,0.00,0.00,0.00,0.00),('5','107','702','217103',4195792,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217103',4195793,'1915','290',221901.32,221901.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217103',4195794,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','217103',4195795,'1917','290',876162.89,878181.22,2018.33,333024.45,0.00,0.00,0.00,0.00,0.00),('5','107','703','217103',4195796,'1918','290',132925.87,132925.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','217103',4195797,'1919','290',418650.30,418650.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','217103',4195798,'1920','290',95447.88,95447.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217103',4195799,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217103',4195800,'1922','290',68216.25,68216.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217103',4195801,'1923','290',720977.72,720977.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217103',4195802,'1924','290',69026.52,69026.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','217103',4195803,'1925','290',1414875.85,1418855.65,3979.80,656667.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','217103',4195804,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','217103',4195805,'1927','290',414143.11,422447.08,8303.97,1370155.05,0.00,0.00,0.00,0.00,0.00),('5','107','705','217103',4195806,'1928','290',100922.94,100922.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','217103',4195807,'1929','291',3129095.86,3138786.37,9690.51,2858700.45,0.00,0.00,0.00,0.00,0.00),('5','107','706','217103',4195808,'1930','291',2163599.30,2169187.13,5587.83,1648409.85,0.00,0.00,0.00,0.00,0.00),('5','107','706','217103',4195809,'1931','291',3355116.46,3357919.75,2803.29,826970.55,0.00,0.00,0.00,0.00,0.00),('5','107','706','217103',4195810,'1932','291',2878392.75,2882134.51,3741.76,1103819.20,0.00,0.00,0.00,0.00,0.00),('5','107','706','217103',4195811,'1933','291',3816279.87,3822460.36,6180.49,1823244.55,0.00,0.00,0.00,0.00,0.00),('5','107','708','217103',4195812,'1934','291',1421954.37,1428877.24,6922.87,2042246.65,0.00,0.00,0.00,0.00,0.00),('5','107','706','217103',4195813,'2898','291',2626434.36,2629840.43,3406.07,1004790.65,0.00,0.00,0.00,0.00,0.00),('5','107','708','217103',4195814,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217116',4196083,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217116',4196084,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217116',4196085,'1877','290',718478.88,721035.28,2556.40,421806.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217116',4196086,'1878','290',175330.29,175330.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217116',4196087,'1879','290',821871.94,822398.50,526.56,86882.40,0.00,0.00,0.00,0.00,0.00),('5','107','696','217116',4196088,'1880','290',104424.43,104424.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217116',4196089,'1881','290',1200266.69,1200275.78,9.09,1499.85,0.00,0.00,0.00,0.00,0.00),('5','107','697','217116',4196090,'1882','290',1014854.20,1017784.47,2930.27,483494.55,0.00,0.00,0.00,0.00,0.00),('5','107','697','217116',4196091,'1883','290',507908.73,510084.19,2175.46,358950.90,0.00,0.00,0.00,0.00,0.00),('5','107','697','217116',4196092,'1884','290',113480.65,113480.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217116',4196093,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217116',4196094,'1886','290',1895104.05,1901235.73,6131.68,1011727.20,0.00,0.00,0.00,0.00,0.00),('5','107','697','217116',4196095,'1887','290',205734.14,205734.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217116',4196096,'1888','290',114175.98,114175.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217116',4196097,'1889','290',2786557.72,2791185.53,4627.81,763588.65,0.00,0.00,0.00,0.00,0.00),('5','107','696','217116',4196098,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217116',4196099,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217116',4196100,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217116',4196101,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217116',4196102,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217116',4196103,'1895','290',658760.77,659531.18,770.41,127117.65,0.00,0.00,0.00,0.00,0.00),('5','107','698','217116',4196104,'1896','290',208098.95,208845.06,746.11,123108.15,0.00,0.00,0.00,0.00,0.00),('5','107','698','217116',4196105,'1897','290',393002.07,393455.37,453.30,74794.50,0.00,0.00,0.00,0.00,0.00),('5','107','698','217116',4196106,'1898','290',63143.69,63143.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','217116',4196107,'1899','290',1801744.01,1801744.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','217116',4196108,'1900','290',401704.38,401704.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','217116',4196109,'1901','290',980781.33,980781.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','217116',4196110,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','217116',4196111,'1903','290',1053551.30,1053551.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','217116',4196112,'1904','290',1033915.42,1037553.62,3638.20,600303.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','217116',4196113,'1905','290',1480015.54,1480015.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','217116',4196114,'1906','290',528160.61,530835.00,2674.39,441274.35,0.00,0.00,0.00,0.00,0.00),('5','107','701','217116',4196115,'1907','290',1813647.68,1817630.85,3983.17,657223.05,0.00,0.00,0.00,0.00,0.00),('5','107','701','217116',4196116,'1908','290',600795.42,600795.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','217116',4196117,'1909','290',441355.40,441355.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','217116',4196118,'1910','290',370016.78,373175.37,3158.59,521167.35,0.00,0.00,0.00,0.00,0.00),('5','107','702','217116',4196119,'1911','290',998739.51,998794.57,55.06,9084.90,0.00,0.00,0.00,0.00,0.00),('5','107','702','217116',4196120,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217116',4196121,'1913','290',550941.57,550941.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217116',4196122,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217116',4196123,'1915','290',221901.32,221901.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217116',4196124,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','217116',4196125,'1917','290',878181.22,880717.45,2536.23,418477.95,0.00,0.00,0.00,0.00,0.00),('5','107','703','217116',4196126,'1918','290',132925.87,132925.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','217116',4196127,'1919','290',418650.30,418849.27,198.97,32830.05,0.00,0.00,0.00,0.00,0.00),('5','107','703','217116',4196128,'1920','290',95447.88,95447.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217116',4196129,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217116',4196130,'1922','290',68216.25,68216.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217116',4196131,'1923','290',720977.72,720977.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217116',4196132,'1924','290',69026.52,69026.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','217116',4196133,'1925','290',1418855.65,1419537.84,682.19,112561.35,0.00,0.00,0.00,0.00,0.00),('5','107','705','217116',4196134,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','217116',4196135,'1927','290',422447.08,422696.85,249.77,41212.05,0.00,0.00,0.00,0.00,0.00),('5','107','705','217116',4196136,'1928','290',100922.94,100922.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','217116',4196137,'1929','291',3138786.37,3138786.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','217116',4196138,'1930','291',2169187.13,2169187.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','217116',4196139,'1931','291',3357919.75,3362510.44,4590.69,1354253.55,0.00,0.00,0.00,0.00,0.00),('5','107','706','217116',4196140,'1932','291',2882134.51,2886270.32,4135.81,1220063.95,0.00,0.00,0.00,0.00,0.00),('5','107','706','217116',4196141,'1933','291',3822460.36,3830152.60,7692.24,2269210.80,0.00,0.00,0.00,0.00,0.00),('5','107','708','217116',4196142,'1934','291',1428877.24,1428877.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','217116',4196143,'2898','291',2629840.43,2633960.16,4119.73,1215320.35,0.00,0.00,0.00,0.00,0.00),('5','107','708','217116',4196144,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217135',4196396,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217135',4196397,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217135',4196398,'1877','290',721035.28,723563.94,2528.66,417228.90,0.00,0.00,0.00,0.00,0.00),('5','107','696','217135',4196399,'1878','290',175330.29,175330.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217135',4196400,'1879','290',822398.50,824682.62,2284.12,376879.80,0.00,0.00,0.00,0.00,0.00),('5','107','696','217135',4196401,'1880','290',104424.43,104424.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217135',4196402,'1881','290',1200275.78,1200275.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217135',4196403,'1882','290',1017784.47,1020013.18,2228.71,367737.15,0.00,0.00,0.00,0.00,0.00),('5','107','697','217135',4196404,'1883','290',510084.19,512940.80,2856.61,471340.65,0.00,0.00,0.00,0.00,0.00),('5','107','697','217135',4196405,'1884','290',113480.65,113480.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217135',4196406,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217135',4196407,'1886','290',1901235.73,1906439.74,5204.01,858661.65,0.00,0.00,0.00,0.00,0.00),('5','107','697','217135',4196408,'1887','290',205734.14,205734.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217135',4196409,'1888','290',114175.98,117890.90,3714.92,612961.80,0.00,0.00,0.00,0.00,0.00),('5','107','696','217135',4196410,'1889','290',2791185.53,2797500.47,6314.94,1041965.10,0.00,0.00,0.00,0.00,0.00),('5','107','696','217135',4196411,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217135',4196412,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217135',4196413,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217135',4196414,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217135',4196415,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217135',4196416,'1895','290',659531.18,659531.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217135',4196417,'1896','290',208845.06,210058.88,1213.82,200280.30,0.00,0.00,0.00,0.00,0.00),('5','107','698','217135',4196418,'1897','290',393455.37,394495.97,1040.60,171699.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217135',4196419,'1898','290',63143.69,63143.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','217135',4196420,'1899','290',1801744.01,1801744.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','217135',4196421,'1900','290',401704.38,401704.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','217135',4196422,'1901','290',980781.33,980781.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','217135',4196423,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','217135',4196424,'1903','290',1053551.30,1053551.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','217135',4196425,'1904','290',1037553.62,1039868.20,2314.58,381905.70,0.00,0.00,0.00,0.00,0.00),('5','107','700','217135',4196426,'1905','290',1480015.54,1480015.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','217135',4196427,'1906','290',530835.00,534027.98,3192.98,526841.70,0.00,0.00,0.00,0.00,0.00),('5','107','701','217135',4196428,'1907','290',1817630.85,1821928.20,4297.35,709062.75,0.00,0.00,0.00,0.00,0.00),('5','107','701','217135',4196429,'1908','290',600795.42,600795.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','217135',4196430,'1909','290',441355.40,442552.30,1196.90,197488.50,0.00,0.00,0.00,0.00,0.00),('5','107','701','217135',4196431,'1910','290',373175.37,373175.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217135',4196432,'1911','290',998794.57,998794.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217135',4196433,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217135',4196434,'1913','290',550941.57,550941.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217135',4196435,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217135',4196436,'1915','290',221901.32,221901.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217135',4196437,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','217135',4196438,'1917','290',880717.45,883092.10,2374.65,391817.25,0.00,0.00,0.00,0.00,0.00),('5','107','703','217135',4196439,'1918','290',132925.87,134006.38,1080.51,178284.15,0.00,0.00,0.00,0.00,0.00),('5','107','703','217135',4196440,'1919','290',418849.27,419983.73,1134.46,187185.90,0.00,0.00,0.00,0.00,0.00),('5','107','703','217135',4196441,'1920','290',95447.88,95447.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217135',4196442,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217135',4196443,'1922','290',68216.25,68216.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217135',4196444,'1923','290',720977.72,720977.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217135',4196445,'1924','290',69026.52,69026.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','217135',4196446,'1925','290',1419537.84,1419537.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','217135',4196447,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','217135',4196448,'1927','290',422696.85,422696.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','217135',4196449,'1928','290',100922.94,100922.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','217135',4196450,'1929','291',3138786.37,3154975.91,16189.54,4775914.30,0.00,0.00,0.00,0.00,0.00),('5','107','706','217135',4196451,'1930','291',2169187.13,2180141.22,10954.09,3231456.55,0.00,0.00,0.00,0.00,0.00),('5','107','706','217135',4196452,'1931','291',3362510.44,3368906.88,6396.44,1886949.80,0.00,0.00,0.00,0.00,0.00),('5','107','706','217135',4196453,'1932','291',2886270.32,2889801.88,3531.56,1041810.20,0.00,0.00,0.00,0.00,0.00),('5','107','706','217135',4196454,'1933','291',3830152.60,3837201.81,7049.21,2079516.95,0.00,0.00,0.00,0.00,0.00),('5','107','708','217135',4196455,'1934','291',1428877.24,1431484.81,2607.57,769233.15,0.00,0.00,0.00,0.00,0.00),('5','107','706','217135',4196456,'2898','291',2633960.16,2638395.75,4435.59,1308499.05,0.00,0.00,0.00,0.00,0.00),('5','107','708','217135',4196457,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217156',4196807,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217156',4196808,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217156',4196809,'1877','290',723563.94,727133.45,3569.51,588969.15,0.00,0.00,0.00,0.00,0.00),('5','107','696','217156',4196810,'1878','290',175330.29,175330.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217156',4196811,'1879','290',824682.62,825590.72,908.10,149836.50,0.00,0.00,0.00,0.00,0.00),('5','107','696','217156',4196812,'1880','290',104424.43,104424.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217156',4196813,'1881','290',1200275.78,1200275.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217156',4196814,'1882','290',1020013.18,1020013.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217156',4196815,'1883','290',512940.80,512940.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217156',4196816,'1884','290',113480.65,113480.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217156',4196817,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217156',4196818,'1886','290',1906439.74,1906439.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217156',4196819,'1887','290',205734.14,205734.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217156',4196820,'1888','290',117890.90,117890.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217156',4196821,'1889','290',2797500.47,2804209.60,6709.13,1107006.45,0.00,0.00,0.00,0.00,0.00),('5','107','696','217156',4196822,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217156',4196823,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217156',4196824,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217156',4196825,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217156',4196826,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217156',4196827,'1895','290',659531.18,660448.52,917.34,151361.10,0.00,0.00,0.00,0.00,0.00),('5','107','698','217156',4196828,'1896','290',210058.88,211684.25,1625.37,268186.05,0.00,0.00,0.00,0.00,0.00),('5','107','698','217156',4196829,'1897','290',394495.97,394598.91,102.94,16985.10,0.00,0.00,0.00,0.00,0.00),('5','107','698','217156',4196830,'1898','290',63143.69,63143.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','217156',4196831,'1899','290',1801744.01,1803778.65,2034.64,335715.60,0.00,0.00,0.00,0.00,0.00),('5','107','699','217156',4196832,'1900','290',401704.38,401704.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','217156',4196833,'1901','290',980781.33,983564.28,2782.95,459186.75,0.00,0.00,0.00,0.00,0.00),('5','107','699','217156',4196834,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','217156',4196835,'1903','290',1053551.30,1053551.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','217156',4196836,'1904','290',1039868.20,1039868.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','217156',4196837,'1905','290',1480015.54,1480015.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','217156',4196838,'1906','290',534027.98,534027.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','217156',4196839,'1907','290',1821928.20,1827774.35,5846.15,964614.75,0.00,0.00,0.00,0.00,0.00),('5','107','701','217156',4196840,'1908','290',600795.42,600795.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','217156',4196841,'1909','290',442552.30,442552.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','217156',4196842,'1910','290',373175.37,373175.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217156',4196843,'1911','290',998794.57,1002075.63,3281.06,541374.90,0.00,0.00,0.00,0.00,0.00),('5','107','702','217156',4196844,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217156',4196845,'1913','290',550941.57,552898.80,1957.23,322942.95,0.00,0.00,0.00,0.00,0.00),('5','107','702','217156',4196846,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217156',4196847,'1915','290',221901.32,223177.56,1276.24,210579.60,0.00,0.00,0.00,0.00,0.00),('5','107','702','217156',4196848,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','217156',4196849,'1917','290',883092.10,888250.04,5157.94,851060.10,0.00,0.00,0.00,0.00,0.00),('5','107','703','217156',4196850,'1918','290',134006.38,134006.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','217156',4196851,'1919','290',419983.73,421488.90,1505.17,248353.05,0.00,0.00,0.00,0.00,0.00),('5','107','703','217156',4196852,'1920','290',95447.88,95447.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217156',4196853,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217156',4196854,'1922','290',68216.25,68216.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217156',4196855,'1923','290',720977.72,720977.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217156',4196856,'1924','290',69026.52,69026.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','217156',4196857,'1925','290',1419537.84,1424362.34,4824.50,796042.50,0.00,0.00,0.00,0.00,0.00),('5','107','705','217156',4196858,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','217156',4196859,'1927','290',422696.85,425890.91,3194.06,527019.90,0.00,0.00,0.00,0.00,0.00),('5','107','705','217156',4196860,'1928','290',100922.94,100922.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','217156',4196861,'1929','291',3154975.91,3163260.25,8284.34,2443880.30,0.00,0.00,0.00,0.00,0.00),('5','107','706','217156',4196862,'1930','291',2180141.22,2185688.74,5547.52,1636518.40,0.00,0.00,0.00,0.00,0.00),('5','107','706','217156',4196863,'1931','291',3368906.88,3374151.57,5244.69,1547183.55,0.00,0.00,0.00,0.00,0.00),('5','107','706','217156',4196864,'1932','291',2889801.88,2895373.93,5572.05,1643754.75,0.00,0.00,0.00,0.00,0.00),('5','107','706','217156',4196865,'1933','291',3837201.81,3843631.94,6430.13,1896888.35,0.00,0.00,0.00,0.00,0.00),('5','107','708','217156',4196866,'1934','291',1431484.81,1437241.29,5756.48,1698161.60,0.00,0.00,0.00,0.00,0.00),('5','107','706','217156',4196867,'2898','291',2638395.75,2643144.00,4748.25,1400733.75,0.00,0.00,0.00,0.00,0.00),('5','107','708','217156',4196868,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217183',4197464,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217183',4197465,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217183',4197466,'1877','290',727133.45,728697.96,1564.51,258144.15,0.00,0.00,0.00,0.00,0.00),('5','107','696','217183',4197467,'1878','290',175330.29,175330.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217183',4197468,'1879','290',825590.72,825590.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217183',4197469,'1880','290',104424.43,104424.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217183',4197470,'1881','290',1200275.78,1200275.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217183',4197471,'1882','290',1020013.18,1020941.00,927.82,153090.30,0.00,0.00,0.00,0.00,0.00),('5','107','697','217183',4197472,'1883','290',512940.80,512940.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217183',4197473,'1884','290',113480.65,113480.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217183',4197474,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217183',4197475,'1886','290',1906439.74,1908492.32,2052.58,338675.70,0.00,0.00,0.00,0.00,0.00),('5','107','697','217183',4197476,'1887','290',205734.14,205734.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217183',4197477,'1888','290',117890.90,118049.95,159.05,26243.25,0.00,0.00,0.00,0.00,0.00),('5','107','696','217183',4197478,'1889','290',2804209.60,2809924.03,5714.43,942880.95,0.00,0.00,0.00,0.00,0.00),('5','107','696','217183',4197479,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217183',4197480,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217183',4197481,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217183',4197482,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217183',4197483,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217183',4197484,'1895','290',660448.52,661762.23,1313.71,216762.15,0.00,0.00,0.00,0.00,0.00),('5','107','698','217183',4197485,'1896','290',211684.25,212894.58,1210.33,199704.45,0.00,0.00,0.00,0.00,0.00),('5','107','698','217183',4197486,'1897','290',394598.91,394598.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217183',4197487,'1898','290',63143.69,63143.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','217183',4197488,'1899','290',1803778.65,1807186.83,3408.18,562349.70,0.00,0.00,0.00,0.00,0.00),('5','107','699','217183',4197489,'1900','290',401704.38,401704.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','217183',4197490,'1901','290',983564.28,983564.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','217183',4197491,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','217183',4197492,'1903','290',1053551.30,1053551.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','217183',4197493,'1904','290',1039868.20,1039868.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','217183',4197494,'1905','290',1480015.54,1480015.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','217183',4197495,'1906','290',534027.98,534027.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','217183',4197496,'1907','290',1827774.35,1832389.47,4615.12,761494.80,0.00,0.00,0.00,0.00,0.00),('5','107','701','217183',4197497,'1908','290',600795.42,600795.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','217183',4197498,'1909','290',442552.30,444241.66,1689.36,278744.40,0.00,0.00,0.00,0.00,0.00),('5','107','701','217183',4197499,'1910','290',373175.37,373175.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217183',4197500,'1911','290',1002075.63,1005316.03,3240.40,534666.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217183',4197501,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217183',4197502,'1913','290',552898.80,555051.28,2152.48,355159.20,0.00,0.00,0.00,0.00,0.00),('5','107','702','217183',4197503,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217183',4197504,'1915','290',223177.56,225190.46,2012.90,332128.50,0.00,0.00,0.00,0.00,0.00),('5','107','702','217183',4197505,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','217183',4197506,'1917','290',888250.04,893114.42,4864.38,802622.70,0.00,0.00,0.00,0.00,0.00),('5','107','703','217183',4197507,'1918','290',134006.38,134006.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','217183',4197508,'1919','290',421488.90,421488.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','217183',4197509,'1920','290',95447.88,95447.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217183',4197510,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217183',4197511,'1922','290',68216.25,68216.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217183',4197512,'1923','290',720977.72,720977.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217183',4197513,'1924','290',69026.52,69026.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','217183',4197514,'1925','290',1424362.34,1427026.28,2663.94,439550.10,0.00,0.00,0.00,0.00,0.00),('5','107','705','217183',4197515,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','217183',4197516,'1927','290',425890.91,426820.32,929.41,153352.65,0.00,0.00,0.00,0.00,0.00),('5','107','705','217183',4197517,'1928','290',100922.94,100922.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','217183',4197518,'1929','291',3163260.25,3170325.18,7064.93,2084154.35,0.00,0.00,0.00,0.00,0.00),('5','107','706','217183',4197519,'1930','291',2185688.74,2188201.97,2513.23,741402.85,0.00,0.00,0.00,0.00,0.00),('5','107','706','217183',4197520,'1931','291',3374151.57,3381467.44,7315.87,2158181.65,0.00,0.00,0.00,0.00,0.00),('5','107','706','217183',4197521,'1932','291',2895373.93,2899976.52,4602.59,1357764.05,0.00,0.00,0.00,0.00,0.00),('5','107','706','217183',4197522,'1933','291',3843631.94,3846858.48,3226.54,951829.30,0.00,0.00,0.00,0.00,0.00),('5','107','708','217183',4197523,'1934','291',1437241.29,1437891.62,650.33,191847.35,0.00,0.00,0.00,0.00,0.00),('5','107','706','217183',4197524,'2898','291',2643144.00,2645759.34,2615.34,771525.30,0.00,0.00,0.00,0.00,0.00),('5','107','708','217183',4197525,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217195',4197757,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217195',4197758,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217195',4197759,'1877','290',728697.96,728928.61,230.65,38057.25,0.00,0.00,0.00,0.00,0.00),('5','107','696','217195',4197760,'1878','290',175330.29,175330.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217195',4197761,'1879','290',825590.72,825682.98,92.26,15222.90,0.00,0.00,0.00,0.00,0.00),('5','107','696','217195',4197762,'1880','290',104424.43,104424.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217195',4197763,'1881','290',1200275.78,1200318.20,42.42,6999.30,0.00,0.00,0.00,0.00,0.00),('5','107','697','217195',4197764,'1882','290',1020941.00,1020941.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217195',4197765,'1883','290',512940.80,512940.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217195',4197766,'1884','290',113480.65,113480.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217195',4197767,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217195',4197768,'1886','290',1908492.32,1911746.27,3253.95,536901.75,0.00,0.00,0.00,0.00,0.00),('5','107','697','217195',4197769,'1887','290',205734.14,205734.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217195',4197770,'1888','290',118049.95,120450.58,2400.63,396103.95,0.00,0.00,0.00,0.00,0.00),('5','107','696','217195',4197771,'1889','290',2809924.03,2810165.37,241.34,39821.10,0.00,0.00,0.00,0.00,0.00),('5','107','696','217195',4197772,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217195',4197773,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217195',4197774,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217195',4197775,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217195',4197776,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217195',4197777,'1895','290',661762.23,663420.29,1658.06,273579.90,0.00,0.00,0.00,0.00,0.00),('5','107','698','217195',4197778,'1896','290',212894.58,212894.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217195',4197779,'1897','290',394598.91,395958.64,1359.73,224355.45,0.00,0.00,0.00,0.00,0.00),('5','107','698','217195',4197780,'1898','290',63143.69,63143.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','217195',4197781,'1899','290',1807186.83,1810721.55,3534.72,583228.80,0.00,0.00,0.00,0.00,0.00),('5','107','699','217195',4197782,'1900','290',401704.38,401704.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','217195',4197783,'1901','290',983564.28,986705.85,3141.57,518359.05,0.00,0.00,0.00,0.00,0.00),('5','107','699','217195',4197784,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','217195',4197785,'1903','290',1053551.30,1053551.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','217195',4197786,'1904','290',1039868.20,1039868.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','217195',4197787,'1905','290',1480015.54,1480015.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','217195',4197788,'1906','290',534027.98,534027.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','217195',4197789,'1907','290',1832389.47,1838195.30,5805.83,957961.95,0.00,0.00,0.00,0.00,0.00),('5','107','701','217195',4197790,'1908','290',600795.42,600795.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','217195',4197791,'1909','290',444241.66,448687.39,4445.73,733545.45,0.00,0.00,0.00,0.00,0.00),('5','107','701','217195',4197792,'1910','290',373175.37,373175.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217195',4197793,'1911','290',1005316.03,1008096.36,2780.33,458754.45,0.00,0.00,0.00,0.00,0.00),('5','107','702','217195',4197794,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217195',4197795,'1913','290',555051.28,557543.25,2491.97,411175.05,0.00,0.00,0.00,0.00,0.00),('5','107','702','217195',4197796,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217195',4197797,'1915','290',225190.46,225806.06,615.60,101574.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217195',4197798,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','217195',4197799,'1917','290',893114.42,897161.83,4047.41,667822.65,0.00,0.00,0.00,0.00,0.00),('5','107','703','217195',4197800,'1918','290',134006.38,134006.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','217195',4197801,'1919','290',421488.90,423147.04,1658.14,273593.10,0.00,0.00,0.00,0.00,0.00),('5','107','703','217195',4197802,'1920','290',95447.88,95447.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217195',4197803,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217195',4197804,'1922','290',68216.25,68216.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217195',4197805,'1923','290',720977.72,720977.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217195',4197806,'1924','290',69026.52,69026.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','217195',4197807,'1925','290',1427026.28,1430016.43,2990.15,493374.75,0.00,0.00,0.00,0.00,0.00),('5','107','705','217195',4197808,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','217195',4197809,'1927','290',426820.32,429422.91,2602.59,429427.35,0.00,0.00,0.00,0.00,0.00),('5','107','705','217195',4197810,'1928','290',100922.94,100922.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','217195',4197811,'1929','291',3170325.18,3177395.04,7069.86,2085608.70,0.00,0.00,0.00,0.00,0.00),('5','107','706','217195',4197812,'1930','291',2188201.97,2192352.75,4150.78,1224480.10,0.00,0.00,0.00,0.00,0.00),('5','107','706','217195',4197813,'1931','291',3381467.44,3387231.26,5763.82,1700326.90,0.00,0.00,0.00,0.00,0.00),('5','107','706','217195',4197814,'1932','291',2899976.52,2903016.67,3040.15,896844.25,0.00,0.00,0.00,0.00,0.00),('5','107','706','217195',4197815,'1933','291',3846858.48,3852956.45,6097.97,1798901.15,0.00,0.00,0.00,0.00,0.00),('5','107','708','217195',4197816,'1934','291',1437891.62,1438845.74,954.12,281465.40,0.00,0.00,0.00,0.00,0.00),('5','107','706','217195',4197817,'2898','291',2645759.34,2648272.70,2513.36,741441.20,0.00,0.00,0.00,0.00,0.00),('5','107','708','217195',4197818,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217205',4198000,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217205',4198001,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217205',4198002,'1877','290',728928.61,728928.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217205',4198003,'1878','290',175330.29,175330.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217205',4198004,'1879','290',825682.98,825682.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217205',4198005,'1880','290',104424.43,104424.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217205',4198006,'1881','290',1200318.20,1200318.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217205',4198007,'1882','290',1020941.00,1021811.42,870.42,143619.30,0.00,0.00,0.00,0.00,0.00),('5','107','697','217205',4198008,'1883','290',512940.80,514959.68,2018.88,333115.20,0.00,0.00,0.00,0.00,0.00),('5','107','697','217205',4198009,'1884','290',113480.65,113480.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217205',4198010,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217205',4198011,'1886','290',1911746.27,1917117.73,5371.46,886290.90,0.00,0.00,0.00,0.00,0.00),('5','107','697','217205',4198012,'1887','290',205734.14,205734.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217205',4198013,'1888','290',120450.58,124129.84,3679.26,607077.90,0.00,0.00,0.00,0.00,0.00),('5','107','696','217205',4198014,'1889','290',2810165.37,2810165.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217205',4198015,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217205',4198016,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217205',4198017,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217205',4198018,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217205',4198019,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217205',4198020,'1895','290',663420.29,665073.62,1653.33,272799.45,0.00,0.00,0.00,0.00,0.00),('5','107','698','217205',4198021,'1896','290',212894.58,213218.23,323.65,53402.25,0.00,0.00,0.00,0.00,0.00),('5','107','698','217205',4198022,'1897','290',395958.64,396660.65,702.01,115831.65,0.00,0.00,0.00,0.00,0.00),('5','107','698','217205',4198023,'1898','290',63143.69,63143.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','217205',4198024,'1899','290',1810721.55,1813629.01,2907.46,479730.90,0.00,0.00,0.00,0.00,0.00),('5','107','699','217205',4198025,'1900','290',401704.38,401704.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','217205',4198026,'1901','290',986705.85,988057.60,1351.75,223038.75,0.00,0.00,0.00,0.00,0.00),('5','107','699','217205',4198027,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','217205',4198028,'1903','290',1053551.30,1053551.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','217205',4198029,'1904','290',1039868.20,1039868.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','217205',4198030,'1905','290',1480015.54,1480015.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','217205',4198031,'1906','290',534027.98,534027.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','217205',4198032,'1907','290',1838195.30,1840165.79,1970.49,325130.85,0.00,0.00,0.00,0.00,0.00),('5','107','701','217205',4198033,'1908','290',600795.42,600795.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','217205',4198034,'1909','290',448687.39,450349.60,1662.21,274264.65,0.00,0.00,0.00,0.00,0.00),('5','107','701','217205',4198035,'1910','290',373175.37,373175.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217205',4198036,'1911','290',1008096.36,1009271.49,1175.13,193896.45,0.00,0.00,0.00,0.00,0.00),('5','107','702','217205',4198037,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217205',4198038,'1913','290',557543.25,558686.50,1143.25,188636.25,0.00,0.00,0.00,0.00,0.00),('5','107','702','217205',4198039,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217205',4198040,'1915','290',225806.06,226454.02,647.96,106913.40,0.00,0.00,0.00,0.00,0.00),('5','107','702','217205',4198041,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','217205',4198042,'1917','290',897161.83,900273.05,3111.22,513351.30,0.00,0.00,0.00,0.00,0.00),('5','107','703','217205',4198043,'1918','290',134006.38,135330.25,1323.87,218438.55,0.00,0.00,0.00,0.00,0.00),('5','107','703','217205',4198044,'1919','290',423147.04,423618.75,471.71,77832.15,0.00,0.00,0.00,0.00,0.00),('5','107','703','217205',4198045,'1920','290',95447.88,96058.55,610.67,100760.55,0.00,0.00,0.00,0.00,0.00),('5','107','704','217205',4198046,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217205',4198047,'1922','290',68216.25,68216.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217205',4198048,'1923','290',720977.72,720977.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217205',4198049,'1924','290',69026.52,69026.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','217205',4198050,'1925','290',1430016.43,1434518.99,4502.56,742922.40,0.00,0.00,0.00,0.00,0.00),('5','107','705','217205',4198051,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','217205',4198052,'1927','290',429422.91,429422.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','217205',4198053,'1928','290',100922.94,102363.49,1440.55,237690.75,0.00,0.00,0.00,0.00,0.00),('5','107','706','217205',4198054,'1929','291',3177395.04,3183847.34,6452.30,1903428.50,0.00,0.00,0.00,0.00,0.00),('5','107','706','217205',4198055,'1930','291',2192352.75,2196622.77,4270.02,1259655.90,0.00,0.00,0.00,0.00,0.00),('5','107','706','217205',4198056,'1931','291',3387231.26,3392615.96,5384.70,1588486.50,0.00,0.00,0.00,0.00,0.00),('5','107','706','217205',4198057,'1932','291',2903016.67,2906912.93,3896.26,1149396.70,0.00,0.00,0.00,0.00,0.00),('5','107','706','217205',4198058,'1933','291',3852956.45,3861357.12,8400.67,2478197.65,0.00,0.00,0.00,0.00,0.00),('5','107','708','217205',4198059,'1934','291',1438845.74,1439906.43,1060.69,312903.55,0.00,0.00,0.00,0.00,0.00),('5','107','706','217205',4198060,'2898','291',2648272.70,2652745.05,4472.35,1319343.25,0.00,0.00,0.00,0.00,0.00),('5','107','708','217205',4198061,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217227',4198503,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217227',4198504,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217227',4198505,'1877','290',728928.61,729213.16,284.55,46950.75,0.00,0.00,0.00,0.00,0.00),('5','107','696','217227',4198506,'1878','290',175330.29,175330.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217227',4198507,'1879','290',825682.98,827096.59,1413.61,233245.65,0.00,0.00,0.00,0.00,0.00),('5','107','696','217227',4198508,'1880','290',104424.43,104424.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217227',4198509,'1881','290',1200318.20,1200318.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217227',4198510,'1882','290',1021811.42,1024313.65,2502.23,412867.95,0.00,0.00,0.00,0.00,0.00),('5','107','697','217227',4198511,'1883','290',514959.68,514959.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217227',4198512,'1884','290',113480.65,113480.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217227',4198513,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217227',4198514,'1886','290',1917117.73,1923283.85,6166.12,1017409.80,0.00,0.00,0.00,0.00,0.00),('5','107','697','217227',4198515,'1887','290',205734.14,205734.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217227',4198516,'1888','290',124129.84,124129.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217227',4198517,'1889','290',2810165.37,2814813.91,4648.54,767009.10,0.00,0.00,0.00,0.00,0.00),('5','107','696','217227',4198518,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217227',4198519,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217227',4198520,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217227',4198521,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217227',4198522,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217227',4198523,'1895','290',665073.62,665073.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217227',4198524,'1896','290',213218.23,214229.88,1011.65,166922.25,0.00,0.00,0.00,0.00,0.00),('5','107','698','217227',4198525,'1897','290',396660.65,396660.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217227',4198526,'1898','290',63143.69,63143.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','217227',4198527,'1899','290',1813629.01,1814143.39,514.38,84872.70,0.00,0.00,0.00,0.00,0.00),('5','107','699','217227',4198528,'1900','290',401704.38,401704.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','217227',4198529,'1901','290',988057.60,989320.28,1262.68,208342.20,0.00,0.00,0.00,0.00,0.00),('5','107','699','217227',4198530,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','217227',4198531,'1903','290',1053551.30,1053551.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','217227',4198532,'1904','290',1039868.20,1042038.86,2170.66,358158.90,0.00,0.00,0.00,0.00,0.00),('5','107','700','217227',4198533,'1905','290',1480015.54,1480015.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','217227',4198534,'1906','290',534027.98,536593.45,2565.47,423302.55,0.00,0.00,0.00,0.00,0.00),('5','107','701','217227',4198535,'1907','290',1840165.79,1843717.25,3551.46,585990.90,0.00,0.00,0.00,0.00,0.00),('5','107','701','217227',4198536,'1908','290',600795.42,600795.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','217227',4198537,'1909','290',450349.60,451600.90,1251.30,206464.50,0.00,0.00,0.00,0.00,0.00),('5','107','701','217227',4198538,'1910','290',373175.37,373175.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217227',4198539,'1911','290',1009271.49,1010237.41,965.92,159376.80,0.00,0.00,0.00,0.00,0.00),('5','107','702','217227',4198540,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217227',4198541,'1913','290',558686.50,558686.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217227',4198542,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217227',4198543,'1915','290',226454.02,226454.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217227',4198544,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','217227',4198545,'1917','290',900273.05,901604.77,1331.72,219733.80,0.00,0.00,0.00,0.00,0.00),('5','107','703','217227',4198546,'1918','290',135330.25,135330.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','217227',4198547,'1919','290',423618.75,423618.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','217227',4198548,'1920','290',96058.55,96058.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217227',4198549,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217227',4198550,'1922','290',68216.25,68216.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217227',4198551,'1923','290',720977.72,720977.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217227',4198552,'1924','290',69026.52,69026.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','217227',4198553,'1925','290',1434518.99,1437228.57,2709.58,447080.70,0.00,0.00,0.00,0.00,0.00),('5','107','705','217227',4198554,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','217227',4198555,'1927','290',429422.91,430110.91,688.00,113520.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','217227',4198556,'1928','290',102363.49,102363.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','217227',4198557,'1929','291',3183847.34,3189545.08,5697.74,1680833.30,0.00,0.00,0.00,0.00,0.00),('5','107','706','217227',4198558,'1930','291',2196622.77,2201309.16,4686.39,1382485.05,0.00,0.00,0.00,0.00,0.00),('5','107','706','217227',4198559,'1931','291',3392615.96,3398920.10,6304.14,1859721.30,0.00,0.00,0.00,0.00,0.00),('5','107','706','217227',4198560,'1932','291',2906912.93,2911148.63,4235.70,1249531.50,0.00,0.00,0.00,0.00,0.00),('5','107','706','217227',4198561,'1933','291',3861357.12,3867087.51,5730.39,1690465.05,0.00,0.00,0.00,0.00,0.00),('5','107','708','217227',4198562,'1934','291',1439906.43,1450739.60,10833.17,3195785.15,0.00,0.00,0.00,0.00,0.00),('5','107','706','217227',4198563,'2898','291',2652745.05,2655891.90,3146.85,928320.75,0.00,0.00,0.00,0.00,0.00),('5','107','708','217227',4198564,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217236',4198711,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217236',4198712,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217236',4198713,'1877','290',729213.16,730797.03,1583.87,261338.55,0.00,0.00,0.00,0.00,0.00),('5','107','696','217236',4198714,'1878','290',175330.29,175330.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217236',4198715,'1879','290',827096.59,827096.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217236',4198716,'1880','290',104424.43,104424.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217236',4198717,'1881','290',1200318.20,1200318.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217236',4198718,'1882','290',1024313.65,1027262.40,2948.75,486543.75,0.00,0.00,0.00,0.00,0.00),('5','107','697','217236',4198719,'1883','290',514959.68,514959.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217236',4198720,'1884','290',113480.65,113480.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217236',4198721,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217236',4198722,'1886','290',1923283.85,1928881.49,5597.64,923610.60,0.00,0.00,0.00,0.00,0.00),('5','107','697','217236',4198723,'1887','290',205734.14,205734.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217236',4198724,'1888','290',124129.84,124129.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217236',4198725,'1889','290',2814813.91,2820758.42,5944.51,980844.15,0.00,0.00,0.00,0.00,0.00),('5','107','696','217236',4198726,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217236',4198727,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217236',4198728,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217236',4198729,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217236',4198730,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217236',4198731,'1895','290',665073.62,665073.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217236',4198732,'1896','290',214229.88,215379.22,1149.34,189641.10,0.00,0.00,0.00,0.00,0.00),('5','107','698','217236',4198733,'1897','290',396660.65,396660.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217236',4198734,'1898','290',63143.69,63469.17,325.48,53704.20,0.00,0.00,0.00,0.00,0.00),('5','107','699','217236',4198735,'1899','290',1814143.39,1817030.35,2886.96,476348.40,0.00,0.00,0.00,0.00,0.00),('5','107','699','217236',4198736,'1900','290',401704.38,401704.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','217236',4198737,'1901','290',989320.28,990300.05,979.77,161662.05,0.00,0.00,0.00,0.00,0.00),('5','107','699','217236',4198738,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','217236',4198739,'1903','290',1053551.30,1053551.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','217236',4198740,'1904','290',1042038.86,1045842.54,3803.68,627607.20,0.00,0.00,0.00,0.00,0.00),('5','107','700','217236',4198741,'1905','290',1480015.54,1480015.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','217236',4198742,'1906','290',536593.45,538560.05,1966.60,324489.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','217236',4198743,'1907','290',1843717.25,1848824.33,5107.08,842668.20,0.00,0.00,0.00,0.00,0.00),('5','107','701','217236',4198744,'1908','290',600795.42,600795.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','217236',4198745,'1909','290',451600.90,451600.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','217236',4198746,'1910','290',373175.37,373175.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217236',4198747,'1911','290',1010237.41,1011525.83,1288.42,212589.30,0.00,0.00,0.00,0.00,0.00),('5','107','702','217236',4198748,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217236',4198749,'1913','290',558686.50,559267.87,581.37,95926.05,0.00,0.00,0.00,0.00,0.00),('5','107','702','217236',4198750,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217236',4198751,'1915','290',226454.02,226454.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217236',4198752,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','217236',4198753,'1917','290',901604.77,903457.13,1852.36,305639.40,0.00,0.00,0.00,0.00,0.00),('5','107','703','217236',4198754,'1918','290',135330.25,135330.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','217236',4198755,'1919','290',423618.75,423618.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','217236',4198756,'1920','290',96058.55,96058.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217236',4198757,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217236',4198758,'1922','290',68216.25,68216.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217236',4198759,'1923','290',720977.72,720977.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217236',4198760,'1924','290',69026.52,69026.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','217236',4198761,'1925','290',1437228.57,1439752.82,2524.25,416501.25,0.00,0.00,0.00,0.00,0.00),('5','107','705','217236',4198762,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','217236',4198763,'1927','290',430110.91,430110.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','217236',4198764,'1928','290',102363.49,102363.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','217236',4198765,'1929','291',3189545.08,3195277.46,5732.38,1691052.10,0.00,0.00,0.00,0.00,0.00),('5','107','706','217236',4198766,'1930','291',2201309.16,2206294.51,4985.35,1470678.25,0.00,0.00,0.00,0.00,0.00),('5','107','706','217236',4198767,'1931','291',3398920.10,3402643.06,3722.96,1098273.20,0.00,0.00,0.00,0.00,0.00),('5','107','706','217236',4198768,'1932','291',2911148.63,2914415.71,3267.08,963788.60,0.00,0.00,0.00,0.00,0.00),('5','107','706','217236',4198769,'1933','291',3867087.51,3872573.98,5486.47,1618508.65,0.00,0.00,0.00,0.00,0.00),('5','107','708','217236',4198770,'1934','291',1450739.60,1453887.39,3147.79,928598.05,0.00,0.00,0.00,0.00,0.00),('5','107','706','217236',4198771,'2898','291',2655891.90,2658308.85,2416.95,713000.25,0.00,0.00,0.00,0.00,0.00),('5','107','708','217236',4198772,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217300',4199612,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217300',4199613,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217300',4199614,'1877','290',730797.03,732658.17,1861.14,307088.10,0.00,0.00,0.00,0.00,0.00),('5','107','696','217300',4199615,'1878','290',175330.29,175330.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217300',4199616,'1879','290',827096.59,827706.62,610.03,100654.95,0.00,0.00,0.00,0.00,0.00),('5','107','696','217300',4199617,'1880','290',104424.43,104424.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217300',4199618,'1881','290',1200318.20,1200318.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217300',4199619,'1882','290',1027262.40,1027696.42,434.02,71613.30,0.00,0.00,0.00,0.00,0.00),('5','107','697','217300',4199620,'1883','290',514959.68,514959.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217300',4199621,'1884','290',113480.65,113480.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217300',4199622,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217300',4199623,'1886','290',1928881.49,1929603.29,721.80,119097.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217300',4199624,'1887','290',205734.14,205734.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217300',4199625,'1888','290',124129.84,124129.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217300',4199626,'1889','290',2820758.42,2826238.44,5480.02,904203.30,0.00,0.00,0.00,0.00,0.00),('5','107','696','217300',4199627,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217300',4199628,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217300',4199629,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217300',4199630,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217300',4199631,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217300',4199632,'1895','290',665073.62,665702.81,629.19,103816.35,0.00,0.00,0.00,0.00,0.00),('5','107','698','217300',4199633,'1896','290',215379.22,215379.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217300',4199634,'1897','290',396660.65,396660.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217300',4199635,'1898','290',63469.17,63876.78,407.61,67255.65,0.00,0.00,0.00,0.00,0.00),('5','107','699','217300',4199636,'1899','290',1817030.35,1819263.40,2233.05,368453.25,0.00,0.00,0.00,0.00,0.00),('5','107','699','217300',4199637,'1900','290',401704.38,402090.19,385.81,63658.65,0.00,0.00,0.00,0.00,0.00),('5','107','699','217300',4199638,'1901','290',990300.05,990966.81,666.76,110015.40,0.00,0.00,0.00,0.00,0.00),('5','107','699','217300',4199639,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','217300',4199640,'1903','290',1053551.30,1053551.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','217300',4199641,'1904','290',1045842.54,1050159.46,4316.92,712291.80,0.00,0.00,0.00,0.00,0.00),('5','107','700','217300',4199642,'1905','290',1480015.54,1480015.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','217300',4199643,'1906','290',538560.05,541708.05,3148.00,519420.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','217300',4199644,'1907','290',1848824.33,1852950.59,4126.26,680832.90,0.00,0.00,0.00,0.00,0.00),('5','107','701','217300',4199645,'1908','290',600795.42,600795.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','217300',4199646,'1909','290',451600.90,451600.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','217300',4199647,'1910','290',373175.37,374786.82,1611.45,265889.25,0.00,0.00,0.00,0.00,0.00),('5','107','702','217300',4199648,'1911','290',1011525.83,1012433.00,907.17,149683.05,0.00,0.00,0.00,0.00,0.00),('5','107','702','217300',4199649,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217300',4199650,'1913','290',559267.87,559950.73,682.86,112671.90,0.00,0.00,0.00,0.00,0.00),('5','107','702','217300',4199651,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217300',4199652,'1915','290',226454.02,226454.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217300',4199653,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','217300',4199654,'1917','290',903457.13,906275.78,2818.65,465077.25,0.00,0.00,0.00,0.00,0.00),('5','107','703','217300',4199655,'1918','290',135330.25,135330.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','217300',4199656,'1919','290',423618.75,424004.37,385.62,63627.30,0.00,0.00,0.00,0.00,0.00),('5','107','703','217300',4199657,'1920','290',96058.55,96058.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217300',4199658,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217300',4199659,'1922','290',68216.25,68216.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217300',4199660,'1923','290',720977.72,720977.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217300',4199661,'1924','290',69026.52,69026.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','217300',4199662,'1925','290',1439752.82,1441948.45,2195.63,362278.95,0.00,0.00,0.00,0.00,0.00),('5','107','705','217300',4199663,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','217300',4199664,'1927','290',430110.91,430985.83,874.92,144361.80,0.00,0.00,0.00,0.00,0.00),('5','107','705','217300',4199665,'1928','290',102363.49,102363.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','217300',4199666,'1929','291',3195277.46,3201355.17,6077.71,1792924.45,0.00,0.00,0.00,0.00,0.00),('5','107','706','217300',4199667,'1930','291',2206294.51,2208736.31,2441.80,720331.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','217300',4199668,'1931','291',3402643.06,3406959.15,4316.09,1273246.55,0.00,0.00,0.00,0.00,0.00),('5','107','706','217300',4199669,'1932','291',2914415.71,2918887.65,4471.94,1319222.30,0.00,0.00,0.00,0.00,0.00),('5','107','706','217300',4199670,'1933','291',3872573.98,3878038.38,5464.40,1611998.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','217300',4199671,'1934','291',1453887.39,1456564.64,2677.25,789788.75,0.00,0.00,0.00,0.00,0.00),('5','107','706','217300',4199672,'2898','291',2658308.85,2660443.59,2134.74,629748.30,0.00,0.00,0.00,0.00,0.00),('5','107','708','217300',4199673,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217685',4206405,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217685',4206406,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217685',4206407,'1877','290',732658.17,733421.75,763.58,125990.70,0.00,0.00,0.00,0.00,0.00),('5','107','696','217685',4206408,'1878','290',175330.29,175330.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217685',4206409,'1879','290',827706.62,828291.93,585.31,96576.15,0.00,0.00,0.00,0.00,0.00),('5','107','696','217685',4206410,'1880','290',104424.43,104424.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217685',4206411,'1881','290',1200318.20,1200318.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217685',4206412,'1882','290',1027696.42,1030820.86,3124.44,515532.60,0.00,0.00,0.00,0.00,0.00),('5','107','697','217685',4206413,'1883','290',514959.68,514959.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217685',4206414,'1884','290',113480.65,113480.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217685',4206415,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217685',4206416,'1886','290',1929603.29,1935083.00,5479.71,904152.15,0.00,0.00,0.00,0.00,0.00),('5','107','697','217685',4206417,'1887','290',205734.14,205734.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217685',4206418,'1888','290',124129.84,125201.70,1071.86,176856.90,0.00,0.00,0.00,0.00,0.00),('5','107','696','217685',4206419,'1889','290',2826238.44,2828558.28,2319.84,382773.60,0.00,0.00,0.00,0.00,0.00),('5','107','696','217685',4206420,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217685',4206421,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217685',4206422,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217685',4206423,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217685',4206424,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217685',4206425,'1895','290',665702.81,665702.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217685',4206426,'1896','290',215379.22,217851.69,2472.47,407957.55,0.00,0.00,0.00,0.00,0.00),('5','107','698','217685',4206427,'1897','290',396660.65,396660.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217685',4206428,'1898','290',63876.78,64285.10,408.32,67372.80,0.00,0.00,0.00,0.00,0.00),('5','107','699','217685',4206429,'1899','290',1819263.40,1820578.33,1314.93,216963.45,0.00,0.00,0.00,0.00,0.00),('5','107','699','217685',4206430,'1900','290',402090.19,402090.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','217685',4206431,'1901','290',990966.81,992034.49,1067.68,176167.20,0.00,0.00,0.00,0.00,0.00),('5','107','699','217685',4206432,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','217685',4206433,'1903','290',1053551.30,1053551.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','217685',4206434,'1904','290',1050159.46,1053213.45,3053.99,503908.35,0.00,0.00,0.00,0.00,0.00),('5','107','700','217685',4206435,'1905','290',1480015.54,1480015.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','217685',4206436,'1906','290',541708.05,544258.96,2550.91,420900.15,0.00,0.00,0.00,0.00,0.00),('5','107','701','217685',4206437,'1907','290',1852950.59,1858333.80,5383.21,888229.65,0.00,0.00,0.00,0.00,0.00),('5','107','701','217685',4206438,'1908','290',600795.42,600795.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','217685',4206439,'1909','290',451600.90,454680.07,3079.17,508063.05,0.00,0.00,0.00,0.00,0.00),('5','107','701','217685',4206440,'1910','290',374786.82,374786.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217685',4206441,'1911','290',1012433.00,1015346.59,2913.59,480742.35,0.00,0.00,0.00,0.00,0.00),('5','107','702','217685',4206442,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217685',4206443,'1913','290',559950.73,559950.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217685',4206444,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217685',4206445,'1915','290',226454.02,226454.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217685',4206446,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','217685',4206447,'1917','290',906275.78,906943.83,668.05,110228.25,0.00,0.00,0.00,0.00,0.00),('5','107','703','217685',4206448,'1918','290',135330.25,135330.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','217685',4206449,'1919','290',424004.37,424420.33,415.96,68633.40,0.00,0.00,0.00,0.00,0.00),('5','107','703','217685',4206450,'1920','290',96058.55,96058.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217685',4206451,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217685',4206452,'1922','290',68216.25,68216.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217685',4206453,'1923','290',720977.72,720977.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217685',4206454,'1924','290',69026.52,69026.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','217685',4206455,'1925','290',1441948.45,1446025.30,4076.85,672680.25,0.00,0.00,0.00,0.00,0.00),('5','107','705','217685',4206456,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','217685',4206457,'1927','290',430985.83,430985.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','217685',4206458,'1928','290',102363.49,102363.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','217685',4206459,'1929','291',3201355.17,3207440.58,6085.41,1795195.95,0.00,0.00,0.00,0.00,0.00),('5','107','706','217685',4206460,'1930','291',2208736.31,2214039.62,5303.31,1564476.45,0.00,0.00,0.00,0.00,0.00),('5','107','706','217685',4206461,'1931','291',3406959.15,3410439.63,3480.48,1026741.60,0.00,0.00,0.00,0.00,0.00),('5','107','706','217685',4206462,'1932','291',2918887.65,2922936.19,4048.54,1194319.30,0.00,0.00,0.00,0.00,0.00),('5','107','706','217685',4206463,'1933','291',3878038.38,3883989.07,5950.69,1755453.55,0.00,0.00,0.00,0.00,0.00),('5','107','708','217685',4206464,'1934','291',1456564.64,1461830.59,5265.95,1553455.25,0.00,0.00,0.00,0.00,0.00),('5','107','706','217685',4206465,'2898','291',2660443.59,2663937.53,3493.94,1030712.30,0.00,0.00,0.00,0.00,0.00),('5','107','708','217685',4206466,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217820',4208720,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217820',4208721,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217820',4208722,'1877','290',733421.75,733421.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217820',4208723,'1878','290',175330.29,175330.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217820',4208724,'1879','290',828291.93,828291.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217820',4208725,'1880','290',104424.43,104424.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217820',4208726,'1881','290',1200318.20,1200324.46,6.26,1032.90,0.00,0.00,0.00,0.00,0.00),('5','107','697','217820',4208727,'1882','290',1030820.86,1031587.65,766.79,126520.35,0.00,0.00,0.00,0.00,0.00),('5','107','697','217820',4208728,'1883','290',514959.68,514959.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217820',4208729,'1884','290',113480.65,113480.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217820',4208730,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217820',4208731,'1886','290',1935083.00,1939985.25,4902.25,808871.25,0.00,0.00,0.00,0.00,0.00),('5','107','697','217820',4208732,'1887','290',205734.14,205734.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217820',4208733,'1888','290',125201.70,127495.35,2293.65,378452.25,0.00,0.00,0.00,0.00,0.00),('5','107','696','217820',4208734,'1889','290',2828558.28,2834177.21,5618.93,927123.45,0.00,0.00,0.00,0.00,0.00),('5','107','696','217820',4208735,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217820',4208736,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217820',4208737,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217820',4208738,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217820',4208739,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217820',4208740,'1895','290',665702.81,666614.32,911.51,150399.15,0.00,0.00,0.00,0.00,0.00),('5','107','698','217820',4208741,'1896','290',217851.69,217851.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217820',4208742,'1897','290',396660.65,396660.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217820',4208743,'1898','290',64285.10,64285.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','217820',4208744,'1899','290',1820578.33,1824482.65,3904.32,644212.80,0.00,0.00,0.00,0.00,0.00),('5','107','699','217820',4208745,'1900','290',402090.19,402090.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','217820',4208746,'1901','290',992034.49,992606.64,572.15,94404.75,0.00,0.00,0.00,0.00,0.00),('5','107','699','217820',4208747,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','217820',4208748,'1903','290',1053551.30,1053551.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','217820',4208749,'1904','290',1053213.45,1053213.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','217820',4208750,'1905','290',1480015.54,1480015.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','217820',4208751,'1906','290',544258.96,544258.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','217820',4208752,'1907','290',1858333.80,1863177.52,4843.72,799213.80,0.00,0.00,0.00,0.00,0.00),('5','107','701','217820',4208753,'1908','290',600795.42,600795.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','217820',4208754,'1909','290',454680.07,454680.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','217820',4208755,'1910','290',374786.82,374786.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217820',4208756,'1911','290',1015346.59,1017023.92,1677.33,276759.45,0.00,0.00,0.00,0.00,0.00),('5','107','702','217820',4208757,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217820',4208758,'1913','290',559950.73,561452.00,1501.27,247709.55,0.00,0.00,0.00,0.00,0.00),('5','107','702','217820',4208759,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217820',4208760,'1915','290',226454.02,226454.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217820',4208761,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','217820',4208762,'1917','290',906943.83,910618.87,3675.04,606381.60,0.00,0.00,0.00,0.00,0.00),('5','107','703','217820',4208763,'1918','290',135330.25,135330.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','217820',4208764,'1919','290',424420.33,425267.01,846.68,139702.20,0.00,0.00,0.00,0.00,0.00),('5','107','703','217820',4208765,'1920','290',96058.55,96058.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217820',4208766,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217820',4208767,'1922','290',68216.25,68216.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217820',4208768,'1923','290',720977.72,720977.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217820',4208769,'1924','290',69026.52,69026.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','217820',4208770,'1925','290',1446025.30,1448470.21,2444.91,403410.15,0.00,0.00,0.00,0.00,0.00),('5','107','705','217820',4208771,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','217820',4208772,'1927','290',430985.83,431811.98,826.15,136314.75,0.00,0.00,0.00,0.00,0.00),('5','107','705','217820',4208773,'1928','290',102363.49,102363.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','217820',4208774,'1929','291',3207440.58,3214424.67,6984.09,2060306.55,0.00,0.00,0.00,0.00,0.00),('5','107','706','217820',4208775,'1930','291',2214039.62,2218975.59,4935.97,1456111.15,0.00,0.00,0.00,0.00,0.00),('5','107','706','217820',4208776,'1931','291',3410439.63,3414635.40,4195.77,1237752.15,0.00,0.00,0.00,0.00,0.00),('5','107','706','217820',4208777,'1932','291',2922936.19,2924769.50,1833.31,540826.45,0.00,0.00,0.00,0.00,0.00),('5','107','706','217820',4208778,'1933','291',3883989.07,3886616.85,2627.78,775195.10,0.00,0.00,0.00,0.00,0.00),('5','107','708','217820',4208779,'1934','291',1461830.59,1468387.04,6556.45,1934152.75,0.00,0.00,0.00,0.00,0.00),('5','107','706','217820',4208780,'2898','291',2663937.53,2665546.18,1608.65,474551.75,0.00,0.00,0.00,0.00,0.00),('5','107','708','217820',4208781,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217918',4210721,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217918',4210722,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217918',4210723,'1877','290',733421.75,734793.78,1372.03,226384.95,0.00,0.00,0.00,0.00,0.00),('5','107','696','217918',4210724,'1878','290',175330.29,175330.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217918',4210725,'1879','290',828291.93,828291.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217918',4210726,'1880','290',104424.43,104424.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217918',4210727,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217918',4210728,'1882','290',1031587.65,1031587.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217918',4210729,'1883','290',514959.68,516277.46,1317.78,217433.70,0.00,0.00,0.00,0.00,0.00),('5','107','697','217918',4210730,'1884','290',113480.65,113480.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217918',4210731,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217918',4210732,'1886','290',1939985.25,1946140.26,6155.01,1015576.65,0.00,0.00,0.00,0.00,0.00),('5','107','697','217918',4210733,'1887','290',205734.14,205734.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','217918',4210734,'1888','290',127495.35,132361.43,4866.08,802903.20,0.00,0.00,0.00,0.00,0.00),('5','107','696','217918',4210735,'1889','290',2834177.21,2840225.06,6047.85,997895.25,0.00,0.00,0.00,0.00,0.00),('5','107','696','217918',4210736,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217918',4210737,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','217918',4210738,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217918',4210739,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217918',4210740,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217918',4210741,'1895','290',666614.32,667024.44,410.12,67669.80,0.00,0.00,0.00,0.00,0.00),('5','107','698','217918',4210742,'1896','290',217851.69,217851.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217918',4210743,'1897','290',396660.65,396660.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','217918',4210744,'1898','290',64285.10,64285.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','217918',4210745,'1899','290',1824482.65,1827767.70,3285.05,542033.25,0.00,0.00,0.00,0.00,0.00),('5','107','699','217918',4210746,'1900','290',402090.19,402090.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','217918',4210747,'1901','290',992606.64,994506.08,1899.44,313407.60,0.00,0.00,0.00,0.00,0.00),('5','107','699','217918',4210748,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','217918',4210749,'1903','290',1053551.30,1053551.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','217918',4210750,'1904','290',1053213.45,1053213.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','217918',4210751,'1905','290',1480015.54,1480015.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','217918',4210752,'1906','290',544258.96,544258.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','217918',4210753,'1907','290',1863177.52,1867794.71,4617.19,761836.35,0.00,0.00,0.00,0.00,0.00),('5','107','701','217918',4210754,'1908','290',600795.42,600795.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','217918',4210755,'1909','290',454680.07,454680.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','217918',4210756,'1910','290',374786.82,374786.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217918',4210757,'1911','290',1017023.92,1018635.81,1611.89,265961.85,0.00,0.00,0.00,0.00,0.00),('5','107','702','217918',4210758,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217918',4210759,'1913','290',561452.00,563112.95,1660.95,274056.75,0.00,0.00,0.00,0.00,0.00),('5','107','702','217918',4210760,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','217918',4210761,'1915','290',226454.02,226561.56,107.54,17744.10,0.00,0.00,0.00,0.00,0.00),('5','107','702','217918',4210762,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','217918',4210763,'1917','290',910618.87,914311.47,3692.60,609279.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','217918',4210764,'1918','290',135330.25,135330.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','217918',4210765,'1919','290',425267.01,425267.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','217918',4210766,'1920','290',96058.55,96058.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217918',4210767,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217918',4210768,'1922','290',68216.25,68216.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217918',4210769,'1923','290',720977.72,720977.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','217918',4210770,'1924','290',69026.52,69026.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','217918',4210771,'1925','290',1448470.21,1451526.57,3056.36,504299.40,0.00,0.00,0.00,0.00,0.00),('5','107','705','217918',4210772,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','217918',4210773,'1927','290',431811.98,431811.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','217918',4210774,'1928','290',102363.49,102363.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','217918',4210775,'1929','291',3214424.67,3219898.06,5473.39,1614650.05,0.00,0.00,0.00,0.00,0.00),('5','107','706','217918',4210776,'1930','291',2218975.59,2223388.50,4412.91,1301808.45,0.00,0.00,0.00,0.00,0.00),('5','107','706','217918',4210777,'1931','291',3414635.40,3419338.89,4703.49,1387529.55,0.00,0.00,0.00,0.00,0.00),('5','107','706','217918',4210778,'1932','291',2924769.50,2928148.68,3379.18,996858.10,0.00,0.00,0.00,0.00,0.00),('5','107','706','217918',4210779,'1933','291',3886616.85,3890547.04,3930.19,1159406.05,0.00,0.00,0.00,0.00,0.00),('5','107','708','217918',4210780,'1934','291',1468387.04,1468815.84,428.80,126496.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','217918',4210781,'2898','291',2665546.18,2667838.17,2291.99,676137.05,0.00,0.00,0.00,0.00,0.00),('5','107','708','217918',4210782,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','218311',4217316,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','218311',4217317,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','218311',4217318,'1877','290',734793.78,735799.88,1006.10,166006.50,0.00,0.00,0.00,0.00,0.00),('5','107','696','218311',4217319,'1878','290',175330.29,175330.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','218311',4217320,'1879','290',828291.93,828789.83,497.90,82153.50,0.00,0.00,0.00,0.00,0.00),('5','107','696','218311',4217321,'1880','290',104424.43,104424.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','218311',4217322,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','218311',4217323,'1882','290',1031587.65,1035757.70,4170.05,688058.25,0.00,0.00,0.00,0.00,0.00),('5','107','697','218311',4217324,'1883','290',516277.46,516277.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','218311',4217325,'1884','290',113480.65,113480.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','218311',4217326,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','218311',4217327,'1886','290',1946140.26,1951564.35,5424.09,894974.85,0.00,0.00,0.00,0.00,0.00),('5','107','697','218311',4217328,'1887','290',205734.14,205744.14,10.00,1650.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','218311',4217329,'1888','290',132361.43,132361.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','218311',4217330,'1889','290',2840225.06,2844758.38,4533.32,747997.80,0.00,0.00,0.00,0.00,0.00),('5','107','696','218311',4217331,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','218311',4217332,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','218311',4217333,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','218311',4217334,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','218311',4217335,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','218311',4217336,'1895','290',667024.44,667681.38,656.94,108395.10,0.00,0.00,0.00,0.00,0.00),('5','107','698','218311',4217337,'1896','290',217851.69,217851.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','218311',4217338,'1897','290',396660.65,396660.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','218311',4217339,'1898','290',64285.10,64285.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','218311',4217340,'1899','290',1827767.70,1829713.20,1945.50,321007.50,0.00,0.00,0.00,0.00,0.00),('5','107','699','218311',4217341,'1900','290',402090.19,402090.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','218311',4217342,'1901','290',994506.08,996001.48,1495.40,246741.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','218311',4217343,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','218311',4217344,'1903','290',1053551.30,1053561.55,10.25,1691.25,0.00,0.00,0.00,0.00,0.00),('5','107','700','218311',4217345,'1904','290',1053213.45,1058211.87,4998.42,824739.30,0.00,0.00,0.00,0.00,0.00),('5','107','700','218311',4217346,'1905','290',1480015.54,1480015.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','218311',4217347,'1906','290',544258.96,545392.58,1133.62,187047.30,0.00,0.00,0.00,0.00,0.00),('5','107','701','218311',4217348,'1907','290',1867794.71,1872825.05,5030.34,830006.10,0.00,0.00,0.00,0.00,0.00),('5','107','701','218311',4217349,'1908','290',600795.42,600795.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','218311',4217350,'1909','290',454680.07,454680.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','218311',4217351,'1910','290',374786.82,374786.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','218311',4217352,'1911','290',1018635.81,1021394.52,2758.71,455187.15,0.00,0.00,0.00,0.00,0.00),('5','107','702','218311',4217353,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','218311',4217354,'1913','290',563112.95,563638.18,525.23,86662.95,0.00,0.00,0.00,0.00,0.00),('5','107','702','218311',4217355,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','218311',4217356,'1915','290',226561.56,226561.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','218311',4217357,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','218311',4217358,'1917','290',914311.47,915563.30,1251.83,206551.95,0.00,0.00,0.00,0.00,0.00),('5','107','703','218311',4217359,'1918','290',135330.25,136346.56,1016.31,167691.15,0.00,0.00,0.00,0.00,0.00),('5','107','703','218311',4217360,'1919','290',425267.01,425641.50,374.49,61790.85,0.00,0.00,0.00,0.00,0.00),('5','107','703','218311',4217361,'1920','290',96058.55,96058.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','218311',4217362,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','218311',4217363,'1922','290',68216.25,68216.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','218311',4217364,'1923','290',720977.72,720977.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','218311',4217365,'1924','290',69026.52,69026.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','218311',4217366,'1925','290',1451526.57,1451526.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','218311',4217367,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','218311',4217368,'1927','290',431811.98,431811.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','218311',4217369,'1928','290',102363.49,102363.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','218311',4217370,'1929','291',3219898.06,3227632.06,7734.00,2281530.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','218311',4217371,'1930','291',2223388.50,2228343.02,4954.52,1461583.40,0.00,0.00,0.00,0.00,0.00),('5','107','706','218311',4217372,'1931','291',3419338.89,3423865.95,4527.06,1335482.70,0.00,0.00,0.00,0.00,0.00),('5','107','706','218311',4217373,'1932','291',2928148.68,2932344.75,4196.07,1237840.65,0.00,0.00,0.00,0.00,0.00),('5','107','706','218311',4217374,'1933','291',3890547.04,3895052.06,4505.02,1328980.90,0.00,0.00,0.00,0.00,0.00),('5','107','708','218311',4217375,'1934','291',1468815.84,1469475.71,659.87,194661.65,0.00,0.00,0.00,0.00,0.00),('5','107','706','218311',4217376,'2898','291',2667838.17,2672187.07,4348.90,1282925.50,0.00,0.00,0.00,0.00,0.00),('5','107','708','218311',4217377,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','218491',4220379,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','218491',4220380,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','218491',4220381,'1877','290',735799.88,738679.16,2879.28,475081.20,0.00,0.00,0.00,0.00,0.00),('5','107','696','218491',4220382,'1878','290',175330.29,175330.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','218491',4220383,'1879','290',828789.83,829239.75,449.92,74236.80,0.00,0.00,0.00,0.00,0.00),('5','107','696','218491',4220384,'1880','290',104424.43,104424.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','218491',4220385,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','218491',4220386,'1882','290',1035757.70,1035757.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','218491',4220387,'1883','290',516277.46,516277.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','218491',4220388,'1884','290',113480.65,113480.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','218491',4220389,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','218491',4220390,'1886','290',1951564.35,1951618.61,54.26,8952.90,0.00,0.00,0.00,0.00,0.00),('5','107','697','218491',4220391,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','218491',4220392,'1888','290',132361.43,132381.43,20.00,3300.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','218491',4220393,'1889','290',2844758.38,2850318.08,5559.70,917350.50,0.00,0.00,0.00,0.00,0.00),('5','107','696','218491',4220394,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','218491',4220395,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','218491',4220396,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','218491',4220397,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','218491',4220398,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','218491',4220399,'1895','290',667681.38,667681.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','218491',4220400,'1896','290',217851.69,219774.02,1922.33,317184.45,0.00,0.00,0.00,0.00,0.00),('5','107','698','218491',4220401,'1897','290',396660.65,397950.93,1290.28,212896.20,0.00,0.00,0.00,0.00,0.00),('5','107','698','218491',4220402,'1898','290',64285.10,64285.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','218491',4220403,'1899','290',1829713.20,1830519.24,806.04,132996.60,0.00,0.00,0.00,0.00,0.00),('5','107','699','218491',4220404,'1900','290',402090.19,402090.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','218491',4220405,'1901','290',996001.48,996748.69,747.21,123289.65,0.00,0.00,0.00,0.00,0.00),('5','107','699','218491',4220406,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','218491',4220407,'1903','290',1053561.55,1053561.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','218491',4220408,'1904','290',1058211.87,1063094.24,4882.37,805591.05,0.00,0.00,0.00,0.00,0.00),('5','107','700','218491',4220409,'1905','290',1480015.54,1480015.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','218491',4220410,'1906','290',545392.58,550502.94,5110.36,843209.40,0.00,0.00,0.00,0.00,0.00),('5','107','701','218491',4220411,'1907','290',1872825.05,1873770.48,945.43,155995.95,0.00,0.00,0.00,0.00,0.00),('5','107','701','218491',4220412,'1908','290',600795.42,600795.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','218491',4220413,'1909','290',454680.07,454680.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','218491',4220414,'1910','290',374786.82,374786.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','218491',4220415,'1911','290',1021394.52,1023407.94,2013.42,332214.30,0.00,0.00,0.00,0.00,0.00),('5','107','702','218491',4220416,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','218491',4220417,'1913','290',563638.18,564003.55,365.37,60286.05,0.00,0.00,0.00,0.00,0.00),('5','107','702','218491',4220418,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','218491',4220419,'1915','290',226561.56,226561.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','218491',4220420,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','218491',4220421,'1917','290',915563.30,917397.41,1834.11,302628.15,0.00,0.00,0.00,0.00,0.00),('5','107','703','218491',4220422,'1918','290',136346.56,136346.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','218491',4220423,'1919','290',425641.50,425955.92,314.42,51879.30,0.00,0.00,0.00,0.00,0.00),('5','107','703','218491',4220424,'1920','290',96058.55,96058.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','218491',4220425,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','218491',4220426,'1922','290',68216.25,68216.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','218491',4220427,'1923','290',720977.72,720977.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','218491',4220428,'1924','290',69026.52,69026.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','218491',4220429,'1925','290',1451526.57,1455250.45,3723.88,614440.20,0.00,0.00,0.00,0.00,0.00),('5','107','705','218491',4220430,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','218491',4220431,'1927','290',431811.98,433882.41,2070.43,341620.95,0.00,0.00,0.00,0.00,0.00),('5','107','705','218491',4220432,'1928','290',102363.49,102363.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','218491',4220433,'1929','291',3227632.06,3233931.81,6299.75,1858426.25,0.00,0.00,0.00,0.00,0.00),('5','107','706','218491',4220434,'1930','291',2228343.02,2232801.51,4458.49,1315254.55,0.00,0.00,0.00,0.00,0.00),('5','107','706','218491',4220435,'1931','291',3423865.95,3428714.69,4848.74,1430378.30,0.00,0.00,0.00,0.00,0.00),('5','107','706','218491',4220436,'1932','291',2932344.75,2935814.51,3469.76,1023579.20,0.00,0.00,0.00,0.00,0.00),('5','107','706','218491',4220437,'1933','291',3895052.06,3900009.00,4956.94,1462297.30,0.00,0.00,0.00,0.00,0.00),('5','107','708','218491',4220438,'1934','291',1469475.71,1474986.09,5510.38,1625562.10,0.00,0.00,0.00,0.00,0.00),('5','107','706','218491',4220439,'2898','291',2672187.07,2675429.35,3242.28,956472.60,0.00,0.00,0.00,0.00,0.00),('5','107','708','218491',4220440,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','218499',4220578,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','218499',4220579,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','218499',4220580,'1877','290',738679.16,742116.57,3437.41,567172.65,0.00,0.00,0.00,0.00,0.00),('5','107','696','218499',4220581,'1878','290',175330.29,175330.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','218499',4220582,'1879','290',829239.75,830428.43,1188.68,196132.20,0.00,0.00,0.00,0.00,0.00),('5','107','696','218499',4220583,'1880','290',104424.43,104424.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','218499',4220584,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','218499',4220585,'1882','290',1035757.70,1035757.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','218499',4220586,'1883','290',516277.46,516277.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','218499',4220587,'1884','290',113480.65,113480.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','218499',4220588,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','218499',4220589,'1886','290',1951618.61,1951618.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','218499',4220590,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','218499',4220591,'1888','290',132381.43,132381.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','218499',4220592,'1889','290',2850318.08,2856893.73,6575.65,1084982.25,0.00,0.00,0.00,0.00,0.00),('5','107','696','218499',4220593,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','218499',4220594,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','218499',4220595,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','218499',4220596,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','218499',4220597,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','218499',4220598,'1895','290',667681.38,667681.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','218499',4220599,'1896','290',219774.02,222428.38,2654.36,437969.40,0.00,0.00,0.00,0.00,0.00),('5','107','698','218499',4220600,'1897','290',397950.93,399434.40,1483.47,244772.55,0.00,0.00,0.00,0.00,0.00),('5','107','698','218499',4220601,'1898','290',64285.10,64285.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','218499',4220602,'1899','290',1830519.24,1830519.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','218499',4220603,'1900','290',402090.19,402090.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','218499',4220604,'1901','290',996748.69,996748.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','218499',4220605,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','218499',4220606,'1903','290',1053561.55,1053561.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','218499',4220607,'1904','290',1063094.24,1068717.62,5623.38,927857.70,0.00,0.00,0.00,0.00,0.00),('5','107','700','218499',4220608,'1905','290',1480015.54,1480015.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','218499',4220609,'1906','290',550502.94,555768.30,5265.36,868784.40,0.00,0.00,0.00,0.00,0.00),('5','107','701','218499',4220610,'1907','290',1873770.48,1873770.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','218499',4220611,'1908','290',600795.42,600795.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','218499',4220612,'1909','290',454680.07,454680.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','218499',4220613,'1910','290',374786.82,374786.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','218499',4220614,'1911','290',1023407.94,1024334.50,926.56,152882.40,0.00,0.00,0.00,0.00,0.00),('5','107','702','218499',4220615,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','218499',4220616,'1913','290',564003.55,564864.81,861.26,142107.90,0.00,0.00,0.00,0.00,0.00),('5','107','702','218499',4220617,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','218499',4220618,'1915','290',226561.56,226570.63,9.07,1496.55,0.00,0.00,0.00,0.00,0.00),('5','107','702','218499',4220619,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','218499',4220620,'1917','290',917397.41,919183.16,1785.75,294648.75,0.00,0.00,0.00,0.00,0.00),('5','107','703','218499',4220621,'1918','290',136346.56,136739.28,392.72,64798.80,0.00,0.00,0.00,0.00,0.00),('5','107','703','218499',4220622,'1919','290',425955.92,426425.37,469.45,77459.25,0.00,0.00,0.00,0.00,0.00),('5','107','703','218499',4220623,'1920','290',96058.55,96058.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','218499',4220624,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','218499',4220625,'1922','290',68216.25,68216.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','218499',4220626,'1923','290',720977.72,720977.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','218499',4220627,'1924','290',69026.52,69026.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','218499',4220628,'1925','290',1455250.45,1458952.84,3702.39,610894.35,0.00,0.00,0.00,0.00,0.00),('5','107','705','218499',4220629,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','218499',4220630,'1927','290',433882.41,437028.77,3146.36,519149.40,0.00,0.00,0.00,0.00,0.00),('5','107','705','218499',4220631,'1928','290',102363.49,102363.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','218499',4220632,'1929','291',3233931.81,3240992.22,7060.41,2082820.95,0.00,0.00,0.00,0.00,0.00),('5','107','706','218499',4220633,'1930','291',2232801.51,2238013.93,5212.42,1537663.90,0.00,0.00,0.00,0.00,0.00),('5','107','706','218499',4220634,'1931','291',3428714.69,3433519.79,4805.10,1417504.50,0.00,0.00,0.00,0.00,0.00),('5','107','706','218499',4220635,'1932','291',2935814.51,2939832.02,4017.51,1185165.45,0.00,0.00,0.00,0.00,0.00),('5','107','706','218499',4220636,'1933','291',3900009.00,3905431.26,5422.26,1599566.70,0.00,0.00,0.00,0.00,0.00),('5','107','708','218499',4220637,'1934','291',1474986.09,1480845.75,5859.66,1728599.70,0.00,0.00,0.00,0.00,0.00),('5','107','706','218499',4220638,'2898','291',2675429.35,2678019.75,2590.40,764168.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','218499',4220639,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','218746',4224923,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','218746',4224924,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','218746',4224925,'1877','290',742116.57,742116.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','218746',4224926,'1878','290',175330.29,175330.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','218746',4224927,'1879','290',830428.43,830428.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','218746',4224928,'1880','290',104424.43,104424.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','218746',4224929,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','218746',4224930,'1882','290',1035757.70,1035757.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','218746',4224931,'1883','290',516277.46,516277.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','218746',4224932,'1884','290',113480.65,113480.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','218746',4224933,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','218746',4224934,'1886','290',1951618.61,1951618.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','218746',4224935,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','218746',4224936,'1888','290',132381.43,132381.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','218746',4224937,'1889','290',2856893.73,2856893.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','218746',4224938,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','218746',4224939,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','218746',4224940,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','218746',4224941,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','218746',4224942,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','218746',4224943,'1895','290',667681.38,669933.95,2252.57,371674.05,0.00,0.00,0.00,0.00,0.00),('5','107','698','218746',4224944,'1896','290',222428.38,223539.65,1111.27,183359.55,0.00,0.00,0.00,0.00,0.00),('5','107','698','218746',4224945,'1897','290',399434.40,401038.02,1603.62,264597.30,0.00,0.00,0.00,0.00,0.00),('5','107','698','218746',4224946,'1898','290',64285.10,64695.71,410.61,67750.65,0.00,0.00,0.00,0.00,0.00),('5','107','699','218746',4224947,'1899','290',1830519.24,1831636.85,1117.61,184405.65,0.00,0.00,0.00,0.00,0.00),('5','107','699','218746',4224948,'1900','290',402090.19,402090.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','218746',4224949,'1901','290',996748.69,997569.01,820.32,135352.80,0.00,0.00,0.00,0.00,0.00),('5','107','699','218746',4224950,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','218746',4224951,'1903','290',1053561.55,1055652.60,2091.05,345023.25,0.00,0.00,0.00,0.00,0.00),('5','107','700','218746',4224952,'1904','290',1068717.62,1073284.68,4567.06,753564.90,0.00,0.00,0.00,0.00,0.00),('5','107','700','218746',4224953,'1905','290',1480015.54,1480064.95,49.41,8152.65,0.00,0.00,0.00,0.00,0.00),('5','107','700','218746',4224954,'1906','290',555768.30,560393.09,4624.79,763090.35,0.00,0.00,0.00,0.00,0.00),('5','107','701','218746',4224955,'1907','290',1873770.48,1873770.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','218746',4224956,'1908','290',600795.42,600795.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','218746',4224957,'1909','290',454680.07,454680.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','218746',4224958,'1910','290',374786.82,374786.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','218746',4224959,'1911','290',1024334.50,1024334.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','218746',4224960,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','218746',4224961,'1913','290',564864.81,564864.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','218746',4224962,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','218746',4224963,'1915','290',226570.63,226570.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','218746',4224964,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','218746',4224965,'1917','290',919183.16,921145.57,1962.41,323797.65,0.00,0.00,0.00,0.00,0.00),('5','107','703','218746',4224966,'1918','290',136739.28,138083.62,1344.34,221816.10,0.00,0.00,0.00,0.00,0.00),('5','107','703','218746',4224967,'1919','290',426425.37,427411.30,985.93,162678.45,0.00,0.00,0.00,0.00,0.00),('5','107','703','218746',4224968,'1920','290',96058.55,97332.11,1273.56,210137.40,0.00,0.00,0.00,0.00,0.00),('5','107','704','218746',4224969,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','218746',4224970,'1922','290',68216.25,68216.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','218746',4224971,'1923','290',720977.72,720977.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','218746',4224972,'1924','290',69026.52,69026.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','218746',4224973,'1925','290',1458952.84,1463328.02,4375.18,721904.70,0.00,0.00,0.00,0.00,0.00),('5','107','705','218746',4224974,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','218746',4224975,'1927','290',437028.77,439512.34,2483.57,409789.05,0.00,0.00,0.00,0.00,0.00),('5','107','705','218746',4224976,'1928','290',102363.49,104323.08,1959.59,323332.35,0.00,0.00,0.00,0.00,0.00),('5','107','706','218746',4224977,'1929','291',3240992.22,3248840.99,7848.77,2315387.15,0.00,0.00,0.00,0.00,0.00),('5','107','706','218746',4224978,'1930','291',2238013.93,2242201.41,4187.48,1235306.60,0.00,0.00,0.00,0.00,0.00),('5','107','706','218746',4224979,'1931','291',3433519.79,3438883.97,5364.18,1582433.10,0.00,0.00,0.00,0.00,0.00),('5','107','706','218746',4224980,'1932','291',2939832.02,2944777.24,4945.22,1458839.90,0.00,0.00,0.00,0.00,0.00),('5','107','706','218746',4224981,'1933','291',3905431.26,3911817.36,6386.10,1883899.50,0.00,0.00,0.00,0.00,0.00),('5','107','708','218746',4224982,'1934','291',1480845.75,1482181.49,1335.74,394043.30,0.00,0.00,0.00,0.00,0.00),('5','107','706','218746',4224983,'2898','291',2678019.75,2681074.14,3054.39,901045.05,0.00,0.00,0.00,0.00,0.00),('5','107','708','218746',4224984,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','219209',4232933,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','219209',4232934,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','219209',4232935,'1877','290',742116.57,743194.81,1078.24,177909.60,0.00,0.00,0.00,0.00,0.00),('5','107','696','219209',4232936,'1878','290',175330.29,175330.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','219209',4232937,'1879','290',830428.43,831722.94,1294.51,213594.15,0.00,0.00,0.00,0.00,0.00),('5','107','696','219209',4232938,'1880','290',104424.43,104424.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','219209',4232939,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','219209',4232940,'1882','290',1035757.70,1035757.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','219209',4232941,'1883','290',516277.46,516277.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','219209',4232942,'1884','290',113480.65,113480.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','219209',4232943,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','219209',4232944,'1886','290',1951618.61,1951618.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','219209',4232945,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','219209',4232946,'1888','290',132381.43,132381.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','219209',4232947,'1889','290',2856893.73,2863670.38,6776.65,1118147.25,0.00,0.00,0.00,0.00,0.00),('5','107','696','219209',4232948,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','219209',4232949,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','219209',4232950,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','219209',4232951,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','219209',4232952,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','219209',4232953,'1895','290',669933.95,670785.21,851.26,140457.90,0.00,0.00,0.00,0.00,0.00),('5','107','698','219209',4232954,'1896','290',223539.65,224606.24,1066.59,175987.35,0.00,0.00,0.00,0.00,0.00),('5','107','698','219209',4232955,'1897','290',401038.02,401038.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','219209',4232956,'1898','290',64695.71,64695.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','219209',4232957,'1899','290',1831636.85,1835955.03,4318.18,712499.70,0.00,0.00,0.00,0.00,0.00),('5','107','699','219209',4232958,'1900','290',402090.19,403084.02,993.83,163981.95,0.00,0.00,0.00,0.00,0.00),('5','107','699','219209',4232959,'1901','290',997569.01,1000870.93,3301.92,544816.80,0.00,0.00,0.00,0.00,0.00),('5','107','699','219209',4232960,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','219209',4232961,'1903','290',1055652.60,1055652.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','219209',4232962,'1904','290',1073284.68,1075961.85,2677.17,441733.05,0.00,0.00,0.00,0.00,0.00),('5','107','700','219209',4232963,'1905','290',1480064.95,1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','219209',4232964,'1906','290',560393.09,563421.36,3028.27,499664.55,0.00,0.00,0.00,0.00,0.00),('5','107','701','219209',4232965,'1907','290',1873770.48,1873770.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','219209',4232966,'1908','290',600795.42,600795.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','219209',4232967,'1909','290',454680.07,454680.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','219209',4232968,'1910','290',374786.82,374786.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','219209',4232969,'1911','290',1024334.50,1024432.36,97.86,16146.90,0.00,0.00,0.00,0.00,0.00),('5','107','702','219209',4232970,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','219209',4232971,'1913','290',564864.81,565060.16,195.35,32232.75,0.00,0.00,0.00,0.00,0.00),('5','107','702','219209',4232972,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','219209',4232973,'1915','290',226570.63,226570.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','219209',4232974,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','219209',4232975,'1917','290',921145.57,925083.51,3937.94,649760.10,0.00,0.00,0.00,0.00,0.00),('5','107','703','219209',4232976,'1918','290',138083.62,138083.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','219209',4232977,'1919','290',427411.30,428389.54,978.24,161409.60,0.00,0.00,0.00,0.00,0.00),('5','107','703','219209',4232978,'1920','290',97332.11,97332.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','219209',4232979,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','219209',4232980,'1922','290',68216.25,68216.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','219209',4232981,'1923','290',720977.72,720977.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','219209',4232982,'1924','290',69026.52,69026.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','219209',4232983,'1925','290',1463328.02,1468742.27,5414.25,893351.25,0.00,0.00,0.00,0.00,0.00),('5','107','705','219209',4232984,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','219209',4232985,'1927','290',439512.34,439512.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','219209',4232986,'1928','290',104323.08,107910.52,3587.44,591927.60,0.00,0.00,0.00,0.00,0.00),('5','107','706','219209',4232987,'1929','291',3248840.99,3258475.93,9634.94,2842307.30,0.00,0.00,0.00,0.00,0.00),('5','107','706','219209',4232988,'1930','291',2242201.41,2248014.00,5812.59,1714714.05,0.00,0.00,0.00,0.00,0.00),('5','107','706','219209',4232989,'1931','291',3438883.97,3443438.07,4554.10,1343459.50,0.00,0.00,0.00,0.00,0.00),('5','107','706','219209',4232990,'1932','291',2944777.24,2948406.24,3629.00,1070555.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','219209',4232991,'1933','291',3911817.36,3918697.83,6880.47,2029738.65,0.00,0.00,0.00,0.00,0.00),('5','107','708','219209',4232992,'1934','291',1482181.49,1488698.32,6516.83,1922464.85,0.00,0.00,0.00,0.00,0.00),('5','107','706','219209',4232993,'2898','291',2681074.14,2685979.84,4905.70,1447181.50,0.00,0.00,0.00,0.00,0.00),('5','107','708','219209',4232994,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','219677',4241057,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','219677',4241058,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','219677',4241059,'1877','290',743194.81,743194.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','219677',4241060,'1878','290',175330.29,175330.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','219677',4241061,'1879','290',831722.94,833343.42,1620.48,267379.20,0.00,0.00,0.00,0.00,0.00),('5','107','696','219677',4241062,'1880','290',104424.43,104424.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','219677',4241063,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','219677',4241064,'1882','290',1035757.70,1035757.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','219677',4241065,'1883','290',516277.46,516277.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','219677',4241066,'1884','290',113480.65,113480.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','219677',4241067,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','219677',4241068,'1886','290',1951618.61,1956558.64,4940.03,815104.95,0.00,0.00,0.00,0.00,0.00),('5','107','697','219677',4241069,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','219677',4241070,'1888','290',132381.43,136579.89,4198.46,692745.90,0.00,0.00,0.00,0.00,0.00),('5','107','696','219677',4241071,'1889','290',2863670.38,2870786.89,7116.51,1174224.15,0.00,0.00,0.00,0.00,0.00),('5','107','696','219677',4241072,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','219677',4241073,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','219677',4241074,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','219677',4241075,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','219677',4241076,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','219677',4241077,'1895','290',670785.21,670785.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','219677',4241078,'1896','290',224606.24,225513.82,907.58,149750.70,0.00,0.00,0.00,0.00,0.00),('5','107','698','219677',4241079,'1897','290',401038.02,402749.43,1711.41,282382.65,0.00,0.00,0.00,0.00,0.00),('5','107','698','219677',4241080,'1898','290',64695.71,64695.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','219677',4241081,'1899','290',1835955.03,1837809.93,1854.90,306058.50,0.00,0.00,0.00,0.00,0.00),('5','107','699','219677',4241082,'1900','290',403084.02,403084.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','219677',4241083,'1901','290',1000870.93,1003335.87,2464.94,406715.10,0.00,0.00,0.00,0.00,0.00),('5','107','699','219677',4241084,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','219677',4241085,'1903','290',1055652.60,1055652.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','219677',4241086,'1904','290',1075961.85,1075961.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','219677',4241087,'1905','290',1480064.95,1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','219677',4241088,'1906','290',563421.36,563421.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','219677',4241089,'1907','290',1873770.48,1874593.57,823.09,135809.85,0.00,0.00,0.00,0.00,0.00),('5','107','701','219677',4241090,'1908','290',600795.42,600795.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','219677',4241091,'1909','290',454680.07,454680.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','219677',4241092,'1910','290',374786.82,374786.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','219677',4241093,'1911','290',1024432.36,1026963.19,2530.83,417586.95,0.00,0.00,0.00,0.00,0.00),('5','107','702','219677',4241094,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','219677',4241095,'1913','290',565060.16,565429.07,368.91,60870.15,0.00,0.00,0.00,0.00,0.00),('5','107','702','219677',4241096,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','219677',4241097,'1915','290',226570.63,226570.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','219677',4241098,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','219677',4241099,'1917','290',925083.51,927284.16,2200.65,363107.25,0.00,0.00,0.00,0.00,0.00),('5','107','703','219677',4241100,'1918','290',138083.62,138083.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','219677',4241101,'1919','290',428389.54,428389.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','219677',4241102,'1920','290',97332.11,97332.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','219677',4241103,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','219677',4241104,'1922','290',68216.25,68216.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','219677',4241105,'1923','290',720977.72,720977.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','219677',4241106,'1924','290',69026.52,69026.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','219677',4241107,'1925','290',1468742.27,1472249.79,3507.52,578740.80,0.00,0.00,0.00,0.00,0.00),('5','107','705','219677',4241108,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','219677',4241109,'1927','290',439512.34,439512.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','219677',4241110,'1928','290',107910.52,110444.27,2533.75,418068.75,0.00,0.00,0.00,0.00,0.00),('5','107','706','219677',4241111,'1929','291',3258475.93,3265095.44,6619.51,1952755.45,0.00,0.00,0.00,0.00,0.00),('5','107','706','219677',4241112,'1930','291',2248014.00,2251634.52,3620.52,1068053.40,0.00,0.00,0.00,0.00,0.00),('5','107','706','219677',4241113,'1931','291',3443438.07,3446522.13,3084.06,909797.70,0.00,0.00,0.00,0.00,0.00),('5','107','706','219677',4241114,'1932','291',2948406.24,2950985.07,2578.83,760754.85,0.00,0.00,0.00,0.00,0.00),('5','107','706','219677',4241115,'1933','291',3918697.83,3924338.93,5641.10,1664124.50,0.00,0.00,0.00,0.00,0.00),('5','107','708','219677',4241116,'1934','291',1488698.32,1494265.21,5566.89,1642232.55,0.00,0.00,0.00,0.00,0.00),('5','107','706','219677',4241117,'2898','291',2685979.84,2687955.15,1975.31,582716.45,0.00,0.00,0.00,0.00,0.00),('5','107','708','219677',4241118,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','219697',4241556,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','219697',4241557,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','219697',4241558,'1877','290',743194.81,745820.94,2626.13,433311.45,0.00,0.00,0.00,0.00,0.00),('5','107','696','219697',4241559,'1878','290',175330.29,175330.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','219697',4241560,'1879','290',833343.42,834106.68,763.26,125937.90,0.00,0.00,0.00,0.00,0.00),('5','107','696','219697',4241561,'1880','290',104424.43,104424.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','219697',4241562,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','219697',4241563,'1882','290',1035757.70,1035757.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','219697',4241564,'1883','290',516277.46,516277.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','219697',4241565,'1884','290',113480.65,113480.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','219697',4241566,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','219697',4241567,'1886','290',1956558.64,1962604.97,6046.33,997644.45,0.00,0.00,0.00,0.00,0.00),('5','107','697','219697',4241568,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','219697',4241569,'1888','290',136579.89,141663.81,5083.92,838846.80,0.00,0.00,0.00,0.00,0.00),('5','107','696','219697',4241570,'1889','290',2870786.89,2877156.32,6369.43,1050955.95,0.00,0.00,0.00,0.00,0.00),('5','107','696','219697',4241571,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','219697',4241572,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','219697',4241573,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','219697',4241574,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','219697',4241575,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','219697',4241576,'1895','290',670785.21,671559.85,774.64,127815.60,0.00,0.00,0.00,0.00,0.00),('5','107','698','219697',4241577,'1896','290',225513.82,225513.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','219697',4241578,'1897','290',402749.43,402749.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','219697',4241579,'1898','290',64695.71,64695.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','219697',4241580,'1899','290',1837809.93,1838146.74,336.81,55573.65,0.00,0.00,0.00,0.00,0.00),('5','107','699','219697',4241581,'1900','290',403084.02,403084.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','219697',4241582,'1901','290',1003335.87,1004889.48,1553.61,256345.65,0.00,0.00,0.00,0.00,0.00),('5','107','699','219697',4241583,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','219697',4241584,'1903','290',1055652.60,1055652.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','219697',4241585,'1904','290',1075961.85,1075961.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','219697',4241586,'1905','290',1480064.95,1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','219697',4241587,'1906','290',563421.36,563421.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','219697',4241588,'1907','290',1874593.57,1879202.94,4609.37,760546.05,0.00,0.00,0.00,0.00,0.00),('5','107','701','219697',4241589,'1908','290',600795.42,600795.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','219697',4241590,'1909','290',454680.07,454680.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','219697',4241591,'1910','290',374786.82,374786.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','219697',4241592,'1911','290',1026963.19,1029300.22,2337.03,385609.95,0.00,0.00,0.00,0.00,0.00),('5','107','702','219697',4241593,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','219697',4241594,'1913','290',565429.07,565436.03,6.96,1148.40,0.00,0.00,0.00,0.00,0.00),('5','107','702','219697',4241595,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','219697',4241596,'1915','290',226570.63,227061.14,490.51,80934.15,0.00,0.00,0.00,0.00,0.00),('5','107','702','219697',4241597,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','219697',4241598,'1917','290',927284.16,930065.92,2781.76,458990.40,0.00,0.00,0.00,0.00,0.00),('5','107','703','219697',4241599,'1918','290',138083.62,138083.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','219697',4241600,'1919','290',428389.54,428389.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','219697',4241601,'1920','290',97332.11,97332.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','219697',4241602,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','219697',4241603,'1922','290',68216.25,68216.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','219697',4241604,'1923','290',720977.72,720977.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','219697',4241605,'1924','290',69026.52,69026.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','219697',4241606,'1925','290',1472249.79,1475722.71,3472.92,573031.80,0.00,0.00,0.00,0.00,0.00),('5','107','705','219697',4241607,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','219697',4241608,'1927','290',439512.34,440147.25,634.91,104760.15,0.00,0.00,0.00,0.00,0.00),('5','107','705','219697',4241609,'1928','290',110444.27,110444.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','219697',4241610,'1929','291',3265095.44,3273412.79,8317.35,2453618.25,0.00,0.00,0.00,0.00,0.00),('5','107','706','219697',4241611,'1930','291',2251634.52,2254959.59,3325.07,980895.65,0.00,0.00,0.00,0.00,0.00),('5','107','706','219697',4241612,'1931','291',3446522.13,3453000.83,6478.70,1911216.50,0.00,0.00,0.00,0.00,0.00),('5','107','706','219697',4241613,'1932','291',2950985.07,2952838.25,1853.18,546688.10,0.00,0.00,0.00,0.00,0.00),('5','107','706','219697',4241614,'1933','291',3924338.93,3930036.41,5697.48,1680756.60,0.00,0.00,0.00,0.00,0.00),('5','107','708','219697',4241615,'1934','291',1494265.21,1495615.24,1350.03,398258.85,0.00,0.00,0.00,0.00,0.00),('5','107','706','219697',4241616,'2898','291',2687955.15,2692681.07,4725.92,1394146.40,0.00,0.00,0.00,0.00,0.00),('5','107','708','219697',4241617,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','219846',4244167,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','219846',4244168,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','219846',4244169,'1877','290',745820.94,747046.62,1225.68,202237.20,0.00,0.00,0.00,0.00,0.00),('5','107','696','219846',4244170,'1878','290',175330.29,175330.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','219846',4244171,'1879','290',834106.68,834688.94,582.26,96072.90,0.00,0.00,0.00,0.00,0.00),('5','107','696','219846',4244172,'1880','290',104424.43,104424.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','219846',4244173,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','219846',4244174,'1882','290',1035757.70,1037256.35,1498.65,247277.25,0.00,0.00,0.00,0.00,0.00),('5','107','697','219846',4244175,'1883','290',516277.46,516277.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','219846',4244176,'1884','290',113480.65,113480.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','219846',4244177,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','219846',4244178,'1886','290',1962604.97,1967898.27,5293.30,873394.50,0.00,0.00,0.00,0.00,0.00),('5','107','697','219846',4244179,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','219846',4244180,'1888','290',141663.81,144212.11,2548.30,420469.50,0.00,0.00,0.00,0.00,0.00),('5','107','696','219846',4244181,'1889','290',2877156.32,2883029.06,5872.74,969002.10,0.00,0.00,0.00,0.00,0.00),('5','107','696','219846',4244182,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','219846',4244183,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','219846',4244184,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','219846',4244185,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','219846',4244186,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','219846',4244187,'1895','290',671559.85,672496.49,936.64,154545.60,0.00,0.00,0.00,0.00,0.00),('5','107','698','219846',4244188,'1896','290',225513.82,225513.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','219846',4244189,'1897','290',402749.43,402749.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','219846',4244190,'1898','290',64695.71,64695.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','219846',4244191,'1899','290',1838146.74,1839302.09,1155.35,190632.75,0.00,0.00,0.00,0.00,0.00),('5','107','699','219846',4244192,'1900','290',403084.02,403084.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','219846',4244193,'1901','290',1004889.48,1004900.08,10.60,1749.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','219846',4244194,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','219846',4244195,'1903','290',1055652.60,1055652.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','219846',4244196,'1904','290',1075961.85,1078540.90,2579.05,425543.25,0.00,0.00,0.00,0.00,0.00),('5','107','700','219846',4244197,'1905','290',1480064.95,1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','219846',4244198,'1906','290',563421.36,564173.34,751.98,124076.70,0.00,0.00,0.00,0.00,0.00),('5','107','701','219846',4244199,'1907','290',1879202.94,1881474.02,2271.08,374728.20,0.00,0.00,0.00,0.00,0.00),('5','107','701','219846',4244200,'1908','290',600795.42,600795.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','219846',4244201,'1909','290',454680.07,454680.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','219846',4244202,'1910','290',374786.82,374786.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','219846',4244203,'1911','290',1029300.22,1031756.92,2456.70,405355.50,0.00,0.00,0.00,0.00,0.00),('5','107','702','219846',4244204,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','219846',4244205,'1913','290',565436.03,566728.13,1292.10,213196.50,0.00,0.00,0.00,0.00,0.00),('5','107','702','219846',4244206,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','219846',4244207,'1915','290',227061.14,227061.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','219846',4244208,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','219846',4244209,'1917','290',930065.92,931885.60,1819.68,300247.20,0.00,0.00,0.00,0.00,0.00),('5','107','703','219846',4244210,'1918','290',138083.62,138083.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','219846',4244211,'1919','290',428389.54,428389.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','219846',4244212,'1920','290',97332.11,97332.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','219846',4244213,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','219846',4244214,'1922','290',68216.25,68216.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','219846',4244215,'1923','290',720977.72,720977.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','219846',4244216,'1924','290',69026.52,69026.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','219846',4244217,'1925','290',1475722.71,1477377.33,1654.62,273012.30,0.00,0.00,0.00,0.00,0.00),('5','107','705','219846',4244218,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','219846',4244219,'1927','290',440147.25,441116.44,969.19,159916.35,0.00,0.00,0.00,0.00,0.00),('5','107','705','219846',4244220,'1928','290',110444.27,110444.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','219846',4244221,'1929','291',3273412.79,3282136.27,8723.48,2573426.60,0.00,0.00,0.00,0.00,0.00),('5','107','706','219846',4244222,'1930','291',2254959.59,2256899.24,1939.65,572196.75,0.00,0.00,0.00,0.00,0.00),('5','107','706','219846',4244223,'1931','291',3453000.83,3458786.98,5786.15,1706914.25,0.00,0.00,0.00,0.00,0.00),('5','107','706','219846',4244224,'1932','291',2952838.25,2956755.87,3917.62,1155697.90,0.00,0.00,0.00,0.00,0.00),('5','107','706','219846',4244225,'1933','291',3930036.41,3937351.81,7315.40,2158043.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','219846',4244226,'1934','291',1495615.24,1497107.17,1491.93,440119.35,0.00,0.00,0.00,0.00,0.00),('5','107','706','219846',4244227,'2898','291',2692681.07,2694836.39,2155.32,635819.40,0.00,0.00,0.00,0.00,0.00),('5','107','708','219846',4244228,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','219862',4244474,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','219862',4244475,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','219862',4244476,'1877','290',747046.62,747531.38,484.76,79985.40,0.00,0.00,0.00,0.00,0.00),('5','107','696','219862',4244477,'1878','290',175330.29,175330.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','219862',4244478,'1879','290',834688.94,835007.37,318.43,52540.95,0.00,0.00,0.00,0.00,0.00),('5','107','696','219862',4244479,'1880','290',104424.43,104424.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','219862',4244480,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','219862',4244481,'1882','290',1037256.35,1039686.55,2430.20,400983.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','219862',4244482,'1883','290',516277.46,516277.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','219862',4244483,'1884','290',113480.65,113480.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','219862',4244484,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','219862',4244485,'1886','290',1967898.27,1973621.14,5722.87,944273.55,0.00,0.00,0.00,0.00,0.00),('5','107','697','219862',4244486,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','219862',4244487,'1888','290',144212.11,144212.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','219862',4244488,'1889','290',2883029.06,2888718.75,5689.69,938798.85,0.00,0.00,0.00,0.00,0.00),('5','107','696','219862',4244489,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','219862',4244490,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','219862',4244491,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','219862',4244492,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','219862',4244493,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','219862',4244494,'1895','290',672496.49,672496.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','219862',4244495,'1896','290',225513.82,225513.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','219862',4244496,'1897','290',402749.43,402960.22,210.79,34780.35,0.00,0.00,0.00,0.00,0.00),('5','107','698','219862',4244497,'1898','290',64695.71,64695.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','219862',4244498,'1899','290',1839302.09,1839302.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','219862',4244499,'1900','290',403084.02,403084.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','219862',4244500,'1901','290',1004900.08,1007059.12,2159.04,356241.60,0.00,0.00,0.00,0.00,0.00),('5','107','699','219862',4244501,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','219862',4244502,'1903','290',1055652.60,1055652.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','219862',4244503,'1904','290',1078540.90,1082003.83,3462.93,571383.45,0.00,0.00,0.00,0.00,0.00),('5','107','700','219862',4244504,'1905','290',1480064.95,1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','219862',4244505,'1906','290',564173.34,567197.67,3024.33,499014.45,0.00,0.00,0.00,0.00,0.00),('5','107','701','219862',4244506,'1907','290',1881474.02,1885224.75,3750.73,618870.45,0.00,0.00,0.00,0.00,0.00),('5','107','701','219862',4244507,'1908','290',600795.42,600795.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','219862',4244508,'1909','290',454680.07,454680.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','219862',4244509,'1910','290',374786.82,374786.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','219862',4244510,'1911','290',1031756.92,1033799.64,2042.72,337048.80,0.00,0.00,0.00,0.00,0.00),('5','107','702','219862',4244511,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','219862',4244512,'1913','290',566728.13,566728.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','219862',4244513,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','219862',4244514,'1915','290',227061.14,227061.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','219862',4244515,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','219862',4244516,'1917','290',931885.60,933468.50,1582.90,261178.50,0.00,0.00,0.00,0.00,0.00),('5','107','703','219862',4244517,'1918','290',138083.62,138083.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','219862',4244518,'1919','290',428389.54,428389.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','219862',4244519,'1920','290',97332.11,97332.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','219862',4244520,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','219862',4244521,'1922','290',68216.25,68216.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','219862',4244522,'1923','290',720977.72,720977.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','219862',4244523,'1924','290',69026.52,69026.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','219862',4244524,'1925','290',1477377.33,1480627.28,3249.95,536241.75,0.00,0.00,0.00,0.00,0.00),('5','107','705','219862',4244525,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','219862',4244526,'1927','290',441116.44,441116.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','219862',4244527,'1928','290',110444.27,110444.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','219862',4244528,'1929','291',3282136.27,3288709.59,6573.32,1939129.40,0.00,0.00,0.00,0.00,0.00),('5','107','706','219862',4244529,'1930','291',2256899.24,2261482.04,4582.80,1351926.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','219862',4244530,'1931','291',3458786.98,3462146.30,3359.32,990999.40,0.00,0.00,0.00,0.00,0.00),('5','107','706','219862',4244531,'1932','291',2956755.87,2960587.82,3831.95,1130425.25,0.00,0.00,0.00,0.00,0.00),('5','107','706','219862',4244532,'1933','291',3937351.81,3943812.33,6460.52,1905853.40,0.00,0.00,0.00,0.00,0.00),('5','107','708','219862',4244533,'1934','291',1497107.17,1503112.65,6005.48,1771616.60,0.00,0.00,0.00,0.00,0.00),('5','107','706','219862',4244534,'2898','291',2694836.39,2700835.59,5999.20,1769764.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','219862',4244535,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','220272',4251701,'1875','290',1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','220272',4251702,'1876','290',1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','220272',4251703,'1877','290',747531.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','220272',4251704,'1878','290',175330.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','220272',4251705,'1879','290',835007.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','220272',4251706,'1880','290',104424.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','220272',4251707,'1881','290',1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','220272',4251708,'1882','290',1039686.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','220272',4251709,'1883','290',516277.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','220272',4251710,'1884','290',113480.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','220272',4251711,'1885','290',1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','220272',4251712,'1886','290',1973621.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','220272',4251713,'1887','290',205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','220272',4251714,'1888','290',144212.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','220272',4251715,'1889','290',2888718.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','220272',4251716,'1890','290',682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','220272',4251717,'1891','290',1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','220272',4251718,'1892','290',1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','220272',4251719,'1893','290',1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','220272',4251720,'1894','290',1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','220272',4251721,'1895','290',672496.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','220272',4251722,'1896','290',225513.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','220272',4251723,'1897','290',402960.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','220272',4251724,'1898','290',64695.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','220272',4251725,'1899','290',1839302.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','220272',4251726,'1900','290',403084.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','220272',4251727,'1901','290',1007059.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','220272',4251728,'1902','290',36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','220272',4251729,'1903','290',1055652.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','220272',4251730,'1904','290',1082003.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','220272',4251731,'1905','290',1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','220272',4251732,'1906','290',567197.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','220272',4251733,'1907','290',1885224.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','220272',4251734,'1908','290',600795.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','220272',4251735,'1909','290',454680.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','220272',4251736,'1910','290',374786.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','220272',4251737,'1911','290',1033799.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','220272',4251738,'1912','290',196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','220272',4251739,'1913','290',566728.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','220272',4251740,'1914','290',64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','220272',4251741,'1915','290',227061.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','220272',4251742,'1916','290',22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','220272',4251743,'1917','290',933468.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','220272',4251744,'1918','290',138083.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','220272',4251745,'1919','290',428389.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','220272',4251746,'1920','290',97332.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','220272',4251747,'1921','290',922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','220272',4251748,'1922','290',68216.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','220272',4251749,'1923','290',720977.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','220272',4251750,'1924','290',69026.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','220272',4251751,'1925','290',1480627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','220272',4251752,'1926','290',45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','220272',4251753,'1927','290',441116.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','220272',4251754,'1928','290',110444.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','220272',4251755,'1929','291',3288709.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','220272',4251756,'1930','291',2261482.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','220272',4251757,'1931','291',3462146.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','220272',4251758,'1932','291',2960587.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','220272',4251759,'1933','291',3943812.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','220272',4251760,'1934','291',1503112.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','220272',4251761,'2898','291',2700835.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','220272',4251762,'2899','291',3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','220406',4254442,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','220406',4254443,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','220406',4254444,'1877','290',747531.38,748202.97,671.59,110812.35,0.00,0.00,0.00,0.00,0.00),('5','107','696','220406',4254445,'1878','290',175330.29,175330.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','220406',4254446,'1879','290',835007.37,835382.64,375.27,61919.55,0.00,0.00,0.00,0.00,0.00),('5','107','696','220406',4254447,'1880','290',104424.43,104424.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','220406',4254448,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','220406',4254449,'1882','290',1039686.55,1040118.35,431.80,71247.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','220406',4254450,'1883','290',516277.46,516277.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','220406',4254451,'1884','290',113480.65,113480.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','220406',4254452,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','220406',4254453,'1886','290',1973621.14,1974434.95,813.81,134278.65,0.00,0.00,0.00,0.00,0.00),('5','107','697','220406',4254454,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','220406',4254455,'1888','290',144212.11,144212.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','220406',4254456,'1889','290',2888718.75,2890212.39,1493.64,246450.60,0.00,0.00,0.00,0.00,0.00),('5','107','696','220406',4254457,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','220406',4254458,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','220406',4254459,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','220406',4254460,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','220406',4254461,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','220406',4254462,'1895','290',672496.49,672578.89,82.40,13596.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','220406',4254463,'1896','290',225513.82,225513.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','220406',4254464,'1897','290',402960.22,402960.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','220406',4254465,'1898','290',64695.71,64695.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','220406',4254466,'1899','290',1839302.09,1842355.22,3053.13,503766.45,0.00,0.00,0.00,0.00,0.00),('5','107','699','220406',4254467,'1900','290',403084.02,403084.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','220406',4254468,'1901','290',1007059.12,1009053.12,1994.00,329010.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','220406',4254469,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','220406',4254470,'1903','290',1055652.60,1055652.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','220406',4254471,'1904','290',1082003.83,1085318.72,3314.89,546956.85,0.00,0.00,0.00,0.00,0.00),('5','107','700','220406',4254472,'1905','290',1480064.95,1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','220406',4254473,'1906','290',567197.67,570261.42,3063.75,505518.75,0.00,0.00,0.00,0.00,0.00),('5','107','701','220406',4254474,'1907','290',1885224.75,1891084.14,5859.39,966799.35,0.00,0.00,0.00,0.00,0.00),('5','107','701','220406',4254475,'1908','290',600795.42,600795.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','220406',4254476,'1909','290',454680.07,455997.30,1317.23,217342.95,0.00,0.00,0.00,0.00,0.00),('5','107','701','220406',4254477,'1910','290',374786.82,374786.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','220406',4254478,'1911','290',1033799.64,1035768.93,1969.29,324932.85,0.00,0.00,0.00,0.00,0.00),('5','107','702','220406',4254479,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','220406',4254480,'1913','290',566728.13,568264.35,1536.22,253476.30,0.00,0.00,0.00,0.00,0.00),('5','107','702','220406',4254481,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','220406',4254482,'1915','290',227061.14,227944.03,882.89,145676.85,0.00,0.00,0.00,0.00,0.00),('5','107','702','220406',4254483,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','220406',4254484,'1917','290',933468.50,936937.82,3469.32,572437.80,0.00,0.00,0.00,0.00,0.00),('5','107','703','220406',4254485,'1918','290',138083.62,138083.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','220406',4254486,'1919','290',428389.54,430429.21,2039.67,336545.55,0.00,0.00,0.00,0.00,0.00),('5','107','703','220406',4254487,'1920','290',97332.11,97332.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','220406',4254488,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','220406',4254489,'1922','290',68216.25,68216.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','220406',4254490,'1923','290',720977.72,720977.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','220406',4254491,'1924','290',69026.52,69026.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','220406',4254492,'1925','290',1480627.28,1484014.69,3387.41,558922.65,0.00,0.00,0.00,0.00,0.00),('5','107','705','220406',4254493,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','220406',4254494,'1927','290',441116.44,442118.70,1002.26,165372.90,0.00,0.00,0.00,0.00,0.00),('5','107','705','220406',4254495,'1928','290',110444.27,110866.82,422.55,69720.75,0.00,0.00,0.00,0.00,0.00),('5','107','706','220406',4254496,'1929','291',3288709.59,3295980.61,7271.02,2144950.90,0.00,0.00,0.00,0.00,0.00),('5','107','706','220406',4254497,'1930','291',2261482.04,2264713.35,3231.31,953236.45,0.00,0.00,0.00,0.00,0.00),('5','107','706','220406',4254498,'1931','291',3462146.30,3466629.61,4483.31,1322576.45,0.00,0.00,0.00,0.00,0.00),('5','107','706','220406',4254499,'1932','291',2960587.82,2964912.57,4324.75,1275801.25,0.00,0.00,0.00,0.00,0.00),('5','107','706','220406',4254500,'1933','291',3943812.33,3948275.55,4463.22,1316649.90,0.00,0.00,0.00,0.00,0.00),('5','107','708','220406',4254501,'1934','291',1503112.65,1509471.41,6358.76,1875834.20,0.00,0.00,0.00,0.00,0.00),('5','107','706','220406',4254502,'2898','291',2700835.59,2704652.21,3816.62,1125902.90,0.00,0.00,0.00,0.00,0.00),('5','107','708','220406',4254503,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','220414',4254647,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','220414',4254648,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','220414',4254649,'1877','290',748202.97,749297.23,1094.26,180552.90,0.00,0.00,0.00,0.00,0.00),('5','107','696','220414',4254650,'1878','290',175330.29,175330.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','220414',4254651,'1879','290',835382.64,835382.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','220414',4254652,'1880','290',104424.43,104424.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','220414',4254653,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','220414',4254654,'1882','290',1040118.35,1041866.09,1747.74,288377.10,0.00,0.00,0.00,0.00,0.00),('5','107','697','220414',4254655,'1883','290',516277.46,516277.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','220414',4254656,'1884','290',113480.65,113480.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','220414',4254657,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','220414',4254658,'1886','290',1974434.95,1979225.02,4790.07,790361.55,0.00,0.00,0.00,0.00,0.00),('5','107','697','220414',4254659,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','220414',4254660,'1888','290',144212.11,144212.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','220414',4254661,'1889','290',2890212.39,2896055.02,5842.63,964033.95,0.00,0.00,0.00,0.00,0.00),('5','107','696','220414',4254662,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','220414',4254663,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','220414',4254664,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','220414',4254665,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','220414',4254666,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','220414',4254667,'1895','290',672578.89,672977.75,398.86,65811.90,0.00,0.00,0.00,0.00,0.00),('5','107','698','220414',4254668,'1896','290',225513.82,226120.05,606.23,100027.95,0.00,0.00,0.00,0.00,0.00),('5','107','698','220414',4254669,'1897','290',402960.22,403055.91,95.69,15788.85,0.00,0.00,0.00,0.00,0.00),('5','107','698','220414',4254670,'1898','290',64695.71,65028.38,332.67,54890.55,0.00,0.00,0.00,0.00,0.00),('5','107','699','220414',4254671,'1899','290',1842355.22,1844553.76,2198.54,362759.10,0.00,0.00,0.00,0.00,0.00),('5','107','699','220414',4254672,'1900','290',403084.02,403084.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','220414',4254673,'1901','290',1009053.12,1009053.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','220414',4254674,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','220414',4254675,'1903','290',1055652.60,1055652.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','220414',4254676,'1904','290',1085318.72,1088464.18,3145.46,519000.90,0.00,0.00,0.00,0.00,0.00),('5','107','700','220414',4254677,'1905','290',1480064.95,1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','220414',4254678,'1906','290',570261.42,571697.88,1436.46,237015.90,0.00,0.00,0.00,0.00,0.00),('5','107','701','220414',4254679,'1907','290',1891084.14,1894756.00,3671.86,605856.90,0.00,0.00,0.00,0.00,0.00),('5','107','701','220414',4254680,'1908','290',600795.42,600795.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','220414',4254681,'1909','290',455997.30,455997.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','220414',4254682,'1910','290',374786.82,374786.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','220414',4254683,'1911','290',1035768.93,1036253.64,484.71,79977.15,0.00,0.00,0.00,0.00,0.00),('5','107','702','220414',4254684,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','220414',4254685,'1913','290',568264.35,568732.09,467.74,77177.10,0.00,0.00,0.00,0.00,0.00),('5','107','702','220414',4254686,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','220414',4254687,'1915','290',227944.03,227944.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','220414',4254688,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','220414',4254689,'1917','290',936937.82,938696.38,1758.56,290162.40,0.00,0.00,0.00,0.00,0.00),('5','107','703','220414',4254690,'1918','290',138083.62,138083.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','220414',4254691,'1919','290',430429.21,430793.61,364.40,60126.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','220414',4254692,'1920','290',97332.11,97332.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','220414',4254693,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','220414',4254694,'1922','290',68216.25,68216.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','220414',4254695,'1923','290',720977.72,720977.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','220414',4254696,'1924','290',69026.52,69026.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','220414',4254697,'1925','290',1484014.69,1487047.80,3033.11,500463.15,0.00,0.00,0.00,0.00,0.00),('5','107','705','220414',4254698,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','220414',4254699,'1927','290',442118.70,443351.04,1232.34,203336.10,0.00,0.00,0.00,0.00,0.00),('5','107','705','220414',4254700,'1928','290',110866.82,110866.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','220414',4254701,'1929','291',3295980.61,3304820.70,8840.09,2607826.55,0.00,0.00,0.00,0.00,0.00),('5','107','706','220414',4254702,'1930','291',2264713.35,2268551.19,3837.84,1132162.80,0.00,0.00,0.00,0.00,0.00),('5','107','706','220414',4254703,'1931','291',3466629.61,3471504.96,4875.35,1438228.25,0.00,0.00,0.00,0.00,0.00),('5','107','706','220414',4254704,'1932','291',2964912.57,2970040.90,5128.33,1512857.35,0.00,0.00,0.00,0.00,0.00),('5','107','706','220414',4254705,'1933','291',3948275.55,3953905.56,5630.01,1660852.95,0.00,0.00,0.00,0.00,0.00),('5','107','708','220414',4254706,'1934','291',1509471.41,1510704.32,1232.91,363708.45,0.00,0.00,0.00,0.00,0.00),('5','107','706','220414',4254707,'2898','291',2704652.21,2706938.03,2285.82,674316.90,0.00,0.00,0.00,0.00,0.00),('5','107','708','220414',4254708,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','220819',4261488,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','220819',4261489,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','220819',4261490,'1877','290',749297.23,749760.50,463.27,76439.55,0.00,0.00,0.00,0.00,0.00),('5','107','696','220819',4261491,'1878','290',175330.29,175330.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','220819',4261492,'1879','290',835382.64,835802.99,420.35,69357.75,0.00,0.00,0.00,0.00,0.00),('5','107','696','220819',4261493,'1880','290',104424.43,104424.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','220819',4261494,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','220819',4261495,'1882','290',1041866.09,1045263.42,3397.33,560559.45,0.00,0.00,0.00,0.00,0.00),('5','107','697','220819',4261496,'1883','290',516277.46,516277.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','220819',4261497,'1884','290',113480.65,113480.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','220819',4261498,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','220819',4261499,'1886','290',1979225.02,1984725.54,5500.52,907585.80,0.00,0.00,0.00,0.00,0.00),('5','107','697','220819',4261500,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','220819',4261501,'1888','290',144212.11,144938.84,726.73,119910.45,0.00,0.00,0.00,0.00,0.00),('5','107','696','220819',4261502,'1889','290',2896055.02,2901067.33,5012.31,827031.15,0.00,0.00,0.00,0.00,0.00),('5','107','696','220819',4261503,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','220819',4261504,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','220819',4261505,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','220819',4261506,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','220819',4261507,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','220819',4261508,'1895','290',672977.75,673551.01,573.26,94587.90,0.00,0.00,0.00,0.00,0.00),('5','107','698','220819',4261509,'1896','290',226120.05,226120.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','220819',4261510,'1897','290',403055.91,403055.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','220819',4261511,'1898','290',65028.38,65028.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','220819',4261512,'1899','290',1844553.76,1844553.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','220819',4261513,'1900','290',403084.02,403084.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','220819',4261514,'1901','290',1009053.12,1013077.19,4024.07,663971.55,0.00,0.00,0.00,0.00,0.00),('5','107','699','220819',4261515,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','220819',4261516,'1903','290',1055652.60,1055652.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','220819',4261517,'1904','290',1088464.18,1094406.93,5942.75,980553.75,0.00,0.00,0.00,0.00,0.00),('5','107','700','220819',4261518,'1905','290',1480064.95,1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','220819',4261519,'1906','290',571697.88,574669.58,2971.70,490330.50,0.00,0.00,0.00,0.00,0.00),('5','107','701','220819',4261520,'1907','290',1894756.00,1899604.61,4848.61,800020.65,0.00,0.00,0.00,0.00,0.00),('5','107','701','220819',4261521,'1908','290',600795.42,600795.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','220819',4261522,'1909','290',455997.30,455997.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','220819',4261523,'1910','290',374786.82,374786.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','220819',4261524,'1911','290',1036253.64,1037026.19,772.55,127470.75,0.00,0.00,0.00,0.00,0.00),('5','107','702','220819',4261525,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','220819',4261526,'1913','290',568732.09,568732.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','220819',4261527,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','220819',4261528,'1915','290',227944.03,227944.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','220819',4261529,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','220819',4261530,'1917','290',938696.38,940858.53,2162.15,356754.75,0.00,0.00,0.00,0.00,0.00),('5','107','703','220819',4261531,'1918','290',138083.62,138083.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','220819',4261532,'1919','290',430793.61,430793.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','220819',4261533,'1920','290',97332.11,97332.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','220819',4261534,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','220819',4261535,'1922','290',68216.25,68216.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','220819',4261536,'1923','290',720977.72,720977.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','220819',4261537,'1924','290',69026.52,69026.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','220819',4261538,'1925','290',1487047.80,1490862.66,3814.86,629451.90,0.00,0.00,0.00,0.00,0.00),('5','107','705','220819',4261539,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','220819',4261540,'1927','290',443351.04,444260.85,909.81,150118.65,0.00,0.00,0.00,0.00,0.00),('5','107','705','220819',4261541,'1928','290',110866.82,110866.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','220819',4261542,'1929','291',3304820.70,3310432.91,5612.21,1655601.95,0.00,0.00,0.00,0.00,0.00),('5','107','706','220819',4261543,'1930','291',2268551.19,2274296.46,5745.27,1694854.65,0.00,0.00,0.00,0.00,0.00),('5','107','706','220819',4261544,'1931','291',3471504.96,3475716.18,4211.22,1242309.90,0.00,0.00,0.00,0.00,0.00),('5','107','706','220819',4261545,'1932','291',2970040.90,2973102.02,3061.12,903030.40,0.00,0.00,0.00,0.00,0.00),('5','107','706','220819',4261546,'1933','291',3953905.56,3958094.39,4188.83,1235704.85,0.00,0.00,0.00,0.00,0.00),('5','107','708','220819',4261547,'1934','291',1510704.32,1511229.47,525.15,154919.25,0.00,0.00,0.00,0.00,0.00),('5','107','706','220819',4261548,'2898','291',2706938.03,2710482.04,3544.01,1045482.95,0.00,0.00,0.00,0.00,0.00),('5','107','708','220819',4261549,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','220974',4264316,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','220974',4264317,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','220974',4264318,'1877','290',749760.50,750718.32,957.82,158040.30,0.00,0.00,0.00,0.00,0.00),('5','107','696','220974',4264319,'1878','290',175330.29,175330.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','220974',4264320,'1879','290',835802.99,836708.34,905.35,149382.75,0.00,0.00,0.00,0.00,0.00),('5','107','696','220974',4264321,'1880','290',104424.43,104424.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','220974',4264322,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','220974',4264323,'1882','290',1045263.42,1045263.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','220974',4264324,'1883','290',516277.46,516277.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','220974',4264325,'1884','290',113480.65,113480.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','220974',4264326,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','220974',4264327,'1886','290',1984725.54,1990320.75,5595.21,923209.65,0.00,0.00,0.00,0.00,0.00),('5','107','697','220974',4264328,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','220974',4264329,'1888','290',144938.84,147234.53,2295.69,378788.85,0.00,0.00,0.00,0.00,0.00),('5','107','696','220974',4264330,'1889','290',2901067.33,2907555.69,6488.36,1070579.40,0.00,0.00,0.00,0.00,0.00),('5','107','696','220974',4264331,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','220974',4264332,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','220974',4264333,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','220974',4264334,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','220974',4264335,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','220974',4264336,'1895','290',673551.01,675527.60,1976.59,326137.35,0.00,0.00,0.00,0.00,0.00),('5','107','698','220974',4264337,'1896','290',226120.05,226120.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','220974',4264338,'1897','290',403055.91,403055.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','220974',4264339,'1898','290',65028.38,65028.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','220974',4264340,'1899','290',1844553.76,1844553.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','220974',4264341,'1900','290',403084.02,403084.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','220974',4264342,'1901','290',1013077.19,1015141.80,2064.61,340660.65,0.00,0.00,0.00,0.00,0.00),('5','107','699','220974',4264343,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','220974',4264344,'1903','290',1055652.60,1055652.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','220974',4264345,'1904','290',1094406.93,1098735.25,4328.32,714172.80,0.00,0.00,0.00,0.00,0.00),('5','107','700','220974',4264346,'1905','290',1480064.95,1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','220974',4264347,'1906','290',574669.58,576168.59,1499.01,247336.65,0.00,0.00,0.00,0.00,0.00),('5','107','701','220974',4264348,'1907','290',1899604.61,1902573.19,2968.58,489815.70,0.00,0.00,0.00,0.00,0.00),('5','107','701','220974',4264349,'1908','290',600795.42,600795.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','220974',4264350,'1909','290',455997.30,455997.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','220974',4264351,'1910','290',374786.82,374786.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','220974',4264352,'1911','290',1037026.19,1037026.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','220974',4264353,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','220974',4264354,'1913','290',568732.09,568732.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','220974',4264355,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','220974',4264356,'1915','290',227944.03,227944.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','220974',4264357,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','220974',4264358,'1917','290',940858.53,943402.86,2544.33,419814.45,0.00,0.00,0.00,0.00,0.00),('5','107','703','220974',4264359,'1918','290',138083.62,138083.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','220974',4264360,'1919','290',430793.61,430793.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','220974',4264361,'1920','290',97332.11,97332.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','220974',4264362,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','220974',4264363,'1922','290',68216.25,68216.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','220974',4264364,'1923','290',720977.72,720977.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','220974',4264365,'1924','290',69026.52,69026.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','220974',4264366,'1925','290',1490862.66,1493405.82,2543.16,419621.40,0.00,0.00,0.00,0.00,0.00),('5','107','705','220974',4264367,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','220974',4264368,'1927','290',444260.85,445140.69,879.84,145173.60,0.00,0.00,0.00,0.00,0.00),('5','107','705','220974',4264369,'1928','290',110866.82,110866.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','220974',4264370,'1929','291',3310432.91,3318558.79,8125.88,2397134.60,0.00,0.00,0.00,0.00,0.00),('5','107','706','220974',4264371,'1930','291',2274296.46,2276965.36,2668.90,787325.50,0.00,0.00,0.00,0.00,0.00),('5','107','706','220974',4264372,'1931','291',3475716.18,3480720.02,5003.84,1476132.80,0.00,0.00,0.00,0.00,0.00),('5','107','706','220974',4264373,'1932','291',2973102.02,2977798.88,4696.86,1385573.70,0.00,0.00,0.00,0.00,0.00),('5','107','706','220974',4264374,'1933','291',3958094.39,3960549.77,2455.38,724337.10,0.00,0.00,0.00,0.00,0.00),('5','107','708','220974',4264375,'1934','291',1511229.47,1511469.63,240.16,70847.20,0.00,0.00,0.00,0.00,0.00),('5','107','706','220974',4264376,'2898','291',2710482.04,2712788.66,2306.62,680452.90,0.00,0.00,0.00,0.00,0.00),('5','107','708','220974',4264377,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','221008',4264857,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','221008',4264858,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','221008',4264859,'1877','290',750718.32,751642.81,924.49,152540.85,0.00,0.00,0.00,0.00,0.00),('5','107','696','221008',4264860,'1878','290',175330.29,175330.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','221008',4264861,'1879','290',836708.34,836708.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','221008',4264862,'1880','290',104424.43,104424.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','221008',4264863,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','221008',4264864,'1882','290',1045263.42,1045263.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','221008',4264865,'1883','290',516277.46,517543.71,1266.25,208931.25,0.00,0.00,0.00,0.00,0.00),('5','107','697','221008',4264866,'1884','290',113480.65,113480.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','221008',4264867,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','221008',4264868,'1886','290',1990320.75,1996472.49,6151.74,1015037.10,0.00,0.00,0.00,0.00,0.00),('5','107','697','221008',4264869,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','221008',4264870,'1888','290',147234.53,151422.57,4188.04,691026.60,0.00,0.00,0.00,0.00,0.00),('5','107','696','221008',4264871,'1889','290',2907555.69,2913945.55,6389.86,1054326.90,0.00,0.00,0.00,0.00,0.00),('5','107','696','221008',4264872,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','221008',4264873,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','221008',4264874,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','221008',4264875,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','221008',4264876,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','221008',4264877,'1895','290',675527.60,675938.21,410.61,67750.65,0.00,0.00,0.00,0.00,0.00),('5','107','698','221008',4264878,'1896','290',226120.05,227949.79,1829.74,301907.10,0.00,0.00,0.00,0.00,0.00),('5','107','698','221008',4264879,'1897','290',403055.91,403736.49,680.58,112295.70,0.00,0.00,0.00,0.00,0.00),('5','107','698','221008',4264880,'1898','290',65028.38,65028.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','221008',4264881,'1899','290',1844553.76,1847084.61,2530.85,417590.25,0.00,0.00,0.00,0.00,0.00),('5','107','699','221008',4264882,'1900','290',403084.02,403084.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','221008',4264883,'1901','290',1015141.80,1015141.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','221008',4264884,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','221008',4264885,'1903','290',1055652.60,1055652.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','221008',4264886,'1904','290',1098735.25,1103220.50,4485.25,740066.25,0.00,0.00,0.00,0.00,0.00),('5','107','700','221008',4264887,'1905','290',1480064.95,1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','221008',4264888,'1906','290',576168.59,579506.29,3337.70,550720.50,0.00,0.00,0.00,0.00,0.00),('5','107','701','221008',4264889,'1907','290',1902573.19,1903365.03,791.84,130653.60,0.00,0.00,0.00,0.00,0.00),('5','107','701','221008',4264890,'1908','290',600795.42,600795.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','221008',4264891,'1909','290',455997.30,455997.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','221008',4264892,'1910','290',374786.82,374786.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','221008',4264893,'1911','290',1037026.19,1037026.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','221008',4264894,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','221008',4264895,'1913','290',568732.09,568732.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','221008',4264896,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','221008',4264897,'1915','290',227944.03,227944.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','221008',4264898,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','221008',4264899,'1917','290',943402.86,945077.16,1674.30,276259.50,0.00,0.00,0.00,0.00,0.00),('5','107','703','221008',4264900,'1918','290',138083.62,138083.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','221008',4264901,'1919','290',430793.61,430793.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','221008',4264902,'1920','290',97332.11,97332.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','221008',4264903,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','221008',4264904,'1922','290',68216.25,68216.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','221008',4264905,'1923','290',720977.72,720977.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','221008',4264906,'1924','290',69026.52,69026.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','221008',4264907,'1925','290',1493405.82,1497511.50,4105.68,677437.20,0.00,0.00,0.00,0.00,0.00),('5','107','705','221008',4264908,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','221008',4264909,'1927','290',445140.69,446339.30,1198.61,197770.65,0.00,0.00,0.00,0.00,0.00),('5','107','705','221008',4264910,'1928','290',110866.82,110866.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','221008',4264911,'1929','291',3318558.79,3325711.94,7153.15,2110179.25,0.00,0.00,0.00,0.00,0.00),('5','107','706','221008',4264912,'1930','291',2276965.36,2283801.32,6835.96,2016608.20,0.00,0.00,0.00,0.00,0.00),('5','107','706','221008',4264913,'1931','291',3480720.02,3484134.22,3414.20,1007189.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','221008',4264914,'1932','291',2977798.88,2982003.35,4204.47,1240318.65,0.00,0.00,0.00,0.00,0.00),('5','107','706','221008',4264915,'1933','291',3960549.77,3968017.77,7468.00,2203060.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','221008',4264916,'1934','291',1511469.63,1519064.21,7594.58,2240401.10,0.00,0.00,0.00,0.00,0.00),('5','107','706','221008',4264917,'2898','291',2712788.66,2717480.23,4691.57,1384013.15,0.00,0.00,0.00,0.00,0.00),('5','107','708','221008',4264918,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','221249',4269042,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','221249',4269043,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','221249',4269044,'1877','290',751642.81,754551.43,2908.62,479922.30,0.00,0.00,0.00,0.00,0.00),('5','107','696','221249',4269045,'1878','290',175330.29,175330.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','221249',4269046,'1879','290',836708.34,838334.00,1625.66,268233.90,0.00,0.00,0.00,0.00,0.00),('5','107','696','221249',4269047,'1880','290',104424.43,104424.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','221249',4269048,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','221249',4269049,'1882','290',1045263.42,1046053.71,790.29,130397.85,0.00,0.00,0.00,0.00,0.00),('5','107','697','221249',4269050,'1883','290',517543.71,517543.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','221249',4269051,'1884','290',113480.65,113480.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','221249',4269052,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','221249',4269053,'1886','290',1996472.49,1998309.15,1836.66,303048.90,0.00,0.00,0.00,0.00,0.00),('5','107','697','221249',4269054,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','221249',4269055,'1888','290',151422.57,152407.54,984.97,162520.05,0.00,0.00,0.00,0.00,0.00),('5','107','696','221249',4269056,'1889','290',2913945.55,2921073.94,7128.39,1176184.35,0.00,0.00,0.00,0.00,0.00),('5','107','696','221249',4269057,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','221249',4269058,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','221249',4269059,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','221249',4269060,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','221249',4269061,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','221249',4269062,'1895','290',675938.21,676708.95,770.74,127172.10,0.00,0.00,0.00,0.00,0.00),('5','107','698','221249',4269063,'1896','290',227949.79,230129.29,2179.50,359617.50,0.00,0.00,0.00,0.00,0.00),('5','107','698','221249',4269064,'1897','290',403736.49,403736.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','221249',4269065,'1898','290',65028.38,65028.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','221249',4269066,'1899','290',1847084.61,1847084.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','221249',4269067,'1900','290',403084.02,403084.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','221249',4269068,'1901','290',1015141.80,1015141.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','221249',4269069,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','221249',4269070,'1903','290',1055652.60,1055652.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','221249',4269071,'1904','290',1103220.50,1104517.52,1297.02,214008.30,0.00,0.00,0.00,0.00,0.00),('5','107','700','221249',4269072,'1905','290',1480064.95,1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','221249',4269073,'1906','290',579506.29,579773.82,267.53,44142.45,0.00,0.00,0.00,0.00,0.00),('5','107','701','221249',4269074,'1907','290',1903365.03,1903365.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','221249',4269075,'1908','290',600795.42,600795.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','221249',4269076,'1909','290',455997.30,455997.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','221249',4269077,'1910','290',374786.82,374786.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','221249',4269078,'1911','290',1037026.19,1038660.09,1633.90,269593.50,0.00,0.00,0.00,0.00,0.00),('5','107','702','221249',4269079,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','221249',4269080,'1913','290',568732.09,569749.93,1017.84,167943.60,0.00,0.00,0.00,0.00,0.00),('5','107','702','221249',4269081,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','221249',4269082,'1915','290',227944.03,227944.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','221249',4269083,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','221249',4269084,'1917','290',945077.16,947740.02,2662.86,439371.90,0.00,0.00,0.00,0.00,0.00),('5','107','703','221249',4269085,'1918','290',138083.62,138083.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','221249',4269086,'1919','290',430793.61,431463.18,669.57,110479.05,0.00,0.00,0.00,0.00,0.00),('5','107','703','221249',4269087,'1920','290',97332.11,97332.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','221249',4269088,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','221249',4269089,'1922','290',68216.25,71022.72,2806.47,463067.55,0.00,0.00,0.00,0.00,0.00),('5','107','704','221249',4269090,'1923','290',720977.72,720977.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','221249',4269091,'1924','290',69026.52,71113.00,2086.48,344269.20,0.00,0.00,0.00,0.00,0.00),('5','107','705','221249',4269092,'1925','290',1497511.50,1499949.98,2438.48,402349.20,0.00,0.00,0.00,0.00,0.00),('5','107','705','221249',4269093,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','221249',4269094,'1927','290',446339.30,447449.32,1110.02,183153.30,0.00,0.00,0.00,0.00,0.00),('5','107','705','221249',4269095,'1928','290',110866.82,110866.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','221249',4269096,'1929','291',3325711.94,3335482.87,9770.93,2882424.35,0.00,0.00,0.00,0.00,0.00),('5','107','706','221249',4269097,'1930','291',2283801.32,2288034.15,4232.83,1248684.85,0.00,0.00,0.00,0.00,0.00),('5','107','706','221249',4269098,'1931','291',3484134.22,3488805.96,4671.74,1378163.30,0.00,0.00,0.00,0.00,0.00),('5','107','706','221249',4269099,'1932','291',2982003.35,2985070.18,3066.83,904714.85,0.00,0.00,0.00,0.00,0.00),('5','107','706','221249',4269100,'1933','291',3968017.77,3974216.50,6198.73,1828625.35,0.00,0.00,0.00,0.00,0.00),('5','107','708','221249',4269101,'1934','291',1519064.21,1520192.02,1127.81,332703.95,0.00,0.00,0.00,0.00,0.00),('5','107','706','221249',4269102,'2898','291',2717480.23,2721531.46,4051.23,1195112.85,0.00,0.00,0.00,0.00,0.00),('5','107','708','221249',4269103,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','221507',4273813,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','221507',4273814,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','221507',4273815,'1877','290',754551.43,755782.36,1230.93,203103.45,0.00,0.00,0.00,0.00,0.00),('5','107','696','221507',4273816,'1878','290',175330.29,175330.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','221507',4273817,'1879','290',838334.00,838715.26,381.26,62907.90,0.00,0.00,0.00,0.00,0.00),('5','107','696','221507',4273818,'1880','290',104424.43,104424.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','221507',4273819,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','221507',4273820,'1882','290',1046053.71,1048771.80,2718.09,448484.85,0.00,0.00,0.00,0.00,0.00),('5','107','697','221507',4273821,'1883','290',517543.71,518691.20,1147.49,189335.85,0.00,0.00,0.00,0.00,0.00),('5','107','697','221507',4273822,'1884','290',113480.65,114138.00,657.35,108462.75,0.00,0.00,0.00,0.00,0.00),('5','107','697','221507',4273823,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','221507',4273824,'1886','290',1998309.15,2004305.43,5996.28,989386.20,0.00,0.00,0.00,0.00,0.00),('5','107','697','221507',4273825,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','221507',4273826,'1888','290',152407.54,152407.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','221507',4273827,'1889','290',2921073.94,2923247.94,2174.00,358710.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','221507',4273828,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','221507',4273829,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','221507',4273830,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','221507',4273831,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','221507',4273832,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','221507',4273833,'1895','290',676708.95,676708.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','221507',4273834,'1896','290',230129.29,232287.30,2158.01,356071.65,0.00,0.00,0.00,0.00,0.00),('5','107','698','221507',4273835,'1897','290',403736.49,403736.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','221507',4273836,'1898','290',65028.38,65028.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','221507',4273837,'1899','290',1847084.61,1847084.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','221507',4273838,'1900','290',403084.02,403084.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','221507',4273839,'1901','290',1015141.80,1015141.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','221507',4273840,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','221507',4273841,'1903','290',1055652.60,1055652.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','221507',4273842,'1904','290',1104517.52,1104517.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','221507',4273843,'1905','290',1480064.95,1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','221507',4273844,'1906','290',579773.82,579773.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','221507',4273845,'1907','290',1903365.03,1907994.41,4629.38,763847.70,0.00,0.00,0.00,0.00,0.00),('5','107','701','221507',4273846,'1908','290',600795.42,600795.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','221507',4273847,'1909','290',455997.30,457724.21,1726.91,284940.15,0.00,0.00,0.00,0.00,0.00),('5','107','701','221507',4273848,'1910','290',374786.82,374786.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','221507',4273849,'1911','290',1038660.09,1040465.23,1805.14,297848.10,0.00,0.00,0.00,0.00,0.00),('5','107','702','221507',4273850,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','221507',4273851,'1913','290',569749.93,570195.39,445.46,73500.90,0.00,0.00,0.00,0.00,0.00),('5','107','702','221507',4273852,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','221507',4273853,'1915','290',227944.03,228199.83,255.80,42207.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','221507',4273854,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','221507',4273855,'1917','290',947740.02,948658.32,918.30,151519.50,0.00,0.00,0.00,0.00,0.00),('5','107','703','221507',4273856,'1918','290',138083.62,138083.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','221507',4273857,'1919','290',431463.18,432523.25,1060.07,174911.55,0.00,0.00,0.00,0.00,0.00),('5','107','703','221507',4273858,'1920','290',97332.11,97332.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','221507',4273859,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','221507',4273860,'1922','290',71022.72,73640.19,2617.47,431882.55,0.00,0.00,0.00,0.00,0.00),('5','107','704','221507',4273861,'1923','290',720977.72,720977.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','221507',4273862,'1924','290',71113.00,72536.13,1423.13,234816.45,0.00,0.00,0.00,0.00,0.00),('5','107','705','221507',4273863,'1925','290',1499949.98,1503611.38,3661.40,604131.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','221507',4273864,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','221507',4273865,'1927','290',447449.32,447449.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','221507',4273866,'1928','290',110866.82,111619.71,752.89,124226.85,0.00,0.00,0.00,0.00,0.00),('5','107','706','221507',4273867,'1929','291',3335482.87,3342481.25,6998.38,2064522.10,0.00,0.00,0.00,0.00,0.00),('5','107','706','221507',4273868,'1930','291',2288034.15,2291828.17,3794.02,1119235.90,0.00,0.00,0.00,0.00,0.00),('5','107','706','221507',4273869,'1931','291',3488805.96,3492679.80,3873.84,1142782.80,0.00,0.00,0.00,0.00,0.00),('5','107','706','221507',4273870,'1932','291',2985070.18,2987898.95,2828.77,834487.15,0.00,0.00,0.00,0.00,0.00),('5','107','706','221507',4273871,'1933','291',3974216.50,3979310.81,5094.31,1502821.45,0.00,0.00,0.00,0.00,0.00),('5','107','708','221507',4273872,'1934','291',1520192.02,1521188.17,996.15,293864.25,0.00,0.00,0.00,0.00,0.00),('5','107','706','221507',4273873,'2898','291',2721531.46,2724322.35,2790.89,823312.55,0.00,0.00,0.00,0.00,0.00),('5','107','708','221507',4273874,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','221730',4277961,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','221730',4277962,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','221730',4277963,'1877','290',755782.36,755782.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','221730',4277964,'1878','290',175330.29,175330.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','221730',4277965,'1879','290',838715.26,838715.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','221730',4277966,'1880','290',104424.43,104424.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','221730',4277967,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','221730',4277968,'1882','290',1048771.80,1053397.15,4625.35,763182.75,0.00,0.00,0.00,0.00,0.00),('5','107','697','221730',4277969,'1883','290',518691.20,518691.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','221730',4277970,'1884','290',114138.00,114138.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','221730',4277971,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','221730',4277972,'1886','290',2004305.43,2010775.30,6469.87,1067528.55,0.00,0.00,0.00,0.00,0.00),('5','107','697','221730',4277973,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','221730',4277974,'1888','290',152407.54,152407.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','221730',4277975,'1889','290',2923247.94,2923247.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','221730',4277976,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','221730',4277977,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','221730',4277978,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','221730',4277979,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','221730',4277980,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','221730',4277981,'1895','290',676708.95,676708.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','221730',4277982,'1896','290',232287.30,232651.94,364.64,60165.60,0.00,0.00,0.00,0.00,0.00),('5','107','698','221730',4277983,'1897','290',403736.49,403736.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','221730',4277984,'1898','290',65028.38,65028.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','221730',4277985,'1899','290',1847084.61,1850113.32,3028.71,499737.15,0.00,0.00,0.00,0.00,0.00),('5','107','699','221730',4277986,'1900','290',403084.02,403084.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','221730',4277987,'1901','290',1015141.80,1016847.05,1705.25,281366.25,0.00,0.00,0.00,0.00,0.00),('5','107','699','221730',4277988,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','221730',4277989,'1903','290',1055652.60,1055652.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','221730',4277990,'1904','290',1104517.52,1104517.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','221730',4277991,'1905','290',1480064.95,1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','221730',4277992,'1906','290',579773.82,579773.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','221730',4277993,'1907','290',1907994.41,1912719.98,4725.57,779719.05,0.00,0.00,0.00,0.00,0.00),('5','107','701','221730',4277994,'1908','290',600795.42,602844.26,2048.84,338058.60,0.00,0.00,0.00,0.00,0.00),('5','107','701','221730',4277995,'1909','290',457724.21,462309.64,4585.43,756595.95,0.00,0.00,0.00,0.00,0.00),('5','107','701','221730',4277996,'1910','290',374786.82,375886.62,1099.80,181467.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','221730',4277997,'1911','290',1040465.23,1043156.69,2691.46,444090.90,0.00,0.00,0.00,0.00,0.00),('5','107','702','221730',4277998,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','221730',4277999,'1913','290',570195.39,570195.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','221730',4278000,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','221730',4278001,'1915','290',228199.83,228199.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','221730',4278002,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','221730',4278003,'1917','290',948658.32,948658.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','221730',4278004,'1918','290',138083.62,138083.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','221730',4278005,'1919','290',432523.25,432523.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','221730',4278006,'1920','290',97332.11,97332.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','221730',4278007,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','221730',4278008,'1922','290',73640.19,75061.28,1421.09,234479.85,0.00,0.00,0.00,0.00,0.00),('5','107','704','221730',4278009,'1923','290',720977.72,720977.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','221730',4278010,'1924','290',72536.13,75306.73,2770.60,457149.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','221730',4278011,'1925','290',1503611.38,1507542.39,3931.01,648616.65,0.00,0.00,0.00,0.00,0.00),('5','107','705','221730',4278012,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','221730',4278013,'1927','290',447449.32,447449.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','221730',4278014,'1928','290',111619.71,111619.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','221730',4278015,'1929','291',3342481.25,3348403.28,5922.03,1746998.85,0.00,0.00,0.00,0.00,0.00),('5','107','706','221730',4278016,'1930','291',2291828.17,2295864.97,4036.80,1190856.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','221730',4278017,'1931','291',3492679.80,3498758.74,6078.94,1793287.30,0.00,0.00,0.00,0.00,0.00),('5','107','706','221730',4278018,'1932','291',2987898.95,2992765.52,4866.57,1435638.15,0.00,0.00,0.00,0.00,0.00),('5','107','706','221730',4278019,'1933','291',3979310.81,3986051.60,6740.79,1988533.05,0.00,0.00,0.00,0.00,0.00),('5','107','708','221730',4278020,'1934','291',1521188.17,1526652.26,5464.09,1611906.55,0.00,0.00,0.00,0.00,0.00),('5','107','706','221730',4278021,'2898','291',2724322.35,2727419.90,3097.55,913777.25,0.00,0.00,0.00,0.00,0.00),('5','107','708','221730',4278022,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','221884',4280548,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','221884',4280549,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','221884',4280550,'1877','290',755782.36,756394.36,612.00,100980.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','221884',4280551,'1878','290',175330.29,175330.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','221884',4280552,'1879','290',838715.26,838715.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','221884',4280553,'1880','290',104424.43,104424.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','221884',4280554,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','221884',4280555,'1882','290',1053397.15,1057051.38,3654.23,602947.95,0.00,0.00,0.00,0.00,0.00),('5','107','697','221884',4280556,'1883','290',518691.20,519588.38,897.18,148034.70,0.00,0.00,0.00,0.00,0.00),('5','107','697','221884',4280557,'1884','290',114138.00,114138.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','221884',4280558,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','221884',4280559,'1886','290',2010775.30,2015755.28,4979.98,821696.70,0.00,0.00,0.00,0.00,0.00),('5','107','697','221884',4280560,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','221884',4280561,'1888','290',152407.54,152407.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','221884',4280562,'1889','290',2923247.94,2928547.06,5299.12,874354.80,0.00,0.00,0.00,0.00,0.00),('5','107','696','221884',4280563,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','221884',4280564,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','221884',4280565,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','221884',4280566,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','221884',4280567,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','221884',4280568,'1895','290',676708.95,676708.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','221884',4280569,'1896','290',232651.94,232651.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','221884',4280570,'1897','290',403736.49,403736.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','221884',4280571,'1898','290',65028.38,65028.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','221884',4280572,'1899','290',1850113.32,1853561.05,3447.73,568875.45,0.00,0.00,0.00,0.00,0.00),('5','107','699','221884',4280573,'1900','290',403084.02,403084.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','221884',4280574,'1901','290',1016847.05,1018388.68,1541.63,254368.95,0.00,0.00,0.00,0.00,0.00),('5','107','699','221884',4280575,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','221884',4280576,'1903','290',1055652.60,1055652.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','221884',4280577,'1904','290',1104517.52,1104517.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','221884',4280578,'1905','290',1480064.95,1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','221884',4280579,'1906','290',579773.82,579773.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','221884',4280580,'1907','290',1912719.98,1914607.06,1887.08,311368.20,0.00,0.00,0.00,0.00,0.00),('5','107','701','221884',4280581,'1908','290',602844.26,606018.67,3174.41,523777.65,0.00,0.00,0.00,0.00,0.00),('5','107','701','221884',4280582,'1909','290',462309.64,465697.12,3387.48,558934.20,0.00,0.00,0.00,0.00,0.00),('5','107','701','221884',4280583,'1910','290',375886.62,375982.87,96.25,15881.25,0.00,0.00,0.00,0.00,0.00),('5','107','702','221884',4280584,'1911','290',1043156.69,1045194.63,2037.94,336260.10,0.00,0.00,0.00,0.00,0.00),('5','107','702','221884',4280585,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','221884',4280586,'1913','290',570195.39,570840.07,644.68,106372.20,0.00,0.00,0.00,0.00,0.00),('5','107','702','221884',4280587,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','221884',4280588,'1915','290',228199.83,228199.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','221884',4280589,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','221884',4280590,'1917','290',948658.32,948658.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','221884',4280591,'1918','290',138083.62,138083.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','221884',4280592,'1919','290',432523.25,432523.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','221884',4280593,'1920','290',97332.11,97332.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','221884',4280594,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','221884',4280595,'1922','290',75061.28,77491.77,2430.49,401030.85,0.00,0.00,0.00,0.00,0.00),('5','107','704','221884',4280596,'1923','290',720977.72,720977.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','221884',4280597,'1924','290',75306.73,76448.33,1141.60,188364.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','221884',4280598,'1925','290',1507542.39,1507542.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','221884',4280599,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','221884',4280600,'1927','290',447449.32,447449.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','221884',4280601,'1928','290',111619.71,111619.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','221884',4280602,'1929','291',3348403.28,3356707.29,8304.01,2449682.95,0.00,0.00,0.00,0.00,0.00),('5','107','706','221884',4280603,'1930','291',2295864.97,2298836.95,2971.98,876734.10,0.00,0.00,0.00,0.00,0.00),('5','107','706','221884',4280604,'1931','291',3498758.74,3502462.24,3703.50,1092532.50,0.00,0.00,0.00,0.00,0.00),('5','107','706','221884',4280605,'1932','291',2992765.52,2996289.43,3523.91,1039553.45,0.00,0.00,0.00,0.00,0.00),('5','107','706','221884',4280606,'1933','291',3986051.60,3991264.84,5213.24,1537905.80,0.00,0.00,0.00,0.00,0.00),('5','107','708','221884',4280607,'1934','291',1526652.26,1527200.44,548.18,161713.10,0.00,0.00,0.00,0.00,0.00),('5','107','706','221884',4280608,'2898','291',2727419.90,2730933.35,3513.45,1036467.75,0.00,0.00,0.00,0.00,0.00),('5','107','708','221884',4280609,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','222425',4290110,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','222425',4290111,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','222425',4290112,'1877','290',756394.36,758762.12,2367.76,390680.40,0.00,0.00,0.00,0.00,0.00),('5','107','696','222425',4290113,'1878','290',175330.29,175330.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','222425',4290114,'1879','290',838715.26,838715.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','222425',4290115,'1880','290',104424.43,104424.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','222425',4290116,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','222425',4290117,'1882','290',1057051.38,1059593.17,2541.79,419395.35,0.00,0.00,0.00,0.00,0.00),('5','107','697','222425',4290118,'1883','290',519588.38,519588.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','222425',4290119,'1884','290',114138.00,114676.55,538.55,88860.75,0.00,0.00,0.00,0.00,0.00),('5','107','697','222425',4290120,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','222425',4290121,'1886','290',2015755.28,2020871.26,5115.98,844136.70,0.00,0.00,0.00,0.00,0.00),('5','107','697','222425',4290122,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','222425',4290123,'1888','290',152407.54,152407.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','222425',4290124,'1889','290',2928547.06,2935274.10,6727.04,1109961.60,0.00,0.00,0.00,0.00,0.00),('5','107','696','222425',4290125,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','222425',4290126,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','222425',4290127,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','222425',4290128,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','222425',4290129,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','222425',4290130,'1895','290',676708.95,676708.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','222425',4290131,'1896','290',232651.94,232651.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','222425',4290132,'1897','290',403736.49,403736.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','222425',4290133,'1898','290',65028.38,65028.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','222425',4290134,'1899','290',1853561.05,1856401.45,2840.40,468666.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','222425',4290135,'1900','290',403084.02,403084.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','222425',4290136,'1901','290',1018388.68,1021467.97,3079.29,508082.85,0.00,0.00,0.00,0.00,0.00),('5','107','699','222425',4290137,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','222425',4290138,'1903','290',1055652.60,1055652.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','222425',4290139,'1904','290',1104517.52,1104517.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','222425',4290140,'1905','290',1480064.95,1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','222425',4290141,'1906','290',579773.82,579773.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','222425',4290142,'1907','290',1914607.06,1917927.26,3320.20,547833.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','222425',4290143,'1908','290',606018.67,607533.59,1514.92,249961.80,0.00,0.00,0.00,0.00,0.00),('5','107','701','222425',4290144,'1909','290',465697.12,468660.94,2963.82,489030.30,0.00,0.00,0.00,0.00,0.00),('5','107','701','222425',4290145,'1910','290',375982.87,377148.42,1165.55,192315.75,0.00,0.00,0.00,0.00,0.00),('5','107','702','222425',4290146,'1911','290',1045194.63,1046628.47,1433.84,236583.60,0.00,0.00,0.00,0.00,0.00),('5','107','702','222425',4290147,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','222425',4290148,'1913','290',570840.07,571470.15,630.08,103963.20,0.00,0.00,0.00,0.00,0.00),('5','107','702','222425',4290149,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','222425',4290150,'1915','290',228199.83,228199.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','222425',4290151,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','222425',4290152,'1917','290',948658.32,948812.58,154.26,25452.90,0.00,0.00,0.00,0.00,0.00),('5','107','703','222425',4290153,'1918','290',138083.62,138083.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','222425',4290154,'1919','290',432523.25,432523.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','222425',4290155,'1920','290',97332.11,97332.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','222425',4290156,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','222425',4290157,'1922','290',77491.77,78541.89,1050.12,173269.80,0.00,0.00,0.00,0.00,0.00),('5','107','704','222425',4290158,'1923','290',720977.72,720977.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','222425',4290159,'1924','290',76448.33,78117.54,1669.21,275419.65,0.00,0.00,0.00,0.00,0.00),('5','107','705','222425',4290160,'1925','290',1507542.39,1507542.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','222425',4290161,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','222425',4290162,'1927','290',447449.32,447449.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','222425',4290163,'1928','290',111619.71,111619.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','222425',4290164,'1929','291',3356707.29,3364847.38,8140.09,2401326.55,0.00,0.00,0.00,0.00,0.00),('5','107','706','222425',4290165,'1930','291',2298836.95,2303252.40,4415.45,1302557.75,0.00,0.00,0.00,0.00,0.00),('5','107','706','222425',4290166,'1931','291',3502462.24,3507100.90,4638.66,1368404.70,0.00,0.00,0.00,0.00,0.00),('5','107','706','222425',4290167,'1932','291',2996289.43,2999546.90,3257.47,960953.65,0.00,0.00,0.00,0.00,0.00),('5','107','706','222425',4290168,'1933','291',3991264.84,3997651.87,6387.03,1884173.85,0.00,0.00,0.00,0.00,0.00),('5','107','708','222425',4290169,'1934','291',1527200.44,1527680.07,479.63,141490.85,0.00,0.00,0.00,0.00,0.00),('5','107','706','222425',4290170,'2898','291',2730933.35,2734297.84,3364.49,992524.55,0.00,0.00,0.00,0.00,0.00),('5','107','708','222425',4290171,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','222527',4291713,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','222527',4291714,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','222527',4291715,'1877','290',758762.12,760452.59,1690.47,278927.55,0.00,0.00,0.00,0.00,0.00),('5','107','696','222527',4291716,'1878','290',175330.29,175330.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','222527',4291717,'1879','290',838715.26,841240.60,2525.34,416681.10,0.00,0.00,0.00,0.00,0.00),('5','107','696','222527',4291718,'1880','290',104424.43,104424.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','222527',4291719,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','222527',4291720,'1882','290',1059593.17,1059593.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','222527',4291721,'1883','290',519588.38,519588.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','222527',4291722,'1884','290',114676.55,114676.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','222527',4291723,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','222527',4291724,'1886','290',2020871.26,2020871.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','222527',4291725,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','222527',4291726,'1888','290',152407.54,152407.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','222527',4291727,'1889','290',2935274.10,2941522.87,6248.77,1031047.05,0.00,0.00,0.00,0.00,0.00),('5','107','696','222527',4291728,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','222527',4291729,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','222527',4291730,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','222527',4291731,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','222527',4291732,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','222527',4291733,'1895','290',676708.95,676708.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','222527',4291734,'1896','290',232651.94,232651.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','222527',4291735,'1897','290',403736.49,403736.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','222527',4291736,'1898','290',65028.38,65028.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','222527',4291737,'1899','290',1856401.45,1860044.62,3643.17,601123.05,0.00,0.00,0.00,0.00,0.00),('5','107','699','222527',4291738,'1900','290',403084.02,403084.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','222527',4291739,'1901','290',1021467.97,1024610.97,3143.00,518595.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','222527',4291740,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','222527',4291741,'1903','290',1055652.60,1055652.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','222527',4291742,'1904','290',1104517.52,1104517.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','222527',4291743,'1905','290',1480064.95,1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','222527',4291744,'1906','290',579773.82,579773.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','222527',4291745,'1907','290',1917927.26,1920161.09,2233.83,368581.95,0.00,0.00,0.00,0.00,0.00),('5','107','701','222527',4291746,'1908','290',607533.59,607533.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','222527',4291747,'1909','290',468660.94,471371.36,2710.42,447219.30,0.00,0.00,0.00,0.00,0.00),('5','107','701','222527',4291748,'1910','290',377148.42,379334.55,2186.13,360711.45,0.00,0.00,0.00,0.00,0.00),('5','107','702','222527',4291749,'1911','290',1046628.47,1049902.01,3273.54,540134.10,0.00,0.00,0.00,0.00,0.00),('5','107','702','222527',4291750,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','222527',4291751,'1913','290',571470.15,571470.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','222527',4291752,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','222527',4291753,'1915','290',228199.83,229999.14,1799.31,296886.15,0.00,0.00,0.00,0.00,0.00),('5','107','702','222527',4291754,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','222527',4291755,'1917','290',948812.58,951873.77,3061.19,505096.35,0.00,0.00,0.00,0.00,0.00),('5','107','703','222527',4291756,'1918','290',138083.62,138083.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','222527',4291757,'1919','290',432523.25,433384.73,861.48,142144.20,0.00,0.00,0.00,0.00,0.00),('5','107','703','222527',4291758,'1920','290',97332.11,97332.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','222527',4291759,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','222527',4291760,'1922','290',78541.89,78787.54,245.65,40532.25,0.00,0.00,0.00,0.00,0.00),('5','107','704','222527',4291761,'1923','290',720977.72,721000.23,22.51,3714.15,0.00,0.00,0.00,0.00,0.00),('5','107','704','222527',4291762,'1924','290',78117.54,82631.85,4514.31,744861.15,0.00,0.00,0.00,0.00,0.00),('5','107','705','222527',4291763,'1925','290',1507542.39,1507542.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','222527',4291764,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','222527',4291765,'1927','290',447449.32,447449.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','222527',4291766,'1928','290',111619.71,111619.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','222527',4291767,'1929','291',3364847.38,3370875.92,6028.54,1778419.30,0.00,0.00,0.00,0.00,0.00),('5','107','706','222527',4291768,'1930','291',2303252.40,2305860.44,2608.04,769371.80,0.00,0.00,0.00,0.00,0.00),('5','107','706','222527',4291769,'1931','291',3507100.90,3511675.22,4574.32,1349424.40,0.00,0.00,0.00,0.00,0.00),('5','107','706','222527',4291770,'1932','291',2999546.90,3003300.73,3753.83,1107379.85,0.00,0.00,0.00,0.00,0.00),('5','107','706','222527',4291771,'1933','291',3997651.87,4002120.08,4468.21,1318121.95,0.00,0.00,0.00,0.00,0.00),('5','107','708','222527',4291772,'1934','291',1527680.07,1533102.08,5422.01,1599492.95,0.00,0.00,0.00,0.00,0.00),('5','107','706','222527',4291773,'2898','291',2734297.84,2737265.91,2968.07,875580.65,0.00,0.00,0.00,0.00,0.00),('5','107','708','222527',4291774,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','222608',4293266,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','222608',4293267,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','222608',4293268,'1877','290',760452.59,763313.44,2860.85,472040.25,0.00,0.00,0.00,0.00,0.00),('5','107','696','222608',4293269,'1878','290',175330.29,175330.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','222608',4293270,'1879','290',841240.60,842440.49,1199.89,197981.85,0.00,0.00,0.00,0.00,0.00),('5','107','696','222608',4293271,'1880','290',104424.43,104424.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','222608',4293272,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','222608',4293273,'1882','290',1059593.17,1059593.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','222608',4293274,'1883','290',519588.38,519588.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','222608',4293275,'1884','290',114676.55,114676.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','222608',4293276,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','222608',4293277,'1886','290',2020871.26,2020871.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','222608',4293278,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','222608',4293279,'1888','290',152407.54,152407.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','222608',4293280,'1889','290',2941522.87,2948165.03,6642.16,1095956.40,0.00,0.00,0.00,0.00,0.00),('5','107','696','222608',4293281,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','222608',4293282,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','222608',4293283,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','222608',4293284,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','222608',4293285,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','222608',4293286,'1895','290',676708.95,676708.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','222608',4293287,'1896','290',232651.94,232651.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','222608',4293288,'1897','290',403736.49,403736.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','222608',4293289,'1898','290',65028.38,65028.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','222608',4293290,'1899','290',1860044.62,1864938.15,4893.53,807432.45,0.00,0.00,0.00,0.00,0.00),('5','107','699','222608',4293291,'1900','290',403084.02,404236.12,1152.10,190096.50,0.00,0.00,0.00,0.00,0.00),('5','107','699','222608',4293292,'1901','290',1024610.97,1026975.07,2364.10,390076.50,0.00,0.00,0.00,0.00,0.00),('5','107','699','222608',4293293,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','222608',4293294,'1903','290',1055652.60,1055652.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','222608',4293295,'1904','290',1104517.52,1104517.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','222608',4293296,'1905','290',1480064.95,1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','222608',4293297,'1906','290',579773.82,579773.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','222608',4293298,'1907','290',1920161.09,1922326.02,2164.93,357213.45,0.00,0.00,0.00,0.00,0.00),('5','107','701','222608',4293299,'1908','290',607533.59,609451.91,1918.32,316522.80,0.00,0.00,0.00,0.00,0.00),('5','107','701','222608',4293300,'1909','290',471371.36,473355.03,1983.67,327305.55,0.00,0.00,0.00,0.00,0.00),('5','107','701','222608',4293301,'1910','290',379334.55,379334.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','222608',4293302,'1911','290',1049902.01,1052055.15,2153.14,355268.10,0.00,0.00,0.00,0.00,0.00),('5','107','702','222608',4293303,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','222608',4293304,'1913','290',571470.15,572151.20,681.05,112373.25,0.00,0.00,0.00,0.00,0.00),('5','107','702','222608',4293305,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','222608',4293306,'1915','290',229999.14,230080.62,81.48,13444.20,0.00,0.00,0.00,0.00,0.00),('5','107','702','222608',4293307,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','222608',4293308,'1917','290',951873.77,954442.79,2569.02,423888.30,0.00,0.00,0.00,0.00,0.00),('5','107','703','222608',4293309,'1918','290',138083.62,138083.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','222608',4293310,'1919','290',433384.73,435282.87,1898.14,313193.10,0.00,0.00,0.00,0.00,0.00),('5','107','703','222608',4293311,'1920','290',97332.11,97332.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','222608',4293312,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','222608',4293313,'1922','290',78787.54,81603.36,2815.82,464610.30,0.00,0.00,0.00,0.00,0.00),('5','107','704','222608',4293314,'1923','290',721000.23,721000.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','222608',4293315,'1924','290',82631.85,86654.42,4022.57,663724.05,0.00,0.00,0.00,0.00,0.00),('5','107','705','222608',4293316,'1925','290',1507542.39,1507542.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','222608',4293317,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','222608',4293318,'1927','290',447449.32,447449.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','222608',4293319,'1928','290',111619.71,111619.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','222608',4293320,'1929','291',3370875.92,3376516.54,5640.62,1663982.90,0.00,0.00,0.00,0.00,0.00),('5','107','706','222608',4293321,'1930','291',2305860.44,2308837.35,2976.91,878188.45,0.00,0.00,0.00,0.00,0.00),('5','107','706','222608',4293322,'1931','291',3511675.22,3515906.51,4231.29,1248230.55,0.00,0.00,0.00,0.00,0.00),('5','107','706','222608',4293323,'1932','291',3003300.73,3006149.29,2848.56,840325.20,0.00,0.00,0.00,0.00,0.00),('5','107','706','222608',4293324,'1933','291',4002120.08,4005650.61,3530.53,1041506.35,0.00,0.00,0.00,0.00,0.00),('5','107','708','222608',4293325,'1934','291',1533102.08,1533468.88,366.80,108206.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','222608',4293326,'2898','291',2737265.91,2739018.41,1752.50,516987.50,0.00,0.00,0.00,0.00,0.00),('5','107','708','222608',4293327,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','222829',4297403,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','222829',4297404,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','222829',4297405,'1877','290',763313.44,764597.13,1283.69,211808.85,0.00,0.00,0.00,0.00,0.00),('5','107','696','222829',4297406,'1878','290',175330.29,175330.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','222829',4297407,'1879','290',842440.49,843364.59,924.10,152476.50,0.00,0.00,0.00,0.00,0.00),('5','107','696','222829',4297408,'1880','290',104424.43,104424.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','222829',4297409,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','222829',4297410,'1882','290',1059593.17,1059593.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','222829',4297411,'1883','290',519588.38,519588.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','222829',4297412,'1884','290',114676.55,114676.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','222829',4297413,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','222829',4297414,'1886','290',2020871.26,2020871.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','222829',4297415,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','222829',4297416,'1888','290',152407.54,152407.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','222829',4297417,'1889','290',2948165.03,2953024.60,4859.57,801829.05,0.00,0.00,0.00,0.00,0.00),('5','107','696','222829',4297418,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','222829',4297419,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','222829',4297420,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','222829',4297421,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','222829',4297422,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','222829',4297423,'1895','290',676708.95,676708.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','222829',4297424,'1896','290',232651.94,232651.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','222829',4297425,'1897','290',403736.49,403736.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','222829',4297426,'1898','290',65028.38,65028.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','222829',4297427,'1899','290',1864938.15,1867769.44,2831.29,467162.85,0.00,0.00,0.00,0.00,0.00),('5','107','699','222829',4297428,'1900','290',404236.12,406468.36,2232.24,368319.60,0.00,0.00,0.00,0.00,0.00),('5','107','699','222829',4297429,'1901','290',1026975.07,1028682.14,1707.07,281666.55,0.00,0.00,0.00,0.00,0.00),('5','107','699','222829',4297430,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','222829',4297431,'1903','290',1055652.60,1055652.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','222829',4297432,'1904','290',1104517.52,1104517.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','222829',4297433,'1905','290',1480064.95,1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','222829',4297434,'1906','290',579773.82,579773.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','222829',4297435,'1907','290',1922326.02,1925422.51,3096.49,510920.85,0.00,0.00,0.00,0.00,0.00),('5','107','701','222829',4297436,'1908','290',609451.91,609451.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','222829',4297437,'1909','290',473355.03,477445.65,4090.62,674952.30,0.00,0.00,0.00,0.00,0.00),('5','107','701','222829',4297438,'1910','290',379334.55,379334.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','222829',4297439,'1911','290',1052055.15,1053702.39,1647.24,271794.60,0.00,0.00,0.00,0.00,0.00),('5','107','702','222829',4297440,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','222829',4297441,'1913','290',572151.20,573015.90,864.70,142675.50,0.00,0.00,0.00,0.00,0.00),('5','107','702','222829',4297442,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','222829',4297443,'1915','290',230080.62,230638.41,557.79,92035.35,0.00,0.00,0.00,0.00,0.00),('5','107','702','222829',4297444,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','222829',4297445,'1917','290',954442.79,955847.21,1404.42,231729.30,0.00,0.00,0.00,0.00,0.00),('5','107','703','222829',4297446,'1918','290',138083.62,138083.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','222829',4297447,'1919','290',435282.87,435548.99,266.12,43909.80,0.00,0.00,0.00,0.00,0.00),('5','107','703','222829',4297448,'1920','290',97332.11,97332.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','222829',4297449,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','222829',4297450,'1922','290',81603.36,81603.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','222829',4297451,'1923','290',721000.23,721000.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','222829',4297452,'1924','290',86654.42,89660.34,3005.92,495976.80,0.00,0.00,0.00,0.00,0.00),('5','107','705','222829',4297453,'1925','290',1507542.39,1507542.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','222829',4297454,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','222829',4297455,'1927','290',447449.32,447449.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','222829',4297456,'1928','290',111619.71,111619.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','222829',4297457,'1929','291',3376516.54,3382804.47,6287.93,1854939.35,0.00,0.00,0.00,0.00,0.00),('5','107','706','222829',4297458,'1930','291',2308837.35,2311908.08,3070.73,905865.35,0.00,0.00,0.00,0.00,0.00),('5','107','706','222829',4297459,'1931','291',3515906.51,3520310.73,4404.22,1299244.90,0.00,0.00,0.00,0.00,0.00),('5','107','706','222829',4297460,'1932','291',3006149.29,3009790.71,3641.42,1074218.90,0.00,0.00,0.00,0.00,0.00),('5','107','706','222829',4297461,'1933','291',4005650.61,4011316.34,5665.73,1671390.35,0.00,0.00,0.00,0.00,0.00),('5','107','708','222829',4297462,'1934','291',1533468.88,1534457.18,988.30,291548.50,0.00,0.00,0.00,0.00,0.00),('5','107','706','222829',4297463,'2898','291',2739018.41,2743443.34,4424.93,1305354.35,0.00,0.00,0.00,0.00,0.00),('5','107','708','222829',4297464,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','223042',4301509,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','223042',4301510,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','223042',4301511,'1877','290',764597.13,764737.46,140.33,23154.45,0.00,0.00,0.00,0.00,0.00),('5','107','696','223042',4301512,'1878','290',175330.29,175330.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','223042',4301513,'1879','290',843364.59,843364.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','223042',4301514,'1880','290',104424.43,104521.61,97.18,16034.70,0.00,0.00,0.00,0.00,0.00),('5','107','697','223042',4301515,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','223042',4301516,'1882','290',1059593.17,1060833.11,1239.94,204590.10,0.00,0.00,0.00,0.00,0.00),('5','107','697','223042',4301517,'1883','290',519588.38,521092.71,1504.33,248214.45,0.00,0.00,0.00,0.00,0.00),('5','107','697','223042',4301518,'1884','290',114676.55,114676.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','223042',4301519,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','223042',4301520,'1886','290',2020871.26,2027562.61,6691.35,1104072.75,0.00,0.00,0.00,0.00,0.00),('5','107','697','223042',4301521,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','223042',4301522,'1888','290',152407.54,152407.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','223042',4301523,'1889','290',2953024.60,2953622.80,598.20,98703.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','223042',4301524,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','223042',4301525,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','223042',4301526,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','223042',4301527,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','223042',4301528,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','223042',4301529,'1895','290',676708.95,676936.98,228.03,37624.95,0.00,0.00,0.00,0.00,0.00),('5','107','698','223042',4301530,'1896','290',232651.94,234120.24,1468.30,242269.50,0.00,0.00,0.00,0.00,0.00),('5','107','698','223042',4301531,'1897','290',403736.49,404466.47,729.98,120446.70,0.00,0.00,0.00,0.00,0.00),('5','107','698','223042',4301532,'1898','290',65028.38,65028.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','223042',4301533,'1899','290',1867769.44,1870329.90,2560.46,422475.90,0.00,0.00,0.00,0.00,0.00),('5','107','699','223042',4301534,'1900','290',406468.36,407301.37,833.01,137446.65,0.00,0.00,0.00,0.00,0.00),('5','107','699','223042',4301535,'1901','290',1028682.14,1031469.93,2787.79,459985.35,0.00,0.00,0.00,0.00,0.00),('5','107','699','223042',4301536,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','223042',4301537,'1903','290',1055652.60,1055652.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','223042',4301538,'1904','290',1104517.52,1108681.62,4164.10,687076.50,0.00,0.00,0.00,0.00,0.00),('5','107','700','223042',4301539,'1905','290',1480064.95,1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','223042',4301540,'1906','290',579773.82,579773.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','223042',4301541,'1907','290',1925422.51,1926886.39,1463.88,241540.20,0.00,0.00,0.00,0.00,0.00),('5','107','701','223042',4301542,'1908','290',609451.91,609451.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','223042',4301543,'1909','290',477445.65,478401.60,955.95,157731.75,0.00,0.00,0.00,0.00,0.00),('5','107','701','223042',4301544,'1910','290',379334.55,379334.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','223042',4301545,'1911','290',1053702.39,1054608.80,906.41,149557.65,0.00,0.00,0.00,0.00,0.00),('5','107','702','223042',4301546,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','223042',4301547,'1913','290',573015.90,573295.89,279.99,46198.35,0.00,0.00,0.00,0.00,0.00),('5','107','702','223042',4301548,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','223042',4301549,'1915','290',230638.41,230638.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','223042',4301550,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','223042',4301551,'1917','290',955847.21,957484.11,1636.90,270088.50,0.00,0.00,0.00,0.00,0.00),('5','107','703','223042',4301552,'1918','290',138083.62,139458.20,1374.58,226805.70,0.00,0.00,0.00,0.00,0.00),('5','107','703','223042',4301553,'1919','290',435548.99,436584.19,1035.20,170808.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','223042',4301554,'1920','290',97332.11,97332.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','223042',4301555,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','223042',4301556,'1922','290',81603.36,81603.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','223042',4301557,'1923','290',721000.23,721000.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','223042',4301558,'1924','290',89660.34,91900.08,2239.74,369557.10,0.00,0.00,0.00,0.00,0.00),('5','107','705','223042',4301559,'1925','290',1507542.39,1512221.48,4679.09,772049.85,0.00,0.00,0.00,0.00,0.00),('5','107','705','223042',4301560,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','223042',4301561,'1927','290',447449.32,447449.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','223042',4301562,'1928','290',111619.71,111619.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','223042',4301563,'1929','291',3382804.47,3391445.08,8640.61,2548979.95,0.00,0.00,0.00,0.00,0.00),('5','107','706','223042',4301564,'1930','291',2311908.08,2316043.24,4135.16,1219872.20,0.00,0.00,0.00,0.00,0.00),('5','107','706','223042',4301565,'1931','291',3520310.73,3525257.96,4947.23,1459432.85,0.00,0.00,0.00,0.00,0.00),('5','107','706','223042',4301566,'1932','291',3009790.71,3013412.15,3621.44,1068324.80,0.00,0.00,0.00,0.00,0.00),('5','107','706','223042',4301567,'1933','291',4011316.34,4015870.70,4554.36,1343536.20,0.00,0.00,0.00,0.00,0.00),('5','107','708','223042',4301568,'1934','291',1534457.18,1536204.00,1746.82,515311.90,0.00,0.00,0.00,0.00,0.00),('5','107','706','223042',4301569,'2898','291',2743443.34,2748593.37,5150.03,1519258.85,0.00,0.00,0.00,0.00,0.00),('5','107','708','223042',4301570,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','223293',4305366,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','223293',4305367,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','223293',4305368,'1877','290',764737.46,764737.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','223293',4305369,'1878','290',175330.29,175330.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','223293',4305370,'1879','290',843364.59,843364.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','223293',4305371,'1880','290',104521.61,104521.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','223293',4305372,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','223293',4305373,'1882','290',1060833.11,1064309.27,3476.16,573566.40,0.00,0.00,0.00,0.00,0.00),('5','107','697','223293',4305374,'1883','290',521092.71,523245.09,2152.38,355142.70,0.00,0.00,0.00,0.00,0.00),('5','107','697','223293',4305375,'1884','290',114676.55,114676.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','223293',4305376,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','223293',4305377,'1886','290',2027562.61,2034324.05,6761.44,1115637.60,0.00,0.00,0.00,0.00,0.00),('5','107','697','223293',4305378,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','223293',4305379,'1888','290',152407.54,152407.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','223293',4305380,'1889','290',2953622.80,2953622.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','223293',4305381,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','223293',4305382,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','223293',4305383,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','223293',4305384,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','223293',4305385,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','223293',4305386,'1895','290',676936.98,676936.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','223293',4305387,'1896','290',234120.24,237358.57,3238.33,534324.45,0.00,0.00,0.00,0.00,0.00),('5','107','698','223293',4305388,'1897','290',404466.47,405582.01,1115.54,184064.10,0.00,0.00,0.00,0.00,0.00),('5','107','698','223293',4305389,'1898','290',65028.38,65028.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','223293',4305390,'1899','290',1870329.90,1870329.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','223293',4305391,'1900','290',407301.37,407301.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','223293',4305392,'1901','290',1031469.93,1031469.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','223293',4305393,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','223293',4305394,'1903','290',1055652.60,1055652.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','223293',4305395,'1904','290',1108681.62,1112340.98,3659.36,603794.40,0.00,0.00,0.00,0.00,0.00),('5','107','700','223293',4305396,'1905','290',1480064.95,1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','223293',4305397,'1906','290',579773.82,579773.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','223293',4305398,'1907','290',1926886.39,1926886.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','223293',4305399,'1908','290',609451.91,609451.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','223293',4305400,'1909','290',478401.60,478401.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','223293',4305401,'1910','290',379334.55,379334.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','223293',4305402,'1911','290',1054608.80,1055767.12,1158.32,191122.80,0.00,0.00,0.00,0.00,0.00),('5','107','702','223293',4305403,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','223293',4305404,'1913','290',573295.89,573320.08,24.19,3991.35,0.00,0.00,0.00,0.00,0.00),('5','107','702','223293',4305405,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','223293',4305406,'1915','290',230638.41,230638.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','223293',4305407,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','223293',4305408,'1917','290',957484.11,960742.79,3258.68,537682.20,0.00,0.00,0.00,0.00,0.00),('5','107','703','223293',4305409,'1918','290',139458.20,139458.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','223293',4305410,'1919','290',436584.19,438954.57,2370.38,391112.70,0.00,0.00,0.00,0.00,0.00),('5','107','703','223293',4305411,'1920','290',97332.11,97332.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','223293',4305412,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','223293',4305413,'1922','290',81603.36,81603.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','223293',4305414,'1923','290',721000.23,721000.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','223293',4305415,'1924','290',91900.08,94886.16,2986.08,492703.20,0.00,0.00,0.00,0.00,0.00),('5','107','705','223293',4305416,'1925','290',1512221.48,1516787.26,4565.78,753353.70,0.00,0.00,0.00,0.00,0.00),('5','107','705','223293',4305417,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','223293',4305418,'1927','290',447449.32,450037.52,2588.20,427053.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','223293',4305419,'1928','290',111619.71,111619.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','223293',4305420,'1929','291',3391445.08,3398180.60,6735.52,1986978.40,0.00,0.00,0.00,0.00,0.00),('5','107','706','223293',4305421,'1930','291',2316043.24,2320269.36,4226.12,1246705.40,0.00,0.00,0.00,0.00,0.00),('5','107','706','223293',4305422,'1931','291',3525257.96,3531066.99,5809.03,1713663.85,0.00,0.00,0.00,0.00,0.00),('5','107','706','223293',4305423,'1932','291',3013412.15,3019020.33,5608.18,1654413.10,0.00,0.00,0.00,0.00,0.00),('5','107','706','223293',4305424,'1933','291',4015870.70,4020676.35,4805.65,1417666.75,0.00,0.00,0.00,0.00,0.00),('5','107','708','223293',4305425,'1934','291',1536204.00,1539182.56,2978.56,878675.20,0.00,0.00,0.00,0.00,0.00),('5','107','706','223293',4305426,'2898','291',2748593.37,2753537.51,4944.14,1458521.30,0.00,0.00,0.00,0.00,0.00),('5','107','708','223293',4305427,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','223561',4310428,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','223561',4310429,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','223561',4310430,'1877','290',764737.46,764737.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','223561',4310431,'1878','290',175330.29,175330.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','223561',4310432,'1879','290',843364.59,843364.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','223561',4310433,'1880','290',104521.61,104521.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','223561',4310434,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','223561',4310435,'1882','290',1064309.27,1065195.72,886.45,146264.25,0.00,0.00,0.00,0.00,0.00),('5','107','697','223561',4310436,'1883','290',523245.09,525118.59,1873.50,309127.50,0.00,0.00,0.00,0.00,0.00),('5','107','697','223561',4310437,'1884','290',114676.55,114676.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','223561',4310438,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','223561',4310439,'1886','290',2034324.05,2036999.03,2674.98,441371.70,0.00,0.00,0.00,0.00,0.00),('5','107','697','223561',4310440,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','223561',4310441,'1888','290',152407.54,152407.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','223561',4310442,'1889','290',2953622.80,2953622.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','223561',4310443,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','223561',4310444,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','223561',4310445,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','223561',4310446,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','223561',4310447,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','223561',4310448,'1895','290',676936.98,677369.59,432.61,71380.65,0.00,0.00,0.00,0.00,0.00),('5','107','698','223561',4310449,'1896','290',237358.57,238663.52,1304.95,215316.75,0.00,0.00,0.00,0.00,0.00),('5','107','698','223561',4310450,'1897','290',405582.01,406242.46,660.45,108974.25,0.00,0.00,0.00,0.00,0.00),('5','107','698','223561',4310451,'1898','290',65028.38,65028.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','223561',4310452,'1899','290',1870329.90,1870329.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','223561',4310453,'1900','290',407301.37,407301.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','223561',4310454,'1901','290',1031469.93,1031469.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','223561',4310455,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','223561',4310456,'1903','290',1055652.60,1055652.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','223561',4310457,'1904','290',1112340.98,1114856.45,2515.47,415052.55,0.00,0.00,0.00,0.00,0.00),('5','107','700','223561',4310458,'1905','290',1480064.95,1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','223561',4310459,'1906','290',579773.82,582370.38,2596.56,428432.40,0.00,0.00,0.00,0.00,0.00),('5','107','701','223561',4310460,'1907','290',1926886.39,1926886.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','223561',4310461,'1908','290',609451.91,609451.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','223561',4310462,'1909','290',478401.60,478401.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','223561',4310463,'1910','290',379334.55,379334.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','223561',4310464,'1911','290',1055767.12,1058155.96,2388.84,394158.60,0.00,0.00,0.00,0.00,0.00),('5','107','702','223561',4310465,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','223561',4310466,'1913','290',573320.08,575054.15,1734.07,286121.55,0.00,0.00,0.00,0.00,0.00),('5','107','702','223561',4310467,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','223561',4310468,'1915','290',230638.41,231501.04,862.63,142333.95,0.00,0.00,0.00,0.00,0.00),('5','107','702','223561',4310469,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','223561',4310470,'1917','290',960742.79,964578.13,3835.34,632831.10,0.00,0.00,0.00,0.00,0.00),('5','107','703','223561',4310471,'1918','290',139458.20,139458.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','223561',4310472,'1919','290',438954.57,442444.44,3489.87,575828.55,0.00,0.00,0.00,0.00,0.00),('5','107','703','223561',4310473,'1920','290',97332.11,97332.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','223561',4310474,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','223561',4310475,'1922','290',81603.36,81603.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','223561',4310476,'1923','290',721000.23,721000.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','223561',4310477,'1924','290',94886.16,94886.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','223561',4310478,'1925','290',1516787.26,1521150.42,4363.16,719921.40,0.00,0.00,0.00,0.00,0.00),('5','107','705','223561',4310479,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','223561',4310480,'1927','290',450037.52,451641.52,1604.00,264660.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','223561',4310481,'1928','290',111619.71,113440.79,1821.08,300478.20,0.00,0.00,0.00,0.00,0.00),('5','107','706','223561',4310482,'1929','291',3398180.60,3405113.87,6933.27,2045314.65,0.00,0.00,0.00,0.00,0.00),('5','107','706','223561',4310483,'1930','291',2320269.36,2324641.09,4371.73,1289660.35,0.00,0.00,0.00,0.00,0.00),('5','107','706','223561',4310484,'1931','291',3531066.99,3537002.33,5935.34,1750925.30,0.00,0.00,0.00,0.00,0.00),('5','107','706','223561',4310485,'1932','291',3019020.33,3024344.01,5323.68,1570485.60,0.00,0.00,0.00,0.00,0.00),('5','107','706','223561',4310486,'1933','291',4020676.35,4027376.18,6699.83,1976449.85,0.00,0.00,0.00,0.00,0.00),('5','107','708','223561',4310487,'1934','291',1539182.56,1544883.02,5700.46,1681635.70,0.00,0.00,0.00,0.00,0.00),('5','107','706','223561',4310488,'2898','291',2753537.51,2756801.63,3264.12,962915.40,0.00,0.00,0.00,0.00,0.00),('5','107','708','223561',4310489,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','223744',4313861,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','223744',4313862,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','223744',4313863,'1877','290',764737.46,764737.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','223744',4313864,'1878','290',175330.29,175330.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','223744',4313865,'1879','290',843364.59,843364.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','223744',4313866,'1880','290',104521.61,104521.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','223744',4313867,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','223744',4313868,'1882','290',1065195.72,1067387.48,2191.76,361640.40,0.00,0.00,0.00,0.00,0.00),('5','107','697','223744',4313869,'1883','290',525118.59,525407.57,288.98,47681.70,0.00,0.00,0.00,0.00,0.00),('5','107','697','223744',4313870,'1884','290',114676.55,114676.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','223744',4313871,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','223744',4313872,'1886','290',2036999.03,2040137.66,3138.63,517873.95,0.00,0.00,0.00,0.00,0.00),('5','107','697','223744',4313873,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','223744',4313874,'1888','290',152407.54,152569.99,162.45,26804.25,0.00,0.00,0.00,0.00,0.00),('5','107','696','223744',4313875,'1889','290',2953622.80,2954631.88,1009.08,166498.20,0.00,0.00,0.00,0.00,0.00),('5','107','696','223744',4313876,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','223744',4313877,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','223744',4313878,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','223744',4313879,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','223744',4313880,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','223744',4313881,'1895','290',677369.59,678342.17,972.58,160475.70,0.00,0.00,0.00,0.00,0.00),('5','107','698','223744',4313882,'1896','290',238663.52,241095.79,2432.27,401324.55,0.00,0.00,0.00,0.00,0.00),('5','107','698','223744',4313883,'1897','290',406242.46,406242.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','223744',4313884,'1898','290',65028.38,65028.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','223744',4313885,'1899','290',1870329.90,1870329.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','223744',4313886,'1900','290',407301.37,407301.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','223744',4313887,'1901','290',1031469.93,1031469.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','223744',4313888,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','223744',4313889,'1903','290',1055652.60,1055652.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','223744',4313890,'1904','290',1114856.45,1120751.78,5895.33,972729.45,0.00,0.00,0.00,0.00,0.00),('5','107','700','223744',4313891,'1905','290',1480064.95,1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','223744',4313892,'1906','290',582370.38,587075.70,4705.32,776377.80,0.00,0.00,0.00,0.00,0.00),('5','107','701','223744',4313893,'1907','290',1926886.39,1926886.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','223744',4313894,'1908','290',609451.91,609451.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','223744',4313895,'1909','290',478401.60,478401.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','223744',4313896,'1910','290',379334.55,379334.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','223744',4313897,'1911','290',1058155.96,1059761.16,1605.20,264858.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','223744',4313898,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','223744',4313899,'1913','290',575054.15,575642.95,588.80,97152.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','223744',4313900,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','223744',4313901,'1915','290',231501.04,231501.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','223744',4313902,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','223744',4313903,'1917','290',964578.13,968431.53,3853.40,635811.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','223744',4313904,'1918','290',139458.20,139458.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','223744',4313905,'1919','290',442444.44,445426.80,2982.36,492089.40,0.00,0.00,0.00,0.00,0.00),('5','107','703','223744',4313906,'1920','290',97332.11,97332.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','223744',4313907,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','223744',4313908,'1922','290',81603.36,81603.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','223744',4313909,'1923','290',721000.23,721000.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','223744',4313910,'1924','290',94886.16,94886.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','223744',4313911,'1925','290',1521150.42,1526763.54,5613.12,926164.80,0.00,0.00,0.00,0.00,0.00),('5','107','705','223744',4313912,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','223744',4313913,'1927','290',451641.52,454341.59,2700.07,445511.55,0.00,0.00,0.00,0.00,0.00),('5','107','705','223744',4313914,'1928','290',113440.79,113440.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','223744',4313915,'1929','291',3405113.87,3413304.24,8190.37,2416159.15,0.00,0.00,0.00,0.00,0.00),('5','107','706','223744',4313916,'1930','291',2324641.09,2330237.72,5596.63,1651005.85,0.00,0.00,0.00,0.00,0.00),('5','107','706','223744',4313917,'1931','291',3537002.33,3541343.59,4341.26,1280671.70,0.00,0.00,0.00,0.00,0.00),('5','107','706','223744',4313918,'1932','291',3024344.01,3029302.28,4958.27,1462689.65,0.00,0.00,0.00,0.00,0.00),('5','107','706','223744',4313919,'1933','291',4027376.18,4033861.62,6485.44,1913204.80,0.00,0.00,0.00,0.00,0.00),('5','107','708','223744',4313920,'1934','291',1544883.02,1545489.09,606.07,178790.65,0.00,0.00,0.00,0.00,0.00),('5','107','706','223744',4313921,'2898','291',2756801.63,2762083.78,5282.15,1558234.25,0.00,0.00,0.00,0.00,0.00),('5','107','708','223744',4313922,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','224026',4318993,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','224026',4318994,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','224026',4318995,'1877','290',764737.46,767725.99,2988.53,493107.45,0.00,0.00,0.00,0.00,0.00),('5','107','696','224026',4318996,'1878','290',175330.29,175330.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','224026',4318997,'1879','290',843364.59,843364.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','224026',4318998,'1880','290',104521.61,104521.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','224026',4318999,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','224026',4319000,'1882','290',1067387.48,1067387.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','224026',4319001,'1883','290',525407.57,525407.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','224026',4319002,'1884','290',114676.55,114676.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','224026',4319003,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','224026',4319004,'1886','290',2040137.66,2040137.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','224026',4319005,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','224026',4319006,'1888','290',152569.99,152569.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','224026',4319007,'1889','290',2954631.88,2960568.20,5936.32,979492.80,0.00,0.00,0.00,0.00,0.00),('5','107','696','224026',4319008,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','224026',4319009,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','224026',4319010,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','224026',4319011,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','224026',4319012,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','224026',4319013,'1895','290',678342.17,679321.92,979.75,161658.75,0.00,0.00,0.00,0.00,0.00),('5','107','698','224026',4319014,'1896','290',241095.79,244210.56,3114.77,513937.05,0.00,0.00,0.00,0.00,0.00),('5','107','698','224026',4319015,'1897','290',406242.46,406242.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','224026',4319016,'1898','290',65028.38,65028.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','224026',4319017,'1899','290',1870329.90,1870329.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','224026',4319018,'1900','290',407301.37,407301.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','224026',4319019,'1901','290',1031469.93,1031469.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','224026',4319020,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','224026',4319021,'1903','290',1055652.60,1055652.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','224026',4319022,'1904','290',1120751.78,1127458.04,6706.26,1106532.90,0.00,0.00,0.00,0.00,0.00),('5','107','700','224026',4319023,'1905','290',1480064.95,1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','224026',4319024,'1906','290',587075.70,592214.91,5139.21,847969.65,0.00,0.00,0.00,0.00,0.00),('5','107','701','224026',4319025,'1907','290',1926886.39,1926886.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','224026',4319026,'1908','290',609451.91,609451.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','224026',4319027,'1909','290',478401.60,478401.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','224026',4319028,'1910','290',379334.55,379334.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','224026',4319029,'1911','290',1059761.16,1062462.60,2701.44,445737.60,0.00,0.00,0.00,0.00,0.00),('5','107','702','224026',4319030,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','224026',4319031,'1913','290',575642.95,575642.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','224026',4319032,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','224026',4319033,'1915','290',231501.04,231633.36,132.32,21832.80,0.00,0.00,0.00,0.00,0.00),('5','107','702','224026',4319034,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','224026',4319035,'1917','290',968431.53,971083.96,2652.43,437650.95,0.00,0.00,0.00,0.00,0.00),('5','107','703','224026',4319036,'1918','290',139458.20,139458.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','224026',4319037,'1919','290',445426.80,445426.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','224026',4319038,'1920','290',97332.11,97332.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','224026',4319039,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','224026',4319040,'1922','290',81603.36,81603.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','224026',4319041,'1923','290',721000.23,721000.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','224026',4319042,'1924','290',94886.16,94886.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','224026',4319043,'1925','290',1526763.54,1531324.08,4560.54,752489.10,0.00,0.00,0.00,0.00,0.00),('5','107','705','224026',4319044,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','224026',4319045,'1927','290',454341.59,454341.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','224026',4319046,'1928','290',113440.79,113440.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','224026',4319047,'1929','291',3413304.24,3419246.96,5942.72,1753102.40,0.00,0.00,0.00,0.00,0.00),('5','107','706','224026',4319048,'1930','291',2330237.72,2334933.33,4695.61,1385204.95,0.00,0.00,0.00,0.00,0.00),('5','107','706','224026',4319049,'1931','291',3541343.59,3544293.11,2949.52,870108.40,0.00,0.00,0.00,0.00,0.00),('5','107','706','224026',4319050,'1932','291',3029302.28,3033209.49,3907.21,1152626.95,0.00,0.00,0.00,0.00,0.00),('5','107','706','224026',4319051,'1933','291',4033861.62,4036889.79,3028.17,893310.15,0.00,0.00,0.00,0.00,0.00),('5','107','708','224026',4319052,'1934','291',1545489.09,1545489.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','224026',4319053,'2898','291',2762083.78,2765819.37,3735.59,1101999.05,0.00,0.00,0.00,0.00,0.00),('5','107','708','224026',4319054,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','224373',4324991,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','224373',4324992,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','224373',4324993,'1877','290',767725.99,769102.13,1376.14,227063.10,0.00,0.00,0.00,0.00,0.00),('5','107','696','224373',4324994,'1878','290',175330.29,175330.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','224373',4324995,'1879','290',843364.59,844245.88,881.29,145412.85,0.00,0.00,0.00,0.00,0.00),('5','107','696','224373',4324996,'1880','290',104521.61,104521.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','224373',4324997,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','224373',4324998,'1882','290',1067387.48,1068745.84,1358.36,224129.40,0.00,0.00,0.00,0.00,0.00),('5','107','697','224373',4324999,'1883','290',525407.57,526682.57,1275.00,210375.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','224373',4325000,'1884','290',114676.55,114676.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','224373',4325001,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','224373',4325002,'1886','290',2040137.66,2043922.59,3784.93,624513.45,0.00,0.00,0.00,0.00,0.00),('5','107','697','224373',4325003,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','224373',4325004,'1888','290',152569.99,152569.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','224373',4325005,'1889','290',2960568.20,2966951.31,6383.11,1053213.15,0.00,0.00,0.00,0.00,0.00),('5','107','696','224373',4325006,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','224373',4325007,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','224373',4325008,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','224373',4325009,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','224373',4325010,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','224373',4325011,'1895','290',679321.92,679321.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','224373',4325012,'1896','290',244210.56,246878.85,2668.29,440267.85,0.00,0.00,0.00,0.00,0.00),('5','107','698','224373',4325013,'1897','290',406242.46,406893.42,650.96,107408.40,0.00,0.00,0.00,0.00,0.00),('5','107','698','224373',4325014,'1898','290',65028.38,65028.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','224373',4325015,'1899','290',1870329.90,1870329.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','224373',4325016,'1900','290',407301.37,407301.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','224373',4325017,'1901','290',1031469.93,1031469.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','224373',4325018,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','224373',4325019,'1903','290',1055652.60,1055671.68,19.08,3148.20,0.00,0.00,0.00,0.00,0.00),('5','107','700','224373',4325020,'1904','290',1127458.04,1131083.01,3624.97,598120.05,0.00,0.00,0.00,0.00,0.00),('5','107','700','224373',4325021,'1905','290',1480064.95,1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','224373',4325022,'1906','290',592214.91,595403.46,3188.55,526110.75,0.00,0.00,0.00,0.00,0.00),('5','107','701','224373',4325023,'1907','290',1926886.39,1927332.74,446.35,73647.75,0.00,0.00,0.00,0.00,0.00),('5','107','701','224373',4325024,'1908','290',609451.91,610294.36,842.45,139004.25,0.00,0.00,0.00,0.00,0.00),('5','107','701','224373',4325025,'1909','290',478401.60,478401.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','224373',4325026,'1910','290',379334.55,379334.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','224373',4325027,'1911','290',1062462.60,1064703.54,2240.94,369755.10,0.00,0.00,0.00,0.00,0.00),('5','107','702','224373',4325028,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','224373',4325029,'1913','290',575642.95,576191.51,548.56,90512.40,0.00,0.00,0.00,0.00,0.00),('5','107','702','224373',4325030,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','224373',4325031,'1915','290',231633.36,231633.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','224373',4325032,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','224373',4325033,'1917','290',971083.96,973085.46,2001.50,330247.50,0.00,0.00,0.00,0.00,0.00),('5','107','703','224373',4325034,'1918','290',139458.20,139458.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','224373',4325035,'1919','290',445426.80,445977.53,550.73,90870.45,0.00,0.00,0.00,0.00,0.00),('5','107','703','224373',4325036,'1920','290',97332.11,97332.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','224373',4325037,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','224373',4325038,'1922','290',81603.36,81603.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','224373',4325039,'1923','290',721000.23,721000.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','224373',4325040,'1924','290',94886.16,94886.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','224373',4325041,'1925','290',1531324.08,1534904.68,3580.60,590799.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','224373',4325042,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','224373',4325043,'1927','290',454341.59,454379.98,38.39,6334.35,0.00,0.00,0.00,0.00,0.00),('5','107','705','224373',4325044,'1928','290',113440.79,113440.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','224373',4325045,'1929','291',3419246.96,3426344.90,7097.94,2093892.30,0.00,0.00,0.00,0.00,0.00),('5','107','706','224373',4325046,'1930','291',2334933.33,2339046.96,4113.63,1213520.85,0.00,0.00,0.00,0.00,0.00),('5','107','706','224373',4325047,'1931','291',3544293.11,3547770.67,3477.56,1025880.20,0.00,0.00,0.00,0.00,0.00),('5','107','706','224373',4325048,'1932','291',3033209.49,3036626.05,3416.56,1007885.20,0.00,0.00,0.00,0.00,0.00),('5','107','706','224373',4325049,'1933','291',4036889.79,4043737.75,6847.96,2020148.20,0.00,0.00,0.00,0.00,0.00),('5','107','708','224373',4325050,'1934','291',1545489.09,1551484.06,5994.97,1768516.15,0.00,0.00,0.00,0.00,0.00),('5','107','706','224373',4325051,'2898','291',2765819.37,2771069.44,5250.07,1548770.65,0.00,0.00,0.00,0.00,0.00),('5','107','708','224373',4325052,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','224553',4328154,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','224553',4328155,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','224553',4328156,'1877','290',769102.13,769696.73,594.60,98109.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','224553',4328157,'1878','290',175330.29,175330.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','224553',4328158,'1879','290',844245.88,844245.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','224553',4328159,'1880','290',104521.61,104521.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','224553',4328160,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','224553',4328161,'1882','290',1068745.84,1070060.94,1315.10,216991.50,0.00,0.00,0.00,0.00,0.00),('5','107','697','224553',4328162,'1883','290',526682.57,527357.00,674.43,111280.95,0.00,0.00,0.00,0.00,0.00),('5','107','697','224553',4328163,'1884','290',114676.55,114676.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','224553',4328164,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','224553',4328165,'1886','290',2043922.59,2048490.76,4568.17,753748.05,0.00,0.00,0.00,0.00,0.00),('5','107','697','224553',4328166,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','224553',4328167,'1888','290',152569.99,153860.29,1290.30,212899.50,0.00,0.00,0.00,0.00,0.00),('5','107','696','224553',4328168,'1889','290',2966951.31,2972026.40,5075.09,837389.85,0.00,0.00,0.00,0.00,0.00),('5','107','696','224553',4328169,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','224553',4328170,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','224553',4328171,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','224553',4328172,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','224553',4328173,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','224553',4328174,'1895','290',679321.92,679759.32,437.40,72171.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','224553',4328175,'1896','290',246878.85,249061.33,2182.48,360109.20,0.00,0.00,0.00,0.00,0.00),('5','107','698','224553',4328176,'1897','290',406893.42,407459.41,565.99,93388.35,0.00,0.00,0.00,0.00,0.00),('5','107','698','224553',4328177,'1898','290',65028.38,65028.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','224553',4328178,'1899','290',1870329.90,1873567.01,3237.11,534123.15,0.00,0.00,0.00,0.00,0.00),('5','107','699','224553',4328179,'1900','290',407301.37,408011.54,710.17,117178.05,0.00,0.00,0.00,0.00,0.00),('5','107','699','224553',4328180,'1901','290',1031469.93,1031469.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','224553',4328181,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','224553',4328182,'1903','290',1055671.68,1056505.40,833.72,137563.80,0.00,0.00,0.00,0.00,0.00),('5','107','700','224553',4328183,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','224553',4328184,'1905','290',1480064.95,1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','224553',4328185,'1906','290',595403.46,596329.54,926.08,152803.20,0.00,0.00,0.00,0.00,0.00),('5','107','701','224553',4328186,'1907','290',1927332.74,1931482.81,4150.07,684761.55,0.00,0.00,0.00,0.00,0.00),('5','107','701','224553',4328187,'1908','290',610294.36,610294.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','224553',4328188,'1909','290',478401.60,478401.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','224553',4328189,'1910','290',379334.55,379334.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','224553',4328190,'1911','290',1064703.54,1067020.71,2317.17,382333.05,0.00,0.00,0.00,0.00,0.00),('5','107','702','224553',4328191,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','224553',4328192,'1913','290',576191.51,577325.36,1133.85,187085.25,0.00,0.00,0.00,0.00,0.00),('5','107','702','224553',4328193,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','224553',4328194,'1915','290',231633.36,231633.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','224553',4328195,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','224553',4328196,'1917','290',973085.46,973085.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','224553',4328197,'1918','290',139458.20,139458.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','224553',4328198,'1919','290',445977.53,445977.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','224553',4328199,'1920','290',97332.11,97332.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','224553',4328200,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','224553',4328201,'1922','290',81603.36,81603.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','224553',4328202,'1923','290',721000.23,721000.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','224553',4328203,'1924','290',94886.16,94886.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','224553',4328204,'1925','290',1534904.68,1537229.66,2324.98,383621.70,0.00,0.00,0.00,0.00,0.00),('5','107','705','224553',4328205,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','224553',4328206,'1927','290',454379.98,454898.13,518.15,85494.75,0.00,0.00,0.00,0.00,0.00),('5','107','705','224553',4328207,'1928','290',113440.79,113440.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','224553',4328208,'1929','291',3426344.90,3435428.89,9083.99,2679777.05,0.00,0.00,0.00,0.00,0.00),('5','107','706','224553',4328209,'1930','291',2339046.96,2341713.55,2666.59,786644.05,0.00,0.00,0.00,0.00,0.00),('5','107','706','224553',4328210,'1931','291',3547770.67,3551220.08,3449.41,1017575.95,0.00,0.00,0.00,0.00,0.00),('5','107','706','224553',4328211,'1932','291',3036626.05,3040865.05,4239.00,1250505.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','224553',4328212,'1933','291',4043737.75,4052894.56,9156.81,2701258.95,0.00,0.00,0.00,0.00,0.00),('5','107','708','224553',4328213,'1934','291',1551484.06,1552134.06,650.00,191750.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','224553',4328214,'2898','291',2771069.44,2774835.90,3766.46,1111105.70,0.00,0.00,0.00,0.00,0.00),('5','107','708','224553',4328215,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','224632',4329594,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','224632',4329595,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','224632',4329596,'1877','290',769696.73,769696.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','224632',4329597,'1878','290',175330.29,176687.38,1357.09,223919.85,0.00,0.00,0.00,0.00,0.00),('5','107','696','224632',4329598,'1879','290',844245.88,844245.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','224632',4329599,'1880','290',104521.61,104521.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','224632',4329600,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','224632',4329601,'1882','290',1070060.94,1070060.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','224632',4329602,'1883','290',527357.00,527547.99,190.99,31513.35,0.00,0.00,0.00,0.00,0.00),('5','107','697','224632',4329603,'1884','290',114676.55,114676.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','224632',4329604,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','224632',4329605,'1886','290',2048490.76,2048876.13,385.37,63586.05,0.00,0.00,0.00,0.00,0.00),('5','107','697','224632',4329606,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','224632',4329607,'1888','290',153860.29,154083.84,223.55,36885.75,0.00,0.00,0.00,0.00,0.00),('5','107','696','224632',4329608,'1889','290',2972026.40,2977767.03,5740.63,947203.95,0.00,0.00,0.00,0.00,0.00),('5','107','696','224632',4329609,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','224632',4329610,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','224632',4329611,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','224632',4329612,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','224632',4329613,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','224632',4329614,'1895','290',679759.32,681458.80,1699.48,280414.20,0.00,0.00,0.00,0.00,0.00),('5','107','698','224632',4329615,'1896','290',249061.33,249572.19,510.86,84291.90,0.00,0.00,0.00,0.00,0.00),('5','107','698','224632',4329616,'1897','290',407459.41,408624.91,1165.50,192307.50,0.00,0.00,0.00,0.00,0.00),('5','107','698','224632',4329617,'1898','290',65028.38,65028.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','224632',4329618,'1899','290',1873567.01,1877404.78,3837.77,633232.05,0.00,0.00,0.00,0.00,0.00),('5','107','699','224632',4329619,'1900','290',408011.54,409291.14,1279.60,211134.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','224632',4329620,'1901','290',1031469.93,1033159.60,1689.67,278795.55,0.00,0.00,0.00,0.00,0.00),('5','107','699','224632',4329621,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','224632',4329622,'1903','290',1056505.40,1056505.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','224632',4329623,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','224632',4329624,'1905','290',1480064.95,1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','224632',4329625,'1906','290',596329.54,596329.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','224632',4329626,'1907','290',1931482.81,1932341.95,859.14,141758.10,0.00,0.00,0.00,0.00,0.00),('5','107','701','224632',4329627,'1908','290',610294.36,610294.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','224632',4329628,'1909','290',478401.60,478793.32,391.72,64633.80,0.00,0.00,0.00,0.00,0.00),('5','107','701','224632',4329629,'1910','290',379334.55,379334.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','224632',4329630,'1911','290',1067020.71,1069320.87,2300.16,379526.40,0.00,0.00,0.00,0.00,0.00),('5','107','702','224632',4329631,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','224632',4329632,'1913','290',577325.36,578605.90,1280.54,211289.10,0.00,0.00,0.00,0.00,0.00),('5','107','702','224632',4329633,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','224632',4329634,'1915','290',231633.36,232424.79,791.43,130585.95,0.00,0.00,0.00,0.00,0.00),('5','107','702','224632',4329635,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','224632',4329636,'1917','290',973085.46,973085.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','224632',4329637,'1918','290',139458.20,139458.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','224632',4329638,'1919','290',445977.53,445977.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','224632',4329639,'1920','290',97332.11,97332.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','224632',4329640,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','224632',4329641,'1922','290',81603.36,81603.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','224632',4329642,'1923','290',721000.23,721000.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','224632',4329643,'1924','290',94886.16,94886.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','224632',4329644,'1925','290',1537229.66,1541006.60,3776.94,623195.10,0.00,0.00,0.00,0.00,0.00),('5','107','705','224632',4329645,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','224632',4329646,'1927','290',454898.13,456499.54,1601.41,264232.65,0.00,0.00,0.00,0.00,0.00),('5','107','705','224632',4329647,'1928','290',113440.79,113440.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','224632',4329648,'1929','291',3435428.89,3442389.70,6960.81,2053438.95,0.00,0.00,0.00,0.00,0.00),('5','107','706','224632',4329649,'1930','291',2341713.55,2345696.15,3982.60,1174867.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','224632',4329650,'1931','291',3551220.08,3554859.22,3639.14,1073546.30,0.00,0.00,0.00,0.00,0.00),('5','107','706','224632',4329651,'1932','291',3040865.05,3043788.03,2922.98,862279.10,0.00,0.00,0.00,0.00,0.00),('5','107','706','224632',4329652,'1933','291',4052894.56,4059801.09,6906.53,2037426.35,0.00,0.00,0.00,0.00,0.00),('5','107','708','224632',4329653,'1934','291',1552134.06,1553328.86,1194.80,352466.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','224632',4329654,'2898','291',2774835.90,2777032.44,2196.54,647979.30,0.00,0.00,0.00,0.00,0.00),('5','107','708','224632',4329655,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','224836',4333055,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','224836',4333056,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','224836',4333057,'1877','290',769696.73,770889.52,1192.79,196810.35,0.00,0.00,0.00,0.00,0.00),('5','107','696','224836',4333058,'1878','290',176687.38,176687.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','224836',4333059,'1879','290',844245.88,845647.47,1401.59,231262.35,0.00,0.00,0.00,0.00,0.00),('5','107','696','224836',4333060,'1880','290',104521.61,104521.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','224836',4333061,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','224836',4333062,'1882','290',1070060.94,1070060.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','224836',4333063,'1883','290',527547.99,527547.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','224836',4333064,'1884','290',114676.55,114676.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','224836',4333065,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','224836',4333066,'1886','290',2048876.13,2048876.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','224836',4333067,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','224836',4333068,'1888','290',154083.84,154083.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','224836',4333069,'1889','290',2977767.03,2981005.60,3238.57,534364.05,0.00,0.00,0.00,0.00,0.00),('5','107','696','224836',4333070,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','224836',4333071,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','224836',4333072,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','224836',4333073,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','224836',4333074,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','224836',4333075,'1895','290',681458.80,681458.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','224836',4333076,'1896','290',249572.19,249677.00,104.81,17293.65,0.00,0.00,0.00,0.00,0.00),('5','107','698','224836',4333077,'1897','290',408624.91,409292.95,668.04,110226.60,0.00,0.00,0.00,0.00,0.00),('5','107','698','224836',4333078,'1898','290',65028.38,65028.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','224836',4333079,'1899','290',1877404.78,1879014.65,1609.87,265628.55,0.00,0.00,0.00,0.00,0.00),('5','107','699','224836',4333080,'1900','290',409291.14,409291.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','224836',4333081,'1901','290',1033159.60,1034549.90,1390.30,229399.50,0.00,0.00,0.00,0.00,0.00),('5','107','699','224836',4333082,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','224836',4333083,'1903','290',1056505.40,1059230.00,2724.60,449559.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','224836',4333084,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','224836',4333085,'1905','290',1480064.95,1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','224836',4333086,'1906','290',596329.54,598479.82,2150.28,354796.20,0.00,0.00,0.00,0.00,0.00),('5','107','701','224836',4333087,'1907','290',1932341.95,1932341.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','224836',4333088,'1908','290',610294.36,610294.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','224836',4333089,'1909','290',478793.32,478793.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','224836',4333090,'1910','290',379334.55,379334.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','224836',4333091,'1911','290',1069320.87,1069902.33,581.46,95940.90,0.00,0.00,0.00,0.00,0.00),('5','107','702','224836',4333092,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','224836',4333093,'1913','290',578605.90,578930.09,324.19,53491.35,0.00,0.00,0.00,0.00,0.00),('5','107','702','224836',4333094,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','224836',4333095,'1915','290',232424.79,233198.53,773.74,127667.10,0.00,0.00,0.00,0.00,0.00),('5','107','702','224836',4333096,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','224836',4333097,'1917','290',973085.46,973556.10,470.64,77655.60,0.00,0.00,0.00,0.00,0.00),('5','107','703','224836',4333098,'1918','290',139458.20,139458.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','224836',4333099,'1919','290',445977.53,446729.00,751.47,123992.55,0.00,0.00,0.00,0.00,0.00),('5','107','703','224836',4333100,'1920','290',97332.11,97332.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','224836',4333101,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','224836',4333102,'1922','290',81603.36,81603.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','224836',4333103,'1923','290',721000.23,721000.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','224836',4333104,'1924','290',94886.16,94886.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','224836',4333105,'1925','290',1541006.60,1541006.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','224836',4333106,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','224836',4333107,'1927','290',456499.54,456499.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','224836',4333108,'1928','290',113440.79,113440.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','224836',4333109,'1929','291',3442389.70,3442389.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','224836',4333110,'1930','291',2345696.15,2345696.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','224836',4333111,'1931','291',3554859.22,3554859.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','224836',4333112,'1932','291',3043788.03,3043788.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','224836',4333113,'1933','291',4059801.09,4059801.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','224836',4333114,'1934','291',1553328.86,1553328.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','224836',4333115,'2898','291',2777032.44,2777032.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','224836',4333116,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','225104',4338029,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','225104',4338030,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','225104',4338031,'1877','290',770889.52,772655.75,1766.23,287895.49,0.00,0.00,0.00,0.00,0.00),('5','107','696','225104',4338032,'1878','290',176687.38,176687.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','225104',4338033,'1879','290',845647.47,846073.25,425.78,69402.14,0.00,0.00,0.00,0.00,0.00),('5','107','696','225104',4338034,'1880','290',104521.61,104521.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','225104',4338035,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','225104',4338036,'1882','290',1070060.94,1070060.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','225104',4338037,'1883','290',527547.99,527547.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','225104',4338038,'1884','290',114676.55,114676.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','225104',4338039,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','225104',4338040,'1886','290',2048876.13,2048876.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','225104',4338041,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','225104',4338042,'1888','290',154083.84,154083.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','225104',4338043,'1889','290',2981005.60,2983789.57,2783.97,453787.11,0.00,0.00,0.00,0.00,0.00),('5','107','696','225104',4338044,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','225104',4338045,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','225104',4338046,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','225104',4338047,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','225104',4338048,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','225104',4338049,'1895','290',681458.80,681458.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','225104',4338050,'1896','290',249677.00,250862.00,1185.00,193155.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','225104',4338051,'1897','290',409292.95,409292.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','225104',4338052,'1898','290',65028.38,65028.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','225104',4338053,'1899','290',1879014.65,1879014.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','225104',4338054,'1900','290',409291.14,409291.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','225104',4338055,'1901','290',1034549.90,1035288.32,738.42,120362.46,0.00,0.00,0.00,0.00,0.00),('5','107','699','225104',4338056,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','225104',4338057,'1903','290',1059230.00,1063096.98,3866.98,630317.74,0.00,0.00,0.00,0.00,0.00),('5','107','700','225104',4338058,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','225104',4338059,'1905','290',1480064.95,1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','225104',4338060,'1906','290',598479.82,601630.69,3150.87,513591.81,0.00,0.00,0.00,0.00,0.00),('5','107','701','225104',4338061,'1907','290',1932341.95,1935070.69,2728.74,444784.62,0.00,0.00,0.00,0.00,0.00),('5','107','701','225104',4338062,'1908','290',610294.36,610294.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','225104',4338063,'1909','290',478793.32,478836.25,42.93,6997.59,0.00,0.00,0.00,0.00,0.00),('5','107','701','225104',4338064,'1910','290',379334.55,379334.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','225104',4338065,'1911','290',1069902.33,1071987.91,2085.58,339949.54,0.00,0.00,0.00,0.00,0.00),('5','107','702','225104',4338066,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','225104',4338067,'1913','290',578930.09,579680.51,750.42,122318.46,0.00,0.00,0.00,0.00,0.00),('5','107','702','225104',4338068,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','225104',4338069,'1915','290',233198.53,233198.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','225104',4338070,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','225104',4338071,'1917','290',973556.10,974115.29,559.19,91147.97,0.00,0.00,0.00,0.00,0.00),('5','107','703','225104',4338072,'1918','290',139458.20,139458.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','225104',4338073,'1919','290',446729.00,446729.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','225104',4338074,'1920','290',97332.11,97332.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','225104',4338075,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','225104',4338076,'1922','290',81603.36,81603.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','225104',4338077,'1923','290',721000.23,721000.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','225104',4338078,'1924','290',94886.16,94886.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','225104',4338079,'1925','290',1541006.60,1541006.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','225104',4338080,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','225104',4338081,'1927','290',456499.54,456499.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','225104',4338082,'1928','290',113440.79,113440.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','225104',4338083,'1929','291',3442389.70,3449278.68,6888.98,2032249.10,0.00,0.00,0.00,0.00,0.00),('5','107','706','225104',4338084,'1930','291',2345696.15,2350038.49,4342.34,1280990.30,0.00,0.00,0.00,0.00,0.00),('5','107','706','225104',4338085,'1931','291',3554859.22,3561332.65,6473.43,1909661.85,0.00,0.00,0.00,0.00,0.00),('5','107','706','225104',4338086,'1932','291',3043788.03,3048726.11,4938.08,1456733.60,0.00,0.00,0.00,0.00,0.00),('5','107','706','225104',4338087,'1933','291',4059801.09,4066092.40,6291.31,1855936.45,0.00,0.00,0.00,0.00,0.00),('5','107','708','225104',4338088,'1934','291',1553328.86,1559144.96,5816.10,1715749.50,0.00,0.00,0.00,0.00,0.00),('5','107','706','225104',4338089,'2898','291',2777032.44,2781398.00,4365.56,1287840.20,0.00,0.00,0.00,0.00,0.00),('5','107','708','225104',4338090,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','225352',4342436,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','225352',4342437,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','225352',4342438,'1877','290',772655.75,773044.70,388.95,63398.85,0.00,0.00,0.00,0.00,0.00),('5','107','696','225352',4342439,'1878','290',176687.38,176687.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','225352',4342440,'1879','290',846073.25,846073.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','225352',4342441,'1880','290',104521.61,104521.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','225352',4342442,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','225352',4342443,'1882','290',1070060.94,1073012.42,2951.48,481091.24,0.00,0.00,0.00,0.00,0.00),('5','107','697','225352',4342444,'1883','290',527547.99,527547.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','225352',4342445,'1884','290',114676.55,114676.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','225352',4342446,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','225352',4342447,'1886','290',2048876.13,2053718.55,4842.42,789314.46,0.00,0.00,0.00,0.00,0.00),('5','107','697','225352',4342448,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','225352',4342449,'1888','290',154083.84,154083.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','225352',4342450,'1889','290',2983789.57,2985503.70,1714.13,279403.19,0.00,0.00,0.00,0.00,0.00),('5','107','696','225352',4342451,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','225352',4342452,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','225352',4342453,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','225352',4342454,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','225352',4342455,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','225352',4342456,'1895','290',681458.80,681458.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','225352',4342457,'1896','290',250862.00,251176.00,314.00,51182.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','225352',4342458,'1897','290',409292.95,409450.00,157.05,25599.15,0.00,0.00,0.00,0.00,0.00),('5','107','698','225352',4342459,'1898','290',65028.38,65028.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','225352',4342460,'1899','290',1879014.65,1881522.85,2508.20,408836.60,0.00,0.00,0.00,0.00,0.00),('5','107','699','225352',4342461,'1900','290',409291.14,409291.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','225352',4342462,'1901','290',1035288.32,1036747.17,1458.85,237792.55,0.00,0.00,0.00,0.00,0.00),('5','107','699','225352',4342463,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','225352',4342464,'1903','290',1063096.98,1065228.62,2131.64,347457.32,0.00,0.00,0.00,0.00,0.00),('5','107','700','225352',4342465,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','225352',4342466,'1905','290',1480064.95,1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','225352',4342467,'1906','290',601630.69,602415.90,785.21,127989.23,0.00,0.00,0.00,0.00,0.00),('5','107','701','225352',4342468,'1907','290',1935070.69,1939324.98,4254.29,693449.27,0.00,0.00,0.00,0.00,0.00),('5','107','701','225352',4342469,'1908','290',610294.36,610294.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','225352',4342470,'1909','290',478836.25,482424.72,3588.47,584920.61,0.00,0.00,0.00,0.00,0.00),('5','107','701','225352',4342471,'1910','290',379334.55,379334.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','225352',4342472,'1911','290',1071987.91,1073698.19,1710.28,278775.64,0.00,0.00,0.00,0.00,0.00),('5','107','702','225352',4342473,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','225352',4342474,'1913','290',579680.51,580269.68,589.17,96034.71,0.00,0.00,0.00,0.00,0.00),('5','107','702','225352',4342475,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','225352',4342476,'1915','290',233198.53,233445.98,247.45,40334.35,0.00,0.00,0.00,0.00,0.00),('5','107','702','225352',4342477,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','225352',4342478,'1917','290',974115.29,975021.41,906.12,147697.56,0.00,0.00,0.00,0.00,0.00),('5','107','703','225352',4342479,'1918','290',139458.20,139458.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','225352',4342480,'1919','290',446729.00,447776.24,1047.24,170700.12,0.00,0.00,0.00,0.00,0.00),('5','107','703','225352',4342481,'1920','290',97332.11,97332.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','225352',4342482,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','225352',4342483,'1922','290',81603.36,81614.00,10.64,1734.32,0.00,0.00,0.00,0.00,0.00),('5','107','704','225352',4342484,'1923','290',721000.23,721000.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','225352',4342485,'1924','290',94886.16,96788.40,1902.24,310065.12,0.00,0.00,0.00,0.00,0.00),('5','107','705','225352',4342486,'1925','290',1541006.60,1542915.13,1908.53,311090.39,0.00,0.00,0.00,0.00,0.00),('5','107','705','225352',4342487,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','225352',4342488,'1927','290',456499.54,456499.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','225352',4342489,'1928','290',113440.79,113440.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','225352',4342490,'1929','291',3449278.68,3458162.16,8883.48,2620626.60,0.00,0.00,0.00,0.00,0.00),('5','107','706','225352',4342491,'1930','291',2350038.49,2353064.30,3025.81,892613.95,0.00,0.00,0.00,0.00,0.00),('5','107','706','225352',4342492,'1931','291',3561332.65,3566358.35,5025.70,1482581.50,0.00,0.00,0.00,0.00,0.00),('5','107','706','225352',4342493,'1932','291',3048726.11,3052516.60,3790.49,1118194.55,0.00,0.00,0.00,0.00,0.00),('5','107','706','225352',4342494,'1933','291',4066092.40,4071407.55,5315.15,1567969.25,0.00,0.00,0.00,0.00,0.00),('5','107','708','225352',4342495,'1934','291',1559144.96,1559144.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','225352',4342496,'2898','291',2781398.00,2785457.32,4059.32,1197499.40,0.00,0.00,0.00,0.00,0.00),('5','107','708','225352',4342497,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','225363',4342732,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','225363',4342733,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','225363',4342734,'1877','290',773044.70,773604.54,559.84,91253.92,0.00,0.00,0.00,0.00,0.00),('5','107','696','225363',4342735,'1878','290',176687.38,176687.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','225363',4342736,'1879','290',846073.25,847041.07,967.82,157754.66,0.00,0.00,0.00,0.00,0.00),('5','107','696','225363',4342737,'1880','290',104521.61,104521.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','225363',4342738,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','225363',4342739,'1882','290',1073012.42,1074905.88,1893.46,308633.98,0.00,0.00,0.00,0.00,0.00),('5','107','697','225363',4342740,'1883','290',527547.99,527547.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','225363',4342741,'1884','290',114676.55,114676.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','225363',4342742,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','225363',4342743,'1886','290',2053718.55,2059970.12,6251.57,1019005.91,0.00,0.00,0.00,0.00,0.00),('5','107','697','225363',4342744,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','225363',4342745,'1888','290',154083.84,154083.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','225363',4342746,'1889','290',2985503.70,2991511.10,6007.40,979206.20,0.00,0.00,0.00,0.00,0.00),('5','107','696','225363',4342747,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','225363',4342748,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','225363',4342749,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','225363',4342750,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','225363',4342751,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','225363',4342752,'1895','290',681458.80,681458.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','225363',4342753,'1896','290',251176.00,252386.00,1210.00,197230.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','225363',4342754,'1897','290',409450.00,409450.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','225363',4342755,'1898','290',65028.38,65028.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','225363',4342756,'1899','290',1881522.85,1882786.14,1263.29,205916.27,0.00,0.00,0.00,0.00,0.00),('5','107','699','225363',4342757,'1900','290',409291.14,410739.53,1448.39,236087.57,0.00,0.00,0.00,0.00,0.00),('5','107','699','225363',4342758,'1901','290',1036747.17,1037824.58,1077.41,175617.83,0.00,0.00,0.00,0.00,0.00),('5','107','699','225363',4342759,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','225363',4342760,'1903','290',1065228.62,1066147.70,919.08,149810.04,0.00,0.00,0.00,0.00,0.00),('5','107','700','225363',4342761,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','225363',4342762,'1905','290',1480064.95,1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','225363',4342763,'1906','290',602415.90,602415.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','225363',4342764,'1907','290',1939324.98,1942325.34,3000.36,489058.68,0.00,0.00,0.00,0.00,0.00),('5','107','701','225363',4342765,'1908','290',610294.36,610294.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','225363',4342766,'1909','290',482424.72,482424.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','225363',4342767,'1910','290',379334.55,379334.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','225363',4342768,'1911','290',1073698.19,1075195.38,1497.19,244041.97,0.00,0.00,0.00,0.00,0.00),('5','107','702','225363',4342769,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','225363',4342770,'1913','290',580269.68,581308.37,1038.69,169306.47,0.00,0.00,0.00,0.00,0.00),('5','107','702','225363',4342771,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','225363',4342772,'1915','290',233445.98,233445.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','225363',4342773,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','225363',4342774,'1917','290',975021.41,976974.06,1952.65,318281.95,0.00,0.00,0.00,0.00,0.00),('5','107','703','225363',4342775,'1918','290',139458.20,139458.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','225363',4342776,'1919','290',447776.24,447776.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','225363',4342777,'1920','290',97332.11,97332.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','225363',4342778,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','225363',4342779,'1922','290',81614.00,83641.68,2027.68,330511.84,0.00,0.00,0.00,0.00,0.00),('5','107','704','225363',4342780,'1923','290',721000.23,721000.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','225363',4342781,'1924','290',96788.40,98757.17,1968.77,320909.51,0.00,0.00,0.00,0.00,0.00),('5','107','705','225363',4342782,'1925','290',1542915.13,1546004.02,3088.89,503489.07,0.00,0.00,0.00,0.00,0.00),('5','107','705','225363',4342783,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','225363',4342784,'1927','290',456499.54,457474.05,974.51,158845.13,0.00,0.00,0.00,0.00,0.00),('5','107','705','225363',4342785,'1928','290',113440.79,113440.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','225363',4342786,'1929','291',3458162.16,3465498.20,7336.04,2164131.80,0.00,0.00,0.00,0.00,0.00),('5','107','706','225363',4342787,'1930','291',2353064.30,2361112.89,8048.59,2374334.05,0.00,0.00,0.00,0.00,0.00),('5','107','706','225363',4342788,'1931','291',3566358.35,3569435.24,3076.89,907682.55,0.00,0.00,0.00,0.00,0.00),('5','107','706','225363',4342789,'1932','291',3052516.60,3056908.23,4391.63,1295530.85,0.00,0.00,0.00,0.00,0.00),('5','107','706','225363',4342790,'1933','291',4071407.55,4076571.83,5164.28,1523462.60,0.00,0.00,0.00,0.00,0.00),('5','107','708','225363',4342791,'1934','291',1559144.96,1560634.93,1489.97,439541.15,0.00,0.00,0.00,0.00,0.00),('5','107','706','225363',4342792,'2898','291',2785457.32,2788188.95,2731.63,805830.85,0.00,0.00,0.00,0.00,0.00),('5','107','708','225363',4342793,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','225909',4352467,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','225909',4352468,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','225909',4352469,'1877','290',773604.54,773604.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','225909',4352470,'1878','290',176687.38,176687.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','225909',4352471,'1879','290',847041.07,848034.11,993.04,161865.52,0.00,0.00,0.00,0.00,0.00),('5','107','696','225909',4352472,'1880','290',104521.61,104521.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','225909',4352473,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','225909',4352474,'1882','290',1074905.88,1076852.15,1946.27,317242.01,0.00,0.00,0.00,0.00,0.00),('5','107','697','225909',4352475,'1883','290',527547.99,527547.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','225909',4352476,'1884','290',114676.55,114676.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','225909',4352477,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','225909',4352478,'1886','290',2059970.12,2066067.75,6097.63,993913.69,0.00,0.00,0.00,0.00,0.00),('5','107','697','225909',4352479,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','225909',4352480,'1888','290',154083.84,155247.55,1163.71,189684.73,0.00,0.00,0.00,0.00,0.00),('5','107','696','225909',4352481,'1889','290',2991511.10,2997144.19,5633.09,918193.67,0.00,0.00,0.00,0.00,0.00),('5','107','696','225909',4352482,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','225909',4352483,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','225909',4352484,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','225909',4352485,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','225909',4352486,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','225909',4352487,'1895','290',681458.80,682037.26,578.46,94288.98,0.00,0.00,0.00,0.00,0.00),('5','107','698','225909',4352488,'1896','290',252386.00,253399.77,1013.77,165244.51,0.00,0.00,0.00,0.00,0.00),('5','107','698','225909',4352489,'1897','290',409450.00,409450.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','225909',4352490,'1898','290',65028.38,65028.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','225909',4352491,'1899','290',1882786.14,1886885.27,4099.13,668158.19,0.00,0.00,0.00,0.00,0.00),('5','107','699','225909',4352492,'1900','290',410739.53,410739.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','225909',4352493,'1901','290',1037824.58,1037824.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','225909',4352494,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','225909',4352495,'1903','290',1066147.70,1066147.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','225909',4352496,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','225909',4352497,'1905','290',1480064.95,1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','225909',4352498,'1906','290',602415.90,602415.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','225909',4352499,'1907','290',1942325.34,1945487.37,3162.03,515410.89,0.00,0.00,0.00,0.00,0.00),('5','107','701','225909',4352500,'1908','290',610294.36,610294.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','225909',4352501,'1909','290',482424.72,482424.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','225909',4352502,'1910','290',379334.55,379334.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','225909',4352503,'1911','290',1075195.38,1075785.77,590.39,96233.57,0.00,0.00,0.00,0.00,0.00),('5','107','702','225909',4352504,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','225909',4352505,'1913','290',581308.37,581523.17,214.80,35012.40,0.00,0.00,0.00,0.00,0.00),('5','107','702','225909',4352506,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','225909',4352507,'1915','290',233445.98,233445.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','225909',4352508,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','225909',4352509,'1917','290',976974.06,978712.16,1738.10,283310.30,0.00,0.00,0.00,0.00,0.00),('5','107','703','225909',4352510,'1918','290',139458.20,139458.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','225909',4352511,'1919','290',447776.24,448104.20,327.96,53457.48,0.00,0.00,0.00,0.00,0.00),('5','107','703','225909',4352512,'1920','290',97332.11,97332.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','225909',4352513,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','225909',4352514,'1922','290',83641.68,85658.08,2016.40,328673.20,0.00,0.00,0.00,0.00,0.00),('5','107','704','225909',4352515,'1923','290',721000.23,721000.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','225909',4352516,'1924','290',98757.17,101068.41,2311.24,376732.12,0.00,0.00,0.00,0.00,0.00),('5','107','705','225909',4352517,'1925','290',1546004.02,1548858.31,2854.29,465249.27,0.00,0.00,0.00,0.00,0.00),('5','107','705','225909',4352518,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','225909',4352519,'1927','290',457474.05,457474.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','225909',4352520,'1928','290',113440.79,113440.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','225909',4352521,'1929','291',3465498.20,3472155.00,6656.80,1963756.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','225909',4352522,'1930','291',2361112.89,2366784.86,5671.97,1673231.15,0.00,0.00,0.00,0.00,0.00),('5','107','706','225909',4352523,'1931','291',3569435.24,3572337.79,2902.55,856252.25,0.00,0.00,0.00,0.00,0.00),('5','107','706','225909',4352524,'1932','291',3056908.23,3062265.15,5356.92,1580291.40,0.00,0.00,0.00,0.00,0.00),('5','107','706','225909',4352525,'1933','291',4076571.83,4080136.55,3564.72,1051592.40,0.00,0.00,0.00,0.00,0.00),('5','107','708','225909',4352526,'1934','291',1560634.93,1560784.93,150.00,44250.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','225909',4352527,'2898','291',2788188.95,2791399.03,3210.08,946973.60,0.00,0.00,0.00,0.00,0.00),('5','107','708','225909',4352528,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','226039',4354475,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','226039',4354476,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','226039',4354477,'1877','290',773604.54,774401.44,796.90,129894.70,0.00,0.00,0.00,0.00,0.00),('5','107','696','226039',4354478,'1878','290',176687.38,176687.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','226039',4354479,'1879','290',848034.11,849076.89,1042.78,169973.14,0.00,0.00,0.00,0.00,0.00),('5','107','696','226039',4354480,'1880','290',104521.61,104805.80,284.19,46322.97,0.00,0.00,0.00,0.00,0.00),('5','107','697','226039',4354481,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','226039',4354482,'1882','290',1076852.15,1076852.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','226039',4354483,'1883','290',527547.99,528186.83,638.84,104130.92,0.00,0.00,0.00,0.00,0.00),('5','107','697','226039',4354484,'1884','290',114676.55,115114.05,437.50,71312.50,0.00,0.00,0.00,0.00,0.00),('5','107','697','226039',4354485,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','226039',4354486,'1886','290',2066067.75,2071227.15,5159.40,840982.20,0.00,0.00,0.00,0.00,0.00),('5','107','697','226039',4354487,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','226039',4354488,'1888','290',155247.55,158485.68,3238.13,527815.19,0.00,0.00,0.00,0.00,0.00),('5','107','696','226039',4354489,'1889','290',2997144.19,3003774.80,6630.61,1080789.43,0.00,0.00,0.00,0.00,0.00),('5','107','696','226039',4354490,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','226039',4354491,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','226039',4354492,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','226039',4354493,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','226039',4354494,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','226039',4354495,'1895','290',682037.26,682933.40,896.14,146070.82,0.00,0.00,0.00,0.00,0.00),('5','107','698','226039',4354496,'1896','290',253399.77,253604.72,204.95,33406.85,0.00,0.00,0.00,0.00,0.00),('5','107','698','226039',4354497,'1897','290',409450.00,409450.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','226039',4354498,'1898','290',65028.38,65028.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','226039',4354499,'1899','290',1886885.27,1889223.17,2337.90,381077.70,0.00,0.00,0.00,0.00,0.00),('5','107','699','226039',4354500,'1900','290',410739.53,410739.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','226039',4354501,'1901','290',1037824.58,1040035.76,2211.18,360422.34,0.00,0.00,0.00,0.00,0.00),('5','107','699','226039',4354502,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','226039',4354503,'1903','290',1066147.70,1066147.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','226039',4354504,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','226039',4354505,'1905','290',1480064.95,1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','226039',4354506,'1906','290',602415.90,602415.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','226039',4354507,'1907','290',1945487.37,1948170.57,2683.20,437361.60,0.00,0.00,0.00,0.00,0.00),('5','107','701','226039',4354508,'1908','290',610294.36,610294.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','226039',4354509,'1909','290',482424.72,482869.42,444.70,72486.10,0.00,0.00,0.00,0.00,0.00),('5','107','701','226039',4354510,'1910','290',379334.55,379334.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','226039',4354511,'1911','290',1075785.77,1075785.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','226039',4354512,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','226039',4354513,'1913','290',581523.17,581523.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','226039',4354514,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','226039',4354515,'1915','290',233445.98,233445.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','226039',4354516,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','226039',4354517,'1917','290',978712.16,979644.26,932.10,151932.30,0.00,0.00,0.00,0.00,0.00),('5','107','703','226039',4354518,'1918','290',139458.20,139458.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','226039',4354519,'1919','290',448104.20,450807.70,2703.50,440670.50,0.00,0.00,0.00,0.00,0.00),('5','107','703','226039',4354520,'1920','290',97332.11,97332.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','226039',4354521,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','226039',4354522,'1922','290',85658.08,86995.97,1337.89,218076.07,0.00,0.00,0.00,0.00,0.00),('5','107','704','226039',4354523,'1923','290',721000.23,721000.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','226039',4354524,'1924','290',101068.41,102475.59,1407.18,229370.34,0.00,0.00,0.00,0.00,0.00),('5','107','705','226039',4354525,'1925','290',1548858.31,1552127.03,3268.72,532801.36,0.00,0.00,0.00,0.00,0.00),('5','107','705','226039',4354526,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','226039',4354527,'1927','290',457474.05,457991.45,517.40,84336.20,0.00,0.00,0.00,0.00,0.00),('5','107','705','226039',4354528,'1928','290',113440.79,113440.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','226039',4354529,'1929','291',3472155.00,3477433.08,5278.08,1557033.60,0.00,0.00,0.00,0.00,0.00),('5','107','706','226039',4354530,'1930','291',2366784.86,2372793.23,6008.37,1772469.15,0.00,0.00,0.00,0.00,0.00),('5','107','706','226039',4354531,'1931','291',3572337.79,3577574.13,5236.34,1544720.30,0.00,0.00,0.00,0.00,0.00),('5','107','706','226039',4354532,'1932','291',3062265.15,3066892.56,4627.41,1365085.95,0.00,0.00,0.00,0.00,0.00),('5','107','706','226039',4354533,'1933','291',4080136.55,4087313.51,7176.96,2117203.20,0.00,0.00,0.00,0.00,0.00),('5','107','708','226039',4354534,'1934','291',1560784.93,1566419.91,5634.98,1662319.10,0.00,0.00,0.00,0.00,0.00),('5','107','706','226039',4354535,'2898','291',2791399.03,2794875.76,3476.73,1025635.35,0.00,0.00,0.00,0.00,0.00),('5','107','708','226039',4354536,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','226080',4355282,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','226080',4355283,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','226080',4355284,'1877','290',774401.44,774401.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','226080',4355285,'1878','290',176687.38,177556.35,868.97,141642.11,0.00,0.00,0.00,0.00,0.00),('5','107','696','226080',4355286,'1879','290',849076.89,849663.45,586.56,95609.28,0.00,0.00,0.00,0.00,0.00),('5','107','696','226080',4355287,'1880','290',104805.80,104805.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','226080',4355288,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','226080',4355289,'1882','290',1076852.15,1076852.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','226080',4355290,'1883','290',528186.83,529263.56,1076.73,175506.99,0.00,0.00,0.00,0.00,0.00),('5','107','697','226080',4355291,'1884','290',115114.05,115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','226080',4355292,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','226080',4355293,'1886','290',2071227.15,2073017.82,1790.67,291879.21,0.00,0.00,0.00,0.00,0.00),('5','107','697','226080',4355294,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','226080',4355295,'1888','290',158485.68,159817.86,1332.18,217145.34,0.00,0.00,0.00,0.00,0.00),('5','107','696','226080',4355296,'1889','290',3003774.80,3009126.84,5352.04,872382.52,0.00,0.00,0.00,0.00,0.00),('5','107','696','226080',4355297,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','226080',4355298,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','226080',4355299,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','226080',4355300,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','226080',4355301,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','226080',4355302,'1895','290',682933.40,682933.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','226080',4355303,'1896','290',253604.72,255123.33,1518.61,247533.43,0.00,0.00,0.00,0.00,0.00),('5','107','698','226080',4355304,'1897','290',409450.00,409751.20,301.20,49095.60,0.00,0.00,0.00,0.00,0.00),('5','107','698','226080',4355305,'1898','290',65028.38,65028.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','226080',4355306,'1899','290',1889223.17,1892377.05,3153.88,514082.44,0.00,0.00,0.00,0.00,0.00),('5','107','699','226080',4355307,'1900','290',410739.53,410739.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','226080',4355308,'1901','290',1040035.76,1042818.35,2782.59,453562.17,0.00,0.00,0.00,0.00,0.00),('5','107','699','226080',4355309,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','226080',4355310,'1903','290',1066147.70,1067792.69,1644.99,268133.37,0.00,0.00,0.00,0.00,0.00),('5','107','700','226080',4355311,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','226080',4355312,'1905','290',1480064.95,1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','226080',4355313,'1906','290',602415.90,602415.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','226080',4355314,'1907','290',1948170.57,1949649.27,1478.70,241028.10,0.00,0.00,0.00,0.00,0.00),('5','107','701','226080',4355315,'1908','290',610294.36,610294.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','226080',4355316,'1909','290',482869.42,482869.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','226080',4355317,'1910','290',379334.55,379334.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','226080',4355318,'1911','290',1075785.77,1076719.02,933.25,152119.75,0.00,0.00,0.00,0.00,0.00),('5','107','702','226080',4355319,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','226080',4355320,'1913','290',581523.17,582444.32,921.15,150147.45,0.00,0.00,0.00,0.00,0.00),('5','107','702','226080',4355321,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','226080',4355322,'1915','290',233445.98,233812.36,366.38,59719.94,0.00,0.00,0.00,0.00,0.00),('5','107','702','226080',4355323,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','226080',4355324,'1917','290',979644.26,983403.30,3759.04,612723.52,0.00,0.00,0.00,0.00,0.00),('5','107','703','226080',4355325,'1918','290',139458.20,139458.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','226080',4355326,'1919','290',450807.70,451639.79,832.09,135630.67,0.00,0.00,0.00,0.00,0.00),('5','107','703','226080',4355327,'1920','290',97332.11,97332.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','226080',4355328,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','226080',4355329,'1922','290',86995.97,86995.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','226080',4355330,'1923','290',721000.23,721000.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','226080',4355331,'1924','290',102475.59,102990.76,515.17,83972.71,0.00,0.00,0.00,0.00,0.00),('5','107','705','226080',4355332,'1925','290',1552127.03,1556258.09,4131.06,673362.78,0.00,0.00,0.00,0.00,0.00),('5','107','705','226080',4355333,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','226080',4355334,'1927','290',457991.45,459949.80,1958.35,319211.05,0.00,0.00,0.00,0.00,0.00),('5','107','705','226080',4355335,'1928','290',113440.79,113440.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','226080',4355336,'1929','291',3477433.08,3485617.29,8184.21,2414341.95,0.00,0.00,0.00,0.00,0.00),('5','107','706','226080',4355337,'1930','291',2372793.23,2378871.26,6078.03,1793018.85,0.00,0.00,0.00,0.00,0.00),('5','107','706','226080',4355338,'1931','291',3577574.13,3585210.28,7636.15,2252664.25,0.00,0.00,0.00,0.00,0.00),('5','107','706','226080',4355339,'1932','291',3066892.56,3069293.92,2401.36,708401.20,0.00,0.00,0.00,0.00,0.00),('5','107','706','226080',4355340,'1933','291',4087313.51,4093042.28,5728.77,1689987.15,0.00,0.00,0.00,0.00,0.00),('5','107','708','226080',4355341,'1934','291',1566419.91,1567772.50,1352.59,399014.05,0.00,0.00,0.00,0.00,0.00),('5','107','706','226080',4355342,'2898','291',2794875.76,2800393.02,5517.26,1627591.70,0.00,0.00,0.00,0.00,0.00),('5','107','708','226080',4355343,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','226502',4362878,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','226502',4362879,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','226502',4362880,'1877','290',774401.44,774481.16,79.72,12994.36,0.00,0.00,0.00,0.00,0.00),('5','107','696','226502',4362881,'1878','290',177556.35,177556.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','226502',4362882,'1879','290',849663.45,849700.55,37.10,6047.30,0.00,0.00,0.00,0.00,0.00),('5','107','696','226502',4362883,'1880','290',104805.80,104805.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','226502',4362884,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','226502',4362885,'1882','290',1076852.15,1076852.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','226502',4362886,'1883','290',529263.56,529263.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','226502',4362887,'1884','290',115114.05,115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','226502',4362888,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','226502',4362889,'1886','290',2073017.82,2073017.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','226502',4362890,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','226502',4362891,'1888','290',159817.86,159817.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','226502',4362892,'1889','290',3009126.84,3009478.15,351.31,57263.53,0.00,0.00,0.00,0.00,0.00),('5','107','696','226502',4362893,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','226502',4362894,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','226502',4362895,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','226502',4362896,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','226502',4362897,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','226502',4362898,'1895','290',682933.40,683617.25,683.85,111467.55,0.00,0.00,0.00,0.00,0.00),('5','107','698','226502',4362899,'1896','290',255123.33,255809.26,685.93,111806.59,0.00,0.00,0.00,0.00,0.00),('5','107','698','226502',4362900,'1897','290',409751.20,409751.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','226502',4362901,'1898','290',65028.38,65028.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','226502',4362902,'1899','290',1892377.05,1894692.50,2315.45,377418.35,0.00,0.00,0.00,0.00,0.00),('5','107','699','226502',4362903,'1900','290',410739.53,410739.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','226502',4362904,'1901','290',1042818.35,1045338.07,2519.72,410714.36,0.00,0.00,0.00,0.00,0.00),('5','107','699','226502',4362905,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','226502',4362906,'1903','290',1067792.69,1072026.39,4233.70,690093.10,0.00,0.00,0.00,0.00,0.00),('5','107','700','226502',4362907,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','226502',4362908,'1905','290',1480064.95,1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','226502',4362909,'1906','290',602415.90,604941.76,2525.86,411715.18,0.00,0.00,0.00,0.00,0.00),('5','107','701','226502',4362910,'1907','290',1949649.27,1952660.48,3011.21,490827.23,0.00,0.00,0.00,0.00,0.00),('5','107','701','226502',4362911,'1908','290',610294.36,610294.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','226502',4362912,'1909','290',482869.42,487528.15,4658.73,759372.99,0.00,0.00,0.00,0.00,0.00),('5','107','701','226502',4362913,'1910','290',379334.55,379334.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','226502',4362914,'1911','290',1076719.02,1077398.07,679.05,110685.15,0.00,0.00,0.00,0.00,0.00),('5','107','702','226502',4362915,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','226502',4362916,'1913','290',582444.32,582685.69,241.37,39343.31,0.00,0.00,0.00,0.00,0.00),('5','107','702','226502',4362917,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','226502',4362918,'1915','290',233812.36,233812.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','226502',4362919,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','226502',4362920,'1917','290',983403.30,985210.88,1807.58,294635.54,0.00,0.00,0.00,0.00,0.00),('5','107','703','226502',4362921,'1918','290',139458.20,139458.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','226502',4362922,'1919','290',451639.79,451639.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','226502',4362923,'1920','290',97332.11,97332.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','226502',4362924,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','226502',4362925,'1922','290',86995.97,87292.00,296.03,48252.89,0.00,0.00,0.00,0.00,0.00),('5','107','704','226502',4362926,'1923','290',721000.23,721000.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','226502',4362927,'1924','290',102990.76,105443.73,2452.97,399834.11,0.00,0.00,0.00,0.00,0.00),('5','107','705','226502',4362928,'1925','290',1556258.09,1558747.83,2489.74,405827.62,0.00,0.00,0.00,0.00,0.00),('5','107','705','226502',4362929,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','226502',4362930,'1927','290',459949.80,460934.94,985.14,160577.82,0.00,0.00,0.00,0.00,0.00),('5','107','705','226502',4362931,'1928','290',113440.79,113440.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','226502',4362932,'1929','291',3485617.29,3494145.11,8527.82,2515706.90,0.00,0.00,0.00,0.00,0.00),('5','107','706','226502',4362933,'1930','291',2378871.26,2383244.43,4373.17,1290085.15,0.00,0.00,0.00,0.00,0.00),('5','107','706','226502',4362934,'1931','291',3585210.28,3590910.00,5699.72,1681417.40,0.00,0.00,0.00,0.00,0.00),('5','107','706','226502',4362935,'1932','291',3069293.92,3071878.50,2584.58,762451.10,0.00,0.00,0.00,0.00,0.00),('5','107','706','226502',4362936,'1933','291',4093042.28,4099883.89,6841.61,2018274.95,0.00,0.00,0.00,0.00,0.00),('5','107','708','226502',4362937,'1934','291',1567772.50,1568121.12,348.62,102842.90,0.00,0.00,0.00,0.00,0.00),('5','107','706','226502',4362938,'2898','291',2800393.02,2804067.25,3674.23,1083897.85,0.00,0.00,0.00,0.00,0.00),('5','107','708','226502',4362939,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','226797',4368220,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','226797',4368221,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','226797',4368222,'1877','290',774481.16,774481.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','226797',4368223,'1878','290',177556.35,177556.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','226797',4368224,'1879','290',849700.55,849700.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','226797',4368225,'1880','290',104805.80,104805.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','226797',4368226,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','226797',4368227,'1882','290',1076852.15,1076852.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','226797',4368228,'1883','290',529263.56,529263.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','226797',4368229,'1884','290',115114.05,115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','226797',4368230,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','226797',4368231,'1886','290',2073017.82,2073017.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','226797',4368232,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','226797',4368233,'1888','290',159817.86,159817.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','226797',4368234,'1889','290',3009478.15,3009478.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','226797',4368235,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','226797',4368236,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','226797',4368237,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','226797',4368238,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','226797',4368239,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','226797',4368240,'1895','290',683617.25,685587.72,1970.47,321186.61,0.00,0.00,0.00,0.00,0.00),('5','107','698','226797',4368241,'1896','290',255809.26,256352.59,543.33,88562.79,0.00,0.00,0.00,0.00,0.00),('5','107','698','226797',4368242,'1897','290',409751.20,409965.50,214.30,34930.90,0.00,0.00,0.00,0.00,0.00),('5','107','698','226797',4368243,'1898','290',65028.38,65028.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','226797',4368244,'1899','290',1894692.50,1897117.40,2424.90,395258.70,0.00,0.00,0.00,0.00,0.00),('5','107','699','226797',4368245,'1900','290',410739.53,410739.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','226797',4368246,'1901','290',1045338.07,1047927.98,2589.91,422155.33,0.00,0.00,0.00,0.00,0.00),('5','107','699','226797',4368247,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','226797',4368248,'1903','290',1072026.39,1075687.91,3661.52,596827.76,0.00,0.00,0.00,0.00,0.00),('5','107','700','226797',4368249,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','226797',4368250,'1905','290',1480064.95,1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','226797',4368251,'1906','290',604941.76,607117.92,2176.16,354714.08,0.00,0.00,0.00,0.00,0.00),('5','107','701','226797',4368252,'1907','290',1952660.48,1957590.95,4930.47,803666.61,0.00,0.00,0.00,0.00,0.00),('5','107','701','226797',4368253,'1908','290',610294.36,610294.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','226797',4368254,'1909','290',487528.15,491578.76,4050.61,660249.43,0.00,0.00,0.00,0.00,0.00),('5','107','701','226797',4368255,'1910','290',379334.55,379334.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','226797',4368256,'1911','290',1077398.07,1078315.40,917.33,149524.79,0.00,0.00,0.00,0.00,0.00),('5','107','702','226797',4368257,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','226797',4368258,'1913','290',582685.69,583771.32,1085.63,176957.69,0.00,0.00,0.00,0.00,0.00),('5','107','702','226797',4368259,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','226797',4368260,'1915','290',233812.36,233813.13,0.77,125.51,0.00,0.00,0.00,0.00,0.00),('5','107','702','226797',4368261,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','226797',4368262,'1917','290',985210.88,987082.78,1871.90,305119.70,0.00,0.00,0.00,0.00,0.00),('5','107','703','226797',4368263,'1918','290',139458.20,139458.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','226797',4368264,'1919','290',451639.79,453556.78,1916.99,312469.37,0.00,0.00,0.00,0.00,0.00),('5','107','703','226797',4368265,'1920','290',97332.11,97332.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','226797',4368266,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','226797',4368267,'1922','290',87292.00,87651.26,359.26,58559.38,0.00,0.00,0.00,0.00,0.00),('5','107','704','226797',4368268,'1923','290',721000.23,721000.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','226797',4368269,'1924','290',105443.73,108434.84,2991.11,487550.93,0.00,0.00,0.00,0.00,0.00),('5','107','705','226797',4368270,'1925','290',1558747.83,1562225.22,3477.39,566814.57,0.00,0.00,0.00,0.00,0.00),('5','107','705','226797',4368271,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','226797',4368272,'1927','290',460934.94,463258.49,2323.55,378738.65,0.00,0.00,0.00,0.00,0.00),('5','107','705','226797',4368273,'1928','290',113440.79,113440.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','226797',4368274,'1929','291',3494145.11,3499908.96,5763.85,1700335.75,0.00,0.00,0.00,0.00,0.00),('5','107','706','226797',4368275,'1930','291',2383244.43,2387751.52,4507.09,1329591.55,0.00,0.00,0.00,0.00,0.00),('5','107','706','226797',4368276,'1931','291',3590910.00,3596154.50,5244.50,1547127.50,0.00,0.00,0.00,0.00,0.00),('5','107','706','226797',4368277,'1932','291',3071878.50,3075908.84,4030.34,1188950.30,0.00,0.00,0.00,0.00,0.00),('5','107','706','226797',4368278,'1933','291',4099883.89,4104713.22,4829.33,1424652.35,0.00,0.00,0.00,0.00,0.00),('5','107','708','226797',4368279,'1934','291',1568121.12,1569029.96,908.84,268107.80,0.00,0.00,0.00,0.00,0.00),('5','107','706','226797',4368280,'2898','291',2804067.25,2806853.46,2786.21,821931.95,0.00,0.00,0.00,0.00,0.00),('5','107','708','226797',4368281,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','226808',4368492,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','226808',4368493,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','226808',4368494,'1877','290',774481.16,774481.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','226808',4368495,'1878','290',177556.35,177556.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','226808',4368496,'1879','290',849700.55,849700.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','226808',4368497,'1880','290',104805.80,104805.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','226808',4368498,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','226808',4368499,'1882','290',1076852.15,1076852.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','226808',4368500,'1883','290',529263.56,529263.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','226808',4368501,'1884','290',115114.05,115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','226808',4368502,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','226808',4368503,'1886','290',2073017.82,2073017.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','226808',4368504,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','226808',4368505,'1888','290',159817.86,159817.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','226808',4368506,'1889','290',3009478.15,3009478.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','226808',4368507,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','226808',4368508,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','226808',4368509,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','226808',4368510,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','226808',4368511,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','226808',4368512,'1895','290',685587.72,687030.65,1442.93,235197.59,0.00,0.00,0.00,0.00,0.00),('5','107','698','226808',4368513,'1896','290',256352.59,258149.78,1797.19,292941.97,0.00,0.00,0.00,0.00,0.00),('5','107','698','226808',4368514,'1897','290',409965.50,409965.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','226808',4368515,'1898','290',65028.38,65028.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','226808',4368516,'1899','290',1897117.40,1899805.58,2688.18,438173.34,0.00,0.00,0.00,0.00,0.00),('5','107','699','226808',4368517,'1900','290',410739.53,410739.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','226808',4368518,'1901','290',1047927.98,1051594.68,3666.70,597672.10,0.00,0.00,0.00,0.00,0.00),('5','107','699','226808',4368519,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','226808',4368520,'1903','290',1075687.91,1078329.78,2641.87,430624.81,0.00,0.00,0.00,0.00,0.00),('5','107','700','226808',4368521,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','226808',4368522,'1905','290',1480064.95,1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','226808',4368523,'1906','290',607117.92,611914.83,4796.91,781896.33,0.00,0.00,0.00,0.00,0.00),('5','107','701','226808',4368524,'1907','290',1957590.95,1963376.19,5785.24,942994.12,0.00,0.00,0.00,0.00,0.00),('5','107','701','226808',4368525,'1908','290',610294.36,610294.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','226808',4368526,'1909','290',491578.76,493150.42,1571.66,256180.58,0.00,0.00,0.00,0.00,0.00),('5','107','701','226808',4368527,'1910','290',379334.55,379334.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','226808',4368528,'1911','290',1078315.40,1079392.79,1077.39,175614.57,0.00,0.00,0.00,0.00,0.00),('5','107','702','226808',4368529,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','226808',4368530,'1913','290',583771.32,585377.22,1605.90,261761.70,0.00,0.00,0.00,0.00,0.00),('5','107','702','226808',4368531,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','226808',4368532,'1915','290',233813.13,233813.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','226808',4368533,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','226808',4368534,'1917','290',987082.78,987631.29,548.51,89407.13,0.00,0.00,0.00,0.00,0.00),('5','107','703','226808',4368535,'1918','290',139458.20,139458.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','226808',4368536,'1919','290',453556.78,453790.02,233.24,38018.12,0.00,0.00,0.00,0.00,0.00),('5','107','703','226808',4368537,'1920','290',97332.11,97332.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','226808',4368538,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','226808',4368539,'1922','290',87651.26,89853.87,2202.61,359025.43,0.00,0.00,0.00,0.00,0.00),('5','107','704','226808',4368540,'1923','290',721000.23,721000.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','226808',4368541,'1924','290',108434.84,110324.44,1889.60,308004.80,0.00,0.00,0.00,0.00,0.00),('5','107','705','226808',4368542,'1925','290',1562225.22,1564088.86,1863.64,303773.32,0.00,0.00,0.00,0.00,0.00),('5','107','705','226808',4368543,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','226808',4368544,'1927','290',463258.49,464434.53,1176.04,191694.52,0.00,0.00,0.00,0.00,0.00),('5','107','705','226808',4368545,'1928','290',113440.79,113440.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','226808',4368546,'1929','291',3499908.96,3507581.78,7672.82,2263481.90,0.00,0.00,0.00,0.00,0.00),('5','107','706','226808',4368547,'1930','291',2387751.52,2390010.63,2259.11,666437.45,0.00,0.00,0.00,0.00,0.00),('5','107','706','226808',4368548,'1931','291',3596154.50,3600459.35,4304.85,1269930.75,0.00,0.00,0.00,0.00,0.00),('5','107','706','226808',4368549,'1932','291',3075908.84,3080023.50,4114.66,1213824.70,0.00,0.00,0.00,0.00,0.00),('5','107','706','226808',4368550,'1933','291',4104713.22,4109870.37,5157.15,1521359.25,0.00,0.00,0.00,0.00,0.00),('5','107','708','226808',4368551,'1934','291',1569029.96,1571135.63,2105.67,621172.65,0.00,0.00,0.00,0.00,0.00),('5','107','706','226808',4368552,'2898','291',2806853.46,2809508.35,2654.89,783192.55,0.00,0.00,0.00,0.00,0.00),('5','107','708','226808',4368553,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227140',4374553,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227140',4374554,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227140',4374555,'1877','290',774481.16,774481.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227140',4374556,'1878','290',177556.35,177556.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227140',4374557,'1879','290',849700.55,849700.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227140',4374558,'1880','290',104805.80,104805.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227140',4374559,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227140',4374560,'1882','290',1076852.15,1076852.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227140',4374561,'1883','290',529263.56,529263.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227140',4374562,'1884','290',115114.05,115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227140',4374563,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227140',4374564,'1886','290',2073017.82,2073017.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227140',4374565,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227140',4374566,'1888','290',159817.86,159817.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227140',4374567,'1889','290',3009478.15,3009478.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227140',4374568,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227140',4374569,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227140',4374570,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','227140',4374571,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','227140',4374572,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','227140',4374573,'1895','290',687030.65,687627.39,596.74,97268.62,0.00,0.00,0.00,0.00,0.00),('5','107','698','227140',4374574,'1896','290',258149.78,260753.08,2603.30,424337.90,0.00,0.00,0.00,0.00,0.00),('5','107','698','227140',4374575,'1897','290',409965.50,411787.85,1822.35,297043.05,0.00,0.00,0.00,0.00,0.00),('5','107','698','227140',4374576,'1898','290',65028.38,65429.00,400.62,65301.06,0.00,0.00,0.00,0.00,0.00),('5','107','699','227140',4374577,'1899','290',1899805.58,1902524.00,2718.42,443102.46,0.00,0.00,0.00,0.00,0.00),('5','107','699','227140',4374578,'1900','290',410739.53,410739.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','227140',4374579,'1901','290',1051594.68,1055020.70,3426.02,558441.26,0.00,0.00,0.00,0.00,0.00),('5','107','699','227140',4374580,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','227140',4374581,'1903','290',1078329.78,1081169.23,2839.45,462830.35,0.00,0.00,0.00,0.00,0.00),('5','107','700','227140',4374582,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','227140',4374583,'1905','290',1480064.95,1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','227140',4374584,'1906','290',611914.83,618209.58,6294.75,1026044.25,0.00,0.00,0.00,0.00,0.00),('5','107','701','227140',4374585,'1907','290',1963376.19,1967757.20,4381.01,714104.63,0.00,0.00,0.00,0.00,0.00),('5','107','701','227140',4374586,'1908','290',610294.36,610294.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','227140',4374587,'1909','290',493150.42,498099.73,4949.31,806737.53,0.00,0.00,0.00,0.00,0.00),('5','107','701','227140',4374588,'1910','290',379334.55,379334.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','227140',4374589,'1911','290',1079392.79,1080569.08,1176.29,191735.27,0.00,0.00,0.00,0.00,0.00),('5','107','702','227140',4374590,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','227140',4374591,'1913','290',585377.22,586060.56,683.34,111384.42,0.00,0.00,0.00,0.00,0.00),('5','107','702','227140',4374592,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','227140',4374593,'1915','290',233813.13,234387.65,574.52,93646.76,0.00,0.00,0.00,0.00,0.00),('5','107','702','227140',4374594,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','227140',4374595,'1917','290',987631.29,988747.11,1115.82,181878.66,0.00,0.00,0.00,0.00,0.00),('5','107','703','227140',4374596,'1918','290',139458.20,139458.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','227140',4374597,'1919','290',453790.02,455418.60,1628.58,265458.54,0.00,0.00,0.00,0.00,0.00),('5','107','703','227140',4374598,'1920','290',97332.11,97332.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','227140',4374599,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','227140',4374600,'1922','290',89853.87,90705.59,851.72,138830.36,0.00,0.00,0.00,0.00,0.00),('5','107','704','227140',4374601,'1923','290',721000.23,721000.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','227140',4374602,'1924','290',110324.44,112675.78,2351.34,383268.42,0.00,0.00,0.00,0.00,0.00),('5','107','705','227140',4374603,'1925','290',1564088.86,1568927.00,4838.14,788616.82,0.00,0.00,0.00,0.00,0.00),('5','107','705','227140',4374604,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','227140',4374605,'1927','290',464434.53,465922.60,1488.07,242555.41,0.00,0.00,0.00,0.00,0.00),('5','107','705','227140',4374606,'1928','290',113440.79,113440.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','227140',4374607,'1929','291',3507581.78,3514118.92,6537.14,1928456.30,0.00,0.00,0.00,0.00,0.00),('5','107','706','227140',4374608,'1930','291',2390010.63,2398821.28,8810.65,2599141.75,0.00,0.00,0.00,0.00,0.00),('5','107','706','227140',4374609,'1931','291',3600459.35,3606639.04,6179.69,1823008.55,0.00,0.00,0.00,0.00,0.00),('5','107','706','227140',4374610,'1932','291',3080023.50,3084573.68,4550.18,1342303.10,0.00,0.00,0.00,0.00,0.00),('5','107','706','227140',4374611,'1933','291',4109870.37,4120251.68,10381.31,3062486.45,0.00,0.00,0.00,0.00,0.00),('5','107','708','227140',4374612,'1934','291',1571135.63,1575553.10,4417.47,1303153.65,0.00,0.00,0.00,0.00,0.00),('5','107','706','227140',4374613,'2898','291',2809508.35,2810016.57,508.22,149924.90,0.00,0.00,0.00,0.00,0.00),('5','107','708','227140',4374614,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227333',4377893,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227333',4377894,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227333',4377895,'1877','290',774481.16,774481.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227333',4377896,'1878','290',177556.35,177556.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227333',4377897,'1879','290',849700.55,849700.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227333',4377898,'1880','290',104805.80,104805.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227333',4377899,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227333',4377900,'1882','290',1076852.15,1078099.20,1247.05,203269.15,0.00,0.00,0.00,0.00,0.00),('5','107','697','227333',4377901,'1883','290',529263.56,529263.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227333',4377902,'1884','290',115114.05,115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227333',4377903,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227333',4377904,'1886','290',2073017.82,2078714.50,5696.68,928558.84,0.00,0.00,0.00,0.00,0.00),('5','107','697','227333',4377905,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227333',4377906,'1888','290',159817.86,159817.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227333',4377907,'1889','290',3009478.15,3009478.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227333',4377908,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227333',4377909,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227333',4377910,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','227333',4377911,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','227333',4377912,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','227333',4377913,'1895','290',687627.39,687627.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','227333',4377914,'1896','290',260753.08,264132.10,3379.02,550780.26,0.00,0.00,0.00,0.00,0.00),('5','107','698','227333',4377915,'1897','290',411787.85,414417.00,2629.15,428551.45,0.00,0.00,0.00,0.00,0.00),('5','107','698','227333',4377916,'1898','290',65429.00,65429.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','227333',4377917,'1899','290',1902524.00,1906647.76,4123.76,672172.88,0.00,0.00,0.00,0.00,0.00),('5','107','699','227333',4377918,'1900','290',410739.53,410739.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','227333',4377919,'1901','290',1055020.70,1055926.00,905.30,147563.90,0.00,0.00,0.00,0.00,0.00),('5','107','699','227333',4377920,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','227333',4377921,'1903','290',1081169.23,1087079.22,5909.99,963328.37,0.00,0.00,0.00,0.00,0.00),('5','107','700','227333',4377922,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','227333',4377923,'1905','290',1480064.95,1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','227333',4377924,'1906','290',618209.58,618209.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','227333',4377925,'1907','290',1967757.20,1967757.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','227333',4377926,'1908','290',610294.36,610294.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','227333',4377927,'1909','290',498099.73,498099.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','227333',4377928,'1910','290',379334.55,379334.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','227333',4377929,'1911','290',1080569.08,1081636.73,1067.65,174026.95,0.00,0.00,0.00,0.00,0.00),('5','107','702','227333',4377930,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','227333',4377931,'1913','290',586060.56,586060.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','227333',4377932,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','227333',4377933,'1915','290',234387.65,234387.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','227333',4377934,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','227333',4377935,'1917','290',988747.11,991287.76,2540.65,414125.95,0.00,0.00,0.00,0.00,0.00),('5','107','703','227333',4377936,'1918','290',139458.20,139458.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','227333',4377937,'1919','290',455418.60,457929.74,2511.14,409315.82,0.00,0.00,0.00,0.00,0.00),('5','107','703','227333',4377938,'1920','290',97332.11,97332.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','227333',4377939,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','227333',4377940,'1922','290',90705.59,90705.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','227333',4377941,'1923','290',721000.23,721000.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','227333',4377942,'1924','290',112675.78,117343.20,4667.42,760789.46,0.00,0.00,0.00,0.00,0.00),('5','107','705','227333',4377943,'1925','290',1568927.00,1573354.52,4427.52,721685.76,0.00,0.00,0.00,0.00,0.00),('5','107','705','227333',4377944,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','227333',4377945,'1927','290',465922.60,465922.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','227333',4377946,'1928','290',113440.79,113440.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','227333',4377947,'1929','291',3514118.92,3519382.30,5263.38,1552697.10,0.00,0.00,0.00,0.00,0.00),('5','107','706','227333',4377948,'1930','291',2398821.28,2404864.78,6043.50,1782832.50,0.00,0.00,0.00,0.00,0.00),('5','107','706','227333',4377949,'1931','291',3606639.04,3610337.17,3698.13,1090948.35,0.00,0.00,0.00,0.00,0.00),('5','107','706','227333',4377950,'1932','291',3084573.68,3088822.00,4248.32,1253254.40,0.00,0.00,0.00,0.00,0.00),('5','107','706','227333',4377951,'1933','291',4120251.68,4127415.38,7163.70,2113291.50,0.00,0.00,0.00,0.00,0.00),('5','107','708','227333',4377952,'1934','291',1575553.10,1575553.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','227333',4377953,'2898','291',2810016.57,2813095.75,3079.18,908358.10,0.00,0.00,0.00,0.00,0.00),('5','107','708','227333',4377954,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227637',4382916,'1875','290',1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227637',4382917,'1876','290',1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227637',4382918,'1877','290',774481.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227637',4382919,'1878','290',177556.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227637',4382920,'1879','290',849700.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227637',4382921,'1880','290',104805.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227637',4382922,'1881','290',1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227637',4382923,'1882','290',1078099.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227637',4382924,'1883','290',529263.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227637',4382925,'1884','290',115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227637',4382926,'1885','290',1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227637',4382927,'1886','290',2078714.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227637',4382928,'1887','290',205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227637',4382929,'1888','290',159817.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227637',4382930,'1889','290',3009478.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227637',4382931,'1890','290',682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227637',4382932,'1891','290',1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227637',4382933,'1892','290',1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','227637',4382934,'1893','290',1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','227637',4382935,'1894','290',1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','227637',4382936,'1895','290',687627.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','227637',4382937,'1896','290',264132.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','227637',4382938,'1897','290',414417.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','227637',4382939,'1898','290',65429.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','227637',4382940,'1899','290',1906647.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','227637',4382941,'1900','290',410739.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','227637',4382942,'1901','290',1055926.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','227637',4382943,'1902','290',36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','227637',4382944,'1903','290',1087079.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','227637',4382945,'1904','290',1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','227637',4382946,'1905','290',1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','227637',4382947,'1906','290',618209.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','227637',4382948,'1907','290',1967757.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','227637',4382949,'1908','290',610294.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','227637',4382950,'1909','290',498099.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','227637',4382951,'1910','290',379334.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','227637',4382952,'1911','290',1081636.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','227637',4382953,'1912','290',196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','227637',4382954,'1913','290',586060.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','227637',4382955,'1914','290',64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','227637',4382956,'1915','290',234387.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','227637',4382957,'1916','290',22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','227637',4382958,'1917','290',991287.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','227637',4382959,'1918','290',139458.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','227637',4382960,'1919','290',457929.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','227637',4382961,'1920','290',97332.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','227637',4382962,'1921','290',922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','227637',4382963,'1922','290',90705.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','227637',4382964,'1923','290',721000.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','227637',4382965,'1924','290',117343.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','227637',4382966,'1925','290',1573354.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','227637',4382967,'1926','290',45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','227637',4382968,'1927','290',465922.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','227637',4382969,'1928','290',113440.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','227637',4382970,'1929','291',3519382.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','227637',4382971,'1930','291',2404864.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','227637',4382972,'1931','291',3610337.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','227637',4382973,'1932','291',3088822.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','227637',4382974,'1933','291',4127415.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','227637',4382975,'1934','291',1575553.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','227637',4382976,'2898','291',2813095.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','227637',4382977,'2899','291',3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227663',4383442,'1875','290',1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227663',4383443,'1876','290',1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227663',4383444,'1877','290',774481.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227663',4383445,'1878','290',177556.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227663',4383446,'1879','290',849700.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227663',4383447,'1880','290',104805.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227663',4383448,'1881','290',1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227663',4383449,'1882','290',1078099.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227663',4383450,'1883','290',529263.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227663',4383451,'1884','290',115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227663',4383452,'1885','290',1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227663',4383453,'1886','290',2078714.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227663',4383454,'1887','290',205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227663',4383455,'1888','290',159817.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227663',4383456,'1889','290',3009478.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227663',4383457,'1890','290',682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227663',4383458,'1891','290',1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227663',4383459,'1892','290',1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','227663',4383460,'1893','290',1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','227663',4383461,'1894','290',1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','227663',4383462,'1895','290',687627.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','227663',4383463,'1896','290',264132.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','227663',4383464,'1897','290',414417.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','227663',4383465,'1898','290',65429.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','227663',4383466,'1899','290',1906647.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','227663',4383467,'1900','290',410739.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','227663',4383468,'1901','290',1055926.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','227663',4383469,'1902','290',36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','227663',4383470,'1903','290',1087079.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','227663',4383471,'1904','290',1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','227663',4383472,'1905','290',1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','227663',4383473,'1906','290',618209.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','227663',4383474,'1907','290',1967757.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','227663',4383475,'1908','290',610294.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','227663',4383476,'1909','290',498099.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','227663',4383477,'1910','290',379334.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','227663',4383478,'1911','290',1081636.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','227663',4383479,'1912','290',196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','227663',4383480,'1913','290',586060.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','227663',4383481,'1914','290',64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','227663',4383482,'1915','290',234387.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','227663',4383483,'1916','290',22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','227663',4383484,'1917','290',991287.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','227663',4383485,'1918','290',139458.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','227663',4383486,'1919','290',457929.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','227663',4383487,'1920','290',97332.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','227663',4383488,'1921','290',922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','227663',4383489,'1922','290',90705.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','227663',4383490,'1923','290',721000.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','227663',4383491,'1924','290',117343.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','227663',4383492,'1925','290',1573354.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','227663',4383493,'1926','290',45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','227663',4383494,'1927','290',465922.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','227663',4383495,'1928','290',113440.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','227663',4383496,'1929','291',3519382.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','227663',4383497,'1930','291',2404864.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','227663',4383498,'1931','291',3610337.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','227663',4383499,'1932','291',3088822.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','227663',4383500,'1933','291',4127415.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','227663',4383501,'1934','291',1575553.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','227663',4383502,'2898','291',2813095.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','227663',4383503,'2899','291',3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227665',4383505,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227665',4383506,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227665',4383507,'1877','290',774481.16,774481.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227665',4383508,'1878','290',177556.35,177556.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227665',4383509,'1879','290',849700.55,849700.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227665',4383510,'1880','290',104805.80,104805.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227665',4383511,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227665',4383512,'1882','290',1078099.20,1081710.75,3611.55,588682.65,0.00,0.00,0.00,0.00,0.00),('5','107','697','227665',4383513,'1883','290',529263.56,530241.60,978.04,159420.52,0.00,0.00,0.00,0.00,0.00),('5','107','697','227665',4383514,'1884','290',115114.05,115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227665',4383515,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227665',4383516,'1886','290',2078714.50,2084682.36,5967.86,972761.18,0.00,0.00,0.00,0.00,0.00),('5','107','697','227665',4383517,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227665',4383518,'1888','290',159817.86,159817.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227665',4383519,'1889','290',3009478.15,3009478.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227665',4383520,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227665',4383521,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227665',4383522,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','227665',4383523,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','227665',4383524,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','227665',4383525,'1895','290',687627.39,688388.49,761.10,124059.30,0.00,0.00,0.00,0.00,0.00),('5','107','698','227665',4383526,'1896','290',264132.10,265634.10,1502.00,244826.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','227665',4383527,'1897','290',414417.00,415134.27,717.27,116915.01,0.00,0.00,0.00,0.00,0.00),('5','107','698','227665',4383528,'1898','290',65429.00,65942.00,513.00,83619.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','227665',4383529,'1899','290',1906647.76,1908156.68,1508.92,245953.96,0.00,0.00,0.00,0.00,0.00),('5','107','699','227665',4383530,'1900','290',410739.53,410739.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','227665',4383531,'1901','290',1055926.00,1058185.00,2259.00,368217.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','227665',4383532,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','227665',4383533,'1903','290',1087079.22,1092635.34,5556.12,905647.56,0.00,0.00,0.00,0.00,0.00),('5','107','700','227665',4383534,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','227665',4383535,'1905','290',1480064.95,1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','227665',4383536,'1906','290',618209.58,619616.55,1406.97,229336.11,0.00,0.00,0.00,0.00,0.00),('5','107','701','227665',4383537,'1907','290',1967757.20,1967757.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','227665',4383538,'1908','290',610294.36,610294.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','227665',4383539,'1909','290',498099.73,498099.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','227665',4383540,'1910','290',379334.55,379334.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','227665',4383541,'1911','290',1081636.73,1082693.66,1056.93,172279.59,0.00,0.00,0.00,0.00,0.00),('5','107','702','227665',4383542,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','227665',4383543,'1913','290',586060.56,586060.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','227665',4383544,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','227665',4383545,'1915','290',234387.65,234387.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','227665',4383546,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','227665',4383547,'1917','290',991287.76,994004.01,2716.25,442748.75,0.00,0.00,0.00,0.00,0.00),('5','107','703','227665',4383548,'1918','290',139458.20,139458.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','227665',4383549,'1919','290',457929.74,459446.58,1516.84,247244.92,0.00,0.00,0.00,0.00,0.00),('5','107','703','227665',4383550,'1920','290',97332.11,97332.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','227665',4383551,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','227665',4383552,'1922','290',90705.59,93537.60,2832.01,461617.63,0.00,0.00,0.00,0.00,0.00),('5','107','704','227665',4383553,'1923','290',721000.23,721000.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','227665',4383554,'1924','290',117343.20,117343.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','227665',4383555,'1925','290',1573354.52,1577835.99,4481.47,730479.61,0.00,0.00,0.00,0.00,0.00),('5','107','705','227665',4383556,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','227665',4383557,'1927','290',465922.60,467236.24,1313.64,214123.32,0.00,0.00,0.00,0.00,0.00),('5','107','705','227665',4383558,'1928','290',113440.79,113440.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','227665',4383559,'1929','291',3519382.30,3523838.61,4456.31,1314611.45,0.00,0.00,0.00,0.00,0.00),('5','107','706','227665',4383560,'1930','291',2404864.78,2410008.37,5143.59,1517359.05,0.00,0.00,0.00,0.00,0.00),('5','107','706','227665',4383561,'1931','291',3610337.17,3616997.92,6660.75,1964921.25,0.00,0.00,0.00,0.00,0.00),('5','107','706','227665',4383562,'1932','291',3088822.00,3091932.09,3110.09,917476.55,0.00,0.00,0.00,0.00,0.00),('5','107','706','227665',4383563,'1933','291',4127415.38,4135845.10,8429.72,2486767.40,0.00,0.00,0.00,0.00,0.00),('5','107','708','227665',4383564,'1934','291',1575553.10,1575553.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','227665',4383565,'2898','291',2813095.75,2817880.10,4784.35,1411383.25,0.00,0.00,0.00,0.00,0.00),('5','107','708','227665',4383566,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227982',4389331,'1875','290',1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227982',4389332,'1876','290',1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227982',4389333,'1877','290',774481.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227982',4389334,'1878','290',177556.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227982',4389335,'1879','290',849700.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227982',4389336,'1880','290',104805.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227982',4389337,'1881','290',1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227982',4389338,'1882','290',1081710.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227982',4389339,'1883','290',530241.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227982',4389340,'1884','290',115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227982',4389341,'1885','290',1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227982',4389342,'1886','290',2084682.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227982',4389343,'1887','290',205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227982',4389344,'1888','290',159817.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227982',4389345,'1889','290',3009478.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227982',4389346,'1890','290',682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227982',4389347,'1891','290',1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227982',4389348,'1892','290',1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','227982',4389349,'1893','290',1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','227982',4389350,'1894','290',1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','227982',4389351,'1895','290',688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','227982',4389352,'1896','290',265634.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','227982',4389353,'1897','290',415134.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','227982',4389354,'1898','290',65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','227982',4389355,'1899','290',1908156.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','227982',4389356,'1900','290',410739.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','227982',4389357,'1901','290',1058185.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','227982',4389358,'1902','290',36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','227982',4389359,'1903','290',1092635.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','227982',4389360,'1904','290',1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','227982',4389361,'1905','290',1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','227982',4389362,'1906','290',619616.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','227982',4389363,'1907','290',1967757.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','227982',4389364,'1908','290',610294.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','227982',4389365,'1909','290',498099.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','227982',4389366,'1910','290',379334.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','227982',4389367,'1911','290',1082693.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','227982',4389368,'1912','290',196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','227982',4389369,'1913','290',586060.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','227982',4389370,'1914','290',64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','227982',4389371,'1915','290',234387.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','227982',4389372,'1916','290',22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','227982',4389373,'1917','290',994004.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','227982',4389374,'1918','290',139458.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','227982',4389375,'1919','290',459446.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','227982',4389376,'1920','290',97332.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','227982',4389377,'1921','290',922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','227982',4389378,'1922','290',93537.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','227982',4389379,'1923','290',721000.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','227982',4389380,'1924','290',117343.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','227982',4389381,'1925','290',1577835.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','227982',4389382,'1926','290',45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','227982',4389383,'1927','290',467236.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','227982',4389384,'1928','290',113440.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','227982',4389385,'1929','291',3523838.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','227982',4389386,'1930','291',2410008.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','227982',4389387,'1931','291',3616997.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','227982',4389388,'1932','291',3091932.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','227982',4389389,'1933','291',4135845.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','227982',4389390,'1934','291',1575553.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','227982',4389391,'2898','291',2817880.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','227982',4389392,'2899','291',3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227986',4389458,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227986',4389459,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227986',4389460,'1877','290',774481.16,774942.80,461.64,75247.32,0.00,0.00,0.00,0.00,0.00),('5','107','696','227986',4389461,'1878','290',177556.35,177556.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227986',4389462,'1879','290',849700.55,850102.83,402.28,65571.64,0.00,0.00,0.00,0.00,0.00),('5','107','696','227986',4389463,'1880','290',104805.80,104805.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227986',4389464,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227986',4389465,'1882','290',1081710.75,1084455.12,2744.37,447332.31,0.00,0.00,0.00,0.00,0.00),('5','107','697','227986',4389466,'1883','290',530241.60,530241.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227986',4389467,'1884','290',115114.05,115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227986',4389468,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227986',4389469,'1886','290',2084682.36,2090660.12,5977.76,974374.88,0.00,0.00,0.00,0.00,0.00),('5','107','697','227986',4389470,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','227986',4389471,'1888','290',159817.86,159817.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227986',4389472,'1889','290',3009478.15,3014557.67,5079.52,827961.76,0.00,0.00,0.00,0.00,0.00),('5','107','696','227986',4389473,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227986',4389474,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','227986',4389475,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','227986',4389476,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','227986',4389477,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','227986',4389478,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','227986',4389479,'1896','290',265634.10,267807.14,2173.04,354205.52,0.00,0.00,0.00,0.00,0.00),('5','107','698','227986',4389480,'1897','290',415134.27,416360.30,1226.03,199842.89,0.00,0.00,0.00,0.00,0.00),('5','107','698','227986',4389481,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','227986',4389482,'1899','290',1908156.68,1908686.03,529.35,86284.05,0.00,0.00,0.00,0.00,0.00),('5','107','699','227986',4389483,'1900','290',410739.53,410792.29,52.76,8599.88,0.00,0.00,0.00,0.00,0.00),('5','107','699','227986',4389484,'1901','290',1058185.00,1059288.70,1103.70,179903.10,0.00,0.00,0.00,0.00,0.00),('5','107','699','227986',4389485,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','227986',4389486,'1903','290',1092635.34,1097722.85,5087.51,829264.13,0.00,0.00,0.00,0.00,0.00),('5','107','700','227986',4389487,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','227986',4389488,'1905','290',1480064.95,1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','227986',4389489,'1906','290',619616.55,622292.12,2675.57,436117.91,0.00,0.00,0.00,0.00,0.00),('5','107','701','227986',4389490,'1907','290',1967757.20,1967757.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','227986',4389491,'1908','290',610294.36,610294.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','227986',4389492,'1909','290',498099.73,498099.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','227986',4389493,'1910','290',379334.55,379334.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','227986',4389494,'1911','290',1082693.66,1082857.64,163.98,26728.74,0.00,0.00,0.00,0.00,0.00),('5','107','702','227986',4389495,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','227986',4389496,'1913','290',586060.56,586060.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','227986',4389497,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','227986',4389498,'1915','290',234387.65,234387.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','227986',4389499,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','227986',4389500,'1917','290',994004.01,995529.64,1525.63,248677.69,0.00,0.00,0.00,0.00,0.00),('5','107','703','227986',4389501,'1918','290',139458.20,139458.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','227986',4389502,'1919','290',459446.58,460104.84,658.26,107296.38,0.00,0.00,0.00,0.00,0.00),('5','107','703','227986',4389503,'1920','290',97332.11,97332.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','227986',4389504,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','227986',4389505,'1922','290',93537.60,95329.47,1791.87,292074.81,0.00,0.00,0.00,0.00,0.00),('5','107','704','227986',4389506,'1923','290',721000.23,721000.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','227986',4389507,'1924','290',117343.20,117343.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','227986',4389508,'1925','290',1577835.99,1580869.20,3033.21,494413.23,0.00,0.00,0.00,0.00,0.00),('5','107','705','227986',4389509,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','227986',4389510,'1927','290',467236.24,468343.06,1106.82,180411.66,0.00,0.00,0.00,0.00,0.00),('5','107','705','227986',4389511,'1928','290',113440.79,113440.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','227986',4389512,'1929','291',3523838.61,3530510.25,6671.64,2001492.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','227986',4389513,'1930','291',2410008.37,2416305.43,6297.06,1889118.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','227986',4389514,'1931','291',3616997.92,3623639.53,6641.61,1992483.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','227986',4389515,'1932','291',3091932.09,3095171.43,3239.34,971802.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','227986',4389516,'1933','291',4135845.10,4140340.20,4495.10,1348530.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','227986',4389517,'1934','291',1575553.10,1581071.93,5518.83,1655649.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','227986',4389518,'2898','291',2817880.10,2820060.88,2180.78,654234.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','227986',4389519,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','228071',4391271,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','228071',4391272,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','228071',4391273,'1877','290',774942.80,774942.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','228071',4391274,'1878','290',177556.35,177556.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','228071',4391275,'1879','290',850102.83,850102.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','228071',4391276,'1880','290',104805.80,104805.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','228071',4391277,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','228071',4391278,'1882','290',1084455.12,1087764.20,3309.08,539380.04,0.00,0.00,0.00,0.00,0.00),('5','107','697','228071',4391279,'1883','290',530241.60,530891.00,649.40,105852.20,0.00,0.00,0.00,0.00,0.00),('5','107','697','228071',4391280,'1884','290',115114.05,115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','228071',4391281,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','228071',4391282,'1886','290',2090660.12,2096832.33,6172.21,1006070.23,0.00,0.00,0.00,0.00,0.00),('5','107','697','228071',4391283,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','228071',4391284,'1888','290',159817.86,159817.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','228071',4391285,'1889','290',3014557.67,3014557.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','228071',4391286,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','228071',4391287,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','228071',4391288,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','228071',4391289,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','228071',4391290,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','228071',4391291,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','228071',4391292,'1896','290',267807.14,268599.90,792.76,129219.88,0.00,0.00,0.00,0.00,0.00),('5','107','698','228071',4391293,'1897','290',416360.30,416979.10,618.80,100864.40,0.00,0.00,0.00,0.00,0.00),('5','107','698','228071',4391294,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','228071',4391295,'1899','290',1908686.03,1911524.08,2838.05,462602.15,0.00,0.00,0.00,0.00,0.00),('5','107','699','228071',4391296,'1900','290',410792.29,411993.89,1201.60,195860.80,0.00,0.00,0.00,0.00,0.00),('5','107','699','228071',4391297,'1901','290',1059288.70,1060238.94,950.24,154889.12,0.00,0.00,0.00,0.00,0.00),('5','107','699','228071',4391298,'1902','290',36524.32,36524.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','228071',4391299,'1903','290',1097722.85,1099266.20,1543.35,251566.05,0.00,0.00,0.00,0.00,0.00),('5','107','700','228071',4391300,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','228071',4391301,'1905','290',1480064.95,1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','228071',4391302,'1906','290',622292.12,622292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','228071',4391303,'1907','290',1967757.20,1967757.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','228071',4391304,'1908','290',610294.36,610294.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','228071',4391305,'1909','290',498099.73,498099.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','228071',4391306,'1910','290',379334.55,379334.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','228071',4391307,'1911','290',1082857.64,1084469.45,1611.81,262725.03,0.00,0.00,0.00,0.00,0.00),('5','107','702','228071',4391308,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','228071',4391309,'1913','290',586060.56,586562.45,501.89,81808.07,0.00,0.00,0.00,0.00,0.00),('5','107','702','228071',4391310,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','228071',4391311,'1915','290',234387.65,234387.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','228071',4391312,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','228071',4391313,'1917','290',995529.64,998493.55,2963.91,483117.33,0.00,0.00,0.00,0.00,0.00),('5','107','703','228071',4391314,'1918','290',139458.20,140441.47,983.27,160273.01,0.00,0.00,0.00,0.00,0.00),('5','107','703','228071',4391315,'1919','290',460104.84,460678.68,573.84,93535.92,0.00,0.00,0.00,0.00,0.00),('5','107','703','228071',4391316,'1920','290',97332.11,98375.94,1043.83,170144.29,0.00,0.00,0.00,0.00,0.00),('5','107','704','228071',4391317,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','228071',4391318,'1922','290',95329.47,99799.32,4469.85,728585.55,0.00,0.00,0.00,0.00,0.00),('5','107','704','228071',4391319,'1923','290',721000.23,721000.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','228071',4391320,'1924','290',117343.20,118601.48,1258.28,205099.64,0.00,0.00,0.00,0.00,0.00),('5','107','705','228071',4391321,'1925','290',1580869.20,1583670.83,2801.63,456665.69,0.00,0.00,0.00,0.00,0.00),('5','107','705','228071',4391322,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','228071',4391323,'1927','290',468343.06,469246.86,903.80,147319.40,0.00,0.00,0.00,0.00,0.00),('5','107','705','228071',4391324,'1928','290',113440.79,113440.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','228071',4391325,'1929','291',3530510.25,3536587.89,6077.64,1823292.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','228071',4391326,'1930','291',2416305.43,2421102.52,4797.09,1439127.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','228071',4391327,'1931','291',3623639.53,3628036.53,4397.00,1319100.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','228071',4391328,'1932','291',3095171.43,3099374.70,4203.27,1260981.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','228071',4391329,'1933','291',4140340.20,4147432.12,7091.92,2127576.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','228071',4391330,'1934','291',1581071.93,1582141.93,1070.00,321000.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','228071',4391331,'2898','291',2820060.88,2823010.31,2949.43,884829.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','228071',4391332,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229320',4414689,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229320',4414690,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229320',4414691,'1877','290',774942.80,776595.86,1653.06,269448.78,0.00,0.00,0.00,0.00,0.00),('5','107','696','229320',4414692,'1878','290',177556.35,177556.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229320',4414693,'1879','290',850102.83,851232.86,1130.03,184194.89,0.00,0.00,0.00,0.00,0.00),('5','107','696','229320',4414694,'1880','290',104805.80,104805.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229320',4414695,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229320',4414696,'1882','290',1087764.20,1088606.39,842.19,137276.97,0.00,0.00,0.00,0.00,0.00),('5','107','697','229320',4414697,'1883','290',530891.00,530891.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229320',4414698,'1884','290',115114.05,115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229320',4414699,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229320',4414700,'1886','290',2096832.33,2098882.36,2050.03,334154.89,0.00,0.00,0.00,0.00,0.00),('5','107','697','229320',4414701,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229320',4414702,'1888','290',159817.86,159817.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229320',4414703,'1889','290',3014557.67,3019090.61,4532.94,738869.22,0.00,0.00,0.00,0.00,0.00),('5','107','696','229320',4414704,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229320',4414705,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229320',4414706,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229320',4414707,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229320',4414708,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229320',4414709,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229320',4414710,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229320',4414711,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229320',4414712,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','229320',4414713,'1899','290',1911524.08,1911796.00,271.92,44322.96,0.00,0.00,0.00,0.00,0.00),('5','107','699','229320',4414714,'1900','290',411993.89,415816.62,3822.73,623104.99,0.00,0.00,0.00,0.00,0.00),('5','107','699','229320',4414715,'1901','290',1060238.94,1063359.78,3120.84,508696.92,0.00,0.00,0.00,0.00,0.00),('5','107','699','229320',4414716,'1902','290',36524.32,38327.68,1803.36,293947.68,0.00,0.00,0.00,0.00,0.00),('5','107','700','229320',4414717,'1903','290',1099266.20,1099266.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','229320',4414718,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','229320',4414719,'1905','290',1480064.95,1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','229320',4414720,'1906','290',622292.12,622292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','229320',4414721,'1907','290',1967757.20,1967757.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','229320',4414722,'1908','290',610294.36,610294.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','229320',4414723,'1909','290',498099.73,498099.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','229320',4414724,'1910','290',379334.55,379334.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','229320',4414725,'1911','290',1084469.45,1087194.35,2724.90,444158.70,0.00,0.00,0.00,0.00,0.00),('5','107','702','229320',4414726,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','229320',4414727,'1913','290',586562.45,586594.92,32.47,5292.61,0.00,0.00,0.00,0.00,0.00),('5','107','702','229320',4414728,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','229320',4414729,'1915','290',234387.65,234589.33,201.68,32873.84,0.00,0.00,0.00,0.00,0.00),('5','107','702','229320',4414730,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','229320',4414731,'1917','290',998493.55,1003792.30,5298.75,863696.25,0.00,0.00,0.00,0.00,0.00),('5','107','703','229320',4414732,'1918','290',140441.47,140441.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','229320',4414733,'1919','290',460678.68,462083.16,1404.48,228930.24,0.00,0.00,0.00,0.00,0.00),('5','107','703','229320',4414734,'1920','290',98375.94,99322.27,946.33,154251.79,0.00,0.00,0.00,0.00,0.00),('5','107','704','229320',4414735,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','229320',4414736,'1922','290',99799.32,106266.50,6467.18,1054150.34,0.00,0.00,0.00,0.00,0.00),('5','107','704','229320',4414737,'1923','290',721000.23,721000.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','229320',4414738,'1924','290',118601.48,121105.75,2504.27,408196.01,0.00,0.00,0.00,0.00,0.00),('5','107','705','229320',4414739,'1925','290',1583670.83,1587674.64,4003.81,652621.03,0.00,0.00,0.00,0.00,0.00),('5','107','705','229320',4414740,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','229320',4414741,'1927','290',469246.86,469246.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','229320',4414742,'1928','290',113440.79,113440.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','229320',4414743,'1929','291',3536587.89,3544209.46,7621.57,2286471.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','229320',4414744,'1930','291',2421102.52,2425387.96,4285.44,1285632.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','229320',4414745,'1931','291',3628036.53,3634135.15,6098.62,1829586.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','229320',4414746,'1932','291',3099374.70,3104540.76,5166.06,1549818.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','229320',4414747,'1933','291',4147432.12,4155059.54,7627.42,2288226.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','229320',4414748,'1934','291',1582141.93,1587772.78,5630.85,1689255.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','229320',4414749,'2898','291',2823010.31,2827943.64,4933.33,1479999.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','229320',4414750,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229801',4423779,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229801',4423780,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229801',4423781,'1877','290',776595.86,778125.11,1529.25,249267.75,0.00,0.00,0.00,0.00,0.00),('5','107','696','229801',4423782,'1878','290',177556.35,178209.23,652.88,106419.44,0.00,0.00,0.00,0.00,0.00),('5','107','696','229801',4423783,'1879','290',851232.86,851232.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229801',4423784,'1880','290',104805.80,104805.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229801',4423785,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229801',4423786,'1882','290',1088606.39,1088606.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229801',4423787,'1883','290',530891.00,530891.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229801',4423788,'1884','290',115114.05,115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229801',4423789,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229801',4423790,'1886','290',2098882.36,2098882.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229801',4423791,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229801',4423792,'1888','290',159817.86,159817.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229801',4423793,'1889','290',3019090.61,3024619.43,5528.82,901197.66,0.00,0.00,0.00,0.00,0.00),('5','107','696','229801',4423794,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229801',4423795,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229801',4423796,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229801',4423797,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229801',4423798,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229801',4423799,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229801',4423800,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229801',4423801,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229801',4423802,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','229801',4423803,'1899','290',1911796.00,1915093.02,3297.02,537414.26,0.00,0.00,0.00,0.00,0.00),('5','107','699','229801',4423804,'1900','290',415816.62,416451.55,634.93,103493.59,0.00,0.00,0.00,0.00,0.00),('5','107','699','229801',4423805,'1901','290',1063359.78,1068151.99,4792.21,781130.23,0.00,0.00,0.00,0.00,0.00),('5','107','699','229801',4423806,'1902','290',38327.68,38327.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','229801',4423807,'1903','290',1099266.20,1099266.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','229801',4423808,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','229801',4423809,'1905','290',1480064.95,1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','229801',4423810,'1906','290',622292.12,622292.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','229801',4423811,'1907','290',1967757.20,1967757.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','229801',4423812,'1908','290',610294.36,610294.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','229801',4423813,'1909','290',498099.73,498099.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','229801',4423814,'1910','290',379334.55,379334.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','229801',4423815,'1911','290',1087194.35,1091332.28,4137.93,674482.59,0.00,0.00,0.00,0.00,0.00),('5','107','702','229801',4423816,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','229801',4423817,'1913','290',586594.92,588537.09,1942.17,316573.71,0.00,0.00,0.00,0.00,0.00),('5','107','702','229801',4423818,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','229801',4423819,'1915','290',234589.33,235782.98,1193.65,194564.95,0.00,0.00,0.00,0.00,0.00),('5','107','702','229801',4423820,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','229801',4423821,'1917','290',1003792.30,1008229.82,4437.52,723315.76,0.00,0.00,0.00,0.00,0.00),('5','107','703','229801',4423822,'1918','290',140441.47,140441.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','229801',4423823,'1919','290',462083.16,464554.19,2471.03,402777.89,0.00,0.00,0.00,0.00,0.00),('5','107','703','229801',4423824,'1920','290',99322.27,99322.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','229801',4423825,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','229801',4423826,'1922','290',106266.50,107531.88,1265.38,206256.94,0.00,0.00,0.00,0.00,0.00),('5','107','704','229801',4423827,'1923','290',721000.23,721000.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','229801',4423828,'1924','290',121105.75,121994.04,888.29,144791.27,0.00,0.00,0.00,0.00,0.00),('5','107','705','229801',4423829,'1925','290',1587674.64,1590373.17,2698.53,439860.39,0.00,0.00,0.00,0.00,0.00),('5','107','705','229801',4423830,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','229801',4423831,'1927','290',469246.86,471239.00,1992.14,324718.82,0.00,0.00,0.00,0.00,0.00),('5','107','705','229801',4423832,'1928','290',113440.79,113440.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','229801',4423833,'1929','291',3544209.46,3551300.25,7090.79,2127237.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','229801',4423834,'1930','291',2425387.96,2430546.06,5158.10,1547430.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','229801',4423835,'1931','291',3634135.15,3638862.30,4727.15,1418145.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','229801',4423836,'1932','291',3104540.76,3108668.93,4128.17,1238451.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','229801',4423837,'1933','291',4155059.54,4159546.51,4486.97,1346091.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','229801',4423838,'1934','291',1587772.78,1589805.39,2032.61,609783.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','229801',4423839,'2898','291',2827943.64,2830486.19,2542.55,762765.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','229801',4423840,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229812',4424016,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229812',4424017,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229812',4424018,'1877','290',778125.11,778125.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229812',4424019,'1878','290',178209.23,178209.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229812',4424020,'1879','290',851232.86,852260.34,1027.48,167479.24,0.00,0.00,0.00,0.00,0.00),('5','107','696','229812',4424021,'1880','290',104805.80,105153.65,347.85,56699.55,0.00,0.00,0.00,0.00,0.00),('5','107','697','229812',4424022,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229812',4424023,'1882','290',1088606.39,1093545.65,4939.26,805099.38,0.00,0.00,0.00,0.00,0.00),('5','107','697','229812',4424024,'1883','290',530891.00,533921.88,3030.88,494033.44,0.00,0.00,0.00,0.00,0.00),('5','107','697','229812',4424025,'1884','290',115114.05,115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229812',4424026,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229812',4424027,'1886','290',2098882.36,2105944.00,7061.64,1151047.32,0.00,0.00,0.00,0.00,0.00),('5','107','697','229812',4424028,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229812',4424029,'1888','290',159817.86,159817.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229812',4424030,'1889','290',3024619.43,3025997.93,1378.50,224695.50,0.00,0.00,0.00,0.00,0.00),('5','107','696','229812',4424031,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229812',4424032,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229812',4424033,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229812',4424034,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229812',4424035,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229812',4424036,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229812',4424037,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229812',4424038,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229812',4424039,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','229812',4424040,'1899','290',1915093.02,1915099.00,5.98,974.74,0.00,0.00,0.00,0.00,0.00),('5','107','699','229812',4424041,'1900','290',416451.55,416451.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','229812',4424042,'1901','290',1068151.99,1068151.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','229812',4424043,'1902','290',38327.68,38327.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','229812',4424044,'1903','290',1099266.20,1106813.00,7546.80,1230128.40,0.00,0.00,0.00,0.00,0.00),('5','107','700','229812',4424045,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','229812',4424046,'1905','290',1480064.95,1480064.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','229812',4424047,'1906','290',622292.12,623662.00,1369.88,223290.44,0.00,0.00,0.00,0.00,0.00),('5','107','701','229812',4424048,'1907','290',1967757.20,1967757.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','229812',4424049,'1908','290',610294.36,610294.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','229812',4424050,'1909','290',498099.73,498099.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','229812',4424051,'1910','290',379334.55,379334.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','229812',4424052,'1911','290',1091332.28,1093178.00,1845.72,300852.36,0.00,0.00,0.00,0.00,0.00),('5','107','702','229812',4424053,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','229812',4424054,'1913','290',588537.09,590748.00,2210.91,360378.33,0.00,0.00,0.00,0.00,0.00),('5','107','702','229812',4424055,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','229812',4424056,'1915','290',235782.98,235782.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','229812',4424057,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','229812',4424058,'1917','290',1008229.82,1011314.58,3084.76,502815.88,0.00,0.00,0.00,0.00,0.00),('5','107','703','229812',4424059,'1918','290',140441.47,141772.90,1331.43,217023.09,0.00,0.00,0.00,0.00,0.00),('5','107','703','229812',4424060,'1919','290',464554.19,468209.39,3655.20,595797.60,0.00,0.00,0.00,0.00,0.00),('5','107','703','229812',4424061,'1920','290',99322.27,100251.04,928.77,151389.51,0.00,0.00,0.00,0.00,0.00),('5','107','704','229812',4424062,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','229812',4424063,'1922','290',107531.88,110261.38,2729.50,444908.50,0.00,0.00,0.00,0.00,0.00),('5','107','704','229812',4424064,'1923','290',721000.23,721025.00,24.77,4037.51,0.00,0.00,0.00,0.00,0.00),('5','107','704','229812',4424065,'1924','290',121994.04,121994.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','229812',4424066,'1925','290',1590373.17,1594816.00,4442.83,724181.29,0.00,0.00,0.00,0.00,0.00),('5','107','705','229812',4424067,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','229812',4424068,'1927','290',471239.00,473614.00,2375.00,387125.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','229812',4424069,'1928','290',113440.79,113440.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','229812',4424070,'1929','291',3551300.25,3556413.67,5113.42,1534026.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','229812',4424071,'1930','291',2430546.06,2436617.98,6071.92,1821576.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','229812',4424072,'1931','291',3638862.30,3645757.62,6895.32,2068596.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','229812',4424073,'1932','291',3108668.93,3112366.91,3697.98,1109394.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','229812',4424074,'1933','291',4159546.51,4165596.22,6049.71,1814913.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','229812',4424075,'1934','291',1589805.39,1590708.00,902.61,270783.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','229812',4424076,'2898','291',2830486.19,2835513.42,5027.23,1508169.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','229812',4424077,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229828',4424410,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229828',4424411,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229828',4424412,'1877','290',778125.11,778125.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229828',4424413,'1878','290',178209.23,179260.09,1050.86,171290.18,0.00,0.00,0.00,0.00,0.00),('5','107','696','229828',4424414,'1879','290',852260.34,852260.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229828',4424415,'1880','290',105153.65,105153.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229828',4424416,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229828',4424417,'1882','290',1093545.65,1098069.37,4523.72,737366.36,0.00,0.00,0.00,0.00,0.00),('5','107','697','229828',4424418,'1883','290',533921.88,534526.23,604.35,98509.05,0.00,0.00,0.00,0.00,0.00),('5','107','697','229828',4424419,'1884','290',115114.05,115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229828',4424420,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229828',4424421,'1886','290',2105944.00,2112445.27,6501.27,1059707.01,0.00,0.00,0.00,0.00,0.00),('5','107','697','229828',4424422,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229828',4424423,'1888','290',159817.86,159817.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229828',4424424,'1889','290',3025997.93,3029190.19,3192.26,520338.38,0.00,0.00,0.00,0.00,0.00),('5','107','696','229828',4424425,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229828',4424426,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229828',4424427,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229828',4424428,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229828',4424429,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229828',4424430,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229828',4424431,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229828',4424432,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229828',4424433,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','229828',4424434,'1899','290',1915099.00,1915713.54,614.54,100170.02,0.00,0.00,0.00,0.00,0.00),('5','107','699','229828',4424435,'1900','290',416451.55,417500.33,1048.78,170951.14,0.00,0.00,0.00,0.00,0.00),('5','107','699','229828',4424436,'1901','290',1068151.99,1070544.52,2392.53,389982.39,0.00,0.00,0.00,0.00,0.00),('5','107','699','229828',4424437,'1902','290',38327.68,38327.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','229828',4424438,'1903','290',1106813.00,1110354.00,3541.00,577183.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','229828',4424439,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','229828',4424440,'1905','290',1480064.95,1480071.00,6.05,986.15,0.00,0.00,0.00,0.00,0.00),('5','107','700','229828',4424441,'1906','290',623662.00,625580.90,1918.90,312780.70,0.00,0.00,0.00,0.00,0.00),('5','107','701','229828',4424442,'1907','290',1967757.20,1971400.42,3643.22,593844.86,0.00,0.00,0.00,0.00,0.00),('5','107','701','229828',4424443,'1908','290',610294.36,610294.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','229828',4424444,'1909','290',498099.73,498099.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','229828',4424445,'1910','290',379334.55,383251.00,3916.45,638381.35,0.00,0.00,0.00,0.00,0.00),('5','107','702','229828',4424446,'1911','290',1093178.00,1095931.47,2753.47,448815.61,0.00,0.00,0.00,0.00,0.00),('5','107','702','229828',4424447,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','229828',4424448,'1913','290',590748.00,591269.74,521.74,85043.62,0.00,0.00,0.00,0.00,0.00),('5','107','702','229828',4424449,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','229828',4424450,'1915','290',235782.98,235782.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','229828',4424451,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','229828',4424452,'1917','290',1011314.58,1011928.04,613.46,99993.98,0.00,0.00,0.00,0.00,0.00),('5','107','703','229828',4424453,'1918','290',141772.90,142677.26,904.36,147410.68,0.00,0.00,0.00,0.00,0.00),('5','107','703','229828',4424454,'1919','290',468209.39,469462.13,1252.74,204196.62,0.00,0.00,0.00,0.00,0.00),('5','107','703','229828',4424455,'1920','290',100251.04,100251.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','229828',4424456,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','229828',4424457,'1922','290',110261.38,112879.54,2618.16,426760.08,0.00,0.00,0.00,0.00,0.00),('5','107','704','229828',4424458,'1923','290',721025.00,721025.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','229828',4424459,'1924','290',121994.04,121994.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','229828',4424460,'1925','290',1594816.00,1597415.03,2599.03,423641.89,0.00,0.00,0.00,0.00,0.00),('5','107','705','229828',4424461,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','229828',4424462,'1927','290',473614.00,473614.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','229828',4424463,'1928','290',113440.79,113440.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','229828',4424464,'1929','291',3556413.67,3565412.00,8998.33,2699499.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','229828',4424465,'1930','291',2436617.98,2442823.29,6205.31,1861593.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','229828',4424466,'1931','291',3645757.62,3651909.56,6151.94,1845582.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','229828',4424467,'1932','291',3112366.91,3116078.02,3711.11,1113333.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','229828',4424468,'1933','291',4165596.22,4170390.62,4794.40,1438320.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','229828',4424469,'1934','291',1590708.00,1591118.65,410.65,123195.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','229828',4424470,'2898','291',2835513.42,2839389.78,3876.36,1162908.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','229828',4424471,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229832',4424533,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229832',4424534,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229832',4424535,'1877','290',778125.11,780674.47,2549.36,415545.68,0.00,0.00,0.00,0.00,0.00),('5','107','696','229832',4424536,'1878','290',179260.09,179260.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229832',4424537,'1879','290',852260.34,852956.54,696.20,113480.60,0.00,0.00,0.00,0.00,0.00),('5','107','696','229832',4424538,'1880','290',105153.65,105153.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229832',4424539,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229832',4424540,'1882','290',1098069.37,1100743.75,2674.38,435923.94,0.00,0.00,0.00,0.00,0.00),('5','107','697','229832',4424541,'1883','290',534526.23,534526.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229832',4424542,'1884','290',115114.05,115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229832',4424543,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229832',4424544,'1886','290',2112445.27,2116344.90,3899.63,635639.69,0.00,0.00,0.00,0.00,0.00),('5','107','697','229832',4424545,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229832',4424546,'1888','290',159817.86,159817.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229832',4424547,'1889','290',3029190.19,3032266.77,3076.58,501482.54,0.00,0.00,0.00,0.00,0.00),('5','107','696','229832',4424548,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229832',4424549,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229832',4424550,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229832',4424551,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229832',4424552,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229832',4424553,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229832',4424554,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229832',4424555,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229832',4424556,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','229832',4424557,'1899','290',1915713.54,1919453.22,3739.68,609567.84,0.00,0.00,0.00,0.00,0.00),('5','107','699','229832',4424558,'1900','290',417500.33,417636.77,136.44,22239.72,0.00,0.00,0.00,0.00,0.00),('5','107','699','229832',4424559,'1901','290',1070544.52,1075030.00,4485.48,731133.24,0.00,0.00,0.00,0.00,0.00),('5','107','699','229832',4424560,'1902','290',38327.68,38327.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','229832',4424561,'1903','290',1110354.00,1110354.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','229832',4424562,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','229832',4424563,'1905','290',1480071.00,1480137.24,66.24,10797.12,0.00,0.00,0.00,0.00,0.00),('5','107','700','229832',4424564,'1906','290',625580.90,627454.00,1873.10,305315.30,0.00,0.00,0.00,0.00,0.00),('5','107','701','229832',4424565,'1907','290',1971400.42,1972986.24,1585.82,258488.66,0.00,0.00,0.00,0.00,0.00),('5','107','701','229832',4424566,'1908','290',610294.36,613623.97,3329.61,542726.43,0.00,0.00,0.00,0.00,0.00),('5','107','701','229832',4424567,'1909','290',498099.73,501130.19,3030.46,493964.98,0.00,0.00,0.00,0.00,0.00),('5','107','701','229832',4424568,'1910','290',383251.00,383251.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','229832',4424569,'1911','290',1095931.47,1100647.66,4716.19,768738.97,0.00,0.00,0.00,0.00,0.00),('5','107','702','229832',4424570,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','229832',4424571,'1913','290',591269.74,593190.41,1920.67,313069.21,0.00,0.00,0.00,0.00,0.00),('5','107','702','229832',4424572,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','229832',4424573,'1915','290',235782.98,235782.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','229832',4424574,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','229832',4424575,'1917','290',1011928.04,1011928.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','229832',4424576,'1918','290',142677.26,142677.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','229832',4424577,'1919','290',469462.13,469462.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','229832',4424578,'1920','290',100251.04,100251.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','229832',4424579,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','229832',4424580,'1922','290',112879.54,118140.09,5260.55,857469.65,0.00,0.00,0.00,0.00,0.00),('5','107','704','229832',4424581,'1923','290',721025.00,721025.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','229832',4424582,'1924','290',121994.04,125450.53,3456.49,563407.87,0.00,0.00,0.00,0.00,0.00),('5','107','705','229832',4424583,'1925','290',1597415.03,1597415.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','229832',4424584,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','229832',4424585,'1927','290',473614.00,473614.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','229832',4424586,'1928','290',113440.79,113440.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','229832',4424587,'1929','291',3565412.00,3570685.00,5273.00,1581900.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','229832',4424588,'1930','291',2442823.29,2448087.44,5264.15,1579245.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','229832',4424589,'1931','291',3651909.56,3657035.77,5126.21,1537863.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','229832',4424590,'1932','291',3116078.02,3119872.41,3794.39,1138317.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','229832',4424591,'1933','291',4170390.62,4179967.85,9577.23,2873169.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','229832',4424592,'1934','291',1591118.65,1597573.00,6454.35,1936305.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','229832',4424593,'2898','291',2839389.78,2842810.60,3420.82,1026246.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','229832',4424594,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229836',4424677,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229836',4424678,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229836',4424679,'1877','290',780674.47,780674.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229836',4424680,'1878','290',179260.09,179260.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229836',4424681,'1879','290',852956.54,852956.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229836',4424682,'1880','290',105153.65,105153.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229836',4424683,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229836',4424684,'1882','290',1100743.75,1100743.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229836',4424685,'1883','290',534526.23,534526.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229836',4424686,'1884','290',115114.05,115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229836',4424687,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229836',4424688,'1886','290',2116344.90,2116344.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229836',4424689,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229836',4424690,'1888','290',159817.86,159817.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229836',4424691,'1889','290',3032266.77,3032266.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229836',4424692,'1890','290',682750.80,682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229836',4424693,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229836',4424694,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229836',4424695,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229836',4424696,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229836',4424697,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229836',4424698,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229836',4424699,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229836',4424700,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','229836',4424701,'1899','290',1919453.22,1919453.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','229836',4424702,'1900','290',417636.77,417636.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','229836',4424703,'1901','290',1075030.00,1075030.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','229836',4424704,'1902','290',38327.68,38327.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','229836',4424705,'1903','290',1110354.00,1110354.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','229836',4424706,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','229836',4424707,'1905','290',1480137.24,1480137.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','229836',4424708,'1906','290',627454.00,627454.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','229836',4424709,'1907','290',1972986.24,1972986.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','229836',4424710,'1908','290',613623.97,613623.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','229836',4424711,'1909','290',501130.19,501130.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','229836',4424712,'1910','290',383251.00,383251.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','229836',4424713,'1911','290',1100647.66,1100647.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','229836',4424714,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','229836',4424715,'1913','290',593190.41,593190.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','229836',4424716,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','229836',4424717,'1915','290',235782.98,235782.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','229836',4424718,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','229836',4424719,'1917','290',1011928.04,1011928.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','229836',4424720,'1918','290',142677.26,142677.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','229836',4424721,'1919','290',469462.13,469462.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','229836',4424722,'1920','290',100251.04,100251.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','229836',4424723,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','229836',4424724,'1922','290',118140.09,118140.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','229836',4424725,'1923','290',721025.00,721025.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','229836',4424726,'1924','290',125450.53,125450.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','229836',4424727,'1925','290',1597415.03,1597415.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','229836',4424728,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','229836',4424729,'1927','290',473614.00,473614.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','229836',4424730,'1928','290',113440.79,113440.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','229836',4424731,'1929','291',3570685.00,3571088.49,403.49,121047.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','229836',4424732,'1930','291',2448087.44,2449390.96,1303.52,391056.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','229836',4424733,'1931','291',3657035.77,3659606.75,2570.98,771294.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','229836',4424734,'1932','291',3119872.41,3121688.76,1816.35,544905.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','229836',4424735,'1933','291',4179967.85,4181507.84,1539.99,461997.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','229836',4424736,'1934','291',1597573.00,1597573.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','229836',4424737,'2898','291',2842810.60,2843570.57,759.97,227991.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','229836',4424738,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229840',4424837,'1875','290',1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229840',4424838,'1876','290',1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229840',4424839,'1877','290',780674.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229840',4424840,'1878','290',179260.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229840',4424841,'1879','290',852956.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229840',4424842,'1880','290',105153.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229840',4424843,'1881','290',1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229840',4424844,'1882','290',1100743.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229840',4424845,'1883','290',534526.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229840',4424846,'1884','290',115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229840',4424847,'1885','290',1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229840',4424848,'1886','290',2116344.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229840',4424849,'1887','290',205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229840',4424850,'1888','290',159817.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229840',4424851,'1889','290',3032266.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229840',4424852,'1890','290',682750.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229840',4424853,'1891','290',1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229840',4424854,'1892','290',1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229840',4424855,'1893','290',1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229840',4424856,'1894','290',1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229840',4424857,'1895','290',688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229840',4424858,'1896','290',268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229840',4424859,'1897','290',416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229840',4424860,'1898','290',65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','229840',4424861,'1899','290',1919453.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','229840',4424862,'1900','290',417636.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','229840',4424863,'1901','290',1075030.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','229840',4424864,'1902','290',38327.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','229840',4424865,'1903','290',1110354.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','229840',4424866,'1904','290',1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','229840',4424867,'1905','290',1480137.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','229840',4424868,'1906','290',627454.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','229840',4424869,'1907','290',1972986.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','229840',4424870,'1908','290',613623.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','229840',4424871,'1909','290',501130.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','229840',4424872,'1910','290',383251.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','229840',4424873,'1911','290',1100647.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','229840',4424874,'1912','290',196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','229840',4424875,'1913','290',593190.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','229840',4424876,'1914','290',64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','229840',4424877,'1915','290',235782.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','229840',4424878,'1916','290',22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','229840',4424879,'1917','290',1011928.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','229840',4424880,'1918','290',142677.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','229840',4424881,'1919','290',469462.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','229840',4424882,'1920','290',100251.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','229840',4424883,'1921','290',922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','229840',4424884,'1922','290',118140.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','229840',4424885,'1923','290',721025.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','229840',4424886,'1924','290',125450.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','229840',4424887,'1925','290',1597415.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','229840',4424888,'1926','290',45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','229840',4424889,'1927','290',473614.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','229840',4424890,'1928','290',113440.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','229840',4424891,'1929','291',3571088.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','229840',4424892,'1930','291',2449390.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','229840',4424893,'1931','291',3659606.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','229840',4424894,'1932','291',3121688.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','229840',4424895,'1933','291',4181507.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','229840',4424896,'1934','291',1597573.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','229840',4424897,'2898','291',2843570.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','229840',4424898,'2899','291',3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229845',4424993,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229845',4424994,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229845',4424995,'1877','290',780674.47,782152.15,1477.68,240861.84,0.00,0.00,0.00,0.00,0.00),('5','107','696','229845',4424996,'1878','290',179260.09,179260.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229845',4424997,'1879','290',852956.54,852956.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229845',4424998,'1880','290',105153.65,105153.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229845',4424999,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229845',4425000,'1882','290',1100743.75,1104159.39,3415.64,556749.32,0.00,0.00,0.00,0.00,0.00),('5','107','697','229845',4425001,'1883','290',534526.23,535767.91,1241.68,202393.84,0.00,0.00,0.00,0.00,0.00),('5','107','697','229845',4425002,'1884','290',115114.05,115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229845',4425003,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229845',4425004,'1886','290',2116344.90,2123095.39,6750.49,1100329.87,0.00,0.00,0.00,0.00,0.00),('5','107','697','229845',4425005,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','229845',4425006,'1888','290',159817.86,159817.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229845',4425007,'1889','290',3032266.77,3032373.12,106.35,17335.05,0.00,0.00,0.00,0.00,0.00),('5','107','696','229845',4425008,'1890','290',682750.80,682753.39,2.59,422.17,0.00,0.00,0.00,0.00,0.00),('5','107','696','229845',4425009,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','229845',4425010,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229845',4425011,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229845',4425012,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229845',4425013,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229845',4425014,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229845',4425015,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','229845',4425016,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','229845',4425017,'1899','290',1919453.22,1920581.21,1127.99,183862.37,0.00,0.00,0.00,0.00,0.00),('5','107','699','229845',4425018,'1900','290',417636.77,418579.14,942.37,153606.31,0.00,0.00,0.00,0.00,0.00),('5','107','699','229845',4425019,'1901','290',1075030.00,1077191.27,2161.27,352287.01,0.00,0.00,0.00,0.00,0.00),('5','107','699','229845',4425020,'1902','290',38327.68,38327.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','229845',4425021,'1903','290',1110354.00,1114949.99,4595.99,749146.37,0.00,0.00,0.00,0.00,0.00),('5','107','700','229845',4425022,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','229845',4425023,'1905','290',1480137.24,1480137.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','229845',4425024,'1906','290',627454.00,632790.90,5336.90,869914.70,0.00,0.00,0.00,0.00,0.00),('5','107','701','229845',4425025,'1907','290',1972986.24,1978043.95,5057.71,824406.73,0.00,0.00,0.00,0.00,0.00),('5','107','701','229845',4425026,'1908','290',613623.97,613623.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','229845',4425027,'1909','290',501130.19,502146.72,1016.53,165694.39,0.00,0.00,0.00,0.00,0.00),('5','107','701','229845',4425028,'1910','290',383251.00,385422.03,2171.03,353877.89,0.00,0.00,0.00,0.00,0.00),('5','107','702','229845',4425029,'1911','290',1100647.66,1104565.80,3918.14,638656.82,0.00,0.00,0.00,0.00,0.00),('5','107','702','229845',4425030,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','229845',4425031,'1913','290',593190.41,594186.19,995.78,162312.14,0.00,0.00,0.00,0.00,0.00),('5','107','702','229845',4425032,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','229845',4425033,'1915','290',235782.98,235782.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','229845',4425034,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','229845',4425035,'1917','290',1011928.04,1011928.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','229845',4425036,'1918','290',142677.26,142677.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','229845',4425037,'1919','290',469462.13,469462.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','229845',4425038,'1920','290',100251.04,100251.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','229845',4425039,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','229845',4425040,'1922','290',118140.09,119391.74,1251.65,204018.95,0.00,0.00,0.00,0.00,0.00),('5','107','704','229845',4425041,'1923','290',721025.00,721025.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','229845',4425042,'1924','290',125450.53,126555.91,1105.38,180176.94,0.00,0.00,0.00,0.00,0.00),('5','107','705','229845',4425043,'1925','290',1597415.03,1597415.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','229845',4425044,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','229845',4425045,'1927','290',473614.00,473614.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','229845',4425046,'1928','290',113440.79,113440.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','229845',4425047,'1929','291',3571088.49,3577810.05,6721.56,2083683.60,0.00,0.00,0.00,0.00,0.00),('5','107','706','229845',4425048,'1930','291',2449390.96,2455940.98,6550.02,2030506.20,0.00,0.00,0.00,0.00,0.00),('5','107','706','229845',4425049,'1931','291',3659606.75,3664139.59,4532.84,1405180.40,0.00,0.00,0.00,0.00,0.00),('5','107','706','229845',4425050,'1932','291',3121688.76,3126238.86,4550.10,1410531.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','229845',4425051,'1933','291',4181507.84,4185979.43,4471.59,1386192.90,0.00,0.00,0.00,0.00,0.00),('5','107','708','229845',4425052,'1934','291',1597573.00,1600736.32,3163.32,980629.20,0.00,0.00,0.00,0.00,0.00),('5','107','706','229845',4425053,'2898','291',2843570.57,2847394.80,3824.23,1185511.30,0.00,0.00,0.00,0.00,0.00),('5','107','708','229845',4425054,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230036',4428419,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230036',4428420,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230036',4428421,'1877','290',782152.15,785708.86,3556.71,579743.73,0.00,0.00,0.00,0.00,0.00),('5','107','696','230036',4428422,'1878','290',179260.09,179260.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230036',4428423,'1879','290',852956.54,854574.24,1617.70,263685.10,0.00,0.00,0.00,0.00,0.00),('5','107','696','230036',4428424,'1880','290',105153.65,105153.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','230036',4428425,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','230036',4428426,'1882','290',1104159.39,1105195.29,1035.90,168851.70,0.00,0.00,0.00,0.00,0.00),('5','107','697','230036',4428427,'1883','290',535767.91,535767.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','230036',4428428,'1884','290',115114.05,115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','230036',4428429,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','230036',4428430,'1886','290',2123095.39,2124458.90,1363.51,222252.13,0.00,0.00,0.00,0.00,0.00),('5','107','697','230036',4428431,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','230036',4428432,'1888','290',159817.86,159817.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230036',4428433,'1889','290',3032373.12,3038048.36,5675.24,925064.12,0.00,0.00,0.00,0.00,0.00),('5','107','696','230036',4428434,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230036',4428435,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230036',4428436,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','230036',4428437,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','230036',4428438,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','230036',4428439,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','230036',4428440,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','230036',4428441,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','230036',4428442,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','230036',4428443,'1899','290',1920581.21,1920917.02,335.81,54737.03,0.00,0.00,0.00,0.00,0.00),('5','107','699','230036',4428444,'1900','290',418579.14,420526.89,1947.75,317483.25,0.00,0.00,0.00,0.00,0.00),('5','107','699','230036',4428445,'1901','290',1077191.27,1081898.15,4706.88,767221.44,0.00,0.00,0.00,0.00,0.00),('5','107','699','230036',4428446,'1902','290',38327.68,38327.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','230036',4428447,'1903','290',1114949.99,1117531.10,2581.11,420720.93,0.00,0.00,0.00,0.00,0.00),('5','107','700','230036',4428448,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','230036',4428449,'1905','290',1480137.24,1480137.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','230036',4428450,'1906','290',632790.90,635311.90,2521.00,410923.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','230036',4428451,'1907','290',1978043.95,1978443.02,399.07,65048.41,0.00,0.00,0.00,0.00,0.00),('5','107','701','230036',4428452,'1908','290',613623.97,615894.03,2270.06,370019.78,0.00,0.00,0.00,0.00,0.00),('5','107','701','230036',4428453,'1909','290',502146.72,502146.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','230036',4428454,'1910','290',385422.03,387199.00,1776.97,289646.11,0.00,0.00,0.00,0.00,0.00),('5','107','702','230036',4428455,'1911','290',1104565.80,1104817.38,251.58,41007.54,0.00,0.00,0.00,0.00,0.00),('5','107','702','230036',4428456,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','230036',4428457,'1913','290',594186.19,594186.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','230036',4428458,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','230036',4428459,'1915','290',235782.98,235782.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','230036',4428460,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','230036',4428461,'1917','290',1011928.04,1012087.62,159.58,26011.54,0.00,0.00,0.00,0.00,0.00),('5','107','703','230036',4428462,'1918','290',142677.26,142677.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','230036',4428463,'1919','290',469462.13,472729.28,3267.15,532545.45,0.00,0.00,0.00,0.00,0.00),('5','107','703','230036',4428464,'1920','290',100251.04,100820.76,569.72,92864.36,0.00,0.00,0.00,0.00,0.00),('5','107','704','230036',4428465,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','230036',4428466,'1922','290',119391.74,122402.88,3011.14,490815.82,0.00,0.00,0.00,0.00,0.00),('5','107','704','230036',4428467,'1923','290',721025.00,721025.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','230036',4428468,'1924','290',126555.91,129523.73,2967.82,483754.66,0.00,0.00,0.00,0.00,0.00),('5','107','705','230036',4428469,'1925','290',1597415.03,1601098.93,3683.90,600475.70,0.00,0.00,0.00,0.00,0.00),('5','107','705','230036',4428470,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','230036',4428471,'1927','290',473614.00,475278.73,1664.73,271350.99,0.00,0.00,0.00,0.00,0.00),('5','107','705','230036',4428472,'1928','290',113440.79,113440.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','230036',4428473,'1929','291',3577810.05,3584749.33,6939.28,2151176.80,0.00,0.00,0.00,0.00,0.00),('5','107','706','230036',4428474,'1930','291',2455940.98,2462547.18,6606.20,2047922.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','230036',4428475,'1931','291',3664139.59,3671259.51,7119.92,2207175.20,0.00,0.00,0.00,0.00,0.00),('5','107','706','230036',4428476,'1932','291',3126238.86,3131954.99,5716.13,1772000.30,0.00,0.00,0.00,0.00,0.00),('5','107','706','230036',4428477,'1933','291',4185979.43,4193034.30,7054.87,2187009.70,0.00,0.00,0.00,0.00,0.00),('5','107','708','230036',4428478,'1934','291',1600736.32,1602035.27,1298.95,402674.50,0.00,0.00,0.00,0.00,0.00),('5','107','706','230036',4428479,'2898','291',2847394.80,2851799.38,4404.58,1365419.80,0.00,0.00,0.00,0.00,0.00),('5','107','708','230036',4428480,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230040',4428535,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230040',4428536,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230040',4428537,'1877','290',785708.86,788406.46,2697.60,439708.80,0.00,0.00,0.00,0.00,0.00),('5','107','696','230040',4428538,'1878','290',179260.09,179260.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230040',4428539,'1879','290',854574.24,857038.07,2463.83,401604.29,0.00,0.00,0.00,0.00,0.00),('5','107','696','230040',4428540,'1880','290',105153.65,105153.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','230040',4428541,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','230040',4428542,'1882','290',1105195.29,1107692.38,2497.09,407025.67,0.00,0.00,0.00,0.00,0.00),('5','107','697','230040',4428543,'1883','290',535767.91,535767.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','230040',4428544,'1884','290',115114.05,115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','230040',4428545,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','230040',4428546,'1886','290',2124458.90,2131098.24,6639.34,1082212.42,0.00,0.00,0.00,0.00,0.00),('5','107','697','230040',4428547,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','230040',4428548,'1888','290',159817.86,159817.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230040',4428549,'1889','290',3038048.36,3041806.96,3758.60,612651.80,0.00,0.00,0.00,0.00,0.00),('5','107','696','230040',4428550,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230040',4428551,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230040',4428552,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','230040',4428553,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','230040',4428554,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','230040',4428555,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','230040',4428556,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','230040',4428557,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','230040',4428558,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','230040',4428559,'1899','290',1920917.02,1920917.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','230040',4428560,'1900','290',420526.89,425537.84,5010.95,816784.85,0.00,0.00,0.00,0.00,0.00),('5','107','699','230040',4428561,'1901','290',1081898.15,1083758.52,1860.37,303240.31,0.00,0.00,0.00,0.00,0.00),('5','107','699','230040',4428562,'1902','290',38327.68,39857.43,1529.75,249349.25,0.00,0.00,0.00,0.00,0.00),('5','107','700','230040',4428563,'1903','290',1117531.10,1117531.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','230040',4428564,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','230040',4428565,'1905','290',1480137.24,1480137.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','230040',4428566,'1906','290',635311.90,635311.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','230040',4428567,'1907','290',1978443.02,1978443.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','230040',4428568,'1908','290',615894.03,615894.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','230040',4428569,'1909','290',502146.72,502146.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','230040',4428570,'1910','290',387199.00,387199.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','230040',4428571,'1911','290',1104817.38,1104817.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','230040',4428572,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','230040',4428573,'1913','290',594186.19,594186.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','230040',4428574,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','230040',4428575,'1915','290',235782.98,235782.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','230040',4428576,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','230040',4428577,'1917','290',1012087.62,1015313.49,3225.87,525816.81,0.00,0.00,0.00,0.00,0.00),('5','107','703','230040',4428578,'1918','290',142677.26,142677.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','230040',4428579,'1919','290',472729.28,476239.26,3509.98,572126.74,0.00,0.00,0.00,0.00,0.00),('5','107','703','230040',4428580,'1920','290',100820.76,101663.78,843.02,137412.26,0.00,0.00,0.00,0.00,0.00),('5','107','704','230040',4428581,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','230040',4428582,'1922','290',122402.88,126319.65,3916.77,638433.51,0.00,0.00,0.00,0.00,0.00),('5','107','704','230040',4428583,'1923','290',721025.00,721025.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','230040',4428584,'1924','290',129523.73,132960.87,3437.14,560253.82,0.00,0.00,0.00,0.00,0.00),('5','107','705','230040',4428585,'1925','290',1601098.93,1604763.59,3664.66,597339.58,0.00,0.00,0.00,0.00,0.00),('5','107','705','230040',4428586,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','230040',4428587,'1927','290',475278.73,476675.40,1396.67,227657.21,0.00,0.00,0.00,0.00,0.00),('5','107','705','230040',4428588,'1928','290',113440.79,113440.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','230040',4428589,'1929','291',3584749.33,3591204.59,6455.26,2001130.60,0.00,0.00,0.00,0.00,0.00),('5','107','706','230040',4428590,'1930','291',2462547.18,2468244.71,5697.53,1766234.30,0.00,0.00,0.00,0.00,0.00),('5','107','706','230040',4428591,'1931','291',3671259.51,3677730.81,6471.30,2006103.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','230040',4428592,'1932','291',3131954.99,3137452.92,5497.93,1704358.30,0.00,0.00,0.00,0.00,0.00),('5','107','706','230040',4428593,'1933','291',4193034.30,4199121.90,6087.60,1887156.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','230040',4428594,'1934','291',1602035.27,1609415.74,7380.47,2287945.70,0.00,0.00,0.00,0.00,0.00),('5','107','706','230040',4428595,'2898','291',2851799.38,2856301.15,4501.77,1395548.70,0.00,0.00,0.00,0.00,0.00),('5','107','708','230040',4428596,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230250',4432457,'1875','290',1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230250',4432458,'1876','290',1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230250',4432459,'1877','290',788406.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230250',4432460,'1878','290',179260.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230250',4432461,'1879','290',857038.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230250',4432462,'1880','290',105153.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','230250',4432463,'1881','290',1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','230250',4432464,'1882','290',1107692.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','230250',4432465,'1883','290',535767.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','230250',4432466,'1884','290',115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','230250',4432467,'1885','290',1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','230250',4432468,'1886','290',2131098.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','230250',4432469,'1887','290',205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','230250',4432470,'1888','290',159817.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230250',4432471,'1889','290',3041806.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230250',4432472,'1890','290',682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230250',4432473,'1891','290',1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230250',4432474,'1892','290',1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','230250',4432475,'1893','290',1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','230250',4432476,'1894','290',1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','230250',4432477,'1895','290',688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','230250',4432478,'1896','290',268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','230250',4432479,'1897','290',416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','230250',4432480,'1898','290',65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','230250',4432481,'1899','290',1920917.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','230250',4432482,'1900','290',425537.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','230250',4432483,'1901','290',1083758.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','230250',4432484,'1902','290',39857.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','230250',4432485,'1903','290',1117531.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','230250',4432486,'1904','290',1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','230250',4432487,'1905','290',1480137.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','230250',4432488,'1906','290',635311.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','230250',4432489,'1907','290',1978443.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','230250',4432490,'1908','290',615894.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','230250',4432491,'1909','290',502146.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','230250',4432492,'1910','290',387199.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','230250',4432493,'1911','290',1104817.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','230250',4432494,'1912','290',196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','230250',4432495,'1913','290',594186.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','230250',4432496,'1914','290',64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','230250',4432497,'1915','290',235782.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','230250',4432498,'1916','290',22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','230250',4432499,'1917','290',1015313.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','230250',4432500,'1918','290',142677.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','230250',4432501,'1919','290',476239.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','230250',4432502,'1920','290',101663.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','230250',4432503,'1921','290',922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','230250',4432504,'1922','290',126319.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','230250',4432505,'1923','290',721025.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','230250',4432506,'1924','290',132960.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','230250',4432507,'1925','290',1604763.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','230250',4432508,'1926','290',45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','230250',4432509,'1927','290',476675.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','230250',4432510,'1928','290',113440.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','230250',4432511,'1929','291',3591204.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','230250',4432512,'1930','291',2468244.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','230250',4432513,'1931','291',3677730.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','230250',4432514,'1932','291',3137452.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','230250',4432515,'1933','291',4199121.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','230250',4432516,'1934','291',1609415.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','230250',4432517,'2898','291',2856301.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','230250',4432518,'2899','291',3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230254',4432597,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230254',4432598,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230254',4432599,'1877','290',788406.46,790835.92,2429.46,396001.98,0.00,0.00,0.00,0.00,0.00),('5','107','696','230254',4432600,'1878','290',179260.09,179260.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230254',4432601,'1879','290',857038.07,857038.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230254',4432602,'1880','290',105153.65,105153.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','230254',4432603,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','230254',4432604,'1882','290',1107692.38,1107692.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','230254',4432605,'1883','290',535767.91,536279.92,512.01,83457.63,0.00,0.00,0.00,0.00,0.00),('5','107','697','230254',4432606,'1884','290',115114.05,115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','230254',4432607,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','230254',4432608,'1886','290',2131098.24,2133945.25,2847.01,464062.63,0.00,0.00,0.00,0.00,0.00),('5','107','697','230254',4432609,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','230254',4432610,'1888','290',159817.86,162897.26,3079.40,501942.20,0.00,0.00,0.00,0.00,0.00),('5','107','696','230254',4432611,'1889','290',3041806.96,3047049.66,5242.70,854560.10,0.00,0.00,0.00,0.00,0.00),('5','107','696','230254',4432612,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230254',4432613,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230254',4432614,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','230254',4432615,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','230254',4432616,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','230254',4432617,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','230254',4432618,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','230254',4432619,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','230254',4432620,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','230254',4432621,'1899','290',1920917.02,1920917.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','230254',4432622,'1900','290',425537.84,426465.41,927.57,151193.91,0.00,0.00,0.00,0.00,0.00),('5','107','699','230254',4432623,'1901','290',1083758.52,1087155.13,3396.61,553647.43,0.00,0.00,0.00,0.00,0.00),('5','107','699','230254',4432624,'1902','290',39857.43,39857.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','230254',4432625,'1903','290',1117531.10,1117531.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','230254',4432626,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','230254',4432627,'1905','290',1480137.24,1480137.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','230254',4432628,'1906','290',635311.90,635311.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','230254',4432629,'1907','290',1978443.02,1978443.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','230254',4432630,'1908','290',615894.03,615894.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','230254',4432631,'1909','290',502146.72,502146.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','230254',4432632,'1910','290',387199.00,387199.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','230254',4432633,'1911','290',1104817.38,1104817.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','230254',4432634,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','230254',4432635,'1913','290',594186.19,594186.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','230254',4432636,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','230254',4432637,'1915','290',235782.98,235782.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','230254',4432638,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','230254',4432639,'1917','290',1015313.49,1016541.77,1228.28,200209.64,0.00,0.00,0.00,0.00,0.00),('5','107','703','230254',4432640,'1918','290',142677.26,144772.40,2095.14,341507.82,0.00,0.00,0.00,0.00,0.00),('5','107','703','230254',4432641,'1919','290',476239.26,477845.34,1606.08,261791.04,0.00,0.00,0.00,0.00,0.00),('5','107','703','230254',4432642,'1920','290',101663.78,104167.96,2504.18,408181.34,0.00,0.00,0.00,0.00,0.00),('5','107','704','230254',4432643,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','230254',4432644,'1922','290',126319.65,130673.09,4353.44,709610.72,0.00,0.00,0.00,0.00,0.00),('5','107','704','230254',4432645,'1923','290',721025.00,721025.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','230254',4432646,'1924','290',132960.87,137031.60,4070.73,663528.99,0.00,0.00,0.00,0.00,0.00),('5','107','705','230254',4432647,'1925','290',1604763.59,1609058.67,4295.08,700098.04,0.00,0.00,0.00,0.00,0.00),('5','107','705','230254',4432648,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','230254',4432649,'1927','290',476675.40,479296.98,2621.58,427317.54,0.00,0.00,0.00,0.00,0.00),('5','107','705','230254',4432650,'1928','290',113440.79,113440.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','230254',4432651,'1929','291',3591204.59,3600645.71,9441.12,2926747.20,0.00,0.00,0.00,0.00,0.00),('5','107','706','230254',4432652,'1930','291',2468244.71,2472551.31,4306.60,1335046.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','230254',4432653,'1931','291',3677730.81,3685182.85,7452.04,2310132.40,0.00,0.00,0.00,0.00,0.00),('5','107','706','230254',4432654,'1932','291',3137452.92,3142670.78,5217.86,1617536.60,0.00,0.00,0.00,0.00,0.00),('5','107','706','230254',4432655,'1933','291',4199121.90,4206048.99,6927.09,2147397.90,0.00,0.00,0.00,0.00,0.00),('5','107','708','230254',4432656,'1934','291',1609415.74,1611076.06,1660.32,514699.20,0.00,0.00,0.00,0.00,0.00),('5','107','706','230254',4432657,'2898','291',2856301.15,2860653.35,4352.20,1349182.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','230254',4432658,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230258',4432718,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230258',4432719,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230258',4432720,'1877','290',790835.92,792041.23,1205.31,196465.53,0.00,0.00,0.00,0.00,0.00),('5','107','696','230258',4432721,'1878','290',179260.09,180222.35,962.26,156848.38,0.00,0.00,0.00,0.00,0.00),('5','107','696','230258',4432722,'1879','290',857038.07,858299.59,1261.52,205627.76,0.00,0.00,0.00,0.00,0.00),('5','107','696','230258',4432723,'1880','290',105153.65,105153.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','230258',4432724,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','230258',4432725,'1882','290',1107692.38,1108136.80,444.42,72440.46,0.00,0.00,0.00,0.00,0.00),('5','107','697','230258',4432726,'1883','290',536279.92,536279.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','230258',4432727,'1884','290',115114.05,115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','230258',4432728,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','230258',4432729,'1886','290',2133945.25,2133945.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','230258',4432730,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','230258',4432731,'1888','290',162897.26,162897.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230258',4432732,'1889','290',3047049.66,3052887.32,5837.66,951538.58,0.00,0.00,0.00,0.00,0.00),('5','107','696','230258',4432733,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230258',4432734,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230258',4432735,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','230258',4432736,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','230258',4432737,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','230258',4432738,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','230258',4432739,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','230258',4432740,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','230258',4432741,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','230258',4432742,'1899','290',1920917.02,1920917.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','230258',4432743,'1900','290',426465.41,431850.16,5384.75,877714.25,0.00,0.00,0.00,0.00,0.00),('5','107','699','230258',4432744,'1901','290',1087155.13,1090708.11,3552.98,579135.74,0.00,0.00,0.00,0.00,0.00),('5','107','699','230258',4432745,'1902','290',39857.43,39857.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','230258',4432746,'1903','290',1117531.10,1117531.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','230258',4432747,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','230258',4432748,'1905','290',1480137.24,1480137.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','230258',4432749,'1906','290',635311.90,635311.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','230258',4432750,'1907','290',1978443.02,1979645.56,1202.54,196014.02,0.00,0.00,0.00,0.00,0.00),('5','107','701','230258',4432751,'1908','290',615894.03,620050.71,4156.68,677538.84,0.00,0.00,0.00,0.00,0.00),('5','107','701','230258',4432752,'1909','290',502146.72,507920.14,5773.42,941067.46,0.00,0.00,0.00,0.00,0.00),('5','107','701','230258',4432753,'1910','290',387199.00,388533.18,1334.18,217471.34,0.00,0.00,0.00,0.00,0.00),('5','107','702','230258',4432754,'1911','290',1104817.38,1108581.31,3763.93,613520.59,0.00,0.00,0.00,0.00,0.00),('5','107','702','230258',4432755,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','230258',4432756,'1913','290',594186.19,595886.14,1699.95,277091.85,0.00,0.00,0.00,0.00,0.00),('5','107','702','230258',4432757,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','230258',4432758,'1915','290',235782.98,235819.78,36.80,5998.40,0.00,0.00,0.00,0.00,0.00),('5','107','702','230258',4432759,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','230258',4432760,'1917','290',1016541.77,1016541.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','230258',4432761,'1918','290',144772.40,144772.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','230258',4432762,'1919','290',477845.34,477845.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','230258',4432763,'1920','290',104167.96,104167.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','230258',4432764,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','230258',4432765,'1922','290',130673.09,133545.79,2872.70,468250.10,0.00,0.00,0.00,0.00,0.00),('5','107','704','230258',4432766,'1923','290',721025.00,721025.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','230258',4432767,'1924','290',137031.60,140731.42,3699.82,603070.66,0.00,0.00,0.00,0.00,0.00),('5','107','705','230258',4432768,'1925','290',1609058.67,1611129.89,2071.22,337608.86,0.00,0.00,0.00,0.00,0.00),('5','107','705','230258',4432769,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','230258',4432770,'1927','290',479296.98,479296.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','230258',4432771,'1928','290',113440.79,113440.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','230258',4432772,'1929','291',3600645.71,3609150.63,8504.92,2636525.20,0.00,0.00,0.00,0.00,0.00),('5','107','706','230258',4432773,'1930','291',2472551.31,2477407.04,4855.73,1505276.30,0.00,0.00,0.00,0.00,0.00),('5','107','706','230258',4432774,'1931','291',3685182.85,3690521.06,5338.21,1654845.10,0.00,0.00,0.00,0.00,0.00),('5','107','706','230258',4432775,'1932','291',3142670.78,3148208.74,5537.96,1716767.60,0.00,0.00,0.00,0.00,0.00),('5','107','706','230258',4432776,'1933','291',4206048.99,4213305.58,7256.59,2249542.90,0.00,0.00,0.00,0.00,0.00),('5','107','708','230258',4432777,'1934','291',1611076.06,1613661.14,2585.08,801374.80,0.00,0.00,0.00,0.00,0.00),('5','107','706','230258',4432778,'2898','291',2860653.35,2865981.97,5328.62,1651872.20,0.00,0.00,0.00,0.00,0.00),('5','107','708','230258',4432779,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230690',4440715,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230690',4440716,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230690',4440717,'1877','290',792041.23,792041.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230690',4440718,'1878','290',180222.35,180222.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230690',4440719,'1879','290',858299.59,860365.04,2065.45,336668.35,0.00,0.00,0.00,0.00,0.00),('5','107','696','230690',4440720,'1880','290',105153.65,105153.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','230690',4440721,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','230690',4440722,'1882','290',1108136.80,1108365.58,228.78,37291.14,0.00,0.00,0.00,0.00,0.00),('5','107','697','230690',4440723,'1883','290',536279.92,537268.36,988.44,161115.72,0.00,0.00,0.00,0.00,0.00),('5','107','697','230690',4440724,'1884','290',115114.05,115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','230690',4440725,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','230690',4440726,'1886','290',2133945.25,2140078.00,6132.75,999638.25,0.00,0.00,0.00,0.00,0.00),('5','107','697','230690',4440727,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','230690',4440728,'1888','290',162897.26,162897.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230690',4440729,'1889','290',3052887.32,3053838.55,951.23,155050.49,0.00,0.00,0.00,0.00,0.00),('5','107','696','230690',4440730,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230690',4440731,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230690',4440732,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','230690',4440733,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','230690',4440734,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','230690',4440735,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','230690',4440736,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','230690',4440737,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','230690',4440738,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','230690',4440739,'1899','290',1920917.02,1920930.49,13.47,2195.61,0.00,0.00,0.00,0.00,0.00),('5','107','699','230690',4440740,'1900','290',431850.16,436435.78,4585.62,747456.06,0.00,0.00,0.00,0.00,0.00),('5','107','699','230690',4440741,'1901','290',1090708.11,1094075.77,3367.66,548928.58,0.00,0.00,0.00,0.00,0.00),('5','107','699','230690',4440742,'1902','290',39857.43,39857.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','230690',4440743,'1903','290',1117531.10,1117531.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','230690',4440744,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','230690',4440745,'1905','290',1480137.24,1480137.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','230690',4440746,'1906','290',635311.90,635311.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','230690',4440747,'1907','290',1979645.56,1980365.31,719.75,117319.25,0.00,0.00,0.00,0.00,0.00),('5','107','701','230690',4440748,'1908','290',620050.71,620050.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','230690',4440749,'1909','290',507920.14,510518.93,2598.79,423602.77,0.00,0.00,0.00,0.00,0.00),('5','107','701','230690',4440750,'1910','290',388533.18,388533.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','230690',4440751,'1911','290',1108581.31,1111561.92,2980.61,485839.43,0.00,0.00,0.00,0.00,0.00),('5','107','702','230690',4440752,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','230690',4440753,'1913','290',595886.14,597543.44,1657.30,270139.90,0.00,0.00,0.00,0.00,0.00),('5','107','702','230690',4440754,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','230690',4440755,'1915','290',235819.78,235819.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','230690',4440756,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','230690',4440757,'1917','290',1016541.77,1019452.93,2911.16,474519.08,0.00,0.00,0.00,0.00,0.00),('5','107','703','230690',4440758,'1918','290',144772.40,144772.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','230690',4440759,'1919','290',477845.34,479963.07,2117.73,345189.99,0.00,0.00,0.00,0.00,0.00),('5','107','703','230690',4440760,'1920','290',104167.96,104777.09,609.13,99288.19,0.00,0.00,0.00,0.00,0.00),('5','107','704','230690',4440761,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','230690',4440762,'1922','290',133545.79,136202.49,2656.70,433042.10,0.00,0.00,0.00,0.00,0.00),('5','107','704','230690',4440763,'1923','290',721025.00,721025.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','230690',4440764,'1924','290',140731.42,145355.75,4624.33,753765.79,0.00,0.00,0.00,0.00,0.00),('5','107','705','230690',4440765,'1925','290',1611129.89,1615834.98,4705.09,766929.67,0.00,0.00,0.00,0.00,0.00),('5','107','705','230690',4440766,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','230690',4440767,'1927','290',479296.98,481258.99,1962.01,319807.63,0.00,0.00,0.00,0.00,0.00),('5','107','705','230690',4440768,'1928','290',113440.79,113440.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','230690',4440769,'1929','291',3609150.63,3617459.65,8309.02,2575796.20,0.00,0.00,0.00,0.00,0.00),('5','107','706','230690',4440770,'1930','291',2477407.04,2485439.42,8032.38,2490037.80,0.00,0.00,0.00,0.00,0.00),('5','107','706','230690',4440771,'1931','291',3690521.06,3696855.92,6334.86,1963806.60,0.00,0.00,0.00,0.00,0.00),('5','107','706','230690',4440772,'1932','291',3148208.74,3153307.41,5098.67,1580587.70,0.00,0.00,0.00,0.00,0.00),('5','107','706','230690',4440773,'1933','291',4213305.58,4220035.56,6729.98,2086293.80,0.00,0.00,0.00,0.00,0.00),('5','107','708','230690',4440774,'1934','291',1613661.14,1622721.98,9060.84,2808860.40,0.00,0.00,0.00,0.00,0.00),('5','107','706','230690',4440775,'2898','291',2865981.97,2869422.49,3440.52,1066561.20,0.00,0.00,0.00,0.00,0.00),('5','107','708','230690',4440776,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230910',4444146,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230910',4444147,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230910',4444148,'1877','290',792041.23,792041.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230910',4444149,'1878','290',180222.35,180222.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230910',4444150,'1879','290',860365.04,861388.39,1023.35,166806.05,0.00,0.00,0.00,0.00,0.00),('5','107','696','230910',4444151,'1880','290',105153.65,105153.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','230910',4444152,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','230910',4444153,'1882','290',1108365.58,1112898.78,4533.20,738911.60,0.00,0.00,0.00,0.00,0.00),('5','107','697','230910',4444154,'1883','290',537268.36,537858.59,590.23,96207.49,0.00,0.00,0.00,0.00,0.00),('5','107','697','230910',4444155,'1884','290',115114.05,115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','230910',4444156,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','230910',4444157,'1886','290',2140078.00,2148837.43,8759.43,1427787.09,0.00,0.00,0.00,0.00,0.00),('5','107','697','230910',4444158,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','230910',4444159,'1888','290',162897.26,166259.59,3362.33,548059.79,0.00,0.00,0.00,0.00,0.00),('5','107','696','230910',4444160,'1889','290',3053838.55,3054415.50,576.95,94042.85,0.00,0.00,0.00,0.00,0.00),('5','107','696','230910',4444161,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230910',4444162,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','230910',4444163,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','230910',4444164,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','230910',4444165,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','230910',4444166,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','230910',4444167,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','230910',4444168,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','230910',4444169,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','230910',4444170,'1899','290',1920930.49,1920930.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','230910',4444171,'1900','290',436435.78,436435.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','230910',4444172,'1901','290',1094075.77,1096210.39,2134.62,347943.06,0.00,0.00,0.00,0.00,0.00),('5','107','699','230910',4444173,'1902','290',39857.43,39857.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','230910',4444174,'1903','290',1117531.10,1117531.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','230910',4444175,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','230910',4444176,'1905','290',1480137.24,1480137.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','230910',4444177,'1906','290',635311.90,635311.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','230910',4444178,'1907','290',1980365.31,1980365.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','230910',4444179,'1908','290',620050.71,620050.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','230910',4444180,'1909','290',510518.93,510518.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','230910',4444181,'1910','290',388533.18,388533.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','230910',4444182,'1911','290',1111561.92,1114576.94,3015.02,491448.26,0.00,0.00,0.00,0.00,0.00),('5','107','702','230910',4444183,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','230910',4444184,'1913','290',597543.44,598667.35,1123.91,183197.33,0.00,0.00,0.00,0.00,0.00),('5','107','702','230910',4444185,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','230910',4444186,'1915','290',235819.78,236874.21,1054.43,171872.09,0.00,0.00,0.00,0.00,0.00),('5','107','702','230910',4444187,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','230910',4444188,'1917','290',1019452.93,1025566.28,6113.35,996476.05,0.00,0.00,0.00,0.00,0.00),('5','107','703','230910',4444189,'1918','290',144772.40,144772.76,0.36,58.68,0.00,0.00,0.00,0.00,0.00),('5','107','703','230910',4444190,'1919','290',479963.07,482374.12,2411.05,393001.15,0.00,0.00,0.00,0.00,0.00),('5','107','703','230910',4444191,'1920','290',104777.09,105980.80,1203.71,196204.73,0.00,0.00,0.00,0.00,0.00),('5','107','704','230910',4444192,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','230910',4444193,'1922','290',136202.49,138029.95,1827.46,297875.98,0.00,0.00,0.00,0.00,0.00),('5','107','704','230910',4444194,'1923','290',721025.00,721025.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','230910',4444195,'1924','290',145355.75,146554.55,1198.80,195404.40,0.00,0.00,0.00,0.00,0.00),('5','107','705','230910',4444196,'1925','290',1615834.98,1620560.80,4725.82,770308.66,0.00,0.00,0.00,0.00,0.00),('5','107','705','230910',4444197,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','230910',4444198,'1927','290',481258.99,483387.39,2128.40,346929.20,0.00,0.00,0.00,0.00,0.00),('5','107','705','230910',4444199,'1928','290',113440.79,114399.89,959.10,156333.30,0.00,0.00,0.00,0.00,0.00),('5','107','706','230910',4444200,'1929','291',3617459.65,3626765.67,9306.02,2884866.20,0.00,0.00,0.00,0.00,0.00),('5','107','706','230910',4444201,'1930','291',2485439.42,2491731.00,6291.58,1950389.80,0.00,0.00,0.00,0.00,0.00),('5','107','706','230910',4444202,'1931','291',3696855.92,3704362.13,7506.21,2326925.10,0.00,0.00,0.00,0.00,0.00),('5','107','706','230910',4444203,'1932','291',3153307.41,3159673.25,6365.84,1973410.40,0.00,0.00,0.00,0.00,0.00),('5','107','706','230910',4444204,'1933','291',4220035.56,4226564.24,6528.68,2023890.80,0.00,0.00,0.00,0.00,0.00),('5','107','708','230910',4444205,'1934','291',1622721.98,1624954.20,2232.22,691988.20,0.00,0.00,0.00,0.00,0.00),('5','107','706','230910',4444206,'2898','291',2869422.49,2874905.19,5482.70,1699637.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','230910',4444207,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','231083',4447128,'1875','290',1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','231083',4447129,'1876','290',1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','231083',4447130,'1877','290',792041.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','231083',4447131,'1878','290',180222.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','231083',4447132,'1879','290',861388.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','231083',4447133,'1880','290',105153.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','231083',4447134,'1881','290',1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','231083',4447135,'1882','290',1112898.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','231083',4447136,'1883','290',537858.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','231083',4447137,'1884','290',115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','231083',4447138,'1885','290',1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','231083',4447139,'1886','290',2148837.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','231083',4447140,'1887','290',205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','231083',4447141,'1888','290',166259.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','231083',4447142,'1889','290',3054415.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','231083',4447143,'1890','290',682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','231083',4447144,'1891','290',1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','231083',4447145,'1892','290',1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','231083',4447146,'1893','290',1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','231083',4447147,'1894','290',1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','231083',4447148,'1895','290',688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','231083',4447149,'1896','290',268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','231083',4447150,'1897','290',416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','231083',4447151,'1898','290',65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','231083',4447152,'1899','290',1920930.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','231083',4447153,'1900','290',436435.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','231083',4447154,'1901','290',1096210.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','231083',4447155,'1902','290',39857.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','231083',4447156,'1903','290',1117531.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','231083',4447157,'1904','290',1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','231083',4447158,'1905','290',1480137.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','231083',4447159,'1906','290',635311.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','231083',4447160,'1907','290',1980365.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','231083',4447161,'1908','290',620050.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','231083',4447162,'1909','290',510518.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','231083',4447163,'1910','290',388533.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','231083',4447164,'1911','290',1114576.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','231083',4447165,'1912','290',196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','231083',4447166,'1913','290',598667.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','231083',4447167,'1914','290',64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','231083',4447168,'1915','290',236874.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','231083',4447169,'1916','290',22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','231083',4447170,'1917','290',1025566.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','231083',4447171,'1918','290',144772.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','231083',4447172,'1919','290',482374.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','231083',4447173,'1920','290',105980.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','231083',4447174,'1921','290',922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','231083',4447175,'1922','290',138029.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','231083',4447176,'1923','290',721025.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','231083',4447177,'1924','290',146554.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','231083',4447178,'1925','290',1620560.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','231083',4447179,'1926','290',45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','231083',4447180,'1927','290',483387.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','231083',4447181,'1928','290',114399.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','231083',4447182,'1929','291',3626765.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','231083',4447183,'1930','291',2491731.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','231083',4447184,'1931','291',3704362.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','231083',4447185,'1932','291',3159673.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','231083',4447186,'1933','291',4226564.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','231083',4447187,'1934','291',1624954.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','231083',4447188,'2898','291',2874905.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','231083',4447189,'2899','291',3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','231532',4454473,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','231532',4454474,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','231532',4454475,'1877','290',792041.23,792042.07,0.84,136.92,0.00,0.00,0.00,0.00,0.00),('5','107','696','231532',4454476,'1878','290',180222.35,180222.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','231532',4454477,'1879','290',861388.39,861388.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','231532',4454478,'1880','290',105153.65,105153.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','231532',4454479,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','231532',4454480,'1882','290',1112898.78,1117215.46,4316.68,703618.84,0.00,0.00,0.00,0.00,0.00),('5','107','697','231532',4454481,'1883','290',537858.59,541520.64,3662.05,596914.15,0.00,0.00,0.00,0.00,0.00),('5','107','697','231532',4454482,'1884','290',115114.05,115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','231532',4454483,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','231532',4454484,'1886','290',2148837.43,2154838.93,6001.50,978244.50,0.00,0.00,0.00,0.00,0.00),('5','107','697','231532',4454485,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','231532',4454486,'1888','290',166259.59,166259.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','231532',4454487,'1889','290',3054415.50,3054415.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','231532',4454488,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','231532',4454489,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','231532',4454490,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','231532',4454491,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','231532',4454492,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','231532',4454493,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','231532',4454494,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','231532',4454495,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','231532',4454496,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','231532',4454497,'1899','290',1920930.49,1920930.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','231532',4454498,'1900','290',436435.78,436435.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','231532',4454499,'1901','290',1096210.39,1096210.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','231532',4454500,'1902','290',39857.43,39857.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','231532',4454501,'1903','290',1117531.10,1121502.86,3971.76,647396.88,0.00,0.00,0.00,0.00,0.00),('5','107','700','231532',4454502,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','231532',4454503,'1905','290',1480137.24,1480137.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','231532',4454504,'1906','290',635311.90,640198.78,4886.88,796561.44,0.00,0.00,0.00,0.00,0.00),('5','107','701','231532',4454505,'1907','290',1980365.31,1985300.44,4935.13,804426.19,0.00,0.00,0.00,0.00,0.00),('5','107','701','231532',4454506,'1908','290',620050.71,620050.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','231532',4454507,'1909','290',510518.93,513731.23,3212.30,523604.90,0.00,0.00,0.00,0.00,0.00),('5','107','701','231532',4454508,'1910','290',388533.18,391050.05,2516.87,410249.81,0.00,0.00,0.00,0.00,0.00),('5','107','702','231532',4454509,'1911','290',1114576.94,1118519.89,3942.95,642700.85,0.00,0.00,0.00,0.00,0.00),('5','107','702','231532',4454510,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','231532',4454511,'1913','290',598667.35,598667.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','231532',4454512,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','231532',4454513,'1915','290',236874.21,236874.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','231532',4454514,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','231532',4454515,'1917','290',1025566.28,1029227.76,3661.48,596821.24,0.00,0.00,0.00,0.00,0.00),('5','107','703','231532',4454516,'1918','290',144772.76,144772.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','231532',4454517,'1919','290',482374.12,482374.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','231532',4454518,'1920','290',105980.80,105980.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','231532',4454519,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','231532',4454520,'1922','290',138029.95,138029.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','231532',4454521,'1923','290',721025.00,721025.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','231532',4454522,'1924','290',146554.55,146554.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','231532',4454523,'1925','290',1620560.80,1624433.26,3872.46,631210.98,0.00,0.00,0.00,0.00,0.00),('5','107','705','231532',4454524,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','231532',4454525,'1927','290',483387.39,483387.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','231532',4454526,'1928','290',114399.89,115314.75,914.86,149122.18,0.00,0.00,0.00,0.00,0.00),('5','107','706','231532',4454527,'1929','291',3626765.67,3634856.71,8091.04,2589132.80,0.00,0.00,0.00,0.00,0.00),('5','107','706','231532',4454528,'1930','291',2491731.00,2497507.32,5776.32,1848422.40,0.00,0.00,0.00,0.00,0.00),('5','107','706','231532',4454529,'1931','291',3704362.13,3709643.39,5281.26,1690003.20,0.00,0.00,0.00,0.00,0.00),('5','107','706','231532',4454530,'1932','291',3159673.25,3164469.48,4796.23,1534793.60,0.00,0.00,0.00,0.00,0.00),('5','107','706','231532',4454531,'1933','291',4226564.24,4234810.39,8246.15,2638768.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','231532',4454532,'1934','291',1624954.20,1628030.66,3076.46,984467.20,0.00,0.00,0.00,0.00,0.00),('5','107','706','231532',4454533,'2898','291',2874905.19,2877872.69,2967.50,949600.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','231532',4454534,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','231543',4454746,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','231543',4454747,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','231543',4454748,'1877','290',792042.07,792042.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','231543',4454749,'1878','290',180222.35,180222.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','231543',4454750,'1879','290',861388.39,861388.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','231543',4454751,'1880','290',105153.65,105153.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','231543',4454752,'1881','290',1200324.46,1200324.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','231543',4454753,'1882','290',1117215.46,1117363.55,148.09,24138.67,0.00,0.00,0.00,0.00,0.00),('5','107','697','231543',4454754,'1883','290',541520.64,541520.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','231543',4454755,'1884','290',115114.05,115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','231543',4454756,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','231543',4454757,'1886','290',2154838.93,2154838.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','231543',4454758,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','231543',4454759,'1888','290',166259.59,166259.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','231543',4454760,'1889','290',3054415.50,3054415.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','231543',4454761,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','231543',4454762,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','231543',4454763,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','231543',4454764,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','231543',4454765,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','231543',4454766,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','231543',4454767,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','231543',4454768,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','231543',4454769,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','231543',4454770,'1899','290',1920930.49,1920934.49,4.00,652.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','231543',4454771,'1900','290',436435.78,440084.62,3648.84,594760.92,0.00,0.00,0.00,0.00,0.00),('5','107','699','231543',4454772,'1901','290',1096210.39,1099171.82,2961.43,482713.09,0.00,0.00,0.00,0.00,0.00),('5','107','699','231543',4454773,'1902','290',39857.43,39857.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','231543',4454774,'1903','290',1121502.86,1122782.96,1280.10,208656.30,0.00,0.00,0.00,0.00,0.00),('5','107','700','231543',4454775,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','231543',4454776,'1905','290',1480137.24,1480137.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','231543',4454777,'1906','290',640198.78,647982.76,7783.98,1268788.74,0.00,0.00,0.00,0.00,0.00),('5','107','701','231543',4454778,'1907','290',1985300.44,1988476.64,3176.20,517720.60,0.00,0.00,0.00,0.00,0.00),('5','107','701','231543',4454779,'1908','290',620050.71,622481.15,2430.44,396161.72,0.00,0.00,0.00,0.00,0.00),('5','107','701','231543',4454780,'1909','290',513731.23,519058.42,5327.19,868331.97,0.00,0.00,0.00,0.00,0.00),('5','107','701','231543',4454781,'1910','290',391050.05,391050.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','231543',4454782,'1911','290',1118519.89,1118547.70,27.81,4533.03,0.00,0.00,0.00,0.00,0.00),('5','107','702','231543',4454783,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','231543',4454784,'1913','290',598667.35,603878.99,5211.64,849497.32,0.00,0.00,0.00,0.00,0.00),('5','107','702','231543',4454785,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','231543',4454786,'1915','290',236874.21,237829.98,955.77,155790.51,0.00,0.00,0.00,0.00,0.00),('5','107','702','231543',4454787,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','231543',4454788,'1917','290',1029227.76,1029227.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','231543',4454789,'1918','290',144772.76,144772.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','231543',4454790,'1919','290',482374.12,482374.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','231543',4454791,'1920','290',105980.80,105980.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','231543',4454792,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','231543',4454793,'1922','290',138029.95,142055.64,4025.69,656187.47,0.00,0.00,0.00,0.00,0.00),('5','107','704','231543',4454794,'1923','290',721025.00,721025.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','231543',4454795,'1924','290',146554.55,151010.76,4456.21,726362.23,0.00,0.00,0.00,0.00,0.00),('5','107','705','231543',4454796,'1925','290',1624433.26,1625365.00,931.74,151873.62,0.00,0.00,0.00,0.00,0.00),('5','107','705','231543',4454797,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','231543',4454798,'1927','290',483387.39,483387.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','231543',4454799,'1928','290',115314.75,115983.21,668.46,108958.98,0.00,0.00,0.00,0.00,0.00),('5','107','706','231543',4454800,'1929','291',3634856.71,3643859.90,9003.19,2881020.80,0.00,0.00,0.00,0.00,0.00),('5','107','706','231543',4454801,'1930','291',2497507.32,2503022.37,5515.05,1764816.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','231543',4454802,'1931','291',3709643.39,3715146.54,5503.15,1761008.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','231543',4454803,'1932','291',3164469.48,3169924.92,5455.44,1745740.80,0.00,0.00,0.00,0.00,0.00),('5','107','706','231543',4454804,'1933','291',4234810.39,4243819.59,9009.20,2882944.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','231543',4454805,'1934','291',1628030.66,1628105.31,74.65,23888.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','231543',4454806,'2898','291',2877872.69,2880298.47,2425.78,776249.60,0.00,0.00,0.00,0.00,0.00),('5','107','708','231543',4454807,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','231761',4458653,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','231761',4458654,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','231761',4458655,'1877','290',792042.07,792042.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','231761',4458656,'1878','290',180222.35,180222.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','231761',4458657,'1879','290',861388.39,861388.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','231761',4458658,'1880','290',105153.65,105153.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','231761',4458659,'1881','290',1200324.46,1200334.26,9.80,1597.40,0.00,0.00,0.00,0.00,0.00),('5','107','697','231761',4458660,'1882','290',1117363.55,1120821.60,3458.05,563662.15,0.00,0.00,0.00,0.00,0.00),('5','107','697','231761',4458661,'1883','290',541520.64,543115.67,1595.03,259989.89,0.00,0.00,0.00,0.00,0.00),('5','107','697','231761',4458662,'1884','290',115114.05,115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','231761',4458663,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','231761',4458664,'1886','290',2154838.93,2158946.22,4107.29,669488.27,0.00,0.00,0.00,0.00,0.00),('5','107','697','231761',4458665,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','231761',4458666,'1888','290',166259.59,166259.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','231761',4458667,'1889','290',3054415.50,3054515.25,99.75,16259.25,0.00,0.00,0.00,0.00,0.00),('5','107','696','231761',4458668,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','231761',4458669,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','231761',4458670,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','231761',4458671,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','231761',4458672,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','231761',4458673,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','231761',4458674,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','231761',4458675,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','231761',4458676,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','231761',4458677,'1899','290',1920934.49,1920934.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','231761',4458678,'1900','290',440084.62,443590.62,3506.00,571478.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','231761',4458679,'1901','290',1099171.82,1100967.31,1795.49,292664.87,0.00,0.00,0.00,0.00,0.00),('5','107','699','231761',4458680,'1902','290',39857.43,39857.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','231761',4458681,'1903','290',1122782.96,1122782.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','231761',4458682,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','231761',4458683,'1905','290',1480137.24,1480137.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','231761',4458684,'1906','290',647982.76,654328.55,6345.79,1034363.77,0.00,0.00,0.00,0.00,0.00),('5','107','701','231761',4458685,'1907','290',1988476.64,1990274.18,1797.54,292999.02,0.00,0.00,0.00,0.00,0.00),('5','107','701','231761',4458686,'1908','290',622481.15,626932.79,4451.64,725617.32,0.00,0.00,0.00,0.00,0.00),('5','107','701','231761',4458687,'1909','290',519058.42,525041.50,5983.08,975242.04,0.00,0.00,0.00,0.00,0.00),('5','107','701','231761',4458688,'1910','290',391050.05,391050.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','231761',4458689,'1911','290',1118547.70,1118988.52,440.82,71853.66,0.00,0.00,0.00,0.00,0.00),('5','107','702','231761',4458690,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','231761',4458691,'1913','290',603878.99,606598.05,2719.06,443206.78,0.00,0.00,0.00,0.00,0.00),('5','107','702','231761',4458692,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','231761',4458693,'1915','290',237829.98,237829.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','231761',4458694,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','231761',4458695,'1917','290',1029227.76,1029732.67,504.91,82300.33,0.00,0.00,0.00,0.00,0.00),('5','107','703','231761',4458696,'1918','290',144772.76,144842.48,69.72,11364.36,0.00,0.00,0.00,0.00,0.00),('5','107','703','231761',4458697,'1919','290',482374.12,483113.18,739.06,120466.78,0.00,0.00,0.00,0.00,0.00),('5','107','703','231761',4458698,'1920','290',105980.80,105980.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','231761',4458699,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','231761',4458700,'1922','290',142055.64,146239.97,4184.33,682045.79,0.00,0.00,0.00,0.00,0.00),('5','107','704','231761',4458701,'1923','290',721025.00,721025.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','231761',4458702,'1924','290',151010.76,152277.52,1266.76,206481.88,0.00,0.00,0.00,0.00,0.00),('5','107','705','231761',4458703,'1925','290',1625365.00,1625365.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','231761',4458704,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','231761',4458705,'1927','290',483387.39,483387.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','231761',4458706,'1928','290',115983.21,115983.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','231761',4458707,'1929','291',3643859.90,3654609.17,10749.27,3439766.40,0.00,0.00,0.00,0.00,0.00),('5','107','706','231761',4458708,'1930','291',2503022.37,2512138.03,9115.66,2917011.20,0.00,0.00,0.00,0.00,0.00),('5','107','706','231761',4458709,'1931','291',3715146.54,3718689.00,3542.46,1133587.20,0.00,0.00,0.00,0.00,0.00),('5','107','706','231761',4458710,'1932','291',3169924.92,3174856.57,4931.65,1578128.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','231761',4458711,'1933','291',4243819.59,4252603.79,8784.20,2810944.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','231761',4458712,'1934','291',1628105.31,1634246.26,6140.95,1965104.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','231761',4458713,'2898','291',2880298.47,2887894.45,7595.98,2430713.60,0.00,0.00,0.00,0.00,0.00),('5','107','708','231761',4458714,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','232037',4463836,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','232037',4463837,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','232037',4463838,'1877','290',792042.07,794650.02,2607.95,425095.85,0.00,0.00,0.00,0.00,0.00),('5','107','696','232037',4463839,'1878','290',180222.35,180222.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','232037',4463840,'1879','290',861388.39,861388.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','232037',4463841,'1880','290',105153.65,105153.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','232037',4463842,'1881','290',1200334.26,1200334.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','232037',4463843,'1882','290',1120821.60,1120821.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','232037',4463844,'1883','290',543115.67,545893.88,2778.21,452848.23,0.00,0.00,0.00,0.00,0.00),('5','107','697','232037',4463845,'1884','290',115114.05,115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','232037',4463846,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','232037',4463847,'1886','290',2158946.22,2164120.72,5174.50,843443.50,0.00,0.00,0.00,0.00,0.00),('5','107','697','232037',4463848,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','232037',4463849,'1888','290',166259.59,166345.15,85.56,13946.28,0.00,0.00,0.00,0.00,0.00),('5','107','696','232037',4463850,'1889','290',3054515.25,3059058.93,4543.68,740619.84,0.00,0.00,0.00,0.00,0.00),('5','107','696','232037',4463851,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','232037',4463852,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','232037',4463853,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','232037',4463854,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','232037',4463855,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','232037',4463856,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','232037',4463857,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','232037',4463858,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','232037',4463859,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','232037',4463860,'1899','290',1920934.49,1920934.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','232037',4463861,'1900','290',443590.62,445940.60,2349.98,383046.74,0.00,0.00,0.00,0.00,0.00),('5','107','699','232037',4463862,'1901','290',1100967.31,1104479.05,3511.74,572413.62,0.00,0.00,0.00,0.00,0.00),('5','107','699','232037',4463863,'1902','290',39857.43,39857.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','232037',4463864,'1903','290',1122782.96,1126186.79,3403.83,554824.29,0.00,0.00,0.00,0.00,0.00),('5','107','700','232037',4463865,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','232037',4463866,'1905','290',1480137.24,1480137.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','232037',4463867,'1906','290',654328.55,656358.76,2030.21,330924.23,0.00,0.00,0.00,0.00,0.00),('5','107','701','232037',4463868,'1907','290',1990274.18,1990274.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','232037',4463869,'1908','290',626932.79,631830.87,4898.08,798387.04,0.00,0.00,0.00,0.00,0.00),('5','107','701','232037',4463870,'1909','290',525041.50,525251.28,209.78,34194.14,0.00,0.00,0.00,0.00,0.00),('5','107','701','232037',4463871,'1910','290',391050.05,391050.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','232037',4463872,'1911','290',1118988.52,1118988.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','232037',4463873,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','232037',4463874,'1913','290',606598.05,606598.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','232037',4463875,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','232037',4463876,'1915','290',237829.98,237829.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','232037',4463877,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','232037',4463878,'1917','290',1029732.67,1030337.73,605.06,98624.78,0.00,0.00,0.00,0.00,0.00),('5','107','703','232037',4463879,'1918','290',144842.48,144842.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','232037',4463880,'1919','290',483113.18,483644.03,530.85,86528.55,0.00,0.00,0.00,0.00,0.00),('5','107','703','232037',4463881,'1920','290',105980.80,105980.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','232037',4463882,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','232037',4463883,'1922','290',146239.97,149998.89,3758.92,612703.96,0.00,0.00,0.00,0.00,0.00),('5','107','704','232037',4463884,'1923','290',721025.00,721025.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','232037',4463885,'1924','290',152277.52,154202.02,1924.50,313693.50,0.00,0.00,0.00,0.00,0.00),('5','107','705','232037',4463886,'1925','290',1625365.00,1629266.39,3901.39,635926.57,0.00,0.00,0.00,0.00,0.00),('5','107','705','232037',4463887,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','232037',4463888,'1927','290',483387.39,483387.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','232037',4463889,'1928','290',115983.21,115983.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','232037',4463890,'1929','291',3654609.17,3663229.00,8619.83,2758345.60,0.00,0.00,0.00,0.00,0.00),('5','107','706','232037',4463891,'1930','291',2512138.03,2518210.10,6072.07,1943062.40,0.00,0.00,0.00,0.00,0.00),('5','107','706','232037',4463892,'1931','291',3718689.00,3724064.35,5375.35,1720112.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','232037',4463893,'1932','291',3174856.57,3178795.69,3939.12,1260518.40,0.00,0.00,0.00,0.00,0.00),('5','107','706','232037',4463894,'1933','291',4252603.79,4260758.23,8154.44,2609420.80,0.00,0.00,0.00,0.00,0.00),('5','107','708','232037',4463895,'1934','291',1634246.26,1635713.10,1466.84,469388.80,0.00,0.00,0.00,0.00,0.00),('5','107','706','232037',4463896,'2898','291',2887894.45,2893157.54,5263.09,1684188.80,0.00,0.00,0.00,0.00,0.00),('5','107','708','232037',4463897,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','232276',4468035,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','232276',4468036,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','232276',4468037,'1877','290',794650.02,796529.04,1879.02,306280.26,0.00,0.00,0.00,0.00,0.00),('5','107','696','232276',4468038,'1878','290',180222.35,180222.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','232276',4468039,'1879','290',861388.39,861388.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','232276',4468040,'1880','290',105153.65,105153.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','232276',4468041,'1881','290',1200334.26,1200334.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','232276',4468042,'1882','290',1120821.60,1123978.77,3157.17,514618.71,0.00,0.00,0.00,0.00,0.00),('5','107','697','232276',4468043,'1883','290',545893.88,545893.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','232276',4468044,'1884','290',115114.05,115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','232276',4468045,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','232276',4468046,'1886','290',2164120.72,2170703.36,6582.64,1072970.32,0.00,0.00,0.00,0.00,0.00),('5','107','697','232276',4468047,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','232276',4468048,'1888','290',166345.15,166345.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','232276',4468049,'1889','290',3059058.93,3065183.59,6124.66,998319.58,0.00,0.00,0.00,0.00,0.00),('5','107','696','232276',4468050,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','232276',4468051,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','232276',4468052,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','232276',4468053,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','232276',4468054,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','232276',4468055,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','232276',4468056,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','232276',4468057,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','232276',4468058,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','232276',4468059,'1899','290',1920934.49,1920934.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','232276',4468060,'1900','290',445940.60,445940.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','232276',4468061,'1901','290',1104479.05,1108484.30,4005.25,652855.75,0.00,0.00,0.00,0.00,0.00),('5','107','699','232276',4468062,'1902','290',39857.43,39857.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','232276',4468063,'1903','290',1126186.79,1129743.80,3557.01,579792.63,0.00,0.00,0.00,0.00,0.00),('5','107','700','232276',4468064,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','232276',4468065,'1905','290',1480137.24,1480137.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','232276',4468066,'1906','290',656358.76,657825.79,1467.03,239125.89,0.00,0.00,0.00,0.00,0.00),('5','107','701','232276',4468067,'1907','290',1990274.18,1991882.17,1607.99,262102.37,0.00,0.00,0.00,0.00,0.00),('5','107','701','232276',4468068,'1908','290',631830.87,633249.18,1418.31,231184.53,0.00,0.00,0.00,0.00,0.00),('5','107','701','232276',4468069,'1909','290',525251.28,526979.62,1728.34,281719.42,0.00,0.00,0.00,0.00,0.00),('5','107','701','232276',4468070,'1910','290',391050.05,391050.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','232276',4468071,'1911','290',1118988.52,1121907.80,2919.28,475842.64,0.00,0.00,0.00,0.00,0.00),('5','107','702','232276',4468072,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','232276',4468073,'1913','290',606598.05,606598.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','232276',4468074,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','232276',4468075,'1915','290',237829.98,237829.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','232276',4468076,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','232276',4468077,'1917','290',1030337.73,1032187.72,1849.99,301548.37,0.00,0.00,0.00,0.00,0.00),('5','107','703','232276',4468078,'1918','290',144842.48,144842.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','232276',4468079,'1919','290',483644.03,484410.70,766.67,124967.21,0.00,0.00,0.00,0.00,0.00),('5','107','703','232276',4468080,'1920','290',105980.80,105980.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','232276',4468081,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','232276',4468082,'1922','290',149998.89,152334.05,2335.16,380631.08,0.00,0.00,0.00,0.00,0.00),('5','107','704','232276',4468083,'1923','290',721025.00,721025.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','232276',4468084,'1924','290',154202.02,154202.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','232276',4468085,'1925','290',1629266.39,1633839.81,4573.42,745467.46,0.00,0.00,0.00,0.00,0.00),('5','107','705','232276',4468086,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','232276',4468087,'1927','290',483387.39,483387.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','232276',4468088,'1928','290',115983.21,116001.01,17.80,2901.40,0.00,0.00,0.00,0.00,0.00),('5','107','706','232276',4468089,'1929','291',3663229.00,3672914.27,9685.27,3147712.75,0.00,0.00,0.00,0.00,0.00),('5','107','706','232276',4468090,'1930','291',2518210.10,2525061.47,6851.37,2226695.25,0.00,0.00,0.00,0.00,0.00),('5','107','706','232276',4468091,'1931','291',3724064.35,3729899.47,5835.12,1896414.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','232276',4468092,'1932','291',3178795.69,3185392.06,6596.37,2143820.25,0.00,0.00,0.00,0.00,0.00),('5','107','706','232276',4468093,'1933','291',4260758.23,4265903.92,5145.69,1672349.25,0.00,0.00,0.00,0.00,0.00),('5','107','708','232276',4468094,'1934','291',1635713.10,1642470.20,6757.10,2196057.50,0.00,0.00,0.00,0.00,0.00),('5','107','706','232276',4468095,'2898','291',2893157.54,2900233.67,7076.13,2299742.25,0.00,0.00,0.00,0.00,0.00),('5','107','708','232276',4468096,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','232519',4472459,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','232519',4472460,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','232519',4472461,'1877','290',796529.04,796529.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','232519',4472462,'1878','290',180222.35,180222.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','232519',4472463,'1879','290',861388.39,861388.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','232519',4472464,'1880','290',105153.65,105153.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','232519',4472465,'1881','290',1200334.26,1200334.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','232519',4472466,'1882','290',1123978.77,1126113.67,2134.90,347988.70,0.00,0.00,0.00,0.00,0.00),('5','107','697','232519',4472467,'1883','290',545893.88,546913.12,1019.24,166136.12,0.00,0.00,0.00,0.00,0.00),('5','107','697','232519',4472468,'1884','290',115114.05,115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','232519',4472469,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','232519',4472470,'1886','290',2170703.36,2173711.98,3008.62,490405.06,0.00,0.00,0.00,0.00,0.00),('5','107','697','232519',4472471,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','232519',4472472,'1888','290',166345.15,166345.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','232519',4472473,'1889','290',3065183.59,3070979.27,5795.68,944695.84,0.00,0.00,0.00,0.00,0.00),('5','107','696','232519',4472474,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','232519',4472475,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','232519',4472476,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','232519',4472477,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','232519',4472478,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','232519',4472479,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','232519',4472480,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','232519',4472481,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','232519',4472482,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','232519',4472483,'1899','290',1920934.49,1920934.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','232519',4472484,'1900','290',445940.60,446273.90,333.30,54327.90,0.00,0.00,0.00,0.00,0.00),('5','107','699','232519',4472485,'1901','290',1108484.30,1111573.10,3088.80,503474.40,0.00,0.00,0.00,0.00,0.00),('5','107','699','232519',4472486,'1902','290',39857.43,39857.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','232519',4472487,'1903','290',1129743.80,1131738.77,1994.97,325180.11,0.00,0.00,0.00,0.00,0.00),('5','107','700','232519',4472488,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','232519',4472489,'1905','290',1480137.24,1480137.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','232519',4472490,'1906','290',657825.79,661642.17,3816.38,622069.94,0.00,0.00,0.00,0.00,0.00),('5','107','701','232519',4472491,'1907','290',1991882.17,1991882.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','232519',4472492,'1908','290',633249.18,633249.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','232519',4472493,'1909','290',526979.62,526979.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','232519',4472494,'1910','290',391050.05,391050.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','232519',4472495,'1911','290',1121907.80,1125002.29,3094.49,504401.87,0.00,0.00,0.00,0.00,0.00),('5','107','702','232519',4472496,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','232519',4472497,'1913','290',606598.05,609438.58,2840.53,463006.39,0.00,0.00,0.00,0.00,0.00),('5','107','702','232519',4472498,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','232519',4472499,'1915','290',237829.98,237829.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','232519',4472500,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','232519',4472501,'1917','290',1032187.72,1032291.32,103.60,16886.80,0.00,0.00,0.00,0.00,0.00),('5','107','703','232519',4472502,'1918','290',144842.48,147422.05,2579.57,420469.91,0.00,0.00,0.00,0.00,0.00),('5','107','703','232519',4472503,'1919','290',484410.70,485631.89,1221.19,199053.97,0.00,0.00,0.00,0.00,0.00),('5','107','703','232519',4472504,'1920','290',105980.80,105980.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','232519',4472505,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','232519',4472506,'1922','290',152334.05,152334.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','232519',4472507,'1923','290',721025.00,721025.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','232519',4472508,'1924','290',154202.02,159525.27,5323.25,867689.75,0.00,0.00,0.00,0.00,0.00),('5','107','705','232519',4472509,'1925','290',1633839.81,1638324.96,4485.15,731079.45,0.00,0.00,0.00,0.00,0.00),('5','107','705','232519',4472510,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','232519',4472511,'1927','290',483387.39,483387.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','232519',4472512,'1928','290',116001.01,116001.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','232519',4472513,'1929','291',3672914.27,3680273.15,7358.88,2391636.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','232519',4472514,'1930','291',2525061.47,2530694.25,5632.78,1830653.50,0.00,0.00,0.00,0.00,0.00),('5','107','706','232519',4472515,'1931','291',3729899.47,3734767.94,4868.47,1582252.75,0.00,0.00,0.00,0.00,0.00),('5','107','706','232519',4472516,'1932','291',3185392.06,3190917.39,5525.33,1795732.25,0.00,0.00,0.00,0.00,0.00),('5','107','706','232519',4472517,'1933','291',4265903.92,4271080.61,5176.69,1682424.25,0.00,0.00,0.00,0.00,0.00),('5','107','708','232519',4472518,'1934','291',1642470.20,1646259.95,3789.75,1231668.75,0.00,0.00,0.00,0.00,0.00),('5','107','706','232519',4472519,'2898','291',2900233.67,2903711.96,3478.29,1130444.25,0.00,0.00,0.00,0.00,0.00),('5','107','708','232519',4472520,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','232631',4474258,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','232631',4474259,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','232631',4474260,'1877','290',796529.04,798368.23,1839.19,299787.97,0.00,0.00,0.00,0.00,0.00),('5','107','696','232631',4474261,'1878','290',180222.35,180222.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','232631',4474262,'1879','290',861388.39,862260.17,871.78,142100.14,0.00,0.00,0.00,0.00,0.00),('5','107','696','232631',4474263,'1880','290',105153.65,105153.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','232631',4474264,'1881','290',1200334.26,1200334.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','232631',4474265,'1882','290',1126113.67,1128914.90,2801.23,456600.49,0.00,0.00,0.00,0.00,0.00),('5','107','697','232631',4474266,'1883','290',546913.12,546913.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','232631',4474267,'1884','290',115114.05,115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','232631',4474268,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','232631',4474269,'1886','290',2173711.98,2177867.89,4155.91,677413.33,0.00,0.00,0.00,0.00,0.00),('5','107','697','232631',4474270,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','232631',4474271,'1888','290',166345.15,167063.49,718.34,117089.42,0.00,0.00,0.00,0.00,0.00),('5','107','696','232631',4474272,'1889','290',3070979.27,3077735.12,6755.85,1101203.55,0.00,0.00,0.00,0.00,0.00),('5','107','696','232631',4474273,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','232631',4474274,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','232631',4474275,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','232631',4474276,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','232631',4474277,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','232631',4474278,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','232631',4474279,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','232631',4474280,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','232631',4474281,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','232631',4474282,'1899','290',1920934.49,1920934.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','232631',4474283,'1900','290',446273.90,449544.37,3270.47,533086.61,0.00,0.00,0.00,0.00,0.00),('5','107','699','232631',4474284,'1901','290',1111573.10,1112672.83,1099.73,179255.99,0.00,0.00,0.00,0.00,0.00),('5','107','699','232631',4474285,'1902','290',39857.43,39857.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','232631',4474286,'1903','290',1131738.77,1138097.22,6358.45,1036427.35,0.00,0.00,0.00,0.00,0.00),('5','107','700','232631',4474287,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','232631',4474288,'1905','290',1480137.24,1480137.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','232631',4474289,'1906','290',661642.17,663547.31,1905.14,310537.82,0.00,0.00,0.00,0.00,0.00),('5','107','701','232631',4474290,'1907','290',1991882.17,1991949.72,67.55,11010.65,0.00,0.00,0.00,0.00,0.00),('5','107','701','232631',4474291,'1908','290',633249.18,633249.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','232631',4474292,'1909','290',526979.62,526979.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','232631',4474293,'1910','290',391050.05,391050.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','232631',4474294,'1911','290',1125002.29,1129332.41,4330.12,705809.56,0.00,0.00,0.00,0.00,0.00),('5','107','702','232631',4474295,'1912','290',196496.77,196496.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','232631',4474296,'1913','290',609438.58,610092.47,653.89,106584.07,0.00,0.00,0.00,0.00,0.00),('5','107','702','232631',4474297,'1914','290',64509.28,64509.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','232631',4474298,'1915','290',237829.98,237829.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','232631',4474299,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','232631',4474300,'1917','290',1032291.32,1032291.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','232631',4474301,'1918','290',147422.05,147422.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','232631',4474302,'1919','290',485631.89,485631.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','232631',4474303,'1920','290',105980.80,105980.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','232631',4474304,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','232631',4474305,'1922','290',152334.05,153138.18,804.13,131073.19,0.00,0.00,0.00,0.00,0.00),('5','107','704','232631',4474306,'1923','290',721025.00,721025.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','232631',4474307,'1924','290',159525.27,160649.67,1124.40,183277.20,0.00,0.00,0.00,0.00,0.00),('5','107','705','232631',4474308,'1925','290',1638324.96,1643250.01,4925.05,802783.15,0.00,0.00,0.00,0.00,0.00),('5','107','705','232631',4474309,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','232631',4474310,'1927','290',483387.39,483387.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','232631',4474311,'1928','290',116001.01,117131.20,1130.19,184220.97,0.00,0.00,0.00,0.00,0.00),('5','107','706','232631',4474312,'1929','291',3680273.15,3689620.84,9347.69,3037999.25,0.00,0.00,0.00,0.00,0.00),('5','107','706','232631',4474313,'1930','291',2530694.25,2536888.04,6193.79,2012981.75,0.00,0.00,0.00,0.00,0.00),('5','107','706','232631',4474314,'1931','291',3734767.94,3738947.02,4179.08,1358201.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','232631',4474315,'1932','291',3190917.39,3197393.32,6475.93,2104677.25,0.00,0.00,0.00,0.00,0.00),('5','107','706','232631',4474316,'1933','291',4271080.61,4278642.21,7561.60,2457520.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','232631',4474317,'1934','291',1646259.95,1648338.56,2078.61,675548.25,0.00,0.00,0.00,0.00,0.00),('5','107','706','232631',4474318,'2898','291',2903711.96,2908980.44,5268.48,1712256.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','232631',4474319,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','232875',4478534,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','232875',4478535,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','232875',4478536,'1877','290',798368.23,801566.64,3198.41,521340.83,0.00,0.00,0.00,0.00,0.00),('5','107','696','232875',4478537,'1878','290',180222.35,180222.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','232875',4478538,'1879','290',862260.17,864385.98,2125.81,346507.03,0.00,0.00,0.00,0.00,0.00),('5','107','696','232875',4478539,'1880','290',105153.65,105153.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','232875',4478540,'1881','290',1200334.26,1200334.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','232875',4478541,'1882','290',1128914.90,1130131.00,1216.10,198224.30,0.00,0.00,0.00,0.00,0.00),('5','107','697','232875',4478542,'1883','290',546913.12,546913.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','232875',4478543,'1884','290',115114.05,115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','232875',4478544,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','232875',4478545,'1886','290',2177867.89,2179469.60,1601.71,261078.73,0.00,0.00,0.00,0.00,0.00),('5','107','697','232875',4478546,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','232875',4478547,'1888','290',167063.49,167063.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','232875',4478548,'1889','290',3077735.12,3081460.19,3725.07,607186.41,0.00,0.00,0.00,0.00,0.00),('5','107','696','232875',4478549,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','232875',4478550,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','232875',4478551,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','232875',4478552,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','232875',4478553,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','232875',4478554,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','232875',4478555,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','232875',4478556,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','232875',4478557,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','232875',4478558,'1899','290',1920934.49,1920934.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','232875',4478559,'1900','290',449544.37,449544.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','232875',4478560,'1901','290',1112672.83,1112672.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','232875',4478561,'1902','290',39857.43,39857.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','232875',4478562,'1903','290',1138097.22,1140969.40,2872.18,468165.34,0.00,0.00,0.00,0.00,0.00),('5','107','700','232875',4478563,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','232875',4478564,'1905','290',1480137.24,1480137.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','232875',4478565,'1906','290',663547.31,665307.35,1760.04,286886.52,0.00,0.00,0.00,0.00,0.00),('5','107','701','232875',4478566,'1907','290',1991949.72,1993664.48,1714.76,279505.88,0.00,0.00,0.00,0.00,0.00),('5','107','701','232875',4478567,'1908','290',633249.18,636779.88,3530.70,575504.10,0.00,0.00,0.00,0.00,0.00),('5','107','701','232875',4478568,'1909','290',526979.62,533372.98,6393.36,1042117.68,0.00,0.00,0.00,0.00,0.00),('5','107','701','232875',4478569,'1910','290',391050.05,391050.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','232875',4478570,'1911','290',1129332.41,1133411.07,4078.66,664821.58,0.00,0.00,0.00,0.00,0.00),('5','107','702','232875',4478571,'1912','290',196496.77,197059.24,562.47,91682.61,0.00,0.00,0.00,0.00,0.00),('5','107','702','232875',4478572,'1913','290',610092.47,613135.81,3043.34,496064.42,0.00,0.00,0.00,0.00,0.00),('5','107','702','232875',4478573,'1914','290',64509.28,65099.42,590.14,96192.82,0.00,0.00,0.00,0.00,0.00),('5','107','702','232875',4478574,'1915','290',237829.98,238718.28,888.30,144792.90,0.00,0.00,0.00,0.00,0.00),('5','107','702','232875',4478575,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','232875',4478576,'1917','290',1032291.32,1032291.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','232875',4478577,'1918','290',147422.05,147422.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','232875',4478578,'1919','290',485631.89,485631.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','232875',4478579,'1920','290',105980.80,105980.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','232875',4478580,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','232875',4478581,'1922','290',153138.18,153138.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','232875',4478582,'1923','290',721025.00,721025.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','232875',4478583,'1924','290',160649.67,160649.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','232875',4478584,'1925','290',1643250.01,1647229.57,3979.56,648668.28,0.00,0.00,0.00,0.00,0.00),('5','107','705','232875',4478585,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','232875',4478586,'1927','290',483387.39,483387.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','232875',4478587,'1928','290',117131.20,120034.24,2903.04,473195.52,0.00,0.00,0.00,0.00,0.00),('5','107','706','232875',4478588,'1929','291',3689620.84,3698934.50,9313.66,3026939.50,0.00,0.00,0.00,0.00,0.00),('5','107','706','232875',4478589,'1930','291',2536888.04,2543140.19,6252.15,2031948.75,0.00,0.00,0.00,0.00,0.00),('5','107','706','232875',4478590,'1931','291',3738947.02,3743976.88,5029.86,1634704.50,0.00,0.00,0.00,0.00,0.00),('5','107','706','232875',4478591,'1932','291',3197393.32,3206194.12,8800.80,2860260.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','232875',4478592,'1933','291',4278642.21,4288574.33,9932.12,3227939.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','232875',4478593,'1934','291',1648338.56,1655233.53,6894.97,2240865.25,0.00,0.00,0.00,0.00,0.00),('5','107','706','232875',4478594,'2898','291',2908980.44,2916299.93,7319.49,2378834.25,0.00,0.00,0.00,0.00,0.00),('5','107','708','232875',4478595,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','233048',4481881,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','233048',4481882,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','233048',4481883,'1877','290',801566.64,801566.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','233048',4481884,'1878','290',180222.35,180222.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','233048',4481885,'1879','290',864385.98,864385.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','233048',4481886,'1880','290',105153.65,105153.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','233048',4481887,'1881','290',1200334.26,1200334.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','233048',4481888,'1882','290',1130131.00,1130131.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','233048',4481889,'1883','290',546913.12,546913.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','233048',4481890,'1884','290',115114.05,115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','233048',4481891,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','233048',4481892,'1886','290',2179469.60,2179469.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','233048',4481893,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','233048',4481894,'1888','290',167063.49,167063.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','233048',4481895,'1889','290',3081460.19,3081460.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','233048',4481896,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','233048',4481897,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','233048',4481898,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','233048',4481899,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','233048',4481900,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','233048',4481901,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','233048',4481902,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','233048',4481903,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','233048',4481904,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','233048',4481905,'1899','290',1920934.49,1920934.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','233048',4481906,'1900','290',449544.37,449544.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','233048',4481907,'1901','290',1112672.83,1112672.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','233048',4481908,'1902','290',39857.43,39857.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','233048',4481909,'1903','290',1140969.40,1140969.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','233048',4481910,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','233048',4481911,'1905','290',1480137.24,1480137.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','233048',4481912,'1906','290',665307.35,665307.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','233048',4481913,'1907','290',1993664.48,1993664.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','233048',4481914,'1908','290',636779.88,636779.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','233048',4481915,'1909','290',533372.98,533372.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','233048',4481916,'1910','290',391050.05,391050.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','233048',4481917,'1911','290',1133411.07,1133411.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','233048',4481918,'1912','290',197059.24,197059.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','233048',4481919,'1913','290',613135.81,613135.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','233048',4481920,'1914','290',65099.42,65099.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','233048',4481921,'1915','290',238718.28,238718.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','233048',4481922,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','233048',4481923,'1917','290',1032291.32,1032291.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','233048',4481924,'1918','290',147422.05,147422.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','233048',4481925,'1919','290',485631.89,485631.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','233048',4481926,'1920','290',105980.80,105980.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','233048',4481927,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','233048',4481928,'1922','290',153138.18,153138.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','233048',4481929,'1923','290',721025.00,721025.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','233048',4481930,'1924','290',160649.67,160649.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','233048',4481931,'1925','290',1647229.57,1647229.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','233048',4481932,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','233048',4481933,'1927','290',483387.39,483387.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','233048',4481934,'1928','290',120034.24,120034.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','233048',4481935,'1929','291',3698934.50,3699346.70,412.20,136026.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','233048',4481936,'1930','291',2543140.19,2546635.50,3495.31,1153452.30,0.00,0.00,0.00,0.00,0.00),('5','107','706','233048',4481937,'1931','291',3743976.88,3744890.57,913.69,301517.70,0.00,0.00,0.00,0.00,0.00),('5','107','706','233048',4481938,'1932','291',3206194.12,3206914.94,720.82,237870.60,0.00,0.00,0.00,0.00,0.00),('5','107','706','233048',4481939,'1933','291',4288574.33,4289778.30,1203.97,397310.10,0.00,0.00,0.00,0.00,0.00),('5','107','708','233048',4481940,'1934','291',1655233.53,1655233.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','233048',4481941,'2898','291',2916299.93,2917343.22,1043.29,344285.70,0.00,0.00,0.00,0.00,0.00),('5','107','708','233048',4481942,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','233055',4482099,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','233055',4482100,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','233055',4482101,'1877','290',801566.64,801566.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','233055',4482102,'1878','290',180222.35,180222.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','233055',4482103,'1879','290',864385.98,864385.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','233055',4482104,'1880','290',105153.65,105153.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','233055',4482105,'1881','290',1200334.26,1200334.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','233055',4482106,'1882','290',1130131.00,1130131.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','233055',4482107,'1883','290',546913.12,546913.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','233055',4482108,'1884','290',115114.05,115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','233055',4482109,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','233055',4482110,'1886','290',2179469.60,2179469.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','233055',4482111,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','233055',4482112,'1888','290',167063.49,167063.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','233055',4482113,'1889','290',3081460.19,3081460.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','233055',4482114,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','233055',4482115,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','233055',4482116,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','233055',4482117,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','233055',4482118,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','233055',4482119,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','233055',4482120,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','233055',4482121,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','233055',4482122,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','233055',4482123,'1899','290',1920934.49,1920934.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','233055',4482124,'1900','290',449544.37,449544.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','233055',4482125,'1901','290',1112672.83,1112672.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','233055',4482126,'1902','290',39857.43,39857.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','233055',4482127,'1903','290',1140969.40,1140969.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','233055',4482128,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','233055',4482129,'1905','290',1480137.24,1480137.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','233055',4482130,'1906','290',665307.35,665307.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','233055',4482131,'1907','290',1993664.48,1998422.07,4757.59,775487.17,0.00,0.00,0.00,0.00,0.00),('5','107','701','233055',4482132,'1908','290',636779.88,644282.39,7502.51,1222909.13,0.00,0.00,0.00,0.00,0.00),('5','107','701','233055',4482133,'1909','290',533372.98,544396.64,11023.66,1796856.58,0.00,0.00,0.00,0.00,0.00),('5','107','701','233055',4482134,'1910','290',391050.05,391050.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','233055',4482135,'1911','290',1133411.07,1137416.87,4005.80,652945.40,0.00,0.00,0.00,0.00,0.00),('5','107','702','233055',4482136,'1912','290',197059.24,197317.45,258.21,42088.23,0.00,0.00,0.00,0.00,0.00),('5','107','702','233055',4482137,'1913','290',613135.81,616511.00,3375.19,550155.97,0.00,0.00,0.00,0.00,0.00),('5','107','702','233055',4482138,'1914','290',65099.42,65383.00,283.58,46223.54,0.00,0.00,0.00,0.00,0.00),('5','107','702','233055',4482139,'1915','290',238718.28,239905.29,1187.01,193482.63,0.00,0.00,0.00,0.00,0.00),('5','107','702','233055',4482140,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','233055',4482141,'1917','290',1032291.32,1032291.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','233055',4482142,'1918','290',147422.05,147422.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','233055',4482143,'1919','290',485631.89,485631.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','233055',4482144,'1920','290',105980.80,105980.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','233055',4482145,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','233055',4482146,'1922','290',153138.18,153138.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','233055',4482147,'1923','290',721025.00,721025.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','233055',4482148,'1924','290',160649.67,160649.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','233055',4482149,'1925','290',1647229.57,1652791.43,5561.86,906583.18,0.00,0.00,0.00,0.00,0.00),('5','107','705','233055',4482150,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','233055',4482151,'1927','290',483387.39,483387.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','233055',4482152,'1928','290',120034.24,127013.16,6978.92,1137563.96,0.00,0.00,0.00,0.00,0.00),('5','107','706','233055',4482153,'1929','291',3699346.70,3704286.09,4939.39,1704089.55,0.00,0.00,0.00,0.00,0.00),('5','107','706','233055',4482154,'1930','291',2546635.50,2551289.87,4654.37,1605757.65,0.00,0.00,0.00,0.00,0.00),('5','107','706','233055',4482155,'1931','291',3744890.57,3748567.00,3676.43,1268368.35,0.00,0.00,0.00,0.00,0.00),('5','107','706','233055',4482156,'1932','291',3206914.94,3211173.45,4258.51,1469185.95,0.00,0.00,0.00,0.00,0.00),('5','107','706','233055',4482157,'1933','291',4289778.30,4293357.03,3578.73,1234661.85,0.00,0.00,0.00,0.00,0.00),('5','107','708','233055',4482158,'1934','291',1655233.53,1659513.05,4279.52,1476434.40,0.00,0.00,0.00,0.00,0.00),('5','107','706','233055',4482159,'2898','291',2917343.22,2920801.75,3458.53,1193192.85,0.00,0.00,0.00,0.00,0.00),('5','107','708','233055',4482160,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','233278',4486027,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','233278',4486028,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','233278',4486029,'1877','290',801566.64,801566.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','233278',4486030,'1878','290',180222.35,180222.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','233278',4486031,'1879','290',864385.98,864385.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','233278',4486032,'1880','290',105153.65,105153.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','233278',4486033,'1881','290',1200334.26,1200334.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','233278',4486034,'1882','290',1130131.00,1136284.76,6153.76,1003062.88,0.00,0.00,0.00,0.00,0.00),('5','107','697','233278',4486035,'1883','290',546913.12,546913.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','233278',4486036,'1884','290',115114.05,115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','233278',4486037,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','233278',4486038,'1886','290',2179469.60,2187667.08,8197.48,1336189.24,0.00,0.00,0.00,0.00,0.00),('5','107','697','233278',4486039,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','233278',4486040,'1888','290',167063.49,167063.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','233278',4486041,'1889','290',3081460.19,3081460.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','233278',4486042,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','233278',4486043,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','233278',4486044,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','233278',4486045,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','233278',4486046,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','233278',4486047,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','233278',4486048,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','233278',4486049,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','233278',4486050,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','233278',4486051,'1899','290',1920934.49,1920934.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','233278',4486052,'1900','290',449544.37,455154.55,5610.18,914459.34,0.00,0.00,0.00,0.00,0.00),('5','107','699','233278',4486053,'1901','290',1112672.83,1117904.45,5231.62,852754.06,0.00,0.00,0.00,0.00,0.00),('5','107','699','233278',4486054,'1902','290',39857.43,39857.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','233278',4486055,'1903','290',1140969.40,1140969.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','233278',4486056,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','233278',4486057,'1905','290',1480137.24,1480137.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','233278',4486058,'1906','290',665307.35,665307.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','233278',4486059,'1907','290',1998422.07,1998422.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','233278',4486060,'1908','290',644282.39,646104.54,1822.15,297010.45,0.00,0.00,0.00,0.00,0.00),('5','107','701','233278',4486061,'1909','290',544396.64,546601.10,2204.46,359326.98,0.00,0.00,0.00,0.00,0.00),('5','107','701','233278',4486062,'1910','290',391050.05,391050.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','233278',4486063,'1911','290',1137416.87,1142513.18,5096.31,830698.53,0.00,0.00,0.00,0.00,0.00),('5','107','702','233278',4486064,'1912','290',197317.45,197317.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','233278',4486065,'1913','290',616511.00,619784.17,3273.17,533526.71,0.00,0.00,0.00,0.00,0.00),('5','107','702','233278',4486066,'1914','290',65383.00,65383.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','233278',4486067,'1915','290',239905.29,239905.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','233278',4486068,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','233278',4486069,'1917','290',1032291.32,1032291.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','233278',4486070,'1918','290',147422.05,147422.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','233278',4486071,'1919','290',485631.89,485631.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','233278',4486072,'1920','290',105980.80,105980.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','233278',4486073,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','233278',4486074,'1922','290',153138.18,156869.41,3731.23,608190.49,0.00,0.00,0.00,0.00,0.00),('5','107','704','233278',4486075,'1923','290',721025.00,721025.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','233278',4486076,'1924','290',160649.67,166286.29,5636.62,918769.06,0.00,0.00,0.00,0.00,0.00),('5','107','705','233278',4486077,'1925','290',1652791.43,1652791.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','233278',4486078,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','233278',4486079,'1927','290',483387.39,483387.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','233278',4486080,'1928','290',127013.16,127013.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','233278',4486081,'1929','291',3704286.09,3710231.75,5945.66,2051252.70,0.00,0.00,0.00,0.00,0.00),('5','107','706','233278',4486082,'1930','291',2551289.87,2557371.81,6081.94,2098269.30,0.00,0.00,0.00,0.00,0.00),('5','107','706','233278',4486083,'1931','291',3748567.00,3753358.88,4791.88,1653198.60,0.00,0.00,0.00,0.00,0.00),('5','107','706','233278',4486084,'1932','291',3211173.45,3216480.98,5307.53,1831097.85,0.00,0.00,0.00,0.00,0.00),('5','107','706','233278',4486085,'1933','291',4293357.03,4300758.61,7401.58,2553545.10,0.00,0.00,0.00,0.00,0.00),('5','107','708','233278',4486086,'1934','291',1659513.05,1661222.59,1709.54,589791.30,0.00,0.00,0.00,0.00,0.00),('5','107','706','233278',4486087,'2898','291',2920801.75,2927375.72,6573.97,2268019.65,0.00,0.00,0.00,0.00,0.00),('5','107','708','233278',4486088,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','233546',4490980,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','233546',4490981,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','233546',4490982,'1877','290',801566.64,802959.56,1392.92,227045.96,0.00,0.00,0.00,0.00,0.00),('5','107','696','233546',4490983,'1878','290',180222.35,180222.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','233546',4490984,'1879','290',864385.98,864805.47,419.49,68376.87,0.00,0.00,0.00,0.00,0.00),('5','107','696','233546',4490985,'1880','290',105153.65,105153.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','233546',4490986,'1881','290',1200334.26,1200334.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','233546',4490987,'1882','290',1136284.76,1136634.72,349.96,57043.48,0.00,0.00,0.00,0.00,0.00),('5','107','697','233546',4490988,'1883','290',546913.12,546913.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','233546',4490989,'1884','290',115114.05,115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','233546',4490990,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','233546',4490991,'1886','290',2187667.08,2193743.09,6076.01,990389.63,0.00,0.00,0.00,0.00,0.00),('5','107','697','233546',4490992,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','233546',4490993,'1888','290',167063.49,167063.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','233546',4490994,'1889','290',3081460.19,3086740.00,5279.81,860609.03,0.00,0.00,0.00,0.00,0.00),('5','107','696','233546',4490995,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','233546',4490996,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','233546',4490997,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','233546',4490998,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','233546',4490999,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','233546',4491000,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','233546',4491001,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','233546',4491002,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','233546',4491003,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','233546',4491004,'1899','290',1920934.49,1920934.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','233546',4491005,'1900','290',455154.55,457889.67,2735.12,445824.56,0.00,0.00,0.00,0.00,0.00),('5','107','699','233546',4491006,'1901','290',1117904.45,1122878.52,4974.07,810773.41,0.00,0.00,0.00,0.00,0.00),('5','107','699','233546',4491007,'1902','290',39857.43,39857.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','233546',4491008,'1903','290',1140969.40,1140969.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','233546',4491009,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','233546',4491010,'1905','290',1480137.24,1480137.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','233546',4491011,'1906','290',665307.35,665307.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','233546',4491012,'1907','290',1998422.07,2003936.11,5514.04,898788.52,0.00,0.00,0.00,0.00,0.00),('5','107','701','233546',4491013,'1908','290',646104.54,646104.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','233546',4491014,'1909','290',546601.10,551340.98,4739.88,772600.44,0.00,0.00,0.00,0.00,0.00),('5','107','701','233546',4491015,'1910','290',391050.05,391050.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','233546',4491016,'1911','290',1142513.18,1145580.97,3067.79,500049.77,0.00,0.00,0.00,0.00,0.00),('5','107','702','233546',4491017,'1912','290',197317.45,197317.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','233546',4491018,'1913','290',619784.17,620587.53,803.36,130947.68,0.00,0.00,0.00,0.00,0.00),('5','107','702','233546',4491019,'1914','290',65383.00,65383.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','233546',4491020,'1915','290',239905.29,240291.15,385.86,62895.18,0.00,0.00,0.00,0.00,0.00),('5','107','702','233546',4491021,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','233546',4491022,'1917','290',1032291.32,1032291.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','233546',4491023,'1918','290',147422.05,147422.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','233546',4491024,'1919','290',485631.89,485631.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','233546',4491025,'1920','290',105980.80,105980.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','233546',4491026,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','233546',4491027,'1922','290',156869.41,159187.37,2317.96,377827.48,0.00,0.00,0.00,0.00,0.00),('5','107','704','233546',4491028,'1923','290',721025.00,721025.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','233546',4491029,'1924','290',166286.29,169970.37,3684.08,600505.04,0.00,0.00,0.00,0.00,0.00),('5','107','705','233546',4491030,'1925','290',1652791.43,1652791.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','233546',4491031,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','233546',4491032,'1927','290',483387.39,483387.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','233546',4491033,'1928','290',127013.16,127013.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','233546',4491034,'1929','291',3710231.75,3717486.64,7254.89,2502937.05,0.00,0.00,0.00,0.00,0.00),('5','107','706','233546',4491035,'1930','291',2557371.81,2564725.29,7353.48,2536950.60,0.00,0.00,0.00,0.00,0.00),('5','107','706','233546',4491036,'1931','291',3753358.88,3761966.16,8607.28,2969511.60,0.00,0.00,0.00,0.00,0.00),('5','107','706','233546',4491037,'1932','291',3216480.98,3225072.15,8591.17,2963953.65,0.00,0.00,0.00,0.00,0.00),('5','107','706','233546',4491038,'1933','291',4300758.61,4307424.11,6665.50,2299597.50,0.00,0.00,0.00,0.00,0.00),('5','107','708','233546',4491039,'1934','291',1661222.59,1671409.58,10186.99,3514511.55,0.00,0.00,0.00,0.00,0.00),('5','107','706','233546',4491040,'2898','291',2927375.72,2934138.33,6762.61,2333100.45,0.00,0.00,0.00,0.00,0.00),('5','107','708','233546',4491041,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','233899',4497170,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','233899',4497171,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','233899',4497172,'1877','290',802959.56,806312.95,3353.39,546602.57,0.00,0.00,0.00,0.00,0.00),('5','107','696','233899',4497173,'1878','290',180222.35,180222.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','233899',4497174,'1879','290',864805.47,864805.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','233899',4497175,'1880','290',105153.65,105153.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','233899',4497176,'1881','290',1200334.26,1200334.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','233899',4497177,'1882','290',1136634.72,1142505.24,5870.52,956894.76,0.00,0.00,0.00,0.00,0.00),('5','107','697','233899',4497178,'1883','290',546913.12,546913.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','233899',4497179,'1884','290',115114.05,115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','233899',4497180,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','233899',4497181,'1886','290',2193743.09,2200130.83,6387.74,1041201.62,0.00,0.00,0.00,0.00,0.00),('5','107','697','233899',4497182,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','233899',4497183,'1888','290',167063.49,167063.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','233899',4497184,'1889','290',3086740.00,3093354.00,6614.00,1078082.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','233899',4497185,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','233899',4497186,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','233899',4497187,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','233899',4497188,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','233899',4497189,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','233899',4497190,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','233899',4497191,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','233899',4497192,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','233899',4497193,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','233899',4497194,'1899','290',1920934.49,1920934.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','233899',4497195,'1900','290',457889.67,459623.62,1733.95,282633.85,0.00,0.00,0.00,0.00,0.00),('5','107','699','233899',4497196,'1901','290',1122878.52,1127639.88,4761.36,776101.68,0.00,0.00,0.00,0.00,0.00),('5','107','699','233899',4497197,'1902','290',39857.43,39857.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','233899',4497198,'1903','290',1140969.40,1140969.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','233899',4497199,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','233899',4497200,'1905','290',1480137.24,1480137.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','233899',4497201,'1906','290',665307.35,665307.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','233899',4497202,'1907','290',2003936.11,2009442.00,5505.89,897460.07,0.00,0.00,0.00,0.00,0.00),('5','107','701','233899',4497203,'1908','290',646104.54,646104.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','233899',4497204,'1909','290',551340.98,554152.00,2811.02,458196.26,0.00,0.00,0.00,0.00,0.00),('5','107','701','233899',4497205,'1910','290',391050.05,391050.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','233899',4497206,'1911','290',1145580.97,1150260.00,4679.03,762681.89,0.00,0.00,0.00,0.00,0.00),('5','107','702','233899',4497207,'1912','290',197317.45,197317.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','233899',4497208,'1913','290',620587.53,620624.00,36.47,5944.61,0.00,0.00,0.00,0.00,0.00),('5','107','702','233899',4497209,'1914','290',65383.00,65383.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','233899',4497210,'1915','290',240291.15,240291.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','233899',4497211,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','233899',4497212,'1917','290',1032291.32,1032291.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','233899',4497213,'1918','290',147422.05,147422.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','233899',4497214,'1919','290',485631.89,485631.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','233899',4497215,'1920','290',105980.80,105980.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','233899',4497216,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','233899',4497217,'1922','290',159187.37,164233.24,5045.87,822476.81,0.00,0.00,0.00,0.00,0.00),('5','107','704','233899',4497218,'1923','290',721025.00,721025.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','233899',4497219,'1924','290',169970.37,172294.91,2324.54,378900.02,0.00,0.00,0.00,0.00,0.00),('5','107','705','233899',4497220,'1925','290',1652791.43,1652791.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','233899',4497221,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','233899',4497222,'1927','290',483387.39,483387.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','233899',4497223,'1928','290',127013.16,127013.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','233899',4497224,'1929','291',3717486.64,3724339.79,6853.15,2364336.75,0.00,0.00,0.00,0.00,0.00),('5','107','706','233899',4497225,'1930','291',2564725.29,2573424.59,8699.30,3001258.50,0.00,0.00,0.00,0.00,0.00),('5','107','706','233899',4497226,'1931','291',3761966.16,3767493.26,5527.10,1906849.50,0.00,0.00,0.00,0.00,0.00),('5','107','706','233899',4497227,'1932','291',3225072.15,3232349.42,7277.27,2510658.15,0.00,0.00,0.00,0.00,0.00),('5','107','706','233899',4497228,'1933','291',4307424.11,4314656.63,7232.52,2495219.40,0.00,0.00,0.00,0.00,0.00),('5','107','708','233899',4497229,'1934','291',1671409.58,1675356.53,3946.95,1361697.75,0.00,0.00,0.00,0.00,0.00),('5','107','706','233899',4497230,'2898','291',2934138.33,2939628.08,5489.75,1893963.75,0.00,0.00,0.00,0.00,0.00),('5','107','708','233899',4497231,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','234086',4500425,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','234086',4500426,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','234086',4500427,'1877','290',806312.95,810704.96,4392.01,715897.63,0.00,0.00,0.00,0.00,0.00),('5','107','696','234086',4500428,'1878','290',180222.35,180222.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','234086',4500429,'1879','290',864805.47,864845.95,40.48,6598.24,0.00,0.00,0.00,0.00,0.00),('5','107','696','234086',4500430,'1880','290',105153.65,105153.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','234086',4500431,'1881','290',1200334.26,1200334.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','234086',4500432,'1882','290',1142505.24,1143317.36,812.12,132375.56,0.00,0.00,0.00,0.00,0.00),('5','107','697','234086',4500433,'1883','290',546913.12,546913.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','234086',4500434,'1884','290',115114.05,115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','234086',4500435,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','234086',4500436,'1886','290',2200130.83,2201269.13,1138.30,185542.90,0.00,0.00,0.00,0.00,0.00),('5','107','697','234086',4500437,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','234086',4500438,'1888','290',167063.49,167063.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','234086',4500439,'1889','290',3093354.00,3099243.00,5889.00,959907.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','234086',4500440,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','234086',4500441,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','234086',4500442,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','234086',4500443,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','234086',4500444,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','234086',4500445,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','234086',4500446,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','234086',4500447,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','234086',4500448,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','234086',4500449,'1899','290',1920934.49,1920934.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','234086',4500450,'1900','290',459623.62,463503.20,3879.58,632371.54,0.00,0.00,0.00,0.00,0.00),('5','107','699','234086',4500451,'1901','290',1127639.88,1131471.69,3831.81,624585.03,0.00,0.00,0.00,0.00,0.00),('5','107','699','234086',4500452,'1902','290',39857.43,42484.15,2626.72,428155.36,0.00,0.00,0.00,0.00,0.00),('5','107','700','234086',4500453,'1903','290',1140969.40,1140969.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','234086',4500454,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','234086',4500455,'1905','290',1480137.24,1480137.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','234086',4500456,'1906','290',665307.35,665307.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','234086',4500457,'1907','290',2009442.00,2015620.23,6178.23,1007051.49,0.00,0.00,0.00,0.00,0.00),('5','107','701','234086',4500458,'1908','290',646104.54,646104.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','234086',4500459,'1909','290',554152.00,556626.12,2474.12,403281.56,0.00,0.00,0.00,0.00,0.00),('5','107','701','234086',4500460,'1910','290',391050.05,391050.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','234086',4500461,'1911','290',1150260.00,1153988.68,3728.68,607774.84,0.00,0.00,0.00,0.00,0.00),('5','107','702','234086',4500462,'1912','290',197317.45,197317.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','234086',4500463,'1913','290',620624.00,622266.99,1642.99,267807.37,0.00,0.00,0.00,0.00,0.00),('5','107','702','234086',4500464,'1914','290',65383.00,65383.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','234086',4500465,'1915','290',240291.15,240291.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','234086',4500466,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','234086',4500467,'1917','290',1032291.32,1032291.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','234086',4500468,'1918','290',147422.05,147422.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','234086',4500469,'1919','290',485631.89,485631.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','234086',4500470,'1920','290',105980.80,105980.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','234086',4500471,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','234086',4500472,'1922','290',164233.24,167638.67,3405.43,555085.09,0.00,0.00,0.00,0.00,0.00),('5','107','704','234086',4500473,'1923','290',721025.00,721025.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','234086',4500474,'1924','290',172294.91,176136.08,3841.17,626110.71,0.00,0.00,0.00,0.00,0.00),('5','107','705','234086',4500475,'1925','290',1652791.43,1652791.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','234086',4500476,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','234086',4500477,'1927','290',483387.39,483387.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','234086',4500478,'1928','290',127013.16,127013.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','234086',4500479,'1929','291',3724339.79,3729706.87,5367.08,1851642.60,0.00,0.00,0.00,0.00,0.00),('5','107','706','234086',4500480,'1930','291',2573424.59,2581120.92,7696.33,2655233.85,0.00,0.00,0.00,0.00,0.00),('5','107','706','234086',4500481,'1931','291',3767493.26,3770527.00,3033.74,1046640.30,0.00,0.00,0.00,0.00,0.00),('5','107','706','234086',4500482,'1932','291',3232349.42,3238680.66,6331.24,2184277.80,0.00,0.00,0.00,0.00,0.00),('5','107','706','234086',4500483,'1933','291',4314656.63,4321020.18,6363.55,2195424.75,0.00,0.00,0.00,0.00,0.00),('5','107','708','234086',4500484,'1934','291',1675356.53,1681035.78,5679.25,1959341.25,0.00,0.00,0.00,0.00,0.00),('5','107','706','234086',4500485,'2898','291',2939628.08,2943565.98,3937.90,1358575.50,0.00,0.00,0.00,0.00,0.00),('5','107','708','234086',4500486,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','234427',4506829,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','234427',4506830,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','234427',4506831,'1877','290',810704.96,814900.70,4195.74,683905.62,0.00,0.00,0.00,0.00,0.00),('5','107','696','234427',4506832,'1878','290',180222.35,180222.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','234427',4506833,'1879','290',864845.95,864845.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','234427',4506834,'1880','290',105153.65,105153.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','234427',4506835,'1881','290',1200334.26,1200334.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','234427',4506836,'1882','290',1143317.36,1143317.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','234427',4506837,'1883','290',546913.12,546913.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','234427',4506838,'1884','290',115114.05,115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','234427',4506839,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','234427',4506840,'1886','290',2201269.13,2201269.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','234427',4506841,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','234427',4506842,'1888','290',167063.49,167063.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','234427',4506843,'1889','290',3099243.00,3104045.00,4802.00,782726.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','234427',4506844,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','234427',4506845,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','234427',4506846,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','234427',4506847,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','234427',4506848,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','234427',4506849,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','234427',4506850,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','234427',4506851,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','234427',4506852,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','234427',4506853,'1899','290',1920934.49,1920934.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','234427',4506854,'1900','290',463503.20,468639.59,5136.39,837231.57,0.00,0.00,0.00,0.00,0.00),('5','107','699','234427',4506855,'1901','290',1131471.69,1133311.98,1840.29,299967.27,0.00,0.00,0.00,0.00,0.00),('5','107','699','234427',4506856,'1902','290',42484.15,44342.17,1858.02,302857.26,0.00,0.00,0.00,0.00,0.00),('5','107','700','234427',4506857,'1903','290',1140969.40,1140969.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','234427',4506858,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','234427',4506859,'1905','290',1480137.24,1480137.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','234427',4506860,'1906','290',665307.35,668993.05,3685.70,600769.10,0.00,0.00,0.00,0.00,0.00),('5','107','701','234427',4506861,'1907','290',2015620.23,2018590.29,2970.06,484119.78,0.00,0.00,0.00,0.00,0.00),('5','107','701','234427',4506862,'1908','290',646104.54,648901.06,2796.52,455832.76,0.00,0.00,0.00,0.00,0.00),('5','107','701','234427',4506863,'1909','290',556626.12,562085.32,5459.20,889849.60,0.00,0.00,0.00,0.00,0.00),('5','107','701','234427',4506864,'1910','290',391050.05,391050.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','234427',4506865,'1911','290',1153988.68,1156633.00,2644.32,431024.16,0.00,0.00,0.00,0.00,0.00),('5','107','702','234427',4506866,'1912','290',197317.45,197317.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','234427',4506867,'1913','290',622266.99,625740.18,3473.19,566129.97,0.00,0.00,0.00,0.00,0.00),('5','107','702','234427',4506868,'1914','290',65383.00,65383.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','234427',4506869,'1915','290',240291.15,241378.48,1087.33,177234.79,0.00,0.00,0.00,0.00,0.00),('5','107','702','234427',4506870,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','234427',4506871,'1917','290',1032291.32,1032291.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','234427',4506872,'1918','290',147422.05,147422.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','234427',4506873,'1919','290',485631.89,485631.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','234427',4506874,'1920','290',105980.80,105980.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','234427',4506875,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','234427',4506876,'1922','290',167638.67,171973.73,4335.06,706614.78,0.00,0.00,0.00,0.00,0.00),('5','107','704','234427',4506877,'1923','290',721025.00,721025.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','234427',4506878,'1924','290',176136.08,180308.95,4172.87,680177.81,0.00,0.00,0.00,0.00,0.00),('5','107','705','234427',4506879,'1925','290',1652791.43,1652791.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','234427',4506880,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','234427',4506881,'1927','290',483387.39,483387.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','234427',4506882,'1928','290',127013.16,127013.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','234427',4506883,'1929','291',3729706.87,3736802.35,7095.48,2447940.60,0.00,0.00,0.00,0.00,0.00),('5','107','706','234427',4506884,'1930','291',2581120.92,2588637.12,7516.20,2593089.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','234427',4506885,'1931','291',3770527.00,3777615.79,7088.79,2445632.55,0.00,0.00,0.00,0.00,0.00),('5','107','706','234427',4506886,'1932','291',3238680.66,3244673.53,5992.87,2067540.15,0.00,0.00,0.00,0.00,0.00),('5','107','706','234427',4506887,'1933','291',4321020.18,4327445.03,6424.85,2216573.25,0.00,0.00,0.00,0.00,0.00),('5','107','708','234427',4506888,'1934','291',1681035.78,1685208.39,4172.61,1439550.45,0.00,0.00,0.00,0.00,0.00),('5','107','706','234427',4506889,'2898','291',2943565.98,2947557.53,3991.55,1377084.75,0.00,0.00,0.00,0.00,0.00),('5','107','708','234427',4506890,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','234525',4508561,'1875','290',1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','234525',4508562,'1876','290',1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','234525',4508563,'1877','290',814900.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','234525',4508564,'1878','290',180222.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','234525',4508565,'1879','290',864845.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','234525',4508566,'1880','290',105153.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','234525',4508567,'1881','290',1200334.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','234525',4508568,'1882','290',1143317.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','234525',4508569,'1883','290',546913.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','234525',4508570,'1884','290',115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','234525',4508571,'1885','290',1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','234525',4508572,'1886','290',2201269.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','234525',4508573,'1887','290',205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','234525',4508574,'1888','290',167063.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','234525',4508575,'1889','290',3104045.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','234525',4508576,'1890','290',682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','234525',4508577,'1891','290',1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','234525',4508578,'1892','290',1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','234525',4508579,'1893','290',1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','234525',4508580,'1894','290',1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','234525',4508581,'1895','290',688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','234525',4508582,'1896','290',268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','234525',4508583,'1897','290',416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','234525',4508584,'1898','290',65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','234525',4508585,'1899','290',1920934.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','234525',4508586,'1900','290',468639.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','234525',4508587,'1901','290',1133311.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','234525',4508588,'1902','290',44342.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','234525',4508589,'1903','290',1140969.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','234525',4508590,'1904','290',1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','234525',4508591,'1905','290',1480137.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','234525',4508592,'1906','290',668993.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','234525',4508593,'1907','290',2018590.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','234525',4508594,'1908','290',648901.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','234525',4508595,'1909','290',562085.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','234525',4508596,'1910','290',391050.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','234525',4508597,'1911','290',1156633.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','234525',4508598,'1912','290',197317.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','234525',4508599,'1913','290',625740.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','234525',4508600,'1914','290',65383.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','234525',4508601,'1915','290',241378.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','234525',4508602,'1916','290',22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','234525',4508603,'1917','290',1032291.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','234525',4508604,'1918','290',147422.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','234525',4508605,'1919','290',485631.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','234525',4508606,'1920','290',105980.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','234525',4508607,'1921','290',922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','234525',4508608,'1922','290',171973.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','234525',4508609,'1923','290',721025.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','234525',4508610,'1924','290',180308.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','234525',4508611,'1925','290',1652791.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','234525',4508612,'1926','290',45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','234525',4508613,'1927','290',483387.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','234525',4508614,'1928','290',127013.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','234525',4508615,'1929','291',3736802.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','234525',4508616,'1930','291',2588637.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','234525',4508617,'1931','291',3777615.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','234525',4508618,'1932','291',3244673.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','234525',4508619,'1933','291',4327445.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','234525',4508620,'1934','291',1685208.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','234525',4508621,'2898','291',2947557.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','234525',4508622,'2899','291',3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','234612',4509922,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','234612',4509923,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','234612',4509924,'1877','290',814900.70,817086.39,2185.69,360638.85,0.00,0.00,0.00,0.00,0.00),('5','107','696','234612',4509925,'1878','290',180222.35,180985.69,763.34,125951.10,0.00,0.00,0.00,0.00,0.00),('5','107','696','234612',4509926,'1879','290',864845.95,865187.91,341.96,56423.40,0.00,0.00,0.00,0.00,0.00),('5','107','696','234612',4509927,'1880','290',105153.65,106255.71,1102.06,181839.90,0.00,0.00,0.00,0.00,0.00),('5','107','697','234612',4509928,'1881','290',1200334.26,1200334.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','234612',4509929,'1882','290',1143317.36,1145713.86,2396.50,395422.50,0.00,0.00,0.00,0.00,0.00),('5','107','697','234612',4509930,'1883','290',546913.12,547494.28,581.16,95891.40,0.00,0.00,0.00,0.00,0.00),('5','107','697','234612',4509931,'1884','290',115114.05,115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','234612',4509932,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','234612',4509933,'1886','290',2201269.13,2204744.86,3475.73,573495.45,0.00,0.00,0.00,0.00,0.00),('5','107','697','234612',4509934,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','234612',4509935,'1888','290',167063.49,167063.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','234612',4509936,'1889','290',3104045.00,3107812.46,3767.46,621630.90,0.00,0.00,0.00,0.00,0.00),('5','107','696','234612',4509937,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','234612',4509938,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','234612',4509939,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','234612',4509940,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','234612',4509941,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','234612',4509942,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','234612',4509943,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','234612',4509944,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','234612',4509945,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','234612',4509946,'1899','290',1920934.49,1920934.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','234612',4509947,'1900','290',468639.59,468657.77,18.18,2999.70,0.00,0.00,0.00,0.00,0.00),('5','107','699','234612',4509948,'1901','290',1133311.98,1133311.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','234612',4509949,'1902','290',44342.17,44520.92,178.75,29493.75,0.00,0.00,0.00,0.00,0.00),('5','107','700','234612',4509950,'1903','290',1140969.40,1147282.62,6313.22,1041681.30,0.00,0.00,0.00,0.00,0.00),('5','107','700','234612',4509951,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','234612',4509952,'1905','290',1480137.24,1480137.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','234612',4509953,'1906','290',668993.05,674903.17,5910.12,975169.80,0.00,0.00,0.00,0.00,0.00),('5','107','701','234612',4509954,'1907','290',2018590.29,2019175.00,584.71,96477.15,0.00,0.00,0.00,0.00,0.00),('5','107','701','234612',4509955,'1908','290',648901.06,649078.13,177.07,29216.55,0.00,0.00,0.00,0.00,0.00),('5','107','701','234612',4509956,'1909','290',562085.32,562324.49,239.17,39463.05,0.00,0.00,0.00,0.00,0.00),('5','107','701','234612',4509957,'1910','290',391050.05,391050.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','234612',4509958,'1911','290',1156633.00,1158098.98,1465.98,241886.70,0.00,0.00,0.00,0.00,0.00),('5','107','702','234612',4509959,'1912','290',197317.45,197317.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','234612',4509960,'1913','290',625740.18,626919.67,1179.49,194615.85,0.00,0.00,0.00,0.00,0.00),('5','107','702','234612',4509961,'1914','290',65383.00,65383.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','234612',4509962,'1915','290',241378.48,241378.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','234612',4509963,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','234612',4509964,'1917','290',1032291.32,1032291.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','234612',4509965,'1918','290',147422.05,147422.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','234612',4509966,'1919','290',485631.89,485631.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','234612',4509967,'1920','290',105980.80,105980.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','234612',4509968,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','234612',4509969,'1922','290',171973.73,174092.17,2118.44,349542.60,0.00,0.00,0.00,0.00,0.00),('5','107','704','234612',4509970,'1923','290',721025.00,721025.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','234612',4509971,'1924','290',180308.95,183421.58,3112.63,513583.95,0.00,0.00,0.00,0.00,0.00),('5','107','705','234612',4509972,'1925','290',1652791.43,1657252.50,4461.07,736076.55,0.00,0.00,0.00,0.00,0.00),('5','107','705','234612',4509973,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','234612',4509974,'1927','290',483387.39,483387.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','234612',4509975,'1928','290',127013.16,129243.36,2230.20,367983.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','234612',4509976,'1929','291',3736802.35,3743660.58,6858.23,2366089.35,0.00,0.00,0.00,0.00,0.00),('5','107','706','234612',4509977,'1930','291',2588637.12,2600349.04,11711.92,4040612.40,0.00,0.00,0.00,0.00,0.00),('5','107','706','234612',4509978,'1931','291',3777615.79,3781894.06,4278.27,1476003.15,0.00,0.00,0.00,0.00,0.00),('5','107','706','234612',4509979,'1932','291',3244673.53,3250637.93,5964.40,2057718.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','234612',4509980,'1933','291',4327445.03,4334737.37,7292.34,2515857.30,0.00,0.00,0.00,0.00,0.00),('5','107','708','234612',4509981,'1934','291',1685208.39,1687715.24,2506.85,864863.25,0.00,0.00,0.00,0.00,0.00),('5','107','706','234612',4509982,'2898','291',2947557.53,2953141.40,5583.87,1926435.15,0.00,0.00,0.00,0.00,0.00),('5','107','708','234612',4509983,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','234775',4513006,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','234775',4513007,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','234775',4513008,'1877','290',817086.39,817086.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','234775',4513009,'1878','290',180985.69,180985.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','234775',4513010,'1879','290',865187.91,865187.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','234775',4513011,'1880','290',106255.71,106255.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','234775',4513012,'1881','290',1200334.26,1200334.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','234775',4513013,'1882','290',1145713.86,1146243.41,529.55,87375.75,0.00,0.00,0.00,0.00,0.00),('5','107','697','234775',4513014,'1883','290',547494.28,548269.05,774.77,127837.05,0.00,0.00,0.00,0.00,0.00),('5','107','697','234775',4513015,'1884','290',115114.05,115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','234775',4513016,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','234775',4513017,'1886','290',2204744.86,2205873.95,1129.09,186299.85,0.00,0.00,0.00,0.00,0.00),('5','107','697','234775',4513018,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','234775',4513019,'1888','290',167063.49,167305.88,242.39,39994.35,0.00,0.00,0.00,0.00,0.00),('5','107','696','234775',4513020,'1889','290',3107812.46,3107812.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','234775',4513021,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','234775',4513022,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','234775',4513023,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','234775',4513024,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','234775',4513025,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','234775',4513026,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','234775',4513027,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','234775',4513028,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','234775',4513029,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','234775',4513030,'1899','290',1920934.49,1920934.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','234775',4513031,'1900','290',468657.77,468657.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','234775',4513032,'1901','290',1133311.98,1133311.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','234775',4513033,'1902','290',44520.92,44520.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','234775',4513034,'1903','290',1147282.62,1157451.83,10169.21,1677919.65,0.00,0.00,0.00,0.00,0.00),('5','107','700','234775',4513035,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','234775',4513036,'1905','290',1480137.24,1480849.88,712.64,117585.60,0.00,0.00,0.00,0.00,0.00),('5','107','700','234775',4513037,'1906','290',674903.17,686623.77,11720.60,1933899.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','234775',4513038,'1907','290',2019175.00,2019175.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','234775',4513039,'1908','290',649078.13,649078.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','234775',4513040,'1909','290',562324.49,562324.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','234775',4513041,'1910','290',391050.05,391050.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','234775',4513042,'1911','290',1158098.98,1159140.00,1041.02,171768.30,0.00,0.00,0.00,0.00,0.00),('5','107','702','234775',4513043,'1912','290',197317.45,197317.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','234775',4513044,'1913','290',626919.67,626919.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','234775',4513045,'1914','290',65383.00,65383.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','234775',4513046,'1915','290',241378.48,241378.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','234775',4513047,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','234775',4513048,'1917','290',1032291.32,1032355.98,64.66,10668.90,0.00,0.00,0.00,0.00,0.00),('5','107','703','234775',4513049,'1918','290',147422.05,152410.86,4988.81,823153.65,0.00,0.00,0.00,0.00,0.00),('5','107','703','234775',4513050,'1919','290',485631.89,489434.28,3802.39,627394.35,0.00,0.00,0.00,0.00,0.00),('5','107','703','234775',4513051,'1920','290',105980.80,107827.14,1846.34,304646.10,0.00,0.00,0.00,0.00,0.00),('5','107','704','234775',4513052,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','234775',4513053,'1922','290',174092.17,174092.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','234775',4513054,'1923','290',721025.00,721025.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','234775',4513055,'1924','290',183421.58,183421.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','234775',4513056,'1925','290',1657252.50,1661400.28,4147.78,684383.70,0.00,0.00,0.00,0.00,0.00),('5','107','705','234775',4513057,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','234775',4513058,'1927','290',483387.39,483387.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','234775',4513059,'1928','290',129243.36,132701.40,3458.04,570576.60,0.00,0.00,0.00,0.00,0.00),('5','107','706','234775',4513060,'1929','291',3743660.58,3748200.14,4539.56,1566148.20,0.00,0.00,0.00,0.00,0.00),('5','107','706','234775',4513061,'1930','291',2600349.04,2607598.75,7249.71,2501149.95,0.00,0.00,0.00,0.00,0.00),('5','107','706','234775',4513062,'1931','291',3781894.06,3787468.88,5574.82,1923312.90,0.00,0.00,0.00,0.00,0.00),('5','107','706','234775',4513063,'1932','291',3250637.93,3258217.39,7579.46,2614913.70,0.00,0.00,0.00,0.00,0.00),('5','107','706','234775',4513064,'1933','291',4334737.37,4340269.72,5532.35,1908660.75,0.00,0.00,0.00,0.00,0.00),('5','107','708','234775',4513065,'1934','291',1687715.24,1689552.32,1837.08,633792.60,0.00,0.00,0.00,0.00,0.00),('5','107','706','234775',4513066,'2898','291',2953141.40,2958151.07,5009.67,1728336.15,0.00,0.00,0.00,0.00,0.00),('5','107','708','234775',4513067,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','235154',4519676,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','235154',4519677,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','235154',4519678,'1877','290',817086.39,817086.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','235154',4519679,'1878','290',180985.69,180985.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','235154',4519680,'1879','290',865187.91,865187.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','235154',4519681,'1880','290',106255.71,106255.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','235154',4519682,'1881','290',1200334.26,1200334.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','235154',4519683,'1882','290',1146243.41,1146243.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','235154',4519684,'1883','290',548269.05,548269.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','235154',4519685,'1884','290',115114.05,115114.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','235154',4519686,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','235154',4519687,'1886','290',2205873.95,2205873.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','235154',4519688,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','235154',4519689,'1888','290',167305.88,167305.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','235154',4519690,'1889','290',3107812.46,3107812.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','235154',4519691,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','235154',4519692,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','235154',4519693,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','235154',4519694,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','235154',4519695,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','235154',4519696,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','235154',4519697,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','235154',4519698,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','235154',4519699,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','235154',4519700,'1899','290',1920934.49,1923226.00,2291.51,378099.15,0.00,0.00,0.00,0.00,0.00),('5','107','699','235154',4519701,'1900','290',468657.77,470102.30,1444.53,238347.45,0.00,0.00,0.00,0.00,0.00),('5','107','699','235154',4519702,'1901','290',1133311.98,1135075.02,1763.04,290901.60,0.00,0.00,0.00,0.00,0.00),('5','107','699','235154',4519703,'1902','290',44520.92,44959.68,438.76,72395.40,0.00,0.00,0.00,0.00,0.00),('5','107','700','235154',4519704,'1903','290',1157451.83,1160947.00,3495.17,576703.05,0.00,0.00,0.00,0.00,0.00),('5','107','700','235154',4519705,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','235154',4519706,'1905','290',1480849.88,1480849.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','235154',4519707,'1906','290',686623.77,689721.00,3097.23,511042.95,0.00,0.00,0.00,0.00,0.00),('5','107','701','235154',4519708,'1907','290',2019175.00,2019175.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','235154',4519709,'1908','290',649078.13,649078.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','235154',4519710,'1909','290',562324.49,562324.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','235154',4519711,'1910','290',391050.05,391050.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','235154',4519712,'1911','290',1159140.00,1167661.35,8521.35,1406022.75,0.00,0.00,0.00,0.00,0.00),('5','107','702','235154',4519713,'1912','290',197317.45,203016.93,5699.48,940414.20,0.00,0.00,0.00,0.00,0.00),('5','107','702','235154',4519714,'1913','290',626919.67,634441.00,7521.33,1241019.45,0.00,0.00,0.00,0.00,0.00),('5','107','702','235154',4519715,'1914','290',65383.00,70285.14,4902.14,808853.10,0.00,0.00,0.00,0.00,0.00),('5','107','702','235154',4519716,'1915','290',241378.48,248415.67,7037.19,1161136.35,0.00,0.00,0.00,0.00,0.00),('5','107','702','235154',4519717,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','235154',4519718,'1917','290',1032355.98,1032355.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','235154',4519719,'1918','290',152410.86,152410.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','235154',4519720,'1919','290',489434.28,489434.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','235154',4519721,'1920','290',107827.14,107827.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','235154',4519722,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','235154',4519723,'1922','290',174092.17,174092.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','235154',4519724,'1923','290',721025.00,721025.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','235154',4519725,'1924','290',183421.58,183421.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','235154',4519726,'1925','290',1661400.28,1661400.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','235154',4519727,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','235154',4519728,'1927','290',483387.39,483387.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','235154',4519729,'1928','290',132701.40,132701.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','235154',4519730,'1929','291',3748200.14,3756941.54,8741.40,3015783.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','235154',4519731,'1930','291',2607598.75,2618220.20,10621.45,3664400.25,0.00,0.00,0.00,0.00,0.00),('5','107','706','235154',4519732,'1931','291',3787468.88,3793015.18,5546.30,1913473.50,0.00,0.00,0.00,0.00,0.00),('5','107','706','235154',4519733,'1932','291',3258217.39,3266147.77,7930.38,2735981.10,0.00,0.00,0.00,0.00,0.00),('5','107','706','235154',4519734,'1933','291',4340269.72,4348635.51,8365.79,2886197.55,0.00,0.00,0.00,0.00,0.00),('5','107','708','235154',4519735,'1934','291',1689552.32,1689857.90,305.58,105425.10,0.00,0.00,0.00,0.00,0.00),('5','107','706','235154',4519736,'2898','291',2958151.07,2964686.41,6535.34,2254692.30,0.00,0.00,0.00,0.00,0.00),('5','107','708','235154',4519737,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','235377',4523465,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','235377',4523466,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','235377',4523467,'1877','290',817086.39,820700.34,3613.95,596301.75,0.00,0.00,0.00,0.00,0.00),('5','107','696','235377',4523468,'1878','290',180985.69,180985.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','235377',4523469,'1879','290',865187.91,865187.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','235377',4523470,'1880','290',106255.71,106535.60,279.89,46181.85,0.00,0.00,0.00,0.00,0.00),('5','107','697','235377',4523471,'1881','290',1200334.26,1200334.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','235377',4523472,'1882','290',1146243.41,1146243.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','235377',4523473,'1883','290',548269.05,551163.86,2894.81,477643.65,0.00,0.00,0.00,0.00,0.00),('5','107','697','235377',4523474,'1884','290',115114.05,116296.57,1182.52,195115.80,0.00,0.00,0.00,0.00,0.00),('5','107','697','235377',4523475,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','235377',4523476,'1886','290',2205873.95,2214059.84,8185.89,1350671.85,0.00,0.00,0.00,0.00,0.00),('5','107','697','235377',4523477,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','235377',4523478,'1888','290',167305.88,170506.81,3200.93,528153.45,0.00,0.00,0.00,0.00,0.00),('5','107','696','235377',4523479,'1889','290',3107812.46,3115397.41,7584.95,1251516.75,0.00,0.00,0.00,0.00,0.00),('5','107','696','235377',4523480,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','235377',4523481,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','235377',4523482,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','235377',4523483,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','235377',4523484,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','235377',4523485,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','235377',4523486,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','235377',4523487,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','235377',4523488,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','235377',4523489,'1899','290',1923226.00,1925474.54,2248.54,371009.10,0.00,0.00,0.00,0.00,0.00),('5','107','699','235377',4523490,'1900','290',470102.30,475390.27,5287.97,872515.05,0.00,0.00,0.00,0.00,0.00),('5','107','699','235377',4523491,'1901','290',1135075.02,1140845.97,5770.95,952206.75,0.00,0.00,0.00,0.00,0.00),('5','107','699','235377',4523492,'1902','290',44959.68,45700.68,741.00,122265.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','235377',4523493,'1903','290',1160947.00,1160947.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','235377',4523494,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','235377',4523495,'1905','290',1480849.88,1480849.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','235377',4523496,'1906','290',689721.00,689721.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','235377',4523497,'1907','290',2019175.00,2019175.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','235377',4523498,'1908','290',649078.13,653601.89,4523.76,746420.40,0.00,0.00,0.00,0.00,0.00),('5','107','701','235377',4523499,'1909','290',562324.49,567668.90,5344.41,881827.65,0.00,0.00,0.00,0.00,0.00),('5','107','701','235377',4523500,'1910','290',391050.05,391050.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','235377',4523501,'1911','290',1167661.35,1167661.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','235377',4523502,'1912','290',203016.93,204538.58,1521.65,251072.25,0.00,0.00,0.00,0.00,0.00),('5','107','702','235377',4523503,'1913','290',634441.00,635935.97,1494.97,246670.05,0.00,0.00,0.00,0.00,0.00),('5','107','702','235377',4523504,'1914','290',70285.14,70285.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','235377',4523505,'1915','290',248415.67,249651.71,1236.04,203946.60,0.00,0.00,0.00,0.00,0.00),('5','107','702','235377',4523506,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','235377',4523507,'1917','290',1032355.98,1032355.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','235377',4523508,'1918','290',152410.86,152410.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','235377',4523509,'1919','290',489434.28,489434.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','235377',4523510,'1920','290',107827.14,107827.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','235377',4523511,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','235377',4523512,'1922','290',174092.17,174092.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','235377',4523513,'1923','290',721025.00,721025.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','235377',4523514,'1924','290',183421.58,183421.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','235377',4523515,'1925','290',1661400.28,1661400.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','235377',4523516,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','235377',4523517,'1927','290',483387.39,483387.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','235377',4523518,'1928','290',132701.40,132701.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','235377',4523519,'1929','291',3756941.54,3766491.45,9549.91,3294718.95,0.00,0.00,0.00,0.00,0.00),('5','107','706','235377',4523520,'1930','291',2618220.20,2625108.30,6888.10,2376394.50,0.00,0.00,0.00,0.00,0.00),('5','107','706','235377',4523521,'1931','291',3793015.18,3800168.00,7152.82,2467722.90,0.00,0.00,0.00,0.00,0.00),('5','107','706','235377',4523522,'1932','291',3266147.77,3272619.87,6472.10,2232874.50,0.00,0.00,0.00,0.00,0.00),('5','107','706','235377',4523523,'1933','291',4348635.51,4358093.07,9457.56,3262858.20,0.00,0.00,0.00,0.00,0.00),('5','107','708','235377',4523524,'1934','291',1689857.90,1698452.19,8594.29,2965030.05,0.00,0.00,0.00,0.00,0.00),('5','107','706','235377',4523525,'2898','291',2964686.41,2972454.36,7767.95,2679942.75,0.00,0.00,0.00,0.00,0.00),('5','107','708','235377',4523526,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','235671',4528628,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','235671',4528629,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','235671',4528630,'1877','290',820700.34,823264.82,2564.48,423139.20,0.00,0.00,0.00,0.00,0.00),('5','107','696','235671',4528631,'1878','290',180985.69,180985.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','235671',4528632,'1879','290',865187.91,867057.02,1869.11,308403.15,0.00,0.00,0.00,0.00,0.00),('5','107','696','235671',4528633,'1880','290',106535.60,106535.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','235671',4528634,'1881','290',1200334.26,1200334.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','235671',4528635,'1882','290',1146243.41,1146243.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','235671',4528636,'1883','290',551163.86,552413.55,1249.69,206198.85,0.00,0.00,0.00,0.00,0.00),('5','107','697','235671',4528637,'1884','290',116296.57,116296.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','235671',4528638,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','235671',4528639,'1886','290',2214059.84,2215513.75,1453.91,239895.15,0.00,0.00,0.00,0.00,0.00),('5','107','697','235671',4528640,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','235671',4528641,'1888','290',170506.81,171841.18,1334.37,220171.05,0.00,0.00,0.00,0.00,0.00),('5','107','696','235671',4528642,'1889','290',3115397.41,3121523.98,6126.57,1010884.05,0.00,0.00,0.00,0.00,0.00),('5','107','696','235671',4528643,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','235671',4528644,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','235671',4528645,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','235671',4528646,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','235671',4528647,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','235671',4528648,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','235671',4528649,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','235671',4528650,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','235671',4528651,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','235671',4528652,'1899','290',1925474.54,1927732.37,2257.83,372541.95,0.00,0.00,0.00,0.00,0.00),('5','107','699','235671',4528653,'1900','290',475390.27,479499.07,4108.80,677952.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','235671',4528654,'1901','290',1140845.97,1147004.80,6158.83,1016206.95,0.00,0.00,0.00,0.00,0.00),('5','107','699','235671',4528655,'1902','290',45700.68,46372.94,672.26,110922.90,0.00,0.00,0.00,0.00,0.00),('5','107','700','235671',4528656,'1903','290',1160947.00,1170713.98,9766.98,1611551.70,0.00,0.00,0.00,0.00,0.00),('5','107','700','235671',4528657,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','235671',4528658,'1905','290',1480849.88,1480849.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','235671',4528659,'1906','290',689721.00,697504.86,7783.86,1284336.90,0.00,0.00,0.00,0.00,0.00),('5','107','701','235671',4528660,'1907','290',2019175.00,2021858.99,2683.99,442858.35,0.00,0.00,0.00,0.00,0.00),('5','107','701','235671',4528661,'1908','290',653601.89,656123.98,2522.09,416144.85,0.00,0.00,0.00,0.00,0.00),('5','107','701','235671',4528662,'1909','290',567668.90,572284.99,4616.09,761654.85,0.00,0.00,0.00,0.00,0.00),('5','107','701','235671',4528663,'1910','290',391050.05,391050.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','235671',4528664,'1911','290',1167661.35,1167661.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','235671',4528665,'1912','290',204538.58,204538.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','235671',4528666,'1913','290',635935.97,635935.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','235671',4528667,'1914','290',70285.14,70285.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','235671',4528668,'1915','290',249651.71,249651.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','235671',4528669,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','235671',4528670,'1917','290',1032355.98,1032581.98,226.00,37290.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','235671',4528671,'1918','290',152410.86,153523.97,1113.11,183663.15,0.00,0.00,0.00,0.00,0.00),('5','107','703','235671',4528672,'1919','290',489434.28,489434.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','235671',4528673,'1920','290',107827.14,107827.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','235671',4528674,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','235671',4528675,'1922','290',174092.17,174092.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','235671',4528676,'1923','290',721025.00,721025.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','235671',4528677,'1924','290',183421.58,183421.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','235671',4528678,'1925','290',1661400.28,1668901.96,7501.68,1237777.20,0.00,0.00,0.00,0.00,0.00),('5','107','705','235671',4528679,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','235671',4528680,'1927','290',483387.39,483387.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','235671',4528681,'1928','290',132701.40,137187.85,4486.45,740264.25,0.00,0.00,0.00,0.00,0.00),('5','107','706','235671',4528682,'1929','291',3766491.45,3772831.83,6340.38,2187431.10,0.00,0.00,0.00,0.00,0.00),('5','107','706','235671',4528683,'1930','291',2625108.30,2636159.73,11051.43,3812743.35,0.00,0.00,0.00,0.00,0.00),('5','107','706','235671',4528684,'1931','291',3800168.00,3805276.60,5108.60,1762467.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','235671',4528685,'1932','291',3272619.87,3278522.59,5902.72,2036438.40,0.00,0.00,0.00,0.00,0.00),('5','107','706','235671',4528686,'1933','291',4358093.07,4365591.70,7498.63,2587027.35,0.00,0.00,0.00,0.00,0.00),('5','107','708','235671',4528687,'1934','291',1698452.19,1701210.56,2758.37,951637.65,0.00,0.00,0.00,0.00,0.00),('5','107','706','235671',4528688,'2898','291',2972454.36,2979324.70,6870.34,2370267.30,0.00,0.00,0.00,0.00,0.00),('5','107','708','235671',4528689,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','235953',4533600,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','235953',4533601,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','235953',4533602,'1877','290',823264.82,827600.00,4335.18,715304.70,0.00,0.00,0.00,0.00,0.00),('5','107','696','235953',4533603,'1878','290',180985.69,180985.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','235953',4533604,'1879','290',867057.02,867057.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','235953',4533605,'1880','290',106535.60,106535.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','235953',4533606,'1881','290',1200334.26,1200334.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','235953',4533607,'1882','290',1146243.41,1146243.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','235953',4533608,'1883','290',552413.55,552413.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','235953',4533609,'1884','290',116296.57,116296.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','235953',4533610,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','235953',4533611,'1886','290',2215513.75,2215513.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','235953',4533612,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','235953',4533613,'1888','290',171841.18,171841.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','235953',4533614,'1889','290',3121523.98,3129985.08,8461.10,1396081.50,0.00,0.00,0.00,0.00,0.00),('5','107','696','235953',4533615,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','235953',4533616,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','235953',4533617,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','235953',4533618,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','235953',4533619,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','235953',4533620,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','235953',4533621,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','235953',4533622,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','235953',4533623,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','235953',4533624,'1899','290',1927732.37,1927732.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','235953',4533625,'1900','290',479499.07,479499.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','235953',4533626,'1901','290',1147004.80,1147004.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','235953',4533627,'1902','290',46372.94,52450.00,6077.06,1002714.90,0.00,0.00,0.00,0.00,0.00),('5','107','700','235953',4533628,'1903','290',1170713.98,1180906.00,10192.02,1681683.30,0.00,0.00,0.00,0.00,0.00),('5','107','700','235953',4533629,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','235953',4533630,'1905','290',1480849.88,1480849.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','235953',4533631,'1906','290',697504.86,699804.00,2299.14,379358.10,0.00,0.00,0.00,0.00,0.00),('5','107','701','235953',4533632,'1907','290',2021858.99,2021858.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','235953',4533633,'1908','290',656123.98,656123.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','235953',4533634,'1909','290',572284.99,572284.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','235953',4533635,'1910','290',391050.05,391050.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','235953',4533636,'1911','290',1167661.35,1167661.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','235953',4533637,'1912','290',204538.58,204538.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','235953',4533638,'1913','290',635935.97,639496.00,3560.03,587404.95,0.00,0.00,0.00,0.00,0.00),('5','107','702','235953',4533639,'1914','290',70285.14,70285.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','235953',4533640,'1915','290',249651.71,249651.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','235953',4533641,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','235953',4533642,'1917','290',1032581.98,1032581.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','235953',4533643,'1918','290',153523.97,159217.44,5693.47,939422.55,0.00,0.00,0.00,0.00,0.00),('5','107','703','235953',4533644,'1919','290',489434.28,494807.76,5373.48,886624.20,0.00,0.00,0.00,0.00,0.00),('5','107','703','235953',4533645,'1920','290',107827.14,107827.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','235953',4533646,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','235953',4533647,'1922','290',174092.17,174092.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','235953',4533648,'1923','290',721025.00,721025.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','235953',4533649,'1924','290',183421.58,189109.16,5687.58,938450.70,0.00,0.00,0.00,0.00,0.00),('5','107','705','235953',4533650,'1925','290',1668901.96,1675439.00,6537.04,1078611.60,0.00,0.00,0.00,0.00,0.00),('5','107','705','235953',4533651,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','235953',4533652,'1927','290',483387.39,483387.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','235953',4533653,'1928','290',137187.85,137187.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','235953',4533654,'1929','291',3772831.83,3780212.49,7380.66,2546327.70,0.00,0.00,0.00,0.00,0.00),('5','107','706','235953',4533655,'1930','291',2636159.73,2646818.30,10658.57,3677206.65,0.00,0.00,0.00,0.00,0.00),('5','107','706','235953',4533656,'1931','291',3805276.60,3811740.72,6464.12,2230121.40,0.00,0.00,0.00,0.00,0.00),('5','107','706','235953',4533657,'1932','291',3278522.59,3285920.52,7397.93,2552285.85,0.00,0.00,0.00,0.00,0.00),('5','107','706','235953',4533658,'1933','291',4365591.70,4373569.74,7978.04,2752423.80,0.00,0.00,0.00,0.00,0.00),('5','107','708','235953',4533659,'1934','291',1701210.56,1704317.00,3106.44,1071721.80,0.00,0.00,0.00,0.00,0.00),('5','107','706','235953',4533660,'2898','291',2979324.70,2985147.92,5823.22,2009010.90,0.00,0.00,0.00,0.00,0.00),('5','107','708','235953',4533661,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','236125',4536744,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','236125',4536745,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','236125',4536746,'1877','290',827600.00,829456.01,1856.01,306241.65,0.00,0.00,0.00,0.00,0.00),('5','107','696','236125',4536747,'1878','290',180985.69,180985.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','236125',4536748,'1879','290',867057.02,867516.28,459.26,75777.90,0.00,0.00,0.00,0.00,0.00),('5','107','696','236125',4536749,'1880','290',106535.60,106535.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','236125',4536750,'1881','290',1200334.26,1200334.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','236125',4536751,'1882','290',1146243.41,1146243.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','236125',4536752,'1883','290',552413.55,552413.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','236125',4536753,'1884','290',116296.57,116296.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','236125',4536754,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','236125',4536755,'1886','290',2215513.75,2215513.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','236125',4536756,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','236125',4536757,'1888','290',171841.18,171841.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','236125',4536758,'1889','290',3129985.08,3132530.99,2545.91,420075.15,0.00,0.00,0.00,0.00,0.00),('5','107','696','236125',4536759,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','236125',4536760,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','236125',4536761,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','236125',4536762,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','236125',4536763,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','236125',4536764,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','236125',4536765,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','236125',4536766,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','236125',4536767,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','236125',4536768,'1899','290',1927732.37,1927732.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','236125',4536769,'1900','290',479499.07,479499.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','236125',4536770,'1901','290',1147004.80,1147004.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','236125',4536771,'1902','290',52450.00,52450.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','236125',4536772,'1903','290',1180906.00,1189933.99,9027.99,1489618.35,0.00,0.00,0.00,0.00,0.00),('5','107','700','236125',4536773,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','236125',4536774,'1905','290',1480849.88,1480849.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','236125',4536775,'1906','290',699804.00,705320.00,5516.00,910140.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','236125',4536776,'1907','290',2021858.99,2021858.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','236125',4536777,'1908','290',656123.98,656123.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','236125',4536778,'1909','290',572284.99,572284.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','236125',4536779,'1910','290',391050.05,391050.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','236125',4536780,'1911','290',1167661.35,1172063.00,4401.65,726272.25,0.00,0.00,0.00,0.00,0.00),('5','107','702','236125',4536781,'1912','290',204538.58,204538.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','236125',4536782,'1913','290',639496.00,645859.95,6363.95,1050051.75,0.00,0.00,0.00,0.00,0.00),('5','107','702','236125',4536783,'1914','290',70285.14,70285.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','236125',4536784,'1915','290',249651.71,252183.68,2531.97,417775.05,0.00,0.00,0.00,0.00,0.00),('5','107','702','236125',4536785,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','236125',4536786,'1917','290',1032581.98,1032581.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','236125',4536787,'1918','290',159217.44,165845.99,6628.55,1093710.75,0.00,0.00,0.00,0.00,0.00),('5','107','703','236125',4536788,'1919','290',494807.76,500483.98,5676.22,936576.30,0.00,0.00,0.00,0.00,0.00),('5','107','703','236125',4536789,'1920','290',107827.14,109082.99,1255.85,207215.25,0.00,0.00,0.00,0.00,0.00),('5','107','704','236125',4536790,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','236125',4536791,'1922','290',174092.17,174092.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','236125',4536792,'1923','290',721025.00,721025.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','236125',4536793,'1924','290',189109.16,189109.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','236125',4536794,'1925','290',1675439.00,1682205.00,6766.00,1116390.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','236125',4536795,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','236125',4536796,'1927','290',483387.39,483387.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','236125',4536797,'1928','290',137187.85,143478.09,6290.24,1037889.60,0.00,0.00,0.00,0.00,0.00),('5','107','706','236125',4536798,'1929','291',3780212.49,3785901.60,5689.11,1962742.95,0.00,0.00,0.00,0.00,0.00),('5','107','706','236125',4536799,'1930','291',2646818.30,2657196.39,10378.09,3580441.05,0.00,0.00,0.00,0.00,0.00),('5','107','706','236125',4536800,'1931','291',3811740.72,3817123.23,5382.51,1856965.95,0.00,0.00,0.00,0.00,0.00),('5','107','706','236125',4536801,'1932','291',3285920.52,3293092.32,7171.80,2474271.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','236125',4536802,'1933','291',4373569.74,4381161.31,7591.57,2619091.65,0.00,0.00,0.00,0.00,0.00),('5','107','708','236125',4536803,'1934','291',1704317.00,1708415.07,4098.07,1413834.15,0.00,0.00,0.00,0.00,0.00),('5','107','706','236125',4536804,'2898','291',2985147.92,2991331.30,6183.38,2133266.10,0.00,0.00,0.00,0.00,0.00),('5','107','708','236125',4536805,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','236428',4542093,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','236428',4542094,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','236428',4542095,'1877','290',829456.01,829456.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','236428',4542096,'1878','290',180985.69,180985.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','236428',4542097,'1879','290',867516.28,867516.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','236428',4542098,'1880','290',106535.60,106535.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','236428',4542099,'1881','290',1200334.26,1200334.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','236428',4542100,'1882','290',1146243.41,1154212.00,7968.59,1314817.35,0.00,0.00,0.00,0.00,0.00),('5','107','697','236428',4542101,'1883','290',552413.55,555126.93,2713.38,447707.70,0.00,0.00,0.00,0.00,0.00),('5','107','697','236428',4542102,'1884','290',116296.57,121476.50,5179.93,854688.45,0.00,0.00,0.00,0.00,0.00),('5','107','697','236428',4542103,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','236428',4542104,'1886','290',2215513.75,2226277.14,10763.39,1775959.35,0.00,0.00,0.00,0.00,0.00),('5','107','697','236428',4542105,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','236428',4542106,'1888','290',171841.18,178258.49,6417.31,1058856.15,0.00,0.00,0.00,0.00,0.00),('5','107','696','236428',4542107,'1889','290',3132530.99,3132530.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','236428',4542108,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','236428',4542109,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','236428',4542110,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','236428',4542111,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','236428',4542112,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','236428',4542113,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','236428',4542114,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','236428',4542115,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','236428',4542116,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','236428',4542117,'1899','290',1927732.37,1927732.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','236428',4542118,'1900','290',479499.07,479499.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','236428',4542119,'1901','290',1147004.80,1147004.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','236428',4542120,'1902','290',52450.00,52450.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','236428',4542121,'1903','290',1189933.99,1189933.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','236428',4542122,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','236428',4542123,'1905','290',1480849.88,1480849.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','236428',4542124,'1906','290',705320.00,705320.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','236428',4542125,'1907','290',2021858.99,2021858.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','236428',4542126,'1908','290',656123.98,656123.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','236428',4542127,'1909','290',572284.99,572284.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','236428',4542128,'1910','290',391050.05,391050.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','236428',4542129,'1911','290',1172063.00,1180046.17,7983.17,1317223.05,0.00,0.00,0.00,0.00,0.00),('5','107','702','236428',4542130,'1912','290',204538.58,208012.00,3473.42,573114.30,0.00,0.00,0.00,0.00,0.00),('5','107','702','236428',4542131,'1913','290',645859.95,652377.19,6517.24,1075344.60,0.00,0.00,0.00,0.00,0.00),('5','107','702','236428',4542132,'1914','290',70285.14,70285.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','236428',4542133,'1915','290',252183.68,256744.36,4560.68,752512.20,0.00,0.00,0.00,0.00,0.00),('5','107','702','236428',4542134,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','236428',4542135,'1917','290',1032581.98,1032581.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','236428',4542136,'1918','290',165845.99,165845.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','236428',4542137,'1919','290',500483.98,500483.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','236428',4542138,'1920','290',109082.99,109082.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','236428',4542139,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','236428',4542140,'1922','290',174092.17,174092.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','236428',4542141,'1923','290',721025.00,721025.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','236428',4542142,'1924','290',189109.16,189109.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','236428',4542143,'1925','290',1682205.00,1687057.26,4852.26,800622.90,0.00,0.00,0.00,0.00,0.00),('5','107','705','236428',4542144,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','236428',4542145,'1927','290',483387.39,483387.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','236428',4542146,'1928','290',143478.09,147491.76,4013.67,662255.55,0.00,0.00,0.00,0.00,0.00),('5','107','706','236428',4542147,'1929','291',3785901.60,3791565.08,5663.48,1953900.60,0.00,0.00,0.00,0.00,0.00),('5','107','706','236428',4542148,'1930','291',2657196.39,2666287.44,9091.05,3136412.25,0.00,0.00,0.00,0.00,0.00),('5','107','706','236428',4542149,'1931','291',3817123.23,3824971.63,7848.40,2707698.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','236428',4542150,'1932','291',3293092.32,3301891.35,8799.03,3035665.35,0.00,0.00,0.00,0.00,0.00),('5','107','706','236428',4542151,'1933','291',4381161.31,4389328.89,8167.58,2817815.10,0.00,0.00,0.00,0.00,0.00),('5','107','708','236428',4542152,'1934','291',1708415.07,1717170.32,8755.25,3020561.25,0.00,0.00,0.00,0.00,0.00),('5','107','706','236428',4542153,'2898','291',2991331.30,2997494.72,6163.42,2126379.90,0.00,0.00,0.00,0.00,0.00),('5','107','708','236428',4542154,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','236435',4542212,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','236435',4542213,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','236435',4542214,'1877','290',829456.01,829456.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','236435',4542215,'1878','290',180985.69,180985.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','236435',4542216,'1879','290',867516.28,867516.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','236435',4542217,'1880','290',106535.60,106535.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','236435',4542218,'1881','290',1200334.26,1200334.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','236435',4542219,'1882','290',1154212.00,1157189.14,2977.14,491228.10,0.00,0.00,0.00,0.00,0.00),('5','107','697','236435',4542220,'1883','290',555126.93,555777.05,650.12,107269.80,0.00,0.00,0.00,0.00,0.00),('5','107','697','236435',4542221,'1884','290',121476.50,122460.00,983.50,162277.50,0.00,0.00,0.00,0.00,0.00),('5','107','697','236435',4542222,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','236435',4542223,'1886','290',2226277.14,2230397.71,4120.57,679894.05,0.00,0.00,0.00,0.00,0.00),('5','107','697','236435',4542224,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','236435',4542225,'1888','290',178258.49,180680.12,2421.63,399568.95,0.00,0.00,0.00,0.00,0.00),('5','107','696','236435',4542226,'1889','290',3132530.99,3132530.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','236435',4542227,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','236435',4542228,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','236435',4542229,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','236435',4542230,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','236435',4542231,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','236435',4542232,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','236435',4542233,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','236435',4542234,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','236435',4542235,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','236435',4542236,'1899','290',1927732.37,1927732.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','236435',4542237,'1900','290',479499.07,479499.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','236435',4542238,'1901','290',1147004.80,1147004.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','236435',4542239,'1902','290',52450.00,52450.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','236435',4542240,'1903','290',1189933.99,1189933.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','236435',4542241,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','236435',4542242,'1905','290',1480849.88,1480849.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','236435',4542243,'1906','290',705320.00,705320.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','236435',4542244,'1907','290',2021858.99,2027968.99,6110.00,1008150.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','236435',4542245,'1908','290',656123.98,661490.99,5367.01,885556.65,0.00,0.00,0.00,0.00,0.00),('5','107','701','236435',4542246,'1909','290',572284.99,582400.99,10116.00,1669140.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','236435',4542247,'1910','290',391050.05,391050.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','236435',4542248,'1911','290',1180046.17,1181574.42,1528.25,252161.25,0.00,0.00,0.00,0.00,0.00),('5','107','702','236435',4542249,'1912','290',208012.00,208012.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','236435',4542250,'1913','290',652377.19,654027.48,1650.29,272297.85,0.00,0.00,0.00,0.00,0.00),('5','107','702','236435',4542251,'1914','290',70285.14,70285.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','236435',4542252,'1915','290',256744.36,257450.43,706.07,116501.55,0.00,0.00,0.00,0.00,0.00),('5','107','702','236435',4542253,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','236435',4542254,'1917','290',1032581.98,1032581.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','236435',4542255,'1918','290',165845.99,165845.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','236435',4542256,'1919','290',500483.98,500483.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','236435',4542257,'1920','290',109082.99,109082.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','236435',4542258,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','236435',4542259,'1922','290',174092.17,176778.27,2686.10,443206.50,0.00,0.00,0.00,0.00,0.00),('5','107','704','236435',4542260,'1923','290',721025.00,722385.92,1360.92,224551.80,0.00,0.00,0.00,0.00,0.00),('5','107','704','236435',4542261,'1924','290',189109.16,192137.60,3028.44,499692.60,0.00,0.00,0.00,0.00,0.00),('5','107','705','236435',4542262,'1925','290',1687057.26,1692457.35,5400.09,891014.85,0.00,0.00,0.00,0.00,0.00),('5','107','705','236435',4542263,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','236435',4542264,'1927','290',483387.39,483387.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','236435',4542265,'1928','290',147491.76,152945.17,5453.41,899812.65,0.00,0.00,0.00,0.00,0.00),('5','107','706','236435',4542266,'1929','291',3791565.08,3798391.04,6825.96,2354956.20,0.00,0.00,0.00,0.00,0.00),('5','107','706','236435',4542267,'1930','291',2666287.44,2676477.52,10190.08,3515577.60,0.00,0.00,0.00,0.00,0.00),('5','107','706','236435',4542268,'1931','291',3824971.63,3831219.84,6248.21,2155632.45,0.00,0.00,0.00,0.00,0.00),('5','107','706','236435',4542269,'1932','291',3301891.35,3307897.59,6006.24,2072152.80,0.00,0.00,0.00,0.00,0.00),('5','107','706','236435',4542270,'1933','291',4389328.89,4396924.60,7595.71,2620519.95,0.00,0.00,0.00,0.00,0.00),('5','107','708','236435',4542271,'1934','291',1717170.32,1719411.87,2241.55,773334.75,0.00,0.00,0.00,0.00,0.00),('5','107','706','236435',4542272,'2898','291',2997494.72,3001294.67,3799.95,1310982.75,0.00,0.00,0.00,0.00,0.00),('5','107','708','236435',4542273,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','236781',4547962,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','236781',4547963,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','236781',4547964,'1877','290',829456.01,829456.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','236781',4547965,'1878','290',180985.69,180985.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','236781',4547966,'1879','290',867516.28,867516.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','236781',4547967,'1880','290',106535.60,106535.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','236781',4547968,'1881','290',1200334.26,1200334.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','236781',4547969,'1882','290',1157189.14,1157189.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','236781',4547970,'1883','290',555777.05,555777.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','236781',4547971,'1884','290',122460.00,122460.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','236781',4547972,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','236781',4547973,'1886','290',2230397.71,2230397.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','236781',4547974,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','236781',4547975,'1888','290',180680.12,180680.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','236781',4547976,'1889','290',3132530.99,3132530.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','236781',4547977,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','236781',4547978,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','236781',4547979,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','236781',4547980,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','236781',4547981,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','236781',4547982,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','236781',4547983,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','236781',4547984,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','236781',4547985,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','236781',4547986,'1899','290',1927732.37,1932106.27,4373.90,721693.50,0.00,0.00,0.00,0.00,0.00),('5','107','699','236781',4547987,'1900','290',479499.07,486564.30,7065.23,1165762.95,0.00,0.00,0.00,0.00,0.00),('5','107','699','236781',4547988,'1901','290',1147004.80,1147004.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','236781',4547989,'1902','290',52450.00,56861.00,4411.00,727815.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','236781',4547990,'1903','290',1189933.99,1189933.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','236781',4547991,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','236781',4547992,'1905','290',1480849.88,1480849.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','236781',4547993,'1906','290',705320.00,705320.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','236781',4547994,'1907','290',2027968.99,2029329.99,1361.00,224565.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','236781',4547995,'1908','290',661490.99,666741.64,5250.65,866357.25,0.00,0.00,0.00,0.00,0.00),('5','107','701','236781',4547996,'1909','290',582400.99,589682.61,7281.62,1201467.30,0.00,0.00,0.00,0.00,0.00),('5','107','701','236781',4547997,'1910','290',391050.05,391050.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','236781',4547998,'1911','290',1181574.42,1186686.30,5111.88,843460.20,0.00,0.00,0.00,0.00,0.00),('5','107','702','236781',4547999,'1912','290',208012.00,210921.05,2909.05,479993.25,0.00,0.00,0.00,0.00,0.00),('5','107','702','236781',4548000,'1913','290',654027.48,658093.61,4066.13,670911.45,0.00,0.00,0.00,0.00,0.00),('5','107','702','236781',4548001,'1914','290',70285.14,72289.52,2004.38,330722.70,0.00,0.00,0.00,0.00,0.00),('5','107','702','236781',4548002,'1915','290',257450.43,259623.78,2173.35,358602.75,0.00,0.00,0.00,0.00,0.00),('5','107','702','236781',4548003,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','236781',4548004,'1917','290',1032581.98,1032679.21,97.23,16042.95,0.00,0.00,0.00,0.00,0.00),('5','107','703','236781',4548005,'1918','290',165845.99,165845.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','236781',4548006,'1919','290',500483.98,500483.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','236781',4548007,'1920','290',109082.99,109082.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','236781',4548008,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','236781',4548009,'1922','290',176778.27,176778.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','236781',4548010,'1923','290',722385.92,722385.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','236781',4548011,'1924','290',192137.60,192137.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','236781',4548012,'1925','290',1692457.35,1700287.42,7830.07,1291961.55,0.00,0.00,0.00,0.00,0.00),('5','107','705','236781',4548013,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','236781',4548014,'1927','290',483387.39,483387.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','236781',4548015,'1928','290',152945.17,155829.61,2884.44,475932.60,0.00,0.00,0.00,0.00,0.00),('5','107','706','236781',4548016,'1929','291',3798391.04,3805387.13,6996.09,2413651.05,0.00,0.00,0.00,0.00,0.00),('5','107','706','236781',4548017,'1930','291',2676477.52,2687829.90,11352.38,3916571.10,0.00,0.00,0.00,0.00,0.00),('5','107','706','236781',4548018,'1931','291',3831219.84,3838763.18,7543.34,2602452.30,0.00,0.00,0.00,0.00,0.00),('5','107','706','236781',4548019,'1932','291',3307897.59,3313781.91,5884.32,2030090.40,0.00,0.00,0.00,0.00,0.00),('5','107','706','236781',4548020,'1933','291',4396924.60,4406775.35,9850.75,3398508.75,0.00,0.00,0.00,0.00,0.00),('5','107','708','236781',4548021,'1934','291',1719411.87,1721965.28,2553.41,880926.45,0.00,0.00,0.00,0.00,0.00),('5','107','706','236781',4548022,'2898','291',3001294.67,3007397.67,6103.00,2105535.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','236781',4548023,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','237118',4554111,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','237118',4554112,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','237118',4554113,'1877','290',829456.01,829456.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','237118',4554114,'1878','290',180985.69,180985.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','237118',4554115,'1879','290',867516.28,867516.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','237118',4554116,'1880','290',106535.60,106535.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','237118',4554117,'1881','290',1200334.26,1200334.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','237118',4554118,'1882','290',1157189.14,1157189.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','237118',4554119,'1883','290',555777.05,559144.00,3366.95,555546.75,0.00,0.00,0.00,0.00,0.00),('5','107','697','237118',4554120,'1884','290',122460.00,122460.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','237118',4554121,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','237118',4554122,'1886','290',2230397.71,2238406.95,8009.24,1321524.60,0.00,0.00,0.00,0.00,0.00),('5','107','697','237118',4554123,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','237118',4554124,'1888','290',180680.12,185981.77,5301.65,874772.25,0.00,0.00,0.00,0.00,0.00),('5','107','696','237118',4554125,'1889','290',3132530.99,3132530.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','237118',4554126,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','237118',4554127,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','237118',4554128,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','237118',4554129,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','237118',4554130,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','237118',4554131,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','237118',4554132,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','237118',4554133,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','237118',4554134,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','237118',4554135,'1899','290',1932106.27,1932106.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','237118',4554136,'1900','290',486564.30,493524.66,6960.36,1148459.40,0.00,0.00,0.00,0.00,0.00),('5','107','699','237118',4554137,'1901','290',1147004.80,1147004.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','237118',4554138,'1902','290',56861.00,59753.90,2892.90,477328.50,0.00,0.00,0.00,0.00,0.00),('5','107','700','237118',4554139,'1903','290',1189933.99,1189933.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','237118',4554140,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','237118',4554141,'1905','290',1480849.88,1480849.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','237118',4554142,'1906','290',705320.00,705320.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','237118',4554143,'1907','290',2029329.99,2030063.83,733.84,121083.60,0.00,0.00,0.00,0.00,0.00),('5','107','701','237118',4554144,'1908','290',666741.64,667818.98,1077.34,177761.10,0.00,0.00,0.00,0.00,0.00),('5','107','701','237118',4554145,'1909','290',589682.61,591251.98,1569.37,258946.05,0.00,0.00,0.00,0.00,0.00),('5','107','701','237118',4554146,'1910','290',391050.05,391050.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','237118',4554147,'1911','290',1186686.30,1191984.58,5298.28,874216.20,0.00,0.00,0.00,0.00,0.00),('5','107','702','237118',4554148,'1912','290',210921.05,210921.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','237118',4554149,'1913','290',658093.61,659489.31,1395.70,230290.50,0.00,0.00,0.00,0.00,0.00),('5','107','702','237118',4554150,'1914','290',72289.52,72289.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','237118',4554151,'1915','290',259623.78,261617.73,1993.95,329001.75,0.00,0.00,0.00,0.00,0.00),('5','107','702','237118',4554152,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','237118',4554153,'1917','290',1032679.21,1032679.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','237118',4554154,'1918','290',165845.99,173737.86,7891.87,1302158.55,0.00,0.00,0.00,0.00,0.00),('5','107','703','237118',4554155,'1919','290',500483.98,506429.90,5945.92,981076.80,0.00,0.00,0.00,0.00,0.00),('5','107','703','237118',4554156,'1920','290',109082.99,109082.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','237118',4554157,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','237118',4554158,'1922','290',176778.27,176778.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','237118',4554159,'1923','290',722385.92,722385.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','237118',4554160,'1924','290',192137.60,192137.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','237118',4554161,'1925','290',1700287.42,1707070.35,6782.93,1119183.45,0.00,0.00,0.00,0.00,0.00),('5','107','705','237118',4554162,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','237118',4554163,'1927','290',483387.39,483387.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','237118',4554164,'1928','290',155829.61,159587.30,3757.69,620018.85,0.00,0.00,0.00,0.00,0.00),('5','107','706','237118',4554165,'1929','291',3805387.13,3813580.86,8193.73,2826836.85,0.00,0.00,0.00,0.00,0.00),('5','107','706','237118',4554166,'1930','291',2687829.90,2695894.81,8064.91,2782393.95,0.00,0.00,0.00,0.00,0.00),('5','107','706','237118',4554167,'1931','291',3838763.18,3846528.64,7765.46,2679083.70,0.00,0.00,0.00,0.00,0.00),('5','107','706','237118',4554168,'1932','291',3313781.91,3321216.84,7434.93,2565050.85,0.00,0.00,0.00,0.00,0.00),('5','107','706','237118',4554169,'1933','291',4406775.35,4416547.88,9772.53,3371522.85,0.00,0.00,0.00,0.00,0.00),('5','107','708','237118',4554170,'1934','291',1721965.28,1725561.75,3596.47,1240782.15,0.00,0.00,0.00,0.00,0.00),('5','107','706','237118',4554171,'2898','291',3007397.67,3014381.15,6983.48,2409300.60,0.00,0.00,0.00,0.00,0.00),('5','107','708','237118',4554172,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','237320',4557762,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','237320',4557763,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','237320',4557764,'1877','290',829456.01,836768.49,7312.48,1206559.20,0.00,0.00,0.00,0.00,0.00),('5','107','696','237320',4557765,'1878','290',180985.69,183709.00,2723.31,449346.15,0.00,0.00,0.00,0.00,0.00),('5','107','696','237320',4557766,'1879','290',867516.28,868649.14,1132.86,186921.90,0.00,0.00,0.00,0.00,0.00),('5','107','696','237320',4557767,'1880','290',106535.60,106535.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','237320',4557768,'1881','290',1200334.26,1200334.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','237320',4557769,'1882','290',1157189.14,1157189.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','237320',4557770,'1883','290',559144.00,559144.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','237320',4557771,'1884','290',122460.00,129027.18,6567.18,1083584.70,0.00,0.00,0.00,0.00,0.00),('5','107','697','237320',4557772,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','237320',4557773,'1886','290',2238406.95,2238406.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','237320',4557774,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','237320',4557775,'1888','290',185981.77,193841.47,7859.70,1296850.50,0.00,0.00,0.00,0.00,0.00),('5','107','696','237320',4557776,'1889','290',3132530.99,3140949.98,8418.99,1389133.35,0.00,0.00,0.00,0.00,0.00),('5','107','696','237320',4557777,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','237320',4557778,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','237320',4557779,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','237320',4557780,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','237320',4557781,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','237320',4557782,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','237320',4557783,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','237320',4557784,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','237320',4557785,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','237320',4557786,'1899','290',1932106.27,1932106.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','237320',4557787,'1900','290',493524.66,501646.57,8121.91,1340115.15,0.00,0.00,0.00,0.00,0.00),('5','107','699','237320',4557788,'1901','290',1147004.80,1147004.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','237320',4557789,'1902','290',59753.90,65170.59,5416.69,893753.85,0.00,0.00,0.00,0.00,0.00),('5','107','700','237320',4557790,'1903','290',1189933.99,1189933.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','237320',4557791,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','237320',4557792,'1905','290',1480849.88,1480849.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','237320',4557793,'1906','290',705320.00,705320.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','237320',4557794,'1907','290',2030063.83,2030063.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','237320',4557795,'1908','290',667818.98,667818.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','237320',4557796,'1909','290',591251.98,591251.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','237320',4557797,'1910','290',391050.05,391050.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','237320',4557798,'1911','290',1191984.58,1196556.12,4571.54,754304.10,0.00,0.00,0.00,0.00,0.00),('5','107','702','237320',4557799,'1912','290',210921.05,210921.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','237320',4557800,'1913','290',659489.31,663298.44,3809.13,628506.45,0.00,0.00,0.00,0.00,0.00),('5','107','702','237320',4557801,'1914','290',72289.52,72289.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','237320',4557802,'1915','290',261617.73,263411.55,1793.82,295980.30,0.00,0.00,0.00,0.00,0.00),('5','107','702','237320',4557803,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','237320',4557804,'1917','290',1032679.21,1032679.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','237320',4557805,'1918','290',173737.86,187131.98,13394.12,2210029.80,0.00,0.00,0.00,0.00,0.00),('5','107','703','237320',4557806,'1919','290',506429.90,508507.82,2077.92,342856.80,0.00,0.00,0.00,0.00,0.00),('5','107','703','237320',4557807,'1920','290',109082.99,118545.98,9462.99,1561393.35,0.00,0.00,0.00,0.00,0.00),('5','107','704','237320',4557808,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','237320',4557809,'1922','290',176778.27,176778.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','237320',4557810,'1923','290',722385.92,722385.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','237320',4557811,'1924','290',192137.60,192137.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','237320',4557812,'1925','290',1707070.35,1711663.00,4592.65,757787.25,0.00,0.00,0.00,0.00,0.00),('5','107','705','237320',4557813,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','237320',4557814,'1927','290',483387.39,483387.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','237320',4557815,'1928','290',159587.30,161321.00,1733.70,286060.50,0.00,0.00,0.00,0.00,0.00),('5','107','706','237320',4557816,'1929','291',3813580.86,3820507.43,6926.57,2389666.65,0.00,0.00,0.00,0.00,0.00),('5','107','706','237320',4557817,'1930','291',2695894.81,2707336.39,11441.58,3947345.10,0.00,0.00,0.00,0.00,0.00),('5','107','706','237320',4557818,'1931','291',3846528.64,3853064.71,6536.07,2254944.15,0.00,0.00,0.00,0.00,0.00),('5','107','706','237320',4557819,'1932','291',3321216.84,3326815.02,5598.18,1931372.10,0.00,0.00,0.00,0.00,0.00),('5','107','706','237320',4557820,'1933','291',4416547.88,4425915.27,9367.39,3231749.55,0.00,0.00,0.00,0.00,0.00),('5','107','708','237320',4557821,'1934','291',1725561.75,1729141.82,3580.07,1235124.15,0.00,0.00,0.00,0.00,0.00),('5','107','706','237320',4557822,'2898','291',3014381.15,3022668.78,8287.63,2859232.35,0.00,0.00,0.00,0.00,0.00),('5','107','708','237320',4557823,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','237538',4561587,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','237538',4561588,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','237538',4561589,'1877','290',836768.49,843027.65,6259.16,1032761.40,0.00,0.00,0.00,0.00,0.00),('5','107','696','237538',4561590,'1878','290',183709.00,190585.39,6876.39,1134604.35,0.00,0.00,0.00,0.00,0.00),('5','107','696','237538',4561591,'1879','290',868649.14,875620.77,6971.63,1150318.95,0.00,0.00,0.00,0.00,0.00),('5','107','696','237538',4561592,'1880','290',106535.60,111325.18,4789.58,790280.70,0.00,0.00,0.00,0.00,0.00),('5','107','697','237538',4561593,'1881','290',1200334.26,1200334.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','237538',4561594,'1882','290',1157189.14,1157189.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','237538',4561595,'1883','290',559144.00,559144.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','237538',4561596,'1884','290',129027.18,131185.41,2158.23,356107.95,0.00,0.00,0.00,0.00,0.00),('5','107','697','237538',4561597,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','237538',4561598,'1886','290',2238406.95,2238406.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','237538',4561599,'1887','290',205744.14,205744.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','237538',4561600,'1888','290',193841.47,196833.58,2992.11,493698.15,0.00,0.00,0.00,0.00,0.00),('5','107','696','237538',4561601,'1889','290',3140949.98,3140949.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','237538',4561602,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','237538',4561603,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','237538',4561604,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','237538',4561605,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','237538',4561606,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','237538',4561607,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','237538',4561608,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','237538',4561609,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','237538',4561610,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','237538',4561611,'1899','290',1932106.27,1932106.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','237538',4561612,'1900','290',501646.57,501646.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','237538',4561613,'1901','290',1147004.80,1147004.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','237538',4561614,'1902','290',65170.59,65170.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','237538',4561615,'1903','290',1189933.99,1189933.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','237538',4561616,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','237538',4561617,'1905','290',1480849.88,1480849.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','237538',4561618,'1906','290',705320.00,705320.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','237538',4561619,'1907','290',2030063.83,2030614.95,551.12,90934.80,0.00,0.00,0.00,0.00,0.00),('5','107','701','237538',4561620,'1908','290',667818.98,670718.77,2899.79,478465.35,0.00,0.00,0.00,0.00,0.00),('5','107','701','237538',4561621,'1909','290',591251.98,593099.10,1847.12,304774.80,0.00,0.00,0.00,0.00,0.00),('5','107','701','237538',4561622,'1910','290',391050.05,391050.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','237538',4561623,'1911','290',1196556.12,1197735.30,1179.18,194564.70,0.00,0.00,0.00,0.00,0.00),('5','107','702','237538',4561624,'1912','290',210921.05,211373.38,452.33,74634.45,0.00,0.00,0.00,0.00,0.00),('5','107','702','237538',4561625,'1913','290',663298.44,664387.74,1089.30,179734.50,0.00,0.00,0.00,0.00,0.00),('5','107','702','237538',4561626,'1914','290',72289.52,72939.28,649.76,107210.40,0.00,0.00,0.00,0.00,0.00),('5','107','702','237538',4561627,'1915','290',263411.55,263883.09,471.54,77804.10,0.00,0.00,0.00,0.00,0.00),('5','107','702','237538',4561628,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','237538',4561629,'1917','290',1032679.21,1032679.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','237538',4561630,'1918','290',187131.98,187131.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','237538',4561631,'1919','290',508507.82,508507.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','237538',4561632,'1920','290',118545.98,118545.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','237538',4561633,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','237538',4561634,'1922','290',176778.27,176778.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','237538',4561635,'1923','290',722385.92,722385.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','237538',4561636,'1924','290',192137.60,192137.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','237538',4561637,'1925','290',1711663.00,1711663.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','237538',4561638,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','237538',4561639,'1927','290',483387.39,483387.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','237538',4561640,'1928','290',161321.00,161321.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','237538',4561641,'1929','291',3820507.43,3826171.11,5663.68,1953969.60,0.00,0.00,0.00,0.00,0.00),('5','107','706','237538',4561642,'1930','291',2707336.39,2714367.30,7030.91,2425663.95,0.00,0.00,0.00,0.00,0.00),('5','107','706','237538',4561643,'1931','291',3853064.71,3853064.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','237538',4561644,'1932','291',3326815.02,3326815.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','237538',4561645,'1933','291',4425915.27,4432612.26,6696.99,2310461.55,0.00,0.00,0.00,0.00,0.00),('5','107','708','237538',4561646,'1934','291',1729141.82,1737639.94,8498.12,2931851.40,0.00,0.00,0.00,0.00,0.00),('5','107','706','237538',4561647,'2898','291',3022668.78,3028679.18,6010.40,2073588.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','237538',4561648,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','237775',4565505,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','237775',4565506,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','237775',4565507,'1877','290',843027.65,843027.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','237775',4565508,'1878','290',190585.39,190585.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','237775',4565509,'1879','290',875620.77,875620.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','237775',4565510,'1880','290',111325.18,111325.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','237775',4565511,'1881','290',1200334.26,1200334.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','237775',4565512,'1882','290',1157189.14,1159251.64,2062.50,340312.50,0.00,0.00,0.00,0.00,0.00),('5','107','697','237775',4565513,'1883','290',559144.00,561135.98,1991.98,328676.70,0.00,0.00,0.00,0.00,0.00),('5','107','697','237775',4565514,'1884','290',131185.41,133043.76,1858.35,306627.75,0.00,0.00,0.00,0.00,0.00),('5','107','697','237775',4565515,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','237775',4565516,'1886','290',2238406.95,2238429.48,22.53,3717.45,0.00,0.00,0.00,0.00,0.00),('5','107','697','237775',4565517,'1887','290',205744.14,206189.38,445.24,73464.60,0.00,0.00,0.00,0.00,0.00),('5','107','697','237775',4565518,'1888','290',196833.58,198723.95,1890.37,311911.05,0.00,0.00,0.00,0.00,0.00),('5','107','696','237775',4565519,'1889','290',3140949.98,3140949.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','237775',4565520,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','237775',4565521,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','237775',4565522,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','237775',4565523,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','237775',4565524,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','237775',4565525,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','237775',4565526,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','237775',4565527,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','237775',4565528,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','237775',4565529,'1899','290',1932106.27,1937698.61,5592.34,922736.10,0.00,0.00,0.00,0.00,0.00),('5','107','699','237775',4565530,'1900','290',501646.57,506724.49,5077.92,837856.80,0.00,0.00,0.00,0.00,0.00),('5','107','699','237775',4565531,'1901','290',1147004.80,1147203.64,198.84,32808.60,0.00,0.00,0.00,0.00,0.00),('5','107','699','237775',4565532,'1902','290',65170.59,69490.43,4319.84,712773.60,0.00,0.00,0.00,0.00,0.00),('5','107','700','237775',4565533,'1903','290',1189933.99,1189933.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','237775',4565534,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','237775',4565535,'1905','290',1480849.88,1480849.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','237775',4565536,'1906','290',705320.00,705320.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','237775',4565537,'1907','290',2030614.95,2030614.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','237775',4565538,'1908','290',670718.77,670718.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','237775',4565539,'1909','290',593099.10,593099.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','237775',4565540,'1910','290',391050.05,391050.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','237775',4565541,'1911','290',1197735.30,1200446.06,2710.76,447275.40,0.00,0.00,0.00,0.00,0.00),('5','107','702','237775',4565542,'1912','290',211373.38,211373.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','237775',4565543,'1913','290',664387.74,666392.01,2004.27,330704.55,0.00,0.00,0.00,0.00,0.00),('5','107','702','237775',4565544,'1914','290',72939.28,72939.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','237775',4565545,'1915','290',263883.09,264930.81,1047.72,172873.80,0.00,0.00,0.00,0.00,0.00),('5','107','702','237775',4565546,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','237775',4565547,'1917','290',1032679.21,1032679.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','237775',4565548,'1918','290',187131.98,187131.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','237775',4565549,'1919','290',508507.82,508507.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','237775',4565550,'1920','290',118545.98,118545.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','237775',4565551,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','237775',4565552,'1922','290',176778.27,176778.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','237775',4565553,'1923','290',722385.92,722385.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','237775',4565554,'1924','290',192137.60,192137.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','237775',4565555,'1925','290',1711663.00,1713215.05,1552.05,256088.25,0.00,0.00,0.00,0.00,0.00),('5','107','705','237775',4565556,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','237775',4565557,'1927','290',483387.39,483387.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','237775',4565558,'1928','290',161321.00,162665.53,1344.53,221847.45,0.00,0.00,0.00,0.00,0.00),('5','107','706','237775',4565559,'1929','291',3826171.11,3832642.68,6471.57,2232691.65,0.00,0.00,0.00,0.00,0.00),('5','107','706','237775',4565560,'1930','291',2714367.30,2727388.16,13020.86,4492196.70,0.00,0.00,0.00,0.00,0.00),('5','107','706','237775',4565561,'1931','291',3853064.71,3865952.14,12887.43,4446163.35,0.00,0.00,0.00,0.00,0.00),('5','107','706','237775',4565562,'1932','291',3326815.02,3339324.36,12509.34,4315722.30,0.00,0.00,0.00,0.00,0.00),('5','107','706','237775',4565563,'1933','291',4432612.26,4443881.97,11269.71,3888049.95,0.00,0.00,0.00,0.00,0.00),('5','107','708','237775',4565564,'1934','291',1737639.94,1740029.88,2389.94,824529.30,0.00,0.00,0.00,0.00,0.00),('5','107','706','237775',4565565,'2898','291',3028679.18,3034870.99,6191.81,2136174.45,0.00,0.00,0.00,0.00,0.00),('5','107','708','237775',4565566,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','237945',4568341,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','237945',4568342,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','237945',4568343,'1877','290',843027.65,843027.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','237945',4568344,'1878','290',190585.39,190585.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','237945',4568345,'1879','290',875620.77,875620.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','237945',4568346,'1880','290',111325.18,111325.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','237945',4568347,'1881','290',1200334.26,1200334.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','237945',4568348,'1882','290',1159251.64,1159251.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','237945',4568349,'1883','290',561135.98,561135.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','237945',4568350,'1884','290',133043.76,133043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','237945',4568351,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','237945',4568352,'1886','290',2238429.48,2238429.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','237945',4568353,'1887','290',206189.38,206189.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','237945',4568354,'1888','290',198723.95,198723.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','237945',4568355,'1889','290',3140949.98,3140949.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','237945',4568356,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','237945',4568357,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','237945',4568358,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','237945',4568359,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','237945',4568360,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','237945',4568361,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','237945',4568362,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','237945',4568363,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','237945',4568364,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','237945',4568365,'1899','290',1937698.61,1937698.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','237945',4568366,'1900','290',506724.49,506724.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','237945',4568367,'1901','290',1147203.64,1147203.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','237945',4568368,'1902','290',69490.43,74057.80,4567.37,753616.05,0.00,0.00,0.00,0.00,0.00),('5','107','700','237945',4568369,'1903','290',1189933.99,1189933.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','237945',4568370,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','237945',4568371,'1905','290',1480849.88,1480849.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','237945',4568372,'1906','290',705320.00,722622.17,17302.17,2854858.05,0.00,0.00,0.00,0.00,0.00),('5','107','701','237945',4568373,'1907','290',2030614.95,2030614.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','237945',4568374,'1908','290',670718.77,670718.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','237945',4568375,'1909','290',593099.10,593099.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','237945',4568376,'1910','290',391050.05,391050.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','237945',4568377,'1911','290',1200446.06,1201488.08,1042.02,171933.30,0.00,0.00,0.00,0.00,0.00),('5','107','702','237945',4568378,'1912','290',211373.38,211373.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','237945',4568379,'1913','290',666392.01,666926.15,534.14,88133.10,0.00,0.00,0.00,0.00,0.00),('5','107','702','237945',4568380,'1914','290',72939.28,72939.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','237945',4568381,'1915','290',264930.81,264930.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','237945',4568382,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','237945',4568383,'1917','290',1032679.21,1032679.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','237945',4568384,'1918','290',187131.98,187131.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','237945',4568385,'1919','290',508507.82,508507.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','237945',4568386,'1920','290',118545.98,118545.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','237945',4568387,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','237945',4568388,'1922','290',176778.27,176778.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','237945',4568389,'1923','290',722385.92,722385.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','237945',4568390,'1924','290',192137.60,192137.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','237945',4568391,'1925','290',1713215.05,1725061.21,11846.16,1954616.40,0.00,0.00,0.00,0.00,0.00),('5','107','705','237945',4568392,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','237945',4568393,'1927','290',483387.39,483387.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','237945',4568394,'1928','290',162665.53,162665.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','237945',4568395,'1929','291',3832642.68,3839261.81,6619.13,2283599.85,0.00,0.00,0.00,0.00,0.00),('5','107','706','237945',4568396,'1930','291',2727388.16,2736029.05,8640.89,2981107.05,0.00,0.00,0.00,0.00,0.00),('5','107','706','237945',4568397,'1931','291',3865952.14,3874436.02,8483.88,2926938.60,0.00,0.00,0.00,0.00,0.00),('5','107','706','237945',4568398,'1932','291',3339324.36,3344374.66,5050.30,1742353.50,0.00,0.00,0.00,0.00,0.00),('5','107','706','237945',4568399,'1933','291',4443881.97,4453858.67,9976.70,3441961.50,0.00,0.00,0.00,0.00,0.00),('5','107','708','237945',4568400,'1934','291',1740029.88,1745321.23,5291.35,1825515.75,0.00,0.00,0.00,0.00,0.00),('5','107','706','237945',4568401,'2898','291',3034870.99,3039573.37,4702.38,1622321.10,0.00,0.00,0.00,0.00,0.00),('5','107','708','237945',4568402,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','238279',4573829,'1875','290',1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','238279',4573830,'1876','290',1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','238279',4573831,'1877','290',843027.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','238279',4573832,'1878','290',190585.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','238279',4573833,'1879','290',875620.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','238279',4573834,'1880','290',111325.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','238279',4573835,'1881','290',1200334.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','238279',4573836,'1882','290',1159251.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','238279',4573837,'1883','290',561135.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','238279',4573838,'1884','290',133043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','238279',4573839,'1885','290',1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','238279',4573840,'1886','290',2238429.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','238279',4573841,'1887','290',206189.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','238279',4573842,'1888','290',198723.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','238279',4573843,'1889','290',3140949.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','238279',4573844,'1890','290',682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','238279',4573845,'1891','290',1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','238279',4573846,'1892','290',1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','238279',4573847,'1893','290',1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','238279',4573848,'1894','290',1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','238279',4573849,'1895','290',688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','238279',4573850,'1896','290',268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','238279',4573851,'1897','290',416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','238279',4573852,'1898','290',65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','238279',4573853,'1899','290',1937698.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','238279',4573854,'1900','290',506724.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','238279',4573855,'1901','290',1147203.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','238279',4573856,'1902','290',74057.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','238279',4573857,'1903','290',1189933.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','238279',4573858,'1904','290',1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','238279',4573859,'1905','290',1480849.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','238279',4573860,'1906','290',722622.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','238279',4573861,'1907','290',2030614.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','238279',4573862,'1908','290',670718.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','238279',4573863,'1909','290',593099.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','238279',4573864,'1910','290',391050.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','238279',4573865,'1911','290',1201488.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','238279',4573866,'1912','290',211373.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','238279',4573867,'1913','290',666926.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','238279',4573868,'1914','290',72939.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','238279',4573869,'1915','290',264930.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','238279',4573870,'1916','290',22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','238279',4573871,'1917','290',1032679.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','238279',4573872,'1918','290',187131.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','238279',4573873,'1919','290',508507.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','238279',4573874,'1920','290',118545.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','238279',4573875,'1921','290',922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','238279',4573876,'1922','290',176778.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','238279',4573877,'1923','290',722385.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','238279',4573878,'1924','290',192137.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','238279',4573879,'1925','290',1725061.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','238279',4573880,'1926','290',45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','238279',4573881,'1927','290',483387.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','238279',4573882,'1928','290',162665.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','238279',4573883,'1929','291',3839261.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','238279',4573884,'1930','291',2736029.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','238279',4573885,'1931','291',3874436.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','238279',4573886,'1932','291',3344374.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','238279',4573887,'1933','291',4453858.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','238279',4573888,'1934','291',1745321.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','238279',4573889,'2898','291',3039573.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','238279',4573890,'2899','291',3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','238295',4574236,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','238295',4574237,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','238295',4574238,'1877','290',843027.65,843027.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','238295',4574239,'1878','290',190585.39,190585.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','238295',4574240,'1879','290',875620.77,884611.27,8990.50,1483432.50,0.00,0.00,0.00,0.00,0.00),('5','107','696','238295',4574241,'1880','290',111325.18,111325.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','238295',4574242,'1881','290',1200334.26,1200334.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','238295',4574243,'1882','290',1159251.64,1159251.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','238295',4574244,'1883','290',561135.98,561135.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','238295',4574245,'1884','290',133043.76,133043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','238295',4574246,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','238295',4574247,'1886','290',2238429.48,2238429.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','238295',4574248,'1887','290',206189.38,206189.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','238295',4574249,'1888','290',198723.95,198723.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','238295',4574250,'1889','290',3140949.98,3151110.98,10161.00,1676565.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','238295',4574251,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','238295',4574252,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','238295',4574253,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','238295',4574254,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','238295',4574255,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','238295',4574256,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','238295',4574257,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','238295',4574258,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','238295',4574259,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','238295',4574260,'1899','290',1937698.61,1937698.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','238295',4574261,'1900','290',506724.49,506724.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','238295',4574262,'1901','290',1147203.64,1147203.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','238295',4574263,'1902','290',74057.80,74057.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','238295',4574264,'1903','290',1189933.99,1189933.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','238295',4574265,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','238295',4574266,'1905','290',1480849.88,1480849.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','238295',4574267,'1906','290',722622.17,730657.94,8035.77,1325902.05,0.00,0.00,0.00,0.00,0.00),('5','107','701','238295',4574268,'1907','290',2030614.95,2030614.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','238295',4574269,'1908','290',670718.77,670718.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','238295',4574270,'1909','290',593099.10,593099.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','238295',4574271,'1910','290',391050.05,391050.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','238295',4574272,'1911','290',1201488.08,1201488.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','238295',4574273,'1912','290',211373.38,211373.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','238295',4574274,'1913','290',666926.15,666926.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','238295',4574275,'1914','290',72939.28,72939.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','238295',4574276,'1915','290',264930.81,274155.41,9224.60,1522059.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','238295',4574277,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','238295',4574278,'1917','290',1032679.21,1032679.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','238295',4574279,'1918','290',187131.98,187131.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','238295',4574280,'1919','290',508507.82,508507.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','238295',4574281,'1920','290',118545.98,118545.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','238295',4574282,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','238295',4574283,'1922','290',176778.27,186404.17,9625.90,1588273.50,0.00,0.00,0.00,0.00,0.00),('5','107','704','238295',4574284,'1923','290',722385.92,722385.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','238295',4574285,'1924','290',192137.60,192137.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','238295',4574286,'1925','290',1725061.21,1725061.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','238295',4574287,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','238295',4574288,'1927','290',483387.39,483387.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','238295',4574289,'1928','290',162665.53,162665.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','238295',4574290,'1929','291',3839261.81,3847738.95,8477.14,2924613.30,0.00,0.00,0.00,0.00,0.00),('5','107','706','238295',4574291,'1930','291',2736029.05,2747061.75,11032.70,3806281.50,0.00,0.00,0.00,0.00,0.00),('5','107','706','238295',4574292,'1931','291',3874436.02,3881755.64,7319.62,2525268.90,0.00,0.00,0.00,0.00,0.00),('5','107','706','238295',4574293,'1932','291',3344374.66,3351202.39,6827.73,2355566.85,0.00,0.00,0.00,0.00,0.00),('5','107','706','238295',4574294,'1933','291',4453858.67,4461741.43,7882.76,2719552.20,0.00,0.00,0.00,0.00,0.00),('5','107','708','238295',4574295,'1934','291',1745321.23,1748329.04,3007.81,1037694.45,0.00,0.00,0.00,0.00,0.00),('5','107','706','238295',4574296,'2898','291',3039573.37,3045397.38,5824.01,2009283.45,0.00,0.00,0.00,0.00,0.00),('5','107','708','238295',4574297,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','238492',4577522,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','238492',4577523,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','238492',4577524,'1877','290',843027.65,846593.98,3566.33,588444.45,0.00,0.00,0.00,0.00,0.00),('5','107','696','238492',4577525,'1878','290',190585.39,195218.56,4633.17,764473.05,0.00,0.00,0.00,0.00,0.00),('5','107','696','238492',4577526,'1879','290',884611.27,885229.48,618.21,102004.65,0.00,0.00,0.00,0.00,0.00),('5','107','696','238492',4577527,'1880','290',111325.18,111394.92,69.74,11507.10,0.00,0.00,0.00,0.00,0.00),('5','107','697','238492',4577528,'1881','290',1200334.26,1200334.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','238492',4577529,'1882','290',1159251.64,1159251.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','238492',4577530,'1883','290',561135.98,561135.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','238492',4577531,'1884','290',133043.76,133043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','238492',4577532,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','238492',4577533,'1886','290',2238429.48,2238429.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','238492',4577534,'1887','290',206189.38,206189.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','238492',4577535,'1888','290',198723.95,198723.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','238492',4577536,'1889','290',3151110.98,3160835.39,9724.41,1604527.65,0.00,0.00,0.00,0.00,0.00),('5','107','696','238492',4577537,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','238492',4577538,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','238492',4577539,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','238492',4577540,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','238492',4577541,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','238492',4577542,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','238492',4577543,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','238492',4577544,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','238492',4577545,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','238492',4577546,'1899','290',1937698.61,1937698.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','238492',4577547,'1900','290',506724.49,506724.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','238492',4577548,'1901','290',1147203.64,1147203.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','238492',4577549,'1902','290',74057.80,74057.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','238492',4577550,'1903','290',1189933.99,1189933.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','238492',4577551,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','238492',4577552,'1905','290',1480849.88,1480849.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','238492',4577553,'1906','290',730657.94,741317.52,10659.58,1758830.70,0.00,0.00,0.00,0.00,0.00),('5','107','701','238492',4577554,'1907','290',2030614.95,2036976.23,6361.28,1049611.20,0.00,0.00,0.00,0.00,0.00),('5','107','701','238492',4577555,'1908','290',670718.77,670718.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','238492',4577556,'1909','290',593099.10,597944.63,4845.53,799512.45,0.00,0.00,0.00,0.00,0.00),('5','107','701','238492',4577557,'1910','290',391050.05,391050.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','238492',4577558,'1911','290',1201488.08,1201488.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','238492',4577559,'1912','290',211373.38,211373.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','238492',4577560,'1913','290',666926.15,666926.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','238492',4577561,'1914','290',72939.28,72939.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','238492',4577562,'1915','290',274155.41,283060.29,8904.88,1469305.20,0.00,0.00,0.00,0.00,0.00),('5','107','702','238492',4577563,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','238492',4577564,'1917','290',1032679.21,1032679.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','238492',4577565,'1918','290',187131.98,190224.10,3092.12,510199.80,0.00,0.00,0.00,0.00,0.00),('5','107','703','238492',4577566,'1919','290',508507.82,508507.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','238492',4577567,'1920','290',118545.98,118545.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','238492',4577568,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','238492',4577569,'1922','290',186404.17,195619.89,9215.72,1520593.80,0.00,0.00,0.00,0.00,0.00),('5','107','704','238492',4577570,'1923','290',722385.92,722385.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','238492',4577571,'1924','290',192137.60,192137.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','238492',4577572,'1925','290',1725061.21,1725061.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','238492',4577573,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','238492',4577574,'1927','290',483387.39,483387.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','238492',4577575,'1928','290',162665.53,162665.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','238492',4577576,'1929','291',3847738.95,3855492.67,7753.72,2675033.40,0.00,0.00,0.00,0.00,0.00),('5','107','706','238492',4577577,'1930','291',2747061.75,2758805.39,11743.64,4051555.80,0.00,0.00,0.00,0.00,0.00),('5','107','706','238492',4577578,'1931','291',3881755.64,3887427.23,5671.59,1956698.55,0.00,0.00,0.00,0.00,0.00),('5','107','706','238492',4577579,'1932','291',3351202.39,3359410.45,8208.06,2831780.70,0.00,0.00,0.00,0.00,0.00),('5','107','706','238492',4577580,'1933','291',4461741.43,4470598.63,8857.20,3055734.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','238492',4577581,'1934','291',1748329.04,1757152.99,8823.95,3044262.75,0.00,0.00,0.00,0.00,0.00),('5','107','706','238492',4577582,'2898','291',3045397.38,3050880.67,5483.29,1891735.05,0.00,0.00,0.00,0.00,0.00),('5','107','708','238492',4577583,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','238669',4580514,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','238669',4580515,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','238669',4580516,'1877','290',846593.98,846910.00,316.02,52143.30,0.00,0.00,0.00,0.00,0.00),('5','107','696','238669',4580517,'1878','290',195218.56,198561.78,3343.22,551631.30,0.00,0.00,0.00,0.00,0.00),('5','107','696','238669',4580518,'1879','290',885229.48,885229.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','238669',4580519,'1880','290',111394.92,111394.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','238669',4580520,'1881','290',1200334.26,1200495.43,161.17,26593.05,0.00,0.00,0.00,0.00,0.00),('5','107','697','238669',4580521,'1882','290',1159251.64,1171043.55,11791.91,1945665.15,0.00,0.00,0.00,0.00,0.00),('5','107','697','238669',4580522,'1883','290',561135.98,561135.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','238669',4580523,'1884','290',133043.76,133043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','238669',4580524,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','238669',4580525,'1886','290',2238429.48,2238467.28,37.80,6237.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','238669',4580526,'1887','290',206189.38,206189.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','238669',4580527,'1888','290',198723.95,198723.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','238669',4580528,'1889','290',3160835.39,3164123.15,3287.76,542480.40,0.00,0.00,0.00,0.00,0.00),('5','107','696','238669',4580529,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','238669',4580530,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','238669',4580531,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','238669',4580532,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','238669',4580533,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','238669',4580534,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','238669',4580535,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','238669',4580536,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','238669',4580537,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','238669',4580538,'1899','290',1937698.61,1937698.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','238669',4580539,'1900','290',506724.49,509542.55,2818.06,464979.90,0.00,0.00,0.00,0.00,0.00),('5','107','699','238669',4580540,'1901','290',1147203.64,1147203.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','238669',4580541,'1902','290',74057.80,74057.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','238669',4580542,'1903','290',1189933.99,1189933.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','238669',4580543,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','238669',4580544,'1905','290',1480849.88,1480849.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','238669',4580545,'1906','290',741317.52,748807.16,7489.64,1235790.60,0.00,0.00,0.00,0.00,0.00),('5','107','701','238669',4580546,'1907','290',2036976.23,2036976.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','238669',4580547,'1908','290',670718.77,676922.23,6203.46,1023570.90,0.00,0.00,0.00,0.00,0.00),('5','107','701','238669',4580548,'1909','290',597944.63,597944.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','238669',4580549,'1910','290',391050.05,391050.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','238669',4580550,'1911','290',1201488.08,1201488.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','238669',4580551,'1912','290',211373.38,211373.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','238669',4580552,'1913','290',666926.15,666926.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','238669',4580553,'1914','290',72939.28,72939.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','238669',4580554,'1915','290',283060.29,283060.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','238669',4580555,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','238669',4580556,'1917','290',1032679.21,1032679.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','238669',4580557,'1918','290',190224.10,192719.38,2495.28,411721.20,0.00,0.00,0.00,0.00,0.00),('5','107','703','238669',4580558,'1919','290',508507.82,514864.18,6356.36,1048799.40,0.00,0.00,0.00,0.00,0.00),('5','107','703','238669',4580559,'1920','290',118545.98,120381.17,1835.19,302806.35,0.00,0.00,0.00,0.00,0.00),('5','107','704','238669',4580560,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','238669',4580561,'1922','290',195619.89,205943.51,10323.62,1703397.30,0.00,0.00,0.00,0.00,0.00),('5','107','704','238669',4580562,'1923','290',722385.92,724282.06,1896.14,312863.10,0.00,0.00,0.00,0.00,0.00),('5','107','704','238669',4580563,'1924','290',192137.60,192137.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','238669',4580564,'1925','290',1725061.21,1725061.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','238669',4580565,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','238669',4580566,'1927','290',483387.39,483387.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','238669',4580567,'1928','290',162665.53,162665.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','238669',4580568,'1929','291',3855492.67,3863991.25,8498.58,2932010.10,0.00,0.00,0.00,0.00,0.00),('5','107','706','238669',4580569,'1930','291',2758805.39,2769847.58,11042.19,3809555.55,0.00,0.00,0.00,0.00,0.00),('5','107','706','238669',4580570,'1931','291',3887427.23,3892817.60,5390.37,1859677.65,0.00,0.00,0.00,0.00,0.00),('5','107','706','238669',4580571,'1932','291',3359410.45,3365413.26,6002.81,2070969.45,0.00,0.00,0.00,0.00,0.00),('5','107','706','238669',4580572,'1933','291',4470598.63,4476859.82,6261.19,2160110.55,0.00,0.00,0.00,0.00,0.00),('5','107','708','238669',4580573,'1934','291',1757152.99,1762697.30,5544.31,1912786.95,0.00,0.00,0.00,0.00,0.00),('5','107','706','238669',4580574,'2898','291',3050880.67,3055734.87,4854.20,1674699.00,0.00,0.00,0.00,0.00,0.00),('5','107','708','238669',4580575,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','238917',4584966,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','238917',4584967,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','238917',4584968,'1877','290',846910.00,846910.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','238917',4584969,'1878','290',198561.78,198561.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','238917',4584970,'1879','290',885229.48,885229.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','238917',4584971,'1880','290',111394.92,111394.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','238917',4584972,'1881','290',1200495.43,1200495.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','238917',4584973,'1882','290',1171043.55,1177127.35,6083.80,1003827.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','238917',4584974,'1883','290',561135.98,562207.00,1071.02,176718.30,0.00,0.00,0.00,0.00,0.00),('5','107','697','238917',4584975,'1884','290',133043.76,133043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','238917',4584976,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','238917',4584977,'1886','290',2238467.28,2238467.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','238917',4584978,'1887','290',206189.38,206189.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','238917',4584979,'1888','290',198723.95,205121.98,6398.03,1055674.95,0.00,0.00,0.00,0.00,0.00),('5','107','696','238917',4584980,'1889','290',3164123.15,3164141.40,18.25,3011.25,0.00,0.00,0.00,0.00,0.00),('5','107','696','238917',4584981,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','238917',4584982,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','238917',4584983,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','238917',4584984,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','238917',4584985,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','238917',4584986,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','238917',4584987,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','238917',4584988,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','238917',4584989,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','238917',4584990,'1899','290',1937698.61,1943795.37,6096.76,1005965.40,0.00,0.00,0.00,0.00,0.00),('5','107','699','238917',4584991,'1900','290',509542.55,514011.61,4469.06,737394.90,0.00,0.00,0.00,0.00,0.00),('5','107','699','238917',4584992,'1901','290',1147203.64,1147203.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','238917',4584993,'1902','290',74057.80,81228.93,7171.13,1183236.45,0.00,0.00,0.00,0.00,0.00),('5','107','700','238917',4584994,'1903','290',1189933.99,1199886.89,9952.90,1642228.50,0.00,0.00,0.00,0.00,0.00),('5','107','700','238917',4584995,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','238917',4584996,'1905','290',1480849.88,1480849.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','238917',4584997,'1906','290',748807.16,748807.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','238917',4584998,'1907','290',2036976.23,2042557.65,5581.42,920934.30,0.00,0.00,0.00,0.00,0.00),('5','107','701','238917',4584999,'1908','290',676922.23,676922.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','238917',4585000,'1909','290',597944.63,597944.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','238917',4585001,'1910','290',391050.05,391050.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','238917',4585002,'1911','290',1201488.08,1201488.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','238917',4585003,'1912','290',211373.38,211373.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','238917',4585004,'1913','290',666926.15,666927.21,1.06,174.90,0.00,0.00,0.00,0.00,0.00),('5','107','702','238917',4585005,'1914','290',72939.28,72939.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','238917',4585006,'1915','290',283060.29,283060.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','238917',4585007,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','238917',4585008,'1917','290',1032679.21,1032679.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','238917',4585009,'1918','290',192719.38,201297.28,8577.90,1415353.50,0.00,0.00,0.00,0.00,0.00),('5','107','703','238917',4585010,'1919','290',514864.18,514864.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','238917',4585011,'1920','290',120381.17,123048.95,2667.78,440183.70,0.00,0.00,0.00,0.00,0.00),('5','107','704','238917',4585012,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','238917',4585013,'1922','290',205943.51,205943.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','238917',4585014,'1923','290',724282.06,734030.22,9748.16,1608446.40,0.00,0.00,0.00,0.00,0.00),('5','107','704','238917',4585015,'1924','290',192137.60,192137.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','238917',4585016,'1925','290',1725061.21,1732376.86,7315.65,1207082.25,0.00,0.00,0.00,0.00,0.00),('5','107','705','238917',4585017,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','238917',4585018,'1927','290',483387.39,483387.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','238917',4585019,'1928','290',162665.53,162665.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','238917',4585020,'1929','291',3863991.25,3869717.98,5726.73,1975721.85,0.00,0.00,0.00,0.00,0.00),('5','107','706','238917',4585021,'1930','291',2769847.58,2780481.19,10633.61,3668595.45,0.00,0.00,0.00,0.00,0.00),('5','107','706','238917',4585022,'1931','291',3892817.60,3900836.55,8018.95,2766537.75,0.00,0.00,0.00,0.00,0.00),('5','107','706','238917',4585023,'1932','291',3365413.26,3371093.33,5680.07,1959624.15,0.00,0.00,0.00,0.00,0.00),('5','107','706','238917',4585024,'1933','291',4476859.82,4484235.58,7375.76,2544637.20,0.00,0.00,0.00,0.00,0.00),('5','107','708','238917',4585025,'1934','291',1762697.30,1764073.80,1376.50,474892.50,0.00,0.00,0.00,0.00,0.00),('5','107','706','238917',4585026,'2898','291',3055734.87,3061798.11,6063.24,2091817.80,0.00,0.00,0.00,0.00,0.00),('5','107','708','238917',4585027,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','239013',4586806,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','239013',4586807,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','239013',4586808,'1877','290',846910.00,846919.75,9.75,1608.75,0.00,0.00,0.00,0.00,0.00),('5','107','696','239013',4586809,'1878','290',198561.78,207474.94,8913.16,1470671.40,0.00,0.00,0.00,0.00,0.00),('5','107','696','239013',4586810,'1879','290',885229.48,885229.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','239013',4586811,'1880','290',111394.92,111394.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','239013',4586812,'1881','290',1200495.43,1200495.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','239013',4586813,'1882','290',1177127.35,1177127.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','239013',4586814,'1883','290',562207.00,562207.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','239013',4586815,'1884','290',133043.76,133043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','239013',4586816,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','239013',4586817,'1886','290',2238467.28,2238467.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','239013',4586818,'1887','290',206189.38,206189.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','239013',4586819,'1888','290',205121.98,207841.66,2719.68,448747.20,0.00,0.00,0.00,0.00,0.00),('5','107','696','239013',4586820,'1889','290',3164141.40,3174124.44,9983.04,1647201.60,0.00,0.00,0.00,0.00,0.00),('5','107','696','239013',4586821,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','239013',4586822,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','239013',4586823,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','239013',4586824,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','239013',4586825,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','239013',4586826,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','239013',4586827,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','239013',4586828,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','239013',4586829,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','239013',4586830,'1899','290',1943795.37,1945176.90,1381.53,227952.45,0.00,0.00,0.00,0.00,0.00),('5','107','699','239013',4586831,'1900','290',514011.61,514011.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','239013',4586832,'1901','290',1147203.64,1147203.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','239013',4586833,'1902','290',81228.93,82611.51,1382.58,228125.70,0.00,0.00,0.00,0.00,0.00),('5','107','700','239013',4586834,'1903','290',1199886.89,1206496.32,6609.43,1090555.95,0.00,0.00,0.00,0.00,0.00),('5','107','700','239013',4586835,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','239013',4586836,'1905','290',1480849.88,1480849.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','239013',4586837,'1906','290',748807.16,750843.07,2035.91,335925.15,0.00,0.00,0.00,0.00,0.00),('5','107','701','239013',4586838,'1907','290',2042557.65,2048296.86,5739.21,946969.65,0.00,0.00,0.00,0.00,0.00),('5','107','701','239013',4586839,'1908','290',676922.23,676922.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','239013',4586840,'1909','290',597944.63,603126.30,5181.67,854975.55,0.00,0.00,0.00,0.00,0.00),('5','107','701','239013',4586841,'1910','290',391050.05,391050.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','239013',4586842,'1911','290',1201488.08,1201488.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','239013',4586843,'1912','290',211373.38,211373.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','239013',4586844,'1913','290',666927.21,666927.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','239013',4586845,'1914','290',72939.28,72939.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','239013',4586846,'1915','290',283060.29,283060.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','239013',4586847,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','239013',4586848,'1917','290',1032679.21,1032998.75,319.54,52724.10,0.00,0.00,0.00,0.00,0.00),('5','107','703','239013',4586849,'1918','290',201297.28,203306.52,2009.24,331524.60,0.00,0.00,0.00,0.00,0.00),('5','107','703','239013',4586850,'1919','290',514864.18,516867.80,2003.62,330597.30,0.00,0.00,0.00,0.00,0.00),('5','107','703','239013',4586851,'1920','290',123048.95,123048.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','239013',4586852,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','239013',4586853,'1922','290',205943.51,205943.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','239013',4586854,'1923','290',734030.22,737599.49,3569.27,588929.55,0.00,0.00,0.00,0.00,0.00),('5','107','704','239013',4586855,'1924','290',192137.60,192137.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','239013',4586856,'1925','290',1732376.86,1740422.14,8045.28,1327471.20,0.00,0.00,0.00,0.00,0.00),('5','107','705','239013',4586857,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','239013',4586858,'1927','290',483387.39,483387.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','239013',4586859,'1928','290',162665.53,162665.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','239013',4586860,'1929','291',3869717.98,3876583.80,6865.82,2368707.90,0.00,0.00,0.00,0.00,0.00),('5','107','706','239013',4586861,'1930','291',2780481.19,2788459.52,7978.33,2752523.85,0.00,0.00,0.00,0.00,0.00),('5','107','706','239013',4586862,'1931','291',3900836.55,3907401.99,6565.44,2265076.80,0.00,0.00,0.00,0.00,0.00),('5','107','706','239013',4586863,'1932','291',3371093.33,3378465.99,7372.66,2543567.70,0.00,0.00,0.00,0.00,0.00),('5','107','706','239013',4586864,'1933','291',4484235.58,4490930.62,6695.04,2309788.80,0.00,0.00,0.00,0.00,0.00),('5','107','708','239013',4586865,'1934','291',1764073.80,1769608.48,5534.68,1909464.60,0.00,0.00,0.00,0.00,0.00),('5','107','706','239013',4586866,'2898','291',3061798.11,3066892.57,5094.46,1757588.70,0.00,0.00,0.00,0.00,0.00),('5','107','708','239013',4586867,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','239391',4593158,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','239391',4593159,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','239391',4593160,'1877','290',846919.75,846950.05,30.30,4999.50,0.00,0.00,0.00,0.00,0.00),('5','107','696','239391',4593161,'1878','290',207474.94,209421.55,1946.61,321190.65,0.00,0.00,0.00,0.00,0.00),('5','107','696','239391',4593162,'1879','290',885229.48,885229.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','239391',4593163,'1880','290',111394.92,112294.76,899.84,148473.60,0.00,0.00,0.00,0.00,0.00),('5','107','697','239391',4593164,'1881','290',1200495.43,1200495.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','239391',4593165,'1882','290',1177127.35,1180877.10,3749.75,618708.75,0.00,0.00,0.00,0.00,0.00),('5','107','697','239391',4593166,'1883','290',562207.00,570096.65,7889.65,1301792.25,0.00,0.00,0.00,0.00,0.00),('5','107','697','239391',4593167,'1884','290',133043.76,133043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','239391',4593168,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','239391',4593169,'1886','290',2238467.28,2238467.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','239391',4593170,'1887','290',206189.38,206189.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','239391',4593171,'1888','290',207841.66,217400.89,9559.23,1577272.95,0.00,0.00,0.00,0.00,0.00),('5','107','696','239391',4593172,'1889','290',3174124.44,3179459.75,5335.31,880326.15,0.00,0.00,0.00,0.00,0.00),('5','107','696','239391',4593173,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','239391',4593174,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','239391',4593175,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','239391',4593176,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','239391',4593177,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','239391',4593178,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','239391',4593179,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','239391',4593180,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','239391',4593181,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','239391',4593182,'1899','290',1945176.90,1955575.29,10398.39,1715734.35,0.00,0.00,0.00,0.00,0.00),('5','107','699','239391',4593183,'1900','290',514011.61,514011.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','239391',4593184,'1901','290',1147203.64,1147203.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','239391',4593185,'1902','290',82611.51,89610.27,6998.76,1154795.40,0.00,0.00,0.00,0.00,0.00),('5','107','700','239391',4593186,'1903','290',1206496.32,1206496.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','239391',4593187,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','239391',4593188,'1905','290',1480849.88,1480849.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','239391',4593189,'1906','290',750843.07,750843.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','239391',4593190,'1907','290',2048296.86,2048296.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','239391',4593191,'1908','290',676922.23,679001.68,2079.45,343109.25,0.00,0.00,0.00,0.00,0.00),('5','107','701','239391',4593192,'1909','290',603126.30,603126.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','239391',4593193,'1910','290',391050.05,391050.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','239391',4593194,'1911','290',1201488.08,1201488.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','239391',4593195,'1912','290',211373.38,211373.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','239391',4593196,'1913','290',666927.21,666927.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','239391',4593197,'1914','290',72939.28,72939.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','239391',4593198,'1915','290',283060.29,283060.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','239391',4593199,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','239391',4593200,'1917','290',1032998.75,1032998.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','239391',4593201,'1918','290',203306.52,211450.50,8143.98,1343756.70,0.00,0.00,0.00,0.00,0.00),('5','107','703','239391',4593202,'1919','290',516867.80,521295.78,4427.98,730616.70,0.00,0.00,0.00,0.00,0.00),('5','107','703','239391',4593203,'1920','290',123048.95,125021.65,1972.70,325495.50,0.00,0.00,0.00,0.00,0.00),('5','107','704','239391',4593204,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','239391',4593205,'1922','290',205943.51,205943.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','239391',4593206,'1923','290',737599.49,737599.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','239391',4593207,'1924','290',192137.60,192137.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','239391',4593208,'1925','290',1740422.14,1748033.96,7611.82,1255950.30,0.00,0.00,0.00,0.00,0.00),('5','107','705','239391',4593209,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','239391',4593210,'1927','290',483387.39,483387.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','239391',4593211,'1928','290',162665.53,167081.52,4415.99,728638.35,0.00,0.00,0.00,0.00,0.00),('5','107','706','239391',4593212,'1929','291',3876583.80,3883291.05,6707.25,2314001.25,0.00,0.00,0.00,0.00,0.00),('5','107','706','239391',4593213,'1930','291',2788459.52,2797051.14,8591.62,2964108.90,0.00,0.00,0.00,0.00,0.00),('5','107','706','239391',4593214,'1931','291',3907401.99,3915293.99,7892.00,2722740.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','239391',4593215,'1932','291',3378465.99,3385925.99,7460.00,2573700.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','239391',4593216,'1933','291',4490930.62,4501026.10,10095.48,3482940.60,0.00,0.00,0.00,0.00,0.00),('5','107','708','239391',4593217,'1934','291',1769608.48,1774958.04,5349.56,1845598.20,0.00,0.00,0.00,0.00,0.00),('5','107','706','239391',4593218,'2898','291',3066892.57,3073432.07,6539.50,2256127.50,0.00,0.00,0.00,0.00,0.00),('5','107','708','239391',4593219,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','239695',4598507,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','239695',4598508,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','239695',4598509,'1877','290',846950.05,846951.26,1.21,199.65,0.00,0.00,0.00,0.00,0.00),('5','107','696','239695',4598510,'1878','290',209421.55,213394.36,3972.81,655513.65,0.00,0.00,0.00,0.00,0.00),('5','107','696','239695',4598511,'1879','290',885229.48,885229.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','239695',4598512,'1880','290',112294.76,112838.90,544.14,89783.10,0.00,0.00,0.00,0.00,0.00),('5','107','697','239695',4598513,'1881','290',1200495.43,1200495.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','239695',4598514,'1882','290',1180877.10,1180877.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','239695',4598515,'1883','290',570096.65,574574.40,4477.75,738828.75,0.00,0.00,0.00,0.00,0.00),('5','107','697','239695',4598516,'1884','290',133043.76,133043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','239695',4598517,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','239695',4598518,'1886','290',2238467.28,2238467.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','239695',4598519,'1887','290',206189.38,206189.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','239695',4598520,'1888','290',217400.89,225812.83,8411.94,1387970.10,0.00,0.00,0.00,0.00,0.00),('5','107','696','239695',4598521,'1889','290',3179459.75,3187639.86,8180.11,1349718.15,0.00,0.00,0.00,0.00,0.00),('5','107','696','239695',4598522,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','239695',4598523,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','239695',4598524,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','239695',4598525,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','239695',4598526,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','239695',4598527,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','239695',4598528,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','239695',4598529,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','239695',4598530,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','239695',4598531,'1899','290',1955575.29,1957516.83,1941.54,320354.10,0.00,0.00,0.00,0.00,0.00),('5','107','699','239695',4598532,'1900','290',514011.61,518203.80,4192.19,691711.35,0.00,0.00,0.00,0.00,0.00),('5','107','699','239695',4598533,'1901','290',1147203.64,1147203.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','239695',4598534,'1902','290',89610.27,93965.13,4354.86,718551.90,0.00,0.00,0.00,0.00,0.00),('5','107','700','239695',4598535,'1903','290',1206496.32,1215100.98,8604.66,1419768.90,0.00,0.00,0.00,0.00,0.00),('5','107','700','239695',4598536,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','239695',4598537,'1905','290',1480849.88,1480849.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','239695',4598538,'1906','290',750843.07,756307.83,5464.76,901685.40,0.00,0.00,0.00,0.00,0.00),('5','107','701','239695',4598539,'1907','290',2048296.86,2048296.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','239695',4598540,'1908','290',679001.68,679001.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','239695',4598541,'1909','290',603126.30,603126.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','239695',4598542,'1910','290',391050.05,391050.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','239695',4598543,'1911','290',1201488.08,1201488.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','239695',4598544,'1912','290',211373.38,211373.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','239695',4598545,'1913','290',666927.21,666927.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','239695',4598546,'1914','290',72939.28,72939.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','239695',4598547,'1915','290',283060.29,283060.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','239695',4598548,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','239695',4598549,'1917','290',1032998.75,1032998.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','239695',4598550,'1918','290',211450.50,216572.45,5121.95,845121.75,0.00,0.00,0.00,0.00,0.00),('5','107','703','239695',4598551,'1919','290',521295.78,522553.55,1257.77,207532.05,0.00,0.00,0.00,0.00,0.00),('5','107','703','239695',4598552,'1920','290',125021.65,126895.97,1874.32,309262.80,0.00,0.00,0.00,0.00,0.00),('5','107','704','239695',4598553,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','239695',4598554,'1922','290',205943.51,205943.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','239695',4598555,'1923','290',737599.49,737599.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','239695',4598556,'1924','290',192137.60,192137.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','239695',4598557,'1925','290',1748033.96,1752962.24,4928.28,813166.20,0.00,0.00,0.00,0.00,0.00),('5','107','705','239695',4598558,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','239695',4598559,'1927','290',483387.39,483387.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','239695',4598560,'1928','290',167081.52,171940.57,4859.05,801743.25,0.00,0.00,0.00,0.00,0.00),('5','107','706','239695',4598561,'1929','291',3883291.05,3889841.44,6550.39,2259884.55,0.00,0.00,0.00,0.00,0.00),('5','107','706','239695',4598562,'1930','291',2797051.14,2806523.76,9472.62,3268053.90,0.00,0.00,0.00,0.00,0.00),('5','107','706','239695',4598563,'1931','291',3915293.99,3917718.98,2424.99,836621.55,0.00,0.00,0.00,0.00,0.00),('5','107','706','239695',4598564,'1932','291',3385925.99,3398391.99,12466.00,4300770.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','239695',4598565,'1933','291',4501026.10,4508252.60,7226.50,2493142.50,0.00,0.00,0.00,0.00,0.00),('5','107','708','239695',4598566,'1934','291',1774958.04,1777461.80,2503.76,863797.20,0.00,0.00,0.00,0.00,0.00),('5','107','706','239695',4598567,'2898','291',3073432.07,3079536.11,6104.04,2105893.80,0.00,0.00,0.00,0.00,0.00),('5','107','708','239695',4598568,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','239942',4602802,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','239942',4602803,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','239942',4602804,'1877','290',846951.26,846951.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','239942',4602805,'1878','290',213394.36,216185.60,2791.24,460554.60,0.00,0.00,0.00,0.00,0.00),('5','107','696','239942',4602806,'1879','290',885229.48,885229.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','239942',4602807,'1880','290',112838.90,112838.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','239942',4602808,'1881','290',1200495.43,1200495.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','239942',4602809,'1882','290',1180877.10,1180877.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','239942',4602810,'1883','290',574574.40,577058.10,2483.70,409810.50,0.00,0.00,0.00,0.00,0.00),('5','107','697','239942',4602811,'1884','290',133043.76,133043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','239942',4602812,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','239942',4602813,'1886','290',2238467.28,2238467.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','239942',4602814,'1887','290',206189.38,206189.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','239942',4602815,'1888','290',225812.83,231119.68,5306.85,875630.25,0.00,0.00,0.00,0.00,0.00),('5','107','696','239942',4602816,'1889','290',3187639.86,3198082.58,10442.72,1723048.80,0.00,0.00,0.00,0.00,0.00),('5','107','696','239942',4602817,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','239942',4602818,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','239942',4602819,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','239942',4602820,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','239942',4602821,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','239942',4602822,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','239942',4602823,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','239942',4602824,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','239942',4602825,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','239942',4602826,'1899','290',1957516.83,1966491.89,8975.06,1480884.90,0.00,0.00,0.00,0.00,0.00),('5','107','699','239942',4602827,'1900','290',518203.80,518203.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','239942',4602828,'1901','290',1147203.64,1147276.09,72.45,11954.25,0.00,0.00,0.00,0.00,0.00),('5','107','699','239942',4602829,'1902','290',93965.13,99221.96,5256.83,867376.95,0.00,0.00,0.00,0.00,0.00),('5','107','700','239942',4602830,'1903','290',1215100.98,1224502.75,9401.77,1551292.05,0.00,0.00,0.00,0.00,0.00),('5','107','700','239942',4602831,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','239942',4602832,'1905','290',1480849.88,1480849.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','239942',4602833,'1906','290',756307.83,760370.58,4062.75,670353.75,0.00,0.00,0.00,0.00,0.00),('5','107','701','239942',4602834,'1907','290',2048296.86,2051803.73,3506.87,578633.55,0.00,0.00,0.00,0.00,0.00),('5','107','701','239942',4602835,'1908','290',679001.68,679001.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','239942',4602836,'1909','290',603126.30,606460.16,3333.86,550086.90,0.00,0.00,0.00,0.00,0.00),('5','107','701','239942',4602837,'1910','290',391050.05,391050.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','239942',4602838,'1911','290',1201488.08,1201488.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','239942',4602839,'1912','290',211373.38,211373.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','239942',4602840,'1913','290',666927.21,666927.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','239942',4602841,'1914','290',72939.28,72939.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','239942',4602842,'1915','290',283060.29,283060.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','239942',4602843,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','239942',4602844,'1917','290',1032998.75,1033041.34,42.59,7027.35,0.00,0.00,0.00,0.00,0.00),('5','107','703','239942',4602845,'1918','290',216572.45,222117.31,5544.86,914901.90,0.00,0.00,0.00,0.00,0.00),('5','107','703','239942',4602846,'1919','290',522553.55,526107.19,3553.64,586350.60,0.00,0.00,0.00,0.00,0.00),('5','107','703','239942',4602847,'1920','290',126895.97,126895.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','239942',4602848,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','239942',4602849,'1922','290',205943.51,205943.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','239942',4602850,'1923','290',737599.49,742229.47,4629.98,763946.70,0.00,0.00,0.00,0.00,0.00),('5','107','704','239942',4602851,'1924','290',192137.60,192137.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','239942',4602852,'1925','290',1752962.24,1757093.53,4131.29,681662.85,0.00,0.00,0.00,0.00,0.00),('5','107','705','239942',4602853,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','239942',4602854,'1927','290',483387.39,483387.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','239942',4602855,'1928','290',171940.57,174163.68,2223.11,366813.15,0.00,0.00,0.00,0.00,0.00),('5','107','706','239942',4602856,'1929','291',3889841.44,3897398.41,7556.97,2607154.65,0.00,0.00,0.00,0.00,0.00),('5','107','706','239942',4602857,'1930','291',2806523.76,2816693.02,10169.26,3508394.70,0.00,0.00,0.00,0.00,0.00),('5','107','706','239942',4602858,'1931','291',3917718.98,3922149.12,4430.14,1528398.30,0.00,0.00,0.00,0.00,0.00),('5','107','706','239942',4602859,'1932','291',3398391.99,3406704.98,8312.99,2867981.55,0.00,0.00,0.00,0.00,0.00),('5','107','706','239942',4602860,'1933','291',4508252.60,4518073.26,9820.66,3388127.70,0.00,0.00,0.00,0.00,0.00),('5','107','708','239942',4602861,'1934','291',1777461.80,1779634.21,2172.41,749481.45,0.00,0.00,0.00,0.00,0.00),('5','107','706','239942',4602862,'2898','291',3079536.11,3085528.72,5992.61,2067450.45,0.00,0.00,0.00,0.00,0.00),('5','107','708','239942',4602863,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','240082',4605178,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','240082',4605179,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','240082',4605180,'1877','290',846951.26,846951.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','240082',4605181,'1878','290',216185.60,216509.00,323.40,53361.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','240082',4605182,'1879','290',885229.48,885229.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','240082',4605183,'1880','290',112838.90,112838.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','240082',4605184,'1881','290',1200495.43,1200495.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','240082',4605185,'1882','290',1180877.10,1180877.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','240082',4605186,'1883','290',577058.10,580786.57,3728.47,615197.55,0.00,0.00,0.00,0.00,0.00),('5','107','697','240082',4605187,'1884','290',133043.76,137101.97,4058.21,669604.65,0.00,0.00,0.00,0.00,0.00),('5','107','697','240082',4605188,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','240082',4605189,'1886','290',2238467.28,2238467.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','240082',4605190,'1887','290',206189.38,206189.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','240082',4605191,'1888','290',231119.68,237238.12,6118.44,1009542.60,0.00,0.00,0.00,0.00,0.00),('5','107','696','240082',4605192,'1889','290',3198082.58,3198773.93,691.35,114072.75,0.00,0.00,0.00,0.00,0.00),('5','107','696','240082',4605193,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','240082',4605194,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','240082',4605195,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','240082',4605196,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','240082',4605197,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','240082',4605198,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','240082',4605199,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','240082',4605200,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','240082',4605201,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','240082',4605202,'1899','290',1966491.89,1967745.02,1253.13,206766.45,0.00,0.00,0.00,0.00,0.00),('5','107','699','240082',4605203,'1900','290',518203.80,518203.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','240082',4605204,'1901','290',1147276.09,1147276.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','240082',4605205,'1902','290',99221.96,100333.36,1111.40,183381.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','240082',4605206,'1903','290',1224502.75,1228311.13,3808.38,628382.70,0.00,0.00,0.00,0.00,0.00),('5','107','700','240082',4605207,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','240082',4605208,'1905','290',1480849.88,1491204.70,10354.82,1708545.30,0.00,0.00,0.00,0.00,0.00),('5','107','700','240082',4605209,'1906','290',760370.58,760842.62,472.04,77886.60,0.00,0.00,0.00,0.00,0.00),('5','107','701','240082',4605210,'1907','290',2051803.73,2051803.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','240082',4605211,'1908','290',679001.68,685811.31,6809.63,1123588.95,0.00,0.00,0.00,0.00,0.00),('5','107','701','240082',4605212,'1909','290',606460.16,613418.15,6957.99,1148068.35,0.00,0.00,0.00,0.00,0.00),('5','107','701','240082',4605213,'1910','290',391050.05,391050.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','240082',4605214,'1911','290',1201488.08,1204480.22,2992.14,493703.10,0.00,0.00,0.00,0.00,0.00),('5','107','702','240082',4605215,'1912','290',211373.38,211374.18,0.80,132.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','240082',4605216,'1913','290',666927.21,666935.27,8.06,1329.90,0.00,0.00,0.00,0.00,0.00),('5','107','702','240082',4605217,'1914','290',72939.28,72941.99,2.71,447.15,0.00,0.00,0.00,0.00,0.00),('5','107','702','240082',4605218,'1915','290',283060.29,283060.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','240082',4605219,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','240082',4605220,'1917','290',1033041.34,1033041.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','240082',4605221,'1918','290',222117.31,222117.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','240082',4605222,'1919','290',526107.19,528580.22,2473.03,408049.95,0.00,0.00,0.00,0.00,0.00),('5','107','703','240082',4605223,'1920','290',126895.97,129900.08,3004.11,495678.15,0.00,0.00,0.00,0.00,0.00),('5','107','704','240082',4605224,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','240082',4605225,'1922','290',205943.51,205943.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','240082',4605226,'1923','290',742229.47,751361.05,9131.58,1506710.70,0.00,0.00,0.00,0.00,0.00),('5','107','704','240082',4605227,'1924','290',192137.60,192137.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','240082',4605228,'1925','290',1757093.53,1763590.93,6497.40,1072071.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','240082',4605229,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','240082',4605230,'1927','290',483387.39,483387.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','240082',4605231,'1928','290',174163.68,179476.14,5312.46,876555.90,0.00,0.00,0.00,0.00,0.00),('5','107','706','240082',4605232,'1929','291',3897398.41,3905459.35,8060.94,2781024.30,0.00,0.00,0.00,0.00,0.00),('5','107','706','240082',4605233,'1930','291',2816693.02,2827635.49,10942.47,3775152.15,0.00,0.00,0.00,0.00,0.00),('5','107','706','240082',4605234,'1931','291',3922149.12,3927975.24,5826.12,2010011.40,0.00,0.00,0.00,0.00,0.00),('5','107','706','240082',4605235,'1932','291',3406704.98,3414412.53,7707.55,2659104.75,0.00,0.00,0.00,0.00,0.00),('5','107','706','240082',4605236,'1933','291',4518073.26,4527307.44,9234.18,3185792.10,0.00,0.00,0.00,0.00,0.00),('5','107','708','240082',4605237,'1934','291',1779634.21,1790103.91,10469.70,3612046.50,0.00,0.00,0.00,0.00,0.00),('5','107','706','240082',4605238,'2898','291',3085528.72,3094199.53,8670.81,2991429.45,0.00,0.00,0.00,0.00,0.00),('5','107','708','240082',4605239,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','240245',4607980,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','240245',4607981,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','240245',4607982,'1877','290',846951.26,846951.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','240245',4607983,'1878','290',216509.00,219299.94,2790.94,460505.10,0.00,0.00,0.00,0.00,0.00),('5','107','696','240245',4607984,'1879','290',885229.48,885229.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','240245',4607985,'1880','290',112838.90,112838.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','240245',4607986,'1881','290',1200495.43,1200495.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','240245',4607987,'1882','290',1180877.10,1180877.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','240245',4607988,'1883','290',580786.57,580786.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','240245',4607989,'1884','290',137101.97,140846.46,3744.49,617840.85,0.00,0.00,0.00,0.00,0.00),('5','107','697','240245',4607990,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','240245',4607991,'1886','290',2238467.28,2238467.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','240245',4607992,'1887','290',206189.38,206189.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','240245',4607993,'1888','290',237238.12,243755.02,6516.90,1075288.50,0.00,0.00,0.00,0.00,0.00),('5','107','696','240245',4607994,'1889','290',3198773.93,3205518.34,6744.41,1112827.65,0.00,0.00,0.00,0.00,0.00),('5','107','696','240245',4607995,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','240245',4607996,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','240245',4607997,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','240245',4607998,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','240245',4607999,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','240245',4608000,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','240245',4608001,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','240245',4608002,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','240245',4608003,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','240245',4608004,'1899','290',1967745.02,1970891.00,3145.98,519086.70,0.00,0.00,0.00,0.00,0.00),('5','107','699','240245',4608005,'1900','290',518203.80,518203.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','240245',4608006,'1901','290',1147276.09,1147276.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','240245',4608007,'1902','290',100333.36,105648.10,5314.74,876932.10,0.00,0.00,0.00,0.00,0.00),('5','107','700','240245',4608008,'1903','290',1228311.13,1229342.08,1030.95,170106.75,0.00,0.00,0.00,0.00,0.00),('5','107','700','240245',4608009,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','240245',4608010,'1905','290',1491204.70,1492566.11,1361.41,224632.65,0.00,0.00,0.00,0.00,0.00),('5','107','700','240245',4608011,'1906','290',760842.62,760842.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','240245',4608012,'1907','290',2051803.73,2051803.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','240245',4608013,'1908','290',685811.31,689690.96,3879.65,640142.25,0.00,0.00,0.00,0.00,0.00),('5','107','701','240245',4608014,'1909','290',613418.15,615565.71,2147.56,354347.40,0.00,0.00,0.00,0.00,0.00),('5','107','701','240245',4608015,'1910','290',391050.05,391050.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','240245',4608016,'1911','290',1204480.22,1207991.62,3511.40,579381.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','240245',4608017,'1912','290',211374.18,211374.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','240245',4608018,'1913','290',666935.27,670056.60,3121.33,515019.45,0.00,0.00,0.00,0.00,0.00),('5','107','702','240245',4608019,'1914','290',72941.99,72941.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','240245',4608020,'1915','290',283060.29,283060.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','240245',4608021,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','240245',4608022,'1917','290',1033041.34,1033041.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','240245',4608023,'1918','290',222117.31,222117.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','240245',4608024,'1919','290',528580.22,529681.42,1101.20,181698.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','240245',4608025,'1920','290',129900.08,129900.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','240245',4608026,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','240245',4608027,'1922','290',205943.51,205943.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','240245',4608028,'1923','290',751361.05,758297.31,6936.26,1144482.90,0.00,0.00,0.00,0.00,0.00),('5','107','704','240245',4608029,'1924','290',192137.60,192137.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','240245',4608030,'1925','290',1763590.93,1768152.85,4561.92,752716.80,0.00,0.00,0.00,0.00,0.00),('5','107','705','240245',4608031,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','240245',4608032,'1927','290',483387.39,483387.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','240245',4608033,'1928','290',179476.14,181398.87,1922.73,317250.45,0.00,0.00,0.00,0.00,0.00),('5','107','706','240245',4608034,'1929','291',3905459.35,3918608.15,13148.80,4536336.00,0.00,0.00,0.00,0.00,0.00),('5','107','706','240245',4608035,'1930','291',2827635.49,2838575.72,10940.23,3774379.35,0.00,0.00,0.00,0.00,0.00),('5','107','706','240245',4608036,'1931','291',3927975.24,3937086.99,9111.75,3143553.75,0.00,0.00,0.00,0.00,0.00),('5','107','706','240245',4608037,'1932','291',3414412.53,3421277.84,6865.31,2368531.95,0.00,0.00,0.00,0.00,0.00),('5','107','706','240245',4608038,'1933','291',4527307.44,4537423.11,10115.67,3489906.15,0.00,0.00,0.00,0.00,0.00),('5','107','708','240245',4608039,'1934','291',1790103.91,1791268.07,1164.16,401635.20,0.00,0.00,0.00,0.00,0.00),('5','107','706','240245',4608040,'2898','291',3094199.53,3103347.90,9148.37,3156187.65,0.00,0.00,0.00,0.00,0.00),('5','107','708','240245',4608041,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','240613',4614043,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','240613',4614044,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','240613',4614045,'1877','290',846951.26,846951.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','240613',4614046,'1878','290',219299.94,224007.02,4707.08,776668.20,0.00,0.00,0.00,0.00,0.00),('5','107','696','240613',4614047,'1879','290',885229.48,885229.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','240613',4614048,'1880','290',112838.90,112838.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','240613',4614049,'1881','290',1200495.43,1200495.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','240613',4614050,'1882','290',1180877.10,1180877.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','240613',4614051,'1883','290',580786.57,583050.25,2263.68,373507.20,0.00,0.00,0.00,0.00,0.00),('5','107','697','240613',4614052,'1884','290',140846.46,140846.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','240613',4614053,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','240613',4614054,'1886','290',2238467.28,2244363.83,5896.55,972930.75,0.00,0.00,0.00,0.00,0.00),('5','107','697','240613',4614055,'1887','290',206189.38,206189.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','240613',4614056,'1888','290',243755.02,246868.43,3113.41,513712.65,0.00,0.00,0.00,0.00,0.00),('5','107','696','240613',4614057,'1889','290',3205518.34,3212294.19,6775.85,1118015.25,0.00,0.00,0.00,0.00,0.00),('5','107','696','240613',4614058,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','240613',4614059,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','240613',4614060,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','240613',4614061,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','240613',4614062,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','240613',4614063,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','240613',4614064,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','240613',4614065,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','240613',4614066,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','240613',4614067,'1899','290',1970891.00,1979315.38,8424.38,1390022.70,0.00,0.00,0.00,0.00,0.00),('5','107','699','240613',4614068,'1900','290',518203.80,518203.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','240613',4614069,'1901','290',1147276.09,1147276.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','240613',4614070,'1902','290',105648.10,107702.87,2054.77,339037.05,0.00,0.00,0.00,0.00,0.00),('5','107','700','240613',4614071,'1903','290',1229342.08,1229342.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','240613',4614072,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','240613',4614073,'1905','290',1492566.11,1492566.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','240613',4614074,'1906','290',760842.62,760842.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','240613',4614075,'1907','290',2051803.73,2057174.04,5370.31,886101.15,0.00,0.00,0.00,0.00,0.00),('5','107','701','240613',4614076,'1908','290',689690.96,689690.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','240613',4614077,'1909','290',615565.71,617683.30,2117.59,349402.35,0.00,0.00,0.00,0.00,0.00),('5','107','701','240613',4614078,'1910','290',391050.05,393844.50,2794.45,461084.25,0.00,0.00,0.00,0.00,0.00),('5','107','702','240613',4614079,'1911','290',1207991.62,1212221.04,4229.42,697854.30,0.00,0.00,0.00,0.00,0.00),('5','107','702','240613',4614080,'1912','290',211374.18,211374.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','240613',4614081,'1913','290',670056.60,671728.67,1672.07,275891.55,0.00,0.00,0.00,0.00,0.00),('5','107','702','240613',4614082,'1914','290',72941.99,72941.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','240613',4614083,'1915','290',283060.29,283060.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','240613',4614084,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','240613',4614085,'1917','290',1033041.34,1033041.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','240613',4614086,'1918','290',222117.31,222973.73,856.42,141309.30,0.00,0.00,0.00,0.00,0.00),('5','107','703','240613',4614087,'1919','290',529681.42,529681.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','240613',4614088,'1920','290',129900.08,129900.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','240613',4614089,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','240613',4614090,'1922','290',205943.51,205943.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','240613',4614091,'1923','290',758297.31,764779.08,6481.77,1069492.05,0.00,0.00,0.00,0.00,0.00),('5','107','704','240613',4614092,'1924','290',192137.60,192137.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','240613',4614093,'1925','290',1768152.85,1774010.24,5857.39,966469.35,0.00,0.00,0.00,0.00,0.00),('5','107','705','240613',4614094,'1926','290',45087.24,45087.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','240613',4614095,'1927','290',483387.39,483387.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','705','240613',4614096,'1928','290',181398.87,183125.23,1726.36,284849.40,0.00,0.00,0.00,0.00,0.00),('5','107','706','240613',4614097,'1929','291',3918608.15,3926681.10,8072.95,2785167.75,0.00,0.00,0.00,0.00,0.00),('5','107','706','240613',4614098,'1930','291',2838575.72,2846201.70,7625.98,2630963.10,0.00,0.00,0.00,0.00,0.00),('5','107','706','240613',4614099,'1931','291',3937086.99,3943837.87,6750.88,2329053.60,0.00,0.00,0.00,0.00,0.00),('5','107','706','240613',4614100,'1932','291',3421277.84,3429668.57,8390.73,2894801.85,0.00,0.00,0.00,0.00,0.00),('5','107','706','240613',4614101,'1933','291',4537423.11,4547431.66,10008.55,3452949.75,0.00,0.00,0.00,0.00,0.00),('5','107','708','240613',4614102,'1934','291',1791268.07,1794799.23,3531.16,1218250.20,0.00,0.00,0.00,0.00,0.00),('5','107','706','240613',4614103,'2898','291',3103347.90,3109813.86,6465.96,2230756.20,0.00,0.00,0.00,0.00,0.00),('5','107','708','240613',4614104,'2899','291',3339081.51,3339081.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','240813',4616971,'1875','290',1487.02,1487.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','240813',4616972,'1876','290',1410.98,1410.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','240813',4616973,'1877','290',846951.26,846951.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','240813',4616974,'1878','290',224007.02,225851.65,1844.63,304363.95,0.00,0.00,0.00,0.00,0.00),('5','107','696','240813',4616975,'1879','290',885229.48,885229.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','240813',4616976,'1880','290',112838.90,112838.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','240813',4616977,'1881','290',1200495.43,1200495.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','240813',4616978,'1882','290',1180877.10,1180877.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','240813',4616979,'1883','290',583050.25,583050.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','240813',4616980,'1884','290',140846.46,143004.73,2158.27,356114.55,0.00,0.00,0.00,0.00,0.00),('5','107','697','240813',4616981,'1885','290',1119.90,1119.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','240813',4616982,'1886','290',2244363.83,2247860.14,3496.31,576891.15,0.00,0.00,0.00,0.00,0.00),('5','107','697','240813',4616983,'1887','290',206189.38,206189.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','697','240813',4616984,'1888','290',246868.43,249959.44,3091.01,510016.65,0.00,0.00,0.00,0.00,0.00),('5','107','696','240813',4616985,'1889','290',3212294.19,3220173.16,7878.97,1300030.05,0.00,0.00,0.00,0.00,0.00),('5','107','696','240813',4616986,'1890','290',682753.39,682753.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','240813',4616987,'1891','290',1089.49,1089.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','696','240813',4616988,'1892','290',1110.50,1110.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','240813',4616989,'1893','290',1081.79,1081.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','240813',4616990,'1894','290',1188.03,1188.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','240813',4616991,'1895','290',688388.49,688388.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','240813',4616992,'1896','290',268599.90,268599.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','240813',4616993,'1897','290',416979.10,416979.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','698','240813',4616994,'1898','290',65942.00,65942.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','240813',4616995,'1899','290',1979315.38,1984171.17,4855.79,801205.35,0.00,0.00,0.00,0.00,0.00),('5','107','699','240813',4616996,'1900','290',518203.80,519017.44,813.64,134250.60,0.00,0.00,0.00,0.00,0.00),('5','107','699','240813',4616997,'1901','290',1147276.09,1147276.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','699','240813',4616998,'1902','290',107702.87,111805.18,4102.31,676881.15,0.00,0.00,0.00,0.00,0.00),('5','107','700','240813',4616999,'1903','290',1229342.08,1237074.77,7732.69,1275893.85,0.00,0.00,0.00,0.00,0.00),('5','107','700','240813',4617000,'1904','290',1131083.01,1131083.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','240813',4617001,'1905','290',1492566.11,1492566.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','700','240813',4617002,'1906','290',760842.62,760842.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','240813',4617003,'1907','290',2057174.04,2058048.63,874.59,144307.35,0.00,0.00,0.00,0.00,0.00),('5','107','701','240813',4617004,'1908','290',689690.96,689690.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','240813',4617005,'1909','290',617683.30,617683.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','701','240813',4617006,'1910','290',393844.50,394643.25,798.75,131793.75,0.00,0.00,0.00,0.00,0.00),('5','107','702','240813',4617007,'1911','290',1212221.04,1212221.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','240813',4617008,'1912','290',211374.18,211374.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','240813',4617009,'1913','290',671728.67,671728.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','240813',4617010,'1914','290',72941.99,72941.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','240813',4617011,'1915','290',283060.29,283060.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','702','240813',4617012,'1916','290',22752.62,22752.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','703','240813',4617013,'1917','290',1033041.34,1033101.87,60.53,9987.45,0.00,0.00,0.00,0.00,0.00),('5','107','703','240813',4617014,'1918','290',222973.73,225831.81,2858.08,471583.20,0.00,0.00,0.00,0.00,0.00),('5','107','703','240813',4617015,'1919','290',529681.42,533969.92,4288.50,707602.50,0.00,0.00,0.00,0.00,0.00),('5','107','703','240813',4617016,'1920','290',129900.08,130771.56,871.48,143794.20,0.00,0.00,0.00,0.00,0.00),('5','107','704','240813',4617017,'1921','290',922484.21,922484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','107','704','240813',4617018,'1922','290',205943.51,205943.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5'