-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_5_station_105
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_5_station_105`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_5_station_105` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_5_station_105`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3515 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (3455,4036,'',0,'2','5','105','0001480945-TAJ BANK','','2021-07-14 09:08:45',5,0.00,0.00,'','600','2021-07-14 09:08:45','600',0,1),(3484,4011,'',0,'22','5','105','PURCHASES','','2021-07-15 07:37:47',5,0.00,0.00,'','576','2021-07-15 07:37:47','576',0,1),(3485,30176,'',0,'24','5','105','PURCHASES','','2021-07-15 07:38:03',5,0.00,0.00,'','576','2021-07-15 07:38:03','576',0,1),(3486,3026,'',0,'6.1','5','105','CASH','','2021-07-15 07:38:22',5,0.00,0.00,'','576','2021-07-15 07:38:22','576',0,1),(3487,30177,'',0,'24','5','105','SALARIES & WAGES','','2021-07-15 07:38:42',5,0.00,0.00,'','576','2021-07-15 07:38:42','576',0,1),(3488,4024,'',0,'20','5','105','SALES','','2021-07-15 07:40:25',5,0.00,0.00,'','576','2021-07-15 07:40:25','576',0,1),(3511,4043,'',0,'2','5','105','UBA-1022244928','','2021-07-26 14:52:42',5,0.00,0.00,'','600','2021-07-26 14:52:42','600',0,1),(3512,4044,'',0,'2','5','105','JA\'IZ- 0010037957','','2022-03-01 20:00:39',5,0.00,0.00,'','600','2022-03-01 20:00:39','600',0,0),(3513,4045,'',0,'2','5','105','JA\'IZ-0010037957','','2022-03-02 19:15:05',5,0.00,0.00,'','600','2022-03-02 19:15:05','600',0,0),(3514,2000,'',0,'6','5','105','INVENTORY VALUE ADJUSTMENT','','2023-02-06 10:21:23',5,0.00,0.00,'','600','2023-02-06 10:21:23','600',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
INSERT INTO `accounts_transactions` VALUES (1,'5','105','0000-00-00','2023-02-06 16:20:22',10,'600','','0000-00-00 00:00:00','600','2023-02-06 16:20:54'),(2,'5','105','0000-00-00','2023-02-06 16:22:35',10,'600','','0000-00-00 00:00:00','600','2023-02-06 16:23:13'),(3,'5','105','0000-00-00','2023-02-20 16:26:08',10,'600','','0000-00-00 00:00:00','600','2023-02-20 16:29:42'),(4,'5','105','0000-00-00','2023-02-20 16:28:42',10,'600','','0000-00-00 00:00:00','600','2023-02-20 16:29:46');
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
INSERT INTO `accounts_transactions_items` VALUES (1,'5','105','1','3514','6',0.00,'PMS Price Icrease(185 to 220 x 1,050 litrs) 20/1/2023',36750.00,'2023-02-06'),(2,'5','105','1','254','supplier',36750.00,'PMS Price Icrease(185 to 220 x 1,050 litrs) 20/1/2023',0.00,'2023-02-06'),(3,'5','105','2','254','supplier',0.00,'AGO Price Decrease(860 to 830 x 2,00 litrs) 13/1/2023',6000.00,'2023-02-06'),(4,'5','105','2','3514','6',6000.00,'AGO Price Decrease(860 to 830 x 2,00 litrs) 13/1/2023',0.00,'2023-02-06'),(6,'5','105','3','254','supplier',0.00,'PMS PRICE DECREASE FROM 220 210 DIPPING 1050',10500.00,'2023-02-19'),(7,'5','105','3','3514','6',10500.00,'PMS PRICE DECREASE FROM 220 210 DIPPING 1,050',0.00,'2023-02-20'),(8,'5','105','4','254','supplier',0.00,'AGO PRICE DECREASE FROM 830 TO 820 DIPPING 200ltrs',2000.00,'2023-02-20'),(9,'5','105','4','3514','6',2000.00,'AGO PRICE DECREASE FROM 830 TO 820 DIPPING 200Ltrs',0.00,'2023-02-20');
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=18297 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('5','105',15966,'961',2257.48,30600.00,'2021-08-05','','2021-08-05 13:33:34','600','600',2021,'600','2021-08-05 13:33:34',5),('5','105',15967,'962',35750.45,600.00,'2021-08-05','','2021-08-05 13:33:52','600','600',2021,'600','2021-08-05 13:33:52',5),('5','105',15968,'963',569.73,250.00,'2021-08-05','','2021-08-05 13:34:20','600','600',2021,'600','2021-08-05 13:34:20',5),('5','105',15969,'964',29999.95,24000.00,'2021-08-05','','2021-08-05 13:34:41','600','600',2021,'600','2021-08-05 13:34:41',5),('5','105',16010,'964',46307.92,49950.00,'2021-08-10','','2021-08-10 16:34:41','600','600',2021,'600','2021-08-10 16:34:41',5),('5','105',16011,'961',2303.25,7800.00,'2021-08-10','','2021-08-10 16:35:12','600','600',2021,'600','2021-08-10 16:35:12',5),('5','105',16076,'961',49128.29,49400.00,'2021-08-16','','2021-08-16 17:09:49','600','600',2021,'600','2021-08-16 17:09:49',5),('5','105',16077,'962',1058.57,650.00,'2021-08-16','','2021-08-16 17:10:17','600','600',2021,'600','2021-08-16 17:10:17',5),('5','105',16078,'963',250.00,250.00,'2021-08-16','','2021-08-16 17:10:44','600','600',2021,'600','2021-08-16 17:10:44',5),('5','105',16079,'964',1601.58,7800.00,'2021-08-16','','2021-08-16 17:11:00','600','600',2021,'600','2021-08-16 17:11:00',5),('5','105',16371,'961',1287.87,500.00,'2021-09-09','','2021-09-09 08:43:53','600','600',2021,'600','2021-09-09 08:43:53',5),('5','105',16372,'962',1033.94,650.00,'2021-09-09','','2021-09-09 08:44:12','600','600',2021,'600','2021-09-09 08:44:12',5),('5','105',16373,'963',9591.06,200.00,'2021-09-09','','2021-09-09 08:44:40','600','600',2021,'600','2021-09-09 08:44:40',5),('5','105',16374,'964',11394.14,200.00,'2021-09-09','','2021-09-09 08:44:58','600','600',2021,'600','2021-09-09 08:44:58',5),('5','105',16406,'963',4031.29,4350.00,'2021-09-12','','2021-09-12 10:19:39','600','600',2021,'600','2021-09-12 10:19:39',5),('5','105',16486,'963',304.19,50200.00,'2021-09-18','','2021-09-18 16:06:36','600','600',2021,'600','2021-09-18 16:06:36',5),('5','105',16487,'962',50550.00,650.00,'2021-09-18','','2021-09-18 16:06:57','600','600',2021,'600','2021-09-18 16:06:57',5),('5','105',17626,'961',31511.00,5511.00,'2021-11-15','','2021-11-15 08:19:02','600','600',2021,'600','2021-11-15 08:19:02',5),('5','105',17627,'962',689.90,26690.00,'2021-11-15','','2021-11-15 08:19:31','600','600',2021,'600','2021-11-15 08:19:31',5),('5','105',18268,'963',1526.17,2100.00,'2021-12-30','','2021-12-30 17:50:01','600','600',2021,'600','2021-12-30 17:50:01',5),('5','105',18269,'963',2100.00,2100.00,'2021-12-30','','2021-12-30 17:50:21','600','600',2021,'600','2021-12-30 17:50:21',5),('5','105',18288,'964',3578.29,4500.00,'2022-01-01','','2022-01-01 16:59:34','600','600',2022,'600','2022-01-01 16:59:34',5),('5','105',18289,'964',2643.49,3000.00,'2022-06-02','','2022-06-02 12:20:25','600','600',2022,'600','2022-06-02 12:20:25',5),('5','105',18290,'964',1067.60,1300.00,'2022-11-07','','2022-11-07 06:10:28','600','600',2022,'600','2022-11-07 06:10:28',5),('5','105',18291,'964',1300.00,1700.00,'2022-11-07','','2022-11-07 06:11:33','600','600',2022,'600','2022-11-07 06:11:33',5),('5','105',18292,'964',8585.44,9000.00,'2022-12-07','','2022-12-07 16:14:26','600','600',2022,'600','2022-12-07 16:14:26',5),('5','105',18293,'964',3201.65,3500.00,'2022-12-22','','2022-12-22 09:44:15','600','600',2022,'600','2022-12-22 09:44:15',5),('5','105',18294,'964',2321.91,2600.00,'2023-01-21','','2023-01-21 10:04:17','600','600',2023,'600','2023-01-21 10:04:17',5),('5','105',18295,'964',7414.02,7700.00,'2023-01-26','','2023-01-26 13:16:35','600','600',2023,'600','2023-01-26 13:16:35',5),('5','105',18296,'964',4628.94,5500.00,'2023-03-07','','2023-03-07 08:25:33','600','600',2023,'600','2023-03-07 08:25:33',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2881 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('5','105','962',2853,'5','PMS PUMP 5',318568.43,'PMS DISPENSER','',NULL,NULL,'',5,'2021-07-15 09:25:17','600'),('5','105','961',2854,'5','PMS PUMP 6',67599.41,'PMS DISPENSER','',NULL,NULL,'',5,'2021-07-15 09:26:08','600'),('5','105','962',2855,'5','PMS PUMP 7',341871.18,'PMS DISPENSER','',NULL,NULL,'',5,'2021-07-15 09:26:52','600'),('5','105','961',2856,'5','PMS PUMP 8',79215.37,'pMS DISPENSER','',NULL,NULL,'',5,'2021-07-15 09:27:29','600'),('5','105','963',2857,'5','PMS PUMP 3',134343.81,'PMS DISPENSER','',NULL,NULL,'',5,'2021-07-15 09:23:45','600'),('5','105','963',2858,'5','PMS PUMP 4',128680.18,'PMS DISPENSER','',NULL,NULL,'',5,'2021-07-15 09:24:19','600'),('5','105','964',2859,'5','PMS PUMP 1',1210016.68,'PMS DISPENSER','',NULL,NULL,'',5,'2021-07-27 13:55:20','600'),('5','105','964',2860,'5','PMS PUMP 2',1088834.73,'PMS DISPENSER','',NULL,NULL,'',5,'2021-07-27 13:56:13','600'),('5','105','965',2861,'5','AGO PUMP',65655.11,'AGO DISPENSER','',NULL,NULL,'',5,'2021-07-15 09:32:52','600'),('5','105','966',2862,'5','DPK PUMP',0.00,'DPK DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','105','965',2880,'5','AGO PUMP 2',0.00,'AGO DISPENSE PUMP',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=241 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
INSERT INTO `depots_nozzles_tanks` VALUES (239,'5','105','2853','962','PMS TANKS CONNECTION ERROR.','2021-08-03 12:55:51',0,'600'),(240,'5','105','2856','961','PMS TANKS CONNECTION ERROR.','2021-08-03 12:56:18',0,'600');
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=257897 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('5','105',213016,'DAILY','2021-07-09','2021-07-09 00:00:00',NULL,'641',1841158.15,1838092.55,'641','2021-07-26 14:56:11','607','2021-07-26 14:57:56',10,0),('5','105',213055,'DAILY','2021-07-10','2021-07-10 00:00:00',NULL,'641',2594643.95,2590996.15,'641','2021-07-26 21:28:21','607','2021-07-27 12:42:06',10,0),('5','105',213303,'DAILY ','2021-07-11','2021-07-11 00:00:00',NULL,'641',2471324.60,2467581.10,'641','2021-07-27 14:19:44','607','2021-07-27 14:21:57',10,0),('5','105',213308,'DAILY ','2021-07-12','2021-07-12 00:00:00',NULL,'641',2484469.95,2480848.05,'641','2021-07-27 14:33:27','607','2021-07-27 14:35:21',10,0),('5','105',213311,'DAILY ','2021-07-13','2021-07-13 00:00:00',NULL,'641',2487601.75,2483655.05,'641','2021-07-27 14:40:47','607','2021-07-27 14:41:41',10,0),('5','105',213313,'DAILY','2021-07-14','2021-07-14 00:00:00',NULL,'641',2529182.35,2523047.60,'641','2021-07-27 14:47:11','607','2021-07-27 14:48:35',10,0),('5','105',213318,'DAILY','2021-07-15','2021-07-15 00:00:00',NULL,'641',2421000.40,2421000.40,'641','2021-07-27 14:55:03','607','2021-07-27 15:09:58',10,0),('5','105',213325,'DAILY','2021-07-16','2021-07-16 00:00:00',NULL,'641',2360062.85,2360062.85,'641','2021-07-27 15:29:02','607','2021-07-27 15:30:35',10,0),('5','105',213330,'DAILY','2021-07-17','2021-07-17 00:00:00',NULL,'641',2443796.85,2443796.85,'641','2021-07-27 15:38:51','607','2021-07-27 15:39:20',10,0),('5','105',213332,'DAILY','2021-07-18','2021-07-18 00:00:00',NULL,'641',2682426.35,2682426.35,'641','2021-07-28 06:38:35','607','2021-07-28 09:59:28',10,0),('5','105',213487,'DAILY ','2021-07-19','2021-07-19 00:00:00',NULL,'641',2888758.95,2888758.95,'641','2021-07-28 11:34:52','607','2021-07-28 11:52:29',10,0),('5','105',213504,'DAILY','2021-07-20','2021-07-20 00:00:00',NULL,'641',2482827.65,2482827.65,'641','2021-07-28 12:06:45','607','2021-07-28 12:07:57',10,0),('5','105',213508,'DAILY','2021-07-21','2021-07-21 00:00:00',NULL,'641',2310540.15,2310540.15,'641','2021-07-28 12:20:42','607','2021-07-28 12:32:17',10,0),('5','105',213515,'DAILY','2021-07-22','2021-07-22 00:00:00',NULL,'641',1785652.60,1785652.60,'641','2021-07-28 13:03:59','607','2021-07-28 13:14:06',10,0),('5','105',213527,'DAILY','2021-07-23','2021-07-23 00:00:00',NULL,'641',2293499.40,2293499.40,'641','2021-07-28 13:38:32','607','2021-07-28 13:41:43',10,0),('5','105',213532,'DAILY ','2021-07-24','2021-07-24 00:00:00',NULL,'641',2574041.45,2574041.45,'641','2021-07-28 13:48:34','607','2021-07-28 13:50:55',10,0),('5','105',213538,'DAILY','2021-07-25','2021-07-25 00:00:00',NULL,'641',2268774.15,2268774.15,'641','2021-07-28 14:48:54','607','2021-07-28 15:00:35',10,0),('5','105',213555,'DAILY','2021-07-26','2021-07-26 00:00:00',NULL,'641',1729489.75,1729489.75,'641','2021-07-28 15:08:35','607','2021-07-28 15:15:10',10,0),('5','105',213558,'DAILY','2021-07-27','2021-07-27 00:00:00',NULL,'641',1967528.75,1967528.75,'641','2021-07-28 15:32:02','607','2021-07-28 15:34:29',10,0),('5','105',213569,'DAILY','2021-07-28','2021-07-28 00:00:00',NULL,'641',2004741.35,2004741.35,'641','2021-07-29 05:51:54','607','2021-07-29 06:01:43',10,0),('5','105',213629,'DAILY','2021-07-29','2021-07-29 00:00:00',NULL,'641',1973464.35,1973464.35,'641','2021-07-30 00:12:26','607','2021-07-30 09:54:37',10,0),('5','105',213957,'DAILY','2021-07-30','2021-07-30 00:00:00',NULL,'641',2079242.90,2079242.90,'641','2021-07-31 12:26:16','607','2021-08-01 11:48:01',10,0),('5','105',214424,'DAILY','2021-07-31','2021-07-31 00:00:00',NULL,'641',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','105',214902,'DAILY','2021-07-31','2021-07-31 00:00:00',NULL,'600',2081944.30,2081944.30,'641','2021-08-07 10:42:41','607','2021-08-07 15:56:17',10,0),('5','105',216103,'DAILY ','2021-08-09','2021-08-09 00:00:00',NULL,'641',2154767.40,2154767.40,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','105',216225,'DAILY ','2021-08-01','2021-08-01 00:00:00',NULL,'641',2154920.80,2154920.80,'641','2021-08-09 12:42:54','607','2021-08-09 12:47:44',10,0),('5','105',216253,'DAILY','2021-08-02','2021-08-02 00:00:00',NULL,'641',2168756.30,2168756.30,'641','2021-08-09 14:49:12','607','2021-08-09 15:04:38',10,0),('5','105',216271,'DAILY','2021-08-03','2021-08-03 00:00:00',NULL,'641',2228720.40,2228720.40,'641','2021-08-09 16:20:07','607','2021-08-09 16:23:59',10,0),('5','105',216277,'DAILY','2021-08-04','2021-08-04 00:00:00',NULL,'641',2116333.45,2116333.45,'641','2021-08-09 17:13:07','607','2021-08-09 17:20:10',10,0),('5','105',216289,'DAILY ','2021-08-05','2021-08-05 00:00:00',NULL,'641',2073007.50,2073007.50,'641','2021-08-10 16:40:20','607','2021-08-10 16:54:30',10,0),('5','105',216507,'DAILY','2021-08-06','2021-08-06 00:00:00',NULL,'641',2217319.05,2217319.05,'641','2021-08-10 17:02:21','607','2021-08-10 17:12:18',10,0),('5','105',216512,'DAILY','2021-08-07','2021-08-07 00:00:00',NULL,'641',2044321.50,2044321.50,'641','2021-08-10 17:31:38','607','2021-08-10 18:09:03',10,0),('5','105',216532,'DAILY','2021-08-08','2021-08-08 00:00:00',NULL,'641',2152194.75,2152194.75,'641','2021-08-10 19:20:01','607','2021-08-11 13:48:43',10,0),('5','105',216718,'DAILY','2021-08-09','2021-08-09 00:00:00',NULL,'641',2044204.65,2044204.65,'641','2021-08-11 15:03:38','607','2021-08-11 15:05:32',10,0),('5','105',216720,'DAILY','2021-08-10','2021-08-10 00:00:00',NULL,'641',2167533.65,2167533.65,'641','2021-08-11 15:21:47','607','2021-08-11 15:26:22',10,0),('5','105',216724,'DAILY ','2021-08-11','2021-08-11 00:00:00',NULL,'641',1960823.85,1960823.85,'641','2021-08-12 05:57:45','607','2021-08-12 10:51:58',10,0),('5','105',216880,'DAILY','2021-08-12','2021-08-12 00:00:00',NULL,'641',1971168.50,1971168.50,'641','2021-08-12 22:37:33','607','2021-08-13 08:05:34',10,0),('5','105',217084,'DAILY','2021-08-13','2021-08-13 00:00:00',NULL,'641',2041517.35,2041517.35,'641','2021-08-16 15:42:01','607','2021-08-16 15:54:34',10,0),('5','105',217921,'DAILY ','2021-08-14','2021-08-14 00:00:00',NULL,'641',2080795.25,2080795.25,'641','2021-08-16 15:59:02','607','2021-08-16 16:16:11',10,0),('5','105',217926,'DAILY ','2021-08-15','2021-08-15 00:00:00',NULL,'641',2001197.25,2001197.25,'641','2021-08-17 08:04:04','607','2021-08-17 08:25:08',10,0),('5','105',218035,'DAILY ','2021-08-16','2021-08-16 00:00:00',NULL,'641',2001234.55,2001234.55,'641','2021-08-17 08:56:02','607','2021-08-17 09:02:02',10,0),('5','105',218078,'DAILY ','2021-08-17','2021-08-17 00:00:00',NULL,'641',1982822.15,1982822.15,'641','2021-08-17 22:03:27','607','2021-08-17 23:11:44',10,0),('5','105',218305,'DAILY','2021-08-18','2021-08-18 00:00:00',NULL,'641',1973644.60,1973644.60,'641','2021-08-19 06:54:29','607','2021-08-19 08:47:05',10,0),('5','105',218548,'DAILY ','2021-08-19','2021-08-19 00:00:00',NULL,'641',2027791.50,2027791.50,'641','2021-08-20 07:07:38','607','2021-08-20 08:45:10',10,0),('5','105',218725,'DAILY ','2021-08-20','2021-08-20 00:00:00',NULL,'641',2136870.00,2136870.00,'641','2021-08-21 05:39:48','607','2021-08-21 23:05:54',10,0),('5','105',219106,'DAILY ','2021-08-21','2021-08-21 00:00:00',NULL,'641',1999075.65,1999075.65,'641','2021-08-22 06:19:58','607','2021-08-22 08:28:50',10,0),('5','105',219213,'DAILY ','2021-08-22','2021-08-22 00:00:00',NULL,'641',2103932.85,2103932.85,'641','2021-08-23 06:13:37','607','2021-08-23 09:19:12',10,0),('5','105',219461,'DAILY ','2021-08-23','2021-08-23 00:00:00',NULL,'641',2171611.20,2171611.20,'641','2021-08-24 05:24:29','607','2021-08-24 13:45:25',10,0),('5','105',219754,'DAILY ','2021-08-24','2021-08-24 00:00:00',NULL,'641',1962817.90,1962817.90,'641','2021-08-25 08:34:35','607','2021-08-25 08:54:06',10,0),('5','105',219904,'DAILY','2021-08-25','2021-08-25 00:00:00',NULL,'641',1810613.00,1810613.00,'641','2021-08-26 06:21:24','607','2021-08-26 06:23:35',10,0),('5','105',220040,'DAILY','2021-08-26','2021-08-26 00:00:00',NULL,'641',1860761.95,1860761.95,'641','2021-08-27 06:26:21','607','2021-08-27 09:30:03',10,0),('5','105',220362,'DAILY ','2021-08-27','2021-08-27 00:00:00',NULL,'641',2033463.20,2033463.20,'641','2021-08-27 22:55:33','607','2021-08-28 07:04:31',10,0),('5','105',220575,'DAILY ','2021-08-28','2021-08-28 00:00:00',NULL,'641',1628635.10,1628635.10,'641','2021-08-29 06:00:06','607','2021-08-29 07:43:02',10,0),('5','105',220893,'DAILY ','2021-08-29','2021-08-29 00:00:00',NULL,'641',1986398.50,1986398.50,'641','2021-08-30 04:52:25','607','2021-08-30 09:14:48',10,0),('5','105',220988,'DAILY ','2021-08-30','2021-08-30 00:00:00',NULL,'641',1765164.45,1765164.45,'641','2021-08-31 08:09:49','607','2021-08-31 12:15:36',10,0),('5','105',221278,'DAILY','2021-08-31','2021-08-31 00:00:00',NULL,'641',1832796.90,1832796.90,'641','2021-09-01 07:20:49','607','2021-09-01 17:05:00',10,0),('5','105',221607,'DAILY ','2021-09-01','2021-09-01 00:00:00',NULL,'641',2079319.75,2079319.75,'641','2021-09-02 05:49:51','607','2021-09-02 06:41:52',10,0),('5','105',221716,'DAILY ','2021-09-02','2021-09-02 00:00:00',NULL,'641',2098964.80,2098964.80,'641','2021-09-03 06:28:51','607','2021-09-03 09:14:24',10,0),('5','105',222003,'DAILY ','2021-09-03','2021-09-03 00:00:00',NULL,'641',1892371.35,1892371.35,'641','2021-09-04 07:43:55','607','2021-09-04 20:10:57',10,0),('5','105',222296,'DAILY ','2021-09-04','2021-09-04 00:00:00',NULL,'641',2017187.55,2017187.55,'641','2021-09-05 10:46:22','607','2021-09-05 15:13:48',10,0),('5','105',222435,'DAILY ','2021-09-05','2021-09-05 00:00:00',NULL,'641',1911719.85,1911719.85,'641','2021-09-06 07:10:51','607','2021-09-06 08:34:39',10,0),('5','105',222585,'DAILY ','2021-09-06','2021-09-06 00:00:00',NULL,'641',1859216.95,1859216.95,'641','2021-09-07 08:16:09','607','2021-09-07 11:05:13',10,0),('5','105',222888,'DAILY','2021-09-07','2021-09-07 00:00:00',NULL,'641',1363538.30,1363538.30,'641','2021-09-08 06:04:42','607','2021-09-08 09:13:22',10,0),('5','105',223013,'DAILY ','2021-09-08','2021-09-08 00:00:00',NULL,'641',1021980.50,1021980.50,'641','2021-09-08 21:18:29','607','2021-09-09 05:57:17',10,0),('5','105',223305,'DAILY','2021-09-09','2021-09-09 00:00:00',NULL,'641',1608403.40,1608403.40,'641','2021-09-10 10:19:20','607','2021-09-11 05:29:58',10,0),('5','105',223637,'DAILY ','2021-09-10','2021-09-10 00:00:00',NULL,'641',1877250.40,1877250.40,'641','2021-09-11 06:20:56','607','2021-09-11 07:33:17',10,0),('5','105',223684,'DAILY','2021-09-11','2021-09-11 00:00:00',NULL,'641',1772251.15,1772251.15,'641','2021-09-12 10:26:44','607','2021-09-12 18:00:13',10,0),('5','105',224124,'DAILY','2021-09-12','2021-09-12 00:00:00',NULL,'641',1463580.20,1463580.20,'641','2021-09-13 08:47:02','607','2021-09-13 08:56:41',10,0),('5','105',224288,'DAILY','2021-09-13','2021-09-13 00:00:00',NULL,'641',269382.75,269382.75,'641','2021-09-13 21:00:52','607','2021-09-14 08:27:05',10,0),('5','105',224372,'DAILY ','2021-09-14','2021-09-14 00:00:00',NULL,'641',1687389.25,1687389.25,'641','2021-09-14 22:24:01','607','2021-09-15 09:12:57',10,0),('5','105',224622,'DAILY','2021-09-15','2021-09-15 00:00:00',NULL,'641',1123156.45,1123156.45,'641','2021-09-16 09:09:56','607','2021-09-16 09:44:25',10,0),('5','105',224855,'DAILY','2021-09-16','2021-09-16 00:00:00',NULL,'641',1749087.80,1729431.32,'641','2021-09-17 06:49:51','607','2021-09-17 08:38:46',10,0),('5','105',225077,'DAILY ','2021-09-17','2021-09-17 00:00:00',NULL,'641',1769749.05,1750033.97,'641','2021-09-20 04:37:49','607','2021-09-20 06:15:07',10,0),('5','105',225726,'DAILY ','2021-09-18','2021-09-18 00:00:00',NULL,'641',1859325.92,1859325.92,'641','2021-09-20 07:33:07','607','2021-09-20 09:05:52',10,0),('5','105',225773,'DAILY ','2021-09-19','2021-09-19 00:00:00',NULL,'641',1772890.69,1772890.69,'641','2021-09-20 09:18:04','607','2021-09-20 09:25:28',10,0),('5','105',225786,'DAILY','2021-09-20','2021-09-20 00:00:00',NULL,'641',1730637.83,1730637.83,'641','2021-09-21 06:11:55','607','2021-09-21 09:44:28',10,0),('5','105',226057,'DAILY ','2021-09-21','2021-09-21 00:00:00',NULL,'641',1552752.67,1552752.67,'641','2021-09-22 08:30:46','607','2021-09-22 09:07:06',10,0),('5','105',226328,'DAILY','2021-09-22','2021-09-22 00:00:00',NULL,'641',1548433.17,1548433.17,'641','2021-09-23 10:01:39','607','2021-09-23 10:24:56',10,0),('5','105',226561,'DAILY ','2021-09-23','2021-09-23 00:00:00',NULL,'641',1560786.94,1560786.94,'641','2021-09-23 22:11:26','607','2021-09-24 05:40:53',10,0),('5','105',226782,'DAILY ','2021-09-24','2021-09-24 00:00:00',NULL,'641',1661201.46,1661201.46,'641','2021-09-25 05:28:40','607','2021-09-25 05:31:27',10,0),('5','105',227207,'DAILY ','2021-09-25','2021-09-25 00:00:00',NULL,'641',1689569.98,1689569.98,'641','2021-09-26 07:40:46','607','2021-09-26 08:27:50',10,0),('5','105',227456,'DAILY ','2021-09-26','2021-09-26 00:00:00',NULL,'641',1786815.78,1786815.78,'641','2021-09-27 10:11:19','607','2021-09-27 18:25:48',10,0),('5','105',227577,'DAILY ','2021-09-27','2021-09-27 00:00:00',NULL,'641',1726466.66,1726466.66,'641','2021-09-28 05:31:54','607','2021-09-28 08:21:55',10,0),('5','105',227776,'DAILY ','2021-09-28','2021-09-28 00:00:00',NULL,'641',1587781.37,1587781.37,'641','2021-09-29 05:57:34','607','2021-09-29 08:29:09',10,0),('5','105',227935,'DAILY','2021-09-29','2021-09-29 00:00:00',NULL,'641',1557122.70,1557122.70,'641','2021-10-05 18:55:05','607','2021-10-05 18:57:23',10,0),('5','105',229384,'DAILY','2021-09-30','2021-09-30 00:00:00',NULL,'641',1615608.73,1615608.73,'641','2021-10-05 19:12:45','607','2021-10-06 08:26:58',10,0),('5','105',229761,'DAILY','2021-10-01','2021-10-01 00:00:00',NULL,'641',1599667.33,1599667.33,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','105',229764,'DAILY','2021-10-01','2021-10-01 00:00:00',NULL,'641',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','105',229825,'DAILY ','2021-10-01','2021-10-01 00:00:00',NULL,'641',1599667.33,1599667.33,'641','2021-10-07 18:07:07','607','2021-10-07 18:12:54',10,0),('5','105',229848,'DAILY','2021-10-02','2021-10-02 00:00:00',NULL,'641',431987.49,431987.49,'641','2021-10-07 18:20:35','607','2021-10-07 18:22:29',10,0),('5','105',230171,'DAILY','2021-10-03','2021-10-03 00:00:00',NULL,'641',1460435.99,1460435.99,'641','2021-10-09 11:09:13','607','2021-10-09 11:13:30',10,0),('5','105',230173,'DAILY','2021-10-04','2021-10-04 00:00:00',NULL,'641',1586699.05,1586699.05,'641','2021-10-09 11:18:25','607','2021-10-09 11:19:37',10,0),('5','105',230174,'DAILY ','2021-10-05','2021-10-05 00:00:00',NULL,'641',1694709.37,1694709.37,'641','2021-10-09 11:28:02','607','2021-10-09 11:29:07',10,0),('5','105',230177,'DAILY','2021-10-06','2021-10-06 00:00:00',NULL,'641',1593186.45,1593186.45,'641','2021-10-09 11:33:40','607','2021-10-09 11:34:16',10,0),('5','105',230178,'DAILY','2021-10-07','2021-10-07 00:00:00',NULL,'641',799836.11,799836.11,'641','2021-10-09 11:37:06','607','2021-10-09 11:38:00',10,0),('5','105',230180,'DAILY','2021-10-08','2021-10-08 00:00:00',NULL,'641',167493.91,167493.91,'641','2021-10-09 11:41:09','607','2021-10-09 11:41:54',10,0),('5','105',230181,'DAILY','2021-10-09','2021-10-09 00:00:00',NULL,'641',0.00,0.00,'641','2021-10-10 10:41:19','607','2021-10-11 15:54:06',10,0),('5','105',230716,'DAILY ','2021-10-10','2021-10-10 00:00:00',NULL,'641',1645132.92,1645132.92,'641','2021-10-11 16:13:16','607','2021-10-11 16:15:52',10,0),('5','105',230722,'DAILY','2021-10-11','2021-10-11 00:00:00',NULL,'641',1421715.34,1421715.34,'641','2021-10-12 15:10:03','607','2021-10-12 15:13:26',10,0),('5','105',231010,'DAILY ','2021-10-12','2021-10-12 00:00:00',NULL,'641',1441606.23,1441606.23,'641','2021-10-13 05:27:56','607','2021-10-13 08:25:11',10,0),('5','105',231121,'DAILY ','2021-10-13','2021-10-13 00:00:00',NULL,'641',1204372.77,1204372.77,'641','2021-10-14 15:33:53','607','2021-10-14 15:47:11',10,0),('5','105',231606,'DAILY ','2021-10-14','2021-10-14 00:00:00',NULL,'641',1715703.77,1715703.77,'641','2021-10-14 22:28:24','607','2021-10-15 10:08:00',10,0),('5','105',231776,'DAILY ','2021-10-15','2021-10-15 00:00:00',NULL,'641',1463319.46,1463319.46,'641','2021-10-16 06:15:02','607','2021-10-16 06:39:47',10,0),('5','105',232003,'DAILY ','2021-10-16','2021-10-16 00:00:00',NULL,'641',1481678.15,1481678.15,'641','2021-10-16 21:49:11','607','2021-10-17 09:25:28',10,0),('5','105',232289,'DAILY ','2021-10-17','2021-10-17 00:00:00',NULL,'641',1528636.82,1528636.82,'641','2021-10-17 22:07:40','607','2021-10-18 09:44:08',10,0),('5','105',232452,'DAILY','2021-10-18','2021-10-18 00:00:00',NULL,'641',1116263.12,1116263.12,'641','2021-10-18 21:19:19','607','2021-10-19 07:35:00',10,0),('5','105',232763,'DAILY','2021-10-19','2021-10-19 00:00:00',NULL,'641',1581145.64,1581145.64,'641','2021-10-20 07:25:09','607','2021-10-20 09:04:09',10,0),('5','105',233321,'DAILY ','2021-10-20','2021-10-20 00:00:00',NULL,'641',1500468.74,1500468.74,'641','2021-10-21 18:14:42','607','2021-10-21 19:55:05',10,0),('5','105',233336,'DAILY ','2021-10-21','2021-10-21 00:00:00',NULL,'641',1541460.94,1544294.44,'641','2021-10-22 09:01:13','607','2021-10-22 09:17:49',10,0),('5','105',233629,'DAILY','2021-10-22','2021-10-22 00:00:00',NULL,'641',467631.07,467631.07,'641','2021-10-23 07:15:44','607','2021-10-23 08:04:21',10,0),('5','105',234184,'DAILY','2021-10-23','2021-10-23 00:00:00',NULL,'641',141287.85,141287.85,'641','2021-10-25 12:19:04','607','2021-10-25 13:17:13',10,0),('5','105',234201,'DAILY ','2021-10-24','2021-10-24 00:00:00',NULL,'641',51077.25,51077.25,'641','2021-10-25 13:21:18','607','2021-10-25 13:23:57',10,0),('5','105',234484,'DAILY','2021-10-25','2021-10-25 00:00:00',NULL,'641',52388.25,52388.25,'641','2021-10-26 14:22:19','607','2021-10-26 16:16:26',10,0),('5','105',234801,'DAILY ','2021-10-26','2021-10-26 00:00:00',NULL,'641',42314.25,42314.25,'641','2021-10-27 23:16:23','607','2021-10-28 09:19:33',10,0),('5','105',234917,'DAILY ','2021-10-27','2021-10-27 00:00:00',NULL,'641',36073.20,36073.20,'641','2021-10-28 09:31:01','607','2021-10-28 15:53:56',10,0),('5','105',234995,'DAILY','2021-10-28','2021-10-28 00:00:00',NULL,'641',30808.50,30808.50,'641','2021-10-31 11:07:36','607','2021-10-31 11:13:56',10,0),('5','105',235611,'DAILY','2021-10-29','2021-10-29 00:00:00',NULL,'641',0.00,0.00,'641','2021-10-31 11:15:17','607','2021-10-31 11:16:46',10,0),('5','105',235618,'DAILY','2021-10-30','2021-10-30 00:00:00',NULL,'641',1439601.60,1439601.60,'641','2021-11-01 13:14:39','607','2021-11-01 16:12:08',10,0),('5','105',235951,'DAILY','2021-10-31','2021-10-31 00:00:00',NULL,'641',1463663.55,1463663.55,'641','2021-11-01 16:30:42','607','2021-11-01 16:33:38',10,0),('5','105',235954,'DAILY ','2021-11-01','2021-11-01 00:00:00',NULL,'641',230218.95,230218.95,'641','2021-11-02 16:29:45','607','2021-11-02 16:47:25',10,0),('5','105',236195,'DAILY ','2021-11-02','2021-11-02 00:00:00',NULL,'641',1472530.35,1472530.35,'641','2021-11-03 09:58:31','607','2021-11-03 10:34:48',10,0),('5','105',236539,'DAILY ','2021-11-03','2021-11-03 00:00:00',NULL,'641',1045582.50,1045582.50,'641','2021-11-04 07:00:53','607','2021-11-04 10:37:00',10,0),('5','105',236606,'DAILY ','2021-11-04','2021-11-04 00:00:00',NULL,'641',1764282.15,1764282.15,'641','2021-11-05 06:03:29','607','2021-11-05 10:16:33',10,0),('5','105',237053,'DAILY','2021-11-05','2021-11-05 00:00:00',NULL,'641',1774606.50,1774606.50,'641','2021-11-06 11:44:52','600','2021-11-07 07:48:39',10,0),('5','105',237224,'DAILY','2021-11-06','2021-11-06 00:00:00',NULL,'641',1063953.75,1063953.75,'641','2021-11-07 08:19:48','600','2021-11-08 07:36:03',10,0),('5','105',237549,'DAILY ','2021-11-07','2021-11-07 00:00:00',NULL,'641',76976.40,76976.40,'641','2021-11-08 17:25:16','600','2021-11-09 08:39:42',10,0),('5','105',237792,'DAILY ','2021-11-08','2021-11-08 00:00:00',NULL,'641',0.00,0.00,'641','2021-11-09 20:32:45','600','2021-11-10 11:17:09',10,0),('5','105',238028,'DAILY','2021-11-09','2021-11-09 00:00:00',NULL,'641',0.00,0.00,'641','2021-11-10 13:55:43','600','2021-11-10 15:53:48',10,0),('5','105',238051,'DAILY','2021-11-10','2021-11-10 00:00:00',NULL,'641',1921018.95,1921018.95,'641','2021-11-10 21:30:11','600','2021-11-11 04:51:52',10,0),('5','105',238225,'DAILY','2021-11-11','2021-11-11 00:00:00',NULL,'641',1640117.40,1640117.40,'641','2021-11-12 06:06:26','600','2021-11-12 08:15:20',10,0),('5','105',238417,'DAILY ','2021-11-12','2021-11-12 00:00:00',NULL,'641',1751576.85,1751576.85,'641','2021-11-14 03:21:09','600','2021-11-14 09:37:52',10,0),('5','105',239163,'DAILY ','2021-11-13','2021-11-13 00:00:00',NULL,'641',2077366.35,2077366.35,'641','2021-11-15 10:27:55','600','2021-11-15 14:08:19',10,0),('5','105',239212,'DAILY','2021-11-14','2021-11-14 00:00:00',NULL,'641',2496594.00,2496594.00,'641','2021-11-15 14:32:27','600','2021-11-16 08:09:04',10,0),('5','105',239355,'DAILY ','2021-11-15','2021-11-15 00:00:00',NULL,'641',2322616.65,2322616.65,'641','2021-11-16 08:45:57','600','2021-11-16 20:07:37',10,0),('5','105',239492,'DAILY ','2021-11-16','2021-11-16 00:00:00',NULL,'641',2544090.60,2544090.60,'641','2021-11-17 07:40:44','600','2021-11-17 08:00:20',10,0),('5','105',239669,'DAILY ','2021-11-17','2021-11-17 00:00:00',NULL,'641',1936785.75,1936785.75,'641','2021-11-17 22:41:09','600','2021-11-18 10:14:38',10,0),('5','105',239856,'DAILY ','2021-11-18','2021-11-18 00:00:00',NULL,'641',1726850.85,1726850.85,'641','2021-11-19 12:46:37','600','2021-11-20 08:28:37',10,0),('5','105',240406,'DAILY ','2021-11-19','2021-11-19 00:00:00',NULL,'641',1812126.00,1812126.00,'641','2021-11-20 20:35:53','600','2021-11-21 12:19:12',10,0),('5','105',240599,'DAILY','2021-11-20','2021-11-20 00:00:00',NULL,'641',2060096.10,2060096.10,'641','2021-11-21 17:03:41','600','2021-11-21 17:25:37',10,0),('5','105',240603,'DAILY','2021-11-21','2021-11-21 00:00:00',NULL,'641',2081402.55,2081402.55,'641','2021-11-21 22:23:23','600','2021-11-22 08:00:42',10,0),('5','105',240787,'DAILY ','2021-11-22','2021-11-22 00:00:00',NULL,'641',1825977.30,1825977.30,'641','2021-11-23 07:51:04','600','2021-11-23 09:23:17',10,0),('5','105',241071,'DAILY','2021-11-23','2021-11-23 00:00:00',NULL,'641',1786899.90,1786899.90,'641','2021-11-24 08:33:08','600','2021-11-24 08:46:16',10,0),('5','105',241416,'DAILY','2021-11-24','2021-11-24 00:00:00',NULL,'641',889842.00,889842.00,'641','2021-11-25 08:59:12','600','2021-11-26 08:26:12',10,0),('5','105',241863,'DAILY ','2021-11-25','2021-11-25 00:00:00',NULL,'641',143426.85,143426.85,'641','2021-11-26 12:51:43','600','2021-11-27 07:56:10',10,0),('5','105',242088,'DAILY ','2021-11-26','2021-11-26 00:00:00',NULL,'641',181442.40,181442.40,'641','2021-11-27 13:04:02','600','2021-11-27 16:01:33',10,0),('5','105',242131,'DAILY','2021-11-27','2021-11-27 00:00:00',NULL,'641',1681986.90,1681986.90,'641','2021-11-28 04:33:16','600','2021-11-28 17:59:19',10,0),('5','105',242373,'DAILY','2021-11-28','2021-11-28 00:00:00',NULL,'641',1837850.85,1837850.85,'641','2021-11-29 06:02:00','600','2021-11-29 06:56:14',10,0),('5','105',242534,'DAILY ','2021-11-29','2021-11-29 00:00:00',NULL,'641',1773091.35,1773091.35,'641','2021-11-30 07:42:39','600','2021-11-30 08:46:37',10,0),('5','105',242838,'DAILY','2021-11-30','2021-11-30 00:00:00',NULL,'641',1853320.35,1853320.35,'641','2021-12-01 07:56:30','600','2021-12-01 08:31:31',10,0),('5','105',243083,'DAILY','2021-12-01','2021-12-01 00:00:00',NULL,'641',1237738.95,1237738.95,'641','2021-12-02 15:19:13','600','2021-12-02 15:28:04',10,0),('5','105',243283,'DAILY','2021-12-02','2021-12-02 00:00:00',NULL,'641',2078580.30,2078580.30,'641','2021-12-03 08:15:29','600','2021-12-03 09:19:06',10,0),('5','105',243648,'DAILY ','2021-12-03','2021-12-03 00:00:00',NULL,'641',2150886.30,2150886.30,'641','2021-12-04 08:05:25','600','2021-12-04 13:24:11',10,0),('5','105',243789,'DAILY','2021-12-04','2021-12-04 00:00:00',NULL,'641',2471830.55,2471830.55,'641','2021-12-05 04:56:29','600','2021-12-05 07:51:53',10,0),('5','105',243953,'DAILY','2021-12-05','2021-12-05 00:00:00',NULL,'641',2277812.25,2277812.25,'641','2021-12-06 05:44:11','600','2021-12-06 08:59:19',10,0),('5','105',244191,'DAILY ','2021-12-06','2021-12-06 00:00:00',NULL,'641',979059.00,979059.00,'641','2021-12-06 22:08:39','600','2021-12-07 08:08:28',10,0),('5','105',244477,'DAILY ','2021-12-07','2021-12-07 00:00:00',NULL,'641',2030841.00,2030841.00,'641','2021-12-08 13:52:25','600','2021-12-08 17:41:56',10,0),('5','105',244769,'DAILY ','2021-12-08','2021-12-08 00:00:00',NULL,'641',2321006.70,2321006.70,'641','2021-12-09 06:51:23','600','2021-12-09 09:33:38',10,0),('5','105',245051,'DAILY','2021-12-09','2021-12-09 00:00:00',NULL,'641',1117537.20,1117537.20,'641','2021-12-10 09:15:34','600','2021-12-10 10:52:39',10,0),('5','105',245119,'DAILY ','2021-12-10','2021-12-10 00:00:00',NULL,'641',143865.00,143865.00,'641','2021-12-10 19:59:56','600','2021-12-11 06:57:38',10,0),('5','105',245416,'DAILY','2021-12-11','2021-12-11 00:00:00',NULL,'641',116254.65,116254.65,'641','2021-12-11 22:11:01','600','2021-12-12 03:44:50',10,0),('5','105',245609,'DAILY','2021-12-12','2021-12-12 00:00:00',NULL,'641',148394.85,148394.85,'641','2021-12-12 19:07:54','600','2021-12-13 10:39:10',10,0),('5','105',245791,'DAILY','2021-12-13','2021-12-13 00:00:00',NULL,'641',354646.20,354646.20,'641','2021-12-14 10:33:52','600','2021-12-14 14:10:58',10,0),('5','105',246167,'DAILY','2021-12-14','2021-12-14 00:00:00',NULL,'641',1465078.20,1465078.20,'641','2021-12-15 19:05:01','600','2021-12-16 08:14:31',10,0),('5','105',246550,'DAILY','2021-12-15','2021-12-15 00:00:00',NULL,'641',2050813.95,2050813.95,'641','2021-12-16 10:15:45','600','2021-12-16 10:19:34',10,0),('5','105',246655,'DAILY','2021-12-16','2021-12-16 00:00:00',NULL,'641',1816704.75,1816704.75,'641','2021-12-17 09:09:21','600','2021-12-17 09:36:10',10,0),('5','105',246947,'DAILY','2021-12-17','2021-12-17 00:00:00',NULL,'641',1219693.50,1219693.50,'641','2021-12-19 06:20:21','600','2021-12-19 07:51:35',10,0),('5','105',247389,'DAILY','2021-12-18','2021-12-18 00:00:00',NULL,'641',1882531.35,1882531.35,'641','2021-12-20 05:40:10','600','2021-12-20 11:12:47',10,0),('5','105',247510,'DAILY','2021-12-19','2021-12-19 00:00:00',NULL,'641',1723055.85,1723055.85,'641','2021-12-20 12:23:52','600','2021-12-20 19:12:05',10,0),('5','105',247647,'DAILY','2021-12-20','2021-12-20 00:00:00',NULL,'641',1436577.90,1436577.90,'641','2021-12-21 05:56:52','600','2021-12-21 07:58:38',10,0),('5','105',247770,'DAILY','2021-12-21','2021-12-21 00:00:00',NULL,'641',713267.40,713267.40,'641','2021-12-22 09:22:33','600','2021-12-22 09:30:53',10,0),('5','105',248052,'DAILY','2021-12-22','2021-12-22 00:00:00',NULL,'641',1630474.50,1630474.50,'641','2021-12-23 07:17:07','600','2021-12-23 08:24:49',10,0),('5','105',248345,'DAILY','2021-12-23','2021-12-23 00:00:00',NULL,'641',514489.50,514489.50,'641','2021-12-23 21:18:20','600','2021-12-24 08:13:51',10,0),('5','105',248525,'DAILY','2021-12-24','2021-12-24 00:00:00',NULL,'641',1950074.40,1950074.40,'641','2021-12-25 07:52:51','600','2021-12-25 08:29:09',10,0),('5','105',248773,'DAILY','2021-12-25','2021-12-25 00:00:00',NULL,'641',2070764.55,2070764.55,'641','2021-12-26 07:49:17','600','2021-12-26 11:06:40',10,0),('5','105',249308,'DAILY','2021-12-26','2021-12-26 00:00:00',NULL,'641',1873885.20,1873885.20,'641','2021-12-27 19:44:34','600','2021-12-28 08:18:57',10,0),('5','105',249451,'DAILY','2021-12-27','2021-12-27 00:00:00',NULL,'641',1603179.60,1603179.60,'641','2021-12-29 06:25:25','600','2021-12-29 08:43:44',10,0),('5','105',249720,'DAILY','2021-12-28','2021-12-28 00:00:00',NULL,'641',2045904.30,2045904.30,'641','2021-12-29 11:45:14','600','2021-12-30 08:58:11',10,0),('5','105',250015,'DAILY','2021-12-29','2021-12-29 00:00:00',NULL,'641',597486.45,597486.45,'641','2022-01-02 06:01:36','600','2022-01-02 09:31:09',10,0),('5','105',250693,'DAILY','2021-12-30','2021-12-30 00:00:00',NULL,'641',0.00,0.00,'641','2022-01-02 14:15:45','600','2022-01-02 16:06:33',10,0),('5','105',250729,'DAILY69','2021-12-31','2021-12-31 00:00:00',NULL,'641',337660.95,337660.95,'641','2022-01-02 16:21:30','600','2022-01-02 16:24:14',10,0),('5','105',250731,'DAILY','2022-01-01','2022-01-01 00:00:00',NULL,'641',1495553.70,1495553.70,'641','2022-01-02 16:39:25','600','2022-01-02 16:41:42',10,0),('5','105',251195,'DAILY','2022-01-02','2022-01-02 00:00:00',NULL,'641',1636540.95,1636540.95,'641','2022-01-04 15:59:54','600','2022-01-04 17:52:59',10,0),('5','105',251717,'DAILY','2022-01-03','2022-01-03 00:00:00',NULL,'641',1469131.95,1469131.95,'641','2022-01-06 20:48:08','600','2022-01-07 11:41:41',10,0),('5','105',251932,'DAILY','2022-01-04','2022-01-04 00:00:00',NULL,'641',1722761.70,1722761.70,'641','2022-01-07 19:00:37','600','2022-01-07 21:11:31',10,0),('5','105',252148,'DAILY','2022-01-05','2022-01-05 00:00:00',NULL,'641',2037156.00,2037156.00,'641','2022-01-11 08:00:31','600','2022-01-11 09:24:41',10,0),('5','105',252905,'DAILY','2022-01-06','2022-01-06 00:00:00',NULL,'641',2077412.70,2077412.70,'641','2022-01-11 21:45:30','600','2022-01-11 21:50:07',10,0),('5','105',252937,'DAILY','2022-01-07','2022-01-07 00:00:00',NULL,'641',1547508.60,1547508.60,'641','2022-01-11 22:02:32','600','2022-01-12 09:41:15',10,0),('5','105',253170,'DAILY','2022-01-08','2022-01-08 00:00:00',NULL,'641',1325167.80,1325167.80,'641','2022-01-12 21:21:11','600','2022-01-12 21:28:47',10,0),('5','105',253206,'DAILY','2022-01-09','2022-01-09 00:00:00',NULL,'641',272096.55,272096.55,'641','2022-01-13 07:26:50','600','2022-01-13 09:11:27',10,0),('5','105',253307,'DAILY','2022-01-10','2022-01-10 00:00:00',NULL,'641',382064.10,382064.10,'641','2022-01-13 11:05:11','600','2022-01-13 11:08:09',10,0),('5','105',253312,'DAILY','2022-01-11','2022-01-11 00:00:00',NULL,'641',2075399.70,2075399.70,'641','2022-01-13 11:10:57','600','2022-01-13 11:12:11',10,0),('5','105',253315,'DAILY','2022-01-12','2022-01-12 00:00:00',NULL,'641',2081418.90,2081418.90,'641','2022-01-13 11:19:10','600','2022-01-13 11:20:23',10,0),('5','105',253321,'DAILY','2022-01-13','2022-01-13 00:00:00',NULL,'641',1731886.20,1731886.20,'641','2022-01-13 20:21:10','600','2022-01-14 09:52:11',10,0),('5','105',253574,'DAILY','2022-01-14','2022-01-14 00:00:00',NULL,'641',405796.05,405796.05,'641','2022-01-15 19:08:01','600','2022-01-16 06:18:47',10,0),('5','105',254022,'DAILY','2022-01-15','2022-01-15 00:00:00',NULL,'641',397336.50,397336.50,'641','2022-01-16 19:02:11','600','2022-01-16 19:03:41',10,0),('5','105',254182,'DAILY','2022-01-16','2022-01-16 00:00:00',NULL,'641',1634706.15,1634706.15,'641','2022-01-17 06:17:06','600','2022-01-17 09:13:32',10,0),('5','105',254333,'DAILY','2022-01-17','2022-01-17 00:00:00',NULL,'641',1643512.20,1643512.20,'641','2022-01-18 07:17:30','600','2022-01-18 10:15:26',10,0),('5','105',254811,'DAILY','2022-01-18','2022-01-18 00:00:00',NULL,'641',1492865.55,1492865.55,'641','2022-01-19 11:52:51','600','2022-01-19 16:19:44',10,0),('5','105',254903,'DAILY','2022-01-19','2022-01-19 00:00:00',NULL,'641',287370.60,287370.60,'641','2022-01-20 15:43:59','600','2022-01-20 16:50:20',10,0),('5','105',255455,'DAILY','2022-01-20','2022-01-20 00:00:00',NULL,'641',0.00,0.00,'641','2022-01-22 06:56:11','600','2022-01-22 09:25:11',10,0),('5','105',255692,'DAILY','2022-01-21','2022-01-21 00:00:00',NULL,'641',0.00,0.00,'641','2022-01-22 22:54:58','600','2022-01-22 22:57:57',10,0),('5','105',255835,'DAILY','2022-01-22','2022-01-22 00:00:00',NULL,'641',0.00,0.00,'641','2022-01-23 14:34:49','600','2022-01-23 16:27:02',10,0),('5','105',255909,'DAILY','2022-01-23','2022-01-23 00:00:00',NULL,'641',1292250.30,1292250.30,'641','2022-01-24 06:07:15','600','2022-01-24 09:38:23',10,0),('5','105',256121,'DAILY','2022-01-24','2022-01-24 00:00:00',NULL,'641',1591519.05,1591519.05,'641','2022-01-25 08:24:40','600','2022-01-25 09:09:50',10,0),('5','105',256575,'DAILY','2022-01-25','2022-01-25 00:00:00',NULL,'641',1472271.90,1472271.90,'641','2022-01-26 11:06:51','600','2022-01-27 10:03:54',10,0),('5','105',256817,'DAILY','2022-01-26','2022-01-26 00:00:00',NULL,'641',1380426.30,1380426.30,'641','2022-01-27 11:33:58','600','2022-01-27 15:10:24',10,0),('5','105',256919,'DAILY','2022-01-27','2022-01-27 00:00:00',NULL,'641',1342639.65,1342639.65,'641','2022-01-29 05:54:17','600','2022-01-29 13:24:56',10,0),('5','105',257481,'DAILY','2022-01-28','2022-01-28 00:00:00',NULL,'641',318179.40,318179.40,'641','2022-01-30 06:25:21','600','2022-01-30 10:21:47',10,0),('5','105',257482,'DAILY','2022-01-29','2022-01-29 00:00:00',NULL,'641',213627.15,213627.15,'641','2022-01-31 15:58:15','600','2022-01-31 16:17:46',10,0),('5','105',257483,'DAILY','2022-01-30','2022-01-30 00:00:00',NULL,'641',1582950.60,1582950.60,'641','2022-01-31 19:05:06','600','2022-02-01 09:07:36',10,0),('5','105',257484,'DAILY','2022-01-31','2022-01-31 00:00:00',NULL,'641',1447515.30,1447515.30,'641','2022-02-01 09:16:11','600','2022-02-01 09:50:46',10,0),('5','105',257485,'DAILY','2022-02-01','2022-02-01 00:00:00',NULL,'641',1431747.90,1431747.90,'641','2022-02-02 06:32:38','600','2022-02-02 14:56:14',10,0),('5','105',257486,'DAILY','2022-02-02','2022-02-02 00:00:00',NULL,'641',1493286.30,1493286.30,'641','2022-02-03 07:04:04','600','2022-02-03 09:13:17',10,0),('5','105',257487,'DAILY','2022-02-03','2022-02-03 00:00:00',NULL,'641',378670.05,378670.05,'641','2022-02-04 11:23:03','600','2022-02-04 14:18:02',10,0),('5','105',257488,'DAILY','2022-02-04','2022-02-04 00:00:00',NULL,'641',310039.95,310039.95,'641','2022-02-05 21:25:27','600','2022-02-06 05:23:58',10,0),('5','105',257489,'DAILY','2022-02-05','2022-02-05 00:00:00',NULL,'641',1340973.15,1340973.15,'641','2022-02-06 14:54:01','600','2022-02-06 16:30:13',10,0),('5','105',257490,'DAILY','2022-02-06','2022-02-06 00:00:00',NULL,'641',1593319.20,1593319.20,'641','2022-02-07 05:11:44','600','2022-02-07 10:39:26',10,0),('5','105',257491,'DAILY','2022-02-07','2022-02-07 00:00:00',NULL,'641',1563282.60,1563282.60,'641','2022-02-08 12:38:26','600','2022-02-09 09:10:20',10,0),('5','105',257492,'DAILY','2022-02-08','2022-02-08 00:00:00',NULL,'641',1431965.70,1431965.70,'641','2022-02-10 22:43:27','600','2022-02-11 09:43:10',10,0),('5','105',257493,'DAILY','2022-02-09','2022-02-09 00:00:00',NULL,'641',283427.10,283427.10,'641','2022-02-11 12:18:27','600','2022-02-11 12:20:51',10,0),('5','105',257494,'DAILY','2022-02-10','2022-02-10 00:00:00',NULL,'641',0.00,0.00,'641','2022-02-11 12:40:50','600','2022-02-11 12:41:55',10,0),('5','105',257495,'DAILY','2022-02-11','2022-02-11 00:00:00',NULL,'641',0.00,0.00,'641','2022-02-13 12:51:54','600','2022-02-13 21:48:18',10,0),('5','105',257496,'DAILY','2022-02-12','2022-02-12 00:00:00',NULL,'641',399968.25,399968.25,'641','2022-02-14 16:52:42','600','2022-02-14 16:53:35',10,0),('5','105',257497,'DAILY','2022-02-13','2022-02-13 00:00:00',NULL,'641',936528.45,936528.45,'641','2022-02-14 16:56:30','600','2022-02-14 16:57:23',10,0),('5','105',257498,'DAILY','2022-02-14','2022-02-14 00:00:00',NULL,'641',858465.30,858465.30,'641','2022-02-16 06:09:57','600','2022-02-16 12:41:23',10,0),('5','105',257499,'DAILY','2022-02-15','2022-02-15 00:00:00',NULL,'641',976243.95,976243.95,'641','2022-02-16 13:13:20','600','2022-02-17 08:57:38',10,0),('5','105',257500,'DAILY','2022-02-16','2022-02-16 00:00:00',NULL,'641',410178.45,410178.45,'641','2022-02-17 22:28:02','600','2022-02-18 09:23:38',10,0),('5','105',257501,'DAILY','2022-02-17','2022-02-17 00:00:00',NULL,'641',0.00,0.00,'641','2022-02-20 05:59:59','600','2022-02-20 08:48:39',10,0),('5','105',257502,'DAILY','2022-02-18','2022-02-18 00:00:00',NULL,'641',0.00,0.00,'641','2022-02-21 14:20:52','600','2022-02-21 14:22:31',10,0),('5','105',257503,'DAILY','2022-02-19','2022-02-19 00:00:00',NULL,'641',0.00,0.00,'641','2022-02-21 14:27:06','600','2022-02-21 14:28:42',10,0),('5','105',257504,'DAILY','2022-02-20','2022-02-20 00:00:00',NULL,'641',0.00,0.00,'641','2022-02-21 14:43:20','600','2022-02-22 09:22:03',10,0),('5','105',257505,'DAILY','2022-02-21','2022-02-22 16:18:39','2022-02-23 16:18:39','641',424482.30,424482.30,'641','2022-02-22 16:20:08','600','2022-02-23 09:09:26',10,0),('5','105',257506,'DAILY','2022-02-22','2022-02-23 19:07:24','2022-02-24 19:07:24','641',1514597.70,1514597.70,'641','2022-02-23 19:21:23','600','2022-02-23 19:23:27',10,0),('5','105',257507,'DAILY','2022-02-23','2022-02-24 18:44:13','2022-02-25 18:44:13','641',823623.95,823623.95,'641','2022-02-24 18:54:01','600','2022-02-25 09:37:53',10,0),('5','105',257508,'DAILY','2022-02-24','2022-02-25 19:33:13','2022-02-26 19:33:13','641',2389800.60,2389800.60,'641','2022-02-26 05:19:40','600','2022-02-26 09:47:01',10,0),('5','105',257509,'DAILY','2022-02-25','2022-02-26 21:49:20','2022-02-27 21:49:20','641',1236675.00,1236675.00,'641','2022-02-27 12:33:54','600','2022-02-27 13:42:04',10,0),('5','105',257510,'DAILY','2022-02-26','2022-02-27 14:18:31','2022-02-28 14:18:31','641',838945.80,838945.80,'641','2022-02-27 14:25:19','600','2022-02-28 08:47:50',10,0),('5','105',257511,'DAILY','2022-02-27','2022-03-01 06:08:40','2022-03-02 06:08:40','641',401182.65,401182.65,'641','2022-03-01 15:46:40','600','2022-03-01 16:42:02',10,0),('5','105',257512,'DAILY','2022-02-28','2022-03-01 17:11:24','2022-03-02 17:11:24','641',1727761.20,1727761.20,'641','2022-03-01 17:27:09','600','2022-03-01 17:52:51',10,0),('5','105',257513,'DAILY','2022-03-01','2022-03-02 06:25:42','2022-03-03 06:25:42','641',1253854.80,1253854.80,'641','2022-03-02 06:26:57','600','2022-03-02 09:36:59',10,0),('5','105',257514,'DAILY','2022-03-02','2022-03-02 23:20:37','2022-03-03 23:20:37','641',1333003.65,1333003.65,'641','2022-03-03 06:21:56','600','2022-03-03 10:22:52',10,0),('5','105',257515,'DAILY','2022-03-03','2022-03-07 07:39:16','2022-03-08 07:39:16','641',1320966.90,1320966.90,'641','2022-03-07 07:44:56','600','2022-03-08 10:05:04',10,0),('5','105',257516,'DAILY','2022-03-04','2022-03-09 06:07:55','2022-03-10 06:07:55','641',280519.80,280519.80,'641','2022-03-09 06:10:03','600','2022-03-09 16:18:29',10,0),('5','105',257517,'DAILY','2022-03-05','2022-03-09 16:25:18','2022-03-10 16:25:18','641',0.00,0.00,'641','2022-03-09 16:25:40','600','2022-03-09 16:40:56',10,0),('5','105',257518,'DAILY','2022-03-06','2022-03-09 17:44:51','2022-03-10 17:44:51','641',0.00,0.00,'641','2022-03-09 17:46:19','600','2022-03-10 09:08:18',10,0),('5','105',257519,'DAILY','2022-03-07','2022-03-11 07:04:17','2022-03-12 07:04:17','641',0.00,0.00,'641','2022-03-11 07:04:47','600','2022-03-11 15:04:34',10,0),('5','105',257520,'DAILY','2022-03-08','2022-03-11 15:26:34','2022-03-12 15:26:34','641',1335524.85,1335524.85,'641','2022-03-11 16:20:22','600','2022-03-11 18:04:40',10,0),('5','105',257521,'DAILY','2022-03-09','2022-03-12 11:24:56','2022-03-13 11:24:56','641',1944978.75,1944978.75,'641','2022-03-12 11:27:07','600','2022-03-12 13:39:03',10,0),('5','105',257522,'DAILY','2022-03-10','2022-03-13 06:05:38','2022-03-14 06:05:38','641',401189.25,401189.25,'641','2022-03-13 06:06:59','600','2022-03-13 08:53:03',10,0),('5','105',257523,'DAILY','2022-03-11','2022-03-13 18:04:00','2022-03-14 18:04:00','641',0.00,0.00,'641','2022-03-13 18:04:57','600','2022-03-13 18:58:32',10,0),('5','105',257524,'DAILY','2022-03-12','2022-03-13 19:38:31','2022-03-14 19:38:31','641',832360.65,832360.65,'641','2022-03-14 14:47:39','600','2022-03-15 09:13:11',10,0),('5','105',257525,'DAILY','2022-03-13','2022-03-15 13:42:24','2022-03-16 13:42:24','641',1809982.35,1809982.35,'641','2022-03-15 14:33:58','600','2022-03-15 16:51:02',10,0),('5','105',257526,'DAILY','2022-03-14','2022-03-16 06:13:44','2022-03-17 06:13:44','641',1488869.25,1488869.25,'641','2022-03-16 06:15:00','600','2022-03-16 11:37:35',10,0),('5','105',257527,'DAILY','2022-03-15','2022-03-17 06:00:35','2022-03-18 06:00:35','641',803508.75,803508.75,'641','2022-03-19 20:15:54','600','2022-03-19 22:03:28',10,0),('5','105',257528,'DAILY','2022-03-16','2022-03-19 22:59:31','2022-03-20 22:59:31','641',0.00,0.00,'641','2022-03-19 22:59:49','600','2022-03-20 13:15:37',10,0),('5','105',257529,'DAILY','2022-03-17','2022-03-20 15:05:21','2022-03-21 15:05:21','641',0.00,0.00,'641','2022-03-20 15:05:41','600','2022-03-20 15:16:18',10,0),('5','105',257530,'DAILY','2022-03-18','2022-03-20 19:38:32','2022-03-21 19:38:32','641',0.00,0.00,'641','2022-03-20 19:39:00','600','2022-03-20 20:00:22',10,0),('5','105',257531,'DAILY','2022-03-19','2022-03-20 20:15:47','2022-03-21 20:15:47','641',0.00,0.00,'641','2022-03-20 20:16:08','600','2022-03-20 20:45:08',10,0),('5','105',257532,'DAILY','2022-03-20','2022-03-20 20:52:17','2022-03-21 20:52:17','641',0.00,0.00,'641','2022-03-20 20:52:35','600','2022-03-20 21:23:41',10,0),('5','105',257533,'DAILY','2022-03-21','2022-03-21 19:37:29','2022-03-22 19:37:29','641',0.00,0.00,'641','2022-03-21 19:38:04','600','2022-03-22 09:01:49',10,0),('5','105',257534,'DAILY','2022-03-22','2022-03-22 17:59:35','2022-03-23 17:59:35','641',0.00,0.00,'641','2022-03-22 23:35:24','600','2022-03-23 10:25:52',10,0),('5','105',257535,'DAILY','2022-03-23','2022-03-23 22:54:38','2022-03-24 22:54:38','641',0.00,0.00,'641','2022-03-23 22:54:56','600','2022-03-24 09:04:53',10,0),('5','105',257536,'DAILY','2022-03-24','2022-03-25 08:04:28','2022-03-26 08:04:28','641',0.00,0.00,'641','2022-03-25 08:04:48','600','2022-03-25 10:18:49',10,0),('5','105',257537,'DAILY','2022-03-25','2022-03-26 08:31:37','2022-03-27 08:31:37','641',0.00,0.00,'641','2022-03-26 08:31:54','600','2022-03-26 12:41:17',10,0),('5','105',257538,'DAILY','2022-03-26','2022-03-27 19:22:57','2022-03-28 19:22:57','641',479828.25,479828.25,'641','2022-03-27 19:31:14','600','2022-03-28 10:11:23',10,0),('5','105',257539,'DAILY','2022-03-27','2022-03-28 13:00:45','2022-03-29 13:00:45','641',837398.10,837398.10,'641','2022-03-28 13:08:06','600','2022-03-28 13:12:33',10,0),('5','105',257540,'DAILY','2022-03-28','2022-03-29 06:19:43','2022-03-30 06:19:43','641',744590.55,744590.55,'641','2022-03-29 10:06:32','600','2022-03-29 11:29:38',10,0),('5','105',257541,'DAILY','2022-03-29','2022-03-29 14:50:53','2022-03-30 14:50:53','641',397126.95,397126.95,'641','2022-03-30 12:23:29','600','2022-03-31 09:26:51',10,0),('5','105',257542,'DAILY','2022-03-30','2022-04-01 19:10:57','2022-04-02 19:10:57','641',0.00,0.00,'641','2022-04-01 19:12:12','600','2022-04-01 19:20:25',10,0),('5','105',257543,'DAILY','2022-03-31','2022-04-02 04:42:33','2022-04-03 04:42:33','641',0.00,0.00,'641','2022-04-02 04:43:44','600','2022-04-02 16:13:06',10,0),('5','105',257544,'DAILY','2022-04-01','2022-04-02 18:25:59','2022-04-03 18:25:59','641',0.00,0.00,'641','2022-04-02 18:26:31','600','2022-04-03 11:04:32',10,0),('5','105',257545,'DAILY','2022-04-02','2022-04-03 13:30:55','2022-04-04 13:30:55','641',0.00,0.00,'641','2022-04-03 13:35:09','600','2022-04-04 09:06:43',10,0),('5','105',257546,'DAILY','2022-04-03','2022-04-04 18:54:28','2022-04-05 18:54:28','641',0.00,0.00,'641','2022-04-04 18:54:52','600','2022-04-05 11:31:47',10,0),('5','105',257547,'DAILY','2022-04-04','2022-04-05 12:05:59','2022-04-06 12:05:59','641',0.00,0.00,'641','2022-04-05 12:06:45','600','2022-04-06 09:05:00',10,0),('5','105',257548,'DAILY','2022-04-05','2022-04-06 13:42:52','2022-04-07 13:42:52','641',0.00,0.00,'641','2022-04-06 13:43:25','600','2022-04-07 13:56:57',10,0),('5','105',257549,'DAILY','2022-04-06','2022-04-08 06:48:00','2022-04-09 06:48:00','641',853596.15,853596.15,'641','2022-04-08 06:49:26','600','2022-04-08 09:10:39',10,0),('5','105',257550,'DAILY','2022-04-07','2022-04-09 07:37:10','2022-04-10 07:37:10','641',955769.10,955769.10,'641','2022-04-09 07:38:33','600','2022-04-09 08:59:44',10,0),('5','105',257551,'DAILY','2022-04-08','2022-04-09 16:31:35','2022-04-10 16:31:35','641',385638.00,385638.00,'641','2022-04-09 16:33:11','600','2022-04-09 21:34:05',10,0),('5','105',257552,'DAILY','2022-04-09','2022-04-10 18:46:35','2022-04-11 18:46:35','641',906897.75,906897.75,'641','2022-04-11 05:34:25','600','2022-04-11 09:05:53',10,0),('5','105',257553,'DAILY','2022-04-10','2022-04-11 11:49:47','2022-04-12 11:49:47','641',1567856.40,1567856.40,'641','2022-04-12 16:15:59','600','2022-04-13 08:57:06',10,0),('5','105',257554,'DAILY','2022-04-11','2022-04-13 09:39:01','2022-04-14 09:39:01','641',1412711.85,1412711.85,'641','2022-04-13 09:40:29','600','2022-04-13 15:02:01',10,0),('5','105',257555,'DAILY','2022-04-12','2022-04-13 19:21:12','2022-04-14 19:21:12','641',1195566.90,1195566.90,'641','2022-04-14 06:48:37','600','2022-04-14 09:21:37',10,0),('5','105',257556,'DAILY','2022-04-13','2022-04-14 11:37:57','2022-04-15 11:37:57','641',1173649.95,1173649.95,'641','2022-04-14 16:40:40','600','2022-04-15 10:18:05',10,0),('5','105',257557,'DAILY','2022-04-14','2022-04-16 10:59:23','2022-04-17 10:59:23','641',1159643.10,1159643.10,'641','2022-04-16 11:01:02','600','2022-04-16 11:05:31',10,0),('5','105',257558,'DAILY','2022-04-15','2022-04-16 12:17:30','2022-04-17 12:17:30','641',988830.15,988830.15,'641','2022-04-16 17:24:27','600','2022-04-16 19:58:55',10,0),('5','105',257559,'DAILY','2022-04-16','2022-04-18 00:17:06','2022-04-19 00:17:06','641',563135.10,563135.10,'641','2022-04-18 00:21:14','600','2022-04-18 11:07:28',10,0),('5','105',257560,'DAILY','2022-04-17','2022-04-18 20:47:06','2022-04-19 20:47:06','641',0.00,0.00,'641','2022-04-18 20:47:45','600','2022-04-19 10:49:54',10,0),('5','105',257561,'DAILY','2022-04-18','2022-04-19 19:48:57','2022-04-20 19:48:57','641',0.00,0.00,'641','2022-04-19 19:49:35','600','2022-04-20 09:47:49',10,0),('5','105',257562,'DAILY','2022-04-19','2022-04-20 19:12:18','2022-04-21 19:12:18','641',0.00,0.00,'641','2022-04-20 19:28:43','600','2022-04-21 09:21:37',10,0),('5','105',257563,'DAILY','2022-04-20','2022-04-22 14:50:25','2022-04-23 14:50:25','641',0.00,0.00,'641','2022-04-22 14:50:50','600','2022-04-22 15:05:09',10,0),('5','105',257564,'DAILY','2022-04-21','2022-04-22 15:06:27','2022-04-23 15:06:27','641',0.00,0.00,'641','2022-04-22 15:06:54','600','2022-04-22 15:12:06',10,0),('5','105',257565,'DAILY','2022-04-22','2022-04-22 17:05:49','2022-04-23 17:05:49','641',0.00,0.00,'641','2022-04-23 13:05:22','600','2022-04-23 21:11:45',10,0),('5','105',257566,'DAILY','2022-04-23','2022-04-24 11:41:31','2022-04-25 11:41:31','641',535459.65,535459.65,'641','2022-04-24 15:36:14','600','2022-04-24 15:37:25',10,0),('5','105',257567,'DAILY','2022-04-24','2022-04-25 10:04:36','2022-04-26 10:04:36','641',768982.50,768982.50,'641','2022-04-25 10:05:57','600','2022-04-25 11:35:56',10,0),('5','105',257568,'DAILY','2022-04-25','2022-04-25 23:10:46','2022-04-26 23:10:46','641',700647.75,700647.75,'641','2022-04-26 10:12:12','600','2022-04-26 10:13:55',10,0),('5','105',257569,'DAILY','2022-04-26','2022-04-27 18:04:05','2022-04-28 18:04:05','641',239581.65,239581.65,'641','2022-04-28 05:04:29','600','2022-04-28 12:50:12',10,0),('5','105',257570,'DAILY','2022-04-27','2022-04-28 17:18:07','2022-04-29 17:18:07','641',0.00,0.00,'641','2022-04-28 17:18:30','600','2022-04-28 21:10:34',10,0),('5','105',257571,'DAILY','2022-04-28','2022-04-29 08:58:23','2022-04-30 08:58:23','641',315169.80,315169.80,'641','2022-04-29 16:10:30','600','2022-04-29 16:11:51',10,0),('5','105',257572,'DAILY','2022-04-29','2022-05-09 13:54:40','2022-05-10 13:54:40','641',1239562.50,1239562.50,'641','2022-05-09 14:00:10','600','2022-05-09 14:01:12',10,0),('5','105',257573,'DAILY','2022-04-30','2022-05-09 14:06:36','2022-05-10 14:06:36','641',1110649.65,1110649.65,'641','2022-05-09 14:07:59','600','2022-05-09 14:12:55',10,0),('5','105',257574,'DAILY','2022-05-01','2022-05-09 14:14:23','2022-05-10 14:14:23','641',994463.25,994463.25,'641','2022-05-09 14:15:13','600','2022-05-09 14:20:06',10,0),('5','105',257575,'DAILY','2022-05-02','2022-05-09 14:26:05','2022-05-10 14:26:05','641',881713.80,881713.80,'641','2022-05-09 14:27:18','600','2022-05-09 14:27:47',10,0),('5','105',257576,'DAILY','2022-05-03','2022-05-09 14:30:19','2022-05-10 14:30:19','641',888477.15,888477.15,'641','2022-05-09 14:31:45','600','2022-05-09 14:40:55',10,0),('5','105',257577,'DAILY','2022-05-04','2022-05-09 14:59:32','2022-05-10 14:59:32','641',827427.15,827427.15,'641','2022-05-09 15:01:32','600','2022-05-09 15:05:19',10,0),('5','105',257578,'DAILY','2022-05-05','2022-05-09 15:07:27','2022-05-10 15:07:27','641',379500.00,379500.00,'641','2022-05-09 15:08:06','600','2022-05-09 15:09:04',10,0),('5','105',257579,'DAILY','2022-05-06','2022-05-09 15:10:22','2022-05-10 15:10:22','641',0.00,0.00,'641','2022-05-09 15:10:40','600','2022-05-09 15:11:11',10,0),('5','105',257580,'DAILY','2022-05-07','2022-05-09 15:13:42','2022-05-10 15:13:42','641',0.00,0.00,'641','2022-05-09 15:14:00','600','2022-05-09 15:14:51',10,0),('5','105',257581,'DAILY','2022-05-08','2022-05-09 15:17:37','2022-05-10 15:17:37','641',1332533.40,1332533.40,'641','2022-05-09 15:18:54','600','2022-05-09 15:21:01',10,0),('5','105',257582,'DAILY','2022-05-09','2022-05-09 15:24:49','2022-05-10 15:24:49','641',1322428.80,1322428.80,'641','2022-05-10 11:58:48','600','2022-05-10 12:02:32',10,0),('5','105',257583,'DAILY','2022-05-10','2022-05-10 12:04:28','2022-05-11 12:04:28','641',1171589.10,1171589.10,'641','2022-05-11 05:28:47','600','2022-05-11 09:20:20',10,0),('5','105',257584,'DAILY','2022-05-11','2022-05-11 20:14:27','2022-05-12 20:14:27','641',1195256.70,1195256.70,'641','2022-05-11 20:16:42','600','2022-05-12 12:55:55',10,0),('5','105',257585,'DAILY','2022-05-12','2022-05-12 15:11:45','2022-05-13 15:11:45','641',1052653.80,1052653.80,'641','2022-05-13 08:10:00','600','2022-05-13 11:32:31',10,0),('5','105',257586,'DAILY','2022-05-13','2022-05-14 07:53:58','2022-05-15 07:53:58','641',1006080.90,1006080.90,'641','2022-05-15 10:46:04','600','2022-05-16 09:56:39',10,0),('5','105',257587,'DAILY','2022-05-14','2022-05-16 15:41:48','2022-05-17 15:41:48','641',1081116.30,1081116.30,'641','2022-05-16 15:44:31','600','2022-05-16 15:45:16',10,0),('5','105',257588,'DAILY','2022-05-15','2022-05-16 15:49:32','2022-05-17 15:49:32','641',1171450.50,1171450.50,'641','2022-05-16 15:51:13','600','2022-05-16 15:52:25',10,0),('5','105',257589,'DAILY','2022-05-16','2022-05-16 15:54:32','2022-05-17 15:54:32','641',511323.45,511323.45,'641','2022-05-17 05:17:33','600','2022-05-17 06:05:17',10,0),('5','105',257590,'DAILY','2022-05-17','2022-05-17 18:21:26','2022-05-18 18:21:26','641',868475.85,868475.85,'641','2022-05-18 12:17:12','600','2022-05-18 12:21:06',10,0),('5','105',257591,'DAILY','2022-05-18','2022-05-19 06:20:50','2022-05-20 06:20:50','641',690510.15,690510.15,'641','2022-05-19 06:22:32','600','2022-05-19 08:22:19',10,0),('5','105',257592,'DAILY','2022-05-19','2022-05-19 15:40:46','2022-05-20 15:40:46','641',658957.20,658957.20,'641','2022-05-20 05:28:20','600','2022-05-20 06:07:18',10,0),('5','105',257593,'DAILY','2022-05-20','2022-05-21 08:08:38','2022-05-22 08:08:38','641',338250.00,338250.00,'641','2022-05-21 08:10:47','600','2022-05-21 09:43:07',10,0),('5','105',257594,'DAILY','2022-05-21','2022-05-21 21:01:15','2022-05-22 21:01:15','641',280460.40,280460.40,'641','2022-05-23 09:58:38','600','2022-05-23 10:01:05',10,0),('5','105',257595,'DAILY','2022-05-22','2022-05-23 10:01:54','2022-05-24 10:01:54','641',711362.85,711362.85,'641','2022-05-23 10:04:46','600','2022-05-23 10:10:21',10,0),('5','105',257596,'DAILY','2022-05-23','2022-05-23 19:41:57','2022-05-24 19:41:57','641',692981.85,692981.85,'641','2022-05-24 05:20:21','600','2022-05-24 07:56:50',10,0),('5','105',257597,'DAILY','2022-05-24','2022-05-24 12:04:50','2022-05-25 12:04:50','641',947705.55,947705.55,'641','2022-05-25 12:48:57','600','2022-05-25 16:16:58',10,0),('5','105',257598,'DAILY','2022-05-25','2022-05-25 16:21:40','2022-05-26 16:21:40','641',698910.30,698910.30,'641','2022-05-26 10:24:41','600','2022-05-26 10:34:48',10,0),('5','105',257599,'DAILY','2022-05-26','2022-05-27 05:16:17','2022-05-28 05:16:17','641',720071.55,720071.55,'641','2022-05-27 05:19:30','600','2022-05-27 05:21:21',10,0),('5','105',257600,'DAILY','2022-05-27','2022-05-27 05:24:23','2022-05-28 05:24:23','641',687233.25,687233.25,'641','2022-05-28 10:43:30','600','2022-05-28 11:47:27',10,0),('5','105',257601,'DAILY','2022-05-28','2022-05-28 23:25:39','2022-05-29 23:25:39','641',743478.45,743478.45,'641','2022-05-28 23:26:28','600','2022-05-29 08:11:20',10,0),('5','105',257602,'DAILY','2022-05-29','2022-05-30 09:54:49','2022-05-31 09:54:49','641',704385.00,704385.00,'641','2022-05-30 10:20:46','600','2022-05-30 10:26:24',10,0),('5','105',257603,'DAILY','2022-05-30','2022-05-30 10:28:01','2022-05-31 10:28:01','641',794224.20,794224.20,'641','2022-05-31 09:07:50','600','2022-05-31 22:56:34',10,0),('5','105',257604,'DAILY','2022-05-31','2022-06-01 09:39:12','2022-06-02 09:39:12','641',445542.90,445542.90,'641','2022-06-02 13:36:32','600','2022-06-02 16:11:44',10,0),('5','105',257605,'DAILY','2022-06-01','2022-06-02 18:52:31','2022-06-03 18:52:31','641',0.00,0.00,'641','2022-06-02 18:53:16','600','2022-06-03 09:26:25',10,0),('5','105',257606,'DAILY','2022-06-02','2022-06-03 19:26:53','2022-06-04 19:26:53','641',0.00,0.00,'641','2022-06-03 19:27:10','600','2022-06-04 09:22:22',10,0),('5','105',257607,'DAILY','2022-06-03','2022-06-04 17:07:51','2022-06-05 17:07:51','641',0.00,0.00,'641','2022-06-04 17:08:14','600','2022-06-05 05:32:36',10,0),('5','105',257608,'DAILY','2022-06-04','2022-06-05 15:48:30','2022-06-06 15:48:30','641',383813.10,383813.10,'641','2022-06-05 21:16:58','600','2022-06-06 09:48:15',10,0),('5','105',257609,'DAILY','2022-06-05','2022-06-06 11:48:21','2022-06-07 11:48:21','641',679644.90,679644.90,'641','2022-06-06 11:52:21','600','2022-06-06 12:08:14',10,0),('5','105',257610,'DAILY','2022-06-06','2022-06-06 20:48:50','2022-06-07 20:48:50','641',691191.60,691191.60,'641','2022-06-06 20:51:52','600','2022-06-07 09:05:53',10,0),('5','105',257611,'DAILY','2022-06-07','2022-06-07 13:18:22','2022-06-08 13:18:22','641',500963.10,500963.10,'641','2022-06-08 05:26:58','600','2022-06-08 09:45:23',10,0),('5','105',257612,'DAILY','2022-06-08','2022-06-08 17:45:40','2022-06-09 17:45:40','641',208474.20,208474.20,'641','2022-06-09 08:42:23','600','2022-06-09 11:13:35',10,0),('5','105',257613,'DAILY','2022-06-09','2022-06-10 05:37:43','2022-06-11 05:37:43','641',0.00,0.00,'641','2022-06-10 05:38:34','600','2022-06-10 09:20:45',10,0),('5','105',257614,'DAILY','2022-06-10','2022-06-11 07:10:36','2022-06-12 07:10:36','641',0.00,0.00,'641','2022-06-11 07:11:07','600','2022-06-11 09:28:53',10,0),('5','105',257615,'DAILY59','2022-06-11','2022-06-11 22:57:14','2022-06-12 22:57:14','641',0.00,0.00,'641','2022-06-11 22:58:26','600','2022-06-12 09:54:01',10,0),('5','105',257616,'DAILY','2022-06-12','2022-06-12 19:50:56','2022-06-13 19:50:56','641',0.00,0.00,'641','2022-06-12 19:52:12','600','2022-06-13 09:29:49',10,0),('5','105',257617,'DAILY','2022-06-13','2022-06-13 21:07:58','2022-06-14 21:07:58','641',0.00,0.00,'641','2022-06-13 21:09:05','600','2022-06-14 10:47:06',10,0),('5','105',257618,'DAILY','2022-06-14','2022-06-14 22:06:42','2022-06-15 22:06:42','641',0.00,0.00,'641','2022-06-14 22:07:26','600','2022-06-15 09:23:45',10,0),('5','105',257619,'DAILY','2022-06-15','2022-06-15 22:22:08','2022-06-16 22:22:08','641',0.00,0.00,'641','2022-06-15 22:22:46','600','2022-06-16 09:16:03',10,0),('5','105',257620,'DAILY','2022-06-16','2022-06-16 19:32:20','2022-06-17 19:32:20','641',0.00,0.00,'641','2022-06-16 19:33:17','600','2022-06-17 09:55:54',10,0),('5','105',257621,'DAILY','2022-06-17','2022-06-17 14:22:19','2022-06-18 14:22:19','641',264085.80,264085.80,'641','2022-06-18 11:11:38','600','2022-06-18 11:12:18',10,0),('5','105',257622,'DAILY','2022-06-18','2022-06-18 11:14:28','2022-06-19 11:14:28','641',678516.30,678516.30,'641','2022-06-19 10:27:20','600','2022-06-19 13:40:25',10,0),('5','105',257623,'DAILY','2022-06-19','2022-06-20 05:11:14','2022-06-21 05:11:14','641',662428.80,662428.80,'641','2022-06-20 05:13:43','600','2022-06-20 09:56:56',10,0),('5','105',257624,'DAILY','2022-06-20','2022-06-20 18:22:42','2022-06-21 18:22:42','641',562008.15,562008.15,'641','2022-06-21 12:58:48','600','2022-06-22 09:30:52',10,0),('5','105',257625,'DAILY','2022-06-21','2022-06-22 11:05:13','2022-06-23 11:05:13','641',289490.85,289490.85,'641','2022-06-22 11:06:52','600','2022-06-22 14:18:41',10,0),('5','105',257626,'DAILY','2022-06-22','2022-06-23 05:17:00','2022-06-24 05:17:00','641',0.00,0.00,'641','2022-06-23 05:17:48','600','2022-06-23 09:59:10',10,0),('5','105',257627,'DAILY','2022-06-23','2022-06-25 11:40:08','2022-06-26 11:40:08','641',0.00,0.00,'641','2022-06-25 11:40:40','600','2022-06-25 14:03:05',10,0),('5','105',257628,'DAILY','2022-06-24','2022-06-25 17:41:27','2022-06-26 17:41:27','641',0.00,0.00,'641','2022-06-25 17:41:47','600','2022-06-26 12:14:01',10,0),('5','105',257629,'DAILY','2022-06-25','2022-06-26 15:18:15','2022-06-27 15:18:15','641',0.00,0.00,'641','2022-06-26 15:18:37','600','2022-06-26 16:44:22',10,0),('5','105',257630,'DAILY','2022-06-26','2022-06-27 08:09:07','2022-06-28 08:09:07','641',0.00,0.00,'641','2022-06-27 08:09:28','600','2022-06-27 10:23:42',10,0),('5','105',257631,'DAILY','2022-06-27','2022-06-28 10:23:51','2022-06-29 10:23:51','641',0.00,0.00,'641','2022-06-28 10:24:30','600','2022-06-29 09:06:36',10,0),('5','105',257632,'DAILY','2022-06-28','2022-06-29 16:11:28','2022-06-30 16:11:28','641',0.00,0.00,'641','2022-06-29 16:11:55','600','2022-06-29 16:22:42',10,0),('5','105',257633,'DAILY','2022-06-29','2022-06-29 19:27:29','2022-06-30 19:27:29','641',0.00,0.00,'641','2022-06-29 19:28:08','600','2022-06-30 08:29:04',10,0),('5','105',257634,'DAILY','2022-06-30','2022-06-30 19:50:32','2022-07-01 19:50:32','641',0.00,0.00,'641','2022-06-30 19:51:10','600','2022-07-01 09:53:13',10,0),('5','105',257635,'DAILY','2022-07-01','2022-07-01 20:40:16','2022-07-02 20:40:16','641',0.00,0.00,'641','2022-07-01 20:40:39','600','2022-07-02 13:38:52',10,0),('5','105',257636,'DAILY','2022-07-02','2022-07-03 05:20:09','2022-07-04 05:20:09','641',0.00,0.00,'641','2022-07-03 05:20:46','600','2022-07-03 09:35:53',10,0),('5','105',257637,'DAILY','2022-07-03','2022-07-04 20:14:48','2022-07-05 20:14:48','641',0.00,0.00,'641','2022-07-04 20:15:09','600','2022-07-05 09:15:30',10,0),('5','105',257638,'DAILY','2022-07-04','2022-07-05 23:29:24','2022-07-06 23:29:24','641',0.00,0.00,'641','2022-07-05 23:29:54','600','2022-07-06 09:13:48',10,0),('5','105',257639,'DAILY','2022-07-05','2022-07-06 09:58:29','2022-07-07 09:58:29','641',398537.70,398537.70,'641','2022-07-06 11:11:18','600','2022-07-07 10:37:51',10,0),('5','105',257640,'DAILY','2022-07-06','2022-07-07 14:29:18','2022-07-08 14:29:18','641',644933.85,644933.85,'641','2022-07-07 14:35:14','600','2022-07-07 14:42:21',10,0),('5','105',257641,'DAILY','2022-07-07','2022-07-07 16:13:18','2022-07-08 16:13:18','641',674234.55,674234.55,'641','2022-07-08 08:04:13','600','2022-07-08 08:56:01',10,0),('5','105',257642,'DAILY','2022-07-08','2022-07-09 19:07:54','2022-07-10 19:07:54','641',397409.10,397409.10,'641','2022-07-09 19:11:27','600','2022-07-09 21:28:58',10,0),('5','105',257643,'DAILY','2022-07-09','2022-07-11 05:22:53','2022-07-12 05:22:53','641',0.00,0.00,'641','2022-07-11 05:23:23','600','2022-07-11 08:23:00',10,0),('5','105',257644,'DAILY','2022-07-10','2022-07-11 19:55:58','2022-07-12 19:55:58','641',0.00,0.00,'641','2022-07-11 19:56:21','600','2022-07-12 10:52:22',10,0),('5','105',257645,'DAILY','2022-07-11','2022-07-12 17:33:26','2022-07-13 17:33:26','641',0.00,0.00,'641','2022-07-12 17:33:42','600','2022-07-13 09:31:26',10,0),('5','105',257646,'DAILY','2022-07-12','2022-07-13 14:20:18','2022-07-14 14:20:18','641',452410.10,403500.90,'641','2022-07-13 14:22:14','600','2022-07-13 14:33:50',10,0),('5','105',257647,'DAILY','2022-07-13','2022-07-13 20:09:31','2022-07-14 20:09:31','641',878938.70,878938.70,'641','2022-07-14 05:47:12','600','2022-07-14 09:47:23',10,0),('5','105',257648,'DAILY','2022-07-14','2022-07-15 06:59:26','2022-07-16 06:59:26','641',1323782.30,1323782.30,'641','2022-07-15 12:09:05','600','2022-07-15 12:13:52',10,0),('5','105',257649,'DAILY','2022-07-15','2022-07-16 09:00:52','2022-07-17 09:00:52','641',1112854.55,1112854.55,'641','2022-07-16 09:02:26','600','2022-07-16 09:54:21',10,0),('5','105',257650,'DAILY','2022-07-16','2022-07-17 11:58:43','2022-07-18 11:58:43','641',1307206.30,1307206.30,'641','2022-07-17 11:59:43','600','2022-07-18 07:31:24',10,0),('5','105',257651,'DAILY','2022-07-17','2022-07-18 09:00:33','2022-07-19 09:00:33','641',1162828.60,1162828.60,'641','2022-07-18 09:02:28','600','2022-07-18 09:10:55',10,0),('5','105',257652,'DAILY','2022-07-18','2022-07-18 09:12:53','2022-07-19 09:12:53','641',1160062.85,1160062.85,'641','2022-07-19 10:40:51','600','2022-07-19 13:53:20',10,0),('5','105',257653,'DAILY','2022-07-19','2022-07-20 11:19:21','2022-07-21 11:19:21','641',981867.15,981867.15,'641','2022-07-20 11:22:53','600','2022-07-20 14:05:57',10,0),('5','105',257654,'DAILY','2022-07-20','2022-07-20 14:31:45','2022-07-21 14:31:45','641',1301957.85,1301957.85,'641','2022-07-21 11:09:52','600','2022-07-21 14:32:36',10,0),('5','105',257655,'DAILY','2022-07-21','2022-07-21 15:21:04','2022-07-22 15:21:04','641',1311999.65,1311999.65,'641','2022-07-21 19:19:32','600','2022-07-21 19:46:50',10,0),('5','105',257656,'DAILY','2022-07-22','2022-07-22 10:23:16','2022-07-23 10:23:16','641',1437701.60,1437701.60,'641','2022-07-23 05:32:59','600','2022-07-23 10:33:42',10,0),('5','105',257657,'DAILY','2022-07-23','2022-07-24 08:34:19','2022-07-25 08:34:19','641',1622810.75,1622810.75,'641','2022-07-24 08:37:12','600','2022-07-24 09:27:35',10,0),('5','105',257658,'DAILY','2022-07-24','2022-07-25 10:34:19','2022-07-26 10:34:19','641',1115601.80,1115601.80,'641','2022-07-25 10:35:37','600','2022-07-25 11:11:36',10,0),('5','105',257659,'DAILY','2022-07-25','2022-07-26 09:32:40','2022-07-27 09:32:40','641',753773.25,753773.25,'641','2022-07-26 09:34:44','600','2022-07-26 10:04:42',10,0),('5','105',257660,'DAILY','2022-07-26','2022-07-27 12:04:47','2022-07-28 12:04:47','641',759291.80,759291.80,'641','2022-07-27 12:06:41','600','2022-07-27 14:15:55',10,0),('5','105',257661,'DAILY','2022-07-27','2022-07-28 11:49:23','2022-07-29 11:49:23','641',583149.60,583149.60,'641','2022-07-28 11:51:13','600','2022-07-28 16:11:24',10,0),('5','105',257662,'DAILY','2022-07-28','2022-07-28 18:26:41','2022-07-29 18:26:41','641',615298.90,615298.90,'641','2022-07-29 09:07:16','600','2022-07-29 09:14:07',10,0),('5','105',257663,'DAILY','2022-07-29','2022-07-29 12:05:48','2022-07-30 12:05:48','641',259001.85,259001.85,'641','2022-07-30 19:59:14','600','2022-07-30 20:07:46',10,0),('5','105',257664,'DAILY','2022-07-30','2022-07-31 09:37:43','2022-08-01 09:37:43','641',0.00,0.00,'641','2022-07-31 09:38:28','600','2022-07-31 10:15:12',10,0),('5','105',257665,'DAILY','2022-07-31','2022-08-01 08:53:42','2022-08-02 08:53:42','641',0.00,0.00,'641','2022-08-01 08:54:04','600','2022-08-02 11:14:38',10,0),('5','105',257666,'DAILY','2022-08-01','2022-08-02 11:24:28','2022-08-03 11:24:28','641',395764.95,395764.95,'641','2022-08-02 12:15:24','600','2022-08-02 12:18:34',10,0),('5','105',257667,'DAILY','2022-08-02','2022-08-02 20:21:52','2022-08-03 20:21:52','641',1029149.45,1029149.45,'641','2022-08-03 10:01:53','600','2022-08-03 10:05:12',10,0),('5','105',257668,'DAILY','2022-08-03','2022-08-04 05:42:16','2022-08-05 05:42:16','641',941766.55,941766.55,'641','2022-08-04 05:44:20','600','2022-08-04 08:19:11',10,0),('5','105',257669,'DAILY','2022-08-04','2022-08-04 12:37:01','2022-08-05 12:37:01','641',1087141.40,1087141.40,'641','2022-08-05 11:21:20','600','2022-08-05 13:50:59',10,0),('5','105',257670,'DAILY','2022-08-05','2022-08-06 10:51:13','2022-08-07 10:51:13','641',934031.70,934031.70,'641','2022-08-06 10:52:18','600','2022-08-07 09:59:55',10,0),('5','105',257671,'DAILY','2022-08-06','2022-08-07 13:45:17','2022-08-08 13:45:17','641',744031.15,744031.15,'641','2022-08-07 13:47:05','600','2022-08-07 13:49:53',10,0),('5','105',257672,'DAILY','2022-08-07','2022-08-07 19:13:42','2022-08-08 19:13:42','641',791727.85,791727.85,'641','2022-09-03 05:18:08','600','2022-09-03 09:29:54',10,0),('5','105',257673,'DAILY','2022-08-08','2022-09-03 10:47:07','2022-09-04 10:47:07','641',764397.80,764397.80,'641','2022-09-03 10:49:33','600','2022-09-03 11:53:37',10,0),('5','105',257674,'DAILY','2022-08-09','2022-09-03 11:56:57','2022-09-04 11:56:57','641',562523.95,562523.95,'641','2022-09-03 11:58:03','600','2022-09-03 12:09:01',10,0),('5','105',257675,'DAILY','2022-08-10','2022-09-03 12:13:56','2022-09-04 12:13:56','641',927960.00,927960.00,'641','2022-09-03 12:21:32','600','2022-09-03 12:23:07',10,0),('5','105',257676,'DAILY','2022-08-11','2022-09-03 12:28:43','2022-09-04 12:28:43','641',800643.00,800643.00,'641','2022-09-03 12:29:38','600','2022-09-03 13:34:44',10,0),('5','105',257677,'DAILY','2022-08-11','2022-09-03 13:49:17','2022-09-04 13:49:17','641',929027.45,929027.45,'641','2022-09-03 13:54:06','600','2022-09-03 13:55:12',10,0),('5','105',257678,'DAILY','2022-08-13','2022-09-03 13:57:41','2022-09-04 13:57:41','641',1028065.35,1028065.35,'641','2022-09-03 13:59:34','600','2022-09-03 14:00:52',10,0),('5','105',257679,'DAILY','2022-08-14','2022-09-03 14:02:50','2022-09-04 14:02:50','641',983608.00,983608.00,'641','2022-09-03 14:04:13','600','2022-09-03 14:08:58',10,0),('5','105',257680,'DAILY','2022-08-15','2022-09-03 14:09:48','2022-09-04 14:09:48','641',991050.55,991050.55,'641','2022-09-03 14:12:06','600','2022-09-03 14:13:15',10,0),('5','105',257681,'DAILY','2022-08-16','2022-09-03 14:20:12','2022-09-04 14:20:12','641',1076472.45,1076472.45,'641','2022-09-03 15:34:39','600','2022-09-03 16:57:53',10,0),('5','105',257682,'DAILY','2022-08-17','2022-09-03 18:24:44','2022-09-04 18:24:44','641',1173170.10,1173170.10,'641','2022-09-04 08:56:12','600','2022-09-04 10:09:01',10,0),('5','105',257683,'DAILY','2022-08-18','2022-09-04 10:56:20','2022-09-05 10:56:20','641',1299292.00,1299292.00,'641','2022-09-04 10:58:39','600','2022-09-04 10:59:37',10,0),('5','105',257684,'DAILY','2022-08-19','2022-09-04 11:28:53','2022-09-05 11:28:53','641',752765.00,752765.00,'641','2022-09-04 11:30:42','600','2022-09-04 11:50:23',10,0),('5','105',257685,'DAILY','2022-08-20','2022-09-04 12:04:36','2022-09-05 12:04:36','641',940704.65,940704.65,'641','2022-09-04 12:21:35','600','2022-09-05 10:24:48',10,0),('5','105',257686,'DAILY','2022-08-21','2022-09-05 11:25:20','2022-09-06 11:25:20','641',1014018.30,1014018.30,'641','2022-09-05 11:27:31','600','2022-09-05 11:35:35',10,0),('5','105',257687,'DAILY','2022-08-22','2022-09-05 11:39:39','2022-09-06 11:39:39','641',1077902.50,1077902.50,'641','2022-09-05 11:46:44','600','2022-09-05 11:48:41',10,0),('5','105',257688,'DAILY','2022-08-23','2022-09-05 11:53:01','2022-09-06 11:53:01','641',937953.70,937953.70,'641','2022-09-05 11:54:39','600','2022-09-05 11:55:32',10,0),('5','105',257689,'DAILY','2022-08-24','2022-09-05 11:56:42','2022-09-06 11:56:42','641',1374231.80,1374231.80,'641','2022-09-05 11:58:48','600','2022-09-05 12:01:30',10,0),('5','105',257690,'DAILY','2022-08-25','2022-09-05 12:05:52','2022-09-06 12:05:52','641',1217755.10,1217755.10,'641','2022-09-05 12:08:32','600','2022-09-05 12:09:32',10,0),('5','105',257691,'DAILY','2022-08-26','2022-09-05 12:10:53','2022-09-06 12:10:53','641',1296348.65,1296348.65,'641','2022-09-05 12:12:08','600','2022-09-05 12:12:49',10,0),('5','105',257692,'DAILY','2022-08-27','2022-09-05 12:15:15','2022-09-06 12:15:15','641',1152710.95,1152710.95,'641','2022-09-05 12:21:47','600','2022-09-05 12:29:27',10,0),('5','105',257693,'DAILY','2022-08-28','2022-09-05 12:32:03','2022-09-06 12:32:03','641',1267298.10,1267298.10,'641','2022-09-05 12:35:07','600','2022-09-05 12:36:34',10,0),('5','105',257694,'DAILY','2022-08-29','2022-09-05 13:39:59','2022-09-06 13:39:59','641',1255757.80,1255757.80,'641','2022-09-05 13:41:17','600','2022-09-05 13:45:20',10,0),('5','105',257695,'DAILY','2022-08-30','2022-09-05 15:36:27','2022-09-06 15:36:27','641',1331136.05,1331136.05,'641','2022-09-05 15:39:02','600','2022-09-05 15:40:43',10,0),('5','105',257696,'DAILY','2022-08-31','2022-09-05 15:43:31','2022-09-06 15:43:31','641',1378706.95,1378706.95,'641','2022-09-05 15:45:19','600','2022-09-05 16:03:59',10,0),('5','105',257697,'DAILY','2022-09-01','2022-09-05 16:13:46','2022-09-06 16:13:46','641',1381864.90,1381864.90,'641','2022-09-05 16:14:47','600','2022-09-05 16:15:45',10,0),('5','105',257698,'DAILY','2022-09-02','2022-09-05 16:17:33','2022-09-06 16:17:33','641',1301634.10,1301634.10,'641','2022-09-05 16:18:42','600','2022-09-05 16:46:48',10,0),('5','105',257699,'DAILY','2022-09-03','2022-09-05 16:51:24','2022-09-06 16:51:24','641',1297060.90,1297060.90,'641','2022-09-05 16:52:32','600','2022-09-05 17:46:30',10,0),('5','105',257700,'DAILY','2022-09-04','2022-09-05 18:25:53','2022-09-06 18:25:53','641',1489466.45,1489466.45,'641','2022-09-05 18:31:45','600','2022-09-05 19:07:16',10,0),('5','105',257701,'DAILY','2022-09-05','2022-09-05 19:15:46','2022-09-06 19:15:46','641',1496119.05,1496119.05,'641','2022-09-06 05:57:33','600','2022-09-06 08:27:08',10,0),('5','105',257702,'DAILY','2022-09-06','2022-09-06 09:10:43','2022-09-07 09:10:43','641',1621186.45,1621186.45,'641','2022-09-07 11:14:03','600','2022-09-07 12:02:34',10,0),('5','105',257703,'DAILY','2022-09-07','2022-09-08 06:55:54','2022-09-09 06:55:54','641',1388826.45,1388826.45,'641','2022-09-08 06:57:51','600','2022-09-08 08:53:27',10,0),('5','105',257704,'DAILY','2022-09-08','2022-09-08 18:19:59','2022-09-09 18:19:59','641',1114181.00,1114181.00,'641','2022-09-09 06:51:29','600','2022-09-09 09:14:54',10,0),('5','105',257705,'DAILY','2022-09-09','2022-09-10 07:02:54','2022-09-11 07:02:54','641',976365.25,976365.25,'641','2022-09-10 07:04:02','600','2022-09-10 09:40:32',10,0),('5','105',257706,'DAILY','2022-09-10','2022-09-12 08:11:54','2022-09-13 08:11:54','641',1148422.65,1148422.65,'641','2022-09-12 08:13:26','600','2022-09-13 10:24:00',10,0),('5','105',257707,'DAILY','2022-09-11','2022-09-13 10:29:43','2022-09-14 10:29:43','641',416675.50,416675.50,'641','2022-09-13 10:32:18','600','2022-09-13 10:55:41',10,0),('5','105',257708,'DAILY','2022-09-12','2022-09-13 11:18:38','2022-09-14 11:18:38','641',0.00,0.00,'641','2022-09-13 11:18:57','600','2022-09-13 11:25:53',10,0),('5','105',257709,'DAILY','2022-09-13','2022-09-14 12:47:09','2022-09-15 12:47:09','641',0.00,0.00,'641','2022-09-14 12:47:30','600','2022-09-14 16:13:54',10,0),('5','105',257710,'DAILY','2022-09-14','2022-09-15 17:27:34','2022-09-16 17:27:34','641',0.00,0.00,'641','2022-09-15 17:27:52','600','2022-09-16 10:17:17',10,0),('5','105',257711,'DAILY','2022-09-15','2022-09-16 13:54:30','2022-09-17 13:54:30','641',393026.95,393026.95,'641','2022-09-16 13:55:47','600','2022-09-17 08:18:48',10,0),('5','105',257712,'DAILY','2022-09-16','2022-09-17 17:13:43','2022-09-18 17:13:43','641',928670.40,928670.40,'641','2022-09-17 17:14:39','600','2022-09-18 08:25:05',10,0),('5','105',257713,'DAILY','2022-09-17','2022-09-18 09:09:08','2022-09-19 09:09:08','641',1334712.10,1334712.10,'641','2022-09-18 09:11:21','600','2022-09-18 14:56:42',10,0),('5','105',257714,'DAILY','2022-09-18','2022-09-19 07:23:41','2022-09-20 07:23:41','641',1236972.90,1236972.90,'641','2022-09-19 07:24:37','600','2022-09-19 08:01:28',10,0),('5','105',257715,'DAILY','2022-09-19','2022-09-19 10:33:50','2022-09-20 10:33:50','641',1297495.65,1297495.65,'641','2022-09-20 17:27:53','600','2022-09-20 17:32:16',10,0),('5','105',257716,'DAILY','2022-09-20','2022-09-21 05:40:53','2022-09-22 05:40:53','641',943916.25,943916.25,'641','2022-09-21 05:49:18','600','2022-09-21 06:08:16',10,0),('5','105',257717,'DAILY','2022-09-21','2022-09-21 22:36:54','2022-09-22 22:36:54','641',1143466.50,1143466.50,'641','2022-09-21 22:38:33','600','2022-09-22 08:42:54',10,0),('5','105',257718,'DAILY','2022-09-22','2022-09-22 10:22:31','2022-09-23 10:22:31','641',1265912.45,1265912.45,'641','2022-09-23 13:47:37','600','2022-09-23 14:42:12',10,0),('5','105',257719,'DAILY','2022-09-23','2022-09-23 19:19:50','2022-09-24 19:19:50','641',1356647.55,1356647.55,'641','2022-09-24 05:36:36','600','2022-09-24 05:55:45',10,0),('5','105',257720,'DAILY','2022-09-24','2022-09-25 19:21:12','2022-09-26 19:21:12','641',1192855.95,1192855.95,'641','2022-09-25 19:23:37','600','2022-09-26 08:24:34',10,0),('5','105',257721,'DAILY','2022-09-25','2022-09-26 08:54:41','2022-09-27 08:54:41','641',1597658.15,1597658.15,'641','2022-09-26 08:56:41','600','2022-09-26 09:46:37',10,0),('5','105',257722,'DAILY','2022-09-26','2022-09-26 12:42:43','2022-09-27 12:42:43','641',1436880.20,1436880.20,'641','2022-09-27 12:20:28','600','2022-09-28 10:01:31',10,0),('5','105',257723,'DAILY','2022-09-27','2022-09-28 11:56:46','2022-09-29 11:56:46','641',1436663.75,1436663.75,'641','2022-09-28 11:58:12','600','2022-09-28 16:35:44',10,0),('5','105',257724,'DAILY','2022-09-28','2022-09-29 05:57:37','2022-09-30 05:57:37','641',1490437.70,1490437.70,'641','2022-09-29 06:08:38','600','2022-09-29 06:15:46',10,0),('5','105',257725,'DAILY','2022-09-29','2022-09-29 10:16:47','2022-09-30 10:16:47','641',1357480.05,1357480.05,'641','2022-09-30 11:35:56','600','2022-09-30 14:48:51',10,0),('5','105',257726,'DAILY','2022-09-30','2022-10-01 07:55:07','2022-10-02 07:55:07','641',1344507.85,1344507.85,'641','2022-10-01 07:56:19','600','2022-10-01 10:21:59',10,0),('5','105',257727,'DAILY','2022-10-01','2022-10-02 09:27:50','2022-10-03 09:27:50','641',1585085.55,1585085.55,'641','2022-10-02 09:29:09','600','2022-10-02 10:07:54',10,0),('5','105',257728,'DAILY','2022-10-02','2022-10-03 06:30:49','2022-10-04 06:30:49','641',1448316.90,1448316.90,'641','2022-10-03 06:42:04','600','2022-10-03 09:34:19',10,0),('5','105',257729,'DAILY','2022-10-03','2022-10-03 21:42:51','2022-10-04 21:42:51','641',1371162.65,1371162.65,'641','2022-10-03 21:44:21','600','2022-10-04 09:06:38',10,0),('5','105',257730,'DAILY','2022-10-04','2022-10-04 14:21:56','2022-10-05 14:21:56','641',1579104.50,1579104.50,'641','2022-10-05 07:39:17','600','2022-10-05 08:09:31',10,0),('5','105',257731,'DAILY','2022-10-05','2022-10-06 11:04:35','2022-10-07 11:04:35','641',1227021.75,1227021.75,'641','2022-10-06 11:43:23','600','2022-10-06 13:32:10',10,0),('5','105',257732,'DAILY','2022-10-06','2022-10-07 10:02:29','2022-10-08 10:02:29','641',1405637.40,1405637.40,'641','2022-10-07 10:50:02','600','2022-10-08 08:12:14',10,0),('5','105',257733,'DAILY','2022-10-07','2022-10-08 12:55:45','2022-10-09 12:55:45','641',1330606.95,1330606.95,'641','2022-10-08 12:56:35','600','2022-10-08 18:50:47',10,0),('5','105',257734,'DAILY','2022-10-08','2022-10-09 13:45:54','2022-10-10 13:45:54','641',2865977.45,2865977.45,'641','2022-10-09 14:54:38','600','2022-10-10 10:26:19',10,0),('5','105',257735,'DAILY','2022-10-09','2022-10-11 07:09:14','2022-10-12 07:09:14','641',657995.05,657995.05,'641','2022-10-11 07:10:09','600','2022-10-11 08:30:47',10,0),('5','105',257736,'DAILY','2022-10-10','2022-10-12 10:13:37','2022-10-13 10:13:37','641',0.00,0.00,'641','2022-10-12 10:13:56','600','2022-10-12 16:49:16',10,0),('5','105',257737,'DAILY','2022-10-11','2022-10-12 17:34:11','2022-10-13 17:34:11','641',0.00,0.00,'641','2022-10-12 17:34:30','600','2022-10-12 19:11:06',10,0),('5','105',257738,'DAILY','2022-10-12','2022-10-13 07:45:40','2022-10-14 07:45:40','641',0.00,0.00,'641','2022-10-13 07:46:05','600','2022-10-13 08:18:24',10,0),('5','105',257739,'DAILY ','2022-10-13','2022-10-14 13:07:05','2022-10-15 13:07:05','641',0.00,0.00,'641','2022-10-14 13:07:23','600','2022-10-15 10:27:30',10,0),('5','105',257740,'DAILY','2022-10-14','2022-10-15 10:44:49','2022-10-16 10:44:49','641',0.00,0.00,'641','2022-10-15 10:45:13','600','2022-10-16 09:57:47',10,0),('5','105',257741,'DAILY','2022-10-15','2022-10-16 20:36:23','2022-10-17 20:36:23','641',0.00,0.00,'641','2022-10-16 20:36:46','600','2022-10-17 08:07:13',10,0),('5','105',257742,'DAILY','2022-10-16','2022-10-17 19:25:24','2022-10-18 19:25:24','641',0.00,0.00,'641','2022-10-17 19:33:08','600','2022-10-18 06:37:11',10,0),('5','105',257743,'DAILY','2022-10-17','2022-10-19 05:46:09','2022-10-20 05:46:09','641',0.00,0.00,'641','2022-10-19 05:46:40','600','2022-10-19 05:59:29',10,0),('5','105',257744,'DAILY','2022-10-18','2022-10-19 19:19:06','2022-10-20 19:19:06','641',0.00,0.00,'641','2022-10-19 19:19:31','600','2022-10-20 09:07:47',10,0),('5','105',257745,'DAILY','2022-10-19','2022-10-20 13:34:40','2022-10-21 13:34:40','641',0.00,0.00,'641','2022-10-20 13:35:02','600','2022-10-21 05:59:10',10,0),('5','105',257746,'DAILY','2022-10-20','2022-10-21 07:42:16','2022-10-22 07:42:16','641',0.00,0.00,'641','2022-10-21 07:42:46','600','2022-10-21 20:56:20',10,0),('5','105',257747,'DAILY ','2022-10-21','2022-10-22 07:21:00','2022-10-23 07:21:00','641',0.00,0.00,'641','2022-10-22 07:21:29','600','2022-10-22 09:13:43',10,0),('5','105',257748,'DAILY','2022-10-22','2022-10-23 08:02:30','2022-10-24 08:02:30','641',0.00,0.00,'641','2022-10-23 08:03:16','600','2022-10-24 06:02:02',10,0),('5','105',257749,'DAILY','2022-10-23','2022-10-24 21:47:52','2022-10-25 21:47:52','641',0.00,0.00,'641','2022-10-24 21:48:26','600','2022-10-25 05:55:44',10,0),('5','105',257750,'DAILY','2022-10-24','2022-10-25 17:32:50','2022-10-26 17:32:50','641',0.00,0.00,'641','2022-10-25 17:33:20','600','2022-10-26 06:01:46',10,0),('5','105',257751,'DAILY','2022-10-25','2022-10-27 08:26:35','2022-10-28 08:26:35','641',0.00,0.00,'641','2022-10-27 08:26:55','600','2022-10-27 18:38:46',10,0),('5','105',257752,'DAILY','2022-10-26','2022-10-27 18:48:28','2022-10-28 18:48:28','641',0.00,0.00,'641','2022-10-27 18:48:50','600','2022-10-27 19:24:55',10,0),('5','105',257753,'DAILY','2022-10-27','2022-10-27 22:52:01','2022-10-28 22:52:01','641',322837.95,322837.95,'641','2022-10-29 09:32:01','600','2022-10-29 09:37:08',10,0),('5','105',257754,'DAILY','2022-10-28','2022-10-29 18:58:37','2022-10-30 18:58:37','641',1549715.40,1549715.40,'641','2022-10-29 19:08:45','600','2022-10-30 05:48:12',10,0),('5','105',257755,'DAILY','2022-10-29','2022-10-30 20:50:26','2022-10-31 20:50:26','641',1868594.35,1868594.35,'641','2022-10-30 20:51:22','600','2022-10-31 06:01:33',10,0),('5','105',257756,'DAILY','2022-10-30','2022-10-31 12:21:49','2022-11-01 12:21:49','641',1995521.00,1995521.00,'641','2022-10-31 12:43:19','600','2022-11-01 05:54:30',10,0),('5','105',257757,'DAILY','2022-10-31','2022-11-01 11:52:48','2022-11-02 11:52:48','641',2212385.40,2212385.40,'641','2022-11-01 11:53:56','600','2022-11-01 21:06:23',10,0),('5','105',257758,'DAILY','2022-11-01','2022-11-02 06:19:54','2022-11-03 06:19:54','641',2224134.75,2224134.75,'641','2022-11-02 08:25:48','600','2022-11-02 15:01:06',10,0),('5','105',257759,'DAILY','2022-11-02','2022-11-02 18:20:35','2022-11-03 18:20:35','641',2804799.80,2804799.80,'641','2022-11-02 18:31:45','600','2022-11-03 06:02:46',10,0),('5','105',257760,'DAILY','2022-11-03','2022-11-03 13:54:18','2022-11-04 13:54:18','641',2787805.70,2787805.70,'641','2022-11-05 06:05:48','600','2022-11-05 08:59:37',10,0),('5','105',257761,'DAILY','2022-11-04','2022-11-05 14:58:58','2022-11-06 14:58:58','641',2418728.85,2418728.85,'641','2022-11-05 15:00:44','600','2022-11-05 22:07:57',10,0),('5','105',257762,'DAILY','2022-11-05','2022-11-06 12:16:57','2022-11-07 12:16:57','641',2446697.15,2446697.15,'641','2022-11-06 12:19:14','600','2022-11-06 14:25:54',10,0),('5','105',257763,'DAILY','2022-11-06','2022-11-07 05:54:08','2022-11-08 05:54:08','641',2254570.95,2254570.95,'641','2022-11-07 14:14:24','600','2022-11-08 08:17:31',10,0),('5','105',257764,'DAILY','2022-11-07','2022-11-08 08:21:56','2022-11-09 08:21:56','641',1855949.60,1855949.60,'641','2022-11-08 08:26:53','600','2022-11-09 08:14:15',10,0),('5','105',257765,'DAILY','2022-11-08','2022-11-09 09:55:33','2022-11-10 09:55:33','641',343472.85,343472.85,'641','2022-11-09 10:01:53','600','2022-11-09 15:37:19',10,0),('5','105',257766,'DAILY','2022-11-09','2022-11-10 06:59:03','2022-11-11 06:59:03','641',0.00,0.00,'641','2022-11-10 06:59:24','600','2022-11-10 09:29:02',10,0),('5','105',257767,'DAILY','2022-11-10','2022-11-11 14:36:04','2022-11-12 14:36:04','641',0.00,0.00,'641','2022-11-11 14:36:26','600','2022-11-12 09:28:23',10,0),('5','105',257768,'DAILY','2022-11-11','2022-11-12 18:09:07','2022-11-13 18:09:07','641',0.00,0.00,'641','2022-11-12 18:09:33','600','2022-11-13 06:00:32',10,0),('5','105',257769,'DAILY','2022-11-12','2022-11-13 18:19:36','2022-11-14 18:19:36','641',0.00,0.00,'641','2022-11-13 18:20:26','600','2022-11-14 08:08:11',10,0),('5','105',257770,'DAILY','2022-11-13','2022-11-14 17:10:22','2022-11-15 17:10:22','641',0.00,0.00,'641','2022-11-14 17:10:39','600','2022-11-15 08:23:10',10,0),('5','105',257771,'DAILY','2022-11-14','2022-11-15 12:53:44','2022-11-16 12:53:44','641',0.00,0.00,'641','2022-11-15 12:54:01','600','2022-11-15 13:34:47',10,0),('5','105',257772,'DAILY','2022-11-15','2022-11-16 05:52:20','2022-11-17 05:52:20','641',0.00,0.00,'641','2022-11-16 05:52:41','600','2022-11-16 09:38:21',10,0),('5','105',257773,'DAILY','2022-11-16','2022-11-17 10:14:01','2022-11-18 10:14:01','641',0.00,0.00,'641','2022-11-17 10:14:21','600','2022-11-17 10:29:46',10,0),('5','105',257774,'DAILY','2022-11-17','2022-11-17 18:09:51','2022-11-18 18:09:51','641',0.00,0.00,'641','2022-11-17 18:10:08','600','2022-11-18 08:36:47',10,0),('5','105',257775,'DAILY','2022-11-18','2022-11-18 10:09:17','2022-11-19 10:09:17','641',0.00,0.00,'641','2022-11-19 05:48:22','600','2022-11-19 09:14:40',10,0),('5','105',257776,'DAILY','2022-11-19','2022-11-19 19:59:03','2022-11-20 19:59:03','641',0.00,0.00,'641','2022-11-19 20:09:10','600','2022-11-20 10:32:29',10,0),('5','105',257777,'DAILY','2022-11-20','2022-11-20 20:01:38','2022-11-21 20:01:38','641',0.00,0.00,'641','2022-11-20 20:02:10','600','2022-11-21 06:06:08',10,0),('5','105',257778,'DAILY','2022-11-21','2022-11-21 22:33:13','2022-11-22 22:33:13','641',532855.50,532855.50,'641','2022-11-22 11:52:45','600','2022-11-22 13:30:02',10,0),('5','105',257779,'DAILY','2022-11-22','2022-11-23 05:48:04','2022-11-24 05:48:04','641',2050292.10,2050292.10,'641','2022-11-23 05:49:29','600','2022-11-23 06:11:03',10,0),('5','105',257780,'DAILY','2022-11-23','2022-11-24 05:45:45','2022-11-25 05:45:45','641',2062894.30,2062894.30,'641','2022-11-24 05:47:04','600','2022-11-24 06:45:30',10,0),('5','105',257781,'DAILY ','2022-11-24','2022-11-24 10:23:10','2022-11-25 10:23:10','600',1486088.35,1486088.35,'641','2022-11-25 09:41:14','600','2022-11-25 10:25:02',10,0),('5','105',257782,'DAILY','2022-11-25','2022-11-25 18:46:53','2022-11-26 18:46:53','641',0.00,0.00,'641','2022-11-25 18:47:14','600','2022-11-26 09:23:18',10,0),('5','105',257783,'DAILY','2022-11-26','2022-11-26 22:35:18','2022-11-27 22:35:18','641',0.00,0.00,'641','2022-11-26 22:36:28','600','2022-11-27 09:29:20',10,0),('5','105',257784,'DAILY','2022-11-27','2022-11-28 06:14:31','2022-11-29 06:14:31','641',0.00,0.00,'641','2022-11-28 06:15:02','600','2022-11-28 08:11:00',10,0),('5','105',257785,'DAILY','2022-11-29','2022-11-29 09:20:22','2022-11-30 09:20:22','641',0.00,0.00,'641','2022-11-29 09:20:58','600','2022-11-30 06:19:28',10,0),('5','105',257786,'DAILY','2022-11-29','2022-11-30 12:10:22','2022-12-01 12:10:22','641',339456.50,339456.50,'641','2022-12-01 12:51:39','600','2022-12-01 13:04:31',10,0),('5','105',257787,'DAILY','2022-11-30','2022-12-02 05:59:01','2022-12-03 05:59:01','641',1901777.80,1901777.80,'641','2022-12-02 06:01:10','600','2022-12-02 06:10:00',10,0),('5','105',257788,'DAILY','2022-12-01','2022-12-02 06:13:25','2022-12-03 06:13:25','641',1949722.40,1949722.40,'641','2022-12-02 06:14:51','600','2022-12-02 06:19:31',10,0),('5','105',257789,'DAILY','2022-12-02','2022-12-02 15:15:27','2022-12-03 15:15:27','641',1998083.25,1998083.25,'641','2022-12-03 06:01:47','600','2022-12-03 10:11:08',10,0),('5','105',257790,'DAILY','2022-12-03','2022-12-03 16:23:09','2022-12-04 16:23:09','641',1988609.40,1988609.40,'641','2022-12-04 06:13:33','600','2022-12-04 09:06:13',10,0),('5','105',257791,'DAILY','2022-12-04','2022-12-05 05:51:06','2022-12-06 05:51:06','641',1954323.35,1954323.35,'641','2022-12-05 05:52:10','600','2022-12-05 06:05:54',10,0),('5','105',257792,'DAILY','2022-12-05','2022-12-06 05:48:12','2022-12-07 05:48:12','641',2073074.85,2073074.85,'641','2022-12-06 05:50:09','600','2022-12-06 06:05:37',10,0),('5','105',257793,'DAILY','2022-12-06','2022-12-07 06:12:12','2022-12-08 06:12:12','641',1788091.60,1788091.60,'641','2022-12-07 06:13:46','600','2022-12-07 08:55:18',10,0),('5','105',257794,'DAILY','2022-12-07','2022-12-07 16:06:38','2022-12-08 16:06:38','641',1659050.40,1659050.40,'641','2022-12-07 16:43:16','600','2022-12-08 10:00:52',10,0),('5','105',257795,'DAILY','2022-12-08','2022-12-08 18:42:16','2022-12-09 18:42:16','641',0.00,0.00,'641','2022-12-08 18:42:41','600','2022-12-09 06:06:34',10,0),('5','105',257796,'DAILY','2022-12-09','2022-12-09 21:23:40','2022-12-10 21:23:40','641',0.00,0.00,'641','2022-12-09 21:24:07','600','2022-12-10 06:08:23',10,0),('5','105',257797,'DAILY','2022-12-10','2022-12-10 21:41:44','2022-12-11 21:41:44','641',0.00,0.00,'641','2022-12-10 21:42:30','600','2022-12-11 09:17:03',10,0),('5','105',257798,'DAILY','2022-12-11','2022-12-11 20:00:49','2022-12-12 20:00:49','641',0.00,0.00,'641','2022-12-11 20:01:22','600','2022-12-12 06:21:44',10,0),('5','105',257799,'DAILY','2022-12-12','2022-12-13 08:39:08','2022-12-14 08:39:08','641',0.00,0.00,'641','2022-12-13 08:39:36','600','2022-12-13 09:19:24',10,0),('5','105',257800,'DAILY','2022-12-13','2022-12-14 07:11:33','2022-12-15 07:11:33','641',0.00,0.00,'641','2022-12-14 07:11:53','600','2022-12-14 09:42:12',10,0),('5','105',257801,'DAILY','2022-12-14','2022-12-14 18:43:12','2022-12-15 18:43:12','641',0.00,0.00,'641','2022-12-14 18:43:48','600','2022-12-15 08:58:23',10,0),('5','105',257802,'DAILY','2022-12-15','2022-12-15 18:37:17','2022-12-16 18:37:17','641',0.00,0.00,'641','2022-12-15 18:38:03','600','2022-12-16 09:09:05',10,0),('5','105',257803,'DAILY','2022-12-16','2022-12-17 07:45:22','2022-12-18 07:45:22','641',0.00,0.00,'641','2022-12-17 07:45:49','600','2022-12-17 10:27:16',10,0),('5','105',257804,'DAILY','2022-12-17','2022-12-17 16:39:54','2022-12-18 16:39:54','641',0.00,0.00,'641','2022-12-17 16:40:45','600','2022-12-18 09:25:29',10,0),('5','105',257805,'DAILY','2022-12-18','2022-12-19 06:05:19','2022-12-20 06:05:19','641',620003.45,620003.45,'641','2022-12-19 21:09:21','600','2022-12-20 08:53:43',10,0),('5','105',257806,'DAILY','2022-12-19','2022-12-20 16:35:37','2022-12-21 16:35:37','641',2444044.25,2444044.25,'641','2022-12-20 16:36:36','600','2022-12-21 09:17:23',10,0),('5','105',257807,'DAILY','2022-12-20','2022-12-21 12:08:40','2022-12-22 12:08:40','641',1899596.65,1899596.65,'641','2022-12-21 12:10:56','600','2022-12-21 13:46:52',10,0),('5','105',257808,'DAILY','2022-12-21','2022-12-22 07:46:07','2022-12-23 07:46:07','641',616978.70,616978.70,'641','2022-12-22 15:02:57','600','2022-12-22 15:17:24',10,0),('5','105',257809,'DAILY','2022-12-22','2022-12-22 21:52:03','2022-12-23 21:52:03','641',0.00,0.00,'641','2022-12-22 21:52:51','600','2022-12-23 09:44:19',10,0),('5','105',257810,'DAILY','2022-12-23','2022-12-24 09:07:19','2022-12-25 09:07:19','641',0.00,0.00,'641','2022-12-24 09:07:55','600','2022-12-25 09:29:37',10,0),('5','105',257811,'DAILY','2022-12-24','2022-12-25 13:27:28','2022-12-26 13:27:28','641',0.00,0.00,'641','2022-12-25 13:27:56','600','2022-12-26 10:03:08',10,0),('5','105',257812,'DAILY','2022-12-25','2022-12-26 22:09:51','2022-12-27 22:09:51','641',0.00,0.00,'641','2022-12-26 22:10:17','600','2022-12-27 09:32:42',10,0),('5','105',257813,'DAILY','2022-12-26','2022-12-27 19:09:15','2022-12-28 19:09:15','641',0.00,0.00,'641','2022-12-27 19:09:37','600','2022-12-28 09:29:59',10,0),('5','105',257814,'DAILY','2022-12-27','2022-12-30 06:46:47','2022-12-31 06:46:47','641',0.00,0.00,'641','2022-12-30 06:47:12','600','2022-12-30 10:23:34',10,0),('5','105',257815,'DAILY','2022-12-28','2022-12-30 10:41:58','2022-12-31 10:41:58','641',0.00,0.00,'641','2022-12-30 10:43:21','600','2022-12-30 17:40:00',10,0),('5','105',257816,'DAILY','2022-12-29','2022-12-30 18:04:44','2022-12-31 18:04:44','641',0.00,0.00,'641','2022-12-30 18:05:46','600','2022-12-31 09:15:43',10,0),('5','105',257817,'DAILY','2022-12-30','2022-12-31 16:24:20','2023-01-01 16:24:20','641',0.00,0.00,'641','2022-12-31 16:24:59','600','2023-01-01 09:23:45',10,0),('5','105',257818,'DAILY','2022-12-31','2023-01-01 18:30:42','2023-01-02 18:30:42','641',0.00,0.00,'641','2023-01-01 18:31:01','600','2023-01-02 08:52:13',10,0),('5','105',257819,'DAILY','2023-01-01','2023-01-03 08:38:44','2023-01-04 08:38:44','641',0.00,0.00,'641','2023-01-03 08:39:02','600','2023-01-04 09:12:22',10,0),('5','105',257820,'DAILY','2023-01-02','2023-01-04 09:17:12','2023-01-05 09:17:12','641',0.00,0.00,'641','2023-01-04 09:17:42','600','2023-01-05 09:52:23',10,0),('5','105',257821,'DAILY','2023-01-03','2023-01-05 19:31:30','2023-01-06 19:31:30','641',0.00,0.00,'641','2023-01-05 19:31:55','600','2023-01-06 10:14:38',10,0),('5','105',257822,'DAILY','2023-01-04','2023-01-06 15:13:02','2023-01-07 15:13:02','641',0.00,0.00,'641','2023-01-06 15:13:21','600','2023-01-07 10:14:27',10,0),('5','105',257823,'DAILY','2023-01-05','2023-01-07 14:35:04','2023-01-08 14:35:04','641',0.00,0.00,'641','2023-01-08 13:08:45','600','2023-01-09 06:37:11',10,0),('5','105',257824,'DAILY','2023-01-06','2023-01-09 18:30:00','2023-01-10 18:30:00','641',0.00,0.00,'641','2023-01-09 18:30:45','600','2023-01-10 08:27:06',10,0),('5','105',257825,'DAILY','2023-01-07','2023-01-10 18:34:01','2023-01-11 18:34:01','641',0.00,0.00,'641','2023-01-10 18:34:25','600','2023-01-11 08:25:05',10,0),('5','105',257826,'DAILY','2023-01-08','2023-01-11 14:16:38','2023-01-12 14:16:38','641',0.00,0.00,'641','2023-01-11 14:16:59','600','2023-01-12 06:19:11',10,0),('5','105',257827,'DAILY','2023-01-09','2023-01-12 10:27:39','2023-01-13 10:27:39','641',0.00,0.00,'641','2023-01-12 10:28:11','600','2023-01-13 06:27:01',10,0),('5','105',257828,'DAILY','2023-01-10','2023-01-13 19:27:45','2023-01-14 19:27:45','641',0.00,0.00,'641','2023-01-13 19:28:12','600','2023-01-14 14:42:40',10,0),('5','105',257829,'DAILY','2023-01-11','2023-01-16 06:53:05','2023-01-17 06:53:05','641',0.00,0.00,'641','2023-01-16 06:53:28','600','2023-01-16 08:23:56',10,0),('5','105',257830,'DAILY','2023-01-12','2023-01-16 11:42:32','2023-01-17 11:42:32','641',0.00,0.00,'641','2023-01-16 11:43:01','600','2023-01-16 13:16:00',10,0),('5','105',257831,'DAILY','2023-01-13','2023-01-16 19:43:06','2023-01-17 19:43:06','641',0.00,0.00,'641','2023-01-16 19:43:43','600','2023-01-17 08:20:31',10,0),('5','105',257832,'DAILY','2023-01-14','2023-01-17 18:54:35','2023-01-18 18:54:35','641',0.00,0.00,'641','2023-01-17 18:54:52','600','2023-01-17 21:56:44',10,0),('5','105',257833,'DAILY','2023-01-15','2023-01-17 22:03:38','2023-01-18 22:03:38','641',0.00,0.00,'641','2023-01-17 22:03:57','600','2023-01-18 06:12:14',10,0),('5','105',257834,'DAILY','2023-01-16','2023-01-18 06:17:07','2023-01-19 06:17:07','641',0.00,0.00,'641','2023-01-18 06:17:25','600','2023-01-18 06:22:35',10,0),('5','105',257835,'DAILY','2023-01-17','2023-01-18 06:46:15','2023-01-19 06:46:15','641',3068570.95,3068570.95,'641','2023-01-18 15:11:05','600','2023-01-18 15:13:14',10,0),('5','105',257836,'DAILY','2023-01-18','2023-01-18 22:11:50','2023-01-19 22:11:50','641',2063897.00,2063897.00,'641','2023-01-19 08:12:21','600','2023-01-19 08:22:55',10,0),('5','105',257837,'DAILY','2023-01-19','2023-01-19 12:19:19','2023-01-20 12:19:19','641',445058.20,445058.20,'641','2023-01-21 10:14:02','600','2023-01-21 17:37:40',10,0),('5','105',257838,'DAILY','2023-01-20','2023-01-22 06:10:07','2023-01-23 06:10:07','641',0.00,0.00,'641','2023-01-22 06:10:35','600','2023-01-22 09:27:51',10,0),('5','105',257839,'DAILY','2023-01-21','2023-01-22 18:05:41','2023-01-23 18:05:41','641',0.00,0.00,'641','2023-01-22 18:06:05','600','2023-01-23 08:15:24',10,0),('5','105',257840,'DAILY','2023-01-21','2023-01-23 16:26:31','2023-01-24 16:26:31','641',432658.60,432658.60,'641','2023-01-24 06:14:07','600','2023-01-24 08:25:11',10,0),('5','105',257841,'DAILY','2023-01-23','2023-01-24 16:01:12','2023-01-25 16:01:12','641',0.00,0.00,'600','2023-01-24 16:08:35','600','2023-01-24 16:08:46',10,0),('5','105',257842,'DAILY','2023-01-23','2023-01-24 16:16:23','2023-01-25 16:16:23','641',2878251.20,2878251.20,'641','2023-01-24 16:17:04','600','2023-01-25 09:00:46',10,0),('5','105',257843,'DAILY','2023-01-24','2023-01-25 11:18:20','2023-01-26 11:18:20','641',3130747.40,3130747.40,'641','2023-01-25 11:21:33','600','2023-01-25 13:31:34',10,0),('5','105',257844,'DAILY','2023-01-25','2023-01-25 14:11:25','2023-01-26 14:11:25','641',1652503.60,1652503.60,'641','2023-01-26 14:14:58','600','2023-01-27 09:30:47',10,0),('5','105',257845,'DAILY','2023-01-26','2023-01-27 12:58:30','2023-01-28 12:58:30','641',0.00,0.00,'641','2023-01-27 12:58:51','600','2023-01-28 11:58:43',10,0),('5','105',257846,'DAILY','2023-01-27','2023-01-28 12:28:34','2023-01-29 12:28:34','641',0.00,0.00,'641','2023-01-28 12:28:55','600','2023-01-29 11:55:40',10,0),('5','105',257847,'DAILY','2023-01-28','2023-01-29 20:06:03','2023-01-30 20:06:03','641',0.00,0.00,'641','2023-01-29 20:06:25','600','2023-01-30 08:56:23',10,0),('5','105',257848,'DAILY','2023-01-29','2023-01-30 11:07:37','2023-01-31 11:07:37','641',0.00,0.00,'641','2023-01-30 11:08:01','600','2023-01-30 13:30:29',10,0),('5','105',257849,'DAILY','2023-01-30','2023-01-31 07:27:21','2023-02-01 07:27:21','641',0.00,0.00,'641','2023-01-31 07:27:44','600','2023-01-31 09:58:04',10,0),('5','105',257850,'DAILY','2023-01-31','2023-02-01 08:00:41','2023-02-02 08:00:41','641',0.00,0.00,'641','2023-02-01 08:01:21','600','2023-02-02 12:27:04',10,0),('5','105',257851,'DAILY','2023-02-01','2023-02-03 07:04:27','2023-02-04 07:04:27','641',0.00,0.00,'641','2023-02-03 07:04:51','600','2023-02-03 09:10:44',10,0),('5','105',257852,'DAILY','2023-02-02','2023-02-04 07:31:31','2023-02-05 07:31:31','641',0.00,0.00,'641','2023-02-04 07:31:53','600','2023-02-04 13:15:43',10,0),('5','105',257853,'DAILY','2023-02-03','2023-02-06 07:32:52','2023-02-07 07:32:52','641',0.00,0.00,'641','2023-02-06 07:33:17','600','2023-02-06 08:54:35',10,0),('5','105',257854,'DAILY','2023-02-04','2023-02-06 10:44:23','2023-02-07 10:44:23','641',0.00,0.00,'641','2023-02-06 10:44:44','600','2023-02-07 09:06:28',10,0),('5','105',257855,'DAILY','2023-02-05','2023-02-07 12:55:08','2023-02-08 12:55:08','641',0.00,0.00,'641','2023-02-07 12:55:35','600','2023-02-07 14:12:17',10,0),('5','105',257856,'DAILY','2023-02-06','2023-02-07 15:54:49','2023-02-08 15:54:49','641',0.00,0.00,'641','2023-02-07 15:55:14','600','2023-02-08 08:39:34',10,0),('5','105',257857,'DAILY','2023-02-07','2023-02-08 09:04:11','2023-02-09 09:04:11','641',1066511.60,1066511.60,'641','2023-02-08 09:55:31','600','2023-02-08 13:56:50',10,0),('5','105',257858,'DAILY','2023-02-08','2023-02-09 06:15:25','2023-02-10 06:15:25','641',3652457.60,3652457.60,'641','2023-02-09 06:16:44','600','2023-02-09 08:27:57',10,0),('5','105',257859,'DAILY','2023-02-09','2023-02-10 08:09:03','2023-02-11 08:09:03','641',1895326.40,1895326.40,'641','2023-02-10 14:42:08','600','2023-02-10 14:53:13',10,0),('5','105',257860,'DAILY','2023-02-10','2023-02-10 21:27:27','2023-02-11 21:27:27','641',0.00,0.00,'641','2023-02-10 21:28:31','600','2023-02-11 13:56:44',10,0),('5','105',257861,'DAILY','2023-02-11','2023-02-11 20:00:32','2023-02-12 20:00:32','641',0.00,0.00,'641','2023-02-11 20:01:05','600','2023-02-12 14:11:37',10,0),('5','105',257862,'DAILY','2023-02-12','2023-02-13 11:26:04','2023-02-14 11:26:04','641',0.00,0.00,'641','2023-02-13 11:26:22','600','2023-02-14 09:31:40',10,0),('5','105',257863,'DAILY','2023-02-13','2023-02-14 15:04:46','2023-02-15 15:04:46','641',0.00,0.00,'641','2023-02-14 15:05:12','600','2023-02-15 08:55:33',10,0),('5','105',257864,'DAILY','2023-02-14','2023-02-15 20:45:44','2023-02-16 20:45:44','641',0.00,0.00,'641','2023-02-15 20:46:14','600','2023-02-16 11:47:42',10,0),('5','105',257865,'DAILY','2023-02-15','2023-02-17 07:08:34','2023-02-18 07:08:34','641',0.00,0.00,'641','2023-02-17 07:08:59','600','2023-02-17 10:27:25',10,0),('5','105',257866,'DAILY','2023-02-16','2023-02-18 06:55:12','2023-02-19 06:55:12','641',0.00,0.00,'641','2023-02-18 06:55:36','600','2023-02-18 21:23:13',10,0),('5','105',257867,'DAILY','2023-02-18','2023-02-19 16:38:16','2023-02-20 16:38:16','641',0.00,0.00,'641','2023-02-19 16:38:41','600','2023-02-19 17:36:42',10,0),('5','105',257868,'DAILY','2023-02-19','2023-02-20 19:24:25','2023-02-21 19:24:25','641',0.00,0.00,'641','2023-02-21 16:34:38','600','2023-02-22 09:09:42',10,0),('5','105',257869,'DAILY','2023-02-20','2023-02-23 08:03:34','2023-02-24 08:03:34','641',0.00,0.00,'641','2023-02-23 08:03:53','600','2023-02-23 10:05:35',10,0),('5','105',257870,'DAILY','2023-02-21','2023-02-23 14:17:19','2023-02-24 14:17:19','641',0.00,0.00,'641','2023-02-23 14:18:01','600','2023-02-24 09:06:07',10,0),('5','105',257871,'DAILY','2023-02-22','2023-02-25 08:03:27','2023-02-26 08:03:27','641',0.00,0.00,'641','2023-02-25 08:03:43','600','2023-02-25 10:37:52',10,0),('5','105',257872,'DAILY','2023-02-23','2023-02-26 15:38:09','2023-02-27 15:38:09','641',0.00,0.00,'641','2023-02-26 15:38:24','600','2023-02-26 16:19:47',10,0),('5','105',257873,'DAILY','2023-02-24','2023-02-26 19:55:09','2023-02-27 19:55:09','641',0.00,0.00,'641','2023-02-26 19:55:33','600','2023-02-27 09:23:12',10,0),('5','105',257874,'DAILY','2023-02-25','2023-02-27 14:26:23','2023-02-28 14:26:23','641',1043253.20,1043253.20,'641','2023-02-27 14:32:16','600','2023-02-27 14:38:18',10,0),('5','105',257875,'DAILY','2023-02-27','2023-02-27 23:19:43','2023-02-28 23:19:43','641',2244090.20,2244090.20,'641','2023-02-28 14:31:25','600','2023-02-28 17:52:34',10,0),('5','105',257876,'DAILY','2023-02-27','2023-02-28 19:57:31','2023-03-01 19:57:31','641',461469.80,461469.80,'641','2023-03-01 04:41:25','600','2023-03-01 10:03:33',10,0),('5','105',257877,'DAILY','2023-02-28','2023-03-01 15:22:55','2023-03-02 15:22:55','641',2187009.00,2187009.00,'641','2023-03-01 18:20:53','600','2023-03-02 09:10:28',10,0),('5','105',257878,'DAILY','2023-03-01','2023-03-02 09:29:45','2023-03-03 09:29:45','641',0.00,0.00,'600','2023-03-02 10:03:14','600','2023-03-02 10:03:26',10,0),('5','105',257879,'DAILY','2023-03-01','2023-03-02 10:14:39','2023-03-03 10:14:39','641',2366945.70,2366945.70,'641','2023-03-02 10:32:08','600','2023-03-02 11:04:24',10,0),('5','105',257880,'DAILY','2023-03-02','2023-03-02 22:58:01','2023-03-03 22:58:01','641',2266586.70,2266586.70,'641','2023-03-03 09:36:47','600','2023-03-03 11:48:42',10,0),('5','105',257881,'DAILY','2023-03-03','2023-03-04 06:10:38','2023-03-05 06:10:38','641',2540210.40,2540210.40,'641','2023-03-04 06:12:43','600','2023-03-04 13:36:32',10,0),('5','105',257882,'DAILY','2023-03-04','2023-03-05 06:50:09','2023-03-06 06:50:09','641',3113334.00,3113334.00,'641','2023-03-05 10:11:59','600','2023-03-05 11:20:32',10,0),('5','105',257883,'DAILY','2023-03-05','2023-03-05 19:28:16','2023-03-06 19:28:16','641',3470798.10,3470798.10,'641','2023-03-06 06:12:01','600','2023-03-06 09:38:50',10,0),('5','105',257884,'DAILY ','2023-03-06','2023-03-06 13:19:30','2023-03-07 13:19:30','641',4681051.20,4681051.20,'641','2023-03-07 11:45:07','600','2023-03-08 09:16:24',10,0),('5','105',257885,'DAILY','2023-03-07','2023-03-08 15:40:31','2023-03-09 15:40:31','641',3917306.40,3917306.40,'641','2023-03-08 15:42:15','600','2023-03-08 16:20:00',10,0),('5','105',257886,'DAILY','2023-03-08','2023-03-08 20:24:11','2023-03-09 20:24:11','641',2939086.50,2939086.50,'641','2023-03-09 07:44:07','600','2023-03-09 14:50:33',10,0),('5','105',257887,'DAILY','2023-03-09','2023-03-10 06:54:11','2023-03-11 06:54:11','641',0.00,0.00,'641','2023-03-10 06:54:42','600','2023-03-10 09:20:30',10,0),('5','105',257888,'DAILY','2023-03-10','2023-03-11 11:22:33','2023-03-12 11:22:33','641',0.00,0.00,'641','2023-03-11 11:22:58','600','2023-03-11 22:50:22',10,0),('5','105',257889,'DAILY','2023-03-11','2023-03-12 11:25:52','2023-03-13 11:25:52','641',0.00,0.00,'641','2023-03-12 11:26:23','600','2023-03-13 08:17:31',10,0),('5','105',257890,'DAILY','2023-03-12','2023-03-14 06:45:41','2023-03-15 06:45:41','641',0.00,0.00,'641','2023-03-14 06:46:42','600','2023-03-14 09:18:43',10,0),('5','105',257891,'DAILY','2023-03-13','2023-03-14 16:16:25','2023-03-15 16:16:25','641',0.00,0.00,'641','2023-03-14 16:16:51','600','2023-03-15 08:22:45',10,0),('5','105',257892,'DAILY','2023-03-14','2023-03-16 08:28:31','2023-03-17 08:28:31','641',0.00,0.00,'641','2023-03-16 08:28:55','600','2023-03-16 08:31:00',10,0),('5','105',257893,'DAILY','2023-03-15','2023-03-16 08:33:23','2023-03-17 08:33:23','641',0.00,0.00,'641','2023-03-16 08:33:42','600','2023-03-16 09:37:14',10,0),('5','105',257894,'DAILY','2023-03-16','2023-03-17 07:51:57','2023-03-18 07:51:57','641',0.00,0.00,'641','2023-03-17 07:52:25','600','2023-03-17 11:59:17',10,0),('5','105',257895,'DAILY','2023-03-17','2023-03-19 09:35:11','2023-03-20 09:35:11','641',0.00,0.00,'641','2023-03-19 09:35:44','600','2023-03-20 08:38:56',10,0),('5','105',257896,'DAILY','2023-03-18','2023-03-20 17:36:47','2023-03-21 17:36:47','641',0.00,0.00,'641','2023-03-20 17:37:13','','0000-00-00 00:00:00',5,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4908013 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('5','105','961','213016',4126272,'2853','432',186.74,2529.40,2342.66,386538.90,0.00,0.00,0.00,0.00,0.00),('5','105','961','213016',4126273,'2854','432',34.89,306.52,271.63,44818.95,0.00,0.00,0.00,0.00,0.00),('5','105','962','213016',4126274,'2855','432',51.31,51.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','213016',4126275,'2856','432',117.05,1948.70,1831.65,302222.25,0.00,0.00,0.00,0.00,0.00),('5','105','963','213016',4126276,'2857','432',94.02,3274.09,3180.07,524711.55,0.00,0.00,0.00,0.00,0.00),('5','105','963','213016',4126277,'2858','432',65.14,2501.48,2436.34,401996.10,0.00,0.00,0.00,0.00,0.00),('5','105','964','213016',4126278,'2859','432',17.35,17.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','213016',4126279,'2860','432',103.28,103.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','213016',4126280,'2861','433',178.55,791.67,613.12,177804.80,0.00,0.00,0.00,0.00,0.00),('5','105','966','213016',4126281,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','213016',4126282,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','213055',4126868,'2853','432',2529.40,3756.74,1227.34,202511.10,0.00,0.00,0.00,0.00,0.00),('5','105','961','213055',4126869,'2854','432',306.52,2654.64,2348.12,387439.80,0.00,0.00,0.00,0.00,0.00),('5','105','962','213055',4126870,'2855','432',51.31,2489.18,2437.87,402248.55,0.00,0.00,0.00,0.00,0.00),('5','105','962','213055',4126871,'2856','432',1948.70,4198.03,2249.33,371139.45,0.00,0.00,0.00,0.00,0.00),('5','105','963','213055',4126872,'2857','432',3274.09,5185.59,1911.50,315397.50,0.00,0.00,0.00,0.00,0.00),('5','105','963','213055',4126873,'2858','432',2501.48,6748.07,4246.59,700687.35,0.00,0.00,0.00,0.00,0.00),('5','105','964','213055',4126874,'2859','432',17.35,17.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','213055',4126875,'2860','432',103.28,103.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','213055',4126876,'2861','433',791.67,1521.23,729.56,211572.40,0.00,0.00,0.00,0.00,0.00),('5','105','966','213055',4126877,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','213055',4126878,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','213303',4130942,'2853','432',3756.74,7255.38,3498.64,577275.60,0.00,0.00,0.00,0.00,0.00),('5','105','961','213303',4130943,'2854','432',2654.64,2654.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','213303',4130944,'2855','432',2489.18,6646.52,4157.34,685961.10,0.00,0.00,0.00,0.00,0.00),('5','105','962','213303',4130945,'2856','432',4198.03,4198.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','213303',4130946,'2857','432',5185.59,7463.09,2277.50,375787.50,0.00,0.00,0.00,0.00,0.00),('5','105','963','213303',4130947,'2858','432',6748.07,10453.73,3705.66,611433.90,0.00,0.00,0.00,0.00,0.00),('5','105','964','213303',4130948,'2859','432',235.57,235.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','213303',4130949,'2860','432',237.36,237.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','213303',4130950,'2861','433',1521.23,2269.93,748.70,217123.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','213303',4130951,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','213303',4130952,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','213308',4131002,'2853','432',7255.38,11567.44,4312.06,711489.90,0.00,0.00,0.00,0.00,0.00),('5','105','961','213308',4131003,'2854','432',2654.64,2654.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','213308',4131004,'2855','432',6646.52,10417.26,3770.74,622172.10,0.00,0.00,0.00,0.00,0.00),('5','105','962','213308',4131005,'2856','432',4198.03,4198.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','213308',4131006,'2857','432',7463.09,9596.65,2133.56,352037.40,0.00,0.00,0.00,0.00,0.00),('5','105','963','213308',4131007,'2858','432',10453.73,13999.66,3545.93,585078.45,0.00,0.00,0.00,0.00,0.00),('5','105','964','213308',4131008,'2859','432',235.57,235.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','213308',4131009,'2860','432',237.36,237.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','213308',4131010,'2861','433',2269.93,2994.31,724.38,210070.20,0.00,0.00,0.00,0.00,0.00),('5','105','966','213308',4131011,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','213308',4131012,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','213311',4131057,'2853','432',11567.44,14881.76,3314.32,546862.80,0.00,0.00,0.00,0.00,0.00),('5','105','961','213311',4131058,'2854','432',2654.64,2654.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','213311',4131059,'2855','432',10417.26,13852.39,3435.13,566796.45,0.00,0.00,0.00,0.00,0.00),('5','105','962','213311',4131060,'2856','432',4198.03,4198.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','213311',4131061,'2857','432',9596.65,13095.78,3499.13,577356.45,0.00,0.00,0.00,0.00,0.00),('5','105','963','213311',4131062,'2858','432',13999.66,17416.21,3416.55,563730.75,0.00,0.00,0.00,0.00,0.00),('5','105','964','213311',4131063,'2859','432',235.57,235.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','213311',4131064,'2860','432',237.36,237.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','213311',4131065,'2861','433',2994.31,3783.65,789.34,228908.60,0.00,0.00,0.00,0.00,0.00),('5','105','966','213311',4131066,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','213311',4131067,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','213313',4131087,'2853','432',14881.76,18302.18,3420.42,564369.30,0.00,0.00,0.00,0.00,0.00),('5','105','961','213313',4131088,'2854','432',2654.64,2654.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','213313',4131089,'2855','432',13852.39,17721.01,3868.62,638322.30,0.00,0.00,0.00,0.00,0.00),('5','105','962','213313',4131090,'2856','432',4198.03,4198.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','213313',4131091,'2857','432',13095.78,15730.70,2634.92,434761.80,0.00,0.00,0.00,0.00,0.00),('5','105','963','213313',4131092,'2858','432',17416.21,20626.99,3210.78,529778.70,0.00,0.00,0.00,0.00,0.00),('5','105','964','213313',4131093,'2859','432',235.57,235.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','213313',4131094,'2860','432',237.36,237.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','213313',4131095,'2861','433',3783.65,5010.60,1226.95,355815.50,0.00,0.00,0.00,0.00,0.00),('5','105','966','213313',4131096,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','213313',4131097,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','213318',4131180,'2853','432',18302.18,21917.02,3614.84,596448.60,0.00,0.00,0.00,0.00,0.00),('5','105','961','213318',4131181,'2854','432',2654.64,2654.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','213318',4131182,'2855','432',17721.01,21322.85,3601.84,594303.60,0.00,0.00,0.00,0.00,0.00),('5','105','962','213318',4131183,'2856','432',4198.03,4198.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','213318',4131184,'2857','432',15730.70,18810.91,3080.21,508234.65,0.00,0.00,0.00,0.00,0.00),('5','105','963','213318',4131185,'2858','432',20626.99,23854.94,3227.95,532611.75,0.00,0.00,0.00,0.00,0.00),('5','105','964','213318',4131186,'2859','432',235.57,235.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','213318',4131187,'2860','432',237.36,237.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','213318',4131188,'2861','433',5010.60,5652.64,642.04,189401.80,0.00,0.00,0.00,0.00,0.00),('5','105','966','213318',4131189,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','213318',4131190,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','213325',4131307,'2853','432',21917.02,22568.93,651.91,107565.15,0.00,0.00,0.00,0.00,0.00),('5','105','961','213325',4131308,'2854','432',2654.64,8076.83,5422.19,894661.35,0.00,0.00,0.00,0.00,0.00),('5','105','962','213325',4131309,'2855','432',21322.85,21352.71,29.86,4926.90,0.00,0.00,0.00,0.00,0.00),('5','105','962','213325',4131310,'2856','432',4198.03,8972.11,4774.08,787723.20,0.00,0.00,0.00,0.00,0.00),('5','105','963','213325',4131311,'2857','432',18810.91,18810.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','213325',4131312,'2858','432',23854.94,25246.76,1391.82,229650.30,0.00,0.00,0.00,0.00,0.00),('5','105','964','213325',4131313,'2859','432',235.57,235.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','213325',4131314,'2860','432',237.36,237.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','213325',4131315,'2861','433',5652.64,6790.05,1137.41,335535.95,0.00,0.00,0.00,0.00,0.00),('5','105','966','213325',4131316,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','213325',4131317,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','213330',4131415,'2853','432',22568.93,26127.81,3558.88,587215.20,0.00,0.00,0.00,0.00,0.00),('5','105','961','213330',4131416,'2854','432',8076.83,11406.34,3329.51,549369.15,0.00,0.00,0.00,0.00,0.00),('5','105','962','213330',4131417,'2855','432',21352.71,25132.49,3779.78,623663.70,0.00,0.00,0.00,0.00,0.00),('5','105','962','213330',4131418,'2856','432',8972.11,11999.73,3027.62,499557.30,0.00,0.00,0.00,0.00,0.00),('5','105','963','213330',4131419,'2857','432',18810.91,18810.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','213330',4131420,'2858','432',25246.76,25246.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','213330',4131421,'2859','432',235.57,235.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','213330',4131422,'2860','432',237.36,237.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','213330',4131423,'2861','433',6790.05,7413.75,623.70,183991.50,0.00,0.00,0.00,0.00,0.00),('5','105','966','213330',4131424,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','213330',4131425,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','213332',4131439,'2853','432',26127.81,28748.28,2620.47,432377.55,0.00,0.00,0.00,0.00,0.00),('5','105','961','213332',4131440,'2854','432',11406.34,14834.55,3428.21,565654.65,0.00,0.00,0.00,0.00,0.00),('5','105','962','213332',4131441,'2855','432',25132.49,28360.61,3228.12,532639.80,0.00,0.00,0.00,0.00,0.00),('5','105','962','213332',4131442,'2856','432',11999.73,14010.62,2010.89,331796.85,0.00,0.00,0.00,0.00,0.00),('5','105','963','213332',4131443,'2857','432',18810.91,18829.08,18.17,2998.05,0.00,0.00,0.00,0.00,0.00),('5','105','963','213332',4131444,'2858','432',25246.76,28207.28,2960.52,488485.80,0.00,0.00,0.00,0.00,0.00),('5','105','964','213332',4131445,'2859','432',235.57,235.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','213332',4131446,'2860','432',237.36,237.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','213332',4131447,'2861','433',7413.75,8527.22,1113.47,328473.65,0.00,0.00,0.00,0.00,0.00),('5','105','966','213332',4131448,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','213332',4131449,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','213487',4134030,'2853','432',28748.28,32606.35,3858.07,636581.55,0.00,0.00,0.00,0.00,0.00),('5','105','961','213487',4134031,'2854','432',14834.55,14834.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','213487',4134032,'2855','432',28360.61,32423.24,4062.63,670333.95,0.00,0.00,0.00,0.00,0.00),('5','105','962','213487',4134033,'2856','432',14010.62,17425.67,3415.05,563483.25,0.00,0.00,0.00,0.00,0.00),('5','105','963','213487',4134034,'2857','432',18829.08,18954.41,125.33,20679.45,0.00,0.00,0.00,0.00,0.00),('5','105','963','213487',4134035,'2858','432',28207.28,33300.98,5093.70,840460.50,0.00,0.00,0.00,0.00,0.00),('5','105','964','213487',4134036,'2859','432',235.57,235.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','213487',4134037,'2860','432',237.36,237.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','213487',4134038,'2861','433',8527.22,9060.17,532.95,157220.25,0.00,0.00,0.00,0.00,0.00),('5','105','966','213487',4134039,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','213487',4134040,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','213504',4134277,'2853','432',32606.35,36310.05,3703.70,611110.50,0.00,0.00,0.00,0.00,0.00),('5','105','961','213504',4134278,'2854','432',14834.55,15854.87,1020.32,168352.80,0.00,0.00,0.00,0.00,0.00),('5','105','962','213504',4134279,'2855','432',32423.24,37185.30,4762.06,785739.90,0.00,0.00,0.00,0.00,0.00),('5','105','962','213504',4134280,'2856','432',17425.67,18257.71,832.04,137286.60,0.00,0.00,0.00,0.00,0.00),('5','105','963','213504',4134281,'2857','432',18954.41,19812.91,858.50,141652.50,0.00,0.00,0.00,0.00,0.00),('5','105','963','213504',4134282,'2858','432',33300.98,36614.59,3313.61,546745.65,0.00,0.00,0.00,0.00,0.00),('5','105','964','213504',4134283,'2859','432',235.57,235.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','213504',4134284,'2860','432',237.36,237.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','213504',4134285,'2861','433',9060.17,9371.83,311.66,91939.70,0.00,0.00,0.00,0.00,0.00),('5','105','966','213504',4134286,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','213504',4134287,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','213508',4134330,'2853','432',36310.05,39975.31,3665.26,604767.90,0.00,0.00,0.00,0.00,0.00),('5','105','961','213508',4134331,'2854','432',15854.87,16260.06,405.19,66856.35,0.00,0.00,0.00,0.00,0.00),('5','105','962','213508',4134332,'2855','432',37185.30,40495.13,3309.83,546121.95,0.00,0.00,0.00,0.00,0.00),('5','105','962','213508',4134333,'2856','432',18257.71,19661.79,1404.08,231673.20,0.00,0.00,0.00,0.00,0.00),('5','105','963','213508',4134334,'2857','432',19812.91,21318.48,1505.57,248419.05,0.00,0.00,0.00,0.00,0.00),('5','105','963','213508',4134335,'2858','432',36614.59,39744.96,3130.37,516511.05,0.00,0.00,0.00,0.00,0.00),('5','105','964','213508',4134336,'2859','432',235.57,235.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','213508',4134337,'2860','432',237.36,237.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','213508',4134338,'2861','433',9371.83,9697.90,326.07,96190.65,0.00,0.00,0.00,0.00,0.00),('5','105','966','213508',4134339,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','213508',4134340,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','213515',4134429,'2853','432',39975.31,42182.40,2207.09,364169.85,0.00,0.00,0.00,0.00,0.00),('5','105','961','213515',4134430,'2854','432',16260.06,16260.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','213515',4134431,'2855','432',40495.13,41287.64,792.51,130764.15,0.00,0.00,0.00,0.00,0.00),('5','105','962','213515',4134432,'2856','432',19661.79,21485.47,1823.68,300907.20,0.00,0.00,0.00,0.00,0.00),('5','105','963','213515',4134433,'2857','432',21318.48,24024.81,2706.33,446544.45,0.00,0.00,0.00,0.00,0.00),('5','105','963','213515',4134434,'2858','432',39744.96,42510.76,2765.80,456357.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','213515',4134435,'2859','432',235.57,235.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','213515',4134436,'2860','432',237.36,237.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','213515',4134437,'2861','433',9697.90,9992.51,294.61,86909.95,0.00,0.00,0.00,0.00,0.00),('5','105','966','213515',4134438,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','213515',4134439,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','213527',4134647,'2853','432',42182.40,45340.36,3157.96,521063.40,0.00,0.00,0.00,0.00,0.00),('5','105','961','213527',4134648,'2854','432',16260.06,16260.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','213527',4134649,'2855','432',41287.64,44780.34,3492.70,576295.50,0.00,0.00,0.00,0.00,0.00),('5','105','962','213527',4134650,'2856','432',21485.47,24581.22,3095.75,510798.75,0.00,0.00,0.00,0.00,0.00),('5','105','963','213527',4134651,'2857','432',24024.81,24024.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','213527',4134652,'2858','432',42510.76,45599.45,3088.69,509633.85,0.00,0.00,0.00,0.00,0.00),('5','105','964','213527',4134653,'2859','432',235.57,235.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','213527',4134654,'2860','432',237.36,237.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','213527',4134655,'2861','433',9992.51,10588.13,595.62,175707.90,0.00,0.00,0.00,0.00,0.00),('5','105','966','213527',4134656,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','213527',4134657,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','213532',4134709,'2853','432',45340.36,49455.24,4114.88,678955.20,0.00,0.00,0.00,0.00,0.00),('5','105','961','213532',4134710,'2854','432',16260.06,16260.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','213532',4134711,'2855','432',44780.34,48866.85,4086.51,674274.15,0.00,0.00,0.00,0.00,0.00),('5','105','962','213532',4134712,'2856','432',24581.22,27067.58,2486.36,410249.40,0.00,0.00,0.00,0.00,0.00),('5','105','963','213532',4134713,'2857','432',24024.81,24671.36,646.55,106680.75,0.00,0.00,0.00,0.00,0.00),('5','105','963','213532',4134714,'2858','432',45599.45,48407.69,2808.24,463359.60,0.00,0.00,0.00,0.00,0.00),('5','105','964','213532',4134715,'2859','432',235.57,235.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','213532',4134716,'2860','432',237.36,237.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','213532',4134717,'2861','433',10588.13,11403.46,815.33,240522.35,0.00,0.00,0.00,0.00,0.00),('5','105','966','213532',4134718,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','213532',4134719,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','213538',4134817,'2853','432',49455.24,53439.40,3984.16,657386.40,0.00,0.00,0.00,0.00,0.00),('5','105','961','213538',4134818,'2854','432',16260.06,16260.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','213538',4134819,'2855','432',48866.85,52853.21,3986.36,657749.40,0.00,0.00,0.00,0.00,0.00),('5','105','962','213538',4134820,'2856','432',27067.58,27067.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','213538',4134821,'2857','432',24671.36,25650.52,979.16,161561.40,0.00,0.00,0.00,0.00,0.00),('5','105','963','213538',4134822,'2858','432',48407.69,51993.99,3586.30,591739.50,0.00,0.00,0.00,0.00,0.00),('5','105','964','213538',4134823,'2859','432',235.57,235.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','213538',4134824,'2860','432',237.36,237.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','213538',4134825,'2861','433',11403.46,12082.57,679.11,200337.45,0.00,0.00,0.00,0.00,0.00),('5','105','966','213538',4134826,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','213538',4134827,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','213555',4135089,'2853','432',53439.40,56253.78,2814.38,464372.70,0.00,0.00,0.00,0.00,0.00),('5','105','961','213555',4135090,'2854','432',16260.06,16260.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','213555',4135091,'2855','432',52853.21,56454.00,3600.79,594130.35,0.00,0.00,0.00,0.00,0.00),('5','105','962','213555',4135092,'2856','432',27067.58,27067.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','213555',4135093,'2857','432',25650.52,25650.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','213555',4135094,'2858','432',51993.99,54585.88,2591.89,427661.85,0.00,0.00,0.00,0.00,0.00),('5','105','964','213555',4135095,'2859','432',235.57,235.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','213555',4135096,'2860','432',237.36,237.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','213555',4135097,'2861','433',12082.57,12907.40,824.83,243324.85,0.00,0.00,0.00,0.00,0.00),('5','105','966','213555',4135098,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','213555',4135099,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','213558',4135130,'2853','432',56253.78,58360.26,2106.48,347569.20,0.00,0.00,0.00,0.00,0.00),('5','105','961','213558',4135131,'2854','432',16260.06,16265.82,5.76,950.40,0.00,0.00,0.00,0.00,0.00),('5','105','962','213558',4135132,'2855','432',56454.00,59127.62,2673.62,441147.30,0.00,0.00,0.00,0.00,0.00),('5','105','962','213558',4135133,'2856','432',27067.58,28264.70,1197.12,197524.80,0.00,0.00,0.00,0.00,0.00),('5','105','963','213558',4135134,'2857','432',25650.52,25958.54,308.02,50823.30,0.00,0.00,0.00,0.00,0.00),('5','105','963','213558',4135135,'2858','432',54585.88,56730.70,2144.82,353895.30,0.00,0.00,0.00,0.00,0.00),('5','105','964','213558',4135136,'2859','432',235.57,1411.11,1175.54,193964.10,0.00,0.00,0.00,0.00,0.00),('5','105','964','213558',4135137,'2860','432',237.36,1603.86,1366.50,225472.50,0.00,0.00,0.00,0.00,0.00),('5','105','965','213558',4135138,'2861','433',12907.40,13436.83,529.43,156181.85,0.00,0.00,0.00,0.00,0.00),('5','105','966','213558',4135139,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','213558',4135140,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','213569',4135330,'2853','432',58360.26,60330.20,1969.94,325040.10,0.00,0.00,0.00,0.00,0.00),('5','105','961','213569',4135331,'2854','432',16265.82,16265.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','213569',4135332,'2855','432',59127.62,61624.24,2496.62,411942.30,0.00,0.00,0.00,0.00,0.00),('5','105','962','213569',4135333,'2856','432',28264.70,29415.56,1150.86,189891.90,0.00,0.00,0.00,0.00,0.00),('5','105','963','213569',4135334,'2857','432',25958.54,26936.87,978.33,161424.45,0.00,0.00,0.00,0.00,0.00),('5','105','963','213569',4135335,'2858','432',56730.70,57739.85,1009.15,166509.75,0.00,0.00,0.00,0.00,0.00),('5','105','964','213569',4135336,'2859','432',1411.11,3705.73,2294.62,378612.30,0.00,0.00,0.00,0.00,0.00),('5','105','964','213569',4135337,'2860','432',1603.86,2946.51,1342.65,221537.25,0.00,0.00,0.00,0.00,0.00),('5','105','965','213569',4135338,'2861','433',13436.83,13944.57,507.74,149783.30,0.00,0.00,0.00,0.00,0.00),('5','105','966','213569',4135339,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','213569',4135340,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','213629',4136394,'2853','432',60330.20,62842.09,2511.89,414461.85,0.00,0.00,0.00,0.00,0.00),('5','105','961','213629',4136395,'2854','432',16265.82,16265.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','213629',4136396,'2855','432',61624.24,64503.30,2879.06,475044.90,0.00,0.00,0.00,0.00,0.00),('5','105','962','213629',4136397,'2856','432',29415.56,30716.92,1301.36,214724.40,0.00,0.00,0.00,0.00,0.00),('5','105','963','213629',4136398,'2857','432',26936.87,28101.36,1164.49,192140.85,0.00,0.00,0.00,0.00,0.00),('5','105','963','213629',4136399,'2858','432',57739.85,59488.07,1748.22,288456.30,0.00,0.00,0.00,0.00,0.00),('5','105','964','213629',4136400,'2859','432',3705.73,6061.10,2355.37,388636.05,0.00,0.00,0.00,0.00,0.00),('5','105','964','213629',4136401,'2860','432',2946.51,2946.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','213629',4136402,'2861','433',13944.57,13944.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','213629',4136403,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','213629',4136404,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','213957',4141687,'2853','432',62842.09,63100.22,258.13,42591.45,0.00,0.00,0.00,0.00,0.00),('5','105','961','213957',4141688,'2854','432',16265.82,19063.93,2798.11,461688.15,0.00,0.00,0.00,0.00,0.00),('5','105','962','213957',4141689,'2855','432',64503.30,64647.65,144.35,23817.75,0.00,0.00,0.00,0.00,0.00),('5','105','962','213957',4141690,'2856','432',30716.92,33420.26,2703.34,446051.10,0.00,0.00,0.00,0.00,0.00),('5','105','963','213957',4141691,'2857','432',28101.36,28101.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','213957',4141692,'2858','432',59488.07,59488.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','213957',4141693,'2859','432',6061.10,9213.24,3152.14,520103.10,0.00,0.00,0.00,0.00,0.00),('5','105','964','213957',4141694,'2860','432',2946.51,5759.74,2813.23,464182.95,0.00,0.00,0.00,0.00,0.00),('5','105','965','213957',4141695,'2861','433',13944.57,14354.09,409.52,120808.40,0.00,0.00,0.00,0.00,0.00),('5','105','966','213957',4141696,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','213957',4141697,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','214424',4149760,'2853','432',63100.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','214424',4149761,'2854','432',19063.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','214424',4149762,'2855','432',64647.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','214424',4149763,'2856','432',33420.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','214424',4149764,'2857','432',28101.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','214424',4149765,'2858','432',59488.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','214424',4149766,'2859','432',9213.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','214424',4149767,'2860','432',5759.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','214424',4149768,'2861','433',14354.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','214424',4149769,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','214424',4149770,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','214902',4157922,'2853','432',63100.22,63100.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','214902',4157923,'2854','432',19063.93,21997.07,2933.14,483968.10,0.00,0.00,0.00,0.00,0.00),('5','105','962','214902',4157924,'2855','432',64647.65,64647.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','214902',4157925,'2856','432',33420.26,36369.76,2949.50,486667.50,0.00,0.00,0.00,0.00,0.00),('5','105','963','214902',4157926,'2857','432',28101.36,28101.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','214902',4157927,'2858','432',59488.07,59488.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','214902',4157928,'2859','432',9213.24,12341.00,3127.76,516080.40,0.00,0.00,0.00,0.00,0.00),('5','105','964','214902',4157929,'2860','432',5759.74,8438.56,2678.82,442005.30,0.00,0.00,0.00,0.00,0.00),('5','105','965','214902',4157930,'2861','433',14354.09,14873.49,519.40,153223.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','214902',4157931,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','214902',4157932,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','216103',4178480,'2853','432',63100.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','216103',4178481,'2854','432',21997.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','216103',4178482,'2855','432',64647.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','216103',4178483,'2856','432',36369.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','216103',4178484,'2857','432',28101.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','216103',4178485,'2858','432',59488.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','216103',4178486,'2859','432',12341.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','216103',4178487,'2860','432',8438.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','216103',4178488,'2861','433',14873.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','216103',4178489,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','216103',4178490,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','216225',4180420,'2853','432',63100.22,63100.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','216225',4180421,'2854','432',21997.07,25358.96,3361.89,554711.85,0.00,0.00,0.00,0.00,0.00),('5','105','962','216225',4180422,'2855','432',64647.65,64647.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','216225',4180423,'2856','432',36369.76,38669.07,2299.31,379386.15,0.00,0.00,0.00,0.00,0.00),('5','105','963','216225',4180424,'2857','432',28101.36,28101.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','216225',4180425,'2858','432',59488.07,59488.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','216225',4180426,'2859','432',12341.00,15668.79,3327.79,549085.35,0.00,0.00,0.00,0.00,0.00),('5','105','964','216225',4180427,'2860','432',8438.56,11772.50,3333.94,550100.10,0.00,0.00,0.00,0.00,0.00),('5','105','965','216225',4180428,'2861','433',14873.49,15285.82,412.33,121637.35,0.00,0.00,0.00,0.00,0.00),('5','105','966','216225',4180429,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','216225',4180430,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','216253',4181005,'2853','432',63100.22,63100.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','216253',4181006,'2854','432',25358.96,28563.75,3204.79,528790.35,0.00,0.00,0.00,0.00,0.00),('5','105','962','216253',4181007,'2855','432',64647.65,64647.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','216253',4181008,'2856','432',38669.07,41634.63,2965.56,489317.40,0.00,0.00,0.00,0.00,0.00),('5','105','963','216253',4181009,'2857','432',28101.36,28101.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','216253',4181010,'2858','432',59488.07,59488.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','216253',4181011,'2859','432',15668.79,18911.46,3242.67,535040.55,0.00,0.00,0.00,0.00,0.00),('5','105','964','216253',4181012,'2860','432',11772.50,14634.62,2862.12,472249.80,0.00,0.00,0.00,0.00,0.00),('5','105','965','216253',4181013,'2861','433',15285.82,15771.78,485.96,143358.20,0.00,0.00,0.00,0.00,0.00),('5','105','966','216253',4181014,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','216253',4181015,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','216271',4181358,'2853','432',63100.22,65736.73,2636.51,435024.15,0.00,0.00,0.00,0.00,0.00),('5','105','961','216271',4181359,'2854','432',28563.75,31542.36,2978.61,491470.65,0.00,0.00,0.00,0.00,0.00),('5','105','962','216271',4181360,'2855','432',64647.65,65511.62,863.97,142555.05,0.00,0.00,0.00,0.00,0.00),('5','105','961','216271',4181361,'2856','432',41634.63,43482.82,1848.19,304951.35,0.00,0.00,0.00,0.00,0.00),('5','105','963','216271',4181362,'2857','432',28101.36,28101.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','216271',4181363,'2858','432',59488.07,59488.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','216271',4181364,'2859','432',18911.46,19966.74,1055.28,174121.20,0.00,0.00,0.00,0.00,0.00),('5','105','964','216271',4181365,'2860','432',14634.62,17368.88,2734.26,451152.90,0.00,0.00,0.00,0.00,0.00),('5','105','965','216271',4181366,'2861','433',15771.78,16549.56,777.78,229445.10,0.00,0.00,0.00,0.00,0.00),('5','105','966','216271',4181367,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','216271',4181368,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','216277',4181503,'2853','432',65736.73,68481.03,2744.30,452809.50,0.00,0.00,0.00,0.00,0.00),('5','105','961','216277',4181504,'2854','432',31542.36,34056.10,2513.74,414767.10,0.00,0.00,0.00,0.00,0.00),('5','105','962','216277',4181505,'2855','432',65511.62,68726.68,3215.06,530484.90,0.00,0.00,0.00,0.00,0.00),('5','105','961','216277',4181506,'2856','432',43482.82,46724.84,3242.02,534933.30,0.00,0.00,0.00,0.00,0.00),('5','105','963','216277',4181507,'2857','432',28101.36,28101.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','216277',4181508,'2858','432',59488.07,59488.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','216277',4181509,'2859','432',19966.74,19966.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','216277',4181510,'2860','432',17368.88,17648.32,279.44,46107.60,0.00,0.00,0.00,0.00,0.00),('5','105','965','216277',4181511,'2861','433',16549.56,17014.75,465.19,137231.05,0.00,0.00,0.00,0.00,0.00),('5','105','966','216277',4181512,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','216277',4181513,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','216289',4181803,'2853','432',68481.03,71033.82,2552.79,421210.35,0.00,0.00,0.00,0.00,0.00),('5','105','961','216289',4181804,'2854','432',34056.10,36871.28,2815.18,464504.70,0.00,0.00,0.00,0.00,0.00),('5','105','962','216289',4181805,'2855','432',68726.68,71959.06,3232.38,533342.70,0.00,0.00,0.00,0.00,0.00),('5','105','961','216289',4181806,'2856','432',46724.84,49288.94,2564.10,423076.50,0.00,0.00,0.00,0.00,0.00),('5','105','963','216289',4181807,'2857','432',28101.36,28101.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','216289',4181808,'2858','432',59488.07,59488.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','216289',4181809,'2859','432',19966.74,20485.96,519.22,85671.30,0.00,0.00,0.00,0.00,0.00),('5','105','964','216289',4181810,'2860','432',17648.32,17648.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','216289',4181811,'2861','433',17014.75,17506.96,492.21,145201.95,0.00,0.00,0.00,0.00,0.00),('5','105','966','216289',4181812,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','216289',4181813,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','216507',4185564,'2853','432',71033.82,74497.08,3463.26,571437.90,0.00,0.00,0.00,0.00,0.00),('5','105','961','216507',4185565,'2854','432',36871.28,37985.50,1114.22,183846.30,0.00,0.00,0.00,0.00,0.00),('5','105','962','216507',4185566,'2855','432',71959.06,75827.57,3868.51,638304.15,0.00,0.00,0.00,0.00,0.00),('5','105','961','216507',4185567,'2856','432',49288.94,49985.20,696.26,114882.90,0.00,0.00,0.00,0.00,0.00),('5','105','963','216507',4185568,'2857','432',28101.36,28101.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','216507',4185569,'2858','432',59488.07,59488.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','216507',4185570,'2859','432',20485.96,22541.39,2055.43,339145.95,0.00,0.00,0.00,0.00,0.00),('5','105','964','216507',4185571,'2860','432',17648.32,18847.48,1199.16,197861.40,0.00,0.00,0.00,0.00,0.00),('5','105','965','216507',4185572,'2861','433',17506.96,18089.47,582.51,171840.45,0.00,0.00,0.00,0.00,0.00),('5','105','966','216507',4185573,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','216507',4185574,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','216512',4185649,'2853','432',74497.08,78423.53,3926.45,647864.25,0.00,0.00,0.00,0.00,0.00),('5','105','961','216512',4185650,'2854','432',37985.50,37985.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','216512',4185651,'2855','432',75827.57,80132.73,4305.16,710351.40,0.00,0.00,0.00,0.00,0.00),('5','105','961','216512',4185652,'2856','432',49985.20,49985.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','216512',4185653,'2857','432',28101.36,28101.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','216512',4185654,'2858','432',59488.07,59488.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','216512',4185655,'2859','432',22541.39,24406.53,1865.14,307748.10,0.00,0.00,0.00,0.00,0.00),('5','105','964','216512',4185656,'2860','432',18847.48,19928.59,1081.11,178383.15,0.00,0.00,0.00,0.00,0.00),('5','105','965','216512',4185657,'2861','433',18089.47,18767.35,677.88,199974.60,0.00,0.00,0.00,0.00,0.00),('5','105','966','216512',4185658,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','216512',4185659,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','216532',4186024,'2853','432',78423.53,81199.20,2775.67,457985.55,0.00,0.00,0.00,0.00,0.00),('5','105','961','216532',4186025,'2854','432',37985.50,37985.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','216532',4186026,'2855','432',80132.73,83203.90,3071.17,506743.05,0.00,0.00,0.00,0.00,0.00),('5','105','961','216532',4186027,'2856','432',49985.20,49985.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','216532',4186028,'2857','432',28101.36,28101.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','216532',4186029,'2858','432',59488.07,59488.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','216532',4186030,'2859','432',24406.53,27437.60,3031.07,500126.55,0.00,0.00,0.00,0.00,0.00),('5','105','964','216532',4186031,'2860','432',19928.59,23128.24,3199.65,527942.25,0.00,0.00,0.00,0.00,0.00),('5','105','965','216532',4186032,'2861','433',18767.35,19307.68,540.33,159397.35,0.00,0.00,0.00,0.00,0.00),('5','105','966','216532',4186033,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','216532',4186034,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','216718',4189233,'2853','432',81199.20,83993.23,2794.03,461014.95,0.00,0.00,0.00,0.00,0.00),('5','105','961','216718',4189234,'2854','432',37985.50,37985.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','216718',4189235,'2855','432',83203.90,86214.50,3010.60,496749.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','216718',4189236,'2856','432',49985.20,49985.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','216718',4189237,'2857','432',28101.36,28101.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','216718',4189238,'2858','432',59488.07,59488.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','216718',4189239,'2859','432',27437.60,29935.37,2497.77,412132.05,0.00,0.00,0.00,0.00,0.00),('5','105','964','216718',4189240,'2860','432',23128.24,26243.39,3115.15,513999.75,0.00,0.00,0.00,0.00,0.00),('5','105','965','216718',4189241,'2861','433',19307.68,19851.10,543.42,160308.90,0.00,0.00,0.00,0.00,0.00),('5','105','966','216718',4189242,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','216718',4189243,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','216720',4189260,'2853','432',83993.23,86596.75,2603.52,429580.80,0.00,0.00,0.00,0.00,0.00),('5','105','961','216720',4189261,'2854','432',37985.50,37985.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','216720',4189262,'2855','432',86214.50,89425.15,3210.65,529757.25,0.00,0.00,0.00,0.00,0.00),('5','105','961','216720',4189263,'2856','432',49985.20,49985.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','216720',4189264,'2857','432',28101.36,28101.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','216720',4189265,'2858','432',59488.07,59488.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','216720',4189266,'2859','432',29935.37,32967.45,3032.08,500293.20,0.00,0.00,0.00,0.00,0.00),('5','105','964','216720',4189267,'2860','432',26243.39,29453.65,3210.26,529692.90,0.00,0.00,0.00,0.00,0.00),('5','105','965','216720',4189268,'2861','433',19851.10,20455.20,604.10,178209.50,0.00,0.00,0.00,0.00,0.00),('5','105','966','216720',4189269,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','216720',4189270,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','216724',4189394,'2853','432',86596.75,89401.72,2804.97,462820.05,0.00,0.00,0.00,0.00,0.00),('5','105','961','216724',4189395,'2854','432',37985.50,37985.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','216724',4189396,'2855','432',89425.15,91790.60,2365.45,390299.25,0.00,0.00,0.00,0.00,0.00),('5','105','961','216724',4189397,'2856','432',49985.20,49985.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','216724',4189398,'2857','432',28101.36,28101.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','216724',4189399,'2858','432',59488.07,59488.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','216724',4189400,'2859','432',32967.45,35627.54,2660.09,438914.85,0.00,0.00,0.00,0.00,0.00),('5','105','964','216724',4189401,'2860','432',29453.65,32343.87,2890.22,476886.30,0.00,0.00,0.00,0.00,0.00),('5','105','965','216724',4189402,'2861','433',20455.20,21105.72,650.52,191903.40,0.00,0.00,0.00,0.00,0.00),('5','105','966','216724',4189403,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','216724',4189404,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','216880',4191919,'2853','432',89401.72,92064.10,2662.38,439292.70,0.00,0.00,0.00,0.00,0.00),('5','105','961','216880',4191920,'2854','432',37985.50,37985.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','216880',4191921,'2855','432',91790.60,94229.81,2439.21,402469.65,0.00,0.00,0.00,0.00,0.00),('5','105','961','216880',4191922,'2856','432',49985.20,49985.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','216880',4191923,'2857','432',28101.36,28101.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','216880',4191924,'2858','432',59488.07,59488.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','216880',4191925,'2859','432',35627.54,38715.83,3088.29,509567.85,0.00,0.00,0.00,0.00,0.00),('5','105','964','216880',4191926,'2860','432',32343.87,35306.88,2963.01,488896.65,0.00,0.00,0.00,0.00,0.00),('5','105','965','216880',4191927,'2861','433',21105.72,21549.59,443.87,130941.65,0.00,0.00,0.00,0.00,0.00),('5','105','966','216880',4191928,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','216880',4191929,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','217084',4195398,'2853','432',92064.10,92596.68,532.58,87875.70,0.00,0.00,0.00,0.00,0.00),('5','105','961','217084',4195399,'2854','432',37985.50,40171.15,2185.65,360632.25,0.00,0.00,0.00,0.00,0.00),('5','105','962','217084',4195400,'2855','432',94229.81,94492.62,262.81,43363.65,0.00,0.00,0.00,0.00,0.00),('5','105','961','217084',4195401,'2856','432',49985.20,52684.73,2699.53,445422.45,0.00,0.00,0.00,0.00,0.00),('5','105','963','217084',4195402,'2857','432',28101.36,28101.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','217084',4195403,'2858','432',59488.07,59488.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','217084',4195404,'2859','432',38715.83,41488.78,2772.95,457536.75,0.00,0.00,0.00,0.00,0.00),('5','105','964','217084',4195405,'2860','432',35306.88,38463.09,3156.21,520774.65,0.00,0.00,0.00,0.00,0.00),('5','105','965','217084',4195406,'2861','433',21549.59,21976.41,426.82,125911.90,0.00,0.00,0.00,0.00,0.00),('5','105','966','217084',4195407,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','217084',4195408,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','217921',4210835,'2853','432',92596.68,92596.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','217921',4210836,'2854','432',40171.15,43036.36,2865.21,472759.65,0.00,0.00,0.00,0.00,0.00),('5','105','962','217921',4210837,'2855','432',94492.62,94492.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','217921',4210838,'2856','432',52684.73,55666.29,2981.56,491957.40,0.00,0.00,0.00,0.00,0.00),('5','105','963','217921',4210839,'2857','432',28101.36,28101.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','217921',4210840,'2858','432',59488.07,59488.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','217921',4210841,'2859','432',41488.78,44208.45,2719.67,448745.55,0.00,0.00,0.00,0.00,0.00),('5','105','964','217921',4210842,'2860','432',38463.09,41755.03,3291.94,543170.10,0.00,0.00,0.00,0.00,0.00),('5','105','965','217921',4210843,'2861','433',21976.41,22397.30,420.89,124162.55,0.00,0.00,0.00,0.00,0.00),('5','105','966','217921',4210844,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','217921',4210845,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','217926',4210917,'2853','432',92596.68,92596.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','217926',4210918,'2854','432',43036.36,45658.75,2622.39,432694.35,0.00,0.00,0.00,0.00,0.00),('5','105','962','217926',4210919,'2855','432',94492.62,94492.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','217926',4210920,'2856','432',55666.29,58486.83,2820.54,465389.10,0.00,0.00,0.00,0.00,0.00),('5','105','963','217926',4210921,'2857','432',28101.36,28101.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','217926',4210922,'2858','432',59488.07,59488.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','217926',4210923,'2859','432',44208.45,47069.13,2860.68,472012.20,0.00,0.00,0.00,0.00,0.00),('5','105','964','217926',4210924,'2860','432',41755.03,44871.03,3116.00,514140.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','217926',4210925,'2861','433',22397.30,22793.78,396.48,116961.60,0.00,0.00,0.00,0.00,0.00),('5','105','966','217926',4210926,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','217926',4210927,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','218035',4212483,'2853','432',92596.68,92596.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','218035',4212484,'2854','432',45658.75,50339.85,4681.10,772381.50,0.00,0.00,0.00,0.00,0.00),('5','105','962','218035',4212485,'2855','432',94492.62,94492.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','218035',4212486,'2856','432',58486.83,63126.65,4639.82,765570.30,0.00,0.00,0.00,0.00,0.00),('5','105','963','218035',4212487,'2857','432',28101.36,28101.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','218035',4212488,'2858','432',59488.07,59488.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','218035',4212489,'2859','432',47069.13,48164.79,1095.66,180783.90,0.00,0.00,0.00,0.00,0.00),('5','105','964','218035',4212490,'2860','432',44871.03,45462.18,591.15,97539.75,0.00,0.00,0.00,0.00,0.00),('5','105','965','218035',4212491,'2861','433',22793.78,23420.76,626.98,184959.10,0.00,0.00,0.00,0.00,0.00),('5','105','966','218035',4212492,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','218035',4212493,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','218078',4213221,'2853','432',92596.68,92596.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','218078',4213222,'2854','432',50339.85,56104.54,5764.69,951173.85,0.00,0.00,0.00,0.00,0.00),('5','105','962','218078',4213223,'2855','432',94492.62,94492.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','218078',4213224,'2856','432',63126.65,68418.83,5292.18,873209.70,0.00,0.00,0.00,0.00,0.00),('5','105','963','218078',4213225,'2857','432',28101.36,28101.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','218078',4213226,'2858','432',59488.07,59488.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','218078',4213227,'2859','432',48164.79,48164.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','218078',4213228,'2860','432',45462.18,45462.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','218078',4213229,'2861','433',23420.76,23957.84,537.08,158438.60,0.00,0.00,0.00,0.00,0.00),('5','105','966','218078',4213230,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','218078',4213231,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','218305',4217199,'2853','432',92596.68,92596.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','218305',4217200,'2854','432',56104.54,58863.24,2758.70,455185.50,0.00,0.00,0.00,0.00,0.00),('5','105','962','218305',4217201,'2855','432',94492.62,94492.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','218305',4217202,'2856','432',68418.83,71355.00,2936.17,484468.05,0.00,0.00,0.00,0.00,0.00),('5','105','963','218305',4217203,'2857','432',28101.36,31053.46,2952.10,487096.50,0.00,0.00,0.00,0.00,0.00),('5','105','963','218305',4217204,'2858','432',59488.07,62159.84,2671.77,440842.05,0.00,0.00,0.00,0.00,0.00),('5','105','964','218305',4217205,'2859','432',48164.79,48164.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','218305',4217206,'2860','432',45462.18,45462.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','218305',4217207,'2861','433',23957.84,24317.34,359.50,106052.50,0.00,0.00,0.00,0.00,0.00),('5','105','966','218305',4217208,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','218305',4217209,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','218548',4221629,'2853','432',92596.68,92596.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','218548',4221630,'2854','432',58863.24,61752.68,2889.44,476757.60,0.00,0.00,0.00,0.00,0.00),('5','105','962','218548',4221631,'2855','432',94492.62,94492.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','218548',4221632,'2856','432',71355.00,74096.45,2741.45,452339.25,0.00,0.00,0.00,0.00,0.00),('5','105','963','218548',4221633,'2857','432',31053.46,33834.13,2780.67,458810.55,0.00,0.00,0.00,0.00,0.00),('5','105','963','218548',4221634,'2858','432',62159.84,65195.62,3035.78,500903.70,0.00,0.00,0.00,0.00,0.00),('5','105','964','218548',4221635,'2859','432',48164.79,48164.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','218548',4221636,'2860','432',45462.18,45462.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','218548',4221637,'2861','433',24317.34,24788.46,471.12,138980.40,0.00,0.00,0.00,0.00,0.00),('5','105','966','218548',4221638,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','218548',4221639,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','218725',4224618,'2853','432',92596.68,92596.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','218725',4224619,'2854','432',61752.68,65236.78,3484.10,574876.50,0.00,0.00,0.00,0.00,0.00),('5','105','962','218725',4224620,'2855','432',94492.62,94492.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','218725',4224621,'2856','432',74096.45,77219.77,3123.32,515347.80,0.00,0.00,0.00,0.00,0.00),('5','105','963','218725',4224622,'2857','432',33834.13,36028.77,2194.64,362115.60,0.00,0.00,0.00,0.00,0.00),('5','105','963','218725',4224623,'2858','432',65195.62,68441.48,3245.86,535566.90,0.00,0.00,0.00,0.00,0.00),('5','105','964','218725',4224624,'2859','432',48164.79,48164.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','218725',4224625,'2860','432',45462.18,45462.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','218725',4224626,'2861','433',24788.46,25293.42,504.96,148963.20,0.00,0.00,0.00,0.00,0.00),('5','105','966','218725',4224627,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','218725',4224628,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','219106',4231491,'2853','432',92596.68,92596.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','219106',4231492,'2854','432',65236.78,67599.41,2362.63,389833.95,0.00,0.00,0.00,0.00,0.00),('5','105','962','219106',4231493,'2855','432',94492.62,94492.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','219106',4231494,'2856','432',77219.77,79215.37,1995.60,329274.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','219106',4231495,'2857','432',36028.77,39217.64,3188.87,526163.55,0.00,0.00,0.00,0.00,0.00),('5','105','963','219106',4231496,'2858','432',68441.48,71874.24,3432.76,566405.40,0.00,0.00,0.00,0.00,0.00),('5','105','964','219106',4231497,'2859','432',48164.79,48164.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','219106',4231498,'2860','432',45462.18,45462.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','219106',4231499,'2861','433',25293.42,25928.67,635.25,187398.75,0.00,0.00,0.00,0.00,0.00),('5','105','966','219106',4231500,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','219106',4231501,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','219213',4233025,'2853','432',92596.68,95719.62,3122.94,515285.10,0.00,0.00,0.00,0.00,0.00),('5','105','961','219213',4233026,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','219213',4233027,'2855','432',94492.62,97475.04,2982.42,492099.30,0.00,0.00,0.00,0.00,0.00),('5','105','961','219213',4233028,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','219213',4233029,'2857','432',39217.64,42218.95,3001.31,495216.15,0.00,0.00,0.00,0.00,0.00),('5','105','963','219213',4233030,'2858','432',71874.24,74795.07,2920.83,481936.95,0.00,0.00,0.00,0.00,0.00),('5','105','964','219213',4233031,'2859','432',48164.79,48164.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','219213',4233032,'2860','432',45462.18,45462.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','219213',4233033,'2861','433',25928.67,26333.40,404.73,119395.35,0.00,0.00,0.00,0.00,0.00),('5','105','966','219213',4233034,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','219213',4233035,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','219461',4237445,'2853','432',95719.62,98657.52,2937.90,484753.50,0.00,0.00,0.00,0.00,0.00),('5','105','961','219461',4237446,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','219461',4237447,'2855','432',97475.04,100611.17,3136.13,517461.45,0.00,0.00,0.00,0.00,0.00),('5','105','961','219461',4237448,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','219461',4237449,'2857','432',42218.95,45178.84,2959.89,488381.85,0.00,0.00,0.00,0.00,0.00),('5','105','963','219461',4237450,'2858','432',74795.07,77676.94,2881.87,475508.55,0.00,0.00,0.00,0.00,0.00),('5','105','964','219461',4237451,'2859','432',48164.79,48164.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','219461',4237452,'2860','432',45462.18,45462.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','219461',4237453,'2861','433',26333.40,27030.03,696.63,205505.85,0.00,0.00,0.00,0.00,0.00),('5','105','966','219461',4237454,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','219461',4237455,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','219754',4242809,'2853','432',98657.52,101587.77,2930.25,483491.25,0.00,0.00,0.00,0.00,0.00),('5','105','961','219754',4242810,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','219754',4242811,'2855','432',100611.17,103447.82,2836.65,468047.25,0.00,0.00,0.00,0.00,0.00),('5','105','961','219754',4242812,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','219754',4242813,'2857','432',45178.84,47909.95,2731.11,450633.15,0.00,0.00,0.00,0.00,0.00),('5','105','963','219754',4242814,'2858','432',77676.94,80564.75,2887.81,476488.65,0.00,0.00,0.00,0.00,0.00),('5','105','964','219754',4242815,'2859','432',48164.79,48164.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','219754',4242816,'2860','432',45462.18,45462.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','219754',4242817,'2861','433',27030.03,27315.31,285.28,84157.60,0.00,0.00,0.00,0.00,0.00),('5','105','966','219754',4242818,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','219754',4242819,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','219904',4245220,'2853','432',101587.77,103889.70,2301.93,379818.45,0.00,0.00,0.00,0.00,0.00),('5','105','961','219904',4245221,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','219904',4245222,'2855','432',103447.82,106298.12,2850.30,470299.50,0.00,0.00,0.00,0.00,0.00),('5','105','961','219904',4245223,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','219904',4245224,'2857','432',47909.95,50564.38,2654.43,437980.95,0.00,0.00,0.00,0.00,0.00),('5','105','963','219904',4245225,'2858','432',80564.75,82957.44,2392.69,394793.85,0.00,0.00,0.00,0.00,0.00),('5','105','964','219904',4245226,'2859','432',48164.79,48164.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','219904',4245227,'2860','432',45462.18,45462.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','219904',4245228,'2861','433',27315.31,27748.26,432.95,127720.25,0.00,0.00,0.00,0.00,0.00),('5','105','966','219904',4245229,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','219904',4245230,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','220040',4247858,'2853','432',103889.70,105013.02,1123.32,185347.80,0.00,0.00,0.00,0.00,0.00),('5','105','961','220040',4247859,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','220040',4247860,'2855','432',106298.12,109064.24,2766.12,456409.80,0.00,0.00,0.00,0.00,0.00),('5','105','961','220040',4247861,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','220040',4247862,'2857','432',50564.38,52639.16,2074.78,342338.70,0.00,0.00,0.00,0.00,0.00),('5','105','963','220040',4247863,'2858','432',82957.44,84490.38,1532.94,252935.10,0.00,0.00,0.00,0.00,0.00),('5','105','964','220040',4247864,'2859','432',48164.79,49933.41,1768.62,291822.30,0.00,0.00,0.00,0.00,0.00),('5','105','964','220040',4247865,'2860','432',45462.18,46905.45,1443.27,238139.55,0.00,0.00,0.00,0.00,0.00),('5','105','965','220040',4247866,'2861','433',27748.26,28066.12,317.86,93768.70,0.00,0.00,0.00,0.00,0.00),('5','105','966','220040',4247867,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','220040',4247868,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','220362',4253548,'2853','432',105013.02,107818.07,2805.05,462833.25,0.00,0.00,0.00,0.00,0.00),('5','105','961','220362',4253549,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','220362',4253550,'2855','432',109064.24,111412.96,2348.72,387538.80,0.00,0.00,0.00,0.00,0.00),('5','105','961','220362',4253551,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','220362',4253552,'2857','432',52639.16,52639.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','220362',4253553,'2858','432',84490.38,84490.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','220362',4253554,'2859','432',49933.41,53488.07,3554.66,586518.90,0.00,0.00,0.00,0.00,0.00),('5','105','964','220362',4253555,'2860','432',46905.45,49845.99,2940.54,485189.10,0.00,0.00,0.00,0.00,0.00),('5','105','965','220362',4253556,'2861','433',28066.12,28443.69,377.57,111383.15,0.00,0.00,0.00,0.00,0.00),('5','105','966','220362',4253557,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','220362',4253558,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','220575',4257346,'2853','432',107818.07,109752.37,1934.30,319159.50,0.00,0.00,0.00,0.00,0.00),('5','105','961','220575',4257347,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','220575',4257348,'2855','432',111412.96,113787.63,2374.67,391820.55,0.00,0.00,0.00,0.00,0.00),('5','105','961','220575',4257349,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','220575',4257350,'2857','432',52639.16,52639.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','220575',4257351,'2858','432',84490.38,84490.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','220575',4257352,'2859','432',53488.07,56064.51,2576.44,425112.60,0.00,0.00,0.00,0.00,0.00),('5','105','964','220575',4257353,'2860','432',49845.99,52032.79,2186.80,360822.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','220575',4257354,'2861','433',28443.69,28890.20,446.51,131720.45,0.00,0.00,0.00,0.00,0.00),('5','105','966','220575',4257355,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','220575',4257356,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','220893',4263118,'2853','432',109752.37,112245.49,2493.12,411364.80,0.00,0.00,0.00,0.00,0.00),('5','105','961','220893',4263119,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','220893',4263120,'2855','432',113787.63,116320.84,2533.21,417979.65,0.00,0.00,0.00,0.00,0.00),('5','105','961','220893',4263121,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','220893',4263122,'2857','432',52639.16,52639.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','220893',4263123,'2858','432',84490.38,84490.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','220893',4263124,'2859','432',56064.51,59300.09,3235.58,533870.70,0.00,0.00,0.00,0.00,0.00),('5','105','964','220893',4263125,'2860','432',52032.79,54979.94,2947.15,486279.75,0.00,0.00,0.00,0.00,0.00),('5','105','965','220893',4263126,'2861','433',28890.20,29354.28,464.08,136903.60,0.00,0.00,0.00,0.00,0.00),('5','105','966','220893',4263127,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','220893',4263128,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','220988',4264601,'2853','432',112245.49,112944.95,699.46,115410.90,0.00,0.00,0.00,0.00,0.00),('5','105','961','220988',4264602,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','220988',4264603,'2855','432',116320.84,118260.41,1939.57,320029.05,0.00,0.00,0.00,0.00,0.00),('5','105','961','220988',4264604,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','220988',4264605,'2857','432',52639.16,52985.58,346.42,57159.30,0.00,0.00,0.00,0.00,0.00),('5','105','963','220988',4264606,'2858','432',84490.38,84766.72,276.34,45596.10,0.00,0.00,0.00,0.00,0.00),('5','105','964','220988',4264607,'2859','432',59300.09,62699.72,3399.63,560938.95,0.00,0.00,0.00,0.00,0.00),('5','105','964','220988',4264608,'2860','432',54979.94,58700.89,3720.95,613956.75,0.00,0.00,0.00,0.00,0.00),('5','105','965','220988',4264609,'2861','433',29354.28,29530.80,176.52,52073.40,0.00,0.00,0.00,0.00,0.00),('5','105','966','220988',4264610,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','220988',4264611,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','221278',4269609,'2853','432',112944.95,112944.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','221278',4269610,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','221278',4269611,'2855','432',118260.41,118260.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','221278',4269612,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','221278',4269613,'2857','432',52985.58,55668.01,2682.43,442600.95,0.00,0.00,0.00,0.00,0.00),('5','105','963','221278',4269614,'2858','432',84766.72,87043.95,2277.23,375742.95,0.00,0.00,0.00,0.00,0.00),('5','105','964','221278',4269615,'2859','432',62699.72,65848.35,3148.63,519523.95,0.00,0.00,0.00,0.00,0.00),('5','105','964','221278',4269616,'2860','432',58700.89,61700.46,2999.57,494929.05,0.00,0.00,0.00,0.00,0.00),('5','105','965','221278',4269617,'2861','433',29530.80,29530.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','221278',4269618,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','221278',4269619,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','221607',4276002,'2853','432',112944.95,112944.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','221607',4276003,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','221607',4276004,'2855','432',118260.41,118260.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','221607',4276005,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','221607',4276006,'2857','432',55668.01,58919.83,3251.82,536550.30,0.00,0.00,0.00,0.00,0.00),('5','105','963','221607',4276007,'2858','432',87043.95,90314.96,3271.01,539716.65,0.00,0.00,0.00,0.00,0.00),('5','105','964','221607',4276008,'2859','432',65848.35,69069.26,3220.91,531450.15,0.00,0.00,0.00,0.00,0.00),('5','105','964','221607',4276009,'2860','432',61700.46,63824.68,2124.22,350496.30,0.00,0.00,0.00,0.00,0.00),('5','105','965','221607',4276010,'2861','433',29530.80,29941.33,410.53,121106.35,0.00,0.00,0.00,0.00,0.00),('5','105','966','221607',4276011,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','221607',4276012,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','221716',4277680,'2853','432',112944.95,112944.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','221716',4277681,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','221716',4277682,'2855','432',118260.41,118260.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','221716',4277683,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','221716',4277684,'2857','432',58919.83,62213.24,3293.41,543412.65,0.00,0.00,0.00,0.00,0.00),('5','105','963','221716',4277685,'2858','432',90314.96,93382.77,3067.81,506188.65,0.00,0.00,0.00,0.00,0.00),('5','105','964','221716',4277686,'2859','432',69069.26,72574.30,3505.04,578331.60,0.00,0.00,0.00,0.00,0.00),('5','105','964','221716',4277687,'2860','432',63824.68,65722.85,1898.17,313198.05,0.00,0.00,0.00,0.00,0.00),('5','105','965','221716',4277688,'2861','433',29941.33,30476.36,535.03,157833.85,0.00,0.00,0.00,0.00,0.00),('5','105','966','221716',4277689,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','221716',4277690,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','222003',4282968,'2853','432',112944.95,112944.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','222003',4282969,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','222003',4282970,'2855','432',118260.41,118260.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','222003',4282971,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','222003',4282972,'2857','432',62213.24,65543.01,3329.77,549412.05,0.00,0.00,0.00,0.00,0.00),('5','105','963','222003',4282973,'2858','432',93382.77,96187.80,2805.03,462829.95,0.00,0.00,0.00,0.00,0.00),('5','105','964','222003',4282974,'2859','432',72574.30,75502.15,2927.85,483095.25,0.00,0.00,0.00,0.00,0.00),('5','105','964','222003',4282975,'2860','432',65722.85,67543.14,1820.29,300347.85,0.00,0.00,0.00,0.00,0.00),('5','105','965','222003',4282976,'2861','433',30476.36,30804.11,327.75,96686.25,0.00,0.00,0.00,0.00,0.00),('5','105','966','222003',4282977,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','222003',4282978,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','222296',4287759,'2853','432',112944.95,112944.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','222296',4287760,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','222296',4287761,'2855','432',118260.41,118260.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','222296',4287762,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','222296',4287763,'2857','432',65543.01,70428.88,4885.87,806168.55,0.00,0.00,0.00,0.00,0.00),('5','105','963','222296',4287764,'2858','432',96187.80,100637.02,4449.22,734121.30,0.00,0.00,0.00,0.00,0.00),('5','105','964','222296',4287765,'2859','432',75502.15,76526.68,1024.53,169047.45,0.00,0.00,0.00,0.00,0.00),('5','105','964','222296',4287766,'2860','432',67543.14,68738.23,1195.09,197189.85,0.00,0.00,0.00,0.00,0.00),('5','105','965','222296',4287767,'2861','433',30804.11,31179.23,375.12,110660.40,0.00,0.00,0.00,0.00,0.00),('5','105','966','222296',4287768,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','222296',4287769,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','222435',4290390,'2853','432',112944.95,112944.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','222435',4290391,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','222435',4290392,'2855','432',118260.41,118260.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','222435',4290393,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','222435',4290394,'2857','432',70428.88,73060.20,2631.32,434167.80,0.00,0.00,0.00,0.00,0.00),('5','105','963','222435',4290395,'2858','432',100637.02,103552.18,2915.16,481001.40,0.00,0.00,0.00,0.00,0.00),('5','105','964','222435',4290396,'2859','432',76526.68,79497.94,2971.26,490257.90,0.00,0.00,0.00,0.00,0.00),('5','105','964','222435',4290397,'2860','432',68738.23,71398.23,2660.00,438900.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','222435',4290398,'2861','433',31179.23,31407.68,228.45,67392.75,0.00,0.00,0.00,0.00,0.00),('5','105','966','222435',4290399,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','222435',4290400,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','222585',4292771,'2853','432',112944.95,112944.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','222585',4292772,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','222585',4292773,'2855','432',118260.41,118260.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','222585',4292774,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','222585',4292775,'2857','432',73060.20,75352.85,2292.65,378287.25,0.00,0.00,0.00,0.00,0.00),('5','105','963','222585',4292776,'2858','432',103552.18,105961.38,2409.20,397518.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','222585',4292777,'2859','432',79497.94,82742.91,3244.97,535420.05,0.00,0.00,0.00,0.00,0.00),('5','105','964','222585',4292778,'2860','432',71398.23,73954.09,2555.86,421716.90,0.00,0.00,0.00,0.00,0.00),('5','105','965','222585',4292779,'2861','433',31407.68,31835.73,428.05,126274.75,0.00,0.00,0.00,0.00,0.00),('5','105','966','222585',4292780,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','222585',4292781,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','222888',4298680,'2853','432',112944.95,112944.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','222888',4298681,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','222888',4298682,'2855','432',118260.41,118260.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','222888',4298683,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','222888',4298684,'2857','432',75352.85,77274.84,1921.99,317128.35,0.00,0.00,0.00,0.00,0.00),('5','105','963','222888',4298685,'2858','432',105961.38,107360.81,1399.43,230905.95,0.00,0.00,0.00,0.00,0.00),('5','105','964','222888',4298686,'2859','432',82742.91,84979.32,2236.41,369007.65,0.00,0.00,0.00,0.00,0.00),('5','105','964','222888',4298687,'2860','432',73954.09,76197.05,2242.96,370088.40,0.00,0.00,0.00,0.00,0.00),('5','105','965','222888',4298688,'2861','433',31835.73,32094.74,259.01,76407.95,0.00,0.00,0.00,0.00,0.00),('5','105','966','222888',4298689,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','222888',4298690,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','223013',4300928,'2853','432',112944.95,112944.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','223013',4300929,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','223013',4300930,'2855','432',118260.41,118260.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','223013',4300931,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','223013',4300932,'2857','432',77274.84,78104.40,829.56,136877.40,0.00,0.00,0.00,0.00,0.00),('5','105','963','223013',4300933,'2858','432',107360.81,108117.24,756.43,124810.95,0.00,0.00,0.00,0.00,0.00),('5','105','964','223013',4300934,'2859','432',84979.32,87181.42,2202.10,363346.50,0.00,0.00,0.00,0.00,0.00),('5','105','964','223013',4300935,'2860','432',76197.05,77968.12,1771.07,292226.55,0.00,0.00,0.00,0.00,0.00),('5','105','965','223013',4300936,'2861','433',32094.74,32449.72,354.98,104719.10,0.00,0.00,0.00,0.00,0.00),('5','105','966','223013',4300937,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','223013',4300938,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','223305',4305582,'2853','432',112944.95,112944.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','223305',4305583,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','223305',4305584,'2855','432',118260.41,118260.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','223305',4305585,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','223305',4305586,'2857','432',78104.40,80307.71,2203.31,363546.15,0.00,0.00,0.00,0.00,0.00),('5','105','963','223305',4305587,'2858','432',108117.24,110138.87,2021.63,333568.95,0.00,0.00,0.00,0.00,0.00),('5','105','964','223305',4305588,'2859','432',87181.42,89839.09,2657.67,438515.55,0.00,0.00,0.00,0.00,0.00),('5','105','964','223305',4305589,'2860','432',77968.12,79969.56,2001.44,330237.60,0.00,0.00,0.00,0.00,0.00),('5','105','965','223305',4305590,'2861','433',32449.72,32932.89,483.17,142535.15,0.00,0.00,0.00,0.00,0.00),('5','105','966','223305',4305591,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','223305',4305592,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','223637',4312010,'2853','432',112944.95,112944.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','223637',4312011,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','223637',4312012,'2855','432',118260.41,118260.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','223637',4312013,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','223637',4312014,'2857','432',80307.71,82919.26,2611.55,430905.75,0.00,0.00,0.00,0.00,0.00),('5','105','963','223637',4312015,'2858','432',110138.87,112421.09,2282.22,376566.30,0.00,0.00,0.00,0.00,0.00),('5','105','964','223637',4312016,'2859','432',89839.09,93425.04,3585.95,591681.75,0.00,0.00,0.00,0.00,0.00),('5','105','964','223637',4312017,'2860','432',79969.56,82236.87,2267.31,374106.15,0.00,0.00,0.00,0.00,0.00),('5','105','965','223637',4312018,'2861','433',32932.89,33285.40,352.51,103990.45,0.00,0.00,0.00,0.00,0.00),('5','105','966','223637',4312019,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','223637',4312020,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','223684',4312647,'2853','432',112944.95,112944.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','223684',4312648,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','223684',4312649,'2855','432',118260.41,118260.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','223684',4312650,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','223684',4312651,'2857','432',82919.26,85259.30,2340.04,386106.60,0.00,0.00,0.00,0.00,0.00),('5','105','963','223684',4312652,'2858','432',112421.09,114126.86,1705.77,281452.05,0.00,0.00,0.00,0.00,0.00),('5','105','964','223684',4312653,'2859','432',93425.04,96375.13,2950.09,486764.85,0.00,0.00,0.00,0.00,0.00),('5','105','964','223684',4312654,'2860','432',82236.87,85188.64,2951.77,487042.05,0.00,0.00,0.00,0.00,0.00),('5','105','965','223684',4312655,'2861','433',33285.40,33729.08,443.68,130885.60,0.00,0.00,0.00,0.00,0.00),('5','105','966','223684',4312656,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','223684',4312657,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','224124',4320546,'2853','432',112944.95,112944.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','224124',4320547,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','224124',4320548,'2855','432',118260.41,118260.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','224124',4320549,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','224124',4320550,'2857','432',85259.30,85259.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','224124',4320551,'2858','432',114126.86,114126.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','224124',4320552,'2859','432',96375.13,100758.47,4383.34,723251.10,0.00,0.00,0.00,0.00,0.00),('5','105','964','224124',4320553,'2860','432',85188.64,89186.82,3998.18,659699.70,0.00,0.00,0.00,0.00,0.00),('5','105','965','224124',4320554,'2861','433',33729.08,34002.40,273.32,80629.40,0.00,0.00,0.00,0.00,0.00),('5','105','966','224124',4320555,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','224124',4320556,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','224288',4323921,'2853','432',112944.95,112944.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','224288',4323922,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','224288',4323923,'2855','432',118260.41,118260.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','224288',4323924,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','224288',4323925,'2857','432',85259.30,85259.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','224288',4323926,'2858','432',114126.86,114126.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','224288',4323927,'2859','432',100758.47,101328.35,569.88,94030.20,0.00,0.00,0.00,0.00,0.00),('5','105','964','224288',4323928,'2860','432',89186.82,89748.76,561.94,92720.10,0.00,0.00,0.00,0.00,0.00),('5','105','965','224288',4323929,'2861','433',34002.40,34282.51,280.11,82632.45,0.00,0.00,0.00,0.00,0.00),('5','105','966','224288',4323930,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','224288',4323931,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','224372',4324980,'2853','432',112944.95,112944.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','224372',4324981,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','224372',4324982,'2855','432',118260.41,118260.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','224372',4324983,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','224372',4324984,'2857','432',85259.30,85259.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','224372',4324985,'2858','432',114126.86,114126.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','224372',4324986,'2859','432',101328.35,106394.03,5065.68,835837.20,0.00,0.00,0.00,0.00,0.00),('5','105','964','224372',4324987,'2860','432',89748.76,94313.12,4564.36,753119.40,0.00,0.00,0.00,0.00,0.00),('5','105','965','224372',4324988,'2861','433',34282.51,34616.18,333.67,98432.65,0.00,0.00,0.00,0.00,0.00),('5','105','966','224372',4324989,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','224372',4324990,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','224622',4329410,'2853','432',112944.95,112944.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','224622',4329411,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','224622',4329412,'2855','432',118260.41,118260.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','224622',4329413,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','224622',4329414,'2857','432',85259.30,85259.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','224622',4329415,'2858','432',114126.86,114126.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','224622',4329416,'2859','432',106394.03,109543.96,3149.93,519738.45,0.00,0.00,0.00,0.00,0.00),('5','105','964','224622',4329417,'2860','432',94313.12,97290.93,2977.81,491338.65,0.00,0.00,0.00,0.00,0.00),('5','105','965','224622',4329418,'2861','433',34616.18,34996.11,379.93,112079.35,0.00,0.00,0.00,0.00,0.00),('5','105','966','224622',4329419,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','224622',4329420,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','224855',4333456,'2853','432',112944.95,112944.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','224855',4333457,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','224855',4333458,'2855','432',118260.41,118260.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','224855',4333459,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','224855',4333460,'2857','432',85259.30,85259.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','224855',4333461,'2858','432',114126.86,114126.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','224855',4333462,'2859','432',109543.96,114395.24,4851.28,790758.64,0.00,0.00,0.00,0.00,0.00),('5','105','964','224855',4333463,'2860','432',97290.93,102267.89,4976.96,811244.48,0.00,0.00,0.00,0.00,0.00),('5','105','965','224855',4333464,'2861','433',34996.11,35428.07,431.96,127428.20,0.00,0.00,0.00,0.00,0.00),('5','105','966','224855',4333465,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','224855',4333466,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','225077',4337452,'2853','432',112944.95,112944.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','225077',4337453,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','225077',4337454,'2855','432',118260.41,118260.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','225077',4337455,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','225077',4337456,'2857','432',85259.30,86800.52,1541.22,251218.86,0.00,0.00,0.00,0.00,0.00),('5','105','963','225077',4337457,'2858','432',114126.86,115435.97,1309.11,213384.93,0.00,0.00,0.00,0.00,0.00),('5','105','964','225077',4337458,'2859','432',114395.24,118041.53,3646.29,594345.27,0.00,0.00,0.00,0.00,0.00),('5','105','964','225077',4337459,'2860','432',102267.89,105628.81,3360.92,547829.96,0.00,0.00,0.00,0.00,0.00),('5','105','965','225077',4337460,'2861','433',35428.07,35913.68,485.61,143254.95,0.00,0.00,0.00,0.00,0.00),('5','105','966','225077',4337461,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','225077',4337462,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','225726',4349024,'2853','432',112944.95,112944.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','225726',4349025,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','225726',4349026,'2855','432',118260.41,118260.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','225726',4349027,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','225726',4349028,'2857','432',86800.52,89831.45,3030.93,494041.59,0.00,0.00,0.00,0.00,0.00),('5','105','963','225726',4349029,'2858','432',115435.97,116944.71,1508.74,245924.62,0.00,0.00,0.00,0.00,0.00),('5','105','964','225726',4349030,'2859','432',118041.53,121348.12,3306.59,538974.17,0.00,0.00,0.00,0.00,0.00),('5','105','964','225726',4349031,'2860','432',105628.81,108615.04,2986.23,486755.49,0.00,0.00,0.00,0.00,0.00),('5','105','965','225726',4349032,'2861','433',35913.68,36231.07,317.39,93630.05,0.00,0.00,0.00,0.00,0.00),('5','105','966','225726',4349033,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','225726',4349034,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','225773',4349891,'2853','432',112944.95,112944.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','225773',4349892,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','225773',4349893,'2855','432',118260.41,118260.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','225773',4349894,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','225773',4349895,'2857','432',89831.45,92371.41,2539.96,414013.48,0.00,0.00,0.00,0.00,0.00),('5','105','963','225773',4349896,'2858','432',116944.71,118954.01,2009.30,327515.90,0.00,0.00,0.00,0.00,0.00),('5','105','964','225773',4349897,'2859','432',121348.12,124570.37,3222.25,525226.75,0.00,0.00,0.00,0.00,0.00),('5','105','964','225773',4349898,'2860','432',108615.04,111720.16,3105.12,506134.56,0.00,0.00,0.00,0.00,0.00),('5','105','965','225773',4349899,'2861','433',36231.07,36231.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','225773',4349900,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','225773',4349901,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','225786',4350126,'2853','432',112944.95,112944.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','225786',4350127,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','225786',4350128,'2855','432',118260.41,118260.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','225786',4350129,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','225786',4350130,'2857','432',92371.41,96163.55,3792.14,618118.82,0.00,0.00,0.00,0.00,0.00),('5','105','963','225786',4350131,'2858','432',118954.01,121442.54,2488.53,405630.39,0.00,0.00,0.00,0.00,0.00),('5','105','964','225786',4350132,'2859','432',124570.37,128390.48,3820.11,622677.93,0.00,0.00,0.00,0.00,0.00),('5','105','964','225786',4350133,'2860','432',111720.16,112236.79,516.63,84210.69,0.00,0.00,0.00,0.00,0.00),('5','105','965','225786',4350134,'2861','433',36231.07,36231.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','225786',4350135,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','225786',4350136,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','226057',4354882,'2853','432',112944.95,112944.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','226057',4354883,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','226057',4354884,'2855','432',118260.41,118260.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','226057',4354885,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','226057',4354886,'2857','432',96163.55,101042.82,4879.27,795321.01,0.00,0.00,0.00,0.00,0.00),('5','105','963','226057',4354887,'2858','432',121442.54,125264.82,3822.28,623031.64,0.00,0.00,0.00,0.00,0.00),('5','105','964','226057',4354888,'2859','432',128390.48,129215.02,824.54,134400.02,0.00,0.00,0.00,0.00,0.00),('5','105','964','226057',4354889,'2860','432',112236.79,112236.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','226057',4354890,'2861','433',36231.07,36231.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','226057',4354891,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','226057',4354892,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','226328',4359847,'2853','432',112944.95,112944.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','226328',4359848,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','226328',4359849,'2855','432',118260.41,118260.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','226328',4359850,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','226328',4359851,'2857','432',101042.82,103367.90,2325.08,378988.04,0.00,0.00,0.00,0.00,0.00),('5','105','963','226328',4359852,'2858','432',125264.82,126722.01,1457.19,237521.97,0.00,0.00,0.00,0.00,0.00),('5','105','964','226328',4359853,'2859','432',129215.02,132259.05,3044.03,496176.89,0.00,0.00,0.00,0.00,0.00),('5','105','964','226328',4359854,'2860','432',112236.79,114910.08,2673.29,435746.27,0.00,0.00,0.00,0.00,0.00),('5','105','965','226328',4359855,'2861','433',36231.07,36231.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','226328',4359856,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','226328',4359857,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','226561',4363857,'2853','432',112944.95,112944.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','226561',4363858,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','226561',4363859,'2855','432',118260.41,118260.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','226561',4363860,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','226561',4363861,'2857','432',103367.90,106188.41,2820.51,459743.13,0.00,0.00,0.00,0.00,0.00),('5','105','963','226561',4363862,'2858','432',126722.01,126922.16,200.15,32624.45,0.00,0.00,0.00,0.00,0.00),('5','105','964','226561',4363863,'2859','432',132259.05,135746.46,3487.41,568447.83,0.00,0.00,0.00,0.00,0.00),('5','105','964','226561',4363864,'2860','432',114910.08,117977.39,3067.31,499971.53,0.00,0.00,0.00,0.00,0.00),('5','105','965','226561',4363865,'2861','433',36231.07,36231.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','226561',4363866,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','226561',4363867,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','226782',4367958,'2853','432',112944.95,112944.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','226782',4367959,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','226782',4367960,'2855','432',118260.41,118260.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','226782',4367961,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','226782',4367962,'2857','432',106188.41,109237.31,3048.90,496970.70,0.00,0.00,0.00,0.00,0.00),('5','105','963','226782',4367963,'2858','432',126922.16,126922.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','226782',4367964,'2859','432',135746.46,139328.75,3582.29,583913.27,0.00,0.00,0.00,0.00,0.00),('5','105','964','226782',4367965,'2860','432',117977.39,121537.62,3560.23,580317.49,0.00,0.00,0.00,0.00,0.00),('5','105','965','226782',4367966,'2861','433',36231.07,36231.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','226782',4367967,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','226782',4367968,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','227207',4375484,'2853','432',112944.95,112944.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','227207',4375485,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','227207',4375486,'2855','432',118260.41,118260.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','227207',4375487,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','227207',4375488,'2857','432',109237.31,112470.43,3233.12,526998.56,0.00,0.00,0.00,0.00,0.00),('5','105','963','227207',4375489,'2858','432',126922.16,126922.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','227207',4375490,'2859','432',139328.75,142603.66,3274.91,533810.33,0.00,0.00,0.00,0.00,0.00),('5','105','964','227207',4375491,'2860','432',121537.62,125395.05,3857.43,628761.09,0.00,0.00,0.00,0.00,0.00),('5','105','965','227207',4375492,'2861','433',36231.07,36231.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','227207',4375493,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','227207',4375494,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','227456',4380023,'2853','432',112944.95,112944.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','227456',4380024,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','227456',4380025,'2855','432',118260.41,118260.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','227456',4380026,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','227456',4380027,'2857','432',112470.43,116282.71,3812.28,621401.64,0.00,0.00,0.00,0.00,0.00),('5','105','963','227456',4380028,'2858','432',126922.16,126922.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','227456',4380029,'2859','432',142603.66,146476.44,3872.78,631263.14,0.00,0.00,0.00,0.00,0.00),('5','105','964','227456',4380030,'2860','432',125395.05,128672.05,3277.00,534151.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','227456',4380031,'2861','433',36231.07,36231.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','227456',4380032,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','227456',4380033,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','227577',4382182,'2853','432',112944.95,112944.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','227577',4382183,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','227577',4382184,'2855','432',118260.41,118260.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','227577',4382185,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','227577',4382186,'2857','432',116282.71,119847.28,3564.57,581024.91,0.00,0.00,0.00,0.00,0.00),('5','105','963','227577',4382187,'2858','432',126922.16,126922.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','227577',4382188,'2859','432',146476.44,150244.25,3767.81,614153.03,0.00,0.00,0.00,0.00,0.00),('5','105','964','227577',4382189,'2860','432',128672.05,131931.49,3259.44,531288.72,0.00,0.00,0.00,0.00,0.00),('5','105','965','227577',4382190,'2861','433',36231.07,36231.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','227577',4382191,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','227577',4382192,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','227776',4385707,'2853','432',112944.95,112944.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','227776',4385708,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','227776',4385709,'2855','432',118260.41,118260.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','227776',4385710,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','227776',4385711,'2857','432',119847.28,121304.02,1456.74,237448.62,0.00,0.00,0.00,0.00,0.00),('5','105','963','227776',4385712,'2858','432',126922.16,126922.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','227776',4385713,'2859','432',150244.25,154730.01,4485.76,731178.88,0.00,0.00,0.00,0.00,0.00),('5','105','964','227776',4385714,'2860','432',131931.49,135729.98,3798.49,619153.87,0.00,0.00,0.00,0.00,0.00),('5','105','965','227776',4385715,'2861','433',36231.07,36231.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','227776',4385716,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','227776',4385717,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','227935',4388417,'2853','432',112944.95,117818.67,4873.72,794416.36,0.00,0.00,0.00,0.00,0.00),('5','105','961','227935',4388418,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','227935',4388419,'2855','432',118260.41,122939.59,4679.18,762706.34,0.00,0.00,0.00,0.00,0.00),('5','105','961','227935',4388420,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','227935',4388421,'2857','432',121304.02,121304.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','227935',4388422,'2858','432',126922.16,126922.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','227935',4388423,'2859','432',154730.01,154730.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','227935',4388424,'2860','432',135729.98,135729.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','227935',4388425,'2861','433',36231.07,36231.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','227935',4388426,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','227935',4388427,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','229384',4415888,'2853','432',117818.67,122583.97,4765.30,776743.90,0.00,0.00,0.00,0.00,0.00),('5','105','961','229384',4415889,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','229384',4415890,'2855','432',122939.59,128086.00,5146.41,838864.83,0.00,0.00,0.00,0.00,0.00),('5','105','961','229384',4415891,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','229384',4415892,'2857','432',121304.02,121304.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','229384',4415893,'2858','432',126922.16,126922.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','229384',4415894,'2859','432',154730.01,154730.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','229384',4415895,'2860','432',135729.98,135729.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','229384',4415896,'2861','433',36231.07,36231.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','229384',4415897,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','229384',4415898,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','229761',4422926,'2853','432',122583.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','229761',4422927,'2854','432',67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','229761',4422928,'2855','432',128086.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','229761',4422929,'2856','432',79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','229761',4422930,'2857','432',121304.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','229761',4422931,'2858','432',126922.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','229761',4422932,'2859','432',154730.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','229761',4422933,'2860','432',135729.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','229761',4422934,'2861','433',36231.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','229761',4422935,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','229761',4422936,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','229764',4422967,'2853','432',122583.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','229764',4422968,'2854','432',67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','229764',4422969,'2855','432',128086.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','229764',4422970,'2856','432',79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','229764',4422971,'2857','432',121304.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','229764',4422972,'2858','432',126922.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','229764',4422973,'2859','432',154730.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','229764',4422974,'2860','432',135729.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','229764',4422975,'2861','433',36231.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','229764',4422976,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','229764',4422977,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','229825',4424356,'2853','432',122583.97,127203.52,4619.55,752986.65,0.00,0.00,0.00,0.00,0.00),('5','105','961','229825',4424357,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','229825',4424358,'2855','432',128086.00,133280.36,5194.36,846680.68,0.00,0.00,0.00,0.00,0.00),('5','105','961','229825',4424359,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','229825',4424360,'2857','432',121304.02,121304.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','229825',4424361,'2858','432',126922.16,126922.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','229825',4424362,'2859','432',154730.01,154730.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','229825',4424363,'2860','432',135729.98,135729.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','229825',4424364,'2861','433',36231.07,36231.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','229825',4424365,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','229825',4424366,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','229848',4425075,'2853','432',127203.52,128709.60,1506.08,245491.04,0.00,0.00,0.00,0.00,0.00),('5','105','961','229848',4425076,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','229848',4425077,'2855','432',133280.36,134424.51,1144.15,186496.45,0.00,0.00,0.00,0.00,0.00),('5','105','961','229848',4425078,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','229848',4425079,'2857','432',121304.02,121304.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','229848',4425080,'2858','432',126922.16,126922.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','229848',4425081,'2859','432',154730.01,154730.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','229848',4425082,'2860','432',135729.98,135729.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','229848',4425083,'2861','433',36231.07,36231.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','229848',4425084,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','229848',4425085,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','230171',4430795,'2853','432',128709.60,128709.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','230171',4430796,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','230171',4430797,'2855','432',134424.51,134424.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','230171',4430798,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','230171',4430799,'2857','432',121304.02,123240.89,1936.87,315709.81,0.00,0.00,0.00,0.00,0.00),('5','105','963','230171',4430800,'2858','432',126922.16,126922.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','230171',4430801,'2859','432',154730.01,158131.23,3401.22,554398.86,0.00,0.00,0.00,0.00,0.00),('5','105','964','230171',4430802,'2860','432',135729.98,139351.62,3621.64,590327.32,0.00,0.00,0.00,0.00,0.00),('5','105','965','230171',4430803,'2861','433',36231.07,36231.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','230171',4430804,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','230171',4430805,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','230173',4430824,'2853','432',128709.60,128709.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','230173',4430825,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','230173',4430826,'2855','432',134424.51,134424.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','230173',4430827,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','230173',4430828,'2857','432',123240.89,124638.95,1398.06,227883.78,0.00,0.00,0.00,0.00,0.00),('5','105','963','230173',4430829,'2858','432',126922.16,126922.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','230173',4430830,'2859','432',158131.23,161996.45,3865.22,630030.86,0.00,0.00,0.00,0.00,0.00),('5','105','964','230173',4430831,'2860','432',139351.62,143822.69,4471.07,728784.41,0.00,0.00,0.00,0.00,0.00),('5','105','965','230173',4430832,'2861','433',36231.07,36231.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','230173',4430833,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','230173',4430834,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','230174',4430835,'2853','432',128709.60,128709.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','230174',4430836,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','230174',4430837,'2855','432',134424.51,134424.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','230174',4430838,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','230174',4430839,'2857','432',124638.95,127594.76,2955.81,481797.03,0.00,0.00,0.00,0.00,0.00),('5','105','963','230174',4430840,'2858','432',126922.16,128008.75,1086.59,177114.17,0.00,0.00,0.00,0.00,0.00),('5','105','964','230174',4430841,'2859','432',161996.45,165116.20,3119.75,508519.25,0.00,0.00,0.00,0.00,0.00),('5','105','964','230174',4430842,'2860','432',143822.69,147057.53,3234.84,527278.92,0.00,0.00,0.00,0.00,0.00),('5','105','965','230174',4430843,'2861','433',36231.07,36231.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','230174',4430844,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','230174',4430845,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','230177',4430875,'2853','432',128709.60,128709.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','230177',4430876,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','230177',4430877,'2855','432',134424.51,134424.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','230177',4430878,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','230177',4430879,'2857','432',127594.76,130280.54,2685.78,437782.14,0.00,0.00,0.00,0.00,0.00),('5','105','963','230177',4430880,'2858','432',128008.75,128630.17,621.42,101291.46,0.00,0.00,0.00,0.00,0.00),('5','105','964','230177',4430881,'2859','432',165116.20,168304.62,3188.42,519712.46,0.00,0.00,0.00,0.00,0.00),('5','105','964','230177',4430882,'2860','432',147057.53,150336.06,3278.53,534400.39,0.00,0.00,0.00,0.00,0.00),('5','105','965','230177',4430883,'2861','433',36231.07,36231.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','230177',4430884,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','230177',4430885,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','230178',4430886,'2853','432',128709.60,128709.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','230178',4430887,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','230178',4430888,'2855','432',134424.51,134424.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','230178',4430889,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','230178',4430890,'2857','432',130280.54,133959.29,3678.75,599636.25,0.00,0.00,0.00,0.00,0.00),('5','105','963','230178',4430891,'2858','432',128630.17,128630.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','230178',4430892,'2859','432',168304.62,169532.84,1228.22,200199.86,0.00,0.00,0.00,0.00,0.00),('5','105','964','230178',4430893,'2860','432',150336.06,150336.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','230178',4430894,'2861','433',36231.07,36231.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','230178',4430895,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','230178',4430896,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','230180',4430906,'2853','432',128709.60,128709.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','230180',4430907,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','230180',4430908,'2855','432',134424.51,134424.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','230180',4430909,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','230180',4430910,'2857','432',133959.29,134343.81,384.52,62676.76,0.00,0.00,0.00,0.00,0.00),('5','105','963','230180',4430911,'2858','432',128630.17,128680.18,50.01,8151.63,0.00,0.00,0.00,0.00,0.00),('5','105','964','230180',4430912,'2859','432',169532.84,169532.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','230180',4430913,'2860','432',150336.06,150929.10,593.04,96665.52,0.00,0.00,0.00,0.00,0.00),('5','105','965','230180',4430914,'2861','433',36231.07,36231.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','230180',4430915,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','230180',4430916,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','230181',4430917,'2853','432',128709.60,128709.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','230181',4430918,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','230181',4430919,'2855','432',134424.51,134424.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','230181',4430920,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','230181',4430921,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','230181',4430922,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','230181',4430923,'2859','432',169532.84,169532.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','230181',4430924,'2860','432',150929.10,150929.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','230181',4430925,'2861','433',36231.07,36231.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','230181',4430926,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','230181',4430927,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','230716',4441278,'2853','432',128709.60,128709.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','230716',4441279,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','230716',4441280,'2855','432',134424.51,134424.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','230716',4441281,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','230716',4441282,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','230716',4441283,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','230716',4441284,'2859','432',169532.84,174409.15,4876.31,794838.53,0.00,0.00,0.00,0.00,0.00),('5','105','964','230716',4441285,'2860','432',150929.10,156145.63,5216.53,850294.39,0.00,0.00,0.00,0.00,0.00),('5','105','965','230716',4441286,'2861','433',36231.07,36231.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','230716',4441287,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','230716',4441288,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','230722',4441374,'2853','432',128709.60,128709.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','230722',4441375,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','230722',4441376,'2855','432',134424.51,134424.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','230722',4441377,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','230722',4441378,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','230722',4441379,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','230722',4441380,'2859','432',174409.15,178658.86,4249.71,692702.73,0.00,0.00,0.00,0.00,0.00),('5','105','964','230722',4441381,'2860','432',156145.63,160618.10,4472.47,729012.61,0.00,0.00,0.00,0.00,0.00),('5','105','965','230722',4441382,'2861','433',36231.07,36231.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','230722',4441383,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','230722',4441384,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','231010',4446162,'2853','432',128709.60,128709.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','231010',4446163,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','231010',4446164,'2855','432',134424.51,134424.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','231010',4446165,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','231010',4446166,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','231010',4446167,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','231010',4446168,'2859','432',178658.86,183093.80,4434.94,722895.22,0.00,0.00,0.00,0.00,0.00),('5','105','964','231010',4446169,'2860','432',160618.10,165027.37,4409.27,718711.01,0.00,0.00,0.00,0.00,0.00),('5','105','965','231010',4446170,'2861','433',36231.07,36231.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','231010',4446171,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','231010',4446172,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','231121',4447916,'2853','432',128709.60,128709.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','231121',4447917,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','231121',4447918,'2855','432',134424.51,134424.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','231121',4447919,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','231121',4447920,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','231121',4447921,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','231121',4447922,'2859','432',183093.80,186856.48,3762.68,613316.84,0.00,0.00,0.00,0.00,0.00),('5','105','964','231121',4447923,'2860','432',165027.37,168653.48,3626.11,591055.93,0.00,0.00,0.00,0.00,0.00),('5','105','965','231121',4447924,'2861','433',36231.07,36231.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','231121',4447925,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','231121',4447926,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','231606',4456014,'2853','432',128709.60,128709.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','231606',4456015,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','231606',4456016,'2855','432',134424.51,134424.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','231606',4456017,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','231606',4456018,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','231606',4456019,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','231606',4456020,'2859','432',186856.48,192098.00,5241.52,854367.76,0.00,0.00,0.00,0.00,0.00),('5','105','964','231606',4456021,'2860','432',168653.48,173937.75,5284.27,861336.01,0.00,0.00,0.00,0.00,0.00),('5','105','965','231606',4456022,'2861','433',36231.07,36231.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','231606',4456023,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','231606',4456024,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','231776',4458997,'2853','432',128709.60,128709.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','231776',4458998,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','231776',4458999,'2855','432',134424.51,134424.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','231776',4459000,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','231776',4459001,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','231776',4459002,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','231776',4459003,'2859','432',192098.00,196632.72,4534.72,739159.36,0.00,0.00,0.00,0.00,0.00),('5','105','964','231776',4459004,'2860','432',173937.75,178380.45,4442.70,724160.10,0.00,0.00,0.00,0.00,0.00),('5','105','965','231776',4459005,'2861','433',36231.07,36231.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','231776',4459006,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','231776',4459007,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','232003',4463053,'2853','432',128709.60,128709.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','232003',4463054,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','232003',4463055,'2855','432',134424.51,134424.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','232003',4463056,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','232003',4463057,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','232003',4463058,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','232003',4463059,'2859','432',196632.72,201003.94,4371.22,712508.86,0.00,0.00,0.00,0.00,0.00),('5','105','964','232003',4463060,'2860','432',178380.45,183099.28,4718.83,769169.29,0.00,0.00,0.00,0.00,0.00),('5','105','965','232003',4463061,'2861','433',36231.07,36231.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','232003',4463062,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','232003',4463063,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','232289',4468332,'2853','432',128709.60,128709.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','232289',4468333,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','232289',4468334,'2855','432',134424.51,134424.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','232289',4468335,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','232289',4468336,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','232289',4468337,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','232289',4468338,'2859','432',201003.94,205610.17,4606.23,750815.49,0.00,0.00,0.00,0.00,0.00),('5','105','964','232289',4468339,'2860','432',183099.28,187871.19,4771.91,777821.33,0.00,0.00,0.00,0.00,0.00),('5','105','965','232289',4468340,'2861','433',36231.07,36231.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','232289',4468341,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','232289',4468342,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','232452',4471133,'2853','432',128709.60,128709.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','232452',4471134,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','232452',4471135,'2855','432',134424.51,134424.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','232452',4471136,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','232452',4471137,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','232452',4471138,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','232452',4471139,'2859','432',205610.17,208896.70,3286.53,535704.39,0.00,0.00,0.00,0.00,0.00),('5','105','964','232452',4471140,'2860','432',187871.19,191432.90,3561.71,580558.73,0.00,0.00,0.00,0.00,0.00),('5','105','965','232452',4471141,'2861','433',36231.07,36231.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','232452',4471142,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','232452',4471143,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','232763',4476918,'2853','432',128709.60,128709.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','232763',4476919,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','232763',4476920,'2855','432',134424.51,134424.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','232763',4476921,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','232763',4476922,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','232763',4476923,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','232763',4476924,'2859','432',208896.70,213802.08,4905.38,799576.94,0.00,0.00,0.00,0.00,0.00),('5','105','964','232763',4476925,'2860','432',191432.90,196227.80,4794.90,781568.70,0.00,0.00,0.00,0.00,0.00),('5','105','965','232763',4476926,'2861','433',36231.07,36231.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','232763',4476927,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','232763',4476928,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','233321',4486975,'2853','432',128709.60,128709.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','233321',4486976,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','233321',4486977,'2855','432',134424.51,134424.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','233321',4486978,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','233321',4486979,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','233321',4486980,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','233321',4486981,'2859','432',213802.08,218013.53,4211.45,686466.35,0.00,0.00,0.00,0.00,0.00),('5','105','964','233321',4486982,'2860','432',196227.80,200641.73,4413.93,719470.59,0.00,0.00,0.00,0.00,0.00),('5','105','965','233321',4486983,'2861','433',36231.07,36517.53,286.46,94531.80,0.00,0.00,0.00,0.00,0.00),('5','105','966','233321',4486984,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','233321',4486985,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','233336',4487213,'2853','432',128709.60,128709.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','233336',4487214,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','233336',4487215,'2855','432',134424.51,134424.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','233336',4487216,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','233336',4487217,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','233336',4487218,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','233336',4487219,'2859','432',218013.53,222301.88,4288.35,699001.05,0.00,0.00,0.00,0.00,0.00),('5','105','964','233336',4487220,'2860','432',200641.73,205427.76,4786.03,780122.89,0.00,0.00,0.00,0.00,0.00),('5','105','965','233336',4487221,'2861','433',36517.53,36706.43,188.90,65170.50,0.00,0.00,0.00,0.00,0.00),('5','105','966','233336',4487222,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','233336',4487223,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','233629',4492244,'2853','432',128709.60,128709.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','233629',4492245,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','233629',4492246,'2855','432',134424.51,134424.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','233629',4492247,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','233629',4492248,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','233629',4492249,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','233629',4492250,'2859','432',222301.88,223817.42,1515.54,247033.02,0.00,0.00,0.00,0.00,0.00),('5','105','964','233629',4492251,'2860','432',205427.76,206545.21,1117.45,182144.35,0.00,0.00,0.00,0.00,0.00),('5','105','965','233629',4492252,'2861','433',36706.43,36817.89,111.46,38453.70,0.00,0.00,0.00,0.00,0.00),('5','105','966','233629',4492253,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','233629',4492254,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','234184',4502548,'2853','432',128709.60,128709.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','234184',4502549,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','234184',4502550,'2855','432',134424.51,134424.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','234184',4502551,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','234184',4502552,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','234184',4502553,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','234184',4502554,'2859','432',223817.42,223817.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','234184',4502555,'2860','432',206545.21,206545.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','234184',4502556,'2861','433',36817.89,37227.42,409.53,141287.85,0.00,0.00,0.00,0.00,0.00),('5','105','966','234184',4502557,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','234184',4502558,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','234201',4502847,'2853','432',128709.60,128709.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','234201',4502848,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','234201',4502849,'2855','432',134424.51,134424.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','234201',4502850,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','234201',4502851,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','234201',4502852,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','234201',4502853,'2859','432',223817.42,223817.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','234201',4502854,'2860','432',206545.21,206545.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','234201',4502855,'2861','433',37227.42,37375.47,148.05,51077.25,0.00,0.00,0.00,0.00,0.00),('5','105','966','234201',4502856,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','234201',4502857,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','234484',4507761,'2853','432',128709.60,128709.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','234484',4507762,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','234484',4507763,'2855','432',134424.51,134424.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','234484',4507764,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','234484',4507765,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','234484',4507766,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','234484',4507767,'2859','432',223817.42,223817.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','234484',4507768,'2860','432',206545.21,206545.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','234484',4507769,'2861','433',37375.47,37527.32,151.85,52388.25,0.00,0.00,0.00,0.00,0.00),('5','105','966','234484',4507770,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','234484',4507771,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','234801',4513592,'2853','432',128709.60,128709.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','234801',4513593,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','234801',4513594,'2855','432',134424.51,134424.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','234801',4513595,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','234801',4513596,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','234801',4513597,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','234801',4513598,'2859','432',223817.42,223817.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','234801',4513599,'2860','432',206545.21,206545.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','234801',4513600,'2861','433',37527.32,37649.97,122.65,42314.25,0.00,0.00,0.00,0.00,0.00),('5','105','966','234801',4513601,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','234801',4513602,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','234917',4515557,'2853','432',128709.60,128709.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','234917',4515558,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','234917',4515559,'2855','432',134424.51,134424.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','234917',4515560,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','234917',4515561,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','234917',4515562,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','234917',4515563,'2859','432',223817.42,223817.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','234917',4515564,'2860','432',206545.21,206545.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','234917',4515565,'2861','433',37649.97,37754.53,104.56,36073.20,0.00,0.00,0.00,0.00,0.00),('5','105','966','234917',4515566,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','234917',4515567,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','234995',4516983,'2853','432',128709.60,128709.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','234995',4516984,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','234995',4516985,'2855','432',134424.51,134424.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','234995',4516986,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','234995',4516987,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','234995',4516988,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','234995',4516989,'2859','432',223817.42,223817.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','234995',4516990,'2860','432',206545.21,206545.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','234995',4516991,'2861','433',37754.53,37843.83,89.30,30808.50,0.00,0.00,0.00,0.00,0.00),('5','105','966','234995',4516992,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','234995',4516993,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','235611',4527502,'2853','432',128709.60,128709.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','235611',4527503,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','235611',4527504,'2855','432',134424.51,134424.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','235611',4527505,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','235611',4527506,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','235611',4527507,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','235611',4527508,'2859','432',223817.42,223817.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','235611',4527509,'2860','432',206545.21,206545.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','235611',4527510,'2861','433',37843.83,37843.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','235611',4527511,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','235611',4527512,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','235618',4527607,'2853','432',128709.60,128709.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','235618',4527608,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','235618',4527609,'2855','432',134424.51,134424.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','235618',4527610,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','235618',4527611,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','235618',4527612,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','235618',4527613,'2859','432',223817.42,227822.76,4005.34,660881.10,0.00,0.00,0.00,0.00,0.00),('5','105','964','235618',4527614,'2860','432',206545.21,211044.89,4499.68,742447.20,0.00,0.00,0.00,0.00,0.00),('5','105','965','235618',4527615,'2861','433',37843.83,37948.97,105.14,36273.30,0.00,0.00,0.00,0.00,0.00),('5','105','966','235618',4527616,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','235618',4527617,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','235951',4533523,'2853','432',128709.60,128709.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','235951',4533524,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','235951',4533525,'2855','432',134424.51,134424.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','235951',4533526,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','235951',4533527,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','235951',4533528,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','235951',4533529,'2859','432',227822.76,231855.94,4033.18,665474.70,0.00,0.00,0.00,0.00,0.00),('5','105','964','235951',4533530,'2860','432',211044.89,215645.77,4600.88,759145.20,0.00,0.00,0.00,0.00,0.00),('5','105','965','235951',4533531,'2861','433',37948.97,38062.14,113.17,39043.65,0.00,0.00,0.00,0.00,0.00),('5','105','966','235951',4533532,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','235951',4533533,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','235954',4533662,'2853','432',128709.60,128709.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','235954',4533663,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','235954',4533664,'2855','432',134424.51,134424.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','235954',4533665,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','235954',4533666,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','235954',4533667,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','235954',4533668,'2859','432',231855.94,232656.23,800.29,132047.85,0.00,0.00,0.00,0.00,0.00),('5','105','964','235954',4533669,'2860','432',215645.77,215842.24,196.47,32417.55,0.00,0.00,0.00,0.00,0.00),('5','105','965','235954',4533670,'2861','433',38062.14,38252.73,190.59,65753.55,0.00,0.00,0.00,0.00,0.00),('5','105','966','235954',4533671,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','235954',4533672,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','236195',4538029,'2853','432',128709.60,128709.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','236195',4538030,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','236195',4538031,'2855','432',134424.51,134424.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','236195',4538032,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','236195',4538033,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','236195',4538034,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','236195',4538035,'2859','432',232656.23,236875.46,4219.23,696172.95,0.00,0.00,0.00,0.00,0.00),('5','105','964','236195',4538036,'2860','432',215842.24,220205.05,4362.81,719863.65,0.00,0.00,0.00,0.00,0.00),('5','105','965','236195',4538037,'2861','433',38252.73,38416.48,163.75,56493.75,0.00,0.00,0.00,0.00,0.00),('5','105','966','236195',4538038,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','236195',4538039,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','236539',4543834,'2853','432',128709.60,128709.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','236539',4543835,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','236539',4543836,'2855','432',134424.51,134424.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','236539',4543837,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','236539',4543838,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','236539',4543839,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','236539',4543840,'2859','432',236875.46,240221.31,3345.85,552065.25,0.00,0.00,0.00,0.00,0.00),('5','105','964','236539',4543841,'2860','432',220205.05,223073.39,2868.34,473276.10,0.00,0.00,0.00,0.00,0.00),('5','105','965','236539',4543842,'2861','433',38416.48,38475.15,58.67,20241.15,0.00,0.00,0.00,0.00,0.00),('5','105','966','236539',4543843,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','236539',4543844,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','236606',4545118,'2853','432',128709.60,128709.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','236606',4545119,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','236606',4545120,'2855','432',134424.51,134424.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','236606',4545121,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','236606',4545122,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','236606',4545123,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','236606',4545124,'2859','432',240221.31,245037.94,4816.63,794743.95,0.00,0.00,0.00,0.00,0.00),('5','105','964','236606',4545125,'2860','432',223073.39,228375.32,5301.93,874818.45,0.00,0.00,0.00,0.00,0.00),('5','105','965','236606',4545126,'2861','433',38475.15,38749.70,274.55,94719.75,0.00,0.00,0.00,0.00,0.00),('5','105','966','236606',4545127,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','236606',4545128,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','237053',4552790,'2853','432',128709.60,128709.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','237053',4552791,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','237053',4552792,'2855','432',134424.51,134424.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','237053',4552793,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','237053',4552794,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','237053',4552795,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','237053',4552796,'2859','432',245037.94,250455.06,5417.12,893824.80,0.00,0.00,0.00,0.00,0.00),('5','105','964','237053',4552797,'2860','432',228375.32,233256.82,4881.50,805447.50,0.00,0.00,0.00,0.00,0.00),('5','105','965','237053',4552798,'2861','433',38749.70,38968.06,218.36,75334.20,0.00,0.00,0.00,0.00,0.00),('5','105','966','237053',4552799,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','237053',4552800,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','237224',4555814,'2853','432',128709.60,128709.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','237224',4555815,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','237224',4555816,'2855','432',134424.51,134424.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','237224',4555817,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','237224',4555818,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','237224',4555819,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','237224',4555820,'2859','432',250455.06,253686.75,3231.69,533228.85,0.00,0.00,0.00,0.00,0.00),('5','105','964','237224',4555821,'2860','432',233256.82,236214.48,2957.66,488013.90,0.00,0.00,0.00,0.00,0.00),('5','105','965','237224',4555822,'2861','433',38968.06,39091.86,123.80,42711.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','237224',4555823,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','237224',4555824,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','237549',4561796,'2853','432',128709.60,128709.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','237549',4561797,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','237549',4561798,'2855','432',134424.51,134424.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','237549',4561799,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','237549',4561800,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','237549',4561801,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','237549',4561802,'2859','432',253686.75,253686.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','237549',4561803,'2860','432',236214.48,236214.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','237549',4561804,'2861','433',39091.86,39314.98,223.12,76976.40,0.00,0.00,0.00,0.00,0.00),('5','105','966','237549',4561805,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','237549',4561806,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','237792',4565832,'2853','432',128709.60,128709.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','237792',4565833,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','237792',4565834,'2855','432',134424.51,134424.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','237792',4565835,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','237792',4565836,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','237792',4565837,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','237792',4565838,'2859','432',253686.75,253686.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','237792',4565839,'2860','432',236214.48,236214.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','237792',4565840,'2861','433',39314.98,39314.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','237792',4565841,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','237792',4565842,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','238028',4569706,'2853','432',128709.60,128709.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','238028',4569707,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','238028',4569708,'2855','432',134424.51,134424.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','238028',4569709,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','238028',4569710,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','238028',4569711,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','238028',4569712,'2859','432',253686.75,253686.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','238028',4569713,'2860','432',236214.48,236214.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','238028',4569714,'2861','433',39314.98,39314.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','238028',4569715,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','238028',4569716,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','238051',4570072,'2853','432',128709.60,128709.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','238051',4570073,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','238051',4570074,'2855','432',134424.51,134424.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','238051',4570075,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','238051',4570076,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','238051',4570077,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','238051',4570078,'2859','432',253686.75,259243.89,5557.14,916928.10,0.00,0.00,0.00,0.00,0.00),('5','105','964','238051',4570079,'2860','432',236214.48,241622.55,5408.07,892331.55,0.00,0.00,0.00,0.00,0.00),('5','105','965','238051',4570080,'2861','433',39314.98,39638.92,323.94,111759.30,0.00,0.00,0.00,0.00,0.00),('5','105','966','238051',4570081,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','238051',4570082,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','238225',4573025,'2853','432',128709.60,128709.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','238225',4573026,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','238225',4573027,'2855','432',134424.51,134424.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','238225',4573028,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','238225',4573029,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','238225',4573030,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','238225',4573031,'2859','432',259243.89,263815.67,4571.78,754343.70,0.00,0.00,0.00,0.00,0.00),('5','105','964','238225',4573032,'2860','432',241622.55,246479.23,4856.68,801352.20,0.00,0.00,0.00,0.00,0.00),('5','105','965','238225',4573033,'2861','433',39638.92,39883.62,244.70,84421.50,0.00,0.00,0.00,0.00,0.00),('5','105','966','238225',4573034,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','238225',4573035,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','238417',4576358,'2853','432',128709.60,129540.95,831.35,137172.75,0.00,0.00,0.00,0.00,0.00),('5','105','961','238417',4576359,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','238417',4576360,'2855','432',134424.51,134424.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','238417',4576361,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','238417',4576362,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','238417',4576363,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','238417',4576364,'2859','432',263815.67,268346.95,4531.28,747661.20,0.00,0.00,0.00,0.00,0.00),('5','105','964','238417',4576365,'2860','432',246479.23,251119.79,4640.56,765692.40,0.00,0.00,0.00,0.00,0.00),('5','105','965','238417',4576366,'2861','433',39883.62,40176.52,292.90,101050.50,0.00,0.00,0.00,0.00,0.00),('5','105','966','238417',4576367,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','238417',4576368,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','239163',4589369,'2853','432',129540.95,129731.36,190.41,31417.65,0.00,0.00,0.00,0.00,0.00),('5','105','961','239163',4589370,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','239163',4589371,'2855','432',134424.51,137255.90,2831.39,467179.35,0.00,0.00,0.00,0.00,0.00),('5','105','961','239163',4589372,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','239163',4589373,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','239163',4589374,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','239163',4589375,'2859','432',268346.95,272608.99,4262.04,703236.60,0.00,0.00,0.00,0.00,0.00),('5','105','964','239163',4589376,'2860','432',251119.79,254986.50,3866.71,638007.15,0.00,0.00,0.00,0.00,0.00),('5','105','965','239163',4589377,'2861','433',40176.52,40865.00,688.48,237525.60,0.00,0.00,0.00,0.00,0.00),('5','105','966','239163',4589378,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','239163',4589379,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','239212',4590135,'2853','432',129731.36,131615.41,1884.05,310868.25,0.00,0.00,0.00,0.00,0.00),('5','105','961','239212',4590136,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','239212',4590137,'2855','432',137255.90,140374.70,3118.80,514602.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','239212',4590138,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','239212',4590139,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','239212',4590140,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','239212',4590141,'2859','432',272608.99,276454.86,3845.87,634568.55,0.00,0.00,0.00,0.00,0.00),('5','105','964','239212',4590142,'2860','432',254986.50,258803.22,3816.72,629758.80,0.00,0.00,0.00,0.00,0.00),('5','105','965','239212',4590143,'2861','433',40865.00,42044.12,1179.12,406796.40,0.00,0.00,0.00,0.00,0.00),('5','105','966','239212',4590144,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','239212',4590145,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','239355',4592533,'2853','432',131615.41,137055.43,5440.02,897603.30,0.00,0.00,0.00,0.00,0.00),('5','105','961','239355',4592534,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','239355',4592535,'2855','432',140374.70,146099.01,5724.31,944511.15,0.00,0.00,0.00,0.00,0.00),('5','105','961','239355',4592536,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','239355',4592537,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','239355',4592538,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','239355',4592539,'2859','432',276454.86,276454.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','239355',4592540,'2860','432',258803.22,258803.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','239355',4592541,'2861','433',42044.12,43436.88,1392.76,480502.20,0.00,0.00,0.00,0.00,0.00),('5','105','966','239355',4592542,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','239355',4592543,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','239492',4595049,'2853','432',137055.43,140256.55,3201.12,528184.80,0.00,0.00,0.00,0.00,0.00),('5','105','961','239492',4595050,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','239492',4595051,'2855','432',146099.01,148706.07,2607.06,430164.90,0.00,0.00,0.00,0.00,0.00),('5','105','961','239492',4595052,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','239492',4595053,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','239492',4595054,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','239492',4595055,'2859','432',276454.86,280422.16,3967.30,654604.50,0.00,0.00,0.00,0.00,0.00),('5','105','964','239492',4595056,'2860','432',258803.22,262633.59,3830.37,632011.05,0.00,0.00,0.00,0.00,0.00),('5','105','965','239492',4595057,'2861','433',43436.88,44303.91,867.03,299125.35,0.00,0.00,0.00,0.00,0.00),('5','105','966','239492',4595058,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','239492',4595059,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','239669',4598073,'2853','432',140256.55,140256.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','239669',4598074,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','239669',4598075,'2855','432',148706.07,148706.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','239669',4598076,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','239669',4598077,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','239669',4598078,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','239669',4598079,'2859','432',280422.16,285568.55,5146.39,849154.35,0.00,0.00,0.00,0.00,0.00),('5','105','964','239669',4598080,'2860','432',262633.59,267904.05,5270.46,869625.90,0.00,0.00,0.00,0.00,0.00),('5','105','965','239669',4598081,'2861','433',44303.91,44935.81,631.90,218005.50,0.00,0.00,0.00,0.00,0.00),('5','105','966','239669',4598082,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','239669',4598083,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','239856',4601277,'2853','432',140256.55,142532.71,2276.16,375566.40,0.00,0.00,0.00,0.00,0.00),('5','105','961','239856',4601278,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','239856',4601279,'2855','432',148706.07,151689.57,2983.50,492277.50,0.00,0.00,0.00,0.00,0.00),('5','105','961','239856',4601280,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','239856',4601281,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','239856',4601282,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','239856',4601283,'2859','432',285568.55,289273.24,3704.69,611273.85,0.00,0.00,0.00,0.00,0.00),('5','105','964','239856',4601284,'2860','432',267904.05,268461.25,557.20,91938.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','239856',4601285,'2861','433',44935.81,45387.39,451.58,155795.10,0.00,0.00,0.00,0.00,0.00),('5','105','966','239856',4601286,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','239856',4601287,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','240406',4610803,'2853','432',142532.71,145076.60,2543.89,419741.85,0.00,0.00,0.00,0.00,0.00),('5','105','961','240406',4610804,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','240406',4610805,'2855','432',151689.57,155052.48,3362.91,554880.15,0.00,0.00,0.00,0.00,0.00),('5','105','961','240406',4610806,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','240406',4610807,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','240406',4610808,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','240406',4610809,'2859','432',289273.24,293267.01,3993.77,658972.05,0.00,0.00,0.00,0.00,0.00),('5','105','964','240406',4610810,'2860','432',268461.25,268877.60,416.35,68697.75,0.00,0.00,0.00,0.00,0.00),('5','105','965','240406',4610811,'2861','433',45387.39,45705.75,318.36,109834.20,0.00,0.00,0.00,0.00,0.00),('5','105','966','240406',4610812,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','240406',4610813,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','240599',4613790,'2853','432',145076.60,146831.71,1755.11,289593.15,0.00,0.00,0.00,0.00,0.00),('5','105','961','240599',4613791,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','240599',4613792,'2855','432',155052.48,157636.68,2584.20,426393.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','240599',4613793,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','240599',4613794,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','240599',4613795,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','240599',4613796,'2859','432',293267.01,297102.16,3835.15,632799.75,0.00,0.00,0.00,0.00,0.00),('5','105','964','240599',4613797,'2860','432',268877.60,272234.05,3356.45,553814.25,0.00,0.00,0.00,0.00,0.00),('5','105','965','240599',4613798,'2861','433',45705.75,46162.26,456.51,157495.95,0.00,0.00,0.00,0.00,0.00),('5','105','966','240599',4613799,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','240599',4613800,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','240603',4613870,'2853','432',146831.71,149446.16,2614.45,431384.25,0.00,0.00,0.00,0.00,0.00),('5','105','961','240603',4613871,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','240603',4613872,'2855','432',157636.68,160931.70,3295.02,543678.30,0.00,0.00,0.00,0.00,0.00),('5','105','961','240603',4613873,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','240603',4613874,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','240603',4613875,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','240603',4613876,'2859','432',297102.16,301223.13,4120.97,679960.05,0.00,0.00,0.00,0.00,0.00),('5','105','964','240603',4613877,'2860','432',272234.05,273696.21,1462.16,241256.40,0.00,0.00,0.00,0.00,0.00),('5','105','965','240603',4613878,'2861','433',46162.26,46698.85,536.59,185123.55,0.00,0.00,0.00,0.00,0.00),('5','105','966','240603',4613879,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','240603',4613880,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','240787',4616601,'2853','432',149446.16,154250.94,4804.78,792788.70,0.00,0.00,0.00,0.00,0.00),('5','105','961','240787',4616602,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','240787',4616603,'2855','432',160931.70,165921.11,4989.41,823252.65,0.00,0.00,0.00,0.00,0.00),('5','105','961','240787',4616604,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','240787',4616605,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','240787',4616606,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','240787',4616607,'2859','432',301223.13,301223.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','240787',4616608,'2860','432',273696.21,273696.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','240787',4616609,'2861','433',46698.85,47307.36,608.51,209935.95,0.00,0.00,0.00,0.00,0.00),('5','105','966','240787',4616610,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','240787',4616611,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','241071',4621785,'2853','432',154250.94,158429.02,4178.08,689383.20,0.00,0.00,0.00,0.00,0.00),('5','105','961','241071',4621786,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','241071',4621787,'2855','432',165921.11,170074.78,4153.67,685355.55,0.00,0.00,0.00,0.00,0.00),('5','105','961','241071',4621788,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','241071',4621789,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','241071',4621790,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','241071',4621791,'2859','432',301223.13,301223.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','241071',4621792,'2860','432',273696.21,273696.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','241071',4621793,'2861','433',47307.36,48502.03,1194.67,412161.15,0.00,0.00,0.00,0.00,0.00),('5','105','966','241071',4621794,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','241071',4621795,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','241416',4627861,'2853','432',158429.02,160337.11,1908.09,314834.85,0.00,0.00,0.00,0.00,0.00),('5','105','961','241416',4627862,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','241416',4627863,'2855','432',170074.78,173181.51,3106.73,512610.45,0.00,0.00,0.00,0.00,0.00),('5','105','961','241416',4627864,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','241416',4627865,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','241416',4627866,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','241416',4627867,'2859','432',301223.13,301223.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','241416',4627868,'2860','432',273696.21,273696.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','241416',4627869,'2861','433',48502.03,48682.89,180.86,62396.70,0.00,0.00,0.00,0.00,0.00),('5','105','966','241416',4627870,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','241416',4627871,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','241863',4635341,'2853','432',160337.11,160337.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','241863',4635342,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','241863',4635343,'2855','432',173181.51,173181.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','241863',4635344,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','241863',4635345,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','241863',4635346,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','241863',4635347,'2859','432',301223.13,301223.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','241863',4635348,'2860','432',273696.21,273696.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','241863',4635349,'2861','433',48682.89,49098.62,415.73,143426.85,0.00,0.00,0.00,0.00,0.00),('5','105','966','241863',4635350,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','241863',4635351,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','242088',4639406,'2853','432',160337.11,160337.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','242088',4639407,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','242088',4639408,'2855','432',173181.51,173181.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','242088',4639409,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','242088',4639410,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','242088',4639411,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','242088',4639412,'2859','432',301223.13,301223.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','242088',4639413,'2860','432',273696.21,273696.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','242088',4639414,'2861','433',49098.62,49624.54,525.92,181442.40,0.00,0.00,0.00,0.00,0.00),('5','105','966','242088',4639415,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','242088',4639416,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','242131',4640169,'2853','432',160337.11,160337.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','242131',4640170,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','242131',4640171,'2855','432',173181.51,173181.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','242131',4640172,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','242131',4640173,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','242131',4640174,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','242131',4640175,'2859','432',301223.13,305797.65,4574.52,754795.80,0.00,0.00,0.00,0.00,0.00),('5','105','964','242131',4640176,'2860','432',273696.21,278140.02,4443.81,733228.65,0.00,0.00,0.00,0.00,0.00),('5','105','965','242131',4640177,'2861','433',49624.54,50186.75,562.21,193962.45,0.00,0.00,0.00,0.00,0.00),('5','105','966','242131',4640178,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','242131',4640179,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','242373',4644602,'2853','432',160337.11,160337.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','242373',4644603,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','242373',4644604,'2855','432',173181.51,173181.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','242373',4644605,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','242373',4644606,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','242373',4644607,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','242373',4644608,'2859','432',305797.65,311093.80,5296.15,873864.75,0.00,0.00,0.00,0.00,0.00),('5','105','964','242373',4644609,'2860','432',278140.02,282875.37,4735.35,781332.75,0.00,0.00,0.00,0.00,0.00),('5','105','965','242373',4644610,'2861','433',50186.75,50716.18,529.43,182653.35,0.00,0.00,0.00,0.00,0.00),('5','105','966','242373',4644611,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','242373',4644612,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','242534',4647366,'2853','432',160337.11,160337.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','242534',4647367,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','242534',4647368,'2855','432',173181.51,173181.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','242534',4647369,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','242534',4647370,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','242534',4647371,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','242534',4647372,'2859','432',311093.80,316110.16,5016.36,827699.40,0.00,0.00,0.00,0.00,0.00),('5','105','964','242534',4647373,'2860','432',282875.37,287636.30,4760.93,785553.45,0.00,0.00,0.00,0.00,0.00),('5','105','965','242534',4647374,'2861','433',50716.18,51179.48,463.30,159838.50,0.00,0.00,0.00,0.00,0.00),('5','105','966','242534',4647375,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','242534',4647376,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','242838',4652484,'2853','432',160337.11,160337.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','242838',4652485,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','242838',4652486,'2855','432',173181.51,173181.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','242838',4652487,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','242838',4652488,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','242838',4652489,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','242838',4652490,'2859','432',316110.16,320934.18,4824.02,795963.30,0.00,0.00,0.00,0.00,0.00),('5','105','964','242838',4652491,'2860','432',287636.30,292564.14,4927.84,813093.60,0.00,0.00,0.00,0.00,0.00),('5','105','965','242838',4652492,'2861','433',51179.48,51887.49,708.01,244263.45,0.00,0.00,0.00,0.00,0.00),('5','105','966','242838',4652493,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','242838',4652494,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','243083',4656983,'2853','432',160337.11,161000.56,663.45,109469.25,0.00,0.00,0.00,0.00,0.00),('5','105','961','243083',4656984,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','243083',4656985,'2855','432',173181.51,174490.26,1308.75,215943.75,0.00,0.00,0.00,0.00,0.00),('5','105','961','243083',4656986,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','243083',4656987,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','243083',4656988,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','243083',4656989,'2859','432',320934.18,323531.55,2597.37,428566.05,0.00,0.00,0.00,0.00,0.00),('5','105','964','243083',4656990,'2860','432',292564.14,294185.29,1621.15,267489.75,0.00,0.00,0.00,0.00,0.00),('5','105','965','243083',4656991,'2861','433',51887.49,52514.36,626.87,216270.15,0.00,0.00,0.00,0.00,0.00),('5','105','966','243083',4656992,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','243083',4656993,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','243283',4660315,'2853','432',161000.56,162783.82,1783.26,294237.90,0.00,0.00,0.00,0.00,0.00),('5','105','961','243283',4660316,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','243283',4660317,'2855','432',174490.26,177485.84,2995.58,494270.70,0.00,0.00,0.00,0.00,0.00),('5','105','961','243283',4660318,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','243283',4660319,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','243283',4660320,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','243283',4660321,'2859','432',323531.55,327154.03,3622.48,597709.20,0.00,0.00,0.00,0.00,0.00),('5','105','964','243283',4660322,'2860','432',294185.29,297320.06,3134.77,517237.05,0.00,0.00,0.00,0.00,0.00),('5','105','965','243283',4660323,'2861','433',52514.36,53021.97,507.61,175125.45,0.00,0.00,0.00,0.00,0.00),('5','105','966','243283',4660324,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','243283',4660325,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','243648',4666469,'2853','432',162783.82,165074.08,2290.26,377892.90,0.00,0.00,0.00,0.00,0.00),('5','105','961','243648',4666470,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','243648',4666471,'2855','432',177485.84,180236.29,2750.45,453824.25,0.00,0.00,0.00,0.00,0.00),('5','105','961','243648',4666472,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','243648',4666473,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','243648',4666474,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','243648',4666475,'2859','432',327154.03,330952.66,3798.63,626773.95,0.00,0.00,0.00,0.00,0.00),('5','105','964','243648',4666476,'2860','432',297320.06,300722.56,3402.50,561412.50,0.00,0.00,0.00,0.00,0.00),('5','105','965','243648',4666477,'2861','433',53021.97,53401.63,379.66,130982.70,0.00,0.00,0.00,0.00,0.00),('5','105','966','243648',4666478,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','243648',4666479,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','243789',4669359,'2853','432',165074.08,167606.98,2532.90,417928.50,0.00,0.00,0.00,0.00,0.00),('5','105','961','243789',4669360,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','243789',4669361,'2855','432',180236.29,183800.75,3564.46,588135.90,0.00,0.00,0.00,0.00,0.00),('5','105','961','243789',4669362,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','243789',4669363,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','243789',4669364,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','243789',4669365,'2859','432',330952.66,334745.21,3792.55,625770.75,0.00,0.00,0.00,0.00,0.00),('5','105','964','243789',4669366,'2860','432',300722.56,304357.10,3634.54,599699.10,0.00,0.00,0.00,0.00,0.00),('5','105','965','243789',4669367,'2861','433',53401.63,54098.14,696.51,240296.30,0.00,0.00,0.00,0.00,0.00),('5','105','966','243789',4669368,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','243789',4669369,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','243953',4671986,'2853','432',167606.98,170372.64,2765.66,456333.90,0.00,0.00,0.00,0.00,0.00),('5','105','961','243953',4671987,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','243953',4671988,'2855','432',183800.75,188251.76,4451.01,734416.65,0.00,0.00,0.00,0.00,0.00),('5','105','961','243953',4671989,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','243953',4671990,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','243953',4671991,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','243953',4671992,'2859','432',334745.21,337974.61,3229.40,532851.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','243953',4671993,'2860','432',304357.10,306871.33,2514.23,414847.95,0.00,0.00,0.00,0.00,0.00),('5','105','965','243953',4671994,'2861','433',54098.14,54502.09,403.95,139362.75,0.00,0.00,0.00,0.00,0.00),('5','105','966','243953',4671995,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','243953',4671996,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','244191',4676034,'2853','432',170372.64,172700.79,2328.15,384144.75,0.00,0.00,0.00,0.00,0.00),('5','105','961','244191',4676035,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','244191',4676036,'2855','432',188251.76,190662.20,2410.44,397722.60,0.00,0.00,0.00,0.00,0.00),('5','105','961','244191',4676037,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','244191',4676038,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','244191',4676039,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','244191',4676040,'2859','432',337974.61,337974.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','244191',4676041,'2860','432',306871.33,306871.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','244191',4676042,'2861','433',54502.09,55073.66,571.57,197191.65,0.00,0.00,0.00,0.00,0.00),('5','105','966','244191',4676043,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','244191',4676044,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','244477',4681159,'2853','432',172700.79,172700.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','244477',4681160,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','244477',4681161,'2855','432',190662.20,190662.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','244477',4681162,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','244477',4681163,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','244477',4681164,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','244477',4681165,'2859','432',337974.61,343943.08,5968.47,984797.55,0.00,0.00,0.00,0.00,0.00),('5','105','964','244477',4681166,'2860','432',306871.33,312358.90,5487.57,905449.05,0.00,0.00,0.00,0.00,0.00),('5','105','965','244477',4681167,'2861','433',55073.66,55481.18,407.52,140594.40,0.00,0.00,0.00,0.00,0.00),('5','105','966','244477',4681168,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','244477',4681169,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','244769',4685772,'2853','432',172700.79,172700.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','244769',4685773,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','244769',4685774,'2855','432',190662.20,190662.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','244769',4685775,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','244769',4685776,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','244769',4685777,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','244769',4685778,'2859','432',343943.08,350144.09,6201.01,1023166.65,0.00,0.00,0.00,0.00,0.00),('5','105','964','244769',4685779,'2860','432',312358.90,318776.35,6417.45,1058879.25,0.00,0.00,0.00,0.00,0.00),('5','105','965','244769',4685780,'2861','433',55481.18,56173.82,692.64,238960.80,0.00,0.00,0.00,0.00,0.00),('5','105','966','244769',4685781,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','244769',4685782,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','245051',4690864,'2853','432',172700.79,172700.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','245051',4690865,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','245051',4690866,'2855','432',190662.20,190662.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','245051',4690867,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','245051',4690868,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','245051',4690869,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','245051',4690870,'2859','432',350144.09,353363.61,3219.52,531220.80,0.00,0.00,0.00,0.00,0.00),('5','105','964','245051',4690871,'2860','432',318776.35,321581.76,2805.41,462892.65,0.00,0.00,0.00,0.00,0.00),('5','105','965','245051',4690872,'2861','433',56173.82,56531.57,357.75,123423.75,0.00,0.00,0.00,0.00,0.00),('5','105','966','245051',4690873,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','245051',4690874,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','245119',4692127,'2853','432',172700.79,172700.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','245119',4692128,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','245119',4692129,'2855','432',190662.20,190662.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','245119',4692130,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','245119',4692131,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','245119',4692132,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','245119',4692133,'2859','432',353363.61,353363.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','245119',4692134,'2860','432',321581.76,321581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','245119',4692135,'2861','433',56531.57,56948.57,417.00,143865.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','245119',4692136,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','245119',4692137,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','245416',4697505,'2853','432',172700.79,172700.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','245416',4697506,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','245416',4697507,'2855','432',190662.20,190662.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','245416',4697508,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','245416',4697509,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','245416',4697510,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','245416',4697511,'2859','432',353363.61,353363.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','245416',4697512,'2860','432',321581.76,321581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','245416',4697513,'2861','433',56948.57,57285.54,336.97,116254.65,0.00,0.00,0.00,0.00,0.00),('5','105','966','245416',4697514,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','245416',4697515,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','245609',4700865,'2853','432',172700.79,172700.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','245609',4700866,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','245609',4700867,'2855','432',190662.20,190662.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','245609',4700868,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','245609',4700869,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','245609',4700870,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','245609',4700871,'2859','432',353363.61,353363.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','245609',4700872,'2860','432',321581.76,321581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','245609',4700873,'2861','433',57285.54,57715.67,430.13,148394.85,0.00,0.00,0.00,0.00,0.00),('5','105','966','245609',4700874,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','245609',4700875,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','245791',4703802,'2853','432',172700.79,172700.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','245791',4703803,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','245791',4703804,'2855','432',190662.20,190662.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','245791',4703805,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','245791',4703806,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','245791',4703807,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','245791',4703808,'2859','432',353363.61,353363.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','245791',4703809,'2860','432',321581.76,321581.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','245791',4703810,'2861','433',57715.67,58743.63,1027.96,354646.20,0.00,0.00,0.00,0.00,0.00),('5','105','966','245791',4703811,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','245791',4703812,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','246167',4709894,'2853','432',172700.79,172700.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','246167',4709895,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','246167',4709896,'2855','432',190662.20,190662.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','246167',4709897,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','246167',4709898,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','246167',4709899,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','246167',4709900,'2859','432',353363.61,357646.88,4283.27,706739.55,0.00,0.00,0.00,0.00,0.00),('5','105','964','246167',4709901,'2860','432',321581.76,325082.45,3500.69,577613.85,0.00,0.00,0.00,0.00,0.00),('5','105','965','246167',4709902,'2861','433',58743.63,59267.47,523.84,180724.80,0.00,0.00,0.00,0.00,0.00),('5','105','966','246167',4709903,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','246167',4709904,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','246550',4716247,'2853','432',172700.79,172700.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','246550',4716248,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','246550',4716249,'2855','432',190662.20,190662.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','246550',4716250,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','246550',4716251,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','246550',4716252,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','246550',4716253,'2859','432',357646.88,363580.62,5933.74,979067.10,0.00,0.00,0.00,0.00,0.00),('5','105','964','246550',4716254,'2860','432',325082.45,330522.06,5439.61,897535.65,0.00,0.00,0.00,0.00,0.00),('5','105','965','246550',4716255,'2861','433',59267.47,59772.43,504.96,174211.20,0.00,0.00,0.00,0.00,0.00),('5','105','966','246550',4716256,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','246550',4716257,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','246655',4718184,'2853','432',172700.79,172700.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','246655',4718185,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','246655',4718186,'2855','432',190662.20,190662.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','246655',4718187,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','246655',4718188,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','246655',4718189,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','246655',4718190,'2859','432',363580.62,368296.67,4716.05,778148.25,0.00,0.00,0.00,0.00,0.00),('5','105','964','246655',4718191,'2860','432',330522.06,335272.08,4750.02,783753.30,0.00,0.00,0.00,0.00,0.00),('5','105','965','246655',4718192,'2861','433',59772.43,60510.99,738.56,254803.20,0.00,0.00,0.00,0.00,0.00),('5','105','966','246655',4718193,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','246655',4718194,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','246947',4723122,'2853','432',172700.79,172700.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','246947',4723123,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','246947',4723124,'2855','432',190662.20,190662.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','246947',4723125,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','246947',4723126,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','246947',4723127,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','246947',4723128,'2859','432',368296.67,370826.75,2530.08,417463.20,0.00,0.00,0.00,0.00,0.00),('5','105','964','246947',4723129,'2860','432',335272.08,337553.90,2281.82,376500.30,0.00,0.00,0.00,0.00,0.00),('5','105','965','246947',4723130,'2861','433',60510.99,61744.99,1234.00,425730.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','246947',4723131,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','246947',4723132,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','247389',4730950,'2853','432',172700.79,172700.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','247389',4730951,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','247389',4730952,'2855','432',190662.20,190662.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','247389',4730953,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','247389',4730954,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','247389',4730955,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','247389',4730956,'2859','432',370826.75,376456.64,5629.89,928931.85,0.00,0.00,0.00,0.00,0.00),('5','105','964','247389',4730957,'2860','432',337553.90,342348.41,4794.51,791094.15,0.00,0.00,0.00,0.00,0.00),('5','105','965','247389',4730958,'2861','433',61744.99,62216.02,471.03,162505.35,0.00,0.00,0.00,0.00,0.00),('5','105','966','247389',4730959,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','247389',4730960,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','247510',4732841,'2853','432',172700.79,172700.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','247510',4732842,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','247510',4732843,'2855','432',190662.20,190662.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','247510',4732844,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','247510',4732845,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','247510',4732846,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','247510',4732847,'2859','432',376456.64,381032.14,4575.50,754957.50,0.00,0.00,0.00,0.00,0.00),('5','105','964','247510',4732848,'2860','432',342348.41,347238.80,4890.39,806914.35,0.00,0.00,0.00,0.00,0.00),('5','105','965','247510',4732849,'2861','433',62216.02,62683.22,467.20,161184.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','247510',4732850,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','247510',4732851,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','247647',4735333,'2853','432',172700.79,172700.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','247647',4735334,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','247647',4735335,'2855','432',190662.20,190662.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','247647',4735336,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','247647',4735337,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','247647',4735338,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','247647',4735339,'2859','432',381032.14,385596.92,4564.78,753188.70,0.00,0.00,0.00,0.00,0.00),('5','105','964','247647',4735340,'2860','432',347238.80,350483.95,3245.15,535449.75,0.00,0.00,0.00,0.00,0.00),('5','105','965','247647',4735341,'2861','433',62683.22,63112.03,428.81,147939.45,0.00,0.00,0.00,0.00,0.00),('5','105','966','247647',4735342,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','247647',4735343,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','247770',4737247,'2853','432',172700.79,172700.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','247770',4737248,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','247770',4737249,'2855','432',190662.20,190662.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','247770',4737250,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','247770',4737251,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','247770',4737252,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','247770',4737253,'2859','432',385596.92,387252.75,1655.83,273211.95,0.00,0.00,0.00,0.00,0.00),('5','105','964','247770',4737254,'2860','432',350483.95,352280.34,1796.39,296404.35,0.00,0.00,0.00,0.00,0.00),('5','105','965','247770',4737255,'2861','433',63112.03,63528.41,416.38,143651.10,0.00,0.00,0.00,0.00,0.00),('5','105','966','247770',4737256,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','247770',4737257,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','248052',4741940,'2853','432',172700.79,172700.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','248052',4741941,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','248052',4741942,'2855','432',190662.20,190662.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','248052',4741943,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','248052',4741944,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','248052',4741945,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','248052',4741946,'2859','432',387252.75,391997.68,4744.93,782913.45,0.00,0.00,0.00,0.00,0.00),('5','105','964','248052',4741947,'2860','432',352280.34,356580.71,4300.37,709561.05,0.00,0.00,0.00,0.00,0.00),('5','105','965','248052',4741948,'2861','433',63528.41,63928.41,400.00,138000.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','248052',4741949,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','248052',4741950,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','248345',4747188,'2853','432',172700.79,172700.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','248345',4747189,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','248345',4747190,'2855','432',190662.20,190662.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','248345',4747191,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','248345',4747192,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','248345',4747193,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','248345',4747194,'2859','432',391997.68,393452.20,1454.52,239995.80,0.00,0.00,0.00,0.00,0.00),('5','105','964','248345',4747195,'2860','432',356580.71,357353.33,772.62,127482.30,0.00,0.00,0.00,0.00,0.00),('5','105','965','248345',4747196,'2861','433',63928.41,64354.53,426.12,147011.40,0.00,0.00,0.00,0.00,0.00),('5','105','966','248345',4747197,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','248345',4747198,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','248525',4750156,'2853','432',172700.79,174493.77,1792.98,295841.70,0.00,0.00,0.00,0.00,0.00),('5','105','961','248525',4750157,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','248525',4750158,'2855','432',190662.20,193460.12,2797.92,461656.80,0.00,0.00,0.00,0.00,0.00),('5','105','961','248525',4750159,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','248525',4750160,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','248525',4750161,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','248525',4750162,'2859','432',393452.20,396266.30,2814.10,464326.50,0.00,0.00,0.00,0.00,0.00),('5','105','964','248525',4750163,'2860','432',357353.33,360937.29,3583.96,591353.40,0.00,0.00,0.00,0.00,0.00),('5','105','965','248525',4750164,'2861','433',64354.53,64751.33,396.80,136896.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','248525',4750165,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','248525',4750166,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','248773',4754338,'2853','432',174493.77,176242.66,1748.89,288566.85,0.00,0.00,0.00,0.00,0.00),('5','105','961','248773',4754339,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','248773',4754340,'2855','432',193460.12,195965.22,2505.10,413341.50,0.00,0.00,0.00,0.00,0.00),('5','105','961','248773',4754341,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','248773',4754342,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','248773',4754343,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','248773',4754344,'2859','432',396266.30,400074.40,3808.10,628336.50,0.00,0.00,0.00,0.00,0.00),('5','105','964','248773',4754345,'2860','432',360937.29,364579.62,3642.33,600984.45,0.00,0.00,0.00,0.00,0.00),('5','105','965','248773',4754346,'2861','433',64751.33,65155.78,404.45,139535.25,0.00,0.00,0.00,0.00,0.00),('5','105','966','248773',4754347,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','248773',4754348,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','249308',4763462,'2853','432',176242.66,177679.90,1437.24,237144.60,0.00,0.00,0.00,0.00,0.00),('5','105','961','249308',4763463,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','249308',4763464,'2855','432',195965.22,199371.98,3406.76,562115.40,0.00,0.00,0.00,0.00,0.00),('5','105','961','249308',4763465,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','249308',4763466,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','249308',4763467,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','249308',4763468,'2859','432',400074.40,403438.78,3364.38,555122.70,0.00,0.00,0.00,0.00,0.00),('5','105','964','249308',4763469,'2860','432',364579.62,367728.12,3148.50,519502.50,0.00,0.00,0.00,0.00,0.00),('5','105','965','249308',4763470,'2861','433',65155.78,65155.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','249308',4763471,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','249308',4763472,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','249451',4765681,'2853','432',177679.90,177679.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','249451',4765682,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','249451',4765683,'2855','432',199371.98,202892.11,3520.13,580821.45,0.00,0.00,0.00,0.00,0.00),('5','105','961','249451',4765684,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','249451',4765685,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','249451',4765686,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','249451',4765687,'2859','432',403438.78,406479.29,3040.51,501684.15,0.00,0.00,0.00,0.00,0.00),('5','105','964','249451',4765688,'2860','432',367728.12,370883.72,3155.60,520674.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','249451',4765689,'2861','433',65155.78,65155.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','249451',4765690,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','249451',4765691,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','249720',4770145,'2853','432',177679.90,178559.91,880.01,145201.65,0.00,0.00,0.00,0.00,0.00),('5','105','961','249720',4770146,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','249720',4770147,'2855','432',202892.11,203303.28,411.17,67843.05,0.00,0.00,0.00,0.00,0.00),('5','105','961','249720',4770148,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','249720',4770149,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','249720',4770150,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','249720',4770151,'2859','432',406479.29,412209.71,5730.42,945519.30,0.00,0.00,0.00,0.00,0.00),('5','105','964','249720',4770152,'2860','432',370883.72,376261.54,5377.82,887340.30,0.00,0.00,0.00,0.00,0.00),('5','105','965','249720',4770153,'2861','433',65155.78,65155.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','249720',4770154,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','249720',4770155,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','250015',4775309,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','250015',4775310,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','250015',4775311,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','250015',4775312,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','250015',4775313,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','250015',4775314,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','250015',4775315,'2859','432',412209.71,414367.39,2157.68,356017.20,0.00,0.00,0.00,0.00,0.00),('5','105','964','250015',4775316,'2860','432',376261.54,377724.99,1463.45,241469.25,0.00,0.00,0.00,0.00,0.00),('5','105','965','250015',4775317,'2861','433',65155.78,65155.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','250015',4775318,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','250015',4775319,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','250693',4786619,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','250693',4786620,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','250693',4786621,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','250693',4786622,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','250693',4786623,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','250693',4786624,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','250693',4786625,'2859','432',414367.39,414367.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','250693',4786626,'2860','432',377724.99,377724.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','250693',4786627,'2861','433',65155.78,65155.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','250693',4786628,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','250693',4786629,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','250729',4787294,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','250729',4787295,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','250729',4787296,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','250729',4787297,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','250729',4787298,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','250729',4787299,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','250729',4787300,'2859','432',414367.39,415386.16,1018.77,168097.05,0.00,0.00,0.00,0.00,0.00),('5','105','964','250729',4787301,'2860','432',377724.99,378752.65,1027.66,169563.90,0.00,0.00,0.00,0.00,0.00),('5','105','965','250729',4787302,'2861','433',65155.78,65155.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','250729',4787303,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','250729',4787304,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','250731',4787329,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','250731',4787330,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','250731',4787331,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','250731',4787332,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','250731',4787333,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','250731',4787334,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','250731',4787335,'2859','432',415386.16,419664.97,4278.81,706003.65,0.00,0.00,0.00,0.00,0.00),('5','105','964','250731',4787336,'2860','432',378752.65,383119.62,4366.97,720550.05,0.00,0.00,0.00,0.00,0.00),('5','105','965','250731',4787337,'2861','433',65155.78,65355.78,200.00,69000.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','250731',4787338,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','250731',4787339,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','251195',4795547,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','251195',4795548,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','251195',4795549,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','251195',4795550,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','251195',4795551,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','251195',4795552,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','251195',4795553,'2859','432',419664.97,425057.58,5392.61,889780.65,0.00,0.00,0.00,0.00,0.00),('5','105','964','251195',4795554,'2860','432',383119.62,387645.44,4525.82,746760.30,0.00,0.00,0.00,0.00,0.00),('5','105','965','251195',4795555,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','251195',4795556,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','251195',4795557,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','251717',4804702,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','251717',4804703,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','251717',4804704,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','251717',4804705,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','251717',4804706,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','251717',4804707,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','251717',4804708,'2859','432',425057.58,430118.64,5061.06,835074.90,0.00,0.00,0.00,0.00,0.00),('5','105','964','251717',4804709,'2860','432',387645.44,391488.21,3842.77,634057.05,0.00,0.00,0.00,0.00,0.00),('5','105','965','251717',4804710,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','251717',4804711,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','251717',4804712,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','251932',4808312,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','251932',4808313,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','251932',4808314,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','251932',4808315,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','251932',4808316,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','251932',4808317,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','251932',4808318,'2859','432',430118.64,436370.07,6251.43,1031485.95,0.00,0.00,0.00,0.00,0.00),('5','105','964','251932',4808319,'2860','432',391488.21,395677.76,4189.55,691275.75,0.00,0.00,0.00,0.00,0.00),('5','105','965','251932',4808320,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','251932',4808321,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','251932',4808322,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','252148',4812022,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','252148',4812023,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','252148',4812024,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','252148',4812025,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','252148',4812026,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','252148',4812027,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','252148',4812028,'2859','432',436370.07,442703.91,6333.84,1045083.60,0.00,0.00,0.00,0.00,0.00),('5','105','964','252148',4812029,'2860','432',395677.76,401690.32,6012.56,992072.40,0.00,0.00,0.00,0.00,0.00),('5','105','965','252148',4812030,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','252148',4812031,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','252148',4812032,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','252905',4825105,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','252905',4825106,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','252905',4825107,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','252905',4825108,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','252905',4825109,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','252905',4825110,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','252905',4825111,'2859','432',442703.91,449513.21,6809.30,1123534.50,0.00,0.00,0.00,0.00,0.00),('5','105','964','252905',4825112,'2860','432',401690.32,407471.40,5781.08,953878.20,0.00,0.00,0.00,0.00,0.00),('5','105','965','252905',4825113,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','252905',4825114,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','252905',4825115,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','252937',4825745,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','252937',4825746,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','252937',4825747,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','252937',4825748,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','252937',4825749,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','252937',4825750,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','252937',4825751,'2859','432',449513.21,454322.54,4809.33,793539.45,0.00,0.00,0.00,0.00,0.00),('5','105','964','252937',4825752,'2860','432',407471.40,412040.91,4569.51,753969.15,0.00,0.00,0.00,0.00,0.00),('5','105','965','252937',4825753,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','252937',4825754,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','252937',4825755,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','253170',4829749,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','253170',4829750,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','253170',4829751,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','253170',4829752,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','253170',4829753,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','253170',4829754,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','253170',4829755,'2859','432',454322.54,458786.18,4463.64,736500.60,0.00,0.00,0.00,0.00,0.00),('5','105','964','253170',4829756,'2860','432',412040.91,415608.59,3567.68,588667.20,0.00,0.00,0.00,0.00,0.00),('5','105','965','253170',4829757,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','253170',4829758,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','253170',4829759,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','253206',4830227,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','253206',4830228,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','253206',4830229,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','253206',4830230,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','253206',4830231,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','253206',4830232,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','253206',4830233,'2859','432',458786.18,459916.73,1130.55,186540.75,0.00,0.00,0.00,0.00,0.00),('5','105','964','253206',4830234,'2860','432',415608.59,416127.11,518.52,85555.80,0.00,0.00,0.00,0.00,0.00),('5','105','965','253206',4830235,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','253206',4830236,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','253206',4830237,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','253307',4831779,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','253307',4831780,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','253307',4831781,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','253307',4831782,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','253307',4831783,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','253307',4831784,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','253307',4831785,'2859','432',459916.73,460710.74,794.01,131011.65,0.00,0.00,0.00,0.00,0.00),('5','105','964','253307',4831786,'2860','432',416127.11,417648.64,1521.53,251052.45,0.00,0.00,0.00,0.00,0.00),('5','105','965','253307',4831787,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','253307',4831788,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','253307',4831789,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','253312',4831836,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','253312',4831837,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','253312',4831838,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','253312',4831839,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','253312',4831840,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','253312',4831841,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','253312',4831842,'2859','432',460710.74,467389.52,6678.78,1101998.70,0.00,0.00,0.00,0.00,0.00),('5','105','964','253312',4831843,'2860','432',417648.64,423548.04,5899.40,973401.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','253312',4831844,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','253312',4831845,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','253312',4831846,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','253315',4831868,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','253315',4831869,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','253315',4831870,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','253315',4831871,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','253315',4831872,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','253315',4831873,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','253315',4831874,'2859','432',467389.52,473850.77,6461.25,1066106.25,0.00,0.00,0.00,0.00,0.00),('5','105','964','253315',4831875,'2860','432',423548.04,429701.45,6153.41,1015312.65,0.00,0.00,0.00,0.00,0.00),('5','105','965','253315',4831876,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','253315',4831877,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','253315',4831878,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','253321',4831934,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','253321',4831935,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','253321',4831936,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','253321',4831937,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','253321',4831938,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','253321',4831939,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','253321',4831940,'2859','432',473850.77,479630.03,5779.26,953577.90,0.00,0.00,0.00,0.00,0.00),('5','105','964','253321',4831941,'2860','432',429701.45,434418.47,4717.02,778308.30,0.00,0.00,0.00,0.00,0.00),('5','105','965','253321',4831942,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','253321',4831943,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','253321',4831944,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','253574',4836386,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','253574',4836387,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','253574',4836388,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','253574',4836389,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','253574',4836390,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','253574',4836391,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','253574',4836392,'2859','432',479630.03,481356.58,1726.55,284880.75,0.00,0.00,0.00,0.00,0.00),('5','105','964','253574',4836393,'2860','432',434418.47,435151.29,732.82,120915.30,0.00,0.00,0.00,0.00,0.00),('5','105','965','253574',4836394,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','253574',4836395,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','253574',4836396,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','254022',4844113,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','254022',4844114,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','254022',4844115,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','254022',4844116,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','254022',4844117,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','254022',4844118,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','254022',4844119,'2859','432',481356.58,482552.55,1195.97,197335.05,0.00,0.00,0.00,0.00,0.00),('5','105','964','254022',4844120,'2860','432',435151.29,436363.42,1212.13,200001.45,0.00,0.00,0.00,0.00,0.00),('5','105','965','254022',4844121,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','254022',4844122,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','254022',4844123,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','254182',4847272,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','254182',4847273,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','254182',4847274,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','254182',4847275,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','254182',4847276,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','254182',4847277,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','254182',4847278,'2859','432',482552.55,487944.65,5392.10,889696.50,0.00,0.00,0.00,0.00,0.00),('5','105','964','254182',4847279,'2860','432',436363.42,440878.63,4515.21,745009.65,0.00,0.00,0.00,0.00,0.00),('5','105','965','254182',4847280,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','254182',4847281,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','254182',4847282,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','254333',4849668,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','254333',4849669,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','254333',4849670,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','254333',4849671,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','254333',4849672,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','254333',4849673,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','254333',4849674,'2859','432',487944.65,492602.29,4657.64,768510.60,0.00,0.00,0.00,0.00,0.00),('5','105','964','254333',4849675,'2860','432',440878.63,446181.67,5303.04,875001.60,0.00,0.00,0.00,0.00,0.00),('5','105','965','254333',4849676,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','254333',4849677,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','254333',4849678,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','254811',4857880,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','254811',4857881,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','254811',4857882,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','254811',4857883,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','254811',4857884,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','254811',4857885,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','254811',4857886,'2859','432',492602.29,497128.50,4526.21,746824.65,0.00,0.00,0.00,0.00,0.00),('5','105','964','254811',4857887,'2860','432',446181.67,450703.13,4521.46,746040.90,0.00,0.00,0.00,0.00,0.00),('5','105','965','254811',4857888,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','254811',4857889,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','254811',4857890,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','254903',4859669,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','254903',4859670,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','254903',4859671,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','254903',4859672,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','254903',4859673,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','254903',4859674,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','254903',4859675,'2859','432',497128.50,498271.49,1142.99,188593.35,0.00,0.00,0.00,0.00,0.00),('5','105','964','254903',4859676,'2860','432',450703.13,451301.78,598.65,98777.25,0.00,0.00,0.00,0.00,0.00),('5','105','965','254903',4859677,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','254903',4859678,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','254903',4859679,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','255455',4869081,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','255455',4869082,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','255455',4869083,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','255455',4869084,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','255455',4869085,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','255455',4869086,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','255455',4869087,'2859','432',498271.49,498271.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','255455',4869088,'2860','432',451301.78,451301.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','255455',4869089,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','255455',4869090,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','255455',4869091,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','255692',4873065,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','255692',4873066,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','255692',4873067,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','255692',4873068,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','255692',4873069,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','255692',4873070,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','255692',4873071,'2859','432',498271.49,498271.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','255692',4873072,'2860','432',451301.78,451301.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','255692',4873073,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','255692',4873074,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','255692',4873075,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','255835',4875159,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','255835',4875160,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','255835',4875161,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','255835',4875162,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','255835',4875163,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','255835',4875164,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','255835',4875165,'2859','432',498271.49,498271.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','255835',4875166,'2860','432',451301.78,451301.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','255835',4875167,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','255835',4875168,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','255835',4875169,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','255909',4876572,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','255909',4876573,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','255909',4876574,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','255909',4876575,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','255909',4876576,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','255909',4876577,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','255909',4876578,'2859','432',498271.49,503049.24,4777.75,788328.75,0.00,0.00,0.00,0.00,0.00),('5','105','964','255909',4876579,'2860','432',451301.78,454355.85,3054.07,503921.55,0.00,0.00,0.00,0.00,0.00),('5','105','965','255909',4876580,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','255909',4876581,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','255909',4876582,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','256121',4880044,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','256121',4880045,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','256121',4880046,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','256121',4880047,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','256121',4880048,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','256121',4880049,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','256121',4880050,'2859','432',503049.24,508157.10,5107.86,842796.90,0.00,0.00,0.00,0.00,0.00),('5','105','964','256121',4880051,'2860','432',454355.85,458893.56,4537.71,748722.15,0.00,0.00,0.00,0.00,0.00),('5','105','965','256121',4880052,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','256121',4880053,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','256121',4880054,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','256575',4887491,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','256575',4887492,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','256575',4887493,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','256575',4887494,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','256575',4887495,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','256575',4887496,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','256575',4887497,'2859','432',508157.10,513541.77,5384.67,888470.55,0.00,0.00,0.00,0.00,0.00),('5','105','964','256575',4887498,'2860','432',458893.56,462431.75,3538.19,583801.35,0.00,0.00,0.00,0.00,0.00),('5','105','965','256575',4887499,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','256575',4887500,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','256575',4887501,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','256817',4891512,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','256817',4891513,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','256817',4891514,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','256817',4891515,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','256817',4891516,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','256817',4891517,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','256817',4891518,'2859','432',513541.77,516939.04,3397.27,560549.55,0.00,0.00,0.00,0.00,0.00),('5','105','964','256817',4891519,'2860','432',462431.75,467400.70,4968.95,819876.75,0.00,0.00,0.00,0.00,0.00),('5','105','965','256817',4891520,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','256817',4891521,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','256817',4891522,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','256919',4893458,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','256919',4893459,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','256919',4893460,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','256919',4893461,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','256919',4893462,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','256919',4893463,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','256919',4893464,'2859','432',516939.04,521680.28,4741.24,782304.60,0.00,0.00,0.00,0.00,0.00),('5','105','964','256919',4893465,'2860','432',467400.70,470796.67,3395.97,560335.05,0.00,0.00,0.00,0.00,0.00),('5','105','965','256919',4893466,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','256919',4893467,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','256919',4893468,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257481',4903437,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257481',4903438,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257481',4903439,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257481',4903440,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257481',4903441,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257481',4903442,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257481',4903443,'2859','432',521680.28,522964.55,1284.27,211904.55,0.00,0.00,0.00,0.00,0.00),('5','105','964','257481',4903444,'2860','432',470796.67,471440.76,644.09,106274.85,0.00,0.00,0.00,0.00,0.00),('5','105','965','257481',4903445,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257481',4903446,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257481',4903447,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257482',4903448,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257482',4903449,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257482',4903450,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257482',4903451,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257482',4903452,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257482',4903453,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257482',4903454,'2859','432',522964.55,523372.06,407.51,67239.15,0.00,0.00,0.00,0.00,0.00),('5','105','964','257482',4903455,'2860','432',471440.76,472327.96,887.20,146388.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257482',4903456,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257482',4903457,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257482',4903458,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257483',4903459,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257483',4903460,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257483',4903461,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257483',4903462,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257483',4903463,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257483',4903464,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257483',4903465,'2859','432',523372.06,527706.41,4334.35,715167.75,0.00,0.00,0.00,0.00,0.00),('5','105','964','257483',4903466,'2860','432',472327.96,477587.25,5259.29,867782.85,0.00,0.00,0.00,0.00,0.00),('5','105','965','257483',4903467,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257483',4903468,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257483',4903469,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257484',4903470,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257484',4903471,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257484',4903472,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257484',4903473,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257484',4903474,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257484',4903475,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257484',4903476,'2859','432',527706.41,528919.62,1213.21,200179.65,0.00,0.00,0.00,0.00,0.00),('5','105','964','257484',4903477,'2860','432',477587.25,485146.86,7559.61,1247335.65,0.00,0.00,0.00,0.00,0.00),('5','105','965','257484',4903478,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257484',4903479,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257484',4903480,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257485',4903481,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257485',4903482,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257485',4903483,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257485',4903484,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257485',4903485,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257485',4903486,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257485',4903487,'2859','432',528919.62,534736.69,5817.07,959816.55,0.00,0.00,0.00,0.00,0.00),('5','105','964','257485',4903488,'2860','432',485146.86,488007.05,2860.19,471931.35,0.00,0.00,0.00,0.00,0.00),('5','105','965','257485',4903489,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257485',4903490,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257485',4903491,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257486',4903492,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257486',4903493,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257486',4903494,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257486',4903495,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257486',4903496,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257486',4903497,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257486',4903498,'2859','432',534736.69,539436.13,4699.44,775407.60,0.00,0.00,0.00,0.00,0.00),('5','105','964','257486',4903499,'2860','432',488007.05,492357.83,4350.78,717878.70,0.00,0.00,0.00,0.00,0.00),('5','105','965','257486',4903500,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257486',4903501,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257486',4903502,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257487',4903503,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257487',4903504,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257487',4903505,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257487',4903506,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257487',4903507,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257487',4903508,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257487',4903509,'2859','432',539436.13,540798.06,1361.93,224718.45,0.00,0.00,0.00,0.00,0.00),('5','105','964','257487',4903510,'2860','432',492357.83,493290.87,933.04,153951.60,0.00,0.00,0.00,0.00,0.00),('5','105','965','257487',4903511,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257487',4903512,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257487',4903513,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257488',4903514,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257488',4903515,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257488',4903516,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257488',4903517,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257488',4903518,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257488',4903519,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257488',4903520,'2859','432',540798.06,541784.37,986.31,162741.15,0.00,0.00,0.00,0.00,0.00),('5','105','964','257488',4903521,'2860','432',493290.87,494183.59,892.72,147298.80,0.00,0.00,0.00,0.00,0.00),('5','105','965','257488',4903522,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257488',4903523,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257488',4903524,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257489',4903525,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257489',4903526,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257489',4903527,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257489',4903528,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257489',4903529,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257489',4903530,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257489',4903531,'2859','432',541784.37,545613.17,3828.80,631752.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257489',4903532,'2860','432',494183.59,498481.90,4298.31,709221.15,0.00,0.00,0.00,0.00,0.00),('5','105','965','257489',4903533,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257489',4903534,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257489',4903535,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257490',4903536,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257490',4903537,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257490',4903538,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257490',4903539,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257490',4903540,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257490',4903541,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257490',4903542,'2859','432',545613.17,550610.55,4997.38,824567.70,0.00,0.00,0.00,0.00,0.00),('5','105','964','257490',4903543,'2860','432',498481.90,503141.00,4659.10,768751.50,0.00,0.00,0.00,0.00,0.00),('5','105','965','257490',4903544,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257490',4903545,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257490',4903546,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257491',4903547,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257491',4903548,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257491',4903549,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257491',4903550,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257491',4903551,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257491',4903552,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257491',4903553,'2859','432',550610.55,555834.91,5224.36,862019.40,0.00,0.00,0.00,0.00,0.00),('5','105','964','257491',4903554,'2860','432',503141.00,507391.08,4250.08,701263.20,0.00,0.00,0.00,0.00,0.00),('5','105','965','257491',4903555,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257491',4903556,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257491',4903557,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257492',4903558,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257492',4903559,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257492',4903560,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257492',4903561,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257492',4903562,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257492',4903563,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257492',4903564,'2859','432',555834.91,560810.64,4975.73,820995.45,0.00,0.00,0.00,0.00,0.00),('5','105','964','257492',4903565,'2860','432',507391.08,511093.93,3702.85,610970.25,0.00,0.00,0.00,0.00,0.00),('5','105','965','257492',4903566,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257492',4903567,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257492',4903568,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257493',4903569,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257493',4903570,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257493',4903571,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257493',4903572,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257493',4903573,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257493',4903574,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257493',4903575,'2859','432',560810.64,561520.40,709.76,117110.40,0.00,0.00,0.00,0.00,0.00),('5','105','964','257493',4903576,'2860','432',511093.93,512101.91,1007.98,166316.70,0.00,0.00,0.00,0.00,0.00),('5','105','965','257493',4903577,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257493',4903578,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257493',4903579,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257494',4903580,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257494',4903581,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257494',4903582,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257494',4903583,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257494',4903584,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257494',4903585,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257494',4903586,'2859','432',561520.40,561520.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257494',4903587,'2860','432',512101.91,512101.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257494',4903588,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257494',4903589,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257494',4903590,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257495',4903591,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257495',4903592,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257495',4903593,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257495',4903594,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257495',4903595,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257495',4903596,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257495',4903597,'2859','432',561520.40,561520.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257495',4903598,'2860','432',512101.91,512101.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257495',4903599,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257495',4903600,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257495',4903601,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257496',4903602,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257496',4903603,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257496',4903604,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257496',4903605,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257496',4903606,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257496',4903607,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257496',4903608,'2859','432',561520.40,562693.55,1173.15,193569.75,0.00,0.00,0.00,0.00,0.00),('5','105','964','257496',4903609,'2860','432',512101.91,513352.81,1250.90,206398.50,0.00,0.00,0.00,0.00,0.00),('5','105','965','257496',4903610,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257496',4903611,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257496',4903612,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257497',4903613,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257497',4903614,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257497',4903615,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257497',4903616,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257497',4903617,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257497',4903618,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257497',4903619,'2859','432',562693.55,565718.97,3025.42,499194.30,0.00,0.00,0.00,0.00,0.00),('5','105','964','257497',4903620,'2860','432',513352.81,516003.32,2650.51,437334.15,0.00,0.00,0.00,0.00,0.00),('5','105','965','257497',4903621,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257497',4903622,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257497',4903623,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257498',4903624,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257498',4903625,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257498',4903626,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257498',4903627,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257498',4903628,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257498',4903629,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257498',4903630,'2859','432',565718.97,568545.17,2826.20,466323.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257498',4903631,'2860','432',516003.32,518379.94,2376.62,392142.30,0.00,0.00,0.00,0.00,0.00),('5','105','965','257498',4903632,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257498',4903633,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257498',4903634,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257499',4903635,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257499',4903636,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257499',4903637,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257499',4903638,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257499',4903639,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257499',4903640,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257499',4903641,'2859','432',568545.17,571666.18,3121.01,514966.65,0.00,0.00,0.00,0.00,0.00),('5','105','964','257499',4903642,'2860','432',518379.94,521175.56,2795.62,461277.30,0.00,0.00,0.00,0.00,0.00),('5','105','965','257499',4903643,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257499',4903644,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257499',4903645,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257500',4903646,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257500',4903647,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257500',4903648,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257500',4903649,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257500',4903650,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257500',4903651,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257500',4903652,'2859','432',571666.18,574152.11,2485.93,410178.45,0.00,0.00,0.00,0.00,0.00),('5','105','964','257500',4903653,'2860','432',521175.56,521175.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257500',4903654,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257500',4903655,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257500',4903656,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257501',4903657,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257501',4903658,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257501',4903659,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257501',4903660,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257501',4903661,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257501',4903662,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257501',4903663,'2859','432',574152.11,574152.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257501',4903664,'2860','432',521175.56,521175.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257501',4903665,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257501',4903666,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257501',4903667,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257502',4903668,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257502',4903669,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257502',4903670,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257502',4903671,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257502',4903672,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257502',4903673,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257502',4903674,'2859','432',574152.11,574152.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257502',4903675,'2860','432',521175.56,521175.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257502',4903676,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257502',4903677,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257502',4903678,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257503',4903679,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257503',4903680,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257503',4903681,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257503',4903682,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257503',4903683,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257503',4903684,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257503',4903685,'2859','432',574152.11,574152.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257503',4903686,'2860','432',521175.56,521175.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257503',4903687,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257503',4903688,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257503',4903689,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257504',4903690,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257504',4903691,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257504',4903692,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257504',4903693,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257504',4903694,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257504',4903695,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257504',4903696,'2859','432',574152.11,574152.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257504',4903697,'2860','432',521175.56,521175.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257504',4903698,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257504',4903699,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257504',4903700,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257505',4903701,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257505',4903702,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257505',4903703,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257505',4903704,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257505',4903705,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257505',4903706,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257505',4903707,'2859','432',574152.11,575679.91,1527.80,252087.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257505',4903708,'2860','432',521175.56,522220.38,1044.82,172395.30,0.00,0.00,0.00,0.00,0.00),('5','105','965','257505',4903709,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257505',4903710,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257505',4903711,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257506',4903712,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257506',4903713,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257506',4903714,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257506',4903715,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257506',4903716,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257506',4903717,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257506',4903718,'2859','432',575679.91,580887.02,5207.11,859173.15,0.00,0.00,0.00,0.00,0.00),('5','105','964','257506',4903719,'2860','432',522220.38,526192.65,3972.27,655424.55,0.00,0.00,0.00,0.00,0.00),('5','105','965','257506',4903720,'2861','433',65355.78,65355.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257506',4903721,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257506',4903722,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257507',4903723,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257507',4903724,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257507',4903725,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257507',4903726,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257507',4903727,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257507',4903728,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257507',4903729,'2859','432',580887.02,582330.25,1443.23,238132.95,0.00,0.00,0.00,0.00,0.00),('5','105','964','257507',4903730,'2860','432',526192.65,528988.22,2795.57,461269.05,0.00,0.00,0.00,0.00,0.00),('5','105','965','257507',4903731,'2861','433',65355.78,65655.11,299.33,124221.95,0.00,0.00,0.00,0.00,0.00),('5','105','966','257507',4903732,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257507',4903733,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257508',4903734,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257508',4903735,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257508',4903736,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257508',4903737,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257508',4903738,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257508',4903739,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257508',4903740,'2859','432',582330.25,589769.20,7438.95,1227426.75,0.00,0.00,0.00,0.00,0.00),('5','105','964','257508',4903741,'2860','432',528988.22,536032.91,7044.69,1162373.85,0.00,0.00,0.00,0.00,0.00),('5','105','965','257508',4903742,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257508',4903743,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257508',4903744,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257509',4903745,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257509',4903746,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257509',4903747,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257509',4903748,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257509',4903749,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257509',4903750,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257509',4903751,'2859','432',589769.20,593792.26,4023.06,663804.90,0.00,0.00,0.00,0.00,0.00),('5','105','964','257509',4903752,'2860','432',536032.91,539504.85,3471.94,572870.10,0.00,0.00,0.00,0.00,0.00),('5','105','965','257509',4903753,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257509',4903754,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257509',4903755,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257510',4903756,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257510',4903757,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257510',4903758,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257510',4903759,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257510',4903760,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257510',4903761,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257510',4903762,'2859','432',593792.26,597256.59,3464.33,571614.45,0.00,0.00,0.00,0.00,0.00),('5','105','964','257510',4903763,'2860','432',539504.85,541125.04,1620.19,267331.35,0.00,0.00,0.00,0.00,0.00),('5','105','965','257510',4903764,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257510',4903765,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257510',4903766,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257511',4903767,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257511',4903768,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257511',4903769,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257511',4903770,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257511',4903771,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257511',4903772,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257511',4903773,'2859','432',597256.59,598554.79,1298.20,214203.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257511',4903774,'2860','432',541125.04,542258.25,1133.21,186979.65,0.00,0.00,0.00,0.00,0.00),('5','105','965','257511',4903775,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257511',4903776,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257511',4903777,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257512',4903778,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257512',4903779,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257512',4903780,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257512',4903781,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257512',4903782,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257512',4903783,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257512',4903784,'2859','432',598554.79,603501.17,4946.38,816152.70,0.00,0.00,0.00,0.00,0.00),('5','105','964','257512',4903785,'2860','432',542258.25,547783.15,5524.90,911608.50,0.00,0.00,0.00,0.00,0.00),('5','105','965','257512',4903786,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257512',4903787,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257512',4903788,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257513',4903789,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257513',4903790,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257513',4903791,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257513',4903792,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257513',4903793,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257513',4903794,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257513',4903795,'2859','432',603501.17,607510.61,4009.44,661557.60,0.00,0.00,0.00,0.00,0.00),('5','105','964','257513',4903796,'2860','432',547783.15,551372.83,3589.68,592297.20,0.00,0.00,0.00,0.00,0.00),('5','105','965','257513',4903797,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257513',4903798,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257513',4903799,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257514',4903800,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257514',4903801,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257514',4903802,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257514',4903803,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257514',4903804,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257514',4903805,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257514',4903806,'2859','432',607510.61,613643.78,6133.17,1011973.05,0.00,0.00,0.00,0.00,0.00),('5','105','964','257514',4903807,'2860','432',551372.83,553318.47,1945.64,321030.60,0.00,0.00,0.00,0.00,0.00),('5','105','965','257514',4903808,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257514',4903809,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257514',4903810,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257515',4903811,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257515',4903812,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257515',4903813,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257515',4903814,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257515',4903815,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257515',4903816,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257515',4903817,'2859','432',613643.78,617899.42,4255.64,702180.60,0.00,0.00,0.00,0.00,0.00),('5','105','964','257515',4903818,'2860','432',553318.47,557068.69,3750.22,618786.30,0.00,0.00,0.00,0.00,0.00),('5','105','965','257515',4903819,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257515',4903820,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257515',4903821,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257516',4903822,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257516',4903823,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257516',4903824,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257516',4903825,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257516',4903826,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257516',4903827,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257516',4903828,'2859','432',617899.42,617899.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257516',4903829,'2860','432',557068.69,558768.81,1700.12,280519.80,0.00,0.00,0.00,0.00,0.00),('5','105','965','257516',4903830,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257516',4903831,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257516',4903832,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257517',4903833,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257517',4903834,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257517',4903835,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257517',4903836,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257517',4903837,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257517',4903838,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257517',4903839,'2859','432',617899.42,617899.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257517',4903840,'2860','432',558768.81,558768.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257517',4903841,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257517',4903842,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257517',4903843,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257518',4903844,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257518',4903845,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257518',4903846,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257518',4903847,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257518',4903848,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257518',4903849,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257518',4903850,'2859','432',617899.42,617899.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257518',4903851,'2860','432',558768.81,558768.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257518',4903852,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257518',4903853,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257518',4903854,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257519',4903855,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257519',4903856,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257519',4903857,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257519',4903858,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257519',4903859,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257519',4903860,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257519',4903861,'2859','432',617899.42,617899.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257519',4903862,'2860','432',558768.81,558768.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257519',4903863,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257519',4903864,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257519',4903865,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257520',4903866,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257520',4903867,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257520',4903868,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257520',4903869,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257520',4903870,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257520',4903871,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257520',4903872,'2859','432',617899.42,623608.78,5709.36,942044.40,0.00,0.00,0.00,0.00,0.00),('5','105','964','257520',4903873,'2860','432',558768.81,561153.54,2384.73,393480.45,0.00,0.00,0.00,0.00,0.00),('5','105','965','257520',4903874,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257520',4903875,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257520',4903876,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257521',4903877,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257521',4903878,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257521',4903879,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257521',4903880,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257521',4903881,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257521',4903882,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257521',4903883,'2859','432',623608.78,628001.33,4392.55,724770.75,0.00,0.00,0.00,0.00,0.00),('5','105','964','257521',4903884,'2860','432',561153.54,568548.74,7395.20,1220208.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257521',4903885,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257521',4903886,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257521',4903887,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257522',4903888,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257522',4903889,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257522',4903890,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257522',4903891,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257522',4903892,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257522',4903893,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257522',4903894,'2859','432',628001.33,629491.12,1489.79,245815.35,0.00,0.00,0.00,0.00,0.00),('5','105','964','257522',4903895,'2860','432',568548.74,569490.40,941.66,155373.90,0.00,0.00,0.00,0.00,0.00),('5','105','965','257522',4903896,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257522',4903897,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257522',4903898,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257523',4903899,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257523',4903900,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257523',4903901,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257523',4903902,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257523',4903903,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257523',4903904,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257523',4903905,'2859','432',629491.12,629491.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257523',4903906,'2860','432',569490.40,569490.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257523',4903907,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257523',4903908,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257523',4903909,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257524',4903910,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257524',4903911,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257524',4903912,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257524',4903913,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257524',4903914,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257524',4903915,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257524',4903916,'2859','432',629491.12,632083.09,2591.97,427675.05,0.00,0.00,0.00,0.00,0.00),('5','105','964','257524',4903917,'2860','432',569490.40,571943.04,2452.64,404685.60,0.00,0.00,0.00,0.00,0.00),('5','105','965','257524',4903918,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257524',4903919,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257524',4903920,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257525',4903921,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257525',4903922,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257525',4903923,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257525',4903924,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257525',4903925,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257525',4903926,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257525',4903927,'2859','432',632083.09,636567.05,4483.96,739853.40,0.00,0.00,0.00,0.00,0.00),('5','105','964','257525',4903928,'2860','432',571943.04,578428.67,6485.63,1070128.95,0.00,0.00,0.00,0.00,0.00),('5','105','965','257525',4903929,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257525',4903930,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257525',4903931,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257526',4903932,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257526',4903933,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257526',4903934,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257526',4903935,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257526',4903936,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257526',4903937,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257526',4903938,'2859','432',636567.05,645590.50,9023.45,1488869.25,0.00,0.00,0.00,0.00,0.00),('5','105','964','257526',4903939,'2860','432',578428.67,578428.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257526',4903940,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257526',4903941,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257526',4903942,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257527',4903943,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257527',4903944,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257527',4903945,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257527',4903946,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257527',4903947,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257527',4903948,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257527',4903949,'2859','432',645590.50,645819.75,229.25,37826.25,0.00,0.00,0.00,0.00,0.00),('5','105','964','257527',4903950,'2860','432',578428.67,583069.17,4640.50,765682.50,0.00,0.00,0.00,0.00,0.00),('5','105','965','257527',4903951,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257527',4903952,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257527',4903953,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257528',4903954,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257528',4903955,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257528',4903956,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257528',4903957,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257528',4903958,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257528',4903959,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257528',4903960,'2859','432',645819.75,645819.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257528',4903961,'2860','432',583069.17,583069.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257528',4903962,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257528',4903963,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257528',4903964,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257529',4903965,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257529',4903966,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257529',4903967,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257529',4903968,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257529',4903969,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257529',4903970,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257529',4903971,'2859','432',645819.75,645819.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257529',4903972,'2860','432',583069.17,583069.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257529',4903973,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257529',4903974,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257529',4903975,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257530',4903976,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257530',4903977,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257530',4903978,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257530',4903979,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257530',4903980,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257530',4903981,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257530',4903982,'2859','432',645819.75,645819.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257530',4903983,'2860','432',583069.17,583069.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257530',4903984,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257530',4903985,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257530',4903986,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257531',4903987,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257531',4903988,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257531',4903989,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257531',4903990,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257531',4903991,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257531',4903992,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257531',4903993,'2859','432',645819.75,645819.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257531',4903994,'2860','432',583069.17,583069.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257531',4903995,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257531',4903996,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257531',4903997,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257532',4903998,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257532',4903999,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257532',4904000,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257532',4904001,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257532',4904002,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257532',4904003,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257532',4904004,'2859','432',645819.75,645819.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257532',4904005,'2860','432',583069.17,583069.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257532',4904006,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257532',4904007,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257532',4904008,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257533',4904009,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257533',4904010,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257533',4904011,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257533',4904012,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257533',4904013,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257533',4904014,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257533',4904015,'2859','432',645819.75,645819.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257533',4904016,'2860','432',583069.17,583069.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257533',4904017,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257533',4904018,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257533',4904019,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257534',4904020,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257534',4904021,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257534',4904022,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257534',4904023,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257534',4904024,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257534',4904025,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257534',4904026,'2859','432',645819.75,645819.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257534',4904027,'2860','432',583069.17,583069.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257534',4904028,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257534',4904029,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257534',4904030,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257535',4904031,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257535',4904032,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257535',4904033,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257535',4904034,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257535',4904035,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257535',4904036,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257535',4904037,'2859','432',645819.75,645819.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257535',4904038,'2860','432',583069.17,583069.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257535',4904039,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257535',4904040,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257535',4904041,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257536',4904042,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257536',4904043,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257536',4904044,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257536',4904045,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257536',4904046,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257536',4904047,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257536',4904048,'2859','432',645819.75,645819.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257536',4904049,'2860','432',583069.17,583069.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257536',4904050,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257536',4904051,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257536',4904052,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257537',4904053,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257537',4904054,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257537',4904055,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257537',4904056,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257537',4904057,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257537',4904058,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257537',4904059,'2859','432',645819.75,645819.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257537',4904060,'2860','432',583069.17,583069.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257537',4904061,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257537',4904062,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257537',4904063,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257538',4904064,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257538',4904065,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257538',4904066,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257538',4904067,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257538',4904068,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257538',4904069,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257538',4904070,'2859','432',645819.75,647393.10,1573.35,259602.75,0.00,0.00,0.00,0.00,0.00),('5','105','964','257538',4904071,'2860','432',583069.17,584403.87,1334.70,220225.50,0.00,0.00,0.00,0.00,0.00),('5','105','965','257538',4904072,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257538',4904073,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257538',4904074,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257539',4904075,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257539',4904076,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257539',4904077,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257539',4904078,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257539',4904079,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257539',4904080,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257539',4904081,'2859','432',647393.10,649898.76,2505.66,413433.90,0.00,0.00,0.00,0.00,0.00),('5','105','964','257539',4904082,'2860','432',584403.87,586973.35,2569.48,423964.20,0.00,0.00,0.00,0.00,0.00),('5','105','965','257539',4904083,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257539',4904084,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257539',4904085,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257540',4904086,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257540',4904087,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257540',4904088,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257540',4904089,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257540',4904090,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257540',4904091,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257540',4904092,'2859','432',649898.76,652971.91,3073.15,507069.75,0.00,0.00,0.00,0.00,0.00),('5','105','964','257540',4904093,'2860','432',586973.35,588412.87,1439.52,237520.80,0.00,0.00,0.00,0.00,0.00),('5','105','965','257540',4904094,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257540',4904095,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257540',4904096,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257541',4904097,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257541',4904098,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257541',4904099,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257541',4904100,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257541',4904101,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257541',4904102,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257541',4904103,'2859','432',652971.91,654735.31,1763.40,290961.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257541',4904104,'2860','432',588412.87,589056.30,643.43,106165.95,0.00,0.00,0.00,0.00,0.00),('5','105','965','257541',4904105,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257541',4904106,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257541',4904107,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257542',4904108,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257542',4904109,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257542',4904110,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257542',4904111,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257542',4904112,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257542',4904113,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257542',4904114,'2859','432',654735.31,654735.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257542',4904115,'2860','432',589056.30,589056.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257542',4904116,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257542',4904117,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257542',4904118,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257543',4904119,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257543',4904120,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257543',4904121,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257543',4904122,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257543',4904123,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257543',4904124,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257543',4904125,'2859','432',654735.31,654735.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257543',4904126,'2860','432',589056.30,589056.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257543',4904127,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257543',4904128,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257543',4904129,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257544',4904130,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257544',4904131,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257544',4904132,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257544',4904133,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257544',4904134,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257544',4904135,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257544',4904136,'2859','432',654735.31,654735.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257544',4904137,'2860','432',589056.30,589056.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257544',4904138,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257544',4904139,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257544',4904140,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257545',4904141,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257545',4904142,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257545',4904143,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257545',4904144,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257545',4904145,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257545',4904146,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257545',4904147,'2859','432',654735.31,654735.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257545',4904148,'2860','432',589056.30,589056.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257545',4904149,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257545',4904150,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257545',4904151,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257546',4904152,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257546',4904153,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257546',4904154,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257546',4904155,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257546',4904156,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257546',4904157,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257546',4904158,'2859','432',654735.31,654735.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257546',4904159,'2860','432',589056.30,589056.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257546',4904160,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257546',4904161,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257546',4904162,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257547',4904163,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257547',4904164,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257547',4904165,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257547',4904166,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257547',4904167,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257547',4904168,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257547',4904169,'2859','432',654735.31,654735.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257547',4904170,'2860','432',589056.30,589056.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257547',4904171,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257547',4904172,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257547',4904173,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257548',4904174,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257548',4904175,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257548',4904176,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257548',4904177,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257548',4904178,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257548',4904179,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257548',4904180,'2859','432',654735.31,654735.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257548',4904181,'2860','432',589056.30,589056.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257548',4904182,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257548',4904183,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257548',4904184,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257549',4904185,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257549',4904186,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257549',4904187,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257549',4904188,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257549',4904189,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257549',4904190,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257549',4904191,'2859','432',654735.31,657326.23,2590.92,427501.80,0.00,0.00,0.00,0.00,0.00),('5','105','964','257549',4904192,'2860','432',589056.30,591638.69,2582.39,426094.35,0.00,0.00,0.00,0.00,0.00),('5','105','965','257549',4904193,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257549',4904194,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257549',4904195,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257550',4904196,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257550',4904197,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257550',4904198,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257550',4904199,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257550',4904200,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257550',4904201,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257550',4904202,'2859','432',657326.23,660532.60,3206.37,529051.05,0.00,0.00,0.00,0.00,0.00),('5','105','964','257550',4904203,'2860','432',591638.69,594224.86,2586.17,426718.05,0.00,0.00,0.00,0.00,0.00),('5','105','965','257550',4904204,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257550',4904205,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257550',4904206,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257551',4904207,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257551',4904208,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257551',4904209,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257551',4904210,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257551',4904211,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257551',4904212,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257551',4904213,'2859','432',660532.60,662073.17,1540.57,254194.05,0.00,0.00,0.00,0.00,0.00),('5','105','964','257551',4904214,'2860','432',594224.86,595021.49,796.63,131443.95,0.00,0.00,0.00,0.00,0.00),('5','105','965','257551',4904215,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257551',4904216,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257551',4904217,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257552',4904218,'2853','432',178559.91,178559.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257552',4904219,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257552',4904220,'2855','432',203303.28,203303.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257552',4904221,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257552',4904222,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257552',4904223,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257552',4904224,'2859','432',662073.17,664897.58,2824.41,466027.65,0.00,0.00,0.00,0.00,0.00),('5','105','964','257552',4904225,'2860','432',595021.49,597693.43,2671.94,440870.10,0.00,0.00,0.00,0.00,0.00),('5','105','965','257552',4904226,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257552',4904227,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257552',4904228,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257553',4904229,'2853','432',178559.91,179527.47,967.56,159647.40,0.00,0.00,0.00,0.00,0.00),('5','105','961','257553',4904230,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257553',4904231,'2855','432',203303.28,205004.13,1700.85,280640.25,0.00,0.00,0.00,0.00,0.00),('5','105','961','257553',4904232,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257553',4904233,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257553',4904234,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257553',4904235,'2859','432',664897.58,668434.97,3537.39,583669.35,0.00,0.00,0.00,0.00,0.00),('5','105','964','257553',4904236,'2860','432',597693.43,600989.79,3296.36,543899.40,0.00,0.00,0.00,0.00,0.00),('5','105','965','257553',4904237,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257553',4904238,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257553',4904239,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257554',4904240,'2853','432',179527.47,182367.62,2840.15,468624.75,0.00,0.00,0.00,0.00,0.00),('5','105','961','257554',4904241,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257554',4904242,'2855','432',205004.13,208164.23,3160.10,521416.50,0.00,0.00,0.00,0.00,0.00),('5','105','961','257554',4904243,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257554',4904244,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257554',4904245,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257554',4904246,'2859','432',668434.97,670996.61,2561.64,422670.60,0.00,0.00,0.00,0.00,0.00),('5','105','964','257554',4904247,'2860','432',600989.79,600989.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257554',4904248,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257554',4904249,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257554',4904250,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257555',4904251,'2853','432',182367.62,186084.89,3717.27,613349.55,0.00,0.00,0.00,0.00,0.00),('5','105','961','257555',4904252,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257555',4904253,'2855','432',208164.23,211692.82,3528.59,582217.35,0.00,0.00,0.00,0.00,0.00),('5','105','961','257555',4904254,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257555',4904255,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257555',4904256,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257555',4904257,'2859','432',670996.61,670996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257555',4904258,'2860','432',600989.79,600989.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257555',4904259,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257555',4904260,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257555',4904261,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257556',4904262,'2853','432',186084.89,189618.80,3533.91,583095.15,0.00,0.00,0.00,0.00,0.00),('5','105','961','257556',4904263,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257556',4904264,'2855','432',211692.82,215271.94,3579.12,590554.80,0.00,0.00,0.00,0.00,0.00),('5','105','961','257556',4904265,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257556',4904266,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257556',4904267,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257556',4904268,'2859','432',670996.61,670996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257556',4904269,'2860','432',600989.79,600989.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257556',4904270,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257556',4904271,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257556',4904272,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257557',4904273,'2853','432',189618.80,193007.03,3388.23,559057.95,0.00,0.00,0.00,0.00,0.00),('5','105','961','257557',4904274,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257557',4904275,'2855','432',215271.94,218911.85,3639.91,600585.15,0.00,0.00,0.00,0.00,0.00),('5','105','961','257557',4904276,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257557',4904277,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257557',4904278,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257557',4904279,'2859','432',670996.61,670996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257557',4904280,'2860','432',600989.79,600989.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257557',4904281,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257557',4904282,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257557',4904283,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257558',4904284,'2853','432',193007.03,197278.25,4271.22,704751.30,0.00,0.00,0.00,0.00,0.00),('5','105','961','257558',4904285,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257558',4904286,'2855','432',218911.85,220633.54,1721.69,284078.85,0.00,0.00,0.00,0.00,0.00),('5','105','961','257558',4904287,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257558',4904288,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257558',4904289,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257558',4904290,'2859','432',670996.61,670996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257558',4904291,'2860','432',600989.79,600989.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257558',4904292,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257558',4904293,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257558',4904294,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257559',4904295,'2853','432',197278.25,197964.70,686.45,113264.25,0.00,0.00,0.00,0.00,0.00),('5','105','961','257559',4904296,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257559',4904297,'2855','432',220633.54,223360.03,2726.49,449870.85,0.00,0.00,0.00,0.00,0.00),('5','105','961','257559',4904298,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257559',4904299,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257559',4904300,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257559',4904301,'2859','432',670996.61,670996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257559',4904302,'2860','432',600989.79,600989.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257559',4904303,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257559',4904304,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257559',4904305,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257560',4904306,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257560',4904307,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257560',4904308,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257560',4904309,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257560',4904310,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257560',4904311,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257560',4904312,'2859','432',670996.61,670996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257560',4904313,'2860','432',600989.79,600989.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257560',4904314,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257560',4904315,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257560',4904316,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257561',4904317,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257561',4904318,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257561',4904319,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257561',4904320,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257561',4904321,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257561',4904322,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257561',4904323,'2859','432',670996.61,670996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257561',4904324,'2860','432',600989.79,600989.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257561',4904325,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257561',4904326,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257561',4904327,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257562',4904328,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257562',4904329,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257562',4904330,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257562',4904331,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257562',4904332,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257562',4904333,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257562',4904334,'2859','432',670996.61,670996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257562',4904335,'2860','432',600989.79,600989.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257562',4904336,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257562',4904337,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257562',4904338,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257563',4904339,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257563',4904340,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257563',4904341,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257563',4904342,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257563',4904343,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257563',4904344,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257563',4904345,'2859','432',670996.61,670996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257563',4904346,'2860','432',600989.79,600989.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257563',4904347,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257563',4904348,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257563',4904349,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257564',4904350,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257564',4904351,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257564',4904352,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257564',4904353,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257564',4904354,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257564',4904355,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257564',4904356,'2859','432',670996.61,670996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257564',4904357,'2860','432',600989.79,600989.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257564',4904358,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257564',4904359,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257564',4904360,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257565',4904361,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257565',4904362,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257565',4904363,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257565',4904364,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257565',4904365,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257565',4904366,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257565',4904367,'2859','432',670996.61,670996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257565',4904368,'2860','432',600989.79,600989.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257565',4904369,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257565',4904370,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257565',4904371,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257566',4904372,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257566',4904373,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257566',4904374,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257566',4904375,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257566',4904376,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257566',4904377,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257566',4904378,'2859','432',670996.61,674241.82,3245.21,535459.65,0.00,0.00,0.00,0.00,0.00),('5','105','964','257566',4904379,'2860','432',600989.79,600989.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257566',4904380,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257566',4904381,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257566',4904382,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257567',4904383,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257567',4904384,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257567',4904385,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257567',4904386,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257567',4904387,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257567',4904388,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257567',4904389,'2859','432',674241.82,676697.16,2455.34,405131.10,0.00,0.00,0.00,0.00,0.00),('5','105','964','257567',4904390,'2860','432',600989.79,603194.95,2205.16,363851.40,0.00,0.00,0.00,0.00,0.00),('5','105','965','257567',4904391,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257567',4904392,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257567',4904393,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257568',4904394,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257568',4904395,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257568',4904396,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257568',4904397,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257568',4904398,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257568',4904399,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257568',4904400,'2859','432',676697.16,678565.74,1868.58,308315.70,0.00,0.00,0.00,0.00,0.00),('5','105','964','257568',4904401,'2860','432',603194.95,605572.72,2377.77,392332.05,0.00,0.00,0.00,0.00,0.00),('5','105','965','257568',4904402,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257568',4904403,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257568',4904404,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257569',4904405,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257569',4904406,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257569',4904407,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257569',4904408,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257569',4904409,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257569',4904410,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257569',4904411,'2859','432',678565.74,678706.27,140.53,23187.45,0.00,0.00,0.00,0.00,0.00),('5','105','964','257569',4904412,'2860','432',605572.72,606884.20,1311.48,216394.20,0.00,0.00,0.00,0.00,0.00),('5','105','965','257569',4904413,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257569',4904414,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257569',4904415,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257570',4904416,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257570',4904417,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257570',4904418,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257570',4904419,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257570',4904420,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257570',4904421,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257570',4904422,'2859','432',678706.27,678706.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257570',4904423,'2860','432',606884.20,606884.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257570',4904424,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257570',4904425,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257570',4904426,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257571',4904427,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257571',4904428,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257571',4904429,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257571',4904430,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257571',4904431,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257571',4904432,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257571',4904433,'2859','432',678706.27,679738.56,1032.29,170327.85,0.00,0.00,0.00,0.00,0.00),('5','105','964','257571',4904434,'2860','432',606884.20,607762.03,877.83,144841.95,0.00,0.00,0.00,0.00,0.00),('5','105','965','257571',4904435,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257571',4904436,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257571',4904437,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257572',4904438,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257572',4904439,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257572',4904440,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257572',4904441,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257572',4904442,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257572',4904443,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257572',4904444,'2859','432',679738.56,683712.52,3973.96,655703.40,0.00,0.00,0.00,0.00,0.00),('5','105','964','257572',4904445,'2860','432',607762.03,611300.57,3538.54,583859.10,0.00,0.00,0.00,0.00,0.00),('5','105','965','257572',4904446,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257572',4904447,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257572',4904448,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257573',4904449,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257573',4904450,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257573',4904451,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257573',4904452,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257573',4904453,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257573',4904454,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257573',4904455,'2859','432',683712.52,687163.76,3451.24,569454.60,0.00,0.00,0.00,0.00,0.00),('5','105','964','257573',4904456,'2860','432',611300.57,614580.54,3279.97,541195.05,0.00,0.00,0.00,0.00,0.00),('5','105','965','257573',4904457,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257573',4904458,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257573',4904459,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257574',4904460,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257574',4904461,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257574',4904462,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257574',4904463,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257574',4904464,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257574',4904465,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257574',4904466,'2859','432',687163.76,689981.26,2817.50,464887.50,0.00,0.00,0.00,0.00,0.00),('5','105','964','257574',4904467,'2860','432',614580.54,617790.09,3209.55,529575.75,0.00,0.00,0.00,0.00,0.00),('5','105','965','257574',4904468,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257574',4904469,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257574',4904470,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257575',4904471,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257575',4904472,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257575',4904473,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257575',4904474,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257575',4904475,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257575',4904476,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257575',4904477,'2859','432',689981.26,692646.98,2665.72,439843.80,0.00,0.00,0.00,0.00,0.00),('5','105','964','257575',4904478,'2860','432',617790.09,620468.09,2678.00,441870.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257575',4904479,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257575',4904480,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257575',4904481,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257576',4904482,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257576',4904483,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257576',4904484,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257576',4904485,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257576',4904486,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257576',4904487,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257576',4904488,'2859','432',692646.98,695054.72,2407.74,397277.10,0.00,0.00,0.00,0.00,0.00),('5','105','964','257576',4904489,'2860','432',620468.09,623445.06,2976.97,491200.05,0.00,0.00,0.00,0.00,0.00),('5','105','965','257576',4904490,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257576',4904491,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257576',4904492,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257577',4904493,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257577',4904494,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257577',4904495,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257577',4904496,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257577',4904497,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257577',4904498,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257577',4904499,'2859','432',695054.72,698175.36,3120.64,514905.60,0.00,0.00,0.00,0.00,0.00),('5','105','964','257577',4904500,'2860','432',623445.06,625339.13,1894.07,312521.55,0.00,0.00,0.00,0.00,0.00),('5','105','965','257577',4904501,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257577',4904502,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257577',4904503,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257578',4904504,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257578',4904505,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257578',4904506,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257578',4904507,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257578',4904508,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257578',4904509,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257578',4904510,'2859','432',698175.36,700475.36,2300.00,379500.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257578',4904511,'2860','432',625339.13,625339.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257578',4904512,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257578',4904513,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257578',4904514,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257579',4904515,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257579',4904516,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257579',4904517,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257579',4904518,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257579',4904519,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257579',4904520,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257579',4904521,'2859','432',700475.36,700475.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257579',4904522,'2860','432',625339.13,625339.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257579',4904523,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257579',4904524,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257579',4904525,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257580',4904526,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257580',4904527,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257580',4904528,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257580',4904529,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257580',4904530,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257580',4904531,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257580',4904532,'2859','432',700475.36,700475.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257580',4904533,'2860','432',625339.13,625339.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257580',4904534,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257580',4904535,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257580',4904536,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257581',4904537,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257581',4904538,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257581',4904539,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257581',4904540,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257581',4904541,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257581',4904542,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257581',4904543,'2859','432',700475.36,704065.23,3589.87,592328.55,0.00,0.00,0.00,0.00,0.00),('5','105','964','257581',4904544,'2860','432',625339.13,629825.22,4486.09,740204.85,0.00,0.00,0.00,0.00,0.00),('5','105','965','257581',4904545,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257581',4904546,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257581',4904547,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257582',4904548,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257582',4904549,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257582',4904550,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257582',4904551,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257582',4904552,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257582',4904553,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257582',4904554,'2859','432',704065.23,707829.49,3764.26,621102.90,0.00,0.00,0.00,0.00,0.00),('5','105','964','257582',4904555,'2860','432',629825.22,634075.68,4250.46,701325.90,0.00,0.00,0.00,0.00,0.00),('5','105','965','257582',4904556,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257582',4904557,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257582',4904558,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257583',4904559,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257583',4904560,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257583',4904561,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257583',4904562,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257583',4904563,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257583',4904564,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257583',4904565,'2859','432',707829.49,711576.90,3747.41,618322.65,0.00,0.00,0.00,0.00,0.00),('5','105','964','257583',4904566,'2860','432',634075.68,637428.81,3353.13,553266.45,0.00,0.00,0.00,0.00,0.00),('5','105','965','257583',4904567,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257583',4904568,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257583',4904569,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257584',4904570,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257584',4904571,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257584',4904572,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257584',4904573,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257584',4904574,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257584',4904575,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257584',4904576,'2859','432',711576.90,715237.51,3660.61,604000.65,0.00,0.00,0.00,0.00,0.00),('5','105','964','257584',4904577,'2860','432',637428.81,641012.18,3583.37,591256.05,0.00,0.00,0.00,0.00,0.00),('5','105','965','257584',4904578,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257584',4904579,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257584',4904580,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257585',4904581,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257585',4904582,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257585',4904583,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257585',4904584,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257585',4904585,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257585',4904586,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257585',4904587,'2859','432',715237.51,718317.53,3080.02,508203.30,0.00,0.00,0.00,0.00,0.00),('5','105','964','257585',4904588,'2860','432',641012.18,644311.88,3299.70,544450.50,0.00,0.00,0.00,0.00,0.00),('5','105','965','257585',4904589,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257585',4904590,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257585',4904591,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257586',4904592,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257586',4904593,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257586',4904594,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257586',4904595,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257586',4904596,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257586',4904597,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257586',4904598,'2859','432',718317.53,722289.01,3971.48,655294.20,0.00,0.00,0.00,0.00,0.00),('5','105','964','257586',4904599,'2860','432',644311.88,646437.86,2125.98,350786.70,0.00,0.00,0.00,0.00,0.00),('5','105','965','257586',4904600,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257586',4904601,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257586',4904602,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257587',4904603,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257587',4904604,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257587',4904605,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257587',4904606,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257587',4904607,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257587',4904608,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257587',4904609,'2859','432',722289.01,725761.10,3472.09,572894.85,0.00,0.00,0.00,0.00,0.00),('5','105','964','257587',4904610,'2860','432',646437.86,649517.99,3080.13,508221.45,0.00,0.00,0.00,0.00,0.00),('5','105','965','257587',4904611,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257587',4904612,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257587',4904613,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257588',4904614,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257588',4904615,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257588',4904616,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257588',4904617,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257588',4904618,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257588',4904619,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257588',4904620,'2859','432',725761.10,729513.77,3752.67,619190.55,0.00,0.00,0.00,0.00,0.00),('5','105','964','257588',4904621,'2860','432',649517.99,652865.02,3347.03,552259.95,0.00,0.00,0.00,0.00,0.00),('5','105','965','257588',4904622,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257588',4904623,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257588',4904624,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257589',4904625,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257589',4904626,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257589',4904627,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257589',4904628,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257589',4904629,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257589',4904630,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257589',4904631,'2859','432',729513.77,732612.70,3098.93,511323.45,0.00,0.00,0.00,0.00,0.00),('5','105','964','257589',4904632,'2860','432',652865.02,652865.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257589',4904633,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257589',4904634,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257589',4904635,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257590',4904636,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257590',4904637,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257590',4904638,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257590',4904639,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257590',4904640,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257590',4904641,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257590',4904642,'2859','432',732612.70,734303.24,1690.54,278939.10,0.00,0.00,0.00,0.00,0.00),('5','105','964','257590',4904643,'2860','432',652865.02,656437.97,3572.95,589536.75,0.00,0.00,0.00,0.00,0.00),('5','105','965','257590',4904644,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257590',4904645,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257590',4904646,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257591',4904647,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257591',4904648,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257591',4904649,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257591',4904650,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257591',4904651,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257591',4904652,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257591',4904653,'2859','432',734303.24,736716.57,2413.33,398199.45,0.00,0.00,0.00,0.00,0.00),('5','105','964','257591',4904654,'2860','432',656437.97,658209.55,1771.58,292310.70,0.00,0.00,0.00,0.00,0.00),('5','105','965','257591',4904655,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257591',4904656,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257591',4904657,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257592',4904658,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257592',4904659,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257592',4904660,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257592',4904661,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257592',4904662,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257592',4904663,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257592',4904664,'2859','432',736716.57,739194.20,2477.63,408808.95,0.00,0.00,0.00,0.00,0.00),('5','105','964','257592',4904665,'2860','432',658209.55,659725.60,1516.05,250148.25,0.00,0.00,0.00,0.00,0.00),('5','105','965','257592',4904666,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257592',4904667,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257592',4904668,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257593',4904669,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257593',4904670,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257593',4904671,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257593',4904672,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257593',4904673,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257593',4904674,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257593',4904675,'2859','432',739194.20,741244.20,2050.00,338250.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257593',4904676,'2860','432',659725.60,659725.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257593',4904677,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257593',4904678,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257593',4904679,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257594',4904680,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257594',4904681,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257594',4904682,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257594',4904683,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257594',4904684,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257594',4904685,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257594',4904686,'2859','432',741244.20,742135.68,891.48,147094.20,0.00,0.00,0.00,0.00,0.00),('5','105','964','257594',4904687,'2860','432',659725.60,660533.88,808.28,133366.20,0.00,0.00,0.00,0.00,0.00),('5','105','965','257594',4904688,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257594',4904689,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257594',4904690,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257595',4904691,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257595',4904692,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257595',4904693,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257595',4904694,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257595',4904695,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257595',4904696,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257595',4904697,'2859','432',742135.68,744399.46,2263.78,373523.70,0.00,0.00,0.00,0.00,0.00),('5','105','964','257595',4904698,'2860','432',660533.88,662581.39,2047.51,337839.15,0.00,0.00,0.00,0.00,0.00),('5','105','965','257595',4904699,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257595',4904700,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257595',4904701,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257596',4904702,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257596',4904703,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257596',4904704,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257596',4904705,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257596',4904706,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257596',4904707,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257596',4904708,'2859','432',744399.46,746269.38,1869.92,308536.80,0.00,0.00,0.00,0.00,0.00),('5','105','964','257596',4904709,'2860','432',662581.39,664911.36,2329.97,384445.05,0.00,0.00,0.00,0.00,0.00),('5','105','965','257596',4904710,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257596',4904711,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257596',4904712,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257597',4904713,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257597',4904714,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257597',4904715,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257597',4904716,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257597',4904717,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257597',4904718,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257597',4904719,'2859','432',746269.38,749840.25,3570.87,589193.55,0.00,0.00,0.00,0.00,0.00),('5','105','964','257597',4904720,'2860','432',664911.36,667084.16,2172.80,358512.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257597',4904721,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257597',4904722,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257597',4904723,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257598',4904724,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257598',4904725,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257598',4904726,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257598',4904727,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257598',4904728,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257598',4904729,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257598',4904730,'2859','432',749840.25,751831.08,1990.83,328486.95,0.00,0.00,0.00,0.00,0.00),('5','105','964','257598',4904731,'2860','432',667084.16,669329.15,2244.99,370423.35,0.00,0.00,0.00,0.00,0.00),('5','105','965','257598',4904732,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257598',4904733,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257598',4904734,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257599',4904735,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257599',4904736,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257599',4904737,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257599',4904738,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257599',4904739,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257599',4904740,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257599',4904741,'2859','432',751831.08,754375.95,2544.87,419903.55,0.00,0.00,0.00,0.00,0.00),('5','105','964','257599',4904742,'2860','432',669329.15,671148.35,1819.20,300168.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257599',4904743,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257599',4904744,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257599',4904745,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257600',4904746,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257600',4904747,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257600',4904748,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257600',4904749,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257600',4904750,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257600',4904751,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257600',4904752,'2859','432',754375.95,756561.61,2185.66,360633.90,0.00,0.00,0.00,0.00,0.00),('5','105','964','257600',4904753,'2860','432',671148.35,673127.74,1979.39,326599.35,0.00,0.00,0.00,0.00,0.00),('5','105','965','257600',4904754,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257600',4904755,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257600',4904756,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257601',4904757,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257601',4904758,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257601',4904759,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257601',4904760,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257601',4904761,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257601',4904762,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257601',4904763,'2859','432',756561.61,758776.49,2214.88,365455.20,0.00,0.00,0.00,0.00,0.00),('5','105','964','257601',4904764,'2860','432',673127.74,675418.79,2291.05,378023.25,0.00,0.00,0.00,0.00,0.00),('5','105','965','257601',4904765,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257601',4904766,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257601',4904767,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257602',4904768,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257602',4904769,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257602',4904770,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257602',4904771,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257602',4904772,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257602',4904773,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257602',4904774,'2859','432',758776.49,761321.70,2545.21,419959.65,0.00,0.00,0.00,0.00,0.00),('5','105','964','257602',4904775,'2860','432',675418.79,677142.58,1723.79,284425.35,0.00,0.00,0.00,0.00,0.00),('5','105','965','257602',4904776,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257602',4904777,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257602',4904778,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257603',4904779,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257603',4904780,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257603',4904781,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257603',4904782,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257603',4904783,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257603',4904784,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257603',4904785,'2859','432',761321.70,764181.11,2859.41,471802.65,0.00,0.00,0.00,0.00,0.00),('5','105','964','257603',4904786,'2860','432',677142.58,679096.65,1954.07,322421.55,0.00,0.00,0.00,0.00,0.00),('5','105','965','257603',4904787,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257603',4904788,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257603',4904789,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257604',4904790,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257604',4904791,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257604',4904792,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257604',4904793,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257604',4904794,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257604',4904795,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257604',4904796,'2859','432',764181.11,766881.37,2700.26,445542.90,0.00,0.00,0.00,0.00,0.00),('5','105','964','257604',4904797,'2860','432',679096.65,679096.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257604',4904798,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257604',4904799,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257604',4904800,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257605',4904801,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257605',4904802,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257605',4904803,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257605',4904804,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257605',4904805,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257605',4904806,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257605',4904807,'2859','432',766881.37,766881.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257605',4904808,'2860','432',679096.65,679096.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257605',4904809,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257605',4904810,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257605',4904811,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257606',4904812,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257606',4904813,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257606',4904814,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257606',4904815,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257606',4904816,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257606',4904817,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257606',4904818,'2859','432',766881.37,766881.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257606',4904819,'2860','432',679096.65,679096.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257606',4904820,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257606',4904821,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257606',4904822,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257607',4904823,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257607',4904824,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257607',4904825,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257607',4904826,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257607',4904827,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257607',4904828,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257607',4904829,'2859','432',766881.37,766881.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257607',4904830,'2860','432',679096.65,679096.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257607',4904831,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257607',4904832,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257607',4904833,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257608',4904834,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257608',4904835,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257608',4904836,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257608',4904837,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257608',4904838,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257608',4904839,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257608',4904840,'2859','432',766881.37,768128.04,1246.67,205700.55,0.00,0.00,0.00,0.00,0.00),('5','105','964','257608',4904841,'2860','432',679096.65,680176.12,1079.47,178112.55,0.00,0.00,0.00,0.00,0.00),('5','105','965','257608',4904842,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257608',4904843,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257608',4904844,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257609',4904845,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257609',4904846,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257609',4904847,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257609',4904848,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257609',4904849,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257609',4904850,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257609',4904851,'2859','432',768128.04,770340.84,2212.80,365112.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257609',4904852,'2860','432',680176.12,682082.38,1906.26,314532.90,0.00,0.00,0.00,0.00,0.00),('5','105','965','257609',4904853,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257609',4904854,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257609',4904855,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257610',4904856,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257610',4904857,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257610',4904858,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257610',4904859,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257610',4904860,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257610',4904861,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257610',4904862,'2859','432',770340.84,772113.83,1772.99,292543.35,0.00,0.00,0.00,0.00,0.00),('5','105','964','257610',4904863,'2860','432',682082.38,684498.43,2416.05,398648.25,0.00,0.00,0.00,0.00,0.00),('5','105','965','257610',4904864,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257610',4904865,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257610',4904866,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257611',4904867,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257611',4904868,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257611',4904869,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257611',4904870,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257611',4904871,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257611',4904872,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257611',4904873,'2859','432',772113.83,775149.97,3036.14,500963.10,0.00,0.00,0.00,0.00,0.00),('5','105','964','257611',4904874,'2860','432',684498.43,684498.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257611',4904875,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257611',4904876,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257611',4904877,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257612',4904878,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257612',4904879,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257612',4904880,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257612',4904881,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257612',4904882,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257612',4904883,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257612',4904884,'2859','432',775149.97,776150.07,1000.10,165016.50,0.00,0.00,0.00,0.00,0.00),('5','105','964','257612',4904885,'2860','432',684498.43,684761.81,263.38,43457.70,0.00,0.00,0.00,0.00,0.00),('5','105','965','257612',4904886,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257612',4904887,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257612',4904888,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257613',4904889,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257613',4904890,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257613',4904891,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257613',4904892,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257613',4904893,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257613',4904894,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257613',4904895,'2859','432',776150.07,776150.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257613',4904896,'2860','432',684761.81,684761.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257613',4904897,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257613',4904898,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257613',4904899,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257614',4904900,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257614',4904901,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257614',4904902,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257614',4904903,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257614',4904904,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257614',4904905,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257614',4904906,'2859','432',776150.07,776150.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257614',4904907,'2860','432',684761.81,684761.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257614',4904908,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257614',4904909,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257614',4904910,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257615',4904911,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257615',4904912,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257615',4904913,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257615',4904914,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257615',4904915,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257615',4904916,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257615',4904917,'2859','432',776150.07,776150.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257615',4904918,'2860','432',684761.81,684761.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257615',4904919,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257615',4904920,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257615',4904921,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257616',4904922,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257616',4904923,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257616',4904924,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257616',4904925,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257616',4904926,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257616',4904927,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257616',4904928,'2859','432',776150.07,776150.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257616',4904929,'2860','432',684761.81,684761.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257616',4904930,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257616',4904931,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257616',4904932,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257617',4904933,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257617',4904934,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257617',4904935,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257617',4904936,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257617',4904937,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257617',4904938,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257617',4904939,'2859','432',776150.07,776150.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257617',4904940,'2860','432',684761.81,684761.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257617',4904941,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257617',4904942,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257617',4904943,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257618',4904944,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257618',4904945,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257618',4904946,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257618',4904947,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257618',4904948,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257618',4904949,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257618',4904950,'2859','432',776150.07,776150.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257618',4904951,'2860','432',684761.81,684761.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257618',4904952,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257618',4904953,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257618',4904954,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257619',4904955,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257619',4904956,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257619',4904957,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257619',4904958,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257619',4904959,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257619',4904960,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257619',4904961,'2859','432',776150.07,776150.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257619',4904962,'2860','432',684761.81,684761.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257619',4904963,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257619',4904964,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257619',4904965,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257620',4904966,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257620',4904967,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257620',4904968,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257620',4904969,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257620',4904970,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257620',4904971,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257620',4904972,'2859','432',776150.07,776150.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257620',4904973,'2860','432',684761.81,684761.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257620',4904974,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257620',4904975,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257620',4904976,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257621',4904977,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257621',4904978,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257621',4904979,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257621',4904980,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257621',4904981,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257621',4904982,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257621',4904983,'2859','432',776150.07,777750.59,1600.52,264085.80,0.00,0.00,0.00,0.00,0.00),('5','105','964','257621',4904984,'2860','432',684761.81,684761.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257621',4904985,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257621',4904986,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257621',4904987,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257622',4904988,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257622',4904989,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257622',4904990,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257622',4904991,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257622',4904992,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257622',4904993,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257622',4904994,'2859','432',777750.59,778784.42,1033.83,170581.95,0.00,0.00,0.00,0.00,0.00),('5','105','964','257622',4904995,'2860','432',684761.81,687840.20,3078.39,507934.35,0.00,0.00,0.00,0.00,0.00),('5','105','965','257622',4904996,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257622',4904997,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257622',4904998,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257623',4904999,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257623',4905000,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257623',4905001,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257623',4905002,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257623',4905003,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257623',4905004,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257623',4905005,'2859','432',778784.42,780444.92,1660.50,273982.50,0.00,0.00,0.00,0.00,0.00),('5','105','964','257623',4905006,'2860','432',687840.20,690194.42,2354.22,388446.30,0.00,0.00,0.00,0.00,0.00),('5','105','965','257623',4905007,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257623',4905008,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257623',4905009,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257624',4905010,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257624',4905011,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257624',4905012,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257624',4905013,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257624',4905014,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257624',4905015,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257624',4905016,'2859','432',780444.92,782489.53,2044.61,337360.65,0.00,0.00,0.00,0.00,0.00),('5','105','964','257624',4905017,'2860','432',690194.42,691555.92,1361.50,224647.50,0.00,0.00,0.00,0.00,0.00),('5','105','965','257624',4905018,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257624',4905019,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257624',4905020,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257625',4905021,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257625',4905022,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257625',4905023,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257625',4905024,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257625',4905025,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257625',4905026,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257625',4905027,'2859','432',782489.53,784244.02,1754.49,289490.85,0.00,0.00,0.00,0.00,0.00),('5','105','964','257625',4905028,'2860','432',691555.92,691555.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257625',4905029,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257625',4905030,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257625',4905031,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257626',4905032,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257626',4905033,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257626',4905034,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257626',4905035,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257626',4905036,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257626',4905037,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257626',4905038,'2859','432',784244.02,784244.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257626',4905039,'2860','432',691555.92,691555.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257626',4905040,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257626',4905041,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257626',4905042,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257627',4905043,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257627',4905044,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257627',4905045,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257627',4905046,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257627',4905047,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257627',4905048,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257627',4905049,'2859','432',784244.02,784244.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257627',4905050,'2860','432',691555.92,691555.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257627',4905051,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257627',4905052,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257627',4905053,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257628',4905054,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257628',4905055,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257628',4905056,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257628',4905057,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257628',4905058,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257628',4905059,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257628',4905060,'2859','432',784244.02,784244.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257628',4905061,'2860','432',691555.92,691555.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257628',4905062,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257628',4905063,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257628',4905064,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257629',4905065,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257629',4905066,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257629',4905067,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257629',4905068,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257629',4905069,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257629',4905070,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257629',4905071,'2859','432',784244.02,784244.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257629',4905072,'2860','432',691555.92,691555.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257629',4905073,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257629',4905074,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257629',4905075,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257630',4905076,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257630',4905077,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257630',4905078,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257630',4905079,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257630',4905080,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257630',4905081,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257630',4905082,'2859','432',784244.02,784244.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257630',4905083,'2860','432',691555.92,691555.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257630',4905084,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257630',4905085,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257630',4905086,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257631',4905087,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257631',4905088,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257631',4905089,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257631',4905090,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257631',4905091,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257631',4905092,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257631',4905093,'2859','432',784244.02,784244.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257631',4905094,'2860','432',691555.92,691555.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257631',4905095,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257631',4905096,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257631',4905097,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257632',4905098,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257632',4905099,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257632',4905100,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257632',4905101,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257632',4905102,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257632',4905103,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257632',4905104,'2859','432',784244.02,784244.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257632',4905105,'2860','432',691555.92,691555.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257632',4905106,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257632',4905107,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257632',4905108,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257633',4905109,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257633',4905110,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257633',4905111,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257633',4905112,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257633',4905113,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257633',4905114,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257633',4905115,'2859','432',784244.02,784244.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257633',4905116,'2860','432',691555.92,691555.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257633',4905117,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257633',4905118,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257633',4905119,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257634',4905120,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257634',4905121,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257634',4905122,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257634',4905123,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257634',4905124,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257634',4905125,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257634',4905126,'2859','432',784244.02,784244.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257634',4905127,'2860','432',691555.92,691555.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257634',4905128,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257634',4905129,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257634',4905130,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257635',4905131,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257635',4905132,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257635',4905133,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257635',4905134,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257635',4905135,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257635',4905136,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257635',4905137,'2859','432',784244.02,784244.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257635',4905138,'2860','432',691555.92,691555.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257635',4905139,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257635',4905140,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257635',4905141,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257636',4905142,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257636',4905143,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257636',4905144,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257636',4905145,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257636',4905146,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257636',4905147,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257636',4905148,'2859','432',784244.02,784244.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257636',4905149,'2860','432',691555.92,691555.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257636',4905150,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257636',4905151,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257636',4905152,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257637',4905153,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257637',4905154,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257637',4905155,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257637',4905156,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257637',4905157,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257637',4905158,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257637',4905159,'2859','432',784244.02,784244.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257637',4905160,'2860','432',691555.92,691555.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257637',4905161,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257637',4905162,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257637',4905163,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257638',4905164,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257638',4905165,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257638',4905166,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257638',4905167,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257638',4905168,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257638',4905169,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257638',4905170,'2859','432',784244.02,784244.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257638',4905171,'2860','432',691555.92,691555.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257638',4905172,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257638',4905173,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257638',4905174,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257639',4905175,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257639',4905176,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257639',4905177,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257639',4905178,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257639',4905179,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257639',4905180,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257639',4905181,'2859','432',784244.02,785456.54,1212.52,200065.80,0.00,0.00,0.00,0.00,0.00),('5','105','964','257639',4905182,'2860','432',691555.92,692758.78,1202.86,198471.90,0.00,0.00,0.00,0.00,0.00),('5','105','965','257639',4905183,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257639',4905184,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257639',4905185,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257640',4905186,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257640',4905187,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257640',4905188,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257640',4905189,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257640',4905190,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257640',4905191,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257640',4905192,'2859','432',785456.54,787395.63,1939.09,319949.85,0.00,0.00,0.00,0.00,0.00),('5','105','964','257640',4905193,'2860','432',692758.78,694728.38,1969.60,324984.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257640',4905194,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257640',4905195,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257640',4905196,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257641',4905197,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257641',4905198,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257641',4905199,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257641',4905200,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257641',4905201,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257641',4905202,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257641',4905203,'2859','432',787395.63,789047.93,1652.30,272629.50,0.00,0.00,0.00,0.00,0.00),('5','105','964','257641',4905204,'2860','432',694728.38,697162.35,2433.97,401605.05,0.00,0.00,0.00,0.00,0.00),('5','105','965','257641',4905205,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257641',4905206,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257641',4905207,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257642',4905208,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257642',4905209,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257642',4905210,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257642',4905211,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257642',4905212,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257642',4905213,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257642',4905214,'2859','432',789047.93,791456.47,2408.54,397409.10,0.00,0.00,0.00,0.00,0.00),('5','105','964','257642',4905215,'2860','432',697162.35,697162.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257642',4905216,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257642',4905217,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257642',4905218,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257643',4905219,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257643',4905220,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257643',4905221,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257643',4905222,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257643',4905223,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257643',4905224,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257643',4905225,'2859','432',791456.47,791456.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257643',4905226,'2860','432',697162.35,697162.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257643',4905227,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257643',4905228,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257643',4905229,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257644',4905230,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257644',4905231,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257644',4905232,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257644',4905233,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257644',4905234,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257644',4905235,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257644',4905236,'2859','432',791456.47,791456.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257644',4905237,'2860','432',697162.35,697162.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257644',4905238,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257644',4905239,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257644',4905240,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257645',4905241,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257645',4905242,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257645',4905243,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257645',4905244,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257645',4905245,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257645',4905246,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257645',4905247,'2859','432',791456.47,791456.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257645',4905248,'2860','432',697162.35,697162.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257645',4905249,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257645',4905250,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257645',4905251,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257646',4905252,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257646',4905253,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257646',4905254,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257646',4905255,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257646',4905256,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257646',4905257,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257646',4905258,'2859','432',791456.47,792447.54,991.07,163526.55,0.00,0.00,0.00,0.00,0.00),('5','105','964','257646',4905259,'2860','432',697162.35,698616.74,1454.39,239974.35,0.00,0.00,0.00,0.00,0.00),('5','105','965','257646',4905260,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257646',4905261,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257646',4905262,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257647',4905263,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257647',4905264,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257647',4905265,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257647',4905266,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257647',4905267,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257647',4905268,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257647',4905269,'2859','432',792447.54,794617.33,2169.79,401411.15,0.00,0.00,0.00,0.00,0.00),('5','105','964','257647',4905270,'2860','432',698616.74,701197.97,2581.23,477527.55,0.00,0.00,0.00,0.00,0.00),('5','105','965','257647',4905271,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257647',4905272,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257647',4905273,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257648',4905274,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257648',4905275,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257648',4905276,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257648',4905277,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257648',4905278,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257648',4905279,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257648',4905280,'2859','432',794617.33,798334.49,3717.16,687674.60,0.00,0.00,0.00,0.00,0.00),('5','105','964','257648',4905281,'2860','432',701197.97,704636.39,3438.42,636107.70,0.00,0.00,0.00,0.00,0.00),('5','105','965','257648',4905282,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257648',4905283,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257648',4905284,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257649',4905285,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257649',4905286,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257649',4905287,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257649',4905288,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257649',4905289,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257649',4905290,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257649',4905291,'2859','432',798334.49,801995.61,3661.12,677307.20,0.00,0.00,0.00,0.00,0.00),('5','105','964','257649',4905292,'2860','432',704636.39,706990.70,2354.31,435547.35,0.00,0.00,0.00,0.00,0.00),('5','105','965','257649',4905293,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257649',4905294,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257649',4905295,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257650',4905296,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257650',4905297,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257650',4905298,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257650',4905299,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257650',4905300,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257650',4905301,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257650',4905302,'2859','432',801995.61,805501.31,3505.70,648554.50,0.00,0.00,0.00,0.00,0.00),('5','105','964','257650',4905303,'2860','432',706990.70,710550.98,3560.28,658651.80,0.00,0.00,0.00,0.00,0.00),('5','105','965','257650',4905304,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257650',4905305,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257650',4905306,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257651',4905307,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257651',4905308,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257651',4905309,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257651',4905310,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257651',4905311,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257651',4905312,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257651',4905313,'2859','432',805501.31,808109.28,2607.97,482474.45,0.00,0.00,0.00,0.00,0.00),('5','105','964','257651',4905314,'2860','432',710550.98,714228.57,3677.59,680354.15,0.00,0.00,0.00,0.00,0.00),('5','105','965','257651',4905315,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257651',4905316,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257651',4905317,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257652',4905318,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257652',4905319,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257652',4905320,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257652',4905321,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257652',4905322,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257652',4905323,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257652',4905324,'2859','432',808109.28,811089.02,2979.74,551251.90,0.00,0.00,0.00,0.00,0.00),('5','105','964','257652',4905325,'2860','432',714228.57,717519.44,3290.87,608810.95,0.00,0.00,0.00,0.00,0.00),('5','105','965','257652',4905326,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257652',4905327,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257652',4905328,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257653',4905329,'2853','432',197964.70,197964.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257653',4905330,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257653',4905331,'2855','432',223360.03,223360.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257653',4905332,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257653',4905333,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257653',4905334,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257653',4905335,'2859','432',811089.02,813944.65,2855.63,528291.55,0.00,0.00,0.00,0.00,0.00),('5','105','964','257653',4905336,'2860','432',717519.44,719971.20,2451.76,453575.60,0.00,0.00,0.00,0.00,0.00),('5','105','965','257653',4905337,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257653',4905338,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257653',4905339,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257654',4905340,'2853','432',197964.70,200832.92,2868.22,530620.70,0.00,0.00,0.00,0.00,0.00),('5','105','961','257654',4905341,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257654',4905342,'2855','432',223360.03,225362.76,2002.73,370505.05,0.00,0.00,0.00,0.00,0.00),('5','105','961','257654',4905343,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257654',4905344,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257654',4905345,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257654',4905346,'2859','432',813944.65,813950.03,5.38,995.30,0.00,0.00,0.00,0.00,0.00),('5','105','964','257654',4905347,'2860','432',719971.20,722132.48,2161.28,399836.80,0.00,0.00,0.00,0.00,0.00),('5','105','965','257654',4905348,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257654',4905349,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257654',4905350,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257655',4905351,'2853','432',200832.92,203759.32,2926.40,541384.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257655',4905352,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257655',4905353,'2855','432',225362.76,227964.05,2601.29,481238.65,0.00,0.00,0.00,0.00,0.00),('5','105','961','257655',4905354,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257655',4905355,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257655',4905356,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257655',4905357,'2859','432',813950.03,813950.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257655',4905358,'2860','432',722132.48,723696.68,1564.20,289377.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257655',4905359,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257655',4905360,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257655',4905361,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257656',4905362,'2853','432',203759.32,207271.63,3512.31,649777.35,0.00,0.00,0.00,0.00,0.00),('5','105','961','257656',4905363,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257656',4905364,'2855','432',227964.05,230890.98,2926.93,541482.05,0.00,0.00,0.00,0.00,0.00),('5','105','961','257656',4905365,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257656',4905366,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257656',4905367,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257656',4905368,'2859','432',813950.03,813950.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257656',4905369,'2860','432',723696.68,725028.80,1332.12,246442.20,0.00,0.00,0.00,0.00,0.00),('5','105','965','257656',4905370,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257656',4905371,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257656',4905372,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257657',4905373,'2853','432',207271.63,212313.71,5042.08,932784.80,0.00,0.00,0.00,0.00,0.00),('5','105','961','257657',4905374,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257657',4905375,'2855','432',230890.98,234620.85,3729.87,690025.95,0.00,0.00,0.00,0.00,0.00),('5','105','961','257657',4905376,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257657',4905377,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257657',4905378,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257657',4905379,'2859','432',813950.03,813950.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257657',4905380,'2860','432',725028.80,725028.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257657',4905381,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257657',4905382,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257657',4905383,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257658',4905384,'2853','432',212313.71,215017.18,2703.47,500141.95,0.00,0.00,0.00,0.00,0.00),('5','105','961','257658',4905385,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257658',4905386,'2855','432',234620.85,236952.97,2332.12,431442.20,0.00,0.00,0.00,0.00,0.00),('5','105','961','257658',4905387,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257658',4905388,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257658',4905389,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257658',4905390,'2859','432',813950.03,814944.72,994.69,184017.65,0.00,0.00,0.00,0.00,0.00),('5','105','964','257658',4905391,'2860','432',725028.80,725028.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257658',4905392,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257658',4905393,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257658',4905394,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257659',4905395,'2853','432',215017.18,217728.60,2711.42,501612.70,0.00,0.00,0.00,0.00,0.00),('5','105','961','257659',4905396,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257659',4905397,'2855','432',236952.97,238316.00,1363.03,252160.55,0.00,0.00,0.00,0.00,0.00),('5','105','961','257659',4905398,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257659',4905399,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257659',4905400,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257659',4905401,'2859','432',814944.72,814944.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257659',4905402,'2860','432',725028.80,725028.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257659',4905403,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257659',4905404,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257659',4905405,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257660',4905406,'2853','432',217728.60,220251.68,2523.08,466769.80,0.00,0.00,0.00,0.00,0.00),('5','105','961','257660',4905407,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257660',4905408,'2855','432',238316.00,239897.20,1581.20,292522.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257660',4905409,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257660',4905410,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257660',4905411,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257660',4905412,'2859','432',814944.72,814944.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257660',4905413,'2860','432',725028.80,725028.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257660',4905414,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257660',4905415,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257660',4905416,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257661',4905417,'2853','432',220251.68,222298.17,2046.49,378600.65,0.00,0.00,0.00,0.00,0.00),('5','105','961','257661',4905418,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257661',4905419,'2855','432',239897.20,241002.87,1105.67,204548.95,0.00,0.00,0.00,0.00,0.00),('5','105','961','257661',4905420,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257661',4905421,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257661',4905422,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257661',4905423,'2859','432',814944.72,814944.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257661',4905424,'2860','432',725028.80,725028.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257661',4905425,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257661',4905426,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257661',4905427,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257662',4905428,'2853','432',222298.17,222524.00,225.83,41778.55,0.00,0.00,0.00,0.00,0.00),('5','105','961','257662',4905429,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257662',4905430,'2855','432',241002.87,243502.98,2500.11,462520.35,0.00,0.00,0.00,0.00,0.00),('5','105','961','257662',4905431,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257662',4905432,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257662',4905433,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257662',4905434,'2859','432',814944.72,815544.72,600.00,111000.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257662',4905435,'2860','432',725028.80,725028.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257662',4905436,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257662',4905437,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257662',4905438,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257663',4905439,'2853','432',222524.00,222524.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257663',4905440,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257663',4905441,'2855','432',243502.98,243502.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257663',4905442,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257663',4905443,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257663',4905444,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257663',4905445,'2859','432',815544.72,816944.73,1400.01,259001.85,0.00,0.00,0.00,0.00,0.00),('5','105','964','257663',4905446,'2860','432',725028.80,725028.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257663',4905447,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257663',4905448,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257663',4905449,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257664',4905450,'2853','432',222524.00,222524.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257664',4905451,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257664',4905452,'2855','432',243502.98,243502.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257664',4905453,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257664',4905454,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257664',4905455,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257664',4905456,'2859','432',816944.73,816944.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257664',4905457,'2860','432',725028.80,725028.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257664',4905458,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257664',4905459,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257664',4905460,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257665',4905461,'2853','432',222524.00,222524.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257665',4905462,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257665',4905463,'2855','432',243502.98,243502.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257665',4905464,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257665',4905465,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257665',4905466,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257665',4905467,'2859','432',816944.73,816944.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257665',4905468,'2860','432',725028.80,725028.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257665',4905469,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257665',4905470,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257665',4905471,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257666',4905472,'2853','432',222524.00,222524.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257666',4905473,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257666',4905474,'2855','432',243502.98,243502.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257666',4905475,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257666',4905476,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257666',4905477,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257666',4905478,'2859','432',816944.73,818072.23,1127.50,208587.50,0.00,0.00,0.00,0.00,0.00),('5','105','964','257666',4905479,'2860','432',725028.80,726040.57,1011.77,187177.45,0.00,0.00,0.00,0.00,0.00),('5','105','965','257666',4905480,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257666',4905481,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257666',4905482,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257667',4905483,'2853','432',222524.00,222524.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257667',4905484,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257667',4905485,'2855','432',243502.98,243502.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257667',4905486,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257667',4905487,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257667',4905488,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257667',4905489,'2859','432',818072.23,820533.53,2461.30,455340.50,0.00,0.00,0.00,0.00,0.00),('5','105','964','257667',4905490,'2860','432',726040.57,729142.24,3101.67,573808.95,0.00,0.00,0.00,0.00,0.00),('5','105','965','257667',4905491,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257667',4905492,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257667',4905493,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257668',4905494,'2853','432',222524.00,222524.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257668',4905495,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257668',4905496,'2855','432',243502.98,243502.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257668',4905497,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257668',4905498,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257668',4905499,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257668',4905500,'2859','432',820533.53,823414.68,2881.15,533012.75,0.00,0.00,0.00,0.00,0.00),('5','105','964','257668',4905501,'2860','432',729142.24,731351.72,2209.48,408753.80,0.00,0.00,0.00,0.00,0.00),('5','105','965','257668',4905502,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257668',4905503,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257668',4905504,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257669',4905505,'2853','432',222524.00,222524.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257669',4905506,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257669',4905507,'2855','432',243502.98,243502.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257669',4905508,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257669',4905509,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257669',4905510,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257669',4905511,'2859','432',823414.68,826603.60,3188.92,589950.20,0.00,0.00,0.00,0.00,0.00),('5','105','964','257669',4905512,'2860','432',731351.72,734039.24,2687.52,497191.20,0.00,0.00,0.00,0.00,0.00),('5','105','965','257669',4905513,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257669',4905514,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257669',4905515,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257670',4905516,'2853','432',222524.00,222524.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257670',4905517,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257670',4905518,'2855','432',243502.98,243502.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257670',4905519,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257670',4905520,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257670',4905521,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257670',4905522,'2859','432',826603.60,828250.82,1647.22,304735.70,0.00,0.00,0.00,0.00,0.00),('5','105','964','257670',4905523,'2860','432',734039.24,737440.84,3401.60,629296.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257670',4905524,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257670',4905525,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257670',4905526,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257671',4905527,'2853','432',222524.00,222524.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257671',4905528,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257671',4905529,'2855','432',243502.98,243502.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257671',4905530,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257671',4905531,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257671',4905532,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257671',4905533,'2859','432',828250.82,830017.66,1766.84,326865.40,0.00,0.00,0.00,0.00,0.00),('5','105','964','257671',4905534,'2860','432',737440.84,739695.79,2254.95,417165.75,0.00,0.00,0.00,0.00,0.00),('5','105','965','257671',4905535,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257671',4905536,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257671',4905537,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257672',4905538,'2853','432',222524.00,222524.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257672',4905539,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257672',4905540,'2855','432',243502.98,243502.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257672',4905541,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257672',4905542,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257672',4905543,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257672',4905544,'2859','432',830017.66,832228.03,2210.37,408918.45,0.00,0.00,0.00,0.00,0.00),('5','105','964','257672',4905545,'2860','432',739695.79,741765.03,2069.24,382809.40,0.00,0.00,0.00,0.00,0.00),('5','105','965','257672',4905546,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257672',4905547,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257672',4905548,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257673',4905549,'2853','432',222524.00,222524.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257673',4905550,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257673',4905551,'2855','432',243502.98,243502.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257673',4905552,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257673',4905553,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257673',4905554,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257673',4905555,'2859','432',832228.03,834330.10,2102.07,388882.95,0.00,0.00,0.00,0.00,0.00),('5','105','964','257673',4905556,'2860','432',741765.03,743794.84,2029.81,375514.85,0.00,0.00,0.00,0.00,0.00),('5','105','965','257673',4905557,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257673',4905558,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257673',4905559,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257674',4905560,'2853','432',222524.00,222524.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257674',4905561,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257674',4905562,'2855','432',243502.98,243502.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257674',4905563,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257674',4905564,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257674',4905565,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257674',4905566,'2859','432',834330.10,836879.07,2548.97,471559.45,0.00,0.00,0.00,0.00,0.00),('5','105','964','257674',4905567,'2860','432',743794.84,744286.54,491.70,90964.50,0.00,0.00,0.00,0.00,0.00),('5','105','965','257674',4905568,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257674',4905569,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257674',4905570,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257675',4905571,'2853','432',222524.00,222524.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257675',4905572,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257675',4905573,'2855','432',243502.98,243502.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257675',4905574,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257675',4905575,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257675',4905576,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257675',4905577,'2859','432',836879.07,839057.65,2178.58,403037.30,0.00,0.00,0.00,0.00,0.00),('5','105','964','257675',4905578,'2860','432',744286.54,747123.96,2837.42,524922.70,0.00,0.00,0.00,0.00,0.00),('5','105','965','257675',4905579,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257675',4905580,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257675',4905581,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257676',4905582,'2853','432',222524.00,222524.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257676',4905583,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257676',4905584,'2855','432',243502.98,243502.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257676',4905585,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257676',4905586,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257676',4905587,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257676',4905588,'2859','432',839057.65,841311.79,2254.14,417015.90,0.00,0.00,0.00,0.00,0.00),('5','105','964','257676',4905589,'2860','432',747123.96,749197.62,2073.66,383627.10,0.00,0.00,0.00,0.00,0.00),('5','105','965','257676',4905590,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257676',4905591,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257676',4905592,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257677',4905593,'2853','432',222524.00,222524.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257677',4905594,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257677',4905595,'2855','432',243502.98,243502.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257677',4905596,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257677',4905597,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257677',4905598,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257677',4905599,'2859','432',841311.79,843801.35,2489.56,460568.60,0.00,0.00,0.00,0.00,0.00),('5','105','964','257677',4905600,'2860','432',749197.62,751729.83,2532.21,468458.85,0.00,0.00,0.00,0.00,0.00),('5','105','965','257677',4905601,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257677',4905602,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257677',4905603,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257678',4905604,'2853','432',222524.00,222524.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257678',4905605,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257678',4905606,'2855','432',243502.98,243502.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257678',4905607,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257678',4905608,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257678',4905609,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257678',4905610,'2859','432',843801.35,846601.34,2799.99,517998.15,0.00,0.00,0.00,0.00,0.00),('5','105','964','257678',4905611,'2860','432',751729.83,754486.95,2757.12,510067.20,0.00,0.00,0.00,0.00,0.00),('5','105','965','257678',4905612,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257678',4905613,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257678',4905614,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257679',4905615,'2853','432',222524.00,222524.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257679',4905616,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257679',4905617,'2855','432',243502.98,243502.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257679',4905618,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257679',4905619,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257679',4905620,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257679',4905621,'2859','432',846601.34,849210.03,2608.69,482607.65,0.00,0.00,0.00,0.00,0.00),('5','105','964','257679',4905622,'2860','432',754486.95,757195.06,2708.11,501000.35,0.00,0.00,0.00,0.00,0.00),('5','105','965','257679',4905623,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257679',4905624,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257679',4905625,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257680',4905626,'2853','432',222524.00,222524.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257680',4905627,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257680',4905628,'2855','432',243502.98,243502.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257680',4905629,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257680',4905630,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257680',4905631,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257680',4905632,'2859','432',849210.03,852034.50,2824.47,522526.95,0.00,0.00,0.00,0.00,0.00),('5','105','964','257680',4905633,'2860','432',757195.06,759727.62,2532.56,468523.60,0.00,0.00,0.00,0.00,0.00),('5','105','965','257680',4905634,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257680',4905635,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257680',4905636,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257681',4905637,'2853','432',222524.00,222524.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257681',4905638,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257681',4905639,'2855','432',243502.98,243502.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257681',4905640,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257681',4905641,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257681',4905642,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257681',4905643,'2859','432',852034.50,855239.42,3204.92,592910.20,0.00,0.00,0.00,0.00,0.00),('5','105','964','257681',4905644,'2860','432',759727.62,762341.47,2613.85,483562.25,0.00,0.00,0.00,0.00,0.00),('5','105','965','257681',4905645,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257681',4905646,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257681',4905647,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257682',4905648,'2853','432',222524.00,222524.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257682',4905649,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257682',4905650,'2855','432',243502.98,243502.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257682',4905651,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257682',4905652,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257682',4905653,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257682',4905654,'2859','432',855239.42,858542.56,3303.14,611080.90,0.00,0.00,0.00,0.00,0.00),('5','105','964','257682',4905655,'2860','432',762341.47,765379.79,3038.32,562089.20,0.00,0.00,0.00,0.00,0.00),('5','105','965','257682',4905656,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257682',4905657,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257682',4905658,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257683',4905659,'2853','432',222524.00,222524.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257683',4905660,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257683',4905661,'2855','432',243502.98,243502.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257683',4905662,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257683',4905663,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257683',4905664,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257683',4905665,'2859','432',858542.56,862633.39,4090.83,756803.55,0.00,0.00,0.00,0.00,0.00),('5','105','964','257683',4905666,'2860','432',765379.79,768312.16,2932.37,542488.45,0.00,0.00,0.00,0.00,0.00),('5','105','965','257683',4905667,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257683',4905668,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257683',4905669,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257684',4905670,'2853','432',222524.00,222524.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257684',4905671,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257684',4905672,'2855','432',243502.98,243502.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257684',4905673,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257684',4905674,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257684',4905675,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257684',4905676,'2859','432',862633.39,864791.78,2158.39,399302.15,0.00,0.00,0.00,0.00,0.00),('5','105','964','257684',4905677,'2860','432',768312.16,770222.77,1910.61,353462.85,0.00,0.00,0.00,0.00,0.00),('5','105','965','257684',4905678,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257684',4905679,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257684',4905680,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257685',4905681,'2853','432',222524.00,222524.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257685',4905682,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257685',4905683,'2855','432',243502.98,243502.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257685',4905684,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257685',4905685,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257685',4905686,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257685',4905687,'2859','432',864791.78,867514.45,2722.67,503693.95,0.00,0.00,0.00,0.00,0.00),('5','105','964','257685',4905688,'2860','432',770222.77,772584.99,2362.22,437010.70,0.00,0.00,0.00,0.00,0.00),('5','105','965','257685',4905689,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257685',4905690,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257685',4905691,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257686',4905692,'2853','432',222524.00,222524.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257686',4905693,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257686',4905694,'2855','432',243502.98,243502.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257686',4905695,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257686',4905696,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257686',4905697,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257686',4905698,'2859','432',867514.45,870173.62,2659.17,491946.45,0.00,0.00,0.00,0.00,0.00),('5','105','964','257686',4905699,'2860','432',772584.99,775407.00,2822.01,522071.85,0.00,0.00,0.00,0.00,0.00),('5','105','965','257686',4905700,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257686',4905701,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257686',4905702,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257687',4905703,'2853','432',222524.00,223454.94,930.94,172223.90,0.00,0.00,0.00,0.00,0.00),('5','105','961','257687',4905704,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257687',4905705,'2855','432',243502.98,244412.21,909.23,168207.55,0.00,0.00,0.00,0.00,0.00),('5','105','961','257687',4905706,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257687',4905707,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257687',4905708,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257687',4905709,'2859','432',870173.62,872655.56,2481.94,459158.90,0.00,0.00,0.00,0.00,0.00),('5','105','964','257687',4905710,'2860','432',775407.00,776911.39,1504.39,278312.15,0.00,0.00,0.00,0.00,0.00),('5','105','965','257687',4905711,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257687',4905712,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257687',4905713,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257688',4905714,'2853','432',223454.94,225890.89,2435.95,450650.75,0.00,0.00,0.00,0.00,0.00),('5','105','961','257688',4905715,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257688',4905716,'2855','432',244412.21,247046.28,2634.07,487302.95,0.00,0.00,0.00,0.00,0.00),('5','105','961','257688',4905717,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257688',4905718,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257688',4905719,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257688',4905720,'2859','432',872655.56,872655.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257688',4905721,'2860','432',776911.39,776911.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257688',4905722,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257688',4905723,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257688',4905724,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257689',4905725,'2853','432',225890.89,228718.55,2827.66,523117.10,0.00,0.00,0.00,0.00,0.00),('5','105','961','257689',4905726,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257689',4905727,'2855','432',247046.28,249846.90,2800.62,518114.70,0.00,0.00,0.00,0.00,0.00),('5','105','961','257689',4905728,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257689',4905729,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257689',4905730,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257689',4905731,'2859','432',872655.56,874455.56,1800.00,333000.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257689',4905732,'2860','432',776911.39,776911.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257689',4905733,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257689',4905734,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257689',4905735,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257690',4905736,'2853','432',228718.55,232089.87,3371.32,623694.20,0.00,0.00,0.00,0.00,0.00),('5','105','961','257690',4905737,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257690',4905738,'2855','432',249846.90,253058.04,3211.14,594060.90,0.00,0.00,0.00,0.00,0.00),('5','105','961','257690',4905739,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257690',4905740,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257690',4905741,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257690',4905742,'2859','432',874455.56,874455.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257690',4905743,'2860','432',776911.39,776911.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257690',4905744,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257690',4905745,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257690',4905746,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257691',4905747,'2853','432',232089.87,235168.77,3078.90,569596.50,0.00,0.00,0.00,0.00,0.00),('5','105','961','257691',4905748,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257691',4905749,'2855','432',253058.04,256986.43,3928.39,726752.15,0.00,0.00,0.00,0.00,0.00),('5','105','961','257691',4905750,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257691',4905751,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257691',4905752,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257691',4905753,'2859','432',874455.56,874455.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257691',4905754,'2860','432',776911.39,776911.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257691',4905755,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257691',4905756,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257691',4905757,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257692',4905758,'2853','432',235168.77,237263.76,2094.99,387573.15,0.00,0.00,0.00,0.00,0.00),('5','105','961','257692',4905759,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257692',4905760,'2855','432',256986.43,259206.66,2220.23,410742.55,0.00,0.00,0.00,0.00,0.00),('5','105','961','257692',4905761,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257692',4905762,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257692',4905763,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257692',4905764,'2859','432',874455.56,875087.21,631.65,116855.25,0.00,0.00,0.00,0.00,0.00),('5','105','964','257692',4905765,'2860','432',776911.39,778195.39,1284.00,237540.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257692',4905766,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257692',4905767,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257692',4905768,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257693',4905769,'2853','432',237263.76,240603.43,3339.67,617838.95,0.00,0.00,0.00,0.00,0.00),('5','105','961','257693',4905770,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257693',4905771,'2855','432',259206.66,262717.25,3510.59,649459.15,0.00,0.00,0.00,0.00,0.00),('5','105','961','257693',4905772,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257693',4905773,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257693',4905774,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257693',4905775,'2859','432',875087.21,875087.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257693',4905776,'2860','432',778195.39,778195.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257693',4905777,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257693',4905778,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257693',4905779,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257694',4905780,'2853','432',240603.43,243766.65,3163.22,585195.70,0.00,0.00,0.00,0.00,0.00),('5','105','961','257694',4905781,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257694',4905782,'2855','432',262717.25,266341.91,3624.66,670562.10,0.00,0.00,0.00,0.00,0.00),('5','105','961','257694',4905783,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257694',4905784,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257694',4905785,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257694',4905786,'2859','432',875087.21,875087.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257694',4905787,'2860','432',778195.39,778195.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257694',4905788,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257694',4905789,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257694',4905790,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257695',4905791,'2853','432',243766.65,246699.61,2932.96,542597.60,0.00,0.00,0.00,0.00,0.00),('5','105','961','257695',4905792,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257695',4905793,'2855','432',266341.91,269430.88,3088.97,571459.45,0.00,0.00,0.00,0.00,0.00),('5','105','961','257695',4905794,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257695',4905795,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257695',4905796,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257695',4905797,'2859','432',875087.21,875671.59,584.38,108110.30,0.00,0.00,0.00,0.00,0.00),('5','105','964','257695',4905798,'2860','432',778195.39,778784.41,589.02,108968.70,0.00,0.00,0.00,0.00,0.00),('5','105','965','257695',4905799,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257695',4905800,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257695',4905801,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257696',4905802,'2853','432',246699.61,246699.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257696',4905803,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257696',4905804,'2855','432',269430.88,269430.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257696',4905805,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257696',4905806,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257696',4905807,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257696',4905808,'2859','432',875671.59,879631.86,3960.27,732649.95,0.00,0.00,0.00,0.00,0.00),('5','105','964','257696',4905809,'2860','432',778784.41,782276.61,3492.20,646057.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257696',4905810,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257696',4905811,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257696',4905812,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257697',4905813,'2853','432',246699.61,246699.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257697',4905814,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257697',4905815,'2855','432',269430.88,269430.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257697',4905816,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257697',4905817,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257697',4905818,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257697',4905819,'2859','432',879631.86,884186.13,4554.27,842539.95,0.00,0.00,0.00,0.00,0.00),('5','105','964','257697',4905820,'2860','432',782276.61,785191.88,2915.27,539324.95,0.00,0.00,0.00,0.00,0.00),('5','105','965','257697',4905821,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257697',4905822,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257697',4905823,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257698',4905824,'2853','432',246699.61,246699.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257698',4905825,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257698',4905826,'2855','432',269430.88,269430.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257698',4905827,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257698',4905828,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257698',4905829,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257698',4905830,'2859','432',884186.13,887333.76,3147.63,582311.55,0.00,0.00,0.00,0.00,0.00),('5','105','964','257698',4905831,'2860','432',785191.88,789080.11,3888.23,719322.55,0.00,0.00,0.00,0.00,0.00),('5','105','965','257698',4905832,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257698',4905833,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257698',4905834,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257699',4905835,'2853','432',246699.61,246699.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257699',4905836,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257699',4905837,'2855','432',269430.88,269430.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257699',4905838,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257699',4905839,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257699',4905840,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257699',4905841,'2859','432',887333.76,890792.44,3458.68,639855.80,0.00,0.00,0.00,0.00,0.00),('5','105','964','257699',4905842,'2860','432',789080.11,792632.57,3552.46,657205.10,0.00,0.00,0.00,0.00,0.00),('5','105','965','257699',4905843,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257699',4905844,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257699',4905845,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257700',4905846,'2853','432',246699.61,246699.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257700',4905847,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257700',4905848,'2855','432',269430.88,269430.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257700',4905849,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257700',4905850,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257700',4905851,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257700',4905852,'2859','432',890792.44,895687.67,4895.23,905617.55,0.00,0.00,0.00,0.00,0.00),('5','105','964','257700',4905853,'2860','432',792632.57,795788.51,3155.94,583848.90,0.00,0.00,0.00,0.00,0.00),('5','105','965','257700',4905854,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257700',4905855,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257700',4905856,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257701',4905857,'2853','432',246699.61,246699.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257701',4905858,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257701',4905859,'2855','432',269430.88,269430.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257701',4905860,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257701',4905861,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257701',4905862,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257701',4905863,'2859','432',895687.67,900114.06,4426.39,818882.15,0.00,0.00,0.00,0.00,0.00),('5','105','964','257701',4905864,'2860','432',795788.51,799449.25,3660.74,677236.90,0.00,0.00,0.00,0.00,0.00),('5','105','965','257701',4905865,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257701',4905866,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257701',4905867,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257702',4905868,'2853','432',246699.61,246699.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257702',4905869,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257702',4905870,'2855','432',269430.88,269430.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257702',4905871,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257702',4905872,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257702',4905873,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257702',4905874,'2859','432',900114.06,905076.18,4962.12,917992.20,0.00,0.00,0.00,0.00,0.00),('5','105','964','257702',4905875,'2860','432',799449.25,803250.30,3801.05,703194.25,0.00,0.00,0.00,0.00,0.00),('5','105','965','257702',4905876,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257702',4905877,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257702',4905878,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257703',4905879,'2853','432',246699.61,246699.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257703',4905880,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257703',4905881,'2855','432',269430.88,269430.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257703',4905882,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257703',4905883,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257703',4905884,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257703',4905885,'2859','432',905076.18,909130.41,4054.23,750032.55,0.00,0.00,0.00,0.00,0.00),('5','105','964','257703',4905886,'2860','432',803250.30,806703.24,3452.94,638793.90,0.00,0.00,0.00,0.00,0.00),('5','105','965','257703',4905887,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257703',4905888,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257703',4905889,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257704',4905890,'2853','432',246699.61,246699.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257704',4905891,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257704',4905892,'2855','432',269430.88,269430.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257704',4905893,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257704',4905894,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257704',4905895,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257704',4905896,'2859','432',909130.41,912109.42,2979.01,551116.85,0.00,0.00,0.00,0.00,0.00),('5','105','964','257704',4905897,'2860','432',806703.24,809746.83,3043.59,563064.15,0.00,0.00,0.00,0.00,0.00),('5','105','965','257704',4905898,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257704',4905899,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257704',4905900,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257705',4905901,'2853','432',246699.61,246699.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257705',4905902,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257705',4905903,'2855','432',269430.88,269430.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257705',4905904,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257705',4905905,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257705',4905906,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257705',4905907,'2859','432',912109.42,914459.44,2350.02,434753.70,0.00,0.00,0.00,0.00,0.00),('5','105','964','257705',4905908,'2860','432',809746.83,812674.46,2927.63,541611.55,0.00,0.00,0.00,0.00,0.00),('5','105','965','257705',4905909,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257705',4905910,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257705',4905911,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257706',4905912,'2853','432',246699.61,246699.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257706',4905913,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257706',4905914,'2855','432',269430.88,269430.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257706',4905915,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257706',4905916,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257706',4905917,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257706',4905918,'2859','432',914459.44,918728.16,4268.72,789713.20,0.00,0.00,0.00,0.00,0.00),('5','105','964','257706',4905919,'2860','432',812674.46,814613.43,1938.97,358709.45,0.00,0.00,0.00,0.00,0.00),('5','105','965','257706',4905920,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257706',4905921,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257706',4905922,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257707',4905923,'2853','432',246699.61,246699.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257707',4905924,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257707',4905925,'2855','432',269430.88,269430.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257707',4905926,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257707',4905927,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257707',4905928,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257707',4905929,'2859','432',918728.16,920980.46,2252.30,416675.50,0.00,0.00,0.00,0.00,0.00),('5','105','964','257707',4905930,'2860','432',814613.43,814613.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257707',4905931,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257707',4905932,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257707',4905933,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257708',4905934,'2853','432',246699.61,246699.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257708',4905935,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257708',4905936,'2855','432',269430.88,269430.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257708',4905937,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257708',4905938,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257708',4905939,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257708',4905940,'2859','432',920980.46,920980.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257708',4905941,'2860','432',814613.43,814613.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257708',4905942,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257708',4905943,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257708',4905944,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257709',4905945,'2853','432',246699.61,246699.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257709',4905946,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257709',4905947,'2855','432',269430.88,269430.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257709',4905948,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257709',4905949,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257709',4905950,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257709',4905951,'2859','432',920980.46,920980.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257709',4905952,'2860','432',814613.43,814613.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257709',4905953,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257709',4905954,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257709',4905955,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257710',4905956,'2853','432',246699.61,246699.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257710',4905957,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257710',4905958,'2855','432',269430.88,269430.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257710',4905959,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257710',4905960,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257710',4905961,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257710',4905962,'2859','432',920980.46,920980.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257710',4905963,'2860','432',814613.43,814613.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257710',4905964,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257710',4905965,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257710',4905966,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257711',4905967,'2853','432',246699.61,246699.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257711',4905968,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257711',4905969,'2855','432',269430.88,269430.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257711',4905970,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257711',4905971,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257711',4905972,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257711',4905973,'2859','432',920980.46,922980.00,1999.54,369914.90,0.00,0.00,0.00,0.00,0.00),('5','105','964','257711',4905974,'2860','432',814613.43,814738.36,124.93,23112.05,0.00,0.00,0.00,0.00,0.00),('5','105','965','257711',4905975,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257711',4905976,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257711',4905977,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257712',4905978,'2853','432',246699.61,246699.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257712',4905979,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257712',4905980,'2855','432',269430.88,269430.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257712',4905981,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257712',4905982,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257712',4905983,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257712',4905984,'2859','432',922980.00,925083.48,2103.48,389143.80,0.00,0.00,0.00,0.00,0.00),('5','105','964','257712',4905985,'2860','432',814738.36,817654.72,2916.36,539526.60,0.00,0.00,0.00,0.00,0.00),('5','105','965','257712',4905986,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257712',4905987,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257712',4905988,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257713',4905989,'2853','432',246699.61,246699.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257713',4905990,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257713',4905991,'2855','432',269430.88,269430.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257713',4905992,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257713',4905993,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257713',4905994,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257713',4905995,'2859','432',925083.48,928820.93,3737.45,691428.25,0.00,0.00,0.00,0.00,0.00),('5','105','964','257713',4905996,'2860','432',817654.72,821131.93,3477.21,643283.85,0.00,0.00,0.00,0.00,0.00),('5','105','965','257713',4905997,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257713',4905998,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257713',4905999,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257714',4906000,'2853','432',246699.61,246699.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257714',4906001,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257714',4906002,'2855','432',269430.88,269430.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257714',4906003,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257714',4906004,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257714',4906005,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257714',4906006,'2859','432',928820.93,931414.68,2593.75,479843.75,0.00,0.00,0.00,0.00,0.00),('5','105','964','257714',4906007,'2860','432',821131.93,825224.52,4092.59,757129.15,0.00,0.00,0.00,0.00,0.00),('5','105','965','257714',4906008,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257714',4906009,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257714',4906010,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257715',4906011,'2853','432',246699.61,246699.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257715',4906012,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257715',4906013,'2855','432',269430.88,269430.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257715',4906014,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257715',4906015,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257715',4906016,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257715',4906017,'2859','432',931414.68,935486.44,4071.76,753275.60,0.00,0.00,0.00,0.00,0.00),('5','105','964','257715',4906018,'2860','432',825224.52,828166.25,2941.73,544220.05,0.00,0.00,0.00,0.00,0.00),('5','105','965','257715',4906019,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257715',4906020,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257715',4906021,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257716',4906022,'2853','432',246699.61,246699.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257716',4906023,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257716',4906024,'2855','432',269430.88,269430.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257716',4906025,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257716',4906026,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257716',4906027,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257716',4906028,'2859','432',935486.44,937972.96,2486.52,460006.20,0.00,0.00,0.00,0.00,0.00),('5','105','964','257716',4906029,'2860','432',828166.25,830781.98,2615.73,483910.05,0.00,0.00,0.00,0.00,0.00),('5','105','965','257716',4906030,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257716',4906031,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257716',4906032,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257717',4906033,'2853','432',246699.61,246699.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257717',4906034,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257717',4906035,'2855','432',269430.88,269430.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257717',4906036,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257717',4906037,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257717',4906038,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257717',4906039,'2859','432',937972.96,941769.88,3796.92,702430.20,0.00,0.00,0.00,0.00,0.00),('5','105','964','257717',4906040,'2860','432',830781.98,833165.96,2383.98,441036.30,0.00,0.00,0.00,0.00,0.00),('5','105','965','257717',4906041,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257717',4906042,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257717',4906043,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257718',4906044,'2853','432',246699.61,246699.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257718',4906045,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257718',4906046,'2855','432',269430.88,269430.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257718',4906047,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257718',4906048,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257718',4906049,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257718',4906050,'2859','432',941769.88,945503.46,3733.58,690712.30,0.00,0.00,0.00,0.00,0.00),('5','105','964','257718',4906051,'2860','432',833165.96,836275.15,3109.19,575200.15,0.00,0.00,0.00,0.00,0.00),('5','105','965','257718',4906052,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257718',4906053,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257718',4906054,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257719',4906055,'2853','432',246699.61,246699.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257719',4906056,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257719',4906057,'2855','432',269430.88,269430.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257719',4906058,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257719',4906059,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257719',4906060,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257719',4906061,'2859','432',945503.46,949697.34,4193.88,775867.80,0.00,0.00,0.00,0.00,0.00),('5','105','964','257719',4906062,'2860','432',836275.15,839414.50,3139.35,580779.75,0.00,0.00,0.00,0.00,0.00),('5','105','965','257719',4906063,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257719',4906064,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257719',4906065,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257720',4906066,'2853','432',246699.61,246699.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257720',4906067,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257720',4906068,'2855','432',269430.88,269430.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257720',4906069,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257720',4906070,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257720',4906071,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257720',4906072,'2859','432',949697.34,953145.38,3448.04,637887.40,0.00,0.00,0.00,0.00,0.00),('5','105','964','257720',4906073,'2860','432',839414.50,842414.33,2999.83,554968.55,0.00,0.00,0.00,0.00,0.00),('5','105','965','257720',4906074,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257720',4906075,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257720',4906076,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257721',4906077,'2853','432',246699.61,246699.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257721',4906078,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257721',4906079,'2855','432',269430.88,269430.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257721',4906080,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257721',4906081,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257721',4906082,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257721',4906083,'2859','432',953145.38,958006.86,4861.48,899373.80,0.00,0.00,0.00,0.00,0.00),('5','105','964','257721',4906084,'2860','432',842414.33,846188.84,3774.51,698284.35,0.00,0.00,0.00,0.00,0.00),('5','105','965','257721',4906085,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257721',4906086,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257721',4906087,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257722',4906088,'2853','432',246699.61,246699.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257722',4906089,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257722',4906090,'2855','432',269430.88,269430.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257722',4906091,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257722',4906092,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257722',4906093,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257722',4906094,'2859','432',958006.86,962113.26,4106.40,759684.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257722',4906095,'2860','432',846188.84,849849.36,3660.52,677196.20,0.00,0.00,0.00,0.00,0.00),('5','105','965','257722',4906096,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257722',4906097,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257722',4906098,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257723',4906099,'2853','432',246699.61,246699.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257723',4906100,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257723',4906101,'2855','432',269430.88,269430.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257723',4906102,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257723',4906103,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257723',4906104,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257723',4906105,'2859','432',962113.26,966015.44,3902.18,721903.30,0.00,0.00,0.00,0.00,0.00),('5','105','964','257723',4906106,'2860','432',849849.36,853712.93,3863.57,714760.45,0.00,0.00,0.00,0.00,0.00),('5','105','965','257723',4906107,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257723',4906108,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257723',4906109,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257724',4906110,'2853','432',246699.61,247841.02,1141.41,211160.85,0.00,0.00,0.00,0.00,0.00),('5','105','961','257724',4906111,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257724',4906112,'2855','432',269430.88,270163.32,732.44,135501.40,0.00,0.00,0.00,0.00,0.00),('5','105','961','257724',4906113,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257724',4906114,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257724',4906115,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257724',4906116,'2859','432',966015.44,969477.18,3461.74,640421.90,0.00,0.00,0.00,0.00,0.00),('5','105','964','257724',4906117,'2860','432',853712.93,856433.76,2720.83,503353.55,0.00,0.00,0.00,0.00,0.00),('5','105','965','257724',4906118,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257724',4906119,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257724',4906120,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257725',4906121,'2853','432',247841.02,251225.74,3384.72,626173.20,0.00,0.00,0.00,0.00,0.00),('5','105','961','257725',4906122,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257725',4906123,'2855','432',270163.32,274116.33,3953.01,731306.85,0.00,0.00,0.00,0.00,0.00),('5','105','961','257725',4906124,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257725',4906125,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257725',4906126,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257725',4906127,'2859','432',969477.18,969477.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257725',4906128,'2860','432',856433.76,856433.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257725',4906129,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257725',4906130,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257725',4906131,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257726',4906132,'2853','432',251225.74,254667.81,3442.07,636782.95,0.00,0.00,0.00,0.00,0.00),('5','105','961','257726',4906133,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257726',4906134,'2855','432',274116.33,277941.87,3825.54,707724.90,0.00,0.00,0.00,0.00,0.00),('5','105','961','257726',4906135,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257726',4906136,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257726',4906137,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257726',4906138,'2859','432',969477.18,969477.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257726',4906139,'2860','432',856433.76,856433.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257726',4906140,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257726',4906141,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257726',4906142,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257727',4906143,'2853','432',254667.81,258824.76,4156.95,769035.75,0.00,0.00,0.00,0.00,0.00),('5','105','961','257727',4906144,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257727',4906145,'2855','432',277941.87,282352.95,4411.08,816049.80,0.00,0.00,0.00,0.00,0.00),('5','105','961','257727',4906146,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257727',4906147,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257727',4906148,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257727',4906149,'2859','432',969477.18,969477.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257727',4906150,'2860','432',856433.76,856433.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257727',4906151,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257727',4906152,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257727',4906153,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257728',4906154,'2853','432',258824.76,262423.02,3598.26,665678.10,0.00,0.00,0.00,0.00,0.00),('5','105','961','257728',4906155,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257728',4906156,'2855','432',282352.95,286583.43,4230.48,782638.80,0.00,0.00,0.00,0.00,0.00),('5','105','961','257728',4906157,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257728',4906158,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257728',4906159,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257728',4906160,'2859','432',969477.18,969477.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257728',4906161,'2860','432',856433.76,856433.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257728',4906162,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257728',4906163,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257728',4906164,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257729',4906165,'2853','432',262423.02,265913.87,3490.85,645807.25,0.00,0.00,0.00,0.00,0.00),('5','105','961','257729',4906166,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257729',4906167,'2855','432',286583.43,290504.27,3920.84,725355.40,0.00,0.00,0.00,0.00,0.00),('5','105','961','257729',4906168,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257729',4906169,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257729',4906170,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257729',4906171,'2859','432',969477.18,969477.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257729',4906172,'2860','432',856433.76,856433.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257729',4906173,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257729',4906174,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257729',4906175,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257730',4906176,'2853','432',265913.87,269218.05,3304.18,611273.30,0.00,0.00,0.00,0.00,0.00),('5','105','961','257730',4906177,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257730',4906178,'2855','432',290504.27,294522.92,4018.65,743450.25,0.00,0.00,0.00,0.00,0.00),('5','105','961','257730',4906179,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257730',4906180,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257730',4906181,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257730',4906182,'2859','432',969477.18,969477.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257730',4906183,'2860','432',856433.76,857646.63,1212.87,224380.95,0.00,0.00,0.00,0.00,0.00),('5','105','965','257730',4906184,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257730',4906185,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257730',4906186,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257731',4906187,'2853','432',269218.05,271299.27,2081.22,385025.70,0.00,0.00,0.00,0.00,0.00),('5','105','961','257731',4906188,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257731',4906189,'2855','432',294522.92,294522.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257731',4906190,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257731',4906191,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257731',4906192,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257731',4906193,'2859','432',969477.18,973139.10,3661.92,677455.20,0.00,0.00,0.00,0.00,0.00),('5','105','964','257731',4906194,'2860','432',857646.63,858536.04,889.41,164540.85,0.00,0.00,0.00,0.00,0.00),('5','105','965','257731',4906195,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257731',4906196,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257731',4906197,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257732',4906198,'2853','432',271299.27,271299.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257732',4906199,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257732',4906200,'2855','432',294522.92,294522.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257732',4906201,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257732',4906202,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257732',4906203,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257732',4906204,'2859','432',973139.10,977052.47,3913.37,723973.45,0.00,0.00,0.00,0.00,0.00),('5','105','964','257732',4906205,'2860','432',858536.04,862220.71,3684.67,681663.95,0.00,0.00,0.00,0.00,0.00),('5','105','965','257732',4906206,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257732',4906207,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257732',4906208,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257733',4906209,'2853','432',271299.27,271299.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257733',4906210,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257733',4906211,'2855','432',294522.92,294522.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257733',4906212,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257733',4906213,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257733',4906214,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257733',4906215,'2859','432',977052.47,980631.35,3578.88,662092.80,0.00,0.00,0.00,0.00,0.00),('5','105','964','257733',4906216,'2860','432',862220.71,865834.30,3613.59,668514.15,0.00,0.00,0.00,0.00,0.00),('5','105','965','257733',4906217,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257733',4906218,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257733',4906219,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257734',4906220,'2853','432',271299.27,271299.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257734',4906221,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257734',4906222,'2855','432',294522.92,294522.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257734',4906223,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257734',4906224,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257734',4906225,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257734',4906226,'2859','432',980631.35,988603.16,7971.81,1474784.85,0.00,0.00,0.00,0.00,0.00),('5','105','964','257734',4906227,'2860','432',865834.30,873354.26,7519.96,1391192.60,0.00,0.00,0.00,0.00,0.00),('5','105','965','257734',4906228,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257734',4906229,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257734',4906230,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257735',4906231,'2853','432',271299.27,271299.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257735',4906232,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257735',4906233,'2855','432',294522.92,294522.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257735',4906234,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257735',4906235,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257735',4906236,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257735',4906237,'2859','432',988603.16,991172.55,2569.39,475337.15,0.00,0.00,0.00,0.00,0.00),('5','105','964','257735',4906238,'2860','432',873354.26,874341.60,987.34,182657.90,0.00,0.00,0.00,0.00,0.00),('5','105','965','257735',4906239,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257735',4906240,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257735',4906241,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257736',4906242,'2853','432',271299.27,271299.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257736',4906243,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257736',4906244,'2855','432',294522.92,294522.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257736',4906245,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257736',4906246,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257736',4906247,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257736',4906248,'2859','432',991172.55,991172.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257736',4906249,'2860','432',874341.60,874341.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257736',4906250,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257736',4906251,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257736',4906252,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257737',4906253,'2853','432',271299.27,271299.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257737',4906254,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257737',4906255,'2855','432',294522.92,294522.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257737',4906256,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257737',4906257,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257737',4906258,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257737',4906259,'2859','432',991172.55,991172.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257737',4906260,'2860','432',874341.60,874341.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257737',4906261,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257737',4906262,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257737',4906263,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257738',4906264,'2853','432',271299.27,271299.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257738',4906265,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257738',4906266,'2855','432',294522.92,294522.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257738',4906267,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257738',4906268,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257738',4906269,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257738',4906270,'2859','432',991172.55,991172.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257738',4906271,'2860','432',874341.60,874341.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257738',4906272,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257738',4906273,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257738',4906274,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257739',4906275,'2853','432',271299.27,271299.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257739',4906276,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257739',4906277,'2855','432',294522.92,294522.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257739',4906278,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257739',4906279,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257739',4906280,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257739',4906281,'2859','432',991172.55,991172.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257739',4906282,'2860','432',874341.60,874341.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257739',4906283,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257739',4906284,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257739',4906285,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257740',4906286,'2853','432',271299.27,271299.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257740',4906287,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257740',4906288,'2855','432',294522.92,294522.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257740',4906289,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257740',4906290,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257740',4906291,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257740',4906292,'2859','432',991172.55,991172.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257740',4906293,'2860','432',874341.60,874341.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257740',4906294,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257740',4906295,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257740',4906296,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257741',4906297,'2853','432',271299.27,271299.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257741',4906298,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257741',4906299,'2855','432',294522.92,294522.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257741',4906300,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257741',4906301,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257741',4906302,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257741',4906303,'2859','432',991172.55,991172.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257741',4906304,'2860','432',874341.60,874341.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257741',4906305,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257741',4906306,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257741',4906307,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257742',4906308,'2853','432',271299.27,271299.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257742',4906309,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257742',4906310,'2855','432',294522.92,294522.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257742',4906311,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257742',4906312,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257742',4906313,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257742',4906314,'2859','432',991172.55,991172.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257742',4906315,'2860','432',874341.60,874341.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257742',4906316,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257742',4906317,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257742',4906318,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257743',4906319,'2853','432',271299.27,271299.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257743',4906320,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257743',4906321,'2855','432',294522.92,294522.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257743',4906322,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257743',4906323,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257743',4906324,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257743',4906325,'2859','432',991172.55,991172.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257743',4906326,'2860','432',874341.60,874341.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257743',4906327,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257743',4906328,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257743',4906329,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257744',4906330,'2853','432',271299.27,271299.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257744',4906331,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257744',4906332,'2855','432',294522.92,294522.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257744',4906333,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257744',4906334,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257744',4906335,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257744',4906336,'2859','432',991172.55,991172.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257744',4906337,'2860','432',874341.60,874341.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257744',4906338,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257744',4906339,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257744',4906340,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257745',4906341,'2853','432',271299.27,271299.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257745',4906342,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257745',4906343,'2855','432',294522.92,294522.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257745',4906344,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257745',4906345,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257745',4906346,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257745',4906347,'2859','432',991172.55,991172.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257745',4906348,'2860','432',874341.60,874341.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257745',4906349,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257745',4906350,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257745',4906351,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257746',4906352,'2853','432',271299.27,271299.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257746',4906353,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257746',4906354,'2855','432',294522.92,294522.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257746',4906355,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257746',4906356,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257746',4906357,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257746',4906358,'2859','432',991172.55,991172.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257746',4906359,'2860','432',874341.60,874341.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257746',4906360,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257746',4906361,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257746',4906362,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257747',4906363,'2853','432',271299.27,271299.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257747',4906364,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257747',4906365,'2855','432',294522.92,294522.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257747',4906366,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257747',4906367,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257747',4906368,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257747',4906369,'2859','432',991172.55,991172.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257747',4906370,'2860','432',874341.60,874341.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257747',4906371,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257747',4906372,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257747',4906373,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257748',4906374,'2853','432',271299.27,271299.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257748',4906375,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257748',4906376,'2855','432',294522.92,294522.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257748',4906377,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257748',4906378,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257748',4906379,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257748',4906380,'2859','432',991172.55,991172.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257748',4906381,'2860','432',874341.60,874341.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257748',4906382,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257748',4906383,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257748',4906384,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257749',4906385,'2853','432',271299.27,271299.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257749',4906386,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257749',4906387,'2855','432',294522.92,294522.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257749',4906388,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257749',4906389,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257749',4906390,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257749',4906391,'2859','432',991172.55,991172.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257749',4906392,'2860','432',874341.60,874341.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257749',4906393,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257749',4906394,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257749',4906395,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257750',4906396,'2853','432',271299.27,271299.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257750',4906397,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257750',4906398,'2855','432',294522.92,294522.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257750',4906399,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257750',4906400,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257750',4906401,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257750',4906402,'2859','432',991172.55,991172.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257750',4906403,'2860','432',874341.60,874341.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257750',4906404,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257750',4906405,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257750',4906406,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257751',4906407,'2853','432',271299.27,271299.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257751',4906408,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257751',4906409,'2855','432',294522.92,294522.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257751',4906410,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257751',4906411,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257751',4906412,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257751',4906413,'2859','432',991172.55,991172.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257751',4906414,'2860','432',874341.60,874341.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257751',4906415,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257751',4906416,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257751',4906417,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257752',4906418,'2853','432',271299.27,271299.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257752',4906419,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257752',4906420,'2855','432',294522.92,294522.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257752',4906421,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257752',4906422,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257752',4906423,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257752',4906424,'2859','432',991172.55,991172.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257752',4906425,'2860','432',874341.60,874341.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257752',4906426,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257752',4906427,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257752',4906428,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257753',4906429,'2853','432',271299.27,271299.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257753',4906430,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257753',4906431,'2855','432',294522.92,294522.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257753',4906432,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257753',4906433,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257753',4906434,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257753',4906435,'2859','432',991172.55,991867.01,694.46,128475.10,0.00,0.00,0.00,0.00,0.00),('5','105','964','257753',4906436,'2860','432',874341.60,875392.21,1050.61,194362.85,0.00,0.00,0.00,0.00,0.00),('5','105','965','257753',4906437,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257753',4906438,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257753',4906439,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257754',4906440,'2853','432',271299.27,271299.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257754',4906441,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257754',4906442,'2855','432',294522.92,294522.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257754',4906443,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257754',4906444,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257754',4906445,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257754',4906446,'2859','432',991867.01,996091.65,4224.64,781558.40,0.00,0.00,0.00,0.00,0.00),('5','105','964','257754',4906447,'2860','432',875392.21,879544.41,4152.20,768157.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257754',4906448,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257754',4906449,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257754',4906450,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257755',4906451,'2853','432',271299.27,271299.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257755',4906452,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257755',4906453,'2855','432',294522.92,294522.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257755',4906454,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257755',4906455,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257755',4906456,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257755',4906457,'2859','432',996091.65,1001255.62,5163.97,955334.45,0.00,0.00,0.00,0.00,0.00),('5','105','964','257755',4906458,'2860','432',879544.41,884480.95,4936.54,913259.90,0.00,0.00,0.00,0.00,0.00),('5','105','965','257755',4906459,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257755',4906460,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257755',4906461,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257756',4906462,'2853','432',271299.27,271299.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257756',4906463,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257756',4906464,'2855','432',294522.92,294522.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257756',4906465,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257756',4906466,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257756',4906467,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257756',4906468,'2859','432',1001255.62,1006348.91,5093.29,942258.65,0.00,0.00,0.00,0.00,0.00),('5','105','964','257756',4906469,'2860','432',884480.95,890174.26,5693.31,1053262.35,0.00,0.00,0.00,0.00,0.00),('5','105','965','257756',4906470,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257756',4906471,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257756',4906472,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257757',4906473,'2853','432',271299.27,271299.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257757',4906474,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257757',4906475,'2855','432',294522.92,294522.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257757',4906476,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257757',4906477,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257757',4906478,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257757',4906479,'2859','432',1006348.91,1012463.10,6114.19,1131125.15,0.00,0.00,0.00,0.00,0.00),('5','105','964','257757',4906480,'2860','432',890174.26,896018.91,5844.65,1081260.25,0.00,0.00,0.00,0.00,0.00),('5','105','965','257757',4906481,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257757',4906482,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257757',4906483,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257758',4906484,'2853','432',271299.27,271299.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257758',4906485,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257758',4906486,'2855','432',294522.92,294522.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257758',4906487,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257758',4906488,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257758',4906489,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257758',4906490,'2859','432',1012463.10,1018192.48,5729.38,1059935.30,0.00,0.00,0.00,0.00,0.00),('5','105','964','257758',4906491,'2860','432',896018.91,902311.88,6292.97,1164199.45,0.00,0.00,0.00,0.00,0.00),('5','105','965','257758',4906492,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257758',4906493,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257758',4906494,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257759',4906495,'2853','432',271299.27,271299.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257759',4906496,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257759',4906497,'2855','432',294522.92,294522.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257759',4906498,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257759',4906499,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257759',4906500,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257759',4906501,'2859','432',1018192.48,1026020.56,7828.08,1448194.80,0.00,0.00,0.00,0.00,0.00),('5','105','964','257759',4906502,'2860','432',902311.88,909644.88,7333.00,1356605.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257759',4906503,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257759',4906504,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257759',4906505,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257760',4906506,'2853','432',271299.27,275821.35,4522.08,836584.80,0.00,0.00,0.00,0.00,0.00),('5','105','961','257760',4906507,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257760',4906508,'2855','432',294522.92,294522.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257760',4906509,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257760',4906510,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257760',4906511,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257760',4906512,'2859','432',1026020.56,1031338.53,5317.97,983824.45,0.00,0.00,0.00,0.00,0.00),('5','105','964','257760',4906513,'2860','432',909644.88,914874.05,5229.17,967396.45,0.00,0.00,0.00,0.00,0.00),('5','105','965','257760',4906514,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257760',4906515,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257760',4906516,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257761',4906517,'2853','432',275821.35,279786.66,3965.31,733582.35,0.00,0.00,0.00,0.00,0.00),('5','105','961','257761',4906518,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257761',4906519,'2855','432',294522.92,299092.17,4569.25,845311.25,0.00,0.00,0.00,0.00,0.00),('5','105','961','257761',4906520,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257761',4906521,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257761',4906522,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257761',4906523,'2859','432',1031338.53,1035878.18,4539.65,839835.25,0.00,0.00,0.00,0.00,0.00),('5','105','964','257761',4906524,'2860','432',914874.05,914874.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257761',4906525,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257761',4906526,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257761',4906527,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257762',4906528,'2853','432',279786.66,284491.11,4704.45,870323.25,0.00,0.00,0.00,0.00,0.00),('5','105','961','257762',4906529,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257762',4906530,'2855','432',299092.17,303655.18,4563.01,844156.85,0.00,0.00,0.00,0.00,0.00),('5','105','961','257762',4906531,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257762',4906532,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257762',4906533,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257762',4906534,'2859','432',1035878.18,1039836.11,3957.93,732217.05,0.00,0.00,0.00,0.00,0.00),('5','105','964','257762',4906535,'2860','432',914874.05,914874.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257762',4906536,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257762',4906537,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257762',4906538,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257763',4906539,'2853','432',284491.11,289742.41,5251.30,971490.50,0.00,0.00,0.00,0.00,0.00),('5','105','961','257763',4906540,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257763',4906541,'2855','432',303655.18,309111.43,5456.25,1009406.25,0.00,0.00,0.00,0.00,0.00),('5','105','961','257763',4906542,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257763',4906543,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257763',4906544,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257763',4906545,'2859','432',1039836.11,1041315.43,1479.32,273674.20,0.00,0.00,0.00,0.00,0.00),('5','105','964','257763',4906546,'2860','432',914874.05,914874.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257763',4906547,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257763',4906548,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257763',4906549,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257764',4906550,'2853','432',289742.41,295496.64,5754.23,1064532.55,0.00,0.00,0.00,0.00,0.00),('5','105','961','257764',4906551,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257764',4906552,'2855','432',309111.43,313389.36,4277.93,791417.05,0.00,0.00,0.00,0.00,0.00),('5','105','961','257764',4906553,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257764',4906554,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257764',4906555,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257764',4906556,'2859','432',1041315.43,1041315.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257764',4906557,'2860','432',914874.05,914874.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257764',4906558,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257764',4906559,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257764',4906560,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257765',4906561,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257765',4906562,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257765',4906563,'2855','432',313389.36,315245.97,1856.61,343472.85,0.00,0.00,0.00,0.00,0.00),('5','105','961','257765',4906564,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257765',4906565,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257765',4906566,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257765',4906567,'2859','432',1041315.43,1041315.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257765',4906568,'2860','432',914874.05,914874.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257765',4906569,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257765',4906570,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257765',4906571,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257766',4906572,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257766',4906573,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257766',4906574,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257766',4906575,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257766',4906576,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257766',4906577,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257766',4906578,'2859','432',1041315.43,1041315.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257766',4906579,'2860','432',914874.05,914874.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257766',4906580,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257766',4906581,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257766',4906582,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257767',4906583,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257767',4906584,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257767',4906585,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257767',4906586,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257767',4906587,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257767',4906588,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257767',4906589,'2859','432',1041315.43,1041315.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257767',4906590,'2860','432',914874.05,914874.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257767',4906591,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257767',4906592,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257767',4906593,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257768',4906594,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257768',4906595,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257768',4906596,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257768',4906597,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257768',4906598,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257768',4906599,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257768',4906600,'2859','432',1041315.43,1041315.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257768',4906601,'2860','432',914874.05,914874.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257768',4906602,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257768',4906603,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257768',4906604,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257769',4906605,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257769',4906606,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257769',4906607,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257769',4906608,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257769',4906609,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257769',4906610,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257769',4906611,'2859','432',1041315.43,1041315.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257769',4906612,'2860','432',914874.05,914874.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257769',4906613,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257769',4906614,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257769',4906615,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257770',4906616,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257770',4906617,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257770',4906618,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257770',4906619,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257770',4906620,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257770',4906621,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257770',4906622,'2859','432',1041315.43,1041315.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257770',4906623,'2860','432',914874.05,914874.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257770',4906624,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257770',4906625,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257770',4906626,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257771',4906627,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257771',4906628,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257771',4906629,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257771',4906630,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257771',4906631,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257771',4906632,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257771',4906633,'2859','432',1041315.43,1041315.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257771',4906634,'2860','432',914874.05,914874.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257771',4906635,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257771',4906636,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257771',4906637,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257772',4906638,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257772',4906639,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257772',4906640,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257772',4906641,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257772',4906642,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257772',4906643,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257772',4906644,'2859','432',1041315.43,1041315.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257772',4906645,'2860','432',914874.05,914874.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257772',4906646,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257772',4906647,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257772',4906648,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257773',4906649,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257773',4906650,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257773',4906651,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257773',4906652,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257773',4906653,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257773',4906654,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257773',4906655,'2859','432',1041315.43,1041315.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257773',4906656,'2860','432',914874.05,914874.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257773',4906657,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257773',4906658,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257773',4906659,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257774',4906660,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257774',4906661,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257774',4906662,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257774',4906663,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257774',4906664,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257774',4906665,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257774',4906666,'2859','432',1041315.43,1041315.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257774',4906667,'2860','432',914874.05,914874.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257774',4906668,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257774',4906669,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257774',4906670,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257775',4906671,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257775',4906672,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257775',4906673,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257775',4906674,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257775',4906675,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257775',4906676,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257775',4906677,'2859','432',1041315.43,1041315.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257775',4906678,'2860','432',914874.05,914874.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257775',4906679,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257775',4906680,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257775',4906681,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257776',4906682,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257776',4906683,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257776',4906684,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257776',4906685,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257776',4906686,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257776',4906687,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257776',4906688,'2859','432',1041315.43,1041315.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257776',4906689,'2860','432',914874.05,914874.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257776',4906690,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257776',4906691,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257776',4906692,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257777',4906693,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257777',4906694,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257777',4906695,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257777',4906696,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257777',4906697,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257777',4906698,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257777',4906699,'2859','432',1041315.43,1041315.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257777',4906700,'2860','432',914874.05,914874.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257777',4906701,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257777',4906702,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257777',4906703,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257778',4906704,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257778',4906705,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257778',4906706,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257778',4906707,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257778',4906708,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257778',4906709,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257778',4906710,'2859','432',1041315.43,1042630.94,1315.51,243369.35,0.00,0.00,0.00,0.00,0.00),('5','105','964','257778',4906711,'2860','432',914874.05,916438.84,1564.79,289486.15,0.00,0.00,0.00,0.00,0.00),('5','105','965','257778',4906712,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257778',4906713,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257778',4906714,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257779',4906715,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257779',4906716,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257779',4906717,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257779',4906718,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257779',4906719,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257779',4906720,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257779',4906721,'2859','432',1042630.94,1048419.77,5788.83,1070933.55,0.00,0.00,0.00,0.00,0.00),('5','105','964','257779',4906722,'2860','432',916438.84,921732.67,5293.83,979358.55,0.00,0.00,0.00,0.00,0.00),('5','105','965','257779',4906723,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257779',4906724,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257779',4906725,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257780',4906726,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257780',4906727,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257780',4906728,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257780',4906729,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257780',4906730,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257780',4906731,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257780',4906732,'2859','432',1048419.77,1053763.67,5343.90,988621.50,0.00,0.00,0.00,0.00,0.00),('5','105','964','257780',4906733,'2860','432',921732.67,927539.55,5806.88,1074272.80,0.00,0.00,0.00,0.00,0.00),('5','105','965','257780',4906734,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257780',4906735,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257780',4906736,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257781',4906737,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257781',4906738,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257781',4906739,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257781',4906740,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257781',4906741,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257781',4906742,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257781',4906743,'2859','432',1053763.67,1058009.09,4245.42,785402.70,0.00,0.00,0.00,0.00,0.00),('5','105','964','257781',4906744,'2860','432',927539.55,931327.04,3787.49,700685.65,0.00,0.00,0.00,0.00,0.00),('5','105','965','257781',4906745,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257781',4906746,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257781',4906747,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257782',4906748,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257782',4906749,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257782',4906750,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257782',4906751,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257782',4906752,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257782',4906753,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257782',4906754,'2859','432',1058009.09,1058009.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257782',4906755,'2860','432',931327.04,931327.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257782',4906756,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257782',4906757,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257782',4906758,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257783',4906759,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257783',4906760,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257783',4906761,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257783',4906762,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257783',4906763,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257783',4906764,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257783',4906765,'2859','432',1058009.09,1058009.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257783',4906766,'2860','432',931327.04,931327.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257783',4906767,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257783',4906768,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257783',4906769,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257784',4906770,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257784',4906771,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257784',4906772,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257784',4906773,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257784',4906774,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257784',4906775,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257784',4906776,'2859','432',1058009.09,1058009.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257784',4906777,'2860','432',931327.04,931327.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257784',4906778,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257784',4906779,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257784',4906780,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257785',4906781,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257785',4906782,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257785',4906783,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257785',4906784,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257785',4906785,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257785',4906786,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257785',4906787,'2859','432',1058009.09,1058009.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257785',4906788,'2860','432',931327.04,931327.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257785',4906789,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257785',4906790,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257785',4906791,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257786',4906792,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257786',4906793,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257786',4906794,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257786',4906795,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257786',4906796,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257786',4906797,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257786',4906798,'2859','432',1058009.09,1058700.54,691.45,127918.25,0.00,0.00,0.00,0.00,0.00),('5','105','964','257786',4906799,'2860','432',931327.04,932470.49,1143.45,211538.25,0.00,0.00,0.00,0.00,0.00),('5','105','965','257786',4906800,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257786',4906801,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257786',4906802,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257787',4906803,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257787',4906804,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257787',4906805,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257787',4906806,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257787',4906807,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257787',4906808,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257787',4906809,'2859','432',1058700.54,1064314.68,5614.14,1038615.90,0.00,0.00,0.00,0.00,0.00),('5','105','964','257787',4906810,'2860','432',932470.49,937136.23,4665.74,863161.90,0.00,0.00,0.00,0.00,0.00),('5','105','965','257787',4906811,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257787',4906812,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257787',4906813,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257788',4906814,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257788',4906815,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257788',4906816,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257788',4906817,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257788',4906818,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257788',4906819,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257788',4906820,'2859','432',1064314.68,1069369.29,5054.61,935102.85,0.00,0.00,0.00,0.00,0.00),('5','105','964','257788',4906821,'2860','432',937136.23,942620.66,5484.43,1014619.55,0.00,0.00,0.00,0.00,0.00),('5','105','965','257788',4906822,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257788',4906823,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257788',4906824,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257789',4906825,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257789',4906826,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257789',4906827,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257789',4906828,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257789',4906829,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257789',4906830,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257789',4906831,'2859','432',1069369.29,1073645.99,4276.70,791189.50,0.00,0.00,0.00,0.00,0.00),('5','105','964','257789',4906832,'2860','432',942620.66,949144.41,6523.75,1206893.75,0.00,0.00,0.00,0.00,0.00),('5','105','965','257789',4906833,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257789',4906834,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257789',4906835,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257790',4906836,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257790',4906837,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257790',4906838,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257790',4906839,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257790',4906840,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257790',4906841,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257790',4906842,'2859','432',1073645.99,1079287.77,5641.78,1043729.30,0.00,0.00,0.00,0.00,0.00),('5','105','964','257790',4906843,'2860','432',949144.41,954251.87,5107.46,944880.10,0.00,0.00,0.00,0.00,0.00),('5','105','965','257790',4906844,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257790',4906845,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257790',4906846,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257791',4906847,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257791',4906848,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257791',4906849,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257791',4906850,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257791',4906851,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257791',4906852,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257791',4906853,'2859','432',1079287.77,1084013.89,4726.12,874332.20,0.00,0.00,0.00,0.00,0.00),('5','105','964','257791',4906854,'2860','432',954251.87,960089.66,5837.79,1079991.15,0.00,0.00,0.00,0.00,0.00),('5','105','965','257791',4906855,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257791',4906856,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257791',4906857,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257792',4906858,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257792',4906859,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257792',4906860,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257792',4906861,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257792',4906862,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257792',4906863,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257792',4906864,'2859','432',1084013.89,1089469.63,5455.74,1009311.90,0.00,0.00,0.00,0.00,0.00),('5','105','964','257792',4906865,'2860','432',960089.66,965839.73,5750.07,1063762.95,0.00,0.00,0.00,0.00,0.00),('5','105','965','257792',4906866,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257792',4906867,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257792',4906868,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257793',4906869,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257793',4906870,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257793',4906871,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257793',4906872,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257793',4906873,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257793',4906874,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257793',4906875,'2859','432',1089469.63,1094717.15,5247.52,970791.20,0.00,0.00,0.00,0.00,0.00),('5','105','964','257793',4906876,'2860','432',965839.73,970257.57,4417.84,817300.40,0.00,0.00,0.00,0.00,0.00),('5','105','965','257793',4906877,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257793',4906878,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257793',4906879,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257794',4906880,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257794',4906881,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257794',4906882,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257794',4906883,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257794',4906884,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257794',4906885,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257794',4906886,'2859','432',1094717.15,1100098.76,5381.61,995597.85,0.00,0.00,0.00,0.00,0.00),('5','105','964','257794',4906887,'2860','432',970257.57,973843.80,3586.23,663452.55,0.00,0.00,0.00,0.00,0.00),('5','105','965','257794',4906888,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257794',4906889,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257794',4906890,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257795',4906891,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257795',4906892,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257795',4906893,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257795',4906894,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257795',4906895,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257795',4906896,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257795',4906897,'2859','432',1100098.76,1100098.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257795',4906898,'2860','432',973843.80,973843.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257795',4906899,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257795',4906900,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257795',4906901,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257796',4906902,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257796',4906903,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257796',4906904,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257796',4906905,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257796',4906906,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257796',4906907,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257796',4906908,'2859','432',1100098.76,1100098.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257796',4906909,'2860','432',973843.80,973843.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257796',4906910,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257796',4906911,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257796',4906912,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257797',4906913,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257797',4906914,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257797',4906915,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257797',4906916,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257797',4906917,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257797',4906918,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257797',4906919,'2859','432',1100098.76,1100098.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257797',4906920,'2860','432',973843.80,973843.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257797',4906921,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257797',4906922,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257797',4906923,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257798',4906924,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257798',4906925,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257798',4906926,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257798',4906927,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257798',4906928,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257798',4906929,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257798',4906930,'2859','432',1100098.76,1100098.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257798',4906931,'2860','432',973843.80,973843.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257798',4906932,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257798',4906933,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257798',4906934,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257799',4906935,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257799',4906936,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257799',4906937,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257799',4906938,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257799',4906939,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257799',4906940,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257799',4906941,'2859','432',1100098.76,1100098.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257799',4906942,'2860','432',973843.80,973843.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257799',4906943,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257799',4906944,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257799',4906945,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257800',4906946,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257800',4906947,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257800',4906948,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257800',4906949,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257800',4906950,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257800',4906951,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257800',4906952,'2859','432',1100098.76,1100098.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257800',4906953,'2860','432',973843.80,973843.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257800',4906954,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257800',4906955,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257800',4906956,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257801',4906957,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257801',4906958,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257801',4906959,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257801',4906960,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257801',4906961,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257801',4906962,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257801',4906963,'2859','432',1100098.76,1100098.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257801',4906964,'2860','432',973843.80,973843.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257801',4906965,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257801',4906966,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257801',4906967,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257802',4906968,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257802',4906969,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257802',4906970,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257802',4906971,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257802',4906972,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257802',4906973,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257802',4906974,'2859','432',1100098.76,1100098.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257802',4906975,'2860','432',973843.80,973843.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257802',4906976,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257802',4906977,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257802',4906978,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257803',4906979,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257803',4906980,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257803',4906981,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257803',4906982,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257803',4906983,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257803',4906984,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257803',4906985,'2859','432',1100098.76,1100098.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257803',4906986,'2860','432',973843.80,973843.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257803',4906987,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257803',4906988,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257803',4906989,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257804',4906990,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257804',4906991,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257804',4906992,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257804',4906993,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257804',4906994,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257804',4906995,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257804',4906996,'2859','432',1100098.76,1100098.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257804',4906997,'2860','432',973843.80,973843.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257804',4906998,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257804',4906999,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257804',4907000,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257805',4907001,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257805',4907002,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257805',4907003,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257805',4907004,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257805',4907005,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257805',4907006,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257805',4907007,'2859','432',1100098.76,1101742.21,1643.45,304038.25,0.00,0.00,0.00,0.00,0.00),('5','105','964','257805',4907008,'2860','432',973843.80,975551.72,1707.92,315965.20,0.00,0.00,0.00,0.00,0.00),('5','105','965','257805',4907009,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257805',4907010,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257805',4907011,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257806',4907012,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257806',4907013,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257806',4907014,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257806',4907015,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257806',4907016,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257806',4907017,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257806',4907018,'2859','432',1101742.21,1107363.72,5621.51,1039979.35,0.00,0.00,0.00,0.00,0.00),('5','105','964','257806',4907019,'2860','432',975551.72,983141.26,7589.54,1404064.90,0.00,0.00,0.00,0.00,0.00),('5','105','965','257806',4907020,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257806',4907021,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257806',4907022,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257807',4907023,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257807',4907024,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257807',4907025,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257807',4907026,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257807',4907027,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257807',4907028,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257807',4907029,'2859','432',1107363.72,1112172.87,4809.15,889692.75,0.00,0.00,0.00,0.00,0.00),('5','105','964','257807',4907030,'2860','432',983141.26,988600.20,5458.94,1009903.90,0.00,0.00,0.00,0.00,0.00),('5','105','965','257807',4907031,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257807',4907032,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257807',4907033,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257808',4907034,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257808',4907035,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257808',4907036,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257808',4907037,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257808',4907038,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257808',4907039,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257808',4907040,'2859','432',1112172.87,1115507.89,3335.02,616978.70,0.00,0.00,0.00,0.00,0.00),('5','105','964','257808',4907041,'2860','432',988600.20,988600.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257808',4907042,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257808',4907043,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257808',4907044,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257809',4907045,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257809',4907046,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257809',4907047,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257809',4907048,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257809',4907049,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257809',4907050,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257809',4907051,'2859','432',1115507.89,1115507.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257809',4907052,'2860','432',988600.20,988600.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257809',4907053,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257809',4907054,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257809',4907055,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257810',4907056,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257810',4907057,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257810',4907058,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257810',4907059,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257810',4907060,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257810',4907061,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257810',4907062,'2859','432',1115507.89,1115507.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257810',4907063,'2860','432',988600.20,988600.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257810',4907064,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257810',4907065,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257810',4907066,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257811',4907067,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257811',4907068,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257811',4907069,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257811',4907070,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257811',4907071,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257811',4907072,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257811',4907073,'2859','432',1115507.89,1115507.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257811',4907074,'2860','432',988600.20,988600.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257811',4907075,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257811',4907076,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257811',4907077,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257812',4907078,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257812',4907079,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257812',4907080,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257812',4907081,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257812',4907082,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257812',4907083,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257812',4907084,'2859','432',1115507.89,1115507.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257812',4907085,'2860','432',988600.20,988600.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257812',4907086,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257812',4907087,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257812',4907088,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257813',4907089,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257813',4907090,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257813',4907091,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257813',4907092,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257813',4907093,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257813',4907094,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257813',4907095,'2859','432',1115507.89,1115507.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257813',4907096,'2860','432',988600.20,988600.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257813',4907097,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257813',4907098,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257813',4907099,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257814',4907100,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257814',4907101,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257814',4907102,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257814',4907103,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257814',4907104,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257814',4907105,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257814',4907106,'2859','432',1115507.89,1115507.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257814',4907107,'2860','432',988600.20,988600.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257814',4907108,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257814',4907109,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257814',4907110,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257815',4907111,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257815',4907112,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257815',4907113,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257815',4907114,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257815',4907115,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257815',4907116,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257815',4907117,'2859','432',1115507.89,1115507.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257815',4907118,'2860','432',988600.20,988600.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257815',4907119,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257815',4907120,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257815',4907121,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257816',4907122,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257816',4907123,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257816',4907124,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257816',4907125,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257816',4907126,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257816',4907127,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257816',4907128,'2859','432',1115507.89,1115507.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257816',4907129,'2860','432',988600.20,988600.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257816',4907130,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257816',4907131,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257816',4907132,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257817',4907133,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257817',4907134,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257817',4907135,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257817',4907136,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257817',4907137,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257817',4907138,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257817',4907139,'2859','432',1115507.89,1115507.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257817',4907140,'2860','432',988600.20,988600.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257817',4907141,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257817',4907142,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257817',4907143,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257818',4907144,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257818',4907145,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257818',4907146,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257818',4907147,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257818',4907148,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257818',4907149,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257818',4907150,'2859','432',1115507.89,1115507.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257818',4907151,'2860','432',988600.20,988600.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257818',4907152,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257818',4907153,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257818',4907154,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257819',4907155,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257819',4907156,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257819',4907157,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257819',4907158,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257819',4907159,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257819',4907160,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257819',4907161,'2859','432',1115507.89,1115507.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257819',4907162,'2860','432',988600.20,988600.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257819',4907163,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257819',4907164,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257819',4907165,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257820',4907166,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257820',4907167,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257820',4907168,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257820',4907169,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257820',4907170,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257820',4907171,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257820',4907172,'2859','432',1115507.89,1115507.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257820',4907173,'2860','432',988600.20,988600.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257820',4907174,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257820',4907175,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257820',4907176,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257821',4907177,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257821',4907178,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257821',4907179,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257821',4907180,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257821',4907181,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257821',4907182,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257821',4907183,'2859','432',1115507.89,1115507.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257821',4907184,'2860','432',988600.20,988600.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257821',4907185,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257821',4907186,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257821',4907187,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257822',4907188,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257822',4907189,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257822',4907190,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257822',4907191,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257822',4907192,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257822',4907193,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257822',4907194,'2859','432',1115507.89,1115507.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257822',4907195,'2860','432',988600.20,988600.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257822',4907196,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257822',4907197,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257822',4907198,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257823',4907199,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257823',4907200,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257823',4907201,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257823',4907202,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257823',4907203,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257823',4907204,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257823',4907205,'2859','432',1115507.89,1115507.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257823',4907206,'2860','432',988600.20,988600.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257823',4907207,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257823',4907208,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257823',4907209,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257824',4907210,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257824',4907211,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257824',4907212,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257824',4907213,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257824',4907214,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257824',4907215,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257824',4907216,'2859','432',1115507.89,1115507.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257824',4907217,'2860','432',988600.20,988600.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257824',4907218,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257824',4907219,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257824',4907220,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257825',4907221,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257825',4907222,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257825',4907223,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257825',4907224,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257825',4907225,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257825',4907226,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257825',4907227,'2859','432',1115507.89,1115507.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257825',4907228,'2860','432',988600.20,988600.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257825',4907229,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257825',4907230,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257825',4907231,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257826',4907232,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257826',4907233,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257826',4907234,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257826',4907235,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257826',4907236,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257826',4907237,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257826',4907238,'2859','432',1115507.89,1115507.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257826',4907239,'2860','432',988600.20,988600.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257826',4907240,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257826',4907241,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257826',4907242,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257827',4907243,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257827',4907244,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257827',4907245,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257827',4907246,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257827',4907247,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257827',4907248,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257827',4907249,'2859','432',1115507.89,1115507.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257827',4907250,'2860','432',988600.20,988600.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257827',4907251,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257827',4907252,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257827',4907253,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257828',4907254,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257828',4907255,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257828',4907256,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257828',4907257,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257828',4907258,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257828',4907259,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257828',4907260,'2859','432',1115507.89,1115507.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257828',4907261,'2860','432',988600.20,988600.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257828',4907262,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257828',4907263,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257828',4907264,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257829',4907265,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257829',4907266,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257829',4907267,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257829',4907268,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257829',4907269,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257829',4907270,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257829',4907271,'2859','432',1115507.89,1115507.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257829',4907272,'2860','432',988600.20,988600.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257829',4907273,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257829',4907274,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257829',4907275,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257830',4907276,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257830',4907277,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257830',4907278,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257830',4907279,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257830',4907280,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257830',4907281,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257830',4907282,'2859','432',1115507.89,1115507.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257830',4907283,'2860','432',988600.20,988600.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257830',4907284,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257830',4907285,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257830',4907286,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257831',4907287,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257831',4907288,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257831',4907289,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257831',4907290,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257831',4907291,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257831',4907292,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257831',4907293,'2859','432',1115507.89,1115507.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257831',4907294,'2860','432',988600.20,988600.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257831',4907295,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257831',4907296,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257831',4907297,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257832',4907298,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257832',4907299,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257832',4907300,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257832',4907301,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257832',4907302,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257832',4907303,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257832',4907304,'2859','432',1115507.89,1115507.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257832',4907305,'2860','432',988600.20,988600.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257832',4907306,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257832',4907307,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257832',4907308,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257833',4907309,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257833',4907310,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257833',4907311,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257833',4907312,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257833',4907313,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257833',4907314,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257833',4907315,'2859','432',1115507.89,1115507.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257833',4907316,'2860','432',988600.20,988600.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257833',4907317,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257833',4907318,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257833',4907319,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257834',4907320,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257834',4907321,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257834',4907322,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257834',4907323,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257834',4907324,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257834',4907325,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257834',4907326,'2859','432',1115507.89,1115507.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257834',4907327,'2860','432',988600.20,988600.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257834',4907328,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257834',4907329,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257834',4907330,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257835',4907331,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257835',4907332,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257835',4907333,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257835',4907334,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257835',4907335,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257835',4907336,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257835',4907337,'2859','432',1115507.89,1123408.20,7900.31,1461557.35,0.00,0.00,0.00,0.00,0.00),('5','105','964','257835',4907338,'2860','432',988600.20,997286.76,8686.56,1607013.60,0.00,0.00,0.00,0.00,0.00),('5','105','965','257835',4907339,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257835',4907340,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257835',4907341,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257836',4907342,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257836',4907343,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257836',4907344,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257836',4907345,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257836',4907346,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257836',4907347,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257836',4907348,'2859','432',1123408.20,1128022.03,4613.83,853558.55,0.00,0.00,0.00,0.00,0.00),('5','105','964','257836',4907349,'2860','432',997286.76,1003829.13,6542.37,1210338.45,0.00,0.00,0.00,0.00,0.00),('5','105','965','257836',4907350,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257836',4907351,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257836',4907352,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257837',4907353,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257837',4907354,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257837',4907355,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257837',4907356,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257837',4907357,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257837',4907358,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257837',4907359,'2859','432',1128022.03,1130154.77,2132.74,394556.90,0.00,0.00,0.00,0.00,0.00),('5','105','964','257837',4907360,'2860','432',1003829.13,1004102.11,272.98,50501.30,0.00,0.00,0.00,0.00,0.00),('5','105','965','257837',4907361,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257837',4907362,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257837',4907363,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257838',4907364,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257838',4907365,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257838',4907366,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257838',4907367,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257838',4907368,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257838',4907369,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257838',4907370,'2859','432',1130154.77,1130154.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257838',4907371,'2860','432',1004102.11,1004102.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257838',4907372,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257838',4907373,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257838',4907374,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257839',4907375,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257839',4907376,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257839',4907377,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257839',4907378,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257839',4907379,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257839',4907380,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257839',4907381,'2859','432',1130154.77,1130154.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257839',4907382,'2860','432',1004102.11,1004102.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257839',4907383,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257839',4907384,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257839',4907385,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257840',4907386,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257840',4907387,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257840',4907388,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257840',4907389,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257840',4907390,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257840',4907391,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257840',4907392,'2859','432',1130154.77,1130987.17,832.40,183128.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257840',4907393,'2860','432',1004102.11,1005236.34,1134.23,249530.60,0.00,0.00,0.00,0.00,0.00),('5','105','965','257840',4907394,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257840',4907395,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257840',4907396,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257841',4907397,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257841',4907398,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257841',4907399,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257841',4907400,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257841',4907401,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257841',4907402,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257841',4907403,'2859','432',1130987.17,1130987.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257841',4907404,'2860','432',1005236.34,1005236.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257841',4907405,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257841',4907406,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257841',4907407,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257842',4907408,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257842',4907409,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257842',4907410,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257842',4907411,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257842',4907412,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257842',4907413,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257842',4907414,'2859','432',1130987.17,1136938.52,5951.35,1309297.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257842',4907415,'2860','432',1005236.34,1012367.95,7131.61,1568954.20,0.00,0.00,0.00,0.00,0.00),('5','105','965','257842',4907416,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257842',4907417,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257842',4907418,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257843',4907419,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257843',4907420,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257843',4907421,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257843',4907422,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257843',4907423,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257843',4907424,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257843',4907425,'2859','432',1136938.52,1143682.93,6744.41,1483770.20,0.00,0.00,0.00,0.00,0.00),('5','105','964','257843',4907426,'2860','432',1012367.95,1019854.21,7486.26,1646977.20,0.00,0.00,0.00,0.00,0.00),('5','105','965','257843',4907427,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257843',4907428,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257843',4907429,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257844',4907430,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257844',4907431,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257844',4907432,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257844',4907433,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257844',4907434,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257844',4907435,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257844',4907436,'2859','432',1143682.93,1148123.48,4440.55,976921.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257844',4907437,'2860','432',1019854.21,1022925.04,3070.83,675582.60,0.00,0.00,0.00,0.00,0.00),('5','105','965','257844',4907438,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257844',4907439,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257844',4907440,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257845',4907441,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257845',4907442,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257845',4907443,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257845',4907444,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257845',4907445,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257845',4907446,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257845',4907447,'2859','432',1148123.48,1148123.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257845',4907448,'2860','432',1022925.04,1022925.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257845',4907449,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257845',4907450,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257845',4907451,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257846',4907452,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257846',4907453,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257846',4907454,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257846',4907455,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257846',4907456,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257846',4907457,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257846',4907458,'2859','432',1148123.48,1148123.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257846',4907459,'2860','432',1022925.04,1022925.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257846',4907460,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257846',4907461,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257846',4907462,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257847',4907463,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257847',4907464,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257847',4907465,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257847',4907466,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257847',4907467,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257847',4907468,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257847',4907469,'2859','432',1148123.48,1148123.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257847',4907470,'2860','432',1022925.04,1022925.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257847',4907471,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257847',4907472,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257847',4907473,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257848',4907474,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257848',4907475,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257848',4907476,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257848',4907477,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257848',4907478,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257848',4907479,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257848',4907480,'2859','432',1148123.48,1148123.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257848',4907481,'2860','432',1022925.04,1022925.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257848',4907482,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257848',4907483,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257848',4907484,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257849',4907485,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257849',4907486,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257849',4907487,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257849',4907488,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257849',4907489,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257849',4907490,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257849',4907491,'2859','432',1148123.48,1148123.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257849',4907492,'2860','432',1022925.04,1022925.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257849',4907493,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257849',4907494,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257849',4907495,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257850',4907496,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257850',4907497,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257850',4907498,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257850',4907499,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257850',4907500,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257850',4907501,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257850',4907502,'2859','432',1148123.48,1148123.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257850',4907503,'2860','432',1022925.04,1022925.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257850',4907504,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257850',4907505,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257850',4907506,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257851',4907507,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257851',4907508,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257851',4907509,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257851',4907510,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257851',4907511,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257851',4907512,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257851',4907513,'2859','432',1148123.48,1148123.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257851',4907514,'2860','432',1022925.04,1022925.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257851',4907515,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257851',4907516,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257851',4907517,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257852',4907518,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257852',4907519,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257852',4907520,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257852',4907521,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257852',4907522,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257852',4907523,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257852',4907524,'2859','432',1148123.48,1148123.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257852',4907525,'2860','432',1022925.04,1022925.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257852',4907526,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257852',4907527,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257852',4907528,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257853',4907529,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257853',4907530,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257853',4907531,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257853',4907532,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257853',4907533,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257853',4907534,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257853',4907535,'2859','432',1148123.48,1148123.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257853',4907536,'2860','432',1022925.04,1022925.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257853',4907537,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257853',4907538,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257853',4907539,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257854',4907540,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257854',4907541,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257854',4907542,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257854',4907543,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257854',4907544,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257854',4907545,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257854',4907546,'2859','432',1148123.48,1148123.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257854',4907547,'2860','432',1022925.04,1022925.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257854',4907548,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257854',4907549,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257854',4907550,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257855',4907551,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257855',4907552,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257855',4907553,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257855',4907554,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257855',4907555,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257855',4907556,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257855',4907557,'2859','432',1148123.48,1148123.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257855',4907558,'2860','432',1022925.04,1022925.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257855',4907559,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257855',4907560,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257855',4907561,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257856',4907562,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257856',4907563,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257856',4907564,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257856',4907565,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257856',4907566,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257856',4907567,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257856',4907568,'2859','432',1148123.48,1148123.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257856',4907569,'2860','432',1022925.04,1022925.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257856',4907570,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257856',4907571,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257856',4907572,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257857',4907573,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257857',4907574,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257857',4907575,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257857',4907576,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257857',4907577,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257857',4907578,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257857',4907579,'2859','432',1148123.48,1150279.23,2155.75,474265.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257857',4907580,'2860','432',1022925.04,1025617.07,2692.03,592246.60,0.00,0.00,0.00,0.00,0.00),('5','105','965','257857',4907581,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257857',4907582,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257857',4907583,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257858',4907584,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257858',4907585,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257858',4907586,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257858',4907587,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257858',4907588,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257858',4907589,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257858',4907590,'2859','432',1150279.23,1158048.95,7769.72,1709338.40,0.00,0.00,0.00,0.00,0.00),('5','105','964','257858',4907591,'2860','432',1025617.07,1034449.43,8832.36,1943119.20,0.00,0.00,0.00,0.00,0.00),('5','105','965','257858',4907592,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257858',4907593,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257858',4907594,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257859',4907595,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257859',4907596,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257859',4907597,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257859',4907598,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257859',4907599,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257859',4907600,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257859',4907601,'2859','432',1158048.95,1162529.41,4480.46,985701.20,0.00,0.00,0.00,0.00,0.00),('5','105','964','257859',4907602,'2860','432',1034449.43,1038584.09,4134.66,909625.20,0.00,0.00,0.00,0.00,0.00),('5','105','965','257859',4907603,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257859',4907604,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257859',4907605,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257860',4907606,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257860',4907607,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257860',4907608,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257860',4907609,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257860',4907610,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257860',4907611,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257860',4907612,'2859','432',1162529.41,1162529.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257860',4907613,'2860','432',1038584.09,1038584.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257860',4907614,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257860',4907615,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257860',4907616,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257861',4907617,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257861',4907618,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257861',4907619,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257861',4907620,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257861',4907621,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257861',4907622,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257861',4907623,'2859','432',1162529.41,1162529.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257861',4907624,'2860','432',1038584.09,1038584.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257861',4907625,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257861',4907626,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257861',4907627,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257862',4907628,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257862',4907629,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257862',4907630,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257862',4907631,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257862',4907632,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257862',4907633,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257862',4907634,'2859','432',1162529.41,1162529.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257862',4907635,'2860','432',1038584.09,1038584.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257862',4907636,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257862',4907637,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257862',4907638,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257863',4907639,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257863',4907640,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257863',4907641,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257863',4907642,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257863',4907643,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257863',4907644,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257863',4907645,'2859','432',1162529.41,1162529.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257863',4907646,'2860','432',1038584.09,1038584.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257863',4907647,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257863',4907648,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257863',4907649,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257864',4907650,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257864',4907651,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257864',4907652,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257864',4907653,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257864',4907654,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257864',4907655,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257864',4907656,'2859','432',1162529.41,1162529.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257864',4907657,'2860','432',1038584.09,1038584.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257864',4907658,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257864',4907659,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257864',4907660,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257865',4907661,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257865',4907662,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257865',4907663,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257865',4907664,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257865',4907665,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257865',4907666,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257865',4907667,'2859','432',1162529.41,1162529.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257865',4907668,'2860','432',1038584.09,1038584.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257865',4907669,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257865',4907670,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257865',4907671,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257866',4907672,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257866',4907673,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257866',4907674,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257866',4907675,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257866',4907676,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257866',4907677,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257866',4907678,'2859','432',1162529.41,1162529.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257866',4907679,'2860','432',1038584.09,1038584.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257866',4907680,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257866',4907681,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257866',4907682,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257867',4907683,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257867',4907684,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257867',4907685,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257867',4907686,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257867',4907687,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257867',4907688,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257867',4907689,'2859','432',1162529.41,1162529.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257867',4907690,'2860','432',1038584.09,1038584.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257867',4907691,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257867',4907692,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257867',4907693,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257868',4907694,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257868',4907695,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257868',4907696,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257868',4907697,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257868',4907698,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257868',4907699,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257868',4907700,'2859','432',1162529.41,1162529.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257868',4907701,'2860','432',1038584.09,1038584.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257868',4907702,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257868',4907703,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257868',4907704,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257869',4907705,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257869',4907706,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257869',4907707,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257869',4907708,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257869',4907709,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257869',4907710,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257869',4907711,'2859','432',1162529.41,1162529.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257869',4907712,'2860','432',1038584.09,1038584.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257869',4907713,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257869',4907714,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257869',4907715,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257870',4907716,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257870',4907717,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257870',4907718,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257870',4907719,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257870',4907720,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257870',4907721,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257870',4907722,'2859','432',1162529.41,1162529.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257870',4907723,'2860','432',1038584.09,1038584.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257870',4907724,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257870',4907725,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257870',4907726,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257871',4907727,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257871',4907728,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257871',4907729,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257871',4907730,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257871',4907731,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257871',4907732,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257871',4907733,'2859','432',1162529.41,1162529.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257871',4907734,'2860','432',1038584.09,1038584.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257871',4907735,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257871',4907736,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257871',4907737,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257872',4907738,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257872',4907739,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257872',4907740,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257872',4907741,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257872',4907742,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257872',4907743,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257872',4907744,'2859','432',1162529.41,1162529.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257872',4907745,'2860','432',1038584.09,1038584.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257872',4907746,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257872',4907747,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257872',4907748,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257873',4907749,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257873',4907750,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257873',4907751,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257873',4907752,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257873',4907753,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257873',4907754,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257873',4907755,'2859','432',1162529.41,1162529.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257873',4907756,'2860','432',1038584.09,1038584.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257873',4907757,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257873',4907758,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257873',4907759,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257874',4907760,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257874',4907761,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257874',4907762,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257874',4907763,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257874',4907764,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257874',4907765,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257874',4907766,'2859','432',1162529.41,1164300.67,1771.26,389677.20,0.00,0.00,0.00,0.00,0.00),('5','105','964','257874',4907767,'2860','432',1038584.09,1041554.89,2970.80,653576.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257874',4907768,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257874',4907769,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257874',4907770,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257875',4907771,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257875',4907772,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257875',4907773,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257875',4907774,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257875',4907775,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257875',4907776,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257875',4907777,'2859','432',1164300.67,1168951.85,4651.18,1023259.60,0.00,0.00,0.00,0.00,0.00),('5','105','964','257875',4907778,'2860','432',1041554.89,1047104.12,5549.23,1220830.60,0.00,0.00,0.00,0.00,0.00),('5','105','965','257875',4907779,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257875',4907780,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257875',4907781,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257876',4907782,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257876',4907783,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257876',4907784,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257876',4907785,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257876',4907786,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257876',4907787,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257876',4907788,'2859','432',1168951.85,1170297.12,1345.27,295959.40,0.00,0.00,0.00,0.00,0.00),('5','105','964','257876',4907789,'2860','432',1047104.12,1047856.44,752.32,165510.40,0.00,0.00,0.00,0.00,0.00),('5','105','965','257876',4907790,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257876',4907791,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257876',4907792,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257877',4907793,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257877',4907794,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257877',4907795,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257877',4907796,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257877',4907797,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257877',4907798,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257877',4907799,'2859','432',1170297.12,1175010.35,4713.23,1036910.60,0.00,0.00,0.00,0.00,0.00),('5','105','964','257877',4907800,'2860','432',1047856.44,1053084.16,5227.72,1150098.40,0.00,0.00,0.00,0.00,0.00),('5','105','965','257877',4907801,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257877',4907802,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257877',4907803,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257878',4907804,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257878',4907805,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257878',4907806,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257878',4907807,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257878',4907808,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257878',4907809,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257878',4907810,'2859','432',1175010.35,1175010.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257878',4907811,'2860','432',1053084.16,1053084.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257878',4907812,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257878',4907813,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257878',4907814,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257879',4907815,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257879',4907816,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257879',4907817,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257879',4907818,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257879',4907819,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257879',4907820,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257879',4907821,'2859','432',1175010.35,1180528.14,5517.79,1158735.90,0.00,0.00,0.00,0.00,0.00),('5','105','964','257879',4907822,'2860','432',1053084.16,1058837.54,5753.38,1208209.80,0.00,0.00,0.00,0.00,0.00),('5','105','965','257879',4907823,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257879',4907824,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257879',4907825,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257880',4907826,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257880',4907827,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257880',4907828,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257880',4907829,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257880',4907830,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257880',4907831,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257880',4907832,'2859','432',1180528.14,1186151.38,5623.24,1180880.40,0.00,0.00,0.00,0.00,0.00),('5','105','964','257880',4907833,'2860','432',1058837.54,1064007.57,5170.03,1085706.30,0.00,0.00,0.00,0.00,0.00),('5','105','965','257880',4907834,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257880',4907835,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257880',4907836,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257881',4907837,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257881',4907838,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257881',4907839,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257881',4907840,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257881',4907841,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257881',4907842,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257881',4907843,'2859','432',1186151.38,1191799.21,5647.83,1186044.30,0.00,0.00,0.00,0.00,0.00),('5','105','964','257881',4907844,'2860','432',1064007.57,1070455.98,6448.41,1354166.10,0.00,0.00,0.00,0.00,0.00),('5','105','965','257881',4907845,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257881',4907846,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257881',4907847,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257882',4907848,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257882',4907849,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257882',4907850,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257882',4907851,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257882',4907852,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257882',4907853,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257882',4907854,'2859','432',1191799.21,1198661.92,6862.71,1441169.10,0.00,0.00,0.00,0.00,0.00),('5','105','964','257882',4907855,'2860','432',1070455.98,1078418.67,7962.69,1672164.90,0.00,0.00,0.00,0.00,0.00),('5','105','965','257882',4907856,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257882',4907857,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257882',4907858,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257883',4907859,'2853','432',295496.64,295496.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257883',4907860,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257883',4907861,'2855','432',315245.97,315245.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257883',4907862,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257883',4907863,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257883',4907864,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257883',4907865,'2859','432',1198661.92,1206934.25,8272.33,1737189.30,0.00,0.00,0.00,0.00,0.00),('5','105','964','257883',4907866,'2860','432',1078418.67,1086673.95,8255.28,1733608.80,0.00,0.00,0.00,0.00,0.00),('5','105','965','257883',4907867,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257883',4907868,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257883',4907869,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257884',4907870,'2853','432',295496.64,304180.43,8683.79,1823595.90,0.00,0.00,0.00,0.00,0.00),('5','105','961','257884',4907871,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257884',4907872,'2855','432',315245.97,323609.69,8363.72,1756381.20,0.00,0.00,0.00,0.00,0.00),('5','105','961','257884',4907873,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257884',4907874,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257884',4907875,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257884',4907876,'2859','432',1206934.25,1210016.68,3082.43,647310.30,0.00,0.00,0.00,0.00,0.00),('5','105','964','257884',4907877,'2860','432',1086673.95,1088834.73,2160.78,453763.80,0.00,0.00,0.00,0.00,0.00),('5','105','965','257884',4907878,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257884',4907879,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257884',4907880,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257885',4907881,'2853','432',304180.43,312554.40,8373.97,1758533.70,0.00,0.00,0.00,0.00,0.00),('5','105','961','257885',4907882,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257885',4907883,'2855','432',323609.69,333889.56,10279.87,2158772.70,0.00,0.00,0.00,0.00,0.00),('5','105','961','257885',4907884,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257885',4907885,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257885',4907886,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257885',4907887,'2859','432',1210016.68,1210016.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257885',4907888,'2860','432',1088834.73,1088834.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257885',4907889,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257885',4907890,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257885',4907891,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257886',4907892,'2853','432',312554.40,318568.43,6014.03,1262946.30,0.00,0.00,0.00,0.00,0.00),('5','105','961','257886',4907893,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257886',4907894,'2855','432',333889.56,341871.18,7981.62,1676140.20,0.00,0.00,0.00,0.00,0.00),('5','105','961','257886',4907895,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257886',4907896,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257886',4907897,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257886',4907898,'2859','432',1210016.68,1210016.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257886',4907899,'2860','432',1088834.73,1088834.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257886',4907900,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257886',4907901,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257886',4907902,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257887',4907903,'2853','432',318568.43,318568.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257887',4907904,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257887',4907905,'2855','432',341871.18,341871.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257887',4907906,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257887',4907907,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257887',4907908,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257887',4907909,'2859','432',1210016.68,1210016.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257887',4907910,'2860','432',1088834.73,1088834.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257887',4907911,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257887',4907912,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257887',4907913,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257888',4907914,'2853','432',318568.43,318568.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257888',4907915,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257888',4907916,'2855','432',341871.18,341871.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257888',4907917,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257888',4907918,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257888',4907919,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257888',4907920,'2859','432',1210016.68,1210016.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257888',4907921,'2860','432',1088834.73,1088834.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257888',4907922,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257888',4907923,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257888',4907924,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257889',4907925,'2853','432',318568.43,318568.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257889',4907926,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257889',4907927,'2855','432',341871.18,341871.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257889',4907928,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257889',4907929,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257889',4907930,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257889',4907931,'2859','432',1210016.68,1210016.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257889',4907932,'2860','432',1088834.73,1088834.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257889',4907933,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257889',4907934,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257889',4907935,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257890',4907936,'2853','432',318568.43,318568.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257890',4907937,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257890',4907938,'2855','432',341871.18,341871.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257890',4907939,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257890',4907940,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257890',4907941,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257890',4907942,'2859','432',1210016.68,1210016.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257890',4907943,'2860','432',1088834.73,1088834.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257890',4907944,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257890',4907945,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257890',4907946,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257891',4907947,'2853','432',318568.43,318568.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257891',4907948,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257891',4907949,'2855','432',341871.18,341871.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257891',4907950,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257891',4907951,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257891',4907952,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257891',4907953,'2859','432',1210016.68,1210016.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257891',4907954,'2860','432',1088834.73,1088834.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257891',4907955,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257891',4907956,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257891',4907957,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257892',4907958,'2853','432',318568.43,318568.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257892',4907959,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257892',4907960,'2855','432',341871.18,341871.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257892',4907961,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257892',4907962,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257892',4907963,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257892',4907964,'2859','432',1210016.68,1210016.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257892',4907965,'2860','432',1088834.73,1088834.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257892',4907966,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257892',4907967,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257892',4907968,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257893',4907969,'2853','432',318568.43,318568.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257893',4907970,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257893',4907971,'2855','432',341871.18,341871.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257893',4907972,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257893',4907973,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257893',4907974,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257893',4907975,'2859','432',1210016.68,1210016.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257893',4907976,'2860','432',1088834.73,1088834.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257893',4907977,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257893',4907978,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257893',4907979,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257894',4907980,'2853','432',318568.43,318568.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257894',4907981,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257894',4907982,'2855','432',341871.18,341871.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257894',4907983,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257894',4907984,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257894',4907985,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257894',4907986,'2859','432',1210016.68,1210016.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257894',4907987,'2860','432',1088834.73,1088834.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257894',4907988,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257894',4907989,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257894',4907990,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257895',4907991,'2853','432',318568.43,318568.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257895',4907992,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257895',4907993,'2855','432',341871.18,341871.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257895',4907994,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257895',4907995,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257895',4907996,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257895',4907997,'2859','432',1210016.68,1210016.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257895',4907998,'2860','432',1088834.73,1088834.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257895',4907999,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257895',4908000,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257895',4908001,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257896',4908002,'2853','432',318568.43,318568.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257896',4908003,'2854','432',67599.41,67599.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','962','257896',4908004,'2855','432',341871.18,341871.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','961','257896',4908005,'2856','432',79215.37,79215.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257896',4908006,'2857','432',134343.81,134343.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','963','257896',4908007,'2858','432',128680.18,128680.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257896',4908008,'2859','432',1210016.68,1210016.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','964','257896',4908009,'2860','432',1088834.73,1088834.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257896',4908010,'2861','433',65655.11,65655.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','966','257896',4908011,'2862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','105','965','257896',4908012,'2880','433',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=730854 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('5','105','213016','432',165.00,165.00,10062.35,0.00,0.00,0.00,0.00,614103),('5','105','213016','433',295.00,290.00,613.12,0.00,0.00,0.00,0.00,614104),('5','105','213016','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614105),('5','105','213055','432',165.00,165.00,14420.75,0.00,0.00,0.00,0.00,614205),('5','105','213055','433',295.00,290.00,729.56,0.00,0.00,0.00,0.00,614206),('5','105','213055','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614207),('5','105','213303','432',165.00,165.00,13639.14,0.00,0.00,0.00,0.00,614841),('5','105','213303','433',295.00,290.00,748.70,0.00,0.00,0.00,0.00,614842),('5','105','213303','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614843),('5','105','213308','432',165.00,165.00,13762.29,0.00,0.00,0.00,0.00,614854),('5','105','213308','433',295.00,290.00,724.38,0.00,0.00,0.00,0.00,614855),('5','105','213308','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614856),('5','105','213311','432',165.00,165.00,13665.13,0.00,0.00,0.00,0.00,614863),('5','105','213311','433',295.00,290.00,789.34,0.00,0.00,0.00,0.00,614864),('5','105','213311','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614865),('5','105','213313','432',165.00,165.00,13134.74,0.00,0.00,0.00,0.00,614869),('5','105','213313','433',295.00,290.00,1226.95,0.00,0.00,0.00,0.00,614870),('5','105','213313','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614871),('5','105','213318','432',165.00,165.00,13524.84,0.00,0.00,0.00,0.00,614884),('5','105','213318','433',295.00,295.00,642.04,0.00,0.00,0.00,0.00,614885),('5','105','213318','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614886),('5','105','213325','432',165.00,165.00,12269.86,0.00,0.00,0.00,0.00,614900),('5','105','213325','433',295.00,295.00,1137.41,0.00,0.00,0.00,0.00,614901),('5','105','213325','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614902),('5','105','213330','432',165.00,165.00,13695.79,0.00,0.00,0.00,0.00,614914),('5','105','213330','433',295.00,295.00,623.70,0.00,0.00,0.00,0.00,614915),('5','105','213330','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614916),('5','105','213332','432',165.00,165.00,14266.38,0.00,0.00,0.00,0.00,614920),('5','105','213332','433',295.00,295.00,1113.47,0.00,0.00,0.00,0.00,614921),('5','105','213332','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614922),('5','105','213487','432',165.00,165.00,16554.78,0.00,0.00,0.00,0.00,615321),('5','105','213487','433',295.00,295.00,532.95,0.00,0.00,0.00,0.00,615322),('5','105','213487','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615323),('5','105','213504','432',165.00,165.00,14490.23,0.00,0.00,0.00,0.00,615365),('5','105','213504','433',295.00,295.00,311.66,0.00,0.00,0.00,0.00,615366),('5','105','213504','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615367),('5','105','213508','432',165.00,165.00,13420.30,0.00,0.00,0.00,0.00,615377),('5','105','213508','433',295.00,295.00,326.07,0.00,0.00,0.00,0.00,615378),('5','105','213508','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615379),('5','105','213515','432',165.00,165.00,10295.41,0.00,0.00,0.00,0.00,615395),('5','105','213515','433',295.00,295.00,294.61,0.00,0.00,0.00,0.00,615396),('5','105','213515','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615397),('5','105','213527','432',165.00,165.00,12835.10,0.00,0.00,0.00,0.00,615430),('5','105','213527','433',295.00,295.00,595.62,0.00,0.00,0.00,0.00,615431),('5','105','213527','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615432),('5','105','213532','432',165.00,165.00,14142.54,0.00,0.00,0.00,0.00,615445),('5','105','213532','433',295.00,295.00,815.33,0.00,0.00,0.00,0.00,615446),('5','105','213532','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615447),('5','105','213538','432',165.00,165.00,12535.98,0.00,0.00,0.00,0.00,615463),('5','105','213538','433',295.00,295.00,679.11,0.00,0.00,0.00,0.00,615464),('5','105','213538','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615465),('5','105','213555','432',165.00,165.00,9007.06,0.00,0.00,0.00,0.00,615509),('5','105','213555','433',295.00,295.00,824.83,0.00,0.00,0.00,0.00,615510),('5','105','213555','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615511),('5','105','213558','432',165.00,165.00,10977.86,0.00,0.00,0.00,0.00,615517),('5','105','213558','433',295.00,295.00,529.43,0.00,0.00,0.00,0.00,615518),('5','105','213558','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615519),('5','105','213569','432',165.00,165.00,11242.17,0.00,0.00,0.00,0.00,615550),('5','105','213569','433',295.00,295.00,507.74,0.00,0.00,0.00,0.00,615551),('5','105','213569','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615552),('5','105','213629','432',165.00,165.00,11960.39,0.00,0.00,0.00,0.00,615705),('5','105','213629','433',295.00,295.00,0.00,0.00,0.00,0.00,0.00,615706),('5','105','213629','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615707),('5','105','213957','432',165.00,165.00,11869.30,0.00,0.00,0.00,0.00,616559),('5','105','213957','433',295.00,295.00,409.52,0.00,0.00,0.00,0.00,616560),('5','105','213957','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,616561),('5','105','214424','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,617772),('5','105','214424','433',295.00,295.00,0.00,0.00,0.00,0.00,0.00,617773),('5','105','214424','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,617774),('5','105','214902','432',165.00,165.00,11689.22,0.00,0.00,0.00,0.00,619015),('5','105','214902','433',295.00,295.00,519.40,0.00,0.00,0.00,0.00,619016),('5','105','214902','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,619017),('5','105','216103','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,622110),('5','105','216103','433',295.00,295.00,0.00,0.00,0.00,0.00,0.00,622111),('5','105','216103','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,622112),('5','105','216225','432',165.00,165.00,12322.93,0.00,0.00,0.00,0.00,622425),('5','105','216225','433',295.00,295.00,412.33,0.00,0.00,0.00,0.00,622426),('5','105','216225','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,622427),('5','105','216253','432',165.00,165.00,12275.14,0.00,0.00,0.00,0.00,622503),('5','105','216253','433',295.00,295.00,485.96,0.00,0.00,0.00,0.00,622504),('5','105','216253','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,622505),('5','105','216271','432',165.00,165.00,12116.82,0.00,0.00,0.00,0.00,622552),('5','105','216271','433',295.00,295.00,777.78,0.00,0.00,0.00,0.00,622553),('5','105','216271','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,622554),('5','105','216277','432',165.00,165.00,11994.56,0.00,0.00,0.00,0.00,622569),('5','105','216277','433',295.00,295.00,465.19,0.00,0.00,0.00,0.00,622570),('5','105','216277','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,622571),('5','105','216289','432',165.00,165.00,11683.67,0.00,0.00,0.00,0.00,622603),('5','105','216289','433',295.00,295.00,492.21,0.00,0.00,0.00,0.00,622604),('5','105','216289','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,622605),('5','105','216507','432',165.00,165.00,12396.84,0.00,0.00,0.00,0.00,623178),('5','105','216507','433',295.00,295.00,582.51,0.00,0.00,0.00,0.00,623179),('5','105','216507','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,623180),('5','105','216512','432',165.00,165.00,11177.86,0.00,0.00,0.00,0.00,623192),('5','105','216512','433',295.00,295.00,677.88,0.00,0.00,0.00,0.00,623193),('5','105','216512','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,623194),('5','105','216532','432',165.00,165.00,12077.56,0.00,0.00,0.00,0.00,623249),('5','105','216532','433',295.00,295.00,540.33,0.00,0.00,0.00,0.00,623250),('5','105','216532','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,623251),('5','105','216718','432',165.00,165.00,11417.55,0.00,0.00,0.00,0.00,623731),('5','105','216718','433',295.00,295.00,543.42,0.00,0.00,0.00,0.00,623732),('5','105','216718','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,623733),('5','105','216720','432',165.00,165.00,12056.51,0.00,0.00,0.00,0.00,623737),('5','105','216720','433',295.00,295.00,604.10,0.00,0.00,0.00,0.00,623738),('5','105','216720','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,623739),('5','105','216724','432',165.00,165.00,10720.73,0.00,0.00,0.00,0.00,623748),('5','105','216724','433',295.00,295.00,650.52,0.00,0.00,0.00,0.00,623749),('5','105','216724','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,623750),('5','105','216880','432',165.00,165.00,11152.89,0.00,0.00,0.00,0.00,624146),('5','105','216880','433',295.00,295.00,443.87,0.00,0.00,0.00,0.00,624147),('5','105','216880','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,624148),('5','105','217084','432',165.00,165.00,11609.73,0.00,0.00,0.00,0.00,624677),('5','105','217084','433',295.00,295.00,426.82,0.00,0.00,0.00,0.00,624678),('5','105','217084','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,624679),('5','105','217921','432',165.00,165.00,11858.38,0.00,0.00,0.00,0.00,626887),('5','105','217921','433',295.00,295.00,420.89,0.00,0.00,0.00,0.00,626888),('5','105','217921','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,626889),('5','105','217926','432',165.00,165.00,11419.61,0.00,0.00,0.00,0.00,626901),('5','105','217926','433',295.00,295.00,396.48,0.00,0.00,0.00,0.00,626902),('5','105','217926','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,626903),('5','105','218035','432',165.00,165.00,11007.73,0.00,0.00,0.00,0.00,627169),('5','105','218035','433',295.00,295.00,626.98,0.00,0.00,0.00,0.00,627170),('5','105','218035','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,627171),('5','105','218078','432',165.00,165.00,11056.87,0.00,0.00,0.00,0.00,627287),('5','105','218078','433',295.00,295.00,537.08,0.00,0.00,0.00,0.00,627288),('5','105','218078','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,627289),('5','105','218305','432',165.00,165.00,11318.74,0.00,0.00,0.00,0.00,627887),('5','105','218305','433',295.00,295.00,359.50,0.00,0.00,0.00,0.00,627888),('5','105','218305','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,627889),('5','105','218548','432',165.00,165.00,11447.34,0.00,0.00,0.00,0.00,628519),('5','105','218548','433',295.00,295.00,471.12,0.00,0.00,0.00,0.00,628520),('5','105','218548','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,628521),('5','105','218725','432',165.00,165.00,12047.92,0.00,0.00,0.00,0.00,628969),('5','105','218725','433',295.00,295.00,504.96,0.00,0.00,0.00,0.00,628970),('5','105','218725','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,628971),('5','105','219106','432',165.00,165.00,10979.86,0.00,0.00,0.00,0.00,629985),('5','105','219106','433',295.00,295.00,635.25,0.00,0.00,0.00,0.00,629986),('5','105','219106','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,629987),('5','105','219213','432',165.00,165.00,12027.50,0.00,0.00,0.00,0.00,630258),('5','105','219213','433',295.00,295.00,404.73,0.00,0.00,0.00,0.00,630259),('5','105','219213','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,630260),('5','105','219461','432',165.00,165.00,11915.79,0.00,0.00,0.00,0.00,630905),('5','105','219461','433',295.00,295.00,696.63,0.00,0.00,0.00,0.00,630906),('5','105','219461','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,630907),('5','105','219754','432',165.00,165.00,11385.82,0.00,0.00,0.00,0.00,631693),('5','105','219754','433',295.00,295.00,285.28,0.00,0.00,0.00,0.00,631694),('5','105','219754','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,631695),('5','105','219904','432',165.00,165.00,10199.35,0.00,0.00,0.00,0.00,632074),('5','105','219904','433',295.00,295.00,432.95,0.00,0.00,0.00,0.00,632075),('5','105','219904','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,632076),('5','105','220040','432',165.00,165.00,10709.05,0.00,0.00,0.00,0.00,632438),('5','105','220040','433',295.00,295.00,317.86,0.00,0.00,0.00,0.00,632439),('5','105','220040','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,632440),('5','105','220362','432',165.00,165.00,11648.97,0.00,0.00,0.00,0.00,633286),('5','105','220362','433',295.00,295.00,377.57,0.00,0.00,0.00,0.00,633287),('5','105','220362','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,633288),('5','105','220575','432',165.00,165.00,9072.21,0.00,0.00,0.00,0.00,633845),('5','105','220575','433',295.00,295.00,446.51,0.00,0.00,0.00,0.00,633846),('5','105','220575','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,633847),('5','105','220893','432',165.00,165.00,11209.06,0.00,0.00,0.00,0.00,634676),('5','105','220893','433',295.00,295.00,464.08,0.00,0.00,0.00,0.00,634677),('5','105','220893','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,634678),('5','105','220988','432',165.00,165.00,10382.37,0.00,0.00,0.00,0.00,634917),('5','105','220988','433',295.00,295.00,176.52,0.00,0.00,0.00,0.00,634918),('5','105','220988','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,634919),('5','105','221278','432',165.00,165.00,11107.86,0.00,0.00,0.00,0.00,635670),('5','105','221278','433',295.00,295.00,0.00,0.00,0.00,0.00,0.00,635671),('5','105','221278','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,635672),('5','105','221607','432',165.00,165.00,11867.96,0.00,0.00,0.00,0.00,636535),('5','105','221607','433',295.00,295.00,410.53,0.00,0.00,0.00,0.00,636536),('5','105','221607','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,636537),('5','105','221716','432',165.00,165.00,11764.43,0.00,0.00,0.00,0.00,636813),('5','105','221716','433',295.00,295.00,535.03,0.00,0.00,0.00,0.00,636814),('5','105','221716','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,636815),('5','105','222003','432',165.00,165.00,10882.94,0.00,0.00,0.00,0.00,637562),('5','105','222003','433',295.00,295.00,327.75,0.00,0.00,0.00,0.00,637563),('5','105','222003','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,637564),('5','105','222296','432',165.00,165.00,11554.71,0.00,0.00,0.00,0.00,638301),('5','105','222296','433',295.00,295.00,375.12,0.00,0.00,0.00,0.00,638302),('5','105','222296','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,638303),('5','105','222435','432',165.00,165.00,11177.74,0.00,0.00,0.00,0.00,638674),('5','105','222435','433',295.00,295.00,228.45,0.00,0.00,0.00,0.00,638675),('5','105','222435','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,638676),('5','105','222585','432',165.00,165.00,10502.68,0.00,0.00,0.00,0.00,639056),('5','105','222585','433',295.00,295.00,428.05,0.00,0.00,0.00,0.00,639057),('5','105','222585','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,639058),('5','105','222888','432',165.00,165.00,7800.79,0.00,0.00,0.00,0.00,639871),('5','105','222888','433',295.00,295.00,259.01,0.00,0.00,0.00,0.00,639872),('5','105','222888','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,639873),('5','105','223013','432',165.00,165.00,5559.16,0.00,0.00,0.00,0.00,640200),('5','105','223013','433',295.00,295.00,354.98,0.00,0.00,0.00,0.00,640201),('5','105','223013','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,640202),('5','105','223305','432',165.00,165.00,8884.05,0.00,0.00,0.00,0.00,640924),('5','105','223305','433',295.00,295.00,483.17,0.00,0.00,0.00,0.00,640925),('5','105','223305','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,640926),('5','105','223637','432',165.00,165.00,10747.03,0.00,0.00,0.00,0.00,641772),('5','105','223637','433',295.00,295.00,352.51,0.00,0.00,0.00,0.00,641773),('5','105','223637','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,641774),('5','105','223684','432',165.00,165.00,9947.67,0.00,0.00,0.00,0.00,641880),('5','105','223684','433',295.00,295.00,443.68,0.00,0.00,0.00,0.00,641881),('5','105','223684','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,641882),('5','105','224124','432',165.00,165.00,8381.52,0.00,0.00,0.00,0.00,643023),('5','105','224124','433',295.00,295.00,273.32,0.00,0.00,0.00,0.00,643024),('5','105','224124','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,643025),('5','105','224288','432',165.00,165.00,1131.82,0.00,0.00,0.00,0.00,643465),('5','105','224288','433',295.00,295.00,280.11,0.00,0.00,0.00,0.00,643466),('5','105','224288','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,643467),('5','105','224372','432',165.00,165.00,9630.04,0.00,0.00,0.00,0.00,643663),('5','105','224372','433',295.00,295.00,333.67,0.00,0.00,0.00,0.00,643664),('5','105','224372','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,643665),('5','105','224622','432',165.00,165.00,6127.74,0.00,0.00,0.00,0.00,644328),('5','105','224622','433',295.00,295.00,379.93,0.00,0.00,0.00,0.00,644329),('5','105','224622','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,644330),('5','105','224855','432',165.00,163.00,9828.24,0.00,0.00,0.00,0.00,644921),('5','105','224855','433',295.00,295.00,431.96,0.00,0.00,0.00,0.00,644922),('5','105','224855','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,644923),('5','105','225077','432',165.00,163.00,9857.54,0.00,0.00,0.00,0.00,645488),('5','105','225077','433',295.00,295.00,485.61,0.00,0.00,0.00,0.00,645489),('5','105','225077','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,645490),('5','105','225726','432',163.00,163.00,10832.49,0.00,0.00,0.00,0.00,647164),('5','105','225726','433',295.00,295.00,317.39,0.00,0.00,0.00,0.00,647165),('5','105','225726','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647166),('5','105','225773','432',163.00,163.00,10876.63,0.00,0.00,0.00,0.00,647299),('5','105','225773','433',295.00,295.00,0.00,0.00,0.00,0.00,0.00,647300),('5','105','225773','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647301),('5','105','225786','432',163.00,163.00,10617.41,0.00,0.00,0.00,0.00,647333),('5','105','225786','433',295.00,295.00,0.00,0.00,0.00,0.00,0.00,647334),('5','105','225786','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647335),('5','105','226057','432',163.00,163.00,9526.09,0.00,0.00,0.00,0.00,648035),('5','105','226057','433',295.00,295.00,0.00,0.00,0.00,0.00,0.00,648036),('5','105','226057','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,648037),('5','105','226328','432',163.00,163.00,9499.59,0.00,0.00,0.00,0.00,648741),('5','105','226328','433',295.00,295.00,0.00,0.00,0.00,0.00,0.00,648742),('5','105','226328','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,648743),('5','105','226561','432',163.00,163.00,9575.38,0.00,0.00,0.00,0.00,649325),('5','105','226561','433',295.00,295.00,0.00,0.00,0.00,0.00,0.00,649326),('5','105','226561','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,649327),('5','105','226782','432',163.00,163.00,10191.42,0.00,0.00,0.00,0.00,649897),('5','105','226782','433',295.00,295.00,0.00,0.00,0.00,0.00,0.00,649898),('5','105','226782','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,649899),('5','105','227207','432',163.00,163.00,10365.46,0.00,0.00,0.00,0.00,651009),('5','105','227207','433',295.00,295.00,0.00,0.00,0.00,0.00,0.00,651010),('5','105','227207','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,651011),('5','105','227456','432',163.00,163.00,10962.06,0.00,0.00,0.00,0.00,651649),('5','105','227456','433',295.00,295.00,0.00,0.00,0.00,0.00,0.00,651650),('5','105','227456','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,651651),('5','105','227577','432',163.00,163.00,10591.82,0.00,0.00,0.00,0.00,651980),('5','105','227577','433',295.00,295.00,0.00,0.00,0.00,0.00,0.00,651981),('5','105','227577','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,651982),('5','105','227776','432',163.00,163.00,9740.99,0.00,0.00,0.00,0.00,652485),('5','105','227776','433',295.00,300.00,0.00,0.00,0.00,0.00,0.00,652486),('5','105','227776','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,652487),('5','105','227935','432',163.00,163.00,9552.90,0.00,0.00,0.00,0.00,652888),('5','105','227935','433',295.00,300.00,0.00,0.00,0.00,0.00,0.00,652889),('5','105','227935','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,652890),('5','105','229384','432',163.00,163.00,9911.71,0.00,0.00,0.00,0.00,656652),('5','105','229384','433',295.00,300.00,0.00,0.00,0.00,0.00,0.00,656653),('5','105','229384','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,656654),('5','105','229761','432',163.00,163.00,0.00,0.00,0.00,0.00,0.00,657600),('5','105','229761','433',295.00,300.00,0.00,0.00,0.00,0.00,0.00,657601),('5','105','229761','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,657602),('5','105','229764','432',163.00,163.00,0.00,0.00,0.00,0.00,0.00,657607),('5','105','229764','433',295.00,300.00,0.00,0.00,0.00,0.00,0.00,657608),('5','105','229764','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,657609),('5','105','229825','432',163.00,163.00,9813.91,0.00,0.00,0.00,0.00,657780),('5','105','229825','433',295.00,300.00,0.00,0.00,0.00,0.00,0.00,657781),('5','105','229825','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,657782),('5','105','229848','432',163.00,163.00,2650.23,0.00,0.00,0.00,0.00,657841),('5','105','229848','433',295.00,300.00,0.00,0.00,0.00,0.00,0.00,657842),('5','105','229848','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,657843),('5','105','230171','432',163.00,163.00,8959.73,0.00,0.00,0.00,0.00,658665),('5','105','230171','433',295.00,300.00,0.00,0.00,0.00,0.00,0.00,658666),('5','105','230171','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,658667),('5','105','230173','432',163.00,163.00,9734.35,0.00,0.00,0.00,0.00,658670),('5','105','230173','433',295.00,300.00,0.00,0.00,0.00,0.00,0.00,658671),('5','105','230173','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,658672),('5','105','230174','432',163.00,163.00,10396.99,0.00,0.00,0.00,0.00,658673),('5','105','230174','433',295.00,300.00,0.00,0.00,0.00,0.00,0.00,658674),('5','105','230174','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,658675),('5','105','230177','432',163.00,163.00,9774.15,0.00,0.00,0.00,0.00,658680),('5','105','230177','433',295.00,295.00,0.00,0.00,0.00,0.00,0.00,658681),('5','105','230177','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,658682),('5','105','230178','432',163.00,163.00,4906.97,0.00,0.00,0.00,0.00,658683),('5','105','230178','433',295.00,295.00,0.00,0.00,0.00,0.00,0.00,658684),('5','105','230178','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,658685),('5','105','230180','432',163.00,163.00,1027.57,0.00,0.00,0.00,0.00,658689),('5','105','230180','433',295.00,295.00,0.00,0.00,0.00,0.00,0.00,658690),('5','105','230180','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,658691),('5','105','230181','432',163.00,163.00,0.00,0.00,0.00,0.00,0.00,658692),('5','105','230181','433',295.00,295.00,0.00,0.00,0.00,0.00,0.00,658693),('5','105','230181','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,658694),('5','105','230716','432',163.00,163.00,10092.84,0.00,0.00,0.00,0.00,660094),('5','105','230716','433',295.00,310.00,0.00,0.00,0.00,0.00,0.00,660095),('5','105','230716','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,660096),('5','105','230722','432',163.00,163.00,8722.18,0.00,0.00,0.00,0.00,660109),('5','105','230722','433',295.00,310.00,0.00,0.00,0.00,0.00,0.00,660110),('5','105','230722','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,660111),('5','105','231010','432',163.00,163.00,8844.21,0.00,0.00,0.00,0.00,660861),('5','105','231010','433',320.00,320.00,0.00,0.00,0.00,0.00,0.00,660862),('5','105','231010','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,660863),('5','105','231121','432',163.00,163.00,7388.79,0.00,0.00,0.00,0.00,661143),('5','105','231121','433',320.00,320.00,0.00,0.00,0.00,0.00,0.00,661144),('5','105','231121','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661145),('5','105','231606','432',163.00,163.00,10525.79,0.00,0.00,0.00,0.00,662447),('5','105','231606','433',320.00,320.00,0.00,0.00,0.00,0.00,0.00,662448),('5','105','231606','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,662449),('5','105','231776','432',163.00,163.00,8977.42,0.00,0.00,0.00,0.00,662893),('5','105','231776','433',320.00,320.00,0.00,0.00,0.00,0.00,0.00,662894),('5','105','231776','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,662895),('5','105','232003','432',163.00,163.00,9090.05,0.00,0.00,0.00,0.00,663505),('5','105','232003','433',320.00,320.00,0.00,0.00,0.00,0.00,0.00,663506),('5','105','232003','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,663507),('5','105','232289','432',163.00,163.00,9378.14,0.00,0.00,0.00,0.00,664253),('5','105','232289','433',327.00,327.00,0.00,0.00,0.00,0.00,0.00,664254),('5','105','232289','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,664255),('5','105','232452','432',163.00,163.00,6848.24,0.00,0.00,0.00,0.00,664671),('5','105','232452','433',327.00,327.00,0.00,0.00,0.00,0.00,0.00,664672),('5','105','232452','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,664673),('5','105','232763','432',163.00,163.00,9700.28,0.00,0.00,0.00,0.00,665497),('5','105','232763','433',327.00,327.00,0.00,0.00,0.00,0.00,0.00,665498),('5','105','232763','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,665499),('5','105','233321','432',163.00,163.00,8625.38,0.00,0.00,0.00,0.00,666968),('5','105','233321','433',330.00,330.00,286.46,0.00,0.00,0.00,0.00,666969),('5','105','233321','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,666970),('5','105','233336','432',163.00,163.00,9074.38,0.00,0.00,0.00,0.00,667009),('5','105','233336','433',330.00,345.00,188.90,0.00,0.00,0.00,0.00,667010),('5','105','233336','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,667011),('5','105','233629','432',163.00,163.00,2632.99,0.00,0.00,0.00,0.00,667755),('5','105','233629','433',345.00,345.00,111.46,0.00,0.00,0.00,0.00,667756),('5','105','233629','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,667757),('5','105','234184','432',163.00,163.00,0.00,0.00,0.00,0.00,0.00,669226),('5','105','234184','433',345.00,345.00,409.53,0.00,0.00,0.00,0.00,669227),('5','105','234184','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,669228),('5','105','234201','432',163.00,163.00,0.00,0.00,0.00,0.00,0.00,669276),('5','105','234201','433',345.00,345.00,148.05,0.00,0.00,0.00,0.00,669277),('5','105','234201','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,669278),('5','105','234484','432',163.00,163.00,0.00,0.00,0.00,0.00,0.00,670034),('5','105','234484','433',345.00,345.00,151.85,0.00,0.00,0.00,0.00,670035),('5','105','234484','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,670036),('5','105','234801','432',163.00,163.00,0.00,0.00,0.00,0.00,0.00,670879),('5','105','234801','433',345.00,345.00,122.65,0.00,0.00,0.00,0.00,670880),('5','105','234801','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,670881),('5','105','234917','432',163.00,163.00,0.00,0.00,0.00,0.00,0.00,671172),('5','105','234917','433',345.00,345.00,104.56,0.00,0.00,0.00,0.00,671173),('5','105','234917','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,671174),('5','105','234995','432',163.00,163.00,0.00,0.00,0.00,0.00,0.00,671400),('5','105','234995','433',345.00,345.00,89.30,0.00,0.00,0.00,0.00,671401),('5','105','234995','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,671402),('5','105','235611','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,672979),('5','105','235611','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,672980),('5','105','235611','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,672981),('5','105','235618','432',165.00,165.00,8505.02,0.00,0.00,0.00,0.00,672998),('5','105','235618','433',345.00,345.00,105.14,0.00,0.00,0.00,0.00,672999),('5','105','235618','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,673000),('5','105','235951','432',165.00,165.00,8634.06,0.00,0.00,0.00,0.00,673884),('5','105','235951','433',345.00,345.00,113.17,0.00,0.00,0.00,0.00,673885),('5','105','235951','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,673886),('5','105','235954','432',165.00,165.00,996.76,0.00,0.00,0.00,0.00,673893),('5','105','235954','433',345.00,345.00,190.59,0.00,0.00,0.00,0.00,673894),('5','105','235954','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,673895),('5','105','236195','432',165.00,165.00,8582.04,0.00,0.00,0.00,0.00,674525),('5','105','236195','433',345.00,345.00,163.75,0.00,0.00,0.00,0.00,674526),('5','105','236195','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,674527),('5','105','236539','432',165.00,165.00,6214.19,0.00,0.00,0.00,0.00,675416),('5','105','236539','433',345.00,345.00,58.67,0.00,0.00,0.00,0.00,675417),('5','105','236539','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,675418),('5','105','236606','432',165.00,165.00,10118.56,0.00,0.00,0.00,0.00,675597),('5','105','236606','433',345.00,345.00,274.55,0.00,0.00,0.00,0.00,675598),('5','105','236606','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,675599),('5','105','237053','432',165.00,165.00,10298.62,0.00,0.00,0.00,0.00,676748),('5','105','237053','433',345.00,345.00,218.36,0.00,0.00,0.00,0.00,676749),('5','105','237053','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,676750),('5','105','237224','432',165.00,165.00,6189.35,0.00,0.00,0.00,0.00,677187),('5','105','237224','433',345.00,345.00,123.80,0.00,0.00,0.00,0.00,677188),('5','105','237224','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,677189),('5','105','237549','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,678042),('5','105','237549','433',345.00,345.00,223.12,0.00,0.00,0.00,0.00,678043),('5','105','237549','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,678044),('5','105','237792','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,678674),('5','105','237792','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,678675),('5','105','237792','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,678676),('5','105','238028','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,679279),('5','105','238028','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,679280),('5','105','238028','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,679281),('5','105','238051','432',165.00,165.00,10965.21,0.00,0.00,0.00,0.00,679342),('5','105','238051','433',345.00,345.00,323.94,0.00,0.00,0.00,0.00,679343),('5','105','238051','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,679344),('5','105','238225','432',165.00,165.00,9428.46,0.00,0.00,0.00,0.00,679782),('5','105','238225','433',345.00,345.00,244.70,0.00,0.00,0.00,0.00,679783),('5','105','238225','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,679784),('5','105','238417','432',165.00,165.00,10003.19,0.00,0.00,0.00,0.00,680274),('5','105','238417','433',345.00,345.00,292.90,0.00,0.00,0.00,0.00,680275),('5','105','238417','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,680276),('5','105','239163','432',165.00,165.00,11150.55,0.00,0.00,0.00,0.00,682223),('5','105','239163','433',345.00,345.00,688.48,0.00,0.00,0.00,0.00,682224),('5','105','239163','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,682225),('5','105','239212','432',165.00,165.00,12665.44,0.00,0.00,0.00,0.00,682357),('5','105','239212','433',345.00,345.00,1179.12,0.00,0.00,0.00,0.00,682358),('5','105','239212','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,682359),('5','105','239355','432',165.00,165.00,11164.33,0.00,0.00,0.00,0.00,682715),('5','105','239355','433',345.00,345.00,1392.76,0.00,0.00,0.00,0.00,682716),('5','105','239355','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,682717),('5','105','239492','432',165.00,165.00,13605.85,0.00,0.00,0.00,0.00,683089),('5','105','239492','433',345.00,345.00,867.03,0.00,0.00,0.00,0.00,683090),('5','105','239492','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,683091),('5','105','239669','432',165.00,165.00,10416.85,0.00,0.00,0.00,0.00,683545),('5','105','239669','433',345.00,345.00,631.90,0.00,0.00,0.00,0.00,683546),('5','105','239669','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,683547),('5','105','239856','432',165.00,165.00,9521.55,0.00,0.00,0.00,0.00,684026),('5','105','239856','433',345.00,345.00,451.58,0.00,0.00,0.00,0.00,684027),('5','105','239856','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,684028),('5','105','240406','432',165.00,165.00,10316.92,0.00,0.00,0.00,0.00,685463),('5','105','240406','433',345.00,345.00,318.36,0.00,0.00,0.00,0.00,685464),('5','105','240406','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,685465),('5','105','240599','432',165.00,165.00,11530.91,0.00,0.00,0.00,0.00,685958),('5','105','240599','433',345.00,345.00,456.51,0.00,0.00,0.00,0.00,685959),('5','105','240599','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,685960),('5','105','240603','432',165.00,165.00,11492.60,0.00,0.00,0.00,0.00,685970),('5','105','240603','433',345.00,345.00,536.59,0.00,0.00,0.00,0.00,685971),('5','105','240603','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,685972),('5','105','240787','432',165.00,165.00,9794.19,0.00,0.00,0.00,0.00,686394),('5','105','240787','433',345.00,345.00,608.51,0.00,0.00,0.00,0.00,686395),('5','105','240787','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,686396),('5','105','241071','432',165.00,165.00,8331.75,0.00,0.00,0.00,0.00,687163),('5','105','241071','433',345.00,345.00,1194.67,0.00,0.00,0.00,0.00,687164),('5','105','241071','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,687165),('5','105','241416','432',165.00,165.00,5014.82,0.00,0.00,0.00,0.00,688086),('5','105','241416','433',345.00,345.00,180.86,0.00,0.00,0.00,0.00,688087),('5','105','241416','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,688088),('5','105','241863','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,689249),('5','105','241863','433',345.00,345.00,415.73,0.00,0.00,0.00,0.00,689250),('5','105','241863','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,689251),('5','105','242088','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,689829),('5','105','242088','433',345.00,345.00,525.92,0.00,0.00,0.00,0.00,689830),('5','105','242088','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,689831),('5','105','242131','432',165.00,165.00,9018.33,0.00,0.00,0.00,0.00,689950),('5','105','242131','433',345.00,345.00,562.21,0.00,0.00,0.00,0.00,689951),('5','105','242131','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,689952),('5','105','242373','432',165.00,165.00,10031.50,0.00,0.00,0.00,0.00,690584),('5','105','242373','433',345.00,345.00,529.43,0.00,0.00,0.00,0.00,690585),('5','105','242373','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,690586),('5','105','242534','432',165.00,165.00,9777.29,0.00,0.00,0.00,0.00,690986),('5','105','242534','433',345.00,345.00,463.30,0.00,0.00,0.00,0.00,690987),('5','105','242534','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,690988),('5','105','242838','432',165.00,165.00,9751.86,0.00,0.00,0.00,0.00,691792),('5','105','242838','433',345.00,345.00,708.01,0.00,0.00,0.00,0.00,691793),('5','105','242838','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,691794),('5','105','243083','432',165.00,165.00,6190.72,0.00,0.00,0.00,0.00,692433),('5','105','243083','433',345.00,345.00,626.87,0.00,0.00,0.00,0.00,692434),('5','105','243083','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,692435),('5','105','243283','432',165.00,165.00,11536.09,0.00,0.00,0.00,0.00,692954),('5','105','243283','433',345.00,345.00,507.61,0.00,0.00,0.00,0.00,692955),('5','105','243283','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,692956),('5','105','243648','432',165.00,165.00,12241.84,0.00,0.00,0.00,0.00,693881),('5','105','243648','433',345.00,345.00,379.66,0.00,0.00,0.00,0.00,693882),('5','105','243648','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,693883),('5','105','243789','432',165.00,165.00,13524.45,0.00,0.00,0.00,0.00,694271),('5','105','243789','433',345.00,345.00,696.51,0.00,0.00,0.00,0.00,694272),('5','105','243789','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,694273),('5','105','243953','432',165.00,165.00,12960.30,0.00,0.00,0.00,0.00,694682),('5','105','243953','433',345.00,345.00,403.95,0.00,0.00,0.00,0.00,694683),('5','105','243953','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,694684),('5','105','244191','432',165.00,165.00,4738.59,0.00,0.00,0.00,0.00,695297),('5','105','244191','433',345.00,345.00,571.57,0.00,0.00,0.00,0.00,695298),('5','105','244191','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,695299),('5','105','244477','432',165.00,165.00,11456.04,0.00,0.00,0.00,0.00,696053),('5','105','244477','433',345.00,345.00,407.52,0.00,0.00,0.00,0.00,696054),('5','105','244477','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,696055),('5','105','244769','432',165.00,165.00,12618.46,0.00,0.00,0.00,0.00,696799),('5','105','244769','433',345.00,345.00,692.64,0.00,0.00,0.00,0.00,696800),('5','105','244769','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,696801),('5','105','245051','432',165.00,165.00,6024.93,0.00,0.00,0.00,0.00,697525),('5','105','245051','433',345.00,345.00,357.75,0.00,0.00,0.00,0.00,697526),('5','105','245051','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,697527),('5','105','245119','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,697714),('5','105','245119','433',345.00,345.00,417.00,0.00,0.00,0.00,0.00,697715),('5','105','245119','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,697716),('5','105','245416','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,698488),('5','105','245416','433',345.00,345.00,336.97,0.00,0.00,0.00,0.00,698489),('5','105','245416','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,698490),('5','105','245609','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,698985),('5','105','245609','433',345.00,345.00,430.13,0.00,0.00,0.00,0.00,698986),('5','105','245609','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,698987),('5','105','245791','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699434),('5','105','245791','433',345.00,345.00,1027.96,0.00,0.00,0.00,0.00,699435),('5','105','245791','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,699436),('5','105','246167','432',165.00,165.00,7783.96,0.00,0.00,0.00,0.00,700434),('5','105','246167','433',345.00,345.00,523.84,0.00,0.00,0.00,0.00,700435),('5','105','246167','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,700436),('5','105','246550','432',165.00,165.00,11373.35,0.00,0.00,0.00,0.00,701428),('5','105','246550','433',345.00,345.00,504.96,0.00,0.00,0.00,0.00,701429),('5','105','246550','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,701430),('5','105','246655','432',165.00,165.00,9466.07,0.00,0.00,0.00,0.00,701718),('5','105','246655','433',345.00,345.00,738.56,0.00,0.00,0.00,0.00,701719),('5','105','246655','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,701720),('5','105','246947','432',165.00,165.00,4811.90,0.00,0.00,0.00,0.00,702453),('5','105','246947','433',345.00,345.00,1234.00,0.00,0.00,0.00,0.00,702454),('5','105','246947','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,702455),('5','105','247389','432',165.00,165.00,10424.40,0.00,0.00,0.00,0.00,703596),('5','105','247389','433',345.00,345.00,471.03,0.00,0.00,0.00,0.00,703597),('5','105','247389','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,703598),('5','105','247510','432',165.00,165.00,9465.89,0.00,0.00,0.00,0.00,703899),('5','105','247510','433',345.00,345.00,467.20,0.00,0.00,0.00,0.00,703900),('5','105','247510','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,703901),('5','105','247647','432',165.00,165.00,7809.93,0.00,0.00,0.00,0.00,704284),('5','105','247647','433',345.00,345.00,428.81,0.00,0.00,0.00,0.00,704285),('5','105','247647','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,704286),('5','105','247770','432',165.00,165.00,3452.22,0.00,0.00,0.00,0.00,704564),('5','105','247770','433',345.00,345.00,416.38,0.00,0.00,0.00,0.00,704565),('5','105','247770','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,704566),('5','105','248052','432',165.00,165.00,9045.30,0.00,0.00,0.00,0.00,705310),('5','105','248052','433',345.00,345.00,400.00,0.00,0.00,0.00,0.00,705311),('5','105','248052','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,705312),('5','105','248345','432',165.00,165.00,2227.14,0.00,0.00,0.00,0.00,706080),('5','105','248345','433',345.00,345.00,426.12,0.00,0.00,0.00,0.00,706081),('5','105','248345','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,706082),('5','105','248525','432',165.00,165.00,10988.96,0.00,0.00,0.00,0.00,706526),('5','105','248525','433',345.00,345.00,396.80,0.00,0.00,0.00,0.00,706527),('5','105','248525','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,706528),('5','105','248773','432',165.00,165.00,11704.42,0.00,0.00,0.00,0.00,707165),('5','105','248773','433',345.00,345.00,404.45,0.00,0.00,0.00,0.00,707166),('5','105','248773','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,707167),('5','105','249308','432',165.00,165.00,11356.88,0.00,0.00,0.00,0.00,708552),('5','105','249308','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,708553),('5','105','249308','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,708554),('5','105','249451','432',165.00,165.00,9716.24,0.00,0.00,0.00,0.00,708898),('5','105','249451','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,708899),('5','105','249451','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,708900),('5','105','249720','432',165.00,165.00,12399.42,0.00,0.00,0.00,0.00,709600),('5','105','249720','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,709601),('5','105','249720','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,709602),('5','105','250015','432',165.00,165.00,3621.13,0.00,0.00,0.00,0.00,710359),('5','105','250015','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,710360),('5','105','250015','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,710361),('5','105','250693','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,712084),('5','105','250693','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,712085),('5','105','250693','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,712086),('5','105','250729','432',165.00,165.00,2046.43,0.00,0.00,0.00,0.00,712189),('5','105','250729','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,712190),('5','105','250729','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,712191),('5','105','250731','432',165.00,165.00,8645.78,0.00,0.00,0.00,0.00,712194),('5','105','250731','433',345.00,345.00,200.00,0.00,0.00,0.00,0.00,712195),('5','105','250731','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,712196),('5','105','251195','432',165.00,165.00,9918.43,0.00,0.00,0.00,0.00,713385),('5','105','251195','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,713386),('5','105','251195','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,713387),('5','105','251717','432',165.00,165.00,8903.83,0.00,0.00,0.00,0.00,714761),('5','105','251717','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,714762),('5','105','251717','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,714763),('5','105','251932','432',165.00,165.00,10440.98,0.00,0.00,0.00,0.00,715321),('5','105','251932','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,715322),('5','105','251932','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,715323),('5','105','252148','432',165.00,165.00,12346.40,0.00,0.00,0.00,0.00,715874),('5','105','252148','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,715875),('5','105','252148','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,715876),('5','105','252905','432',165.00,165.00,12590.38,0.00,0.00,0.00,0.00,717846),('5','105','252905','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,717847),('5','105','252905','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,717848),('5','105','252937','432',165.00,165.00,9378.84,0.00,0.00,0.00,0.00,717938),('5','105','252937','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,717939),('5','105','252937','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,717940),('5','105','253170','432',165.00,165.00,8031.32,0.00,0.00,0.00,0.00,718547),('5','105','253170','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,718548),('5','105','253170','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,718549),('5','105','253206','432',165.00,165.00,1649.07,0.00,0.00,0.00,0.00,718639),('5','105','253206','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,718640),('5','105','253206','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,718641),('5','105','253307','432',165.00,165.00,2315.54,0.00,0.00,0.00,0.00,718887),('5','105','253307','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,718888),('5','105','253307','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,718889),('5','105','253312','432',165.00,165.00,12578.18,0.00,0.00,0.00,0.00,718902),('5','105','253312','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,718903),('5','105','253312','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,718904),('5','105','253315','432',165.00,165.00,12614.66,0.00,0.00,0.00,0.00,718909),('5','105','253315','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,718910),('5','105','253315','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,718911),('5','105','253321','432',165.00,165.00,10496.28,0.00,0.00,0.00,0.00,718925),('5','105','253321','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,718926),('5','105','253321','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,718927),('5','105','253574','432',165.00,165.00,2459.37,0.00,0.00,0.00,0.00,719578),('5','105','253574','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,719579),('5','105','253574','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,719580),('5','105','254022','432',165.00,165.00,2408.10,0.00,0.00,0.00,0.00,720735),('5','105','254022','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,720736),('5','105','254022','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,720737),('5','105','254182','432',165.00,165.00,9907.31,0.00,0.00,0.00,0.00,721176),('5','105','254182','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,721177),('5','105','254182','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,721178),('5','105','254333','432',165.00,165.00,9960.68,0.00,0.00,0.00,0.00,721548),('5','105','254333','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,721549),('5','105','254333','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,721550),('5','105','254811','432',165.00,165.00,9047.67,0.00,0.00,0.00,0.00,722759),('5','105','254811','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,722760),('5','105','254811','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,722761),('5','105','254903','432',165.00,165.00,1741.64,0.00,0.00,0.00,0.00,723015),('5','105','254903','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,723016),('5','105','254903','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,723017),('5','105','255455','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,724412),('5','105','255455','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,724413),('5','105','255455','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,724414),('5','105','255692','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,725000),('5','105','255692','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,725001),('5','105','255692','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,725002),('5','105','255835','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,725347),('5','105','255835','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,725348),('5','105','255835','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,725349),('5','105','255909','432',165.00,165.00,7831.82,0.00,0.00,0.00,0.00,725548),('5','105','255909','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,725549),('5','105','255909','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,725550),('5','105','256121','432',165.00,165.00,9645.57,0.00,0.00,0.00,0.00,726077),('5','105','256121','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,726078),('5','105','256121','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,726079),('5','105','256575','432',165.00,165.00,8922.86,0.00,0.00,0.00,0.00,727225),('5','105','256575','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,727226),('5','105','256575','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,727227),('5','105','256817','432',165.00,165.00,8366.22,0.00,0.00,0.00,0.00,727848),('5','105','256817','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,727849),('5','105','256817','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,727850),('5','105','256919','432',165.00,165.00,8137.21,0.00,0.00,0.00,0.00,728138),('5','105','256919','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,728139),('5','105','256919','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,728140),('5','105','257481','432',165.00,165.00,1928.36,0.00,0.00,0.00,0.00,729606),('5','105','257481','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729607),('5','105','257481','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729608),('5','105','257482','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729609),('5','105','257482','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729610),('5','105','257482','432',165.00,165.00,1294.71,0.00,0.00,0.00,0.00,729611),('5','105','257483','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729612),('5','105','257483','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729613),('5','105','257483','432',165.00,165.00,9593.64,0.00,0.00,0.00,0.00,729614),('5','105','257484','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729615),('5','105','257484','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729616),('5','105','257484','432',165.00,165.00,8772.82,0.00,0.00,0.00,0.00,729617),('5','105','257485','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729618),('5','105','257485','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729619),('5','105','257485','432',165.00,165.00,8677.26,0.00,0.00,0.00,0.00,729620),('5','105','257486','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729621),('5','105','257486','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729622),('5','105','257486','432',165.00,165.00,9050.22,0.00,0.00,0.00,0.00,729623),('5','105','257487','432',165.00,165.00,2294.97,0.00,0.00,0.00,0.00,729624),('5','105','257487','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729625),('5','105','257487','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729626),('5','105','257488','432',165.00,165.00,1879.03,0.00,0.00,0.00,0.00,729627),('5','105','257488','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729628),('5','105','257488','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729629),('5','105','257489','433',345.00,390.00,0.00,0.00,0.00,0.00,0.00,729630),('5','105','257489','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729631),('5','105','257489','432',165.00,165.00,8127.11,0.00,0.00,0.00,0.00,729632),('5','105','257490','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729633),('5','105','257490','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729634),('5','105','257490','432',165.00,165.00,9656.48,0.00,0.00,0.00,0.00,729635),('5','105','257491','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729636),('5','105','257491','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729637),('5','105','257491','432',165.00,165.00,9474.44,0.00,0.00,0.00,0.00,729638),('5','105','257492','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729639),('5','105','257492','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729640),('5','105','257492','432',165.00,165.00,8678.58,0.00,0.00,0.00,0.00,729641),('5','105','257493','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729642),('5','105','257493','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729643),('5','105','257493','432',165.00,165.00,1717.74,0.00,0.00,0.00,0.00,729644),('5','105','257494','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729645),('5','105','257494','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729646),('5','105','257494','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729647),('5','105','257495','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729648),('5','105','257495','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729649),('5','105','257495','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729650),('5','105','257496','432',165.00,165.00,2424.05,0.00,0.00,0.00,0.00,729651),('5','105','257496','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729652),('5','105','257496','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729653),('5','105','257497','432',165.00,165.00,5675.93,0.00,0.00,0.00,0.00,729654),('5','105','257497','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729655),('5','105','257497','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729656),('5','105','257498','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729657),('5','105','257498','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729658),('5','105','257498','432',165.00,165.00,5202.82,0.00,0.00,0.00,0.00,729659),('5','105','257499','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729660),('5','105','257499','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729661),('5','105','257499','432',165.00,165.00,5916.63,0.00,0.00,0.00,0.00,729662),('5','105','257500','432',165.00,165.00,2485.93,0.00,0.00,0.00,0.00,729663),('5','105','257500','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729664),('5','105','257500','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729665),('5','105','257501','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729666),('5','105','257501','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729667),('5','105','257501','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729668),('5','105','257502','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729669),('5','105','257502','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729670),('5','105','257502','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729671),('5','105','257503','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729672),('5','105','257503','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729673),('5','105','257503','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729674),('5','105','257504','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729675),('5','105','257504','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729676),('5','105','257504','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729677),('5','105','257505','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729678),('5','105','257505','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729679),('5','105','257505','432',165.00,165.00,2572.62,0.00,0.00,0.00,0.00,729680),('5','105','257506','433',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729681),('5','105','257506','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729682),('5','105','257506','432',165.00,165.00,9179.38,0.00,0.00,0.00,0.00,729683),('5','105','257507','433',415.00,415.00,299.33,0.00,0.00,0.00,0.00,729684),('5','105','257507','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729685),('5','105','257507','432',165.00,165.00,4238.80,0.00,0.00,0.00,0.00,729686),('5','105','257508','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729687),('5','105','257508','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729688),('5','105','257508','432',165.00,165.00,14483.64,0.00,0.00,0.00,0.00,729689),('5','105','257509','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729690),('5','105','257509','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729691),('5','105','257509','432',165.00,165.00,7495.00,0.00,0.00,0.00,0.00,729692),('5','105','257510','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729693),('5','105','257510','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729694),('5','105','257510','432',165.00,165.00,5084.52,0.00,0.00,0.00,0.00,729695),('5','105','257511','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729696),('5','105','257511','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729697),('5','105','257511','432',165.00,165.00,2431.41,0.00,0.00,0.00,0.00,729698),('5','105','257512','432',165.00,165.00,10471.28,0.00,0.00,0.00,0.00,729699),('5','105','257512','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729700),('5','105','257512','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729701),('5','105','257513','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729702),('5','105','257513','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729703),('5','105','257513','432',165.00,165.00,7599.12,0.00,0.00,0.00,0.00,729704),('5','105','257514','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729705),('5','105','257514','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729706),('5','105','257514','432',165.00,165.00,8078.81,0.00,0.00,0.00,0.00,729707),('5','105','257515','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729708),('5','105','257515','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729709),('5','105','257515','432',165.00,165.00,8005.86,0.00,0.00,0.00,0.00,729710),('5','105','257516','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729711),('5','105','257516','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729712),('5','105','257516','432',165.00,165.00,1700.12,0.00,0.00,0.00,0.00,729713),('5','105','257517','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729714),('5','105','257517','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729715),('5','105','257517','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729716),('5','105','257518','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729717),('5','105','257518','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729718),('5','105','257518','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729719),('5','105','257519','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729720),('5','105','257519','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729721),('5','105','257519','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729722),('5','105','257520','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729723),('5','105','257520','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729724),('5','105','257520','432',165.00,165.00,8094.09,0.00,0.00,0.00,0.00,729725),('5','105','257521','432',165.00,165.00,11787.75,0.00,0.00,0.00,0.00,729726),('5','105','257521','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729727),('5','105','257521','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729728),('5','105','257522','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729729),('5','105','257522','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729730),('5','105','257522','432',165.00,165.00,2431.45,0.00,0.00,0.00,0.00,729731),('5','105','257523','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729732),('5','105','257523','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729733),('5','105','257523','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729734),('5','105','257524','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729735),('5','105','257524','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729736),('5','105','257524','432',165.00,165.00,5044.61,0.00,0.00,0.00,0.00,729737),('5','105','257525','432',165.00,165.00,10969.59,0.00,0.00,0.00,0.00,729738),('5','105','257525','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729739),('5','105','257525','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729740),('5','105','257526','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729741),('5','105','257526','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729742),('5','105','257526','432',165.00,165.00,9023.45,0.00,0.00,0.00,0.00,729743),('5','105','257527','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729744),('5','105','257527','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729745),('5','105','257527','432',165.00,165.00,4869.75,0.00,0.00,0.00,0.00,729746),('5','105','257528','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729747),('5','105','257528','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729748),('5','105','257528','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729749),('5','105','257529','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729750),('5','105','257529','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729751),('5','105','257529','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729752),('5','105','257530','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729753),('5','105','257530','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729754),('5','105','257530','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729755),('5','105','257531','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729756),('5','105','257531','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729757),('5','105','257531','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729758),('5','105','257532','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729759),('5','105','257532','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729760),('5','105','257532','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729761),('5','105','257533','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729762),('5','105','257533','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729763),('5','105','257533','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729764),('5','105','257534','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729765),('5','105','257534','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729766),('5','105','257534','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729767),('5','105','257535','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729768),('5','105','257535','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729769),('5','105','257535','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729770),('5','105','257536','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729771),('5','105','257536','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729772),('5','105','257536','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729773),('5','105','257537','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729774),('5','105','257537','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729775),('5','105','257537','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729776),('5','105','257538','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729777),('5','105','257538','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729778),('5','105','257538','432',165.00,165.00,2908.05,0.00,0.00,0.00,0.00,729779),('5','105','257539','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729780),('5','105','257539','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729781),('5','105','257539','432',165.00,165.00,5075.14,0.00,0.00,0.00,0.00,729782),('5','105','257540','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729783),('5','105','257540','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729784),('5','105','257540','432',165.00,165.00,4512.67,0.00,0.00,0.00,0.00,729785),('5','105','257541','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729786),('5','105','257541','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729787),('5','105','257541','432',165.00,165.00,2406.83,0.00,0.00,0.00,0.00,729788),('5','105','257542','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729789),('5','105','257542','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729790),('5','105','257542','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729791),('5','105','257543','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729792),('5','105','257543','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729793),('5','105','257543','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729794),('5','105','257544','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729795),('5','105','257544','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729796),('5','105','257544','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729797),('5','105','257545','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729798),('5','105','257545','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729799),('5','105','257545','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729800),('5','105','257546','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729801),('5','105','257546','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729802),('5','105','257546','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729803),('5','105','257547','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729804),('5','105','257547','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729805),('5','105','257547','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729806),('5','105','257548','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729807),('5','105','257548','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729808),('5','105','257548','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729809),('5','105','257549','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729810),('5','105','257549','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729811),('5','105','257549','432',165.00,165.00,5173.31,0.00,0.00,0.00,0.00,729812),('5','105','257550','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729813),('5','105','257550','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729814),('5','105','257550','432',165.00,165.00,5792.54,0.00,0.00,0.00,0.00,729815),('5','105','257551','432',165.00,165.00,2337.20,0.00,0.00,0.00,0.00,729816),('5','105','257551','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729817),('5','105','257551','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729818),('5','105','257552','432',165.00,165.00,5496.35,0.00,0.00,0.00,0.00,729819),('5','105','257552','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729820),('5','105','257552','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729821),('5','105','257553','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729822),('5','105','257553','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729823),('5','105','257553','432',165.00,165.00,9502.16,0.00,0.00,0.00,0.00,729824),('5','105','257554','432',165.00,165.00,8561.89,0.00,0.00,0.00,0.00,729825),('5','105','257554','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729826),('5','105','257554','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729827),('5','105','257555','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729828),('5','105','257555','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729829),('5','105','257555','432',165.00,165.00,7245.86,0.00,0.00,0.00,0.00,729830),('5','105','257556','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729831),('5','105','257556','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729832),('5','105','257556','432',165.00,165.00,7113.03,0.00,0.00,0.00,0.00,729833),('5','105','257557','432',165.00,165.00,7028.14,0.00,0.00,0.00,0.00,729834),('5','105','257557','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729835),('5','105','257557','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729836),('5','105','257558','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729837),('5','105','257558','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729838),('5','105','257558','432',165.00,165.00,5992.91,0.00,0.00,0.00,0.00,729839),('5','105','257559','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729840),('5','105','257559','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729841),('5','105','257559','432',165.00,165.00,3412.94,0.00,0.00,0.00,0.00,729842),('5','105','257560','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729843),('5','105','257560','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729844),('5','105','257560','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729845),('5','105','257561','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729846),('5','105','257561','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729847),('5','105','257561','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729848),('5','105','257562','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729849),('5','105','257562','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729850),('5','105','257562','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729851),('5','105','257563','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729852),('5','105','257563','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729853),('5','105','257563','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729854),('5','105','257564','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729855),('5','105','257564','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729856),('5','105','257564','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729857),('5','105','257565','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729858),('5','105','257565','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729859),('5','105','257565','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729860),('5','105','257566','432',165.00,165.00,3245.21,0.00,0.00,0.00,0.00,729861),('5','105','257566','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729862),('5','105','257566','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729863),('5','105','257567','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729864),('5','105','257567','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729865),('5','105','257567','432',165.00,165.00,4660.50,0.00,0.00,0.00,0.00,729866),('5','105','257568','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729867),('5','105','257568','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729868),('5','105','257568','432',165.00,165.00,4246.35,0.00,0.00,0.00,0.00,729869),('5','105','257569','432',165.00,165.00,1452.01,0.00,0.00,0.00,0.00,729870),('5','105','257569','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729871),('5','105','257569','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729872),('5','105','257570','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729873),('5','105','257570','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729874),('5','105','257570','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729875),('5','105','257571','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729876),('5','105','257571','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729877),('5','105','257571','432',165.00,165.00,1910.12,0.00,0.00,0.00,0.00,729878),('5','105','257572','432',165.00,165.00,7512.50,0.00,0.00,0.00,0.00,729879),('5','105','257572','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729880),('5','105','257572','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729881),('5','105','257573','432',165.00,165.00,6731.21,0.00,0.00,0.00,0.00,729882),('5','105','257573','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729883),('5','105','257573','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729884),('5','105','257574','432',165.00,165.00,6027.05,0.00,0.00,0.00,0.00,729885),('5','105','257574','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729886),('5','105','257574','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729887),('5','105','257575','432',165.00,165.00,5343.72,0.00,0.00,0.00,0.00,729888),('5','105','257575','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729889),('5','105','257575','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729890),('5','105','257576','432',165.00,165.00,5384.71,0.00,0.00,0.00,0.00,729891),('5','105','257576','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729892),('5','105','257576','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729893),('5','105','257577','432',165.00,165.00,5014.71,0.00,0.00,0.00,0.00,729894),('5','105','257577','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729895),('5','105','257577','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729896),('5','105','257578','432',165.00,165.00,2300.00,0.00,0.00,0.00,0.00,729897),('5','105','257578','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729898),('5','105','257578','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729899),('5','105','257579','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729900),('5','105','257579','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729901),('5','105','257579','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729902),('5','105','257580','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729903),('5','105','257580','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729904),('5','105','257580','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729905),('5','105','257581','432',165.00,165.00,8075.96,0.00,0.00,0.00,0.00,729906),('5','105','257581','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729907),('5','105','257581','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729908),('5','105','257582','432',165.00,165.00,8014.72,0.00,0.00,0.00,0.00,729909),('5','105','257582','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729910),('5','105','257582','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729911),('5','105','257583','432',165.00,165.00,7100.54,0.00,0.00,0.00,0.00,729912),('5','105','257583','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729913),('5','105','257583','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729914),('5','105','257584','432',165.00,165.00,7243.98,0.00,0.00,0.00,0.00,729915),('5','105','257584','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729916),('5','105','257584','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729917),('5','105','257585','432',165.00,165.00,6379.72,0.00,0.00,0.00,0.00,729918),('5','105','257585','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729919),('5','105','257585','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729920),('5','105','257586','432',165.00,165.00,6097.46,0.00,0.00,0.00,0.00,729921),('5','105','257586','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729922),('5','105','257586','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729923),('5','105','257587','432',165.00,165.00,6552.22,0.00,0.00,0.00,0.00,729924),('5','105','257587','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729925),('5','105','257587','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729926),('5','105','257588','432',165.00,165.00,7099.70,0.00,0.00,0.00,0.00,729927),('5','105','257588','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729928),('5','105','257588','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729929),('5','105','257589','432',165.00,165.00,3098.93,0.00,0.00,0.00,0.00,729930),('5','105','257589','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729931),('5','105','257589','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729932),('5','105','257590','432',165.00,165.00,5263.49,0.00,0.00,0.00,0.00,729933),('5','105','257590','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729934),('5','105','257590','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729935),('5','105','257591','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729936),('5','105','257591','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729937),('5','105','257591','432',165.00,165.00,4184.91,0.00,0.00,0.00,0.00,729938),('5','105','257592','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729939),('5','105','257592','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729940),('5','105','257592','432',165.00,165.00,3993.68,0.00,0.00,0.00,0.00,729941),('5','105','257593','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729942),('5','105','257593','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729943),('5','105','257593','432',165.00,165.00,2050.00,0.00,0.00,0.00,0.00,729944),('5','105','257594','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729945),('5','105','257594','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729946),('5','105','257594','432',165.00,165.00,1699.76,0.00,0.00,0.00,0.00,729947),('5','105','257595','432',165.00,165.00,4311.29,0.00,0.00,0.00,0.00,729948),('5','105','257595','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729949),('5','105','257595','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729950),('5','105','257596','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729951),('5','105','257596','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729952),('5','105','257596','432',165.00,165.00,4199.89,0.00,0.00,0.00,0.00,729953),('5','105','257597','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729954),('5','105','257597','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729955),('5','105','257597','432',165.00,165.00,5743.67,0.00,0.00,0.00,0.00,729956),('5','105','257598','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729957),('5','105','257598','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729958),('5','105','257598','432',165.00,165.00,4235.82,0.00,0.00,0.00,0.00,729959),('5','105','257599','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729960),('5','105','257599','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729961),('5','105','257599','432',165.00,165.00,4364.07,0.00,0.00,0.00,0.00,729962),('5','105','257600','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729963),('5','105','257600','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729964),('5','105','257600','432',165.00,165.00,4165.05,0.00,0.00,0.00,0.00,729965),('5','105','257601','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729966),('5','105','257601','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729967),('5','105','257601','432',165.00,165.00,4505.93,0.00,0.00,0.00,0.00,729968),('5','105','257602','432',165.00,165.00,4269.00,0.00,0.00,0.00,0.00,729969),('5','105','257602','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729970),('5','105','257602','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729971),('5','105','257603','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729972),('5','105','257603','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729973),('5','105','257603','432',165.00,165.00,4813.48,0.00,0.00,0.00,0.00,729974),('5','105','257604','432',165.00,165.00,2700.26,0.00,0.00,0.00,0.00,729975),('5','105','257604','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729976),('5','105','257604','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729977),('5','105','257605','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729978),('5','105','257605','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729979),('5','105','257605','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729980),('5','105','257606','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729981),('5','105','257606','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729982),('5','105','257606','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729983),('5','105','257607','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729984),('5','105','257607','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729985),('5','105','257607','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729986),('5','105','257608','432',165.00,165.00,2326.14,0.00,0.00,0.00,0.00,729987),('5','105','257608','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729988),('5','105','257608','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729989),('5','105','257609','432',165.00,165.00,4119.06,0.00,0.00,0.00,0.00,729990),('5','105','257609','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729991),('5','105','257609','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729992),('5','105','257610','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729993),('5','105','257610','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729994),('5','105','257610','432',165.00,165.00,4189.04,0.00,0.00,0.00,0.00,729995),('5','105','257611','432',165.00,165.00,3036.14,0.00,0.00,0.00,0.00,729996),('5','105','257611','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729997),('5','105','257611','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729998),('5','105','257612','432',165.00,165.00,1263.48,0.00,0.00,0.00,0.00,729999),('5','105','257612','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730000),('5','105','257612','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730001),('5','105','257613','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730002),('5','105','257613','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730003),('5','105','257613','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730004),('5','105','257614','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730005),('5','105','257614','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730006),('5','105','257614','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730007),('5','105','257615','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730008),('5','105','257615','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730009),('5','105','257615','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730010),('5','105','257616','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730011),('5','105','257616','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730012),('5','105','257616','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730013),('5','105','257617','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730014),('5','105','257617','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730015),('5','105','257617','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730016),('5','105','257618','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730017),('5','105','257618','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730018),('5','105','257618','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730019),('5','105','257619','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730020),('5','105','257619','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730021),('5','105','257619','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730022),('5','105','257620','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730023),('5','105','257620','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730024),('5','105','257620','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730025),('5','105','257621','432',165.00,165.00,1600.52,0.00,0.00,0.00,0.00,730026),('5','105','257621','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730027),('5','105','257621','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730028),('5','105','257622','432',165.00,165.00,4112.22,0.00,0.00,0.00,0.00,730029),('5','105','257622','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730030),('5','105','257622','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730031),('5','105','257623','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730032),('5','105','257623','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730033),('5','105','257623','432',165.00,165.00,4014.72,0.00,0.00,0.00,0.00,730034),('5','105','257624','432',165.00,165.00,3406.11,0.00,0.00,0.00,0.00,730035),('5','105','257624','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730036),('5','105','257624','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730037),('5','105','257625','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730038),('5','105','257625','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730039),('5','105','257625','432',165.00,165.00,1754.49,0.00,0.00,0.00,0.00,730040),('5','105','257626','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730041),('5','105','257626','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730042),('5','105','257626','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730043),('5','105','257627','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730044),('5','105','257627','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730045),('5','105','257627','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730046),('5','105','257628','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730047),('5','105','257628','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730048),('5','105','257628','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730049),('5','105','257629','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730050),('5','105','257629','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730051),('5','105','257629','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730052),('5','105','257630','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730053),('5','105','257630','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730054),('5','105','257630','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730055),('5','105','257631','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730056),('5','105','257631','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730057),('5','105','257631','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730058),('5','105','257632','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730059),('5','105','257632','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730060),('5','105','257632','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730061),('5','105','257633','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730062),('5','105','257633','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730063),('5','105','257633','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730064),('5','105','257634','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730065),('5','105','257634','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730066),('5','105','257634','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730067),('5','105','257635','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730068),('5','105','257635','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730069),('5','105','257635','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730070),('5','105','257636','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730071),('5','105','257636','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730072),('5','105','257636','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730073),('5','105','257637','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730074),('5','105','257637','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730075),('5','105','257637','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730076),('5','105','257638','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730077),('5','105','257638','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730078),('5','105','257638','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730079),('5','105','257639','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730080),('5','105','257639','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730081),('5','105','257639','432',165.00,165.00,2415.38,0.00,0.00,0.00,0.00,730082),('5','105','257640','432',165.00,165.00,3908.69,0.00,0.00,0.00,0.00,730083),('5','105','257640','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730084),('5','105','257640','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730085),('5','105','257641','432',165.00,165.00,4086.27,0.00,0.00,0.00,0.00,730086),('5','105','257641','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730087),('5','105','257641','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730088),('5','105','257642','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730089),('5','105','257642','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730090),('5','105','257642','432',165.00,165.00,2408.54,0.00,0.00,0.00,0.00,730091),('5','105','257643','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730092),('5','105','257643','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730093),('5','105','257643','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730094),('5','105','257644','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730095),('5','105','257644','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730096),('5','105','257644','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730097),('5','105','257645','432',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730098),('5','105','257645','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730099),('5','105','257645','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730100),('5','105','257646','432',185.00,165.00,2445.46,0.00,0.00,0.00,0.00,730101),('5','105','257646','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730102),('5','105','257646','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730103),('5','105','257647','432',185.00,185.00,4751.02,0.00,0.00,0.00,0.00,730104),('5','105','257647','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730105),('5','105','257647','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730106),('5','105','257648','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730107),('5','105','257648','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730108),('5','105','257648','432',185.00,185.00,7155.58,0.00,0.00,0.00,0.00,730109),('5','105','257649','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730110),('5','105','257649','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730111),('5','105','257649','432',185.00,185.00,6015.43,0.00,0.00,0.00,0.00,730112),('5','105','257650','432',185.00,185.00,7065.98,0.00,0.00,0.00,0.00,730113),('5','105','257650','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730114),('5','105','257650','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730115),('5','105','257651','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730116),('5','105','257651','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730117),('5','105','257651','432',185.00,185.00,6285.56,0.00,0.00,0.00,0.00,730118),('5','105','257652','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730119),('5','105','257652','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730120),('5','105','257652','432',185.00,185.00,6270.61,0.00,0.00,0.00,0.00,730121),('5','105','257653','432',185.00,185.00,5307.39,0.00,0.00,0.00,0.00,730122),('5','105','257653','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730123),('5','105','257653','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730124),('5','105','257654','432',185.00,185.00,7037.61,0.00,0.00,0.00,0.00,730125),('5','105','257654','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730126),('5','105','257654','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730127),('5','105','257655','432',185.00,185.00,7091.89,0.00,0.00,0.00,0.00,730128),('5','105','257655','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730129),('5','105','257655','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730130),('5','105','257656','432',185.00,185.00,7771.36,0.00,0.00,0.00,0.00,730131),('5','105','257656','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730132),('5','105','257656','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730133),('5','105','257657','432',185.00,185.00,8771.95,0.00,0.00,0.00,0.00,730134),('5','105','257657','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730135),('5','105','257657','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730136),('5','105','257658','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730137),('5','105','257658','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730138),('5','105','257658','432',185.00,185.00,6030.28,0.00,0.00,0.00,0.00,730139),('5','105','257659','432',185.00,185.00,4074.45,0.00,0.00,0.00,0.00,730140),('5','105','257659','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730141),('5','105','257659','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730142),('5','105','257660','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730143),('5','105','257660','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730144),('5','105','257660','432',185.00,185.00,4104.28,0.00,0.00,0.00,0.00,730145),('5','105','257661','432',185.00,185.00,3152.16,0.00,0.00,0.00,0.00,730146),('5','105','257661','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730147),('5','105','257661','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730148),('5','105','257662','432',185.00,185.00,3325.94,0.00,0.00,0.00,0.00,730149),('5','105','257662','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730150),('5','105','257662','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730151),('5','105','257663','432',185.00,185.00,1400.01,0.00,0.00,0.00,0.00,730152),('5','105','257663','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730153),('5','105','257663','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730154),('5','105','257664','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730155),('5','105','257664','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730156),('5','105','257664','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730157),('5','105','257665','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730158),('5','105','257665','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730159),('5','105','257665','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730160),('5','105','257666','432',185.00,185.00,2139.27,0.00,0.00,0.00,0.00,730161),('5','105','257666','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730162),('5','105','257666','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730163),('5','105','257667','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730164),('5','105','257667','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730165),('5','105','257667','432',185.00,185.00,5562.97,0.00,0.00,0.00,0.00,730166),('5','105','257668','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730167),('5','105','257668','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730168),('5','105','257668','432',185.00,185.00,5090.63,0.00,0.00,0.00,0.00,730169),('5','105','257669','432',185.00,185.00,5876.44,0.00,0.00,0.00,0.00,730170),('5','105','257669','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730171),('5','105','257669','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730172),('5','105','257670','432',185.00,185.00,5048.82,0.00,0.00,0.00,0.00,730173),('5','105','257670','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730174),('5','105','257670','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730175),('5','105','257671','432',185.00,185.00,4021.79,0.00,0.00,0.00,0.00,730176),('5','105','257671','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730177),('5','105','257671','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730178),('5','105','257672','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730179),('5','105','257672','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730180),('5','105','257672','432',185.00,185.00,4279.61,0.00,0.00,0.00,0.00,730181),('5','105','257673','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730182),('5','105','257673','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730183),('5','105','257673','432',185.00,185.00,4131.88,0.00,0.00,0.00,0.00,730184),('5','105','257674','432',185.00,185.00,3040.67,0.00,0.00,0.00,0.00,730185),('5','105','257674','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730186),('5','105','257674','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730187),('5','105','257675','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730188),('5','105','257675','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730189),('5','105','257675','432',185.00,185.00,5016.00,0.00,0.00,0.00,0.00,730190),('5','105','257676','432',185.00,185.00,4327.80,0.00,0.00,0.00,0.00,730191),('5','105','257676','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730192),('5','105','257676','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730193),('5','105','257677','432',185.00,185.00,5021.77,0.00,0.00,0.00,0.00,730194),('5','105','257677','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730195),('5','105','257677','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730196),('5','105','257678','432',185.00,185.00,5557.11,0.00,0.00,0.00,0.00,730197),('5','105','257678','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730198),('5','105','257678','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730199),('5','105','257679','432',185.00,185.00,5316.80,0.00,0.00,0.00,0.00,730200),('5','105','257679','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730201),('5','105','257679','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730202),('5','105','257680','432',185.00,185.00,5357.03,0.00,0.00,0.00,0.00,730203),('5','105','257680','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730204),('5','105','257680','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730205),('5','105','257681','432',185.00,185.00,5818.77,0.00,0.00,0.00,0.00,730206),('5','105','257681','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730207),('5','105','257681','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730208),('5','105','257682','432',185.00,185.00,6341.46,0.00,0.00,0.00,0.00,730209),('5','105','257682','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730210),('5','105','257682','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730211),('5','105','257683','432',185.00,185.00,7023.20,0.00,0.00,0.00,0.00,730212),('5','105','257683','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730213),('5','105','257683','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730214),('5','105','257684','432',185.00,185.00,4069.00,0.00,0.00,0.00,0.00,730215),('5','105','257684','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730216),('5','105','257684','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730217),('5','105','257685','432',185.00,185.00,5084.89,0.00,0.00,0.00,0.00,730218),('5','105','257685','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730219),('5','105','257685','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730220),('5','105','257686','432',185.00,185.00,5481.18,0.00,0.00,0.00,0.00,730221),('5','105','257686','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730222),('5','105','257686','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730223),('5','105','257687','432',185.00,185.00,5826.50,0.00,0.00,0.00,0.00,730224),('5','105','257687','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730225),('5','105','257687','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730226),('5','105','257688','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730227),('5','105','257688','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730228),('5','105','257688','432',185.00,185.00,5070.02,0.00,0.00,0.00,0.00,730229),('5','105','257689','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730230),('5','105','257689','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730231),('5','105','257689','432',185.00,185.00,7428.28,0.00,0.00,0.00,0.00,730232),('5','105','257690','432',185.00,185.00,6582.46,0.00,0.00,0.00,0.00,730233),('5','105','257690','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730234),('5','105','257690','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730235),('5','105','257691','432',185.00,185.00,7007.29,0.00,0.00,0.00,0.00,730236),('5','105','257691','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730237),('5','105','257691','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730238),('5','105','257692','432',185.00,185.00,6230.87,0.00,0.00,0.00,0.00,730239),('5','105','257692','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730240),('5','105','257692','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730241),('5','105','257693','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730242),('5','105','257693','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730243),('5','105','257693','432',185.00,185.00,6850.26,0.00,0.00,0.00,0.00,730244),('5','105','257694','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730245),('5','105','257694','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730246),('5','105','257694','432',185.00,185.00,6787.88,0.00,0.00,0.00,0.00,730247),('5','105','257695','432',185.00,185.00,7195.33,0.00,0.00,0.00,0.00,730248),('5','105','257695','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730249),('5','105','257695','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730250),('5','105','257696','432',185.00,185.00,7452.47,0.00,0.00,0.00,0.00,730251),('5','105','257696','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730252),('5','105','257696','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730253),('5','105','257697','432',185.00,185.00,7469.54,0.00,0.00,0.00,0.00,730254),('5','105','257697','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730255),('5','105','257697','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730256),('5','105','257698','432',185.00,185.00,7035.86,0.00,0.00,0.00,0.00,730257),('5','105','257698','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730258),('5','105','257698','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730259),('5','105','257699','432',185.00,185.00,7011.14,0.00,0.00,0.00,0.00,730260),('5','105','257699','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730261),('5','105','257699','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730262),('5','105','257700','432',185.00,185.00,8051.17,0.00,0.00,0.00,0.00,730263),('5','105','257700','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730264),('5','105','257700','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730265),('5','105','257701','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730266),('5','105','257701','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730267),('5','105','257701','432',185.00,185.00,8087.13,0.00,0.00,0.00,0.00,730268),('5','105','257702','432',185.00,185.00,8763.17,0.00,0.00,0.00,0.00,730269),('5','105','257702','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730270),('5','105','257702','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730271),('5','105','257703','432',185.00,185.00,7507.17,0.00,0.00,0.00,0.00,730272),('5','105','257703','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730273),('5','105','257703','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730274),('5','105','257704','432',185.00,185.00,6022.60,0.00,0.00,0.00,0.00,730275),('5','105','257704','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730276),('5','105','257704','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730277),('5','105','257705','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730278),('5','105','257705','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730279),('5','105','257705','432',185.00,185.00,5277.65,0.00,0.00,0.00,0.00,730280),('5','105','257706','432',185.00,185.00,6207.69,0.00,0.00,0.00,0.00,730281),('5','105','257706','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730282),('5','105','257706','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730283),('5','105','257707','432',185.00,185.00,2252.30,0.00,0.00,0.00,0.00,730284),('5','105','257707','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730285),('5','105','257707','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730286),('5','105','257708','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730287),('5','105','257708','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730288),('5','105','257708','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730289),('5','105','257709','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730290),('5','105','257709','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730291),('5','105','257709','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730292),('5','105','257710','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730293),('5','105','257710','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730294),('5','105','257710','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730295),('5','105','257711','432',185.00,185.00,2124.47,0.00,0.00,0.00,0.00,730296),('5','105','257711','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730297),('5','105','257711','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730298),('5','105','257712','432',185.00,185.00,5019.84,0.00,0.00,0.00,0.00,730299),('5','105','257712','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730300),('5','105','257712','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730301),('5','105','257713','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730302),('5','105','257713','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730303),('5','105','257713','432',185.00,185.00,7214.66,0.00,0.00,0.00,0.00,730304),('5','105','257714','432',185.00,185.00,6686.34,0.00,0.00,0.00,0.00,730305),('5','105','257714','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730306),('5','105','257714','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730307),('5','105','257715','432',185.00,185.00,7013.49,0.00,0.00,0.00,0.00,730308),('5','105','257715','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730309),('5','105','257715','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730310),('5','105','257716','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730311),('5','105','257716','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730312),('5','105','257716','432',185.00,185.00,5102.25,0.00,0.00,0.00,0.00,730313),('5','105','257717','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730314),('5','105','257717','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730315),('5','105','257717','432',185.00,185.00,6180.90,0.00,0.00,0.00,0.00,730316),('5','105','257718','432',185.00,185.00,6842.77,0.00,0.00,0.00,0.00,730317),('5','105','257718','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730318),('5','105','257718','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730319),('5','105','257719','432',185.00,185.00,7333.23,0.00,0.00,0.00,0.00,730320),('5','105','257719','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730321),('5','105','257719','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730322),('5','105','257720','432',185.00,185.00,6447.87,0.00,0.00,0.00,0.00,730323),('5','105','257720','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730324),('5','105','257720','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730325),('5','105','257721','432',185.00,185.00,8635.99,0.00,0.00,0.00,0.00,730326),('5','105','257721','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730327),('5','105','257721','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730328),('5','105','257722','432',185.00,185.00,7766.92,0.00,0.00,0.00,0.00,730329),('5','105','257722','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730330),('5','105','257722','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730331),('5','105','257723','432',185.00,185.00,7765.75,0.00,0.00,0.00,0.00,730332),('5','105','257723','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730333),('5','105','257723','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730334),('5','105','257724','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730335),('5','105','257724','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730336),('5','105','257724','432',185.00,185.00,8056.42,0.00,0.00,0.00,0.00,730337),('5','105','257725','432',185.00,185.00,7337.73,0.00,0.00,0.00,0.00,730338),('5','105','257725','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730339),('5','105','257725','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730340),('5','105','257726','432',185.00,185.00,7267.61,0.00,0.00,0.00,0.00,730341),('5','105','257726','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730342),('5','105','257726','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730343),('5','105','257727','432',185.00,185.00,8568.03,0.00,0.00,0.00,0.00,730344),('5','105','257727','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730345),('5','105','257727','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730346),('5','105','257728','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730347),('5','105','257728','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730348),('5','105','257728','432',185.00,185.00,7828.74,0.00,0.00,0.00,0.00,730349),('5','105','257729','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730350),('5','105','257729','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730351),('5','105','257729','432',185.00,185.00,7411.69,0.00,0.00,0.00,0.00,730352),('5','105','257730','432',185.00,185.00,8535.70,0.00,0.00,0.00,0.00,730353),('5','105','257730','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730354),('5','105','257730','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730355),('5','105','257731','432',185.00,185.00,6632.55,0.00,0.00,0.00,0.00,730356),('5','105','257731','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730357),('5','105','257731','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730358),('5','105','257732','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730359),('5','105','257732','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730360),('5','105','257732','432',185.00,185.00,7598.04,0.00,0.00,0.00,0.00,730361),('5','105','257733','432',185.00,185.00,7192.47,0.00,0.00,0.00,0.00,730362),('5','105','257733','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730363),('5','105','257733','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730364),('5','105','257734','432',185.00,185.00,15491.77,0.00,0.00,0.00,0.00,730365),('5','105','257734','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730366),('5','105','257734','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730367),('5','105','257735','432',185.00,185.00,3556.73,0.00,0.00,0.00,0.00,730368),('5','105','257735','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730369),('5','105','257735','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730370),('5','105','257736','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730371),('5','105','257736','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730372),('5','105','257736','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730373),('5','105','257737','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730374),('5','105','257737','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730375),('5','105','257737','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730376),('5','105','257738','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730377),('5','105','257738','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730378),('5','105','257738','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730379),('5','105','257739','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730380),('5','105','257739','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730381),('5','105','257739','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730382),('5','105','257740','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730383),('5','105','257740','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730384),('5','105','257740','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730385),('5','105','257741','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730386),('5','105','257741','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730387),('5','105','257741','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730388),('5','105','257742','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730389),('5','105','257742','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730390),('5','105','257742','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730391),('5','105','257743','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730392),('5','105','257743','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730393),('5','105','257743','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730394),('5','105','257744','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730395),('5','105','257744','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730396),('5','105','257744','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730397),('5','105','257745','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730398),('5','105','257745','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730399),('5','105','257745','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730400),('5','105','257746','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730401),('5','105','257746','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730402),('5','105','257746','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730403),('5','105','257747','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730404),('5','105','257747','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730405),('5','105','257747','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730406),('5','105','257748','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730407),('5','105','257748','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730408),('5','105','257748','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730409),('5','105','257749','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730410),('5','105','257749','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730411),('5','105','257749','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730412),('5','105','257750','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730413),('5','105','257750','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730414),('5','105','257750','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730415),('5','105','257751','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730416),('5','105','257751','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730417),('5','105','257751','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730418),('5','105','257752','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730419),('5','105','257752','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730420),('5','105','257752','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730421),('5','105','257753','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730422),('5','105','257753','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730423),('5','105','257753','432',185.00,185.00,1745.07,0.00,0.00,0.00,0.00,730424),('5','105','257754','432',185.00,185.00,8376.84,0.00,0.00,0.00,0.00,730425),('5','105','257754','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730426),('5','105','257754','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730427),('5','105','257755','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730428),('5','105','257755','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730429),('5','105','257755','432',185.00,185.00,10100.51,0.00,0.00,0.00,0.00,730430),('5','105','257756','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730431),('5','105','257756','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730432),('5','105','257756','432',185.00,185.00,10786.60,0.00,0.00,0.00,0.00,730433),('5','105','257757','432',185.00,185.00,11958.84,0.00,0.00,0.00,0.00,730434),('5','105','257757','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730435),('5','105','257757','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730436),('5','105','257758','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730437),('5','105','257758','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730438),('5','105','257758','432',185.00,185.00,12022.35,0.00,0.00,0.00,0.00,730439),('5','105','257759','432',185.00,185.00,15161.08,0.00,0.00,0.00,0.00,730440),('5','105','257759','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730441),('5','105','257759','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730442),('5','105','257760','432',185.00,185.00,15069.22,0.00,0.00,0.00,0.00,730443),('5','105','257760','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730444),('5','105','257760','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730445),('5','105','257761','432',185.00,185.00,13074.21,0.00,0.00,0.00,0.00,730446),('5','105','257761','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730447),('5','105','257761','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730448),('5','105','257762','432',185.00,185.00,13225.39,0.00,0.00,0.00,0.00,730449),('5','105','257762','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730450),('5','105','257762','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730451),('5','105','257763','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730452),('5','105','257763','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730453),('5','105','257763','432',185.00,185.00,12186.87,0.00,0.00,0.00,0.00,730454),('5','105','257764','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730455),('5','105','257764','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730456),('5','105','257764','432',185.00,185.00,10032.16,0.00,0.00,0.00,0.00,730457),('5','105','257765','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730458),('5','105','257765','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730459),('5','105','257765','432',185.00,185.00,1856.61,0.00,0.00,0.00,0.00,730460),('5','105','257766','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730461),('5','105','257766','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730462),('5','105','257766','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730463),('5','105','257767','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730464),('5','105','257767','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730465),('5','105','257767','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730466),('5','105','257768','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730467),('5','105','257768','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730468),('5','105','257768','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730469),('5','105','257769','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730470),('5','105','257769','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730471),('5','105','257769','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730472),('5','105','257770','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730473),('5','105','257770','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730474),('5','105','257770','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730475),('5','105','257771','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730476),('5','105','257771','433',415.00,415.00,0.00,0.00,0.00,0.00,0.00,730477),('5','105','257771','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730478),('5','105','257772','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730479),('5','105','257772','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730480),('5','105','257772','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730481),('5','105','257773','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730482),('5','105','257773','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730483),('5','105','257773','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730484),('5','105','257774','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730485),('5','105','257774','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730486),('5','105','257774','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730487),('5','105','257775','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730488),('5','105','257775','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730489),('5','105','257775','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730490),('5','105','257776','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730491),('5','105','257776','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730492),('5','105','257776','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730493),('5','105','257777','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730494),('5','105','257777','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730495),('5','105','257777','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730496),('5','105','257778','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730497),('5','105','257778','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730498),('5','105','257778','432',185.00,185.00,2880.30,0.00,0.00,0.00,0.00,730499),('5','105','257779','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730500),('5','105','257779','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730501),('5','105','257779','432',185.00,185.00,11082.66,0.00,0.00,0.00,0.00,730502),('5','105','257780','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730503),('5','105','257780','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730504),('5','105','257780','432',185.00,185.00,11150.78,0.00,0.00,0.00,0.00,730505),('5','105','257781','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730506),('5','105','257781','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730507),('5','105','257781','432',185.00,185.00,8032.91,0.00,0.00,0.00,0.00,730508),('5','105','257782','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730509),('5','105','257782','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730510),('5','105','257782','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730511),('5','105','257783','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730512),('5','105','257783','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730513),('5','105','257783','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730514),('5','105','257784','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730515),('5','105','257784','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730516),('5','105','257784','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730517),('5','105','257785','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730518),('5','105','257785','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730519),('5','105','257785','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730520),('5','105','257786','432',185.00,185.00,1834.90,0.00,0.00,0.00,0.00,730521),('5','105','257786','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730522),('5','105','257786','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730523),('5','105','257787','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730524),('5','105','257787','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730525),('5','105','257787','432',185.00,185.00,10279.88,0.00,0.00,0.00,0.00,730526),('5','105','257788','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730527),('5','105','257788','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730528),('5','105','257788','432',185.00,185.00,10539.04,0.00,0.00,0.00,0.00,730529),('5','105','257789','432',185.00,185.00,10800.45,0.00,0.00,0.00,0.00,730530),('5','105','257789','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730531),('5','105','257789','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730532),('5','105','257790','432',185.00,185.00,10749.24,0.00,0.00,0.00,0.00,730533),('5','105','257790','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730534),('5','105','257790','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730535),('5','105','257791','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730536),('5','105','257791','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730537),('5','105','257791','432',185.00,185.00,10563.91,0.00,0.00,0.00,0.00,730538),('5','105','257792','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730539),('5','105','257792','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730540),('5','105','257792','432',185.00,185.00,11205.81,0.00,0.00,0.00,0.00,730541),('5','105','257793','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730542),('5','105','257793','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730543),('5','105','257793','432',185.00,185.00,9665.36,0.00,0.00,0.00,0.00,730544),('5','105','257794','432',185.00,185.00,8967.84,0.00,0.00,0.00,0.00,730545),('5','105','257794','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730546),('5','105','257794','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730547),('5','105','257795','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730548),('5','105','257795','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730549),('5','105','257795','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730550),('5','105','257796','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730551),('5','105','257796','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730552),('5','105','257796','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730553),('5','105','257797','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730554),('5','105','257797','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730555),('5','105','257797','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730556),('5','105','257798','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730557),('5','105','257798','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730558),('5','105','257798','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730559),('5','105','257799','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730560),('5','105','257799','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730561),('5','105','257799','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730562),('5','105','257800','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730563),('5','105','257800','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730564),('5','105','257800','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730565),('5','105','257801','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730566),('5','105','257801','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730567),('5','105','257801','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730568),('5','105','257802','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730569),('5','105','257802','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730570),('5','105','257802','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730571),('5','105','257803','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730572),('5','105','257803','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730573),('5','105','257803','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730574),('5','105','257804','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730575),('5','105','257804','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730576),('5','105','257804','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730577),('5','105','257805','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730578),('5','105','257805','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730579),('5','105','257805','432',185.00,185.00,3351.37,0.00,0.00,0.00,0.00,730580),('5','105','257806','432',185.00,185.00,13211.05,0.00,0.00,0.00,0.00,730581),('5','105','257806','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730582),('5','105','257806','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730583),('5','105','257807','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730584),('5','105','257807','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730585),('5','105','257807','432',185.00,185.00,10268.09,0.00,0.00,0.00,0.00,730586),('5','105','257808','432',185.00,185.00,3335.02,0.00,0.00,0.00,0.00,730587),('5','105','257808','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730588),('5','105','257808','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730589),('5','105','257809','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730590),('5','105','257809','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730591),('5','105','257809','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730592),('5','105','257810','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730593),('5','105','257810','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730594),('5','105','257810','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730595),('5','105','257811','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730596),('5','105','257811','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730597),('5','105','257811','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730598),('5','105','257812','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730599),('5','105','257812','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730600),('5','105','257812','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730601),('5','105','257813','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730602),('5','105','257813','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730603),('5','105','257813','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730604),('5','105','257814','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730605),('5','105','257814','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730606),('5','105','257814','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730607),('5','105','257815','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730608),('5','105','257815','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730609),('5','105','257815','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730610),('5','105','257816','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730611),('5','105','257816','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730612),('5','105','257816','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730613),('5','105','257817','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730614),('5','105','257817','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730615),('5','105','257817','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730616),('5','105','257818','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730617),('5','105','257818','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730618),('5','105','257818','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730619),('5','105','257819','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730620),('5','105','257819','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730621),('5','105','257819','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730622),('5','105','257820','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730623),('5','105','257820','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730624),('5','105','257820','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730625),('5','105','257821','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730626),('5','105','257821','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730627),('5','105','257821','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730628),('5','105','257822','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730629),('5','105','257822','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730630),('5','105','257822','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730631),('5','105','257823','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730632),('5','105','257823','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730633),('5','105','257823','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730634),('5','105','257824','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730635),('5','105','257824','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730636),('5','105','257824','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730637),('5','105','257825','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730638),('5','105','257825','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730639),('5','105','257825','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730640),('5','105','257826','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730641),('5','105','257826','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730642),('5','105','257826','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730643),('5','105','257827','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730644),('5','105','257827','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730645),('5','105','257827','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730646),('5','105','257828','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730647),('5','105','257828','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730648),('5','105','257828','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730649),('5','105','257829','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730650),('5','105','257829','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730651),('5','105','257829','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730652),('5','105','257830','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730653),('5','105','257830','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730654),('5','105','257830','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730655),('5','105','257831','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730656),('5','105','257831','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730657),('5','105','257831','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730658),('5','105','257832','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730659),('5','105','257832','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730660),('5','105','257832','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730661),('5','105','257833','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730662),('5','105','257833','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730663),('5','105','257833','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730664),('5','105','257834','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730665),('5','105','257834','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730666),('5','105','257834','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730667),('5','105','257835','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730668),('5','105','257835','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730669),('5','105','257835','432',185.00,185.00,16586.87,0.00,0.00,0.00,0.00,730670),('5','105','257836','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730671),('5','105','257836','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730672),('5','105','257836','432',185.00,185.00,11156.20,0.00,0.00,0.00,0.00,730673),('5','105','257837','432',185.00,185.00,2405.72,0.00,0.00,0.00,0.00,730674),('5','105','257837','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730675),('5','105','257837','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730676),('5','105','257838','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730677),('5','105','257838','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730678),('5','105','257838','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730679),('5','105','257839','432',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730680),('5','105','257839','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730681),('5','105','257839','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730682),('5','105','257840','432',220.00,220.00,1966.63,0.00,0.00,0.00,0.00,730683),('5','105','257840','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730684),('5','105','257840','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730685),('5','105','257841','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730686),('5','105','257841','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730687),('5','105','257841','432',220.00,185.00,0.00,0.00,0.00,0.00,0.00,730688),('5','105','257842','432',220.00,220.00,13082.96,0.00,0.00,0.00,0.00,730689),('5','105','257842','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730690),('5','105','257842','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730691),('5','105','257843','432',220.00,220.00,14230.67,0.00,0.00,0.00,0.00,730692),('5','105','257843','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730693),('5','105','257843','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730694),('5','105','257844','432',220.00,220.00,7511.38,0.00,0.00,0.00,0.00,730695),('5','105','257844','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730696),('5','105','257844','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730697),('5','105','257845','432',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730698),('5','105','257845','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730699),('5','105','257845','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730700),('5','105','257846','432',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730701),('5','105','257846','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730702),('5','105','257846','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730703),('5','105','257847','432',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730704),('5','105','257847','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730705),('5','105','257847','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730706),('5','105','257848','432',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730707),('5','105','257848','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730708),('5','105','257848','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730709),('5','105','257849','432',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730710),('5','105','257849','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730711),('5','105','257849','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730712),('5','105','257850','432',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730713),('5','105','257850','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730714),('5','105','257850','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730715),('5','105','257851','432',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730716),('5','105','257851','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730717),('5','105','257851','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730718),('5','105','257852','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730719),('5','105','257852','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730720),('5','105','257852','432',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730721),('5','105','257853','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730722),('5','105','257853','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730723),('5','105','257853','432',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730724),('5','105','257854','432',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730725),('5','105','257854','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730726),('5','105','257854','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730727),('5','105','257855','432',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730728),('5','105','257855','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730729),('5','105','257855','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730730),('5','105','257856','432',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730731),('5','105','257856','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730732),('5','105','257856','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730733),('5','105','257857','432',220.00,220.00,4847.78,0.00,0.00,0.00,0.00,730734),('5','105','257857','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730735),('5','105','257857','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730736),('5','105','257858','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730737),('5','105','257858','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730738),('5','105','257858','432',220.00,220.00,16602.08,0.00,0.00,0.00,0.00,730739),('5','105','257859','432',220.00,220.00,8615.12,0.00,0.00,0.00,0.00,730740),('5','105','257859','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730741),('5','105','257859','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730742),('5','105','257860','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730743),('5','105','257860','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730744),('5','105','257860','432',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730745),('5','105','257861','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730746),('5','105','257861','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730747),('5','105','257861','432',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730748),('5','105','257862','432',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730749),('5','105','257862','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730750),('5','105','257862','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730751),('5','105','257863','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730752),('5','105','257863','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730753),('5','105','257863','432',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730754),('5','105','257864','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730755),('5','105','257864','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730756),('5','105','257864','432',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730757),('5','105','257865','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730758),('5','105','257865','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730759),('5','105','257865','432',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730760),('5','105','257866','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730761),('5','105','257866','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730762),('5','105','257866','432',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730763),('5','105','257867','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730764),('5','105','257867','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730765),('5','105','257867','432',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730766),('5','105','257868','432',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730767),('5','105','257868','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730768),('5','105','257868','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730769),('5','105','257869','432',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730770),('5','105','257869','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730771),('5','105','257869','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730772),('5','105','257870','432',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730773),('5','105','257870','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730774),('5','105','257870','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730775),('5','105','257871','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730776),('5','105','257871','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730777),('5','105','257871','432',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730778),('5','105','257872','432',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730779),('5','105','257872','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730780),('5','105','257872','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730781),('5','105','257873','432',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730782),('5','105','257873','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730783),('5','105','257873','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730784),('5','105','257874','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730785),('5','105','257874','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730786),('5','105','257874','432',220.00,220.00,4742.06,0.00,0.00,0.00,0.00,730787),('5','105','257875','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730788),('5','105','257875','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730789),('5','105','257875','432',220.00,220.00,10200.41,0.00,0.00,0.00,0.00,730790),('5','105','257876','432',220.00,220.00,2097.59,0.00,0.00,0.00,0.00,730791),('5','105','257876','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730792),('5','105','257876','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730793),('5','105','257877','432',220.00,220.00,9940.95,0.00,0.00,0.00,0.00,730794),('5','105','257877','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730795),('5','105','257877','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730796),('5','105','257878','432',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730797),('5','105','257878','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730798),('5','105','257878','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730799),('5','105','257879','432',210.00,210.00,11271.17,0.00,0.00,0.00,0.00,730800),('5','105','257879','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730801),('5','105','257879','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730802),('5','105','257880','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730803),('5','105','257880','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730804),('5','105','257880','432',210.00,210.00,10793.27,0.00,0.00,0.00,0.00,730805),('5','105','257881','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730806),('5','105','257881','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730807),('5','105','257881','432',210.00,210.00,12096.24,0.00,0.00,0.00,0.00,730808),('5','105','257882','432',210.00,210.00,14825.40,0.00,0.00,0.00,0.00,730809),('5','105','257882','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730810),('5','105','257882','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730811),('5','105','257883','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730812),('5','105','257883','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730813),('5','105','257883','432',210.00,210.00,16527.61,0.00,0.00,0.00,0.00,730814),('5','105','257884','432',210.00,210.00,22290.72,0.00,0.00,0.00,0.00,730815),('5','105','257884','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730816),('5','105','257884','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730817),('5','105','257885','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730818),('5','105','257885','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730819),('5','105','257885','432',210.00,210.00,18653.84,0.00,0.00,0.00,0.00,730820),('5','105','257886','432',210.00,210.00,13995.65,0.00,0.00,0.00,0.00,730821),('5','105','257886','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730822),('5','105','257886','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730823),('5','105','257887','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730824),('5','105','257887','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730825),('5','105','257887','432',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730826),('5','105','257888','432',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730827),('5','105','257888','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730828),('5','105','257888','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730829),('5','105','257889','432',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730830),('5','105','257889','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730831),('5','105','257889','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730832),('5','105','257890','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730833),('5','105','257890','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730834),('5','105','257890','432',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730835),('5','105','257891','432',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730836),('5','105','257891','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730837),('5','105','257891','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730838),('5','105','257892','432',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730839),('5','105','257892','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730840),('5','105','257892','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730841),('5','105','257893','432',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730842),('5','105','257893','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730843),('5','105','257893','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730844),('5','105','257894','432',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730845),('5','105','257894','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730846),('5','105','257894','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730847),('5','105','257895','432',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730848),('5','105','257895','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730849),('5','105','257895','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730850),('5','105','257896','432',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730851),('5','105','257896','433',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730852),('5','105','257896','434',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730853);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=394 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('5',393,'105','PRODUCT TANKS','TANKS CONTAINING PETROLEUM PRODUCT.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=967 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('5','105','393',961,0,'432','PMS TANK 1',65000.00,1.00,1287.87,'TANK CONTAINING PETROLEUM.','576','2021-07-15 07:27:11','2021-07-15 07:27:11','576',5,1),('5','105','393',962,0,'432','PMS TANK 2',65000.00,1.00,1033.94,'TANK CONTAINING PETROLEUM.','576','2021-07-15 07:30:09','2021-07-15 07:30:09','576',5,1),('5','105','393',963,0,'432','PMS TANK 3',65000.00,1.00,11177.05,'TANK CONTAINING PETROLEUM.','576','2021-07-15 07:31:53','2021-07-15 07:31:53','576',5,1),('5','105','393',964,0,'432','PMS TANK 4',65000.00,1.00,15367.31,'TANK CONTAINING PETROLEUM.','576','2021-07-15 07:33:53','2021-07-15 07:33:53','576',5,1),('5','105','393',965,0,'433','AGO TANK',40000.00,1.00,6270.87,'TANKS CONTAINING DIESEL.','576','2021-07-15 07:35:47','2021-07-15 07:35:47','576',5,1),('5','105','393',966,0,'434','DPK TANK ',40000.00,1.00,0.00,'TANKS CONTAINING KEROSENE.','576','2021-07-15 07:36:57','2021-07-15 07:36:57','576',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'5','105',966,0.00,'2023-03-20 17:36:47'),(2,'5','105',965,2710.50,'2023-03-20 17:36:47'),(3,'5','105',964,256.79,'2023-03-20 17:36:47'),(4,'5','105',963,2100.00,'2023-03-20 17:36:47'),(5,'5','105',962,3215.85,'2023-03-20 17:36:47'),(6,'5','105',961,5511.00,'2023-03-20 17:36:47');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2643814 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2110495,'5','105','964',432,'Sale Id shift 242838',0.00,0.00,0.00,4824.02,0.00,'2021-12-01 08:31:31','',''),(2110496,'5','105','964',432,'Sale Id shift 242838',0.00,0.00,0.00,4927.84,0.00,'2021-12-01 08:31:31','',''),(2110497,'5','105','965',433,'Sale Id shift 242838',0.00,0.00,0.00,708.01,0.00,'2021-12-01 08:31:31','',''),(2110498,'5','105',NULL,432,'Sale Id shift 242838',1609056.90,0.00,0.00,0.00,0.00,'2021-12-01 08:31:31','',''),(2110499,'5','105',NULL,433,'Sale Id shift 242838',244263.45,0.00,0.00,0.00,0.00,'2021-12-01 08:31:31','',''),(2119798,'5','105',NULL,432,'Purchased from SALBAS OIL & GAS LIMITED',0.00,9900000.00,60000.00,0.00,0.00,'2021-12-01 19:18:41','',''),(2126260,'5','105',NULL,432,'Reception corrector for bridging 125910',0.00,0.00,0.00,30000.00,0.00,'2021-12-02 11:24:51','',''),(2126261,'5','105','962',432,'Received from bridging 125910',0.00,0.00,30000.00,0.00,0.00,'2021-12-02 11:24:51','',''),(2126268,'5','105',NULL,432,'Reception corrector for bridging 125911',0.00,0.00,0.00,30000.00,0.00,'2021-12-02 11:25:10','',''),(2126269,'5','105','964',432,'Received from bridging 125911',0.00,0.00,30000.00,0.00,0.00,'2021-12-02 11:25:10','',''),(2130202,'5','105','962',432,'Sale Id shift 243083',0.00,0.00,0.00,663.45,0.00,'2021-12-02 15:28:04','',''),(2130203,'5','105','962',432,'Sale Id shift 243083',0.00,0.00,0.00,1308.75,0.00,'2021-12-02 15:28:04','',''),(2130204,'5