-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_5_station_104
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_5_station_104`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_5_station_104` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_5_station_104`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3319 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (3166,4015,'',0,'20','5','104','SALES','','2021-02-20 23:51:21',5,0.00,0.00,'','595','2021-02-20 23:51:21','595',0,1),(3167,3017,'',0,'6.1','5','104','CASH','','2021-02-20 23:51:46',5,0.00,0.00,'','595','2021-02-20 23:51:46','595',0,1),(3168,4000,'',0,'22','5','104','PURCHASES','','2021-02-20 23:52:24',5,0.00,0.00,'','595','2021-02-20 23:52:24','595',0,1),(3169,30148,'',0,'24','5','104','SALARIES & WAGES','','2021-02-20 23:53:05',5,0.00,0.00,'','595','2021-02-20 23:53:05','595',0,1),(3170,30149,'',0,'24','5','104','PURCHASES','','2021-02-20 23:53:39',5,0.00,0.00,'','595','2021-02-20 23:53:39','595',0,1),(3229,4016,'',0,'2','5','104','ZENITH BANK-1010992954','','2021-03-06 01:17:53',5,0.00,0.00,'','600','2021-03-06 01:17:53','600',0,1),(3316,4034,'',0,'2','5','104','UBA-1024022416','','2021-05-04 15:43:47',5,0.00,0.00,'','600','2021-05-04 15:43:47','600',0,1),(3317,4035,'',0,'2','5','104','JA\'IZ-0010037957','','2022-03-02 19:03:15',5,0.00,0.00,'','600','2022-03-02 19:03:15','600',0,0),(3318,2000,'',0,'6','5','104','INVENTORY VALUE ADJUSTMENT','','2023-02-06 10:24:00',5,0.00,0.00,'','600','2023-02-06 10:24:00','600',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
INSERT INTO `accounts_transactions` VALUES (1,'5','104','0000-00-00','2023-02-20 16:38:54',10,'600','','0000-00-00 00:00:00','600','2023-02-20 16:43:44'),(2,'5','104','0000-00-00','2023-02-20 16:42:45',10,'600','','0000-00-00 00:00:00','600','2023-02-20 16:43:47');
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
INSERT INTO `accounts_transactions_items` VALUES (2,'5','104','1','215','supplier',0.00,'PMS PRICE DECREASE FROM 220 TO 210 DIPPING 1,438Ltrs',14380.00,'2023-02-19'),(3,'5','104','1','3318','6',14380.00,'PMS PRICE DECREASE FROM 220 TO 210 DIPPING 1,438Ltrs',0.00,'2023-02-19'),(4,'5','104','2','215','supplier',0.00,'AGO PRICE DECREASE FROM 830 TO 820 DIPPING 123Ltrs',1230.00,'2023-02-20'),(5,'5','104','2','3318','6',1230.00,'AGO PRICE DECREASE FROM 830 TO 820 DIPPING 123Ltrs',0.00,'2023-02-20');
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=18150 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('5','104',17475,'896',1387.47,2555.00,'2021-11-05','','2021-11-05 09:59:08','600','600',2021,'600','2021-11-05 09:59:08',5),('5','104',18127,'895',791.40,1000.00,'2021-12-20','','2021-12-20 09:30:05','600','600',2021,'600','2021-12-20 09:30:05',5),('5','104',18128,'896',9352.48,10000.00,'2021-12-20','','2021-12-20 09:30:24','600','600',2021,'600','2021-12-20 09:30:24',5),('5','104',18129,'896',2704.72,2900.00,'2022-02-16','','2022-02-16 12:31:58','600','600',2022,'600','2022-02-16 12:31:58',5),('5','104',18130,'895',401.95,3571.00,'2022-09-06','','2022-09-06 18:20:47','600','600',2022,'600','2022-09-06 18:20:47',5),('5','104',18131,'896',17437.13,250.00,'2022-09-06','','2022-09-06 18:21:06','600','600',2022,'600','2022-09-06 18:21:06',5),('5','104',18132,'895',6464.31,8850.00,'2022-09-07','','2022-09-07 11:10:16','600','600',2022,'600','2022-09-07 11:10:16',5),('5','104',18133,'896',28649.19,26070.00,'2022-09-07','','2022-09-07 11:10:35','600','600',2022,'600','2022-09-07 11:10:35',5),('5','104',18134,'895',1393.63,1750.00,'2022-09-07','','2022-09-08 10:11:42','600','600',2022,'600','2022-09-08 10:11:42',5),('5','104',18135,'896',20153.16,16380.00,'2022-09-07','','2022-09-08 10:12:07','600','600',2022,'600','2022-09-08 10:12:07',5),('5','104',18136,'895',1750.00,10000.00,'2022-09-08','','2022-09-08 11:43:18','600','600',2022,'600','2022-09-08 11:43:18',5),('5','104',18137,'896',16380.00,10000.00,'2022-09-08','','2022-09-08 11:43:39','600','600',2022,'600','2022-09-08 11:43:39',5),('5','104',18138,'896',182.69,5400.00,'2022-09-09','','2022-09-09 09:16:33','600','600',2022,'600','2022-09-09 09:16:33',5),('5','104',18139,'896',5400.00,11000.00,'2022-09-09','','2022-09-09 16:09:19','600','600',2022,'600','2022-09-09 16:09:19',5),('5','104',18140,'895',2422.97,3000.00,'2022-09-14','','2022-09-14 06:04:18','600','600',2022,'600','2022-09-14 06:04:18',5),('5','104',18141,'896',4275.89,5000.00,'2022-09-14','','2022-09-14 06:04:32','600','600',2022,'600','2022-09-14 06:04:32',5),('5','104',18142,'895',3000.00,759.00,'2022-09-15','','2022-09-15 10:09:36','600','600',2022,'600','2022-09-15 10:09:36',5),('5','104',18143,'896',5000.00,10000.00,'2022-09-15','','2022-09-15 10:09:54','600','600',2022,'600','2022-09-15 10:09:54',5),('5','104',18144,'895',3955.03,3290.00,'2022-10-04','','2022-10-04 16:39:46','600','600',2022,'600','2022-10-04 16:39:46',5),('5','104',18145,'896',7135.09,7770.00,'2022-10-04','','2022-10-04 16:40:11','600','600',2022,'600','2022-10-04 16:40:11',5),('5','104',18146,'895',111.45,1750.00,'2023-01-17','','2023-01-17 18:24:28','600','600',2023,'600','2023-01-17 18:24:28',5),('5','104',18147,'896',4726.11,2100.00,'2023-01-17','','2023-01-17 18:24:53','600','600',2023,'600','2023-01-17 18:24:53',5),('5','104',18148,'895',1750.00,1750.00,'2023-01-18','','2023-01-18 11:06:25','600','600',2023,'600','2023-01-18 11:06:25',5),('5','104',18149,'896',2100.00,4100.00,'2023-01-18','','2023-01-18 11:06:51','600','600',2023,'600','2023-01-18 11:06:51',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2677 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('5','104','895',2669,'5','PMS PUMP 1',2648298.26,'PMS DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','104','895',2670,'5','PMS PUMP 2',1648622.42,'PMS DISPENSER','',NULL,NULL,'',5,'2022-02-08 12:51:28','600'),('5','104','896',2671,'5','PMS PUMP 4',2216521.84,'PMS DISPENSER','',NULL,NULL,'',5,'2022-02-08 12:52:27','600'),('5','104','896',2672,'5','PMS PUMP 5',1545441.73,'PMS DISPENSER','',NULL,NULL,'',5,'2021-03-04 11:27:37','600'),('5','104','897',2673,'5','AGO PUMP ',1404731.74,'AGO DISPENSER','',NULL,NULL,'',5,'2021-03-04 11:33:20','600'),('5','104','898',2674,'5','DPK PUMP',0.00,'DPK DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','104','895',2675,'5','PMS PUMP 3',2675444.45,'PMS DISPENSER','',NULL,NULL,'',5,'2021-02-28 11:50:56','600'),('5','104','896',2676,'5','PMS PUMP 6',1357591.20,'PMS DISPENSER','',NULL,NULL,'',5,'2021-02-28 11:51:42','600');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=257768 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('5','104',181487,'MORNING','2021-02-27','2021-02-27 00:00:00',NULL,'595',0.00,0.00,'595','2021-02-27 16:43:09','595','2021-02-27 16:46:16',10,0),('5','104',181491,'FULL','2021-02-27','2021-02-27 00:00:00',NULL,'595',0.00,0.00,'595','2021-02-27 16:51:45','595','2021-02-27 16:52:46',10,0),('5','104',181497,'AFTERNOON','2021-02-27','2021-02-27 00:00:00',NULL,'595',0.00,-26569.00,'595','2021-02-27 17:05:10','595','2021-02-27 17:06:57',10,0),('5','104',181500,'FULL','2021-02-27','2021-02-27 00:00:00',NULL,'595',0.00,240774252349.00,'595','2021-02-27 17:10:38','595','2021-02-27 17:11:26',10,0),('5','104',181508,'daily shift','2021-02-27','2021-02-27 00:00:00',NULL,'595',0.00,3711822.96,'595','2021-02-28 08:37:37','595','2021-02-28 08:38:53',10,0),('5','104',181545,'daily shift','2021-02-28','2021-02-28 00:00:00',NULL,'595',0.00,0.00,'600','2021-02-28 11:44:14','600','2021-02-28 11:45:09',10,0),('5','104',181639,'daily shift','2021-02-28','2021-02-28 00:00:00',NULL,'595',0.00,4044695.38,'595','2021-02-28 23:36:32','595','2021-03-01 19:28:37',10,0),('5','104',181886,'daily shift','2021-03-01','2021-03-01 00:00:00',NULL,'595',0.00,1743692.06,'595','2021-03-01 23:18:58','600','2021-03-02 09:16:25',10,0),('5','104',182054,'daily shift','2021-03-02','2021-03-02 00:00:00',NULL,'595',0.00,0.00,'600','2021-03-04 11:03:39','600','2021-03-04 11:04:01',10,0),('5','104',182402,'daily shift','2021-03-04','2021-03-04 00:00:00',NULL,'595',0.00,625452.50,'595','2021-03-04 23:07:54','607','2021-03-05 15:58:10',10,0),('5','104',182661,'daily shift','2021-03-05','2021-03-05 00:00:00',NULL,'595',0.00,225597.50,'595','2021-03-06 10:26:03','600','2021-03-07 17:36:55',10,0),('5','104',182981,'daily shift','2021-03-08','2021-03-08 00:00:00',NULL,'595',0.00,663048.55,'595','2021-03-08 00:24:16','600','2021-03-08 14:37:14',10,0),('5','104',183167,'daily shift','2021-03-08','2021-03-08 00:00:00',NULL,'595',0.00,7790616.44,'595','2021-03-10 17:22:05','607','2021-03-10 17:46:51',10,0),('5','104',183827,'daily shift','2021-03-11','2021-03-11 00:00:00',NULL,'595',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','104',184229,'FULL','2021-03-13','2021-03-13 00:00:00',NULL,'600',5276896.80,5936352.30,'595','2021-03-14 11:51:49','607','2021-03-14 12:00:44',10,0),('5','104',184358,'daily shift ','2021-03-13','2021-03-13 00:00:00',NULL,'595',9571185.59,10763070.89,'595','2021-03-14 13:59:11','607','2021-03-14 14:10:47',10,0),('5','104',184387,'daily shift ','2021-03-14','2021-03-14 00:00:00',NULL,'595',2168271.64,2168271.64,'595','2021-03-15 10:21:57','607','2021-03-15 14:43:53',10,0),('5','104',184623,'daily shift ','2021-03-15','2021-03-15 00:00:00',NULL,'595',3183812.17,3183812.17,'595','2021-03-15 22:02:01','607','2021-03-16 10:52:57',10,0),('5','104',184776,'daily shift ','2021-03-16','2021-03-16 00:00:00',NULL,'595',1178238.98,1178238.98,'595','2021-03-16 17:50:13','607','2021-03-16 18:23:11',10,0),('5','104',184872,'daily shift ','2021-03-17','2021-03-17 00:00:00',NULL,'595',2754815.73,2754815.73,'595','2021-03-18 00:17:06','607','2021-03-18 08:17:18',10,0),('5','104',185190,'daily shift ','2021-03-18','2021-03-18 00:00:00',NULL,'595',3486746.04,3486746.04,'595','2021-03-19 07:14:08','607','2021-03-19 07:37:02',10,0),('5','104',185270,'daily shift ','2021-03-19','2021-03-19 00:00:00',NULL,'595',2487500.62,2487500.62,'595','2021-03-19 23:16:28','607','2021-03-21 07:10:55',10,0),('5','104',185725,'daily shift ','2021-03-20','2021-03-20 00:00:00',NULL,'595',2110153.99,2110153.99,'595','2021-03-21 21:13:22','607','2021-03-21 22:21:08',10,0),('5','104',185863,'daily shift ','2021-03-21','2021-03-21 00:00:00',NULL,'595',2028772.98,2028772.98,'595','2021-03-22 05:31:13','607','2021-03-22 10:52:43',10,0),('5','104',185950,'daily shift ','2021-03-22','2021-03-22 00:00:00',NULL,'595',3096718.01,3096718.01,'595','2021-03-23 23:03:03','607','2021-03-24 09:03:18',10,0),('5','104',186413,'daily shift ','2021-03-23','2021-03-23 00:00:00',NULL,'595',1948086.35,1948086.35,'595','2021-03-24 14:04:03','607','2021-03-24 14:48:52',10,0),('5','104',186516,'daily shift ','2021-03-24','2021-03-24 00:00:00',NULL,'595',1860698.79,1860698.79,'595','2021-03-24 23:11:41','607','2021-03-25 12:53:39',10,0),('5','104',186668,'daily shift ','2021-03-25','2021-03-25 00:00:00',NULL,'595',2726846.56,2726846.56,'595','2021-03-26 07:53:44','607','2021-03-26 08:56:27',10,0),('5','104',186936,'daily shift ','2021-03-26','2021-03-26 00:00:00',NULL,'595',967493.02,967493.02,'595','2021-03-27 18:55:48','607','2021-03-27 19:01:55',10,0),('5','104',187141,'daily shift ','2021-03-27','2021-03-27 00:00:00',NULL,'595',3489702.86,3489702.86,'595','2021-03-28 06:35:53','607','2021-03-28 09:10:24',10,0),('5','104',187475,'daily shift ','2021-03-28','2021-03-28 00:00:00',NULL,'595',2116504.47,2116504.47,'595','2021-03-29 14:30:00','607','2021-03-29 15:17:03',10,0),('5','104',187552,'daily shift ','2021-03-29','2021-03-29 00:00:00',NULL,'595',3820438.01,3820438.01,'595','2021-03-29 21:33:34','607','2021-03-30 08:14:46',10,0),('5','104',187622,'daily shift ','2021-03-30','2021-03-30 00:00:00',NULL,'595',1839596.81,1839596.81,'595','2021-03-30 21:16:03','607','2021-03-31 05:47:15',10,0),('5','104',187813,'daily shift ','2021-03-31','2021-03-31 00:00:00',NULL,'595',2049014.32,2049014.32,'595','2021-03-31 22:08:45','607','2021-04-01 05:28:41',10,0),('5','104',188003,'daily shift ','2021-04-01','2021-04-01 00:00:00',NULL,'595',2356222.05,2356222.05,'595','2021-04-04 14:32:14','607','2021-04-04 14:53:08',10,0),('5','104',188716,'daily shift ','2021-04-02','2021-04-02 00:00:00',NULL,'595',2767850.84,2767850.84,'595','2021-04-04 15:08:27','607','2021-04-04 15:10:25',10,0),('5','104',188721,'daily shift ','2021-04-03','2021-04-03 00:00:00',NULL,'595',2997095.67,2997095.67,'595','2021-04-04 15:18:26','607','2021-04-04 15:19:20',10,0),('5','104',188723,'daily shift ','2021-04-04','2021-04-04 00:00:00',NULL,'595',2132628.43,2132628.43,'595','2021-04-04 22:22:32','607','2021-04-05 07:37:23',10,0),('5','104',188832,'daily shift ','2021-04-05','2021-04-05 00:00:00',NULL,'595',5428177.10,5619440.85,'595','2021-04-06 09:51:09','607','2021-04-06 11:29:07',10,0),('5','104',189089,'daily shift ','2021-04-06','2021-04-06 00:00:00',NULL,'595',2270763.92,2270763.92,'595','2021-04-06 21:42:59','604','2021-04-07 07:01:09',10,0),('5','104',189233,'daily shift ','2021-04-07','2021-04-07 00:00:00',NULL,'595',335344.25,335344.25,'595','2021-04-07 21:43:57','607','2021-04-08 05:25:39',10,0),('5','104',189410,'daily shift ','2021-04-08','2021-04-08 00:00:00',NULL,'595',633668.00,633668.00,'595','2021-04-08 21:36:35','607','2021-04-08 21:53:47',10,0),('5','104',189608,'daily shift ','2021-04-09','2021-04-09 00:00:00',NULL,'595',397894.85,397894.85,'595','2021-04-09 18:29:43','607','2021-04-10 08:23:40',10,0),('5','104',189848,'daily shift ','2021-04-10','2021-04-10 00:00:00',NULL,'595',3739734.33,3739734.33,'595','2021-04-11 06:13:55','607','2021-04-11 09:18:15',10,0),('5','104',190075,'daily shift ','2021-04-11','2021-04-11 00:00:00',NULL,'595',1862331.28,1862331.28,'595','2021-04-11 22:09:00','607','2021-04-12 09:59:16',10,0),('5','104',190278,'daily shift ','2021-04-12','2021-04-12 00:00:00',NULL,'595',355431.25,355431.25,'595','2021-04-12 22:09:38','607','2021-04-13 07:28:05',10,0),('5','104',190457,'daily shift ','2021-04-13','2021-04-13 00:00:00',NULL,'595',3240403.08,3274349.60,'595','2021-04-14 11:55:26','607','2021-04-14 13:40:30',10,0),('5','104',190806,'daily shift ','2021-04-14','2021-04-14 00:00:00',NULL,'595',2948205.60,2948205.60,'595','2021-04-15 05:45:57','607','2021-04-15 08:12:17',10,0),('5','104',190917,'daily shift ','2021-04-15','2021-04-15 00:00:00',NULL,'595',2468725.00,2468725.00,'595','2021-04-16 07:15:17','607','2021-04-16 08:37:53',10,0),('5','104',191744,'daily shift ','2021-04-16','2021-04-16 00:00:00',NULL,'595',3369967.45,3369967.45,'595','2021-04-19 09:47:49','607','2021-04-19 10:18:05',10,0),('5','104',191797,'daily shift ','2021-04-17','2021-04-17 00:00:00',NULL,'595',2565339.45,2565339.45,'595','2021-04-19 11:02:53','607','2021-04-19 11:05:38',10,0),('5','104',191811,'daily shift ','2021-04-18','2021-04-18 00:00:00',NULL,'595',2128993.35,2128993.35,'595','2021-04-19 11:30:44','607','2021-04-19 11:43:31',10,0),('5','104',191829,'daily shift ','2021-04-19','2021-04-19 00:00:00',NULL,'595',3302449.85,3302449.85,'595','2021-04-19 23:08:37','607','2021-04-20 08:59:07',10,0),('5','104',191977,'daily shift ','2021-04-20','2021-04-20 00:00:00',NULL,'595',602650.70,602650.70,'595','2021-04-20 22:41:19','607','2021-04-21 10:42:59',10,0),('5','104',192259,'daily shift ','2021-04-21','2021-04-21 00:00:00',NULL,'595',456173.65,456173.65,'595','2021-04-21 21:51:23','607','2021-04-22 08:12:47',10,0),('5','104',192378,'daily shift ','2021-04-22','2021-04-22 00:00:00',NULL,'595',276988.60,276988.60,'595','2021-04-22 22:11:13','607','2021-04-23 09:20:37',10,0),('5','104',192611,'daily shift ','2021-04-23','2021-04-23 00:00:00',NULL,'595',2928402.70,2928402.70,'595','2021-04-23 22:36:33','607','2021-04-24 08:56:54',10,0),('5','104',192800,'daily shift ','2021-04-24','2021-04-24 00:00:00',NULL,'595',2103690.70,2103690.70,'595','2021-04-24 21:33:43','607','2021-04-25 08:06:24',10,0),('5','104',193041,'daily shift ','2021-04-25','2021-04-25 00:00:00',NULL,'595',769409.10,769409.10,'595','2021-04-25 21:19:32','607','2021-04-26 08:00:51',10,0),('5','104',193245,'daily shift ','2021-04-26','2021-04-26 00:00:00',NULL,'595',229437.00,229437.00,'595','2021-04-26 21:38:59','607','2021-04-27 07:26:48',10,0),('5','104',193429,'daily shift ','2021-04-27','2021-04-27 00:00:00',NULL,'595',1884854.40,1884854.40,'595','2021-04-28 21:36:37','607','2021-04-29 08:25:23',10,0),('5','104',193898,'daily shift ','2021-04-28','2021-04-28 00:00:00',NULL,'595',326308.45,326308.45,'595','2021-04-29 08:58:33','607','2021-04-29 09:19:00',10,0),('5','104',193914,'daily shift ','2021-04-29','2021-04-29 00:00:00',NULL,'595',135616.40,135616.40,'595','2021-04-29 20:27:12','607','2021-04-30 09:21:59',10,0),('5','104',194151,'daily shift ','2021-04-30','2021-04-30 00:00:00',NULL,'595',361380.50,361380.50,'595','2021-04-30 19:50:48','607','2021-05-01 10:57:37',10,0),('5','104',194394,'daily shift ','2021-05-01','2021-05-01 00:00:00',NULL,'595',120508.75,120508.75,'595','2021-05-01 22:24:24','607','2021-05-02 08:55:56',10,0),('5','104',194565,'daily shift ','2021-05-02','2021-05-02 00:00:00',NULL,'595',139382.05,139382.05,'595','2021-05-02 22:10:50','607','2021-05-04 03:44:13',10,0),('5','104',194936,'daily shift ','2021-05-03','2021-05-03 00:00:00',NULL,'595',1143505.00,1143505.00,'595','2021-05-04 15:03:49','607','2021-05-04 20:06:00',10,0),('5','104',195057,'daily shift ','2021-05-04','2021-05-04 00:00:00',NULL,'595',1697611.60,1697611.60,'595','2021-05-04 22:01:44','607','2021-05-05 11:05:38',10,0),('5','104',195178,'daily shift ','2021-05-05','2021-05-05 00:00:00',NULL,'595',2427243.95,2427243.95,'595','2021-05-05 21:17:38','607','2021-05-06 09:08:30',10,0),('5','104',195400,'daily shift ','2021-05-06','2021-05-06 00:00:00',NULL,'595',2743840.90,2743840.90,'595','2021-05-06 21:46:41','607','2021-05-07 16:10:57',10,0),('5','104',195727,'daily shift ','2021-05-07','2021-05-07 00:00:00',NULL,'595',3055473.60,3055473.60,'595','2021-05-08 08:47:52','607','2021-05-08 12:00:58',10,0),('5','104',195879,'daily shift ','2021-05-08','2021-05-08 00:00:00',NULL,'595',909732.55,909732.55,'595','2021-05-08 18:07:01','607','2021-05-09 10:13:04',10,0),('5','104',196107,'daily shift ','2021-05-09','2021-05-09 00:00:00',NULL,'595',47419.10,47419.10,'595','2021-05-09 22:28:56','607','2021-05-10 10:15:05',10,0),('5','104',196316,'daily shift ','2021-05-10','2021-05-10 00:00:00',NULL,'595',143277.55,143277.55,'595','2021-05-10 21:41:03','607','2021-05-11 09:26:22',10,0),('5','104',196516,'daily shift ','2021-05-11','2021-05-11 00:00:00',NULL,'595',96876.05,96876.05,'595','2021-05-11 22:03:47','607','2021-05-12 11:03:56',10,0),('5','104',196811,'daily shift ','2021-05-12','2021-05-12 00:00:00',NULL,'595',44702.85,44702.85,'595','2021-05-12 23:47:51','607','2021-05-12 23:59:24',10,0),('5','104',196859,'daily shift ','2021-05-13','2021-05-13 00:00:00',NULL,'595',1296897.85,1296897.85,'595','2021-05-14 08:50:28','607','2021-05-14 21:38:16',10,0),('5','104',197210,'daily shift ','2021-05-14','2021-05-14 00:00:00',NULL,'595',1668854.50,1668854.50,'595','2021-05-16 11:47:43','607','2021-05-16 15:23:26',10,0),('5','104',197500,'daily shift ','2021-05-15','2021-05-15 00:00:00',NULL,'595',2177139.30,2177139.30,'595','2021-05-17 17:41:27','607','2021-05-18 06:39:24',10,0),('5','104',197992,'daily shift ','2021-05-16','2021-05-16 00:00:00',NULL,'595',2057424.15,2057424.15,'595','2021-05-18 13:00:39','607','2021-05-18 13:03:06',10,0),('5','104',198009,'daily shift ','2021-05-17','2021-05-17 00:00:00',NULL,'595',2345462.35,2348908.65,'595','2021-05-18 13:13:41','607','2021-05-18 13:15:14',10,0),('5','104',198016,'daily shift ','2021-05-18','2021-05-18 00:00:00',NULL,'595',1808874.50,1813372.20,'595','2021-05-18 21:59:35','607','2021-05-19 11:10:38',10,0),('5','104',198220,'daily shift ','2021-05-19','2021-05-19 00:00:00',NULL,'595',2133206.60,2146757.10,'595','2021-05-20 09:33:25','607','2021-05-20 10:38:51',10,0),('5','104',198434,'daily shift ','2021-05-20','2021-05-20 00:00:00',NULL,'595',1776311.75,1779736.95,'595','2021-05-21 05:42:08','607','2021-05-21 13:41:36',10,0),('5','104',198744,'daily shift ','2021-05-21','2021-05-21 00:00:00',NULL,'595',1957852.25,1963822.95,'595','2021-05-21 22:18:26','607','2021-05-22 09:01:15',10,0),('5','104',198834,'daily shift ','2021-05-22','2021-05-22 00:00:00',NULL,'595',2037348.90,2046670.65,'595','2021-05-23 04:43:50','607','2021-05-23 09:30:30',10,0),('5','104',199044,'daily shift ','2021-05-23','2021-05-23 00:00:00',NULL,'595',1515960.25,1518451.65,'595','2021-05-24 01:15:04','607','2021-05-24 07:55:52',10,0),('5','104',199296,'daily shift ','2021-05-24','2021-05-24 00:00:00',NULL,'595',2086053.60,2093129.70,'595','2021-05-24 22:49:29','607','2021-05-25 08:00:41',10,0),('5','104',199602,'daily shift ','2021-05-25','2021-05-25 00:00:00',NULL,'595',2036012.45,2045786.55,'595','2021-05-25 23:02:35','607','2021-05-26 08:35:47',10,0),('5','104',199774,'daily shift ','2021-05-26','2021-05-26 00:00:00',NULL,'595',1737958.20,1742944.50,'595','2021-05-27 10:49:08','607','2021-05-27 11:05:25',10,0),('5','104',199981,'daily shift ','2021-05-27','2021-05-27 00:00:00',NULL,'595',2109623.40,2119728.30,'595','2021-05-28 09:09:32','607','2021-05-28 09:14:27',10,0),('5','104',200157,'daily shift ','2021-05-28','2021-05-28 00:00:00',NULL,'595',1994533.35,1998523.80,'595','2021-05-28 22:39:23','607','2021-05-29 08:12:22',10,0),('5','104',200326,'daily shift ','2021-05-29','2021-05-29 00:00:00',NULL,'595',1604895.60,1604895.60,'595','2021-05-30 08:08:27','607','2021-05-30 08:11:01',10,0),('5','104',200521,'daily shift ','2021-05-30','2021-05-30 00:00:00',NULL,'595',1548341.85,1548341.85,'595','2021-05-30 21:30:51','607','2021-05-31 08:31:16',10,0),('5','104',200755,'daily shift ','2021-05-31','2021-05-31 00:00:00',NULL,'595',1700118.75,1700118.75,'595','2021-05-31 22:40:19','607','2021-06-01 09:17:50',10,0),('5','104',200976,'daily shift ','2021-06-01','2021-06-01 00:00:00',NULL,'595',1651206.15,1651206.15,'595','2021-06-01 22:41:42','607','2021-06-02 08:29:47',10,0),('5','104',201190,'daily shift ','2021-06-02','2021-06-02 00:00:00',NULL,'595',1742337.30,1742337.30,'595','2021-06-02 22:04:16','607','2021-06-03 08:36:43',10,0),('5','104',201365,'daily shift ','2021-06-03','2021-06-03 00:00:00',NULL,'595',1664046.45,1664046.45,'595','2021-06-04 07:47:00','607','2021-06-04 08:56:31',10,0),('5','104',201572,'daily shift ','2021-06-04','2021-06-04 00:00:00',NULL,'595',2070219.95,2076826.20,'595','2021-06-05 06:15:29','607','2021-06-05 07:35:05',10,0),('5','104',201784,'daily shift ','2021-06-05','2021-06-05 00:00:00',NULL,'595',1589358.75,1592873.15,'595','2021-06-05 22:39:58','607','2021-06-06 06:54:24',10,0),('5','104',202061,'daily shift ','2021-06-06','2021-06-06 00:00:00',NULL,'595',1602709.95,1605768.45,'595','2021-06-06 22:15:04','607','2021-06-06 22:20:46',10,0),('5','104',202196,'daily shift ','2021-06-07','2021-06-07 00:00:00',NULL,'595',1685701.20,1690251.20,'595','2021-06-08 05:06:52','607','2021-06-08 05:27:58',10,0),('5','104',202422,'daily shift ','2021-06-08','2021-06-08 00:00:00',NULL,'595',1521073.40,1521073.40,'595','2021-06-09 11:02:17','607','2021-06-09 11:15:19',10,0),('5','104',202746,'daily shift ','2021-06-09','2021-06-09 00:00:00',NULL,'595',1666922.40,1666922.40,'595','2021-06-09 22:11:18','607','2021-06-09 22:15:29',10,0),('5','104',202906,'daily shift ','2021-06-10','2021-06-10 00:00:00',NULL,'595',1685047.65,1685047.65,'595','2021-06-10 21:10:18','607','2021-06-10 21:11:43',10,0),('5','104',203095,'daily shift ','2021-06-11','2021-06-11 00:00:00',NULL,'595',1773774.75,1773774.75,'595','2021-06-11 22:00:13','607','2021-06-12 05:42:18',10,0),('5','104',203301,'daily shift ','2021-06-12','2021-06-12 00:00:00',NULL,'595',1672081.95,1672081.95,'595','2021-06-12 21:57:34','607','2021-06-13 05:51:57',10,0),('5','104',203535,'daily shift ','2021-06-13','2021-06-13 00:00:00',NULL,'595',1646026.80,1646026.80,'595','2021-06-13 22:10:11','607','2021-06-13 22:12:15',10,0),('5','104',203893,'daily shift ','2021-06-14','2021-06-14 00:00:00',NULL,'595',2139560.50,2139560.50,'595','2021-06-14 22:33:38','607','2021-06-14 22:50:57',10,0),('5','104',203986,'daily shift ','2021-06-15','2021-06-15 00:00:00',NULL,'595',1913584.75,1913584.75,'595','2021-06-15 22:26:33','607','2021-06-16 07:44:00',10,0),('5','104',204221,'daily shift ','2021-06-16','2021-06-16 00:00:00',NULL,'595',1720997.30,1720997.30,'595','2021-06-16 21:49:45','607','2021-06-16 22:08:40',10,0),('5','104',204469,'daily shift ','2021-06-17','2021-06-17 00:00:00',NULL,'595',1689327.75,1689327.75,'595','2021-06-17 21:43:32','607','2021-06-17 21:48:58',10,0),('5','104',204662,'daily shift ','2021-06-18','2021-06-18 00:00:00',NULL,'595',1929145.90,1929145.90,'595','2021-06-18 22:10:42','607','2021-06-19 06:11:14',10,0),('5','104',204902,'daily shift ','2021-06-19','2021-06-19 00:00:00',NULL,'595',1497985.50,1497985.50,'595','2021-06-20 11:07:09','607','2021-06-20 11:16:37',10,0),('5','104',205122,'daily shift ','2021-06-20','2021-06-20 00:00:00',NULL,'595',1186170.15,1186170.15,'595','2021-06-20 23:01:06','607','2021-06-21 05:28:46',10,0),('5','104',205255,'daily shift ','2021-06-21','2021-06-21 00:00:00',NULL,'595',1805791.35,1805791.35,'595','2021-06-21 22:00:19','607','2021-06-22 07:10:46',10,0),('5','104',205489,'daily shift ','2021-06-22','2021-06-22 00:00:00',NULL,'595',1287831.60,1287831.60,'595','2021-06-22 21:43:28','607','2021-06-22 22:12:45',10,0),('5','104',205752,'daily shift ','2021-06-23','2021-06-23 00:00:00',NULL,'595',1343408.55,1343408.55,'595','2021-06-23 21:28:38','607','2021-06-24 05:05:13',10,0),('5','104',205959,'daily shift ','2021-06-24','2021-06-24 00:00:00',NULL,'595',1177494.45,1177494.45,'595','2021-06-25 06:22:59','607','2021-06-25 08:19:52',10,0),('5','104',206234,'daily shift ','2021-06-25','2021-06-25 00:00:00',NULL,'595',396734.25,396734.25,'595','2021-06-25 18:12:37','607','2021-06-25 20:13:46',10,0),('5','104',206351,'daily shift ','2021-06-26','2021-06-26 00:00:00',NULL,'595',308736.45,308736.45,'595','2021-06-27 11:04:46','607','2021-06-27 11:12:18',10,0),('5','104',206682,'daily shift ','2021-06-27','2021-06-27 00:00:00',NULL,'595',1254546.15,1254546.15,'595','2021-06-27 22:43:34','607','2021-06-27 22:55:20',10,0),('5','104',206837,'daily shift ','2021-06-28','2021-06-28 00:00:00',NULL,'595',1691812.65,1691812.65,'595','2021-06-28 21:44:05','607','2021-06-29 02:55:44',10,0),('5','104',207058,'daily shift ','2021-06-29','2021-06-29 00:00:00',NULL,'595',1485165.00,1485165.00,'595','2021-06-29 21:59:09','607','2021-06-30 05:33:01',10,0),('5','104',207250,'daily shift ','2021-06-30','2021-06-30 00:00:00',NULL,'595',1282116.00,1282116.00,'595','2021-06-30 22:55:42','607','2021-07-01 07:04:47',10,0),('5','104',207494,'daily shift ','2021-07-01','2021-07-01 00:00:00',NULL,'595',1528145.85,1528145.85,'595','2021-07-02 00:05:08','607','2021-07-02 06:13:49',10,0),('5','104',207732,'daily shift ','2021-07-02','2021-07-02 00:00:00',NULL,'595',1583278.95,1583278.95,'595','2021-07-02 21:09:45','607','2021-07-02 22:40:37',10,0),('5','104',207916,'daily shift ','2021-07-03','2021-07-03 00:00:00',NULL,'595',1385602.35,1385602.35,'595','2021-07-03 22:40:07','607','2021-07-03 22:56:17',10,0),('5','104',208138,'daily shift ','2021-07-04','2021-07-04 00:00:00',NULL,'595',1250051.55,1250051.55,'595','2021-07-04 22:24:56','607','2021-07-04 22:37:27',10,0),('5','104',208314,'daily shift ','2021-07-05','2021-07-05 00:00:00',NULL,'595',1543487.55,1543487.55,'595','2021-07-06 09:03:26','607','2021-07-06 09:05:50',10,0),('5','104',208606,'daily shift ','2021-07-06','2021-07-06 00:00:00',NULL,'595',1344436.50,1344436.50,'595','2021-07-06 22:25:32','607','2021-07-07 06:10:15',10,0),('5','104',208792,'daily shift ','2021-07-07','2021-07-07 00:00:00',NULL,'595',1269198.15,1269198.15,'595','2021-07-07 21:50:24','607','2021-07-08 06:37:18',10,0),('5','104',209020,'daily shift ','2021-07-08','2021-07-08 00:00:00',NULL,'595',1383368.25,1383368.25,'595','2021-07-08 22:26:44','607','2021-07-08 22:56:13',10,0),('5','104',209226,'daily shift ','2021-07-09','2021-07-09 00:00:00',NULL,'595',1473408.75,1473408.75,'595','2021-07-09 22:05:19','607','2021-07-09 22:09:05',10,0),('5','104',209502,'daily shift ','2021-07-10','2021-07-10 00:00:00',NULL,'595',808767.30,808767.30,'595','2021-07-10 20:06:49','607','2021-07-10 22:27:01',10,0),('5','104',209638,'daily shift ','2021-07-11','2021-07-11 00:00:00',NULL,'595',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','104',210416,'daily shift ','2021-07-13','2021-07-13 00:00:00',NULL,'595',1128809.55,1128809.55,'595','2021-07-14 14:47:48','607','2021-07-14 14:54:01',10,0),('5','104',210450,'daily shift ','2021-07-14','2021-07-14 00:00:00',NULL,'595',1344273.15,1344273.15,'595','2021-07-14 22:24:55','607','2021-07-15 10:19:36',10,0),('5','104',210598,'daily shift ','2021-07-15','2021-07-15 00:00:00',NULL,'595',1475306.25,1475306.25,'595','2021-07-15 22:08:09','607','2021-07-15 22:22:23',10,0),('5','104',210760,'daily shift ','2021-07-16','2021-07-16 00:00:00',NULL,'595',1654288.35,2957667.05,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','104',211437,'daily shift ','2021-07-16','2021-07-16 00:00:00',NULL,'595',1654281.75,1654281.75,'595','2021-07-19 09:19:48','607','2021-07-19 09:45:44',10,0),('5','104',211450,'daily shift ','2021-07-19','2021-07-19 00:00:00',NULL,'595',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','104',211469,'daily shift ','2021-07-17','2021-07-17 00:00:00',NULL,'595',923313.60,923313.60,'595','2021-07-19 10:37:49','607','2021-07-19 10:41:17',10,0),('5','104',211473,'daily shift ','2021-07-18','2021-07-18 00:00:00',NULL,'595',440772.75,440772.75,'595','2021-07-19 11:13:15','607','2021-07-19 11:19:50',10,0),('5','104',211502,'daily shift ','2021-07-19','2021-07-19 00:00:00',NULL,'595',2118139.65,2118139.65,'595','2021-07-20 05:18:17','607','2021-07-20 07:56:48',10,0),('5','104',211612,'daily shift ','2021-07-20','2021-07-20 00:00:00',NULL,'595',1456400.55,1456400.55,'595','2021-07-21 05:39:22','607','2021-07-21 07:27:48',10,0),('5','104',211812,'daily shift ','2021-07-21','2021-07-21 00:00:00',NULL,'595',1376142.90,1376142.90,'595','2021-07-22 07:56:03','607','2021-07-22 08:16:06',10,0),('5','104',212045,'daily shift ','2021-07-22','2021-07-22 00:00:00',NULL,'595',1145062.05,1145062.05,'595','2021-07-22 22:38:45','607','2021-07-22 23:22:41',10,0),('5','104',212255,'daily shift ','2021-07-23','2021-07-23 00:00:00',NULL,'595',1401622.20,1401622.20,'595','2021-07-23 23:24:02','607','2021-07-24 07:12:25',10,0),('5','104',212494,'daily shift ','2021-07-24','2021-07-24 00:00:00',NULL,'595',1260758.40,1260758.40,'595','2021-07-25 05:45:12','607','2021-07-25 07:04:08',10,0),('5','104',212697,'daily shift ','2021-07-25','2021-07-25 00:00:00',NULL,'595',1472342.85,1472342.85,'595','2021-07-25 22:38:48','607','2021-07-25 22:46:25',10,0),('5','104',212865,'daily shift ','2021-07-26','2021-07-26 00:00:00',NULL,'595',1320105.60,1320105.60,'595','2021-07-27 06:03:47','607','2021-07-27 06:25:06',10,0),('5','104',213257,'daily shift ','2021-07-27','2021-07-27 00:00:00',NULL,'595',1412279.55,1412279.55,'595','2021-07-28 15:44:32','607','2021-07-28 15:50:46',10,0),('5','104',213582,'Daly shift ','2021-07-28','2021-07-28 00:00:00',NULL,'595',1435229.40,1435229.40,'595','2021-07-28 21:58:41','607','2021-07-29 06:00:05',10,0),('5','104',213676,'Daly shift ','2021-07-29','2021-07-29 00:00:00',NULL,'595',1173468.45,1173468.45,'595','2021-07-29 22:51:04','607','2021-07-29 23:02:01',10,0),('5','104',213910,'Daly shift ','2021-07-30','2021-07-30 00:00:00',NULL,'595',1413218.70,1413218.70,'595','2021-07-30 23:08:25','607','2021-07-31 08:28:47',10,0),('5','104',214129,'Daly shift ','2021-07-31','2021-07-31 00:00:00',NULL,'595',1757262.55,1757262.55,'595','2021-08-01 10:06:54','607','2021-08-01 10:23:36',10,0),('5','104',214436,'Daly shift ','2021-08-01','2021-08-01 00:00:00',NULL,'595',1218904.05,1218904.05,'595','2021-08-02 11:16:26','607','2021-08-02 11:21:53',10,0),('5','104',214646,'Daly shift ','2021-08-02','2021-08-02 00:00:00',NULL,'595',1483540.95,1483540.95,'595','2021-08-02 21:05:25','607','2021-08-02 21:33:08',10,0),('5','104',214777,'Daly shift ','2021-08-03','2021-08-03 00:00:00',NULL,'595',1536670.10,1536670.10,'595','2021-08-03 21:15:21','607','2021-08-03 23:17:41',10,0),('5','104',214998,'Daly shift ','2021-08-04','2021-08-04 00:00:00',NULL,'595',1401771.50,1401771.50,'595','2021-08-04 23:20:13','607','2021-08-05 06:40:34',10,0),('5','104',215235,'Daly shift ','2021-08-05','2021-08-05 00:00:00',NULL,'595',1377421.30,1377421.30,'595','2021-08-07 09:59:30','607','2021-08-07 10:26:59',10,0),('5','104',215828,'Daly shift ','2021-08-06','2021-08-06 00:00:00',NULL,'595',1569451.35,1569451.35,'595','2021-08-07 16:12:30','607','2021-08-07 16:18:28',10,0),('5','104',215852,'Daly shift ','2021-08-07','2021-08-07 00:00:00',NULL,'595',1329036.10,1329036.10,'595','2021-08-07 22:56:48','607','2021-08-08 01:01:11',10,0),('5','104',215934,'Daly shift ','2021-08-08','2021-08-08 00:00:00',NULL,'595',1239526.65,1239526.65,'595','2021-08-08 22:16:11','607','2021-08-09 08:00:59',10,0),('5','104',216144,'Daly shift ','2021-08-09','2021-08-09 00:00:00',NULL,'595',1361983.90,1361983.90,'595','2021-08-10 00:36:36','607','2021-08-10 06:15:32',10,0),('5','104',216369,'Daly shift ','2021-08-10','2021-08-10 00:00:00',NULL,'595',1555163.75,1555163.75,'595','2021-08-10 22:53:56','607','2021-08-11 07:04:41',10,0),('5','104',216579,'Daly shift ','2021-08-11','2021-08-11 00:00:00',NULL,'595',1443323.10,1443323.10,'595','2021-08-11 22:30:43','607','2021-08-12 10:49:38',10,0),('5','104',216921,'Daly shift ','2021-08-12','2021-08-12 00:00:00',NULL,'595',1573033.15,1573033.15,'595','2021-08-13 14:28:24','607','2021-08-13 15:53:53',10,0),('5','104',217257,'Daly shift ','2021-08-13','2021-08-13 00:00:00',NULL,'595',1235731.10,1235731.10,'595','2021-08-13 22:50:59','607','2021-08-14 06:42:18',10,0),('5','104',217284,'Daly shift ','2021-08-14','2021-08-14 00:00:00',NULL,'595',1161235.40,1161235.40,'595','2021-08-14 22:28:27','607','2021-08-14 22:59:17',10,0),('5','104',217696,'Daly shift ','2021-08-15','2021-08-15 00:00:00',NULL,'595',1286016.10,1286016.10,'595','2021-08-16 00:09:44','607','2021-08-16 06:13:06',10,0),('5','104',217803,'Daly shift ','2021-08-16','2021-08-16 00:00:00',NULL,'595',1258612.10,1258612.10,'595','2021-08-16 21:56:12','607','2021-08-17 05:41:28',10,0),('5','104',218009,'Daly shift ','2021-08-17','2021-08-17 00:00:00',NULL,'595',1432816.80,1432816.80,'595','2021-08-17 22:57:20','607','2021-08-17 23:11:14',10,0),('5','104',218209,'Daly shift ','2021-08-18','2021-08-18 00:00:00',NULL,'595',1262774.35,1262774.35,'595','2021-08-18 21:53:28','607','2021-08-18 22:44:53',10,0),('5','104',218447,'Daly shift ','2021-08-19','2021-08-19 00:00:00',NULL,'595',1170897.25,1170897.25,'595','2021-08-19 22:29:35','607','2021-08-20 06:29:01',10,0),('5','104',218711,'Daly shift ','2021-08-20','2021-08-20 00:00:00',NULL,'595',683392.30,683392.30,'595','2021-08-20 19:49:13','607','2021-08-20 23:06:20',10,0),('5','104',218935,'Daly shift ','2021-08-21','2021-08-21 00:00:00',NULL,'595',237095.45,237095.45,'595','2021-08-21 21:53:42','607','2021-08-21 23:05:02',10,0),('5','104',219163,'Daly shift ','2021-08-22','2021-08-22 00:00:00',NULL,'595',1168740.60,1168740.60,'595','2021-08-22 22:10:39','607','2021-08-22 23:27:25',10,0),('5','104',219337,'Daly shift ','2021-08-23','2021-08-23 00:00:00',NULL,'595',1388685.50,1388685.50,'595','2021-08-23 22:48:36','607','2021-08-24 05:11:02',10,0),('5','104',219610,'Daly shift ','2021-08-24','2021-08-24 00:00:00',NULL,'595',1152502.15,1152502.15,'595','2021-08-24 22:17:13','607','2021-08-24 22:26:50',10,0),('5','104',219844,'Daly shift ','2021-08-25','2021-08-25 00:00:00',NULL,'595',1124730.65,1124730.65,'595','2021-08-25 22:35:02','607','2021-08-26 05:22:23',10,0),('5','104',220034,'Daly shift ','2021-08-26','2021-08-26 00:00:00',NULL,'595',1206889.60,1206889.60,'595','2021-08-26 22:10:35','607','2021-08-27 05:50:23',10,0),('5','104',220311,'Daly shift ','2021-08-27','2021-08-27 00:00:00',NULL,'595',1143727.75,1143727.75,'595','2021-08-28 07:38:44','607','2021-08-28 21:16:44',10,0),('5','104',220670,'Daly shift ','2021-08-28','2021-08-28 00:00:00',NULL,'595',1034036.00,1034036.00,'595','2021-08-28 21:33:34','607','2021-08-28 21:38:12',10,0),('5','104',220713,'Daly shift ','2021-08-29','2021-08-29 00:00:00',NULL,'595',1035395.35,1035395.35,'595','2021-08-29 21:51:07','607','2021-08-30 00:08:58',10,0),('5','104',220894,'Daly shift ','2021-08-30','2021-08-30 00:00:00',NULL,'595',1227500.75,1227500.75,'595','2021-08-30 23:41:42','607','2021-08-31 07:02:50',10,0),('5','104',221173,'Daly shift ','2021-08-31','2021-08-31 00:00:00',NULL,'595',1123850.20,1123850.20,'595','2021-09-01 14:38:22','607','2021-09-01 14:43:40',10,0),('5','104',221564,'Daly shift ','2021-09-01','2021-09-01 00:00:00',NULL,'595',1368870.80,1368870.80,'595','2021-09-02 06:39:22','607','2021-09-02 06:42:46',10,0),('5','104',221627,'Daly shift ','2021-09-02','2021-09-02 00:00:00',NULL,'595',1174284.25,1174284.25,'595','2021-09-02 20:34:12','607','2021-09-02 22:08:54',10,0),('5','104',221827,'Daly shift ','2021-09-03','2021-09-03 00:00:00',NULL,'595',1193668.85,1193668.85,'595','2021-09-03 21:28:22','607','2021-09-04 07:08:37',10,0),('5','104',222588,'Daly shift ','2021-09-04','2021-09-04 00:00:00',NULL,'595',1119860.05,1119860.05,'595','2021-09-06 12:00:07','607','2021-09-06 12:03:06',10,0),('5','104',222607,'Daly shift ','2021-09-05','2021-09-05 00:00:00',NULL,'595',1020448.30,1020448.30,'595','2021-09-06 12:07:59','607','2021-09-06 12:16:08',10,0),('5','104',222611,'Daly shift ','2021-09-06','2021-09-06 00:00:00',NULL,'595',1111408.60,1111408.60,'595','2021-09-08 13:21:36','607','2021-09-08 13:49:57',10,0),('5','104',223075,'Daly shift ','2021-09-07','2021-09-07 00:00:00',NULL,'595',1112304.90,1112304.90,'595','2021-09-08 13:58:31','607','2021-09-08 14:04:21',10,0),('5','104',223084,'Daly shift ','2021-09-08','2021-09-08 00:00:00',NULL,'595',1095991.50,1095991.50,'595','2021-09-10 14:09:47','607','2021-09-10 18:08:55',10,0),('5','104',223622,'Daly shift ','2021-09-09','2021-09-09 00:00:00',NULL,'595',1060493.75,1060493.75,'595','2021-09-10 21:59:40','607','2021-09-11 05:29:21',10,0),('5','104',223676,'Daly shift ','2021-09-10','2021-09-10 00:00:00',NULL,'595',1189928.10,1189928.10,'595','2021-09-14 12:21:03','607','2021-09-14 12:24:14',10,0),('5','104',224423,'Daly shift ','2021-09-11','2021-09-11 00:00:00',NULL,'595',1125862.85,1125862.85,'595','2021-09-14 12:43:13','607','2021-09-14 12:49:12',10,0),('5','104',224427,'Daly shift ','2021-09-12','2021-09-12 00:00:00',NULL,'595',1033175.80,1033175.80,'595','2021-09-14 12:56:39','607','2021-09-14 13:01:17',10,0),('5','104',224429,'Daly shift ','2021-09-13','2021-09-13 00:00:00',NULL,'595',1133328.65,1133328.65,'595','2021-09-14 13:04:03','607','2021-09-14 13:06:07',10,0),('5','104',224432,'Daly shift ','2021-09-14','2021-09-14 00:00:00',NULL,'595',801177.30,801177.30,'595','2021-09-20 14:02:13','607','2021-09-20 15:13:01',10,0),('5','104',225903,'Daly shift ','2021-09-15','2021-09-15 00:00:00',NULL,'595',704290.40,712932.00,'595','2021-09-20 15:15:44','607','2021-09-20 15:17:14',10,0),('5','104',225905,'Daly shift ','2021-09-16','2021-09-16 00:00:00',NULL,'595',287905.27,291437.85,'595','2021-09-20 15:23:58','607','2021-09-20 15:26:11',10,0),('5','104',225908,'Daly shift ','2021-09-17','2021-09-17 00:00:00',NULL,'595',0.00,0.00,'595','2021-09-20 15:31:32','607','2021-09-20 15:34:03',10,0),('5','104',225911,'Daly shift ','2021-09-18','2021-09-18 00:00:00',NULL,'595',0.00,0.00,'595','2021-09-20 15:41:11','607','2021-09-20 15:42:29',10,0),('5','104',225913,'Daly shift ','2021-09-19','2021-09-19 00:00:00',NULL,'595',471415.56,471415.56,'595','2021-09-20 15:46:43','607','2021-09-20 15:47:37',10,0),('5','104',225915,'Daly shift ','2021-09-20','2021-09-20 00:00:00',NULL,'595',1037737.87,1037737.87,'595','2021-09-24 09:20:19','607','2021-09-24 09:22:04',10,0),('5','104',226807,'Daly shift ','2021-09-21','2021-09-21 00:00:00',NULL,'595',1530522.73,1530522.73,'595','2021-09-24 09:27:35','607','2021-09-24 09:29:16',10,0),('5','104',226810,'Daly shift ','2021-09-22','2021-09-22 00:00:00',NULL,'595',1188191.76,1188191.76,'595','2021-09-24 09:39:43','607','2021-09-24 09:41:35',10,0),('5','104',226817,'Daly shift ','2021-09-23','2021-09-23 00:00:00',NULL,'595',1263664.02,1263664.02,'595','2021-09-24 09:49:57','607','2021-09-24 09:50:30',10,0),('5','104',226819,'Daly shift ','2021-09-24','2021-09-24 00:00:00',NULL,'595',1128879.32,1128879.32,'595','2021-09-28 11:14:24','607','2021-09-28 11:36:50',10,0),('5','104',227714,'Daly shift ','2021-09-25','2021-09-25 00:00:00',NULL,'595',1018670.13,1031169.15,'595','2021-09-28 12:32:42','607','2021-09-28 12:34:10',10,0),('5','104',227737,'Daly shift ','2021-09-26','2021-09-26 00:00:00',NULL,'595',964386.24,964386.24,'595','2021-09-28 12:55:48','607','2021-09-28 12:59:52',10,0),('5','104',227740,'Daly shift ','2021-09-27','2021-09-27 00:00:00',NULL,'595',979052.98,979052.98,'595','2021-09-28 13:14:35','607','2021-09-28 13:19:24',10,0),('5','104',227748,'Daly shift ','2021-09-28','2021-09-28 00:00:00',NULL,'595',1027173.84,1027173.84,'595','2021-10-05 13:02:53','607','2021-10-05 13:08:58',10,0),('5','104',229293,'Daly shift ','2021-09-29','2021-09-29 00:00:00',NULL,'595',1002153.34,1002153.34,'595','2021-10-05 13:16:18','607','2021-10-05 13:23:15',10,0),('5','104',229301,'Daly shift ','2021-09-30','2021-09-30 00:00:00',NULL,'595',1084644.38,1084644.38,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','104',229350,'Daly shift ','2021-09-30','2021-09-30 00:00:00',NULL,'595',1084644.38,1084644.38,'595','2021-10-05 15:31:11','607','2021-10-05 15:45:56',10,0),('5','104',229509,'Daly shift ','2021-10-01','2021-10-01 00:00:00',NULL,'595',766642.79,766642.79,'595','2021-10-13 14:03:10','607','2021-10-13 14:08:21',10,0),('5','104',231244,'Daly shift ','2021-10-02','2021-10-02 00:00:00',NULL,'595',466243.57,466243.57,'595','2021-10-13 14:15:16','607','2021-10-13 14:15:49',10,0),('5','104',231251,'Daly shift ','2021-10-03','2021-10-03 00:00:00',NULL,'595',0.00,0.00,'595','2021-10-13 14:18:36','607','2021-10-13 14:21:53',10,0),('5','104',231256,'Daly shift ','2021-10-04','2021-10-04 00:00:00',NULL,'595',0.00,0.00,'595','2021-10-13 14:23:20','607','2021-10-13 14:28:18',10,0),('5','104',231261,'Daly shift ','2021-10-05','2021-10-05 00:00:00',NULL,'595',0.00,0.00,'595','2021-10-13 14:36:10','607','2021-10-13 14:36:51',10,0),('5','104',231267,'Daly shift ','2021-10-06','2021-10-06 00:00:00',NULL,'595',0.00,0.00,'595','2021-10-13 14:38:47','607','2021-10-13 14:39:39',10,0),('5','104',231268,'Daly shift ','2021-10-07','2021-10-07 00:00:00',NULL,'595',162237.16,162237.16,'595','2021-10-13 14:43:10','607','2021-10-13 14:44:48',10,0),('5','104',231277,'Daly shift ','2021-10-08','2021-10-08 00:00:00',NULL,'595',1210933.52,1210933.52,'595','2021-10-13 14:56:48','607','2021-10-13 14:58:06',10,0),('5','104',231283,'Daly shift ','2021-10-09','2021-10-09 00:00:00',NULL,'595',1200252.13,1200252.13,'595','2021-10-13 15:18:14','607','2021-10-13 15:20:24',10,0),('5','104',231286,'Daly shift ','2021-10-10','2021-10-10 00:00:00',NULL,'595',1459159.70,1459159.70,'595','2021-10-13 15:27:39','607','2021-10-13 15:29:20',10,0),('5','104',231288,'Daly shift ','2021-10-11','2021-10-11 00:00:00',NULL,'595',1378329.63,1378329.63,'595','2021-10-13 15:42:09','607','2021-10-13 15:43:19',10,0),('5','104',231295,'Daly shift ','2021-10-12','2021-10-12 00:00:00',NULL,'595',981022.02,981022.02,'595','2021-10-13 15:47:33','607','2021-10-13 15:48:00',10,0),('5','104',231301,'Daly shift ','2021-10-13','2021-10-13 00:00:00',NULL,'595',918558.79,918558.79,'595','2021-10-13 20:29:33','607','2021-10-14 05:40:02',10,0),('5','104',231411,'Daly shift ','2021-10-14','2021-10-14 00:00:00',NULL,'595',848729.59,848729.59,'595','2021-10-15 07:00:42','607','2021-10-15 10:06:44',10,0),('5','104',231738,'Daly shift ','2021-10-15','2021-10-15 00:00:00',NULL,'595',1015136.29,1015136.29,'595','2021-10-16 07:24:42','607','2021-10-16 09:34:56',10,0),('5','104',231981,'Daly shift ','2021-10-16','2021-10-16 00:00:00',NULL,'595',995607.26,995607.26,'595','2021-10-17 05:15:14','607','2021-10-17 09:24:49',10,0),('5','104',232191,'Daly shift ','2021-10-17','2021-10-17 00:00:00',NULL,'595',899914.85,899914.85,'595','2021-10-17 19:11:57','607','2021-10-17 22:15:07',10,0),('5','104',232319,'Daly shift ','2021-10-18','2021-10-18 00:00:00',NULL,'595',1134199.64,1134199.64,'595','2021-10-18 22:00:58','607','2021-10-19 07:34:09',10,0),('5','104',232644,'Daly shift ','2021-10-19','2021-10-19 00:00:00',NULL,'595',1000608.10,1000608.10,'595','2021-10-20 05:43:55','607','2021-10-20 09:03:09',10,0),('5','104',232964,'Daly shift ','2021-10-20','2021-10-20 00:00:00',NULL,'595',1118305.51,1118305.51,'595','2021-10-21 08:05:13','607','2021-10-21 08:34:31',10,0),('5','104',233175,'Daly shift ','2021-10-21','2021-10-21 00:00:00',NULL,'595',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','104',233179,'Daly shift ','2021-10-21','2021-10-21 00:00:00',NULL,'595',1176501.40,1176501.40,'595','2021-10-21 18:25:19','607','2021-10-22 09:17:08',10,0),('5','104',233451,'Daily shift','2021-10-22','2021-10-22 00:00:00',NULL,'595',1329780.08,1329780.08,'595','2021-10-22 17:41:22','607','2021-10-23 08:03:30',10,0),('5','104',233668,'Daly shift ','2021-10-23','2021-10-23 00:00:00',NULL,'595',1336914.59,1336914.59,'595','2021-10-23 21:28:17','607','2021-10-23 22:38:44',10,0),('5','104',233883,'Daly shift ','2021-10-24','2021-10-24 00:00:00',NULL,'595',1404447.12,1404447.12,'595','2021-10-25 06:56:55','607','2021-10-25 11:13:48',10,0),('5','104',234272,'Daly shift ','2021-10-25','2021-10-25 00:00:00',NULL,'595',2193699.64,2193699.64,'595','2021-10-25 20:09:48','607','2021-10-26 08:27:35',10,0),('5','104',234375,'Daly shift ','2021-10-26','2021-10-26 00:00:00',NULL,'595',1992625.80,1992625.80,'595','2021-10-26 21:24:15','607','2021-10-27 06:21:04',10,0),('5','104',234621,'Daly shift ','2021-10-27','2021-10-27 00:00:00',NULL,'595',2082285.15,2082285.15,'595','2021-10-28 16:18:42','607','2021-10-28 16:21:38',10,0),('5','104',235004,'Daly shift ','2021-10-28','2021-10-28 00:00:00',NULL,'595',1811313.90,1811313.90,'595','2021-10-28 20:42:22','607','2021-10-29 08:44:07',10,0),('5','104',235187,'Daly shift ','2021-10-29','2021-10-29 00:00:00',NULL,'595',2037119.70,2037119.70,'595','2021-10-29 21:58:05','607','2021-10-30 16:47:27',10,0),('5','104',235490,'Daly shift ','2021-10-30','2021-10-30 00:00:00',NULL,'595',2202599.85,2202599.85,'595','2021-10-30 20:30:34','607','2021-10-30 22:03:32',10,0),('5','104',235563,'Daly shift ','2021-10-31','2021-10-31 00:00:00',NULL,'595',1604126.70,1604126.70,'595','2021-10-31 22:56:05','607','2021-11-01 08:45:37',10,0),('5','104',235881,'Daly shift ','2021-11-01','2021-11-01 00:00:00',NULL,'595',555698.55,555698.55,'595','2021-11-02 19:59:00','607','2021-11-02 20:02:58',10,0),('5','104',236203,'Daly shift ','2021-11-02','2021-11-02 00:00:00',NULL,'595',2620666.95,2620666.95,'595','2021-11-02 20:10:37','607','2021-11-02 20:28:37',10,0),('5','104',236227,'Daly shift ','2021-11-03','2021-11-03 00:00:00',NULL,'595',2046254.10,2046254.10,'595','2021-11-04 08:55:04','607','2021-11-04 10:35:01',10,0),('5','104',236617,'Daly shift ','2021-11-04','2021-11-04 00:00:00',NULL,'595',1902545.70,1902545.70,'595','2021-11-05 11:54:05','607','2021-11-05 15:45:33',10,0),('5','104',236910,'Daly shift ','2021-11-05','2021-11-05 00:00:00',NULL,'595',879859.20,879859.20,'595','2021-11-05 20:59:25','600','2021-11-06 09:31:25',10,0),('5','104',237024,'Daly shift ','2021-11-06','2021-11-06 00:00:00',NULL,'595',454746.60,454746.60,'595','2021-11-07 18:14:26','600','2021-11-07 19:07:16',10,0),('5','104',237338,'Daly shift ','2021-11-07','2021-11-07 00:00:00',NULL,'595',2254952.70,2254952.70,'595','2021-11-07 19:39:17','600','2021-11-08 07:35:31',10,0),('5','104',237445,'Daly shift ','2021-11-08','2021-11-08 00:00:00',NULL,'595',1699933.95,1699933.95,'595','2021-11-09 05:13:39','600','2021-11-09 08:34:49',10,0),('5','104',237674,'Daly shift ','2021-11-09','2021-11-09 00:00:00',NULL,'595',545427.30,545427.30,'595','2021-11-09 18:14:19','600','2021-11-10 10:55:50',10,0),('5','104',238098,'Daly shift ','2021-11-10','2021-11-10 00:00:00',NULL,'595',0.00,0.00,'595','2021-11-11 04:35:06','600','2021-11-11 04:52:36',10,0),('5','104',238230,'Daly shift ','2021-11-11','2021-11-11 00:00:00',NULL,'595',0.00,0.00,'595','2021-11-12 05:29:20','600','2021-11-12 08:14:48',10,0),('5','104',238427,'Daly shift ','2021-11-12','2021-11-12 00:00:00',NULL,'595',1967813.10,1967813.10,'595','2021-11-12 21:26:49','600','2021-11-13 10:02:50',10,0),('5','104',238729,'Daly shift ','2021-11-13','2021-11-13 00:00:00',NULL,'595',2223008.70,2223008.70,'595','2021-11-14 08:12:51','600','2021-11-14 09:38:39',10,0),('5','104',238920,'Daly shift ','2021-11-14','2021-11-14 00:00:00',NULL,'595',1837161.15,1837161.15,'595','2021-11-15 07:15:11','600','2021-11-15 08:20:43',10,0),('5','104',239134,'Daly shift ','2021-11-15','2021-11-15 00:00:00',NULL,'595',850274.70,850274.70,'595','2021-11-15 21:46:12','600','2021-11-16 08:10:41',10,0),('5','104',239376,'Daly shift ','2021-11-16','2021-11-16 00:00:00',NULL,'595',2207236.35,2207236.35,'595','2021-11-17 13:28:01','600','2021-11-17 13:54:43',10,0),('5','104',239673,'Daly shift ','2021-11-17','2021-11-17 00:00:00',NULL,'595',2330753.70,2330753.70,'595','2021-11-18 06:22:50','600','2021-11-18 10:57:55',10,0),('5','104',239879,'Daly shift ','2021-11-18','2021-11-18 00:00:00',NULL,'595',2197654.80,2197654.80,'595','2021-11-18 17:09:10','600','2021-11-19 08:15:45',10,0),('5','104',240058,'Daly shift ','2021-11-19','2021-11-19 00:00:00',NULL,'595',681631.50,681631.50,'595','2021-11-19 20:56:13','600','2021-11-20 08:27:04',10,0),('5','104',240258,'Daly shift ','2021-11-20','2021-11-20 00:00:00',NULL,'595',3626629.05,3626629.05,'595','2021-11-20 23:07:10','600','2021-11-21 10:52:33',10,0),('5','104',240530,'Daly shift ','2021-11-21','2021-11-21 00:00:00',NULL,'595',2625232.50,2625232.50,'595','2021-11-21 19:07:59','600','2021-11-21 19:42:31',10,0),('5','104',240738,'Daly shift ','2021-11-22','2021-11-22 00:00:00',NULL,'595',2506247.40,2506247.40,'595','2021-11-23 08:15:20','600','2021-11-23 08:39:52',10,0),('5','104',241091,'Daly shift ','2021-11-23','2021-11-23 00:00:00',NULL,'595',2462232.90,2462232.90,'595','2021-11-23 18:58:38','600','2021-11-24 08:46:40',10,0),('5','104',241331,'Daly shift ','2021-11-24','2021-11-24 00:00:00',NULL,'595',2670058.65,2670058.65,'595','2021-11-24 22:09:51','600','2021-11-25 07:49:31',10,0),('5','104',241543,'Daly shift ','2021-11-25','2021-11-25 00:00:00',NULL,'595',652857.15,652857.15,'595','2021-11-25 20:40:56','600','2021-11-26 08:25:37',10,0),('5','104',241821,'Daly shift ','2021-11-26','2021-11-26 00:00:00',NULL,'595',325348.80,325348.80,'595','2021-11-26 20:20:51','600','2021-11-27 07:55:38',10,0),('5','104',242034,'Daly shift ','2021-11-27','2021-11-27 00:00:00',NULL,'595',658725.75,658725.75,'595','2021-11-27 21:22:13','600','2021-11-28 16:19:35',10,0),('5','104',242364,'Daly shift ','2021-11-28','2021-11-28 00:00:00',NULL,'595',749302.05,749302.05,'595','2021-11-28 17:54:56','600','2021-11-28 17:57:21',10,0),('5','104',242447,'Daly shift ','2021-11-29','2021-11-29 00:00:00',NULL,'595',932410.80,932410.80,'595','2021-11-29 22:40:40','600','2021-11-30 08:49:56',10,0),('5','104',242784,'Daly shift ','2021-11-30','2021-11-30 00:00:00',NULL,'595',1606316.55,1606316.55,'595','2021-11-30 22:40:30','600','2021-12-01 08:30:43',10,0),('5','104',242996,'Daly shift ','2021-12-01','2021-12-01 00:00:00',NULL,'595',631484.55,631484.55,'595','2021-12-01 22:04:43','600','2021-12-02 11:25:57',10,0),('5','104',243256,'Daly shift ','2021-12-02','2021-12-02 00:00:00',NULL,'595',513591.15,513591.15,'595','2021-12-02 20:13:32','600','2021-12-04 10:43:17',10,0),('5','104',243786,'Daly shift ','2021-12-03','2021-12-03 00:00:00',NULL,'595',642034.65,642034.65,'595','2021-12-04 20:18:54','600','2021-12-05 07:53:25',10,0),('5','104',244000,'Daly shift ','2021-12-04','2021-12-04 00:00:00',NULL,'595',686563.80,686563.80,'595','2021-12-05 18:42:55','600','2021-12-05 19:34:08',10,0),('5','104',244007,'Daly shift ','2021-12-05','2021-12-05 00:00:00',NULL,'595',208476.60,208476.60,'595','2021-12-05 20:30:33','600','2021-12-05 20:35:06',10,0),('5','104',244152,'Daly shift ','2021-12-06','2021-12-06 00:00:00',NULL,'595',957540.60,957540.60,'595','2021-12-06 22:08:03','600','2021-12-07 08:08:01',10,0),('5','104',244358,'Daly shift ','2021-12-07','2021-12-07 00:00:00',NULL,'595',2349299.85,2349299.85,'595','2021-12-07 20:59:55','600','2021-12-08 17:41:29',10,0),('5','104',244698,'Daly shift ','2021-12-08','2021-12-08 00:00:00',NULL,'595',1926793.80,1926793.80,'595','2021-12-08 19:54:21','600','2021-12-09 03:53:02',10,0),('5','104',244840,'Daly shift ','2021-12-09','2021-12-09 00:00:00',NULL,'595',1712612.25,1712612.25,'595','2021-12-10 08:25:16','600','2021-12-10 10:50:42',10,0),('5','104',245187,'Daly shift ','2021-12-10','2021-12-10 00:00:00',NULL,'595',257104.35,257104.35,'595','2021-12-10 22:13:45','600','2021-12-11 06:58:16',10,0),('5','104',245350,'Daly shift ','2021-12-11','2021-12-11 00:00:00',NULL,'595',206154.75,206154.75,'595','2021-12-11 19:35:11','600','2021-12-12 03:45:23',10,0),('5','104',245643,'Daly shift ','2021-12-12','2021-12-12 00:00:00',NULL,'595',69700.35,69700.35,'595','2021-12-12 20:45:41','600','2021-12-13 10:36:31',10,0),('5','104',245952,'Daly shift ','2021-12-13','2021-12-13 00:00:00',NULL,'595',0.00,0.00,'595','2021-12-14 06:32:17','600','2021-12-14 08:52:49',10,0),('5','104',246161,'Daly shift ','2021-12-14','2021-12-14 00:00:00',NULL,'595',110068.20,110068.20,'595','2021-12-16 09:55:16','600','2021-12-16 09:57:53',10,0),('5','104',246546,'Daly shift ','2021-12-15','2021-12-15 00:00:00',NULL,'595',1939510.65,1939510.65,'595','2021-12-16 10:04:49','600','2021-12-16 10:06:09',10,0),('5','104',246551,'Daly shift ','2021-12-16','2021-12-16 00:00:00',NULL,'595',2350174.20,2350174.20,'595','2021-12-16 22:44:24','600','2021-12-17 09:34:39',10,0),('5','104',246787,'Daly shift ','2021-12-17','2021-12-17 00:00:00',NULL,'595',1580046.45,1580046.45,'595','2021-12-20 09:49:19','600','2021-12-20 09:51:21',10,0),('5','104',247484,'Daly shift ','2021-12-18','2021-12-18 00:00:00',NULL,'595',1018933.35,1018933.35,'595','2021-12-20 10:07:21','600','2021-12-20 10:09:53',10,0),('5','104',247489,'Daly shift ','2021-12-19','2021-12-19 00:00:00',NULL,'595',194386.80,194386.80,'595','2021-12-20 10:14:37','600','2021-12-20 10:15:43',10,0),('5','104',247490,'Daly shift ','2021-12-20','2021-12-20 00:00:00',NULL,'595',559659.00,559659.00,'595','2021-12-20 21:47:41','600','2021-12-21 07:59:18',10,0),('5','104',247731,'Daly shift ','2021-12-21','2021-12-21 00:00:00',NULL,'595',753614.55,753614.55,'595','2021-12-21 21:37:07','600','2021-12-22 08:03:20',10,0),('5','104',248126,'Daly shift ','2021-12-22','2021-12-22 00:00:00',NULL,'595',1903902.90,1903902.90,'595','2021-12-23 09:45:35','600','2021-12-23 10:01:14',10,0),('5','104',248282,'Daly shift ','2021-12-23','2021-12-23 00:00:00',NULL,'595',2687737.50,2687737.50,'595','2021-12-23 21:46:54','600','2021-12-24 08:14:28',10,0),('5','104',248464,'Daly shift ','2021-12-24','2021-12-24 00:00:00',NULL,'595',1112238.90,1112238.90,'595','2021-12-24 21:38:20','600','2021-12-25 05:02:58',10,0),('5','104',248712,'Daly shift ','2021-12-25','2021-12-25 00:00:00',NULL,'595',192841.20,192841.20,'595','2021-12-25 19:36:18','600','2021-12-26 07:25:44',10,0),('5','104',248953,'Daly shift ','2021-12-26','2021-12-26 00:00:00',NULL,'595',157740.90,157740.90,'595','2021-12-26 20:18:25','600','2021-12-27 12:16:23',10,0),('5','104',249253,'Daly shift ','2021-12-27','2021-12-27 00:00:00',NULL,'595',176733.15,176733.15,'595','2021-12-27 20:28:18','600','2021-12-28 08:19:41',10,0),('5','104',249437,'Daly shift ','2021-12-28','2021-12-28 00:00:00',NULL,'595',143216.40,143216.40,'595','2021-12-28 20:01:53','600','2021-12-29 08:44:11',10,0),('5','104',249684,'Daly shift ','2021-12-29','2021-12-29 00:00:00',NULL,'595',106853.40,106853.40,'595','2021-12-29 20:26:44','600','2021-12-30 08:58:56',10,0),('5','104',249972,'Daly shift ','2021-12-30','2021-12-30 00:00:00',NULL,'595',0.00,0.00,'595','2021-12-31 07:17:12','600','2021-12-31 08:42:46',10,0),('5','104',250307,'Daly shift ','2021-12-31','2021-12-31 00:00:00',NULL,'595',175371.90,175371.90,'595','2022-01-01 20:34:05','600','2022-01-01 20:42:41',10,0),('5','104',250533,'Daly shift ','2022-01-01','2022-01-01 00:00:00',NULL,'595',1378084.95,1378084.95,'595','2022-01-01 21:16:19','600','2022-01-02 09:31:33',10,0),('5','104',250666,'Daly shift ','2022-01-02','2022-01-02 00:00:00',NULL,'595',1740573.45,1740573.45,'595','2022-01-02 20:14:09','600','2022-01-03 16:59:14',10,0),('5','104',250956,'Daly shift ','2022-01-03','2022-01-03 00:00:00',NULL,'595',2095349.85,2095349.85,'595','2022-01-03 20:27:06','600','2022-01-04 08:28:00',10,0),('5','104',251233,'Daly shift ','2022-01-04','2022-01-04 00:00:00',NULL,'595',1114131.15,1114131.15,'595','2022-01-04 20:11:28','600','2022-01-05 11:38:10',10,0),('5','104',251485,'Daly shift ','2022-01-05','2022-01-05 00:00:00',NULL,'595',2449048.80,2449048.80,'595','2022-01-06 07:02:50','600','2022-01-06 10:39:11',10,0),('5','104',251613,'Daly shift ','2022-01-06','2022-01-06 00:00:00',NULL,'595',1389113.55,1389113.55,'595','2022-01-07 07:55:48','600','2022-01-07 11:40:24',10,0),('5','104',251873,'Daly shift ','2022-01-07','2022-01-07 00:00:00',NULL,'595',1809566.55,1809566.55,'595','2022-01-07 23:10:21','600','2022-01-08 13:25:10',10,0),('5','104',252213,'Daly shift ','2022-01-08','2022-01-08 00:00:00',NULL,'595',1177113.30,1177113.30,'595','2022-01-08 23:45:33','600','2022-01-09 09:58:27',10,0),('5','104',252566,'Daly shift ','2022-01-10','2022-01-10 00:00:00',NULL,'595',530366.10,530366.10,'595','2022-01-10 10:47:46','600','2022-01-10 20:35:06',10,0),('5','104',252677,'Daly shift ','2022-01-10','2022-01-10 00:00:00',NULL,'595',0.00,0.00,'595','2022-01-10 21:41:09','600','2022-01-11 09:24:16',10,0),('5','104',252852,'Daly shift ','2022-01-11','2022-01-11 00:00:00',NULL,'595',1654054.05,1654054.05,'595','2022-01-12 10:53:44','600','2022-01-13 09:10:38',10,0),('5','104',253271,'Daly shift ','2022-01-12','2022-01-12 00:00:00',NULL,'595',1707865.50,1707865.50,'595','2022-01-13 10:01:02','600','2022-01-13 10:06:50',10,0),('5','104',253289,'Daly shift ','2022-01-13','2022-01-13 00:00:00',NULL,'595',1705433.40,1705433.40,'595','2022-01-13 21:51:17','600','2022-01-14 09:51:40',10,0),('5','104',253554,'Daly shift ','2022-01-14','2022-01-14 00:00:00',NULL,'595',1694721.60,1694721.60,'595','2022-01-14 21:58:00','600','2022-01-14 22:05:48',10,0),('5','104',253777,'Daly shift ','2022-01-15','2022-01-15 00:00:00',NULL,'595',1408253.55,1408253.55,'595','2022-01-15 21:30:21','600','2022-01-16 06:18:10',10,0),('5','104',254106,'Daly shift ','2022-01-16','2022-01-16 00:00:00',NULL,'595',1451871.30,1451871.30,'595','2022-01-16 19:23:24','600','2022-01-17 05:25:34',10,0),('5','104',254282,'Daly shift ','2022-01-17','2022-01-17 00:00:00',NULL,'595',1660093.05,1660093.05,'595','2022-01-17 22:03:49','600','2022-01-18 06:18:08',10,0),('5','104',254532,'Daly shift ','2022-01-18','2022-01-18 00:00:00',NULL,'595',221388.75,221388.75,'595','2022-01-18 22:12:55','600','2022-01-19 11:59:47',10,0),('5','104',254816,'Daly shift ','2022-01-19','2022-01-19 00:00:00',NULL,'595',0.00,0.00,'595','2022-01-19 22:23:29','600','2022-01-20 09:41:47',10,0),('5','104',255096,'Daly shift ','2022-01-20','2022-01-20 00:00:00',NULL,'595',315669.75,315669.75,'595','2022-01-21 21:06:49','600','2022-01-22 09:25:37',10,0),('5','104',255573,'Daly shift ','2022-01-21','2022-01-21 00:00:00',NULL,'595',1616607.30,1616607.30,'595','2022-01-22 12:52:30','600','2022-01-22 16:47:59',10,0),('5','104',255640,'Daly shift ','2022-01-22','2022-01-22 00:00:00',NULL,'595',1253074.35,1253074.35,'595','2022-01-22 19:53:31','600','2022-01-23 09:02:44',10,0),('5','104',255809,'Daly shift ','2022-01-23','2022-01-23 00:00:00',NULL,'595',1245215.40,1245215.40,'595','2022-01-23 21:18:35','600','2022-01-24 09:38:48',10,0),('5','104',256022,'Daly shift ','2022-01-24','2022-01-24 00:00:00',NULL,'595',744168.15,744168.15,'595','2022-01-25 07:27:15','600','2022-01-25 09:09:26',10,0),('5','104',256290,'Daly shift ','2022-01-25','2022-01-25 00:00:00',NULL,'595',0.00,0.00,'595','2022-01-26 09:18:34','600','2022-01-27 10:03:19',10,0),('5','104',256935,'Daly shift ','2022-01-26','2022-01-26 00:00:00',NULL,'595',0.00,0.00,'595','2022-01-27 22:36:43','600','2022-01-28 10:47:12',10,0),('5','104',257070,'Daly shift ','2022-01-27','2022-01-27 00:00:00',NULL,'595',0.00,0.00,'595','2022-01-28 11:57:06','600','2022-01-28 13:38:05',10,0),('5','104',257114,'Daly shift ','2022-01-28','2022-01-28 00:00:00',NULL,'595',0.00,0.00,'595','2022-01-28 21:32:07','600','2022-01-29 13:23:57',10,0),('5','104',257405,'Daly shift ','2022-01-29','2022-01-29 00:00:00',NULL,'595',266623.50,266623.50,'595','2022-01-30 17:03:31','600','2022-01-31 09:12:02',10,0),('5','104',257406,'Daly shift ','2022-01-30','2022-01-30 00:00:00',NULL,'595',1539938.40,1539938.40,'595','2022-01-31 09:57:05','600','2022-01-31 16:54:49',10,0),('5','104',257407,'Daly shift ','2022-01-31','2022-01-31 00:00:00',NULL,'595',1587826.35,1587826.35,'595','2022-01-31 23:18:15','600','2022-02-01 09:08:07',10,0),('5','104',257408,'Daly shift ','2022-02-01','2022-02-01 00:00:00',NULL,'595',390060.00,390060.00,'595','2022-02-01 22:56:38','600','2022-02-03 11:46:22',10,0),('5','104',257409,'Daly shift ','2022-02-02','2022-02-02 00:00:00',NULL,'595',231547.80,231547.80,'595','2022-02-03 16:06:26','600','2022-02-03 16:15:42',10,0),('5','104',257410,'Daly shift ','2022-02-03','2022-02-03 00:00:00',NULL,'595',1490685.90,1490685.90,'595','2022-02-03 22:49:44','600','2022-02-04 09:26:24',10,0),('5','104',257411,'Daly shift ','2022-02-04','2022-02-04 00:00:00',NULL,'595',1492751.70,1492751.70,'595','2022-02-04 21:32:38','600','2022-02-05 05:30:22',10,0),('5','104',257412,'Daly shift ','2022-02-05','2022-02-05 00:00:00',NULL,'595',1338583.95,1338583.95,'595','2022-02-05 20:41:44','600','2022-02-06 05:25:29',10,0),('5','104',257413,'Daly shift ','2022-02-06','2022-02-06 00:00:00',NULL,'595',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','104',257414,'Daly shift ','2022-02-06','2022-02-06 00:00:00',NULL,'595',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','104',257415,'Daly shift ','2022-02-06','2022-02-06 00:00:00',NULL,'595',1391482.95,1391482.95,'595','2022-02-08 13:02:40','600','2022-02-08 13:16:02',10,0),('5','104',257416,'Daly shift ','2022-02-07','2022-02-07 00:00:00',NULL,'595',1620121.80,1620121.80,'595','2022-02-08 13:25:43','600','2022-02-08 14:05:59',10,0),('5','104',257417,'Daly shift ','2022-02-08','2022-02-08 00:00:00',NULL,'595',421579.95,421579.95,'595','2022-02-08 19:25:06','600','2022-02-09 09:11:03',10,0),('5','104',257418,'Daly shift ','2022-02-09','2022-02-09 00:00:00',NULL,'595',0.00,0.00,'595','2022-02-09 23:16:53','600','2022-02-10 10:05:14',10,0),('5','104',257419,'Daly shift ','2022-02-10','2022-02-10 00:00:00',NULL,'595',0.00,0.00,'595','2022-02-10 22:58:00','600','2022-02-11 09:44:11',10,0),('5','104',257420,'Daly shift ','2022-02-11','2022-02-11 00:00:00',NULL,'595',441739.65,441739.65,'595','2022-02-12 23:15:32','600','2022-02-13 09:03:35',10,0),('5','104',257421,'Daly shift ','2022-02-12','2022-02-12 00:00:00',NULL,'595',1173687.90,1173687.90,'595','2022-02-13 13:22:17','600','2022-02-13 13:29:08',10,0),('5','104',257422,'Daly shift ','2022-02-13','2022-02-13 00:00:00',NULL,'595',1656073.65,1656073.65,'595','2022-02-13 22:18:50','600','2022-02-14 08:59:48',10,0),('5','104',257423,'Daly shift ','2022-02-14','2022-02-14 00:00:00',NULL,'595',461740.95,461740.95,'595','2022-02-16 16:28:03','600','2022-02-16 18:00:17',10,0),('5','104',257424,'Daly shift ','2022-02-15','2022-02-15 00:00:00',NULL,'595',0.00,0.00,'595','2022-02-16 18:02:39','600','2022-02-17 08:58:33',10,0),('5','104',257425,'Daly shift ','2022-02-16','2022-02-16 00:00:00',NULL,'595',0.00,0.00,'595','2022-02-17 21:37:20','600','2022-02-18 09:25:14',10,0),('5','104',257426,'Daly shift ','2022-02-17','2022-02-17 00:00:00',NULL,'595',0.00,0.00,'595','2022-02-18 12:35:45','600','2022-02-19 11:50:32',10,0),('5','104',257427,'Daly shift ','2022-02-18','2022-02-18 00:00:00',NULL,'595',0.00,0.00,'595','2022-02-19 14:44:11','600','2022-02-19 17:12:00',10,0),('5','104',257428,'Daly shift ','2022-02-19','2022-02-19 00:00:00',NULL,'595',0.00,0.00,'595','2022-02-20 08:06:30','600','2022-02-20 08:49:47',10,0),('5','104',257429,'Daly shift ','2022-02-20','2022-02-20 00:00:00',NULL,'595',0.00,0.00,'595','2022-02-20 16:50:20','600','2022-02-21 09:58:26',10,0),('5','104',257430,'Daly shift ','2022-02-21','2022-02-21 00:00:00',NULL,'595',765210.60,765210.60,'595','2022-02-21 22:05:00','600','2022-02-22 09:23:37',10,0),('5','104',257431,'Daly shift ','2022-02-22','2022-02-22 10:12:34','2022-02-23 10:12:34','595',1692078.30,1692078.30,'595','2022-02-22 23:14:27','600','2022-02-23 09:10:50',10,0),('5','104',257432,'Daly shift ','2022-02-23','2022-02-23 09:19:15','2022-02-24 09:19:15','595',2895482.70,2895482.70,'595','2022-02-24 12:57:26','600','2022-02-24 13:02:05',10,0),('5','104',257433,'Daly shift ','2022-02-24','2022-02-24 13:05:56','2022-02-25 13:05:56','595',1884592.05,1884592.05,'595','2022-02-25 19:54:15','600','2022-02-26 09:47:44',10,0),('5','104',257434,'Daly shift ','2022-02-25','2022-02-26 15:34:40','2022-02-27 15:34:40','595',1927741.20,1927741.20,'595','2022-02-26 21:35:31','600','2022-02-26 21:55:57',10,0),('5','104',257435,'Daly shift ','2022-02-26','2022-02-26 22:23:18','2022-02-27 22:23:18','595',2156026.95,2156026.95,'595','2022-02-27 12:28:05','600','2022-02-27 13:42:38',10,0),('5','104',257436,'Daly shift ','2022-02-27','2022-02-27 18:07:00','2022-02-28 18:07:00','595',2247367.65,2247367.65,'595','2022-02-27 21:40:00','600','2022-02-28 08:48:37',10,0),('5','104',257437,'Daly shift ','2022-02-28','2022-02-28 11:27:46','2022-03-01 11:27:46','595',1489448.40,1489448.40,'595','2022-02-28 21:36:16','600','2022-03-01 09:24:32',10,0),('5','104',257438,'Daly shift ','2022-03-01','2022-03-01 23:37:28','2022-03-02 23:37:28','595',977943.45,977943.45,'595','2022-03-03 11:12:33','600','2022-03-03 12:29:47',10,0),('5','104',257439,'Daly shift ','2022-03-02','2022-03-03 16:58:52','2022-03-04 16:58:52','595',1944714.75,1944714.75,'595','2022-03-03 17:06:35','600','2022-03-03 18:14:30',10,0),('5','104',257440,'Daly shift ','2022-03-03','2022-03-03 23:30:35','2022-03-04 23:30:35','595',1808969.25,1808969.25,'595','2022-03-03 23:33:46','600','2022-03-04 09:27:55',10,0),('5','104',257441,'Daly shift ','2022-03-04','2022-03-07 00:11:04','2022-03-08 00:11:04','595',860636.70,860636.70,'595','2022-03-07 00:13:05','600','2022-03-07 05:19:09',10,0),('5','104',257442,'Daly shift ','2022-03-05','2022-03-07 05:22:17','2022-03-08 05:22:17','595',1968766.80,1968766.80,'595','2022-03-07 05:26:04','600','2022-03-07 09:56:50',10,0),('5','104',257443,'Daly shift ','2022-03-06','2022-03-08 01:43:02','2022-03-09 01:43:02','595',2083055.70,2083055.70,'595','2022-03-08 01:46:08','600','2022-03-08 10:06:03',10,0),('5','104',257444,'Daly shift ','2022-03-07','2022-03-08 14:58:28','2022-03-09 14:58:28','595',488037.00,488037.00,'595','2022-03-08 15:05:22','600','2022-03-08 15:22:05',10,0),('5','104',257445,'Daly shift ','2022-03-08','2022-03-08 20:58:45','2022-03-09 20:58:45','595',0.00,0.00,'595','2022-03-08 20:59:04','600','2022-03-10 09:09:13',10,0),('5','104',257446,'Daly shift ','2022-03-09','2022-03-10 09:36:59','2022-03-11 09:36:59','595',0.00,0.00,'595','2022-03-10 09:37:16','600','2022-03-10 11:33:14',10,0),('5','104',257447,'Daly shift ','2022-03-10','2022-03-10 23:39:16','2022-03-11 23:39:16','595',344581.05,344581.05,'595','2022-03-12 15:51:14','600','2022-03-12 15:55:03',10,0),('5','104',257448,'Daly shift ','2022-03-11','2022-03-12 16:01:37','2022-03-13 16:01:37','595',2212867.80,2212867.80,'595','2022-03-12 16:08:32','600','2022-03-12 16:25:36',10,0),('5','104',257449,'Daly shift ','2022-03-12','2022-03-12 16:37:08','2022-03-13 16:37:08','595',1875779.40,1875779.40,'595','2022-03-12 22:32:41','600','2022-03-13 08:53:56',10,0),('5','104',257450,'Daly shift ','2022-03-13','2022-03-15 09:34:55','2022-03-16 09:34:55','595',1754111.70,1754111.70,'595','2022-03-15 09:38:32','600','2022-03-15 11:44:11',10,0),('5','104',257451,'Daly shift ','2022-03-14','2022-03-15 15:05:04','2022-03-16 15:05:04','595',371416.65,371416.65,'595','2022-03-15 15:07:19','600','2022-03-15 15:23:29',10,0),('5','104',257452,'Daly shift ','2022-03-15','2022-03-15 15:57:31','2022-03-16 15:57:31','595',0.00,0.00,'595','2022-03-15 15:58:14','600','2022-03-16 11:38:12',10,0),('5','104',257453,'Daly shift ','2022-03-16','2022-03-16 22:06:59','2022-03-17 22:06:59','595',0.00,0.00,'595','2022-03-16 22:07:23','600','2022-03-17 08:55:52',10,0),('5','104',257454,'Daly shift ','2022-03-17','2022-03-18 06:57:36','2022-03-19 06:57:36','595',0.00,0.00,'595','2022-03-18 06:58:04','600','2022-03-18 09:20:10',10,0),('5','104',257455,'Daly shift ','2022-03-18','2022-03-19 22:27:28','2022-03-20 22:27:28','595',369189.15,369189.15,'595','2022-03-21 23:53:37','600','2022-03-22 09:02:17',10,0),('5','104',257456,'Daly shift ','2022-03-19','2022-03-22 10:40:45','2022-03-23 10:40:45','595',1968499.50,1968499.50,'595','2022-03-22 10:43:02','600','2022-03-22 11:23:26',10,0),('5','104',257457,'Daly shift ','2022-03-20','2022-03-22 12:52:22','2022-03-23 12:52:22','595',1583156.85,1583156.85,'595','2022-03-22 12:56:47','600','2022-03-22 13:16:53',10,0),('5','104',257458,'Daly shift ','2022-03-21','2022-03-22 13:31:51','2022-03-23 13:31:51','595',421870.35,421870.35,'595','2022-03-22 13:34:00','600','2022-03-22 18:13:28',10,0),('5','104',257459,'Daly shift ','2022-03-22','2022-03-22 18:19:35','2022-03-23 18:19:35','595',0.00,0.00,'595','2022-03-22 18:26:10','600','2022-03-23 10:24:26',10,0),('5','104',257460,'Daly shift ','2022-03-23','2022-03-23 13:05:43','2022-03-24 13:05:43','595',0.00,0.00,'595','2022-03-23 13:06:31','600','2022-03-24 09:05:23',10,0),('5','104',257461,'Daly shift ','2022-03-24','2022-03-24 21:18:34','2022-03-25 21:18:34','595',589950.90,589950.90,'595','2022-03-25 11:40:02','600','2022-03-25 13:21:06',10,0),('5','104',257462,'Daly shift ','2022-03-25','2022-03-25 19:35:30','2022-03-26 19:35:30','595',1394611.35,1394611.35,'595','2022-03-25 19:39:42','600','2022-03-26 12:41:41',10,0),('5','104',257463,'Daly shift ','2022-03-26','2022-03-26 12:54:40','2022-03-27 12:54:40','595',1569465.15,1569465.15,'595','2022-03-26 19:33:41','600','2022-03-27 08:57:08',10,0),('5','104',257464,'Daly shift ','2022-03-27','2022-03-27 11:42:55','2022-03-28 11:42:55','595',1825462.65,1825462.65,'595','2022-03-28 00:19:41','600','2022-03-28 10:11:55',10,0),('5','104',257465,'Daly shift ','2022-03-28','2022-03-28 16:47:13','2022-03-29 16:47:13','595',0.00,0.00,'595','2022-03-28 16:48:35','600','2022-03-29 11:32:34',10,0),('5','104',257466,'Daly shift ','2022-03-29','2022-03-29 13:01:59','2022-03-30 13:01:59','595',0.00,0.00,'595','2022-03-29 22:09:56','600','2022-03-30 09:49:59',10,0),('5','104',257467,'Daly shift ','2022-03-30','2022-03-30 22:06:00','2022-03-31 22:06:00','595',0.00,0.00,'595','2022-03-30 22:06:42','600','2022-03-31 09:27:37',10,0),('5','104',257468,'Daly shift ','2022-03-31','2022-03-31 18:43:10','2022-04-01 18:43:10','595',0.00,0.00,'595','2022-03-31 18:43:46','600','2022-04-01 16:21:36',10,0),('5','104',257469,'Daly shift ','2022-04-01','2022-04-02 06:21:33','2022-04-03 06:21:33','595',0.00,0.00,'595','2022-04-02 06:22:05','600','2022-04-02 16:13:34',10,0),('5','104',257470,'Daly shift ','2022-04-02','2022-04-02 18:11:42','2022-04-03 18:11:42','595',0.00,0.00,'595','2022-04-02 18:12:25','600','2022-04-03 11:05:28',10,0),('5','104',257471,'Daly shift ','2022-04-03','2022-04-03 15:24:10','2022-04-04 15:24:10','595',0.00,0.00,'595','2022-04-03 15:26:51','600','2022-04-04 09:07:09',10,0),('5','104',257472,'Daly shift ','2022-04-04','2022-04-04 23:44:35','2022-04-05 23:44:35','595',0.00,0.00,'595','2022-04-04 23:45:09','600','2022-04-05 11:32:13',10,0),('5','104',257473,'Daly shift ','2022-04-05','2022-04-05 23:11:33','2022-04-06 23:11:33','595',0.00,0.00,'595','2022-04-05 23:12:16','600','2022-04-06 09:06:02',10,0),('5','104',257474,'Daly shift ','2022-04-06','2022-04-06 23:49:52','2022-04-07 23:49:52','595',0.00,0.00,'595','2022-04-06 23:50:57','600','2022-04-07 13:57:21',10,0),('5','104',257475,'Daly shift ','2022-04-07','2022-04-07 16:27:58','2022-04-08 16:27:58','595',0.00,0.00,'595','2022-04-07 16:28:40','600','2022-04-08 09:11:25',10,0),('5','104',257476,'Daly shift ','2022-04-08','2022-04-08 11:02:07','2022-04-09 11:02:07','595',0.00,0.00,'595','2022-04-08 20:23:52','600','2022-04-09 09:01:02',10,0),('5','104',257477,'Daly shift ','2022-04-09','2022-04-09 23:45:12','2022-04-10 23:45:12','595',0.00,0.00,'595','2022-04-09 23:47:17','600','2022-04-10 21:03:51',10,0),('5','104',257478,'Daly shift ','2022-04-10','2022-04-11 12:33:14','2022-04-12 12:33:14','595',0.00,0.00,'595','2022-04-11 12:34:03','600','2022-04-11 15:27:19',10,0),('5','104',257479,'Daly shift ','2022-04-11','2022-04-11 17:40:10','2022-04-12 17:40:10','595',0.00,0.00,'595','2022-04-11 19:45:37','600','2022-04-12 08:57:56',10,0),('5','104',257480,'Daly shift ','2022-04-12','2022-04-12 15:24:31','2022-04-13 15:24:31','595',1797041.40,1797041.40,'595','2022-04-12 20:53:54','600','2022-04-13 08:58:00',10,0),('5','104',257481,'Daly shift ','2022-04-13','2022-04-13 19:58:36','2022-04-14 19:58:36','595',1099825.65,1099825.65,'595','2022-04-13 20:00:50','600','2022-04-14 09:22:08',10,0),('5','104',257482,'Daly shift ','2022-04-14','2022-04-14 11:17:07','2022-04-15 11:17:07','595',1183360.20,1183360.20,'595','2022-04-14 22:26:31','600','2022-04-15 10:19:02',10,0),('5','104',257483,'Daly shift ','2022-04-15','2022-04-16 06:28:45','2022-04-17 06:28:45','595',314811.75,314811.75,'595','2022-04-16 06:31:11','600','2022-04-16 19:58:29',10,0),('5','104',257484,'Daly shift ','2022-04-16','2022-04-16 23:13:37','2022-04-17 23:13:37','595',0.00,0.00,'595','2022-04-16 23:14:31','600','2022-04-17 05:41:46',10,0),('5','104',257485,'Daly shift ','2022-04-17','2022-04-17 23:21:37','2022-04-18 23:21:37','595',0.00,0.00,'595','2022-04-17 23:22:01','600','2022-04-18 11:08:18',10,0),('5','104',257486,'Daly shift ','2022-04-18','2022-04-18 21:54:51','2022-04-19 21:54:51','595',951020.40,951020.40,'595','2022-04-18 22:52:07','600','2022-04-19 10:52:32',10,0),('5','104',257487,'Daly shift ','2022-04-19','2022-04-19 19:59:58','2022-04-20 19:59:58','595',1509118.05,1509118.05,'595','2022-04-19 20:02:25','600','2022-04-20 09:55:23',10,0),('5','104',257488,'Daly shift ','2022-04-20','2022-04-20 18:02:14','2022-04-21 18:02:14','595',1312086.60,1312086.60,'595','2022-04-20 18:06:07','600','2022-04-21 09:22:50',10,0),('5','104',257489,'Daly shift ','2022-04-21','2022-04-21 22:44:36','2022-04-22 22:44:36','595',1366917.75,1366917.75,'595','2022-04-21 22:48:19','600','2022-04-22 10:17:45',10,0),('5','104',257490,'Daly shift ','2022-04-22','2022-04-22 15:21:28','2022-04-23 15:21:28','595',1492794.60,1492794.60,'595','2022-04-22 20:27:53','600','2022-04-23 09:12:10',10,0),('5','104',257491,'Daly shift ','2022-04-23','2022-04-23 10:37:09','2022-04-24 10:37:09','595',1201655.40,1201655.40,'595','2022-04-23 20:47:28','600','2022-04-23 21:11:11',10,0),('5','104',257492,'Daly shift ','2022-04-24','2022-04-24 12:43:15','2022-04-25 12:43:15','595',1283076.30,1283076.30,'595','2022-04-24 19:51:28','600','2022-04-25 11:36:20',10,0),('5','104',257493,'Daly shift ','2022-04-25','2022-04-25 19:42:46','2022-04-26 19:42:46','595',1326075.30,1326075.30,'595','2022-04-25 19:44:22','600','2022-04-26 10:14:30',10,0),('5','104',257494,'Daly shift ','2022-04-26','2022-04-26 11:35:59','2022-04-27 11:35:59','595',545359.65,545359.65,'595','2022-04-26 19:57:08','600','2022-04-27 10:16:40',10,0),('5','104',257495,'Daly shift ','2022-04-27','2022-04-28 08:06:19','2022-04-29 08:06:19','595',0.00,0.00,'595','2022-04-28 08:06:42','600','2022-04-28 12:50:45',10,0),('5','104',257496,'Daly shift ','2022-04-28','2022-04-28 15:27:03','2022-04-29 15:27:03','595',1064617.95,1064617.95,'595','2022-04-29 20:36:42','600','2022-04-29 21:17:16',10,0),('5','104',257497,'Daly shift ','2022-04-29','2022-04-29 22:05:48','2022-04-30 22:05:48','595',1268350.05,1268350.05,'595','2022-04-29 22:25:36','600','2022-05-09 10:53:04',10,0),('5','104',257498,'Daly shift ','2022-04-30','2022-05-10 15:21:06','2022-05-11 15:21:06','595',1585060.95,1585060.95,'595','2022-05-10 15:43:24','600','2022-05-10 16:18:15',10,0),('5','104',257499,'Daly shift ','2022-05-01','2022-05-10 16:51:58','2022-05-11 16:51:58','595',1414488.90,1414488.90,'595','2022-05-10 16:58:28','600','2022-05-10 16:59:06',10,0),('5','104',257500,'Daly shift ','2022-05-02','2022-05-10 17:00:28','2022-05-11 17:00:28','595',1390770.15,1390770.15,'595','2022-05-10 17:02:02','600','2022-05-10 17:03:12',10,0),('5','104',257501,'Daly shift ','2022-05-03','2022-05-10 17:03:45','2022-05-11 17:03:45','595',1237810.20,1237810.20,'595','2022-05-10 17:05:53','600','2022-05-10 17:08:54',10,0),('5','104',257502,'Daly shift ','2022-05-04','2022-05-10 17:09:48','2022-05-11 17:09:48','595',982584.90,982584.90,'595','2022-05-10 17:11:43','600','2022-05-10 17:12:18',10,0),('5','104',257503,'Daly shift ','2022-05-05','2022-05-10 17:13:34','2022-05-11 17:13:34','595',1354471.80,1354471.80,'595','2022-05-10 17:15:28','600','2022-05-10 17:22:32',10,0),('5','104',257504,'Daly shift ','2022-05-06','2022-05-10 17:23:43','2022-05-11 17:23:43','595',1266106.05,1266106.05,'595','2022-05-10 17:25:37','600','2022-05-10 17:26:52',10,0),('5','104',257505,'Daly shift ','2022-05-07','2022-05-10 17:27:26','2022-05-11 17:27:26','595',395181.60,395181.60,'595','2022-05-10 17:28:33','600','2022-05-10 17:45:09',10,0),('5','104',257506,'Daly shift ','2022-05-08','2022-05-10 18:17:45','2022-05-11 18:17:45','595',0.00,0.00,'595','2022-05-10 18:18:37','600','2022-05-10 20:24:21',10,0),('5','104',257507,'Daly shift ','2022-05-09','2022-05-10 21:31:39','2022-05-11 21:31:39','595',0.00,0.00,'595','2022-05-10 21:32:05','600','2022-05-10 21:53:09',10,0),('5','104',257508,'Daly shift ','2022-05-10','2022-05-11 09:21:46','2022-05-12 09:21:46','595',0.00,0.00,'595','2022-05-11 09:24:58','600','2022-05-11 09:36:40',10,0),('5','104',257509,'Daly shift ','2022-05-11','2022-05-11 10:09:09','2022-05-12 10:09:09','595',0.00,0.00,'595','2022-05-11 10:10:44','600','2022-05-11 10:25:55',10,0),('5','104',257510,'Daly shift ','2022-05-12','2022-05-13 11:22:11','2022-05-14 11:22:11','595',0.00,0.00,'595','2022-05-13 11:23:05','600','2022-05-13 11:33:06',10,0),('5','104',257511,'Daly shift ','2022-05-13','2022-05-14 14:09:07','2022-05-15 14:09:07','595',0.00,0.00,'595','2022-05-14 14:09:46','600','2022-05-14 14:24:08',10,0),('5','104',257512,'Daly shift ','2022-05-14','2022-05-14 22:26:04','2022-05-15 22:26:04','595',0.00,0.00,'595','2022-05-14 22:26:49','600','2022-05-15 06:15:51',10,0),('5','104',257513,'Daly shift ','2022-05-15','2022-05-15 06:41:58','2022-05-16 06:41:58','595',0.00,0.00,'595','2022-05-15 06:42:35','600','2022-05-16 11:24:52',10,0),('5','104',257514,'Daly shift ','2022-05-16','2022-05-16 11:56:25','2022-05-17 11:56:25','595',0.00,0.00,'595','2022-05-16 11:56:56','600','2022-05-16 12:02:39',10,0),('5','104',257515,'Daly shift ','2022-05-17','2022-05-17 22:02:29','2022-05-18 22:02:29','595',0.00,0.00,'595','2022-05-17 22:02:57','600','2022-05-18 06:09:37',10,0),('5','104',257516,'Daly shift ','2022-05-18','2022-05-18 08:07:01','2022-05-19 08:07:01','595',0.00,0.00,'595','2022-05-18 20:38:00','600','2022-05-18 21:23:09',10,0),('5','104',257517,'Daly shift ','2022-05-19','2022-05-19 15:10:14','2022-05-20 15:10:14','595',0.00,0.00,'595','2022-05-19 15:11:17','600','2022-05-19 20:50:25',10,0),('5','104',257518,'Daly shift ','2022-05-20','2022-05-20 21:02:04','2022-05-21 21:02:04','595',0.00,0.00,'595','2022-05-20 21:02:22','600','2022-05-20 21:19:53',10,0),('5','104',257519,'Daly shift ','2022-05-21','2022-05-21 20:53:49','2022-05-22 20:53:49','595',0.00,0.00,'595','2022-05-21 21:53:07','600','2022-05-22 08:07:15',10,0),('5','104',257520,'Daly shift ','2022-05-22','2022-05-22 09:51:23','2022-05-23 09:51:23','595',0.00,0.00,'595','2022-05-22 21:54:00','600','2022-05-23 06:00:56',10,0),('5','104',257521,'Daly shift ','2022-05-23','2022-05-23 22:43:58','2022-05-24 22:43:58','595',0.00,0.00,'595','2022-05-23 22:44:22','600','2022-05-24 07:57:50',10,0),('5','104',257522,'Daly shift ','2022-05-24','2022-05-24 10:19:03','2022-05-25 10:19:03','595',518629.65,518629.65,'595','2022-05-24 22:55:15','600','2022-05-25 06:05:19',10,0),('5','104',257523,'Daly shift ','2022-05-25','2022-05-25 15:21:48','2022-05-26 15:21:48','595',1132766.25,1132766.25,'595','2022-05-25 22:25:11','600','2022-05-26 05:26:21',10,0),('5','104',257524,'Daly shift ','2022-05-26','2022-05-26 10:16:44','2022-05-27 10:16:44','595',1290656.40,1290656.40,'595','2022-05-26 21:50:07','600','2022-05-27 05:22:24',10,0),('5','104',257525,'Daly shift ','2022-05-27','2022-05-27 10:20:15','2022-05-28 10:20:15','595',1483632.15,1483632.15,'595','2022-05-27 20:24:39','600','2022-05-28 06:11:40',10,0),('5','104',257526,'Daly shift ','2022-05-28','2022-05-28 23:35:08','2022-05-29 23:35:08','595',1159199.25,1159199.25,'595','2022-05-28 23:39:59','600','2022-05-29 08:12:30',10,0),('5','104',257527,'Daly shift ','2022-05-29','2022-05-29 12:33:10','2022-05-30 12:33:10','595',0.00,0.00,'595','2022-05-29 19:32:58','600','2022-05-30 05:57:09',10,0),('5','104',257528,'Daly shift ','2022-05-30','2022-05-30 22:39:55','2022-05-31 22:39:55','595',452403.60,452403.60,'595','2022-05-31 13:56:20','600','2022-05-31 16:31:16',10,0),('5','104',257529,'Daly shift ','2022-05-31','2022-06-01 05:35:20','2022-06-02 05:35:20','595',1093002.90,1093002.90,'595','2022-06-01 05:37:14','600','2022-06-02 09:06:48',10,0),('5','104',257530,'Daly shift ','2022-06-01','2022-06-02 11:13:29','2022-06-03 11:13:29','595',1153995.15,1153995.15,'595','2022-06-02 11:15:07','600','2022-06-02 11:31:29',10,0),('5','104',257531,'Daly shift ','2022-06-02','2022-06-02 11:35:06','2022-06-03 11:35:06','595',834103.05,834103.05,'595','2022-06-02 20:13:05','600','2022-06-03 09:27:22',10,0),('5','104',257532,'Daly shift ','2022-06-03','2022-06-03 21:45:42','2022-06-04 21:45:42','595',513569.10,513569.10,'595','2022-06-03 21:49:02','600','2022-06-04 09:22:56',10,0),('5','104',257533,'Daly shift ','2022-06-04','2022-06-04 19:12:23','2022-06-05 19:12:23','595',683885.40,683885.40,'595','2022-06-05 13:42:28','600','2022-06-05 13:52:43',10,0),('5','104',257534,'Daly shift ','2022-06-05','2022-06-05 17:52:55','2022-06-06 17:52:55','595',1276968.00,1276968.00,'595','2022-06-05 18:37:04','600','2022-06-06 09:48:50',10,0),('5','104',257535,'Daly shift ','2022-06-06','2022-06-06 11:26:43','2022-06-07 11:26:43','595',1067627.55,1067627.55,'595','2022-06-07 06:55:50','600','2022-06-07 09:07:30',10,0),('5','104',257536,'Daly shift ','2022-06-07','2022-06-07 09:35:10','2022-06-08 09:35:10','595',893397.45,893397.45,'595','2022-06-07 19:46:05','600','2022-06-08 09:46:08',10,0),('5','104',257537,'Daly shift ','2022-06-08','2022-06-08 09:56:55','2022-06-09 09:56:55','595',1038737.70,1038737.70,'595','2022-06-08 22:04:53','600','2022-06-09 11:13:58',10,0),('5','104',257538,'Daly shift ','2022-06-10','2022-06-10 09:56:13','2022-06-11 09:56:13','595',1074310.05,1074310.05,'595','2022-06-10 10:05:27','600','2022-06-10 10:11:45',10,0),('5','104',257539,'Daly shift ','2022-06-10','2022-06-11 11:11:40','2022-06-12 11:11:40','595',499128.30,499128.30,'595','2022-06-11 11:12:47','600','2022-06-11 13:31:47',10,0),('5','104',257540,'Daly shift ','2022-06-11','2022-06-11 20:04:35','2022-06-12 20:04:35','595',0.00,0.00,'595','2022-06-11 20:05:33','600','2022-06-12 09:54:35',10,0),('5','104',257541,'Daly shift ','2022-06-12','2022-06-13 07:14:59','2022-06-14 07:14:59','595',0.00,0.00,'595','2022-06-13 16:57:17','600','2022-06-13 18:19:46',10,0),('5','104',257542,'Daly shift ','2022-06-13','2022-06-13 18:50:04','2022-06-14 18:50:04','595',0.00,0.00,'595','2022-06-13 18:50:51','600','2022-06-14 10:47:29',10,0),('5','104',257543,'Daly shift ','2022-06-14','2022-06-14 12:37:54','2022-06-15 12:37:54','595',0.00,0.00,'595','2022-06-14 18:21:33','600','2022-06-15 09:24:14',10,0),('5','104',257544,'Daly shift ','2022-06-15','2022-06-15 10:23:57','2022-06-16 10:23:57','595',0.00,0.00,'595','2022-06-15 10:24:26','600','2022-06-16 09:16:49',10,0),('5','104',257545,'Daly shift ','2022-06-16','2022-06-16 14:14:52','2022-06-17 14:14:52','595',0.00,0.00,'595','2022-06-16 14:15:12','600','2022-06-17 09:56:23',10,0),('5','104',257546,'Daly shift ','2022-06-17','2022-06-17 10:26:58','2022-06-18 10:26:58','595',0.00,0.00,'595','2022-06-17 10:27:56','600','2022-06-18 09:47:24',10,0),('5','104',257547,'Daly shift ','2022-06-18','2022-06-18 15:53:30','2022-06-19 15:53:30','595',0.00,0.00,'595','2022-06-18 15:53:55','600','2022-06-19 09:33:25',10,0),('5','104',257548,'Daly shift ','2022-06-19','2022-06-19 18:01:24','2022-06-20 18:01:24','595',0.00,0.00,'595','2022-06-19 18:01:52','600','2022-06-20 09:57:20',10,0),('5','104',257549,'Daly shift ','2022-06-20','2022-06-20 17:27:43','2022-06-21 17:27:43','595',0.00,0.00,'595','2022-06-20 17:28:10','600','2022-06-21 09:56:31',10,0),('5','104',257550,'Daly shift ','2022-06-21','2022-06-21 18:35:58','2022-06-22 18:35:58','595',0.00,0.00,'595','2022-06-21 18:36:36','600','2022-06-22 09:31:25',10,0),('5','104',257551,'Daly shift ','2022-06-22','2022-06-22 16:45:45','2022-06-23 16:45:45','595',0.00,0.00,'595','2022-06-22 16:46:23','600','2022-06-23 09:59:36',10,0),('5','104',257552,'Daly shift ','2022-06-23','2022-06-23 17:06:01','2022-06-24 17:06:01','595',0.00,0.00,'595','2022-06-23 17:06:36','600','2022-06-24 09:42:58',10,0),('5','104',257553,'Daly shift ','2022-06-24','2022-06-24 20:07:08','2022-06-25 20:07:08','595',0.00,0.00,'595','2022-06-24 20:07:33','600','2022-06-25 09:25:20',10,0),('5','104',257554,'Daly shift ','2022-06-25','2022-06-25 22:34:42','2022-06-26 22:34:42','595',0.00,0.00,'595','2022-06-25 22:35:15','600','2022-06-26 12:14:33',10,0),('5','104',257555,'Daly shift ','2022-06-26','2022-06-26 14:46:33','2022-06-27 14:46:33','595',0.00,0.00,'595','2022-06-26 14:46:49','600','2022-06-27 10:24:07',10,0),('5','104',257556,'Daly shift ','2022-06-27','2022-06-27 15:26:55','2022-06-28 15:26:55','595',0.00,0.00,'595','2022-06-27 15:27:18','600','2022-06-28 09:17:24',10,0),('5','104',257557,'Daly shift ','2022-06-28','2022-06-28 17:50:19','2022-06-29 17:50:19','595',0.00,0.00,'595','2022-06-28 17:50:53','600','2022-06-29 09:07:07',10,0),('5','104',257558,'Daly shift ','2022-06-29','2022-06-29 19:34:41','2022-06-30 19:34:41','595',0.00,0.00,'595','2022-06-29 19:35:47','600','2022-06-30 08:29:45',10,0),('5','104',257559,'Daly shift ','2022-06-30','2022-06-30 09:07:34','2022-07-01 09:07:34','595',0.00,0.00,'595','2022-06-30 17:39:14','600','2022-07-01 09:54:07',10,0),('5','104',257560,'Daly shift ','2022-07-01','2022-07-01 21:54:11','2022-07-02 21:54:11','595',0.00,0.00,'595','2022-07-01 21:54:38','600','2022-07-02 13:39:31',10,0),('5','104',257561,'Daly shift ','2022-07-02','2022-07-02 21:52:31','2022-07-03 21:52:31','595',0.00,0.00,'595','2022-07-02 21:52:51','600','2022-07-03 09:36:57',10,0),('5','104',257562,'Daly shift ','2022-07-04','2022-07-04 05:52:59','2022-07-05 05:52:59','595',0.00,0.00,'595','2022-07-04 12:24:29','600','2022-07-04 12:26:15',10,0),('5','104',257563,'Daly shift ','2022-07-04','2022-07-04 15:32:35','2022-07-05 15:32:35','595',0.00,0.00,'595','2022-07-04 15:33:39','600','2022-07-05 09:17:00',10,0),('5','104',257564,'Daly shift ','2022-07-05','2022-07-05 15:52:56','2022-07-06 15:52:56','595',0.00,0.00,'595','2022-07-05 15:53:40','600','2022-07-06 09:14:35',10,0),('5','104',257565,'Daly shift ','2022-07-06','2022-07-06 23:39:57','2022-07-07 23:39:57','595',0.00,0.00,'595','2022-07-06 23:41:10','600','2022-07-07 10:38:36',10,0),('5','104',257566,'Daly shift ','2022-07-07','2022-07-07 18:42:21','2022-07-08 18:42:21','595',0.00,0.00,'595','2022-07-07 18:42:44','600','2022-07-08 08:56:44',10,0),('5','104',257567,'Daly shift ','2022-07-08','2022-07-08 22:35:49','2022-07-09 22:35:49','595',418143.00,418143.00,'595','2022-07-10 22:26:46','600','2022-07-11 08:23:56',10,0),('5','104',257568,'Daly shift ','2022-07-09','2022-07-12 00:19:16','2022-07-13 00:19:16','595',897624.75,897624.75,'595','2022-07-12 00:21:20','600','2022-07-12 10:53:18',10,0),('5','104',257569,'Daly shift ','2022-07-10','2022-07-12 15:47:27','2022-07-13 15:47:27','595',943060.80,943060.80,'595','2022-07-12 16:09:07','600','2022-07-12 16:40:21',10,0),('5','104',257570,'Daly shift ','2022-07-11','2022-07-12 16:52:18','2022-07-13 16:52:18','595',1102487.15,1102487.15,'595','2022-07-12 16:54:13','600','2022-07-12 17:24:25',10,0),('5','104',257571,'Daly shift ','2022-07-12','2022-07-12 17:29:04','2022-07-13 17:29:04','595',985646.70,985646.70,'595','2022-07-13 06:42:03','600','2022-07-13 09:32:18',10,0),('5','104',257572,'Daly shift ','2022-07-13','2022-07-13 21:50:18','2022-07-14 21:50:18','595',1426721.85,1426721.85,'595','2022-07-13 21:53:31','600','2022-07-14 09:50:41',10,0),('5','104',257573,'Daly shift ','2022-07-14','2022-07-14 10:35:14','2022-07-15 10:35:14','595',1657995.90,1657995.90,'595','2022-07-14 22:32:49','600','2022-07-15 10:52:15',10,0),('5','104',257574,'Daly shift ','2022-07-15','2022-07-15 20:59:50','2022-07-16 20:59:50','595',2003920.00,2003920.00,'595','2022-07-15 21:35:23','600','2022-07-16 09:54:58',10,0),('5','104',257575,'Daly shift ','2022-07-16','2022-07-16 18:53:43','2022-07-17 18:53:43','595',1624460.95,1624460.95,'595','2022-07-16 19:06:31','600','2022-07-17 04:58:48',10,0),('5','104',257576,'Daly shift ','2022-07-17','2022-07-17 10:02:58','2022-07-18 10:02:58','595',2662656.90,2662656.90,'595','2022-07-17 22:44:39','600','2022-07-18 07:32:28',10,0),('5','104',257577,'Daly shift ','2022-07-18','2022-07-18 11:49:26','2022-07-19 11:49:26','595',1555367.15,1555367.15,'595','2022-07-18 23:25:27','600','2022-07-19 09:38:41',10,0),('5','104',257578,'Daly shift ','2022-07-19','2022-07-19 23:16:02','2022-07-20 23:16:02','595',1780415.95,1780415.95,'595','2022-07-19 23:22:59','600','2022-07-20 09:10:03',10,0),('5','104',257579,'Daly shift ','2022-07-20','2022-07-20 20:26:27','2022-07-21 20:26:27','595',1407391.20,1407391.20,'595','2022-07-21 20:49:14','600','2022-07-22 07:27:28',10,0),('5','104',257580,'Daly shift ','2022-07-21','2022-07-22 11:14:54','2022-07-23 11:14:54','595',1681224.50,1681224.50,'595','2022-07-22 11:22:28','600','2022-07-22 11:35:05',10,0),('5','104',257581,'Daly shift ','2022-07-22','2022-07-22 11:49:08','2022-07-23 11:49:08','595',1630464.20,1630464.20,'595','2022-07-22 23:06:33','600','2022-07-23 10:34:39',10,0),('5','104',257582,'Daly shift ','2022-07-23','2022-07-23 20:55:31','2022-07-24 20:55:31','595',1487855.10,1487855.10,'595','2022-07-23 21:35:46','600','2022-07-24 09:29:00',10,0),('5','104',257583,'Daly shift ','2022-07-24','2022-07-24 14:58:19','2022-07-25 14:58:19','595',1573911.55,1573911.55,'595','2022-07-25 08:53:14','600','2022-07-25 11:08:35',10,0),('5','104',257584,'Daly shift ','2022-07-25','2022-07-25 23:34:57','2022-07-26 23:34:57','595',1671149.40,1671149.40,'595','2022-07-25 23:37:30','600','2022-07-26 09:20:42',10,0),('5','104',257585,'Daly shift ','2022-07-26','2022-07-26 14:03:58','2022-07-27 14:03:58','595',1321714.00,1321714.00,'595','2022-07-27 08:19:18','600','2022-07-27 09:16:59',10,0),('5','104',257586,'Daly  shift ','2022-07-27','2022-07-27 09:57:03','2022-07-28 09:57:03','595',1184196.10,1184196.10,'595','2022-07-27 18:47:20','600','2022-07-28 09:24:23',10,0),('5','104',257587,'Daly  shift ','2022-07-28','2022-07-28 11:10:14','2022-07-29 11:10:14','595',487193.80,487193.80,'595','2022-07-29 09:39:50','600','2022-07-29 09:56:05',10,0),('5','104',257588,'Daly  shift ','2022-07-29','2022-07-29 11:00:22','2022-07-30 11:00:22','595',0.00,0.00,'595','2022-07-29 18:26:26','600','2022-07-30 20:08:43',10,0),('5','104',257589,'Daly  shift ','2022-07-30','2022-07-30 22:30:32','2022-07-31 22:30:32','595',0.00,0.00,'595','2022-07-30 22:30:54','600','2022-07-31 10:15:59',10,0),('5','104',257590,'Daly  shift ','2022-07-31','2022-07-31 18:44:42','2022-08-01 18:44:42','595',0.00,0.00,'595','2022-07-31 18:45:08','600','2022-08-01 08:23:55',10,0),('5','104',257591,'Daly  shift ','2022-08-01','2022-08-02 22:14:39','2022-08-03 22:14:39','595',502158.45,502158.45,'595','2022-08-03 15:59:02','600','2022-08-03 16:53:25',10,0),('5','104',257592,'Daly  shift ','2022-08-02','2022-08-03 18:52:20','2022-08-04 18:52:20','595',1517712.25,1517712.25,'595','2022-08-03 18:56:29','600','2022-08-04 08:19:48',10,0),('5','104',257593,'Daly  shift ','2022-08-03','2022-08-04 11:23:07','2022-08-05 11:23:07','595',1162081.20,1162081.20,'595','2022-08-04 11:26:14','600','2022-08-04 11:41:53',10,0),('5','104',257594,'Daly  shift ','2022-08-04','2022-08-04 11:57:05','2022-08-05 11:57:05','595',1449835.75,1449835.75,'595','2022-08-04 17:17:42','600','2022-08-05 10:28:10',10,0),('5','104',257595,'Daly  shift ','2022-08-05','2022-08-05 11:25:31','2022-08-06 11:25:31','595',1110205.35,1110205.35,'595','2022-08-05 20:19:06','600','2022-08-06 08:57:43',10,0),('5','104',257596,'Daly  shift ','2022-08-06','2022-08-06 18:26:20','2022-08-07 18:26:20','595',1856963.40,1856963.40,'595','2022-08-06 18:30:28','600','2022-08-07 10:00:53',10,0),('5','104',257597,'Daly  shift ','2022-08-07','2022-09-03 06:32:33','2022-09-04 06:32:33','595',723129.85,723129.85,'595','2022-09-03 11:23:51','600','2022-09-03 11:30:36',10,0),('5','104',257598,'Daly  shift ','2022-08-08','2022-09-03 11:38:44','2022-09-04 11:38:44','595',0.00,0.00,'595','2022-09-03 11:40:33','600','2022-09-03 12:21:12',10,0),('5','104',257599,'Daly  shift ','2022-08-09','2022-09-03 12:21:49','2022-09-04 12:21:49','595',0.00,0.00,'595','2022-09-03 12:22:11','600','2022-09-03 12:24:19',10,0),('5','104',257600,'Daly  shift ','2022-08-10','2022-09-03 12:41:51','2022-09-04 12:41:51','595',576195.45,576195.45,'595','2022-09-03 12:45:01','600','2022-09-03 13:37:58',10,0),('5','104',257601,'Daly  shift ','2022-08-11','2022-09-03 14:11:12','2022-09-04 14:11:12','595',1484959.85,1484959.85,'595','2022-09-03 14:14:31','600','2022-09-03 16:58:49',10,0),('5','104',257602,'Daly  shift ','2022-08-12','2022-09-03 22:10:05','2022-09-04 22:10:05','595',1639405.25,1639405.25,'595','2022-09-03 22:22:52','600','2022-09-04 10:10:34',10,0),('5','104',257603,'Daly  shift ','2022-08-13','2022-09-04 13:35:51','2022-09-05 13:35:51','595',1621547.20,1621547.20,'595','2022-09-04 13:46:49','600','2022-09-04 13:48:23',10,0),('5','104',257604,'Daly  shift ','2022-08-14','2022-09-04 13:56:32','2022-09-05 13:56:32','595',1247083.15,1247083.15,'595','2022-09-04 18:06:47','600','2022-09-04 18:07:41',10,0),('5','104',257605,'Daly  shift ','2022-08-15','2022-09-04 18:16:41','2022-09-05 18:16:41','595',1617114.60,1617114.60,'595','2022-09-04 18:22:02','600','2022-09-04 18:34:21',10,0),('5','104',257606,'Daly  shift ','2022-08-16','2022-09-04 19:13:30','2022-09-05 19:13:30','595',1212242.10,1212242.10,'595','2022-09-04 21:18:49','600','2022-09-04 21:25:05',10,0),('5','104',257607,'Daly  shift ','2022-08-17','2022-09-04 21:32:21','2022-09-05 21:32:21','595',1494585.40,1494585.40,'595','2022-09-04 21:35:46','600','2022-09-04 21:38:17',10,0),('5','104',257608,'Daly  shift ','2022-08-18','2022-09-04 21:40:21','2022-09-05 21:40:21','595',1373021.90,1373021.90,'595','2022-09-04 21:43:20','600','2022-09-04 21:45:59',10,0),('5','104',257609,'Daly  shift ','2022-08-19','2022-09-04 21:49:22','2022-09-05 21:49:22','595',1072903.80,1072903.80,'595','2022-09-04 21:51:51','600','2022-09-04 21:55:51',10,0),('5','104',257610,'Daly  shift ','2022-08-20','2022-09-04 21:57:11','2022-09-05 21:57:11','595',1163181.95,1163181.95,'595','2022-09-04 22:01:16','600','2022-09-04 22:03:08',10,0),('5','104',257611,'Daly  shift ','2022-08-21','2022-09-05 13:52:59','2022-09-06 13:52:59','595',870038.35,870038.35,'595','2022-09-05 13:55:02','600','2022-09-05 13:58:28',10,0),('5','104',257612,'Daly  shift ','2022-08-22','2022-09-05 14:01:49','2022-09-06 14:01:49','595',1179164.10,1179164.10,'595','2022-09-05 14:05:20','600','2022-09-05 14:09:17',10,0),('5','104',257613,'Daly  shift ','2022-08-23','2022-09-05 14:10:50','2022-09-06 14:10:50','595',785206.60,785206.60,'595','2022-09-05 14:37:42','600','2022-09-05 14:55:27',10,0),('5','104',257614,'Daly  shift ','2022-08-24','2022-09-05 14:58:21','2022-09-06 14:58:21','595',233734.55,233734.55,'595','2022-09-05 15:14:49','600','2022-09-05 15:18:10',10,0),('5','104',257615,'Daly  shift ','2022-08-25','2022-09-05 15:18:55','2022-09-06 15:18:55','595',1483539.05,1483539.05,'595','2022-09-05 15:21:11','600','2022-09-05 15:25:12',10,0),('5','104',257616,'Daly  shift ','2022-08-26','2022-09-05 15:42:37','2022-09-06 15:42:37','595',1551583.90,1551583.90,'595','2022-09-05 15:44:33','600','2022-09-05 16:04:55',10,0),('5','104',257617,'Daly  shift ','2022-08-27','2022-09-05 16:09:07','2022-09-06 16:09:07','595',1490358.15,1490358.15,'595','2022-09-05 16:13:09','600','2022-09-05 16:14:55',10,0),('5','104',257618,'Daly  shift ','2022-08-28','2022-09-05 16:16:11','2022-09-06 16:16:11','595',1614513.50,1614513.50,'595','2022-09-05 23:28:24','600','2022-09-06 08:32:59',10,0),('5','104',257619,'Daly  shift ','2022-08-29','2022-09-06 09:48:14','2022-09-07 09:48:14','595',896110.40,896110.40,'595','2022-09-06 10:21:50','600','2022-09-06 11:06:50',10,0),('5','104',257620,'Daly  shift ','2022-08-30','2022-09-06 13:35:12','2022-09-07 13:35:12','595',244610.70,244610.70,'595','2022-09-06 13:37:54','600','2022-09-06 13:39:12',10,0),('5','104',257621,'Daly  shift ','2022-08-31','2022-09-06 13:50:21','2022-09-07 13:50:21','595',245413.60,245413.60,'595','2022-09-06 14:00:17','600','2022-09-06 14:01:38',10,0),('5','104',257622,'Daly  shift ','2022-09-01','2022-09-06 14:03:59','2022-09-07 14:03:59','595',2699399.75,2699399.75,'595','2022-09-06 14:14:24','600','2022-09-06 14:53:33',10,0),('5','104',257623,'Daly  shift ','2022-08-02','2022-09-06 14:59:37','2022-09-07 14:59:37','595',2443618.75,2443618.75,'595','2022-09-06 15:11:30','600','2022-09-06 15:21:04',10,0),('5','104',257624,'Daly  shift ','2022-09-03','2022-09-06 15:23:54','2022-09-07 15:23:54','595',2405751.10,2405751.10,'595','2022-09-07 10:26:37','600','2022-09-07 10:27:34',10,0),('5','104',257625,'Daly  shift ','2022-09-04','2022-09-07 10:29:18','2022-09-08 10:29:18','595',549309.40,549309.40,'595','2022-09-07 10:31:22','600','2022-09-07 10:32:19',10,0),('5','104',257626,'Daly  shift ','2022-09-05','2022-09-07 10:33:41','2022-09-08 10:33:41','595',492877.00,492877.00,'595','2022-09-07 10:36:17','600','2022-09-07 10:39:26',10,0),('5','104',257627,'Daly  shift ','2022-09-06','2022-09-07 10:40:55','2022-09-08 10:40:55','595',2474043.85,2474043.85,'595','2022-09-07 11:13:24','600','2022-09-07 12:00:12',10,0),('5','104',257628,'Daly  shift ','2022-09-07','2022-09-07 17:38:59','2022-09-08 17:38:59','595',3063307.70,3063307.70,'595','2022-09-08 12:03:32','600','2022-09-08 12:06:45',10,0),('5','104',257629,'Daly  shift ','2022-09-08','2022-09-08 12:21:11','2022-09-09 12:21:11','595',2186651.90,2186651.90,'595','2022-09-09 16:09:35','600','2022-09-09 16:10:00',10,0),('5','104',257630,'DAILY SHIFT','2022-09-09','2022-09-09 16:10:52','2022-09-10 16:10:52','595',966504.75,966504.75,'595','2022-09-11 23:08:54','600','2022-09-12 05:53:20',10,0),('5','104',257631,'Daly  shift ','2022-09-10','2022-09-13 10:42:38','2022-09-14 10:42:38','595',445211.75,445211.75,'595','2022-09-13 11:03:44','600','2022-09-13 11:05:33',10,0),('5','104',257632,'Daly  shift ','2022-09-11','2022-09-13 11:09:46','2022-09-14 11:09:46','595',2253496.10,2253496.10,'595','2022-09-13 11:13:37','600','2022-09-13 11:18:04',10,0),('5','104',257633,'Daly  shift ','2022-09-12','2022-09-13 11:19:11','2022-09-14 11:19:11','595',2946741.05,2946741.05,'595','2022-09-13 11:22:46','600','2022-09-13 11:23:33',10,0),('5','104',257634,'Daly  shift ','2022-09-13','2022-09-13 11:26:36','2022-09-14 11:26:36','595',1799818.75,1799818.75,'595','2022-09-15 10:12:33','600','2022-09-15 11:08:09',10,0),('5','104',257635,'Daly  shift ','2022-09-14','2022-09-16 15:24:00','2022-09-17 15:24:00','595',2888471.60,2888471.60,'595','2022-09-16 15:39:57','600','2022-09-16 16:53:42',10,0),('5','104',257636,'Daly  shift ','2022-09-15','2022-09-17 06:56:15','2022-09-18 06:56:15','595',2008015.90,2008015.90,'595','2022-09-17 07:00:31','600','2022-09-17 08:20:22',10,0),('5','104',257637,'Daly  shift ','2022-09-16','2022-09-17 23:07:50','2022-09-18 23:07:50','595',2502169.40,2502169.40,'595','2022-09-17 23:12:06','600','2022-09-18 08:25:59',10,0),('5','104',257638,'Daly  shift ','2022-09-18','2022-09-18 14:18:45','2022-09-19 14:18:45','595',0.00,0.00,'600','2022-09-19 13:28:34','600','2022-09-19 13:28:52',10,0),('5','104',257639,'Daly  shift ','2022-09-17','2022-09-20 08:24:33','2022-09-21 08:24:33','595',1358120.15,1358120.15,'595','2022-09-20 08:40:19','600','2022-09-20 09:19:53',10,0),('5','104',257640,'Daly  shift ','2022-09-18','2022-09-20 15:11:26','2022-09-21 15:11:26','595',2738838.05,2738838.05,'595','2022-09-20 15:23:53','600','2022-09-20 15:25:51',10,0),('5','104',257641,'Daly  shift ','2022-09-19','2022-09-20 15:26:40','2022-09-21 15:26:40','595',3275236.30,3275236.30,'595','2022-09-20 15:33:18','600','2022-09-20 15:34:06',10,0),('5','104',257642,'Daly  shift ','2022-09-20','2022-09-20 15:36:55','2022-09-21 15:36:55','595',1781185.55,1781185.55,'595','2022-09-20 20:52:56','600','2022-09-21 06:09:37',10,0),('5','104',257643,'Daly  shift ','2022-09-21','2022-09-21 11:55:10','2022-09-22 11:55:10','595',888564.25,888564.25,'595','2022-09-22 10:31:10','600','2022-09-22 10:35:07',10,0),('5','104',257644,'Daly  shift ','2022-09-22','2022-09-22 10:39:09','2022-09-23 10:39:09','595',2572859.75,2572859.75,'595','2022-09-22 22:03:57','600','2022-09-23 10:27:51',10,0),('5','104',257645,'Daly  shift ','2022-09-23','2022-09-23 23:59:11','2022-09-24 23:59:11','595',3077693.30,3077693.30,'595','2022-09-24 00:07:35','600','2022-09-24 05:56:20',10,0),('5','104',257646,'Daly  shift ','2022-09-24','2022-09-25 12:11:16','2022-09-26 12:11:16','595',2466947.25,2466947.25,'595','2022-09-25 12:18:24','600','2022-09-26 08:25:14',10,0),('5','104',257647,'Daly  shift ','2022-09-26','2022-09-26 10:31:34','2022-09-27 10:31:34','595',2183549.45,2183549.45,'595','2022-09-26 10:34:20','600','2022-09-26 10:35:46',10,0),('5','104',257648,'Daly  shift ','2022-09-26','2022-09-27 06:27:04','2022-09-28 06:27:04','595',2675168.45,2675168.45,'595','2022-09-27 08:33:12','600','2022-09-27 09:03:12',10,0),('5','104',257649,'Daly  shift ','2022-09-27','2022-09-28 11:35:32','2022-09-29 11:35:32','595',2507504.80,2507504.80,'595','2022-09-28 11:44:18','600','2022-09-28 16:39:15',10,0),('5','104',257650,'Daly  shift ','2022-09-28','2022-09-29 14:17:36','2022-09-30 14:17:36','595',2778907.20,2778907.20,'595','2022-09-29 14:37:11','600','2022-09-30 08:19:49',10,0),('5','104',257651,'Daly  shift ','2022-09-29','2022-10-02 06:26:59','2022-10-03 06:26:59','595',2395639.00,2395639.00,'595','2022-10-02 06:31:17','600','2022-10-02 08:07:10',10,0),('5','104',257652,'Daly  shift ','2022-09-30','2022-10-02 16:55:19','2022-10-03 16:55:19','595',3018809.65,3018809.65,'595','2022-10-03 13:14:43','600','2022-10-04 09:07:57',10,0),('5','104',257653,'Daly  shift ','2022-10-01','2022-10-04 10:36:19','2022-10-05 10:36:19','595',3189457.35,3189457.35,'595','2022-10-04 10:39:50','600','2022-10-04 10:58:07',10,0),('5','104',257654,'Daly  shift ','2022-10-02','2022-10-04 10:59:00','2022-10-05 10:59:00','595',2499181.65,2499181.65,'595','2022-10-04 11:03:50','600','2022-10-04 11:05:30',10,0),('5','104',257655,'Daly  shift ','2022-10-03','2022-10-04 14:22:37','2022-10-05 14:22:37','595',1856199.35,1856199.35,'595','2022-10-04 19:18:55','600','2022-10-04 20:44:50',10,0),('5','104',257656,'Daly  shift ','2022-10-04','2022-10-04 22:41:17','2022-10-05 22:41:17','595',0.00,0.00,'595','2022-10-04 22:42:10','600','2022-10-05 06:18:38',10,0),('5','104',257657,'Daly  shift ','2022-10-05','2022-10-05 08:41:03','2022-10-06 08:41:03','595',0.00,0.00,'595','2022-10-06 22:25:05','600','2022-10-07 06:24:43',10,0),('5','104',257658,'Daly  shift ','2022-10-06','2022-10-07 07:22:26','2022-10-08 07:22:26','595',0.00,0.00,'595','2022-10-07 07:22:52','600','2022-10-08 08:14:03',10,0),('5','104',257659,'Daly  shift ','2022-10-07','2022-10-09 15:41:24','2022-10-10 15:41:24','595',0.00,0.00,'595','2022-10-09 15:44:59','600','2022-10-09 16:28:54',10,0),('5','104',257660,'Daly  shift ','2022-10-11','2022-10-12 06:40:09','2022-10-13 06:40:09','595',0.00,0.00,'595','2022-10-12 06:40:45','600','2022-10-12 08:59:48',10,0),('5','104',257661,'Daly  shift ','2022-10-12','2022-10-12 09:50:51','2022-10-13 09:50:51','595',0.00,0.00,'595','2022-10-13 23:19:57','600','2022-10-14 08:13:31',10,0),('5','104',257662,'Daly shift ','2022-10-16','2022-10-16 09:41:33','2022-10-17 09:41:33','595',0.00,0.00,'595','2022-10-16 09:42:01','600','2022-10-16 09:58:55',10,0),('5','104',257663,'Daly shift ','2022-10-16','2022-10-16 10:40:05','2022-10-17 10:40:05','595',0.00,0.00,'600','2022-10-17 11:30:40','600','2022-10-17 11:30:50',10,0),('5','104',257664,'Daly shift ','2022-10-17','2022-10-18 06:29:51','2022-10-19 06:29:51','595',575331.50,575331.50,'595','2022-10-18 10:40:46','600','2022-10-18 11:52:50',10,0),('5','104',257665,'Daly shift ','2022-10-18','2022-10-19 11:51:26','2022-10-20 11:51:26','595',1999285.75,1999285.75,'595','2022-10-19 11:54:03','600','2022-10-19 12:07:55',10,0),('5','104',257666,'Daly shift ','2022-10-19','2022-10-19 12:50:33','2022-10-20 12:50:33','595',2260494.65,2260494.65,'595','2022-10-19 22:36:08','600','2022-10-20 09:08:48',10,0),('5','104',257667,'Daly shift ','2022-10-20','2022-10-20 11:01:06','2022-10-21 11:01:06','595',1742048.80,1742048.80,'595','2022-10-20 22:03:03','600','2022-10-21 06:00:42',10,0),('5','104',257668,'Daly shift ','2022-10-20','2022-10-21 10:27:59','2022-10-22 10:27:59','595',1796621.95,1796621.95,'595','2022-10-21 16:57:24','600','2022-10-21 20:55:46',10,0),('5','104',257669,'Daly shift ','2022-10-21','2022-10-21 23:13:20','2022-10-22 23:13:20','595',1529568.90,1529568.90,'595','2022-10-24 07:28:48','600','2022-10-24 08:05:23',10,0),('5','104',257670,'Daly shift ','2022-10-23','2022-10-24 08:33:01','2022-10-25 08:33:01','595',1604695.55,1604695.55,'595','2022-10-24 08:35:30','600','2022-10-24 10:38:33',10,0),('5','104',257671,'Daly shift ','2022-10-24','2022-10-24 22:54:24','2022-10-25 22:54:24','595',1796296.35,1796296.35,'595','2022-10-24 22:56:44','600','2022-10-25 05:57:12',10,0),('5','104',257672,'Daly shift ','2022-10-25','2022-10-25 13:05:58','2022-10-26 13:05:58','595',571661.10,571661.10,'595','2022-10-25 22:24:03','600','2022-10-26 06:02:53',10,0),('5','104',257673,'Daly shift ','2022-10-28','2022-10-28 08:55:30','2022-10-29 08:55:30','595',0.00,0.00,'595','2022-10-28 08:56:07','600','2022-10-28 10:23:33',10,0),('5','104',257674,'Daly shift ','2022-10-30','2022-10-31 11:13:30','2022-11-01 11:13:30','595',0.00,0.00,'595','2022-10-31 11:14:34','600','2022-10-31 13:10:28',10,0),('5','104',257675,'Daly shift ','2022-10-31','2022-11-01 07:13:34','2022-11-02 07:13:34','595',594380.95,594380.95,'595','2022-11-01 09:57:22','600','2022-11-01 10:13:15',10,0),('5','104',257676,'Daly shift ','2022-11-01','2022-11-01 22:24:33','2022-11-02 22:24:33','595',1584018.10,1584018.10,'595','2022-11-01 22:26:42','600','2022-11-02 06:03:51',10,0),('5','104',257677,'Daly shift ','2022-11-02','2022-11-02 14:12:43','2022-11-03 14:12:43','595',1791380.90,1791380.90,'595','2022-11-02 23:00:41','600','2022-11-03 06:04:04',10,0),('5','104',257678,'Daly shift ','2022-11-03','2022-11-03 10:27:15','2022-11-04 10:27:15','595',1880301.15,1880301.15,'595','2022-11-03 22:04:32','600','2022-11-04 08:15:15',10,0),('5','104',257679,'Daly shift ','2022-11-04','2022-11-04 18:05:42','2022-11-05 18:05:42','595',1905331.65,1905331.65,'595','2022-11-04 18:15:11','600','2022-11-05 09:00:45',10,0),('5','104',257680,'Daly shift ','2022-11-05','2022-11-05 21:59:37','2022-11-06 21:59:37','595',656838.80,656838.80,'595','2022-11-05 22:01:56','600','2022-11-05 22:06:58',10,0),('5','104',257681,'Daly shift ','2022-11-06','2022-11-06 18:06:42','2022-11-07 18:06:42','595',1649589.50,1649589.50,'595','2022-11-06 18:08:55','600','2022-11-07 06:07:31',10,0),('5','104',257682,'Daly shift ','2022-11-07','2022-11-07 23:11:22','2022-11-08 23:11:22','595',1765747.30,1765747.30,'595','2022-11-07 23:13:00','600','2022-11-08 08:18:24',10,0),('5','104',257683,'Daly shift ','2022-11-08','2022-11-09 00:04:00','2022-11-10 00:04:00','595',1388506.40,1388506.40,'595','2022-11-09 00:05:28','600','2022-11-09 08:16:02',10,0),('5','104',257684,'Daly shift ','2022-11-09','2022-11-09 15:29:14','2022-11-10 15:29:14','595',663278.65,663278.65,'595','2022-11-09 15:44:21','600','2022-11-10 09:30:09',10,0),('5','104',257685,'Daly shift ','2022-11-10','2022-11-10 12:06:20','2022-11-11 12:06:20','595',0.00,0.00,'595','2022-11-10 12:06:48','600','2022-11-11 09:27:47',10,0),('5','104',257686,'Daly shift ','2022-11-11','2022-11-11 21:42:09','2022-11-12 21:42:09','595',0.00,0.00,'595','2022-11-11 21:42:38','600','2022-11-12 09:30:03',10,0),('5','104',257687,'Daly shift ','2022-11-13','2022-11-13 21:59:43','2022-11-14 21:59:43','595',0.00,0.00,'595','2022-11-13 22:00:31','600','2022-11-14 08:09:05',10,0),('5','104',257688,'Daly shift ','2022-11-15','2022-11-15 08:57:57','2022-11-16 08:57:57','595',0.00,0.00,'595','2022-11-15 08:58:14','600','2022-11-15 13:41:11',10,0),('5','104',257689,'Daly shift ','2022-11-17','2022-11-17 17:52:35','2022-11-18 17:52:35','595',0.00,0.00,'595','2022-11-17 17:53:16','600','2022-11-18 08:37:34',10,0),('5','104',257690,'Daly shift ','2022-11-18','2022-11-19 07:08:52','2022-11-20 07:08:52','595',0.00,0.00,'600','2022-11-19 10:55:30','600','2022-11-19 10:55:45',10,0),('5','104',257691,'Daly shift ','2022-11-18','2022-11-20 12:53:35','2022-11-21 12:53:35','595',592394.05,592394.05,'595','2022-11-20 12:59:10','600','2022-11-20 16:59:55',10,0),('5','104',257692,'Daly shift t','2022-11-20','2022-11-20 21:24:16','2022-11-21 21:24:16','595',1892766.45,1892766.45,'595','2022-11-20 21:27:20','600','2022-11-21 06:07:16',10,0),('5','104',257693,'Daly shift ','2022-11-20','2022-11-21 10:40:06','2022-11-22 10:40:06','595',1800155.45,1800155.45,'595','2022-11-21 10:45:53','600','2022-11-21 10:58:28',10,0),('5','104',257694,'Daly shift ','2022-11-21','2022-11-22 20:14:56','2022-11-23 20:14:56','595',613471.10,613471.10,'595','2022-11-22 20:16:35','600','2022-11-23 06:12:08',10,0),('5','104',257695,'Daly shift ','2022-11-22','2022-11-23 08:42:57','2022-11-24 08:42:57','595',1676614.30,1676614.30,'595','2022-11-23 08:51:49','600','2022-11-23 08:52:19',10,0),('5','104',257696,'Daly shift ','2022-11-23','2022-11-23 08:53:31','2022-11-24 08:53:31','595',1016330.80,1016330.80,'595','2022-11-23 15:21:17','600','2022-11-24 06:46:24',10,0),('5','104',257697,'DAILY ','2022-11-24','2022-11-24 10:22:04','2022-11-25 10:22:04','600',671814.55,671814.55,'595','2022-11-25 10:19:18','600','2022-11-25 10:24:38',10,0),('5','104',257698,'Daly shift ','2022-11-25','2022-11-25 23:35:05','2022-11-26 23:35:05','595',1701487.55,1701487.55,'595','2022-11-25 23:37:12','600','2022-11-26 09:24:37',10,0),('5','104',257699,'Daly shift ','2022-11-26','2022-11-27 07:14:32','2022-11-28 07:14:32','595',1515547.75,1515547.75,'595','2022-11-27 10:21:43','600','2022-11-27 11:22:04',10,0),('5','104',257700,'Daly shift ','2022-11-27','2022-11-27 22:58:17','2022-11-28 22:58:17','595',1851529.95,1851529.95,'595','2022-11-27 23:04:38','600','2022-11-28 06:11:52',10,0),('5','104',257701,'Daly shift ','2022-11-28','2022-11-29 13:56:55','2022-11-30 13:56:55','595',413669.25,413669.25,'595','2022-11-29 13:59:37','600','2022-11-29 14:10:49',10,0),('5','104',257702,'Daly shift ','2022-11-29','2022-11-29 14:35:56','2022-11-30 14:35:56','595',0.00,0.00,'595','2022-11-29 14:36:21','600','2022-11-30 06:20:24',10,0),('5','104',257703,'Daly shift ','2022-12-01','2022-12-01 07:47:30','2022-12-02 07:47:30','595',0.00,0.00,'595','2022-12-01 07:48:56','600','2022-12-01 08:26:19',10,0),('5','104',257704,'Daly shift ','2022-12-02','2022-12-02 21:58:40','2022-12-03 21:58:40','595',0.00,0.00,'595','2022-12-02 21:59:11','600','2022-12-03 10:12:21',10,0),('5','104',257705,'Daly shift ','2022-12-05','2022-12-05 00:28:41','2022-12-06 00:28:41','595',0.00,0.00,'595','2022-12-05 00:28:57','600','2022-12-05 06:07:32',10,0),('5','104',257706,'Daly shift ','2022-12-05','2022-12-05 23:05:47','2022-12-06 23:05:47','595',0.00,0.00,'595','2022-12-05 23:06:20','600','2022-12-06 06:06:40',10,0),('5','104',257707,'Daly shift ','2022-12-07','2022-12-07 06:10:25','2022-12-08 06:10:25','595',0.00,0.00,'595','2022-12-07 06:12:09','600','2022-12-07 06:14:39',10,0),('5','104',257708,'Daly shift ','2022-12-08','2022-12-08 22:05:03','2022-12-09 22:05:03','595',0.00,0.00,'595','2022-12-08 22:05:28','600','2022-12-09 06:07:35',10,0),('5','104',257709,'Daly shift ','2022-12-12','2022-12-12 06:22:32','2022-12-13 06:22:32','595',0.00,0.00,'595','2022-12-12 06:22:54','600','2022-12-12 08:41:27',10,0),('5','104',257710,'Daly shift ','2022-12-13','2022-12-13 09:25:20','2022-12-14 09:25:20','595',0.00,0.00,'595','2022-12-13 09:25:41','600','2022-12-14 09:43:23',10,0),('5','104',257711,'Daly shift ','2022-12-15','2022-12-15 07:19:33','2022-12-16 07:19:33','595',0.00,0.00,'595','2022-12-15 07:19:58','600','2022-12-15 08:58:53',10,0),('5','104',257712,'Daly shift ','2022-12-16','2022-12-16 20:43:33','2022-12-17 20:43:33','595',0.00,0.00,'595','2022-12-16 20:43:57','600','2022-12-17 10:28:22',10,0),('5','104',257713,'Daly shift ','2022-12-19','2022-12-19 09:42:49','2022-12-20 09:42:49','595',0.00,0.00,'595','2022-12-19 09:43:46','600','2022-12-20 08:54:46',10,0),('5','104',257714,'Daly shift ','2022-12-20','2022-12-20 20:34:33','2022-12-21 20:34:33','595',0.00,0.00,'595','2022-12-20 20:34:53','600','2022-12-21 09:28:09',10,0),('5','104',257715,'Daly shift ','2022-12-23','2022-12-23 08:45:50','2022-12-24 08:45:50','595',0.00,0.00,'595','2022-12-23 08:46:09','600','2022-12-23 09:50:03',10,0),('5','104',257716,'Daly shift ','2022-12-25','2022-12-25 08:09:01','2022-12-26 08:09:01','595',0.00,0.00,'595','2022-12-25 08:09:30','600','2022-12-25 09:30:38',10,0),('5','104',257717,'Daly shift ','2022-12-29','2022-12-29 01:47:26','2022-12-30 01:47:26','595',0.00,0.00,'595','2022-12-29 01:47:45','600','2022-12-29 09:37:00',10,0),('5','104',257718,'Daly shift ','2022-12-29','2022-12-29 23:01:02','2022-12-30 23:01:02','595',0.00,0.00,'595','2022-12-29 23:01:22','600','2022-12-30 10:24:30',10,0),('5','104',257719,'Daly shift ','2022-12-31','2022-12-31 21:26:37','2023-01-01 21:26:37','595',0.00,0.00,'595','2022-12-31 21:28:17','600','2023-01-01 09:25:00',10,0),('5','104',257720,'Daly shift ','2023-01-03','2023-01-03 06:56:59','2023-01-04 06:56:59','595',0.00,0.00,'595','2023-01-03 06:57:33','600','2023-01-03 07:37:55',10,0),('5','104',257721,'Daly shift ','2023-01-08','2023-01-08 13:55:45','2023-01-09 13:55:45','595',0.00,0.00,'595','2023-01-08 13:56:10','600','2023-01-09 06:38:26',10,0),('5','104',257722,'Daly shift ','2023-01-10','2023-01-11 06:15:35','2023-01-12 06:15:35','595',0.00,0.00,'595','2023-01-11 06:15:56','600','2023-01-11 08:26:02',10,0),('5','104',257723,'Daly shift ','2023-01-14','2023-01-16 08:19:14','2023-01-17 08:19:14','595',1528370.10,1528370.10,'595','2023-01-16 08:58:45','600','2023-01-16 09:02:45',10,0),('5','104',257724,'Daly shift ','2023-01-15','2023-01-16 09:05:36','2023-01-17 09:05:36','595',1723680.15,1723680.15,'595','2023-01-16 09:08:07','600','2023-01-16 09:12:48',10,0),('5','104',257725,'Daly shift ','2023-01-16','2023-01-16 22:51:16','2023-01-17 22:51:16','595',2062692.65,2062692.65,'595','2023-01-17 00:23:55','600','2023-01-17 08:21:38',10,0),('5','104',257726,'Daly shift ','2023-01-16','2023-01-17 16:47:16','2023-01-18 16:47:16','595',0.00,0.00,'600','2023-01-17 18:25:39','600','2023-01-17 18:26:02',10,0),('5','104',257727,'Daly shift','2023-01-17','2023-01-18 10:19:47','2023-01-19 10:19:47','595',751103.70,751103.70,'600','2023-01-18 11:08:07','600','2023-01-18 11:08:25',10,0),('5','104',257728,'Daly shift','2023-01-19','2023-01-19 07:47:52','2023-01-20 07:47:52','595',0.00,0.00,'595','2023-01-19 07:48:09','600','2023-01-19 08:24:45',10,0),('5','104',257729,'Daly shift','2023-01-18','2023-01-21 07:20:48','2023-01-22 07:20:48','595',0.00,0.00,'595','2023-01-22 00:10:13','600','2023-01-22 09:30:35',10,0),('5','104',257730,'Daly shift','2023-01-21','2023-01-22 15:15:21','2023-01-23 15:15:21','595',0.00,0.00,'595','2023-01-22 15:15:46','600','2023-01-23 08:16:20',10,0),('5','104',257731,'Daly shift ','2023-01-22','2023-01-23 11:14:48','2023-01-24 11:14:48','595',1675214.20,1675214.20,'595','2023-01-23 13:00:20','600','2023-01-23 13:14:29',10,0),('5','104',257732,'Daly shift','2023-01-23','2023-01-23 15:15:57','2023-01-24 15:15:57','595',1584679.80,1584679.80,'595','2023-01-23 15:36:46','600','2023-01-24 08:26:12',10,0),('5','104',257733,'Daily shift','2023-01-24','2023-01-24 17:16:32','2023-01-25 17:16:32','595',0.00,0.00,'595','2023-01-24 17:17:05','600','2023-01-25 09:13:52',10,0),('5','104',257734,'Daly shift','2023-01-25','2023-01-25 13:50:11','2023-01-26 13:50:11','595',0.00,0.00,'595','2023-01-25 13:50:35','600','2023-01-26 08:58:41',10,0),('5','104',257735,'Daily shift','2023-01-26','2023-01-26 22:58:36','2023-01-27 22:58:36','595',0.00,0.00,'595','2023-01-26 22:59:21','600','2023-01-27 09:32:08',10,0),('5','104',257736,'Daily shift','2023-01-29','2023-01-29 18:33:34','2023-01-30 18:33:34','595',0.00,0.00,'595','2023-01-29 18:33:52','600','2023-01-30 08:59:30',10,0),('5','104',257737,'Daily shift','2023-01-30','2023-01-30 23:47:26','2023-01-31 23:47:26','595',0.00,0.00,'595','2023-01-30 23:47:52','600','2023-01-31 10:18:35',10,0),('5','104',257738,'Daly shift','2023-01-31','2023-02-01 00:03:28','2023-02-02 00:03:28','595',0.00,0.00,'595','2023-02-01 00:03:48','600','2023-02-01 07:26:19',10,0),('5','104',257739,'Daily shift','2023-02-01','2023-02-02 06:38:49','2023-02-03 06:38:49','595',0.00,0.00,'595','2023-02-02 06:39:16','600','2023-02-02 12:27:42',10,0),('5','104',257740,'Daily shift','2023-02-02','2023-02-02 18:27:42','2023-02-03 18:27:42','595',491031.20,491031.20,'595','2023-02-03 09:48:21','600','2023-02-03 10:06:44',10,0),('5','104',257741,'Daly shift','2023-02-03','2023-02-04 05:56:47','2023-02-05 05:56:47','595',1615889.00,1615889.00,'595','2023-02-05 09:49:34','600','2023-02-05 15:05:03',10,0),('5','104',257742,'Daly shift','2023-02-04','2023-02-06 15:59:53','2023-02-07 15:59:53','595',2085443.80,2085443.80,'595','2023-02-06 16:02:52','600','2023-02-07 09:07:32',10,0),('5','104',257743,'Daly shift','2023-02-05','2023-02-07 14:51:15','2023-02-08 14:51:15','595',1945083.80,1945083.80,'595','2023-02-07 14:56:16','600','2023-02-07 18:24:46',10,0),('5','104',257744,'Daly shirt ','2023-02-06','2023-02-07 19:44:34','2023-02-08 19:44:34','595',370134.60,370134.60,'595','2023-02-07 19:46:07','600','2023-02-08 08:41:47',10,0),('5','104',257745,'Daly shift','2023-02-08','2023-02-08 13:00:57','2023-02-09 13:00:57','595',0.00,0.00,'595','2023-02-08 13:01:37','600','2023-02-09 08:28:50',10,0),('5','104',257746,'Daily shift','2023-02-09','2023-02-11 06:36:18','2023-02-12 06:36:18','595',0.00,0.00,'595','2023-02-11 06:36:36','600','2023-02-11 13:57:41',10,0),('5','104',257747,'Daily shift','2023-02-10','2023-02-12 07:32:59','2023-02-13 07:32:59','595',849668.60,849668.60,'595','2023-02-12 18:29:01','600','2023-02-13 09:04:20',10,0),('5','104',257748,'Daly shift','2023-02-11','2023-02-13 09:42:35','2023-02-14 09:42:35','595',2131716.40,2131716.40,'595','2023-02-13 09:45:19','600','2023-02-13 10:03:11',10,0),('5','104',257749,'Daily shift','2023-02-12','2023-02-13 10:11:15','2023-02-14 10:11:15','595',2279996.40,2279996.40,'595','2023-02-13 10:24:37','600','2023-02-13 10:25:30',10,0),('5','104',257750,'Daily shift','2023-02-13','2023-02-13 21:04:24','2023-02-14 21:04:24','595',974078.60,974078.60,'595','2023-02-13 21:06:07','600','2023-02-14 09:32:43',10,0),('5','104',257751,'Daly shift','2023-02-16','2023-02-16 12:18:52','2023-02-17 12:18:52','595',0.00,0.00,'595','2023-02-16 12:19:36','600','2023-02-17 10:28:15',10,0),('5','104',257752,'Daily shift','2023-02-18','2023-02-18 22:51:57','2023-02-19 22:51:57','595',409629.00,409629.00,'595','2023-02-18 22:55:24','600','2023-02-19 17:38:36',10,0),('5','104',257753,'Daily shift','2023-02-20','2023-02-20 16:34:00','2023-02-21 16:34:00','595',0.00,0.00,'595','2023-02-20 16:34:20','600','2023-02-21 11:29:36',10,0),('5','104',257754,'Daily shift','2023-02-21','2023-02-21 23:51:07','2023-02-22 23:51:07','595',0.00,0.00,'595','2023-02-21 23:51:36','600','2023-02-22 09:10:38',10,0),('5','104',257755,'Daily shift','2023-02-23','2023-02-23 07:27:02','2023-02-24 07:27:02','595',0.00,0.00,'595','2023-02-23 07:27:29','600','2023-02-23 10:06:36',10,0),('5','104',257756,'Daly shift','2023-02-24','2023-02-24 09:34:29','2023-02-25 09:34:29','595',375244.80,375244.80,'595','2023-02-26 00:36:08','600','2023-02-26 14:59:02',10,0),('5','104',257757,'Daly shift','2023-02-25','2023-02-27 08:50:28','2023-02-28 08:50:28','595',884165.10,884165.10,'595','2023-02-27 09:43:52','600','2023-02-27 09:50:00',10,0),('5','104',257758,'Daily shift','2023-02-26','2023-02-28 06:50:26','2023-03-01 06:50:26','595',2443125.30,2443125.30,'595','2023-03-01 15:03:12','600','2023-03-01 15:16:20',10,0),('5','104',257759,'Daly shift','2023-02-27','2023-03-01 15:22:32','2023-03-02 15:22:32','595',4083798.60,4083798.60,'595','2023-03-02 08:46:00','600','2023-03-02 09:11:35',10,0),('5','104',257760,'Daily shift','2023-02-28','2023-03-02 09:32:01','2023-03-03 09:32:01','595',6248734.80,6248734.80,'595','2023-03-02 09:54:41','600','2023-03-02 09:55:54',10,0),('5','104',257761,'Daily shift','2023-03-01','2023-03-02 10:11:44','2023-03-03 10:11:44','595',6653169.60,6653169.60,'595','2023-03-04 20:34:29','600','2023-03-04 20:35:30',10,0),('5','104',257762,'Daly shift','2023-03-02','2023-03-04 20:36:09','2023-03-05 20:36:09','595',7173400.50,7173400.50,'595','2023-03-04 20:50:03','600','2023-03-04 20:50:54',10,0),('5','104',257763,'Daly shift','2023-03-03','2023-03-04 20:52:39','2023-03-05 20:52:39','595',2171563.80,2171563.80,'595','2023-03-04 21:00:26','600','2023-03-04 21:30:46',10,0),('5','104',257764,'Daly shift','2023-03-04','2023-03-05 09:02:52','2023-03-06 09:02:52','595',2128383.60,2128383.60,'595','2023-03-05 21:30:22','600','2023-03-06 09:39:53',10,0),('5','104',257765,'Daly shift','2023-03-07','2023-03-07 14:30:30','2023-03-08 14:30:30','595',0.00,0.00,'595','2023-03-07 14:30:49','600','2023-03-08 09:17:32',10,0),('5','104',257766,'Daily shift','2023-03-13','2023-03-13 07:07:12','2023-03-14 07:07:12','595',0.00,0.00,'595','2023-03-13 07:07:37','600','2023-03-13 08:19:32',10,0),('5','104',257767,'Daily shift','2023-03-17','2023-03-17 15:50:19','2023-03-18 15:50:19','595',0.00,0.00,'595','2023-03-17 15:51:35','600','2023-03-18 10:13:06',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4905089 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('5','104','895','181487',3564529,'2669','394',0.00,1655134.04,1655134.04,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','181487',3564530,'2670','394',0.00,769496.02,769496.02,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','181487',3564531,'2671','394',0.00,1433944.53,1433944.53,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','181487',3564532,'2672','394',0.00,684429.44,684429.44,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','181487',3564533,'2673','395',0.00,1227364.02,1227364.02,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','181487',3564534,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','181487',3564535,'2675','394',0.00,1774030.46,1774030.46,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','181487',3564536,'2676','394',0.00,1258293.69,1258293.69,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','181491',3564605,'2669','394',1655134.04,1655134.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','181491',3564606,'2670','394',769496.02,769496.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','181491',3564607,'2671','394',1433944.53,1433944.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','181491',3564608,'2672','394',684429.44,684429.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','181491',3564609,'2673','395',1227364.02,1227364.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','181491',3564610,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','181491',3564611,'2675','394',1774030.46,1774030.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','181491',3564612,'2676','394',1258293.69,1258293.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','181497',3564736,'2669','394',1655134.04,1655134.04,-163.00,-26569.00,0.00,0.00,163.00,0.00,0.00),('5','104','895','181497',3564737,'2670','394',769496.02,769496.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','181497',3564738,'2671','394',1433944.53,1433944.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','181497',3564739,'2672','394',684429.44,684429.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','181497',3564740,'2673','395',1227364.02,1227364.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','181497',3564741,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','181497',3564742,'2675','394',1774030.46,1774030.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','181497',3564743,'2676','394',1258293.69,1258293.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','181500',3564795,'2669','394',1655134.04,1655286.04,152.00,24776.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','181500',3564796,'2670','394',769496.02,7694567.02,6925071.00,1128786573.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','181500',3564797,'2671','394',1433944.53,1437893944.53,1436460000.00,234142980000.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','181500',3564798,'2672','394',684429.44,6899429.44,6215000.00,1013045000.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','181500',3564799,'2673','395',1227364.02,1299364.02,72000.00,18000000.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','181500',3564800,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','181500',3564801,'2675','394',1774030.46,17566030.46,15792000.00,2574096000.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','181500',3564802,'2676','394',1258293.69,12898293.69,11640000.00,1897320000.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','181508',3564964,'2669','394',1655286.04,1678057.96,22771.92,3711822.96,0.00,0.00,0.00,0.00,0.00),('5','104','895','181508',3564965,'2670','394',7694567.02,7694567.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','181508',3564966,'2671','394',1437893944.53,1437893944.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','181508',3564967,'2672','394',6899429.44,6899429.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','181508',3564968,'2673','395',1299364.02,1299364.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','181508',3564969,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','181508',3564970,'2675','394',17566030.46,17566030.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','181508',3564971,'2676','394',12898293.69,12898293.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','181545',3565322,'2669','394',1678057.96,1678057.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','181545',3565323,'2670','394',7694567.02,7694567.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','181545',3565324,'2671','394',1437893944.53,1437893944.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','181545',3565325,'2672','394',6899429.44,6899429.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','181545',3565326,'2673','395',1299364.02,1299364.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','181545',3565327,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','181545',3565328,'2675','394',17566030.46,17566030.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','181545',3565329,'2676','394',12898293.69,12898293.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','181639',3566912,'2669','394',1678057.96,1681775.47,3717.51,605954.13,0.00,0.00,0.00,0.00,0.00),('5','104','895','181639',3566913,'2670','394',787000.28,789798.19,2797.91,456059.33,0.00,0.00,0.00,0.00,0.00),('5','104','896','181639',3566914,'2671','394',1458872.22,1465548.75,6676.53,1088274.39,0.00,0.00,0.00,0.00,0.00),('5','104','896','181639',3566915,'2672','394',701168.62,709180.81,8012.19,1305986.97,0.00,0.00,0.00,0.00,0.00),('5','104','897','181639',3566916,'2673','395',1237299.40,1237940.20,640.80,160200.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','181639',3566917,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','181639',3566918,'2675','394',1794913.13,1797540.25,2627.12,428220.56,0.00,0.00,0.00,0.00,0.00),('5','104','896','181639',3566919,'2676','394',1277056.75,1277056.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','181886',3571242,'2669','394',1681775.47,1681775.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','181886',3571243,'2670','394',789798.19,789798.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','181886',3571244,'2671','394',1465548.75,1468745.38,3196.63,521050.69,0.00,0.00,0.00,0.00,0.00),('5','104','896','181886',3571245,'2672','394',709180.81,713541.80,4360.99,710841.37,0.00,0.00,0.00,0.00,0.00),('5','104','897','181886',3571246,'2673','395',1237940.20,1239987.40,2047.20,511800.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','181886',3571247,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','181886',3571248,'2675','394',1797540.25,1797540.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','181886',3571249,'2676','394',1277056.75,1277056.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','182054',3574451,'2669','394',1681775.47,1681775.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','182054',3574452,'2670','394',789798.19,789798.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','182054',3574453,'2671','394',1468745.38,1468745.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','182054',3574454,'2672','394',713541.80,713541.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','182054',3574455,'2673','395',1239987.40,1239987.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','182054',3574456,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','182054',3574457,'2675','394',1797540.25,1797540.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','182054',3574458,'2676','394',1277056.75,1277056.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','182402',3580604,'2669','394',1681775.47,1681775.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','182402',3580605,'2670','394',789798.19,789798.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','182402',3580606,'2671','394',1468745.38,1468745.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','182402',3580607,'2672','394',715226.54,715226.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','182402',3580608,'2673','395',1243475.12,1245976.93,2501.81,625452.50,0.00,0.00,0.00,0.00,0.00),('5','104','898','182402',3580609,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','182402',3580610,'2675','394',1797540.25,1797540.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','182402',3580611,'2676','394',1277056.75,1277056.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','182661',3585550,'2669','394',1681775.47,1681775.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','182661',3585551,'2670','394',789798.19,789798.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','182661',3585552,'2671','394',1468745.38,1468745.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','182661',3585553,'2672','394',715226.54,715226.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','182661',3585554,'2673','395',1245976.93,1246879.32,902.39,225597.50,0.00,0.00,0.00,0.00,0.00),('5','104','898','182661',3585555,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','182661',3585556,'2675','394',1797540.25,1797540.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','182661',3585557,'2676','394',1277056.75,1277056.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','182981',3591385,'2669','394',1681775.47,1681775.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','182981',3591386,'2670','394',789798.19,789798.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','182981',3591387,'2671','394',1468745.38,1468745.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','182981',3591388,'2672','394',715226.54,715226.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','182981',3591389,'2673','395',1246879.32,1249381.39,2502.07,663048.55,0.00,0.00,0.00,0.00,0.00),('5','104','898','182981',3591390,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','182981',3591391,'2675','394',1797540.25,1797540.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','182981',3591392,'2676','394',1277056.75,1277056.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','183167',3594723,'2669','394',1681775.47,1696569.38,14793.91,2411407.33,0.00,0.00,0.00,0.00,0.00),('5','104','895','183167',3594724,'2670','394',789798.19,796290.04,6491.85,1058171.55,0.00,0.00,0.00,0.00,0.00),('5','104','896','183167',3594725,'2671','394',1468745.38,1468876.30,130.92,21339.96,0.00,0.00,0.00,0.00,0.00),('5','104','896','183167',3594726,'2672','394',715226.54,729534.72,14308.18,2332233.34,0.00,0.00,0.00,0.00,0.00),('5','104','897','183167',3594727,'2673','395',1249381.39,1252209.94,2828.55,749565.75,0.00,0.00,0.00,0.00,0.00),('5','104','898','183167',3594728,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','183167',3594729,'2675','394',1797540.25,1805012.02,7471.77,1217898.51,0.00,0.00,0.00,0.00,0.00),('5','104','896','183167',3594730,'2676','394',1277056.75,1277056.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','183827',3606752,'2669','394',1696569.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','183827',3606753,'2670','394',796290.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','183827',3606754,'2671','394',1468876.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','183827',3606755,'2672','394',729534.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','183827',3606756,'2673','395',1252209.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','183827',3606757,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','183827',3606758,'2675','394',1805012.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','183827',3606759,'2676','394',1277056.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','184229',3613979,'2669','394',1696569.38,1698551.33,1981.95,323057.85,0.00,0.00,0.00,0.00,0.00),('5','104','895','184229',3613980,'2670','394',796290.04,802783.57,6493.53,1058445.39,0.00,0.00,0.00,0.00,0.00),('5','104','896','184229',3613981,'2671','394',1468876.30,1469117.29,240.99,39281.37,0.00,0.00,0.00,0.00,0.00),('5','104','896','184229',3613982,'2672','394',729534.72,738698.51,9163.79,1493697.77,0.00,0.00,0.00,0.00,0.00),('5','104','897','184229',3613983,'2673','395',1252209.94,1254796.04,2586.10,659455.50,0.00,0.00,0.00,0.00,0.00),('5','104','898','184229',3613984,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','184229',3613985,'2675','394',1805012.02,1816753.57,11741.55,1913872.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','184229',3613986,'2676','394',1277056.75,1279808.54,2751.79,448541.77,0.00,0.00,0.00,0.00,0.00),('5','104','895','184358',3616047,'2669','394',1698551.33,1709699.62,11148.29,1817171.27,0.00,0.00,0.00,0.00,0.00),('5','104','895','184358',3616048,'2670','394',802783.57,811794.90,9011.33,1468846.79,0.00,0.00,0.00,0.00,0.00),('5','104','896','184358',3616049,'2671','394',1469117.29,1469117.80,0.51,83.13,0.00,0.00,0.00,0.00,0.00),('5','104','896','184358',3616050,'2672','394',738698.51,759848.78,21150.27,3447494.01,0.00,0.00,0.00,0.00,0.00),('5','104','897','184358',3616051,'2673','395',1254796.04,1259470.10,4674.06,1191885.30,0.00,0.00,0.00,0.00,0.00),('5','104','898','184358',3616052,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','184358',3616053,'2675','394',1816753.57,1828090.19,11336.62,1847869.06,0.00,0.00,0.00,0.00,0.00),('5','104','896','184358',3616054,'2676','394',1279808.54,1285880.45,6071.91,989721.33,0.00,0.00,0.00,0.00,0.00),('5','104','895','184387',3616614,'2669','394',1709699.62,1712001.50,2301.88,375206.44,0.00,0.00,0.00,0.00,0.00),('5','104','895','184387',3616615,'2670','394',811794.90,813117.23,1322.33,215539.79,0.00,0.00,0.00,0.00,0.00),('5','104','896','184387',3616616,'2671','394',1469117.80,1469117.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','184387',3616617,'2672','394',759848.78,766734.75,6885.97,1122413.11,0.00,0.00,0.00,0.00,0.00),('5','104','897','184387',3616618,'2673','395',1259470.10,1259470.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','184387',3616619,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','184387',3616620,'2675','394',1828090.19,1829882.58,1792.39,292159.57,0.00,0.00,0.00,0.00,0.00),('5','104','896','184387',3616621,'2676','394',1285880.45,1286880.16,999.71,162952.73,0.00,0.00,0.00,0.00,0.00),('5','104','895','184623',3621075,'2669','394',1712001.50,1717066.64,5065.14,825617.82,0.00,0.00,0.00,0.00,0.00),('5','104','895','184623',3621076,'2670','394',813117.23,817368.24,4251.01,692914.63,0.00,0.00,0.00,0.00,0.00),('5','104','896','184623',3621077,'2671','394',1469117.80,1469117.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','184623',3621078,'2672','394',766734.75,770422.48,3687.73,601099.99,0.00,0.00,0.00,0.00,0.00),('5','104','897','184623',3621079,'2673','395',1259470.10,1259470.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','184623',3621080,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','184623',3621081,'2675','394',1829882.58,1834735.93,4853.35,791096.05,0.00,0.00,0.00,0.00,0.00),('5','104','896','184623',3621082,'2676','394',1286880.16,1288555.52,1675.36,273083.68,0.00,0.00,0.00,0.00,0.00),('5','104','895','184776',3623771,'2669','394',1717066.64,1719569.00,2502.36,407884.68,0.00,0.00,0.00,0.00,0.00),('5','104','895','184776',3623772,'2670','394',817368.24,819404.00,2035.76,331828.88,0.00,0.00,0.00,0.00,0.00),('5','104','896','184776',3623773,'2671','394',1469117.80,1469117.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','184776',3623774,'2672','394',770422.48,770422.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','184776',3623775,'2673','395',1259470.10,1259470.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','184776',3623776,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','184776',3623777,'2675','394',1834735.93,1837426.27,2690.34,438525.42,0.00,0.00,0.00,0.00,0.00),('5','104','896','184776',3623778,'2676','394',1288555.52,1288555.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','184872',3625512,'2669','394',1719569.00,1719723.15,154.15,25126.45,0.00,0.00,0.00,0.00,0.00),('5','104','895','184872',3625513,'2670','394',819404.00,824469.09,5065.09,825609.67,0.00,0.00,0.00,0.00,0.00),('5','104','896','184872',3625514,'2671','394',1469117.80,1469117.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','184872',3625515,'2672','394',770422.48,776798.34,6375.86,1039265.18,0.00,0.00,0.00,0.00,0.00),('5','104','897','184872',3625516,'2673','395',1259470.10,1259470.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','184872',3625517,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','184872',3625518,'2675','394',1837426.27,1842731.88,5305.61,864814.43,0.00,0.00,0.00,0.00,0.00),('5','104','896','184872',3625519,'2676','394',1288555.52,1288555.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','185190',3630972,'2669','394',1719723.15,1720752.35,1029.20,167759.60,0.00,0.00,0.00,0.00,0.00),('5','104','895','185190',3630973,'2670','394',824469.09,826892.83,2423.74,395069.62,0.00,0.00,0.00,0.00,0.00),('5','104','896','185190',3630974,'2671','394',1469117.80,1473373.26,4255.46,693639.98,0.00,0.00,0.00,0.00,0.00),('5','104','896','185190',3630975,'2672','394',776798.34,783822.08,7023.74,1144869.62,0.00,0.00,0.00,0.00,0.00),('5','104','897','185190',3630976,'2673','395',1259470.10,1259470.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','185190',3630977,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','185190',3630978,'2675','394',1842731.88,1847687.44,4955.56,807756.28,0.00,0.00,0.00,0.00,0.00),('5','104','896','185190',3630979,'2676','394',1288555.52,1290258.90,1703.38,277650.94,0.00,0.00,0.00,0.00,0.00),('5','104','895','185270',3631976,'2669','394',1720752.35,1723666.12,2913.77,474944.51,0.00,0.00,0.00,0.00,0.00),('5','104','895','185270',3631977,'2670','394',826892.83,829090.37,2197.54,358199.02,0.00,0.00,0.00,0.00,0.00),('5','104','896','185270',3631978,'2671','394',1473373.26,1477110.60,3737.34,609186.42,0.00,0.00,0.00,0.00,0.00),('5','104','896','185270',3631979,'2672','394',783822.08,785322.18,1500.10,244516.30,0.00,0.00,0.00,0.00,0.00),('5','104','897','185270',3631980,'2673','395',1259470.10,1259470.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','185270',3631981,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','185270',3631982,'2675','394',1847687.44,1850452.88,2765.44,450766.72,0.00,0.00,0.00,0.00,0.00),('5','104','896','185270',3631983,'2676','394',1290258.90,1292405.45,2146.55,349887.65,0.00,0.00,0.00,0.00,0.00),('5','104','895','185725',3640264,'2669','394',1723666.12,1726494.73,2828.61,461063.43,0.00,0.00,0.00,0.00,0.00),('5','104','895','185725',3640265,'2670','394',829090.37,830183.76,1093.39,178222.57,0.00,0.00,0.00,0.00,0.00),('5','104','896','185725',3640266,'2671','394',1477110.60,1479853.07,2742.47,447022.61,0.00,0.00,0.00,0.00,0.00),('5','104','896','185725',3640267,'2672','394',785322.18,785322.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','185725',3640268,'2673','395',1259470.10,1259470.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','185725',3640269,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','185725',3640270,'2675','394',1850452.88,1854176.18,3723.30,606897.90,0.00,0.00,0.00,0.00,0.00),('5','104','896','185725',3640271,'2676','394',1292405.45,1294963.41,2557.96,416947.48,0.00,0.00,0.00,0.00,0.00),('5','104','895','185863',3642993,'2669','394',1726494.73,1730414.75,3920.02,638963.26,0.00,0.00,0.00,0.00,0.00),('5','104','895','185863',3642994,'2670','394',830183.76,831789.08,1605.32,261667.16,0.00,0.00,0.00,0.00,0.00),('5','104','896','185863',3642995,'2671','394',1479853.07,1481205.02,1351.95,220367.85,0.00,0.00,0.00,0.00,0.00),('5','104','896','185863',3642996,'2672','394',785322.18,785322.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','185863',3642997,'2673','395',1259470.10,1259470.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','185863',3642998,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','185863',3642999,'2675','394',1854176.18,1856919.91,2743.73,447227.99,0.00,0.00,0.00,0.00,0.00),('5','104','896','185863',3643000,'2676','394',1294963.41,1297788.85,2825.44,460546.72,0.00,0.00,0.00,0.00,0.00),('5','104','895','185950',3644428,'2669','394',1730414.75,1731691.83,1277.08,208164.04,0.00,0.00,0.00,0.00,0.00),('5','104','895','185950',3644429,'2670','394',831789.08,832283.79,494.71,80637.73,0.00,0.00,0.00,0.00,0.00),('5','104','896','185950',3644430,'2671','394',1481205.02,1488761.87,7556.85,1231766.55,0.00,0.00,0.00,0.00,0.00),('5','104','896','185950',3644431,'2672','394',785322.18,788212.20,2890.02,471073.26,0.00,0.00,0.00,0.00,0.00),('5','104','897','185950',3644432,'2673','395',1259470.10,1259470.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','185950',3644433,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','185950',3644434,'2675','394',1856919.91,1858144.85,1224.94,199665.22,0.00,0.00,0.00,0.00,0.00),('5','104','896','185950',3644435,'2676','394',1297788.85,1303343.52,5554.67,905411.21,0.00,0.00,0.00,0.00,0.00),('5','104','895','186413',3652177,'2669','394',1731691.83,1733630.82,1938.99,316055.37,0.00,0.00,0.00,0.00,0.00),('5','104','895','186413',3652178,'2670','394',832283.79,833211.86,928.07,151275.41,0.00,0.00,0.00,0.00,0.00),('5','104','896','186413',3652179,'2671','394',1488761.87,1491684.78,2922.91,476434.33,0.00,0.00,0.00,0.00,0.00),('5','104','896','186413',3652180,'2672','394',788212.20,788212.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','186413',3652181,'2673','395',1259470.10,1259470.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','186413',3652182,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','186413',3652183,'2675','394',1858144.85,1861491.52,3346.67,545507.21,0.00,0.00,0.00,0.00,0.00),('5','104','896','186413',3652184,'2676','394',1303343.52,1306158.33,2814.81,458814.03,0.00,0.00,0.00,0.00,0.00),('5','104','895','186516',3654200,'2669','394',1733630.82,1736826.91,3196.09,520962.67,0.00,0.00,0.00,0.00,0.00),('5','104','895','186516',3654201,'2670','394',833211.86,833945.33,733.47,119555.61,0.00,0.00,0.00,0.00,0.00),('5','104','896','186516',3654202,'2671','394',1491684.78,1492195.07,510.29,83177.27,0.00,0.00,0.00,0.00,0.00),('5','104','896','186516',3654203,'2672','394',788212.20,789224.02,1011.82,164926.66,0.00,0.00,0.00,0.00,0.00),('5','104','897','186516',3654204,'2673','395',1259470.10,1259470.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','186516',3654205,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','186516',3654206,'2675','394',1861491.52,1864768.49,3276.97,534146.11,0.00,0.00,0.00,0.00,0.00),('5','104','896','186516',3654207,'2676','394',1306158.33,1308845.02,2686.69,437930.47,0.00,0.00,0.00,0.00,0.00),('5','104','895','186668',3656704,'2669','394',1736826.91,1740281.78,3454.87,563143.81,0.00,0.00,0.00,0.00,0.00),('5','104','895','186668',3656705,'2670','394',833945.33,836927.07,2981.74,486023.62,0.00,0.00,0.00,0.00,0.00),('5','104','896','186668',3656706,'2671','394',1492195.07,1494857.58,2662.51,433989.13,0.00,0.00,0.00,0.00,0.00),('5','104','896','186668',3656707,'2672','394',789224.02,792431.50,3207.48,522819.24,0.00,0.00,0.00,0.00,0.00),('5','104','897','186668',3656708,'2673','395',1259470.10,1259470.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','186668',3656709,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','186668',3656710,'2675','394',1864768.49,1869095.25,4326.76,705261.88,0.00,0.00,0.00,0.00,0.00),('5','104','896','186668',3656711,'2676','394',1308845.02,1308940.78,95.76,15608.88,0.00,0.00,0.00,0.00,0.00),('5','104','895','186936',3661213,'2669','394',1740281.78,1742432.46,2150.68,350560.84,0.00,0.00,0.00,0.00,0.00),('5','104','895','186936',3661214,'2670','394',836927.07,838414.63,1487.56,242472.28,0.00,0.00,0.00,0.00,0.00),('5','104','896','186936',3661215,'2671','394',1494857.58,1494857.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','186936',3661216,'2672','394',792431.50,792431.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','186936',3661217,'2673','395',1259470.10,1259470.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','186936',3661218,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','186936',3661219,'2675','394',1869095.25,1871392.55,2297.30,374459.90,0.00,0.00,0.00,0.00,0.00),('5','104','896','186936',3661220,'2676','394',1308940.78,1308940.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','187141',3664770,'2669','394',1742432.46,1746359.04,3926.58,640032.54,0.00,0.00,0.00,0.00,0.00),('5','104','895','187141',3664771,'2670','394',838414.63,839927.85,1513.22,246654.86,0.00,0.00,0.00,0.00,0.00),('5','104','896','187141',3664772,'2671','394',1494857.58,1498136.92,3279.34,534532.42,0.00,0.00,0.00,0.00,0.00),('5','104','896','187141',3664773,'2672','394',792431.50,798125.38,5693.88,928102.44,0.00,0.00,0.00,0.00,0.00),('5','104','897','187141',3664774,'2673','395',1259470.10,1259470.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','187141',3664775,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','187141',3664776,'2675','394',1871392.55,1874802.50,3409.95,555821.85,0.00,0.00,0.00,0.00,0.00),('5','104','896','187141',3664777,'2676','394',1308940.78,1312527.03,3586.25,584558.75,0.00,0.00,0.00,0.00,0.00),('5','104','895','187475',3670783,'2669','394',1746359.04,1749736.71,3377.67,550560.21,0.00,0.00,0.00,0.00,0.00),('5','104','895','187475',3670784,'2670','394',839927.85,842388.90,2461.05,401151.15,0.00,0.00,0.00,0.00,0.00),('5','104','896','187475',3670785,'2671','394',1498136.92,1499284.73,1147.81,187093.03,0.00,0.00,0.00,0.00,0.00),('5','104','896','187475',3670786,'2672','394',798125.38,799505.97,1380.59,225036.17,0.00,0.00,0.00,0.00,0.00),('5','104','897','187475',3670787,'2673','395',1259470.10,1259470.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','187475',3670788,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','187475',3670789,'2675','394',1874802.50,1878091.04,3288.54,536032.02,0.00,0.00,0.00,0.00,0.00),('5','104','896','187475',3670790,'2676','394',1312527.03,1313856.06,1329.03,216631.89,0.00,0.00,0.00,0.00,0.00),('5','104','895','187552',3672162,'2669','394',1749736.71,1754607.41,4870.70,793924.10,0.00,0.00,0.00,0.00,0.00),('5','104','895','187552',3672163,'2670','394',842388.90,842388.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','187552',3672164,'2671','394',1499284.73,1505579.15,6294.42,1025990.46,0.00,0.00,0.00,0.00,0.00),('5','104','896','187552',3672165,'2672','394',799505.97,805561.20,6055.23,987002.49,0.00,0.00,0.00,0.00,0.00),('5','104','897','187552',3672166,'2673','395',1259470.10,1259470.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','187552',3672167,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','187552',3672168,'2675','394',1878091.04,1882262.50,4171.46,679947.98,0.00,0.00,0.00,0.00,0.00),('5','104','896','187552',3672169,'2676','394',1313856.06,1315902.52,2046.46,333572.98,0.00,0.00,0.00,0.00,0.00),('5','104','895','187622',3673198,'2669','394',1754607.41,1754612.05,4.64,756.32,0.00,0.00,0.00,0.00,0.00),('5','104','895','187622',3673199,'2670','394',842388.90,846060.83,3671.93,598524.59,0.00,0.00,0.00,0.00,0.00),('5','104','896','187622',3673200,'2671','394',1505579.15,1507101.54,1522.39,248149.57,0.00,0.00,0.00,0.00,0.00),('5','104','896','187622',3673201,'2672','394',805561.20,807725.90,2164.70,352846.10,0.00,0.00,0.00,0.00,0.00),('5','104','897','187622',3673202,'2673','395',1259470.10,1259470.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','187622',3673203,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','187622',3673204,'2675','394',1882262.50,1885260.21,2997.71,488626.73,0.00,0.00,0.00,0.00,0.00),('5','104','896','187622',3673205,'2676','394',1315902.52,1316827.02,924.50,150693.50,0.00,0.00,0.00,0.00,0.00),('5','104','895','187813',3676609,'2669','394',1754612.05,1760056.05,5444.00,887372.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','187813',3676610,'2670','394',846060.83,849349.59,3288.76,536067.88,0.00,0.00,0.00,0.00,0.00),('5','104','896','187813',3676611,'2671','394',1507101.54,1507101.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','187813',3676612,'2672','394',807725.90,807725.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','187813',3676613,'2673','395',1259470.10,1259470.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','187813',3676614,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','187813',3676615,'2675','394',1885260.21,1889098.09,3837.88,625574.44,0.00,0.00,0.00,0.00,0.00),('5','104','896','187813',3676616,'2676','394',1316827.02,1316827.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','188003',3680076,'2669','394',1760056.05,1762779.64,2723.59,443945.17,0.00,0.00,0.00,0.00,0.00),('5','104','895','188003',3680077,'2670','394',849349.59,851207.53,1857.94,302844.22,0.00,0.00,0.00,0.00,0.00),('5','104','896','188003',3680078,'2671','394',1507101.54,1510888.58,3787.04,617287.52,0.00,0.00,0.00,0.00,0.00),('5','104','896','188003',3680079,'2672','394',807725.90,810984.65,3258.75,531176.25,0.00,0.00,0.00,0.00,0.00),('5','104','897','188003',3680080,'2673','395',1259470.10,1259470.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','188003',3680081,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','188003',3680082,'2675','394',1889098.09,1891926.12,2828.03,460968.89,0.00,0.00,0.00,0.00,0.00),('5','104','896','188003',3680083,'2676','394',1316827.02,1316827.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','188716',3692296,'2669','394',1762779.64,1766406.51,3626.87,591179.81,0.00,0.00,0.00,0.00,0.00),('5','104','895','188716',3692297,'2670','394',851207.53,854206.55,2999.02,488840.26,0.00,0.00,0.00,0.00,0.00),('5','104','896','188716',3692298,'2671','394',1510888.58,1514102.61,3214.03,523886.89,0.00,0.00,0.00,0.00,0.00),('5','104','896','188716',3692299,'2672','394',810984.65,814803.80,3819.15,622521.45,0.00,0.00,0.00,0.00,0.00),('5','104','897','188716',3692300,'2673','395',1259470.10,1259470.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','188716',3692301,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','188716',3692302,'2675','394',1891926.12,1895247.73,3321.61,541422.43,0.00,0.00,0.00,0.00,0.00),('5','104','896','188716',3692303,'2676','394',1316827.02,1316827.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','188721',3692344,'2669','394',1766406.51,1769917.55,3511.04,572299.52,0.00,0.00,0.00,0.00,0.00),('5','104','895','188721',3692345,'2670','394',854206.55,857071.49,2864.94,466985.22,0.00,0.00,0.00,0.00,0.00),('5','104','896','188721',3692346,'2671','394',1514102.61,1517612.52,3509.91,572115.33,0.00,0.00,0.00,0.00,0.00),('5','104','896','188721',3692347,'2672','394',814803.80,818874.97,4071.17,663600.71,0.00,0.00,0.00,0.00,0.00),('5','104','897','188721',3692348,'2673','395',1259470.10,1259470.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','188721',3692349,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','188721',3692350,'2675','394',1895247.73,1899677.76,4430.03,722094.89,0.00,0.00,0.00,0.00,0.00),('5','104','896','188721',3692351,'2676','394',1316827.02,1316827.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','188723',3692375,'2669','394',1769917.55,1772873.92,2956.37,481888.31,0.00,0.00,0.00,0.00,0.00),('5','104','895','188723',3692376,'2670','394',857071.49,860382.25,3310.76,539653.88,0.00,0.00,0.00,0.00,0.00),('5','104','896','188723',3692377,'2671','394',1517612.52,1517612.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','188723',3692378,'2672','394',818874.97,825691.45,6816.48,1111086.24,0.00,0.00,0.00,0.00,0.00),('5','104','897','188723',3692379,'2673','395',1259470.10,1259470.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','188723',3692380,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','188723',3692381,'2675','394',1899677.76,1899677.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','188723',3692382,'2676','394',1316827.02,1316827.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','188832',3694284,'2669','394',1772873.92,1779541.17,6667.25,1086761.75,0.00,0.00,0.00,0.00,0.00),('5','104','895','188832',3694285,'2670','394',860382.25,861803.20,1420.95,231614.85,0.00,0.00,0.00,0.00,0.00),('5','104','896','188832',3694286,'2671','394',1517612.52,1527973.17,10360.65,1688785.95,0.00,0.00,0.00,0.00,0.00),('5','104','896','188832',3694287,'2672','394',825691.45,831429.06,5737.61,935230.43,0.00,0.00,0.00,0.00,0.00),('5','104','897','188832',3694288,'2673','395',1259470.10,1260191.85,721.75,191263.75,0.00,0.00,0.00,0.00,0.00),('5','104','898','188832',3694289,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','188832',3694290,'2675','394',1899677.76,1908793.00,9115.24,1485784.12,0.00,0.00,0.00,0.00,0.00),('5','104','896','188832',3694291,'2676','394',1316827.02,1316827.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','189089',3698921,'2669','394',1779541.17,1783223.29,3682.12,600185.56,0.00,0.00,0.00,0.00,0.00),('5','104','895','189089',3698922,'2670','394',861803.20,864843.80,3040.60,495617.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','189089',3698923,'2671','394',1527973.17,1528140.33,167.16,27247.08,0.00,0.00,0.00,0.00,0.00),('5','104','896','189089',3698924,'2672','394',831429.06,831520.41,91.35,14890.05,0.00,0.00,0.00,0.00,0.00),('5','104','897','189089',3698925,'2673','395',1260191.85,1261371.31,1179.46,312556.90,0.00,0.00,0.00,0.00,0.00),('5','104','898','189089',3698926,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','189089',3698927,'2675','394',1908793.00,1913825.31,5032.31,820266.53,0.00,0.00,0.00,0.00,0.00),('5','104','896','189089',3698928,'2676','394',1316827.02,1316827.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','189233',3701451,'2669','394',1783223.29,1783223.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','189233',3701452,'2670','394',864843.80,864843.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','189233',3701453,'2671','394',1528140.33,1528140.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','189233',3701454,'2672','394',831520.41,831520.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','189233',3701455,'2673','395',1261371.31,1262636.76,1265.45,335344.25,0.00,0.00,0.00,0.00,0.00),('5','104','898','189233',3701456,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','189233',3701457,'2675','394',1913825.31,1913825.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','189233',3701458,'2676','394',1316827.02,1316827.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','189410',3704958,'2669','394',1783223.29,1783223.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','189410',3704959,'2670','394',864843.80,864843.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','189410',3704960,'2671','394',1528140.33,1528140.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','189410',3704961,'2672','394',831520.41,831520.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','189410',3704962,'2673','395',1262636.76,1265027.96,2391.20,633668.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','189410',3704963,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','189410',3704964,'2675','394',1913825.31,1913825.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','189410',3704965,'2676','394',1316827.02,1316827.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','189608',3708385,'2669','394',1783223.29,1783223.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','189608',3708386,'2670','394',864843.80,864843.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','189608',3708387,'2671','394',1528140.33,1528140.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','189608',3708388,'2672','394',831520.41,831520.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','189608',3708389,'2673','395',1265027.96,1266529.45,1501.49,397894.85,0.00,0.00,0.00,0.00,0.00),('5','104','898','189608',3708390,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','189608',3708391,'2675','394',1913825.31,1913825.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','189608',3708392,'2676','394',1316827.02,1316827.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','189848',3712376,'2669','394',1783223.29,1791088.03,7864.74,1281952.62,0.00,0.00,0.00,0.00,0.00),('5','104','895','189848',3712377,'2670','394',864843.80,870875.55,6031.75,983175.25,0.00,0.00,0.00,0.00,0.00),('5','104','896','189848',3712378,'2671','394',1528140.33,1528140.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','189848',3712379,'2672','394',831520.41,831520.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','189848',3712380,'2673','395',1266529.45,1268450.11,1920.66,508974.90,0.00,0.00,0.00,0.00,0.00),('5','104','898','189848',3712381,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','189848',3712382,'2675','394',1913825.31,1919749.43,5924.12,965631.56,0.00,0.00,0.00,0.00,0.00),('5','104','896','189848',3712383,'2676','394',1316827.02,1316827.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','190075',3716955,'2669','394',1791088.03,1794514.09,3426.06,558447.78,0.00,0.00,0.00,0.00,0.00),('5','104','895','190075',3716956,'2670','394',870875.55,874167.56,3292.01,536597.63,0.00,0.00,0.00,0.00,0.00),('5','104','896','190075',3716957,'2671','394',1528140.33,1528140.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','190075',3716958,'2672','394',831520.41,831520.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','190075',3716959,'2673','395',1268450.11,1269241.02,790.91,209591.15,0.00,0.00,0.00,0.00,0.00),('5','104','898','190075',3716960,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','190075',3716961,'2675','394',1919749.43,1923170.87,3421.44,557694.72,0.00,0.00,0.00,0.00,0.00),('5','104','896','190075',3716962,'2676','394',1316827.02,1316827.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','190278',3720666,'2669','394',1794514.09,1794514.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','190278',3720667,'2670','394',874167.56,874167.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','190278',3720668,'2671','394',1528140.33,1528140.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','190278',3720669,'2672','394',831520.41,831520.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','190278',3720670,'2673','395',1269241.02,1270582.27,1341.25,355431.25,0.00,0.00,0.00,0.00,0.00),('5','104','898','190278',3720671,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','190278',3720672,'2675','394',1923170.87,1923170.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','190278',3720673,'2676','394',1316827.02,1316827.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','190457',3724042,'2669','394',1794514.09,1794534.37,20.28,3346.20,0.00,0.00,0.00,0.00,0.00),('5','104','895','190457',3724043,'2670','394',874167.56,881777.15,7609.59,1255582.35,0.00,0.00,0.00,0.00,0.00),('5','104','896','190457',3724044,'2671','394',1528140.33,1528140.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','190457',3724045,'2672','394',831520.41,832883.22,1362.81,224863.65,0.00,0.00,0.00,0.00,0.00),('5','104','897','190457',3724046,'2673','395',1270582.27,1272370.05,1787.78,473761.70,0.00,0.00,0.00,0.00,0.00),('5','104','898','190457',3724047,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','190457',3724048,'2675','394',1923170.87,1931151.45,7980.58,1316795.70,0.00,0.00,0.00,0.00,0.00),('5','104','896','190457',3724049,'2676','394',1316827.02,1316827.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','190806',3730659,'2669','394',1794534.37,1794534.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','190806',3730660,'2670','394',881777.15,885596.12,3818.97,630130.05,0.00,0.00,0.00,0.00,0.00),('5','104','896','190806',3730661,'2671','394',1528140.33,1530404.64,2264.31,373611.15,0.00,0.00,0.00,0.00,0.00),('5','104','896','190806',3730662,'2672','394',832883.22,837037.42,4154.20,685443.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','190806',3730663,'2673','395',1272370.05,1274793.03,2422.98,642089.70,0.00,0.00,0.00,0.00,0.00),('5','104','898','190806',3730664,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','190806',3730665,'2675','394',1931151.45,1934890.43,3738.98,616931.70,0.00,0.00,0.00,0.00,0.00),('5','104','896','190806',3730666,'2676','394',1316827.02,1316827.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','190917',3732517,'2669','394',1794534.37,1794534.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','190917',3732518,'2670','394',885596.12,888982.20,3386.08,558703.20,0.00,0.00,0.00,0.00,0.00),('5','104','896','190917',3732519,'2671','394',1530404.64,1532870.69,2466.05,406898.25,0.00,0.00,0.00,0.00,0.00),('5','104','896','190917',3732520,'2672','394',837037.42,840372.97,3335.55,550365.75,0.00,0.00,0.00,0.00,0.00),('5','104','897','190917',3732521,'2673','395',1274793.03,1275980.65,1187.62,314719.30,0.00,0.00,0.00,0.00,0.00),('5','104','898','190917',3732522,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','190917',3732523,'2675','394',1934890.43,1938662.01,3771.58,622310.70,0.00,0.00,0.00,0.00,0.00),('5','104','896','190917',3732524,'2676','394',1316827.02,1316922.34,95.32,15727.80,0.00,0.00,0.00,0.00,0.00),('5','104','895','191744',3747617,'2669','394',1794534.37,1799059.43,4525.06,746634.90,0.00,0.00,0.00,0.00,0.00),('5','104','895','191744',3747618,'2670','394',888982.20,892972.75,3990.55,658440.75,0.00,0.00,0.00,0.00,0.00),('5','104','896','191744',3747619,'2671','394',1532870.69,1532870.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','191744',3747620,'2672','394',840372.97,841886.82,1513.85,249785.25,0.00,0.00,0.00,0.00,0.00),('5','104','897','191744',3747621,'2673','395',1275980.65,1279387.76,3407.11,902884.15,0.00,0.00,0.00,0.00,0.00),('5','104','898','191744',3747622,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','191744',3747623,'2675','394',1938662.01,1943584.57,4922.56,812222.40,0.00,0.00,0.00,0.00,0.00),('5','104','896','191744',3747624,'2676','394',1316922.34,1316922.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','191797',3748776,'2669','394',1799059.43,1801247.07,2187.64,360960.60,0.00,0.00,0.00,0.00,0.00),('5','104','895','191797',3748777,'2670','394',892972.75,894184.02,1211.27,199859.55,0.00,0.00,0.00,0.00,0.00),('5','104','896','191797',3748778,'2671','394',1532870.69,1534046.04,1175.35,193932.75,0.00,0.00,0.00,0.00,0.00),('5','104','896','191797',3748779,'2672','394',841886.82,843255.11,1368.29,225767.85,0.00,0.00,0.00,0.00,0.00),('5','104','897','191797',3748780,'2673','395',1279387.76,1281058.85,1671.09,442838.85,0.00,0.00,0.00,0.00,0.00),('5','104','898','191797',3748781,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','191797',3748782,'2675','394',1943584.57,1946954.49,3369.92,556036.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','191797',3748783,'2676','394',1316922.34,1320473.51,3551.17,585943.05,0.00,0.00,0.00,0.00,0.00),('5','104','895','191811',3749044,'2669','394',1801247.07,1801247.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','191811',3749045,'2670','394',894184.02,896897.69,2713.67,447755.55,0.00,0.00,0.00,0.00,0.00),('5','104','896','191811',3749046,'2671','394',1534046.04,1535076.18,1030.14,169973.10,0.00,0.00,0.00,0.00,0.00),('5','104','896','191811',3749047,'2672','394',843255.11,847010.70,3755.59,619672.35,0.00,0.00,0.00,0.00,0.00),('5','104','897','191811',3749048,'2673','395',1281058.85,1282477.85,1419.00,376035.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','191811',3749049,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','191811',3749050,'2675','394',1946954.49,1950015.97,3061.48,505144.20,0.00,0.00,0.00,0.00,0.00),('5','104','896','191811',3749051,'2676','394',1320473.51,1320536.62,63.11,10413.15,0.00,0.00,0.00,0.00,0.00),('5','104','895','191829',3749436,'2669','394',1801247.07,1801270.45,23.38,3857.70,0.00,0.00,0.00,0.00,0.00),('5','104','895','191829',3749437,'2670','394',896897.69,899103.19,2205.50,363907.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','191829',3749438,'2671','394',1535076.18,1538859.71,3783.53,624282.45,0.00,0.00,0.00,0.00,0.00),('5','104','896','191829',3749439,'2672','394',847010.70,852218.63,5207.93,859308.45,0.00,0.00,0.00,0.00,0.00),('5','104','897','191829',3749440,'2673','395',1282477.85,1283342.05,864.20,229013.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','191829',3749441,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','191829',3749442,'2675','394',1950015.97,1951986.48,1970.51,325134.15,0.00,0.00,0.00,0.00,0.00),('5','104','896','191829',3749443,'2676','394',1320536.62,1325972.66,5436.04,896946.60,0.00,0.00,0.00,0.00,0.00),('5','104','895','191977',3752044,'2669','394',1801270.45,1801270.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','191977',3752045,'2670','394',899103.19,899103.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','191977',3752046,'2671','394',1538859.71,1539904.61,1044.90,172408.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','191977',3752047,'2672','394',852218.63,853360.87,1142.24,188469.60,0.00,0.00,0.00,0.00,0.00),('5','104','897','191977',3752048,'2673','395',1283342.05,1283738.46,396.41,105048.65,0.00,0.00,0.00,0.00,0.00),('5','104','898','191977',3752049,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','191977',3752050,'2675','394',1951986.48,1951986.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','191977',3752051,'2676','394',1325972.66,1326801.29,828.63,136723.95,0.00,0.00,0.00,0.00,0.00),('5','104','895','192259',3757408,'2669','394',1801270.45,1801270.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','192259',3757409,'2670','394',899103.19,899103.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','192259',3757410,'2671','394',1539904.61,1539904.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','192259',3757411,'2672','394',853360.87,853360.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','192259',3757412,'2673','395',1283738.46,1285459.87,1721.41,456173.65,0.00,0.00,0.00,0.00,0.00),('5','104','898','192259',3757413,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','192259',3757414,'2675','394',1951986.48,1951986.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','192259',3757415,'2676','394',1326801.29,1326801.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','192378',3759309,'2669','394',1801270.45,1801270.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','192378',3759310,'2670','394',899103.19,899103.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','192378',3759311,'2671','394',1539904.61,1539904.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','192378',3759312,'2672','394',853360.87,853360.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','192378',3759313,'2673','395',1285459.87,1286505.11,1045.24,276988.60,0.00,0.00,0.00,0.00,0.00),('5','104','898','192378',3759314,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','192378',3759315,'2675','394',1951986.48,1951986.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','192378',3759316,'2676','394',1326801.29,1326801.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','192611',3763488,'2669','394',1801270.45,1804371.42,3100.97,511660.05,0.00,0.00,0.00,0.00,0.00),('5','104','895','192611',3763489,'2670','394',899103.19,902592.08,3488.89,575666.85,0.00,0.00,0.00,0.00,0.00),('5','104','896','192611',3763490,'2671','394',1539904.61,1539904.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','192611',3763491,'2672','394',853360.87,857963.89,4603.02,759498.30,0.00,0.00,0.00,0.00,0.00),('5','104','897','192611',3763492,'2673','395',1286505.11,1287654.69,1149.58,304638.70,0.00,0.00,0.00,0.00,0.00),('5','104','898','192611',3763493,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','192611',3763494,'2675','394',1951986.48,1956695.20,4708.72,776938.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','192611',3763495,'2676','394',1326801.29,1326801.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','192800',3766818,'2669','394',1804371.42,1804397.74,26.32,4342.80,0.00,0.00,0.00,0.00,0.00),('5','104','895','192800',3766819,'2670','394',902592.08,905437.87,2845.79,469555.35,0.00,0.00,0.00,0.00,0.00),('5','104','896','192800',3766820,'2671','394',1539904.61,1542524.52,2619.91,432285.15,0.00,0.00,0.00,0.00,0.00),('5','104','896','192800',3766821,'2672','394',857963.89,860652.82,2688.93,443673.45,0.00,0.00,0.00,0.00,0.00),('5','104','897','192800',3766822,'2673','395',1287654.69,1288307.20,652.51,172915.15,0.00,0.00,0.00,0.00,0.00),('5','104','898','192800',3766823,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','192800',3766824,'2675','394',1956695.20,1960215.92,3520.72,580918.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','192800',3766825,'2676','394',1326801.29,1326801.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','193041',3771448,'2669','394',1804397.74,1804397.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','193041',3771449,'2670','394',905437.87,906066.41,628.54,103709.10,0.00,0.00,0.00,0.00,0.00),('5','104','896','193041',3771450,'2671','394',1542524.52,1544208.05,1683.53,277782.45,0.00,0.00,0.00,0.00,0.00),('5','104','896','193041',3771451,'2672','394',860652.82,862569.29,1916.47,316217.55,0.00,0.00,0.00,0.00,0.00),('5','104','897','193041',3771452,'2673','395',1288307.20,1288465.84,158.64,42039.60,0.00,0.00,0.00,0.00,0.00),('5','104','898','193041',3771453,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','193041',3771454,'2675','394',1960215.92,1960395.68,179.76,29660.40,0.00,0.00,0.00,0.00,0.00),('5','104','896','193041',3771455,'2676','394',1326801.29,1326801.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','193245',3775287,'2669','394',1804397.74,1804397.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','193245',3775288,'2670','394',906066.41,906066.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','193245',3775289,'2671','394',1544208.05,1544208.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','193245',3775290,'2672','394',862569.29,862569.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','193245',3775291,'2673','395',1288465.84,1289331.64,865.80,229437.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','193245',3775292,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','193245',3775293,'2675','394',1960395.68,1960395.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','193245',3775294,'2676','394',1326801.29,1326801.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','193429',3779053,'2669','394',1804397.74,1804397.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','193429',3779054,'2670','394',906066.41,906066.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','193429',3779055,'2671','394',1544208.05,1550541.84,6333.79,1045075.35,0.00,0.00,0.00,0.00,0.00),('5','104','896','193429',3779056,'2672','394',862569.29,867658.86,5089.57,839779.05,0.00,0.00,0.00,0.00,0.00),('5','104','897','193429',3779057,'2673','395',1289331.64,1289331.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','193429',3779058,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','193429',3779059,'2675','394',1960395.68,1960395.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','193429',3779060,'2676','394',1326801.29,1326801.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','193898',3787447,'2669','394',1804397.74,1804397.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','193898',3787448,'2670','394',906066.41,906066.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','193898',3787449,'2671','394',1550541.84,1550541.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','193898',3787450,'2672','394',867658.86,868581.00,922.14,152153.10,0.00,0.00,0.00,0.00,0.00),('5','104','897','193898',3787451,'2673','395',1289331.64,1289988.83,657.19,174155.35,0.00,0.00,0.00,0.00,0.00),('5','104','898','193898',3787452,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','193898',3787453,'2675','394',1960395.68,1960395.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','193898',3787454,'2676','394',1326801.29,1326801.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','193914',3787772,'2669','394',1804397.74,1804397.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','193914',3787773,'2670','394',906066.41,906066.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','193914',3787774,'2671','394',1550541.84,1550541.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','193914',3787775,'2672','394',868581.00,868581.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','193914',3787776,'2673','395',1289988.83,1290500.59,511.76,135616.40,0.00,0.00,0.00,0.00,0.00),('5','104','898','193914',3787777,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','193914',3787778,'2675','394',1960395.68,1960395.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','193914',3787779,'2676','394',1326801.29,1326801.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','194151',3792047,'2669','394',1804397.74,1804397.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','194151',3792048,'2670','394',906066.41,906066.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','194151',3792049,'2671','394',1550541.84,1550541.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','194151',3792050,'2672','394',868581.00,868581.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','194151',3792051,'2673','395',1290500.59,1291864.29,1363.70,361380.50,0.00,0.00,0.00,0.00,0.00),('5','104','898','194151',3792052,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','194151',3792053,'2675','394',1960395.68,1960395.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','194151',3792054,'2676','394',1326801.29,1326801.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','194394',3796590,'2669','394',1804397.74,1804397.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','194394',3796591,'2670','394',906066.41,906066.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','194394',3796592,'2671','394',1550541.84,1550541.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','194394',3796593,'2672','394',868581.00,868581.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','194394',3796594,'2673','395',1291864.29,1292319.04,454.75,120508.75,0.00,0.00,0.00,0.00,0.00),('5','104','898','194394',3796595,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','194394',3796596,'2675','394',1960395.68,1960395.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','194394',3796597,'2676','394',1326801.29,1326801.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','194565',3799513,'2669','394',1804397.74,1804397.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','194565',3799514,'2670','394',906066.41,906066.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','194565',3799515,'2671','394',1550541.84,1550541.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','194565',3799516,'2672','394',868581.00,868581.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','194565',3799517,'2673','395',1292319.04,1292845.01,525.97,139382.05,0.00,0.00,0.00,0.00,0.00),('5','104','898','194565',3799518,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','194565',3799519,'2675','394',1960395.68,1960395.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','194565',3799520,'2676','394',1326801.29,1326801.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','194936',3806923,'2669','394',1804397.74,1804454.67,56.93,9393.45,0.00,0.00,0.00,0.00,0.00),('5','104','895','194936',3806924,'2670','394',906066.41,907906.37,1839.96,303593.40,0.00,0.00,0.00,0.00,0.00),('5','104','896','194936',3806925,'2671','394',1550541.84,1551651.12,1109.28,183031.20,0.00,0.00,0.00,0.00,0.00),('5','104','896','194936',3806926,'2672','394',868581.00,869905.82,1324.82,218595.30,0.00,0.00,0.00,0.00,0.00),('5','104','897','194936',3806927,'2673','395',1292845.01,1293463.65,618.64,163939.60,0.00,0.00,0.00,0.00,0.00),('5','104','898','194936',3806928,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','194936',3806929,'2675','394',1960395.68,1962001.45,1605.77,264952.05,0.00,0.00,0.00,0.00,0.00),('5','104','896','194936',3806930,'2676','394',1326801.29,1326801.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','195057',3809018,'2669','394',1804454.67,1804454.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','195057',3809019,'2670','394',907906.37,910447.96,2541.59,419362.35,0.00,0.00,0.00,0.00,0.00),('5','104','896','195057',3809020,'2671','394',1551651.12,1554187.68,2536.56,418532.40,0.00,0.00,0.00,0.00,0.00),('5','104','896','195057',3809021,'2672','394',869905.82,872251.89,2346.07,387101.55,0.00,0.00,0.00,0.00,0.00),('5','104','897','195057',3809022,'2673','395',1293463.65,1293846.64,382.99,101492.35,0.00,0.00,0.00,0.00,0.00),('5','104','898','195057',3809023,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','195057',3809024,'2675','394',1962001.45,1964250.68,2249.23,371122.95,0.00,0.00,0.00,0.00,0.00),('5','104','896','195057',3809025,'2676','394',1326801.29,1326801.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','195178',3811152,'2669','394',1804454.67,1804454.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','195178',3811153,'2670','394',910447.96,912710.15,2262.19,373261.35,0.00,0.00,0.00,0.00,0.00),('5','104','896','195178',3811154,'2671','394',1554187.68,1556628.91,2441.23,402802.95,0.00,0.00,0.00,0.00,0.00),('5','104','896','195178',3811155,'2672','394',872251.89,874826.92,2575.03,424879.95,0.00,0.00,0.00,0.00,0.00),('5','104','897','195178',3811156,'2673','395',1293846.64,1296409.32,2562.68,679110.20,0.00,0.00,0.00,0.00,0.00),('5','104','898','195178',3811157,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','195178',3811158,'2675','394',1964250.68,1967566.98,3316.30,547189.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','195178',3811159,'2676','394',1326801.29,1326801.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','195400',3814965,'2669','394',1804454.67,1804454.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','195400',3814966,'2670','394',912710.15,916002.88,3292.73,543300.45,0.00,0.00,0.00,0.00,0.00),('5','104','896','195400',3814967,'2671','394',1556628.91,1559423.92,2795.01,461176.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','195400',3814968,'2672','394',874826.92,878323.01,3496.09,576854.85,0.00,0.00,0.00,0.00,0.00),('5','104','897','195400',3814969,'2673','395',1296409.32,1298393.08,1983.76,525696.40,0.00,0.00,0.00,0.00,0.00),('5','104','898','195400',3814970,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','195400',3814971,'2675','394',1967566.98,1971426.45,3859.47,636812.55,0.00,0.00,0.00,0.00,0.00),('5','104','896','195400',3814972,'2676','394',1326801.29,1326801.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','195727',3820657,'2669','394',1804454.67,1804454.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','195727',3820658,'2670','394',916002.88,918606.30,2603.42,429564.30,0.00,0.00,0.00,0.00,0.00),('5','104','896','195727',3820659,'2671','394',1559423.92,1563968.68,4544.76,749885.40,0.00,0.00,0.00,0.00,0.00),('5','104','896','195727',3820660,'2672','394',878323.01,882073.06,3750.05,618758.25,0.00,0.00,0.00,0.00,0.00),('5','104','897','195727',3820661,'2673','395',1298393.08,1300105.09,1712.01,453682.65,0.00,0.00,0.00,0.00,0.00),('5','104','898','195727',3820662,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','195727',3820663,'2675','394',1971426.45,1976296.65,4870.20,803583.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','195727',3820664,'2676','394',1326801.29,1326801.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','195879',3823185,'2669','394',1804454.67,1804454.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','195879',3823186,'2670','394',918606.30,919692.17,1085.87,179168.55,0.00,0.00,0.00,0.00,0.00),('5','104','896','195879',3823187,'2671','394',1563968.68,1565497.24,1528.56,252212.40,0.00,0.00,0.00,0.00,0.00),('5','104','896','195879',3823188,'2672','394',882073.06,883761.09,1688.03,278524.95,0.00,0.00,0.00,0.00,0.00),('5','104','897','195879',3823189,'2673','395',1300105.09,1300417.37,312.28,82754.20,0.00,0.00,0.00,0.00,0.00),('5','104','898','195879',3823190,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','195879',3823191,'2675','394',1976296.65,1977006.18,709.53,117072.45,0.00,0.00,0.00,0.00,0.00),('5','104','896','195879',3823192,'2676','394',1326801.29,1326801.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','196107',3827413,'2669','394',1804454.67,1804454.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','196107',3827414,'2670','394',919692.17,919692.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','196107',3827415,'2671','394',1565497.24,1565497.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','196107',3827416,'2672','394',883761.09,883761.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','196107',3827417,'2673','395',1300417.37,1300596.31,178.94,47419.10,0.00,0.00,0.00,0.00,0.00),('5','104','898','196107',3827418,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','196107',3827419,'2675','394',1977006.18,1977006.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','196107',3827420,'2676','394',1326801.29,1326801.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','196316',3831458,'2669','394',1804454.67,1804454.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','196316',3831459,'2670','394',919692.17,919692.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','196316',3831460,'2671','394',1565497.24,1565497.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','196316',3831461,'2672','394',883761.09,883761.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','196316',3831462,'2673','395',1300596.31,1301136.98,540.67,143277.55,0.00,0.00,0.00,0.00,0.00),('5','104','898','196316',3831463,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','196316',3831464,'2675','394',1977006.18,1977006.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','196316',3831465,'2676','394',1326801.29,1326801.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','196516',3835006,'2669','394',1804454.67,1804454.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','196516',3835007,'2670','394',919692.17,919692.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','196516',3835008,'2671','394',1565497.24,1565497.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','196516',3835009,'2672','394',883761.09,883761.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','196516',3835010,'2673','395',1301136.98,1301502.55,365.57,96876.05,0.00,0.00,0.00,0.00,0.00),('5','104','898','196516',3835011,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','196516',3835012,'2675','394',1977006.18,1977006.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','196516',3835013,'2676','394',1326801.29,1326801.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','196811',3840281,'2669','394',1804454.67,1804454.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','196811',3840282,'2670','394',919692.17,919692.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','196811',3840283,'2671','394',1565497.24,1565497.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','196811',3840284,'2672','394',883761.09,883761.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','196811',3840285,'2673','395',1301502.55,1301671.24,168.69,44702.85,0.00,0.00,0.00,0.00,0.00),('5','104','898','196811',3840286,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','196811',3840287,'2675','394',1977006.18,1977006.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','196811',3840288,'2676','394',1326801.29,1326801.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','196859',3841159,'2669','394',1804454.67,1807694.84,3240.17,534628.05,0.00,0.00,0.00,0.00,0.00),('5','104','895','196859',3841160,'2670','394',919692.17,922673.04,2980.87,491843.55,0.00,0.00,0.00,0.00,0.00),('5','104','896','196859',3841161,'2671','394',1565497.24,1565515.45,18.21,3004.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','196859',3841162,'2672','394',883761.09,883765.07,3.98,656.70,0.00,0.00,0.00,0.00,0.00),('5','104','897','196859',3841163,'2673','395',1301671.24,1302677.90,1006.66,266764.90,0.00,0.00,0.00,0.00,0.00),('5','104','898','196859',3841164,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','196859',3841165,'2675','394',1977006.18,1977006.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','196859',3841166,'2676','394',1326801.29,1326801.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','197210',3847409,'2669','394',1807694.84,1812366.66,4671.82,770850.30,0.00,0.00,0.00,0.00,0.00),('5','104','895','197210',3847410,'2670','394',922673.04,926343.78,3670.74,605672.10,0.00,0.00,0.00,0.00,0.00),('5','104','896','197210',3847411,'2671','394',1565515.45,1565515.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','197210',3847412,'2672','394',883765.07,883765.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','197210',3847413,'2673','395',1302677.90,1303781.04,1103.14,292332.10,0.00,0.00,0.00,0.00,0.00),('5','104','898','197210',3847414,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','197210',3847415,'2675','394',1977006.18,1977006.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','197210',3847416,'2676','394',1326801.29,1326801.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','197500',3852246,'2669','394',1812366.66,1815210.84,2844.18,469289.70,0.00,0.00,0.00,0.00,0.00),('5','104','895','197500',3852247,'2670','394',926343.78,929747.71,3403.93,561648.45,0.00,0.00,0.00,0.00,0.00),('5','104','896','197500',3852248,'2671','394',1565515.45,1567487.26,1971.81,325348.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','197500',3852249,'2672','394',883765.07,885749.24,1984.17,327388.05,0.00,0.00,0.00,0.00,0.00),('5','104','897','197500',3852250,'2673','395',1303781.04,1305643.17,1862.13,493464.45,0.00,0.00,0.00,0.00,0.00),('5','104','898','197500',3852251,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','197500',3852252,'2675','394',1977006.18,1977006.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','197500',3852253,'2676','394',1326801.29,1326801.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','197992',3860995,'2669','394',1815210.84,1819121.56,3910.72,645268.80,0.00,0.00,0.00,0.00,0.00),('5','104','895','197992',3860996,'2670','394',929747.71,932798.56,3050.85,503390.25,0.00,0.00,0.00,0.00,0.00),('5','104','896','197992',3860997,'2671','394',1567487.26,1569910.85,2423.59,399892.35,0.00,0.00,0.00,0.00,0.00),('5','104','896','197992',3860998,'2672','394',885749.24,886921.27,1172.03,193384.95,0.00,0.00,0.00,0.00,0.00),('5','104','897','197992',3860999,'2673','395',1305643.17,1306833.69,1190.52,315487.80,0.00,0.00,0.00,0.00,0.00),('5','104','898','197992',3861000,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','197992',3861001,'2675','394',1977006.18,1977006.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','197992',3861002,'2676','394',1326801.29,1326801.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','198009',3861324,'2669','394',1819121.56,1823283.23,4161.67,686675.55,0.00,0.00,0.00,0.00,0.00),('5','104','895','198009',3861325,'2670','394',932798.56,935822.56,3024.00,498960.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','198009',3861326,'2671','394',1569910.85,1574983.71,5072.86,837021.90,0.00,0.00,0.00,0.00,0.00),('5','104','896','198009',3861327,'2672','394',886921.27,887770.67,849.40,140151.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','198009',3861328,'2673','395',1306833.69,1307522.95,689.26,186100.20,0.00,0.00,0.00,0.00,0.00),('5','104','898','198009',3861329,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','198009',3861330,'2675','394',1977006.18,1977006.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','198009',3861331,'2676','394',1326801.29,1326801.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','198016',3861399,'2669','394',1823283.23,1824760.14,1476.91,243690.15,0.00,0.00,0.00,0.00,0.00),('5','104','895','198016',3861400,'2670','394',935822.56,938325.17,2502.61,412930.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','198016',3861401,'2671','394',1574983.71,1578204.33,3220.62,531402.30,0.00,0.00,0.00,0.00,0.00),('5','104','896','198016',3861402,'2672','394',887770.67,890088.69,2318.02,382473.30,0.00,0.00,0.00,0.00,0.00),('5','104','897','198016',3861403,'2673','395',1307522.95,1308422.49,899.54,242875.80,0.00,0.00,0.00,0.00,0.00),('5','104','898','198016',3861404,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','198016',3861405,'2675','394',1977006.18,1977006.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','198016',3861406,'2676','394',1326801.29,1326801.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','198220',3864679,'2669','394',1824760.14,1827243.09,2482.95,409686.75,0.00,0.00,0.00,0.00,0.00),('5','104','895','198220',3864680,'2670','394',938325.17,940861.06,2535.89,418421.85,0.00,0.00,0.00,0.00,0.00),('5','104','896','198220',3864681,'2671','394',1578204.33,1579677.25,1472.92,243031.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','198220',3864682,'2672','394',890088.69,892172.87,2084.18,343889.70,0.00,0.00,0.00,0.00,0.00),('5','104','897','198220',3864683,'2673','395',1308422.49,1311132.59,2710.10,731727.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','198220',3864684,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','198220',3864685,'2675','394',1977006.18,1977006.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','198220',3864686,'2676','394',1326801.29,1326801.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','198434',3868460,'2669','394',1827243.09,1829611.01,2367.92,390706.80,0.00,0.00,0.00,0.00,0.00),('5','104','895','198434',3868461,'2670','394',940861.06,943402.45,2541.39,419329.35,0.00,0.00,0.00,0.00,0.00),('5','104','896','198434',3868462,'2671','394',1579677.25,1582121.56,2444.31,403311.15,0.00,0.00,0.00,0.00,0.00),('5','104','896','198434',3868463,'2672','394',892172.87,894484.56,2311.69,381428.85,0.00,0.00,0.00,0.00,0.00),('5','104','897','198434',3868464,'2673','395',1311132.59,1311817.63,685.04,184960.80,0.00,0.00,0.00,0.00,0.00),('5','104','898','198434',3868465,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','198434',3868466,'2675','394',1977006.18,1977006.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','198434',3868467,'2676','394',1326801.29,1326801.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','198744',3874000,'2669','394',1829611.01,1831727.11,2116.10,349156.50,0.00,0.00,0.00,0.00,0.00),('5','104','895','198744',3874001,'2670','394',943402.45,945339.37,1936.92,319591.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','198744',3874002,'2671','394',1582121.56,1584903.50,2781.94,459020.10,0.00,0.00,0.00,0.00,0.00),('5','104','896','198744',3874003,'2672','394',894484.56,897597.51,3112.95,513636.75,0.00,0.00,0.00,0.00,0.00),('5','104','897','198744',3874004,'2673','395',1311817.63,1313011.77,1194.14,322417.80,0.00,0.00,0.00,0.00,0.00),('5','104','898','198744',3874005,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','198744',3874006,'2675','394',1977006.18,1977006.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','198744',3874007,'2676','394',1326801.29,1326801.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','198834',3875120,'2669','394',1831727.11,1834700.12,2973.01,490546.65,0.00,0.00,0.00,0.00,0.00),('5','104','895','198834',3875121,'2670','394',945339.37,947809.94,2470.57,407644.05,0.00,0.00,0.00,0.00,0.00),('5','104','896','198834',3875122,'2671','394',1584903.50,1587287.85,2384.35,393417.75,0.00,0.00,0.00,0.00,0.00),('5','104','896','198834',3875123,'2672','394',897597.51,899122.89,1525.38,251687.70,0.00,0.00,0.00,0.00,0.00),('5','104','897','198834',3875124,'2673','395',1313011.77,1314876.12,1864.35,503374.50,0.00,0.00,0.00,0.00,0.00),('5','104','898','198834',3875125,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','198834',3875126,'2675','394',1977006.18,1977006.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','198834',3875127,'2676','394',1326801.29,1326801.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','199044',3878905,'2669','394',1834700.12,1837595.32,2895.20,477708.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','199044',3878906,'2670','394',947809.94,950695.54,2885.60,476124.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','199044',3878907,'2671','394',1587287.85,1589564.53,2276.68,375652.20,0.00,0.00,0.00,0.00,0.00),('5','104','896','199044',3878908,'2672','394',899122.89,899452.78,329.89,54431.85,0.00,0.00,0.00,0.00,0.00),('5','104','897','199044',3878909,'2673','395',1314876.12,1315374.40,498.28,134535.60,0.00,0.00,0.00,0.00,0.00),('5','104','898','199044',3878910,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','199044',3878911,'2675','394',1977006.18,1977006.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','199044',3878912,'2676','394',1326801.29,1326801.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','199296',3882976,'2669','394',1837595.32,1841436.37,3841.05,633773.25,0.00,0.00,0.00,0.00,0.00),('5','104','895','199296',3882977,'2670','394',950695.54,953294.62,2599.08,428848.20,0.00,0.00,0.00,0.00,0.00),('5','104','896','199296',3882978,'2671','394',1589564.53,1592882.34,3317.81,547438.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','199296',3882979,'2672','394',899452.78,900064.66,611.88,100960.20,0.00,0.00,0.00,0.00,0.00),('5','104','897','199296',3882980,'2673','395',1315374.40,1316789.62,1415.22,382109.40,0.00,0.00,0.00,0.00,0.00),('5','104','898','199296',3882981,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','199296',3882982,'2675','394',1977006.18,1977006.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','199296',3882983,'2676','394',1326801.29,1326801.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','199602',3888566,'2669','394',1841436.37,1845191.29,3754.92,619561.80,0.00,0.00,0.00,0.00,0.00),('5','104','895','199602',3888567,'2670','394',953294.62,955715.92,2421.30,399514.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','199602',3888568,'2671','394',1592882.34,1595905.59,3023.25,498836.25,0.00,0.00,0.00,0.00,0.00),('5','104','896','199602',3888569,'2672','394',900064.66,900065.10,0.44,72.60,0.00,0.00,0.00,0.00,0.00),('5','104','897','199602',3888570,'2673','395',1316789.62,1318744.44,1954.82,527801.40,0.00,0.00,0.00,0.00,0.00),('5','104','898','199602',3888571,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','199602',3888572,'2675','394',1977006.18,1977006.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','199602',3888573,'2676','394',1326801.29,1326801.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','199774',3890911,'2669','394',1845191.29,1846589.92,1398.63,230773.95,0.00,0.00,0.00,0.00,0.00),('5','104','895','199774',3890912,'2670','394',955715.92,958597.87,2881.95,475521.75,0.00,0.00,0.00,0.00,0.00),('5','104','896','199774',3890913,'2671','394',1595905.59,1599409.07,3503.48,578074.20,0.00,0.00,0.00,0.00,0.00),('5','104','896','199774',3890914,'2672','394',900065.10,900368.65,303.55,50085.75,0.00,0.00,0.00,0.00,0.00),('5','104','897','199774',3890915,'2673','395',1318744.44,1319741.70,997.26,269260.20,0.00,0.00,0.00,0.00,0.00),('5','104','898','199774',3890916,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','199774',3890917,'2675','394',1977006.18,1977849.99,843.81,139228.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','199774',3890918,'2676','394',1326801.29,1326801.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','199981',3894614,'2669','394',1846589.92,1847329.59,739.67,122045.55,0.00,0.00,0.00,0.00,0.00),('5','104','895','199981',3894615,'2670','394',958597.87,958597.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','199981',3894616,'2671','394',1599409.07,1603936.68,4527.61,747055.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','199981',3894617,'2672','394',900368.65,903979.68,3611.03,595819.95,0.00,0.00,0.00,0.00,0.00),('5','104','897','199981',3894618,'2673','395',1319741.70,1321762.68,2020.98,545664.60,0.00,0.00,0.00,0.00,0.00),('5','104','898','199981',3894619,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','199981',3894620,'2675','394',1977849.99,1978511.46,661.47,109142.55,0.00,0.00,0.00,0.00,0.00),('5','104','896','199981',3894621,'2676','394',1326801.29,1326801.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','200157',3897761,'2669','394',1847329.59,1847615.98,286.39,47254.35,0.00,0.00,0.00,0.00,0.00),('5','104','895','200157',3897762,'2670','394',958597.87,961700.02,3102.15,511854.75,0.00,0.00,0.00,0.00,0.00),('5','104','896','200157',3897763,'2671','394',1603936.68,1606227.25,2290.57,377944.05,0.00,0.00,0.00,0.00,0.00),('5','104','896','200157',3897764,'2672','394',903979.68,905677.03,1697.35,280062.75,0.00,0.00,0.00,0.00,0.00),('5','104','897','200157',3897765,'2673','395',1321762.68,1322560.77,798.09,215484.30,0.00,0.00,0.00,0.00,0.00),('5','104','898','200157',3897766,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','200157',3897767,'2675','394',1978511.46,1981694.71,3183.25,525236.25,0.00,0.00,0.00,0.00,0.00),('5','104','896','200157',3897768,'2676','394',1326801.29,1327047.88,246.59,40687.35,0.00,0.00,0.00,0.00,0.00),('5','104','895','200326',3900624,'2669','394',1847615.98,1848740.27,1124.29,185507.85,0.00,0.00,0.00,0.00,0.00),('5','104','895','200326',3900625,'2670','394',961700.02,962051.94,351.92,58066.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','200326',3900626,'2671','394',1606227.25,1608269.96,2042.71,337047.15,0.00,0.00,0.00,0.00,0.00),('5','104','896','200326',3900627,'2672','394',905677.03,907272.82,1595.79,263305.35,0.00,0.00,0.00,0.00,0.00),('5','104','897','200326',3900628,'2673','395',1322560.77,1322560.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','200326',3900629,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','200326',3900630,'2675','394',1981694.71,1984614.54,2919.83,481771.95,0.00,0.00,0.00,0.00,0.00),('5','104','896','200326',3900631,'2676','394',1327047.88,1328739.98,1692.10,279196.50,0.00,0.00,0.00,0.00,0.00),('5','104','895','200521',3904386,'2669','394',1848740.27,1850424.59,1684.32,277912.80,0.00,0.00,0.00,0.00,0.00),('5','104','895','200521',3904387,'2670','394',962051.94,962776.53,724.59,119557.35,0.00,0.00,0.00,0.00,0.00),('5','104','896','200521',3904388,'2671','394',1608269.96,1610687.97,2418.01,398971.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','200521',3904389,'2672','394',907272.82,907837.49,564.67,93170.55,0.00,0.00,0.00,0.00,0.00),('5','104','897','200521',3904390,'2673','395',1322560.77,1322560.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','200521',3904391,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','200521',3904392,'2675','394',1984614.54,1987530.71,2916.17,481168.05,0.00,0.00,0.00,0.00,0.00),('5','104','896','200521',3904393,'2676','394',1328739.98,1329816.11,1076.13,177561.45,0.00,0.00,0.00,0.00,0.00),('5','104','895','200755',3908471,'2669','394',1850424.59,1852476.59,2052.00,338580.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','200755',3908472,'2670','394',962776.53,964654.74,1878.21,309904.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','200755',3908473,'2671','394',1610687.97,1612406.86,1718.89,283616.85,0.00,0.00,0.00,0.00,0.00),('5','104','896','200755',3908474,'2672','394',907837.49,909716.33,1878.84,310008.60,0.00,0.00,0.00,0.00,0.00),('5','104','897','200755',3908475,'2673','395',1322560.77,1322560.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','200755',3908476,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','200755',3908477,'2675','394',1987530.71,1990294.28,2763.57,455989.05,0.00,0.00,0.00,0.00,0.00),('5','104','896','200755',3908478,'2676','394',1329816.11,1329828.35,12.24,2019.60,0.00,0.00,0.00,0.00,0.00),('5','104','895','200976',3912258,'2669','394',1852476.59,1854832.50,2355.91,388725.15,0.00,0.00,0.00,0.00,0.00),('5','104','895','200976',3912259,'2670','394',964654.74,966805.48,2150.74,354872.10,0.00,0.00,0.00,0.00,0.00),('5','104','896','200976',3912260,'2671','394',1612406.86,1613308.05,901.19,148696.35,0.00,0.00,0.00,0.00,0.00),('5','104','896','200976',3912261,'2672','394',909716.33,911872.52,2156.19,355771.35,0.00,0.00,0.00,0.00,0.00),('5','104','897','200976',3912262,'2673','395',1322560.77,1322560.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','200976',3912263,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','200976',3912264,'2675','394',1990294.28,1992737.56,2443.28,403141.20,0.00,0.00,0.00,0.00,0.00),('5','104','896','200976',3912265,'2676','394',1329828.35,1329828.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','201190',3915820,'2669','394',1854832.50,1856791.91,1959.41,323302.65,0.00,0.00,0.00,0.00,0.00),('5','104','895','201190',3915821,'2670','394',966805.48,967354.37,548.89,90566.85,0.00,0.00,0.00,0.00,0.00),('5','104','896','201190',3915822,'2671','394',1613308.05,1616272.44,2964.39,489124.35,0.00,0.00,0.00,0.00,0.00),('5','104','896','201190',3915823,'2672','394',911872.52,912914.79,1042.27,171974.55,0.00,0.00,0.00,0.00,0.00),('5','104','897','201190',3915824,'2673','395',1322560.77,1322560.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','201190',3915825,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','201190',3915826,'2675','394',1992737.56,1995315.60,2578.04,425376.60,0.00,0.00,0.00,0.00,0.00),('5','104','896','201190',3915827,'2676','394',1329828.35,1331294.97,1466.62,241992.30,0.00,0.00,0.00,0.00,0.00),('5','104','895','201365',3918743,'2669','394',1856791.91,1859307.09,2515.18,415004.70,0.00,0.00,0.00,0.00,0.00),('5','104','895','201365',3918744,'2670','394',967354.37,967654.37,300.00,49500.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','201365',3918745,'2671','394',1616272.44,1618542.28,2269.84,374523.60,0.00,0.00,0.00,0.00,0.00),('5','104','896','201365',3918746,'2672','394',912914.79,913468.74,553.95,91401.75,0.00,0.00,0.00,0.00,0.00),('5','104','897','201365',3918747,'2673','395',1322560.77,1322560.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','201365',3918748,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','201365',3918749,'2675','394',1995315.60,1998184.74,2869.14,473408.10,0.00,0.00,0.00,0.00,0.00),('5','104','896','201365',3918750,'2676','394',1331294.97,1332871.99,1577.02,260208.30,0.00,0.00,0.00,0.00,0.00),('5','104','895','201572',3922622,'2669','394',1859307.09,1860299.40,992.31,163731.15,0.00,0.00,0.00,0.00,0.00),('5','104','895','201572',3922623,'2670','394',967654.37,969633.41,1979.04,326541.60,0.00,0.00,0.00,0.00,0.00),('5','104','896','201572',3922624,'2671','394',1618542.28,1621543.09,3000.81,495133.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','201572',3922625,'2672','394',913468.74,913468.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','201572',3922626,'2673','395',1322560.77,1323882.02,1321.25,356737.50,0.00,0.00,0.00,0.00,0.00),('5','104','898','201572',3922627,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','201572',3922628,'2675','394',1998184.74,2001134.25,2949.51,486669.15,0.00,0.00,0.00,0.00,0.00),('5','104','896','201572',3922629,'2676','394',1332871.99,1334375.10,1503.11,248013.15,0.00,0.00,0.00,0.00,0.00),('5','104','895','201784',3926861,'2669','394',1860299.40,1862495.30,2195.90,362323.50,0.00,0.00,0.00,0.00,0.00),('5','104','895','201784',3926862,'2670','394',969633.41,970450.70,817.29,134852.85,0.00,0.00,0.00,0.00,0.00),('5','104','896','201784',3926863,'2671','394',1621543.09,1623786.90,2243.81,370228.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','201784',3926864,'2672','394',913468.74,914191.90,723.16,119321.40,0.00,0.00,0.00,0.00,0.00),('5','104','897','201784',3926865,'2673','395',1323882.02,1324584.90,702.88,193292.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','201784',3926866,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','201784',3926867,'2675','394',2001134.25,2003202.50,2068.25,341261.25,0.00,0.00,0.00,0.00,0.00),('5','104','896','201784',3926868,'2676','394',1334375.10,1334809.00,433.90,71593.50,0.00,0.00,0.00,0.00,0.00),('5','104','895','202061',3932004,'2669','394',1862495.30,1864643.00,2147.70,354370.50,0.00,0.00,0.00,0.00,0.00),('5','104','895','202061',3932005,'2670','394',970450.70,970450.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','202061',3932006,'2671','394',1623786.90,1625916.30,2129.40,351351.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','202061',3932007,'2672','394',914191.90,914425.79,233.89,38591.85,0.00,0.00,0.00,0.00,0.00),('5','104','897','202061',3932008,'2673','395',1324584.90,1325196.60,611.70,168217.50,0.00,0.00,0.00,0.00,0.00),('5','104','898','202061',3932009,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','202061',3932010,'2675','394',2003202.50,2005663.90,2461.40,406131.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','202061',3932011,'2676','394',1334809.00,1336549.04,1740.04,287106.60,0.00,0.00,0.00,0.00,0.00),('5','104','895','202196',3934483,'2669','394',1864643.00,1866549.30,1906.30,314539.50,0.00,0.00,0.00,0.00,0.00),('5','104','895','202196',3934484,'2670','394',970450.70,972546.08,2095.38,345737.70,0.00,0.00,0.00,0.00,0.00),('5','104','896','202196',3934485,'2671','394',1625916.30,1628240.70,2324.40,383526.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','202196',3934486,'2672','394',914425.79,914435.79,10.00,1650.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','202196',3934487,'2673','395',1325196.60,1326106.60,910.00,250250.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','202196',3934488,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','202196',3934489,'2675','394',2005663.90,2008055.10,2391.20,394548.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','202196',3934490,'2676','394',1336549.04,1336549.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','202422',3938363,'2669','394',1866549.30,1868132.50,1583.20,261228.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','202422',3938364,'2670','394',972546.08,973939.14,1393.06,229854.90,0.00,0.00,0.00,0.00,0.00),('5','104','896','202422',3938365,'2671','394',1628240.70,1630999.80,2759.10,455251.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','202422',3938366,'2672','394',914435.79,914587.17,151.38,24977.70,0.00,0.00,0.00,0.00,0.00),('5','104','897','202422',3938367,'2673','395',1326106.60,1326677.30,570.70,156942.50,0.00,0.00,0.00,0.00,0.00),('5','104','898','202422',3938368,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','202422',3938369,'2675','394',2008055.10,2009957.96,1902.86,313971.90,0.00,0.00,0.00,0.00,0.00),('5','104','896','202422',3938370,'2676','394',1336549.04,1337026.90,477.86,78846.90,0.00,0.00,0.00,0.00,0.00),('5','104','895','202746',3943876,'2669','394',1868132.50,1870045.30,1912.80,315612.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','202746',3943877,'2670','394',973939.14,975745.11,1805.97,297985.05,0.00,0.00,0.00,0.00,0.00),('5','104','896','202746',3943878,'2671','394',1630999.80,1633417.70,2417.90,398953.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','202746',3943879,'2672','394',914587.17,914587.72,0.55,90.75,0.00,0.00,0.00,0.00,0.00),('5','104','897','202746',3943880,'2673','395',1326677.30,1327541.90,864.60,237765.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','202746',3943881,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','202746',3943882,'2675','394',2009957.96,2012482.30,2524.34,416516.10,0.00,0.00,0.00,0.00,0.00),('5','104','896','202746',3943883,'2676','394',1337026.90,1337026.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','202906',3946736,'2669','394',1870045.30,1872291.30,2246.00,370590.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','202906',3946737,'2670','394',975745.11,977307.92,1562.81,257863.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','202906',3946738,'2671','394',1633417.70,1636166.50,2748.80,453552.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','202906',3946739,'2672','394',914587.72,914587.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','202906',3946740,'2673','395',1327541.90,1328188.70,646.80,177870.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','202906',3946741,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','202906',3946742,'2675','394',2012482.30,2015059.10,2576.80,425172.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','202906',3946743,'2676','394',1337026.90,1337026.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','203095',3950726,'2669','394',1872291.30,1874741.50,2450.20,404283.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','203095',3950727,'2670','394',977307.92,978993.37,1685.45,278099.25,0.00,0.00,0.00,0.00,0.00),('5','104','896','203095',3950728,'2671','394',1636166.50,1638544.20,2377.70,392320.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','203095',3950729,'2672','394',914587.72,914587.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','203095',3950730,'2673','395',1328188.70,1329112.40,923.70,254017.50,0.00,0.00,0.00,0.00,0.00),('5','104','898','203095',3950731,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','203095',3950732,'2675','394',2015059.10,2017756.40,2697.30,445054.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','203095',3950733,'2676','394',1337026.90,1337026.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','203301',3954417,'2669','394',1874741.50,1877128.00,2386.50,393772.50,0.00,0.00,0.00,0.00,0.00),('5','104','895','203301',3954418,'2670','394',978993.37,980763.00,1769.63,291988.95,0.00,0.00,0.00,0.00,0.00),('5','104','896','203301',3954419,'2671','394',1638544.20,1641046.60,2502.40,412896.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','203301',3954420,'2672','394',914587.72,914587.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','203301',3954421,'2673','395',1329112.40,1329731.00,618.60,170115.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','203301',3954422,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','203301',3954423,'2675','394',2017756.40,2020200.70,2444.30,403309.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','203301',3954424,'2676','394',1337026.90,1337026.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','203535',3958436,'2669','394',1877128.00,1878780.10,1652.10,272596.50,0.00,0.00,0.00,0.00,0.00),('5','104','895','203535',3958437,'2670','394',980763.00,982458.37,1695.37,279736.05,0.00,0.00,0.00,0.00,0.00),('5','104','896','203535',3958438,'2671','394',1641046.60,1643260.00,2213.40,365211.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','203535',3958439,'2672','394',914587.72,915523.17,935.45,154349.25,0.00,0.00,0.00,0.00,0.00),('5','104','897','203535',3958440,'2673','395',1329731.00,1330980.20,1249.20,343530.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','203535',3958441,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','203535',3958442,'2675','394',2020200.70,2021595.00,1394.30,230059.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','203535',3958443,'2676','394',1337026.90,1337030.20,3.30,544.50,0.00,0.00,0.00,0.00,0.00),('5','104','895','203893',3965076,'2669','394',1878780.10,1881371.10,2591.00,427515.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','203893',3965077,'2670','394',982458.37,984582.67,2124.30,350509.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','203893',3965078,'2671','394',1643260.00,1645899.00,2639.00,435435.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','203893',3965079,'2672','394',915523.17,915523.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','203893',3965080,'2673','395',1330980.20,1332878.80,1898.60,522115.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','203893',3965081,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','203893',3965082,'2675','394',2021595.00,2024043.40,2448.40,403986.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','203893',3965083,'2676','394',1337030.20,1337030.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','203986',3966307,'2669','394',1881371.10,1883167.70,1796.60,296439.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','203986',3966308,'2670','394',984582.67,986706.32,2123.65,350402.25,0.00,0.00,0.00,0.00,0.00),('5','104','896','203986',3966309,'2671','394',1645899.00,1648445.20,2546.20,420123.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','203986',3966310,'2672','394',915523.17,915523.27,0.10,16.50,0.00,0.00,0.00,0.00,0.00),('5','104','897','203986',3966311,'2673','395',1332878.80,1334493.60,1614.80,444070.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','203986',3966312,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','203986',3966313,'2675','394',2024043.40,2026482.70,2439.30,402484.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','203986',3966314,'2676','394',1337030.20,1337030.50,0.30,49.50,0.00,0.00,0.00,0.00,0.00),('5','104','895','204221',3970653,'2669','394',1883167.70,1885512.50,2344.80,386892.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','204221',3970654,'2670','394',986706.32,988688.16,1981.84,327003.60,0.00,0.00,0.00,0.00,0.00),('5','104','896','204221',3970655,'2671','394',1648445.20,1649564.30,1119.10,184651.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','204221',3970656,'2672','394',915523.27,916679.45,1156.18,190769.70,0.00,0.00,0.00,0.00,0.00),('5','104','897','204221',3970657,'2673','395',1334493.60,1335483.10,989.50,272112.50,0.00,0.00,0.00,0.00,0.00),('5','104','898','204221',3970658,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','204221',3970659,'2675','394',2026482.70,2027724.00,1241.30,204814.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','204221',3970660,'2676','394',1337030.50,1337968.40,937.90,154753.50,0.00,0.00,0.00,0.00,0.00),('5','104','895','204469',3975255,'2669','394',1885512.50,1887813.10,2300.60,379599.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','204469',3975256,'2670','394',988688.16,988688.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','204469',3975257,'2671','394',1649564.30,1651499.96,1935.66,319383.90,0.00,0.00,0.00,0.00,0.00),('5','104','896','204469',3975258,'2672','394',916679.45,917631.34,951.89,157061.85,0.00,0.00,0.00,0.00,0.00),('5','104','897','204469',3975259,'2673','395',1335483.10,1336497.70,1014.60,279015.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','204469',3975260,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','204469',3975261,'2675','394',2027724.00,2030058.20,2334.20,385143.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','204469',3975262,'2676','394',1337968.40,1338993.40,1025.00,169125.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','204662',3978589,'2669','394',1887813.10,1889790.95,1977.85,326345.25,0.00,0.00,0.00,0.00,0.00),('5','104','895','204662',3978590,'2670','394',988688.16,989583.05,894.89,147656.85,0.00,0.00,0.00,0.00,0.00),('5','104','896','204662',3978591,'2671','394',1651499.96,1653984.97,2485.01,410026.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','204662',3978592,'2672','394',917631.34,918183.35,552.01,91081.65,0.00,0.00,0.00,0.00,0.00),('5','104','897','204662',3978593,'2673','395',1336497.70,1337375.82,878.12,241483.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','204662',3978594,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','204662',3978595,'2675','394',2030058.20,2032541.80,2483.60,409794.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','204662',3978596,'2676','394',1338993.40,1340828.30,1834.90,302758.50,0.00,0.00,0.00,0.00,0.00),('5','104','895','204902',3982610,'2669','394',1889790.95,1891778.50,1987.55,327945.75,0.00,0.00,0.00,0.00,0.00),('5','104','895','204902',3982611,'2670','394',989583.05,991278.85,1695.80,279807.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','204902',3982612,'2671','394',1653984.97,1655651.50,1666.53,274977.45,0.00,0.00,0.00,0.00,0.00),('5','104','896','204902',3982613,'2672','394',918183.35,918183.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','204902',3982614,'2673','395',1337375.82,1337375.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','204902',3982615,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','204902',3982616,'2675','394',2032541.80,2034956.52,2414.72,398428.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','204902',3982617,'2676','394',1340828.30,1342142.40,1314.10,216826.50,0.00,0.00,0.00,0.00,0.00),('5','104','895','205122',3986625,'2669','394',1891778.50,1893614.30,1835.80,302907.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','205122',3986626,'2670','394',991278.85,991540.99,262.14,43253.10,0.00,0.00,0.00,0.00,0.00),('5','104','896','205122',3986627,'2671','394',1655651.50,1657417.20,1765.70,291340.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','205122',3986628,'2672','394',918183.35,918183.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','205122',3986629,'2673','395',1337375.82,1337375.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','205122',3986630,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','205122',3986631,'2675','394',2034956.52,2036617.22,1660.70,274015.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','205122',3986632,'2676','394',1342142.40,1343806.97,1664.57,274654.05,0.00,0.00,0.00,0.00,0.00),('5','104','895','205255',3988975,'2669','394',1893614.30,1896282.30,2668.00,440220.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','205255',3988976,'2670','394',991540.99,992279.49,738.50,121852.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','205255',3988977,'2671','394',1657417.20,1659096.18,1678.98,277031.70,0.00,0.00,0.00,0.00,0.00),('5','104','896','205255',3988978,'2672','394',918183.35,918183.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','205255',3988979,'2673','395',1337375.82,1337375.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','205255',3988980,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','205255',3988981,'2675','394',2036617.22,2040099.85,3482.63,574633.95,0.00,0.00,0.00,0.00,0.00),('5','104','896','205255',3988982,'2676','394',1343806.97,1346183.05,2376.08,392053.20,0.00,0.00,0.00,0.00,0.00),('5','104','895','205489',3993246,'2669','394',1896282.30,1898233.59,1951.29,321962.85,0.00,0.00,0.00,0.00,0.00),('5','104','895','205489',3993247,'2670','394',992279.49,992907.82,628.33,103674.45,0.00,0.00,0.00,0.00,0.00),('5','104','896','205489',3993248,'2671','394',1659096.18,1660140.57,1044.39,172324.35,0.00,0.00,0.00,0.00,0.00),('5','104','896','205489',3993249,'2672','394',918183.35,918183.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','205489',3993250,'2673','395',1337375.82,1337375.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','205489',3993251,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','205489',3993252,'2675','394',2040099.85,2042294.01,2194.16,362036.40,0.00,0.00,0.00,0.00,0.00),('5','104','896','205489',3993253,'2676','394',1346183.05,1348169.92,1986.87,327833.55,0.00,0.00,0.00,0.00,0.00),('5','104','895','205752',3998004,'2669','394',1898233.59,1900452.90,2219.31,366186.15,0.00,0.00,0.00,0.00,0.00),('5','104','895','205752',3998005,'2670','394',992907.82,994229.56,1321.74,218087.10,0.00,0.00,0.00,0.00,0.00),('5','104','896','205752',3998006,'2671','394',1660140.57,1661080.00,939.43,155005.95,0.00,0.00,0.00,0.00,0.00),('5','104','896','205752',3998007,'2672','394',918183.35,918183.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','205752',3998008,'2673','395',1337375.82,1337375.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','205752',3998009,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','205752',3998010,'2675','394',2042294.01,2044221.97,1927.96,318113.40,0.00,0.00,0.00,0.00,0.00),('5','104','896','205752',3998011,'2676','394',1348169.92,1349903.35,1733.43,286015.95,0.00,0.00,0.00,0.00,0.00),('5','104','895','205959',4001732,'2669','394',1900452.90,1900452.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','205959',4001733,'2670','394',994229.56,994229.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','205959',4001734,'2671','394',1661080.00,1664628.07,3548.07,585431.55,0.00,0.00,0.00,0.00,0.00),('5','104','896','205959',4001735,'2672','394',918183.35,918183.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','205959',4001736,'2673','395',1337375.82,1337375.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','205959',4001737,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','205959',4001738,'2675','394',2044221.97,2044221.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','205959',4001739,'2676','394',1349903.35,1353491.61,3588.26,592062.90,0.00,0.00,0.00,0.00,0.00),('5','104','895','206234',4006713,'2669','394',1900452.90,1900452.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','206234',4006714,'2670','394',994229.56,994229.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','206234',4006715,'2671','394',1664628.07,1666534.21,1906.14,314513.10,0.00,0.00,0.00,0.00,0.00),('5','104','896','206234',4006716,'2672','394',918183.35,918183.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','206234',4006717,'2673','395',1337375.82,1337375.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','206234',4006718,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','206234',4006719,'2675','394',2044221.97,2044221.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','206234',4006720,'2676','394',1353491.61,1353989.92,498.31,82221.15,0.00,0.00,0.00,0.00,0.00),('5','104','895','206351',4008776,'2669','394',1900452.90,1901267.55,814.65,134417.25,0.00,0.00,0.00,0.00,0.00),('5','104','895','206351',4008777,'2670','394',994229.56,994233.19,3.63,598.95,0.00,0.00,0.00,0.00,0.00),('5','104','896','206351',4008778,'2671','394',1666534.21,1666926.69,392.48,64759.20,0.00,0.00,0.00,0.00,0.00),('5','104','896','206351',4008779,'2672','394',918183.35,918183.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','206351',4008780,'2673','395',1337375.82,1337375.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','206351',4008781,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','206351',4008782,'2675','394',2044221.97,2044882.34,660.37,108961.05,0.00,0.00,0.00,0.00,0.00),('5','104','896','206351',4008783,'2676','394',1353989.92,1353989.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','206682',4014588,'2669','394',1901267.55,1902746.71,1479.16,244061.40,0.00,0.00,0.00,0.00,0.00),('5','104','895','206682',4014589,'2670','394',994233.19,995644.40,1411.21,232849.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','206682',4014590,'2671','394',1666926.69,1668673.17,1746.48,288169.20,0.00,0.00,0.00,0.00,0.00),('5','104','896','206682',4014591,'2672','394',918183.35,918183.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','206682',4014592,'2673','395',1337375.82,1337375.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','206682',4014593,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','206682',4014594,'2675','394',2044882.34,2047069.48,2187.14,360878.10,0.00,0.00,0.00,0.00,0.00),('5','104','896','206682',4014595,'2676','394',1353989.92,1354769.24,779.32,128587.80,0.00,0.00,0.00,0.00,0.00),('5','104','895','206837',4017094,'2669','394',1902746.71,1905246.30,2499.59,412432.35,0.00,0.00,0.00,0.00,0.00),('5','104','895','206837',4017095,'2670','394',995644.40,997469.92,1825.52,301210.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','206837',4017096,'2671','394',1668673.17,1671334.66,2661.49,439145.85,0.00,0.00,0.00,0.00,0.00),('5','104','896','206837',4017097,'2672','394',918183.35,918198.30,14.95,2466.75,0.00,0.00,0.00,0.00,0.00),('5','104','897','206837',4017098,'2673','395',1337375.82,1337375.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','206837',4017099,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','206837',4017100,'2675','394',2047069.48,2050059.80,2990.32,493402.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','206837',4017101,'2676','394',1354769.24,1355030.78,261.54,43154.10,0.00,0.00,0.00,0.00,0.00),('5','104','895','207058',4021092,'2669','394',1905246.30,1907894.43,2648.13,436941.45,0.00,0.00,0.00,0.00,0.00),('5','104','895','207058',4021093,'2670','394',997469.92,998919.50,1449.58,239180.70,0.00,0.00,0.00,0.00,0.00),('5','104','896','207058',4021094,'2671','394',1671334.66,1673454.79,2120.13,349821.45,0.00,0.00,0.00,0.00,0.00),('5','104','896','207058',4021095,'2672','394',918198.30,919160.65,962.35,158787.75,0.00,0.00,0.00,0.00,0.00),('5','104','897','207058',4021096,'2673','395',1337375.82,1337375.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','207058',4021097,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','207058',4021098,'2675','394',2050059.80,2051872.87,1813.07,299156.55,0.00,0.00,0.00,0.00,0.00),('5','104','896','207058',4021099,'2676','394',1355030.78,1355038.52,7.74,1277.10,0.00,0.00,0.00,0.00,0.00),('5','104','895','207250',4024698,'2669','394',1907894.43,1909876.47,1982.04,327036.60,0.00,0.00,0.00,0.00,0.00),('5','104','895','207250',4024699,'2670','394',998919.50,999468.29,548.79,90550.35,0.00,0.00,0.00,0.00,0.00),('5','104','896','207250',4024700,'2671','394',1673454.79,1675404.04,1949.25,321626.25,0.00,0.00,0.00,0.00,0.00),('5','104','896','207250',4024701,'2672','394',919160.65,920432.56,1271.91,209865.15,0.00,0.00,0.00,0.00,0.00),('5','104','897','207250',4024702,'2673','395',1337375.82,1337375.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','207250',4024703,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','207250',4024704,'2675','394',2051872.87,2053891.28,2018.41,333037.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','207250',4024705,'2676','394',1355038.52,1355038.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','207494',4028951,'2669','394',1909876.47,1912496.74,2620.27,432344.55,0.00,0.00,0.00,0.00,0.00),('5','104','895','207494',4028952,'2670','394',999468.29,1000111.73,643.44,106167.60,0.00,0.00,0.00,0.00,0.00),('5','104','896','207494',4028953,'2671','394',1675404.04,1677777.42,2373.38,391607.70,0.00,0.00,0.00,0.00,0.00),('5','104','896','207494',4028954,'2672','394',920432.56,921773.79,1341.23,221302.95,0.00,0.00,0.00,0.00,0.00),('5','104','897','207494',4028955,'2673','395',1337375.82,1337375.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','207494',4028956,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','207494',4028957,'2675','394',2053891.28,2056174.45,2283.17,376723.05,0.00,0.00,0.00,0.00,0.00),('5','104','896','207494',4028958,'2676','394',1355038.52,1355038.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','207732',4032930,'2669','394',1912496.74,1914714.41,2217.67,365915.55,0.00,0.00,0.00,0.00,0.00),('5','104','895','207732',4032931,'2670','394',1000111.73,1000684.80,573.07,94556.55,0.00,0.00,0.00,0.00,0.00),('5','104','896','207732',4032932,'2671','394',1677777.42,1680202.30,2424.88,400105.20,0.00,0.00,0.00,0.00,0.00),('5','104','896','207732',4032933,'2672','394',921773.79,923661.55,1887.76,311480.40,0.00,0.00,0.00,0.00,0.00),('5','104','897','207732',4032934,'2673','395',1337375.82,1337375.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','207732',4032935,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','207732',4032936,'2675','394',2056174.45,2058666.70,2492.25,411221.25,0.00,0.00,0.00,0.00,0.00),('5','104','896','207732',4032937,'2676','394',1355038.52,1355038.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','207916',4036130,'2669','394',1914714.41,1916540.78,1826.37,301351.05,0.00,0.00,0.00,0.00,0.00),('5','104','895','207916',4036131,'2670','394',1000684.80,1002163.49,1478.69,243983.85,0.00,0.00,0.00,0.00,0.00),('5','104','896','207916',4036132,'2671','394',1680202.30,1681351.88,1149.58,189680.70,0.00,0.00,0.00,0.00,0.00),('5','104','896','207916',4036133,'2672','394',923661.55,925351.36,1689.81,278818.65,0.00,0.00,0.00,0.00,0.00),('5','104','897','207916',4036134,'2673','395',1337375.82,1337375.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','207916',4036135,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','207916',4036136,'2675','394',2058666.70,2060919.84,2253.14,371768.10,0.00,0.00,0.00,0.00,0.00),('5','104','896','207916',4036137,'2676','394',1355038.52,1355038.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','208138',4040002,'2669','394',1916540.78,1918390.20,1849.42,305154.30,0.00,0.00,0.00,0.00,0.00),('5','104','895','208138',4040003,'2670','394',1002163.49,1003951.91,1788.42,295089.30,0.00,0.00,0.00,0.00,0.00),('5','104','896','208138',4040004,'2671','394',1681351.88,1682887.57,1535.69,253388.85,0.00,0.00,0.00,0.00,0.00),('5','104','896','208138',4040005,'2672','394',925351.36,926719.08,1367.72,225673.80,0.00,0.00,0.00,0.00,0.00),('5','104','897','208138',4040006,'2673','395',1337375.82,1337375.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','208138',4040007,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','208138',4040008,'2675','394',2060919.84,2061954.66,1034.82,170745.30,0.00,0.00,0.00,0.00,0.00),('5','104','896','208138',4040009,'2676','394',1355038.52,1355038.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','208314',4043377,'2669','394',1918390.20,1920930.62,2540.42,419169.30,0.00,0.00,0.00,0.00,0.00),('5','104','895','208314',4043378,'2670','394',1003951.91,1006236.89,2284.98,377021.70,0.00,0.00,0.00,0.00,0.00),('5','104','896','208314',4043379,'2671','394',1682887.57,1685305.70,2418.13,398991.45,0.00,0.00,0.00,0.00,0.00),('5','104','896','208314',4043380,'2672','394',926719.08,928830.02,2110.94,348305.10,0.00,0.00,0.00,0.00,0.00),('5','104','897','208314',4043381,'2673','395',1337375.82,1337375.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','208314',4043382,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','208314',4043383,'2675','394',2061954.66,2061954.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','208314',4043384,'2676','394',1355038.52,1355038.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','208606',4048180,'2669','394',1920930.62,1923235.48,2304.86,380301.90,0.00,0.00,0.00,0.00,0.00),('5','104','895','208606',4048181,'2670','394',1006236.89,1008142.19,1905.30,314374.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','208606',4048182,'2671','394',1685305.70,1687413.80,2108.10,347836.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','208606',4048183,'2672','394',928830.02,930659.86,1829.84,301923.60,0.00,0.00,0.00,0.00,0.00),('5','104','897','208606',4048184,'2673','395',1337375.82,1337375.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','208606',4048185,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','208606',4048186,'2675','394',2061954.66,2061954.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','208606',4048187,'2676','394',1355038.52,1355038.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','208792',4051412,'2669','394',1923235.48,1925874.90,2639.42,435504.30,0.00,0.00,0.00,0.00,0.00),('5','104','895','208792',4051413,'2670','394',1008142.19,1010594.52,2452.33,404634.45,0.00,0.00,0.00,0.00,0.00),('5','104','896','208792',4051414,'2671','394',1687413.80,1688971.66,1557.86,257046.90,0.00,0.00,0.00,0.00,0.00),('5','104','896','208792',4051415,'2672','394',930659.86,931702.36,1042.50,172012.50,0.00,0.00,0.00,0.00,0.00),('5','104','897','208792',4051416,'2673','395',1337375.82,1337375.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','208792',4051417,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','208792',4051418,'2675','394',2061954.66,2061954.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','208792',4051419,'2676','394',1355038.52,1355038.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','209020',4055345,'2669','394',1925874.90,1928669.87,2794.97,461170.05,0.00,0.00,0.00,0.00,0.00),('5','104','895','209020',4055346,'2670','394',1010594.52,1013003.21,2408.69,397433.85,0.00,0.00,0.00,0.00,0.00),('5','104','896','209020',4055347,'2671','394',1688971.66,1691538.57,2566.91,423540.15,0.00,0.00,0.00,0.00,0.00),('5','104','896','209020',4055348,'2672','394',931702.36,932315.84,613.48,101224.20,0.00,0.00,0.00,0.00,0.00),('5','104','897','209020',4055349,'2673','395',1337375.82,1337375.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','209020',4055350,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','209020',4055351,'2675','394',2061954.66,2061954.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','209020',4055352,'2676','394',1355038.52,1355038.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','209226',4059080,'2669','394',1928669.87,1931454.89,2785.02,459528.30,0.00,0.00,0.00,0.00,0.00),('5','104','895','209226',4059081,'2670','394',1013003.21,1015872.30,2869.09,473399.85,0.00,0.00,0.00,0.00,0.00),('5','104','896','209226',4059082,'2671','394',1691538.57,1694309.58,2771.01,457216.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','209226',4059083,'2672','394',932315.84,932820.47,504.63,83263.95,0.00,0.00,0.00,0.00,0.00),('5','104','897','209226',4059084,'2673','395',1337375.82,1337375.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','209226',4059085,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','209226',4059086,'2675','394',2061954.66,2061954.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','209226',4059087,'2676','394',1355038.52,1355038.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','209502',4063998,'2669','394',1931454.89,1932083.12,628.23,103657.95,0.00,0.00,0.00,0.00,0.00),('5','104','895','209502',4063999,'2670','394',1015872.30,1016965.99,1093.69,180458.85,0.00,0.00,0.00,0.00,0.00),('5','104','896','209502',4064000,'2671','394',1694309.58,1696128.45,1818.87,300113.55,0.00,0.00,0.00,0.00,0.00),('5','104','896','209502',4064001,'2672','394',932820.47,934181.30,1360.83,224536.95,0.00,0.00,0.00,0.00,0.00),('5','104','897','209502',4064002,'2673','395',1337375.82,1337375.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','209502',4064003,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','209502',4064004,'2675','394',2061954.66,2061954.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','209502',4064005,'2676','394',1355038.52,1355038.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','209638',4066542,'2669','394',1932083.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','209638',4066543,'2670','394',1016965.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','209638',4066544,'2671','394',1696128.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','209638',4066545,'2672','394',934181.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','209638',4066546,'2673','395',1337375.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','209638',4066547,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','209638',4066548,'2675','394',2061954.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','209638',4066549,'2676','394',1355038.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','210416',4080242,'2669','394',1932083.12,1934085.42,2002.30,330379.50,0.00,0.00,0.00,0.00,0.00),('5','104','895','210416',4080243,'2670','394',1016965.99,1018230.55,1264.56,208652.40,0.00,0.00,0.00,0.00,0.00),('5','104','896','210416',4080244,'2671','394',1696128.45,1698319.00,2190.55,361440.75,0.00,0.00,0.00,0.00,0.00),('5','104','896','210416',4080245,'2672','394',934181.30,935558.82,1377.52,227290.80,0.00,0.00,0.00,0.00,0.00),('5','104','897','210416',4080246,'2673','395',1337375.82,1337375.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','210416',4080247,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','210416',4080248,'2675','394',2061954.66,2061961.00,6.34,1046.10,0.00,0.00,0.00,0.00,0.00),('5','104','896','210416',4080249,'2676','394',1355038.52,1355038.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','210450',4080915,'2669','394',1934085.42,1937388.96,3303.54,545084.10,0.00,0.00,0.00,0.00,0.00),('5','104','895','210450',4080916,'2670','394',1018230.55,1019744.48,1513.93,249798.45,0.00,0.00,0.00,0.00,0.00),('5','104','896','210450',4080917,'2671','394',1698319.00,1700527.37,2208.37,364381.05,0.00,0.00,0.00,0.00,0.00),('5','104','896','210450',4080918,'2672','394',935558.82,936680.09,1121.27,185009.55,0.00,0.00,0.00,0.00,0.00),('5','104','897','210450',4080919,'2673','395',1337375.82,1337375.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','210450',4080920,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','210450',4080921,'2675','394',2061961.00,2061961.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','210450',4080922,'2676','394',1355038.52,1355038.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','210598',4083549,'2669','394',1937388.96,1940414.62,3025.66,499233.90,0.00,0.00,0.00,0.00,0.00),('5','104','895','210598',4083550,'2670','394',1019744.48,1021409.52,1665.04,274731.60,0.00,0.00,0.00,0.00,0.00),('5','104','896','210598',4083551,'2671','394',1700527.37,1703242.21,2714.84,447948.60,0.00,0.00,0.00,0.00,0.00),('5','104','896','210598',4083552,'2672','394',936680.09,936680.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','210598',4083553,'2673','395',1337375.82,1337375.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','210598',4083554,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','210598',4083555,'2675','394',2061961.00,2063496.71,1535.71,253392.15,0.00,0.00,0.00,0.00,0.00),('5','104','896','210598',4083556,'2676','394',1355038.52,1355038.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','210760',4086348,'2669','394',1940414.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','210760',4086349,'2670','394',1021409.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','210760',4086350,'2671','394',1703242.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','210760',4086351,'2672','394',936680.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','210760',4086352,'2673','395',1337375.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','210760',4086353,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','210760',4086354,'2675','394',2063496.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','210760',4086355,'2676','394',1355038.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','211437',4098260,'2669','394',1940414.62,1944114.55,3699.93,610488.45,0.00,0.00,0.00,0.00,0.00),('5','104','895','211437',4098261,'2670','394',1021409.52,1022876.78,1467.26,242097.90,0.00,0.00,0.00,0.00,0.00),('5','104','896','211437',4098262,'2671','394',1703242.21,1705058.82,1816.61,299740.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','211437',4098263,'2672','394',936680.09,938590.54,1910.45,315224.25,0.00,0.00,0.00,0.00,0.00),('5','104','897','211437',4098264,'2673','395',1337375.82,1337375.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','211437',4098265,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','211437',4098266,'2675','394',2063496.71,2064628.41,1131.70,186730.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','211437',4098267,'2676','394',1355038.52,1355038.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','211450',4098525,'2669','394',1944114.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','211450',4098526,'2670','394',1022876.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','211450',4098527,'2671','394',1705058.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','211450',4098528,'2672','394',938590.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','211450',4098529,'2673','395',1337375.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','211450',4098530,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','211450',4098531,'2675','394',2064628.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','211450',4098532,'2676','394',1355038.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','211469',4098893,'2669','394',1944114.55,1945912.56,1798.01,296671.65,0.00,0.00,0.00,0.00,0.00),('5','104','895','211469',4098894,'2670','394',1022876.78,1024701.59,1824.81,301093.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','211469',4098895,'2671','394',1705058.82,1705058.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','211469',4098896,'2672','394',938590.54,938590.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','211469',4098897,'2673','395',1337375.82,1337375.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','211469',4098898,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','211469',4098899,'2675','394',2064628.41,2066601.43,1973.02,325548.30,0.00,0.00,0.00,0.00,0.00),('5','104','896','211469',4098900,'2676','394',1355038.52,1355038.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','211473',4098933,'2669','394',1945912.56,1947446.35,1533.79,253075.35,0.00,0.00,0.00,0.00,0.00),('5','104','895','211473',4098934,'2670','394',1024701.59,1024701.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','211473',4098935,'2671','394',1705058.82,1706196.38,1137.56,187697.40,0.00,0.00,0.00,0.00,0.00),('5','104','896','211473',4098936,'2672','394',938590.54,938590.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','211473',4098937,'2673','395',1337375.82,1337375.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','211473',4098938,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','211473',4098939,'2675','394',2066601.43,2066601.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','211473',4098940,'2676','394',1355038.52,1355038.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','211502',4099400,'2669','394',1947446.35,1952316.96,4870.61,803650.65,0.00,0.00,0.00,0.00,0.00),('5','104','895','211502',4099401,'2670','394',1024701.59,1028424.03,3722.44,614202.60,0.00,0.00,0.00,0.00,0.00),('5','104','896','211502',4099402,'2671','394',1706196.38,1710440.54,4244.16,700286.40,0.00,0.00,0.00,0.00,0.00),('5','104','896','211502',4099403,'2672','394',938590.54,938590.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','211502',4099404,'2673','395',1337375.82,1337375.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','211502',4099405,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','211502',4099406,'2675','394',2066601.43,2066601.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','211502',4099407,'2676','394',1355038.52,1355038.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','211612',4101375,'2669','394',1952316.96,1953787.89,1470.93,242703.45,0.00,0.00,0.00,0.00,0.00),('5','104','895','211612',4101376,'2670','394',1028424.03,1031735.30,3311.27,546359.55,0.00,0.00,0.00,0.00,0.00),('5','104','896','211612',4101377,'2671','394',1710440.54,1714485.01,4044.47,667337.55,0.00,0.00,0.00,0.00,0.00),('5','104','896','211612',4101378,'2672','394',938590.54,938590.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','211612',4101379,'2673','395',1337375.82,1337375.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','211612',4101380,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','211612',4101381,'2675','394',2066601.43,2066601.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','211612',4101382,'2676','394',1355038.52,1355038.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','211812',4104585,'2669','394',1953787.89,1958459.20,4671.31,770766.15,0.00,0.00,0.00,0.00,0.00),('5','104','895','211812',4104586,'2670','394',1031735.30,1031735.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','211812',4104587,'2671','394',1714485.01,1714502.00,16.99,2803.35,0.00,0.00,0.00,0.00,0.00),('5','104','896','211812',4104588,'2672','394',938590.54,942242.50,3651.96,602573.40,0.00,0.00,0.00,0.00,0.00),('5','104','897','211812',4104589,'2673','395',1337375.82,1337375.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','211812',4104590,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','211812',4104591,'2675','394',2066601.43,2066601.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','211812',4104592,'2676','394',1355038.52,1355038.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','212045',4108743,'2669','394',1958459.20,1960729.49,2270.29,374597.85,0.00,0.00,0.00,0.00,0.00),('5','104','895','212045',4108744,'2670','394',1031735.30,1033721.05,1985.75,327648.75,0.00,0.00,0.00,0.00,0.00),('5','104','896','212045',4108745,'2671','394',1714502.00,1714889.09,387.09,63869.85,0.00,0.00,0.00,0.00,0.00),('5','104','896','212045',4108746,'2672','394',942242.50,942271.84,29.34,4841.10,0.00,0.00,0.00,0.00,0.00),('5','104','897','212045',4108747,'2673','395',1337375.82,1337375.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','212045',4108748,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','212045',4108749,'2675','394',2066601.43,2068868.73,2267.30,374104.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','212045',4108750,'2676','394',1355038.52,1355038.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','212255',4112471,'2669','394',1960729.49,1961932.30,1202.81,198463.65,0.00,0.00,0.00,0.00,0.00),('5','104','895','212255',4112472,'2670','394',1033721.05,1034603.40,882.35,145587.75,0.00,0.00,0.00,0.00,0.00),('5','104','896','212255',4112473,'2671','394',1714889.09,1717488.28,2599.19,428866.35,0.00,0.00,0.00,0.00,0.00),('5','104','896','212255',4112474,'2672','394',942271.84,946082.12,3810.28,628696.20,0.00,0.00,0.00,0.00,0.00),('5','104','897','212255',4112475,'2673','395',1337375.82,1337375.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','212255',4112476,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','212255',4112477,'2675','394',2068868.73,2068868.78,0.05,8.25,0.00,0.00,0.00,0.00,0.00),('5','104','896','212255',4112478,'2676','394',1355038.52,1355038.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','212494',4116859,'2669','394',1961932.30,1963485.33,1553.03,256249.95,0.00,0.00,0.00,0.00,0.00),('5','104','895','212494',4116860,'2670','394',1034603.40,1037360.02,2756.62,454842.30,0.00,0.00,0.00,0.00,0.00),('5','104','896','212494',4116861,'2671','394',1717488.28,1718948.44,1460.16,240926.40,0.00,0.00,0.00,0.00,0.00),('5','104','896','212494',4116862,'2672','394',946082.12,946976.22,894.10,147526.50,0.00,0.00,0.00,0.00,0.00),('5','104','897','212494',4116863,'2673','395',1337375.82,1337375.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','212494',4116864,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','212494',4116865,'2675','394',2068868.78,2069845.83,977.05,161213.25,0.00,0.00,0.00,0.00,0.00),('5','104','896','212494',4116866,'2676','394',1355038.52,1355038.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','212697',4120519,'2669','394',1963485.33,1966477.55,2992.22,493716.30,0.00,0.00,0.00,0.00,0.00),('5','104','895','212697',4120520,'2670','394',1037360.02,1037360.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','212697',4120521,'2671','394',1718948.44,1718948.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','212697',4120522,'2672','394',946976.22,950038.25,3062.03,505234.95,0.00,0.00,0.00,0.00,0.00),('5','104','897','212697',4120523,'2673','395',1337375.82,1337375.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','212697',4120524,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','212697',4120525,'2675','394',2069845.83,2072714.87,2869.04,473391.60,0.00,0.00,0.00,0.00,0.00),('5','104','896','212697',4120526,'2676','394',1355038.52,1355038.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','212865',4123597,'2669','394',1966477.55,1968920.14,2442.59,403027.35,0.00,0.00,0.00,0.00,0.00),('5','104','895','212865',4123598,'2670','394',1037360.02,1037648.35,288.33,47574.45,0.00,0.00,0.00,0.00,0.00),('5','104','896','212865',4123599,'2671','394',1718948.44,1718948.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','212865',4123600,'2672','394',950038.25,953089.87,3051.62,503517.30,0.00,0.00,0.00,0.00,0.00),('5','104','897','212865',4123601,'2673','395',1337375.82,1337375.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','212865',4123602,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','212865',4123603,'2675','394',2072714.87,2074932.97,2218.10,365986.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','212865',4123604,'2676','394',1355038.52,1355038.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','213257',4130138,'2669','394',1968920.14,1971580.71,2660.57,438994.05,0.00,0.00,0.00,0.00,0.00),('5','104','895','213257',4130139,'2670','394',1037648.35,1037693.14,44.79,7390.35,0.00,0.00,0.00,0.00,0.00),('5','104','896','213257',4130140,'2671','394',1718948.44,1718948.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','213257',4130141,'2672','394',953089.87,956125.15,3035.28,500821.20,0.00,0.00,0.00,0.00,0.00),('5','104','897','213257',4130142,'2673','395',1337375.82,1337375.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','213257',4130143,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','213257',4130144,'2675','394',2074932.97,2077751.60,2818.63,465073.95,0.00,0.00,0.00,0.00,0.00),('5','104','896','213257',4130145,'2676','394',1355038.52,1355038.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','213582',4135575,'2669','394',1971580.71,1973758.74,2178.03,359374.95,0.00,0.00,0.00,0.00,0.00),('5','104','895','213582',4135576,'2670','394',1037693.14,1037693.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','213582',4135577,'2671','394',1718948.44,1718948.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','213582',4135578,'2672','394',956125.15,959798.41,3673.26,606087.90,0.00,0.00,0.00,0.00,0.00),('5','104','897','213582',4135579,'2673','395',1337375.82,1337375.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','213582',4135580,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','213582',4135581,'2675','394',2077751.60,2080598.67,2847.07,469766.55,0.00,0.00,0.00,0.00,0.00),('5','104','896','213582',4135582,'2676','394',1355038.52,1355038.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','213676',4137097,'2669','394',1973758.74,1976724.33,2965.59,489322.35,0.00,0.00,0.00,0.00,0.00),('5','104','895','213676',4137098,'2670','394',1037693.14,1039188.32,1495.18,246704.70,0.00,0.00,0.00,0.00,0.00),('5','104','896','213676',4137099,'2671','394',1718948.44,1718948.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','213676',4137100,'2672','394',959798.41,961179.12,1380.71,227817.15,0.00,0.00,0.00,0.00,0.00),('5','104','897','213676',4137101,'2673','395',1337375.82,1337375.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','213676',4137102,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','213676',4137103,'2675','394',2080598.67,2081869.12,1270.45,209624.25,0.00,0.00,0.00,0.00,0.00),('5','104','896','213676',4137104,'2676','394',1355038.52,1355038.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','213910',4140868,'2669','394',1976724.33,1978229.50,1505.17,248353.05,0.00,0.00,0.00,0.00,0.00),('5','104','895','213910',4140869,'2670','394',1039188.32,1039188.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','213910',4140870,'2671','394',1718948.44,1720534.59,1586.15,261714.75,0.00,0.00,0.00,0.00,0.00),('5','104','896','213910',4140871,'2672','394',961179.12,963545.96,2366.84,390528.60,0.00,0.00,0.00,0.00,0.00),('5','104','897','213910',4140872,'2673','395',1337375.82,1338025.11,649.29,191540.55,0.00,0.00,0.00,0.00,0.00),('5','104','898','213910',4140873,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','213910',4140874,'2675','394',2081869.12,2083815.07,1945.95,321081.75,0.00,0.00,0.00,0.00,0.00),('5','104','896','213910',4140875,'2676','394',1355038.52,1355038.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','214129',4144598,'2669','394',1978229.50,1979790.72,1561.22,257601.30,0.00,0.00,0.00,0.00,0.00),('5','104','895','214129',4144599,'2670','394',1039188.32,1041305.62,2117.30,349354.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','214129',4144600,'2671','394',1720534.59,1722584.59,2050.00,338250.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','214129',4144601,'2672','394',963545.96,965670.89,2124.93,350613.45,0.00,0.00,0.00,0.00,0.00),('5','104','897','214129',4144602,'2673','395',1338025.11,1339548.88,1523.77,449512.15,0.00,0.00,0.00,0.00,0.00),('5','104','898','214129',4144603,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','214129',4144604,'2675','394',2083815.07,2083887.38,72.31,11931.15,0.00,0.00,0.00,0.00,0.00),('5','104','896','214129',4144605,'2676','394',1355038.52,1355038.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','214436',4149910,'2669','394',1979790.72,1981618.48,1827.76,301580.40,0.00,0.00,0.00,0.00,0.00),('5','104','895','214436',4149911,'2670','394',1041305.62,1041305.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','214436',4149912,'2671','394',1722584.59,1723000.06,415.47,68552.55,0.00,0.00,0.00,0.00,0.00),('5','104','896','214436',4149913,'2672','394',965670.89,967421.39,1750.50,288832.50,0.00,0.00,0.00,0.00,0.00),('5','104','897','214436',4149914,'2673','395',1339548.88,1340183.86,634.98,187319.10,0.00,0.00,0.00,0.00,0.00),('5','104','898','214436',4149915,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','214436',4149916,'2675','394',2083887.38,2086145.68,2258.30,372619.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','214436',4149917,'2676','394',1355038.52,1355038.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','214646',4153502,'2669','394',1981618.48,1981618.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','214646',4153503,'2670','394',1041305.62,1043699.49,2393.87,394988.55,0.00,0.00,0.00,0.00,0.00),('5','104','896','214646',4153504,'2671','394',1723000.06,1723255.76,255.70,42190.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','214646',4153505,'2672','394',967421.39,969936.50,2515.11,414993.15,0.00,0.00,0.00,0.00,0.00),('5','104','897','214646',4153506,'2673','395',1340183.86,1340925.10,741.24,218665.80,0.00,0.00,0.00,0.00,0.00),('5','104','898','214646',4153507,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','214646',4153508,'2675','394',2086145.68,2088646.91,2501.23,412702.95,0.00,0.00,0.00,0.00,0.00),('5','104','896','214646',4153509,'2676','394',1355038.52,1355038.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','214777',4155871,'2669','394',1981618.48,1983478.76,1860.28,306946.20,0.00,0.00,0.00,0.00,0.00),('5','104','895','214777',4155872,'2670','394',1043699.49,1046206.04,2506.55,413580.75,0.00,0.00,0.00,0.00,0.00),('5','104','896','214777',4155873,'2671','394',1723255.76,1723285.76,30.00,4950.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','214777',4155874,'2672','394',969936.50,970002.07,65.57,10819.05,0.00,0.00,0.00,0.00,0.00),('5','104','897','214777',4155875,'2673','395',1340925.10,1341900.57,975.47,287763.65,0.00,0.00,0.00,0.00,0.00),('5','104','898','214777',4155876,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','214777',4155877,'2675','394',2088646.91,2091753.64,3106.73,512610.45,0.00,0.00,0.00,0.00,0.00),('5','104','896','214777',4155878,'2676','394',1355038.52,1355038.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','214998',4159535,'2669','394',1983478.76,1984718.32,1239.56,204527.40,0.00,0.00,0.00,0.00,0.00),('5','104','895','214998',4159536,'2670','394',1046206.04,1047788.82,1582.78,261158.70,0.00,0.00,0.00,0.00,0.00),('5','104','896','214998',4159537,'2671','394',1723285.76,1724350.30,1064.54,175649.10,0.00,0.00,0.00,0.00,0.00),('5','104','896','214998',4159538,'2672','394',970002.07,972691.40,2689.33,443739.45,0.00,0.00,0.00,0.00,0.00),('5','104','897','214998',4159539,'2673','395',1341900.57,1342251.62,351.05,103559.75,0.00,0.00,0.00,0.00,0.00),('5','104','898','214998',4159540,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','214998',4159541,'2675','394',2091753.64,2093045.38,1291.74,213137.10,0.00,0.00,0.00,0.00,0.00),('5','104','896','214998',4159542,'2676','394',1355038.52,1355038.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','215235',4163586,'2669','394',1984718.32,1986030.73,1312.41,216547.65,0.00,0.00,0.00,0.00,0.00),('5','104','895','215235',4163587,'2670','394',1047788.82,1049596.15,1807.33,298209.45,0.00,0.00,0.00,0.00,0.00),('5','104','896','215235',4163588,'2671','394',1724350.30,1725366.00,1015.70,167590.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','215235',4163589,'2672','394',972691.40,976285.04,3593.64,592950.60,0.00,0.00,0.00,0.00,0.00),('5','104','897','215235',4163590,'2673','395',1342251.62,1342597.80,346.18,102123.10,0.00,0.00,0.00,0.00,0.00),('5','104','898','215235',4163591,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','215235',4163592,'2675','394',2093045.38,2093045.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','215235',4163593,'2676','394',1355038.52,1355038.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','215828',4173813,'2669','394',1986030.73,1988296.65,2265.92,373876.80,0.00,0.00,0.00,0.00,0.00),('5','104','895','215828',4173814,'2670','394',1049596.15,1049596.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','215828',4173815,'2671','394',1725366.00,1725385.57,19.57,3229.05,0.00,0.00,0.00,0.00,0.00),('5','104','896','215828',4173816,'2672','394',976285.04,979258.89,2973.85,490685.25,0.00,0.00,0.00,0.00,0.00),('5','104','897','215828',4173817,'2673','395',1342597.80,1343697.00,1099.20,324264.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','215828',4173818,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','215828',4173819,'2675','394',2093045.38,2095332.63,2287.25,377396.25,0.00,0.00,0.00,0.00,0.00),('5','104','896','215828',4173820,'2676','394',1355038.52,1355038.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','215852',4174214,'2669','394',1988296.65,1990448.02,2151.37,354976.05,0.00,0.00,0.00,0.00,0.00),('5','104','895','215852',4174215,'2670','394',1049596.15,1049596.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','215852',4174216,'2671','394',1725385.57,1725385.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','215852',4174217,'2672','394',979258.89,982071.62,2812.73,464100.45,0.00,0.00,0.00,0.00,0.00),('5','104','897','215852',4174218,'2673','395',1343697.00,1343938.87,241.87,71351.65,0.00,0.00,0.00,0.00,0.00),('5','104','898','215852',4174219,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','215852',4174220,'2675','394',2095332.63,2097990.86,2658.23,438607.95,0.00,0.00,0.00,0.00,0.00),('5','104','896','215852',4174221,'2676','394',1355038.52,1355038.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','215934',4175405,'2669','394',1990448.02,1992963.31,2515.29,415022.85,0.00,0.00,0.00,0.00,0.00),('5','104','895','215934',4175406,'2670','394',1049596.15,1049596.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','215934',4175407,'2671','394',1725385.57,1725385.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','215934',4175408,'2672','394',982071.62,984068.44,1996.82,329475.30,0.00,0.00,0.00,0.00,0.00),('5','104','897','215934',4175409,'2673','395',1343938.87,1344701.44,762.57,224958.15,0.00,0.00,0.00,0.00,0.00),('5','104','898','215934',4175410,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','215934',4175411,'2675','394',2097990.86,2099627.65,1636.79,270070.35,0.00,0.00,0.00,0.00,0.00),('5','104','896','215934',4175412,'2676','394',1355038.52,1355038.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','216144',4179063,'2669','394',1992963.31,1995845.64,2882.33,475584.45,0.00,0.00,0.00,0.00,0.00),('5','104','895','216144',4179064,'2670','394',1049596.15,1049597.15,1.00,165.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','216144',4179065,'2671','394',1725385.57,1725538.07,152.50,25162.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','216144',4179066,'2672','394',984068.44,985497.58,1429.14,235808.10,0.00,0.00,0.00,0.00,0.00),('5','104','897','216144',4179067,'2673','395',1344701.44,1345331.75,630.31,185941.45,0.00,0.00,0.00,0.00,0.00),('5','104','898','216144',4179068,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','216144',4179069,'2675','394',2099627.65,2102290.21,2662.56,439322.40,0.00,0.00,0.00,0.00,0.00),('5','104','896','216144',4179070,'2676','394',1355038.52,1355038.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','216369',4182885,'2669','394',1995845.64,1996962.61,1116.97,184300.05,0.00,0.00,0.00,0.00,0.00),('5','104','895','216369',4182886,'2670','394',1049597.15,1049597.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','216369',4182887,'2671','394',1725538.07,1728211.87,2673.80,441177.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','216369',4182888,'2672','394',985497.58,985853.46,355.88,58720.20,0.00,0.00,0.00,0.00,0.00),('5','104','897','216369',4182889,'2673','395',1345331.75,1346388.34,1056.59,311694.05,0.00,0.00,0.00,0.00,0.00),('5','104','898','216369',4182890,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','216369',4182891,'2675','394',2102290.21,2103585.92,1295.71,213792.15,0.00,0.00,0.00,0.00,0.00),('5','104','896','216369',4182892,'2676','394',1355038.52,1357132.34,2093.82,345480.30,0.00,0.00,0.00,0.00,0.00),('5','104','895','216579',4186501,'2669','394',1996962.61,1997316.55,353.94,58400.10,0.00,0.00,0.00,0.00,0.00),('5','104','895','216579',4186502,'2670','394',1049597.15,1049597.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','216579',4186503,'2671','394',1728211.87,1731616.58,3404.71,561777.15,0.00,0.00,0.00,0.00,0.00),('5','104','896','216579',4186504,'2672','394',985853.46,987348.89,1495.43,246745.95,0.00,0.00,0.00,0.00,0.00),('5','104','897','216579',4186505,'2673','395',1346388.34,1346714.65,326.31,96261.45,0.00,0.00,0.00,0.00,0.00),('5','104','898','216579',4186506,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','216579',4186507,'2675','394',2103585.92,2106495.85,2909.93,480138.45,0.00,0.00,0.00,0.00,0.00),('5','104','896','216579',4186508,'2676','394',1357132.34,1357132.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','216921',4192752,'2669','394',1997316.55,1999068.46,1751.91,289065.15,0.00,0.00,0.00,0.00,0.00),('5','104','895','216921',4192753,'2670','394',1049597.15,1051317.05,1719.90,283783.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','216921',4192754,'2671','394',1731616.58,1731616.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','216921',4192755,'2672','394',987348.89,989480.81,2131.92,351766.80,0.00,0.00,0.00,0.00,0.00),('5','104','897','216921',4192756,'2673','395',1346714.65,1347305.99,591.34,174445.30,0.00,0.00,0.00,0.00,0.00),('5','104','898','216921',4192757,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','216921',4192758,'2675','394',2106495.85,2108919.55,2423.70,399910.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','216921',4192759,'2676','394',1357132.34,1357581.20,448.86,74061.90,0.00,0.00,0.00,0.00,0.00),('5','104','895','217257',4199174,'2669','394',1999068.46,2001182.80,2114.34,348866.10,0.00,0.00,0.00,0.00,0.00),('5','104','895','217257',4199175,'2670','394',1051317.05,1051317.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','217257',4199176,'2671','394',1731616.58,1731616.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','217257',4199177,'2672','394',989480.81,991803.60,2322.79,383260.35,0.00,0.00,0.00,0.00,0.00),('5','104','897','217257',4199178,'2673','395',1347305.99,1347707.32,401.33,118392.35,0.00,0.00,0.00,0.00,0.00),('5','104','898','217257',4199179,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','217257',4199180,'2675','394',2108919.55,2111254.17,2334.62,385212.30,0.00,0.00,0.00,0.00,0.00),('5','104','896','217257',4199181,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','217284',4199465,'2669','394',2001182.80,2003609.44,2426.64,400395.60,0.00,0.00,0.00,0.00,0.00),('5','104','895','217284',4199466,'2670','394',1051317.05,1051317.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','217284',4199467,'2671','394',1731616.58,1731616.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','217284',4199468,'2672','394',991803.60,993720.50,1916.90,316288.50,0.00,0.00,0.00,0.00,0.00),('5','104','897','217284',4199469,'2673','395',1347707.32,1348040.10,332.78,98170.10,0.00,0.00,0.00,0.00,0.00),('5','104','898','217284',4199470,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','217284',4199471,'2675','394',2111254.17,2113353.45,2099.28,346381.20,0.00,0.00,0.00,0.00,0.00),('5','104','896','217284',4199472,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','217696',4206650,'2669','394',2003609.44,2006495.26,2885.82,476160.30,0.00,0.00,0.00,0.00,0.00),('5','104','895','217696',4206651,'2670','394',1051317.05,1051317.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','217696',4206652,'2671','394',1731616.58,1731616.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','217696',4206653,'2672','394',993720.50,995834.03,2113.53,348732.45,0.00,0.00,0.00,0.00,0.00),('5','104','897','217696',4206654,'2673','395',1348040.10,1348508.29,468.19,138116.05,0.00,0.00,0.00,0.00,0.00),('5','104','898','217696',4206655,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','217696',4206656,'2675','394',2113353.45,2115311.07,1957.62,323007.30,0.00,0.00,0.00,0.00,0.00),('5','104','896','217696',4206657,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','217803',4208410,'2669','394',2006495.26,2008991.40,2496.14,411863.10,0.00,0.00,0.00,0.00,0.00),('5','104','895','217803',4208411,'2670','394',1051317.05,1051317.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','217803',4208412,'2671','394',1731616.58,1731616.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','217803',4208413,'2672','394',995834.03,997983.40,2149.37,354646.05,0.00,0.00,0.00,0.00,0.00),('5','104','897','217803',4208414,'2673','395',1348508.29,1348751.82,243.53,71841.35,0.00,0.00,0.00,0.00,0.00),('5','104','898','217803',4208415,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','217803',4208416,'2675','394',2115311.07,2117858.11,2547.04,420261.60,0.00,0.00,0.00,0.00,0.00),('5','104','896','217803',4208417,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','218009',4212096,'2669','394',2008991.40,2011520.46,2529.06,417294.90,0.00,0.00,0.00,0.00,0.00),('5','104','895','218009',4212097,'2670','394',1051317.05,1051478.05,161.00,26565.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','218009',4212098,'2671','394',1731616.58,1731616.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','218009',4212099,'2672','394',997983.40,1000481.65,2498.25,412211.25,0.00,0.00,0.00,0.00,0.00),('5','104','897','218009',4212100,'2673','395',1348751.82,1349285.91,534.09,157556.55,0.00,0.00,0.00,0.00,0.00),('5','104','898','218009',4212101,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','218009',4212102,'2675','394',2117858.11,2120398.65,2540.54,419189.10,0.00,0.00,0.00,0.00,0.00),('5','104','896','218009',4212103,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','218209',4215689,'2669','394',2011520.46,2011520.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','218209',4215690,'2670','394',1051478.05,1051717.76,239.71,39552.15,0.00,0.00,0.00,0.00,0.00),('5','104','896','218209',4215691,'2671','394',1731616.58,1731616.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','218209',4215692,'2672','394',1000481.65,1006383.52,5901.87,973808.55,0.00,0.00,0.00,0.00,0.00),('5','104','897','218209',4215693,'2673','395',1349285.91,1350131.38,845.47,249413.65,0.00,0.00,0.00,0.00,0.00),('5','104','898','218209',4215694,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','218209',4215695,'2675','394',2120398.65,2120398.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','218209',4215696,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','218447',4219829,'2669','394',2011520.46,2011520.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','218447',4219830,'2670','394',1051717.76,1051717.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','218447',4219831,'2671','394',1731616.58,1734213.75,2597.17,428533.05,0.00,0.00,0.00,0.00,0.00),('5','104','896','218447',4219832,'2672','394',1006383.52,1010187.82,3804.30,627709.50,0.00,0.00,0.00,0.00,0.00),('5','104','897','218447',4219833,'2673','395',1350131.38,1350520.04,388.66,114654.70,0.00,0.00,0.00,0.00,0.00),('5','104','898','218447',4219834,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','218447',4219835,'2675','394',2120398.65,2120398.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','218447',4219836,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','218711',4224373,'2669','394',2011520.46,2011520.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','218711',4224374,'2670','394',1051717.76,1051717.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','218711',4224375,'2671','394',1734213.75,1736094.44,1880.69,310313.85,0.00,0.00,0.00,0.00,0.00),('5','104','896','218711',4224376,'2672','394',1010187.82,1011884.79,1696.97,280000.05,0.00,0.00,0.00,0.00,0.00),('5','104','897','218711',4224377,'2673','395',1350520.04,1350835.56,315.52,93078.40,0.00,0.00,0.00,0.00,0.00),('5','104','898','218711',4224378,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','218711',4224379,'2675','394',2120398.65,2120398.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','218711',4224380,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','218935',4228314,'2669','394',2011520.46,2011890.01,369.55,60975.75,0.00,0.00,0.00,0.00,0.00),('5','104','895','218935',4228315,'2670','394',1051717.76,1051717.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','218935',4228316,'2671','394',1736094.44,1736094.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','218935',4228317,'2672','394',1011884.79,1011884.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','218935',4228318,'2673','395',1350835.56,1351297.55,461.99,136287.05,0.00,0.00,0.00,0.00,0.00),('5','104','898','218935',4228319,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','218935',4228320,'2675','394',2120398.65,2120640.06,241.41,39832.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','218935',4228321,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','219163',4232149,'2669','394',2011890.01,2014861.83,2971.82,490350.30,0.00,0.00,0.00,0.00,0.00),('5','104','895','219163',4232150,'2670','394',1051717.76,1052939.28,1221.52,201550.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','219163',4232151,'2671','394',1736094.44,1736094.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','219163',4232152,'2672','394',1011884.79,1011884.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','219163',4232153,'2673','395',1351297.55,1351991.18,693.63,204620.85,0.00,0.00,0.00,0.00,0.00),('5','104','898','219163',4232154,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','219163',4232155,'2675','394',2120640.06,2122289.87,1649.81,272218.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','219163',4232156,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','219337',4235360,'2669','394',2014861.83,2017487.88,2626.05,433298.25,0.00,0.00,0.00,0.00,0.00),('5','104','895','219337',4235361,'2670','394',1052939.28,1054818.49,1879.21,310069.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','219337',4235362,'2671','394',1736094.44,1736094.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','219337',4235363,'2672','394',1011884.79,1011884.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','219337',4235364,'2673','395',1351991.18,1352560.45,569.27,167934.65,0.00,0.00,0.00,0.00,0.00),('5','104','898','219337',4235365,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','219337',4235366,'2675','394',2122289.87,2125183.10,2893.23,477382.95,0.00,0.00,0.00,0.00,0.00),('5','104','896','219337',4235367,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','219610',4239902,'2669','394',2017487.88,2019696.92,2209.04,364491.60,0.00,0.00,0.00,0.00,0.00),('5','104','895','219610',4239903,'2670','394',1054818.49,1056551.49,1733.00,285945.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','219610',4239904,'2671','394',1736094.44,1736094.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','219610',4239905,'2672','394',1011884.79,1011884.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','219610',4239906,'2673','395',1352560.45,1352910.29,349.84,103202.80,0.00,0.00,0.00,0.00,0.00),('5','104','898','219610',4239907,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','219610',4239908,'2675','394',2125183.10,2127600.45,2417.35,398862.75,0.00,0.00,0.00,0.00,0.00),('5','104','896','219610',4239909,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','219844',4244147,'2669','394',2019696.92,2021883.10,2186.18,360719.70,0.00,0.00,0.00,0.00,0.00),('5','104','895','219844',4244148,'2670','394',1056551.49,1058158.80,1607.31,265206.15,0.00,0.00,0.00,0.00,0.00),('5','104','896','219844',4244149,'2671','394',1736094.44,1736356.86,262.42,43299.30,0.00,0.00,0.00,0.00,0.00),('5','104','896','219844',4244150,'2672','394',1011884.79,1011884.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','219844',4244151,'2673','395',1352910.29,1353327.79,417.50,123162.50,0.00,0.00,0.00,0.00,0.00),('5','104','898','219844',4244152,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','219844',4244153,'2675','394',2127600.45,2129614.65,2014.20,332343.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','219844',4244154,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','220034',4247841,'2669','394',2021883.10,2022338.11,455.01,75076.65,0.00,0.00,0.00,0.00,0.00),('5','104','895','220034',4247842,'2670','394',1058158.80,1060000.73,1841.93,303918.45,0.00,0.00,0.00,0.00,0.00),('5','104','896','220034',4247843,'2671','394',1736356.86,1736356.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','220034',4247844,'2672','394',1011884.79,1014185.16,2300.37,379561.05,0.00,0.00,0.00,0.00,0.00),('5','104','897','220034',4247845,'2673','395',1353327.79,1353566.51,238.72,70422.40,0.00,0.00,0.00,0.00,0.00),('5','104','898','220034',4247846,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','220034',4247847,'2675','394',2129614.65,2131905.02,2290.37,377911.05,0.00,0.00,0.00,0.00,0.00),('5','104','896','220034',4247848,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','220311',4252440,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','220311',4252441,'2670','394',1060000.73,1062029.81,2029.08,334798.20,0.00,0.00,0.00,0.00,0.00),('5','104','896','220311',4252442,'2671','394',1736356.86,1738468.67,2111.81,348448.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','220311',4252443,'2672','394',1014185.16,1016233.93,2048.77,338047.05,0.00,0.00,0.00,0.00,0.00),('5','104','897','220311',4252444,'2673','395',1353566.51,1353981.54,415.03,122433.85,0.00,0.00,0.00,0.00,0.00),('5','104','898','220311',4252445,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','220311',4252446,'2675','394',2131905.02,2131905.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','220311',4252447,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','220670',4259128,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','220670',4259129,'2670','394',1062029.81,1062216.75,186.94,30845.10,0.00,0.00,0.00,0.00,0.00),('5','104','896','220670',4259130,'2671','394',1738468.67,1741006.51,2537.84,418743.60,0.00,0.00,0.00,0.00,0.00),('5','104','896','220670',4259131,'2672','394',1016233.93,1019065.21,2831.28,467161.20,0.00,0.00,0.00,0.00,0.00),('5','104','897','220670',4259132,'2673','395',1353981.54,1354379.12,397.58,117286.10,0.00,0.00,0.00,0.00,0.00),('5','104','898','220670',4259133,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','220670',4259134,'2675','394',2131905.02,2131905.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','220670',4259135,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','220713',4259592,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','220713',4259593,'2670','394',1062216.75,1064436.34,2219.59,366232.35,0.00,0.00,0.00,0.00,0.00),('5','104','896','220713',4259594,'2671','394',1741006.51,1743208.32,2201.81,363298.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','220713',4259595,'2672','394',1019065.21,1019610.91,545.70,90040.50,0.00,0.00,0.00,0.00,0.00),('5','104','897','220713',4259596,'2673','395',1354379.12,1354676.67,297.55,87777.25,0.00,0.00,0.00,0.00,0.00),('5','104','898','220713',4259597,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','220713',4259598,'2675','394',2131905.02,2132681.06,776.04,128046.60,0.00,0.00,0.00,0.00,0.00),('5','104','896','220713',4259599,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','220894',4263129,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','220894',4263130,'2670','394',1064436.34,1068220.92,3784.58,624455.70,0.00,0.00,0.00,0.00,0.00),('5','104','896','220894',4263131,'2671','394',1743208.32,1743208.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','220894',4263132,'2672','394',1019610.91,1019610.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','220894',4263133,'2673','395',1354676.67,1354988.81,312.14,92081.30,0.00,0.00,0.00,0.00,0.00),('5','104','898','220894',4263134,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','220894',4263135,'2675','394',2132681.06,2135777.81,3096.75,510963.75,0.00,0.00,0.00,0.00,0.00),('5','104','896','220894',4263136,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','221173',4267733,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','221173',4267734,'2670','394',1068220.92,1070836.68,2615.76,431600.40,0.00,0.00,0.00,0.00,0.00),('5','104','896','221173',4267735,'2671','394',1743208.32,1743495.95,287.63,47458.95,0.00,0.00,0.00,0.00,0.00),('5','104','896','221173',4267736,'2672','394',1019610.91,1021034.45,1423.54,234884.10,0.00,0.00,0.00,0.00,0.00),('5','104','897','221173',4267737,'2673','395',1354988.81,1355332.89,344.08,101503.60,0.00,0.00,0.00,0.00,0.00),('5','104','898','221173',4267738,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','221173',4267739,'2675','394',2135777.81,2137646.92,1869.11,308403.15,0.00,0.00,0.00,0.00,0.00),('5','104','896','221173',4267740,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','221564',4275169,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','221564',4275170,'2670','394',1070836.68,1072925.00,2088.32,344572.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','221564',4275171,'2671','394',1743495.95,1744420.87,924.92,152611.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','221564',4275172,'2672','394',1021034.45,1022091.32,1056.87,174383.55,0.00,0.00,0.00,0.00,0.00),('5','104','897','221564',4275173,'2673','395',1355332.89,1356344.12,1011.23,298312.85,0.00,0.00,0.00,0.00,0.00),('5','104','898','221564',4275174,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','221564',4275175,'2675','394',2137646.92,2140065.04,2418.12,398989.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','221564',4275176,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','221627',4276136,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','221627',4276137,'2670','394',1072925.00,1075051.31,2126.31,350841.15,0.00,0.00,0.00,0.00,0.00),('5','104','896','221627',4276138,'2671','394',1744420.87,1745806.08,1385.21,228559.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','221627',4276139,'2672','394',1022091.32,1022990.42,899.10,148351.50,0.00,0.00,0.00,0.00,0.00),('5','104','897','221627',4276140,'2673','395',1356344.12,1356741.09,396.97,117106.15,0.00,0.00,0.00,0.00,0.00),('5','104','898','221627',4276141,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','221627',4276142,'2675','394',2140065.04,2142061.56,1996.52,329425.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','221627',4276143,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','221827',4279779,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','221827',4279780,'2670','394',1075051.31,1077550.08,2498.77,412297.05,0.00,0.00,0.00,0.00,0.00),('5','104','896','221827',4279781,'2671','394',1745806.08,1747959.83,2153.75,355368.75,0.00,0.00,0.00,0.00,0.00),('5','104','896','221827',4279782,'2672','394',1022990.42,1025062.89,2072.47,341957.55,0.00,0.00,0.00,0.00,0.00),('5','104','897','221827',4279783,'2673','395',1356741.09,1357025.99,284.90,84045.50,0.00,0.00,0.00,0.00,0.00),('5','104','898','221827',4279784,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','221827',4279785,'2675','394',2142061.56,2142061.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','221827',4279786,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','222588',4292851,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','222588',4292852,'2670','394',1077550.08,1079858.03,2307.95,380811.75,0.00,0.00,0.00,0.00,0.00),('5','104','896','222588',4292853,'2671','394',1747959.83,1749708.91,1749.08,288598.20,0.00,0.00,0.00,0.00,0.00),('5','104','896','222588',4292854,'2672','394',1025062.89,1026610.62,1547.73,255375.45,0.00,0.00,0.00,0.00,0.00),('5','104','897','222588',4292855,'2673','395',1357025.99,1357687.26,661.27,195074.65,0.00,0.00,0.00,0.00,0.00),('5','104','898','222588',4292857,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','222588',4292859,'2675','394',2142061.56,2142061.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','222588',4292861,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','222607',4293258,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','222607',4293259,'2670','394',1079858.03,1080130.20,272.17,44908.05,0.00,0.00,0.00,0.00,0.00),('5','104','896','222607',4293260,'2671','394',1749708.91,1751596.11,1887.20,311388.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','222607',4293261,'2672','394',1026610.62,1028573.59,1962.97,323890.05,0.00,0.00,0.00,0.00,0.00),('5','104','897','222607',4293262,'2673','395',1357687.26,1358018.65,331.39,97760.05,0.00,0.00,0.00,0.00,0.00),('5','104','898','222607',4293263,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','222607',4293264,'2675','394',2142061.56,2143531.27,1469.71,242502.15,0.00,0.00,0.00,0.00,0.00),('5','104','896','222607',4293265,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','222611',4293363,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','222611',4293364,'2670','394',1080130.20,1080130.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','222611',4293365,'2671','394',1751596.11,1753385.50,1789.39,295249.35,0.00,0.00,0.00,0.00,0.00),('5','104','896','222611',4293366,'2672','394',1028573.59,1030452.63,1879.04,310041.60,0.00,0.00,0.00,0.00,0.00),('5','104','897','222611',4293367,'2673','395',1358018.65,1358291.09,272.44,80369.80,0.00,0.00,0.00,0.00,0.00),('5','104','898','222611',4293368,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','222611',4293369,'2675','394',2143531.27,2146111.56,2580.29,425747.85,0.00,0.00,0.00,0.00,0.00),('5','104','896','222611',4293370,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','223075',4302183,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','223075',4302184,'2670','394',1080130.20,1080130.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','223075',4302185,'2671','394',1753385.50,1755235.49,1849.99,305248.35,0.00,0.00,0.00,0.00,0.00),('5','104','896','223075',4302186,'2672','394',1030452.63,1032323.22,1870.59,308647.35,0.00,0.00,0.00,0.00,0.00),('5','104','897','223075',4302187,'2673','395',1358291.09,1358476.07,184.98,54569.10,0.00,0.00,0.00,0.00,0.00),('5','104','898','223075',4302188,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','223075',4302189,'2675','394',2146111.56,2148801.50,2689.94,443840.10,0.00,0.00,0.00,0.00,0.00),('5','104','896','223075',4302190,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','223084',4302331,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','223084',4302332,'2670','394',1080130.20,1082599.74,2469.54,407474.10,0.00,0.00,0.00,0.00,0.00),('5','104','896','223084',4302333,'2671','394',1755235.49,1757035.91,1800.42,297069.30,0.00,0.00,0.00,0.00,0.00),('5','104','896','223084',4302334,'2672','394',1032323.22,1034098.07,1774.85,292850.25,0.00,0.00,0.00,0.00,0.00),('5','104','897','223084',4302335,'2673','395',1358476.07,1358810.30,334.23,98597.85,0.00,0.00,0.00,0.00,0.00),('5','104','898','223084',4302336,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','223084',4302337,'2675','394',2148801.50,2148801.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','223084',4302338,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','223622',4311858,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','223622',4311859,'2670','394',1082599.74,1085486.43,2886.69,476303.85,0.00,0.00,0.00,0.00,0.00),('5','104','896','223622',4311860,'2671','394',1757035.91,1758169.20,1133.29,186992.85,0.00,0.00,0.00,0.00,0.00),('5','104','896','223622',4311861,'2672','394',1034098.07,1036212.22,2114.15,348834.75,0.00,0.00,0.00,0.00,0.00),('5','104','897','223622',4311862,'2673','395',1358810.30,1358974.24,163.94,48362.30,0.00,0.00,0.00,0.00,0.00),('5','104','898','223622',4311863,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','223622',4311864,'2675','394',2148801.50,2148801.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','223622',4311865,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','223676',4312560,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','223676',4312561,'2670','394',1085486.43,1087779.02,2292.59,378277.35,0.00,0.00,0.00,0.00,0.00),('5','104','896','223676',4312562,'2671','394',1758169.20,1760635.99,2466.79,407020.35,0.00,0.00,0.00,0.00,0.00),('5','104','896','223676',4312563,'2672','394',1036212.22,1037835.79,1623.57,267889.05,0.00,0.00,0.00,0.00,0.00),('5','104','897','223676',4312564,'2673','395',1358974.24,1359437.77,463.53,136741.35,0.00,0.00,0.00,0.00,0.00),('5','104','898','223676',4312565,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','223676',4312566,'2675','394',2148801.50,2148801.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','223676',4312567,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','224423',4326039,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','224423',4326040,'2670','394',1087779.02,1090054.97,2275.95,375531.75,0.00,0.00,0.00,0.00,0.00),('5','104','896','224423',4326041,'2671','394',1760635.99,1762517.50,1881.51,310449.15,0.00,0.00,0.00,0.00,0.00),('5','104','896','224423',4326042,'2672','394',1037835.79,1039827.55,1991.76,328640.40,0.00,0.00,0.00,0.00,0.00),('5','104','897','224423',4326043,'2673','395',1359437.77,1359814.86,377.09,111241.55,0.00,0.00,0.00,0.00,0.00),('5','104','898','224423',4326044,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','224423',4326045,'2675','394',2148801.50,2148801.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','224423',4326046,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','224427',4326085,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','224427',4326086,'2670','394',1090054.97,1093029.33,2974.36,490769.40,0.00,0.00,0.00,0.00,0.00),('5','104','896','224427',4326087,'2671','394',1762517.50,1762517.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','224427',4326088,'2672','394',1039827.55,1042485.85,2658.30,438619.50,0.00,0.00,0.00,0.00,0.00),('5','104','897','224427',4326089,'2673','395',1359814.86,1360166.68,351.82,103786.90,0.00,0.00,0.00,0.00,0.00),('5','104','898','224427',4326090,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','224427',4326091,'2675','394',2148801.50,2148801.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','224427',4326092,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','224429',4326111,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','224429',4326112,'2670','394',1093029.33,1096267.53,3238.20,534303.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','224429',4326113,'2671','394',1762517.50,1762517.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','224429',4326114,'2672','394',1042485.85,1045110.43,2624.58,433055.70,0.00,0.00,0.00,0.00,0.00),('5','104','897','224429',4326115,'2673','395',1360166.68,1360729.29,562.61,165969.95,0.00,0.00,0.00,0.00,0.00),('5','104','898','224429',4326116,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','224429',4326117,'2675','394',2148801.50,2148801.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','224429',4326118,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','224432',4326151,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','224432',4326152,'2670','394',1096267.53,1100359.70,4092.17,675208.05,0.00,0.00,0.00,0.00,0.00),('5','104','896','224432',4326153,'2671','394',1762517.50,1762517.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','224432',4326154,'2672','394',1045110.43,1045110.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','224432',4326155,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','224432',4326156,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','224432',4326157,'2675','394',2148801.50,2149564.95,763.45,125969.25,0.00,0.00,0.00,0.00,0.00),('5','104','896','224432',4326158,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','225903',4352391,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','225903',4352392,'2670','394',1100359.70,1104680.50,4320.80,712932.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','225903',4352393,'2671','394',1762517.50,1762517.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','225903',4352394,'2672','394',1045110.43,1045110.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','225903',4352395,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','225903',4352396,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','225903',4352397,'2675','394',2149564.95,2149564.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','225903',4352398,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','225905',4352405,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','225905',4352406,'2670','394',1104680.50,1106446.79,1766.29,291437.85,0.00,0.00,0.00,0.00,0.00),('5','104','896','225905',4352407,'2671','394',1762517.50,1762517.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','225905',4352408,'2672','394',1045110.43,1045110.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','225905',4352409,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','225905',4352410,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','225905',4352411,'2675','394',2149564.95,2149564.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','225905',4352412,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','225908',4352459,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','225908',4352460,'2670','394',1106446.79,1106446.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','225908',4352461,'2671','394',1762517.50,1762517.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','225908',4352462,'2672','394',1045110.43,1045110.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','225908',4352463,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','225908',4352464,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','225908',4352465,'2675','394',2149564.95,2149564.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','225908',4352466,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','225911',4352531,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','225911',4352532,'2670','394',1106446.79,1106446.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','225911',4352533,'2671','394',1762517.50,1762517.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','225911',4352534,'2672','394',1045110.43,1045110.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','225911',4352535,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','225911',4352536,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','225911',4352537,'2675','394',2149564.95,2149564.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','225911',4352538,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','225913',4352565,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','225913',4352566,'2670','394',1106446.79,1107837.63,1390.84,226706.92,0.00,0.00,0.00,0.00,0.00),('5','104','896','225913',4352567,'2671','394',1762517.50,1762517.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','225913',4352568,'2672','394',1045110.43,1046611.71,1501.28,244708.64,0.00,0.00,0.00,0.00,0.00),('5','104','897','225913',4352569,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','225913',4352570,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','225913',4352571,'2675','394',2149564.95,2149564.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','225913',4352572,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','225915',4352596,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','225915',4352597,'2670','394',1107837.63,1109974.16,2136.53,348254.39,0.00,0.00,0.00,0.00,0.00),('5','104','896','225915',4352598,'2671','394',1762517.50,1762517.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','225915',4352599,'2672','394',1046611.71,1048849.99,2238.28,364839.64,0.00,0.00,0.00,0.00,0.00),('5','104','897','225915',4352600,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','225915',4352601,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','225915',4352602,'2675','394',2149564.95,2151556.63,1991.68,324643.84,0.00,0.00,0.00,0.00,0.00),('5','104','896','225915',4352603,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','226807',4368484,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','226807',4368485,'2670','394',1109974.16,1112697.38,2723.22,443884.86,0.00,0.00,0.00,0.00,0.00),('5','104','896','226807',4368486,'2671','394',1762517.50,1762646.85,129.35,21084.05,0.00,0.00,0.00,0.00,0.00),('5','104','896','226807',4368487,'2672','394',1048849.99,1052073.06,3223.07,525360.41,0.00,0.00,0.00,0.00,0.00),('5','104','897','226807',4368488,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','226807',4368489,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','226807',4368490,'2675','394',2151556.63,2154870.70,3314.07,540193.41,0.00,0.00,0.00,0.00,0.00),('5','104','896','226807',4368491,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','226810',4368559,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','226810',4368560,'2670','394',1112697.38,1114511.22,1813.84,295655.92,0.00,0.00,0.00,0.00,0.00),('5','104','896','226810',4368561,'2671','394',1762646.85,1765284.82,2637.97,429989.11,0.00,0.00,0.00,0.00,0.00),('5','104','896','226810',4368562,'2672','394',1052073.06,1053055.60,982.54,160154.02,0.00,0.00,0.00,0.00,0.00),('5','104','897','226810',4368563,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','226810',4368564,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','226810',4368565,'2675','394',2154870.70,2156725.87,1855.17,302392.71,0.00,0.00,0.00,0.00,0.00),('5','104','896','226810',4368566,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','226817',4368685,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','226817',4368686,'2670','394',1114511.22,1114511.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','226817',4368687,'2671','394',1765284.82,1769321.48,4036.66,657975.58,0.00,0.00,0.00,0.00,0.00),('5','104','896','226817',4368688,'2672','394',1053055.60,1056771.48,3715.88,605688.44,0.00,0.00,0.00,0.00,0.00),('5','104','897','226817',4368689,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','226817',4368690,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','226817',4368691,'2675','394',2156725.87,2156725.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','226817',4368692,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','226819',4368709,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','226819',4368710,'2670','394',1114511.22,1116794.07,2282.85,372104.55,0.00,0.00,0.00,0.00,0.00),('5','104','896','226819',4368711,'2671','394',1769321.48,1770503.01,1181.53,192589.39,0.00,0.00,0.00,0.00,0.00),('5','104','896','226819',4368712,'2672','394',1056771.48,1059105.57,2334.09,380456.67,0.00,0.00,0.00,0.00,0.00),('5','104','897','226819',4368713,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','226819',4368714,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','226819',4368715,'2675','394',2156725.87,2157853.04,1127.17,183728.71,0.00,0.00,0.00,0.00,0.00),('5','104','896','226819',4368716,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','227714',4384470,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','227714',4384471,'2670','394',1116794.07,1119994.57,3200.50,528082.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','227714',4384472,'2671','394',1770503.01,1771395.10,892.09,147194.85,0.00,0.00,0.00,0.00,0.00),('5','104','896','227714',4384473,'2672','394',1059105.57,1061262.49,2156.92,355891.80,0.00,0.00,0.00,0.00,0.00),('5','104','897','227714',4384474,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','227714',4384475,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','227714',4384476,'2675','394',2157853.04,2157853.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','227714',4384477,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','227737',4384888,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','227737',4384889,'2670','394',1119994.57,1121915.33,1920.76,313083.88,0.00,0.00,0.00,0.00,0.00),('5','104','896','227737',4384890,'2671','394',1771395.10,1773780.94,2385.84,388891.92,0.00,0.00,0.00,0.00,0.00),('5','104','896','227737',4384891,'2672','394',1061262.49,1062872.37,1609.88,262410.44,0.00,0.00,0.00,0.00,0.00),('5','104','897','227737',4384892,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','227737',4384893,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','227737',4384894,'2675','394',2157853.04,2157853.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','227737',4384895,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','227740',4384930,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','227740',4384931,'2670','394',1121915.33,1124745.55,2830.22,461325.86,0.00,0.00,0.00,0.00,0.00),('5','104','896','227740',4384932,'2671','394',1773780.94,1775420.60,1639.66,267264.58,0.00,0.00,0.00,0.00,0.00),('5','104','896','227740',4384933,'2672','394',1062872.37,1064408.95,1536.58,250462.54,0.00,0.00,0.00,0.00,0.00),('5','104','897','227740',4384934,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','227740',4384935,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','227740',4384936,'2675','394',2157853.04,2157853.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','227740',4384937,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','227748',4385138,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','227748',4385139,'2670','394',1124745.55,1127566.53,2820.98,459819.74,0.00,0.00,0.00,0.00,0.00),('5','104','896','227748',4385140,'2671','394',1775420.60,1777546.96,2126.36,346596.68,0.00,0.00,0.00,0.00,0.00),('5','104','896','227748',4385141,'2672','394',1064408.95,1065763.29,1354.34,220757.42,0.00,0.00,0.00,0.00,0.00),('5','104','897','227748',4385142,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','227748',4385143,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','227748',4385144,'2675','394',2157853.04,2157853.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','227748',4385145,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','229293',4414208,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','229293',4414209,'2670','394',1127566.53,1130636.52,3069.99,500408.37,0.00,0.00,0.00,0.00,0.00),('5','104','896','229293',4414210,'2671','394',1777546.96,1780625.15,3078.19,501744.97,0.00,0.00,0.00,0.00,0.00),('5','104','896','229293',4414211,'2672','394',1065763.29,1065763.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','229293',4414212,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','229293',4414213,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','229293',4414214,'2675','394',2157853.04,2157853.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','229293',4414215,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','229301',4414354,'2669','394',2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','229301',4414355,'2670','394',1130636.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','229301',4414356,'2671','394',1780625.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','229301',4414357,'2672','394',1065763.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','229301',4414358,'2673','395',1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','229301',4414359,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','229301',4414360,'2675','394',2157853.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','229301',4414361,'2676','394',1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','229350',4415365,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','229350',4415366,'2670','394',1130636.52,1133844.32,3207.80,522871.40,0.00,0.00,0.00,0.00,0.00),('5','104','896','229350',4415367,'2671','394',1780625.15,1782794.42,2169.27,353591.01,0.00,0.00,0.00,0.00,0.00),('5','104','896','229350',4415368,'2672','394',1065763.29,1067040.48,1277.19,208181.97,0.00,0.00,0.00,0.00,0.00),('5','104','897','229350',4415369,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','229350',4415370,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','229350',4415371,'2675','394',2157853.04,2157853.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','229350',4415372,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','229509',4417940,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','229509',4417941,'2670','394',1133844.32,1136591.14,2746.82,447731.66,0.00,0.00,0.00,0.00,0.00),('5','104','896','229509',4417942,'2671','394',1782794.42,1782900.80,106.38,17339.94,0.00,0.00,0.00,0.00,0.00),('5','104','896','229509',4417943,'2672','394',1067040.48,1067040.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','229509',4417944,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','229509',4417945,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','229509',4417946,'2675','394',2157853.04,2159703.17,1850.13,301571.19,0.00,0.00,0.00,0.00,0.00),('5','104','896','229509',4417947,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','231244',4449897,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','231244',4449898,'2670','394',1136591.14,1137483.40,892.26,145438.38,0.00,0.00,0.00,0.00,0.00),('5','104','896','231244',4449899,'2671','394',1782900.80,1784106.38,1205.58,196509.54,0.00,0.00,0.00,0.00,0.00),('5','104','896','231244',4449900,'2672','394',1067040.48,1067413.64,373.16,60825.08,0.00,0.00,0.00,0.00,0.00),('5','104','897','231244',4449901,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','231244',4449902,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','231244',4449903,'2675','394',2159703.17,2160092.56,389.39,63470.57,0.00,0.00,0.00,0.00,0.00),('5','104','896','231244',4449904,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','231251',4449986,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','231251',4449987,'2670','394',1137483.40,1137483.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','231251',4449988,'2671','394',1784106.38,1784106.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','231251',4449989,'2672','394',1067413.64,1067413.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','231251',4449990,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','231251',4449991,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','231251',4449992,'2675','394',2160092.56,2160092.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','231251',4449993,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','231256',4450082,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','231256',4450083,'2670','394',1137483.40,1137483.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','231256',4450084,'2671','394',1784106.38,1784106.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','231256',4450085,'2672','394',1067413.64,1067413.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','231256',4450086,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','231256',4450087,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','231256',4450088,'2675','394',2160092.56,2160092.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','231256',4450089,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','231261',4450170,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','231261',4450171,'2670','394',1137483.40,1137483.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','231261',4450172,'2671','394',1784106.38,1784106.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','231261',4450173,'2672','394',1067413.64,1067413.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','231261',4450174,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','231261',4450175,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','231261',4450176,'2675','394',2160092.56,2160092.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','231261',4450177,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','231267',4450279,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','231267',4450280,'2670','394',1137483.40,1137483.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','231267',4450281,'2671','394',1784106.38,1784106.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','231267',4450282,'2672','394',1067413.64,1067413.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','231267',4450283,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','231267',4450284,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','231267',4450285,'2675','394',2160092.56,2160092.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','231267',4450286,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','231268',4450287,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','231268',4450288,'2670','394',1137483.40,1137483.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','231268',4450289,'2671','394',1784106.38,1784673.44,567.06,92430.78,0.00,0.00,0.00,0.00,0.00),('5','104','896','231268',4450290,'2672','394',1067413.64,1067841.90,428.26,69806.38,0.00,0.00,0.00,0.00,0.00),('5','104','897','231268',4450291,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','231268',4450292,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','231268',4450293,'2675','394',2160092.56,2160092.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','231268',4450294,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','231277',4450401,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','231277',4450402,'2670','394',1137483.40,1137483.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','231277',4450403,'2671','394',1784673.44,1787936.40,3262.96,531862.48,0.00,0.00,0.00,0.00,0.00),('5','104','896','231277',4450404,'2672','394',1067841.90,1068720.38,878.48,143192.24,0.00,0.00,0.00,0.00,0.00),('5','104','897','231277',4450405,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','231277',4450406,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','231277',4450407,'2675','394',2160092.56,2163380.16,3287.60,535878.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','231277',4450408,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','231283',4450480,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','231283',4450481,'2670','394',1137483.40,1137483.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','231283',4450482,'2671','394',1787936.40,1789858.82,1922.42,313354.46,0.00,0.00,0.00,0.00,0.00),('5','104','896','231283',4450483,'2672','394',1068720.38,1070589.78,1869.40,304712.20,0.00,0.00,0.00,0.00,0.00),('5','104','897','231283',4450484,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','231283',4450485,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','231283',4450486,'2675','394',2163380.16,2166951.85,3571.69,582185.47,0.00,0.00,0.00,0.00,0.00),('5','104','896','231283',4450487,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','231286',4450524,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','231286',4450525,'2670','394',1137483.40,1137483.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','231286',4450526,'2671','394',1789858.82,1793705.07,3846.25,626938.75,0.00,0.00,0.00,0.00,0.00),('5','104','896','231286',4450527,'2672','394',1070589.78,1071983.91,1394.13,227243.19,0.00,0.00,0.00,0.00,0.00),('5','104','897','231286',4450528,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','231286',4450529,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','231286',4450530,'2675','394',2166951.85,2170663.37,3711.52,604977.76,0.00,0.00,0.00,0.00,0.00),('5','104','896','231286',4450531,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','231288',4450540,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','231288',4450541,'2670','394',1137483.40,1138643.68,1160.28,189125.64,0.00,0.00,0.00,0.00,0.00),('5','104','896','231288',4450542,'2671','394',1793705.07,1795973.25,2268.18,369713.34,0.00,0.00,0.00,0.00,0.00),('5','104','896','231288',4450543,'2672','394',1071983.91,1073340.59,1356.68,221138.84,0.00,0.00,0.00,0.00,0.00),('5','104','897','231288',4450544,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','231288',4450545,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','231288',4450546,'2675','394',2170663.37,2174334.24,3670.87,598351.81,0.00,0.00,0.00,0.00,0.00),('5','104','896','231288',4450547,'2676','394',1357581.20,1357581.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','231295',4450688,'2669','394',2022338.11,2022338.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','231295',4450689,'2670','394',1138643.68,1140276.19,1632.51,266099.13,0.00,0.00,0.00,0.00,0.00),('5','104','896','231295',4450690,'2671','394',1795973.25,1797539.04,1565.79,255223.77,0.00,0.00,0.00,0.00,0.00),('5','104','896','231295',4450691,'2672','394',1073340.59,1074527.35,1186.76,193441.88,0.00,0.00,0.00,0.00,0.00),('5','104','897','231295',4450692,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','231295',4450693,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','231295',4450694,'2675','394',2174334.24,2175957.72,1623.48,264627.24,0.00,0.00,0.00,0.00,0.00),('5','104','896','231295',4450695,'2676','394',1357581.20,1357591.20,10.00,1630.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','231301',4450797,'2669','394',2022338.11,2023670.53,1332.42,217184.46,0.00,0.00,0.00,0.00,0.00),('5','104','895','231301',4450798,'2670','394',1140276.19,1140276.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','231301',4450799,'2671','394',1797539.04,1798211.73,672.69,109648.47,0.00,0.00,0.00,0.00,0.00),('5','104','896','231301',4450800,'2672','394',1074527.35,1075851.56,1324.21,215846.23,0.00,0.00,0.00,0.00,0.00),('5','104','897','231301',4450801,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','231301',4450802,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','231301',4450803,'2675','394',2175957.72,2178263.73,2306.01,375879.63,0.00,0.00,0.00,0.00,0.00),('5','104','896','231301',4450804,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','231411',4452360,'2669','394',2023670.53,2025036.50,1365.97,222653.11,0.00,0.00,0.00,0.00,0.00),('5','104','895','231411',4452361,'2670','394',1140276.19,1141318.07,1041.88,169826.44,0.00,0.00,0.00,0.00,0.00),('5','104','896','231411',4452362,'2671','394',1798211.73,1799161.17,949.44,154758.72,0.00,0.00,0.00,0.00,0.00),('5','104','896','231411',4452363,'2672','394',1075851.56,1076795.67,944.11,153889.93,0.00,0.00,0.00,0.00,0.00),('5','104','897','231411',4452364,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','231411',4452365,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','231411',4452366,'2675','394',2178263.73,2179169.26,905.53,147601.39,0.00,0.00,0.00,0.00,0.00),('5','104','896','231411',4452367,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','231738',4458312,'2669','394',2025036.50,2027001.65,1965.15,320319.45,0.00,0.00,0.00,0.00,0.00),('5','104','895','231738',4458313,'2670','394',1141318.07,1142364.70,1046.63,170600.69,0.00,0.00,0.00,0.00,0.00),('5','104','896','231738',4458314,'2671','394',1799161.17,1801027.63,1866.46,304232.98,0.00,0.00,0.00,0.00,0.00),('5','104','896','231738',4458315,'2672','394',1076795.67,1077445.46,649.79,105915.77,0.00,0.00,0.00,0.00,0.00),('5','104','897','231738',4458316,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','231738',4458317,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','231738',4458318,'2675','394',2179169.26,2179869.06,699.80,114067.40,0.00,0.00,0.00,0.00,0.00),('5','104','896','231738',4458319,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','231981',4462682,'2669','394',2027001.65,2028025.69,1024.04,166918.52,0.00,0.00,0.00,0.00,0.00),('5','104','895','231981',4462683,'2670','394',1142364.70,1143291.45,926.75,151060.25,0.00,0.00,0.00,0.00,0.00),('5','104','896','231981',4462684,'2671','394',1801027.63,1801679.24,651.61,106212.43,0.00,0.00,0.00,0.00,0.00),('5','104','896','231981',4462685,'2672','394',1077445.46,1078871.39,1425.93,232426.59,0.00,0.00,0.00,0.00,0.00),('5','104','897','231981',4462686,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','231981',4462687,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','231981',4462688,'2675','394',2179869.06,2181948.75,2079.69,338989.47,0.00,0.00,0.00,0.00,0.00),('5','104','896','231981',4462689,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','232191',4466471,'2669','394',2028025.69,2029181.48,1155.79,188393.77,0.00,0.00,0.00,0.00,0.00),('5','104','895','232191',4466472,'2670','394',1143291.45,1143838.37,546.92,89147.96,0.00,0.00,0.00,0.00,0.00),('5','104','896','232191',4466473,'2671','394',1801679.24,1803440.98,1761.74,287163.62,0.00,0.00,0.00,0.00,0.00),('5','104','896','232191',4466474,'2672','394',1078871.39,1079307.66,436.27,71112.01,0.00,0.00,0.00,0.00,0.00),('5','104','897','232191',4466475,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','232191',4466476,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','232191',4466477,'2675','394',2181948.75,2183568.98,1620.23,264097.49,0.00,0.00,0.00,0.00,0.00),('5','104','896','232191',4466478,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','232319',4468784,'2669','394',2029181.48,2030111.04,929.56,151518.28,0.00,0.00,0.00,0.00,0.00),('5','104','895','232319',4468785,'2670','394',1143838.37,1145117.85,1279.48,208555.24,0.00,0.00,0.00,0.00,0.00),('5','104','896','232319',4468786,'2671','394',1803440.98,1804593.83,1152.85,187914.55,0.00,0.00,0.00,0.00,0.00),('5','104','896','232319',4468787,'2672','394',1079307.66,1080300.77,993.11,161876.93,0.00,0.00,0.00,0.00,0.00),('5','104','897','232319',4468788,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','232319',4468789,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','232319',4468790,'2675','394',2183568.98,2186172.26,2603.28,424334.64,0.00,0.00,0.00,0.00,0.00),('5','104','896','232319',4468791,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','232644',4474597,'2669','394',2030111.04,2031134.58,1023.54,166837.02,0.00,0.00,0.00,0.00,0.00),('5','104','895','232644',4474598,'2670','394',1145117.85,1146292.59,1174.74,191482.62,0.00,0.00,0.00,0.00,0.00),('5','104','896','232644',4474599,'2671','394',1804593.83,1805762.82,1168.99,190545.37,0.00,0.00,0.00,0.00,0.00),('5','104','896','232644',4474600,'2672','394',1080300.77,1081093.65,792.88,129239.44,0.00,0.00,0.00,0.00,0.00),('5','104','897','232644',4474601,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','232644',4474602,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','232644',4474603,'2675','394',2186172.26,2188150.81,1978.55,322503.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','232644',4474604,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','232964',4480337,'2669','394',2031134.58,2032424.88,1290.30,210318.90,0.00,0.00,0.00,0.00,0.00),('5','104','895','232964',4480338,'2670','394',1146292.59,1147639.09,1346.50,219479.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','232964',4480339,'2671','394',1805762.82,1806947.44,1184.62,193093.06,0.00,0.00,0.00,0.00,0.00),('5','104','896','232964',4480340,'2672','394',1081093.65,1081872.60,778.95,126968.85,0.00,0.00,0.00,0.00,0.00),('5','104','897','232964',4480341,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','232964',4480342,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','232964',4480343,'2675','394',2188150.81,2190411.21,2260.40,368445.20,0.00,0.00,0.00,0.00,0.00),('5','104','896','232964',4480344,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','233175',4484168,'2669','394',2032424.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','233175',4484169,'2670','394',1147639.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','233175',4484170,'2671','394',1806947.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','233175',4484171,'2672','394',1081872.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','233175',4484172,'2673','395',1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','233175',4484173,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','233175',4484174,'2675','394',2190411.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','233175',4484175,'2676','394',1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','233179',4484206,'2669','394',2032424.88,2033522.14,1097.26,178853.38,0.00,0.00,0.00,0.00,0.00),('5','104','895','233179',4484207,'2670','394',1147639.09,1149095.13,1456.04,237334.52,0.00,0.00,0.00,0.00,0.00),('5','104','896','233179',4484208,'2671','394',1806947.44,1808782.69,1835.25,299145.75,0.00,0.00,0.00,0.00,0.00),('5','104','896','233179',4484209,'2672','394',1081872.60,1082860.59,987.99,161042.37,0.00,0.00,0.00,0.00,0.00),('5','104','897','233179',4484210,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','233179',4484211,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','233179',4484212,'2675','394',2190411.21,2192252.47,1841.26,300125.38,0.00,0.00,0.00,0.00,0.00),('5','104','896','233179',4484213,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','233451',4488963,'2669','394',2033522.14,2034699.90,1177.76,191974.88,0.00,0.00,0.00,0.00,0.00),('5','104','895','233451',4488964,'2670','394',1149095.13,1150895.26,1800.13,293421.19,0.00,0.00,0.00,0.00,0.00),('5','104','896','233451',4488965,'2671','394',1808782.69,1810916.13,2133.44,347750.72,0.00,0.00,0.00,0.00,0.00),('5','104','896','233451',4488966,'2672','394',1082860.59,1083870.26,1009.67,164576.21,0.00,0.00,0.00,0.00,0.00),('5','104','897','233451',4488967,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','233451',4488968,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','233451',4488969,'2675','394',2192252.47,2194289.63,2037.16,332057.08,0.00,0.00,0.00,0.00,0.00),('5','104','896','233451',4488970,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','233668',4492949,'2669','394',2034699.90,2035792.12,1092.22,178031.86,0.00,0.00,0.00,0.00,0.00),('5','104','895','233668',4492950,'2670','394',1150895.26,1152069.34,1174.08,191375.04,0.00,0.00,0.00,0.00,0.00),('5','104','896','233668',4492951,'2671','394',1810916.13,1813437.39,2521.26,410965.38,0.00,0.00,0.00,0.00,0.00),('5','104','896','233668',4492952,'2672','394',1083870.26,1084878.61,1008.35,164361.05,0.00,0.00,0.00,0.00,0.00),('5','104','897','233668',4492953,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','233668',4492954,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','233668',4492955,'2675','394',2194289.63,2196695.65,2406.02,392181.26,0.00,0.00,0.00,0.00,0.00),('5','104','896','233668',4492956,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','233883',4496847,'2669','394',2035792.12,2036167.16,375.04,61131.52,0.00,0.00,0.00,0.00,0.00),('5','104','895','233883',4496848,'2670','394',1152069.34,1152742.50,673.16,109725.08,0.00,0.00,0.00,0.00,0.00),('5','104','896','233883',4496849,'2671','394',1813437.39,1815494.98,2057.59,335387.17,0.00,0.00,0.00,0.00,0.00),('5','104','896','233883',4496850,'2672','394',1084878.61,1087509.09,2630.48,428768.24,0.00,0.00,0.00,0.00,0.00),('5','104','897','233883',4496851,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','233883',4496852,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','233883',4496853,'2675','394',2196695.65,2199575.62,2879.97,469435.11,0.00,0.00,0.00,0.00,0.00),('5','104','896','233883',4496854,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','234272',4504133,'2669','394',2036167.16,2038751.71,2584.55,421281.65,0.00,0.00,0.00,0.00,0.00),('5','104','895','234272',4504134,'2670','394',1152742.50,1156782.19,4039.69,658469.47,0.00,0.00,0.00,0.00,0.00),('5','104','896','234272',4504135,'2671','394',1815494.98,1817351.77,1856.79,302656.77,0.00,0.00,0.00,0.00,0.00),('5','104','896','234272',4504136,'2672','394',1087509.09,1089265.41,1756.32,286280.16,0.00,0.00,0.00,0.00,0.00),('5','104','897','234272',4504137,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','234272',4504138,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','234272',4504139,'2675','394',2199575.62,2202796.55,3220.93,525011.59,0.00,0.00,0.00,0.00,0.00),('5','104','896','234272',4504140,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','234375',4505822,'2669','394',2038751.71,2041861.54,3109.83,513121.95,0.00,0.00,0.00,0.00,0.00),('5','104','895','234375',4505823,'2670','394',1156782.19,1158601.41,1819.22,300171.30,0.00,0.00,0.00,0.00,0.00),('5','104','896','234375',4505824,'2671','394',1817351.77,1818316.92,965.15,159249.75,0.00,0.00,0.00,0.00,0.00),('5','104','896','234375',4505825,'2672','394',1089265.41,1092660.87,3395.46,560250.90,0.00,0.00,0.00,0.00,0.00),('5','104','897','234375',4505826,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','234375',4505827,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','234375',4505828,'2675','394',2202796.55,2205583.41,2786.86,459831.90,0.00,0.00,0.00,0.00,0.00),('5','104','896','234375',4505829,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','234621',4510229,'2669','394',2041861.54,2044047.49,2185.95,360681.75,0.00,0.00,0.00,0.00,0.00),('5','104','895','234621',4510230,'2670','394',1158601.41,1161017.40,2415.99,398638.35,0.00,0.00,0.00,0.00,0.00),('5','104','896','234621',4510231,'2671','394',1818316.92,1819940.11,1623.19,267826.35,0.00,0.00,0.00,0.00,0.00),('5','104','896','234621',4510232,'2672','394',1092660.87,1096608.36,3947.49,651335.85,0.00,0.00,0.00,0.00,0.00),('5','104','897','234621',4510233,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','234621',4510234,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','234621',4510235,'2675','394',2205583.41,2208030.70,2447.29,403802.85,0.00,0.00,0.00,0.00,0.00),('5','104','896','234621',4510236,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','235004',4517085,'2669','394',2044047.49,2046984.64,2937.15,484629.75,0.00,0.00,0.00,0.00,0.00),('5','104','895','235004',4517086,'2670','394',1161017.40,1161954.92,937.52,154690.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','235004',4517087,'2671','394',1819940.11,1820260.43,320.32,52852.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','235004',4517088,'2672','394',1096608.36,1100155.67,3547.31,585306.15,0.00,0.00,0.00,0.00,0.00),('5','104','897','235004',4517089,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','235004',4517090,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','235004',4517091,'2675','394',2208030.70,2211266.06,3235.36,533834.40,0.00,0.00,0.00,0.00,0.00),('5','104','896','235004',4517092,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','235187',4520213,'2669','394',2046984.64,2050437.22,3452.58,569675.70,0.00,0.00,0.00,0.00,0.00),('5','104','895','235187',4520214,'2670','394',1161954.92,1165027.92,3073.00,507045.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','235187',4520215,'2671','394',1820260.43,1824089.45,3829.02,631788.30,0.00,0.00,0.00,0.00,0.00),('5','104','896','235187',4520216,'2672','394',1100155.67,1102147.25,1991.58,328610.70,0.00,0.00,0.00,0.00,0.00),('5','104','897','235187',4520217,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','235187',4520218,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','235187',4520219,'2675','394',2211266.06,2211266.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','235187',4520220,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','235490',4525592,'2669','394',2050437.22,2050437.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','235490',4525593,'2670','394',1165027.92,1168966.89,3938.97,649930.05,0.00,0.00,0.00,0.00,0.00),('5','104','896','235490',4525594,'2671','394',1824089.45,1826742.83,2653.38,437807.70,0.00,0.00,0.00,0.00,0.00),('5','104','896','235490',4525595,'2672','394',1102147.25,1104343.20,2195.95,362331.75,0.00,0.00,0.00,0.00,0.00),('5','104','897','235490',4525596,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','235490',4525597,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','235490',4525598,'2675','394',2211266.06,2215826.85,4560.79,752530.35,0.00,0.00,0.00,0.00,0.00),('5','104','896','235490',4525599,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','235563',4526596,'2669','394',2050437.22,2050437.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','235563',4526597,'2670','394',1168966.89,1169467.99,501.10,82681.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','235563',4526598,'2671','394',1826742.83,1829845.49,3102.66,511938.90,0.00,0.00,0.00,0.00,0.00),('5','104','896','235563',4526599,'2672','394',1104343.20,1107855.22,3512.02,579483.30,0.00,0.00,0.00,0.00,0.00),('5','104','897','235563',4526600,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','235563',4526601,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','235563',4526602,'2675','394',2215826.85,2218433.05,2606.20,430023.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','235563',4526603,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','235881',4532285,'2669','394',2050437.22,2050437.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','235881',4532286,'2670','394',1169467.99,1169467.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','235881',4532287,'2671','394',1829845.49,1831410.85,1565.36,258284.40,0.00,0.00,0.00,0.00,0.00),('5','104','896','235881',4532288,'2672','394',1107855.22,1109657.73,1802.51,297414.15,0.00,0.00,0.00,0.00,0.00),('5','104','897','235881',4532289,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','235881',4532290,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','235881',4532291,'2675','394',2218433.05,2218433.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','235881',4532292,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','236203',4538199,'2669','394',2050437.22,2054711.45,4274.23,705247.95,0.00,0.00,0.00,0.00,0.00),('5','104','895','236203',4538200,'2670','394',1169467.99,1169467.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','236203',4538201,'2671','394',1831410.85,1836484.07,5073.22,837081.30,0.00,0.00,0.00,0.00,0.00),('5','104','896','236203',4538202,'2672','394',1109657.73,1112523.74,2866.01,472891.65,0.00,0.00,0.00,0.00,0.00),('5','104','897','236203',4538203,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','236203',4538204,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','236203',4538205,'2675','394',2218433.05,2222102.42,3669.37,605446.05,0.00,0.00,0.00,0.00,0.00),('5','104','896','236203',4538206,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','236227',4538614,'2669','394',2054711.45,2058428.53,3717.08,613318.20,0.00,0.00,0.00,0.00,0.00),('5','104','895','236227',4538615,'2670','394',1169467.99,1169467.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','236227',4538616,'2671','394',1836484.07,1837814.05,1329.98,219446.70,0.00,0.00,0.00,0.00,0.00),('5','104','896','236227',4538617,'2672','394',1112523.74,1115662.38,3138.64,517875.60,0.00,0.00,0.00,0.00,0.00),('5','104','897','236227',4538618,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','236227',4538619,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','236227',4538620,'2675','394',2222102.42,2226318.26,4215.84,695613.60,0.00,0.00,0.00,0.00,0.00),('5','104','896','236227',4538621,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','236617',4545300,'2669','394',2058428.53,2062694.49,4265.96,703883.40,0.00,0.00,0.00,0.00,0.00),('5','104','895','236617',4545301,'2670','394',1169467.99,1169824.06,356.07,58751.55,0.00,0.00,0.00,0.00,0.00),('5','104','896','236617',4545302,'2671','394',1837814.05,1837890.71,76.66,12648.90,0.00,0.00,0.00,0.00,0.00),('5','104','896','236617',4545303,'2672','394',1115662.38,1117878.83,2216.45,365714.25,0.00,0.00,0.00,0.00,0.00),('5','104','897','236617',4545304,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','236617',4545305,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','236617',4545306,'2675','394',2226318.26,2230933.70,4615.44,761547.60,0.00,0.00,0.00,0.00,0.00),('5','104','896','236617',4545307,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','236910',4550399,'2669','394',2062694.49,2064298.43,1603.94,264650.10,0.00,0.00,0.00,0.00,0.00),('5','104','895','236910',4550400,'2670','394',1169824.06,1171748.16,1924.10,317476.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','236910',4550401,'2671','394',1837890.71,1837890.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','236910',4550402,'2672','394',1117878.83,1117878.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','236910',4550403,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','236910',4550404,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','236910',4550405,'2675','394',2230933.70,2232738.14,1804.44,297732.60,0.00,0.00,0.00,0.00,0.00),('5','104','896','236910',4550406,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','237024',4552365,'2669','394',2064298.43,2065272.10,973.67,160655.55,0.00,0.00,0.00,0.00,0.00),('5','104','895','237024',4552366,'2670','394',1171748.16,1172602.43,854.27,140954.55,0.00,0.00,0.00,0.00,0.00),('5','104','896','237024',4552367,'2671','394',1837890.71,1837890.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','237024',4552368,'2672','394',1117878.83,1117878.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','237024',4552369,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','237024',4552370,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','237024',4552371,'2675','394',2232738.14,2233666.24,928.10,153136.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','237024',4552372,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','237338',4558194,'2669','394',2065272.10,2071190.48,5918.38,976532.70,0.00,0.00,0.00,0.00,0.00),('5','104','895','237338',4558195,'2670','394',1172602.43,1176271.46,3669.03,605389.95,0.00,0.00,0.00,0.00,0.00),('5','104','896','237338',4558196,'2671','394',1837890.71,1837890.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','237338',4558197,'2672','394',1117878.83,1117878.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','237338',4558198,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','237338',4558199,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','237338',4558200,'2675','394',2233666.24,2237745.21,4078.97,673030.05,0.00,0.00,0.00,0.00,0.00),('5','104','896','237338',4558201,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','237445',4560023,'2669','394',2071190.48,2076460.67,5270.19,869581.35,0.00,0.00,0.00,0.00,0.00),('5','104','895','237445',4560024,'2670','394',1176271.46,1176798.76,527.30,87004.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','237445',4560025,'2671','394',1837890.71,1837890.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','237445',4560026,'2672','394',1117878.83,1117878.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','237445',4560027,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','237445',4560028,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','237445',4560029,'2675','394',2237745.21,2242250.35,4505.14,743348.10,0.00,0.00,0.00,0.00,0.00),('5','104','896','237445',4560030,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','237674',4563838,'2669','394',2076460.67,2077635.14,1174.47,193787.55,0.00,0.00,0.00,0.00,0.00),('5','104','895','237674',4563839,'2670','394',1176798.76,1177945.81,1147.05,189263.25,0.00,0.00,0.00,0.00,0.00),('5','104','896','237674',4563840,'2671','394',1837890.71,1837890.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','237674',4563841,'2672','394',1117878.83,1117878.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','237674',4563842,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','237674',4563843,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','237674',4563844,'2675','394',2242250.35,2243234.45,984.10,162376.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','237674',4563845,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','238098',4570959,'2669','394',2077635.14,2077635.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','238098',4570960,'2670','394',1177945.81,1177945.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','238098',4570961,'2671','394',1837890.71,1837890.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','238098',4570962,'2672','394',1117878.83,1117878.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','238098',4570963,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','238098',4570964,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','238098',4570965,'2675','394',2243234.45,2243234.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','238098',4570966,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','238230',4573108,'2669','394',2077635.14,2077635.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','238230',4573109,'2670','394',1177945.81,1177945.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','238230',4573110,'2671','394',1837890.71,1837890.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','238230',4573111,'2672','394',1117878.83,1117878.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','238230',4573112,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','238230',4573113,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','238230',4573114,'2675','394',2243234.45,2243234.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','238230',4573115,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','238427',4576534,'2669','394',2077635.14,2081615.00,3979.86,656676.90,0.00,0.00,0.00,0.00,0.00),('5','104','895','238427',4576535,'2670','394',1177945.81,1181843.72,3897.91,643155.15,0.00,0.00,0.00,0.00,0.00),('5','104','896','238427',4576536,'2671','394',1837890.71,1837890.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','238427',4576537,'2672','394',1117878.83,1117878.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','238427',4576538,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','238427',4576539,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','238427',4576540,'2675','394',2243234.45,2247282.82,4048.37,667981.05,0.00,0.00,0.00,0.00,0.00),('5','104','896','238427',4576541,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','238729',4581564,'2669','394',2081615.00,2086496.50,4881.50,805447.50,0.00,0.00,0.00,0.00,0.00),('5','104','895','238729',4581565,'2670','394',1181843.72,1184772.20,2928.48,483199.20,0.00,0.00,0.00,0.00,0.00),('5','104','896','238729',4581566,'2671','394',1837890.71,1838092.90,202.19,33361.35,0.00,0.00,0.00,0.00,0.00),('5','104','896','238729',4581567,'2672','394',1117878.83,1117979.11,100.28,16546.20,0.00,0.00,0.00,0.00,0.00),('5','104','897','238729',4581568,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','238729',4581569,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','238729',4581570,'2675','394',2247282.82,2252643.15,5360.33,884454.45,0.00,0.00,0.00,0.00,0.00),('5','104','896','238729',4581571,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','238920',4585086,'2669','394',2086496.50,2087754.22,1257.72,207523.80,0.00,0.00,0.00,0.00,0.00),('5','104','895','238920',4585087,'2670','394',1184772.20,1185075.32,303.12,50014.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','238920',4585088,'2671','394',1838092.90,1843031.68,4938.78,814898.70,0.00,0.00,0.00,0.00,0.00),('5','104','896','238920',4585089,'2672','394',1117979.11,1122613.80,4634.69,764723.85,0.00,0.00,0.00,0.00,0.00),('5','104','897','238920',4585090,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','238920',4585091,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','238920',4585092,'2675','394',2252643.15,2252643.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','238920',4585093,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','239134',4588871,'2669','394',2087754.22,2087754.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','239134',4588872,'2670','394',1185075.32,1185075.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','239134',4588873,'2671','394',1843031.68,1845548.10,2516.42,415209.30,0.00,0.00,0.00,0.00,0.00),('5','104','896','239134',4588874,'2672','394',1122613.80,1125250.56,2636.76,435065.40,0.00,0.00,0.00,0.00,0.00),('5','104','897','239134',4588875,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','239134',4588876,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','239134',4588877,'2675','394',2252643.15,2252643.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','239134',4588878,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','239376',4592931,'2669','394',2087754.22,2092757.36,5003.14,825518.10,0.00,0.00,0.00,0.00,0.00),('5','104','895','239376',4592932,'2670','394',1185075.32,1187891.24,2815.92,464626.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','239376',4592933,'2671','394',1845548.10,1845548.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','239376',4592934,'2672','394',1125250.56,1126471.23,1220.67,201410.55,0.00,0.00,0.00,0.00,0.00),('5','104','897','239376',4592935,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','239376',4592936,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','239376',4592937,'2675','394',2252643.15,2256980.61,4337.46,715680.90,0.00,0.00,0.00,0.00,0.00),('5','104','896','239376',4592938,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','239673',4598146,'2669','394',2092757.36,2097489.48,4732.12,780799.80,0.00,0.00,0.00,0.00,0.00),('5','104','895','239673',4598147,'2670','394',1187891.24,1187891.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','239673',4598148,'2671','394',1845548.10,1849531.97,3983.87,657338.55,0.00,0.00,0.00,0.00,0.00),('5','104','896','239673',4598149,'2672','394',1126471.23,1127955.73,1484.50,244942.50,0.00,0.00,0.00,0.00,0.00),('5','104','897','239673',4598150,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','239673',4598151,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','239673',4598152,'2675','394',2256980.61,2260905.90,3925.29,647672.85,0.00,0.00,0.00,0.00,0.00),('5','104','896','239673',4598153,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','239879',4601658,'2669','394',2097489.48,2097489.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','239879',4601659,'2670','394',1187891.24,1189826.86,1935.62,319377.30,0.00,0.00,0.00,0.00,0.00),('5','104','896','239879',4601660,'2671','394',1849531.97,1854943.00,5411.03,892819.95,0.00,0.00,0.00,0.00,0.00),('5','104','896','239879',4601661,'2672','394',1127955.73,1133928.20,5972.47,985457.55,0.00,0.00,0.00,0.00,0.00),('5','104','897','239879',4601662,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','239879',4601663,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','239879',4601664,'2675','394',2260905.90,2260905.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','239879',4601665,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','240058',4604779,'2669','394',2097489.48,2097489.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','240058',4604780,'2670','394',1189826.86,1189826.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','240058',4604781,'2671','394',1854943.00,1856862.56,1919.56,316727.40,0.00,0.00,0.00,0.00,0.00),('5','104','896','240058',4604782,'2672','394',1133928.20,1136139.74,2211.54,364904.10,0.00,0.00,0.00,0.00,0.00),('5','104','897','240058',4604783,'2673','395',1360729.29,1360729.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','240058',4604784,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','240058',4604785,'2675','394',2260905.90,2260905.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','240058',4604786,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','240258',4608247,'2669','394',2097489.48,2103950.30,6460.82,1066035.30,0.00,0.00,0.00,0.00,0.00),('5','104','895','240258',4608248,'2670','394',1189826.86,1189826.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','240258',4608249,'2671','394',1856862.56,1861755.59,4893.03,807349.95,0.00,0.00,0.00,0.00,0.00),('5','104','896','240258',4608250,'2672','394',1136139.74,1139869.01,3729.27,615329.55,0.00,0.00,0.00,0.00,0.00),('5','104','897','240258',4608251,'2673','395',1360729.29,1361568.26,838.97,289444.65,0.00,0.00,0.00,0.00,0.00),('5','104','898','240258',4608252,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','240258',4608253,'2675','394',2260905.90,2266048.14,5142.24,848469.60,0.00,0.00,0.00,0.00,0.00),('5','104','896','240258',4608254,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','240530',4612639,'2669','394',2103950.30,2104068.49,118.19,19501.35,0.00,0.00,0.00,0.00,0.00),('5','104','895','240530',4612640,'2670','394',1189826.86,1195725.85,5898.99,973333.35,0.00,0.00,0.00,0.00,0.00),('5','104','896','240530',4612641,'2671','394',1861755.59,1866674.29,4918.70,811585.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','240530',4612642,'2672','394',1139869.01,1144316.15,4447.14,733778.10,0.00,0.00,0.00,0.00,0.00),('5','104','897','240530',4612643,'2673','395',1361568.26,1361645.15,76.89,26527.05,0.00,0.00,0.00,0.00,0.00),('5','104','898','240530',4612644,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','240530',4612645,'2675','394',2266048.14,2266414.85,366.71,60507.15,0.00,0.00,0.00,0.00,0.00),('5','104','896','240530',4612646,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','240738',4615707,'2669','394',2104068.49,2109146.78,5078.29,837917.85,0.00,0.00,0.00,0.00,0.00),('5','104','895','240738',4615708,'2670','394',1195725.85,1199958.37,4232.52,698365.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','240738',4615709,'2671','394',1866674.29,1866674.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','240738',4615710,'2672','394',1144316.15,1144316.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','240738',4615711,'2673','395',1361645.15,1362290.83,645.68,222759.60,0.00,0.00,0.00,0.00,0.00),('5','104','898','240738',4615712,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','240738',4615713,'2675','394',2266414.85,2270943.36,4528.51,747204.15,0.00,0.00,0.00,0.00,0.00),('5','104','896','240738',4615714,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','241091',4622116,'2669','394',2109146.78,2114949.31,5802.53,957417.45,0.00,0.00,0.00,0.00,0.00),('5','104','895','241091',4622117,'2670','394',1199958.37,1203484.90,3526.53,581877.45,0.00,0.00,0.00,0.00,0.00),('5','104','896','241091',4622118,'2671','394',1866674.29,1866674.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','241091',4622119,'2672','394',1144316.15,1144316.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','241091',4622120,'2673','395',1362290.83,1362643.86,353.03,121795.35,0.00,0.00,0.00,0.00,0.00),('5','104','898','241091',4622121,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','241091',4622122,'2675','394',2270943.36,2275798.77,4855.41,801142.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','241091',4622123,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','241331',4626233,'2669','394',2114949.31,2121311.50,6362.19,1049761.35,0.00,0.00,0.00,0.00,0.00),('5','104','895','241331',4626234,'2670','394',1203484.90,1206811.67,3326.77,548917.05,0.00,0.00,0.00,0.00,0.00),('5','104','896','241331',4626235,'2671','394',1866674.29,1866674.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','241331',4626236,'2672','394',1144316.15,1144316.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','241331',4626237,'2673','395',1362643.86,1363315.45,671.59,231698.55,0.00,0.00,0.00,0.00,0.00),('5','104','898','241331',4626238,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','241331',4626239,'2675','394',2275798.77,2280887.75,5088.98,839681.70,0.00,0.00,0.00,0.00,0.00),('5','104','896','241331',4626240,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','241543',4629880,'2669','394',2121311.50,2122890.41,1558.91,257220.15,0.00,0.00,20.00,0.00,0.00),('5','104','895','241543',4629881,'2670','394',1206811.67,1208341.93,1500.26,247542.90,0.00,0.00,30.00,0.00,0.00),('5','104','896','241543',4629882,'2671','394',1866674.29,1866674.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','241543',4629883,'2672','394',1144316.15,1144316.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','241543',4629884,'2673','395',1363315.45,1363724.43,408.98,141098.10,0.00,0.00,0.00,0.00,0.00),('5','104','898','241543',4629885,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','241543',4629886,'2675','394',2280887.75,2280930.15,42.40,6996.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','241543',4629887,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','241821',4634694,'2669','394',2122890.41,2122890.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','241821',4634695,'2670','394',1208341.93,1208341.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','241821',4634696,'2671','394',1866674.29,1866674.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','241821',4634697,'2672','394',1144316.15,1144316.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','241821',4634698,'2673','395',1363724.43,1364667.47,943.04,325348.80,0.00,0.00,0.00,0.00,0.00),('5','104','898','241821',4634699,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','241821',4634700,'2675','394',2280930.15,2280930.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','241821',4634701,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','242034',4638382,'2669','394',2122890.41,2122890.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','242034',4638383,'2670','394',1208341.93,1208341.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','242034',4638384,'2671','394',1866674.29,1866674.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','242034',4638385,'2672','394',1144316.15,1144316.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','242034',4638386,'2673','395',1364667.47,1366576.82,1909.35,658725.75,0.00,0.00,0.00,0.00,0.00),('5','104','898','242034',4638387,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','242034',4638388,'2675','394',2280930.15,2280930.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','242034',4638389,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','242364',4644433,'2669','394',2122890.41,2122890.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','242364',4644434,'2670','394',1208341.93,1208341.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','242364',4644435,'2671','394',1866674.29,1866674.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','242364',4644436,'2672','394',1144316.15,1144316.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','242364',4644437,'2673','395',1366576.82,1368748.71,2171.89,749302.05,0.00,0.00,0.00,0.00,0.00),('5','104','898','242364',4644438,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','242364',4644439,'2675','394',2280930.15,2280930.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','242364',4644440,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','242447',4645623,'2669','394',2122890.41,2122890.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','242447',4645624,'2670','394',1208341.93,1208341.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','242447',4645625,'2671','394',1866674.29,1866674.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','242447',4645626,'2672','394',1144316.15,1144316.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','242447',4645627,'2673','395',1368748.71,1371451.35,2702.64,932410.80,0.00,0.00,0.00,0.00,0.00),('5','104','898','242447',4645628,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','242447',4645629,'2675','394',2280930.15,2280930.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','242447',4645630,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','242784',4651614,'2669','394',2122890.41,2122890.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','242784',4651615,'2670','394',1208341.93,1208341.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','242784',4651616,'2671','394',1866674.29,1866674.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','242784',4651617,'2672','394',1144316.15,1144316.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','242784',4651618,'2673','395',1371451.35,1376107.34,4655.99,1606316.55,0.00,0.00,0.00,0.00,0.00),('5','104','898','242784',4651619,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','242784',4651620,'2675','394',2280930.15,2280930.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','242784',4651621,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','242996',4655186,'2669','394',2122890.41,2122890.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','242996',4655187,'2670','394',1208341.93,1208341.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','242996',4655188,'2671','394',1866674.29,1866674.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','242996',4655189,'2672','394',1144316.15,1144316.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','242996',4655190,'2673','395',1376107.34,1377937.73,1830.39,631484.55,0.00,0.00,0.00,0.00,0.00),('5','104','898','242996',4655191,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','242996',4655192,'2675','394',2280930.15,2280930.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','242996',4655193,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','243256',4659815,'2669','394',2122890.41,2122890.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','243256',4659816,'2670','394',1208341.93,1208341.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','243256',4659817,'2671','394',1866674.29,1866674.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','243256',4659818,'2672','394',1144316.15,1144316.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','243256',4659819,'2673','395',1377937.73,1379426.40,1488.67,513591.15,0.00,0.00,0.00,0.00,0.00),('5','104','898','243256',4659820,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','243256',4659821,'2675','394',2280930.15,2280930.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','243256',4659822,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','243786',4669305,'2669','394',2122890.41,2122890.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','243786',4669306,'2670','394',1208341.93,1208341.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','243786',4669307,'2671','394',1866674.29,1866674.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','243786',4669308,'2672','394',1144316.15,1144316.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','243786',4669309,'2673','395',1379426.40,1381287.37,1860.97,642034.65,0.00,0.00,0.00,0.00,0.00),('5','104','898','243786',4669310,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','243786',4669311,'2675','394',2280930.15,2280930.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','243786',4669312,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','244000',4672967,'2669','394',2122890.41,2122890.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','244000',4672968,'2670','394',1208341.93,1208341.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','244000',4672969,'2671','394',1866674.29,1866674.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','244000',4672970,'2672','394',1144316.15,1144316.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','244000',4672971,'2673','395',1381287.37,1383277.41,1990.04,686563.80,0.00,0.00,0.00,0.00,0.00),('5','104','898','244000',4672972,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','244000',4672973,'2675','394',2280930.15,2280930.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','244000',4672974,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','244007',4673125,'2669','394',2122890.41,2122890.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','244007',4673126,'2670','394',1208341.93,1208341.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','244007',4673127,'2671','394',1866674.29,1866674.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','244007',4673128,'2672','394',1144316.15,1144316.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','244007',4673129,'2673','395',1383277.41,1383881.69,604.28,208476.60,0.00,0.00,0.00,0.00,0.00),('5','104','898','244007',4673130,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','244007',4673131,'2675','394',2280930.15,2280930.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','244007',4673132,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','244152',4675391,'2669','394',2122890.41,2122890.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','244152',4675392,'2670','394',1208341.93,1208341.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','244152',4675393,'2671','394',1866674.29,1866674.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','244152',4675394,'2672','394',1144316.15,1144316.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','244152',4675395,'2673','395',1383881.69,1386657.17,2775.48,957540.60,0.00,0.00,0.00,0.00,0.00),('5','104','898','244152',4675396,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','244152',4675397,'2675','394',2280930.15,2280930.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','244152',4675398,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','244358',4678837,'2669','394',2122890.41,2127144.04,4253.63,701848.95,0.00,0.00,0.00,0.00,0.00),('5','104','895','244358',4678838,'2670','394',1208341.93,1211532.25,3190.32,526402.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','244358',4678839,'2671','394',1866674.29,1866674.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','244358',4678840,'2672','394',1144316.15,1144316.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','244358',4678841,'2673','395',1386657.17,1387824.28,1167.11,402652.95,0.00,0.00,0.00,0.00,0.00),('5','104','898','244358',4678842,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','244358',4678843,'2675','394',2280930.15,2285284.06,4353.91,718395.15,0.00,0.00,0.00,0.00,0.00),('5','104','896','244358',4678844,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','244698',4684927,'2669','394',2127144.04,2130914.27,3750.23,618787.95,0.00,0.00,20.00,0.00,0.00),('5','104','895','244698',4684928,'2670','394',1211532.25,1213226.14,1673.89,276191.85,0.00,0.00,20.00,0.00,0.00),('5','104','896','244698',4684929,'2671','394',1866674.29,1866674.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','244698',4684930,'2672','394',1144316.15,1144316.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','244698',4684931,'2673','395',1387824.28,1389140.30,1316.02,454026.90,0.00,0.00,0.00,0.00,0.00),('5','104','898','244698',4684932,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','244698',4684933,'2675','394',2285284.06,2288815.80,3501.74,577787.10,0.00,0.00,30.00,0.00,0.00),('5','104','896','244698',4684934,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','244840',4687251,'2669','394',2130914.27,2134033.30,3119.03,514639.95,0.00,0.00,0.00,0.00,0.00),('5','104','895','244840',4687252,'2670','394',1213226.14,1216185.00,2958.86,488211.90,0.00,0.00,0.00,0.00,0.00),('5','104','896','244840',4687253,'2671','394',1866674.29,1866674.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','244840',4687254,'2672','394',1144316.15,1144316.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','244840',4687255,'2673','395',1389140.30,1389755.95,615.65,212399.25,0.00,0.00,0.00,0.00,0.00),('5','104','898','244840',4687256,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','244840',4687257,'2675','394',2288815.80,2291830.11,3014.31,497361.15,0.00,0.00,0.00,0.00,0.00),('5','104','896','244840',4687258,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','245187',4693567,'2669','394',2134033.30,2134033.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','245187',4693568,'2670','394',1216185.00,1216185.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','245187',4693569,'2671','394',1866674.29,1866674.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','245187',4693570,'2672','394',1144316.15,1144316.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','245187',4693571,'2673','395',1389755.95,1390501.18,745.23,257104.35,0.00,0.00,0.00,0.00,0.00),('5','104','898','245187',4693572,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','245187',4693573,'2675','394',2291830.11,2291830.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','245187',4693574,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','245350',4696246,'2669','394',2134033.30,2134033.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','245350',4696247,'2670','394',1216185.00,1216185.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','245350',4696248,'2671','394',1866674.29,1866674.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','245350',4696249,'2672','394',1144316.15,1144316.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','245350',4696250,'2673','395',1390501.18,1391098.73,597.55,206154.75,0.00,0.00,0.00,0.00,0.00),('5','104','898','245350',4696251,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','245350',4696252,'2675','394',2291830.11,2291830.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','245350',4696253,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','245643',4701522,'2669','394',2134033.30,2134033.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','245643',4701523,'2670','394',1216185.00,1216185.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','245643',4701524,'2671','394',1866674.29,1866674.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','245643',4701525,'2672','394',1144316.15,1144316.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','245643',4701526,'2673','395',1391098.73,1391300.76,202.03,69700.35,0.00,0.00,0.00,0.00,0.00),('5','104','898','245643',4701527,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','245643',4701528,'2675','394',2291830.11,2291830.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','245643',4701529,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','245952',4705976,'2669','394',2134033.30,2134033.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','245952',4705977,'2670','394',1216185.00,1216185.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','245952',4705978,'2671','394',1866674.29,1866674.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','245952',4705979,'2672','394',1144316.15,1144316.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','245952',4705980,'2673','395',1391300.76,1391300.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','245952',4705981,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','245952',4705982,'2675','394',2291830.11,2291830.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','245952',4705983,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','246161',4709812,'2669','394',2134033.30,2134207.70,174.40,28776.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','246161',4709813,'2670','394',1216185.00,1216396.75,211.75,34938.75,0.00,0.00,0.00,0.00,0.00),('5','104','896','246161',4709814,'2671','394',1866674.29,1866674.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','246161',4709815,'2672','394',1144316.15,1144316.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','246161',4709816,'2673','395',1391300.76,1391300.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','246161',4709817,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','246161',4709818,'2675','394',2291830.11,2292111.04,280.93,46353.45,0.00,0.00,0.00,0.00,0.00),('5','104','896','246161',4709819,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','246546',4716148,'2669','394',2134207.70,2137670.72,3443.02,568098.30,0.00,0.00,20.00,0.00,0.00),('5','104','895','246546',4716149,'2670','394',1216396.75,1216396.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','246546',4716150,'2671','394',1866674.29,1870141.51,3447.22,568791.30,0.00,0.00,20.00,0.00,0.00),('5','104','896','246546',4716151,'2672','394',1144316.15,1145559.28,1223.13,201816.45,0.00,0.00,20.00,0.00,0.00),('5','104','897','246546',4716152,'2673','395',1391300.76,1391300.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','246546',4716153,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','246546',4716154,'2675','394',2292111.04,2295772.28,3641.24,600804.60,0.00,0.00,20.00,0.00,0.00),('5','104','896','246546',4716155,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','246551',4716258,'2669','394',2137670.72,2141350.36,3679.64,607140.60,0.00,0.00,0.00,0.00,0.00),('5','104','895','246551',4716259,'2670','394',1216396.75,1219519.10,3122.35,515187.75,0.00,0.00,0.00,0.00,0.00),('5','104','896','246551',4716260,'2671','394',1870141.51,1872323.24,2181.73,359985.45,0.00,0.00,0.00,0.00,0.00),('5','104','896','246551',4716261,'2672','394',1145559.28,1147245.71,1686.43,278260.95,0.00,0.00,0.00,0.00,0.00),('5','104','897','246551',4716262,'2673','395',1391300.76,1391300.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','246551',4716263,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','246551',4716264,'2675','394',2295772.28,2299345.61,3573.33,589599.45,0.00,0.00,0.00,0.00,0.00),('5','104','896','246551',4716265,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','246787',4720318,'2669','394',2141350.36,2141350.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','246787',4720319,'2670','394',1219519.10,1219519.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','246787',4720320,'2671','394',1872323.24,1876958.03,4604.79,759790.35,0.00,0.00,30.00,0.00,0.00),('5','104','896','246787',4720321,'2672','394',1147245.71,1152019.63,4753.92,784396.80,0.00,0.00,20.00,0.00,0.00),('5','104','897','246787',4720322,'2673','395',1391300.76,1391404.70,103.94,35859.30,0.00,0.00,0.00,0.00,0.00),('5','104','898','246787',4720323,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','246787',4720324,'2675','394',2299345.61,2299345.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','246787',4720325,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','247484',4732537,'2669','394',2141350.36,2141350.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','247484',4732538,'2670','394',1219519.10,1219519.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','247484',4732539,'2671','394',1876958.03,1876958.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','247484',4732540,'2672','394',1152019.63,1152019.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','247484',4732541,'2673','395',1391404.70,1394358.13,2953.43,1018933.35,0.00,0.00,0.00,0.00,0.00),('5','104','898','247484',4732542,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','247484',4732543,'2675','394',2299345.61,2299345.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','247484',4732544,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','247489',4732568,'2669','394',2141350.36,2141350.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','247489',4732569,'2670','394',1219519.10,1219519.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','247489',4732570,'2671','394',1876958.03,1876958.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','247489',4732571,'2672','394',1152019.63,1152019.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','247489',4732572,'2673','395',1394358.13,1394921.57,563.44,194386.80,0.00,0.00,0.00,0.00,0.00),('5','104','898','247489',4732573,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','247489',4732574,'2675','394',2299345.61,2299345.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','247489',4732575,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','247490',4732576,'2669','394',2141350.36,2141350.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','247490',4732577,'2670','394',1219519.10,1219519.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','247490',4732578,'2671','394',1876958.03,1876958.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','247490',4732579,'2672','394',1152019.63,1152019.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','247490',4732580,'2673','395',1394921.57,1396543.77,1622.20,559659.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','247490',4732581,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','247490',4732582,'2675','394',2299345.61,2299345.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','247490',4732583,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','247731',4736656,'2669','394',2141350.36,2141350.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','247731',4736657,'2670','394',1219519.10,1219519.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','247731',4736658,'2671','394',1876958.03,1876958.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','247731',4736659,'2672','394',1152019.63,1152019.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','247731',4736660,'2673','395',1396543.77,1398728.16,2184.39,753614.55,0.00,0.00,0.00,0.00,0.00),('5','104','898','247731',4736661,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','247731',4736662,'2675','394',2299345.61,2299345.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','247731',4736663,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','248126',4743503,'2669','394',2141350.36,2144337.91,2987.55,492945.75,0.00,0.00,0.00,0.00,0.00),('5','104','895','248126',4743504,'2670','394',1219519.10,1222009.58,2490.48,410929.20,0.00,0.00,0.00,0.00,0.00),('5','104','896','248126',4743505,'2671','394',1876958.03,1876958.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','248126',4743506,'2672','394',1152019.63,1152019.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','248126',4743507,'2673','395',1398728.16,1400016.32,1288.16,444415.20,0.00,0.00,0.00,0.00,0.00),('5','104','898','248126',4743508,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','248126',4743509,'2675','394',2299345.61,2302712.96,3367.35,555612.75,0.00,0.00,0.00,0.00,0.00),('5','104','896','248126',4743510,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','248282',4746042,'2669','394',2144337.91,2148001.51,3663.60,604494.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','248282',4746043,'2670','394',1222009.58,1226379.28,4369.70,721000.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','248282',4746044,'2671','394',1876958.03,1876958.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','248282',4746045,'2672','394',1152019.63,1152019.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','248282',4746046,'2673','395',1400016.32,1401681.59,1665.27,574518.15,0.00,0.00,0.00,0.00,0.00),('5','104','898','248282',4746047,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','248282',4746048,'2675','394',2302712.96,2307487.05,4774.09,787724.85,0.00,0.00,0.00,0.00,0.00),('5','104','896','248282',4746049,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','248464',4748760,'2669','394',2148001.51,2149675.05,1673.54,276134.10,0.00,0.00,0.00,0.00,0.00),('5','104','895','248464',4748761,'2670','394',1226379.28,1227994.07,1614.79,266440.35,0.00,0.00,0.00,0.00,0.00),('5','104','896','248464',4748762,'2671','394',1876958.03,1876958.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','248464',4748763,'2672','394',1152019.63,1152019.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','248464',4748764,'2673','395',1401681.59,1402478.45,796.86,274916.70,0.00,0.00,0.00,0.00,0.00),('5','104','898','248464',4748765,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','248464',4748766,'2675','394',2307487.05,2309273.40,1786.35,294747.75,0.00,0.00,0.00,0.00,0.00),('5','104','896','248464',4748767,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','248712',4753210,'2669','394',2149675.05,2149675.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','248712',4753211,'2670','394',1227994.07,1227994.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','248712',4753212,'2671','394',1876958.03,1876958.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','248712',4753213,'2672','394',1152019.63,1152019.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','248712',4753214,'2673','395',1402478.45,1403037.41,558.96,192841.20,0.00,0.00,0.00,0.00,0.00),('5','104','898','248712',4753215,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','248712',4753216,'2675','394',2309273.40,2309273.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','248712',4753217,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','248953',4757131,'2669','394',2149675.05,2149675.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','248953',4757132,'2670','394',1227994.07,1227994.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','248953',4757133,'2671','394',1876958.03,1876958.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','248953',4757134,'2672','394',1152019.63,1152019.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','248953',4757135,'2673','395',1403037.41,1403494.63,457.22,157740.90,0.00,0.00,0.00,0.00,0.00),('5','104','898','248953',4757136,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','248953',4757137,'2675','394',2309273.40,2309273.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','248953',4757138,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','249253',4762433,'2669','394',2149675.05,2149675.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','249253',4762434,'2670','394',1227994.07,1227994.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','249253',4762435,'2671','394',1876958.03,1876958.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','249253',4762436,'2672','394',1152019.63,1152019.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','249253',4762437,'2673','395',1403494.63,1404006.90,512.27,176733.15,0.00,0.00,0.00,0.00,0.00),('5','104','898','249253',4762438,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','249253',4762439,'2675','394',2309273.40,2309273.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','249253',4762440,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','249437',4765413,'2669','394',2149675.05,2149675.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','249437',4765414,'2670','394',1227994.07,1227994.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','249437',4765415,'2671','394',1876958.03,1876958.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','249437',4765416,'2672','394',1152019.63,1152019.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','249437',4765417,'2673','395',1404006.90,1404422.02,415.12,143216.40,0.00,0.00,0.00,0.00,0.00),('5','104','898','249437',4765418,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','249437',4765419,'2675','394',2309273.40,2309273.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','249437',4765420,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','249684',4769518,'2669','394',2149675.05,2149675.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','249684',4769519,'2670','394',1227994.07,1227994.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','249684',4769520,'2671','394',1876958.03,1876958.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','249684',4769521,'2672','394',1152019.63,1152019.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','249684',4769522,'2673','395',1404422.02,1404731.74,309.72,106853.40,0.00,0.00,0.00,0.00,0.00),('5','104','898','249684',4769523,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','249684',4769524,'2675','394',2309273.40,2309273.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','249684',4769525,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','249972',4774605,'2669','394',2149675.05,2149675.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','249972',4774606,'2670','394',1227994.07,1227994.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','249972',4774607,'2671','394',1876958.03,1876958.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','249972',4774608,'2672','394',1152019.63,1152019.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','249972',4774609,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','249972',4774610,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','249972',4774611,'2675','394',2309273.40,2309273.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','249972',4774612,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','250307',4780290,'2669','394',2149675.05,2149675.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','250307',4780291,'2670','394',1227994.07,1227994.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','250307',4780292,'2671','394',1876958.03,1877499.81,541.78,89393.70,0.00,0.00,0.00,0.00,0.00),('5','104','896','250307',4780293,'2672','394',1152019.63,1152540.71,521.08,85978.20,0.00,0.00,0.00,0.00,0.00),('5','104','897','250307',4780294,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','250307',4780295,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','250307',4780296,'2675','394',2309273.40,2309273.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','250307',4780297,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','250533',4783897,'2669','394',2149675.05,2149675.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','250533',4783898,'2670','394',1227994.07,1230113.72,2109.65,348092.25,0.00,0.00,10.00,0.00,0.00),('5','104','896','250533',4783899,'2671','394',1877499.81,1878850.57,1340.76,221225.40,0.00,0.00,10.00,0.00,0.00),('5','104','896','250533',4783900,'2672','394',1152540.71,1154989.01,2428.30,400669.50,0.00,0.00,20.00,0.00,0.00),('5','104','897','250533',4783901,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','250533',4783902,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','250533',4783903,'2675','394',2309273.40,2311776.72,2473.32,408097.80,0.00,0.00,30.00,0.00,0.00),('5','104','896','250533',4783904,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','250666',4786020,'2669','394',2149675.05,2149675.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','250666',4786021,'2670','394',1230113.72,1232460.64,2346.92,387241.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','250666',4786022,'2671','394',1878850.57,1881217.69,2367.12,390574.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','250666',4786023,'2672','394',1154989.01,1158771.26,3782.25,624071.25,0.00,0.00,0.00,0.00,0.00),('5','104','897','250666',4786024,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','250666',4786025,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','250666',4786026,'2675','394',2311776.72,2313829.36,2052.64,338685.60,0.00,0.00,0.00,0.00,0.00),('5','104','896','250666',4786027,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','250956',4791426,'2669','394',2149675.05,2149675.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','250956',4791427,'2670','394',1232460.64,1237548.79,5068.15,836244.75,0.00,0.00,20.00,0.00,0.00),('5','104','896','250956',4791428,'2671','394',1881217.69,1882458.86,1231.17,203143.05,0.00,0.00,10.00,0.00,0.00),('5','104','896','250956',4791429,'2672','394',1158771.26,1160173.64,1392.38,229742.70,0.00,0.00,10.00,0.00,0.00),('5','104','897','250956',4791430,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','250956',4791431,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','250956',4791432,'2675','394',2313829.36,2318856.75,5007.39,826219.35,0.00,0.00,20.00,0.00,0.00),('5','104','896','250956',4791433,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','251233',4796201,'2669','394',2149675.05,2149851.83,176.78,29168.70,0.00,0.00,0.00,0.00,0.00),('5','104','895','251233',4796202,'2670','394',1237548.79,1241574.00,4025.21,664159.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','251233',4796203,'2671','394',1882458.86,1882458.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','251233',4796204,'2672','394',1160173.64,1160173.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','251233',4796205,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','251233',4796206,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','251233',4796207,'2675','394',2318856.75,2321407.07,2550.32,420802.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','251233',4796208,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','251485',4800585,'2669','394',2149851.83,2149851.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','251485',4800586,'2670','394',1241574.00,1246338.21,4744.21,782794.65,0.00,0.00,20.00,0.00,0.00),('5','104','896','251485',4800587,'2671','394',1882458.86,1886003.50,3524.64,581565.60,0.00,0.00,20.00,0.00,0.00),('5','104','896','251485',4800588,'2672','394',1160173.64,1165544.28,5350.64,882855.60,0.00,0.00,20.00,0.00,0.00),('5','104','897','251485',4800589,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','251485',4800590,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','251485',4800591,'2675','394',2321407.07,2322650.30,1223.23,201832.95,0.00,0.00,20.00,0.00,0.00),('5','104','896','251485',4800592,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','251613',4802653,'2669','394',2149851.83,2149851.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','251613',4802654,'2670','394',1246338.21,1248964.24,2626.03,433294.95,0.00,0.00,0.00,0.00,0.00),('5','104','896','251613',4802655,'2671','394',1886003.50,1886003.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','251613',4802656,'2672','394',1165544.28,1168445.57,2901.29,478712.85,0.00,0.00,0.00,0.00,0.00),('5','104','897','251613',4802657,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','251613',4802658,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','251613',4802659,'2675','394',2322650.30,2325541.85,2891.55,477105.75,0.00,0.00,0.00,0.00,0.00),('5','104','896','251613',4802660,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','251873',4807178,'2669','394',2149851.83,2149851.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','251873',4807179,'2670','394',1248964.24,1253765.47,4801.23,792202.95,0.00,0.00,0.00,0.00,0.00),('5','104','896','251873',4807180,'2671','394',1886003.50,1887520.95,1517.45,250379.25,0.00,0.00,0.00,0.00,0.00),('5','104','896','251873',4807181,'2672','394',1168445.57,1170065.86,1620.29,267347.85,0.00,0.00,0.00,0.00,0.00),('5','104','897','251873',4807182,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','251873',4807183,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','251873',4807184,'2675','394',2325541.85,2328569.95,3028.10,499636.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','251873',4807185,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','252213',4813274,'2669','394',2149851.83,2149851.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','252213',4813275,'2670','394',1253765.47,1258099.91,4304.44,710232.60,0.00,0.00,30.00,0.00,0.00),('5','104','896','252213',4813276,'2671','394',1887520.95,1887520.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','252213',4813277,'2672','394',1170065.86,1170065.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','252213',4813278,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','252213',4813279,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','252213',4813280,'2675','394',2328569.95,2331419.53,2829.58,466880.70,0.00,0.00,20.00,0.00,0.00),('5','104','896','252213',4813281,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','252566',4819520,'2669','394',2149851.83,2149851.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','252566',4819521,'2670','394',1258099.91,1259283.14,1183.23,195232.95,0.00,0.00,0.00,0.00,0.00),('5','104','896','252566',4819522,'2671','394',1887520.95,1887520.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','252566',4819523,'2672','394',1170065.86,1170065.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','252566',4819524,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','252566',4819525,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','252566',4819526,'2675','394',2331419.53,2333450.64,2031.11,335133.15,0.00,0.00,0.00,0.00,0.00),('5','104','896','252566',4819527,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','252677',4821462,'2669','394',2149851.83,2149851.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','252677',4821463,'2670','394',1259283.14,1259283.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','252677',4821464,'2671','394',1887520.95,1887520.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','252677',4821465,'2672','394',1170065.86,1170065.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','252677',4821466,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','252677',4821467,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','252677',4821468,'2675','394',2333450.64,2333450.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','252677',4821469,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','252852',4824175,'2669','394',2149851.83,2149851.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','252852',4824176,'2670','394',1259283.14,1262994.87,3691.73,609135.45,0.00,0.00,20.00,0.00,0.00),('5','104','896','252852',4824177,'2671','394',1887520.95,1889246.05,1705.10,281341.50,0.00,0.00,20.00,0.00,0.00),('5','104','896','252852',4824178,'2672','394',1170065.86,1171466.48,1390.62,229452.30,0.00,0.00,10.00,0.00,0.00),('5','104','897','252852',4824179,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','252852',4824180,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','252852',4824181,'2675','394',2333450.64,2336707.76,3237.12,534124.80,0.00,0.00,20.00,0.00,0.00),('5','104','896','252852',4824182,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','253271',4831196,'2669','394',2149851.83,2149851.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','253271',4831197,'2670','394',1262994.87,1268209.52,5214.65,860417.25,0.00,0.00,0.00,0.00,0.00),('5','104','896','253271',4831198,'2671','394',1889246.05,1890139.81,893.76,147470.40,0.00,0.00,0.00,0.00,0.00),('5','104','896','253271',4831199,'2672','394',1171466.48,1171466.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','253271',4831200,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','253271',4831201,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','253271',4831202,'2675','394',2336707.76,2340950.05,4242.29,699977.85,0.00,0.00,0.00,0.00,0.00),('5','104','896','253271',4831203,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','253289',4831512,'2669','394',2149851.83,2149976.05,124.22,20496.30,0.00,0.00,0.00,0.00,0.00),('5','104','895','253289',4831513,'2670','394',1268209.52,1271074.02,2854.50,470992.50,0.00,0.00,10.00,0.00,0.00),('5','104','896','253289',4831514,'2671','394',1890139.81,1892783.13,2633.32,434497.80,0.00,0.00,10.00,0.00,0.00),('5','104','896','253289',4831515,'2672','394',1171466.48,1174241.13,2764.65,456167.25,0.00,0.00,10.00,0.00,0.00),('5','104','897','253289',4831516,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','253289',4831517,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','253289',4831518,'2675','394',2340950.05,2342919.32,1959.27,323279.55,0.00,0.00,10.00,0.00,0.00),('5','104','896','253289',4831519,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','253554',4835962,'2669','394',2149976.05,2149976.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','253554',4835963,'2670','394',1271074.02,1271074.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','253554',4835964,'2671','394',1892783.13,1897888.94,5105.81,842458.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','253554',4835965,'2672','394',1174241.13,1179406.36,5165.23,852262.95,0.00,0.00,0.00,0.00,0.00),('5','104','897','253554',4835966,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','253554',4835967,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','253554',4835968,'2675','394',2342919.32,2342919.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','253554',4835969,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','253777',4839815,'2669','394',2149976.05,2149976.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','253777',4839816,'2670','394',1271074.02,1274060.40,2986.38,492752.70,0.00,0.00,0.00,0.00,0.00),('5','104','896','253777',4839817,'2671','394',1897888.94,1899379.81,1490.87,245993.55,0.00,0.00,0.00,0.00,0.00),('5','104','896','253777',4839818,'2672','394',1179406.36,1180895.40,1489.04,245691.60,0.00,0.00,0.00,0.00,0.00),('5','104','897','253777',4839819,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','253777',4839820,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','253777',4839821,'2675','394',2342919.32,2345487.90,2568.58,423815.70,0.00,0.00,0.00,0.00,0.00),('5','104','896','253777',4839822,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','254106',4845827,'2669','394',2149976.05,2149976.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','254106',4845828,'2670','394',1274060.40,1279980.65,5920.25,976841.25,0.00,0.00,0.00,0.00,0.00),('5','104','896','254106',4845829,'2671','394',1899379.81,1899379.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','254106',4845830,'2672','394',1180895.40,1180895.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','254106',4845831,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','254106',4845832,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','254106',4845833,'2675','394',2345487.90,2348366.87,2878.97,475030.05,0.00,0.00,0.00,0.00,0.00),('5','104','896','254106',4845834,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','254282',4848745,'2669','394',2149976.05,2149976.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','254282',4848746,'2670','394',1279980.65,1287351.73,7341.08,1211278.20,0.00,0.00,30.00,0.00,0.00),('5','104','896','254282',4848747,'2671','394',1899379.81,1899379.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','254282',4848748,'2672','394',1180895.40,1180895.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','254282',4848749,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','254282',4848750,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','254282',4848751,'2675','394',2348366.87,2351116.96,2720.09,448814.85,0.00,0.00,30.00,0.00,0.00),('5','104','896','254282',4848752,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','254532',4853105,'2669','394',2149976.05,2149976.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','254532',4853106,'2670','394',1287351.73,1288693.48,1341.75,221388.75,0.00,0.00,0.00,0.00,0.00),('5','104','896','254532',4853107,'2671','394',1899379.81,1899379.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','254532',4853108,'2672','394',1180895.40,1180895.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','254532',4853109,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','254532',4853110,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','254532',4853111,'2675','394',2351116.96,2351116.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','254532',4853112,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','254816',4857977,'2669','394',2149976.05,2149976.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','254816',4857978,'2670','394',1288693.48,1288693.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','254816',4857979,'2671','394',1899379.81,1899379.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','254816',4857980,'2672','394',1180895.40,1180895.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','254816',4857981,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','254816',4857982,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','254816',4857983,'2675','394',2351116.96,2351116.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','254816',4857984,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','255096',4862920,'2669','394',2149976.05,2149976.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','255096',4862921,'2670','394',1288693.48,1288693.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','255096',4862922,'2671','394',1899379.81,1900283.37,903.56,149087.40,0.00,0.00,0.00,0.00,0.00),('5','104','896','255096',4862923,'2672','394',1180895.40,1181904.99,1009.59,166582.35,0.00,0.00,0.00,0.00,0.00),('5','104','897','255096',4862924,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','255096',4862925,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','255096',4862926,'2675','394',2351116.96,2351116.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','255096',4862927,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','255573',4870739,'2669','394',2149976.05,2149976.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','255573',4870740,'2670','394',1288693.48,1288693.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','255573',4870741,'2671','394',1900283.37,1904828.70,4515.33,745029.45,0.00,0.00,30.00,0.00,0.00),('5','104','896','255573',4870742,'2672','394',1181904.99,1187227.28,5282.29,871577.85,0.00,0.00,40.00,0.00,0.00),('5','104','897','255573',4870743,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','255573',4870744,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','255573',4870745,'2675','394',2351116.96,2351116.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','255573',4870746,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','255640',4872001,'2669','394',2149976.05,2149976.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','255640',4872002,'2670','394',1288693.48,1288693.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','255640',4872003,'2671','394',1904828.70,1908875.62,4046.92,667741.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','255640',4872004,'2672','394',1187227.28,1190774.75,3547.47,585332.55,0.00,0.00,0.00,0.00,0.00),('5','104','897','255640',4872005,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','255640',4872006,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','255640',4872007,'2675','394',2351116.96,2351116.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','255640',4872008,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','255809',4874702,'2669','394',2149976.05,2149976.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','255809',4874703,'2670','394',1288693.48,1288693.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','255809',4874704,'2671','394',1908875.62,1913127.27,4251.65,701522.25,0.00,0.00,0.00,0.00,0.00),('5','104','896','255809',4874705,'2672','394',1190774.75,1194069.86,3295.11,543693.15,0.00,0.00,0.00,0.00,0.00),('5','104','897','255809',4874706,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','255809',4874707,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','255809',4874708,'2675','394',2351116.96,2351116.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','255809',4874709,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','256022',4878327,'2669','394',2149976.05,2149976.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','256022',4878328,'2670','394',1288693.48,1288693.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','256022',4878329,'2671','394',1913127.27,1915326.34,2199.07,362846.55,0.00,0.00,0.00,0.00,0.00),('5','104','896','256022',4878330,'2672','394',1194069.86,1196380.90,2311.04,381321.60,0.00,0.00,0.00,0.00,0.00),('5','104','897','256022',4878331,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','256022',4878332,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','256022',4878333,'2675','394',2351116.96,2351116.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','256022',4878334,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','256290',4882457,'2669','394',2149976.05,2149976.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','256290',4882458,'2670','394',1288693.48,1288693.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','256290',4882459,'2671','394',1915326.34,1915326.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','256290',4882460,'2672','394',1196380.90,1196380.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','256290',4882461,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','256290',4882462,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','256290',4882463,'2675','394',2351116.96,2351116.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','256290',4882464,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','256935',4893802,'2669','394',2149976.05,2149976.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','256935',4893803,'2670','394',1288693.48,1288693.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','256935',4893804,'2671','394',1915326.34,1915326.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','256935',4893805,'2672','394',1196380.90,1196380.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','256935',4893806,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','256935',4893807,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','256935',4893808,'2675','394',2351116.96,2351116.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','256935',4893809,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257070',4896074,'2669','394',2149976.05,2149976.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257070',4896075,'2670','394',1288693.48,1288693.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257070',4896076,'2671','394',1915326.34,1915326.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257070',4896077,'2672','394',1196380.90,1196380.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257070',4896078,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257070',4896079,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257070',4896080,'2675','394',2351116.96,2351116.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257070',4896081,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257114',4896973,'2669','394',2149976.05,2149976.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257114',4896974,'2670','394',1288693.48,1288693.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257114',4896975,'2671','394',1915326.34,1915326.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257114',4896976,'2672','394',1196380.90,1196380.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257114',4896977,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257114',4896978,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257114',4896979,'2675','394',2351116.96,2351116.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257114',4896980,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257405',4902185,'2669','394',2149976.05,2149976.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257405',4902186,'2670','394',1288693.48,1288693.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257405',4902187,'2671','394',1915326.34,1916221.47,895.13,147696.45,0.00,0.00,0.00,0.00,0.00),('5','104','896','257405',4902188,'2672','394',1196380.90,1197101.67,720.77,118927.05,0.00,0.00,0.00,0.00,0.00),('5','104','897','257405',4902189,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257405',4902190,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257405',4902191,'2675','394',2351116.96,2351116.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257405',4902192,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257406',4902193,'2669','394',2149976.05,2149976.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257406',4902194,'2670','394',1288693.48,1288693.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257406',4902195,'2671','394',1916221.47,1921367.97,5146.50,849172.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','257406',4902196,'2672','394',1197101.67,1201288.13,4186.46,690765.90,0.00,0.00,0.00,0.00,0.00),('5','104','897','257406',4902197,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257406',4902198,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257406',4902199,'2675','394',2351116.96,2351116.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257406',4902200,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257407',4902201,'2669','394',2149976.05,2149976.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257407',4902202,'2670','394',1288693.48,1288693.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257407',4902203,'2671','394',1921367.97,1926125.05,4727.08,779968.20,0.00,0.00,30.00,0.00,0.00),('5','104','896','257407',4902204,'2672','394',1201288.13,1206224.24,4896.11,807858.15,0.00,0.00,40.00,0.00,0.00),('5','104','897','257407',4902205,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257407',4902206,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257407',4902207,'2675','394',2351116.96,2351116.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257407',4902208,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257408',4902209,'2669','394',2149976.05,2149976.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257408',4902210,'2670','394',1288693.48,1288693.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257408',4902211,'2671','394',1926125.05,1926125.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257408',4902212,'2672','394',1206224.24,1208588.24,2364.00,390060.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257408',4902213,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257408',4902214,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257408',4902215,'2675','394',2351116.96,2351116.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257408',4902216,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257409',4902217,'2669','394',2149976.05,2149976.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257409',4902218,'2670','394',1288693.48,1288693.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257409',4902219,'2671','394',1926125.05,1927273.46,1148.41,189487.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','257409',4902220,'2672','394',1208588.24,1208843.15,254.91,42060.15,0.00,0.00,0.00,0.00,0.00),('5','104','897','257409',4902221,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257409',4902222,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257409',4902223,'2675','394',2351116.96,2351116.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257409',4902224,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257410',4902225,'2669','394',2149976.05,2149976.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257410',4902226,'2670','394',1288693.48,1290311.05,1597.57,263599.05,0.00,0.00,20.00,0.00,0.00),('5','104','896','257410',4902227,'2671','394',1927273.46,1930109.00,2815.54,464564.10,0.00,0.00,20.00,0.00,0.00),('5','104','896','257410',4902228,'2672','394',1208843.15,1213494.50,4621.35,762522.75,0.00,0.00,30.00,0.00,0.00),('5','104','897','257410',4902229,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257410',4902230,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257410',4902231,'2675','394',2351116.96,2351116.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257410',4902232,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257411',4902233,'2669','394',2149976.05,2150009.86,33.81,5578.65,0.00,0.00,0.00,0.00,0.00),('5','104','895','257411',4902234,'2670','394',1290311.05,1290572.40,261.35,43122.75,0.00,0.00,0.00,0.00,0.00),('5','104','896','257411',4902235,'2671','394',1930109.00,1935297.89,5188.89,856166.85,0.00,0.00,0.00,0.00,0.00),('5','104','896','257411',4902236,'2672','394',1213494.50,1216332.59,2838.09,468284.85,0.00,0.00,0.00,0.00,0.00),('5','104','897','257411',4902237,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257411',4902238,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257411',4902239,'2675','394',2351116.96,2351841.80,724.84,119598.60,0.00,0.00,0.00,0.00,0.00),('5','104','896','257411',4902240,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257412',4902241,'2669','394',2150009.86,2150009.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257412',4902242,'2670','394',1290572.40,1290572.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257412',4902243,'2671','394',1935297.89,1939445.02,4117.13,679326.45,0.00,0.00,30.00,0.00,0.00),('5','104','896','257412',4902244,'2672','394',1216332.59,1220348.09,3995.50,659257.50,0.00,0.00,20.00,0.00,0.00),('5','104','897','257412',4902245,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257412',4902246,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257412',4902247,'2675','394',2351841.80,2351841.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257412',4902248,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257413',4902249,'2669','394',2150009.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257413',4902250,'2670','394',1290572.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257413',4902251,'2671','394',1939445.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257413',4902252,'2672','394',1220348.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257413',4902253,'2673','395',1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257413',4902254,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257413',4902255,'2675','394',2351841.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257413',4902256,'2676','394',1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257414',4902257,'2669','394',2150009.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257414',4902258,'2670','394',1294777.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257414',4902259,'2675','394',2351841.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257414',4902260,'2671','394',1939255.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257414',4902261,'2672','394',1220348.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257414',4902262,'2676','394',1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257414',4902263,'2673','395',1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257414',4902264,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257415',4902265,'2669','394',2150009.86,2156715.97,6706.11,1106508.15,0.00,0.00,0.00,0.00,0.00),('5','104','895','257415',4902266,'2670','394',1290572.40,1292299.52,1727.12,284974.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','257415',4902267,'2671','394',1939445.02,1939445.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257415',4902268,'2672','394',1220348.09,1220348.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257415',4902269,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257415',4902270,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257415',4902271,'2675','394',2351841.80,2351841.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257415',4902272,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257416',4902273,'2669','394',2156715.97,2156715.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257416',4902274,'2670','394',1292299.52,1295073.34,2773.82,457680.30,0.00,0.00,0.00,0.00,0.00),('5','104','896','257416',4902275,'2671','394',1939445.02,1941810.51,2365.49,390305.85,0.00,0.00,0.00,0.00,0.00),('5','104','896','257416',4902276,'2672','394',1220348.09,1223040.44,2692.35,444237.75,0.00,0.00,0.00,0.00,0.00),('5','104','897','257416',4902277,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257416',4902278,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257416',4902279,'2675','394',2351841.80,2353829.06,1987.26,327897.90,0.00,0.00,0.00,0.00,0.00),('5','104','896','257416',4902280,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257417',4902281,'2669','394',2156715.97,2156715.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257417',4902282,'2670','394',1295073.34,1295073.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257417',4902283,'2671','394',1941810.51,1941810.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257417',4902284,'2672','394',1223040.44,1223040.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257417',4902285,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257417',4902286,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257417',4902287,'2675','394',2353829.06,2356384.09,2555.03,421579.95,0.00,0.00,0.00,0.00,0.00),('5','104','896','257417',4902288,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257418',4902289,'2669','394',2156715.97,2156715.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257418',4902290,'2670','394',1295073.34,1295073.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257418',4902291,'2675','394',2356384.09,2356384.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257418',4902292,'2671','394',1941810.51,1941810.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257418',4902293,'2672','394',1223040.44,1223040.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257418',4902294,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257418',4902295,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257418',4902296,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257419',4902297,'2669','394',2156715.97,2156715.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257419',4902298,'2670','394',1295073.34,1295073.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257419',4902299,'2671','394',1941810.51,1941810.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257419',4902300,'2672','394',1223040.44,1223040.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257419',4902301,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257419',4902302,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257419',4902303,'2675','394',2356384.09,2356384.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257419',4902304,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257420',4902305,'2669','394',2156715.97,2156715.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257420',4902306,'2670','394',1295073.34,1295073.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257420',4902307,'2671','394',1941810.51,1943398.64,1588.13,262041.45,0.00,0.00,0.00,0.00,0.00),('5','104','896','257420',4902308,'2672','394',1223040.44,1224129.52,1089.08,179698.20,0.00,0.00,0.00,0.00,0.00),('5','104','897','257420',4902309,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257420',4902310,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257420',4902311,'2675','394',2356384.09,2356384.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257420',4902312,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257421',4902313,'2669','394',2156715.97,2156715.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257421',4902314,'2670','394',1295073.34,1295073.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257421',4902315,'2671','394',1943398.64,1950511.90,7113.26,1173687.90,0.00,0.00,0.00,0.00,0.00),('5','104','896','257421',4902316,'2672','394',1224129.52,1224129.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257421',4902317,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257421',4902318,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257421',4902319,'2675','394',2356384.09,2356384.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257421',4902320,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257422',4902321,'2669','394',2156715.97,2156715.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257422',4902322,'2670','394',1295073.34,1295073.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257422',4902323,'2671','394',1950511.90,1955038.43,4496.53,741927.45,0.00,0.00,30.00,0.00,0.00),('5','104','896','257422',4902324,'2672','394',1224129.52,1229709.80,5540.28,914146.20,0.00,0.00,40.00,0.00,0.00),('5','104','897','257422',4902325,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257422',4902326,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257422',4902327,'2675','394',2356384.09,2356384.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257422',4902328,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257423',4902329,'2669','394',2156715.97,2156715.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257423',4902330,'2670','394',1295073.34,1295073.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257423',4902331,'2671','394',1955038.43,1956322.55,1284.12,211879.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','257423',4902332,'2672','394',1229709.80,1231224.11,1514.31,249861.15,0.00,0.00,0.00,0.00,0.00),('5','104','897','257423',4902333,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257423',4902334,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257423',4902335,'2675','394',2356384.09,2356384.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257423',4902336,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257424',4902337,'2669','394',2156715.97,2156715.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257424',4902338,'2670','394',1295073.34,1295073.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257424',4902339,'2671','394',1956322.55,1956322.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257424',4902340,'2672','394',1231224.11,1231224.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257424',4902341,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257424',4902342,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257424',4902343,'2675','394',2356384.09,2356384.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257424',4902344,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257425',4902345,'2669','394',2156715.97,2156715.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257425',4902346,'2670','394',1295073.34,1295073.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257425',4902347,'2671','394',1956322.55,1956322.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257425',4902348,'2672','394',1231224.11,1231224.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257425',4902349,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257425',4902350,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257425',4902351,'2675','394',2356384.09,2356384.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257425',4902352,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257426',4902353,'2669','394',2156715.97,2156715.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257426',4902354,'2670','394',1295073.34,1295073.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257426',4902355,'2671','394',1956322.55,1956322.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257426',4902356,'2672','394',1231224.11,1231224.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257426',4902357,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257426',4902358,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257426',4902359,'2675','394',2356384.09,2356384.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257426',4902360,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257427',4902361,'2669','394',2156715.97,2156715.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257427',4902362,'2670','394',1295073.34,1295073.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257427',4902363,'2671','394',1956322.55,1956322.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257427',4902364,'2672','394',1231224.11,1231224.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257427',4902365,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257427',4902366,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257427',4902367,'2675','394',2356384.09,2356384.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257427',4902368,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257428',4902369,'2669','394',2156715.97,2156715.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257428',4902370,'2670','394',1295073.34,1295073.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257428',4902371,'2671','394',1956322.55,1956322.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257428',4902372,'2672','394',1231224.11,1231224.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257428',4902373,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257428',4902374,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257428',4902375,'2675','394',2356384.09,2356384.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257428',4902376,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257429',4902377,'2669','394',2156715.97,2156715.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257429',4902378,'2670','394',1295073.34,1295073.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257429',4902379,'2671','394',1956322.55,1956322.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257429',4902380,'2672','394',1231224.11,1231224.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257429',4902381,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257429',4902382,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257429',4902383,'2675','394',2356384.09,2356384.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257429',4902384,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257430',4902385,'2669','394',2156715.97,2159201.55,2485.58,410120.70,0.00,0.00,0.00,0.00,0.00),('5','104','895','257430',4902386,'2670','394',1295073.34,1295073.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257430',4902387,'2671','394',1956322.55,1956322.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257430',4902388,'2672','394',1231224.11,1231224.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257430',4902389,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257430',4902390,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257430',4902391,'2675','394',2356384.09,2358536.15,2152.06,355089.90,0.00,0.00,0.00,0.00,0.00),('5','104','896','257430',4902392,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257431',4902393,'2669','394',2159201.55,2163898.27,4666.72,770008.80,0.00,0.00,30.00,0.00,0.00),('5','104','895','257431',4902394,'2670','394',1295073.34,1295073.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257431',4902395,'2671','394',1956322.55,1956322.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257431',4902396,'2672','394',1231224.11,1231224.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257431',4902397,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257431',4902398,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257431',4902399,'2675','394',2358536.15,2364154.45,5588.30,922069.50,0.00,0.00,30.00,0.00,0.00),('5','104','896','257431',4902400,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257432',4902401,'2669','394',2163898.27,2173134.05,9235.78,1523903.70,0.00,0.00,0.00,0.00,0.00),('5','104','895','257432',4902402,'2670','394',1295073.34,1295073.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257432',4902403,'2671','394',1956322.55,1956417.66,95.11,15693.15,0.00,0.00,0.00,0.00,0.00),('5','104','896','257432',4902404,'2672','394',1231224.11,1234211.30,2987.19,492886.35,0.00,0.00,0.00,0.00,0.00),('5','104','897','257432',4902405,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257432',4902406,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257432',4902407,'2675','394',2364154.45,2369384.75,5230.30,862999.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','257432',4902408,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257433',4902409,'2669','394',2173134.05,2179535.17,6401.12,1056184.80,0.00,0.00,0.00,0.00,0.00),('5','104','895','257433',4902410,'2670','394',1295073.34,1295073.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257433',4902411,'2671','394',1956417.66,1956417.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257433',4902412,'2672','394',1234211.30,1239231.95,5020.65,828407.25,0.00,0.00,0.00,0.00,0.00),('5','104','897','257433',4902413,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257433',4902414,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257433',4902415,'2675','394',2369384.75,2369384.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257433',4902416,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257434',4902417,'2669','394',2179535.17,2180911.11,1365.94,225380.10,0.00,0.00,10.00,0.00,0.00),('5','104','895','257434',4902418,'2670','394',1295073.34,1295073.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257434',4902419,'2671','394',1956417.66,1956417.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257434',4902420,'2672','394',1239231.95,1244418.62,5156.67,850850.55,0.00,0.00,30.00,0.00,0.00),('5','104','897','257434',4902421,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257434',4902422,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257434',4902423,'2675','394',2369384.75,2374575.42,5160.67,851510.55,0.00,0.00,30.00,0.00,0.00),('5','104','896','257434',4902424,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257435',4902425,'2669','394',2180911.11,2184961.96,4050.85,668390.25,0.00,0.00,0.00,0.00,0.00),('5','104','895','257435',4902426,'2670','394',1295073.34,1295073.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257435',4902427,'2675','394',2374575.42,2378647.64,4072.22,671916.30,0.00,0.00,0.00,0.00,0.00),('5','104','896','257435',4902428,'2671','394',1956417.66,1956420.09,2.43,400.95,0.00,0.00,0.00,0.00,0.00),('5','104','896','257435',4902429,'2672','394',1244418.62,1249359.95,4941.33,815319.45,0.00,0.00,0.00,0.00,0.00),('5','104','896','257435',4902430,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257435',4902431,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257435',4902432,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257436',4902433,'2669','394',2184961.96,2187801.90,2839.94,468590.10,0.00,0.00,0.00,0.00,0.00),('5','104','895','257436',4902434,'2670','394',1295073.34,1295073.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257436',4902435,'2671','394',1956420.09,1960666.84,4246.75,700713.75,0.00,0.00,0.00,0.00,0.00),('5','104','896','257436',4902436,'2672','394',1249359.95,1249674.02,314.07,51821.55,0.00,0.00,0.00,0.00,0.00),('5','104','897','257436',4902437,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257436',4902438,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257436',4902439,'2675','394',2378647.64,2384867.29,6219.65,1026242.25,0.00,0.00,0.00,0.00,0.00),('5','104','896','257436',4902440,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257437',4902441,'2669','394',2187801.90,2188413.86,601.96,99323.40,0.00,0.00,10.00,0.00,0.00),('5','104','895','257437',4902442,'2670','394',1295073.34,1295073.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257437',4902443,'2671','394',1960666.84,1963986.33,3299.49,544415.85,0.00,0.00,20.00,0.00,0.00),('5','104','896','257437',4902444,'2672','394',1249674.02,1253864.10,4160.08,686413.20,0.00,0.00,30.00,0.00,0.00),('5','104','897','257437',4902445,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257437',4902446,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257437',4902447,'2675','394',2384867.29,2385842.72,965.43,159295.95,0.00,0.00,10.00,0.00,0.00),('5','104','896','257437',4902448,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257438',4902449,'2669','394',2188413.86,2191076.42,2662.56,439322.40,0.00,0.00,0.00,0.00,0.00),('5','104','895','257438',4902450,'2670','394',1295073.34,1295073.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257438',4902451,'2671','394',1963986.33,1963996.84,10.51,1734.15,0.00,0.00,0.00,0.00,0.00),('5','104','896','257438',4902452,'2672','394',1253864.10,1254496.62,632.52,104365.80,0.00,0.00,0.00,0.00,0.00),('5','104','897','257438',4902453,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257438',4902454,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257438',4902455,'2675','394',2385842.72,2388464.06,2621.34,432521.10,0.00,0.00,0.00,0.00,0.00),('5','104','896','257438',4902456,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257439',4902457,'2669','394',2191076.42,2194258.88,3182.46,525105.90,0.00,0.00,0.00,0.00,0.00),('5','104','895','257439',4902458,'2670','394',1295073.34,1295473.31,399.97,65995.05,0.00,0.00,0.00,0.00,0.00),('5','104','896','257439',4902459,'2671','394',1963996.84,1963996.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257439',4902460,'2672','394',1254496.62,1259855.31,5358.69,884183.85,0.00,0.00,0.00,0.00,0.00),('5','104','897','257439',4902461,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257439',4902462,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257439',4902463,'2675','394',2388464.06,2391309.09,2845.03,469429.95,0.00,0.00,0.00,0.00,0.00),('5','104','896','257439',4902464,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257440',4902465,'2669','394',2194258.88,2194258.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257440',4902466,'2670','394',1295473.31,1295473.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257440',4902467,'2671','394',1963996.84,1969913.02,5916.18,976169.70,0.00,0.00,0.00,0.00,0.00),('5','104','896','257440',4902468,'2672','394',1259855.31,1264902.58,5047.27,832799.55,0.00,0.00,0.00,0.00,0.00),('5','104','897','257440',4902469,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257440',4902470,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257440',4902471,'2675','394',2391309.09,2391309.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257440',4902472,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257441',4902473,'2669','394',2194258.88,2194258.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257441',4902474,'2670','394',1295473.31,1295473.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257441',4902475,'2675','394',2391309.09,2391309.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257441',4902476,'2671','394',1969913.02,1972639.79,2726.77,449917.05,0.00,0.00,0.00,0.00,0.00),('5','104','896','257441',4902477,'2672','394',1264902.58,1267391.79,2489.21,410719.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','257441',4902478,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257441',4902479,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257441',4902480,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257442',4902481,'2669','394',2194258.88,2198760.59,4501.71,742782.15,0.00,0.00,0.00,0.00,0.00),('5','104','895','257442',4902482,'2670','394',1295473.31,1297451.27,1977.96,326363.40,0.00,0.00,0.00,0.00,0.00),('5','104','895','257442',4902483,'2675','394',2391309.09,2396761.34,5452.25,899621.25,0.00,0.00,0.00,0.00,0.00),('5','104','896','257442',4902484,'2671','394',1972639.79,1972639.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257442',4902485,'2672','394',1267391.79,1267391.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257442',4902486,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257442',4902487,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257442',4902488,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257443',4902489,'2669','394',2198760.59,2205102.61,6342.02,1046433.30,0.00,0.00,0.00,0.00,0.00),('5','104','895','257443',4902490,'2670','394',1297451.27,1297451.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257443',4902491,'2671','394',1972639.79,1972639.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257443',4902492,'2672','394',1267391.79,1267391.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257443',4902493,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257443',4902494,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257443',4902495,'2675','394',2396761.34,2403043.90,6282.56,1036622.40,0.00,0.00,0.00,0.00,0.00),('5','104','896','257443',4902496,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257444',4902497,'2669','394',2205102.61,2207748.54,2645.93,436578.45,0.00,0.00,0.00,0.00,0.00),('5','104','895','257444',4902498,'2670','394',1297451.27,1297763.14,311.87,51458.55,0.00,0.00,0.00,0.00,0.00),('5','104','896','257444',4902499,'2671','394',1972639.79,1972639.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257444',4902500,'2672','394',1267391.79,1267391.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257444',4902501,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257444',4902502,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257444',4902503,'2675','394',2403043.90,2403043.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257444',4902504,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257445',4902505,'2669','394',2207748.54,2207748.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257445',4902506,'2670','394',1297763.14,1297763.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257445',4902507,'2671','394',1972639.79,1972639.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257445',4902508,'2672','394',1267391.79,1267391.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257445',4902509,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257445',4902510,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257445',4902511,'2675','394',2403043.90,2403043.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257445',4902512,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257446',4902513,'2669','394',2207748.54,2207748.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257446',4902514,'2670','394',1297763.14,1297763.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257446',4902515,'2671','394',1972639.79,1972639.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257446',4902516,'2672','394',1267391.79,1267391.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257446',4902517,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257446',4902518,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257446',4902519,'2675','394',2403043.90,2403043.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257446',4902520,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257447',4902521,'2669','394',2207748.54,2208467.00,718.46,118545.90,0.00,0.00,0.00,0.00,0.00),('5','104','895','257447',4902522,'2670','394',1297763.14,1297763.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257447',4902523,'2675','394',2403043.90,2403942.20,898.30,148219.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','257447',4902524,'2671','394',1972639.79,1972639.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257447',4902525,'2672','394',1267391.79,1267863.40,471.61,77815.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','257447',4902526,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257447',4902527,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257447',4902528,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257448',4902529,'2669','394',2208467.00,2211868.14,3381.14,557888.10,0.00,0.00,20.00,0.00,0.00),('5','104','895','257448',4902530,'2670','394',1297763.14,1297763.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257448',4902531,'2671','394',1972639.79,1975973.19,3313.40,546711.00,0.00,0.00,20.00,0.00,0.00),('5','104','896','257448',4902532,'2672','394',1267863.40,1271148.11,3274.71,540327.15,0.00,0.00,10.00,0.00,0.00),('5','104','897','257448',4902533,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257448',4902534,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257448',4902535,'2675','394',2403942.20,2407404.27,3442.07,567941.55,0.00,0.00,20.00,0.00,0.00),('5','104','896','257448',4902536,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257449',4902537,'2669','394',2211868.14,2214427.50,2559.36,422294.40,0.00,0.00,0.00,0.00,0.00),('5','104','895','257449',4902538,'2670','394',1297763.14,1297763.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257449',4902539,'2671','394',1975973.19,1978235.08,2261.89,373211.85,0.00,0.00,0.00,0.00,0.00),('5','104','896','257449',4902540,'2672','394',1271148.11,1274732.87,3584.76,591485.40,0.00,0.00,0.00,0.00,0.00),('5','104','897','257449',4902541,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257449',4902542,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257449',4902543,'2675','394',2407404.27,2410366.62,2962.35,488787.75,0.00,0.00,0.00,0.00,0.00),('5','104','896','257449',4902544,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257450',4902545,'2669','394',2214427.50,2220064.33,5636.83,930076.95,0.00,0.00,0.00,0.00,0.00),('5','104','895','257450',4902546,'2670','394',1297763.14,1297763.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257450',4902547,'2671','394',1978235.08,1979027.86,792.78,130808.70,0.00,0.00,0.00,0.00,0.00),('5','104','896','257450',4902548,'2672','394',1274732.87,1274732.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257450',4902549,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257450',4902550,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257450',4902551,'2675','394',2410366.62,2414567.99,4201.37,693226.05,0.00,0.00,0.00,0.00,0.00),('5','104','896','257450',4902552,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257451',4902553,'2669','394',2220064.33,2220064.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257451',4902554,'2670','394',1297763.14,1298004.04,240.90,39748.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','257451',4902555,'2671','394',1979027.86,1979027.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257451',4902556,'2672','394',1274732.87,1274732.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257451',4902557,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257451',4902558,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257451',4902559,'2675','394',2414567.99,2416578.10,2010.11,331668.15,0.00,0.00,0.00,0.00,0.00),('5','104','896','257451',4902560,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257452',4902561,'2669','394',2220064.33,2220064.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257452',4902562,'2670','394',1298004.04,1298004.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257452',4902563,'2671','394',1979027.86,1979027.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257452',4902564,'2672','394',1274732.87,1274732.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257452',4902565,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257452',4902566,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257452',4902567,'2675','394',2416578.10,2416578.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257452',4902568,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257453',4902569,'2669','394',2220064.33,2220064.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257453',4902570,'2670','394',1298004.04,1298004.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257453',4902571,'2671','394',1979027.86,1979027.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257453',4902572,'2672','394',1274732.87,1274732.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257453',4902573,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257453',4902574,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257453',4902575,'2675','394',2416578.10,2416578.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257453',4902576,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257454',4902577,'2669','394',2220064.33,2220064.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257454',4902578,'2670','394',1298004.04,1298004.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257454',4902579,'2671','394',1979027.86,1979027.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257454',4902580,'2672','394',1274732.87,1274732.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257454',4902581,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257454',4902582,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257454',4902583,'2675','394',2416578.10,2416578.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257454',4902584,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257455',4902585,'2669','394',2220064.33,2220728.97,664.64,109665.60,0.00,0.00,0.00,0.00,0.00),('5','104','895','257455',4902586,'2670','394',1298004.04,1298702.24,698.20,115203.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257455',4902587,'2675','394',2416578.10,2417452.77,874.67,144320.55,0.00,0.00,0.00,0.00,0.00),('5','104','896','257455',4902588,'2671','394',1979027.86,1979027.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257455',4902589,'2672','394',1274732.87,1274732.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257455',4902590,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257455',4902591,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257455',4902592,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257456',4902593,'2669','394',2220728.97,2225528.97,4800.00,792000.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257456',4902594,'2670','394',1298702.24,1298702.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257456',4902595,'2671','394',1979027.86,1979027.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257456',4902596,'2672','394',1274732.87,1274732.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257456',4902597,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257456',4902598,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257456',4902599,'2675','394',2417452.77,2424583.07,7130.30,1176499.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','257456',4902600,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257457',4902601,'2669','394',2225528.97,2228740.52,3181.55,524955.75,0.00,0.00,30.00,0.00,0.00),('5','104','895','257457',4902602,'2670','394',1298702.24,1301445.49,2733.25,450986.25,0.00,0.00,10.00,0.00,0.00),('5','104','896','257457',4902603,'2671','394',1979027.86,1979027.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257457',4902604,'2672','394',1274732.87,1274732.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257457',4902605,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257457',4902606,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257457',4902607,'2675','394',2424583.07,2428293.16,3680.09,607214.85,0.00,0.00,30.00,0.00,0.00),('5','104','896','257457',4902608,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257458',4902609,'2669','394',2228740.52,2229683.37,942.85,155570.25,0.00,0.00,0.00,0.00,0.00),('5','104','895','257458',4902610,'2670','394',1301445.49,1301445.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257458',4902611,'2671','394',1979027.86,1979027.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257458',4902612,'2672','394',1274732.87,1274732.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257458',4902613,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257458',4902614,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257458',4902615,'2675','394',2428293.16,2429907.10,1613.94,266300.10,0.00,0.00,0.00,0.00,0.00),('5','104','896','257458',4902616,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257459',4902617,'2669','394',2229683.37,2229683.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257459',4902618,'2670','394',1301445.49,1301445.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257459',4902619,'2671','394',1979027.86,1979027.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257459',4902620,'2672','394',1274732.87,1274732.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257459',4902621,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257459',4902622,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257459',4902623,'2675','394',2429907.10,2429907.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257459',4902624,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257460',4902625,'2669','394',2229683.37,2229683.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257460',4902626,'2670','394',1301445.49,1301445.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257460',4902627,'2671','394',1979027.86,1979027.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257460',4902628,'2672','394',1274732.87,1274732.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257460',4902629,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257460',4902630,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257460',4902631,'2675','394',2429907.10,2429907.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257460',4902632,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257461',4902633,'2669','394',2229683.37,2231003.58,1320.21,217834.65,0.00,0.00,0.00,0.00,0.00),('5','104','895','257461',4902634,'2670','394',1301445.49,1302359.60,914.11,150828.15,0.00,0.00,0.00,0.00,0.00),('5','104','896','257461',4902635,'2671','394',1979027.86,1979027.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257461',4902636,'2672','394',1274732.87,1274732.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257461',4902637,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257461',4902638,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257461',4902639,'2675','394',2429907.10,2431248.24,1341.14,221288.10,0.00,0.00,0.00,0.00,0.00),('5','104','896','257461',4902640,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257462',4902641,'2669','394',2231003.58,2234527.78,3494.20,576543.00,0.00,0.00,30.00,0.00,0.00),('5','104','895','257462',4902642,'2670','394',1302359.60,1303224.92,845.32,139477.80,0.00,0.00,20.00,0.00,0.00),('5','104','896','257462',4902643,'2671','394',1979027.86,1979027.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257462',4902644,'2672','394',1274732.87,1274732.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257462',4902645,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257462',4902646,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257462',4902647,'2675','394',2431248.24,2435380.91,4112.67,678590.55,0.00,0.00,20.00,0.00,0.00),('5','104','896','257462',4902648,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257463',4902649,'2669','394',2234527.78,2238734.62,4206.84,694128.60,0.00,0.00,0.00,0.00,0.00),('5','104','895','257463',4902650,'2670','394',1303224.92,1303224.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257463',4902651,'2671','394',1979027.86,1979027.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257463',4902652,'2672','394',1274732.87,1274732.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257463',4902653,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257463',4902654,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257463',4902655,'2675','394',2435380.91,2440685.98,5305.07,875336.55,0.00,0.00,0.00,0.00,0.00),('5','104','896','257463',4902656,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257464',4902657,'2669','394',2238734.62,2241194.93,2460.31,405951.15,0.00,0.00,0.00,0.00,0.00),('5','104','895','257464',4902658,'2670','394',1303224.92,1307192.07,3967.15,654579.75,0.00,0.00,0.00,0.00,0.00),('5','104','896','257464',4902659,'2671','394',1979027.86,1979027.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257464',4902660,'2672','394',1274732.87,1274732.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257464',4902661,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257464',4902662,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257464',4902663,'2675','394',2440685.98,2445321.93,4635.95,764931.75,0.00,0.00,0.00,0.00,0.00),('5','104','896','257464',4902664,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257465',4902665,'2669','394',2241194.93,2241194.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257465',4902666,'2670','394',1307192.07,1307192.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257465',4902667,'2671','394',1979027.86,1979027.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257465',4902668,'2672','394',1274732.87,1274732.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257465',4902669,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257465',4902670,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257465',4902671,'2675','394',2445321.93,2445321.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257465',4902672,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257466',4902673,'2669','394',2241194.93,2241194.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257466',4902674,'2670','394',1307192.07,1307192.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257466',4902675,'2671','394',1979027.86,1979027.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257466',4902676,'2672','394',1274732.87,1274732.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257466',4902677,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257466',4902678,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257466',4902679,'2675','394',2445321.93,2445321.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257466',4902680,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257467',4902681,'2669','394',2241194.93,2241194.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257467',4902682,'2670','394',1307192.07,1307192.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257467',4902683,'2671','394',1979027.86,1979027.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257467',4902684,'2672','394',1274732.87,1274732.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257467',4902685,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257467',4902686,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257467',4902687,'2675','394',2445321.93,2445321.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257467',4902688,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257468',4902689,'2669','394',2241194.93,2241194.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257468',4902690,'2670','394',1307192.07,1307192.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257468',4902691,'2671','394',1979027.86,1979027.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257468',4902692,'2672','394',1274732.87,1274732.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257468',4902693,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257468',4902694,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257468',4902695,'2675','394',2445321.93,2445321.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257468',4902696,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257469',4902697,'2669','394',2241194.93,2241194.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257469',4902698,'2670','394',1307192.07,1307192.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257469',4902699,'2675','394',2445321.93,2445321.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257469',4902700,'2671','394',1979027.86,1979027.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257469',4902701,'2672','394',1274732.87,1274732.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257469',4902702,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257469',4902703,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257469',4902704,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257470',4902705,'2669','394',2241194.93,2241194.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257470',4902706,'2670','394',1307192.07,1307192.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257470',4902707,'2671','394',1979027.86,1979027.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257470',4902708,'2672','394',1274732.87,1274732.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257470',4902709,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257470',4902710,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257470',4902711,'2675','394',2445321.93,2445321.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257470',4902712,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257471',4902713,'2669','394',2241194.93,2241194.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257471',4902714,'2670','394',1307192.07,1307192.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257471',4902715,'2671','394',1979027.86,1979027.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257471',4902716,'2672','394',1274732.87,1274732.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257471',4902717,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257471',4902718,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257471',4902719,'2675','394',2445321.93,2445321.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257471',4902720,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257472',4902721,'2669','394',2241194.93,2241194.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257472',4902722,'2670','394',1307192.07,1307192.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257472',4902723,'2671','394',1979027.86,1979027.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257472',4902724,'2672','394',1274732.87,1274732.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257472',4902725,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257472',4902726,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257472',4902727,'2675','394',2445321.93,2445321.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257472',4902728,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257473',4902729,'2669','394',2241194.93,2241194.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257473',4902730,'2670','394',1307192.07,1307192.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257473',4902731,'2671','394',1979027.86,1979027.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257473',4902732,'2672','394',1274732.87,1274732.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257473',4902733,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257473',4902734,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257473',4902735,'2675','394',2445321.93,2445321.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257473',4902736,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257474',4902737,'2669','394',2241194.93,2241194.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257474',4902738,'2670','394',1307192.07,1307192.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257474',4902739,'2671','394',1979027.86,1979027.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257474',4902740,'2672','394',1274732.87,1274732.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257474',4902741,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257474',4902742,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257474',4902743,'2675','394',2445321.93,2445321.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257474',4902744,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257475',4902745,'2669','394',2241194.93,2241194.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257475',4902746,'2670','394',1307192.07,1307192.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257475',4902747,'2671','394',1979027.86,1979027.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257475',4902748,'2672','394',1274732.87,1274732.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257475',4902749,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257475',4902750,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257475',4902751,'2675','394',2445321.93,2445321.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257475',4902752,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257476',4902753,'2669','394',2241194.93,2241194.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257476',4902754,'2670','394',1307192.07,1307192.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257476',4902755,'2671','394',1979027.86,1979027.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257476',4902756,'2672','394',1274732.87,1274732.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257476',4902757,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257476',4902758,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257476',4902759,'2675','394',2445321.93,2445321.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257476',4902760,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257477',4902761,'2669','394',2241194.93,2241194.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257477',4902762,'2670','394',1307192.07,1307192.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257477',4902763,'2671','394',1979027.86,1979027.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257477',4902764,'2672','394',1274732.87,1274732.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257477',4902765,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257477',4902766,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257477',4902767,'2675','394',2445321.93,2445321.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257477',4902768,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257478',4902769,'2669','394',2241194.93,2241194.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257478',4902770,'2670','394',1307192.07,1307192.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257478',4902771,'2671','394',1979027.86,1979027.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257478',4902772,'2672','394',1274732.87,1274732.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257478',4902773,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257478',4902774,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257478',4902775,'2675','394',2445321.93,2445321.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257478',4902776,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257479',4902777,'2669','394',2241194.93,2241194.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257479',4902778,'2670','394',1307192.07,1307192.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257479',4902779,'2671','394',1979027.86,1979027.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257479',4902780,'2672','394',1274732.87,1274732.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257479',4902781,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257479',4902782,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257479',4902783,'2675','394',2445321.93,2445321.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257479',4902784,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257480',4902785,'2669','394',2241194.93,2246967.09,5772.16,952406.40,0.00,0.00,0.00,0.00,0.00),('5','104','895','257480',4902786,'2670','394',1307192.07,1307432.06,239.99,39598.35,0.00,0.00,0.00,0.00,0.00),('5','104','896','257480',4902787,'2671','394',1979027.86,1979027.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257480',4902788,'2672','394',1274732.87,1274732.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257480',4902789,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257480',4902790,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257480',4902791,'2675','394',2445321.93,2450200.94,4879.01,805036.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','257480',4902792,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257481',4902793,'2669','394',2246967.09,2251014.32,4047.23,667792.95,0.00,0.00,0.00,0.00,0.00),('5','104','895','257481',4902794,'2670','394',1307432.06,1310050.44,2618.38,432032.70,0.00,0.00,0.00,0.00,0.00),('5','104','896','257481',4902795,'2671','394',1979027.86,1979027.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257481',4902796,'2672','394',1274732.87,1274732.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257481',4902797,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257481',4902798,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257481',4902799,'2675','394',2450200.94,2450200.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257481',4902800,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257482',4902801,'2669','394',2251014.32,2253893.09,2878.77,474997.05,0.00,0.00,0.00,0.00,0.00),('5','104','895','257482',4902802,'2670','394',1310050.44,1310218.85,168.41,27787.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','257482',4902803,'2671','394',1979027.86,1979027.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257482',4902804,'2672','394',1274732.87,1274732.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257482',4902805,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257482',4902806,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257482',4902807,'2675','394',2450200.94,2454325.64,4124.70,680575.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','257482',4902808,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257483',4902809,'2669','394',2253893.09,2253893.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257483',4902810,'2670','394',1310218.85,1310511.79,292.94,48335.10,0.00,0.00,0.00,0.00,0.00),('5','104','896','257483',4902811,'2671','394',1979027.86,1979027.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257483',4902812,'2672','394',1274732.87,1274732.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257483',4902813,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257483',4902814,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257483',4902815,'2675','394',2454325.64,2455940.65,1615.01,266476.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','257483',4902816,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257484',4902817,'2669','394',2253893.09,2253893.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257484',4902818,'2670','394',1310511.79,1310511.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257484',4902819,'2671','394',1979027.86,1979027.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257484',4902820,'2672','394',1274732.87,1274732.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257484',4902821,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257484',4902822,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257484',4902823,'2675','394',2455940.65,2455940.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257484',4902824,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257485',4902825,'2669','394',2253893.09,2253893.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257485',4902826,'2670','394',1310511.79,1310511.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257485',4902827,'2671','394',1979027.86,1979027.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257485',4902828,'2672','394',1274732.87,1274732.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257485',4902829,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257485',4902830,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257485',4902831,'2675','394',2455940.65,2455940.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257485',4902832,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257486',4902833,'2669','394',2253893.09,2255830.44,1937.35,319662.75,0.00,0.00,0.00,0.00,0.00),('5','104','895','257486',4902834,'2670','394',1310511.79,1310511.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257486',4902835,'2671','394',1979027.86,1979064.29,36.43,6010.95,0.00,0.00,0.00,0.00,0.00),('5','104','896','257486',4902836,'2672','394',1274732.87,1277159.75,2426.88,400435.20,0.00,0.00,0.00,0.00,0.00),('5','104','897','257486',4902837,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257486',4902838,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257486',4902839,'2675','394',2455940.65,2457303.75,1363.10,224911.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','257486',4902840,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257487',4902841,'2669','394',2255830.44,2259546.26,3715.82,613110.30,0.00,0.00,0.00,0.00,0.00),('5','104','895','257487',4902842,'2670','394',1310511.79,1310511.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257487',4902843,'2671','394',1979064.29,1979064.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257487',4902844,'2672','394',1277159.75,1279169.39,2009.64,331590.60,0.00,0.00,0.00,0.00,0.00),('5','104','897','257487',4902845,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257487',4902846,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257487',4902847,'2675','394',2457303.75,2460724.46,3420.71,564417.15,0.00,0.00,0.00,0.00,0.00),('5','104','896','257487',4902848,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257488',4902849,'2669','394',2259546.26,2261677.61,2131.35,351672.75,0.00,0.00,0.00,0.00,0.00),('5','104','895','257488',4902850,'2670','394',1310511.79,1310511.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257488',4902851,'2671','394',1979064.29,1979064.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257488',4902852,'2672','394',1279169.39,1281196.30,2026.91,334440.15,0.00,0.00,0.00,0.00,0.00),('5','104','897','257488',4902853,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257488',4902854,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257488',4902855,'2675','394',2460724.46,2464518.24,3793.78,625973.70,0.00,0.00,0.00,0.00,0.00),('5','104','896','257488',4902856,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257489',4902857,'2669','394',2261677.61,2266365.90,4688.29,773567.85,0.00,0.00,0.00,0.00,0.00),('5','104','895','257489',4902858,'2670','394',1310511.79,1310868.97,357.18,58934.70,0.00,0.00,0.00,0.00,0.00),('5','104','896','257489',4902859,'2671','394',1979064.29,1979064.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257489',4902860,'2672','394',1281196.30,1282826.07,1629.77,268912.05,0.00,0.00,0.00,0.00,0.00),('5','104','897','257489',4902861,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257489',4902862,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257489',4902863,'2675','394',2464518.24,2466127.35,1609.11,265503.15,0.00,0.00,0.00,0.00,0.00),('5','104','896','257489',4902864,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257490',4902865,'2669','394',2266365.90,2268525.34,2159.44,356307.60,0.00,0.00,0.00,0.00,0.00),('5','104','895','257490',4902866,'2670','394',1310868.97,1310868.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257490',4902867,'2671','394',1979064.29,1980816.70,1752.41,289147.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','257490',4902868,'2672','394',1282826.07,1286359.53,3533.46,583020.90,0.00,0.00,0.00,0.00,0.00),('5','104','897','257490',4902869,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257490',4902870,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257490',4902871,'2675','394',2466127.35,2467729.28,1601.93,264318.45,0.00,0.00,0.00,0.00,0.00),('5','104','896','257490',4902872,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257491',4902873,'2669','394',2268525.34,2271719.57,3194.23,527047.95,0.00,0.00,0.00,0.00,0.00),('5','104','895','257491',4902874,'2670','394',1310868.97,1310868.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257491',4902875,'2671','394',1980816.70,1980816.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257491',4902876,'2672','394',1286359.53,1286359.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257491',4902877,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257491',4902878,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257491',4902879,'2675','394',2467729.28,2471817.81,4088.53,674607.45,0.00,0.00,0.00,0.00,0.00),('5','104','896','257491',4902880,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257492',4902881,'2669','394',2271719.57,2276385.24,4665.67,769835.55,0.00,0.00,0.00,0.00,0.00),('5','104','895','257492',4902882,'2670','394',1310868.97,1310868.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257492',4902883,'2671','394',1980816.70,1980816.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257492',4902884,'2672','394',1286359.53,1286359.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257492',4902885,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257492',4902886,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257492',4902887,'2675','394',2471817.81,2474928.36,3110.55,513240.75,0.00,0.00,0.00,0.00,0.00),('5','104','896','257492',4902888,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257493',4902889,'2669','394',2276385.24,2279636.91,3251.67,536525.55,0.00,0.00,0.00,0.00,0.00),('5','104','895','257493',4902890,'2670','394',1310868.97,1310868.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257493',4902891,'2671','394',1980816.70,1980816.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257493',4902892,'2672','394',1286359.53,1286359.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257493',4902893,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257493',4902894,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257493',4902895,'2675','394',2474928.36,2479713.51,4785.15,789549.75,0.00,0.00,0.00,0.00,0.00),('5','104','896','257493',4902896,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257494',4902897,'2669','394',2279636.91,2282635.05,2998.14,494693.10,0.00,0.00,0.00,0.00,0.00),('5','104','895','257494',4902898,'2670','394',1310868.97,1311176.04,307.07,50666.55,0.00,0.00,0.00,0.00,0.00),('5','104','896','257494',4902899,'2671','394',1980816.70,1980816.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257494',4902900,'2672','394',1286359.53,1286359.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257494',4902901,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257494',4902902,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257494',4902903,'2675','394',2479713.51,2479713.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257494',4902904,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257495',4902905,'2669','394',2282635.05,2282635.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257495',4902906,'2670','394',1311176.04,1311176.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257495',4902907,'2671','394',1980816.70,1980816.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257495',4902908,'2672','394',1286359.53,1286359.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257495',4902909,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257495',4902910,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257495',4902911,'2675','394',2479713.51,2479713.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257495',4902912,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257496',4902913,'2669','394',2282635.05,2285056.36,2421.31,399516.15,0.00,0.00,0.00,0.00,0.00),('5','104','895','257496',4902914,'2670','394',1311176.04,1312875.71,1699.67,280445.55,0.00,0.00,0.00,0.00,0.00),('5','104','896','257496',4902915,'2671','394',1980816.70,1980816.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257496',4902916,'2672','394',1286359.53,1286359.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257496',4902917,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257496',4902918,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257496',4902919,'2675','394',2479713.51,2482044.76,2331.25,384656.25,0.00,0.00,0.00,0.00,0.00),('5','104','896','257496',4902920,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257497',4902921,'2669','394',2285056.36,2287998.87,2942.51,485514.15,0.00,0.00,0.00,0.00,0.00),('5','104','895','257497',4902922,'2670','394',1312875.71,1315215.98,2340.27,386144.55,0.00,0.00,0.00,0.00,0.00),('5','104','896','257497',4902923,'2671','394',1980816.70,1980816.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257497',4902924,'2672','394',1286359.53,1286359.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257497',4902925,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257497',4902926,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257497',4902927,'2675','394',2482044.76,2484448.95,2404.19,396691.35,0.00,0.00,0.00,0.00,0.00),('5','104','896','257497',4902928,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257498',4902929,'2669','394',2287998.87,2291273.71,3274.84,540348.60,0.00,0.00,0.00,0.00,0.00),('5','104','895','257498',4902930,'2670','394',1315215.98,1318335.32,3119.34,514691.10,0.00,0.00,0.00,0.00,0.00),('5','104','896','257498',4902931,'2671','394',1980816.70,1980816.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257498',4902932,'2672','394',1286359.53,1286359.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257498',4902933,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257498',4902934,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257498',4902935,'2675','394',2484448.95,2487661.20,3212.25,530021.25,0.00,0.00,0.00,0.00,0.00),('5','104','896','257498',4902936,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257499',4902937,'2669','394',2291273.71,2294070.44,2796.73,461460.45,0.00,0.00,0.00,0.00,0.00),('5','104','895','257499',4902938,'2670','394',1318335.32,1320103.34,1768.02,291723.30,0.00,0.00,0.00,0.00,0.00),('5','104','896','257499',4902939,'2671','394',1980816.70,1980819.56,2.86,471.90,0.00,0.00,0.00,0.00,0.00),('5','104','896','257499',4902940,'2672','394',1286359.53,1288507.73,2148.20,354453.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257499',4902941,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257499',4902942,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257499',4902943,'2675','394',2487661.20,2489518.05,1856.85,306380.25,0.00,0.00,0.00,0.00,0.00),('5','104','896','257499',4902944,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257500',4902945,'2669','394',2294070.44,2298792.44,4722.00,779130.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257500',4902946,'2670','394',1320103.34,1320103.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257500',4902947,'2671','394',1980819.56,1980819.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257500',4902948,'2672','394',1288507.73,1288507.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257500',4902949,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257500',4902950,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257500',4902951,'2675','394',2489518.05,2493224.96,3706.91,611640.15,0.00,0.00,0.00,0.00,0.00),('5','104','896','257500',4902952,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257501',4902953,'2669','394',2298792.44,2302103.18,3310.74,546272.10,0.00,0.00,0.00,0.00,0.00),('5','104','895','257501',4902954,'2670','394',1320103.34,1320103.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257501',4902955,'2675','394',2493224.96,2496219.00,2994.04,494016.60,0.00,0.00,0.00,0.00,0.00),('5','104','896','257501',4902956,'2671','394',1980819.56,1980819.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257501',4902957,'2672','394',1288507.73,1289704.83,1197.10,197521.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','257501',4902958,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257501',4902959,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257501',4902960,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257502',4902961,'2669','394',2302103.18,2304654.09,2550.91,420900.15,0.00,0.00,0.00,0.00,0.00),('5','104','895','257502',4902962,'2670','394',1320103.34,1320103.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257502',4902963,'2671','394',1980819.56,1980819.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257502',4902964,'2672','394',1289704.83,1293108.98,3404.15,561684.75,0.00,0.00,0.00,0.00,0.00),('5','104','897','257502',4902965,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257502',4902966,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257502',4902967,'2675','394',2496219.00,2496219.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257502',4902968,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257503',4902969,'2669','394',2304654.09,2308260.26,3606.17,595018.05,0.00,0.00,0.00,0.00,0.00),('5','104','895','257503',4902970,'2670','394',1320103.34,1320103.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257503',4902971,'2671','394',1980819.56,1980819.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257503',4902972,'2672','394',1293108.98,1294597.33,1488.35,245577.75,0.00,0.00,0.00,0.00,0.00),('5','104','897','257503',4902973,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257503',4902974,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257503',4902975,'2675','394',2496219.00,2499333.40,3114.40,513876.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257503',4902976,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257504',4902977,'2669','394',2308260.26,2308260.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257504',4902978,'2670','394',1320103.34,1320103.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257504',4902979,'2671','394',1980819.56,1980819.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257504',4902980,'2672','394',1294597.33,1298918.30,4320.97,712960.05,0.00,0.00,0.00,0.00,0.00),('5','104','897','257504',4902981,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257504',4902982,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257504',4902983,'2675','394',2499333.40,2502685.80,3352.40,553146.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257504',4902984,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257505',4902985,'2669','394',2308260.26,2308260.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257505',4902986,'2670','394',1320103.34,1320103.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257505',4902987,'2671','394',1980819.56,1981979.08,1159.52,191320.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','257505',4902988,'2672','394',1298918.30,1300153.82,1235.52,203860.80,0.00,0.00,0.00,0.00,0.00),('5','104','897','257505',4902989,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257505',4902990,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257505',4902991,'2675','394',2502685.80,2502685.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257505',4902992,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257506',4902993,'2669','394',2308260.26,2308260.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257506',4902994,'2670','394',1320103.34,1320103.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257506',4902995,'2671','394',1981979.08,1981979.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257506',4902996,'2672','394',1300153.82,1300153.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257506',4902997,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257506',4902998,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257506',4902999,'2675','394',2502685.80,2502685.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257506',4903000,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257507',4903001,'2669','394',2308260.26,2308260.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257507',4903002,'2670','394',1320103.34,1320103.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257507',4903003,'2675','394',2502685.80,2502685.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257507',4903004,'2671','394',1981979.08,1981979.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257507',4903005,'2672','394',1300153.82,1300153.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257507',4903006,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257507',4903007,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257507',4903008,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257508',4903009,'2669','394',2308260.26,2308260.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257508',4903010,'2670','394',1320103.34,1320103.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257508',4903011,'2671','394',1981979.08,1981979.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257508',4903012,'2672','394',1300153.82,1300153.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257508',4903013,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257508',4903014,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257508',4903015,'2675','394',2502685.80,2502685.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257508',4903016,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257509',4903017,'2669','394',2308260.26,2308260.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257509',4903018,'2670','394',1320103.34,1320103.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257509',4903019,'2671','394',1981979.08,1981979.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257509',4903020,'2672','394',1300153.82,1300153.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257509',4903021,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257509',4903022,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257509',4903023,'2675','394',2502685.80,2502685.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257509',4903024,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257510',4903025,'2669','394',2308260.26,2308260.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257510',4903026,'2670','394',1320103.34,1320103.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257510',4903027,'2671','394',1981979.08,1981979.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257510',4903028,'2672','394',1300153.82,1300153.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257510',4903029,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257510',4903030,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257510',4903031,'2675','394',2502685.80,2502685.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257510',4903032,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257511',4903033,'2669','394',2308260.26,2308260.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257511',4903034,'2670','394',1320103.34,1320103.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257511',4903035,'2671','394',1981979.08,1981979.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257511',4903036,'2672','394',1300153.82,1300153.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257511',4903037,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257511',4903038,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257511',4903039,'2675','394',2502685.80,2502685.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257511',4903040,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257512',4903041,'2669','394',2308260.26,2308260.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257512',4903042,'2670','394',1320103.34,1320103.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257512',4903043,'2671','394',1981979.08,1981979.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257512',4903044,'2672','394',1300153.82,1300153.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257512',4903045,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257512',4903046,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257512',4903047,'2675','394',2502685.80,2502685.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257512',4903048,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257513',4903049,'2669','394',2308260.26,2308260.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257513',4903050,'2670','394',1320103.34,1320103.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257513',4903051,'2671','394',1981979.08,1981979.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257513',4903052,'2672','394',1300153.82,1300153.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257513',4903053,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257513',4903054,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257513',4903055,'2675','394',2502685.80,2502685.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257513',4903056,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257514',4903057,'2669','394',2308260.26,2308260.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257514',4903058,'2670','394',1320103.34,1320103.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257514',4903059,'2671','394',1981979.08,1981979.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257514',4903060,'2672','394',1300153.82,1300153.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257514',4903061,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257514',4903062,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257514',4903063,'2675','394',2502685.80,2502685.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257514',4903064,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257515',4903065,'2669','394',2308260.26,2308260.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257515',4903066,'2670','394',1320103.34,1320103.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257515',4903067,'2671','394',1981979.08,1981979.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257515',4903068,'2672','394',1300153.82,1300153.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257515',4903069,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257515',4903070,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257515',4903071,'2675','394',2502685.80,2502685.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257515',4903072,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257516',4903073,'2669','394',2308260.26,2308260.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257516',4903074,'2670','394',1320103.34,1320103.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257516',4903075,'2671','394',1981979.08,1981979.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257516',4903076,'2672','394',1300153.82,1300153.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257516',4903077,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257516',4903078,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257516',4903079,'2675','394',2502685.80,2502685.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257516',4903080,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257517',4903081,'2669','394',2308260.26,2308260.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257517',4903082,'2670','394',1320103.34,1320103.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257517',4903083,'2671','394',1981979.08,1981979.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257517',4903084,'2672','394',1300153.82,1300153.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257517',4903085,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257517',4903086,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257517',4903087,'2675','394',2502685.80,2502685.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257517',4903088,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257518',4903089,'2669','394',2308260.26,2308260.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257518',4903090,'2670','394',1320103.34,1320103.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257518',4903091,'2675','394',2502685.80,2502685.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257518',4903092,'2671','394',1981979.08,1981979.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257518',4903093,'2672','394',1300153.82,1300153.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257518',4903094,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257518',4903095,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257518',4903096,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257519',4903097,'2669','394',2308260.26,2308260.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257519',4903098,'2670','394',1320103.34,1320103.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257519',4903099,'2671','394',1981979.08,1981979.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257519',4903100,'2672','394',1300153.82,1300153.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257519',4903101,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257519',4903102,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257519',4903103,'2675','394',2502685.80,2502685.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257519',4903104,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257520',4903105,'2669','394',2308260.26,2308260.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257520',4903106,'2670','394',1320103.34,1320103.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257520',4903107,'2671','394',1981979.08,1981979.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257520',4903108,'2672','394',1300153.82,1300153.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257520',4903109,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257520',4903110,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257520',4903111,'2675','394',2502685.80,2502685.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257520',4903112,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257521',4903113,'2669','394',2308260.26,2308260.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257521',4903114,'2670','394',1320103.34,1320103.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257521',4903115,'2671','394',1981979.08,1981979.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257521',4903116,'2672','394',1300153.82,1300153.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257521',4903117,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257521',4903118,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257521',4903119,'2675','394',2502685.80,2502685.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257521',4903120,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257522',4903121,'2669','394',2308260.26,2309931.82,1671.56,275807.40,0.00,0.00,0.00,0.00,0.00),('5','104','895','257522',4903122,'2670','394',1320103.34,1320393.75,290.41,47917.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','257522',4903123,'2671','394',1981979.08,1981979.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257522',4903124,'2672','394',1300153.82,1300153.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257522',4903125,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257522',4903126,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257522',4903127,'2675','394',2502685.80,2503867.04,1181.24,194904.60,0.00,0.00,0.00,0.00,0.00),('5','104','896','257522',4903128,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257523',4903129,'2669','394',2309931.82,2313411.30,3479.48,574114.20,0.00,0.00,0.00,0.00,0.00),('5','104','895','257523',4903130,'2670','394',1320393.75,1320393.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257523',4903131,'2671','394',1981979.08,1981979.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257523',4903132,'2672','394',1300153.82,1300153.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257523',4903133,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257523',4903134,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257523',4903135,'2675','394',2503867.04,2507252.81,3385.77,558652.05,0.00,0.00,0.00,0.00,0.00),('5','104','896','257523',4903136,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257524',4903137,'2669','394',2313411.30,2317587.95,4176.65,689147.25,0.00,0.00,0.00,0.00,0.00),('5','104','895','257524',4903138,'2670','394',1320393.75,1320393.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257524',4903139,'2671','394',1981979.08,1981979.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257524',4903140,'2672','394',1300153.82,1300153.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257524',4903141,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257524',4903142,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257524',4903143,'2675','394',2507252.81,2510898.32,3645.51,601509.15,0.00,0.00,0.00,0.00,0.00),('5','104','896','257524',4903144,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257525',4903145,'2669','394',2317587.95,2322172.57,4584.62,756462.30,0.00,0.00,0.00,0.00,0.00),('5','104','895','257525',4903146,'2670','394',1320393.75,1320393.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257525',4903147,'2671','394',1981979.08,1981979.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257525',4903148,'2672','394',1300153.82,1300153.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257525',4903149,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257525',4903150,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257525',4903151,'2675','394',2510898.32,2515305.41,4407.09,727169.85,0.00,0.00,0.00,0.00,0.00),('5','104','896','257525',4903152,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257526',4903153,'2669','394',2322172.57,2325430.77,3258.20,537603.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257526',4903154,'2670','394',1320393.75,1320649.24,255.49,42155.85,0.00,0.00,0.00,0.00,0.00),('5','104','896','257526',4903155,'2671','394',1981979.08,1981979.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257526',4903156,'2672','394',1300153.82,1300153.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257526',4903157,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257526',4903158,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257526',4903159,'2675','394',2515305.41,2518817.17,3511.76,579440.40,0.00,0.00,0.00,0.00,0.00),('5','104','896','257526',4903160,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257527',4903161,'2669','394',2325430.77,2325430.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257527',4903162,'2670','394',1320649.24,1320649.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257527',4903163,'2671','394',1981979.08,1981979.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257527',4903164,'2672','394',1300153.82,1300153.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257527',4903165,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257527',4903166,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257527',4903167,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257527',4903168,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257528',4903169,'2669','394',2325430.77,2326961.97,1531.20,252648.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257528',4903170,'2670','394',1320649.24,1321859.88,1210.64,199755.60,0.00,0.00,0.00,0.00,0.00),('5','104','896','257528',4903171,'2671','394',1981979.08,1981979.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257528',4903172,'2672','394',1300153.82,1300153.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257528',4903173,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257528',4903174,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257528',4903175,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257528',4903176,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257529',4903177,'2669','394',2326961.97,2329518.87,2556.90,421888.50,0.00,0.00,0.00,0.00,0.00),('5','104','895','257529',4903178,'2670','394',1321859.88,1325927.24,4067.36,671114.40,0.00,0.00,0.00,0.00,0.00),('5','104','896','257529',4903179,'2671','394',1981979.08,1981979.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257529',4903180,'2672','394',1300153.82,1300153.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257529',4903181,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257529',4903182,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257529',4903183,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257529',4903184,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257530',4903185,'2669','394',2329518.87,2331831.24,2312.37,381541.05,0.00,0.00,0.00,0.00,0.00),('5','104','895','257530',4903186,'2670','394',1325927.24,1330608.78,4681.54,772454.10,0.00,0.00,0.00,0.00,0.00),('5','104','896','257530',4903187,'2671','394',1981979.08,1981979.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257530',4903188,'2672','394',1300153.82,1300153.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257530',4903189,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257530',4903190,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257530',4903191,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257530',4903192,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257531',4903193,'2669','394',2331831.24,2333813.70,1982.46,327105.90,0.00,0.00,0.00,0.00,0.00),('5','104','895','257531',4903194,'2670','394',1330608.78,1333681.49,3072.71,506997.15,0.00,0.00,0.00,0.00,0.00),('5','104','896','257531',4903195,'2671','394',1981979.08,1981979.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257531',4903196,'2672','394',1300153.82,1300153.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257531',4903197,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257531',4903198,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257531',4903199,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257531',4903200,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257532',4903201,'2669','394',2333813.70,2334945.00,1131.30,186664.50,0.00,0.00,0.00,0.00,0.00),('5','104','895','257532',4903202,'2670','394',1333681.49,1335662.73,1981.24,326904.60,0.00,0.00,0.00,0.00,0.00),('5','104','896','257532',4903203,'2671','394',1981979.08,1981979.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257532',4903204,'2672','394',1300153.82,1300153.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257532',4903205,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257532',4903206,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257532',4903207,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257532',4903208,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257533',4903209,'2669','394',2334945.00,2337108.14,2163.14,356918.10,0.00,0.00,0.00,0.00,0.00),('5','104','895','257533',4903210,'2670','394',1335662.73,1337644.35,1981.62,326967.30,0.00,0.00,0.00,0.00,0.00),('5','104','896','257533',4903211,'2671','394',1981979.08,1981979.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257533',4903212,'2672','394',1300153.82,1300153.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257533',4903213,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257533',4903214,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257533',4903215,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257533',4903216,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257534',4903217,'2669','394',2337108.14,2340694.69,3586.55,591780.75,0.00,0.00,0.00,0.00,0.00),('5','104','895','257534',4903218,'2670','394',1337644.35,1341797.00,4152.65,685187.25,0.00,0.00,0.00,0.00,0.00),('5','104','896','257534',4903219,'2671','394',1981979.08,1981979.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257534',4903220,'2672','394',1300153.82,1300153.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257534',4903221,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257534',4903222,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257534',4903223,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257534',4903224,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257535',4903225,'2669','394',2340694.69,2343535.78,2841.09,468779.85,0.00,0.00,0.00,0.00,0.00),('5','104','895','257535',4903226,'2670','394',1341797.00,1345426.38,3629.38,598847.70,0.00,0.00,0.00,0.00,0.00),('5','104','896','257535',4903227,'2671','394',1981979.08,1981979.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257535',4903228,'2672','394',1300153.82,1300153.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257535',4903229,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257535',4903230,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257535',4903231,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257535',4903232,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257536',4903233,'2669','394',2343535.78,2346660.99,3125.21,515659.65,0.00,0.00,0.00,0.00,0.00),('5','104','895','257536',4903234,'2670','394',1345426.38,1347715.70,2289.32,377737.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','257536',4903235,'2671','394',1981979.08,1981979.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257536',4903236,'2672','394',1300153.82,1300153.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257536',4903237,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257536',4903238,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257536',4903239,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257536',4903240,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257537',4903241,'2669','394',2346660.99,2346660.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257537',4903242,'2670','394',1347715.70,1350715.80,3000.10,495016.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','257537',4903243,'2671','394',1981979.08,1985274.36,3295.28,543721.20,0.00,0.00,0.00,0.00,0.00),('5','104','896','257537',4903244,'2672','394',1300153.82,1300153.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257537',4903245,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257537',4903246,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257537',4903247,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257537',4903248,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257538',4903249,'2669','394',2346660.99,2346660.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257538',4903250,'2670','394',1350715.80,1350715.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257538',4903251,'2671','394',1985274.36,1988875.33,3600.97,594160.05,0.00,0.00,0.00,0.00,0.00),('5','104','896','257538',4903252,'2672','394',1300153.82,1303063.82,2910.00,480150.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257538',4903253,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257538',4903254,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257538',4903255,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257538',4903256,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257539',4903257,'2669','394',2346660.99,2346660.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257539',4903258,'2670','394',1350715.80,1350715.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257539',4903259,'2671','394',1988875.33,1991900.35,3025.02,499128.30,0.00,0.00,0.00,0.00,0.00),('5','104','896','257539',4903260,'2672','394',1303063.82,1303063.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257539',4903261,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257539',4903262,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257539',4903263,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257539',4903264,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257540',4903265,'2669','394',2346660.99,2346660.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257540',4903266,'2670','394',1350715.80,1350715.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257540',4903267,'2671','394',1991900.35,1991900.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257540',4903268,'2672','394',1303063.82,1303063.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257540',4903269,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257540',4903270,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257540',4903271,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257540',4903272,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257541',4903273,'2669','394',2346660.99,2346660.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257541',4903274,'2670','394',1350715.80,1350715.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257541',4903275,'2671','394',1991900.35,1991900.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257541',4903276,'2672','394',1303063.82,1303063.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257541',4903277,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257541',4903278,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257541',4903279,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257541',4903280,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257542',4903281,'2669','394',2346660.99,2346660.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257542',4903282,'2670','394',1350715.80,1350715.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257542',4903283,'2671','394',1991900.35,1991900.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257542',4903284,'2672','394',1303063.82,1303063.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257542',4903285,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257542',4903286,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257542',4903287,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257542',4903288,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257543',4903289,'2669','394',2346660.99,2346660.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257543',4903290,'2670','394',1350715.80,1350715.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257543',4903291,'2671','394',1991900.35,1991900.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257543',4903292,'2672','394',1303063.82,1303063.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257543',4903293,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257543',4903294,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257543',4903295,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257543',4903296,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257544',4903297,'2669','394',2346660.99,2346660.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257544',4903298,'2670','394',1350715.80,1350715.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257544',4903299,'2671','394',1991900.35,1991900.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257544',4903300,'2672','394',1303063.82,1303063.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257544',4903301,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257544',4903302,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257544',4903303,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257544',4903304,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257545',4903305,'2669','394',2346660.99,2346660.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257545',4903306,'2670','394',1350715.80,1350715.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257545',4903307,'2671','394',1991900.35,1991900.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257545',4903308,'2672','394',1303063.82,1303063.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257545',4903309,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257545',4903310,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257545',4903311,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257545',4903312,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257546',4903313,'2669','394',2346660.99,2346660.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257546',4903314,'2670','394',1350715.80,1350715.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257546',4903315,'2671','394',1991900.35,1991900.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257546',4903316,'2672','394',1303063.82,1303063.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257546',4903317,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257546',4903318,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257546',4903319,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257546',4903320,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257547',4903321,'2669','394',2346660.99,2346660.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257547',4903322,'2670','394',1350715.80,1350715.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257547',4903323,'2671','394',1991900.35,1991900.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257547',4903324,'2672','394',1303063.82,1303063.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257547',4903325,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257547',4903326,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257547',4903327,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257547',4903328,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257548',4903329,'2669','394',2346660.99,2346660.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257548',4903330,'2670','394',1350715.80,1350715.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257548',4903331,'2671','394',1991900.35,1991900.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257548',4903332,'2672','394',1303063.82,1303063.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257548',4903333,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257548',4903334,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257548',4903335,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257548',4903336,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257549',4903337,'2669','394',2346660.99,2346660.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257549',4903338,'2670','394',1350715.80,1350715.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257549',4903339,'2671','394',1991900.35,1991900.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257549',4903340,'2672','394',1303063.82,1303063.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257549',4903341,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257549',4903342,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257549',4903343,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257549',4903344,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257550',4903345,'2669','394',2346660.99,2346660.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257550',4903346,'2670','394',1350715.80,1350715.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257550',4903347,'2671','394',1991900.35,1991900.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257550',4903348,'2672','394',1303063.82,1303063.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257550',4903349,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257550',4903350,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257550',4903351,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257550',4903352,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257551',4903353,'2669','394',2346660.99,2346660.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257551',4903354,'2670','394',1350715.80,1350715.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257551',4903355,'2671','394',1991900.35,1991900.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257551',4903356,'2672','394',1303063.82,1303063.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257551',4903357,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257551',4903358,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257551',4903359,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257551',4903360,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257552',4903361,'2669','394',2346660.99,2346660.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257552',4903362,'2670','394',1350715.80,1350715.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257552',4903363,'2671','394',1991900.35,1991900.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257552',4903364,'2672','394',1303063.82,1303063.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257552',4903365,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257552',4903366,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257552',4903367,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257552',4903368,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257553',4903369,'2669','394',2346660.99,2346660.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257553',4903370,'2670','394',1350715.80,1350715.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257553',4903371,'2671','394',1991900.35,1991900.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257553',4903372,'2672','394',1303063.82,1303063.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257553',4903373,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257553',4903374,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257553',4903375,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257553',4903376,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257554',4903377,'2669','394',2346660.99,2346660.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257554',4903378,'2670','394',1350715.80,1350715.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257554',4903379,'2671','394',1991900.35,1991900.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257554',4903380,'2672','394',1303063.82,1303063.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257554',4903381,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257554',4903382,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257554',4903383,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257554',4903384,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257555',4903385,'2669','394',2346660.99,2346660.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257555',4903386,'2670','394',1350715.80,1350715.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257555',4903387,'2671','394',1991900.35,1991900.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257555',4903388,'2672','394',1303063.82,1303063.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257555',4903389,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257555',4903390,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257555',4903391,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257555',4903392,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257556',4903393,'2669','394',2346660.99,2346660.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257556',4903394,'2670','394',1350715.80,1350715.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257556',4903395,'2671','394',1991900.35,1991900.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257556',4903396,'2672','394',1303063.82,1303063.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257556',4903397,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257556',4903398,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257556',4903399,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257556',4903400,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257557',4903401,'2669','394',2346660.99,2346660.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257557',4903402,'2670','394',1350715.80,1350715.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257557',4903403,'2671','394',1991900.35,1991900.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257557',4903404,'2672','394',1303063.82,1303063.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257557',4903405,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257557',4903406,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257557',4903407,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257557',4903408,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257558',4903409,'2669','394',2346660.99,2346660.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257558',4903410,'2670','394',1350715.80,1350715.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257558',4903411,'2671','394',1991900.35,1991900.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257558',4903412,'2672','394',1303063.82,1303063.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257558',4903413,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257558',4903414,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257558',4903415,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257558',4903416,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257559',4903417,'2669','394',2346660.99,2346660.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257559',4903418,'2670','394',1350715.80,1350715.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257559',4903419,'2671','394',1991900.35,1991900.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257559',4903420,'2672','394',1303063.82,1303063.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257559',4903421,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257559',4903422,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257559',4903423,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257559',4903424,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257560',4903425,'2669','394',2346660.99,2346660.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257560',4903426,'2670','394',1350715.80,1350715.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257560',4903427,'2671','394',1991900.35,1991900.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257560',4903428,'2672','394',1303063.82,1303063.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257560',4903429,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257560',4903430,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257560',4903431,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257560',4903432,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257561',4903433,'2669','394',2346660.99,2346660.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257561',4903434,'2670','394',1350715.80,1350715.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257561',4903435,'2671','394',1991900.35,1991900.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257561',4903436,'2672','394',1303063.82,1303063.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257561',4903437,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257561',4903438,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257561',4903439,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257561',4903440,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257562',4903441,'2669','394',2346660.99,2346660.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257562',4903442,'2670','394',1350715.80,1350715.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257562',4903443,'2671','394',1991900.35,1991900.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257562',4903444,'2672','394',1303063.82,1303063.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257562',4903445,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257562',4903446,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257562',4903447,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257562',4903448,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257563',4903449,'2669','394',2346660.99,2346660.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257563',4903450,'2670','394',1350715.80,1350715.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257563',4903451,'2671','394',1991900.35,1991900.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257563',4903452,'2672','394',1303063.82,1303063.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257563',4903453,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257563',4903454,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257563',4903455,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257563',4903456,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257564',4903457,'2669','394',2346660.99,2346660.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257564',4903458,'2670','394',1350715.80,1350715.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257564',4903459,'2671','394',1991900.35,1991900.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257564',4903460,'2672','394',1303063.82,1303063.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257564',4903461,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257564',4903462,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257564',4903463,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257564',4903464,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257565',4903465,'2669','394',2346660.99,2346660.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257565',4903466,'2670','394',1350715.80,1350715.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257565',4903467,'2671','394',1991900.35,1991900.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257565',4903468,'2672','394',1303063.82,1303063.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257565',4903469,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257565',4903470,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257565',4903471,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257565',4903472,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257566',4903473,'2669','394',2346660.99,2346660.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257566',4903474,'2670','394',1350715.80,1350715.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257566',4903475,'2671','394',1991900.35,1991900.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257566',4903476,'2672','394',1303063.82,1303063.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257566',4903477,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257566',4903478,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257566',4903479,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257566',4903480,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257567',4903481,'2669','394',2346660.99,2347981.50,1320.51,217884.15,0.00,0.00,0.00,0.00,0.00),('5','104','895','257567',4903482,'2670','394',1350715.80,1351929.49,1213.69,200258.85,0.00,0.00,0.00,0.00,0.00),('5','104','896','257567',4903483,'2671','394',1991900.35,1991900.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257567',4903484,'2672','394',1303063.82,1303063.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257567',4903485,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257567',4903486,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257567',4903487,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257567',4903488,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257568',4903489,'2669','394',2347981.50,2350913.98,2932.48,483859.20,0.00,0.00,0.00,0.00,0.00),('5','104','895','257568',4903490,'2670','394',1351929.49,1354437.16,2507.67,413765.55,0.00,0.00,0.00,0.00,0.00),('5','104','896','257568',4903491,'2671','394',1991900.35,1991900.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257568',4903492,'2672','394',1303063.82,1303063.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257568',4903493,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257568',4903494,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257568',4903495,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257568',4903496,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257569',4903497,'2669','394',2350913.98,2353549.23,2635.25,434816.25,0.00,0.00,0.00,0.00,0.00),('5','104','895','257569',4903498,'2670','394',1354437.16,1357517.43,3080.27,508244.55,0.00,0.00,0.00,0.00,0.00),('5','104','896','257569',4903499,'2671','394',1991900.35,1991900.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257569',4903500,'2672','394',1303063.82,1303063.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257569',4903501,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257569',4903502,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257569',4903503,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257569',4903504,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257570',4903505,'2669','394',2353549.23,2356343.30,2794.07,516902.95,0.00,0.00,0.00,0.00,0.00),('5','104','895','257570',4903506,'2670','394',1357517.43,1360682.75,3165.32,585584.20,0.00,0.00,0.00,0.00,0.00),('5','104','896','257570',4903507,'2671','394',1991900.35,1991900.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257570',4903508,'2672','394',1303063.82,1303063.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257570',4903509,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257570',4903510,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257570',4903511,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257570',4903512,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257571',4903513,'2669','394',2356343.30,2358704.74,2361.44,436866.40,0.00,0.00,0.00,0.00,0.00),('5','104','895','257571',4903514,'2670','394',1360682.75,1363649.13,2966.38,548780.30,0.00,0.00,0.00,0.00,0.00),('5','104','896','257571',4903515,'2671','394',1991900.35,1991900.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257571',4903516,'2672','394',1303063.82,1303063.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257571',4903517,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257571',4903518,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257571',4903519,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257571',4903520,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257572',4903521,'2669','394',2358704.74,2361047.74,2343.00,433455.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257572',4903522,'2670','394',1363649.13,1369018.14,5369.01,993266.85,0.00,0.00,0.00,0.00,0.00),('5','104','896','257572',4903523,'2671','394',1991900.35,1991900.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257572',4903524,'2672','394',1303063.82,1303063.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257572',4903525,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257572',4903526,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257572',4903527,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257572',4903528,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257573',4903529,'2669','394',2361047.74,2361047.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257573',4903530,'2670','394',1369018.14,1369018.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257573',4903531,'2671','394',1991900.35,1996665.27,4764.92,881510.20,0.00,0.00,0.00,0.00,0.00),('5','104','896','257573',4903532,'2672','394',1303063.82,1307261.04,4197.22,776485.70,0.00,0.00,0.00,0.00,0.00),('5','104','897','257573',4903533,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257573',4903534,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257573',4903535,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257573',4903536,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257574',4903537,'2669','394',2361047.74,2366757.13,5709.39,1056237.15,0.00,0.00,0.00,0.00,0.00),('5','104','895','257574',4903538,'2670','394',1369018.14,1369018.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257574',4903539,'2671','394',1996665.27,1996665.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257574',4903540,'2672','394',1307261.04,1312383.65,5122.61,947682.85,0.00,0.00,0.00,0.00,0.00),('5','104','897','257574',4903541,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257574',4903542,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257574',4903543,'2675','394',2518817.17,2518817.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257574',4903544,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257575',4903545,'2669','394',2366757.13,2369299.89,2542.76,470410.60,0.00,0.00,0.00,0.00,0.00),('5','104','895','257575',4903546,'2670','394',1369018.14,1369018.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257575',4903547,'2671','394',1996665.27,1997670.03,1004.76,185880.60,0.00,0.00,0.00,0.00,0.00),('5','104','896','257575',4903548,'2672','394',1312383.65,1313828.40,1444.75,267278.75,0.00,0.00,0.00,0.00,0.00),('5','104','897','257575',4903549,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257575',4903550,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257575',4903551,'2675','394',2518817.17,2522605.77,3788.60,700891.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257575',4903552,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257576',4903553,'2669','394',2369299.89,2375639.77,6339.88,1172877.80,0.00,0.00,0.00,0.00,0.00),('5','104','895','257576',4903554,'2670','394',1369018.14,1370804.12,1785.98,330406.30,0.00,0.00,0.00,0.00,0.00),('5','104','896','257576',4903555,'2671','394',1997670.03,1997670.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257576',4903556,'2672','394',1313828.40,1313828.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257576',4903557,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257576',4903558,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257576',4903559,'2675','394',2522605.77,2528872.65,6266.88,1159372.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','257576',4903560,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257577',4903561,'2669','394',2375639.77,2375639.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257577',4903562,'2670','394',1370804.12,1370804.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257577',4903563,'2671','394',1997670.03,2001566.35,3896.32,720819.20,0.00,0.00,0.00,0.00,0.00),('5','104','896','257577',4903564,'2672','394',1313828.40,1318339.47,4511.07,834547.95,0.00,0.00,0.00,0.00,0.00),('5','104','897','257577',4903565,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257577',4903566,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257577',4903567,'2675','394',2528872.65,2528872.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257577',4903568,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257578',4903569,'2669','394',2375639.77,2375757.76,117.99,21828.15,0.00,0.00,0.00,0.00,0.00),('5','104','895','257578',4903570,'2670','394',1370804.12,1370824.71,20.59,3809.15,0.00,0.00,0.00,0.00,0.00),('5','104','896','257578',4903571,'2671','394',2001566.35,2009509.42,7943.07,1469467.95,0.00,0.00,0.00,0.00,0.00),('5','104','896','257578',4903572,'2672','394',1318339.47,1319871.42,1531.95,283410.75,0.00,0.00,0.00,0.00,0.00),('5','104','897','257578',4903573,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257578',4903574,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257578',4903575,'2675','394',2528872.65,2528882.92,10.27,1899.95,0.00,0.00,0.00,0.00,0.00),('5','104','896','257578',4903576,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257579',4903577,'2669','394',2375757.76,2377975.90,2218.14,410355.90,0.00,0.00,0.00,0.00,0.00),('5','104','895','257579',4903578,'2670','394',1370824.71,1372620.11,1795.40,332149.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257579',4903579,'2671','394',2009509.42,2010203.64,694.22,128430.70,0.00,0.00,0.00,0.00,0.00),('5','104','896','257579',4903580,'2672','394',1319871.42,1322771.18,2899.76,536455.60,0.00,0.00,0.00,0.00,0.00),('5','104','897','257579',4903581,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257579',4903582,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257579',4903583,'2675','394',2528882.92,2528882.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257579',4903584,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257580',4903585,'2669','394',2377975.90,2380160.20,2184.30,404095.50,0.00,0.00,0.00,0.00,0.00),('5','104','895','257580',4903586,'2670','394',1372620.11,1372620.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257580',4903587,'2671','394',2010203.64,2012070.14,1866.50,345302.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','257580',4903588,'2672','394',1322771.18,1327808.08,5036.90,931826.50,0.00,0.00,0.00,0.00,0.00),('5','104','897','257580',4903589,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257580',4903590,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257580',4903591,'2675','394',2528882.92,2528882.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257580',4903592,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257581',4903593,'2669','394',2380160.20,2382515.22,2355.02,435678.70,0.00,0.00,0.00,0.00,0.00),('5','104','895','257581',4903594,'2670','394',1372620.11,1374715.63,2095.52,387671.20,0.00,0.00,0.00,0.00,0.00),('5','104','896','257581',4903595,'2671','394',2012070.14,2015177.28,3107.14,574820.90,0.00,0.00,0.00,0.00,0.00),('5','104','896','257581',4903596,'2672','394',1327808.08,1329063.72,1255.64,232293.40,0.00,0.00,0.00,0.00,0.00),('5','104','897','257581',4903597,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257581',4903598,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257581',4903599,'2675','394',2528882.92,2528882.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257581',4903600,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257582',4903601,'2669','394',2382515.22,2385154.86,2639.64,488333.40,0.00,0.00,0.00,0.00,0.00),('5','104','895','257582',4903602,'2670','394',1374715.63,1378388.15,3672.52,679416.20,0.00,0.00,0.00,0.00,0.00),('5','104','896','257582',4903603,'2671','394',2015177.28,2015177.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257582',4903604,'2672','394',1329063.72,1329063.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257582',4903605,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257582',4903606,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257582',4903607,'2675','394',2528882.92,2530613.22,1730.30,320105.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','257582',4903608,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257583',4903609,'2669','394',2385154.86,2389162.36,4007.50,741387.50,0.00,0.00,0.00,0.00,0.00),('5','104','895','257583',4903610,'2670','394',1378388.15,1380898.88,2510.73,464485.05,0.00,0.00,0.00,0.00,0.00),('5','104','896','257583',4903611,'2671','394',2015177.28,2015177.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257583',4903612,'2672','394',1329063.72,1329063.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257583',4903613,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257583',4903614,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257583',4903615,'2675','394',2530613.22,2532602.62,1989.40,368039.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257583',4903616,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257584',4903617,'2669','394',2389162.36,2393515.19,4352.83,805273.55,0.00,0.00,0.00,0.00,0.00),('5','104','895','257584',4903618,'2670','394',1380898.88,1385579.29,4680.41,865875.85,0.00,0.00,0.00,0.00,0.00),('5','104','896','257584',4903619,'2671','394',2015177.28,2015177.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257584',4903620,'2672','394',1329063.72,1329063.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257584',4903621,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257584',4903622,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257584',4903623,'2675','394',2532602.62,2532602.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257584',4903624,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257585',4903625,'2669','394',2393515.19,2393515.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257585',4903626,'2670','394',1385579.29,1391668.26,6088.97,1126459.45,0.00,0.00,0.00,0.00,0.00),('5','104','896','257585',4903627,'2671','394',2015177.28,2015177.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257585',4903628,'2672','394',1329063.72,1329063.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257585',4903629,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257585',4903630,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257585',4903631,'2675','394',2532602.62,2533658.05,1055.43,195254.55,0.00,0.00,0.00,0.00,0.00),('5','104','896','257585',4903632,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257586',4903633,'2669','394',2393515.19,2396775.04,3259.85,603072.25,0.00,0.00,0.00,0.00,0.00),('5','104','895','257586',4903634,'2670','394',1391668.26,1394809.47,3141.21,581123.85,0.00,0.00,0.00,0.00,0.00),('5','104','896','257586',4903635,'2671','394',2015177.28,2015177.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257586',4903636,'2672','394',1329063.72,1329063.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257586',4903637,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257586',4903638,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257586',4903639,'2675','394',2533658.05,2533658.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257586',4903640,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257587',4903641,'2669','394',2396775.04,2397988.68,1213.64,224523.40,0.00,0.00,0.00,0.00,0.00),('5','104','895','257587',4903642,'2670','394',1394809.47,1396229.31,1419.84,262670.40,0.00,0.00,0.00,0.00,0.00),('5','104','896','257587',4903643,'2671','394',2015177.28,2015177.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257587',4903644,'2672','394',1329063.72,1329063.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257587',4903645,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257587',4903646,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257587',4903647,'2675','394',2533658.05,2533658.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257587',4903648,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257588',4903649,'2669','394',2397988.68,2397988.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257588',4903650,'2670','394',1396229.31,1396229.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257588',4903651,'2671','394',2015177.28,2015177.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257588',4903652,'2672','394',1329063.72,1329063.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257588',4903653,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257588',4903654,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257588',4903655,'2675','394',2533658.05,2533658.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257588',4903656,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257589',4903657,'2669','394',2397988.68,2397988.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257589',4903658,'2670','394',1396229.31,1396229.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257589',4903659,'2671','394',2015177.28,2015177.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257589',4903660,'2672','394',1329063.72,1329063.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257589',4903661,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257589',4903662,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257589',4903663,'2675','394',2533658.05,2533658.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257589',4903664,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257590',4903665,'2669','394',2397988.68,2397988.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257590',4903666,'2670','394',1396229.31,1396229.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257590',4903667,'2671','394',2015177.28,2015177.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257590',4903668,'2672','394',1329063.72,1329063.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257590',4903669,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257590',4903670,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257590',4903671,'2675','394',2533658.05,2533658.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257590',4903672,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257591',4903673,'2669','394',2397988.68,2399499.91,1511.23,279577.55,0.00,0.00,0.00,0.00,0.00),('5','104','895','257591',4903674,'2670','394',1396229.31,1396229.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257591',4903675,'2675','394',2533658.05,2533658.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257591',4903676,'2671','394',2015177.28,2015177.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257591',4903677,'2672','394',1329063.72,1330266.86,1203.14,222580.90,0.00,0.00,0.00,0.00,0.00),('5','104','896','257591',4903678,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257591',4903679,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257591',4903680,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257592',4903681,'2669','394',2399499.91,2402088.37,2588.46,478865.10,0.00,0.00,0.00,0.00,0.00),('5','104','895','257592',4903682,'2670','394',1396229.31,1399463.54,3234.23,598332.55,0.00,0.00,0.00,0.00,0.00),('5','104','896','257592',4903683,'2671','394',2015177.28,2016992.66,1815.38,335845.30,0.00,0.00,0.00,0.00,0.00),('5','104','896','257592',4903684,'2672','394',1330266.86,1330832.64,565.78,104669.30,0.00,0.00,0.00,0.00,0.00),('5','104','897','257592',4903685,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257592',4903686,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257592',4903687,'2675','394',2533658.05,2533658.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257592',4903688,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257593',4903689,'2669','394',2402088.37,2404572.20,2483.83,459508.55,0.00,0.00,0.00,0.00,0.00),('5','104','895','257593',4903690,'2670','394',1399463.54,1403261.23,3797.69,702572.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','257593',4903691,'2671','394',2016992.66,2016992.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257593',4903692,'2672','394',1330832.64,1330832.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257593',4903693,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257593',4903694,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257593',4903695,'2675','394',2533658.05,2533658.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257593',4903696,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257594',4903697,'2669','394',2404572.20,2408542.51,3970.31,734507.35,0.00,0.00,0.00,0.00,0.00),('5','104','895','257594',4903698,'2670','394',1403261.23,1407127.87,3866.64,715328.40,0.00,0.00,0.00,0.00,0.00),('5','104','896','257594',4903699,'2671','394',2016992.66,2016992.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257594',4903700,'2672','394',1330832.64,1330832.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257594',4903701,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257594',4903702,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257594',4903703,'2675','394',2533658.05,2533658.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257594',4903704,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257595',4903705,'2669','394',2408542.51,2408542.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257595',4903706,'2670','394',1407127.87,1407127.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257595',4903707,'2671','394',2016992.66,2021017.24,4024.58,744547.30,0.00,0.00,0.00,0.00,0.00),('5','104','896','257595',4903708,'2672','394',1330832.64,1332809.17,1976.53,365658.05,0.00,0.00,0.00,0.00,0.00),('5','104','897','257595',4903709,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257595',4903710,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257595',4903711,'2675','394',2533658.05,2533658.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257595',4903712,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257596',4903713,'2669','394',2408542.51,2408542.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257596',4903714,'2670','394',1407127.87,1407127.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257596',4903715,'2671','394',2021017.24,2024410.91,3393.67,627828.95,0.00,0.00,0.00,0.00,0.00),('5','104','896','257596',4903716,'2672','394',1332809.17,1339453.14,6643.97,1229134.45,0.00,0.00,0.00,0.00,0.00),('5','104','897','257596',4903717,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257596',4903718,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257596',4903719,'2675','394',2533658.05,2533658.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257596',4903720,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257597',4903721,'2669','394',2408542.51,2408542.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257597',4903722,'2670','394',1407127.87,1407127.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257597',4903723,'2671','394',2024410.91,2025936.29,1525.38,282195.30,0.00,0.00,0.00,0.00,0.00),('5','104','896','257597',4903724,'2672','394',1339453.14,1341836.57,2383.43,440934.55,0.00,0.00,0.00,0.00,0.00),('5','104','897','257597',4903725,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257597',4903726,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257597',4903727,'2675','394',2533658.05,2533658.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257597',4903728,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257598',4903729,'2669','394',2408542.51,2408542.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257598',4903730,'2670','394',1407127.87,1407127.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257598',4903731,'2671','394',2025936.29,2025936.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257598',4903732,'2672','394',1341836.57,1341836.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257598',4903733,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257598',4903734,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257598',4903735,'2675','394',2533658.05,2533658.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257598',4903736,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257599',4903737,'2669','394',2408542.51,2408542.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257599',4903738,'2670','394',1407127.87,1407127.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257599',4903739,'2671','394',2025936.29,2025936.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257599',4903740,'2672','394',1341836.57,1341836.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257599',4903741,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257599',4903742,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257599',4903743,'2675','394',2533658.05,2533658.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257599',4903744,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257600',4903745,'2669','394',2408542.51,2410352.11,1809.60,334776.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257600',4903746,'2670','394',1407127.87,1408432.84,1304.97,241419.45,0.00,0.00,0.00,0.00,0.00),('5','104','896','257600',4903747,'2671','394',2025936.29,2025936.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257600',4903748,'2672','394',1341836.57,1341836.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257600',4903749,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257600',4903750,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257600',4903751,'2675','394',2533658.05,2533658.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257600',4903752,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257601',4903753,'2669','394',2410352.11,2412164.80,1812.69,335347.65,0.00,0.00,0.00,0.00,0.00),('5','104','895','257601',4903754,'2670','394',1408432.84,1410611.99,2179.15,403142.75,0.00,0.00,0.00,0.00,0.00),('5','104','896','257601',4903755,'2671','394',2025936.29,2026732.29,796.00,147260.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257601',4903756,'2672','394',1341836.57,1345075.54,3238.97,599209.45,0.00,0.00,0.00,0.00,0.00),('5','104','897','257601',4903757,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257601',4903758,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257601',4903759,'2675','394',2533658.05,2533658.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257601',4903760,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257602',4903761,'2669','394',2412164.80,2412164.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257602',4903762,'2670','394',1410611.99,1413635.39,3023.40,559329.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257602',4903763,'2675','394',2533658.05,2533658.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257602',4903764,'2671','394',2026732.29,2032274.82,5542.53,1025368.05,0.00,0.00,0.00,0.00,0.00),('5','104','896','257602',4903765,'2672','394',1345075.54,1345371.26,295.72,54708.20,0.00,0.00,0.00,0.00,0.00),('5','104','896','257602',4903766,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257602',4903767,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257602',4903768,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257603',4903769,'2669','394',2412164.80,2412184.80,20.00,3700.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257603',4903770,'2670','394',1413635.39,1417444.30,3808.91,704648.35,0.00,0.00,0.00,0.00,0.00),('5','104','896','257603',4903771,'2671','394',2032274.82,2036035.90,3761.08,695799.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','257603',4903772,'2672','394',1345371.26,1346546.39,1175.13,217399.05,0.00,0.00,0.00,0.00,0.00),('5','104','897','257603',4903773,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257603',4903774,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257603',4903775,'2675','394',2533658.05,2533658.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257603',4903776,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257604',4903777,'2669','394',2412184.80,2413798.86,1614.06,298601.10,0.00,0.00,0.00,0.00,0.00),('5','104','895','257604',4903778,'2670','394',1417444.30,1418787.28,1342.98,248451.30,0.00,0.00,0.00,0.00,0.00),('5','104','896','257604',4903779,'2671','394',2036035.90,2037753.38,1717.48,317733.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','257604',4903780,'2672','394',1346546.39,1348612.86,2066.47,382296.95,0.00,0.00,0.00,0.00,0.00),('5','104','897','257604',4903781,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257604',4903782,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257604',4903783,'2675','394',2533658.05,2533658.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257604',4903784,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257605',4903785,'2669','394',2413798.86,2413798.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257605',4903786,'2670','394',1418787.28,1421045.63,2258.35,417794.75,0.00,0.00,0.00,0.00,0.00),('5','104','896','257605',4903787,'2671','394',2037753.38,2041105.28,3351.90,620101.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','257605',4903788,'2672','394',1348612.86,1351743.77,3130.91,579218.35,0.00,0.00,0.00,0.00,0.00),('5','104','897','257605',4903789,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257605',4903790,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257605',4903791,'2675','394',2533658.05,2533658.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257605',4903792,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257606',4903793,'2669','394',2413798.86,2417060.79,3261.93,603457.05,0.00,0.00,0.00,0.00,0.00),('5','104','895','257606',4903794,'2670','394',1421045.63,1422146.12,1100.49,203590.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','257606',4903795,'2671','394',2041105.28,2042797.18,1691.90,313001.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','257606',4903796,'2672','394',1351743.77,1352242.11,498.34,92192.90,0.00,0.00,0.00,0.00,0.00),('5','104','897','257606',4903797,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257606',4903798,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257606',4903799,'2675','394',2533658.05,2533658.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257606',4903800,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257607',4903801,'2669','394',2417060.79,2419044.05,1983.26,366903.10,0.00,0.00,0.00,0.00,0.00),('5','104','895','257607',4903802,'2670','394',1422146.12,1423494.33,1348.21,249418.85,0.00,0.00,0.00,0.00,0.00),('5','104','896','257607',4903803,'2671','394',2042797.18,2045738.82,2941.64,544203.40,0.00,0.00,0.00,0.00,0.00),('5','104','896','257607',4903804,'2672','394',1352242.11,1354047.84,1805.73,334060.05,0.00,0.00,0.00,0.00,0.00),('5','104','897','257607',4903805,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257607',4903806,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257607',4903807,'2675','394',2533658.05,2533658.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257607',4903808,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257608',4903809,'2669','394',2419044.05,2420536.67,1492.62,276134.70,0.00,0.00,0.00,0.00,0.00),('5','104','895','257608',4903810,'2670','394',1423494.33,1426163.57,2669.24,493809.40,0.00,0.00,0.00,0.00,0.00),('5','104','895','257608',4903811,'2675','394',2533658.05,2533658.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257608',4903812,'2671','394',2045738.82,2048293.73,2554.91,472658.35,0.00,0.00,0.00,0.00,0.00),('5','104','896','257608',4903813,'2672','394',1354047.84,1354752.81,704.97,130419.45,0.00,0.00,0.00,0.00,0.00),('5','104','896','257608',4903814,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257608',4903815,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257608',4903816,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257609',4903817,'2669','394',2420536.67,2422821.13,2284.46,422625.10,0.00,0.00,0.00,0.00,0.00),('5','104','895','257609',4903818,'2670','394',1426163.57,1427340.77,1177.20,217782.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257609',4903819,'2675','394',2533658.05,2533658.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257609',4903820,'2671','394',2048293.73,2048740.84,447.11,82715.35,0.00,0.00,0.00,0.00,0.00),('5','104','896','257609',4903821,'2672','394',1354752.81,1356643.52,1890.71,349781.35,0.00,0.00,0.00,0.00,0.00),('5','104','896','257609',4903822,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257609',4903823,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257609',4903824,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257610',4903825,'2669','394',2422821.13,2425048.70,2227.57,412100.45,0.00,0.00,0.00,0.00,0.00),('5','104','895','257610',4903826,'2670','394',1427340.77,1429394.70,2053.93,379977.05,0.00,0.00,0.00,0.00,0.00),('5','104','895','257610',4903827,'2675','394',2533658.05,2533658.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257610',4903828,'2671','394',2048740.84,2050746.81,2005.97,371104.45,0.00,0.00,0.00,0.00,0.00),('5','104','896','257610',4903829,'2672','394',1356643.52,1356643.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257610',4903830,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257610',4903831,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257610',4903832,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257611',4903833,'2669','394',2425048.70,2426225.19,1176.49,217650.65,0.00,0.00,0.00,0.00,0.00),('5','104','895','257611',4903834,'2670','394',1429394.70,1431047.81,1653.11,305825.35,0.00,0.00,0.00,0.00,0.00),('5','104','896','257611',4903835,'2671','394',2050746.81,2052620.12,1873.31,346562.35,0.00,0.00,0.00,0.00,0.00),('5','104','896','257611',4903836,'2672','394',1356643.52,1356643.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257611',4903837,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257611',4903838,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257611',4903839,'2675','394',2533658.05,2533658.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257611',4903840,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257612',4903841,'2669','394',2426225.19,2427898.08,1672.89,309484.65,0.00,0.00,0.00,0.00,0.00),('5','104','895','257612',4903842,'2670','394',1431047.81,1433391.83,2344.02,433643.70,0.00,0.00,0.00,0.00,0.00),('5','104','896','257612',4903843,'2671','394',2052620.12,2054977.07,2356.95,436035.75,0.00,0.00,0.00,0.00,0.00),('5','104','896','257612',4903844,'2672','394',1356643.52,1356643.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257612',4903845,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257612',4903846,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257612',4903847,'2675','394',2533658.05,2533658.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257612',4903848,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257613',4903849,'2669','394',2427898.08,2427898.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257613',4903850,'2670','394',1433391.83,1433752.54,360.71,66731.35,0.00,0.00,0.00,0.00,0.00),('5','104','896','257613',4903851,'2671','394',2054977.07,2057508.82,2531.75,468373.75,0.00,0.00,0.00,0.00,0.00),('5','104','896','257613',4903852,'2672','394',1356643.52,1357995.42,1351.90,250101.50,0.00,0.00,0.00,0.00,0.00),('5','104','897','257613',4903853,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257613',4903854,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257613',4903855,'2675','394',2533658.05,2533658.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257613',4903856,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257614',4903857,'2669','394',2427898.08,2427898.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257614',4903858,'2670','394',1433752.54,1433752.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257614',4903859,'2671','394',2057508.82,2058772.25,1263.43,233734.55,0.00,0.00,0.00,0.00,0.00),('5','104','896','257614',4903860,'2672','394',1357995.42,1357995.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257614',4903861,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257614',4903862,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257614',4903863,'2675','394',2533658.05,2533658.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257614',4903864,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257615',4903865,'2669','394',2427898.08,2430187.28,2289.20,423502.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257615',4903866,'2670','394',1433752.54,1435992.63,2240.09,414416.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','257615',4903867,'2671','394',2058772.25,2060946.40,2174.15,402217.75,0.00,0.00,0.00,0.00,0.00),('5','104','896','257615',4903868,'2672','394',1357995.42,1359311.11,1315.69,243402.65,0.00,0.00,0.00,0.00,0.00),('5','104','897','257615',4903869,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257615',4903870,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257615',4903871,'2675','394',2533658.05,2533658.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257615',4903872,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257616',4903873,'2669','394',2430187.28,2432856.88,2669.60,493876.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257616',4903874,'2670','394',1435992.63,1438042.08,2049.45,379148.25,0.00,0.00,0.00,0.00,0.00),('5','104','896','257616',4903875,'2671','394',2060946.40,2063261.55,2315.15,428302.75,0.00,0.00,0.00,0.00,0.00),('5','104','896','257616',4903876,'2672','394',1359311.11,1360663.85,1352.74,250256.90,0.00,0.00,0.00,0.00,0.00),('5','104','897','257616',4903877,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257616',4903878,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257616',4903879,'2675','394',2533658.05,2533658.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257616',4903880,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257617',4903881,'2669','394',2432856.88,2435299.46,2442.58,451877.30,0.00,0.00,0.00,0.00,0.00),('5','104','895','257617',4903882,'2670','394',1438042.08,1440048.16,2006.08,371124.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','257617',4903883,'2671','394',2063261.55,2065386.82,2125.27,393174.95,0.00,0.00,0.00,0.00,0.00),('5','104','896','257617',4903884,'2672','394',1360663.85,1362145.91,1482.06,274181.10,0.00,0.00,0.00,0.00,0.00),('5','104','897','257617',4903885,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257617',4903886,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257617',4903887,'2675','394',2533658.05,2533658.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257617',4903888,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257618',4903889,'2669','394',2435299.46,2438635.05,3335.59,617084.15,0.00,0.00,0.00,0.00,0.00),('5','104','895','257618',4903890,'2670','394',1440048.16,1443098.78,3050.62,564364.70,0.00,0.00,0.00,0.00,0.00),('5','104','896','257618',4903891,'2671','394',2065386.82,2067528.58,2141.76,396225.60,0.00,0.00,0.00,0.00,0.00),('5','104','896','257618',4903892,'2672','394',1362145.91,1362345.04,199.13,36839.05,0.00,0.00,0.00,0.00,0.00),('5','104','897','257618',4903893,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257618',4903894,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257618',4903895,'2675','394',2533658.05,2533658.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257618',4903896,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257619',4903897,'2669','394',2438635.05,2441669.73,3034.68,561415.80,0.00,0.00,0.00,0.00,0.00),('5','104','895','257619',4903898,'2670','394',1443098.78,1444907.94,1809.16,334694.60,0.00,0.00,0.00,0.00,0.00),('5','104','896','257619',4903899,'2671','394',2067528.58,2067528.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257619',4903900,'2672','394',1362345.04,1362345.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257619',4903901,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257619',4903902,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257619',4903903,'2675','394',2533658.05,2533658.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257619',4903904,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257620',4903905,'2669','394',2441669.73,2441669.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257620',4903906,'2670','394',1444907.94,1446230.16,1322.22,244610.70,0.00,0.00,0.00,0.00,0.00),('5','104','896','257620',4903907,'2671','394',2067528.58,2067528.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257620',4903908,'2672','394',1362345.04,1362345.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257620',4903909,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257620',4903910,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257620',4903911,'2675','394',2533658.05,2533658.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257620',4903912,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257621',4903913,'2669','394',2441669.73,2442277.18,607.45,112378.25,0.00,0.00,0.00,0.00,0.00),('5','104','895','257621',4903914,'2670','394',1446230.16,1446782.07,551.91,102103.35,0.00,0.00,0.00,0.00,0.00),('5','104','896','257621',4903915,'2671','394',2067528.58,2067695.78,167.20,30932.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257621',4903916,'2672','394',1362345.04,1362345.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257621',4903917,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257621',4903918,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257621',4903919,'2675','394',2533658.05,2533658.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257621',4903920,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257622',4903921,'2669','394',2442277.18,2446767.27,4490.09,830666.65,0.00,0.00,0.00,0.00,0.00),('5','104','895','257622',4903922,'2670','394',1446782.07,1450607.03,3824.96,707617.60,0.00,0.00,0.00,0.00,0.00),('5','104','896','257622',4903923,'2671','394',2067695.78,2071920.47,4224.69,781567.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','257622',4903924,'2672','394',1362345.04,1364396.65,2051.61,379547.85,0.00,0.00,0.00,0.00,0.00),('5','104','897','257622',4903925,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257622',4903926,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257622',4903927,'2675','394',2533658.05,2533658.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257622',4903928,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257623',4903929,'2669','394',2446767.27,2450788.40,4021.13,743909.05,0.00,0.00,0.00,0.00,0.00),('5','104','895','257623',4903930,'2670','394',1450607.03,1454440.67,3833.64,709223.40,0.00,0.00,0.00,0.00,0.00),('5','104','896','257623',4903931,'2671','394',2071920.47,2075639.59,3719.12,688037.20,0.00,0.00,0.00,0.00,0.00),('5','104','896','257623',4903932,'2672','394',1364396.65,1366031.51,1634.86,302449.10,0.00,0.00,0.00,0.00,0.00),('5','104','897','257623',4903933,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257623',4903934,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257623',4903935,'2675','394',2533658.05,2533658.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257623',4903936,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257624',4903937,'2669','394',2450788.40,2455702.04,4913.64,909023.40,0.00,0.00,0.00,0.00,0.00),('5','104','895','257624',4903938,'2670','394',1454440.67,1459143.43,4702.76,870010.60,0.00,0.00,0.00,0.00,0.00),('5','104','896','257624',4903939,'2671','394',2075639.59,2079027.25,3387.66,626717.10,0.00,0.00,0.00,0.00,0.00),('5','104','896','257624',4903940,'2672','394',1366031.51,1366031.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257624',4903941,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257624',4903942,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257624',4903943,'2675','394',2533658.05,2533658.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257624',4903944,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257625',4903945,'2669','394',2455702.04,2457033.64,1331.60,246346.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257625',4903946,'2670','394',1459143.43,1460781.07,1637.64,302963.40,0.00,0.00,0.00,0.00,0.00),('5','104','896','257625',4903947,'2671','394',2079027.25,2079027.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257625',4903948,'2672','394',1366031.51,1366031.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257625',4903949,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257625',4903950,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257625',4903951,'2675','394',2533658.05,2533658.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257625',4903952,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257626',4903953,'2669','394',2457033.64,2457163.44,129.80,24013.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257626',4903954,'2670','394',1460781.07,1462102.32,1321.25,244431.25,0.00,0.00,0.00,0.00,0.00),('5','104','896','257626',4903955,'2671','394',2079027.25,2080240.40,1213.15,224432.75,0.00,0.00,0.00,0.00,0.00),('5','104','896','257626',4903956,'2672','394',1366031.51,1366031.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257626',4903957,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257626',4903958,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257626',4903959,'2675','394',2533658.05,2533658.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257626',4903960,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257627',4903961,'2669','394',2457163.44,2461169.12,4005.68,741050.80,0.00,0.00,0.00,0.00,0.00),('5','104','895','257627',4903962,'2670','394',1462102.32,1465553.01,3450.69,638377.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','257627',4903963,'2671','394',2080240.40,2084207.63,3967.23,733937.55,0.00,0.00,0.00,0.00,0.00),('5','104','896','257627',4903964,'2672','394',1366031.51,1367981.12,1949.61,360677.85,0.00,0.00,0.00,0.00,0.00),('5','104','897','257627',4903965,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257627',4903966,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257627',4903967,'2675','394',2533658.05,2533658.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257627',4903968,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257628',4903969,'2669','394',2461169.12,2461215.40,46.28,8561.80,0.00,0.00,0.00,0.00,0.00),('5','104','895','257628',4903970,'2670','394',1465553.01,1472247.84,6694.83,1238543.55,0.00,0.00,0.00,0.00,0.00),('5','104','896','257628',4903971,'2671','394',2084207.63,2089108.03,4900.40,906574.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257628',4903972,'2672','394',1367981.12,1372898.03,4916.91,909628.35,0.00,0.00,0.00,0.00,0.00),('5','104','897','257628',4903973,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257628',4903974,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257628',4903975,'2675','394',2533658.05,2533658.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257628',4903976,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257629',4903977,'2669','394',2461215.40,2461215.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257629',4903978,'2670','394',1472247.84,1473073.69,825.85,152782.25,0.00,0.00,0.00,0.00,0.00),('5','104','896','257629',4903979,'2671','394',2089108.03,2094580.55,5472.52,1012416.20,0.00,0.00,0.00,0.00,0.00),('5','104','896','257629',4903980,'2672','394',1372898.03,1378419.40,5521.37,1021453.45,0.00,0.00,0.00,0.00,0.00),('5','104','897','257629',4903981,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257629',4903982,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257629',4903983,'2675','394',2533658.05,2533658.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257629',4903984,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257630',4903985,'2669','394',2461215.40,2461215.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257630',4903986,'2670','394',1473073.69,1473073.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257630',4903987,'2671','394',2094580.55,2097045.65,2465.10,456043.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','257630',4903988,'2672','394',1378419.40,1381178.65,2759.25,510461.25,0.00,0.00,0.00,0.00,0.00),('5','104','897','257630',4903989,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257630',4903990,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257630',4903991,'2675','394',2533658.05,2533658.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257630',4903992,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257631',4903993,'2669','394',2461215.40,2461215.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257631',4903994,'2670','394',1473073.69,1473997.04,923.35,170819.75,0.00,0.00,0.00,0.00,0.00),('5','104','896','257631',4903995,'2671','394',2097045.65,2097734.43,688.78,127424.30,0.00,0.00,0.00,0.00,0.00),('5','104','896','257631',4903996,'2672','394',1381178.65,1381973.07,794.42,146967.70,0.00,0.00,0.00,0.00,0.00),('5','104','897','257631',4903997,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257631',4903998,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257631',4903999,'2675','394',2533658.05,2533658.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257631',4904000,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257632',4904001,'2669','394',2461215.40,2462517.15,1301.75,240823.75,0.00,0.00,0.00,0.00,0.00),('5','104','895','257632',4904002,'2670','394',1473997.04,1478370.69,4373.65,809125.25,0.00,0.00,0.00,0.00,0.00),('5','104','896','257632',4904003,'2671','394',2097734.43,2101656.46,3922.03,725575.55,0.00,0.00,0.00,0.00,0.00),('5','104','896','257632',4904004,'2672','394',1381973.07,1383815.23,1842.16,340799.60,0.00,0.00,0.00,0.00,0.00),('5','104','897','257632',4904005,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257632',4904006,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257632',4904007,'2675','394',2533658.05,2534399.52,741.47,137171.95,0.00,0.00,0.00,0.00,0.00),('5','104','896','257632',4904008,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257633',4904009,'2669','394',2462517.15,2462543.09,25.94,4798.90,0.00,0.00,0.00,0.00,0.00),('5','104','895','257633',4904010,'2670','394',1478370.69,1482266.65,3895.96,720752.60,0.00,0.00,0.00,0.00,0.00),('5','104','896','257633',4904011,'2671','394',2101656.46,2107371.72,5715.26,1057323.10,0.00,0.00,0.00,0.00,0.00),('5','104','896','257633',4904012,'2672','394',1383815.23,1388116.45,4301.22,795725.70,0.00,0.00,0.00,0.00,0.00),('5','104','897','257633',4904013,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257633',4904014,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257633',4904015,'2675','394',2534399.52,2536389.47,1989.95,368140.75,0.00,0.00,0.00,0.00,0.00),('5','104','896','257633',4904016,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257634',4904017,'2669','394',2462543.09,2462543.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257634',4904018,'2670','394',1482266.65,1482266.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257634',4904019,'2671','394',2107371.72,2112157.96,4786.24,885454.40,0.00,0.00,0.00,0.00,0.00),('5','104','896','257634',4904020,'2672','394',1388116.45,1393058.96,4942.51,914364.35,0.00,0.00,0.00,0.00,0.00),('5','104','897','257634',4904021,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257634',4904022,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257634',4904023,'2675','394',2536389.47,2536389.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257634',4904024,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257635',4904025,'2669','394',2462543.09,2464151.49,1608.40,297554.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257635',4904026,'2670','394',1482266.65,1487724.28,5457.63,1009661.55,0.00,0.00,0.00,0.00,0.00),('5','104','896','257635',4904027,'2671','394',2112157.96,2115111.39,2953.43,546384.55,0.00,0.00,0.00,0.00,0.00),('5','104','896','257635',4904028,'2672','394',1393058.96,1395853.49,2794.53,516988.05,0.00,0.00,0.00,0.00,0.00),('5','104','897','257635',4904029,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257635',4904030,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257635',4904031,'2675','394',2536389.47,2539188.84,2799.37,517883.45,0.00,0.00,0.00,0.00,0.00),('5','104','896','257635',4904032,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257636',4904033,'2669','394',2464151.49,2465056.48,904.99,167423.15,0.00,0.00,0.00,0.00,0.00),('5','104','895','257636',4904034,'2670','394',1487724.28,1491091.16,3366.88,622872.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','257636',4904035,'2671','394',2115111.39,2118585.25,3473.86,642664.10,0.00,0.00,0.00,0.00,0.00),('5','104','896','257636',4904036,'2672','394',1395853.49,1398961.90,3108.41,575055.85,0.00,0.00,0.00,0.00,0.00),('5','104','897','257636',4904037,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257636',4904038,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257636',4904039,'2675','394',2539188.84,2539188.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257636',4904040,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257637',4904041,'2669','394',2465056.48,2470274.57,5218.09,965346.65,0.00,0.00,0.00,0.00,0.00),('5','104','895','257637',4904042,'2670','394',1491091.16,1495185.45,4094.29,757443.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','257637',4904043,'2671','394',2118585.25,2120775.16,2189.91,405133.35,0.00,0.00,0.00,0.00,0.00),('5','104','896','257637',4904044,'2672','394',1398961.90,1399004.59,42.69,7897.65,0.00,0.00,0.00,0.00,0.00),('5','104','897','257637',4904045,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257637',4904046,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257637',4904047,'2675','394',2539188.84,2541169.10,1980.26,366348.10,0.00,0.00,0.00,0.00,0.00),('5','104','896','257637',4904048,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257638',4904049,'2669','394',2470274.57,2470274.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257638',4904050,'2670','394',1495185.45,1495185.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257638',4904051,'2671','394',2120775.16,2120775.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257638',4904052,'2672','394',1399004.59,1399004.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257638',4904053,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257638',4904054,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257638',4904055,'2675','394',2541169.10,2541169.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257638',4904056,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257639',4904057,'2669','394',2470274.57,2471742.47,1467.90,271561.50,0.00,0.00,0.00,0.00,0.00),('5','104','895','257639',4904058,'2670','394',1495185.45,1497365.40,2179.95,403290.75,0.00,0.00,0.00,0.00,0.00),('5','104','896','257639',4904059,'2671','394',2120775.16,2122452.69,1677.53,310343.05,0.00,0.00,0.00,0.00,0.00),('5','104','896','257639',4904060,'2672','394',1399004.59,1399339.03,334.44,61871.40,0.00,0.00,0.00,0.00,0.00),('5','104','897','257639',4904061,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257639',4904062,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257639',4904063,'2675','394',2541169.10,2542850.47,1681.37,311053.45,0.00,0.00,0.00,0.00,0.00),('5','104','896','257639',4904064,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257640',4904065,'2669','394',2471742.47,2471742.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257640',4904066,'2670','394',1497365.40,1501729.72,4364.32,807399.20,0.00,0.00,0.00,0.00,0.00),('5','104','896','257640',4904067,'2671','394',2122452.69,2126251.47,3798.78,702774.30,0.00,0.00,0.00,0.00,0.00),('5','104','896','257640',4904068,'2672','394',1399339.03,1403951.47,4612.44,853301.40,0.00,0.00,0.00,0.00,0.00),('5','104','897','257640',4904069,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257640',4904070,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257640',4904071,'2675','394',2542850.47,2544879.46,2028.99,375363.15,0.00,0.00,0.00,0.00,0.00),('5','104','896','257640',4904072,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257641',4904073,'2669','394',2471742.47,2473969.31,2226.84,411965.40,0.00,0.00,0.00,0.00,0.00),('5','104','895','257641',4904074,'2670','394',1501729.72,1504762.92,3033.20,561142.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257641',4904075,'2671','394',2126251.47,2131043.95,4792.48,886608.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','257641',4904076,'2672','394',1403951.47,1409248.74,5297.27,979994.95,0.00,0.00,0.00,0.00,0.00),('5','104','897','257641',4904077,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257641',4904078,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257641',4904079,'2675','394',2544879.46,2547233.65,2354.19,435525.15,0.00,0.00,0.00,0.00,0.00),('5','104','896','257641',4904080,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257642',4904081,'2669','394',2473969.31,2474661.69,692.38,128090.30,0.00,0.00,0.00,0.00,0.00),('5','104','895','257642',4904082,'2670','394',1504762.92,1505808.39,1045.47,193411.95,0.00,0.00,0.00,0.00,0.00),('5','104','896','257642',4904083,'2671','394',2131043.95,2135221.34,4177.39,772817.15,0.00,0.00,0.00,0.00,0.00),('5','104','896','257642',4904084,'2672','394',1409248.74,1412961.53,3712.79,686866.15,0.00,0.00,0.00,0.00,0.00),('5','104','897','257642',4904085,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257642',4904086,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257642',4904087,'2675','394',2547233.65,2547233.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257642',4904088,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257643',4904089,'2669','394',2474661.69,2474661.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257643',4904090,'2670','394',1505808.39,1505808.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257643',4904091,'2671','394',2135221.34,2137705.65,2484.31,459597.35,0.00,0.00,0.00,0.00,0.00),('5','104','896','257643',4904092,'2672','394',1412961.53,1415280.27,2318.74,428966.90,0.00,0.00,0.00,0.00,0.00),('5','104','897','257643',4904093,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257643',4904094,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257643',4904095,'2675','394',2547233.65,2547233.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257643',4904096,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257644',4904097,'2669','394',2474661.69,2478187.51,3525.82,652276.70,0.00,0.00,0.00,0.00,0.00),('5','104','895','257644',4904098,'2670','394',1505808.39,1509097.48,3289.09,608481.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','257644',4904099,'2671','394',2137705.65,2139963.13,2257.48,417633.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','257644',4904100,'2672','394',1415280.27,1416561.81,1281.54,237084.90,0.00,0.00,0.00,0.00,0.00),('5','104','897','257644',4904101,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257644',4904102,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257644',4904103,'2675','394',2547233.65,2550787.07,3553.42,657382.70,0.00,0.00,0.00,0.00,0.00),('5','104','896','257644',4904104,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257645',4904105,'2669','394',2478187.51,2483238.03,5050.52,934346.20,0.00,0.00,0.00,0.00,0.00),('5','104','895','257645',4904106,'2670','394',1509097.48,1511735.25,2637.77,487987.45,0.00,0.00,0.00,0.00,0.00),('5','104','896','257645',4904107,'2671','394',2139963.13,2141930.95,1967.82,364046.70,0.00,0.00,0.00,0.00,0.00),('5','104','896','257645',4904108,'2672','394',1416561.81,1418638.48,2076.67,384183.95,0.00,0.00,0.00,0.00,0.00),('5','104','897','257645',4904109,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257645',4904110,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257645',4904111,'2675','394',2550787.07,2555690.47,4903.40,907129.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257645',4904112,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257646',4904113,'2669','394',2483238.03,2486426.21,3188.18,589813.30,0.00,0.00,0.00,0.00,0.00),('5','104','895','257646',4904114,'2670','394',1511735.25,1515690.23,3954.98,731671.30,0.00,0.00,0.00,0.00,0.00),('5','104','896','257646',4904115,'2671','394',2141930.95,2143680.88,1749.93,323737.05,0.00,0.00,0.00,0.00,0.00),('5','104','896','257646',4904116,'2672','394',1418638.48,1423080.24,4441.76,821725.60,0.00,0.00,0.00,0.00,0.00),('5','104','897','257646',4904117,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257646',4904118,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257646',4904119,'2675','394',2555690.47,2555690.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257646',4904120,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257647',4904121,'2669','394',2486426.21,2486426.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257647',4904122,'2670','394',1515690.23,1515690.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257647',4904123,'2671','394',2143680.88,2149570.56,5889.68,1089590.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','257647',4904124,'2672','394',1423080.24,1428993.53,5913.29,1093958.65,0.00,0.00,0.00,0.00,0.00),('5','104','897','257647',4904125,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257647',4904126,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257647',4904127,'2675','394',2555690.47,2555690.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257647',4904128,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257648',4904129,'2669','394',2486426.21,2490424.15,3997.94,739618.90,0.00,0.00,0.00,0.00,0.00),('5','104','895','257648',4904130,'2670','394',1515690.23,1516631.09,940.86,174059.10,0.00,0.00,0.00,0.00,0.00),('5','104','895','257648',4904131,'2675','394',2555690.47,2556366.55,676.08,125074.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','257648',4904132,'2671','394',2149570.56,2153944.12,4373.56,809108.60,0.00,0.00,0.00,0.00,0.00),('5','104','896','257648',4904133,'2672','394',1428993.53,1433465.46,4471.93,827307.05,0.00,0.00,0.00,0.00,0.00),('5','104','896','257648',4904134,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257648',4904135,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257648',4904136,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257649',4904137,'2669','394',2490424.15,2492194.74,1770.59,327559.15,0.00,0.00,0.00,0.00,0.00),('5','104','895','257649',4904138,'2670','394',1516631.09,1516772.58,141.49,26175.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','257649',4904139,'2671','394',2153944.12,2157746.97,3802.85,703527.25,0.00,0.00,0.00,0.00,0.00),('5','104','896','257649',4904140,'2672','394',1433465.46,1436954.70,3489.24,645509.40,0.00,0.00,0.00,0.00,0.00),('5','104','897','257649',4904141,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257649',4904142,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257649',4904143,'2675','394',2556366.55,2560716.46,4349.91,804733.35,0.00,0.00,0.00,0.00,0.00),('5','104','896','257649',4904144,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257650',4904145,'2669','394',2492194.74,2496854.14,4659.40,861989.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257650',4904146,'2670','394',1516772.58,1518010.36,1237.78,228989.30,0.00,0.00,0.00,0.00,0.00),('5','104','896','257650',4904147,'2671','394',2157746.97,2162163.61,4416.64,817078.40,0.00,0.00,0.00,0.00,0.00),('5','104','896','257650',4904148,'2672','394',1436954.70,1437162.19,207.49,38385.65,0.00,0.00,0.00,0.00,0.00),('5','104','897','257650',4904149,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257650',4904150,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257650',4904151,'2675','394',2560716.46,2565216.27,4499.81,832464.85,0.00,0.00,0.00,0.00,0.00),('5','104','896','257650',4904152,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257651',4904153,'2669','394',2496854.14,2499933.19,3079.05,569624.25,0.00,0.00,0.00,0.00,0.00),('5','104','895','257651',4904154,'2670','394',1518010.36,1519564.61,1554.25,287536.25,0.00,0.00,0.00,0.00,0.00),('5','104','895','257651',4904155,'2675','394',2565216.27,2568361.03,3144.76,581780.60,0.00,0.00,0.00,0.00,0.00),('5','104','896','257651',4904156,'2671','394',2162163.61,2167334.95,5171.34,956697.90,0.00,0.00,0.00,0.00,0.00),('5','104','896','257651',4904157,'2672','394',1437162.19,1437162.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257651',4904158,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257651',4904159,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257651',4904160,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257652',4904161,'2669','394',2499933.19,2502631.65,2698.46,499215.10,0.00,0.00,0.00,0.00,0.00),('5','104','895','257652',4904162,'2670','394',1519564.61,1519751.90,187.29,34648.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','257652',4904163,'2671','394',2167334.95,2174201.85,6866.90,1270376.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','257652',4904164,'2672','394',1437162.19,1437918.77,756.58,139967.30,0.00,0.00,0.00,0.00,0.00),('5','104','897','257652',4904165,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257652',4904166,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257652',4904167,'2675','394',2568361.03,2574169.69,5808.66,1074602.10,0.00,0.00,0.00,0.00,0.00),('5','104','896','257652',4904168,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257653',4904169,'2669','394',2502631.65,2509018.69,6387.04,1181602.40,0.00,0.00,0.00,0.00,0.00),('5','104','895','257653',4904170,'2670','394',1519751.90,1519751.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257653',4904171,'2671','394',2174201.85,2177075.33,2873.48,531593.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','257653',4904172,'2672','394',1437918.77,1443818.24,5899.47,1091401.95,0.00,0.00,0.00,0.00,0.00),('5','104','897','257653',4904173,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257653',4904174,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257653',4904175,'2675','394',2574169.69,2576250.01,2080.32,384859.20,0.00,0.00,0.00,0.00,0.00),('5','104','896','257653',4904176,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257654',4904177,'2669','394',2509018.69,2511993.21,2974.52,550286.20,0.00,0.00,0.00,0.00,0.00),('5','104','895','257654',4904178,'2670','394',1519751.90,1520358.29,606.39,112182.15,0.00,0.00,0.00,0.00,0.00),('5','104','896','257654',4904179,'2671','394',2177075.33,2178900.72,1825.39,337697.15,0.00,0.00,0.00,0.00,0.00),('5','104','896','257654',4904180,'2672','394',1443818.24,1448551.36,4733.12,875627.20,0.00,0.00,0.00,0.00,0.00),('5','104','897','257654',4904181,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257654',4904182,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257654',4904183,'2675','394',2576250.01,2579619.68,3369.67,623388.95,0.00,0.00,0.00,0.00,0.00),('5','104','896','257654',4904184,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257655',4904185,'2669','394',2511993.21,2512635.19,641.98,118766.30,0.00,0.00,0.00,0.00,0.00),('5','104','895','257655',4904186,'2670','394',1520358.29,1522249.69,1891.40,349909.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257655',4904187,'2671','394',2178900.72,2182381.06,3480.34,643862.90,0.00,0.00,0.00,0.00,0.00),('5','104','896','257655',4904188,'2672','394',1448551.36,1452571.15,4019.79,743661.15,0.00,0.00,0.00,0.00,0.00),('5','104','897','257655',4904189,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257655',4904190,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257655',4904191,'2675','394',2579619.68,2579619.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257655',4904192,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257656',4904193,'2669','394',2512635.19,2512635.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257656',4904194,'2670','394',1522249.69,1522249.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257656',4904195,'2675','394',2579619.68,2579619.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257656',4904196,'2671','394',2182381.06,2182381.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257656',4904197,'2672','394',1452571.15,1452571.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257656',4904198,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257656',4904199,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257656',4904200,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257657',4904201,'2669','394',2512635.19,2512635.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257657',4904202,'2670','394',1522249.69,1522249.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257657',4904203,'2671','394',2182381.06,2182381.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257657',4904204,'2672','394',1452571.15,1452571.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257657',4904205,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257657',4904206,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257657',4904207,'2675','394',2579619.68,2579619.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257657',4904208,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257658',4904209,'2669','394',2512635.19,2512635.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257658',4904210,'2670','394',1522249.69,1522249.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257658',4904211,'2671','394',2182381.06,2182381.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257658',4904212,'2672','394',1452571.15,1452571.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257658',4904213,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257658',4904214,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257658',4904215,'2675','394',2579619.68,2579619.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257658',4904216,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257659',4904217,'2669','394',2512635.19,2512635.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257659',4904218,'2670','394',1522249.69,1522249.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257659',4904219,'2671','394',2182381.06,2182381.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257659',4904220,'2672','394',1452571.15,1452571.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257659',4904221,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257659',4904222,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257659',4904223,'2675','394',2579619.68,2579619.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257659',4904224,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257660',4904225,'2669','394',2512635.19,2512635.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257660',4904226,'2670','394',1522249.69,1522249.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257660',4904227,'2671','394',2182381.06,2182381.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257660',4904228,'2672','394',1452571.15,1452571.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257660',4904229,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257660',4904230,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257660',4904231,'2675','394',2579619.68,2579619.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257660',4904232,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257661',4904233,'2669','394',2512635.19,2512635.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257661',4904234,'2670','394',1522249.69,1522249.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257661',4904235,'2671','394',2182381.06,2182381.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257661',4904236,'2672','394',1452571.15,1452571.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257661',4904237,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257661',4904238,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257661',4904239,'2675','394',2579619.68,2579619.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257661',4904240,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257662',4904241,'2669','394',2512635.19,2512635.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257662',4904242,'2670','394',1522249.69,1522249.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257662',4904243,'2671','394',2182381.06,2182381.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257662',4904244,'2672','394',1452571.15,1452571.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257662',4904245,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257662',4904246,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257662',4904247,'2675','394',2579619.68,2579619.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257662',4904248,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257663',4904249,'2669','394',2512635.19,2512635.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257663',4904250,'2670','394',1522249.69,1522249.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257663',4904251,'2671','394',2182381.06,2182381.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257663',4904252,'2672','394',1452571.15,1452571.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257663',4904253,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257663',4904254,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257663',4904255,'2675','394',2579619.68,2579619.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257663',4904256,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257664',4904257,'2669','394',2512635.19,2512635.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257664',4904258,'2670','394',1522249.69,1522249.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257664',4904259,'2671','394',2182381.06,2184291.06,1910.00,353350.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257664',4904260,'2672','394',1452571.15,1453771.05,1199.90,221981.50,0.00,0.00,0.00,0.00,0.00),('5','104','897','257664',4904261,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257664',4904262,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257664',4904263,'2675','394',2579619.68,2579619.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257664',4904264,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257665',4904265,'2669','394',2512635.19,2518332.40,5697.21,1053983.85,0.00,0.00,0.00,0.00,0.00),('5','104','895','257665',4904266,'2670','394',1522249.69,1527254.18,5004.49,925830.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','257665',4904267,'2671','394',2184291.06,2184291.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257665',4904268,'2672','394',1453771.05,1453771.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257665',4904269,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257665',4904270,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257665',4904271,'2675','394',2579619.68,2579724.93,105.25,19471.25,0.00,0.00,0.00,0.00,0.00),('5','104','896','257665',4904272,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257666',4904273,'2669','394',2518332.40,2523047.03,4714.63,872206.55,0.00,0.00,0.00,0.00,0.00),('5','104','895','257666',4904274,'2670','394',1527254.18,1528240.79,986.61,182522.85,0.00,0.00,0.00,0.00,0.00),('5','104','896','257666',4904275,'2671','394',2184291.06,2184330.08,39.02,7218.70,0.00,0.00,0.00,0.00,0.00),('5','104','896','257666',4904276,'2672','394',1453771.05,1459060.17,5289.12,978487.20,0.00,0.00,0.00,0.00,0.00),('5','104','897','257666',4904277,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257666',4904278,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257666',4904279,'2675','394',2579724.93,2580914.44,1189.51,220059.35,0.00,0.00,0.00,0.00,0.00),('5','104','896','257666',4904280,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257667',4904281,'2669','394',2523047.03,2523047.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257667',4904282,'2670','394',1528240.79,1528240.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257667',4904283,'2671','394',2184330.08,2188909.27,4579.19,847150.15,0.00,0.00,0.00,0.00,0.00),('5','104','896','257667',4904284,'2672','394',1459060.17,1459060.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257667',4904285,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257667',4904286,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257667',4904287,'2675','394',2580914.44,2585751.73,4837.29,894898.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','257667',4904288,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257668',4904289,'2669','394',2523047.03,2523047.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257668',4904290,'2670','394',1528240.79,1529399.34,1158.55,214331.75,0.00,0.00,0.00,0.00,0.00),('5','104','896','257668',4904291,'2671','394',2188909.27,2193769.99,4860.72,899233.20,0.00,0.00,0.00,0.00,0.00),('5','104','896','257668',4904292,'2672','394',1459060.17,1462312.78,3252.61,601732.85,0.00,0.00,0.00,0.00,0.00),('5','104','897','257668',4904293,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257668',4904294,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257668',4904295,'2675','394',2585751.73,2586191.32,439.59,81324.15,0.00,0.00,0.00,0.00,0.00),('5','104','896','257668',4904296,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257669',4904297,'2669','394',2523047.03,2523047.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257669',4904298,'2670','394',1529399.34,1529399.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257669',4904299,'2675','394',2586191.32,2586191.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257669',4904300,'2671','394',2193769.99,2197500.66,3730.67,690173.95,0.00,0.00,0.00,0.00,0.00),('5','104','896','257669',4904301,'2672','394',1462312.78,1466850.05,4537.27,839394.95,0.00,0.00,0.00,0.00,0.00),('5','104','896','257669',4904302,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257669',4904303,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257669',4904304,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257670',4904305,'2669','394',2523047.03,2526897.14,3850.11,712270.35,0.00,0.00,0.00,0.00,0.00),('5','104','895','257670',4904306,'2670','394',1529399.34,1531941.98,2542.64,470388.40,0.00,0.00,0.00,0.00,0.00),('5','104','896','257670',4904307,'2671','394',2197500.66,2199781.94,2281.28,422036.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','257670',4904308,'2672','394',1466850.05,1466850.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257670',4904309,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257670',4904310,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257670',4904311,'2675','394',2586191.32,2586191.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257670',4904312,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257671',4904313,'2669','394',2526897.14,2529902.84,3005.70,556054.50,0.00,0.00,0.00,0.00,0.00),('5','104','895','257671',4904314,'2670','394',1531941.98,1533884.11,1942.13,359294.05,0.00,0.00,0.00,0.00,0.00),('5','104','896','257671',4904315,'2671','394',2199781.94,2199781.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257671',4904316,'2672','394',1466850.05,1466850.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257671',4904317,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257671',4904318,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257671',4904319,'2675','394',2586191.32,2590953.20,4761.88,880947.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','257671',4904320,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257672',4904321,'2669','394',2529902.84,2529902.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257672',4904322,'2670','394',1533884.11,1536974.17,3090.06,571661.10,0.00,0.00,0.00,0.00,0.00),('5','104','896','257672',4904323,'2671','394',2199781.94,2199781.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257672',4904324,'2672','394',1466850.05,1466850.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257672',4904325,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257672',4904326,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257672',4904327,'2675','394',2590953.20,2590953.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257672',4904328,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257673',4904329,'2669','394',2529902.84,2529902.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257673',4904330,'2670','394',1536974.17,1536974.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257673',4904331,'2671','394',2199781.94,2199781.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257673',4904332,'2672','394',1466850.05,1466850.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257673',4904333,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257673',4904334,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257673',4904335,'2675','394',2590953.20,2590953.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257673',4904336,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257674',4904337,'2669','394',2529902.84,2529902.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257674',4904338,'2670','394',1536974.17,1536974.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257674',4904339,'2671','394',2199781.94,2199781.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257674',4904340,'2672','394',1466850.05,1466850.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257674',4904341,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257674',4904342,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257674',4904343,'2675','394',2590953.20,2590953.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257674',4904344,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257675',4904345,'2669','394',2529902.84,2531217.98,1315.14,243300.90,0.00,0.00,0.00,0.00,0.00),('5','104','895','257675',4904346,'2670','394',1536974.17,1537459.36,485.19,89760.15,0.00,0.00,0.00,0.00,0.00),('5','104','896','257675',4904347,'2671','394',2199781.94,2199781.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257675',4904348,'2672','394',1466850.05,1468262.59,1412.54,261319.90,0.00,0.00,0.00,0.00,0.00),('5','104','897','257675',4904349,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257675',4904350,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257675',4904351,'2675','394',2590953.20,2590953.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257675',4904352,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257676',4904353,'2669','394',2531217.98,2534818.46,3600.48,666088.80,0.00,0.00,0.00,0.00,0.00),('5','104','895','257676',4904354,'2670','394',1537459.36,1542421.14,4961.78,917929.30,0.00,0.00,0.00,0.00,0.00),('5','104','896','257676',4904355,'2671','394',2199781.94,2199781.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257676',4904356,'2672','394',1468262.59,1468262.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257676',4904357,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257676',4904358,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257676',4904359,'2675','394',2590953.20,2590953.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257676',4904360,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257677',4904361,'2669','394',2534818.46,2538211.67,3393.21,627743.85,0.00,0.00,0.00,0.00,0.00),('5','104','895','257677',4904362,'2670','394',1542421.14,1542421.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257677',4904363,'2671','394',2199781.94,2201822.27,2040.33,377461.05,0.00,0.00,0.00,0.00,0.00),('5','104','896','257677',4904364,'2672','394',1468262.59,1472164.49,3901.90,721851.50,0.00,0.00,0.00,0.00,0.00),('5','104','897','257677',4904365,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257677',4904366,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257677',4904367,'2675','394',2590953.20,2591300.90,347.70,64324.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','257677',4904368,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257678',4904369,'2669','394',2538211.67,2542244.01,4032.34,745982.90,0.00,0.00,0.00,0.00,0.00),('5','104','895','257678',4904370,'2670','394',1542421.14,1542421.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257678',4904371,'2671','394',2201822.27,2206353.70,4531.43,838314.55,0.00,0.00,0.00,0.00,0.00),('5','104','896','257678',4904372,'2672','394',1472164.49,1472164.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257678',4904373,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257678',4904374,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257678',4904375,'2675','394',2591300.90,2592900.92,1600.02,296003.70,0.00,0.00,0.00,0.00,0.00),('5','104','896','257678',4904376,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257679',4904377,'2669','394',2542244.01,2546103.16,3859.15,713942.75,0.00,0.00,0.00,0.00,0.00),('5','104','895','257679',4904378,'2670','394',1542421.14,1542421.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257679',4904379,'2671','394',2206353.70,2206353.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257679',4904380,'2672','394',1472164.49,1475309.75,3145.26,581873.10,0.00,0.00,0.00,0.00,0.00),('5','104','897','257679',4904381,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257679',4904382,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257679',4904383,'2675','394',2592900.92,2596195.60,3294.68,609515.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','257679',4904384,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257680',4904385,'2669','394',2546103.16,2546103.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257680',4904386,'2670','394',1542421.14,1545971.62,3550.48,656838.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','257680',4904387,'2671','394',2206353.70,2206353.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257680',4904388,'2672','394',1475309.75,1475309.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257680',4904389,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257680',4904390,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257680',4904391,'2675','394',2596195.60,2596195.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257680',4904392,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257681',4904393,'2669','394',2546103.16,2548765.15,2661.99,492468.15,0.00,0.00,0.00,0.00,0.00),('5','104','895','257681',4904394,'2670','394',1545971.62,1547561.17,1589.55,294066.75,0.00,0.00,0.00,0.00,0.00),('5','104','896','257681',4904395,'2671','394',2206353.70,2206353.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257681',4904396,'2672','394',1475309.75,1475309.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257681',4904397,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257681',4904398,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257681',4904399,'2675','394',2596195.60,2600860.76,4665.16,863054.60,0.00,0.00,0.00,0.00,0.00),('5','104','896','257681',4904400,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257682',4904401,'2669','394',2548765.15,2551789.23,3024.08,559454.80,0.00,0.00,0.00,0.00,0.00),('5','104','895','257682',4904402,'2670','394',1547561.17,1550837.08,3275.91,606043.35,0.00,0.00,0.00,0.00,0.00),('5','104','896','257682',4904403,'2671','394',2206353.70,2206353.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257682',4904404,'2672','394',1475309.75,1475309.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257682',4904405,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257682',4904406,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257682',4904407,'2675','394',2600860.76,2604105.35,3244.59,600249.15,0.00,0.00,0.00,0.00,0.00),('5','104','896','257682',4904408,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257683',4904409,'2669','394',2551789.23,2558336.94,6547.71,1211326.35,0.00,0.00,0.00,0.00,0.00),('5','104','895','257683',4904410,'2670','394',1550837.08,1550837.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257683',4904411,'2671','394',2206353.70,2206353.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257683',4904412,'2672','394',1475309.75,1475309.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257683',4904413,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257683',4904414,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257683',4904415,'2675','394',2604105.35,2605063.08,957.73,177180.05,0.00,0.00,0.00,0.00,0.00),('5','104','896','257683',4904416,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257684',4904417,'2669','394',2558336.94,2558336.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257684',4904418,'2670','394',1550837.08,1553420.21,2583.13,477879.05,0.00,0.00,0.00,0.00,0.00),('5','104','896','257684',4904419,'2671','394',2206353.70,2206353.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257684',4904420,'2672','394',1475309.75,1475309.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257684',4904421,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257684',4904422,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257684',4904423,'2675','394',2605063.08,2606065.24,1002.16,185399.60,0.00,0.00,0.00,0.00,0.00),('5','104','896','257684',4904424,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257685',4904425,'2669','394',2558336.94,2558336.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257685',4904426,'2670','394',1553420.21,1553420.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257685',4904427,'2671','394',2206353.70,2206353.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257685',4904428,'2672','394',1475309.75,1475309.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257685',4904429,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257685',4904430,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257685',4904431,'2675','394',2606065.24,2606065.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257685',4904432,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257686',4904433,'2669','394',2558336.94,2558336.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257686',4904434,'2670','394',1553420.21,1553420.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257686',4904435,'2671','394',2206353.70,2206353.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257686',4904436,'2672','394',1475309.75,1475309.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257686',4904437,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257686',4904438,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257686',4904439,'2675','394',2606065.24,2606065.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257686',4904440,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257687',4904441,'2669','394',2558336.94,2558336.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257687',4904442,'2670','394',1553420.21,1553420.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257687',4904443,'2671','394',2206353.70,2206353.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257687',4904444,'2672','394',1475309.75,1475309.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257687',4904445,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257687',4904446,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257687',4904447,'2675','394',2606065.24,2606065.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257687',4904448,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257688',4904449,'2669','394',2558336.94,2558336.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257688',4904450,'2670','394',1553420.21,1553420.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257688',4904451,'2671','394',2206353.70,2206353.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257688',4904452,'2672','394',1475309.75,1475309.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257688',4904453,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257688',4904454,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257688',4904455,'2675','394',2606065.24,2606065.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257688',4904456,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257689',4904457,'2669','394',2558336.94,2558336.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257689',4904458,'2670','394',1553420.21,1553420.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257689',4904459,'2671','394',2206353.70,2206353.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257689',4904460,'2672','394',1475309.75,1475309.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257689',4904461,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257689',4904462,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257689',4904463,'2675','394',2606065.24,2606065.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257689',4904464,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257690',4904465,'2669','394',2558336.94,2558336.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257690',4904466,'2670','394',1553420.21,1553420.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257690',4904467,'2671','394',2206353.70,2206353.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257690',4904468,'2672','394',1475309.75,1475309.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257690',4904469,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257690',4904470,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257690',4904471,'2675','394',2606065.24,2606065.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257690',4904472,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257691',4904473,'2669','394',2558336.94,2558527.69,190.75,35288.75,0.00,0.00,0.00,0.00,0.00),('5','104','895','257691',4904474,'2670','394',1553420.21,1554923.57,1503.36,278121.60,0.00,0.00,0.00,0.00,0.00),('5','104','896','257691',4904475,'2671','394',2206353.70,2206353.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257691',4904476,'2672','394',1475309.75,1475309.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257691',4904477,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257691',4904478,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257691',4904479,'2675','394',2606065.24,2607573.26,1508.02,278983.70,0.00,0.00,0.00,0.00,0.00),('5','104','896','257691',4904480,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257692',4904481,'2669','394',2558527.69,2560370.55,1842.86,340929.10,0.00,0.00,0.00,0.00,0.00),('5','104','895','257692',4904482,'2670','394',1554923.57,1559719.89,4796.32,887319.20,0.00,0.00,0.00,0.00,0.00),('5','104','896','257692',4904483,'2671','394',2206353.70,2206353.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257692',4904484,'2672','394',1475309.75,1475309.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257692',4904485,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257692',4904486,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257692',4904487,'2675','394',2607573.26,2611165.25,3591.99,664518.15,0.00,0.00,0.00,0.00,0.00),('5','104','896','257692',4904488,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257693',4904489,'2669','394',2560370.55,2564309.20,3938.65,728650.25,0.00,0.00,0.00,0.00,0.00),('5','104','895','257693',4904490,'2670','394',1559719.89,1561448.38,1728.49,319770.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','257693',4904491,'2671','394',2206353.70,2206353.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257693',4904492,'2672','394',1475309.75,1475309.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257693',4904493,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257693',4904494,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257693',4904495,'2675','394',2611165.25,2615228.68,4063.43,751734.55,0.00,0.00,0.00,0.00,0.00),('5','104','896','257693',4904496,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257694',4904497,'2669','394',2564309.20,2564309.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257694',4904498,'2670','394',1561448.38,1564764.44,3316.06,613471.10,0.00,0.00,0.00,0.00,0.00),('5','104','896','257694',4904499,'2671','394',2206353.70,2206353.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257694',4904500,'2672','394',1475309.75,1475309.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257694',4904501,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257694',4904502,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257694',4904503,'2675','394',2615228.68,2615228.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257694',4904504,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257695',4904505,'2669','394',2564309.20,2564309.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257695',4904506,'2670','394',1564764.44,1569793.15,5028.71,930311.35,0.00,0.00,0.00,0.00,0.00),('5','104','896','257695',4904507,'2671','394',2206353.70,2206353.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257695',4904508,'2672','394',1475309.75,1475309.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257695',4904509,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257695',4904510,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257695',4904511,'2675','394',2615228.68,2619262.75,4034.07,746302.95,0.00,0.00,0.00,0.00,0.00),('5','104','896','257695',4904512,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257696',4904513,'2669','394',2564309.20,2567951.56,3642.36,673836.60,0.00,0.00,0.00,0.00,0.00),('5','104','895','257696',4904514,'2670','394',1569793.15,1570325.32,532.17,98451.45,0.00,0.00,0.00,0.00,0.00),('5','104','896','257696',4904515,'2671','394',2206353.70,2206353.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257696',4904516,'2672','394',1475309.75,1475309.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257696',4904517,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257696',4904518,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257696',4904519,'2675','394',2619262.75,2620581.90,1319.15,244042.75,0.00,0.00,0.00,0.00,0.00),('5','104','896','257696',4904520,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257697',4904521,'2669','394',2567951.56,2569182.62,1231.06,227746.10,0.00,0.00,0.00,0.00,0.00),('5','104','895','257697',4904522,'2670','394',1570325.32,1571404.22,1078.90,199596.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','257697',4904523,'2671','394',2206353.70,2206353.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257697',4904524,'2672','394',1475309.75,1475309.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257697',4904525,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257697',4904526,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257697',4904527,'2675','394',2620581.90,2621903.37,1321.47,244471.95,0.00,0.00,0.00,0.00,0.00),('5','104','896','257697',4904528,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257698',4904529,'2669','394',2569182.62,2573186.36,4003.74,740691.90,0.00,0.00,0.00,0.00,0.00),('5','104','895','257698',4904530,'2670','394',1571404.22,1574373.12,2968.90,549246.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','257698',4904531,'2671','394',2206353.70,2206353.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257698',4904532,'2672','394',1475309.75,1475309.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257698',4904533,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257698',4904534,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257698',4904535,'2675','394',2621903.37,2624127.96,2224.59,411549.15,0.00,0.00,0.00,0.00,0.00),('5','104','896','257698',4904536,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257699',4904537,'2669','394',2573186.36,2573186.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257699',4904538,'2670','394',1574373.12,1574700.85,327.73,60630.05,0.00,0.00,0.00,0.00,0.00),('5','104','896','257699',4904539,'2671','394',2206353.70,2206353.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257699',4904540,'2672','394',1475309.75,1479597.92,4288.17,793311.45,0.00,0.00,0.00,0.00,0.00),('5','104','897','257699',4904541,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257699',4904542,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257699',4904543,'2675','394',2624127.96,2627704.21,3576.25,661606.25,0.00,0.00,0.00,0.00,0.00),('5','104','896','257699',4904544,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257700',4904545,'2669','394',2573186.36,2573186.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257700',4904546,'2670','394',1574700.85,1574700.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257700',4904547,'2671','394',2206353.70,2210460.44,4106.74,759746.90,0.00,0.00,0.00,0.00,0.00),('5','104','896','257700',4904548,'2672','394',1479597.92,1485499.45,5901.53,1091783.05,0.00,0.00,0.00,0.00,0.00),('5','104','897','257700',4904549,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257700',4904550,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257700',4904551,'2675','394',2627704.21,2627704.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257700',4904552,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257701',4904553,'2669','394',2573186.36,2573186.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257701',4904554,'2670','394',1574700.85,1575710.58,1009.73,186800.05,0.00,0.00,0.00,0.00,0.00),('5','104','896','257701',4904555,'2671','394',2210460.44,2210825.26,364.82,67491.70,0.00,0.00,0.00,0.00,0.00),('5','104','896','257701',4904556,'2672','394',1485499.45,1486360.95,861.50,159377.50,0.00,0.00,0.00,0.00,0.00),('5','104','897','257701',4904557,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257701',4904558,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257701',4904559,'2675','394',2627704.21,2627704.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257701',4904560,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257702',4904561,'2669','394',2573186.36,2573186.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257702',4904562,'2670','394',1575710.58,1575710.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257702',4904563,'2671','394',2210825.26,2210825.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257702',4904564,'2672','394',1486360.95,1486360.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257702',4904565,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257702',4904566,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257702',4904567,'2675','394',2627704.21,2627704.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257702',4904568,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257703',4904569,'2669','394',2573186.36,2573186.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257703',4904570,'2670','394',1575710.58,1575710.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257703',4904571,'2671','394',2210825.26,2210825.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257703',4904572,'2672','394',1486360.95,1486360.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257703',4904573,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257703',4904574,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257703',4904575,'2675','394',2627704.21,2627704.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257703',4904576,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257704',4904577,'2669','394',2573186.36,2573186.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257704',4904578,'2670','394',1575710.58,1575710.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257704',4904579,'2671','394',2210825.26,2210825.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257704',4904580,'2672','394',1486360.95,1486360.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257704',4904581,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257704',4904582,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257704',4904583,'2675','394',2627704.21,2627704.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257704',4904584,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257705',4904585,'2669','394',2573186.36,2573186.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257705',4904586,'2670','394',1575710.58,1575710.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257705',4904587,'2671','394',2210825.26,2210825.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257705',4904588,'2672','394',1486360.95,1486360.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257705',4904589,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257705',4904590,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257705',4904591,'2675','394',2627704.21,2627704.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257705',4904592,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257706',4904593,'2669','394',2573186.36,2573186.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257706',4904594,'2670','394',1575710.58,1575710.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257706',4904595,'2671','394',2210825.26,2210825.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257706',4904596,'2672','394',1486360.95,1486360.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257706',4904597,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257706',4904598,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257706',4904599,'2675','394',2627704.21,2627704.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257706',4904600,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257707',4904601,'2669','394',2573186.36,2573186.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257707',4904602,'2670','394',1575710.58,1575710.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257707',4904603,'2671','394',2210825.26,2210825.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257707',4904604,'2672','394',1486360.95,1486360.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257707',4904605,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257707',4904606,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257707',4904607,'2675','394',2627704.21,2627704.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257707',4904608,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257708',4904609,'2669','394',2573186.36,2573186.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257708',4904610,'2670','394',1575710.58,1575710.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257708',4904611,'2671','394',2210825.26,2210825.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257708',4904612,'2672','394',1486360.95,1486360.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257708',4904613,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257708',4904614,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257708',4904615,'2675','394',2627704.21,2627704.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257708',4904616,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257709',4904617,'2669','394',2573186.36,2573186.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257709',4904618,'2670','394',1575710.58,1575710.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257709',4904619,'2671','394',2210825.26,2210825.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257709',4904620,'2672','394',1486360.95,1486360.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257709',4904621,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257709',4904622,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257709',4904623,'2675','394',2627704.21,2627704.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257709',4904624,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257710',4904625,'2669','394',2573186.36,2573186.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257710',4904626,'2670','394',1575710.58,1575710.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257710',4904627,'2671','394',2210825.26,2210825.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257710',4904628,'2672','394',1486360.95,1486360.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257710',4904629,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257710',4904630,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257710',4904631,'2675','394',2627704.21,2627704.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257710',4904632,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257711',4904633,'2669','394',2573186.36,2573186.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257711',4904634,'2670','394',1575710.58,1575710.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257711',4904635,'2671','394',2210825.26,2210825.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257711',4904636,'2672','394',1486360.95,1486360.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257711',4904637,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257711',4904638,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257711',4904639,'2675','394',2627704.21,2627704.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257711',4904640,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257712',4904641,'2669','394',2573186.36,2573186.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257712',4904642,'2670','394',1575710.58,1575710.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257712',4904643,'2671','394',2210825.26,2210825.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257712',4904644,'2672','394',1486360.95,1486360.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257712',4904645,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257712',4904646,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257712',4904647,'2675','394',2627704.21,2627704.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257712',4904648,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257713',4904649,'2669','394',2573186.36,2573186.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257713',4904650,'2670','394',1575710.58,1575710.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257713',4904651,'2671','394',2210825.26,2210825.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257713',4904652,'2672','394',1486360.95,1486360.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257713',4904653,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257713',4904654,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257713',4904655,'2675','394',2627704.21,2627704.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257713',4904656,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257714',4904657,'2669','394',2573186.36,2573186.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257714',4904658,'2670','394',1575710.58,1575710.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257714',4904659,'2671','394',2210825.26,2210825.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257714',4904660,'2672','394',1486360.95,1486360.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257714',4904661,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257714',4904662,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257714',4904663,'2675','394',2627704.21,2627704.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257714',4904664,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257715',4904665,'2669','394',2573186.36,2573186.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257715',4904666,'2670','394',1575710.58,1575710.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257715',4904667,'2671','394',2210825.26,2210825.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257715',4904668,'2672','394',1486360.95,1486360.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257715',4904669,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257715',4904670,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257715',4904671,'2675','394',2627704.21,2627704.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257715',4904672,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257716',4904673,'2669','394',2573186.36,2573186.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257716',4904674,'2670','394',1575710.58,1575710.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257716',4904675,'2671','394',2210825.26,2210825.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257716',4904676,'2672','394',1486360.95,1486360.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257716',4904677,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257716',4904678,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257716',4904679,'2675','394',2627704.21,2627704.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257716',4904680,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257717',4904681,'2669','394',2573186.36,2573186.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257717',4904682,'2670','394',1575710.58,1575710.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257717',4904683,'2671','394',2210825.26,2210825.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257717',4904684,'2672','394',1486360.95,1486360.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257717',4904685,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257717',4904686,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257717',4904687,'2675','394',2627704.21,2627704.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257717',4904688,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257718',4904689,'2669','394',2573186.36,2573186.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257718',4904690,'2670','394',1575710.58,1575710.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257718',4904691,'2671','394',2210825.26,2210825.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257718',4904692,'2672','394',1486360.95,1486360.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257718',4904693,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257718',4904694,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257718',4904695,'2675','394',2627704.21,2627704.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257718',4904696,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257719',4904697,'2669','394',2573186.36,2573186.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257719',4904698,'2670','394',1575710.58,1575710.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257719',4904699,'2671','394',2210825.26,2210825.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257719',4904700,'2672','394',1486360.95,1486360.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257719',4904701,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257719',4904702,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257719',4904703,'2675','394',2627704.21,2627704.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257719',4904704,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257720',4904705,'2669','394',2573186.36,2573186.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257720',4904706,'2670','394',1575710.58,1575710.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257720',4904707,'2671','394',2210825.26,2210825.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257720',4904708,'2672','394',1486360.95,1486360.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257720',4904709,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257720',4904710,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257720',4904711,'2675','394',2627704.21,2627704.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257720',4904712,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257721',4904713,'2669','394',2573186.36,2573186.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257721',4904714,'2670','394',1575710.58,1575710.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257721',4904715,'2671','394',2210825.26,2210825.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257721',4904716,'2672','394',1486360.95,1486360.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257721',4904717,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257721',4904718,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257721',4904719,'2675','394',2627704.21,2627704.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257721',4904720,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257722',4904721,'2669','394',2573186.36,2573186.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257722',4904722,'2670','394',1575710.58,1575710.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257722',4904723,'2671','394',2210825.26,2210825.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257722',4904724,'2672','394',1486360.95,1486360.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257722',4904725,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257722',4904726,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257722',4904727,'2675','394',2627704.21,2627704.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257722',4904728,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257723',4904729,'2669','394',2573186.36,2574237.38,1051.02,194438.70,0.00,0.00,0.00,0.00,0.00),('5','104','895','257723',4904730,'2670','394',1575710.58,1575710.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257723',4904731,'2671','394',2210825.26,2210825.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257723',4904732,'2672','394',1486360.95,1493571.39,7210.44,1333931.40,0.00,0.00,0.00,0.00,0.00),('5','104','897','257723',4904733,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257723',4904734,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257723',4904735,'2675','394',2627704.21,2627704.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257723',4904736,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257724',4904737,'2669','394',2574237.38,2574237.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257724',4904738,'2670','394',1575710.58,1575710.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257724',4904739,'2671','394',2210825.26,2211010.04,184.78,34184.30,0.00,0.00,0.00,0.00,0.00),('5','104','896','257724',4904740,'2672','394',1493571.39,1498683.14,5111.75,945673.75,0.00,0.00,0.00,0.00,0.00),('5','104','897','257724',4904741,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257724',4904742,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257724',4904743,'2675','394',2627704.21,2631724.87,4020.66,743822.10,0.00,0.00,0.00,0.00,0.00),('5','104','896','257724',4904744,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257725',4904745,'2669','394',2574237.38,2577906.75,3669.37,678833.45,0.00,0.00,0.00,0.00,0.00),('5','104','895','257725',4904746,'2670','394',1575710.58,1580463.87,4753.29,879358.65,0.00,0.00,0.00,0.00,0.00),('5','104','896','257725',4904747,'2671','394',2211010.04,2211462.83,452.79,83766.15,0.00,0.00,0.00,0.00,0.00),('5','104','896','257725',4904748,'2672','394',1498683.14,1498683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257725',4904749,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257725',4904750,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257725',4904751,'2675','394',2631724.87,2633999.11,2274.24,420734.40,0.00,0.00,0.00,0.00,0.00),('5','104','896','257725',4904752,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257726',4904753,'2669','394',2577906.75,2577906.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257726',4904754,'2670','394',1580463.87,1580463.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257726',4904755,'2671','394',2211462.83,2211462.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257726',4904756,'2672','394',1498683.14,1498683.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257726',4904757,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257726',4904758,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257726',4904759,'2675','394',2633999.11,2633999.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257726',4904760,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257727',4904761,'2669','394',2577906.75,2577906.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257727',4904762,'2670','394',1580463.87,1580940.85,476.98,88241.30,0.00,0.00,0.00,0.00,0.00),('5','104','896','257727',4904763,'2671','394',2211462.83,2211462.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257727',4904764,'2672','394',1498683.14,1502266.18,3583.04,662862.40,0.00,0.00,0.00,0.00,0.00),('5','104','897','257727',4904765,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257727',4904766,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257727',4904767,'2675','394',2633999.11,2633999.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257727',4904768,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257728',4904769,'2669','394',2577906.75,2577906.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257728',4904770,'2670','394',1580940.85,1580940.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257728',4904771,'2671','394',2211462.83,2211462.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257728',4904772,'2672','394',1502266.18,1502266.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257728',4904773,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257728',4904774,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257728',4904775,'2675','394',2633999.11,2633999.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257728',4904776,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257729',4904777,'2669','394',2577906.75,2577906.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257729',4904778,'2670','394',1580940.85,1580940.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257729',4904779,'2671','394',2211462.83,2211462.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257729',4904780,'2672','394',1502266.18,1502266.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257729',4904781,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257729',4904782,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257729',4904783,'2675','394',2633999.11,2633999.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257729',4904784,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257730',4904785,'2669','394',2577906.75,2577906.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257730',4904786,'2670','394',1580940.85,1580940.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257730',4904787,'2671','394',2211462.83,2211462.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257730',4904788,'2672','394',1502266.18,1502266.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257730',4904789,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257730',4904790,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257730',4904791,'2675','394',2633999.11,2633999.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257730',4904792,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257731',4904793,'2669','394',2577906.75,2584896.03,6989.28,1537641.60,0.00,0.00,0.00,0.00,0.00),('5','104','895','257731',4904794,'2670','394',1580940.85,1581566.18,625.33,137572.60,0.00,0.00,0.00,0.00,0.00),('5','104','896','257731',4904795,'2671','394',2211462.83,2211462.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257731',4904796,'2672','394',1502266.18,1502266.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257731',4904797,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257731',4904798,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257731',4904799,'2675','394',2633999.11,2633999.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257731',4904800,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257732',4904801,'2669','394',2584896.03,2588085.69,3189.66,701725.20,0.00,0.00,0.00,0.00,0.00),('5','104','895','257732',4904802,'2670','394',1581566.18,1585389.36,3823.18,841099.60,0.00,0.00,0.00,0.00,0.00),('5','104','896','257732',4904803,'2671','394',2211462.83,2211462.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257732',4904804,'2672','394',1502266.18,1502266.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257732',4904805,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257732',4904806,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257732',4904807,'2675','394',2633999.11,2634189.36,190.25,41855.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257732',4904808,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257733',4904809,'2669','394',2588085.69,2588085.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257733',4904810,'2670','394',1585389.36,1585389.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257733',4904811,'2671','394',2211462.83,2211462.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257733',4904812,'2672','394',1502266.18,1502266.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257733',4904813,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257733',4904814,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257733',4904815,'2675','394',2634189.36,2634189.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257733',4904816,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257734',4904817,'2669','394',2588085.69,2588085.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257734',4904818,'2670','394',1585389.36,1585389.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257734',4904819,'2671','394',2211462.83,2211462.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257734',4904820,'2672','394',1502266.18,1502266.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257734',4904821,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257734',4904822,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257734',4904823,'2675','394',2634189.36,2634189.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257734',4904824,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257735',4904825,'2669','394',2588085.69,2588085.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257735',4904826,'2670','394',1585389.36,1585389.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257735',4904827,'2671','394',2211462.83,2211462.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257735',4904828,'2672','394',1502266.18,1502266.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257735',4904829,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257735',4904830,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257735',4904831,'2675','394',2634189.36,2634189.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257735',4904832,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257736',4904833,'2669','394',2588085.69,2588085.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257736',4904834,'2670','394',1585389.36,1585389.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257736',4904835,'2671','394',2211462.83,2211462.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257736',4904836,'2672','394',1502266.18,1502266.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257736',4904837,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257736',4904838,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257736',4904839,'2675','394',2634189.36,2634189.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257736',4904840,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257737',4904841,'2669','394',2588085.69,2588085.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257737',4904842,'2670','394',1585389.36,1585389.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257737',4904843,'2671','394',2211462.83,2211462.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257737',4904844,'2672','394',1502266.18,1502266.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257737',4904845,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257737',4904846,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257737',4904847,'2675','394',2634189.36,2634189.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257737',4904848,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257738',4904849,'2669','394',2588085.69,2588085.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257738',4904850,'2670','394',1585389.36,1585389.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257738',4904851,'2675','394',2634189.36,2634189.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257738',4904852,'2671','394',2211462.83,2211462.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257738',4904853,'2672','394',1502266.18,1502266.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257738',4904854,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257738',4904855,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257738',4904856,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257739',4904857,'2669','394',2588085.69,2588085.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257739',4904858,'2670','394',1585389.36,1585389.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257739',4904859,'2671','394',2211462.83,2211462.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257739',4904860,'2672','394',1502266.18,1502266.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257739',4904861,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257739',4904862,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257739',4904863,'2675','394',2634189.36,2634189.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257739',4904864,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257740',4904865,'2669','394',2588085.69,2588085.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257740',4904866,'2670','394',1585389.36,1587621.32,2231.96,491031.20,0.00,0.00,0.00,0.00,0.00),('5','104','896','257740',4904867,'2671','394',2211462.83,2211462.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257740',4904868,'2672','394',1502266.18,1502266.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257740',4904869,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257740',4904870,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257740',4904871,'2675','394',2634189.36,2634189.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257740',4904872,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257741',4904873,'2669','394',2588085.69,2591199.84,3114.15,685113.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257741',4904874,'2670','394',1587621.32,1590837.52,3216.20,707564.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257741',4904875,'2671','394',2211462.83,2211462.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257741',4904876,'2672','394',1502266.18,1502266.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257741',4904877,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257741',4904878,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257741',4904879,'2675','394',2634189.36,2635203.96,1014.60,223212.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257741',4904880,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257742',4904881,'2669','394',2591199.84,2598783.50,7583.66,1668405.20,0.00,0.00,0.00,0.00,0.00),('5','104','895','257742',4904882,'2670','394',1590837.52,1591868.75,1031.23,226870.60,0.00,0.00,0.00,0.00,0.00),('5','104','896','257742',4904883,'2671','394',2211462.83,2211462.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257742',4904884,'2672','394',1502266.18,1502266.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257742',4904885,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257742',4904886,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257742',4904887,'2675','394',2635203.96,2636068.36,864.40,190168.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257742',4904888,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257743',4904889,'2669','394',2598783.50,2606101.07,7317.57,1609865.40,0.00,0.00,0.00,0.00,0.00),('5','104','895','257743',4904890,'2670','394',1591868.75,1592181.67,312.92,68842.40,0.00,0.00,0.00,0.00,0.00),('5','104','896','257743',4904891,'2671','394',2211462.83,2211462.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257743',4904892,'2672','394',1502266.18,1502266.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257743',4904893,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257743',4904894,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257743',4904895,'2675','394',2636068.36,2637279.16,1210.80,266376.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257743',4904896,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257744',4904897,'2669','394',2606101.07,2607783.50,1682.43,370134.60,0.00,0.00,0.00,0.00,0.00),('5','104','895','257744',4904898,'2670','394',1592181.67,1592181.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257744',4904899,'2671','394',2211462.83,2211462.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257744',4904900,'2672','394',1502266.18,1502266.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257744',4904901,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257744',4904902,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257744',4904903,'2675','394',2637279.16,2637279.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257744',4904904,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257745',4904905,'2669','394',2607783.50,2607783.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257745',4904906,'2670','394',1592181.67,1592181.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257745',4904907,'2671','394',2211462.83,2211462.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257745',4904908,'2672','394',1502266.18,1502266.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257745',4904909,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257745',4904910,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257745',4904911,'2675','394',2637279.16,2637279.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257745',4904912,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257746',4904913,'2669','394',2607783.50,2607783.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257746',4904914,'2670','394',1592181.67,1592181.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257746',4904915,'2671','394',2211462.83,2211462.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257746',4904916,'2672','394',1502266.18,1502266.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257746',4904917,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257746',4904918,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257746',4904919,'2675','394',2637279.16,2637279.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257746',4904920,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257747',4904921,'2669','394',2607783.50,2611645.63,3862.13,849668.60,0.00,0.00,0.00,0.00,0.00),('5','104','895','257747',4904922,'2670','394',1592181.67,1592181.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257747',4904923,'2671','394',2211462.83,2211462.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257747',4904924,'2672','394',1502266.18,1502266.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257747',4904925,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257747',4904926,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257747',4904927,'2675','394',2637279.16,2637279.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257747',4904928,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257748',4904929,'2669','394',2611645.63,2616535.84,4890.21,1075846.20,0.00,0.00,0.00,0.00,0.00),('5','104','895','257748',4904930,'2670','394',1592181.67,1596981.08,4799.41,1055870.20,0.00,0.00,0.00,0.00,0.00),('5','104','896','257748',4904931,'2671','394',2211462.83,2211462.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257748',4904932,'2672','394',1502266.18,1502266.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257748',4904933,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257748',4904934,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257748',4904935,'2675','394',2637279.16,2637279.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257748',4904936,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257749',4904937,'2669','394',2616535.84,2621749.29,5213.45,1146959.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257749',4904938,'2670','394',1596981.08,1600726.31,3745.23,823950.60,0.00,0.00,0.00,0.00,0.00),('5','104','896','257749',4904939,'2671','394',2211462.83,2211462.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257749',4904940,'2672','394',1502266.18,1502266.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257749',4904941,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257749',4904942,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257749',4904943,'2675','394',2637279.16,2638684.10,1404.94,309086.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','257749',4904944,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257750',4904945,'2669','394',2621749.29,2625398.63,3649.34,802854.80,0.00,0.00,0.00,0.00,0.00),('5','104','895','257750',4904946,'2670','394',1600726.31,1601504.60,778.29,171223.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','257750',4904947,'2671','394',2211462.83,2211462.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257750',4904948,'2672','394',1502266.18,1502266.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257750',4904949,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257750',4904950,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257750',4904951,'2675','394',2638684.10,2638684.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257750',4904952,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257751',4904953,'2669','394',2625398.63,2625398.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257751',4904954,'2670','394',1601504.60,1601504.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257751',4904955,'2671','394',2211462.83,2211462.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257751',4904956,'2672','394',1502266.18,1502266.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257751',4904957,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257751',4904958,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257751',4904959,'2675','394',2638684.10,2638684.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257751',4904960,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257752',4904961,'2669','394',2625398.63,2625398.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257752',4904962,'2670','394',1601504.60,1601504.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257752',4904963,'2675','394',2638684.10,2640546.05,1861.95,409629.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257752',4904964,'2671','394',2211462.83,2211462.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257752',4904965,'2672','394',1502266.18,1502266.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257752',4904966,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257752',4904967,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257752',4904968,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257753',4904969,'2669','394',2625398.63,2625398.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257753',4904970,'2670','394',1601504.60,1601504.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257753',4904971,'2671','394',2211462.83,2211462.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257753',4904972,'2672','394',1502266.18,1502266.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257753',4904973,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257753',4904974,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257753',4904975,'2675','394',2640546.05,2640546.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257753',4904976,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257754',4904977,'2669','394',2625398.63,2625398.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257754',4904978,'2670','394',1601504.60,1601504.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257754',4904979,'2671','394',2211462.83,2211462.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257754',4904980,'2672','394',1502266.18,1502266.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257754',4904981,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257754',4904982,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257754',4904983,'2675','394',2640546.05,2640546.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257754',4904984,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257755',4904985,'2669','394',2625398.63,2625398.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257755',4904986,'2670','394',1601504.60,1601504.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257755',4904987,'2671','394',2211462.83,2211462.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257755',4904988,'2672','394',1502266.18,1502266.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257755',4904989,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257755',4904990,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257755',4904991,'2675','394',2640546.05,2640546.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257755',4904992,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257756',4904993,'2669','394',2625398.63,2625398.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257756',4904994,'2670','394',1601504.60,1601581.98,77.38,16249.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','257756',4904995,'2671','394',2211462.83,2211462.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257756',4904996,'2672','394',1502266.18,1503273.77,1007.59,211593.90,0.00,0.00,0.00,0.00,0.00),('5','104','897','257756',4904997,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257756',4904998,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257756',4904999,'2675','394',2640546.05,2641247.96,701.91,147401.10,0.00,0.00,0.00,0.00,0.00),('5','104','896','257756',4905000,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257757',4905001,'2669','394',2625398.63,2625398.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257757',4905002,'2670','394',1601581.98,1601581.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257757',4905003,'2671','394',2211462.83,2213806.55,2343.72,492181.20,0.00,0.00,0.00,0.00,0.00),('5','104','896','257757',4905004,'2672','394',1503273.77,1504283.27,1009.50,211995.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257757',4905005,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257757',4905006,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257757',4905007,'2675','394',2641247.96,2642105.05,857.09,179988.90,0.00,0.00,0.00,0.00,0.00),('5','104','896','257757',4905008,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257758',4905009,'2669','394',2625398.63,2625398.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257758',4905010,'2670','394',1601581.98,1603609.00,2027.02,425674.20,0.00,0.00,0.00,0.00,0.00),('5','104','896','257758',4905011,'2671','394',2213806.55,2214101.72,295.17,61985.70,0.00,0.00,0.00,0.00,0.00),('5','104','896','257758',4905012,'2672','394',1504283.27,1509158.81,4875.54,1023863.40,0.00,0.00,0.00,0.00,0.00),('5','104','897','257758',4905013,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257758',4905014,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257758',4905015,'2675','394',2642105.05,2646541.25,4436.20,931602.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257758',4905016,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257759',4905017,'2669','394',2625398.63,2635399.77,10001.14,2100239.40,0.00,0.00,0.00,0.00,0.00),('5','104','895','257759',4905018,'2670','394',1603609.00,1608611.16,5002.16,1050453.60,0.00,0.00,0.00,0.00,0.00),('5','104','896','257759',4905019,'2671','394',2214101.72,2215097.60,995.88,209134.80,0.00,0.00,0.00,0.00,0.00),('5','104','896','257759',4905020,'2672','394',1509158.81,1512606.29,3447.48,723970.80,0.00,0.00,0.00,0.00,0.00),('5','104','897','257759',4905021,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257759',4905022,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257759',4905023,'2675','394',2646541.25,2646541.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257759',4905024,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257760',4905025,'2669','394',2635399.77,2638614.24,3214.47,675038.70,0.00,0.00,0.00,0.00,0.00),('5','104','895','257760',4905026,'2670','394',1608611.16,1619737.41,11126.25,2336512.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','257760',4905027,'2671','394',2215097.60,2215097.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257760',4905028,'2672','394',1512606.29,1516461.79,3855.50,809655.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257760',4905029,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257760',4905030,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257760',4905031,'2675','394',2646541.25,2658100.91,11559.66,2427528.60,0.00,0.00,0.00,0.00,0.00),('5','104','896','257760',4905032,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257761',4905033,'2669','394',2638614.24,2638614.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257761',4905034,'2670','394',1619737.41,1634246.48,14509.07,3046904.70,0.00,0.00,0.00,0.00,0.00),('5','104','896','257761',4905035,'2671','394',2215097.60,2215097.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257761',4905036,'2672','394',1516461.79,1518622.99,2161.20,453852.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257761',4905037,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257761',4905038,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257761',4905039,'2675','394',2658100.91,2673112.40,15011.49,3152412.90,0.00,0.00,0.00,0.00,0.00),('5','104','896','257761',4905040,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257762',4905041,'2669','394',2638614.24,2648298.26,9684.02,2033644.20,0.00,0.00,0.00,0.00,0.00),('5','104','895','257762',4905042,'2670','394',1634246.48,1636843.61,2597.13,545397.30,0.00,0.00,0.00,0.00,0.00),('5','104','896','257762',4905043,'2671','394',2215097.60,2215097.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257762',4905044,'2672','394',1518622.99,1538293.14,19670.15,4130731.50,0.00,0.00,0.00,0.00,0.00),('5','104','897','257762',4905045,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257762',4905046,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257762',4905047,'2675','394',2673112.40,2675320.15,2207.75,463627.50,0.00,0.00,0.00,0.00,0.00),('5','104','896','257762',4905048,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257763',4905049,'2669','394',2648298.26,2648298.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257763',4905050,'2670','394',1636843.61,1638487.26,1643.65,345166.50,0.00,0.00,0.00,0.00,0.00),('5','104','895','257763',4905051,'2675','394',2675320.15,2675444.45,124.30,26103.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257763',4905052,'2671','394',2215097.60,2216521.84,1424.24,299090.40,0.00,0.00,0.00,0.00,0.00),('5','104','896','257763',4905053,'2672','394',1538293.14,1545441.73,7148.59,1501203.90,0.00,0.00,0.00,0.00,0.00),('5','104','896','257763',4905054,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257763',4905055,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257763',4905056,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257764',4905057,'2669','394',2648298.26,2648298.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257764',4905058,'2670','394',1638487.26,1648622.42,10135.16,2128383.60,0.00,0.00,0.00,0.00,0.00),('5','104','896','257764',4905059,'2671','394',2216521.84,2216521.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257764',4905060,'2672','394',1545441.73,1545441.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257764',4905061,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257764',4905062,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257764',4905063,'2675','394',2675444.45,2675444.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257764',4905064,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257765',4905065,'2669','394',2648298.26,2648298.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257765',4905066,'2670','394',1648622.42,1648622.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257765',4905067,'2671','394',2216521.84,2216521.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257765',4905068,'2672','394',1545441.73,1545441.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257765',4905069,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257765',4905070,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257765',4905071,'2675','394',2675444.45,2675444.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257765',4905072,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257766',4905073,'2669','394',2648298.26,2648298.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257766',4905074,'2670','394',1648622.42,1648622.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257766',4905075,'2671','394',2216521.84,2216521.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257766',4905076,'2672','394',1545441.73,1545441.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257766',4905077,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257766',4905078,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257766',4905079,'2675','394',2675444.45,2675444.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257766',4905080,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257767',4905081,'2669','394',2648298.26,2648298.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257767',4905082,'2670','394',1648622.42,1648622.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257767',4905083,'2671','394',2216521.84,2216521.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257767',4905084,'2672','394',1545441.73,1545441.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','897','257767',4905085,'2673','395',1404731.74,1404731.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','898','257767',4905086,'2674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','895','257767',4905087,'2675','394',2675444.45,2675444.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','104','896','257767',4905088,'2676','394',1357591.20,1357591.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=730486 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('5','104','181487','394',0.00,0.00,7575328.18,0.00,0.00,0.00,0.00,532395),('5','104','181487','395',0.00,0.00,1227364.02,0.00,0.00,0.00,0.00,532396),('5','104','181487','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,532397),('5','104','181491','394',0.00,163.00,0.00,0.00,0.00,0.00,0.00,532407),('5','104','181491','395',0.00,240.00,0.00,0.00,0.00,0.00,0.00,532408),('5','104','181491','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,532409),('5','104','181497','394',0.00,163.00,-163.00,0.00,0.00,0.00,0.00,532423),('5','104','181497','395',0.00,250.00,0.00,0.00,0.00,0.00,0.00,532424),('5','104','181497','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,532425),('5','104','181500','394',0.00,163.00,1477032223.00,0.00,0.00,0.00,0.00,532432),('5','104','181500','395',0.00,250.00,72000.00,0.00,0.00,0.00,0.00,532433),('5','104','181500','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,532434),('5','104','181508','394',0.00,163.00,22771.92,0.00,0.00,0.00,0.00,532456),('5','104','181508','395',0.00,250.00,0.00,0.00,0.00,0.00,0.00,532457),('5','104','181508','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,532458),('5','104','181545','394',0.00,163.00,0.00,0.00,0.00,0.00,0.00,532531),('5','104','181545','395',0.00,250.00,0.00,0.00,0.00,0.00,0.00,532532),('5','104','181545','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,532533),('5','104','181639','394',0.00,163.00,23831.26,0.00,0.00,0.00,0.00,532785),('5','104','181639','395',0.00,250.00,640.80,0.00,0.00,0.00,0.00,532786),('5','104','181639','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,532787),('5','104','181886','394',0.00,163.00,7557.62,0.00,0.00,0.00,0.00,533460),('5','104','181886','395',0.00,250.00,2047.20,0.00,0.00,0.00,0.00,533461),('5','104','181886','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,533462),('5','104','182054','394',0.00,163.00,0.00,0.00,0.00,0.00,0.00,533914),('5','104','182054','395',0.00,250.00,0.00,0.00,0.00,0.00,0.00,533915),('5','104','182054','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,533916),('5','104','182402','394',0.00,163.00,0.00,0.00,0.00,0.00,0.00,534812),('5','104','182402','395',0.00,250.00,2501.81,0.00,0.00,0.00,0.00,534813),('5','104','182402','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,534814),('5','104','182661','394',0.00,163.00,0.00,0.00,0.00,0.00,0.00,535508),('5','104','182661','395',0.00,250.00,902.39,0.00,0.00,0.00,0.00,535509),('5','104','182661','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,535510),('5','104','182981','394',0.00,163.00,0.00,0.00,0.00,0.00,0.00,536381),('5','104','182981','395',0.00,265.00,2502.07,0.00,0.00,0.00,0.00,536382),('5','104','182981','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,536383),('5','104','183167','394',0.00,163.00,43196.63,0.00,0.00,0.00,0.00,536851),('5','104','183167','395',0.00,265.00,2828.55,0.00,0.00,0.00,0.00,536852),('5','104','183167','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,536853),('5','104','183827','394',163.00,163.00,0.00,0.00,0.00,0.00,0.00,538588),('5','104','183827','395',0.00,265.00,0.00,0.00,0.00,0.00,0.00,538589),('5','104','183827','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,538590),('5','104','184229','394',163.00,163.00,32373.60,0.00,0.00,0.00,0.00,539651),('5','104','184229','395',0.00,255.00,2586.10,0.00,0.00,0.00,0.00,539652),('5','104','184229','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,539653),('5','104','184358','394',163.00,163.00,58718.93,0.00,0.00,0.00,0.00,539985),('5','104','184358','395',0.00,255.00,4674.06,0.00,0.00,0.00,0.00,539986),('5','104','184358','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,539987),('5','104','184387','394',163.00,163.00,13302.28,0.00,0.00,0.00,0.00,540064),('5','104','184387','395',0.00,255.00,0.00,0.00,0.00,0.00,0.00,540065),('5','104','184387','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,540066),('5','104','184623','394',163.00,163.00,19532.59,0.00,0.00,0.00,0.00,540694),('5','104','184623','395',0.00,255.00,0.00,0.00,0.00,0.00,0.00,540695),('5','104','184623','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,540696),('5','104','184776','394',163.00,163.00,7228.46,0.00,0.00,0.00,0.00,541102),('5','104','184776','395',0.00,255.00,0.00,0.00,0.00,0.00,0.00,541103),('5','104','184776','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,541104),('5','104','184872','394',163.00,163.00,16900.71,0.00,0.00,0.00,0.00,541359),('5','104','184872','395',0.00,265.00,0.00,0.00,0.00,0.00,0.00,541360),('5','104','184872','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,541361),('5','104','185190','394',163.00,163.00,21391.08,0.00,0.00,0.00,0.00,542176),('5','104','185190','395',0.00,265.00,0.00,0.00,0.00,0.00,0.00,542177),('5','104','185190','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,542178),('5','104','185270','394',163.00,163.00,15260.74,0.00,0.00,0.00,0.00,542353),('5','104','185270','395',0.00,265.00,0.00,0.00,0.00,0.00,0.00,542354),('5','104','185270','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,542355),('5','104','185725','394',163.00,163.00,12945.73,0.00,0.00,0.00,0.00,543569),('5','104','185725','395',0.00,265.00,0.00,0.00,0.00,0.00,0.00,543570),('5','104','185725','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,543571),('5','104','185863','394',163.00,163.00,12446.46,0.00,0.00,0.00,0.00,543955),('5','104','185863','395',0.00,265.00,0.00,0.00,0.00,0.00,0.00,543956),('5','104','185863','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,543957),('5','104','185950','394',163.00,163.00,18998.27,0.00,0.00,0.00,0.00,544172),('5','104','185950','395',0.00,265.00,0.00,0.00,0.00,0.00,0.00,544173),('5','104','185950','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,544174),('5','104','186413','394',163.00,163.00,11951.45,0.00,0.00,0.00,0.00,545395),('5','104','186413','395',0.00,265.00,0.00,0.00,0.00,0.00,0.00,545396),('5','104','186413','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,545397),('5','104','186516','394',163.00,163.00,11415.33,0.00,0.00,0.00,0.00,545677),('5','104','186516','395',0.00,265.00,0.00,0.00,0.00,0.00,0.00,545678),('5','104','186516','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,545679),('5','104','186668','394',163.00,163.00,16729.12,0.00,0.00,0.00,0.00,546059),('5','104','186668','395',0.00,265.00,0.00,0.00,0.00,0.00,0.00,546060),('5','104','186668','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,546061),('5','104','186936','394',163.00,163.00,5935.54,0.00,0.00,0.00,0.00,546737),('5','104','186936','395',0.00,265.00,0.00,0.00,0.00,0.00,0.00,546738),('5','104','186936','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,546739),('5','104','187141','394',163.00,163.00,21409.22,0.00,0.00,0.00,0.00,547290),('5','104','187141','395',0.00,265.00,0.00,0.00,0.00,0.00,0.00,547291),('5','104','187141','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,547292),('5','104','187475','394',163.00,163.00,12984.69,0.00,0.00,0.00,0.00,548162),('5','104','187475','395',0.00,265.00,0.00,0.00,0.00,0.00,0.00,548163),('5','104','187475','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,548164),('5','104','187552','394',163.00,163.00,23438.27,0.00,0.00,0.00,0.00,548370),('5','104','187552','395',0.00,265.00,0.00,0.00,0.00,0.00,0.00,548371),('5','104','187552','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,548372),('5','104','187622','394',163.00,163.00,11285.87,0.00,0.00,0.00,0.00,548538),('5','104','187622','395',0.00,265.00,0.00,0.00,0.00,0.00,0.00,548539),('5','104','187622','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,548540),('5','104','187813','394',163.00,163.00,12570.64,0.00,0.00,0.00,0.00,549049),('5','104','187813','395',0.00,265.00,0.00,0.00,0.00,0.00,0.00,549050),('5','104','187813','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,549051),('5','104','188003','394',163.00,163.00,14455.35,0.00,0.00,0.00,0.00,549549),('5','104','188003','395',0.00,265.00,0.00,0.00,0.00,0.00,0.00,549550),('5','104','188003','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,549551),('5','104','188716','394',163.00,163.00,16980.68,0.00,0.00,0.00,0.00,551390),('5','104','188716','395',0.00,265.00,0.00,0.00,0.00,0.00,0.00,551391),('5','104','188716','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,551392),('5','104','188721','394',163.00,163.00,18387.09,0.00,0.00,0.00,0.00,551403),('5','104','188721','395',0.00,265.00,0.00,0.00,0.00,0.00,0.00,551404),('5','104','188721','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,551405),('5','104','188723','394',163.00,163.00,13083.61,0.00,0.00,0.00,0.00,551409),('5','104','188723','395',0.00,265.00,0.00,0.00,0.00,0.00,0.00,551410),('5','104','188723','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,551411),('5','104','188832','394',163.00,163.00,33301.70,0.00,0.00,0.00,0.00,551694),('5','104','188832','395',0.00,265.00,721.75,0.00,0.00,0.00,0.00,551695),('5','104','188832','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,551696),('5','104','189089','394',163.00,163.00,12013.54,0.00,0.00,0.00,0.00,552371),('5','104','189089','395',265.00,265.00,1179.46,0.00,0.00,0.00,0.00,552372),('5','104','189089','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,552373),('5','104','189233','394',163.00,163.00,0.00,0.00,0.00,0.00,0.00,552741),('5','104','189233','395',265.00,265.00,1265.45,0.00,0.00,0.00,0.00,552742),('5','104','189233','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,552743),('5','104','189410','394',163.00,163.00,0.00,0.00,0.00,0.00,0.00,553226),('5','104','189410','395',265.00,265.00,2391.20,0.00,0.00,0.00,0.00,553227),('5','104','189410','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,553228),('5','104','189608','394',163.00,163.00,0.00,0.00,0.00,0.00,0.00,553733),('5','104','189608','395',265.00,265.00,1501.49,0.00,0.00,0.00,0.00,553734),('5','104','189608','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,553735),('5','104','189848','394',163.00,163.00,19820.61,0.00,0.00,0.00,0.00,554330),('5','104','189848','395',265.00,265.00,1920.66,0.00,0.00,0.00,0.00,554331),('5','104','189848','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,554332),('5','104','190075','394',163.00,163.00,10139.51,0.00,0.00,0.00,0.00,554935),('5','104','190075','395',265.00,265.00,790.91,0.00,0.00,0.00,0.00,554936),('5','104','190075','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,554937),('5','104','190278','394',163.00,163.00,0.00,0.00,0.00,0.00,0.00,555464),('5','104','190278','395',265.00,265.00,1341.25,0.00,0.00,0.00,0.00,555465),('5','104','190278','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,555466),('5','104','190457','394',163.00,165.00,16973.26,0.00,0.00,0.00,0.00,555928),('5','104','190457','395',265.00,265.00,1787.78,0.00,0.00,0.00,0.00,555929),('5','104','190457','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,555930),('5','104','190806','394',165.00,165.00,13976.46,0.00,0.00,0.00,0.00,556868),('5','104','190806','395',265.00,265.00,2422.98,0.00,0.00,0.00,0.00,556869),('5','104','190806','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556870),('5','104','190917','394',165.00,165.00,13054.58,0.00,0.00,0.00,0.00,557145),('5','104','190917','395',265.00,265.00,1187.62,0.00,0.00,0.00,0.00,557146),('5','104','190917','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,557147),('5','104','191744','394',165.00,165.00,14952.02,0.00,0.00,0.00,0.00,559326),('5','104','191744','395',265.00,265.00,3407.11,0.00,0.00,0.00,0.00,559327),('5','104','191744','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,559328),('5','104','191797','394',165.00,165.00,12863.64,0.00,0.00,0.00,0.00,559477),('5','104','191797','395',265.00,265.00,1671.09,0.00,0.00,0.00,0.00,559478),('5','104','191797','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,559479),('5','104','191811','394',165.00,165.00,10623.99,0.00,0.00,0.00,0.00,559518),('5','104','191811','395',265.00,265.00,1419.00,0.00,0.00,0.00,0.00,559519),('5','104','191811','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,559520),('5','104','191829','394',165.00,165.00,18626.89,0.00,0.00,0.00,0.00,559570),('5','104','191829','395',265.00,265.00,864.20,0.00,0.00,0.00,0.00,559571),('5','104','191829','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,559572),('5','104','191977','394',165.00,165.00,3015.77,0.00,0.00,0.00,0.00,559953),('5','104','191977','395',265.00,265.00,396.41,0.00,0.00,0.00,0.00,559954),('5','104','191977','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,559955),('5','104','192259','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,560712),('5','104','192259','395',265.00,265.00,1721.41,0.00,0.00,0.00,0.00,560713),('5','104','192259','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,560714),('5','104','192378','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,561008),('5','104','192378','395',265.00,265.00,1045.24,0.00,0.00,0.00,0.00,561009),('5','104','192378','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,561010),('5','104','192611','394',165.00,165.00,15901.60,0.00,0.00,0.00,0.00,561618),('5','104','192611','395',265.00,265.00,1149.58,0.00,0.00,0.00,0.00,561619),('5','104','192611','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,561620),('5','104','192800','394',165.00,165.00,11701.67,0.00,0.00,0.00,0.00,562097),('5','104','192800','395',265.00,265.00,652.51,0.00,0.00,0.00,0.00,562098),('5','104','192800','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,562099),('5','104','193041','394',165.00,165.00,4408.30,0.00,0.00,0.00,0.00,562738),('5','104','193041','395',265.00,265.00,158.64,0.00,0.00,0.00,0.00,562739),('5','104','193041','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,562740),('5','104','193245','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,563292),('5','104','193245','395',265.00,265.00,865.80,0.00,0.00,0.00,0.00,563293),('5','104','193245','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,563294),('5','104','193429','394',165.00,165.00,11423.36,0.00,0.00,0.00,0.00,563759),('5','104','193429','395',265.00,265.00,0.00,0.00,0.00,0.00,0.00,563760),('5','104','193429','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,563761),('5','104','193898','394',165.00,165.00,922.14,0.00,0.00,0.00,0.00,564950),('5','104','193898','395',265.00,265.00,657.19,0.00,0.00,0.00,0.00,564951),('5','104','193898','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,564952),('5','104','193914','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,564990),('5','104','193914','395',265.00,265.00,511.76,0.00,0.00,0.00,0.00,564991),('5','104','193914','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,564992),('5','104','194151','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,565601),('5','104','194151','395',265.00,265.00,1363.70,0.00,0.00,0.00,0.00,565602),('5','104','194151','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,565603),('5','104','194394','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,566227),('5','104','194394','395',265.00,265.00,454.75,0.00,0.00,0.00,0.00,566228),('5','104','194394','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,566229),('5','104','194565','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,566655),('5','104','194565','395',265.00,265.00,525.97,0.00,0.00,0.00,0.00,566656),('5','104','194565','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,566657),('5','104','194936','394',165.00,165.00,5936.76,0.00,0.00,0.00,0.00,567634),('5','104','194936','395',265.00,265.00,618.64,0.00,0.00,0.00,0.00,567635),('5','104','194936','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,567636),('5','104','195057','394',165.00,165.00,9673.45,0.00,0.00,0.00,0.00,567954),('5','104','195057','395',265.00,265.00,382.99,0.00,0.00,0.00,0.00,567955),('5','104','195057','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,567956),('5','104','195178','394',165.00,165.00,10594.75,0.00,0.00,0.00,0.00,568263),('5','104','195178','395',265.00,265.00,2562.68,0.00,0.00,0.00,0.00,568264),('5','104','195178','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,568265),('5','104','195400','394',165.00,165.00,13443.30,0.00,0.00,0.00,0.00,568823),('5','104','195400','395',265.00,265.00,1983.76,0.00,0.00,0.00,0.00,568824),('5','104','195400','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,568825),('5','104','195727','394',165.00,165.00,15768.43,0.00,0.00,0.00,0.00,569651),('5','104','195727','395',265.00,265.00,1712.01,0.00,0.00,0.00,0.00,569652),('5','104','195727','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,569653),('5','104','195879','394',165.00,165.00,5011.99,0.00,0.00,0.00,0.00,570025),('5','104','195879','395',265.00,265.00,312.28,0.00,0.00,0.00,0.00,570026),('5','104','195879','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,570027),('5','104','196107','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,570610),('5','104','196107','395',265.00,265.00,178.94,0.00,0.00,0.00,0.00,570611),('5','104','196107','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,570612),('5','104','196316','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,571137),('5','104','196316','395',265.00,265.00,540.67,0.00,0.00,0.00,0.00,571138),('5','104','196316','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,571139),('5','104','196516','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,571657),('5','104','196516','395',265.00,265.00,365.57,0.00,0.00,0.00,0.00,571658),('5','104','196516','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,571659),('5','104','196811','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,572428),('5','104','196811','395',265.00,265.00,168.69,0.00,0.00,0.00,0.00,572429),('5','104','196811','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,572430),('5','104','196859','394',165.00,165.00,6243.23,0.00,0.00,0.00,0.00,572558),('5','104','196859','395',265.00,265.00,1006.66,0.00,0.00,0.00,0.00,572559),('5','104','196859','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,572560),('5','104','197210','394',165.00,165.00,8342.56,0.00,0.00,0.00,0.00,573474),('5','104','197210','395',265.00,265.00,1103.14,0.00,0.00,0.00,0.00,573475),('5','104','197210','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,573476),('5','104','197500','394',165.00,165.00,10204.09,0.00,0.00,0.00,0.00,574133),('5','104','197500','395',265.00,265.00,1862.13,0.00,0.00,0.00,0.00,574134),('5','104','197500','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,574135),('5','104','197992','394',165.00,165.00,10557.19,0.00,0.00,0.00,0.00,575438),('5','104','197992','395',265.00,265.00,1190.52,0.00,0.00,0.00,0.00,575439),('5','104','197992','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,575440),('5','104','198009','394',165.00,165.00,13107.93,0.00,0.00,0.00,0.00,575482),('5','104','198009','395',265.00,270.00,689.26,0.00,0.00,0.00,0.00,575483),('5','104','198009','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,575484),('5','104','198016','394',165.00,165.00,9518.16,0.00,0.00,0.00,0.00,575497),('5','104','198016','395',265.00,270.00,899.54,0.00,0.00,0.00,0.00,575498),('5','104','198016','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,575499),('5','104','198220','394',165.00,165.00,8575.94,0.00,0.00,0.00,0.00,576001),('5','104','198220','395',265.00,270.00,2710.10,0.00,0.00,0.00,0.00,576002),('5','104','198220','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,576003),('5','104','198434','394',165.00,165.00,9665.31,0.00,0.00,0.00,0.00,576567),('5','104','198434','395',265.00,270.00,685.04,0.00,0.00,0.00,0.00,576568),('5','104','198434','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,576569),('5','104','198744','394',165.00,165.00,9947.91,0.00,0.00,0.00,0.00,577386),('5','104','198744','395',265.00,270.00,1194.14,0.00,0.00,0.00,0.00,577387),('5','104','198744','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,577388),('5','104','198834','394',165.00,165.00,9353.31,0.00,0.00,0.00,0.00,577573),('5','104','198834','395',265.00,270.00,1864.35,0.00,0.00,0.00,0.00,577574),('5','104','198834','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,577575),('5','104','199044','394',165.00,165.00,8387.37,0.00,0.00,0.00,0.00,578129),('5','104','199044','395',265.00,270.00,498.28,0.00,0.00,0.00,0.00,578130),('5','104','199044','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,578131),('5','104','199296','394',165.00,165.00,10369.82,0.00,0.00,0.00,0.00,578726),('5','104','199296','395',265.00,270.00,1415.22,0.00,0.00,0.00,0.00,578727),('5','104','199296','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,578728),('5','104','199602','394',165.00,165.00,9199.91,0.00,0.00,0.00,0.00,579529),('5','104','199602','395',265.00,270.00,1954.82,0.00,0.00,0.00,0.00,579530),('5','104','199602','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,579531),('5','104','199774','394',165.00,165.00,8931.42,0.00,0.00,0.00,0.00,579918),('5','104','199774','395',265.00,270.00,997.26,0.00,0.00,0.00,0.00,579919),('5','104','199774','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,579920),('5','104','199981','394',165.00,165.00,9539.78,0.00,0.00,0.00,0.00,580462),('5','104','199981','395',265.00,270.00,2020.98,0.00,0.00,0.00,0.00,580463),('5','104','199981','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,580464),('5','104','200157','394',165.00,165.00,10806.30,0.00,0.00,0.00,0.00,580915),('5','104','200157','395',265.00,270.00,798.09,0.00,0.00,0.00,0.00,580916),('5','104','200157','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,580917),('5','104','200326','394',165.00,165.00,9726.64,0.00,0.00,0.00,0.00,581351),('5','104','200326','395',265.00,270.00,0.00,0.00,0.00,0.00,0.00,581352),('5','104','200326','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,581353),('5','104','200521','394',165.00,165.00,9383.89,0.00,0.00,0.00,0.00,581859),('5','104','200521','395',265.00,270.00,0.00,0.00,0.00,0.00,0.00,581860),('5','104','200521','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,581861),('5','104','200755','394',165.00,165.00,10303.75,0.00,0.00,0.00,0.00,582468),('5','104','200755','395',265.00,270.00,0.00,0.00,0.00,0.00,0.00,582469),('5','104','200755','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,582470),('5','104','200976','394',165.00,165.00,10007.31,0.00,0.00,0.00,0.00,583024),('5','104','200976','395',265.00,270.00,0.00,0.00,0.00,0.00,0.00,583025),('5','104','200976','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,583026),('5','104','201190','394',165.00,165.00,10559.62,0.00,0.00,0.00,0.00,583573),('5','104','201190','395',265.00,270.00,0.00,0.00,0.00,0.00,0.00,583574),('5','104','201190','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,583575),('5','104','201365','394',165.00,165.00,10085.13,0.00,0.00,0.00,0.00,584024),('5','104','201365','395',265.00,270.00,0.00,0.00,0.00,0.00,0.00,584025),('5','104','201365','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,584026),('5','104','201572','394',165.00,165.00,10424.78,0.00,0.00,0.00,0.00,584567),('5','104','201572','395',265.00,270.00,1321.25,0.00,0.00,0.00,0.00,584568),('5','104','201572','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,584569),('5','104','201784','394',165.00,165.00,8482.31,0.00,0.00,0.00,0.00,585131),('5','104','201784','395',270.00,275.00,702.88,0.00,0.00,0.00,0.00,585132),('5','104','201784','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,585133),('5','104','202061','394',165.00,165.00,8712.43,0.00,0.00,0.00,0.00,585862),('5','104','202061','395',270.00,275.00,611.70,0.00,0.00,0.00,0.00,585863),('5','104','202061','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,585864),('5','104','202196','394',165.00,165.00,8727.28,0.00,0.00,0.00,0.00,586215),('5','104','202196','395',270.00,275.00,910.00,0.00,0.00,0.00,0.00,586216),('5','104','202196','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,586217),('5','104','202422','394',165.00,165.00,8267.46,0.00,0.00,0.00,0.00,586792),('5','104','202422','395',275.00,275.00,570.70,0.00,0.00,0.00,0.00,586793),('5','104','202422','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,586794),('5','104','202746','394',165.00,165.00,8661.56,0.00,0.00,0.00,0.00,587613),('5','104','202746','395',275.00,275.00,864.60,0.00,0.00,0.00,0.00,587614),('5','104','202746','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,587615),('5','104','202906','394',165.00,165.00,9134.41,0.00,0.00,0.00,0.00,588025),('5','104','202906','395',275.00,275.00,646.80,0.00,0.00,0.00,0.00,588026),('5','104','202906','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,588027),('5','104','203095','394',165.00,165.00,9210.65,0.00,0.00,0.00,0.00,588537),('5','104','203095','395',275.00,275.00,923.70,0.00,0.00,0.00,0.00,588538),('5','104','203095','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,588539),('5','104','203301','394',165.00,165.00,9102.83,0.00,0.00,0.00,0.00,589078),('5','104','203301','395',275.00,275.00,618.60,0.00,0.00,0.00,0.00,589079),('5','104','203301','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,589080),('5','104','203535','394',165.00,165.00,7893.92,0.00,0.00,0.00,0.00,589658),('5','104','203535','395',275.00,275.00,1249.20,0.00,0.00,0.00,0.00,589659),('5','104','203535','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,589660),('5','104','203893','394',165.00,165.00,9802.70,0.00,0.00,0.00,0.00,590604),('5','104','203893','395',275.00,275.00,1898.60,0.00,0.00,0.00,0.00,590605),('5','104','203893','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,590606),('5','104','203986','394',165.00,165.00,8906.15,0.00,0.00,0.00,0.00,590813),('5','104','203986','395',275.00,275.00,1614.80,0.00,0.00,0.00,0.00,590814),('5','104','203986','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,590815),('5','104','204221','394',165.00,165.00,8781.12,0.00,0.00,0.00,0.00,591432),('5','104','204221','395',275.00,275.00,989.50,0.00,0.00,0.00,0.00,591433),('5','104','204221','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,591434),('5','104','204469','394',165.00,165.00,8547.35,0.00,0.00,0.00,0.00,592084),('5','104','204469','395',275.00,275.00,1014.60,0.00,0.00,0.00,0.00,592085),('5','104','204469','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,592086),('5','104','204662','394',165.00,165.00,10228.26,0.00,0.00,0.00,0.00,592565),('5','104','204662','395',275.00,275.00,878.12,0.00,0.00,0.00,0.00,592566),('5','104','204662','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,592567),('5','104','204902','394',165.00,165.00,9078.70,0.00,0.00,0.00,0.00,593151),('5','104','204902','395',275.00,275.00,0.00,0.00,0.00,0.00,0.00,593152),('5','104','204902','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,593153),('5','104','205122','394',165.00,165.00,7188.91,0.00,0.00,0.00,0.00,593722),('5','104','205122','395',275.00,275.00,0.00,0.00,0.00,0.00,0.00,593723),('5','104','205122','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,593724),('5','104','205255','394',165.00,165.00,10944.19,0.00,0.00,0.00,0.00,594066),('5','104','205255','395',275.00,280.00,0.00,0.00,0.00,0.00,0.00,594067),('5','104','205255','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,594068),('5','104','205489','394',165.00,165.00,7805.04,0.00,0.00,0.00,0.00,594654),('5','104','205489','395',275.00,280.00,0.00,0.00,0.00,0.00,0.00,594655),('5','104','205489','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,594656),('5','104','205752','394',165.00,165.00,8141.87,0.00,0.00,0.00,0.00,595344),('5','104','205752','395',275.00,280.00,0.00,0.00,0.00,0.00,0.00,595345),('5','104','205752','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,595346),('5','104','205959','394',165.00,165.00,7136.33,0.00,0.00,0.00,0.00,595881),('5','104','205959','395',275.00,290.00,0.00,0.00,0.00,0.00,0.00,595882),('5','104','205959','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,595883),('5','104','206234','394',165.00,165.00,2404.45,0.00,0.00,0.00,0.00,596592),('5','104','206234','395',275.00,290.00,0.00,0.00,0.00,0.00,0.00,596593),('5','104','206234','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,596594),('5','104','206351','394',165.00,165.00,1871.13,0.00,0.00,0.00,0.00,596892),('5','104','206351','395',275.00,290.00,0.00,0.00,0.00,0.00,0.00,596893),('5','104','206351','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,596894),('5','104','206682','394',165.00,165.00,7603.31,0.00,0.00,0.00,0.00,597735),('5','104','206682','395',275.00,290.00,0.00,0.00,0.00,0.00,0.00,597736),('5','104','206682','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,597737),('5','104','206837','394',165.00,165.00,10253.41,0.00,0.00,0.00,0.00,598126),('5','104','206837','395',275.00,290.00,0.00,0.00,0.00,0.00,0.00,598127),('5','104','206837','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,598128),('5','104','207058','394',165.00,165.00,9001.00,0.00,0.00,0.00,0.00,598697),('5','104','207058','395',275.00,290.00,0.00,0.00,0.00,0.00,0.00,598698),('5','104','207058','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,598699),('5','104','207250','394',165.00,165.00,7770.40,0.00,0.00,0.00,0.00,599204),('5','104','207250','395',275.00,290.00,0.00,0.00,0.00,0.00,0.00,599205),('5','104','207250','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,599206),('5','104','207494','394',165.00,165.00,9261.49,0.00,0.00,0.00,0.00,599832),('5','104','207494','395',275.00,290.00,0.00,0.00,0.00,0.00,0.00,599833),('5','104','207494','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,599834),('5','104','207732','394',165.00,165.00,9595.63,0.00,0.00,0.00,0.00,600424),('5','104','207732','395',275.00,290.00,0.00,0.00,0.00,0.00,0.00,600425),('5','104','207732','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,600426),('5','104','207916','394',165.00,165.00,8397.59,0.00,0.00,0.00,0.00,600897),('5','104','207916','395',275.00,290.00,0.00,0.00,0.00,0.00,0.00,600898),('5','104','207916','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,600899),('5','104','208138','394',165.00,165.00,7576.07,0.00,0.00,0.00,0.00,601470),('5','104','208138','395',275.00,290.00,0.00,0.00,0.00,0.00,0.00,601471),('5','104','208138','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,601472),('5','104','208314','394',165.00,165.00,9354.47,0.00,0.00,0.00,0.00,601930),('5','104','208314','395',275.00,290.00,0.00,0.00,0.00,0.00,0.00,601931),('5','104','208314','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,601932),('5','104','208606','394',165.00,165.00,8148.10,0.00,0.00,0.00,0.00,602666),('5','104','208606','395',275.00,290.00,0.00,0.00,0.00,0.00,0.00,602667),('5','104','208606','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,602668),('5','104','208792','394',165.00,165.00,7692.11,0.00,0.00,0.00,0.00,603139),('5','104','208792','395',275.00,290.00,0.00,0.00,0.00,0.00,0.00,603140),('5','104','208792','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,603141),('5','104','209020','394',165.00,165.00,8384.05,0.00,0.00,0.00,0.00,603714),('5','104','209020','395',275.00,290.00,0.00,0.00,0.00,0.00,0.00,603715),('5','104','209020','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,603716),('5','104','209226','394',165.00,165.00,8929.75,0.00,0.00,0.00,0.00,604252),('5','104','209226','395',275.00,290.00,0.00,0.00,0.00,0.00,0.00,604253),('5','104','209226','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,604254),('5','104','209502','394',165.00,165.00,4901.62,0.00,0.00,0.00,0.00,604957),('5','104','209502','395',275.00,290.00,0.00,0.00,0.00,0.00,0.00,604958),('5','104','209502','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,604959),('5','104','209638','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,605311),('5','104','209638','395',275.00,290.00,0.00,0.00,0.00,0.00,0.00,605312),('5','104','209638','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,605313),('5','104','210416','394',165.00,165.00,6841.27,0.00,0.00,0.00,0.00,607322),('5','104','210416','395',275.00,290.00,0.00,0.00,0.00,0.00,0.00,607323),('5','104','210416','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,607324),('5','104','210450','394',165.00,165.00,8147.11,0.00,0.00,0.00,0.00,607423),('5','104','210450','395',275.00,290.00,0.00,0.00,0.00,0.00,0.00,607424),('5','104','210450','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,607425),('5','104','210598','394',165.00,165.00,8941.25,0.00,0.00,0.00,0.00,607803),('5','104','210598','395',275.00,295.00,0.00,0.00,0.00,0.00,0.00,607804),('5','104','210598','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,607805),('5','104','210760','394',165.00,295.00,0.00,0.00,0.00,0.00,0.00,608232),('5','104','210760','395',275.00,165.00,0.00,0.00,0.00,0.00,0.00,608233),('5','104','210760','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,608234),('5','104','211437','394',165.00,165.00,10025.95,0.00,0.00,0.00,0.00,609978),('5','104','211437','395',295.00,295.00,0.00,0.00,0.00,0.00,0.00,609979),('5','104','211437','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,609980),('5','104','211450','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,610012),('5','104','211450','395',295.00,295.00,0.00,0.00,0.00,0.00,0.00,610013),('5','104','211450','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,610014),('5','104','211469','394',165.00,165.00,5595.84,0.00,0.00,0.00,0.00,610063),('5','104','211469','395',295.00,295.00,0.00,0.00,0.00,0.00,0.00,610064),('5','104','211469','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,610065),('5','104','211473','394',165.00,165.00,2671.35,0.00,0.00,0.00,0.00,610074),('5','104','211473','395',295.00,295.00,0.00,0.00,0.00,0.00,0.00,610075),('5','104','211473','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,610076),('5','104','211502','394',165.00,165.00,12837.21,0.00,0.00,0.00,0.00,610149),('5','104','211502','395',295.00,295.00,0.00,0.00,0.00,0.00,0.00,610150),('5','104','211502','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,610151),('5','104','211612','394',165.00,165.00,8826.67,0.00,0.00,0.00,0.00,610435),('5','104','211612','395',295.00,295.00,0.00,0.00,0.00,0.00,0.00,610436),('5','104','211612','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,610437),('5','104','211812','394',165.00,165.00,8340.26,0.00,0.00,0.00,0.00,610931),('5','104','211812','395',295.00,295.00,0.00,0.00,0.00,0.00,0.00,610932),('5','104','211812','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,610933),('5','104','212045','394',165.00,165.00,6939.77,0.00,0.00,0.00,0.00,611544),('5','104','212045','395',295.00,295.00,0.00,0.00,0.00,0.00,0.00,611545),('5','104','212045','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,611546),('5','104','212255','394',165.00,165.00,8494.68,0.00,0.00,0.00,0.00,612086),('5','104','212255','395',295.00,295.00,0.00,0.00,0.00,0.00,0.00,612087),('5','104','212255','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,612088),('5','104','212494','394',165.00,165.00,7640.96,0.00,0.00,0.00,0.00,612724),('5','104','212494','395',295.00,295.00,0.00,0.00,0.00,0.00,0.00,612725),('5','104','212494','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,612726),('5','104','212697','394',165.00,165.00,8923.29,0.00,0.00,0.00,0.00,613266),('5','104','212697','395',295.00,295.00,0.00,0.00,0.00,0.00,0.00,613267),('5','104','212697','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,613268),('5','104','212865','394',165.00,165.00,8000.64,0.00,0.00,0.00,0.00,613706),('5','104','212865','395',295.00,295.00,0.00,0.00,0.00,0.00,0.00,613707),('5','104','212865','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,613708),('5','104','213257','394',165.00,165.00,8559.27,0.00,0.00,0.00,0.00,614721),('5','104','213257','395',295.00,295.00,0.00,0.00,0.00,0.00,0.00,614722),('5','104','213257','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614723),('5','104','213582','394',165.00,165.00,8698.36,0.00,0.00,0.00,0.00,615584),('5','104','213582','395',295.00,295.00,0.00,0.00,0.00,0.00,0.00,615585),('5','104','213582','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615586),('5','104','213676','394',165.00,165.00,7111.93,0.00,0.00,0.00,0.00,615817),('5','104','213676','395',295.00,295.00,0.00,0.00,0.00,0.00,0.00,615818),('5','104','213676','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615819),('5','104','213910','394',165.00,165.00,7404.11,0.00,0.00,0.00,0.00,616426),('5','104','213910','395',295.00,295.00,649.29,0.00,0.00,0.00,0.00,616427),('5','104','213910','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,616428),('5','104','214129','394',165.00,165.00,7925.76,0.00,0.00,0.00,0.00,616995),('5','104','214129','395',295.00,295.00,1523.77,0.00,0.00,0.00,0.00,616996),('5','104','214129','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,616997),('5','104','214436','394',165.00,165.00,6252.03,0.00,0.00,0.00,0.00,617803),('5','104','214436','395',295.00,295.00,634.98,0.00,0.00,0.00,0.00,617804),('5','104','214436','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,617805),('5','104','214646','394',165.00,165.00,7665.91,0.00,0.00,0.00,0.00,618340),('5','104','214646','395',295.00,295.00,741.24,0.00,0.00,0.00,0.00,618341),('5','104','214646','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,618342),('5','104','214777','394',165.00,165.00,7569.13,0.00,0.00,0.00,0.00,618685),('5','104','214777','395',295.00,295.00,975.47,0.00,0.00,0.00,0.00,618686),('5','104','214777','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,618687),('5','104','214998','394',165.00,165.00,7867.95,0.00,0.00,0.00,0.00,619267),('5','104','214998','395',295.00,295.00,351.05,0.00,0.00,0.00,0.00,619268),('5','104','214998','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,619269),('5','104','215235','394',165.00,165.00,7729.08,0.00,0.00,0.00,0.00,619863),('5','104','215235','395',295.00,295.00,346.18,0.00,0.00,0.00,0.00,619864),('5','104','215235','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,619865),('5','104','215828','394',165.00,165.00,7546.59,0.00,0.00,0.00,0.00,621397),('5','104','215828','395',295.00,295.00,1099.20,0.00,0.00,0.00,0.00,621398),('5','104','215828','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,621399),('5','104','215852','394',165.00,165.00,7622.33,0.00,0.00,0.00,0.00,621455),('5','104','215852','395',295.00,295.00,241.87,0.00,0.00,0.00,0.00,621456),('5','104','215852','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,621457),('5','104','215934','394',165.00,165.00,6148.90,0.00,0.00,0.00,0.00,621660),('5','104','215934','395',295.00,295.00,762.57,0.00,0.00,0.00,0.00,621661),('5','104','215934','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,621662),('5','104','216144','394',165.00,165.00,7127.53,0.00,0.00,0.00,0.00,622205),('5','104','216144','395',295.00,295.00,630.31,0.00,0.00,0.00,0.00,622206),('5','104','216144','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,622207),('5','104','216369','394',165.00,165.00,7536.18,0.00,0.00,0.00,0.00,622793),('5','104','216369','395',295.00,295.00,1056.59,0.00,0.00,0.00,0.00,622794),('5','104','216369','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,622795),('5','104','216579','394',165.00,165.00,8164.01,0.00,0.00,0.00,0.00,623350),('5','104','216579','395',295.00,295.00,326.31,0.00,0.00,0.00,0.00,623351),('5','104','216579','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,623352),('5','104','216921','394',165.00,165.00,8476.29,0.00,0.00,0.00,0.00,624263),('5','104','216921','395',295.00,295.00,591.34,0.00,0.00,0.00,0.00,624264),('5','104','216921','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,624265),('5','104','217257','394',165.00,165.00,6771.75,0.00,0.00,0.00,0.00,625153),('5','104','217257','395',295.00,295.00,401.33,0.00,0.00,0.00,0.00,625154),('5','104','217257','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,625155),('5','104','217284','394',165.00,165.00,6442.82,0.00,0.00,0.00,0.00,625205),('5','104','217284','395',295.00,295.00,332.78,0.00,0.00,0.00,0.00,625206),('5','104','217284','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,625207),('5','104','217696','394',165.00,165.00,6956.97,0.00,0.00,0.00,0.00,626298),('5','104','217696','395',295.00,295.00,468.19,0.00,0.00,0.00,0.00,626299),('5','104','217696','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,626300),('5','104','217803','394',165.00,165.00,7192.55,0.00,0.00,0.00,0.00,626565),('5','104','217803','395',295.00,295.00,243.53,0.00,0.00,0.00,0.00,626566),('5','104','217803','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,626567),('5','104','218009','394',165.00,165.00,7728.85,0.00,0.00,0.00,0.00,627101),('5','104','218009','395',295.00,295.00,534.09,0.00,0.00,0.00,0.00,627102),('5','104','218009','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,627103),('5','104','218209','394',165.00,165.00,6141.58,0.00,0.00,0.00,0.00,627642),('5','104','218209','395',295.00,295.00,845.47,0.00,0.00,0.00,0.00,627643),('5','104','218209','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,627644),('5','104','218447','394',165.00,165.00,6401.47,0.00,0.00,0.00,0.00,628262),('5','104','218447','395',295.00,295.00,388.66,0.00,0.00,0.00,0.00,628263),('5','104','218447','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,628264),('5','104','218711','394',165.00,165.00,3577.66,0.00,0.00,0.00,0.00,628930),('5','104','218711','395',295.00,295.00,315.52,0.00,0.00,0.00,0.00,628931),('5','104','218711','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,628932),('5','104','218935','394',165.00,165.00,610.96,0.00,0.00,0.00,0.00,629526),('5','104','218935','395',295.00,295.00,461.99,0.00,0.00,0.00,0.00,629527),('5','104','218935','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,629528),('5','104','219163','394',165.00,165.00,5843.15,0.00,0.00,0.00,0.00,630116),('5','104','219163','395',295.00,295.00,693.63,0.00,0.00,0.00,0.00,630117),('5','104','219163','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,630118),('5','104','219337','394',165.00,165.00,7398.49,0.00,0.00,0.00,0.00,630580),('5','104','219337','395',295.00,295.00,569.27,0.00,0.00,0.00,0.00,630581),('5','104','219337','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,630582),('5','104','219610','394',165.00,165.00,6359.39,0.00,0.00,0.00,0.00,631288),('5','104','219610','395',295.00,295.00,349.84,0.00,0.00,0.00,0.00,631289),('5','104','219610','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,631290),('5','104','219844','394',165.00,165.00,6070.11,0.00,0.00,0.00,0.00,631903),('5','104','219844','395',295.00,295.00,417.50,0.00,0.00,0.00,0.00,631904),('5','104','219844','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,631905),('5','104','220034','394',165.00,165.00,6887.68,0.00,0.00,0.00,0.00,632430),('5','104','220034','395',295.00,295.00,238.72,0.00,0.00,0.00,0.00,632431),('5','104','220034','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,632432),('5','104','220311','394',165.00,165.00,6189.66,0.00,0.00,0.00,0.00,633143),('5','104','220311','395',295.00,295.00,415.03,0.00,0.00,0.00,0.00,633144),('5','104','220311','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,633145),('5','104','220670','394',165.00,165.00,5556.06,0.00,0.00,0.00,0.00,634096),('5','104','220670','395',295.00,295.00,397.58,0.00,0.00,0.00,0.00,634097),('5','104','220670','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,634098),('5','104','220713','394',165.00,165.00,5743.14,0.00,0.00,0.00,0.00,634190),('5','104','220713','395',295.00,295.00,297.55,0.00,0.00,0.00,0.00,634191),('5','104','220713','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,634192),('5','104','220894','394',165.00,165.00,6881.33,0.00,0.00,0.00,0.00,634679),('5','104','220894','395',295.00,295.00,312.14,0.00,0.00,0.00,0.00,634680),('5','104','220894','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,634681),('5','104','221173','394',165.00,165.00,6196.04,0.00,0.00,0.00,0.00,635379),('5','104','221173','395',295.00,295.00,344.08,0.00,0.00,0.00,0.00,635380),('5','104','221173','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,635381),('5','104','221564','394',165.00,165.00,6488.23,0.00,0.00,0.00,0.00,636422),('5','104','221564','395',295.00,295.00,1011.23,0.00,0.00,0.00,0.00,636423),('5','104','221564','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,636424),('5','104','221627','394',165.00,165.00,6407.14,0.00,0.00,0.00,0.00,636574),('5','104','221627','395',295.00,295.00,396.97,0.00,0.00,0.00,0.00,636575),('5','104','221627','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,636576),('5','104','221827','394',165.00,165.00,6724.99,0.00,0.00,0.00,0.00,637105),('5','104','221827','395',295.00,295.00,284.90,0.00,0.00,0.00,0.00,637106),('5','104','221827','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,637107),('5','104','222588','394',165.00,165.00,5604.76,0.00,0.00,0.00,0.00,639065),('5','104','222588','395',295.00,295.00,661.27,0.00,0.00,0.00,0.00,639066),('5','104','222588','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,639067),('5','104','222607','394',165.00,165.00,5592.05,0.00,0.00,0.00,0.00,639117),('5','104','222607','395',295.00,295.00,331.39,0.00,0.00,0.00,0.00,639118),('5','104','222607','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,639119),('5','104','222611','394',165.00,165.00,6248.72,0.00,0.00,0.00,0.00,639129),('5','104','222611','395',295.00,295.00,272.44,0.00,0.00,0.00,0.00,639130),('5','104','222611','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,639131),('5','104','223075','394',165.00,165.00,6410.52,0.00,0.00,0.00,0.00,640372),('5','104','223075','395',295.00,295.00,184.98,0.00,0.00,0.00,0.00,640373),('5','104','223075','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,640374),('5','104','223084','394',165.00,165.00,6044.81,0.00,0.00,0.00,0.00,640396),('5','104','223084','395',295.00,295.00,334.23,0.00,0.00,0.00,0.00,640397),('5','104','223084','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,640398),('5','104','223622','394',165.00,165.00,6134.13,0.00,0.00,0.00,0.00,641739),('5','104','223622','395',295.00,295.00,163.94,0.00,0.00,0.00,0.00,641740),('5','104','223622','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,641741),('5','104','223676','394',165.00,165.00,6382.95,0.00,0.00,0.00,0.00,641859),('5','104','223676','395',295.00,295.00,463.53,0.00,0.00,0.00,0.00,641860),('5','104','223676','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,641861),('5','104','224423','394',165.00,165.00,6149.22,0.00,0.00,0.00,0.00,643803),('5','104','224423','395',295.00,295.00,377.09,0.00,0.00,0.00,0.00,643804),('5','104','224423','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,643805),('5','104','224427','394',165.00,165.00,5632.66,0.00,0.00,0.00,0.00,643814),('5','104','224427','395',295.00,295.00,351.82,0.00,0.00,0.00,0.00,643815),('5','104','224427','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,643816),('5','104','224429','394',165.00,165.00,5862.78,0.00,0.00,0.00,0.00,643820),('5','104','224429','395',295.00,295.00,562.61,0.00,0.00,0.00,0.00,643821),('5','104','224429','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,643822),('5','104','224432','394',165.00,165.00,4855.62,0.00,0.00,0.00,0.00,643829),('5','104','224432','395',295.00,295.00,0.00,0.00,0.00,0.00,0.00,643830),('5','104','224432','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,643831),('5','104','225903','394',163.00,165.00,4320.80,0.00,0.00,0.00,0.00,647651),('5','104','225903','395',295.00,295.00,0.00,0.00,0.00,0.00,0.00,647652),('5','104','225903','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647653),('5','104','225905','394',163.00,165.00,1766.29,0.00,0.00,0.00,0.00,647657),('5','104','225905','395',295.00,295.00,0.00,0.00,0.00,0.00,0.00,647658),('5','104','225905','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647659),('5','104','225908','394',163.00,163.00,0.00,0.00,0.00,0.00,0.00,647666),('5','104','225908','395',295.00,295.00,0.00,0.00,0.00,0.00,0.00,647667),('5','104','225908','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647668),('5','104','225911','394',163.00,163.00,0.00,0.00,0.00,0.00,0.00,647673),('5','104','225911','395',295.00,295.00,0.00,0.00,0.00,0.00,0.00,647674),('5','104','225911','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647675),('5','104','225913','394',163.00,163.00,2892.12,0.00,0.00,0.00,0.00,647679),('5','104','225913','395',295.00,295.00,0.00,0.00,0.00,0.00,0.00,647680),('5','104','225913','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647681),('5','104','225915','394',163.00,163.00,6366.49,0.00,0.00,0.00,0.00,647685),('5','104','225915','395',295.00,295.00,0.00,0.00,0.00,0.00,0.00,647686),('5','104','225915','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647687),('5','104','226807','394',163.00,163.00,9389.71,0.00,0.00,0.00,0.00,649968),('5','104','226807','395',295.00,295.00,0.00,0.00,0.00,0.00,0.00,649969),('5','104','226807','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,649970),('5','104','226810','394',163.00,163.00,7289.52,0.00,0.00,0.00,0.00,649976),('5','104','226810','395',295.00,295.00,0.00,0.00,0.00,0.00,0.00,649977),('5','104','226810','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,649978),('5','104','226817','394',163.00,163.00,7752.54,0.00,0.00,0.00,0.00,649994),('5','104','226817','395',295.00,295.00,0.00,0.00,0.00,0.00,0.00,649995),('5','104','226817','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,649996),('5','104','226819','394',163.00,163.00,6925.64,0.00,0.00,0.00,0.00,650000),('5','104','226819','395',295.00,295.00,0.00,0.00,0.00,0.00,0.00,650001),('5','104','226819','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,650002),('5','104','227714','394',163.00,165.00,6249.51,0.00,0.00,0.00,0.00,652315),('5','104','227714','395',295.00,295.00,0.00,0.00,0.00,0.00,0.00,652316),('5','104','227714','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,652317),('5','104','227737','394',163.00,163.00,5916.48,0.00,0.00,0.00,0.00,652376),('5','104','227737','395',295.00,295.00,0.00,0.00,0.00,0.00,0.00,652377),('5','104','227737','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,652378),('5','104','227740','394',163.00,163.00,6006.46,0.00,0.00,0.00,0.00,652384),('5','104','227740','395',295.00,295.00,0.00,0.00,0.00,0.00,0.00,652385),('5','104','227740','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,652386),('5','104','227748','394',163.00,163.00,6301.68,0.00,0.00,0.00,0.00,652406),('5','104','227748','395',295.00,295.00,0.00,0.00,0.00,0.00,0.00,652407),('5','104','227748','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,652408),('5','104','229293','394',163.00,163.00,6148.18,0.00,0.00,0.00,0.00,656406),('5','104','229293','395',300.00,300.00,0.00,0.00,0.00,0.00,0.00,656407),('5','104','229293','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,656408),('5','104','229301','394',163.00,163.00,0.00,0.00,0.00,0.00,0.00,656428),('5','104','229301','395',300.00,300.00,0.00,0.00,0.00,0.00,0.00,656429),('5','104','229301','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,656430),('5','104','229350','394',163.00,163.00,6654.26,0.00,0.00,0.00,0.00,656570),('5','104','229350','395',300.00,300.00,0.00,0.00,0.00,0.00,0.00,656571),('5','104','229350','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,656572),('5','104','229509','394',163.00,163.00,4703.33,0.00,0.00,0.00,0.00,656956),('5','104','229509','395',300.00,300.00,0.00,0.00,0.00,0.00,0.00,656957),('5','104','229509','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,656958),('5','104','231244','394',163.00,163.00,2860.39,0.00,0.00,0.00,0.00,661481),('5','104','231244','395',300.00,300.00,0.00,0.00,0.00,0.00,0.00,661482),('5','104','231244','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661483),('5','104','231251','394',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661500),('5','104','231251','395',300.00,300.00,0.00,0.00,0.00,0.00,0.00,661501),('5','104','231251','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661502),('5','104','231256','394',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661515),('5','104','231256','395',300.00,300.00,0.00,0.00,0.00,0.00,0.00,661516),('5','104','231256','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661517),('5','104','231261','394',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661529),('5','104','231261','395',300.00,310.00,0.00,0.00,0.00,0.00,0.00,661530),('5','104','231261','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661531),('5','104','231267','394',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661546),('5','104','231267','395',300.00,310.00,0.00,0.00,0.00,0.00,0.00,661547),('5','104','231267','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661548),('5','104','231268','394',163.00,163.00,995.32,0.00,0.00,0.00,0.00,661549),('5','104','231268','395',300.00,310.00,0.00,0.00,0.00,0.00,0.00,661550),('5','104','231268','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661551),('5','104','231277','394',163.00,163.00,7429.04,0.00,0.00,0.00,0.00,661572),('5','104','231277','395',300.00,310.00,0.00,0.00,0.00,0.00,0.00,661573),('5','104','231277','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661574),('5','104','231283','394',163.00,163.00,7363.51,0.00,0.00,0.00,0.00,661590),('5','104','231283','395',320.00,310.00,0.00,0.00,0.00,0.00,0.00,661591),('5','104','231283','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661592),('5','104','231286','394',163.00,163.00,8951.90,0.00,0.00,0.00,0.00,661598),('5','104','231286','395',320.00,310.00,0.00,0.00,0.00,0.00,0.00,661599),('5','104','231286','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661600),('5','104','231288','394',163.00,163.00,8456.01,0.00,0.00,0.00,0.00,661604),('5','104','231288','395',320.00,320.00,0.00,0.00,0.00,0.00,0.00,661605),('5','104','231288','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661606),('5','104','231295','394',163.00,163.00,6018.54,0.00,0.00,0.00,0.00,661625),('5','104','231295','395',320.00,320.00,0.00,0.00,0.00,0.00,0.00,661626),('5','104','231295','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661627),('5','104','231301','394',163.00,163.00,5635.33,0.00,0.00,0.00,0.00,661643),('5','104','231301','395',320.00,320.00,0.00,0.00,0.00,0.00,0.00,661644),('5','104','231301','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661645),('5','104','231411','394',163.00,163.00,5206.93,0.00,0.00,0.00,0.00,661911),('5','104','231411','395',320.00,320.00,0.00,0.00,0.00,0.00,0.00,661912),('5','104','231411','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661913),('5','104','231738','394',163.00,163.00,6227.83,0.00,0.00,0.00,0.00,662781),('5','104','231738','395',320.00,320.00,0.00,0.00,0.00,0.00,0.00,662782),('5','104','231738','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,662783),('5','104','231981','394',163.00,163.00,6108.02,0.00,0.00,0.00,0.00,663444),('5','104','231981','395',320.00,327.00,0.00,0.00,0.00,0.00,0.00,663445),('5','104','231981','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,663446),('5','104','232191','394',163.00,163.00,5520.95,0.00,0.00,0.00,0.00,663991),('5','104','232191','395',327.00,327.00,0.00,0.00,0.00,0.00,0.00,663992),('5','104','232191','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,663993),('5','104','232319','394',163.00,163.00,6958.28,0.00,0.00,0.00,0.00,664326),('5','104','232319','395',327.00,327.00,0.00,0.00,0.00,0.00,0.00,664327),('5','104','232319','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,664328),('5','104','232644','394',163.00,163.00,6138.70,0.00,0.00,0.00,0.00,665177),('5','104','232644','395',327.00,327.00,0.00,0.00,0.00,0.00,0.00,665178),('5','104','232644','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,665179),('5','104','232964','394',163.00,163.00,6860.77,0.00,0.00,0.00,0.00,666037),('5','104','232964','395',330.00,330.00,0.00,0.00,0.00,0.00,0.00,666038),('5','104','232964','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,666039),('5','104','233175','394',163.00,163.00,0.00,0.00,0.00,0.00,0.00,666570),('5','104','233175','395',330.00,345.00,0.00,0.00,0.00,0.00,0.00,666571),('5','104','233175','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,666572),('5','104','233179','394',163.00,163.00,7217.80,0.00,0.00,0.00,0.00,666582),('5','104','233179','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,666583),('5','104','233179','396',0.00,345.00,0.00,0.00,0.00,0.00,0.00,666584),('5','104','233451','394',163.00,163.00,8158.16,0.00,0.00,0.00,0.00,667295),('5','104','233451','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,667296),('5','104','233451','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,667297),('5','104','233668','394',163.00,163.00,8201.93,0.00,0.00,0.00,0.00,667856),('5','104','233668','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,667857),('5','104','233668','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,667858),('5','104','233883','394',163.00,163.00,8616.24,0.00,0.00,0.00,0.00,668421),('5','104','233883','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,668422),('5','104','233883','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,668423),('5','104','234272','394',163.00,163.00,13458.28,0.00,0.00,0.00,0.00,669470),('5','104','234272','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,669471),('5','104','234272','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,669472),('5','104','234375','394',165.00,165.00,12076.52,0.00,0.00,0.00,0.00,669729),('5','104','234375','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,669730),('5','104','234375','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,669731),('5','104','234621','394',165.00,165.00,12619.91,0.00,0.00,0.00,0.00,670379),('5','104','234621','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,670380),('5','104','234621','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,670381),('5','104','235004','394',165.00,165.00,10977.66,0.00,0.00,0.00,0.00,671427),('5','104','235004','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,671428),('5','104','235004','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,671429),('5','104','235187','394',165.00,165.00,12346.18,0.00,0.00,0.00,0.00,671892),('5','104','235187','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,671893),('5','104','235187','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,671894),('5','104','235490','394',165.00,165.00,13349.09,0.00,0.00,0.00,0.00,672679),('5','104','235490','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,672680),('5','104','235490','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,672681),('5','104','235563','394',165.00,165.00,9721.98,0.00,0.00,0.00,0.00,672853),('5','104','235563','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,672854),('5','104','235563','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,672855),('5','104','235881','394',165.00,165.00,3367.87,0.00,0.00,0.00,0.00,673689),('5','104','235881','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,673690),('5','104','235881','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,673691),('5','104','236203','394',165.00,165.00,15882.83,0.00,0.00,0.00,0.00,674548),('5','104','236203','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,674549),('5','104','236203','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,674550),('5','104','236227','394',165.00,165.00,12401.54,0.00,0.00,0.00,0.00,674614),('5','104','236227','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,674615),('5','104','236227','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,674616),('5','104','236617','394',165.00,165.00,11530.58,0.00,0.00,0.00,0.00,675626),('5','104','236617','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,675627),('5','104','236617','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,675628),('5','104','236910','394',165.00,165.00,5332.48,0.00,0.00,0.00,0.00,676397),('5','104','236910','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,676398),('5','104','236910','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,676399),('5','104','237024','394',165.00,165.00,2756.04,0.00,0.00,0.00,0.00,676674),('5','104','237024','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,676675),('5','104','237024','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,676676),('5','104','237338','394',165.00,165.00,13666.38,0.00,0.00,0.00,0.00,677498),('5','104','237338','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,677499),('5','104','237338','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,677500),('5','104','237445','394',165.00,165.00,10302.63,0.00,0.00,0.00,0.00,677759),('5','104','237445','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,677760),('5','104','237445','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,677761),('5','104','237674','394',165.00,165.00,3305.62,0.00,0.00,0.00,0.00,678350),('5','104','237674','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,678351),('5','104','237674','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,678352),('5','104','238098','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,679479),('5','104','238098','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,679480),('5','104','238098','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,679481),('5','104','238230','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,679797),('5','104','238230','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,679798),('5','104','238230','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,679799),('5','104','238427','394',165.00,165.00,11926.14,0.00,0.00,0.00,0.00,680300),('5','104','238427','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,680301),('5','104','238427','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,680302),('5','104','238729','394',165.00,165.00,13472.78,0.00,0.00,0.00,0.00,681095),('5','104','238729','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,681096),('5','104','238729','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,681097),('5','104','238920','394',165.00,165.00,11134.31,0.00,0.00,0.00,0.00,681583),('5','104','238920','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,681584),('5','104','238920','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,681585),('5','104','239134','394',165.00,165.00,5153.18,0.00,0.00,0.00,0.00,682138),('5','104','239134','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,682139),('5','104','239134','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,682140),('5','104','239376','394',165.00,165.00,13377.19,0.00,0.00,0.00,0.00,682774),('5','104','239376','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,682775),('5','104','239376','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,682776),('5','104','239673','394',165.00,165.00,14125.78,0.00,0.00,0.00,0.00,683556),('5','104','239673','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,683557),('5','104','239673','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,683558),('5','104','239879','394',165.00,165.00,13319.12,0.00,0.00,0.00,0.00,684085),('5','104','239879','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,684086),('5','104','239879','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,684087),('5','104','240058','394',165.00,165.00,4131.10,0.00,0.00,0.00,0.00,684543),('5','104','240058','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,684544),('5','104','240058','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,684545),('5','104','240258','394',165.00,165.00,20225.36,0.00,0.00,0.00,0.00,685056),('5','104','240258','395',345.00,345.00,838.97,0.00,0.00,0.00,0.00,685057),('5','104','240258','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,685058),('5','104','240530','394',165.00,165.00,15749.73,0.00,0.00,0.00,0.00,685770),('5','104','240530','395',345.00,345.00,76.89,0.00,0.00,0.00,0.00,685771),('5','104','240530','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,685772),('5','104','240738','394',165.00,165.00,13839.32,0.00,0.00,0.00,0.00,686261),('5','104','240738','395',345.00,345.00,645.68,0.00,0.00,0.00,0.00,686262),('5','104','240738','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,686263),('5','104','241091','394',165.00,165.00,14184.47,0.00,0.00,0.00,0.00,687215),('5','104','241091','395',345.00,345.00,353.03,0.00,0.00,0.00,0.00,687216),('5','104','241091','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,687217),('5','104','241331','394',165.00,165.00,14777.94,0.00,0.00,0.00,0.00,687843),('5','104','241331','395',345.00,345.00,671.59,0.00,0.00,0.00,0.00,687844),('5','104','241331','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,687845),('5','104','241543','394',165.00,165.00,3101.57,0.00,0.00,0.00,0.00,688408),('5','104','241543','395',345.00,345.00,408.98,0.00,0.00,0.00,0.00,688409),('5','104','241543','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,688410),('5','104','241821','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,689138),('5','104','241821','395',345.00,345.00,943.04,0.00,0.00,0.00,0.00,689139),('5','104','241821','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,689140),('5','104','242034','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,689689),('5','104','242034','395',345.00,345.00,1909.35,0.00,0.00,0.00,0.00,689690),('5','104','242034','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,689691),('5','104','242364','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,690560),('5','104','242364','395',345.00,345.00,2171.89,0.00,0.00,0.00,0.00,690561),('5','104','242364','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,690562),('5','104','242447','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,690754),('5','104','242447','395',345.00,345.00,2702.64,0.00,0.00,0.00,0.00,690755),('5','104','242447','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,690756),('5','104','242784','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,691638),('5','104','242784','395',345.00,345.00,4655.99,0.00,0.00,0.00,0.00,691639),('5','104','242784','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,691640),('5','104','242996','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,692189),('5','104','242996','395',345.00,345.00,1830.39,0.00,0.00,0.00,0.00,692190),('5','104','242996','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,692191),('5','104','243256','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,692874),('5','104','243256','395',345.00,345.00,1488.67,0.00,0.00,0.00,0.00,692875),('5','104','243256','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,692876),('5','104','243786','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,694262),('5','104','243786','395',345.00,345.00,1860.97,0.00,0.00,0.00,0.00,694263),('5','104','243786','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,694264),('5','104','244000','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,694812),('5','104','244000','395',345.00,345.00,1990.04,0.00,0.00,0.00,0.00,694813),('5','104','244000','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,694814),('5','104','244007','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,694832),('5','104','244007','395',345.00,345.00,604.28,0.00,0.00,0.00,0.00,694833),('5','104','244007','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,694834),('5','104','244152','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,695186),('5','104','244152','395',345.00,345.00,2775.48,0.00,0.00,0.00,0.00,695187),('5','104','244152','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,695188),('5','104','244358','394',165.00,165.00,11797.86,0.00,0.00,0.00,0.00,695730),('5','104','244358','395',345.00,345.00,1167.11,0.00,0.00,0.00,0.00,695731),('5','104','244358','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,695732),('5','104','244698','394',165.00,165.00,8925.86,0.00,0.00,0.00,0.00,696628),('5','104','244698','395',345.00,345.00,1316.02,0.00,0.00,0.00,0.00,696629),('5','104','244698','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,696630),('5','104','244840','394',165.00,165.00,9092.20,0.00,0.00,0.00,0.00,696991),('5','104','244840','395',345.00,345.00,615.65,0.00,0.00,0.00,0.00,696992),('5','104','244840','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,696993),('5','104','245187','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,697897),('5','104','245187','395',345.00,345.00,745.23,0.00,0.00,0.00,0.00,697898),('5','104','245187','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,697899),('5','104','245350','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,698307),('5','104','245350','395',345.00,345.00,597.55,0.00,0.00,0.00,0.00,698308),('5','104','245350','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,698309),('5','104','245643','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699078),('5','104','245643','395',345.00,345.00,202.03,0.00,0.00,0.00,0.00,699079),('5','104','245643','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,699080),('5','104','245952','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699871),('5','104','245952','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,699872),('5','104','245952','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,699873),('5','104','246161','394',165.00,165.00,667.08,0.00,0.00,0.00,0.00,700418),('5','104','246161','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,700419),('5','104','246161','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,700420),('5','104','246546','394',165.00,165.00,11754.61,0.00,0.00,0.00,0.00,701416),('5','104','246546','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,701417),('5','104','246546','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,701418),('5','104','246551','394',165.00,165.00,14243.48,0.00,0.00,0.00,0.00,701431),('5','104','246551','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,701432),('5','104','246551','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,701433),('5','104','246787','394',165.00,165.00,9358.71,0.00,0.00,0.00,0.00,702037),('5','104','246787','395',345.00,345.00,103.94,0.00,0.00,0.00,0.00,702038),('5','104','246787','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,702039),('5','104','247484','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,703826),('5','104','247484','395',345.00,345.00,2953.43,0.00,0.00,0.00,0.00,703827),('5','104','247484','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,703828),('5','104','247489','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,703835),('5','104','247489','395',345.00,345.00,563.44,0.00,0.00,0.00,0.00,703836),('5','104','247489','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,703837),('5','104','247490','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,703838),('5','104','247490','395',345.00,345.00,1622.20,0.00,0.00,0.00,0.00,703839),('5','104','247490','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,703840),('5','104','247731','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,704478),('5','104','247731','395',345.00,345.00,2184.39,0.00,0.00,0.00,0.00,704479),('5','104','247731','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,704480),('5','104','248126','394',165.00,165.00,8845.38,0.00,0.00,0.00,0.00,705522),('5','104','248126','395',345.00,345.00,1288.16,0.00,0.00,0.00,0.00,705523),('5','104','248126','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,705524),('5','104','248282','394',165.00,165.00,12807.39,0.00,0.00,0.00,0.00,705908),('5','104','248282','395',345.00,345.00,1665.27,0.00,0.00,0.00,0.00,705909),('5','104','248282','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,705910),('5','104','248464','394',165.00,165.00,5074.68,0.00,0.00,0.00,0.00,706357),('5','104','248464','395',345.00,345.00,796.86,0.00,0.00,0.00,0.00,706358),('5','104','248464','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,706359),('5','104','248712','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,707004),('5','104','248712','395',345.00,345.00,558.96,0.00,0.00,0.00,0.00,707005),('5','104','248712','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,707006),('5','104','248953','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,707623),('5','104','248953','395',345.00,345.00,457.22,0.00,0.00,0.00,0.00,707624),('5','104','248953','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,707625),('5','104','249253','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,708402),('5','104','249253','395',345.00,345.00,512.27,0.00,0.00,0.00,0.00,708403),('5','104','249253','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,708404),('5','104','249437','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,708857),('5','104','249437','395',345.00,345.00,415.12,0.00,0.00,0.00,0.00,708858),('5','104','249437','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,708859),('5','104','249684','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,709494),('5','104','249684','395',345.00,345.00,309.72,0.00,0.00,0.00,0.00,709495),('5','104','249684','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,709496),('5','104','249972','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,710242),('5','104','249972','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,710243),('5','104','249972','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,710244),('5','104','250307','394',165.00,165.00,1062.86,0.00,0.00,0.00,0.00,711108),('5','104','250307','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,711109),('5','104','250307','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,711110),('5','104','250533','394',165.00,165.00,8352.03,0.00,0.00,0.00,0.00,711683),('5','104','250533','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,711684),('5','104','250533','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,711685),('5','104','250666','394',165.00,165.00,10548.93,0.00,0.00,0.00,0.00,712006),('5','104','250666','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,712007),('5','104','250666','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,712008),('5','104','250956','394',165.00,165.00,12699.09,0.00,0.00,0.00,0.00,712770),('5','104','250956','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,712771),('5','104','250956','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,712772),('5','104','251233','394',165.00,165.00,6752.31,0.00,0.00,0.00,0.00,713494),('5','104','251233','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,713495),('5','104','251233','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,713496),('5','104','251485','394',165.00,165.00,14842.72,0.00,0.00,0.00,0.00,714160),('5','104','251485','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,714161),('5','104','251485','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,714162),('5','104','251613','394',165.00,165.00,8418.87,0.00,0.00,0.00,0.00,714469),('5','104','251613','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,714470),('5','104','251613','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,714471),('5','104','251873','394',165.00,165.00,10967.07,0.00,0.00,0.00,0.00,715153),('5','104','251873','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,715154),('5','104','251873','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,715155),('5','104','252213','394',165.00,165.00,7134.02,0.00,0.00,0.00,0.00,716062),('5','104','252213','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,716063),('5','104','252213','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,716064),('5','104','252566','394',165.00,165.00,3214.34,0.00,0.00,0.00,0.00,716952),('5','104','252566','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,716953),('5','104','252566','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,716954),('5','104','252677','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,717262),('5','104','252677','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,717263),('5','104','252677','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,717264),('5','104','252852','394',165.00,165.00,10024.57,0.00,0.00,0.00,0.00,717701),('5','104','252852','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,717702),('5','104','252852','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,717703),('5','104','253271','394',165.00,165.00,10350.70,0.00,0.00,0.00,0.00,718793),('5','104','253271','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,718794),('5','104','253271','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,718795),('5','104','253289','394',165.00,165.00,10335.96,0.00,0.00,0.00,0.00,718836),('5','104','253289','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,718837),('5','104','253289','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,718838),('5','104','253554','394',165.00,165.00,10271.04,0.00,0.00,0.00,0.00,719520),('5','104','253554','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,719521),('5','104','253554','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,719522),('5','104','253777','394',165.00,165.00,8534.87,0.00,0.00,0.00,0.00,720096),('5','104','253777','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,720097),('5','104','253777','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,720098),('5','104','254106','394',165.00,165.00,8799.22,0.00,0.00,0.00,0.00,720970),('5','104','254106','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,720971),('5','104','254106','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,720972),('5','104','254282','394',165.00,165.00,10061.17,0.00,0.00,0.00,0.00,721412),('5','104','254282','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,721413),('5','104','254282','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,721414),('5','104','254532','394',165.00,165.00,1341.75,0.00,0.00,0.00,0.00,722059),('5','104','254532','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,722060),('5','104','254532','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,722061),('5','104','254816','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,722775),('5','104','254816','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,722776),('5','104','254816','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,722777),('5','104','255096','394',165.00,165.00,1913.15,0.00,0.00,0.00,0.00,723503),('5','104','255096','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,723504),('5','104','255096','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,723505),('5','104','255573','394',165.00,165.00,9797.62,0.00,0.00,0.00,0.00,724666),('5','104','255573','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,724667),('5','104','255573','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,724668),('5','104','255640','394',165.00,165.00,7594.39,0.00,0.00,0.00,0.00,724853),('5','104','255640','395',345.00,345.00,0.00,0.00,0.00,0.00,0.00,724854),('5','104','255640','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,724855),('5','104','255809','394',165.00,165.00,7546.76,0.00,0.00,0.00,0.00,725274),('5','104','255809','395',350.00,350.00,0.00,0.00,0.00,0.00,0.00,725275),('5','104','255809','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,725276),('5','104','256022','394',165.00,165.00,4510.11,0.00,0.00,0.00,0.00,725819),('5','104','256022','395',355.00,355.00,0.00,0.00,0.00,0.00,0.00,725820),('5','104','256022','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,725821),('5','104','256290','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,726469),('5','104','256290','395',355.00,355.00,0.00,0.00,0.00,0.00,0.00,726470),('5','104','256290','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,726471),('5','104','256935','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728182),('5','104','256935','395',355.00,355.00,0.00,0.00,0.00,0.00,0.00,728183),('5','104','256935','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,728184),('5','104','257070','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728511),('5','104','257070','395',355.00,355.00,0.00,0.00,0.00,0.00,0.00,728512),('5','104','257070','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,728513),('5','104','257114','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728633),('5','104','257114','395',355.00,355.00,0.00,0.00,0.00,0.00,0.00,728634),('5','104','257114','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,728635),('5','104','257405','394',165.00,165.00,1615.90,0.00,0.00,0.00,0.00,729397),('5','104','257405','395',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729398),('5','104','257405','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729399),('5','104','257406','395',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729400),('5','104','257406','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729401),('5','104','257406','394',165.00,165.00,9332.96,0.00,0.00,0.00,0.00,729402),('5','104','257407','395',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729403),('5','104','257407','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729404),('5','104','257407','394',165.00,165.00,9623.19,0.00,0.00,0.00,0.00,729405),('5','104','257408','395',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729406),('5','104','257408','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729407),('5','104','257408','394',165.00,165.00,2364.00,0.00,0.00,0.00,0.00,729408),('5','104','257409','395',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729409),('5','104','257409','396',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729410),('5','104','257409','394',165.00,165.00,1403.32,0.00,0.00,0.00,0.00,729411),('5','104','257410','395',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729412),('5','104','257410','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729413),('5','104','257410','394',165.00,165.00,9034.46,0.00,0.00,0.00,0.00,729414),('5','104','257411','395',360.00,360.00,0.00,0.00,0.00,0.00,0.00,729415),('5','104','257411','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729416),('5','104','257411','394',165.00,165.00,9046.98,0.00,0.00,0.00,0.00,729417),('5','104','257412','395',390.00,390.00,0.00,0.00,0.00,0.00,0.00,729418),('5','104','257412','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729419),('5','104','257412','394',165.00,165.00,8112.63,0.00,0.00,0.00,0.00,729420),('5','104','257413','395',390.00,390.00,0.00,0.00,0.00,0.00,0.00,729421),('5','104','257413','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729422),('5','104','257413','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729423),('5','104','257414','395',390.00,390.00,0.00,0.00,0.00,0.00,0.00,729424),('5','104','257414','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729425),('5','104','257414','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729426),('5','104','257415','394',165.00,165.00,8433.23,0.00,0.00,0.00,0.00,729427),('5','104','257415','395',390.00,390.00,0.00,0.00,0.00,0.00,0.00,729428),('5','104','257415','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729429),('5','104','257416','394',165.00,165.00,9818.92,0.00,0.00,0.00,0.00,729430),('5','104','257416','395',390.00,390.00,0.00,0.00,0.00,0.00,0.00,729431),('5','104','257416','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729432),('5','104','257417','395',390.00,390.00,0.00,0.00,0.00,0.00,0.00,729433),('5','104','257417','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729434),('5','104','257417','394',165.00,165.00,2555.03,0.00,0.00,0.00,0.00,729435),('5','104','257418','395',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729436),('5','104','257418','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729437),('5','104','257418','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729438),('5','104','257419','395',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729439),('5','104','257419','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729440),('5','104','257419','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729441),('5','104','257420','395',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729442),('5','104','257420','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729443),('5','104','257420','394',165.00,165.00,2677.21,0.00,0.00,0.00,0.00,729444),('5','104','257421','395',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729445),('5','104','257421','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729446),('5','104','257421','394',165.00,165.00,7113.26,0.00,0.00,0.00,0.00,729447),('5','104','257422','395',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729448),('5','104','257422','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729449),('5','104','257422','394',165.00,165.00,10036.81,0.00,0.00,0.00,0.00,729450),('5','104','257423','395',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729451),('5','104','257423','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729452),('5','104','257423','394',165.00,165.00,2798.43,0.00,0.00,0.00,0.00,729453),('5','104','257424','395',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729454),('5','104','257424','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729455),('5','104','257424','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729456),('5','104','257425','395',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729457),('5','104','257425','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729458),('5','104','257425','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729459),('5','104','257426','395',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729460),('5','104','257426','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729461),('5','104','257426','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729462),('5','104','257427','395',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729463),('5','104','257427','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729464),('5','104','257427','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729465),('5','104','257428','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729466),('5','104','257428','395',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729467),('5','104','257428','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729468),('5','104','257429','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729469),('5','104','257429','395',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729470),('5','104','257429','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729471),('5','104','257430','395',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729472),('5','104','257430','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729473),('5','104','257430','394',165.00,165.00,4637.64,0.00,0.00,0.00,0.00,729474),('5','104','257431','395',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729475),('5','104','257431','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729476),('5','104','257431','394',165.00,165.00,10255.02,0.00,0.00,0.00,0.00,729477),('5','104','257432','395',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729478),('5','104','257432','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729479),('5','104','257432','394',165.00,165.00,17548.38,0.00,0.00,0.00,0.00,729480),('5','104','257433','395',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729481),('5','104','257433','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729482),('5','104','257433','394',165.00,165.00,11421.77,0.00,0.00,0.00,0.00,729483),('5','104','257434','394',165.00,165.00,11683.28,0.00,0.00,0.00,0.00,729484),('5','104','257434','395',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729485),('5','104','257434','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729486),('5','104','257435','395',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729487),('5','104','257435','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729488),('5','104','257435','394',165.00,165.00,13066.83,0.00,0.00,0.00,0.00,729489),('5','104','257436','394',165.00,165.00,13620.41,0.00,0.00,0.00,0.00,729490),('5','104','257436','395',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729491),('5','104','257436','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729492),('5','104','257437','395',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729493),('5','104','257437','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729494),('5','104','257437','394',165.00,165.00,9026.96,0.00,0.00,0.00,0.00,729495),('5','104','257438','395',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729496),('5','104','257438','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729497),('5','104','257438','394',165.00,165.00,5926.93,0.00,0.00,0.00,0.00,729498),('5','104','257439','394',165.00,165.00,11786.15,0.00,0.00,0.00,0.00,729499),('5','104','257439','395',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729500),('5','104','257439','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729501),('5','104','257440','395',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729502),('5','104','257440','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729503),('5','104','257440','394',165.00,165.00,10963.45,0.00,0.00,0.00,0.00,729504),('5','104','257441','395',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729505),('5','104','257441','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729506),('5','104','257441','394',165.00,165.00,5215.98,0.00,0.00,0.00,0.00,729507),('5','104','257442','395',500.00,500.00,0.00,0.00,0.00,0.00,0.00,729508),('5','104','257442','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729509),('5','104','257442','394',165.00,165.00,11931.92,0.00,0.00,0.00,0.00,729510),('5','104','257443','395',500.00,500.00,0.00,0.00,0.00,0.00,0.00,729511),('5','104','257443','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729512),('5','104','257443','394',165.00,165.00,12624.58,0.00,0.00,0.00,0.00,729513),('5','104','257444','395',500.00,500.00,0.00,0.00,0.00,0.00,0.00,729514),('5','104','257444','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729515),('5','104','257444','394',165.00,165.00,2957.80,0.00,0.00,0.00,0.00,729516),('5','104','257445','395',500.00,500.00,0.00,0.00,0.00,0.00,0.00,729517),('5','104','257445','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729518),('5','104','257445','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729519),('5','104','257446','395',600.00,600.00,0.00,0.00,0.00,0.00,0.00,729520),('5','104','257446','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729521),('5','104','257446','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729522),('5','104','257447','395',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729523),('5','104','257447','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729524),('5','104','257447','394',165.00,165.00,2088.37,0.00,0.00,0.00,0.00,729525),('5','104','257448','394',165.00,165.00,13411.32,0.00,0.00,0.00,0.00,729526),('5','104','257448','395',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729527),('5','104','257448','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729528),('5','104','257449','395',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729529),('5','104','257449','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729530),('5','104','257449','394',165.00,165.00,11368.36,0.00,0.00,0.00,0.00,729531),('5','104','257450','394',165.00,165.00,10630.98,0.00,0.00,0.00,0.00,729532),('5','104','257450','395',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729533),('5','104','257450','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729534),('5','104','257451','394',165.00,165.00,2251.01,0.00,0.00,0.00,0.00,729535),('5','104','257451','395',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729536),('5','104','257451','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729537),('5','104','257452','395',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729538),('5','104','257452','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729539),('5','104','257452','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729540),('5','104','257453','395',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729541),('5','104','257453','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729542),('5','104','257453','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729543),('5','104','257454','395',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729544),('5','104','257454','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729545),('5','104','257454','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729546),('5','104','257455','395',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729547),('5','104','257455','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729548),('5','104','257455','394',165.00,165.00,2237.51,0.00,0.00,0.00,0.00,729549),('5','104','257456','394',165.00,165.00,11930.30,0.00,0.00,0.00,0.00,729550),('5','104','257456','395',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729551),('5','104','257456','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729552),('5','104','257457','394',165.00,165.00,9594.89,0.00,0.00,0.00,0.00,729553),('5','104','257457','395',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729554),('5','104','257457','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729555),('5','104','257458','395',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729556),('5','104','257458','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729557),('5','104','257458','394',165.00,165.00,2556.79,0.00,0.00,0.00,0.00,729558),('5','104','257459','395',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729559),('5','104','257459','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729560),('5','104','257459','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729561),('5','104','257460','395',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729562),('5','104','257460','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729563),('5','104','257460','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729564),('5','104','257461','395',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729565),('5','104','257461','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729566),('5','104','257461','394',165.00,165.00,3575.46,0.00,0.00,0.00,0.00,729567),('5','104','257462','395',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729568),('5','104','257462','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729569),('5','104','257462','394',165.00,165.00,8452.19,0.00,0.00,0.00,0.00,729570),('5','104','257463','395',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729571),('5','104','257463','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729572),('5','104','257463','394',165.00,165.00,9511.91,0.00,0.00,0.00,0.00,729573),('5','104','257464','395',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729574),('5','104','257464','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729575),('5','104','257464','394',165.00,165.00,11063.41,0.00,0.00,0.00,0.00,729576),('5','104','257465','395',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729577),('5','104','257465','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729578),('5','104','257465','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729579),('5','104','257466','395',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729580),('5','104','257466','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729581),('5','104','257466','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729582),('5','104','257467','395',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729583),('5','104','257467','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729584),('5','104','257467','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729585),('5','104','257468','395',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729586),('5','104','257468','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729587),('5','104','257468','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729588),('5','104','257469','395',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729589),('5','104','257469','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729590),('5','104','257469','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729591),('5','104','257470','395',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729592),('5','104','257470','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729593),('5','104','257470','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729594),('5','104','257471','395',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729595),('5','104','257471','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729596),('5','104','257471','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729597),('5','104','257472','395',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729598),('5','104','257472','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729599),('5','104','257472','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729600),('5','104','257473','395',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729601),('5','104','257473','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729602),('5','104','257473','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729603),('5','104','257474','395',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729604),('5','104','257474','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729605),('5','104','257474','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729606),('5','104','257475','395',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729607),('5','104','257475','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729608),('5','104','257475','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729609),('5','104','257476','395',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729610),('5','104','257476','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729611),('5','104','257476','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729612),('5','104','257477','395',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729613),('5','104','257477','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729614),('5','104','257477','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729615),('5','104','257478','395',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729616),('5','104','257478','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729617),('5','104','257478','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729618),('5','104','257479','395',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729619),('5','104','257479','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729620),('5','104','257479','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729621),('5','104','257480','395',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729622),('5','104','257480','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729623),('5','104','257480','394',165.00,165.00,10891.16,0.00,0.00,0.00,0.00,729624),('5','104','257481','395',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729625),('5','104','257481','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729626),('5','104','257481','394',165.00,165.00,6665.61,0.00,0.00,0.00,0.00,729627),('5','104','257482','395',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729628),('5','104','257482','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729629),('5','104','257482','394',165.00,165.00,7171.88,0.00,0.00,0.00,0.00,729630),('5','104','257483','395',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729631),('5','104','257483','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729632),('5','104','257483','394',165.00,165.00,1907.95,0.00,0.00,0.00,0.00,729633),('5','104','257484','395',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729634),('5','104','257484','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729635),('5','104','257484','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729636),('5','104','257485','395',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729637),('5','104','257485','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729638),('5','104','257485','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729639),('5','104','257486','395',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729640),('5','104','257486','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729641),('5','104','257486','394',165.00,165.00,5763.76,0.00,0.00,0.00,0.00,729642),('5','104','257487','395',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729643),('5','104','257487','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729644),('5','104','257487','394',165.00,165.00,9146.17,0.00,0.00,0.00,0.00,729645),('5','104','257488','395',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729646),('5','104','257488','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729647),('5','104','257488','394',165.00,165.00,7952.04,0.00,0.00,0.00,0.00,729648),('5','104','257489','395',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729649),('5','104','257489','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729650),('5','104','257489','394',165.00,165.00,8284.35,0.00,0.00,0.00,0.00,729651),('5','104','257490','395',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729652),('5','104','257490','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729653),('5','104','257490','394',165.00,165.00,9047.24,0.00,0.00,0.00,0.00,729654),('5','104','257491','395',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729655),('5','104','257491','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729656),('5','104','257491','394',165.00,165.00,7282.76,0.00,0.00,0.00,0.00,729657),('5','104','257492','394',165.00,165.00,7776.22,0.00,0.00,0.00,0.00,729658),('5','104','257492','395',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729659),('5','104','257492','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729660),('5','104','257493','395',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729661),('5','104','257493','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729662),('5','104','257493','394',165.00,165.00,8036.82,0.00,0.00,0.00,0.00,729663),('5','104','257494','395',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729664),('5','104','257494','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729665),('5','104','257494','394',165.00,165.00,3305.21,0.00,0.00,0.00,0.00,729666),('5','104','257495','395',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729667),('5','104','257495','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729668),('5','104','257495','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729669),('5','104','257496','395',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729670),('5','104','257496','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729671),('5','104','257496','394',165.00,165.00,6452.23,0.00,0.00,0.00,0.00,729672),('5','104','257497','395',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729673),('5','104','257497','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729674),('5','104','257497','394',165.00,165.00,7686.97,0.00,0.00,0.00,0.00,729675),('5','104','257498','394',165.00,165.00,9606.43,0.00,0.00,0.00,0.00,729676),('5','104','257498','395',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729677),('5','104','257498','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729678),('5','104','257499','394',165.00,165.00,8572.66,0.00,0.00,0.00,0.00,729679),('5','104','257499','395',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729680),('5','104','257499','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729681),('5','104','257500','394',165.00,165.00,8428.91,0.00,0.00,0.00,0.00,729682),('5','104','257500','395',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729683),('5','104','257500','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729684),('5','104','257501','395',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729685),('5','104','257501','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729686),('5','104','257501','394',165.00,165.00,7501.88,0.00,0.00,0.00,0.00,729687),('5','104','257502','394',165.00,165.00,5955.06,0.00,0.00,0.00,0.00,729688),('5','104','257502','395',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729689),('5','104','257502','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729690),('5','104','257503','394',165.00,165.00,8208.92,0.00,0.00,0.00,0.00,729691),('5','104','257503','395',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729692),('5','104','257503','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729693),('5','104','257504','394',165.00,165.00,7673.37,0.00,0.00,0.00,0.00,729694),('5','104','257504','395',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729695),('5','104','257504','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729696),('5','104','257505','394',165.00,165.00,2395.04,0.00,0.00,0.00,0.00,729697),('5','104','257505','395',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729698),('5','104','257505','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729699),('5','104','257506','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729700),('5','104','257506','395',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729701),('5','104','257506','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729702),('5','104','257507','395',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729703),('5','104','257507','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729704),('5','104','257507','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729705),('5','104','257508','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729706),('5','104','257508','395',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729707),('5','104','257508','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729708),('5','104','257509','395',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729709),('5','104','257509','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729710),('5','104','257509','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729711),('5','104','257510','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729712),('5','104','257510','395',660.00,660.00,0.00,0.00,0.00,0.00,0.00,729713),('5','104','257510','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729714),('5','104','257511','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729715),('5','104','257511','395',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729716),('5','104','257511','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729717),('5','104','257512','395',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729718),('5','104','257512','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729719),('5','104','257512','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729720),('5','104','257513','395',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729721),('5','104','257513','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729722),('5','104','257513','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729723),('5','104','257514','395',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729724),('5','104','257514','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729725),('5','104','257514','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729726),('5','104','257515','395',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729727),('5','104','257515','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729728),('5','104','257515','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729729),('5','104','257516','395',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729730),('5','104','257516','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729731),('5','104','257516','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729732),('5','104','257517','395',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729733),('5','104','257517','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729734),('5','104','257517','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729735),('5','104','257518','395',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729736),('5','104','257518','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729737),('5','104','257518','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729738),('5','104','257519','395',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729739),('5','104','257519','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729740),('5','104','257519','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729741),('5','104','257520','395',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729742),('5','104','257520','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729743),('5','104','257520','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729744),('5','104','257521','395',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729745),('5','104','257521','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729746),('5','104','257521','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729747),('5','104','257522','395',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729748),('5','104','257522','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729749),('5','104','257522','394',165.00,165.00,3143.21,0.00,0.00,0.00,0.00,729750),('5','104','257523','395',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729751),('5','104','257523','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729752),('5','104','257523','394',165.00,165.00,6865.25,0.00,0.00,0.00,0.00,729753),('5','104','257524','395',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729754),('5','104','257524','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729755),('5','104','257524','394',165.00,165.00,7822.16,0.00,0.00,0.00,0.00,729756),('5','104','257525','394',165.00,165.00,8991.71,0.00,0.00,0.00,0.00,729757),('5','104','257525','395',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729758),('5','104','257525','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729759),('5','104','257526','395',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729760),('5','104','257526','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729761),('5','104','257526','394',165.00,165.00,7025.45,0.00,0.00,0.00,0.00,729762),('5','104','257527','395',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729763),('5','104','257527','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729764),('5','104','257527','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729765),('5','104','257528','395',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729766),('5','104','257528','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729767),('5','104','257528','394',165.00,165.00,2741.84,0.00,0.00,0.00,0.00,729768),('5','104','257529','395',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729769),('5','104','257529','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729770),('5','104','257529','394',165.00,165.00,6624.26,0.00,0.00,0.00,0.00,729771),('5','104','257530','394',165.00,165.00,6993.91,0.00,0.00,0.00,0.00,729772),('5','104','257530','395',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729773),('5','104','257530','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729774),('5','104','257531','395',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729775),('5','104','257531','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729776),('5','104','257531','394',165.00,165.00,5055.17,0.00,0.00,0.00,0.00,729777),('5','104','257532','395',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729778),('5','104','257532','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729779),('5','104','257532','394',165.00,165.00,3112.54,0.00,0.00,0.00,0.00,729780),('5','104','257533','394',165.00,165.00,4144.76,0.00,0.00,0.00,0.00,729781),('5','104','257533','395',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729782),('5','104','257533','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729783),('5','104','257534','395',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729784),('5','104','257534','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729785),('5','104','257534','394',165.00,165.00,7739.20,0.00,0.00,0.00,0.00,729786),('5','104','257535','394',165.00,165.00,6470.47,0.00,0.00,0.00,0.00,729787),('5','104','257535','395',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729788),('5','104','257535','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729789),('5','104','257536','394',165.00,165.00,5414.53,0.00,0.00,0.00,0.00,729790),('5','104','257536','395',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729791),('5','104','257536','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729792),('5','104','257537','395',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729793),('5','104','257537','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729794),('5','104','257537','394',165.00,165.00,6295.38,0.00,0.00,0.00,0.00,729795),('5','104','257538','394',165.00,165.00,6510.97,0.00,0.00,0.00,0.00,729796),('5','104','257538','395',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729797),('5','104','257538','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729798),('5','104','257539','395',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729799),('5','104','257539','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729800),('5','104','257539','394',165.00,165.00,3025.02,0.00,0.00,0.00,0.00,729801),('5','104','257540','395',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729802),('5','104','257540','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729803),('5','104','257540','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729804),('5','104','257541','395',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729805),('5','104','257541','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729806),('5','104','257541','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729807),('5','104','257542','395',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729808),('5','104','257542','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729809),('5','104','257542','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729810),('5','104','257543','395',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729811),('5','104','257543','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729812),('5','104','257543','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729813),('5','104','257544','395',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729814),('5','104','257544','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729815),('5','104','257544','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729816),('5','104','257545','395',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729817),('5','104','257545','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729818),('5','104','257545','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729819),('5','104','257546','395',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729820),('5','104','257546','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729821),('5','104','257546','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729822),('5','104','257547','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729823),('5','104','257547','395',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729824),('5','104','257547','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729825),('5','104','257548','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729826),('5','104','257548','395',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729827),('5','104','257548','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729828),('5','104','257549','395',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729829),('5','104','257549','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729830),('5','104','257549','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729831),('5','104','257550','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729832),('5','104','257550','395',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729833),('5','104','257550','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729834),('5','104','257551','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729835),('5','104','257551','395',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729836),('5','104','257551','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729837),('5','104','257552','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729838),('5','104','257552','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729839),('5','104','257552','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729840),('5','104','257553','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729841),('5','104','257553','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729842),('5','104','257553','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729843),('5','104','257554','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729844),('5','104','257554','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729845),('5','104','257554','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729846),('5','104','257555','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729847),('5','104','257555','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729848),('5','104','257555','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729849),('5','104','257556','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729850),('5','104','257556','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729851),('5','104','257556','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729852),('5','104','257557','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729853),('5','104','257557','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729854),('5','104','257557','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729855),('5','104','257558','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729856),('5','104','257558','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729857),('5','104','257558','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729858),('5','104','257559','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729859),('5','104','257559','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729860),('5','104','257559','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729861),('5','104','257560','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729862),('5','104','257560','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729863),('5','104','257560','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729864),('5','104','257561','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729865),('5','104','257561','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729866),('5','104','257561','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729867),('5','104','257562','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729868),('5','104','257562','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729869),('5','104','257562','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729870),('5','104','257563','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729871),('5','104','257563','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729872),('5','104','257563','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729873),('5','104','257564','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729874),('5','104','257564','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729875),('5','104','257564','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729876),('5','104','257565','395',820.00,820.00,0.00,0.00,0.00,0.00,0.00,729877),('5','104','257565','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729878),('5','104','257565','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729879),('5','104','257566','394',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729880),('5','104','257566','395',820.00,820.00,0.00,0.00,0.00,0.00,0.00,729881),('5','104','257566','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729882),('5','104','257567','395',820.00,820.00,0.00,0.00,0.00,0.00,0.00,729883),('5','104','257567','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729884),('5','104','257567','394',165.00,165.00,2534.20,0.00,0.00,0.00,0.00,729885),('5','104','257568','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729886),('5','104','257568','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729887),('5','104','257568','394',165.00,165.00,5440.15,0.00,0.00,0.00,0.00,729888),('5','104','257569','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729889),('5','104','257569','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729890),('5','104','257569','394',165.00,165.00,5715.52,0.00,0.00,0.00,0.00,729891),('5','104','257570','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729892),('5','104','257570','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729893),('5','104','257570','394',185.00,185.00,5959.39,0.00,0.00,0.00,0.00,729894),('5','104','257571','394',185.00,185.00,5327.82,0.00,0.00,0.00,0.00,729895),('5','104','257571','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729896),('5','104','257571','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729897),('5','104','257572','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729898),('5','104','257572','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729899),('5','104','257572','394',185.00,185.00,7712.01,0.00,0.00,0.00,0.00,729900),('5','104','257573','394',185.00,185.00,8962.14,0.00,0.00,0.00,0.00,729901),('5','104','257573','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729902),('5','104','257573','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729903),('5','104','257574','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729904),('5','104','257574','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729905),('5','104','257574','394',185.00,185.00,10832.00,0.00,0.00,0.00,0.00,729906),('5','104','257575','394',185.00,185.00,8780.87,0.00,0.00,0.00,0.00,729907),('5','104','257575','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729908),('5','104','257575','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729909),('5','104','257576','394',185.00,185.00,14392.74,0.00,0.00,0.00,0.00,729910),('5','104','257576','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729911),('5','104','257576','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729912),('5','104','257577','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729913),('5','104','257577','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729914),('5','104','257577','394',185.00,185.00,8407.39,0.00,0.00,0.00,0.00,729915),('5','104','257578','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729916),('5','104','257578','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729917),('5','104','257578','394',185.00,185.00,9623.87,0.00,0.00,0.00,0.00,729918),('5','104','257579','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729919),('5','104','257579','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729920),('5','104','257579','394',185.00,185.00,7607.52,0.00,0.00,0.00,0.00,729921),('5','104','257580','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729922),('5','104','257580','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729923),('5','104','257580','394',185.00,185.00,9087.70,0.00,0.00,0.00,0.00,729924),('5','104','257581','394',185.00,185.00,8813.32,0.00,0.00,0.00,0.00,729925),('5','104','257581','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729926),('5','104','257581','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729927),('5','104','257582','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729928),('5','104','257582','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729929),('5','104','257582','394',185.00,185.00,8042.46,0.00,0.00,0.00,0.00,729930),('5','104','257583','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729931),('5','104','257583','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729932),('5','104','257583','394',185.00,185.00,8507.63,0.00,0.00,0.00,0.00,729933),('5','104','257584','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729934),('5','104','257584','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729935),('5','104','257584','394',185.00,185.00,9033.24,0.00,0.00,0.00,0.00,729936),('5','104','257585','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729937),('5','104','257585','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729938),('5','104','257585','394',185.00,185.00,7144.40,0.00,0.00,0.00,0.00,729939),('5','104','257586','394',185.00,185.00,6401.06,0.00,0.00,0.00,0.00,729940),('5','104','257586','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729941),('5','104','257586','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729942),('5','104','257587','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729943),('5','104','257587','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729944),('5','104','257587','394',185.00,185.00,2633.48,0.00,0.00,0.00,0.00,729945),('5','104','257588','394',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729946),('5','104','257588','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729947),('5','104','257588','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729948),('5','104','257589','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729949),('5','104','257589','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729950),('5','104','257589','394',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729951),('5','104','257590','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729952),('5','104','257590','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729953),('5','104','257590','394',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729954),('5','104','257591','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729955),('5','104','257591','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729956),('5','104','257591','394',185.00,185.00,2714.37,0.00,0.00,0.00,0.00,729957),('5','104','257592','394',185.00,185.00,8203.85,0.00,0.00,0.00,0.00,729958),('5','104','257592','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729959),('5','104','257592','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729960),('5','104','257593','394',185.00,185.00,6281.52,0.00,0.00,0.00,0.00,729961),('5','104','257593','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729962),('5','104','257593','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729963),('5','104','257594','394',185.00,185.00,7836.95,0.00,0.00,0.00,0.00,729964),('5','104','257594','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729965),('5','104','257594','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729966),('5','104','257595','394',185.00,185.00,6001.11,0.00,0.00,0.00,0.00,729967),('5','104','257595','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729968),('5','104','257595','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729969),('5','104','257596','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729970),('5','104','257596','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729971),('5','104','257596','394',185.00,185.00,10037.64,0.00,0.00,0.00,0.00,729972),('5','104','257597','394',185.00,185.00,3908.81,0.00,0.00,0.00,0.00,729973),('5','104','257597','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729974),('5','104','257597','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729975),('5','104','257598','394',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729976),('5','104','257598','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729977),('5','104','257598','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729978),('5','104','257599','394',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729979),('5','104','257599','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729980),('5','104','257599','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729981),('5','104','257600','394',185.00,185.00,3114.57,0.00,0.00,0.00,0.00,729982),('5','104','257600','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729983),('5','104','257600','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729984),('5','104','257601','394',185.00,185.00,8026.81,0.00,0.00,0.00,0.00,729985),('5','104','257601','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729986),('5','104','257601','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729987),('5','104','257602','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729988),('5','104','257602','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729989),('5','104','257602','394',185.00,185.00,8861.65,0.00,0.00,0.00,0.00,729990),('5','104','257603','394',185.00,185.00,8765.12,0.00,0.00,0.00,0.00,729991),('5','104','257603','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729992),('5','104','257603','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729993),('5','104','257604','394',185.00,185.00,6740.99,0.00,0.00,0.00,0.00,729994),('5','104','257604','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729995),('5','104','257604','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729996),('5','104','257605','394',185.00,185.00,8741.16,0.00,0.00,0.00,0.00,729997),('5','104','257605','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729998),('5','104','257605','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,729999),('5','104','257606','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730000),('5','104','257606','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730001),('5','104','257606','394',185.00,185.00,6552.66,0.00,0.00,0.00,0.00,730002),('5','104','257607','394',185.00,185.00,8078.84,0.00,0.00,0.00,0.00,730003),('5','104','257607','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730004),('5','104','257607','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730005),('5','104','257608','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730006),('5','104','257608','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730007),('5','104','257608','394',185.00,185.00,7421.74,0.00,0.00,0.00,0.00,730008),('5','104','257609','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730009),('5','104','257609','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730010),('5','104','257609','394',185.00,185.00,5799.48,0.00,0.00,0.00,0.00,730011),('5','104','257610','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730012),('5','104','257610','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730013),('5','104','257610','394',185.00,185.00,6287.47,0.00,0.00,0.00,0.00,730014),('5','104','257611','394',185.00,185.00,4702.91,0.00,0.00,0.00,0.00,730015),('5','104','257611','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730016),('5','104','257611','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730017),('5','104','257612','394',185.00,185.00,6373.86,0.00,0.00,0.00,0.00,730018),('5','104','257612','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730019),('5','104','257612','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730020),('5','104','257613','394',185.00,185.00,4244.36,0.00,0.00,0.00,0.00,730021),('5','104','257613','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730022),('5','104','257613','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730023),('5','104','257614','394',185.00,185.00,1263.43,0.00,0.00,0.00,0.00,730024),('5','104','257614','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730025),('5','104','257614','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730026),('5','104','257615','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730027),('5','104','257615','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730028),('5','104','257615','394',185.00,185.00,8019.13,0.00,0.00,0.00,0.00,730029),('5','104','257616','394',185.00,185.00,8386.94,0.00,0.00,0.00,0.00,730030),('5','104','257616','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730031),('5','104','257616','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730032),('5','104','257617','394',185.00,185.00,8055.99,0.00,0.00,0.00,0.00,730033),('5','104','257617','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730034),('5','104','257617','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730035),('5','104','257618','394',185.00,185.00,8727.10,0.00,0.00,0.00,0.00,730036),('5','104','257618','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730037),('5','104','257618','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730038),('5','104','257619','394',185.00,185.00,4843.84,0.00,0.00,0.00,0.00,730039),('5','104','257619','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730040),('5','104','257619','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730041),('5','104','257620','394',185.00,185.00,1322.22,0.00,0.00,0.00,0.00,730042),('5','104','257620','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730043),('5','104','257620','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730044),('5','104','257621','394',185.00,185.00,1326.56,0.00,0.00,0.00,0.00,730045),('5','104','257621','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730046),('5','104','257621','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730047),('5','104','257622','394',185.00,185.00,14591.35,0.00,0.00,0.00,0.00,730048),('5','104','257622','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730049),('5','104','257622','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730050),('5','104','257623','394',185.00,185.00,13208.75,0.00,0.00,0.00,0.00,730051),('5','104','257623','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730052),('5','104','257623','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730053),('5','104','257624','394',185.00,185.00,13004.06,0.00,0.00,0.00,0.00,730054),('5','104','257624','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730055),('5','104','257624','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730056),('5','104','257625','394',185.00,185.00,2969.24,0.00,0.00,0.00,0.00,730057),('5','104','257625','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730058),('5','104','257625','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730059),('5','104','257626','394',185.00,185.00,2664.20,0.00,0.00,0.00,0.00,730060),('5','104','257626','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730061),('5','104','257626','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730062),('5','104','257627','394',185.00,185.00,13373.21,0.00,0.00,0.00,0.00,730063),('5','104','257627','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730064),('5','104','257627','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730065),('5','104','257628','394',185.00,185.00,16558.42,0.00,0.00,0.00,0.00,730066),('5','104','257628','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730067),('5','104','257628','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730068),('5','104','257629','394',185.00,185.00,11819.74,0.00,0.00,0.00,0.00,730069),('5','104','257629','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730070),('5','104','257629','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730071),('5','104','257630','394',185.00,185.00,5224.35,0.00,0.00,0.00,0.00,730072),('5','104','257630','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730073),('5','104','257630','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730074),('5','104','257631','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730075),('5','104','257631','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730076),('5','104','257631','394',185.00,185.00,2406.55,0.00,0.00,0.00,0.00,730077),('5','104','257632','394',185.00,185.00,12181.06,0.00,0.00,0.00,0.00,730078),('5','104','257632','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730079),('5','104','257632','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730080),('5','104','257633','394',185.00,185.00,15928.33,0.00,0.00,0.00,0.00,730081),('5','104','257633','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730082),('5','104','257633','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730083),('5','104','257634','394',185.00,185.00,9728.75,0.00,0.00,0.00,0.00,730084),('5','104','257634','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730085),('5','104','257634','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730086),('5','104','257635','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730087),('5','104','257635','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730088),('5','104','257635','394',185.00,185.00,15613.36,0.00,0.00,0.00,0.00,730089),('5','104','257636','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730090),('5','104','257636','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730091),('5','104','257636','394',185.00,185.00,10854.14,0.00,0.00,0.00,0.00,730092),('5','104','257637','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730093),('5','104','257637','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730094),('5','104','257637','394',185.00,185.00,13525.24,0.00,0.00,0.00,0.00,730095),('5','104','257638','394',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730096),('5','104','257638','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730097),('5','104','257638','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730098),('5','104','257639','394',185.00,185.00,7341.19,0.00,0.00,0.00,0.00,730099),('5','104','257639','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730100),('5','104','257639','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730101),('5','104','257640','394',185.00,185.00,14804.53,0.00,0.00,0.00,0.00,730102),('5','104','257640','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730103),('5','104','257640','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730104),('5','104','257641','394',185.00,185.00,17703.98,0.00,0.00,0.00,0.00,730105),('5','104','257641','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730106),('5','104','257641','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730107),('5','104','257642','394',185.00,185.00,9628.03,0.00,0.00,0.00,0.00,730108),('5','104','257642','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730109),('5','104','257642','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730110),('5','104','257643','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730111),('5','104','257643','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730112),('5','104','257643','394',185.00,185.00,4803.05,0.00,0.00,0.00,0.00,730113),('5','104','257644','394',185.00,185.00,13907.35,0.00,0.00,0.00,0.00,730114),('5','104','257644','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730115),('5','104','257644','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730116),('5','104','257645','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730117),('5','104','257645','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730118),('5','104','257645','394',185.00,185.00,16636.18,0.00,0.00,0.00,0.00,730119),('5','104','257646','394',185.00,185.00,13334.85,0.00,0.00,0.00,0.00,730120),('5','104','257646','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730121),('5','104','257646','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730122),('5','104','257647','394',185.00,185.00,11802.97,0.00,0.00,0.00,0.00,730123),('5','104','257647','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730124),('5','104','257647','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730125),('5','104','257648','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730126),('5','104','257648','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730127),('5','104','257648','394',185.00,185.00,14460.37,0.00,0.00,0.00,0.00,730128),('5','104','257649','394',185.00,185.00,13554.08,0.00,0.00,0.00,0.00,730129),('5','104','257649','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730130),('5','104','257649','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730131),('5','104','257650','394',185.00,185.00,15021.12,0.00,0.00,0.00,0.00,730132),('5','104','257650','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730133),('5','104','257650','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730134),('5','104','257651','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730135),('5','104','257651','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730136),('5','104','257651','394',185.00,185.00,12949.40,0.00,0.00,0.00,0.00,730137),('5','104','257652','394',185.00,185.00,16317.89,0.00,0.00,0.00,0.00,730138),('5','104','257652','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730139),('5','104','257652','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730140),('5','104','257653','394',185.00,185.00,17240.31,0.00,0.00,0.00,0.00,730141),('5','104','257653','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730142),('5','104','257653','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730143),('5','104','257654','394',185.00,185.00,13509.09,0.00,0.00,0.00,0.00,730144),('5','104','257654','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730145),('5','104','257654','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730146),('5','104','257655','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730147),('5','104','257655','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730148),('5','104','257655','394',185.00,185.00,10033.51,0.00,0.00,0.00,0.00,730149),('5','104','257656','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730150),('5','104','257656','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730151),('5','104','257656','394',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730152),('5','104','257657','394',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730153),('5','104','257657','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730154),('5','104','257657','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730155),('5','104','257658','394',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730156),('5','104','257658','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730157),('5','104','257658','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730158),('5','104','257659','394',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730159),('5','104','257659','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730160),('5','104','257659','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730161),('5','104','257660','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730162),('5','104','257660','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730163),('5','104','257660','394',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730164),('5','104','257661','394',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730165),('5','104','257661','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730166),('5','104','257661','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730167),('5','104','257662','394',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730168),('5','104','257662','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730169),('5','104','257662','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730170),('5','104','257663','394',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730171),('5','104','257663','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730172),('5','104','257663','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730173),('5','104','257664','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730174),('5','104','257664','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730175),('5','104','257664','394',185.00,185.00,3109.90,0.00,0.00,0.00,0.00,730176),('5','104','257665','394',185.00,185.00,10806.95,0.00,0.00,0.00,0.00,730177),('5','104','257665','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730178),('5','104','257665','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730179),('5','104','257666','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730180),('5','104','257666','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730181),('5','104','257666','394',185.00,185.00,12218.89,0.00,0.00,0.00,0.00,730182),('5','104','257667','394',185.00,185.00,9416.48,0.00,0.00,0.00,0.00,730183),('5','104','257667','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730184),('5','104','257667','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730185),('5','104','257668','394',185.00,185.00,9711.47,0.00,0.00,0.00,0.00,730186),('5','104','257668','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730187),('5','104','257668','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730188),('5','104','257669','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730189),('5','104','257669','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730190),('5','104','257669','394',185.00,185.00,8267.94,0.00,0.00,0.00,0.00,730191),('5','104','257670','394',185.00,185.00,8674.03,0.00,0.00,0.00,0.00,730192),('5','104','257670','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730193),('5','104','257670','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730194),('5','104','257671','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730195),('5','104','257671','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730196),('5','104','257671','394',185.00,185.00,9709.71,0.00,0.00,0.00,0.00,730197),('5','104','257672','394',185.00,185.00,3090.06,0.00,0.00,0.00,0.00,730198),('5','104','257672','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730199),('5','104','257672','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730200),('5','104','257673','394',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730201),('5','104','257673','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730202),('5','104','257673','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730203),('5','104','257674','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730204),('5','104','257674','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730205),('5','104','257674','394',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730206),('5','104','257675','394',185.00,185.00,3212.87,0.00,0.00,0.00,0.00,730207),('5','104','257675','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730208),('5','104','257675','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730209),('5','104','257676','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730210),('5','104','257676','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730211),('5','104','257676','394',185.00,185.00,8562.26,0.00,0.00,0.00,0.00,730212),('5','104','257677','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730213),('5','104','257677','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730214),('5','104','257677','394',185.00,185.00,9683.14,0.00,0.00,0.00,0.00,730215),('5','104','257678','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730216),('5','104','257678','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730217),('5','104','257678','394',185.00,185.00,10163.79,0.00,0.00,0.00,0.00,730218),('5','104','257679','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730219),('5','104','257679','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730220),('5','104','257679','394',185.00,185.00,10299.09,0.00,0.00,0.00,0.00,730221),('5','104','257680','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730222),('5','104','257680','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730223),('5','104','257680','394',185.00,185.00,3550.48,0.00,0.00,0.00,0.00,730224),('5','104','257681','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730225),('5','104','257681','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730226),('5','104','257681','394',185.00,185.00,8916.70,0.00,0.00,0.00,0.00,730227),('5','104','257682','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730228),('5','104','257682','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730229),('5','104','257682','394',185.00,185.00,9544.58,0.00,0.00,0.00,0.00,730230),('5','104','257683','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730231),('5','104','257683','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730232),('5','104','257683','394',185.00,185.00,7505.44,0.00,0.00,0.00,0.00,730233),('5','104','257684','394',185.00,185.00,3585.29,0.00,0.00,0.00,0.00,730234),('5','104','257684','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730235),('5','104','257684','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730236),('5','104','257685','394',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730237),('5','104','257685','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730238),('5','104','257685','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730239),('5','104','257686','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730240),('5','104','257686','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730241),('5','104','257686','394',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730242),('5','104','257687','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730243),('5','104','257687','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730244),('5','104','257687','394',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730245),('5','104','257688','394',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730246),('5','104','257688','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730247),('5','104','257688','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730248),('5','104','257689','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730249),('5','104','257689','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730250),('5','104','257689','394',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730251),('5','104','257690','394',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730252),('5','104','257690','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730253),('5','104','257690','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730254),('5','104','257691','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730255),('5','104','257691','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730256),('5','104','257691','394',185.00,185.00,3202.13,0.00,0.00,0.00,0.00,730257),('5','104','257692','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730258),('5','104','257692','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730259),('5','104','257692','394',185.00,185.00,10231.17,0.00,0.00,0.00,0.00,730260),('5','104','257693','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730261),('5','104','257693','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730262),('5','104','257693','394',185.00,185.00,9730.57,0.00,0.00,0.00,0.00,730263),('5','104','257694','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730264),('5','104','257694','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730265),('5','104','257694','394',185.00,185.00,3316.06,0.00,0.00,0.00,0.00,730266),('5','104','257695','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730267),('5','104','257695','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730268),('5','104','257695','394',185.00,185.00,9062.78,0.00,0.00,0.00,0.00,730269),('5','104','257696','394',185.00,185.00,5493.68,0.00,0.00,0.00,0.00,730270),('5','104','257696','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730271),('5','104','257696','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730272),('5','104','257697','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730273),('5','104','257697','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730274),('5','104','257697','394',185.00,185.00,3631.43,0.00,0.00,0.00,0.00,730275),('5','104','257698','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730276),('5','104','257698','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730277),('5','104','257698','394',185.00,185.00,9197.23,0.00,0.00,0.00,0.00,730278),('5','104','257699','394',185.00,185.00,8192.15,0.00,0.00,0.00,0.00,730279),('5','104','257699','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730280),('5','104','257699','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730281),('5','104','257700','395',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730282),('5','104','257700','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730283),('5','104','257700','394',185.00,185.00,10008.27,0.00,0.00,0.00,0.00,730284),('5','104','257701','394',185.00,185.00,2236.05,0.00,0.00,0.00,0.00,730285),('5','104','257701','395',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730286),('5','104','257701','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730287),('5','104','257702','394',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730288),('5','104','257702','395',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730289),('5','104','257702','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730290),('5','104','257703','394',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730291),('5','104','257703','395',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730292),('5','104','257703','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730293),('5','104','257704','395',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730294),('5','104','257704','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730295),('5','104','257704','394',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730296),('5','104','257705','395',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730297),('5','104','257705','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730298),('5','104','257705','394',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730299),('5','104','257706','395',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730300),('5','104','257706','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730301),('5','104','257706','394',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730302),('5','104','257707','395',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730303),('5','104','257707','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730304),('5','104','257707','394',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730305),('5','104','257708','395',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730306),('5','104','257708','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730307),('5','104','257708','394',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730308),('5','104','257709','395',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730309),('5','104','257709','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730310),('5','104','257709','394',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730311),('5','104','257710','394',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730312),('5','104','257710','395',885.00,885.00,0.00,0.00,0.00,0.00,0.00,730313),('5','104','257710','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730314),('5','104','257711','395',885.00,885.00,0.00,0.00,0.00,0.00,0.00,730315),('5','104','257711','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730316),('5','104','257711','394',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730317),('5','104','257712','395',885.00,885.00,0.00,0.00,0.00,0.00,0.00,730318),('5','104','257712','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730319),('5','104','257712','394',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730320),('5','104','257713','395',885.00,885.00,0.00,0.00,0.00,0.00,0.00,730321),('5','104','257713','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730322),('5','104','257713','394',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730323),('5','104','257714','395',885.00,885.00,0.00,0.00,0.00,0.00,0.00,730324),('5','104','257714','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730325),('5','104','257714','394',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730326),('5','104','257715','395',885.00,885.00,0.00,0.00,0.00,0.00,0.00,730327),('5','104','257715','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730328),('5','104','257715','394',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730329),('5','104','257716','394',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730330),('5','104','257716','395',885.00,885.00,0.00,0.00,0.00,0.00,0.00,730331),('5','104','257716','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730332),('5','104','257717','395',885.00,885.00,0.00,0.00,0.00,0.00,0.00,730333),('5','104','257717','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730334),('5','104','257717','394',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730335),('5','104','257718','395',885.00,885.00,0.00,0.00,0.00,0.00,0.00,730336),('5','104','257718','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730337),('5','104','257718','394',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730338),('5','104','257719','395',885.00,885.00,0.00,0.00,0.00,0.00,0.00,730339),('5','104','257719','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730340),('5','104','257719','394',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730341),('5','104','257720','395',885.00,885.00,0.00,0.00,0.00,0.00,0.00,730342),('5','104','257720','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730343),('5','104','257720','394',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730344),('5','104','257721','394',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730345),('5','104','257721','395',885.00,885.00,0.00,0.00,0.00,0.00,0.00,730346),('5','104','257721','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730347),('5','104','257722','395',885.00,885.00,0.00,0.00,0.00,0.00,0.00,730348),('5','104','257722','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730349),('5','104','257722','394',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730350),('5','104','257723','394',185.00,185.00,8261.46,0.00,0.00,0.00,0.00,730351),('5','104','257723','395',885.00,885.00,0.00,0.00,0.00,0.00,0.00,730352),('5','104','257723','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730353),('5','104','257724','394',185.00,185.00,9317.19,0.00,0.00,0.00,0.00,730354),('5','104','257724','395',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730355),('5','104','257724','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730356),('5','104','257725','395',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730357),('5','104','257725','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730358),('5','104','257725','394',185.00,185.00,11149.69,0.00,0.00,0.00,0.00,730359),('5','104','257726','394',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730360),('5','104','257726','395',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730361),('5','104','257726','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730362),('5','104','257727','394',185.00,185.00,4060.02,0.00,0.00,0.00,0.00,730363),('5','104','257727','395',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730364),('5','104','257727','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730365),('5','104','257728','394',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730366),('5','104','257728','395',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730367),('5','104','257728','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730368),('5','104','257729','394',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730369),('5','104','257729','395',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730370),('5','104','257729','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730371),('5','104','257730','395',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730372),('5','104','257730','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730373),('5','104','257730','394',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730374),('5','104','257731','394',220.00,220.00,7614.61,0.00,0.00,0.00,0.00,730375),('5','104','257731','395',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730376),('5','104','257731','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730377),('5','104','257732','394',220.00,220.00,7203.09,0.00,0.00,0.00,0.00,730378),('5','104','257732','395',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730379),('5','104','257732','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730380),('5','104','257733','394',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730381),('5','104','257733','395',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730382),('5','104','257733','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730383),('5','104','257734','394',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730384),('5','104','257734','395',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730385),('5','104','257734','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730386),('5','104','257735','395',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730387),('5','104','257735','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730388),('5','104','257735','394',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730389),('5','104','257736','394',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730390),('5','104','257736','395',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730391),('5','104','257736','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730392),('5','104','257737','395',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730393),('5','104','257737','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730394),('5','104','257737','394',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730395),('5','104','257738','395',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730396),('5','104','257738','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730397),('5','104','257738','394',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730398),('5','104','257739','395',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730399),('5','104','257739','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730400),('5','104','257739','394',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730401),('5','104','257740','394',220.00,220.00,2231.96,0.00,0.00,0.00,0.00,730402),('5','104','257740','395',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730403),('5','104','257740','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730404),('5','104','257741','395',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730405),('5','104','257741','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730406),('5','104','257741','394',220.00,220.00,7344.95,0.00,0.00,0.00,0.00,730407),('5','104','257742','394',220.00,220.00,9479.29,0.00,0.00,0.00,0.00,730408),('5','104','257742','395',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730409),('5','104','257742','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730410),('5','104','257743','394',220.00,220.00,8841.29,0.00,0.00,0.00,0.00,730411),('5','104','257743','395',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730412),('5','104','257743','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730413),('5','104','257744','395',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730414),('5','104','257744','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730415),('5','104','257744','394',220.00,220.00,1682.43,0.00,0.00,0.00,0.00,730416),('5','104','257745','395',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730417),('5','104','257745','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730418),('5','104','257745','394',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730419),('5','104','257746','395',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730420),('5','104','257746','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730421),('5','104','257746','394',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730422),('5','104','257747','394',220.00,220.00,3862.13,0.00,0.00,0.00,0.00,730423),('5','104','257747','395',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730424),('5','104','257747','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730425),('5','104','257748','394',220.00,220.00,9689.62,0.00,0.00,0.00,0.00,730426),('5','104','257748','395',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730427),('5','104','257748','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730428),('5','104','257749','394',220.00,220.00,10363.62,0.00,0.00,0.00,0.00,730429),('5','104','257749','395',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730430),('5','104','257749','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730431),('5','104','257750','395',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730432),('5','104','257750','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730433),('5','104','257750','394',220.00,220.00,4427.63,0.00,0.00,0.00,0.00,730434),('5','104','257751','394',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730435),('5','104','257751','395',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730436),('5','104','257751','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730437),('5','104','257752','395',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730438),('5','104','257752','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730439),('5','104','257752','394',220.00,220.00,1861.95,0.00,0.00,0.00,0.00,730440),('5','104','257753','394',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730441),('5','104','257753','395',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730442),('5','104','257753','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730443),('5','104','257754','395',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730444),('5','104','257754','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730445),('5','104','257754','394',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730446),('5','104','257755','394',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730447),('5','104','257755','395',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730448),('5','104','257755','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730449),('5','104','257756','394',210.00,210.00,1786.88,0.00,0.00,0.00,0.00,730450),('5','104','257756','395',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730451),('5','104','257756','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730452),('5','104','257757','394',210.00,210.00,4210.31,0.00,0.00,0.00,0.00,730453),('5','104','257757','395',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730454),('5','104','257757','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730455),('5','104','257758','395',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730456),('5','104','257758','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730457),('5','104','257758','394',210.00,210.00,11633.93,0.00,0.00,0.00,0.00,730458),('5','104','257759','394',210.00,210.00,19446.66,0.00,0.00,0.00,0.00,730459),('5','104','257759','395',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730460),('5','104','257759','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730461),('5','104','257760','394',210.00,210.00,29755.88,0.00,0.00,0.00,0.00,730462),('5','104','257760','395',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730463),('5','104','257760','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730464),('5','104','257761','394',210.00,210.00,31681.76,0.00,0.00,0.00,0.00,730465),('5','104','257761','395',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730466),('5','104','257761','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730467),('5','104','257762','394',210.00,210.00,34159.05,0.00,0.00,0.00,0.00,730468),('5','104','257762','395',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730469),('5','104','257762','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730470),('5','104','257763','395',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730471),('5','104','257763','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730472),('5','104','257763','394',210.00,210.00,10340.78,0.00,0.00,0.00,0.00,730473),('5','104','257764','394',210.00,210.00,10135.16,0.00,0.00,0.00,0.00,730474),('5','104','257764','395',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730475),('5','104','257764','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730476),('5','104','257765','395',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730477),('5','104','257765','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730478),('5','104','257765','394',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730479),('5','104','257766','395',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730480),('5','104','257766','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730481),('5','104','257766','394',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730482),('5','104','257767','394',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730483),('5','104','257767','395',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730484),('5','104','257767','396',365.00,365.00,0.00,0.00,0.00,0.00,0.00,730485);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=365 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('5',364,'104','PRODUCT TANKS','TANKS CONTAINING PETROLEUM PRODUCTS.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=899 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('5','104','364',895,0,'394','PMS TANK 1',36000.00,1.00,32959.27,'TANKS CONTAINING PETROLEUM PRODUCTS.','595','2021-02-20 23:27:41','2022-03-25 10:20:53','600',5,1),('5','104','364',896,0,'394','PMS TANK 2',34500.00,1.00,29246.92,'TANKS CONTAINING PETROLEUM PRODUCTS.','595','2021-02-20 23:31:43','2021-02-22 17:22:38','595',5,1),('5','104','364',897,0,'395','AGO TANK',34500.00,1.00,6109.17,'TANKS CONTAINING PETROLEUM PRODUCTS.','595','2021-02-20 23:34:30','2021-02-22 17:23:20','595',5,1),('5','104','364',898,0,'396','DPK TANK',34500.00,1.00,150.00,'TANKS CONTAINING PETROLEUM PRODUCTS.','595','2021-02-20 23:36:11','2021-02-22 17:23:43','595',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'5','104',898,0.00,'2023-03-17 15:50:19'),(2,'5','104',897,127.55,'2023-03-17 15:50:19'),(3,'5','104',896,182.40,'2023-03-17 15:50:19'),(4,'5','104',895,3214.60,'2023-03-17 15:50:19');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2644039 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2110483,'5','104','897',395,'Sale Id shift 242784',0.00,0.00,0.00,4655.99,0.00,'2021-12-01 08:30:43','',''),(2110484,'5','104',NULL,395,'Sale Id shift 242784',1606316.55,0.00,0.00,0.00,0.00,'2021-12-01 08:30:43','',''),(2126280,'5','104','897',395,'Sale Id shift 242996',0.00,0.00,0.00,1830.39,0.00,'2021-12-02 11:25:57','',''),(2126281,'5','104',NULL,395,'Sale Id shift 242996',631484.55,0.00,0.00,0.00,0.00,'2021-12-02 11:25:57','',''),(2152590,'5','104','897',395,'Sale Id shift 243256',0.00,0.00,0.00,1488.67,0.00,'2021-12-04 10:43:17','',''),(2152591,'5','104',NULL,395,'Sale Id shift 243256',513591.15,0.00,0.00,0.00,0.00,'2021-12-04 10:43:17','',''),(2163655,'5','104','897',395,'Sale Id shift 243786',0.00,0.00,0.00,1860.97,0.00,'2021-12-05 07:53:25','',''),(2163656,'5','104',NULL,395,'Sale Id shift 243786',642034.65,0.00,0.00,0.00,0.00,'2021-12-05 07:53:25','',''),(2174377,'5','104','897',395,'Sale Id shift 244000',0.00,0.00,0.00,1990.04,0.00,'2021-12-05 19:34:08','',''),(2174378,'5','104',NULL,395,'Sale Id shift 244000',686563.80,0.00,0.00,0.00,0.00,'2021-12-05 19:34:08','',''),(2174460,'5','104','897',395,'Sale Id shift 244007',0.00,0.00,0.00,604.28,0.00,'2021-12-05 20:35:06','',''),(2174461,'5','104',NULL,395,'Sale Id shift 244007',208476.60,0.00,0.00,0.00,0.00,'2021-12-05 20:35:06','',''),(2189270,'5','104',NULL,394,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,4933500.00,29900.00,0.00,0.00,'2021-12-07 08:07:45','',''),(2189273,'5','104','897',395,'Sale Id shift 244152',0.00,0.00,0.00,2775.48,0.00,'2021-12-07 08:08:01','',''),(2189274,'5','104',NULL,395,'Sale Id shift 244152',957540.60,0.00,0.00,0.00,0.00,'2021-12-07 08:08:01','',''),(2198531,'5','104',NULL,394,'Reception corrector for bridging 126451',0.00,0.00,0.00,29900.00,0.00,'2021-12-07 17:12:16','',''),(2198532,'5','104','895',394,'Received from bridging 126451',0.00,0.00,29900.00,0.00,0.00,'2021-12-07 17:12:16','',''),(2210814,'5','104','895',394,'Sale Id shift 244358',0.00,0.00,0.00,4253.63,0.00,'2021-12-08 17:41:29','',''),(2210815,'5','104','895',394,'Sale Id shift 244358',0.00,0.00,0.00,3190.32,0.00,'2021-12-08 17:41:29','',''),(2210816,'5','104','897',395,'Sale Id shift 244358',0.00,0.00,0.00,1167.11,0.00,'2021-12-08 17:41:29','',''),(2210817,'5','104','895',394,'Sale Id shift 244358',0.00,0.00,0.00,4353.91,0.00,'2021-12-08 17:41:29','',''),(2210818,'5','104',NULL,394,'Sale Id shift 244358',1946646.90,0.00,0.00,0.00,0.00,'2021-12-08 17:41:29','',''),(2210819,'5','104',NULL,395,'Sale Id shift 244358',402652.95,0.00,0.00,0.00,0.00,'2021-12-08 17:41:29','',''),(2211665,'5','104','895',394,'Sale Id shift 244698',0.00,0.00,0.00,3750.23,0.00,'2021-12-09 03:53:02','',''),(2211666,'5','104','895',394,'Sale Id shift 244698',0.00,0.00,0.00,1673.89,0.00,'2021-12-09 03:53:02','',''),(2211667,'5','104','897',395,'Sale Id shift 244698',0.00,0.00,0.00,1316.02,0.00,'2021-12-09 03:53:02','',''),(2211668,'5','104','895',394,'Sale Id shift 244698',0.00,0.00,0.00,3501.74,0.00,'2021-12-09 03:53:02','',''),(2211669,'5','104',NULL,394,'Sale Id shift 244698',1472766.90,0.00,0.00,0.00,0.00,'2021-12-09 03:53:02','',''),(2211670,'5','104',NULL,395,'Sale Id shift 244698',454026.90,0.00,0.00,0.00,0.00,'2021-12-09 03:53:02','',''),(2230124,'5','104','895',394,'Sale Id shift 244840',0.00,0.00,0.00,3119.03,0.00,'2021-12-10 10:50:42','',''),(2230125,'5','104','895',394,'Sale Id shift 244840',0.00,0.00,0.00,2958.86,0.00,'2021-12-10 10:50:42','',''),(2230126,'5','104','897',395,'Sale Id shift 244840',0.00,0.00,0.00,615.65,0.00,'2021-12-10 10:50:42','',''),(2230127,'5','104','895',394,'Sale Id shift 244840',0.00,0.00,0.00,3014.31,0.00,'2021-12-10 10:50:42','',''),(2230128,'5','104',NULL,394,'Sale Id shift 244840',1500213.00,0.00,0.00,0.00,0.00,'2021-12-10 10:50:42','',''),(2230129,'5','104',NULL,395,'Sale Id shift 244840',212399.25,0.00,0.00,0.00,0.00,'2021-12-10 10:50:42','',''),(2239182,'5','104','897',395,'Sale Id shift 245187',0.00,0.00,0.00,745.23,0.00,'2021-12-11 06:58:16','',''),(2239183,'5','104',NULL,395,'Sale Id shift 245187',257104.35,0.00,0.00,0.00,0.00,'2021-12-11 06:58:16','',''),(2251914,'5','104','897',395,'Sale Id shift 245350',0.00,0.00,0.00,597.55,0.00,'2021-12-12 03:45:23','',''),(2251915,'5','104',NULL,395,'Sale Id shift 245350',206154.75,0.00,0.00,0.00,0.00,'2021-12-12 03:45:23','',''),(2269513,'5','104','897',395,'Sale Id shift 245643',0.00,0.00,0.00,202.03,0.00,'2021-12-13 10:36:31','',''),(2269514,'5','104',NULL,395,'Sale Id shift 245643',69700.35,0.00,0.00,0.00,0.00,'2021-12-13 10:36:31','',''),(2269543,'5','104',NULL,395,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,62100.00,180.00,0.00,0.00,'2021-12-13 10:38:46','',''),(2279769,'5','104',NULL,395,'Reception corrector for bridging 127308',0.00,0.00,0.00,180.00,0.00,'2021-12-14 08:55:31','',''),(2279770,'5','104','897',395,'Received from bridging 127308',0.00,0.00,180.00,0.00,0.00,'2021-12-14 08:55:31','',''),(2294461,'5','104',NULL,394,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,5898750.00,35750.00,0.00,0.00,'2021-12-16 08:13:57','',''),(2295497,'5','104',NULL,394,'Reception corrector for bridging 127599',0.00,0.00,0.00,18100.00,0.00,'2021-12-16 09:39:33','',''),(2295498,'5','104','895',394,'Received from bridging 127599',0.00,0.00,18100.00,0.00,0.00,'2021-12-16 09:39:33','',''),(2295501,'5','104',NULL,394,'Reception corrector for bridging 127600',0.00,0.00,0.00,17650.00,0.00,'2021-12-16 09:39:45','',''),(2295502,'5','104','896',394,'Received from bridging 127600',0.00,0.00,17650.00,0.00,0.00,'2021-12-16 09:39:45','',''),(2295701,'5','104','895',394,'Sale Id shift 246161',0.00,0.00,0.00,174.40,0.00,'2021-12-16 09:57:53','',''),(2295702,'5','104','895',394,'Sale Id shift 246161',0.00,0.00,0.00,211.75,0.00,'2021-12-16 09:57:53','',''),(2295703,'5','104','895',394,'Sale Id shift 246161',0.00,0.00,0.00,280.93,0.00,'2021-12-16 09:57:53','',''),(2295704,'5','104',NULL,394,'Sale Id shift 246161',110068.20,0.00,0.00,0.00,0.00,'2021-12-16 09:57:53','',''),(2295832,'5','104','895',394,'Sale Id shift 246546',0.00,0.00,0.00,3443.02,0.00,'2021-12-16 10:06:09','',''),(2295833,'5','104','896',394,'Sale Id shift 246546',0.00,0.00,0.00,3447.22,0.00,'2021-12-16 10:06:09','',''),(2295834,'5','104','896',394,'Sale Id shift 246546',0.00,0.00,0.00,1223.13,0.00,'2021-12-16 10:06:09','',''),(2295835,'5','104','895',394,'Sale Id shift 246546',0.00,0.00,0.00,3641.24,0.00,'2021-12-16 10:06:09','',''),(2295836,'5','104',NULL,394,'Sale Id shift 246546',1939510.65,0.00,0.00,0.00,0.00,'2021-12-16 10:06:09','',''),(2303455,'5','104','895',394,'Sale Id shift 246551',0.00,0.00,0.00,3679.64,0.00,'2021-12-17 09:34:39','',''),(2303456,'5','104','895',394,'Sale Id shift 246551',0.00,0.00,0.00,3122.35,0.00,'2021-12-17 09:34:39','',''),(2303457,'5','104','896',394,'Sale Id shift 246551',0.00,0.00,0.00,2181.73,0.00,'2021-12-17 09:34:39','',''),(2303458,'5','104','896',394,'Sale Id shift 246551',0.00,0.00,0.00,1686.43,0.00,'2021-12-17 09:34:39','',''),(2303459,'5','104','895',394,'Sale Id shift 246551',0.00,0.00,0.00,3573.33,0.00,'2021-12-17 09:34:39','',''),(2303460,'5','104',NULL,394,'Sale Id shift 246551',2350174.20,0.00,0.00,0.00,0.00,'2021-12-17 09:34:39','',''),(2308857,'5','104',NULL,395,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,4588500.00,13300.00,0.00,0.00,'2021-12-18 04:02:19','',''),(2313052,'5','104',NULL,395,'Reception corrector for bridging 127863',0.00,0.00,0.00,13300.00,0.00,'2021-12-18 11:58:22','',''),(2313053,'5','104','897',395,'Received from bridging 127863',0.00,0.00,13300.00,0.00,0.00,'2021-12-18 11:58:22','',''),(2327792,'5','104','895',0,'Tank level zero out for dipping',0.00,0.00,0.00,791.40,0.00,'2021-12-20 09:30:05','',''),(2327793,'5','104','895',0,'Inventory adjustment from tank dipping to 1000',0.00,0.00,1000.00,0.00,0.00,'2021-12-20 09:30:05','',''),(2327795,'5','104','896',0,'Tank level zero out for dipping',0.00,0.00,0.00,9352.48,0.00,'2021-12-20 09:30:24','',''),(2327796,'5','104','896',0,'Inventory adjustment from tank dipping to 10000',0.00,0.00,10000.00,0.00,0.00,'2021-12-20 09:30:24','',''),(2327951,'5','104','896',394,'Sale Id shift 246787',0.00,0.00,0.00,4604.79,0.00,'2021-12-20 09:51:21','',''),(2327952,'5','104','896',394,'Sale Id shift 246787',0.00,0.00,0.00,4753.92,0.00,'2021-12-20 09:51:21','',''),(2327953,'5','104','897',395,'Sale Id shift 246787',0.00,0.00,0.00,103.94,0.00,'2021-12-20 09:51:21','',''),(2327954,'5','104',NULL,394,'Sale Id shift 246787',1544187.15,0.00,0.00,0.00,0.00,'2021-12-20 09:51:21','',''),(2327955,'5','104',NULL,395,'Sale Id shift 246787',35859.30,0.00,0.00,0.00,0.00,'2021-12-20 09:51:21','',''),(2328116,'5','104','897',395,'Sale Id shift 247484',0.00,0.00,0.00,2953.43,0.00,'2021-12-20 10:09:53','',''),(2328117,'5','104',NULL,395,'Sale Id shift 247484',1018933.35,0.00,0.00,0.00,0.00,'2021-12-20 10:09:53','',''),(2328159,'5','104','897',395,'Sale Id shift 247489',0.00,0.00,0.00,563.44,0.00,'2021-12-20 10:15:43','',''),(2328160,'5','104',NULL,395,'Sale Id shift 247489',194386.80,0.00,0.00,0.00,0.00,'2021-12-20 10:15:43','',''),(2334312,'5','104','897',395,'Sale Id shift 247490',0.00,0.00,0.00,1622.20,0.00,'2021-12-21 07:59:18','',''),(2334313,'5','104',NULL,395,'Sale Id shift 247490',559659.00,0.00,0.00,0.00,0.00,'2021-12-21 07:59:18','',''),(2342494,'5','104','897',395,'Sale Id shift 247731',0.00,0.00,0.00,2184.39,0.00,'2021-12-22 08:03:20','',''),(2342495,'5','104',NULL,395,'Sale Id shift 247731',753614.55,0.00,0.00,0.00,0.00,'2021-12-22 08:03:20','',''),(2342502,'5','104',NULL,394,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,4389000.00,26600.00,0.00,0.00,'2021-12-22 08:03:38','',''),(2350536,'5','104',NULL,394,'Reception corrector for bridging 128451',0.00,0.00,0.00,26600.00,0.00,'2021-12-23 07:43:22','',''),(2350537,'5','104','895',394,'Received from bridging 128451',0.00,0.00,26600.00,0.00,0.00,'2021-12-23 07:43:22','',''),(2352170,'5','104','895',394,'Sale Id shift 248126',0.00,0.00,0.00,2987.55,0.00,'2021-12-23 10:01:14','',''),(2352171,'5','104','895',394,'Sale Id shift 248126',0.00,0.00,0.00,2490.48,0.00,'2021-12-23 10:01:14','',''),(2352172,'5','104','897',395,'Sale Id shift 248126',0.00,0.00,0.00,1288.16,0.00,'2021-12-23 10:01:14','',''),(2352173,'5','104','895',394,'Sale Id shift 248126',0.00,0.00,0.00,3367.35,0.00,'2021-12-23 10:01:14','',''),(2352174,'5','104',NULL,394,'Sale Id shift 248126',1459487.70,0.00,0.00,0.00,0.00,'2021-12-23 10:01:14','',''),(2352175,'5','104',NULL,395,'Sale Id shift 248126',444415.20,0.00,0.00,0.00,0.00,'2021-12-23 10:01:14','',''),(2359757,'5','104','895',394,'Sale Id shift 248282',0.00,0.00,0.00,3663.60,0.00,'2021-12-24 08:14:28','',''),(2359758,'5','104','895',394,'Sale Id shift 248282',0.00,0.00,0.00,4369.70,0.00,'2021-12-24 08:14:28','',''),(2359759,'5','104','897',395,'Sale Id shift 248282',0.00,0.00,0.00,1665.27,0.00,'2021-12-24 08:14:28','',''),(2359760,'5','104','895',394,'Sale Id shift 248282',0.00,0.00,0.00,4774.09,0.00,'2021-12-24 08:14:28','',''),(2359761,'5','104',NULL,394,'Sale Id shift 248282',2113219.35,0.00,0.00,0.00,0.00,'2021-12-24 08:14:28','',''),(2359762,'5','104',NULL,395,'Sale Id shift 248282',574518.15,0.00,0.00,0.00,0.00,'2021-12-24 08:14:28','',''),(2367890,'5','104','895',394,'Sale Id shift 248464',0.00,0.00,0.00,1673.54,0.00,'2021-12-25 05:02:58','',''),(2367891,'5','104','895',394,'Sale Id shift 248464',0.00,0.00,0.00,1614.79,0.00,'2021-12-25 05:02:58','',''),(2367892,'5','104','897',395,'Sale Id shift 248464',0.00,0.00,0.00,796.86,0.00,'2021-12-25 05:02:58','',''),(2367893,'5','104','895',394,'Sale Id shift 248464',0.00,0.00,0.00,1786.35,0.00,'2021-12-25 05:02:58','',''),(2367894,'5','104',NULL,394,'Sale Id shift 248464',837322.20,0.00,0.00,0.00,0.00,'2021-12-25 05:02:58','',''),(2367895,'5','104',NULL,395,'Sale Id shift 248464',274916.70,0.00,0.00,0.00,0.00,'2021-12-25 05:02:58','',''),(2375169,'5','104','897',395,'Sale Id shift 248712',0.00,0.00,0.00,558.96,0.00,'2021-12-26 07:25:44','',''),(2375170,'5','104',NULL,395,'Sale Id shift 248712',192841.20,0.00,0.00,0.00,0.00,'2021-12-26 07:25:44','',''),(2383851,'5','104','897',395,'Sale Id shift 248953',0.00,0.00,0.00,457.22,0.00,'2021-12-27 12:16:23','',''),(2383852,'5','104',NULL,395,'Sale Id shift 248953',157740.90,0.00,0.00,0.00,0.00,'2021-12-27 12:16:23','',''),(2387556,'5','104','897',395,'Sale Id shift 249253',0.00,0.00,0.00,512.27,0.00,'2021-12-28 08:19:41','',''),(2387557,'5','104',NULL,395,'Sale Id shift 249253',176733.15,0.00,0.00,0.00,0.00,'2021-12-28 08:19:41','',''),(2394675,'5','104','897',395,'Sale Id shift 249437',0.00,0.00,0.00,415.12,0.00,'2021-12-29 08:44:11','',''),(2394676,'5','104',NULL,395,'Sale Id shift 249437',143216.40,0.00,0.00,0.00,0.00,'2021-12-29 08:44:11','',''),(2401702,'5','104','897',395,'Sale Id shift 249684',0.00,0.00,0.00,309.72,0.00,'2021-12-30 08:58:57','',''),(2401703,'5','104',NULL,395,'Sale Id shift 249684',106853.40,0.00,0.00,0.00,0.00,'2021-12-30 08:58:57','',''),(2415846,'5','104',NULL,394,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,6520800.00,39520.00,0.00,0.00,'2022-01-01 08:43:59','',''),(2415848,'5','104',NULL,394,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,8085.00,49.00,0.00,0.00,'2022-01-01 08:44:12','',''),(2419564,'5','104',NULL,394,'Reception corrector for bridging 129399',0.00,0.00,0.00,25920.00,0.00,'2022-01-01 16:03:46','',''),(2419565,'5','104','895',394,'Received from bridging 129399',0.00,0.00,25920.00,0.00,0.00,'2022-01-01 16:03:46','',''),(2419569,'5','104',NULL,394,'Reception corrector for bridging 129400',0.00,0.00,0.00,13600.00,0.00,'2022-01-01 16:04:05','',''),(2419570,'5','104','896',394,'Received from bridging 129400',0.00,0.00,13600.00,0.00,0.00,'2022-01-01 16:04:05','',''),(2419576,'5','104',NULL,394,'Reception corrector for bridging 129403',0.00,0.00,0.00,49.00,0.00,'2022-01-01 16:04:18','',''),(2419577,'5','104','895',394,'Received from bridging 129403',0.00,0.00,49.00,0.00,0.00,'2022-01-01 16:04:18','',''),(2420482,'5','104','896',394,'Sale Id shift 250307',0.00,0.00,0.00,541.78,0.00,'2022-01-01 20:42:41','',''),(2420483,'5','104','896',394,'Sale Id shift 250307',0.00,0.00,0.00,521.08,0.00,'2022-01-01 20:42:41','',''),(2420484,'5','104',NULL,394,'Sale Id shift 250307',175371.90,0.00,0.00,0.00,0.00,'2022-01-01 20:42:41','',''),(2422063,'5','104','895',394,'Sale Id shift 250533',0.00,0.00,0.00,2109.65,0.00,'2022-01-02 09:31:33','',''),(2422064,'5','104','896',394,'Sale Id shift 250533',0.00,0.00,0.00,1340.76,0.00,'2022-01-02 09:31:33','',''),(2422065,'5','104','896',394,'Sale Id shift 250533',0.00,0.00,0.00,2428.30,0.00,'2022-01-02 09:31:33','',''),(2422066,'5','104','895',394,'Sale Id shift 250533',0.00,0.00,0.00,2473.32,0.00,'2022-01-02 09:31:33','',''),(2422067,'5','104',NULL,394,'Sale Id shift 250533',1378084.95,0.00,0.00,0.00,0.00,'2022-01-02 09:31:33','',''),(2432173,'5','104','895',394,'Sale Id shift 250666',0.00,0.00,0.00,2346.92,0.00,'2022-01-03 16:59:14','',''),(2432174,'5','104','896',394,'Sale Id shift 250666',0.00,0.00,0.00,2367.12,0.00,'2022-01-03 16:59:14','',''),(2432175,'5','104','896',394,'Sale Id shift 250666',0.00,0.00,0.00,3782.25,0.00,'2022-01-03 16:59:14','',''),(2432176,'5','104','895',394,'Sale Id shift 250666',0.00,0.00,0.00,2052.64,0.00,'2022-01-03 16:59:14','',''),(2432177,'5','104',NULL,394,'Sale Id shift 250666',1740573.45,0.00,0.00,0.00,0.00,'2022-01-03 16:59:14','',''),(2434053,'5','104','895',394,'Sale Id shift 250956',0.00,0.00,0.00,5068.15,0.00,'2022-01-04 08:28:00','',''),(2434054,'5','104','896',394,'Sale Id shift 250956',0.00,0.00,0.00,1231.17,0.00,'2022-01-04 08:28:00','',''),(2434055,'5','104','896',394,'Sale Id shift 250956',0.00,0.00,0.00,1392.38,0.00,'2022-01-04 08:28:00','',''),(2434056,'5','104','895',394,'Sale Id shift 250956',0.00,0.00,0.00,5007.39,0.00,'2022-01-04 08:28:00','',''),(2434057,'5','104',NULL,394,'Sale Id shift 250956',2095349.85,0.00,0.00,0.00,0.00,'2022-01-04 08:28:00','',''),(2443067,'5','104','895',394,'Sale Id shift 251233',0.00,0.00,0.00,176.78,0.00,'2022-01-05 11:38:10','',''),(2443068,'5','104','895',394,'Sale Id shift 251233',0.00,0.00,0.00,4025.21,0.00,'2022-01-05 11:38:10','',''),(2443069,'5','104','895',394,'Sale Id shift 251233',0.00,0.00,0.00,2550.32,0.00,'2022-01-05 11:38:10','',''),(2443070,'5','104',NULL,394,'Sale Id shift 251233',1114131.15,0.00,0.00,0.00,0.00,'2022-01-05 11:38:10','',''),(2443086,'5','104',NULL,394,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7359000.00,44600.00,0.00,0.00,'2022-01-05 11:39:37','',''),(2448036,'5','104',NULL,394,'Reception corrector for bridging 129904',0.00,0.00,0.00,14870.00,0.00,'2022-01-06 00:51:31','',''),(2448037,'5','104','896',394,'Received from bridging 129904',0.00,0.00,14870.00,0.00,0.00,'2022-01-06 00:51:31','',''),(2448038,'5','104',NULL,394,'Reception corrector for bridging 129903',0.00,0.00,0.00,29730.00,0.00,'2022-01-06 00:51:41','',''),(2448039,'5','104','895',394,'Received from bridging 129903',0.00,0.00,29730.00,0.00,0.00,'2022-01-06 00:51:41','',''),(2450272,'5','104','895',394,'Sale Id shift 251485',0.00,0.00,0.00,4744.21,0.00,'2022-01-06 10:39:11','',''),(2450273,'5','104','896',394,'Sale Id shift 251485',0.00,0.00,0.00,3524.64,0.00,'2022-01-06 10:39:11','',''),(2450274,'5','104','896',394,'Sale Id shift 251485',0.00,0.00,0.00,5350.64,0.00,'2022-01-06 10:39:11','',''),(2450275,'5','104','895',394,'Sale Id shift 251485',0.00,0.00,0.00,1223.23,0.00,'2022-01-06 10:39:11','',''),(2450276,'5','104',NULL,394,'Sale Id shift 251485',2449048.80,0.00,0.00,0.00,0.00,'2022-01-06 10:39:11','',''),(2458513,'5','104','895',394,'Sale Id shift 251613',0.00,0.00,0.00,2626.03,0.00,'2022-01-07 11:40:24','',''),(2458514,'5','104','896',394,'Sale Id shift 251613',0.00,0.00,0.00,2901.29,0.00,'2022-01-07 11:40:24','',''),(2458515,'5','104','895',394,'Sale Id shift 251613',0.00,0.00,0.00,2891.55,0.00,'2022-01-07 11:40:24','',''),(2458516,'5','104',NULL,394,'Sale Id shift 251613',1389113.55,0.00,0.00,0.00,0.00,'2022-01-07 11:40:24','',''),(2466978,'5','104','895',394,'Sale Id shift 251873',0.00,0.00,0.00,4801.23,0.00,'2022-01-08 13:25:10','',''),(2466979,'5','104','896',394,'Sale Id shift 251873',0.00,0.00,0.00,1517.45,0.00,'2022-01-08 13:25:10','',''),(2466980,'5','104','896',394,'Sale Id shift 251873',0.00,0.00,0.00,1620.29,0.00,'2022-01-08 13:25:10','',''),(2466981,'5','104','895',394,'Sale Id shift 251873',0.00,0.00,0.00,3028.10,0.00,'2022-01-08 13:25:10','',''),(2466982,'5','104',NULL,394,'Sale Id shift 251873',1809566.55,0.00,0.00,0.00,0.00,'2022-01-08 13:25:10','',''),(2472941,'5','104','895',394,'Sale Id shift 252213',0.00,0.00,0.00,4304.44,0.00,'2022-01-09 09:58:27','',''),(2472942,'5','104','895',394,'Sale Id shift 252213',0.00,0.00,0.00,2829.58,0.00,'2022-01-09 09:58:27','',''),(2472943,'5','104',NULL,394,'Sale Id shift 252213',1177113.30,0.00,0.00,0.00,0.00,'2022-01-09 09:58:27','',''),(2486062,'5','104','895',394,'Sale Id shift 252566',0.00,0.00,0.00,1183.23,0.00,'2022-01-10 20:35:06','',''),(2486063,'5','104','895',394,'Sale Id shift 252566',0.00,0.00,0.00,2031.11,0.00,'2022-01-10 20:35:06','',''),(2486064,'5','104',NULL,394,'Sale Id shift 252566',530366.10,0.00,0.00,0.00,0.00,'2022-01-10 20:35:06','',''),(2490539,'5','104',NULL,394,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7278810.00,44114.00,0.00,0.00,'2022-01-11 14:39:06','',''),(2493980,'5','104',NULL,394,'Reception corrector for bridging 130544',0.00,0.00,0.00,22614.00,0.00,'2022-01-12 04:28:46','',''),(2493981,'5','104','896',394,'Received from bridging 130544',0.00,0.00,22614.00,0.00,0.00,'2022-01-12 04:28:46','',''),(2493982,'5','104',NULL,394,'Reception corrector for bridging 130543',0.00,0.00,0.00,21500.00,0.00,'2022-01-12 04:28:57','',''),(2493983,'5','104','895',394,'Received from bridging 130543',0.00,0.00,21500.00,0.00,0.00,'2022-01-12 04:28:57','',''),(2502713,'5','104','895',394,'Sale Id shift 252852',0.00,0.00,0.00,3691.73,0.00,'2022-01-13 09:10:38','',''),(2502714,'5','104','896',394,'Sale Id shift 252852',0.00,0.00,0.00,1705.10,0.00,'2022-01-13 09:10:38','',''),(2502715,'5','104','896',394,'Sale Id shift 252852',0.00,0.00,0.00,1390.62,0.00,'2022-01-13 09:10:38','',''),(2502716,'5','104','895',394,'Sale Id shift 252852',0.00,0.00,0.00,3237.12,0.00,'2022-01-13 09:10:38','',''),(2502717,'5','104',NULL,394,'Sale Id shift 252852',1654054.05,0.00,0.00,0.00,0.00,'2022-01-13 09:10:38','',''),(2503342,'5','104','895',394,'Sale Id shift 253271',0.00,0.00,0.00,5214.65,0.00,'2022-01-13 10:06:50','',''),(2503343,'5','104','896',394,'Sale Id shift 253271',0.00,0.00,0.00,893.76,0.00,'2022-01-13 10:06:50','',''),(2503344,'5','104','895',394,'Sale Id shift 253271',0.00,0.00,0.00,4242.29,0.00,'2022-01-13 10:06:50','',''),(2503345,'5','104',NULL,394,'Sale Id shift 253271',1707865.50,0.00,0.00,0.00,0.00,'2022-01-13 10:06:50','',''),(2510996,'5','104','895',394,'Sale Id shift 253289',0.00,0.00,0.00,124.22,0.00,'2022-01-14 09:51:40','',''),(2510997,'5','104','895',394,'Sale Id shift 253289',0.00,0.00,0.00,2854.50,0.00,'2022-01-14 09:51:40','',''),(2510998,'5','104','896',394,'Sale Id shift 253289',0.00,0.00,0.00,2633.32,0.00,'2022-01-14 09:51:40','',''),(2510999,'5','104','896',394,'Sale Id shift 253289',0.00,0.00,0.00,2764.65,0.00,'2022-01-14 09:51:40','',''),(2511000,'5','104','895',394,'Sale Id shift 253289',0.00,0.00,0.00,1959.27,0.00,'2022-01-14 09:51:40','',''),(2511001,'5','104',NULL,394,'Sale Id shift 253289',1705433.40,0.00,0.00,0.00,0.00,'2022-01-14 09:51:40','',''),(2516460,'5','104',NULL,394,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,4250400.00,25760.00,0.00,0.00,'2022-01-14 22:05:30','',''),(2516461,'5','104','896',394,'Sale Id shift 253554',0.00,0.00,0.00,5105.81,0.00,'2022-01-14 22:05:48','',''),(2516462,'5','104','896',394,'Sale Id shift 253554',0.00,0.00,0.00,5165.23,0.00,'2022-01-14 22:05:48','',''),(2516463,'5','104',NULL,394,'Sale Id shift 253554',1694721.60,0.00,0.00,0.00,0.00,'2022-01-14 22:05:48','',''),(2516721,'5','104',NULL,394,'Reception corrector for bridging 130944',0.00,0.00,0.00,25760.00,0.00,'2022-01-15 06:58:21','',''),(2516722,'5','104','895',394,'Received from bridging 130944',0.00,0.00,25760.00,0.00,0.00,'2022-01-15 06:58:21','',''),(2525695,'5','104','895',394,'Sale Id shift 253777',0.00,0.00,0.00,2986.38,0.00,'2022-01-16 06:18:10','',''),(2525696,'5','104','896',394,'Sale Id shift 253777',0.00,0.00,0.00,1490.87,0.00,'2022-01-16 06:18:10','',''),(2525697,'5','104','896',394,'Sale Id shift 253777',0.00,0.00,0.00,1489.04,0.00,'2022-01-16 06:18:10','',''),(2525698,'5','104','895',394,'Sale Id shift 253777',0.00,0.00,0.00,2568.58,0.00,'2022-01-16 06:18:10','',''),(2525699,'5','104',NULL,394,'Sale Id shift 253777',1408253.55,0.00,0.00,0.00,0.00,'2022-01-16 06:18:10','',''),(2534023,'5','104','895',394,'Sale Id shift 254106',0.00,0.00,0.00,5920.25,0.00,'2022-01-17 05:25:34','',''),(2534024,'5','104','895',394,'Sale Id shift 254106',0.00,0.00,0.00,2878.97,0.00,'2022-01-17 05:25:34','',''),(2534025,'5','104',NULL,394,'Sale Id shift 254106',1451871.30,0.00,0.00,0.00,0.00,'2022-01-17 05:25:34','',''),(2540971,'5','104','895',394,'Sale Id shift 254282',0.00,0.00,0.00,7341.08,0.00,'2022-01-18 06:18:08','',''),(2540972,'5','104','895',394,'Sale Id shift 254282',0.00,0.00,0.00,2720.09,0.00,'2022-01-18 06:18:08','',''),(2540973,'5','104',NULL,394,'Sale Id shift 254282',1660093.05,0.00,0.00,0.00,0.00,'2022-01-18 06:18:08','',''),(2551326,'5','104','895',394,'Sale Id shift 254532',0.00,0.00,0.00,1341.75,0.00,'2022-01-19 11:59:47','',''),(2551327,'5','104',NULL,394,'Sale Id shift 254532',221388.75,0.00,0.00,0.00,0.00,'2022-01-19 11:59:47','',''),(2566189,'5','104',NULL,394,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,5115000.00,31000.00,0.00,0.00,'2022-01-21 09:57:42','',''),(2566817,'5','104',NULL,394,'Reception corrector for bridging 131572',0.00,0.00,0.00,31000.00,0.00,'2022-01-21 10:48:10','',''),(2566818,'5','104','896',394,'Received from bridging 131572',0.00,0.00,31000.00,0.00,0.00,'2022-01-21 10:48:10','',''),(2574089,'5','104','896',394,'Sale Id shift 255096',0.00,0.00,0.00,903.56,0.00,'2022-01-22 09:25:37','',''),(2574090,'5','104','896',394,'Sale Id shift 255096',0.00,0.00,0.00,1009.59,0.00,'2022-01-22 09:25:37','',''),(2574091,'5','104',NULL,394,'Sale Id shift 255096',315669.75,0.00,0.00,0.00,0.00,'2022-01-22 09:25:37','',''),(2579634,'5','104','896',394,'Sale Id shift 255573',0.00,0.00,0.00,4515.33,0.00,'2022-01-22 16:47:59','',''),(2579635,'5','104','896',394,'Sale Id shift 255573',0.00,0.00,0.00,5282.29,0.00,'2022-01-22 16:47:59','',''),(2579636,'5','104',NULL,394,'Sale Id shift 255573',1616607.30,0.00,0.00,0.00,0.00,'2022-01-22 16:47:59','',''),(2582834,'5','104','896',394,'Sale Id shift 255640',0.00,0.00,0.00,4046.92,0.00,'2022-01-23 09:02:44','',''),(2582835,'5','104','896',394,'Sale Id shift 255640',0.00,0.00,0.00,3547.47,0.00,'2022-01-23 09:02:44','',''),(2582836,'5','104',NULL,394,'Sale Id shift 255640',1253074.35,0.00,0.00,0.00,0.00,'2022-01-23 09:02:44','',''),(2591220,'5','104','896',394,'Sale Id shift 255809',0.00,0.00,0.00,4251.65,0.00,'2022-01-24 09:38:48','',''),(2591221,'5','104','896',394,'Sale Id shift 255809',0.00,0.00,0.00,3295.11,0.00,'2022-01-24 09:38:48','',''),(2591222,'5','104',NULL,394,'Sale Id shift 255809',1245215.40,0.00,0.00,0.00,0.00,'2022-01-24 09:38:48','',''),(2598121,'5','104','896',394,'Sale Id shift 256022',0.00,0.00,0.00,2199.07,0.00,'2022-01-25 09:09:26','',''),(2598122,'5','104','896',394,'Sale Id shift 256022',0.00,0.00,0.00,2311.04,0.00,'2022-01-25 09:09:26','',''),(2598123,'5','104',NULL,394,'Sale Id shift 256022',744168.15,0.00,0.00,0.00,0.00,'2022-01-25 09:09:26','',''),(2612849,'5','104',NULL,394,'Balance from closing inventory values 2021-11-31 23:59:59',75492847.88,75399438.00,918100.00,918292.56,0.00,'2021-11-30 23:59:59','',''),(2612854,'5','104',NULL,396,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2612958,'5','104',NULL,395,'Balance from closing inventory values 2021-11-31 23:59:59',3699110.70,10565250.00,61300.00,41372.06,0.00,'2021-11-30 23:59:59','',''),(2613284,'5','104','898',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613673,'5','104','896',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,162794.00,162553.01,0.00,'2021-11-30 23:59:59','',''),(2613835,'5','104','897',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,30650.00,10722.06,0.00,'2021-11-30 23:59:59','',''),(2613965,'5','104','895',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,298811.00,298077.02,0.00,'2021-11-30 23:59:59','',''),(2640472,'5','104',NULL,394,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,3762000.00,22800.00,0.00,0.00,'2022-01-29 21:20:57','',''),(2642928,'5','104',NULL,394,'Reception corrector for bridging 132601',0.00,0.00,0.00,22800.00,0.00,'2022-01-30 10:22:49','',''),(2642929,'5','104','896',394,'Received from bridging 132601',0.00,0.00,22800.00,0.00,0.00,'2022-01-30 10:22:49','',''),(2642930,'5','104','896',394,'Sale Id shift 257405',0.00,0.00,0.00,895.13,0.00,'2022-01-31 09:12:02','',''),(2642931,'5','104','896',394,'Sale Id shift 257405',0.00,0.00,0.00,720.77,0.00,'2022-01-31 09:12:02','',''),(2642932,'5','104',NULL,394,'Sale Id shift 257405',266623.50,0.00,0.00,0.00,0.00,'2022-01-31 09:12:02','',''),(2642933,'5','104','896',394,'Sale Id shift 257406',0.00,0.00,0.00,5146.50,0.00,'2022-01-31 16:54:49','',''),(2642934,'5','104','896',394,'Sale Id shift 257406',0.00,0.00,0.00,4186.46,0.00,'2022-01-31 16:54:49','',''),(2642935,'5','104',NULL,394,'Sale Id shift 257406',1539938.40,0.00,0.00,0.00,0.00,'2022-01-31 16:54:49','',''),(2642936,'5','104','896',394,'Sale Id shift 257407',0.00,0.00,0.00,4727.08,0.00,'2022-02-01 09:08:07','',''),(2642937,'5','104','896',394,'Sale Id shift 257407',0.00,0.00,0.00,4896.11,0.00,'2022-02-01 09:08:07','',''),(2642938,'5','104',NULL,394,'Sale Id shift 257407',1587826.35,0.00,0.00,0.00,0.00,'2022-02-01 09:08:07','',''),(2642939,'5','104','896',394,'Sale Id shift 257408',0.00,0.00,0.00,2364.00,0.00,'2022-02-03 11:46:22','',''),(2642940,'5','104',NULL,394,'Sale Id shift 257408',390060.00,0.00,0.00,0.00,0.00,'2022-02-03 11:46:22','',''),(2642941,'5','104',NULL,394,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,4950000.00,30000.00,0.00,0.00,'2022-02-03 11:46:37','',''),(2642942,'5','104',NULL,394,'Reception corrector for bridging 132602',0.00,0.00,0.00,30000.00,0.00,'2022-02-03 14:04:15','',''),(2642943,'5','104','896',394,'Received from bridging 132602',0.00,0.00,30000.00,0.00,0.00,'2022-02-03 14:04:15','',''),(2642944,'5','104','896',394,'Sale Id shift 257409',0.00,0.00,0.00,1148.41,0.00,'2022-02-03 16:15:42','',''),(2642945,'5','104','896',394,'Sale Id shift 257409',0.00,0.00,0.00,254.91,0.00,'2022-02-03 16:15:42','',''),(2642946,'5','104',NULL,394,'Sale Id shift 257409',231547.80,0.00,0.00,0.00,0.00,'2022-02-03 16:15:42','',''),(2642947,'5','104',NULL,394,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,3052500.00,18500.00,0.00,0.00,'2022-02-03 18:28:27','',''),(2642948,'5','104',NULL,394,'Reception corrector for bridging 132603',0.00,0.00,0.00,18500.00,0.00,'2022-02-03 21:58:12','',''),(2642949,'5','104','895',394,'Received from bridging 132603',0.00,0.00,18500.00,0.00,0.00,'2022-02-03 21:58:12','',''),(2642950,'5','104','895',394,'Sale Id shift 257410',0.00,0.00,0.00,1597.57,0.00,'2022-02-04 09:26:24','',''),(2642951,'5','104','896',394,'Sale Id shift 257410',0.00,0.00,0.00,2815.54,0.00,'2022-02-04 09:26:24','',''),(2642952,'5','104','896',394,'Sale Id shift 257410',0.00,0.00,0.00,4621.35,0.00,'2022-02-04 09:26:24','',''),(2642953,'5','104',NULL,394,'Sale Id shift 257410',1490685.90,0.00,0.00,0.00,0.00,'2022-02-04 09:26:24','',''),(2642954,'5','104','895',394,'Sale Id shift 257411',0.00,0.00,0.00,33.81,0.00,'2022-02-05 05:30:22','',''),(2642955,'5','104','895',394,'Sale Id shift 257411',0.00,0.00,0.00,261.35,0.00,'2022-02-05 05:30:22','',''),(2642956,'5','104','896',394,'Sale Id shift 257411',0.00,0.00,0.00,5188.89,0.00,'2022-02-05 05:30:22','',''),(2642957,'5','104','896',394,'Sale Id shift 257411',0.00,0.00,0.00,2838.09,0.00,'2022-02-05 05:30:22','',''),(2642958,'5','104','895',394,'Sale Id shift 257411',0.00,0.00,0.00,724.84,0.00,'2022-02-05 05:30:22','',''),(2642959,'5','104',NULL,394,'Sale Id shift 257411',1492751.70,0.00,0.00,0.00,0.00,'2022-02-05 05:30:22','',''),(2642960,'5','104','896',394,'Sale Id shift 257412',0.00,0.00,0.00,4117.13,0.00,'2022-02-06 05:25:29','',''),(2642961,'5','104','896',394,'Sale Id shift 257412',0.00,0.00,0.00,3995.50,0.00,'2022-02-06 05:25:29','',''),(2642962,'5','104',NULL,394,'Sale Id shift 257412',1338583.95,0.00,0.00,0.00,0.00,'2022-02-06 05:25:29','',''),(2642963,'5','104','895',394,'Sale Id shift 257415',0.00,0.00,0.00,6706.11,0.00,'2022-02-08 13:16:02','',''),(2642964,'5','104','895',394,'Sale Id shift 257415',0.00,0.00,0.00,1727.12,0.00,'2022-02-08 13:16:02','',''),(2642965,'5','104',NULL,394,'Sale Id shift 257415',1391482.95,0.00,0.00,0.00,0.00,'2022-02-08 13:16:02','',''),(2642966,'5','104','895',394,'Sale Id shift 257416',0.00,0.00,0.00,2773.82,0.00,'2022-02-08 14:05:59','',''),(2642967,'5','104','896',394,'Sale Id shift 257416',0.00,0.00,0.00,2365.49,0.00,'2022-02-08 14:05:59','',''),(2642968,'5','104','896',394,'Sale Id shift 257416',0.00,0.00,0.00,2692.35,0.00,'2022-02-08 14:05:59','',''),(2642969,'5','104','895',394,'Sale Id shift 257416',0.00,0.00,0.00,1987.26,0.00,'2022-02-08 14:05:59','',''),(2642970,'5','104',NULL,394,'Sale Id shift 257416',1620121.80,0.00,0.00,0.00,0.00,'2022-02-08 14:05:59','',''),(2642971,'5','104','895',394,'Sale Id shift 257417',0.00,0.00,0.00,2555.03,0.00,'2022-02-09 09:11:03','',''),(2642972,'5','104',NULL,394,'Sale Id shift 257417',421579.95,0.00,0.00,0.00,0.00,'2022-02-09 09:11:03','',''),(2642973,'5','104',NULL,394,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,3712500.00,22500.00,0.00,0.00,'2022-02-12 15:38:15','',''),(2642974,'5','104',NULL,394,'Reception corrector for bridging 132604',0.00,0.00,0.00,22500.00,0.00,'2022-02-12 18:55:07','',''),(2642975,'5','104','896',394,'Received from bridging 132604',0.00,0.00,22500.00,0.00,0.00,'2022-02-12 18:55:07','',''),(2642976,'5','104','896',394,'Sale Id shift 257420',0.00,0.00,0.00,1588.13,0.00,'2022-02-13 09:03:35','',''),(2642977,'5','104','896',394,'Sale Id shift 257420',0.00,0.00,0.00,1089.08,0.00,'2022-02-13 09:03:35','',''),(2642978,'5','104',NULL,394,'Sale Id shift 257420',441739.65,0.00,0.00,0.00,0.00,'2022-02-13 09:03:35','',''),(2642979,'5','104','896',394,'Sale Id shift 257421',0.00,0.00,0.00,7113.26,0.00,'2022-02-13 13:29:08','',''),(2642980,'5','104',NULL,394,'Sale Id shift 257421',1173687.90,0.00,0.00,0.00,0.00,'2022-02-13 13:29:08','',''),(2642981,'5','104','896',394,'Sale Id shift 257422',0.00,0.00,0.00,4496.53,0.00,'2022-02-14 08:59:48','',''),(2642982,'5','104','896',394,'Sale Id shift 257422',0.00,0.00,0.00,5540.28,0.00,'2022-02-14 08:59:48','',''),(2642983,'5','104',NULL,394,'Sale Id shift 257422',1656073.65,0.00,0.00,0.00,0.00,'2022-02-14 08:59:48','',''),(2642984,'5','104','896',0,'Tank level zero out for dipping',0.00,0.00,0.00,2704.72,0.00,'2022-02-16 12:31:58','',''),(2642985,'5','104','896',0,'Inventory adjustment from tank dipping to 2900',0.00,0.00,2900.00,0.00,0.00,'2022-02-16 12:31:58','',''),(2642986,'5','104','896',394,'Sale Id shift 257423',0.00,0.00,0.00,1284.12,0.00,'2022-02-16 18:00:17','',''),(2642987,'5','104','896',394,'Sale Id shift 257423',0.00,0.00,0.00,1514.31,0.00,'2022-02-16 18:00:17','',''),(2642988,'5','104',NULL,394,'Sale Id shift 257423',461740.95,0.00,0.00,0.00,0.00,'2022-02-16 18:00:17','',''),(2642989,'5','104',NULL,394,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-02-21 17:57:18','',''),(2642990,'5','104',NULL,394,'Reception corrector for bridging 132606',0.00,0.00,0.00,17000.00,0.00,'2022-02-21 18:25:34','',''),(2642991,'5','104','896',394,'Received from bridging 132606',0.00,0.00,17000.00,0.00,0.00,'2022-02-21 18:25:34','',''),(2642992,'5','104',NULL,394,'Reception corrector for bridging 132605',0.00,0.00,0.00,33000.00,0.00,'2022-02-21 18:25:42','',''),(2642993,'5','104','895',394,'Received from bridging 132605',0.00,0.00,33000.00,0.00,0.00,'2022-02-21 18:25:42','',''),(2642994,'5','104','895',394,'Sale Id shift 257430',0.00,0.00,0.00,2485.58,0.00,'2022-02-22 09:23:37','',''),(2642995,'5','104','895',394,'Sale Id shift 257430',0.00,0.00,0.00,2152.06,0.00,'2022-02-22 09:23:37','',''),(2642996,'5','104',NULL,394,'Sale Id shift 257430',765210.60,0.00,0.00,0.00,0.00,'2022-02-22 09:23:37','',''),(2642997,'5','104','895',394,'Sale Id shift 257431',0.00,0.00,0.00,4666.72,0.00,'2022-02-23 09:10:50','',''),(2642998,'5','104','895',394,'Sale Id shift 257431',0.00,0.00,0.00,5588.30,0.00,'2022-02-23 09:10:50','',''),(2642999,'5','104',NULL,394,'Sale Id shift 257431',1692078.30,0.00,0.00,0.00,0.00,'2022-02-23 09:10:50','',''),(2643000,'5','104','895',394,'Sale Id shift 257432',0.00,0.00,0.00,9235.78,0.00,'2022-02-24 13:02:05','',''),(2643001,'5','104','896',394,'Sale Id shift 257432',0.00,0.00,0.00,95.11,0.00,'2022-02-24 13:02:05','',''),(2643002,'5','104','896',394,'Sale Id shift 257432',0.00,0.00,0.00,2987.19,0.00,'2022-02-24 13:02:05','',''),(2643003,'5','104','895',394,'Sale Id shift 257432',0.00,0.00,0.00,5230.30,0.00,'2022-02-24 13:02:05','',''),(2643004,'5','104',NULL,394,'Sale Id shift 257432',2895482.70,0.00,0.00,0.00,0.00,'2022-02-24 13:02:05','',''),(2643005,'5','104',NULL,394,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,2227500.00,13500.00,0.00,0.00,'2022-02-25 09:38:21','',''),(2643006,'5','104',NULL,394,'Reception corrector for bridging 132607',0.00,0.00,0.00,13500.00,0.00,'2022-02-25 16:44:30','',''),(2643007,'5','104','895',394,'Received from bridging 132607',0.00,0.00,13500.00,0.00,0.00,'2022-02-25 16:44:30','',''),(2643008,'5','104','895',394,'Sale Id shift 257433',0.00,0.00,0.00,6401.12,0.00,'2022-02-26 09:47:44','',''),(2643009,'5','104','896',394,'Sale Id shift 257433',0.00,0.00,0.00,5020.65,0.00,'2022-02-26 09:47:44','',''),(2643010,'5','104',NULL,394,'Sale Id shift 257433',1884592.05,0.00,0.00,0.00,0.00,'2022-02-26 09:47:44','',''),(2643011,'5','104','895',394,'Sale Id shift 257434',0.00,0.00,0.00,1365.94,0.00,'2022-02-26 21:55:57','',''),(2643012,'5','104','896',394,'Sale Id shift 257434',0.00,0.00,0.00,5156.67,0.00,'2022-02-26 21:55:57','',''),(2643013,'5','104','895',394,'Sale Id shift 257434',0.00,0.00,0.00,5160.67,0.00,'2022-02-26 21:55:57','',''),(2643014,'5','104',NULL,394,'Sale Id shift 257434',1927741.20,0.00,0.00,0.00,0.00,'2022-02-26 21:55:57','',''),(2643015,'5','104',NULL,394,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-02-27 09:03:54','',''),(2643016,'5','104',NULL,394,'Reception corrector for bridging 132609',0.00,0.00,0.00,13500.00,0.00,'2022-02-27 11:13:44','',''),(2643017,'5','104','896',394,'Received from bridging 132609',0.00,0.00,13500.00,0.00,0.00,'2022-02-27 11:13:44','',''),(2643018,'5','104',NULL,394,'Reception corrector for bridging 132608',0.00,0.00,0.00,26500.00,0.00,'2022-02-27 11:13:57','',''),(2643019,'5','104','895',394,'Received from bridging 132608',0.00,0.00,26500.00,0.00,0.00,'2022-02-27 11:13:57','',''),(2643020,'5','104','895',394,'Sale Id shift 257435',0.00,0.00,0.00,4050.85,0.00,'2022-02-27 13:42:38','',''),(2643021,'5','104','896',394,'Sale Id shift 257435',0.00,0.00,0.00,2.43,0.00,'2022-02-27 13:42:38','',''),(2643022,'5','104','896',394,'Sale Id shift 257435',0.00,0.00,0.00,4941.33,0.00,'2022-02-27 13:42:38','',''),(2643023,'5','104','895',394,'Sale Id shift 257435',0.00,0.00,0.00,4072.22,0.00,'2022-02-27 13:42:38','',''),(2643024,'5','104',NULL,394,'Sale Id shift 257435',2156026.95,0.00,0.00,0.00,0.00,'2022-02-27 13:42:38','',''),(2643025,'5','104','895',394,'Sale Id shift 257436',0.00,0.00,0.00,2839.94,0.00,'2022-02-28 08:48:37','',''),(2643026,'5','104','896',394,'Sale Id shift 257436',0.00,0.00,0.00,4246.75,0.00,'2022-02-28 08:48:37','',''),(2643027,'5','104','896',394,'Sale Id shift 257436',0.00,0.00,0.00,314.07,0.00,'2022-02-28 08:48:37','',''),(2643028,'5','104','895',394,'Sale Id shift 257436',0.00,0.00,0.00,6219.65,0.00,'2022-02-28 08:48:37','',''),(2643029,'5','104',NULL,394,'Sale Id shift 257436',2247367.65,0.00,0.00,0.00,0.00,'2022-02-28 08:48:37','',''),(2643030,'5','104','895',394,'Sale Id shift 257437',0.00,0.00,0.00,601.96,0.00,'2022-03-01 09:24:32','',''),(2643031,'5','104','896',394,'Sale Id shift 257437',0.00,0.00,0.00,3299.49,0.00,'2022-03-01 09:24:32','',''),(2643032,'5','104','896',394,'Sale Id shift 257437',0.00,0.00,0.00,4160.08,0.00,'2022-03-01 09:24:32','',''),(2643033,'5','104','895',394,'Sale Id shift 257437',0.00,0.00,0.00,965.43,0.00,'2022-03-01 09:24:32','',''),(2643034,'5','104',NULL,394,'Sale Id shift 257437',1489448.40,0.00,0.00,0.00,0.00,'2022-03-01 09:24:32','',''),(2643035,'5','104',NULL,394,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,3671250.00,22250.00,0.00,0.00,'2022-03-03 10:31:46','',''),(2643036,'5','104',NULL,394,'Reception corrector for bridging 132610',0.00,0.00,0.00,22250.00,0.00,'2022-03-03 10:38:26','',''),(2643037,'5','104','896',394,'Received from bridging 132610',0.00,0.00,22250.00,0.00,0.00,'2022-03-03 10:38:26','',''),(2643038,'5','104','895',394,'Sale Id shift 257438',0.00,0.00,0.00,2662.56,0.00,'2022-03-03 12:29:47','',''),(2643039,'5','104','896',394,'Sale Id shift 257438',0.00,0.00,0.00,10.51,0.00,'2022-03-03 12:29:47','',''),(2643040,'5','104','896',394,'Sale Id shift 257438',0.00,0.00,0.00,632.52,0.00,'2022-03-03 12:29:47','',''),(2643041,'5','104','895',394,'Sale Id shift 257438',0.00,0.00,0.00,2621.34,0.00,'2022-03-03 12:29:47','',''),(2643042,'5','104',NULL,394,'Sale Id shift 257438',977943.45,0.00,0.00,0.00,0.00,'2022-03-03 12:29:47','',''),(2643043,'5','104','895',394,'Sale Id shift 257439',0.00,0.00,0.00,3182.46,0.00,'2022-03-03 18:14:30','',''),(2643044,'5','104','895',394,'Sale Id shift 257439',0.00,0.00,0.00,399.97,0.00,'2022-03-03 18:14:30','',''),(2643045,'5','104','896',394,'Sale Id shift 257439',0.00,0.00,0.00,5358.69,0.00,'2022-03-03 18:14:30','',''),(2643046,'5','104','895',394,'Sale Id shift 257439',0.00,0.00,0.00,2845.03,0.00,'2022-03-03 18:14:30','',''),(2643047,'5','104',NULL,394,'Sale Id shift 257439',1944714.75,0.00,0.00,0.00,0.00,'2022-03-03 18:14:30','',''),(2643048,'5','104','896',394,'Sale Id shift 257440',0.00,0.00,0.00,5916.18,0.00,'2022-03-04 09:27:55','',''),(2643049,'5','104','896',394,'Sale Id shift 257440',0.00,0.00,0.00,5047.27,0.00,'2022-03-04 09:27:55','',''),(2643050,'5','104',NULL,394,'Sale Id shift 257440',1808969.25,0.00,0.00,0.00,0.00,'2022-03-04 09:27:55','',''),(2643051,'5','104',NULL,394,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,4620000.00,28000.00,0.00,0.00,'2022-03-06 11:33:06','',''),(2643052,'5','104',NULL,394,'Reception corrector for bridging 132611',0.00,0.00,0.00,28000.00,0.00,'2022-03-06 16:54:31','',''),(2643053,'5','104','895',394,'Received from bridging 132611',0.00,0.00,28000.00,0.00,0.00,'2022-03-06 16:54:31','',''),(2643054,'5','104','896',394,'Sale Id shift 257441',0.00,0.00,0.00,2726.77,0.00,'2022-03-07 05:19:09','',''),(2643055,'5','104','896',394,'Sale Id shift 257441',0.00,0.00,0.00,2489.21,0.00,'2022-03-07 05:19:09','',''),(2643056,'5','104',NULL,394,'Sale Id shift 257441',860636.70,0.00,0.00,0.00,0.00,'2022-03-07 05:19:09','',''),(2643057,'5','104','895',394,'Sale Id shift 257442',0.00,0.00,0.00,4501.71,0.00,'2022-03-07 09:56:50','',''),(2643058,'5','104','895',394,'Sale Id shift 257442',0.00,0.00,0.00,1977.96,0.00,'2022-03-07 09:56:50','',''),(2643059,'5','104','895',394,'Sale Id shift 257442',0.00,0.00,0.00,5452.25,0.00,'2022-03-07 09:56:50','',''),(2643060,'5','104',NULL,394,'Sale Id shift 257442',1968766.80,0.00,0.00,0.00,0.00,'2022-03-07 09:56:50','',''),(2643061,'5','104','895',394,'Sale Id shift 257443',0.00,0.00,0.00,6342.02,0.00,'2022-03-08 10:06:03','',''),(2643062,'5','104','895',394,'Sale Id shift 257443',0.00,0.00,0.00,6282.56,0.00,'2022-03-08 10:06:03','',''),(2643063,'5','104',NULL,394,'Sale Id shift 257443',2083055.70,0.00,0.00,0.00,0.00,'2022-03-08 10:06:03','',''),(2643064,'5','104','895',394,'Sale Id shift 257444',0.00,0.00,0.00,2645.93,0.00,'2022-03-08 15:22:05','',''),(2643065,'5','104','895',394,'Sale Id shift 257444',0.00,0.00,0.00,311.87,0.00,'2022-03-08 15:22:05','',''),(2643066,'5','104',NULL,394,'Sale Id shift 257444',488037.00,0.00,0.00,0.00,0.00,'2022-03-08 15:22:05','',''),(2643067,'5','104',NULL,394,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,6517500.00,39500.00,0.00,0.00,'2022-03-11 11:20:53','',''),(2643068,'5','104',NULL,394,'Reception corrector for bridging 132613',0.00,0.00,0.00,13500.00,0.00,'2022-03-12 13:34:37','',''),(2643069,'5','104','896',394,'Received from bridging 132613',0.00,0.00,13500.00,0.00,0.00,'2022-03-12 13:34:37','',''),(2643070,'5','104',NULL,394,'Reception corrector for bridging 132612',0.00,0.00,0.00,26000.00,0.00,'2022-03-12 13:34:44','',''),(2643071,'5','104','895',394,'Received from bridging 132612',0.00,0.00,26000.00,0.00,0.00,'2022-03-12 13:34:44','',''),(2643072,'5','104','895',394,'Sale Id shift 257447',0.00,0.00,0.00,718.46,0.00,'2022-03-12 15:55:03','',''),(2643073,'5','104','896',394,'Sale Id shift 257447',0.00,0.00,0.00,471.61,0.00,'2022-03-12 15:55:03','',''),(2643074,'5','104','895',394,'Sale Id shift 257447',0.00,0.00,0.00,898.30,0.00,'2022-03-12 15:55:03','',''),(2643075,'5','104',NULL,394,'Sale Id shift 257447',344581.05,0.00,0.00,0.00,0.00,'2022-03-12 15:55:03','',''),(2643076,'5','104','895',394,'Sale Id shift 257448',0.00,0.00,0.00,3381.14,0.00,'2022-03-12 16:25:36','',''),(2643077,'5','104','896',394,'Sale Id shift 257448',0.00,0.00,0.00,3313.40,0.00,'2022-03-12 16:25:36','',''),(2643078,'5','104','896',394,'Sale Id shift 257448',0.00,0.00,0.00,3274.71,0.00,'2022-03-12 16:25:36','',''),(2643079,'5','104','895',394,'Sale Id shift 257448',0.00,0.00,0.00,3442.07,0.00,'2022-03-12 16:25:36','',''),(2643080,'5','104',NULL,394,'Sale Id shift 257448',2212867.80,0.00,0.00,0.00,0.00,'2022-03-12 16:25:36','',''),(2643081,'5','104','895',394,'Sale Id shift 257449',0.00,0.00,0.00,2559.36,0.00,'2022-03-13 08:53:56','',''),(2643082,'5','104','896',394,'Sale Id shift 257449',0.00,0.00,0.00,2261.89,0.00,'2022-03-13 08:53:56','',''),(2643083,'5','104','896',394,'Sale Id shift 257449',0.00,0.00,0.00,3584.76,0.00,'2022-03-13 08:53:56','',''),(2643084,'5','104','895',394,'Sale Id shift 257449',0.00,0.00,0.00,2962.35,0.00,'2022-03-13 08:53:56','',''),(2643085,'5','104',NULL,394,'Sale Id shift 257449',1875779.40,0.00,0.00,0.00,0.00,'2022-03-13 08:53:56','',''),(2643086,'5','104','895',394,'Sale Id shift 257450',0.00,0.00,0.00,5636.83,0.00,'2022-03-15 11:44:11','',''),(2643087,'5','104','896',394,'Sale Id shift 257450',0.00,0.00,0.00,792.78,0.00,'2022-03-15 11:44:11','',''),(2643088,'5','104','895',394,'Sale Id shift 257450',0.00,0.00,0.00,4201.37,0.00,'2022-03-15 11:44:11','',''),(2643089,'5','104',NULL,394,'Sale Id shift 257450',1754111.70,0.00,0.00,0.00,0.00,'2022-03-15 11:44:11','',''),(2643090,'5','104','895',394,'Sale Id shift 257451',0.00,0.00,0.00,240.90,0.00,'2022-03-15 15:23:29','',''),(2643091,'5','104','895',394,'Sale Id shift 257451',0.00,0.00,0.00,2010.11,0.00,'2022-03-15 15:23:29','',''),(2643092,'5','104',NULL,394,'Sale Id shift 257451',371416.65,0.00,0.00,0.00,0.00,'2022-03-15 15:23:29','',''),(2643093,'5','104',NULL,394,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,4346100.00,26340.00,0.00,0.00,'2022-03-19 10:12:55','',''),(2643094,'5','104',NULL,394,'Reception corrector for bridging 132615',0.00,0.00,0.00,26340.00,0.00,'2022-03-21 15:14:16','',''),(2643095,'5','104','895',394,'Received from bridging 132615',0.00,0.00,26340.00,0.00,0.00,'2022-03-21 15:14:16','',''),(2643096,'5','104','895',394,'Sale Id shift 257455',0.00,0.00,0.00,664.64,0.00,'2022-03-22 09:02:17','',''),(2643097,'5','104','895',394,'Sale Id shift 257455',0.00,0.00,0.00,698.20,0.00,'2022-03-22 09:02:17','',''),(2643098,'5','104','895',394,'Sale Id shift 257455',0.00,0.00,0.00,874.67,0.00,'2022-03-22 09:02:17','',''),(2643099,'5','104',NULL,394,'Sale Id shift 257455',369189.15,0.00,0.00,0.00,0.00,'2022-03-22 09:02:17','',''),(2643100,'5','104','895',394,'Sale Id shift 257456',0.00,0.00,0.00,4800.00,0.00,'2022-03-22 11:23:26','',''),(2643101,'5','104','895',394,'Sale Id shift 257456',0.00,0.00,0.00,7130.30,0.00,'2022-03-22 11:23:26','',''),(2643102,'5','104',NULL,394,'Sale Id shift 257456',1968499.50,0.00,0.00,0.00,0.00,'2022-03-22 11:23:26','',''),(2643103,'5','104','895',394,'Sale Id shift 257457',0.00,0.00,0.00,3181.55,0.00,'2022-03-22 13:16:53','',''),(2643104,'5','104','895',394,'Sale Id shift 257457',0.00,0.00,0.00,2733.25,0.00,'2022-03-22 13:16:53','',''),(2643105,'5','104','895',394,'Sale Id shift 257457',0.00,0.00,0.00,3680.09,0.00,'2022-03-22 13:16:53','',''),(2643106,'5','104',NULL,394,'Sale Id shift 257457',1583156.85,0.00,0.00,0.00,0.00,'2022-03-22 13:16:53','',''),(2643107,'5','104','895',394,'Sale Id shift 257458',0.00,0.00,0.00,942.85,0.00,'2022-03-22 18:13:28','',''),(2643108,'5','104','895',394,'Sale Id shift 257458',0.00,0.00,0.00,1613.94,0.00,'2022-03-22 18:13:28','',''),(2643109,'5','104',NULL,394,'Sale Id shift 257458',421870.35,0.00,0.00,0.00,0.00,'2022-03-22 18:13:28','',''),(2643110,'5','104',NULL,394,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,5403750.00,32750.00,0.00,0.00,'2022-03-24 21:55:50','',''),(2643111,'5','104',NULL,394,'Reception corrector for bridging 132616',0.00,0.00,0.00,32750.00,0.00,'2022-03-25 10:21:08','',''),(2643112,'5','104','895',394,'Received from bridging 132616',0.00,0.00,32750.00,0.00,0.00,'2022-03-25 10:21:08','',''),(2643113,'5','104','895',394,'Sale Id shift 257461',0.00,0.00,0.00,1320.21,0.00,'2022-03-25 13:21:06','',''),(2643114,'5','104','895',394,'Sale Id shift 257461',0.00,0.00,0.00,914.11,0.00,'2022-03-25 13:21:06','',''),(2643115,'5','104','895',394,'Sale Id shift 257461',0.00,0.00,0.00,1341.14,0.00,'2022-03-25 13:21:06','',''),(2643116,'5','104',NULL,394,'Sale Id shift 257461',589950.90,0.00,0.00,0.00,0.00,'2022-03-25 13:21:06','',''),(2643117,'5','104','895',394,'Sale Id shift 257462',0.00,0.00,0.00,3494.20,0.00,'2022-03-26 12:41:41','',''),(2643118,'5','104','895',394,'Sale Id shift 257462',0.00,0.00,0.00,845.32,0.00,'2022-03-26 12:41:41','',''),(2643119,'5','104','895',394,'Sale Id shift 257462',0.00,0.00,0.00,4112.67,0.00,'2022-03-26 12:41:41','',''),(2643120,'5','104',NULL,394,'Sale Id shift 257462',1394611.35,0.00,0.00,0.00,0.00,'2022-03-26 12:41:41','',''),(2643121,'5','104','895',394,'Sale Id shift 257463',0.00,0.00,0.00,4206.84,0.00,'2022-03-27 08:57:08','',''),(2643122,'5','104','895',394,'Sale Id shift 257463',0.00,0.00,0.00,5305.07,0.00,'2022-03-27 08:57:08','',''),(2643123,'5','104',NULL,394,'Sale Id shift 257463',1569465.15,0.00,0.00,0.00,0.00,'2022-03-27 08:57:08','',''),(2643124,'5','104','895',394,'Sale Id shift 257464',0.00,0.00,0.00,2460.31,0.00,'2022-03-28 10:11:55','',''),(2643125,'5','104','895',394,'Sale Id shift 257464',0.00,0.00,0.00,3967.15,0.00,'2022-03-28 10:11:55','',''),(2643126,'5','104','895',394,'Sale Id shift 257464',0.00,0.00,0.00,4635.95,0.00,'2022-03-28 10:11:55','',''),(2643127,'5','104',NULL,394,'Sale Id shift 257464',1825462.65,0.00,0.00,0.00,0.00,'2022-03-28 10:11:55','',''),(2643128,'5','104',NULL,394,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,4372500.00,26500.00,0.00,0.00,'2022-04-12 15:25:59','',''),(2643129,'5','104',NULL,394,'Reception corrector for bridging 132617',0.00,0.00,0.00,26500.00,0.00,'2022-04-12 15:58:54','',''),(2643130,'5','104','895',394,'Received from bridging 132617',0.00,0.00,26500.00,0.00,0.00,'2022-04-12 15:58:54','',''),(2643131,'5','104','895',394,'Sale Id shift 257480',0.00,0.00,0.00,5772.16,0.00,'2022-04-13 08:58:00','',''),(2643132,'5','104','895',394,'Sale Id shift 257480',0.00,0.00,0.00,239.99,0.00,'2022-04-13 08:58:00','',''),(2643133,'5','104','895',394,'Sale Id shift 257480',0.00,0.00,0.00,4879.01,0.00,'2022-04-13 08:58:00','',''),(2643134,'5','104',NULL,394,'Sale Id shift 257480',1797041.40,0.00,0.00,0.00,0.00,'2022-04-13 08:58:00','',''),(2643135,'5','104','895',394,'Sale Id shift 257481',0.00,0.00,0.00,4047.23,0.00,'2022-04-14 09:22:08','',''),(2643136,'5','104','895',394,'Sale Id shift 257481',0.00,0.00,0.00,2618.38,0.00,'2022-04-14 09:22:08','',''),(2643137,'5','104',NULL,394,'Sale Id shift 257481',1099825.65,0.00,0.00,0.00,0.00,'2022-04-14 09:22:08','',''),(2643138,'5','104','895',394,'Sale Id shift 257482',0.00,0.00,0.00,2878.77,0.00,'2022-04-15 10:19:02','',''),(2643139,'5','104','895',394,'Sale Id shift 257482',0.00,0.00,0.00,168.41,0.00,'2022-04-15 10:19:02','',''),(2643140,'5','104','895',394,'Sale Id shift 257482',0.00,0.00,0.00,4124.70,0.00,'2022-04-15 10:19:02','',''),(2643141,'5','104',NULL,394,'Sale Id shift 257482',1183360.20,0.00,0.00,0.00,0.00,'2022-04-15 10:19:02','',''),(2643142,'5','104','895',394,'Sale Id shift 257483',0.00,0.00,0.00,292.94,0.00,'2022-04-16 19:58:29','',''),(2643143,'5','104','895',394,'Sale Id shift 257483',0.00,0.00,0.00,1615.01,0.00,'2022-04-16 19:58:29','',''),(2643144,'5','104',NULL,394,'Sale Id shift 257483',314811.75,0.00,0.00,0.00,0.00,'2022-04-16 19:58:29','',''),(2643145,'5','104',NULL,394,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,6567000.00,39800.00,0.00,0.00,'2022-04-18 21:30:51','',''),(2643146,'5','104',NULL,394,'Reception corrector for bridging 132619',0.00,0.00,0.00,13350.00,0.00,'2022-04-18 22:02:52','',''),(2643147,'5','104','896',394,'Received from bridging 132619',0.00,0.00,13350.00,0.00,0.00,'2022-04-18 22:02:52','',''),(2643148,'5','104',NULL,394,'Reception corrector for bridging 132618',0.00,0.00,0.00,26450.00,0.00,'2022-04-18 22:02:59','',''),(2643149,'5','104','895',394,'Received from bridging 132618',0.00,0.00,26450.00,0.00,0.00,'2022-04-18 22:02:59','',''),(2643150,'5','104','895',394,'Sale Id shift 257486',0.00,0.00,0.00,1937.35,0.00,'2022-04-19 10:52:32','',''),(2643151,'5','104','896',394,'Sale Id shift 257486',0.00,0.00,0.00,36.43,0.00,'2022-04-19 10:52:32','',''),(2643152,'5','104','896',394,'Sale Id shift 257486',0.00,0.00,0.00,2426.88,0.00,'2022-04-19 10:52:32','',''),(2643153,'5','104','895',394,'Sale Id shift 257486',0.00,0.00,0.00,1363.10,0.00,'2022-04-19 10:52:32','',''),(2643154,'5','104',NULL,394,'Sale Id shift 257486',951020.40,0.00,0.00,0.00,0.00,'2022-04-19 10:52:32','',''),(2643155,'5','104','895',394,'Sale Id shift 257487',0.00,0.00,0.00,3715.82,0.00,'2022-04-20 09:55:23','',''),(2643156,'5','104','896',394,'Sale Id shift 257487',0.00,0.00,0.00,2009.64,0.00,'2022-04-20 09:55:23','',''),(2643157,'5','104','895',394,'Sale Id shift 257487',0.00,0.00,0.00,3420.71,0.00,'2022-04-20 09:55:23','',''),(2643158,'5','104',NULL,394,'Sale Id shift 257487',1509118.05,0.00,0.00,0.00,0.00,'2022-04-20 09:55:23','',''),(2643159,'5','104','895',394,'Sale Id shift 257488',0.00,0.00,0.00,2131.35,0.00,'2022-04-21 09:22:50','',''),(2643160,'5','104','896',394,'Sale Id shift 257488',0.00,0.00,0.00,2026.91,0.00,'2022-04-21 09:22:50','',''),(2643161,'5','104','895',394,'Sale Id shift 257488',0.00,0.00,0.00,3793.78,0.00,'2022-04-21 09:22:50','',''),(2643162,'5','104',NULL,394,'Sale Id shift 257488',1312086.60,0.00,0.00,0.00,0.00,'2022-04-21 09:22:50','',''),(2643163,'5','104','895',394,'Sale Id shift 257489',0.00,0.00,0.00,4688.29,0.00,'2022-04-22 10:17:45','',''),(2643164,'5','104','895',394,'Sale Id shift 257489',0.00,0.00,0.00,357.18,0.00,'2022-04-22 10:17:45','',''),(2643165,'5','104','896',394,'Sale Id shift 257489',0.00,0.00,0.00,1629.77,0.00,'2022-04-22 10:17:45','',''),(2643166,'5','104','895',394,'Sale Id shift 257489',0.00,0.00,0.00,1609.11,0.00,'2022-04-22 10:17:45','',''),(2643167,'5','104',NULL,394,'Sale Id shift 257489',1366917.75,0.00,0.00,0.00,0.00,'2022-04-22 10:17:45','',''),(2643168,'5','104','895',394,'Sale Id shift 257490',0.00,0.00,0.00,2159.44,0.00,'2022-04-23 09:12:10','',''),(2643169,'5','104','896',394,'Sale Id shift 257490',0.00,0.00,0.00,1752.41,0.00,'2022-04-23 09:12:10','',''),(2643170,'5','104','896',394,'Sale Id shift 257490',0.00,0.00,0.00,3533.46,0.00,'2022-04-23 09:12:10','',''),(2643171,'5','104','895',394,'Sale Id shift 257490',0.00,0.00,0.00,1601.93,0.00,'2022-04-23 09:12:10','',''),(2643172,'5','104',NULL,394,'Sale Id shift 257490',1492794.60,0.00,0.00,0.00,0.00,'2022-04-23 09:12:10','',''),(2643173,'5','104',NULL,394,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,4290000.00,26000.00,0.00,0.00,'2022-04-23 09:12:27','',''),(2643174,'5','104',NULL,394,'Reception corrector for bridging 132620',0.00,0.00,0.00,26000.00,0.00,'2022-04-23 14:11:58','',''),(2643175,'5','104','895',394,'Received from bridging 132620',0.00,0.00,26000.00,0.00,0.00,'2022-04-23 14:11:58','',''),(2643176,'5','104','895',394,'Sale Id shift 257491',0.00,0.00,0.00,3194.23,0.00,'2022-04-23 21:11:11','',''),(2643177,'5','104','895',394,'Sale Id shift 257491',0.00,0.00,0.00,4088.53,0.00,'2022-04-23 21:11:11','',''),(2643178,'5','104',NULL,394,'Sale Id shift 257491',1201655.40,0.00,0.00,0.00,0.00,'2022-04-23 21:11:11','',''),(2643179,'5','104','895',394,'Sale Id shift 257492',0.00,0.00,0.00,4665.67,0.00,'2022-04-25 11:36:20','',''),(2643180,'5','104','895',394,'Sale Id shift 257492',0.00,0.00,0.00,3110.55,0.00,'2022-04-25 11:36:20','',''),(2643181,'5','104',NULL,394,'Sale Id shift 257492',1283076.30,0.00,0.00,0.00,0.00,'2022-04-25 11:36:20','',''),(2643182,'5','104','895',394,'Sale Id shift 257493',0.00,0.00,0.00,3251.67,0.00,'2022-04-26 10:14:30','',''),(2643183,'5','104','895',394,'Sale Id shift 257493',0.00,0.00,0.00,4785.15,0.00,'2022-04-26 10:14:30','',''),(2643184,'5','104',NULL,394,'Sale Id shift 257493',1326075.30,0.00,0.00,0.00,0.00,'2022-04-26 10:14:30','',''),(2643185,'5','104','895',394,'Sale Id shift 257494',0.00,0.00,0.00,2998.14,0.00,'2022-04-27 10:16:40','',''),(2643186,'5','104','895',394,'Sale Id shift 257494',0.00,0.00,0.00,307.07,0.00,'2022-04-27 10:16:40','',''),(2643187,'5','104',NULL,394,'Sale Id shift 257494',545359.65,0.00,0.00,0.00,0.00,'2022-04-27 10:16:40','',''),(2643188,'5','104',NULL,394,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,4512750.00,27350.00,0.00,0.00,'2022-04-28 15:31:17','',''),(2643189,'5','104',NULL,394,'Reception corrector for bridging 132621',0.00,0.00,0.00,27350.00,0.00,'2022-04-29 09:49:44','',''),(2643190,'5','104','895',394,'Received from bridging 132621',0.00,0.00,27350.00,0.00,0.00,'2022-04-29 09:49:44','',''),(2643191,'5','104','895',394,'Sale Id shift 257496',0.00,0.00,0.00,2421.31,0.00,'2022-04-29 21:17:16','',''),(2643192,'5','104','895',394,'Sale Id shift 257496',0.00,0.00,0.00,1699.67,0.00,'2022-04-29 21:17:16','',''),(2643193,'5','104','895',394,'Sale Id shift 257496',0.00,0.00,0.00,2331.25,0.00,'2022-04-29 21:17:16','',''),(2643194,'5','104',NULL,394,'Sale Id shift 257496',1064617.95,0.00,0.00,0.00,0.00,'2022-04-29 21:17:16','',''),(2643195,'5','104','895',394,'Sale Id shift 257497',0.00,0.00,0.00,2942.51,0.00,'2022-05-09 10:53:04','',''),(2643196,'5','104','895',394,'Sale Id shift 257497',0.00,0.00,0.00,2340.27,0.00,'2022-05-09 10:53:04','',''),(2643197,'5','104','895',394,'Sale Id shift 257497',0.00,0.00,0.00,2404.19,0.00,'2022-05-09 10:53:04','',''),(2643198,'5','104',NULL,394,'Sale Id shift 257497',1268350.05,0.00,0.00,0.00,0.00,'2022-05-09 10:53:04','',''),(2643199,'5','104','895',394,'Sale Id shift 257498',0.00,0.00,0.00,3274.84,0.00,'2022-05-10 16:18:15','',''),(2643200,'5','104','895',394,'Sale Id shift 257498',0.00,0.00,0.00,3119.34,0.00,'2022-05-10 16:18:15','',''),(2643201,'5','104','895',394,'Sale Id shift 257498',0.00,0.00,0.00,3212.25,0.00,'2022-05-10 16:18:15','',''),(2643202,'5','104',NULL,394,'Sale Id shift 257498',1585060.95,0.00,0.00,0.00,0.00,'2022-05-10 16:18:15','',''),(2643203,'5','104',NULL,394,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-10 16:44:11','',''),(2643204,'5','104',NULL,394,'Reception corrector for bridging 132623',0.00,0.00,0.00,15000.00,0.00,'2022-05-10 16:57:44','',''),(2643205,'5','104','896',394,'Received from bridging 132623',0.00,0.00,15000.00,0.00,0.00,'2022-05-10 16:57:44','',''),(2643206,'5','104',NULL,394,'Reception corrector for bridging 132622',0.00,0.00,0.00,30000.00,0.00,'2022-05-10 16:57:44','',''),(2643207,'5','104','895',394,'Received from bridging 132622',0.00,0.00,30000.00,0.00,0.00,'2022-05-10 16:57:44','',''),(2643208,'5','104','895',394,'Sale Id shift 257499',0.00,0.00,0.00,2796.73,0.00,'2022-05-10 16:59:06','',''),(2643209,'5','104','895',394,'Sale Id shift 257499',0.00,0.00,0.00,1768.02,0.00,'2022-05-10 16:59:06','',''),(2643210,'5','104','896',394,'Sale Id shift 257499',0.00,0.00,0.00,2.86,0.00,'2022-05-10 16:59:06','',''),(2643211,'5','104','896',394,'Sale Id shift 257499',0.00,0.00,0.00,2148.20,0.00,'2022-05-10 16:59:06','',''),(2643212,'5','104','895',394,'Sale Id shift 257499',0.00,0.00,0.00,1856.85,0.00,'2022-05-10 16:59:06','',''),(2643213,'5','104',NULL,394,'Sale Id shift 257499',1414488.90,0.00,0.00,0.00,0.00,'2022-05-10 16:59:06','',''),(2643214,'5','104','895',394,'Sale Id shift 257500',0.00,0.00,0.00,4722.00,0.00,'2022-05-10 17:03:12','',''),(2643215,'5','104','895',394,'Sale Id shift 257500',0.00,0.00,0.00,3706.91,0.00,'2022-05-10 17:03:12','',''),(2643216,'5','104',NULL,394,'Sale Id shift 257500',1390770.15,0.00,0.00,0.00,0.00,'2022-05-10 17:03:12','',''),(2643217,'5','104','895',394,'Sale Id shift 257501',0.00,0.00,0.00,3310.74,0.00,'2022-05-10 17:08:54','',''),(2643218,'5','104','896',394,'Sale Id shift 257501',0.00,0.00,0.00,1197.10,0.00,'2022-05-10 17:08:54','',''),(2643219,'5','104','895',394,'Sale Id shift 257501',0.00,0.00,0.00,2994.04,0.00,'2022-05-10 17:08:54','',''),(2643220,'5','104',NULL,394,'Sale Id shift 257501',1237810.20,0.00,0.00,0.00,0.00,'2022-05-10 17:08:54','',''),(2643221,'5','104','895',394,'Sale Id shift 257502',0.00,0.00,0.00,2550.91,0.00,'2022-05-10 17:12:18','',''),(2643222,'5','104','896',394,'Sale Id shift 257502',0.00,0.00,0.00,3404.15,0.00,'2022-05-10 17:12:18','',''),(2643223,'5','104',NULL,394,'Sale Id shift 257502',982584.90,0.00,0.00,0.00,0.00,'2022-05-10 17:12:18','',''),(2643224,'5','104','895',394,'Sale Id shift 257503',0.00,0.00,0.00,3606.17,0.00,'2022-05-10 17:22:32','',''),(2643225,'5','104','896',394,'Sale Id shift 257503',0.00,0.00,0.00,1488.35,0.00,'2022-05-10 17:22:32','',''),(2643226,'5','104','895',394,'Sale Id shift 257503',0.00,0.00,0.00,3114.40,0.00,'2022-05-10 17:22:32','',''),(2643227,'5','104',NULL,394,'Sale Id shift 257503',1354471.80,0.00,0.00,0.00,0.00,'2022-05-10 17:22:32','',''),(2643228,'5','104','896',394,'Sale Id shift 257504',0.00,0.00,0.00,4320.97,0.00,'2022-05-10 17:26:52','',''),(2643229,'5','104','895',394,'Sale Id shift 257504',0.00,0.00,0.00,3352.40,0.00,'2022-05-10 17:26:52','',''),(2643230,'5','104',NULL,394,'Sale Id shift 257504',1266106.05,0.00,0.00,0.00,0.00,'2022-05-10 17:26:52','',''),(2643231,'5','104','896',394,'Sale Id shift 257505',0.00,0.00,0.00,1159.52,0.00,'2022-05-10 17:45:09','',''),(2643232,'5','104','896',394,'Sale Id shift 257505',0.00,0.00,0.00,1235.52,0.00,'2022-05-10 17:45:09','',''),(2643233,'5','104',NULL,394,'Sale Id shift 257505',395181.60,0.00,0.00,0.00,0.00,'2022-05-10 17:45:09','',''),(2643234,'5','104',NULL,394,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,5610000.00,34000.00,0.00,0.00,'2022-05-24 19:57:10','',''),(2643235,'5','104',NULL,394,'Reception corrector for bridging 132624',0.00,0.00,0.00,34000.00,0.00,'2022-05-24 22:13:57','',''),(2643236,'5','104','895',394,'Received from bridging 132624',0.00,0.00,34000.00,0.00,0.00,'2022-05-24 22:13:57','',''),(2643237,'5','104','895',394,'Sale Id shift 257522',0.00,0.00,0.00,1671.56,0.00,'2022-05-25 06:05:19','',''),(2643238,'5','104','895',394,'Sale Id shift 257522',0.00,0.00,0.00,290.41,0.00,'2022-05-25 06:05:19','',''),(2643239,'5','104','895',394,'Sale Id shift 257522',0.00,0.00,0.00,1181.24,0.00,'2022-05-25 06:05:19','',''),(2643240,'5','104',NULL,394,'Sale Id shift 257522',518629.65,0.00,0.00,0.00,0.00,'2022-05-25 06:05:19','',''),(2643241,'5','104','895',394,'Sale Id shift 257523',0.00,0.00,0.00,3479.48,0.00,'2022-05-26 05:26:21','',''),(2643242,'5','104','895',394,'Sale Id shift 257523',0.00,0.00,0.00,3385.77,0.00,'2022-05-26 05:26:21','',''),(2643243,'5','104',NULL,394,'Sale Id shift 257523',1132766.25,0.00,0.00,0.00,0.00,'2022-05-26 05:26:21','',''),(2643244,'5','104','895',394,'Sale Id shift 257524',0.00,0.00,0.00,4176.65,0.00,'2022-05-27 05:22:24','',''),(2643245,'5','104','895',394,'Sale Id shift 257524',0.00,0.00,0.00,3645.51,0.00,'2022-05-27 05:22:24','',''),(2643246,'5','104',NULL,394,'Sale Id shift 257524',1290656.40,0.00,0.00,0.00,0.00,'2022-05-27 05:22:24','',''),(2643247,'5','104','895',394,'Sale Id shift 257525',0.00,0.00,0.00,4584.62,0.00,'2022-05-28 06:11:40','',''),(2643248,'5','104','895',394,'Sale Id shift 257525',0.00,0.00,0.00,4407.09,0.00,'2022-05-28 06:11:40','',''),(2643249,'5','104',NULL,394,'Sale Id shift 257525',1483632.15,0.00,0.00,0.00,0.00,'2022-05-28 06:11:40','',''),(2643250,'5','104','895',394,'Sale Id shift 257526',0.00,0.00,0.00,3258.20,0.00,'2022-05-29 08:12:30','',''),(2643251,'5','104','895',394,'Sale Id shift 257526',0.00,0.00,0.00,255.49,0.00,'2022-05-29 08:12:30','',''),(2643252,'5','104','895',394,'Sale Id shift 257526',0.00,0.00,0.00,3511.76,0.00,'2022-05-29 08:12:30','',''),(2643253,'5','104',NULL,394,'Sale Id shift 257526',1159199.25,0.00,0.00,0.00,0.00,'2022-05-29 08:12:30','',''),(2643254,'5','104',NULL,394,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,4059000.00,24600.00,0.00,0.00,'2022-05-31 09:05:17','',''),(2643255,'5','104',NULL,394,'Reception corrector for bridging 132625',0.00,0.00,0.00,24600.00,0.00,'2022-05-31 13:30:46','',''),(2643256,'5','104','895',394,'Received from bridging 132625',0.00,0.00,24600.00,0.00,0.00,'2022-05-31 13:30:46','',''),(2643257,'5','104','895',394,'Sale Id shift 257528',0.00,0.00,0.00,1531.20,0.00,'2022-05-31 16:31:16','',''),(2643258,'5','104','895',394,'Sale Id shift 257528',0.00,0.00,0.00,1210.64,0.00,'2022-05-31 16:31:16','',''),(2643259,'5','104',NULL,394,'Sale Id shift 257528',452403.60,0.00,0.00,0.00,0.00,'2022-05-31 16:31:16','',''),(2643260,'5','104','895',394,'Sale Id shift 257529',0.00,0.00,0.00,2556.90,0.00,'2022-06-02 09:06:48','',''),(2643261,'5','104','895',394,'Sale Id shift 257529',0.00,0.00,0.00,4067.36,0.00,'2022-06-02 09:06:48','',''),(2643262,'5','104',NULL,394,'Sale Id shift 257529',1093002.90,0.00,0.00,0.00,0.00,'2022-06-02 09:06:48','',''),(2643263,'5','104','895',394,'Sale Id shift 257530',0.00,0.00,0.00,2312.37,0.00,'2022-06-02 11:31:29','',''),(2643264,'5','104','895',394,'Sale Id shift 257530',0.00,0.00,0.00,4681.54,0.00,'2022-06-02 11:31:29','',''),(2643265,'5','104',NULL,394,'Sale Id shift 257530',1153995.15,0.00,0.00,0.00,0.00,'2022-06-02 11:31:29','',''),(2643266,'5','104','895',394,'Sale Id shift 257531',0.00,0.00,0.00,1982.46,0.00,'2022-06-03 09:27:22','',''),(2643267,'5','104','895',394,'Sale Id shift 257531',0.00,0.00,0.00,3072.71,0.00,'2022-06-03 09:27:22','',''),(2643268,'5','104',NULL,394,'Sale Id shift 257531',834103.05,0.00,0.00,0.00,0.00,'2022-06-03 09:27:22','',''),(2643269,'5','104','895',394,'Sale Id shift 257532',0.00,0.00,0.00,1131.30,0.00,'2022-06-04 09:22:56','',''),(2643270,'5','104','895',394,'Sale Id shift 257532',0.00,0.00,0.00,1981.24,0.00,'2022-06-04 09:22:56','',''),(2643271,'5','104',NULL,394,'Sale Id shift 257532',513569.10,0.00,0.00,0.00,0.00,'2022-06-04 09:22:56','',''),(2643272,'5','104',NULL,394,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,4403025.00,26685.00,0.00,0.00,'2022-06-05 05:33:08','',''),(2643273,'5','104',NULL,394,'Reception corrector for bridging 132626',0.00,0.00,0.00,26685.00,0.00,'2022-06-05 10:18:47','',''),(2643274,'5','104','895',394,'Received from bridging 132626',0.00,0.00,26685.00,0.00,0.00,'2022-06-05 10:18:47','',''),(2643275,'5','104','895',394,'Sale Id shift 257533',0.00,0.00,0.00,2163.14,0.00,'2022-06-05 13:52:43','',''),(2643276,'5','104','895',394,'Sale Id shift 257533',0.00,0.00,0.00,1981.62,0.00,'2022-06-05 13:52:43','',''),(2643277,'5','104',NULL,394,'Sale Id shift 257533',683885.40,0.00,0.00,0.00,0.00,'2022-06-05 13:52:43','',''),(2643278,'5','104','895',394,'Sale Id shift 257534',0.00,0.00,0.00,3586.55,0.00,'2022-06-06 09:48:50','',''),(2643279,'5','104','895',394,'Sale Id shift 257534',0.00,0.00,0.00,4152.65,0.00,'2022-06-06 09:48:50','',''),(2643280,'5','104',NULL,394,'Sale Id shift 257534',1276968.00,0.00,0.00,0.00,0.00,'2022-06-06 09:48:50','',''),(2643281,'5','104','895',394,'Sale Id shift 257535',0.00,0.00,0.00,2841.09,0.00,'2022-06-07 09:07:30','',''),(2643282,'5','104','895',394,'Sale Id shift 257535',0.00,0.00,0.00,3629.38,0.00,'2022-06-07 09:07:30','',''),(2643283,'5','104',NULL,394,'Sale Id shift 257535',1067627.55,0.00,0.00,0.00,0.00,'2022-06-07 09:07:30','',''),(2643284,'5','104',NULL,394,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,2145000.00,13000.00,0.00,0.00,'2022-06-07 09:11:39','',''),(2643285,'5','104',NULL,394,'Reception corrector for bridging 132627',0.00,0.00,0.00,13000.00,0.00,'2022-06-07 10:02:57','',''),(2643286,'5','104','896',394,'Received from bridging 132627',0.00,0.00,13000.00,0.00,0.00,'2022-06-07 10:02:57','',''),(2643287,'5','104','895',394,'Sale Id shift 257536',0.00,0.00,0.00,3125.21,0.00,'2022-06-08 09:46:08','',''),(2643288,'5','104','895',394,'Sale Id shift 257536',0.00,0.00,0.00,2289.32,0.00,'2022-06-08 09:46:08','',''),(2643289,'5','104',NULL,394,'Sale Id shift 257536',893397.45,0.00,0.00,0.00,0.00,'2022-06-08 09:46:08','',''),(2643290,'5','104','895',394,'Sale Id shift 257537',0.00,0.00,0.00,3000.10,0.00,'2022-06-09 11:13:58','',''),(2643291,'5','104','896',394,'Sale Id shift 257537',0.00,0.00,0.00,3295.28,0.00,'2022-06-09 11:13:58','',''),(2643292,'5','104',NULL,394,'Sale Id shift 257537',1038737.70,0.00,0.00,0.00,0.00,'2022-06-09 11:13:58','',''),(2643293,'5','104','896',394,'Sale Id shift 257538',0.00,0.00,0.00,3600.97,0.00,'2022-06-10 10:11:45','',''),(2643294,'5','104','896',394,'Sale Id shift 257538',0.00,0.00,0.00,2910.00,0.00,'2022-06-10 10:11:45','',''),(2643295,'5','104',NULL,394,'Sale Id shift 257538',1074310.05,0.00,0.00,0.00,0.00,'2022-06-10 10:11:45','',''),(2643296,'5','104','896',394,'Sale Id shift 257539',0.00,0.00,0.00,3025.02,0.00,'2022-06-11 13:31:47','',''),(2643297,'5','104',NULL,394,'Sale Id shift 257539',499128.30,0.00,0.00,0.00,0.00,'2022-06-11 13:31:47','',''),(2643298,'5','104',NULL,394,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,5445000.00,33000.00,0.00,0.00,'2022-07-08 22:50:41','',''),(2643299,'5','104',NULL,394,'Reception corrector for bridging 132628',0.00,0.00,0.00,33000.00,0.00,'2022-07-10 09:34:55','',''),(2643300,'5','104','895',394,'Received from bridging 132628',0.00,0.00,33000.00,0.00,0.00,'2022-07-10 09:34:55','',''),(2643301,'5','104','895',394,'Sale Id shift 257567',0.00,0.00,0.00,1320.51,0.00,'2022-07-11 08:23:56','',''),(2643302,'5','104','895',394,'Sale Id shift 257567',0.00,0.00,0.00,1213.69,0.00,'2022-07-11 08:23:56','',''),(2643303,'5','104',NULL,394,'Sale Id shift 257567',418143.00,0.00,0.00,0.00,0.00,'2022-07-11 08:23:56','',''),(2643304,'5','104','895',394,'Sale Id shift 257568',0.00,0.00,0.00,2932.48,0.00,'2022-07-12 10:53:18','',''),(2643305,'5','104','895',394,'Sale Id shift 257568',0.00,0.00,0.00,2507.67,0.00,'2022-07-12 10:53:18','',''),(2643306,'5','104',NULL,394,'Sale Id shift 257568',897624.75,0.00,0.00,0.00,0.00,'2022-07-12 10:53:19','',''),(2643307,'5','104','895',394,'Sale Id shift 257569',0.00,0.00,0.00,2635.25,0.00,'2022-07-12 16:40:21','',''),(2643308,'5','104','895',394,'Sale Id shift 257569',0.00,0.00,0.00,3080.27,0.00,'2022-07-12 16:40:21','',''),(2643309,'5','104',NULL,394,'Sale Id shift 257569',943060.80,0.00,0.00,0.00,0.00,'2022-07-12 16:40:21','',''),(2643310,'5','104','895',394,'Sale Id shift 257570',0.00,0.00,0.00,2794.07,0.00,'2022-07-12 17:24:25','',''),(2643311,'5','104','895',394,'Sale Id shift 257570',0.00,0.00,0.00,3165.32,0.00,'2022-07-12 17:24:25','',''),(2643312,'5','104',NULL,394,'Sale Id shift 257570',1102487.15,0.00,0.00,0.00,0.00,'2022-07-12 17:24:25','',''),(2643313,'5','104','895',394,'Sale Id shift 257571',0.00,0.00,0.00,2361.44,0.00,'2022-07-13 09:32:18','',''),(2643314,'5','104','895',394,'Sale Id shift 257571',0.00,0.00,0.00,2966.38,0.00,'2022-07-13 09:32:18','',''),(2643315,'5','104',NULL,394,'Sale Id shift 257571',985646.70,0.00,0.00,0.00,0.00,'2022-07-13 09:32:18','',''),(2643316,'5','104','895',394,'Sale Id shift 257572',0.00,0.00,0.00,2343.00,0.00,'2022-07-14 09:50:41','',''),(2643317,'5','104','895',394,'Sale Id shift 257572',0.00,0.00,0.00,5369.01,0.00,'2022-07-14 09:50:41','',''),(2643318,'5','104',NULL,394,'Sale Id shift 257572',1426721.85,0.00,0.00,0.00,0.00,'2022-07-14 09:50:41','',''),(2643319,'5','104',NULL,394,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,4162500.00,22500.00,0.00,0.00,'2022-07-14 10:41:10','',''),(2643320,'5','104',NULL,394,'Reception corrector for bridging 132629',0.00,0.00,0.00,22500.00,0.00,'2022-07-14 12:05:45','',''),(2643321,'5','104','896',394,'Received from bridging 132629',0.00,0.00,22500.00,0.00,0.00,'2022-07-14 12:05:45','',''),(2643322,'5','104','896',394,'Sale Id shift 257573',0.00,0.00,0.00,4764.92,0.00,'2022-07-15 10:52:15','',''),(2643323,'5','104','896',394,'Sale Id shift 257573',0.00,0.00,0.00,4197.22,0.00,'2022-07-15 10:52:15','',''),(2643324,'5','104',NULL,394,'Sale Id shift 257573',1657995.90,0.00,0.00,0.00,0.00,'2022-07-15 10:52:15','',''),(2643325,'5','104',NULL,394,'Purchased from SALBAS OIL & GAS NIG LTD',0.00,7387050.00,39930.00,0.00,0.00,'2022-07-15 20:52:51','',''),(2643326,'5','104',NULL,394,'Reception corrector for bridging 