-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_5_station_102
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_5_station_102`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_5_station_102` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_5_station_102`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3356 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (2368,30134,'',0,'24','5','102','PUBLIC RELATION','','2020-03-12 15:54:40',5,0.00,0.00,'','415','2020-03-12 15:54:40','415',0,1),(2369,30135,'',0,'24','5','102','PURCHASE','','2020-03-12 15:55:04',5,0.00,0.00,'','415','2020-03-12 15:55:04','415',0,1),(2370,30136,'',0,'24','5','102','SALARIES & WAGES','','2020-03-12 15:55:39',5,0.00,0.00,'','415','2020-03-12 15:55:39','415',0,1),(2371,3016,'',0,'6.1','5','102','CASH','','2020-03-12 15:56:01',5,0.00,0.00,'','415','2020-03-12 15:56:01','415',0,1),(2372,30137,'',0,'24','5','102','DIESEL INTERNAL CONSUMPTION','','2020-03-12 15:56:30',5,0.00,0.00,'','415','2020-03-12 15:56:30','415',0,1),(2373,30138,'',0,'24','5','102','CLEANING AND SANITARY','','2020-03-12 15:56:52',5,0.00,0.00,'','415','2020-03-12 15:56:52','415',0,1),(2374,30139,'',0,'24','5','102','TRANSPORT FARE','','2020-03-12 15:57:09',5,0.00,0.00,'','415','2020-03-12 15:57:09','415',0,1),(2375,30140,'',0,'24','5','102','OTHER OPERATING EXPENSES','','2020-03-12 15:57:45',5,0.00,0.00,'','415','2020-03-12 15:57:45','415',0,1),(2376,30141,'',0,'24','5','102','PUMP REPAIR AND MAINTENANCE ','','2020-03-12 15:58:05',5,0.00,0.00,'','415','2020-03-12 15:58:05','415',0,1),(2377,30142,'',0,'24','5','102','GENERATOR REPAIR AND MAINTENAN','','2020-03-12 15:58:40',5,0.00,0.00,'','415','2020-03-12 15:58:40','415',0,1),(2378,30143,'',0,'24','5','102','WEIGHT AND MEASURE  ','','2020-03-12 15:59:15',5,0.00,0.00,'','415','2020-03-12 15:59:15','415',0,1),(2379,30144,'',0,'24','5','102','DPR EXPESES ','','2020-03-12 16:00:41',5,0.00,0.00,'','415','2020-03-12 16:00:41','415',0,1),(2380,30145,'',0,'24','5','102','TRAVELLING EXPENSES','','2020-03-12 16:01:22',5,0.00,0.00,'','415','2020-03-12 16:01:22','415',0,1),(2381,30146,'',0,'24','5','102','MEDICAL EXPENSES','','2020-03-12 16:02:24',5,0.00,0.00,'','415','2020-03-12 16:02:24','415',0,1),(2382,30147,'',0,'24','5','102','OFFICIAL CAR FUEL AND MAINTENA','','2020-03-12 16:03:08',5,0.00,0.00,'','415','2020-03-12 16:03:08','415',0,1),(2383,4014,'',0,'20','5','102','SALES','','2020-03-12 16:03:33',5,0.00,0.00,'','415','2020-03-12 16:03:33','415',0,1),(2384,4013,'',0,'2','5','102','UBA1019882661','','2020-03-12 16:06:22',5,0.00,0.00,'','415','2020-03-12 16:06:22','415',0,1),(3354,4007,'',0,'22','5','102','PURCHASES','ALL PURCHASES ACCOUNT','2021-05-18 07:35:01',5,0.00,0.00,'','617','2021-05-18 07:35:01','617',0,1),(3355,4014,'',0,'2','5','102','JA\'IZ-0010037957','','2022-03-02 19:05:07',5,0.00,0.00,'','600','2022-03-02 19:05:07','600',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2993 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (2992,'','5','102','MAI MAI PURE WATER','ALIYU','08035300530','info@salbasoilandgas.com.ng','KATSINA','KATSINA','BATSARI ROAD','Nigeria',300000.00,0.00,0.00,'0000-00-00','2021-07-29 08:43:22',5,'600','2021-07-29 08:43:22','600');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=1759 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('5','102','632',1753,'5','PUMP 2',201195.69,'PMS PUMP 2','',NULL,NULL,'',5,'2021-07-26 12:38:09','600'),('5','102','632',1754,'5','PUMP 3',1050429.30,'PMS PUMP 3','',NULL,NULL,'',5,'2021-07-26 12:39:24','600'),('5','102','631',1755,'5','PUMP 1',269860.24,'PMS PUMP 1',NULL,NULL,NULL,NULL,5,'2020-03-19 15:50:28','415'),('5','102','631',1756,'5','PUMP 4',1161615.82,'PMS PUMP 4','',NULL,NULL,'',5,'2021-07-26 12:40:09','600'),('5','102','633',1757,'5','PUMP 5',278853.60,'AGO PUMP 5','',NULL,NULL,'',5,'2021-07-26 12:40:48','600'),('5','102','634',1758,'5','PUMP 6',0.00,'DPK PUMP 6',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=226 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
INSERT INTO `depots_nozzles_tanks` VALUES (222,'5','102','1755','631','PMS TANKS CONNECTION ERROR.','2021-07-12 11:00:03',0,'600'),(223,'5','102','1756','631','PMS TANKS GROUPING ERROR.','2021-07-12 11:00:45',0,'600'),(224,'5','102','1753','632','PMS TANKS CONNECTION ERROR.','2021-07-12 11:01:29',0,'600'),(225,'5','102','1754','632','PMS TANKS CONNECTION ERROR.','2021-07-12 11:02:13',0,'600');
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`)
) ENGINE=InnoDB AUTO_INCREMENT=257796 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('5','102',213197,'DAILY SHIFT','2021-07-23','2021-07-23 00:00:00',NULL,'415',101329.80,101329.80,'415','2021-07-27 09:28:10','605','2021-07-27 09:30:22',10),('5','102',213205,'DAILY SHIFT','2021-07-24','2021-07-24 00:00:00',NULL,'415',378043.05,378043.05,'415','2021-07-27 09:35:05','605','2021-07-27 10:07:34',10),('5','102',213306,'Daily shift','2021-07-25','2021-07-25 00:00:00',NULL,'415',279490.20,279490.20,'415','2021-07-27 14:27:06','605','2021-07-27 14:37:07',10),('5','102',213382,'Daily shift','2021-07-26','2021-07-26 00:00:00',NULL,'415',231892.65,231892.65,'415','2021-07-28 05:56:51','605','2021-07-28 08:55:54',10),('5','102',213448,'Daily shift','2021-07-27','2021-07-27 00:00:00',NULL,'415',301418.70,301418.70,'415','2021-07-28 09:05:08','605','2021-07-28 15:39:26',10),('5','102',213625,'Daily shift','2021-07-28','2021-07-28 00:00:00',NULL,'415',257193.75,257193.75,'415','2021-07-29 08:55:49','605','2021-07-29 09:01:33',10),('5','102',213884,'Daily shift','2021-07-29','2021-07-29 00:00:00',NULL,'415',262970.40,262970.40,'415','2021-07-30 06:27:50','605','2021-07-30 09:50:39',10),('5','102',214101,'Daily shift ','2021-07-30','2021-07-30 00:00:00',NULL,'415',307832.25,307832.25,'415','2021-07-31 06:45:13','605','2021-07-31 15:07:34',10),('5','102',214310,'Daily shift','2021-07-31','2021-07-31 00:00:00',NULL,'415',321076.80,321076.80,'415','2021-08-01 06:28:42','605','2021-08-01 06:34:04',10),('5','102',214529,'Daily shift','2021-08-01','2021-08-01 00:00:00',NULL,'415',266453.55,266453.55,'415','2021-08-02 06:23:31','605','2021-08-02 06:24:30',10),('5','102',214532,'Daily shift','2021-08-02','2021-08-02 00:00:00',NULL,'415',273659.10,273659.10,'415','2021-08-02 20:47:38','605','2021-08-03 08:14:30',10),('5','102',214949,'Daily shift','2021-08-03','2021-08-03 00:00:00',NULL,'415',408241.35,408241.35,'415','2021-08-03 20:11:48','605','2021-08-03 20:47:16',10),('5','102',215106,'Daily shift','2021-08-04','2021-08-04 00:00:00',NULL,'415',354070.20,354070.20,'415','2021-08-04 18:50:06','605','2021-08-05 05:43:54',10),('5','102',215351,'Daily shift','2021-08-05','2021-08-05 00:00:00',NULL,'415',374764.50,374764.50,'415','2021-08-05 20:55:03','605','2021-08-06 00:09:48',10),('5','102',215654,'Daily shift','2021-08-06','2021-08-06 00:00:00',NULL,'415',297661.65,297661.65,'415','2021-08-06 21:30:57','605','2021-08-07 04:55:49',10),('5','102',215881,'Daily shift','2021-08-07','2021-08-07 00:00:00',NULL,'415',284161.35,284161.35,'415','2021-08-07 20:06:15','605','2021-08-08 06:18:30',10),('5','102',216076,'Daily shift','2021-08-08','2021-08-08 00:00:00',NULL,'415',239347.35,239347.35,'415','2021-08-08 20:02:31','605','2021-08-08 22:21:41',10),('5','102',216309,'Daily shift','2021-08-09','2021-08-09 00:00:00',NULL,'415',290635.95,290635.95,'415','2021-08-10 04:53:48','605','2021-08-10 05:36:06',10),('5','102',216533,'Daily shift','2021-08-10','2021-08-10 00:00:00',NULL,'415',307332.30,307332.30,'415','2021-08-10 19:54:13','605','2021-08-11 05:27:20',10),('5','102',216627,'Daily shift','2021-08-11','2021-08-11 00:00:00',NULL,'415',311851.65,311851.65,'415','2021-08-12 05:41:03','605','2021-08-12 05:51:28',10),('5','102',216993,'Daily shift','2021-08-12','2021-08-12 00:00:00',NULL,'415',342203.40,342203.40,'415','2021-08-12 19:36:59','605','2021-08-13 06:32:52',10),('5','102',217151,'Daily shift','2021-08-13','2021-08-13 00:00:00',NULL,'415',320307.90,320307.90,'415','2021-08-13 19:29:02','605','2021-08-14 06:49:40',10),('5','102',217463,'Daily shift','2021-08-14','2021-08-14 00:00:00',NULL,'415',180486.90,180486.90,'415','2021-08-14 20:39:30','605','2021-08-15 18:17:19',10),('5','102',217650,'Daily shift','2021-08-15','2021-08-15 00:00:00',NULL,'415',225485.70,225485.70,'415','2021-08-15 18:40:09','605','2021-08-15 21:03:51',10),('5','102',217835,'Daily shift','2021-08-16','2021-08-16 00:00:00',NULL,'415',309264.45,309264.45,'415','2021-08-16 20:13:50','605','2021-08-16 22:42:34',10),('5','102',218124,'Daily shift','2021-08-17','2021-08-17 00:00:00',NULL,'415',226196.85,226196.85,'415','2021-08-18 05:53:42','605','2021-08-18 06:01:52',10),('5','102',218299,'Daily shift','2021-08-18','2021-08-18 00:00:00',NULL,'415',254197.35,254197.35,'415','2021-08-18 18:48:50','605','2021-08-19 04:35:19',10),('5','102',218652,'Daily shift','2021-08-19','2021-08-19 00:00:00',NULL,'415',255850.65,255850.65,'415','2021-08-19 20:25:37','605','2021-08-20 05:19:50',10),('5','102',218677,'Daily shift','2021-08-20','2021-08-20 00:00:00',NULL,'415',204420.15,204420.15,'415','2021-08-20 23:12:29','605','2021-08-21 05:07:54',10),('5','102',218901,'Daily shift','2021-08-21','2021-08-21 00:00:00',NULL,'415',266620.20,266620.20,'415','2021-08-21 22:01:06','605','2021-08-22 06:58:33',10),('5','102',219317,'Daily shift','2021-08-22','2021-08-22 00:00:00',NULL,'415',214894.35,214894.35,'415','2021-08-22 22:54:49','605','2021-08-23 06:23:55',10),('5','102',219570,'Daily shift','2021-08-23','2021-08-23 00:00:00',NULL,'415',231320.10,231320.10,'415','2021-08-23 22:39:44','605','2021-08-23 22:50:38',10),('5','102',219757,'Daily shift','2021-08-24','2021-08-24 00:00:00',NULL,'415',239865.45,239865.45,'415','2021-08-24 19:28:38','605','2021-08-24 22:11:48',10),('5','102',219869,'Daily shift','2021-08-25','2021-08-25 00:00:00',NULL,'415',252461.55,252461.55,'415','2021-08-25 19:45:49','605','2021-08-25 21:26:18',10),('5','102',220022,'Daily shift','2021-08-26','2021-08-26 00:00:00',NULL,'415',257913.15,257913.15,'415','2021-08-26 19:23:55','605','2021-08-27 06:54:18',10),('5','102',220290,'Daily shift','2021-08-27','2021-08-27 00:00:00',NULL,'415',279757.50,279757.50,'415','2021-08-27 19:27:19','605','2021-08-28 06:32:48',10),('5','102',220485,'Daily shift','2021-08-28','2021-08-28 00:00:00',NULL,'415',282999.75,282999.75,'415','2021-08-28 19:15:42','605','2021-08-29 06:54:37',10),('5','102',220844,'Daily shift','2021-08-29','2021-08-29 00:00:00',NULL,'415',220476.30,220476.30,'415','2021-08-29 19:54:29','605','2021-08-30 04:40:27',10),('5','102',220902,'Daily shift','2021-08-30','2021-08-30 00:00:00',NULL,'415',245897.85,245897.85,'415','2021-08-30 19:21:22','605','2021-08-30 21:02:50',10),('5','102',221132,'Daily shift','2021-08-31','2021-08-31 00:00:00',NULL,'415',238088.40,238088.40,'415','2021-08-31 18:39:34','605','2021-09-01 04:55:38',10),('5','102',221459,'Daily shift','2021-09-01','2021-09-01 00:00:00',NULL,'415',284090.40,284090.40,'415','2021-09-01 18:38:38','605','2021-09-02 06:24:22',10),('5','102',221657,'Daily shift','2021-09-02','2021-09-02 00:00:00',NULL,'415',308716.65,308716.65,'415','2021-09-02 20:02:13','605','2021-09-03 09:07:43',10),('5','102',221996,'Daily shift','2021-09-03','2021-09-03 00:00:00',NULL,'415',253091.85,253091.85,'415','2021-09-03 21:07:09','605','2021-09-04 08:50:52',10),('5','102',222204,'Daily shift','2021-09-04','2021-09-04 00:00:00',NULL,'415',214618.80,214618.80,'415','2021-09-04 21:13:38','605','2021-09-05 05:39:17',10),('5','102',222302,'Daily shift','2021-09-05','2021-09-05 00:00:00',NULL,'415',148679.85,148679.85,'415','2021-09-05 21:31:21','605','2021-09-06 04:05:21',10),('5','102',222615,'Daily shift','2021-09-06','2021-09-06 00:00:00',NULL,'415',226733.10,226733.10,'415','2021-09-06 19:59:53','605','2021-09-07 09:25:07',10),('5','102',222874,'Daily shift','2021-09-07','2021-09-07 00:00:00',NULL,'415',84145.05,84145.05,'415','2021-09-07 19:53:09','600','2021-09-08 09:15:52',10),('5','102',223009,'Daily shift','2021-09-08','2021-09-08 00:00:00',NULL,'415',178137.30,178137.30,'415','2021-09-08 19:40:36','608','2021-09-09 08:52:01',10),('5','102',223295,'Daily shift','2021-09-09','2021-09-09 00:00:00',NULL,'415',204233.70,204233.70,'415','2021-09-09 20:09:23','608','2021-09-10 08:36:13',10),('5','102',223490,'Daily shift','2021-09-10','2021-09-10 00:00:00',NULL,'415',114894.45,114894.45,'415','2021-09-11 05:29:50','608','2021-09-11 09:30:41',10),('5','102',223746,'Daily shift','2021-09-11','2021-09-11 00:00:00',NULL,'415',153953.25,153953.25,'415','2021-09-11 20:07:28','608','2021-09-12 14:28:53',10),('5','102',224047,'Daily shift','2021-09-12','2021-09-12 00:00:00',NULL,'415',109228.35,109228.35,'415','2021-09-12 19:56:30','608','2021-09-13 08:33:54',10),('5','102',224357,'Daily shift','2021-09-14','2021-09-14 00:00:00',NULL,'415',0.00,0.00,'415','2021-09-15 13:15:07','608','2021-09-15 20:37:21',10),('5','102',224859,'Daily shift','2021-09-16','2021-09-16 00:00:00',NULL,'415',0.00,0.00,'415','2021-09-16 18:04:08','608','2021-09-17 08:26:59',10),('5','102',225083,'Daily shift','2021-09-17','2021-09-17 00:00:00',NULL,'415',0.00,0.00,'415','2021-09-17 19:06:58','608','2021-09-19 20:41:56',10),('5','102',225917,'Daily shift','2021-09-18','2021-09-18 00:00:00',NULL,'415',0.00,0.00,'415','2021-09-20 16:03:00','608','2021-09-20 17:59:15',10),('5','102',225931,'Daily shift','2021-09-19','2021-09-19 00:00:00',NULL,'415',0.00,0.00,'415','2021-09-20 18:02:00','608','2021-09-20 18:09:47',10),('5','102',225933,'Daily shift','2021-09-20','2021-09-20 00:00:00',NULL,'415',0.00,0.00,'415','2021-09-20 18:11:59','608','2021-09-20 18:43:52',10),('5','102',225969,'Daily shift','2021-09-21','2021-09-21 00:00:00',NULL,'415',0.00,0.00,'415','2021-09-21 05:41:43','608','2021-09-21 15:14:54',10),('5','102',226334,'Daily shift','2021-09-22','2021-09-22 00:00:00',NULL,'415',0.00,0.00,'415','2021-09-22 19:51:24','608','2021-09-22 21:16:55',10),('5','102',226543,'Daily shift','2021-09-23','2021-09-23 00:00:00',NULL,'415',0.00,0.00,'415','2021-09-23 21:07:09','600','2021-09-24 14:13:45',10),('5','102',226877,'Daily shift','2021-09-24','2021-09-24 00:00:00',NULL,'415',0.00,0.00,'415','2021-09-24 19:30:32','608','2021-09-24 20:50:34',10),('5','102',227023,'Daily shift','2021-09-25','2021-09-25 00:00:00',NULL,'415',0.00,0.00,'415','2021-09-25 18:39:25','608','2021-09-25 20:32:12',10),('5','102',227263,'Daily shift','2021-09-26','2021-09-26 00:00:00',NULL,'415',0.00,0.00,'415','2021-09-26 17:40:12','608','2021-09-26 18:36:47',10),('5','102',227398,'Daily shift','2021-09-27','2021-09-27 00:00:00',NULL,'415',0.00,0.00,'415','2021-09-27 20:01:34','608','2021-09-27 20:46:43',10),('5','102',227808,'Daily shift','2021-09-28','2021-09-28 00:00:00',NULL,'415',0.00,0.00,'415','2021-09-28 18:00:44','608','2021-09-28 20:31:39',10),('5','102',228091,'Daily shift','2021-09-29','2021-09-29 00:00:00',NULL,'415',0.00,0.00,'415','2021-09-29 19:22:24','600','2021-10-05 12:34:54',10),('5','102',229399,'Daily shift','2021-09-30','2021-09-30 00:00:00',NULL,'415',0.00,0.00,'415','2021-10-05 21:18:59','600','2021-10-14 08:47:01',10),('5','102',232413,'Daily shift','2021-10-01','2021-10-01 00:00:00',NULL,'415',0.00,0.00,'415','2021-10-18 09:57:07','608','2021-10-19 12:46:36',10),('5','102',232714,'Daily shift','2021-10-02','2021-10-02 00:00:00',NULL,'415',0.00,0.00,'415','2021-10-19 12:49:25','608','2021-10-19 12:50:19',10),('5','102',232715,'Daily shift','2021-10-03','2021-10-03 00:00:00',NULL,'415',0.00,0.00,'415','2021-10-19 12:51:38','608','2021-10-19 12:53:10',10),('5','102',232782,'Daily shift','2021-10-04','2021-10-04 00:00:00',NULL,'415',0.00,0.00,'415','2021-10-19 19:57:31','608','2021-10-19 19:59:36',10),('5','102',232783,'Daily shift','2021-10-05','2021-10-05 00:00:00',NULL,'415',0.00,0.00,'415','2021-10-19 20:06:00','608','2021-10-19 20:07:58',10),('5','102',232790,'Daily shift','2021-10-06','2021-10-06 00:00:00',NULL,'415',0.00,0.00,'415','2021-10-19 20:33:09','608','2021-10-19 20:34:07',10),('5','102',232791,'Daily shift','2021-10-07','2021-10-07 00:00:00',NULL,'415',0.00,0.00,'415','2021-10-19 20:36:10','608','2021-10-19 20:39:33',10),('5','102',232794,'Daily shift','2021-10-08','2021-10-08 00:00:00',NULL,'415',0.00,0.00,'415','2021-10-19 20:40:44','608','2021-10-19 20:46:29',10),('5','102',232797,'Daily shift','2021-10-09','2021-10-09 00:00:00',NULL,'415',0.00,0.00,'415','2021-10-19 20:48:58','608','2021-10-19 20:54:00',10),('5','102',232800,'Daily shift','2021-10-10','2021-10-10 00:00:00',NULL,'415',0.00,0.00,'415','2021-10-19 20:57:51','608','2021-10-19 21:00:03',10),('5','102',232801,'Daily shift','2021-10-11','2021-10-11 00:00:00',NULL,'415',0.00,0.00,'415','2021-10-19 21:01:51','608','2021-10-19 21:10:03',10),('5','102',232803,'Daily shift','2021-10-12','2021-10-12 00:00:00',NULL,'415',0.00,0.00,'415','2021-10-19 21:13:36','608','2021-10-19 21:25:18',10),('5','102',232804,'Daily shift','2021-10-13','2021-10-13 00:00:00',NULL,'415',0.00,0.00,'415','2021-10-19 21:39:21','608','2021-10-19 21:39:39',10),('5','102',232809,'Daily shift','2021-10-14','2021-10-14 00:00:00',NULL,'415',0.00,0.00,'415','2021-10-19 21:40:39','608','2021-10-19 21:44:02',10),('5','102',232811,'Daily shift','2021-10-15','2021-10-15 00:00:00',NULL,'415',0.00,0.00,'415','2021-10-19 21:45:24','608','2021-10-19 21:51:06',10),('5','102',232812,'Daily shift','2021-10-16','2021-10-16 00:00:00',NULL,'415',0.00,0.00,'415','2021-10-19 21:52:16','608','2021-10-19 21:56:39',10),('5','102',232814,'Daily shift','2021-10-17','2021-10-17 00:00:00',NULL,'415',0.00,0.00,'415','2021-10-19 21:58:52','608','2021-10-19 21:59:17',10),('5','102',232816,'Daily shift','2021-10-18','2021-10-18 00:00:00',NULL,'415',0.00,0.00,'415','2021-10-19 22:00:23','608','2021-10-19 22:01:31',10),('5','102',232817,'Daily shift','2021-10-19','2021-10-19 00:00:00',NULL,'415',0.00,0.00,'415','2021-10-19 22:02:33','608','2021-10-19 22:03:37',10),('5','102',233066,'Daily shift','2021-10-20','2021-10-20 00:00:00',NULL,'415',0.00,0.00,'415','2021-10-20 18:42:05','608','2021-10-21 08:07:47',10),('5','102',233316,'Daily shift','2021-10-21','2021-10-21 00:00:00',NULL,'415',0.00,0.00,'415','2021-10-21 17:52:33','608','2021-10-22 06:29:37',10),('5','102',233569,'Daily shift','2021-10-22','2021-10-22 00:00:00',NULL,'415',0.00,0.00,'415','2021-10-22 19:49:43','608','2021-10-22 21:34:09',10),('5','102',234241,'Daily shift','2021-10-23','2021-10-23 00:00:00',NULL,'415',0.00,0.00,'415','2021-10-25 16:00:43','608','2021-10-25 20:06:56',10),('5','102',234273,'Daily shift','2021-10-24','2021-10-24 00:00:00',NULL,'415',0.00,0.00,'415','2021-10-25 20:11:06','608','2021-10-25 20:11:28',10),('5','102',234274,'Daily shift','2021-10-25','2021-10-25 00:00:00',NULL,'415',0.00,0.00,'415','2021-10-25 20:12:32','608','2021-10-25 20:14:04',10),('5','102',234769,'Daily shift','2021-10-26','2021-10-26 00:00:00',NULL,'415',0.00,0.00,'415','2021-10-27 18:05:03','608','2021-10-28 15:59:45',10),('5','102',235450,'Daily shift','2021-10-27','2021-10-27 00:00:00',NULL,'415',0.00,0.00,'415','2021-10-30 14:05:15','608','2021-10-31 18:09:37',10),('5','102',235701,'Daily shift','2021-10-28','2021-10-28 00:00:00',NULL,'415',0.00,0.00,'415','2021-10-31 19:08:13','608','2021-11-02 16:28:35',10),('5','102',236569,'Daily shift','2021-10-29','2021-10-29 00:00:00',NULL,'415',0.00,0.00,'415','2021-11-04 08:16:36','608','2021-11-04 09:41:25',10),('5','102',236598,'Daily shift','2021-10-30','2021-10-30 00:00:00',NULL,'415',0.00,0.00,'415','2021-11-04 09:43:34','608','2021-11-04 10:35:15',10),('5','102',236657,'Daily shift','2021-10-31','2021-10-31 00:00:00',NULL,'415',0.00,0.00,'415','2021-11-04 14:07:03','608','2021-11-04 14:08:43',10),('5','102',236660,'Daily shift','2021-11-01','2021-11-01 00:00:00',NULL,'415',0.00,0.00,'415','2021-11-04 14:09:38','608','2021-11-04 14:11:08',10),('5','102',236661,'Daily shift','2021-11-02','2021-11-02 00:00:00',NULL,'415',0.00,0.00,'415','2021-11-04 14:11:50','608','2021-11-04 14:12:58',10),('5','102',236664,'Daily shift','2021-11-03','2021-11-03 00:00:00',NULL,'415',0.00,0.00,'415','2021-11-04 14:14:06','608','2021-11-04 14:14:45',10),('5','102',236665,'Daily shift','2021-11-04','2021-11-04 00:00:00',NULL,'415',250405.49,253477.95,'415','2021-11-11 21:39:29','608','2021-11-12 09:52:47',10),('5','102',238455,'Daily shift','2021-11-05','2021-11-05 00:00:00',NULL,'415',1453900.80,1453900.80,'415','2021-11-12 09:56:14','608','2021-11-12 09:58:29',10),('5','102',238458,'Daily shift','2021-11-06','2021-11-06 00:00:00',NULL,'415',1937005.95,1937005.95,'415','2021-11-12 10:01:03','608','2021-11-12 10:04:33',10),('5','102',238464,'Daily shift','2021-11-07','2021-11-07 00:00:00',NULL,'415',0.00,0.00,'415','2021-11-12 10:08:55','608','2021-11-12 10:10:31',10),('5','102',238468,'Daily shift','2021-11-08','2021-11-08 00:00:00',NULL,'415',0.00,0.00,'415','2021-11-12 10:15:08','608','2021-11-14 19:32:02',10),('5','102',239060,'Daily shift','2021-11-07','2021-11-07 00:00:00',NULL,'415',2244810.15,2244810.15,'415','2021-11-15 05:53:23','608','2021-11-15 10:34:05',10),('5','102',239187,'Daily shift','2021-11-08','2021-11-08 00:00:00',NULL,'415',752711.85,752711.85,'415','2021-11-15 12:47:11','608','2021-11-15 12:52:54',10),('5','102',239190,'Daily shift ','2021-11-09','2021-11-09 00:00:00',NULL,'415',0.00,0.00,'415','2021-11-15 12:54:02','608','2021-11-15 13:18:41',10),('5','102',239196,'Daily shift','2021-11-10','2021-11-10 00:00:00',NULL,'415',0.00,0.00,'415','2021-11-15 13:19:50','608','2021-11-15 13:20:39',10),('5','102',239197,'Daily shift','2021-11-11','2021-11-11 00:00:00',NULL,'415',0.00,0.00,'415','2021-11-15 13:21:42','608','2021-11-15 13:23:37',10),('5','102',239198,'Daily shift','2021-11-12','2021-11-12 00:00:00',NULL,'415',0.00,0.00,'415','2021-11-15 13:25:06','608','2021-11-15 13:25:59',10),('5','102',239200,'Daily shift','2021-11-13','2021-11-13 00:00:00',NULL,'415',0.00,0.00,'415','2021-11-15 13:27:30','608','2021-11-15 13:28:43',10),('5','102',239223,'Daily shift','2021-11-14','2021-11-14 00:00:00',NULL,'415',996355.80,996355.80,'415','2021-11-15 16:00:39','608','2021-11-15 16:02:34',10),('5','102',239224,'Daily shift','2021-11-15','2021-11-15 00:00:00',NULL,'415',967621.05,967621.05,'415','2021-11-16 07:03:16','608','2021-11-16 14:31:31',10),('5','102',239462,'Daily shift','2021-11-16','2021-11-16 00:00:00',NULL,'415',751743.30,751743.30,'415','2021-11-16 17:53:47','608','2021-11-17 18:54:43',10),('5','102',239715,'Daily shift','2021-11-17','2021-11-17 00:00:00',NULL,'415',759455.40,759455.40,'415','2021-11-17 19:19:23','608','2021-11-18 19:30:52',10),('5','102',239947,'Daily shift','2021-11-18','2021-11-18 00:00:00',NULL,'415',683768.25,683768.25,'415','2021-11-18 19:40:05','608','2021-11-19 21:56:38',10),('5','102',240516,'Daily shift','2021-11-19','2021-11-19 00:00:00',NULL,'415',652070.10,652070.10,'415','2021-11-21 10:04:35','608','2021-11-21 10:05:54',10),('5','102',240518,'Daily shift','2021-11-20','2021-11-20 00:00:00',NULL,'415',605097.90,605097.90,'415','2021-11-21 10:09:13','608','2021-11-21 10:13:12',10),('5','102',240521,'Daily shift','2021-11-21','2021-11-21 00:00:00',NULL,'415',600870.60,600870.60,'415','2021-11-22 05:50:08','608','2021-11-22 10:32:35',10),('5','102',241609,'Daily shift','2021-11-22','2021-11-22 00:00:00',NULL,'415',538942.80,538942.80,'415','2021-11-25 11:52:51','608','2021-11-25 12:23:17',10),('5','102',241612,'Daily shift','2021-11-23','2021-11-23 00:00:00',NULL,'415',45637.35,45637.35,'415','2021-11-25 12:24:21','608','2021-11-29 14:39:44',10),('5','102',242592,'Daily shift','2021-11-24','2021-11-24 00:00:00',NULL,'415',0.00,0.00,'415','2021-11-29 15:05:44','608','2021-11-29 15:06:23',10),('5','102',242759,'Daily shift','2021-11-25','2021-11-25 00:00:00',NULL,'415',0.00,0.00,'415','2021-11-30 09:23:55','608','2021-11-30 09:24:50',10),('5','102',242762,'Daily shift','2021-11-26','2021-11-26 00:00:00',NULL,'415',0.00,0.00,'415','2021-11-30 09:29:27','608','2021-11-30 09:30:38',10),('5','102',242765,'Daily shift','2021-11-27','2021-11-27 00:00:00',NULL,'415',0.00,0.00,'415','2021-11-30 09:34:07','608','2021-11-30 09:36:04',10),('5','102',242766,'Daily shift','2021-11-28','2021-11-28 00:00:00',NULL,'415',0.00,0.00,'415','2021-11-30 09:36:53','608','2021-11-30 09:45:20',10),('5','102',242770,'Daily shift','2021-11-29','2021-11-29 00:00:00',NULL,'415',0.00,0.00,'415','2021-11-30 09:46:47','608','2021-11-30 10:54:13',10),('5','102',243080,'Daily shift','2021-11-30','2021-11-30 00:00:00',NULL,'415',0.00,0.00,'415','2021-12-01 18:46:46','608','2021-12-02 16:21:04',10),('5','102',243467,'Daily shift','2021-12-01','2021-12-01 00:00:00',NULL,'415',0.00,0.00,'415','2021-12-03 11:18:03','608','2021-12-03 11:19:41',10),('5','102',243469,'Daily shift','2021-12-02','2021-12-02 00:00:00',NULL,'415',0.00,0.00,'415','2021-12-03 11:21:07','608','2021-12-03 11:22:06',10),('5','102',243470,'Daily shift','2021-12-03','2021-12-03 00:00:00',NULL,'415',0.00,0.00,'415','2021-12-03 19:12:09','608','2021-12-04 19:43:27',10),('5','102',243931,'Daily shift','2021-12-04','2021-12-04 00:00:00',NULL,'415',0.00,0.00,'415','2021-12-05 12:29:13','608','2021-12-05 20:28:52',10),('5','102',244008,'Daily shift','2021-12-05','2021-12-05 00:00:00',NULL,'415',0.00,0.00,'415','2021-12-05 20:32:06','608','2021-12-06 08:49:21',10),('5','102',244220,'Daily shift','2021-12-06','2021-12-06 00:00:00',NULL,'415',0.00,0.00,'415','2021-12-06 17:31:21','608','2021-12-07 17:07:03',10),('5','102',244615,'Daily shift','2021-12-07','2021-12-07 00:00:00',NULL,'415',0.00,0.00,'415','2021-12-08 11:42:06','608','2021-12-08 20:54:41',10),('5','102',244801,'Daily shift','2021-12-08','2021-12-08 00:00:00',NULL,'415',0.00,0.00,'415','2021-12-09 08:24:29','600','2021-12-09 09:28:30',10),('5','102',245080,'Daily shift','2021-12-09','2021-12-09 00:00:00',NULL,'415',0.00,0.00,'415','2021-12-10 11:18:54','608','2021-12-11 17:51:44',10),('5','102',245594,'Daily shift','2021-12-10','2021-12-10 00:00:00',NULL,'415',0.00,0.00,'415','2021-12-12 15:39:17','608','2021-12-12 21:22:46',10),('5','102',245657,'Daily shift','2021-12-11','2021-12-11 00:00:00',NULL,'415',0.00,0.00,'415','2021-12-12 23:50:30','608','2021-12-13 09:16:01',10),('5','102',245750,'Daily shift','2021-12-12','2021-12-12 00:00:00',NULL,'415',0.00,0.00,'415','2021-12-13 09:40:28','608','2021-12-13 10:50:28',10),('5','102',245828,'Daily shift','2021-12-13','2021-12-13 00:00:00',NULL,'415',0.00,0.00,'415','2021-12-13 19:32:26','608','2021-12-14 09:28:46',10),('5','102',246223,'Daily shift','2021-12-14','2021-12-14 00:00:00',NULL,'415',0.00,0.00,'415','2021-12-15 07:16:09','608','2021-12-15 09:09:02',10),('5','102',246306,'Daily shift','2021-12-15','2021-12-15 00:00:00',NULL,'415',0.00,0.00,'415','2021-12-15 19:54:32','608','2021-12-16 09:05:45',10),('5','102',246868,'Daily shift','2021-12-16','2021-12-16 00:00:00',NULL,'415',0.00,0.00,'415','2021-12-17 16:50:29','608','2021-12-18 17:41:53',10),('5','102',247272,'Daily shift','2021-12-17','2021-12-17 00:00:00',NULL,'415',0.00,0.00,'415','2021-12-19 12:15:41','608','2021-12-19 18:43:26',10),('5','102',247358,'Daily shift','2021-12-18','2021-12-18 00:00:00',NULL,'415',0.00,0.00,'415','2021-12-19 19:25:11','608','2021-12-19 19:41:28',10),('5','102',247479,'Daily shift','2021-12-19','2021-12-19 00:00:00',NULL,'415',0.00,0.00,'415','2021-12-20 09:34:16','608','2021-12-21 21:09:16',10),('5','102',248007,'Daily shift','2021-12-20','2021-12-20 00:00:00',NULL,'415',0.00,0.00,'415','2021-12-22 10:41:12','608','2021-12-22 10:41:59',10),('5','102',248008,'Daily shift','2021-12-21','2021-12-21 00:00:00',NULL,'415',0.00,0.00,'415','2021-12-22 10:43:05','608','2021-12-22 10:43:49',10),('5','102',248010,'Daily shift','2021-12-22','2021-12-22 00:00:00',NULL,'415',0.00,0.00,'415','2021-12-22 18:19:08','608','2021-12-25 13:03:33',10),('5','102',248986,'Daily shift','2021-12-23','2021-12-23 00:00:00',NULL,'415',0.00,0.00,'415','2021-12-26 13:02:34','608','2021-12-26 17:55:04',10),('5','102',249528,'Daily shift','2021-12-24','2021-12-24 00:00:00',NULL,'415',0.00,0.00,'415','2021-12-28 17:52:10','608','2021-12-29 10:11:22',10),('5','102',249767,'Daily shift','2021-12-25','2021-12-25 00:00:00',NULL,'415',0.00,0.00,'415','2021-12-29 15:50:13','608','2021-12-30 18:30:13',10),('5','102',250130,'Daily shift','2021-12-26','2021-12-26 00:00:00',NULL,'415',0.00,0.00,'415','2021-12-31 07:15:12','608','2021-12-31 20:49:00',10),('5','102',250488,'Daily shift','2021-12-27','2021-12-27 00:00:00',NULL,'415',0.00,0.00,'415','2022-01-01 15:29:58','608','2022-01-02 14:17:30',10),('5','102',250695,'Daily shift','2021-12-28','2021-12-28 00:00:00',NULL,'415',0.00,0.00,'415','2022-01-02 14:18:33','608','2022-01-02 14:18:58',10),('5','102',250699,'Daily shift','2021-12-29','2021-12-29 00:00:00',NULL,'415',0.00,0.00,'415','2022-01-02 14:24:12','608','2022-01-02 14:24:48',10),('5','102',250704,'Daily shift','2021-12-30','2021-12-30 00:00:00',NULL,'415',0.00,0.00,'415','2022-01-02 14:29:34','608','2022-01-02 14:33:15',10),('5','102',250707,'Daily shift','2021-12-31','2021-12-31 00:00:00',NULL,'415',0.00,0.00,'415','2022-01-02 14:36:09','608','2022-01-02 14:37:27',10),('5','102',250710,'Daily shift','2022-01-01','2022-01-01 00:00:00',NULL,'415',0.00,0.00,'415','2022-01-02 14:38:29','608','2022-01-02 14:39:06',10),('5','102',250712,'Daily shift','2022-01-02','2022-01-02 00:00:00',NULL,'415',453703.80,453703.80,'415','2022-01-04 10:02:50','608','2022-01-04 13:57:36',10),('5','102',251352,'Daily shift','2022-01-03','2022-01-03 00:00:00',NULL,'415',1369830.00,1369830.00,'415','2022-01-05 10:57:45','608','2022-01-05 10:58:46',10),('5','102',251356,'Daily shift','2022-01-04','2022-01-04 00:00:00',NULL,'415',2052925.05,2052925.05,'415','2022-01-05 11:04:57','608','2022-01-05 11:06:23',10),('5','102',251364,'Daily shift','2022-01-05','2022-01-05 00:00:00',NULL,'415',1419876.15,1419876.15,'415','2022-01-06 08:35:58','608','2022-01-06 18:17:16',10),('5','102',251850,'Daily shift','2022-01-06','2022-01-06 00:00:00',NULL,'415',1017559.95,1017559.95,'415','2022-01-07 11:51:03','608','2022-01-07 12:35:37',10),('5','102',252491,'Daily shift','2022-01-07','2022-01-07 00:00:00',NULL,'415',159225.00,159225.00,'415','2022-01-10 07:45:56','608','2022-01-12 19:52:23',10),('5','102',253150,'Daily shift','2022-01-08','2022-01-08 00:00:00',NULL,'415',0.00,0.00,'415','2022-01-12 19:53:34','608','2022-01-12 19:55:35',10),('5','102',253151,'Daily shift','2022-01-09','2022-01-09 00:00:00',NULL,'415',0.00,0.00,'415','2022-01-12 20:01:40','608','2022-01-12 20:03:23',10),('5','102',253153,'Daily shift','2022-01-10','2022-01-10 00:00:00',NULL,'415',0.00,0.00,'415','2022-01-12 20:05:04','608','2022-01-12 20:05:51',10),('5','102',253154,'Daily shift','2022-01-11','2022-01-11 00:00:00',NULL,'415',0.00,0.00,'415','2022-01-12 20:08:10','608','2022-01-12 20:10:48',10),('5','102',253157,'Daily shift','2022-01-12','2022-01-12 00:00:00',NULL,'415',0.00,0.00,'415','2022-01-12 20:14:01','608','2022-01-12 20:14:57',10),('5','102',253309,'Daily shift','2022-01-13','2022-01-13 00:00:00',NULL,'415',0.00,0.00,'415','2022-01-13 21:02:41','608','2022-01-13 22:52:41',10),('5','102',253573,'Daily shift','2022-01-14','2022-01-14 00:00:00',NULL,'415',0.00,0.00,'415','2022-01-14 19:11:14','608','2022-01-15 09:40:40',10),('5','102',253797,'Daily shift','2022-01-15','2022-01-15 00:00:00',NULL,'415',0.00,0.00,'415','2022-01-16 07:21:37','608','2022-01-16 10:50:17',10),('5','102',254074,'Daily shift','2022-01-16','2022-01-16 00:00:00',NULL,'415',0.00,0.00,'415','2022-01-16 19:05:01','608','2022-01-17 09:59:38',10),('5','102',254369,'Daily shift','2022-01-17','2022-01-17 00:00:00',NULL,'415',0.00,0.00,'415','2022-01-17 21:06:17','608','2022-01-18 15:54:05',10),('5','102',254643,'Daily shift','2022-01-18','2022-01-18 00:00:00',NULL,'415',0.00,0.00,'415','2022-01-18 19:02:54','608','2022-01-19 10:04:28',10),('5','102',254859,'Daily shift','2022-01-19','2022-01-19 00:00:00',NULL,'415',0.00,0.00,'415','2022-01-19 18:50:40','608','2022-01-20 07:19:21',10),('5','102',255147,'Daily shift','2022-01-20','2022-01-20 00:00:00',NULL,'415',0.00,0.00,'415','2022-01-20 20:54:02','608','2022-01-21 11:19:01',10),('5','102',255313,'Daily shift','2022-01-21','2022-01-21 00:00:00',NULL,'415',0.00,0.00,'415','2022-01-21 18:53:56','608','2022-01-22 22:12:15',10),('5','102',255762,'Daily shift','2022-01-22','2022-01-22 00:00:00',NULL,'415',0.00,0.00,'415','2022-01-23 09:24:03','608','2022-01-23 13:44:21',10),('5','102',255893,'Daily shift','2022-01-23','2022-01-23 00:00:00',NULL,'415',0.00,0.00,'415','2022-01-24 10:19:16','608','2022-01-24 21:11:15',10),('5','102',256179,'Daily shift','2022-01-24','2022-01-24 00:00:00',NULL,'415',0.00,0.00,'415','2022-01-24 22:18:27','608','2022-01-25 09:53:06',10),('5','102',256311,'Daily shift','2022-01-25','2022-01-25 00:00:00',NULL,'415',0.00,0.00,'415','2022-01-25 19:08:41','608','2022-01-26 10:17:44',10),('5','102',256563,'Daily shift','2022-01-26','2022-01-26 00:00:00',NULL,'415',0.00,0.00,'415','2022-01-26 22:05:58','608','2022-01-27 19:01:55',10),('5','102',256910,'Daily shift','2022-01-27','2022-01-27 00:00:00',NULL,'415',0.00,0.00,'415','2022-01-27 20:26:43','608','2022-01-28 22:09:13',10),('5','102',257277,'Daily shift','2022-01-28','2022-01-28 00:00:00',NULL,'415',0.00,0.00,'415','2022-01-29 09:17:55','608','2022-01-30 13:03:37',10),('5','102',257656,'Daily shift','2022-01-29','2022-01-29 00:00:00',NULL,'415',0.00,0.00,'415','2022-01-30 16:54:12','608','2022-01-31 22:14:21',10),('5','102',257657,'Daily shift','2022-01-30','2022-01-30 00:00:00',NULL,'415',0.00,0.00,'415','2022-02-01 12:19:55','608','2022-02-01 21:59:11',10),('5','102',257658,'Daily shift','2022-01-31','2022-01-31 00:00:00',NULL,'415',0.00,0.00,'415','2022-02-01 22:02:54','608','2022-02-01 22:04:10',10),('5','102',257659,'Daily shift','2022-02-01','2022-02-01 00:00:00',NULL,'415',0.00,0.00,'415','2022-02-01 22:06:05','608','2022-02-01 22:06:36',10),('5','102',257660,'Daily shift','2022-02-02','2022-02-02 00:00:00',NULL,'415',0.00,0.00,'415','2022-02-02 21:46:21','608','2022-02-03 16:02:51',10),('5','102',257661,'Daily shift','2022-02-03','2022-02-03 00:00:00',NULL,'415',0.00,0.00,'415','2022-02-03 20:06:41','608','2022-02-04 09:35:58',10),('5','102',257662,'Daily shift','2022-02-05','2022-02-05 00:00:00',NULL,'415',0.00,0.00,'415','2022-02-05 09:13:58','608','2022-02-05 20:15:17',10),('5','102',257663,'Daily shift','2022-02-06','2022-02-06 00:00:00',NULL,'415',0.00,0.00,'415','2022-02-08 09:03:58','608','2022-02-09 00:10:49',10),('5','102',257664,'Daily shift','2022-02-07','2022-02-07 00:00:00',NULL,'415',0.00,0.00,'415','2022-02-09 11:04:32','608','2022-02-09 12:47:36',10),('5','102',257665,'Daily shift','2022-02-08','2022-02-08 00:00:00',NULL,'415',0.00,0.00,'415','2022-02-09 12:50:01','608','2022-02-09 12:55:16',10),('5','102',257666,'Daily shift','2022-02-09','2022-02-09 00:00:00',NULL,'415',0.00,0.00,'415','2022-02-09 22:03:45','608','2022-02-10 20:28:42',10),('5','102',257667,'Daily shift','2022-02-10','2022-02-10 00:00:00',NULL,'415',0.00,0.00,'415','2022-02-11 07:22:46','608','2022-02-11 11:24:11',10),('5','102',257668,'Daily shift','2022-02-11','2022-02-11 00:00:00',NULL,'415',0.00,0.00,'415','2022-02-13 07:13:59','608','2022-02-13 21:03:09',10),('5','102',257669,'Daily shift','2022-02-12','2022-02-12 00:00:00',NULL,'415',0.00,0.00,'415','2022-02-13 21:06:19','608','2022-02-13 21:08:50',10),('5','102',257670,'Daily shift','2022-02-13','2022-02-13 00:00:00',NULL,'415',0.00,0.00,'415','2022-02-13 21:11:10','608','2022-02-14 22:30:07',10),('5','102',257671,'Daily shift','2022-02-14','2022-02-14 00:00:00',NULL,'415',0.00,0.00,'415','2022-02-15 07:04:56','608','2022-02-15 07:06:17',10),('5','102',257672,'Daily shift','2022-02-15','2022-02-15 00:00:00',NULL,'415',0.00,0.00,'415','2022-02-15 20:12:55','608','2022-02-16 09:51:44',10),('5','102',257673,'Daily shift','2022-02-16','2022-02-16 00:00:00',NULL,'415',0.00,0.00,'415','2022-02-16 19:04:56','608','2022-02-17 17:52:20',10),('5','102',257674,'Daily shift','2022-02-17','2022-02-17 00:00:00',NULL,'415',0.00,0.00,'415','2022-02-17 20:51:32','608','2022-02-18 11:56:42',10),('5','102',257675,'Daily shift','2022-02-18','2022-02-18 00:00:00',NULL,'415',0.00,0.00,'415','2022-02-18 21:09:29','608','2022-02-19 22:50:37',10),('5','102',257676,'Daily shift','2022-02-19','2022-02-19 00:00:00',NULL,'415',0.00,0.00,'415','2022-02-20 22:36:10','608','2022-02-21 11:51:08',10),('5','102',257677,'Daily shift','2022-02-20','2022-02-20 00:00:00',NULL,'415',0.00,0.00,'415','2022-02-21 11:54:24','608','2022-02-22 07:22:16',10),('5','102',257678,'Daily shift','2022-02-21','2022-02-22 21:17:47','2022-02-23 21:17:47','415',0.00,0.00,'415','2022-02-22 21:18:07','608','2022-02-22 22:40:07',10),('5','102',257679,'Daily shift','2022-02-22','2022-02-23 08:54:22','2022-02-24 08:54:22','415',0.00,0.00,'415','2022-02-23 08:54:40','608','2022-02-23 10:24:02',10),('5','102',257680,'Daily shift','2022-02-23','2022-02-23 22:09:19','2022-02-24 22:09:19','415',1234242.90,1234242.90,'415','2022-02-23 22:10:28','608','2022-02-24 07:02:42',10),('5','102',257681,'Daily shift','2022-02-24','2022-02-24 22:05:09','2022-02-25 22:05:09','415',2725638.30,2725638.30,'415','2022-02-24 22:06:48','608','2022-02-25 23:20:10',10),('5','102',257682,'Daily shift','2022-02-25','2022-02-26 12:03:10','2022-02-27 12:03:10','415',1844427.75,1844427.75,'415','2022-02-26 12:05:21','608','2022-02-26 22:33:15',10),('5','102',257683,'Daily shift','2022-02-26','2022-02-27 09:53:34','2022-02-28 09:53:34','415',827237.40,827237.40,'415','2022-02-27 09:55:33','608','2022-02-27 09:57:40',10),('5','102',257684,'Daily shift','2022-02-27','2022-02-28 12:22:11','2022-03-01 12:22:11','415',0.00,0.00,'415','2022-02-28 12:22:27','608','2022-03-01 07:05:00',10),('5','102',257685,'Daily shift','2022-02-28','2022-03-01 22:23:31','2022-03-02 22:23:31','415',0.00,0.00,'415','2022-03-01 22:24:00','608','2022-03-02 09:55:03',10),('5','102',257686,'Daily shift','2022-03-01','2022-03-02 10:44:56','2022-03-03 10:44:56','415',0.00,0.00,'415','2022-03-02 10:45:26','608','2022-03-02 23:17:36',10),('5','102',257687,'Daily shift','2022-03-02','2022-03-03 10:40:59','2022-03-04 10:40:59','415',0.00,0.00,'415','2022-03-03 10:41:27','608','2022-03-03 21:28:55',10),('5','102',257688,'Daily shift','2022-03-03','2022-03-04 07:32:03','2022-03-05 07:32:03','415',0.00,0.00,'415','2022-03-04 07:32:17','608','2022-03-05 00:17:27',10),('5','102',257689,'Daily shift','2022-03-04','2022-03-06 12:13:42','2022-03-07 12:13:42','415',0.00,0.00,'415','2022-03-06 12:13:55','608','2022-03-08 10:19:26',10),('5','102',257690,'Daily shift','2022-03-05','2022-03-08 10:35:31','2022-03-09 10:35:31','415',0.00,0.00,'415','2022-03-08 10:35:49','608','2022-03-08 10:44:27',10),('5','102',257691,'Daily shift','2022-03-06','2022-03-08 10:45:17','2022-03-09 10:45:17','415',0.00,0.00,'415','2022-03-08 10:45:33','608','2022-03-08 10:46:05',10),('5','102',257692,'Daily shift','2022-03-07','2022-03-08 10:47:30','2022-03-09 10:47:30','415',0.00,0.00,'415','2022-03-08 10:47:45','608','2022-03-08 11:08:13',10),('5','102',257693,'Daily shift','2022-03-08','2022-03-09 09:43:49','2022-03-10 09:43:49','415',0.00,0.00,'415','2022-03-09 09:44:05','608','2022-03-09 09:59:51',10),('5','102',257694,'Daily shift','2022-03-09','2022-03-09 10:30:45','2022-03-10 10:30:45','415',0.00,0.00,'415','2022-03-09 19:21:03','608','2022-03-10 14:04:33',10),('5','102',257695,'Daily shift','2022-03-10','2022-03-11 11:27:53','2022-03-12 11:27:53','415',0.00,0.00,'415','2022-03-11 11:28:13','608','2022-03-12 10:26:28',10),('5','102',257696,'Daily shift','2022-03-11','2022-03-12 21:27:25','2022-03-13 21:27:25','415',0.00,0.00,'415','2022-03-12 21:28:40','608','2022-03-12 21:34:34',10),('5','102',257697,'Daily shift','2022-03-12','2022-03-12 21:36:44','2022-03-13 21:36:44','415',0.00,0.00,'415','2022-03-12 21:37:26','608','2022-03-12 21:41:41',10),('5','102',257698,'Daily shift','2022-03-13','2022-03-13 19:06:10','2022-03-14 19:06:10','415',0.00,0.00,'415','2022-03-13 19:06:28','608','2022-03-13 23:25:10',10),('5','102',257699,'Daily shift','2022-03-14','2022-03-14 21:40:25','2022-03-15 21:40:25','415',0.00,0.00,'415','2022-03-14 21:40:47','608','2022-03-15 10:51:54',10),('5','102',257700,'Daily shift','2022-03-15','2022-03-15 17:19:34','2022-03-16 17:19:34','415',0.00,0.00,'415','2022-03-15 17:19:52','608','2022-03-15 20:47:34',10),('5','102',257701,'Daily shift','2022-03-16','2022-03-16 12:17:17','2022-03-17 12:17:17','415',0.00,0.00,'415','2022-03-16 12:17:32','608','2022-03-16 22:26:43',10),('5','102',257702,'Daily shift','2022-03-17','2022-03-17 19:18:30','2022-03-18 19:18:30','415',0.00,0.00,'415','2022-03-17 19:18:48','608','2022-03-17 22:03:04',10),('5','102',257703,'Daily shift','2022-03-18','2022-03-18 18:32:30','2022-03-19 18:32:30','415',0.00,0.00,'415','2022-03-18 18:32:46','608','2022-03-19 22:50:16',10),('5','102',257704,'Daily shift','2022-03-19','2022-03-20 19:03:19','2022-03-21 19:03:19','415',0.00,0.00,'415','2022-03-20 19:03:39','608','2022-03-20 20:33:58',10),('5','102',257705,'Daily shift','2022-03-20','2022-03-22 09:50:01','2022-03-23 09:50:01','415',0.00,0.00,'415','2022-03-22 09:50:20','608','2022-03-22 16:05:56',10),('5','102',257706,'Daily shift','2022-03-21','2022-03-22 19:21:06','2022-03-23 19:21:06','415',0.00,0.00,'415','2022-03-22 19:21:19','608','2022-03-22 19:24:46',10),('5','102',257707,'Daily shift','2022-03-22','2022-03-22 19:26:52','2022-03-23 19:26:52','415',0.00,0.00,'415','2022-03-22 19:27:06','608','2022-03-23 14:00:04',10),('5','102',257708,'Daily shift','2022-03-23','2022-03-23 19:12:07','2022-03-24 19:12:07','415',0.00,0.00,'415','2022-03-23 19:12:31','795','2022-03-28 12:00:33',10),('5','102',257709,'Daily shift','2022-03-24','2022-03-28 14:25:46','2022-03-29 14:25:46','415',0.00,0.00,'415','2022-03-28 14:26:01','795','2022-03-28 14:29:11',10),('5','102',257710,'Daily shift','2022-03-25','2022-03-28 14:36:29','2022-03-29 14:36:29','415',0.00,0.00,'415','2022-03-28 14:36:54','795','2022-03-28 14:39:07',10),('5','102',257711,'Daily shift','2022-03-26','2022-03-28 14:44:43','2022-03-29 14:44:43','415',0.00,0.00,'415','2022-03-28 14:44:57','795','2022-03-28 14:48:53',10),('5','102',257712,'Daily shift','2022-03-27','2022-03-31 15:07:26','2022-04-01 15:07:26','415',864799.65,864799.65,'415','2022-03-31 15:08:25','795','2022-03-31 15:09:19',10),('5','102',257713,'Daily shift','2022-03-28','2022-03-31 15:16:22','2022-04-01 15:16:22','415',2769721.35,2769721.35,'415','2022-03-31 15:17:57','795','2022-03-31 15:19:21',10),('5','102',257714,'Daily shift','2022-03-29','2022-03-31 15:23:01','2022-04-01 15:23:01','415',1387942.05,1387942.05,'415','2022-03-31 15:24:47','795','2022-03-31 15:25:33',10),('5','102',257715,'Daily shift','2022-03-30','2022-03-31 15:26:47','2022-04-01 15:26:47','415',1221404.25,1221404.25,'415','2022-03-31 15:27:40','795','2022-03-31 15:29:15',10),('5','102',257716,'Daily shift','2022-03-31','2022-03-31 15:42:12','2022-04-01 15:42:12','415',368973.00,368973.00,'415','2022-04-01 07:44:34','795','2022-04-04 09:45:07',10),('5','102',257717,'Daily shift','2022-04-01','2022-04-04 11:40:52','2022-04-05 11:40:52','415',0.00,0.00,'415','2022-04-04 11:41:08','795','2022-04-04 12:28:51',10),('5','102',257718,'Daily shift','2022-04-02','2022-04-05 19:22:43','2022-04-06 19:22:43','415',0.00,0.00,'415','2022-04-05 19:23:18','795','2022-04-06 16:16:12',10),('5','102',257719,'Daily shift','2022-04-03','2022-04-06 16:17:17','2022-04-07 16:17:17','415',0.00,0.00,'415','2022-04-06 16:17:31','795','2022-04-06 16:17:41',10),('5','102',257720,'Daily shift','2022-04-04','2022-04-06 16:22:51','2022-04-07 16:22:51','415',0.00,0.00,'415','2022-04-06 16:23:27','795','2022-04-06 16:24:18',10),('5','102',257721,'Daily shift','2022-04-05','2022-04-06 16:26:10','2022-04-07 16:26:10','415',0.00,0.00,'415','2022-04-06 16:26:36','795','2022-04-06 16:26:55',10),('5','102',257722,'Daily shift','2022-04-06','2022-04-06 16:28:54','2022-04-07 16:28:54','415',0.00,0.00,'415','2022-04-06 16:29:09','795','2022-04-08 13:00:21',10),('5','102',257723,'Daily shift','2022-04-07','2022-04-08 13:59:52','2022-04-09 13:59:52','415',0.00,0.00,'415','2022-04-08 14:00:08','795','2022-04-10 10:43:31',10),('5','102',257724,'Daily shift','2022-04-08','2022-04-10 10:46:09','2022-04-11 10:46:09','415',0.00,0.00,'415','2022-04-10 10:46:23','795','2022-04-10 11:52:05',10),('5','102',257725,'Daily shift','2022-04-09','2022-04-10 12:01:58','2022-04-11 12:01:58','415',0.00,0.00,'415','2022-04-10 12:02:13','795','2022-04-10 12:02:43',10),('5','102',257726,'Daily shift','2022-04-10','2022-04-10 12:04:43','2022-04-11 12:04:43','415',0.00,0.00,'415','2022-04-11 09:17:44','795','2022-04-11 09:19:51',10),('5','102',257727,'Daily shift','2022-04-11','2022-04-13 09:53:51','2022-04-14 09:53:51','415',0.00,0.00,'415','2022-04-13 09:54:12','795','2022-04-13 10:09:10',10),('5','102',257728,'Daily shift','2022-04-12','2022-04-13 10:18:01','2022-04-14 10:18:01','415',0.00,0.00,'415','2022-04-13 10:18:14','795','2022-04-13 15:19:26',10),('5','102',257729,'Daily shift','2022-04-13','2022-04-13 19:00:17','2022-04-14 19:00:17','415',0.00,0.00,'415','2022-04-13 19:00:40','795','2022-04-14 20:40:18',10),('5','102',257730,'Daily shift','2022-04-14','2022-04-15 20:35:49','2022-04-16 20:35:49','415',0.00,0.00,'415','2022-04-15 20:36:14','795','2022-04-16 10:50:02',10),('5','102',257731,'Daily shift','2022-04-15','2022-04-18 13:36:30','2022-04-19 13:36:30','415',0.00,0.00,'415','2022-04-18 13:37:00','795','2022-04-18 17:25:38',10),('5','102',257732,'Daily shift','2022-04-16','2022-04-18 21:41:14','2022-04-19 21:41:14','415',0.00,0.00,'415','2022-04-18 21:41:36','795','2022-04-18 21:42:06',10),('5','102',257733,'Daily shift','2022-04-17','2022-04-18 21:43:11','2022-04-19 21:43:11','415',0.00,0.00,'415','2022-04-18 21:43:33','795','2022-04-18 22:07:40',10),('5','102',257734,'Daily shift','2022-04-18','2022-04-18 22:10:25','2022-04-19 22:10:25','415',0.00,0.00,'415','2022-04-18 22:11:03','795','2022-04-19 10:15:59',10),('5','102',257735,'Daily shift','2022-04-19','2022-04-19 10:27:24','2022-04-20 10:27:24','415',0.00,0.00,'415','2022-04-20 10:08:56','795','2022-04-20 13:18:14',10),('5','102',257736,'Daily shift','2022-04-20','2022-04-20 16:14:31','2022-04-21 16:14:31','415',0.00,0.00,'415','2022-04-21 11:16:28','795','2022-04-21 23:56:12',10),('5','102',257737,'Daily shift','2022-04-21','2022-04-22 00:00:39','2022-04-23 00:00:39','415',0.00,0.00,'415','2022-04-22 00:01:09','795','2022-04-22 00:02:52',10),('5','102',257738,'Daily shift','2022-04-22','2022-04-22 00:05:12','2022-04-23 00:05:12','415',0.00,0.00,'415','2022-04-23 21:24:16','795','2022-04-24 14:42:30',10),('5','102',257739,'Daily shift','2022-04-23','2022-04-25 12:11:03','2022-04-26 12:11:03','415',0.00,0.00,'415','2022-04-25 12:11:24','795','2022-04-25 12:38:14',10),('5','102',257740,'Daily shift','2022-04-24','2022-04-25 12:38:41','2022-04-26 12:38:41','415',0.00,0.00,'415','2022-04-25 12:38:58','795','2022-04-25 12:42:03',10),('5','102',257741,'Daily shift','2022-04-25','2022-04-25 12:42:51','2022-04-26 12:42:51','415',0.00,0.00,'415','2022-04-25 20:05:28','795','2022-04-26 09:14:18',10),('5','102',257742,'Daily shift','2022-04-26','2022-04-27 09:55:47','2022-04-28 09:55:47','415',0.00,0.00,'415','2022-04-27 09:56:06','795','2022-04-27 11:52:48',10),('5','102',257743,'Daily shift','2022-04-27','2022-04-28 07:47:45','2022-04-29 07:47:45','415',0.00,0.00,'415','2022-04-28 07:48:01','795','2022-04-29 10:23:26',10),('5','102',257744,'Daily shift','2022-04-29','2022-05-10 11:12:58','2022-05-11 11:12:58','415',776656.65,776656.65,'415','2022-05-10 11:14:27','795','2022-05-10 11:18:41',10),('5','102',257745,'Daily shifte','2022-04-30','2022-05-10 11:19:46','2022-05-11 11:19:46','415',663465.00,663465.00,'415','2022-05-10 11:21:03','795','2022-05-10 11:21:45',10),('5','102',257746,'Daily shift','2022-05-01','2022-05-10 11:31:13','2022-05-11 11:31:13','415',696003.00,696003.00,'415','2022-05-10 11:32:49','795','2022-05-10 11:35:21',10),('5','102',257747,'Daily shift','2022-05-02','2022-05-10 11:38:00','2022-05-11 11:38:00','415',770182.05,770182.05,'415','2022-05-10 11:39:25','795','2022-05-10 11:40:56',10),('5','102',257748,'Daily shift','2022-05-03','2022-05-10 11:41:58','2022-05-11 11:41:58','415',693099.00,693099.00,'415','2022-05-10 11:42:48','795','2022-05-10 11:44:48',10),('5','102',257749,'Daily shift','2022-05-04','2022-05-10 11:46:33','2022-05-11 11:46:33','415',727928.85,727928.85,'415','2022-05-10 11:47:32','795','2022-05-10 11:48:30',10),('5','102',257750,'Daily shift','2022-05-05','2022-05-10 11:49:01','2022-05-11 11:49:01','415',689470.65,689470.65,'415','2022-05-10 11:49:51','795','2022-05-10 11:50:28',10),('5','102',257751,'Daily shift','2022-05-06','2022-05-10 11:51:21','2022-05-11 11:51:21','415',1032546.90,1032546.90,'415','2022-05-10 11:52:06','795','2022-05-10 11:53:14',10),('5','102',257752,'Daily shift','2022-05-07','2022-05-10 11:54:10','2022-05-11 11:54:10','415',554434.65,554434.65,'415','2022-05-10 11:55:21','795','2022-05-10 11:56:00',10),('5','102',257753,'Daily shift','2022-05-08','2022-05-10 12:00:59','2022-05-11 12:00:59','415',0.00,0.00,'415','2022-05-10 12:01:13','795','2022-05-10 12:02:30',10),('5','102',257754,'Daily shift','2022-05-09','2022-05-10 12:03:12','2022-05-11 12:03:12','415',0.00,0.00,'415','2022-05-10 12:03:25','795','2022-05-10 12:04:09',10),('5','102',257755,'Daily shift','2022-05-10','2022-05-10 12:10:36','2022-05-11 12:10:36','415',0.00,0.00,'415','2022-05-10 19:15:59','795','2022-05-11 09:37:53',10),('5','102',257756,'Daily shift','2022-05-11','2022-05-12 14:58:03','2022-05-13 14:58:03','415',0.00,0.00,'415','2022-05-12 14:58:25','795','2022-05-13 11:00:22',10),('5','102',257757,'Daily shift','2022-05-12','2022-05-13 16:42:49','2022-05-14 16:42:49','415',0.00,0.00,'415','2022-05-13 16:43:07','795','2022-05-14 15:33:01',10),('5','102',257758,'Daily shift','2022-05-13','2022-05-15 07:53:53','2022-05-16 07:53:53','415',0.00,0.00,'415','2022-05-15 07:54:16','795','2022-05-15 13:52:07',10),('5','102',257759,'Daily shift','2022-05-14','2022-05-16 09:32:14','2022-05-17 09:32:14','415',0.00,0.00,'415','2022-05-16 09:32:33','795','2022-05-16 09:40:33',10),('5','102',257760,'Daily shift','2022-05-15','2022-05-16 09:44:16','2022-05-17 09:44:16','415',0.00,0.00,'415','2022-05-16 09:44:33','795','2022-05-16 10:23:46',10),('5','102',257761,'Daily shift','2022-05-16','2022-05-16 13:19:05','2022-05-17 13:19:05','415',0.00,0.00,'415','2022-05-16 20:07:41','795','2022-05-17 09:29:55',10),('5','102',257762,'Daily shift','2022-05-17','2022-05-17 10:13:07','2022-05-18 10:13:07','415',0.00,0.00,'415','2022-05-19 11:04:27','795','2022-05-19 12:10:59',10),('5','102',257763,'Daily shift','2022-05-18','2022-05-19 15:49:42','2022-05-20 15:49:42','415',0.00,0.00,'415','2022-05-19 15:50:01','795','2022-05-20 10:09:23',10),('5','102',257764,'Daily shift','2022-05-19','2022-05-20 18:17:13','2022-05-21 18:17:13','415',0.00,0.00,'415','2022-05-20 18:17:30','795','2022-05-23 13:07:22',10),('5','102',257765,'Daily shift','2022-05-20','2022-05-23 13:16:02','2022-05-24 13:16:02','415',0.00,0.00,'415','2022-05-23 13:16:20','795','2022-05-23 13:18:08',10),('5','102',257766,'Daily shift','2022-05-21','2022-05-23 13:18:56','2022-05-24 13:18:56','415',0.00,0.00,'415','2022-05-23 13:19:13','795','2022-05-23 13:19:36',10),('5','102',257767,'Daily shift','2022-05-22','2022-05-23 13:23:58','2022-05-24 13:23:58','415',0.00,0.00,'415','2022-05-23 13:24:16','795','2022-05-23 13:33:18',10),('5','102',257768,'Daily shift','2022-05-23','2022-05-23 13:40:00','2022-05-24 13:40:00','415',0.00,0.00,'415','2022-05-24 10:45:22','795','2022-05-24 11:00:27',10),('5','102',257769,'Daily shift','2022-05-24','2022-05-25 09:30:51','2022-05-26 09:30:51','415',0.00,0.00,'415','2022-05-25 09:31:08','795','2022-05-25 09:31:40',10),('5','102',257770,'Daily shift','2022-05-25','2022-05-26 07:31:37','2022-05-27 07:31:37','415',0.00,0.00,'415','2022-05-26 07:32:04','795','2022-05-26 10:34:53',10),('5','102',257771,'Daily shift','2022-05-26','2022-05-26 19:05:13','2022-05-27 19:05:13','415',0.00,0.00,'415','2022-05-26 19:05:32','795','2022-05-26 23:16:33',10),('5','102',257772,'Daily shift','2022-05-27','2022-05-28 22:06:37','2022-05-29 22:06:37','415',0.00,0.00,'415','2022-05-28 22:07:36','795','2022-05-28 22:37:31',10),('5','102',257773,'Daily shift','2022-05-28','2022-05-29 22:03:53','2022-05-30 22:03:53','415',0.00,0.00,'415','2022-05-29 22:04:13','795','2022-05-30 11:11:03',10),('5','102',257774,'Daily shift','2022-05-29','2022-05-30 12:37:43','2022-05-31 12:37:43','415',0.00,0.00,'415','2022-05-30 12:38:14','795','2022-05-30 13:30:38',10),('5','102',257775,'Daily shift','2022-05-30','2022-05-30 17:47:50','2022-05-31 17:47:50','415',0.00,0.00,'415','2022-05-30 17:48:07','795','2022-05-31 09:45:15',10),('5','102',257776,'Daily shift','2022-05-31','2022-05-31 21:57:22','2022-06-01 21:57:22','415',0.00,0.00,'415','2022-05-31 21:57:38','795','2022-06-02 10:19:23',10),('5','102',257777,'Daily shift','2022-06-01','2022-06-03 09:59:40','2022-06-04 09:59:40','415',0.00,0.00,'415','2022-06-03 10:00:06','795','2022-06-03 10:00:39',10),('5','102',257778,'Daily shift','2022-06-02','2022-06-03 10:03:35','2022-06-04 10:03:35','415',0.00,0.00,'415','2022-06-03 10:03:50','795','2022-06-03 10:07:06',10),('5','102',257779,'Daily shift','2022-06-03','2022-06-04 15:19:45','2022-06-05 15:19:45','415',0.00,0.00,'415','2022-06-04 15:20:06','795','2022-06-04 15:21:09',10),('5','102',257780,'Daily shift','2022-06-04','2022-06-06 07:15:34','2022-06-07 07:15:34','415',0.00,0.00,'415','2022-06-06 07:15:52','795','2022-06-06 08:56:54',10),('5','102',257781,'Daily shift','2022-06-05','2022-06-06 09:00:52','2022-06-07 09:00:52','415',0.00,0.00,'415','2022-06-06 09:01:12','795','2022-06-06 09:11:59',10),('5','102',257782,'Daily shift','2022-06-06','2022-06-07 12:21:15','2022-06-08 12:21:15','415',0.00,0.00,'415','2022-06-07 12:21:33','795','2022-06-07 12:37:46',10),('5','102',257783,'Daily shift','2022-06-07','2022-06-08 08:42:33','2022-06-09 08:42:33','415',0.00,0.00,'415','2022-06-08 08:44:32','795','2022-06-08 09:45:56',10),('5','102',257784,'Daily shift','2022-06-08','2022-06-09 18:38:57','2022-06-10 18:38:57','415',0.00,0.00,'415','2022-06-09 18:39:13','795','2022-06-09 19:36:12',10),('5','102',257785,'Daily shift','2022-06-09','2022-06-12 16:24:30','2022-06-13 16:24:30','415',0.00,0.00,'415','2022-06-12 16:24:51','795','2022-06-12 16:25:48',10),('5','102',257786,'Daily shift','2022-06-10','2022-06-12 16:26:28','2022-06-13 16:26:28','415',0.00,0.00,'415','2022-06-12 16:26:42','795','2022-06-12 16:27:14',10),('5','102',257787,'Daily shift','2022-06-11','2022-06-12 16:28:57','2022-06-13 16:28:57','415',0.00,0.00,'415','2022-06-12 16:29:12','795','2022-06-12 16:30:16',10),('5','102',257788,'Daily shift','2022-06-12','2022-06-13 13:06:40','2022-06-14 13:06:40','415',0.00,0.00,'415','2022-06-13 13:06:57','795','2022-06-13 21:38:34',10),('5','102',257789,'Daily shift','2022-06-13','2022-06-13 22:06:55','2022-06-14 22:06:55','415',0.00,0.00,'415','2022-06-13 22:07:18','795','2022-06-14 08:57:21',10),('5','102',257790,'Daily shift','2022-06-14','2022-06-15 09:35:47','2022-06-16 09:35:47','415',0.00,0.00,'415','2022-06-15 09:36:25','795','2022-06-15 12:04:40',10),('5','102',257791,'Daily shift','2022-06-15','2022-06-16 10:24:35','2022-06-17 10:24:35','415',0.00,0.00,'415','2022-06-16 10:24:50','795','2022-06-16 13:44:34',10),('5','102',257792,'Daily shift','2022-06-16','2022-06-17 17:04:56','2022-06-18 17:04:56','415',0.00,0.00,'415','2022-06-17 17:05:12','795','2022-06-17 19:36:26',10),('5','102',257793,'Daily shift','2022-06-17','2022-06-17 20:14:59','2022-06-18 20:14:59','415',0.00,0.00,'415','2022-06-17 20:15:30','795','2022-06-18 17:59:29',10),('5','102',257794,'Daily shift','2022-06-18','2022-06-18 21:01:18','2022-06-19 21:01:18','415',0.00,0.00,'415','2022-06-18 21:01:35','795','2022-06-19 14:56:19',10),('5','102',257795,'Daily shift','2022-06-19','2022-06-19 19:21:25','2022-06-20 19:21:25','415',0.00,0.00,'415','2022-06-19 19:22:03','795','2022-06-20 09:18:57',10);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4907486 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('5','102','632','213197',4129204,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','213197',4129205,'1754','249',943003.38,943257.57,254.19,41941.35,0.00,0.00,0.00,0.00,0.00),('5','102','631','213197',4129206,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','213197',4129207,'1756','249',949384.65,949744.58,359.93,59388.45,0.00,0.00,0.00,0.00,0.00),('5','102','633','213197',4129208,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','213197',4129209,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','213205',4129348,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','213205',4129349,'1754','249',943257.57,943793.69,536.12,88459.80,0.00,0.00,0.00,0.00,0.00),('5','102','631','213205',4129350,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','213205',4129351,'1756','249',949744.58,951499.63,1755.05,289583.25,0.00,0.00,0.00,0.00,0.00),('5','102','633','213205',4129352,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','213205',4129353,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','213306',4130978,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','213306',4130979,'1754','249',943793.69,944884.02,1090.33,179904.45,0.00,0.00,0.00,0.00,0.00),('5','102','631','213306',4130980,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','213306',4130981,'1756','249',951499.63,952103.18,603.55,99585.75,0.00,0.00,0.00,0.00,0.00),('5','102','633','213306',4130982,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','213306',4130983,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','213382',4132355,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','213382',4132356,'1754','249',944884.02,945437.03,553.01,91246.65,0.00,0.00,0.00,0.00,0.00),('5','102','631','213382',4132357,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','213382',4132358,'1756','249',952103.18,952955.58,852.40,140646.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','213382',4132359,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','213382',4132360,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','213448',4133256,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','213448',4133257,'1754','249',945437.03,946460.78,1023.75,168918.75,0.00,0.00,0.00,0.00,0.00),('5','102','631','213448',4133258,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','213448',4133259,'1756','249',952955.58,953758.61,803.03,132499.95,0.00,0.00,0.00,0.00,0.00),('5','102','633','213448',4133260,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','213448',4133261,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','213625',4136366,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','213625',4136367,'1754','249',946460.78,947162.46,701.68,115777.20,0.00,0.00,0.00,0.00,0.00),('5','102','631','213625',4136368,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','213625',4136369,'1756','249',953758.61,954615.68,857.07,141416.55,0.00,0.00,0.00,0.00,0.00),('5','102','633','213625',4136370,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','213625',4136371,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','213884',4140598,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','213884',4140599,'1754','249',947162.46,948121.95,959.49,158315.85,0.00,0.00,0.00,0.00,0.00),('5','102','631','213884',4140600,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','213884',4140601,'1756','249',954615.68,955249.95,634.27,104654.55,0.00,0.00,0.00,0.00,0.00),('5','102','633','213884',4140602,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','213884',4140603,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','214101',4144168,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','214101',4144169,'1754','249',948121.95,949518.31,1396.36,230399.40,0.00,0.00,0.00,0.00,0.00),('5','102','631','214101',4144170,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','214101',4144171,'1756','249',955249.95,955719.24,469.29,77432.85,0.00,0.00,0.00,0.00,0.00),('5','102','633','214101',4144172,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','214101',4144173,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','214310',4148031,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','214310',4148032,'1754','249',949518.31,950595.28,1076.97,177700.05,0.00,0.00,0.00,0.00,0.00),('5','102','631','214310',4148033,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','214310',4148034,'1756','249',955719.24,956588.19,868.95,143376.75,0.00,0.00,0.00,0.00,0.00),('5','102','633','214310',4148035,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','214310',4148036,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','214529',4151557,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','214529',4151558,'1754','249',950595.28,951407.34,812.06,133989.90,0.00,0.00,0.00,0.00,0.00),('5','102','631','214529',4151559,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','214529',4151560,'1756','249',956588.19,957391.00,802.81,132463.65,0.00,0.00,0.00,0.00,0.00),('5','102','633','214529',4151561,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','214529',4151562,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','214532',4151580,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','214532',4151581,'1754','249',951407.34,952298.52,891.18,147044.70,0.00,0.00,0.00,0.00,0.00),('5','102','631','214532',4151582,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','214532',4151583,'1756','249',957391.00,958158.36,767.36,126614.40,0.00,0.00,0.00,0.00,0.00),('5','102','633','214532',4151584,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','214532',4151585,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','214949',4158826,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','214949',4158827,'1754','249',952298.52,953433.42,1134.90,187258.50,0.00,0.00,0.00,0.00,0.00),('5','102','631','214949',4158828,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','214949',4158829,'1756','249',958158.36,959497.65,1339.29,220982.85,0.00,0.00,0.00,0.00,0.00),('5','102','633','214949',4158830,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','214949',4158831,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','215106',4161363,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','215106',4161364,'1754','249',953433.42,954397.69,964.27,159104.55,0.00,0.00,0.00,0.00,0.00),('5','102','631','215106',4161365,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','215106',4161366,'1756','249',959497.65,960679.26,1181.61,194965.65,0.00,0.00,0.00,0.00,0.00),('5','102','633','215106',4161367,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','215106',4161368,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','215351',4165557,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','215351',4165558,'1754','249',954397.69,955743.33,1345.64,222030.60,0.00,0.00,0.00,0.00,0.00),('5','102','631','215351',4165559,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','215351',4165560,'1756','249',960679.26,961604.92,925.66,152733.90,0.00,0.00,0.00,0.00,0.00),('5','102','633','215351',4165561,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','215351',4165562,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','215654',4170800,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','215654',4170801,'1754','249',955743.33,956507.99,764.66,126168.90,0.00,0.00,0.00,0.00,0.00),('5','102','631','215654',4170802,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','215654',4170803,'1756','249',961604.92,962644.27,1039.35,171492.75,0.00,0.00,0.00,0.00,0.00),('5','102','633','215654',4170804,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','215654',4170805,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','215881',4174712,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','215881',4174713,'1754','249',956507.99,956507.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','215881',4174714,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','215881',4174715,'1756','249',962644.27,964366.46,1722.19,284161.35,0.00,0.00,0.00,0.00,0.00),('5','102','633','215881',4174716,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','215881',4174717,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','216076',4178132,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','216076',4178133,'1754','249',956507.99,956507.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','216076',4178134,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','216076',4178135,'1756','249',964366.46,965817.05,1450.59,239347.35,0.00,0.00,0.00,0.00,0.00),('5','102','633','216076',4178136,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','216076',4178137,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','216309',4182191,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','216309',4182192,'1754','249',956507.99,956507.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','216309',4182193,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','216309',4182194,'1756','249',965817.05,967578.48,1761.43,290635.95,0.00,0.00,0.00,0.00,0.00),('5','102','633','216309',4182195,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','216309',4182196,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','216533',4186035,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','216533',4186036,'1754','249',956507.99,956507.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','216533',4186037,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','216533',4186038,'1756','249',967578.48,969441.10,1862.62,307332.30,0.00,0.00,0.00,0.00,0.00),('5','102','633','216533',4186039,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','216533',4186040,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','216627',4187361,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','216627',4187362,'1754','249',956507.99,956507.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','216627',4187363,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','216627',4187364,'1756','249',969441.10,971331.11,1890.01,311851.65,0.00,0.00,0.00,0.00,0.00),('5','102','633','216627',4187365,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','216627',4187366,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','216993',4194170,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','216993',4194171,'1754','249',956507.99,956507.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','216993',4194172,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','216993',4194173,'1756','249',971331.11,973405.07,2073.96,342203.40,0.00,0.00,0.00,0.00,0.00),('5','102','633','216993',4194174,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','216993',4194175,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','217151',4196724,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','217151',4196725,'1754','249',956507.99,956507.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','217151',4196726,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','217151',4196727,'1756','249',973405.07,975346.33,1941.26,320307.90,0.00,0.00,0.00,0.00,0.00),('5','102','633','217151',4196728,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','217151',4196729,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','217463',4202551,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','217463',4202552,'1754','249',956507.99,956848.55,340.56,56192.40,0.00,0.00,0.00,0.00,0.00),('5','102','631','217463',4202553,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','217463',4202554,'1756','249',975346.33,976099.63,753.30,124294.50,0.00,0.00,0.00,0.00,0.00),('5','102','633','217463',4202555,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','217463',4202556,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','217650',4205928,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','217650',4205929,'1754','249',956848.55,957619.00,770.45,127124.25,0.00,0.00,0.00,0.00,0.00),('5','102','631','217650',4205930,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','217650',4205931,'1756','249',976099.63,976695.76,596.13,98361.45,0.00,0.00,0.00,0.00,0.00),('5','102','633','217650',4205932,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','217650',4205933,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','217835',4209062,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','217835',4209063,'1754','249',957619.00,958434.85,815.85,134615.25,0.00,0.00,0.00,0.00,0.00),('5','102','631','217835',4209064,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','217835',4209065,'1756','249',976695.76,977754.24,1058.48,174649.20,0.00,0.00,0.00,0.00,0.00),('5','102','633','217835',4209066,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','217835',4209067,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','218124',4214014,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','218124',4214015,'1754','249',958434.85,959115.66,680.81,112333.65,0.00,0.00,0.00,0.00,0.00),('5','102','631','218124',4214016,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','218124',4214017,'1756','249',977754.24,978444.32,690.08,113863.20,0.00,0.00,0.00,0.00,0.00),('5','102','633','218124',4214018,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','218124',4214019,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','218299',4217101,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','218299',4217102,'1754','249',959115.66,959993.22,877.56,144797.40,0.00,0.00,0.00,0.00,0.00),('5','102','631','218299',4217103,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','218299',4217104,'1756','249',978444.32,979107.35,663.03,109399.95,0.00,0.00,0.00,0.00,0.00),('5','102','633','218299',4217105,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','218299',4217106,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','218652',4223658,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','218652',4223659,'1754','249',959993.22,960657.09,663.87,109538.55,0.00,0.00,0.00,0.00,0.00),('5','102','631','218652',4223660,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','218652',4223661,'1756','249',979107.35,979994.09,886.74,146312.10,0.00,0.00,0.00,0.00,0.00),('5','102','633','218652',4223662,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','218652',4223663,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','218677',4223997,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','218677',4223998,'1754','249',960657.09,961352.87,695.78,114803.70,0.00,0.00,0.00,0.00,0.00),('5','102','631','218677',4223999,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','218677',4224000,'1756','249',979994.09,980537.22,543.13,89616.45,0.00,0.00,0.00,0.00,0.00),('5','102','633','218677',4224001,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','218677',4224002,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','218901',4227976,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','218901',4227977,'1754','249',961352.87,961795.32,442.45,73004.25,0.00,0.00,0.00,0.00,0.00),('5','102','631','218901',4227978,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','218901',4227979,'1756','249',980537.22,981710.65,1173.43,193615.95,0.00,0.00,0.00,0.00,0.00),('5','102','633','218901',4227980,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','218901',4227981,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','219317',4235194,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','219317',4235195,'1754','249',961795.32,962427.96,632.64,104385.60,0.00,0.00,0.00,0.00,0.00),('5','102','631','219317',4235196,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','219317',4235197,'1756','249',981710.65,982380.40,669.75,110508.75,0.00,0.00,0.00,0.00,0.00),('5','102','633','219317',4235198,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','219317',4235199,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','219570',4239562,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','219570',4239563,'1754','249',962427.96,963169.16,741.20,122298.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','219570',4239564,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','219570',4239565,'1756','249',982380.40,983041.14,660.74,109022.10,0.00,0.00,0.00,0.00,0.00),('5','102','633','219570',4239566,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','219570',4239567,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','219757',4242851,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','219757',4242852,'1754','249',963169.16,963877.88,708.72,116938.80,0.00,0.00,0.00,0.00,0.00),('5','102','631','219757',4242853,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','219757',4242854,'1756','249',983041.14,983786.15,745.01,122926.65,0.00,0.00,0.00,0.00,0.00),('5','102','633','219757',4242855,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','219757',4242856,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','219869',4244626,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','219869',4244627,'1754','249',963877.88,964614.28,736.40,121506.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','219869',4244628,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','219869',4244629,'1756','249',983786.15,984579.82,793.67,130955.55,0.00,0.00,0.00,0.00,0.00),('5','102','633','219869',4244630,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','219869',4244631,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','220022',4247738,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','220022',4247739,'1754','249',964614.28,965103.70,489.42,80754.30,0.00,0.00,0.00,0.00,0.00),('5','102','631','220022',4247740,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','220022',4247741,'1756','249',984579.82,985653.51,1073.69,177158.85,0.00,0.00,0.00,0.00,0.00),('5','102','633','220022',4247742,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','220022',4247743,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','220290',4252066,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','220290',4252067,'1754','249',965103.70,966036.03,932.33,153834.45,0.00,0.00,0.00,0.00,0.00),('5','102','631','220290',4252068,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','220290',4252069,'1756','249',985653.51,986416.68,763.17,125923.05,0.00,0.00,0.00,0.00,0.00),('5','102','633','220290',4252070,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','220290',4252071,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','220485',4255727,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','220485',4255728,'1754','249',966036.03,966792.27,756.24,124779.60,0.00,0.00,0.00,0.00,0.00),('5','102','631','220485',4255729,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','220485',4255730,'1756','249',986416.68,987375.59,958.91,158220.15,0.00,0.00,0.00,0.00,0.00),('5','102','633','220485',4255731,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','220485',4255732,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','220844',4262107,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','220844',4262108,'1754','249',966792.27,967502.29,710.02,117153.30,0.00,0.00,0.00,0.00,0.00),('5','102','631','220844',4262109,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','220844',4262110,'1756','249',987375.59,988001.79,626.20,103323.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','220844',4262111,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','220844',4262112,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','220902',4263216,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','220902',4263217,'1754','249',967502.29,968255.55,753.26,124287.90,0.00,0.00,0.00,0.00,0.00),('5','102','631','220902',4263218,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','220902',4263219,'1756','249',988001.79,988738.82,737.03,121609.95,0.00,0.00,0.00,0.00,0.00),('5','102','633','220902',4263220,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','220902',4263221,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','221132',4267287,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','221132',4267288,'1754','249',968255.55,969031.83,776.28,128086.20,0.00,0.00,0.00,0.00,0.00),('5','102','631','221132',4267289,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','221132',4267290,'1756','249',988738.82,989405.50,666.68,110002.20,0.00,0.00,0.00,0.00,0.00),('5','102','633','221132',4267291,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','221132',4267292,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','221459',4272913,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','221459',4272914,'1754','249',969031.83,969418.11,386.28,63736.20,0.00,0.00,0.00,0.00,0.00),('5','102','631','221459',4272915,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','221459',4272916,'1756','249',989405.50,990740.98,1335.48,220354.20,0.00,0.00,0.00,0.00,0.00),('5','102','633','221459',4272917,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','221459',4272918,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','221657',4276605,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','221657',4276606,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','221657',4276607,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','221657',4276608,'1756','249',990740.98,992611.99,1871.01,308716.65,0.00,0.00,0.00,0.00,0.00),('5','102','633','221657',4276609,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','221657',4276610,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','221996',4282830,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','221996',4282831,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','221996',4282832,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','221996',4282833,'1756','249',992611.99,994145.88,1533.89,253091.85,0.00,0.00,0.00,0.00,0.00),('5','102','633','221996',4282834,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','221996',4282835,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','222204',4286467,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','222204',4286468,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','222204',4286469,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','222204',4286470,'1756','249',994145.88,995446.60,1300.72,214618.80,0.00,0.00,0.00,0.00,0.00),('5','102','633','222204',4286471,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','222204',4286472,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','222302',4287850,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','222302',4287851,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','222302',4287852,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','222302',4287853,'1756','249',995446.60,996347.69,901.09,148679.85,0.00,0.00,0.00,0.00,0.00),('5','102','633','222302',4287854,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','222302',4287855,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','222615',4293429,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','222615',4293430,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','222615',4293431,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','222615',4293432,'1756','249',996347.69,997721.83,1374.14,226733.10,0.00,0.00,0.00,0.00,0.00),('5','102','633','222615',4293433,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','222615',4293434,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','222874',4298419,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','222874',4298420,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','222874',4298421,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','222874',4298422,'1756','249',997721.83,998231.80,509.97,84145.05,0.00,0.00,0.00,0.00,0.00),('5','102','633','222874',4298423,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','222874',4298424,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','223009',4300895,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','223009',4300896,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','223009',4300897,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','223009',4300898,'1756','249',998231.80,999311.42,1079.62,178137.30,0.00,0.00,0.00,0.00,0.00),('5','102','633','223009',4300899,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','223009',4300900,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','223295',4305432,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','223295',4305433,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','223295',4305434,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','223295',4305435,'1756','249',999311.42,1000549.20,1237.78,204233.70,0.00,0.00,0.00,0.00,0.00),('5','102','633','223295',4305436,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','223295',4305437,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','223490',4309115,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','223490',4309116,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','223490',4309117,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','223490',4309118,'1756','249',1000549.20,1001245.53,696.33,114894.45,0.00,0.00,0.00,0.00,0.00),('5','102','633','223490',4309119,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','223490',4309120,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','223746',4313932,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','223746',4313933,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','223746',4313934,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','223746',4313935,'1756','249',1001245.53,1002178.58,933.05,153953.25,0.00,0.00,0.00,0.00,0.00),('5','102','633','223746',4313936,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','223746',4313937,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','224047',4319464,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','224047',4319465,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','224047',4319466,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','224047',4319467,'1756','249',1002178.58,1002840.57,661.99,109228.35,0.00,0.00,0.00,0.00,0.00),('5','102','633','224047',4319468,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','224047',4319469,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','224357',4324748,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','224357',4324749,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','224357',4324750,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','224357',4324751,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','224357',4324752,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','224357',4324753,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','224859',4333539,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','224859',4333540,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','224859',4333541,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','224859',4333542,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','224859',4333543,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','224859',4333544,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','225083',4337557,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','225083',4337558,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','225083',4337559,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','225083',4337560,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','225083',4337561,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','225083',4337562,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','225917',4352634,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','225917',4352635,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','225917',4352636,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','225917',4352637,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','225917',4352638,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','225917',4352639,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','225931',4352830,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','225931',4352831,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','225931',4352832,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','225931',4352833,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','225931',4352834,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','225931',4352835,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','225933',4352854,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','225933',4352855,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','225933',4352856,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','225933',4352857,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','225933',4352858,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','225933',4352859,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','225969',4353342,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','225969',4353343,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','225969',4353344,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','225969',4353345,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','225969',4353346,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','225969',4353347,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','226334',4359966,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','226334',4359967,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','226334',4359968,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','226334',4359969,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','226334',4359970,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','226334',4359971,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','226543',4363552,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','226543',4363553,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','226543',4363554,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','226543',4363555,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','226543',4363556,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','226543',4363557,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','226877',4369909,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','226877',4369910,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','226877',4369911,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','226877',4369912,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','226877',4369913,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','226877',4369914,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','227023',4372237,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','227023',4372238,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','227023',4372239,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','227023',4372240,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','227023',4372241,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','227023',4372242,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','227263',4376394,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','227263',4376395,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','227263',4376396,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','227263',4376397,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','227263',4376398,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','227263',4376399,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','227398',4378841,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','227398',4378842,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','227398',4378843,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','227398',4378844,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','227398',4378845,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','227398',4378846,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','227808',4386337,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','227808',4386338,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','227808',4386339,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','227808',4386340,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','227808',4386341,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','227808',4386342,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','228091',4391671,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','228091',4391672,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','228091',4391673,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','228091',4391674,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','228091',4391675,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','228091',4391676,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','229399',4416224,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','229399',4416225,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','229399',4416226,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','229399',4416227,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','229399',4416228,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','229399',4416229,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','232413',4470322,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','232413',4470323,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','232413',4470324,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','232413',4470325,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','232413',4470326,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','232413',4470327,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','232714',4475916,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','232714',4475917,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','232714',4475918,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','232714',4475919,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','232714',4475920,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','232714',4475921,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','232715',4475922,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','232715',4475923,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','232715',4475924,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','232715',4475925,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','232715',4475926,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','232715',4475927,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','232782',4477466,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','232782',4477467,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','232782',4477468,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','232782',4477469,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','232782',4477470,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','232782',4477471,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','232783',4477472,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','232783',4477473,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','232783',4477474,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','232783',4477475,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','232783',4477476,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','232783',4477477,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','232790',4477591,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','232790',4477592,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','232790',4477593,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','232790',4477594,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','232790',4477595,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','232790',4477596,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','232791',4477597,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','232791',4477598,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','232791',4477599,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','232791',4477600,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','232791',4477601,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','232791',4477602,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','232794',4477637,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','232794',4477638,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','232794',4477639,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','232794',4477640,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','232794',4477641,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','232794',4477642,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','232797',4477671,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','232797',4477672,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','232797',4477673,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','232797',4477674,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','232797',4477675,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','232797',4477676,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','232800',4477720,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','232800',4477721,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','232800',4477722,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','232800',4477723,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','232800',4477724,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','232800',4477725,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','232801',4477726,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','232801',4477727,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','232801',4477728,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','232801',4477729,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','232801',4477730,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','232801',4477731,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','232803',4477747,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','232803',4477748,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','232803',4477749,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','232803',4477750,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','232803',4477751,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','232803',4477752,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','232804',4477753,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','232804',4477754,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','232804',4477755,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','232804',4477756,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','232804',4477757,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','232804',4477758,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','232809',4477830,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','232809',4477831,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','232809',4477832,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','232809',4477833,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','232809',4477834,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','232809',4477835,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','232811',4477848,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','232811',4477849,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','232811',4477850,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','232811',4477851,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','232811',4477852,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','232811',4477853,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','232812',4477854,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','232812',4477855,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','232812',4477856,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','232812',4477857,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','232812',4477858,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','232812',4477859,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','232814',4477880,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','232814',4477881,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','232814',4477882,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','232814',4477883,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','232814',4477884,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','232814',4477885,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','232816',4477904,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','232816',4477905,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','232816',4477906,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','232816',4477907,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','232816',4477908,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','232816',4477909,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','232817',4477910,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','232817',4477911,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','232817',4477912,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','232817',4477913,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','232817',4477914,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','232817',4477915,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','233066',4482318,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','233066',4482319,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','233066',4482320,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','233066',4482321,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','233066',4482322,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','233066',4482323,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','233316',4486915,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','233316',4486916,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','233316',4486917,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','233316',4486918,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','233316',4486919,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','233316',4486920,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','233569',4491532,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','233569',4491533,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','233569',4491534,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','233569',4491535,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','233569',4491536,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','233569',4491537,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','234241',4503459,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','234241',4503460,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','234241',4503461,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','234241',4503462,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','234241',4503463,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','234241',4503464,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','234273',4504141,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','234273',4504142,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','234273',4504143,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','234273',4504144,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','234273',4504145,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','234273',4504146,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','234274',4504147,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','234274',4504148,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','234274',4504149,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','234274',4504150,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','234274',4504151,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','234274',4504152,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','234769',4512910,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','234769',4512911,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','234769',4512912,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','234769',4512913,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','234769',4512914,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','234769',4512915,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','235450',4524915,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','235450',4524916,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','235450',4524917,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','235450',4524918,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','235450',4524919,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','235450',4524920,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','235701',4529253,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','235701',4529254,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','235701',4529255,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','235701',4529256,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','235701',4529257,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','235701',4529258,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','236569',4544430,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','236569',4544431,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','236569',4544432,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','236569',4544433,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','236569',4544434,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','236569',4544435,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','236598',4544984,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','236598',4544985,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','236598',4544986,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','236598',4544987,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','236598',4544988,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','236598',4544989,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','236657',4545959,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','236657',4545960,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','236657',4545961,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','236657',4545962,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','236657',4545963,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','236657',4545964,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','236660',4545980,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','236660',4545981,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','236660',4545982,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','236660',4545983,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','236660',4545984,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','236660',4545985,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','236661',4545986,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','236661',4545987,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','236661',4545988,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','236661',4545989,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','236661',4545990,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','236661',4545991,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','236664',4546010,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','236664',4546011,'1754','249',969418.11,969418.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','236664',4546012,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','236664',4546013,'1756','249',1002840.57,1002840.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','236664',4546014,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','236664',4546015,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','236665',4546016,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','236665',4546017,'1754','249',969418.11,970086.91,668.80,110352.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','236665',4546018,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','236665',4546019,'1756','249',1002840.57,1003708.00,867.43,143125.95,0.00,0.00,0.00,0.00,0.00),('5','102','633','236665',4546020,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','236665',4546021,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','238455',4576908,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','238455',4576909,'1754','249',970086.91,973362.63,3275.72,540493.80,0.00,0.00,0.00,0.00,0.00),('5','102','631','238455',4576910,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','238455',4576911,'1756','249',1003708.00,1009243.80,5535.80,913407.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','238455',4576912,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','238455',4576913,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','238458',4576923,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','238458',4576924,'1754','249',973362.63,978060.57,4697.94,775160.10,0.00,0.00,0.00,0.00,0.00),('5','102','631','238458',4576925,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','238458',4576926,'1756','249',1009243.80,1016285.29,7041.49,1161845.85,0.00,0.00,0.00,0.00,0.00),('5','102','633','238458',4576927,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','238458',4576928,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','238464',4577004,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','238464',4577005,'1754','249',978060.57,978060.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','238464',4577006,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','238464',4577007,'1756','249',1016285.29,1016285.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','238464',4577008,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','238464',4577009,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','238468',4577046,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','238468',4577047,'1754','249',978060.57,978060.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','238468',4577048,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','238468',4577049,'1756','249',1016285.29,1016285.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','238468',4577050,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','238468',4577051,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','239060',4587558,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','239060',4587559,'1754','249',978060.57,983106.51,5045.94,832580.10,0.00,0.00,0.00,0.00,0.00),('5','102','631','239060',4587560,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','239060',4587561,'1756','249',1016285.29,1024844.26,8558.97,1412230.05,0.00,0.00,0.00,0.00,0.00),('5','102','633','239060',4587562,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','239060',4587563,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','239187',4589675,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','239187',4589676,'1754','249',983106.51,983106.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','239187',4589677,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','239187',4589678,'1756','249',1024844.26,1029406.15,4561.89,752711.85,0.00,0.00,0.00,0.00,0.00),('5','102','633','239187',4589679,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','239187',4589680,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','239190',4589722,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','239190',4589723,'1754','249',983106.51,983106.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','239190',4589724,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','239190',4589725,'1756','249',1029406.15,1029406.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','239190',4589726,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','239190',4589727,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','239196',4589833,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','239196',4589834,'1754','249',983106.51,983106.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','239196',4589835,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','239196',4589836,'1756','249',1029406.15,1029406.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','239196',4589837,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','239196',4589838,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','239197',4589839,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','239197',4589840,'1754','249',983106.51,983106.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','239197',4589841,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','239197',4589842,'1756','249',1029406.15,1029406.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','239197',4589843,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','239197',4589844,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','239198',4589845,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','239198',4589846,'1754','249',983106.51,983106.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','239198',4589847,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','239198',4589848,'1756','249',1029406.15,1029406.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','239198',4589849,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','239198',4589850,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','239200',4589885,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','239200',4589886,'1754','249',983106.51,983106.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','239200',4589887,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','239200',4589888,'1756','249',1029406.15,1029406.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','239200',4589889,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','239200',4589890,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','239223',4590304,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','239223',4590305,'1754','249',983106.51,986214.91,3108.40,512886.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','239223',4590306,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','239223',4590307,'1756','249',1029406.15,1032336.27,2930.12,483469.80,0.00,0.00,0.00,0.00,0.00),('5','102','633','239223',4590308,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','239223',4590309,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','239224',4590310,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','239224',4590311,'1754','249',986214.91,989318.51,3103.60,512094.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','239224',4590312,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','239224',4590313,'1756','249',1032336.27,1035097.04,2760.77,455527.05,0.00,0.00,0.00,0.00,0.00),('5','102','633','239224',4590314,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','239224',4590315,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','239462',4594504,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','239462',4594505,'1754','249',989318.51,992043.64,2725.13,449646.45,0.00,0.00,0.00,0.00,0.00),('5','102','631','239462',4594506,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','239462',4594507,'1756','249',1035097.04,1036927.93,1830.89,302096.85,0.00,0.00,0.00,0.00,0.00),('5','102','633','239462',4594508,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','239462',4594509,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','239715',4598962,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','239715',4598963,'1754','249',992043.64,994262.97,2219.33,366189.45,0.00,0.00,0.00,0.00,0.00),('5','102','631','239715',4598964,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','239715',4598965,'1756','249',1036927.93,1039311.36,2383.43,393265.95,0.00,0.00,0.00,0.00,0.00),('5','102','633','239715',4598966,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','239715',4598967,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','239947',4602960,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','239947',4602961,'1754','249',994262.97,996458.26,2195.29,362222.85,0.00,0.00,0.00,0.00,0.00),('5','102','631','239947',4602962,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','239947',4602963,'1756','249',1039311.36,1041260.12,1948.76,321545.40,0.00,0.00,0.00,0.00,0.00),('5','102','633','239947',4602964,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','239947',4602965,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','240516',4612372,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','240516',4612373,'1754','249',996458.26,996616.53,158.27,26114.55,0.00,0.00,0.00,0.00,0.00),('5','102','631','240516',4612374,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','240516',4612375,'1756','249',1041260.12,1045053.79,3793.67,625955.55,0.00,0.00,0.00,0.00,0.00),('5','102','633','240516',4612376,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','240516',4612377,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','240518',4612404,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','240518',4612405,'1754','249',996616.53,996616.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','240518',4612406,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','240518',4612407,'1756','249',1045053.79,1048721.05,3667.26,605097.90,0.00,0.00,0.00,0.00,0.00),('5','102','633','240518',4612408,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','240518',4612409,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','240521',4612450,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','240521',4612451,'1754','249',996616.53,996616.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','240521',4612452,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','240521',4612453,'1756','249',1048721.05,1052362.69,3641.64,600870.60,0.00,0.00,0.00,0.00,0.00),('5','102','633','240521',4612454,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','240521',4612455,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','241609',4631000,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','241609',4631001,'1754','249',996616.53,996616.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','241609',4631002,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','241609',4631003,'1756','249',1052362.69,1055629.01,3266.32,538942.80,0.00,0.00,0.00,0.00,0.00),('5','102','633','241609',4631004,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','241609',4631005,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','241612',4631035,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','241612',4631036,'1754','249',996616.53,996616.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','241612',4631037,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','241612',4631038,'1756','249',1055629.01,1055905.60,276.59,45637.35,0.00,0.00,0.00,0.00,0.00),('5','102','633','241612',4631039,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','241612',4631040,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','242592',4648338,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','242592',4648339,'1754','249',996616.53,996616.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','242592',4648340,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','242592',4648341,'1756','249',1055905.60,1055905.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','242592',4648342,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','242592',4648343,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','242759',4651240,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','242759',4651241,'1754','249',996616.53,996616.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','242759',4651242,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','242759',4651243,'1756','249',1055905.60,1055905.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','242759',4651244,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','242759',4651245,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','242762',4651275,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','242762',4651276,'1754','249',996616.53,996616.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','242762',4651277,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','242762',4651278,'1756','249',1055905.60,1055905.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','242762',4651279,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','242762',4651280,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','242765',4651298,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','242765',4651299,'1754','249',996616.53,996616.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','242765',4651300,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','242765',4651301,'1756','249',1055905.60,1055905.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','242765',4651302,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','242765',4651303,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','242766',4651304,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','242766',4651305,'1754','249',996616.53,996616.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','242766',4651306,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','242766',4651307,'1756','249',1055905.60,1055905.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','242766',4651308,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','242766',4651309,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','242770',4651383,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','242770',4651384,'1754','249',996616.53,996616.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','242770',4651385,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','242770',4651386,'1756','249',1055905.60,1055905.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','242770',4651387,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','242770',4651388,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','243080',4656935,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','243080',4656936,'1754','249',996616.53,996616.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','243080',4656937,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','243080',4656938,'1756','249',1055905.60,1055905.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','243080',4656939,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','243080',4656940,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','243467',4663604,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','243467',4663605,'1754','249',996616.53,996616.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','243467',4663606,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','243467',4663607,'1756','249',1055905.60,1055905.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','243467',4663608,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','243467',4663609,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','243469',4663632,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','243469',4663633,'1754','249',996616.53,996616.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','243469',4663634,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','243469',4663635,'1756','249',1055905.60,1055905.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','243469',4663636,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','243469',4663637,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','243470',4663638,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','243470',4663639,'1754','249',996616.53,996616.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','243470',4663640,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','243470',4663641,'1756','249',1055905.60,1055905.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','243470',4663642,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','243470',4663643,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','243931',4671592,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','243931',4671593,'1754','249',996616.53,996616.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','243931',4671594,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','243931',4671595,'1756','249',1055905.60,1055905.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','243931',4671596,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','243931',4671597,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','244008',4673133,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','244008',4673134,'1754','249',996616.53,996616.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','244008',4673135,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','244008',4673136,'1756','249',1055905.60,1055905.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','244008',4673137,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','244008',4673138,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','244220',4676654,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','244220',4676655,'1754','249',996616.53,996616.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','244220',4676656,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','244220',4676657,'1756','249',1055905.60,1055905.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','244220',4676658,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','244220',4676659,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','244615',4683438,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','244615',4683439,'1754','249',996616.53,996616.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','244615',4683440,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','244615',4683441,'1756','249',1055905.60,1055905.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','244615',4683442,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','244615',4683443,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','244801',4686484,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','244801',4686485,'1754','249',996616.53,996616.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','244801',4686486,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','244801',4686487,'1756','249',1055905.60,1055905.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','244801',4686488,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','244801',4686489,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','245080',4691467,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','245080',4691468,'1754','249',996616.53,996616.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','245080',4691469,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','245080',4691470,'1756','249',1055905.60,1055905.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','245080',4691471,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','245080',4691472,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','245594',4700611,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','245594',4700612,'1754','249',996616.53,996616.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','245594',4700613,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','245594',4700614,'1756','249',1055905.60,1055905.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','245594',4700615,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','245594',4700616,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','245657',4701702,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','245657',4701703,'1754','249',996616.53,996616.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','245657',4701704,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','245657',4701705,'1756','249',1055905.60,1055905.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','245657',4701706,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','245657',4701707,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','245750',4703163,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','245750',4703164,'1754','249',996616.53,996616.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','245750',4703165,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','245750',4703166,'1756','249',1055905.60,1055905.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','245750',4703167,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','245750',4703168,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','245828',4704492,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','245828',4704493,'1754','249',996616.53,996616.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','245828',4704494,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','245828',4704495,'1756','249',1055905.60,1055905.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','245828',4704496,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','245828',4704497,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','246223',4710522,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','246223',4710523,'1754','249',996616.53,996616.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','246223',4710524,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','246223',4710525,'1756','249',1055905.60,1055905.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','246223',4710526,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','246223',4710527,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','246306',4711990,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','246306',4711991,'1754','249',996616.53,996616.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','246306',4711992,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','246306',4711993,'1756','249',1055905.60,1055905.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','246306',4711994,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','246306',4711995,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','246868',4721901,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','246868',4721902,'1754','249',996616.53,996616.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','246868',4721903,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','246868',4721904,'1756','249',1055905.60,1055905.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','246868',4721905,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','246868',4721906,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','247272',4728780,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','247272',4728781,'1754','249',996616.53,996616.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','247272',4728782,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','247272',4728783,'1756','249',1055905.60,1055905.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','247272',4728784,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','247272',4728785,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','247358',4730587,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','247358',4730588,'1754','249',996616.53,996616.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','247358',4730589,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','247358',4730590,'1756','249',1055905.60,1055905.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','247358',4730591,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','247358',4730592,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','247479',4732428,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','247479',4732429,'1754','249',996616.53,996616.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','247479',4732430,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','247479',4732431,'1756','249',1055905.60,1055905.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','247479',4732432,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','247479',4732433,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','248007',4741271,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','248007',4741272,'1754','249',996616.53,996616.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','248007',4741273,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','248007',4741274,'1756','249',1055905.60,1055905.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','248007',4741275,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','248007',4741276,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','248008',4741277,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','248008',4741278,'1754','249',996616.53,996616.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','248008',4741279,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','248008',4741280,'1756','249',1055905.60,1055905.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','248008',4741281,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','248008',4741282,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','248010',4741296,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','248010',4741297,'1754','249',996616.53,996616.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','248010',4741298,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','248010',4741299,'1756','249',1055905.60,1055905.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','248010',4741300,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','248010',4741301,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','248986',4757877,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','248986',4757878,'1754','249',996616.53,996616.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','248986',4757879,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','248986',4757880,'1756','249',1055905.60,1055905.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','248986',4757881,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','248986',4757882,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','249528',4767048,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','249528',4767049,'1754','249',996616.53,996616.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','249528',4767050,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','249528',4767051,'1756','249',1055905.60,1055905.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','249528',4767052,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','249528',4767053,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','249767',4771015,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','249767',4771016,'1754','249',996616.53,996616.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','249767',4771017,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','249767',4771018,'1756','249',1055905.60,1055905.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','249767',4771019,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','249767',4771020,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','250130',4776916,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','250130',4776917,'1754','249',996616.53,996616.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','250130',4776918,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','250130',4776919,'1756','249',1055905.60,1055905.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','250130',4776920,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','250130',4776921,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','250488',4783074,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','250488',4783075,'1754','249',996616.53,996616.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','250488',4783076,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','250488',4783077,'1756','249',1055905.60,1055905.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','250488',4783078,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','250488',4783079,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','250695',4786648,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','250695',4786649,'1754','249',996616.53,996616.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','250695',4786650,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','250695',4786651,'1756','249',1055905.60,1055905.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','250695',4786652,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','250695',4786653,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','250699',4786705,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','250699',4786706,'1754','249',996616.53,996616.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','250699',4786707,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','250699',4786708,'1756','249',1055905.60,1055905.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','250699',4786709,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','250699',4786710,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','250704',4786800,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','250704',4786801,'1754','249',996616.53,996616.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','250704',4786802,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','250704',4786803,'1756','249',1055905.60,1055905.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','250704',4786804,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','250704',4786805,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','250707',4786827,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','250707',4786828,'1754','249',996616.53,996616.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','250707',4786829,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','250707',4786830,'1756','249',1055905.60,1055905.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','250707',4786831,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','250707',4786832,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','250710',4786876,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','250710',4786877,'1754','249',996616.53,996616.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','250710',4786878,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','250710',4786879,'1756','249',1055905.60,1055905.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','250710',4786880,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','250710',4786881,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','250712',4786897,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','250712',4786898,'1754','249',996616.53,998151.98,1535.45,253349.25,0.00,0.00,0.00,0.00,0.00),('5','102','631','250712',4786899,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','250712',4786900,'1756','249',1055905.60,1057119.87,1214.27,200354.55,0.00,0.00,0.00,0.00,0.00),('5','102','633','250712',4786901,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','250712',4786902,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','251352',4798119,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','251352',4798120,'1754','249',998151.98,1002427.89,4275.91,705525.15,0.00,0.00,0.00,0.00,0.00),('5','102','631','251352',4798121,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','251352',4798122,'1756','249',1057119.87,1061145.96,4026.09,664304.85,0.00,0.00,0.00,0.00,0.00),('5','102','633','251352',4798123,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','251352',4798124,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','251356',4798204,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','251356',4798205,'1754','249',1002427.89,1008540.28,6112.39,1008544.35,0.00,0.00,0.00,0.00,0.00),('5','102','631','251356',4798206,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','251356',4798207,'1756','249',1061145.96,1067475.54,6329.58,1044380.70,0.00,0.00,0.00,0.00,0.00),('5','102','633','251356',4798208,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','251356',4798209,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','251364',4798319,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','251364',4798320,'1754','249',1008540.28,1010108.53,1568.25,258761.25,0.00,0.00,0.00,0.00,0.00),('5','102','631','251364',4798321,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','251364',4798322,'1756','249',1067475.54,1074512.60,7037.06,1161114.90,0.00,0.00,0.00,0.00,0.00),('5','102','633','251364',4798323,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','251364',4798324,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','251850',4806749,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','251850',4806750,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','251850',4806751,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','251850',4806752,'1756','249',1074512.60,1080679.63,6167.03,1017559.95,0.00,0.00,0.00,0.00,0.00),('5','102','633','251850',4806753,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','251850',4806754,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','252491',4818112,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','252491',4818113,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','252491',4818114,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','252491',4818115,'1756','249',1080679.63,1081644.63,965.00,159225.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','252491',4818116,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','252491',4818117,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','253150',4829431,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','253150',4829432,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','253150',4829433,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','253150',4829434,'1756','249',1081644.63,1081644.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','253150',4829435,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','253150',4829436,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','253151',4829437,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','253151',4829438,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','253151',4829439,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','253151',4829440,'1756','249',1081644.63,1081644.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','253151',4829441,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','253151',4829442,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','253153',4829449,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','253153',4829450,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','253153',4829451,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','253153',4829452,'1756','249',1081644.63,1081644.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','253153',4829453,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','253153',4829454,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','253154',4829455,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','253154',4829456,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','253154',4829457,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','253154',4829458,'1756','249',1081644.63,1081644.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','253154',4829459,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','253154',4829460,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','253157',4829498,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','253157',4829499,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','253157',4829500,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','253157',4829501,'1756','249',1081644.63,1081644.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','253157',4829502,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','253157',4829503,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','253309',4831806,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','253309',4831807,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','253309',4831808,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','253309',4831809,'1756','249',1081644.63,1081644.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','253309',4831810,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','253309',4831811,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','253573',4836380,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','253573',4836381,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','253573',4836382,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','253573',4836383,'1756','249',1081644.63,1081644.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','253573',4836384,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','253573',4836385,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','253797',4840176,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','253797',4840177,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','253797',4840178,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','253797',4840179,'1756','249',1081644.63,1081644.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','253797',4840180,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','253797',4840181,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','254074',4845098,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','254074',4845099,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','254074',4845100,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','254074',4845101,'1756','249',1081644.63,1081644.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','254074',4845102,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','254074',4845103,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','254369',4850403,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','254369',4850404,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','254369',4850405,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','254369',4850406,'1756','249',1081644.63,1081644.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','254369',4850407,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','254369',4850408,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','254643',4855223,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','254643',4855224,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','254643',4855225,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','254643',4855226,'1756','249',1081644.63,1081644.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','254643',4855227,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','254643',4855228,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','254859',4858744,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','254859',4858745,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','254859',4858746,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','254859',4858747,'1756','249',1081644.63,1081644.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','254859',4858748,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','254859',4858749,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','255147',4863860,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','255147',4863861,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','255147',4863862,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','255147',4863863,'1756','249',1081644.63,1081644.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','255147',4863864,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','255147',4863865,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','255313',4866758,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','255313',4866759,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','255313',4866760,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','255313',4866761,'1756','249',1081644.63,1081644.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','255313',4866762,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','255313',4866763,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','255762',4873906,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','255762',4873907,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','255762',4873908,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','255762',4873909,'1756','249',1081644.63,1081644.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','255762',4873910,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','255762',4873911,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','255893',4876258,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','255893',4876259,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','255893',4876260,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','255893',4876261,'1756','249',1081644.63,1081644.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','255893',4876262,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','255893',4876263,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','256179',4880933,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','256179',4880934,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','256179',4880935,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','256179',4880936,'1756','249',1081644.63,1081644.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','256179',4880937,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','256179',4880938,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','256311',4882866,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','256311',4882867,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','256311',4882868,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','256311',4882869,'1756','249',1081644.63,1081644.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','256311',4882870,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','256311',4882871,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','256563',4887232,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','256563',4887233,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','256563',4887234,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','256563',4887235,'1756','249',1081644.63,1081644.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','256563',4887236,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','256563',4887237,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','256910',4893319,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','256910',4893320,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','256910',4893321,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','256910',4893322,'1756','249',1081644.63,1081644.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','256910',4893323,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','256910',4893324,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257277',4899675,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257277',4899676,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257277',4899677,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257277',4899678,'1756','249',1081644.63,1081644.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257277',4899679,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257277',4899680,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257656',4906646,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257656',4906647,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257656',4906648,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257656',4906649,'1756','249',1081644.63,1081644.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257656',4906650,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257656',4906651,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257657',4906652,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257657',4906653,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257657',4906654,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257657',4906655,'1756','249',1081644.63,1081644.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257657',4906656,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257657',4906657,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257658',4906658,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257658',4906659,'1756','249',1081644.63,1081644.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257658',4906660,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257658',4906661,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257658',4906662,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257658',4906663,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257659',4906664,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257659',4906665,'1756','249',1081644.63,1081644.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257659',4906666,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257659',4906667,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257659',4906668,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257659',4906669,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257660',4906670,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257660',4906671,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257660',4906672,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257660',4906673,'1756','249',1081644.63,1081644.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257660',4906674,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257660',4906675,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257661',4906676,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257661',4906677,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257661',4906678,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257661',4906679,'1756','249',1081644.63,1081644.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257661',4906680,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257661',4906681,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257662',4906682,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257662',4906683,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257662',4906684,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257662',4906685,'1756','249',1081644.63,1081644.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257662',4906686,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257662',4906687,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257663',4906688,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257663',4906689,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257663',4906690,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257663',4906691,'1756','249',1081644.63,1081644.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257663',4906692,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257663',4906693,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257664',4906694,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257664',4906695,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257664',4906696,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257664',4906697,'1756','249',1081644.63,1081644.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257664',4906698,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257664',4906699,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257665',4906700,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257665',4906701,'1756','249',1081644.63,1081644.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257665',4906702,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257665',4906703,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257665',4906704,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257665',4906705,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257666',4906706,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257666',4906707,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257666',4906708,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257666',4906709,'1756','249',1081644.63,1081644.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257666',4906710,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257666',4906711,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257667',4906712,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257667',4906713,'1756','249',1081644.63,1081644.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257667',4906714,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257667',4906715,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257667',4906716,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257667',4906717,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257668',4906718,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257668',4906719,'1756','249',1081644.63,1081644.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257668',4906720,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257668',4906721,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257668',4906722,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257668',4906723,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257669',4906724,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257669',4906725,'1756','249',1081644.63,1081644.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257669',4906726,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257669',4906727,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257669',4906728,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257669',4906729,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257670',4906730,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257670',4906731,'1756','249',1081644.63,1081644.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257670',4906732,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257670',4906733,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257670',4906734,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257670',4906735,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257671',4906736,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257671',4906737,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257671',4906738,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257671',4906739,'1756','249',1081644.63,1081644.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257671',4906740,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257671',4906741,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257672',4906742,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257672',4906743,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257672',4906744,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257672',4906745,'1756','249',1081644.63,1081644.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257672',4906746,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257672',4906747,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257673',4906748,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257673',4906749,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257673',4906750,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257673',4906751,'1756','249',1081644.63,1081644.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257673',4906752,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257673',4906753,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257674',4906754,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257674',4906755,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257674',4906756,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257674',4906757,'1756','249',1081644.63,1081644.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257674',4906758,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257674',4906759,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257675',4906760,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257675',4906761,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257675',4906762,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257675',4906763,'1756','249',1081644.63,1081644.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257675',4906764,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257675',4906765,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257676',4906766,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257676',4906767,'1756','249',1081644.63,1081644.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257676',4906768,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257676',4906769,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257676',4906770,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257676',4906771,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257677',4906772,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257677',4906773,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257677',4906774,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257677',4906775,'1756','249',1081644.63,1081644.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257677',4906776,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257677',4906777,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257678',4906778,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257678',4906779,'1756','249',1081644.63,1081644.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257678',4906780,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257678',4906781,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257678',4906782,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257678',4906783,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257679',4906784,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257679',4906785,'1754','249',1010108.53,1010108.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257679',4906786,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257679',4906787,'1756','249',1081644.63,1081644.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257679',4906788,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257679',4906789,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257680',4906790,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257680',4906791,'1754','249',1010108.53,1013408.21,3299.68,544447.20,0.00,0.00,0.00,0.00,0.00),('5','102','631','257680',4906792,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257680',4906793,'1756','249',1081644.63,1085825.21,4180.58,689795.70,0.00,0.00,0.00,0.00,0.00),('5','102','633','257680',4906794,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257680',4906795,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257681',4906796,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257681',4906797,'1754','249',1013408.21,1020235.91,6827.70,1126570.50,0.00,0.00,0.00,0.00,0.00),('5','102','631','257681',4906798,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257681',4906799,'1756','249',1085825.21,1095516.53,9691.32,1599067.80,0.00,0.00,0.00,0.00,0.00),('5','102','633','257681',4906800,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257681',4906801,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257682',4906802,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257682',4906803,'1754','249',1020235.91,1022634.50,2398.59,395767.35,0.00,0.00,0.00,0.00,0.00),('5','102','631','257682',4906804,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257682',4906805,'1756','249',1095516.53,1104296.29,8779.76,1448660.40,0.00,0.00,0.00,0.00,0.00),('5','102','633','257682',4906806,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257682',4906807,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257683',4906808,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257683',4906809,'1754','249',1022634.50,1023935.14,1300.64,214605.60,0.00,0.00,0.00,0.00,0.00),('5','102','631','257683',4906810,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257683',4906811,'1756','249',1104296.29,1108009.21,3712.92,612631.80,0.00,0.00,0.00,0.00,0.00),('5','102','633','257683',4906812,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257683',4906813,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257684',4906814,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257684',4906815,'1756','249',1108009.21,1108009.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257684',4906816,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257684',4906817,'1754','249',1023935.14,1023935.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257684',4906818,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257684',4906819,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257685',4906820,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257685',4906821,'1754','249',1023935.14,1023935.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257685',4906822,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257685',4906823,'1756','249',1108009.21,1108009.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257685',4906824,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257685',4906825,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257686',4906826,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257686',4906827,'1754','249',1023935.14,1023935.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257686',4906828,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257686',4906829,'1756','249',1108009.21,1108009.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257686',4906830,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257686',4906831,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257687',4906832,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257687',4906833,'1754','249',1023935.14,1023935.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257687',4906834,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257687',4906835,'1756','249',1108009.21,1108009.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257687',4906836,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257687',4906837,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257688',4906838,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257688',4906839,'1754','249',1023935.14,1023935.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257688',4906840,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257688',4906841,'1756','249',1108009.21,1108009.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257688',4906842,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257688',4906843,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257689',4906844,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257689',4906845,'1754','249',1023935.14,1023935.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257689',4906846,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257689',4906847,'1756','249',1108009.21,1108009.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257689',4906848,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257689',4906849,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257690',4906850,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257690',4906851,'1756','249',1108009.21,1108009.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257690',4906852,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257690',4906853,'1754','249',1023935.14,1023935.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257690',4906854,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257690',4906855,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257691',4906856,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257691',4906857,'1754','249',1023935.14,1023935.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257691',4906858,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257691',4906859,'1756','249',1108009.21,1108009.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257691',4906860,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257691',4906861,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257692',4906862,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257692',4906863,'1754','249',1023935.14,1023935.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257692',4906864,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257692',4906865,'1756','249',1108009.21,1108009.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257692',4906866,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257692',4906867,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257693',4906868,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257693',4906869,'1754','249',1023935.14,1023935.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257693',4906870,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257693',4906871,'1756','249',1108009.21,1108009.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257693',4906872,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257693',4906873,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257694',4906874,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257694',4906875,'1754','249',1023935.14,1023935.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257694',4906876,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257694',4906877,'1756','249',1108009.21,1108009.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257694',4906878,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257694',4906879,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257695',4906880,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257695',4906881,'1754','249',1023935.14,1023935.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257695',4906882,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257695',4906883,'1756','249',1108009.21,1108009.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257695',4906884,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257695',4906885,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257696',4906886,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257696',4906887,'1754','249',1023935.14,1023935.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257696',4906888,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257696',4906889,'1756','249',1108009.21,1108009.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257696',4906890,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257696',4906891,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257697',4906892,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257697',4906893,'1756','249',1108009.21,1108009.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257697',4906894,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257697',4906895,'1754','249',1023935.14,1023935.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257697',4906896,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257697',4906897,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257698',4906898,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257698',4906899,'1754','249',1023935.14,1023935.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257698',4906900,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257698',4906901,'1756','249',1108009.21,1108009.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257698',4906902,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257698',4906903,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257699',4906904,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257699',4906905,'1754','249',1023935.14,1023935.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257699',4906906,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257699',4906907,'1756','249',1108009.21,1108009.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257699',4906908,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257699',4906909,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257700',4906910,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257700',4906911,'1754','249',1023935.14,1023935.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257700',4906912,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257700',4906913,'1756','249',1108009.21,1108009.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257700',4906914,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257700',4906915,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257701',4906916,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257701',4906917,'1754','249',1023935.14,1023935.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257701',4906918,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257701',4906919,'1756','249',1108009.21,1108009.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257701',4906920,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257701',4906921,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257702',4906922,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257702',4906923,'1754','249',1023935.14,1023935.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257702',4906924,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257702',4906925,'1756','249',1108009.21,1108009.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257702',4906926,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257702',4906927,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257703',4906928,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257703',4906929,'1754','249',1023935.14,1023935.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257703',4906930,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257703',4906931,'1756','249',1108009.21,1108009.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257703',4906932,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257703',4906933,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257704',4906934,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257704',4906935,'1754','249',1023935.14,1023935.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257704',4906936,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257704',4906937,'1756','249',1108009.21,1108009.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257704',4906938,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257704',4906939,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257705',4906940,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257705',4906941,'1754','249',1023935.14,1023935.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257705',4906942,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257705',4906943,'1756','249',1108009.21,1108009.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257705',4906944,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257705',4906945,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257706',4906946,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257706',4906947,'1754','249',1023935.14,1023935.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257706',4906948,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257706',4906949,'1756','249',1108009.21,1108009.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257706',4906950,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257706',4906951,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257707',4906952,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257707',4906953,'1754','249',1023935.14,1023935.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257707',4906954,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257707',4906955,'1756','249',1108009.21,1108009.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257707',4906956,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257707',4906957,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257708',4906958,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257708',4906959,'1754','249',1023935.14,1023935.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257708',4906960,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257708',4906961,'1756','249',1108009.21,1108009.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257708',4906962,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257708',4906963,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257709',4906964,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257709',4906965,'1754','249',1023935.14,1023935.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257709',4906966,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257709',4906967,'1756','249',1108009.21,1108009.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257709',4906968,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257709',4906969,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257710',4906970,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257710',4906971,'1754','249',1023935.14,1023935.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257710',4906972,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257710',4906973,'1756','249',1108009.21,1108009.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257710',4906974,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257710',4906975,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257711',4906976,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257711',4906977,'1754','249',1023935.14,1023935.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257711',4906978,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257711',4906979,'1756','249',1108009.21,1108009.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257711',4906980,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257711',4906981,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257712',4906982,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257712',4906983,'1754','249',1023935.14,1026569.04,2633.90,434593.50,0.00,0.00,0.00,0.00,0.00),('5','102','631','257712',4906984,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257712',4906985,'1756','249',1108009.21,1110616.52,2607.31,430206.15,0.00,0.00,0.00,0.00,0.00),('5','102','633','257712',4906986,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257712',4906987,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257713',4906988,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257713',4906989,'1754','249',1026569.04,1033798.99,7229.95,1192941.75,0.00,0.00,0.00,0.00,0.00),('5','102','631','257713',4906990,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257713',4906991,'1756','249',1110616.52,1120172.76,9556.24,1576779.60,0.00,0.00,0.00,0.00,0.00),('5','102','633','257713',4906992,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257713',4906993,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257714',4906994,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257714',4906995,'1754','249',1033798.99,1035047.86,1248.87,206063.55,0.00,0.00,0.00,0.00,0.00),('5','102','631','257714',4906996,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257714',4906997,'1756','249',1120172.76,1127335.66,7162.90,1181878.50,0.00,0.00,0.00,0.00,0.00),('5','102','633','257714',4906998,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257714',4906999,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257715',4907000,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257715',4907001,'1754','249',1035047.86,1036030.63,982.77,162157.05,0.00,0.00,0.00,0.00,0.00),('5','102','631','257715',4907002,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257715',4907003,'1756','249',1127335.66,1133755.34,6419.68,1059247.20,0.00,0.00,0.00,0.00,0.00),('5','102','633','257715',4907004,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257715',4907005,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257716',4907006,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257716',4907007,'1754','249',1036030.63,1037435.37,1404.74,231782.10,0.00,0.00,0.00,0.00,0.00),('5','102','631','257716',4907008,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257716',4907009,'1756','249',1133755.34,1134586.80,831.46,137190.90,0.00,0.00,0.00,0.00,0.00),('5','102','633','257716',4907010,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257716',4907011,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257717',4907012,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257717',4907013,'1754','249',1037435.37,1037435.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257717',4907014,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257717',4907015,'1756','249',1134586.80,1134586.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257717',4907016,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257717',4907017,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257718',4907018,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257718',4907019,'1754','249',1037435.37,1037435.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257718',4907020,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257718',4907021,'1756','249',1134586.80,1134586.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257718',4907022,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257718',4907023,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257719',4907024,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257719',4907025,'1754','249',1037435.37,1037435.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257719',4907026,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257719',4907027,'1756','249',1134586.80,1134586.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257719',4907028,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257719',4907029,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257720',4907030,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257720',4907031,'1754','249',1037435.37,1037435.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257720',4907032,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257720',4907033,'1756','249',1134586.80,1134586.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257720',4907034,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257720',4907035,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257721',4907036,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257721',4907037,'1754','249',1037435.37,1037435.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257721',4907038,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257721',4907039,'1756','249',1134586.80,1134586.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257721',4907040,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257721',4907041,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257722',4907042,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257722',4907043,'1756','249',1134586.80,1134586.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257722',4907044,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257722',4907045,'1754','249',1037435.37,1037435.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257722',4907046,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257722',4907047,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257723',4907048,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257723',4907049,'1756','249',1134586.80,1134586.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257723',4907050,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257723',4907051,'1754','249',1037435.37,1037435.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257723',4907052,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257723',4907053,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257724',4907054,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257724',4907055,'1754','249',1037435.37,1037435.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257724',4907056,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257724',4907057,'1756','249',1134586.80,1134586.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257724',4907058,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257724',4907059,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257725',4907060,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257725',4907061,'1754','249',1037435.37,1037435.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257725',4907062,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257725',4907063,'1756','249',1134586.80,1134586.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257725',4907064,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257725',4907065,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257726',4907066,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257726',4907067,'1754','249',1037435.37,1037435.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257726',4907068,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257726',4907069,'1756','249',1134586.80,1134586.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257726',4907070,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257726',4907071,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257727',4907072,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257727',4907073,'1754','249',1037435.37,1037435.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257727',4907074,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257727',4907075,'1756','249',1134586.80,1134586.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257727',4907076,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257727',4907077,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257728',4907078,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257728',4907079,'1754','249',1037435.37,1037435.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257728',4907080,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257728',4907081,'1756','249',1134586.80,1134586.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257728',4907082,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257728',4907083,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257729',4907084,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257729',4907085,'1754','249',1037435.37,1037435.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257729',4907086,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257729',4907087,'1756','249',1134586.80,1134586.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257729',4907088,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257729',4907089,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257730',4907090,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257730',4907091,'1754','249',1037435.37,1037435.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257730',4907092,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257730',4907093,'1756','249',1134586.80,1134586.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257730',4907094,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257730',4907095,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257731',4907096,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257731',4907097,'1754','249',1037435.37,1037435.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257731',4907098,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257731',4907099,'1756','249',1134586.80,1134586.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257731',4907100,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257731',4907101,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257732',4907102,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257732',4907103,'1754','249',1037435.37,1037435.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257732',4907104,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257732',4907105,'1756','249',1134586.80,1134586.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257732',4907106,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257732',4907107,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257733',4907108,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257733',4907109,'1756','249',1134586.80,1134586.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257733',4907110,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257733',4907111,'1754','249',1037435.37,1037435.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257733',4907112,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257733',4907113,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257734',4907114,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257734',4907115,'1756','249',1134586.80,1134586.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257734',4907116,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257734',4907117,'1754','249',1037435.37,1037435.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257734',4907118,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257734',4907119,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257735',4907120,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257735',4907121,'1754','249',1037435.37,1037435.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257735',4907122,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257735',4907123,'1756','249',1134586.80,1134586.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257735',4907124,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257735',4907125,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257736',4907126,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257736',4907127,'1754','249',1037435.37,1037435.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257736',4907128,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257736',4907129,'1756','249',1134586.80,1134586.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257736',4907130,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257736',4907131,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257737',4907132,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257737',4907133,'1756','249',1134586.80,1134586.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257737',4907134,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257737',4907135,'1754','249',1037435.37,1037435.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257737',4907136,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257737',4907137,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257738',4907138,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257738',4907139,'1756','249',1134586.80,1134586.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257738',4907140,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257738',4907141,'1754','249',1037435.37,1037435.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257738',4907142,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257738',4907143,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257739',4907144,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257739',4907145,'1754','249',1037435.37,1037435.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257739',4907146,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257739',4907147,'1756','249',1134586.80,1134586.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257739',4907148,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257739',4907149,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257740',4907150,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257740',4907151,'1756','249',1134586.80,1134586.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257740',4907152,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257740',4907153,'1754','249',1037435.37,1037435.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257740',4907154,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257740',4907155,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257741',4907156,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257741',4907157,'1754','249',1037435.37,1037435.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257741',4907158,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257741',4907159,'1756','249',1134586.80,1134586.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257741',4907160,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257741',4907161,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257742',4907162,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257742',4907163,'1754','249',1037435.37,1037435.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257742',4907164,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257742',4907165,'1756','249',1134586.80,1134586.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257742',4907166,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257742',4907167,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257743',4907168,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257743',4907169,'1754','249',1037435.37,1037435.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257743',4907170,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257743',4907171,'1756','249',1134586.80,1134586.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257743',4907172,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257743',4907173,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257744',4907174,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257744',4907175,'1754','249',1037435.37,1040235.36,2799.99,461998.35,0.00,0.00,0.00,0.00,0.00),('5','102','631','257744',4907176,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257744',4907177,'1756','249',1134586.80,1136493.82,1907.02,314658.30,0.00,0.00,0.00,0.00,0.00),('5','102','633','257744',4907178,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257744',4907179,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257745',4907180,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257745',4907181,'1754','249',1040235.36,1042458.06,2222.70,366745.50,0.00,0.00,0.00,0.00,0.00),('5','102','631','257745',4907182,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257745',4907183,'1756','249',1136493.82,1138292.12,1798.30,296719.50,0.00,0.00,0.00,0.00,0.00),('5','102','633','257745',4907184,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257745',4907185,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257746',4907186,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257746',4907187,'1754','249',1042458.06,1044536.54,2078.48,342949.20,0.00,0.00,0.00,0.00,0.00),('5','102','631','257746',4907188,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257746',4907189,'1756','249',1138292.12,1140431.84,2139.72,353053.80,0.00,0.00,0.00,0.00,0.00),('5','102','633','257746',4907190,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257746',4907191,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257747',4907192,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257747',4907193,'1754','249',1044536.54,1046904.84,2368.30,390769.50,0.00,0.00,0.00,0.00,0.00),('5','102','631','257747',4907194,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257747',4907195,'1756','249',1140431.84,1142731.31,2299.47,379412.55,0.00,0.00,0.00,0.00,0.00),('5','102','633','257747',4907196,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257747',4907197,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257748',4907198,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257748',4907199,'1754','249',1046904.84,1048641.24,1736.40,286506.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257748',4907200,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257748',4907201,'1756','249',1142731.31,1145195.51,2464.20,406593.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257748',4907202,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257748',4907203,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257749',4907204,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257749',4907205,'1754','249',1048641.24,1050429.30,1788.06,295029.90,0.00,0.00,0.00,0.00,0.00),('5','102','631','257749',4907206,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257749',4907207,'1756','249',1145195.51,1147819.14,2623.63,432898.95,0.00,0.00,0.00,0.00,0.00),('5','102','633','257749',4907208,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257749',4907209,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257750',4907210,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257750',4907211,'1754','249',1050429.30,1050429.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257750',4907212,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257750',4907213,'1756','249',1147819.14,1151997.75,4178.61,689470.65,0.00,0.00,0.00,0.00,0.00),('5','102','633','257750',4907214,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257750',4907215,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257751',4907216,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257751',4907217,'1754','249',1050429.30,1050429.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257751',4907218,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257751',4907219,'1756','249',1151997.75,1158255.61,6257.86,1032546.90,0.00,0.00,0.00,0.00,0.00),('5','102','633','257751',4907220,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257751',4907221,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257752',4907222,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257752',4907223,'1756','249',1158255.61,1161615.82,3360.21,554434.65,0.00,0.00,0.00,0.00,0.00),('5','102','632','257752',4907224,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257752',4907225,'1754','249',1050429.30,1050429.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257752',4907226,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257752',4907227,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257753',4907228,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257753',4907229,'1754','249',1050429.30,1050429.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257753',4907230,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257753',4907231,'1756','249',1161615.82,1161615.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257753',4907232,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257753',4907233,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257754',4907234,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257754',4907235,'1754','249',1050429.30,1050429.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257754',4907236,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257754',4907237,'1756','249',1161615.82,1161615.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257754',4907238,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257754',4907239,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257755',4907240,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257755',4907241,'1754','249',1050429.30,1050429.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257755',4907242,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257755',4907243,'1756','249',1161615.82,1161615.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257755',4907244,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257755',4907245,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257756',4907246,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257756',4907247,'1754','249',1050429.30,1050429.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257756',4907248,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257756',4907249,'1756','249',1161615.82,1161615.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257756',4907250,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257756',4907251,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257757',4907252,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257757',4907253,'1754','249',1050429.30,1050429.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257757',4907254,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257757',4907255,'1756','249',1161615.82,1161615.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257757',4907256,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257757',4907257,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257758',4907258,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257758',4907259,'1754','249',1050429.30,1050429.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257758',4907260,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257758',4907261,'1756','249',1161615.82,1161615.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257758',4907262,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257758',4907263,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257759',4907264,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257759',4907265,'1756','249',1161615.82,1161615.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257759',4907266,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257759',4907267,'1754','249',1050429.30,1050429.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257759',4907268,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257759',4907269,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257760',4907270,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257760',4907271,'1754','249',1050429.30,1050429.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257760',4907272,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257760',4907273,'1756','249',1161615.82,1161615.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257760',4907274,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257760',4907275,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257761',4907276,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257761',4907277,'1754','249',1050429.30,1050429.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257761',4907278,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257761',4907279,'1756','249',1161615.82,1161615.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257761',4907280,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257761',4907281,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257762',4907282,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257762',4907283,'1754','249',1050429.30,1050429.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257762',4907284,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257762',4907285,'1756','249',1161615.82,1161615.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257762',4907286,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257762',4907287,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257763',4907288,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257763',4907289,'1754','249',1050429.30,1050429.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257763',4907290,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257763',4907291,'1756','249',1161615.82,1161615.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257763',4907292,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257763',4907293,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257764',4907294,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257764',4907295,'1754','249',1050429.30,1050429.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257764',4907296,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257764',4907297,'1756','249',1161615.82,1161615.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257764',4907298,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257764',4907299,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257765',4907300,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257765',4907301,'1754','249',1050429.30,1050429.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257765',4907302,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257765',4907303,'1756','249',1161615.82,1161615.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257765',4907304,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257765',4907305,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257766',4907306,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257766',4907307,'1756','249',1161615.82,1161615.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257766',4907308,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257766',4907309,'1754','249',1050429.30,1050429.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257766',4907310,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257766',4907311,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257767',4907312,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257767',4907313,'1754','249',1050429.30,1050429.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257767',4907314,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257767',4907315,'1756','249',1161615.82,1161615.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257767',4907316,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257767',4907317,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257768',4907318,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257768',4907319,'1754','249',1050429.30,1050429.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257768',4907320,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257768',4907321,'1756','249',1161615.82,1161615.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257768',4907322,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257768',4907323,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257769',4907324,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257769',4907325,'1754','249',1050429.30,1050429.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257769',4907326,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257769',4907327,'1756','249',1161615.82,1161615.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257769',4907328,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257769',4907329,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257770',4907330,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257770',4907331,'1754','249',1050429.30,1050429.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257770',4907332,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257770',4907333,'1756','249',1161615.82,1161615.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257770',4907334,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257770',4907335,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257771',4907336,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257771',4907337,'1756','249',1161615.82,1161615.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257771',4907338,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257771',4907339,'1754','249',1050429.30,1050429.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257771',4907340,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257771',4907341,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257772',4907342,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257772',4907343,'1754','249',1050429.30,1050429.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257772',4907344,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257772',4907345,'1756','249',1161615.82,1161615.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257772',4907346,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257772',4907347,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257773',4907348,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257773',4907349,'1754','249',1050429.30,1050429.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257773',4907350,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257773',4907351,'1756','249',1161615.82,1161615.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257773',4907352,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257773',4907353,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257774',4907354,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257774',4907355,'1754','249',1050429.30,1050429.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257774',4907356,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257774',4907357,'1756','249',1161615.82,1161615.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257774',4907358,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257774',4907359,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257775',4907360,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257775',4907361,'1754','249',1050429.30,1050429.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257775',4907362,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257775',4907363,'1756','249',1161615.82,1161615.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257775',4907364,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257775',4907365,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257776',4907366,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257776',4907367,'1754','249',1050429.30,1050429.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257776',4907368,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257776',4907369,'1756','249',1161615.82,1161615.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257776',4907370,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257776',4907371,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257777',4907372,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257777',4907373,'1754','249',1050429.30,1050429.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257777',4907374,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257777',4907375,'1756','249',1161615.82,1161615.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257777',4907376,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257777',4907377,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257778',4907378,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257778',4907379,'1754','249',1050429.30,1050429.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257778',4907380,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257778',4907381,'1756','249',1161615.82,1161615.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257778',4907382,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257778',4907383,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257779',4907384,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257779',4907385,'1754','249',1050429.30,1050429.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257779',4907386,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257779',4907387,'1756','249',1161615.82,1161615.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257779',4907388,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257779',4907389,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257780',4907390,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257780',4907391,'1756','249',1161615.82,1161615.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257780',4907392,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257780',4907393,'1754','249',1050429.30,1050429.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257780',4907394,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257780',4907395,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257781',4907396,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257781',4907397,'1754','249',1050429.30,1050429.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257781',4907398,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257781',4907399,'1756','249',1161615.82,1161615.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257781',4907400,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257781',4907401,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257782',4907402,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257782',4907403,'1754','249',1050429.30,1050429.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257782',4907404,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257782',4907405,'1756','249',1161615.82,1161615.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257782',4907406,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257782',4907407,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257783',4907408,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257783',4907409,'1754','249',1050429.30,1050429.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257783',4907410,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257783',4907411,'1756','249',1161615.82,1161615.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257783',4907412,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257783',4907413,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257784',4907414,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257784',4907415,'1754','249',1050429.30,1050429.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257784',4907416,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257784',4907417,'1756','249',1161615.82,1161615.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257784',4907418,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257784',4907419,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257785',4907420,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257785',4907421,'1754','249',1050429.30,1050429.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257785',4907422,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257785',4907423,'1756','249',1161615.82,1161615.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257785',4907424,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257785',4907425,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257786',4907426,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257786',4907427,'1754','249',1050429.30,1050429.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257786',4907428,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257786',4907429,'1756','249',1161615.82,1161615.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257786',4907430,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257786',4907431,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257787',4907432,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257787',4907433,'1754','249',1050429.30,1050429.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257787',4907434,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257787',4907435,'1756','249',1161615.82,1161615.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257787',4907436,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257787',4907437,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257788',4907438,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257788',4907439,'1756','249',1161615.82,1161615.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257788',4907440,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257788',4907441,'1754','249',1050429.30,1050429.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257788',4907442,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257788',4907443,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257789',4907444,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257789',4907445,'1754','249',1050429.30,1050429.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257789',4907446,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257789',4907447,'1756','249',1161615.82,1161615.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257789',4907448,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257789',4907449,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257790',4907450,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257790',4907451,'1754','249',1050429.30,1050429.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257790',4907452,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257790',4907453,'1756','249',1161615.82,1161615.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257790',4907454,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257790',4907455,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257791',4907456,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257791',4907457,'1754','249',1050429.30,1050429.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257791',4907458,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257791',4907459,'1756','249',1161615.82,1161615.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257791',4907460,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257791',4907461,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257792',4907462,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257792',4907463,'1754','249',1050429.30,1050429.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257792',4907464,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257792',4907465,'1756','249',1161615.82,1161615.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257792',4907466,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257792',4907467,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257793',4907468,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257793',4907469,'1754','249',1050429.30,1050429.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257793',4907470,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257793',4907471,'1756','249',1161615.82,1161615.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257793',4907472,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257793',4907473,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257794',4907474,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257794',4907475,'1756','249',1161615.82,1161615.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257794',4907476,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257794',4907477,'1754','249',1050429.30,1050429.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257794',4907478,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257794',4907479,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257795',4907480,'1753','249',201195.69,201195.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','632','257795',4907481,'1754','249',1050429.30,1050429.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257795',4907482,'1755','249',269860.24,269860.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','631','257795',4907483,'1756','249',1161615.82,1161615.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','633','257795',4907484,'1757','250',278853.60,278853.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','102','634','257795',4907485,'1758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=730477 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('5','102','213197','249',165.00,165.00,614.12,0.00,0.00,0.00,0.00,614571),('5','102','213197','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,614572),('5','102','213197','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614573),('5','102','213205','249',165.00,165.00,2291.17,0.00,0.00,0.00,0.00,614591),('5','102','213205','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,614592),('5','102','213205','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614593),('5','102','213306','249',165.00,165.00,1693.88,0.00,0.00,0.00,0.00,614849),('5','102','213306','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,614850),('5','102','213306','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614851),('5','102','213382','249',165.00,165.00,1405.41,0.00,0.00,0.00,0.00,615054),('5','102','213382','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,615055),('5','102','213382','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615056),('5','102','213448','249',165.00,165.00,1826.78,0.00,0.00,0.00,0.00,615208),('5','102','213448','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,615209),('5','102','213448','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615210),('5','102','213625','249',165.00,165.00,1558.75,0.00,0.00,0.00,0.00,615697),('5','102','213625','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,615698),('5','102','213625','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615699),('5','102','213884','249',165.00,165.00,1593.76,0.00,0.00,0.00,0.00,616372),('5','102','213884','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,616373),('5','102','213884','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,616374),('5','102','214101','249',165.00,165.00,1865.65,0.00,0.00,0.00,0.00,616929),('5','102','214101','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,616930),('5','102','214101','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,616931),('5','102','214310','249',165.00,165.00,1945.92,0.00,0.00,0.00,0.00,617484),('5','102','214310','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,617485),('5','102','214310','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,617486),('5','102','214529','249',165.00,165.00,1614.87,0.00,0.00,0.00,0.00,618036),('5','102','214529','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,618037),('5','102','214529','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,618038),('5','102','214532','249',165.00,165.00,1658.54,0.00,0.00,0.00,0.00,618043),('5','102','214532','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,618044),('5','102','214532','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,618045),('5','102','214949','249',165.00,165.00,2474.19,0.00,0.00,0.00,0.00,619149),('5','102','214949','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,619150),('5','102','214949','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,619151),('5','102','215106','249',165.00,165.00,2145.88,0.00,0.00,0.00,0.00,619547),('5','102','215106','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,619548),('5','102','215106','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,619549),('5','102','215351','249',165.00,165.00,2271.30,0.00,0.00,0.00,0.00,620176),('5','102','215351','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,620177),('5','102','215351','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,620178),('5','102','215654','249',165.00,165.00,1804.01,0.00,0.00,0.00,0.00,620962),('5','102','215654','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,620963),('5','102','215654','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,620964),('5','102','215881','249',165.00,165.00,1722.19,0.00,0.00,0.00,0.00,621536),('5','102','215881','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,621537),('5','102','215881','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,621538),('5','102','216076','249',165.00,165.00,1450.59,0.00,0.00,0.00,0.00,622048),('5','102','216076','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,622049),('5','102','216076','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,622050),('5','102','216309','249',165.00,165.00,1761.43,0.00,0.00,0.00,0.00,622653),('5','102','216309','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,622654),('5','102','216309','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,622655),('5','102','216533','249',165.00,165.00,1862.62,0.00,0.00,0.00,0.00,623252),('5','102','216533','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,623253),('5','102','216533','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,623254),('5','102','216627','249',165.00,165.00,1890.01,0.00,0.00,0.00,0.00,623482),('5','102','216627','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,623483),('5','102','216627','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,623484),('5','102','216993','249',165.00,165.00,2073.96,0.00,0.00,0.00,0.00,624457),('5','102','216993','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,624458),('5','102','216993','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,624459),('5','102','217151','249',165.00,165.00,1941.26,0.00,0.00,0.00,0.00,624860),('5','102','217151','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,624861),('5','102','217151','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,624862),('5','102','217463','249',165.00,165.00,1093.86,0.00,0.00,0.00,0.00,625689),('5','102','217463','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,625690),('5','102','217463','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,625691),('5','102','217650','249',165.00,165.00,1366.58,0.00,0.00,0.00,0.00,626172),('5','102','217650','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,626173),('5','102','217650','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,626174),('5','102','217835','249',165.00,165.00,1874.33,0.00,0.00,0.00,0.00,626654),('5','102','217835','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,626655),('5','102','217835','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,626656),('5','102','218124','249',165.00,165.00,1370.89,0.00,0.00,0.00,0.00,627409),('5','102','218124','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,627410),('5','102','218124','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,627411),('5','102','218299','249',165.00,165.00,1540.59,0.00,0.00,0.00,0.00,627873),('5','102','218299','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,627874),('5','102','218299','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,627875),('5','102','218652','249',165.00,165.00,1550.61,0.00,0.00,0.00,0.00,628800),('5','102','218652','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,628801),('5','102','218652','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,628802),('5','102','218677','249',165.00,165.00,1238.91,0.00,0.00,0.00,0.00,628858),('5','102','218677','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,628859),('5','102','218677','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,628860),('5','102','218901','249',165.00,165.00,1615.88,0.00,0.00,0.00,0.00,629450),('5','102','218901','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,629451),('5','102','218901','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,629452),('5','102','219317','249',165.00,165.00,1302.39,0.00,0.00,0.00,0.00,630539),('5','102','219317','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,630540),('5','102','219317','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,630541),('5','102','219570','249',165.00,165.00,1401.94,0.00,0.00,0.00,0.00,631204),('5','102','219570','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,631205),('5','102','219570','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,631206),('5','102','219757','249',165.00,165.00,1453.73,0.00,0.00,0.00,0.00,631701),('5','102','219757','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,631702),('5','102','219757','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,631703),('5','102','219869','249',165.00,165.00,1530.07,0.00,0.00,0.00,0.00,631974),('5','102','219869','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,631975),('5','102','219869','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,631976),('5','102','220022','249',165.00,165.00,1563.11,0.00,0.00,0.00,0.00,632402),('5','102','220022','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,632403),('5','102','220022','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,632404),('5','102','220290','249',165.00,165.00,1695.50,0.00,0.00,0.00,0.00,633083),('5','102','220290','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,633084),('5','102','220290','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,633085),('5','102','220485','249',165.00,165.00,1715.15,0.00,0.00,0.00,0.00,633599),('5','102','220485','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,633600),('5','102','220485','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,633601),('5','102','220844','249',165.00,165.00,1336.22,0.00,0.00,0.00,0.00,634542),('5','102','220844','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,634543),('5','102','220844','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,634544),('5','102','220902','249',165.00,165.00,1490.29,0.00,0.00,0.00,0.00,634697),('5','102','220902','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,634698),('5','102','220902','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,634699),('5','102','221132','249',165.00,165.00,1442.96,0.00,0.00,0.00,0.00,635290),('5','102','221132','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,635291),('5','102','221132','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,635292),('5','102','221459','249',165.00,165.00,1721.76,0.00,0.00,0.00,0.00,636139),('5','102','221459','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,636140),('5','102','221459','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,636141),('5','102','221657','249',165.00,165.00,1871.01,0.00,0.00,0.00,0.00,636652),('5','102','221657','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,636653),('5','102','221657','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,636654),('5','102','221996','249',165.00,165.00,1533.89,0.00,0.00,0.00,0.00,637542),('5','102','221996','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,637543),('5','102','221996','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,637544),('5','102','222204','249',165.00,165.00,1300.72,0.00,0.00,0.00,0.00,638077),('5','102','222204','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,638078),('5','102','222204','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,638079),('5','102','222302','249',165.00,165.00,901.09,0.00,0.00,0.00,0.00,638318),('5','102','222302','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,638319),('5','102','222302','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,638320),('5','102','222615','249',165.00,165.00,1374.14,0.00,0.00,0.00,0.00,639139),('5','102','222615','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,639140),('5','102','222615','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,639141),('5','102','222874','249',165.00,165.00,509.97,0.00,0.00,0.00,0.00,639831),('5','102','222874','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,639832),('5','102','222874','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,639833),('5','102','223009','249',165.00,165.00,1079.62,0.00,0.00,0.00,0.00,640192),('5','102','223009','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,640193),('5','102','223009','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,640194),('5','102','223295','249',165.00,165.00,1237.78,0.00,0.00,0.00,0.00,640895),('5','102','223295','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,640896),('5','102','223295','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,640897),('5','102','223490','249',165.00,165.00,696.33,0.00,0.00,0.00,0.00,641392),('5','102','223490','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,641393),('5','102','223490','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,641394),('5','102','223746','249',165.00,165.00,933.05,0.00,0.00,0.00,0.00,642050),('5','102','223746','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,642051),('5','102','223746','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,642052),('5','102','224047','249',165.00,165.00,661.99,0.00,0.00,0.00,0.00,642838),('5','102','224047','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,642839),('5','102','224047','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,642840),('5','102','224357','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,643623),('5','102','224357','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,643624),('5','102','224357','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,643625),('5','102','224859','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,644930),('5','102','224859','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,644931),('5','102','224859','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,644932),('5','102','225083','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,645506),('5','102','225083','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,645507),('5','102','225083','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,645508),('5','102','225917','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,647691),('5','102','225917','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,647692),('5','102','225917','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647693),('5','102','225931','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,647731),('5','102','225931','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,647732),('5','102','225931','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647733),('5','102','225933','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,647736),('5','102','225933','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,647737),('5','102','225933','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647738),('5','102','225969','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,647807),('5','102','225969','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,647808),('5','102','225969','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647809),('5','102','226334','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,648758),('5','102','226334','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,648759),('5','102','226334','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,648760),('5','102','226543','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,649274),('5','102','226543','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,649275),('5','102','226543','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,649276),('5','102','226877','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,650167),('5','102','226877','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,650168),('5','102','226877','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,650169),('5','102','227023','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,650535),('5','102','227023','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,650536),('5','102','227023','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,650537),('5','102','227263','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,651156),('5','102','227263','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,651157),('5','102','227263','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,651158),('5','102','227398','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,651495),('5','102','227398','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,651496),('5','102','227398','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,651497),('5','102','227808','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,652573),('5','102','227808','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,652574),('5','102','227808','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,652575),('5','102','228091','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,653328),('5','102','228091','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,653329),('5','102','228091','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,653330),('5','102','229399','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,656695),('5','102','229399','250',295.00,295.00,0.00,0.00,0.00,0.00,0.00,656696),('5','102','229399','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,656697),('5','102','232413','249',163.00,163.00,0.00,0.00,0.00,0.00,0.00,664562),('5','102','232413','250',300.00,295.00,0.00,0.00,0.00,0.00,0.00,664563),('5','102','232413','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,664564),('5','102','232714','249',163.00,165.00,0.00,0.00,0.00,0.00,0.00,665364),('5','102','232714','250',300.00,295.00,0.00,0.00,0.00,0.00,0.00,665365),('5','102','232714','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,665366),('5','102','232715','249',163.00,165.00,0.00,0.00,0.00,0.00,0.00,665367),('5','102','232715','250',300.00,295.00,0.00,0.00,0.00,0.00,0.00,665368),('5','102','232715','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,665369),('5','102','232782','249',163.00,163.00,0.00,0.00,0.00,0.00,0.00,665550),('5','102','232782','250',300.00,300.00,0.00,0.00,0.00,0.00,0.00,665551),('5','102','232782','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,665552),('5','102','232783','249',163.00,163.00,0.00,0.00,0.00,0.00,0.00,665553),('5','102','232783','250',300.00,310.00,0.00,0.00,0.00,0.00,0.00,665554),('5','102','232783','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,665555),('5','102','232790','249',163.00,165.00,0.00,0.00,0.00,0.00,0.00,665574),('5','102','232790','250',300.00,295.00,0.00,0.00,0.00,0.00,0.00,665575),('5','102','232790','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,665576),('5','102','232791','249',163.00,165.00,0.00,0.00,0.00,0.00,0.00,665577),('5','102','232791','250',300.00,295.00,0.00,0.00,0.00,0.00,0.00,665578),('5','102','232791','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,665579),('5','102','232794','249',163.00,165.00,0.00,0.00,0.00,0.00,0.00,665586),('5','102','232794','250',300.00,295.00,0.00,0.00,0.00,0.00,0.00,665587),('5','102','232794','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,665588),('5','102','232797','249',163.00,165.00,0.00,0.00,0.00,0.00,0.00,665595),('5','102','232797','250',300.00,295.00,0.00,0.00,0.00,0.00,0.00,665596),('5','102','232797','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,665597),('5','102','232800','249',163.00,165.00,0.00,0.00,0.00,0.00,0.00,665604),('5','102','232800','250',300.00,295.00,0.00,0.00,0.00,0.00,0.00,665605),('5','102','232800','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,665606),('5','102','232801','249',163.00,165.00,0.00,0.00,0.00,0.00,0.00,665607),('5','102','232801','250',300.00,295.00,0.00,0.00,0.00,0.00,0.00,665608),('5','102','232801','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,665609),('5','102','232803','249',163.00,165.00,0.00,0.00,0.00,0.00,0.00,665613),('5','102','232803','250',300.00,295.00,0.00,0.00,0.00,0.00,0.00,665614),('5','102','232803','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,665615),('5','102','232804','249',163.00,165.00,0.00,0.00,0.00,0.00,0.00,665616),('5','102','232804','250',300.00,295.00,0.00,0.00,0.00,0.00,0.00,665617),('5','102','232804','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,665618),('5','102','232809','249',163.00,165.00,0.00,0.00,0.00,0.00,0.00,665631),('5','102','232809','250',300.00,295.00,0.00,0.00,0.00,0.00,0.00,665632),('5','102','232809','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,665633),('5','102','232811','249',163.00,165.00,0.00,0.00,0.00,0.00,0.00,665637),('5','102','232811','250',300.00,295.00,0.00,0.00,0.00,0.00,0.00,665638),('5','102','232811','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,665639),('5','102','232812','249',163.00,165.00,0.00,0.00,0.00,0.00,0.00,665640),('5','102','232812','250',300.00,295.00,0.00,0.00,0.00,0.00,0.00,665641),('5','102','232812','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,665642),('5','102','232814','249',163.00,165.00,0.00,0.00,0.00,0.00,0.00,665646),('5','102','232814','250',300.00,295.00,0.00,0.00,0.00,0.00,0.00,665647),('5','102','232814','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,665648),('5','102','232816','249',163.00,165.00,0.00,0.00,0.00,0.00,0.00,665652),('5','102','232816','250',300.00,295.00,0.00,0.00,0.00,0.00,0.00,665653),('5','102','232816','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,665654),('5','102','232817','249',163.00,165.00,0.00,0.00,0.00,0.00,0.00,665655),('5','102','232817','250',300.00,295.00,0.00,0.00,0.00,0.00,0.00,665656),('5','102','232817','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,665657),('5','102','233066','249',163.00,165.00,0.00,0.00,0.00,0.00,0.00,666303),('5','102','233066','250',300.00,295.00,0.00,0.00,0.00,0.00,0.00,666304),('5','102','233066','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,666305),('5','102','233316','249',163.00,165.00,0.00,0.00,0.00,0.00,0.00,666956),('5','102','233316','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,666957),('5','102','233316','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,666958),('5','102','233569','249',163.00,165.00,0.00,0.00,0.00,0.00,0.00,667619),('5','102','233569','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,667620),('5','102','233569','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,667621),('5','102','234241','249',163.00,165.00,0.00,0.00,0.00,0.00,0.00,669385),('5','102','234241','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,669386),('5','102','234241','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,669387),('5','102','234273','249',163.00,165.00,0.00,0.00,0.00,0.00,0.00,669473),('5','102','234273','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,669474),('5','102','234273','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,669475),('5','102','234274','249',163.00,165.00,0.00,0.00,0.00,0.00,0.00,669476),('5','102','234274','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,669477),('5','102','234274','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,669478),('5','102','234769','249',163.00,165.00,0.00,0.00,0.00,0.00,0.00,670790),('5','102','234769','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,670791),('5','102','234769','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,670792),('5','102','235450','249',163.00,165.00,0.00,0.00,0.00,0.00,0.00,672581),('5','102','235450','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,672582),('5','102','235450','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,672583),('5','102','235701','249',163.00,165.00,0.00,0.00,0.00,0.00,0.00,673228),('5','102','235701','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,673229),('5','102','235701','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,673230),('5','102','236569','249',163.00,165.00,0.00,0.00,0.00,0.00,0.00,675497),('5','102','236569','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,675498),('5','102','236569','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,675499),('5','102','236598','249',163.00,165.00,0.00,0.00,0.00,0.00,0.00,675574),('5','102','236598','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,675575),('5','102','236598','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,675576),('5','102','236657','249',163.00,165.00,0.00,0.00,0.00,0.00,0.00,675736),('5','102','236657','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,675737),('5','102','236657','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,675738),('5','102','236660','249',163.00,165.00,0.00,0.00,0.00,0.00,0.00,675746),('5','102','236660','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,675747),('5','102','236660','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,675748),('5','102','236661','249',163.00,165.00,0.00,0.00,0.00,0.00,0.00,675749),('5','102','236661','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,675750),('5','102','236661','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,675751),('5','102','236664','249',163.00,165.00,0.00,0.00,0.00,0.00,0.00,675756),('5','102','236664','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,675757),('5','102','236664','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,675758),('5','102','236665','249',163.00,165.00,1536.23,0.00,0.00,0.00,0.00,675759),('5','102','236665','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,675760),('5','102','236665','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,675761),('5','102','238455','249',165.00,165.00,8811.52,0.00,0.00,0.00,0.00,680380),('5','102','238455','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,680381),('5','102','238455','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,680382),('5','102','238458','249',165.00,165.00,11739.43,0.00,0.00,0.00,0.00,680387),('5','102','238458','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,680388),('5','102','238458','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,680389),('5','102','238464','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,680405),('5','102','238464','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,680406),('5','102','238464','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,680407),('5','102','238468','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,680417),('5','102','238468','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,680418),('5','102','238468','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,680419),('5','102','239060','249',165.00,165.00,13604.91,0.00,0.00,0.00,0.00,681951),('5','102','239060','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,681952),('5','102','239060','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,681953),('5','102','239187','249',165.00,165.00,4561.89,0.00,0.00,0.00,0.00,682287),('5','102','239187','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,682288),('5','102','239187','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,682289),('5','102','239190','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,682296),('5','102','239190','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,682297),('5','102','239190','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,682298),('5','102','239196','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,682311),('5','102','239196','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,682312),('5','102','239196','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,682313),('5','102','239197','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,682314),('5','102','239197','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,682315),('5','102','239197','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,682316),('5','102','239198','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,682317),('5','102','239198','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,682318),('5','102','239198','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,682319),('5','102','239200','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,682323),('5','102','239200','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,682324),('5','102','239200','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,682325),('5','102','239223','249',165.00,165.00,6038.52,0.00,0.00,0.00,0.00,682388),('5','102','239223','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,682389),('5','102','239223','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,682390),('5','102','239224','249',165.00,165.00,5864.37,0.00,0.00,0.00,0.00,682391),('5','102','239224','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,682392),('5','102','239224','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,682393),('5','102','239462','249',165.00,165.00,4556.02,0.00,0.00,0.00,0.00,683008),('5','102','239462','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,683009),('5','102','239462','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,683010),('5','102','239715','249',165.00,165.00,4602.76,0.00,0.00,0.00,0.00,683666),('5','102','239715','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,683667),('5','102','239715','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,683668),('5','102','239947','249',165.00,165.00,4144.05,0.00,0.00,0.00,0.00,684275),('5','102','239947','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,684276),('5','102','239947','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,684277),('5','102','240516','249',165.00,165.00,3951.94,0.00,0.00,0.00,0.00,685729),('5','102','240516','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,685730),('5','102','240516','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,685731),('5','102','240518','249',165.00,165.00,3667.26,0.00,0.00,0.00,0.00,685735),('5','102','240518','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,685736),('5','102','240518','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,685737),('5','102','240521','249',165.00,165.00,3641.64,0.00,0.00,0.00,0.00,685744),('5','102','240521','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,685745),('5','102','240521','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,685746),('5','102','241609','249',165.00,165.00,3266.32,0.00,0.00,0.00,0.00,688577),('5','102','241609','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,688578),('5','102','241609','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,688579),('5','102','241612','249',165.00,165.00,276.59,0.00,0.00,0.00,0.00,688585),('5','102','241612','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,688586),('5','102','241612','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,688587),('5','102','242592','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,691146),('5','102','242592','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,691147),('5','102','242592','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,691148),('5','102','242759','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,691565),('5','102','242759','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,691566),('5','102','242759','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,691567),('5','102','242762','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,691574),('5','102','242762','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,691575),('5','102','242762','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,691576),('5','102','242765','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,691581),('5','102','242765','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,691582),('5','102','242765','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,691583),('5','102','242766','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,691584),('5','102','242766','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,691585),('5','102','242766','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,691586),('5','102','242770','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,691596),('5','102','242770','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,691597),('5','102','242770','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,691598),('5','102','243080','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,692424),('5','102','243080','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,692425),('5','102','243080','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,692426),('5','102','243467','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,693421),('5','102','243467','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,693422),('5','102','243467','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,693423),('5','102','243469','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,693427),('5','102','243469','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,693428),('5','102','243469','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,693429),('5','102','243470','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,693430),('5','102','243470','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,693431),('5','102','243470','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,693432),('5','102','243931','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,694617),('5','102','243931','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,694618),('5','102','243931','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,694619),('5','102','244008','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,694835),('5','102','244008','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,694836),('5','102','244008','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,694837),('5','102','244220','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,695384),('5','102','244220','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,695385),('5','102','244220','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,695386),('5','102','244615','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,696394),('5','102','244615','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,696395),('5','102','244615','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,696396),('5','102','244801','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,696882),('5','102','244801','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,696883),('5','102','244801','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,696884),('5','102','245080','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,697607),('5','102','245080','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,697608),('5','102','245080','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,697609),('5','102','245594','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,698945),('5','102','245594','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,698946),('5','102','245594','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,698947),('5','102','245657','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699116),('5','102','245657','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,699117),('5','102','245657','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,699118),('5','102','245750','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699327),('5','102','245750','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,699328),('5','102','245750','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,699329),('5','102','245828','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699538),('5','102','245828','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,699539),('5','102','245828','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,699540),('5','102','246223','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,700553),('5','102','246223','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,700554),('5','102','246223','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,700555),('5','102','246306','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,700785),('5','102','246306','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,700786),('5','102','246306','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,700787),('5','102','246868','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,702261),('5','102','246868','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,702262),('5','102','246868','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,702263),('5','102','247272','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,703290),('5','102','247272','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,703291),('5','102','247272','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,703292),('5','102','247358','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,703528),('5','102','247358','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,703529),('5','102','247358','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,703530),('5','102','247479','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,703810),('5','102','247479','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,703811),('5','102','247479','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,703812),('5','102','248007','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,705182),('5','102','248007','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,705183),('5','102','248007','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,705184),('5','102','248008','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,705185),('5','102','248008','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,705186),('5','102','248008','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,705187),('5','102','248010','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,705191),('5','102','248010','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,705192),('5','102','248010','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,705193),('5','102','248986','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,707717),('5','102','248986','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,707718),('5','102','248986','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,707719),('5','102','249528','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,709108),('5','102','249528','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,709109),('5','102','249528','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,709110),('5','102','249767','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,709725),('5','102','249767','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,709726),('5','102','249767','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,709727),('5','102','250130','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,710629),('5','102','250130','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,710630),('5','102','250130','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,710631),('5','102','250488','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,711556),('5','102','250488','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,711557),('5','102','250488','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,711558),('5','102','250695','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,712090),('5','102','250695','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,712091),('5','102','250695','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,712092),('5','102','250699','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,712102),('5','102','250699','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,712103),('5','102','250699','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,712104),('5','102','250704','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,712115),('5','102','250704','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,712116),('5','102','250704','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,712117),('5','102','250707','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,712124),('5','102','250707','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,712125),('5','102','250707','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,712126),('5','102','250710','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,712133),('5','102','250710','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,712134),('5','102','250710','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,712135),('5','102','250712','249',165.00,165.00,2749.72,0.00,0.00,0.00,0.00,712139),('5','102','250712','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,712140),('5','102','250712','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,712141),('5','102','251352','249',165.00,165.00,8302.00,0.00,0.00,0.00,0.00,713787),('5','102','251352','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,713788),('5','102','251352','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,713789),('5','102','251356','249',165.00,165.00,12441.97,0.00,0.00,0.00,0.00,713799),('5','102','251356','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,713800),('5','102','251356','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,713801),('5','102','251364','249',165.00,165.00,8605.31,0.00,0.00,0.00,0.00,713821),('5','102','251364','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,713822),('5','102','251364','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,713823),('5','102','251850','249',165.00,165.00,6167.03,0.00,0.00,0.00,0.00,715092),('5','102','251850','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,715093),('5','102','251850','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,715094),('5','102','252491','249',165.00,165.00,965.00,0.00,0.00,0.00,0.00,716764),('5','102','252491','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,716765),('5','102','252491','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,716766),('5','102','253150','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,718489),('5','102','253150','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,718490),('5','102','253150','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,718491),('5','102','253151','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,718492),('5','102','253151','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,718493),('5','102','253151','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,718494),('5','102','253153','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,718498),('5','102','253153','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,718499),('5','102','253153','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,718500),('5','102','253154','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,718501),('5','102','253154','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,718502),('5','102','253154','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,718503),('5','102','253157','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,718509),('5','102','253157','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,718510),('5','102','253157','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,718511),('5','102','253309','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,718893),('5','102','253309','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,718894),('5','102','253309','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,718895),('5','102','253573','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,719575),('5','102','253573','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,719576),('5','102','253573','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,719577),('5','102','253797','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,720151),('5','102','253797','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,720152),('5','102','253797','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,720153),('5','102','254074','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,720882),('5','102','254074','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,720883),('5','102','254074','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,720884),('5','102','254369','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,721651),('5','102','254369','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,721652),('5','102','254369','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,721653),('5','102','254643','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,722355),('5','102','254643','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,722356),('5','102','254643','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,722357),('5','102','254859','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,722895),('5','102','254859','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,722896),('5','102','254859','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,722897),('5','102','255147','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,723641),('5','102','255147','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,723642),('5','102','255147','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,723643),('5','102','255313','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,724048),('5','102','255313','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,724049),('5','102','255313','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,724050),('5','102','255762','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,725157),('5','102','255762','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,725158),('5','102','255762','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,725159),('5','102','255893','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,725505),('5','102','255893','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,725506),('5','102','255893','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,725507),('5','102','256179','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,726224),('5','102','256179','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,726225),('5','102','256179','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,726226),('5','102','256311','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,726531),('5','102','256311','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,726532),('5','102','256311','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,726533),('5','102','256563','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,727193),('5','102','256563','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,727194),('5','102','256563','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,727195),('5','102','256910','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728112),('5','102','256910','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,728113),('5','102','256910','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,728114),('5','102','257277','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729053),('5','102','257277','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729054),('5','102','257277','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729055),('5','102','257656','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730057),('5','102','257656','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730058),('5','102','257656','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730059),('5','102','257657','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730060),('5','102','257657','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730061),('5','102','257657','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730062),('5','102','257658','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730063),('5','102','257658','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730064),('5','102','257658','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730065),('5','102','257659','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730066),('5','102','257659','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730067),('5','102','257659','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730068),('5','102','257660','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730069),('5','102','257660','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730070),('5','102','257660','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730071),('5','102','257661','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730072),('5','102','257661','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730073),('5','102','257661','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730074),('5','102','257662','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730075),('5','102','257662','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730076),('5','102','257662','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730077),('5','102','257663','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730078),('5','102','257663','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730079),('5','102','257663','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730080),('5','102','257664','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730081),('5','102','257664','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730082),('5','102','257664','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730083),('5','102','257665','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730084),('5','102','257665','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730085),('5','102','257665','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730086),('5','102','257666','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730087),('5','102','257666','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730088),('5','102','257666','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730089),('5','102','257667','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730090),('5','102','257667','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730091),('5','102','257667','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730092),('5','102','257668','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730093),('5','102','257668','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730094),('5','102','257668','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730095),('5','102','257669','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730096),('5','102','257669','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730097),('5','102','257669','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730098),('5','102','257670','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730099),('5','102','257670','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730100),('5','102','257670','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730101),('5','102','257671','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730102),('5','102','257671','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730103),('5','102','257671','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730104),('5','102','257672','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730105),('5','102','257672','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730106),('5','102','257672','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730107),('5','102','257673','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730108),('5','102','257673','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730109),('5','102','257673','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730110),('5','102','257674','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730111),('5','102','257674','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730112),('5','102','257674','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730113),('5','102','257675','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730114),('5','102','257675','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730115),('5','102','257675','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730116),('5','102','257676','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730117),('5','102','257676','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730118),('5','102','257676','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730119),('5','102','257677','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730120),('5','102','257677','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730121),('5','102','257677','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730122),('5','102','257678','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730123),('5','102','257678','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730124),('5','102','257678','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730125),('5','102','257679','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730126),('5','102','257679','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730127),('5','102','257679','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730128),('5','102','257680','250',345.00,415.00,0.00,0.00,0.00,0.00,0.00,730129),('5','102','257680','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730130),('5','102','257680','249',165.00,165.00,7480.26,0.00,0.00,0.00,0.00,730131),('5','102','257681','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730132),('5','102','257681','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730133),('5','102','257681','249',165.00,165.00,16519.02,0.00,0.00,0.00,0.00,730134),('5','102','257682','249',165.00,165.00,11178.35,0.00,0.00,0.00,0.00,730135),('5','102','257682','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730136),('5','102','257682','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730137),('5','102','257683','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730138),('5','102','257683','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730139),('5','102','257683','249',165.00,165.00,5013.56,0.00,0.00,0.00,0.00,730140),('5','102','257684','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730141),('5','102','257684','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730142),('5','102','257684','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730143),('5','102','257685','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730144),('5','102','257685','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730145),('5','102','257685','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730146),('5','102','257686','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730147),('5','102','257686','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730148),('5','102','257686','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730149),('5','102','257687','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730150),('5','102','257687','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730151),('5','102','257687','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730152),('5','102','257688','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730153),('5','102','257688','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730154),('5','102','257688','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730155),('5','102','257689','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730156),('5','102','257689','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730157),('5','102','257689','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730158),('5','102','257690','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730159),('5','102','257690','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730160),('5','102','257690','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730161),('5','102','257691','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730162),('5','102','257691','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730163),('5','102','257691','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730164),('5','102','257692','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730165),('5','102','257692','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730166),('5','102','257692','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730167),('5','102','257693','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730168),('5','102','257693','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730169),('5','102','257693','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730170),('5','102','257694','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730171),('5','102','257694','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730172),('5','102','257694','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730173),('5','102','257695','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730174),('5','102','257695','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730175),('5','102','257695','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730176),('5','102','257696','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730177),('5','102','257696','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730178),('5','102','257696','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730179),('5','102','257697','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730180),('5','102','257697','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730181),('5','102','257697','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730182),('5','102','257698','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730183),('5','102','257698','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730184),('5','102','257698','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730185),('5','102','257699','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730186),('5','102','257699','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730187),('5','102','257699','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730188),('5','102','257700','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730189),('5','102','257700','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730190),('5','102','257700','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730191),('5','102','257701','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730192),('5','102','257701','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730193),('5','102','257701','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730194),('5','102','257702','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730195),('5','102','257702','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730196),('5','102','257702','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730197),('5','102','257703','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730198),('5','102','257703','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730199),('5','102','257703','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730200),('5','102','257704','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730201),('5','102','257704','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730202),('5','102','257704','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730203),('5','102','257705','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730204),('5','102','257705','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730205),('5','102','257705','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730206),('5','102','257706','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730207),('5','102','257706','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730208),('5','102','257706','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730209),('5','102','257707','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730210),('5','102','257707','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730211),('5','102','257707','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730212),('5','102','257708','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730213),('5','102','257708','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730214),('5','102','257708','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730215),('5','102','257709','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730216),('5','102','257709','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730217),('5','102','257709','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730218),('5','102','257710','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730219),('5','102','257710','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730220),('5','102','257710','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730221),('5','102','257711','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730222),('5','102','257711','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730223),('5','102','257711','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730224),('5','102','257712','249',165.00,165.00,5241.21,0.00,0.00,0.00,0.00,730225),('5','102','257712','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730226),('5','102','257712','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730227),('5','102','257713','249',165.00,165.00,16786.19,0.00,0.00,0.00,0.00,730228),('5','102','257713','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730229),('5','102','257713','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730230),('5','102','257714','249',165.00,165.00,8411.77,0.00,0.00,0.00,0.00,730231),('5','102','257714','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730232),('5','102','257714','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730233),('5','102','257715','249',165.00,165.00,7402.45,0.00,0.00,0.00,0.00,730234),('5','102','257715','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730235),('5','102','257715','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730236),('5','102','257716','249',165.00,165.00,2236.20,0.00,0.00,0.00,0.00,730237),('5','102','257716','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730238),('5','102','257716','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730239),('5','102','257717','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730240),('5','102','257717','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730241),('5','102','257717','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730242),('5','102','257718','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730243),('5','102','257718','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730244),('5','102','257718','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730245),('5','102','257719','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730246),('5','102','257719','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730247),('5','102','257719','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730248),('5','102','257720','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730249),('5','102','257720','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730250),('5','102','257720','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730251),('5','102','257721','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730252),('5','102','257721','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730253),('5','102','257721','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730254),('5','102','257722','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730255),('5','102','257722','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730256),('5','102','257722','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730257),('5','102','257723','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730258),('5','102','257723','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730259),('5','102','257723','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730260),('5','102','257724','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730261),('5','102','257724','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730262),('5','102','257724','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730263),('5','102','257725','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730264),('5','102','257725','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730265),('5','102','257725','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730266),('5','102','257726','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730267),('5','102','257726','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730268),('5','102','257726','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730269),('5','102','257727','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730270),('5','102','257727','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730271),('5','102','257727','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730272),('5','102','257728','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730273),('5','102','257728','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730274),('5','102','257728','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730275),('5','102','257729','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730276),('5','102','257729','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730277),('5','102','257729','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730278),('5','102','257730','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730279),('5','102','257730','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730280),('5','102','257730','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730281),('5','102','257731','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730282),('5','102','257731','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730283),('5','102','257731','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730284),('5','102','257732','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730285),('5','102','257732','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730286),('5','102','257732','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730287),('5','102','257733','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730288),('5','102','257733','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730289),('5','102','257733','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730290),('5','102','257734','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730291),('5','102','257734','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730292),('5','102','257734','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730293),('5','102','257735','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730294),('5','102','257735','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730295),('5','102','257735','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730296),('5','102','257736','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730297),('5','102','257736','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730298),('5','102','257736','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730299),('5','102','257737','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730300),('5','102','257737','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730301),('5','102','257737','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730302),('5','102','257738','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730303),('5','102','257738','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730304),('5','102','257738','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730305),('5','102','257739','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730306),('5','102','257739','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730307),('5','102','257739','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730308),('5','102','257740','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730309),('5','102','257740','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730310),('5','102','257740','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730311),('5','102','257741','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730312),('5','102','257741','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730313),('5','102','257741','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730314),('5','102','257742','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730315),('5','102','257742','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730316),('5','102','257742','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730317),('5','102','257743','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730318),('5','102','257743','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730319),('5','102','257743','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730320),('5','102','257744','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730321),('5','102','257744','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730322),('5','102','257744','249',165.00,165.00,4707.01,0.00,0.00,0.00,0.00,730323),('5','102','257745','249',165.00,165.00,4021.00,0.00,0.00,0.00,0.00,730324),('5','102','257745','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730325),('5','102','257745','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730326),('5','102','257746','249',165.00,165.00,4218.20,0.00,0.00,0.00,0.00,730327),('5','102','257746','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730328),('5','102','257746','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730329),('5','102','257747','249',165.00,165.00,4667.77,0.00,0.00,0.00,0.00,730330),('5','102','257747','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730331),('5','102','257747','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730332),('5','102','257748','249',165.00,165.00,4200.60,0.00,0.00,0.00,0.00,730333),('5','102','257748','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730334),('5','102','257748','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730335),('5','102','257749','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730336),('5','102','257749','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730337),('5','102','257749','249',165.00,165.00,4411.69,0.00,0.00,0.00,0.00,730338),('5','102','257750','249',165.00,165.00,4178.61,0.00,0.00,0.00,0.00,730339),('5','102','257750','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730340),('5','102','257750','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730341),('5','102','257751','249',165.00,165.00,6257.86,0.00,0.00,0.00,0.00,730342),('5','102','257751','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730343),('5','102','257751','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730344),('5','102','257752','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730345),('5','102','257752','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730346),('5','102','257752','249',165.00,165.00,3360.21,0.00,0.00,0.00,0.00,730347),('5','102','257753','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730348),('5','102','257753','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730349),('5','102','257753','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730350),('5','102','257754','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730351),('5','102','257754','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730352),('5','102','257754','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730353),('5','102','257755','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730354),('5','102','257755','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730355),('5','102','257755','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730356),('5','102','257756','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730357),('5','102','257756','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730358),('5','102','257756','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730359),('5','102','257757','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730360),('5','102','257757','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730361),('5','102','257757','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730362),('5','102','257758','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730363),('5','102','257758','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730364),('5','102','257758','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730365),('5','102','257759','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730366),('5','102','257759','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730367),('5','102','257759','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730368),('5','102','257760','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730369),('5','102','257760','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730370),('5','102','257760','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730371),('5','102','257761','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730372),('5','102','257761','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730373),('5','102','257761','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730374),('5','102','257762','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730375),('5','102','257762','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730376),('5','102','257762','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730377),('5','102','257763','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730378),('5','102','257763','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730379),('5','102','257763','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730380),('5','102','257764','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730381),('5','102','257764','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730382),('5','102','257764','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730383),('5','102','257765','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730384),('5','102','257765','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730385),('5','102','257765','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730386),('5','102','257766','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730387),('5','102','257766','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730388),('5','102','257766','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730389),('5','102','257767','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730390),('5','102','257767','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730391),('5','102','257767','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730392),('5','102','257768','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730393),('5','102','257768','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730394),('5','102','257768','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730395),('5','102','257769','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730396),('5','102','257769','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730397),('5','102','257769','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730398),('5','102','257770','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730399),('5','102','257770','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730400),('5','102','257770','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730401),('5','102','257771','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730402),('5','102','257771','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730403),('5','102','257771','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730404),('5','102','257772','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730405),('5','102','257772','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730406),('5','102','257772','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730407),('5','102','257773','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730408),('5','102','257773','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730409),('5','102','257773','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730410),('5','102','257774','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730411),('5','102','257774','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730412),('5','102','257774','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730413),('5','102','257775','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730414),('5','102','257775','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730415),('5','102','257775','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730416),('5','102','257776','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730417),('5','102','257776','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730418),('5','102','257776','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730419),('5','102','257777','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730420),('5','102','257777','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730421),('5','102','257777','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730422),('5','102','257778','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730423),('5','102','257778','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730424),('5','102','257778','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730425),('5','102','257779','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730426),('5','102','257779','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730427),('5','102','257779','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730428),('5','102','257780','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730429),('5','102','257780','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730430),('5','102','257780','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730431),('5','102','257781','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730432),('5','102','257781','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730433),('5','102','257781','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730434),('5','102','257782','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730435),('5','102','257782','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730436),('5','102','257782','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730437),('5','102','257783','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730438),('5','102','257783','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730439),('5','102','257783','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730440),('5','102','257784','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730441),('5','102','257784','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730442),('5','102','257784','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730443),('5','102','257785','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730444),('5','102','257785','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730445),('5','102','257785','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730446),('5','102','257786','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730447),('5','102','257786','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730448),('5','102','257786','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730449),('5','102','257787','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730450),('5','102','257787','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730451),('5','102','257787','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730452),('5','102','257788','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730453),('5','102','257788','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730454),('5','102','257788','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730455),('5','102','257789','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730456),('5','102','257789','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730457),('5','102','257789','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730458),('5','102','257790','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730459),('5','102','257790','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730460),('5','102','257790','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730461),('5','102','257791','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730462),('5','102','257791','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730463),('5','102','257791','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730464),('5','102','257792','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730465),('5','102','257792','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730466),('5','102','257792','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730467),('5','102','257793','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730468),('5','102','257793','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730469),('5','102','257793','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730470),('5','102','257794','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730471),('5','102','257794','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730472),('5','102','257794','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730473),('5','102','257795','250',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730474),('5','102','257795','251',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730475),('5','102','257795','249',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730476);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=257 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('5',256,'102','PMS TANKS','TANKS CONTAINING PETROLEUM');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=635 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('5','102','256',631,0,'249','PMS TANK 1',34500.00,1.00,6726.96,'TANK CONTAINING PMS','415','2019-02-23 19:06:43','2021-07-12 11:03:22','600',5,1),('5','102','256',632,0,'249','PMS TANK 2',35000.00,1.00,801.27,'TANK CONTAINING PMS','415','2019-02-23 19:15:08','2021-07-12 11:03:52','600',5,1),('5','102','256',633,0,'250','AGO TANK',34000.00,1.00,145.00,'TANK CONTAINING AGO','415','2019-02-23 19:17:18','2019-02-23 19:17:18','415',5,1),('5','102','256',634,0,'251','DPK TANK',34000.00,1.00,0.00,'TANK CONTAINING DPK','415','2019-02-23 19:18:30','2019-02-23 19:18:30','415',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2613954 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2434484,'5','102',NULL,249,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,6476250.00,39250.00,0.00,0.00,'2022-01-04 09:07:38','',''),(2434932,'5','102',NULL,249,'Reception corrector for bridging 129658',0.00,0.00,0.00,25800.00,0.00,'2022-01-04 09:49:25','',''),(2434933,'5','102','631',249,'Received from bridging 129658',0.00,0.00,25800.00,0.00,0.00,'2022-01-04 09:49:25','',''),(2434936,'5','102',NULL,249,'Reception corrector for bridging 129659',0.00,0.00,0.00,13450.00,0.00,'2022-01-04 09:49:36','',''),(2434937,'5','102','632',249,'Received from bridging 129659',0.00,0.00,13450.00,0.00,0.00,'2022-01-04 09:49:36','',''),(2437518,'5','102','632',249,'Sale Id shift 250712',0.00,0.00,0.00,1535.45,0.00,'2022-01-04 13:57:36','',''),(2437519,'5','102','631',249,'Sale Id shift 250712',0.00,0.00,0.00,1214.27,0.00,'2022-01-04 13:57:36','',''),(2437520,'5','102',NULL,249,'Sale Id shift 250712',453703.80,0.00,0.00,0.00,0.00,'2022-01-04 13:57:36','',''),(2442592,'5','102','632',249,'Sale Id shift 251352',0.00,0.00,0.00,4275.91,0.00,'2022-01-05 10:58:46','',''),(2442593,'5','102','631',249,'Sale Id shift 251352',0.00,0.00,0.00,4026.09,0.00,'2022-01-05 10:58:46','',''),(2442594,'5','102',NULL,249,'Sale Id shift 251352',1369830.00,0.00,0.00,0.00,0.00,'2022-01-05 10:58:46','',''),(2442687,'5','102','632',249,'Sale Id shift 251356',0.00,0.00,0.00,6112.39,0.00,'2022-01-05 11:06:23','',''),(2442688,'5','102','631',249,'Sale Id shift 251356',0.00,0.00,0.00,6329.58,0.00,'2022-01-05 11:06:23','',''),(2442689,'5','102',NULL,249,'Sale Id shift 251356',2052925.05,0.00,0.00,0.00,0.00,'2022-01-05 11:06:23','',''),(2454923,'5','102','632',249,'Sale Id shift 251364',0.00,0.00,0.00,1568.25,0.00,'2022-01-06 18:17:16','',''),(2454924,'5','102','631',249,'Sale Id shift 251364',0.00,0.00,0.00,7037.06,0.00,'2022-01-06 18:17:16','',''),(2454925,'5','102',NULL,249,'Sale Id shift 251364',1419876.15,0.00,0.00,0.00,0.00,'2022-01-06 18:17:17','',''),(2459006,'5','102','631',249,'Sale Id shift 251850',0.00,0.00,0.00,6167.03,0.00,'2022-01-07 12:35:37','',''),(2459007,'5','102',NULL,249,'Sale Id shift 251850',1017559.95,0.00,0.00,0.00,0.00,'2022-01-07 12:35:37','',''),(2501369,'5','102','631',249,'Sale Id shift 252491',0.00,0.00,0.00,965.00,0.00,'2022-01-12 19:52:23','',''),(2501370,'5','102',NULL,249,'Sale Id shift 252491',159225.00,0.00,0.00,0.00,0.00,'2022-01-12 19:52:23','',''),(2612719,'5','102',NULL,250,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,43500.00,290.00,145.00,0.00,'2021-11-30 23:59:59','',''),(2612732,'5','102',NULL,249,'Balance from closing inventory values 2021-11-31 23:59:59',13240396.79,13347678.00,161812.00,161169.45,0.00,'2021-11-30 23:59:59','',''),(2613058,'5','102',NULL,251,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613332,'5','102','634',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613453,'5','102','631',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,53190.00,53065.03,0.00,'2021-11-30 23:59:59','',''),(2613737,'5','102','633',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,145.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613887,'5','102','632',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,27716.00,27198.42,0.00,'2021-11-30 23:59:59','',''),(2613888,'5','102',NULL,249,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,6600000.00,40000.00,0.00,0.00,'2022-02-23 18:43:37','',''),(2613889,'5','102',NULL,249,'Reception corrector for bridging 129661',0.00,0.00,0.00,13500.00,0.00,'2022-02-23 20:53:29','',''),(2613890,'5','102','632',249,'Received from bridging 129661',0.00,0.00,13500.00,0.00,0.00,'2022-02-23 20:53:29','',''),(2613891,'5','102',NULL,249,'Reception corrector for bridging 129660',0.00,0.00,0.00,26500.00,0.00,'2022-02-23 20:54:06','',''),(2613892,'5','102','631',249,'Received from bridging 129660',0.00,0.00,26500.00,0.00,0.00,'2022-02-23 20:54:06','',''),(2613893,'5','102','632',249,'Sale Id shift 257680',0.00,0.00,0.00,3299.68,0.00,'2022-02-24 07:02:42','',''),(2613894,'5','102','631',249,'Sale Id shift 257680',0.00,0.00,0.00,4180.58,0.00,'2022-02-24 07:02:42','',''),(2613895,'5','102',NULL,249,'Sale Id shift 257680',1234242.90,0.00,0.00,0.00,0.00,'2022-02-24 07:02:42','',''),(2613896,'5','102','632',249,'Sale Id shift 257681',0.00,0.00,0.00,6827.70,0.00,'2022-02-25 23:20:10','',''),(2613897,'5','102','631',249,'Sale Id shift 257681',0.00,0.00,0.00,9691.32,0.00,'2022-02-25 23:20:10','',''),(2613898,'5','102',NULL,249,'Sale Id shift 257681',2725638.30,0.00,0.00,0.00,0.00,'2022-02-25 23:20:10','',''),(2613899,'5','102','632',249,'Sale Id shift 257682',0.00,0.00,0.00,2398.59,0.00,'2022-02-26 22:33:15','',''),(2613900,'5','102','631',249,'Sale Id shift 257682',0.00,0.00,0.00,8779.76,0.00,'2022-02-26 22:33:15','',''),(2613901,'5','102',NULL,249,'Sale Id shift 257682',1844427.75,0.00,0.00,0.00,0.00,'2022-02-26 22:33:15','',''),(2613902,'5','102','632',249,'Sale Id shift 257683',0.00,0.00,0.00,1300.64,0.00,'2022-02-27 09:57:40','',''),(2613903,'5','102','631',249,'Sale Id shift 257683',0.00,0.00,0.00,3712.92,0.00,'2022-02-27 09:57:40','',''),(2613904,'5','102',NULL,249,'Sale Id shift 257683',827237.40,0.00,0.00,0.00,0.00,'2022-02-27 09:57:40','',''),(2613905,'5','102',NULL,249,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,6600000.00,40000.00,0.00,0.00,'2022-03-31 10:44:56','',''),(2613906,'5','102',NULL,249,'Reception corrector for bridging 129663',0.00,0.00,0.00,13500.00,0.00,'2022-03-31 15:03:19','',''),(2613907,'5','102','632',249,'Received from bridging 129663',0.00,0.00,13500.00,0.00,0.00,'2022-03-31 15:03:19','',''),(2613908,'5','102',NULL,249,'Reception corrector for bridging 129662',0.00,0.00,0.00,26500.00,0.00,'2022-03-31 15:03:30','',''),(2613909,'5','102','631',249,'Received from bridging 129662',0.00,0.00,26500.00,0.00,0.00,'2022-03-31 15:03:30','',''),(2613910,'5','102','632',249,'Sale Id shift 257712',0.00,0.00,0.00,2633.90,0.00,'2022-03-31 15:09:19','',''),(2613911,'5','102','631',249,'Sale Id shift 257712',0.00,0.00,0.00,2607.31,0.00,'2022-03-31 15:09:19','',''),(2613912,'5','102',NULL,249,'Sale Id shift 257712',864799.65,0.00,0.00,0.00,0.00,'2022-03-31 15:09:19','',''),(2613913,'5','102','632',249,'Sale Id shift 257713',0.00,0.00,0.00,7229.95,0.00,'2022-03-31 15:19:21','',''),(2613914,'5','102','631',249,'Sale Id shift 257713',0.00,0.00,0.00,9556.24,0.00,'2022-03-31 15:19:21','',''),(2613915,'5','102',NULL,249,'Sale Id shift 257713',2769721.35,0.00,0.00,0.00,0.00,'2022-03-31 15:19:21','',''),(2613916,'5','102','632',249,'Sale Id shift 257714',0.00,0.00,0.00,1248.87,0.00,'2022-03-31 15:25:33','',''),(2613917,'5','102','631',249,'Sale Id shift 257714',0.00,0.00,0.00,7162.90,0.00,'2022-03-31 15:25:33','',''),(2613918,'5','102',NULL,249,'Sale Id shift 257714',1387942.05,0.00,0.00,0.00,0.00,'2022-03-31 15:25:33','',''),(2613919,'5','102','632',249,'Sale Id shift 257715',0.00,0.00,0.00,982.77,0.00,'2022-03-31 15:29:15','',''),(2613920,'5','102','631',249,'Sale Id shift 257715',0.00,0.00,0.00,6419.68,0.00,'2022-03-31 15:29:15','',''),(2613921,'5','102',NULL,249,'Sale Id shift 257715',1221404.25,0.00,0.00,0.00,0.00,'2022-03-31 15:29:15','',''),(2613922,'5','102','632',249,'Sale Id shift 257716',0.00,0.00,0.00,1404.74,0.00,'2022-04-04 09:45:07','',''),(2613923,'5','102','631',249,'Sale Id shift 257716',0.00,0.00,0.00,831.46,0.00,'2022-04-04 09:45:07','',''),(2613924,'5','102',NULL,249,'Sale Id shift 257716',368973.00,0.00,0.00,0.00,0.00,'2022-04-04 09:45:07','',''),(2613925,'5','102',NULL,249,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,6600000.00,40000.00,0.00,0.00,'2022-05-10 09:53:22','',''),(2613926,'5','102',NULL,249,'Reception corrector for bridging 129665',0.00,0.00,0.00,13000.00,0.00,'2022-05-10 11:10:18','',''),(2613927,'5','102','632',249,'Received from bridging 129665',0.00,0.00,13000.00,0.00,0.00,'2022-05-10 11:10:18','',''),(2613928,'5','102',NULL,249,'Reception corrector for bridging 129664',0.00,0.00,0.00,27000.00,0.00,'2022-05-10 11:10:29','',''),(2613929,'5','102','631',249,'Received from bridging 129664',0.00,0.00,27000.00,0.00,0.00,'2022-05-10 11:10:29','',''),(2613930,'5','102','632',249,'Sale Id shift 257744',0.00,0.00,0.00,2799.99,0.00,'2022-05-10 11:18:41','',''),(2613931,'5','102','631',249,'Sale Id shift 257744',0.00,0.00,0.00,1907.02,0.00,'2022-05-10 11:18:41','',''),(2613932,'5','102',NULL,249,'Sale Id shift 257744',776656.65,0.00,0.00,0.00,0.00,'2022-05-10 11:18:41','',''),(2613933,'5','102','632',249,'Sale Id shift 257745',0.00,0.00,0.00,2222.70,0.00,'2022-05-10 11:21:45','',''),(2613934,'5','102','631',249,'Sale Id shift 257745',0.00,0.00,0.00,1798.30,0.00,'2022-05-10 11:21:45','',''),(2613935,'5','102',NULL,249,'Sale Id shift 257745',663465.00,0.00,0.00,0.00,0.00,'2022-05-10 11:21:45','',''),(2613936,'5','102','632',249,'Sale Id shift 257746',0.00,0.00,0.00,2078.48,0.00,'2022-05-10 11:35:21','',''),(2613937,'5','102','631',249,'Sale Id shift 257746',0.00,0.00,0.00,2139.72,0.00,'2022-05-10 11:35:21','',''),(2613938,'5','102',NULL,249,'Sale Id shift 257746',696003.00,0.00,0.00,0.00,0.00,'2022-05-10 11:35:21','',''),(2613939,'5','102','632',249,'Sale Id shift 257747',0.00,0.00,0.00,2368.30,0.00,'2022-05-10 11:40:56','',''),(2613940,'5','102','631',249,'Sale Id shift 257747',0.00,0.00,0.00,2299.47,0.00,'2022-05-10 11:40:56','',''),(2613941,'5','102',NULL,249,'Sale Id shift 257747',770182.05,0.00,0.00,0.00,0.00,'2022-05-10 11:40:56','',''),(2613942,'5','102','632',249,'Sale Id shift 257748',0.00,0.00,0.00,1736.40,0.00,'2022-05-10 11:44:48','',''),(2613943,'5','102','631',249,'Sale Id shift 257748',0.00,0.00,0.00,2464.20,0.00,'2022-05-10 11:44:48','',''),(2613944,'5','102',NULL,249,'Sale Id shift 257748',693099.00,0.00,0.00,0.00,0.00,'2022-05-10 11:44:48','',''),(2613945,'5','102','632',249,'Sale Id shift 257749',0.00,0.00,0.00,1788.06,0.00,'2022-05-10 11:48:30','',''),(2613946,'5','102','631',249,'Sale Id shift 257749',0.00,0.00,0.00,2623.63,0.00,'2022-05-10 11:48:30','',''),(2613947,'5','102',NULL,249,'Sale Id shift 257749',727928.85,0.00,0.00,0.00,0.00,'2022-05-10 11:48:30','',''),(2613948,'5','102','631',249,'Sale Id shift 257750',0.00,0.00,0.00,4178.61,0.00,'2022-05-10 11:50:28','',''),(2613949,'5','102',NULL,249,'Sale Id shift 257750',689470.65,0.00,0.00,0.00,0.00,'2022-05-10 11:50:28','',''),(2613950,'5','102','631',249,'Sale Id shift 257751',0.00,0.00,0.00,6257.86,0.00,'2022-05-10 11:53:14','',''),(2613951,'5','102',NULL,249,'Sale Id shift 257751',1032546.90,0.00,0.00,0.00,0.00,'2022-05-10 11:53:14','',''),(2613952,'5','102','631',249,'Sale Id shift 257752',0.00,0.00,0.00,3360.21,0.00,'2022-05-10 11:56:00','',''),(2613953,'5','102',NULL,249,'Sale Id shift 257752',554434.65,0.00,0.00,0.00,0.00,'2022-05-10 11:56:00','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1729032 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (1032974,'5','102',249,'Sale Id shift 213197',0.00,101329.80,165.00,101329.80,0.00,'2021-07-27 09:30:22'),(1033197,'5','102',249,'Sale Id shift 213205',0.00,378043.05,165.00,378043.05,0.00,'2021-07-27 10:07:34'),(1034727,'5','102',249,'Sale Id shift 213306',0.00,279490.20,165.00,279490.20,0.00,'2021-07-27 14:37:07'),(1036798,'5','102',249,'Sale Id shift 213382',0.00,231892.65,165.00,231892.65,0.00,'2021-07-28 08:55:54'),(1038714,'5','102',249,'Sale Id shift 213448',0.00,301418.70,165.00,301418.70,0.00,'2021-07-28 15:39:26'),(1040187,'5','102',249,'Sale Id shift 213625',0.00,257193.75,165.00,257193.75,0.00,'2021-07-29 09:01:33'),(1044437,'5','102',249,'Sale Id shift 213884',0.00,262970.40,165.00,262970.40,0.00,'2021-07-30 09:50:39'),(1050411,'5','102',249,'Sale Id shift 214101',0.00,307832.25,165.00,307832.25,0.00,'2021-07-31 15:07:34'),(1051482,'5','102',249,'Sale Id shift 214310',0.00,321076.80,165.00,321076.80,0.00,'2021-08-01 06:34:04'),(1055161,'5','102',249,'Sale Id shift 214529',0.00,266453.55,165.00,266453.55,0.00,'2021-08-02 06:24:30'),(1059951,'5','102',249,'Sale Id shift 214532',0.00,273659.10,165.00,273659.10,0.00,'2021-08-03 08:14:30'),(1063715,'5','102',249,'Sale Id shift 214949',0.00,408241.35,165.00,408241.35,0.00,'2021-08-03 20:47:16'),(1067363,'5','102',249,'Sale Id shift 215106',0.00,354070.20,165.00,354070.20,0.00,'2021-08-05 05:43:54'),(1070551,'5','102',249,'Sale Id shift 215351',0.00,374764.50,165.00,374764.50,0.00,'2021-08-06 00:09:48'),(1074744,'5','102',249,'Sale Id shift 215654',0.00,297661.65,165.00,297661.65,0.00,'2021-08-07 04:55:49'),(1078851,'5','102',249,'Sale Id shift 215881',0.00,284161.35,165.00,284161.35,0.00,'2021-08-08 06:18:30'),(1082591,'5','102',249,'Sale Id shift 216076',0.00,239347.35,165.00,239347.35,0.00,'2021-08-08 22:21:41'),(1086650,'5','102',249,'Sale Id shift 216309',0.00,290635.95,165.00,290635.95,0.00,'2021-08-10 05:36:06'),(1090431,'5','102',249,'Sale Id shift 216533',0.00,307332.30,165.00,307332.30,0.00,'2021-08-11 05:27:20'),(1093643,'5','102',249,'Sale Id shift 216627',0.00,311851.65,165.00,311851.65,0.00,'2021-08-12 05:51:28'),(1097083,'5','102',249,'Sale Id shift 216993',0.00,342203.40,165.00,342203.40,0.00,'2021-08-13 06:32:52'),(1101326,'5','102',249,'Sale Id shift 217151',0.00,320307.90,165.00,320307.90,0.00,'2021-08-14 06:49:40'),(1109645,'5','102',249,'Sale Id shift 217463',0.00,180486.90,165.00,180486.90,0.00,'2021-08-15 18:17:19'),(1109763,'5','102',249,'Sale Id shift 217650',0.00,225485.70,165.00,225485.70,0.00,'2021-08-15 21:03:51'),(1113627,'5','102',249,'Sale Id shift 217835',0.00,309264.45,165.00,309264.45,0.00,'2021-08-16 22:42:34'),(1117559,'5','102',249,'Sale Id shift 218124',0.00,226196.85,165.00,226196.85,0.00,'2021-08-18 06:01:52'),(1121036,'5','102',249,'Sale Id shift 218299',0.00,254197.35,165.00,254197.35,0.00,'2021-08-19 04:35:19'),(1125178,'5','102',249,'Sale Id shift 218652',0.00,255850.65,165.00,255850.65,0.00,'2021-08-20 05:19:50'),(1128857,'5','102',249,'Sale Id shift 218677',0.00,204420.15,165.00,204420.15,0.00,'2021-08-21 05:07:54'),(1133345,'5','102',249,'Sale Id shift 218901',0.00,266620.20,165.00,266620.20,0.00,'2021-08-22 06:58:33'),(1137342,'5','102',249,'Sale Id shift 219317',0.00,214894.35,165.00,214894.35,0.00,'2021-08-23 06:23:55'),(1141237,'5','102',249,'Sale Id shift 219570',0.00,231320.10,165.00,231320.10,0.00,'2021-08-23 22:50:38'),(1144979,'5','102',249,'Sale Id shift 219757',0.00,239865.45,165.00,239865.45,0.00,'2021-08-24 22:11:48'),(1148792,'5','102',249,'Sale Id shift 219869',0.00,252461.55,165.00,252461.55,0.00,'2021-08-25 21:26:18'),(1152635,'5','102',249,'Sale Id shift 220022',0.00,257913.15,165.00,257913.15,0.00,'2021-08-27 06:54:18'),(1155991,'5','102',249,'Sale Id shift 220290',0.00,279757.50,165.00,279757.50,0.00,'2021-08-28 06:32:48'),(1159798,'5','102',249,'Sale Id shift 220485',0.00,282999.75,165.00,282999.75,0.00,'2021-08-29 06:54:37'),(1164015,'5','102',249,'Sale Id shift 220844',0.00,220476.30,165.00,220476.30,0.00,'2021-08-30 04:40:27'),(1168112,'5','102',249,'Sale Id shift 220902',0.00,245897.85,165.00,245897.85,0.00,'2021-08-30 21:02:50'),(1172049,'5','102',249,'Sale Id shift 221132',0.00,238088.40,165.00,238088.40,0.00,'2021-09-01 04:55:38'),(1175910,'5','102',249,'Sale Id shift 221459',0.00,284090.40,165.00,284090.40,0.00,'2021-09-02 06:24:22'),(1180953,'5','102',249,'Sale Id shift 221657',0.00,308716.65,165.00,308716.65,0.00,'2021-09-03 09:07:43'),(1185152,'5','102',249,'Sale Id shift 221996',0.00,253091.85,165.00,253091.85,0.00,'2021-09-04 08:50:52'),(1188318,'5','102',249,'Sale Id shift 222204',0.00,214618.80,165.00,214618.80,0.00,'2021-09-05 05:39:17'),(1192141,'5','102',249,'Sale Id shift 222302',0.00,148679.85,165.00,148679.85,0.00,'2021-09-06 04:05:21'),(1195646,'5','102',249,'Sale Id shift 222615',0.00,226733.10,165.00,226733.10,0.00,'2021-09-07 09:25:07'),(1196930,'5','102',249,'Sale Id shift 222874',0.00,84145.05,165.00,84145.05,0.00,'2021-09-08 09:15:52'),(1199119,'5','102',249,'Sale Id shift 223009',0.00,178137.30,165.00,178137.30,0.00,'2021-09-09 08:52:01'),(1202514,'5','102',249,'Sale Id shift 223295',0.00,204233.70,165.00,204233.70,0.00,'2021-09-10 08:36:13'),(1206208,'5','102',249,'Sale Id shift 223490',0.00,114894.45,165.00,114894.45,0.00,'2021-09-11 09:30:41'),(1211397,'5','102',249,'Sale Id shift 223746',0.00,153953.25,165.00,153953.25,0.00,'2021-09-12 14:28:53'),(1213123,'5','102',249,'Sale Id shift 224047',0.00,109228.35,165.00,109228.35,0.00,'2021-09-13 08:33:54'),(1422812,'5','102',249,'Sale Id shift 236665',0.00,250405.49,165.00,253477.95,3072.46,'2021-11-12 09:52:47'),(1422858,'5','102',249,'Sale Id shift 238455',0.00,1453900.80,165.00,1453900.80,0.00,'2021-11-12 09:58:29'),(1422898,'5','102',249,'Sale Id shift 238458',0.00,1937005.95,165.00,1937005.95,0.00,'2021-11-12 10:04:33'),(1436602,'5','102',249,'Sale Id shift 239060',0.00,2244810.15,165.00,2244810.15,0.00,'2021-11-15 10:34:05'),(1437326,'5','102',249,'Sale Id shift 239187',0.00,752711.85,165.00,752711.85,0.00,'2021-11-15 12:52:54'),(1438543,'5','102',249,'Sale Id shift 239223',0.00,996355.80,165.00,996355.80,0.00,'2021-11-15 16:02:34'),(1441856,'5','102',249,'Sale Id shift 239224',0.00,967621.05,165.00,967621.05,0.00,'2021-11-16 14:31:31'),(1447299,'5','102',249,'Sale Id shift 239462',0.00,751743.30,165.00,751743.30,0.00,'2021-11-17 18:54:43'),(1451743,'5','102',249,'Sale Id shift 239715',0.00,759455.40,165.00,759455.40,0.00,'2021-11-18 19:30:52'),(1455890,'5','102',249,'Sale Id shift 239947',0.00,683768.25,165.00,683768.25,0.00,'2021-11-19 21:56:38'),(1462362,'5','102',249,'Sale Id shift 240516',0.00,652070.10,165.00,652070.10,0.00,'2021-11-21 10:05:54'),(1462404,'5','102',249,'Sale Id shift 240518',0.00,605097.90,165.00,605097.90,0.00,'2021-11-21 10:13:12'),(1467305,'5','102',249,'Sale Id shift 240521',0.00,600870.60,165.00,600870.60,0.00,'2021-11-22 10:32:35'),(1481283,'5','102',249,'Sale Id shift 241609',0.00,538942.80,165.00,538942.80,0.00,'2021-11-25 12:23:17'),(1500609,'5','102',249,'Sale Id shift 241612',0.00,45637.35,165.00,45637.35,0.00,'2021-11-29 14:39:44'),(1684595,'5','102',249,'Sale Id shift 250712',0.00,453703.80,165.00,453703.80,0.00,'2022-01-04 13:57:36'),(1688041,'5','102',249,'Sale Id shift 251352',0.00,1369830.00,165.00,1369830.00,0.00,'2022-01-05 10:58:46'),(1688112,'5','102',249,'Sale Id shift 251356',0.00,2052925.05,165.00,2052925.05,0.00,'2022-01-05 11:06:23'),(1696820,'5','102',249,'Sale Id shift 251364',0.00,1419876.15,165.00,1419876.15,0.00,'2022-01-06 18:17:17'),(1699581,'5','102',249,'Sale Id shift 251850',0.00,1017559.95,165.00,1017559.95,0.00,'2022-01-07 12:35:37'),(1729013,'5','102',249,'Sale Id shift 252491',0.00,159225.00,165.00,159225.00,0.00,'2022-01-12 19:52:23'),(1729014,'5','102',249,'Sale Id shift 257680',0.00,1234242.90,165.00,1234242.90,0.00,'2022-02-24 07:02:42'),(1729015,'5','102',249,'Sale Id shift 257681',0.00,2725638.30,165.00,2725638.30,0.00,'2022-02-25 23:20:10'),(1729016,'5','102',249,'Sale Id shift 257682',0.00,1844427.75,165.00,1844427.75,0.00,'2022-02-26 22:33:15'),(1729017,'5','102',249,'Sale Id shift 257683',0.00,827237.40,165.00,827237.40,0.00,'2022-02-27 09:57:40'),(1729018,'5','102',249,'Sale Id shift 257712',0.00,864799.65,165.00,864799.65,0.00,'2022-03-31 15:09:19'),(1729019,'5','102',249,'Sale Id shift 257713',0.00,2769721.35,165.00,2769721.35,0.00,'2022-03-31 15:19:21'),(1729020,'5','102',249,'Sale Id shift 257714',0.00,1387942.05,165.00,1387942.05,0.00,'2022-03-31 15:25:33'),(1729021,'5','102',249,'Sale Id shift 257715',0.00,1221404.25,165.00,1221404.25,0.00,'2022-03-31 15:29:15'),(1729022,'5','102',249,'Sale Id shift 257716',0.00,368973.00,165.00,368973.00,0.00,'2022-04-04 09:45:07'),(1729023,'5','102',249,'Sale Id shift 257744',0.00,776656.65,165.00,776656.65,0.00,'2022-05-10 11:18:41'),(1729024,'5','102',249,'Sale Id shift 257745',0.00,663465.00,165.00,663465.00,0.00,'2022-05-10 11:21:45'),(1729025,'5','102',249,'Sale Id shift 257746',0.00,696003.00,165.00,696003.00,0.00,'2022-05-10 11:35:21'),(1729026,'5','102',249,'Sale Id shift 257747',0.00,770182.05,165.00,770182.05,0.00,'2022-05-10 11:40:56'),(1729027,'5','102',249,'Sale Id shift 257748',0.00,693099.00,165.00,693099.00,0.00,'2022-05-10 11:44:48'),(1729028,'5','102',249,'Sale Id shift 257749',0.00,727928.85,165.00,727928.85,0.00,'2022-05-10 11:48:30'),(1729029,'5','102',249,'Sale Id shift 257750',0.00,689470.65,165.00,689470.65,0.00,'2022-05-10 11:50:28'),(1729030,'5','102',249,'Sale Id shift 257751',0.00,1032546.90,165.00,1032546.90,0.00,'2022-05-10 11:53:14'),(1729031,'5','102',249,'Sale Id shift 257752',0.00,554434.65,165.00,554434.65,0.00,'2022-05-10 11:56:00');
/*!40000 ALTER TABLE `inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices`
--

DROP TABLE IF EXISTS `invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `expirydate` date NOT NULL,
  `notes` text,
  `status` int NOT NULL DEFAULT '0',
  `email` varchar(200) DEFAULT NULL,
  `email_sent_at` datetime DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `payment_method` varchar(50) DEFAULT NULL,
  `payment_details` text,
  `payment_status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `status` (`status`,`company_id`,`station_id`),
  KEY `email_sent_at` (`email_sent_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices`
--

LOCK TABLES `invoices` WRITE;
/*!40000 ALTER TABLE `invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices_items`
--

DROP TABLE IF EXISTS `invoices_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices_items` (
  `id` int NOT NULL AUTO_INCREMENT,
  `invoice_id` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(200) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `item_type` varchar(50) NOT NULL,
  `item_id` varchar(100) NOT NULL,
  `item_details` longtext,
  PRIMARY KEY (`id`),
  KEY `name` (`name`,`invoice_id`,`station_id`),
  KEY `companycode` (`company_id`),
  KEY `status` (`status`,`item_type`,`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices_items`
--

LOCK TABLES `invoices_items` WRITE;
/*!40000 ALTER TABLE `invoices_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ledgers`
--

DROP TABLE IF EXISTS `ledgers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ledgers` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` int NOT NULL AUTO_INCREMENT,
  `ledgertype` varchar(10) NOT NULL,
  `accounttype` varchar(50) NOT NULL,
  `accountid` varchar(50) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `details` varchar(1000) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `accounttype` (`accounttype`,`accountid`,`credit`,`debit`,`thedate`),
  KEY `cooperative` (`company_id`),
  KEY `depot_id` (`station_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=4960399 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ledgers`
--

LOCK TABLES `ledgers` WRITE;
/*!40000 ALTER TABLE `ledgers` DISABLE KEYS */;
INSERT INTO `ledgers` VALUES ('5','102',3573344,'','24','2369',0.00,43500.00,'Purchase Id 78190 for 145.00 litters of Diesel - AGO from SALBAS OIL & GAS NIG. LIMITED','2021-10-13 12:47:26','',''),('5','102',3573345,'','supplier','107',43500.00,0.00,'Purchase Id 78190 for 145.00 litters of Diesel - AGO from SALBAS OIL & GAS NIG. LIMITED','2021-10-13 12:47:26','',''),('5','102',3573356,'','24','2369',0.00,147678.00,'Purchase Id 78189 for 906.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-10-13 12:48:41','',''),('5','102',3573357,'','supplier','107',147678.00,0.00,'Purchase Id 78189 for 906.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-10-13 12:48:41','',''),('5','102',3580347,'','20','2383',0.00,0.00,'Sales from shift 229399 on 2021-10-14 08:47:01 ','2021-10-14 08:47:01','',''),('5','102',3580348,'','6.1','2371',0.00,0.00,'Sales from shift 229399 on 2021-10-14 08:47:01 ','2021-10-14 08:47:01','',''),('5','102',3633372,'','20','2383',0.00,0.00,'Sales from shift 232413 on 2021-10-19 12:46:36 ','2021-10-19 12:46:36','',''),('5','102',3633373,'','6.1','2371',0.00,0.00,'Sales from shift 232413 on 2021-10-19 12:46:36 ','2021-10-19 12:46:36','',''),('5','102',3633419,'','20','2383',0.00,0.00,'Sales from shift 232714 on 2021-10-19 12:50:19 ','2021-10-19 12:50:19','',''),('5','102',3633420,'','6.1','2371',0.00,0.00,'Sales from shift 232714 on 2021-10-19 12:50:19 ','2021-10-19 12:50:19','',''),('5','102',3633467,'','20','2383',0.00,0.00,'Sales from shift 232715 on 2021-10-19 12:53:10 ','2021-10-19 12:53:10','',''),('5','102',3633468,'','6.1','2371',0.00,0.00,'Sales from shift 232715 on 2021-10-19 12:53:10 ','2021-10-19 12:53:10','',''),('5','102',3636756,'','20','2383',0.00,0.00,'Sales from shift 232782 on 2021-10-19 19:59:36 ','2021-10-19 19:59:36','',''),('5','102',3636757,'','6.1','2371',0.00,0.00,'Sales from shift 232782 on 2021-10-19 19:59:36 ','2021-10-19 19:59:36','',''),('5','102',3636760,'','20','2383',0.00,0.00,'Sales from shift 232783 on 2021-10-19 20:07:58 ','2021-10-19 20:07:58','',''),('5','102',3636761,'','6.1','2371',0.00,0.00,'Sales from shift 232783 on 2021-10-19 20:07:58 ','2021-10-19 20:07:58','',''),('5','102',3636788,'','20','2383',0.00,0.00,'Sales from shift 232790 on 2021-10-19 20:34:07 ','2021-10-19 20:34:07','',''),('5','102',3636789,'','6.1','2371',0.00,0.00,'Sales from shift 232790 on 2021-10-19 20:34:07 ','2021-10-19 20:34:07','',''),('5','102',3636794,'','20','2383',0.00,0.00,'Sales from shift 232791 on 2021-10-19 20:39:33 ','2021-10-19 20:39:33','',''),('5','102',3636795,'','6.1','2371',0.00,0.00,'Sales from shift 232791 on 2021-10-19 20:39:33 ','2021-10-19 20:39:33','',''),('5','102',3636803,'','20','2383',0.00,0.00,'Sales from shift 232794 on 2021-10-19 20:46:29 ','2021-10-19 20:46:29','',''),('5','102',3636804,'','6.1','2371',0.00,0.00,'Sales from shift 232794 on 2021-10-19 20:46:29 ','2021-10-19 20:46:29','',''),('5','102',3636816,'','20','2383',0.00,0.00,'Sales from shift 232797 on 2021-10-19 20:54:00 ','2021-10-19 20:54:00','',''),('5','102',3636817,'','6.1','2371',0.00,0.00,'Sales from shift 232797 on 2021-10-19 20:54:00 ','2021-10-19 20:54:00','',''),('5','102',3636824,'','20','2383',0.00,0.00,'Sales from shift 232800 on 2021-10-19 21:00:03 ','2021-10-19 21:00:03','',''),('5','102',3636825,'','6.1','2371',0.00,0.00,'Sales from shift 232800 on 2021-10-19 21:00:03 ','2021-10-19 21:00:03','',''),('5','102',3636842,'','20','2383',0.00,0.00,'Sales from shift 232801 on 2021-10-19 21:10:03 ','2021-10-19 21:10:03','',''),('5','102',3636843,'','6.1','2371',0.00,0.00,'Sales from shift 232801 on 2021-10-19 21:10:03 ','2021-10-19 21:10:03','',''),('5','102',3636857,'','20','2383',0.00,0.00,'Sales from shift 232803 on 2021-10-19 21:25:18 ','2021-10-19 21:25:18','',''),('5','102',3636858,'','6.1','2371',0.00,0.00,'Sales from shift 232803 on 2021-10-19 21:25:18 ','2021-10-19 21:25:18','',''),('5','102',3636870,'','20','2383',0.00,0.00,'Sales from shift 232804 on 2021-10-19 21:39:39 ','2021-10-19 21:39:39','',''),('5','102',3636871,'','6.1','2371',0.00,0.00,'Sales from shift 232804 on 2021-10-19 21:39:39 ','2021-10-19 21:39:39','',''),('5','102',3636874,'','20','2383',0.00,0.00,'Sales from shift 232809 on 2021-10-19 21:44:02 ','2021-10-19 21:44:02','',''),('5','102',3636875,'','6.1','2371',0.00,0.00,'Sales from shift 232809 on 2021-10-19 21:44:02 ','2021-10-19 21:44:02','',''),('5','102',3636888,'','20','2383',0.00,0.00,'Sales from shift 232811 on 2021-10-19 21:51:06 ','2021-10-19 21:51:06','',''),('5','102',3636889,'','6.1','2371',0.00,0.00,'Sales from shift 232811 on 2021-10-19 21:51:06 ','2021-10-19 21:51:06','',''),('5','102',3636902,'','20','2383',0.00,0.00,'Sales from shift 232812 on 2021-10-19 21:56:39 ','2021-10-19 21:56:39','',''),('5','102',3636903,'','6.1','2371',0.00,0.00,'Sales from shift 232812 on 2021-10-19 21:56:39 ','2021-10-19 21:56:39','',''),('5','102',3636904,'','20','2383',0.00,0.00,'Sales from shift 232814 on 2021-10-19 21:59:17 ','2021-10-19 21:59:17','',''),('5','102',3636905,'','6.1','2371',0.00,0.00,'Sales from shift 232814 on 2021-10-19 21:59:17 ','2021-10-19 21:59:17','',''),('5','102',3636906,'','20','2383',0.00,0.00,'Sales from shift 232816 on 2021-10-19 22:01:31 ','2021-10-19 22:01:31','',''),('5','102',3636907,'','6.1','2371',0.00,0.00,'Sales from shift 232816 on 2021-10-19 22:01:31 ','2021-10-19 22:01:31','',''),('5','102',3636908,'','20','2383',0.00,0.00,'Sales from shift 232817 on 2021-10-19 22:03:37 ','2021-10-19 22:03:37','',''),('5','102',3636909,'','6.1','2371',0.00,0.00,'Sales from shift 232817 on 2021-10-19 22:03:37 ','2021-10-19 22:03:37','',''),('5','102',3650230,'','20','2383',0.00,0.00,'Sales from shift 233066 on 2021-10-21 08:07:47 ','2021-10-21 08:07:47','',''),('5','102',3650231,'','6.1','2371',0.00,0.00,'Sales from shift 233066 on 2021-10-21 08:07:47 ','2021-10-21 08:07:47','',''),('5','102',3658219,'','20','2383',0.00,0.00,'Sales from shift 233316 on 2021-10-22 06:29:37 ','2021-10-22 06:29:37','',''),('5','102',3658220,'','6.1','2371',0.00,0.00,'Sales from shift 233316 on 2021-10-22 06:29:37 ','2021-10-22 06:29:37','',''),('5','102',3668719,'','20','2383',0.00,0.00,'Sales from shift 233569 on 2021-10-22 21:34:09 ','2021-10-22 21:34:09','',''),('5','102',3668720,'','6.1','2371',0.00,0.00,'Sales from shift 233569 on 2021-10-22 21:34:09 ','2021-10-22 21:34:09','',''),('5','102',3697268,'','20','2383',0.00,0.00,'Sales from shift 234241 on 2021-10-25 20:06:56 ','2021-10-25 20:06:56','',''),('5','102',3697269,'','6.1','2371',0.00,0.00,'Sales from shift 234241 on 2021-10-25 20:06:56 ','2021-10-25 20:06:56','',''),('5','102',3697294,'','20','2383',0.00,0.00,'Sales from shift 234273 on 2021-10-25 20:11:28 ','2021-10-25 20:11:28','',''),('5','102',3697295,'','6.1','2371',0.00,0.00,'Sales from shift 234273 on 2021-10-25 20:11:28 ','2021-10-25 20:11:28','',''),('5','102',3697302,'','20','2383',0.00,0.00,'Sales from shift 234274 on 2021-10-25 20:14:04 ','2021-10-25 20:14:04','',''),('5','102',3697303,'','6.1','2371',0.00,0.00,'Sales from shift 234274 on 2021-10-25 20:14:04 ','2021-10-25 20:14:04','',''),('5','102',3728361,'','20','2383',0.00,0.00,'Sales from shift 234769 on 2021-10-28 15:59:45 ','2021-10-28 15:59:45','',''),('5','102',3728362,'','6.1','2371',0.00,0.00,'Sales from shift 234769 on 2021-10-28 15:59:45 ','2021-10-28 15:59:45','',''),('5','102',3757788,'','20','2383',0.00,0.00,'Sales from shift 235450 on 2021-10-31 18:09:37 ','2021-10-31 18:09:37','',''),('5','102',3757789,'','6.1','2371',0.00,0.00,'Sales from shift 235450 on 2021-10-31 18:09:37 ','2021-10-31 18:09:37','',''),('5','102',3766635,'','24','2370',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','102',3766723,'','24','2382',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','102',3766825,'','24','2380',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','102',3766834,'','24','2376',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','102',3767029,'','24','2372',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','102',3767109,'','20','2383',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','102',3767475,'','24','2378',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','102',3768130,'','24','2373',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','102',3768279,'','24','2369',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','102',3768973,'','24','2375',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','102',3768993,'','24','2368',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','102',3769002,'','24','2379',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','102',3769148,'','24','2381',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','102',3769386,'','2','2384',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','102',3769670,'','24','2374',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','102',3769824,'','22','3354',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','102',3769861,'','24','2377',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','102',3769924,'','6.1','2371',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','102',3776972,'','20','2383',0.00,0.00,'Sales from shift 235701 on 2021-11-02 16:28:35 ','2021-11-02 16:28:35','',''),('5','102',3776973,'','6.1','2371',0.00,0.00,'Sales from shift 235701 on 2021-11-02 16:28:35 ','2021-11-02 16:28:35','',''),('5','102',3793513,'','20','2383',0.00,0.00,'Sales from shift 236569 on 2021-11-04 09:41:25 ','2021-11-04 09:41:25','',''),('5','102',3793514,'','6.1','2371',0.00,0.00,'Sales from shift 236569 on 2021-11-04 09:41:25 ','2021-11-04 09:41:25','',''),('5','102',3794213,'','20','2383',0.00,0.00,'Sales from shift 236598 on 2021-11-04 10:35:15 ','2021-11-04 10:35:15','',''),('5','102',3794214,'','6.1','2371',0.00,0.00,'Sales from shift 236598 on 2021-11-04 10:35:15 ','2021-11-04 10:35:15','',''),('5','102',3798526,'','20','2383',0.00,0.00,'Sales from shift 236657 on 2021-11-04 14:08:43 ','2021-11-04 14:08:43','',''),('5','102',3798527,'','6.1','2371',0.00,0.00,'Sales from shift 236657 on 2021-11-04 14:08:43 ','2021-11-04 14:08:43','',''),('5','102',3798582,'','20','2383',0.00,0.00,'Sales from shift 236660 on 2021-11-04 14:11:08 ','2021-11-04 14:11:08','',''),('5','102',3798583,'','6.1','2371',0.00,0.00,'Sales from shift 236660 on 2021-11-04 14:11:08 ','2021-11-04 14:11:08','',''),('5','102',3798641,'','20','2383',0.00,0.00,'Sales from shift 236661 on 2021-11-04 14:12:58 ','2021-11-04 14:12:58','',''),('5','102',3798642,'','6.1','2371',0.00,0.00,'Sales from shift 236661 on 2021-11-04 14:12:58 ','2021-11-04 14:12:58','',''),('5','102',3798687,'','20','2383',0.00,0.00,'Sales from shift 236664 on 2021-11-04 14:14:45 ','2021-11-04 14:14:45','',''),('5','102',3798688,'','6.1','2371',0.00,0.00,'Sales from shift 236664 on 2021-11-04 14:14:45 ','2021-11-04 14:14:45','',''),('5','102',3798843,'','24','2369',0.00,6600000.00,'Purchase Id 79783 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-11-04 14:20:08','',''),('5','102',3798844,'','supplier','107',6600000.00,0.00,'Purchase Id 79783 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-11-04 14:20:08','',''),('5','102',3894456,'','customer','2992',0.00,2499.75,'Credit Sales for 15.15 Litres of Petrol from shift 236665 on 2021-11-12 09:52:47 ','2021-11-12 09:52:47','',''),('5','102',3894457,'','20','2383',253477.95,0.00,'Sales from shift 236665 on 2021-11-12 09:52:47 ','2021-11-12 09:52:47','',''),('5','102',3894458,'','6.1','2371',0.00,250978.20,'Sales from shift 236665 on 2021-11-12 09:52:47 ','2021-11-12 09:52:47','',''),('5','102',3894582,'','customer','2992',0.00,10998.90,'Credit Sales for 66.66 Litres of Petrol from shift 238455 on 2021-11-12 09:58:29 ','2021-11-12 09:58:29','',''),('5','102',3894583,'','20','2383',1453900.80,0.00,'Sales from shift 238455 on 2021-11-12 09:58:29 ','2021-11-12 09:58:29','',''),('5','102',3894584,'','6.1','2371',0.00,1442901.90,'Sales from shift 238455 on 2021-11-12 09:58:29 ','2021-11-12 09:58:29','',''),('5','102',3894708,'','customer','2992',0.00,14498.55,'Credit Sales for 87.87 Litres of Petrol from shift 238458 on 2021-11-12 10:04:33 ','2021-11-12 10:04:33','',''),('5','102',3894709,'','20','2383',1937005.95,0.00,'Sales from shift 238458 on 2021-11-12 10:04:33 ','2021-11-12 10:04:33','',''),('5','102',3894710,'','6.1','2371',0.00,1922507.40,'Sales from shift 238458 on 2021-11-12 10:04:33 ','2021-11-12 10:04:33','',''),('5','102',3894838,'','customer','2992',0.00,5999.40,'Credit Sales for 36.36 Litres of Petrol from shift 238464 on 2021-11-12 10:10:31 ','2021-11-12 10:10:31','',''),('5','102',3894839,'','20','2383',0.00,0.00,'Sales from shift 238464 on 2021-11-12 10:10:31 ','2021-11-12 10:10:31','',''),('5','102',3894840,'','6.1','2371',0.00,-5999.40,'Sales from shift 238464 on 2021-11-12 10:10:31 ','2021-11-12 10:10:31','',''),('5','102',3927414,'','customer','2992',0.00,2999.70,'Credit Sales for 18.18 Litres of Petrol from shift 238468 on 2021-11-14 19:32:02 ','2021-11-14 19:32:02','',''),('5','102',3927415,'','20','2383',0.00,0.00,'Sales from shift 238468 on 2021-11-14 19:32:02 ','2021-11-14 19:32:02','',''),('5','102',3927416,'','6.1','2371',0.00,-2999.70,'Sales from shift 238468 on 2021-11-14 19:32:02 ','2021-11-14 19:32:02','',''),('5','102',3930929,'','20','2383',2244810.15,0.00,'Sales from shift 239060 on 2021-11-15 10:34:05 ','2021-11-15 10:34:05','',''),('5','102',3930930,'','6.1','2371',0.00,2244810.15,'Sales from shift 239060 on 2021-11-15 10:34:05 ','2021-11-15 10:34:05','',''),('5','102',3932799,'','20','2383',752711.85,0.00,'Sales from shift 239187 on 2021-11-15 12:52:54 ','2021-11-15 12:52:54','',''),('5','102',3932800,'','6.1','2371',0.00,752711.85,'Sales from shift 239187 on 2021-11-15 12:52:54 ','2021-11-15 12:52:54','',''),('5','102',3933109,'','20','2383',0.00,0.00,'Sales from shift 239190 on 2021-11-15 13:18:41 ','2021-11-15 13:18:41','',''),('5','102',3933110,'','6.1','2371',0.00,0.00,'Sales from shift 239190 on 2021-11-15 13:18:41 ','2021-11-15 13:18:41','',''),('5','102',3933132,'','20','2383',0.00,0.00,'Sales from shift 239196 on 2021-11-15 13:20:39 ','2021-11-15 13:20:39','',''),('5','102',3933133,'','6.1','2371',0.00,0.00,'Sales from shift 239196 on 2021-11-15 13:20:39 ','2021-11-15 13:20:39','',''),('5','102',3933172,'','20','2383',0.00,0.00,'Sales from shift 239197 on 2021-11-15 13:23:37 ','2021-11-15 13:23:37','',''),('5','102',3933173,'','6.1','2371',0.00,0.00,'Sales from shift 239197 on 2021-11-15 13:23:37 ','2021-11-15 13:23:37','',''),('5','102',3933209,'','20','2383',0.00,0.00,'Sales from shift 239198 on 2021-11-15 13:25:59 ','2021-11-15 13:25:59','',''),('5','102',3933210,'','6.1','2371',0.00,0.00,'Sales from shift 239198 on 2021-11-15 13:25:59 ','2021-11-15 13:25:59','',''),('5','102',3933267,'','20','2383',0.00,0.00,'Sales from shift 239200 on 2021-11-15 13:28:43 ','2021-11-15 13:28:43','',''),('5','102',3933268,'','6.1','2371',0.00,0.00,'Sales from shift 239200 on 2021-11-15 13:28:43 ','2021-11-15 13:28:43','',''),('5','102',3933893,'','2','2384',243300.00,0.00,'Payment Id 361152 for invoice:236665, receipt: 0279 by SALBAS OIL & GAS NIG. LIMITED','2021-11-15 14:10:27','',''),('5','102',3933894,'','supplier','107',0.00,243300.00,'Payment Id 361152 for invoice:236665, receipt: 0279 by SALBAS OIL & GAS NIG. LIMITED','2021-11-15 14:10:27','',''),('5','102',3934027,'','6.1','2371',7675.00,0.00,'Payment Id 361158 for invoice:236665, receipt: 0279 by SALBAS OIL & GAS NIG. LIMITED','2021-11-15 14:17:37','',''),('5','102',3934028,'','supplier','107',0.00,7675.00,'Payment Id 361158 for invoice:236665, receipt: 0279 by SALBAS OIL & GAS NIG. LIMITED','2021-11-15 14:17:37','',''),('5','102',3934041,'','2','2384',1262300.00,0.00,'Payment Id 361160 for invoice:238455, receipt: 0279 by SALBAS OIL & GAS NIG. LIMITED','2021-11-15 14:18:25','',''),('5','102',3934042,'','supplier','107',0.00,1262300.00,'Payment Id 361160 for invoice:238455, receipt: 0279 by SALBAS OIL & GAS NIG. LIMITED','2021-11-15 14:18:25','',''),('5','102',3934053,'','6.1','2371',180425.00,0.00,'Payment Id 361165 for invoice:238455, receipt: 0279 by SALBAS OIL & GAS NIG. LIMITED','2021-11-15 14:18:57','',''),('5','102',3934054,'','supplier','107',0.00,180425.00,'Payment Id 361165 for invoice:238455, receipt: 0279 by SALBAS OIL & GAS NIG. LIMITED','2021-11-15 14:18:57','',''),('5','102',3934156,'','2','2384',1901495.00,0.00,'Payment Id 361168 for invoice:238458, receipt: 0279 by SALBAS OIL & GAS NIG. LIMITED','2021-11-15 14:23:06','',''),('5','102',3934157,'','supplier','107',0.00,1901495.00,'Payment Id 361168 for invoice:238458, receipt: 0279 by SALBAS OIL & GAS NIG. LIMITED','2021-11-15 14:23:06','',''),('5','102',3934168,'','6.1','2371',21175.00,0.00,'Payment Id 361172 for invoice:238458, receipt: 0279 by SALBAS OIL & GAS NIG. LIMITED','2021-11-15 14:23:21','',''),('5','102',3934169,'','supplier','107',0.00,21175.00,'Payment Id 361172 for invoice:238458, receipt: 0279 by SALBAS OIL & GAS NIG. LIMITED','2021-11-15 14:23:21','',''),('5','102',3934182,'','2','2384',2233635.00,0.00,'Payment Id 361173 for invoice:239060, receipt: 0279 by SALBAS OIL & GAS NIG. LIMITED','2021-11-15 14:23:43','',''),('5','102',3934183,'','supplier','107',0.00,2233635.00,'Payment Id 361173 for invoice:239060, receipt: 0279 by SALBAS OIL & GAS NIG. LIMITED','2021-11-15 14:23:43','',''),('5','102',3934212,'','2','2384',737540.00,0.00,'Payment Id 361175 for invoice:239187, receipt: 0279 by SALBAS OIL & GAS NIG. LIMITED','2021-11-15 14:24:45','',''),('5','102',3934213,'','supplier','107',0.00,737540.00,'Payment Id 361175 for invoice:239187, receipt: 0279 by SALBAS OIL & GAS NIG. LIMITED','2021-11-15 14:24:45','',''),('5','102',3934246,'','6.1','2371',11675.00,0.00,'Payment Id 361176 for invoice:239187, receipt: 0279 by SALBAS OIL & GAS NIG. LIMITED','2021-11-15 14:25:32','',''),('5','102',3934247,'','supplier','107',0.00,11675.00,'Payment Id 361176 for invoice:239187, receipt: 0279 by SALBAS OIL & GAS NIG. LIMITED','2021-11-15 14:25:32','',''),('5','102',3935883,'','24','2369',0.00,6600000.00,'Purchase Id 80614 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-11-15 15:50:24','',''),('5','102',3935884,'','supplier','107',6600000.00,0.00,'Purchase Id 80614 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-11-15 15:50:24','',''),('5','102',3935909,'','6.1','2371',5175.00,0.00,'Payment Id 361174 for invoice:239060, receipt: 0279 by SALBAS OIL & GAS NIG. LIMITED','2021-11-15 15:51:55','',''),('5','102',3935910,'','supplier','107',0.00,5175.00,'Payment Id 361174 for invoice:239060, receipt: 0279 by SALBAS OIL & GAS NIG. LIMITED','2021-11-15 15:51:55','',''),('5','102',3936134,'','customer','2992',0.00,4499.55,'Credit Sales for 27.27 Litres of Petrol from shift 239223 on 2021-11-15 16:02:34 ','2021-11-15 16:02:34','',''),('5','102',3936135,'','20','2383',996355.80,0.00,'Sales from shift 239223 on 2021-11-15 16:02:34 ','2021-11-15 16:02:34','',''),('5','102',3936136,'','6.1','2371',0.00,991856.25,'Sales from shift 239223 on 2021-11-15 16:02:34 ','2021-11-15 16:02:34','',''),('5','102',3945933,'','customer','2992',0.00,6499.35,'Credit Sales for 39.39 Litres of Petrol from shift 239224 on 2021-11-16 14:31:31 ','2021-11-16 14:31:31','',''),('5','102',3945934,'','20','2383',967621.05,0.00,'Sales from shift 239224 on 2021-11-16 14:31:31 ','2021-11-16 14:31:31','',''),('5','102',3945935,'','6.1','2371',0.00,961121.70,'Sales from shift 239224 on 2021-11-16 14:31:31 ','2021-11-16 14:31:31','',''),('5','102',3945962,'','2','2384',984180.00,0.00,'Payment Id 361253 for invoice:239223, receipt: 0279 by SALBAS OIL & GAS NIG. LIMITED','2021-11-16 14:32:19','',''),('5','102',3945963,'','supplier','107',0.00,984180.00,'Payment Id 361253 for invoice:239223, receipt: 0279 by SALBAS OIL & GAS NIG. LIMITED','2021-11-16 14:32:19','',''),('5','102',3945966,'','6.1','2371',7675.00,0.00,'Payment Id 361259 for invoice:239223, receipt: 0279 by SALBAS OIL & GAS NIG. LIMITED','2021-11-16 14:32:43','',''),('5','102',3945967,'','supplier','107',0.00,7675.00,'Payment Id 361259 for invoice:239223, receipt: 0279 by SALBAS OIL & GAS NIG. LIMITED','2021-11-16 14:32:43','',''),('5','102',3961848,'','customer','2992',0.00,8499.15,'Credit Sales for 51.51 Litres of Petrol from shift 239462 on 2021-11-17 18:54:43 ','2021-11-17 18:54:43','',''),('5','102',3961849,'','20','2383',751743.30,0.00,'Sales from shift 239462 on 2021-11-17 18:54:43 ','2021-11-17 18:54:43','',''),('5','102',3961850,'','6.1','2371',0.00,743244.15,'Sales from shift 239462 on 2021-11-17 18:54:43 ','2021-11-17 18:54:43','',''),('5','102',3974669,'','customer','2992',0.00,7999.20,'Credit Sales for 48.48 Litres of Petrol from shift 239715 on 2021-11-18 19:30:52 ','2021-11-18 19:30:52','',''),('5','102',3974670,'','20','2383',759455.40,0.00,'Sales from shift 239715 on 2021-11-18 19:30:52 ','2021-11-18 19:30:52','',''),('5','102',3974671,'','6.1','2371',0.00,751456.20,'Sales from shift 239715 on 2021-11-18 19:30:52 ','2021-11-18 19:30:52','',''),('5','102',3985865,'','customer','2992',0.00,7999.20,'Credit Sales for 48.48 Litres of Petrol from shift 239947 on 2021-11-19 21:56:38 ','2021-11-19 21:56:38','',''),('5','102',3985866,'','20','2383',683768.25,0.00,'Sales from shift 239947 on 2021-11-19 21:56:38 ','2021-11-19 21:56:38','',''),('5','102',3985867,'','6.1','2371',0.00,675769.05,'Sales from shift 239947 on 2021-11-19 21:56:38 ','2021-11-19 21:56:38','',''),('5','102',4003797,'','customer','2992',0.00,8499.15,'Credit Sales for 51.51 Litres of Petrol from shift 240516 on 2021-11-21 10:05:54 ','2021-11-21 10:05:54','',''),('5','102',4003798,'','20','2383',652070.10,0.00,'Sales from shift 240516 on 2021-11-21 10:05:54 ','2021-11-21 10:05:54','',''),('5','102',4003799,'','6.1','2371',0.00,643570.95,'Sales from shift 240516 on 2021-11-21 10:05:54 ','2021-11-21 10:05:54','',''),('5','102',4003919,'','customer','2992',0.00,7999.20,'Credit Sales for 48.48 Litres of Petrol from shift 240518 on 2021-11-21 10:13:12 ','2021-11-21 10:13:12','',''),('5','102',4003920,'','20','2383',605097.90,0.00,'Sales from shift 240518 on 2021-11-21 10:13:12 ','2021-11-21 10:13:12','',''),('5','102',4003921,'','6.1','2371',0.00,597098.70,'Sales from shift 240518 on 2021-11-21 10:13:12 ','2021-11-21 10:13:12','',''),('5','102',4015691,'','customer','2992',0.00,8499.15,'Credit Sales for 51.51 Litres of Petrol from shift 240521 on 2021-11-22 10:32:35 ','2021-11-22 10:32:35','',''),('5','102',4015692,'','20','2383',600870.60,0.00,'Sales from shift 240521 on 2021-11-22 10:32:35 ','2021-11-22 10:32:35','',''),('5','102',4015693,'','6.1','2371',0.00,592371.45,'Sales from shift 240521 on 2021-11-22 10:32:35 ','2021-11-22 10:32:35','',''),('5','102',4015707,'','2','2384',954440.00,0.00,'Payment Id 364071 for invoice:239224, receipt: 0278 by SALBAS OIL & GAS NIG. LIMITED','2021-11-22 10:33:29','',''),('5','102',4015708,'','supplier','107',0.00,954440.00,'Payment Id 364071 for invoice:239224, receipt: 0278 by SALBAS OIL & GAS NIG. LIMITED','2021-11-22 10:33:29','',''),('5','102',4015711,'','6.1','2371',6675.00,0.00,'Payment Id 364073 for invoice:239224, receipt: 0278 by SALBAS OIL & GAS NIG. LIMITED','2021-11-22 10:33:47','',''),('5','102',4015712,'','supplier','107',0.00,6675.00,'Payment Id 364073 for invoice:239224, receipt: 0278 by SALBAS OIL & GAS NIG. LIMITED','2021-11-22 10:33:47','',''),('5','102',4015713,'','2','2384',738070.00,0.00,'Payment Id 364074 for invoice:239462, receipt: 0279 by SALBAS OIL & GAS NIG. LIMITED','2021-11-22 10:34:02','',''),('5','102',4015714,'','supplier','107',0.00,738070.00,'Payment Id 364074 for invoice:239462, receipt: 0279 by SALBAS OIL & GAS NIG. LIMITED','2021-11-22 10:34:02','',''),('5','102',4015719,'','6.1','2371',5175.00,0.00,'Payment Id 364075 for invoice:239462, receipt: 0279 by SALBAS OIL & GAS NIG. LIMITED','2021-11-22 10:34:15','',''),('5','102',4015720,'','supplier','107',0.00,5175.00,'Payment Id 364075 for invoice:239462, receipt: 0279 by SALBAS OIL & GAS NIG. LIMITED','2021-11-22 10:34:15','',''),('5','102',4015725,'','2','2384',746280.00,0.00,'Payment Id 364077 for invoice:239715, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2021-11-22 10:34:35','',''),('5','102',4015726,'','supplier','107',0.00,746280.00,'Payment Id 364077 for invoice:239715, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2021-11-22 10:34:35','',''),('5','102',4015733,'','6.1','2371',5175.00,0.00,'Payment Id 364080 for invoice:239715, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2021-11-22 10:34:52','',''),('5','102',4015734,'','supplier','107',0.00,5175.00,'Payment Id 364080 for invoice:239715, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2021-11-22 10:34:52','',''),('5','102',4015740,'','2','2384',205175.00,0.00,'Payment Id 364083 for invoice:239947, receipt: 0278 by SALBAS OIL & GAS NIG. LIMITED','2021-11-22 10:35:19','',''),('5','102',4015741,'','supplier','107',0.00,205175.00,'Payment Id 364083 for invoice:239947, receipt: 0278 by SALBAS OIL & GAS NIG. LIMITED','2021-11-22 10:35:19','',''),('5','102',4018449,'','2','2384',638395.00,0.00,'Payment Id 364545 for invoice:240516, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2021-11-22 13:30:37','',''),('5','102',4018450,'','supplier','107',0.00,638395.00,'Payment Id 364545 for invoice:240516, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2021-11-22 13:30:37','',''),('5','102',4018459,'','6.1','2371',5175.00,0.00,'Payment Id 364548 for invoice:240516, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2021-11-22 13:31:00','',''),('5','102',4018460,'','supplier','107',0.00,5175.00,'Payment Id 364548 for invoice:240516, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2021-11-22 13:31:00','',''),('5','102',4018485,'','2','2384',591920.00,0.00,'Payment Id 364550 for invoice:240518, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2021-11-22 13:31:23','',''),('5','102',4018486,'','supplier','107',0.00,591920.00,'Payment Id 364550 for invoice:240518, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2021-11-22 13:31:23','',''),('5','102',4018498,'','6.1','2371',5175.00,0.00,'Payment Id 364551 for invoice:240518, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2021-11-22 13:31:39','',''),('5','102',4018499,'','supplier','107',0.00,5175.00,'Payment Id 364551 for invoice:240518, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2021-11-22 13:31:39','',''),('5','102',4018502,'','2','2384',587195.00,0.00,'Payment Id 364552 for invoice:240521, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2021-11-22 13:32:00','',''),('5','102',4018503,'','supplier','107',0.00,587195.00,'Payment Id 364552 for invoice:240521, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2021-11-22 13:32:00','',''),('5','102',4018506,'','6.1','2371',5175.00,0.00,'Payment Id 364554 for invoice:240521, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2021-11-22 13:32:13','',''),('5','102',4018507,'','supplier','107',0.00,5175.00,'Payment Id 364554 for invoice:240521, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2021-11-22 13:32:13','',''),('5','102',4020017,'','2','2384',470590.00,0.00,'Payment Id 364671 for invoice:239947, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2021-11-22 14:44:45','',''),('5','102',4020018,'','supplier','107',0.00,470590.00,'Payment Id 364671 for invoice:239947, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2021-11-22 14:44:45','',''),('5','102',4056486,'','customer','2992',0.00,7999.20,'Credit Sales for 48.48 Litres of Petrol from shift 241609 on 2021-11-25 12:23:17 ','2021-11-25 12:23:17','',''),('5','102',4056487,'','20','2383',538942.80,0.00,'Sales from shift 241609 on 2021-11-25 12:23:17 ','2021-11-25 12:23:17','',''),('5','102',4056488,'','6.1','2371',0.00,530943.60,'Sales from shift 241609 on 2021-11-25 12:23:17 ','2021-11-25 12:23:17','',''),('5','102',4108530,'','20','2383',45637.35,0.00,'Sales from shift 241612 on 2021-11-29 14:39:44 ','2021-11-29 14:39:44','',''),('5','102',4108531,'','6.1','2371',0.00,45637.35,'Sales from shift 241612 on 2021-11-29 14:39:44 ','2021-11-29 14:39:44','',''),('5','102',4108543,'','2','2384',520760.00,0.00,'Payment Id 366540 for invoice:241609, receipt: 035 by SALBAS OIL & GAS NIG. LIMITED','2021-11-29 14:40:15','',''),('5','102',4108544,'','supplier','107',0.00,520760.00,'Payment Id 366540 for invoice:241609, receipt: 035 by SALBAS OIL & GAS NIG. LIMITED','2021-11-29 14:40:15','',''),('5','102',4108553,'','6.1','2371',9675.00,0.00,'Payment Id 366541 for invoice:241609, receipt: 035 by SALBAS OIL & GAS NIG. LIMITED','2021-11-29 14:40:31','',''),('5','102',4108554,'','supplier','107',0.00,9675.00,'Payment Id 366541 for invoice:241609, receipt: 035 by SALBAS OIL & GAS NIG. LIMITED','2021-11-29 14:40:31','',''),('5','102',4108563,'','2','2384',40295.00,0.00,'Payment Id 366553 for invoice:241612, receipt: 035 by SALBAS OIL & GAS NIG. LIMITED','2021-11-29 14:40:55','',''),('5','102',4108564,'','supplier','107',0.00,40295.00,'Payment Id 366553 for invoice:241612, receipt: 035 by SALBAS OIL & GAS NIG. LIMITED','2021-11-29 14:40:55','',''),('5','102',4108572,'','6.1','2371',5175.00,0.00,'Payment Id 366555 for invoice:241612, receipt: 035 by SALBAS OIL & GAS NIG. LIMITED','2021-11-29 14:41:14','',''),('5','102',4108573,'','supplier','107',0.00,5175.00,'Payment Id 366555 for invoice:241612, receipt: 035 by SALBAS OIL & GAS NIG. LIMITED','2021-11-29 14:41:14','',''),('5','102',4108968,'','20','2383',0.00,0.00,'Sales from shift 242592 on 2021-11-29 15:06:23 ','2021-11-29 15:06:23','',''),('5','102',4108969,'','6.1','2371',0.00,0.00,'Sales from shift 242592 on 2021-11-29 15:06:23 ','2021-11-29 15:06:23','',''),('5','102',4116040,'','20','2383',0.00,0.00,'Sales from shift 242759 on 2021-11-30 09:24:50 ','2021-11-30 09:24:50','',''),('5','102',4116041,'','6.1','2371',0.00,0.00,'Sales from shift 242759 on 2021-11-30 09:24:50 ','2021-11-30 09:24:50','',''),('5','102',4116105,'','20','2383',0.00,0.00,'Sales from shift 242762 on 2021-11-30 09:30:38 ','2021-11-30 09:30:38','',''),('5','102',4116106,'','6.1','2371',0.00,0.00,'Sales from shift 242762 on 2021-11-30 09:30:38 ','2021-11-30 09:30:38','',''),('5','102',4116182,'','20','2383',0.00,0.00,'Sales from shift 242765 on 2021-11-30 09:36:04 ','2021-11-30 09:36:04','',''),('5','102',4116183,'','6.1','2371',0.00,0.00,'Sales from shift 242765 on 2021-11-30 09:36:04 ','2021-11-30 09:36:04','',''),('5','102',4116365,'','20','2383',0.00,0.00,'Sales from shift 242766 on 2021-11-30 09:45:20 ','2021-11-30 09:45:20','',''),('5','102',4116366,'','6.1','2371',0.00,0.00,'Sales from shift 242766 on 2021-11-30 09:45:20 ','2021-11-30 09:45:20','',''),('5','102',4118078,'','20','2383',0.00,0.00,'Sales from shift 242770 on 2021-11-30 10:54:13 ','2021-11-30 10:54:13','',''),('5','102',4118079,'','6.1','2371',0.00,0.00,'Sales from shift 242770 on 2021-11-30 10:54:13 ','2021-11-30 10:54:13','',''),('5','102',4151129,'','20','2383',0.00,0.00,'Sales from shift 243080 on 2021-12-02 16:21:04 ','2021-12-02 16:21:04','',''),('5','102',4151130,'','6.1','2371',0.00,0.00,'Sales from shift 243080 on 2021-12-02 16:21:04 ','2021-12-02 16:21:04','',''),('5','102',4159449,'','20','2383',0.00,0.00,'Sales from shift 243467 on 2021-12-03 11:19:41 ','2021-12-03 11:19:41','',''),('5','102',4159450,'','6.1','2371',0.00,0.00,'Sales from shift 243467 on 2021-12-03 11:19:41 ','2021-12-03 11:19:41','',''),('5','102',4159482,'','20','2383',0.00,0.00,'Sales from shift 243469 on 2021-12-03 11:22:06 ','2021-12-03 11:22:06','',''),('5','102',4159483,'','6.1','2371',0.00,0.00,'Sales from shift 243469 on 2021-12-03 11:22:06 ','2021-12-03 11:22:06','',''),('5','102',4179222,'','20','2383',0.00,0.00,'Sales from shift 243470 on 2021-12-04 19:43:27 ','2021-12-04 19:43:27','',''),('5','102',4179223,'','6.1','2371',0.00,0.00,'Sales from shift 243470 on 2021-12-04 19:43:27 ','2021-12-04 19:43:27','',''),('5','102',4191603,'','20','2383',0.00,0.00,'Sales from shift 243931 on 2021-12-05 20:28:52 ','2021-12-05 20:28:52','',''),('5','102',4191604,'','6.1','2371',0.00,0.00,'Sales from shift 243931 on 2021-12-05 20:28:52 ','2021-12-05 20:28:52','',''),('5','102',4194046,'','20','2383',0.00,0.00,'Sales from shift 244008 on 2021-12-06 08:49:21 ','2021-12-06 08:49:21','',''),('5','102',4194047,'','6.1','2371',0.00,0.00,'Sales from shift 244008 on 2021-12-06 08:49:21 ','2021-12-06 08:49:21','',''),('5','102',4218695,'','20','2383',0.00,0.00,'Sales from shift 244220 on 2021-12-07 17:07:03 ','2021-12-07 17:07:03','',''),('5','102',4218696,'','6.1','2371',0.00,0.00,'Sales from shift 244220 on 2021-12-07 17:07:03 ','2021-12-07 17:07:03','',''),('5','102',4231837,'','20','2383',0.00,0.00,'Sales from shift 244615 on 2021-12-08 20:54:41 ','2021-12-08 20:54:41','',''),('5','102',4231838,'','6.1','2371',0.00,0.00,'Sales from shift 244615 on 2021-12-08 20:54:41 ','2021-12-08 20:54:41','',''),('5','102',4235964,'','20','2383',0.00,0.00,'Sales from shift 244801 on 2021-12-09 09:28:30 ','2021-12-09 09:28:30','',''),('5','102',4235965,'','6.1','2371',0.00,0.00,'Sales from shift 244801 on 2021-12-09 09:28:30 ','2021-12-09 09:28:30','',''),('5','102',4271912,'','20','2383',0.00,0.00,'Sales from shift 245080 on 2021-12-11 17:51:44 ','2021-12-11 17:51:44','',''),('5','102',4271913,'','6.1','2371',0.00,0.00,'Sales from shift 245080 on 2021-12-11 17:51:44 ','2021-12-11 17:51:44','',''),('5','102',4284793,'','20','2383',0.00,0.00,'Sales from shift 245594 on 2021-12-12 21:22:46 ','2021-12-12 21:22:46','',''),('5','102',4284794,'','6.1','2371',0.00,0.00,'Sales from shift 245594 on 2021-12-12 21:22:46 ','2021-12-12 21:22:46','',''),('5','102',4288297,'','20','2383',0.00,0.00,'Sales from shift 245657 on 2021-12-13 09:16:01 ','2021-12-13 09:16:01','',''),('5','102',4288298,'','6.1','2371',0.00,0.00,'Sales from shift 245657 on 2021-12-13 09:16:01 ','2021-12-13 09:16:01','',''),('5','102',4290230,'','20','2383',0.00,0.00,'Sales from shift 245750 on 2021-12-13 10:50:28 ','2021-12-13 10:50:28','',''),('5','102',4290231,'','6.1','2371',0.00,0.00,'Sales from shift 245750 on 2021-12-13 10:50:28 ','2021-12-13 10:50:28','',''),('5','102',4301635,'','20','2383',0.00,0.00,'Sales from shift 245828 on 2021-12-14 09:28:46 ','2021-12-14 09:28:46','',''),('5','102',4301636,'','6.1','2371',0.00,0.00,'Sales from shift 245828 on 2021-12-14 09:28:46 ','2021-12-14 09:28:46','',''),('5','102',4312884,'','20','2383',0.00,0.00,'Sales from shift 246223 on 2021-12-15 09:09:02 ','2021-12-15 09:09:02','',''),('5','102',4312885,'','6.1','2371',0.00,0.00,'Sales from shift 246223 on 2021-12-15 09:09:02 ','2021-12-15 09:09:02','',''),('5','102',4327882,'','20','2383',0.00,0.00,'Sales from shift 246306 on 2021-12-16 09:05:45 ','2021-12-16 09:05:45','',''),('5','102',4327883,'','6.1','2371',0.00,0.00,'Sales from shift 246306 on 2021-12-16 09:05:45 ','2021-12-16 09:05:45','',''),('5','102',4367370,'','20','2383',0.00,0.00,'Sales from shift 246868 on 2021-12-18 17:41:53 ','2021-12-18 17:41:53','',''),('5','102',4367371,'','6.1','2371',0.00,0.00,'Sales from shift 246868 on 2021-12-18 17:41:53 ','2021-12-18 17:41:53','',''),('5','102',4382046,'','20','2383',0.00,0.00,'Sales from shift 247272 on 2021-12-19 18:43:26 ','2021-12-19 18:43:26','',''),('5','102',4382047,'','6.1','2371',0.00,0.00,'Sales from shift 247272 on 2021-12-19 18:43:26 ','2021-12-19 18:43:26','',''),('5','102',4382151,'','20','2383',0.00,0.00,'Sales from shift 247358 on 2021-12-19 19:41:28 ','2021-12-19 19:41:28','',''),('5','102',4382152,'','6.1','2371',0.00,0.00,'Sales from shift 247358 on 2021-12-19 19:41:28 ','2021-12-19 19:41:28','',''),('5','102',4409866,'','20','2383',0.00,0.00,'Sales from shift 247479 on 2021-12-21 21:09:16 ','2021-12-21 21:09:16','',''),('5','102',4409867,'','6.1','2371',0.00,0.00,'Sales from shift 247479 on 2021-12-21 21:09:16 ','2021-12-21 21:09:16','',''),('5','102',4416441,'','20','2383',0.00,0.00,'Sales from shift 248007 on 2021-12-22 10:41:59 ','2021-12-22 10:41:59','',''),('5','102',4416442,'','6.1','2371',0.00,0.00,'Sales from shift 248007 on 2021-12-22 10:41:59 ','2021-12-22 10:41:59','',''),('5','102',4416499,'','20','2383',0.00,0.00,'Sales from shift 248008 on 2021-12-22 10:43:49 ','2021-12-22 10:43:49','',''),('5','102',4416500,'','6.1','2371',0.00,0.00,'Sales from shift 248008 on 2021-12-22 10:43:49 ','2021-12-22 10:43:49','',''),('5','102',4467777,'','20','2383',0.00,0.00,'Sales from shift 248010 on 2021-12-25 13:03:33 ','2021-12-25 13:03:33','',''),('5','102',4467778,'','6.1','2371',0.00,0.00,'Sales from shift 248010 on 2021-12-25 13:03:33 ','2021-12-25 13:03:33','',''),('5','102',4480105,'','20','2383',0.00,0.00,'Sales from shift 248986 on 2021-12-26 17:55:04 ','2021-12-26 17:55:04','',''),('5','102',4480106,'','6.1','2371',0.00,0.00,'Sales from shift 248986 on 2021-12-26 17:55:04 ','2021-12-26 17:55:04','',''),('5','102',4506427,'','20','2383',0.00,0.00,'Sales from shift 249528 on 2021-12-29 10:11:22 ','2021-12-29 10:11:22','',''),('5','102',4506428,'','6.1','2371',0.00,0.00,'Sales from shift 249528 on 2021-12-29 10:11:22 ','2021-12-29 10:11:22','',''),('5','102',4529292,'','20','2383',0.00,0.00,'Sales from shift 249767 on 2021-12-30 18:30:13 ','2021-12-30 18:30:13','',''),('5','102',4529293,'','6.1','2371',0.00,0.00,'Sales from shift 249767 on 2021-12-30 18:30:13 ','2021-12-30 18:30:13','',''),('5','102',4542785,'','20','2383',0.00,0.00,'Sales from shift 250130 on 2021-12-31 20:49:00 ','2021-12-31 20:49:00','',''),('5','102',4542786,'','6.1','2371',0.00,0.00,'Sales from shift 250130 on 2021-12-31 20:49:00 ','2021-12-31 20:49:00','',''),('5','102',4560845,'','20','2383',0.00,0.00,'Sales from shift 250488 on 2022-01-02 14:17:30 ','2022-01-02 14:17:30','',''),('5','102',4560846,'','6.1','2371',0.00,0.00,'Sales from shift 250488 on 2022-01-02 14:17:30 ','2022-01-02 14:17:30','',''),('5','102',4560878,'','20','2383',0.00,0.00,'Sales from shift 250695 on 2022-01-02 14:18:58 ','2022-01-02 14:18:58','',''),('5','102',4560879,'','6.1','2371',0.00,0.00,'Sales from shift 250695 on 2022-01-02 14:18:58 ','2022-01-02 14:18:58','',''),('5','102',4560983,'','20','2383',0.00,0.00,'Sales from shift 250699 on 2022-01-02 14:24:48 ','2022-01-02 14:24:48','',''),('5','102',4560984,'','6.1','2371',0.00,0.00,'Sales from shift 250699 on 2022-01-02 14:24:48 ','2022-01-02 14:24:48','',''),('5','102',4561117,'','20','2383',0.00,0.00,'Sales from shift 250704 on 2022-01-02 14:33:15 ','2022-01-02 14:33:15','',''),('5','102',4561118,'','6.1','2371',0.00,0.00,'Sales from shift 250704 on 2022-01-02 14:33:15 ','2022-01-02 14:33:15','',''),('5','102',4561187,'','20','2383',0.00,0.00,'Sales from shift 250707 on 2022-01-02 14:37:27 ','2022-01-02 14:37:27','',''),('5','102',4561188,'','6.1','2371',0.00,0.00,'Sales from shift 250707 on 2022-01-02 14:37:27 ','2022-01-02 14:37:27','',''),('5','102',4561212,'','20','2383',0.00,0.00,'Sales from shift 250710 on 2022-01-02 14:39:06 ','2022-01-02 14:39:06','',''),('5','102',4561213,'','6.1','2371',0.00,0.00,'Sales from shift 250710 on 2022-01-02 14:39:06 ','2022-01-02 14:39:06','',''),('5','102',4577727,'','24','2369',0.00,6476250.00,'Purchase Id 88669 for 39,250.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-01-04 09:07:38','',''),('5','102',4577728,'','supplier','107',6476250.00,0.00,'Purchase Id 88669 for 39,250.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-01-04 09:07:38','',''),('5','102',4584202,'','20','2383',453703.80,0.00,'Sales from shift 250712 on 2022-01-04 13:57:36 ','2022-01-04 13:57:36','',''),('5','102',4584203,'','6.1','2371',0.00,453703.80,'Sales from shift 250712 on 2022-01-04 13:57:36 ','2022-01-04 13:57:36','',''),('5','102',4593487,'','customer','2992',0.00,1999.80,'Credit Sales for 12.12 Litres of Petrol from shift 251352 on 2022-01-05 10:58:46 ','2022-01-05 10:58:46','',''),('5','102',4593488,'','20','2383',1369830.00,0.00,'Sales from shift 251352 on 2022-01-05 10:58:46 ','2022-01-05 10:58:46','',''),('5','102',4593489,'','6.1','2371',0.00,1367830.20,'Sales from shift 251352 on 2022-01-05 10:58:46 ','2022-01-05 10:58:46','',''),('5','102',4593732,'','20','2383',2052925.05,0.00,'Sales from shift 251356 on 2022-01-05 11:06:23 ','2022-01-05 11:06:23','',''),('5','102',4593733,'','6.1','2371',0.00,2052925.05,'Sales from shift 251356 on 2022-01-05 11:06:23 ','2022-01-05 11:06:23','',''),('5','102',4616280,'','customer','2992',0.00,3999.60,'Credit Sales for 24.24 Litres of Petrol from shift 251364 on 2022-01-06 18:17:16 ','2022-01-06 18:17:16','',''),('5','102',4616281,'','20','2383',1419876.15,0.00,'Sales from shift 251364 on 2022-01-06 18:17:16 ','2022-01-06 18:17:16','',''),('5','102',4616282,'','6.1','2371',0.00,1415876.55,'Sales from shift 251364 on 2022-01-06 18:17:16 ','2022-01-06 18:17:16','',''),('5','102',4623136,'','customer','2992',0.00,8999.10,'Credit Sales for 54.54 Litres of Petrol from shift 251850 on 2022-01-07 12:35:37 ','2022-01-07 12:35:37','',''),('5','102',4623137,'','20','2383',1017559.95,0.00,'Sales from shift 251850 on 2022-01-07 12:35:37 ','2022-01-07 12:35:37','',''),('5','102',4623138,'','6.1','2371',0.00,1008560.85,'Sales from shift 251850 on 2022-01-07 12:35:37 ','2022-01-07 12:35:37','',''),('5','102',4700351,'','customer','2992',0.00,4999.50,'Credit Sales for 30.30 Litres of Petrol from shift 252491 on 2022-01-12 19:52:23 ','2022-01-12 19:52:23','',''),('5','102',4700352,'','20','2383',159225.00,0.00,'Sales from shift 252491 on 2022-01-12 19:52:23 ','2022-01-12 19:52:23','',''),('5','102',4700353,'','6.1','2371',0.00,154225.50,'Sales from shift 252491 on 2022-01-12 19:52:23 ','2022-01-12 19:52:23','',''),('5','102',4700366,'','20','2383',0.00,0.00,'Sales from shift 253150 on 2022-01-12 19:55:35 ','2022-01-12 19:55:35','',''),('5','102',4700367,'','6.1','2371',0.00,0.00,'Sales from shift 253150 on 2022-01-12 19:55:35 ','2022-01-12 19:55:35','',''),('5','102',4700368,'','6.1','2371',7675.00,0.00,'Payment Id 389152 for invoice:250712, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2022-01-12 19:57:48','',''),('5','102',4700369,'','supplier','107',0.00,7675.00,'Payment Id 389152 for invoice:250712, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2022-01-12 19:57:48','',''),('5','102',4700372,'','2','2384',1362650.00,0.00,'Payment Id 389155 for invoice:251352, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2022-01-12 19:58:44','',''),('5','102',4700373,'','supplier','107',0.00,1362650.00,'Payment Id 389155 for invoice:251352, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2022-01-12 19:58:44','',''),('5','102',4700374,'','6.1','2371',5175.00,0.00,'Payment Id 389157 for invoice:251352, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2022-01-12 19:59:28','',''),('5','102',4700375,'','supplier','107',0.00,5175.00,'Payment Id 389157 for invoice:251352, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2022-01-12 19:59:28','',''),('5','102',4700376,'','2','2384',2035750.00,0.00,'Payment Id 389160 for invoice:251356, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2022-01-12 19:59:44','',''),('5','102',4700377,'','supplier','107',0.00,2035750.00,'Payment Id 389160 for invoice:251356, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2022-01-12 19:59:44','',''),('5','102',4700380,'','6.1','2371',17175.00,0.00,'Payment Id 389168 for invoice:251356, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2022-01-12 20:01:22','',''),('5','102',4700381,'','supplier','107',0.00,17175.00,'Payment Id 389168 for invoice:251356, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2022-01-12 20:01:22','',''),('5','102',4700382,'','2','2384',1230700.00,0.00,'Payment Id 390609 for invoice:251364, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2022-01-12 20:01:49','',''),('5','102',4700383,'','supplier','107',0.00,1230700.00,'Payment Id 390609 for invoice:251364, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2022-01-12 20:01:49','',''),('5','102',4700384,'','6.1','2371',185175.00,0.00,'Payment Id 390612 for invoice:251364, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2022-01-12 20:02:15','',''),('5','102',4700385,'','supplier','107',0.00,185175.00,'Payment Id 390612 for invoice:251364, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2022-01-12 20:02:15','',''),('5','102',4700386,'','2','2384',853380.00,0.00,'Payment Id 390614 for invoice:251850, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2022-01-12 20:03:00','',''),('5','102',4700387,'','supplier','107',0.00,853380.00,'Payment Id 390614 for invoice:251850, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2022-01-12 20:03:00','',''),('5','102',4700388,'','20','2383',0.00,0.00,'Sales from shift 253151 on 2022-01-12 20:03:23 ','2022-01-12 20:03:23','',''),('5','102',4700389,'','6.1','2371',0.00,0.00,'Sales from shift 253151 on 2022-01-12 20:03:23 ','2022-01-12 20:03:23','',''),('5','102',4700399,'','6.1','2371',155175.00,0.00,'Payment Id 390616 for invoice:251850, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2022-01-12 20:04:07','',''),('5','102',4700400,'','supplier','107',0.00,155175.00,'Payment Id 390616 for invoice:251850, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2022-01-12 20:04:07','',''),('5','102',4700401,'','2','2384',146450.00,0.00,'Payment Id 390620 for invoice:252491, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2022-01-12 20:04:32','',''),('5','102',4700402,'','supplier','107',0.00,146450.00,'Payment Id 390620 for invoice:252491, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2022-01-12 20:04:32','',''),('5','102',4700405,'','6.1','2371',7875.00,0.00,'Payment Id 390621 for invoice:252491, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2022-01-12 20:05:01','',''),('5','102',4700406,'','supplier','107',0.00,7875.00,'Payment Id 390621 for invoice:252491, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2022-01-12 20:05:01','',''),('5','102',4700412,'','2','2384',446195.00,0.00,'Payment Id 389151 for invoice:250712, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2022-01-12 20:05:18','',''),('5','102',4700413,'','supplier','107',0.00,446195.00,'Payment Id 389151 for invoice:250712, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2022-01-12 20:05:18','',''),('5','102',4700416,'','20','2383',0.00,0.00,'Sales from shift 253153 on 2022-01-12 20:05:51 ','2022-01-12 20:05:51','',''),('5','102',4700417,'','6.1','2371',0.00,0.00,'Sales from shift 253153 on 2022-01-12 20:05:51 ','2022-01-12 20:05:51','',''),('5','102',4700443,'','20','2383',0.00,0.00,'Sales from shift 253154 on 2022-01-12 20:10:48 ','2022-01-12 20:10:48','',''),('5','102',4700444,'','6.1','2371',0.00,0.00,'Sales from shift 253154 on 2022-01-12 20:10:48 ','2022-01-12 20:10:48','',''),('5','102',4700452,'','20','2383',0.00,0.00,'Sales from shift 253157 on 2022-01-12 20:14:57 ','2022-01-12 20:14:57','',''),('5','102',4700453,'','6.1','2371',0.00,0.00,'Sales from shift 253157 on 2022-01-12 20:14:57 ','2022-01-12 20:14:57','',''),('5','102',4714177,'','20','2383',0.00,0.00,'Sales from shift 253309 on 2022-01-13 22:52:41 ','2022-01-13 22:52:41','',''),('5','102',4714178,'','6.1','2371',0.00,0.00,'Sales from shift 253309 on 2022-01-13 22:52:41 ','2022-01-13 22:52:41','',''),('5','102',4730641,'','20','2383',0.00,0.00,'Sales from shift 253573 on 2022-01-15 09:40:40 ','2022-01-15 09:40:40','',''),('5','102',4730642,'','6.1','2371',0.00,0.00,'Sales from shift 253573 on 2022-01-15 09:40:40 ','2022-01-15 09:40:40','',''),('5','102',4747841,'','20','2383',0.00,0.00,'Sales from shift 253797 on 2022-01-16 10:50:17 ','2022-01-16 10:50:17','',''),('5','102',4747842,'','6.1','2371',0.00,0.00,'Sales from shift 253797 on 2022-01-16 10:50:17 ','2022-01-16 10:50:17','',''),('5','102',4760120,'','20','2383',0.00,0.00,'Sales from shift 254074 on 2022-01-17 09:59:38 ','2022-01-17 09:59:38','',''),('5','102',4760121,'','6.1','2371',0.00,0.00,'Sales from shift 254074 on 2022-01-17 09:59:38 ','2022-01-17 09:59:38','',''),('5','102',4780933,'','20','2383',0.00,0.00,'Sales from shift 254369 on 2022-01-18 15:54:05 ','2022-01-18 15:54:05','',''),('5','102',4780934,'','6.1','2371',0.00,0.00,'Sales from shift 254369 on 2022-01-18 15:54:05 ','2022-01-18 15:54:05','',''),('5','102',4788537,'','20','2383',0.00,0.00,'Sales from shift 254643 on 2022-01-19 10:04:28 ','2022-01-19 10:04:28','',''),('5','102',4788538,'','6.1','2371',0.00,0.00,'Sales from shift 254643 on 2022-01-19 10:04:28 ','2022-01-19 10:04:28','',''),('5','102',4800863,'','20','2383',0.00,0.00,'Sales from shift 254859 on 2022-01-20 07:19:21 ','2022-01-20 07:19:21','',''),('5','102',4800864,'','6.1','2371',0.00,0.00,'Sales from shift 254859 on 2022-01-20 07:19:21 ','2022-01-20 07:19:21','',''),('5','102',4820523,'','20','2383',0.00,0.00,'Sales from shift 255147 on 2022-01-21 11:19:01 ','2022-01-21 11:19:01','',''),('5','102',4820524,'','6.1','2371',0.00,0.00,'Sales from shift 255147 on 2022-01-21 11:19:01 ','2022-01-21 11:19:01','',''),('5','102',4846781,'','20','2383',0.00,0.00,'Sales from shift 255313 on 2022-01-22 22:12:15 ','2022-01-22 22:12:15','',''),('5','102',4846782,'','6.1','2371',0.00,0.00,'Sales from shift 255313 on 2022-01-22 22:12:15 ','2022-01-22 22:12:15','',''),('5','102',4854253,'','20','2383',0.00,0.00,'Sales from shift 255762 on 2022-01-23 13:44:21 ','2022-01-23 13:44:21','',''),('5','102',4854254,'','6.1','2371',0.00,0.00,'Sales from shift 255762 on 2022-01-23 13:44:21 ','2022-01-23 13:44:21','',''),('5','102',4873621,'','20','2383',0.00,0.00,'Sales from shift 255893 on 2022-01-24 21:11:15 ','2022-01-24 21:11:15','',''),('5','102',4873622,'','6.1','2371',0.00,0.00,'Sales from shift 255893 on 2022-01-24 21:11:15 ','2022-01-24 21:11:15','',''),('5','102',4876783,'','20','2383',0.00,0.00,'Sales from shift 256179 on 2022-01-25 09:53:06 ','2022-01-25 09:53:06','',''),('5','102',4876784,'','6.1','2371',0.00,0.00,'Sales from shift 256179 on 2022-01-25 09:53:06 ','2022-01-25 09:53:06','',''),('5','102',4893811,'','20','2383',0.00,0.00,'Sales from shift 256311 on 2022-01-26 10:17:44 ','2022-01-26 10:17:44','',''),('5','102',4893812,'','6.1','2371',0.00,0.00,'Sales from shift 256311 on 2022-01-26 10:17:44 ','2022-01-26 10:17:44','',''),('5','102',4918955,'','20','2383',0.00,0.00,'Sales from shift 256563 on 2022-01-27 19:01:55 ','2022-01-27 19:01:55','',''),('5','102',4918956,'','6.1','2371',0.00,0.00,'Sales from shift 256563 on 2022-01-27 19:01:55 ','2022-01-27 19:01:55','',''),('5','102',4935234,'','20','2383',0.00,0.00,'Sales from shift 256910 on 2022-01-28 22:09:13 ','2022-01-28 22:09:13','',''),('5','102',4935235,'','6.1','2371',0.00,0.00,'Sales from shift 256910 on 2022-01-28 22:09:13 ','2022-01-28 22:09:13','',''),('5','102',4960031,'','20','2383',0.00,0.00,'Sales from shift 257277 on 2022-01-30 13:03:37 ','2022-01-30 13:03:37','',''),('5','102',4960032,'','6.1','2371',0.00,0.00,'Sales from shift 257277 on 2022-01-30 13:03:37 ','2022-01-30 13:03:37','',''),('5','102',4960033,'','20','2383',0.00,0.00,'Sales from shift 257656 on 2022-01-31 22:14:21 ','2022-01-31 22:14:21','',''),('5','102',4960034,'','6.1','2371',0.00,0.00,'Sales from shift 257656 on 2022-01-31 22:14:21 ','2022-01-31 22:14:21','',''),('5','102',4960035,'','20','2383',0.00,0.00,'Sales from shift 257657 on 2022-02-01 21:59:11 ','2022-02-01 21:59:11','',''),('5','102',4960036,'','6.1','2371',0.00,0.00,'Sales from shift 257657 on 2022-02-01 21:59:11 ','2022-02-01 21:59:11','',''),('5','102',4960037,'','20','2383',0.00,0.00,'Sales from shift 257658 on 2022-02-01 22:04:10 ','2022-02-01 22:04:10','',''),('5','102',4960038,'','6.1','2371',0.00,0.00,'Sales from shift 257658 on 2022-02-01 22:04:10 ','2022-02-01 22:04:10','',''),('5','102',4960039,'','20','2383',0.00,0.00,'Sales from shift 257659 on 2022-02-01 22:06:36 ','2022-02-01 22:06:36','',''),('5','102',4960040,'','6.1','2371',0.00,0.00,'Sales from shift 257659 on 2022-02-01 22:06:36 ','2022-02-01 22:06:36','',''),('5','102',4960041,'','20','2383',0.00,0.00,'Sales from shift 257660 on 2022-02-03 16:02:51 ','2022-02-03 16:02:51','',''),('5','102',4960042,'','6.1','2371',0.00,0.00,'Sales from shift 257660 on 2022-02-03 16:02:51 ','2022-02-03 16:02:51','',''),('5','102',4960043,'','20','2383',0.00,0.00,'Sales from shift 257661 on 2022-02-04 09:35:58 ','2022-02-04 09:35:58','',''),('5','102',4960044,'','6.1','2371',0.00,0.00,'Sales from shift 257661 on 2022-02-04 09:35:58 ','2022-02-04 09:35:58','',''),('5','102',4960045,'','20','2383',0.00,0.00,'Sales from shift 257662 on 2022-02-05 20:15:17 ','2022-02-05 20:15:17','',''),('5','102',4960046,'','6.1','2371',0.00,0.00,'Sales from shift 257662 on 2022-02-05 20:15:17 ','2022-02-05 20:15:17','',''),('5','102',4960047,'','20','2383',0.00,0.00,'Sales from shift 257663 on 2022-02-09 00:10:49 ','2022-02-09 00:10:49','',''),('5','102',4960048,'','6.1','2371',0.00,0.00,'Sales from shift 257663 on 2022-02-09 00:10:49 ','2022-02-09 00:10:49','',''),('5','102',4960049,'','20','2383',0.00,0.00,'Sales from shift 257664 on 2022-02-09 12:47:36 ','2022-02-09 12:47:36','',''),('5','102',4960050,'','6.1','2371',0.00,0.00,'Sales from shift 257664 on 2022-02-09 12:47:36 ','2022-02-09 12:47:36','',''),('5','102',4960051,'','20','2383',0.00,0.00,'Sales from shift 257665 on 2022-02-09 12:55:16 ','2022-02-09 12:55:16','',''),('5','102',4960052,'','6.1','2371',0.00,0.00,'Sales from shift 257665 on 2022-02-09 12:55:16 ','2022-02-09 12:55:16','',''),('5','102',4960053,'','20','2383',0.00,0.00,'Sales from shift 257666 on 2022-02-10 20:28:42 ','2022-02-10 20:28:42','',''),('5','102',4960054,'','6.1','2371',0.00,0.00,'Sales from shift 257666 on 2022-02-10 20:28:42 ','2022-02-10 20:28:42','',''),('5','102',4960055,'','20','2383',0.00,0.00,'Sales from shift 257667 on 2022-02-11 11:24:11 ','2022-02-11 11:24:11','',''),('5','102',4960056,'','6.1','2371',0.00,0.00,'Sales from shift 257667 on 2022-02-11 11:24:11 ','2022-02-11 11:24:11','',''),('5','102',4960057,'','20','2383',0.00,0.00,'Sales from shift 257668 on 2022-02-13 21:03:09 ','2022-02-13 21:03:09','',''),('5','102',4960058,'','6.1','2371',0.00,0.00,'Sales from shift 257668 on 2022-02-13 21:03:09 ','2022-02-13 21:03:09','',''),('5','102',4960059,'','20','2383',0.00,0.00,'Sales from shift 257669 on 2022-02-13 21:08:50 ','2022-02-13 21:08:50','',''),('5','102',4960060,'','6.1','2371',0.00,0.00,'Sales from shift 257669 on 2022-02-13 21:08:50 ','2022-02-13 21:08:50','',''),('5','102',4960061,'','20','2383',0.00,0.00,'Sales from shift 257670 on 2022-02-14 22:30:07 ','2022-02-14 22:30:07','',''),('5','102',4960062,'','6.1','2371',0.00,0.00,'Sales from shift 257670 on 2022-02-14 22:30:07 ','2022-02-14 22:30:07','',''),('5','102',4960063,'','20','2383',0.00,0.00,'Sales from shift 257671 on 2022-02-15 07:06:17 ','2022-02-15 07:06:17','',''),('5','102',4960064,'','6.1','2371',0.00,0.00,'Sales from shift 257671 on 2022-02-15 07:06:17 ','2022-02-15 07:06:17','',''),('5','102',4960065,'','20','2383',0.00,0.00,'Sales from shift 257672 on 2022-02-16 09:51:44 ','2022-02-16 09:51:44','',''),('5','102',4960066,'','6.1','2371',0.00,0.00,'Sales from shift 257672 on 2022-02-16 09:51:44 ','2022-02-16 09:51:44','',''),('5','102',4960067,'','2','2384',131000.00,0.00,'Payment Id 390622 for invoice:257672, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2022-02-16 16:31:00','',''),('5','102',4960068,'','supplier','107',0.00,131000.00,'Payment Id 390622 for invoice:257672, receipt: 2780 by SALBAS OIL & GAS NIG. LIMITED','2022-02-16 16:31:00','',''),('5','102',4960069,'','20','2383',0.00,0.00,'Sales from shift 257673 on 2022-02-17 17:52:20 ','2022-02-17 17:52:20','',''),('5','102',4960070,'','6.1','2371',0.00,0.00,'Sales from shift 257673 on 2022-02-17 17:52:20 ','2022-02-17 17:52:20','',''),('5','102',4960071,'','20','2383',0.00,0.00,'Sales from shift 257674 on 2022-02-18 11:56:42 ','2022-02-18 11:56:42','',''),('5','102',4960072,'','6.1','2371',0.00,0.00,'Sales from shift 257674 on 2022-02-18 11:56:42 ','2022-02-18 11:56:42','',''),('5','102',4960073,'','20','2383',0.00,0.00,'Sales from shift 257675 on 2022-02-19 22:50:37 ','2022-02-19 22:50:37','',''),('5','102',4960074,'','6.1','2371',0.00,0.00,'Sales from shift 257675 on 2022-02-19 22:50:37 ','2022-02-19 22:50:37','',''),('5','102',4960075,'','20','2383',0.00,0.00,'Sales from shift 257676 on 2022-02-21 11:51:08 ','2022-02-21 11:51:08','',''),('5','102',4960076,'','6.1','2371',0.00,0.00,'Sales from shift 257676 on 2022-02-21 11:51:08 ','2022-02-21 11:51:08','',''),('5','102',4960077,'','20','2383',0.00,0.00,'Sales from shift 257677 on 2022-02-22 07:22:16 ','2022-02-22 07:22:16','',''),('5','102',4960078,'','6.1','2371',0.00,0.00,'Sales from shift 257677 on 2022-02-22 07:22:16 ','2022-02-22 07:22:16','',''),('5','102',4960079,'','20','2383',0.00,0.00,'Sales from shift 257678 on 2022-02-22 22:40:07 ','2022-02-22 22:40:07','',''),('5','102',4960080,'','6.1','2371',0.00,0.00,'Sales from shift 257678 on 2022-02-22 22:40:07 ','2022-02-22 22:40:07','',''),('5','102',4960081,'','20','2383',0.00,0.00,'Sales from shift 257679 on 2022-02-23 10:24:02 ','2022-02-23 10:24:02','',''),('5','102',4960082,'','6.1','2371',0.00,0.00,'Sales from shift 257679 on 2022-02-23 10:24:02 ','2022-02-23 10:24:02','',''),('5','102',4960083,'','24','2369',0.00,6600000.00,'Purchase Id 88670 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-02-23 18:43:37','',''),('5','102',4960084,'','supplier','107',6600000.00,0.00,'Purchase Id 88670 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-02-23 18:43:37','',''),('5','102',4960085,'','20','2383',1234242.90,0.00,'Sales from shift 257680 on 2022-02-24 07:02:42 ','2022-02-24 07:02:42','',''),('5','102',4960086,'','6.1','2371',0.00,1234242.90,'Sales from shift 257680 on 2022-02-24 07:02:42 ','2022-02-24 07:02:42','',''),('5','102',4960087,'','customer','2992',0.00,28449.30,'Credit Sales for 172.42 Litres of Petrol from shift 257681 on 2022-02-25 23:20:10 ','2022-02-25 23:20:10','',''),('5','102',4960088,'','20','2383',2725638.30,0.00,'Sales from shift 257681 on 2022-02-25 23:20:10 ','2022-02-25 23:20:10','',''),('5','102',4960089,'','6.1','2371',0.00,2697189.00,'Sales from shift 257681 on 2022-02-25 23:20:10 ','2022-02-25 23:20:10','',''),('5','102',4960090,'','customer','2992',0.00,20248.80,'Credit Sales for 122.72 Litres of Petrol from shift 257682 on 2022-02-26 22:33:15 ','2022-02-26 22:33:15','',''),('5','102',4960091,'','20','2383',1844427.75,0.00,'Sales from shift 257682 on 2022-02-26 22:33:15 ','2022-02-26 22:33:15','',''),('5','102',4960092,'','6.1','2371',0.00,1824178.95,'Sales from shift 257682 on 2022-02-26 22:33:15 ','2022-02-26 22:33:15','',''),('5','102',4960093,'','customer','2992',0.00,19999.65,'Credit Sales for 121.21 Litres of Petrol from shift 257683 on 2022-02-27 09:57:40 ','2022-02-27 09:57:40','',''),('5','102',4960094,'','20','2383',827237.40,0.00,'Sales from shift 257683 on 2022-02-27 09:57:40 ','2022-02-27 09:57:40','',''),('5','102',4960095,'','6.1','2371',0.00,807237.75,'Sales from shift 257683 on 2022-02-27 09:57:40 ','2022-02-27 09:57:40','',''),('5','102',4960096,'','20','2383',0.00,0.00,'Sales from shift 257684 on 2022-03-01 07:05:00 ','2022-03-01 07:05:00','',''),('5','102',4960097,'','6.1','2371',0.00,0.00,'Sales from shift 257684 on 2022-03-01 07:05:00 ','2022-03-01 07:05:00','',''),('5','102',4960098,'','20','2383',0.00,0.00,'Sales from shift 257685 on 2022-03-02 09:55:03 ','2022-03-02 09:55:03','',''),('5','102',4960099,'','6.1','2371',0.00,0.00,'Sales from shift 257685 on 2022-03-02 09:55:03 ','2022-03-02 09:55:03','',''),('5','102',4960100,'','2','2384',1228200.00,0.00,'Payment Id 390623 for invoice:257680, receipt: 035 by SALBAS OIL & GAS NIG. LIMITED','2022-03-02 09:55:31','',''),('5','102',4960101,'','supplier','107',0.00,1228200.00,'Payment Id 390623 for invoice:257680, receipt: 035 by SALBAS OIL & GAS NIG. LIMITED','2022-03-02 09:55:31','',''),('5','102',4960102,'','6.1','2371',6225.00,0.00,'Payment Id 390624 for invoice:257680, receipt: 035 by SALBAS OIL & GAS NIG. LIMITED','2022-03-02 09:55:52','',''),('5','102',4960103,'','supplier','107',0.00,6225.00,'Payment Id 390624 for invoice:257680, receipt: 035 by SALBAS OIL & GAS NIG. LIMITED','2022-03-02 09:55:52','',''),('5','102',4960104,'','2','2384',2676960.00,0.00,'Payment Id 390625 for invoice:257681, receipt: 035 by SALBAS OIL & GAS NIG. LIMITED','2022-03-02 09:56:16','',''),('5','102',4960105,'','supplier','107',0.00,2676960.00,'Payment Id 390625 for invoice:257681, receipt: 035 by SALBAS OIL & GAS NIG. LIMITED','2022-03-02 09:56:16','',''),('5','102',4960106,'','6.1','2371',22225.00,0.00,'Payment Id 390626 for invoice:257681, receipt: 035 by SALBAS OIL & GAS NIG. LIMITED','2022-03-02 09:56:40','',''),('5','102',4960107,'','supplier','107',0.00,22225.00,'Payment Id 390626 for invoice:257681, receipt: 035 by SALBAS OIL & GAS NIG. LIMITED','2022-03-02 09:56:40','',''),('5','102',4960108,'','2','2384',1606250.00,0.00,'Payment Id 390627 for invoice:257682, receipt: 035 by SALBAS OIL & GAS NIG. LIMITED','2022-03-02 09:57:08','',''),('5','102',4960109,'','supplier','107',0.00,1606250.00,'Payment Id 390627 for invoice:257682, receipt: 035 by SALBAS OIL & GAS NIG. LIMITED','2022-03-02 09:57:08','',''),('5','102',4960110,'','6.1','2371',217925.00,0.00,'Payment Id 390628 for invoice:257682, receipt: 035 by SALBAS OIL & GAS NIG. LIMITED','2022-03-02 09:57:34','',''),('5','102',4960111,'','supplier','107',0.00,217925.00,'Payment Id 390628 for invoice:257682, receipt: 035 by SALBAS OIL & GAS NIG. LIMITED','2022-03-02 09:57:34','',''),('5','102',4960112,'','2','2384',729550.00,0.00,'Payment Id 390629 for invoice:257683, receipt: 035 by SALBAS OIL & GAS NIG. LIMITED','2022-03-02 09:57:57','',''),('5','102',4960113,'','supplier','107',0.00,729550.00,'Payment Id 390629 for invoice:257683, receipt: 035 by SALBAS OIL & GAS NIG. LIMITED','2022-03-02 09:57:57','',''),('5','102',4960114,'','6.1','2371',77725.00,0.00,'Payment Id 390630 for invoice:257683, receipt: 035 by SALBAS OIL & GAS NIG. LIMITED','2022-03-02 09:58:15','',''),('5','102',4960115,'','supplier','107',0.00,77725.00,'Payment Id 390630 for invoice:257683, receipt: 035 by SALBAS OIL & GAS NIG. LIMITED','2022-03-02 09:58:15','',''),('5','102',4960116,'','20','2383',0.00,0.00,'Sales from shift 257686 on 2022-03-02 23:17:36 ','2022-03-02 23:17:36','',''),('5','102',4960117,'','6.1','2371',0.00,0.00,'Sales from shift 257686 on 2022-03-02 23:17:36 ','2022-03-02 23:17:36','',''),('5','102',4960118,'','20','2383',0.00,0.00,'Sales from shift 257687 on 2022-03-03 21:28:55 ','2022-03-03 21:28:55','',''),('5','102',4960119,'','6.1','2371',0.00,0.00,'Sales from shift 257687 on 2022-03-03 21:28:55 ','2022-03-03 21:28:55','',''),('5','102',4960120,'','20','2383',0.00,0.00,'Sales from shift 257688 on 2022-03-05 00:17:27 ','2022-03-05 00:17:27','',''),('5','102',4960121,'','6.1','2371',0.00,0.00,'Sales from shift 257688 on 2022-03-05 00:17:27 ','2022-03-05 00:17:27','',''),('5','102',4960122,'','20','2383',0.00,0.00,'Sales from shift 257689 on 2022-03-08 10:19:26 ','2022-03-08 10:19:26','',''),('5','102',4960123,'','6.1','2371',0.00,0.00,'Sales from shift 257689 on 2022-03-08 10:19:26 ','2022-03-08 10:19:26','',''),('5','102',4960124,'','20','2383',0.00,0.00,'Sales from shift 257690 on 2022-03-08 10:44:27 ','2022-03-08 10:44:27','',''),('5','102',4960125,'','6.1','2371',0.00,0.00,'Sales from shift 257690 on 2022-03-08 10:44:27 ','2022-03-08 10:44:27','',''),('5','102',4960126,'','20','2383',0.00,0.00,'Sales from shift 257691 on 2022-03-08 10:46:05 ','2022-03-08 10:46:05','',''),('5','102',4960127,'','6.1','2371',0.00,0.00,'Sales from shift 257691 on 2022-03-08 10:46:05 ','2022-03-08 10:46:05','',''),('5','102',4960128,'','20','2383',0.00,0.00,'Sales from shift 257692 on 2022-03-08 11:08:13 ','2022-03-08 11:08:13','',''),('5','102',4960129,'','6.1','2371',0.00,0.00,'Sales from shift 257692 on 2022-03-08 11:08:13 ','2022-03-08 11:08:13','',''),('5','102',4960130,'','20','2383',0.00,0.00,'Sales from shift 257693 on 2022-03-09 09:59:51 ','2022-03-09 09:59:51','',''),('5','102',4960131,'','6.1','2371',0.00,0.00,'Sales from shift 257693 on 2022-03-09 09:59:51 ','2022-03-09 09:59:51','',''),('5','102',4960132,'','20','2383',0.00,0.00,'Sales from shift 257694 on 2022-03-10 14:04:33 ','2022-03-10 14:04:33','',''),('5','102',4960133,'','6.1','2371',0.00,0.00,'Sales from shift 257694 on 2022-03-10 14:04:33 ','2022-03-10 14:04:33','',''),('5','102',4960134,'','20','2383',0.00,0.00,'Sales from shift 257695 on 2022-03-12 10:26:28 ','2022-03-12 10:26:28','',''),('5','102',4960135,'','6.1','2371',0.00,0.00,'Sales from shift 257695 on 2022-03-12 10:26:28 ','2022-03-12 10:26:28','',''),('5','102',4960136,'','20','2383',0.00,0.00,'Sales from shift 257696 on 2022-03-12 21:34:34 ','2022-03-12 21:34:34','',''),('5','102',4960137,'','6.1','2371',0.00,0.00,'Sales from shift 257696 on 2022-03-12 21:34:34 ','2022-03-12 21:34:34','',''),('5','102',4960138,'','20','2383',0.00,0.00,'Sales from shift 257697 on 2022-03-12 21:41:41 ','2022-03-12 21:41:41','',''),('5','102',4960139,'','6.1','2371',0.00,0.00,'Sales from shift 257697 on 2022-03-12 21:41:41 ','2022-03-12 21:41:41','',''),('5','102',4960140,'','20','2383',0.00,0.00,'Sales from shift 257698 on 2022-03-13 23:25:10 ','2022-03-13 23:25:10','',''),('5','102',4960141,'','6.1','2371',0.00,0.00,'Sales from shift 257698 on 2022-03-13 23:25:10 ','2022-03-13 23:25:10','',''),('5','102',4960142,'','20','2383',0.00,0.00,'Sales from shift 257699 on 2022-03-15 10:51:54 ','2022-03-15 10:51:54','',''),('5','102',4960143,'','6.1','2371',0.00,0.00,'Sales from shift 257699 on 2022-03-15 10:51:54 ','2022-03-15 10:51:54','',''),('5','102',4960144,'','20','2383',0.00,0.00,'Sales from shift 257700 on 2022-03-15 20:47:34 ','2022-03-15 20:47:34','',''),('5','102',4960145,'','6.1','2371',0.00,0.00,'Sales from shift 257700 on 2022-03-15 20:47:34 ','2022-03-15 20:47:34','',''),('5','102',4960146,'','20','2383',0.00,0.00,'Sales from shift 257701 on 2022-03-16 22:26:43 ','2022-03-16 22:26:43','',''),('5','102',4960147,'','6.1','2371',0.00,0.00,'Sales from shift 257701 on 2022-03-16 22:26:43 ','2022-03-16 22:26:43','',''),('5','102',4960148,'','20','2383',0.00,0.00,'Sales from shift 257702 on 2022-03-17 22:03:04 ','2022-03-17 22:03:04','',''),('5','102',4960149,'','6.1','2371',0.00,0.00,'Sales from shift 257702 on 2022-03-17 22:03:04 ','2022-03-17 22:03:04','',''),('5','102',4960150,'','20','2383',0.00,0.00,'Sales from shift 257703 on 2022-03-19 22:50:16 ','2022-03-19 22:50:16','',''),('5','102',4960151,'','6.1','2371',0.00,0.00,'Sales from shift 257703 on 2022-03-19 22:50:16 ','2022-03-19 22:50:16','',''),('5','102',4960152,'','20','2383',0.00,0.00,'Sales from shift 257704 on 2022-03-20 20:33:58 ','2022-03-20 20:33:58','',''),('5','102',4960153,'','6.1','2371',0.00,0.00,'Sales from shift 257704 on 2022-03-20 20:33:58 ','2022-03-20 20:33:58','',''),('5','102',4960154,'','20','2383',0.00,0.00,'Sales from shift 257705 on 2022-03-22 16:05:56 ','2022-03-22 16:05:56','',''),('5','102',4960155,'','6.1','2371',0.00,0.00,'Sales from shift 257705 on 2022-03-22 16:05:56 ','2022-03-22 16:05:56','',''),('5','102',4960156,'','20','2383',0.00,0.00,'Sales from shift 257706 on 2022-03-22 19:24:46 ','2022-03-22 19:24:46','',''),('5','102',4960157,'','6.1','2371',0.00,0.00,'Sales from shift 257706 on 2022-03-22 19:24:46 ','2022-03-22 19:24:46','',''),('5','102',4960158,'','20','2383',0.00,0.00,'Sales from shift 257707 on 2022-03-23 14:00:04 ','2022-03-23 14:00:04','',''),('5','102',4960159,'','6.1','2371',0.00,0.00,'Sales from shift 257707 on 2022-03-23 14:00:04 ','2022-03-23 14:00:04','',''),('5','102',4960160,'','20','2383',0.00,0.00,'Sales from shift 257708 on 2022-03-28 12:00:33 ','2022-03-28 12:00:33','',''),('5','102',4960161,'','6.1','2371',0.00,0.00,'Sales from shift 257708 on 2022-03-28 12:00:33 ','2022-03-28 12:00:33','',''),('5','102',4960162,'','20','2383',0.00,0.00,'Sales from shift 257709 on 2022-03-28 14:29:11 ','2022-03-28 14:29:11','',''),('5','102',4960163,'','6.1','2371',0.00,0.00,'Sales from shift 257709 on 2022-03-28 14:29:11 ','2022-03-28 14:29:11','',''),('5','102',4960164,'','20','2383',0.00,0.00,'Sales from shift 257710 on 2022-03-28 14:39:07 ','2022-03-28 14:39:07','',''),('5','102',4960165,'','6.1','2371',0.00,0.00,'Sales from shift 257710 on 2022-03-28 14:39:07 ','2022-03-28 14:39:07','',''),('5','102',4960166,'','20','2383',0.00,0.00,'Sales from shift 257711 on 2022-03-28 14:48:53 ','2022-03-28 14:48:53','',''),('5','102',4960167,'','6.1','2371',0.00,0.00,'Sales from shift 257711 on 2022-03-28 14:48:53 ','2022-03-28 14:48:53','',''),('5','102',4960168,'','24','2369',0.00,6600000.00,'Purchase Id 88671 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-03-31 10:44:56','',''),('5','102',4960169,'','supplier','107',6600000.00,0.00,'Purchase Id 88671 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-03-31 10:44:56','',''),('5','102',4960170,'','20','2383',864799.65,0.00,'Sales from shift 257712 on 2022-03-31 15:09:19 ','2022-03-31 15:09:19','',''),('5','102',4960171,'','6.1','2371',0.00,864799.65,'Sales from shift 257712 on 2022-03-31 15:09:19 ','2022-03-31 15:09:19','',''),('5','102',4960172,'','customer','2992',0.00,6758.40,'Credit Sales for 40.96 Litres of Petrol from shift 257713 on 2022-03-31 15:19:21 ','2022-03-31 15:19:21','',''),('5','102',4960173,'','20','2383',2769721.35,0.00,'Sales from shift 257713 on 2022-03-31 15:19:21 ','2022-03-31 15:19:21','',''),('5','102',4960174,'','6.1','2371',0.00,2762962.95,'Sales from shift 257713 on 2022-03-31 15:19:21 ','2022-03-31 15:19:21','',''),('5','102',4960175,'','customer','2992',0.00,27885.00,'Credit Sales for 169.00 Litres of Petrol from shift 257714 on 2022-03-31 15:25:33 ','2022-03-31 15:25:33','',''),('5','102',4960176,'','20','2383',1387942.05,0.00,'Sales from shift 257714 on 2022-03-31 15:25:33 ','2022-03-31 15:25:33','',''),('5','102',4960177,'','6.1','2371',0.00,1360057.05,'Sales from shift 257714 on 2022-03-31 15:25:33 ','2022-03-31 15:25:33','',''),('5','102',4960178,'','20','2383',1221404.25,0.00,'Sales from shift 257715 on 2022-03-31 15:29:15 ','2022-03-31 15:29:15','',''),('5','102',4960179,'','6.1','2371',0.00,1221404.25,'Sales from shift 257715 on 2022-03-31 15:29:15 ','2022-03-31 15:29:15','',''),('5','102',4960180,'','2','3355',852700.00,0.00,'Payment Id 390631 for invoice:257712, receipt: 6890495 by SALBAS OIL & GAS NIG. LIMITED','2022-03-31 15:46:46','',''),('5','102',4960181,'','supplier','107',0.00,852700.00,'Payment Id 390631 for invoice:257712, receipt: 6890495 by SALBAS OIL & GAS NIG. LIMITED','2022-03-31 15:46:46','',''),('5','102',4960182,'','2','3355',2706660.00,0.00,'Payment Id 390633 for invoice:257713, receipt: 0278 by SALBAS OIL & GAS NIG. LIMITED','2022-03-31 15:49:19','',''),('5','102',4960183,'','supplier','107',0.00,2706660.00,'Payment Id 390633 for invoice:257713, receipt: 0278 by SALBAS OIL & GAS NIG. LIMITED','2022-03-31 15:49:19','',''),('5','102',4960184,'','2','3355',1148950.00,0.00,'Payment Id 390635 for invoice:257714, receipt: 0278 by SALBAS OIL & GAS NIG. LIMITED','2022-03-31 15:50:09','',''),('5','102',4960185,'','supplier','107',0.00,1148950.00,'Payment Id 390635 for invoice:257714, receipt: 0278 by SALBAS OIL & GAS NIG. LIMITED','2022-03-31 15:50:09','',''),('5','102',4960186,'','2','3355',1211470.00,0.00,'Payment Id 390637 for invoice:257715, receipt: 0278 by SALBAS OIL & GAS NIG. LIMITED','2022-03-31 15:50:39','',''),('5','102',4960187,'','supplier','107',0.00,1211470.00,'Payment Id 390637 for invoice:257715, receipt: 0278 by SALBAS OIL & GAS NIG. LIMITED','2022-03-31 15:50:39','',''),('5','102',4960188,'','6.1','2371',12100.00,0.00,'Payment Id 390632 for invoice:257712, receipt: 6890495 by SALBAS OIL & GAS NIG. LIMITED','2022-03-31 15:53:57','',''),('5','102',4960189,'','supplier','107',0.00,12100.00,'Payment Id 390632 for invoice:257712, receipt: 6890495 by SALBAS OIL & GAS NIG. LIMITED','2022-03-31 15:53:57','',''),('5','102',4960190,'','6.1','2371',9600.00,0.00,'Payment Id 390638 for invoice:257715, receipt: 0278 by SALBAS OIL & GAS NIG. LIMITED','2022-03-31 15:54:27','',''),('5','102',4960191,'','supplier','107',0.00,9600.00,'Payment Id 390638 for invoice:257715, receipt: 0278 by SALBAS OIL & GAS NIG. LIMITED','2022-03-31 15:54:27','',''),('5','102',4960192,'','6.1','2371',211100.00,0.00,'Payment Id 390636 for invoice:257714, receipt: 0278 by SALBAS OIL & GAS NIG. LIMITED','2022-03-31 15:54:44','',''),('5','102',4960193,'','supplier','107',0.00,211100.00,'Payment Id 390636 for invoice:257714, receipt: 0278 by SALBAS OIL & GAS NIG. LIMITED','2022-03-31 15:54:44','',''),('5','102',4960194,'','6.1','2371',56300.00,0.00,'Payment Id 390634 for invoice:257713, receipt: 0278 by SALBAS OIL & GAS NIG. LIMITED','2022-03-31 15:55:03','',''),('5','102',4960195,'','supplier','107',0.00,56300.00,'Payment Id 390634 for invoice:257713, receipt: 0278 by SALBAS OIL & GAS NIG. LIMITED','2022-03-31 15:55:03','',''),('5','102',4960196,'','customer','2992',0.00,12498.75,'Credit Sales for 75.75 Litres of Petrol from shift 257716 on 2022-04-04 09:45:07 ','2022-04-04 09:45:07','',''),('5','102',4960197,'','20','2383',368973.00,0.00,'Sales from shift 257716 on 2022-04-04 09:45:07 ','2022-04-04 09:45:07','',''),('5','102',4960198,'','6.1','2371',0.00,356474.25,'Sales from shift 257716 on 2022-04-04 09:45:07 ','2022-04-04 09:45:07','',''),('5','102',4960199,'','20','2383',0.00,0.00,'Sales from shift 257717 on 2022-04-04 12:28:51 ','2022-04-04 12:28:51','',''),('5','102',4960200,'','6.1','2371',0.00,0.00,'Sales from shift 257717 on 2022-04-04 12:28:51 ','2022-04-04 12:28:51','',''),('5','102',4960201,'','20','2383',0.00,0.00,'Sales from shift 257718 on 2022-04-06 16:16:12 ','2022-04-06 16:16:12','',''),('5','102',4960202,'','6.1','2371',0.00,0.00,'Sales from shift 257718 on 2022-04-06 16:16:12 ','2022-04-06 16:16:12','',''),('5','102',4960203,'','20','2383',0.00,0.00,'Sales from shift 257719 on 2022-04-06 16:17:41 ','2022-04-06 16:17:41','',''),('5','102',4960204,'','6.1','2371',0.00,0.00,'Sales from shift 257719 on 2022-04-06 16:17:41 ','2022-04-06 16:17:41','',''),('5','102',4960205,'','20','2383',0.00,0.00,'Sales from shift 257720 on 2022-04-06 16:24:18 ','2022-04-06 16:24:18','',''),('5','102',4960206,'','6.1','2371',0.00,0.00,'Sales from shift 257720 on 2022-04-06 16:24:18 ','2022-04-06 16:24:18','',''),('5','102',4960207,'','20','2383',0.00,0.00,'Sales from shift 257721 on 2022-04-06 16:26:55 ','2022-04-06 16:26:55','',''),('5','102',4960208,'','6.1','2371',0.00,0.00,'Sales from shift 257721 on 2022-04-06 16:26:55 ','2022-04-06 16:26:55','',''),('5','102',4960209,'','20','2383',0.00,0.00,'Sales from shift 257722 on 2022-04-08 13:00:21 ','2022-04-08 13:00:21','',''),('5','102',4960210,'','6.1','2371',0.00,0.00,'Sales from shift 257722 on 2022-04-08 13:00:21 ','2022-04-08 13:00:21','',''),('5','102',4960211,'','20','2383',0.00,0.00,'Sales from shift 257723 on 2022-04-10 10:43:31 ','2022-04-10 10:43:31','',''),('5','102',4960212,'','6.1','2371',0.00,0.00,'Sales from shift 257723 on 2022-04-10 10:43:31 ','2022-04-10 10:43:31','',''),('5','102',4960213,'','20','2383',0.00,0.00,'Sales from shift 257724 on 2022-04-10 11:52:05 ','2022-04-10 11:52:05','',''),('5','102',4960214,'','6.1','2371',0.00,0.00,'Sales from shift 257724 on 2022-04-10 11:52:05 ','2022-04-10 11:52:05','',''),('5','102',4960215,'','20','2383',0.00,0.00,'Sales from shift 257725 on 2022-04-10 12:02:43 ','2022-04-10 12:02:43','',''),('5','102',4960216,'','6.1','2371',0.00,0.00,'Sales from shift 257725 on 2022-04-10 12:02:43 ','2022-04-10 12:02:43','',''),('5','102',4960217,'','20','2383',0.00,0.00,'Sales from shift 257726 on 2022-04-11 09:19:51 ','2022-04-11 09:19:51','',''),('5','102',4960218,'','6.1','2371',0.00,0.00,'Sales from shift 257726 on 2022-04-11 09:19:51 ','2022-04-11 09:19:51','',''),('5','102',4960219,'','20','2383',0.00,0.00,'Sales from shift 257727 on 2022-04-13 10:09:10 ','2022-04-13 10:09:10','',''),('5','102',4960220,'','6.1','2371',0.00,0.00,'Sales from shift 257727 on 2022-04-13 10:09:10 ','2022-04-13 10:09:10','',''),('5','102',4960221,'','20','2383',0.00,0.00,'Sales from shift 257728 on 2022-04-13 15:19:26 ','2022-04-13 15:19:26','',''),('5','102',4960222,'','6.1','2371',0.00,0.00,'Sales from shift 257728 on 2022-04-13 15:19:26 ','2022-04-13 15:19:26','',''),('5','102',4960223,'','20','2383',0.00,0.00,'Sales from shift 257729 on 2022-04-14 20:40:18 ','2022-04-14 20:40:18','',''),('5','102',4960224,'','6.1','2371',0.00,0.00,'Sales from shift 257729 on 2022-04-14 20:40:18 ','2022-04-14 20:40:18','',''),('5','102',4960225,'','20','2383',0.00,0.00,'Sales from shift 257730 on 2022-04-16 10:50:02 ','2022-04-16 10:50:02','',''),('5','102',4960226,'','6.1','2371',0.00,0.00,'Sales from shift 257730 on 2022-04-16 10:50:02 ','2022-04-16 10:50:02','',''),('5','102',4960227,'','20','2383',0.00,0.00,'Sales from shift 257731 on 2022-04-18 17:25:38 ','2022-04-18 17:25:38','',''),('5','102',4960228,'','6.1','2371',0.00,0.00,'Sales from shift 257731 on 2022-04-18 17:25:38 ','2022-04-18 17:25:38','',''),('5','102',4960229,'','20','2383',0.00,0.00,'Sales from shift 257732 on 2022-04-18 21:42:06 ','2022-04-18 21:42:06','',''),('5','102',4960230,'','6.1','2371',0.00,0.00,'Sales from shift 257732 on 2022-04-18 21:42:06 ','2022-04-18 21:42:06','',''),('5','102',4960231,'','20','2383',0.00,0.00,'Sales from shift 257733 on 2022-04-18 22:07:40 ','2022-04-18 22:07:40','',''),('5','102',4960232,'','6.1','2371',0.00,0.00,'Sales from shift 257733 on 2022-04-18 22:07:40 ','2022-04-18 22:07:40','',''),('5','102',4960233,'','20','2383',0.00,0.00,'Sales from shift 257734 on 2022-04-19 10:15:59 ','2022-04-19 10:15:59','',''),('5','102',4960234,'','6.1','2371',0.00,0.00,'Sales from shift 257734 on 2022-04-19 10:15:59 ','2022-04-19 10:15:59','',''),('5','102',4960235,'','20','2383',0.00,0.00,'Sales from shift 257735 on 2022-04-20 13:18:14 ','2022-04-20 13:18:14','',''),('5','102',4960236,'','6.1','2371',0.00,0.00,'Sales from shift 257735 on 2022-04-20 13:18:14 ','2022-04-20 13:18:14','',''),('5','102',4960237,'','20','2383',0.00,0.00,'Sales from shift 257736 on 2022-04-21 23:56:12 ','2022-04-21 23:56:12','',''),('5','102',4960238,'','6.1','2371',0.00,0.00,'Sales from shift 257736 on 2022-04-21 23:56:12 ','2022-04-21 23:56:12','',''),('5','102',4960239,'','20','2383',0.00,0.00,'Sales from shift 257737 on 2022-04-22 00:02:52 ','2022-04-22 00:02:52','',''),('5','102',4960240,'','6.1','2371',0.00,0.00,'Sales from shift 257737 on 2022-04-22 00:02:52 ','2022-04-22 00:02:52','',''),('5','102',4960241,'','20','2383',0.00,0.00,'Sales from shift 257738 on 2022-04-24 14:42:30 ','2022-04-24 14:42:30','',''),('5','102',4960242,'','6.1','2371',0.00,0.00,'Sales from shift 257738 on 2022-04-24 14:42:30 ','2022-04-24 14:42:30','',''),('5','102',4960243,'','20','2383',0.00,0.00,'Sales from shift 257739 on 2022-04-25 12:38:14 ','2022-04-25 12:38:14','',''),('5','102',4960244,'','6.1','2371',0.00,0.00,'Sales from shift 257739 on 2022-04-25 12:38:14 ','2022-04-25 12:38:14','',''),('5','102',4960245,'','20','2383',0.00,0.00,'Sales from shift 257740 on 2022-04-25 12:42:03 ','2022-04-25 12:42:03','',''),('5','102',4960246,'','6.1','2371',0.00,0.00,'Sales from shift 257740 on 2022-04-25 12:42:03 ','2022-04-25 12:42:03','',''),('5','102',4960247,'','20','2383',0.00,0.00,'Sales from shift 257741 on 2022-04-26 09:14:18 ','2022-04-26 09:14:18','',''),('5','102',4960248,'','6.1','2371',0.00,0.00,'Sales from shift 257741 on 2022-04-26 09:14:18 ','2022-04-26 09:14:18','',''),('5','102',4960249,'','20','2383',0.00,0.00,'Sales from shift 257742 on 2022-04-27 11:52:48 ','2022-04-27 11:52:48','',''),('5','102',4960250,'','6.1','2371',0.00,0.00,'Sales from shift 257742 on 2022-04-27 11:52:48 ','2022-04-27 11:52:48','',''),('5','102',4960251,'','20','2383',0.00,0.00,'Sales from shift 257743 on 2022-04-29 10:23:26 ','2022-04-29 10:23:26','',''),('5','102',4960252,'','6.1','2371',0.00,0.00,'Sales from shift 257743 on 2022-04-29 10:23:26 ','2022-04-29 10:23:26','',''),('5','102',4960253,'','24','2369',0.00,6600000.00,'Purchase Id 88672 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-05-10 09:53:22','',''),('5','102',4960254,'','supplier','107',6600000.00,0.00,'Purchase Id 88672 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-05-10 09:53:22','',''),('5','102',4960255,'','20','2383',776656.65,0.00,'Sales from shift 257744 on 2022-05-10 11:18:41 ','2022-05-10 11:18:41','',''),('5','102',4960256,'','6.1','2371',0.00,776656.65,'Sales from shift 257744 on 2022-05-10 11:18:41 ','2022-05-10 11:18:41','',''),('5','102',4960257,'','20','2383',663465.00,0.00,'Sales from shift 257745 on 2022-05-10 11:21:45 ','2022-05-10 11:21:45','',''),('5','102',4960258,'','6.1','2371',0.00,663465.00,'Sales from shift 257745 on 2022-05-10 11:21:45 ','2022-05-10 11:21:45','',''),('5','102',4960259,'','customer','2992',0.00,57398.55,'Credit Sales for 347.87 Litres of Petrol from shift 257746 on 2022-05-10 11:35:21 ','2022-05-10 11:35:21','',''),('5','102',4960260,'','20','2383',696003.00,0.00,'Sales from shift 257746 on 2022-05-10 11:35:21 ','2022-05-10 11:35:21','',''),('5','102',4960261,'','6.1','2371',0.00,638604.45,'Sales from shift 257746 on 2022-05-10 11:35:21 ','2022-05-10 11:35:21','',''),('5','102',4960262,'','20','2383',770182.05,0.00,'Sales from shift 257747 on 2022-05-10 11:40:56 ','2022-05-10 11:40:56','',''),('5','102',4960263,'','6.1','2371',0.00,770182.05,'Sales from shift 257747 on 2022-05-10 11:40:56 ','2022-05-10 11:40:56','',''),('5','102',4960264,'','20','2383',693099.00,0.00,'Sales from shift 257748 on 2022-05-10 11:44:48 ','2022-05-10 11:44:48','',''),('5','102',4960265,'','6.1','2371',0.00,693099.00,'Sales from shift 257748 on 2022-05-10 11:44:48 ','2022-05-10 11:44:48','',''),('5','102',4960266,'','customer','2992',0.00,9999.00,'Credit Sales for 60.60 Litres of Petrol from shift 257749 on 2022-05-10 11:48:30 ','2022-05-10 11:48:30','',''),('5','102',4960267,'','20','2383',727928.85,0.00,'Sales from shift 257749 on 2022-05-10 11:48:30 ','2022-05-10 11:48:30','',''),('5','102',4960268,'','6.1','2371',0.00,717929.85,'Sales from shift 257749 on 2022-05-10 11:48:30 ','2022-05-10 11:48:30','',''),('5','102',4960269,'','customer','2992',0.00,7999.20,'Credit Sales for 48.48 Litres of Petrol from shift 257750 on 2022-05-10 11:50:28 ','2022-05-10 11:50:28','',''),('5','102',4960270,'','20','2383',689470.65,0.00,'Sales from shift 257750 on 2022-05-10 11:50:28 ','2022-05-10 11:50:28','',''),('5','102',4960271,'','6.1','2371',0.00,681471.45,'Sales from shift 257750 on 2022-05-10 11:50:28 ','2022-05-10 11:50:28','',''),('5','102',4960272,'','customer','2992',0.00,34999.80,'Credit Sales for 212.12 Litres of Petrol from shift 257751 on 2022-05-10 11:53:14 ','2022-05-10 11:53:14','',''),('5','102',4960273,'','20','2383',1032546.90,0.00,'Sales from shift 257751 on 2022-05-10 11:53:14 ','2022-05-10 11:53:14','',''),('5','102',4960274,'','6.1','2371',0.00,997547.10,'Sales from shift 257751 on 2022-05-10 11:53:14 ','2022-05-10 11:53:14','',''),('5','102',4960275,'','20','2383',554434.65,0.00,'Sales from shift 257752 on 2022-05-10 11:56:00 ','2022-05-10 11:56:00','',''),('5','102',4960276,'','6.1','2371',0.00,554434.65,'Sales from shift 257752 on 2022-05-10 11:56:00 ','2022-05-10 11:56:00','',''),('5','102',4960277,'','20','2383',0.00,0.00,'Sales from shift 257753 on 2022-05-10 12:02:30 ','2022-05-10 12:02:30','',''),('5','102',4960278,'','6.1','2371',0.00,0.00,'Sales from shift 257753 on 2022-05-10 12:02:30 ','2022-05-10 12:02:30','',''),('5','102',4960279,'','20','2383',0.00,0.00,'Sales from shift 257754 on 2022-05-10 12:04:09 ','2022-05-10 12:04:09','',''),('5','102',4960280,'','6.1','2371',0.00,0.00,'Sales from shift 257754 on 2022-05-10 12:04:09 ','2022-05-10 12:04:09','',''),('5','102',4960281,'','20','2383',0.00,0.00,'Sales from shift 257755 on 2022-05-11 09:37:53 ','2022-05-11 09:37:53','',''),('5','102',4960282,'','6.1','2371',0.00,0.00,'Sales from shift 257755 on 2022-05-11 09:37:53 ','2022-05-11 09:37:53','',''),('5','102',4960283,'','20','2383',0.00,0.00,'Sales from shift 257756 on 2022-05-13 11:00:22 ','2022-05-13 11:00:22','',''),('5','102',4960284,'','6.1','2371',0.00,0.00,'Sales from shift 257756 on 2022-05-13 11:00:22 ','2022-05-13 11:00:22','',''),('5','102',4960285,'','2','3355',683360.00,0.00,'Payment Id 390647 for invoice:257748, receipt: 035 by SALBAS OIL & GAS NIG. LIMITED','2022-05-13 15:55:56','',''),('5','102',4960286,'','supplier','107',0.00,683360.00,'Payment Id 390647 for invoice:257748, receipt: 035 by SALBAS OIL & GAS NIG. LIMITED','2022-05-13 15:55:56','',''),('5','102',4960287,'','2','3355',430575.00,0.00,'Payment Id 390649 for invoice:257749, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2022-05-13 15:56:05','',''),('5','102',4960288,'','supplier','107',0.00,430575.00,'Payment Id 390649 for invoice:257749, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2022-05-13 15:56:05','',''),('5','102',4960289,'','6.1','2371',9900.00,0.00,'Payment Id 390652 for invoice:257750, receipt: 6890495 by SALBAS OIL & GAS NIG. LIMITED','2022-05-13 15:56:18','',''),('5','102',4960290,'','supplier','107',0.00,9900.00,'Payment Id 390652 for invoice:257750, receipt: 6890495 by SALBAS OIL & GAS NIG. LIMITED','2022-05-13 15:56:18','',''),('5','102',4960291,'','6.1','2371',9900.00,0.00,'Payment Id 390648 for invoice:257748, receipt: 035 by SALBAS OIL & GAS NIG. LIMITED','2022-05-13 15:56:36','',''),('5','102',4960292,'','supplier','107',0.00,9900.00,'Payment Id 390648 for invoice:257748, receipt: 035 by SALBAS OIL & GAS NIG. LIMITED','2022-05-13 15:56:36','',''),('5','102',4960293,'','6.1','2371',287350.00,0.00,'Payment Id 390650 for invoice:257749, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2022-05-13 15:56:50','',''),('5','102',4960294,'','supplier','107',0.00,287350.00,'Payment Id 390650 for invoice:257749, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2022-05-13 15:56:50','',''),('5','102',4960295,'','2','3355',671570.00,0.00,'Payment Id 390651 for invoice:257750, receipt: 6890495 by SALBAS OIL & GAS NIG. LIMITED','2022-05-13 15:57:02','',''),('5','102',4960296,'','supplier','107',0.00,671570.00,'Payment Id 390651 for invoice:257750, receipt: 6890495 by SALBAS OIL & GAS NIG. LIMITED','2022-05-13 15:57:02','',''),('5','102',4960297,'','2','3355',987640.00,0.00,'Payment Id 390653 for invoice:257751, receipt: 6890495 by SALBAS OIL & GAS NIG. LIMITED','2022-05-13 15:58:28','',''),('5','102',4960298,'','supplier','107',0.00,987640.00,'Payment Id 390653 for invoice:257751, receipt: 6890495 by SALBAS OIL & GAS NIG. LIMITED','2022-05-13 15:58:28','',''),('5','102',4960299,'','6.1','2371',9900.00,0.00,'Payment Id 390654 for invoice:257751, receipt: 6890495 by SALBAS OIL & GAS NIG. LIMITED','2022-05-13 16:01:02','',''),('5','102',4960300,'','supplier','107',0.00,9900.00,'Payment Id 390654 for invoice:257751, receipt: 6890495 by SALBAS OIL & GAS NIG. LIMITED','2022-05-13 16:01:02','',''),('5','102',4960301,'','2','3355',532835.00,0.00,'Payment Id 390655 for invoice:257752, receipt: 6890495 by SALBAS OIL & GAS NIG. LIMITED','2022-05-13 16:01:26','',''),('5','102',4960302,'','supplier','107',0.00,532835.00,'Payment Id 390655 for invoice:257752, receipt: 6890495 by SALBAS OIL & GAS NIG. LIMITED','2022-05-13 16:01:26','',''),('5','102',4960303,'','6.1','2371',21600.00,0.00,'Payment Id 390656 for invoice:257752, receipt: 6890495 by SALBAS OIL & GAS NIG. LIMITED','2022-05-13 16:02:18','',''),('5','102',4960304,'','supplier','107',0.00,21600.00,'Payment Id 390656 for invoice:257752, receipt: 6890495 by SALBAS OIL & GAS NIG. LIMITED','2022-05-13 16:02:18','',''),('5','102',4960305,'','20','2383',0.00,0.00,'Sales from shift 257757 on 2022-05-14 15:33:01 ','2022-05-14 15:33:01','',''),('5','102',4960306,'','6.1','2371',0.00,0.00,'Sales from shift 257757 on 2022-05-14 15:33:01 ','2022-05-14 15:33:01','',''),('5','102',4960307,'','20','2383',0.00,0.00,'Sales from shift 257758 on 2022-05-15 13:52:07 ','2022-05-15 13:52:07','',''),('5','102',4960308,'','6.1','2371',0.00,0.00,'Sales from shift 257758 on 2022-05-15 13:52:07 ','2022-05-15 13:52:07','',''),('5','102',4960309,'','20','2383',0.00,0.00,'Sales from shift 257759 on 2022-05-16 09:40:33 ','2022-05-16 09:40:33','',''),('5','102',4960310,'','6.1','2371',0.00,0.00,'Sales from shift 257759 on 2022-05-16 09:40:33 ','2022-05-16 09:40:33','',''),('5','102',4960311,'','20','2383',0.00,0.00,'Sales from shift 257760 on 2022-05-16 10:23:46 ','2022-05-16 10:23:46','',''),('5','102',4960312,'','6.1','2371',0.00,0.00,'Sales from shift 257760 on 2022-05-16 10:23:46 ','2022-05-16 10:23:46','',''),('5','102',4960313,'','20','2383',0.00,0.00,'Sales from shift 257761 on 2022-05-17 09:29:55 ','2022-05-17 09:29:55','',''),('5','102',4960314,'','6.1','2371',0.00,0.00,'Sales from shift 257761 on 2022-05-17 09:29:55 ','2022-05-17 09:29:55','',''),('5','102',4960315,'','20','2383',0.00,0.00,'Sales from shift 257762 on 2022-05-19 12:10:59 ','2022-05-19 12:10:59','',''),('5','102',4960316,'','6.1','2371',0.00,0.00,'Sales from shift 257762 on 2022-05-19 12:10:59 ','2022-05-19 12:10:59','',''),('5','102',4960317,'','20','2383',0.00,0.00,'Sales from shift 257763 on 2022-05-20 10:09:23 ','2022-05-20 10:09:23','',''),('5','102',4960318,'','6.1','2371',0.00,0.00,'Sales from shift 257763 on 2022-05-20 10:09:23 ','2022-05-20 10:09:23','',''),('5','102',4960319,'','20','2383',0.00,0.00,'Sales from shift 257764 on 2022-05-23 13:07:22 ','2022-05-23 13:07:22','',''),('5','102',4960320,'','6.1','2371',0.00,0.00,'Sales from shift 257764 on 2022-05-23 13:07:22 ','2022-05-23 13:07:22','',''),('5','102',4960321,'','20','2383',0.00,0.00,'Sales from shift 257765 on 2022-05-23 13:18:08 ','2022-05-23 13:18:08','',''),('5','102',4960322,'','6.1','2371',0.00,0.00,'Sales from shift 257765 on 2022-05-23 13:18:08 ','2022-05-23 13:18:08','',''),('5','102',4960323,'','20','2383',0.00,0.00,'Sales from shift 257766 on 2022-05-23 13:19:36 ','2022-05-23 13:19:36','',''),('5','102',4960324,'','6.1','2371',0.00,0.00,'Sales from shift 257766 on 2022-05-23 13:19:36 ','2022-05-23 13:19:36','',''),('5','102',4960325,'','20','2383',0.00,0.00,'Sales from shift 257767 on 2022-05-23 13:33:18 ','2022-05-23 13:33:18','',''),('5','102',4960326,'','6.1','2371',0.00,0.00,'Sales from shift 257767 on 2022-05-23 13:33:18 ','2022-05-23 13:33:18','',''),('5','102',4960327,'','20','2383',0.00,0.00,'Sales from shift 257768 on 2022-05-24 11:00:27 ','2022-05-24 11:00:27','',''),('5','102',4960328,'','6.1','2371',0.00,0.00,'Sales from shift 257768 on 2022-05-24 11:00:27 ','2022-05-24 11:00:27','',''),('5','102',4960329,'','20','2383',0.00,0.00,'Sales from shift 257769 on 2022-05-25 09:31:40 ','2022-05-25 09:31:40','',''),('5','102',4960330,'','6.1','2371',0.00,0.00,'Sales from shift 257769 on 2022-05-25 09:31:40 ','2022-05-25 09:31:40','',''),('5','102',4960331,'','20','2383',0.00,0.00,'Sales from shift 257770 on 2022-05-26 10:34:53 ','2022-05-26 10:34:53','',''),('5','102',4960332,'','6.1','2371',0.00,0.00,'Sales from shift 257770 on 2022-05-26 10:34:53 ','2022-05-26 10:34:53','',''),('5','102',4960333,'','20','2383',0.00,0.00,'Sales from shift 257771 on 2022-05-26 23:16:33 ','2022-05-26 23:16:33','',''),('5','102',4960334,'','6.1','2371',0.00,0.00,'Sales from shift 257771 on 2022-05-26 23:16:33 ','2022-05-26 23:16:33','',''),('5','102',4960335,'','20','2383',0.00,0.00,'Sales from shift 257772 on 2022-05-28 22:37:31 ','2022-05-28 22:37:31','',''),('5','102',4960336,'','6.1','2371',0.00,0.00,'Sales from shift 257772 on 2022-05-28 22:37:31 ','2022-05-28 22:37:31','',''),('5','102',4960337,'','20','2383',0.00,0.00,'Sales from shift 257773 on 2022-05-30 11:11:03 ','2022-05-30 11:11:03','',''),('5','102',4960338,'','6.1','2371',0.00,0.00,'Sales from shift 257773 on 2022-05-30 11:11:03 ','2022-05-30 11:11:03','',''),('5','102',4960339,'','2','3355',739555.00,0.00,'Payment Id 390639 for invoice:257744, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2022-05-30 12:32:43','',''),('5','102',4960340,'','supplier','107',0.00,739555.00,'Payment Id 390639 for invoice:257744, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2022-05-30 12:32:43','',''),('5','102',4960341,'','6.1','2371',37100.00,0.00,'Payment Id 390640 for invoice:257744, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2022-05-30 12:32:52','',''),('5','102',4960342,'','supplier','107',0.00,37100.00,'Payment Id 390640 for invoice:257744, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2022-05-30 12:32:52','',''),('5','102',4960343,'','2','3355',653700.00,0.00,'Payment Id 390641 for invoice:257745, receipt: 6890495 by SALBAS OIL & GAS NIG. LIMITED','2022-05-30 12:33:07','',''),('5','102',4960344,'','supplier','107',0.00,653700.00,'Payment Id 390641 for invoice:257745, receipt: 6890495 by SALBAS OIL & GAS NIG. LIMITED','2022-05-30 12:33:07','',''),('5','102',4960345,'','6.1','2371',9900.00,0.00,'Payment Id 390642 for invoice:257745, receipt: 6890495 by SALBAS OIL & GAS NIG. LIMITED','2022-05-30 12:33:15','',''),('5','102',4960346,'','supplier','107',0.00,9900.00,'Payment Id 390642 for invoice:257745, receipt: 6890495 by SALBAS OIL & GAS NIG. LIMITED','2022-05-30 12:33:15','',''),('5','102',4960347,'','2','3355',628560.00,0.00,'Payment Id 390643 for invoice:257746, receipt: 6890495 by SALBAS OIL & GAS NIG. LIMITED','2022-05-30 12:33:52','',''),('5','102',4960348,'','supplier','107',0.00,628560.00,'Payment Id 390643 for invoice:257746, receipt: 6890495 by SALBAS OIL & GAS NIG. LIMITED','2022-05-30 12:33:52','',''),('5','102',4960349,'','2','3355',615110.00,0.00,'Payment Id 390645 for invoice:257747, receipt: 0278 by SALBAS OIL & GAS NIG. LIMITED','2022-05-30 12:34:03','',''),('5','102',4960350,'','supplier','107',0.00,615110.00,'Payment Id 390645 for invoice:257747, receipt: 0278 by SALBAS OIL & GAS NIG. LIMITED','2022-05-30 12:34:03','',''),('5','102',4960351,'','6.1','2371',9900.00,0.00,'Payment Id 390644 for invoice:257746, receipt: 6890495 by SALBAS OIL & GAS NIG. LIMITED','2022-05-30 12:34:25','',''),('5','102',4960352,'','supplier','107',0.00,9900.00,'Payment Id 390644 for invoice:257746, receipt: 6890495 by SALBAS OIL & GAS NIG. LIMITED','2022-05-30 12:34:25','',''),('5','102',4960353,'','6.1','2371',154900.00,0.00,'Payment Id 390646 for invoice:257747, receipt: 0278 by SALBAS OIL & GAS NIG. LIMITED','2022-05-30 12:34:47','',''),('5','102',4960354,'','supplier','107',0.00,154900.00,'Payment Id 390646 for invoice:257747, receipt: 0278 by SALBAS OIL & GAS NIG. LIMITED','2022-05-30 12:34:47','',''),('5','102',4960355,'','20','2383',0.00,0.00,'Sales from shift 257774 on 2022-05-30 13:30:38 ','2022-05-30 13:30:38','',''),('5','102',4960356,'','6.1','2371',0.00,0.00,'Sales from shift 257774 on 2022-05-30 13:30:38 ','2022-05-30 13:30:38','',''),('5','102',4960357,'','20','2383',0.00,0.00,'Sales from shift 257775 on 2022-05-31 09:45:15 ','2022-05-31 09:45:15','',''),('5','102',4960358,'','6.1','2371',0.00,0.00,'Sales from shift 257775 on 2022-05-31 09:45:15 ','2022-05-31 09:45:15','',''),('5','102',4960359,'','20','2383',0.00,0.00,'Sales from shift 257776 on 2022-06-02 10:19:23 ','2022-06-02 10:19:23','',''),('5','102',4960360,'','6.1','2371',0.00,0.00,'Sales from shift 257776 on 2022-06-02 10:19:23 ','2022-06-02 10:19:23','',''),('5','102',4960361,'','20','2383',0.00,0.00,'Sales from shift 257777 on 2022-06-03 10:00:39 ','2022-06-03 10:00:39','',''),('5','102',4960362,'','6.1','2371',0.00,0.00,'Sales from shift 257777 on 2022-06-03 10:00:39 ','2022-06-03 10:00:39','',''),('5','102',4960363,'','20','2383',0.00,0.00,'Sales from shift 257778 on 2022-06-03 10:07:06 ','2022-06-03 10:07:06','',''),('5','102',4960364,'','6.1','2371',0.00,0.00,'Sales from shift 257778 on 2022-06-03 10:07:06 ','2022-06-03 10:07:06','',''),('5','102',4960365,'','20','2383',0.00,0.00,'Sales from shift 257779 on 2022-06-04 15:21:09 ','2022-06-04 15:21:09','',''),('5','102',4960366,'','6.1','2371',0.00,0.00,'Sales from shift 257779 on 2022-06-04 15:21:09 ','2022-06-04 15:21:09','',''),('5','102',4960367,'','20','2383',0.00,0.00,'Sales from shift 257780 on 2022-06-06 08:56:54 ','2022-06-06 08:56:54','',''),('5','102',4960368,'','6.1','2371',0.00,0.00,'Sales from shift 257780 on 2022-06-06 08:56:54 ','2022-06-06 08:56:54','',''),('5','102',4960369,'','20','2383',0.00,0.00,'Sales from shift 257781 on 2022-06-06 09:11:59 ','2022-06-06 09:11:59','',''),('5','102',4960370,'','6.1','2371',0.00,0.00,'Sales from shift 257781 on 2022-06-06 09:11:59 ','2022-06-06 09:11:59','',''),('5','102',4960371,'','20','2383',0.00,0.00,'Sales from shift 257782 on 2022-06-07 12:37:46 ','2022-06-07 12:37:46','',''),('5','102',4960372,'','6.1','2371',0.00,0.00,'Sales from shift 257782 on 2022-06-07 12:37:46 ','2022-06-07 12:37:46','',''),('5','102',4960373,'','20','2383',0.00,0.00,'Sales from shift 257783 on 2022-06-08 09:45:56 ','2022-06-08 09:45:56','',''),('5','102',4960374,'','6.1','2371',0.00,0.00,'Sales from shift 257783 on 2022-06-08 09:45:56 ','2022-06-08 09:45:56','',''),('5','102',4960375,'','20','2383',0.00,0.00,'Sales from shift 257784 on 2022-06-09 19:36:12 ','2022-06-09 19:36:12','',''),('5','102',4960376,'','6.1','2371',0.00,0.00,'Sales from shift 257784 on 2022-06-09 19:36:12 ','2022-06-09 19:36:12','',''),('5','102',4960377,'','20','2383',0.00,0.00,'Sales from shift 257785 on 2022-06-12 16:25:48 ','2022-06-12 16:25:48','',''),('5','102',4960378,'','6.1','2371',0.00,0.00,'Sales from shift 257785 on 2022-06-12 16:25:48 ','2022-06-12 16:25:48','',''),('5','102',4960379,'','20','2383',0.00,0.00,'Sales from shift 257786 on 2022-06-12 16:27:14 ','2022-06-12 16:27:14','',''),('5','102',4960380,'','6.1','2371',0.00,0.00,'Sales from shift 257786 on 2022-06-12 16:27:14 ','2022-06-12 16:27:14','',''),('5','102',4960381,'','20','2383',0.00,0.00,'Sales from shift 257787 on 2022-06-12 16:30:16 ','2022-06-12 16:30:16','',''),('5','102',4960382,'','6.1','2371',0.00,0.00,'Sales from shift 257787 on 2022-06-12 16:30:16 ','2022-06-12 16:30:16','',''),('5','102',4960383,'','20','2383',0.00,0.00,'Sales from shift 257788 on 2022-06-13 21:38:34 ','2022-06-13 21:38:34','',''),('5','102',4960384,'','6.1','2371',0.00,0.00,'Sales from shift 257788 on 2022-06-13 21:38:34 ','2022-06-13 21:38:34','',''),('5','102',4960385,'','20','2383',0.00,0.00,'Sales from shift 257789 on 2022-06-14 08:57:21 ','2022-06-14 08:57:21','',''),('5','102',4960386,'','6.1','2371',0.00,0.00,'Sales from shift 257789 on 2022-06-14 08:57:21 ','2022-06-14 08:57:21','',''),('5','102',4960387,'','20','2383',0.00,0.00,'Sales from shift 257790 on 2022-06-15 12:04:40 ','2022-06-15 12:04:40','',''),('5','102',4960388,'','6.1','2371',0.00,0.00,'Sales from shift 257790 on 2022-06-15 12:04:40 ','2022-06-15 12:04:40','',''),('5','102',4960389,'','20','2383',0.00,0.00,'Sales from shift 257791 on 2022-06-16 13:44:34 ','2022-06-16 13:44:34','',''),('5','102',4960390,'','6.1','2371',0.00,0.00,'Sales from shift 257791 on 2022-06-16 13:44:34 ','2022-06-16 13:44:34','',''),('5','102',4960391,'','20','2383',0.00,0.00,'Sales from shift 257792 on 2022-06-17 19:36:26 ','2022-06-17 19:36:26','',''),('5','102',4960392,'','6.1','2371',0.00,0.00,'Sales from shift 257792 on 2022-06-17 19:36:26 ','2022-06-17 19:36:26','',''),('5','102',4960393,'','20','2383',0.00,0.00,'Sales from shift 257793 on 2022-06-18 17:59:29 ','2022-06-18 17:59:29','',''),('5','102',4960394,'','6.1','2371',0.00,0.00,'Sales from shift 257793 on 2022-06-18 17:59:29 ','2022-06-18 17:59:29','',''),('5','102',4960395,'','20','2383',0.00,0.00,'Sales from shift 257794 on 2022-06-19 14:56:19 ','2022-06-19 14:56:19','',''),('5','102',4960396,'','6.1','2371',0.00,0.00,'Sales from shift 257794 on 2022-06-19 14:56:19 ','2022-06-19 14:56:19','',''),('5','102',4960397,'','20','2383',0.00,0.00,'Sales from shift 257795 on 2022-06-20 09:18:57 ','2022-06-20 09:18:57','',''),('5','102',4960398,'','6.1','2371',0.00,0.00,'Sales from shift 257795 on 2022-06-20 09:18:57 ','2022-06-20 09:18:57','','');
/*!40000 ALTER TABLE `ledgers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products`
--

DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `measurement` varchar(20) NOT NULL,
  `quantity2` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`code`,`name`,`measurement`,`quantity2`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `cleanup` (`cleanup`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB AUTO_INCREMENT=252 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products`
--

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (249,'5','102','PMS','Petrol','Litres',1,165.00,165.00,165.00,165.00,0.00,0,'2019-02-23 19:02:59','415','415','2019-02-23 19:02:59',1),(250,'5','102','AGO','Diesel','Litres',1,345.00,345.00,345.00,345.00,0.00,0,'2019-02-23 19:03:20','415','415','2019-02-23 19:03:20',1),(251,'5','102','DPK','Kerosene','Litres',1,0.00,0.00,0.00,0.00,0.00,0,'2019-02-23 19:03:36','415','415','2019-02-23 19:03:36',1);
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_changevalues`
--

DROP TABLE IF EXISTS `products_changevalues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_changevalues` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `change_id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity` bigint NOT NULL,
  `oldrate` decimal(20,2) NOT NULL,
  `newrate` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`change_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_changevalues`
--

LOCK TABLES `products_changevalues` WRITE;
/*!40000 ALTER TABLE `products_changevalues` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_changevalues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_prices`
--

DROP TABLE IF EXISTS `products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB AUTO_INCREMENT=16767 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_prices`
--

LOCK TABLES `products_prices` WRITE;
/*!40000 ALTER TABLE `products_prices` DISABLE KEYS */;
INSERT INTO `products_prices` VALUES (14699,'5','102',250,295.00,295.00,295.00,295.00,'AGO  NEW PRICE','2021-07-25 13:24:30','600'),(14726,'5','102',250,295.00,295.00,295.00,295.00,'AGO  NEW PRICE','2021-07-29 14:40:13','600'),(16042,'5','102',250,300.00,295.00,0.00,0.00,'Cost from purchase id #78190','2021-10-13 12:47:26','600'),(16043,'5','102',249,163.00,165.00,0.00,0.00,'Cost from purchase id #78189','2021-10-13 12:48:41','600'),(16365,'5','102',250,345.00,345.00,345.00,345.00,'AGO NEW PRICE','2021-10-21 09:08:53','600'),(16766,'5','102',249,165.00,165.00,0.00,0.00,'Cost from purchase id #79783','2021-11-04 14:20:08','608');
/*!40000 ALTER TABLE `products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_reconciliations`
--

DROP TABLE IF EXISTS `products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_reconciliations`
--

LOCK TABLES `products_reconciliations` WRITE;
/*!40000 ALTER TABLE `products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_shortages`
--

DROP TABLE IF EXISTS `products_shortages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_shortages` (
  `shortage_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shortagedate` date NOT NULL,
  `product_id` varchar(10) NOT NULL,
  `type` int NOT NULL DEFAULT '0',
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`shortage_id`),
  KEY `companycode` (`company_id`,`shortagedate`,`product_id`,`rate`,`quantity`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_shortages`
--

LOCK TABLES `products_shortages` WRITE;
/*!40000 ALTER TABLE `products_shortages` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_shortages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pts_nozzles`
--

DROP TABLE IF EXISTS `pts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pts_nozzles` (
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pts_id` int NOT NULL,
  `pump` varchar(20) NOT NULL,
  `code` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `last_volume` decimal(20,2) NOT NULL,
  `last_price` decimal(20,2) NOT NULL,
  `last_amount` decimal(20,2) NOT NULL,
  `last_transaction` int NOT NULL DEFAULT '0',
  `total_volume` decimal(20,2) NOT NULL,
  `total_amount` decimal(20,2) NOT NULL,
  `total_transactions` decimal(20,2) NOT NULL,
  `lastconnect` datetime NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `terminal_id` (`pts_id`,`pump`,`code`,`lastconnect`),
  KEY `companycode` (`company_id`,`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pts_nozzles`
--

LOCK TABLES `pts_nozzles` WRITE;
/*!40000 ALTER TABLE `pts_nozzles` DISABLE KEYS */;
/*!40000 ALTER TABLE `pts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases`
--

DROP TABLE IF EXISTS `purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=88673 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases`
--

LOCK TABLES `purchases` WRITE;
/*!40000 ALTER TABLE `purchases` DISABLE KEYS */;
INSERT INTO `purchases` VALUES (78189,'5','102','2021-10-01',249,107,163.00,906.00,0.00,0.00,147678.00,0.00,'','NIL','NIL','','','','2021-10-13 09:35:07',15,'','600','','0000-00-00 00:00:00','600','2021-10-13 12:48:41'),(78190,'5','102','2021-10-01',250,107,300.00,145.00,0.00,0.00,43500.00,0.00,'','NIL','NIL','','','','2021-10-13 09:35:37',15,'','600','','0000-00-00 00:00:00','600','2021-10-13 12:47:26'),(79783,'5','102','2021-11-04',249,107,165.00,40000.00,0.00,0.00,6600000.00,0.00,'','1543','KZR 572 XA','','','','2021-11-04 14:18:37',15,'','415','','0000-00-00 00:00:00','608','2021-11-04 14:20:08'),(80614,'5','102','2021-11-13',249,107,165.00,40000.00,0.00,0.00,6600000.00,0.00,'','2015','RAN 342 XA','','','','2021-11-15 15:47:50',15,'','415','','0000-00-00 00:00:00','608','2021-11-15 15:50:24'),(88669,'5','102','2022-01-02',249,107,165.00,39250.00,0.00,0.00,6476250.00,0.00,'','1543','Kmc 140 yt','','','','2022-01-03 10:59:50',15,'','415','','0000-00-00 00:00:00','608','2022-01-04 09:07:38'),(88670,'5','102','2022-02-23',249,107,165.00,40000.00,0.00,0.00,6600000.00,0.00,'','1964','TRN 176 zG','','','','2022-02-23 18:41:25',15,'','415','','0000-00-00 00:00:00','608','2022-02-23 18:43:37'),(88671,'5','102','2022-03-27',249,107,165.00,40000.00,0.00,0.00,6600000.00,0.00,'','0113','Kmc139 yt','','','','2022-03-30 06:40:39',15,'','415','','0000-00-00 00:00:00','795','2022-03-31 10:44:56'),(88672,'5','102','2022-04-29',249,107,165.00,40000.00,0.00,0.00,6600000.00,0.00,'','1333','RAN 553 XA','','','','2022-05-10 09:51:10',15,'','415','','0000-00-00 00:00:00','795','2022-05-10 09:53:22');
/*!40000 ALTER TABLE `purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_payments`
--

DROP TABLE IF EXISTS `purchases_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `supplier_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`supplier_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=390657 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_payments`
--

LOCK TABLES `purchases_payments` WRITE;
/*!40000 ALTER TABLE `purchases_payments` DISABLE KEYS */;
INSERT INTO `purchases_payments` VALUES (361152,'5','102','2021-11-04',107,'0279','','5',243300.00,'236665','','','2384','Katsina station','0279',253477.95,'2021-11-15 13:47:16',5,'','415','','0000-00-00 00:00:00','608','2021-11-15 14:10:27'),(361158,'5','102','2021-11-04',107,'0279','','2',7675.00,'236665','','','','','',0.00,'2021-11-15 13:50:27',5,'Ago consumption=5,175\r\nUnion tanker=2500','415','600','2021-11-15 14:15:06','608','2021-11-15 14:17:37'),(361160,'5','102','2021-11-05',107,'0279','','5',1262300.00,'238455','','','2384','Katsina station','0279',1453732.50,'2021-11-15 13:53:45',5,'','415','','0000-00-00 00:00:00','608','2021-11-15 14:18:25'),(361165,'5','102','2021-11-05',107,'0279','','2',180425.00,'238455','','','','','',0.00,'2021-11-15 13:57:11',5,'Ago consumption=5,175\r\nSalary=163550\r\nMonthly exp=11,700\r\n','415','600','2021-11-15 14:15:52','608','2021-11-15 14:18:57'),(361168,'5','102','2021-11-06',107,'0279','','5',1901495.00,'238458','','','2384','Katsina station','0279',1937170.95,'2021-11-15 13:58:11',5,'','415','','0000-00-00 00:00:00','608','2021-11-15 14:23:06'),(361172,'5','102','2021-11-06',107,'0279','','2',21175.00,'238458','','','','','',0.00,'2021-11-15 14:00:37',5,'Ago consumption=5,175\r\nRepair gen=16,000\r\n','415','600','2021-11-15 14:16:45','608','2021-11-15 14:23:21'),(361173,'5','102','2021-11-07',107,'0279','','5',2233635.00,'239060','','','2384','Katsina station','0279',2244810.15,'2021-11-15 14:01:50',5,'','415','','0000-00-00 00:00:00','608','2021-11-15 14:23:43'),(361174,'5','102','2021-11-07',107,'0279','','2',5175.00,'239060','','','','Katsina station','',0.00,'2021-11-15 14:03:14',5,'Ago consumption=5,175','415','600','2021-11-15 15:51:35','608','2021-11-15 15:51:55'),(361175,'5','102','2021-11-08',107,'0279','','5',737540.00,'239187','','','2384','Katsina station','0279',752711.85,'2021-11-15 14:04:13',5,'','415','','0000-00-00 00:00:00','608','2021-11-15 14:24:45'),(361176,'5','102','2021-11-08',107,'0279','','2',11675.00,'239187','','','','','',0.00,'2021-11-15 14:06:13',5,'Ago consumption=5,175\r\nWheat and measure=5000\r\nBank trans=1500','415','600','2021-11-15 14:17:59','608','2021-11-15 14:25:32'),(361253,'5','102','2021-11-14',107,'0279','','5',984180.00,'239223','','','2384','Katsina station','0279',996355.80,'2021-11-15 16:06:31',5,'','415','','0000-00-00 00:00:00','608','2021-11-16 14:32:19'),(361259,'5','102','2021-11-14',107,'0279','','2',7675.00,'239223','','','','','',0.00,'2021-11-15 16:07:51',5,'Ago consumption=5,175\r\nUnion tanker=2500','415','','0000-00-00 00:00:00','608','2021-11-16 14:32:43'),(364071,'5','102','2021-11-15',107,'0278','','5',954440.00,'239224','','','2384','Katsina station','0278',967621.05,'2021-11-21 10:15:23',5,'','415','','0000-00-00 00:00:00','608','2021-11-22 10:33:29'),(364073,'5','102','2021-11-15',107,'0278','','2',6675.00,'239224','','','','','',0.00,'2021-11-21 10:17:24',5,'Ago consumption=5,175\r\nBank trans=1500','415','','0000-00-00 00:00:00','608','2021-11-22 10:33:47'),(364074,'5','102','2021-11-16',107,'0279','','5',738070.00,'239462','','','2384','Katsina station','0279',751743.30,'2021-11-21 10:18:38',5,'','415','','0000-00-00 00:00:00','608','2021-11-22 10:34:02'),(364075,'5','102','2021-11-16',107,'0279','','2',5175.00,'239462','','','','','',0.00,'2021-11-21 10:19:53',5,'Ago consumption=5,175','415','','0000-00-00 00:00:00','608','2021-11-22 10:34:15'),(364077,'5','102','2021-11-17',107,'0035','','5',746280.00,'239715','','','2384','Katsina station','0035',759455.40,'2021-11-21 10:21:20',5,'','415','','0000-00-00 00:00:00','608','2021-11-22 10:34:35'),(364080,'5','102','2021-11-17',107,'0035','','2',5175.00,'239715','','','','','',0.00,'2021-11-21 10:22:43',5,'Ago consumption=5,175','415','','0000-00-00 00:00:00','608','2021-11-22 10:34:52'),(364083,'5','102','2021-11-18',107,'0278','','5',205175.00,'239947','','','2384','Katsina station','0278',0.00,'2021-11-21 10:25:19',5,'Ago consumption=5,175\r\nSeptember salary=200,000','415','','0000-00-00 00:00:00','608','2021-11-22 10:35:19'),(364545,'5','102','2021-11-19',107,'0035','','5',638395.00,'240516','','','2384','Katsina station','0035',652070.10,'2021-11-22 11:07:07',5,'','415','','0000-00-00 00:00:00','608','2021-11-22 13:30:37'),(364548,'5','102','2021-11-19',107,'0035','','2',5175.00,'240516','','','','','',0.00,'2021-11-22 11:08:11',5,'Ago consumption=5,175','415','','0000-00-00 00:00:00','608','2021-11-22 13:31:00'),(364550,'5','102','2021-11-20',107,'0035','','5',591920.00,'240518','','','2384','Katsina station','0035',605097.90,'2021-11-22 11:09:28',5,'','415','','0000-00-00 00:00:00','608','2021-11-22 13:31:23'),(364551,'5','102','2021-11-20',107,'0035','','2',5175.00,'240518','','','','','',0.00,'2021-11-22 11:10:25',5,'Ago consumption=5,175','415','','0000-00-00 00:00:00','608','2021-11-22 13:31:39'),(364552,'5','102','2021-11-21',107,'0035','','5',587195.00,'240521','','','2384','Katsina station','0035',600870.60,'2021-11-22 11:11:22',5,'','415','','0000-00-00 00:00:00','608','2021-11-22 13:32:00'),(364554,'5','102','2021-11-21',107,'0035','','2',5175.00,'240521','','','','','',0.00,'2021-11-22 11:14:00',5,'Ago consumption=5,175','415','','0000-00-00 00:00:00','608','2021-11-22 13:32:13'),(364671,'5','102','2021-11-18',107,'0035','','5',470590.00,'239947','','','2384','Katsina station','0035',683763.30,'2021-11-22 13:39:23',5,'','415','','0000-00-00 00:00:00','608','2021-11-22 14:44:45'),(366540,'5','102','2021-11-22',107,'035','','5',520760.00,'241609','','','2384','Katsina station','035',538942.80,'2021-11-25 11:58:54',5,'','415','','0000-00-00 00:00:00','608','2021-11-29 14:40:15'),(366541,'5','102','2021-11-22',107,'035','','2',9675.00,'241609','','','','','',0.00,'2021-11-25 12:00:34',5,'Ago consumption=5,175\r\nBank trans=1500\r\nConsumer protection=3000','415','','0000-00-00 00:00:00','608','2021-11-29 14:40:31'),(366553,'5','102','2021-11-23',107,'035','','5',40295.00,'241612','','','2384','Katsina station','035',45637.35,'2021-11-25 12:25:29',5,'','415','','0000-00-00 00:00:00','608','2021-11-29 14:40:55'),(366555,'5','102','2021-11-23',107,'035','','2',5175.00,'241612','','','','','',45637.35,'2021-11-25 12:26:05',5,'Ago consumption=5,175','415','','0000-00-00 00:00:00','608','2021-11-29 14:41:14'),(389151,'5','102','2022-01-02',107,'0035','','5',446195.00,'250712','','','2384','Katsina station','0035',453868.80,'2022-01-07 15:04:37',5,'','415','','0000-00-00 00:00:00','608','2022-01-12 20:05:18'),(389152,'5','102','2022-01-02',107,'0035','','2',7675.00,'250712','','','','','',0.00,'2022-01-07 15:06:18',5,'Ago consumption=5,175\r\nUnion tanker=2500','415','','0000-00-00 00:00:00','608','2022-01-12 19:57:48'),(389155,'5','102','2022-01-03',107,'0035','','5',1362650.00,'251352','','','2384','Katsina station','0035',1369830.00,'2022-01-07 15:08:14',5,'','415','','0000-00-00 00:00:00','608','2022-01-12 19:58:44'),(389157,'5','102','2022-01-03',107,'0035','','2',5175.00,'251352','','','','','',0.00,'2022-01-07 15:09:05',5,'Ago consumption=5,175','415','','0000-00-00 00:00:00','608','2022-01-12 19:59:28'),(389160,'5','102','2022-01-04',107,'0035','','5',2035750.00,'251356','','','2384','Katsina station','0035',2056925.05,'2022-01-07 15:10:13',5,'','415','','0000-00-00 00:00:00','608','2022-01-12 19:59:44'),(389168,'5','102','2022-01-04',107,'0035','','2',17175.00,'251356','','','','','',0.00,'2022-01-07 15:12:17',5,'Ago consumption=5175\r\nMonthly exp=11,700\r\nBank tran=300','415','','0000-00-00 00:00:00','608','2022-01-12 20:01:23'),(390609,'5','102','2022-01-05',107,'0035','','5',1230700.00,'251364','','','2384','Katsina station','0035',1419877.80,'2022-01-10 14:04:11',5,'','415','','0000-00-00 00:00:00','608','2022-01-12 20:01:49'),(390612,'5','102','2022-01-05',107,'0035','','2',185175.00,'251364','','','','','',0.00,'2022-01-10 14:06:34',5,'Ago consumption=5175\r\nStation salary=180,000','415','','0000-00-00 00:00:00','608','2022-01-12 20:02:15'),(390614,'5','102','2022-01-06',107,'0035','','5',853380.00,'251850','','','2384','Katsina station','0035',1017558.30,'2022-01-10 14:07:31',5,'','415','','0000-00-00 00:00:00','608','2022-01-12 20:03:00'),(390616,'5','102','2022-01-06',107,'0035','','2',155175.00,'251850','','','','','',0.00,'2022-01-10 14:08:37',5,'Ago consumption=5,175\r\nHouse rent=150,000','415','','0000-00-00 00:00:00','608','2022-01-12 20:04:07'),(390620,'5','102','2022-01-07',107,'0035','','5',146450.00,'252491','','','2384','Katsina station','0035',159225.00,'2022-01-10 14:09:34',5,'','415','','0000-00-00 00:00:00','608','2022-01-12 20:04:32'),(390621,'5','102','2022-01-07',107,'0035','','2',7875.00,'252491','','','','','',0.00,'2022-01-10 14:10:54',5,'Ago consumption=5,175\r\nBank tran=2700','415','','0000-00-00 00:00:00','608','2022-01-12 20:05:01'),(390622,'5','102','2022-02-16',107,'2780','','5',131000.00,'257672','','','2384','KTN','0280',0.00,'2022-02-16 16:30:48',5,'','600','','0000-00-00 00:00:00','600','2022-02-16 16:31:00'),(390623,'5','102','2022-02-23',107,'035','','5',1228200.00,'257680','','','2384','Katsina station','035',1234429.00,'2022-03-02 08:05:44',5,'','415','','0000-00-00 00:00:00','608','2022-03-02 09:55:31'),(390624,'5','102','2022-02-23',107,'035','','2',6225.00,'257680','','','','','',0.00,'2022-03-02 08:06:54',5,'Ago consumption=6,225','415','','0000-00-00 00:00:00','608','2022-03-02 09:55:52'),(390625,'5','102','2022-02-24',107,'035','','5',2676960.00,'257681','','','2384','Katsina station','035',2725638.30,'2022-03-02 08:08:38',5,'','415','','0000-00-00 00:00:00','608','2022-03-02 09:56:16'),(390626,'5','102','2022-02-24',107,'035','','2',22225.00,'257681','','','','','',0.00,'2022-03-02 08:10:32',5,'Ago consumption=6,225\r\nBank trn=1500\r\nUnion tnaker=2500\r\nService gen=12000','415','','0000-00-00 00:00:00','608','2022-03-02 09:56:40'),(390627,'5','102','2022-02-25',107,'035','','5',1606250.00,'257682','','','2384','Katsina station','035',1844427.40,'2022-03-02 08:11:32',5,'','415','','0000-00-00 00:00:00','608','2022-03-02 09:57:08'),(390628,'5','102','2022-02-25',107,'035','','2',217925.00,'257682','','','','Katsina station','',0.00,'2022-03-02 08:14:43',5,'Ago consumption=6,225\r\nMonthly exp=11,700\r\nJan salary=200,000','415','','0000-00-00 00:00:00','608','2022-03-02 09:57:34'),(390629,'5','102','2022-02-26',107,'035','','5',729550.00,'257683','','','2384','Katsina station','035',827237.40,'2022-03-02 08:15:51',5,'','415','','0000-00-00 00:00:00','608','2022-03-02 09:57:57'),(390630,'5','102','2022-02-26',107,'035','','2',77725.00,'257683','','','','Katsina station','',0.00,'2022-03-02 08:17:36',5,'Ago consumption=6,225\r\nNovember salary=70,000\r\nBank trans=1500','415','','0000-00-00 00:00:00','608','2022-03-02 09:58:15'),(390631,'5','102','2022-03-27',107,'6890495','','5',852700.00,'257712','','','3355','Katsina station','6890495',864799.65,'2022-03-31 15:31:34',5,'','415','','0000-00-00 00:00:00','795','2022-03-31 15:46:46'),(390632,'5','102','2022-03-27',107,'6890495','','2',12100.00,'257712','','','','','',0.00,'2022-03-31 15:32:36',5,'Ago consumption=9,600\r\nUnion tanker=2500','415','','0000-00-00 00:00:00','795','2022-03-31 15:53:57'),(390633,'5','102','2022-03-28',107,'0278','','5',2706660.00,'257713','','','3355','Katsina station','0278',2769721.35,'2022-03-31 15:36:12',5,'','415','','0000-00-00 00:00:00','795','2022-03-31 15:49:19'),(390634,'5','102','2022-03-28',107,'0278','','2',56300.00,'257713','','','','','',0.00,'2022-03-31 15:37:58',5,'Ago consumption=9,600\r\nMonthly expenses=11,700\r\nReffing fire extinguisher=35000','415','','0000-00-00 00:00:00','795','2022-03-31 15:55:03'),(390635,'5','102','2022-03-29',107,'0278','','5',1148950.00,'257714','','','3355','Katsina station','0278',1387942.05,'2022-03-31 15:39:14',5,'','415','','0000-00-00 00:00:00','795','2022-03-31 15:50:09'),(390636,'5','102','2022-03-29',107,'0278','','2',211100.00,'257714','','','','','',0.00,'2022-03-31 15:40:26',5,'Ago consumption=9,600\r\nBank trans=1500\r\nFebruary salary=200,000','415','','0000-00-00 00:00:00','795','2022-03-31 15:54:44'),(390637,'5','102','2022-03-30',107,'0278','','5',1211470.00,'257715','','','3355','Katsina station','0278',1221404.25,'2022-03-31 15:41:18',5,'','415','','0000-00-00 00:00:00','795','2022-03-31 15:50:39'),(390638,'5','102','2022-03-30',107,'0278','','2',9600.00,'257715','','','','','',0.00,'2022-03-31 15:41:56',5,'Ago consumption=9,600','415','','0000-00-00 00:00:00','795','2022-03-31 15:54:27'),(390639,'5','102','2022-04-29',107,'0035','','5',739555.00,'257744','','','3355','Katsina station','0035',776656.65,'2022-05-10 17:15:37',5,'','415','','0000-00-00 00:00:00','795','2022-05-30 12:32:43'),(390640,'5','102','2022-04-29',107,'0035','','2',37100.00,'257744','','','','','',0.00,'2022-05-10 17:19:36',5,'Ago consumption=9900\r\nMonthly exp=11,700\r\nGen service=13000\r\nUnion tanker=2500','415','','0000-00-00 00:00:00','795','2022-05-30 12:32:52'),(390641,'5','102','2022-04-30',107,'6890495','','5',653700.00,'257745','','','3355','Katsina station','6890495',663600.30,'2022-05-10 17:20:59',5,'','415','','0000-00-00 00:00:00','795','2022-05-30 12:33:07'),(390642,'5','102','2022-04-30',107,'6890495','','2',9900.00,'257745','','','','','',0.00,'2022-05-10 17:22:09',5,'Ago consumption=9900','415','','0000-00-00 00:00:00','795','2022-05-30 12:33:15'),(390643,'5','102','2022-05-01',107,'6890495','','5',628560.00,'257746','','','3355','Katsina station','6890495',695867.05,'2022-05-10 17:23:29',5,'','415','','0000-00-00 00:00:00','795','2022-05-30 12:33:52'),(390644,'5','102','2022-05-01',107,'6890495','','2',9900.00,'257746','','','','Katsina station','',0.00,'2022-05-10 17:24:50',5,'Ago consumption=9900','415','','0000-00-00 00:00:00','795','2022-05-30 12:34:25'),(390645,'5','102','2022-05-02',107,'0278','','5',615110.00,'257747','','','3355','Katsina station','0278',770017.05,'2022-05-10 17:26:19',5,'','415','','0000-00-00 00:00:00','795','2022-05-30 12:34:03'),(390646,'5','102','2022-05-02',107,'0278','','2',154900.00,'257747','','','','','',0.00,'2022-05-10 17:27:41',5,'Ago consumption=9900\r\nSalary=145,000','415','','0000-00-00 00:00:00','795','2022-05-30 12:34:47'),(390647,'5','102','2022-05-03',107,'035','','5',683360.00,'257748','','','3355','Katsina station','035',693264.00,'2022-05-10 17:29:12',5,'','415','','0000-00-00 00:00:00','795','2022-05-13 15:55:56'),(390648,'5','102','2022-05-03',107,'035','','2',9900.00,'257748','','','','','',0.00,'2022-05-10 17:30:06',5,'Ago consumption=9900','415','','0000-00-00 00:00:00','795','2022-05-13 15:56:36'),(390649,'5','102','2022-05-04',107,'0035','','5',430575.00,'257749','','','3355','Katsina station','0035',727928.85,'2022-05-10 17:31:25',5,'','415','','0000-00-00 00:00:00','795','2022-05-13 15:56:05'),(390650,'5','102','2022-05-04',107,'0035','','2',287350.00,'257749','','','','','',0.00,'2022-05-10 17:33:57',5,'Ago consumption=9900\r\nBank trans=1500\r\nMarch salary=200000\r\nRepair station light=75,950','415','','0000-00-00 00:00:00','795','2022-05-13 15:56:50'),(390651,'5','102','2022-05-05',107,'6890495','','5',671570.00,'257750','','','3355','Katsina station','6890495',689470.65,'2022-05-10 17:35:06',5,'','415','','0000-00-00 00:00:00','795','2022-05-13 15:57:02'),(390652,'5','102','2022-05-05',107,'6890495','','2',9900.00,'257750','','','','','',0.00,'2022-05-10 17:35:55',5,'Ago consumption=9900','415','','0000-00-00 00:00:00','795','2022-05-13 15:56:18'),(390653,'5','102','2022-05-06',107,'6890495','','5',987640.00,'257751','','','3355','Katsina station','6890495',1032546.90,'2022-05-10 17:37:26',5,'','415','','0000-00-00 00:00:00','795','2022-05-13 15:58:28'),(390654,'5','102','2022-05-06',107,'6890495','','2',9900.00,'257751','','','','','',0.00,'2022-05-10 17:38:13',5,'Ago consumption=9900','415','','0000-00-00 00:00:00','795','2022-05-13 16:01:02'),(390655,'5','102','2022-05-07',107,'6890495','','5',532835.00,'257752','','','3355','Katsina station','6890495',554436.30,'2022-05-10 17:39:21',5,'','415','','0000-00-00 00:00:00','795','2022-05-13 16:01:26'),(390656,'5','102','2022-05-07',107,'6890495','','2',21600.00,'257752','','','','','',0.00,'2022-05-10 17:40:35',5,'Ago consumption=9900\r\nMonthly exp=11,700','415','','0000-00-00 00:00:00','795','2022-05-13 16:02:18');
/*!40000 ALTER TABLE `purchases_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_receptions`
--

DROP TABLE IF EXISTS `purchases_receptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_receptions` (
  `bridge_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `purchase_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `loadingdate` datetime NOT NULL,
  `loadingpoint` varchar(100) DEFAULT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `received` decimal(20,2) NOT NULL,
  `distributed` decimal(20,2) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `vessel` varchar(50) NOT NULL,
  `drivername` varchar(30) NOT NULL,
  `driverphone` varchar(30) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`bridge_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`supplier_id`,`loadingdate`,`quantity`,`waybill`,`meterno`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`purchase_id`),
  KEY `truck_id` (`tank_id`)
) ENGINE=InnoDB AUTO_INCREMENT=129666 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_receptions`
--

LOCK TABLES `purchases_receptions` WRITE;
/*!40000 ALTER TABLE `purchases_receptions` DISABLE KEYS */;
INSERT INTO `purchases_receptions` VALUES (112211,'5',73232,'102',249,107,'2021-07-26 00:00:00','AA RANO DEPOT',2074.00,2074.00,0.00,'NIL','','631','NSR 236 ZQ','XYZ','0908','PMS RECIEVED',5,'2021-07-26 12:04:13','600','0000-00-00 00:00:00','','2021-07-26 12:05:20','600'),(112212,'5',73232,'102',249,107,'2021-07-26 00:00:00','AA RANO DEPOT',716.00,716.00,0.00,'NIL','','632','NSR 236 ZQ','XYZ','0908','PMS RECIEVED',5,'2021-07-26 12:04:13','600','0000-00-00 00:00:00','','2021-07-26 12:05:20','600'),(112213,'5',73231,'102',250,107,'2021-07-26 00:00:00','AA RANO DEPOT',145.00,145.00,0.00,'NIL','','633','lsd 762 xy','XYZ','0908','AGO RECIEVED',5,'2021-07-26 12:05:06','600','0000-00-00 00:00:00','','2021-07-26 12:05:34','600'),(112302,'5',73273,'102',249,107,'2021-07-27 00:00:00','AA RANO',26500.00,26500.00,0.00,'123','','631','TRN 176 ZG','ISYAKU','07080270803','PMS SUPPLIER',5,'2021-07-27 09:06:05','415','0000-00-00 00:00:00','','2021-07-27 09:08:38','600'),(112303,'5',73273,'102',249,107,'2021-07-27 00:00:00','AA RANO',13500.00,13500.00,0.00,'123','','632','TRN 176 ZG','ISYAKU','07080270803','PMS SUPPLIER',5,'2021-07-27 09:06:05','415','0000-00-00 00:00:00','','2021-07-27 09:08:06','600'),(114245,'5',74491,'102',249,107,'2021-08-14 00:00:00','A A RANO',27000.00,27000.00,0.00,'689738','','631','NSR 34 ZU','Babale','07080270803','Pms',5,'2021-08-14 13:41:57','415','0000-00-00 00:00:00','','2021-08-14 16:40:29','600'),(114246,'5',74491,'102',249,107,'2021-08-14 00:00:00','A A RANO',13000.00,13000.00,0.00,'689738','','632','NSR 34 ZU','Babale','07080270803','Pms',5,'2021-08-14 13:41:57','415','0000-00-00 00:00:00','','2021-08-14 16:41:13','600'),(120714,'5',78190,'102',250,107,'2021-10-18 00:00:00','AA RANO DEPOT',145.00,145.00,0.00,'NIL','','633','NIL','NIL','0802','AGO RECIEVED',5,'2021-10-18 08:27:08','600','0000-00-00 00:00:00','','2021-11-11 13:35:12','600'),(120733,'5',78189,'102',249,107,'2021-10-18 00:00:00','AA RANO DEPOT',190.00,190.00,0.00,'NIL','','631','NIL','NIL','0802','PMS RECIEVED',5,'2021-10-18 09:50:19','600','0000-00-00 00:00:00','','2021-10-18 09:50:32','600'),(120734,'5',78189,'102',249,107,'2021-10-18 00:00:00','AA RANO DEPOT',716.00,716.00,0.00,'NIL','','632','NIL','NIL','0802','PMS RECIEVED',5,'2021-10-18 09:50:19','600','0000-00-00 00:00:00','','2021-10-18 09:50:32','600'),(122656,'5',79783,'102',249,107,'2021-11-04 00:00:00','A A RANO',26500.00,26500.00,0.00,'1543','','631','KZR 572 XA','Ibrahim lanxai','07041778808','Pms',5,'2021-11-04 14:23:30','415','0000-00-00 00:00:00','','2021-11-11 13:34:33','600'),(122657,'5',79783,'102',249,107,'2021-11-04 00:00:00','A A RANO',13500.00,13500.00,0.00,'1543','','632','KZR 572 XA','Ibrahim lanxai','07041778808','Pms',5,'2021-11-04 14:23:30','415','0000-00-00 00:00:00','','2021-11-11 13:34:45','600'),(123981,'5',80614,'102',249,107,'2021-11-15 00:00:00','A A RANO',26500.00,26500.00,0.00,'2015','','631','RAN 342 XA','Shamsu barkum','07041778808','Pms',5,'2021-11-15 15:54:45','415','0000-00-00 00:00:00','','2021-11-15 15:58:00','600'),(123982,'5',80614,'102',249,107,'2021-11-15 00:00:00','A A RANO',13500.00,13500.00,0.00,'2015','','632','RAN 342 XA','Shamsu barkum','07041778808','Pms',5,'2021-11-15 15:54:45','415','0000-00-00 00:00:00','','2021-11-15 15:58:00','600'),(129658,'5',88669,'102',249,107,'2022-01-04 00:00:00','Salbas',25800.00,25800.00,0.00,'1543','','631','Kmc 140 yt','Yahaya','08061107129','Pms',5,'2022-01-04 09:24:53','415','0000-00-00 00:00:00','','2022-01-04 09:49:25','600'),(129659,'5',88669,'102',249,107,'2022-01-04 00:00:00','Salbas',13450.00,13450.00,0.00,'1543','','632','Kmc 140 yt','Yahaya','08061107129','Pms',5,'2022-01-04 09:24:53','415','0000-00-00 00:00:00','','2022-01-04 09:49:36','600'),(129660,'5',88670,'102',249,107,'2022-02-23 00:00:00','Salbas',26500.00,26500.00,0.00,'1964','','631','TRN 176 zG','Dan bauchi','07080270803','Pms',5,'2022-02-23 18:46:50','415','0000-00-00 00:00:00','','2022-02-23 20:54:06','600'),(129661,'5',88670,'102',249,107,'2022-02-23 00:00:00','Salbas',13500.00,13500.00,0.00,'1964','','632','TRN 176 zG','Dan bauchi','07080270803','Pms',5,'2022-02-23 18:46:50','415','0000-00-00 00:00:00','','2022-02-23 20:53:29','600'),(129662,'5',88671,'102',249,107,'2022-03-31 00:00:00','Salbas',26500.00,26500.00,0.00,'0113','','631','Kmc139 yt','Danxabarmawa','09061879605','Pms',5,'2022-03-31 15:01:39','415','0000-00-00 00:00:00','','2022-03-31 15:03:30','600'),(129663,'5',88671,'102',249,107,'2022-03-31 00:00:00','Salbas',13500.00,13500.00,0.00,'0113','','632','Kmc139 yt','Danxabarmawa','09061879605','Pms',5,'2022-03-31 15:01:39','415','0000-00-00 00:00:00','','2022-03-31 15:03:19','600'),(129664,'5',88672,'102',249,107,'2022-05-10 00:00:00','Salbas',27000.00,27000.00,0.00,'1333','','631','RAN 553 XA','Umar','07041778808','Pms',5,'2022-05-10 10:32:56','415','0000-00-00 00:00:00','','2022-05-10 11:10:29','600'),(129665,'5',88672,'102',249,107,'2022-05-10 00:00:00','Salbas',13000.00,13000.00,0.00,'1333','','632','RAN 553 XA','Umar','07041778808','Pms',5,'2022-05-10 10:32:56','415','0000-00-00 00:00:00','','2022-05-10 11:10:18','600');
/*!40000 ALTER TABLE `purchases_receptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports`
--

DROP TABLE IF EXISTS `reports`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  `type` varchar(20) NOT NULL,
  `sql` text NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`report_id`),
  KEY `companycode` (`company_id`,`name`,`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports`
--

LOCK TABLES `reports` WRITE;
/*!40000 ALTER TABLE `reports` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_fields`
--

DROP TABLE IF EXISTS `reports_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(20) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `fieldname` varchar(50) NOT NULL,
  `order` int NOT NULL,
  `visibility` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`report_id`,`field_id`,`order`,`visibility`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_fields`
--

LOCK TABLES `reports_fields` WRITE;
/*!40000 ALTER TABLE `reports_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_filters`
--

DROP TABLE IF EXISTS `reports_filters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_filters` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(50) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `filter_id` int NOT NULL AUTO_INCREMENT,
  `criteria` varchar(20) NOT NULL,
  `value` varchar(100) NOT NULL,
  PRIMARY KEY (`filter_id`),
  KEY `companycode` (`company_id`,`report_id`),
  KEY `field_id` (`field_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_filters`
--

LOCK TABLES `reports_filters` WRITE;
/*!40000 ALTER TABLE `reports_filters` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_filters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_customers`
--

DROP TABLE IF EXISTS `retail_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_customers` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(100) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`name`,`phone`,`email`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_customers`
--

LOCK TABLES `retail_customers` WRITE;
/*!40000 ALTER TABLE `retail_customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory`
--

DROP TABLE IF EXISTS `retail_inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` int NOT NULL,
  `qtyout` int NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory`
--

LOCK TABLES `retail_inventory` WRITE;
/*!40000 ALTER TABLE `retail_inventory` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_balances`
--

DROP TABLE IF EXISTS `retail_inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_balances`
--

LOCK TABLES `retail_inventory_balances` WRITE;
/*!40000 ALTER TABLE `retail_inventory_balances` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_costs`
--

DROP TABLE IF EXISTS `retail_inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_costs`
--

LOCK TABLES `retail_inventory_costs` WRITE;
/*!40000 ALTER TABLE `retail_inventory_costs` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products`
--

DROP TABLE IF EXISTS `retail_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`name`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `parent_id` (`parent_id`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products`
--

LOCK TABLES `retail_products` WRITE;
/*!40000 ALTER TABLE `retail_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_prices`
--

DROP TABLE IF EXISTS `retail_products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_prices`
--

LOCK TABLES `retail_products_prices` WRITE;
/*!40000 ALTER TABLE `retail_products_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_purchases`
--

DROP TABLE IF EXISTS `retail_purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_purchases`
--

LOCK TABLES `retail_purchases` WRITE;
/*!40000 ALTER TABLE `retail_purchases` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales`
--

DROP TABLE IF EXISTS `retail_sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `saledate` date NOT NULL,
  `customer_id` varchar(20) NOT NULL DEFAULT '',
  `customer_name` varchar(50) NOT NULL,
  `customer_phone` varchar(30) NOT NULL,
  `quantity_kg` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `payment_method` varchar(10) NOT NULL,
  `payment_account_type` varchar(20) NOT NULL,
  `payment_account_id` varchar(20) NOT NULL,
  `paid` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`customer_name`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `payment_method` (`payment_method`,`payment_account_type`,`payment_account_id`),
  KEY `customer_id` (`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales`
--

LOCK TABLES `retail_sales` WRITE;
/*!40000 ALTER TABLE `retail_sales` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_items`
--

DROP TABLE IF EXISTS `retail_sales_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `product_type` varchar(10) NOT NULL,
  `product_name` varchar(100) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `quantity_2` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `parent_cost` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`sale_id`,`product_id`,`rate`,`quantity`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`product_type`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_items`
--

LOCK TABLES `retail_sales_items` WRITE;
/*!40000 ALTER TABLE `retail_sales_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales`
--

DROP TABLE IF EXISTS `sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `is_credit` int NOT NULL DEFAULT '0',
  `saledate` date NOT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `paid` int NOT NULL,
  `details` text NOT NULL,
  `ledger_notes` varchar(150) DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`product_id`,`customer_id`,`rate`,`quantity`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`is_credit`)
) ENGINE=InnoDB AUTO_INCREMENT=345134 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales`
--

LOCK TABLES `sales` WRITE;
/*!40000 ALTER TABLE `sales` DISABLE KEYS */;
INSERT INTO `sales` VALUES (331891,'5','102','236665',1,'2021-11-11',249,2992,163.00,165.00,15.15,0.00,0.00,2499.75,'1636666769','2021-11-11 21:39:29',15,0,'',NULL,'415','','0000-00-00 00:00:00','608','2021-11-12 09:52:47'),(331972,'5','102','238455',1,'2021-11-12',249,2992,165.00,165.00,66.66,0.00,0.00,10998.90,'1636710974','2021-11-12 09:56:14',15,0,'',NULL,'415','','0000-00-00 00:00:00','608','2021-11-12 09:58:29'),(331973,'5','102','238458',1,'2021-11-12',249,2992,165.00,165.00,87.87,0.00,0.00,14498.55,'1636711263','2021-11-12 10:01:03',15,0,'',NULL,'415','','0000-00-00 00:00:00','608','2021-11-12 10:04:33'),(331974,'5','102','238464',1,'2021-11-12',249,2992,165.00,165.00,36.36,0.00,0.00,5999.40,'1636711735','2021-11-12 10:08:55',15,0,'',NULL,'415','','0000-00-00 00:00:00','608','2021-11-12 10:10:31'),(331975,'5','102','238468',1,'2021-11-12',249,2992,165.00,165.00,18.18,0.00,0.00,2999.70,'1636712108','2021-11-12 10:15:08',15,0,'',NULL,'415','','0000-00-00 00:00:00','608','2021-11-14 19:32:02'),(332818,'5','102','239223',1,'2021-11-15',249,2992,165.00,165.00,27.27,0.00,0.00,4499.55,'1636992039','2021-11-15 16:00:39',15,0,'',NULL,'415','','0000-00-00 00:00:00','608','2021-11-15 16:02:34'),(332875,'5','102','239224',1,'2021-11-16',249,2992,165.00,165.00,39.39,0.00,0.00,6499.35,'1637046196','2021-11-16 07:03:16',15,0,'',NULL,'415','','0000-00-00 00:00:00','608','2021-11-16 14:31:31'),(333066,'5','102','239462',1,'2021-11-16',249,2992,165.00,165.00,51.51,0.00,0.00,8499.15,'1637085227','2021-11-16 17:53:47',15,0,'',NULL,'415','','0000-00-00 00:00:00','608','2021-11-17 18:54:43'),(333343,'5','102','239715',1,'2021-11-17',249,2992,165.00,165.00,48.48,0.00,0.00,7999.20,'1637176763','2021-11-17 19:19:23',15,0,'',NULL,'415','','0000-00-00 00:00:00','608','2021-11-18 19:30:52'),(333710,'5','102','239947',1,'2021-11-18',249,2992,165.00,165.00,48.48,0.00,0.00,7999.20,'1637264405','2021-11-18 19:40:05',15,0,'',NULL,'415','','0000-00-00 00:00:00','608','2021-11-19 21:56:38'),(334094,'5','102','240516',1,'2021-11-21',249,2992,165.00,165.00,51.51,0.00,0.00,8499.15,'1637489075','2021-11-21 10:04:35',15,0,'',NULL,'415','','0000-00-00 00:00:00','608','2021-11-21 10:05:54'),(334095,'5','102','240518',1,'2021-11-21',249,2992,165.00,165.00,48.48,0.00,0.00,7999.20,'1637489353','2021-11-21 10:09:13',15,0,'',NULL,'415','','0000-00-00 00:00:00','608','2021-11-21 10:13:12'),(334183,'5','102','240521',1,'2021-11-22',249,2992,165.00,165.00,51.51,0.00,0.00,8499.15,'1637560208','2021-11-22 05:50:08',15,0,'',NULL,'415','','0000-00-00 00:00:00','608','2021-11-22 10:32:35'),(335192,'5','102','241609',1,'2021-11-25',249,2992,165.00,165.00,48.48,0.00,0.00,7999.20,'1637841171','2021-11-25 11:52:51',15,0,'',NULL,'415','','0000-00-00 00:00:00','608','2021-11-25 12:23:17'),(344130,'5','102','251352',1,'2022-01-05',249,2992,165.00,165.00,12.12,0.00,0.00,1999.80,'1641376665','2022-01-05 10:57:45',15,0,'',NULL,'415','','0000-00-00 00:00:00','608','2022-01-05 10:58:46'),(344328,'5','102','251364',1,'2022-01-06',249,2992,165.00,165.00,24.24,0.00,0.00,3999.60,'1641454558','2022-01-06 08:35:58',15,0,'',NULL,'415','','0000-00-00 00:00:00','608','2022-01-06 18:17:16'),(344580,'5','102','251850',1,'2022-01-07',249,2992,165.00,165.00,54.54,0.00,0.00,8999.10,'1641552663','2022-01-07 11:51:03',15,0,'',NULL,'415','','0000-00-00 00:00:00','608','2022-01-07 12:35:37'),(345123,'5','102','252491',1,'2022-01-10',249,2992,165.00,165.00,30.30,0.00,0.00,4999.50,'1641797156','2022-01-10 07:45:56',15,0,'',NULL,'415','','0000-00-00 00:00:00','608','2022-01-12 19:52:23'),(345124,'5','102','257681',1,'2022-02-24',249,2992,165.00,165.00,172.42,0.00,0.00,28449.30,'1645736808','2022-02-24 22:06:48',15,0,'Pms',NULL,'415','','0000-00-00 00:00:00','608','2022-02-25 23:20:10'),(345125,'5','102','257682',1,'2022-02-26',249,2992,165.00,165.00,122.72,0.00,0.00,20248.80,'1645873521','2022-02-26 12:05:21',15,0,'',NULL,'415','','0000-00-00 00:00:00','608','2022-02-26 22:33:15'),(345126,'5','102','257683',1,'2022-02-27',249,2992,165.00,165.00,121.21,0.00,0.00,19999.65,'1645952133','2022-02-27 09:55:33',15,0,'',NULL,'415','','0000-00-00 00:00:00','608','2022-02-27 09:57:40'),(345127,'5','102','257713',1,'2022-03-31',249,2992,165.00,165.00,40.96,0.00,0.00,6758.40,'1648736277','2022-03-31 15:17:57',15,0,'',NULL,'415','','0000-00-00 00:00:00','795','2022-03-31 15:19:21'),(345128,'5','102','257714',1,'2022-03-31',249,2992,165.00,165.00,169.00,0.00,0.00,27885.00,'1648736687','2022-03-31 15:24:47',15,0,'',NULL,'415','','0000-00-00 00:00:00','795','2022-03-31 15:25:33'),(345129,'5','102','257716',1,'2022-04-01',249,2992,165.00,165.00,75.75,0.00,0.00,12498.75,'1648795474','2022-04-01 07:44:34',15,0,'',NULL,'415','','0000-00-00 00:00:00','795','2022-04-04 09:45:07'),(345130,'5','102','257746',1,'2022-05-10',249,2992,165.00,165.00,347.87,0.00,0.00,57398.55,'1652178769','2022-05-10 11:32:49',15,0,'',NULL,'415','','0000-00-00 00:00:00','795','2022-05-10 11:35:21'),(345131,'5','102','257749',1,'2022-05-10',249,2992,165.00,165.00,60.60,0.00,0.00,9999.00,'1652179652','2022-05-10 11:47:32',15,0,'',NULL,'415','','0000-00-00 00:00:00','795','2022-05-10 11:48:30'),(345132,'5','102','257750',1,'2022-05-10',249,2992,165.00,165.00,48.48,0.00,0.00,7999.20,'1652179791','2022-05-10 11:49:51',15,0,'',NULL,'415','','0000-00-00 00:00:00','795','2022-05-10 11:50:28'),(345133,'5','102','257751',1,'2022-05-10',249,2992,165.00,165.00,212.12,0.00,0.00,34999.80,'1652179926','2022-05-10 11:52:06',15,0,'',NULL,'415','','0000-00-00 00:00:00','795','2022-05-10 11:53:14');
/*!40000 ALTER TABLE `sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_daily`
--

DROP TABLE IF EXISTS `sales_daily`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_daily` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `saledate` date NOT NULL,
  `average` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `target` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`average`,`saledate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_daily`
--

LOCK TABLES `sales_daily` WRITE;
/*!40000 ALTER TABLE `sales_daily` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_daily` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions`
--

DROP TABLE IF EXISTS `sales_distributions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions` (
  `distribution_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `sale_id` int NOT NULL,
  `purchase_id` varchar(20) NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `loadingdate` date NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `destination` varchar(50) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `truckno` varchar(20) NOT NULL,
  `drivername` varchar(50) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`distribution_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`loadingdate`,`quantity`,`destination`,`waybill`,`meterno`,`nozzle_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`tank_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `truckno` (`truckno`),
  KEY `purchase_id_2` (`purchase_id`)
) ENGINE=InnoDB AUTO_INCREMENT=265284 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions`
--

LOCK TABLES `sales_distributions` WRITE;
/*!40000 ALTER TABLE `sales_distributions` DISABLE KEYS */;
INSERT INTO `sales_distributions` VALUES (254233,'5',331891,'',0,'102',249,2992,'2021-11-12',15.15,'','','','631','1756','','','Dispensed on shift # 236665',5,'2021-11-12 09:52:47','608','0000-00-00 00:00:00','','2021-11-12 09:52:47','608'),(254234,'5',331972,'',0,'102',249,2992,'2021-11-12',66.66,'','','','631','1756','','','Dispensed on shift # 238455',5,'2021-11-12 09:58:29','608','0000-00-00 00:00:00','','2021-11-12 09:58:29','608'),(254235,'5',331973,'',0,'102',249,2992,'2021-11-12',87.87,'','','','631','1756','','','Dispensed on shift # 238458',5,'2021-11-12 10:04:33','608','0000-00-00 00:00:00','','2021-11-12 10:04:33','608'),(254236,'5',331974,'',0,'102',249,2992,'2021-11-12',36.36,'','','','','','','','Dispensed on shift # 238464',5,'2021-11-12 10:10:31','608','0000-00-00 00:00:00','','2021-11-12 10:10:31','608'),(254647,'5',331975,'',0,'102',249,2992,'2021-11-14',18.18,'','','','','','','','Dispensed on shift # 238468',5,'2021-11-14 19:32:02','608','0000-00-00 00:00:00','','2021-11-14 19:32:02','608'),(254756,'5',332818,'',0,'102',249,2992,'2021-11-15',27.27,'','','','632','1754','','','Dispensed on shift # 239223',5,'2021-11-15 16:02:34','608','0000-00-00 00:00:00','','2021-11-15 16:02:34','608'),(254912,'5',332875,'',0,'102',249,2992,'2021-11-16',39.39,'','','','632','1754','','','Dispensed on shift # 239224',5,'2021-11-16 14:31:31','608','0000-00-00 00:00:00','','2021-11-16 14:31:31','608'),(255162,'5',333066,'',0,'102',249,2992,'2021-11-17',51.51,'','','','632','1754','','','Dispensed on shift # 239462',5,'2021-11-17 18:54:43','608','0000-00-00 00:00:00','','2021-11-17 18:54:43','608'),(255357,'5',333343,'',0,'102',249,2992,'2021-11-18',48.48,'','','','631','1756','','','Dispensed on shift # 239715',5,'2021-11-18 19:30:52','608','0000-00-00 00:00:00','','2021-11-18 19:30:52','608'),(255525,'5',333710,'',0,'102',249,2992,'2021-11-19',48.48,'','','','632','1754','','','Dispensed on shift # 239947',5,'2021-11-19 21:56:38','608','0000-00-00 00:00:00','','2021-11-19 21:56:38','608'),(255699,'5',334094,'',0,'102',249,2992,'2021-11-21',51.51,'','','','631','1756','','','Dispensed on shift # 240516',5,'2021-11-21 10:05:54','608','0000-00-00 00:00:00','','2021-11-21 10:05:54','608'),(255700,'5',334095,'',0,'102',249,2992,'2021-11-21',48.48,'','','','631','1756','','','Dispensed on shift # 240518',5,'2021-11-21 10:13:12','608','0000-00-00 00:00:00','','2021-11-21 10:13:12','608'),(255823,'5',334183,'',0,'102',249,2992,'2021-11-22',51.51,'','','','631','1756','','','Dispensed on shift # 240521',5,'2021-11-22 10:32:35','608','0000-00-00 00:00:00','','2021-11-22 10:32:35','608'),(256662,'5',335192,'',0,'102',249,2992,'2021-11-25',48.48,'','','','631','1756','','','Dispensed on shift # 241609',5,'2021-11-25 12:23:17','608','0000-00-00 00:00:00','','2021-11-25 12:23:17','608'),(263895,'5',344130,'',0,'102',249,2992,'2022-01-05',12.12,'','','','632','1754','','','Dispensed on shift # 251352',5,'2022-01-05 10:58:46','608','0000-00-00 00:00:00','','2022-01-05 10:58:46','608'),(264186,'5',344328,'',0,'102',249,2992,'2022-01-06',24.24,'','','','631','1756','','','Dispensed on shift # 251364',5,'2022-01-06 18:17:16','608','0000-00-00 00:00:00','','2022-01-06 18:17:16','608'),(264307,'5',344580,'',0,'102',249,2992,'2022-01-07',54.54,'','','','631','1756','','','Dispensed on shift # 251850',5,'2022-01-07 12:35:37','608','0000-00-00 00:00:00','','2022-01-07 12:35:37','608'),(265273,'5',345123,'',0,'102',249,2992,'2022-01-12',30.30,'','','','631','1756','','','Dispensed on shift # 252491',5,'2022-01-12 19:52:23','608','0000-00-00 00:00:00','','2022-01-12 19:52:23','608'),(265274,'5',345124,'',0,'102',249,2992,'2022-02-25',172.42,'','','','631','1756','','','Dispensed on shift # 257681',5,'2022-02-25 23:20:10','608','0000-00-00 00:00:00','','2022-02-25 23:20:10','608'),(265275,'5',345125,'',0,'102',249,2992,'2022-02-26',122.72,'','','','631','1756','','','Dispensed on shift # 257682',5,'2022-02-26 22:33:15','608','0000-00-00 00:00:00','','2022-02-26 22:33:15','608'),(265276,'5',345126,'',0,'102',249,2992,'2022-02-27',121.21,'','','','631','1756','','','Dispensed on shift # 257683',5,'2022-02-27 09:57:40','608','0000-00-00 00:00:00','','2022-02-27 09:57:40','608'),(265277,'5',345127,'',0,'102',249,2992,'2022-03-31',40.96,'','','','631','1756','','','Dispensed on shift # 257713',5,'2022-03-31 15:19:21','795','0000-00-00 00:00:00','','2022-03-31 15:19:21','795'),(265278,'5',345128,'',0,'102',249,2992,'2022-03-31',169.00,'','','','631','1756','','','Dispensed on shift # 257714',5,'2022-03-31 15:25:33','795','0000-00-00 00:00:00','','2022-03-31 15:25:33','795'),(265279,'5',345129,'',0,'102',249,2992,'2022-04-04',75.75,'','','','632','1754','','','Dispensed on shift # 257716',5,'2022-04-04 09:45:07','795','0000-00-00 00:00:00','','2022-04-04 09:45:07','795'),(265280,'5',345130,'',0,'102',249,2992,'2022-05-10',347.87,'','','','631','1756','','','Dispensed on shift # 257746',5,'2022-05-10 11:35:21','795','0000-00-00 00:00:00','','2022-05-10 11:35:21','795'),(265281,'5',345131,'',0,'102',249,2992,'2022-05-10',60.60,'','','','631','1756','','','Dispensed on shift # 257749',5,'2022-05-10 11:48:30','795','0000-00-00 00:00:00','','2022-05-10 11:48:30','795'),(265282,'5',345132,'',0,'102',249,2992,'2022-05-10',48.48,'','','','631','1756','','','Dispensed on shift # 257750',5,'2022-05-10 11:50:28','795','0000-00-00 00:00:00','','2022-05-10 11:50:28','795'),(265283,'5',345133,'',0,'102',249,2992,'2022-05-10',212.12,'','','','631','1756','','','Dispensed on shift # 257751',5,'2022-05-10 11:53:14','795','0000-00-00 00:00:00','','2022-05-10 11:53:14','795');
/*!40000 ALTER TABLE `sales_distributions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_delivery`
--

DROP TABLE IF EXISTS `sales_distributions_delivery`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_delivery` (
  `delivery_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `distribution_id` int NOT NULL,
  `sale_id` int NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `quantity` int NOT NULL,
  `truck_id` int NOT NULL,
  `deliveredon` date NOT NULL,
  `details` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`delivery_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`quantity`,`thedate`,`createdby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`truck_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `distribution_id` (`distribution_id`),
  KEY `deliveredon` (`deliveredon`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_delivery`
--

LOCK TABLES `sales_distributions_delivery` WRITE;
/*!40000 ALTER TABLE `sales_distributions_delivery` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_delivery` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_trucks`
--

DROP TABLE IF EXISTS `sales_distributions_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_trucks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sale_id` varchar(20) NOT NULL,
  `distribution_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `bridge_id` varchar(20) NOT NULL,
  `truck_id` varchar(20) NOT NULL,
  `driver_id` varchar(20) NOT NULL,
  `quantity` int NOT NULL,
  `destination` varchar(150) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `companycode` (`company_id`,`distribution_id`,`truck_id`),
  KEY `sale_id` (`sale_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_trucks`
--

LOCK TABLES `sales_distributions_trucks` WRITE;
/*!40000 ALTER TABLE `sales_distributions_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_fueltickets`
--

DROP TABLE IF EXISTS `sales_fueltickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_fueltickets` (
  `ticket_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `ticketdate` date NOT NULL,
  `code` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `allowance` decimal(10,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `truck_number` varchar(20) NOT NULL,
  `truck_capacity` int NOT NULL,
  `truck_provider` varchar(50) NOT NULL,
  `truck_from` varchar(50) NOT NULL,
  `truck_destination` varchar(50) NOT NULL,
  `driver_name` varchar(50) NOT NULL,
  `driver_phone` varchar(50) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`ticket_id`),
  KEY `companycode` (`company_id`,`ticketdate`,`product_id`,`truck_number`,`rate`,`quantity`,`status`),
  KEY `paid` (`truck_provider`),
  KEY `invoice` (`code`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_fueltickets`
--

LOCK TABLES `sales_fueltickets` WRITE;
/*!40000 ALTER TABLE `sales_fueltickets` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_fueltickets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_payments`
--

DROP TABLE IF EXISTS `sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `customer_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`customer_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_payments`
--

LOCK TABLES `sales_payments` WRITE;
/*!40000 ALTER TABLE `sales_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers`
--

DROP TABLE IF EXISTS `suppliers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers` (
  `supplier_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`supplier_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=108 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers`
--

LOCK TABLES `suppliers` WRITE;
/*!40000 ALTER TABLE `suppliers` DISABLE KEYS */;
INSERT INTO `suppliers` VALUES (107,'5','102','SALBAS OIL & GAS NIG. LIMITED','KABIRU GM','','','KATSINA','KATSINA STATE','','Nigeria',0.00,0.00,'0000-00-00','2019-02-23 19:04:38',5,'415','2019-02-23 19:04:38','415');
/*!40000 ALTER TABLE `suppliers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers_status`
--

DROP TABLE IF EXISTS `suppliers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `supplier_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers_status`
--

LOCK TABLES `suppliers_status` WRITE;
/*!40000 ALTER TABLE `suppliers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `suppliers_status` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2023-03-21  2:56:24
