-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_5_station_101
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_5_station_101`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_5_station_101` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_5_station_101`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3242 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1804,3000,'',0,'24','5','101','PURCHASES','','2019-02-21 13:20:35',5,0.00,0.00,'2019-02-22','412','2019-02-22 14:19:40','412',0,1),(1805,3002,'',0,'24','5','101','SALARIES AND WAGES','','2019-02-21 13:21:16',5,0.00,0.00,'','412','2019-02-21 13:21:16','412',0,1),(1806,3003,'',0,'6.1','5','101','CASH','','2019-02-21 13:21:49',5,0.00,0.00,'','412','2019-02-21 13:21:49','412',0,1),(1807,4001,'',0,'20','5','101','SALES','','2019-02-21 13:22:14',5,0.00,0.00,'2019-02-22','412','2019-02-22 14:25:49','412',0,1),(1808,4000,'',0,'2','5','101','UBA 1019882661','','2019-02-21 13:22:53',5,0.00,0.00,'','412','2019-02-21 13:22:53','412',0,1),(1821,3004,'',0,'24','5','101','DIESEL INTERNAL CONSUPTION(GEN','','2019-02-22 14:26:21',5,0.00,0.00,'','412','2019-02-22 14:26:21','412',0,1),(1822,3005,'',0,'24','5','101','CLEANING & SANITARY ITEMS','','2019-02-22 14:26:42',5,0.00,0.00,'','412','2019-02-22 14:26:42','412',0,1),(1823,3007,'',0,'24','5','101','TRANSPORT FARE','','2019-02-22 14:27:05',5,0.00,0.00,'','412','2019-02-22 14:27:05','412',0,1),(1824,3008,'',0,'24','5','101','OTHER OPERATING EXPENSES','','2019-02-22 14:27:24',5,0.00,0.00,'','412','2019-02-22 14:27:24','412',0,1),(1825,3009,'',0,'24','5','101','GENERATOR REPAIRS & MAINTAINAN','','2019-02-22 14:27:52',5,0.00,0.00,'','412','2019-02-22 14:27:52','412',0,1),(1826,3010,'',0,'24','5','101','PUMP REPAIRS & MAINATAINACE','','2019-02-22 14:28:13',5,0.00,0.00,'','412','2019-02-22 14:28:13','412',0,1),(1827,3011,'',0,'24','5','101','WEIGHT AND MEASURE','','2019-02-22 14:28:37',5,0.00,0.00,'','412','2019-02-22 14:28:37','412',0,1),(1828,3012,'',0,'24','5','101','DPR EXPENSES','','2019-02-22 14:29:03',5,0.00,0.00,'','412','2019-02-22 14:29:03','412',0,1),(1829,3014,'',0,'24','5','101','MEDICAL EXPENSES','','2019-02-22 14:30:24',5,0.00,0.00,'','412','2019-02-22 14:30:24','412',0,1),(2179,4001,'',0,'2','5','101','UBA1019882661','','2020-01-08 13:48:18',5,0.00,0.00,'','412','2020-01-08 13:48:18','412',0,1),(2180,30016,'',0,'24','5','101','SALARIES & WAGES','','2020-01-08 13:49:05',5,0.00,0.00,'','412','2020-01-08 13:49:05','412',0,1),(3225,4005,'',0,'22','5','101','PURCHASES','','2021-03-02 22:56:02',5,0.00,0.00,'','412','2021-03-02 22:56:02','412',0,1),(3238,4025,'',0,'2','5','101','UBA-1022244739','','2021-03-06 01:36:36',5,0.00,0.00,'','600','2021-03-06 01:36:36','600',0,1),(3239,4026,'',0,'2','5','101','ZENITH BANK:EBILLS-1016650302','','2021-03-06 01:37:49',5,0.00,0.00,'','600','2021-03-06 01:37:49','600',0,1),(3240,4027,'',0,'2','5','101','JA\'IZ-0010037957','','2022-03-01 20:03:17',5,0.00,0.00,'','600','2022-03-01 20:03:17','600',0,0),(3241,2000,'',0,'6','5','101','INVENTORY VALUE ADJUSTMENT','','2023-02-06 10:22:51',5,0.00,0.00,'','600','2023-02-06 10:22:51','600',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
INSERT INTO `accounts_transactions` VALUES (1,'5','101','0000-00-00','2023-02-06 16:13:49',10,'600','','0000-00-00 00:00:00','600','2023-02-06 16:15:20'),(2,'5','101','0000-00-00','2023-02-20 16:31:48',10,'600','','0000-00-00 00:00:00','600','2023-02-20 16:36:24'),(3,'5','101','0000-00-00','2023-02-20 16:35:20',10,'600','','0000-00-00 00:00:00','600','2023-02-20 16:36:28');
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
INSERT INTO `accounts_transactions_items` VALUES (1,'5','101','1','3241','6',0.00,'PMS Price Icrease(185 to 220 x 23,800 litrs) 20/1/2023',833000.00,'2023-02-06'),(2,'5','101','1','104','supplier',833000.00,'PMS Price Icrease(185 to 220 x 23,800 litrs) 20/1/2023',0.00,'2023-02-06'),(4,'5','101','2','3241','6',10500.00,'PMS PRICE DECREASE FROM 220 TO 210 DIPPING 1,050',0.00,'2023-02-19'),(5,'5','101','2','104','supplier',0.00,'PMS PRICE DECREASE FROM 220 TO 210 DIPPING 1,050Ltrs',10500.00,'2023-02-20'),(6,'5','101','3','104','supplier',0.00,'AGO PRICE DECREASE FROM 830 TO 820 DIPPING 141',1410.00,'2023-02-20'),(7,'5','101','3','3241','6',1410.00,'AGO PRICE DECREASE FROM 830 TO 820 DIPPING 141Ltrs',0.00,'2023-02-20');
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=64575 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
INSERT INTO `accounts_vouchers_items` VALUES (64572,'5','101',31657,1805,'FEBRUARY SATFF SALARY',500000.00),(64573,'5','101',31657,1823,'TRANSPORTATION TO BANK',2000.00),(64574,'5','101',31657,1827,'WEIGHT AND MEASURE ',50000.00);
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=1430 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1429,'','5','101','P O S CUSTOMERS','','','','','','','Nigeria',0.00,0.00,0.00,'0000-00-00','2019-03-03 13:38:56',5,'412','2019-03-03 13:38:56','412');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=18466 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('5','101',17962,'916',6810.44,9000.00,'2021-12-09','','2021-12-09 18:02:19','412','412',2021,'412','2021-12-09 18:02:19',5),('5','101',18383,'917',1138.33,1200.00,'2022-01-08','','2022-01-08 22:18:44','412','412',2022,'412','2022-01-08 22:18:44',5),('5','101',18458,'917',2350.23,3000.00,'2022-01-16','','2022-01-16 23:11:52','412','412',2022,'412','2022-01-16 23:11:52',5),('5','101',18459,'917',995.47,1300.00,'2022-04-26','','2022-04-26 22:39:16','412','412',2022,'412','2022-04-26 22:39:16',5),('5','101',18460,'917',1979.71,2500.00,'2022-05-14','','2022-05-14 22:46:01','412','412',2022,'412','2022-05-14 22:46:01',5),('5','101',18461,'916',1512.13,2500.00,'2022-07-27','','2022-07-27 20:44:26','412','412',2022,'412','2022-07-27 20:44:26',5),('5','101',18462,'917',134.00,1050.00,'2022-08-11','','2022-09-05 13:52:07','412','412',2022,'412','2022-09-05 13:52:07',5),('5','101',18463,'916',1139.11,1200.00,'2022-10-21','','2022-10-21 21:32:56','412','412',2022,'412','2022-10-21 21:32:56',5),('5','101',18464,'916',574.37,1850.00,'2022-11-07','','2022-11-07 07:15:58','412','412',2022,'412','2022-11-07 07:15:58',5),('5','101',18465,'916',2373.32,3000.00,'2022-11-24','','2022-11-24 20:55:17','412','412',2022,'412','2022-11-24 20:55:17',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2713 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('5','101','620',1732,'5','PUMP 5',830444.59,'PMS Despenser.','',NULL,NULL,'',0,'2021-10-08 15:24:02','600'),('5','101','620',1733,'5','PUMP 6',918866.34,'PMS PUMP 6','',NULL,NULL,'',0,'2021-10-08 15:28:25','600'),('5','101','620',1734,'5','PUMP 7',502795.97,'PMS PUMP 7','',NULL,NULL,'',0,'2021-10-08 15:29:02','600'),('5','101','620',1735,'5','PUMP 8',1560587.15,'PMS PUMP 8','',NULL,NULL,'',0,'2021-10-08 15:29:38','600'),('5','101','621',1736,'5','PMS PUMP 1',1615525.76,'PMS PUMP 1','',NULL,NULL,'',0,'2021-10-08 15:30:13','600'),('5','101','621',1737,'5','PMS PUMP 2',940176.18,'PMS PUMP 2','',NULL,NULL,'',0,'2021-10-08 15:31:00','600'),('5','101','621',1738,'5','PMS PUMP 3',114060.24,'PMS PUMP 3','',NULL,NULL,'',0,'2021-10-08 15:31:39','600'),('5','101','621',1739,'5','PMS PUMP 4',1182184.15,'PMS PUMP 4','',NULL,NULL,'',0,'2021-10-08 15:32:19','600'),('5','101','622',1740,'5','PUMP 9',13028.28,'AGO PUMP ',NULL,NULL,NULL,NULL,5,'2019-10-03 14:05:25','412'),('5','101','622',1741,'5','PUMP 10',732112.12,'AGO PUMP ','',NULL,NULL,'',5,'2021-03-04 15:49:37','600'),('5','101','623',1742,'5','PUMP 11',0.00,'DPK PUMP',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','101','916',2705,'5','PMS PUMP 5',972996.64,'PMS DISPENSER','',NULL,NULL,'',5,'2021-03-04 15:40:47','600'),('5','101','916',2706,'5','PMS PUMP 6',1503729.72,'PMS DISPENSER','',NULL,NULL,'',5,'2021-03-04 15:42:37','600'),('5','101','916',2707,'5','PMS PUMP 7',502795.97,'PMS DISPENSER','',NULL,NULL,'',5,'2021-03-04 15:44:49','600'),('5','101','916',2708,'5','PMS PUMP 8',2312451.44,'PMS DISPENSER','',NULL,NULL,'',5,'2021-03-04 15:47:52','600'),('5','101','917',2709,'5','PMS PUMP 01',1622445.26,'PMS DISPENSER','',NULL,NULL,'',5,'2021-03-04 15:36:13','600'),('5','101','917',2710,'5','PMS PUMP 02',1378724.79,'PMS DISPENSER','',NULL,NULL,'',5,'2021-03-04 15:37:38','600'),('5','101','917',2711,'5','PMS PUMP 03',114060.24,'PMS DISPENSER','',NULL,NULL,'',5,'2021-03-04 15:38:19','600'),('5','101','917',2712,'5','PMS PUMP 04',1654075.76,'PMS DISPENSER','',NULL,NULL,'',5,'2021-03-04 15:39:30','600');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
INSERT INTO `depots_nozzles_status` VALUES (4,'5','101','1732',0,'PMS TANKS GROUPING ERROR.','2021-03-04 14:38:04'),(5,'5','101','1733',0,'PMS TANKS GROUPING ERROR.','2021-03-04 14:39:05'),(6,'5','101','1734',0,'PMS TANKS GROUPING ERROR.','2021-03-04 14:39:46'),(7,'5','101','1735',0,'PMS TANKS GROUPING ERROR.','2021-03-04 14:40:21'),(8,'5','101','1736',0,'PMS TANKS GROUPING ERROR.','2021-03-04 14:41:27'),(9,'5','101','1737',0,'PMS TANKS GROUPING ERROR.','2021-03-04 14:42:00'),(10,'5','101','1738',0,'PMS TANKS GROUPING ERROR.','2021-03-04 14:42:33'),(11,'5','101','1739',0,'PMS TANKS GROUPING ERROR.','2021-03-04 14:43:00');
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=257936 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('5','101',230367,'FULL TIME','2021-10-10','2021-10-10 00:00:00',NULL,'412',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','101',232403,'FULL TIME','2021-10-01','2021-10-01 00:00:00',NULL,'412',521667.54,521667.54,'412','2021-10-18 09:28:18','606','2021-10-18 09:50:24',10,0),('5','101',232414,'FULL TIME','2021-10-10','2021-10-10 00:00:00',NULL,'412',1190513.70,1190513.70,'412','2021-10-18 14:36:49','606','2021-10-18 14:47:37',10,0),('5','101',232502,'FULL TIME','2021-10-11','2021-10-11 00:00:00',NULL,'412',1224535.32,1224535.32,'412','2021-10-18 14:50:33','606','2021-10-18 14:56:32',10,0),('5','101',232505,'FULL TIME','2021-10-12','2021-10-12 00:00:00',NULL,'412',1198360.98,1198360.98,'412','2021-10-18 15:01:05','606','2021-10-18 15:04:48',10,0),('5','101',232507,'FULL TIME','2021-10-13','2021-10-13 00:00:00',NULL,'412',1021105.44,1021105.44,'412','2021-10-18 15:10:11','606','2021-10-18 15:20:18',10,0),('5','101',232513,'FULL TIME','2021-10-14','2021-10-14 00:00:00',NULL,'412',1115055.72,1115055.72,'412','2021-10-18 15:22:42','606','2021-10-18 15:26:00',10,0),('5','101',232515,'FULL TIME','2021-10-15','2021-10-15 00:00:00',NULL,'412',1139208.30,1139208.30,'412','2021-10-18 15:32:34','606','2021-10-18 15:59:23',10,0),('5','101',232529,'FULL TIME','2021-10-16','2021-10-16 00:00:00',NULL,'412',1251143.82,1251143.82,'412','2021-10-18 16:33:04','606','2021-10-18 16:44:41',10,0),('5','101',232531,'FULL TIME','2021-10-17','2021-10-17 00:00:00',NULL,'412',1360876.14,1360876.14,'412','2021-10-19 07:33:50','606','2021-10-19 08:09:49',10,0),('5','101',232651,'FULL TIME','2021-10-18','2021-10-18 00:00:00',NULL,'412',1126335.78,1126335.78,'412','2021-10-19 08:58:39','606','2021-10-19 10:32:12',10,0),('5','101',232720,'FULL TIME','2021-10-19','2021-10-19 00:00:00',NULL,'412',1167525.90,1167525.90,'412','2021-10-19 21:48:27','606','2021-10-20 05:47:44',10,0),('5','101',232906,'FULL TIME','2021-10-20','2021-10-20 00:00:00',NULL,'412',1246381.02,1246381.02,'412','2021-10-20 21:18:29','606','2021-10-21 06:03:32',10,0),('5','101',233131,'FULL TIME','2021-10-21','2021-10-21 00:00:00',NULL,'412',724684.32,724684.32,'412','2021-10-21 21:21:42','606','2021-10-22 05:58:11',10,0),('5','101',235549,'FULL TIME','2021-10-30','2021-10-30 00:00:00',NULL,'412',230027.04,234286.80,'412','2021-10-31 09:02:58','606','2021-10-31 09:09:50',10,0),('5','101',235587,'FULL TIME','2021-10-31','2021-10-31 00:00:00',NULL,'412',1042824.75,1042824.75,'412','2021-10-31 21:51:20','606','2021-11-01 07:24:46',10,0),('5','101',235810,'FULL TIME','2021-11-01','2021-11-01 00:00:00',NULL,'412',1539357.60,1539357.60,'412','2021-11-01 20:53:01','606','2021-11-02 06:19:31',10,0),('5','101',236036,'FULL TIME','2021-11-02','2021-11-02 00:00:00',NULL,'412',1378512.30,1378512.30,'412','2021-11-03 06:34:46','606','2021-11-03 08:50:26',10,0),('5','101',236307,'FULL TIME','2021-11-03','2021-11-03 00:00:00',NULL,'412',1459033.95,1459033.95,'412','2021-11-04 06:34:28','606','2021-11-04 07:39:34',10,0),('5','101',236583,'FULL TIME','2021-11-04','2021-11-04 00:00:00',NULL,'412',1394560.20,1394560.20,'412','2021-11-04 20:43:20','606','2021-11-05 06:34:06',10,0),('5','101',236763,'FULL TIME','2021-11-05','2021-11-05 00:00:00',NULL,'412',538276.20,538276.20,'412','2021-11-05 20:46:30','606','2021-11-06 07:04:34',10,0),('5','101',237773,'FULL TIME','2021-11-09','2021-11-09 00:00:00',NULL,'412',0.00,0.00,'412','2021-11-10 05:21:01','606','2021-11-10 08:39:55',10,0),('5','101',237951,'FULL TIME','2021-11-10','2021-11-10 00:00:00',NULL,'412',683601.60,683601.60,'412','2021-11-10 21:38:27','606','2021-11-11 05:46:06',10,0),('5','101',238129,'FULL TIME','2021-11-11','2021-11-11 00:00:00',NULL,'412',1147256.55,1147256.55,'412','2021-11-11 22:23:01','606','2021-11-12 07:27:08',10,0),('5','101',238420,'FULL TIME','2021-11-12','2021-11-12 00:00:00',NULL,'412',1203747.60,1203747.60,'412','2021-11-13 00:42:21','606','2021-11-13 07:03:42',10,0),('5','101',238637,'FULL TIME','2021-11-13','2021-11-13 00:00:00',NULL,'412',1363949.40,1363949.40,'412','2021-11-13 20:49:36','606','2021-11-14 05:47:15',10,0),('5','101',238989,'FULL TIME','2021-11-14','2021-11-14 00:00:00',NULL,'412',1327377.15,1327377.15,'412','2021-11-14 20:49:08','606','2021-11-15 06:22:51',10,0),('5','101',239074,'FULL TIME','2021-11-15','2021-11-15 00:00:00',NULL,'412',1591312.80,1591312.80,'412','2021-11-15 21:14:47','606','2021-11-16 07:15:58',10,0),('5','101',239354,'FULL TIME','2021-11-16','2021-11-16 00:00:00',NULL,'412',1541263.35,1541263.35,'412','2021-11-16 21:57:21','606','2021-11-17 05:46:27',10,0),('5','101',239549,'FULL TIME','2021-11-17','2021-11-17 00:00:00',NULL,'412',1363739.85,1363739.85,'412','2021-11-17 22:18:58','606','2021-11-18 06:06:57',10,0),('5','101',239967,'FULL TIME','2021-11-18','2021-11-18 00:00:00',NULL,'412',1463728.20,1463728.20,'412','2021-11-18 23:16:13','606','2021-11-19 07:26:27',10,0),('5','101',240164,'FULL TIME','2021-11-19','2021-11-19 00:00:00',NULL,'412',1400813.70,1400813.70,'412','2021-11-19 20:41:00','606','2021-11-20 07:08:13',10,0),('5','101',240234,'FULL TIME','2021-11-20','2021-11-20 00:00:00',NULL,'412',1548162.00,1548162.00,'412','2021-11-20 21:05:54','606','2021-11-21 05:51:42',10,0),('5','101',240578,'FULL TIME','2021-11-21','2021-11-21 00:00:00',NULL,'412',1541510.85,1541510.85,'412','2021-11-22 06:01:16','606','2021-11-22 06:21:06',10,0),('5','101',240743,'FULL TIME','2021-11-22','2021-11-22 00:00:00',NULL,'412',1587620.10,1587620.10,'412','2021-11-22 19:56:23','606','2021-11-23 07:01:20',10,0),('5','101',241014,'FULL TIME','2021-11-23','2021-11-23 00:00:00',NULL,'412',1473245.40,1473245.40,'412','2021-11-24 09:42:58','606','2021-11-24 09:52:39',10,0),('5','101',241333,'FULL TIME','2021-11-24','2021-11-24 00:00:00',NULL,'412',1478256.45,1478256.45,'412','2021-11-24 21:21:26','606','2021-11-25 06:25:20',10,0),('5','101',241503,'FULL TIME','2021-11-25','2021-11-25 00:00:00',NULL,'412',1523539.05,1523539.05,'412','2021-11-25 21:26:16','606','2021-11-26 06:09:44',10,0),('5','101',241818,'FULL TIME','2021-11-26','2021-11-26 00:00:00',NULL,'412',1592814.30,1592814.30,'412','2021-11-26 21:39:42','606','2021-11-27 07:08:25',10,0),('5','101',242008,'FULL TIME','2021-11-27','2021-11-27 00:00:00',NULL,'412',870779.25,870779.25,'412','2021-11-27 21:08:50','606','2021-11-28 06:47:29',10,0),('5','101',242258,'FULL TIME','2021-11-28','2021-11-28 00:00:00',NULL,'412',0.00,0.00,'412','2021-11-29 06:16:26','606','2021-11-30 06:00:56',10,0),('5','101',242865,'FULL TIME','2021-11-30','2021-11-30 00:00:00',NULL,'412',403918.35,403918.35,'412','2021-12-01 06:38:58','606','2021-12-01 07:52:42',10,0),('5','101',242993,'FULL TIME','2021-12-01','2021-12-01 00:00:00',NULL,'412',1346051.85,1346051.85,'412','2021-12-01 21:00:08','606','2021-12-02 07:19:57',10,0),('5','101',243218,'FULL TIME','2021-12-02','2021-12-02 00:00:00',NULL,'412',1323399.00,1323399.00,'412','2021-12-02 21:43:26','606','2021-12-03 06:46:41',10,0),('5','101',243405,'FULL TIME','2021-12-03','2021-12-03 00:00:00',NULL,'412',1377174.15,1377174.15,'412','2021-12-03 21:13:26','606','2021-12-04 06:55:04',10,0),('5','101',243627,'FULL TIME','2021-12-04','2021-12-04 00:00:00',NULL,'412',1432358.40,1432358.40,'412','2021-12-04 21:12:44','606','2021-12-05 05:44:31',10,0),('5','101',243855,'FULL TIME','2021-12-05','2021-12-05 00:00:00',NULL,'412',1502882.70,1502882.70,'412','2021-12-05 21:14:41','606','2021-12-06 06:28:58',10,0),('5','101',244082,'FULL TIME','2021-12-06','2021-12-06 00:00:00',NULL,'412',1436194.65,1436194.65,'412','2021-12-06 21:12:01','606','2021-12-07 06:51:21',10,0),('5','101',244372,'FULL TIME','2021-12-07','2021-12-07 00:00:00',NULL,'412',1151191.80,1151191.80,'412','2021-12-09 18:04:37','600','2021-12-09 18:06:57',10,0),('5','101',245251,'FULL TIME','2021-12-11','2021-12-11 00:00:00',NULL,'412',0.00,0.00,'412','2021-12-11 09:26:46','600','2021-12-11 09:38:14',10,0),('5','101',245285,'FULL TIME','2021-12-08','2021-12-08 00:00:00',NULL,'412',0.00,0.00,'412','2021-12-11 09:40:59','600','2021-12-11 09:42:16',10,0),('5','101',245286,'FULL TIME','2021-12-09','2021-12-09 00:00:00',NULL,'412',0.00,0.00,'412','2021-12-11 09:43:08','600','2021-12-11 09:44:12',10,0),('5','101',245412,'FULL TIME','2021-12-10','2021-12-10 00:00:00',NULL,'412',0.00,0.00,'412','2021-12-11 21:21:03','606','2021-12-12 06:49:38',10,0),('5','101',245456,'FULL TIME','2021-12-12','2021-12-12 00:00:00',NULL,'412',0.00,0.00,'412','2021-12-12 18:08:24','606','2021-12-13 05:58:15',10,0),('5','101',245711,'FULL TIME','2021-12-13','2021-12-13 00:00:00',NULL,'412',160573.05,160573.05,'412','2021-12-13 22:18:06','606','2021-12-14 06:04:45',10,0),('5','101',245957,'FULL TIME','2021-12-14','2021-12-14 00:00:00',NULL,'412',1339922.10,1339922.10,'412','2021-12-15 05:51:49','606','2021-12-15 06:38:48',10,0),('5','101',246293,'FULL TIME','2021-12-15','2021-12-15 00:00:00',NULL,'412',1448071.35,1448071.35,'412','2021-12-15 19:31:30','606','2021-12-16 06:50:24',10,0),('5','101',246489,'FULL TIME','2021-12-16','2021-12-16 00:00:00',NULL,'412',1168033.35,1168033.35,'412','2021-12-16 20:25:44','606','2021-12-17 06:10:18',10,0),('5','101',246751,'FULL TIME','2021-12-17','2021-12-17 00:00:00',NULL,'412',375213.30,375213.30,'412','2021-12-17 20:13:16','606','2021-12-18 07:02:20',10,0),('5','101',247009,'FULL TIME','2021-12-18','2021-12-18 00:00:00',NULL,'412',1452600.60,1452600.60,'412','2021-12-18 20:51:29','606','2021-12-19 07:11:45',10,0),('5','101',247260,'FULL TIME','2021-12-19','2021-12-19 00:00:00',NULL,'412',1374902.10,1374902.10,'412','2021-12-19 19:10:47','606','2021-12-20 06:53:39',10,0),('5','101',247455,'FULL TIME','2021-12-20','2021-12-20 00:00:00',NULL,'412',1426875.45,1426875.45,'412','2021-12-20 20:27:58','600','2021-12-21 09:20:51',10,0),('5','101',247745,'FULL TIME','2021-12-21','2021-12-21 00:00:00',NULL,'412',498950.10,498950.10,'412','2021-12-21 20:07:37','606','2021-12-22 06:28:28',10,0),('5','101',247942,'FULL TIME','2021-12-22','2021-12-22 00:00:00',NULL,'412',0.00,0.00,'412','2021-12-22 19:20:30','606','2021-12-23 06:23:50',10,0),('5','101',248252,'FULL TIME','2021-12-23','2021-12-23 00:00:00',NULL,'412',0.00,0.00,'412','2021-12-23 21:49:17','606','2021-12-24 07:19:46',10,0),('5','101',248478,'FULL TIME','2021-12-24','2021-12-24 00:00:00',NULL,'412',0.00,0.00,'412','2021-12-24 18:46:39','606','2021-12-25 14:07:55',10,0),('5','101',248964,'FULL TIME','2021-12-26','2021-12-26 00:00:00',NULL,'412',0.00,0.00,'412','2021-12-26 18:53:54','606','2021-12-27 07:40:15',10,0),('5','101',249299,'FULL TIME','2021-12-27','2021-12-27 00:00:00',NULL,'412',0.00,0.00,'412','2021-12-27 18:51:43','606','2021-12-28 07:34:46',10,0),('5','101',249429,'FULL TIME','2021-12-28','2021-12-28 00:00:00',NULL,'412',0.00,0.00,'412','2021-12-28 17:46:57','606','2021-12-29 06:44:45',10,0),('5','101',249664,'FULL TIME','2021-12-29','2021-12-29 00:00:00',NULL,'412',1081414.95,1081414.95,'412','2021-12-29 20:27:57','606','2021-12-30 06:56:16',10,0),('5','101',249899,'FULL TIME','2021-12-30','2021-12-30 00:00:00',NULL,'412',1416290.70,1416290.70,'412','2021-12-30 20:01:32','606','2021-12-31 06:46:16',10,0),('5','101',250164,'FULL TIME','2021-12-31','2021-12-31 00:00:00',NULL,'412',1240864.35,1240864.35,'412','2022-01-01 07:33:33','606','2022-01-01 07:48:52',10,0),('5','101',250480,'FULL TIME','2022-01-01','2022-01-01 00:00:00',NULL,'412',1818062.40,1818062.40,'412','2022-01-01 20:58:23','606','2022-01-02 06:44:20',10,0),('5','101',250651,'FULL TIME','2022-01-02','2022-01-02 00:00:00',NULL,'412',1222374.45,1222374.45,'412','2022-01-02 19:59:18','606','2022-01-03 14:05:26',10,0),('5','101',250992,'FULL TIME','2022-01-03','2022-01-03 00:00:00',NULL,'412',557751.15,557751.15,'412','2022-01-03 21:37:45','606','2022-01-04 07:04:15',10,0),('5','101',251098,'FULL TIME','2022-01-04','2022-01-04 00:00:00',NULL,'412',2140304.10,2140304.10,'412','2022-01-05 06:44:26','606','2022-01-05 07:34:02',10,0),('5','101',251324,'FULL TIME','2022-01-05','2022-01-05 00:00:00',NULL,'412',1806660.90,1806660.90,'412','2022-01-06 07:21:55','606','2022-01-06 07:46:27',10,0),('5','101',251581,'FULL TIME','2022-01-06','2022-01-06 00:00:00',NULL,'412',1579526.85,1579526.85,'412','2022-01-06 21:46:59','606','2022-01-07 09:07:50',10,0),('5','101',251839,'FULL TIME','2022-01-07','2022-01-07 00:00:00',NULL,'412',1460687.25,1460687.25,'412','2022-01-07 23:02:59','606','2022-01-08 07:57:30',10,0),('5','101',252019,'FULL TIME','2022-01-08','2022-01-08 00:00:00',NULL,'412',190142.70,190142.70,'412','2022-01-08 22:20:09','606','2022-01-09 08:01:50',10,0),('5','101',252261,'FULL TIME','2022-01-09','2022-01-09 00:00:00',NULL,'412',0.00,0.00,'412','2022-01-10 08:00:24','606','2022-01-11 05:30:15',10,0),('5','101',252771,'FULL TIME','2022-01-11','2022-01-11 00:00:00',NULL,'412',1189389.30,1189389.30,'412','2022-01-11 22:33:58','606','2022-01-12 07:48:56',10,0),('5','101',253024,'FULL TIME','2022-01-12','2022-01-12 00:00:00',NULL,'412',1035335.40,1035335.40,'412','2022-01-12 22:15:38','606','2022-01-13 07:34:17',10,0),('5','101',253255,'FULL TIME','2022-01-13','2022-01-13 00:00:00',NULL,'412',249649.95,249649.95,'412','2022-01-14 07:08:22','606','2022-01-14 09:31:31',10,0),('5','101',253539,'FULL TIME','2022-01-14','2022-01-14 00:00:00',NULL,'412',1563746.25,1563746.25,'412','2022-01-15 07:31:48','606','2022-01-15 10:28:37',10,0),('5','101',253782,'FULL TIME','2022-01-15','2022-01-15 00:00:00',NULL,'412',1556837.70,1556837.70,'412','2022-01-15 22:12:19','606','2022-01-16 07:09:36',10,0),('5','101',254168,'FULL TIME','2022-01-16','2022-01-16 00:00:00',NULL,'412',1540520.85,1540520.85,'412','2022-01-16 23:13:40','606','2022-01-17 07:12:58',10,0),('5','101',254292,'FULL TIME','2022-01-17','2022-01-17 00:00:00',NULL,'412',1475309.55,1475309.55,'412','2022-01-17 22:17:06','606','2022-01-18 08:37:44',10,0),('5','101',254521,'FULL TIME','2022-01-18','2022-01-18 00:00:00',NULL,'412',1052068.05,1052068.05,'412','2022-01-18 20:41:26','606','2022-01-19 08:42:29',10,0),('5','101',254784,'FULL TIME','2022-01-19','2022-01-19 00:00:00',NULL,'412',0.00,0.00,'412','2022-01-19 21:14:06','606','2022-01-20 08:07:33',10,0),('5','101',255015,'FULL TIME','2022-01-20','2022-01-20 00:00:00',NULL,'412',0.00,0.00,'412','2022-01-20 19:43:20','606','2022-01-21 08:33:14',10,0),('5','101',255351,'FULL TIME','2022-01-21','2022-01-21 00:00:00',NULL,'412',0.00,0.00,'412','2022-01-21 21:11:37','606','2022-01-22 08:05:09',10,0),('5','101',255585,'FULL TIME','2022-01-22','2022-01-22 00:00:00',NULL,'412',0.00,0.00,'412','2022-01-22 20:09:02','606','2022-01-23 07:22:03',10,0),('5','101',255735,'FULL TIME','2022-01-23','2022-01-23 00:00:00',NULL,'412',0.00,0.00,'412','2022-01-24 07:47:25','606','2022-01-24 08:31:55',10,0),('5','101',256154,'FULL TIME','2022-01-24','2022-01-24 00:00:00',NULL,'412',0.00,0.00,'412','2022-01-24 20:51:47','606','2022-01-25 07:31:49',10,0),('5','101',256461,'FULL TIME','2022-01-25','2022-01-25 00:00:00',NULL,'412',0.00,0.00,'412','2022-01-25 22:48:35','606','2022-01-26 08:07:44',10,0),('5','101',256599,'FULL TIME','2022-01-26','2022-01-26 00:00:00',NULL,'412',233013.00,233013.00,'412','2022-01-27 10:48:57','606','2022-01-27 10:54:26',10,0),('5','101',256816,'FULL TIME','2022-01-27','2022-01-27 00:00:00',NULL,'412',1420098.90,1420098.90,'412','2022-01-27 23:54:51','606','2022-01-28 07:21:04',10,0),('5','101',256998,'FULL TIME','2022-01-28','2022-01-28 00:00:00',NULL,'412',1401396.15,1401396.15,'412','2022-01-28 22:32:41','606','2022-01-29 07:49:08',10,0),('5','101',257298,'FULL TIME','2022-01-29','2022-01-29 00:00:00',NULL,'412',1406212.50,1406212.50,'412','2022-01-29 20:44:23','606','2022-01-30 07:42:56',10,0),('5','101',257534,'FULL TIME','2022-01-30','2022-01-30 00:00:00',NULL,'412',1556806.35,1556806.35,'412','2022-01-31 13:13:35','606','2022-01-31 13:19:26',10,0),('5','101',257535,'FULL TIME','2022-01-31','2022-01-31 00:00:00',NULL,'412',519891.90,519891.90,'412','2022-01-31 20:11:26','606','2022-02-01 08:30:51',10,0),('5','101',257536,'FULL TIME','2022-02-01','2022-02-01 00:00:00',NULL,'412',0.00,0.00,'412','2022-02-01 20:24:58','606','2022-02-02 08:33:52',10,0),('5','101',257537,'FULL TIME','2022-02-02','2022-02-02 00:00:00',NULL,'412',299306.70,299306.70,'412','2022-02-03 12:17:07','606','2022-02-04 06:28:12',10,0),('5','101',257538,'FULL TIME','2022-02-03','2022-02-03 00:00:00',NULL,'412',1154775.60,1154775.60,'412','2022-02-04 08:14:38','606','2022-02-04 09:09:25',10,0),('5','101',257539,'FULL TIME','2022-02-04','2022-02-04 00:00:00',NULL,'412',1506275.10,1506275.10,'412','2022-02-04 21:37:14','606','2022-02-05 07:51:31',10,0),('5','101',257540,'FULL TIME','2022-02-05','2022-02-05 00:00:00',NULL,'412',1408108.35,1408108.35,'412','2022-02-05 22:54:42','606','2022-02-06 07:47:54',10,0),('5','101',257541,'FULL TIME','2022-02-06','2022-02-06 00:00:00',NULL,'412',1541241.90,1541241.90,'412','2022-02-06 21:52:42','606','2022-02-07 07:17:09',10,0),('5','101',257542,'FULL TIME','2022-02-07','2022-02-07 00:00:00',NULL,'412',751773.00,751773.00,'412','2022-02-07 20:11:04','606','2022-02-08 07:43:10',10,0),('5','101',257543,'FULL TIME','2022-02-08','2022-02-08 00:00:00',NULL,'412',0.00,0.00,'412','2022-02-09 09:25:17','606','2022-02-09 21:21:02',10,0),('5','101',257544,'FULL TIME','2022-02-09','2022-02-09 00:00:00',NULL,'412',0.00,0.00,'412','2022-02-09 22:53:14','606','2022-02-10 08:01:23',10,0),('5','101',257545,'FULL TIME','2022-02-10','2022-02-10 00:00:00',NULL,'412',0.00,0.00,'412','2022-02-10 22:00:57','606','2022-02-11 08:12:22',10,0),('5','101',257546,'FULL TIME','2022-02-11','2022-02-11 00:00:00',NULL,'412',0.00,0.00,'412','2022-02-11 21:12:33','606','2022-02-12 08:13:30',10,0),('5','101',257547,'FULL TIME','2022-02-12','2022-02-12 00:00:00',NULL,'412',0.00,0.00,'412','2022-02-12 20:37:38','606','2022-02-13 07:30:27',10,0),('5','101',257548,'FULL TIME','2022-02-15','2022-02-15 00:00:00',NULL,'412',169544.10,169544.10,'412','2022-02-16 10:13:33','606','2022-02-16 10:14:35',10,0),('5','101',257549,'FULL TIME','2022-02-16','2022-02-16 00:00:00',NULL,'412',1405545.90,1405545.90,'412','2022-02-16 20:51:19','606','2022-02-17 07:09:59',10,0),('5','101',257550,'FULL TIMEo','2022-02-17','2022-02-17 00:00:00',NULL,'412',1530214.95,1530214.95,'412','2022-02-17 22:52:52','606','2022-02-18 07:23:56',10,0),('5','101',257551,'FULL TIME','2022-02-18','2022-02-18 00:00:00',NULL,'412',1493923.20,1493923.20,'412','2022-02-19 10:57:43','606','2022-02-19 10:58:38',10,0),('5','101',257552,'FULL TIME','2022-02-19','2022-02-19 00:00:00',NULL,'412',330346.50,330346.50,'412','2022-02-19 20:21:55','606','2022-02-20 07:22:56',10,0),('5','101',257553,'FULL TIME','2022-02-20','2022-02-20 00:00:00',NULL,'412',0.00,0.00,'412','2022-02-20 21:06:29','606','2022-02-21 07:25:46',10,0),('5','101',257554,'FULL TIME','2022-02-21','2022-02-21 00:00:00',NULL,'412',201473.25,201473.25,'412','2022-02-22 09:50:29','606','2022-02-22 09:52:31',10,0),('5','101',257555,'FULL TIME','2022-02-22','2022-02-22 09:54:50','2022-02-23 09:54:50','412',1614305.55,1614305.55,'412','2022-02-22 21:18:49','606','2022-02-23 07:02:59',10,0),('5','101',257556,'FULL TIME','2022-02-23','2022-02-23 07:58:15','2022-02-24 07:58:15','412',1437192.90,1437192.90,'412','2022-02-24 06:49:52','606','2022-02-24 09:38:52',10,0),('5','101',257557,'FULL TIME','2022-02-24','2022-02-24 09:46:44','2022-02-25 09:46:44','412',2288690.25,2288690.25,'412','2022-02-24 20:18:08','606','2022-02-25 08:12:12',10,0),('5','101',257558,'FULL TIME','2022-02-25','2022-02-25 08:40:59','2022-02-26 08:40:59','412',1078350.90,1078350.90,'412','2022-02-25 22:05:44','606','2022-02-26 07:20:34',10,0),('5','101',257559,'FULL TIME','2022-02-26','2022-02-26 12:25:35','2022-02-27 12:25:35','412',1741639.35,1741639.35,'412','2022-02-27 07:13:02','606','2022-02-27 12:19:53',10,0),('5','101',257560,'FULL TIME','2022-02-27','2022-02-27 13:54:03','2022-02-28 13:54:03','412',1616473.65,1616473.65,'412','2022-02-28 10:01:35','606','2022-02-28 10:03:46',10,0),('5','101',257561,'FULL TIME','2022-02-28','2022-02-28 10:04:56','2022-03-01 10:04:56','412',1651044.45,1651044.45,'412','2022-02-28 22:18:30','606','2022-03-01 06:55:21',10,0),('5','101',257562,'FULL TIME','2022-03-01','2022-03-01 11:04:22','2022-03-02 11:04:22','412',1644221.70,1644221.70,'412','2022-03-01 22:28:04','606','2022-03-02 08:20:37',10,0),('5','101',257563,'FULL TIME','2022-03-02','2022-03-02 18:35:10','2022-03-03 18:35:10','412',1691753.25,1691753.25,'412','2022-03-02 21:30:45','606','2022-03-03 10:22:03',10,0),('5','101',257564,'FULL TIME','2022-03-03','2022-03-03 22:18:52','2022-03-04 22:18:52','412',481837.95,481837.95,'412','2022-03-03 22:19:55','606','2022-03-04 09:14:00',10,0),('5','101',257565,'FULL TIME','2022-03-04','2022-03-04 21:40:38','2022-03-05 21:40:38','412',0.00,0.00,'600','2022-03-04 22:00:59','600','2022-03-04 22:01:14',10,0),('5','101',257566,'FULL TIME','2022-03-04','2022-03-04 22:08:04','2022-03-05 22:08:04','412',1523072.10,1523072.10,'412','2022-03-04 22:08:46','606','2022-03-05 07:34:11',10,0),('5','101',257567,'FULL TIME','2022-03-05','2022-03-05 21:11:58','2022-03-06 21:11:58','412',745618.50,745618.50,'412','2022-03-06 07:59:18','606','2022-03-06 08:25:44',10,0),('5','101',257568,'FULL TIME','2022-03-06','2022-03-06 08:51:32','2022-03-07 08:51:32','412',251012.85,251012.85,'412','2022-03-06 21:31:12','606','2022-03-07 07:59:41',10,0),('5','101',257569,'FULL TIME','2022-03-07','2022-03-07 22:22:34','2022-03-08 22:22:34','412',1449980.40,1449980.40,'412','2022-03-07 22:23:55','606','2022-03-08 07:04:20',10,0),('5','101',257570,'FULL TIME','2022-03-08','2022-03-08 14:25:00','2022-03-09 14:25:00','412',602639.40,602639.40,'412','2022-03-08 22:09:30','606','2022-03-09 07:58:12',10,0),('5','101',257571,'FULL TIME','2022-03-09','2022-03-09 22:06:26','2022-03-10 22:06:26','412',0.00,0.00,'412','2022-03-09 22:06:53','606','2022-03-10 06:40:55',10,0),('5','101',257572,'FULL TIME','2022-03-10','2022-03-10 22:49:32','2022-03-11 22:49:32','412',0.00,0.00,'412','2022-03-10 22:49:46','606','2022-03-11 08:25:42',10,0),('5','101',257573,'FULL TIME','2022-03-11','2022-03-11 21:22:45','2022-03-12 21:22:45','412',113376.45,113376.45,'412','2022-03-11 22:07:02','606','2022-03-12 07:57:11',10,0),('5','101',257574,'FULL TIME','2022-03-12','2022-03-13 06:13:47','2022-03-14 06:13:47','412',0.00,0.00,'412','2022-03-13 06:14:03','606','2022-03-13 08:07:40',10,0),('5','101',257575,'FULL TIME','2022-03-13','2022-03-13 11:55:25','2022-03-14 11:55:25','412',1641457.95,1641457.95,'412','2022-03-13 21:47:52','606','2022-03-14 07:07:09',10,0),('5','101',257576,'FULL TIME','2022-03-14','2022-03-14 11:42:39','2022-03-15 11:42:39','412',1969428.45,1969428.45,'412','2022-03-14 21:39:13','606','2022-03-15 07:09:09',10,0),('5','101',257577,'FULL TIME','2022-03-15','2022-03-15 11:59:47','2022-03-16 11:59:47','412',1395862.05,1395862.05,'412','2022-03-15 21:41:31','606','2022-03-16 08:11:29',10,0),('5','101',257578,'FULL TIME','2022-03-16','2022-03-16 12:18:17','2022-03-17 12:18:17','412',1507410.30,1507410.30,'412','2022-03-16 23:02:52','606','2022-03-17 10:23:08',10,0),('5','101',257579,'FULL TIME','2022-03-17','2022-03-17 13:22:06','2022-03-18 13:22:06','412',0.00,0.00,'412','2022-03-18 07:08:27','606','2022-03-18 07:48:04',10,0),('5','101',257580,'FULL TIME','2022-03-18','2022-03-19 07:42:44','2022-03-20 07:42:44','412',0.00,0.00,'412','2022-03-19 07:42:59','606','2022-03-19 08:28:57',10,0),('5','101',257581,'FULL TIME','2022-03-19','2022-03-19 14:47:55','2022-03-20 14:47:55','412',0.00,0.00,'412','2022-03-20 06:59:31','606','2022-03-20 07:32:02',10,0),('5','101',257582,'FULL TIME','2022-03-20','2022-03-20 14:39:22','2022-03-21 14:39:22','412',0.00,0.00,'412','2022-03-21 06:26:28','606','2022-03-21 06:33:46',10,0),('5','101',257583,'FULL TIME','2022-03-21','2022-03-21 10:13:58','2022-03-22 10:13:58','412',0.00,0.00,'412','2022-03-21 23:09:14','606','2022-03-22 07:07:14',10,0),('5','101',257584,'FULL TIME','2022-03-22','2022-03-22 20:36:13','2022-03-23 20:36:13','412',158098.05,158098.05,'412','2022-03-22 20:48:56','606','2022-03-23 06:33:58',10,0),('5','101',257585,'FULL TIME','2022-03-23','2022-03-23 11:39:02','2022-03-24 11:39:02','412',0.00,0.00,'412','2022-03-23 22:50:09','606','2022-03-24 20:35:27',10,0),('5','101',257586,'FULL TIME','2022-03-24','2022-03-26 08:17:38','2022-03-27 08:17:38','412',0.00,0.00,'412','2022-03-26 08:17:52','606','2022-03-26 09:08:24',10,0),('5','101',257587,'FULL TIME','2022-03-26','2022-03-26 13:08:24','2022-03-27 13:08:24','412',335700.75,335700.75,'412','2022-03-27 09:01:13','606','2022-03-27 14:10:01',10,0),('5','101',257588,'FULL TIME','2022-03-27','2022-03-27 14:53:37','2022-03-28 14:53:37','412',1588352.70,1588352.70,'412','2022-03-27 21:22:53','606','2022-03-28 09:21:46',10,0),('5','101',257589,'FULL TIME','2022-03-28','2022-03-29 07:01:32','2022-03-30 07:01:32','412',1586582.25,1586582.25,'412','2022-03-29 07:03:38','606','2022-03-29 07:21:39',10,0),('5','101',257590,'FULL TIME','2022-03-29','2022-03-30 07:52:45','2022-03-31 07:52:45','412',1378933.05,1378933.05,'412','2022-03-30 07:53:39','606','2022-03-30 08:03:42',10,0),('5','101',257591,'FULL TIME','2022-03-30','2022-03-30 08:36:07','2022-03-31 08:36:07','412',1213654.20,1213654.20,'412','2022-03-30 22:02:13','606','2022-03-31 08:04:01',10,0),('5','101',257592,'FULL TIME','2022-03-31','2022-03-31 23:35:52','2022-04-01 23:35:52','412',452208.90,452208.90,'412','2022-03-31 23:37:53','797','2022-04-01 07:34:57',10,0),('5','101',257593,'FULL TIME','2022-04-01','2022-04-01 19:13:12','2022-04-02 19:13:12','412',0.00,0.00,'412','2022-04-02 05:00:03','797','2022-04-02 17:01:37',10,0),('5','101',257594,'FULL TIME','2022-04-02','2022-04-02 20:38:45','2022-04-03 20:38:45','412',0.00,0.00,'412','2022-04-03 11:33:04','606','2022-04-03 22:01:03',10,0),('5','101',257595,'FULL TIME','2022-04-03','2022-04-03 22:06:12','2022-04-04 22:06:12','412',0.00,0.00,'412','2022-04-03 22:10:10','797','2022-04-03 22:36:44',10,0),('5','101',257596,'FULL TIME','2022-04-04','2022-04-04 21:48:13','2022-04-05 21:48:13','412',0.00,0.00,'412','2022-04-04 21:48:28','797','2022-04-05 10:29:53',10,0),('5','101',257597,'FULL TIME','2022-04-05','2022-04-05 21:48:56','2022-04-06 21:48:56','412',248014.80,248014.80,'412','2022-04-06 12:07:16','606','2022-04-07 06:10:51',10,0),('5','101',257598,'FULL TIME','2022-04-06','2022-04-07 08:13:43','2022-04-08 08:13:43','412',1096786.35,1096786.35,'412','2022-04-07 08:15:24','797','2022-04-07 19:57:38',10,0),('5','101',257599,'FULL TIME','2022-04-07','2022-04-07 21:30:38','2022-04-08 21:30:38','412',940122.15,940122.15,'412','2022-04-07 21:32:01','797','2022-04-08 10:31:32',10,0),('5','101',257600,'FULL TIME','2022-04-08','2022-04-08 11:02:06','2022-04-09 11:02:06','412',1038452.25,1038452.25,'412','2022-04-08 23:08:49','797','2022-04-09 12:49:52',10,0),('5','101',257601,'FULL TIME','2022-04-09','2022-04-09 16:31:59','2022-04-10 16:31:59','412',1550021.55,1550021.55,'412','2022-04-11 07:31:44','797','2022-04-11 08:58:42',10,0),('5','101',257602,'FULL TIME','2022-04-10','2022-04-11 09:18:41','2022-04-12 09:18:41','412',2030626.95,2030626.95,'412','2022-04-11 09:19:34','797','2022-04-11 09:52:43',10,0),('5','101',257603,'FULL TIME','2022-04-11','2022-04-11 11:12:43','2022-04-12 11:12:43','412',1637237.25,1637237.25,'412','2022-04-11 23:01:55','797','2022-04-12 07:17:42',10,0),('5','101',257604,'FULL TIME','2022-04-12','2022-04-12 12:49:55','2022-04-13 12:49:55','412',1875665.55,1875665.55,'412','2022-04-12 21:46:20','797','2022-04-13 09:55:31',10,0),('5','101',257605,'FULL TIME','2022-04-13','2022-04-13 11:09:09','2022-04-14 11:09:09','412',1453221.00,1453221.00,'412','2022-04-14 07:24:22','797','2022-04-14 08:25:34',10,0),('5','101',257606,'FULL TIME','2022-04-14','2022-04-14 09:19:46','2022-04-15 09:19:46','412',1579988.85,1579988.85,'412','2022-04-15 08:13:51','797','2022-04-15 15:18:34',10,0),('5','101',257607,'FULL TIME','2022-04-15','2022-04-16 07:27:44','2022-04-17 07:27:44','412',1500557.85,1473274.98,'412','2022-04-16 07:29:32','797','2022-04-16 11:32:00',10,0),('5','101',257608,'FULL TIME','2022-04-16','2022-04-16 22:28:23','2022-04-17 22:28:23','412',1510147.65,1510147.65,'412','2022-04-16 23:05:50','797','2022-04-17 07:08:23',10,0),('5','101',257609,'FULL TIME','2022-04-17','2022-04-17 22:43:49','2022-04-18 22:43:49','412',1089955.35,1089955.35,'412','2022-04-17 22:45:30','797','2022-04-18 10:38:04',10,0),('5','101',257610,'FULL TIME','2022-04-18','2022-04-18 14:50:20','2022-04-19 14:50:20','412',1050055.05,1050055.05,'412','2022-04-18 23:19:26','797','2022-04-19 04:32:39',10,0),('5','101',257611,'FULL TIME','2022-04-19','2022-04-19 10:23:54','2022-04-20 10:23:54','412',805411.20,805411.20,'412','2022-04-19 22:23:43','797','2022-04-19 22:45:58',10,0),('5','101',257612,'FULL TIME','2022-04-20','2022-04-21 08:58:51','2022-04-22 08:58:51','412',0.00,0.00,'412','2022-04-21 08:59:11','797','2022-04-21 09:24:09',10,0),('5','101',257613,'FULL TIME','2022-04-21','2022-04-21 13:23:32','2022-04-22 13:23:32','412',0.00,0.00,'412','2022-04-22 09:38:09','797','2022-04-22 09:57:00',10,0),('5','101',257614,'FULL TIME','2022-04-22','2022-04-22 17:47:27','2022-04-23 17:47:27','412',264886.05,264886.05,'412','2022-04-23 10:32:50','797','2022-04-23 22:06:59',10,0),('5','101',257615,'FULL TIME','2022-04-23','2022-04-23 23:55:28','2022-04-24 23:55:28','412',1380208.50,1380208.50,'412','2022-04-23 23:56:43','797','2022-04-24 05:36:43',10,0),('5','101',257616,'FULL TIME','2022-04-24','2022-04-24 10:03:24','2022-04-25 10:03:24','412',1274851.05,1274851.05,'412','2022-04-24 21:31:04','797','2022-04-25 04:54:22',10,0),('5','101',257617,'FULL TIME','2022-04-25','2022-04-26 03:16:08','2022-04-27 03:16:08','412',1292727.15,1292727.15,'412','2022-04-26 03:17:09','797','2022-04-26 07:35:48',10,0),('5','101',257618,'FULL TIME','2022-04-26','2022-04-26 11:08:16','2022-04-27 11:08:16','412',187624.80,187624.80,'412','2022-04-26 22:39:55','797','2022-04-27 05:40:26',10,0),('5','101',257619,'FULL TIME','2022-04-27','2022-04-27 22:14:34','2022-04-28 22:14:34','412',0.00,0.00,'412','2022-04-27 22:14:51','797','2022-04-28 07:33:56',10,0),('5','101',257620,'FULL TIME','2022-04-28','2022-04-28 18:04:06','2022-04-29 18:04:06','412',335789.85,335789.85,'412','2022-04-29 11:33:50','797','2022-04-29 11:37:37',10,0),('5','101',257621,'FULL TIME','2022-04-29','2022-04-29 14:21:17','2022-04-30 14:21:17','412',1304615.40,1304615.40,'412','2022-04-29 23:02:11','797','2022-05-09 10:23:48',10,0),('5','101',257622,'FULL TIME','2022-04-30','2022-05-09 14:02:10','2022-05-10 14:02:10','412',889985.25,873803.70,'412','2022-05-09 14:03:11','797','2022-05-09 14:04:31',10,0),('5','101',257623,'FULL TIME','2022-05-01','2022-05-09 14:05:17','2022-05-10 14:05:17','412',1443525.60,1443525.60,'412','2022-05-09 14:06:04','797','2022-05-09 14:07:18',10,0),('5','101',257624,'FULL TIME','2022-05-02','2022-05-09 14:07:49','2022-05-10 14:07:49','412',1205866.20,1205866.20,'412','2022-05-09 14:08:44','797','2022-05-09 14:10:37',10,0),('5','101',257625,'FULL TIME','2022-05-03','2022-05-09 14:12:10','2022-05-10 14:12:10','412',959747.25,959747.25,'412','2022-05-09 14:13:01','797','2022-05-09 14:14:37',10,0),('5','101',257626,'FULL TIME','2022-05-04','2022-05-09 14:16:52','2022-05-10 14:16:52','412',483022.65,483022.65,'412','2022-05-09 14:17:32','797','2022-05-09 14:20:16',10,0),('5','101',257627,'FULL TIME','2022-05-05','2022-05-10 09:57:07','2022-05-11 09:57:07','412',845519.40,845519.40,'412','2022-05-10 09:59:28','797','2022-05-10 10:02:33',10,0),('5','101',257628,'FULL TIME','2022-05-06','2022-05-10 10:04:55','2022-05-11 10:04:55','412',1041224.25,1041224.25,'412','2022-05-10 10:08:28','797','2022-05-10 10:13:24',10,0),('5','101',257629,'FULL TIME','2022-05-07','2022-05-10 10:14:39','2022-05-11 10:14:39','412',1198604.55,1198604.55,'412','2022-05-10 10:15:46','797','2022-05-10 10:17:01',10,0),('5','101',257630,'FULL TIME','2022-05-08','2022-05-10 10:19:54','2022-05-11 10:19:54','412',1020686.70,1020686.70,'412','2022-05-10 10:21:04','797','2022-05-10 10:22:23',10,0),('5','101',257631,'FULL TIME','2022-05-09','2022-05-10 10:23:51','2022-05-11 10:23:51','412',1764807.00,1764807.00,'412','2022-05-10 10:26:40','797','2022-05-10 10:27:12',10,0),('5','101',257632,'FULL TIME','2022-05-10','2022-05-10 11:25:58','2022-05-11 11:25:58','412',1809815.70,1809815.70,'412','2022-05-10 23:28:41','797','2022-05-11 05:35:12',10,0),('5','101',257633,'FULL TIME','2022-05-11','2022-05-11 10:32:01','2022-05-12 10:32:01','412',1363936.20,1363936.20,'412','2022-05-11 21:53:29','797','2022-05-12 08:28:31',10,0),('5','101',257634,'FULL TIME','2022-05-12','2022-05-12 10:52:47','2022-05-13 10:52:47','412',1256244.00,1256244.00,'412','2022-05-12 23:22:21','797','2022-05-13 09:54:29',10,0),('5','101',257635,'FULL TIME','2022-05-13','2022-05-13 10:34:16','2022-05-14 10:34:16','412',887285.85,887285.85,'412','2022-05-13 23:21:42','797','2022-05-14 14:28:58',10,0),('5','101',257636,'FULL TIME','2022-05-14','2022-05-14 19:35:31','2022-05-15 19:35:31','412',375629.10,375629.10,'412','2022-05-14 22:46:30','797','2022-05-14 22:50:13',10,0),('5','101',257637,'FULL TIME','2022-05-15','2022-05-15 15:31:56','2022-05-16 15:31:56','412',0.00,0.00,'412','2022-05-15 20:07:55','797','2022-05-15 22:51:41',10,0),('5','101',257638,'FULL TIME','2022-05-16','2022-05-16 12:16:17','2022-05-17 12:16:17','412',423030.30,423030.30,'412','2022-05-17 07:09:28','797','2022-05-17 07:26:08',10,0),('5','101',257639,'FULL TIME','2022-05-17','2022-05-17 10:10:29','2022-05-18 10:10:29','412',1518264.00,1518264.00,'412','2022-05-17 22:12:13','797','2022-05-18 07:12:59',10,0),('5','101',257640,'FULL TIME','2022-05-18','2022-05-18 11:42:48','2022-05-19 11:42:48','412',1150625.85,1150625.85,'412','2022-05-18 21:59:43','797','2022-05-19 06:18:42',10,0),('5','101',257641,'FULL TIME','2022-05-19','2022-05-19 08:18:44','2022-05-20 08:18:44','412',686987.40,686987.40,'412','2022-05-19 22:16:00','797','2022-05-19 22:33:54',10,0),('5','101',257642,'FULL TIME','2022-05-20','2022-05-20 10:11:06','2022-05-21 10:11:06','412',660003.30,660003.30,'412','2022-05-20 22:11:03','797','2022-05-20 22:33:47',10,0),('5','101',257643,'FULL TIME','2022-05-21','2022-05-21 10:44:41','2022-05-22 10:44:41','412',543450.60,543450.60,'412','2022-05-21 22:04:45','797','2022-05-21 22:39:39',10,0),('5','101',257644,'FULL TIME','2022-05-22','2022-05-22 08:53:39','2022-05-23 08:53:39','412',1319802.00,1319802.00,'412','2022-05-22 20:43:44','797','2022-05-23 05:42:04',10,0),('5','101',257645,'FULL TIME','2022-05-23','2022-05-23 12:54:09','2022-05-24 12:54:09','412',1351579.35,1351579.35,'412','2022-05-23 21:25:59','797','2022-05-24 06:27:11',10,0),('5','101',257646,'FULL TIME','2022-05-24','2022-05-24 08:51:47','2022-05-25 08:51:47','412',1310015.85,1310015.85,'412','2022-05-24 20:29:34','797','2022-05-25 07:29:58',10,0),('5','101',257647,'FULL TIME','2022-05-25','2022-05-25 09:55:00','2022-05-26 09:55:00','412',728392.50,728392.50,'412','2022-05-25 22:36:41','797','2022-05-26 05:40:28',10,0),('5','101',257648,'FULL TIME','2022-05-26','2022-05-26 10:29:25','2022-05-27 10:29:25','412',903342.00,903342.00,'412','2022-05-26 22:16:43','797','2022-05-27 05:52:40',10,0),('5','101',257649,'FULL TIME','2022-05-27','2022-05-27 10:04:08','2022-05-28 10:04:08','412',1193552.25,1193552.25,'412','2022-05-28 06:28:31','797','2022-05-28 06:57:54',10,0),('5','101',257650,'FULL TIME','2022-05-28','2022-05-28 11:38:13','2022-05-29 11:38:13','412',1014316.05,1014316.05,'412','2022-05-28 22:54:07','797','2022-05-29 09:41:39',10,0),('5','101',257651,'FULL TIME','2022-05-29','2022-05-29 12:21:26','2022-05-30 12:21:26','412',1129156.05,1129156.05,'412','2022-05-29 21:37:29','797','2022-05-30 06:25:17',10,0),('5','101',257652,'FULL TIME','2022-05-30','2022-05-30 08:28:26','2022-05-31 08:28:26','412',681022.65,681022.65,'412','2022-05-30 21:19:47','797','2022-05-31 05:39:38',10,0),('5','101',257653,'FULL TIME','2022-05-31','2022-05-31 09:54:33','2022-06-01 09:54:33','412',331732.50,331732.50,'412','2022-05-31 18:37:15','797','2022-05-31 22:44:29',10,0),('5','101',257654,'FULL TIME','2022-06-01','2022-06-01 11:26:37','2022-06-02 11:26:37','412',0.00,0.00,'412','2022-06-01 20:07:52','797','2022-06-02 05:39:49',10,0),('5','101',257655,'FULL TIME','2022-06-02','2022-06-02 10:51:18','2022-06-03 10:51:18','412',0.00,0.00,'412','2022-06-03 06:24:29','797','2022-06-03 11:42:53',10,0),('5','101',257656,'FULL TIME','2022-06-03','2022-06-03 21:30:36','2022-06-04 21:30:36','412',0.00,0.00,'412','2022-06-03 21:31:12','797','2022-06-03 22:55:39',10,0),('5','101',257657,'FULL TIME','2022-06-04','2022-06-04 20:11:37','2022-06-05 20:11:37','412',200483.25,200483.25,'412','2022-06-05 14:48:28','797','2022-06-05 16:12:23',10,0),('5','101',257658,'FULL TIME','2022-06-05','2022-06-05 17:24:20','2022-06-06 17:24:20','412',858810.15,858810.15,'412','2022-06-05 22:22:18','797','2022-06-06 09:46:04',10,0),('5','101',257659,'FULL TIME','2022-06-06','2022-06-06 10:27:23','2022-06-07 10:27:23','412',805501.95,805501.95,'412','2022-06-06 21:40:46','797','2022-06-07 06:49:46',10,0),('5','101',257660,'FULL TIME','2022-06-07','2022-06-07 21:49:29','2022-06-08 21:49:29','412',445014.90,445014.90,'412','2022-06-07 21:50:38','797','2022-06-08 09:04:26',10,0),('5','101',257661,'FULL TIME','2022-06-08','2022-06-08 15:06:49','2022-06-09 15:06:49','412',167011.35,167011.35,'412','2022-06-08 21:42:03','797','2022-06-08 23:03:38',10,0),('5','101',257662,'FULL TIME','2022-06-09','2022-06-09 11:49:37','2022-06-10 11:49:37','412',0.00,0.00,'412','2022-06-09 21:42:37','797','2022-06-10 05:44:42',10,0),('5','101',257663,'FULL TIME','2022-06-10','2022-06-10 22:14:37','2022-06-11 22:14:37','412',0.00,0.00,'412','2022-06-12 06:24:09','797','2022-06-12 12:33:42',10,0),('5','101',257664,'FULL TIME','2022-06-12','2022-06-13 21:44:13','2022-06-14 21:44:13','412',0.00,0.00,'412','2022-06-13 21:44:29','797','2022-06-13 21:46:59',10,0),('5','101',257665,'FULL TIME','2022-06-13','2022-06-13 22:18:06','2022-06-14 22:18:06','412',0.00,0.00,'412','2022-06-13 22:20:29','797','2022-06-14 06:48:09',10,0),('5','101',257666,'FULL TIME','2022-06-14','2022-06-14 16:36:57','2022-06-15 16:36:57','412',0.00,0.00,'412','2022-06-15 06:21:01','797','2022-06-15 09:31:38',10,0),('5','101',257667,'FULL TIME','2022-06-15','2022-06-15 20:39:24','2022-06-16 20:39:24','412',0.00,0.00,'412','2022-06-15 20:43:15','797','2022-06-16 06:56:50',10,0),('5','101',257668,'FULL TIME','2022-06-16','2022-06-16 22:38:24','2022-06-17 22:38:24','412',0.00,0.00,'412','2022-06-16 22:38:38','797','2022-06-17 07:08:22',10,0),('5','101',257669,'FULL TIME','2022-06-17','2022-06-17 22:25:56','2022-06-18 22:25:56','412',0.00,0.00,'412','2022-06-17 22:26:09','797','2022-06-18 07:31:03',10,0),('5','101',257670,'FULL TIME','2022-06-18','2022-06-18 10:28:06','2022-06-19 10:28:06','412',0.00,0.00,'412','2022-06-18 10:28:21','797','2022-06-18 23:04:18',10,0),('5','101',257671,'FULL TIME','2022-06-19','2022-06-19 21:37:42','2022-06-20 21:37:42','412',0.00,0.00,'412','2022-06-19 21:37:56','797','2022-06-20 06:05:52',10,0),('5','101',257672,'FULL TIME','2022-06-20','2022-06-20 21:28:58','2022-06-21 21:28:58','412',307852.05,307852.05,'412','2022-06-21 08:17:09','797','2022-06-21 13:18:35',10,0),('5','101',257673,'FULL TIME','2022-06-21','2022-06-21 18:31:41','2022-06-22 18:31:41','412',840206.40,840206.40,'412','2022-06-21 21:49:32','797','2022-06-22 07:32:51',10,0),('5','101',257674,'FULL TIME','2022-06-22','2022-06-22 23:43:58','2022-06-23 23:43:58','412',797766.75,797766.75,'412','2022-06-22 23:44:44','797','2022-06-23 05:35:35',10,0),('5','101',257675,'FULL TIME','2022-06-23','2022-06-23 11:15:13','2022-06-24 11:15:13','412',674221.35,674221.35,'412','2022-06-23 21:42:54','797','2022-06-24 07:02:24',10,0),('5','101',257676,'FULL TIME','2022-06-24','2022-06-24 11:09:49','2022-06-25 11:09:49','412',790153.65,790153.65,'412','2022-06-24 21:13:30','797','2022-06-25 07:53:47',10,0),('5','101',257677,'FULL TIME','2022-06-25','2022-06-25 10:49:29','2022-06-26 10:49:29','412',847565.40,847565.40,'412','2022-06-26 08:50:23','797','2022-06-26 09:00:22',10,0),('5','101',257678,'FULL TIME','2022-06-26','2022-06-26 23:01:18','2022-06-27 23:01:18','412',803556.60,803556.60,'412','2022-06-26 23:03:07','797','2022-06-27 09:37:38',10,0),('5','101',257679,'FULL TIME','2022-06-27','2022-06-27 12:35:47','2022-06-28 12:35:47','412',666171.00,666171.00,'412','2022-06-28 09:30:39','797','2022-06-28 09:37:14',10,0),('5','101',257680,'FULL TIME','2022-06-28','2022-06-28 11:04:40','2022-06-29 11:04:40','412',609896.10,609896.10,'412','2022-06-28 22:24:56','797','2022-06-29 09:28:14',10,0),('5','101',257681,'FULL TIME','2022-06-29','2022-06-29 10:08:52','2022-06-30 10:08:52','412',262701.45,262701.45,'412','2022-06-29 22:03:21','797','2022-06-30 07:17:17',10,0),('5','101',257682,'FULL TIME','2022-06-30','2022-06-30 09:49:27','2022-07-01 09:49:27','412',0.00,0.00,'412','2022-06-30 19:42:23','797','2022-07-01 07:30:11',10,0),('5','101',257683,'FULL TIME','2022-07-01','2022-07-01 12:47:03','2022-07-02 12:47:03','412',0.00,0.00,'412','2022-07-01 20:27:38','797','2022-07-02 09:05:23',10,0),('5','101',257684,'FULL TIME','2022-07-02','2022-07-03 07:09:20','2022-07-04 07:09:20','412',0.00,0.00,'412','2022-07-03 07:09:37','797','2022-07-03 09:06:20',10,0),('5','101',257685,'FULL TIME','2022-07-03','2022-07-03 21:51:16','2022-07-04 21:51:16','412',0.00,0.00,'412','2022-07-03 21:51:31','797','2022-07-04 06:59:31',10,0),('5','101',257686,'FULL TIME','2022-07-04','2022-07-05 06:50:31','2022-07-06 06:50:31','412',0.00,0.00,'412','2022-07-05 06:50:45','797','2022-07-05 07:41:57',10,0),('5','101',257687,'FULL TIME','2022-07-06','2022-07-06 00:40:16','2022-07-07 00:40:16','412',225954.30,225954.30,'412','2022-07-06 09:47:52','797','2022-07-06 10:03:15',10,0),('5','101',257688,'FULL TIME','2022-07-06','2022-07-06 10:32:09','2022-07-07 10:32:09','412',829615.05,829615.05,'412','2022-07-06 22:27:47','797','2022-07-07 06:49:44',10,0),('5','101',257689,'FULL TIME','2022-07-07','2022-07-07 11:52:01','2022-07-08 11:52:01','412',660684.75,660684.75,'412','2022-07-07 22:27:28','797','2022-07-08 03:54:49',10,0),('5','101',257690,'FULL TIME','2022-07-08','2022-07-08 08:16:27','2022-07-09 08:16:27','412',661889.25,661889.25,'412','2022-07-08 21:39:42','797','2022-07-09 10:53:25',10,0),('5','101',257691,'FULL TIME','2022-07-09','2022-07-09 10:56:15','2022-07-10 10:56:15','412',640728.00,640728.00,'412','2022-07-09 11:45:17','797','2022-07-09 12:08:03',10,0),('5','101',257692,'New price','2022-07-09','2022-07-09 12:12:15','2022-07-10 12:12:15','412',50940.45,57115.05,'412','2022-07-09 21:49:20','797','2022-07-10 06:53:46',10,0),('5','101',257693,'FULL TIME','2022-07-10','2022-07-10 09:53:18','2022-07-11 09:53:18','412',538984.05,604315.45,'412','2022-07-10 22:39:01','797','2022-07-11 07:39:15',10,0),('5','101',257694,'FULL TIME','2022-07-11','2022-07-11 08:59:16','2022-07-12 08:59:16','412',595546.05,667733.45,'412','2022-07-11 21:48:44','797','2022-07-12 08:41:08',10,0),('5','101',257695,'FULL TIME','2022-07-12','2022-07-12 09:20:12','2022-07-13 09:20:12','412',249494.85,279736.65,'412','2022-07-13 06:26:07','797','2022-07-13 06:51:06',10,0),('5','101',257696,'FULL TIME','2022-07-13','2022-07-13 09:56:56','2022-07-14 09:56:56','412',849210.45,952145.05,'412','2022-07-14 08:20:27','797','2022-07-14 09:29:33',10,0),('5','101',257697,'FULL TIME','2022-07-14','2022-07-14 16:18:46','2022-07-15 16:18:46','412',1287250.35,1287250.35,'412','2022-07-14 23:16:33','797','2022-07-15 06:41:38',10,0),('5','101',257698,'FULL TIME','2022-07-15','2022-07-15 09:42:56','2022-07-16 09:42:56','412',1482168.20,1482168.20,'412','2022-07-15 22:15:57','797','2022-07-16 05:42:38',10,0),('5','101',257699,'FULL TIME','2022-07-16','2022-07-16 14:08:55','2022-07-17 14:08:55','412',1460156.90,1460156.90,'412','2022-07-17 02:16:21','797','2022-07-17 06:04:17',10,0),('5','101',257700,'FULL TIME','2022-07-17','2022-07-17 11:51:48','2022-07-18 11:51:48','412',1558852.55,1558852.55,'412','2022-07-18 10:00:42','797','2022-07-18 10:53:46',10,0),('5','101',257701,'FULL TIME','2022-07-18','2022-07-18 12:52:49','2022-07-19 12:52:49','412',1280845.65,1280845.65,'412','2022-07-18 21:53:07','797','2022-07-19 05:50:21',10,0),('5','101',257702,'FULL TIME','2022-07-19','2022-07-19 10:02:59','2022-07-20 10:02:59','412',1547471.35,1547471.35,'412','2022-07-20 06:52:44','797','2022-07-20 08:01:46',10,0),('5','101',257703,'FULL TIME','2022-07-20','2022-07-20 10:40:45','2022-07-21 10:40:45','412',1486260.40,1486260.40,'412','2022-07-21 07:41:55','797','2022-07-21 07:45:07',10,0),('5','101',257704,'FULL TIME','2022-07-21','2022-07-21 14:24:23','2022-07-22 14:24:23','412',1312447.35,1312447.35,'412','2022-07-21 23:27:44','797','2022-07-22 07:01:54',10,0),('5','101',257705,'FULL TIME','2022-07-22','2022-07-22 09:58:05','2022-07-23 09:58:05','412',2096612.40,2096612.40,'412','2022-07-22 22:08:20','797','2022-07-23 07:29:27',10,0),('5','101',257706,'FULL TIME','2022-07-23','2022-07-23 12:04:15','2022-07-24 12:04:15','412',2311020.00,2311020.00,'412','2022-07-23 20:02:08','797','2022-07-24 06:56:33',10,0),('5','101',257707,'FULL TIME','2022-07-24','2022-07-24 11:15:58','2022-07-25 11:15:58','412',2167791.15,2167791.15,'412','2022-07-24 21:23:13','797','2022-07-25 06:41:43',10,0),('5','101',257708,'FULL TIME','2022-07-25','2022-07-25 17:56:40','2022-07-26 17:56:40','412',1623275.10,1623275.10,'412','2022-07-25 21:41:48','797','2022-07-26 07:41:16',10,0),('5','101',257709,'FULL TIME','2022-07-26','2022-07-26 11:20:28','2022-07-27 11:20:28','412',928960.85,928960.85,'412','2022-07-26 21:08:14','797','2022-07-27 06:56:51',10,0),('5','101',257710,'FULL TIME','2022-07-27','2022-07-27 20:40:16','2022-07-28 20:40:16','412',407401.45,407401.45,'412','2022-07-27 20:45:58','797','2022-07-28 08:10:50',10,0),('5','101',257711,'FULL TIME','2022-07-28','2022-07-28 13:21:11','2022-07-29 13:21:11','412',0.00,0.00,'412','2022-07-28 22:37:35','797','2022-07-29 06:56:49',10,0),('5','101',257712,'FULL TIME','2022-07-29','2022-07-29 16:41:21','2022-07-30 16:41:21','412',0.00,0.00,'412','2022-07-29 22:28:37','797','2022-07-30 07:00:30',10,0),('5','101',257713,'FULL TIME','2022-07-30','2022-07-30 22:19:40','2022-07-31 22:19:40','412',0.00,0.00,'412','2022-07-30 22:21:13','797','2022-07-31 05:58:32',10,0),('5','101',257714,'FULL TIME','2022-07-31','2022-07-31 19:47:59','2022-08-01 19:47:59','412',0.00,0.00,'412','2022-07-31 19:48:26','797','2022-08-01 06:48:40',10,0),('5','101',257715,'FULL TIME','2022-08-01','2022-08-01 22:33:20','2022-08-02 22:33:20','412',0.00,0.00,'412','2022-08-01 22:33:43','797','2022-08-02 07:35:59',10,0),('5','101',257716,'FULL TIME','2022-08-02','2022-08-02 18:16:54','2022-08-03 18:16:54','412',372416.10,372416.10,'412','2022-08-03 10:10:45','797','2022-08-03 10:14:17',10,0),('5','101',257717,'FULL TIME','2022-08-03','2022-08-03 10:15:59','2022-08-04 10:15:59','412',966551.00,966551.00,'412','2022-08-03 20:07:11','797','2022-08-04 06:50:10',10,0),('5','101',257718,'FULL TIME','2022-08-04','2022-08-04 10:29:51','2022-08-05 10:29:51','412',1522067.15,1522067.15,'412','2022-08-04 21:23:04','797','2022-08-05 06:37:18',10,0),('5','101',257719,'FULL TIME','2022-08-05','2022-08-05 09:06:04','2022-08-06 09:06:04','412',1157842.85,1157842.85,'412','2022-08-05 22:49:53','797','2022-08-06 09:10:57',10,0),('5','101',257720,'FULL TIME','2022-08-06','2022-08-06 10:27:06','2022-08-07 10:27:06','412',1219425.65,1219425.65,'412','2022-08-06 21:31:41','797','2022-08-07 07:12:29',10,0),('5','101',257721,'FULL TIME','2022-08-07','2022-08-07 22:11:09','2022-08-08 22:11:09','412',1031341.70,1031341.70,'412','2022-08-07 22:13:36','797','2022-09-03 08:16:16',10,0),('5','101',257722,'FULL TIME','2022-08-08','2022-09-03 20:07:37','2022-09-04 20:07:37','412',941884.95,941884.95,'412','2022-09-03 20:09:57','797','2022-09-04 09:48:34',10,0),('5','101',257723,'FULL TIME','2022-08-09','2022-09-04 13:38:01','2022-09-05 13:38:01','412',1119829.05,1119829.05,'412','2022-09-04 13:40:16','797','2022-09-04 15:22:14',10,0),('5','101',257724,'FULL TIME','2022-08-10','2022-09-04 22:32:46','2022-09-05 22:32:46','412',680354.15,680354.15,'412','2022-09-04 22:35:19','797','2022-09-05 11:11:37',10,0),('5','101',257725,'FULL TIME','2022-08-11','2022-09-05 13:47:40','2022-09-06 13:47:40','412',464747.75,464747.75,'412','2022-09-05 13:53:09','797','2022-09-05 13:54:36',10,0),('5','101',257726,'FULL TIME','2022-08-12','2022-09-05 13:58:07','2022-09-06 13:58:07','412',1025012.85,1025012.85,'412','2022-09-05 14:34:43','797','2022-09-05 14:36:34',10,0),('5','101',257727,'FULL TIME','2022-09-05','2022-09-05 14:37:03','2022-09-06 14:37:03','412',0.00,0.00,'412','2022-09-05 14:42:53','797','2022-09-05 14:46:31',10,0),('5','101',257728,'FULL TIME','2022-08-13','2022-09-05 14:49:59','2022-09-06 14:49:59','412',1069708.85,1069708.85,'412','2022-09-05 14:51:20','797','2022-09-05 14:52:06',10,0),('5','101',257729,'FULL TIME','2022-08-14','2022-09-05 14:53:34','2022-09-06 14:53:34','412',1132301.75,1132301.75,'412','2022-09-05 14:54:44','797','2022-09-05 14:56:05',10,0),('5','101',257730,'FULL TIME','2022-08-15','2022-09-05 15:02:11','2022-09-06 15:02:11','412',1020585.80,1020585.80,'412','2022-09-05 15:05:10','797','2022-09-05 15:09:11',10,0),('5','101',257731,'FULL TIME','2022-08-16','2022-09-05 15:13:34','2022-09-06 15:13:34','412',329331.45,329331.45,'412','2022-09-05 15:14:50','797','2022-09-05 15:17:23',10,0),('5','101',257732,'FULL TIME','2022-08-17','2022-09-05 15:19:43','2022-09-06 15:19:43','412',1157186.10,1157186.10,'412','2022-09-05 15:20:54','797','2022-09-05 15:27:38',10,0),('5','101',257733,'FULL TIME','2022-08-18','2022-09-05 15:29:23','2022-09-06 15:29:23','412',1476756.95,1476756.95,'412','2022-09-05 15:30:25','797','2022-09-05 15:31:21',10,0),('5','101',257734,'FULL TIME','2022-08-19','2022-09-05 15:35:29','2022-09-06 15:35:29','412',848987.20,848987.20,'412','2022-09-05 15:36:53','797','2022-09-05 15:39:41',10,0),('5','101',257735,'FULL TIME','2022-08-20','2022-09-05 15:41:31','2022-09-06 15:41:31','412',1273995.10,1273995.10,'412','2022-09-05 15:43:43','797','2022-09-05 15:44:47',10,0),('5','101',257736,'FULL TIME','2022-08-21','2022-09-05 15:45:27','2022-09-06 15:45:27','412',1199488.20,1199488.20,'412','2022-09-05 15:46:46','797','2022-09-05 16:06:20',10,0),('5','101',257737,'FULL TIME','2022-08-22','2022-09-05 16:19:38','2022-09-06 16:19:38','412',1098444.90,1098444.90,'412','2022-09-05 16:27:16','797','2022-09-05 16:28:59',10,0),('5','101',257738,'FULL TIME','2022-08-23','2022-09-05 16:31:03','2022-09-06 16:31:03','412',1215609.10,1215609.10,'412','2022-09-05 16:42:43','797','2022-09-05 16:45:10',10,0),('5','101',257739,'FULL TIME','2022-08-24','2022-09-05 16:50:43','2022-09-06 16:50:43','412',1316365.65,1316365.65,'412','2022-09-05 16:51:54','797','2022-09-05 16:53:30',10,0),('5','101',257740,'FULL TIME','2022-08-25','2022-09-05 16:54:57','2022-09-06 16:54:57','412',1098300.60,1098300.60,'412','2022-09-05 16:56:05','797','2022-09-05 16:57:35',10,0),('5','101',257741,'FULL TIME','2022-08-26','2022-09-06 13:06:14','2022-09-07 13:06:14','412',1343531.05,1343531.05,'412','2022-09-06 13:07:23','797','2022-09-06 13:08:38',10,0),('5','101',257742,'FULL TIME','2022-08-27','2022-09-06 13:11:23','2022-09-07 13:11:23','412',1080856.95,1080856.95,'412','2022-09-06 13:12:36','797','2022-09-06 13:14:11',10,0),('5','101',257743,'FULL TIME','2022-08-28','2022-09-06 13:15:00','2022-09-07 13:15:00','412',1243544.10,1243544.10,'412','2022-09-06 13:16:02','797','2022-09-06 13:22:38',10,0),('5','101',257744,'FULL TIME','2022-08-29','2022-09-06 13:26:03','2022-09-07 13:26:03','412',985123.15,985123.15,'412','2022-09-06 13:26:59','797','2022-09-06 13:28:56',10,0),('5','101',257745,'FULL TIME','2022-08-30','2022-09-06 13:36:56','2022-09-07 13:36:56','412',1336582.45,1336582.45,'412','2022-09-06 14:05:50','797','2022-09-06 14:08:49',10,0),('5','101',257746,'FULL TIME','2022-08-31','2022-09-06 14:09:35','2022-09-07 14:09:35','412',1241018.85,1241018.85,'412','2022-09-06 14:10:30','797','2022-09-06 14:12:06',10,0),('5','101',257747,'FULL TIME','2022-09-01','2022-09-06 14:13:50','2022-09-07 14:13:50','412',1333073.00,1333073.00,'412','2022-09-06 14:15:09','797','2022-09-06 14:19:03',10,0),('5','101',257748,'FULL TIME','2022-09-02','2022-09-06 14:49:08','2022-09-07 14:49:08','412',1325895.00,1325895.00,'412','2022-09-06 14:49:57','797','2022-09-06 15:06:11',10,0),('5','101',257749,'FULL TIME','2022-09-03','2022-09-06 15:34:58','2022-09-07 15:34:58','412',1409664.85,1409664.85,'412','2022-09-06 15:37:18','797','2022-09-06 15:38:16',10,0),('5','101',257750,'FULL TIME','2022-09-04','2022-09-06 15:39:04','2022-09-07 15:39:04','412',1336765.60,1336765.60,'412','2022-09-06 15:40:34','797','2022-09-06 15:43:12',10,0),('5','101',257751,'FULL TIME','2022-09-05','2022-09-06 15:44:28','2022-09-07 15:44:28','412',1533403.95,1533403.95,'412','2022-09-06 15:45:54','797','2022-09-06 15:46:52',10,0),('5','101',257752,'FULL TIME','2022-09-06','2022-09-06 15:49:26','2022-09-07 15:49:26','412',1566413.50,1566413.50,'412','2022-09-07 08:07:29','797','2022-09-07 09:41:44',10,0),('5','101',257753,'FULL TIME','2022-09-07','2022-09-07 12:55:16','2022-09-08 12:55:16','412',939570.60,939570.60,'412','2022-09-07 23:39:08','797','2022-09-08 09:03:03',10,0),('5','101',257754,'FULL TIME','2022-09-08','2022-09-08 20:53:30','2022-09-09 20:53:30','412',773512.75,773512.75,'412','2022-09-08 22:37:10','797','2022-09-09 07:15:22',10,0),('5','101',257755,'FULL TIME','2022-09-09','2022-09-10 10:50:18','2022-09-11 10:50:18','412',387049.60,387049.60,'412','2022-09-10 12:21:27','797','2022-09-10 12:27:16',10,0),('5','101',257756,'FULL TIME','2022-09-10','2022-09-11 09:09:53','2022-09-12 09:09:53','412',0.00,0.00,'412','2022-09-11 09:10:08','797','2022-09-11 11:04:25',10,0),('5','101',257757,'FULL TIME','2022-09-12','2022-09-12 18:20:42','2022-09-13 18:20:42','412',0.00,0.00,'412','2022-09-12 21:26:15','797','2022-09-13 06:59:32',10,0),('5','101',257758,'FULL TIME','2022-09-13','2022-09-13 21:12:53','2022-09-14 21:12:53','412',353782.90,353782.90,'412','2022-09-14 10:36:53','797','2022-09-14 18:15:24',10,0),('5','101',257759,'FULL TIME','2022-09-14','2022-09-14 22:36:11','2022-09-15 22:36:11','412',822010.50,822010.50,'412','2022-09-14 22:40:42','797','2022-09-15 10:06:03',10,0),('5','101',257760,'FULL TIME','2022-09-15','2022-09-15 11:36:58','2022-09-16 11:36:58','412',1243553.35,1243553.35,'412','2022-09-15 21:25:43','797','2022-09-16 09:34:44',10,0),('5','101',257761,'FULL TIME','2022-09-16','2022-09-16 12:42:42','2022-09-17 12:42:42','412',1217494.25,1217494.25,'412','2022-09-16 22:55:21','797','2022-09-17 07:55:40',10,0),('5','101',257762,'FULL TIME','2022-09-17','2022-09-17 13:59:57','2022-09-18 13:59:57','412',1116684.05,1116684.05,'412','2022-09-17 22:51:28','797','2022-09-18 10:38:17',10,0),('5','101',257763,'FULL TIME','2022-09-18','2022-09-18 22:08:23','2022-09-19 22:08:23','412',1205931.75,1205931.75,'412','2022-09-18 22:13:11','797','2022-09-19 10:43:33',10,0),('5','101',257764,'FULL TIME','2022-09-19','2022-09-20 09:14:13','2022-09-21 09:14:13','412',1347105.25,1347105.25,'412','2022-09-20 09:15:58','797','2022-09-20 09:19:33',10,0),('5','101',257765,'FULL TIME','2022-09-20','2022-09-20 10:22:16','2022-09-21 10:22:16','412',1216371.30,1216371.30,'412','2022-09-20 23:35:16','797','2022-09-21 07:08:05',10,0),('5','101',257766,'FULL TIME','2022-09-21','2022-09-21 22:52:16','2022-09-22 22:52:16','412',1130797.70,1130797.70,'412','2022-09-21 22:53:52','797','2022-09-22 09:15:17',10,0),('5','101',257767,'FULL TIME','2022-09-22','2022-09-22 20:01:05','2022-09-23 20:01:05','412',1350949.55,1350949.55,'412','2022-09-22 22:56:17','797','2022-09-23 10:18:38',10,0),('5','101',257768,'FULL TIME','2022-09-23','2022-09-23 13:40:00','2022-09-24 13:40:00','412',1299554.70,1299554.70,'412','2022-09-23 22:48:01','797','2022-09-24 08:50:14',10,0),('5','101',257769,'FULL TIME','2022-09-24','2022-09-24 22:56:01','2022-09-25 22:56:01','412',1044376.80,1044376.80,'412','2022-09-24 22:58:28','797','2022-09-25 07:05:40',10,0),('5','101',257770,'FULL TIME','2022-09-25','2022-09-25 21:22:43','2022-09-26 21:22:43','412',1450520.25,1293707.25,'412','2022-09-25 21:25:35','797','2022-09-26 10:04:44',10,0),('5','101',257771,'FULL TIME','2022-09-26','2022-09-26 20:56:27','2022-09-27 20:56:27','412',1755992.25,1755992.25,'412','2022-09-26 20:59:55','797','2022-09-27 08:09:12',10,0),('5','101',257772,'FULL TIME','2022-09-27','2022-09-27 11:27:08','2022-09-28 11:27:08','412',1451883.70,1451883.70,'412','2022-09-27 22:49:43','797','2022-09-28 06:40:01',10,0),('5','101',257773,'FULL TIME','2022-09-28','2022-09-28 22:12:40','2022-09-29 22:12:40','412',1275852.50,1275852.50,'412','2022-09-28 22:14:41','797','2022-09-29 07:12:18',10,0),('5','101',257774,'FULL TIME','2022-09-29','2022-09-29 22:42:40','2022-09-30 22:42:40','412',1480127.65,1480127.65,'412','2022-09-29 22:44:46','797','2022-09-30 07:20:18',10,0),('5','101',257775,'FULL TIME','2022-09-30','2022-09-30 11:46:46','2022-10-01 11:46:46','412',1253676.55,1253676.55,'412','2022-09-30 22:41:58','797','2022-10-01 07:32:05',10,0),('5','101',257776,'FULL TIME','2022-10-01','2022-10-01 21:44:21','2022-10-02 21:44:21','412',1494217.25,1494217.25,'412','2022-10-01 21:46:49','797','2022-10-02 06:57:00',10,0),('5','101',257777,'FULL TIME','2022-10-02','2022-10-02 22:22:09','2022-10-03 22:22:09','412',1314214.10,1314214.10,'412','2022-10-02 22:24:30','797','2022-10-03 09:45:49',10,0),('5','101',257778,'FULL TIME','2022-10-03','2022-10-03 20:33:54','2022-10-04 20:33:54','412',1690898.15,1690898.15,'412','2022-10-03 20:36:34','797','2022-10-04 07:11:55',10,0),('5','101',257779,'FULL TIME','2022-10-04','2022-10-04 23:11:18','2022-10-05 23:11:18','412',1389320.40,1389320.40,'412','2022-10-04 23:13:16','797','2022-10-05 10:04:18',10,0),('5','101',257780,'FULL TIME','2022-10-05','2022-10-05 20:20:52','2022-10-06 20:20:52','412',1386776.65,1386776.65,'412','2022-10-05 20:24:58','797','2022-10-06 06:57:05',10,0),('5','101',257781,'FULL TIME','2022-10-06','2022-10-06 12:03:53','2022-10-07 12:03:53','412',1551182.45,1551182.45,'412','2022-10-06 21:20:41','797','2022-10-07 06:56:32',10,0),('5','101',257782,'FULL TIME','2022-10-07','2022-10-07 21:22:22','2022-10-08 21:22:22','412',1285100.65,1285100.65,'412','2022-10-07 21:24:17','797','2022-10-08 11:34:43',10,0),('5','101',257783,'FULL TIME','2022-10-08','2022-10-08 22:47:24','2022-10-09 22:47:24','412',2222684.35,2222684.35,'412','2022-10-08 22:49:20','797','2022-10-09 07:00:31',10,0),('5','101',257784,'FULL TIME','2022-10-09','2022-10-09 21:49:42','2022-10-10 21:49:42','412',587191.85,587191.85,'412','2022-10-09 21:52:02','797','2022-10-10 08:57:24',10,0),('5','101',257785,'FULL TIME','2022-10-10','2022-10-11 12:19:23','2022-10-12 12:19:23','412',0.00,0.00,'412','2022-10-11 12:19:36','797','2022-10-11 13:48:12',10,0),('5','101',257786,'FULL TIME','2022-10-11','2022-10-12 08:03:57','2022-10-13 08:03:57','412',0.00,0.00,'412','2022-10-12 08:05:01','797','2022-10-12 12:29:51',10,0),('5','101',257787,'FULL TIME','2022-10-12','2022-10-13 07:10:30','2022-10-14 07:10:30','412',0.00,0.00,'412','2022-10-13 07:10:44','797','2022-10-13 09:48:32',10,0),('5','101',257788,'FULL TIME','2022-10-13','2022-10-13 21:49:12','2022-10-14 21:49:12','412',0.00,0.00,'412','2022-10-13 21:49:35','797','2022-10-14 10:19:53',10,0),('5','101',257789,'FULL TIME','2022-10-15','2022-10-15 21:32:38','2022-10-16 21:32:38','412',0.00,0.00,'412','2022-10-15 21:32:53','797','2022-10-16 06:59:58',10,0),('5','101',257790,'FULL TIME','2022-10-17','2022-10-17 22:02:13','2022-10-18 22:02:13','412',0.00,0.00,'412','2022-10-17 22:02:30','797','2022-10-18 09:35:01',10,0),('5','101',257791,'FULL TIME','2022-10-18','2022-10-19 11:31:38','2022-10-20 11:31:38','412',0.00,0.00,'412','2022-10-19 11:31:54','797','2022-10-19 11:32:49',10,0),('5','101',257792,'FULL TIME','2022-10-19','2022-10-19 18:54:21','2022-10-20 18:54:21','412',0.00,0.00,'412','2022-10-19 18:54:33','797','2022-10-20 09:01:26',10,0),('5','101',257793,'FULL TIME','2022-10-20','2022-10-20 22:47:12','2022-10-21 22:47:12','412',0.00,0.00,'412','2022-10-20 22:47:26','797','2022-10-21 09:31:59',10,0),('5','101',257794,'FULL TIME','2022-10-21','2022-10-21 21:31:09','2022-10-22 21:31:09','412',220501.50,220501.50,'412','2022-10-21 21:33:35','797','2022-10-23 06:40:17',10,0),('5','101',257795,'FULL TIME','2022-10-22','2022-10-23 09:30:22','2022-10-24 09:30:22','412',0.00,0.00,'412','2022-10-23 09:31:58','797','2022-10-23 10:22:31',10,0),('5','101',257796,'FULL TIME','2022-10-23','2022-10-24 11:31:06','2022-10-25 11:31:06','412',0.00,0.00,'412','2022-10-24 11:31:21','797','2022-10-24 11:34:28',10,0),('5','101',257797,'FULL TIME','2022-10-24','2022-10-24 22:20:19','2022-10-25 22:20:19','412',0.00,0.00,'412','2022-10-24 22:20:37','797','2022-10-25 09:23:40',10,0),('5','101',257798,'FULL TIME','2022-10-25','2022-10-26 06:16:09','2022-10-27 06:16:09','412',0.00,0.00,'412','2022-10-26 06:16:21','797','2022-10-26 07:03:47',10,0),('5','101',257799,'FULL TIME','2022-10-26','2022-10-26 12:43:46','2022-10-27 12:43:46','412',317386.00,317386.00,'412','2022-10-27 10:34:51','797','2022-10-27 10:53:59',10,0),('5','101',257800,'FULL TIME','2022-10-27','2022-10-27 16:44:40','2022-10-28 16:44:40','412',1817136.60,1817136.60,'412','2022-10-27 22:25:27','797','2022-10-28 06:54:11',10,0),('5','101',257801,'FULL TIME','2022-10-28','2022-10-28 21:04:45','2022-10-29 21:04:45','412',1256194.40,1256194.40,'412','2022-10-28 21:07:46','797','2022-10-29 08:36:36',10,0),('5','101',257802,'FULL TIME','2022-10-29','2022-10-29 22:46:23','2022-10-30 22:46:23','412',1605435.55,1605435.55,'412','2022-10-29 22:50:44','797','2022-10-30 06:54:35',10,0),('5','101',257803,'FULL TIME','2022-10-30','2022-10-30 22:03:43','2022-10-31 22:03:43','412',2115153.10,2115153.10,'412','2022-10-30 22:05:43','797','2022-10-31 07:01:31',10,0),('5','101',257804,'FULL TIME','2022-10-31','2022-10-31 14:29:30','2022-11-01 14:29:30','412',2303098.30,2303098.30,'412','2022-10-31 21:36:04','797','2022-11-01 06:57:48',10,0),('5','101',257805,'FULL TIME','2022-11-01','2022-11-01 12:56:10','2022-11-02 12:56:10','412',2359874.80,2359874.80,'412','2022-11-01 20:11:32','797','2022-11-02 07:05:37',10,0),('5','101',257806,'FULL TIME','2022-11-02','2022-11-02 08:01:41','2022-11-03 08:01:41','412',2274179.10,2274179.10,'412','2022-11-03 09:10:32','797','2022-11-03 09:14:23',10,0),('5','101',257807,'FULL TIME','2022-11-03','2022-11-03 16:36:34','2022-11-04 16:36:34','412',2287071.75,2287071.75,'412','2022-11-03 21:32:20','797','2022-11-04 07:01:50',10,0),('5','101',257808,'FULL TIME','2022-11-04','2022-11-04 23:17:11','2022-11-05 23:17:11','412',2215202.95,2215202.95,'412','2022-11-04 23:19:03','797','2022-11-05 07:24:33',10,0),('5','101',257809,'FULL TIME','2022-11-05','2022-11-05 21:32:03','2022-11-06 21:32:03','412',1886435.75,1886435.75,'412','2022-11-05 21:34:54','797','2022-11-06 08:15:46',10,0),('5','101',257810,'FULL TIME','2022-11-06','2022-11-06 08:28:11','2022-11-07 08:28:11','412',2217115.85,2217115.85,'412','2022-11-07 07:16:47','797','2022-11-07 14:46:37',10,0),('5','101',257811,'FULL TIME','2022-11-07','2022-11-07 22:36:10','2022-11-08 22:36:10','412',1884704.15,1884704.15,'412','2022-11-07 22:37:41','797','2022-11-08 07:42:35',10,0),('5','101',257812,'FULL TIME','2022-11-08','2022-11-08 22:09:21','2022-11-09 22:09:21','412',568941.60,568941.60,'412','2022-11-08 22:16:53','797','2022-11-09 08:36:04',10,0),('5','101',257813,'FULL TIME','2022-11-09','2022-11-09 21:08:41','2022-11-10 21:08:41','412',0.00,0.00,'412','2022-11-09 21:09:02','797','2022-11-10 10:43:13',10,0),('5','101',257814,'FULL TIME','2022-11-10','2022-11-10 22:12:34','2022-11-11 22:12:34','412',0.00,0.00,'412','2022-11-10 22:12:51','797','2022-11-11 11:26:49',10,0),('5','101',257815,'FULL TIME','2022-11-11','2022-11-11 22:02:51','2022-11-12 22:02:51','412',0.00,0.00,'412','2022-11-11 22:03:55','797','2022-11-12 10:01:45',10,0),('5','101',257816,'FULL TIME','2022-11-12','2022-11-12 20:10:23','2022-11-13 20:10:23','412',0.00,0.00,'412','2022-11-12 20:10:39','797','2022-11-12 23:50:24',10,0),('5','101',257817,'FULL TIME','2022-11-13','2022-11-14 07:55:51','2022-11-15 07:55:51','412',0.00,0.00,'412','2022-11-14 07:56:07','797','2022-11-14 09:06:25',10,0),('5','101',257818,'FULL TIME','2022-11-14','2022-11-15 07:38:36','2022-11-16 07:38:36','412',0.00,0.00,'412','2022-11-15 07:38:51','797','2022-11-15 11:45:03',10,0),('5','101',257819,'FULL TIME','2022-11-15','2022-11-15 20:51:06','2022-11-16 20:51:06','412',0.00,0.00,'412','2022-11-15 20:51:27','797','2022-11-16 07:51:50',10,0),('5','101',257820,'FULL TIME','2022-11-16','2022-11-16 19:13:23','2022-11-17 19:13:23','412',0.00,0.00,'412','2022-11-16 19:13:40','797','2022-11-17 09:36:24',10,0),('5','101',257821,'FULL TIME','2022-11-17','2022-11-18 08:13:59','2022-11-19 08:13:59','412',0.00,0.00,'412','2022-11-18 08:14:17','797','2022-11-18 08:20:37',10,0),('5','101',257822,'FULL TIME','2022-11-18','2022-11-18 18:54:27','2022-11-19 18:54:27','412',0.00,0.00,'412','2022-11-18 18:54:54','797','2022-11-19 09:16:05',10,0),('5','101',257823,'FULL TIME','2022-11-19','2022-11-19 21:00:54','2022-11-20 21:00:54','412',0.00,0.00,'412','2022-11-19 21:01:44','797','2022-11-20 07:28:42',10,0),('5','101',257824,'FULL TIME','2022-11-20','2022-11-20 22:15:23','2022-11-21 22:15:23','412',0.00,0.00,'412','2022-11-20 22:15:37','797','2022-11-21 09:35:32',10,0),('5','101',257825,'FULL TIME','2022-11-21','2022-11-21 22:02:19','2022-11-22 22:02:19','412',280095.55,280095.55,'412','2022-11-22 08:02:40','797','2022-11-22 09:02:18',10,0),('5','101',257826,'FULL TIME','2022-11-22','2022-11-22 15:16:42','2022-11-23 15:16:42','412',1315377.75,1315377.75,'412','2022-11-22 22:37:35','797','2022-11-23 09:38:12',10,0),('5','101',257827,'FULL TIME','2022-11-23','2022-11-23 12:37:08','2022-11-24 12:37:08','412',1116354.75,1116354.75,'412','2022-11-23 21:46:46','797','2022-11-24 08:57:04',10,0),('5','101',257828,'FULL TIME','2022-11-24','2022-11-24 20:50:54','2022-11-25 20:50:54','412',535785.90,535785.90,'412','2022-11-24 20:55:48','797','2022-11-25 11:12:57',10,0),('5','101',257829,'FULL TIME','2022-11-25','2022-11-25 19:23:52','2022-11-26 19:23:52','412',0.00,0.00,'412','2022-11-25 19:24:11','797','2022-11-26 07:44:17',10,0),('5','101',257830,'FULL TIME','2022-11-26','2022-11-26 19:08:05','2022-11-27 19:08:05','412',0.00,0.00,'412','2022-11-26 19:08:20','797','2022-11-27 08:58:38',10,0),('5','101',257831,'FULL TIME','2022-11-27','2022-11-28 00:23:13','2022-11-29 00:23:13','412',0.00,0.00,'412','2022-11-28 00:23:25','797','2022-11-28 09:46:28',10,0),('5','101',257832,'FULL TIME','2022-11-28','2022-11-28 21:30:01','2022-11-29 21:30:01','412',0.00,0.00,'412','2022-11-28 21:30:14','797','2022-11-29 09:44:19',10,0),('5','101',257833,'FULL TIME','2022-11-29','2022-11-29 22:53:52','2022-11-30 22:53:52','412',0.00,0.00,'412','2022-11-29 22:54:06','797','2022-11-30 06:42:35',10,0),('5','101',257834,'FULL TIME','2022-11-30','2022-11-30 21:38:46','2022-12-01 21:38:46','412',0.00,0.00,'412','2022-11-30 21:39:00','797','2022-12-01 10:43:09',10,0),('5','101',257835,'FULL TIME','2022-12-01','2022-12-02 10:02:34','2022-12-03 10:02:34','412',895527.65,895527.65,'412','2022-12-02 10:04:39','797','2022-12-02 13:37:05',10,0),('5','101',257836,'FULL TIME','2022-12-02','2022-12-02 22:25:54','2022-12-03 22:25:54','412',1582192.15,1582192.15,'412','2022-12-02 22:27:49','797','2022-12-03 10:10:45',10,0),('5','101',257837,'FULL TIME','2022-12-03','2022-12-03 22:12:26','2022-12-04 22:12:26','412',1641527.20,1641527.20,'412','2022-12-03 22:15:14','797','2022-12-04 09:47:07',10,0),('5','101',257838,'FULL TIME','2022-12-04','2022-12-04 21:08:29','2022-12-05 21:08:29','412',1617982.25,1617982.25,'412','2022-12-04 21:11:03','797','2022-12-05 09:02:52',10,0),('5','101',257839,'FULL TIME','2022-12-05','2022-12-05 16:25:59','2022-12-06 16:25:59','412',1013896.20,1013896.20,'412','2022-12-05 22:43:36','797','2022-12-06 09:21:43',10,0),('5','101',257840,'FULL TIME','2022-12-06','2022-12-06 11:39:07','2022-12-07 11:39:07','412',514196.40,514196.40,'412','2022-12-06 22:10:56','797','2022-12-07 09:09:26',10,0),('5','101',257841,'FULL TIME','2022-12-07','2022-12-07 21:15:59','2022-12-08 21:15:59','412',0.00,0.00,'412','2022-12-07 21:16:12','797','2022-12-08 09:25:26',10,0),('5','101',257842,'FULL TIME','2022-12-08','2022-12-08 21:05:31','2022-12-09 21:05:31','412',0.00,0.00,'412','2022-12-08 21:05:45','797','2022-12-09 09:15:25',10,0),('5','101',257843,'FULL TIME','2022-12-09','2022-12-09 21:52:18','2022-12-10 21:52:18','412',0.00,0.00,'412','2022-12-09 21:52:35','797','2022-12-10 08:51:09',10,0),('5','101',257844,'FULL TIME','2022-12-10','2022-12-10 20:42:06','2022-12-11 20:42:06','412',0.00,0.00,'412','2022-12-10 20:42:24','797','2022-12-11 12:25:39',10,0),('5','101',257845,'FULL TIME','2022-12-11','2022-12-12 11:10:59','2022-12-13 11:10:59','412',0.00,0.00,'412','2022-12-12 11:11:10','797','2022-12-12 11:22:24',10,0),('5','101',257846,'FULL TIME','2022-12-12','2022-12-12 20:49:15','2022-12-13 20:49:15','412',0.00,0.00,'412','2022-12-12 20:49:42','600','2022-12-13 09:22:24',10,0),('5','101',257847,'FULL TIME','2022-12-13','2022-12-13 22:23:43','2022-12-14 22:23:43','412',0.00,0.00,'412','2022-12-13 22:24:02','600','2022-12-14 09:42:46',10,0),('5','101',257848,'FULL TIME','2022-12-14','2022-12-14 23:00:14','2022-12-15 23:00:14','412',0.00,0.00,'412','2022-12-14 23:00:36','600','2022-12-15 09:01:28',10,0),('5','101',257849,'FULL TIME','2022-12-15','2022-12-15 18:56:54','2022-12-16 18:56:54','412',0.00,0.00,'412','2022-12-15 18:57:12','600','2022-12-16 09:09:59',10,0),('5','101',257850,'FULL TIME','2022-12-16','2022-12-16 21:54:39','2022-12-17 21:54:39','412',0.00,0.00,'412','2022-12-16 21:55:01','600','2022-12-17 10:27:51',10,0),('5','101',257851,'FULL TIME','2022-12-17','2022-12-17 20:55:45','2022-12-18 20:55:45','412',0.00,0.00,'412','2022-12-17 20:56:04','600','2022-12-18 09:25:58',10,0),('5','101',257852,'FULL TIME','2022-12-18','2022-12-18 22:43:12','2022-12-19 22:43:12','412',429392.40,429392.40,'412','2022-12-19 10:40:30','600','2022-12-19 10:59:53',10,0),('5','101',257853,'FULL TIME','2022-12-19','2022-12-19 12:45:27','2022-12-20 12:45:27','412',1482937.80,1482937.80,'412','2022-12-19 21:19:25','600','2022-12-20 08:54:19',10,0),('5','101',257854,'FULL TIME','2022-12-20','2022-12-20 22:18:40','2022-12-21 22:18:40','412',1772005.85,1772005.85,'412','2022-12-20 22:23:02','600','2022-12-21 09:26:35',10,0),('5','101',257855,'FULL TIME','2022-12-21','2022-12-21 13:19:54','2022-12-22 13:19:54','412',1341768.00,1341768.00,'412','2022-12-22 06:15:58','600','2022-12-22 09:44:55',10,0),('5','101',257856,'FULL TIME','2022-12-22','2022-12-22 11:31:37','2022-12-23 11:31:37','412',506726.10,506726.10,'412','2022-12-22 21:13:26','600','2022-12-23 09:47:00',10,0),('5','101',257857,'FULL TIME','2022-12-23','2022-12-23 21:39:33','2022-12-24 21:39:33','412',0.00,0.00,'412','2022-12-23 21:39:48','600','2022-12-24 07:16:00',10,0),('5','101',257858,'FULL TIME','2022-12-24','2022-12-24 22:06:16','2022-12-25 22:06:16','412',0.00,0.00,'412','2022-12-24 22:06:30','600','2022-12-25 09:30:06',10,0),('5','101',257859,'FULL TIME','2022-12-25','2022-12-25 21:08:07','2022-12-26 21:08:07','412',0.00,0.00,'412','2022-12-25 21:08:37','600','2022-12-26 10:03:49',10,0),('5','101',257860,'FULL TIME','2022-12-26','2022-12-26 21:04:49','2022-12-27 21:04:49','412',0.00,0.00,'412','2022-12-26 21:05:02','600','2022-12-27 09:33:20',10,0),('5','101',257861,'FULL TIME','2022-12-27','2022-12-27 18:54:43','2022-12-28 18:54:43','412',0.00,0.00,'412','2022-12-27 18:54:56','600','2022-12-28 09:30:26',10,0),('5','101',257862,'FULL TIME','2022-12-28','2022-12-28 22:47:37','2022-12-29 22:47:37','412',0.00,0.00,'412','2022-12-28 22:47:48','600','2022-12-29 09:36:30',10,0),('5','101',257863,'FULL TIME','2022-12-29','2022-12-30 07:46:37','2022-12-31 07:46:37','412',0.00,0.00,'412','2022-12-30 07:46:52','600','2022-12-30 10:24:04',10,0),('5','101',257864,'FULL TIME','2022-12-30','2022-12-30 21:12:10','2022-12-31 21:12:10','412',0.00,0.00,'412','2022-12-30 21:12:25','600','2022-12-31 09:16:09',10,0),('5','101',257865,'FULL TIME','2022-12-31','2022-12-31 22:32:52','2023-01-01 22:32:52','412',0.00,0.00,'412','2022-12-31 22:33:21','600','2023-01-01 09:24:29',10,0),('5','101',257866,'FULL TIME','2023-01-01','2023-01-01 23:21:26','2023-01-02 23:21:26','412',0.00,0.00,'412','2023-01-01 23:21:37','600','2023-01-02 08:52:38',10,0),('5','101',257867,'FULL TIME','2023-01-02','2023-01-02 22:51:09','2023-01-03 22:51:09','412',0.00,0.00,'412','2023-01-02 22:51:25','600','2023-01-03 07:37:22',10,0),('5','101',257868,'FULL TIME','2023-01-03','2023-01-03 21:27:20','2023-01-04 21:27:20','412',0.00,0.00,'412','2023-01-03 21:27:33','600','2023-01-04 09:13:58',10,0),('5','101',257869,'FULL TIME','2023-01-04','2023-01-04 20:33:16','2023-01-05 20:33:16','412',0.00,0.00,'412','2023-01-04 20:34:27','600','2023-01-05 09:53:04',10,0),('5','101',257870,'FULL TIME','2023-01-05','2023-01-05 19:23:36','2023-01-06 19:23:36','412',0.00,0.00,'412','2023-01-05 19:23:48','600','2023-01-06 10:15:06',10,0),('5','101',257871,'FULL TIME','2023-01-07','2023-01-07 19:50:19','2023-01-08 19:50:19','412',0.00,0.00,'412','2023-01-07 19:50:33','600','2023-01-08 12:43:07',10,0),('5','101',257872,'FULL TIME','2023-01-08','2023-01-08 21:57:31','2023-01-09 21:57:31','412',0.00,0.00,'412','2023-01-08 21:57:50','600','2023-01-09 06:37:53',10,0),('5','101',257873,'FULL TIME','2023-01-09','2023-01-09 20:22:48','2023-01-10 20:22:48','412',0.00,0.00,'412','2023-01-09 20:23:04','600','2023-01-10 08:27:35',10,0),('5','101',257874,'FULL TIME','2023-01-10','2023-01-10 22:47:19','2023-01-11 22:47:19','412',0.00,0.00,'412','2023-01-10 22:47:32','600','2023-01-11 08:25:31',10,0),('5','101',257875,'FULL TIME','2023-01-11','2023-01-11 22:23:10','2023-01-12 22:23:10','412',0.00,0.00,'412','2023-01-11 22:23:23','600','2023-01-12 06:19:42',10,0),('5','101',257876,'FULL TIME','2023-01-13','2023-01-14 07:19:55','2023-01-15 07:19:55','412',0.00,0.00,'412','2023-01-14 07:20:08','600','2023-01-14 14:43:11',10,0),('5','101',257877,'FULL TIME','2023-01-14','2023-01-14 21:20:57','2023-01-15 21:20:57','412',0.00,0.00,'412','2023-01-14 21:21:15','600','2023-01-15 09:27:14',10,0),('5','101',257878,'FULL TIME','2023-01-15','2023-01-15 23:30:35','2023-01-16 23:30:35','412',0.00,0.00,'412','2023-01-15 23:30:52','600','2023-01-16 08:24:32',10,0),('5','101',257879,'FULL TIME','2023-01-16','2023-01-16 22:06:23','2023-01-17 22:06:23','412',0.00,0.00,'412','2023-01-16 22:06:37','600','2023-01-17 08:21:07',10,0),('5','101',257880,'FULL TIME','2023-01-17','2023-01-17 20:27:28','2023-01-18 20:27:28','412',1981403.65,1981403.65,'412','2023-01-18 11:15:42','600','2023-01-18 11:17:00',10,0),('5','101',257881,'FULL TIME','2023-01-18','2023-01-19 05:56:05','2023-01-20 05:56:05','412',779849.00,682894.80,'412','2023-01-19 05:57:40','600','2023-01-19 08:24:04',10,0),('5','101',257882,'FULL TIME','2023-01-19','2023-01-19 09:43:43','2023-01-20 09:43:43','412',1935318.30,1935318.30,'412','2023-01-19 21:57:54','600','2023-01-20 08:29:52',10,0),('5','101',257883,'Morning','2023-01-20','2023-01-20 15:17:37','2023-01-21 15:17:37','412',1072169.35,1072169.35,'412','2023-01-20 15:18:38','600','2023-01-20 15:24:42',10,0),('5','101',257884,'Afternoon','2023-01-20','2023-01-20 16:59:30','2023-01-21 16:59:30','412',1043044.80,1240377.60,'412','2023-01-20 22:40:28','600','2023-01-21 10:05:12',10,0),('5','101',257885,'FULL TIME','2023-01-21','2023-01-21 22:47:59','2023-01-22 22:47:59','412',1987617.80,2363653.60,'412','2023-01-21 22:49:14','600','2023-01-22 09:28:53',10,0),('5','101',257886,'FULL TIME','2023-01-22','2023-01-22 21:16:15','2023-01-23 21:16:15','412',1558671.40,1558671.40,'412','2023-01-22 21:19:14','600','2023-01-23 08:15:52',10,0),('5','101',257887,'FULL TIME','2023-01-23','2023-01-24 11:09:58','2023-01-25 11:09:58','412',1830296.60,1830296.60,'412','2023-01-24 11:15:13','600','2023-01-24 13:22:02',10,0),('5','101',257888,'FULL TIME','2023-01-24','2023-01-24 22:15:54','2023-01-25 22:15:54','412',1098900.00,1098900.00,'412','2023-01-24 22:17:02','600','2023-01-25 09:01:18',10,0),('5','101',257889,'FULL TIME','2023-01-25','2023-01-25 09:35:18','2023-01-26 09:35:18','412',0.00,0.00,'412','2023-01-25 21:58:48','600','2023-01-26 08:58:06',10,0),('5','101',257890,'FULL TIME','2023-01-26','2023-01-26 21:01:44','2023-01-27 21:01:44','412',0.00,0.00,'412','2023-01-26 21:02:00','600','2023-01-27 09:31:10',10,0),('5','101',257891,'FULL TIME','2023-01-27','2023-01-27 22:28:34','2023-01-28 22:28:34','412',1816331.00,1816331.00,'412','2023-01-28 16:58:34','600','2023-01-28 17:04:00',10,0),('5','101',257892,'FULL TIME','2023-01-28','2023-01-28 21:49:57','2023-01-29 21:49:57','412',1577248.20,1577248.20,'412','2023-01-28 21:51:14','600','2023-01-29 11:56:08',10,0),('5','101',257893,'FULL TIME','2023-01-29','2023-01-29 23:15:26','2023-01-30 23:15:26','412',693640.20,693640.20,'412','2023-01-29 23:16:40','600','2023-01-30 08:57:39',10,0),('5','101',257894,'FULL TIME','2023-01-30','2023-01-30 16:51:49','2023-01-31 16:51:49','412',0.00,0.00,'412','2023-01-30 21:43:44','600','2023-01-31 10:00:03',10,0),('5','101',257895,'FULL TIME','2023-01-31','2023-01-31 21:56:50','2023-02-01 21:56:50','412',0.00,0.00,'412','2023-01-31 21:57:01','600','2023-02-01 07:25:10',10,0),('5','101',257896,'FULL TIME','2023-02-01','2023-02-01 21:33:55','2023-02-02 21:33:55','412',0.00,0.00,'412','2023-02-02 14:53:37','600','2023-02-02 21:06:38',10,0),('5','101',257897,'FULL TIME','2023-02-02','2023-02-02 22:18:58','2023-02-03 22:18:58','412',0.00,0.00,'412','2023-02-02 22:19:17','600','2023-02-03 09:11:19',10,0),('5','101',257898,'FULL TIME','2023-02-03','2023-02-03 22:46:22','2023-02-04 22:46:22','412',0.00,0.00,'412','2023-02-03 22:46:35','600','2023-02-04 13:16:37',10,0),('5','101',257899,'FULL TIME','2023-02-04','2023-02-04 21:22:40','2023-02-05 21:22:40','412',0.00,0.00,'412','2023-02-04 21:29:32','600','2023-02-05 15:04:30',10,0),('5','101',257900,'FULL TIME','2023-02-05','2023-02-05 22:36:32','2023-02-06 22:36:32','412',0.00,0.00,'412','2023-02-05 22:36:53','600','2023-02-06 08:54:59',10,0),('5','101',257901,'FULL TIME','2023-02-06','2023-02-06 21:55:10','2023-02-07 21:55:10','412',0.00,0.00,'412','2023-02-06 21:55:31','600','2023-02-07 09:06:57',10,0),('5','101',257902,'FULL TIME','2023-02-07','2023-02-07 22:45:40','2023-02-08 22:45:40','412',0.00,0.00,'412','2023-02-07 22:45:53','600','2023-02-08 08:40:29',10,0),('5','101',257903,'FULL TIME','2023-02-08','2023-02-08 21:47:07','2023-02-09 21:47:07','412',2113003.20,2113003.20,'412','2023-02-08 21:53:35','600','2023-02-09 08:28:26',10,0),('5','101',257904,'FULL TIME','2023-02-09','2023-02-09 22:39:12','2023-02-10 22:39:12','412',2022915.40,2022915.40,'412','2023-02-09 22:40:41','600','2023-02-10 09:21:59',10,0),('5','101',257905,'FULL TIME','2023-02-10','2023-02-10 23:26:49','2023-02-11 23:26:49','412',1429225.60,1429225.60,'412','2023-02-10 23:28:15','600','2023-02-11 13:57:12',10,0),('5','101',257906,'FULL TIME','2023-02-11','2023-02-11 23:36:07','2023-02-12 23:36:07','412',1034693.00,1034693.00,'412','2023-02-11 23:38:41','600','2023-02-12 14:13:10',10,0),('5','101',257907,'FULL TIME','2023-02-13','2023-02-13 07:41:51','2023-02-14 07:41:51','412',0.00,0.00,'412','2023-02-13 07:43:38','600','2023-02-13 09:03:56',10,0),('5','101',257908,'FULL TIME','2023-02-13','2023-02-13 22:50:38','2023-02-14 22:50:38','412',0.00,0.00,'412','2023-02-13 22:50:52','600','2023-02-14 09:32:14',10,0),('5','101',257909,'FULL TIME','2023-02-14','2023-02-14 21:01:16','2023-02-15 21:01:16','412',0.00,0.00,'412','2023-02-14 21:01:27','600','2023-02-15 08:56:03',10,0),('5','101',257910,'FULL TIME','2023-02-15','2023-02-15 22:36:03','2023-02-16 22:36:03','412',0.00,0.00,'412','2023-02-15 22:36:17','600','2023-02-16 11:48:12',10,0),('5','101',257911,'FULL TIME','2023-02-18','2023-02-19 08:18:51','2023-02-20 08:18:51','412',0.00,0.00,'412','2023-02-19 08:19:04','600','2023-02-19 17:37:53',10,0),('5','101',257912,'FULL TIME','2023-02-23','2023-02-23 23:13:35','2023-02-24 23:13:35','412',0.00,0.00,'412','2023-02-23 23:13:49','600','2023-02-24 09:06:43',10,0),('5','101',257913,'FULL TIME','2023-02-24','2023-02-24 23:38:44','2023-02-25 23:38:44','412',0.00,0.00,'412','2023-02-24 23:39:02','600','2023-02-25 10:42:54',10,0),('5','101',257914,'FULL TIME','2023-02-26','2023-02-26 23:25:07','2023-02-27 23:25:07','412',2521856.40,2521856.40,'412','2023-02-27 06:38:57','600','2023-02-27 09:23:48',10,0),('5','101',257915,'FULL TIME','2023-02-27','2023-02-27 23:29:15','2023-02-28 23:29:15','412',2270727.90,2270727.90,'412','2023-02-27 23:30:37','600','2023-02-28 08:30:14',10,0),('5','101',257916,'FULL TIME','2023-02-28','2023-02-28 23:06:26','2023-03-01 23:06:26','412',2337493.20,2337493.20,'412','2023-02-28 23:07:46','600','2023-03-01 10:04:54',10,0),('5','101',257917,'FULL TIME','2023-03-01','2023-03-01 22:58:00','2023-03-02 22:58:00','412',2408670.60,2408670.60,'412','2023-03-01 22:59:18','600','2023-03-02 09:11:06',10,0),('5','101',257918,'FULL TIME','2023-03-02','2023-03-02 22:40:13','2023-03-03 22:40:13','412',2123725.80,2123725.80,'412','2023-03-02 22:41:40','600','2023-03-03 08:16:13',10,0),('5','101',257919,'FULL TIME','2023-03-03','2023-03-03 23:21:46','2023-03-04 23:21:46','412',2473529.10,2473529.10,'412','2023-03-03 23:23:28','600','2023-03-04 13:37:20',10,0),('5','101',257920,'FULL TIME','2023-03-04','2023-03-04 22:12:21','2023-03-05 22:12:21','412',2660786.10,2660786.10,'412','2023-03-04 22:47:16','600','2023-03-05 11:21:54',10,0),('5','101',257921,'FULL TIME','2023-03-05','2023-03-06 07:08:42','2023-03-07 07:08:42','412',2253816.60,2253816.60,'412','2023-03-06 07:10:08','600','2023-03-06 09:39:16',10,0),('5','101',257922,'FULL TIME','2023-03-06','2023-03-07 10:17:59','2023-03-08 10:17:59','412',2377998.00,2491236.00,'412','2023-03-07 10:19:00','600','2023-03-08 09:16:51',10,0),('5','101',257923,'FULL TIME','2023-03-08','2023-03-08 09:58:54','2023-03-09 09:58:54','412',2702683.20,2702683.20,'412','2023-03-08 10:24:37','600','2023-03-08 10:50:50',10,0),('5','101',257924,'FULL TIME','2023-03-08','2023-03-08 11:57:52','2023-03-09 11:57:52','412',2648669.10,2648669.10,'412','2023-03-08 23:08:20','600','2023-03-09 06:08:27',10,0),('5','101',257925,'FULL TIME','2023-03-09','2023-03-09 11:11:35','2023-03-10 11:11:35','412',2445309.30,2445309.30,'412','2023-03-09 22:41:04','600','2023-03-10 06:35:00',10,0),('5','101',257926,'FULL TIME','2023-03-10','2023-03-10 12:16:00','2023-03-11 12:16:00','412',2144538.90,2144538.90,'412','2023-03-11 00:09:01','600','2023-03-11 22:51:22',10,0),('5','101',257927,'FULL TIME','2023-03-11','2023-03-12 05:51:08','2023-03-13 05:51:08','412',3001813.50,3144757.00,'412','2023-03-12 08:32:04','600','2023-03-12 09:19:48',10,0),('5','101',257928,'FULL TIME','2023-03-12','2023-03-13 06:08:23','2023-03-14 06:08:23','412',2342726.40,2342726.40,'412','2023-03-13 06:10:20','600','2023-03-13 08:18:27',10,0),('5','101',257929,'FULL TIME','2023-03-13','2023-03-13 15:28:45','2023-03-14 15:28:45','412',2843595.30,2843595.30,'412','2023-03-13 21:38:32','600','2023-03-14 09:19:21',10,0),('5','101',257930,'FULL TIME','2023-03-14','2023-03-14 11:32:52','2023-03-15 11:32:52','412',2497721.10,2497721.10,'412','2023-03-14 23:27:55','600','2023-03-15 08:23:17',10,0),('5','101',257931,'FULL TIME','2023-03-15','2023-03-15 21:58:59','2023-03-16 21:58:59','412',2270295.30,2270295.30,'412','2023-03-15 22:01:09','600','2023-03-16 05:25:01',10,0),('5','101',257932,'FULL TIME','2023-03-16','2023-03-17 08:22:15','2023-03-18 08:22:15','412',2269308.30,2269308.30,'412','2023-03-17 08:23:47','600','2023-03-17 12:00:05',10,0),('5','101',257933,'FULL TIME','2023-03-17','2023-03-17 22:24:25','2023-03-18 22:24:25','412',2344314.00,2344314.00,'412','2023-03-17 22:26:40','600','2023-03-18 10:11:04',10,0),('5','101',257934,'FULL TIME','2023-03-18','2023-03-18 20:21:12','2023-03-19 20:21:12','412',0.00,0.00,'412','2023-03-18 20:21:27','600','2023-03-19 07:20:23',10,0),('5','101',257935,'FULL TIME','2023-03-19','2023-03-19 22:42:53','2023-03-20 22:42:53','412',0.00,0.00,'412','2023-03-19 22:43:07','600','2023-03-20 08:39:26',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4911662 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('5','101','620','80480',1604480,'1732','240',107538.46,108860.72,1322.26,185116.40,0.00,0.00,0.00,0.00,0.00),('5','101','620','80480',1604481,'1733','240',72457.23,72457.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80480',1604482,'1734','240',77264.98,77328.10,63.12,8836.80,0.00,0.00,0.00,0.00,0.00),('5','101','620','80480',1604483,'1735','240',41414.49,44346.39,2931.90,410466.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','80480',1604484,'1736','240',105348.84,108279.16,2930.32,410244.80,0.00,0.00,0.00,0.00,0.00),('5','101','621','80480',1604485,'1737','240',11230.85,11230.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','80480',1604486,'1738','240',50491.26,52741.96,2250.70,315098.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','80480',1604487,'1739','240',39940.30,39940.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','80480',1604488,'1740','241',12995.68,12995.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','80480',1604489,'1741','241',23829.42,24158.59,329.17,83938.35,0.00,0.00,0.00,0.00,0.00),('5','101','623','80480',1604490,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80484',1604560,'1732','240',108860.72,109969.28,1108.56,155198.40,0.00,0.00,0.00,0.00,0.00),('5','101','620','80484',1604561,'1733','240',72457.23,74954.32,2497.09,349592.60,0.00,0.00,0.00,0.00,0.00),('5','101','620','80484',1604562,'1734','240',77328.10,77328.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80484',1604563,'1735','240',44346.39,47364.86,3018.47,422585.80,0.00,0.00,0.00,0.00,0.00),('5','101','621','80484',1604564,'1736','240',108279.16,110650.23,2371.07,331949.80,0.00,0.00,0.00,0.00,0.00),('5','101','621','80484',1604565,'1737','240',11230.85,11230.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','80484',1604566,'1738','240',52741.96,53041.61,299.65,41951.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','80484',1604567,'1739','240',39940.30,41278.34,1338.04,187325.60,0.00,0.00,0.00,0.00,0.00),('5','101','622','80484',1604568,'1740','241',12995.68,12995.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','80484',1604569,'1741','241',24158.59,24788.12,629.53,160530.15,0.00,0.00,0.00,0.00,0.00),('5','101','623','80484',1604570,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80488',1604613,'1732','240',109969.28,112456.17,2486.89,348164.60,0.00,0.00,0.00,0.00,0.00),('5','101','620','80488',1604614,'1733','240',74954.32,77710.53,2756.21,385869.40,0.00,0.00,0.00,0.00,0.00),('5','101','620','80488',1604615,'1734','240',77328.10,77328.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80488',1604616,'1735','240',47364.86,50472.44,3107.58,435061.20,0.00,0.00,0.00,0.00,0.00),('5','101','621','80488',1604617,'1736','240',110650.23,110991.94,341.71,47839.40,0.00,0.00,0.00,0.00,0.00),('5','101','621','80488',1604618,'1737','240',11230.85,11250.05,19.20,2688.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','80488',1604619,'1738','240',53041.61,53041.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','80488',1604620,'1739','240',41278.34,41637.08,358.74,50223.60,0.00,0.00,0.00,0.00,0.00),('5','101','622','80488',1604621,'1740','241',12995.68,12995.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','80488',1604622,'1741','241',24788.12,25590.22,802.10,204535.50,0.00,0.00,0.00,0.00,0.00),('5','101','623','80488',1604623,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80493',1604674,'1732','240',112456.17,113722.33,1266.16,177262.40,0.00,0.00,0.00,0.00,0.00),('5','101','620','80493',1604675,'1733','240',77710.53,78890.98,1180.45,165263.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80493',1604676,'1734','240',77328.10,77328.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80493',1604677,'1735','240',50472.44,51862.74,1390.30,194642.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','80493',1604678,'1736','240',110991.94,113356.12,2364.18,330985.20,0.00,0.00,0.00,0.00,0.00),('5','101','621','80493',1604679,'1737','240',11250.05,11250.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','80493',1604680,'1738','240',53041.61,54126.38,1084.77,151867.80,0.00,0.00,0.00,0.00,0.00),('5','101','621','80493',1604681,'1739','240',41637.08,41637.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','80493',1604682,'1740','241',12995.68,12995.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','80493',1604683,'1741','241',25590.22,26016.64,426.42,108737.10,0.00,0.00,0.00,0.00,0.00),('5','101','623','80493',1604684,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80496',1604733,'1732','240',113722.33,115405.21,1682.88,235603.20,0.00,0.00,0.00,0.00,0.00),('5','101','620','80496',1604734,'1733','240',78890.98,80814.27,1923.29,269260.60,0.00,0.00,0.00,0.00,0.00),('5','101','620','80496',1604735,'1734','240',77328.10,77338.87,10.77,1507.80,0.00,0.00,0.00,0.00,0.00),('5','101','620','80496',1604736,'1735','240',51862.74,52134.67,271.93,38070.20,0.00,0.00,0.00,0.00,0.00),('5','101','621','80496',1604737,'1736','240',113356.12,116703.51,3347.39,468634.60,0.00,0.00,0.00,0.00,0.00),('5','101','621','80496',1604738,'1737','240',11250.05,12557.25,1307.20,183008.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','80496',1604739,'1738','240',54126.38,54126.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','80496',1604740,'1739','240',41637.08,42312.57,675.49,94568.60,0.00,0.00,0.00,0.00,0.00),('5','101','622','80496',1604741,'1740','241',12995.68,12995.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','80496',1604742,'1741','241',26016.64,26309.86,293.22,74771.10,0.00,0.00,0.00,0.00,0.00),('5','101','623','80496',1604743,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80689',1608489,'1732','240',115405.21,115405.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80689',1608490,'1733','240',80814.27,80814.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80689',1608491,'1734','240',77338.87,77338.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80689',1608492,'1735','240',52134.67,52134.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','80689',1608493,'1736','240',116703.51,119732.65,3029.14,424079.60,0.00,0.00,0.00,0.00,0.00),('5','101','621','80689',1608494,'1737','240',12557.25,15943.70,3386.45,474103.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','80689',1608495,'1738','240',54126.38,54126.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','80689',1608496,'1739','240',42312.57,45643.77,3331.20,466368.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','80689',1608497,'1740','241',12995.68,12995.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','80689',1608498,'1741','241',26309.86,26898.62,588.76,150133.80,0.00,0.00,0.00,0.00,0.00),('5','101','623','80689',1608499,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80690',1608500,'1732','240',115405.21,115405.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80690',1608501,'1733','240',80814.27,80814.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80690',1608502,'1734','240',77338.87,77338.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80690',1608503,'1735','240',52134.67,55295.72,3161.05,442547.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','80690',1608504,'1736','240',119732.65,121938.61,2205.96,308834.40,0.00,0.00,0.00,0.00,0.00),('5','101','621','80690',1608505,'1737','240',15943.70,18801.03,2857.33,400026.20,0.00,0.00,0.00,0.00,0.00),('5','101','621','80690',1608506,'1738','240',54126.38,54126.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','80690',1608507,'1739','240',45643.77,47010.68,1366.91,191367.40,0.00,0.00,0.00,0.00,0.00),('5','101','622','80690',1608508,'1740','241',12995.68,12995.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','80690',1608509,'1741','241',26898.62,27309.05,410.43,104659.65,0.00,0.00,0.00,0.00,0.00),('5','101','623','80690',1608510,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80691',1608511,'1732','240',115405.21,115601.76,196.55,27517.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80691',1608512,'1733','240',80814.27,82320.43,1506.16,210862.40,0.00,0.00,0.00,0.00,0.00),('5','101','620','80691',1608513,'1734','240',77338.87,78083.16,744.29,104200.60,0.00,0.00,0.00,0.00,0.00),('5','101','620','80691',1608514,'1735','240',55295.72,57183.59,1887.87,264301.80,0.00,0.00,0.00,0.00,0.00),('5','101','621','80691',1608515,'1736','240',121938.61,123284.98,1346.37,188491.80,0.00,0.00,0.00,0.00,0.00),('5','101','621','80691',1608516,'1737','240',18801.03,18801.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','80691',1608517,'1738','240',54126.38,54126.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','80691',1608518,'1739','240',47010.68,48639.85,1629.17,228083.80,0.00,0.00,0.00,0.00,0.00),('5','101','622','80691',1608519,'1740','241',12995.68,12995.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','80691',1608520,'1741','241',27309.05,27665.85,356.80,90984.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','80691',1608521,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80693',1608544,'1732','240',115601.76,115601.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80693',1608545,'1733','240',82320.43,84935.95,2615.52,366172.80,0.00,0.00,0.00,0.00,0.00),('5','101','620','80693',1608546,'1734','240',78083.16,80946.00,2862.84,400797.60,0.00,0.00,0.00,0.00,0.00),('5','101','620','80693',1608547,'1735','240',57183.59,57193.59,10.00,1400.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','80693',1608548,'1736','240',123284.98,126166.10,2881.12,403356.80,0.00,0.00,0.00,0.00,0.00),('5','101','621','80693',1608549,'1737','240',18801.03,20126.02,1324.99,185498.60,0.00,0.00,0.00,0.00,0.00),('5','101','621','80693',1608550,'1738','240',54126.38,54126.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','80693',1608551,'1739','240',48639.85,48659.85,20.00,2800.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','80693',1608552,'1740','241',12995.68,12995.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','80693',1608553,'1741','241',27665.85,27943.69,277.84,70849.20,0.00,0.00,0.00,0.00,0.00),('5','101','623','80693',1608554,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80696',1608594,'1732','240',115601.76,115601.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80696',1608595,'1733','240',84935.95,86094.57,1158.62,162206.80,0.00,0.00,0.00,0.00,0.00),('5','101','620','80696',1608596,'1734','240',80946.00,83849.58,2903.58,406501.20,0.00,0.00,0.00,0.00,0.00),('5','101','620','80696',1608597,'1735','240',57193.59,57918.43,724.84,101477.60,0.00,0.00,0.00,0.00,0.00),('5','101','621','80696',1608598,'1736','240',126166.10,127829.11,1663.01,232821.40,0.00,0.00,0.00,0.00,0.00),('5','101','621','80696',1608599,'1737','240',20126.02,20505.90,379.88,53183.20,0.00,0.00,0.00,0.00,0.00),('5','101','621','80696',1608600,'1738','240',54126.38,54126.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','80696',1608601,'1739','240',48659.85,50770.71,2110.86,295520.40,0.00,0.00,0.00,0.00,0.00),('5','101','622','80696',1608602,'1740','241',12995.68,12995.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','80696',1608603,'1741','241',27943.69,28318.28,374.59,95520.45,0.00,0.00,0.00,0.00,0.00),('5','101','623','80696',1608604,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80701',1608699,'1732','240',115601.76,115601.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80701',1608700,'1733','240',86094.57,86094.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80701',1608701,'1734','240',83849.58,83849.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80701',1608702,'1735','240',57918.43,59917.62,1999.19,279886.60,0.00,0.00,0.00,0.00,0.00),('5','101','621','80701',1608703,'1736','240',127829.11,129852.05,2022.94,283211.60,0.00,0.00,0.00,0.00,0.00),('5','101','621','80701',1608704,'1737','240',20505.90,22797.05,2291.15,320761.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','80701',1608705,'1738','240',54126.38,54126.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','80701',1608706,'1739','240',50770.71,52918.59,2147.88,300703.20,0.00,0.00,0.00,0.00,0.00),('5','101','622','80701',1608707,'1740','241',12995.68,12995.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','80701',1608708,'1741','241',28318.28,28718.05,399.77,101941.35,0.00,0.00,0.00,0.00,0.00),('5','101','623','80701',1608709,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80702',1608710,'1732','240',115601.76,115601.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80702',1608711,'1733','240',86094.57,88393.89,2299.32,321904.80,0.00,0.00,0.00,0.00,0.00),('5','101','620','80702',1608712,'1734','240',83849.58,83849.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80702',1608713,'1735','240',59917.62,61911.23,1993.61,279105.40,0.00,0.00,0.00,0.00,0.00),('5','101','621','80702',1608714,'1736','240',129852.05,132740.72,2888.67,404413.80,0.00,0.00,0.00,0.00,0.00),('5','101','621','80702',1608715,'1737','240',22797.05,25063.68,2266.63,317328.20,0.00,0.00,0.00,0.00,0.00),('5','101','621','80702',1608716,'1738','240',54126.38,54126.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','80702',1608717,'1739','240',52918.59,52918.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','80702',1608718,'1740','241',12995.68,12995.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','80702',1608719,'1741','241',28718.05,28974.16,256.11,65308.05,0.00,0.00,0.00,0.00,0.00),('5','101','623','80702',1608720,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80703',1608721,'1732','240',115601.76,115601.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80703',1608722,'1733','240',88393.89,90600.07,2206.18,308865.20,0.00,0.00,0.00,0.00,0.00),('5','101','620','80703',1608723,'1734','240',83849.58,86185.25,2335.67,326993.80,0.00,0.00,0.00,0.00,0.00),('5','101','620','80703',1608724,'1735','240',61911.23,61911.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','80703',1608725,'1736','240',132740.72,135568.74,2828.02,395922.80,0.00,0.00,0.00,0.00,0.00),('5','101','621','80703',1608726,'1737','240',25063.68,26920.40,1856.72,259940.80,0.00,0.00,0.00,0.00,0.00),('5','101','621','80703',1608727,'1738','240',54126.38,54126.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','80703',1608728,'1739','240',52918.59,52918.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','80703',1608729,'1740','241',12995.68,13019.33,23.65,6030.75,0.00,0.00,0.00,0.00,0.00),('5','101','622','80703',1608730,'1741','241',28974.16,28999.53,25.37,6469.35,0.00,0.00,0.00,0.00,0.00),('5','101','623','80703',1608731,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80706',1608766,'1732','240',115601.76,115601.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80706',1608767,'1733','240',90600.07,93246.45,2646.38,370493.20,0.00,0.00,0.00,0.00,0.00),('5','101','620','80706',1608768,'1734','240',86185.25,86185.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80706',1608769,'1735','240',61911.23,64969.01,3057.78,428089.20,0.00,0.00,0.00,0.00,0.00),('5','101','621','80706',1608770,'1736','240',135568.74,139119.93,3551.19,497166.60,0.00,0.00,0.00,0.00,0.00),('5','101','621','80706',1608771,'1737','240',26920.40,28418.01,1497.61,209665.40,0.00,0.00,0.00,0.00,0.00),('5','101','621','80706',1608772,'1738','240',54126.38,54126.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','80706',1608773,'1739','240',52918.59,52918.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','80706',1608774,'1740','241',13019.33,13019.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','80706',1608775,'1741','241',28999.53,29254.79,255.26,65091.30,0.00,0.00,0.00,0.00,0.00),('5','101','623','80706',1608776,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80707',1608777,'1732','240',115601.76,115619.03,17.27,2417.80,0.00,0.00,0.00,0.00,0.00),('5','101','620','80707',1608778,'1733','240',93246.45,95313.57,2067.12,289396.80,0.00,0.00,0.00,0.00,0.00),('5','101','620','80707',1608779,'1734','240',86185.25,86330.90,145.65,20391.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80707',1608780,'1735','240',64969.01,66304.88,1335.87,187021.80,0.00,0.00,0.00,0.00,0.00),('5','101','621','80707',1608781,'1736','240',139119.93,141823.11,2703.18,378445.20,0.00,0.00,0.00,0.00,0.00),('5','101','621','80707',1608782,'1737','240',28418.01,30741.42,2323.41,325277.40,0.00,0.00,0.00,0.00,0.00),('5','101','621','80707',1608783,'1738','240',54126.38,54126.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','80707',1608784,'1739','240',52918.59,56421.23,3502.64,490369.60,0.00,0.00,0.00,0.00,0.00),('5','101','622','80707',1608785,'1740','241',13019.33,13019.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','80707',1608786,'1741','241',29254.79,29498.01,243.22,62021.10,0.00,0.00,0.00,0.00,0.00),('5','101','623','80707',1608787,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80835',1611385,'1732','240',115619.03,115619.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80835',1611386,'1733','240',95313.57,96287.59,974.02,136362.80,0.00,0.00,0.00,0.00,0.00),('5','101','620','80835',1611387,'1734','240',86330.90,86330.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80835',1611388,'1735','240',66304.88,67767.54,1462.66,204772.40,0.00,0.00,0.00,0.00,0.00),('5','101','621','80835',1611389,'1736','240',141823.11,142870.76,1047.65,146671.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','80835',1611390,'1737','240',30741.42,30741.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','80835',1611391,'1738','240',54126.38,54519.47,393.09,55032.60,0.00,0.00,0.00,0.00,0.00),('5','101','621','80835',1611392,'1739','240',56421.23,56689.70,268.47,37585.80,0.00,0.00,0.00,0.00,0.00),('5','101','622','80835',1611393,'1740','241',13019.33,13019.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','80835',1611394,'1741','241',29498.01,29655.54,157.53,40170.15,0.00,0.00,0.00,0.00,0.00),('5','101','623','80835',1611395,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80836',1611396,'1732','240',115619.03,115646.08,27.05,3787.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80836',1611397,'1733','240',96287.59,98044.84,1757.25,246015.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80836',1611398,'1734','240',86330.90,87188.11,857.21,120009.40,0.00,0.00,0.00,0.00,0.00),('5','101','620','80836',1611399,'1735','240',67767.54,69170.50,1402.96,196414.40,0.00,0.00,0.00,0.00,0.00),('5','101','621','80836',1611400,'1736','240',142870.76,143444.42,573.66,80312.40,0.00,0.00,0.00,0.00,0.00),('5','101','621','80836',1611401,'1737','240',30741.42,31680.98,939.56,131538.40,0.00,0.00,0.00,0.00,0.00),('5','101','621','80836',1611402,'1738','240',54519.47,56180.87,1661.40,232596.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','80836',1611403,'1739','240',56689.70,57252.84,563.14,78839.60,0.00,0.00,0.00,0.00,0.00),('5','101','622','80836',1611404,'1740','241',13019.33,13019.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','80836',1611405,'1741','241',29655.54,29914.20,258.66,65958.30,0.00,0.00,0.00,0.00,0.00),('5','101','623','80836',1611406,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80838',1611457,'1732','240',115646.08,115646.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80838',1611458,'1733','240',98044.84,98399.89,355.05,49707.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80838',1611459,'1734','240',87188.11,88837.26,1649.15,230881.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80838',1611460,'1735','240',69170.50,69842.31,671.81,94053.40,0.00,0.00,0.00,0.00,0.00),('5','101','621','80838',1611461,'1736','240',143444.42,145638.36,2193.94,307151.60,0.00,0.00,0.00,0.00,0.00),('5','101','621','80838',1611462,'1737','240',31680.98,33706.41,2025.43,283560.20,0.00,0.00,0.00,0.00,0.00),('5','101','621','80838',1611463,'1738','240',56180.87,56373.14,192.27,26917.80,0.00,0.00,0.00,0.00,0.00),('5','101','621','80838',1611464,'1739','240',57252.84,58826.39,1573.55,220297.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','80838',1611465,'1740','241',13019.33,13019.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','80838',1611466,'1741','241',29914.20,30053.93,139.73,35631.15,0.00,0.00,0.00,0.00,0.00),('5','101','623','80838',1611467,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80839',1611468,'1732','240',115646.08,115646.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80839',1611469,'1733','240',98399.89,98399.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80839',1611470,'1734','240',88837.26,90930.75,2093.49,293088.60,0.00,0.00,0.00,0.00,0.00),('5','101','620','80839',1611471,'1735','240',69842.31,69842.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','80839',1611472,'1736','240',145638.36,148438.12,2799.76,391966.40,0.00,0.00,0.00,0.00,0.00),('5','101','621','80839',1611473,'1737','240',33706.41,34677.04,970.63,135888.20,0.00,0.00,0.00,0.00,0.00),('5','101','621','80839',1611474,'1738','240',56373.14,56423.82,50.68,7095.20,0.00,0.00,0.00,0.00,0.00),('5','101','621','80839',1611475,'1739','240',58826.39,61012.89,2186.50,306110.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','80839',1611476,'1740','241',13019.33,13019.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','80839',1611477,'1741','241',30053.93,30218.33,164.40,41922.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','80839',1611478,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80840',1611479,'1732','240',115646.08,115710.09,64.01,8961.40,0.00,0.00,0.00,0.00,0.00),('5','101','620','80840',1611480,'1733','240',98399.89,100978.89,2579.00,361060.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80840',1611481,'1734','240',90930.75,93995.78,3065.03,429104.20,0.00,0.00,0.00,0.00,0.00),('5','101','620','80840',1611482,'1735','240',69842.31,73070.15,3227.84,451897.60,0.00,0.00,0.00,0.00,0.00),('5','101','621','80840',1611483,'1736','240',148438.12,149144.94,706.82,98954.80,0.00,0.00,0.00,0.00,0.00),('5','101','621','80840',1611484,'1737','240',34677.04,34677.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','80840',1611485,'1738','240',56423.82,56423.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','80840',1611486,'1739','240',61012.89,61330.24,317.35,44429.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','80840',1611487,'1740','241',13019.33,13019.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','80840',1611488,'1741','241',30218.33,30393.52,175.19,44673.45,0.00,0.00,0.00,0.00,0.00),('5','101','623','80840',1611489,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80843',1611524,'1732','240',115710.09,115710.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80843',1611525,'1733','240',100978.89,103701.84,2722.95,381213.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80843',1611526,'1734','240',93995.78,96171.00,2175.22,304530.80,0.00,0.00,0.00,0.00,0.00),('5','101','620','80843',1611527,'1735','240',73070.15,75608.98,2538.83,355436.20,0.00,0.00,0.00,0.00,0.00),('5','101','621','80843',1611528,'1736','240',149144.94,151005.01,1860.07,260409.80,0.00,0.00,0.00,0.00,0.00),('5','101','621','80843',1611529,'1737','240',34677.04,34997.04,320.00,44800.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','80843',1611530,'1738','240',56423.82,56423.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','80843',1611531,'1739','240',61330.24,61330.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','80843',1611532,'1740','241',13019.33,13019.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','80843',1611533,'1741','241',30393.52,30716.34,322.82,82319.10,0.00,0.00,0.00,0.00,0.00),('5','101','623','80843',1611534,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80856',1611714,'1732','240',115710.09,115710.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80856',1611715,'1733','240',103701.84,107102.20,3400.36,476050.40,0.00,0.00,0.00,0.00,0.00),('5','101','620','80856',1611716,'1734','240',96171.00,97139.44,968.44,135581.60,0.00,0.00,0.00,0.00,0.00),('5','101','620','80856',1611717,'1735','240',75608.98,79098.18,3489.20,488488.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','80856',1611718,'1736','240',151005.01,153935.21,2930.20,410228.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','80856',1611719,'1737','240',34997.04,34997.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','80856',1611720,'1738','240',56423.82,56423.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','80856',1611721,'1739','240',61330.24,61330.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','80856',1611722,'1740','241',13019.33,13019.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','80856',1611723,'1741','241',30716.34,30937.60,221.26,53102.40,0.00,0.00,0.00,0.00,0.00),('5','101','623','80856',1611724,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80859',1611755,'1732','240',115710.09,115710.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80859',1611756,'1733','240',107102.20,108825.52,1723.32,241264.80,0.00,0.00,0.00,0.00,0.00),('5','101','620','80859',1611757,'1734','240',97139.44,98027.10,887.66,124272.40,0.00,0.00,0.00,0.00,0.00),('5','101','620','80859',1611758,'1735','240',79098.18,79859.20,761.02,106542.80,0.00,0.00,0.00,0.00,0.00),('5','101','621','80859',1611759,'1736','240',153935.21,155400.25,1465.04,205105.60,0.00,0.00,0.00,0.00,0.00),('5','101','621','80859',1611760,'1737','240',34997.04,36009.34,1012.30,141722.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','80859',1611761,'1738','240',56423.82,56423.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','80859',1611762,'1739','240',61330.24,61330.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','80859',1611763,'1740','241',13019.33,13019.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','80859',1611764,'1741','241',30937.60,31072.62,135.02,32404.80,0.00,0.00,0.00,0.00,0.00),('5','101','623','80859',1611765,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80862',1611810,'1732','240',115710.09,115721.34,11.25,1575.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80862',1611811,'1733','240',108825.52,111652.04,2826.52,395712.80,0.00,0.00,0.00,0.00,0.00),('5','101','620','80862',1611812,'1734','240',98027.10,98027.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80862',1611813,'1735','240',79859.20,79925.16,65.96,9234.40,0.00,0.00,0.00,0.00,0.00),('5','101','621','80862',1611814,'1736','240',155400.25,157069.30,1669.05,233667.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','80862',1611815,'1737','240',36009.34,37602.03,1592.69,222976.60,0.00,0.00,0.00,0.00,0.00),('5','101','621','80862',1611816,'1738','240',56423.82,58639.19,2215.37,310151.80,0.00,0.00,0.00,0.00,0.00),('5','101','621','80862',1611817,'1739','240',61330.24,62030.76,700.52,98072.80,0.00,0.00,0.00,0.00,0.00),('5','101','622','80862',1611818,'1740','241',13019.33,13019.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','80862',1611819,'1741','241',31072.62,31436.35,363.73,87295.20,0.00,0.00,0.00,0.00,0.00),('5','101','623','80862',1611820,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80972',1614023,'1732','240',115721.34,115721.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80972',1614024,'1733','240',111652.04,111652.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80972',1614025,'1734','240',98027.10,98027.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','80972',1614026,'1735','240',79925.16,81475.16,1550.00,217000.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','80972',1614027,'1736','240',157069.30,159661.90,2592.60,362964.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','80972',1614028,'1737','240',37602.03,39189.51,1587.48,222247.20,0.00,0.00,0.00,0.00,0.00),('5','101','621','80972',1614029,'1738','240',58639.19,61487.89,2848.70,398818.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','80972',1614030,'1739','240',62030.76,62030.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','80972',1614031,'1740','241',13019.33,13019.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','80972',1614032,'1741','241',31436.35,31779.03,342.68,82243.20,0.00,0.00,0.00,0.00,0.00),('5','101','623','80972',1614033,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','81250',1619229,'1732','240',115721.34,115721.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','81250',1619230,'1733','240',111652.04,112595.30,943.26,132056.40,0.00,0.00,0.00,0.00,0.00),('5','101','620','81250',1619231,'1734','240',98027.10,99132.19,1105.09,154712.60,0.00,0.00,0.00,0.00,0.00),('5','101','620','81250',1619232,'1735','240',81475.16,83822.48,2347.32,328624.80,0.00,0.00,0.00,0.00,0.00),('5','101','621','81250',1619233,'1736','240',159661.90,161348.51,1686.61,236125.40,0.00,0.00,0.00,0.00,0.00),('5','101','621','81250',1619234,'1737','240',39189.51,39704.53,515.02,72102.80,0.00,0.00,0.00,0.00,0.00),('5','101','621','81250',1619235,'1738','240',61487.89,64019.37,2531.48,354407.20,0.00,0.00,0.00,0.00,0.00),('5','101','621','81250',1619236,'1739','240',62030.76,62030.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','81250',1619237,'1740','241',13019.33,13019.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','81250',1619238,'1741','241',31779.03,32097.21,318.18,76363.20,0.00,0.00,0.00,0.00,0.00),('5','101','623','81250',1619239,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','81253',1619318,'1732','240',115721.34,115721.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','81253',1619319,'1733','240',112595.30,114951.19,2355.89,329824.60,0.00,0.00,0.00,0.00,0.00),('5','101','620','81253',1619320,'1734','240',99132.19,101247.02,2114.83,296076.20,0.00,0.00,0.00,0.00,0.00),('5','101','620','81253',1619321,'1735','240',83822.48,84903.71,1081.23,151372.20,0.00,0.00,0.00,0.00,0.00),('5','101','621','81253',1619322,'1736','240',161348.51,162693.22,1344.71,188259.40,0.00,0.00,0.00,0.00,0.00),('5','101','621','81253',1619323,'1737','240',39704.53,40925.72,1221.19,170966.60,0.00,0.00,0.00,0.00,0.00),('5','101','621','81253',1619324,'1738','240',64019.37,64019.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','81253',1619325,'1739','240',62030.76,62030.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','81253',1619326,'1740','241',13019.33,13019.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','81253',1619327,'1741','241',32097.21,32398.96,301.75,72420.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','81253',1619328,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','81697',1628078,'1732','240',115721.34,115721.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','81697',1628079,'1733','240',114951.19,116642.13,1690.94,236731.60,0.00,0.00,0.00,0.00,0.00),('5','101','620','81697',1628080,'1734','240',101247.02,101857.40,610.38,85453.20,0.00,0.00,0.00,0.00,0.00),('5','101','620','81697',1628081,'1735','240',84903.71,87749.27,2845.56,398378.40,0.00,0.00,0.00,0.00,0.00),('5','101','621','81697',1628082,'1736','240',162693.22,163843.35,1150.13,161018.20,0.00,0.00,0.00,0.00,0.00),('5','101','621','81697',1628083,'1737','240',40925.72,42860.18,1934.46,270824.40,0.00,0.00,0.00,0.00,0.00),('5','101','621','81697',1628084,'1738','240',64019.37,65604.93,1585.56,221978.40,0.00,0.00,0.00,0.00,0.00),('5','101','621','81697',1628085,'1739','240',62030.76,62030.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','81697',1628086,'1740','241',13019.33,13019.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','81697',1628087,'1741','241',32398.96,32573.11,174.15,41796.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','81697',1628088,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','81702',1628146,'1732','240',115721.34,115721.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','81702',1628147,'1733','240',116642.13,118633.14,1991.01,278741.40,0.00,0.00,0.00,0.00,0.00),('5','101','620','81702',1628148,'1734','240',101857.40,102792.94,935.54,130975.60,0.00,0.00,0.00,0.00,0.00),('5','101','620','81702',1628149,'1735','240',87749.27,89843.55,2094.28,293199.20,0.00,0.00,0.00,0.00,0.00),('5','101','621','81702',1628150,'1736','240',163843.35,163843.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','81702',1628151,'1737','240',42860.18,45386.00,2525.82,353614.80,0.00,0.00,0.00,0.00,0.00),('5','101','621','81702',1628152,'1738','240',65604.93,67734.07,2129.14,298079.60,0.00,0.00,0.00,0.00,0.00),('5','101','621','81702',1628153,'1739','240',62030.76,62030.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','81702',1628154,'1740','241',13019.33,13019.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','81702',1628155,'1741','241',32573.11,32888.59,315.48,75715.20,0.00,0.00,0.00,0.00,0.00),('5','101','623','81702',1628156,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','81704',1628169,'1732','240',115721.34,115721.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','81704',1628170,'1733','240',118633.14,120942.93,2309.79,323370.60,0.00,0.00,0.00,0.00,0.00),('5','101','620','81704',1628171,'1734','240',102792.94,103287.83,494.89,69284.60,0.00,0.00,0.00,0.00,0.00),('5','101','620','81704',1628172,'1735','240',89843.55,93159.31,3315.76,464206.40,0.00,0.00,0.00,0.00,0.00),('5','101','621','81704',1628173,'1736','240',163843.35,163843.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','81704',1628174,'1737','240',45386.00,46878.35,1492.35,208929.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','81704',1628175,'1738','240',67734.07,67734.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','81704',1628176,'1739','240',62030.76,63960.75,1929.99,270198.60,0.00,0.00,0.00,0.00,0.00),('5','101','622','81704',1628177,'1740','241',13019.33,13019.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','81704',1628178,'1741','241',32888.59,33154.24,265.65,63756.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','81704',1628179,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','81708',1628273,'1732','240',115721.34,115721.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','81708',1628274,'1733','240',120942.93,123538.35,2595.42,363358.80,0.00,0.00,0.00,0.00,0.00),('5','101','620','81708',1628275,'1734','240',103287.83,105884.07,2596.24,363473.60,0.00,0.00,0.00,0.00,0.00),('5','101','620','81708',1628276,'1735','240',93159.31,95253.25,2093.94,293151.60,0.00,0.00,0.00,0.00,0.00),('5','101','621','81708',1628277,'1736','240',163843.35,163843.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','81708',1628278,'1737','240',46878.35,46878.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','81708',1628279,'1738','240',67734.07,67742.97,8.90,1246.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','81708',1628280,'1739','240',63960.75,66172.07,2211.32,309584.80,0.00,0.00,0.00,0.00,0.00),('5','101','622','81708',1628281,'1740','241',13019.33,13019.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','81708',1628282,'1741','241',33154.24,33320.75,166.51,39962.40,0.00,0.00,0.00,0.00,0.00),('5','101','623','81708',1628283,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','81710',1628300,'1732','240',115721.34,115721.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','81710',1628301,'1733','240',123538.35,123538.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','81710',1628302,'1734','240',105884.07,105884.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','81710',1628303,'1735','240',95253.25,95253.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','81710',1628304,'1736','240',163843.35,163843.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','81710',1628305,'1737','240',46878.35,46878.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','81710',1628306,'1738','240',67742.97,67742.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','81710',1628307,'1739','240',66172.07,66172.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','81710',1628308,'1740','241',13019.33,13019.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','81710',1628309,'1741','241',33320.75,33320.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','81710',1628310,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','82263',1639216,'1732','240',115721.34,115721.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','82263',1639217,'1733','240',123538.35,125815.31,2276.96,318774.40,0.00,0.00,0.00,0.00,0.00),('5','101','620','82263',1639218,'1734','240',105884.07,107831.94,1947.87,272701.80,0.00,0.00,0.00,0.00,0.00),('5','101','620','82263',1639219,'1735','240',95253.25,98101.60,2848.35,398769.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','82263',1639220,'1736','240',163843.35,163843.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','82263',1639221,'1737','240',46878.35,46878.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','82263',1639222,'1738','240',67742.97,67742.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','82263',1639223,'1739','240',66172.07,67339.02,1166.95,163373.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','82263',1639224,'1740','241',13019.33,13019.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','82263',1639225,'1741','241',33320.75,33643.52,322.77,77464.80,0.00,0.00,0.00,0.00,0.00),('5','101','623','82263',1639226,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','82265',1639241,'1732','240',115721.34,116739.87,1018.53,142594.20,0.00,0.00,0.00,0.00,0.00),('5','101','620','82265',1639242,'1733','240',125815.31,127471.89,1656.58,231921.20,0.00,0.00,0.00,0.00,0.00),('5','101','620','82265',1639243,'1734','240',107831.94,107831.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','82265',1639244,'1735','240',98101.60,98103.38,1.78,249.20,0.00,0.00,0.00,0.00,0.00),('5','101','621','82265',1639245,'1736','240',163843.35,165460.47,1617.12,226396.80,0.00,0.00,0.00,0.00,0.00),('5','101','621','82265',1639246,'1737','240',46878.35,48340.73,1462.38,204733.20,0.00,0.00,0.00,0.00,0.00),('5','101','621','82265',1639247,'1738','240',67742.97,67775.36,32.39,4534.60,0.00,0.00,0.00,0.00,0.00),('5','101','621','82265',1639248,'1739','240',67339.02,70385.59,3046.57,426519.80,0.00,0.00,0.00,0.00,0.00),('5','101','622','82265',1639249,'1740','241',13019.33,13019.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','82265',1639250,'1741','241',33643.52,33966.99,323.47,77632.80,0.00,0.00,0.00,0.00,0.00),('5','101','623','82265',1639251,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','82266',1639252,'1732','240',116739.87,116739.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','82266',1639253,'1733','240',127471.89,127471.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','82266',1639254,'1734','240',107831.94,107831.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','82266',1639255,'1735','240',98103.38,98103.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','82266',1639256,'1736','240',165460.47,168637.81,3177.34,444827.60,0.00,0.00,0.00,0.00,0.00),('5','101','621','82266',1639257,'1737','240',48340.73,52024.81,3684.08,515771.20,0.00,0.00,0.00,0.00,0.00),('5','101','621','82266',1639258,'1738','240',67775.36,67775.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','82266',1639259,'1739','240',70385.59,73249.32,2863.73,400922.20,0.00,0.00,0.00,0.00,0.00),('5','101','622','82266',1639260,'1740','241',13019.33,13019.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','82266',1639261,'1741','241',33966.99,34211.78,244.79,58749.60,0.00,0.00,0.00,0.00,0.00),('5','101','623','82266',1639262,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','82267',1639263,'1732','240',116739.87,116739.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','82267',1639264,'1733','240',127471.89,129790.92,2319.03,324664.20,0.00,0.00,0.00,0.00,0.00),('5','101','620','82267',1639265,'1734','240',107831.94,110737.93,2905.99,406838.60,0.00,0.00,0.00,0.00,0.00),('5','101','620','82267',1639266,'1735','240',98103.38,100451.69,2348.31,328763.40,0.00,0.00,0.00,0.00,0.00),('5','101','621','82267',1639267,'1736','240',168637.81,172076.75,3438.94,481451.60,0.00,0.00,0.00,0.00,0.00),('5','101','621','82267',1639268,'1737','240',52024.81,53658.69,1633.88,228743.20,0.00,0.00,0.00,0.00,0.00),('5','101','621','82267',1639269,'1738','240',67775.36,67798.07,22.71,3179.40,0.00,0.00,0.00,0.00,0.00),('5','101','621','82267',1639270,'1739','240',73249.32,73263.08,13.76,1926.40,0.00,0.00,0.00,0.00,0.00),('5','101','622','82267',1639271,'1740','241',13019.33,13019.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','82267',1639272,'1741','241',34211.78,34625.99,414.21,99410.40,0.00,0.00,0.00,0.00,0.00),('5','101','623','82267',1639273,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','82268',1639274,'1732','240',116739.87,116739.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','82268',1639275,'1733','240',129790.92,132294.05,2503.13,350438.20,0.00,0.00,0.00,0.00,0.00),('5','101','620','82268',1639276,'1734','240',110737.93,110737.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','82268',1639277,'1735','240',100451.69,102568.47,2116.78,296349.20,0.00,0.00,0.00,0.00,0.00),('5','101','621','82268',1639278,'1736','240',172076.75,174010.88,1934.13,270778.20,0.00,0.00,0.00,0.00,0.00),('5','101','621','82268',1639279,'1737','240',53658.69,54046.96,388.27,54357.80,0.00,0.00,0.00,0.00,0.00),('5','101','621','82268',1639280,'1738','240',67798.07,69419.69,1621.62,227026.80,0.00,0.00,0.00,0.00,0.00),('5','101','621','82268',1639281,'1739','240',73263.08,73263.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','82268',1639282,'1740','241',13019.33,13019.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','82268',1639283,'1741','241',34625.99,34950.15,324.16,77798.40,0.00,0.00,0.00,0.00,0.00),('5','101','623','82268',1639284,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','82448',1642757,'1732','240',116739.87,117044.88,305.01,42701.40,0.00,0.00,0.00,0.00,0.00),('5','101','620','82448',1642758,'1733','240',132294.05,135035.06,2741.01,383741.40,0.00,0.00,0.00,0.00,0.00),('5','101','620','82448',1642759,'1734','240',110737.93,110737.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','82448',1642760,'1735','240',102568.47,106051.87,3483.40,487676.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','82448',1642761,'1736','240',174010.88,177356.30,3345.42,468358.80,0.00,0.00,0.00,0.00,0.00),('5','101','621','82448',1642762,'1737','240',54046.96,54848.59,801.63,112228.20,0.00,0.00,0.00,0.00,0.00),('5','101','621','82448',1642763,'1738','240',69419.69,69419.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','82448',1642764,'1739','240',73263.08,73263.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','82448',1642765,'1740','241',13019.33,13019.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','82448',1642766,'1741','241',34950.15,35487.93,537.78,129067.20,0.00,0.00,0.00,0.00,0.00),('5','101','623','82448',1642767,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','84141',1675759,'1732','240',117044.88,117166.30,121.42,16998.80,0.00,0.00,0.00,0.00,0.00),('5','101','620','84141',1675760,'1733','240',135035.06,137708.95,2673.89,374344.60,0.00,0.00,0.00,0.00,0.00),('5','101','620','84141',1675761,'1734','240',110737.93,110737.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','84141',1675762,'1735','240',106051.87,106360.71,308.84,43237.60,0.00,0.00,0.00,0.00,0.00),('5','101','621','84141',1675763,'1736','240',177356.30,180450.48,3094.18,433185.20,0.00,0.00,0.00,0.00,0.00),('5','101','621','84141',1675764,'1737','240',54848.59,58075.69,3227.10,451794.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','84141',1675765,'1738','240',69419.69,69419.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','84141',1675766,'1739','240',73263.08,73263.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','84141',1675767,'1740','241',13019.33,13019.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','84141',1675768,'1741','241',35487.93,35654.09,166.16,39878.40,0.00,0.00,0.00,0.00,0.00),('5','101','623','84141',1675769,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','84143',1675798,'1732','240',117166.30,119832.93,2666.63,373328.20,0.00,0.00,0.00,0.00,0.00),('5','101','620','84143',1675799,'1733','240',137708.95,138627.65,918.70,128618.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','84143',1675800,'1734','240',110737.93,112130.56,1392.63,194968.20,0.00,0.00,0.00,0.00,0.00),('5','101','620','84143',1675801,'1735','240',106360.71,108200.82,1840.11,257615.40,0.00,0.00,0.00,0.00,0.00),('5','101','621','84143',1675802,'1736','240',180450.48,183013.53,2563.05,358827.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','84143',1675803,'1737','240',58075.69,58086.39,10.70,1498.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','84143',1675804,'1738','240',69419.69,69419.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','84143',1675805,'1739','240',73263.08,73994.91,731.83,102456.20,0.00,0.00,0.00,0.00,0.00),('5','101','622','84143',1675806,'1740','241',13019.33,13019.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','84143',1675807,'1741','241',35654.09,36008.18,354.09,84981.60,0.00,0.00,0.00,0.00,0.00),('5','101','623','84143',1675808,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','84145',1675814,'1732','240',119832.93,121709.52,1876.59,262722.60,0.00,0.00,0.00,0.00,0.00),('5','101','620','84145',1675815,'1733','240',138627.65,141266.62,2638.97,369455.80,0.00,0.00,0.00,0.00,0.00),('5','101','620','84145',1675816,'1734','240',112130.56,112130.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','84145',1675817,'1735','240',108200.82,110704.01,2503.19,350446.60,0.00,0.00,0.00,0.00,0.00),('5','101','621','84145',1675818,'1736','240',183013.53,183516.34,502.81,70393.40,0.00,0.00,0.00,0.00,0.00),('5','101','621','84145',1675819,'1737','240',58086.39,59089.77,1003.38,140473.20,0.00,0.00,0.00,0.00,0.00),('5','101','621','84145',1675820,'1738','240',69419.69,69744.42,324.73,45462.20,0.00,0.00,0.00,0.00,0.00),('5','101','621','84145',1675821,'1739','240',73994.91,74483.12,488.21,68349.40,0.00,0.00,0.00,0.00,0.00),('5','101','622','84145',1675822,'1740','241',13019.33,13019.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','84145',1675823,'1741','241',36008.18,36204.13,195.95,47028.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','84145',1675824,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','84147',1675850,'1732','240',121709.52,124922.69,3213.17,449843.80,0.00,0.00,0.00,0.00,0.00),('5','101','620','84147',1675851,'1733','240',141266.62,143877.21,2610.59,365482.60,0.00,0.00,0.00,0.00,0.00),('5','101','620','84147',1675852,'1734','240',112130.56,112679.54,548.98,76857.20,0.00,0.00,0.00,0.00,0.00),('5','101','620','84147',1675853,'1735','240',110704.01,112329.93,1625.92,227628.80,0.00,0.00,0.00,0.00,0.00),('5','101','621','84147',1675854,'1736','240',183516.34,183516.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','84147',1675855,'1737','240',59089.77,59089.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','84147',1675856,'1738','240',69744.42,69744.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','84147',1675857,'1739','240',74483.12,75507.44,1024.32,143404.80,0.00,0.00,0.00,0.00,0.00),('5','101','622','84147',1675858,'1740','241',13019.33,13019.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','84147',1675859,'1741','241',36204.13,36204.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','84147',1675860,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','84275',1677948,'1732','240',124922.69,124922.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','84275',1677949,'1733','240',143877.21,144323.28,446.07,62449.80,0.00,0.00,0.00,0.00,0.00),('5','101','620','84275',1677950,'1734','240',112679.54,112679.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','84275',1677951,'1735','240',112329.93,112329.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','84275',1677952,'1736','240',183516.34,183526.22,9.88,1383.20,0.00,0.00,0.00,0.00,0.00),('5','101','621','84275',1677953,'1737','240',59089.77,61814.89,2725.12,381516.80,0.00,0.00,0.00,0.00,0.00),('5','101','621','84275',1677954,'1738','240',69744.42,73657.08,3912.66,547772.40,0.00,0.00,0.00,0.00,0.00),('5','101','621','84275',1677955,'1739','240',75507.44,77882.23,2374.79,332470.60,0.00,0.00,0.00,0.00,0.00),('5','101','622','84275',1677956,'1740','241',13019.33,13019.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','84275',1677957,'1741','241',36204.13,36525.08,320.95,77028.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','84275',1677958,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','84494',1682181,'1732','240',124922.69,125428.40,505.71,70799.40,0.00,0.00,0.00,0.00,0.00),('5','101','620','84494',1682182,'1733','240',144323.28,144323.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','84494',1682183,'1734','240',112679.54,112679.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','84494',1682184,'1735','240',112329.93,112329.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','84494',1682185,'1736','240',183526.22,186030.36,2504.14,350579.60,0.00,0.00,0.00,0.00,0.00),('5','101','621','84494',1682186,'1737','240',61814.89,64333.17,2518.28,352559.20,0.00,0.00,0.00,0.00,0.00),('5','101','621','84494',1682187,'1738','240',73657.08,76168.79,2511.71,351639.40,0.00,0.00,0.00,0.00,0.00),('5','101','621','84494',1682188,'1739','240',77882.23,80440.14,2557.91,358107.40,0.00,0.00,0.00,0.00,0.00),('5','101','622','84494',1682189,'1740','241',13019.33,13019.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','84494',1682190,'1741','241',36525.08,36679.15,154.07,36976.80,0.00,0.00,0.00,0.00,0.00),('5','101','623','84494',1682191,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','84497',1682213,'1732','240',125428.40,125428.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','84497',1682214,'1733','240',144323.28,144323.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','84497',1682215,'1734','240',112679.54,112679.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','84497',1682216,'1735','240',112329.93,112329.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','84497',1682217,'1736','240',186030.36,188071.06,2040.70,285698.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','84497',1682218,'1737','240',64333.17,66396.76,2063.59,288902.60,0.00,0.00,0.00,0.00,0.00),('5','101','621','84497',1682219,'1738','240',76168.79,76485.13,316.34,44287.60,0.00,0.00,0.00,0.00,0.00),('5','101','621','84497',1682220,'1739','240',80440.14,82310.84,1870.70,261898.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','84497',1682221,'1740','241',13019.33,13019.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','84497',1682222,'1741','241',36679.15,37480.34,801.19,192285.60,0.00,0.00,0.00,0.00,0.00),('5','101','623','84497',1682223,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','84499',1682252,'1732','240',125428.40,125428.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','84499',1682253,'1733','240',144323.28,144487.47,164.19,22986.60,0.00,0.00,0.00,0.00,0.00),('5','101','620','84499',1682254,'1734','240',112679.54,112679.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','84499',1682255,'1735','240',112329.93,115052.00,2722.07,381089.80,0.00,0.00,0.00,0.00,0.00),('5','101','621','84499',1682256,'1736','240',188071.06,190032.43,1961.37,274591.80,0.00,0.00,0.00,0.00,0.00),('5','101','621','84499',1682257,'1737','240',66396.76,68444.17,2047.41,286637.40,0.00,0.00,0.00,0.00,0.00),('5','101','621','84499',1682258,'1738','240',76485.13,77779.41,1294.28,181199.20,0.00,0.00,0.00,0.00,0.00),('5','101','621','84499',1682259,'1739','240',82310.84,83739.78,1428.94,200051.60,0.00,0.00,0.00,0.00,0.00),('5','101','622','84499',1682260,'1740','241',13019.33,13019.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','84499',1682261,'1741','241',37480.34,37626.03,145.69,34965.60,0.00,0.00,0.00,0.00,0.00),('5','101','623','84499',1682262,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','84503',1682342,'1732','240',125428.40,125541.75,113.35,15869.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','84503',1682343,'1733','240',144487.47,144487.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','84503',1682344,'1734','240',112679.54,114771.67,2092.13,292898.20,0.00,0.00,0.00,0.00,0.00),('5','101','620','84503',1682345,'1735','240',115052.00,117001.49,1949.49,272928.60,0.00,0.00,0.00,0.00,0.00),('5','101','621','84503',1682346,'1736','240',190032.43,191839.93,1807.50,253050.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','84503',1682347,'1737','240',68444.17,68466.60,22.43,3140.20,0.00,0.00,0.00,0.00,0.00),('5','101','621','84503',1682348,'1738','240',77779.41,78414.87,635.46,88964.40,0.00,0.00,0.00,0.00,0.00),('5','101','621','84503',1682349,'1739','240',83739.78,86597.85,2858.07,400129.80,0.00,0.00,0.00,0.00,0.00),('5','101','622','84503',1682350,'1740','241',13019.33,13019.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','84503',1682351,'1741','241',37626.03,37778.04,152.01,36482.40,0.00,0.00,0.00,0.00,0.00),('5','101','623','84503',1682352,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','84504',1682353,'1732','240',125541.75,127485.72,1943.97,272155.80,0.00,0.00,0.00,0.00,0.00),('5','101','620','84504',1682354,'1733','240',144487.47,146609.78,2122.31,297123.40,0.00,0.00,0.00,0.00,0.00),('5','101','620','84504',1682355,'1734','240',114771.67,114771.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','84504',1682356,'1735','240',117001.49,119449.78,2448.29,342760.60,0.00,0.00,0.00,0.00,0.00),('5','101','621','84504',1682357,'1736','240',191839.93,191839.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','84504',1682358,'1737','240',68466.60,70822.06,2355.46,329764.40,0.00,0.00,0.00,0.00,0.00),('5','101','621','84504',1682359,'1738','240',78414.87,78414.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','84504',1682360,'1739','240',86597.85,87866.82,1268.97,177655.80,0.00,0.00,0.00,0.00,0.00),('5','101','622','84504',1682361,'1740','241',13019.33,13019.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','84504',1682362,'1741','241',37778.04,38366.84,588.80,141312.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','84504',1682363,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','84510',1682459,'1732','240',127485.72,128679.73,1194.01,168355.41,0.00,0.00,0.00,0.00,0.00),('5','101','620','84510',1682460,'1733','240',146609.78,148274.32,1664.54,234700.14,0.00,0.00,0.00,0.00,0.00),('5','101','620','84510',1682461,'1734','240',114771.67,114771.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','84510',1682462,'1735','240',119449.78,122182.05,2732.27,385250.07,0.00,0.00,0.00,0.00,0.00),('5','101','621','84510',1682463,'1736','240',191839.93,194686.42,2846.49,401355.09,0.00,0.00,0.00,0.00,0.00),('5','101','621','84510',1682464,'1737','240',70822.06,73272.01,2449.95,345442.95,0.00,0.00,0.00,0.00,0.00),('5','101','621','84510',1682465,'1738','240',78414.87,78414.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','84510',1682466,'1739','240',87866.82,88770.33,903.51,127394.91,0.00,0.00,0.00,0.00,0.00),('5','101','622','84510',1682467,'1740','241',13019.33,13019.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','84510',1682468,'1741','241',38366.84,38623.94,257.10,61704.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','84510',1682469,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','84513',1682535,'1732','240',128679.73,128679.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','84513',1682536,'1733','240',148274.32,150748.03,2473.71,348793.11,0.00,0.00,0.00,0.00,0.00),('5','101','620','84513',1682537,'1734','240',114771.67,114771.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','84513',1682538,'1735','240',122182.05,122409.44,227.39,32061.99,0.00,0.00,0.00,0.00,0.00),('5','101','621','84513',1682539,'1736','240',194686.42,197987.80,3301.38,465494.58,0.00,0.00,0.00,0.00,0.00),('5','101','621','84513',1682540,'1737','240',73272.01,75131.14,1859.13,262137.33,0.00,0.00,0.00,0.00,0.00),('5','101','621','84513',1682541,'1738','240',78414.87,78414.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','84513',1682542,'1739','240',88770.33,90893.66,2123.33,299389.53,0.00,0.00,0.00,0.00,0.00),('5','101','622','84513',1682543,'1740','241',13019.33,13019.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','84513',1682544,'1741','241',38623.94,38833.68,209.74,47191.50,0.00,0.00,0.00,0.00,0.00),('5','101','623','84513',1682545,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','108502',2152352,'1732','240',219985.45,221775.88,1790.43,252450.63,0.00,0.00,0.00,0.00,0.00),('5','101','620','108502',2152353,'1733','240',262914.82,264210.51,1295.69,182692.29,0.00,0.00,0.00,0.00,0.00),('5','101','620','108502',2152354,'1734','240',320295.50,320903.54,608.04,85733.64,0.00,0.00,0.00,0.00,0.00),('5','101','620','108502',2152355,'1735','240',382367.28,384062.28,1695.00,238995.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','108502',2152356,'1736','240',4476.54,4476.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','108502',2152357,'1737','240',295027.31,295027.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','108502',2152358,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','108502',2152359,'1739','240',288033.89,288033.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','108502',2152360,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','108502',2152361,'1741','241',115535.00,115717.14,182.14,40981.50,0.00,0.00,0.00,0.00,0.00),('5','101','623','108502',2152362,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','108504',2152371,'1732','240',221775.88,221775.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','108504',2152372,'1733','240',264210.51,264210.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','108504',2152373,'1734','240',320903.54,323237.47,2333.93,329084.13,0.00,0.00,0.00,0.00,0.00),('5','101','620','108504',2152374,'1735','240',384062.28,385822.79,1760.51,248231.91,0.00,0.00,0.00,0.00,0.00),('5','101','621','108504',2152375,'1736','240',4476.54,4476.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','108504',2152376,'1737','240',295027.31,297693.19,2665.88,375889.08,0.00,0.00,0.00,0.00,0.00),('5','101','621','108504',2152377,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','108504',2152378,'1739','240',288033.89,290105.29,2071.40,292067.40,0.00,0.00,0.00,0.00,0.00),('5','101','622','108504',2152379,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','108504',2152380,'1741','241',115717.14,116211.28,494.14,111181.50,0.00,0.00,0.00,0.00,0.00),('5','101','623','108504',2152381,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','124192',2474849,'1732','240',221775.88,221775.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','124192',2474850,'1733','240',407349.11,407349.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','124192',2474851,'1734','240',421940.70,422895.03,954.33,136469.19,0.00,0.00,0.00,0.00,0.00),('5','101','620','124192',2474852,'1735','240',591088.82,593319.76,2230.94,319024.42,0.00,0.00,0.00,0.00,0.00),('5','101','621','124192',2474853,'1736','240',649337.73,651779.98,2442.25,349241.75,0.00,0.00,0.00,0.00,0.00),('5','101','621','124192',2474854,'1737','240',465507.60,465507.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','124192',2474855,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','124192',2474856,'1739','240',437284.20,439815.80,2531.60,362018.80,0.00,0.00,0.00,0.00,0.00),('5','101','622','124192',2474857,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','124192',2474858,'1741','241',210783.33,211937.52,1154.19,265463.70,0.00,0.00,0.00,0.00,0.00),('5','101','623','124192',2474859,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','124195',2474882,'1732','240',221775.88,221775.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','124195',2474883,'1733','240',407349.11,407349.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','124195',2474884,'1734','240',422895.03,422895.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','124195',2474885,'1735','240',593319.76,595515.89,2196.13,314046.59,0.00,0.00,0.00,0.00,0.00),('5','101','621','124195',2474886,'1736','240',651779.98,654651.37,2871.39,410608.77,0.00,0.00,0.00,0.00,0.00),('5','101','621','124195',2474887,'1737','240',465507.60,466371.83,864.23,123584.89,0.00,0.00,0.00,0.00,0.00),('5','101','621','124195',2474888,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','124195',2474889,'1739','240',439815.80,441667.19,1851.39,264748.77,0.00,0.00,0.00,0.00,0.00),('5','101','622','124195',2474890,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','124195',2474891,'1741','241',211937.52,212875.51,937.99,215737.70,0.00,0.00,0.00,0.00,0.00),('5','101','623','124195',2474892,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','124196',2474893,'1732','240',221775.88,221775.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','124196',2474894,'1733','240',407349.11,407660.96,311.85,44594.55,0.00,0.00,0.00,0.00,0.00),('5','101','620','124196',2474895,'1734','240',422895.03,423101.43,206.40,29515.20,0.00,0.00,0.00,0.00,0.00),('5','101','620','124196',2474896,'1735','240',595515.89,597773.59,2257.70,322851.10,0.00,0.00,0.00,0.00,0.00),('5','101','621','124196',2474897,'1736','240',654651.37,657051.05,2399.68,343154.24,0.00,0.00,0.00,0.00,0.00),('5','101','621','124196',2474898,'1737','240',466371.83,466691.13,319.30,45659.90,0.00,0.00,0.00,0.00,0.00),('5','101','621','124196',2474899,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','124196',2474900,'1739','240',441667.19,443666.06,1998.87,285838.41,0.00,0.00,0.00,0.00,0.00),('5','101','622','124196',2474901,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','124196',2474902,'1741','241',212875.51,213825.83,950.32,213822.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','124196',2474903,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','124197',2474904,'1732','240',221775.88,221775.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','124197',2474905,'1733','240',407660.96,407660.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','124197',2474906,'1734','240',423101.43,423968.36,866.93,123970.99,0.00,0.00,0.00,0.00,0.00),('5','101','620','124197',2474907,'1735','240',597773.59,599387.28,1613.69,230757.67,0.00,0.00,0.00,0.00,0.00),('5','101','621','124197',2474908,'1736','240',657051.05,660116.69,3065.64,438386.52,0.00,0.00,0.00,0.00,0.00),('5','101','621','124197',2474909,'1737','240',466691.13,466691.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','124197',2474910,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','124197',2474911,'1739','240',443666.06,445638.83,1972.77,282106.11,0.00,0.00,0.00,0.00,0.00),('5','101','622','124197',2474912,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','124197',2474913,'1741','241',213825.83,214940.07,1114.24,250704.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','124197',2474914,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','124990',2490650,'1732','240',221775.88,221775.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','124990',2490651,'1733','240',407660.96,408036.69,375.73,53729.39,0.00,0.00,0.00,0.00,0.00),('5','101','620','124990',2490652,'1734','240',423968.36,425671.51,1703.15,243550.45,0.00,0.00,0.00,0.00,0.00),('5','101','620','124990',2490653,'1735','240',599387.28,600692.61,1305.33,186662.19,0.00,0.00,0.00,0.00,0.00),('5','101','621','124990',2490654,'1736','240',660116.69,662805.19,2688.50,384455.50,0.00,0.00,0.00,0.00,0.00),('5','101','621','124990',2490655,'1737','240',466691.13,467200.57,509.44,72849.92,0.00,0.00,0.00,0.00,0.00),('5','101','621','124990',2490656,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','124990',2490657,'1739','240',445638.83,445638.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','124990',2490658,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','124990',2490659,'1741','241',214940.07,215631.01,690.94,155461.50,0.00,0.00,0.00,0.00,0.00),('5','101','623','124990',2490660,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','125004',2490877,'1732','240',221775.88,221775.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','125004',2490878,'1733','240',408036.69,408036.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','125004',2490879,'1734','240',425671.51,427268.63,1597.12,228388.16,0.00,0.00,0.00,0.00,0.00),('5','101','620','125004',2490880,'1735','240',600692.61,602407.33,1714.72,245204.96,0.00,0.00,0.00,0.00,0.00),('5','101','621','125004',2490881,'1736','240',662805.19,664767.97,1962.78,280677.54,0.00,0.00,0.00,0.00,0.00),('5','101','621','125004',2490882,'1737','240',467200.57,468452.71,1252.14,179056.02,0.00,0.00,0.00,0.00,0.00),('5','101','621','125004',2490883,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','125004',2490884,'1739','240',445638.83,448509.73,2870.90,410538.70,0.00,0.00,0.00,0.00,0.00),('5','101','622','125004',2490885,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','125004',2490886,'1741','241',215631.01,216216.67,585.66,131773.50,0.00,0.00,0.00,0.00,0.00),('5','101','623','125004',2490887,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','125011',2491007,'1732','240',221775.88,221775.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','125011',2491008,'1733','240',408036.69,408036.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','125011',2491009,'1734','240',427268.63,429452.90,2184.27,312350.61,0.00,0.00,0.00,0.00,0.00),('5','101','620','125011',2491010,'1735','240',602407.33,604143.95,1736.62,248336.66,0.00,0.00,0.00,0.00,0.00),('5','101','621','125011',2491011,'1736','240',664767.97,665770.28,1002.31,143330.33,0.00,0.00,0.00,0.00,0.00),('5','101','621','125011',2491012,'1737','240',468452.71,469331.77,879.06,125705.58,0.00,0.00,0.00,0.00,0.00),('5','101','621','125011',2491013,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','125011',2491014,'1739','240',448509.73,450431.47,1921.74,274808.82,0.00,0.00,0.00,0.00,0.00),('5','101','622','125011',2491015,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','125011',2491016,'1741','241',216216.67,216737.78,521.11,117249.75,0.00,0.00,0.00,0.00,0.00),('5','101','623','125011',2491017,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','125017',2491083,'1732','240',221775.88,221775.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','125017',2491084,'1733','240',408036.69,408036.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','125017',2491085,'1734','240',429452.90,430793.22,1340.32,191665.76,0.00,0.00,0.00,0.00,0.00),('5','101','620','125017',2491086,'1735','240',604143.95,605775.02,1631.07,233243.01,0.00,0.00,0.00,0.00,0.00),('5','101','621','125017',2491087,'1736','240',665770.28,668660.84,2890.56,413350.08,0.00,0.00,0.00,0.00,0.00),('5','101','621','125017',2491088,'1737','240',469331.77,469331.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','125017',2491089,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','125017',2491090,'1739','240',450431.47,452224.38,1792.91,256386.13,0.00,0.00,0.00,0.00,0.00),('5','101','622','125017',2491091,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','125017',2491092,'1741','241',216737.78,217371.38,633.60,142560.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','125017',2491093,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','125019',2491103,'1732','240',221775.88,221775.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','125019',2491104,'1733','240',408036.69,408036.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','125019',2491105,'1734','240',430793.22,432236.32,1443.10,206363.30,0.00,0.00,0.00,0.00,0.00),('5','101','620','125019',2491106,'1735','240',605775.02,606675.27,900.25,128735.75,0.00,0.00,0.00,0.00,0.00),('5','101','621','125019',2491107,'1736','240',668660.84,670671.00,2010.16,287452.88,0.00,0.00,0.00,0.00,0.00),('5','101','621','125019',2491108,'1737','240',469331.77,469935.03,603.26,86266.18,0.00,0.00,0.00,0.00,0.00),('5','101','621','125019',2491109,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','125019',2491110,'1739','240',452224.38,453756.97,1532.59,219160.37,0.00,0.00,0.00,0.00,0.00),('5','101','622','125019',2491111,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','125019',2491112,'1741','241',217371.38,218494.36,1122.98,252670.50,0.00,0.00,0.00,0.00,0.00),('5','101','623','125019',2491113,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','125021',2491123,'1732','240',221775.88,221775.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','125021',2491124,'1733','240',408036.69,408827.68,790.99,113111.57,0.00,0.00,0.00,0.00,0.00),('5','101','620','125021',2491125,'1734','240',432236.32,434504.25,2267.93,324313.99,0.00,0.00,0.00,0.00,0.00),('5','101','620','125021',2491126,'1735','240',606675.27,606675.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','125021',2491127,'1736','240',670671.00,672908.92,2237.92,320022.56,0.00,0.00,0.00,0.00,0.00),('5','101','621','125021',2491128,'1737','240',469935.03,469935.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','125021',2491129,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','125021',2491130,'1739','240',453756.97,455349.84,1592.87,227780.41,0.00,0.00,0.00,0.00,0.00),('5','101','622','125021',2491131,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','125021',2491132,'1741','241',218494.36,219228.09,733.73,165089.25,0.00,0.00,0.00,0.00,0.00),('5','101','623','125021',2491133,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','125732',2505301,'1732','240',221775.88,221775.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','125732',2505302,'1733','240',408827.68,410483.93,1656.25,236843.75,0.00,0.00,0.00,0.00,0.00),('5','101','620','125732',2505303,'1734','240',434504.25,439379.10,4874.85,697103.55,0.00,0.00,0.00,0.00,0.00),('5','101','620','125732',2505304,'1735','240',606675.27,609706.09,3030.82,433407.26,0.00,0.00,0.00,0.00,0.00),('5','101','621','125732',2505305,'1736','240',672908.92,673688.13,779.21,111427.03,0.00,0.00,0.00,0.00,0.00),('5','101','621','125732',2505306,'1737','240',469935.03,470657.17,722.14,103266.02,0.00,0.00,0.00,0.00,0.00),('5','101','621','125732',2505307,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','125732',2505308,'1739','240',455349.84,458834.45,3484.61,498299.23,0.00,0.00,0.00,0.00,0.00),('5','101','622','125732',2505309,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','125732',2505310,'1741','241',219228.09,220723.93,1495.84,336564.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','125732',2505311,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','125733',2505312,'1732','240',221775.88,221775.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','125733',2505313,'1733','240',410483.93,410483.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','125733',2505314,'1734','240',439379.10,442094.34,2715.24,388279.32,0.00,0.00,0.00,0.00,0.00),('5','101','620','125733',2505315,'1735','240',609706.09,609775.57,69.48,9935.64,0.00,0.00,0.00,0.00,0.00),('5','101','621','125733',2505316,'1736','240',673688.13,676360.43,2672.30,382138.90,0.00,0.00,0.00,0.00,0.00),('5','101','621','125733',2505317,'1737','240',470657.17,470657.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','125733',2505318,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','125733',2505319,'1739','240',458834.45,461226.45,2392.00,342056.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','125733',2505320,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','125733',2505321,'1741','241',220723.93,221680.12,956.19,215142.75,0.00,0.00,0.00,0.00,0.00),('5','101','623','125733',2505322,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','125734',2505323,'1732','240',221775.88,221775.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','125734',2505324,'1733','240',410483.93,411533.99,1050.06,150158.58,0.00,0.00,0.00,0.00,0.00),('5','101','620','125734',2505325,'1734','240',442094.34,444212.76,2118.42,302934.06,0.00,0.00,0.00,0.00,0.00),('5','101','620','125734',2505326,'1735','240',609775.57,610874.91,1099.34,157205.62,0.00,0.00,0.00,0.00,0.00),('5','101','621','125734',2505327,'1736','240',676360.43,677984.90,1624.47,232299.21,0.00,0.00,0.00,0.00,0.00),('5','101','621','125734',2505328,'1737','240',470657.17,470657.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','125734',2505329,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','125734',2505330,'1739','240',461226.45,462996.86,1770.41,253168.63,0.00,0.00,0.00,0.00,0.00),('5','101','622','125734',2505331,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','125734',2505332,'1741','241',221680.12,222420.60,740.48,166608.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','125734',2505333,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','125736',2505350,'1732','240',221775.88,221775.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','125736',2505351,'1733','240',411533.99,414082.99,2549.00,364507.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','125736',2505352,'1734','240',444212.76,446817.20,2604.44,372434.92,0.00,0.00,0.00,0.00,0.00),('5','101','620','125736',2505353,'1735','240',610874.91,613257.85,2382.94,340760.42,0.00,0.00,0.00,0.00,0.00),('5','101','621','125736',2505354,'1736','240',677984.90,677984.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','125736',2505355,'1737','240',470657.17,470657.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','125736',2505356,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','125736',2505357,'1739','240',462996.86,462996.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','125736',2505358,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','125736',2505359,'1741','241',222420.60,223327.90,907.30,204142.50,0.00,0.00,0.00,0.00,0.00),('5','101','623','125736',2505360,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','125737',2505361,'1732','240',221775.88,221775.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','125737',2505362,'1733','240',414082.99,414082.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','125737',2505363,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','125737',2505364,'1735','240',613257.85,613257.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','125737',2505365,'1736','240',677984.90,677984.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','125737',2505366,'1737','240',470657.17,470657.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','125737',2505367,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','125737',2505368,'1739','240',462996.86,462996.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','125737',2505369,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','125737',2505370,'1741','241',223327.90,223327.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','125737',2505371,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','181610',3566400,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','181610',3566401,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','181610',3566402,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','181610',3566403,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','181610',3566404,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','181610',3566405,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','181610',3566406,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','181610',3566407,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','181610',3566408,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','181610',3566409,'1741','241',596791.99,596791.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','181610',3566410,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','181693',3568021,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','181693',3568022,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','181693',3568023,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','181693',3568024,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','181693',3568025,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','181693',3568026,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','181693',3568027,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','181693',3568028,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','181693',3568029,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','181693',3568030,'1741','241',596791.99,596791.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','181693',3568031,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','182228',3577585,'1732','240',501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','182228',3577586,'1733','240',690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','182228',3577587,'1734','240',446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','182228',3577588,'1735','240',1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','182228',3577589,'1736','240',1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','182228',3577590,'1737','240',716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','182228',3577591,'1738','240',107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','182228',3577592,'1739','240',858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','182228',3577593,'1740','241',13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','182228',3577594,'1741','241',596791.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','182228',3577595,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','182456',3581627,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','182456',3581628,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','182456',3581629,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','182456',3581630,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','182456',3581631,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','182456',3581632,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','182456',3581633,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','182456',3581634,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','182456',3581635,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','182456',3581636,'1741','241',607138.07,608247.88,1109.81,277452.50,0.00,0.00,0.00,0.00,0.00),('5','101','623','182456',3581637,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','182456',3581638,'2705','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','182456',3581639,'2706','240',701962.26,702865.10,902.84,147162.92,0.00,0.00,0.00,0.00,0.00),('5','101','916','182456',3581640,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','182456',3581641,'2708','240',1170271.99,1172246.59,1974.60,321859.80,0.00,0.00,0.00,0.00,0.00),('5','101','917','182456',3581642,'2709','240',1386003.35,1387982.47,1979.12,322596.56,0.00,0.00,0.00,0.00,0.00),('5','101','917','182456',3581643,'2710','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','182456',3581644,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','182456',3581645,'2712','240',863987.06,867138.85,3151.79,513741.77,0.00,0.00,0.00,0.00,0.00),('5','101','620','182629',3584813,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','182629',3584814,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','182629',3584815,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','182629',3584816,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','182629',3584817,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','182629',3584818,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','182629',3584819,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','182629',3584820,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','182629',3584821,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','182629',3584822,'1741','241',608247.88,616866.77,8618.89,2154722.50,0.00,0.00,0.00,0.00,0.00),('5','101','623','182629',3584823,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','182629',3584824,'2705','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','182629',3584825,'2706','240',702865.10,703975.42,1110.32,180982.16,0.00,0.00,0.00,0.00,0.00),('5','101','916','182629',3584826,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','182629',3584827,'2708','240',1172246.59,1174035.77,1789.18,291636.34,0.00,0.00,0.00,0.00,0.00),('5','101','917','182629',3584828,'2709','240',1387982.47,1390566.34,2583.87,421170.81,0.00,0.00,0.00,0.00,0.00),('5','101','917','182629',3584829,'2710','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','182629',3584830,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','182629',3584831,'2712','240',867138.85,869790.36,2651.51,432196.13,0.00,0.00,0.00,0.00,0.00),('5','101','620','182976',3591325,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','182976',3591326,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','182976',3591327,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','182976',3591328,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','182976',3591329,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','182976',3591330,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','182976',3591331,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','182976',3591332,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','182976',3591333,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','182976',3591334,'1741','241',616866.77,617845.93,979.16,244790.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','182976',3591335,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','182976',3591336,'2705','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','182976',3591337,'2706','240',703975.42,704944.21,968.79,157912.77,0.00,0.00,0.00,0.00,0.00),('5','101','916','182976',3591338,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','182976',3591339,'2708','240',1174035.77,1177500.98,3465.21,564829.23,0.00,0.00,0.00,0.00,0.00),('5','101','917','182976',3591340,'2709','240',1390566.34,1393101.16,2534.82,413175.66,0.00,0.00,0.00,0.00,0.00),('5','101','917','182976',3591341,'2710','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','182976',3591342,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','182976',3591343,'2712','240',869790.36,871563.19,1772.83,288971.29,0.00,0.00,0.00,0.00,0.00),('5','101','620','183109',3593634,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','183109',3593635,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','183109',3593636,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','183109',3593637,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','183109',3593638,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','183109',3593639,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','183109',3593640,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','183109',3593641,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','183109',3593642,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','183109',3593643,'1741','241',617845.93,618553.76,707.83,176957.50,0.00,0.00,0.00,0.00,0.00),('5','101','623','183109',3593644,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','183109',3593645,'2705','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','183109',3593646,'2706','240',704944.21,704944.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','183109',3593647,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','183109',3593648,'2708','240',1177500.98,1180174.65,2673.67,435808.21,0.00,0.00,0.00,0.00,0.00),('5','101','917','183109',3593649,'2709','240',1393101.16,1396511.88,3410.72,555947.36,0.00,0.00,0.00,0.00,0.00),('5','101','917','183109',3593650,'2710','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','183109',3593651,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','183109',3593652,'2712','240',871563.19,874417.95,2854.76,465325.88,0.00,0.00,0.00,0.00,0.00),('5','101','620','183202',3595481,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','183202',3595482,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','183202',3595483,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','183202',3595484,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','183202',3595485,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','183202',3595486,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','183202',3595487,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','183202',3595488,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','183202',3595489,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','183202',3595490,'1741','241',618553.76,619415.66,861.90,228403.50,0.00,0.00,0.00,0.00,0.00),('5','101','623','183202',3595491,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','183202',3595492,'2705','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','183202',3595493,'2706','240',704944.21,704944.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','183202',3595494,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','183202',3595495,'2708','240',1180174.65,1183863.73,3689.08,601320.04,0.00,0.00,0.00,0.00,0.00),('5','101','917','183202',3595496,'2709','240',1396511.88,1399332.02,2820.14,459682.82,0.00,0.00,0.00,0.00,0.00),('5','101','917','183202',3595497,'2710','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','183202',3595498,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','183202',3595499,'2712','240',874417.95,876785.09,2367.14,385843.82,0.00,0.00,0.00,0.00,0.00),('5','101','620','183419',3599344,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','183419',3599345,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','183419',3599346,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','183419',3599347,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','183419',3599348,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','183419',3599349,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','183419',3599350,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','183419',3599351,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','183419',3599352,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','183419',3599353,'1741','241',619415.66,626974.25,7558.59,2003026.35,0.00,0.00,0.00,0.00,0.00),('5','101','623','183419',3599354,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','183419',3599355,'2705','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','183419',3599356,'2706','240',704944.21,707442.68,2498.47,407250.61,0.00,0.00,0.00,0.00,0.00),('5','101','916','183419',3599357,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','183419',3599358,'2708','240',1183863.73,1187604.60,3740.87,609761.81,0.00,0.00,0.00,0.00,0.00),('5','101','917','183419',3599359,'2709','240',1399332.02,1400470.08,1138.06,185503.78,0.00,0.00,0.00,0.00,0.00),('5','101','917','183419',3599360,'2710','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','183419',3599361,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','183419',3599362,'2712','240',876785.09,877682.32,897.23,146248.49,0.00,0.00,0.00,0.00,0.00),('5','101','620','183979',3609492,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','183979',3609493,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','183979',3609494,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','183979',3609495,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','183979',3609496,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','183979',3609497,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','183979',3609498,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','183979',3609499,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','183979',3609500,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','183979',3609501,'1741','241',626974.25,627873.74,899.49,238364.85,0.00,0.00,0.00,0.00,0.00),('5','101','623','183979',3609502,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','183979',3609503,'2705','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','183979',3609504,'2706','240',707442.68,707442.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','183979',3609505,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','183979',3609506,'2708','240',1187604.60,1190287.64,2683.04,437335.52,0.00,0.00,0.00,0.00,0.00),('5','101','917','183979',3609507,'2709','240',1400470.08,1403959.07,3488.99,568705.37,0.00,0.00,0.00,0.00,0.00),('5','101','917','183979',3609508,'2710','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','183979',3609509,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','183979',3609510,'2712','240',877682.32,880168.80,2486.48,405296.24,0.00,0.00,0.00,0.00,0.00),('5','101','620','183996',3609735,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','183996',3609736,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','183996',3609737,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','183996',3609738,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','183996',3609739,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','183996',3609740,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','183996',3609741,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','183996',3609742,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','183996',3609743,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','183996',3609744,'1741','241',627873.74,635783.32,7909.58,2096038.70,0.00,0.00,0.00,0.00,0.00),('5','101','623','183996',3609745,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','183996',3609746,'2705','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','183996',3609747,'2706','240',707442.68,707442.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','183996',3609748,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','183996',3609749,'2708','240',1190287.64,1193287.07,2999.43,488907.09,0.00,0.00,0.00,0.00,0.00),('5','101','917','183996',3609750,'2709','240',1403959.07,1407328.40,3369.33,549200.79,0.00,0.00,0.00,0.00,0.00),('5','101','917','183996',3609751,'2710','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','183996',3609752,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','183996',3609753,'2712','240',880168.80,881853.66,1684.86,274632.18,0.00,0.00,0.00,0.00,0.00),('5','101','620','184238',3614139,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','184238',3614140,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','184238',3614141,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','184238',3614142,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','184238',3614143,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','184238',3614144,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','184238',3614145,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','184238',3614146,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','184238',3614147,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','184238',3614148,'1741','241',635783.32,637985.77,2202.45,561624.75,0.00,0.00,0.00,0.00,0.00),('5','101','623','184238',3614149,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','184238',3614150,'2705','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','184238',3614151,'2706','240',707442.68,709313.28,1870.60,304907.80,0.00,0.00,0.00,0.00,0.00),('5','101','916','184238',3614152,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','184238',3614153,'2708','240',1193287.07,1196306.99,3019.92,492246.96,0.00,0.00,0.00,0.00,0.00),('5','101','917','184238',3614154,'2709','240',1407328.40,1412277.79,4949.39,806750.57,0.00,0.00,0.00,0.00,0.00),('5','101','917','184238',3614155,'2710','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','184238',3614156,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','184238',3614157,'2712','240',881853.66,885969.60,4115.94,670898.22,0.00,0.00,0.00,0.00,0.00),('5','101','620','184600',3620628,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','184600',3620629,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','184600',3620630,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','184600',3620631,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','184600',3620632,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','184600',3620633,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','184600',3620634,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','184600',3620635,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','184600',3620636,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','184600',3620637,'1741','241',637985.77,640360.15,2374.38,605466.90,0.00,0.00,0.00,0.00,0.00),('5','101','623','184600',3620638,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','184600',3620639,'2705','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','184600',3620640,'2706','240',709313.28,711747.90,2434.62,396843.06,0.00,0.00,0.00,0.00,0.00),('5','101','916','184600',3620641,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','184600',3620642,'2708','240',1196306.99,1200991.15,4684.16,763518.08,0.00,0.00,0.00,0.00,0.00),('5','101','917','184600',3620643,'2709','240',1412277.79,1416023.10,3745.31,610485.53,0.00,0.00,0.00,0.00,0.00),('5','101','917','184600',3620644,'2710','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','184600',3620645,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','184600',3620646,'2712','240',885969.60,885969.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','184609',3620766,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','184609',3620767,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','184609',3620768,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','184609',3620769,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','184609',3620770,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','184609',3620771,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','184609',3620772,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','184609',3620773,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','184609',3620774,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','184609',3620775,'1741','241',640360.15,641386.61,1026.46,261747.30,0.00,0.00,0.00,0.00,0.00),('5','101','623','184609',3620776,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','184609',3620777,'2705','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','184609',3620778,'2706','240',711747.90,713734.89,1986.99,323879.37,0.00,0.00,0.00,0.00,0.00),('5','101','916','184609',3620779,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','184609',3620780,'2708','240',1200991.15,1204480.71,3489.56,568798.28,0.00,0.00,0.00,0.00,0.00),('5','101','917','184609',3620781,'2709','240',1416023.10,1419330.65,3307.55,539130.65,0.00,0.00,0.00,0.00,0.00),('5','101','917','184609',3620782,'2710','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','184609',3620783,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','184609',3620784,'2712','240',885969.60,887217.15,1247.55,203350.65,0.00,0.00,0.00,0.00,0.00),('5','101','620','184989',3627451,'1732','240',501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','184989',3627452,'1733','240',690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','184989',3627453,'1734','240',446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','184989',3627454,'1735','240',1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','184989',3627455,'1736','240',1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','184989',3627456,'1737','240',716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','184989',3627457,'1738','240',107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','184989',3627458,'1739','240',858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','184989',3627459,'1740','241',13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','184989',3627460,'1741','241',641386.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','184989',3627461,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','184989',3627462,'2705','240',501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','184989',3627463,'2706','240',713734.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','184989',3627464,'2707','240',502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','184989',3627465,'2708','240',1204480.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','184989',3627466,'2709','240',1419330.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','184989',3627467,'2710','240',716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','184989',3627468,'2711','240',114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','184989',3627469,'2712','240',887217.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','184994',3627513,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','184994',3627514,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','184994',3627515,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','184994',3627516,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','184994',3627517,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','184994',3627518,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','184994',3627519,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','184994',3627520,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','184994',3627521,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','184994',3627522,'1741','241',641386.61,642817.82,1431.21,364958.55,0.00,0.00,0.00,0.00,0.00),('5','101','623','184994',3627523,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','184994',3627524,'2705','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','184994',3627525,'2706','240',713734.89,716906.06,3171.17,516900.71,0.00,0.00,0.00,0.00,0.00),('5','101','916','184994',3627526,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','184994',3627527,'2708','240',1204480.71,1209024.79,4544.08,740685.04,0.00,0.00,0.00,0.00,0.00),('5','101','917','184994',3627528,'2709','240',1419330.65,1420283.46,952.81,155308.03,0.00,0.00,0.00,0.00,0.00),('5','101','917','184994',3627529,'2710','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','184994',3627530,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','184994',3627531,'2712','240',887217.15,887281.53,64.38,10493.94,0.00,0.00,0.00,0.00,0.00),('5','101','620','184996',3627545,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','184996',3627546,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','184996',3627547,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','184996',3627548,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','184996',3627549,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','184996',3627550,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','184996',3627551,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','184996',3627552,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','184996',3627553,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','184996',3627554,'1741','241',642817.82,642817.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','184996',3627555,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','184996',3627556,'2705','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','184996',3627557,'2706','240',716906.06,719239.15,2333.09,380293.67,0.00,0.00,0.00,0.00,0.00),('5','101','916','184996',3627558,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','184996',3627559,'2708','240',1209024.79,1210045.00,1020.21,166294.23,0.00,0.00,0.00,0.00,0.00),('5','101','917','184996',3627560,'2709','240',1420283.46,1421687.24,1403.78,228816.14,0.00,0.00,0.00,0.00,0.00),('5','101','917','184996',3627561,'2710','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','184996',3627562,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','184996',3627563,'2712','240',887281.53,888335.14,1053.61,171738.43,0.00,0.00,0.00,0.00,0.00),('5','101','620','185000',3627584,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','185000',3627585,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','185000',3627586,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','185000',3627587,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','185000',3627588,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','185000',3627589,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','185000',3627590,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','185000',3627591,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','185000',3627592,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','185000',3627593,'1741','241',642817.82,642817.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','185000',3627594,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','185000',3627595,'2705','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','185000',3627596,'2706','240',719239.15,720251.79,1012.64,165060.32,0.00,0.00,0.00,0.00,0.00),('5','101','916','185000',3627597,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','185000',3627598,'2708','240',1210045.00,1213477.85,3432.85,559554.55,0.00,0.00,0.00,0.00,0.00),('5','101','917','185000',3627599,'2709','240',1421687.24,1425157.07,3469.83,565582.29,0.00,0.00,0.00,0.00,0.00),('5','101','917','185000',3627600,'2710','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','185000',3627601,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','185000',3627602,'2712','240',888335.14,890445.27,2110.13,343951.19,0.00,0.00,0.00,0.00,0.00),('5','101','620','185205',3631220,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','185205',3631221,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','185205',3631222,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','185205',3631223,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','185205',3631224,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','185205',3631225,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','185205',3631226,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','185205',3631227,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','185205',3631228,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','185205',3631229,'1741','241',642817.82,642817.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','185205',3631230,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','185205',3631231,'2705','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','185205',3631232,'2706','240',720251.79,722521.51,2269.72,369964.36,0.00,0.00,0.00,0.00,0.00),('5','101','916','185205',3631233,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','185205',3631234,'2708','240',1213477.85,1214444.74,966.89,157603.07,0.00,0.00,0.00,0.00,0.00),('5','101','917','185205',3631235,'2709','240',1425157.07,1428134.52,2977.45,485324.35,0.00,0.00,0.00,0.00,0.00),('5','101','917','185205',3631236,'2710','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','185205',3631237,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','185205',3631238,'2712','240',890445.27,893041.35,2596.08,423161.04,0.00,0.00,0.00,0.00,0.00),('5','101','620','185276',3632063,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','185276',3632064,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','185276',3632065,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','185276',3632066,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','185276',3632067,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','185276',3632068,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','185276',3632069,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','185276',3632070,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','185276',3632071,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','185276',3632072,'1741','241',642817.82,642817.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','185276',3632073,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','185276',3632074,'2705','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','185276',3632075,'2706','240',722521.51,725547.58,3026.07,490223.34,0.00,0.00,0.00,0.00,0.00),('5','101','916','185276',3632076,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','185276',3632077,'2708','240',1214444.74,1214455.25,10.51,1702.62,0.00,0.00,0.00,0.00,0.00),('5','101','917','185276',3632078,'2709','240',1428134.52,1432033.95,3899.43,631707.66,0.00,0.00,0.00,0.00,0.00),('5','101','917','185276',3632079,'2710','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','185276',3632080,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','185276',3632081,'2712','240',893041.35,896851.71,3810.36,617278.32,0.00,0.00,0.00,0.00,0.00),('5','101','620','185512',3636469,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','185512',3636470,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','185512',3636471,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','185512',3636472,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','185512',3636473,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','185512',3636474,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','185512',3636475,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','185512',3636476,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','185512',3636477,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','185512',3636478,'1741','241',642817.82,642817.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','185512',3636479,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','185512',3636480,'2705','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','185512',3636481,'2706','240',725547.58,728269.72,2722.14,440986.68,0.00,0.00,0.00,0.00,0.00),('5','101','916','185512',3636482,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','185512',3636483,'2708','240',1214455.25,1214455.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','185512',3636484,'2709','240',1432033.95,1435776.26,3742.31,606254.22,0.00,0.00,0.00,0.00,0.00),('5','101','917','185512',3636485,'2710','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','185512',3636486,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','185512',3636487,'2712','240',896851.71,899449.25,2597.54,420801.48,0.00,0.00,0.00,0.00,0.00),('5','101','620','185805',3641715,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','185805',3641716,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','185805',3641717,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','185805',3641718,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','185805',3641719,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','185805',3641720,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','185805',3641721,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','185805',3641722,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','185805',3641723,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','185805',3641724,'1741','241',642817.82,642817.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','185805',3641725,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','185805',3641726,'2705','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','185805',3641727,'2706','240',728269.72,730353.60,2083.88,337588.56,0.00,0.00,0.00,0.00,0.00),('5','101','916','185805',3641728,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','185805',3641729,'2708','240',1214455.25,1214455.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','185805',3641730,'2709','240',1435776.26,1439903.31,4127.05,668582.10,0.00,0.00,0.00,0.00,0.00),('5','101','917','185805',3641731,'2710','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','185805',3641732,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','185805',3641733,'2712','240',899449.25,902966.03,3516.78,569718.36,0.00,0.00,0.00,0.00,0.00),('5','101','620','185990',3645161,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','185990',3645162,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','185990',3645163,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','185990',3645164,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','185990',3645165,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','185990',3645166,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','185990',3645167,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','185990',3645168,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','185990',3645169,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','185990',3645170,'1741','241',642817.82,642817.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','185990',3645171,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','185990',3645172,'2705','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','185990',3645173,'2706','240',730353.60,733587.61,3234.01,523909.62,0.00,0.00,0.00,0.00,0.00),('5','101','916','185990',3645174,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','185990',3645175,'2708','240',1214455.25,1214462.38,7.13,1155.06,0.00,0.00,0.00,0.00,0.00),('5','101','917','185990',3645176,'2709','240',1439903.31,1444131.23,4227.92,684923.04,0.00,0.00,0.00,0.00,0.00),('5','101','917','185990',3645177,'2710','240',716897.36,716908.73,11.37,1841.94,0.00,0.00,0.00,0.00,0.00),('5','101','917','185990',3645178,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','185990',3645179,'2712','240',902966.03,905512.04,2546.01,412453.62,0.00,0.00,0.00,0.00,0.00),('5','101','620','186182',3648356,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','186182',3648357,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','186182',3648358,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','186182',3648359,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','186182',3648360,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','186182',3648361,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','186182',3648362,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','186182',3648363,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','186182',3648364,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','186182',3648365,'1741','241',642817.82,642817.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','186182',3648366,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','186182',3648367,'2705','240',501154.12,501998.06,843.94,136718.28,0.00,0.00,0.00,0.00,0.00),('5','101','916','186182',3648368,'2706','240',733587.61,736172.39,2584.78,418734.36,0.00,0.00,0.00,0.00,0.00),('5','101','916','186182',3648369,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','186182',3648370,'2708','240',1214462.38,1215339.89,877.51,142156.62,0.00,0.00,0.00,0.00,0.00),('5','101','917','186182',3648371,'2709','240',1444131.23,1446416.12,2284.89,370152.18,0.00,0.00,0.00,0.00,0.00),('5','101','917','186182',3648372,'2710','240',716908.73,717079.37,170.64,27643.68,0.00,0.00,0.00,0.00,0.00),('5','101','917','186182',3648373,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','186182',3648374,'2712','240',905512.04,908142.48,2630.44,426131.28,0.00,0.00,0.00,0.00,0.00),('5','101','620','186487',3653616,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','186487',3653617,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','186487',3653618,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','186487',3653619,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','186487',3653620,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','186487',3653621,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','186487',3653622,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','186487',3653623,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','186487',3653624,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','186487',3653625,'1741','241',642817.82,642817.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','186487',3653626,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','186487',3653627,'2705','240',501998.06,501998.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','186487',3653628,'2706','240',736172.39,737307.30,1134.91,183855.42,0.00,0.00,0.00,0.00,0.00),('5','101','916','186487',3653629,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','186487',3653630,'2708','240',1215339.89,1218138.38,2798.49,453355.38,0.00,0.00,0.00,0.00,0.00),('5','101','917','186487',3653631,'2709','240',1446416.12,1449033.98,2617.86,424093.32,0.00,0.00,0.00,0.00,0.00),('5','101','917','186487',3653632,'2710','240',717079.37,717449.28,369.91,59925.42,0.00,0.00,0.00,0.00,0.00),('5','101','917','186487',3653633,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','186487',3653634,'2712','240',908142.48,910384.68,2242.20,363236.40,0.00,0.00,0.00,0.00,0.00),('5','101','620','186777',3658469,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','186777',3658470,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','186777',3658471,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','186777',3658472,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','186777',3658473,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','186777',3658474,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','186777',3658475,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','186777',3658476,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','186777',3658477,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','186777',3658478,'1741','241',642817.82,642817.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','186777',3658479,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','186777',3658480,'2705','240',501998.06,501998.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','186777',3658481,'2706','240',737307.30,739555.10,2247.80,364143.60,0.00,0.00,0.00,0.00,0.00),('5','101','916','186777',3658482,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','186777',3658483,'2708','240',1218138.38,1221439.81,3301.43,534831.66,0.00,0.00,0.00,0.00,0.00),('5','101','917','186777',3658484,'2709','240',1449033.98,1451933.45,2899.47,469714.14,0.00,0.00,0.00,0.00,0.00),('5','101','917','186777',3658485,'2710','240',717449.28,717799.77,350.49,56779.38,0.00,0.00,0.00,0.00,0.00),('5','101','917','186777',3658486,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','186777',3658487,'2712','240',910384.68,911406.97,1022.29,165610.98,0.00,0.00,0.00,0.00,0.00),('5','101','620','186830',3659494,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','186830',3659495,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','186830',3659496,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','186830',3659497,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','186830',3659498,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','186830',3659499,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','186830',3659500,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','186830',3659501,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','186830',3659502,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','186830',3659503,'1741','241',642817.82,642817.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','186830',3659504,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','186830',3659505,'2705','240',501998.06,502943.50,945.44,153161.28,0.00,0.00,0.00,0.00,0.00),('5','101','916','186830',3659506,'2706','240',739555.10,741472.44,1917.34,310609.08,0.00,0.00,0.00,0.00,0.00),('5','101','916','186830',3659507,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','186830',3659508,'2708','240',1221439.81,1223805.72,2365.91,383277.42,0.00,0.00,0.00,0.00,0.00),('5','101','917','186830',3659509,'2709','240',1451933.45,1452183.58,250.13,40521.06,0.00,0.00,0.00,0.00,0.00),('5','101','917','186830',3659510,'2710','240',717799.77,721029.42,3229.65,523203.30,0.00,0.00,0.00,0.00,0.00),('5','101','917','186830',3659511,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','186830',3659512,'2712','240',911406.97,911896.08,489.11,79235.82,0.00,0.00,0.00,0.00,0.00),('5','101','620','187073',3663449,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','187073',3663450,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','187073',3663451,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','187073',3663452,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','187073',3663453,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','187073',3663454,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','187073',3663455,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','187073',3663456,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','187073',3663457,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','187073',3663458,'1741','241',642817.82,642817.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','187073',3663459,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','187073',3663460,'2705','240',502943.50,502943.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','187073',3663461,'2706','240',741472.44,744700.62,3228.18,522965.16,0.00,0.00,0.00,0.00,0.00),('5','101','916','187073',3663462,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','187073',3663463,'2708','240',1223805.72,1226403.40,2597.68,420824.16,0.00,0.00,0.00,0.00,0.00),('5','101','917','187073',3663464,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','187073',3663465,'2710','240',721029.42,721029.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','187073',3663466,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','187073',3663467,'2712','240',911896.08,914247.71,2351.63,380964.06,0.00,0.00,0.00,0.00,0.00),('5','101','620','187288',3667281,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','187288',3667282,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','187288',3667283,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','187288',3667284,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','187288',3667285,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','187288',3667286,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','187288',3667287,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','187288',3667288,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','187288',3667289,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','187288',3667290,'1741','241',642817.82,642817.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','187288',3667291,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','187288',3667292,'2705','240',502943.50,502943.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','187288',3667293,'2706','240',744700.62,747741.93,3041.31,492692.22,0.00,0.00,0.00,0.00,0.00),('5','101','916','187288',3667294,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','187288',3667295,'2708','240',1226403.40,1230027.57,3624.17,587115.54,0.00,0.00,0.00,0.00,0.00),('5','101','917','187288',3667296,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','187288',3667297,'2710','240',721029.42,722313.68,1284.26,208050.12,0.00,0.00,0.00,0.00,0.00),('5','101','917','187288',3667298,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','187288',3667299,'2712','240',914247.71,916039.02,1791.31,290192.22,0.00,0.00,0.00,0.00,0.00),('5','101','620','187418',3669669,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','187418',3669670,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','187418',3669671,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','187418',3669672,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','187418',3669673,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','187418',3669674,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','187418',3669675,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','187418',3669676,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','187418',3669677,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','187418',3669678,'1741','241',642817.82,642817.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','187418',3669679,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','187418',3669680,'2705','240',502943.50,502943.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','187418',3669681,'2706','240',747741.93,747741.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','187418',3669682,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','187418',3669683,'2708','240',1230027.57,1232527.61,2500.04,405006.48,0.00,0.00,0.00,0.00,0.00),('5','101','917','187418',3669684,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','187418',3669685,'2710','240',722313.68,725838.08,3524.40,570952.80,0.00,0.00,0.00,0.00,0.00),('5','101','917','187418',3669686,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','187418',3669687,'2712','240',916039.02,919165.56,3126.54,506499.48,0.00,0.00,0.00,0.00,0.00),('5','101','620','187750',3675639,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','187750',3675640,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','187750',3675641,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','187750',3675642,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','187750',3675643,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','187750',3675644,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','187750',3675645,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','187750',3675646,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','187750',3675647,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','187750',3675648,'1741','241',642817.82,642817.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','187750',3675649,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','187750',3675650,'2705','240',502943.50,502943.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','187750',3675651,'2706','240',747741.93,748400.24,658.31,106646.22,0.00,0.00,0.00,0.00,0.00),('5','101','916','187750',3675652,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','187750',3675653,'2708','240',1232527.61,1235079.77,2552.16,413449.92,0.00,0.00,0.00,0.00,0.00),('5','101','917','187750',3675654,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','187750',3675655,'2710','240',725838.08,729042.39,3204.31,519098.22,0.00,0.00,0.00,0.00,0.00),('5','101','917','187750',3675656,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','187750',3675657,'2712','240',919165.56,921555.06,2389.50,387099.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','187794',3676351,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','187794',3676352,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','187794',3676353,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','187794',3676354,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','187794',3676355,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','187794',3676356,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','187794',3676357,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','187794',3676358,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','187794',3676359,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','187794',3676360,'1741','241',642817.82,642817.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','187794',3676361,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','187794',3676362,'2705','240',502943.50,502943.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','187794',3676363,'2706','240',748400.24,749312.40,912.16,147769.92,0.00,0.00,0.00,0.00,0.00),('5','101','916','187794',3676364,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','187794',3676365,'2708','240',1235079.77,1237886.26,2806.49,454651.38,0.00,0.00,0.00,0.00,0.00),('5','101','917','187794',3676366,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','187794',3676367,'2710','240',729042.39,732327.67,3285.28,532215.36,0.00,0.00,0.00,0.00,0.00),('5','101','917','187794',3676368,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','187794',3676369,'2712','240',921555.06,924379.80,2824.74,457607.88,0.00,0.00,0.00,0.00,0.00),('5','101','620','188118',3681930,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','188118',3681931,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','188118',3681932,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','188118',3681933,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','188118',3681934,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','188118',3681935,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','188118',3681936,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','188118',3681937,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','188118',3681938,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','188118',3681939,'1741','241',642817.82,642817.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','188118',3681940,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','188118',3681941,'2705','240',502943.50,502943.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','188118',3681942,'2706','240',749312.40,750689.49,1377.09,223088.58,0.00,0.00,0.00,0.00,0.00),('5','101','916','188118',3681943,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','188118',3681944,'2708','240',1237886.26,1240796.05,2909.79,471385.98,0.00,0.00,0.00,0.00,0.00),('5','101','917','188118',3681945,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','188118',3681946,'2710','240',732327.67,734061.07,1733.40,280810.80,0.00,0.00,0.00,0.00,0.00),('5','101','917','188118',3681947,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','188118',3681948,'2712','240',924379.80,927603.13,3223.33,522179.46,0.00,0.00,0.00,0.00,0.00),('5','101','620','188273',3684572,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','188273',3684573,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','188273',3684574,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','188273',3684575,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','188273',3684576,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','188273',3684577,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','188273',3684578,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','188273',3684579,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','188273',3684580,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','188273',3684581,'1741','241',642817.82,642817.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','188273',3684582,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','188273',3684583,'2705','240',502943.50,502943.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','188273',3684584,'2706','240',750689.49,751488.63,799.14,129460.68,0.00,0.00,0.00,0.00,0.00),('5','101','916','188273',3684585,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','188273',3684586,'2708','240',1240796.05,1243711.03,2914.98,472226.76,0.00,0.00,0.00,0.00,0.00),('5','101','917','188273',3684587,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','188273',3684588,'2710','240',734061.07,736466.06,2404.99,389608.38,0.00,0.00,0.00,0.00,0.00),('5','101','917','188273',3684589,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','188273',3684590,'2712','240',927603.13,931077.78,3474.65,562893.30,0.00,0.00,0.00,0.00,0.00),('5','101','620','188501',3688610,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','188501',3688611,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','188501',3688612,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','188501',3688613,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','188501',3688614,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','188501',3688615,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','188501',3688616,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','188501',3688617,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','188501',3688618,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','188501',3688619,'1741','241',642817.82,643102.64,284.82,75477.30,0.00,0.00,0.00,0.00,0.00),('5','101','623','188501',3688620,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','188501',3688621,'2705','240',502943.50,502943.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','188501',3688622,'2706','240',751488.63,751488.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','188501',3688623,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','188501',3688624,'2708','240',1243711.03,1246591.59,2880.56,466650.72,0.00,0.00,0.00,0.00,0.00),('5','101','917','188501',3688625,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','188501',3688626,'2710','240',736466.06,739868.51,3402.45,551196.90,0.00,0.00,0.00,0.00,0.00),('5','101','917','188501',3688627,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','188501',3688628,'2712','240',931077.78,934276.90,3199.12,518257.44,0.00,0.00,0.00,0.00,0.00),('5','101','620','188684',3691730,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','188684',3691731,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','188684',3691732,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','188684',3691733,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','188684',3691734,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','188684',3691735,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','188684',3691736,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','188684',3691737,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','188684',3691738,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','188684',3691739,'1741','241',643102.64,643885.26,782.62,207394.30,0.00,0.00,0.00,0.00,0.00),('5','101','623','188684',3691740,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','188684',3691741,'2705','240',502943.50,502943.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','188684',3691742,'2706','240',751488.63,752278.23,789.60,127915.20,0.00,0.00,0.00,0.00,0.00),('5','101','916','188684',3691743,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','188684',3691744,'2708','240',1246591.59,1249805.30,3213.71,520621.02,0.00,0.00,0.00,0.00,0.00),('5','101','917','188684',3691745,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','188684',3691746,'2710','240',739868.51,742695.23,2826.72,457928.64,0.00,0.00,0.00,0.00,0.00),('5','101','917','188684',3691747,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','188684',3691748,'2712','240',934276.90,937464.87,3187.97,516451.14,0.00,0.00,0.00,0.00,0.00),('5','101','620','188967',3697001,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','188967',3697002,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','188967',3697003,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','188967',3697004,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','188967',3697005,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','188967',3697006,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','188967',3697007,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','188967',3697008,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','188967',3697009,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','188967',3697010,'1741','241',643885.26,644420.03,534.77,141714.05,0.00,0.00,0.00,0.00,0.00),('5','101','623','188967',3697011,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','188967',3697012,'2705','240',502943.50,502943.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','188967',3697013,'2706','240',752278.23,752278.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','188967',3697014,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','188967',3697015,'2708','240',1249805.30,1251841.92,2036.62,329932.44,0.00,0.00,0.00,0.00,0.00),('5','101','917','188967',3697016,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','188967',3697017,'2710','240',742695.23,746224.69,3529.46,571772.52,0.00,0.00,0.00,0.00,0.00),('5','101','917','188967',3697018,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','188967',3697019,'2712','240',937464.87,941438.39,3973.52,643710.24,0.00,0.00,0.00,0.00,0.00),('5','101','620','189099',3699133,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','189099',3699134,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','189099',3699135,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','189099',3699136,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','189099',3699137,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','189099',3699138,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','189099',3699139,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','189099',3699140,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','189099',3699141,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','189099',3699142,'1741','241',644420.03,645186.58,766.55,203135.75,0.00,0.00,0.00,0.00,0.00),('5','101','623','189099',3699143,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','189099',3699144,'2705','240',502943.50,502943.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','189099',3699145,'2706','240',752278.23,753784.60,1506.37,244031.94,0.00,0.00,0.00,0.00,0.00),('5','101','916','189099',3699146,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','189099',3699147,'2708','240',1251841.92,1253517.07,1675.15,271374.30,0.00,0.00,0.00,0.00,0.00),('5','101','917','189099',3699148,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','189099',3699149,'2710','240',746224.69,749456.92,3232.23,523621.26,0.00,0.00,0.00,0.00,0.00),('5','101','917','189099',3699150,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','189099',3699151,'2712','240',941438.39,944638.68,3200.29,518446.98,0.00,0.00,0.00,0.00,0.00),('5','101','620','189302',3702921,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','189302',3702922,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','189302',3702923,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','189302',3702924,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','189302',3702925,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','189302',3702926,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','189302',3702927,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','189302',3702928,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','189302',3702929,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','189302',3702930,'1741','241',645186.58,646219.72,1033.14,273782.10,0.00,0.00,0.00,0.00,0.00),('5','101','623','189302',3702931,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','189302',3702932,'2705','240',502943.50,502943.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','189302',3702933,'2706','240',753784.60,753784.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','189302',3702934,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','189302',3702935,'2708','240',1253517.07,1256385.09,2868.02,464619.24,0.00,0.00,0.00,0.00,0.00),('5','101','917','189302',3702936,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','189302',3702937,'2710','240',749456.92,753020.12,3563.20,577238.40,0.00,0.00,0.00,0.00,0.00),('5','101','917','189302',3702938,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','189302',3702939,'2712','240',944638.68,947977.46,3338.78,540882.36,0.00,0.00,0.00,0.00,0.00),('5','101','620','189464',3705671,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','189464',3705672,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','189464',3705673,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','189464',3705674,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','189464',3705675,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','189464',3705676,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','189464',3705677,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','189464',3705678,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','189464',3705679,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','189464',3705680,'1741','241',646219.72,647096.10,876.38,232240.70,0.00,0.00,0.00,0.00,0.00),('5','101','623','189464',3705681,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','189464',3705682,'2705','240',502943.50,502943.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','189464',3705683,'2706','240',753784.60,754341.67,557.07,90245.34,0.00,0.00,0.00,0.00,0.00),('5','101','916','189464',3705684,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','189464',3705685,'2708','240',1256385.09,1260246.77,3861.68,625592.16,0.00,0.00,0.00,0.00,0.00),('5','101','917','189464',3705686,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','189464',3705687,'2710','240',753020.12,755876.41,2856.29,462718.98,0.00,0.00,0.00,0.00,0.00),('5','101','917','189464',3705688,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','189464',3705689,'2712','240',947977.46,951039.10,3061.64,495985.68,0.00,0.00,0.00,0.00,0.00),('5','101','620','190004',3715837,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','190004',3715838,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','190004',3715839,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','190004',3715840,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','190004',3715841,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','190004',3715842,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','190004',3715843,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','190004',3715844,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','190004',3715845,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','190004',3715846,'1741','241',647096.10,648244.85,1148.75,304418.75,0.00,0.00,0.00,0.00,0.00),('5','101','623','190004',3715847,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','190004',3715848,'2705','240',502943.50,504277.24,1333.74,216065.88,0.00,0.00,0.00,0.00,0.00),('5','101','916','190004',3715849,'2706','240',754341.67,756098.90,1757.23,284671.26,0.00,0.00,0.00,0.00,0.00),('5','101','916','190004',3715850,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','190004',3715851,'2708','240',1260246.77,1263797.57,3550.80,575229.60,0.00,0.00,0.00,0.00,0.00),('5','101','917','190004',3715852,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','190004',3715853,'2710','240',755876.41,757882.67,2006.26,325014.12,0.00,0.00,0.00,0.00,0.00),('5','101','917','190004',3715854,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','190004',3715855,'2712','240',951039.10,953145.12,2106.02,341175.24,0.00,0.00,0.00,0.00,0.00),('5','101','620','190193',3719509,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','190193',3719510,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','190193',3719511,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','190193',3719512,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','190193',3719513,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','190193',3719514,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','190193',3719515,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','190193',3719516,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','190193',3719517,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','190193',3719518,'1741','241',648244.85,649077.65,832.80,220692.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','190193',3719519,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','190193',3719520,'2705','240',504277.24,505398.74,1121.50,181683.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','190193',3719521,'2706','240',756098.90,757175.93,1077.03,174478.86,0.00,0.00,0.00,0.00,0.00),('5','101','916','190193',3719522,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','190193',3719523,'2708','240',1263797.57,1263797.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','190193',3719524,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','190193',3719525,'2710','240',757882.67,757882.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','190193',3719526,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','190193',3719527,'2712','240',953145.12,953145.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','190218',3719778,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','190218',3719779,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','190218',3719780,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','190218',3719781,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','190218',3719782,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','190218',3719783,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','190218',3719784,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','190218',3719785,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','190218',3719786,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','190218',3719787,'1741','241',649077.65,649697.70,620.05,164313.25,0.00,0.00,0.00,0.00,0.00),('5','101','623','190218',3719788,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','190218',3719789,'2705','240',505398.74,508775.17,3376.43,546981.66,0.00,0.00,0.00,0.00,0.00),('5','101','916','190218',3719790,'2706','240',757175.93,759590.27,2414.34,391123.08,0.00,0.00,0.00,0.00,0.00),('5','101','916','190218',3719791,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','190218',3719792,'2708','240',1263797.57,1266529.20,2731.63,442524.06,0.00,0.00,0.00,0.00,0.00),('5','101','917','190218',3719793,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','190218',3719794,'2710','240',757882.67,757882.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','190218',3719795,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','190218',3719796,'2712','240',953145.12,953145.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','190231',3719922,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','190231',3719923,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','190231',3719924,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','190231',3719925,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','190231',3719926,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','190231',3719927,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','190231',3719928,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','190231',3719929,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','190231',3719930,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','190231',3719931,'1741','241',649697.70,651801.96,2104.26,557628.90,0.00,0.00,0.00,0.00,0.00),('5','101','623','190231',3719932,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','190231',3719933,'2705','240',508775.17,511437.88,2662.71,431359.02,0.00,0.00,0.00,0.00,0.00),('5','101','916','190231',3719934,'2706','240',759590.27,762514.16,2923.89,473670.18,0.00,0.00,0.00,0.00,0.00),('5','101','916','190231',3719935,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','190231',3719936,'2708','240',1266529.20,1267111.27,582.07,94295.34,0.00,0.00,0.00,0.00,0.00),('5','101','917','190231',3719937,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','190231',3719938,'2710','240',757882.67,757882.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','190231',3719939,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','190231',3719940,'2712','240',953145.12,953145.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','190543',3725647,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','190543',3725648,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','190543',3725649,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','190543',3725650,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','190543',3725651,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','190543',3725652,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','190543',3725653,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','190543',3725654,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','190543',3725655,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','190543',3725656,'1741','241',651801.96,652537.57,735.61,194936.65,0.00,0.00,0.00,0.00,0.00),('5','101','623','190543',3725657,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','190543',3725658,'2705','240',511437.88,511437.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','190543',3725659,'2706','240',762514.16,762514.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','190543',3725660,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','190543',3725661,'2708','240',1267111.27,1267111.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','190543',3725662,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','190543',3725663,'2710','240',757882.67,757882.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','190543',3725664,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','190543',3725665,'2712','240',953145.12,953145.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','190674',3728168,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','190674',3728169,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','190674',3728170,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','190674',3728171,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','190674',3728172,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','190674',3728173,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','190674',3728174,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','190674',3728175,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','190674',3728176,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','190674',3728177,'1741','241',652537.57,653281.72,744.15,197199.75,0.00,0.00,0.00,0.00,0.00),('5','101','623','190674',3728178,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','190674',3728179,'2705','240',511437.88,514446.77,3008.89,496466.85,0.00,0.00,0.00,0.00,0.00),('5','101','916','190674',3728180,'2706','240',762514.16,765567.96,3053.80,503877.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','190674',3728181,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','190674',3728182,'2708','240',1267111.27,1270114.39,3003.12,495514.80,0.00,0.00,0.00,0.00,0.00),('5','101','917','190674',3728183,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','190674',3728184,'2710','240',757882.67,757882.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','190674',3728185,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','190674',3728186,'2712','240',953145.12,953145.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','190951',3733059,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','190951',3733060,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','190951',3733061,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','190951',3733062,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','190951',3733063,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','190951',3733064,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','190951',3733065,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','190951',3733066,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','190951',3733067,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','190951',3733068,'1741','241',653281.72,654149.66,867.94,230004.10,0.00,0.00,0.00,0.00,0.00),('5','101','623','190951',3733069,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','190951',3733070,'2705','240',514446.77,517075.09,2628.32,433672.80,0.00,0.00,0.00,0.00,0.00),('5','101','916','190951',3733071,'2706','240',765567.96,767956.83,2388.87,394163.55,0.00,0.00,0.00,0.00,0.00),('5','101','916','190951',3733072,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','190951',3733073,'2708','240',1270114.39,1270774.51,660.12,108919.80,0.00,0.00,0.00,0.00,0.00),('5','101','917','190951',3733074,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','190951',3733075,'2710','240',757882.67,757882.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','190951',3733076,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','190951',3733077,'2712','240',953145.12,953145.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','191152',3736655,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','191152',3736656,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','191152',3736657,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','191152',3736658,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','191152',3736659,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','191152',3736660,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','191152',3736661,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','191152',3736662,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','191152',3736663,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','191152',3736664,'1741','241',654149.66,655157.39,1007.73,267048.45,0.00,0.00,0.00,0.00,0.00),('5','101','623','191152',3736665,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','191152',3736666,'2705','240',517075.09,520513.17,3438.08,567283.20,0.00,0.00,0.00,0.00,0.00),('5','101','916','191152',3736667,'2706','240',767956.83,771174.81,3217.98,530966.70,0.00,0.00,0.00,0.00,0.00),('5','101','916','191152',3736668,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','191152',3736669,'2708','240',1270774.51,1273515.14,2740.63,452203.95,0.00,0.00,0.00,0.00,0.00),('5','101','917','191152',3736670,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','191152',3736671,'2710','240',757882.67,757882.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','191152',3736672,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','191152',3736673,'2712','240',953145.12,953145.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','191375',3740582,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','191375',3740583,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','191375',3740584,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','191375',3740585,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','191375',3740586,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','191375',3740587,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','191375',3740588,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','191375',3740589,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','191375',3740590,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','191375',3740591,'1741','241',655157.39,655928.92,771.53,204455.45,0.00,0.00,0.00,0.00,0.00),('5','101','623','191375',3740592,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','191375',3740593,'2705','240',520513.17,524164.29,3651.12,602434.80,0.00,0.00,0.00,0.00,0.00),('5','101','916','191375',3740594,'2706','240',771174.81,773885.16,2710.35,447207.75,0.00,0.00,0.00,0.00,0.00),('5','101','916','191375',3740595,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','191375',3740596,'2708','240',1273515.14,1274684.68,1169.54,192974.10,0.00,0.00,0.00,0.00,0.00),('5','101','917','191375',3740597,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','191375',3740598,'2710','240',757882.67,757882.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','191375',3740599,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','191375',3740600,'2712','240',953145.12,953145.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','191534',3743401,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','191534',3743402,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','191534',3743403,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','191534',3743404,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','191534',3743405,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','191534',3743406,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','191534',3743407,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','191534',3743408,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','191534',3743409,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','191534',3743410,'1741','241',655928.92,656428.28,499.36,132330.40,0.00,0.00,0.00,0.00,0.00),('5','101','623','191534',3743411,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','191534',3743412,'2705','240',524164.29,524164.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','191534',3743413,'2706','240',773885.16,773885.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','191534',3743414,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','191534',3743415,'2708','240',1274684.68,1274684.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','191534',3743416,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','191534',3743417,'2710','240',757882.67,757882.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','191534',3743418,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','191534',3743419,'2712','240',953145.12,953145.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','191908',3751157,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','191908',3751158,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','191908',3751159,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','191908',3751160,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','191908',3751161,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','191908',3751162,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','191908',3751163,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','191908',3751164,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','191908',3751165,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','191908',3751166,'1741','241',656428.28,657055.20,626.92,166133.80,0.00,0.00,0.00,0.00,0.00),('5','101','623','191908',3751167,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','191908',3751168,'2705','240',524164.29,524164.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','191908',3751169,'2706','240',773885.16,773885.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','191908',3751170,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','191908',3751171,'2708','240',1274684.68,1274684.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','191908',3751172,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','191908',3751173,'2710','240',757882.67,757882.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','191908',3751174,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','191908',3751175,'2712','240',953145.12,953145.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','191989',3752278,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','191989',3752279,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','191989',3752280,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','191989',3752281,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','191989',3752282,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','191989',3752283,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','191989',3752284,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','191989',3752285,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','191989',3752286,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','191989',3752287,'1741','241',657055.20,657889.50,834.30,221089.50,0.00,0.00,0.00,0.00,0.00),('5','101','623','191989',3752288,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','191989',3752289,'2705','240',524164.29,525554.31,1390.02,229353.30,0.00,0.00,0.00,0.00,0.00),('5','101','916','191989',3752290,'2706','240',773885.16,775297.55,1412.39,233044.35,0.00,0.00,0.00,0.00,0.00),('5','101','916','191989',3752291,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','191989',3752292,'2708','240',1274684.68,1276177.76,1493.08,246358.20,0.00,0.00,0.00,0.00,0.00),('5','101','917','191989',3752293,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','191989',3752294,'2710','240',757882.67,757882.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','191989',3752295,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','191989',3752296,'2712','240',953145.12,953145.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','192315',3758510,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','192315',3758511,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','192315',3758512,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','192315',3758513,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','192315',3758514,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','192315',3758515,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','192315',3758516,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','192315',3758517,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','192315',3758518,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','192315',3758519,'1741','241',657889.50,665704.98,7815.48,2071102.20,0.00,0.00,0.00,0.00,0.00),('5','101','623','192315',3758520,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','192315',3758521,'2705','240',525554.31,530350.89,4796.58,791435.70,0.00,0.00,0.00,0.00,0.00),('5','101','916','192315',3758522,'2706','240',775297.55,778025.95,2728.40,450186.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','192315',3758523,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','192315',3758524,'2708','240',1276177.76,1278585.08,2407.32,397207.80,0.00,0.00,0.00,0.00,0.00),('5','101','917','192315',3758525,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','192315',3758526,'2710','240',757882.67,757882.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','192315',3758527,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','192315',3758528,'2712','240',953145.12,953145.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','192388',3759391,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','192388',3759392,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','192388',3759393,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','192388',3759394,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','192388',3759395,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','192388',3759396,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','192388',3759397,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','192388',3759398,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','192388',3759399,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','192388',3759400,'1741','241',665704.98,673250.83,7545.85,1999650.25,0.00,0.00,0.00,0.00,0.00),('5','101','623','192388',3759401,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','192388',3759402,'2705','240',530350.89,533620.71,3269.82,539520.30,0.00,0.00,0.00,0.00,0.00),('5','101','916','192388',3759403,'2706','240',778025.95,780972.15,2946.20,486123.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','192388',3759404,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','192388',3759405,'2708','240',1278585.08,1279845.77,1260.69,208013.85,0.00,0.00,0.00,0.00,0.00),('5','101','917','192388',3759406,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','192388',3759407,'2710','240',757882.67,757882.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','192388',3759408,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','192388',3759409,'2712','240',953145.12,953145.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','192657',3764317,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','192657',3764318,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','192657',3764319,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','192657',3764320,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','192657',3764321,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','192657',3764322,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','192657',3764323,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','192657',3764324,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','192657',3764325,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','192657',3764326,'1741','241',673250.83,673993.23,742.40,196736.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','192657',3764327,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','192657',3764328,'2705','240',533620.71,536659.91,3039.20,501468.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','192657',3764329,'2706','240',780972.15,781157.01,184.86,30501.90,0.00,0.00,0.00,0.00,0.00),('5','101','916','192657',3764330,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','192657',3764331,'2708','240',1279845.77,1280489.55,643.78,106223.70,0.00,0.00,0.00,0.00,0.00),('5','101','917','192657',3764332,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','192657',3764333,'2710','240',757882.67,759772.54,1889.87,311828.55,0.00,0.00,0.00,0.00,0.00),('5','101','917','192657',3764334,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','192657',3764335,'2712','240',953145.12,955911.29,2766.17,456418.05,0.00,0.00,0.00,0.00,0.00),('5','101','620','192828',3767493,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','192828',3767494,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','192828',3767495,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','192828',3767496,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','192828',3767497,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','192828',3767498,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','192828',3767499,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','192828',3767500,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','192828',3767501,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','192828',3767502,'1741','241',673993.23,674486.02,492.79,130589.35,0.00,0.00,0.00,0.00,0.00),('5','101','623','192828',3767503,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','192828',3767504,'2705','240',536659.91,539591.70,2931.79,483745.35,0.00,0.00,0.00,0.00,0.00),('5','101','916','192828',3767505,'2706','240',781157.01,781157.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','192828',3767506,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','192828',3767507,'2708','240',1280489.55,1280489.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','192828',3767508,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','192828',3767509,'2710','240',759772.54,760806.27,1033.73,170565.45,0.00,0.00,0.00,0.00,0.00),('5','101','917','192828',3767510,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','192828',3767511,'2712','240',955911.29,958524.85,2613.56,431237.40,0.00,0.00,0.00,0.00,0.00),('5','101','620','193050',3771598,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','193050',3771599,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','193050',3771600,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','193050',3771601,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','193050',3771602,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','193050',3771603,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','193050',3771604,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','193050',3771605,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','193050',3771606,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','193050',3771607,'1741','241',674486.02,675038.55,552.53,146420.45,0.00,0.00,0.00,0.00,0.00),('5','101','623','193050',3771608,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','193050',3771609,'2705','240',539591.70,540652.63,1060.93,175053.45,0.00,0.00,0.00,0.00,0.00),('5','101','916','193050',3771610,'2706','240',781157.01,781157.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','193050',3771611,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','193050',3771612,'2708','240',1280489.55,1280489.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','193050',3771613,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','193050',3771614,'2710','240',760806.27,764212.26,3405.99,561988.35,0.00,0.00,0.00,0.00,0.00),('5','101','917','193050',3771615,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','193050',3771616,'2712','240',958524.85,960008.39,1483.54,244784.10,0.00,0.00,0.00,0.00,0.00),('5','101','620','193398',3778768,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','193398',3778769,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','193398',3778770,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','193398',3778771,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','193398',3778772,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','193398',3778773,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','193398',3778774,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','193398',3778775,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','193398',3778776,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','193398',3778777,'1741','241',675038.55,675455.51,416.96,110494.40,0.00,0.00,0.00,0.00,0.00),('5','101','623','193398',3778778,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','193398',3778779,'2705','240',540652.63,540652.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','193398',3778780,'2706','240',781157.01,781157.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','193398',3778781,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','193398',3778782,'2708','240',1280489.55,1280489.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','193398',3778783,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','193398',3778784,'2710','240',764212.26,765991.01,1778.75,293493.75,0.00,0.00,0.00,0.00,0.00),('5','101','917','193398',3778785,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','193398',3778786,'2712','240',960008.39,961238.03,1229.64,202890.60,0.00,0.00,0.00,0.00,0.00),('5','101','620','193444',3779312,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','193444',3779313,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','193444',3779314,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','193444',3779315,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','193444',3779316,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','193444',3779317,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','193444',3779318,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','193444',3779319,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','193444',3779320,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','193444',3779321,'1741','241',675455.51,676541.77,1086.26,287858.90,0.00,0.00,0.00,0.00,0.00),('5','101','623','193444',3779322,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','193444',3779323,'2705','240',540652.63,540652.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','193444',3779324,'2706','240',781157.01,781157.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','193444',3779325,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','193444',3779326,'2708','240',1280489.55,1280489.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','193444',3779327,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','193444',3779328,'2710','240',765991.01,765991.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','193444',3779329,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','193444',3779330,'2712','240',961238.03,961238.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','193626',3782850,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','193626',3782851,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','193626',3782852,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','193626',3782853,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','193626',3782854,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','193626',3782855,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','193626',3782856,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','193626',3782857,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','193626',3782858,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','193626',3782859,'1741','241',676541.77,677598.04,1056.27,279911.55,0.00,0.00,0.00,0.00,0.00),('5','101','623','193626',3782860,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','193626',3782861,'2705','240',540652.63,541040.32,387.69,63968.85,0.00,0.00,0.00,0.00,0.00),('5','101','916','193626',3782862,'2706','240',781157.01,781785.50,628.49,103700.85,0.00,0.00,0.00,0.00,0.00),('5','101','916','193626',3782863,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','193626',3782864,'2708','240',1280489.55,1280820.61,331.06,54624.90,0.00,0.00,0.00,0.00,0.00),('5','101','917','193626',3782865,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','193626',3782866,'2710','240',765991.01,765991.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','193626',3782867,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','193626',3782868,'2712','240',961238.03,961238.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','193911',3787671,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','193911',3787672,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','193911',3787673,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','193911',3787674,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','193911',3787675,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','193911',3787676,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','193911',3787677,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','193911',3787678,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','193911',3787679,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','193911',3787680,'1741','241',677598.04,678525.78,927.74,245851.10,0.00,0.00,0.00,0.00,0.00),('5','101','623','193911',3787681,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','193911',3787682,'2705','240',541040.32,542851.49,1811.17,298843.05,0.00,0.00,0.00,0.00,0.00),('5','101','916','193911',3787683,'2706','240',781785.50,783317.37,1531.87,252758.55,0.00,0.00,0.00,0.00,0.00),('5','101','916','193911',3787684,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','193911',3787685,'2708','240',1280820.61,1282303.40,1482.79,244660.35,0.00,0.00,0.00,0.00,0.00),('5','101','917','193911',3787686,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','193911',3787687,'2710','240',765991.01,767390.81,1399.80,230967.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','193911',3787688,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','193911',3787689,'2712','240',961238.03,963367.13,2129.10,351301.50,0.00,0.00,0.00,0.00,0.00),('5','101','620','194089',3790975,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','194089',3790976,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','194089',3790977,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','194089',3790978,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','194089',3790979,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','194089',3790980,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','194089',3790981,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','194089',3790982,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','194089',3790983,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','194089',3790984,'1741','241',678525.78,679256.43,730.65,193622.25,0.00,0.00,0.00,0.00,0.00),('5','101','623','194089',3790985,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','194089',3790986,'2705','240',542851.49,546105.36,3253.87,536888.55,0.00,0.00,0.00,0.00,0.00),('5','101','916','194089',3790987,'2706','240',783317.37,785356.34,2038.97,336430.05,0.00,0.00,0.00,0.00,0.00),('5','101','916','194089',3790988,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','194089',3790989,'2708','240',1282303.40,1283023.50,720.10,118816.50,0.00,0.00,0.00,0.00,0.00),('5','101','917','194089',3790990,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','194089',3790991,'2710','240',767390.81,769109.31,1718.50,283552.50,0.00,0.00,0.00,0.00,0.00),('5','101','917','194089',3790992,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','194089',3790993,'2712','240',963367.13,963877.26,510.13,84171.45,0.00,0.00,0.00,0.00,0.00),('5','101','620','194318',3795199,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','194318',3795200,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','194318',3795201,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','194318',3795202,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','194318',3795203,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','194318',3795204,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','194318',3795205,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','194318',3795206,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','194318',3795207,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','194318',3795208,'1741','241',679256.43,679846.23,589.80,156297.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','194318',3795209,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','194318',3795210,'2705','240',546105.36,547690.05,1584.69,261473.85,0.00,0.00,0.00,0.00,0.00),('5','101','916','194318',3795211,'2706','240',785356.34,787373.84,2017.50,332887.50,0.00,0.00,0.00,0.00,0.00),('5','101','916','194318',3795212,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','194318',3795213,'2708','240',1283023.50,1284263.14,1239.64,204540.60,0.00,0.00,0.00,0.00,0.00),('5','101','917','194318',3795214,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','194318',3795215,'2710','240',769109.31,770667.82,1558.51,257154.15,0.00,0.00,0.00,0.00,0.00),('5','101','917','194318',3795216,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','194318',3795217,'2712','240',963877.26,965265.31,1388.05,229028.25,0.00,0.00,0.00,0.00,0.00),('5','101','620','194500',3798451,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','194500',3798452,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','194500',3798453,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','194500',3798454,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','194500',3798455,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','194500',3798456,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','194500',3798457,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','194500',3798458,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','194500',3798459,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','194500',3798460,'1741','241',679846.23,690598.71,10752.48,2849407.20,0.00,0.00,0.00,0.00,0.00),('5','101','623','194500',3798461,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','194500',3798462,'2705','240',547690.05,551081.60,3391.55,559605.75,0.00,0.00,0.00,0.00,0.00),('5','101','916','194500',3798463,'2706','240',787373.84,789505.56,2131.72,351733.80,0.00,0.00,0.00,0.00,0.00),('5','101','916','194500',3798464,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','194500',3798465,'2708','240',1284263.14,1285080.07,816.93,134793.45,0.00,0.00,0.00,0.00,0.00),('5','101','917','194500',3798466,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','194500',3798467,'2710','240',770667.82,772081.82,1414.00,233310.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','194500',3798468,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','194500',3798469,'2712','240',965265.31,965297.97,32.66,5388.90,0.00,0.00,0.00,0.00,0.00),('5','101','620','194715',3802255,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','194715',3802256,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','194715',3802257,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','194715',3802258,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','194715',3802259,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','194715',3802260,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','194715',3802261,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','194715',3802262,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','194715',3802263,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','194715',3802264,'1741','241',690598.71,691240.34,641.63,170031.95,0.00,0.00,0.00,0.00,0.00),('5','101','623','194715',3802265,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','194715',3802266,'2705','240',551081.60,553164.47,2082.87,343673.55,0.00,0.00,0.00,0.00,0.00),('5','101','916','194715',3802267,'2706','240',789505.56,790982.91,1477.35,243762.75,0.00,0.00,0.00,0.00,0.00),('5','101','916','194715',3802268,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','194715',3802269,'2708','240',1285080.07,1285080.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','194715',3802270,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','194715',3802271,'2710','240',772081.82,773294.16,1212.34,200036.10,0.00,0.00,0.00,0.00,0.00),('5','101','917','194715',3802272,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','194715',3802273,'2712','240',965297.97,967764.34,2466.37,406951.05,0.00,0.00,0.00,0.00,0.00),('5','101','620','194944',3807055,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','194944',3807056,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','194944',3807057,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','194944',3807058,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','194944',3807059,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','194944',3807060,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','194944',3807061,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','194944',3807062,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','194944',3807063,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','194944',3807064,'1741','241',691240.34,691891.37,651.03,172522.95,0.00,0.00,0.00,0.00,0.00),('5','101','623','194944',3807065,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','194944',3807066,'2705','240',553164.47,556716.59,3552.12,586099.80,0.00,0.00,0.00,0.00,0.00),('5','101','916','194944',3807067,'2706','240',790982.91,792152.00,1169.09,192899.85,0.00,0.00,0.00,0.00,0.00),('5','101','916','194944',3807068,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','194944',3807069,'2708','240',1285080.07,1286634.90,1554.83,256546.95,0.00,0.00,0.00,0.00,0.00),('5','101','917','194944',3807070,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','194944',3807071,'2710','240',773294.16,773856.52,562.36,92789.40,0.00,0.00,0.00,0.00,0.00),('5','101','917','194944',3807072,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','194944',3807073,'2712','240',967764.34,968333.93,569.59,93982.35,0.00,0.00,0.00,0.00,0.00),('5','101','620','195111',3809909,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','195111',3809910,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','195111',3809911,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','195111',3809912,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','195111',3809913,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','195111',3809914,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','195111',3809915,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','195111',3809916,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','195111',3809917,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','195111',3809918,'1741','241',691891.37,692618.99,727.62,192819.30,0.00,0.00,0.00,0.00,0.00),('5','101','623','195111',3809919,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','195111',3809920,'2705','240',556716.59,558763.60,2047.01,337756.65,0.00,0.00,0.00,0.00,0.00),('5','101','916','195111',3809921,'2706','240',792152.00,793006.16,854.16,140936.40,0.00,0.00,0.00,0.00,0.00),('5','101','916','195111',3809922,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','195111',3809923,'2708','240',1286634.90,1289156.35,2521.45,416039.25,0.00,0.00,0.00,0.00,0.00),('5','101','917','195111',3809924,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','195111',3809925,'2710','240',773856.52,775939.00,2082.48,343609.20,0.00,0.00,0.00,0.00,0.00),('5','101','917','195111',3809926,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','195111',3809927,'2712','240',968333.93,968808.20,474.27,78254.55,0.00,0.00,0.00,0.00,0.00),('5','101','620','195331',3813572,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','195331',3813573,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','195331',3813574,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','195331',3813575,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','195331',3813576,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','195331',3813577,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','195331',3813578,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','195331',3813579,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','195331',3813580,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','195331',3813581,'1741','241',692618.99,693490.55,871.56,230963.40,0.00,0.00,0.00,0.00,0.00),('5','101','623','195331',3813582,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','195331',3813583,'2705','240',558763.60,560616.03,1852.43,305650.95,0.00,0.00,0.00,0.00,0.00),('5','101','916','195331',3813584,'2706','240',793006.16,793738.84,732.68,120892.20,0.00,0.00,0.00,0.00,0.00),('5','101','916','195331',3813585,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','195331',3813586,'2708','240',1289156.35,1291237.92,2081.57,343459.05,0.00,0.00,0.00,0.00,0.00),('5','101','917','195331',3813587,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','195331',3813588,'2710','240',775939.00,778083.60,2144.60,353859.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','195331',3813589,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','195331',3813590,'2712','240',968808.20,970266.67,1458.47,240647.55,0.00,0.00,0.00,0.00,0.00),('5','101','620','195546',3817492,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','195546',3817493,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','195546',3817494,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','195546',3817495,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','195546',3817496,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','195546',3817497,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','195546',3817498,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','195546',3817499,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','195546',3817500,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','195546',3817501,'1741','241',693490.55,694253.84,763.29,202271.85,0.00,0.00,0.00,0.00,0.00),('5','101','623','195546',3817502,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','195546',3817503,'2705','240',560616.03,562546.33,1930.30,318499.50,0.00,0.00,0.00,0.00,0.00),('5','101','916','195546',3817504,'2706','240',793738.84,793738.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','195546',3817505,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','195546',3817506,'2708','240',1291237.92,1293396.93,2159.01,356236.65,0.00,0.00,0.00,0.00,0.00),('5','101','917','195546',3817507,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','195546',3817508,'2710','240',778083.60,780147.22,2063.62,340497.30,0.00,0.00,0.00,0.00,0.00),('5','101','917','195546',3817509,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','195546',3817510,'2712','240',970266.67,972208.68,1942.01,320431.65,0.00,0.00,0.00,0.00,0.00),('5','101','620','195813',3821954,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','195813',3821955,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','195813',3821956,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','195813',3821957,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','195813',3821958,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','195813',3821959,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','195813',3821960,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','195813',3821961,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','195813',3821962,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','195813',3821963,'1741','241',694253.84,695096.42,842.58,223283.70,0.00,0.00,0.00,0.00,0.00),('5','101','623','195813',3821964,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','195813',3821965,'2705','240',562546.33,564613.82,2067.49,341135.85,0.00,0.00,0.00,0.00,0.00),('5','101','916','195813',3821966,'2706','240',793738.84,793738.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','195813',3821967,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','195813',3821968,'2708','240',1293396.93,1295694.97,2298.04,379176.60,0.00,0.00,0.00,0.00,0.00),('5','101','917','195813',3821969,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','195813',3821970,'2710','240',780147.22,781076.56,929.34,153341.10,0.00,0.00,0.00,0.00,0.00),('5','101','917','195813',3821971,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','195813',3821972,'2712','240',972208.68,975552.56,3343.88,551740.20,0.00,0.00,0.00,0.00,0.00),('5','101','620','196057',3826402,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','196057',3826403,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','196057',3826404,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','196057',3826405,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','196057',3826406,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','196057',3826407,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','196057',3826408,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','196057',3826409,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','196057',3826410,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','196057',3826411,'1741','241',695096.42,695733.25,636.83,168759.95,0.00,0.00,0.00,0.00,0.00),('5','101','623','196057',3826412,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','196057',3826413,'2705','240',564613.82,567266.34,2652.52,437665.80,0.00,0.00,0.00,0.00,0.00),('5','101','916','196057',3826414,'2706','240',793738.84,793738.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','196057',3826415,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','196057',3826416,'2708','240',1295694.97,1297228.96,1533.99,253108.35,0.00,0.00,0.00,0.00,0.00),('5','101','917','196057',3826417,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','196057',3826418,'2710','240',781076.56,783702.67,2626.11,433308.15,0.00,0.00,0.00,0.00,0.00),('5','101','917','196057',3826419,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','196057',3826420,'2712','240',975552.56,977199.19,1646.63,271693.95,0.00,0.00,0.00,0.00,0.00),('5','101','620','196293',3830945,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','196293',3830946,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','196293',3830947,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','196293',3830948,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','196293',3830949,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','196293',3830950,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','196293',3830951,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','196293',3830952,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','196293',3830953,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','196293',3830954,'1741','241',695733.25,697997.77,2264.52,600097.80,0.00,0.00,0.00,0.00,0.00),('5','101','623','196293',3830955,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','196293',3830956,'2705','240',567266.34,570285.49,3019.15,498159.75,0.00,0.00,0.00,0.00,0.00),('5','101','916','196293',3830957,'2706','240',793738.84,793753.97,15.13,2496.45,0.00,0.00,0.00,0.00,0.00),('5','101','916','196293',3830958,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','196293',3830959,'2708','240',1297228.96,1297228.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','196293',3830960,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','196293',3830961,'2710','240',783702.67,786031.98,2329.31,384336.15,0.00,0.00,0.00,0.00,0.00),('5','101','917','196293',3830962,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','196293',3830963,'2712','240',977199.19,979901.97,2702.78,445958.70,0.00,0.00,0.00,0.00,0.00),('5','101','620','196496',3834614,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','196496',3834615,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','196496',3834616,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','196496',3834617,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','196496',3834618,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','196496',3834619,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','196496',3834620,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','196496',3834621,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','196496',3834622,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','196496',3834623,'1741','241',697997.77,698780.10,782.33,207317.45,0.00,0.00,0.00,0.00,0.00),('5','101','623','196496',3834624,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','196496',3834625,'2705','240',570285.49,570694.74,409.25,67526.25,0.00,0.00,0.00,0.00,0.00),('5','101','916','196496',3834626,'2706','240',793753.97,793753.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','196496',3834627,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','196496',3834628,'2708','240',1297228.96,1297228.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','196496',3834629,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','196496',3834630,'2710','240',786031.98,789483.14,3451.16,569441.40,0.00,0.00,0.00,0.00,0.00),('5','101','917','196496',3834631,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','196496',3834632,'2712','240',979901.97,983955.02,4053.05,668753.25,0.00,0.00,0.00,0.00,0.00),('5','101','620','196730',3838720,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','196730',3838721,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','196730',3838722,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','196730',3838723,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','196730',3838724,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','196730',3838725,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','196730',3838726,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','196730',3838727,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','196730',3838728,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','196730',3838729,'1741','241',698780.10,699647.23,867.13,229789.45,0.00,0.00,0.00,0.00,0.00),('5','101','623','196730',3838730,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','196730',3838731,'2705','240',570694.74,573767.73,3072.99,507043.35,0.00,0.00,0.00,0.00,0.00),('5','101','916','196730',3838732,'2706','240',793753.97,795618.21,1864.24,307599.60,0.00,0.00,0.00,0.00,0.00),('5','101','916','196730',3838733,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','196730',3838734,'2708','240',1297228.96,1300179.94,2950.98,486911.70,0.00,0.00,0.00,0.00,0.00),('5','101','917','196730',3838735,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','196730',3838736,'2710','240',789483.14,791122.28,1639.14,270458.10,0.00,0.00,0.00,0.00,0.00),('5','101','917','196730',3838737,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','196730',3838738,'2712','240',983955.02,984014.61,59.59,9832.35,0.00,0.00,0.00,0.00,0.00),('5','101','620','196918',3842051,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','196918',3842052,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','196918',3842053,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','196918',3842054,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','196918',3842055,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','196918',3842056,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','196918',3842057,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','196918',3842058,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','196918',3842059,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','196918',3842060,'1741','241',699647.23,699976.51,329.28,87259.20,0.00,0.00,0.00,0.00,0.00),('5','101','623','196918',3842061,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','196918',3842062,'2705','240',573767.73,573767.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','196918',3842063,'2706','240',795618.21,798359.23,2741.02,452268.30,0.00,0.00,0.00,0.00,0.00),('5','101','916','196918',3842064,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','196918',3842065,'2708','240',1300179.94,1303501.23,3321.29,548012.85,0.00,0.00,0.00,0.00,0.00),('5','101','917','196918',3842066,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','196918',3842067,'2710','240',791122.28,792290.84,1168.56,192812.40,0.00,0.00,0.00,0.00,0.00),('5','101','917','196918',3842068,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','196918',3842069,'2712','240',984014.61,984014.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','197116',3845665,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','197116',3845666,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','197116',3845667,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','197116',3845668,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','197116',3845669,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','197116',3845670,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','197116',3845671,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','197116',3845672,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','197116',3845673,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','197116',3845674,'1741','241',699976.51,700283.08,306.57,81241.05,0.00,0.00,0.00,0.00,0.00),('5','101','623','197116',3845675,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','197116',3845676,'2705','240',573767.73,576776.66,3008.93,496473.45,0.00,0.00,0.00,0.00,0.00),('5','101','916','197116',3845677,'2706','240',798359.23,800144.98,1785.75,294648.75,0.00,0.00,0.00,0.00,0.00),('5','101','916','197116',3845678,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','197116',3845679,'2708','240',1303501.23,1306610.17,3108.94,512975.10,0.00,0.00,0.00,0.00,0.00),('5','101','917','197116',3845680,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','197116',3845681,'2710','240',792290.84,792290.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','197116',3845682,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','197116',3845683,'2712','240',984014.61,984014.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','197491',3852108,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','197491',3852109,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','197491',3852110,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','197491',3852111,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','197491',3852112,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','197491',3852113,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','197491',3852114,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','197491',3852115,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','197491',3852116,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','197491',3852117,'1741','241',700283.08,700922.65,639.57,169486.05,0.00,0.00,0.00,0.00,0.00),('5','101','623','197491',3852118,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','197491',3852119,'2705','240',576776.66,578289.14,1512.48,249559.20,0.00,0.00,0.00,0.00,0.00),('5','101','916','197491',3852120,'2706','240',800144.98,800144.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','197491',3852121,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','197491',3852122,'2708','240',1306610.17,1309414.01,2803.84,462633.60,0.00,0.00,0.00,0.00,0.00),('5','101','917','197491',3852123,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','197491',3852124,'2710','240',792290.84,795093.04,2802.20,462363.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','197491',3852125,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','197491',3852126,'2712','240',984014.61,985600.96,1586.35,261747.75,0.00,0.00,0.00,0.00,0.00),('5','101','620','197749',3856490,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','197749',3856491,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','197749',3856492,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','197749',3856493,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','197749',3856494,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','197749',3856495,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','197749',3856496,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','197749',3856497,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','197749',3856498,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','197749',3856499,'1741','241',700922.65,701777.50,854.85,226535.25,0.00,0.00,0.00,0.00,0.00),('5','101','623','197749',3856500,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','197749',3856501,'2705','240',578289.14,580671.60,2382.46,393105.90,0.00,0.00,0.00,0.00,0.00),('5','101','916','197749',3856502,'2706','240',800144.98,801909.29,1764.31,291111.15,0.00,0.00,0.00,0.00,0.00),('5','101','916','197749',3856503,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','197749',3856504,'2708','240',1309414.01,1310841.04,1427.03,235459.95,0.00,0.00,0.00,0.00,0.00),('5','101','917','197749',3856505,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','197749',3856506,'2710','240',795093.04,797177.95,2084.91,344010.15,0.00,0.00,0.00,0.00,0.00),('5','101','917','197749',3856507,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','197749',3856508,'2712','240',985600.96,987183.22,1582.26,261072.90,0.00,0.00,0.00,0.00,0.00),('5','101','620','197750',3856509,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','197750',3856510,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','197750',3856511,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','197750',3856512,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','197750',3856513,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','197750',3856514,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','197750',3856515,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','197750',3856516,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','197750',3856517,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','197750',3856518,'1741','241',701777.50,702212.00,434.50,115142.50,0.00,0.00,0.00,0.00,0.00),('5','101','623','197750',3856519,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','197750',3856520,'2705','240',580671.60,582577.31,1905.71,314442.15,0.00,0.00,0.00,0.00,0.00),('5','101','916','197750',3856521,'2706','240',801909.29,801909.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','197750',3856522,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','197750',3856523,'2708','240',1310841.04,1310841.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','197750',3856524,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','197750',3856525,'2710','240',797177.95,800907.70,3729.75,615408.75,0.00,0.00,0.00,0.00,0.00),('5','101','917','197750',3856526,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','197750',3856527,'2712','240',987183.22,990298.68,3115.46,514050.90,0.00,0.00,0.00,0.00,0.00),('5','101','620','197954',3860228,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','197954',3860229,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','197954',3860230,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','197954',3860231,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','197954',3860232,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','197954',3860233,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','197954',3860234,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','197954',3860235,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','197954',3860236,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','197954',3860237,'1741','241',702212.00,702212.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','197954',3860238,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','197954',3860239,'2705','240',582577.31,584752.51,2175.20,358908.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','197954',3860240,'2706','240',801909.29,803038.86,1129.57,186379.05,0.00,0.00,0.00,0.00,0.00),('5','101','916','197954',3860241,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','197954',3860242,'2708','240',1310841.04,1313684.07,2843.03,469099.95,0.00,0.00,0.00,0.00,0.00),('5','101','917','197954',3860243,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','197954',3860244,'2710','240',800907.70,803397.57,2489.87,410828.55,0.00,0.00,0.00,0.00,0.00),('5','101','917','197954',3860245,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','197954',3860246,'2712','240',990298.68,991011.84,713.16,117671.40,0.00,0.00,0.00,0.00,0.00),('5','101','620','198132',3863248,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','198132',3863249,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','198132',3863250,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','198132',3863251,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','198132',3863252,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','198132',3863253,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','198132',3863254,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','198132',3863255,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','198132',3863256,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','198132',3863257,'1741','241',702212.00,702212.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','198132',3863258,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','198132',3863259,'2705','240',584752.51,586109.42,1356.91,223890.15,0.00,0.00,0.00,0.00,0.00),('5','101','916','198132',3863260,'2706','240',803038.86,804063.31,1024.45,169034.25,0.00,0.00,0.00,0.00,0.00),('5','101','916','198132',3863261,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','198132',3863262,'2708','240',1313684.07,1316517.45,2833.38,467507.70,0.00,0.00,0.00,0.00,0.00),('5','101','917','198132',3863263,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','198132',3863264,'2710','240',803397.57,805897.30,2499.73,412455.45,0.00,0.00,0.00,0.00,0.00),('5','101','917','198132',3863265,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','198132',3863266,'2712','240',991011.84,991550.45,538.61,88870.65,0.00,0.00,0.00,0.00,0.00),('5','101','620','198351',3867053,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','198351',3867054,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','198351',3867055,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','198351',3867056,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','198351',3867057,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','198351',3867058,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','198351',3867059,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','198351',3867060,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','198351',3867061,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','198351',3867062,'1741','241',702212.00,704233.31,2021.31,545753.70,0.00,0.00,0.00,0.00,0.00),('5','101','623','198351',3867063,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','198351',3867064,'2705','240',586109.42,586109.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','198351',3867065,'2706','240',804063.31,805229.13,1165.82,192360.30,0.00,0.00,0.00,0.00,0.00),('5','101','916','198351',3867066,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','198351',3867067,'2708','240',1316517.45,1319413.61,2896.16,477866.40,0.00,0.00,0.00,0.00,0.00),('5','101','917','198351',3867068,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','198351',3867069,'2710','240',805897.30,809022.03,3124.73,515580.45,0.00,0.00,0.00,0.00,0.00),('5','101','917','198351',3867070,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','198351',3867071,'2712','240',991550.45,993815.35,2264.90,373708.50,0.00,0.00,0.00,0.00,0.00),('5','101','620','198598',3871236,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','198598',3871237,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','198598',3871238,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','198598',3871239,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','198598',3871240,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','198598',3871241,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','198598',3871242,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','198598',3871243,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','198598',3871244,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','198598',3871245,'1741','241',704233.31,705177.61,944.30,254961.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','198598',3871246,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','198598',3871247,'2705','240',586109.42,588070.16,1960.74,323522.10,0.00,0.00,0.00,0.00,0.00),('5','101','916','198598',3871248,'2706','240',805229.13,805430.39,201.26,33207.90,0.00,0.00,0.00,0.00,0.00),('5','101','916','198598',3871249,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','198598',3871250,'2708','240',1319413.61,1322558.86,3145.25,518966.25,0.00,0.00,0.00,0.00,0.00),('5','101','917','198598',3871251,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','198598',3871252,'2710','240',809022.03,810958.73,1936.70,319555.50,0.00,0.00,0.00,0.00,0.00),('5','101','917','198598',3871253,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','198598',3871254,'2712','240',993815.35,995078.60,1263.25,208436.25,0.00,0.00,0.00,0.00,0.00),('5','101','620','198823',3874870,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','198823',3874871,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','198823',3874872,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','198823',3874873,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','198823',3874874,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','198823',3874875,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','198823',3874876,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','198823',3874877,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','198823',3874878,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','198823',3874879,'1741','241',705177.61,706421.30,1243.69,335796.30,0.00,0.00,0.00,0.00,0.00),('5','101','623','198823',3874880,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','198823',3874881,'2705','240',588070.16,589798.61,1728.45,285194.25,0.00,0.00,0.00,0.00,0.00),('5','101','916','198823',3874882,'2706','240',805430.39,806462.74,1032.35,170337.75,0.00,0.00,0.00,0.00,0.00),('5','101','916','198823',3874883,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','198823',3874884,'2708','240',1322558.86,1325125.46,2566.60,423489.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','198823',3874885,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','198823',3874886,'2710','240',810958.73,812739.00,1780.27,293744.55,0.00,0.00,0.00,0.00,0.00),('5','101','917','198823',3874887,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','198823',3874888,'2712','240',995078.60,996844.09,1765.49,291305.85,0.00,0.00,0.00,0.00,0.00),('5','101','620','198983',3877900,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','198983',3877901,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','198983',3877902,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','198983',3877903,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','198983',3877904,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','198983',3877905,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','198983',3877906,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','198983',3877907,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','198983',3877908,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','198983',3877909,'1741','241',706421.30,707222.38,801.08,216291.60,0.00,0.00,0.00,0.00,0.00),('5','101','623','198983',3877910,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','198983',3877911,'2705','240',589798.61,591152.72,1354.11,223428.15,0.00,0.00,0.00,0.00,0.00),('5','101','916','198983',3877912,'2706','240',806462.74,808090.91,1628.17,268648.05,0.00,0.00,0.00,0.00,0.00),('5','101','916','198983',3877913,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','198983',3877914,'2708','240',1325125.46,1327396.13,2270.67,374660.55,0.00,0.00,0.00,0.00,0.00),('5','101','917','198983',3877915,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','198983',3877916,'2710','240',812739.00,814489.48,1750.48,288829.20,0.00,0.00,0.00,0.00,0.00),('5','101','917','198983',3877917,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','198983',3877918,'2712','240',996844.09,998284.04,1439.95,237591.75,0.00,0.00,0.00,0.00,0.00),('5','101','620','199201',3881811,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','199201',3881812,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','199201',3881813,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','199201',3881814,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','199201',3881815,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','199201',3881816,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','199201',3881817,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','199201',3881818,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','199201',3881819,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','199201',3881820,'1741','241',707222.38,707876.86,654.48,176709.60,0.00,0.00,0.00,0.00,0.00),('5','101','623','199201',3881821,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','199201',3881822,'2705','240',591152.72,593438.94,2286.22,377226.30,0.00,0.00,0.00,0.00,0.00),('5','101','916','199201',3881823,'2706','240',808090.91,808111.24,20.33,3354.45,0.00,0.00,0.00,0.00,0.00),('5','101','916','199201',3881824,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','199201',3881825,'2708','240',1327396.13,1329333.04,1936.91,319590.15,0.00,0.00,0.00,0.00,0.00),('5','101','917','199201',3881826,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','199201',3881827,'2710','240',814489.48,817330.86,2841.38,468827.70,0.00,0.00,0.00,0.00,0.00),('5','101','917','199201',3881828,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','199201',3881829,'2712','240',998284.04,1000468.10,2184.06,360369.90,0.00,0.00,0.00,0.00,0.00),('5','101','620','199445',3885575,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','199445',3885576,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','199445',3885577,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','199445',3885578,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','199445',3885579,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','199445',3885580,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','199445',3885581,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','199445',3885582,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','199445',3885583,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','199445',3885584,'1741','241',707876.86,708974.01,1097.15,296230.50,0.00,0.00,0.00,0.00,0.00),('5','101','623','199445',3885585,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','199445',3885586,'2705','240',593438.94,595428.68,1989.74,328307.10,0.00,0.00,0.00,0.00,0.00),('5','101','916','199445',3885587,'2706','240',808111.24,809260.33,1149.09,189599.85,0.00,0.00,0.00,0.00,0.00),('5','101','916','199445',3885588,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','199445',3885589,'2708','240',1329333.04,1331124.73,1791.69,295628.85,0.00,0.00,0.00,0.00,0.00),('5','101','917','199445',3885590,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','199445',3885591,'2710','240',817330.86,819529.70,2198.84,362808.60,0.00,0.00,0.00,0.00,0.00),('5','101','917','199445',3885592,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','199445',3885593,'2712','240',1000468.10,1002686.35,2218.25,366011.25,0.00,0.00,0.00,0.00,0.00),('5','101','620','199688',3889544,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','199688',3889545,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','199688',3889546,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','199688',3889547,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','199688',3889548,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','199688',3889549,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','199688',3889550,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','199688',3889551,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','199688',3889552,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','199688',3889553,'1741','241',708974.01,710125.23,1151.22,310829.40,0.00,0.00,0.00,0.00,0.00),('5','101','623','199688',3889554,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','199688',3889555,'2705','240',595428.68,597357.03,1928.35,318177.75,0.00,0.00,0.00,0.00,0.00),('5','101','916','199688',3889556,'2706','240',809260.33,811546.96,2286.63,377293.95,0.00,0.00,0.00,0.00,0.00),('5','101','916','199688',3889557,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','199688',3889558,'2708','240',1331124.73,1333285.48,2160.75,356523.75,0.00,0.00,0.00,0.00,0.00),('5','101','917','199688',3889559,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','199688',3889560,'2710','240',819529.70,821604.38,2074.68,342322.20,0.00,0.00,0.00,0.00,0.00),('5','101','917','199688',3889561,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','199688',3889562,'2712','240',1002686.35,1002716.93,30.58,5045.70,0.00,0.00,0.00,0.00,0.00),('5','101','620','199941',3893684,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','199941',3893685,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','199941',3893686,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','199941',3893687,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','199941',3893688,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','199941',3893689,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','199941',3893690,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','199941',3893691,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','199941',3893692,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','199941',3893693,'1741','241',710125.23,711140.89,1015.66,274228.20,0.00,0.00,0.00,0.00,0.00),('5','101','623','199941',3893694,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','199941',3893695,'2705','240',597357.03,598476.95,1119.92,184786.80,0.00,0.00,0.00,0.00,0.00),('5','101','916','199941',3893696,'2706','240',811546.96,812599.57,1052.61,173680.65,0.00,0.00,0.00,0.00,0.00),('5','101','916','199941',3893697,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','199941',3893698,'2708','240',1333285.48,1336169.52,2884.04,475866.60,0.00,0.00,0.00,0.00,0.00),('5','101','917','199941',3893699,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','199941',3893700,'2710','240',821604.38,824655.05,3050.67,503360.55,0.00,0.00,0.00,0.00,0.00),('5','101','917','199941',3893701,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','199941',3893702,'2712','240',1002716.93,1004528.56,1811.63,298918.95,0.00,0.00,0.00,0.00,0.00),('5','101','620','200090',3896702,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','200090',3896703,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','200090',3896704,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','200090',3896705,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','200090',3896706,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','200090',3896707,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','200090',3896708,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','200090',3896709,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','200090',3896710,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','200090',3896711,'1741','241',711140.89,712043.48,902.59,243699.30,0.00,0.00,0.00,0.00,0.00),('5','101','623','200090',3896712,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','200090',3896713,'2705','240',598476.95,601125.90,2648.95,437076.75,0.00,0.00,0.00,0.00,0.00),('5','101','916','200090',3896714,'2706','240',812599.57,813307.35,707.78,116783.70,0.00,0.00,0.00,0.00,0.00),('5','101','916','200090',3896715,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','200090',3896716,'2708','240',1336169.52,1338575.44,2405.92,396976.80,0.00,0.00,0.00,0.00,0.00),('5','101','917','200090',3896717,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','200090',3896718,'2710','240',824655.05,826632.70,1977.65,326312.25,0.00,0.00,0.00,0.00,0.00),('5','101','917','200090',3896719,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','200090',3896720,'2712','240',1004528.56,1006727.73,2199.17,362863.05,0.00,0.00,0.00,0.00,0.00),('5','101','620','200301',3900285,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','200301',3900286,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','200301',3900287,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','200301',3900288,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','200301',3900289,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','200301',3900290,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','200301',3900291,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','200301',3900292,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','200301',3900293,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','200301',3900294,'1741','241',712043.48,713078.14,1034.66,279358.20,0.00,0.00,0.00,0.00,0.00),('5','101','623','200301',3900295,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','200301',3900296,'2705','240',601125.90,602989.78,1863.88,307540.20,0.00,0.00,0.00,0.00,0.00),('5','101','916','200301',3900297,'2706','240',813307.35,813423.70,116.35,19197.75,0.00,0.00,0.00,0.00,0.00),('5','101','916','200301',3900298,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','200301',3900299,'2708','240',1338575.44,1340683.86,2108.42,347889.30,0.00,0.00,0.00,0.00,0.00),('5','101','917','200301',3900300,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','200301',3900301,'2710','240',826632.70,828012.76,1380.06,227709.90,0.00,0.00,0.00,0.00,0.00),('5','101','917','200301',3900302,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','200301',3900303,'2712','240',1006727.73,1008836.47,2108.74,347942.10,0.00,0.00,0.00,0.00,0.00),('5','101','620','200517',3904313,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','200517',3904314,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','200517',3904315,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','200517',3904316,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','200517',3904317,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','200517',3904318,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','200517',3904319,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','200517',3904320,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','200517',3904321,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','200517',3904322,'1741','241',713078.14,713940.77,862.63,232910.10,0.00,0.00,0.00,0.00,0.00),('5','101','623','200517',3904323,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','200517',3904324,'2705','240',602989.78,603048.81,59.03,9739.95,0.00,0.00,0.00,0.00,0.00),('5','101','916','200517',3904325,'2706','240',813423.70,814688.05,1264.35,208617.75,0.00,0.00,0.00,0.00,0.00),('5','101','916','200517',3904326,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','200517',3904327,'2708','240',1340683.86,1343735.61,3051.75,503538.75,0.00,0.00,0.00,0.00,0.00),('5','101','917','200517',3904328,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','200517',3904329,'2710','240',828012.76,830596.77,2584.01,426361.65,0.00,0.00,0.00,0.00,0.00),('5','101','917','200517',3904330,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','200517',3904331,'2712','240',1008836.47,1011371.00,2534.53,418197.45,0.00,0.00,0.00,0.00,0.00),('5','101','620','200705',3907648,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','200705',3907649,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','200705',3907650,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','200705',3907651,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','200705',3907652,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','200705',3907653,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','200705',3907654,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','200705',3907655,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','200705',3907656,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','200705',3907657,'1741','241',713940.77,714816.73,875.96,236509.20,0.00,0.00,0.00,0.00,0.00),('5','101','623','200705',3907658,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','200705',3907659,'2705','240',603048.81,603657.19,608.38,100382.70,0.00,0.00,0.00,0.00,0.00),('5','101','916','200705',3907660,'2706','240',814688.05,817562.39,2874.34,474266.10,0.00,0.00,0.00,0.00,0.00),('5','101','916','200705',3907661,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','200705',3907662,'2708','240',1343735.61,1346411.20,2675.59,441472.35,0.00,0.00,0.00,0.00,0.00),('5','101','917','200705',3907663,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','200705',3907664,'2710','240',830596.77,832916.74,2319.97,382795.05,0.00,0.00,0.00,0.00,0.00),('5','101','917','200705',3907665,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','200705',3907666,'2712','240',1011371.00,1013000.75,1629.75,268908.75,0.00,0.00,0.00,0.00,0.00),('5','101','620','200922',3911514,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','200922',3911515,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','200922',3911516,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','200922',3911517,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','200922',3911518,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','200922',3911519,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','200922',3911520,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','200922',3911521,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','200922',3911522,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','200922',3911523,'1741','241',714816.73,715905.48,1088.75,293962.50,0.00,0.00,0.00,0.00,0.00),('5','101','623','200922',3911524,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','200922',3911525,'2705','240',603657.19,605757.23,2100.04,346506.60,0.00,0.00,0.00,0.00,0.00),('5','101','916','200922',3911526,'2706','240',817562.39,819428.45,1866.06,307899.90,0.00,0.00,0.00,0.00,0.00),('5','101','916','200922',3911527,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','200922',3911528,'2708','240',1346411.20,1348759.13,2347.93,387408.45,0.00,0.00,0.00,0.00,0.00),('5','101','917','200922',3911529,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','200922',3911530,'2710','240',832916.74,834955.09,2038.35,336327.75,0.00,0.00,0.00,0.00,0.00),('5','101','917','200922',3911531,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','200922',3911532,'2712','240',1013000.75,1013815.39,814.64,134415.60,0.00,0.00,0.00,0.00,0.00),('5','101','620','201133',3914814,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','201133',3914815,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','201133',3914816,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','201133',3914817,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','201133',3914818,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','201133',3914819,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','201133',3914820,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','201133',3914821,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','201133',3914822,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','201133',3914823,'1741','241',715905.48,718276.27,2370.79,640113.30,0.00,0.00,0.00,0.00,0.00),('5','101','623','201133',3914824,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','201133',3914825,'2705','240',605757.23,607071.84,1314.61,216910.65,0.00,0.00,0.00,0.00,0.00),('5','101','916','201133',3914826,'2706','240',819428.45,820518.69,1090.24,179889.60,0.00,0.00,0.00,0.00,0.00),('5','101','916','201133',3914827,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','201133',3914828,'2708','240',1348759.13,1351389.06,2629.93,433938.45,0.00,0.00,0.00,0.00,0.00),('5','101','917','201133',3914829,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','201133',3914830,'2710','240',834955.09,837180.38,2225.29,367172.85,0.00,0.00,0.00,0.00,0.00),('5','101','917','201133',3914831,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','201133',3914832,'2712','240',1013815.39,1015142.94,1327.55,219045.75,0.00,0.00,0.00,0.00,0.00),('5','101','620','201329',3918229,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','201329',3918230,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','201329',3918231,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','201329',3918232,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','201329',3918233,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','201329',3918234,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','201329',3918235,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','201329',3918236,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','201329',3918237,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','201329',3918238,'1741','241',718276.27,719187.69,911.42,246083.40,0.00,0.00,0.00,0.00,0.00),('5','101','623','201329',3918239,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','201329',3918240,'2705','240',607071.84,608583.40,1511.56,249407.40,0.00,0.00,0.00,0.00,0.00),('5','101','916','201329',3918241,'2706','240',820518.69,820724.35,205.66,33933.90,0.00,0.00,0.00,0.00,0.00),('5','101','916','201329',3918242,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','201329',3918243,'2708','240',1351389.06,1355082.34,3693.28,609391.20,0.00,0.00,0.00,0.00,0.00),('5','101','917','201329',3918244,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','201329',3918245,'2710','240',837180.38,839463.61,2283.23,376732.95,0.00,0.00,0.00,0.00,0.00),('5','101','917','201329',3918246,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','201329',3918247,'2712','240',1015142.94,1017486.72,2343.78,386723.70,0.00,0.00,0.00,0.00,0.00),('5','101','620','201522',3921718,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','201522',3921719,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','201522',3921720,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','201522',3921721,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','201522',3921722,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','201522',3921723,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','201522',3921724,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','201522',3921725,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','201522',3921726,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','201522',3921727,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','201522',3921728,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','201522',3921729,'2705','240',608583.40,609855.59,1272.19,209911.35,0.00,0.00,0.00,0.00,0.00),('5','101','916','201522',3921730,'2706','240',820724.35,822024.47,1300.12,214519.80,0.00,0.00,0.00,0.00,0.00),('5','101','916','201522',3921731,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','201522',3921732,'2708','240',1355082.34,1357738.80,2656.46,438315.90,0.00,0.00,0.00,0.00,0.00),('5','101','917','201522',3921733,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','201522',3921734,'2710','240',839463.61,841787.82,2324.21,383494.65,0.00,0.00,0.00,0.00,0.00),('5','101','917','201522',3921735,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','201522',3921736,'2712','240',1017486.72,1019125.22,1638.50,270352.50,0.00,0.00,0.00,0.00,0.00),('5','101','620','201780',3926810,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','201780',3926811,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','201780',3926812,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','201780',3926813,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','201780',3926814,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','201780',3926815,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','201780',3926816,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','201780',3926817,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','201780',3926818,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','201780',3926819,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','201780',3926820,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','201780',3926821,'2705','240',609855.59,611165.23,1309.64,216090.60,0.00,0.00,0.00,0.00,0.00),('5','101','916','201780',3926822,'2706','240',822024.47,824210.60,2186.13,360711.45,0.00,0.00,0.00,0.00,0.00),('5','101','916','201780',3926823,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','201780',3926824,'2708','240',1357738.80,1360700.37,2961.57,488659.05,0.00,0.00,0.00,0.00,0.00),('5','101','917','201780',3926825,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','201780',3926826,'2710','240',841787.82,844263.05,2475.23,408412.95,0.00,0.00,0.00,0.00,0.00),('5','101','917','201780',3926827,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','201780',3926828,'2712','240',1019125.22,1019125.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','202057',3931920,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','202057',3931921,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','202057',3931922,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','202057',3931923,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','202057',3931924,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','202057',3931925,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','202057',3931926,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','202057',3931927,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','202057',3931928,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','202057',3931929,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','202057',3931930,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','202057',3931931,'2705','240',611165.23,611587.18,421.95,69621.75,0.00,0.00,0.00,0.00,0.00),('5','101','916','202057',3931932,'2706','240',824210.60,826350.87,2140.27,353144.55,0.00,0.00,0.00,0.00,0.00),('5','101','916','202057',3931933,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','202057',3931934,'2708','240',1360700.37,1364189.81,3489.44,575757.60,0.00,0.00,0.00,0.00,0.00),('5','101','917','202057',3931935,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','202057',3931936,'2710','240',844263.05,846545.01,2281.96,376523.40,0.00,0.00,0.00,0.00,0.00),('5','101','917','202057',3931937,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','202057',3931938,'2712','240',1019125.22,1019125.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','202278',3935655,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','202278',3935656,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','202278',3935657,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','202278',3935658,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','202278',3935659,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','202278',3935660,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','202278',3935661,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','202278',3935662,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','202278',3935663,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','202278',3935664,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','202278',3935665,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','202278',3935666,'2705','240',611587.18,612887.45,1300.27,214544.55,0.00,0.00,0.00,0.00,0.00),('5','101','916','202278',3935667,'2706','240',826350.87,828826.82,2475.95,408531.75,0.00,0.00,0.00,0.00,0.00),('5','101','916','202278',3935668,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','202278',3935669,'2708','240',1364189.81,1367221.24,3031.43,500185.95,0.00,0.00,0.00,0.00,0.00),('5','101','917','202278',3935670,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','202278',3935671,'2710','240',846545.01,849046.17,2501.16,412691.40,0.00,0.00,0.00,0.00,0.00),('5','101','917','202278',3935672,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','202278',3935673,'2712','240',1019125.22,1019288.40,163.18,26924.70,0.00,0.00,0.00,0.00,0.00),('5','101','620','202435',3938512,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','202435',3938513,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','202435',3938514,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','202435',3938515,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','202435',3938516,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','202435',3938517,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','202435',3938518,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','202435',3938519,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','202435',3938520,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','202435',3938521,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','202435',3938522,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','202435',3938523,'2705','240',612887.45,616061.38,3173.93,523698.45,0.00,0.00,0.00,0.00,0.00),('5','101','916','202435',3938524,'2706','240',828826.82,830196.56,1369.74,226007.10,0.00,0.00,0.00,0.00,0.00),('5','101','916','202435',3938525,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','202435',3938526,'2708','240',1367221.24,1368422.31,1201.07,198176.55,0.00,0.00,0.00,0.00,0.00),('5','101','917','202435',3938527,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','202435',3938528,'2710','240',849046.17,849835.87,789.70,130300.50,0.00,0.00,0.00,0.00,0.00),('5','101','917','202435',3938529,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','202435',3938530,'2712','240',1019288.40,1021052.81,1764.41,291127.65,0.00,0.00,0.00,0.00,0.00),('5','101','620','202706',3943070,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','202706',3943071,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','202706',3943072,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','202706',3943073,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','202706',3943074,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','202706',3943075,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','202706',3943076,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','202706',3943077,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','202706',3943078,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','202706',3943079,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','202706',3943080,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','202706',3943081,'2705','240',616061.38,618059.96,1998.58,329765.70,0.00,0.00,0.00,0.00,0.00),('5','101','916','202706',3943082,'2706','240',830196.56,830662.89,466.33,76944.45,0.00,0.00,0.00,0.00,0.00),('5','101','916','202706',3943083,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','202706',3943084,'2708','240',1368422.31,1369298.11,875.80,144507.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','202706',3943085,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','202706',3943086,'2710','240',849835.87,852814.38,2978.51,491454.15,0.00,0.00,0.00,0.00,0.00),('5','101','917','202706',3943087,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','202706',3943088,'2712','240',1021052.81,1023997.47,2944.66,485868.90,0.00,0.00,0.00,0.00,0.00),('5','101','620','202855',3945945,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','202855',3945946,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','202855',3945947,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','202855',3945948,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','202855',3945949,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','202855',3945950,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','202855',3945951,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','202855',3945952,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','202855',3945953,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','202855',3945954,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','202855',3945955,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','202855',3945956,'2705','240',618059.96,619166.13,1106.17,182518.05,0.00,0.00,0.00,0.00,0.00),('5','101','916','202855',3945957,'2706','240',830662.89,832477.50,1814.61,299410.65,0.00,0.00,0.00,0.00,0.00),('5','101','916','202855',3945958,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','202855',3945959,'2708','240',1369298.11,1370163.97,865.86,142866.90,0.00,0.00,0.00,0.00,0.00),('5','101','917','202855',3945960,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','202855',3945961,'2710','240',852814.38,855334.18,2519.80,415767.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','202855',3945962,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','202855',3945963,'2712','240',1023997.47,1026071.15,2073.68,342157.20,0.00,0.00,0.00,0.00,0.00),('5','101','620','203117',3950909,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','203117',3950910,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','203117',3950911,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','203117',3950912,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','203117',3950913,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','203117',3950914,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','203117',3950915,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','203117',3950916,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','203117',3950917,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','203117',3950918,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','203117',3950919,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','203117',3950920,'2705','240',619166.13,622405.19,3239.06,534444.90,0.00,0.00,0.00,0.00,0.00),('5','101','916','203117',3950921,'2706','240',832477.50,832477.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','203117',3950922,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','203117',3950923,'2708','240',1370163.97,1372167.73,2003.76,330620.40,0.00,0.00,0.00,0.00,0.00),('5','101','917','203117',3950924,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','203117',3950925,'2710','240',855334.18,857970.06,2635.88,434920.20,0.00,0.00,0.00,0.00,0.00),('5','101','917','203117',3950926,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','203117',3950927,'2712','240',1026071.15,1027144.63,1073.48,177124.20,0.00,0.00,0.00,0.00,0.00),('5','101','620','203335',3954786,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','203335',3954787,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','203335',3954788,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','203335',3954789,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','203335',3954790,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','203335',3954791,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','203335',3954792,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','203335',3954793,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','203335',3954794,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','203335',3954795,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','203335',3954796,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','203335',3954797,'2705','240',622405.19,624717.60,2312.41,381547.65,0.00,0.00,0.00,0.00,0.00),('5','101','916','203335',3954798,'2706','240',832477.50,833846.79,1369.29,225932.85,0.00,0.00,0.00,0.00,0.00),('5','101','916','203335',3954799,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','203335',3954800,'2708','240',1372167.73,1374211.40,2043.67,337205.55,0.00,0.00,0.00,0.00,0.00),('5','101','917','203335',3954801,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','203335',3954802,'2710','240',857970.06,860059.98,2089.92,344836.80,0.00,0.00,0.00,0.00,0.00),('5','101','917','203335',3954803,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','203335',3954804,'2712','240',1027144.63,1028719.45,1574.82,259845.30,0.00,0.00,0.00,0.00,0.00),('5','101','620','203531',3958381,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','203531',3958382,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','203531',3958383,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','203531',3958384,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','203531',3958385,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','203531',3958386,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','203531',3958387,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','203531',3958388,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','203531',3958389,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','203531',3958390,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','203531',3958391,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','203531',3958392,'2705','240',624717.60,627402.25,2684.65,442967.25,0.00,0.00,0.00,0.00,0.00),('5','101','916','203531',3958393,'2706','240',833846.79,834753.93,907.14,149678.10,0.00,0.00,0.00,0.00,0.00),('5','101','916','203531',3958394,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','203531',3958395,'2708','240',1374211.40,1376057.26,1845.86,304566.90,0.00,0.00,0.00,0.00,0.00),('5','101','917','203531',3958396,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','203531',3958397,'2710','240',860059.98,861969.11,1909.13,315006.45,0.00,0.00,0.00,0.00,0.00),('5','101','917','203531',3958398,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','203531',3958399,'2712','240',1028719.45,1030449.60,1730.15,285474.75,0.00,0.00,0.00,0.00,0.00),('5','101','620','203738',3962121,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','203738',3962122,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','203738',3962123,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','203738',3962124,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','203738',3962125,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','203738',3962126,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','203738',3962127,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','203738',3962128,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','203738',3962129,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','203738',3962130,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','203738',3962131,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','203738',3962132,'2705','240',627402.25,628528.05,1125.80,185757.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','203738',3962133,'2706','240',834753.93,836053.71,1299.78,214463.70,0.00,0.00,0.00,0.00,0.00),('5','101','916','203738',3962134,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','203738',3962135,'2708','240',1376057.26,1378383.91,2326.65,383897.25,0.00,0.00,0.00,0.00,0.00),('5','101','917','203738',3962136,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','203738',3962137,'2710','240',861969.11,864230.37,2261.26,373107.90,0.00,0.00,0.00,0.00,0.00),('5','101','917','203738',3962138,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','203738',3962139,'2712','240',1030449.60,1032471.30,2021.70,333580.50,0.00,0.00,0.00,0.00,0.00),('5','101','620','203965',3966138,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','203965',3966139,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','203965',3966140,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','203965',3966141,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','203965',3966142,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','203965',3966143,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','203965',3966144,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','203965',3966145,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','203965',3966146,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','203965',3966147,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','203965',3966148,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','203965',3966149,'2705','240',628528.05,631155.20,2627.15,433479.75,0.00,0.00,0.00,0.00,0.00),('5','101','916','203965',3966150,'2706','240',836053.71,836487.68,433.97,71605.05,0.00,0.00,0.00,0.00,0.00),('5','101','916','203965',3966151,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','203965',3966152,'2708','240',1378383.91,1380625.69,2241.78,369893.70,0.00,0.00,0.00,0.00,0.00),('5','101','917','203965',3966153,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','203965',3966154,'2710','240',864230.37,865566.38,1336.01,220441.65,0.00,0.00,0.00,0.00,0.00),('5','101','917','203965',3966155,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','203965',3966156,'2712','240',1032471.30,1034237.27,1765.97,291385.05,0.00,0.00,0.00,0.00,0.00),('5','101','620','204203',3970449,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','204203',3970450,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','204203',3970451,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','204203',3970452,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','204203',3970453,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','204203',3970454,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','204203',3970455,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','204203',3970456,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','204203',3970457,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','204203',3970458,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','204203',3970459,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','204203',3970460,'2705','240',631155.20,633590.16,2434.96,401768.40,0.00,0.00,0.00,0.00,0.00),('5','101','916','204203',3970461,'2706','240',836487.68,837294.66,806.98,133151.70,0.00,0.00,0.00,0.00,0.00),('5','101','916','204203',3970462,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','204203',3970463,'2708','240',1380625.69,1382582.49,1956.80,322872.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','204203',3970464,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','204203',3970465,'2710','240',865566.38,866621.08,1054.70,174025.50,0.00,0.00,0.00,0.00,0.00),('5','101','917','204203',3970466,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','204203',3970467,'2712','240',1034237.27,1035785.90,1548.63,255523.95,0.00,0.00,0.00,0.00,0.00),('5','101','620','204434',3974472,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','204434',3974473,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','204434',3974474,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','204434',3974475,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','204434',3974476,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','204434',3974477,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','204434',3974478,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','204434',3974479,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','204434',3974480,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','204434',3974481,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','204434',3974482,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','204434',3974483,'2705','240',633590.16,637048.05,3457.89,570551.85,0.00,0.00,0.00,0.00,0.00),('5','101','916','204434',3974484,'2706','240',837294.66,837294.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','204434',3974485,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','204434',3974486,'2708','240',1382582.49,1384391.17,1808.68,298432.20,0.00,0.00,0.00,0.00,0.00),('5','101','917','204434',3974487,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','204434',3974488,'2710','240',866621.08,868794.71,2173.63,358648.95,0.00,0.00,0.00,0.00,0.00),('5','101','917','204434',3974489,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','204434',3974490,'2712','240',1035785.90,1037211.02,1425.12,235144.80,0.00,0.00,0.00,0.00,0.00),('5','101','620','204623',3978098,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','204623',3978099,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','204623',3978100,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','204623',3978101,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','204623',3978102,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','204623',3978103,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','204623',3978104,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','204623',3978105,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','204623',3978106,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','204623',3978107,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','204623',3978108,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','204623',3978109,'2705','240',637048.05,638280.23,1232.18,203309.70,0.00,0.00,0.00,0.00,0.00),('5','101','916','204623',3978110,'2706','240',837294.66,838532.74,1238.08,204283.20,0.00,0.00,0.00,0.00,0.00),('5','101','916','204623',3978111,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','204623',3978112,'2708','240',1384391.17,1385835.08,1443.91,238245.15,0.00,0.00,0.00,0.00,0.00),('5','101','917','204623',3978113,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','204623',3978114,'2710','240',868794.71,871878.18,3083.47,508772.55,0.00,0.00,0.00,0.00,0.00),('5','101','917','204623',3978115,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','204623',3978116,'2712','240',1037211.02,1038595.60,1384.58,228455.70,0.00,0.00,0.00,0.00,0.00),('5','101','620','204847',3981656,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','204847',3981657,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','204847',3981658,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','204847',3981659,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','204847',3981660,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','204847',3981661,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','204847',3981662,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','204847',3981663,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','204847',3981664,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','204847',3981665,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','204847',3981666,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','204847',3981667,'2705','240',638280.23,641420.48,3140.25,518141.25,0.00,0.00,0.00,0.00,0.00),('5','101','916','204847',3981668,'2706','240',838532.74,838532.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','204847',3981669,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','204847',3981670,'2708','240',1385835.08,1387883.81,2048.73,338040.45,0.00,0.00,0.00,0.00,0.00),('5','101','917','204847',3981671,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','204847',3981672,'2710','240',871878.18,873856.48,1978.30,326419.50,0.00,0.00,0.00,0.00,0.00),('5','101','917','204847',3981673,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','204847',3981674,'2712','240',1038595.60,1039392.40,796.80,131472.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','205032',3985146,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','205032',3985147,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','205032',3985148,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','205032',3985149,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','205032',3985150,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','205032',3985151,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','205032',3985152,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','205032',3985153,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','205032',3985154,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','205032',3985155,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','205032',3985156,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','205032',3985157,'2705','240',641420.48,644477.00,3056.52,504325.80,0.00,0.00,0.00,0.00,0.00),('5','101','916','205032',3985158,'2706','240',838532.74,838790.92,258.18,42599.70,0.00,0.00,0.00,0.00,0.00),('5','101','916','205032',3985159,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','205032',3985160,'2708','240',1387883.81,1389138.34,1254.53,206997.45,0.00,0.00,0.00,0.00,0.00),('5','101','917','205032',3985161,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','205032',3985162,'2710','240',873856.48,877074.04,3217.56,530897.40,0.00,0.00,0.00,0.00,0.00),('5','101','917','205032',3985163,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','205032',3985164,'2712','240',1039392.40,1040466.26,1073.86,177186.90,0.00,0.00,0.00,0.00,0.00),('5','101','620','205273',3989274,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','205273',3989275,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','205273',3989276,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','205273',3989277,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','205273',3989278,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','205273',3989279,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','205273',3989280,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','205273',3989281,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','205273',3989282,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','205273',3989283,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','205273',3989284,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','205273',3989285,'2705','240',644477.00,646572.27,2095.27,345719.55,0.00,0.00,0.00,0.00,0.00),('5','101','916','205273',3989286,'2706','240',838790.92,839004.86,213.94,35300.10,0.00,0.00,0.00,0.00,0.00),('5','101','916','205273',3989287,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','205273',3989288,'2708','240',1389138.34,1392329.07,3190.73,526470.45,0.00,0.00,0.00,0.00,0.00),('5','101','917','205273',3989289,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','205273',3989290,'2710','240',877074.04,877367.55,293.51,48429.15,0.00,0.00,0.00,0.00,0.00),('5','101','917','205273',3989291,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','205273',3989292,'2712','240',1040466.26,1043335.50,2869.24,473424.60,0.00,0.00,0.00,0.00,0.00),('5','101','620','205493',3993303,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','205493',3993304,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','205493',3993305,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','205493',3993306,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','205493',3993307,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','205493',3993308,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','205493',3993309,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','205493',3993310,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','205493',3993311,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','205493',3993312,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','205493',3993313,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','205493',3993314,'2705','240',646572.27,648728.88,2156.61,355840.65,0.00,0.00,0.00,0.00,0.00),('5','101','916','205493',3993315,'2706','240',839004.86,839004.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','205493',3993316,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','205493',3993317,'2708','240',1392329.07,1393260.27,931.20,153648.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','205493',3993318,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','205493',3993319,'2710','240',877367.55,879154.90,1787.35,294912.75,0.00,0.00,0.00,0.00,0.00),('5','101','917','205493',3993320,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','205493',3993321,'2712','240',1043335.50,1045272.46,1936.96,319598.40,0.00,0.00,0.00,0.00,0.00),('5','101','620','205754',3998013,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','205754',3998014,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','205754',3998015,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','205754',3998016,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','205754',3998017,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','205754',3998018,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','205754',3998019,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','205754',3998020,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','205754',3998021,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','205754',3998022,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','205754',3998023,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','205754',3998024,'2705','240',648728.88,652179.94,3451.06,569424.90,0.00,0.00,0.00,0.00,0.00),('5','101','916','205754',3998025,'2706','240',839004.86,839004.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','205754',3998026,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','205754',3998027,'2708','240',1393260.27,1393988.01,727.74,120077.10,0.00,0.00,0.00,0.00,0.00),('5','101','917','205754',3998028,'2709','240',1452183.58,1452183.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','205754',3998029,'2710','240',879154.90,881583.78,2428.88,400765.20,0.00,0.00,0.00,0.00,0.00),('5','101','917','205754',3998030,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','205754',3998031,'2712','240',1045272.46,1047634.00,2361.54,389654.10,0.00,0.00,0.00,0.00,0.00),('5','101','620','205954',4001669,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','205954',4001670,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','205954',4001671,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','205954',4001672,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','205954',4001673,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','205954',4001674,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','205954',4001675,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','205954',4001676,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','205954',4001677,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','205954',4001678,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','205954',4001679,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','205954',4001680,'2705','240',652179.94,652498.11,318.17,52498.05,0.00,0.00,0.00,0.00,0.00),('5','101','916','205954',4001681,'2706','240',839004.86,839004.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','205954',4001682,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','205954',4001683,'2708','240',1393988.01,1397395.30,3407.29,562202.85,0.00,0.00,0.00,0.00,0.00),('5','101','917','205954',4001684,'2709','240',1452183.58,1453844.30,1660.72,274018.80,0.00,0.00,0.00,0.00,0.00),('5','101','917','205954',4001685,'2710','240',881583.78,882866.24,1282.46,211605.90,0.00,0.00,0.00,0.00,0.00),('5','101','917','205954',4001686,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','205954',4001687,'2712','240',1047634.00,1050519.41,2885.41,476092.65,0.00,0.00,0.00,0.00,0.00),('5','101','620','206165',4005434,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','206165',4005435,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','206165',4005436,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','206165',4005437,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','206165',4005438,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','206165',4005439,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','206165',4005440,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','206165',4005441,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','206165',4005442,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','206165',4005443,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','206165',4005444,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','206165',4005445,'2705','240',652498.11,655908.23,3410.12,562669.80,0.00,0.00,0.00,0.00,0.00),('5','101','916','206165',4005446,'2706','240',839004.86,840475.70,1470.84,242688.60,0.00,0.00,0.00,0.00,0.00),('5','101','916','206165',4005447,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','206165',4005448,'2708','240',1397395.30,1397400.74,5.44,897.60,0.00,0.00,0.00,0.00,0.00),('5','101','917','206165',4005449,'2709','240',1453844.30,1456176.67,2332.37,384841.05,0.00,0.00,0.00,0.00,0.00),('5','101','917','206165',4005450,'2710','240',882866.24,882866.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','206165',4005451,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','206165',4005452,'2712','240',1050519.41,1052632.35,2112.94,348635.10,0.00,0.00,0.00,0.00,0.00),('5','101','620','206394',4009281,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','206394',4009282,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','206394',4009283,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','206394',4009284,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','206394',4009285,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','206394',4009286,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','206394',4009287,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','206394',4009288,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','206394',4009289,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','206394',4009290,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','206394',4009291,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','206394',4009292,'2705','240',655908.23,658955.66,3047.43,502825.95,0.00,0.00,0.00,0.00,0.00),('5','101','916','206394',4009293,'2706','240',840475.70,843084.65,2608.95,430476.75,0.00,0.00,0.00,0.00,0.00),('5','101','916','206394',4009294,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','206394',4009295,'2708','240',1397400.74,1398180.91,780.17,128728.05,0.00,0.00,0.00,0.00,0.00),('5','101','917','206394',4009296,'2709','240',1456176.67,1456255.04,78.37,12931.05,0.00,0.00,0.00,0.00,0.00),('5','101','917','206394',4009297,'2710','240',882866.24,882879.14,12.90,2128.50,0.00,0.00,0.00,0.00,0.00),('5','101','917','206394',4009298,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','206394',4009299,'2712','240',1052632.35,1052796.28,163.93,27048.45,0.00,0.00,0.00,0.00,0.00),('5','101','620','206597',4012893,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','206597',4012894,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','206597',4012895,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','206597',4012896,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','206597',4012897,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','206597',4012898,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','206597',4012899,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','206597',4012900,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','206597',4012901,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','206597',4012902,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','206597',4012903,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','206597',4012904,'2705','240',658955.66,658955.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','206597',4012905,'2706','240',843084.65,843084.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','206597',4012906,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','206597',4012907,'2708','240',1398180.91,1398180.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','206597',4012908,'2709','240',1456255.04,1460828.45,4573.41,754612.65,0.00,0.00,0.00,0.00,0.00),('5','101','917','206597',4012909,'2710','240',882879.14,883906.30,1027.16,169481.40,0.00,0.00,0.00,0.00,0.00),('5','101','917','206597',4012910,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','206597',4012911,'2712','240',1052796.28,1056330.97,3534.69,583223.85,0.00,0.00,0.00,0.00,0.00),('5','101','620','206865',4017541,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','206865',4017542,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','206865',4017543,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','206865',4017544,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','206865',4017545,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','206865',4017546,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','206865',4017547,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','206865',4017548,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','206865',4017549,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','206865',4017550,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','206865',4017551,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','206865',4017552,'2705','240',658955.66,658955.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','206865',4017553,'2706','240',843084.65,843146.45,61.80,10197.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','206865',4017554,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','206865',4017555,'2708','240',1398180.91,1398265.40,84.49,13940.85,0.00,0.00,0.00,0.00,0.00),('5','101','917','206865',4017556,'2709','240',1460828.45,1465127.92,4299.47,709412.55,0.00,0.00,0.00,0.00,0.00),('5','101','917','206865',4017557,'2710','240',883906.30,883914.00,7.70,1270.50,0.00,0.00,0.00,0.00,0.00),('5','101','917','206865',4017558,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','206865',4017559,'2712','240',1056330.97,1060100.03,3769.06,621894.90,0.00,0.00,0.00,0.00,0.00),('5','101','620','207045',4020891,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','207045',4020892,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','207045',4020893,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','207045',4020894,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','207045',4020895,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','207045',4020896,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','207045',4020897,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','207045',4020898,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','207045',4020899,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','207045',4020900,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','207045',4020901,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','207045',4020902,'2705','240',658955.66,658955.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','207045',4020903,'2706','240',843146.45,843146.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','207045',4020904,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','207045',4020905,'2708','240',1398265.40,1400855.95,2590.55,427440.75,0.00,0.00,0.00,0.00,0.00),('5','101','917','207045',4020906,'2709','240',1465127.92,1468701.08,3573.16,589571.40,0.00,0.00,0.00,0.00,0.00),('5','101','917','207045',4020907,'2710','240',883914.00,883914.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','207045',4020908,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','207045',4020909,'2712','240',1060100.03,1062435.05,2335.02,385278.30,0.00,0.00,0.00,0.00,0.00),('5','101','620','207285',4025162,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','207285',4025163,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','207285',4025164,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','207285',4025165,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','207285',4025166,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','207285',4025167,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','207285',4025168,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','207285',4025169,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','207285',4025170,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','207285',4025171,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','207285',4025172,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','207285',4025173,'2705','240',658955.66,659622.40,666.74,110012.10,0.00,0.00,0.00,0.00,0.00),('5','101','916','207285',4025174,'2706','240',843146.45,843146.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','207285',4025175,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','207285',4025176,'2708','240',1400855.95,1403360.44,2504.49,413240.85,0.00,0.00,0.00,0.00,0.00),('5','101','917','207285',4025177,'2709','240',1468701.08,1471542.19,2841.11,468783.15,0.00,0.00,0.00,0.00,0.00),('5','101','917','207285',4025178,'2710','240',883914.00,883914.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','207285',4025179,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','207285',4025180,'2712','240',1062435.05,1064538.73,2103.68,347107.20,0.00,0.00,0.00,0.00,0.00),('5','101','620','207530',4029662,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','207530',4029663,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','207530',4029664,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','207530',4029665,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','207530',4029666,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','207530',4029667,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','207530',4029668,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','207530',4029669,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','207530',4029670,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','207530',4029671,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','207530',4029672,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','207530',4029673,'2705','240',659622.40,662283.39,2660.99,439063.35,0.00,0.00,0.00,0.00,0.00),('5','101','916','207530',4029674,'2706','240',843146.45,843390.10,243.65,40202.25,0.00,0.00,0.00,0.00,0.00),('5','101','916','207530',4029675,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','207530',4029676,'2708','240',1403360.44,1403360.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','207530',4029677,'2709','240',1471542.19,1474129.06,2586.87,426833.55,0.00,0.00,0.00,0.00,0.00),('5','101','917','207530',4029678,'2710','240',883914.00,883914.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','207530',4029679,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','207530',4029680,'2712','240',1064538.73,1066546.86,2008.13,331341.45,0.00,0.00,0.00,0.00,0.00),('5','101','620','207746',4033226,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','207746',4033227,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','207746',4033228,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','207746',4033229,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','207746',4033230,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','207746',4033231,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','207746',4033232,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','207746',4033233,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','207746',4033234,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','207746',4033235,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','207746',4033236,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','207746',4033237,'2705','240',662283.39,664904.54,2621.15,432489.75,0.00,0.00,0.00,0.00,0.00),('5','101','916','207746',4033238,'2706','240',843390.10,844023.87,633.77,104572.05,0.00,0.00,0.00,0.00,0.00),('5','101','916','207746',4033239,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','207746',4033240,'2708','240',1403360.44,1404924.30,1563.86,258036.90,0.00,0.00,0.00,0.00,0.00),('5','101','917','207746',4033241,'2709','240',1474129.06,1476657.85,2528.79,417250.35,0.00,0.00,0.00,0.00,0.00),('5','101','917','207746',4033242,'2710','240',883914.00,883914.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','207746',4033243,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','207746',4033244,'2712','240',1066546.86,1068238.02,1691.16,279041.40,0.00,0.00,0.00,0.00,0.00),('5','101','620','207922',4036248,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','207922',4036249,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','207922',4036250,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','207922',4036251,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','207922',4036252,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','207922',4036253,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','207922',4036254,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','207922',4036255,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','207922',4036256,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','207922',4036257,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','207922',4036258,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','207922',4036259,'2705','240',664904.54,666388.88,1484.34,244916.10,0.00,0.00,0.00,0.00,0.00),('5','101','916','207922',4036260,'2706','240',844023.87,844023.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','207922',4036261,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','207922',4036262,'2708','240',1404924.30,1407633.47,2709.17,447013.05,0.00,0.00,0.00,0.00,0.00),('5','101','917','207922',4036263,'2709','240',1476657.85,1479163.10,2505.25,413366.25,0.00,0.00,0.00,0.00,0.00),('5','101','917','207922',4036264,'2710','240',883914.00,883914.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','207922',4036265,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','207922',4036266,'2712','240',1068238.02,1070121.50,1883.48,310774.20,0.00,0.00,0.00,0.00,0.00),('5','101','620','208210',4041428,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','208210',4041429,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','208210',4041430,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','208210',4041431,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','208210',4041432,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','208210',4041433,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','208210',4041434,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','208210',4041435,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','208210',4041436,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','208210',4041437,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','208210',4041438,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','208210',4041439,'2705','240',666388.88,668164.06,1775.18,292904.70,0.00,0.00,0.00,0.00,0.00),('5','101','916','208210',4041440,'2706','240',844023.87,844506.60,482.73,79650.45,0.00,0.00,0.00,0.00,0.00),('5','101','916','208210',4041441,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','208210',4041442,'2708','240',1407633.47,1410343.10,2709.63,447088.95,0.00,0.00,0.00,0.00,0.00),('5','101','917','208210',4041443,'2709','240',1479163.10,1481444.71,2281.61,376465.65,0.00,0.00,0.00,0.00,0.00),('5','101','917','208210',4041444,'2710','240',883914.00,883914.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','208210',4041445,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','208210',4041446,'2712','240',1070121.50,1072232.67,2111.17,348343.05,0.00,0.00,0.00,0.00,0.00),('5','101','620','208338',4043689,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','208338',4043690,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','208338',4043691,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','208338',4043692,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','208338',4043693,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','208338',4043694,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','208338',4043695,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','208338',4043696,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','208338',4043697,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','208338',4043698,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','208338',4043699,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','208338',4043700,'2705','240',668164.06,670787.67,2623.61,432895.65,0.00,0.00,0.00,0.00,0.00),('5','101','916','208338',4043701,'2706','240',844506.60,845161.60,655.00,108075.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','208338',4043702,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','208338',4043703,'2708','240',1410343.10,1412234.51,1891.41,312082.65,0.00,0.00,0.00,0.00,0.00),('5','101','917','208338',4043704,'2709','240',1481444.71,1483438.60,1993.89,328991.85,0.00,0.00,0.00,0.00,0.00),('5','101','917','208338',4043705,'2710','240',883914.00,883914.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','208338',4043706,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','208338',4043707,'2712','240',1072232.67,1073793.57,1560.90,257548.50,0.00,0.00,0.00,0.00,0.00),('5','101','620','208584',4047885,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','208584',4047886,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','208584',4047887,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','208584',4047888,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','208584',4047889,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','208584',4047890,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','208584',4047891,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','208584',4047892,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','208584',4047893,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','208584',4047894,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','208584',4047895,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','208584',4047896,'2705','240',670787.67,673211.23,2423.56,399887.40,0.00,0.00,0.00,0.00,0.00),('5','101','916','208584',4047897,'2706','240',845161.60,845351.11,189.51,31269.15,0.00,0.00,0.00,0.00,0.00),('5','101','916','208584',4047898,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','208584',4047899,'2708','240',1412234.51,1413609.54,1375.03,226879.95,0.00,0.00,0.00,0.00,0.00),('5','101','917','208584',4047900,'2709','240',1483438.60,1485506.24,2067.64,341160.60,0.00,0.00,0.00,0.00,0.00),('5','101','917','208584',4047901,'2710','240',883914.00,883914.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','208584',4047902,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','208584',4047903,'2712','240',1073793.57,1075333.60,1540.03,254104.95,0.00,0.00,0.00,0.00,0.00),('5','101','620','208771',4051192,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','208771',4051193,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','208771',4051194,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','208771',4051195,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','208771',4051196,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','208771',4051197,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','208771',4051198,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','208771',4051199,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','208771',4051200,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','208771',4051201,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','208771',4051202,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','208771',4051203,'2705','240',673211.23,675843.30,2632.07,434291.55,0.00,0.00,0.00,0.00,0.00),('5','101','916','208771',4051204,'2706','240',845351.11,846200.90,849.79,140215.35,0.00,0.00,0.00,0.00,0.00),('5','101','916','208771',4051205,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','208771',4051206,'2708','240',1413609.54,1415738.68,2129.14,351308.10,0.00,0.00,0.00,0.00,0.00),('5','101','917','208771',4051207,'2709','240',1485506.24,1487200.66,1694.42,279579.30,0.00,0.00,0.00,0.00,0.00),('5','101','917','208771',4051208,'2710','240',883914.00,883914.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','208771',4051209,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','208771',4051210,'2712','240',1075333.60,1076630.46,1296.86,213981.90,0.00,0.00,0.00,0.00,0.00),('5','101','620','209000',4055121,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','209000',4055122,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','209000',4055123,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','209000',4055124,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','209000',4055125,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','209000',4055126,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','209000',4055127,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','209000',4055128,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','209000',4055129,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','209000',4055130,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','209000',4055131,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','209000',4055132,'2705','240',675843.30,678601.06,2757.76,455030.40,0.00,0.00,0.00,0.00,0.00),('5','101','916','209000',4055133,'2706','240',846200.90,846200.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','209000',4055134,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','209000',4055135,'2708','240',1415738.68,1417026.80,1288.12,212539.80,0.00,0.00,0.00,0.00,0.00),('5','101','917','209000',4055136,'2709','240',1487200.66,1489881.65,2680.99,442363.35,0.00,0.00,0.00,0.00,0.00),('5','101','917','209000',4055137,'2710','240',883914.00,883914.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','209000',4055138,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','209000',4055139,'2712','240',1076630.46,1078593.32,1962.86,323871.90,0.00,0.00,0.00,0.00,0.00),('5','101','620','209265',4059741,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','209265',4059742,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','209265',4059743,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','209265',4059744,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','209265',4059745,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','209265',4059746,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','209265',4059747,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','209265',4059748,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','209265',4059749,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','209265',4059750,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','209265',4059751,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','209265',4059752,'2705','240',678601.06,680537.11,1936.05,319448.25,0.00,0.00,0.00,0.00,0.00),('5','101','916','209265',4059753,'2706','240',846200.90,846514.59,313.69,51758.85,0.00,0.00,0.00,0.00,0.00),('5','101','916','209265',4059754,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','209265',4059755,'2708','240',1417026.80,1417026.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','209265',4059756,'2709','240',1489881.65,1492208.60,2326.95,383946.75,0.00,0.00,0.00,0.00,0.00),('5','101','917','209265',4059757,'2710','240',883914.00,884161.84,247.84,40893.60,0.00,0.00,0.00,0.00,0.00),('5','101','917','209265',4059758,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','209265',4059759,'2712','240',1078593.32,1080745.29,2151.97,355075.05,0.00,0.00,0.00,0.00,0.00),('5','101','620','209482',4063639,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','209482',4063640,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','209482',4063641,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','209482',4063642,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','209482',4063643,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','209482',4063644,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','209482',4063645,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','209482',4063646,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','209482',4063647,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','209482',4063648,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','209482',4063649,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','209482',4063650,'2705','240',680537.11,680537.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','209482',4063651,'2706','240',846514.59,846514.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','209482',4063652,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','209482',4063653,'2708','240',1417026.80,1417026.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','209482',4063654,'2709','240',1492208.60,1495540.60,3332.00,549780.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','209482',4063655,'2710','240',884161.84,886711.35,2549.51,420669.15,0.00,0.00,0.00,0.00,0.00),('5','101','917','209482',4063656,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','209482',4063657,'2712','240',1080745.29,1083547.65,2802.36,462389.40,0.00,0.00,0.00,0.00,0.00),('5','101','620','209690',4067278,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','209690',4067279,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','209690',4067280,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','209690',4067281,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','209690',4067282,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','209690',4067283,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','209690',4067284,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','209690',4067285,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','209690',4067286,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','209690',4067287,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','209690',4067288,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','209690',4067289,'2705','240',680537.11,680537.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','209690',4067290,'2706','240',846514.59,846514.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','209690',4067291,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','209690',4067292,'2708','240',1417026.80,1417026.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','209690',4067293,'2709','240',1495540.60,1499083.75,3543.15,584619.75,0.00,0.00,0.00,0.00,0.00),('5','101','917','209690',4067294,'2710','240',886711.35,888874.27,2162.92,356881.80,0.00,0.00,0.00,0.00,0.00),('5','101','917','209690',4067295,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','209690',4067296,'2712','240',1083547.65,1086228.16,2680.51,442284.15,0.00,0.00,0.00,0.00,0.00),('5','101','620','209908',4071179,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','209908',4071180,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','209908',4071181,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','209908',4071182,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','209908',4071183,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','209908',4071184,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','209908',4071185,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','209908',4071186,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','209908',4071187,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','209908',4071188,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','209908',4071189,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','209908',4071190,'2705','240',680537.11,680537.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','209908',4071191,'2706','240',846514.59,846514.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','209908',4071192,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','209908',4071193,'2708','240',1417026.80,1417026.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','209908',4071194,'2709','240',1499083.75,1502298.96,3215.21,530509.65,0.00,0.00,0.00,0.00,0.00),('5','101','917','209908',4071195,'2710','240',888874.27,891080.51,2206.24,364029.60,0.00,0.00,0.00,0.00,0.00),('5','101','917','209908',4071196,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','209908',4071197,'2712','240',1086228.16,1089016.33,2788.17,460048.05,0.00,0.00,0.00,0.00,0.00),('5','101','620','210163',4075658,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','210163',4075659,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','210163',4075660,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','210163',4075661,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','210163',4075662,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','210163',4075663,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','210163',4075664,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','210163',4075665,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','210163',4075666,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','210163',4075667,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','210163',4075668,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','210163',4075669,'2705','240',680537.11,681575.93,1038.82,171405.30,0.00,0.00,0.00,0.00,0.00),('5','101','916','210163',4075670,'2706','240',846514.59,847047.01,532.42,87849.30,0.00,0.00,0.00,0.00,0.00),('5','101','916','210163',4075671,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','210163',4075672,'2708','240',1417026.80,1417026.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','210163',4075673,'2709','240',1502298.96,1505357.41,3058.45,504644.25,0.00,0.00,0.00,0.00,0.00),('5','101','917','210163',4075674,'2710','240',891080.51,892298.16,1217.65,200912.25,0.00,0.00,0.00,0.00,0.00),('5','101','917','210163',4075675,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','210163',4075676,'2712','240',1089016.33,1090963.96,1947.63,321358.95,0.00,0.00,0.00,0.00,0.00),('5','101','620','210362',4079175,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','210362',4079176,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','210362',4079177,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','210362',4079178,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','210362',4079179,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','210362',4079180,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','210362',4079181,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','210362',4079182,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','210362',4079183,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','210362',4079184,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','210362',4079185,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','210362',4079186,'2705','240',681575.93,684787.78,3211.85,529955.25,0.00,0.00,0.00,0.00,0.00),('5','101','916','210362',4079187,'2706','240',847047.01,847047.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','210362',4079188,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','210362',4079189,'2708','240',1417026.80,1417026.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','210362',4079190,'2709','240',1505357.41,1506880.42,1523.01,251296.65,0.00,0.00,0.00,0.00,0.00),('5','101','917','210362',4079191,'2710','240',892298.16,894352.15,2053.99,338908.35,0.00,0.00,0.00,0.00,0.00),('5','101','917','210362',4079192,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','210362',4079193,'2712','240',1090963.96,1093387.36,2423.40,399861.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','210535',4082393,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','210535',4082394,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','210535',4082395,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','210535',4082396,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','210535',4082397,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','210535',4082398,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','210535',4082399,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','210535',4082400,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','210535',4082401,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','210535',4082402,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','210535',4082403,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','210535',4082404,'2705','240',684787.78,688306.66,3518.88,580615.20,0.00,0.00,0.00,0.00,0.00),('5','101','916','210535',4082405,'2706','240',847047.01,850275.28,3228.27,532664.55,0.00,0.00,0.00,0.00,0.00),('5','101','916','210535',4082406,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','210535',4082407,'2708','240',1417026.80,1419033.76,2006.96,331148.40,0.00,0.00,0.00,0.00,0.00),('5','101','917','210535',4082408,'2709','240',1506880.42,1506974.47,94.05,15518.25,0.00,0.00,0.00,0.00,0.00),('5','101','917','210535',4082409,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','210535',4082410,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','210535',4082411,'2712','240',1093387.36,1093486.12,98.76,16295.40,0.00,0.00,0.00,0.00,0.00),('5','101','620','210813',4087318,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','210813',4087319,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','210813',4087320,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','210813',4087321,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','210813',4087322,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','210813',4087323,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','210813',4087324,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','210813',4087325,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','210813',4087326,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','210813',4087327,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','210813',4087328,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','210813',4087329,'2705','240',688306.66,691500.04,3193.38,526907.70,0.00,0.00,0.00,0.00,0.00),('5','101','916','210813',4087330,'2706','240',850275.28,853416.40,3141.12,518284.80,0.00,0.00,0.00,0.00,0.00),('5','101','916','210813',4087331,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','210813',4087332,'2708','240',1419033.76,1421520.00,2486.24,410229.60,0.00,0.00,0.00,0.00,0.00),('5','101','917','210813',4087333,'2709','240',1506974.47,1506974.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','210813',4087334,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','210813',4087335,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','210813',4087336,'2712','240',1093486.12,1093486.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','210967',4089847,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','210967',4089848,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','210967',4089849,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','210967',4089850,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','210967',4089851,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','210967',4089852,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','210967',4089853,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','210967',4089854,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','210967',4089855,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','210967',4089856,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','210967',4089857,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','210967',4089858,'2705','240',691500.04,694301.74,2801.70,462280.50,0.00,0.00,0.00,0.00,0.00),('5','101','916','210967',4089859,'2706','240',853416.40,853416.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','210967',4089860,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','210967',4089861,'2708','240',1421520.00,1423963.12,2443.12,403114.80,0.00,0.00,0.00,0.00,0.00),('5','101','917','210967',4089862,'2709','240',1506974.47,1510655.19,3680.72,607318.80,0.00,0.00,0.00,0.00,0.00),('5','101','917','210967',4089863,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','210967',4089864,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','210967',4089865,'2712','240',1093486.12,1093486.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','211179',4093683,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','211179',4093684,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','211179',4093685,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','211179',4093686,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','211179',4093687,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','211179',4093688,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','211179',4093689,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','211179',4093690,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','211179',4093691,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','211179',4093692,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','211179',4093693,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','211179',4093694,'2705','240',694301.74,697060.88,2759.14,455258.10,0.00,0.00,0.00,0.00,0.00),('5','101','916','211179',4093695,'2706','240',853416.40,853416.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','211179',4093696,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','211179',4093697,'2708','240',1423963.12,1427138.63,3175.51,523959.15,0.00,0.00,0.00,0.00,0.00),('5','101','917','211179',4093698,'2709','240',1510655.19,1514069.33,3414.14,563333.10,0.00,0.00,0.00,0.00,0.00),('5','101','917','211179',4093699,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','211179',4093700,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','211179',4093701,'2712','240',1093486.12,1093486.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','211378',4097326,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','211378',4097327,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','211378',4097328,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','211378',4097329,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','211378',4097330,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','211378',4097331,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','211378',4097332,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','211378',4097333,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','211378',4097334,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','211378',4097335,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','211378',4097336,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','211378',4097337,'2705','240',697060.88,700667.77,3606.89,595136.85,0.00,0.00,0.00,0.00,0.00),('5','101','916','211378',4097338,'2706','240',853416.40,853430.74,14.34,2366.10,0.00,0.00,0.00,0.00,0.00),('5','101','916','211378',4097339,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','211378',4097340,'2708','240',1427138.63,1428656.89,1518.26,250512.90,0.00,0.00,0.00,0.00,0.00),('5','101','917','211378',4097341,'2709','240',1514069.33,1517196.83,3127.50,516037.50,0.00,0.00,0.00,0.00,0.00),('5','101','917','211378',4097342,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','211378',4097343,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','211378',4097344,'2712','240',1093486.12,1094342.65,856.53,141327.45,0.00,0.00,0.00,0.00,0.00),('5','101','620','211620',4101470,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','211620',4101471,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','211620',4101472,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','211620',4101473,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','211620',4101474,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','211620',4101475,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','211620',4101476,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','211620',4101477,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','211620',4101478,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','211620',4101479,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','211620',4101480,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','211620',4101481,'2705','240',700667.77,704564.33,3896.56,642932.40,0.00,0.00,0.00,0.00,0.00),('5','101','916','211620',4101482,'2706','240',853430.74,853430.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','211620',4101483,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','211620',4101484,'2708','240',1428656.89,1428656.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','211620',4101485,'2709','240',1517196.83,1519282.86,2086.03,344194.95,0.00,0.00,0.00,0.00,0.00),('5','101','917','211620',4101486,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','211620',4101487,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','211620',4101488,'2712','240',1094342.65,1095457.91,1115.26,184017.90,0.00,0.00,0.00,0.00,0.00),('5','101','620','211969',4107615,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','211969',4107616,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','211969',4107617,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','211969',4107618,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','211969',4107619,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','211969',4107620,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','211969',4107621,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','211969',4107622,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','211969',4107623,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','211969',4107624,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','211969',4107625,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','211969',4107626,'2705','240',704564.33,705760.97,1196.64,197445.60,0.00,0.00,0.00,0.00,0.00),('5','101','916','211969',4107627,'2706','240',853430.74,853430.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','211969',4107628,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','211969',4107629,'2708','240',1428656.89,1428656.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','211969',4107630,'2709','240',1519282.86,1524674.77,5391.91,889665.15,0.00,0.00,0.00,0.00,0.00),('5','101','917','211969',4107631,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','211969',4107632,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','211969',4107633,'2712','240',1095457.91,1098501.65,3043.74,502217.10,0.00,0.00,0.00,0.00,0.00),('5','101','620','212000',4107989,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','212000',4107990,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','212000',4107991,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','212000',4107992,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','212000',4107993,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','212000',4107994,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','212000',4107995,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','212000',4107996,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','212000',4107997,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','212000',4107998,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','212000',4107999,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','212000',4108000,'2705','240',705760.97,705760.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','212000',4108001,'2706','240',853430.74,853430.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','212000',4108002,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','212000',4108003,'2708','240',1428656.89,1428811.43,154.54,25499.10,0.00,0.00,0.00,0.00,0.00),('5','101','917','212000',4108004,'2709','240',1524674.77,1527262.69,2587.92,427006.80,0.00,0.00,0.00,0.00,0.00),('5','101','917','212000',4108005,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','212000',4108006,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','212000',4108007,'2712','240',1098501.65,1101174.89,2673.24,441084.60,0.00,0.00,0.00,0.00,0.00),('5','101','620','212225',4112078,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','212225',4112079,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','212225',4112080,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','212225',4112081,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','212225',4112082,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','212225',4112083,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','212225',4112084,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','212225',4112085,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','212225',4112086,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','212225',4112087,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','212225',4112088,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','212225',4112089,'2705','240',705760.97,705760.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','212225',4112090,'2706','240',853430.74,853430.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','212225',4112091,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','212225',4112092,'2708','240',1428811.43,1430799.86,1988.43,328090.95,0.00,0.00,0.00,0.00,0.00),('5','101','917','212225',4112093,'2709','240',1527262.69,1531549.52,4286.83,707326.95,0.00,0.00,0.00,0.00,0.00),('5','101','917','212225',4112094,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','212225',4112095,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','212225',4112096,'2712','240',1101174.89,1104416.15,3241.26,534807.90,0.00,0.00,0.00,0.00,0.00),('5','101','620','212474',4116512,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','212474',4116513,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','212474',4116514,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','212474',4116515,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','212474',4116516,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','212474',4116517,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','212474',4116518,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','212474',4116519,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','212474',4116520,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','212474',4116521,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','212474',4116522,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','212474',4116523,'2705','240',705760.97,705760.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','212474',4116524,'2706','240',853430.74,853430.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','212474',4116525,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','212474',4116526,'2708','240',1430799.86,1434305.25,3505.39,578389.35,0.00,0.00,0.00,0.00,0.00),('5','101','917','212474',4116527,'2709','240',1531549.52,1534798.93,3249.41,536152.65,0.00,0.00,0.00,0.00,0.00),('5','101','917','212474',4116528,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','212474',4116529,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','212474',4116530,'2712','240',1104416.15,1106135.86,1719.71,283752.15,0.00,0.00,0.00,0.00,0.00),('5','101','620','212679',4120210,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','212679',4120211,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','212679',4120212,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','212679',4120213,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','212679',4120214,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','212679',4120215,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','212679',4120216,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','212679',4120217,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','212679',4120218,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','212679',4120219,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','212679',4120220,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','212679',4120221,'2705','240',705760.97,705760.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','212679',4120222,'2706','240',853430.74,853430.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','212679',4120223,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','212679',4120224,'2708','240',1434305.25,1436865.82,2560.57,422494.05,0.00,0.00,0.00,0.00,0.00),('5','101','917','212679',4120225,'2709','240',1534798.93,1538305.89,3506.96,578648.40,0.00,0.00,0.00,0.00,0.00),('5','101','917','212679',4120226,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','212679',4120227,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','212679',4120228,'2712','240',1106135.86,1108700.30,2564.44,423132.60,0.00,0.00,0.00,0.00,0.00),('5','101','620','212882',4123770,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','212882',4123771,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','212882',4123772,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','212882',4123773,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','212882',4123774,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','212882',4123775,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','212882',4123776,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','212882',4123777,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','212882',4123778,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','212882',4123779,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','212882',4123780,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','212882',4123781,'2705','240',705760.97,705760.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','212882',4123782,'2706','240',853430.74,853430.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','212882',4123783,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','212882',4123784,'2708','240',1436865.82,1438547.40,1681.58,277460.70,0.00,0.00,0.00,0.00,0.00),('5','101','917','212882',4123785,'2709','240',1538305.89,1540214.53,1908.64,314925.60,0.00,0.00,0.00,0.00,0.00),('5','101','917','212882',4123786,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','212882',4123787,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','212882',4123788,'2712','240',1108700.30,1110627.02,1926.72,317908.80,0.00,0.00,0.00,0.00,0.00),('5','101','620','213156',4128475,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','213156',4128476,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','213156',4128477,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','213156',4128478,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','213156',4128479,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','213156',4128480,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','213156',4128481,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','213156',4128482,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','213156',4128483,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','213156',4128484,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','213156',4128485,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','213156',4128486,'2705','240',705760.97,705760.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','213156',4128487,'2706','240',853430.74,853430.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','213156',4128488,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','213156',4128489,'2708','240',1438547.40,1441517.33,2969.93,490038.45,0.00,0.00,0.00,0.00,0.00),('5','101','917','213156',4128490,'2709','240',1540214.53,1543227.86,3013.33,497199.45,0.00,0.00,0.00,0.00,0.00),('5','101','917','213156',4128491,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','213156',4128492,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','213156',4128493,'2712','240',1110627.02,1112981.94,2354.92,388561.80,0.00,0.00,0.00,0.00,0.00),('5','101','620','213410',4132617,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','213410',4132618,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','213410',4132619,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','213410',4132620,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','213410',4132621,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','213410',4132622,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','213410',4132623,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','213410',4132624,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','213410',4132625,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','213410',4132626,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','213410',4132627,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','213410',4132628,'2705','240',705760.97,705760.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','213410',4132629,'2706','240',853430.74,853430.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','213410',4132630,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','213410',4132631,'2708','240',1441517.33,1443569.14,2051.81,338548.65,0.00,0.00,0.00,0.00,0.00),('5','101','917','213410',4132632,'2709','240',1543227.86,1545862.88,2635.02,434778.30,0.00,0.00,0.00,0.00,0.00),('5','101','917','213410',4132633,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','213410',4132634,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','213410',4132635,'2712','240',1112981.94,1114752.23,1770.29,292097.85,0.00,0.00,0.00,0.00,0.00),('5','101','620','213644',4136583,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','213644',4136584,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','213644',4136585,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','213644',4136586,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','213644',4136587,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','213644',4136588,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','213644',4136589,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','213644',4136590,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','213644',4136591,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','213644',4136592,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','213644',4136593,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','213644',4136594,'2705','240',705760.97,707095.99,1335.02,220278.30,0.00,0.00,0.00,0.00,0.00),('5','101','916','213644',4136595,'2706','240',853430.74,853443.77,13.03,2149.95,0.00,0.00,0.00,0.00,0.00),('5','101','916','213644',4136596,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','213644',4136597,'2708','240',1443569.14,1444828.95,1259.81,207868.65,0.00,0.00,0.00,0.00,0.00),('5','101','917','213644',4136598,'2709','240',1545862.88,1549132.83,3269.95,539541.75,0.00,0.00,0.00,0.00,0.00),('5','101','917','213644',4136599,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','213644',4136600,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','213644',4136601,'2712','240',1114752.23,1117388.66,2636.43,435010.95,0.00,0.00,0.00,0.00,0.00),('5','101','620','213924',4141061,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','213924',4141062,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','213924',4141063,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','213924',4141064,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','213924',4141065,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','213924',4141066,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','213924',4141067,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','213924',4141068,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','213924',4141069,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','213924',4141070,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','213924',4141071,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','213924',4141072,'2705','240',707095.99,708648.19,1552.20,256113.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','213924',4141073,'2706','240',853443.77,853500.34,56.57,9334.05,0.00,0.00,0.00,0.00,0.00),('5','101','916','213924',4141074,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','213924',4141075,'2708','240',1444828.95,1444828.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','213924',4141076,'2709','240',1549132.83,1552273.53,3140.70,518215.50,0.00,0.00,0.00,0.00,0.00),('5','101','917','213924',4141077,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','213924',4141078,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','213924',4141079,'2712','240',1117388.66,1119871.24,2482.58,409625.70,0.00,0.00,0.00,0.00,0.00),('5','101','620','214154',4145042,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','214154',4145043,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','214154',4145044,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','214154',4145045,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','214154',4145046,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','214154',4145047,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','214154',4145048,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','214154',4145049,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','214154',4145050,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','214154',4145051,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','214154',4145052,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','214154',4145053,'2705','240',708648.19,711216.49,2568.30,423769.50,0.00,0.00,0.00,0.00,0.00),('5','101','916','214154',4145054,'2706','240',853500.34,853500.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','214154',4145055,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','214154',4145056,'2708','240',1444828.95,1444828.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','214154',4145057,'2709','240',1552273.53,1554832.39,2558.86,422211.90,0.00,0.00,0.00,0.00,0.00),('5','101','917','214154',4145058,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','214154',4145059,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','214154',4145060,'2712','240',1119871.24,1122012.53,2141.29,353312.85,0.00,0.00,0.00,0.00,0.00),('5','101','620','214358',4148576,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','214358',4148577,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','214358',4148578,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','214358',4148579,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','214358',4148580,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','214358',4148581,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','214358',4148582,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','214358',4148583,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','214358',4148584,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','214358',4148585,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','214358',4148586,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','214358',4148587,'2705','240',711216.49,714518.34,3301.85,544805.25,0.00,0.00,0.00,0.00,0.00),('5','101','916','214358',4148588,'2706','240',853500.34,854234.99,734.65,121217.25,0.00,0.00,0.00,0.00,0.00),('5','101','916','214358',4148589,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','214358',4148590,'2708','240',1444828.95,1444828.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','214358',4148591,'2709','240',1554832.39,1557540.73,2708.34,446876.10,0.00,0.00,0.00,0.00,0.00),('5','101','917','214358',4148592,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','214358',4148593,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','214358',4148594,'2712','240',1122012.53,1123538.20,1525.67,251735.55,0.00,0.00,0.00,0.00,0.00),('5','101','620','214538',4151648,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','214538',4151649,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','214538',4151650,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','214538',4151651,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','214538',4151652,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','214538',4151653,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','214538',4151654,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','214538',4151655,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','214538',4151656,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','214538',4151657,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','214538',4151658,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','214538',4151659,'2705','240',714518.34,716590.02,2071.68,341827.20,0.00,0.00,0.00,0.00,0.00),('5','101','916','214538',4151660,'2706','240',854234.99,854780.11,545.12,89944.80,0.00,0.00,0.00,0.00,0.00),('5','101','916','214538',4151661,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','214538',4151662,'2708','240',1444828.95,1444828.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','214538',4151663,'2709','240',1557540.73,1561108.23,3567.50,588637.50,0.00,0.00,0.00,0.00,0.00),('5','101','917','214538',4151664,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','214538',4151665,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','214538',4151666,'2712','240',1123538.20,1124721.96,1183.76,195320.40,0.00,0.00,0.00,0.00,0.00),('5','101','620','214805',4156245,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','214805',4156246,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','214805',4156247,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','214805',4156248,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','214805',4156249,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','214805',4156250,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','214805',4156251,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','214805',4156252,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','214805',4156253,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','214805',4156254,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','214805',4156255,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','214805',4156256,'2705','240',716590.02,716590.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','214805',4156257,'2706','240',854780.11,854780.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','214805',4156258,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','214805',4156259,'2708','240',1444828.95,1444828.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','214805',4156260,'2709','240',1561108.23,1564725.91,3617.68,596917.20,0.00,0.00,0.00,0.00,0.00),('5','101','917','214805',4156261,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','214805',4156262,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','214805',4156263,'2712','240',1124721.96,1128966.66,4244.70,700375.50,0.00,0.00,0.00,0.00,0.00),('5','101','620','215037',4160083,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','215037',4160084,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','215037',4160085,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','215037',4160086,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','215037',4160087,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','215037',4160088,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','215037',4160089,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','215037',4160090,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','215037',4160091,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','215037',4160092,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','215037',4160093,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','215037',4160094,'2705','240',716590.02,718763.78,2173.76,358670.40,0.00,0.00,0.00,0.00,0.00),('5','101','916','215037',4160095,'2706','240',854780.11,854780.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','215037',4160096,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','215037',4160097,'2708','240',1444828.95,1447620.38,2791.43,460585.95,0.00,0.00,0.00,0.00,0.00),('5','101','917','215037',4160098,'2709','240',1564725.91,1567111.66,2385.75,393648.75,0.00,0.00,0.00,0.00,0.00),('5','101','917','215037',4160099,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','215037',4160100,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','215037',4160101,'2712','240',1128966.66,1130060.62,1093.96,180503.40,0.00,0.00,0.00,0.00,0.00),('5','101','620','215247',4163755,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','215247',4163756,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','215247',4163757,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','215247',4163758,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','215247',4163759,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','215247',4163760,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','215247',4163761,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','215247',4163762,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','215247',4163763,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','215247',4163764,'1741','241',719187.69,719187.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','215247',4163765,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','215247',4163766,'2705','240',718763.78,721886.47,3122.69,515243.85,0.00,0.00,0.00,0.00,0.00),('5','101','916','215247',4163767,'2706','240',854780.11,854879.89,99.78,16463.70,0.00,0.00,0.00,0.00,0.00),('5','101','916','215247',4163768,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','215247',4163769,'2708','240',1447620.38,1449906.82,2286.44,377262.60,0.00,0.00,0.00,0.00,0.00),('5','101','917','215247',4163770,'2709','240',1567111.66,1569555.67,2444.01,403261.65,0.00,0.00,0.00,0.00,0.00),('5','101','917','215247',4163771,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','215247',4163772,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','215247',4163773,'2712','240',1130060.62,1130060.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','215468',4167341,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','215468',4167342,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','215468',4167343,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','215468',4167344,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','215468',4167345,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','215468',4167346,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','215468',4167347,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','215468',4167348,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','215468',4167349,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','215468',4167350,'1741','241',719187.69,719198.48,10.79,3129.10,0.00,0.00,0.00,0.00,0.00),('5','101','623','215468',4167351,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','215468',4167352,'2705','240',721886.47,724102.83,2216.36,365699.40,0.00,0.00,0.00,0.00,0.00),('5','101','916','215468',4167353,'2706','240',854879.89,854879.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','215468',4167354,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','215468',4167355,'2708','240',1449906.82,1452820.82,2914.00,480810.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','215468',4167356,'2709','240',1569555.67,1572850.68,3295.01,543676.65,0.00,0.00,0.00,0.00,0.00),('5','101','917','215468',4167357,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','215468',4167358,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','215468',4167359,'2712','240',1130060.62,1130060.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','215717',4171639,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','215717',4171640,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','215717',4171641,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','215717',4171642,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','215717',4171643,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','215717',4171644,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','215717',4171645,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','215717',4171646,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','215717',4171647,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','215717',4171648,'1741','241',719198.48,719597.78,399.30,115797.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','215717',4171649,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','215717',4171650,'2705','240',724102.83,727972.83,3870.00,638550.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','215717',4171651,'2706','240',854879.89,855588.35,708.46,116895.90,0.00,0.00,0.00,0.00,0.00),('5','101','916','215717',4171652,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','215717',4171653,'2708','240',1452820.82,1455843.35,3022.53,498717.45,0.00,0.00,0.00,0.00,0.00),('5','101','917','215717',4171654,'2709','240',1572850.68,1573138.63,287.95,47511.75,0.00,0.00,0.00,0.00,0.00),('5','101','917','215717',4171655,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','215717',4171656,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','215717',4171657,'2712','240',1130060.62,1130060.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','215956',4175804,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','215956',4175805,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','215956',4175806,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','215956',4175807,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','215956',4175808,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','215956',4175809,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','215956',4175810,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','215956',4175811,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','215956',4175812,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','215956',4175813,'1741','241',719597.78,719944.71,346.93,100609.70,0.00,0.00,0.00,0.00,0.00),('5','101','623','215956',4175814,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','215956',4175815,'2705','240',727972.83,732316.03,4343.20,716628.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','215956',4175816,'2706','240',855588.35,857164.28,1575.93,260028.45,0.00,0.00,0.00,0.00,0.00),('5','101','916','215956',4175817,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','215956',4175818,'2708','240',1455843.35,1458570.74,2727.39,450019.35,0.00,0.00,0.00,0.00,0.00),('5','101','917','215956',4175819,'2709','240',1573138.63,1573138.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','215956',4175820,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','215956',4175821,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','215956',4175822,'2712','240',1130060.62,1130060.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','216160',4179292,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','216160',4179293,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','216160',4179294,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','216160',4179295,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','216160',4179296,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','216160',4179297,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','216160',4179298,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','216160',4179299,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','216160',4179300,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','216160',4179301,'1741','241',719944.71,720400.61,455.90,132211.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','216160',4179302,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','216160',4179303,'2705','240',732316.03,735887.56,3571.53,589302.45,0.00,0.00,0.00,0.00,0.00),('5','101','916','216160',4179304,'2706','240',857164.28,858617.50,1453.22,239781.30,0.00,0.00,0.00,0.00,0.00),('5','101','916','216160',4179305,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','216160',4179306,'2708','240',1458570.74,1460994.70,2423.96,399953.40,0.00,0.00,0.00,0.00,0.00),('5','101','917','216160',4179307,'2709','240',1573138.63,1573138.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','216160',4179308,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','216160',4179309,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','216160',4179310,'2712','240',1130060.62,1130060.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','216325',4182281,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','216325',4182282,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','216325',4182283,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','216325',4182284,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','216325',4182285,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','216325',4182286,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','216325',4182287,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','216325',4182288,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','216325',4182289,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','216325',4182290,'1741','241',720400.61,720915.59,514.98,149344.20,0.00,0.00,0.00,0.00,0.00),('5','101','623','216325',4182291,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','216325',4182292,'2705','240',735887.56,738147.99,2260.43,372970.95,0.00,0.00,0.00,0.00,0.00),('5','101','916','216325',4182293,'2706','240',858617.50,860122.53,1505.03,248329.95,0.00,0.00,0.00,0.00,0.00),('5','101','916','216325',4182294,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','216325',4182295,'2708','240',1460994.70,1461505.20,510.50,84232.50,0.00,0.00,0.00,0.00,0.00),('5','101','917','216325',4182296,'2709','240',1573138.63,1573138.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','216325',4182297,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','216325',4182298,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','216325',4182299,'2712','240',1130060.62,1130060.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','216692',4188589,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','216692',4188590,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','216692',4188591,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','216692',4188592,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','216692',4188593,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','216692',4188594,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','216692',4188595,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','216692',4188596,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','216692',4188597,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','216692',4188598,'1741','241',720915.59,720915.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','216692',4188599,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','216692',4188600,'2705','240',738147.99,738147.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','216692',4188601,'2706','240',860122.53,860122.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','216692',4188602,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','216692',4188603,'2708','240',1461505.20,1461505.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','216692',4188604,'2709','240',1573138.63,1573138.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','216692',4188605,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','216692',4188606,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','216692',4188607,'2712','240',1130060.62,1130060.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','216696',4188672,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','216696',4188673,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','216696',4188674,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','216696',4188675,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','216696',4188676,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','216696',4188677,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','216696',4188678,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','216696',4188679,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','216696',4188680,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','216696',4188681,'1741','241',720915.59,721296.18,380.59,112274.05,0.00,0.00,0.00,0.00,0.00),('5','101','623','216696',4188682,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','216696',4188683,'2705','240',738147.99,740630.89,2482.90,409678.50,0.00,0.00,0.00,0.00,0.00),('5','101','916','216696',4188684,'2706','240',860122.53,861433.42,1310.89,216296.85,0.00,0.00,0.00,0.00,0.00),('5','101','916','216696',4188685,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','216696',4188686,'2708','240',1461505.20,1463856.89,2351.69,388028.85,0.00,0.00,0.00,0.00,0.00),('5','101','917','216696',4188687,'2709','240',1573138.63,1574620.80,1482.17,244558.05,0.00,0.00,0.00,0.00,0.00),('5','101','917','216696',4188688,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','216696',4188689,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','216696',4188690,'2712','240',1130060.62,1130060.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','216830',4191017,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','216830',4191018,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','216830',4191019,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','216830',4191020,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','216830',4191021,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','216830',4191022,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','216830',4191023,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','216830',4191024,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','216830',4191025,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','216830',4191026,'1741','241',721296.18,721549.85,253.67,74832.65,0.00,0.00,0.00,0.00,0.00),('5','101','623','216830',4191027,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','216830',4191028,'2705','240',740630.89,744146.14,3515.25,580016.25,0.00,0.00,0.00,0.00,0.00),('5','101','916','216830',4191029,'2706','240',861433.42,861433.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','216830',4191030,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','216830',4191031,'2708','240',1463856.89,1465204.06,1347.17,222283.05,0.00,0.00,0.00,0.00,0.00),('5','101','917','216830',4191032,'2709','240',1574620.80,1577412.72,2791.92,460666.80,0.00,0.00,0.00,0.00,0.00),('5','101','917','216830',4191033,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','216830',4191034,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','216830',4191035,'2712','240',1130060.62,1130060.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','217131',4196339,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','217131',4196340,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','217131',4196341,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','217131',4196342,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','217131',4196343,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','217131',4196344,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','217131',4196345,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','217131',4196346,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','217131',4196347,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','217131',4196348,'1741','241',721549.85,721946.42,396.57,116988.15,0.00,0.00,0.00,0.00,0.00),('5','101','623','217131',4196349,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','217131',4196350,'2705','240',744146.14,747710.55,3564.41,588127.65,0.00,0.00,0.00,0.00,0.00),('5','101','916','217131',4196351,'2706','240',861433.42,861433.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','217131',4196352,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','217131',4196353,'2708','240',1465204.06,1466618.39,1414.33,233364.45,0.00,0.00,0.00,0.00,0.00),('5','101','917','217131',4196354,'2709','240',1577412.72,1579847.56,2434.84,401748.60,0.00,0.00,0.00,0.00,0.00),('5','101','917','217131',4196355,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','217131',4196356,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','217131',4196357,'2712','240',1130060.62,1130314.70,254.08,41923.20,0.00,0.00,0.00,0.00,0.00),('5','101','620','217307',4199733,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','217307',4199734,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','217307',4199735,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','217307',4199736,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','217307',4199737,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','217307',4199738,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','217307',4199739,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','217307',4199740,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','217307',4199741,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','217307',4199742,'1741','241',721946.42,722344.39,397.97,117401.15,0.00,0.00,0.00,0.00,0.00),('5','101','623','217307',4199743,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','217307',4199744,'2705','240',747710.55,752140.53,4429.98,730946.70,0.00,0.00,0.00,0.00,0.00),('5','101','916','217307',4199745,'2706','240',861433.42,861433.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','217307',4199746,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','217307',4199747,'2708','240',1466618.39,1466618.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','217307',4199748,'2709','240',1579847.56,1579854.82,7.26,1197.90,0.00,0.00,0.00,0.00,0.00),('5','101','917','217307',4199749,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','217307',4199750,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','217307',4199751,'2712','240',1130314.70,1131393.35,1078.65,177977.25,0.00,0.00,0.00,0.00,0.00),('5','101','620','217656',4206008,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','217656',4206009,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','217656',4206010,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','217656',4206011,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','217656',4206012,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','217656',4206013,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','217656',4206014,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','217656',4206015,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','217656',4206016,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','217656',4206017,'1741','241',722344.39,722690.63,346.24,102140.80,0.00,0.00,0.00,0.00,0.00),('5','101','623','217656',4206018,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','217656',4206019,'2705','240',752140.53,755395.06,3254.53,536997.45,0.00,0.00,0.00,0.00,0.00),('5','101','916','217656',4206020,'2706','240',861433.42,861433.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','217656',4206021,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','217656',4206022,'2708','240',1466618.39,1472333.50,5715.11,942993.15,0.00,0.00,0.00,0.00,0.00),('5','101','917','217656',4206023,'2709','240',1579854.82,1579866.94,12.12,1999.80,0.00,0.00,0.00,0.00,0.00),('5','101','917','217656',4206024,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','217656',4206025,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','217656',4206026,'2712','240',1131393.35,1132439.46,1046.11,172608.15,0.00,0.00,0.00,0.00,0.00),('5','101','620','217764',4207587,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','217764',4207588,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','217764',4207589,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','217764',4207590,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','217764',4207591,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','217764',4207592,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','217764',4207593,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','217764',4207594,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','217764',4207595,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','217764',4207596,'1741','241',722690.63,723193.92,503.29,148470.55,0.00,0.00,0.00,0.00,0.00),('5','101','623','217764',4207597,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','217764',4207598,'2705','240',755395.06,758233.99,2838.93,468423.45,0.00,0.00,0.00,0.00,0.00),('5','101','916','217764',4207599,'2706','240',861433.42,861433.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','217764',4207600,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','217764',4207601,'2708','240',1472333.50,1474523.57,2190.07,361361.55,0.00,0.00,0.00,0.00,0.00),('5','101','917','217764',4207602,'2709','240',1579866.94,1582933.43,3066.49,505970.85,0.00,0.00,0.00,0.00,0.00),('5','101','917','217764',4207603,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','217764',4207604,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','217764',4207605,'2712','240',1132439.46,1132439.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','218004',4211978,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','218004',4211979,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','218004',4211980,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','218004',4211981,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','218004',4211982,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','218004',4211983,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','218004',4211984,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','218004',4211985,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','218004',4211986,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','218004',4211987,'1741','241',723193.92,723594.38,400.46,118135.70,0.00,0.00,0.00,0.00,0.00),('5','101','623','218004',4211988,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','218004',4211989,'2705','240',758233.99,761297.99,3064.00,505560.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','218004',4211990,'2706','240',861433.42,861433.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','218004',4211991,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','218004',4211992,'2708','240',1474523.57,1477159.57,2636.00,434940.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','218004',4211993,'2709','240',1582933.43,1586086.06,3152.63,520183.95,0.00,0.00,0.00,0.00,0.00),('5','101','917','218004',4211994,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','218004',4211995,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','218004',4211996,'2712','240',1132439.46,1132439.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','218272',4216608,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','218272',4216609,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','218272',4216610,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','218272',4216611,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','218272',4216612,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','218272',4216613,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','218272',4216614,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','218272',4216615,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','218272',4216616,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','218272',4216617,'1741','241',723594.38,724247.00,652.62,192522.90,0.00,0.00,0.00,0.00,0.00),('5','101','623','218272',4216618,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','218272',4216619,'2705','240',761297.99,764147.11,2849.12,470104.80,0.00,0.00,0.00,0.00,0.00),('5','101','916','218272',4216620,'2706','240',861433.42,861433.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','218272',4216621,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','218272',4216622,'2708','240',1477159.57,1479418.79,2259.22,372771.30,0.00,0.00,0.00,0.00,0.00),('5','101','917','218272',4216623,'2709','240',1586086.06,1588898.54,2812.48,464059.20,0.00,0.00,0.00,0.00,0.00),('5','101','917','218272',4216624,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','218272',4216625,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','218272',4216626,'2712','240',1132439.46,1132439.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','218468',4220007,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','218468',4220008,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','218468',4220009,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','218468',4220010,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','218468',4220011,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','218468',4220012,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','218468',4220013,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','218468',4220014,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','218468',4220015,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','218468',4220016,'1741','241',724247.00,724728.52,481.52,142048.40,0.00,0.00,0.00,0.00,0.00),('5','101','623','218468',4220017,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','218468',4220018,'2705','240',764147.11,766450.85,2303.74,380117.10,0.00,0.00,0.00,0.00,0.00),('5','101','916','218468',4220019,'2706','240',861433.42,861433.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','218468',4220020,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','218468',4220021,'2708','240',1479418.79,1481700.23,2281.44,376437.60,0.00,0.00,0.00,0.00,0.00),('5','101','917','218468',4220022,'2709','240',1588898.54,1591203.20,2304.66,380268.90,0.00,0.00,0.00,0.00,0.00),('5','101','917','218468',4220023,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','218468',4220024,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','218468',4220025,'2712','240',1132439.46,1133388.27,948.81,156553.65,0.00,0.00,0.00,0.00,0.00),('5','101','620','218786',4225711,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','218786',4225712,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','218786',4225713,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','218786',4225714,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','218786',4225715,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','218786',4225716,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','218786',4225717,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','218786',4225718,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','218786',4225719,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','218786',4225720,'1741','241',724728.52,725053.11,324.59,95754.05,0.00,0.00,0.00,0.00,0.00),('5','101','623','218786',4225721,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','218786',4225722,'2705','240',766450.85,768389.51,1938.66,319878.90,0.00,0.00,0.00,0.00,0.00),('5','101','916','218786',4225723,'2706','240',861433.42,862105.92,672.50,110962.50,0.00,0.00,0.00,0.00,0.00),('5','101','916','218786',4225724,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','218786',4225725,'2708','240',1481700.23,1481700.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','218786',4225726,'2709','240',1591203.20,1593954.50,2751.30,453964.50,0.00,0.00,0.00,0.00,0.00),('5','101','917','218786',4225727,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','218786',4225728,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','218786',4225729,'2712','240',1133388.27,1135712.58,2324.31,383511.15,0.00,0.00,0.00,0.00,0.00),('5','101','620','218934',4228295,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','218934',4228296,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','218934',4228297,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','218934',4228298,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','218934',4228299,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','218934',4228300,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','218934',4228301,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','218934',4228302,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','218934',4228303,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','218934',4228304,'1741','241',725053.11,725488.72,435.61,119792.75,0.00,0.00,0.00,0.00,0.00),('5','101','623','218934',4228305,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','218934',4228306,'2705','240',768389.51,768720.49,330.98,54611.70,0.00,0.00,0.00,0.00,0.00),('5','101','916','218934',4228307,'2706','240',862105.92,862105.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','218934',4228308,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','218934',4228309,'2708','240',1481700.23,1481700.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','218934',4228310,'2709','240',1593954.50,1597784.11,3829.61,631885.65,0.00,0.00,0.00,0.00,0.00),('5','101','917','218934',4228311,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','218934',4228312,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','218934',4228313,'2712','240',1135712.58,1139154.42,3441.84,567903.60,0.00,0.00,0.00,0.00,0.00),('5','101','620','219139',4231794,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','219139',4231795,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','219139',4231796,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','219139',4231797,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','219139',4231798,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','219139',4231799,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','219139',4231800,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','219139',4231801,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','219139',4231802,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','219139',4231803,'1741','241',725488.72,725961.19,472.47,139378.65,0.00,0.00,0.00,0.00,0.00),('5','101','623','219139',4231804,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','219139',4231805,'2705','240',768720.49,771692.20,2971.71,490332.15,0.00,0.00,0.00,0.00,0.00),('5','101','916','219139',4231806,'2706','240',862105.92,862105.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','219139',4231807,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','219139',4231808,'2708','240',1481700.23,1483641.66,1941.43,320335.95,0.00,0.00,0.00,0.00,0.00),('5','101','917','219139',4231809,'2709','240',1597784.11,1599569.67,1785.56,294617.40,0.00,0.00,0.00,0.00,0.00),('5','101','917','219139',4231810,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','219139',4231811,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','219139',4231812,'2712','240',1139154.42,1141024.27,1869.85,308525.25,0.00,0.00,0.00,0.00,0.00),('5','101','620','219458',4237381,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','219458',4237382,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','219458',4237383,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','219458',4237384,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','219458',4237385,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','219458',4237386,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','219458',4237387,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','219458',4237388,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','219458',4237389,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','219458',4237390,'1741','241',725961.19,726641.65,680.46,200735.70,0.00,0.00,0.00,0.00,0.00),('5','101','623','219458',4237391,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','219458',4237392,'2705','240',771692.20,774019.14,2326.94,383945.10,0.00,0.00,0.00,0.00,0.00),('5','101','916','219458',4237393,'2706','240',862105.92,862105.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','219458',4237394,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','219458',4237395,'2708','240',1483641.66,1484862.41,1220.75,201423.75,0.00,0.00,0.00,0.00,0.00),('5','101','917','219458',4237396,'2709','240',1599569.67,1600540.27,970.60,160149.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','219458',4237397,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','219458',4237398,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','219458',4237399,'2712','240',1141024.27,1144236.60,3212.33,530034.45,0.00,0.00,0.00,0.00,0.00),('5','101','620','219641',4240465,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','219641',4240466,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','219641',4240467,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','219641',4240468,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','219641',4240469,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','219641',4240470,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','219641',4240471,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','219641',4240472,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','219641',4240473,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','219641',4240474,'1741','241',726641.65,727081.61,439.96,129788.20,0.00,0.00,0.00,0.00,0.00),('5','101','623','219641',4240475,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','219641',4240476,'2705','240',774019.14,777309.52,3290.38,542912.70,0.00,0.00,0.00,0.00,0.00),('5','101','916','219641',4240477,'2706','240',862105.92,862105.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','219641',4240478,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','219641',4240479,'2708','240',1484862.41,1487120.79,2258.38,372632.70,0.00,0.00,0.00,0.00,0.00),('5','101','917','219641',4240480,'2709','240',1600540.27,1603733.32,3193.05,526853.25,0.00,0.00,0.00,0.00,0.00),('5','101','917','219641',4240481,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','219641',4240482,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','219641',4240483,'2712','240',1144236.60,1144236.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','219866',4244578,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','219866',4244579,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','219866',4244580,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','219866',4244581,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','219866',4244582,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','219866',4244583,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','219866',4244584,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','219866',4244585,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','219866',4244586,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','219866',4244587,'1741','241',727081.61,727474.54,392.93,115914.35,0.00,0.00,0.00,0.00,0.00),('5','101','623','219866',4244588,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','219866',4244589,'2705','240',777309.52,780917.92,3608.40,595386.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','219866',4244590,'2706','240',862105.92,862190.69,84.77,13987.05,0.00,0.00,0.00,0.00,0.00),('5','101','916','219866',4244591,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','219866',4244592,'2708','240',1487120.79,1489795.09,2674.30,441259.50,0.00,0.00,0.00,0.00,0.00),('5','101','917','219866',4244593,'2709','240',1603733.32,1603736.59,3.27,539.55,0.00,0.00,0.00,0.00,0.00),('5','101','917','219866',4244594,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','219866',4244595,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','219866',4244596,'2712','240',1144236.60,1144877.00,640.40,105666.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','220057',4248040,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','220057',4248041,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','220057',4248042,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','220057',4248043,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','220057',4248044,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','220057',4248045,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','220057',4248046,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','220057',4248047,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','220057',4248048,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','220057',4248049,'1741','241',727474.54,727895.19,420.65,124091.75,0.00,0.00,0.00,0.00,0.00),('5','101','623','220057',4248050,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','220057',4248051,'2705','240',780917.92,783209.70,2291.78,378143.70,0.00,0.00,0.00,0.00,0.00),('5','101','916','220057',4248052,'2706','240',862190.69,863477.79,1287.10,212371.50,0.00,0.00,0.00,0.00,0.00),('5','101','916','220057',4248053,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','220057',4248054,'2708','240',1489795.09,1492436.77,2641.68,435877.20,0.00,0.00,0.00,0.00,0.00),('5','101','917','220057',4248055,'2709','240',1603736.59,1603736.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','220057',4248056,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','220057',4248057,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','220057',4248058,'2712','240',1144877.00,1146972.06,2095.06,345684.90,0.00,0.00,0.00,0.00,0.00),('5','101','620','220331',4252870,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','220331',4252871,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','220331',4252872,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','220331',4252873,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','220331',4252874,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','220331',4252875,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','220331',4252876,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','220331',4252877,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','220331',4252878,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','220331',4252879,'1741','241',727895.19,728263.64,368.45,108692.75,0.00,0.00,0.00,0.00,0.00),('5','101','623','220331',4252880,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','220331',4252881,'2705','240',783209.70,783209.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','220331',4252882,'2706','240',863477.79,863477.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','220331',4252883,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','220331',4252884,'2708','240',1492436.77,1492849.15,412.38,66805.56,0.00,0.00,0.00,0.00,0.00),('5','101','917','220331',4252885,'2709','240',1603736.59,1606149.54,2412.95,390897.90,0.00,0.00,0.00,0.00,0.00),('5','101','917','220331',4252886,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','220331',4252887,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','220331',4252888,'2712','240',1146972.06,1151256.48,4284.42,694076.04,0.00,0.00,0.00,0.00,0.00),('5','101','620','220496',4255853,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','220496',4255854,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','220496',4255855,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','220496',4255856,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','220496',4255857,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','220496',4255858,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','220496',4255859,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','220496',4255860,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','220496',4255861,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','220496',4255862,'1741','241',728263.64,728491.33,227.69,67168.55,0.00,0.00,0.00,0.00,0.00),('5','101','623','220496',4255863,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','220496',4255864,'2705','240',783209.70,784567.50,1357.80,219963.60,0.00,0.00,0.00,0.00,0.00),('5','101','916','220496',4255865,'2706','240',863477.79,863477.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','220496',4255866,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','220496',4255867,'2708','240',1492849.15,1495036.45,2187.30,354342.60,0.00,0.00,0.00,0.00,0.00),('5','101','917','220496',4255868,'2709','240',1606149.54,1607983.13,1833.59,297041.58,0.00,0.00,0.00,0.00,0.00),('5','101','917','220496',4255869,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','220496',4255870,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','220496',4255871,'2712','240',1151256.48,1152126.19,869.71,140893.02,0.00,0.00,0.00,0.00,0.00),('5','101','620','220680',4259218,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','220680',4259219,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','220680',4259220,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','220680',4259221,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','220680',4259222,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','220680',4259223,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','220680',4259224,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','220680',4259225,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','220680',4259226,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','220680',4259227,'1741','241',728491.33,728682.95,191.62,56527.90,0.00,0.00,0.00,0.00,0.00),('5','101','623','220680',4259228,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','220680',4259229,'2705','240',784567.50,785167.59,600.09,97214.58,0.00,0.00,0.00,0.00,0.00),('5','101','916','220680',4259230,'2706','240',863477.79,863477.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','220680',4259231,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','220680',4259232,'2708','240',1495036.45,1497995.03,2958.58,479289.96,0.00,0.00,0.00,0.00,0.00),('5','101','917','220680',4259233,'2709','240',1607983.13,1609943.87,1960.74,317639.88,0.00,0.00,0.00,0.00,0.00),('5','101','917','220680',4259234,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','220680',4259235,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','220680',4259236,'2712','240',1152126.19,1154955.89,2829.70,458411.40,0.00,0.00,0.00,0.00,0.00),('5','101','620','220900',4263189,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','220900',4263190,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','220900',4263191,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','220900',4263192,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','220900',4263193,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','220900',4263194,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','220900',4263195,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','220900',4263196,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','220900',4263197,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','220900',4263198,'1741','241',728682.95,729106.42,423.47,124923.65,0.00,0.00,0.00,0.00,0.00),('5','101','623','220900',4263199,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','220900',4263200,'2705','240',785167.59,787758.51,2590.92,419729.04,0.00,0.00,0.00,0.00,0.00),('5','101','916','220900',4263201,'2706','240',863477.79,864305.05,827.26,134016.12,0.00,0.00,0.00,0.00,0.00),('5','101','916','220900',4263202,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','220900',4263203,'2708','240',1497995.03,1500948.01,2952.98,478382.76,0.00,0.00,0.00,0.00,0.00),('5','101','917','220900',4263204,'2709','240',1609943.87,1609946.17,2.30,372.60,0.00,0.00,0.00,0.00,0.00),('5','101','917','220900',4263205,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','220900',4263206,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','220900',4263207,'2712','240',1154955.89,1156885.05,1929.16,312523.92,0.00,0.00,0.00,0.00,0.00),('5','101','620','221176',4267782,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','221176',4267783,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','221176',4267784,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','221176',4267785,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','221176',4267786,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','221176',4267787,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','221176',4267788,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','221176',4267789,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','221176',4267790,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','221176',4267791,'1741','241',729106.42,729595.71,489.29,144340.55,0.00,0.00,0.00,0.00,0.00),('5','101','623','221176',4267792,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','221176',4267793,'2705','240',787758.51,790987.35,3228.84,523072.08,0.00,0.00,0.00,0.00,0.00),('5','101','916','221176',4267794,'2706','240',864305.05,865961.03,1655.98,268268.76,0.00,0.00,0.00,0.00,0.00),('5','101','916','221176',4267795,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','221176',4267796,'2708','240',1500948.01,1503744.37,2796.36,453010.32,0.00,0.00,0.00,0.00,0.00),('5','101','917','221176',4267797,'2709','240',1609946.17,1609946.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','221176',4267798,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','221176',4267799,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','221176',4267800,'2712','240',1156885.05,1157522.59,637.54,103281.48,0.00,0.00,0.00,0.00,0.00),('5','101','620','221403',4271896,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','221403',4271897,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','221403',4271898,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','221403',4271899,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','221403',4271900,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','221403',4271901,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','221403',4271902,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','221403',4271903,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','221403',4271904,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','221403',4271905,'1741','241',729595.71,730005.75,410.04,120961.80,0.00,0.00,0.00,0.00,0.00),('5','101','623','221403',4271906,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','221403',4271907,'2705','240',790987.35,792692.41,1705.06,276219.72,0.00,0.00,0.00,0.00,0.00),('5','101','916','221403',4271908,'2706','240',865961.03,868486.85,2525.82,409182.84,0.00,0.00,0.00,0.00,0.00),('5','101','916','221403',4271909,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','221403',4271910,'2708','240',1503744.37,1506572.55,2828.18,458165.16,0.00,0.00,0.00,0.00,0.00),('5','101','917','221403',4271911,'2709','240',1609946.17,1609946.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','221403',4271912,'2710','240',894352.15,894352.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','221403',4271913,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','221403',4271914,'2712','240',1157522.59,1158450.32,927.73,150292.26,0.00,0.00,0.00,0.00,0.00),('5','101','620','221626',4276117,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','221626',4276118,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','221626',4276119,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','221626',4276120,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','221626',4276121,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','221626',4276122,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','221626',4276123,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','221626',4276124,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','221626',4276125,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','221626',4276126,'1741','241',730005.75,730367.59,361.84,106742.80,0.00,0.00,0.00,0.00,0.00),('5','101','623','221626',4276127,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','221626',4276128,'2705','240',792692.41,793048.21,355.80,57639.60,0.00,0.00,0.00,0.00,0.00),('5','101','916','221626',4276129,'2706','240',868486.85,869889.29,1402.44,227195.28,0.00,0.00,0.00,0.00,0.00),('5','101','916','221626',4276130,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','221626',4276131,'2708','240',1506572.55,1508830.93,2258.38,365857.56,0.00,0.00,0.00,0.00,0.00),('5','101','917','221626',4276132,'2709','240',1609946.17,1611384.59,1438.42,233024.04,0.00,0.00,0.00,0.00,0.00),('5','101','917','221626',4276133,'2710','240',894352.15,895944.55,1592.40,257968.80,0.00,0.00,0.00,0.00,0.00),('5','101','917','221626',4276134,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','221626',4276135,'2712','240',1158450.32,1159793.36,1343.04,217572.48,0.00,0.00,0.00,0.00,0.00),('5','101','620','221861',4280190,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','221861',4280191,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','221861',4280192,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','221861',4280193,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','221861',4280194,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','221861',4280195,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','221861',4280196,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','221861',4280197,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','221861',4280198,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','221861',4280199,'1741','241',730367.59,730654.36,286.77,84597.15,0.00,0.00,0.00,0.00,0.00),('5','101','623','221861',4280200,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','221861',4280201,'2705','240',793048.21,794201.46,1153.25,186826.50,0.00,0.00,0.00,0.00,0.00),('5','101','916','221861',4280202,'2706','240',869889.29,871255.58,1366.29,221338.98,0.00,0.00,0.00,0.00,0.00),('5','101','916','221861',4280203,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','221861',4280204,'2708','240',1508830.93,1511259.16,2428.23,393373.26,0.00,0.00,0.00,0.00,0.00),('5','101','917','221861',4280205,'2709','240',1611384.59,1611384.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','221861',4280206,'2710','240',895944.55,898423.42,2478.87,401576.94,0.00,0.00,0.00,0.00,0.00),('5','101','917','221861',4280207,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','221861',4280208,'2712','240',1159793.36,1159793.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','222116',4284865,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','222116',4284866,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','222116',4284867,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','222116',4284868,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','222116',4284869,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','222116',4284870,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','222116',4284871,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','222116',4284872,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','222116',4284873,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','222116',4284874,'1741','241',730654.36,731059.62,405.26,119551.70,0.00,0.00,0.00,0.00,0.00),('5','101','623','222116',4284875,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','222116',4284876,'2705','240',794201.46,795104.47,903.01,146287.62,0.00,0.00,0.00,0.00,0.00),('5','101','916','222116',4284877,'2706','240',871255.58,872568.35,1312.77,212668.74,0.00,0.00,0.00,0.00,0.00),('5','101','916','222116',4284878,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','222116',4284879,'2708','240',1511259.16,1514343.27,3084.11,499625.82,0.00,0.00,0.00,0.00,0.00),('5','101','917','222116',4284880,'2709','240',1611384.59,1611787.18,402.59,65219.58,0.00,0.00,0.00,0.00,0.00),('5','101','917','222116',4284881,'2710','240',898423.42,898423.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','222116',4284882,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','222116',4284883,'2712','240',1159793.36,1161959.61,2166.25,350932.50,0.00,0.00,0.00,0.00,0.00),('5','101','620','222313',4288014,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','222313',4288015,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','222313',4288016,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','222313',4288017,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','222313',4288018,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','222313',4288019,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','222313',4288020,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','222313',4288021,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','222313',4288022,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','222313',4288023,'1741','241',731059.62,731370.86,311.24,91815.80,0.00,0.00,0.00,0.00,0.00),('5','101','623','222313',4288024,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','222313',4288025,'2705','240',795104.47,797787.49,2683.02,434649.24,0.00,0.00,0.00,0.00,0.00),('5','101','916','222313',4288026,'2706','240',872568.35,872568.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','222313',4288027,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','222313',4288028,'2708','240',1514343.27,1514754.54,411.27,66625.74,0.00,0.00,0.00,0.00,0.00),('5','101','917','222313',4288029,'2709','240',1611787.18,1611787.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','222313',4288030,'2710','240',898423.42,901229.62,2806.20,454604.40,0.00,0.00,0.00,0.00,0.00),('5','101','917','222313',4288031,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','222313',4288032,'2712','240',1161959.61,1164512.14,2552.53,413509.86,0.00,0.00,0.00,0.00,0.00),('5','101','620','222545',4292081,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','222545',4292082,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','222545',4292083,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','222545',4292084,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','222545',4292085,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','222545',4292086,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','222545',4292087,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','222545',4292088,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','222545',4292089,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','222545',4292090,'1741','241',731370.86,731775.71,404.85,119430.75,0.00,0.00,0.00,0.00,0.00),('5','101','623','222545',4292091,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','222545',4292092,'2705','240',797787.49,801155.51,3368.02,545619.24,0.00,0.00,0.00,0.00,0.00),('5','101','916','222545',4292093,'2706','240',872568.35,872568.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','222545',4292094,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','222545',4292095,'2708','240',1514754.54,1514754.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','222545',4292096,'2709','240',1611787.18,1611787.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','222545',4292097,'2710','240',901229.62,903992.87,2763.25,447646.50,0.00,0.00,0.00,0.00,0.00),('5','101','917','222545',4292098,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','222545',4292099,'2712','240',1164512.14,1167591.24,3079.10,498814.20,0.00,0.00,0.00,0.00,0.00),('5','101','620','222743',4295899,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','222743',4295900,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','222743',4295901,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','222743',4295902,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','222743',4295903,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','222743',4295904,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','222743',4295905,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','222743',4295906,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','222743',4295907,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','222743',4295908,'1741','241',731775.71,731952.83,177.12,52250.40,0.00,0.00,0.00,0.00,0.00),('5','101','623','222743',4295909,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','222743',4295910,'2705','240',801155.51,801155.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','222743',4295911,'2706','240',872568.35,874329.22,1760.87,285260.94,0.00,0.00,0.00,0.00,0.00),('5','101','916','222743',4295912,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','222743',4295913,'2708','240',1514754.54,1514754.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','222743',4295914,'2709','240',1611787.18,1611787.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','222743',4295915,'2710','240',903992.87,905496.66,1503.79,243613.98,0.00,0.00,0.00,0.00,0.00),('5','101','917','222743',4295916,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','222743',4295917,'2712','240',1167591.24,1168896.91,1305.67,211518.54,0.00,0.00,0.00,0.00,0.00),('5','101','620','222945',4299764,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','222945',4299765,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','222945',4299766,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','222945',4299767,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','222945',4299768,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','222945',4299769,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','222945',4299770,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','222945',4299771,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','222945',4299772,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','222945',4299773,'1741','241',731952.83,732112.12,159.29,46990.55,0.00,0.00,0.00,0.00,0.00),('5','101','623','222945',4299774,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','222945',4299775,'2705','240',801155.51,801155.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','222945',4299776,'2706','240',874329.22,877244.10,2914.88,472210.56,0.00,0.00,0.00,0.00,0.00),('5','101','916','222945',4299777,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','222945',4299778,'2708','240',1514754.54,1514754.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','222945',4299779,'2709','240',1611787.18,1611787.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','222945',4299780,'2710','240',905496.66,908034.67,2538.01,411157.62,0.00,0.00,0.00,0.00,0.00),('5','101','917','222945',4299781,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','222945',4299782,'2712','240',1168896.91,1171710.24,2813.33,455759.46,0.00,0.00,0.00,0.00,0.00),('5','101','620','223192',4303846,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','223192',4303847,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','223192',4303848,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','223192',4303849,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','223192',4303850,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','223192',4303851,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','223192',4303852,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','223192',4303853,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','223192',4303854,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','223192',4303855,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','223192',4303856,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','223192',4303857,'2705','240',801155.51,802018.44,862.93,139794.66,0.00,0.00,0.00,0.00,0.00),('5','101','916','223192',4303858,'2706','240',877244.10,880208.04,2963.94,480158.28,0.00,0.00,0.00,0.00,0.00),('5','101','916','223192',4303859,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','223192',4303860,'2708','240',1514754.54,1517247.66,2493.12,403885.44,0.00,0.00,0.00,0.00,0.00),('5','101','917','223192',4303861,'2709','240',1611787.18,1611787.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','223192',4303862,'2710','240',908034.67,909335.54,1300.87,210740.94,0.00,0.00,0.00,0.00,0.00),('5','101','917','223192',4303863,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','223192',4303864,'2712','240',1171710.24,1171966.49,256.25,41512.50,0.00,0.00,0.00,0.00,0.00),('5','101','620','223430',4308023,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','223430',4308024,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','223430',4308025,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','223430',4308026,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','223430',4308027,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','223430',4308028,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','223430',4308029,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','223430',4308030,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','223430',4308031,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','223430',4308032,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','223430',4308033,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','223430',4308034,'2705','240',802018.44,804257.61,2239.17,362745.54,0.00,0.00,0.00,0.00,0.00),('5','101','916','223430',4308035,'2706','240',880208.04,882553.35,2345.31,379940.22,0.00,0.00,0.00,0.00,0.00),('5','101','916','223430',4308036,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','223430',4308037,'2708','240',1517247.66,1520499.36,3251.70,526775.40,0.00,0.00,0.00,0.00,0.00),('5','101','917','223430',4308038,'2709','240',1611787.18,1611787.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','223430',4308039,'2710','240',909335.54,909335.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','223430',4308040,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','223430',4308041,'2712','240',1171966.49,1171966.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','223697',4312870,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','223697',4312871,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','223697',4312872,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','223697',4312873,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','223697',4312874,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','223697',4312875,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','223697',4312876,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','223697',4312877,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','223697',4312878,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','223697',4312879,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','223697',4312880,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','223697',4312881,'2705','240',804257.61,806361.07,2103.46,340760.52,0.00,0.00,0.00,0.00,0.00),('5','101','916','223697',4312882,'2706','240',882553.35,884876.51,2323.16,376351.92,0.00,0.00,0.00,0.00,0.00),('5','101','916','223697',4312883,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','223697',4312884,'2708','240',1520499.36,1521163.70,664.34,107623.08,0.00,0.00,0.00,0.00,0.00),('5','101','917','223697',4312885,'2709','240',1611787.18,1611787.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','223697',4312886,'2710','240',909335.54,909335.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','223697',4312887,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','223697',4312888,'2712','240',1171966.49,1171966.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','223940',4317396,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','223940',4317397,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','223940',4317398,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','223940',4317399,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','223940',4317400,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','223940',4317401,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','223940',4317402,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','223940',4317403,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','223940',4317404,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','223940',4317405,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','223940',4317406,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','223940',4317407,'2705','240',806361.07,808766.93,2405.86,389749.32,0.00,0.00,0.00,0.00,0.00),('5','101','916','223940',4317408,'2706','240',884876.51,887032.25,2155.74,349229.88,0.00,0.00,0.00,0.00,0.00),('5','101','916','223940',4317409,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','223940',4317410,'2708','240',1521163.70,1523960.86,2797.16,453139.92,0.00,0.00,0.00,0.00,0.00),('5','101','917','223940',4317411,'2709','240',1611787.18,1611787.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','223940',4317412,'2710','240',909335.54,909335.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','223940',4317413,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','223940',4317414,'2712','240',1171966.49,1171966.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','224078',4319920,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','224078',4319921,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','224078',4319922,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','224078',4319923,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','224078',4319924,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','224078',4319925,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','224078',4319926,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','224078',4319927,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','224078',4319928,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','224078',4319929,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','224078',4319930,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','224078',4319931,'2705','240',808766.93,811447.30,2680.37,434219.94,0.00,0.00,0.00,0.00,0.00),('5','101','916','224078',4319932,'2706','240',887032.25,889437.67,2405.42,389678.04,0.00,0.00,0.00,0.00,0.00),('5','101','916','224078',4319933,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','224078',4319934,'2708','240',1523960.86,1526785.92,2825.06,457659.72,0.00,0.00,0.00,0.00,0.00),('5','101','917','224078',4319935,'2709','240',1611787.18,1611787.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','224078',4319936,'2710','240',909335.54,909335.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','224078',4319937,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','224078',4319938,'2712','240',1171966.49,1171966.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','224350',4324629,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','224350',4324630,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','224350',4324631,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','224350',4324632,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','224350',4324633,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','224350',4324634,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','224350',4324635,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','224350',4324636,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','224350',4324637,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','224350',4324638,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','224350',4324639,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','224350',4324640,'2705','240',811447.30,813908.88,2461.58,398775.96,0.00,0.00,0.00,0.00,0.00),('5','101','916','224350',4324641,'2706','240',889437.67,891676.12,2238.45,362628.90,0.00,0.00,0.00,0.00,0.00),('5','101','916','224350',4324642,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','224350',4324643,'2708','240',1526785.92,1529646.32,2860.40,463384.80,0.00,0.00,0.00,0.00,0.00),('5','101','917','224350',4324644,'2709','240',1611787.18,1611787.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','224350',4324645,'2710','240',909335.54,909335.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','224350',4324646,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','224350',4324647,'2712','240',1171966.49,1171966.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','224584',4328724,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','224584',4328725,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','224584',4328726,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','224584',4328727,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','224584',4328728,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','224584',4328729,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','224584',4328730,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','224584',4328731,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','224584',4328732,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','224584',4328733,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','224584',4328734,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','224584',4328735,'2705','240',813908.88,816403.21,2494.33,404081.46,0.00,0.00,0.00,0.00,0.00),('5','101','916','224584',4328736,'2706','240',891676.12,894029.48,2353.36,381244.32,0.00,0.00,0.00,0.00,0.00),('5','101','916','224584',4328737,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','224584',4328738,'2708','240',1529646.32,1532396.79,2750.47,445576.14,0.00,0.00,0.00,0.00,0.00),('5','101','917','224584',4328739,'2709','240',1611787.18,1611787.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','224584',4328740,'2710','240',909335.54,909335.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','224584',4328741,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','224584',4328742,'2712','240',1171966.49,1171966.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','224788',4332288,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','224788',4332289,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','224788',4332290,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','224788',4332291,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','224788',4332292,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','224788',4332293,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','224788',4332294,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','224788',4332295,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','224788',4332296,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','224788',4332297,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','224788',4332298,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','224788',4332299,'2705','240',816403.21,820463.97,4060.76,661903.88,0.00,0.00,0.00,0.00,0.00),('5','101','916','224788',4332300,'2706','240',894029.48,896158.27,2128.79,346992.77,0.00,0.00,0.00,0.00,0.00),('5','101','916','224788',4332301,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','224788',4332302,'2708','240',1532396.79,1534003.52,1606.73,261896.99,0.00,0.00,0.00,0.00,0.00),('5','101','917','224788',4332303,'2709','240',1611787.18,1611787.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','224788',4332304,'2710','240',909335.54,909335.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','224788',4332305,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','224788',4332306,'2712','240',1171966.49,1171966.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','225097',4337861,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','225097',4337862,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','225097',4337863,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','225097',4337864,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','225097',4337865,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','225097',4337866,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','225097',4337867,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','225097',4337868,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','225097',4337869,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','225097',4337870,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','225097',4337871,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','225097',4337872,'2705','240',820463.97,821721.07,1257.10,203650.20,0.00,0.00,0.00,0.00,0.00),('5','101','916','225097',4337873,'2706','240',896158.27,897774.98,1616.71,261907.02,0.00,0.00,0.00,0.00,0.00),('5','101','916','225097',4337874,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','225097',4337875,'2708','240',1534003.52,1537136.97,3133.45,507618.90,0.00,0.00,0.00,0.00,0.00),('5','101','917','225097',4337876,'2709','240',1611787.18,1611787.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','225097',4337877,'2710','240',909335.54,910202.24,866.70,140405.40,0.00,0.00,0.00,0.00,0.00),('5','101','917','225097',4337878,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','225097',4337879,'2712','240',1171966.49,1173355.58,1389.09,225032.58,0.00,0.00,0.00,0.00,0.00),('5','101','620','225405',4343734,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','225405',4343735,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','225405',4343736,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','225405',4343737,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','225405',4343738,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','225405',4343739,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','225405',4343740,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','225405',4343741,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','225405',4343742,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','225405',4343743,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','225405',4343744,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','225405',4343745,'2705','240',821721.07,821721.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','225405',4343746,'2706','240',897774.98,899104.16,1329.18,215327.16,0.00,0.00,0.00,0.00,0.00),('5','101','916','225405',4343747,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','225405',4343748,'2708','240',1537136.97,1540357.04,3220.07,521651.34,0.00,0.00,0.00,0.00,0.00),('5','101','917','225405',4343749,'2709','240',1611787.18,1611787.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','225405',4343750,'2710','240',910202.24,913428.31,3226.07,522623.34,0.00,0.00,0.00,0.00,0.00),('5','101','917','225405',4343751,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','225405',4343752,'2712','240',1173355.58,1174240.24,884.66,143314.92,0.00,0.00,0.00,0.00,0.00),('5','101','620','225504',4345267,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','225504',4345268,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','225504',4345269,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','225504',4345270,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','225504',4345271,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','225504',4345272,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','225504',4345273,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','225504',4345274,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','225504',4345275,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','225504',4345276,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','225504',4345277,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','225504',4345278,'2705','240',821721.07,821721.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','225504',4345279,'2706','240',899104.16,901850.31,2746.15,444876.30,0.00,0.00,0.00,0.00,0.00),('5','101','916','225504',4345280,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','225504',4345281,'2708','240',1540357.04,1543242.18,2885.14,467392.68,0.00,0.00,0.00,0.00,0.00),('5','101','917','225504',4345282,'2709','240',1611787.18,1611787.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','225504',4345283,'2710','240',913428.31,916217.03,2788.72,451772.64,0.00,0.00,0.00,0.00,0.00),('5','101','917','225504',4345284,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','225504',4345285,'2712','240',1174240.24,1174240.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','225730',4349090,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','225730',4349091,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','225730',4349092,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','225730',4349093,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','225730',4349094,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','225730',4349095,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','225730',4349096,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','225730',4349097,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','225730',4349098,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','225730',4349099,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','225730',4349100,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','225730',4349101,'2705','240',821721.07,821721.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','225730',4349102,'2706','240',901850.31,904307.51,2457.20,398066.40,0.00,0.00,0.00,0.00,0.00),('5','101','916','225730',4349103,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','225730',4349104,'2708','240',1543242.18,1546917.05,3674.87,595328.94,0.00,0.00,0.00,0.00,0.00),('5','101','917','225730',4349105,'2709','240',1611787.18,1611787.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','225730',4349106,'2710','240',916217.03,918628.05,2411.02,390585.24,0.00,0.00,0.00,0.00,0.00),('5','101','917','225730',4349107,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','225730',4349108,'2712','240',1174240.24,1174468.46,228.22,36971.64,0.00,0.00,0.00,0.00,0.00),('5','101','620','226021',4354104,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','226021',4354105,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','226021',4354106,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','226021',4354107,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','226021',4354108,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','226021',4354109,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','226021',4354110,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','226021',4354111,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','226021',4354112,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','226021',4354113,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','226021',4354114,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','226021',4354115,'2705','240',821721.07,821721.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','226021',4354116,'2706','240',904307.51,906733.36,2425.85,392987.70,0.00,0.00,0.00,0.00,0.00),('5','101','916','226021',4354117,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','226021',4354118,'2708','240',1546917.05,1549346.11,2429.06,393507.72,0.00,0.00,0.00,0.00,0.00),('5','101','917','226021',4354119,'2709','240',1611787.18,1611787.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','226021',4354120,'2710','240',918628.05,921701.70,3073.65,497931.30,0.00,0.00,0.00,0.00,0.00),('5','101','917','226021',4354121,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','226021',4354122,'2712','240',1174468.46,1174468.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','226283',4359010,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','226283',4359011,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','226283',4359012,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','226283',4359013,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','226283',4359014,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','226283',4359015,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','226283',4359016,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','226283',4359017,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','226283',4359018,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','226283',4359019,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','226283',4359020,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','226283',4359021,'2705','240',821721.07,822675.44,954.37,154607.94,0.00,0.00,0.00,0.00,0.00),('5','101','916','226283',4359022,'2706','240',906733.36,908001.00,1267.64,205357.68,0.00,0.00,0.00,0.00,0.00),('5','101','916','226283',4359023,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','226283',4359024,'2708','240',1549346.11,1551284.12,1938.01,313957.62,0.00,0.00,0.00,0.00,0.00),('5','101','917','226283',4359025,'2709','240',1611787.18,1611787.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','226283',4359026,'2710','240',921701.70,924305.84,2604.14,421870.68,0.00,0.00,0.00,0.00,0.00),('5','101','917','226283',4359027,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','226283',4359028,'2712','240',1174468.46,1174488.41,19.95,3231.90,0.00,0.00,0.00,0.00,0.00),('5','101','620','226500',4362857,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','226500',4362858,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','226500',4362859,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','226500',4362860,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','226500',4362861,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','226500',4362862,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','226500',4362863,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','226500',4362864,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','226500',4362865,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','226500',4362866,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','226500',4362867,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','226500',4362868,'2705','240',822675.44,823619.90,944.46,153002.52,0.00,0.00,0.00,0.00,0.00),('5','101','916','226500',4362869,'2706','240',908001.00,909193.01,1192.01,193105.62,0.00,0.00,0.00,0.00,0.00),('5','101','916','226500',4362870,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','226500',4362871,'2708','240',1551284.12,1553827.18,2543.06,411975.72,0.00,0.00,0.00,0.00,0.00),('5','101','917','226500',4362872,'2709','240',1611787.18,1611787.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','226500',4362873,'2710','240',924305.84,926668.72,2362.88,382786.56,0.00,0.00,0.00,0.00,0.00),('5','101','917','226500',4362874,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','226500',4362875,'2712','240',1174488.41,1174488.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','226757',4367574,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','226757',4367575,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','226757',4367576,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','226757',4367577,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','226757',4367578,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','226757',4367579,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','226757',4367580,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','226757',4367581,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','226757',4367582,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','226757',4367583,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','226757',4367584,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','226757',4367585,'2705','240',823619.90,823650.76,30.86,4999.32,0.00,0.00,0.00,0.00,0.00),('5','101','916','226757',4367586,'2706','240',909193.01,912506.44,3313.43,536775.66,0.00,0.00,0.00,0.00,0.00),('5','101','916','226757',4367587,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','226757',4367588,'2708','240',1553827.18,1554847.53,1020.35,165296.70,0.00,0.00,0.00,0.00,0.00),('5','101','917','226757',4367589,'2709','240',1611787.18,1611787.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','226757',4367590,'2710','240',926668.72,931005.52,4336.80,702561.60,0.00,0.00,0.00,0.00,0.00),('5','101','917','226757',4367591,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','226757',4367592,'2712','240',1174488.41,1174488.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','226993',4371713,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','226993',4371714,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','226993',4371715,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','226993',4371716,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','226993',4371717,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','226993',4371718,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','226993',4371719,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','226993',4371720,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','226993',4371721,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','226993',4371722,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','226993',4371723,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','226993',4371724,'2705','240',823650.76,824904.30,1253.54,203073.48,0.00,0.00,0.00,0.00,0.00),('5','101','916','226993',4371725,'2706','240',912506.44,913750.62,1244.18,201557.16,0.00,0.00,0.00,0.00,0.00),('5','101','916','226993',4371726,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','226993',4371727,'2708','240',1554847.53,1555986.36,1138.83,184490.46,0.00,0.00,0.00,0.00,0.00),('5','101','917','226993',4371728,'2709','240',1611787.18,1611799.25,12.07,1955.34,0.00,0.00,0.00,0.00,0.00),('5','101','917','226993',4371729,'2710','240',931005.52,933966.48,2960.96,479675.52,0.00,0.00,0.00,0.00,0.00),('5','101','917','226993',4371730,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','226993',4371731,'2712','240',1174488.41,1175872.93,1384.52,224292.24,0.00,0.00,0.00,0.00,0.00),('5','101','620','227236',4375848,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','227236',4375849,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','227236',4375850,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','227236',4375851,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','227236',4375852,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','227236',4375853,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','227236',4375854,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','227236',4375855,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','227236',4375856,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','227236',4375857,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','227236',4375858,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','227236',4375859,'2705','240',824904.30,825361.52,457.22,74069.64,0.00,0.00,0.00,0.00,0.00),('5','101','916','227236',4375860,'2706','240',913750.62,914999.23,1248.61,202274.82,0.00,0.00,0.00,0.00,0.00),('5','101','916','227236',4375861,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','227236',4375862,'2708','240',1555986.36,1555986.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','227236',4375863,'2709','240',1611799.25,1612381.29,582.04,94290.48,0.00,0.00,0.00,0.00,0.00),('5','101','917','227236',4375864,'2710','240',933966.48,937719.52,3753.04,607992.48,0.00,0.00,0.00,0.00,0.00),('5','101','917','227236',4375865,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','227236',4375866,'2712','240',1175872.93,1178549.89,2676.96,433667.52,0.00,0.00,0.00,0.00,0.00),('5','101','620','227437',4379704,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','227437',4379705,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','227437',4379706,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','227437',4379707,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','227437',4379708,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','227437',4379709,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','227437',4379710,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','227437',4379711,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','227437',4379712,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','227437',4379713,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','227437',4379714,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','227437',4379715,'2705','240',825361.52,825361.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','227437',4379716,'2706','240',914999.23,914999.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','227437',4379717,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','227437',4379718,'2708','240',1555986.36,1555986.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','227437',4379719,'2709','240',1612381.29,1615325.49,2944.20,476960.40,0.00,0.00,0.00,0.00,0.00),('5','101','917','227437',4379720,'2710','240',937719.52,940176.18,2456.66,397978.92,0.00,0.00,0.00,0.00,0.00),('5','101','917','227437',4379721,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','227437',4379722,'2712','240',1178549.89,1181711.06,3161.17,512109.54,0.00,0.00,0.00,0.00,0.00),('5','101','620','227623',4382727,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','227623',4382728,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','227623',4382729,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','227623',4382730,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','227623',4382731,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','227623',4382732,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','227623',4382733,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','227623',4382734,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','227623',4382735,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','227623',4382736,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','227623',4382737,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','227623',4382738,'2705','240',825361.52,825361.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','227623',4382739,'2706','240',914999.23,914999.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','227623',4382740,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','227623',4382741,'2708','240',1555986.36,1555986.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','227623',4382742,'2709','240',1615325.49,1615525.76,200.27,32443.74,0.00,0.00,0.00,0.00,0.00),('5','101','917','227623',4382743,'2710','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','227623',4382744,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','227623',4382745,'2712','240',1181711.06,1182184.15,473.09,76640.58,0.00,0.00,0.00,0.00,0.00),('5','101','620','227866',4387129,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','227866',4387130,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','227866',4387131,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','227866',4387132,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','227866',4387133,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','227866',4387134,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','227866',4387135,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','227866',4387136,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','227866',4387137,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','227866',4387138,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','227866',4387139,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','227866',4387140,'2705','240',825361.52,827854.38,2492.86,403843.32,0.00,0.00,0.00,0.00,0.00),('5','101','916','227866',4387141,'2706','240',914999.23,916315.53,1316.30,213240.60,0.00,0.00,0.00,0.00,0.00),('5','101','916','227866',4387142,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','227866',4387143,'2708','240',1555986.36,1557878.91,1892.55,306593.10,0.00,0.00,0.00,0.00,0.00),('5','101','917','227866',4387144,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','227866',4387145,'2710','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','227866',4387146,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','227866',4387147,'2712','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','229273',4413857,'1732','240',501154.12,501154.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','229273',4413858,'1733','240',690461.04,690461.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','229273',4413859,'1734','240',446817.20,446817.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','229273',4413860,'1735','240',1161666.43,1161666.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','229273',4413861,'1736','240',1377307.86,1377307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','229273',4413862,'1737','240',716897.36,716897.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','229273',4413863,'1738','240',107607.40,107607.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','229273',4413864,'1739','240',858390.31,858390.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','229273',4413865,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','229273',4413866,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','229273',4413867,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','229273',4413868,'2705','240',827854.38,830444.59,2590.21,419614.02,0.00,0.00,0.00,0.00,0.00),('5','101','916','229273',4413869,'2706','240',916315.53,918866.34,2550.81,413231.22,0.00,0.00,0.00,0.00,0.00),('5','101','916','229273',4413870,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','229273',4413871,'2708','240',1557878.91,1560587.15,2708.24,438734.88,0.00,0.00,0.00,0.00,0.00),('5','101','917','229273',4413872,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','229273',4413873,'2710','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','229273',4413874,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','229273',4413875,'2712','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','230367',4434475,'1732','240',830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','230367',4434476,'1733','240',918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','230367',4434477,'1734','240',502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','230367',4434478,'1735','240',1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','230367',4434479,'1736','240',1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','230367',4434480,'1737','240',940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','230367',4434481,'1738','240',114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','230367',4434482,'1739','240',1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','230367',4434483,'1740','241',13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','230367',4434484,'1741','241',732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','230367',4434485,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','230367',4434486,'2705','240',830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','230367',4434487,'2706','240',918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','230367',4434488,'2707','240',502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','230367',4434489,'2708','240',1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','230367',4434490,'2709','240',1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','230367',4434491,'2710','240',940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','230367',4434492,'2711','240',114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','230367',4434493,'2712','240',1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','232403',4470043,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','232403',4470044,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','232403',4470045,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','232403',4470046,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232403',4470047,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232403',4470048,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232403',4470049,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232403',4470050,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','232403',4470051,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','232403',4470052,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','232403',4470053,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','232403',4470054,'2705','240',830444.59,832246.90,1802.31,291974.22,0.00,0.00,0.00,0.00,0.00),('5','101','916','232403',4470055,'2706','240',918866.34,920269.45,1403.11,227303.82,0.00,0.00,0.00,0.00,0.00),('5','101','916','232403',4470056,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','232403',4470057,'2708','240',1560587.15,1560601.90,14.75,2389.50,0.00,0.00,0.00,0.00,0.00),('5','101','917','232403',4470058,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','232403',4470059,'2710','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','232403',4470060,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','232403',4470061,'2712','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','232414',4470328,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','232414',4470329,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','232414',4470330,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','232414',4470331,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232414',4470332,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232414',4470333,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232414',4470334,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232414',4470335,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','232414',4470336,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','232414',4470337,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','232414',4470338,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','232414',4470339,'2705','240',832246.90,833207.26,960.36,155578.32,0.00,0.00,0.00,0.00,0.00),('5','101','916','232414',4470340,'2706','240',920269.45,923451.08,3181.63,515424.06,0.00,0.00,0.00,0.00,0.00),('5','101','916','232414',4470341,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','232414',4470342,'2708','240',1560601.90,1563808.76,3206.86,519511.32,0.00,0.00,0.00,0.00,0.00),('5','101','917','232414',4470343,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','232414',4470344,'2710','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','232414',4470345,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','232414',4470346,'2712','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','232502',4472102,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','232502',4472103,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','232502',4472104,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','232502',4472105,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232502',4472106,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232502',4472107,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232502',4472108,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232502',4472109,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','232502',4472110,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','232502',4472111,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','232502',4472112,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','232502',4472113,'2705','240',833207.26,835992.13,2784.87,451148.94,0.00,0.00,0.00,0.00,0.00),('5','101','916','232502',4472114,'2706','240',923451.08,926693.69,3242.61,525302.82,0.00,0.00,0.00,0.00,0.00),('5','101','916','232502',4472115,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','232502',4472116,'2708','240',1563808.76,1565340.14,1531.38,248083.56,0.00,0.00,0.00,0.00,0.00),('5','101','917','232502',4472117,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','232502',4472118,'2710','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','232502',4472119,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','232502',4472120,'2712','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','232505',4472177,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','232505',4472178,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','232505',4472179,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','232505',4472180,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232505',4472181,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232505',4472182,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232505',4472183,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232505',4472184,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','232505',4472185,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','232505',4472186,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','232505',4472187,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','232505',4472188,'2705','240',835992.13,835992.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','232505',4472189,'2706','240',926693.69,926693.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','232505',4472190,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','232505',4472191,'2708','240',1565340.14,1565340.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','232505',4472192,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','232505',4472193,'2710','240',940176.18,944516.83,4340.65,703185.30,0.00,0.00,0.00,0.00,0.00),('5','101','917','232505',4472194,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','232505',4472195,'2712','240',1182184.15,1185240.79,3056.64,495175.68,0.00,0.00,0.00,0.00,0.00),('5','101','620','232507',4472207,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','232507',4472208,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','232507',4472209,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','232507',4472210,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232507',4472211,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232507',4472212,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232507',4472213,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232507',4472214,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','232507',4472215,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','232507',4472216,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','232507',4472217,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','232507',4472218,'2705','240',835992.13,835992.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','232507',4472219,'2706','240',926693.69,926693.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','232507',4472220,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','232507',4472221,'2708','240',1565340.14,1565340.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','232507',4472222,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','232507',4472223,'2710','240',944516.83,947981.45,3464.62,561268.44,0.00,0.00,0.00,0.00,0.00),('5','101','917','232507',4472224,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','232507',4472225,'2712','240',1185240.79,1188079.29,2838.50,459837.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','232513',4472338,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','232513',4472339,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','232513',4472340,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','232513',4472341,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232513',4472342,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232513',4472343,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232513',4472344,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232513',4472345,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','232513',4472346,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','232513',4472347,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','232513',4472348,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','232513',4472349,'2705','240',835992.13,835992.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','232513',4472350,'2706','240',926693.69,926693.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','232513',4472351,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','232513',4472352,'2708','240',1565340.14,1565340.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','232513',4472353,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','232513',4472354,'2710','240',947981.45,951632.94,3651.49,591541.38,0.00,0.00,0.00,0.00,0.00),('5','101','917','232513',4472355,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','232513',4472356,'2712','240',1188079.29,1191310.86,3231.57,523514.34,0.00,0.00,0.00,0.00,0.00),('5','101','620','232515',4472361,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','232515',4472362,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','232515',4472363,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','232515',4472364,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232515',4472365,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232515',4472366,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232515',4472367,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232515',4472368,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','232515',4472369,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','232515',4472370,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','232515',4472371,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','232515',4472372,'2705','240',835992.13,835992.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','232515',4472373,'2706','240',926693.69,926693.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','232515',4472374,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','232515',4472375,'2708','240',1565340.14,1565340.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','232515',4472376,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','232515',4472377,'2710','240',951632.94,955332.65,3699.71,599353.02,0.00,0.00,0.00,0.00,0.00),('5','101','917','232515',4472378,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','232515',4472379,'2712','240',1191310.86,1194643.30,3332.44,539855.28,0.00,0.00,0.00,0.00,0.00),('5','101','620','232529',4472748,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','232529',4472749,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','232529',4472750,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','232529',4472751,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232529',4472752,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232529',4472753,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232529',4472754,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232529',4472755,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','232529',4472756,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','232529',4472757,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','232529',4472758,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','232529',4472759,'2705','240',835992.13,835992.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','232529',4472760,'2706','240',926693.69,926693.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','232529',4472761,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','232529',4472762,'2708','240',1565340.14,1565340.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','232529',4472763,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','232529',4472764,'2710','240',955332.65,959193.49,3860.84,625456.08,0.00,0.00,0.00,0.00,0.00),('5','101','917','232529',4472765,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','232529',4472766,'2712','240',1194643.30,1198505.57,3862.27,625687.74,0.00,0.00,0.00,0.00,0.00),('5','101','620','232531',4472790,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','232531',4472791,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','232531',4472792,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','232531',4472793,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232531',4472794,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232531',4472795,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232531',4472796,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232531',4472797,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','232531',4472798,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','232531',4472799,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','232531',4472800,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','232531',4472801,'2705','240',835992.13,836908.04,915.91,148377.42,0.00,0.00,0.00,0.00,0.00),('5','101','916','232531',4472802,'2706','240',926693.69,929562.65,2868.96,464771.52,0.00,0.00,0.00,0.00,0.00),('5','101','916','232531',4472803,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','232531',4472804,'2708','240',1565340.14,1565340.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','232531',4472805,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','232531',4472806,'2710','240',959193.49,962086.03,2892.54,468591.48,0.00,0.00,0.00,0.00,0.00),('5','101','917','232531',4472807,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','232531',4472808,'2712','240',1198505.57,1200228.63,1723.06,279135.72,0.00,0.00,0.00,0.00,0.00),('5','101','620','232651',4474734,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','232651',4474735,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','232651',4474736,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','232651',4474737,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232651',4474738,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232651',4474739,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232651',4474740,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232651',4474741,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','232651',4474742,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','232651',4474743,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','232651',4474744,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','232651',4474745,'2705','240',836908.04,839767.33,2859.29,463204.98,0.00,0.00,0.00,0.00,0.00),('5','101','916','232651',4474746,'2706','240',929562.65,933656.05,4093.40,663130.80,0.00,0.00,0.00,0.00,0.00),('5','101','916','232651',4474747,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','232651',4474748,'2708','240',1565340.14,1565340.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','232651',4474749,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','232651',4474750,'2710','240',962086.03,962086.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','232651',4474751,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','232651',4474752,'2712','240',1200228.63,1200228.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','232720',4476031,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','232720',4476032,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','232720',4476033,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','232720',4476034,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232720',4476035,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232720',4476036,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232720',4476037,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232720',4476038,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','232720',4476039,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','232720',4476040,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','232720',4476041,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','232720',4476042,'2705','240',839767.33,842675.99,2908.66,471202.92,0.00,0.00,0.00,0.00,0.00),('5','101','916','232720',4476043,'2706','240',933656.05,936820.77,3164.72,512684.64,0.00,0.00,0.00,0.00,0.00),('5','101','916','232720',4476044,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','232720',4476045,'2708','240',1565340.14,1566473.71,1133.57,183638.34,0.00,0.00,0.00,0.00,0.00),('5','101','917','232720',4476046,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','232720',4476047,'2710','240',962086.03,962086.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','232720',4476048,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','232720',4476049,'2712','240',1200228.63,1200228.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','232906',4479202,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','232906',4479203,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','232906',4479204,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','232906',4479205,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232906',4479206,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232906',4479207,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232906',4479208,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','232906',4479209,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','232906',4479210,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','232906',4479211,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','232906',4479212,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','232906',4479213,'2705','240',842675.99,844841.79,2165.80,350859.60,0.00,0.00,0.00,0.00,0.00),('5','101','916','232906',4479214,'2706','240',936820.77,939551.08,2730.31,442310.22,0.00,0.00,0.00,0.00,0.00),('5','101','916','232906',4479215,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','232906',4479216,'2708','240',1566473.71,1569271.31,2797.60,453211.20,0.00,0.00,0.00,0.00,0.00),('5','101','917','232906',4479217,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','232906',4479218,'2710','240',962086.03,962086.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','232906',4479219,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','232906',4479220,'2712','240',1200228.63,1200228.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','233131',4483198,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','233131',4483199,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','233131',4483200,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','233131',4483201,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','233131',4483202,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','233131',4483203,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','233131',4483204,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','233131',4483205,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','233131',4483206,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','233131',4483207,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','233131',4483208,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','233131',4483209,'2705','240',844841.79,846813.62,1971.83,319436.46,0.00,0.00,0.00,0.00,0.00),('5','101','916','233131',4483210,'2706','240',939551.08,941484.51,1933.43,313215.66,0.00,0.00,0.00,0.00,0.00),('5','101','916','233131',4483211,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','233131',4483212,'2708','240',1569271.31,1569839.41,568.10,92032.20,0.00,0.00,0.00,0.00,0.00),('5','101','917','233131',4483213,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','233131',4483214,'2710','240',962086.03,962086.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','233131',4483215,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','233131',4483216,'2712','240',1200228.63,1200228.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','235549',4526429,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','235549',4526430,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','235549',4526431,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','235549',4526432,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','235549',4526433,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','235549',4526434,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','235549',4526435,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','235549',4526436,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','235549',4526437,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','235549',4526438,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','235549',4526439,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','235549',4526440,'2705','240',846813.62,847612.24,798.62,131772.30,0.00,0.00,0.00,0.00,0.00),('5','101','916','235549',4526441,'2706','240',941484.51,941484.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','235549',4526442,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','235549',4526443,'2708','240',1569839.41,1570460.71,621.30,102514.50,0.00,0.00,0.00,0.00,0.00),('5','101','917','235549',4526444,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','235549',4526445,'2710','240',962086.03,962086.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','235549',4526446,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','235549',4526447,'2712','240',1200228.63,1200228.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','235587',4527023,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','235587',4527024,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','235587',4527025,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','235587',4527026,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','235587',4527027,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','235587',4527028,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','235587',4527029,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','235587',4527030,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','235587',4527031,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','235587',4527032,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','235587',4527033,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','235587',4527034,'2705','240',847612.24,848559.53,947.29,156302.85,0.00,0.00,0.00,0.00,0.00),('5','101','916','235587',4527035,'2706','240',941484.51,945188.88,3704.37,611221.05,0.00,0.00,0.00,0.00,0.00),('5','101','916','235587',4527036,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','235587',4527037,'2708','240',1570460.71,1572129.20,1668.49,275300.85,0.00,0.00,0.00,0.00,0.00),('5','101','917','235587',4527038,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','235587',4527039,'2710','240',962086.03,962086.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','235587',4527040,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','235587',4527041,'2712','240',1200228.63,1200228.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','235810',4531064,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','235810',4531065,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','235810',4531066,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','235810',4531067,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','235810',4531068,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','235810',4531069,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','235810',4531070,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','235810',4531071,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','235810',4531072,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','235810',4531073,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','235810',4531074,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','235810',4531075,'2705','240',848559.53,851755.24,3195.71,527292.15,0.00,0.00,0.00,0.00,0.00),('5','101','916','235810',4531076,'2706','240',945188.88,949008.92,3820.04,630306.60,0.00,0.00,0.00,0.00,0.00),('5','101','916','235810',4531077,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','235810',4531078,'2708','240',1572129.20,1574442.89,2313.69,381758.85,0.00,0.00,0.00,0.00,0.00),('5','101','917','235810',4531079,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','235810',4531080,'2710','240',962086.03,962086.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','235810',4531081,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','235810',4531082,'2712','240',1200228.63,1200228.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','236036',4534942,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','236036',4534943,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','236036',4534944,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','236036',4534945,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','236036',4534946,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','236036',4534947,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','236036',4534948,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','236036',4534949,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','236036',4534950,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','236036',4534951,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','236036',4534952,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','236036',4534953,'2705','240',851755.24,851755.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','236036',4534954,'2706','240',949008.92,950452.26,1443.34,238151.10,0.00,0.00,0.00,0.00,0.00),('5','101','916','236036',4534955,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','236036',4534956,'2708','240',1574442.89,1574442.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','236036',4534957,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','236036',4534958,'2710','240',962086.03,965054.26,2968.23,489757.95,0.00,0.00,0.00,0.00,0.00),('5','101','917','236036',4534959,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','236036',4534960,'2712','240',1200228.63,1204171.68,3943.05,650603.25,0.00,0.00,0.00,0.00,0.00),('5','101','620','236307',4539901,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','236307',4539902,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','236307',4539903,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','236307',4539904,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','236307',4539905,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','236307',4539906,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','236307',4539907,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','236307',4539908,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','236307',4539909,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','236307',4539910,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','236307',4539911,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','236307',4539912,'2705','240',851755.24,852483.64,728.40,120186.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','236307',4539913,'2706','240',950452.26,951318.08,865.82,142860.30,0.00,0.00,0.00,0.00,0.00),('5','101','916','236307',4539914,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','236307',4539915,'2708','240',1574442.89,1574442.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','236307',4539916,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','236307',4539917,'2710','240',965054.26,968781.26,3727.00,614955.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','236307',4539918,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','236307',4539919,'2712','240',1204171.68,1207693.09,3521.41,581032.65,0.00,0.00,0.00,0.00,0.00),('5','101','620','236583',4544684,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','236583',4544685,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','236583',4544686,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','236583',4544687,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','236583',4544688,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','236583',4544689,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','236583',4544690,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','236583',4544691,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','236583',4544692,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','236583',4544693,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','236583',4544694,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','236583',4544695,'2705','240',852483.64,854949.53,2465.89,406871.85,0.00,0.00,0.00,0.00,0.00),('5','101','916','236583',4544696,'2706','240',951318.08,955443.21,4125.13,680646.45,0.00,0.00,0.00,0.00,0.00),('5','101','916','236583',4544697,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','236583',4544698,'2708','240',1574442.89,1576303.75,1860.86,307041.90,0.00,0.00,0.00,0.00,0.00),('5','101','917','236583',4544699,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','236583',4544700,'2710','240',968781.26,968781.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','236583',4544701,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','236583',4544702,'2712','240',1207693.09,1207693.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','236763',4547553,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','236763',4547554,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','236763',4547555,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','236763',4547556,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','236763',4547557,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','236763',4547558,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','236763',4547559,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','236763',4547560,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','236763',4547561,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','236763',4547562,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','236763',4547563,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','236763',4547564,'2705','240',854949.53,855987.37,1037.84,171243.60,0.00,0.00,0.00,0.00,0.00),('5','101','916','236763',4547565,'2706','240',955443.21,957666.56,2223.35,366852.75,0.00,0.00,0.00,0.00,0.00),('5','101','916','236763',4547566,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','236763',4547567,'2708','240',1576303.75,1576304.84,1.09,179.85,0.00,0.00,0.00,0.00,0.00),('5','101','917','236763',4547568,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','236763',4547569,'2710','240',968781.26,968781.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','236763',4547570,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','236763',4547571,'2712','240',1207693.09,1207693.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','237773',4565456,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','237773',4565457,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','237773',4565458,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','237773',4565459,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','237773',4565460,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','237773',4565461,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','237773',4565462,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','237773',4565463,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','237773',4565464,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','237773',4565465,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','237773',4565466,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','237773',4565467,'2705','240',855987.37,855987.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','237773',4565468,'2706','240',957666.56,957666.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','237773',4565469,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','237773',4565470,'2708','240',1576304.84,1576304.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','237773',4565471,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','237773',4565472,'2710','240',968781.26,968781.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','237773',4565473,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','237773',4565474,'2712','240',1207693.09,1207693.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','237951',4568448,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','237951',4568449,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','237951',4568450,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','237951',4568451,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','237951',4568452,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','237951',4568453,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','237951',4568454,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','237951',4568455,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','237951',4568456,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','237951',4568457,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','237951',4568458,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','237951',4568459,'2705','240',855987.37,857864.41,1877.04,309711.60,0.00,0.00,0.00,0.00,0.00),('5','101','916','237951',4568460,'2706','240',957666.56,958084.33,417.77,68932.05,0.00,0.00,0.00,0.00,0.00),('5','101','916','237951',4568461,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','237951',4568462,'2708','240',1576304.84,1578153.07,1848.23,304957.95,0.00,0.00,0.00,0.00,0.00),('5','101','917','237951',4568463,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','237951',4568464,'2710','240',968781.26,968781.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','237951',4568465,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','237951',4568466,'2712','240',1207693.09,1207693.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','238129',4571176,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','238129',4571177,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','238129',4571178,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','238129',4571179,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','238129',4571180,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','238129',4571181,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','238129',4571182,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','238129',4571183,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','238129',4571184,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','238129',4571185,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','238129',4571186,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','238129',4571187,'2705','240',857864.41,860255.42,2391.01,394516.65,0.00,0.00,0.00,0.00,0.00),('5','101','916','238129',4571188,'2706','240',958084.33,960284.56,2200.23,363037.95,0.00,0.00,0.00,0.00,0.00),('5','101','916','238129',4571189,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','238129',4571190,'2708','240',1578153.07,1580514.90,2361.83,389701.95,0.00,0.00,0.00,0.00,0.00),('5','101','917','238129',4571191,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','238129',4571192,'2710','240',968781.26,968781.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','238129',4571193,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','238129',4571194,'2712','240',1207693.09,1207693.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','238420',4576420,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','238420',4576421,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','238420',4576422,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','238420',4576423,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','238420',4576424,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','238420',4576425,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','238420',4576426,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','238420',4576427,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','238420',4576428,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','238420',4576429,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','238420',4576430,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','238420',4576431,'2705','240',860255.42,862020.91,1765.49,291305.85,0.00,0.00,0.00,0.00,0.00),('5','101','916','238420',4576432,'2706','240',960284.56,963090.73,2806.17,463018.05,0.00,0.00,0.00,0.00,0.00),('5','101','916','238420',4576433,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','238420',4576434,'2708','240',1580514.90,1583238.68,2723.78,449423.70,0.00,0.00,0.00,0.00,0.00),('5','101','917','238420',4576435,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','238420',4576436,'2710','240',968781.26,968781.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','238420',4576437,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','238420',4576438,'2712','240',1207693.09,1207693.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','238637',4579868,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','238637',4579869,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','238637',4579870,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','238637',4579871,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','238637',4579872,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','238637',4579873,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','238637',4579874,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','238637',4579875,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','238637',4579876,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','238637',4579877,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','238637',4579878,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','238637',4579879,'2705','240',862020.91,863021.71,1000.80,165132.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','238637',4579880,'2706','240',963090.73,966464.95,3374.22,556746.30,0.00,0.00,0.00,0.00,0.00),('5','101','916','238637',4579881,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','238637',4579882,'2708','240',1583238.68,1587130.02,3891.34,642071.10,0.00,0.00,0.00,0.00,0.00),('5','101','917','238637',4579883,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','238637',4579884,'2710','240',968781.26,968781.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','238637',4579885,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','238637',4579886,'2712','240',1207693.09,1207693.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','238989',4586399,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','238989',4586400,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','238989',4586401,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','238989',4586402,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','238989',4586403,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','238989',4586404,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','238989',4586405,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','238989',4586406,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','238989',4586407,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','238989',4586408,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','238989',4586409,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','238989',4586410,'2705','240',863021.71,863021.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','238989',4586411,'2706','240',966464.95,966464.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','238989',4586412,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','238989',4586413,'2708','240',1587130.02,1590483.34,3353.32,553297.80,0.00,0.00,0.00,0.00,0.00),('5','101','917','238989',4586414,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','238989',4586415,'2710','240',968781.26,971464.82,2683.56,442787.40,0.00,0.00,0.00,0.00,0.00),('5','101','917','238989',4586416,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','238989',4586417,'2712','240',1207693.09,1209700.92,2007.83,331291.95,0.00,0.00,0.00,0.00,0.00),('5','101','620','239074',4587708,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','239074',4587709,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','239074',4587710,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','239074',4587711,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','239074',4587712,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','239074',4587713,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','239074',4587714,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','239074',4587715,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','239074',4587716,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','239074',4587717,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','239074',4587718,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','239074',4587719,'2705','240',863021.71,864095.70,1073.99,177208.35,0.00,0.00,0.00,0.00,0.00),('5','101','916','239074',4587720,'2706','240',966464.95,966464.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','239074',4587721,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','239074',4587722,'2708','240',1590483.34,1593483.49,3000.15,495024.75,0.00,0.00,0.00,0.00,0.00),('5','101','917','239074',4587723,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','239074',4587724,'2710','240',971464.82,974115.30,2650.48,437329.20,0.00,0.00,0.00,0.00,0.00),('5','101','917','239074',4587725,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','239074',4587726,'2712','240',1209700.92,1212620.62,2919.70,481750.50,0.00,0.00,0.00,0.00,0.00),('5','101','620','239354',4592514,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','239354',4592515,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','239354',4592516,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','239354',4592517,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','239354',4592518,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','239354',4592519,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','239354',4592520,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','239354',4592521,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','239354',4592522,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','239354',4592523,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','239354',4592524,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','239354',4592525,'2705','240',864095.70,864095.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','239354',4592526,'2706','240',966464.95,967063.19,598.24,98709.60,0.00,0.00,0.00,0.00,0.00),('5','101','916','239354',4592527,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','239354',4592528,'2708','240',1593483.49,1595740.14,2256.65,372347.25,0.00,0.00,0.00,0.00,0.00),('5','101','917','239354',4592529,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','239354',4592530,'2710','240',974115.30,976799.82,2684.52,442945.80,0.00,0.00,0.00,0.00,0.00),('5','101','917','239354',4592531,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','239354',4592532,'2712','240',1212620.62,1216422.20,3801.58,627260.70,0.00,0.00,0.00,0.00,0.00),('5','101','620','239549',4595755,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','239549',4595756,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','239549',4595757,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','239549',4595758,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','239549',4595759,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','239549',4595760,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','239549',4595761,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','239549',4595762,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','239549',4595763,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','239549',4595764,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','239549',4595765,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','239549',4595766,'2705','240',864095.70,864095.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','239549',4595767,'2706','240',967063.19,967841.92,778.73,128490.45,0.00,0.00,0.00,0.00,0.00),('5','101','916','239549',4595768,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','239549',4595769,'2708','240',1595740.14,1598203.74,2463.60,406494.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','239549',4595770,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','239549',4595771,'2710','240',976799.82,978961.94,2162.12,356749.80,0.00,0.00,0.00,0.00,0.00),('5','101','917','239549',4595772,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','239549',4595773,'2712','240',1216422.20,1219282.84,2860.64,472005.60,0.00,0.00,0.00,0.00,0.00),('5','101','620','239967',4603347,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','239967',4603348,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','239967',4603349,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','239967',4603350,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','239967',4603351,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','239967',4603352,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','239967',4603353,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','239967',4603354,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','239967',4603355,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','239967',4603356,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','239967',4603357,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','239967',4603358,'2705','240',864095.70,864095.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','239967',4603359,'2706','240',967841.92,968780.05,938.13,154791.45,0.00,0.00,0.00,0.00,0.00),('5','101','916','239967',4603360,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','239967',4603361,'2708','240',1598203.74,1600892.73,2688.99,443683.35,0.00,0.00,0.00,0.00,0.00),('5','101','917','239967',4603362,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','239967',4603363,'2710','240',978961.94,981088.24,2126.30,350839.50,0.00,0.00,0.00,0.00,0.00),('5','101','917','239967',4603364,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','239967',4603365,'2712','240',1219282.84,1222400.50,3117.66,514413.90,0.00,0.00,0.00,0.00,0.00),('5','101','620','240164',4606763,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','240164',4606764,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','240164',4606765,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','240164',4606766,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','240164',4606767,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','240164',4606768,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','240164',4606769,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','240164',4606770,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','240164',4606771,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','240164',4606772,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','240164',4606773,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','240164',4606774,'2705','240',864095.70,864095.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','240164',4606775,'2706','240',968780.05,968780.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','240164',4606776,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','240164',4606777,'2708','240',1600892.73,1603862.89,2970.16,490076.40,0.00,0.00,0.00,0.00,0.00),('5','101','917','240164',4606778,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','240164',4606779,'2710','240',981088.24,983635.62,2547.38,420317.70,0.00,0.00,0.00,0.00,0.00),('5','101','917','240164',4606780,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','240164',4606781,'2712','240',1222400.50,1225372.74,2972.24,490419.60,0.00,0.00,0.00,0.00,0.00),('5','101','620','240234',4607774,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','240234',4607775,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','240234',4607776,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','240234',4607777,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','240234',4607778,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','240234',4607779,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','240234',4607780,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','240234',4607781,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','240234',4607782,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','240234',4607783,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','240234',4607784,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','240234',4607785,'2705','240',864095.70,865323.10,1227.40,202521.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','240234',4607786,'2706','240',968780.05,968780.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','240234',4607787,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','240234',4607788,'2708','240',1603862.89,1606873.64,3010.75,496773.75,0.00,0.00,0.00,0.00,0.00),('5','101','917','240234',4607789,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','240234',4607790,'2710','240',983635.62,986497.63,2862.01,472231.65,0.00,0.00,0.00,0.00,0.00),('5','101','917','240234',4607791,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','240234',4607792,'2712','240',1225372.74,1227655.38,2282.64,376635.60,0.00,0.00,0.00,0.00,0.00),('5','101','620','240578',4613416,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','240578',4613417,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','240578',4613418,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','240578',4613419,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','240578',4613420,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','240578',4613421,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','240578',4613422,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','240578',4613423,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','240578',4613424,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','240578',4613425,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','240578',4613426,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','240578',4613427,'2705','240',865323.10,865323.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','240578',4613428,'2706','240',968780.05,968780.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','240578',4613429,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','240578',4613430,'2708','240',1606873.64,1609959.16,3085.52,509110.80,0.00,0.00,0.00,0.00,0.00),('5','101','917','240578',4613431,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','240578',4613432,'2710','240',986497.63,989519.54,3021.91,498615.15,0.00,0.00,0.00,0.00,0.00),('5','101','917','240578',4613433,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','240578',4613434,'2712','240',1227655.38,1230890.44,3235.06,533784.90,0.00,0.00,0.00,0.00,0.00),('5','101','620','240743',4615768,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','240743',4615769,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','240743',4615770,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','240743',4615771,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','240743',4615772,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','240743',4615773,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','240743',4615774,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','240743',4615775,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','240743',4615776,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','240743',4615777,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','240743',4615778,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','240743',4615779,'2705','240',865323.10,865323.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','240743',4615780,'2706','240',968780.05,968780.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','240743',4615781,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','240743',4615782,'2708','240',1609959.16,1614020.15,4060.99,670063.35,0.00,0.00,0.00,0.00,0.00),('5','101','917','240743',4615783,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','240743',4615784,'2710','240',989519.54,991693.62,2174.08,358723.20,0.00,0.00,0.00,0.00,0.00),('5','101','917','240743',4615785,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','240743',4615786,'2712','240',1230890.44,1234277.31,3386.87,558833.55,0.00,0.00,0.00,0.00,0.00),('5','101','620','241014',4620648,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','241014',4620649,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','241014',4620650,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','241014',4620651,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','241014',4620652,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','241014',4620653,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','241014',4620654,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','241014',4620655,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','241014',4620656,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','241014',4620657,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','241014',4620658,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','241014',4620659,'2705','240',865323.10,865323.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','241014',4620660,'2706','240',968780.05,968780.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','241014',4620661,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','241014',4620662,'2708','240',1614020.15,1617667.57,3647.42,601824.30,0.00,0.00,0.00,0.00,0.00),('5','101','917','241014',4620663,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','241014',4620664,'2710','240',991693.62,993095.22,1401.60,231264.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','241014',4620665,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','241014',4620666,'2712','240',1234277.31,1238157.05,3879.74,640157.10,0.00,0.00,0.00,0.00,0.00),('5','101','620','241333',4626281,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','241333',4626282,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','241333',4626283,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','241333',4626284,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','241333',4626285,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','241333',4626286,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','241333',4626287,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','241333',4626288,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','241333',4626289,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','241333',4626290,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','241333',4626291,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','241333',4626292,'2705','240',865323.10,865323.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','241333',4626293,'2706','240',968780.05,968916.69,136.64,22545.60,0.00,0.00,0.00,0.00,0.00),('5','101','916','241333',4626294,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','241333',4626295,'2708','240',1617667.57,1620950.14,3282.57,541624.05,0.00,0.00,0.00,0.00,0.00),('5','101','917','241333',4626296,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','241333',4626297,'2710','240',993095.22,995389.24,2294.02,378513.30,0.00,0.00,0.00,0.00,0.00),('5','101','917','241333',4626298,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','241333',4626299,'2712','240',1238157.05,1241402.95,3245.90,535573.50,0.00,0.00,0.00,0.00,0.00),('5','101','620','241503',4629170,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','241503',4629171,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','241503',4629172,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','241503',4629173,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','241503',4629174,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','241503',4629175,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','241503',4629176,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','241503',4629177,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','241503',4629178,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','241503',4629179,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','241503',4629180,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','241503',4629181,'2705','240',865323.10,866686.60,1363.50,224977.50,0.00,0.00,0.00,0.00,0.00),('5','101','916','241503',4629182,'2706','240',968916.69,972527.00,3610.31,595701.15,0.00,0.00,0.00,0.00,0.00),('5','101','916','241503',4629183,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','241503',4629184,'2708','240',1620950.14,1625209.90,4259.76,702860.40,0.00,0.00,0.00,0.00,0.00),('5','101','917','241503',4629185,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','241503',4629186,'2710','240',995389.24,995389.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','241503',4629187,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','241503',4629188,'2712','240',1241402.95,1241402.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','241818',4634613,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','241818',4634614,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','241818',4634615,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','241818',4634616,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','241818',4634617,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','241818',4634618,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','241818',4634619,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','241818',4634620,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','241818',4634621,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','241818',4634622,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','241818',4634623,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','241818',4634624,'2705','240',866686.60,871180.22,4493.62,741447.30,0.00,0.00,0.00,0.00,0.00),('5','101','916','241818',4634625,'2706','240',972527.00,973876.10,1349.10,222601.50,0.00,0.00,0.00,0.00,0.00),('5','101','916','241818',4634626,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','241818',4634627,'2708','240',1625209.90,1629020.60,3810.70,628765.50,0.00,0.00,0.00,0.00,0.00),('5','101','917','241818',4634628,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','241818',4634629,'2710','240',995389.24,995389.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','241818',4634630,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','241818',4634631,'2712','240',1241402.95,1241402.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','242008',4637821,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','242008',4637822,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','242008',4637823,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','242008',4637824,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','242008',4637825,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','242008',4637826,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','242008',4637827,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','242008',4637828,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','242008',4637829,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','242008',4637830,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','242008',4637831,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','242008',4637832,'2705','240',871180.22,873643.96,2463.74,406517.10,0.00,0.00,0.00,0.00,0.00),('5','101','916','242008',4637833,'2706','240',973876.10,976287.62,2411.52,397900.80,0.00,0.00,0.00,0.00,0.00),('5','101','916','242008',4637834,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','242008',4637835,'2708','240',1629020.60,1629422.79,402.19,66361.35,0.00,0.00,0.00,0.00,0.00),('5','101','917','242008',4637836,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','242008',4637837,'2710','240',995389.24,995389.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','242008',4637838,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','242008',4637839,'2712','240',1241402.95,1241402.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','242258',4642359,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','242258',4642360,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','242258',4642361,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','242258',4642362,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','242258',4642363,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','242258',4642364,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','242258',4642365,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','242258',4642366,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','242258',4642367,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','242258',4642368,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','242258',4642369,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','242258',4642370,'2705','240',873643.96,873643.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','242258',4642371,'2706','240',976287.62,976287.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','242258',4642372,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','242258',4642373,'2708','240',1629422.79,1629422.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','242258',4642374,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','242258',4642375,'2710','240',995389.24,995389.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','242258',4642376,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','242258',4642377,'2712','240',1241402.95,1241402.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','242865',4652939,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','242865',4652940,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','242865',4652941,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','242865',4652942,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','242865',4652943,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','242865',4652944,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','242865',4652945,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','242865',4652946,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','242865',4652947,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','242865',4652948,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','242865',4652949,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','242865',4652950,'2705','240',873643.96,874929.79,1285.83,212161.95,0.00,0.00,0.00,0.00,0.00),('5','101','916','242865',4652951,'2706','240',976287.62,976949.65,662.03,109234.95,0.00,0.00,0.00,0.00,0.00),('5','101','916','242865',4652952,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','242865',4652953,'2708','240',1629422.79,1629922.92,500.13,82521.45,0.00,0.00,0.00,0.00,0.00),('5','101','917','242865',4652954,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','242865',4652955,'2710','240',995389.24,995389.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','242865',4652956,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','242865',4652957,'2712','240',1241402.95,1241402.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','242993',4655137,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','242993',4655138,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','242993',4655139,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','242993',4655140,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','242993',4655141,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','242993',4655142,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','242993',4655143,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','242993',4655144,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','242993',4655145,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','242993',4655146,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','242993',4655147,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','242993',4655148,'2705','240',874929.79,877529.37,2599.58,428930.70,0.00,0.00,0.00,0.00,0.00),('5','101','916','242993',4655149,'2706','240',976949.65,979459.64,2509.99,414148.35,0.00,0.00,0.00,0.00,0.00),('5','101','916','242993',4655150,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','242993',4655151,'2708','240',1629922.92,1632971.24,3048.32,502972.80,0.00,0.00,0.00,0.00,0.00),('5','101','917','242993',4655152,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','242993',4655153,'2710','240',995389.24,995389.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','242993',4655154,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','242993',4655155,'2712','240',1241402.95,1241402.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','243218',4659110,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','243218',4659111,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','243218',4659112,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','243218',4659113,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','243218',4659114,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','243218',4659115,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','243218',4659116,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','243218',4659117,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','243218',4659118,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','243218',4659119,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','243218',4659120,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','243218',4659121,'2705','240',877529.37,877532.40,3.03,499.95,0.00,0.00,0.00,0.00,0.00),('5','101','916','243218',4659122,'2706','240',979459.64,980809.13,1349.49,222665.85,0.00,0.00,0.00,0.00,0.00),('5','101','916','243218',4659123,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','243218',4659124,'2708','240',1632971.24,1634726.29,1755.05,289583.25,0.00,0.00,0.00,0.00,0.00),('5','101','917','243218',4659125,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','243218',4659126,'2710','240',995389.24,997554.98,2165.74,357347.10,0.00,0.00,0.00,0.00,0.00),('5','101','917','243218',4659127,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','243218',4659128,'2712','240',1241402.95,1244150.24,2747.29,453302.85,0.00,0.00,0.00,0.00,0.00),('5','101','620','243405',4662401,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','243405',4662402,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','243405',4662403,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','243405',4662404,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','243405',4662405,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','243405',4662406,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','243405',4662407,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','243405',4662408,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','243405',4662409,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','243405',4662410,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','243405',4662411,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','243405',4662412,'2705','240',877532.40,878497.22,964.82,159195.30,0.00,0.00,0.00,0.00,0.00),('5','101','916','243405',4662413,'2706','240',980809.13,980809.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','243405',4662414,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','243405',4662415,'2708','240',1634726.29,1635397.84,671.55,110805.75,0.00,0.00,0.00,0.00,0.00),('5','101','917','243405',4662416,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','243405',4662417,'2710','240',997554.98,1000815.43,3260.45,537974.25,0.00,0.00,0.00,0.00,0.00),('5','101','917','243405',4662418,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','243405',4662419,'2712','240',1244150.24,1247599.93,3449.69,569198.85,0.00,0.00,0.00,0.00,0.00),('5','101','620','243627',4666167,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','243627',4666168,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','243627',4666169,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','243627',4666170,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','243627',4666171,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','243627',4666172,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','243627',4666173,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','243627',4666174,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','243627',4666175,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','243627',4666176,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','243627',4666177,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','243627',4666178,'2705','240',878497.22,879579.39,1082.17,178558.05,0.00,0.00,0.00,0.00,0.00),('5','101','916','243627',4666179,'2706','240',980809.13,981883.44,1074.31,177261.15,0.00,0.00,0.00,0.00,0.00),('5','101','916','243627',4666180,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','243627',4666181,'2708','240',1635397.84,1638512.22,3114.38,513872.70,0.00,0.00,0.00,0.00,0.00),('5','101','917','243627',4666182,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','243627',4666183,'2710','240',1000815.43,1002450.25,1634.82,269745.30,0.00,0.00,0.00,0.00,0.00),('5','101','917','243627',4666184,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','243627',4666185,'2712','240',1247599.93,1249375.21,1775.28,292921.20,0.00,0.00,0.00,0.00,0.00),('5','101','620','243855',4670181,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','243855',4670182,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','243855',4670183,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','243855',4670184,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','243855',4670185,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','243855',4670186,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','243855',4670187,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','243855',4670188,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','243855',4670189,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','243855',4670190,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','243855',4670191,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','243855',4670192,'2705','240',879579.39,882177.45,2598.06,428679.90,0.00,0.00,0.00,0.00,0.00),('5','101','916','243855',4670193,'2706','240',981883.44,985003.24,3119.80,514767.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','243855',4670194,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','243855',4670195,'2708','240',1638512.22,1641902.74,3390.52,559435.80,0.00,0.00,0.00,0.00,0.00),('5','101','917','243855',4670196,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','243855',4670197,'2710','240',1002450.25,1002450.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','243855',4670198,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','243855',4670199,'2712','240',1249375.21,1249375.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','244082',4674202,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','244082',4674203,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','244082',4674204,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','244082',4674205,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','244082',4674206,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','244082',4674207,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','244082',4674208,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','244082',4674209,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','244082',4674210,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','244082',4674211,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','244082',4674212,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','244082',4674213,'2705','240',882177.45,885448.42,3270.97,539710.05,0.00,0.00,0.00,0.00,0.00),('5','101','916','244082',4674214,'2706','240',985003.24,987546.14,2542.90,419578.50,0.00,0.00,0.00,0.00,0.00),('5','101','916','244082',4674215,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','244082',4674216,'2708','240',1641902.74,1644793.08,2890.34,476906.10,0.00,0.00,0.00,0.00,0.00),('5','101','917','244082',4674217,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','244082',4674218,'2710','240',1002450.25,1002450.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','244082',4674219,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','244082',4674220,'2712','240',1249375.21,1249375.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','244372',4679178,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','244372',4679179,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','244372',4679180,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','244372',4679181,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','244372',4679182,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','244372',4679183,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','244372',4679184,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','244372',4679185,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','244372',4679186,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','244372',4679187,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','244372',4679188,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','244372',4679189,'2705','240',885448.42,888189.70,2741.28,452311.20,0.00,0.00,0.00,0.00,0.00),('5','101','916','244372',4679190,'2706','240',987546.14,990377.78,2831.64,467220.60,0.00,0.00,0.00,0.00,0.00),('5','101','916','244372',4679191,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','244372',4679192,'2708','240',1644793.08,1646197.08,1404.00,231660.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','244372',4679193,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','244372',4679194,'2710','240',1002450.25,1002450.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','244372',4679195,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','244372',4679196,'2712','240',1249375.21,1249375.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','245251',4694301,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','245251',4694302,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','245251',4694303,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','245251',4694304,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','245251',4694305,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','245251',4694306,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','245251',4694307,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','245251',4694308,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','245251',4694309,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','245251',4694310,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','245251',4694311,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','245251',4694312,'2705','240',888189.70,888189.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','245251',4694313,'2706','240',990377.78,990377.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','245251',4694314,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','245251',4694315,'2708','240',1646197.08,1646197.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','245251',4694316,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','245251',4694317,'2710','240',1002450.25,1002450.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','245251',4694318,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','245251',4694319,'2712','240',1249375.21,1249375.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','245285',4694859,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','245285',4694860,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','245285',4694861,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','245285',4694862,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','245285',4694863,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','245285',4694864,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','245285',4694865,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','245285',4694866,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','245285',4694867,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','245285',4694868,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','245285',4694869,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','245285',4694870,'2705','240',888189.70,888189.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','245285',4694871,'2706','240',990377.78,990377.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','245285',4694872,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','245285',4694873,'2708','240',1646197.08,1646197.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','245285',4694874,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','245285',4694875,'2710','240',1002450.25,1002450.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','245285',4694876,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','245285',4694877,'2712','240',1249375.21,1249375.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','245286',4694878,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','245286',4694879,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','245286',4694880,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','245286',4694881,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','245286',4694882,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','245286',4694883,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','245286',4694884,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','245286',4694885,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','245286',4694886,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','245286',4694887,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','245286',4694888,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','245286',4694889,'2705','240',888189.70,888189.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','245286',4694890,'2706','240',990377.78,990377.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','245286',4694891,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','245286',4694892,'2708','240',1646197.08,1646197.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','245286',4694893,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','245286',4694894,'2710','240',1002450.25,1002450.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','245286',4694895,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','245286',4694896,'2712','240',1249375.21,1249375.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','245412',4697407,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','245412',4697408,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','245412',4697409,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','245412',4697410,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','245412',4697411,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','245412',4697412,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','245412',4697413,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','245412',4697414,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','245412',4697415,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','245412',4697416,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','245412',4697417,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','245412',4697418,'2705','240',888189.70,888189.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','245412',4697419,'2706','240',990377.78,990377.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','245412',4697420,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','245412',4697421,'2708','240',1646197.08,1646197.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','245412',4697422,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','245412',4697423,'2710','240',1002450.25,1002450.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','245412',4697424,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','245412',4697425,'2712','240',1249375.21,1249375.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','245456',4697856,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','245456',4697857,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','245456',4697858,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','245456',4697859,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','245456',4697860,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','245456',4697861,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','245456',4697862,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','245456',4697863,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','245456',4697864,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','245456',4697865,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','245456',4697866,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','245456',4697867,'2705','240',888189.70,888189.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','245456',4697868,'2706','240',990377.78,990377.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','245456',4697869,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','245456',4697870,'2708','240',1646197.08,1646197.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','245456',4697871,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','245456',4697872,'2710','240',1002450.25,1002450.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','245456',4697873,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','245456',4697874,'2712','240',1249375.21,1249375.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','245711',4702242,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','245711',4702243,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','245711',4702244,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','245711',4702245,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','245711',4702246,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','245711',4702247,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','245711',4702248,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','245711',4702249,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','245711',4702250,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','245711',4702251,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','245711',4702252,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','245711',4702253,'2705','240',888189.70,888642.80,453.10,74761.50,0.00,0.00,0.00,0.00,0.00),('5','101','916','245711',4702254,'2706','240',990377.78,990897.85,520.07,85811.55,0.00,0.00,0.00,0.00,0.00),('5','101','916','245711',4702255,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','245711',4702256,'2708','240',1646197.08,1646197.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','245711',4702257,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','245711',4702258,'2710','240',1002450.25,1002450.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','245711',4702259,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','245711',4702260,'2712','240',1249375.21,1249375.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','245957',4706009,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','245957',4706010,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','245957',4706011,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','245957',4706012,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','245957',4706013,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','245957',4706014,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','245957',4706015,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','245957',4706016,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','245957',4706017,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','245957',4706018,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','245957',4706019,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','245957',4706020,'2705','240',888642.80,892106.68,3463.88,571540.20,0.00,0.00,0.00,0.00,0.00),('5','101','916','245957',4706021,'2706','240',990897.85,992198.42,1300.57,214594.05,0.00,0.00,0.00,0.00,0.00),('5','101','916','245957',4706022,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','245957',4706023,'2708','240',1646197.08,1649553.37,3356.29,553787.85,0.00,0.00,0.00,0.00,0.00),('5','101','917','245957',4706024,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','245957',4706025,'2710','240',1002450.25,1002450.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','245957',4706026,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','245957',4706027,'2712','240',1249375.21,1249375.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','246293',4711747,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','246293',4711748,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','246293',4711749,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','246293',4711750,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','246293',4711751,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','246293',4711752,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','246293',4711753,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','246293',4711754,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','246293',4711755,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','246293',4711756,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','246293',4711757,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','246293',4711758,'2705','240',892106.68,894895.10,2788.42,460089.30,0.00,0.00,0.00,0.00,0.00),('5','101','916','246293',4711759,'2706','240',992198.42,995324.81,3126.39,515854.35,0.00,0.00,0.00,0.00,0.00),('5','101','916','246293',4711760,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','246293',4711761,'2708','240',1649553.37,1652414.75,2861.38,472127.70,0.00,0.00,0.00,0.00,0.00),('5','101','917','246293',4711762,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','246293',4711763,'2710','240',1002450.25,1002450.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','246293',4711764,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','246293',4711765,'2712','240',1249375.21,1249375.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','246489',4715019,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','246489',4715020,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','246489',4715021,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','246489',4715022,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','246489',4715023,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','246489',4715024,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','246489',4715025,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','246489',4715026,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','246489',4715027,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','246489',4715028,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','246489',4715029,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','246489',4715030,'2705','240',894895.10,898116.55,3221.45,531539.25,0.00,0.00,0.00,0.00,0.00),('5','101','916','246489',4715031,'2706','240',995324.81,998144.55,2819.74,465257.10,0.00,0.00,0.00,0.00,0.00),('5','101','916','246489',4715032,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','246489',4715033,'2708','240',1652414.75,1653452.55,1037.80,171237.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','246489',4715034,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','246489',4715035,'2710','240',1002450.25,1002450.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','246489',4715036,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','246489',4715037,'2712','240',1249375.21,1249375.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','246751',4719517,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','246751',4719518,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','246751',4719519,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','246751',4719520,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','246751',4719521,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','246751',4719522,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','246751',4719523,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','246751',4719524,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','246751',4719525,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','246751',4719526,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','246751',4719527,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','246751',4719528,'2705','240',898116.55,899131.41,1014.86,167451.90,0.00,0.00,0.00,0.00,0.00),('5','101','916','246751',4719529,'2706','240',998144.55,999103.61,959.06,158244.90,0.00,0.00,0.00,0.00,0.00),('5','101','916','246751',4719530,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','246751',4719531,'2708','240',1653452.55,1653752.65,300.10,49516.50,0.00,0.00,0.00,0.00,0.00),('5','101','917','246751',4719532,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','246751',4719533,'2710','240',1002450.25,1002450.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','246751',4719534,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','246751',4719535,'2712','240',1249375.21,1249375.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','247009',4724160,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','247009',4724161,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','247009',4724162,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','247009',4724163,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','247009',4724164,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','247009',4724165,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','247009',4724166,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','247009',4724167,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','247009',4724168,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','247009',4724169,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','247009',4724170,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','247009',4724171,'2705','240',899131.41,902192.44,3061.03,505069.95,0.00,0.00,0.00,0.00,0.00),('5','101','916','247009',4724172,'2706','240',999103.61,1001800.13,2696.52,444925.80,0.00,0.00,0.00,0.00,0.00),('5','101','916','247009',4724173,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','247009',4724174,'2708','240',1653752.65,1656798.74,3046.09,502604.85,0.00,0.00,0.00,0.00,0.00),('5','101','917','247009',4724175,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','247009',4724176,'2710','240',1002450.25,1002450.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','247009',4724177,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','247009',4724178,'2712','240',1249375.21,1249375.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','247260',4728559,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','247260',4728560,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','247260',4728561,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','247260',4728562,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','247260',4728563,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','247260',4728564,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','247260',4728565,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','247260',4728566,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','247260',4728567,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','247260',4728568,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','247260',4728569,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','247260',4728570,'2705','240',902192.44,905383.84,3191.40,526581.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','247260',4728571,'2706','240',1001800.13,1004384.07,2583.94,426350.10,0.00,0.00,0.00,0.00,0.00),('5','101','916','247260',4728572,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','247260',4728573,'2708','240',1656798.74,1659356.14,2557.40,421971.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','247260',4728574,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','247260',4728575,'2710','240',1002450.25,1002450.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','247260',4728576,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','247260',4728577,'2712','240',1249375.21,1249375.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','247455',4731930,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','247455',4731931,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','247455',4731932,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','247455',4731933,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','247455',4731934,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','247455',4731935,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','247455',4731936,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','247455',4731937,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','247455',4731938,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','247455',4731939,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','247455',4731940,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','247455',4731941,'2705','240',905383.84,908423.47,3039.63,501538.95,0.00,0.00,0.00,0.00,0.00),('5','101','916','247455',4731942,'2706','240',1004384.07,1007070.74,2686.67,443300.55,0.00,0.00,0.00,0.00,0.00),('5','101','916','247455',4731943,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','247455',4731944,'2708','240',1659356.14,1662277.57,2921.43,482035.95,0.00,0.00,0.00,0.00,0.00),('5','101','917','247455',4731945,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','247455',4731946,'2710','240',1002450.25,1002450.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','247455',4731947,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','247455',4731948,'2712','240',1249375.21,1249375.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','247745',4736971,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','247745',4736972,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','247745',4736973,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','247745',4736974,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','247745',4736975,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','247745',4736976,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','247745',4736977,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','247745',4736978,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','247745',4736979,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','247745',4736980,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','247745',4736981,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','247745',4736982,'2705','240',908423.47,910024.86,1601.39,264229.35,0.00,0.00,0.00,0.00,0.00),('5','101','916','247745',4736983,'2706','240',1007070.74,1008493.29,1422.55,234720.75,0.00,0.00,0.00,0.00,0.00),('5','101','916','247745',4736984,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','247745',4736985,'2708','240',1662277.57,1662277.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','247745',4736986,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','247745',4736987,'2710','240',1002450.25,1002450.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','247745',4736988,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','247745',4736989,'2712','240',1249375.21,1249375.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','247942',4739909,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','247942',4739910,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','247942',4739911,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','247942',4739912,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','247942',4739913,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','247942',4739914,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','247942',4739915,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','247942',4739916,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','247942',4739917,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','247942',4739918,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','247942',4739919,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','247942',4739920,'2705','240',910024.86,910024.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','247942',4739921,'2706','240',1008493.29,1008493.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','247942',4739922,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','247942',4739923,'2708','240',1662277.57,1662277.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','247942',4739924,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','247942',4739925,'2710','240',1002450.25,1002450.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','247942',4739926,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','247942',4739927,'2712','240',1249375.21,1249375.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','248252',4745481,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','248252',4745482,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','248252',4745483,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','248252',4745484,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','248252',4745485,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','248252',4745486,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','248252',4745487,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','248252',4745488,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','248252',4745489,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','248252',4745490,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','248252',4745491,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','248252',4745492,'2705','240',910024.86,910024.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','248252',4745493,'2706','240',1008493.29,1008493.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','248252',4745494,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','248252',4745495,'2708','240',1662277.57,1662277.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','248252',4745496,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','248252',4745497,'2710','240',1002450.25,1002450.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','248252',4745498,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','248252',4745499,'2712','240',1249375.21,1249375.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','248478',4749176,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','248478',4749177,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','248478',4749178,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','248478',4749179,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','248478',4749180,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','248478',4749181,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','248478',4749182,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','248478',4749183,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','248478',4749184,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','248478',4749185,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','248478',4749186,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','248478',4749187,'2705','240',910024.86,910024.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','248478',4749188,'2706','240',1008493.29,1008493.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','248478',4749189,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','248478',4749190,'2708','240',1662277.57,1662277.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','248478',4749191,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','248478',4749192,'2710','240',1002450.25,1002450.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','248478',4749193,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','248478',4749194,'2712','240',1249375.21,1249375.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','248964',4757384,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','248964',4757385,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','248964',4757386,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','248964',4757387,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','248964',4757388,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','248964',4757389,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','248964',4757390,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','248964',4757391,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','248964',4757392,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','248964',4757393,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','248964',4757394,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','248964',4757395,'2705','240',910024.86,910024.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','248964',4757396,'2706','240',1008493.29,1008493.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','248964',4757397,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','248964',4757398,'2708','240',1662277.57,1662277.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','248964',4757399,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','248964',4757400,'2710','240',1002450.25,1002450.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','248964',4757401,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','248964',4757402,'2712','240',1249375.21,1249375.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','249299',4763265,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','249299',4763266,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','249299',4763267,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','249299',4763268,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','249299',4763269,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','249299',4763270,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','249299',4763271,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','249299',4763272,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','249299',4763273,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','249299',4763274,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','249299',4763275,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','249299',4763276,'2705','240',910024.86,910024.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','249299',4763277,'2706','240',1008493.29,1008493.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','249299',4763278,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','249299',4763279,'2708','240',1662277.57,1662277.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','249299',4763280,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','249299',4763281,'2710','240',1002450.25,1002450.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','249299',4763282,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','249299',4763283,'2712','240',1249375.21,1249375.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','249429',4765309,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','249429',4765310,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','249429',4765311,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','249429',4765312,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','249429',4765313,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','249429',4765314,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','249429',4765315,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','249429',4765316,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','249429',4765317,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','249429',4765318,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','249429',4765319,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','249429',4765320,'2705','240',910024.86,910024.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','249429',4765321,'2706','240',1008493.29,1008493.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','249429',4765322,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','249429',4765323,'2708','240',1662277.57,1662277.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','249429',4765324,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','249429',4765325,'2710','240',1002450.25,1002450.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','249429',4765326,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','249429',4765327,'2712','240',1249375.21,1249375.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','249664',4769180,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','249664',4769181,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','249664',4769182,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','249664',4769183,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','249664',4769184,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','249664',4769185,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','249664',4769186,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','249664',4769187,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','249664',4769188,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','249664',4769189,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','249664',4769190,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','249664',4769191,'2705','240',910024.86,910024.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','249664',4769192,'2706','240',1008493.29,1009251.50,758.21,125104.65,0.00,0.00,0.00,0.00,0.00),('5','101','916','249664',4769193,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','249664',4769194,'2708','240',1662277.57,1668073.39,5795.82,956310.30,0.00,0.00,0.00,0.00,0.00),('5','101','917','249664',4769195,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','249664',4769196,'2710','240',1002450.25,1002450.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','249664',4769197,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','249664',4769198,'2712','240',1249375.21,1249375.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','249899',4773136,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','249899',4773137,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','249899',4773138,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','249899',4773139,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','249899',4773140,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','249899',4773141,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','249899',4773142,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','249899',4773143,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','249899',4773144,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','249899',4773145,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','249899',4773146,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','249899',4773147,'2705','240',910024.86,912744.66,2719.80,448767.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','249899',4773148,'2706','240',1009251.50,1011870.15,2618.65,432077.25,0.00,0.00,0.00,0.00,0.00),('5','101','916','249899',4773149,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','249899',4773150,'2708','240',1668073.39,1671318.52,3245.13,535446.45,0.00,0.00,0.00,0.00,0.00),('5','101','917','249899',4773151,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','249899',4773152,'2710','240',1002450.25,1002450.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','249899',4773153,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','249899',4773154,'2712','240',1249375.21,1249375.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','250164',4777609,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','250164',4777610,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','250164',4777611,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','250164',4777612,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','250164',4777613,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','250164',4777614,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','250164',4777615,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','250164',4777616,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','250164',4777617,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','250164',4777618,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','250164',4777619,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','250164',4777620,'2705','240',912744.66,915114.13,2369.47,390962.55,0.00,0.00,0.00,0.00,0.00),('5','101','916','250164',4777621,'2706','240',1011870.15,1014325.93,2455.78,405203.70,0.00,0.00,0.00,0.00,0.00),('5','101','916','250164',4777622,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','250164',4777623,'2708','240',1671318.52,1674013.66,2695.14,444698.10,0.00,0.00,0.00,0.00,0.00),('5','101','917','250164',4777624,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','250164',4777625,'2710','240',1002450.25,1002450.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','250164',4777626,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','250164',4777627,'2712','240',1249375.21,1249375.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','250480',4782878,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','250480',4782879,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','250480',4782880,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','250480',4782881,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','250480',4782882,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','250480',4782883,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','250480',4782884,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','250480',4782885,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','250480',4782886,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','250480',4782887,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','250480',4782888,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','250480',4782889,'2705','240',915114.13,915114.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','250480',4782890,'2706','240',1014325.93,1019721.93,5396.00,890340.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','250480',4782891,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','250480',4782892,'2708','240',1674013.66,1679636.22,5622.56,927722.40,0.00,0.00,0.00,0.00,0.00),('5','101','917','250480',4782893,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','250480',4782894,'2710','240',1002450.25,1002450.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','250480',4782895,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','250480',4782896,'2712','240',1249375.21,1249375.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','250651',4785696,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','250651',4785697,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','250651',4785698,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','250651',4785699,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','250651',4785700,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','250651',4785701,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','250651',4785702,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','250651',4785703,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','250651',4785704,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','250651',4785705,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','250651',4785706,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','250651',4785707,'2705','240',915114.13,915114.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','250651',4785708,'2706','240',1019721.93,1019721.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','250651',4785709,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','250651',4785710,'2708','240',1679636.22,1687044.55,7408.33,1222374.45,0.00,0.00,0.00,0.00,0.00),('5','101','917','250651',4785711,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','250651',4785712,'2710','240',1002450.25,1002450.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','250651',4785713,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','250651',4785714,'2712','240',1249375.21,1249375.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','250992',4792086,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','250992',4792087,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','250992',4792088,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','250992',4792089,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','250992',4792090,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','250992',4792091,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','250992',4792092,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','250992',4792093,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','250992',4792094,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','250992',4792095,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','250992',4792096,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','250992',4792097,'2705','240',915114.13,916790.11,1675.98,276536.70,0.00,0.00,0.00,0.00,0.00),('5','101','916','250992',4792098,'2706','240',1019721.93,1021426.26,1704.33,281214.45,0.00,0.00,0.00,0.00,0.00),('5','101','916','250992',4792099,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','250992',4792100,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','250992',4792101,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','250992',4792102,'2710','240',1002450.25,1002450.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','250992',4792103,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','250992',4792104,'2712','240',1249375.21,1249375.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','251098',4793683,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','251098',4793684,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','251098',4793685,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','251098',4793686,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','251098',4793687,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','251098',4793688,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','251098',4793689,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','251098',4793690,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','251098',4793691,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','251098',4793692,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','251098',4793693,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','251098',4793694,'2705','240',916790.11,916790.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','251098',4793695,'2706','240',1021426.26,1021426.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','251098',4793696,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','251098',4793697,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','251098',4793698,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','251098',4793699,'2710','240',1002450.25,1008501.52,6051.27,998459.55,0.00,0.00,0.00,0.00,0.00),('5','101','917','251098',4793700,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','251098',4793701,'2712','240',1249375.21,1256295.48,6920.27,1141844.55,0.00,0.00,0.00,0.00,0.00),('5','101','620','251324',4797591,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','251324',4797592,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','251324',4797593,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','251324',4797594,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','251324',4797595,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','251324',4797596,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','251324',4797597,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','251324',4797598,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','251324',4797599,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','251324',4797600,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','251324',4797601,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','251324',4797602,'2705','240',916790.11,916790.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','251324',4797603,'2706','240',1021426.26,1021426.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','251324',4797604,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','251324',4797605,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','251324',4797606,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','251324',4797607,'2710','240',1008501.52,1014126.60,5625.08,928138.20,0.00,0.00,0.00,0.00,0.00),('5','101','917','251324',4797608,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','251324',4797609,'2712','240',1256295.48,1261619.86,5324.38,878522.70,0.00,0.00,0.00,0.00,0.00),('5','101','620','251581',4801909,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','251581',4801910,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','251581',4801911,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','251581',4801912,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','251581',4801913,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','251581',4801914,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','251581',4801915,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','251581',4801916,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','251581',4801917,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','251581',4801918,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','251581',4801919,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','251581',4801920,'2705','240',916790.11,916790.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','251581',4801921,'2706','240',1021426.26,1021426.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','251581',4801922,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','251581',4801923,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','251581',4801924,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','251581',4801925,'2710','240',1014126.60,1019146.43,5019.83,828271.95,0.00,0.00,0.00,0.00,0.00),('5','101','917','251581',4801926,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','251581',4801927,'2712','240',1261619.86,1266172.92,4553.06,751254.90,0.00,0.00,0.00,0.00,0.00),('5','101','620','251839',4806608,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','251839',4806609,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','251839',4806610,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','251839',4806611,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','251839',4806612,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','251839',4806613,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','251839',4806614,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','251839',4806615,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','251839',4806616,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','251839',4806617,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','251839',4806618,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','251839',4806619,'2705','240',916790.11,916790.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','251839',4806620,'2706','240',1021426.26,1021426.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','251839',4806621,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','251839',4806622,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','251839',4806623,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','251839',4806624,'2710','240',1019146.43,1023633.98,4487.55,740445.75,0.00,0.00,0.00,0.00,0.00),('5','101','917','251839',4806625,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','251839',4806626,'2712','240',1266172.92,1270538.02,4365.10,720241.50,0.00,0.00,0.00,0.00,0.00),('5','101','620','252019',4809622,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','252019',4809623,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','252019',4809624,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','252019',4809625,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','252019',4809626,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','252019',4809627,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','252019',4809628,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','252019',4809629,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','252019',4809630,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','252019',4809631,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','252019',4809632,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','252019',4809633,'2705','240',916790.11,916790.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','252019',4809634,'2706','240',1021426.26,1021426.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','252019',4809635,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','252019',4809636,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','252019',4809637,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','252019',4809638,'2710','240',1023633.98,1024323.90,689.92,113836.80,0.00,0.00,0.00,0.00,0.00),('5','101','917','252019',4809639,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','252019',4809640,'2712','240',1270538.02,1271000.48,462.46,76305.90,0.00,0.00,0.00,0.00,0.00),('5','101','620','252261',4813821,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','252261',4813822,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','252261',4813823,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','252261',4813824,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','252261',4813825,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','252261',4813826,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','252261',4813827,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','252261',4813828,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','252261',4813829,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','252261',4813830,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','252261',4813831,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','252261',4813832,'2705','240',916790.11,916790.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','252261',4813833,'2706','240',1021426.26,1021426.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','252261',4813834,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','252261',4813835,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','252261',4813836,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','252261',4813837,'2710','240',1024323.90,1024323.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','252261',4813838,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','252261',4813839,'2712','240',1271000.48,1271000.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','252771',4822719,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','252771',4822720,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','252771',4822721,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','252771',4822722,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','252771',4822723,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','252771',4822724,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','252771',4822725,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','252771',4822726,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','252771',4822727,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','252771',4822728,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','252771',4822729,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','252771',4822730,'2705','240',916790.11,916790.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','252771',4822731,'2706','240',1021426.26,1021426.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','252771',4822732,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','252771',4822733,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','252771',4822734,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','252771',4822735,'2710','240',1024323.90,1024323.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','252771',4822736,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','252771',4822737,'2712','240',1271000.48,1278208.90,7208.42,1189389.30,0.00,0.00,0.00,0.00,0.00),('5','101','620','253024',4826835,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','253024',4826836,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','253024',4826837,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','253024',4826838,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','253024',4826839,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','253024',4826840,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','253024',4826841,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','253024',4826842,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','253024',4826843,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','253024',4826844,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','253024',4826845,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','253024',4826846,'2705','240',916790.11,916790.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','253024',4826847,'2706','240',1021426.26,1021426.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','253024',4826848,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','253024',4826849,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','253024',4826850,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','253024',4826851,'2710','240',1024323.90,1026996.16,2672.26,440922.90,0.00,0.00,0.00,0.00,0.00),('5','101','917','253024',4826852,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','253024',4826853,'2712','240',1278208.90,1281811.40,3602.50,594412.50,0.00,0.00,0.00,0.00,0.00),('5','101','620','253255',4830825,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','253255',4830826,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','253255',4830827,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','253255',4830828,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','253255',4830829,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','253255',4830830,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','253255',4830831,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','253255',4830832,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','253255',4830833,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','253255',4830834,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','253255',4830835,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','253255',4830836,'2705','240',916790.11,916790.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','253255',4830837,'2706','240',1021426.26,1021426.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','253255',4830838,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','253255',4830839,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','253255',4830840,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','253255',4830841,'2710','240',1026996.16,1027948.17,952.01,157081.65,0.00,0.00,0.00,0.00,0.00),('5','101','917','253255',4830842,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','253255',4830843,'2712','240',1281811.40,1282372.42,561.02,92568.30,0.00,0.00,0.00,0.00,0.00),('5','101','620','253539',4835674,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','253539',4835675,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','253539',4835676,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','253539',4835677,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','253539',4835678,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','253539',4835679,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','253539',4835680,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','253539',4835681,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','253539',4835682,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','253539',4835683,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','253539',4835684,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','253539',4835685,'2705','240',916790.11,917824.31,1034.20,170643.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','253539',4835686,'2706','240',1021426.26,1024724.31,3298.05,544178.25,0.00,0.00,0.00,0.00,0.00),('5','101','916','253539',4835687,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','253539',4835688,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','253539',4835689,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','253539',4835690,'2710','240',1027948.17,1028034.76,86.59,14287.35,0.00,0.00,0.00,0.00,0.00),('5','101','917','253539',4835691,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','253539',4835692,'2712','240',1282372.42,1287430.83,5058.41,834637.65,0.00,0.00,0.00,0.00,0.00),('5','101','620','253782',4839906,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','253782',4839907,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','253782',4839908,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','253782',4839909,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','253782',4839910,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','253782',4839911,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','253782',4839912,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','253782',4839913,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','253782',4839914,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','253782',4839915,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','253782',4839916,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','253782',4839917,'2705','240',917824.31,920349.05,2524.74,416582.10,0.00,0.00,0.00,0.00,0.00),('5','101','916','253782',4839918,'2706','240',1024724.31,1025578.77,854.46,140985.90,0.00,0.00,0.00,0.00,0.00),('5','101','916','253782',4839919,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','253782',4839920,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','253782',4839921,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','253782',4839922,'2710','240',1028034.76,1029854.26,1819.50,300217.50,0.00,0.00,0.00,0.00,0.00),('5','101','917','253782',4839923,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','253782',4839924,'2712','240',1287430.83,1291667.51,4236.68,699052.20,0.00,0.00,0.00,0.00,0.00),('5','101','620','254168',4847040,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','254168',4847041,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','254168',4847042,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','254168',4847043,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','254168',4847044,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','254168',4847045,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','254168',4847046,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','254168',4847047,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','254168',4847048,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','254168',4847049,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','254168',4847050,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','254168',4847051,'2705','240',920349.05,923411.16,3062.11,505248.15,0.00,0.00,0.00,0.00,0.00),('5','101','916','254168',4847052,'2706','240',1025578.77,1029442.98,3864.21,637594.65,0.00,0.00,0.00,0.00,0.00),('5','101','916','254168',4847053,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','254168',4847054,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','254168',4847055,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','254168',4847056,'2710','240',1029854.26,1030992.10,1137.84,187743.60,0.00,0.00,0.00,0.00,0.00),('5','101','917','254168',4847057,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','254168',4847058,'2712','240',1291667.51,1292939.84,1272.33,209934.45,0.00,0.00,0.00,0.00,0.00),('5','101','620','254292',4848936,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','254292',4848937,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','254292',4848938,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','254292',4848939,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','254292',4848940,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','254292',4848941,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','254292',4848942,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','254292',4848943,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','254292',4848944,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','254292',4848945,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','254292',4848946,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','254292',4848947,'2705','240',923411.16,927860.40,4449.24,734124.60,0.00,0.00,0.00,0.00,0.00),('5','101','916','254292',4848948,'2706','240',1029442.98,1033935.01,4492.03,741184.95,0.00,0.00,0.00,0.00,0.00),('5','101','916','254292',4848949,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','254292',4848950,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','254292',4848951,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','254292',4848952,'2710','240',1030992.10,1030992.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','254292',4848953,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','254292',4848954,'2712','240',1292939.84,1292939.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','254521',4852880,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','254521',4852881,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','254521',4852882,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','254521',4852883,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','254521',4852884,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','254521',4852885,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','254521',4852886,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','254521',4852887,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','254521',4852888,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','254521',4852889,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','254521',4852890,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','254521',4852891,'2705','240',927860.40,930973.84,3113.44,513717.60,0.00,0.00,0.00,0.00,0.00),('5','101','916','254521',4852892,'2706','240',1033935.01,1037197.74,3262.73,538350.45,0.00,0.00,0.00,0.00,0.00),('5','101','916','254521',4852893,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','254521',4852894,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','254521',4852895,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','254521',4852896,'2710','240',1030992.10,1030992.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','254521',4852897,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','254521',4852898,'2712','240',1292939.84,1292939.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','254784',4857342,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','254784',4857343,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','254784',4857344,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','254784',4857345,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','254784',4857346,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','254784',4857347,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','254784',4857348,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','254784',4857349,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','254784',4857350,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','254784',4857351,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','254784',4857352,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','254784',4857353,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','254784',4857354,'2706','240',1037197.74,1037197.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','254784',4857355,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','254784',4857356,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','254784',4857357,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','254784',4857358,'2710','240',1030992.10,1030992.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','254784',4857359,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','254784',4857360,'2712','240',1292939.84,1292939.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','255015',4861348,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','255015',4861349,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','255015',4861350,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','255015',4861351,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','255015',4861352,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','255015',4861353,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','255015',4861354,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','255015',4861355,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','255015',4861356,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','255015',4861357,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','255015',4861358,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','255015',4861359,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','255015',4861360,'2706','240',1037197.74,1037197.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','255015',4861361,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','255015',4861362,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','255015',4861363,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','255015',4861364,'2710','240',1030992.10,1030992.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','255015',4861365,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','255015',4861366,'2712','240',1292939.84,1292939.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','255351',4867402,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','255351',4867403,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','255351',4867404,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','255351',4867405,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','255351',4867406,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','255351',4867407,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','255351',4867408,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','255351',4867409,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','255351',4867410,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','255351',4867411,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','255351',4867412,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','255351',4867413,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','255351',4867414,'2706','240',1037197.74,1037197.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','255351',4867415,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','255351',4867416,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','255351',4867417,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','255351',4867418,'2710','240',1030992.10,1030992.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','255351',4867419,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','255351',4867420,'2712','240',1292939.84,1292939.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','255585',4871000,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','255585',4871001,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','255585',4871002,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','255585',4871003,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','255585',4871004,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','255585',4871005,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','255585',4871006,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','255585',4871007,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','255585',4871008,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','255585',4871009,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','255585',4871010,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','255585',4871011,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','255585',4871012,'2706','240',1037197.74,1037197.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','255585',4871013,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','255585',4871014,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','255585',4871015,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','255585',4871016,'2710','240',1030992.10,1030992.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','255585',4871017,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','255585',4871018,'2712','240',1292939.84,1292939.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','255735',4873504,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','255735',4873505,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','255735',4873506,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','255735',4873507,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','255735',4873508,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','255735',4873509,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','255735',4873510,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','255735',4873511,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','255735',4873512,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','255735',4873513,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','255735',4873514,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','255735',4873515,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','255735',4873516,'2706','240',1037197.74,1037197.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','255735',4873517,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','255735',4873518,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','255735',4873519,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','255735',4873520,'2710','240',1030992.10,1030992.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','255735',4873521,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','255735',4873522,'2712','240',1292939.84,1292939.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','256154',4880642,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','256154',4880643,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','256154',4880644,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','256154',4880645,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','256154',4880646,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','256154',4880647,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','256154',4880648,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','256154',4880649,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','256154',4880650,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','256154',4880651,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','256154',4880652,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','256154',4880653,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','256154',4880654,'2706','240',1037197.74,1037197.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','256154',4880655,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','256154',4880656,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','256154',4880657,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','256154',4880658,'2710','240',1030992.10,1030992.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','256154',4880659,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','256154',4880660,'2712','240',1292939.84,1292939.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','256461',4885785,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','256461',4885786,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','256461',4885787,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','256461',4885788,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','256461',4885789,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','256461',4885790,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','256461',4885791,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','256461',4885792,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','256461',4885793,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','256461',4885794,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','256461',4885795,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','256461',4885796,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','256461',4885797,'2706','240',1037197.74,1037197.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','256461',4885798,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','256461',4885799,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','256461',4885800,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','256461',4885801,'2710','240',1030992.10,1030992.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','256461',4885802,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','256461',4885803,'2712','240',1292939.84,1292939.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','256599',4887944,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','256599',4887945,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','256599',4887946,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','256599',4887947,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','256599',4887948,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','256599',4887949,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','256599',4887950,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','256599',4887951,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','256599',4887952,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','256599',4887953,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','256599',4887954,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','256599',4887955,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','256599',4887956,'2706','240',1037197.74,1037197.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','256599',4887957,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','256599',4887958,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','256599',4887959,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','256599',4887960,'2710','240',1030992.10,1031824.22,832.12,137299.80,0.00,0.00,0.00,0.00,0.00),('5','101','917','256599',4887961,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','256599',4887962,'2712','240',1292939.84,1293519.92,580.08,95713.20,0.00,0.00,0.00,0.00,0.00),('5','101','620','256816',4891493,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','256816',4891494,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','256816',4891495,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','256816',4891496,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','256816',4891497,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','256816',4891498,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','256816',4891499,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','256816',4891500,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','256816',4891501,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','256816',4891502,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','256816',4891503,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','256816',4891504,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','256816',4891505,'2706','240',1037197.74,1037197.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','256816',4891506,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','256816',4891507,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','256816',4891508,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','256816',4891509,'2710','240',1031824.22,1036396.52,4572.30,754429.50,0.00,0.00,0.00,0.00,0.00),('5','101','917','256816',4891510,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','256816',4891511,'2712','240',1293519.92,1297554.28,4034.36,665669.40,0.00,0.00,0.00,0.00,0.00),('5','101','620','256998',4894579,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','256998',4894580,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','256998',4894581,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','256998',4894582,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','256998',4894583,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','256998',4894584,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','256998',4894585,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','256998',4894586,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','256998',4894587,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','256998',4894588,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','256998',4894589,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','256998',4894590,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','256998',4894591,'2706','240',1037197.74,1037197.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','256998',4894592,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','256998',4894593,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','256998',4894594,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','256998',4894595,'2710','240',1036396.52,1039131.96,2735.44,451347.60,0.00,0.00,0.00,0.00,0.00),('5','101','917','256998',4894596,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','256998',4894597,'2712','240',1297554.28,1303312.15,5757.87,950048.55,0.00,0.00,0.00,0.00,0.00),('5','101','620','257298',4900126,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257298',4900127,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257298',4900128,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257298',4900129,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257298',4900130,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257298',4900131,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257298',4900132,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257298',4900133,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257298',4900134,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257298',4900135,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257298',4900136,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257298',4900137,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257298',4900138,'2706','240',1037197.74,1037197.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257298',4900139,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257298',4900140,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257298',4900141,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257298',4900142,'2710','240',1039131.96,1043165.38,4033.42,665514.30,0.00,0.00,0.00,0.00,0.00),('5','101','917','257298',4900143,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257298',4900144,'2712','240',1303312.15,1307801.23,4489.08,740698.20,0.00,0.00,0.00,0.00,0.00),('5','101','620','257534',4904024,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257534',4904025,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257534',4904026,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257534',4904027,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257534',4904028,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257534',4904029,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257534',4904030,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257534',4904031,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257534',4904032,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257534',4904033,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257534',4904034,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257534',4904035,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257534',4904036,'2706','240',1037197.74,1037197.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257534',4904037,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257534',4904038,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257534',4904039,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257534',4904040,'2710','240',1043165.38,1047574.98,4409.60,727584.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257534',4904041,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257534',4904042,'2712','240',1307801.23,1312826.82,5025.59,829222.35,0.00,0.00,0.00,0.00,0.00),('5','101','620','257535',4904043,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257535',4904044,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257535',4904045,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257535',4904046,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257535',4904047,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257535',4904048,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257535',4904049,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257535',4904050,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257535',4904051,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257535',4904052,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257535',4904053,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257535',4904054,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257535',4904055,'2706','240',1037197.74,1037197.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257535',4904056,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257535',4904057,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257535',4904058,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257535',4904059,'2710','240',1047574.98,1049234.42,1659.44,273807.60,0.00,0.00,0.00,0.00,0.00),('5','101','917','257535',4904060,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257535',4904061,'2712','240',1312826.82,1314318.24,1491.42,246084.30,0.00,0.00,0.00,0.00,0.00),('5','101','620','257536',4904062,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257536',4904063,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257536',4904064,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257536',4904065,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257536',4904066,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257536',4904067,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257536',4904068,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257536',4904069,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257536',4904070,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257536',4904071,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257536',4904072,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257536',4904073,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257536',4904074,'2706','240',1037197.74,1037197.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257536',4904075,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257536',4904076,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257536',4904077,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257536',4904078,'2710','240',1049234.42,1049234.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257536',4904079,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257536',4904080,'2712','240',1314318.24,1314318.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257537',4904081,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257537',4904082,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257537',4904083,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257537',4904084,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257537',4904085,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257537',4904086,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257537',4904087,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257537',4904088,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257537',4904089,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257537',4904090,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257537',4904091,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257537',4904092,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257537',4904093,'2706','240',1037197.74,1037197.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257537',4904094,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257537',4904095,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257537',4904096,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257537',4904097,'2710','240',1049234.42,1050237.20,1002.78,165458.70,0.00,0.00,0.00,0.00,0.00),('5','101','917','257537',4904098,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257537',4904099,'2712','240',1314318.24,1315129.44,811.20,133848.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257538',4904100,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257538',4904101,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257538',4904102,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257538',4904103,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257538',4904104,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257538',4904105,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257538',4904106,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257538',4904107,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257538',4904108,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257538',4904109,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257538',4904110,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257538',4904111,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257538',4904112,'2706','240',1037197.74,1037197.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257538',4904113,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257538',4904114,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257538',4904115,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257538',4904116,'2710','240',1050237.20,1053218.47,2981.27,491909.55,0.00,0.00,0.00,0.00,0.00),('5','101','917','257538',4904117,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257538',4904118,'2712','240',1315129.44,1319146.81,4017.37,662866.05,0.00,0.00,0.00,0.00,0.00),('5','101','620','257539',4904119,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257539',4904120,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257539',4904121,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257539',4904122,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257539',4904123,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257539',4904124,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257539',4904125,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257539',4904126,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257539',4904127,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257539',4904128,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257539',4904129,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257539',4904130,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257539',4904131,'2706','240',1037197.74,1037197.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257539',4904132,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257539',4904133,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257539',4904134,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257539',4904135,'2710','240',1053218.47,1057957.78,4739.31,781986.15,0.00,0.00,0.00,0.00,0.00),('5','101','917','257539',4904136,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257539',4904137,'2712','240',1319146.81,1323536.44,4389.63,724288.95,0.00,0.00,0.00,0.00,0.00),('5','101','620','257540',4904138,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257540',4904139,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257540',4904140,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257540',4904141,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257540',4904142,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257540',4904143,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257540',4904144,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257540',4904145,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257540',4904146,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257540',4904147,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257540',4904148,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257540',4904149,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257540',4904150,'2706','240',1037197.74,1037197.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257540',4904151,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257540',4904152,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257540',4904153,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257540',4904154,'2710','240',1057957.78,1061799.58,3841.80,633897.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257540',4904155,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257540',4904156,'2712','240',1323536.44,1328228.63,4692.19,774211.35,0.00,0.00,0.00,0.00,0.00),('5','101','620','257541',4904157,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257541',4904158,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257541',4904159,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257541',4904160,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257541',4904161,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257541',4904162,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257541',4904163,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257541',4904164,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257541',4904165,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257541',4904166,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257541',4904167,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257541',4904168,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257541',4904169,'2706','240',1037197.74,1037197.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257541',4904170,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257541',4904171,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257541',4904172,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257541',4904173,'2710','240',1061799.58,1066175.82,4376.24,722079.60,0.00,0.00,0.00,0.00,0.00),('5','101','917','257541',4904174,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257541',4904175,'2712','240',1328228.63,1333193.25,4964.62,819162.30,0.00,0.00,0.00,0.00,0.00),('5','101','620','257542',4904176,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257542',4904177,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257542',4904178,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257542',4904179,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257542',4904180,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257542',4904181,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257542',4904182,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257542',4904183,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257542',4904184,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257542',4904185,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257542',4904186,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257542',4904187,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257542',4904188,'2706','240',1037197.74,1037197.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257542',4904189,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257542',4904190,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257542',4904191,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257542',4904192,'2710','240',1066175.82,1068387.76,2211.94,364970.10,0.00,0.00,0.00,0.00,0.00),('5','101','917','257542',4904193,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257542',4904194,'2712','240',1333193.25,1335537.51,2344.26,386802.90,0.00,0.00,0.00,0.00,0.00),('5','101','620','257543',4904195,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257543',4904196,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257543',4904197,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257543',4904198,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257543',4904199,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257543',4904200,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257543',4904201,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257543',4904202,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257543',4904203,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257543',4904204,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257543',4904205,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257543',4904206,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257543',4904207,'2706','240',1037197.74,1037197.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257543',4904208,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257543',4904209,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257543',4904210,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257543',4904211,'2710','240',1068387.76,1068387.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257543',4904212,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257543',4904213,'2712','240',1335537.51,1335537.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257544',4904214,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257544',4904215,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257544',4904216,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257544',4904217,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257544',4904218,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257544',4904219,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257544',4904220,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257544',4904221,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257544',4904222,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257544',4904223,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257544',4904224,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257544',4904225,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257544',4904226,'2706','240',1037197.74,1037197.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257544',4904227,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257544',4904228,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257544',4904229,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257544',4904230,'2710','240',1068387.76,1068387.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257544',4904231,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257544',4904232,'2712','240',1335537.51,1335537.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257545',4904233,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257545',4904234,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257545',4904235,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257545',4904236,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257545',4904237,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257545',4904238,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257545',4904239,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257545',4904240,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257545',4904241,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257545',4904242,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257545',4904243,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257545',4904244,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257545',4904245,'2706','240',1037197.74,1037197.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257545',4904246,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257545',4904247,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257545',4904248,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257545',4904249,'2710','240',1068387.76,1068387.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257545',4904250,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257545',4904251,'2712','240',1335537.51,1335537.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257546',4904252,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257546',4904253,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257546',4904254,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257546',4904255,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257546',4904256,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257546',4904257,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257546',4904258,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257546',4904259,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257546',4904260,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257546',4904261,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257546',4904262,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257546',4904263,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257546',4904264,'2706','240',1037197.74,1037197.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257546',4904265,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257546',4904266,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257546',4904267,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257546',4904268,'2710','240',1068387.76,1068387.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257546',4904269,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257546',4904270,'2712','240',1335537.51,1335537.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257547',4904271,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257547',4904272,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257547',4904273,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257547',4904274,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257547',4904275,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257547',4904276,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257547',4904277,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257547',4904278,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257547',4904279,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257547',4904280,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257547',4904281,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257547',4904282,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257547',4904283,'2706','240',1037197.74,1037197.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257547',4904284,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257547',4904285,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257547',4904286,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257547',4904287,'2710','240',1068387.76,1068387.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257547',4904288,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257547',4904289,'2712','240',1335537.51,1335537.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257548',4904290,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257548',4904291,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257548',4904292,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257548',4904293,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257548',4904294,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257548',4904295,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257548',4904296,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257548',4904297,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257548',4904298,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257548',4904299,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257548',4904300,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257548',4904301,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257548',4904302,'2706','240',1037197.74,1037197.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257548',4904303,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257548',4904304,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257548',4904305,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257548',4904306,'2710','240',1068387.76,1069415.30,1027.54,169544.10,0.00,0.00,0.00,0.00,0.00),('5','101','917','257548',4904307,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257548',4904308,'2712','240',1335537.51,1335537.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257549',4904309,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257549',4904310,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257549',4904311,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257549',4904312,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257549',4904313,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257549',4904314,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257549',4904315,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257549',4904316,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257549',4904317,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257549',4904318,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257549',4904319,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257549',4904320,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257549',4904321,'2706','240',1037197.74,1037197.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257549',4904322,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257549',4904323,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257549',4904324,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257549',4904325,'2710','240',1069415.30,1069953.94,538.64,88875.60,0.00,0.00,0.00,0.00,0.00),('5','101','917','257549',4904326,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257549',4904327,'2712','240',1335537.51,1343517.33,7979.82,1316670.30,0.00,0.00,0.00,0.00,0.00),('5','101','620','257550',4904328,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257550',4904329,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257550',4904330,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257550',4904331,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257550',4904332,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257550',4904333,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257550',4904334,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257550',4904335,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257550',4904336,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257550',4904337,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257550',4904338,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257550',4904339,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257550',4904340,'2706','240',1037197.74,1037197.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257550',4904341,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257550',4904342,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257550',4904343,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257550',4904344,'2710','240',1069953.94,1073175.89,3221.95,531621.75,0.00,0.00,0.00,0.00,0.00),('5','101','917','257550',4904345,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257550',4904346,'2712','240',1343517.33,1349569.41,6052.08,998593.20,0.00,0.00,0.00,0.00,0.00),('5','101','620','257551',4904347,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257551',4904348,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257551',4904349,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257551',4904350,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257551',4904351,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257551',4904352,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257551',4904353,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257551',4904354,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257551',4904355,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257551',4904356,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257551',4904357,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257551',4904358,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257551',4904359,'2706','240',1037197.74,1037197.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257551',4904360,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257551',4904361,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257551',4904362,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257551',4904363,'2710','240',1073175.89,1076844.83,3668.94,605375.10,0.00,0.00,0.00,0.00,0.00),('5','101','917','257551',4904364,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257551',4904365,'2712','240',1349569.41,1354954.55,5385.14,888548.10,0.00,0.00,0.00,0.00,0.00),('5','101','620','257552',4904366,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257552',4904367,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257552',4904368,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257552',4904369,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257552',4904370,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257552',4904371,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257552',4904372,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257552',4904373,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257552',4904374,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257552',4904375,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257552',4904376,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257552',4904377,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257552',4904378,'2706','240',1037197.74,1037197.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257552',4904379,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257552',4904380,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257552',4904381,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257552',4904382,'2710','240',1076844.83,1078846.93,2002.10,330346.50,0.00,0.00,0.00,0.00,0.00),('5','101','917','257552',4904383,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257552',4904384,'2712','240',1354954.55,1354954.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257553',4904385,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257553',4904386,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257553',4904387,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257553',4904388,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257553',4904389,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257553',4904390,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257553',4904391,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257553',4904392,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257553',4904393,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257553',4904394,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257553',4904395,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257553',4904396,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257553',4904397,'2706','240',1037197.74,1037197.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257553',4904398,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257553',4904399,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257553',4904400,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257553',4904401,'2710','240',1078846.93,1078846.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257553',4904402,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257553',4904403,'2712','240',1354954.55,1354954.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257554',4904404,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257554',4904405,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257554',4904406,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257554',4904407,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257554',4904408,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257554',4904409,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257554',4904410,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257554',4904411,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257554',4904412,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257554',4904413,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257554',4904414,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257554',4904415,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257554',4904416,'2706','240',1037197.74,1037197.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257554',4904417,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257554',4904418,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257554',4904419,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257554',4904420,'2710','240',1078846.93,1078846.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257554',4904421,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257554',4904422,'2712','240',1354954.55,1356175.60,1221.05,201473.25,0.00,0.00,0.00,0.00,0.00),('5','101','620','257555',4904423,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257555',4904424,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257555',4904425,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257555',4904426,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257555',4904427,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257555',4904428,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257555',4904429,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257555',4904430,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257555',4904431,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257555',4904432,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257555',4904433,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257555',4904434,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257555',4904435,'2706','240',1037197.74,1037197.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257555',4904436,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257555',4904437,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257555',4904438,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257555',4904439,'2710','240',1078846.93,1085842.23,6995.30,1154224.50,0.00,0.00,0.00,0.00,0.00),('5','101','917','257555',4904440,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257555',4904441,'2712','240',1356175.60,1358963.97,2788.37,460081.05,0.00,0.00,0.00,0.00,0.00),('5','101','620','257556',4904442,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257556',4904443,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257556',4904444,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257556',4904445,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257556',4904446,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257556',4904447,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257556',4904448,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257556',4904449,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257556',4904450,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257556',4904451,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257556',4904452,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257556',4904453,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257556',4904454,'2706','240',1037197.74,1037197.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257556',4904455,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257556',4904456,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257556',4904457,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257556',4904458,'2710','240',1085842.23,1088969.83,3127.60,516054.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257556',4904459,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257556',4904460,'2712','240',1358963.97,1364546.63,5582.66,921138.90,0.00,0.00,0.00,0.00,0.00),('5','101','620','257557',4904461,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257557',4904462,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257557',4904463,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257557',4904464,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257557',4904465,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257557',4904466,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257557',4904467,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257557',4904468,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257557',4904469,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257557',4904470,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257557',4904471,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257557',4904472,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257557',4904473,'2706','240',1037197.74,1037197.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257557',4904474,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257557',4904475,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257557',4904476,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257557',4904477,'2710','240',1088969.83,1095307.64,6337.81,1045738.65,0.00,0.00,0.00,0.00,0.00),('5','101','917','257557',4904478,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257557',4904479,'2712','240',1364546.63,1372079.67,7533.04,1242951.60,0.00,0.00,0.00,0.00,0.00),('5','101','620','257558',4904480,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257558',4904481,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257558',4904482,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257558',4904483,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257558',4904484,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257558',4904485,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257558',4904486,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257558',4904487,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257558',4904488,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257558',4904489,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257558',4904490,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257558',4904491,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257558',4904492,'2706','240',1037197.74,1037197.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257558',4904493,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257558',4904494,'2708','240',1687044.55,1687044.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257558',4904495,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257558',4904496,'2710','240',1095307.64,1096843.76,1536.12,253459.80,0.00,0.00,0.00,0.00,0.00),('5','101','917','257558',4904497,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257558',4904498,'2712','240',1372079.67,1377079.01,4999.34,824891.10,0.00,0.00,0.00,0.00,0.00),('5','101','620','257559',4904499,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257559',4904500,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257559',4904501,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257559',4904502,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257559',4904503,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257559',4904504,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257559',4904505,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257559',4904506,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257559',4904507,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257559',4904508,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257559',4904509,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257559',4904510,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257559',4904511,'2706','240',1037197.74,1042083.24,4885.50,806107.50,0.00,0.00,0.00,0.00,0.00),('5','101','916','257559',4904512,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257559',4904513,'2708','240',1687044.55,1692714.44,5669.89,935531.85,0.00,0.00,0.00,0.00,0.00),('5','101','917','257559',4904514,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257559',4904515,'2710','240',1096843.76,1096843.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257559',4904516,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257559',4904517,'2712','240',1377079.01,1377079.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257560',4904518,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257560',4904519,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257560',4904520,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257560',4904521,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257560',4904522,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257560',4904523,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257560',4904524,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257560',4904525,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257560',4904526,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257560',4904527,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257560',4904528,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257560',4904529,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257560',4904530,'2706','240',1042083.24,1049347.17,7263.93,1198548.45,0.00,0.00,0.00,0.00,0.00),('5','101','916','257560',4904531,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257560',4904532,'2708','240',1692714.44,1692714.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257560',4904533,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257560',4904534,'2710','240',1096843.76,1099376.64,2532.88,417925.20,0.00,0.00,0.00,0.00,0.00),('5','101','917','257560',4904535,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257560',4904536,'2712','240',1377079.01,1377079.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257561',4904537,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257561',4904538,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257561',4904539,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257561',4904540,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257561',4904541,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257561',4904542,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257561',4904543,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257561',4904544,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257561',4904545,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257561',4904546,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257561',4904547,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257561',4904548,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257561',4904549,'2706','240',1049347.17,1057095.93,7748.76,1278545.40,0.00,0.00,0.00,0.00,0.00),('5','101','916','257561',4904550,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257561',4904551,'2708','240',1692714.44,1692714.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257561',4904552,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257561',4904553,'2710','240',1099376.64,1101634.21,2257.57,372499.05,0.00,0.00,0.00,0.00,0.00),('5','101','917','257561',4904554,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257561',4904555,'2712','240',1377079.01,1377079.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257562',4904556,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257562',4904557,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257562',4904558,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257562',4904559,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257562',4904560,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257562',4904561,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257562',4904562,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257562',4904563,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257562',4904564,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257562',4904565,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257562',4904566,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257562',4904567,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257562',4904568,'2706','240',1057095.93,1062105.12,5009.19,826516.35,0.00,0.00,0.00,0.00,0.00),('5','101','916','257562',4904569,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257562',4904570,'2708','240',1692714.44,1692714.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257562',4904571,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257562',4904572,'2710','240',1101634.21,1106590.00,4955.79,817705.35,0.00,0.00,0.00,0.00,0.00),('5','101','917','257562',4904573,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257562',4904574,'2712','240',1377079.01,1377079.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257563',4904575,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257563',4904576,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257563',4904577,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257563',4904578,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257563',4904579,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257563',4904580,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257563',4904581,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257563',4904582,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257563',4904583,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257563',4904584,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257563',4904585,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257563',4904586,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257563',4904587,'2706','240',1062105.12,1070292.36,8187.24,1350894.60,0.00,0.00,0.00,0.00,0.00),('5','101','916','257563',4904588,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257563',4904589,'2708','240',1692714.44,1692714.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257563',4904590,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257563',4904591,'2710','240',1106590.00,1108655.81,2065.81,340858.65,0.00,0.00,0.00,0.00,0.00),('5','101','917','257563',4904592,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257563',4904593,'2712','240',1377079.01,1377079.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257564',4904594,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257564',4904595,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257564',4904596,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257564',4904597,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257564',4904598,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257564',4904599,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257564',4904600,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257564',4904601,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257564',4904602,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257564',4904603,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257564',4904604,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257564',4904605,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257564',4904606,'2706','240',1070292.36,1070292.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257564',4904607,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257564',4904608,'2708','240',1692714.44,1692714.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257564',4904609,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257564',4904610,'2710','240',1108655.81,1111576.04,2920.23,481837.95,0.00,0.00,0.00,0.00,0.00),('5','101','917','257564',4904611,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257564',4904612,'2712','240',1377079.01,1377079.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257565',4904613,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257565',4904614,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257565',4904615,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257565',4904616,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257565',4904617,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257565',4904618,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257565',4904619,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257565',4904620,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257565',4904621,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257565',4904622,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257565',4904623,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257565',4904624,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257565',4904625,'2706','240',1070292.36,1070292.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257565',4904626,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257565',4904627,'2708','240',1692714.44,1692714.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257565',4904628,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257565',4904629,'2710','240',1111576.04,1111576.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257565',4904630,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257565',4904631,'2712','240',1377079.01,1377079.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257566',4904632,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257566',4904633,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257566',4904634,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257566',4904635,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257566',4904636,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257566',4904637,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257566',4904638,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257566',4904639,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257566',4904640,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257566',4904641,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257566',4904642,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257566',4904643,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257566',4904644,'2706','240',1070292.36,1070292.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257566',4904645,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257566',4904646,'2708','240',1692714.44,1692714.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257566',4904647,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257566',4904648,'2710','240',1111576.04,1117867.10,6291.06,1038024.90,0.00,0.00,0.00,0.00,0.00),('5','101','917','257566',4904649,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257566',4904650,'2712','240',1377079.01,1380018.69,2939.68,485047.20,0.00,0.00,0.00,0.00,0.00),('5','101','620','257567',4904651,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257567',4904652,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257567',4904653,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257567',4904654,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257567',4904655,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257567',4904656,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257567',4904657,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257567',4904658,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257567',4904659,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257567',4904660,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257567',4904661,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257567',4904662,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257567',4904663,'2706','240',1070292.36,1070292.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257567',4904664,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257567',4904665,'2708','240',1692714.44,1692714.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257567',4904666,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257567',4904667,'2710','240',1117867.10,1121463.47,3596.37,593401.05,0.00,0.00,0.00,0.00,0.00),('5','101','917','257567',4904668,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257567',4904669,'2712','240',1380018.69,1380941.22,922.53,152217.45,0.00,0.00,0.00,0.00,0.00),('5','101','620','257568',4904670,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257568',4904671,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257568',4904672,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257568',4904673,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257568',4904674,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257568',4904675,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257568',4904676,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257568',4904677,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257568',4904678,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257568',4904679,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257568',4904680,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257568',4904681,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257568',4904682,'2706','240',1070292.36,1070786.94,494.58,81605.70,0.00,0.00,0.00,0.00,0.00),('5','101','916','257568',4904683,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257568',4904684,'2708','240',1692714.44,1692714.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257568',4904685,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257568',4904686,'2710','240',1121463.47,1121629.13,165.66,27333.90,0.00,0.00,0.00,0.00,0.00),('5','101','917','257568',4904687,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257568',4904688,'2712','240',1380941.22,1381802.27,861.05,142073.25,0.00,0.00,0.00,0.00,0.00),('5','101','620','257569',4904689,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257569',4904690,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257569',4904691,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257569',4904692,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257569',4904693,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257569',4904694,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257569',4904695,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257569',4904696,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257569',4904697,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257569',4904698,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257569',4904699,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257569',4904700,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257569',4904701,'2706','240',1070786.94,1076579.23,5792.29,955727.85,0.00,0.00,0.00,0.00,0.00),('5','101','916','257569',4904702,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257569',4904703,'2708','240',1692714.44,1695709.91,2995.47,494252.55,0.00,0.00,0.00,0.00,0.00),('5','101','917','257569',4904704,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257569',4904705,'2710','240',1121629.13,1121629.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257569',4904706,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257569',4904707,'2712','240',1381802.27,1381802.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257570',4904708,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257570',4904709,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257570',4904710,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257570',4904711,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257570',4904712,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257570',4904713,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257570',4904714,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257570',4904715,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257570',4904716,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257570',4904717,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257570',4904718,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257570',4904719,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257570',4904720,'2706','240',1076579.23,1079549.31,2970.08,490063.20,0.00,0.00,0.00,0.00,0.00),('5','101','916','257570',4904721,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257570',4904722,'2708','240',1695709.91,1696392.19,682.28,112576.20,0.00,0.00,0.00,0.00,0.00),('5','101','917','257570',4904723,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257570',4904724,'2710','240',1121629.13,1121629.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257570',4904725,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257570',4904726,'2712','240',1381802.27,1381802.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257571',4904727,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257571',4904728,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257571',4904729,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257571',4904730,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257571',4904731,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257571',4904732,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257571',4904733,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257571',4904734,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257571',4904735,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257571',4904736,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257571',4904737,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257571',4904738,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257571',4904739,'2706','240',1079549.31,1079549.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257571',4904740,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257571',4904741,'2708','240',1696392.19,1696392.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257571',4904742,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257571',4904743,'2710','240',1121629.13,1121629.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257571',4904744,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257571',4904745,'2712','240',1381802.27,1381802.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257572',4904746,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257572',4904747,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257572',4904748,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257572',4904749,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257572',4904750,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257572',4904751,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257572',4904752,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257572',4904753,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257572',4904754,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257572',4904755,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257572',4904756,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257572',4904757,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257572',4904758,'2706','240',1079549.31,1079549.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257572',4904759,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257572',4904760,'2708','240',1696392.19,1696392.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257572',4904761,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257572',4904762,'2710','240',1121629.13,1121629.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257572',4904763,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257572',4904764,'2712','240',1381802.27,1381802.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257573',4904765,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257573',4904766,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257573',4904767,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257573',4904768,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257573',4904769,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257573',4904770,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257573',4904771,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257573',4904772,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257573',4904773,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257573',4904774,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257573',4904775,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257573',4904776,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257573',4904777,'2706','240',1079549.31,1080236.44,687.13,113376.45,0.00,0.00,0.00,0.00,0.00),('5','101','916','257573',4904778,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257573',4904779,'2708','240',1696392.19,1696392.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257573',4904780,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257573',4904781,'2710','240',1121629.13,1121629.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257573',4904782,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257573',4904783,'2712','240',1381802.27,1381802.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257574',4904784,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257574',4904785,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257574',4904786,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257574',4904787,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257574',4904788,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257574',4904789,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257574',4904790,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257574',4904791,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257574',4904792,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257574',4904793,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257574',4904794,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257574',4904795,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257574',4904796,'2706','240',1080236.44,1080236.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257574',4904797,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257574',4904798,'2708','240',1696392.19,1696392.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257574',4904799,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257574',4904800,'2710','240',1121629.13,1121629.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257574',4904801,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257574',4904802,'2712','240',1381802.27,1381802.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257575',4904803,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257575',4904804,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257575',4904805,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257575',4904806,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257575',4904807,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257575',4904808,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257575',4904809,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257575',4904810,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257575',4904811,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257575',4904812,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257575',4904813,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257575',4904814,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257575',4904815,'2706','240',1080236.44,1085953.83,5717.39,943369.35,0.00,0.00,0.00,0.00,0.00),('5','101','916','257575',4904816,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257575',4904817,'2708','240',1696392.19,1700623.03,4230.84,698088.60,0.00,0.00,0.00,0.00,0.00),('5','101','917','257575',4904818,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257575',4904819,'2710','240',1121629.13,1121629.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257575',4904820,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257575',4904821,'2712','240',1381802.27,1381802.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257576',4904822,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257576',4904823,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257576',4904824,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257576',4904825,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257576',4904826,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257576',4904827,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257576',4904828,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257576',4904829,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257576',4904830,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257576',4904831,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257576',4904832,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257576',4904833,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257576',4904834,'2706','240',1085953.83,1092030.21,6076.38,1002602.70,0.00,0.00,0.00,0.00,0.00),('5','101','916','257576',4904835,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257576',4904836,'2708','240',1700623.03,1706482.58,5859.55,966825.75,0.00,0.00,0.00,0.00,0.00),('5','101','917','257576',4904837,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257576',4904838,'2710','240',1121629.13,1121629.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257576',4904839,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257576',4904840,'2712','240',1381802.27,1381802.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257577',4904841,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257577',4904842,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257577',4904843,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257577',4904844,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257577',4904845,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257577',4904846,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257577',4904847,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257577',4904848,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257577',4904849,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257577',4904850,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257577',4904851,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257577',4904852,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257577',4904853,'2706','240',1092030.21,1098474.84,6444.63,1063363.95,0.00,0.00,0.00,0.00,0.00),('5','101','916','257577',4904854,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257577',4904855,'2708','240',1706482.58,1708497.72,2015.14,332498.10,0.00,0.00,0.00,0.00,0.00),('5','101','917','257577',4904856,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257577',4904857,'2710','240',1121629.13,1121629.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257577',4904858,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257577',4904859,'2712','240',1381802.27,1381802.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257578',4904860,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257578',4904861,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257578',4904862,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257578',4904863,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257578',4904864,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257578',4904865,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257578',4904866,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257578',4904867,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257578',4904868,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257578',4904869,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257578',4904870,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257578',4904871,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257578',4904872,'2706','240',1098474.84,1105196.88,6722.04,1109136.60,0.00,0.00,0.00,0.00,0.00),('5','101','916','257578',4904873,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257578',4904874,'2708','240',1708497.72,1710911.50,2413.78,398273.70,0.00,0.00,0.00,0.00,0.00),('5','101','917','257578',4904875,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257578',4904876,'2710','240',1121629.13,1121629.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257578',4904877,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257578',4904878,'2712','240',1381802.27,1381802.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257579',4904879,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257579',4904880,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257579',4904881,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257579',4904882,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257579',4904883,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257579',4904884,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257579',4904885,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257579',4904886,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257579',4904887,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257579',4904888,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257579',4904889,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257579',4904890,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257579',4904891,'2706','240',1105196.88,1105196.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257579',4904892,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257579',4904893,'2708','240',1710911.50,1710911.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257579',4904894,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257579',4904895,'2710','240',1121629.13,1121629.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257579',4904896,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257579',4904897,'2712','240',1381802.27,1381802.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257580',4904898,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257580',4904899,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257580',4904900,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257580',4904901,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257580',4904902,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257580',4904903,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257580',4904904,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257580',4904905,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257580',4904906,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257580',4904907,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257580',4904908,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257580',4904909,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257580',4904910,'2706','240',1105196.88,1105196.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257580',4904911,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257580',4904912,'2708','240',1710911.50,1710911.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257580',4904913,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257580',4904914,'2710','240',1121629.13,1121629.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257580',4904915,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257580',4904916,'2712','240',1381802.27,1381802.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257581',4904917,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257581',4904918,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257581',4904919,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257581',4904920,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257581',4904921,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257581',4904922,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257581',4904923,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257581',4904924,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257581',4904925,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257581',4904926,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257581',4904927,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257581',4904928,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257581',4904929,'2706','240',1105196.88,1105196.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257581',4904930,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257581',4904931,'2708','240',1710911.50,1710911.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257581',4904932,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257581',4904933,'2710','240',1121629.13,1121629.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257581',4904934,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257581',4904935,'2712','240',1381802.27,1381802.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257582',4904936,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257582',4904937,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257582',4904938,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257582',4904939,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257582',4904940,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257582',4904941,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257582',4904942,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257582',4904943,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257582',4904944,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257582',4904945,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257582',4904946,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257582',4904947,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257582',4904948,'2706','240',1105196.88,1105196.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257582',4904949,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257582',4904950,'2708','240',1710911.50,1710911.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257582',4904951,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257582',4904952,'2710','240',1121629.13,1121629.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257582',4904953,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257582',4904954,'2712','240',1381802.27,1381802.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257583',4904955,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257583',4904956,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257583',4904957,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257583',4904958,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257583',4904959,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257583',4904960,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257583',4904961,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257583',4904962,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257583',4904963,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257583',4904964,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257583',4904965,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257583',4904966,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257583',4904967,'2706','240',1105196.88,1105196.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257583',4904968,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257583',4904969,'2708','240',1710911.50,1710911.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257583',4904970,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257583',4904971,'2710','240',1121629.13,1121629.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257583',4904972,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257583',4904973,'2712','240',1381802.27,1381802.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257584',4904974,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257584',4904975,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257584',4904976,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257584',4904977,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257584',4904978,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257584',4904979,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257584',4904980,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257584',4904981,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257584',4904982,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257584',4904983,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257584',4904984,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257584',4904985,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257584',4904986,'2706','240',1105196.88,1106155.05,958.17,158098.05,0.00,0.00,0.00,0.00,0.00),('5','101','916','257584',4904987,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257584',4904988,'2708','240',1710911.50,1710911.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257584',4904989,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257584',4904990,'2710','240',1121629.13,1121629.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257584',4904991,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257584',4904992,'2712','240',1381802.27,1381802.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257585',4904993,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257585',4904994,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257585',4904995,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257585',4904996,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257585',4904997,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257585',4904998,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257585',4904999,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257585',4905000,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257585',4905001,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257585',4905002,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257585',4905003,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257585',4905004,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257585',4905005,'2706','240',1106155.05,1106155.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257585',4905006,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257585',4905007,'2708','240',1710911.50,1710911.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257585',4905008,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257585',4905009,'2710','240',1121629.13,1121629.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257585',4905010,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257585',4905011,'2712','240',1381802.27,1381802.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257586',4905012,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257586',4905013,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257586',4905014,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257586',4905015,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257586',4905016,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257586',4905017,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257586',4905018,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257586',4905019,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257586',4905020,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257586',4905021,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257586',4905022,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257586',4905023,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257586',4905024,'2706','240',1106155.05,1106155.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257586',4905025,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257586',4905026,'2708','240',1710911.50,1710911.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257586',4905027,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257586',4905028,'2710','240',1121629.13,1121629.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257586',4905029,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257586',4905030,'2712','240',1381802.27,1381802.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257587',4905031,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257587',4905032,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257587',4905033,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257587',4905034,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257587',4905035,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257587',4905036,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257587',4905037,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257587',4905038,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257587',4905039,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257587',4905040,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257587',4905041,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257587',4905042,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257587',4905043,'2706','240',1106155.05,1107366.55,1211.50,199897.50,0.00,0.00,0.00,0.00,0.00),('5','101','916','257587',4905044,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257587',4905045,'2708','240',1710911.50,1711734.55,823.05,135803.25,0.00,0.00,0.00,0.00,0.00),('5','101','917','257587',4905046,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257587',4905047,'2710','240',1121629.13,1121629.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257587',4905048,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257587',4905049,'2712','240',1381802.27,1381802.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257588',4905050,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257588',4905051,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257588',4905052,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257588',4905053,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257588',4905054,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257588',4905055,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257588',4905056,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257588',4905057,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257588',4905058,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257588',4905059,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257588',4905060,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257588',4905061,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257588',4905062,'2706','240',1107366.55,1111715.69,4349.14,717608.10,0.00,0.00,0.00,0.00,0.00),('5','101','916','257588',4905063,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257588',4905064,'2708','240',1711734.55,1717011.79,5277.24,870744.60,0.00,0.00,0.00,0.00,0.00),('5','101','917','257588',4905065,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257588',4905066,'2710','240',1121629.13,1121629.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257588',4905067,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257588',4905068,'2712','240',1381802.27,1381802.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257589',4905069,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257589',4905070,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257589',4905071,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257589',4905072,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257589',4905073,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257589',4905074,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257589',4905075,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257589',4905076,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257589',4905077,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257589',4905078,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257589',4905079,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257589',4905080,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257589',4905081,'2706','240',1111715.69,1113829.93,2114.24,348849.60,0.00,0.00,0.00,0.00,0.00),('5','101','916','257589',4905082,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257589',4905083,'2708','240',1717011.79,1724513.20,7501.41,1237732.65,0.00,0.00,0.00,0.00,0.00),('5','101','917','257589',4905084,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257589',4905085,'2710','240',1121629.13,1121629.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257589',4905086,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257589',4905087,'2712','240',1381802.27,1381802.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257590',4905088,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257590',4905089,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257590',4905090,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257590',4905091,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257590',4905092,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257590',4905093,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257590',4905094,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257590',4905095,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257590',4905096,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257590',4905097,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257590',4905098,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257590',4905099,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257590',4905100,'2706','240',1113829.93,1116305.54,2475.61,408475.65,0.00,0.00,0.00,0.00,0.00),('5','101','916','257590',4905101,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257590',4905102,'2708','240',1724513.20,1730394.76,5881.56,970457.40,0.00,0.00,0.00,0.00,0.00),('5','101','917','257590',4905103,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257590',4905104,'2710','240',1121629.13,1121629.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257590',4905105,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257590',4905106,'2712','240',1381802.27,1381802.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257591',4905107,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257591',4905108,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257591',4905109,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257591',4905110,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257591',4905111,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257591',4905112,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257591',4905113,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257591',4905114,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257591',4905115,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257591',4905116,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257591',4905117,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257591',4905118,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257591',4905119,'2706','240',1116305.54,1117493.96,1188.42,196089.30,0.00,0.00,0.00,0.00,0.00),('5','101','916','257591',4905120,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257591',4905121,'2708','240',1730394.76,1736561.82,6167.06,1017564.90,0.00,0.00,0.00,0.00,0.00),('5','101','917','257591',4905122,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257591',4905123,'2710','240',1121629.13,1121629.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257591',4905124,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257591',4905125,'2712','240',1381802.27,1381802.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257592',4905126,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257592',4905127,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257592',4905128,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257592',4905129,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257592',4905130,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257592',4905131,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257592',4905132,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257592',4905133,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257592',4905134,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257592',4905135,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257592',4905136,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257592',4905137,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257592',4905138,'2706','240',1117493.96,1119434.62,1940.66,320208.90,0.00,0.00,0.00,0.00,0.00),('5','101','916','257592',4905139,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257592',4905140,'2708','240',1736561.82,1737361.82,800.00,132000.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257592',4905141,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257592',4905142,'2710','240',1121629.13,1121629.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257592',4905143,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257592',4905144,'2712','240',1381802.27,1381802.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257593',4905145,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257593',4905146,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257593',4905147,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257593',4905148,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257593',4905149,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257593',4905150,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257593',4905151,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257593',4905152,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257593',4905153,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257593',4905154,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257593',4905155,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257593',4905156,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257593',4905157,'2706','240',1119434.62,1119434.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257593',4905158,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257593',4905159,'2708','240',1737361.82,1737361.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257593',4905160,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257593',4905161,'2710','240',1121629.13,1121629.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257593',4905162,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257593',4905163,'2712','240',1381802.27,1381802.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257594',4905164,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257594',4905165,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257594',4905166,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257594',4905167,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257594',4905168,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257594',4905169,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257594',4905170,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257594',4905171,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257594',4905172,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257594',4905173,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257594',4905174,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257594',4905175,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257594',4905176,'2706','240',1119434.62,1119434.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257594',4905177,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257594',4905178,'2708','240',1737361.82,1737361.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257594',4905179,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257594',4905180,'2710','240',1121629.13,1121629.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257594',4905181,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257594',4905182,'2712','240',1381802.27,1381802.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257595',4905183,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257595',4905184,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257595',4905185,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257595',4905186,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257595',4905187,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257595',4905188,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257595',4905189,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257595',4905190,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257595',4905191,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257595',4905192,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257595',4905193,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257595',4905194,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257595',4905195,'2706','240',1119434.62,1119434.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257595',4905196,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257595',4905197,'2708','240',1737361.82,1737361.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257595',4905198,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257595',4905199,'2710','240',1121629.13,1121629.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257595',4905200,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257595',4905201,'2712','240',1381802.27,1381802.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257596',4905202,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257596',4905203,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257596',4905204,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257596',4905205,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257596',4905206,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257596',4905207,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257596',4905208,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257596',4905209,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257596',4905210,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257596',4905211,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257596',4905212,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257596',4905213,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257596',4905214,'2706','240',1119434.62,1119434.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257596',4905215,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257596',4905216,'2708','240',1737361.82,1737361.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257596',4905217,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257596',4905218,'2710','240',1121629.13,1121629.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257596',4905219,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257596',4905220,'2712','240',1381802.27,1381802.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257597',4905221,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257597',4905222,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257597',4905223,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257597',4905224,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257597',4905225,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257597',4905226,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257597',4905227,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257597',4905228,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257597',4905229,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257597',4905230,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257597',4905231,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257597',4905232,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257597',4905233,'2706','240',1119434.62,1119434.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257597',4905234,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257597',4905235,'2708','240',1737361.82,1737361.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257597',4905236,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257597',4905237,'2710','240',1121629.13,1123132.25,1503.12,248014.80,0.00,0.00,0.00,0.00,0.00),('5','101','917','257597',4905238,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257597',4905239,'2712','240',1381802.27,1381802.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257598',4905240,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257598',4905241,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257598',4905242,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257598',4905243,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257598',4905244,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257598',4905245,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257598',4905246,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257598',4905247,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257598',4905248,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257598',4905249,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257598',4905250,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257598',4905251,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257598',4905252,'2706','240',1119434.62,1120173.34,738.72,121888.80,0.00,0.00,0.00,0.00,0.00),('5','101','916','257598',4905253,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257598',4905254,'2708','240',1737361.82,1737361.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257598',4905255,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257598',4905256,'2710','240',1123132.25,1128509.34,5377.09,887219.85,0.00,0.00,0.00,0.00,0.00),('5','101','917','257598',4905257,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257598',4905258,'2712','240',1381802.27,1382333.65,531.38,87677.70,0.00,0.00,0.00,0.00,0.00),('5','101','620','257599',4905259,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257599',4905260,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257599',4905261,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257599',4905262,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257599',4905263,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257599',4905264,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257599',4905265,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257599',4905266,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257599',4905267,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257599',4905268,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257599',4905269,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257599',4905270,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257599',4905271,'2706','240',1120173.34,1120173.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257599',4905272,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257599',4905273,'2708','240',1737361.82,1737361.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257599',4905274,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257599',4905275,'2710','240',1128509.34,1129028.16,518.82,85605.30,0.00,0.00,0.00,0.00,0.00),('5','101','917','257599',4905276,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257599',4905277,'2712','240',1382333.65,1387512.54,5178.89,854516.85,0.00,0.00,0.00,0.00,0.00),('5','101','620','257600',4905278,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257600',4905279,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257600',4905280,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257600',4905281,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257600',4905282,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257600',4905283,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257600',4905284,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257600',4905285,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257600',4905286,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257600',4905287,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257600',4905288,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257600',4905289,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257600',4905290,'2706','240',1120173.34,1120724.10,550.76,90875.40,0.00,0.00,0.00,0.00,0.00),('5','101','916','257600',4905291,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257600',4905292,'2708','240',1737361.82,1737361.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257600',4905293,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257600',4905294,'2710','240',1129028.16,1130958.10,1929.94,318440.10,0.00,0.00,0.00,0.00,0.00),('5','101','917','257600',4905295,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257600',4905296,'2712','240',1387512.54,1391325.49,3812.95,629136.75,0.00,0.00,0.00,0.00,0.00),('5','101','620','257601',4905297,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257601',4905298,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257601',4905299,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257601',4905300,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257601',4905301,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257601',4905302,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257601',4905303,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257601',4905304,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257601',4905305,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257601',4905306,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257601',4905307,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257601',4905308,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257601',4905309,'2706','240',1120724.10,1121772.76,1048.66,173028.90,0.00,0.00,0.00,0.00,0.00),('5','101','916','257601',4905310,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257601',4905311,'2708','240',1737361.82,1737361.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257601',4905312,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257601',4905313,'2710','240',1130958.10,1135639.80,4681.70,772480.50,0.00,0.00,0.00,0.00,0.00),('5','101','917','257601',4905314,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257601',4905315,'2712','240',1391325.49,1394989.20,3663.71,604512.15,0.00,0.00,0.00,0.00,0.00),('5','101','620','257602',4905316,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257602',4905317,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257602',4905318,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257602',4905319,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257602',4905320,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257602',4905321,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257602',4905322,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257602',4905323,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257602',4905324,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257602',4905325,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257602',4905326,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257602',4905327,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257602',4905328,'2706','240',1121772.76,1121772.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257602',4905329,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257602',4905330,'2708','240',1737361.82,1737361.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257602',4905331,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257602',4905332,'2710','240',1135639.80,1142211.19,6571.39,1084279.35,0.00,0.00,0.00,0.00,0.00),('5','101','917','257602',4905333,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257602',4905334,'2712','240',1394989.20,1400724.64,5735.44,946347.60,0.00,0.00,0.00,0.00,0.00),('5','101','620','257603',4905335,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257603',4905336,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257603',4905337,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257603',4905338,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257603',4905339,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257603',4905340,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257603',4905341,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257603',4905342,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257603',4905343,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257603',4905344,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257603',4905345,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257603',4905346,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257603',4905347,'2706','240',1121772.76,1122867.25,1094.49,180590.85,0.00,0.00,0.00,0.00,0.00),('5','101','916','257603',4905348,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257603',4905349,'2708','240',1737361.82,1739288.74,1926.92,317941.80,0.00,0.00,0.00,0.00,0.00),('5','101','917','257603',4905350,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257603',4905351,'2710','240',1142211.19,1144348.72,2137.53,352692.45,0.00,0.00,0.00,0.00,0.00),('5','101','917','257603',4905352,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257603',4905353,'2712','240',1400724.64,1405488.35,4763.71,786012.15,0.00,0.00,0.00,0.00,0.00),('5','101','620','257604',4905354,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257604',4905355,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257604',4905356,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257604',4905357,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257604',4905358,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257604',4905359,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257604',4905360,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257604',4905361,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257604',4905362,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257604',4905363,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257604',4905364,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257604',4905365,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257604',4905366,'2706','240',1122867.25,1122867.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257604',4905367,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257604',4905368,'2708','240',1739288.74,1745384.29,6095.55,1005765.75,0.00,0.00,0.00,0.00,0.00),('5','101','917','257604',4905369,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257604',4905370,'2710','240',1144348.72,1144686.90,338.18,55799.70,0.00,0.00,0.00,0.00,0.00),('5','101','917','257604',4905371,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257604',4905372,'2712','240',1405488.35,1410422.29,4933.94,814100.10,0.00,0.00,0.00,0.00,0.00),('5','101','620','257605',4905373,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257605',4905374,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257605',4905375,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257605',4905376,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257605',4905377,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257605',4905378,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257605',4905379,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257605',4905380,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257605',4905381,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257605',4905382,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257605',4905383,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257605',4905384,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257605',4905385,'2706','240',1122867.25,1122867.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257605',4905386,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257605',4905387,'2708','240',1745384.29,1750684.03,5299.74,874457.10,0.00,0.00,0.00,0.00,0.00),('5','101','917','257605',4905388,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257605',4905389,'2710','240',1144686.90,1148194.56,3507.66,578763.90,0.00,0.00,0.00,0.00,0.00),('5','101','917','257605',4905390,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257605',4905391,'2712','240',1410422.29,1410422.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257606',4905392,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257606',4905393,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257606',4905394,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257606',4905395,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257606',4905396,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257606',4905397,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257606',4905398,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257606',4905399,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257606',4905400,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257606',4905401,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257606',4905402,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257606',4905403,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257606',4905404,'2706','240',1122867.25,1122867.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257606',4905405,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257606',4905406,'2708','240',1750684.03,1756135.71,5451.68,899527.20,0.00,0.00,0.00,0.00,0.00),('5','101','917','257606',4905407,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257606',4905408,'2710','240',1148194.56,1152318.57,4124.01,680461.65,0.00,0.00,0.00,0.00,0.00),('5','101','917','257606',4905409,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257606',4905410,'2712','240',1410422.29,1410422.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257607',4905411,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257607',4905412,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257607',4905413,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257607',4905414,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257607',4905415,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257607',4905416,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257607',4905417,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257607',4905418,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257607',4905419,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257607',4905420,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257607',4905421,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257607',4905422,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257607',4905423,'2706','240',1122867.25,1122867.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257607',4905424,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257607',4905425,'2708','240',1756135.71,1761672.03,5536.32,896883.84,0.00,0.00,0.00,0.00,0.00),('5','101','917','257607',4905426,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257607',4905427,'2710','240',1152318.57,1154084.87,1766.30,286140.60,0.00,0.00,0.00,0.00,0.00),('5','101','917','257607',4905428,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257607',4905429,'2712','240',1410422.29,1412213.96,1791.67,290250.54,0.00,0.00,0.00,0.00,0.00),('5','101','620','257608',4905430,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257608',4905431,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257608',4905432,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257608',4905433,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257608',4905434,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257608',4905435,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257608',4905436,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257608',4905437,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257608',4905438,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257608',4905439,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257608',4905440,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257608',4905441,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257608',4905442,'2706','240',1122867.25,1122867.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257608',4905443,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257608',4905444,'2708','240',1761672.03,1765009.73,3337.70,550720.50,0.00,0.00,0.00,0.00,0.00),('5','101','917','257608',4905445,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257608',4905446,'2710','240',1154084.87,1154674.51,589.64,97290.60,0.00,0.00,0.00,0.00,0.00),('5','101','917','257608',4905447,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257608',4905448,'2712','240',1412213.96,1417439.03,5225.07,862136.55,0.00,0.00,0.00,0.00,0.00),('5','101','620','257609',4905449,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257609',4905450,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257609',4905451,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257609',4905452,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257609',4905453,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257609',4905454,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257609',4905455,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257609',4905456,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257609',4905457,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257609',4905458,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257609',4905459,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257609',4905460,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257609',4905461,'2706','240',1122867.25,1122867.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257609',4905462,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257609',4905463,'2708','240',1765009.73,1768584.11,3574.38,589772.70,0.00,0.00,0.00,0.00,0.00),('5','101','917','257609',4905464,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257609',4905465,'2710','240',1154674.51,1155052.86,378.35,62427.75,0.00,0.00,0.00,0.00,0.00),('5','101','917','257609',4905466,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257609',4905467,'2712','240',1417439.03,1420092.09,2653.06,437754.90,0.00,0.00,0.00,0.00,0.00),('5','101','620','257610',4905468,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257610',4905469,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257610',4905470,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257610',4905471,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257610',4905472,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257610',4905473,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257610',4905474,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257610',4905475,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257610',4905476,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257610',4905477,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257610',4905478,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257610',4905479,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257610',4905480,'2706','240',1122867.25,1123320.74,453.49,74825.85,0.00,0.00,0.00,0.00,0.00),('5','101','916','257610',4905481,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257610',4905482,'2708','240',1768584.11,1774494.59,5910.48,975229.20,0.00,0.00,0.00,0.00,0.00),('5','101','917','257610',4905483,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257610',4905484,'2710','240',1155052.86,1155052.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257610',4905485,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257610',4905486,'2712','240',1420092.09,1420092.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257611',4905487,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257611',4905488,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257611',4905489,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257611',4905490,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257611',4905491,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257611',4905492,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257611',4905493,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257611',4905494,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257611',4905495,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257611',4905496,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257611',4905497,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257611',4905498,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257611',4905499,'2706','240',1123320.74,1126645.08,3324.34,548516.10,0.00,0.00,0.00,0.00,0.00),('5','101','916','257611',4905500,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257611',4905501,'2708','240',1774494.59,1776051.53,1556.94,256895.10,0.00,0.00,0.00,0.00,0.00),('5','101','917','257611',4905502,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257611',4905503,'2710','240',1155052.86,1155052.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257611',4905504,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257611',4905505,'2712','240',1420092.09,1420092.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257612',4905506,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257612',4905507,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257612',4905508,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257612',4905509,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257612',4905510,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257612',4905511,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257612',4905512,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257612',4905513,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257612',4905514,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257612',4905515,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257612',4905516,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257612',4905517,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257612',4905518,'2706','240',1126645.08,1126645.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257612',4905519,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257612',4905520,'2708','240',1776051.53,1776051.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257612',4905521,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257612',4905522,'2710','240',1155052.86,1155052.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257612',4905523,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257612',4905524,'2712','240',1420092.09,1420092.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257613',4905525,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257613',4905526,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257613',4905527,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257613',4905528,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257613',4905529,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257613',4905530,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257613',4905531,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257613',4905532,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257613',4905533,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257613',4905534,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257613',4905535,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257613',4905536,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257613',4905537,'2706','240',1126645.08,1126645.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257613',4905538,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257613',4905539,'2708','240',1776051.53,1776051.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257613',4905540,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257613',4905541,'2710','240',1155052.86,1155052.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257613',4905542,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257613',4905543,'2712','240',1420092.09,1420092.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257614',4905544,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257614',4905545,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257614',4905546,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257614',4905547,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257614',4905548,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257614',4905549,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257614',4905550,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257614',4905551,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257614',4905552,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257614',4905553,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257614',4905554,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257614',4905555,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257614',4905556,'2706','240',1126645.08,1126645.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257614',4905557,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257614',4905558,'2708','240',1776051.53,1776051.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257614',4905559,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257614',4905560,'2710','240',1155052.86,1156658.23,1605.37,264886.05,0.00,0.00,0.00,0.00,0.00),('5','101','917','257614',4905561,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257614',4905562,'2712','240',1420092.09,1420092.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257615',4905563,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257615',4905564,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257615',4905565,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257615',4905566,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257615',4905567,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257615',4905568,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257615',4905569,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257615',4905570,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257615',4905571,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257615',4905572,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257615',4905573,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257615',4905574,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257615',4905575,'2706','240',1126645.08,1126645.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257615',4905576,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257615',4905577,'2708','240',1776051.53,1776051.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257615',4905578,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257615',4905579,'2710','240',1156658.23,1158922.66,2264.43,373630.95,0.00,0.00,0.00,0.00,0.00),('5','101','917','257615',4905580,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257615',4905581,'2712','240',1420092.09,1426192.56,6100.47,1006577.55,0.00,0.00,0.00,0.00,0.00),('5','101','620','257616',4905582,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257616',4905583,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257616',4905584,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257616',4905585,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257616',4905586,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257616',4905587,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257616',4905588,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257616',4905589,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257616',4905590,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257616',4905591,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257616',4905592,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257616',4905593,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257616',4905594,'2706','240',1126645.08,1126645.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257616',4905595,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257616',4905596,'2708','240',1776051.53,1776051.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257616',4905597,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257616',4905598,'2710','240',1158922.66,1163156.60,4233.94,698600.10,0.00,0.00,0.00,0.00,0.00),('5','101','917','257616',4905599,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257616',4905600,'2712','240',1426192.56,1429684.99,3492.43,576250.95,0.00,0.00,0.00,0.00,0.00),('5','101','620','257617',4905601,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257617',4905602,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257617',4905603,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257617',4905604,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257617',4905605,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257617',4905606,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257617',4905607,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257617',4905608,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257617',4905609,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257617',4905610,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257617',4905611,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257617',4905612,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257617',4905613,'2706','240',1126645.08,1126645.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257617',4905614,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257617',4905615,'2708','240',1776051.53,1776051.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257617',4905616,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257617',4905617,'2710','240',1163156.60,1170991.31,7834.71,1292727.15,0.00,0.00,0.00,0.00,0.00),('5','101','917','257617',4905618,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257617',4905619,'2712','240',1429684.99,1429684.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257618',4905620,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257618',4905621,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257618',4905622,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257618',4905623,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257618',4905624,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257618',4905625,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257618',4905626,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257618',4905627,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257618',4905628,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257618',4905629,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257618',4905630,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257618',4905631,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257618',4905632,'2706','240',1126645.08,1126645.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257618',4905633,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257618',4905634,'2708','240',1776051.53,1776051.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257618',4905635,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257618',4905636,'2710','240',1170991.31,1172128.43,1137.12,187624.80,0.00,0.00,0.00,0.00,0.00),('5','101','917','257618',4905637,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257618',4905638,'2712','240',1429684.99,1429684.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257619',4905639,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257619',4905640,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257619',4905641,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257619',4905642,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257619',4905643,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257619',4905644,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257619',4905645,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257619',4905646,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257619',4905647,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257619',4905648,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257619',4905649,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257619',4905650,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257619',4905651,'2706','240',1126645.08,1126645.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257619',4905652,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257619',4905653,'2708','240',1776051.53,1776051.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257619',4905654,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257619',4905655,'2710','240',1172128.43,1172128.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257619',4905656,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257619',4905657,'2712','240',1429684.99,1429684.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257620',4905658,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257620',4905659,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257620',4905660,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257620',4905661,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257620',4905662,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257620',4905663,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257620',4905664,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257620',4905665,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257620',4905666,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257620',4905667,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257620',4905668,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257620',4905669,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257620',4905670,'2706','240',1126645.08,1128680.17,2035.09,335789.85,0.00,0.00,0.00,0.00,0.00),('5','101','916','257620',4905671,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257620',4905672,'2708','240',1776051.53,1776051.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257620',4905673,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257620',4905674,'2710','240',1172128.43,1172128.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257620',4905675,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257620',4905676,'2712','240',1429684.99,1429684.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257621',4905677,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257621',4905678,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257621',4905679,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257621',4905680,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257621',4905681,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257621',4905682,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257621',4905683,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257621',4905684,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257621',4905685,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257621',4905686,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257621',4905687,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257621',4905688,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257621',4905689,'2706','240',1128680.17,1130906.53,2226.36,367349.40,0.00,0.00,0.00,0.00,0.00),('5','101','916','257621',4905690,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257621',4905691,'2708','240',1776051.53,1781729.16,5677.63,936808.95,0.00,0.00,0.00,0.00,0.00),('5','101','917','257621',4905692,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257621',4905693,'2710','240',1172128.43,1172131.20,2.77,457.05,0.00,0.00,0.00,0.00,0.00),('5','101','917','257621',4905694,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257621',4905695,'2712','240',1429684.99,1429684.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257622',4905696,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257622',4905697,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257622',4905698,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257622',4905699,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257622',4905700,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257622',4905701,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257622',4905702,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257622',4905703,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257622',4905704,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257622',4905705,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257622',4905706,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257622',4905707,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257622',4905708,'2706','240',1130906.53,1130946.72,40.19,6510.78,0.00,0.00,0.00,0.00,0.00),('5','101','916','257622',4905709,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257622',4905710,'2708','240',1781729.16,1787082.82,5353.66,867292.92,0.00,0.00,0.00,0.00,0.00),('5','101','917','257622',4905711,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257622',4905712,'2710','240',1172131.20,1172131.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257622',4905713,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257622',4905714,'2712','240',1429684.99,1429684.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257623',4905715,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257623',4905716,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257623',4905717,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257623',4905718,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257623',4905719,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257623',4905720,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257623',4905721,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257623',4905722,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257623',4905723,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257623',4905724,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257623',4905725,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257623',4905726,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257623',4905727,'2706','240',1130946.72,1135692.13,4745.41,782992.65,0.00,0.00,0.00,0.00,0.00),('5','101','916','257623',4905728,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257623',4905729,'2708','240',1787082.82,1791086.05,4003.23,660532.95,0.00,0.00,0.00,0.00,0.00),('5','101','917','257623',4905730,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257623',4905731,'2710','240',1172131.20,1172131.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257623',4905732,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257623',4905733,'2712','240',1429684.99,1429684.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257624',4905734,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257624',4905735,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257624',4905736,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257624',4905737,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257624',4905738,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257624',4905739,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257624',4905740,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257624',4905741,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257624',4905742,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257624',4905743,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257624',4905744,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257624',4905745,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257624',4905746,'2706','240',1135692.13,1138020.39,2328.26,384162.90,0.00,0.00,0.00,0.00,0.00),('5','101','916','257624',4905747,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257624',4905748,'2708','240',1791086.05,1796066.07,4980.02,821703.30,0.00,0.00,0.00,0.00,0.00),('5','101','917','257624',4905749,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257624',4905750,'2710','240',1172131.20,1172131.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257624',4905751,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257624',4905752,'2712','240',1429684.99,1429684.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257625',4905753,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257625',4905754,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257625',4905755,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257625',4905756,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257625',4905757,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257625',4905758,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257625',4905759,'1738','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257625',4905760,'1739','240',1182184.15,1182184.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257625',4905761,'1740','241',13028.28,13028.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','622','257625',4905762,'1741','241',732112.12,732112.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','623','257625',4905763,'1742','242',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257625',4905764,'2705','240',930973.84,930973.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257625',4905765,'2706','240',1138020.39,1139227.52,1207.13,199176.45,0.00,0.00,0.00,0.00,0.00),('5','101','916','257625',4905766,'2707','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','916','257625',4905767,'2708','240',1796066.07,1800675.59,4609.52,760570.80,0.00,0.00,0.00,0.00,0.00),('5','101','917','257625',4905768,'2709','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257625',4905769,'2710','240',1172131.20,1172131.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257625',4905770,'2711','240',114060.24,114060.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','917','257625',4905771,'2712','240',1429684.99,1429684.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257626',4905772,'1732','240',830444.59,830444.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257626',4905773,'1733','240',918866.34,918866.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257626',4905774,'1734','240',502795.97,502795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','620','257626',4905775,'1735','240',1560587.15,1560587.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257626',4905776,'1736','240',1615525.76,1615525.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','101','621','257626',4905777,'1737','240',940176.18,940176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),