-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_5_station_100
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_5_station_100`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_5_station_100` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_5_station_100`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3238 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (2213,30019,'',0,'24','5','100','PURCHASE','','2020-01-31 14:55:37',5,0.00,0.00,'','414','2020-01-31 14:55:37','414',0,1),(2214,3006,'',0,'6.1','5','100','CASH','','2020-01-31 14:56:18',5,0.00,0.00,'','414','2020-01-31 14:56:18','414',0,1),(2215,4004,'',0,'20','5','100','SALES','','2020-01-31 14:56:43',5,0.00,0.00,'','414','2020-01-31 14:56:43','414',0,1),(2216,4003,'',0,'2','5','100','UBA1019882661','','2020-01-31 14:57:09',5,0.00,0.00,'','414','2020-01-31 14:57:09','414',0,1),(2217,30020,'',0,'24','5','100','SALARIES & WAGES','','2020-01-31 14:58:20',5,0.00,0.00,'','414','2020-01-31 14:58:20','414',0,1),(3236,4023,'',0,'2','5','100','UBA-1021732970','','2021-03-06 01:31:49',5,0.00,0.00,'','600','2021-03-06 01:31:49','600',0,1),(3237,4024,'',0,'2','5','100','JA\'IZ-0010037957','','2022-03-02 19:13:16',5,0.00,0.00,'','600','2022-03-02 19:13:16','600',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=18047 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('5','100',17830,'627',4970.39,200.00,'2021-11-29','','2021-11-29 21:08:15','414','414',2021,'414','2021-11-29 21:08:15',5),('5','100',18046,'627',200.00,8900.00,'2021-12-15','','2021-12-15 09:10:31','600','600',2021,'600','2021-12-15 09:10:31',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=1753 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('5','100','627',1747,'5','PUMP 1',1296284.69,'PMS PUMP 1','',NULL,NULL,'',5,'2021-03-04 09:27:04','600'),('5','100','627',1748,'5','PUMP 2',2129466.00,'PMS PUMP 2','',NULL,NULL,'',5,'2021-03-01 09:07:20','600'),('5','100','628',1749,'5','PUMP 3',305060.16,'PMS PUMP 3','',NULL,NULL,'',5,'2021-02-28 11:36:33','600'),('5','100','628',1750,'5','PUMP 4',1423347.74,'PMS PUMP 4','',NULL,NULL,'',5,'2021-03-01 09:08:17','600'),('5','100','629',1751,'5','PUMP 5',3508122.89,'PMS PUMP 5','',NULL,NULL,'',5,'2021-03-04 09:28:20','600'),('5','100','630',1752,'5','PUMP 6',0.00,'DPK PUMP',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`)
) ENGINE=InnoDB AUTO_INCREMENT=256616 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('5','100',231325,'MORNING','2021-10-01','2021-10-01 00:00:00',NULL,'414',0.00,0.00,'414','2021-10-13 17:34:12','664','2021-10-13 17:35:35',10),('5','100',231326,'MORNING','2021-10-02','2021-10-02 00:00:00',NULL,'414',0.00,0.00,'414','2021-10-13 17:44:17','664','2021-10-13 17:44:47',10),('5','100',231327,'MORNING','2021-10-03','2021-10-03 00:00:00',NULL,'414',386239.91,386239.91,'414','2021-10-13 17:47:54','664','2021-10-13 17:49:41',10),('5','100',231328,'MORNING','2021-10-04','2021-10-04 00:00:00',NULL,'414',594060.02,594060.02,'414','2021-10-13 17:52:09','664','2021-10-13 17:53:47',10),('5','100',231330,'MORNING','2021-10-05','2021-10-05 00:00:00',NULL,'414',852520.97,852520.97,'414','2021-10-13 17:58:00','664','2021-10-13 17:58:45',10),('5','100',231332,'MORNING','2021-10-06','2021-10-06 00:00:00',NULL,'414',857696.22,857696.22,'414','2021-10-13 18:03:32','664','2021-10-13 18:06:09',10),('5','100',231334,'MORNING','2021-10-07','2021-10-07 00:00:00',NULL,'414',575675.25,575675.25,'414','2021-10-13 18:08:24','664','2021-10-13 18:11:39',10),('5','100',231335,'MORNING','2021-10-08','2021-10-08 00:00:00',NULL,'414',619077.26,619077.26,'414','2021-10-13 18:14:14','664','2021-10-13 18:15:22',10),('5','100',231336,'MORNING','2021-10-09','2021-10-09 00:00:00',NULL,'414',678018.06,678018.06,'414','2021-10-13 18:24:33','664','2021-10-13 18:25:35',10),('5','100',231339,'MORNING','2021-10-10','2021-10-10 00:00:00',NULL,'414',319990.19,319990.19,'414','2021-10-13 18:27:54','664','2021-10-13 18:41:27',10),('5','100',231378,'MORNING','2021-10-11','2021-10-11 00:00:00',NULL,'414',0.00,0.00,'414','2021-10-14 06:27:31','664','2021-10-14 09:42:31',10),('5','100',231470,'MORNING','2021-10-12','2021-10-12 00:00:00',NULL,'414',0.00,0.00,'414','2021-10-14 10:47:25','664','2021-10-14 10:49:27',10),('5','100',231472,'MORNING','2021-10-13','2021-10-13 00:00:00',NULL,'414',0.00,0.00,'414','2021-10-14 10:50:29','664','2021-10-14 10:52:22',10),('5','100',231473,'MORNING','2021-10-14','2021-10-14 00:00:00',NULL,'414',0.00,0.00,'414','2021-10-14 20:59:37','664','2021-10-15 09:25:26',10),('5','100',231715,'MORNING','2021-10-15','2021-10-15 00:00:00',NULL,'414',511024.56,511024.56,'414','2021-10-16 09:33:52','664','2021-10-16 16:32:03',10),('5','100',232063,'MORNING','2021-10-16','2021-10-16 00:00:00',NULL,'414',634321.02,634321.02,'414','2021-10-16 19:35:35','664','2021-10-17 15:14:15',10),('5','100',232329,'MORNING','2021-10-17','2021-10-17 00:00:00',NULL,'414',488877.75,488877.75,'414','2021-10-18 05:54:50','664','2021-10-18 06:15:27',10),('5','100',232373,'MORNING','2021-10-18','2021-10-18 00:00:00',NULL,'414',530780.16,530780.16,'414','2021-10-18 18:23:31','664','2021-10-19 05:05:16',10),('5','100',232653,'MORNING','2021-10-19','2021-10-19 00:00:00',NULL,'414',564217.98,564217.98,'414','2021-10-19 20:07:22','664','2021-10-20 08:23:15',10),('5','100',232900,'MORNING','2021-10-20','2021-10-20 00:00:00',NULL,'414',781060.14,781060.14,'414','2021-10-20 21:28:59','664','2021-10-21 06:39:43',10),('5','100',233147,'MORNING','2021-10-21','2021-10-21 00:00:00',NULL,'414',938172.58,938172.58,'414','2021-10-22 06:16:32','664','2021-10-22 08:47:51',10),('5','100',233434,'MORNING','2021-10-22','2021-10-22 00:00:00',NULL,'414',874869.90,874869.90,'414','2021-10-22 19:09:20','664','2021-10-23 06:43:59',10),('5','100',233723,'MORNING','2021-10-23','2021-10-23 00:00:00',NULL,'414',998309.80,998309.80,'414','2021-10-24 19:56:15','664','2021-10-25 13:14:09',10),('5','100',234209,'MORNING','2021-10-24','2021-10-24 00:00:00',NULL,'414',599091.83,599091.83,'414','2021-10-25 13:48:39','664','2021-10-26 06:11:27',10),('5','100',234343,'MORNING','2021-10-25','2021-10-25 00:00:00',NULL,'414',754665.55,754665.55,'414','2021-10-26 07:31:29','664','2021-10-26 15:28:03',10),('5','100',234506,'MORNING','2021-10-26','2021-10-26 00:00:00',NULL,'414',690699.46,699174.30,'414','2021-10-27 07:19:09','664','2021-10-27 07:27:30',10),('5','100',234611,'MORNING','2021-10-27','2021-10-27 00:00:00',NULL,'414',394319.82,399158.10,'414','2021-10-28 07:25:01','664','2021-10-28 07:52:05',10),('5','100',234876,'MORNING','2021-10-28','2021-10-28 00:00:00',NULL,'414',172235.58,174348.90,'414','2021-10-29 11:56:51','664','2021-10-29 21:59:22',10),('5','100',235705,'MORNING','2021-10-29','2021-10-29 00:00:00',NULL,'414',0.00,0.00,'414','2021-10-31 19:20:53','664','2021-10-31 19:32:43',10),('5','100',235708,'MORNING','2021-10-30','2021-10-30 00:00:00',NULL,'414',0.00,0.00,'414','2021-10-31 19:39:17','664','2021-10-31 20:29:37',10),('5','100',235766,'MORNING','2021-10-31','2021-10-31 00:00:00',NULL,'414',345556.20,345556.20,'414','2021-11-01 08:55:17','664','2021-11-01 08:59:07',10),('5','100',235841,'MORNING','2021-11-01','2021-11-01 00:00:00',NULL,'414',983626.05,983626.05,'414','2021-11-01 20:18:48','664','2021-11-01 20:45:32',10),('5','100',236119,'MORNING','2021-11-02','2021-11-02 00:00:00',NULL,'414',1601506.50,1601506.50,'414','2021-11-02 19:21:48','664','2021-11-03 05:01:18',10),('5','100',236363,'MORNING','2021-11-03','2021-11-03 00:00:00',NULL,'414',1837469.70,1837469.70,'414','2021-11-03 20:58:59','664','2021-11-04 06:29:41',10),('5','100',236552,'MORNING','2021-11-04','2021-11-04 00:00:00',NULL,'414',170676.00,170676.00,'414','2021-11-04 16:51:17','664','2021-11-05 15:11:47',10),('5','100',236911,'MORNING','2021-11-05','2021-11-05 00:00:00',NULL,'414',0.00,0.00,'414','2021-11-05 19:51:22','664','2021-11-07 07:09:19',10),('5','100',237398,'MORNING','2021-11-06','2021-11-06 00:00:00',NULL,'414',0.00,0.00,'414','2021-11-08 06:41:19','664','2021-11-08 07:27:28',10),('5','100',237809,'MORNING','2021-11-07','2021-11-07 00:00:00',NULL,'414',0.00,0.00,'414','2021-11-09 18:42:02','664','2021-11-09 18:43:47',10),('5','100',237810,'MORNING','2021-11-08','2021-11-08 00:00:00',NULL,'414',0.00,0.00,'414','2021-11-09 18:46:03','664','2021-11-09 18:48:34',10),('5','100',237813,'MORNING','2021-11-09','2021-11-09 00:00:00',NULL,'414',0.00,0.00,'414','2021-11-09 18:49:51','664','2021-11-09 18:55:51',10),('5','100',238002,'MORNING','2021-11-10','2021-11-10 00:00:00',NULL,'414',0.00,0.00,'414','2021-11-11 08:14:39','664','2021-11-11 09:42:51',10),('5','100',238247,'MORNING','2021-11-11','2021-11-11 00:00:00',NULL,'414',0.00,0.00,'414','2021-11-11 19:35:54','664','2021-11-12 08:17:49',10),('5','100',238421,'MORNING','2021-11-12','2021-11-12 00:00:00',NULL,'414',845184.45,845184.45,'414','2021-11-12 18:08:21','664','2021-11-13 05:52:29',10),('5','100',238649,'MORNING','2021-11-13','2021-11-13 00:00:00',NULL,'414',913408.65,913408.65,'414','2021-11-13 17:37:09','664','2021-11-14 09:02:47',10),('5','100',238892,'MORNING','2021-11-14','2021-11-14 00:00:00',NULL,'414',559222.95,559222.95,'414','2021-11-14 16:41:29','664','2021-11-15 07:23:35',10),('5','100',239112,'MORNING','2021-11-15','2021-11-15 00:00:00',NULL,'414',176581.35,176581.35,'414','2021-11-15 15:21:32','664','2021-11-16 08:08:44',10),('5','100',239352,'MORNING','2021-11-16','2021-11-16 00:00:00',NULL,'414',0.00,0.00,'414','2021-11-16 18:28:16','664','2021-11-17 05:39:30',10),('5','100',239617,'MORNING','2021-11-17','2021-11-17 00:00:00',NULL,'414',0.00,0.00,'414','2021-11-17 19:33:25','664','2021-11-18 06:23:58',10),('5','100',239853,'MORNING','2021-11-18','2021-11-18 00:00:00',NULL,'414',0.00,0.00,'414','2021-11-18 19:28:46','664','2021-11-19 04:41:25',10),('5','100',240154,'MORNING','2021-11-19','2021-11-19 00:00:00',NULL,'414',0.00,0.00,'414','2021-11-19 19:41:39','664','2021-11-20 06:37:13',10),('5','100',240383,'MORNING','2021-11-20','2021-11-20 00:00:00',NULL,'414',0.00,0.00,'414','2021-11-20 19:09:35','664','2021-11-20 20:43:23',10),('5','100',240616,'MORNING','2021-11-21','2021-11-21 00:00:00',NULL,'414',0.00,0.00,'414','2021-11-21 19:02:16','664','2021-11-22 06:19:29',10),('5','100',240792,'MORNING','2021-11-22','2021-11-22 00:00:00',NULL,'414',0.00,0.00,'414','2021-11-23 04:58:15','664','2021-11-23 05:36:37',10),('5','100',241051,'MORNING','2021-11-23','2021-11-23 00:00:00',NULL,'414',548464.95,548464.95,'414','2021-11-23 17:35:14','664','2021-11-24 07:04:03',10),('5','100',241294,'MORNING','2021-11-24','2021-11-24 00:00:00',NULL,'414',1250561.40,1250561.40,'414','2021-11-24 17:43:42','664','2021-11-25 05:52:18',10),('5','100',241567,'MORNING','2021-11-25','2021-11-25 00:00:00',NULL,'414',1221381.15,1221381.15,'414','2021-11-25 18:56:42','664','2021-11-26 05:58:36',10),('5','100',241738,'MORNING','2021-11-26','2021-11-26 00:00:00',NULL,'414',1021519.95,1021519.95,'414','2021-11-26 20:37:19','664','2021-11-27 06:11:16',10),('5','100',242101,'MORNING','2021-11-27','2021-11-27 00:00:00',NULL,'414',1134909.60,1134909.60,'414','2021-11-27 21:55:02','664','2021-11-28 07:30:12',10),('5','100',242401,'MORNING','2021-11-28','2021-11-28 00:00:00',NULL,'414',1269209.70,1269209.70,'414','2021-11-28 22:07:03','664','2021-11-29 04:57:30',10),('5','100',242590,'MORNING','2021-11-29','2021-11-29 00:00:00',NULL,'414',820419.60,820419.60,'414','2021-12-15 10:40:52','664','2021-12-15 10:42:54',10),('5','100',246303,'MORNING','2021-11-30','2021-11-30 00:00:00',NULL,'414',208353.75,208353.75,'414','2021-12-15 10:46:22','664','2021-12-15 10:51:12',10),('5','100',246305,'MORNING','2021-12-03','2021-12-03 00:00:00',NULL,'414',610762.35,610762.35,'414','2021-12-15 11:16:56','664','2021-12-15 11:17:52',10),('5','100',246311,'MORNING','2021-12-04','2021-12-04 00:00:00',NULL,'414',1207800.00,1207800.00,'414','2021-12-15 11:23:00','664','2021-12-15 11:24:53',10),('5','100',246314,'MORNING','2021-12-05','2021-12-05 00:00:00',NULL,'414',1103010.15,1103010.15,'414','2021-12-15 11:30:46','664','2021-12-15 11:31:48',10),('5','100',246316,'MORNING','2021-12-06','2021-12-06 00:00:00',NULL,'414',1470009.75,1470009.75,'414','2021-12-15 11:36:05','664','2021-12-15 11:37:17',10),('5','100',246317,'MORNING','2021-12-07','2021-12-07 00:00:00',NULL,'414',910537.65,910537.65,'414','2021-12-15 11:41:55','664','2021-12-15 11:49:20',10),('5','100',246319,'MORNING','2021-12-08','2021-12-08 00:00:00',NULL,'414',921300.60,921300.60,'414','2021-12-15 11:52:04','664','2021-12-15 11:58:19',10),('5','100',246323,'MORNING','2021-12-09','2021-12-09 00:00:00',NULL,'414',989808.60,989808.60,'414','2021-12-15 12:36:42','664','2021-12-15 12:37:23',10),('5','100',246324,'MORNING','2021-12-10','2021-12-10 00:00:00',NULL,'414',221662.65,221662.65,'414','2021-12-15 12:38:53','664','2021-12-15 12:40:39',10),('5','100',246325,'MORNING','2021-12-11','2021-12-11 00:00:00',NULL,'414',0.00,0.00,'414','2021-12-15 12:41:57','664','2021-12-15 12:42:37',10),('5','100',246326,'MORNING','2021-12-12','2021-12-12 00:00:00',NULL,'414',0.00,0.00,'414','2021-12-15 12:43:39','664','2021-12-15 12:45:13',10),('5','100',246327,'MORNING','2021-12-13','2021-12-13 00:00:00',NULL,'414',0.00,0.00,'414','2021-12-15 12:46:15','664','2021-12-15 12:48:22',10),('5','100',246331,'MORNING','2021-12-14','2021-12-14 00:00:00',NULL,'414',0.00,0.00,'414','2021-12-15 12:49:23','664','2021-12-15 12:52:35',10),('5','100',246333,'MORNING','2021-12-15','2021-12-15 00:00:00',NULL,'414',0.00,0.00,'414','2021-12-16 11:03:34','664','2021-12-16 15:52:43',10),('5','100',246637,'MORNING','2021-12-16','2021-12-16 00:00:00',NULL,'414',534342.60,534342.60,'414','2021-12-17 06:01:37','664','2021-12-17 09:08:49',10),('5','100',246870,'MORNING','2021-12-17','2021-12-17 00:00:00',NULL,'414',1005689.85,1005689.85,'414','2021-12-17 17:02:45','664','2021-12-18 06:52:49',10),('5','100',246962,'MORNING','2021-12-18','2021-12-18 00:00:00',NULL,'414',1125375.90,1125375.90,'414','2021-12-19 20:09:29','664','2021-12-20 06:12:00',10),('5','100',247476,'MORNING','2021-12-19','2021-12-19 00:00:00',NULL,'414',981367.20,981367.20,'414','2021-12-20 09:17:25','664','2021-12-20 18:04:05',10),('5','100',247611,'MORNING','2021-12-20','2021-12-20 00:00:00',NULL,'414',675292.20,675292.20,'414','2021-12-20 19:15:02','664','2021-12-21 14:53:33',10),('5','100',248024,'MORNING','2021-12-21','2021-12-21 00:00:00',NULL,'414',0.00,0.00,'414','2021-12-22 13:00:12','664','2021-12-22 13:00:43',10),('5','100',248034,'MORNING','2021-12-22','2021-12-22 00:00:00',NULL,'414',0.00,0.00,'414','2021-12-23 06:32:50','664','2021-12-24 14:07:59',10),('5','100',248591,'Morning ','2021-12-23','2021-12-23 00:00:00',NULL,'414',0.00,0.00,'414','2021-12-24 19:49:30','664','2021-12-26 07:25:32',10),('5','100',248954,'Morning ','2021-12-24','2021-12-24 00:00:00',NULL,'414',0.00,0.00,'414','2021-12-26 10:33:16','664','2021-12-27 05:57:08',10),('5','100',249504,'MORNING','2021-12-25','2021-12-25 00:00:00',NULL,'414',0.00,0.00,'414','2021-12-28 14:38:09','664','2021-12-28 14:40:15',10),('5','100',249507,'MORNING','2021-12-26','2021-12-26 00:00:00',NULL,'414',0.00,0.00,'414','2021-12-28 14:41:32','664','2021-12-28 14:42:45',10),('5','100',249508,'MORNING','2021-12-27','2021-12-27 00:00:00',NULL,'414',0.00,0.00,'414','2021-12-28 14:44:05','664','2021-12-28 14:44:44',10),('5','100',249509,'MORNING','2021-12-28','2021-12-28 00:00:00',NULL,'414',0.00,0.00,'414','2021-12-28 14:46:28','664','2021-12-28 14:56:27',10),('5','100',250442,'MORNING','2021-12-29','2021-12-29 00:00:00',NULL,'414',0.00,0.00,'414','2022-01-01 12:36:25','664','2022-01-02 08:05:43',10),('5','100',250601,'MORNING','2021-12-30','2021-12-30 00:00:00',NULL,'414',0.00,0.00,'414','2022-01-02 08:06:48','664','2022-01-02 08:08:14',10),('5','100',250604,'MORNING','2021-12-31','2021-12-31 00:00:00',NULL,'414',0.00,0.00,'414','2022-01-02 08:09:27','664','2022-01-02 08:10:07',10),('5','100',250608,'MORNING','2022-01-01','2022-01-01 00:00:00',NULL,'414',0.00,0.00,'414','2022-01-02 08:15:43','664','2022-01-02 08:16:55',10),('5','100',250899,'MORNING','2022-01-02','2022-01-02 00:00:00',NULL,'414',0.00,0.00,'414','2022-01-03 12:59:39','664','2022-01-03 13:03:01',10),('5','100',251230,'MORNING','2022-01-03','2022-01-03 00:00:00',NULL,'414',0.00,0.00,'414','2022-01-04 19:41:27','664','2022-01-05 17:45:20',10),('5','100',251445,'MORNING','2022-01-04','2022-01-04 00:00:00',NULL,'414',0.00,0.00,'414','2022-01-05 17:52:07','664','2022-01-05 18:12:15',10),('5','100',251458,'MORNING','2022-01-05','2022-01-05 00:00:00',NULL,'414',478184.85,478184.85,'414','2022-01-06 09:03:36','664','2022-01-06 09:23:58',10),('5','100',251682,'MORNING','2022-01-06','2022-01-06 00:00:00',NULL,'414',1154100.75,1154100.75,'414','2022-01-06 16:37:44','664','2022-01-07 07:01:04',10),('5','100',251898,'MORNING','2022-01-07','2022-01-07 00:00:00',NULL,'414',1162274.85,1162274.85,'414','2022-01-08 08:22:37','664','2022-01-09 15:48:49',10),('5','100',252381,'MORNING','2022-01-08','2022-01-08 00:00:00',NULL,'414',1361518.95,1361518.95,'414','2022-01-09 16:51:01','664','2022-01-10 08:25:11',10),('5','100',252545,'MORNING','2022-01-09','2022-01-09 00:00:00',NULL,'414',984751.35,984751.35,'414','2022-01-10 09:21:28','664','2022-01-10 10:44:52',10),('5','100',252675,'MORNING','2022-01-10','2022-01-10 00:00:00',NULL,'414',999939.60,999939.60,'414','2022-01-10 21:33:27','664','2022-01-11 08:18:35',10),('5','100',252755,'MORNING','2022-01-11','2022-01-11 00:00:00',NULL,'414',409437.60,409437.60,'414','2022-01-11 20:00:21','664','2022-01-12 08:11:59',10),('5','100',253290,'MORNING','2022-01-12','2022-01-12 00:00:00',NULL,'414',0.00,0.00,'414','2022-01-13 10:30:52','664','2022-01-13 10:31:45',10),('5','100',253292,'MORNING','2022-01-13','2022-01-13 00:00:00',NULL,'414',0.00,0.00,'414','2022-01-13 22:50:45','664','2022-01-14 06:36:31',10),('5','100',253579,'Morning','2022-01-14','2022-01-14 00:00:00',NULL,'414',0.00,0.00,'414','2022-01-14 20:45:10','664','2022-01-15 09:06:38',10),('5','100',253911,'Morning','2022-01-15','2022-01-15 00:00:00',NULL,'414',0.00,0.00,'414','2022-01-15 21:18:30','664','2022-01-16 06:38:21',10),('5','100',254050,'Morning','2022-01-16','2022-01-16 00:00:00',NULL,'414',0.00,0.00,'414','2022-01-17 07:30:06','664','2022-01-17 08:01:14',10),('5','100',254312,'Morning','2022-01-17','2022-01-17 00:00:00',NULL,'414',0.00,0.00,'414','2022-01-17 20:29:58','664','2022-01-18 07:06:27',10),('5','100',254526,'Morning','2022-01-18','2022-01-18 00:00:00',NULL,'414',0.00,0.00,'414','2022-01-18 22:08:23','664','2022-01-19 06:02:45',10),('5','100',254776,'Morning','2022-01-19','2022-01-19 00:00:00',NULL,'414',0.00,0.00,'414','2022-01-19 19:07:59','664','2022-01-20 06:33:12',10),('5','100',255063,'Morning','2022-01-20','2022-01-20 00:00:00',NULL,'414',0.00,0.00,'414','2022-01-20 12:50:22','664','2022-01-21 11:15:10',10),('5','100',255424,'Morning','2022-01-21','2022-01-21 00:00:00',NULL,'414',0.00,0.00,'414','2022-01-21 20:51:34','664','2022-01-21 22:35:13',10),('5','100',255682,'Morning','2022-01-22','2022-01-22 00:00:00',NULL,'414',0.00,0.00,'414','2022-01-22 21:45:00','664','2022-01-23 07:27:54',10),('5','100',255878,'Morning','2022-01-23','2022-01-23 00:00:00',NULL,'414',0.00,0.00,'414','2022-01-23 17:32:29','664','2022-01-24 07:29:51',10),('5','100',256605,'MORNING','2022-01-24','2022-01-24 00:00:00',NULL,'414',0.00,0.00,'414','2022-01-26 13:51:32','664','2022-01-26 13:53:01',10),('5','100',256607,'MORNING','2022-01-25','2022-01-25 00:00:00',NULL,'414',0.00,0.00,'414','2022-01-26 13:54:29','664','2022-01-26 13:55:33',10),('5','100',256608,'MORNING','2022-01-26','2022-01-26 00:00:00',NULL,'414',0.00,0.00,'414','2022-01-26 13:56:33','664','2022-01-27 07:06:23',10),('5','100',256609,'MORNING','2022-01-27','2022-01-27 00:00:00',NULL,'414',0.00,0.00,'414','2022-01-31 13:22:25','664','2022-01-31 13:24:59',10),('5','100',256610,'MORNING','2022-01-28','2022-01-28 00:00:00',NULL,'414',0.00,0.00,'414','2022-01-31 13:26:02','664','2022-01-31 13:26:59',10),('5','100',256611,'MORNING','2022-01-29','2022-01-29 00:00:00',NULL,'414',0.00,0.00,'414','2022-01-31 13:28:46','664','2022-01-31 13:30:29',10),('5','100',256612,'MORNING','2022-01-30','2022-01-30 00:00:00',NULL,'414',0.00,0.00,'414','2022-01-31 13:31:53','664','2022-01-31 13:33:48',10),('5','100',256613,'MORNING','2022-01-31','2022-01-31 00:00:00',NULL,'414',0.00,0.00,'414','2022-01-31 13:34:44','664','2022-02-02 19:20:29',10),('5','100',256614,'Morning ','2022-02-01','2022-02-01 00:00:00',NULL,'414',0.00,0.00,'414','2022-02-03 14:23:52','664','2022-02-03 14:43:57',10),('5','100',256615,'Morning ','2022-04-09','2022-04-09 08:45:28','2022-04-10 08:45:28','414',0.00,0.00,'414','2022-04-09 08:45:46','','0000-00-00 00:00:00',5);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4888125 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('5','100','627','123767',2465819,'1747','246',28729.38,32098.88,3369.50,481838.50,0.00,0.00,0.00,0.00,0.00),('5','100','627','123767',2465820,'1748','246',1042324.49,1046319.31,3994.82,571259.26,0.00,0.00,0.00,0.00,0.00),('5','100','628','123767',2465821,'1749','246',922723.71,924720.71,1997.00,285571.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','123767',2465822,'1750','246',9480.78,12046.65,2565.87,366919.41,0.00,0.00,0.00,0.00,0.00),('5','100','629','123767',2465823,'1751','247',3355987.82,3356254.51,266.69,58671.80,0.00,0.00,0.00,0.00,0.00),('5','100','630','123767',2465824,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','123882',2468263,'1747','246',32098.88,32098.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','123882',2468264,'1748','246',1046319.31,1046319.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','123882',2468265,'1749','246',924720.71,929838.24,5117.53,731806.79,0.00,0.00,0.00,0.00,0.00),('5','100','628','123882',2468266,'1750','246',12046.65,16422.67,4376.02,625770.86,0.00,0.00,0.00,0.00,0.00),('5','100','629','123882',2468267,'1751','247',3356254.51,3356795.57,541.06,121738.50,0.00,0.00,0.00,0.00,0.00),('5','100','630','123882',2468268,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','124047',2471448,'1747','246',32098.88,32098.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','124047',2471449,'1748','246',1046319.31,1046319.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','124047',2471450,'1749','246',929838.24,929838.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','124047',2471451,'1750','246',16422.67,16422.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','124047',2471452,'1751','247',3356795.57,3356795.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','124047',2471453,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','124519',2481543,'1747','246',32098.88,32407.80,308.92,44175.56,0.00,0.00,0.00,0.00,0.00),('5','100','627','124519',2481544,'1748','246',1046319.31,1046586.19,266.88,38163.84,0.00,0.00,0.00,0.00,0.00),('5','100','628','124519',2481545,'1749','246',929838.24,935298.63,5460.39,780835.77,0.00,0.00,0.00,0.00,0.00),('5','100','628','124519',2481546,'1750','246',16422.67,21901.31,5478.64,783445.52,0.00,0.00,0.00,0.00,0.00),('5','100','629','124519',2481547,'1751','247',3356795.57,3357293.34,497.77,111998.25,0.00,0.00,0.00,0.00,0.00),('5','100','630','124519',2481548,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','124671',2484561,'1747','246',35609.51,37567.68,1958.17,280018.31,0.00,0.00,0.00,0.00,0.00),('5','100','627','124671',2484562,'1748','246',1051062.78,1056581.10,5518.32,789119.76,0.00,0.00,0.00,0.00,0.00),('5','100','628','124671',2484563,'1749','246',938301.50,941305.31,3003.81,429544.83,0.00,0.00,0.00,0.00,0.00),('5','100','628','124671',2484564,'1750','246',21901.31,21901.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','124671',2484565,'1751','247',3357706.33,3358057.43,351.10,78997.50,0.00,0.00,0.00,0.00,0.00),('5','100','630','124671',2484566,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','124720',2485499,'1747','246',37567.68,39664.05,2096.37,299780.91,0.00,0.00,0.00,0.00,0.00),('5','100','627','124720',2485500,'1748','246',1056581.10,1061758.67,5177.57,740392.51,0.00,0.00,0.00,0.00,0.00),('5','100','628','124720',2485501,'1749','246',941305.31,944685.60,3380.29,483381.47,0.00,0.00,0.00,0.00,0.00),('5','100','628','124720',2485502,'1750','246',21901.31,21901.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','124720',2485503,'1751','247',3358057.43,3358291.26,233.83,52611.75,0.00,0.00,0.00,0.00,0.00),('5','100','630','124720',2485504,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','124895',2489031,'1747','246',39664.05,39903.23,239.18,34202.74,0.00,0.00,0.00,0.00,0.00),('5','100','627','124895',2489032,'1748','246',1061758.67,1064721.72,2963.05,423716.15,0.00,0.00,0.00,0.00,0.00),('5','100','628','124895',2489033,'1749','246',944685.60,947482.05,2796.45,399892.35,0.00,0.00,0.00,0.00,0.00),('5','100','628','124895',2489034,'1750','246',21901.31,23837.47,1936.16,276870.88,0.00,0.00,0.00,0.00,0.00),('5','100','629','124895',2489035,'1751','247',3358291.26,3358566.94,275.68,62028.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','124895',2489036,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','129016',2571371,'1747','246',39903.23,39903.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','129016',2571372,'1748','246',1064721.72,1064721.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','129016',2571373,'1749','246',947482.05,947482.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','129016',2571374,'1750','246',23837.47,23837.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','129016',2571375,'1751','247',3358566.94,3359061.00,494.06,111163.50,0.00,0.00,0.00,0.00,0.00),('5','100','630','129016',2571376,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','181592',3566102,'1747','246',875940.41,875940.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','181592',3566103,'1748','246',1631405.34,1631405.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','181592',3566104,'1749','246',947482.05,947482.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','181592',3566105,'1750','246',913493.96,913493.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','181592',3566106,'1751','247',3474162.14,3474162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','181592',3566107,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','181593',3566108,'1747','246',481222.52,481222.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','181593',3566109,'1748','246',295998.71,295998.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','181593',3566110,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','181593',3566111,'1750','246',372452.01,372452.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','181593',3566112,'1751','247',178615.01,178615.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','181593',3566113,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','181740',3568606,'1747','246',886357.94,889989.49,3631.55,591942.65,0.00,0.00,0.00,0.00,0.00),('5','100','627','181740',3568607,'1748','246',1631603.60,1631603.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','181740',3568608,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','181740',3568609,'1750','246',913493.96,913493.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','181740',3568610,'1751','247',3474496.14,3474663.54,167.40,41850.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','181740',3568611,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','181881',3571143,'1747','246',889989.49,889989.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','181881',3571144,'1748','246',1631603.60,1631603.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','181881',3571145,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','181881',3571146,'1750','246',913493.96,913493.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','181881',3571147,'1751','247',3474663.54,3474663.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','181881',3571148,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','182265',3578245,'1747','246',889989.49,889989.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','182265',3578246,'1748','246',1631603.60,1631603.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','182265',3578247,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','182265',3578248,'1750','246',913493.96,913493.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','182265',3578249,'1751','247',3474663.54,3474663.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','182265',3578250,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','182345',3579370,'1747','246',886357.94,898114.20,11756.26,1916270.38,0.00,0.00,0.00,0.00,0.00),('5','100','627','182345',3579371,'1748','246',1631603.60,1637218.83,5615.23,915282.49,0.00,0.00,0.00,0.00,0.00),('5','100','628','182345',3579372,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','182345',3579373,'1750','246',913493.96,913493.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','182345',3579374,'1751','247',3474496.14,3475047.94,551.80,137950.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','182345',3579375,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','182395',3580460,'1747','246',898114.20,902655.76,4541.56,772065.20,0.00,0.00,0.00,0.00,0.00),('5','100','627','182395',3580461,'1748','246',1637218.83,1642116.86,4898.03,832665.10,0.00,0.00,0.00,0.00,0.00),('5','100','628','182395',3580462,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','182395',3580463,'1750','246',913493.96,913493.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','182395',3580464,'1751','247',3475047.94,3475543.95,496.01,124002.50,0.00,0.00,0.00,0.00,0.00),('5','100','630','182395',3580465,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','182675',3585770,'1747','246',902655.76,904393.72,1737.96,295453.20,0.00,0.00,0.00,0.00,0.00),('5','100','627','182675',3585771,'1748','246',1642116.86,1643801.45,1684.59,286380.30,0.00,0.00,0.00,0.00,0.00),('5','100','628','182675',3585772,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','182675',3585773,'1750','246',913493.96,913493.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','182675',3585774,'1751','247',3475543.95,3475716.95,173.00,43250.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','182675',3585775,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','182828',3588638,'1747','246',904393.72,904393.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','182828',3588639,'1748','246',1643801.45,1643801.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','182828',3588640,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','182828',3588641,'1750','246',913493.96,913493.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','182828',3588642,'1751','247',3475716.95,3475826.95,110.00,27500.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','182828',3588643,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','182878',3589393,'1747','246',904393.72,907347.15,2953.43,502083.10,0.00,0.00,0.00,0.00,0.00),('5','100','627','182878',3589394,'1748','246',1643801.45,1643811.34,9.89,1681.30,0.00,0.00,0.00,0.00,0.00),('5','100','628','182878',3589395,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','182878',3589396,'1750','246',913493.96,915130.67,1636.71,278240.70,0.00,0.00,0.00,0.00,0.00),('5','100','629','182878',3589397,'1751','247',3475826.95,3475906.52,79.57,21086.05,0.00,0.00,0.00,0.00,0.00),('5','100','630','182878',3589398,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','183035',3592346,'1747','246',907347.15,913351.01,6003.86,1020656.20,0.00,0.00,0.00,0.00,0.00),('5','100','627','183035',3592347,'1748','246',1643811.34,1643811.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','183035',3592348,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','183035',3592349,'1750','246',915130.67,919573.90,4443.23,755349.10,0.00,0.00,0.00,0.00,0.00),('5','100','629','183035',3592350,'1751','247',3475906.52,3476310.11,403.59,106951.35,0.00,0.00,0.00,0.00,0.00),('5','100','630','183035',3592351,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','183284',3596653,'1747','246',913351.01,916838.90,3487.89,592941.30,0.00,0.00,0.00,0.00,0.00),('5','100','627','183284',3596654,'1748','246',1643811.34,1643811.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','183284',3596655,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','183284',3596656,'1750','246',919573.90,921836.02,2262.12,384560.40,0.00,0.00,0.00,0.00,0.00),('5','100','629','183284',3596657,'1751','247',3476310.11,3476734.45,424.34,112450.10,0.00,0.00,0.00,0.00,0.00),('5','100','630','183284',3596658,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','183533',3601128,'1747','246',916838.90,921317.83,4478.93,730065.59,0.00,0.00,0.00,0.00,0.00),('5','100','627','183533',3601129,'1748','246',1643811.34,1643811.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','183533',3601130,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','183533',3601131,'1750','246',921836.02,925897.61,4061.59,662039.17,0.00,0.00,0.00,0.00,0.00),('5','100','629','183533',3601132,'1751','247',3476734.45,3477133.31,398.86,105697.90,0.00,0.00,0.00,0.00,0.00),('5','100','630','183533',3601133,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','183712',3604412,'1747','246',921317.83,928332.03,7014.20,1143314.60,0.00,0.00,0.00,0.00,0.00),('5','100','627','183712',3604413,'1748','246',1643811.34,1646081.60,2270.26,370052.38,0.00,0.00,0.00,0.00,0.00),('5','100','628','183712',3604414,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','183712',3604415,'1750','246',925897.61,928428.94,2531.33,412606.79,0.00,0.00,0.00,0.00,0.00),('5','100','629','183712',3604416,'1751','247',3477133.31,3477372.30,238.99,63332.35,0.00,0.00,0.00,0.00,0.00),('5','100','630','183712',3604417,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','184235',3614097,'1747','246',928332.03,930038.37,1706.34,278133.42,0.00,0.00,0.00,0.00,0.00),('5','100','627','184235',3614098,'1748','246',1646081.60,1648493.70,2412.10,393172.30,0.00,0.00,0.00,0.00,0.00),('5','100','628','184235',3614099,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','184235',3614100,'1750','246',928428.94,928428.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','184235',3614101,'1751','247',3477372.30,3477424.35,52.05,13272.75,0.00,0.00,0.00,0.00,0.00),('5','100','630','184235',3614102,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','184252',3614344,'1747','246',930038.37,930038.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','184252',3614345,'1748','246',1648493.70,1648493.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','184252',3614346,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','184252',3614347,'1750','246',928428.94,928428.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','184252',3614348,'1751','247',3477424.35,3477557.08,132.73,33846.15,0.00,0.00,0.00,0.00,0.00),('5','100','630','184252',3614349,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','184313',3615166,'1747','246',930038.37,933779.85,3741.48,609861.24,0.00,0.00,0.00,0.00,0.00),('5','100','627','184313',3615167,'1748','246',1648493.70,1648493.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','184313',3615168,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','184313',3615169,'1750','246',928428.94,931839.97,3411.03,555997.89,0.00,0.00,0.00,0.00,0.00),('5','100','629','184313',3615170,'1751','247',3477557.08,3478082.53,525.45,133989.75,0.00,0.00,0.00,0.00,0.00),('5','100','630','184313',3615171,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','184576',3620078,'1747','246',933779.85,938565.62,4785.77,780080.51,0.00,0.00,0.00,0.00,0.00),('5','100','627','184576',3620079,'1748','246',1648493.70,1648493.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','184576',3620080,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','184576',3620081,'1750','246',931839.97,934944.09,3104.12,505971.56,0.00,0.00,0.00,0.00,0.00),('5','100','629','184576',3620082,'1751','247',3478082.53,3479539.71,1457.18,371580.90,0.00,0.00,0.00,0.00,0.00),('5','100','630','184576',3620083,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','184770',3623642,'1747','246',938565.62,945271.23,6705.61,1093014.43,0.00,0.00,0.00,0.00,0.00),('5','100','627','184770',3623643,'1748','246',1648493.70,1648493.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','184770',3623644,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','184770',3623645,'1750','246',934944.09,940144.35,5200.26,847642.38,0.00,0.00,0.00,0.00,0.00),('5','100','629','184770',3623646,'1751','247',3479539.71,3479939.71,400.00,102000.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','184770',3623647,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','184929',3626403,'1747','246',945271.23,947427.31,2156.08,351441.04,0.00,0.00,0.00,0.00,0.00),('5','100','627','184929',3626404,'1748','246',1648493.70,1651422.80,2929.10,477443.30,0.00,0.00,0.00,0.00,0.00),('5','100','628','184929',3626405,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','184929',3626406,'1750','246',940144.35,944652.64,4508.29,734851.27,0.00,0.00,0.00,0.00,0.00),('5','100','629','184929',3626407,'1751','247',3479939.71,3480972.05,1032.34,273570.10,0.00,0.00,0.00,0.00,0.00),('5','100','630','184929',3626408,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','185226',3631452,'1747','246',947427.31,948316.16,888.85,144882.55,0.00,0.00,0.00,0.00,0.00),('5','100','627','185226',3631453,'1748','246',1651422.80,1656283.76,4860.96,792336.48,0.00,0.00,0.00,0.00,0.00),('5','100','628','185226',3631454,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','185226',3631455,'1750','246',944652.64,950118.13,5465.49,890874.87,0.00,0.00,0.00,0.00,0.00),('5','100','629','185226',3631456,'1751','247',3480972.05,3481160.89,188.84,50042.60,0.00,0.00,0.00,0.00,0.00),('5','100','630','185226',3631457,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','185330',3633104,'1747','246',948316.16,953831.87,5515.71,899060.73,0.00,0.00,0.00,0.00,0.00),('5','100','627','185330',3633105,'1748','246',1656283.76,1659613.94,3330.18,542819.34,0.00,0.00,0.00,0.00,0.00),('5','100','628','185330',3633106,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','185330',3633107,'1750','246',950118.13,952855.30,2737.17,446158.71,0.00,0.00,0.00,0.00,0.00),('5','100','629','185330',3633108,'1751','247',3481160.89,3481682.55,521.66,138239.90,0.00,0.00,0.00,0.00,0.00),('5','100','630','185330',3633109,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','185634',3638892,'1747','246',953831.87,953831.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','185634',3638893,'1748','246',1659613.94,1665890.94,6277.00,1023151.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','185634',3638894,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','185634',3638895,'1750','246',952855.30,957619.63,4764.33,776585.79,0.00,0.00,0.00,0.00,0.00),('5','100','629','185634',3638896,'1751','247',3481682.55,3481682.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','185634',3638897,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','185726',3640272,'1747','246',953831.87,956884.58,3052.71,494539.02,0.00,0.00,0.00,0.00,0.00),('5','100','627','185726',3640273,'1748','246',1665890.94,1669392.64,3501.70,567275.40,0.00,0.00,0.00,0.00,0.00),('5','100','628','185726',3640274,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','185726',3640275,'1750','246',957619.63,960138.47,2518.84,408052.08,0.00,0.00,0.00,0.00,0.00),('5','100','629','185726',3640276,'1751','247',3481682.55,3481682.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','185726',3640277,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','185937',3644249,'1747','246',956884.58,962313.26,5428.68,884874.84,0.00,0.00,0.00,0.00,0.00),('5','100','627','185937',3644250,'1748','246',1669392.64,1669392.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','185937',3644251,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','185937',3644252,'1750','246',960138.47,964556.38,4417.91,720119.33,0.00,0.00,0.00,0.00,0.00),('5','100','629','185937',3644253,'1751','247',3481682.55,3481682.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','185937',3644254,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','186364',3651358,'1747','246',962313.26,968754.57,6441.31,1049933.53,0.00,0.00,0.00,0.00,0.00),('5','100','627','186364',3651359,'1748','246',1669392.64,1669392.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','186364',3651360,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','186364',3651361,'1750','246',964556.38,971607.00,7050.62,1149251.06,0.00,0.00,0.00,0.00,0.00),('5','100','629','186364',3651362,'1751','247',3481682.55,3481682.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','186364',3651363,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','186369',3651439,'1747','246',968754.57,974493.00,5738.43,935364.09,0.00,0.00,0.00,0.00,0.00),('5','100','627','186369',3651440,'1748','246',1669392.64,1672532.51,3139.87,511798.81,0.00,0.00,0.00,0.00,0.00),('5','100','628','186369',3651441,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','186369',3651442,'1750','246',971607.00,978970.58,7363.58,1200263.54,0.00,0.00,0.00,0.00,0.00),('5','100','629','186369',3651443,'1751','247',3481682.55,3481682.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','186369',3651444,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','186734',3657917,'1747','246',974493.00,979818.90,5325.90,868121.70,0.00,0.00,0.00,0.00,0.00),('5','100','627','186734',3657918,'1748','246',1672532.51,1676758.29,4225.78,688802.14,0.00,0.00,0.00,0.00,0.00),('5','100','628','186734',3657919,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','186734',3657920,'1750','246',978970.58,983523.42,4552.84,742112.92,0.00,0.00,0.00,0.00,0.00),('5','100','629','186734',3657921,'1751','247',3481682.55,3481682.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','186734',3657922,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','187033',3662718,'1747','246',979818.90,985002.56,5183.66,844936.58,0.00,0.00,0.00,0.00,0.00),('5','100','627','187033',3662719,'1748','246',1676758.29,1678935.89,2177.60,354948.80,0.00,0.00,0.00,0.00,0.00),('5','100','628','187033',3662720,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','187033',3662721,'1750','246',983523.42,992873.05,9349.63,1523989.69,0.00,0.00,0.00,0.00,0.00),('5','100','629','187033',3662722,'1751','247',3481682.55,3481682.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','187033',3662723,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','187259',3666677,'1747','246',985002.56,989317.43,4314.87,703323.81,0.00,0.00,0.00,0.00,0.00),('5','100','627','187259',3666678,'1748','246',1678935.89,1683449.21,4513.32,735671.16,0.00,0.00,0.00,0.00,0.00),('5','100','628','187259',3666679,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','187259',3666680,'1750','246',992873.05,1000145.68,7272.63,1185438.69,0.00,0.00,0.00,0.00,0.00),('5','100','629','187259',3666681,'1751','247',3481682.55,3481682.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','187259',3666682,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','187396',3669266,'1747','246',989317.43,994496.72,5179.29,844224.27,0.00,0.00,0.00,0.00,0.00),('5','100','627','187396',3669267,'1748','246',1683449.21,1686282.95,2833.74,461899.62,0.00,0.00,0.00,0.00,0.00),('5','100','628','187396',3669268,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','187396',3669269,'1750','246',1000145.68,1005253.72,5108.04,832610.52,0.00,0.00,0.00,0.00,0.00),('5','100','629','187396',3669270,'1751','247',3481682.55,3481682.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','187396',3669271,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','187499',3671146,'1747','246',994496.72,1004210.02,9713.30,1583267.90,0.00,0.00,0.00,0.00,0.00),('5','100','627','187499',3671147,'1748','246',1686282.95,1686282.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','187499',3671148,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','187499',3671149,'1750','246',1005253.72,1013664.44,8410.72,1370947.36,0.00,0.00,0.00,0.00,0.00),('5','100','629','187499',3671150,'1751','247',3481682.55,3481682.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','187499',3671151,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','187621',3673192,'1747','246',1004210.02,1010232.42,6022.40,981651.20,0.00,0.00,0.00,0.00,0.00),('5','100','627','187621',3673193,'1748','246',1686282.95,1686282.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','187621',3673194,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','187621',3673195,'1750','246',1013664.44,1018581.22,4916.78,801435.14,0.00,0.00,0.00,0.00,0.00),('5','100','629','187621',3673196,'1751','247',3481682.55,3481682.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','187621',3673197,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','187804',3676490,'1747','246',1010232.42,1020860.48,10628.06,1732373.78,0.00,0.00,0.00,0.00,0.00),('5','100','627','187804',3676491,'1748','246',1686282.95,1686282.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','187804',3676492,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','187804',3676493,'1750','246',1018581.22,1025218.34,6637.12,1081850.56,0.00,0.00,0.00,0.00,0.00),('5','100','629','187804',3676494,'1751','247',3481682.55,3481682.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','187804',3676495,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','188095',3681500,'1747','246',1020860.48,1030655.74,9795.26,1596627.38,0.00,0.00,0.00,0.00,0.00),('5','100','627','188095',3681501,'1748','246',1686282.95,1686282.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','188095',3681502,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','188095',3681503,'1750','246',1025218.34,1031481.11,6262.77,1020831.51,0.00,0.00,0.00,0.00,0.00),('5','100','629','188095',3681504,'1751','247',3481682.55,3481682.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','188095',3681505,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','188293',3684896,'1747','246',1030655.74,1037761.75,7106.01,1158279.63,0.00,0.00,0.00,0.00,0.00),('5','100','627','188293',3684897,'1748','246',1686282.95,1686282.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','188293',3684898,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','188293',3684899,'1750','246',1031481.11,1034431.37,2950.26,480892.38,0.00,0.00,0.00,0.00,0.00),('5','100','629','188293',3684900,'1751','247',3481682.55,3481682.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','188293',3684901,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','188586',3690194,'1747','246',1037761.75,1045522.72,7760.97,1265038.11,0.00,0.00,0.00,0.00,0.00),('5','100','627','188586',3690195,'1748','246',1686282.95,1686282.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','188586',3690196,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','188586',3690197,'1750','246',1034431.37,1040870.10,6438.73,1049512.99,0.00,0.00,0.00,0.00,0.00),('5','100','629','188586',3690198,'1751','247',3481682.55,3481682.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','188586',3690199,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','188597',3690309,'1747','246',1045522.72,1053318.32,7795.60,1270682.80,0.00,0.00,0.00,0.00,0.00),('5','100','627','188597',3690310,'1748','246',1686282.95,1686282.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','188597',3690311,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','188597',3690312,'1750','246',1040870.10,1045831.38,4961.28,808688.64,0.00,0.00,0.00,0.00,0.00),('5','100','629','188597',3690313,'1751','247',3481682.55,3481682.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','188597',3690314,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','188826',3694198,'1747','246',1053318.32,1060339.01,7020.69,1144372.47,0.00,0.00,0.00,0.00,0.00),('5','100','627','188826',3694199,'1748','246',1686282.95,1689700.59,3417.64,557075.32,0.00,0.00,0.00,0.00,0.00),('5','100','628','188826',3694200,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','188826',3694201,'1750','246',1045831.38,1048312.02,2480.64,404344.32,0.00,0.00,0.00,0.00,0.00),('5','100','629','188826',3694202,'1751','247',3481682.55,3481682.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','188826',3694203,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','188986',3697341,'1747','246',1060339.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','188986',3697342,'1748','246',1689700.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','188986',3697343,'1749','246',305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','188986',3697344,'1750','246',1048312.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','188986',3697345,'1751','247',3481682.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','188986',3697346,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','189014',3697735,'1747','246',1060339.01,1066767.77,6428.76,1047887.88,0.00,0.00,0.00,0.00,0.00),('5','100','627','189014',3697736,'1748','246',1689700.59,1694100.69,4400.10,717216.30,0.00,0.00,0.00,0.00,0.00),('5','100','628','189014',3697737,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','189014',3697738,'1750','246',1048312.02,1048312.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','189014',3697739,'1751','247',3481682.55,3481682.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','189014',3697740,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','189271',3702212,'1747','246',1066767.77,1073077.94,6310.17,1028557.71,0.00,0.00,0.00,0.00,0.00),('5','100','627','189271',3702213,'1748','246',1694100.69,1700450.70,6350.01,1035051.63,0.00,0.00,0.00,0.00,0.00),('5','100','628','189271',3702214,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','189271',3702215,'1750','246',1048312.02,1048312.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','189271',3702216,'1751','247',3481682.55,3481682.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','189271',3702217,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','190495',3724695,'1747','246',1073077.94,1073077.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','190495',3724696,'1748','246',1700450.70,1700450.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','190495',3724697,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','190495',3724698,'1750','246',1048312.02,1048312.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','190495',3724699,'1751','247',3481682.55,3482092.71,410.16,108692.40,0.00,0.00,0.00,0.00,0.00),('5','100','630','190495',3724700,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','191186',3737297,'1747','246',1073077.94,1073077.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','191186',3737298,'1748','246',1700450.70,1700450.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','191186',3737299,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','191186',3737300,'1750','246',1048312.02,1048312.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','191186',3737301,'1751','247',3482092.71,3482121.00,28.29,7496.85,0.00,0.00,0.00,0.00,0.00),('5','100','630','191186',3737302,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','191267',3738940,'1747','246',1073077.94,1073077.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','191267',3738941,'1748','246',1700450.70,1700450.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','191267',3738942,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','191267',3738943,'1750','246',1048312.02,1048312.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','191267',3738944,'1751','247',3482121.00,3482658.92,537.92,142548.80,0.00,0.00,0.00,0.00,0.00),('5','100','630','191267',3738945,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','191319',3739585,'1747','246',1073077.94,1073077.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','191319',3739586,'1748','246',1700450.70,1700450.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','191319',3739587,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','191319',3739588,'1750','246',1048312.02,1048312.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','191319',3739589,'1751','247',3482658.92,3482889.26,230.34,61040.10,0.00,0.00,0.00,0.00,0.00),('5','100','630','191319',3739590,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','191323',3739635,'1747','246',1073077.94,1073077.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','191323',3739636,'1748','246',1700450.70,1700450.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','191323',3739637,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','191323',3739638,'1750','246',1048312.02,1048312.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','191323',3739639,'1751','247',3482889.26,3482983.93,94.67,25087.55,0.00,0.00,0.00,0.00,0.00),('5','100','630','191323',3739640,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','191325',3739642,'1747','246',1073077.94,1073077.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','191325',3739643,'1748','246',1700450.70,1700450.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','191325',3739644,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','191325',3739645,'1750','246',1048312.02,1048312.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','191325',3739646,'1751','247',3482983.93,3483543.65,559.72,148325.80,0.00,0.00,0.00,0.00,0.00),('5','100','630','191325',3739647,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','191329',3739692,'1747','246',1073077.94,1073077.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','191329',3739693,'1748','246',1700450.70,1700450.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','191329',3739694,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','191329',3739695,'1750','246',1048312.02,1048312.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','191329',3739696,'1751','247',3483543.65,3483622.13,78.48,20797.20,0.00,0.00,0.00,0.00,0.00),('5','100','630','191329',3739697,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','191331',3739721,'1747','246',1073077.94,1076637.15,3559.21,587269.65,0.00,0.00,0.00,0.00,0.00),('5','100','627','191331',3739722,'1748','246',1700450.70,1702218.42,1767.72,291673.80,0.00,0.00,0.00,0.00,0.00),('5','100','628','191331',3739723,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','191331',3739724,'1750','246',1048312.02,1048312.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','191331',3739725,'1751','247',3483622.13,3483822.87,200.74,53196.10,0.00,0.00,0.00,0.00,0.00),('5','100','630','191331',3739726,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','191334',3739761,'1747','246',1076637.15,1079329.65,2692.50,444262.50,0.00,0.00,0.00,0.00,0.00),('5','100','627','191334',3739762,'1748','246',1702218.42,1704264.24,2045.82,337560.30,0.00,0.00,0.00,0.00,0.00),('5','100','628','191334',3739763,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','191334',3739764,'1750','246',1048312.02,1048312.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','191334',3739765,'1751','247',3483822.87,3483846.81,23.94,6344.10,0.00,0.00,0.00,0.00,0.00),('5','100','630','191334',3739766,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','191671',3746515,'1747','246',1079329.65,1080774.10,1444.45,238334.25,0.00,0.00,0.00,0.00,0.00),('5','100','627','191671',3746516,'1748','246',1704264.24,1706174.46,1910.22,315186.30,0.00,0.00,0.00,0.00,0.00),('5','100','628','191671',3746517,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','191671',3746518,'1750','246',1048312.02,1048312.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','191671',3746519,'1751','247',3483846.81,3483947.93,101.12,26796.80,0.00,0.00,0.00,0.00,0.00),('5','100','630','191671',3746520,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','192029',3753121,'1747','246',1080774.10,1080774.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','192029',3753122,'1748','246',1706174.46,1706174.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','192029',3753123,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','192029',3753124,'1750','246',1048312.02,1048312.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','192029',3753125,'1751','247',3483947.93,3484165.03,217.10,57531.50,0.00,0.00,0.00,0.00,0.00),('5','100','630','192029',3753126,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','192169',3755528,'1747','246',1080774.10,1080774.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','192169',3755529,'1748','246',1706174.46,1706174.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','192169',3755530,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','192169',3755531,'1750','246',1048312.02,1048312.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','192169',3755532,'1751','247',3484165.03,3484276.35,111.32,29499.80,0.00,0.00,0.00,0.00,0.00),('5','100','630','192169',3755533,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','192181',3755698,'1747','246',1080774.10,1084980.69,4206.59,694087.35,0.00,0.00,0.00,0.00,0.00),('5','100','627','192181',3755699,'1748','246',1706174.46,1709104.46,2930.00,483450.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','192181',3755700,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','192181',3755701,'1750','246',1048312.02,1048312.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','192181',3755702,'1751','247',3484276.35,3484839.29,562.94,149179.10,0.00,0.00,0.00,0.00,0.00),('5','100','630','192181',3755703,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','192326',3758745,'1747','246',1084980.69,1089319.22,4338.53,715857.45,0.00,0.00,0.00,0.00,0.00),('5','100','627','192326',3758746,'1748','246',1709104.46,1713174.62,4070.16,671576.40,0.00,0.00,0.00,0.00,0.00),('5','100','628','192326',3758747,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','192326',3758748,'1750','246',1048312.02,1048312.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','192326',3758749,'1751','247',3484839.29,3484924.16,84.87,22490.55,0.00,0.00,0.00,0.00,0.00),('5','100','630','192326',3758750,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','192643',3764157,'1747','246',1089319.22,1093399.52,4080.30,673249.50,0.00,0.00,0.00,0.00,0.00),('5','100','627','192643',3764158,'1748','246',1713174.62,1714003.25,828.63,136723.95,0.00,0.00,0.00,0.00,0.00),('5','100','628','192643',3764159,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','192643',3764160,'1750','246',1048312.02,1053514.96,5202.94,858485.10,0.00,0.00,0.00,0.00,0.00),('5','100','629','192643',3764161,'1751','247',3484924.16,3485172.81,248.65,65892.25,0.00,0.00,0.00,0.00,0.00),('5','100','630','192643',3764162,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','192937',3769757,'1747','246',1093399.52,1097158.73,3759.21,620269.65,0.00,0.00,0.00,0.00,0.00),('5','100','627','192937',3769758,'1748','246',1714003.25,1714003.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','192937',3769759,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','192937',3769760,'1750','246',1053514.96,1057206.20,3691.24,609054.60,0.00,0.00,0.00,0.00,0.00),('5','100','629','192937',3769761,'1751','247',3485172.81,3485394.23,221.42,58676.30,0.00,0.00,0.00,0.00,0.00),('5','100','630','192937',3769762,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','193038',3771391,'1747','246',1097158.73,1098128.22,969.49,159965.85,0.00,0.00,0.00,0.00,0.00),('5','100','627','193038',3771392,'1748','246',1714003.25,1715088.75,1085.50,179107.50,0.00,0.00,0.00,0.00,0.00),('5','100','628','193038',3771393,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','193038',3771394,'1750','246',1057206.20,1059573.20,2367.00,390555.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','193038',3771395,'1751','247',3485394.23,3485517.84,123.61,32756.65,0.00,0.00,0.00,0.00,0.00),('5','100','630','193038',3771396,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','193288',3776209,'1747','246',1098128.22,1098128.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','193288',3776210,'1748','246',1715088.75,1715088.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','193288',3776211,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','193288',3776212,'1750','246',1059573.20,1062374.79,2801.59,462262.35,0.00,0.00,0.00,0.00,0.00),('5','100','629','193288',3776213,'1751','247',3485517.84,3485590.61,72.77,19284.05,0.00,0.00,0.00,0.00,0.00),('5','100','630','193288',3776214,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','193744',3784917,'1747','246',1098128.22,1098128.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','193744',3784918,'1748','246',1715088.75,1715088.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','193744',3784919,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','193744',3784920,'1750','246',1062374.79,1062374.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','193744',3784921,'1751','247',3485590.61,3485725.98,135.37,35873.05,0.00,0.00,0.00,0.00,0.00),('5','100','630','193744',3784922,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','193825',3786559,'1747','246',1098128.22,1098128.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','193825',3786560,'1748','246',1715088.75,1715088.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','193825',3786561,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','193825',3786562,'1750','246',1062374.79,1062374.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','193825',3786563,'1751','247',3485725.98,3485890.07,164.09,43483.85,0.00,0.00,0.00,0.00,0.00),('5','100','630','193825',3786564,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','193994',3789274,'1747','246',1098128.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','193994',3789275,'1748','246',1715088.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','193994',3789276,'1749','246',305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','193994',3789277,'1750','246',1062374.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','193994',3789278,'1751','247',3485890.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','193994',3789279,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','194218',3793412,'1747','246',1098128.22,1098128.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','194218',3793413,'1748','246',1715088.75,1715088.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','194218',3793414,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','194218',3793415,'1750','246',1062374.79,1062374.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','194218',3793416,'1751','247',3485890.07,3485909.65,19.58,5188.70,0.00,0.00,0.00,0.00,0.00),('5','100','630','194218',3793417,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','194453',3797836,'1747','246',1098128.22,1099582.16,1453.94,239900.10,0.00,0.00,0.00,0.00,0.00),('5','100','627','194453',3797837,'1748','246',1715088.75,1717890.77,2802.02,462333.30,0.00,0.00,0.00,0.00,0.00),('5','100','628','194453',3797838,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','194453',3797839,'1750','246',1062374.79,1062374.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','194453',3797840,'1751','247',3485909.65,3486090.65,181.00,47965.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','194453',3797841,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','194564',3799507,'1747','246',1099582.16,1100936.32,1354.16,223436.40,0.00,0.00,0.00,0.00,0.00),('5','100','627','194564',3799508,'1748','246',1717890.77,1719573.69,1682.92,277681.80,0.00,0.00,0.00,0.00,0.00),('5','100','628','194564',3799509,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','194564',3799510,'1750','246',1062374.79,1063012.71,637.92,105256.80,0.00,0.00,0.00,0.00,0.00),('5','100','629','194564',3799511,'1751','247',3486090.65,3486150.81,60.16,15942.40,0.00,0.00,0.00,0.00,0.00),('5','100','630','194564',3799512,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','194911',3806408,'1747','246',1100936.32,1104108.33,3172.01,523381.65,0.00,0.00,0.00,0.00,0.00),('5','100','627','194911',3806409,'1748','246',1719573.69,1721827.18,2253.49,371825.85,0.00,0.00,0.00,0.00,0.00),('5','100','628','194911',3806410,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','194911',3806411,'1750','246',1063012.71,1063891.32,878.61,144970.65,0.00,0.00,0.00,0.00,0.00),('5','100','629','194911',3806412,'1751','247',3486150.81,3486350.63,199.82,52952.30,0.00,0.00,0.00,0.00,0.00),('5','100','630','194911',3806413,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','195136',3810329,'1747','246',1104108.33,1105746.58,1638.25,270311.25,0.00,0.00,0.00,0.00,0.00),('5','100','627','195136',3810330,'1748','246',1721827.18,1724905.20,3078.02,507873.30,0.00,0.00,0.00,0.00,0.00),('5','100','628','195136',3810331,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','195136',3810332,'1750','246',1063891.32,1065180.04,1288.72,212638.80,0.00,0.00,0.00,0.00,0.00),('5','100','629','195136',3810333,'1751','247',3486350.63,3486517.70,167.07,44273.55,0.00,0.00,0.00,0.00,0.00),('5','100','630','195136',3810334,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','195285',3813172,'1747','246',1105746.58,1105746.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','195285',3813173,'1748','246',1724905.20,1728533.87,3628.67,598730.55,0.00,0.00,0.00,0.00,0.00),('5','100','628','195285',3813174,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','195285',3813175,'1750','246',1065180.04,1068225.20,3045.16,502451.40,0.00,0.00,0.00,0.00,0.00),('5','100','629','195285',3813176,'1751','247',3486517.70,3487063.47,545.77,144629.05,0.00,0.00,0.00,0.00,0.00),('5','100','630','195285',3813177,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','195412',3815134,'1747','246',1105746.58,1105746.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','195412',3815135,'1748','246',1728533.87,1731431.64,2897.77,478132.05,0.00,0.00,0.00,0.00,0.00),('5','100','628','195412',3815136,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','195412',3815137,'1750','246',1068225.20,1070450.36,2225.16,367151.40,0.00,0.00,0.00,0.00,0.00),('5','100','629','195412',3815138,'1751','247',3487063.47,3487174.87,111.40,29521.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','195412',3815139,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','195747',3821011,'1747','246',1105746.58,1105746.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','195747',3821012,'1748','246',1731431.64,1734506.22,3074.58,507305.70,0.00,0.00,0.00,0.00,0.00),('5','100','628','195747',3821013,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','195747',3821014,'1750','246',1070450.36,1073289.06,2838.70,468385.50,0.00,0.00,0.00,0.00,0.00),('5','100','629','195747',3821015,'1751','247',3487174.87,3487909.83,734.96,194764.40,0.00,0.00,0.00,0.00,0.00),('5','100','630','195747',3821016,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','196016',3825750,'1747','246',1105746.58,1106907.97,1161.39,191629.35,0.00,0.00,0.00,0.00,0.00),('5','100','627','196016',3825751,'1748','246',1734506.22,1739210.96,4704.74,776282.10,0.00,0.00,0.00,0.00,0.00),('5','100','628','196016',3825752,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','196016',3825753,'1750','246',1073289.06,1076527.21,3238.15,534294.75,0.00,0.00,0.00,0.00,0.00),('5','100','629','196016',3825754,'1751','247',3487909.83,3488188.08,278.25,73736.25,0.00,0.00,0.00,0.00,0.00),('5','100','630','196016',3825755,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','196030',3825985,'1747','246',1106907.97,1110065.97,3158.00,521070.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','196030',3825986,'1748','246',1739210.96,1742492.84,3281.88,541510.20,0.00,0.00,0.00,0.00,0.00),('5','100','628','196030',3825987,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','196030',3825988,'1750','246',1076527.21,1076527.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','196030',3825989,'1751','247',3488188.08,3488338.15,150.07,39768.55,0.00,0.00,0.00,0.00,0.00),('5','100','630','196030',3825990,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','196319',3831468,'1747','246',1110065.97,1112029.52,1963.55,323985.75,0.00,0.00,0.00,0.00,0.00),('5','100','627','196319',3831469,'1748','246',1742492.84,1744941.18,2448.34,403976.10,0.00,0.00,0.00,0.00,0.00),('5','100','628','196319',3831470,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','196319',3831471,'1750','246',1076527.21,1076527.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','196319',3831472,'1751','247',3488338.15,3488508.61,170.46,45171.90,0.00,0.00,0.00,0.00,0.00),('5','100','630','196319',3831473,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','196536',3835385,'1747','246',1112029.52,1112029.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','196536',3835386,'1748','246',1744941.18,1744941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','196536',3835387,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','196536',3835388,'1750','246',1076527.21,1076527.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','196536',3835389,'1751','247',3488508.61,3488550.58,41.97,11122.05,0.00,0.00,0.00,0.00,0.00),('5','100','630','196536',3835390,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','196814',3840313,'1747','246',1112029.52,1112029.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','196814',3840314,'1748','246',1744941.18,1744941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','196814',3840315,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','196814',3840316,'1750','246',1076527.21,1076527.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','196814',3840317,'1751','247',3488550.58,3488675.06,124.48,32987.20,0.00,0.00,0.00,0.00,0.00),('5','100','630','196814',3840318,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','197209',3847403,'1747','246',1112029.52,1112352.86,323.34,53351.10,0.00,0.00,0.00,0.00,0.00),('5','100','627','197209',3847404,'1748','246',1744941.18,1745084.95,143.77,23722.05,0.00,0.00,0.00,0.00,0.00),('5','100','628','197209',3847405,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','197209',3847406,'1750','246',1076527.21,1076527.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','197209',3847407,'1751','247',3488675.06,3488682.60,7.54,1998.10,0.00,0.00,0.00,0.00,0.00),('5','100','630','197209',3847408,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','197279',3849010,'1747','246',1112352.86,1115100.87,2748.01,453421.65,0.00,0.00,0.00,0.00,0.00),('5','100','627','197279',3849011,'1748','246',1745084.95,1746447.85,1362.90,224878.50,0.00,0.00,0.00,0.00,0.00),('5','100','628','197279',3849012,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','197279',3849013,'1750','246',1076527.21,1076527.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','197279',3849014,'1751','247',3488682.60,3488895.78,213.18,56492.70,0.00,0.00,0.00,0.00,0.00),('5','100','630','197279',3849015,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','197737',3856276,'1747','246',1115100.87,1117778.14,2677.27,441749.55,0.00,0.00,0.00,0.00,0.00),('5','100','627','197737',3856277,'1748','246',1746447.85,1748561.79,2113.94,348800.10,0.00,0.00,0.00,0.00,0.00),('5','100','628','197737',3856278,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','197737',3856279,'1750','246',1076527.21,1076527.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','197737',3856280,'1751','247',3488895.78,3489064.95,169.17,44830.05,0.00,0.00,0.00,0.00,0.00),('5','100','630','197737',3856281,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','197841',3858367,'1747','246',1117778.14,1121580.76,3802.62,627432.30,0.00,0.00,0.00,0.00,0.00),('5','100','627','197841',3858368,'1748','246',1748561.79,1750675.47,2113.68,348757.20,0.00,0.00,0.00,0.00,0.00),('5','100','628','197841',3858369,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','197841',3858370,'1750','246',1076527.21,1076527.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','197841',3858371,'1751','247',3489064.95,3489352.99,288.04,76330.60,0.00,0.00,0.00,0.00,0.00),('5','100','630','197841',3858372,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','197920',3859564,'1747','246',1121580.76,1124629.46,3048.70,503035.50,0.00,0.00,0.00,0.00,0.00),('5','100','627','197920',3859565,'1748','246',1750675.47,1754439.81,3764.34,621116.10,0.00,0.00,0.00,0.00,0.00),('5','100','628','197920',3859566,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','197920',3859567,'1750','246',1076527.21,1076527.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','197920',3859568,'1751','247',3489352.99,3489460.16,107.17,28400.05,0.00,0.00,0.00,0.00,0.00),('5','100','630','197920',3859569,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','197928',3859713,'1747','246',1124629.46,1127422.15,2792.69,460793.85,0.00,0.00,0.00,0.00,0.00),('5','100','627','197928',3859714,'1748','246',1754439.81,1756415.06,1975.25,325916.25,0.00,0.00,0.00,0.00,0.00),('5','100','628','197928',3859715,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','197928',3859716,'1750','246',1076527.21,1076527.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','197928',3859717,'1751','247',3489460.16,3489549.58,89.42,23696.30,0.00,0.00,0.00,0.00,0.00),('5','100','630','197928',3859718,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','198303',3866365,'1747','246',1127422.15,1134603.65,7181.50,1184947.50,0.00,0.00,0.00,0.00,0.00),('5','100','627','198303',3866366,'1748','246',1756415.06,1762470.78,6055.72,999193.80,0.00,0.00,0.00,0.00,0.00),('5','100','628','198303',3866367,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','198303',3866368,'1750','246',1076527.21,1076527.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','198303',3866369,'1751','247',3489549.58,3489732.89,183.31,48577.15,0.00,0.00,0.00,0.00,0.00),('5','100','630','198303',3866370,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','198333',3866864,'1747','246',1134603.65,1137689.36,3085.71,509142.15,0.00,0.00,0.00,0.00,0.00),('5','100','627','198333',3866865,'1748','246',1762470.78,1766565.46,4094.68,675622.20,0.00,0.00,0.00,0.00,0.00),('5','100','628','198333',3866866,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','198333',3866867,'1750','246',1076527.21,1082500.77,5973.56,985637.40,0.00,0.00,0.00,0.00,0.00),('5','100','629','198333',3866868,'1751','247',3489732.89,3489861.22,128.33,34649.10,0.00,0.00,0.00,0.00,0.00),('5','100','630','198333',3866869,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','198673',3872645,'1747','246',1137689.36,1137689.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','198673',3872646,'1748','246',1766565.46,1769176.31,2610.85,430790.25,0.00,0.00,0.00,0.00,0.00),('5','100','628','198673',3872647,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','198673',3872648,'1750','246',1082500.77,1085298.31,2797.54,461594.10,0.00,0.00,0.00,0.00,0.00),('5','100','629','198673',3872649,'1751','247',3489861.22,3490094.01,232.79,62853.30,0.00,0.00,0.00,0.00,0.00),('5','100','630','198673',3872650,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','198958',3877509,'1747','246',1137689.36,1138147.68,458.32,75622.80,0.00,0.00,0.00,0.00,0.00),('5','100','627','198958',3877510,'1748','246',1769176.31,1773207.95,4031.64,665220.60,0.00,0.00,0.00,0.00,0.00),('5','100','628','198958',3877511,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','198958',3877512,'1750','246',1085298.31,1087029.06,1730.75,285573.75,0.00,0.00,0.00,0.00,0.00),('5','100','629','198958',3877513,'1751','247',3490094.01,3490533.04,439.03,118538.10,0.00,0.00,0.00,0.00,0.00),('5','100','630','198958',3877514,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','199003',3878141,'1747','246',1138147.68,1138147.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','199003',3878142,'1748','246',1773207.95,1776332.46,3124.51,515544.15,0.00,0.00,0.00,0.00,0.00),('5','100','628','199003',3878143,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','199003',3878144,'1750','246',1087029.06,1089907.46,2878.40,474936.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','199003',3878145,'1751','247',3490533.04,3490722.45,189.41,51140.70,0.00,0.00,0.00,0.00,0.00),('5','100','630','199003',3878146,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','199283',3882789,'1747','246',1138147.68,1138147.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','199283',3882790,'1748','246',1776332.46,1779631.06,3298.60,544269.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','199283',3882791,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','199283',3882792,'1750','246',1089907.46,1093600.28,3692.82,609315.30,0.00,0.00,0.00,0.00,0.00),('5','100','629','199283',3882793,'1751','247',3490722.45,3490783.73,61.28,16545.60,0.00,0.00,0.00,0.00,0.00),('5','100','630','199283',3882794,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','199500',3886396,'1747','246',1138147.68,1138147.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','199500',3886397,'1748','246',1779631.06,1784368.15,4737.09,781619.85,0.00,0.00,0.00,0.00,0.00),('5','100','628','199500',3886398,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','199500',3886399,'1750','246',1093600.28,1097899.23,4298.95,709326.75,0.00,0.00,0.00,0.00,0.00),('5','100','629','199500',3886400,'1751','247',3490783.73,3490923.25,139.52,37670.40,0.00,0.00,0.00,0.00,0.00),('5','100','630','199500',3886401,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','199649',3889216,'1747','246',1138147.68,1138147.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','199649',3889217,'1748','246',1784368.15,1788144.59,3776.44,623112.60,0.00,0.00,0.00,0.00,0.00),('5','100','628','199649',3889218,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','199649',3889219,'1750','246',1097899.23,1101562.54,3663.31,604446.15,0.00,0.00,0.00,0.00,0.00),('5','100','629','199649',3889220,'1751','247',3490923.25,3490923.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','199649',3889221,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','199969',3894364,'1747','246',1138147.68,1138147.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','199969',3894365,'1748','246',1788144.59,1790699.36,2554.77,421537.05,0.00,0.00,0.00,0.00,0.00),('5','100','628','199969',3894366,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','199969',3894367,'1750','246',1101562.54,1104796.31,3233.77,533572.05,0.00,0.00,0.00,0.00,0.00),('5','100','629','199969',3894368,'1751','247',3490923.25,3491389.23,465.98,125814.60,0.00,0.00,0.00,0.00,0.00),('5','100','630','199969',3894369,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','200266',3899899,'1747','246',1138147.68,1138147.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','200266',3899900,'1748','246',1790699.36,1794371.89,3672.53,605967.45,0.00,0.00,0.00,0.00,0.00),('5','100','628','200266',3899901,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','200266',3899902,'1750','246',1104796.31,1107497.53,2701.22,445701.30,0.00,0.00,0.00,0.00,0.00),('5','100','629','200266',3899903,'1751','247',3491389.23,3491389.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','200266',3899904,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','200459',3903393,'1747','246',1138147.68,1138147.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','200459',3903394,'1748','246',1794371.89,1798236.02,3864.13,637581.45,0.00,0.00,0.00,0.00,0.00),('5','100','628','200459',3903395,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','200459',3903396,'1750','246',1107497.53,1111960.37,4462.84,736368.60,0.00,0.00,0.00,0.00,0.00),('5','100','629','200459',3903397,'1751','247',3491389.23,3491389.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','200459',3903398,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','200622',3906254,'1747','246',1138147.68,1138147.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','200622',3906255,'1748','246',1798236.02,1800400.51,2164.49,357140.85,0.00,0.00,0.00,0.00,0.00),('5','100','628','200622',3906256,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','200622',3906257,'1750','246',1111960.37,1114928.76,2968.39,489784.35,0.00,0.00,0.00,0.00,0.00),('5','100','629','200622',3906258,'1751','247',3491389.23,3491389.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','200622',3906259,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','200858',3910547,'1747','246',1138147.68,1138147.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','200858',3910548,'1748','246',1800400.51,1803812.21,3411.70,562930.50,0.00,0.00,0.00,0.00,0.00),('5','100','628','200858',3910549,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','200858',3910550,'1750','246',1114928.76,1117866.42,2937.66,484713.90,0.00,0.00,0.00,0.00,0.00),('5','100','629','200858',3910551,'1751','247',3491389.23,3493928.05,2538.82,685481.40,0.00,0.00,0.00,0.00,0.00),('5','100','630','200858',3910552,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','200999',3912657,'1747','246',1138147.68,1138147.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','200999',3912658,'1748','246',1803812.21,1806224.86,2412.65,398087.25,0.00,0.00,0.00,0.00,0.00),('5','100','628','200999',3912659,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','200999',3912660,'1750','246',1117866.42,1119982.81,2116.39,349204.35,0.00,0.00,0.00,0.00,0.00),('5','100','629','200999',3912661,'1751','247',3493928.05,3494137.10,209.05,56443.50,0.00,0.00,0.00,0.00,0.00),('5','100','630','200999',3912662,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','201117',3914659,'1747','246',1138147.68,1140090.07,1942.39,320494.35,0.00,0.00,0.00,0.00,0.00),('5','100','627','201117',3914660,'1748','246',1806224.86,1809441.00,3216.14,530663.10,0.00,0.00,0.00,0.00,0.00),('5','100','628','201117',3914661,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','201117',3914662,'1750','246',1119982.81,1121099.60,1116.79,184270.35,0.00,0.00,0.00,0.00,0.00),('5','100','629','201117',3914663,'1751','247',3494137.10,3494574.37,437.27,118062.90,0.00,0.00,0.00,0.00,0.00),('5','100','630','201117',3914664,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','201389',3919203,'1747','246',1140090.07,1140090.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','201389',3919204,'1748','246',1809441.00,1812018.85,2577.85,425345.25,0.00,0.00,0.00,0.00,0.00),('5','100','628','201389',3919205,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','201389',3919206,'1750','246',1121099.60,1123090.25,1990.65,328457.25,0.00,0.00,0.00,0.00,0.00),('5','100','629','201389',3919207,'1751','247',3494574.37,3494895.56,321.19,86721.30,0.00,0.00,0.00,0.00,0.00),('5','100','630','201389',3919208,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','201555',3922318,'1747','246',1140090.07,1140090.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','201555',3922319,'1748','246',1812018.85,1814902.54,2883.69,475808.85,0.00,0.00,0.00,0.00,0.00),('5','100','628','201555',3922320,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','201555',3922321,'1750','246',1123090.25,1125769.53,2679.28,442081.20,0.00,0.00,0.00,0.00,0.00),('5','100','629','201555',3922322,'1751','247',3494895.56,3495233.53,337.97,91251.90,0.00,0.00,0.00,0.00,0.00),('5','100','630','201555',3922323,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','201918',3929443,'1747','246',1140090.07,1140090.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','201918',3929444,'1748','246',1814902.54,1817892.52,2989.98,493346.70,0.00,0.00,0.00,0.00,0.00),('5','100','628','201918',3929445,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','201918',3929446,'1750','246',1125769.53,1128243.52,2473.99,408208.35,0.00,0.00,0.00,0.00,0.00),('5','100','629','201918',3929447,'1751','247',3495233.53,3495451.30,217.77,58797.90,0.00,0.00,0.00,0.00,0.00),('5','100','630','201918',3929448,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','202049',3931808,'1747','246',1140090.07,1140090.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','202049',3931809,'1748','246',1817892.52,1819924.77,2032.25,335321.25,0.00,0.00,0.00,0.00,0.00),('5','100','628','202049',3931810,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','202049',3931811,'1750','246',1128243.52,1130508.26,2264.74,373682.10,0.00,0.00,0.00,0.00,0.00),('5','100','629','202049',3931812,'1751','247',3495451.30,3495649.90,198.60,54615.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','202049',3931813,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','202201',3934534,'1747','246',1140090.07,1140090.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','202201',3934535,'1748','246',1819924.77,1822714.32,2789.55,460275.75,0.00,0.00,0.00,0.00,0.00),('5','100','628','202201',3934536,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','202201',3934537,'1750','246',1130508.26,1132759.69,2251.43,371485.95,0.00,0.00,0.00,0.00,0.00),('5','100','629','202201',3934538,'1751','247',3495649.90,3495865.56,215.66,59306.50,0.00,0.00,0.00,0.00,0.00),('5','100','630','202201',3934539,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','202637',3942122,'1747','246',1140090.07,1141008.68,918.61,151570.65,0.00,0.00,0.00,0.00,0.00),('5','100','627','202637',3942123,'1748','246',1822714.32,1826079.71,3365.39,555289.35,0.00,0.00,0.00,0.00,0.00),('5','100','628','202637',3942124,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','202637',3942125,'1750','246',1132759.69,1136194.82,3435.13,566796.45,0.00,0.00,0.00,0.00,0.00),('5','100','629','202637',3942126,'1751','247',3495865.56,3496041.41,175.85,48358.75,0.00,0.00,0.00,0.00,0.00),('5','100','630','202637',3942127,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','202719',3943370,'1747','246',1141008.68,1141008.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','202719',3943371,'1748','246',1826079.71,1829291.94,3212.23,530017.95,0.00,0.00,0.00,0.00,0.00),('5','100','628','202719',3943372,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','202719',3943373,'1750','246',1136194.82,1138844.00,2649.18,437114.70,0.00,0.00,0.00,0.00,0.00),('5','100','629','202719',3943374,'1751','247',3496041.41,3506337.60,10296.19,2831452.25,0.00,0.00,0.00,0.00,0.00),('5','100','630','202719',3943375,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','202840',3945803,'1747','246',1141008.68,1142413.95,1405.27,231869.55,0.00,0.00,0.00,0.00,0.00),('5','100','627','202840',3945804,'1748','246',1829291.94,1829978.36,686.42,113259.30,0.00,0.00,0.00,0.00,0.00),('5','100','628','202840',3945805,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','202840',3945806,'1750','246',1138844.00,1141540.21,2696.21,444874.65,0.00,0.00,0.00,0.00,0.00),('5','100','629','202840',3945807,'1751','247',3506337.60,3506543.49,205.89,56619.75,0.00,0.00,0.00,0.00,0.00),('5','100','630','202840',3945808,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','203179',3952006,'1747','246',1142413.95,1145445.15,3031.20,500148.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','203179',3952007,'1748','246',1829978.36,1829978.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','203179',3952008,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','203179',3952009,'1750','246',1141540.21,1141540.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','203179',3952010,'1751','247',3506543.49,3506771.98,228.49,62834.75,0.00,0.00,0.00,0.00,0.00),('5','100','630','203179',3952011,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','203505',3958121,'1747','246',1145445.15,1147985.06,2539.91,419085.15,0.00,0.00,0.00,0.00,0.00),('5','100','627','203505',3958122,'1748','246',1829978.36,1829978.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','203505',3958123,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','203505',3958124,'1750','246',1141540.21,1145253.38,3713.17,612673.05,0.00,0.00,0.00,0.00,0.00),('5','100','629','203505',3958125,'1751','247',3506771.98,3506949.70,177.72,48873.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','203505',3958126,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','203541',3958526,'1747','246',1147985.06,1149917.21,1932.15,318804.75,0.00,0.00,0.00,0.00,0.00),('5','100','627','203541',3958527,'1748','246',1829978.36,1829978.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','203541',3958528,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','203541',3958529,'1750','246',1145253.38,1148476.44,3223.06,531804.90,0.00,0.00,0.00,0.00,0.00),('5','100','629','203541',3958530,'1751','247',3506949.70,3507036.38,86.68,23837.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','203541',3958531,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','203720',3961931,'1747','246',1149917.21,1152936.33,3019.12,498154.80,0.00,0.00,0.00,0.00,0.00),('5','100','627','203720',3961932,'1748','246',1829978.36,1829978.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','203720',3961933,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','203720',3961934,'1750','246',1148476.44,1152181.87,3705.43,611395.95,0.00,0.00,0.00,0.00,0.00),('5','100','629','203720',3961935,'1751','247',3507036.38,3507072.25,35.87,9864.25,0.00,0.00,0.00,0.00,0.00),('5','100','630','203720',3961936,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','204155',3969808,'1747','246',1152936.33,1154253.14,1316.81,217273.65,0.00,0.00,0.00,0.00,0.00),('5','100','627','204155',3969809,'1748','246',1829978.36,1829978.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','204155',3969810,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','204155',3969811,'1750','246',1152181.87,1155394.19,3212.32,530032.80,0.00,0.00,0.00,0.00,0.00),('5','100','629','204155',3969812,'1751','247',3507072.25,3507151.27,79.02,21730.50,0.00,0.00,0.00,0.00,0.00),('5','100','630','204155',3969813,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','204311',3972404,'1747','246',1154253.14,1154399.42,146.28,24136.20,0.00,0.00,0.00,0.00,0.00),('5','100','627','204311',3972405,'1748','246',1829978.36,1831320.94,1342.58,221525.70,0.00,0.00,0.00,0.00,0.00),('5','100','628','204311',3972406,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','204311',3972407,'1750','246',1155394.19,1159280.98,3886.79,641320.35,0.00,0.00,0.00,0.00,0.00),('5','100','629','204311',3972408,'1751','247',3507151.27,3507296.11,144.84,39831.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','204311',3972409,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','204400',3974020,'1747','246',1154399.42,1154399.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','204400',3974021,'1748','246',1831320.94,1833600.92,2279.98,376196.70,0.00,0.00,0.00,0.00,0.00),('5','100','628','204400',3974022,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','204400',3974023,'1750','246',1159280.98,1161727.39,2446.41,403657.65,0.00,0.00,0.00,0.00,0.00),('5','100','629','204400',3974024,'1751','247',3507296.11,3508122.89,826.78,227364.50,0.00,0.00,0.00,0.00,0.00),('5','100','630','204400',3974025,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','204790',3981229,'1747','246',1154399.42,1154399.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','204790',3981230,'1748','246',1833600.92,1836654.30,3053.38,503807.70,0.00,0.00,0.00,0.00,0.00),('5','100','628','204790',3981231,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','204790',3981232,'1750','246',1161727.39,1166389.33,4661.94,769220.10,0.00,0.00,0.00,0.00,0.00),('5','100','629','204790',3981233,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','204790',3981234,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','205568',3994720,'1747','246',1154399.42,1154399.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','205568',3994721,'1748','246',1836654.30,1837284.68,630.38,104012.70,0.00,0.00,0.00,0.00,0.00),('5','100','628','205568',3994722,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','205568',3994723,'1750','246',1166389.33,1167187.52,798.19,131701.35,0.00,0.00,0.00,0.00,0.00),('5','100','629','205568',3994724,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','205568',3994725,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','205575',3994864,'1747','246',1154399.42,1154763.65,364.23,60097.95,0.00,0.00,0.00,0.00,0.00),('5','100','627','205575',3994865,'1748','246',1837284.68,1840217.79,2933.11,483963.15,0.00,0.00,0.00,0.00,0.00),('5','100','628','205575',3994866,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','205575',3994867,'1750','246',1167187.52,1170827.15,3639.63,600538.95,0.00,0.00,0.00,0.00,0.00),('5','100','629','205575',3994868,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','205575',3994869,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','205583',3995061,'1747','246',1154763.65,1156658.71,1895.06,312684.90,0.00,0.00,0.00,0.00,0.00),('5','100','627','205583',3995062,'1748','246',1840217.79,1842520.23,2302.44,379902.60,0.00,0.00,0.00,0.00,0.00),('5','100','628','205583',3995063,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','205583',3995064,'1750','246',1170827.15,1172323.12,1495.97,246835.05,0.00,0.00,0.00,0.00,0.00),('5','100','629','205583',3995065,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','205583',3995066,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','205590',3995193,'1747','246',1156658.71,1157524.79,866.08,142903.20,0.00,0.00,0.00,0.00,0.00),('5','100','627','205590',3995194,'1748','246',1842520.23,1843634.44,1114.21,183844.65,0.00,0.00,0.00,0.00,0.00),('5','100','628','205590',3995195,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','205590',3995196,'1750','246',1172323.12,1173252.69,929.57,153379.05,0.00,0.00,0.00,0.00,0.00),('5','100','629','205590',3995197,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','205590',3995198,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','205794',3998857,'1747','246',1157524.79,1159319.87,1795.08,296188.20,0.00,0.00,0.00,0.00,0.00),('5','100','627','205794',3998858,'1748','246',1843634.44,1845887.16,2252.72,371698.80,0.00,0.00,0.00,0.00,0.00),('5','100','628','205794',3998859,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','205794',3998860,'1750','246',1173252.69,1174956.49,1703.80,281127.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','205794',3998861,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','205794',3998862,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','206019',4002800,'1747','246',1159319.87,1159319.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','206019',4002801,'1748','246',1845887.16,1848379.71,2492.55,411270.75,0.00,0.00,0.00,0.00,0.00),('5','100','628','206019',4002802,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','206019',4002803,'1750','246',1174956.49,1177037.96,2081.47,343442.55,0.00,0.00,0.00,0.00,0.00),('5','100','629','206019',4002804,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','206019',4002805,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','206242',4006829,'1747','246',1159319.87,1159319.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','206242',4006830,'1748','246',1848379.71,1850996.15,2616.44,431712.60,0.00,0.00,0.00,0.00,0.00),('5','100','628','206242',4006831,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','206242',4006832,'1750','246',1177037.96,1179249.00,2211.04,364821.60,0.00,0.00,0.00,0.00,0.00),('5','100','629','206242',4006833,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','206242',4006834,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','206554',4012331,'1747','246',1159319.87,1159319.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','206554',4012332,'1748','246',1850996.15,1851205.78,209.63,34588.95,0.00,0.00,0.00,0.00,0.00),('5','100','628','206554',4012333,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','206554',4012334,'1750','246',1179249.00,1183621.74,4372.74,721502.10,0.00,0.00,0.00,0.00,0.00),('5','100','629','206554',4012335,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','206554',4012336,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','206710',4014998,'1747','246',1159319.87,1159319.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','206710',4014999,'1748','246',1851205.78,1851205.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','206710',4015000,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','206710',4015001,'1750','246',1183621.74,1187277.49,3655.75,603198.75,0.00,0.00,0.00,0.00,0.00),('5','100','629','206710',4015002,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','206710',4015003,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','206816',4016754,'1747','246',1159319.87,1159606.70,286.83,47326.95,0.00,0.00,0.00,0.00,0.00),('5','100','627','206816',4016755,'1748','246',1851205.78,1851623.25,417.47,68882.55,0.00,0.00,0.00,0.00,0.00),('5','100','628','206816',4016756,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','206816',4016757,'1750','246',1187277.49,1190890.05,3612.56,596072.40,0.00,0.00,0.00,0.00,0.00),('5','100','629','206816',4016758,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','206816',4016759,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','207078',4021415,'1747','246',1159606.70,1160044.69,437.99,72268.35,0.00,0.00,0.00,0.00,0.00),('5','100','627','207078',4021416,'1748','246',1851623.25,1853328.55,1705.30,281374.50,0.00,0.00,0.00,0.00,0.00),('5','100','628','207078',4021417,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','207078',4021418,'1750','246',1190890.05,1192369.69,1479.64,244140.60,0.00,0.00,0.00,0.00,0.00),('5','100','629','207078',4021419,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','207078',4021420,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','207282',4025121,'1747','246',1160044.69,1160616.39,571.70,94330.50,0.00,0.00,0.00,0.00,0.00),('5','100','627','207282',4025122,'1748','246',1853328.55,1855874.55,2546.00,420090.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','207282',4025123,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','207282',4025124,'1750','246',1192369.69,1194248.71,1879.02,310038.30,0.00,0.00,0.00,0.00,0.00),('5','100','629','207282',4025125,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','207282',4025126,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','207627',4031390,'1747','246',1160616.39,1160616.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','207627',4031391,'1748','246',1855874.55,1858232.98,2358.43,389140.95,0.00,0.00,0.00,0.00,0.00),('5','100','628','207627',4031392,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','207627',4031393,'1750','246',1194248.71,1195959.83,1711.12,282334.80,0.00,0.00,0.00,0.00,0.00),('5','100','629','207627',4031394,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','207627',4031395,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','207787',4033922,'1747','246',1160616.39,1160616.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','207787',4033923,'1748','246',1858232.98,1860706.46,2473.48,408124.20,0.00,0.00,0.00,0.00,0.00),('5','100','628','207787',4033924,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','207787',4033925,'1750','246',1195959.83,1197640.51,1680.68,277312.20,0.00,0.00,0.00,0.00,0.00),('5','100','629','207787',4033926,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','207787',4033927,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','207947',4036645,'1747','246',1160616.39,1160616.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','207947',4036646,'1748','246',1860706.46,1864045.11,3338.65,550877.25,0.00,0.00,0.00,0.00,0.00),('5','100','628','207947',4036647,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','207947',4036648,'1750','246',1197640.51,1197640.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','207947',4036649,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','207947',4036650,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','208282',4042985,'1747','246',1160616.39,1160616.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','208282',4042986,'1748','246',1864045.11,1865287.99,1242.88,205075.20,0.00,0.00,0.00,0.00,0.00),('5','100','628','208282',4042987,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','208282',4042988,'1750','246',1197640.51,1199574.57,1934.06,319119.90,0.00,0.00,0.00,0.00,0.00),('5','100','629','208282',4042989,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','208282',4042990,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','208498',4046565,'1747','246',1160616.39,1160616.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','208498',4046566,'1748','246',1865287.99,1867627.16,2339.17,385963.05,0.00,0.00,0.00,0.00,0.00),('5','100','628','208498',4046567,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','208498',4046568,'1750','246',1199574.57,1201571.61,1997.04,329511.60,0.00,0.00,0.00,0.00,0.00),('5','100','629','208498',4046569,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','208498',4046570,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','208602',4048158,'1747','246',1160616.39,1160616.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','208602',4048159,'1748','246',1867627.16,1869434.99,1807.83,298291.95,0.00,0.00,0.00,0.00,0.00),('5','100','628','208602',4048160,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','208602',4048161,'1750','246',1201571.61,1203201.09,1629.48,268864.20,0.00,0.00,0.00,0.00,0.00),('5','100','629','208602',4048162,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','208602',4048163,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','208784',4051354,'1747','246',1160616.39,1160616.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','208784',4051355,'1748','246',1869434.99,1872166.59,2731.60,450714.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','208784',4051356,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','208784',4051357,'1750','246',1203201.09,1205517.87,2316.78,382268.70,0.00,0.00,0.00,0.00,0.00),('5','100','629','208784',4051358,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','208784',4051359,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','209096',4056721,'1747','246',1160616.39,1160616.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','209096',4056722,'1748','246',1872166.59,1874173.87,2007.28,331201.20,0.00,0.00,0.00,0.00,0.00),('5','100','628','209096',4056723,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','209096',4056724,'1750','246',1205517.87,1207246.14,1728.27,285164.55,0.00,0.00,0.00,0.00,0.00),('5','100','629','209096',4056725,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','209096',4056726,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','209332',4060952,'1747','246',1160616.39,1160616.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','209332',4060953,'1748','246',1874173.87,1876250.08,2076.21,342574.65,0.00,0.00,0.00,0.00,0.00),('5','100','628','209332',4060954,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','209332',4060955,'1750','246',1207246.14,1209601.05,2354.91,388560.15,0.00,0.00,0.00,0.00,0.00),('5','100','629','209332',4060956,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','209332',4060957,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','209531',4064494,'1747','246',1160616.39,1160616.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','209531',4064495,'1748','246',1876250.08,1878297.81,2047.73,337875.45,0.00,0.00,0.00,0.00,0.00),('5','100','628','209531',4064496,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','209531',4064497,'1750','246',1209601.05,1211619.52,2018.47,333047.55,0.00,0.00,0.00,0.00,0.00),('5','100','629','209531',4064498,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','209531',4064499,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','209784',4069210,'1747','246',1160616.39,1160616.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','209784',4069211,'1748','246',1878297.81,1880034.34,1736.53,286527.45,0.00,0.00,0.00,0.00,0.00),('5','100','628','209784',4069212,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','209784',4069213,'1750','246',1211619.52,1213376.76,1757.24,289944.60,0.00,0.00,0.00,0.00,0.00),('5','100','629','209784',4069214,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','209784',4069215,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','210038',4073624,'1747','246',1160616.39,1160616.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','210038',4073625,'1748','246',1880034.34,1881893.66,1859.32,306787.80,0.00,0.00,0.00,0.00,0.00),('5','100','628','210038',4073626,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','210038',4073627,'1750','246',1213376.76,1215382.29,2005.53,330912.45,0.00,0.00,0.00,0.00,0.00),('5','100','629','210038',4073628,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','210038',4073629,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','210222',4076679,'1747','246',1160616.39,1160616.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','210222',4076680,'1748','246',1881893.66,1884658.64,2764.98,456221.70,0.00,0.00,0.00,0.00,0.00),('5','100','628','210222',4076681,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','210222',4076682,'1750','246',1215382.29,1216549.52,1167.23,192592.95,0.00,0.00,0.00,0.00,0.00),('5','100','629','210222',4076683,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','210222',4076684,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','210428',4080521,'1747','246',1160616.39,1160616.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','210428',4080522,'1748','246',1884658.64,1887835.42,3176.78,524168.70,0.00,0.00,0.00,0.00,0.00),('5','100','628','210428',4080523,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','210428',4080524,'1750','246',1216549.52,1218424.36,1874.84,309348.60,0.00,0.00,0.00,0.00,0.00),('5','100','629','210428',4080525,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','210428',4080526,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','210545',4082524,'1747','246',1160616.39,1161954.77,1338.38,220832.70,0.00,0.00,0.00,0.00,0.00),('5','100','627','210545',4082525,'1748','246',1887835.42,1890337.88,2502.46,412905.90,0.00,0.00,0.00,0.00,0.00),('5','100','628','210545',4082526,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','210545',4082527,'1750','246',1218424.36,1218685.92,261.56,43157.40,0.00,0.00,0.00,0.00,0.00),('5','100','629','210545',4082528,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','210545',4082529,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','210931',4089449,'1747','246',1161954.77,1163413.41,1458.64,240675.60,0.00,0.00,0.00,0.00,0.00),('5','100','627','210931',4089450,'1748','246',1890337.88,1891779.41,1441.53,237852.45,0.00,0.00,0.00,0.00,0.00),('5','100','628','210931',4089451,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','210931',4089452,'1750','246',1218685.92,1219647.34,961.42,158634.30,0.00,0.00,0.00,0.00,0.00),('5','100','629','210931',4089453,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','210931',4089454,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','211152',4093369,'1747','246',1163413.41,1164439.94,1026.53,169377.45,0.00,0.00,0.00,0.00,0.00),('5','100','627','211152',4093370,'1748','246',1891779.41,1893446.70,1667.29,275102.85,0.00,0.00,0.00,0.00,0.00),('5','100','628','211152',4093371,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','211152',4093372,'1750','246',1219647.34,1220933.49,1286.15,212214.75,0.00,0.00,0.00,0.00,0.00),('5','100','629','211152',4093373,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','211152',4093374,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','211187',4093732,'1747','246',1164439.94,1165333.54,893.60,147444.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','211187',4093733,'1748','246',1893446.70,1895742.44,2295.74,378797.10,0.00,0.00,0.00,0.00,0.00),('5','100','628','211187',4093734,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','211187',4093735,'1750','246',1220933.49,1222266.43,1332.94,219935.10,0.00,0.00,0.00,0.00,0.00),('5','100','629','211187',4093736,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','211187',4093737,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','211493',4099301,'1747','246',1165333.54,1165333.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','211493',4099302,'1748','246',1895742.44,1898406.72,2664.28,439606.20,0.00,0.00,0.00,0.00,0.00),('5','100','628','211493',4099303,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','211493',4099304,'1750','246',1222266.43,1224524.62,2258.19,372601.35,0.00,0.00,0.00,0.00,0.00),('5','100','629','211493',4099305,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','211493',4099306,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','211742',4103695,'1747','246',1165333.54,1165817.48,483.94,79850.10,0.00,0.00,0.00,0.00,0.00),('5','100','627','211742',4103696,'1748','246',1898406.72,1899145.19,738.47,121847.55,0.00,0.00,0.00,0.00,0.00),('5','100','628','211742',4103697,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','211742',4103698,'1750','246',1224524.62,1225598.26,1073.64,177150.60,0.00,0.00,0.00,0.00,0.00),('5','100','629','211742',4103699,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','211742',4103700,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','211849',4105214,'1747','246',1165817.48,1167421.92,1604.44,264732.60,0.00,0.00,0.00,0.00,0.00),('5','100','627','211849',4105215,'1748','246',1899145.19,1900664.98,1519.79,250765.35,0.00,0.00,0.00,0.00,0.00),('5','100','628','211849',4105216,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','211849',4105217,'1750','246',1225598.26,1226806.45,1208.19,199351.35,0.00,0.00,0.00,0.00,0.00),('5','100','629','211849',4105218,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','211849',4105219,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','212093',4109763,'1747','246',1167421.92,1167421.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','212093',4109764,'1748','246',1900664.98,1902767.88,2102.90,346978.50,0.00,0.00,0.00,0.00,0.00),('5','100','628','212093',4109765,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','212093',4109766,'1750','246',1226806.45,1228825.78,2019.33,333189.45,0.00,0.00,0.00,0.00,0.00),('5','100','629','212093',4109767,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','212093',4109768,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','212347',4114238,'1747','246',1167421.92,1169822.63,2400.71,396117.15,0.00,0.00,0.00,0.00,0.00),('5','100','627','212347',4114239,'1748','246',1902767.88,1905297.03,2529.15,417309.75,0.00,0.00,0.00,0.00,0.00),('5','100','628','212347',4114240,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','212347',4114241,'1750','246',1228825.78,1229077.24,251.46,41490.90,0.00,0.00,0.00,0.00,0.00),('5','100','629','212347',4114242,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','212347',4114243,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','212617',4119250,'1747','246',1169822.63,1171641.67,1819.04,300141.60,0.00,0.00,0.00,0.00,0.00),('5','100','627','212617',4119251,'1748','246',1905297.03,1907563.61,2266.58,373985.70,0.00,0.00,0.00,0.00,0.00),('5','100','628','212617',4119252,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','212617',4119253,'1750','246',1229077.24,1229380.17,302.93,49983.45,0.00,0.00,0.00,0.00,0.00),('5','100','629','212617',4119254,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','212617',4119255,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','212840',4123155,'1747','246',1171641.67,1173048.31,1406.64,232095.60,0.00,0.00,0.00,0.00,0.00),('5','100','627','212840',4123156,'1748','246',1907563.61,1909798.84,2235.23,368812.95,0.00,0.00,0.00,0.00,0.00),('5','100','628','212840',4123157,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','212840',4123158,'1750','246',1229380.17,1229502.29,122.12,20149.80,0.00,0.00,0.00,0.00,0.00),('5','100','629','212840',4123159,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','212840',4123160,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','213011',4126189,'1747','246',1173048.31,1174908.74,1860.43,306970.95,0.00,0.00,0.00,0.00,0.00),('5','100','627','213011',4126190,'1748','246',1909798.84,1911934.84,2136.00,352440.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','213011',4126191,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','213011',4126192,'1750','246',1229502.29,1229737.42,235.13,38796.45,0.00,0.00,0.00,0.00,0.00),('5','100','629','213011',4126193,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','213011',4126194,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','213123',4128116,'1747','246',1174908.74,1176595.02,1686.28,278236.20,0.00,0.00,0.00,0.00,0.00),('5','100','627','213123',4128117,'1748','246',1911934.84,1913958.92,2024.08,333973.20,0.00,0.00,0.00,0.00,0.00),('5','100','628','213123',4128118,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','213123',4128119,'1750','246',1229737.42,1230701.82,964.40,159126.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','213123',4128120,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','213123',4128121,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','213381',4132349,'1747','246',1176595.02,1178175.98,1580.96,260858.40,0.00,0.00,0.00,0.00,0.00),('5','100','627','213381',4132350,'1748','246',1913958.92,1916113.67,2154.75,355533.75,0.00,0.00,0.00,0.00,0.00),('5','100','628','213381',4132351,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','213381',4132352,'1750','246',1230701.82,1232228.58,1526.76,251915.40,0.00,0.00,0.00,0.00,0.00),('5','100','629','213381',4132353,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','213381',4132354,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','213623',4136358,'1747','246',1178175.98,1178175.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','213623',4136359,'1748','246',1916113.67,1918622.05,2508.38,413882.70,0.00,0.00,0.00,0.00,0.00),('5','100','628','213623',4136360,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','213623',4136361,'1750','246',1232228.58,1234879.74,2651.16,437441.40,0.00,0.00,0.00,0.00,0.00),('5','100','629','213623',4136362,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','213623',4136363,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','213930',4141172,'1747','246',1178175.98,1178175.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','213930',4141173,'1748','246',1918622.05,1920688.77,2066.72,341008.80,0.00,0.00,0.00,0.00,0.00),('5','100','628','213930',4141174,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','213930',4141175,'1750','246',1234879.74,1238126.46,3246.72,535708.80,0.00,0.00,0.00,0.00,0.00),('5','100','629','213930',4141176,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','213930',4141177,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','214313',4148064,'1747','246',1178175.98,1178175.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','214313',4148065,'1748','246',1920688.77,1923159.89,2471.12,407734.80,0.00,0.00,0.00,0.00,0.00),('5','100','628','214313',4148066,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','214313',4148067,'1750','246',1238126.46,1240818.00,2691.54,444104.10,0.00,0.00,0.00,0.00,0.00),('5','100','629','214313',4148068,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','214313',4148069,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','214495',4151152,'1747','246',1178175.98,1178829.64,653.66,107853.90,0.00,0.00,0.00,0.00,0.00),('5','100','627','214495',4151153,'1748','246',1923159.89,1925368.47,2208.58,364415.70,0.00,0.00,0.00,0.00,0.00),('5','100','628','214495',4151154,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','214495',4151155,'1750','246',1240818.00,1242369.03,1551.03,255919.95,0.00,0.00,0.00,0.00,0.00),('5','100','629','214495',4151156,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','214495',4151157,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','214541',4151701,'1747','246',1178829.64,1180131.14,1301.50,214747.50,0.00,0.00,0.00,0.00,0.00),('5','100','627','214541',4151702,'1748','246',1925368.47,1927706.55,2338.08,385783.20,0.00,0.00,0.00,0.00,0.00),('5','100','628','214541',4151703,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','214541',4151704,'1750','246',1242369.03,1243877.80,1508.77,248947.05,0.00,0.00,0.00,0.00,0.00),('5','100','629','214541',4151705,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','214541',4151706,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','214780',4155890,'1747','246',1180131.14,1181255.40,1124.26,185502.90,0.00,0.00,0.00,0.00,0.00),('5','100','627','214780',4155891,'1748','246',1927706.55,1929390.26,1683.71,277812.15,0.00,0.00,0.00,0.00,0.00),('5','100','628','214780',4155892,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','214780',4155893,'1750','246',1243877.80,1244823.15,945.35,155982.75,0.00,0.00,0.00,0.00,0.00),('5','100','629','214780',4155894,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','214780',4155895,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','215000',4159544,'1747','246',1181255.40,1182675.90,1420.50,234382.50,0.00,0.00,0.00,0.00,0.00),('5','100','627','215000',4159545,'1748','246',1929390.26,1931466.16,2075.90,342523.50,0.00,0.00,0.00,0.00,0.00),('5','100','628','215000',4159546,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','215000',4159547,'1750','246',1244823.15,1246240.93,1417.78,233933.70,0.00,0.00,0.00,0.00,0.00),('5','100','629','215000',4159548,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','215000',4159549,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','215249',4163789,'1747','246',1182675.90,1184143.12,1467.22,242091.30,0.00,0.00,0.00,0.00,0.00),('5','100','627','215249',4163790,'1748','246',1931466.16,1933091.57,1625.41,268192.65,0.00,0.00,0.00,0.00,0.00),('5','100','628','215249',4163791,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','215249',4163792,'1750','246',1246240.93,1247580.97,1340.04,221106.60,0.00,0.00,0.00,0.00,0.00),('5','100','629','215249',4163793,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','215249',4163794,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','215479',4167595,'1747','246',1184143.12,1185788.90,1645.78,271553.70,0.00,0.00,0.00,0.00,0.00),('5','100','627','215479',4167596,'1748','246',1933091.57,1934702.81,1611.24,265854.60,0.00,0.00,0.00,0.00,0.00),('5','100','628','215479',4167597,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','215479',4167598,'1750','246',1247580.97,1248605.73,1024.76,169085.40,0.00,0.00,0.00,0.00,0.00),('5','100','629','215479',4167599,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','215479',4167600,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','215886',4174776,'1747','246',1185788.90,1185788.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','215886',4174777,'1748','246',1934702.81,1936603.01,1900.20,313533.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','215886',4174778,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','215886',4174779,'1750','246',1248605.73,1250388.22,1782.49,294110.85,0.00,0.00,0.00,0.00,0.00),('5','100','629','215886',4174780,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','215886',4174781,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','216074',4178076,'1747','246',1185788.90,1185788.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','216074',4178077,'1748','246',1936603.01,1938547.30,1944.29,320807.85,0.00,0.00,0.00,0.00,0.00),('5','100','628','216074',4178078,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','216074',4178079,'1750','246',1250388.22,1252025.03,1636.81,270073.65,0.00,0.00,0.00,0.00,0.00),('5','100','629','216074',4178080,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','216074',4178081,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','216098',4178428,'1747','246',1185788.90,1185788.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','216098',4178429,'1748','246',1938547.30,1940644.51,2097.21,346039.65,0.00,0.00,0.00,0.00,0.00),('5','100','628','216098',4178430,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','216098',4178431,'1750','246',1252025.03,1254301.02,2275.99,375538.35,0.00,0.00,0.00,0.00,0.00),('5','100','629','216098',4178432,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','216098',4178433,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','216393',4183287,'1747','246',1185788.90,1185788.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','216393',4183288,'1748','246',1940644.51,1941743.74,1099.23,181372.95,0.00,0.00,0.00,0.00,0.00),('5','100','628','216393',4183289,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','216393',4183290,'1750','246',1254301.02,1256246.52,1945.50,321007.50,0.00,0.00,0.00,0.00,0.00),('5','100','629','216393',4183291,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','216393',4183292,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','216592',4186701,'1747','246',1185788.90,1185788.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','216592',4186702,'1748','246',1941743.74,1941743.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','216592',4186703,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','216592',4186704,'1750','246',1256246.52,1259977.22,3730.70,615565.50,0.00,0.00,0.00,0.00,0.00),('5','100','629','216592',4186705,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','216592',4186706,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','216804',4190653,'1747','246',1185788.90,1185788.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','216804',4190654,'1748','246',1941743.74,1941743.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','216804',4190655,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','216804',4190656,'1750','246',1259977.22,1263651.34,3674.12,606229.80,0.00,0.00,0.00,0.00,0.00),('5','100','629','216804',4190657,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','216804',4190658,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','217033',4194601,'1747','246',1185788.90,1185788.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','217033',4194602,'1748','246',1941743.74,1941743.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','217033',4194603,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','217033',4194604,'1750','246',1263651.34,1267281.37,3630.03,598954.95,0.00,0.00,0.00,0.00,0.00),('5','100','629','217033',4194605,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','217033',4194606,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','217457',4202443,'1747','246',1185788.90,1185788.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','217457',4202444,'1748','246',1941743.74,1941743.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','217457',4202445,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','217457',4202446,'1750','246',1267281.37,1271367.05,4085.68,674137.20,0.00,0.00,0.00,0.00,0.00),('5','100','629','217457',4202447,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','217457',4202448,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','217660',4206077,'1747','246',1185788.90,1185788.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','217660',4206078,'1748','246',1941743.74,1943268.43,1524.69,251573.85,0.00,0.00,0.00,0.00,0.00),('5','100','628','217660',4206079,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','217660',4206080,'1750','246',1271367.05,1273046.69,1679.64,277140.60,0.00,0.00,0.00,0.00,0.00),('5','100','629','217660',4206081,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','217660',4206082,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','217831',4209005,'1747','246',1185788.90,1185788.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','217831',4209006,'1748','246',1943268.43,1945486.56,2218.13,365991.45,0.00,0.00,0.00,0.00,0.00),('5','100','628','217831',4209007,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','217831',4209008,'1750','246',1273046.69,1274862.53,1815.84,299613.60,0.00,0.00,0.00,0.00,0.00),('5','100','629','217831',4209009,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','217831',4209010,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','218001',4211906,'1747','246',1185788.90,1185788.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','218001',4211907,'1748','246',1945486.56,1947291.30,1804.74,297782.10,0.00,0.00,0.00,0.00,0.00),('5','100','628','218001',4211908,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','218001',4211909,'1750','246',1274862.53,1276755.37,1892.84,312318.60,0.00,0.00,0.00,0.00,0.00),('5','100','629','218001',4211910,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','218001',4211911,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','218255',4216258,'1747','246',1185788.90,1185788.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','218255',4216259,'1748','246',1947291.30,1949375.42,2084.12,343879.80,0.00,0.00,0.00,0.00,0.00),('5','100','628','218255',4216260,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','218255',4216261,'1750','246',1276755.37,1278884.30,2128.93,351273.45,0.00,0.00,0.00,0.00,0.00),('5','100','629','218255',4216262,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','218255',4216263,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','218440',4219770,'1747','246',1185788.90,1185788.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','218440',4219771,'1748','246',1949375.42,1951545.59,2170.17,358078.05,0.00,0.00,0.00,0.00,0.00),('5','100','628','218440',4219772,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','218440',4219773,'1750','246',1278884.30,1280693.20,1808.90,298468.50,0.00,0.00,0.00,0.00,0.00),('5','100','629','218440',4219774,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','218440',4219775,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','218668',4223921,'1747','246',1185788.90,1187362.58,1573.68,259657.20,0.00,0.00,0.00,0.00,0.00),('5','100','627','218668',4223922,'1748','246',1951545.59,1953440.63,1895.04,312681.60,0.00,0.00,0.00,0.00,0.00),('5','100','628','218668',4223923,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','218668',4223924,'1750','246',1280693.20,1281029.21,336.01,55441.65,0.00,0.00,0.00,0.00,0.00),('5','100','629','218668',4223925,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','218668',4223926,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','218919',4228102,'1747','246',1187362.58,1189463.71,2101.13,346686.45,0.00,0.00,0.00,0.00,0.00),('5','100','627','218919',4228103,'1748','246',1953440.63,1954912.29,1471.66,242823.90,0.00,0.00,0.00,0.00,0.00),('5','100','628','218919',4228104,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','218919',4228105,'1750','246',1281029.21,1281029.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','218919',4228106,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','218919',4228107,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','219130',4231703,'1747','246',1189463.71,1190563.77,1100.06,181509.90,0.00,0.00,0.00,0.00,0.00),('5','100','627','219130',4231704,'1748','246',1954912.29,1956728.81,1816.52,299725.80,0.00,0.00,0.00,0.00,0.00),('5','100','628','219130',4231705,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','219130',4231706,'1750','246',1281029.21,1281029.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','219130',4231707,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','219130',4231708,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','219352',4235499,'1747','246',1190563.77,1190563.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','219352',4235500,'1748','246',1956728.81,1956728.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','219352',4235501,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','219352',4235502,'1750','246',1281029.21,1281029.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','219352',4235503,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','219352',4235504,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','219559',4239371,'1747','246',1190563.77,1193582.08,3018.31,498021.15,0.00,0.00,0.00,0.00,0.00),('5','100','627','219559',4239372,'1748','246',1956728.81,1959600.08,2871.27,473759.55,0.00,0.00,0.00,0.00,0.00),('5','100','628','219559',4239373,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','219559',4239374,'1750','246',1281029.21,1281029.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','219559',4239375,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','219559',4239376,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','219612',4239912,'1747','246',1193582.08,1196315.10,2733.02,450948.30,0.00,0.00,0.00,0.00,0.00),('5','100','627','219612',4239913,'1748','246',1959600.08,1962139.76,2539.68,419047.20,0.00,0.00,0.00,0.00,0.00),('5','100','628','219612',4239914,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','219612',4239915,'1750','246',1281029.21,1281890.33,861.12,142084.80,0.00,0.00,0.00,0.00,0.00),('5','100','629','219612',4239916,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','219612',4239917,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','219820',4243764,'1747','246',1196315.10,1197973.84,1658.74,273692.10,0.00,0.00,0.00,0.00,0.00),('5','100','627','219820',4243765,'1748','246',1962139.76,1964087.51,1947.75,321378.75,0.00,0.00,0.00,0.00,0.00),('5','100','628','219820',4243766,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','219820',4243767,'1750','246',1281890.33,1283091.70,1201.37,198226.05,0.00,0.00,0.00,0.00,0.00),('5','100','629','219820',4243768,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','219820',4243769,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','220026',4247770,'1747','246',1197973.84,1199467.18,1493.34,246401.10,0.00,0.00,0.00,0.00,0.00),('5','100','627','220026',4247771,'1748','246',1964087.51,1965667.27,1579.76,260660.40,0.00,0.00,0.00,0.00,0.00),('5','100','628','220026',4247772,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','220026',4247773,'1750','246',1283091.70,1283995.28,903.58,149090.70,0.00,0.00,0.00,0.00,0.00),('5','100','629','220026',4247774,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','220026',4247775,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','220286',4251990,'1747','246',1199467.18,1200510.14,1042.96,172088.40,0.00,0.00,0.00,0.00,0.00),('5','100','627','220286',4251991,'1748','246',1965667.27,1967613.85,1946.58,321185.70,0.00,0.00,0.00,0.00,0.00),('5','100','628','220286',4251992,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','220286',4251993,'1750','246',1283995.28,1285360.42,1365.14,225248.10,0.00,0.00,0.00,0.00,0.00),('5','100','629','220286',4251994,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','220286',4251995,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','220772',4260572,'1747','246',1200510.14,1200510.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','220772',4260573,'1748','246',1967613.85,1970033.68,2419.83,399271.95,0.00,0.00,0.00,0.00,0.00),('5','100','628','220772',4260574,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','220772',4260575,'1750','246',1285360.42,1287438.07,2077.65,342812.25,0.00,0.00,0.00,0.00,0.00),('5','100','629','220772',4260576,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','220772',4260577,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','220872',4262784,'1747','246',1200510.14,1200510.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','220872',4262785,'1748','246',1970033.68,1970033.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','220872',4262786,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','220872',4262787,'1750','246',1287438.07,1290454.70,3016.63,497743.95,0.00,0.00,0.00,0.00,0.00),('5','100','629','220872',4262788,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','220872',4262789,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','220940',4263619,'1747','246',1200510.14,1200510.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','220940',4263620,'1748','246',1970033.68,1970033.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','220940',4263621,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','220940',4263622,'1750','246',1290454.70,1294529.76,4075.06,672384.90,0.00,0.00,0.00,0.00,0.00),('5','100','629','220940',4263623,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','220940',4263624,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','221295',4270008,'1747','246',1200510.14,1200510.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','221295',4270009,'1748','246',1970033.68,1970033.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','221295',4270010,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','221295',4270011,'1750','246',1294529.76,1298181.02,3651.26,602457.90,0.00,0.00,0.00,0.00,0.00),('5','100','629','221295',4270012,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','221295',4270013,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','221427',4272309,'1747','246',1200510.14,1201575.23,1065.09,175739.85,0.00,0.00,0.00,0.00,0.00),('5','100','627','221427',4272310,'1748','246',1970033.68,1971289.12,1255.44,207147.60,0.00,0.00,0.00,0.00,0.00),('5','100','628','221427',4272311,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','221427',4272312,'1750','246',1298181.02,1299778.89,1597.87,263648.55,0.00,0.00,0.00,0.00,0.00),('5','100','629','221427',4272313,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','221427',4272314,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','221624',4276109,'1747','246',1201575.23,1202400.87,825.64,136230.60,0.00,0.00,0.00,0.00,0.00),('5','100','627','221624',4276110,'1748','246',1971289.12,1972963.29,1674.17,276238.05,0.00,0.00,0.00,0.00,0.00),('5','100','628','221624',4276111,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','221624',4276112,'1750','246',1299778.89,1301162.08,1383.19,228226.35,0.00,0.00,0.00,0.00,0.00),('5','100','629','221624',4276113,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','221624',4276114,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','221947',4281790,'1747','246',1202400.87,1203116.39,715.52,118060.80,0.00,0.00,0.00,0.00,0.00),('5','100','627','221947',4281791,'1748','246',1972963.29,1975213.15,2249.86,371226.90,0.00,0.00,0.00,0.00,0.00),('5','100','628','221947',4281792,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','221947',4281793,'1750','246',1301162.08,1302399.60,1237.52,204190.80,0.00,0.00,0.00,0.00,0.00),('5','100','629','221947',4281794,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','221947',4281795,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','222238',4287122,'1747','246',1203116.39,1203419.33,302.94,49985.10,0.00,0.00,0.00,0.00,0.00),('5','100','627','222238',4287123,'1748','246',1975213.15,1976814.07,1600.92,264151.80,0.00,0.00,0.00,0.00,0.00),('5','100','628','222238',4287124,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','222238',4287125,'1750','246',1302399.60,1303346.54,946.94,156245.10,0.00,0.00,0.00,0.00,0.00),('5','100','629','222238',4287126,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','222238',4287127,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','222287',4287660,'1747','246',1203419.33,1204161.41,742.08,122443.20,0.00,0.00,0.00,0.00,0.00),('5','100','627','222287',4287661,'1748','246',1976814.07,1978002.29,1188.22,196056.30,0.00,0.00,0.00,0.00,0.00),('5','100','628','222287',4287662,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','222287',4287663,'1750','246',1303346.54,1305144.71,1798.17,296698.05,0.00,0.00,0.00,0.00,0.00),('5','100','629','222287',4287664,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','222287',4287665,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','222517',4291587,'1747','246',1204161.41,1205384.52,1223.11,201813.15,0.00,0.00,0.00,0.00,0.00),('5','100','627','222517',4291588,'1748','246',1978002.29,1980121.75,2119.46,349710.90,0.00,0.00,0.00,0.00,0.00),('5','100','628','222517',4291589,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','222517',4291590,'1750','246',1305144.71,1306538.14,1393.43,229915.95,0.00,0.00,0.00,0.00,0.00),('5','100','629','222517',4291591,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','222517',4291592,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','222780',4296432,'1747','246',1205384.52,1205813.39,428.87,70763.55,0.00,0.00,0.00,0.00,0.00),('5','100','627','222780',4296433,'1748','246',1980121.75,1981869.65,1747.90,288403.50,0.00,0.00,0.00,0.00,0.00),('5','100','628','222780',4296434,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','222780',4296435,'1750','246',1306538.14,1307316.65,778.51,128454.15,0.00,0.00,0.00,0.00,0.00),('5','100','629','222780',4296436,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','222780',4296437,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','223054',4301771,'1747','246',1205813.39,1207874.72,2061.33,340119.45,0.00,0.00,0.00,0.00,0.00),('5','100','627','223054',4301772,'1748','246',1981869.65,1984213.30,2343.65,386702.25,0.00,0.00,0.00,0.00,0.00),('5','100','628','223054',4301773,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','223054',4301774,'1750','246',1307316.65,1307609.69,293.04,48351.60,0.00,0.00,0.00,0.00,0.00),('5','100','629','223054',4301775,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','223054',4301776,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','223238',4304546,'1747','246',1207874.72,1209606.21,1731.49,285695.85,0.00,0.00,0.00,0.00,0.00),('5','100','627','223238',4304547,'1748','246',1984213.30,1986393.56,2180.26,359742.90,0.00,0.00,0.00,0.00,0.00),('5','100','628','223238',4304548,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','223238',4304549,'1750','246',1307609.69,1307609.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','223238',4304550,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','223238',4304551,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','223536',4309898,'1747','246',1209606.21,1211647.70,2041.49,336845.85,0.00,0.00,0.00,0.00,0.00),('5','100','627','223536',4309899,'1748','246',1986393.56,1988195.26,1801.70,297280.50,0.00,0.00,0.00,0.00,0.00),('5','100','628','223536',4309900,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','223536',4309901,'1750','246',1307609.69,1307609.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','223536',4309902,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','223536',4309903,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','223831',4315717,'1747','246',1211647.70,1212092.52,444.82,73395.30,0.00,0.00,0.00,0.00,0.00),('5','100','627','223831',4315718,'1748','246',1988195.26,1988395.86,200.60,33099.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','223831',4315719,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','223831',4315720,'1750','246',1307609.69,1307609.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','223831',4315721,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','223831',4315722,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','224538',4327984,'1747','246',1212092.52,1212092.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','224538',4327985,'1748','246',1988395.86,1988395.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','224538',4327986,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','224538',4327987,'1750','246',1307609.69,1307609.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','224538',4327988,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','224538',4327989,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','224543',4328051,'1747','246',1212092.52,1212092.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','224543',4328052,'1748','246',1988395.86,1988395.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','224543',4328053,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','224543',4328054,'1750','246',1307609.69,1307609.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','224543',4328055,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','224543',4328056,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','224546',4328074,'1747','246',1212092.52,1212092.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','224546',4328075,'1748','246',1988395.86,1988395.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','224546',4328076,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','224546',4328077,'1750','246',1307609.69,1307609.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','224546',4328078,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','224546',4328079,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','224547',4328080,'1747','246',1212092.52,1213793.08,1700.56,280592.40,0.00,0.00,0.00,0.00,0.00),('5','100','627','224547',4328081,'1748','246',1988395.86,1990687.91,2292.05,378188.25,0.00,0.00,0.00,0.00,0.00),('5','100','628','224547',4328082,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','224547',4328083,'1750','246',1307609.69,1307609.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','224547',4328084,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','224547',4328085,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','224826',4332885,'1747','246',1213793.08,1215705.64,1912.56,311747.28,0.00,0.00,0.00,0.00,0.00),('5','100','627','224826',4332886,'1748','246',1990687.91,1992519.90,1831.99,298614.37,0.00,0.00,0.00,0.00,0.00),('5','100','628','224826',4332887,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','224826',4332888,'1750','246',1307609.69,1307609.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','224826',4332889,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','224826',4332890,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','225025',4336610,'1747','246',1215705.64,1216732.54,1026.90,169438.50,0.00,0.00,0.00,0.00,0.00),('5','100','627','225025',4336611,'1748','246',1992519.90,1994328.32,1808.42,298389.30,0.00,0.00,0.00,0.00,0.00),('5','100','628','225025',4336612,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','225025',4336613,'1750','246',1307609.69,1308587.20,977.51,161289.15,0.00,0.00,0.00,0.00,0.00),('5','100','629','225025',4336614,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','225025',4336615,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','225460',4344831,'1747','246',1216732.54,1217756.67,1024.13,168981.45,0.00,0.00,0.00,0.00,0.00),('5','100','627','225460',4344832,'1748','246',1994328.32,1995719.77,1391.45,229589.25,0.00,0.00,0.00,0.00,0.00),('5','100','628','225460',4344833,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','225460',4344834,'1750','246',1308587.20,1309895.43,1308.23,215857.95,0.00,0.00,0.00,0.00,0.00),('5','100','629','225460',4344835,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','225460',4344836,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','225668',4348473,'1747','246',1217756.67,1217756.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','225668',4348474,'1748','246',1995719.77,1997535.08,1815.31,299526.15,0.00,0.00,0.00,0.00,0.00),('5','100','628','225668',4348475,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','225668',4348476,'1750','246',1309895.43,1311488.55,1593.12,262864.80,0.00,0.00,0.00,0.00,0.00),('5','100','629','225668',4348477,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','225668',4348478,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','225801',4350419,'1747','246',1217756.67,1218816.33,1059.66,174843.90,0.00,0.00,0.00,0.00,0.00),('5','100','627','225801',4350420,'1748','246',1997535.08,1999385.90,1850.82,305385.30,0.00,0.00,0.00,0.00,0.00),('5','100','628','225801',4350421,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','225801',4350422,'1750','246',1311488.55,1312707.21,1218.66,201078.90,0.00,0.00,0.00,0.00,0.00),('5','100','629','225801',4350423,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','225801',4350424,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','225978',4353458,'1747','246',1218816.33,1220327.87,1511.54,246381.02,0.00,0.00,0.00,0.00,0.00),('5','100','627','225978',4353459,'1748','246',1999385.90,2001008.64,1622.74,264506.62,0.00,0.00,0.00,0.00,0.00),('5','100','628','225978',4353460,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','225978',4353461,'1750','246',1312707.21,1313895.57,1188.36,193702.68,0.00,0.00,0.00,0.00,0.00),('5','100','629','225978',4353462,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','225978',4353463,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','226424',4361731,'1747','246',1220327.87,1220327.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','226424',4361732,'1748','246',2001008.64,2002063.69,1055.05,171973.15,0.00,0.00,0.00,0.00,0.00),('5','100','628','226424',4361733,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','226424',4361734,'1750','246',1313895.57,1314903.11,1007.54,164229.02,0.00,0.00,0.00,0.00,0.00),('5','100','629','226424',4361735,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','226424',4361736,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','226510',4363045,'1747','246',1220327.87,1220327.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','226510',4363046,'1748','246',2002063.69,2004550.61,2486.92,405367.96,0.00,0.00,0.00,0.00,0.00),('5','100','628','226510',4363047,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','226510',4363048,'1750','246',1314903.11,1317274.42,2371.31,386523.53,0.00,0.00,0.00,0.00,0.00),('5','100','629','226510',4363049,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','226510',4363050,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','226767',4367725,'1747','246',1220327.87,1220327.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','226767',4367726,'1748','246',2004550.61,2006333.85,1783.24,290668.12,0.00,0.00,0.00,0.00,0.00),('5','100','628','226767',4367727,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','226767',4367728,'1750','246',1317274.42,1319782.66,2508.24,408843.12,0.00,0.00,0.00,0.00,0.00),('5','100','629','226767',4367729,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','226767',4367730,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','226979',4371535,'1747','246',1220327.87,1220327.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','226979',4371536,'1748','246',2006333.85,2008345.00,2011.15,327817.45,0.00,0.00,0.00,0.00,0.00),('5','100','628','226979',4371537,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','226979',4371538,'1750','246',1319782.66,1322303.63,2520.97,410918.11,0.00,0.00,0.00,0.00,0.00),('5','100','629','226979',4371539,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','226979',4371540,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','227218',4375622,'1747','246',1220327.87,1220327.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','227218',4375623,'1748','246',2008345.00,2008584.88,239.88,39100.44,0.00,0.00,0.00,0.00,0.00),('5','100','628','227218',4375624,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','227218',4375625,'1750','246',1322303.63,1326185.14,3881.51,632686.13,0.00,0.00,0.00,0.00,0.00),('5','100','629','227218',4375626,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','227218',4375627,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','227385',4378676,'1747','246',1220327.87,1220327.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','227385',4378677,'1748','246',2008584.88,2008584.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','227385',4378678,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','227385',4378679,'1750','246',1326185.14,1331961.34,5776.20,941520.60,0.00,0.00,0.00,0.00,0.00),('5','100','629','227385',4378680,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','227385',4378681,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','227618',4382666,'1747','246',1220327.87,1220327.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','227618',4382667,'1748','246',2008584.88,2008584.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','227618',4382668,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','227618',4382669,'1750','246',1331961.34,1334121.05,2159.71,352032.73,0.00,0.00,0.00,0.00,0.00),('5','100','629','227618',4382670,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','227618',4382671,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','227874',4387239,'1747','246',1220327.87,1220327.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','227874',4387240,'1748','246',2008584.88,2008584.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','227874',4387241,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','227874',4387242,'1750','246',1334121.05,1334121.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','227874',4387243,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','227874',4387244,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','231322',4451255,'1747','246',1220327.87,1220327.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','231322',4451256,'1748','246',2008584.88,2008584.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','231322',4451257,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','231322',4451258,'1750','246',1334121.05,1334121.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','231322',4451259,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','231322',4451260,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','231325',4451309,'1747','246',1220327.87,1220327.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','231325',4451310,'1748','246',2008584.88,2008584.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','231325',4451311,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','231325',4451312,'1750','246',1334121.05,1334121.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','231325',4451313,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','231325',4451314,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','231326',4451315,'1747','246',1220327.87,1220327.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','231326',4451316,'1748','246',2008584.88,2008584.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','231326',4451317,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','231326',4451318,'1750','246',1334121.05,1334121.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','231326',4451319,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','231326',4451320,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','231327',4451321,'1747','246',1220327.87,1220890.32,562.45,91679.35,0.00,0.00,0.00,0.00,0.00),('5','100','627','231327',4451322,'1748','246',2008584.88,2010392.00,1807.12,294560.56,0.00,0.00,0.00,0.00,0.00),('5','100','628','231327',4451323,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','231327',4451324,'1750','246',1334121.05,1334121.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','231327',4451325,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','231327',4451326,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','231328',4451327,'1747','246',1220890.32,1221610.53,720.21,117394.23,0.00,0.00,0.00,0.00,0.00),('5','100','627','231328',4451328,'1748','246',2010392.00,2013316.33,2924.33,476665.79,0.00,0.00,0.00,0.00,0.00),('5','100','628','231328',4451329,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','231328',4451330,'1750','246',1334121.05,1334121.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','231328',4451331,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','231328',4451332,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','231330',4451335,'1747','246',1221610.53,1224606.31,2995.78,488312.14,0.00,0.00,0.00,0.00,0.00),('5','100','627','231330',4451336,'1748','246',2013316.33,2015550.74,2234.41,364208.83,0.00,0.00,0.00,0.00,0.00),('5','100','628','231330',4451337,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','231330',4451338,'1750','246',1334121.05,1334121.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','231330',4451339,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','231330',4451340,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','231332',4451373,'1747','246',1224606.31,1227290.69,2684.38,437553.94,0.00,0.00,0.00,0.00,0.00),('5','100','627','231332',4451374,'1748','246',2015550.74,2018128.30,2577.56,420142.28,0.00,0.00,0.00,0.00,0.00),('5','100','628','231332',4451375,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','231332',4451376,'1750','246',1334121.05,1334121.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','231332',4451377,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','231332',4451378,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','231334',4451390,'1747','246',1227290.69,1229017.83,1727.14,281523.82,0.00,0.00,0.00,0.00,0.00),('5','100','627','231334',4451391,'1748','246',2018128.30,2019932.91,1804.61,294151.43,0.00,0.00,0.00,0.00,0.00),('5','100','628','231334',4451392,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','231334',4451393,'1750','246',1334121.05,1334121.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','231334',4451394,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','231334',4451395,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','231335',4451396,'1747','246',1229017.83,1230768.44,1750.61,285349.43,0.00,0.00,0.00,0.00,0.00),('5','100','627','231335',4451397,'1748','246',2019932.91,2021980.32,2047.41,333727.83,0.00,0.00,0.00,0.00,0.00),('5','100','628','231335',4451398,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','231335',4451399,'1750','246',1334121.05,1334121.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','231335',4451400,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','231335',4451401,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','231336',4451402,'1747','246',1230768.44,1232634.04,1865.60,304092.80,0.00,0.00,0.00,0.00,0.00),('5','100','627','231336',4451403,'1748','246',2021980.32,2024274.34,2294.02,373925.26,0.00,0.00,0.00,0.00,0.00),('5','100','628','231336',4451404,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','231336',4451405,'1750','246',1334121.05,1334121.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','231336',4451406,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','231336',4451407,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','231339',4451426,'1747','246',1232634.04,1233650.79,1016.75,165730.25,0.00,0.00,0.00,0.00,0.00),('5','100','627','231339',4451427,'1748','246',2024274.34,2025220.72,946.38,154259.94,0.00,0.00,0.00,0.00,0.00),('5','100','628','231339',4451428,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','231339',4451429,'1750','246',1334121.05,1334121.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','231339',4451430,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','231339',4451431,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','231378',4451844,'1747','246',1233650.79,1233650.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','231378',4451845,'1748','246',2025220.72,2025220.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','231378',4451846,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','231378',4451847,'1750','246',1334121.05,1334121.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','231378',4451848,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','231378',4451849,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','231470',4453310,'1747','246',1233650.79,1233650.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','231470',4453311,'1748','246',2025220.72,2025220.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','231470',4453312,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','231470',4453313,'1750','246',1334121.05,1334121.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','231470',4453314,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','231470',4453315,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','231472',4453324,'1747','246',1233650.79,1233650.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','231472',4453325,'1748','246',2025220.72,2025220.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','231472',4453326,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','231472',4453327,'1750','246',1334121.05,1334121.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','231472',4453328,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','231472',4453329,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','231473',4453330,'1747','246',1233650.79,1233650.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','231473',4453331,'1748','246',2025220.72,2025220.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','231473',4453332,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','231473',4453333,'1750','246',1334121.05,1334121.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','231473',4453334,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','231473',4453335,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','231715',4457813,'1747','246',1233650.79,1235198.77,1547.98,252320.74,0.00,0.00,0.00,0.00,0.00),('5','100','627','231715',4457814,'1748','246',2025220.72,2026807.86,1587.14,258703.82,0.00,0.00,0.00,0.00,0.00),('5','100','628','231715',4457815,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','231715',4457816,'1750','246',1334121.05,1334121.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','231715',4457817,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','231715',4457818,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','232063',4464428,'1747','246',1235198.77,1237367.34,2168.57,353476.91,0.00,0.00,0.00,0.00,0.00),('5','100','627','232063',4464429,'1748','246',2026807.86,2028530.83,1722.97,280844.11,0.00,0.00,0.00,0.00,0.00),('5','100','628','232063',4464430,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','232063',4464431,'1750','246',1334121.05,1334121.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','232063',4464432,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','232063',4464433,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','232329',4468888,'1747','246',1237367.34,1238787.69,1420.35,231517.05,0.00,0.00,0.00,0.00,0.00),('5','100','627','232329',4468889,'1748','246',2028530.83,2030109.73,1578.90,257360.70,0.00,0.00,0.00,0.00,0.00),('5','100','628','232329',4468890,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','232329',4468891,'1750','246',1334121.05,1334121.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','232329',4468892,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','232329',4468893,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','232373',4469514,'1747','246',1238787.69,1240197.03,1409.34,229722.42,0.00,0.00,0.00,0.00,0.00),('5','100','627','232373',4469515,'1748','246',2030109.73,2031956.71,1846.98,301057.74,0.00,0.00,0.00,0.00,0.00),('5','100','628','232373',4469516,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','232373',4469517,'1750','246',1334121.05,1334121.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','232373',4469518,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','232373',4469519,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','232653',4474783,'1747','246',1240197.03,1240825.34,628.31,102414.53,0.00,0.00,0.00,0.00,0.00),('5','100','627','232653',4474784,'1748','246',2031956.71,2033362.75,1406.04,229184.52,0.00,0.00,0.00,0.00,0.00),('5','100','628','232653',4474785,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','232653',4474786,'1750','246',1334121.05,1335548.16,1427.11,232618.93,0.00,0.00,0.00,0.00,0.00),('5','100','629','232653',4474787,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','232653',4474788,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','232900',4479086,'1747','246',1240825.34,1240825.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','232900',4479087,'1748','246',2033362.75,2035998.51,2635.76,429628.88,0.00,0.00,0.00,0.00,0.00),('5','100','628','232900',4479088,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','232900',4479089,'1750','246',1335548.16,1337704.18,2156.02,351431.26,0.00,0.00,0.00,0.00,0.00),('5','100','629','232900',4479090,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','232900',4479091,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','233147',4483587,'1747','246',1240825.34,1240825.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','233147',4483588,'1748','246',2035998.51,2038974.63,2976.12,485107.56,0.00,0.00,0.00,0.00,0.00),('5','100','628','233147',4483589,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','233147',4483590,'1750','246',1337704.18,1340483.72,2779.54,453065.02,0.00,0.00,0.00,0.00,0.00),('5','100','629','233147',4483591,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','233147',4483592,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','233434',4488610,'1747','246',1240825.34,1240825.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','233434',4488611,'1748','246',2038974.63,2041706.50,2731.87,445294.81,0.00,0.00,0.00,0.00,0.00),('5','100','628','233434',4488612,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','233434',4488613,'1750','246',1340483.72,1343119.15,2635.43,429575.09,0.00,0.00,0.00,0.00,0.00),('5','100','629','233434',4488614,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','233434',4488615,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','233723',4494016,'1747','246',1240825.34,1240825.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','233723',4494017,'1748','246',2041706.50,2042707.48,1000.98,163159.74,0.00,0.00,0.00,0.00,0.00),('5','100','628','233723',4494018,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','233723',4494019,'1750','246',1343119.15,1348242.77,5123.62,835150.06,0.00,0.00,0.00,0.00,0.00),('5','100','629','233723',4494020,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','233723',4494021,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','234209',4502988,'1747','246',1240825.34,1240825.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','234209',4502989,'1748','246',2042707.48,2042707.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','234209',4502990,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','234209',4502991,'1750','246',1348242.77,1351918.18,3675.41,599091.83,0.00,0.00,0.00,0.00,0.00),('5','100','629','234209',4502992,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','234209',4502993,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','234343',4505160,'1747','246',1240825.34,1240825.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','234343',4505161,'1748','246',2042707.48,2042707.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','234343',4505162,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','234343',4505163,'1750','246',1351918.18,1356548.03,4629.85,754665.55,0.00,0.00,0.00,0.00,0.00),('5','100','629','234343',4505164,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','234343',4505165,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','234506',4508181,'1747','246',1240825.34,1240825.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','234506',4508182,'1748','246',2042707.48,2042707.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','234506',4508183,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','234506',4508184,'1750','246',1356548.03,1360785.45,4237.42,699174.30,0.00,0.00,0.00,0.00,0.00),('5','100','629','234506',4508185,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','234506',4508186,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','234611',4509916,'1747','246',1240825.34,1240825.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','234611',4509917,'1748','246',2042707.48,2042707.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','234611',4509918,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','234611',4509919,'1750','246',1360785.45,1363204.59,2419.14,399158.10,0.00,0.00,0.00,0.00,0.00),('5','100','629','234611',4509920,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','234611',4509921,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','234876',4514721,'1747','246',1240825.34,1240825.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','234876',4514722,'1748','246',2042707.48,2042707.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','234876',4514723,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','234876',4514724,'1750','246',1363204.59,1364261.25,1056.66,174348.90,0.00,0.00,0.00,0.00,0.00),('5','100','629','234876',4514725,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','234876',4514726,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','235705',4529319,'1747','246',1240825.34,1240825.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','235705',4529320,'1748','246',2042707.48,2042707.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','235705',4529321,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','235705',4529322,'1750','246',1364261.25,1364261.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','235705',4529323,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','235705',4529324,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','235708',4529369,'1747','246',1240825.34,1240825.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','235708',4529370,'1748','246',2042707.48,2042707.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','235708',4529371,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','235708',4529372,'1750','246',1364261.25,1364261.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','235708',4529373,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','235708',4529374,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','235766',4530294,'1747','246',1240825.34,1241766.47,941.13,155286.45,0.00,0.00,0.00,0.00,0.00),('5','100','627','235766',4530295,'1748','246',2042707.48,2043860.63,1153.15,190269.75,0.00,0.00,0.00,0.00,0.00),('5','100','628','235766',4530296,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','235766',4530297,'1750','246',1364261.25,1364261.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','235766',4530298,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','235766',4530299,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','235841',4531722,'1747','246',1241766.47,1244819.41,3052.94,503735.10,0.00,0.00,0.00,0.00,0.00),('5','100','627','235841',4531723,'1748','246',2043860.63,2046769.06,2908.43,479890.95,0.00,0.00,0.00,0.00,0.00),('5','100','628','235841',4531724,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','235841',4531725,'1750','246',1364261.25,1364261.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','235841',4531726,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','235841',4531727,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','236119',4536648,'1747','246',1244819.41,1250115.65,5296.24,873879.60,0.00,0.00,0.00,0.00,0.00),('5','100','627','236119',4536649,'1748','246',2046769.06,2051178.92,4409.86,727626.90,0.00,0.00,0.00,0.00,0.00),('5','100','628','236119',4536650,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','236119',4536651,'1750','246',1364261.25,1364261.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','236119',4536652,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','236119',4536653,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','236363',4540916,'1747','246',1250115.65,1256095.14,5979.49,986615.85,0.00,0.00,0.00,0.00,0.00),('5','100','627','236363',4540917,'1748','246',2051178.92,2056335.61,5156.69,850853.85,0.00,0.00,0.00,0.00,0.00),('5','100','628','236363',4540918,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','236363',4540919,'1750','246',1364261.25,1364261.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','236363',4540920,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','236363',4540921,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','236552',4544028,'1747','246',1256095.14,1256611.28,516.14,85163.10,0.00,0.00,0.00,0.00,0.00),('5','100','627','236552',4544029,'1748','246',2056335.61,2056853.87,518.26,85512.90,0.00,0.00,0.00,0.00,0.00),('5','100','628','236552',4544030,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','236552',4544031,'1750','246',1364261.25,1364261.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','236552',4544032,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','236552',4544033,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','236911',4550407,'1747','246',1256611.28,1256611.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','236911',4550408,'1748','246',2056853.87,2056853.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','236911',4550409,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','236911',4550410,'1750','246',1364261.25,1364261.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','236911',4550411,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','236911',4550412,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','237398',4559107,'1747','246',1256611.28,1256611.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','237398',4559108,'1748','246',2056853.87,2056853.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','237398',4559109,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','237398',4559110,'1750','246',1364261.25,1364261.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','237398',4559111,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','237398',4559112,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','237809',4566157,'1747','246',1256611.28,1256611.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','237809',4566158,'1748','246',2056853.87,2056853.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','237809',4566159,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','237809',4566160,'1750','246',1364261.25,1364261.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','237809',4566161,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','237809',4566162,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','237810',4566163,'1747','246',1256611.28,1256611.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','237810',4566164,'1748','246',2056853.87,2056853.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','237810',4566165,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','237810',4566166,'1750','246',1364261.25,1364261.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','237810',4566167,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','237810',4566168,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','237813',4566213,'1747','246',1256611.28,1256611.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','237813',4566214,'1748','246',2056853.87,2056853.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','237813',4566215,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','237813',4566216,'1750','246',1364261.25,1364261.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','237813',4566217,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','237813',4566218,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','238002',4569206,'1747','246',1256611.28,1256611.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','238002',4569207,'1748','246',2056853.87,2056853.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','238002',4569208,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','238002',4569209,'1750','246',1364261.25,1364261.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','238002',4569210,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','238002',4569211,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','238247',4573438,'1747','246',1256611.28,1256611.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','238247',4573439,'1748','246',2056853.87,2056853.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','238247',4573440,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','238247',4573441,'1750','246',1364261.25,1364261.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','238247',4573442,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','238247',4573443,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','238421',4576439,'1747','246',1256611.28,1259496.18,2884.90,476008.50,0.00,0.00,0.00,0.00,0.00),('5','100','627','238421',4576440,'1748','246',2056853.87,2059091.30,2237.43,369175.95,0.00,0.00,0.00,0.00,0.00),('5','100','628','238421',4576441,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','238421',4576442,'1750','246',1364261.25,1364261.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','238421',4576443,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','238421',4576444,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','238649',4580095,'1747','246',1259496.18,1262829.41,3333.23,549982.95,0.00,0.00,0.00,0.00,0.00),('5','100','627','238649',4580096,'1748','246',2059091.30,2061293.88,2202.58,363425.70,0.00,0.00,0.00,0.00,0.00),('5','100','628','238649',4580097,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','238649',4580098,'1750','246',1364261.25,1364261.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','238649',4580099,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','238649',4580100,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','238892',4584503,'1747','246',1262829.41,1264740.09,1910.68,315262.20,0.00,0.00,0.00,0.00,0.00),('5','100','627','238892',4584504,'1748','246',2061293.88,2062772.43,1478.55,243960.75,0.00,0.00,0.00,0.00,0.00),('5','100','628','238892',4584505,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','238892',4584506,'1750','246',1364261.25,1364261.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','238892',4584507,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','238892',4584508,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','239112',4588419,'1747','246',1264740.09,1265461.86,721.77,119092.05,0.00,0.00,0.00,0.00,0.00),('5','100','627','239112',4588420,'1748','246',2062772.43,2063120.85,348.42,57489.30,0.00,0.00,0.00,0.00,0.00),('5','100','628','239112',4588421,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','239112',4588422,'1750','246',1364261.25,1364261.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','239112',4588423,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','239112',4588424,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','239352',4592500,'1747','246',1265461.86,1265461.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','239352',4592501,'1748','246',2063120.85,2063120.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','239352',4592502,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','239352',4592503,'1750','246',1364261.25,1364261.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','239352',4592504,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','239352',4592505,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','239617',4597102,'1747','246',1265461.86,1265461.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','239617',4597103,'1748','246',2063120.85,2063120.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','239617',4597104,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','239617',4597105,'1750','246',1364261.25,1364261.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','239617',4597106,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','239617',4597107,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','239853',4601252,'1747','246',1265461.86,1265461.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','239853',4601253,'1748','246',2063120.85,2063120.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','239853',4601254,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','239853',4601255,'1750','246',1364261.25,1364261.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','239853',4601256,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','239853',4601257,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','240154',4606565,'1747','246',1265461.86,1265461.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','240154',4606566,'1748','246',2063120.85,2063120.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','240154',4606567,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','240154',4606568,'1750','246',1364261.25,1364261.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','240154',4606569,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','240154',4606570,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','240383',4610364,'1747','246',1265461.86,1265461.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','240383',4610365,'1748','246',2063120.85,2063120.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','240383',4610366,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','240383',4610367,'1750','246',1364261.25,1364261.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','240383',4610368,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','240383',4610369,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','240616',4614161,'1747','246',1265461.86,1265461.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','240616',4614162,'1748','246',2063120.85,2063120.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','240616',4614163,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','240616',4614164,'1750','246',1364261.25,1364261.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','240616',4614165,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','240616',4614166,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','240792',4616678,'1747','246',1265461.86,1265461.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','240792',4616679,'1748','246',2063120.85,2063120.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','240792',4616680,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','240792',4616681,'1750','246',1364261.25,1364261.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','240792',4616682,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','240792',4616683,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','241051',4621320,'1747','246',1265461.86,1266430.97,969.11,159903.15,0.00,0.00,0.00,0.00,0.00),('5','100','627','241051',4621321,'1748','246',2063120.85,2064543.78,1422.93,234783.45,0.00,0.00,0.00,0.00,0.00),('5','100','628','241051',4621322,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','241051',4621323,'1750','246',1364261.25,1365193.24,931.99,153778.35,0.00,0.00,0.00,0.00,0.00),('5','100','629','241051',4621324,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','241051',4621325,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','241294',4625675,'1747','246',1266430.97,1269196.25,2765.28,456271.20,0.00,0.00,0.00,0.00,0.00),('5','100','627','241294',4625676,'1748','246',2064543.78,2067401.40,2857.62,471507.30,0.00,0.00,0.00,0.00,0.00),('5','100','628','241294',4625677,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','241294',4625678,'1750','246',1365193.24,1367149.50,1956.26,322782.90,0.00,0.00,0.00,0.00,0.00),('5','100','629','241294',4625679,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','241294',4625680,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','241567',4630331,'1747','246',1269196.25,1269196.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','241567',4630332,'1748','246',2067401.40,2071177.88,3776.48,623119.20,0.00,0.00,0.00,0.00,0.00),('5','100','628','241567',4630333,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','241567',4630334,'1750','246',1367149.50,1370775.33,3625.83,598261.95,0.00,0.00,0.00,0.00,0.00),('5','100','629','241567',4630335,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','241567',4630336,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','241738',4633360,'1747','246',1269196.25,1269763.30,567.05,93563.25,0.00,0.00,0.00,0.00,0.00),('5','100','627','241738',4633361,'1748','246',2071177.88,2073455.90,2278.02,375873.30,0.00,0.00,0.00,0.00,0.00),('5','100','628','241738',4633362,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','241738',4633363,'1750','246',1370775.33,1374121.29,3345.96,552083.40,0.00,0.00,0.00,0.00,0.00),('5','100','629','241738',4633364,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','241738',4633365,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','242101',4639608,'1747','246',1269763.30,1269763.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','242101',4639609,'1748','246',2073455.90,2077065.08,3609.18,595514.70,0.00,0.00,0.00,0.00,0.00),('5','100','628','242101',4639610,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','242101',4639611,'1750','246',1374121.29,1377390.35,3269.06,539394.90,0.00,0.00,0.00,0.00,0.00),('5','100','629','242101',4639612,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','242101',4639613,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','242401',4645132,'1747','246',1269763.30,1269763.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','242401',4645133,'1748','246',2077065.08,2080940.06,3874.98,639371.70,0.00,0.00,0.00,0.00,0.00),('5','100','628','242401',4645134,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','242401',4645135,'1750','246',1377390.35,1381207.55,3817.20,629838.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','242401',4645136,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','242401',4645137,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','242590',4648314,'1747','246',1269763.30,1272142.74,2379.44,392607.60,0.00,0.00,0.00,0.00,0.00),('5','100','627','242590',4648315,'1748','246',2080940.06,2083532.86,2592.80,427812.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','242590',4648316,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','242590',4648317,'1750','246',1381207.55,1381207.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','242590',4648318,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','242590',4648319,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','246303',4711970,'1747','246',1272142.74,1272142.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','246303',4711971,'1748','246',2083532.86,2083532.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','246303',4711972,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','246303',4711973,'1750','246',1381207.55,1382470.30,1262.75,208353.75,0.00,0.00,0.00,0.00,0.00),('5','100','629','246303',4711974,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','246303',4711975,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','246305',4711984,'1747','246',1272142.74,1273192.05,1049.31,173136.15,0.00,0.00,0.00,0.00,0.00),('5','100','627','246305',4711985,'1748','246',2083532.86,2085001.48,1468.62,242322.30,0.00,0.00,0.00,0.00,0.00),('5','100','628','246305',4711986,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','246305',4711987,'1750','246',1382470.30,1383653.96,1183.66,195303.90,0.00,0.00,0.00,0.00,0.00),('5','100','629','246305',4711988,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','246305',4711989,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','246311',4712070,'1747','246',1273192.05,1275811.65,2619.60,432234.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','246311',4712071,'1748','246',2085001.48,2087685.17,2683.69,442808.85,0.00,0.00,0.00,0.00,0.00),('5','100','628','246311',4712072,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','246311',4712073,'1750','246',1383653.96,1385670.67,2016.71,332757.15,0.00,0.00,0.00,0.00,0.00),('5','100','629','246311',4712074,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','246311',4712075,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','246314',4712104,'1747','246',1275811.65,1278259.63,2447.98,403916.70,0.00,0.00,0.00,0.00,0.00),('5','100','627','246314',4712105,'1748','246',2087685.17,2090958.06,3272.89,540026.85,0.00,0.00,0.00,0.00,0.00),('5','100','628','246314',4712106,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','246314',4712107,'1750','246',1385670.67,1386634.71,964.04,159066.60,0.00,0.00,0.00,0.00,0.00),('5','100','629','246314',4712108,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','246314',4712109,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','246316',4712127,'1747','246',1278259.63,1282499.16,4239.53,699522.45,0.00,0.00,0.00,0.00,0.00),('5','100','627','246316',4712128,'1748','246',2090958.06,2094887.50,3929.44,648357.60,0.00,0.00,0.00,0.00,0.00),('5','100','628','246316',4712129,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','246316',4712130,'1750','246',1386634.71,1387374.89,740.18,122129.70,0.00,0.00,0.00,0.00,0.00),('5','100','629','246316',4712131,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','246316',4712132,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','246317',4712133,'1747','246',1282499.16,1282678.29,179.13,29556.45,0.00,0.00,0.00,0.00,0.00),('5','100','627','246317',4712134,'1748','246',2094887.50,2097480.55,2593.05,427853.25,0.00,0.00,0.00,0.00,0.00),('5','100','628','246317',4712135,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','246317',4712136,'1750','246',1387374.89,1390121.12,2746.23,453127.95,0.00,0.00,0.00,0.00,0.00),('5','100','629','246317',4712137,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','246317',4712138,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','246319',4712155,'1747','246',1282678.29,1282678.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','246319',4712156,'1748','246',2097480.55,2100244.60,2764.05,456068.25,0.00,0.00,0.00,0.00,0.00),('5','100','628','246319',4712157,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','246319',4712158,'1750','246',1390121.12,1392940.71,2819.59,465232.35,0.00,0.00,0.00,0.00,0.00),('5','100','629','246319',4712159,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','246319',4712160,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','246323',4712251,'1747','246',1282678.29,1282678.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','246323',4712252,'1748','246',2100244.60,2102992.22,2747.62,453357.30,0.00,0.00,0.00,0.00,0.00),('5','100','628','246323',4712253,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','246323',4712254,'1750','246',1392940.71,1396191.93,3251.22,536451.30,0.00,0.00,0.00,0.00,0.00),('5','100','629','246323',4712255,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','246323',4712256,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','246324',4712257,'1747','246',1282678.29,1282678.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','246324',4712258,'1748','246',2102992.22,2102992.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','246324',4712259,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','246324',4712260,'1750','246',1396191.93,1397535.34,1343.41,221662.65,0.00,0.00,0.00,0.00,0.00),('5','100','629','246324',4712261,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','246324',4712262,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','246325',4712263,'1747','246',1282678.29,1282678.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','246325',4712264,'1748','246',2102992.22,2102992.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','246325',4712265,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','246325',4712266,'1750','246',1397535.34,1397535.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','246325',4712267,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','246325',4712268,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','246326',4712269,'1747','246',1282678.29,1282678.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','246326',4712270,'1748','246',2102992.22,2102992.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','246326',4712271,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','246326',4712272,'1750','246',1397535.34,1397535.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','246326',4712273,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','246326',4712274,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','246327',4712275,'1747','246',1282678.29,1282678.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','246327',4712276,'1748','246',2102992.22,2102992.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','246327',4712277,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','246327',4712278,'1750','246',1397535.34,1397535.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','246327',4712279,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','246327',4712280,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','246331',4712301,'1747','246',1282678.29,1282678.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','246331',4712302,'1748','246',2102992.22,2102992.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','246331',4712303,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','246331',4712304,'1750','246',1397535.34,1397535.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','246331',4712305,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','246331',4712306,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','246333',4712323,'1747','246',1282678.29,1282678.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','246333',4712324,'1748','246',2102992.22,2102992.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','246333',4712325,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','246333',4712326,'1750','246',1397535.34,1397535.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','246333',4712327,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','246333',4712328,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','246637',4717843,'1747','246',1282678.29,1284121.76,1443.47,238172.55,0.00,0.00,0.00,0.00,0.00),('5','100','627','246637',4717844,'1748','246',2102992.22,2104787.19,1794.97,296170.05,0.00,0.00,0.00,0.00,0.00),('5','100','628','246637',4717845,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','246637',4717846,'1750','246',1397535.34,1397535.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','246637',4717847,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','246637',4717848,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','246870',4721935,'1747','246',1284121.76,1287163.96,3042.20,501963.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','246870',4721936,'1748','246',2104787.19,2107840.08,3052.89,503726.85,0.00,0.00,0.00,0.00,0.00),('5','100','628','246870',4721937,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','246870',4721938,'1750','246',1397535.34,1397535.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','246870',4721939,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','246870',4721940,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','246962',4723278,'1747','246',1287163.96,1290633.58,3469.62,572487.30,0.00,0.00,0.00,0.00,0.00),('5','100','627','246962',4723279,'1748','246',2107840.08,2111190.92,3350.84,552888.60,0.00,0.00,0.00,0.00,0.00),('5','100','628','246962',4723280,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','246962',4723281,'1750','246',1397535.34,1397535.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','246962',4723282,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','246962',4723283,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','247476',4732396,'1747','246',1290633.58,1294000.64,3367.06,555564.90,0.00,0.00,0.00,0.00,0.00),('5','100','627','247476',4732397,'1748','246',2111190.92,2113771.54,2580.62,425802.30,0.00,0.00,0.00,0.00,0.00),('5','100','628','247476',4732398,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','247476',4732399,'1750','246',1397535.34,1397535.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','247476',4732400,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','247476',4732401,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','247611',4734626,'1747','246',1294000.64,1296284.69,2284.05,376868.25,0.00,0.00,0.00,0.00,0.00),('5','100','627','247611',4734627,'1748','246',2113771.54,2115580.17,1808.63,298423.95,0.00,0.00,0.00,0.00,0.00),('5','100','628','247611',4734628,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','247611',4734629,'1750','246',1397535.34,1397535.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','247611',4734630,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','247611',4734631,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','248024',4741436,'1747','246',1296284.69,1296284.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','248024',4741437,'1748','246',2115580.17,2115580.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','248024',4741438,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','248024',4741439,'1750','246',1397535.34,1397535.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','248024',4741440,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','248024',4741441,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','248034',4741632,'1747','246',1296284.69,1296284.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','248034',4741633,'1748','246',2115580.17,2115580.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','248034',4741634,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','248034',4741635,'1750','246',1397535.34,1397535.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','248034',4741636,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','248034',4741637,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','248591',4751218,'1747','246',1296284.69,1296284.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','248591',4751219,'1748','246',2115580.17,2115580.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','248591',4751220,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','248591',4751221,'1750','246',1397535.34,1397535.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','248591',4751222,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','248591',4751223,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','248954',4757139,'1747','246',1296284.69,1296284.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','248954',4757140,'1748','246',2115580.17,2115580.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','248954',4757141,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','248954',4757142,'1750','246',1397535.34,1397535.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','248954',4757143,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','248954',4757144,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','249504',4766666,'1747','246',1296284.69,1296284.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','249504',4766667,'1748','246',2115580.17,2115580.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','249504',4766668,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','249504',4766669,'1750','246',1397535.34,1397535.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','249504',4766670,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','249504',4766671,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','249507',4766683,'1747','246',1296284.69,1296284.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','249507',4766684,'1748','246',2115580.17,2115580.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','249507',4766685,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','249507',4766686,'1750','246',1397535.34,1397535.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','249507',4766687,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','249507',4766688,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','249508',4766689,'1747','246',1296284.69,1296284.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','249508',4766690,'1748','246',2115580.17,2115580.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','249508',4766691,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','249508',4766692,'1750','246',1397535.34,1397535.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','249508',4766693,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','249508',4766694,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','249509',4766695,'1747','246',1296284.69,1296284.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','249509',4766696,'1748','246',2115580.17,2115580.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','249509',4766697,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','249509',4766698,'1750','246',1397535.34,1397535.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','249509',4766699,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','249509',4766700,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','250442',4782179,'1747','246',1296284.69,1296284.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','250442',4782180,'1748','246',2115580.17,2115580.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','250442',4782181,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','250442',4782182,'1750','246',1397535.34,1397535.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','250442',4782183,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','250442',4782184,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','250601',4784863,'1747','246',1296284.69,1296284.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','250601',4784864,'1748','246',2115580.17,2115580.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','250601',4784865,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','250601',4784866,'1750','246',1397535.34,1397535.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','250601',4784867,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','250601',4784868,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','250604',4784923,'1747','246',1296284.69,1296284.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','250604',4784924,'1748','246',2115580.17,2115580.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','250604',4784925,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','250604',4784926,'1750','246',1397535.34,1397535.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','250604',4784927,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','250604',4784928,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','250608',4784965,'1747','246',1296284.69,1296284.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','250608',4784966,'1748','246',2115580.17,2115580.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','250608',4784967,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','250608',4784968,'1750','246',1397535.34,1397535.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','250608',4784969,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','250608',4784970,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','250899',4790257,'1747','246',1296284.69,1296284.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','250899',4790258,'1748','246',2115580.17,2115580.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','250899',4790259,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','250899',4790260,'1750','246',1397535.34,1397535.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','250899',4790261,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','250899',4790262,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','251230',4796147,'1747','246',1296284.69,1296284.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','251230',4796148,'1748','246',2115580.17,2115580.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','251230',4796149,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','251230',4796150,'1750','246',1397535.34,1397535.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','251230',4796151,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','251230',4796152,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','251445',4799776,'1747','246',1296284.69,1296284.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','251445',4799777,'1748','246',2115580.17,2115580.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','251445',4799778,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','251445',4799779,'1750','246',1397535.34,1397535.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','251445',4799780,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','251445',4799781,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','251458',4800083,'1747','246',1296284.69,1296284.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','251458',4800084,'1748','246',2115580.17,2117010.72,1430.55,236040.75,0.00,0.00,0.00,0.00,0.00),('5','100','628','251458',4800085,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','251458',4800086,'1750','246',1397535.34,1399002.88,1467.54,242144.10,0.00,0.00,0.00,0.00,0.00),('5','100','629','251458',4800087,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','251458',4800088,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','251682',4804027,'1747','246',1296284.69,1296284.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','251682',4804028,'1748','246',2117010.72,2120448.52,3437.80,567237.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','251682',4804029,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','251682',4804030,'1750','246',1399002.88,1402559.63,3556.75,586863.75,0.00,0.00,0.00,0.00,0.00),('5','100','629','251682',4804031,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','251682',4804032,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','251898',4807648,'1747','246',1296284.69,1296284.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','251898',4807649,'1748','246',2120448.52,2123609.35,3160.83,521536.95,0.00,0.00,0.00,0.00,0.00),('5','100','628','251898',4807650,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','251898',4807651,'1750','246',1402559.63,1406442.89,3883.26,640737.90,0.00,0.00,0.00,0.00,0.00),('5','100','629','251898',4807652,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','251898',4807653,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','252381',4816119,'1747','246',1296284.69,1296284.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','252381',4816120,'1748','246',2123609.35,2127063.11,3453.76,569870.40,0.00,0.00,0.00,0.00,0.00),('5','100','628','252381',4816121,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','252381',4816122,'1750','246',1406442.89,1411240.76,4797.87,791648.55,0.00,0.00,0.00,0.00,0.00),('5','100','629','252381',4816123,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','252381',4816124,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','252545',4819126,'1747','246',1296284.69,1296284.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','252545',4819127,'1748','246',2127063.11,2129466.00,2402.89,396476.85,0.00,0.00,0.00,0.00,0.00),('5','100','628','252545',4819128,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','252545',4819129,'1750','246',1411240.76,1414806.06,3565.30,588274.50,0.00,0.00,0.00,0.00,0.00),('5','100','629','252545',4819130,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','252545',4819131,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','252675',4821436,'1747','246',1296284.69,1296284.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','252675',4821437,'1748','246',2129466.00,2129466.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','252675',4821438,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','252675',4821439,'1750','246',1414806.06,1420866.30,6060.24,999939.60,0.00,0.00,0.00,0.00,0.00),('5','100','629','252675',4821440,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','252675',4821441,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','252755',4822509,'1747','246',1296284.69,1296284.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','252755',4822510,'1748','246',2129466.00,2129466.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','252755',4822511,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','252755',4822512,'1750','246',1420866.30,1423347.74,2481.44,409437.60,0.00,0.00,0.00,0.00,0.00),('5','100','629','252755',4822513,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','252755',4822514,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','253290',4831520,'1747','246',1296284.69,1296284.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','253290',4831521,'1748','246',2129466.00,2129466.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','253290',4831522,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','253290',4831523,'1750','246',1423347.74,1423347.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','253290',4831524,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','253290',4831525,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','253292',4831541,'1747','246',1296284.69,1296284.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','253292',4831542,'1748','246',2129466.00,2129466.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','253292',4831543,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','253292',4831544,'1750','246',1423347.74,1423347.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','253292',4831545,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','253292',4831546,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','253579',4836474,'1747','246',1296284.69,1296284.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','253579',4836475,'1748','246',2129466.00,2129466.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','253579',4836476,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','253579',4836477,'1750','246',1423347.74,1423347.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','253579',4836478,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','253579',4836479,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','253911',4842505,'1747','246',1296284.69,1296284.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','253911',4842506,'1748','246',2129466.00,2129466.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','253911',4842507,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','253911',4842508,'1750','246',1423347.74,1423347.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','253911',4842509,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','253911',4842510,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','254050',4844706,'1747','246',1296284.69,1296284.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','254050',4844707,'1748','246',2129466.00,2129466.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','254050',4844708,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','254050',4844709,'1750','246',1423347.74,1423347.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','254050',4844710,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','254050',4844711,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','254312',4849394,'1747','246',1296284.69,1296284.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','254312',4849395,'1748','246',2129466.00,2129466.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','254312',4849396,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','254312',4849397,'1750','246',1423347.74,1423347.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','254312',4849398,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','254312',4849399,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','254526',4852979,'1747','246',1296284.69,1296284.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','254526',4852980,'1748','246',2129466.00,2129466.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','254526',4852981,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','254526',4852982,'1750','246',1423347.74,1423347.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','254526',4852983,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','254526',4852984,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','254776',4857223,'1747','246',1296284.69,1296284.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','254776',4857224,'1748','246',2129466.00,2129466.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','254776',4857225,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','254776',4857226,'1750','246',1423347.74,1423347.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','254776',4857227,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','254776',4857228,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','255063',4862318,'1747','246',1296284.69,1296284.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','255063',4862319,'1748','246',2129466.00,2129466.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','255063',4862320,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','255063',4862321,'1750','246',1423347.74,1423347.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','255063',4862322,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','255063',4862323,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','255424',4868711,'1747','246',1296284.69,1296284.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','255424',4868712,'1748','246',2129466.00,2129466.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','255424',4868713,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','255424',4868714,'1750','246',1423347.74,1423347.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','255424',4868715,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','255424',4868716,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','255682',4872903,'1747','246',1296284.69,1296284.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','255682',4872904,'1748','246',2129466.00,2129466.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','255682',4872905,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','255682',4872906,'1750','246',1423347.74,1423347.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','255682',4872907,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','255682',4872908,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','255878',4875930,'1747','246',1296284.69,1296284.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','255878',4875931,'1748','246',2129466.00,2129466.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','255878',4875932,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','255878',4875933,'1750','246',1423347.74,1423347.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','255878',4875934,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','255878',4875935,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','256605',4888046,'1747','246',1296284.69,1296284.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','256605',4888047,'1748','246',2129466.00,2129466.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','256605',4888048,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','256605',4888049,'1750','246',1423347.74,1423347.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','256605',4888050,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','256605',4888051,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','256607',4888071,'1747','246',1296284.69,1296284.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','256607',4888072,'1748','246',2129466.00,2129466.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','256607',4888073,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','256607',4888074,'1750','246',1423347.74,1423347.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','256607',4888075,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','256607',4888076,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','256608',4888077,'1747','246',1296284.69,1296284.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','256608',4888078,'1748','246',2129466.00,2129466.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','256608',4888079,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','256608',4888080,'1750','246',1423347.74,1423347.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','256608',4888081,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','256608',4888082,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','256609',4888083,'1747','246',1296284.69,1296284.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','256609',4888084,'1748','246',2129466.00,2129466.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','256609',4888085,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','256609',4888086,'1750','246',1423347.74,1423347.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','256609',4888087,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','256609',4888088,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','256610',4888089,'1747','246',1296284.69,1296284.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','256610',4888090,'1748','246',2129466.00,2129466.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','256610',4888091,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','256610',4888092,'1750','246',1423347.74,1423347.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','256610',4888093,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','256610',4888094,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','256611',4888095,'1747','246',1296284.69,1296284.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','256611',4888096,'1748','246',2129466.00,2129466.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','256611',4888097,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','256611',4888098,'1750','246',1423347.74,1423347.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','256611',4888099,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','256611',4888100,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','256612',4888101,'1747','246',1296284.69,1296284.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','256612',4888102,'1748','246',2129466.00,2129466.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','256612',4888103,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','256612',4888104,'1750','246',1423347.74,1423347.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','256612',4888105,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','256612',4888106,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','256613',4888107,'1747','246',1296284.69,1296284.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','256613',4888108,'1748','246',2129466.00,2129466.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','256613',4888109,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','256613',4888110,'1750','246',1423347.74,1423347.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','256613',4888111,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','256613',4888112,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','256614',4888113,'1747','246',1296284.69,1296284.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','256614',4888114,'1748','246',2129466.00,2129466.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','256614',4888115,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','256614',4888116,'1750','246',1423347.74,1423347.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','256614',4888117,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','256614',4888118,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','256615',4888119,'1747','246',1296284.69,1296284.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','627','256615',4888120,'1748','246',2129466.00,2129466.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','256615',4888121,'1749','246',305060.16,305060.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','628','256615',4888122,'1750','246',1423347.74,1423347.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','629','256615',4888123,'1751','247',3508122.89,3508122.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','100','630','256615',4888124,'1752','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=727336 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('5','100','123767','246',140.00,143.00,11927.19,0.00,0.00,0.00,0.00,372465),('5','100','123767','247',230.00,220.00,266.69,0.00,0.00,0.00,0.00,372466),('5','100','123767','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,372467),('5','100','123882','246',140.00,143.00,9493.55,0.00,0.00,0.00,0.00,372814),('5','100','123882','247',225.00,225.00,541.06,0.00,0.00,0.00,0.00,372815),('5','100','123882','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,372816),('5','100','124047','246',143.00,143.00,0.00,0.00,0.00,0.00,0.00,373309),('5','100','124047','247',225.00,225.00,0.00,0.00,0.00,0.00,0.00,373310),('5','100','124047','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,373311),('5','100','124519','246',143.00,143.00,11514.83,0.00,0.00,0.00,0.00,374722),('5','100','124519','247',225.00,225.00,497.77,0.00,0.00,0.00,0.00,374723),('5','100','124519','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,374724),('5','100','124671','246',143.00,143.00,10480.30,0.00,0.00,0.00,0.00,375177),('5','100','124671','247',225.00,225.00,351.10,0.00,0.00,0.00,0.00,375178),('5','100','124671','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,375179),('5','100','124720','246',143.00,143.00,10654.23,0.00,0.00,0.00,0.00,375325),('5','100','124720','247',225.00,225.00,233.83,0.00,0.00,0.00,0.00,375326),('5','100','124720','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,375327),('5','100','124895','246',143.00,143.00,7934.84,0.00,0.00,0.00,0.00,375850),('5','100','124895','247',225.00,225.00,275.68,0.00,0.00,0.00,0.00,375851),('5','100','124895','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,375852),('5','100','129016','246',143.00,143.00,0.00,0.00,0.00,0.00,0.00,388208),('5','100','129016','247',225.00,225.00,494.06,0.00,0.00,0.00,0.00,388209),('5','100','129016','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,388210),('5','100','181592','246',143.00,163.00,0.00,0.00,0.00,0.00,0.00,532654),('5','100','181592','247',225.00,250.00,0.00,0.00,0.00,0.00,0.00,532655),('5','100','181592','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,532656),('5','100','181593','246',143.00,163.00,0.00,0.00,0.00,0.00,0.00,532657),('5','100','181593','247',225.00,250.00,0.00,0.00,0.00,0.00,0.00,532658),('5','100','181593','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,532659),('5','100','181740','246',143.00,163.00,3631.55,0.00,0.00,0.00,0.00,533041),('5','100','181740','247',225.00,250.00,167.40,0.00,0.00,0.00,0.00,533042),('5','100','181740','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,533043),('5','100','181881','246',143.00,163.00,0.00,0.00,0.00,0.00,0.00,533448),('5','100','181881','247',225.00,250.00,0.00,0.00,0.00,0.00,0.00,533449),('5','100','181881','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,533450),('5','100','182265','246',163.00,163.00,0.00,0.00,0.00,0.00,0.00,534458),('5','100','182265','247',225.00,250.00,0.00,0.00,0.00,0.00,0.00,534459),('5','100','182265','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,534460),('5','100','182345','246',163.00,163.00,17371.49,0.00,0.00,0.00,0.00,534645),('5','100','182345','247',225.00,250.00,551.80,0.00,0.00,0.00,0.00,534646),('5','100','182345','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,534647),('5','100','182395','246',163.00,170.00,9439.59,0.00,0.00,0.00,0.00,534791),('5','100','182395','247',225.00,250.00,496.01,0.00,0.00,0.00,0.00,534792),('5','100','182395','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,534793),('5','100','182675','246',170.00,170.00,3422.55,0.00,0.00,0.00,0.00,535543),('5','100','182675','247',225.00,250.00,173.00,0.00,0.00,0.00,0.00,535544),('5','100','182675','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,535545),('5','100','182828','246',170.00,170.00,0.00,0.00,0.00,0.00,0.00,535960),('5','100','182828','247',225.00,250.00,110.00,0.00,0.00,0.00,0.00,535961),('5','100','182828','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,535962),('5','100','182878','246',170.00,170.00,4600.03,0.00,0.00,0.00,0.00,536087),('5','100','182878','247',225.00,265.00,79.57,0.00,0.00,0.00,0.00,536088),('5','100','182878','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,536089),('5','100','183035','246',170.00,170.00,10447.09,0.00,0.00,0.00,0.00,536521),('5','100','183035','247',225.00,265.00,403.59,0.00,0.00,0.00,0.00,536522),('5','100','183035','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,536523),('5','100','183284','246',170.00,170.00,5750.01,0.00,0.00,0.00,0.00,537140),('5','100','183284','247',225.00,265.00,424.34,0.00,0.00,0.00,0.00,537141),('5','100','183284','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,537142),('5','100','183533','246',170.00,163.00,8540.52,0.00,0.00,0.00,0.00,537799),('5','100','183533','247',225.00,265.00,398.86,0.00,0.00,0.00,0.00,537800),('5','100','183533','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,537801),('5','100','183712','246',170.00,163.00,11815.79,0.00,0.00,0.00,0.00,538265),('5','100','183712','247',225.00,265.00,238.99,0.00,0.00,0.00,0.00,538266),('5','100','183712','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,538267),('5','100','184235','246',170.00,163.00,4118.44,0.00,0.00,0.00,0.00,539669),('5','100','184235','247',225.00,255.00,52.05,0.00,0.00,0.00,0.00,539670),('5','100','184235','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,539671),('5','100','184252','246',170.00,163.00,0.00,0.00,0.00,0.00,0.00,539718),('5','100','184252','247',225.00,255.00,132.73,0.00,0.00,0.00,0.00,539719),('5','100','184252','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,539720),('5','100','184313','246',163.00,163.00,7152.51,0.00,0.00,0.00,0.00,539864),('5','100','184313','247',225.00,255.00,525.45,0.00,0.00,0.00,0.00,539865),('5','100','184313','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,539866),('5','100','184576','246',163.00,163.00,7889.89,0.00,0.00,0.00,0.00,540561),('5','100','184576','247',225.00,255.00,1457.18,0.00,0.00,0.00,0.00,540562),('5','100','184576','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,540563),('5','100','184770','246',163.00,163.00,11905.87,0.00,0.00,0.00,0.00,541087),('5','100','184770','247',225.00,255.00,400.00,0.00,0.00,0.00,0.00,541088),('5','100','184770','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,541089),('5','100','184929','246',163.00,163.00,9593.47,0.00,0.00,0.00,0.00,541504),('5','100','184929','247',225.00,265.00,1032.34,0.00,0.00,0.00,0.00,541505),('5','100','184929','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,541506),('5','100','185226','246',163.00,163.00,11215.30,0.00,0.00,0.00,0.00,542262),('5','100','185226','247',225.00,265.00,188.84,0.00,0.00,0.00,0.00,542263),('5','100','185226','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,542264),('5','100','185330','246',163.00,163.00,11583.06,0.00,0.00,0.00,0.00,542516),('5','100','185330','247',225.00,265.00,521.66,0.00,0.00,0.00,0.00,542517),('5','100','185330','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,542518),('5','100','185634','246',163.00,163.00,11041.33,0.00,0.00,0.00,0.00,543338),('5','100','185634','247',225.00,265.00,0.00,0.00,0.00,0.00,0.00,543339),('5','100','185634','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,543340),('5','100','185726','246',163.00,162.00,9073.25,0.00,0.00,0.00,0.00,543572),('5','100','185726','247',225.00,265.00,0.00,0.00,0.00,0.00,0.00,543573),('5','100','185726','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,543574),('5','100','185937','246',163.00,163.00,9846.59,0.00,0.00,0.00,0.00,544139),('5','100','185937','247',225.00,265.00,0.00,0.00,0.00,0.00,0.00,544140),('5','100','185937','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,544141),('5','100','186364','246',163.00,163.00,13491.93,0.00,0.00,0.00,0.00,545253),('5','100','186364','247',225.00,265.00,0.00,0.00,0.00,0.00,0.00,545254),('5','100','186364','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,545255),('5','100','186369','246',163.00,163.00,16241.88,0.00,0.00,0.00,0.00,545268),('5','100','186369','247',225.00,265.00,0.00,0.00,0.00,0.00,0.00,545269),('5','100','186369','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,545270),('5','100','186734','246',163.00,163.00,14104.52,0.00,0.00,0.00,0.00,546239),('5','100','186734','247',225.00,265.00,0.00,0.00,0.00,0.00,0.00,546240),('5','100','186734','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,546241),('5','100','187033','246',163.00,163.00,16710.89,0.00,0.00,0.00,0.00,546979),('5','100','187033','247',225.00,265.00,0.00,0.00,0.00,0.00,0.00,546980),('5','100','187033','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,546981),('5','100','187259','246',163.00,163.00,16100.82,0.00,0.00,0.00,0.00,547589),('5','100','187259','247',225.00,265.00,0.00,0.00,0.00,0.00,0.00,547590),('5','100','187259','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,547591),('5','100','187396','246',163.00,163.00,13121.07,0.00,0.00,0.00,0.00,547943),('5','100','187396','247',225.00,265.00,0.00,0.00,0.00,0.00,0.00,547944),('5','100','187396','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,547945),('5','100','187499','246',163.00,163.00,18124.02,0.00,0.00,0.00,0.00,548227),('5','100','187499','247',225.00,265.00,0.00,0.00,0.00,0.00,0.00,548228),('5','100','187499','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,548229),('5','100','187621','246',163.00,163.00,10939.18,0.00,0.00,0.00,0.00,548535),('5','100','187621','247',225.00,265.00,0.00,0.00,0.00,0.00,0.00,548536),('5','100','187621','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,548537),('5','100','187804','246',163.00,163.00,17265.18,0.00,0.00,0.00,0.00,549026),('5','100','187804','247',225.00,265.00,0.00,0.00,0.00,0.00,0.00,549027),('5','100','187804','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,549028),('5','100','188095','246',163.00,163.00,16058.03,0.00,0.00,0.00,0.00,549781),('5','100','188095','247',225.00,265.00,0.00,0.00,0.00,0.00,0.00,549782),('5','100','188095','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,549783),('5','100','188293','246',163.00,163.00,10056.27,0.00,0.00,0.00,0.00,550303),('5','100','188293','247',225.00,265.00,0.00,0.00,0.00,0.00,0.00,550304),('5','100','188293','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,550305),('5','100','188586','246',163.00,163.00,14199.70,0.00,0.00,0.00,0.00,551058),('5','100','188586','247',225.00,265.00,0.00,0.00,0.00,0.00,0.00,551059),('5','100','188586','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,551060),('5','100','188597','246',163.00,163.00,12756.88,0.00,0.00,0.00,0.00,551079),('5','100','188597','247',225.00,265.00,0.00,0.00,0.00,0.00,0.00,551080),('5','100','188597','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,551081),('5','100','188826','246',163.00,163.00,12918.97,0.00,0.00,0.00,0.00,551678),('5','100','188826','247',225.00,265.00,0.00,0.00,0.00,0.00,0.00,551679),('5','100','188826','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,551680),('5','100','188986','246',163.00,163.00,0.00,0.00,0.00,0.00,0.00,552112),('5','100','188986','247',225.00,265.00,0.00,0.00,0.00,0.00,0.00,552113),('5','100','188986','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,552114),('5','100','189014','246',163.00,163.00,10828.86,0.00,0.00,0.00,0.00,552177),('5','100','189014','247',225.00,265.00,0.00,0.00,0.00,0.00,0.00,552178),('5','100','189014','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,552179),('5','100','189271','246',163.00,163.00,12660.18,0.00,0.00,0.00,0.00,552845),('5','100','189271','247',225.00,265.00,0.00,0.00,0.00,0.00,0.00,552846),('5','100','189271','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,552847),('5','100','190495','246',163.00,163.00,0.00,0.00,0.00,0.00,0.00,556036),('5','100','190495','247',265.00,265.00,410.16,0.00,0.00,0.00,0.00,556037),('5','100','190495','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,556038),('5','100','191186','246',163.00,163.00,0.00,0.00,0.00,0.00,0.00,557863),('5','100','191186','247',265.00,265.00,28.29,0.00,0.00,0.00,0.00,557864),('5','100','191186','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,557865),('5','100','191267','246',165.00,163.00,0.00,0.00,0.00,0.00,0.00,558083),('5','100','191267','247',265.00,265.00,537.92,0.00,0.00,0.00,0.00,558084),('5','100','191267','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,558085),('5','100','191319','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,558200),('5','100','191319','247',265.00,265.00,230.34,0.00,0.00,0.00,0.00,558201),('5','100','191319','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,558202),('5','100','191323','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,558212),('5','100','191323','247',265.00,265.00,94.67,0.00,0.00,0.00,0.00,558213),('5','100','191323','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,558214),('5','100','191325','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,558216),('5','100','191325','247',265.00,265.00,559.72,0.00,0.00,0.00,0.00,558217),('5','100','191325','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,558218),('5','100','191329','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,558226),('5','100','191329','247',265.00,265.00,78.48,0.00,0.00,0.00,0.00,558227),('5','100','191329','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,558228),('5','100','191331','246',165.00,165.00,5326.93,0.00,0.00,0.00,0.00,558232),('5','100','191331','247',265.00,265.00,200.74,0.00,0.00,0.00,0.00,558233),('5','100','191331','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,558234),('5','100','191334','246',165.00,165.00,4738.32,0.00,0.00,0.00,0.00,558241),('5','100','191334','247',265.00,265.00,23.94,0.00,0.00,0.00,0.00,558242),('5','100','191334','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,558243),('5','100','191671','246',165.00,165.00,3354.67,0.00,0.00,0.00,0.00,559161),('5','100','191671','247',265.00,265.00,101.12,0.00,0.00,0.00,0.00,559162),('5','100','191671','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,559163),('5','100','192029','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,560101),('5','100','192029','247',265.00,265.00,217.10,0.00,0.00,0.00,0.00,560102),('5','100','192029','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,560103),('5','100','192169','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,560464),('5','100','192169','247',265.00,265.00,111.32,0.00,0.00,0.00,0.00,560465),('5','100','192169','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,560466),('5','100','192181','246',165.00,165.00,7136.59,0.00,0.00,0.00,0.00,560499),('5','100','192181','247',265.00,265.00,562.94,0.00,0.00,0.00,0.00,560500),('5','100','192181','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,560501),('5','100','192326','246',165.00,165.00,8408.69,0.00,0.00,0.00,0.00,560889),('5','100','192326','247',265.00,265.00,84.87,0.00,0.00,0.00,0.00,560890),('5','100','192326','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,560891),('5','100','192643','246',165.00,165.00,10111.87,0.00,0.00,0.00,0.00,561707),('5','100','192643','247',265.00,265.00,248.65,0.00,0.00,0.00,0.00,561708),('5','100','192643','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,561709),('5','100','192937','246',165.00,165.00,7450.45,0.00,0.00,0.00,0.00,562488),('5','100','192937','247',265.00,265.00,221.42,0.00,0.00,0.00,0.00,562489),('5','100','192937','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,562490),('5','100','193038','246',165.00,165.00,4421.99,0.00,0.00,0.00,0.00,562729),('5','100','193038','247',265.00,265.00,123.61,0.00,0.00,0.00,0.00,562730),('5','100','193038','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,562731),('5','100','193288','246',165.00,165.00,2801.59,0.00,0.00,0.00,0.00,563412),('5','100','193288','247',265.00,265.00,72.77,0.00,0.00,0.00,0.00,563413),('5','100','193288','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,563414),('5','100','193744','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,564576),('5','100','193744','247',265.00,265.00,135.37,0.00,0.00,0.00,0.00,564577),('5','100','193744','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,564578),('5','100','193825','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,564789),('5','100','193825','247',265.00,265.00,164.09,0.00,0.00,0.00,0.00,564790),('5','100','193825','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,564791),('5','100','193994','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,565199),('5','100','193994','247',265.00,265.00,0.00,0.00,0.00,0.00,0.00,565200),('5','100','193994','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,565201),('5','100','194218','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,565784),('5','100','194218','247',265.00,265.00,19.58,0.00,0.00,0.00,0.00,565785),('5','100','194218','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,565786),('5','100','194453','246',165.00,165.00,4255.96,0.00,0.00,0.00,0.00,566385),('5','100','194453','247',265.00,265.00,181.00,0.00,0.00,0.00,0.00,566386),('5','100','194453','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,566387),('5','100','194564','246',165.00,165.00,3675.00,0.00,0.00,0.00,0.00,566652),('5','100','194564','247',265.00,265.00,60.16,0.00,0.00,0.00,0.00,566653),('5','100','194564','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,566654),('5','100','194911','246',165.00,165.00,6304.11,0.00,0.00,0.00,0.00,567567),('5','100','194911','247',265.00,265.00,199.82,0.00,0.00,0.00,0.00,567568),('5','100','194911','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,567569),('5','100','195136','246',165.00,165.00,6004.99,0.00,0.00,0.00,0.00,568149),('5','100','195136','247',265.00,265.00,167.07,0.00,0.00,0.00,0.00,568150),('5','100','195136','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,568151),('5','100','195285','246',165.00,165.00,6673.83,0.00,0.00,0.00,0.00,568550),('5','100','195285','247',265.00,265.00,545.77,0.00,0.00,0.00,0.00,568551),('5','100','195285','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,568552),('5','100','195412','246',165.00,165.00,5122.93,0.00,0.00,0.00,0.00,568852),('5','100','195412','247',265.00,265.00,111.40,0.00,0.00,0.00,0.00,568853),('5','100','195412','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,568854),('5','100','195747','246',165.00,165.00,5913.28,0.00,0.00,0.00,0.00,569707),('5','100','195747','247',265.00,265.00,734.96,0.00,0.00,0.00,0.00,569708),('5','100','195747','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,569709),('5','100','196016','246',165.00,165.00,9104.28,0.00,0.00,0.00,0.00,570383),('5','100','196016','247',265.00,265.00,278.25,0.00,0.00,0.00,0.00,570384),('5','100','196016','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,570385),('5','100','196030','246',165.00,165.00,6439.88,0.00,0.00,0.00,0.00,570420),('5','100','196030','247',265.00,265.00,150.07,0.00,0.00,0.00,0.00,570421),('5','100','196030','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,570422),('5','100','196319','246',165.00,165.00,4411.89,0.00,0.00,0.00,0.00,571142),('5','100','196319','247',265.00,265.00,170.46,0.00,0.00,0.00,0.00,571143),('5','100','196319','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,571144),('5','100','196536','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,571712),('5','100','196536','247',265.00,265.00,41.97,0.00,0.00,0.00,0.00,571713),('5','100','196536','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,571714),('5','100','196814','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,572437),('5','100','196814','247',265.00,265.00,124.48,0.00,0.00,0.00,0.00,572438),('5','100','196814','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,572439),('5','100','197209','246',165.00,165.00,467.11,0.00,0.00,0.00,0.00,573471),('5','100','197209','247',265.00,265.00,7.54,0.00,0.00,0.00,0.00,573472),('5','100','197209','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,573473),('5','100','197279','246',165.00,165.00,4110.91,0.00,0.00,0.00,0.00,573661),('5','100','197279','247',265.00,265.00,213.18,0.00,0.00,0.00,0.00,573662),('5','100','197279','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,573663),('5','100','197737','246',165.00,165.00,4791.21,0.00,0.00,0.00,0.00,574748),('5','100','197737','247',265.00,265.00,169.17,0.00,0.00,0.00,0.00,574749),('5','100','197737','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,574750),('5','100','197841','246',165.00,165.00,5916.30,0.00,0.00,0.00,0.00,575046),('5','100','197841','247',265.00,265.00,288.04,0.00,0.00,0.00,0.00,575047),('5','100','197841','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,575048),('5','100','197920','246',165.00,165.00,6813.04,0.00,0.00,0.00,0.00,575239),('5','100','197920','247',265.00,265.00,107.17,0.00,0.00,0.00,0.00,575240),('5','100','197920','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,575241),('5','100','197928','246',165.00,165.00,4767.94,0.00,0.00,0.00,0.00,575262),('5','100','197928','247',265.00,265.00,89.42,0.00,0.00,0.00,0.00,575263),('5','100','197928','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,575264),('5','100','198303','246',165.00,165.00,13237.22,0.00,0.00,0.00,0.00,576234),('5','100','198303','247',265.00,265.00,183.31,0.00,0.00,0.00,0.00,576235),('5','100','198303','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,576236),('5','100','198333','246',165.00,165.00,13153.95,0.00,0.00,0.00,0.00,576321),('5','100','198333','247',265.00,270.00,128.33,0.00,0.00,0.00,0.00,576322),('5','100','198333','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,576323),('5','100','198673','246',165.00,165.00,5408.39,0.00,0.00,0.00,0.00,577205),('5','100','198673','247',265.00,270.00,232.79,0.00,0.00,0.00,0.00,577206),('5','100','198673','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,577207),('5','100','198958','246',165.00,165.00,6220.71,0.00,0.00,0.00,0.00,577918),('5','100','198958','247',265.00,270.00,439.03,0.00,0.00,0.00,0.00,577919),('5','100','198958','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,577920),('5','100','199003','246',165.00,165.00,6002.91,0.00,0.00,0.00,0.00,578019),('5','100','199003','247',265.00,270.00,189.41,0.00,0.00,0.00,0.00,578020),('5','100','199003','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,578021),('5','100','199283','246',165.00,165.00,6991.42,0.00,0.00,0.00,0.00,578693),('5','100','199283','247',265.00,270.00,61.28,0.00,0.00,0.00,0.00,578694),('5','100','199283','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,578695),('5','100','199500','246',165.00,165.00,9036.04,0.00,0.00,0.00,0.00,579246),('5','100','199500','247',265.00,270.00,139.52,0.00,0.00,0.00,0.00,579247),('5','100','199500','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,579248),('5','100','199649','246',165.00,165.00,7439.75,0.00,0.00,0.00,0.00,579637),('5','100','199649','247',265.00,270.00,0.00,0.00,0.00,0.00,0.00,579638),('5','100','199649','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,579639),('5','100','199969','246',165.00,165.00,5788.54,0.00,0.00,0.00,0.00,580427),('5','100','199969','247',265.00,270.00,465.98,0.00,0.00,0.00,0.00,580428),('5','100','199969','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,580429),('5','100','200266','246',165.00,165.00,6373.75,0.00,0.00,0.00,0.00,581209),('5','100','200266','247',265.00,270.00,0.00,0.00,0.00,0.00,0.00,581210),('5','100','200266','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,581211),('5','100','200459','246',165.00,165.00,8326.97,0.00,0.00,0.00,0.00,581710),('5','100','200459','247',265.00,270.00,0.00,0.00,0.00,0.00,0.00,581711),('5','100','200459','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,581712),('5','100','200622','246',165.00,165.00,5132.88,0.00,0.00,0.00,0.00,582132),('5','100','200622','247',265.00,270.00,0.00,0.00,0.00,0.00,0.00,582133),('5','100','200622','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,582134),('5','100','200858','246',165.00,165.00,6349.36,0.00,0.00,0.00,0.00,582746),('5','100','200858','247',265.00,270.00,2538.82,0.00,0.00,0.00,0.00,582747),('5','100','200858','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,582748),('5','100','200999','246',165.00,165.00,4529.04,0.00,0.00,0.00,0.00,583087),('5','100','200999','247',265.00,270.00,209.05,0.00,0.00,0.00,0.00,583088),('5','100','200999','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,583089),('5','100','201117','246',165.00,165.00,6275.32,0.00,0.00,0.00,0.00,583386),('5','100','201117','247',265.00,270.00,437.27,0.00,0.00,0.00,0.00,583387),('5','100','201117','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,583388),('5','100','201389','246',165.00,165.00,4568.50,0.00,0.00,0.00,0.00,584094),('5','100','201389','247',265.00,270.00,321.19,0.00,0.00,0.00,0.00,584095),('5','100','201389','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,584096),('5','100','201555','246',165.00,165.00,5562.97,0.00,0.00,0.00,0.00,584517),('5','100','201555','247',265.00,270.00,337.97,0.00,0.00,0.00,0.00,584518),('5','100','201555','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,584519),('5','100','201918','246',165.00,165.00,5463.97,0.00,0.00,0.00,0.00,585498),('5','100','201918','247',265.00,270.00,217.77,0.00,0.00,0.00,0.00,585499),('5','100','201918','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,585500),('5','100','202049','246',165.00,165.00,4296.99,0.00,0.00,0.00,0.00,585832),('5','100','202049','247',265.00,275.00,198.60,0.00,0.00,0.00,0.00,585833),('5','100','202049','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,585834),('5','100','202201','246',165.00,165.00,5040.98,0.00,0.00,0.00,0.00,586228),('5','100','202201','247',265.00,275.00,215.66,0.00,0.00,0.00,0.00,586229),('5','100','202201','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,586230),('5','100','202637','246',165.00,165.00,7719.13,0.00,0.00,0.00,0.00,587345),('5','100','202637','247',275.00,275.00,175.85,0.00,0.00,0.00,0.00,587346),('5','100','202637','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,587347),('5','100','202719','246',165.00,165.00,5861.41,0.00,0.00,0.00,0.00,587543),('5','100','202719','247',275.00,275.00,10296.19,0.00,0.00,0.00,0.00,587544),('5','100','202719','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,587545),('5','100','202840','246',165.00,165.00,4787.90,0.00,0.00,0.00,0.00,587868),('5','100','202840','247',275.00,275.00,205.89,0.00,0.00,0.00,0.00,587869),('5','100','202840','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,587870),('5','100','203179','246',165.00,165.00,3031.20,0.00,0.00,0.00,0.00,588748),('5','100','203179','247',275.00,275.00,228.49,0.00,0.00,0.00,0.00,588749),('5','100','203179','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,588750),('5','100','203505','246',165.00,165.00,6253.08,0.00,0.00,0.00,0.00,589593),('5','100','203505','247',275.00,275.00,177.72,0.00,0.00,0.00,0.00,589594),('5','100','203505','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,589595),('5','100','203541','246',165.00,165.00,5155.21,0.00,0.00,0.00,0.00,589673),('5','100','203541','247',275.00,275.00,86.68,0.00,0.00,0.00,0.00,589674),('5','100','203541','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,589675),('5','100','203720','246',165.00,165.00,6724.55,0.00,0.00,0.00,0.00,590146),('5','100','203720','247',275.00,275.00,35.87,0.00,0.00,0.00,0.00,590147),('5','100','203720','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,590148),('5','100','204155','246',165.00,165.00,4529.13,0.00,0.00,0.00,0.00,591283),('5','100','204155','247',275.00,275.00,79.02,0.00,0.00,0.00,0.00,591284),('5','100','204155','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,591285),('5','100','204311','246',165.00,165.00,5375.65,0.00,0.00,0.00,0.00,591673),('5','100','204311','247',275.00,275.00,144.84,0.00,0.00,0.00,0.00,591674),('5','100','204311','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,591675),('5','100','204400','246',165.00,165.00,4726.39,0.00,0.00,0.00,0.00,591904),('5','100','204400','247',275.00,275.00,826.78,0.00,0.00,0.00,0.00,591905),('5','100','204400','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,591906),('5','100','204790','246',165.00,165.00,7715.32,0.00,0.00,0.00,0.00,592913),('5','100','204790','247',275.00,275.00,0.00,0.00,0.00,0.00,0.00,592914),('5','100','204790','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,592915),('5','100','205568','246',165.00,165.00,1428.57,0.00,0.00,0.00,0.00,594868),('5','100','205568','247',280.00,275.00,0.00,0.00,0.00,0.00,0.00,594869),('5','100','205568','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,594870),('5','100','205575','246',165.00,165.00,6936.97,0.00,0.00,0.00,0.00,594889),('5','100','205575','247',280.00,275.00,0.00,0.00,0.00,0.00,0.00,594890),('5','100','205575','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,594891),('5','100','205583','246',165.00,165.00,5693.47,0.00,0.00,0.00,0.00,594912),('5','100','205583','247',280.00,280.00,0.00,0.00,0.00,0.00,0.00,594913),('5','100','205583','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,594914),('5','100','205590','246',165.00,165.00,2909.86,0.00,0.00,0.00,0.00,594932),('5','100','205590','247',280.00,280.00,0.00,0.00,0.00,0.00,0.00,594933),('5','100','205590','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,594934),('5','100','205794','246',165.00,165.00,5751.60,0.00,0.00,0.00,0.00,595457),('5','100','205794','247',280.00,280.00,0.00,0.00,0.00,0.00,0.00,595458),('5','100','205794','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,595459),('5','100','206019','246',165.00,165.00,4574.02,0.00,0.00,0.00,0.00,596041),('5','100','206019','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,596042),('5','100','206019','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,596043),('5','100','206242','246',165.00,165.00,4827.48,0.00,0.00,0.00,0.00,596612),('5','100','206242','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,596613),('5','100','206242','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,596614),('5','100','206554','246',165.00,165.00,4582.37,0.00,0.00,0.00,0.00,597414),('5','100','206554','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,597415),('5','100','206554','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,597416),('5','100','206710','246',165.00,165.00,3655.75,0.00,0.00,0.00,0.00,597809),('5','100','206710','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,597810),('5','100','206710','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,597811),('5','100','206816','246',165.00,165.00,4316.86,0.00,0.00,0.00,0.00,598072),('5','100','206816','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,598073),('5','100','206816','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,598074),('5','100','207078','246',165.00,165.00,3622.93,0.00,0.00,0.00,0.00,598751),('5','100','207078','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,598752),('5','100','207078','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,598753),('5','100','207282','246',165.00,165.00,4996.72,0.00,0.00,0.00,0.00,599282),('5','100','207282','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,599283),('5','100','207282','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,599284),('5','100','207627','246',165.00,165.00,4069.55,0.00,0.00,0.00,0.00,600176),('5','100','207627','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,600177),('5','100','207627','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,600178),('5','100','207787','246',165.00,165.00,4154.16,0.00,0.00,0.00,0.00,600569),('5','100','207787','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,600570),('5','100','207787','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,600571),('5','100','207947','246',165.00,165.00,3338.65,0.00,0.00,0.00,0.00,600980),('5','100','207947','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,600981),('5','100','207947','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,600982),('5','100','208282','246',165.00,165.00,3176.94,0.00,0.00,0.00,0.00,601860),('5','100','208282','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,601861),('5','100','208282','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,601862),('5','100','208498','246',165.00,165.00,4336.21,0.00,0.00,0.00,0.00,602406),('5','100','208498','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,602407),('5','100','208498','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,602408),('5','100','208602','246',165.00,165.00,3437.31,0.00,0.00,0.00,0.00,602660),('5','100','208602','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,602661),('5','100','208602','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,602662),('5','100','208784','246',165.00,165.00,5048.38,0.00,0.00,0.00,0.00,603130),('5','100','208784','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,603131),('5','100','208784','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,603132),('5','100','209096','246',165.00,165.00,3735.55,0.00,0.00,0.00,0.00,603913),('5','100','209096','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,603914),('5','100','209096','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,603915),('5','100','209332','246',165.00,165.00,4431.12,0.00,0.00,0.00,0.00,604519),('5','100','209332','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,604520),('5','100','209332','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,604521),('5','100','209531','246',165.00,165.00,4066.20,0.00,0.00,0.00,0.00,605035),('5','100','209531','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,605036),('5','100','209531','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,605037),('5','100','209784','246',165.00,165.00,3493.77,0.00,0.00,0.00,0.00,605695),('5','100','209784','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,605696),('5','100','209784','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,605697),('5','100','210038','246',165.00,165.00,3864.85,0.00,0.00,0.00,0.00,606352),('5','100','210038','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,606353),('5','100','210038','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,606354),('5','100','210222','246',165.00,165.00,3932.21,0.00,0.00,0.00,0.00,606817),('5','100','210222','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,606818),('5','100','210222','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,606819),('5','100','210428','246',165.00,165.00,5051.62,0.00,0.00,0.00,0.00,607358),('5','100','210428','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,607359),('5','100','210428','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,607360),('5','100','210545','246',165.00,165.00,4102.40,0.00,0.00,0.00,0.00,607656),('5','100','210545','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,607657),('5','100','210545','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,607658),('5','100','210931','246',165.00,165.00,3861.59,0.00,0.00,0.00,0.00,608677),('5','100','210931','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,608678),('5','100','210931','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,608679),('5','100','211152','246',165.00,165.00,3979.97,0.00,0.00,0.00,0.00,609244),('5','100','211152','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,609245),('5','100','211152','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,609246),('5','100','211187','246',165.00,165.00,4522.28,0.00,0.00,0.00,0.00,609316),('5','100','211187','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,609317),('5','100','211187','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,609318),('5','100','211493','246',165.00,165.00,4922.47,0.00,0.00,0.00,0.00,610129),('5','100','211493','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,610130),('5','100','211493','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,610131),('5','100','211742','246',165.00,165.00,2296.05,0.00,0.00,0.00,0.00,610767),('5','100','211742','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,610768),('5','100','211742','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,610769),('5','100','211849','246',165.00,165.00,4332.42,0.00,0.00,0.00,0.00,611028),('5','100','211849','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,611029),('5','100','211849','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,611030),('5','100','212093','246',165.00,165.00,4122.23,0.00,0.00,0.00,0.00,611675),('5','100','212093','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,611676),('5','100','212093','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,611677),('5','100','212347','246',165.00,165.00,5181.32,0.00,0.00,0.00,0.00,612341),('5','100','212347','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,612342),('5','100','212347','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,612343),('5','100','212617','246',165.00,165.00,4388.55,0.00,0.00,0.00,0.00,613067),('5','100','212617','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,613068),('5','100','212617','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,613069),('5','100','212840','246',165.00,165.00,3763.99,0.00,0.00,0.00,0.00,613644),('5','100','212840','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,613645),('5','100','212840','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,613646),('5','100','213011','246',165.00,165.00,4231.56,0.00,0.00,0.00,0.00,614092),('5','100','213011','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,614093),('5','100','213011','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614094),('5','100','213123','246',165.00,165.00,4674.76,0.00,0.00,0.00,0.00,614385),('5','100','213123','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,614386),('5','100','213123','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614387),('5','100','213381','246',165.00,165.00,5262.47,0.00,0.00,0.00,0.00,615051),('5','100','213381','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,615052),('5','100','213381','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615053),('5','100','213623','246',165.00,165.00,5159.54,0.00,0.00,0.00,0.00,615693),('5','100','213623','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,615694),('5','100','213623','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615695),('5','100','213930','246',165.00,165.00,5313.44,0.00,0.00,0.00,0.00,616479),('5','100','213930','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,616480),('5','100','213930','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,616481),('5','100','214313','246',165.00,165.00,5162.66,0.00,0.00,0.00,0.00,617493),('5','100','214313','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,617494),('5','100','214313','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,617495),('5','100','214495','246',165.00,165.00,4413.27,0.00,0.00,0.00,0.00,617956),('5','100','214495','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,617957),('5','100','214495','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,617958),('5','100','214541','246',165.00,165.00,5148.35,0.00,0.00,0.00,0.00,618069),('5','100','214541','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,618070),('5','100','214541','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,618071),('5','100','214780','246',165.00,165.00,3753.32,0.00,0.00,0.00,0.00,618692),('5','100','214780','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,618693),('5','100','214780','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,618694),('5','100','215000','246',165.00,165.00,4914.18,0.00,0.00,0.00,0.00,619271),('5','100','215000','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,619272),('5','100','215000','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,619273),('5','100','215249','246',165.00,165.00,4432.67,0.00,0.00,0.00,0.00,619901),('5','100','215249','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,619902),('5','100','215249','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,619903),('5','100','215479','246',165.00,165.00,4281.78,0.00,0.00,0.00,0.00,620488),('5','100','215479','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,620489),('5','100','215479','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,620490),('5','100','215886','246',165.00,165.00,3682.69,0.00,0.00,0.00,0.00,621550),('5','100','215886','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,621551),('5','100','215886','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,621552),('5','100','216074','246',165.00,165.00,3581.10,0.00,0.00,0.00,0.00,622042),('5','100','216074','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,622043),('5','100','216074','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,622044),('5','100','216098','246',165.00,165.00,4373.20,0.00,0.00,0.00,0.00,622100),('5','100','216098','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,622101),('5','100','216098','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,622102),('5','100','216393','246',165.00,165.00,3044.73,0.00,0.00,0.00,0.00,622863),('5','100','216393','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,622864),('5','100','216393','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,622865),('5','100','216592','246',165.00,165.00,3730.70,0.00,0.00,0.00,0.00,623384),('5','100','216592','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,623385),('5','100','216592','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,623386),('5','100','216804','246',165.00,165.00,3674.12,0.00,0.00,0.00,0.00,623943),('5','100','216804','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,623944),('5','100','216804','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,623945),('5','100','217033','246',165.00,165.00,3630.03,0.00,0.00,0.00,0.00,624542),('5','100','217033','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,624543),('5','100','217033','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,624544),('5','100','217457','246',165.00,165.00,4085.68,0.00,0.00,0.00,0.00,625672),('5','100','217457','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,625673),('5','100','217457','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,625674),('5','100','217660','246',165.00,165.00,3204.33,0.00,0.00,0.00,0.00,626200),('5','100','217660','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,626201),('5','100','217660','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,626202),('5','100','217831','246',165.00,165.00,4033.97,0.00,0.00,0.00,0.00,626642),('5','100','217831','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,626643),('5','100','217831','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,626644),('5','100','218001','246',165.00,165.00,3697.58,0.00,0.00,0.00,0.00,627078),('5','100','218001','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,627079),('5','100','218001','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,627080),('5','100','218255','246',165.00,165.00,4213.05,0.00,0.00,0.00,0.00,627746),('5','100','218255','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,627747),('5','100','218255','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,627748),('5','100','218440','246',165.00,165.00,3979.07,0.00,0.00,0.00,0.00,628247),('5','100','218440','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,628248),('5','100','218440','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,628249),('5','100','218668','246',165.00,165.00,3804.73,0.00,0.00,0.00,0.00,628839),('5','100','218668','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,628840),('5','100','218668','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,628841),('5','100','218919','246',165.00,165.00,3572.79,0.00,0.00,0.00,0.00,629482),('5','100','218919','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,629483),('5','100','218919','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,629484),('5','100','219130','246',165.00,165.00,2916.58,0.00,0.00,0.00,0.00,630033),('5','100','219130','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,630034),('5','100','219130','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,630035),('5','100','219352','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,630612),('5','100','219352','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,630613),('5','100','219352','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,630614),('5','100','219559','246',165.00,165.00,5889.58,0.00,0.00,0.00,0.00,631174),('5','100','219559','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,631175),('5','100','219559','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,631176),('5','100','219612','246',165.00,165.00,6133.82,0.00,0.00,0.00,0.00,631292),('5','100','219612','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,631293),('5','100','219612','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,631294),('5','100','219820','246',165.00,165.00,4807.86,0.00,0.00,0.00,0.00,631838),('5','100','219820','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,631839),('5','100','219820','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,631840),('5','100','220026','246',165.00,165.00,3976.68,0.00,0.00,0.00,0.00,632412),('5','100','220026','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,632413),('5','100','220026','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,632414),('5','100','220286','246',165.00,165.00,4354.68,0.00,0.00,0.00,0.00,633071),('5','100','220286','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,633072),('5','100','220286','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,633073),('5','100','220772','246',165.00,165.00,4497.48,0.00,0.00,0.00,0.00,634347),('5','100','220772','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,634348),('5','100','220772','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,634349),('5','100','220872','246',165.00,165.00,3016.63,0.00,0.00,0.00,0.00,634618),('5','100','220872','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,634619),('5','100','220872','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,634620),('5','100','220940','246',165.00,165.00,4075.06,0.00,0.00,0.00,0.00,634781),('5','100','220940','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,634782),('5','100','220940','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,634783),('5','100','221295','246',165.00,165.00,3651.26,0.00,0.00,0.00,0.00,635718),('5','100','221295','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,635719),('5','100','221295','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,635720),('5','100','221427','246',165.00,165.00,3918.40,0.00,0.00,0.00,0.00,636050),('5','100','221427','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,636051),('5','100','221427','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,636052),('5','100','221624','246',165.00,165.00,3883.00,0.00,0.00,0.00,0.00,636567),('5','100','221624','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,636568),('5','100','221624','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,636569),('5','100','221947','246',165.00,165.00,4202.90,0.00,0.00,0.00,0.00,637412),('5','100','221947','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,637413),('5','100','221947','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,637414),('5','100','222238','246',165.00,165.00,2850.80,0.00,0.00,0.00,0.00,638165),('5','100','222238','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,638166),('5','100','222238','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,638167),('5','100','222287','246',165.00,165.00,3728.47,0.00,0.00,0.00,0.00,638278),('5','100','222287','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,638279),('5','100','222287','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,638280),('5','100','222517','246',165.00,165.00,4736.00,0.00,0.00,0.00,0.00,638866),('5','100','222517','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,638867),('5','100','222517','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,638868),('5','100','222780','246',165.00,165.00,2955.28,0.00,0.00,0.00,0.00,639565),('5','100','222780','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,639566),('5','100','222780','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,639567),('5','100','223054','246',165.00,165.00,4698.02,0.00,0.00,0.00,0.00,640312),('5','100','223054','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,640313),('5','100','223054','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,640314),('5','100','223238','246',165.00,165.00,3911.75,0.00,0.00,0.00,0.00,640759),('5','100','223238','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,640760),('5','100','223238','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,640761),('5','100','223536','246',165.00,165.00,3843.19,0.00,0.00,0.00,0.00,641506),('5','100','223536','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,641507),('5','100','223536','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,641508),('5','100','223831','246',165.00,165.00,645.42,0.00,0.00,0.00,0.00,642273),('5','100','223831','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,642274),('5','100','223831','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,642275),('5','100','224538','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,644108),('5','100','224538','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,644109),('5','100','224538','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,644110),('5','100','224543','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,644120),('5','100','224543','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,644121),('5','100','224543','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,644122),('5','100','224546','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,644127),('5','100','224546','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,644128),('5','100','224546','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,644129),('5','100','224547','246',165.00,165.00,3992.61,0.00,0.00,0.00,0.00,644130),('5','100','224547','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,644131),('5','100','224547','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,644132),('5','100','224826','246',165.00,163.00,3744.55,0.00,0.00,0.00,0.00,644837),('5','100','224826','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,644838),('5','100','224826','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,644839),('5','100','225025','246',165.00,165.00,3812.83,0.00,0.00,0.00,0.00,645352),('5','100','225025','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,645353),('5','100','225025','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,645354),('5','100','225460','246',165.00,165.00,3723.81,0.00,0.00,0.00,0.00,646496),('5','100','225460','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,646497),('5','100','225460','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,646498),('5','100','225668','246',163.00,165.00,3408.43,0.00,0.00,0.00,0.00,647032),('5','100','225668','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,647033),('5','100','225668','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647034),('5','100','225801','246',163.00,165.00,4129.14,0.00,0.00,0.00,0.00,647372),('5','100','225801','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,647373),('5','100','225801','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647374),('5','100','225978','246',163.00,163.00,4322.64,0.00,0.00,0.00,0.00,647829),('5','100','225978','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,647830),('5','100','225978','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647831),('5','100','226424','246',163.00,163.00,2062.59,0.00,0.00,0.00,0.00,649006),('5','100','226424','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,649007),('5','100','226424','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,649008),('5','100','226510','246',163.00,163.00,4858.23,0.00,0.00,0.00,0.00,649187),('5','100','226510','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,649188),('5','100','226510','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,649189),('5','100','226767','246',163.00,163.00,4291.48,0.00,0.00,0.00,0.00,649856),('5','100','226767','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,649857),('5','100','226767','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,649858),('5','100','226979','246',163.00,163.00,4532.12,0.00,0.00,0.00,0.00,650424),('5','100','226979','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,650425),('5','100','226979','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,650426),('5','100','227218','246',163.00,163.00,4121.39,0.00,0.00,0.00,0.00,651037),('5','100','227218','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,651038),('5','100','227218','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,651039),('5','100','227385','246',163.00,163.00,5776.20,0.00,0.00,0.00,0.00,651460),('5','100','227385','247',290.00,290.00,0.00,0.00,0.00,0.00,0.00,651461),('5','100','227385','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,651462),('5','100','227618','246',163.00,163.00,2159.71,0.00,0.00,0.00,0.00,652062),('5','100','227618','247',290.00,300.00,0.00,0.00,0.00,0.00,0.00,652063),('5','100','227618','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,652064),('5','100','227874','246',163.00,163.00,0.00,0.00,0.00,0.00,0.00,652726),('5','100','227874','247',290.00,300.00,0.00,0.00,0.00,0.00,0.00,652727),('5','100','227874','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,652728),('5','100','231322','246',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661704),('5','100','231322','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,661705),('5','100','231322','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661706),('5','100','231325','246',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661711),('5','100','231325','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,661712),('5','100','231325','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661713),('5','100','231326','246',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661714),('5','100','231326','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,661715),('5','100','231326','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661716),('5','100','231327','246',163.00,163.00,2369.57,0.00,0.00,0.00,0.00,661717),('5','100','231327','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,661718),('5','100','231327','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661719),('5','100','231328','246',163.00,163.00,3644.54,0.00,0.00,0.00,0.00,661720),('5','100','231328','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,661721),('5','100','231328','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661722),('5','100','231330','246',163.00,163.00,5230.19,0.00,0.00,0.00,0.00,661724),('5','100','231330','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,661725),('5','100','231330','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661726),('5','100','231332','246',163.00,163.00,5261.94,0.00,0.00,0.00,0.00,661729),('5','100','231332','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,661730),('5','100','231332','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661731),('5','100','231334','246',163.00,163.00,3531.75,0.00,0.00,0.00,0.00,661735),('5','100','231334','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,661736),('5','100','231334','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661737),('5','100','231335','246',163.00,163.00,3798.02,0.00,0.00,0.00,0.00,661738),('5','100','231335','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,661739),('5','100','231335','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661740),('5','100','231336','246',163.00,163.00,4159.62,0.00,0.00,0.00,0.00,661741),('5','100','231336','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,661742),('5','100','231336','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661743),('5','100','231339','246',163.00,163.00,1963.13,0.00,0.00,0.00,0.00,661748),('5','100','231339','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,661749),('5','100','231339','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661750),('5','100','231378','246',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661832),('5','100','231378','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,661833),('5','100','231378','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661834),('5','100','231470','246',163.00,163.00,0.00,0.00,0.00,0.00,0.00,662075),('5','100','231470','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,662076),('5','100','231470','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,662077),('5','100','231472','246',163.00,163.00,0.00,0.00,0.00,0.00,0.00,662081),('5','100','231472','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,662082),('5','100','231472','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,662083),('5','100','231473','246',163.00,163.00,0.00,0.00,0.00,0.00,0.00,662084),('5','100','231473','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,662085),('5','100','231473','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,662086),('5','100','231715','246',163.00,163.00,3135.12,0.00,0.00,0.00,0.00,662714),('5','100','231715','247',300.00,320.00,0.00,0.00,0.00,0.00,0.00,662715),('5','100','231715','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,662716),('5','100','232063','246',163.00,163.00,3891.54,0.00,0.00,0.00,0.00,663669),('5','100','232063','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,663670),('5','100','232063','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,663671),('5','100','232329','246',163.00,163.00,2999.25,0.00,0.00,0.00,0.00,664345),('5','100','232329','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,664346),('5','100','232329','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,664347),('5','100','232373','246',163.00,163.00,3256.32,0.00,0.00,0.00,0.00,664450),('5','100','232373','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,664451),('5','100','232373','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,664452),('5','100','232653','246',163.00,163.00,3461.46,0.00,0.00,0.00,0.00,665203),('5','100','232653','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,665204),('5','100','232653','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,665205),('5','100','232900','246',163.00,163.00,4791.78,0.00,0.00,0.00,0.00,665851),('5','100','232900','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,665852),('5','100','232900','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,665853),('5','100','233147','246',163.00,163.00,5755.66,0.00,0.00,0.00,0.00,666490),('5','100','233147','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,666491),('5','100','233147','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,666492),('5','100','233434','246',163.00,163.00,5367.30,0.00,0.00,0.00,0.00,667246),('5','100','233434','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,667247),('5','100','233434','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,667248),('5','100','233723','246',163.00,163.00,6124.60,0.00,0.00,0.00,0.00,668008),('5','100','233723','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,668009),('5','100','233723','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,668010),('5','100','234209','246',163.00,163.00,3675.41,0.00,0.00,0.00,0.00,669298),('5','100','234209','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,669299),('5','100','234209','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,669300),('5','100','234343','246',163.00,163.00,4629.85,0.00,0.00,0.00,0.00,669639),('5','100','234343','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,669640),('5','100','234343','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,669641),('5','100','234506','246',163.00,165.00,4237.42,0.00,0.00,0.00,0.00,670094),('5','100','234506','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,670095),('5','100','234506','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,670096),('5','100','234611','246',163.00,165.00,2419.14,0.00,0.00,0.00,0.00,670349),('5','100','234611','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,670350),('5','100','234611','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,670351),('5','100','234876','246',163.00,165.00,1056.66,0.00,0.00,0.00,0.00,671051),('5','100','234876','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,671052),('5','100','234876','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,671053),('5','100','235705','246',163.00,165.00,0.00,0.00,0.00,0.00,0.00,673239),('5','100','235705','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,673240),('5','100','235705','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,673241),('5','100','235708','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,673248),('5','100','235708','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,673249),('5','100','235708','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,673250),('5','100','235766','246',165.00,165.00,2094.28,0.00,0.00,0.00,0.00,673382),('5','100','235766','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,673383),('5','100','235766','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,673384),('5','100','235841','246',165.00,165.00,5961.37,0.00,0.00,0.00,0.00,673578),('5','100','235841','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,673579),('5','100','235841','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,673580),('5','100','236119','246',165.00,165.00,9706.10,0.00,0.00,0.00,0.00,674318),('5','100','236119','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,674319),('5','100','236119','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,674320),('5','100','236363','246',165.00,165.00,11136.18,0.00,0.00,0.00,0.00,674967),('5','100','236363','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,674968),('5','100','236363','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,674969),('5','100','236552','246',165.00,165.00,1034.40,0.00,0.00,0.00,0.00,675454),('5','100','236552','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,675455),('5','100','236552','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,675456),('5','100','236911','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,676400),('5','100','236911','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,676401),('5','100','236911','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,676402),('5','100','237398','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,677635),('5','100','237398','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,677636),('5','100','237398','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,677637),('5','100','237809','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,678721),('5','100','237809','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,678722),('5','100','237809','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,678723),('5','100','237810','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,678724),('5','100','237810','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,678725),('5','100','237810','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,678726),('5','100','237813','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,678733),('5','100','237813','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,678734),('5','100','237813','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,678735),('5','100','238002','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,679206),('5','100','238002','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,679207),('5','100','238002','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,679208),('5','100','238247','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,679845),('5','100','238247','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,679846),('5','100','238247','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,679847),('5','100','238421','246',165.00,165.00,5122.33,0.00,0.00,0.00,0.00,680285),('5','100','238421','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,680286),('5','100','238421','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,680287),('5','100','238649','246',165.00,165.00,5535.81,0.00,0.00,0.00,0.00,680883),('5','100','238649','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,680884),('5','100','238649','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,680885),('5','100','238892','246',165.00,165.00,3389.23,0.00,0.00,0.00,0.00,681510),('5','100','238892','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,681511),('5','100','238892','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,681512),('5','100','239112','246',165.00,165.00,1070.19,0.00,0.00,0.00,0.00,682076),('5','100','239112','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,682077),('5','100','239112','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,682078),('5','100','239352','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,682706),('5','100','239352','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,682707),('5','100','239352','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,682708),('5','100','239617','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,683403),('5','100','239617','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,683404),('5','100','239617','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,683405),('5','100','239853','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,684019),('5','100','239853','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,684020),('5','100','239853','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,684021),('5','100','240154','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,684809),('5','100','240154','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,684810),('5','100','240154','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,684811),('5','100','240383','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,685397),('5','100','240383','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,685398),('5','100','240383','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,685399),('5','100','240616','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,686009),('5','100','240616','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,686010),('5','100','240616','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,686011),('5','100','240792','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,686406),('5','100','240792','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,686407),('5','100','240792','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,686408),('5','100','241051','246',165.00,165.00,3324.03,0.00,0.00,0.00,0.00,687105),('5','100','241051','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,687106),('5','100','241051','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,687107),('5','100','241294','246',165.00,165.00,7579.16,0.00,0.00,0.00,0.00,687738),('5','100','241294','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,687739),('5','100','241294','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,687740),('5','100','241567','246',165.00,165.00,7402.31,0.00,0.00,0.00,0.00,688471),('5','100','241567','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,688472),('5','100','241567','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,688473),('5','100','241738','246',165.00,165.00,6191.03,0.00,0.00,0.00,0.00,688925),('5','100','241738','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,688926),('5','100','241738','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,688927),('5','100','242101','246',165.00,165.00,6878.24,0.00,0.00,0.00,0.00,689865),('5','100','242101','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,689866),('5','100','242101','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,689867),('5','100','242401','246',165.00,165.00,7692.18,0.00,0.00,0.00,0.00,690661),('5','100','242401','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,690662),('5','100','242401','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,690663),('5','100','242590','246',165.00,165.00,4972.24,0.00,0.00,0.00,0.00,691140),('5','100','242590','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,691141),('5','100','242590','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,691142),('5','100','246303','246',165.00,165.00,1262.75,0.00,0.00,0.00,0.00,700776),('5','100','246303','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,700777),('5','100','246303','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,700778),('5','100','246305','246',165.00,165.00,3701.59,0.00,0.00,0.00,0.00,700782),('5','100','246305','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,700783),('5','100','246305','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,700784),('5','100','246311','246',165.00,165.00,7320.00,0.00,0.00,0.00,0.00,700803),('5','100','246311','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,700804),('5','100','246311','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,700805),('5','100','246314','246',165.00,165.00,6684.91,0.00,0.00,0.00,0.00,700812),('5','100','246314','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,700813),('5','100','246314','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,700814),('5','100','246316','246',165.00,165.00,8909.15,0.00,0.00,0.00,0.00,700818),('5','100','246316','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,700819),('5','100','246316','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,700820),('5','100','246317','246',165.00,165.00,5518.41,0.00,0.00,0.00,0.00,700821),('5','100','246317','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,700822),('5','100','246317','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,700823),('5','100','246319','246',165.00,165.00,5583.64,0.00,0.00,0.00,0.00,700827),('5','100','246319','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,700828),('5','100','246319','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,700829),('5','100','246323','246',165.00,165.00,5998.84,0.00,0.00,0.00,0.00,700838),('5','100','246323','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,700839),('5','100','246323','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,700840),('5','100','246324','246',165.00,165.00,1343.41,0.00,0.00,0.00,0.00,700841),('5','100','246324','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,700842),('5','100','246324','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,700843),('5','100','246325','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,700844),('5','100','246325','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,700845),('5','100','246325','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,700846),('5','100','246326','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,700847),('5','100','246326','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,700848),('5','100','246326','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,700849),('5','100','246327','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,700850),('5','100','246327','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,700851),('5','100','246327','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,700852),('5','100','246331','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,700860),('5','100','246331','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,700861),('5','100','246331','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,700862),('5','100','246333','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,700866),('5','100','246333','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,700867),('5','100','246333','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,700868),('5','100','246637','246',165.00,165.00,3238.44,0.00,0.00,0.00,0.00,701672),('5','100','246637','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,701673),('5','100','246637','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,701674),('5','100','246870','246',165.00,165.00,6095.09,0.00,0.00,0.00,0.00,702267),('5','100','246870','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,702268),('5','100','246870','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,702269),('5','100','246962','246',165.00,165.00,6820.46,0.00,0.00,0.00,0.00,702484),('5','100','246962','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,702485),('5','100','246962','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,702486),('5','100','247476','246',165.00,165.00,5947.68,0.00,0.00,0.00,0.00,703801),('5','100','247476','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,703802),('5','100','247476','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,703803),('5','100','247611','246',165.00,165.00,4092.68,0.00,0.00,0.00,0.00,704181),('5','100','247611','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,704182),('5','100','247611','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,704183),('5','100','248024','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,705229),('5','100','248024','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,705230),('5','100','248024','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,705231),('5','100','248034','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,705258),('5','100','248034','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,705259),('5','100','248034','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,705260),('5','100','248591','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,706710),('5','100','248591','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,706711),('5','100','248591','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,706712),('5','100','248954','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,707626),('5','100','248954','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,707627),('5','100','248954','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,707628),('5','100','249504','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,709042),('5','100','249504','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,709043),('5','100','249504','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,709044),('5','100','249507','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,709049),('5','100','249507','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,709050),('5','100','249507','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,709051),('5','100','249508','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,709052),('5','100','249508','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,709053),('5','100','249508','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,709054),('5','100','249509','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,709055),('5','100','249509','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,709056),('5','100','249509','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,709057),('5','100','250442','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,711421),('5','100','250442','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,711422),('5','100','250442','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,711423),('5','100','250601','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,711829),('5','100','250601','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,711830),('5','100','250601','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,711831),('5','100','250604','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,711839),('5','100','250604','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,711840),('5','100','250604','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,711841),('5','100','250608','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,711849),('5','100','250608','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,711850),('5','100','250608','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,711851),('5','100','250899','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,712606),('5','100','250899','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,712607),('5','100','250899','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,712608),('5','100','251230','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,713485),('5','100','251230','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,713486),('5','100','251230','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,713487),('5','100','251445','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,714042),('5','100','251445','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,714043),('5','100','251445','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,714044),('5','100','251458','246',165.00,165.00,2898.09,0.00,0.00,0.00,0.00,714080),('5','100','251458','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,714081),('5','100','251458','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,714082),('5','100','251682','246',165.00,165.00,6994.55,0.00,0.00,0.00,0.00,714662),('5','100','251682','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,714663),('5','100','251682','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,714664),('5','100','251898','246',165.00,165.00,7044.09,0.00,0.00,0.00,0.00,715220),('5','100','251898','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,715221),('5','100','251898','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,715222),('5','100','252381','246',165.00,165.00,8251.63,0.00,0.00,0.00,0.00,716489),('5','100','252381','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,716490),('5','100','252381','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,716491),('5','100','252545','246',165.00,165.00,5968.19,0.00,0.00,0.00,0.00,716889),('5','100','252545','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,716890),('5','100','252545','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,716891),('5','100','252675','246',165.00,165.00,6060.24,0.00,0.00,0.00,0.00,717256),('5','100','252675','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,717257),('5','100','252675','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,717258),('5','100','252755','246',165.00,165.00,2481.44,0.00,0.00,0.00,0.00,717434),('5','100','252755','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,717435),('5','100','252755','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,717436),('5','100','253290','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,718839),('5','100','253290','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,718840),('5','100','253290','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,718841),('5','100','253292','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,718845),('5','100','253292','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,718846),('5','100','253292','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,718847),('5','100','253579','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,719592),('5','100','253579','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,719593),('5','100','253579','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,719594),('5','100','253911','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,720472),('5','100','253911','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,720473),('5','100','253911','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,720474),('5','100','254050','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,720816),('5','100','254050','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,720817),('5','100','254050','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,720818),('5','100','254312','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,721497),('5','100','254312','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,721498),('5','100','254312','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,721499),('5','100','254526','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,722041),('5','100','254526','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,722042),('5','100','254526','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,722043),('5','100','254776','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,722659),('5','100','254776','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,722660),('5','100','254776','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,722661),('5','100','255063','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,723409),('5','100','255063','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,723410),('5','100','255063','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,723411),('5','100','255424','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,724339),('5','100','255424','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,724340),('5','100','255424','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,724341),('5','100','255682','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,724968),('5','100','255682','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,724969),('5','100','255682','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,724970),('5','100','255878','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,725461),('5','100','255878','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,725462),('5','100','255878','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,725463),('5','100','256605','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,727303),('5','100','256605','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,727304),('5','100','256605','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,727305),('5','100','256607','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,727309),('5','100','256607','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,727310),('5','100','256607','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,727311),('5','100','256608','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,727312),('5','100','256608','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,727313),('5','100','256608','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,727314),('5','100','256609','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,727315),('5','100','256609','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,727316),('5','100','256609','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,727317),('5','100','256610','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,727318),('5','100','256610','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,727319),('5','100','256610','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,727320),('5','100','256611','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,727321),('5','100','256611','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,727322),('5','100','256611','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,727323),('5','100','256612','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,727324),('5','100','256612','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,727325),('5','100','256612','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,727326),('5','100','256613','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,727327),('5','100','256613','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,727328),('5','100','256613','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,727329),('5','100','256614','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,727330),('5','100','256614','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,727331),('5','100','256614','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,727332),('5','100','256615','247',300.00,300.00,0.00,0.00,0.00,0.00,0.00,727333),('5','100','256615','248',0.00,0.00,0.00,0.00,0.00,0.00,0.00,727334),('5','100','256615','246',165.00,165.00,0.00,0.00,0.00,0.00,0.00,727335);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=256 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('5',255,'100','PMS TANKS','TANKS CONTAINING PETROLEUM.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=631 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('5','100','255',627,0,'246','PMS TANK 1',32000.00,1.00,23777.24,'TANK CONTAINING PMS','414','2019-02-23 18:47:23','2021-03-07 12:21:22','414',5,1),('5','100','255',628,0,'246','PMS TANK 2',32000.00,1.00,2454.00,'TANK CONTAINING PMS','414','2019-02-23 18:50:10','2019-02-23 18:50:10','414',5,1),('5','100','255',629,0,'247','AGO TANK',32000.00,1.00,203.00,'TANK CONTAINING AGO','414','2019-02-23 18:51:54','2019-02-23 18:51:54','414',5,1),('5','100','255',630,0,'248','DPK TANK',32000.00,1.00,0.00,'TANK CONTAINING DPK','414','2019-02-23 18:54:26','2019-02-23 18:54:26','414',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2613992 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2287597,'5','100','627',0,'Tank level zero out for dipping',0.00,0.00,0.00,200.00,0.00,'2021-12-15 09:10:31','',''),(2287598,'5','100','627',0,'Inventory adjustment from tank dipping to 8900',0.00,0.00,8900.00,0.00,0.00,'2021-12-15 09:10:31','',''),(2288327,'5','100','627',246,'Sale Id shift 242590',0.00,0.00,0.00,2379.44,0.00,'2021-12-15 10:42:54','',''),(2288328,'5','100','627',246,'Sale Id shift 242590',0.00,0.00,0.00,2592.80,0.00,'2021-12-15 10:42:54','',''),(2288329,'5','100',NULL,246,'Sale Id shift 242590',820419.60,0.00,0.00,0.00,0.00,'2021-12-15 10:42:54','',''),(2288404,'5','100','628',246,'Sale Id shift 246303',0.00,0.00,0.00,1262.75,0.00,'2021-12-15 10:51:12','',''),(2288405,'5','100',NULL,246,'Sale Id shift 246303',208353.75,0.00,0.00,0.00,0.00,'2021-12-15 10:51:12','',''),(2288484,'5','100',NULL,246,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2021-12-15 10:59:22','',''),(2288591,'5','100',NULL,246,'Reception corrector for bridging 127477',0.00,0.00,0.00,27000.00,0.00,'2021-12-15 11:13:00','',''),(2288592,'5','100','627',246,'Received from bridging 127477',0.00,0.00,27000.00,0.00,0.00,'2021-12-15 11:13:00','',''),(2288594,'5','100',NULL,246,'Reception corrector for bridging 127478',0.00,0.00,0.00,18000.00,0.00,'2021-12-15 11:13:12','',''),(2288595,'5','100','628',246,'Received from bridging 127478',0.00,0.00,18000.00,0.00,0.00,'2021-12-15 11:13:12','',''),(2288636,'5','100','627',246,'Sale Id shift 246305',0.00,0.00,0.00,1049.31,0.00,'2021-12-15 11:17:52','',''),(2288637,'5','100','627',246,'Sale Id shift 246305',0.00,0.00,0.00,1468.62,0.00,'2021-12-15 11:17:52','',''),(2288638,'5','100','628',246,'Sale Id shift 246305',0.00,0.00,0.00,1183.66,0.00,'2021-12-15 11:17:52','',''),(2288639,'5','100',NULL,246,'Sale Id shift 246305',610762.35,0.00,0.00,0.00,0.00,'2021-12-15 11:17:52','',''),(2288721,'5','100','627',246,'Sale Id shift 246311',0.00,0.00,0.00,2619.60,0.00,'2021-12-15 11:24:53','',''),(2288722,'5','100','627',246,'Sale Id shift 246311',0.00,0.00,0.00,2683.69,0.00,'2021-12-15 11:24:53','',''),(2288723,'5','100','628',246,'Sale Id shift 246311',0.00,0.00,0.00,2016.71,0.00,'2021-12-15 11:24:53','',''),(2288724,'5','100',NULL,246,'Sale Id shift 246311',1207800.00,0.00,0.00,0.00,0.00,'2021-12-15 11:24:53','',''),(2288772,'5','100','627',246,'Sale Id shift 246314',0.00,0.00,0.00,2447.98,0.00,'2021-12-15 11:31:48','',''),(2288773,'5','100','627',246,'Sale Id shift 246314',0.00,0.00,0.00,3272.89,0.00,'2021-12-15 11:31:48','',''),(2288774,'5','100','628',246,'Sale Id shift 246314',0.00,0.00,0.00,964.04,0.00,'2021-12-15 11:31:48','',''),(2288775,'5','100',NULL,246,'Sale Id shift 246314',1103010.15,0.00,0.00,0.00,0.00,'2021-12-15 11:31:48','',''),(2288819,'5','100','627',246,'Sale Id shift 246316',0.00,0.00,0.00,4239.53,0.00,'2021-12-15 11:37:17','',''),(2288820,'5','100','627',246,'Sale Id shift 246316',0.00,0.00,0.00,3929.44,0.00,'2021-12-15 11:37:17','',''),(2288821,'5','100','628',246,'Sale Id shift 246316',0.00,0.00,0.00,740.18,0.00,'2021-12-15 11:37:17','',''),(2288822,'5','100',NULL,246,'Sale Id shift 246316',1470009.75,0.00,0.00,0.00,0.00,'2021-12-15 11:37:17','',''),(2288903,'5','100','627',246,'Sale Id shift 246317',0.00,0.00,0.00,179.13,0.00,'2021-12-15 11:49:20','',''),(2288904,'5','100','627',246,'Sale Id shift 246317',0.00,0.00,0.00,2593.05,0.00,'2021-12-15 11:49:20','',''),(2288905,'5','100','628',246,'Sale Id shift 246317',0.00,0.00,0.00,2746.23,0.00,'2021-12-15 11:49:20','',''),(2288906,'5','100',NULL,246,'Sale Id shift 246317',910537.65,0.00,0.00,0.00,0.00,'2021-12-15 11:49:20','',''),(2288978,'5','100','627',246,'Sale Id shift 246319',0.00,0.00,0.00,2764.05,0.00,'2021-12-15 11:58:19','',''),(2288979,'5','100','628',246,'Sale Id shift 246319',0.00,0.00,0.00,2819.59,0.00,'2021-12-15 11:58:19','',''),(2288980,'5','100',NULL,246,'Sale Id shift 246319',921300.60,0.00,0.00,0.00,0.00,'2021-12-15 11:58:19','',''),(2289237,'5','100','627',246,'Sale Id shift 246323',0.00,0.00,0.00,2747.62,0.00,'2021-12-15 12:37:23','',''),(2289238,'5','100','628',246,'Sale Id shift 246323',0.00,0.00,0.00,3251.22,0.00,'2021-12-15 12:37:23','',''),(2289239,'5','100',NULL,246,'Sale Id shift 246323',989808.60,0.00,0.00,0.00,0.00,'2021-12-15 12:37:23','',''),(2289268,'5','100','628',246,'Sale Id shift 246324',0.00,0.00,0.00,1343.41,0.00,'2021-12-15 12:40:39','',''),(2289269,'5','100',NULL,246,'Sale Id shift 246324',221662.65,0.00,0.00,0.00,0.00,'2021-12-15 12:40:39','',''),(2300589,'5','100',NULL,246,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,4339500.00,26300.00,0.00,0.00,'2021-12-16 18:05:17','',''),(2300733,'5','100',NULL,246,'Reception corrector for bridging 127650',0.00,0.00,0.00,26300.00,0.00,'2021-12-16 18:55:39','',''),(2300734,'5','100','627',246,'Received from bridging 127650',0.00,0.00,26300.00,0.00,0.00,'2021-12-16 18:55:39','',''),(2303121,'5','100','627',246,'Sale Id shift 246637',0.00,0.00,0.00,1443.47,0.00,'2021-12-17 09:08:49','',''),(2303122,'5','100','627',246,'Sale Id shift 246637',0.00,0.00,0.00,1794.97,0.00,'2021-12-17 09:08:49','',''),(2303123,'5','100',NULL,246,'Sale Id shift 246637',534342.60,0.00,0.00,0.00,0.00,'2021-12-17 09:08:49','',''),(2309350,'5','100','627',246,'Sale Id shift 246870',0.00,0.00,0.00,3042.20,0.00,'2021-12-18 06:52:49','',''),(2309351,'5','100','627',246,'Sale Id shift 246870',0.00,0.00,0.00,3052.89,0.00,'2021-12-18 06:52:49','',''),(2309352,'5','100',NULL,246,'Sale Id shift 246870',1005689.85,0.00,0.00,0.00,0.00,'2021-12-18 06:52:49','',''),(2326177,'5','100','627',246,'Sale Id shift 246962',0.00,0.00,0.00,3469.62,0.00,'2021-12-20 06:12:00','',''),(2326178,'5','100','627',246,'Sale Id shift 246962',0.00,0.00,0.00,3350.84,0.00,'2021-12-20 06:12:00','',''),(2326179,'5','100',NULL,246,'Sale Id shift 246962',1125375.90,0.00,0.00,0.00,0.00,'2021-12-20 06:12:00','',''),(2332835,'5','100','627',246,'Sale Id shift 247476',0.00,0.00,0.00,3367.06,0.00,'2021-12-20 18:04:05','',''),(2332836,'5','100','627',246,'Sale Id shift 247476',0.00,0.00,0.00,2580.62,0.00,'2021-12-20 18:04:05','',''),(2332837,'5','100',NULL,246,'Sale Id shift 247476',981367.20,0.00,0.00,0.00,0.00,'2021-12-20 18:04:05','',''),(2338298,'5','100','627',246,'Sale Id shift 247611',0.00,0.00,0.00,2284.05,0.00,'2021-12-21 14:53:33','',''),(2338299,'5','100','627',246,'Sale Id shift 247611',0.00,0.00,0.00,1808.63,0.00,'2021-12-21 14:53:33','',''),(2338300,'5','100',NULL,246,'Sale Id shift 247611',675292.20,0.00,0.00,0.00,0.00,'2021-12-21 14:53:33','',''),(2447028,'5','100',NULL,246,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,6517500.00,39500.00,0.00,0.00,'2022-01-05 17:44:51','',''),(2448032,'5','100',NULL,246,'Reception corrector for bridging 129891',0.00,0.00,0.00,14000.00,0.00,'2022-01-06 00:50:17','',''),(2448033,'5','100','627',246,'Received from bridging 129891',0.00,0.00,14000.00,0.00,0.00,'2022-01-06 00:50:17','',''),(2448034,'5','100',NULL,246,'Reception corrector for bridging 129892',0.00,0.00,0.00,25500.00,0.00,'2022-01-06 00:50:27','',''),(2448035,'5','100','628',246,'Received from bridging 129892',0.00,0.00,25500.00,0.00,0.00,'2022-01-06 00:50:27','',''),(2449384,'5','100','627',246,'Sale Id shift 251458',0.00,0.00,0.00,1430.55,0.00,'2022-01-06 09:23:58','',''),(2449385,'5','100','628',246,'Sale Id shift 251458',0.00,0.00,0.00,1467.54,0.00,'2022-01-06 09:23:58','',''),(2449386,'5','100',NULL,246,'Sale Id shift 251458',478184.85,0.00,0.00,0.00,0.00,'2022-01-06 09:23:58','',''),(2455859,'5','100','627',246,'Sale Id shift 251682',0.00,0.00,0.00,3437.80,0.00,'2022-01-07 07:01:04','',''),(2455860,'5','100','628',246,'Sale Id shift 251682',0.00,0.00,0.00,3556.75,0.00,'2022-01-07 07:01:04','',''),(2455861,'5','100',NULL,246,'Sale Id shift 251682',1154100.75,0.00,0.00,0.00,0.00,'2022-01-07 07:01:04','',''),(2477067,'5','100','627',246,'Sale Id shift 251898',0.00,0.00,0.00,3160.83,0.00,'2022-01-09 15:48:49','',''),(2477068,'5','100','628',246,'Sale Id shift 251898',0.00,0.00,0.00,3883.26,0.00,'2022-01-09 15:48:49','',''),(2477069,'5','100',NULL,246,'Sale Id shift 251898',1162274.85,0.00,0.00,0.00,0.00,'2022-01-09 15:48:49','',''),(2479942,'5','100','627',246,'Sale Id shift 252381',0.00,0.00,0.00,3453.76,0.00,'2022-01-10 08:25:11','',''),(2479943,'5','100','628',246,'Sale Id shift 252381',0.00,0.00,0.00,4797.87,0.00,'2022-01-10 08:25:11','',''),(2479944,'5','100',NULL,246,'Sale Id shift 252381',1361518.95,0.00,0.00,0.00,0.00,'2022-01-10 08:25:11','',''),(2481378,'5','100','627',246,'Sale Id shift 252545',0.00,0.00,0.00,2402.89,0.00,'2022-01-10 10:44:52','',''),(2481379,'5','100','628',246,'Sale Id shift 252545',0.00,0.00,0.00,3565.30,0.00,'2022-01-10 10:44:52','',''),(2481380,'5','100',NULL,246,'Sale Id shift 252545',984751.35,0.00,0.00,0.00,0.00,'2022-01-10 10:44:52','',''),(2486877,'5','100','628',246,'Sale Id shift 252675',0.00,0.00,0.00,6060.24,0.00,'2022-01-11 08:18:35','',''),(2486878,'5','100',NULL,246,'Sale Id shift 252675',999939.60,0.00,0.00,0.00,0.00,'2022-01-11 08:18:35','',''),(2494399,'5','100','628',246,'Sale Id shift 252755',0.00,0.00,0.00,2481.44,0.00,'2022-01-12 08:11:59','',''),(2494400,'5','100',NULL,246,'Sale Id shift 252755',409437.60,0.00,0.00,0.00,0.00,'2022-01-12 08:11:59','',''),(2612715,'5','100',NULL,247,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,30000.00,200.00,100.00,0.00,'2021-11-30 23:59:59','',''),(2612858,'5','100',NULL,248,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2612883,'5','100',NULL,246,'Balance from closing inventory values 2021-11-31 23:59:59',27695202.61,28722893.00,350222.00,343988.11,0.00,'2021-11-30 23:59:59','',''),(2613365,'5','100','629',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,100.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613695,'5','100','630',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613814,'5','100','627',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,126961.00,126761.00,0.00,'2021-11-30 23:59:59','',''),(2613991,'5','100','628',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,48350.00,47086.50,0.00,'2021-11-30 23:59:59','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1724099 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (1314584,'5','100',246,'Sale Id shift 231327',0.00,386239.91,163.00,386239.91,0.00,'2021-10-13 17:49:41'),(1314592,'5','100',246,'Sale Id shift 231328',0.00,594060.02,163.00,594060.02,0.00,'2021-10-13 17:53:47'),(1314605,'5','100',246,'Sale Id shift 231330',0.00,852520.97,163.00,852520.97,0.00,'2021-10-13 17:58:45'),(1314615,'5','100',246,'Sale Id shift 231332',0.00,857696.22,163.00,857696.22,0.00,'2021-10-13 18:06:09'),(1314620,'5','100',246,'Sale Id shift 231334',0.00,575675.25,163.00,575675.25,0.00,'2021-10-13 18:11:39'),(1314622,'5','100',246,'Sale Id shift 231335',0.00,619077.26,163.00,619077.26,0.00,'2021-10-13 18:15:22'),(1314630,'5','100',246,'Sale Id shift 231336',0.00,678018.06,163.00,678018.06,0.00,'2021-10-13 18:25:35'),(1314635,'5','100',246,'Sale Id shift 231339',0.00,319990.19,163.00,319990.19,0.00,'2021-10-13 18:41:27'),(1323671,'5','100',246,'Sale Id shift 231715',0.00,511024.56,163.00,511024.56,0.00,'2021-10-16 16:32:03'),(1326452,'5','100',246,'Sale Id shift 232063',0.00,634321.02,163.00,634321.02,0.00,'2021-10-17 15:14:15'),(1327155,'5','100',246,'Sale Id shift 232329',0.00,488877.75,163.00,488877.75,0.00,'2021-10-18 06:15:27'),(1330812,'5','100',246,'Sale Id shift 232373',0.00,530780.16,163.00,530780.16,0.00,'2021-10-19 05:05:16'),(1334591,'5','100',246,'Sale Id shift 232653',0.00,564217.98,163.00,564217.98,0.00,'2021-10-20 08:23:15'),(1337541,'5','100',246,'Sale Id shift 232900',0.00,781060.14,163.00,781060.14,0.00,'2021-10-21 06:39:43'),(1341706,'5','100',246,'Sale Id shift 233147',0.00,938172.58,163.00,938172.58,0.00,'2021-10-22 08:47:51'),(1344438,'5','100',246,'Sale Id shift 233434',0.00,874869.90,163.00,874869.90,0.00,'2021-10-23 06:43:59'),(1353308,'5','100',246,'Sale Id shift 233723',0.00,998309.80,163.00,998309.80,0.00,'2021-10-25 13:14:09'),(1354774,'5','100',246,'Sale Id shift 234209',0.00,599091.83,163.00,599091.83,0.00,'2021-10-26 06:11:27'),(1357436,'5','100',246,'Sale Id shift 234343',0.00,754665.55,163.00,754665.55,0.00,'2021-10-26 15:28:03'),(1358492,'5','100',246,'Sale Id shift 234506',0.00,690699.46,165.00,699174.30,8474.84,'2021-10-27 07:27:30'),(1361974,'5','100',246,'Sale Id shift 234611',0.00,394319.82,165.00,399158.10,4838.28,'2021-10-28 07:52:05'),(1367571,'5','100',246,'Sale Id shift 234876',0.00,172235.58,165.00,174348.90,2113.32,'2021-10-29 21:59:22'),(1374806,'5','100',246,'Sale Id shift 235766',0.00,345556.20,165.00,345556.20,0.00,'2021-11-01 08:59:07'),(1376765,'5','100',246,'Sale Id shift 235841',0.00,983626.05,165.00,983626.05,0.00,'2021-11-01 20:45:32'),(1379100,'5','100',246,'Sale Id shift 236119',0.00,1601506.50,165.00,1601506.50,0.00,'2021-11-03 05:01:18'),(1382938,'5','100',246,'Sale Id shift 236363',0.00,1837469.70,165.00,1837469.70,0.00,'2021-11-04 06:29:41'),(1391309,'5','100',246,'Sale Id shift 236552',0.00,170676.00,165.00,170676.00,0.00,'2021-11-05 15:11:47'),(1425908,'5','100',246,'Sale Id shift 238421',0.00,845184.45,165.00,845184.45,0.00,'2021-11-13 05:52:29'),(1431621,'5','100',246,'Sale Id shift 238649',0.00,913408.65,165.00,913408.65,0.00,'2021-11-14 09:02:47'),(1435597,'5','100',246,'Sale Id shift 238892',0.00,559222.95,165.00,559222.95,0.00,'2021-11-15 07:23:35'),(1440062,'5','100',246,'Sale Id shift 239112',0.00,176581.35,165.00,176581.35,0.00,'2021-11-16 08:08:44'),(1475446,'5','100',246,'Sale Id shift 241051',0.00,548464.95,165.00,548464.95,0.00,'2021-11-24 07:04:03'),(1479084,'5','100',246,'Sale Id shift 241294',0.00,1250561.40,165.00,1250561.40,0.00,'2021-11-25 05:52:18'),(1483409,'5','100',246,'Sale Id shift 241567',0.00,1221381.15,165.00,1221381.15,0.00,'2021-11-26 05:58:36'),(1487852,'5','100',246,'Sale Id shift 241738',0.00,1021519.95,165.00,1021519.95,0.00,'2021-11-27 06:11:16'),(1493038,'5','100',246,'Sale Id shift 242101',0.00,1134909.60,165.00,1134909.60,0.00,'2021-11-28 07:30:12'),(1497384,'5','100',246,'Sale Id shift 242401',0.00,1269209.70,165.00,1269209.70,0.00,'2021-11-29 04:57:30'),(1580418,'5','100',246,'Sale Id shift 242590',0.00,820419.60,165.00,820419.60,0.00,'2021-12-15 10:42:54'),(1580486,'5','100',246,'Sale Id shift 246303',0.00,208353.75,165.00,208353.75,0.00,'2021-12-15 10:51:12'),(1580689,'5','100',246,'Sale Id shift 246305',0.00,610762.35,165.00,610762.35,0.00,'2021-12-15 11:17:52'),(1580754,'5','100',246,'Sale Id shift 246311',0.00,1207800.00,165.00,1207800.00,0.00,'2021-12-15 11:24:53'),(1580801,'5','100',246,'Sale Id shift 246314',0.00,1103010.15,165.00,1103010.15,0.00,'2021-12-15 11:31:48'),(1580842,'5','100',246,'Sale Id shift 246316',0.00,1470009.75,165.00,1470009.75,0.00,'2021-12-15 11:37:17'),(1580918,'5','100',246,'Sale Id shift 246317',0.00,910537.65,165.00,910537.65,0.00,'2021-12-15 11:49:20'),(1580981,'5','100',246,'Sale Id shift 246319',0.00,921300.60,165.00,921300.60,0.00,'2021-12-15 11:58:19'),(1581179,'5','100',246,'Sale Id shift 246323',0.00,989808.60,165.00,989808.60,0.00,'2021-12-15 12:37:23'),(1581199,'5','100',246,'Sale Id shift 246324',0.00,221662.65,165.00,221662.65,0.00,'2021-12-15 12:40:39'),(1589798,'5','100',246,'Sale Id shift 246637',0.00,534342.60,165.00,534342.60,0.00,'2021-12-17 09:08:49'),(1593858,'5','100',246,'Sale Id shift 246870',0.00,1005689.85,165.00,1005689.85,0.00,'2021-12-18 06:52:49'),(1604745,'5','100',246,'Sale Id shift 246962',0.00,1125375.90,165.00,1125375.90,0.00,'2021-12-20 06:12:00'),(1609896,'5','100',246,'Sale Id shift 247476',0.00,981367.20,165.00,981367.20,0.00,'2021-12-20 18:04:05'),(1613638,'5','100',246,'Sale Id shift 247611',0.00,675292.20,165.00,675292.20,0.00,'2021-12-21 14:53:33'),(1692708,'5','100',246,'Sale Id shift 251458',0.00,478184.85,165.00,478184.85,0.00,'2022-01-06 09:23:58'),(1697161,'5','100',246,'Sale Id shift 251682',0.00,1154100.75,165.00,1154100.75,0.00,'2022-01-07 07:01:04'),(1712127,'5','100',246,'Sale Id shift 251898',0.00,1162274.85,165.00,1162274.85,0.00,'2022-01-09 15:48:49'),(1713828,'5','100',246,'Sale Id shift 252381',0.00,1361518.95,165.00,1361518.95,0.00,'2022-01-10 08:25:11'),(1715002,'5','100',246,'Sale Id shift 252545',0.00,984751.35,165.00,984751.35,0.00,'2022-01-10 10:44:52'),(1719134,'5','100',246,'Sale Id shift 252675',0.00,999939.60,165.00,999939.60,0.00,'2022-01-11 08:18:35'),(1724098,'5','100',246,'Sale Id shift 252755',0.00,409437.60,165.00,409437.60,0.00,'2022-01-12 08:11:59');
/*!40000 ALTER TABLE `inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices`
--

DROP TABLE IF EXISTS `invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `expirydate` date NOT NULL,
  `notes` text,
  `status` int NOT NULL DEFAULT '0',
  `email` varchar(200) DEFAULT NULL,
  `email_sent_at` datetime DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `payment_method` varchar(50) DEFAULT NULL,
  `payment_details` text,
  `payment_status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `status` (`status`,`company_id`,`station_id`),
  KEY `email_sent_at` (`email_sent_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices`
--

LOCK TABLES `invoices` WRITE;
/*!40000 ALTER TABLE `invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices_items`
--

DROP TABLE IF EXISTS `invoices_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices_items` (
  `id` int NOT NULL AUTO_INCREMENT,
  `invoice_id` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(200) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `item_type` varchar(50) NOT NULL,
  `item_id` varchar(100) NOT NULL,
  `item_details` longtext,
  PRIMARY KEY (`id`),
  KEY `name` (`name`,`invoice_id`,`station_id`),
  KEY `companycode` (`company_id`),
  KEY `status` (`status`,`item_type`,`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices_items`
--

LOCK TABLES `invoices_items` WRITE;
/*!40000 ALTER TABLE `invoices_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ledgers`
--

DROP TABLE IF EXISTS `ledgers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ledgers` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` int NOT NULL AUTO_INCREMENT,
  `ledgertype` varchar(10) NOT NULL,
  `accounttype` varchar(50) NOT NULL,
  `accountid` varchar(50) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `details` varchar(1000) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `accounttype` (`accounttype`,`accountid`,`credit`,`debit`,`thedate`),
  KEY `cooperative` (`company_id`),
  KEY `depot_id` (`station_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=4903985 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ledgers`
--

LOCK TABLES `ledgers` WRITE;
/*!40000 ALTER TABLE `ledgers` DISABLE KEYS */;
INSERT INTO `ledgers` VALUES ('5','100',3570525,'','24','2213',0.00,30000.00,'Purchase Id 78179 for 100.00 litters of Diesel - AGO from SALBAS OIL & GAS NIG. LIMITED','2021-10-13 09:05:34','',''),('5','100',3570526,'','supplier','106',30000.00,0.00,'Purchase Id 78179 for 100.00 litters of Diesel - AGO from SALBAS OIL & GAS NIG. LIMITED','2021-10-13 09:05:34','',''),('5','100',3570547,'','24','2213',0.00,105950.00,'Purchase Id 78178 for 650.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-10-13 09:06:59','',''),('5','100',3570548,'','supplier','106',105950.00,0.00,'Purchase Id 78178 for 650.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-10-13 09:06:59','',''),('5','100',3577405,'','24','2213',0.00,4873700.00,'Purchase Id 78248 for 29,900.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-10-13 17:10:51','',''),('5','100',3577406,'','supplier','106',4873700.00,0.00,'Purchase Id 78248 for 29,900.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-10-13 17:10:51','',''),('5','100',3577637,'','20','2215',0.00,0.00,'Sales from shift 231322 on 2021-10-13 17:30:37 ','2021-10-13 17:30:37','',''),('5','100',3577638,'','6.1','2214',0.00,0.00,'Sales from shift 231322 on 2021-10-13 17:30:37 ','2021-10-13 17:30:37','',''),('5','100',3577705,'','20','2215',0.00,0.00,'Sales from shift 231325 on 2021-10-13 17:35:35 ','2021-10-13 17:35:35','',''),('5','100',3577706,'','6.1','2214',0.00,0.00,'Sales from shift 231325 on 2021-10-13 17:35:35 ','2021-10-13 17:35:35','',''),('5','100',3577819,'','20','2215',0.00,0.00,'Sales from shift 231326 on 2021-10-13 17:44:47 ','2021-10-13 17:44:47','',''),('5','100',3577820,'','6.1','2214',0.00,0.00,'Sales from shift 231326 on 2021-10-13 17:44:47 ','2021-10-13 17:44:47','',''),('5','100',3577886,'','20','2215',386239.91,0.00,'Sales from shift 231327 on 2021-10-13 17:49:41 ','2021-10-13 17:49:41','',''),('5','100',3577887,'','6.1','2214',0.00,386239.91,'Sales from shift 231327 on 2021-10-13 17:49:41 ','2021-10-13 17:49:41','',''),('5','100',3577935,'','20','2215',594060.02,0.00,'Sales from shift 231328 on 2021-10-13 17:53:47 ','2021-10-13 17:53:47','',''),('5','100',3577936,'','6.1','2214',0.00,594060.02,'Sales from shift 231328 on 2021-10-13 17:53:47 ','2021-10-13 17:53:47','',''),('5','100',3577989,'','20','2215',852520.97,0.00,'Sales from shift 231330 on 2021-10-13 17:58:45 ','2021-10-13 17:58:45','',''),('5','100',3577990,'','6.1','2214',0.00,852520.97,'Sales from shift 231330 on 2021-10-13 17:58:45 ','2021-10-13 17:58:45','',''),('5','100',3578054,'','20','2215',857696.22,0.00,'Sales from shift 231332 on 2021-10-13 18:06:09 ','2021-10-13 18:06:09','',''),('5','100',3578055,'','6.1','2214',0.00,857696.22,'Sales from shift 231332 on 2021-10-13 18:06:09 ','2021-10-13 18:06:09','',''),('5','100',3578094,'','20','2215',575675.25,0.00,'Sales from shift 231334 on 2021-10-13 18:11:39 ','2021-10-13 18:11:39','',''),('5','100',3578095,'','6.1','2214',0.00,575675.25,'Sales from shift 231334 on 2021-10-13 18:11:39 ','2021-10-13 18:11:39','',''),('5','100',3578122,'','20','2215',619077.26,0.00,'Sales from shift 231335 on 2021-10-13 18:15:22 ','2021-10-13 18:15:22','',''),('5','100',3578123,'','6.1','2214',0.00,619077.26,'Sales from shift 231335 on 2021-10-13 18:15:22 ','2021-10-13 18:15:22','',''),('5','100',3578171,'','20','2215',678018.06,0.00,'Sales from shift 231336 on 2021-10-13 18:25:35 ','2021-10-13 18:25:35','',''),('5','100',3578172,'','6.1','2214',0.00,678018.06,'Sales from shift 231336 on 2021-10-13 18:25:35 ','2021-10-13 18:25:35','',''),('5','100',3578202,'','20','2215',319990.19,0.00,'Sales from shift 231339 on 2021-10-13 18:41:27 ','2021-10-13 18:41:27','',''),('5','100',3578203,'','6.1','2214',0.00,319990.19,'Sales from shift 231339 on 2021-10-13 18:41:27 ','2021-10-13 18:41:27','',''),('5','100',3581059,'','20','2215',0.00,0.00,'Sales from shift 231378 on 2021-10-14 09:42:31 ','2021-10-14 09:42:31','',''),('5','100',3581060,'','6.1','2214',0.00,0.00,'Sales from shift 231378 on 2021-10-14 09:42:31 ','2021-10-14 09:42:31','',''),('5','100',3581943,'','20','2215',0.00,0.00,'Sales from shift 231470 on 2021-10-14 10:49:27 ','2021-10-14 10:49:27','',''),('5','100',3581944,'','6.1','2214',0.00,0.00,'Sales from shift 231470 on 2021-10-14 10:49:27 ','2021-10-14 10:49:27','',''),('5','100',3581977,'','20','2215',0.00,0.00,'Sales from shift 231472 on 2021-10-14 10:52:22 ','2021-10-14 10:52:22','',''),('5','100',3581978,'','6.1','2214',0.00,0.00,'Sales from shift 231472 on 2021-10-14 10:52:22 ','2021-10-14 10:52:22','',''),('5','100',3590793,'','20','2215',0.00,0.00,'Sales from shift 231473 on 2021-10-15 09:25:26 ','2021-10-15 09:25:26','',''),('5','100',3590794,'','6.1','2214',0.00,0.00,'Sales from shift 231473 on 2021-10-15 09:25:26 ','2021-10-15 09:25:26','',''),('5','100',3598197,'','24','2213',0.00,3260000.00,'Purchase Id 78391 for 20,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-10-15 20:01:34','',''),('5','100',3598198,'','supplier','106',3260000.00,0.00,'Purchase Id 78391 for 20,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-10-15 20:01:34','',''),('5','100',3606624,'','20','2215',511024.56,0.00,'Sales from shift 231715 on 2021-10-16 16:32:03 ','2021-10-16 16:32:03','',''),('5','100',3606625,'','6.1','2214',0.00,511024.56,'Sales from shift 231715 on 2021-10-16 16:32:03 ','2021-10-16 16:32:03','',''),('5','100',3615928,'','20','2215',634321.02,0.00,'Sales from shift 232063 on 2021-10-17 15:14:15 ','2021-10-17 15:14:15','',''),('5','100',3615929,'','6.1','2214',0.00,634321.02,'Sales from shift 232063 on 2021-10-17 15:14:15 ','2021-10-17 15:14:15','',''),('5','100',3618093,'','20','2215',488877.75,0.00,'Sales from shift 232329 on 2021-10-18 06:15:27 ','2021-10-18 06:15:27','',''),('5','100',3618094,'','6.1','2214',0.00,488877.75,'Sales from shift 232329 on 2021-10-18 06:15:27 ','2021-10-18 06:15:27','',''),('5','100',3627886,'','20','2215',530780.16,0.00,'Sales from shift 232373 on 2021-10-19 05:05:16 ','2021-10-19 05:05:16','',''),('5','100',3627887,'','6.1','2214',0.00,530780.16,'Sales from shift 232373 on 2021-10-19 05:05:16 ','2021-10-19 05:05:16','',''),('5','100',3631786,'','24','2213',0.00,4890000.00,'Purchase Id 78631 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-10-19 10:51:59','',''),('5','100',3631787,'','supplier','106',4890000.00,0.00,'Purchase Id 78631 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-10-19 10:51:59','',''),('5','100',3638601,'','20','2215',564217.98,0.00,'Sales from shift 232653 on 2021-10-20 08:23:15 ','2021-10-20 08:23:15','',''),('5','100',3638602,'','6.1','2214',0.00,564217.98,'Sales from shift 232653 on 2021-10-20 08:23:15 ','2021-10-20 08:23:15','',''),('5','100',3647190,'','6.1','2214',8500.00,0.00,'Payment Id 347706 for invoice:231327, receipt: 0099 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 16:17:36','',''),('5','100',3647191,'','supplier','106',0.00,8500.00,'Payment Id 347706 for invoice:231327, receipt: 0099 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 16:17:36','',''),('5','100',3647192,'','2','3236',377410.00,0.00,'Payment Id 347705 for invoice:231327, receipt: 0099 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 16:17:36','',''),('5','100',3647193,'','supplier','106',0.00,377410.00,'Payment Id 347705 for invoice:231327, receipt: 0099 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 16:17:36','',''),('5','100',3647361,'','6.1','2214',29200.00,0.00,'Payment Id 347715 for invoice:231328, receipt: 01143466 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 16:22:59','',''),('5','100',3647362,'','supplier','106',0.00,29200.00,'Payment Id 347715 for invoice:231328, receipt: 01143466 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 16:22:59','',''),('5','100',3647363,'','2','3236',564860.00,0.00,'Payment Id 347713 for invoice:231328, receipt: 01143466 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 16:22:59','',''),('5','100',3647364,'','supplier','106',0.00,564860.00,'Payment Id 347713 for invoice:231328, receipt: 01143466 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 16:22:59','',''),('5','100',3647406,'','6.1','2214',8700.00,0.00,'Payment Id 347717 for invoice:231330, receipt: 0061 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 16:24:44','',''),('5','100',3647407,'','supplier','106',0.00,8700.00,'Payment Id 347717 for invoice:231330, receipt: 0061 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 16:24:44','',''),('5','100',3647408,'','2','3236',843920.00,0.00,'Payment Id 347716 for invoice:231330, receipt: 0061 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 16:24:44','',''),('5','100',3647409,'','supplier','106',0.00,843920.00,'Payment Id 347716 for invoice:231330, receipt: 0061 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 16:24:44','',''),('5','100',3647905,'','6.1','2214',11200.00,0.00,'Payment Id 347735 for invoice:231339, receipt: 0056 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 16:53:19','',''),('5','100',3647906,'','supplier','106',0.00,11200.00,'Payment Id 347735 for invoice:231339, receipt: 0056 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 16:53:19','',''),('5','100',3647907,'','2','3236',308730.00,0.00,'Payment Id 347734 for invoice:231339, receipt: 0056 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 16:53:19','',''),('5','100',3647908,'','supplier','106',0.00,308730.00,'Payment Id 347734 for invoice:231339, receipt: 0056 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 16:53:19','',''),('5','100',3647909,'','6.1','2214',8700.00,0.00,'Payment Id 347732 for invoice:231336, receipt: 0054 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 16:53:20','',''),('5','100',3647910,'','supplier','106',0.00,8700.00,'Payment Id 347732 for invoice:231336, receipt: 0054 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 16:53:20','',''),('5','100',3647911,'','2','3236',669310.00,0.00,'Payment Id 347730 for invoice:231336, receipt: 0054 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 16:53:20','',''),('5','100',3647912,'','supplier','106',0.00,669310.00,'Payment Id 347730 for invoice:231336, receipt: 0054 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 16:53:20','',''),('5','100',3647913,'','6.1','2214',10700.00,0.00,'Payment Id 347723 for invoice:231335, receipt: 0055 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 16:53:20','',''),('5','100',3647914,'','supplier','106',0.00,10700.00,'Payment Id 347723 for invoice:231335, receipt: 0055 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 16:53:20','',''),('5','100',3647915,'','2','3236',608385.00,0.00,'Payment Id 347722 for invoice:231335, receipt: 0055 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 16:53:20','',''),('5','100',3647916,'','supplier','106',0.00,608385.00,'Payment Id 347722 for invoice:231335, receipt: 0055 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 16:53:20','',''),('5','100',3647917,'','6.1','2214',8700.00,0.00,'Payment Id 347721 for invoice:231334, receipt: 0038 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 16:53:20','',''),('5','100',3647918,'','supplier','106',0.00,8700.00,'Payment Id 347721 for invoice:231334, receipt: 0038 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 16:53:20','',''),('5','100',3647919,'','2','3236',566975.00,0.00,'Payment Id 347720 for invoice:231334, receipt: 0038 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 16:53:20','',''),('5','100',3647920,'','supplier','106',0.00,566975.00,'Payment Id 347720 for invoice:231334, receipt: 0038 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 16:53:20','',''),('5','100',3647921,'','6.1','2214',13700.00,0.00,'Payment Id 347719 for invoice:231332, receipt: 0055 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 16:53:20','',''),('5','100',3647922,'','supplier','106',0.00,13700.00,'Payment Id 347719 for invoice:231332, receipt: 0055 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 16:53:20','',''),('5','100',3647923,'','2','3236',844325.00,0.00,'Payment Id 347718 for invoice:231332, receipt: 0055 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 16:53:20','',''),('5','100',3647924,'','supplier','106',0.00,844325.00,'Payment Id 347718 for invoice:231332, receipt: 0055 by SALBAS OIL & GAS NIG. LIMITED','2021-10-20 16:53:20','',''),('5','100',3649206,'','20','2215',781060.14,0.00,'Sales from shift 232900 on 2021-10-21 06:39:43 ','2021-10-21 06:39:43','',''),('5','100',3649207,'','6.1','2214',0.00,781060.14,'Sales from shift 232900 on 2021-10-21 06:39:43 ','2021-10-21 06:39:43','',''),('5','100',3655171,'','6.1','2214',49100.00,0.00,'Payment Id 348264 for invoice:232900, receipt: 0050 by SALBAS OIL & GAS NIG. LIMITED','2021-10-21 14:45:12','',''),('5','100',3655172,'','supplier','106',0.00,49100.00,'Payment Id 348264 for invoice:232900, receipt: 0050 by SALBAS OIL & GAS NIG. LIMITED','2021-10-21 14:45:12','',''),('5','100',3655173,'','2','3236',731960.00,0.00,'Payment Id 348262 for invoice:232900, receipt: 0050 by SALBAS OIL & GAS NIG. LIMITED','2021-10-21 14:45:12','',''),('5','100',3655174,'','supplier','106',0.00,731960.00,'Payment Id 348262 for invoice:232900, receipt: 0050 by SALBAS OIL & GAS NIG. LIMITED','2021-10-21 14:45:12','',''),('5','100',3655175,'','6.1','2214',12040.00,0.00,'Payment Id 348260 for invoice:232653, receipt: 0080 by SALBAS OIL & GAS NIG. LIMITED','2021-10-21 14:45:12','',''),('5','100',3655176,'','supplier','106',0.00,12040.00,'Payment Id 348260 for invoice:232653, receipt: 0080 by SALBAS OIL & GAS NIG. LIMITED','2021-10-21 14:45:12','',''),('5','100',3655177,'','2','3236',552180.00,0.00,'Payment Id 348258 for invoice:232653, receipt: 0080 by SALBAS OIL & GAS NIG. LIMITED','2021-10-21 14:45:12','',''),('5','100',3655178,'','supplier','106',0.00,552180.00,'Payment Id 348258 for invoice:232653, receipt: 0080 by SALBAS OIL & GAS NIG. LIMITED','2021-10-21 14:45:12','',''),('5','100',3655179,'','6.1','2214',9040.00,0.00,'Payment Id 348254 for invoice:232373, receipt: 0079 by SALBAS OIL & GAS NIG. LIMITED','2021-10-21 14:45:12','',''),('5','100',3655180,'','supplier','106',0.00,9040.00,'Payment Id 348254 for invoice:232373, receipt: 0079 by SALBAS OIL & GAS NIG. LIMITED','2021-10-21 14:45:12','',''),('5','100',3655181,'','2','3236',521740.00,0.00,'Payment Id 348253 for invoice:232373, receipt: 0079 by SALBAS OIL & GAS NIG. LIMITED','2021-10-21 14:45:12','',''),('5','100',3655182,'','supplier','106',0.00,521740.00,'Payment Id 348253 for invoice:232373, receipt: 0079 by SALBAS OIL & GAS NIG. LIMITED','2021-10-21 14:45:12','',''),('5','100',3655183,'','6.1','2214',8900.00,0.00,'Payment Id 348252 for invoice:232329, receipt: 0038 by SALBAS OIL & GAS NIG. LIMITED','2021-10-21 14:45:12','',''),('5','100',3655184,'','supplier','106',0.00,8900.00,'Payment Id 348252 for invoice:232329, receipt: 0038 by SALBAS OIL & GAS NIG. LIMITED','2021-10-21 14:45:12','',''),('5','100',3655185,'','2','3236',479975.00,0.00,'Payment Id 348251 for invoice:232329, receipt: 0038 by SALBAS OIL & GAS NIG. LIMITED','2021-10-21 14:45:12','',''),('5','100',3655186,'','supplier','106',0.00,479975.00,'Payment Id 348251 for invoice:232329, receipt: 0038 by SALBAS OIL & GAS NIG. LIMITED','2021-10-21 14:45:12','',''),('5','100',3655187,'','6.1','2214',8900.00,0.00,'Payment Id 348249 for invoice:232063, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2021-10-21 14:45:12','',''),('5','100',3655188,'','supplier','106',0.00,8900.00,'Payment Id 348249 for invoice:232063, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2021-10-21 14:45:12','',''),('5','100',3655189,'','2','3236',625420.00,0.00,'Payment Id 348247 for invoice:232063, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2021-10-21 14:45:12','',''),('5','100',3655190,'','supplier','106',0.00,625420.00,'Payment Id 348247 for invoice:232063, receipt: 0035 by SALBAS OIL & GAS NIG. LIMITED','2021-10-21 14:45:12','',''),('5','100',3655191,'','6.1','2214',203900.00,0.00,'Payment Id 348245 for invoice:231715, receipt: 0039 by SALBAS OIL & GAS NIG. LIMITED','2021-10-21 14:45:12','',''),('5','100',3655192,'','supplier','106',0.00,203900.00,'Payment Id 348245 for invoice:231715, receipt: 0039 by SALBAS OIL & GAS NIG. LIMITED','2021-10-21 14:45:12','',''),('5','100',3655193,'','2','3236',307125.00,0.00,'Payment Id 348244 for invoice:231715, receipt: 0039 by SALBAS OIL & GAS NIG. LIMITED','2021-10-21 14:45:12','',''),('5','100',3655194,'','supplier','106',0.00,307125.00,'Payment Id 348244 for invoice:231715, receipt: 0039 by SALBAS OIL & GAS NIG. LIMITED','2021-10-21 14:45:12','',''),('5','100',3657660,'','24','2213',0.00,652000.00,'Purchase Id 78858 for 4,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-10-21 18:52:42','',''),('5','100',3657661,'','supplier','106',652000.00,0.00,'Purchase Id 78858 for 4,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-10-21 18:52:42','',''),('5','100',3659894,'','20','2215',938172.58,0.00,'Sales from shift 233147 on 2021-10-22 08:47:51 ','2021-10-22 08:47:51','',''),('5','100',3659895,'','6.1','2214',0.00,938172.58,'Sales from shift 233147 on 2021-10-22 08:47:51 ','2021-10-22 08:47:51','',''),('5','100',3669364,'','6.1','2214',9400.00,0.00,'Payment Id 348807 for invoice:233147, receipt: 0076 by SALBAS OIL & GAS NIG. LIMITED','2021-10-23 06:42:14','',''),('5','100',3669365,'','supplier','106',0.00,9400.00,'Payment Id 348807 for invoice:233147, receipt: 0076 by SALBAS OIL & GAS NIG. LIMITED','2021-10-23 06:42:14','',''),('5','100',3669366,'','2','3236',928770.00,0.00,'Payment Id 348806 for invoice:233147, receipt: 0076 by SALBAS OIL & GAS NIG. LIMITED','2021-10-23 06:42:14','',''),('5','100',3669367,'','supplier','106',0.00,928770.00,'Payment Id 348806 for invoice:233147, receipt: 0076 by SALBAS OIL & GAS NIG. LIMITED','2021-10-23 06:42:14','',''),('5','100',3669388,'','20','2215',874869.90,0.00,'Sales from shift 233434 on 2021-10-23 06:43:59 ','2021-10-23 06:43:59','',''),('5','100',3669389,'','6.1','2214',0.00,874869.90,'Sales from shift 233434 on 2021-10-23 06:43:59 ','2021-10-23 06:43:59','',''),('5','100',3679412,'','24','2213',0.00,107743.00,'Purchase Id 79001 for 661.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-10-24 06:47:44','',''),('5','100',3679413,'','supplier','106',107743.00,0.00,'Purchase Id 79001 for 661.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-10-24 06:47:44','',''),('5','100',3692829,'','6.1','2214',9400.00,0.00,'Payment Id 350364 for invoice:233723, receipt: 0048 by SALBAS OIL & GAS NIG. LIMITED','2021-10-25 13:13:50','',''),('5','100',3692830,'','supplier','106',0.00,9400.00,'Payment Id 350364 for invoice:233723, receipt: 0048 by SALBAS OIL & GAS NIG. LIMITED','2021-10-25 13:13:50','',''),('5','100',3692831,'','2','3236',988910.00,0.00,'Payment Id 350362 for invoice:233723, receipt: 0048 by SALBAS OIL & GAS NIG. LIMITED','2021-10-25 13:13:50','',''),('5','100',3692832,'','supplier','106',0.00,988910.00,'Payment Id 350362 for invoice:233723, receipt: 0048 by SALBAS OIL & GAS NIG. LIMITED','2021-10-25 13:13:50','',''),('5','100',3692833,'','6.1','2214',9400.00,0.00,'Payment Id 350360 for invoice:233434, receipt: 0047 by SALBAS OIL & GAS NIG. LIMITED','2021-10-25 13:13:50','',''),('5','100',3692834,'','supplier','106',0.00,9400.00,'Payment Id 350360 for invoice:233434, receipt: 0047 by SALBAS OIL & GAS NIG. LIMITED','2021-10-25 13:13:50','',''),('5','100',3692835,'','2','3236',865470.00,0.00,'Payment Id 350359 for invoice:233434, receipt: 0047 by SALBAS OIL & GAS NIG. LIMITED','2021-10-25 13:13:50','',''),('5','100',3692836,'','supplier','106',0.00,865470.00,'Payment Id 350359 for invoice:233434, receipt: 0047 by SALBAS OIL & GAS NIG. LIMITED','2021-10-25 13:13:50','',''),('5','100',3692841,'','20','2215',998309.80,0.00,'Sales from shift 233723 on 2021-10-25 13:14:09 ','2021-10-25 13:14:09','',''),('5','100',3692842,'','6.1','2214',0.00,998309.80,'Sales from shift 233723 on 2021-10-25 13:14:09 ','2021-10-25 13:14:09','',''),('5','100',3697579,'','6.1','2214',9400.00,0.00,'Payment Id 350417 for invoice:234209, receipt: 0049 by SALBAS OIL & GAS NIG. LIMITED','2021-10-26 06:11:05','',''),('5','100',3697580,'','supplier','106',0.00,9400.00,'Payment Id 350417 for invoice:234209, receipt: 0049 by SALBAS OIL & GAS NIG. LIMITED','2021-10-26 06:11:05','',''),('5','100',3697581,'','2','3236',589690.00,0.00,'Payment Id 350416 for invoice:234209, receipt: 0049 by SALBAS OIL & GAS NIG. LIMITED','2021-10-26 06:11:05','',''),('5','100',3697582,'','supplier','106',0.00,589690.00,'Payment Id 350416 for invoice:234209, receipt: 0049 by SALBAS OIL & GAS NIG. LIMITED','2021-10-26 06:11:05','',''),('5','100',3697585,'','20','2215',599091.83,0.00,'Sales from shift 234209 on 2021-10-26 06:11:27 ','2021-10-26 06:11:27','',''),('5','100',3697586,'','6.1','2214',0.00,599091.83,'Sales from shift 234209 on 2021-10-26 06:11:27 ','2021-10-26 06:11:27','',''),('5','100',3706018,'','6.1','2214',9400.00,0.00,'Payment Id 350977 for invoice:234343, receipt: 0069 by SALBAS OIL & GAS NIG. LIMITED','2021-10-26 15:26:52','',''),('5','100',3706019,'','supplier','106',0.00,9400.00,'Payment Id 350977 for invoice:234343, receipt: 0069 by SALBAS OIL & GAS NIG. LIMITED','2021-10-26 15:26:52','',''),('5','100',3706020,'','2','3236',745265.00,0.00,'Payment Id 350976 for invoice:234343, receipt: 0069 by SALBAS OIL & GAS NIG. LIMITED','2021-10-26 15:26:52','',''),('5','100',3706021,'','supplier','106',0.00,745265.00,'Payment Id 350976 for invoice:234343, receipt: 0069 by SALBAS OIL & GAS NIG. LIMITED','2021-10-26 15:26:52','',''),('5','100',3706042,'','20','2215',754665.55,0.00,'Sales from shift 234343 on 2021-10-26 15:28:03 ','2021-10-26 15:28:03','',''),('5','100',3706043,'','6.1','2214',0.00,754665.55,'Sales from shift 234343 on 2021-10-26 15:28:03 ','2021-10-26 15:28:03','',''),('5','100',3709970,'','20','2215',699174.30,0.00,'Sales from shift 234506 on 2021-10-27 07:27:30 ','2021-10-27 07:27:30','',''),('5','100',3709971,'','6.1','2214',0.00,699174.30,'Sales from shift 234506 on 2021-10-27 07:27:30 ','2021-10-27 07:27:30','',''),('5','100',3719523,'','6.1','2214',19400.00,0.00,'Payment Id 351470 for invoice:234506, receipt: 0090 by SALBAS OIL & GAS NIG. LIMITED','2021-10-28 05:35:22','',''),('5','100',3719524,'','supplier','106',0.00,19400.00,'Payment Id 351470 for invoice:234506, receipt: 0090 by SALBAS OIL & GAS NIG. LIMITED','2021-10-28 05:35:22','',''),('5','100',3719525,'','2','3236',679775.00,0.00,'Payment Id 351469 for invoice:234506, receipt: 0090 by SALBAS OIL & GAS NIG. LIMITED','2021-10-28 05:35:22','',''),('5','100',3719526,'','supplier','106',0.00,679775.00,'Payment Id 351469 for invoice:234506, receipt: 0090 by SALBAS OIL & GAS NIG. LIMITED','2021-10-28 05:35:22','',''),('5','100',3720969,'','20','2215',399158.10,0.00,'Sales from shift 234611 on 2021-10-28 07:52:05 ','2021-10-28 07:52:05','',''),('5','100',3720970,'','6.1','2214',0.00,399158.10,'Sales from shift 234611 on 2021-10-28 07:52:05 ','2021-10-28 07:52:05','',''),('5','100',3738328,'','6.1','2214',11900.00,0.00,'Payment Id 352497 for invoice:234876, receipt: 0033 by SALBAS OIL & GAS NIG. LIMITED','2021-10-29 21:58:57','',''),('5','100',3738329,'','supplier','106',0.00,11900.00,'Payment Id 352497 for invoice:234876, receipt: 0033 by SALBAS OIL & GAS NIG. LIMITED','2021-10-29 21:58:57','',''),('5','100',3738330,'','2','3236',162450.00,0.00,'Payment Id 352496 for invoice:234876, receipt: 0033 by SALBAS OIL & GAS NIG. LIMITED','2021-10-29 21:58:57','',''),('5','100',3738331,'','supplier','106',0.00,162450.00,'Payment Id 352496 for invoice:234876, receipt: 0033 by SALBAS OIL & GAS NIG. LIMITED','2021-10-29 21:58:57','',''),('5','100',3738332,'','6.1','2214',9400.00,0.00,'Payment Id 352495 for invoice:234611, receipt: 0030 by SALBAS OIL & GAS NIG. LIMITED','2021-10-29 21:58:57','',''),('5','100',3738333,'','supplier','106',0.00,9400.00,'Payment Id 352495 for invoice:234611, receipt: 0030 by SALBAS OIL & GAS NIG. LIMITED','2021-10-29 21:58:57','',''),('5','100',3738334,'','2','3236',389760.00,0.00,'Payment Id 352494 for invoice:234611, receipt: 0030 by SALBAS OIL & GAS NIG. LIMITED','2021-10-29 21:58:57','',''),('5','100',3738335,'','supplier','106',0.00,389760.00,'Payment Id 352494 for invoice:234611, receipt: 0030 by SALBAS OIL & GAS NIG. LIMITED','2021-10-29 21:58:57','',''),('5','100',3738336,'','20','2215',174348.90,0.00,'Sales from shift 234876 on 2021-10-29 21:59:22 ','2021-10-29 21:59:22','',''),('5','100',3738337,'','6.1','2214',0.00,174348.90,'Sales from shift 234876 on 2021-10-29 21:59:22 ','2021-10-29 21:59:22','',''),('5','100',3757922,'','24','2213',0.00,4950000.00,'Purchase Id 79500 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-10-31 19:19:59','',''),('5','100',3757923,'','supplier','106',4950000.00,0.00,'Purchase Id 79500 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-10-31 19:19:59','',''),('5','100',3757940,'','20','2215',0.00,0.00,'Sales from shift 235705 on 2021-10-31 19:32:43 ','2021-10-31 19:32:43','',''),('5','100',3757941,'','6.1','2214',0.00,0.00,'Sales from shift 235705 on 2021-10-31 19:32:43 ','2021-10-31 19:32:43','',''),('5','100',3757994,'','20','2215',0.00,0.00,'Sales from shift 235708 on 2021-10-31 20:29:37 ','2021-10-31 20:29:37','',''),('5','100',3757995,'','6.1','2214',0.00,0.00,'Sales from shift 235708 on 2021-10-31 20:29:37 ','2021-10-31 20:29:37','',''),('5','100',3759981,'','20','2215',345556.20,0.00,'Sales from shift 235766 on 2021-11-01 08:59:07 ','2021-11-01 08:59:07','',''),('5','100',3759982,'','6.1','2214',0.00,345556.20,'Sales from shift 235766 on 2021-11-01 08:59:07 ','2021-11-01 08:59:07','',''),('5','100',3766419,'','20','2215',983626.05,0.00,'Sales from shift 235841 on 2021-11-01 20:45:32 ','2021-11-01 20:45:32','',''),('5','100',3766420,'','6.1','2214',0.00,983626.05,'Sales from shift 235841 on 2021-11-01 20:45:32 ','2021-11-01 20:45:32','',''),('5','100',3766526,'','6.1','2214',9400.00,0.00,'Payment Id 354215 for invoice:235766, receipt: 0042 by SALBAS OIL & GAS NIG. LIMITED','2021-11-02 04:28:01','',''),('5','100',3766527,'','supplier','106',0.00,9400.00,'Payment Id 354215 for invoice:235766, receipt: 0042 by SALBAS OIL & GAS NIG. LIMITED','2021-11-02 04:28:01','',''),('5','100',3766528,'','2','3236',336150.00,0.00,'Payment Id 354214 for invoice:235766, receipt: 0042 by SALBAS OIL & GAS NIG. LIMITED','2021-11-02 04:28:01','',''),('5','100',3766529,'','supplier','106',0.00,336150.00,'Payment Id 354214 for invoice:235766, receipt: 0042 by SALBAS OIL & GAS NIG. LIMITED','2021-11-02 04:28:01','',''),('5','100',3766789,'','2','2216',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','100',3767833,'','24','2217',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','100',3767893,'','6.1','2214',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','100',3768389,'','2','3236',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','100',3768841,'','20','2215',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','100',3770081,'','24','2213',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','100',3778130,'','20','2215',1601506.50,0.00,'Sales from shift 236119 on 2021-11-03 05:01:18 ','2021-11-03 05:01:18','',''),('5','100',3778131,'','6.1','2214',0.00,1601506.50,'Sales from shift 236119 on 2021-11-03 05:01:18 ','2021-11-03 05:01:18','',''),('5','100',3790182,'','20','2215',1837469.70,0.00,'Sales from shift 236363 on 2021-11-04 06:29:41 ','2021-11-04 06:29:41','',''),('5','100',3790183,'','6.1','2214',0.00,1837469.70,'Sales from shift 236363 on 2021-11-04 06:29:41 ','2021-11-04 06:29:41','',''),('5','100',3813534,'','20','2215',170676.00,0.00,'Sales from shift 236552 on 2021-11-05 15:11:47 ','2021-11-05 15:11:47','',''),('5','100',3813535,'','6.1','2214',0.00,170676.00,'Sales from shift 236552 on 2021-11-05 15:11:47 ','2021-11-05 15:11:47','',''),('5','100',3828685,'','20','2215',0.00,0.00,'Sales from shift 236911 on 2021-11-07 07:09:19 ','2021-11-07 07:09:19','',''),('5','100',3828686,'','6.1','2214',0.00,0.00,'Sales from shift 236911 on 2021-11-07 07:09:19 ','2021-11-07 07:09:19','',''),('5','100',3840900,'','20','2215',0.00,0.00,'Sales from shift 237398 on 2021-11-08 07:27:28 ','2021-11-08 07:27:28','',''),('5','100',3840901,'','6.1','2214',0.00,0.00,'Sales from shift 237398 on 2021-11-08 07:27:28 ','2021-11-08 07:27:28','',''),('5','100',3863313,'','20','2215',0.00,0.00,'Sales from shift 237809 on 2021-11-09 18:43:47 ','2021-11-09 18:43:47','',''),('5','100',3863314,'','6.1','2214',0.00,0.00,'Sales from shift 237809 on 2021-11-09 18:43:47 ','2021-11-09 18:43:47','',''),('5','100',3863329,'','20','2215',0.00,0.00,'Sales from shift 237810 on 2021-11-09 18:48:34 ','2021-11-09 18:48:34','',''),('5','100',3863330,'','6.1','2214',0.00,0.00,'Sales from shift 237810 on 2021-11-09 18:48:34 ','2021-11-09 18:48:34','',''),('5','100',3863349,'','20','2215',0.00,0.00,'Sales from shift 237813 on 2021-11-09 18:55:51 ','2021-11-09 18:55:51','',''),('5','100',3863350,'','6.1','2214',0.00,0.00,'Sales from shift 237813 on 2021-11-09 18:55:51 ','2021-11-09 18:55:51','',''),('5','100',3863388,'','6.1','2214',9400.00,0.00,'Payment Id 358251 for invoice:236119, receipt: 0008 by SALBAS OIL & GAS NIG. LIMITED','2021-11-09 19:18:50','',''),('5','100',3863389,'','supplier','106',0.00,9400.00,'Payment Id 358251 for invoice:236119, receipt: 0008 by SALBAS OIL & GAS NIG. LIMITED','2021-11-09 19:18:50','',''),('5','100',3863390,'','2','3236',1592100.00,0.00,'Payment Id 358250 for invoice:236119, receipt: 0008 by SALBAS OIL & GAS NIG. LIMITED','2021-11-09 19:18:50','',''),('5','100',3863391,'','supplier','106',0.00,1592100.00,'Payment Id 358250 for invoice:236119, receipt: 0008 by SALBAS OIL & GAS NIG. LIMITED','2021-11-09 19:18:50','',''),('5','100',3863392,'','6.1','2214',9400.00,0.00,'Payment Id 358249 for invoice:235841, receipt: 0031 by SALBAS OIL & GAS NIG. LIMITED','2021-11-09 19:18:50','',''),('5','100',3863393,'','supplier','106',0.00,9400.00,'Payment Id 358249 for invoice:235841, receipt: 0031 by SALBAS OIL & GAS NIG. LIMITED','2021-11-09 19:18:50','',''),('5','100',3863394,'','2','3236',974220.00,0.00,'Payment Id 358248 for invoice:235841, receipt: 0031 by SALBAS OIL & GAS NIG. LIMITED','2021-11-09 19:18:50','',''),('5','100',3863395,'','supplier','106',0.00,974220.00,'Payment Id 358248 for invoice:235841, receipt: 0031 by SALBAS OIL & GAS NIG. LIMITED','2021-11-09 19:18:50','',''),('5','100',3880029,'','20','2215',0.00,0.00,'Sales from shift 238002 on 2021-11-11 09:42:51 ','2021-11-11 09:42:51','',''),('5','100',3880030,'','6.1','2214',0.00,0.00,'Sales from shift 238002 on 2021-11-11 09:42:51 ','2021-11-11 09:42:51','',''),('5','100',3892754,'','20','2215',0.00,0.00,'Sales from shift 238247 on 2021-11-12 08:17:49 ','2021-11-12 08:17:49','',''),('5','100',3892755,'','6.1','2214',0.00,0.00,'Sales from shift 238247 on 2021-11-12 08:17:49 ','2021-11-12 08:17:49','',''),('5','100',3896405,'','24','2213',0.00,2458500.00,'Purchase Id 80382 for 14,900.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-11-12 12:13:57','',''),('5','100',3896406,'','supplier','106',2458500.00,0.00,'Purchase Id 80382 for 14,900.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-11-12 12:13:57','',''),('5','100',3902925,'','20','2215',845184.45,0.00,'Sales from shift 238421 on 2021-11-13 05:52:29 ','2021-11-13 05:52:29','',''),('5','100',3902926,'','6.1','2214',0.00,845184.45,'Sales from shift 238421 on 2021-11-13 05:52:29 ','2021-11-13 05:52:29','',''),('5','100',3918333,'','20','2215',913408.65,0.00,'Sales from shift 238649 on 2021-11-14 09:02:47 ','2021-11-14 09:02:47','',''),('5','100',3918334,'','6.1','2214',0.00,913408.65,'Sales from shift 238649 on 2021-11-14 09:02:47 ','2021-11-14 09:02:47','',''),('5','100',3928503,'','20','2215',559222.95,0.00,'Sales from shift 238892 on 2021-11-15 07:23:35 ','2021-11-15 07:23:35','',''),('5','100',3928504,'','6.1','2214',0.00,559222.95,'Sales from shift 238892 on 2021-11-15 07:23:35 ','2021-11-15 07:23:35','',''),('5','100',3935935,'','6.1','2214',9400.00,0.00,'Payment Id 361192 for invoice:238892, receipt: 0022 by SALBAS OIL & GAS NIG. LIMITED','2021-11-15 15:53:14','',''),('5','100',3935936,'','supplier','106',0.00,9400.00,'Payment Id 361192 for invoice:238892, receipt: 0022 by SALBAS OIL & GAS NIG. LIMITED','2021-11-15 15:53:14','',''),('5','100',3935937,'','2','3236',549820.00,0.00,'Payment Id 361191 for invoice:238892, receipt: 0022 by SALBAS OIL & GAS NIG. LIMITED','2021-11-15 15:53:14','',''),('5','100',3935938,'','supplier','106',0.00,549820.00,'Payment Id 361191 for invoice:238892, receipt: 0022 by SALBAS OIL & GAS NIG. LIMITED','2021-11-15 15:53:14','',''),('5','100',3935939,'','6.1','2214',9400.00,0.00,'Payment Id 361184 for invoice:238649, receipt: 0020 by SALBAS OIL & GAS NIG. LIMITED','2021-11-15 15:53:14','',''),('5','100',3935940,'','supplier','106',0.00,9400.00,'Payment Id 361184 for invoice:238649, receipt: 0020 by SALBAS OIL & GAS NIG. LIMITED','2021-11-15 15:53:14','',''),('5','100',3935941,'','2','3236',904000.00,0.00,'Payment Id 361183 for invoice:238649, receipt: 0020 by SALBAS OIL & GAS NIG. LIMITED','2021-11-15 15:53:14','',''),('5','100',3935942,'','supplier','106',0.00,904000.00,'Payment Id 361183 for invoice:238649, receipt: 0020 by SALBAS OIL & GAS NIG. LIMITED','2021-11-15 15:53:14','',''),('5','100',3935943,'','6.1','2214',9400.00,0.00,'Payment Id 361182 for invoice:238421, receipt: 0021 by SALBAS OIL & GAS NIG. LIMITED','2021-11-15 15:53:14','',''),('5','100',3935944,'','supplier','106',0.00,9400.00,'Payment Id 361182 for invoice:238421, receipt: 0021 by SALBAS OIL & GAS NIG. LIMITED','2021-11-15 15:53:14','',''),('5','100',3935945,'','2','3236',835715.00,0.00,'Payment Id 361181 for invoice:238421, receipt: 0021 by SALBAS OIL & GAS NIG. LIMITED','2021-11-15 15:53:14','',''),('5','100',3935946,'','supplier','106',0.00,835715.00,'Payment Id 361181 for invoice:238421, receipt: 0021 by SALBAS OIL & GAS NIG. LIMITED','2021-11-15 15:53:14','',''),('5','100',3935947,'','6.1','2214',11900.00,0.00,'Payment Id 358926 for invoice:236552, receipt: 0026 by SALBAS OIL & GAS NIG. LIMITED','2021-11-15 15:53:14','',''),('5','100',3935948,'','supplier','106',0.00,11900.00,'Payment Id 358926 for invoice:236552, receipt: 0026 by SALBAS OIL & GAS NIG. LIMITED','2021-11-15 15:53:14','',''),('5','100',3935949,'','2','3236',158775.00,0.00,'Payment Id 358925 for invoice:236552, receipt: 0026 by SALBAS OIL & GAS NIG. LIMITED','2021-11-15 15:53:15','',''),('5','100',3935950,'','supplier','106',0.00,158775.00,'Payment Id 358925 for invoice:236552, receipt: 0026 by SALBAS OIL & GAS NIG. LIMITED','2021-11-15 15:53:15','',''),('5','100',3935951,'','6.1','2214',35100.00,0.00,'Payment Id 358922 for invoice:236363, receipt: 0074 by SALBAS OIL & GAS NIG. LIMITED','2021-11-15 15:53:15','',''),('5','100',3935952,'','supplier','106',0.00,35100.00,'Payment Id 358922 for invoice:236363, receipt: 0074 by SALBAS OIL & GAS NIG. LIMITED','2021-11-15 15:53:15','',''),('5','100',3935953,'','2','3236',1802370.00,0.00,'Payment Id 358921 for invoice:236363, receipt: 0074 by SALBAS OIL & GAS NIG. LIMITED','2021-11-15 15:53:15','',''),('5','100',3935954,'','supplier','106',0.00,1802370.00,'Payment Id 358921 for invoice:236363, receipt: 0074 by SALBAS OIL & GAS NIG. LIMITED','2021-11-15 15:53:15','',''),('5','100',3940362,'','20','2215',176581.35,0.00,'Sales from shift 239112 on 2021-11-16 08:08:44 ','2021-11-16 08:08:44','',''),('5','100',3940363,'','6.1','2214',0.00,176581.35,'Sales from shift 239112 on 2021-11-16 08:08:44 ','2021-11-16 08:08:44','',''),('5','100',3950192,'','20','2215',0.00,0.00,'Sales from shift 239352 on 2021-11-17 05:39:30 ','2021-11-17 05:39:30','',''),('5','100',3950193,'','6.1','2214',0.00,0.00,'Sales from shift 239352 on 2021-11-17 05:39:30 ','2021-11-17 05:39:30','',''),('5','100',3962531,'','20','2215',0.00,0.00,'Sales from shift 239617 on 2021-11-18 06:23:58 ','2021-11-18 06:23:58','',''),('5','100',3962532,'','6.1','2214',0.00,0.00,'Sales from shift 239617 on 2021-11-18 06:23:58 ','2021-11-18 06:23:58','',''),('5','100',3974866,'','20','2215',0.00,0.00,'Sales from shift 239853 on 2021-11-19 04:41:25 ','2021-11-19 04:41:25','',''),('5','100',3974867,'','6.1','2214',0.00,0.00,'Sales from shift 239853 on 2021-11-19 04:41:25 ','2021-11-19 04:41:25','',''),('5','100',3986456,'','20','2215',0.00,0.00,'Sales from shift 240154 on 2021-11-20 06:37:13 ','2021-11-20 06:37:13','',''),('5','100',3986457,'','6.1','2214',0.00,0.00,'Sales from shift 240154 on 2021-11-20 06:37:13 ','2021-11-20 06:37:13','',''),('5','100',3999242,'','20','2215',0.00,0.00,'Sales from shift 240383 on 2021-11-20 20:43:23 ','2021-11-20 20:43:23','',''),('5','100',3999243,'','6.1','2214',0.00,0.00,'Sales from shift 240383 on 2021-11-20 20:43:23 ','2021-11-20 20:43:23','',''),('5','100',4012364,'','20','2215',0.00,0.00,'Sales from shift 240616 on 2021-11-22 06:19:29 ','2021-11-22 06:19:29','',''),('5','100',4012365,'','6.1','2214',0.00,0.00,'Sales from shift 240616 on 2021-11-22 06:19:29 ','2021-11-22 06:19:29','',''),('5','100',4024086,'','20','2215',0.00,0.00,'Sales from shift 240792 on 2021-11-23 05:36:37 ','2021-11-23 05:36:37','',''),('5','100',4024087,'','6.1','2214',0.00,0.00,'Sales from shift 240792 on 2021-11-23 05:36:37 ','2021-11-23 05:36:37','',''),('5','100',4027795,'','24','2213',0.00,7425000.00,'Purchase Id 85464 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-11-23 09:26:52','',''),('5','100',4027796,'','supplier','106',7425000.00,0.00,'Purchase Id 85464 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-11-23 09:26:52','',''),('5','100',4038488,'','20','2215',548464.95,0.00,'Sales from shift 241051 on 2021-11-24 07:04:03 ','2021-11-24 07:04:03','',''),('5','100',4038489,'','6.1','2214',0.00,548464.95,'Sales from shift 241051 on 2021-11-24 07:04:03 ','2021-11-24 07:04:03','',''),('5','100',4049575,'','20','2215',1250561.40,0.00,'Sales from shift 241294 on 2021-11-25 05:52:18 ','2021-11-25 05:52:18','',''),('5','100',4049576,'','6.1','2214',0.00,1250561.40,'Sales from shift 241294 on 2021-11-25 05:52:18 ','2021-11-25 05:52:18','',''),('5','100',4062889,'','20','2215',1221381.15,0.00,'Sales from shift 241567 on 2021-11-26 05:58:36 ','2021-11-26 05:58:36','',''),('5','100',4062890,'','6.1','2214',0.00,1221381.15,'Sales from shift 241567 on 2021-11-26 05:58:36 ','2021-11-26 05:58:36','',''),('5','100',4063058,'','6.1','2214',204400.00,0.00,'Payment Id 366877 for invoice:241051, receipt: 0045 by SALBAS OIL & GAS NIG. LIMITED','2021-11-26 06:23:45','',''),('5','100',4063059,'','supplier','106',0.00,204400.00,'Payment Id 366877 for invoice:241051, receipt: 0045 by SALBAS OIL & GAS NIG. LIMITED','2021-11-26 06:23:45','',''),('5','100',4063060,'','2','3236',344065.00,0.00,'Payment Id 366876 for invoice:241051, receipt: 0045 by SALBAS OIL & GAS NIG. LIMITED','2021-11-26 06:23:45','',''),('5','100',4063061,'','supplier','106',0.00,344065.00,'Payment Id 366876 for invoice:241051, receipt: 0045 by SALBAS OIL & GAS NIG. LIMITED','2021-11-26 06:23:45','',''),('5','100',4063062,'','6.1','2214',14900.00,0.00,'Payment Id 366875 for invoice:239112, receipt: 0068 by SALBAS OIL & GAS NIG. LIMITED','2021-11-26 06:23:45','',''),('5','100',4063063,'','supplier','106',0.00,14900.00,'Payment Id 366875 for invoice:239112, receipt: 0068 by SALBAS OIL & GAS NIG. LIMITED','2021-11-26 06:23:45','',''),('5','100',4063064,'','2','3236',161680.00,0.00,'Payment Id 366874 for invoice:239112, receipt: 0068 by SALBAS OIL & GAS NIG. LIMITED','2021-11-26 06:23:45','',''),('5','100',4063065,'','supplier','106',0.00,161680.00,'Payment Id 366874 for invoice:239112, receipt: 0068 by SALBAS OIL & GAS NIG. LIMITED','2021-11-26 06:23:45','',''),('5','100',4066275,'','6.1','2214',19400.00,0.00,'Payment Id 366879 for invoice:241294, receipt: 0024 by SALBAS OIL & GAS NIG. LIMITED','2021-11-26 09:45:18','',''),('5','100',4066276,'','supplier','106',0.00,19400.00,'Payment Id 366879 for invoice:241294, receipt: 0024 by SALBAS OIL & GAS NIG. LIMITED','2021-11-26 09:45:18','',''),('5','100',4066277,'','2','3236',1231160.00,0.00,'Payment Id 366878 for invoice:241294, receipt: 0024 by SALBAS OIL & GAS NIG. LIMITED','2021-11-26 09:45:18','',''),('5','100',4066278,'','supplier','106',0.00,1231160.00,'Payment Id 366878 for invoice:241294, receipt: 0024 by SALBAS OIL & GAS NIG. LIMITED','2021-11-26 09:45:18','',''),('5','100',4075031,'','20','2215',1021519.95,0.00,'Sales from shift 241738 on 2021-11-27 06:11:16 ','2021-11-27 06:11:16','',''),('5','100',4075032,'','6.1','2214',0.00,1021519.95,'Sales from shift 241738 on 2021-11-27 06:11:16 ','2021-11-27 06:11:16','',''),('5','100',4089310,'','20','2215',1134909.60,0.00,'Sales from shift 242101 on 2021-11-28 07:30:12 ','2021-11-28 07:30:12','',''),('5','100',4089311,'','6.1','2214',0.00,1134909.60,'Sales from shift 242101 on 2021-11-28 07:30:12 ','2021-11-28 07:30:12','',''),('5','100',4100593,'','20','2215',1269209.70,0.00,'Sales from shift 242401 on 2021-11-29 04:57:30 ','2021-11-29 04:57:30','',''),('5','100',4100594,'','6.1','2214',0.00,1269209.70,'Sales from shift 242401 on 2021-11-29 04:57:30 ','2021-11-29 04:57:30','',''),('5','100',4115993,'','6.1','2214',9400.00,0.00,'Payment Id 369088 for invoice:242401, receipt: 0025 by SALBAS OIL & GAS NIG. LIMITED','2021-11-30 09:22:17','',''),('5','100',4115994,'','supplier','106',0.00,9400.00,'Payment Id 369088 for invoice:242401, receipt: 0025 by SALBAS OIL & GAS NIG. LIMITED','2021-11-30 09:22:17','',''),('5','100',4115995,'','2','3236',1259810.00,0.00,'Payment Id 369085 for invoice:242401, receipt: 0025 by SALBAS OIL & GAS NIG. LIMITED','2021-11-30 09:22:17','',''),('5','100',4115996,'','supplier','106',0.00,1259810.00,'Payment Id 369085 for invoice:242401, receipt: 0025 by SALBAS OIL & GAS NIG. LIMITED','2021-11-30 09:22:17','',''),('5','100',4115997,'','6.1','2214',14400.00,0.00,'Payment Id 369081 for invoice:242101, receipt: 0023 by SALBAS OIL & GAS NIG. LIMITED','2021-11-30 09:22:17','',''),('5','100',4115998,'','supplier','106',0.00,14400.00,'Payment Id 369081 for invoice:242101, receipt: 0023 by SALBAS OIL & GAS NIG. LIMITED','2021-11-30 09:22:17','',''),('5','100',4115999,'','2','3236',1120500.00,0.00,'Payment Id 369079 for invoice:242101, receipt: 0023 by SALBAS OIL & GAS NIG. LIMITED','2021-11-30 09:22:17','',''),('5','100',4116000,'','supplier','106',0.00,1120500.00,'Payment Id 369079 for invoice:242101, receipt: 0023 by SALBAS OIL & GAS NIG. LIMITED','2021-11-30 09:22:17','',''),('5','100',4116001,'','6.1','2214',9400.00,0.00,'Payment Id 369074 for invoice:241738, receipt: 0024 by SALBAS OIL & GAS NIG. LIMITED','2021-11-30 09:22:17','',''),('5','100',4116002,'','supplier','106',0.00,9400.00,'Payment Id 369074 for invoice:241738, receipt: 0024 by SALBAS OIL & GAS NIG. LIMITED','2021-11-30 09:22:17','',''),('5','100',4116003,'','2','3236',1012120.00,0.00,'Payment Id 369072 for invoice:241738, receipt: 0024 by SALBAS OIL & GAS NIG. LIMITED','2021-11-30 09:22:17','',''),('5','100',4116004,'','supplier','106',0.00,1012120.00,'Payment Id 369072 for invoice:241738, receipt: 0024 by SALBAS OIL & GAS NIG. LIMITED','2021-11-30 09:22:17','',''),('5','100',4116005,'','6.1','2214',9400.00,0.00,'Payment Id 369068 for invoice:241567, receipt: 0053 by SALBAS OIL & GAS NIG. LIMITED','2021-11-30 09:22:17','',''),('5','100',4116006,'','supplier','106',0.00,9400.00,'Payment Id 369068 for invoice:241567, receipt: 0053 by SALBAS OIL & GAS NIG. LIMITED','2021-11-30 09:22:17','',''),('5','100',4116007,'','2','3236',1211980.00,0.00,'Payment Id 369066 for invoice:241567, receipt: 0053 by SALBAS OIL & GAS NIG. LIMITED','2021-11-30 09:22:17','',''),('5','100',4116008,'','supplier','106',0.00,1211980.00,'Payment Id 369066 for invoice:241567, receipt: 0053 by SALBAS OIL & GAS NIG. LIMITED','2021-11-30 09:22:17','',''),('5','100',4315066,'','20','2215',820419.60,0.00,'Sales from shift 242590 on 2021-12-15 10:42:54 ','2021-12-15 10:42:54','',''),('5','100',4315067,'','6.1','2214',0.00,820419.60,'Sales from shift 242590 on 2021-12-15 10:42:54 ','2021-12-15 10:42:54','',''),('5','100',4315209,'','20','2215',208353.75,0.00,'Sales from shift 246303 on 2021-12-15 10:51:12 ','2021-12-15 10:51:12','',''),('5','100',4315210,'','6.1','2214',0.00,208353.75,'Sales from shift 246303 on 2021-12-15 10:51:12 ','2021-12-15 10:51:12','',''),('5','100',4315390,'','24','2213',0.00,7425000.00,'Purchase Id 87265 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-12-15 10:59:22','',''),('5','100',4315391,'','supplier','106',7425000.00,0.00,'Purchase Id 87265 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-12-15 10:59:22','',''),('5','100',4315812,'','20','2215',610762.35,0.00,'Sales from shift 246305 on 2021-12-15 11:17:52 ','2021-12-15 11:17:52','',''),('5','100',4315813,'','6.1','2214',0.00,610762.35,'Sales from shift 246305 on 2021-12-15 11:17:52 ','2021-12-15 11:17:52','',''),('5','100',4315974,'','20','2215',1207800.00,0.00,'Sales from shift 246311 on 2021-12-15 11:24:53 ','2021-12-15 11:24:53','',''),('5','100',4315975,'','6.1','2214',0.00,1207800.00,'Sales from shift 246311 on 2021-12-15 11:24:53 ','2021-12-15 11:24:53','',''),('5','100',4316082,'','20','2215',1103010.15,0.00,'Sales from shift 246314 on 2021-12-15 11:31:48 ','2021-12-15 11:31:48','',''),('5','100',4316083,'','6.1','2214',0.00,1103010.15,'Sales from shift 246314 on 2021-12-15 11:31:48 ','2021-12-15 11:31:48','',''),('5','100',4316220,'','20','2215',1470009.75,0.00,'Sales from shift 246316 on 2021-12-15 11:37:17 ','2021-12-15 11:37:17','',''),('5','100',4316221,'','6.1','2214',0.00,1470009.75,'Sales from shift 246316 on 2021-12-15 11:37:17 ','2021-12-15 11:37:17','',''),('5','100',4316437,'','20','2215',910537.65,0.00,'Sales from shift 246317 on 2021-12-15 11:49:20 ','2021-12-15 11:49:20','',''),('5','100',4316438,'','6.1','2214',0.00,910537.65,'Sales from shift 246317 on 2021-12-15 11:49:20 ','2021-12-15 11:49:20','',''),('5','100',4316596,'','20','2215',921300.60,0.00,'Sales from shift 246319 on 2021-12-15 11:58:19 ','2021-12-15 11:58:19','',''),('5','100',4316597,'','6.1','2214',0.00,921300.60,'Sales from shift 246319 on 2021-12-15 11:58:19 ','2021-12-15 11:58:19','',''),('5','100',4317224,'','20','2215',989808.60,0.00,'Sales from shift 246323 on 2021-12-15 12:37:23 ','2021-12-15 12:37:23','',''),('5','100',4317225,'','6.1','2214',0.00,989808.60,'Sales from shift 246323 on 2021-12-15 12:37:23 ','2021-12-15 12:37:23','',''),('5','100',4317309,'','20','2215',221662.65,0.00,'Sales from shift 246324 on 2021-12-15 12:40:39 ','2021-12-15 12:40:39','',''),('5','100',4317310,'','6.1','2214',0.00,221662.65,'Sales from shift 246324 on 2021-12-15 12:40:39 ','2021-12-15 12:40:39','',''),('5','100',4317349,'','20','2215',0.00,0.00,'Sales from shift 246325 on 2021-12-15 12:42:37 ','2021-12-15 12:42:37','',''),('5','100',4317350,'','6.1','2214',0.00,0.00,'Sales from shift 246325 on 2021-12-15 12:42:37 ','2021-12-15 12:42:37','',''),('5','100',4317419,'','20','2215',0.00,0.00,'Sales from shift 246326 on 2021-12-15 12:45:13 ','2021-12-15 12:45:13','',''),('5','100',4317420,'','6.1','2214',0.00,0.00,'Sales from shift 246326 on 2021-12-15 12:45:13 ','2021-12-15 12:45:13','',''),('5','100',4317469,'','20','2215',0.00,0.00,'Sales from shift 246327 on 2021-12-15 12:48:22 ','2021-12-15 12:48:22','',''),('5','100',4317470,'','6.1','2214',0.00,0.00,'Sales from shift 246327 on 2021-12-15 12:48:22 ','2021-12-15 12:48:22','',''),('5','100',4317538,'','20','2215',0.00,0.00,'Sales from shift 246331 on 2021-12-15 12:52:35 ','2021-12-15 12:52:35','',''),('5','100',4317539,'','6.1','2214',0.00,0.00,'Sales from shift 246331 on 2021-12-15 12:52:35 ','2021-12-15 12:52:35','',''),('5','100',4336105,'','6.1','2214',11900.00,0.00,'Payment Id 377652 for invoice:246324, receipt: 0033 by SALBAS OIL & GAS NIG. LIMITED','2021-12-16 15:52:14','',''),('5','100',4336106,'','supplier','106',0.00,11900.00,'Payment Id 377652 for invoice:246324, receipt: 0033 by SALBAS OIL & GAS NIG. LIMITED','2021-12-16 15:52:14','',''),('5','100',4336107,'','2','3236',209760.00,0.00,'Payment Id 377651 for invoice:246324, receipt: 0033 by SALBAS OIL & GAS NIG. LIMITED','2021-12-16 15:52:14','',''),('5','100',4336108,'','supplier','106',0.00,209760.00,'Payment Id 377651 for invoice:246324, receipt: 0033 by SALBAS OIL & GAS NIG. LIMITED','2021-12-16 15:52:14','',''),('5','100',4336109,'','6.1','2214',9400.00,0.00,'Payment Id 377649 for invoice:246323, receipt:  by SALBAS OIL & GAS NIG. LIMITED','2021-12-16 15:52:14','',''),('5','100',4336110,'','supplier','106',0.00,9400.00,'Payment Id 377649 for invoice:246323, receipt:  by SALBAS OIL & GAS NIG. LIMITED','2021-12-16 15:52:14','',''),('5','100',4336111,'','2','3236',980400.00,0.00,'Payment Id 377648 for invoice:246323, receipt: 0016 by SALBAS OIL & GAS NIG. LIMITED','2021-12-16 15:52:14','',''),('5','100',4336112,'','supplier','106',0.00,980400.00,'Payment Id 377648 for invoice:246323, receipt: 0016 by SALBAS OIL & GAS NIG. LIMITED','2021-12-16 15:52:14','',''),('5','100',4336113,'','6.1','2214',9400.00,0.00,'Payment Id 377646 for invoice:246319, receipt: 0067 by SALBAS OIL & GAS NIG. LIMITED','2021-12-16 15:52:14','',''),('5','100',4336114,'','supplier','106',0.00,9400.00,'Payment Id 377646 for invoice:246319, receipt: 0067 by SALBAS OIL & GAS NIG. LIMITED','2021-12-16 15:52:14','',''),('5','100',4336115,'','2','3236',911900.00,0.00,'Payment Id 377644 for invoice:246319, receipt: 0067 by SALBAS OIL & GAS NIG. LIMITED','2021-12-16 15:52:14','',''),('5','100',4336116,'','supplier','106',0.00,911900.00,'Payment Id 377644 for invoice:246319, receipt: 0067 by SALBAS OIL & GAS NIG. LIMITED','2021-12-16 15:52:14','',''),('5','100',4336117,'','6.1','2214',204400.00,0.00,'Payment Id 377641 for invoice:246317, receipt: 0032 by SALBAS OIL & GAS NIG. LIMITED','2021-12-16 15:52:14','',''),('5','100',4336118,'','supplier','106',0.00,204400.00,'Payment Id 377641 for invoice:246317, receipt: 0032 by SALBAS OIL & GAS NIG. LIMITED','2021-12-16 15:52:14','',''),('5','100',4336119,'','2','3236',706140.00,0.00,'Payment Id 377639 for invoice:246317, receipt: 0032 by SALBAS OIL & GAS NIG. LIMITED','2021-12-16 15:52:14','',''),('5','100',4336120,'','supplier','106',0.00,706140.00,'Payment Id 377639 for invoice:246317, receipt: 0032 by SALBAS OIL & GAS NIG. LIMITED','2021-12-16 15:52:14','',''),('5','100',4336121,'','6.1','2214',19900.00,0.00,'Payment Id 377632 for invoice:246316, receipt: 0067 by SALBAS OIL & GAS NIG. LIMITED','2021-12-16 15:52:14','',''),('5','100',4336122,'','supplier','106',0.00,19900.00,'Payment Id 377632 for invoice:246316, receipt: 0067 by SALBAS OIL & GAS NIG. LIMITED','2021-12-16 15:52:14','',''),('5','100',4336123,'','2','3236',1450110.00,0.00,'Payment Id 377631 for invoice:246316, receipt: 0067 by SALBAS OIL & GAS NIG. LIMITED','2021-12-16 15:52:14','',''),('5','100',4336124,'','supplier','106',0.00,1450110.00,'Payment Id 377631 for invoice:246316, receipt: 0067 by SALBAS OIL & GAS NIG. LIMITED','2021-12-16 15:52:14','',''),('5','100',4336125,'','6.1','2214',19400.00,0.00,'Payment Id 377628 for invoice:246314, receipt: 0056 by SALBAS OIL & GAS NIG. LIMITED','2021-12-16 15:52:14','',''),('5','100',4336126,'','supplier','106',0.00,19400.00,'Payment Id 377628 for invoice:246314, receipt: 0056 by SALBAS OIL & GAS NIG. LIMITED','2021-12-16 15:52:14','',''),('5','100',4336127,'','2','3236',1083610.00,0.00,'Payment Id 377626 for invoice:246314, receipt: 0056 by SALBAS OIL & GAS NIG. LIMITED','2021-12-16 15:52:14','',''),('5','100',4336128,'','supplier','106',0.00,1083610.00,'Payment Id 377626 for invoice:246314, receipt: 0056 by SALBAS OIL & GAS NIG. LIMITED','2021-12-16 15:52:14','',''),('5','100',4336129,'','6.1','2214',9400.00,0.00,'Payment Id 377625 for invoice:246311, receipt: 0055 by SALBAS OIL & GAS NIG. LIMITED','2021-12-16 15:52:14','',''),('5','100',4336130,'','supplier','106',0.00,9400.00,'Payment Id 377625 for invoice:246311, receipt: 0055 by SALBAS OIL & GAS NIG. LIMITED','2021-12-16 15:52:14','',''),('5','100',4336131,'','2','3236',1198400.00,0.00,'Payment Id 377619 for invoice:246311, receipt: 0055 by SALBAS OIL & GAS NIG. LIMITED','2021-12-16 15:52:14','',''),('5','100',4336132,'','supplier','106',0.00,1198400.00,'Payment Id 377619 for invoice:246311, receipt: 0055 by SALBAS OIL & GAS NIG. LIMITED','2021-12-16 15:52:14','',''),('5','100',4336133,'','6.1','2214',30100.00,0.00,'Payment Id 377616 for invoice:246305, receipt: 0057 by SALBAS OIL & GAS NIG. LIMITED','2021-12-16 15:52:14','',''),('5','100',4336134,'','supplier','106',0.00,30100.00,'Payment Id 377616 for invoice:246305, receipt: 0057 by SALBAS OIL & GAS NIG. LIMITED','2021-12-16 15:52:14','',''),('5','100',4336135,'','2','3236',580660.00,0.00,'Payment Id 377615 for invoice:246305, receipt: 0057 by SALBAS OIL & GAS NIG. LIMITED','2021-12-16 15:52:14','',''),('5','100',4336136,'','supplier','106',0.00,580660.00,'Payment Id 377615 for invoice:246305, receipt: 0057 by SALBAS OIL & GAS NIG. LIMITED','2021-12-16 15:52:14','',''),('5','100',4336137,'','6.1','2214',11900.00,0.00,'Payment Id 377614 for invoice:246303, receipt: 0069 by SALBAS OIL & GAS NIG. LIMITED','2021-12-16 15:52:14','',''),('5','100',4336138,'','supplier','106',0.00,11900.00,'Payment Id 377614 for invoice:246303, receipt: 0069 by SALBAS OIL & GAS NIG. LIMITED','2021-12-16 15:52:14','',''),('5','100',4336139,'','2','3236',166450.00,0.00,'Payment Id 377613 for invoice:246303, receipt: 0069 by SALBAS OIL & GAS NIG. LIMITED','2021-12-16 15:52:14','',''),('5','100',4336140,'','supplier','106',0.00,166450.00,'Payment Id 377613 for invoice:246303, receipt: 0069 by SALBAS OIL & GAS NIG. LIMITED','2021-12-16 15:52:14','',''),('5','100',4336141,'','6.1','2214',19400.00,0.00,'Payment Id 377608 for invoice:242590, receipt: 0055 by SALBAS OIL & GAS NIG. LIMITED','2021-12-16 15:52:14','',''),('5','100',4336142,'','supplier','106',0.00,19400.00,'Payment Id 377608 for invoice:242590, receipt: 0055 by SALBAS OIL & GAS NIG. LIMITED','2021-12-16 15:52:14','',''),('5','100',4336143,'','2','3236',801020.00,0.00,'Payment Id 377605 for invoice:242590, receipt: 0055 by SALBAS OIL & GAS NIG. LIMITED','2021-12-16 15:52:14','',''),('5','100',4336144,'','supplier','106',0.00,801020.00,'Payment Id 377605 for invoice:242590, receipt: 0055 by SALBAS OIL & GAS NIG. LIMITED','2021-12-16 15:52:14','',''),('5','100',4336155,'','20','2215',0.00,0.00,'Sales from shift 246333 on 2021-12-16 15:52:43 ','2021-12-16 15:52:43','',''),('5','100',4336156,'','6.1','2214',0.00,0.00,'Sales from shift 246333 on 2021-12-16 15:52:43 ','2021-12-16 15:52:43','',''),('5','100',4338503,'','24','2213',0.00,4339500.00,'Purchase Id 87377 for 26,300.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-12-16 18:05:17','',''),('5','100',4338504,'','supplier','106',4339500.00,0.00,'Purchase Id 87377 for 26,300.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-12-16 18:05:17','',''),('5','100',4342328,'','20','2215',534342.60,0.00,'Sales from shift 246637 on 2021-12-17 09:08:49 ','2021-12-17 09:08:49','',''),('5','100',4342329,'','6.1','2214',0.00,534342.60,'Sales from shift 246637 on 2021-12-17 09:08:49 ','2021-12-17 09:08:49','',''),('5','100',4353179,'','20','2215',1005689.85,0.00,'Sales from shift 246870 on 2021-12-18 06:52:49 ','2021-12-18 06:52:49','',''),('5','100',4353180,'','6.1','2214',0.00,1005689.85,'Sales from shift 246870 on 2021-12-18 06:52:49 ','2021-12-18 06:52:49','',''),('5','100',4382370,'','20','2215',1125375.90,0.00,'Sales from shift 246962 on 2021-12-20 06:12:00 ','2021-12-20 06:12:00','',''),('5','100',4382371,'','6.1','2214',0.00,1125375.90,'Sales from shift 246962 on 2021-12-20 06:12:00 ','2021-12-20 06:12:00','',''),('5','100',4394485,'','20','2215',981367.20,0.00,'Sales from shift 247476 on 2021-12-20 18:04:05 ','2021-12-20 18:04:05','',''),('5','100',4394486,'','6.1','2214',0.00,981367.20,'Sales from shift 247476 on 2021-12-20 18:04:05 ','2021-12-20 18:04:05','',''),('5','100',4394487,'','6.1','2214',12400.00,0.00,'Payment Id 378461 for invoice:246637, receipt: 0074 by SALBAS OIL & GAS NIG. LIMITED','2021-12-20 18:04:20','',''),('5','100',4394488,'','supplier','106',0.00,12400.00,'Payment Id 378461 for invoice:246637, receipt: 0074 by SALBAS OIL & GAS NIG. LIMITED','2021-12-20 18:04:20','',''),('5','100',4394489,'','2','3236',521940.00,0.00,'Payment Id 378459 for invoice:246637, receipt: 0074 by SALBAS OIL & GAS NIG. LIMITED','2021-12-20 18:04:20','',''),('5','100',4394490,'','supplier','106',0.00,521940.00,'Payment Id 378459 for invoice:246637, receipt: 0074 by SALBAS OIL & GAS NIG. LIMITED','2021-12-20 18:04:20','',''),('5','100',4404987,'','20','2215',675292.20,0.00,'Sales from shift 247611 on 2021-12-21 14:53:33 ','2021-12-21 14:53:33','',''),('5','100',4404988,'','6.1','2214',0.00,675292.20,'Sales from shift 247611 on 2021-12-21 14:53:33 ','2021-12-21 14:53:33','',''),('5','100',4419603,'','20','2215',0.00,0.00,'Sales from shift 248024 on 2021-12-22 13:00:43 ','2021-12-22 13:00:43','',''),('5','100',4419604,'','6.1','2214',0.00,0.00,'Sales from shift 248024 on 2021-12-22 13:00:43 ','2021-12-22 13:00:43','',''),('5','100',4426098,'','6.1','2214',25900.00,0.00,'Payment Id 380803 for invoice:246870, receipt: 0095 by SALBAS OIL & GAS NIG. LIMITED','2021-12-23 04:54:11','',''),('5','100',4426099,'','supplier','106',0.00,25900.00,'Payment Id 380803 for invoice:246870, receipt: 0095 by SALBAS OIL & GAS NIG. LIMITED','2021-12-23 04:54:11','',''),('5','100',4426100,'','2','3236',979790.00,0.00,'Payment Id 380802 for invoice:246870, receipt: 0095 by SALBAS OIL & GAS NIG. LIMITED','2021-12-23 04:54:11','',''),('5','100',4426101,'','supplier','106',0.00,979790.00,'Payment Id 380802 for invoice:246870, receipt: 0095 by SALBAS OIL & GAS NIG. LIMITED','2021-12-23 04:54:11','',''),('5','100',4453075,'','20','2215',0.00,0.00,'Sales from shift 248034 on 2021-12-24 14:07:59 ','2021-12-24 14:07:59','',''),('5','100',4453076,'','6.1','2214',0.00,0.00,'Sales from shift 248034 on 2021-12-24 14:07:59 ','2021-12-24 14:07:59','',''),('5','100',4472093,'','20','2215',0.00,0.00,'Sales from shift 248591 on 2021-12-26 07:25:32 ','2021-12-26 07:25:32','',''),('5','100',4472094,'','6.1','2214',0.00,0.00,'Sales from shift 248591 on 2021-12-26 07:25:32 ','2021-12-26 07:25:32','',''),('5','100',4480674,'','20','2215',0.00,0.00,'Sales from shift 248954 on 2021-12-27 05:57:08 ','2021-12-27 05:57:08','',''),('5','100',4480675,'','6.1','2214',0.00,0.00,'Sales from shift 248954 on 2021-12-27 05:57:08 ','2021-12-27 05:57:08','',''),('5','100',4499261,'','20','2215',0.00,0.00,'Sales from shift 249504 on 2021-12-28 14:40:15 ','2021-12-28 14:40:15','',''),('5','100',4499262,'','6.1','2214',0.00,0.00,'Sales from shift 249504 on 2021-12-28 14:40:15 ','2021-12-28 14:40:15','',''),('5','100',4499302,'','20','2215',0.00,0.00,'Sales from shift 249507 on 2021-12-28 14:42:45 ','2021-12-28 14:42:45','',''),('5','100',4499303,'','6.1','2214',0.00,0.00,'Sales from shift 249507 on 2021-12-28 14:42:45 ','2021-12-28 14:42:45','',''),('5','100',4499337,'','20','2215',0.00,0.00,'Sales from shift 249508 on 2021-12-28 14:44:44 ','2021-12-28 14:44:44','',''),('5','100',4499338,'','6.1','2214',0.00,0.00,'Sales from shift 249508 on 2021-12-28 14:44:44 ','2021-12-28 14:44:44','',''),('5','100',4499501,'','20','2215',0.00,0.00,'Sales from shift 249509 on 2021-12-28 14:56:27 ','2021-12-28 14:56:27','',''),('5','100',4499502,'','6.1','2214',0.00,0.00,'Sales from shift 249509 on 2021-12-28 14:56:27 ','2021-12-28 14:56:27','',''),('5','100',4555004,'','20','2215',0.00,0.00,'Sales from shift 250442 on 2022-01-02 08:05:43 ','2022-01-02 08:05:43','',''),('5','100',4555005,'','6.1','2214',0.00,0.00,'Sales from shift 250442 on 2022-01-02 08:05:43 ','2022-01-02 08:05:43','',''),('5','100',4555043,'','20','2215',0.00,0.00,'Sales from shift 250601 on 2022-01-02 08:08:14 ','2022-01-02 08:08:14','',''),('5','100',4555044,'','6.1','2214',0.00,0.00,'Sales from shift 250601 on 2022-01-02 08:08:14 ','2022-01-02 08:08:14','',''),('5','100',4555081,'','20','2215',0.00,0.00,'Sales from shift 250604 on 2022-01-02 08:10:07 ','2022-01-02 08:10:07','',''),('5','100',4555082,'','6.1','2214',0.00,0.00,'Sales from shift 250604 on 2022-01-02 08:10:07 ','2022-01-02 08:10:07','',''),('5','100',4555178,'','20','2215',0.00,0.00,'Sales from shift 250608 on 2022-01-02 08:16:55 ','2022-01-02 08:16:55','',''),('5','100',4555179,'','6.1','2214',0.00,0.00,'Sales from shift 250608 on 2022-01-02 08:16:55 ','2022-01-02 08:16:55','',''),('5','100',4569587,'','20','2215',0.00,0.00,'Sales from shift 250899 on 2022-01-03 13:03:01 ','2022-01-03 13:03:01','',''),('5','100',4569588,'','6.1','2214',0.00,0.00,'Sales from shift 250899 on 2022-01-03 13:03:01 ','2022-01-03 13:03:01','',''),('5','100',4602587,'','24','2213',0.00,6517500.00,'Purchase Id 88916 for 39,500.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-01-05 17:44:51','',''),('5','100',4602588,'','supplier','106',6517500.00,0.00,'Purchase Id 88916 for 39,500.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2022-01-05 17:44:51','',''),('5','100',4602597,'','20','2215',0.00,0.00,'Sales from shift 251230 on 2022-01-05 17:45:20 ','2022-01-05 17:45:20','',''),('5','100',4602598,'','6.1','2214',0.00,0.00,'Sales from shift 251230 on 2022-01-05 17:45:20 ','2022-01-05 17:45:20','',''),('5','100',4603114,'','20','2215',0.00,0.00,'Sales from shift 251445 on 2022-01-05 18:12:15 ','2022-01-05 18:12:15','',''),('5','100',4603115,'','6.1','2214',0.00,0.00,'Sales from shift 251445 on 2022-01-05 18:12:15 ','2022-01-05 18:12:15','',''),('5','100',4606342,'','20','2215',478184.85,0.00,'Sales from shift 251458 on 2022-01-06 09:23:58 ','2022-01-06 09:23:58','',''),('5','100',4606343,'','6.1','2214',0.00,478184.85,'Sales from shift 251458 on 2022-01-06 09:23:58 ','2022-01-06 09:23:58','',''),('5','100',4617380,'','20','2215',1154100.75,0.00,'Sales from shift 251682 on 2022-01-07 07:01:04 ','2022-01-07 07:01:04','',''),('5','100',4617381,'','6.1','2214',0.00,1154100.75,'Sales from shift 251682 on 2022-01-07 07:01:04 ','2022-01-07 07:01:04','',''),('5','100',4617382,'','6.1','2214',195100.00,0.00,'Payment Id 388695 for invoice:251458, receipt: 0015 by SALBAS OIL & GAS NIG. LIMITED','2022-01-07 07:01:25','',''),('5','100',4617383,'','supplier','106',0.00,195100.00,'Payment Id 388695 for invoice:251458, receipt: 0015 by SALBAS OIL & GAS NIG. LIMITED','2022-01-07 07:01:25','',''),('5','100',4617384,'','2','3236',283085.00,0.00,'Payment Id 388693 for invoice:251458, receipt: 0015 by SALBAS OIL & GAS NIG. LIMITED','2022-01-07 07:01:25','',''),('5','100',4617385,'','supplier','106',0.00,283085.00,'Payment Id 388693 for invoice:251458, receipt: 0015 by SALBAS OIL & GAS NIG. LIMITED','2022-01-07 07:01:25','',''),('5','100',4617386,'','6.1','2214',11900.00,0.00,'Payment Id 388691 for invoice:247611, receipt: 0034 by SALBAS OIL & GAS NIG. LIMITED','2022-01-07 07:01:25','',''),('5','100',4617387,'','supplier','106',0.00,11900.00,'Payment Id 388691 for invoice:247611, receipt: 0034 by SALBAS OIL & GAS NIG. LIMITED','2022-01-07 07:01:25','',''),('5','100',4617388,'','2','3236',663390.00,0.00,'Payment Id 388689 for invoice:247611, receipt: 0034 by SALBAS OIL & GAS NIG. LIMITED','2022-01-07 07:01:25','',''),('5','100',4617389,'','supplier','106',0.00,663390.00,'Payment Id 388689 for invoice:247611, receipt: 0034 by SALBAS OIL & GAS NIG. LIMITED','2022-01-07 07:01:25','',''),('5','100',4617390,'','6.1','2214',9400.00,0.00,'Payment Id 388688 for invoice:247476, receipt: 0096 by SALBAS OIL & GAS NIG. LIMITED','2022-01-07 07:01:25','',''),('5','100',4617391,'','supplier','106',0.00,9400.00,'Payment Id 388688 for invoice:247476, receipt: 0096 by SALBAS OIL & GAS NIG. LIMITED','2022-01-07 07:01:25','',''),('5','100',4617392,'','2','3236',971965.00,0.00,'Payment Id 388687 for invoice:247476, receipt: 0096 by SALBAS OIL & GAS NIG. LIMITED','2022-01-07 07:01:25','',''),('5','100',4617393,'','supplier','106',0.00,971965.00,'Payment Id 388687 for invoice:247476, receipt: 0096 by SALBAS OIL & GAS NIG. LIMITED','2022-01-07 07:01:25','',''),('5','100',4617394,'','6.1','2214',9400.00,0.00,'Payment Id 388685 for invoice:246962, receipt: 0098 by SALBAS OIL & GAS NIG. LIMITED','2022-01-07 07:01:25','',''),('5','100',4617395,'','supplier','106',0.00,9400.00,'Payment Id 388685 for invoice:246962, receipt: 0098 by SALBAS OIL & GAS NIG. LIMITED','2022-01-07 07:01:25','',''),('5','100',4617396,'','2','3236',1115975.00,0.00,'Payment Id 388684 for invoice:246962, receipt: 0098 by SALBAS OIL & GAS NIG. LIMITED','2022-01-07 07:01:25','',''),('5','100',4617397,'','supplier','106',0.00,1115975.00,'Payment Id 388684 for invoice:246962, receipt: 0098 by SALBAS OIL & GAS NIG. LIMITED','2022-01-07 07:01:25','',''),('5','100',4630827,'','6.1','2214',9400.00,0.00,'Payment Id 389178 for invoice:251682, receipt: 0048 by SALBAS OIL & GAS NIG. LIMITED','2022-01-08 08:06:54','',''),('5','100',4630828,'','supplier','106',0.00,9400.00,'Payment Id 389178 for invoice:251682, receipt: 0048 by SALBAS OIL & GAS NIG. LIMITED','2022-01-08 08:06:54','',''),('5','100',4630829,'','2','3236',1144700.00,0.00,'Payment Id 389177 for invoice:251682, receipt: 0048 by SALBAS OIL & GAS NIG. LIMITED','2022-01-08 08:06:54','',''),('5','100',4630830,'','supplier','106',0.00,1144700.00,'Payment Id 389177 for invoice:251682, receipt: 0048 by SALBAS OIL & GAS NIG. LIMITED','2022-01-08 08:06:54','',''),('5','100',4654046,'','20','2215',1162274.85,0.00,'Sales from shift 251898 on 2022-01-09 15:48:49 ','2022-01-09 15:48:49','',''),('5','100',4654047,'','6.1','2214',0.00,1162274.85,'Sales from shift 251898 on 2022-01-09 15:48:49 ','2022-01-09 15:48:49','',''),('5','100',4658188,'','20','2215',1361518.95,0.00,'Sales from shift 252381 on 2022-01-10 08:25:11 ','2022-01-10 08:25:11','',''),('5','100',4658189,'','6.1','2214',0.00,1361518.95,'Sales from shift 252381 on 2022-01-10 08:25:11 ','2022-01-10 08:25:11','',''),('5','100',4660602,'','20','2215',984751.35,0.00,'Sales from shift 252545 on 2022-01-10 10:44:52 ','2022-01-10 10:44:52','',''),('5','100',4660603,'','6.1','2214',0.00,984751.35,'Sales from shift 252545 on 2022-01-10 10:44:52 ','2022-01-10 10:44:52','',''),('5','100',4672066,'','20','2215',999939.60,0.00,'Sales from shift 252675 on 2022-01-11 08:18:35 ','2022-01-11 08:18:35','',''),('5','100',4672067,'','6.1','2214',0.00,999939.60,'Sales from shift 252675 on 2022-01-11 08:18:35 ','2022-01-11 08:18:35','',''),('5','100',4673654,'','6.1','2214',9400.00,0.00,'Payment Id 390909 for invoice:252545, receipt: 0050 by SALBAS OIL & GAS NIG. LIMITED','2022-01-11 09:42:42','',''),('5','100',4673655,'','supplier','106',0.00,9400.00,'Payment Id 390909 for invoice:252545, receipt: 0050 by SALBAS OIL & GAS NIG. LIMITED','2022-01-11 09:42:42','',''),('5','100',4673656,'','2','3236',975350.00,0.00,'Payment Id 390906 for invoice:252545, receipt: 0050 by SALBAS OIL & GAS NIG. LIMITED','2022-01-11 09:42:42','',''),('5','100',4673657,'','supplier','106',0.00,975350.00,'Payment Id 390906 for invoice:252545, receipt: 0050 by SALBAS OIL & GAS NIG. LIMITED','2022-01-11 09:42:42','',''),('5','100',4673658,'','6.1','2214',29400.00,0.00,'Payment Id 390904 for invoice:252381, receipt: 0051 by SALBAS OIL & GAS NIG. LIMITED','2022-01-11 09:42:42','',''),('5','100',4673659,'','supplier','106',0.00,29400.00,'Payment Id 390904 for invoice:252381, receipt: 0051 by SALBAS OIL & GAS NIG. LIMITED','2022-01-11 09:42:42','',''),('5','100',4673660,'','2','3236',1032875.00,0.00,'Payment Id 390902 for invoice:252381, receipt: 0051 by SALBAS OIL & GAS NIG. LIMITED','2022-01-11 09:42:42','',''),('5','100',4673661,'','supplier','106',0.00,1032875.00,'Payment Id 390902 for invoice:252381, receipt: 0051 by SALBAS OIL & GAS NIG. LIMITED','2022-01-11 09:42:42','',''),('5','100',4673662,'','6.1','2214',129400.00,0.00,'Payment Id 390898 for invoice:251898, receipt: 0049 by SALBAS OIL & GAS NIG. LIMITED','2022-01-11 09:42:42','',''),('5','100',4673663,'','supplier','106',0.00,129400.00,'Payment Id 390898 for invoice:251898, receipt: 0049 by SALBAS OIL & GAS NIG. LIMITED','2022-01-11 09:42:42','',''),('5','100',4673664,'','2','3236',1332120.00,0.00,'Payment Id 390897 for invoice:251898, receipt: 0049 by SALBAS OIL & GAS NIG. LIMITED','2022-01-11 09:42:42','',''),('5','100',4673665,'','supplier','106',0.00,1332120.00,'Payment Id 390897 for invoice:251898, receipt: 0049 by SALBAS OIL & GAS NIG. LIMITED','2022-01-11 09:42:42','',''),('5','100',4686682,'','20','2215',409437.60,0.00,'Sales from shift 252755 on 2022-01-12 08:11:59 ','2022-01-12 08:11:59','',''),('5','100',4686683,'','6.1','2214',0.00,409437.60,'Sales from shift 252755 on 2022-01-12 08:11:59 ','2022-01-12 08:11:59','',''),('5','100',4686690,'','6.1','2214',19400.00,0.00,'Payment Id 391391 for invoice:252675, receipt: 0034 by SALBAS OIL & GAS NIG. LIMITED','2022-01-12 08:12:18','',''),('5','100',4686691,'','supplier','106',0.00,19400.00,'Payment Id 391391 for invoice:252675, receipt: 0034 by SALBAS OIL & GAS NIG. LIMITED','2022-01-12 08:12:18','',''),('5','100',4686692,'','2','3236',980540.00,0.00,'Payment Id 391390 for invoice:252675, receipt: 0034 by SALBAS OIL & GAS NIG. LIMITED','2022-01-12 08:12:18','',''),('5','100',4686693,'','supplier','106',0.00,980540.00,'Payment Id 391390 for invoice:252675, receipt: 0034 by SALBAS OIL & GAS NIG. LIMITED','2022-01-12 08:12:18','',''),('5','100',4704149,'','20','2215',0.00,0.00,'Sales from shift 253290 on 2022-01-13 10:31:45 ','2022-01-13 10:31:45','',''),('5','100',4704150,'','6.1','2214',0.00,0.00,'Sales from shift 253290 on 2022-01-13 10:31:45 ','2022-01-13 10:31:45','',''),('5','100',4704523,'','6.1','2214',11900.00,0.00,'Payment Id 392208 for invoice:252755, receipt: 0125416 by SALBAS OIL & GAS NIG. LIMITED','2022-01-13 10:45:11','',''),('5','100',4704524,'','supplier','106',0.00,11900.00,'Payment Id 392208 for invoice:252755, receipt: 0125416 by SALBAS OIL & GAS NIG. LIMITED','2022-01-13 10:45:11','',''),('5','100',4704525,'','2','3236',397540.00,0.00,'Payment Id 392206 for invoice:252755, receipt: 0125416 by SALBAS OIL & GAS NIG. LIMITED','2022-01-13 10:45:11','',''),('5','100',4704526,'','supplier','106',0.00,397540.00,'Payment Id 392206 for invoice:252755, receipt: 0125416 by SALBAS OIL & GAS NIG. LIMITED','2022-01-13 10:45:11','',''),('5','100',4714238,'','20','2215',0.00,0.00,'Sales from shift 253292 on 2022-01-14 06:36:31 ','2022-01-14 06:36:31','',''),('5','100',4714239,'','6.1','2214',0.00,0.00,'Sales from shift 253292 on 2022-01-14 06:36:31 ','2022-01-14 06:36:31','',''),('5','100',4729790,'','20','2215',0.00,0.00,'Sales from shift 253579 on 2022-01-15 09:06:38 ','2022-01-15 09:06:38','',''),('5','100',4729791,'','6.1','2214',0.00,0.00,'Sales from shift 253579 on 2022-01-15 09:06:38 ','2022-01-15 09:06:38','',''),('5','100',4743796,'','20','2215',0.00,0.00,'Sales from shift 253911 on 2022-01-16 06:38:21 ','2022-01-16 06:38:21','',''),('5','100',4743797,'','6.1','2214',0.00,0.00,'Sales from shift 253911 on 2022-01-16 06:38:21 ','2022-01-16 06:38:21','',''),('5','100',4758255,'','20','2215',0.00,0.00,'Sales from shift 254050 on 2022-01-17 08:01:14 ','2022-01-17 08:01:14','',''),('5','100',4758256,'','6.1','2214',0.00,0.00,'Sales from shift 254050 on 2022-01-17 08:01:14 ','2022-01-17 08:01:14','',''),('5','100',4770983,'','20','2215',0.00,0.00,'Sales from shift 254312 on 2022-01-18 07:06:27 ','2022-01-18 07:06:27','',''),('5','100',4770984,'','6.1','2214',0.00,0.00,'Sales from shift 254312 on 2022-01-18 07:06:27 ','2022-01-18 07:06:27','',''),('5','100',4785275,'','20','2215',0.00,0.00,'Sales from shift 254526 on 2022-01-19 06:02:45 ','2022-01-19 06:02:45','',''),('5','100',4785276,'','6.1','2214',0.00,0.00,'Sales from shift 254526 on 2022-01-19 06:02:45 ','2022-01-19 06:02:45','',''),('5','100',4800691,'','20','2215',0.00,0.00,'Sales from shift 254776 on 2022-01-20 06:33:12 ','2022-01-20 06:33:12','',''),('5','100',4800692,'','6.1','2214',0.00,0.00,'Sales from shift 254776 on 2022-01-20 06:33:12 ','2022-01-20 06:33:12','',''),('5','100',4820434,'','20','2215',0.00,0.00,'Sales from shift 255063 on 2022-01-21 11:15:10 ','2022-01-21 11:15:10','',''),('5','100',4820435,'','6.1','2214',0.00,0.00,'Sales from shift 255063 on 2022-01-21 11:15:10 ','2022-01-21 11:15:10','',''),('5','100',4831316,'','20','2215',0.00,0.00,'Sales from shift 255424 on 2022-01-21 22:35:13 ','2022-01-21 22:35:13','',''),('5','100',4831317,'','6.1','2214',0.00,0.00,'Sales from shift 255424 on 2022-01-21 22:35:13 ','2022-01-21 22:35:13','',''),('5','100',4846971,'','20','2215',0.00,0.00,'Sales from shift 255682 on 2022-01-23 07:27:54 ','2022-01-23 07:27:54','',''),('5','100',4846972,'','6.1','2214',0.00,0.00,'Sales from shift 255682 on 2022-01-23 07:27:54 ','2022-01-23 07:27:54','',''),('5','100',4860457,'','20','2215',0.00,0.00,'Sales from shift 255878 on 2022-01-24 07:29:51 ','2022-01-24 07:29:51','',''),('5','100',4860458,'','6.1','2214',0.00,0.00,'Sales from shift 255878 on 2022-01-24 07:29:51 ','2022-01-24 07:29:51','',''),('5','100',4897784,'','20','2215',0.00,0.00,'Sales from shift 256605 on 2022-01-26 13:53:01 ','2022-01-26 13:53:01','',''),('5','100',4897785,'','6.1','2214',0.00,0.00,'Sales from shift 256605 on 2022-01-26 13:53:01 ','2022-01-26 13:53:01','',''),('5','100',4897827,'','20','2215',0.00,0.00,'Sales from shift 256607 on 2022-01-26 13:55:33 ','2022-01-26 13:55:33','',''),('5','100',4897828,'','6.1','2214',0.00,0.00,'Sales from shift 256607 on 2022-01-26 13:55:33 ','2022-01-26 13:55:33','',''),('5','100',4903971,'','20','2215',0.00,0.00,'Sales from shift 256608 on 2022-01-27 07:06:23 ','2022-01-27 07:06:23','',''),('5','100',4903972,'','6.1','2214',0.00,0.00,'Sales from shift 256608 on 2022-01-27 07:06:23 ','2022-01-27 07:06:23','',''),('5','100',4903973,'','20','2215',0.00,0.00,'Sales from shift 256609 on 2022-01-31 13:24:59 ','2022-01-31 13:24:59','',''),('5','100',4903974,'','6.1','2214',0.00,0.00,'Sales from shift 256609 on 2022-01-31 13:24:59 ','2022-01-31 13:24:59','',''),('5','100',4903975,'','20','2215',0.00,0.00,'Sales from shift 256610 on 2022-01-31 13:26:59 ','2022-01-31 13:26:59','',''),('5','100',4903976,'','6.1','2214',0.00,0.00,'Sales from shift 256610 on 2022-01-31 13:26:59 ','2022-01-31 13:26:59','',''),('5','100',4903977,'','20','2215',0.00,0.00,'Sales from shift 256611 on 2022-01-31 13:30:29 ','2022-01-31 13:30:29','',''),('5','100',4903978,'','6.1','2214',0.00,0.00,'Sales from shift 256611 on 2022-01-31 13:30:29 ','2022-01-31 13:30:29','',''),('5','100',4903979,'','20','2215',0.00,0.00,'Sales from shift 256612 on 2022-01-31 13:33:48 ','2022-01-31 13:33:48','',''),('5','100',4903980,'','6.1','2214',0.00,0.00,'Sales from shift 256612 on 2022-01-31 13:33:48 ','2022-01-31 13:33:48','',''),('5','100',4903981,'','20','2215',0.00,0.00,'Sales from shift 256613 on 2022-02-02 19:20:29 ','2022-02-02 19:20:29','',''),('5','100',4903982,'','6.1','2214',0.00,0.00,'Sales from shift 256613 on 2022-02-02 19:20:29 ','2022-02-02 19:20:29','',''),('5','100',4903983,'','20','2215',0.00,0.00,'Sales from shift 256614 on 2022-02-03 14:43:57 ','2022-02-03 14:43:57','',''),('5','100',4903984,'','6.1','2214',0.00,0.00,'Sales from shift 256614 on 2022-02-03 14:43:57 ','2022-02-03 14:43:57','','');
/*!40000 ALTER TABLE `ledgers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products`
--

DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `measurement` varchar(20) NOT NULL,
  `quantity2` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`code`,`name`,`measurement`,`quantity2`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `cleanup` (`cleanup`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB AUTO_INCREMENT=249 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products`
--

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (246,'5','100','PMS','Petrol','Litres',1,165.00,165.00,165.00,165.00,0.00,0,'2019-02-23 18:43:15','414','414','2019-02-23 18:43:15',1),(247,'5','100','AGO','Diesel','Litres',1,300.00,300.00,300.00,300.00,0.00,0,'2019-02-23 18:43:43','414','414','2019-02-23 18:43:43',1),(248,'5','100','DPK','Kerosene','Litres',1,0.00,0.00,0.00,0.00,0.00,0,'2019-02-23 18:44:15','414','414','2019-02-23 18:44:15',1);
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_changevalues`
--

DROP TABLE IF EXISTS `products_changevalues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_changevalues` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `change_id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity` bigint NOT NULL,
  `oldrate` decimal(20,2) NOT NULL,
  `newrate` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`change_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_changevalues`
--

LOCK TABLES `products_changevalues` WRITE;
/*!40000 ALTER TABLE `products_changevalues` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_changevalues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_prices`
--

DROP TABLE IF EXISTS `products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB AUTO_INCREMENT=16653 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_prices`
--

LOCK TABLES `products_prices` WRITE;
/*!40000 ALTER TABLE `products_prices` DISABLE KEYS */;
INSERT INTO `products_prices` VALUES (7192,'5','100',246,143.00,143.00,0.00,143.00,'','2019-12-17 12:19:02','414'),(7193,'5','100',247,220.00,220.00,0.00,220.00,'','2019-12-17 12:19:26','414'),(7420,'5','100',247,230.00,220.00,0.00,0.00,'Cost from purchase id #43478','2020-02-03 10:48:50','414'),(7421,'5','100',246,140.00,143.00,0.00,0.00,'Cost from purchase id #36691','2020-02-03 11:14:55','437'),(7449,'5','100',247,225.00,225.00,0.00,225.00,'','2020-02-05 11:54:34','414'),(7461,'5','100',246,143.00,143.00,0.00,0.00,'Cost from purchase id #43633','2020-02-06 12:57:44','437'),(12549,'5','100',246,163.00,143.00,0.00,0.00,'Cost from purchase id #62789','2021-03-03 16:03:13','414'),(12558,'5','100',246,170.00,143.00,0.00,0.00,'Cost from purchase id #62855','2021-03-04 11:40:39','600'),(12778,'5','100',246,163.00,143.00,0.00,0.00,'Cost from purchase id #63519','2021-03-14 09:05:55','605'),(13217,'5','100',247,265.00,225.00,0.00,0.00,'Cost from purchase id #65726','2021-04-08 19:51:49','605'),(13350,'5','100',246,165.00,143.00,0.00,0.00,'Cost from purchase id #66282','2021-04-16 12:00:57','605'),(13856,'5','100',247,275.00,275.00,275.00,275.00,'NEW AGO PRICE','2021-06-07 09:18:35','600'),(14071,'5','100',247,280.00,280.00,280.00,280.00,'NEW AGO PRICE','2021-06-22 10:58:19','414'),(14072,'5','100',246,165.00,165.00,165.00,165.00,'NEW PMS PRICE','2021-06-22 11:00:04','414'),(14116,'5','100',247,290.00,290.00,290.00,290.00,'AGO  NEW PRICE','2021-06-24 10:15:53','414'),(15354,'5','100',246,163.00,165.00,0.00,0.00,'Cost from purchase id #76615','2021-09-18 19:51:28','664'),(15610,'5','100',247,300.00,300.00,300.00,300.00,'AGO NEW PRICE','2021-09-29 08:58:25','600'),(16652,'5','100',246,165.00,165.00,0.00,0.00,'Cost from purchase id #79500','2021-10-31 19:19:59','664');
/*!40000 ALTER TABLE `products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_reconciliations`
--

DROP TABLE IF EXISTS `products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_reconciliations`
--

LOCK TABLES `products_reconciliations` WRITE;
/*!40000 ALTER TABLE `products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_shortages`
--

DROP TABLE IF EXISTS `products_shortages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_shortages` (
  `shortage_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shortagedate` date NOT NULL,
  `product_id` varchar(10) NOT NULL,
  `type` int NOT NULL DEFAULT '0',
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`shortage_id`),
  KEY `companycode` (`company_id`,`shortagedate`,`product_id`,`rate`,`quantity`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_shortages`
--

LOCK TABLES `products_shortages` WRITE;
/*!40000 ALTER TABLE `products_shortages` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_shortages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pts_nozzles`
--

DROP TABLE IF EXISTS `pts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pts_nozzles` (
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pts_id` int NOT NULL,
  `pump` varchar(20) NOT NULL,
  `code` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `last_volume` decimal(20,2) NOT NULL,
  `last_price` decimal(20,2) NOT NULL,
  `last_amount` decimal(20,2) NOT NULL,
  `last_transaction` int NOT NULL DEFAULT '0',
  `total_volume` decimal(20,2) NOT NULL,
  `total_amount` decimal(20,2) NOT NULL,
  `total_transactions` decimal(20,2) NOT NULL,
  `lastconnect` datetime NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `terminal_id` (`pts_id`,`pump`,`code`,`lastconnect`),
  KEY `companycode` (`company_id`,`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pts_nozzles`
--

LOCK TABLES `pts_nozzles` WRITE;
/*!40000 ALTER TABLE `pts_nozzles` DISABLE KEYS */;
/*!40000 ALTER TABLE `pts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases`
--

DROP TABLE IF EXISTS `purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=88918 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases`
--

LOCK TABLES `purchases` WRITE;
/*!40000 ALTER TABLE `purchases` DISABLE KEYS */;
INSERT INTO `purchases` VALUES (78178,'5','100','2021-10-01',246,106,163.00,650.00,0.00,0.00,105950.00,0.00,'','NIL','NIL','','','','2021-10-13 09:04:58',15,'','600','','0000-00-00 00:00:00','600','2021-10-13 09:06:59'),(78179,'5','100','2021-10-01',247,106,300.00,100.00,0.00,0.00,30000.00,0.00,'','NIL','NIL','','','','2021-10-13 09:05:19',15,'','600','','0000-00-00 00:00:00','600','2021-10-13 09:05:34'),(78248,'5','100','2021-10-02',246,106,163.00,29900.00,0.00,0.00,4873700.00,0.00,'','1654','KMA 901 ZE','','','','2021-10-13 17:09:25',15,'','414','','0000-00-00 00:00:00','664','2021-10-13 17:10:51'),(78391,'5','100','2021-10-15',246,106,163.00,20000.00,0.00,0.00,3260000.00,0.00,'','2206','RAN 554 XA','','','','2021-10-15 19:46:47',15,'','414','','0000-00-00 00:00:00','664','2021-10-15 20:01:34'),(78631,'5','100','2021-10-19',246,106,163.00,30000.00,0.00,0.00,4890000.00,0.00,'','2212','LSD 602 XY','','','','2021-10-19 08:57:34',15,'','414','','0000-00-00 00:00:00','664','2021-10-19 10:51:59'),(78858,'5','100','2021-10-15',246,106,163.00,4000.00,0.00,0.00,652000.00,0.00,'','2206','RAN 554 XA','','','','2021-10-21 18:38:53',15,'','414','','0000-00-00 00:00:00','664','2021-10-21 18:52:42'),(79001,'5','100','2021-10-15',246,106,163.00,661.00,0.00,0.00,107743.00,0.00,'','2206','RAN 554 XA','','','','2021-10-24 06:43:03',15,'','414','','0000-00-00 00:00:00','664','2021-10-24 06:47:44'),(79500,'5','100','2021-10-31',246,106,165.00,30000.00,0.00,0.00,4950000.00,0.00,'','0339','LSD 602 XY','','','','2021-10-31 19:18:55',15,'','414','','0000-00-00 00:00:00','664','2021-10-31 19:19:59'),(80382,'5','100','2021-11-12',246,106,165.00,14900.00,0.00,0.00,2458500.00,0.00,'','2219','LSD 602 XY','','','','2021-11-12 12:08:14',15,'','414','','0000-00-00 00:00:00','664','2021-11-12 12:13:57'),(85464,'5','100','2021-11-23',246,106,165.00,45000.00,0.00,0.00,7425000.00,0.00,'','2221','DKA 771 ZU','','','','2021-11-23 09:22:03',15,'','414','','0000-00-00 00:00:00','664','2021-11-23 09:26:52'),(87265,'5','100','2021-12-03',246,106,165.00,45000.00,0.00,0.00,7425000.00,0.00,'','0228','KMC 39 XX','','','','2021-12-15 10:58:36',15,'','414','','0000-00-00 00:00:00','664','2021-12-15 10:59:22'),(87377,'5','100','2021-12-16',246,106,165.00,26300.00,0.00,0.00,4339500.00,0.00,'','1255','GWL 66 YJ','','','','2021-12-16 17:57:32',15,'','414','','0000-00-00 00:00:00','664','2021-12-16 18:05:17'),(88916,'5','100','2022-01-05',246,106,165.00,39500.00,0.00,0.00,6517500.00,0.00,'','2074','KMC 146 YT','','','','2022-01-05 17:32:37',15,'','414','','0000-00-00 00:00:00','664','2022-01-05 17:44:51'),(88917,'5','100','2022-04-09',246,106,165.00,30000.00,0.00,0.00,4950000.00,0.00,'','2095','NSR 70 YC','','','','2022-04-10 07:40:08',0,'','414','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_payments`
--

DROP TABLE IF EXISTS `purchases_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `supplier_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`supplier_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=392209 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_payments`
--

LOCK TABLES `purchases_payments` WRITE;
/*!40000 ALTER TABLE `purchases_payments` DISABLE KEYS */;
INSERT INTO `purchases_payments` VALUES (347705,'5','100','2021-10-03',106,'0099','','5',377410.00,'231327','','','3236','tashar yari 019','0099',386239.91,'2021-10-20 16:15:20',5,'AGO FOR GEN = 6,000\r\nTRANSPORT = 2,500\r\n\r\nTOTAL = 8,500','414','','0000-00-00 00:00:00','664','2021-10-20 16:17:36'),(347706,'5','100','2021-10-03',106,'0099','','2',8500.00,'231327','','','','','',0.00,'2021-10-20 16:16:27',5,'','414','','0000-00-00 00:00:00','664','2021-10-20 16:17:36'),(347713,'5','100','2021-10-04',106,'01143466','','5',564860.00,'231328','','','3236','tashar yari 019','01143466',594060.02,'2021-10-20 16:20:29',5,'AGO FOR GEN = 6,000\r\nTRANSPORT = 2,500\r\nGEN OIL = 9,000\r\nSTATION EXPENSES = 11,700\r\n\r\nTOTAL = 29,200','414','','0000-00-00 00:00:00','664','2021-10-20 16:23:00'),(347715,'5','100','2021-10-04',106,'01143466','','2',29200.00,'231328','','','','','',0.00,'2021-10-20 16:21:28',5,'','414','','0000-00-00 00:00:00','664','2021-10-20 16:22:59'),(347716,'5','100','2021-10-05',106,'0061','','5',843920.00,'231330','','','3236','tashar yari 019','0061',852520.97,'2021-10-20 16:23:31',5,'AGO FOR GEN = 6,200\r\nTRANSPORT = 2,500\r\n\r\nTOTAL = 8,700','414','','0000-00-00 00:00:00','664','2021-10-20 16:24:44'),(347717,'5','100','2021-10-05',106,'0061','','2',8700.00,'231330','','','','','',0.00,'2021-10-20 16:24:19',5,'','414','','0000-00-00 00:00:00','664','2021-10-20 16:24:44'),(347718,'5','100','2021-10-06',106,'0055','','5',844325.00,'231332','','','3236','tashar yari 019','0055',857696.22,'2021-10-20 16:28:21',5,'AGO FOR GEN = 6,200\r\nTRANSPORT = 2,500\r\nPOLICE PMS = 5000\r\n\r\nTOTAL = 13,700','414','','0000-00-00 00:00:00','664','2021-10-20 16:53:20'),(347719,'5','100','2021-10-06',106,'0055','','2',13700.00,'231332','','','','','',0.00,'2021-10-20 16:29:05',5,'','414','','0000-00-00 00:00:00','664','2021-10-20 16:53:20'),(347720,'5','100','2021-10-07',106,'0038','','5',566975.00,'231334','','','3236','tashar yari 019','0038',575675.25,'2021-10-20 16:30:55',5,'AGO FOR GEN = 6,200\r\nTRANSPORT = 2,500\r\n\r\nTOTAL 8,700','414','','0000-00-00 00:00:00','664','2021-10-20 16:53:20'),(347721,'5','100','2021-10-07',106,'0038','','2',8700.00,'231334','','','','','',0.00,'2021-10-20 16:31:41',5,'','414','','0000-00-00 00:00:00','664','2021-10-20 16:53:20'),(347722,'5','100','2021-10-08',106,'0055','','5',608385.00,'231335','','','3236','tashar yari 019','0055',619077.26,'2021-10-20 16:33:46',5,'AGO FOR GEN = 6,200\r\nTRANSPORT = 2,500\r\nGEN BELT = 2,000\r\n\r\nTOTAL = 10,700','414','','0000-00-00 00:00:00','664','2021-10-20 16:53:20'),(347723,'5','100','2021-10-08',106,'0055','','2',10700.00,'231335','','','','','',0.00,'2021-10-20 16:34:31',5,'','414','','0000-00-00 00:00:00','664','2021-10-20 16:53:20'),(347730,'5','100','2021-10-09',106,'0054','','5',669310.00,'231336','','','3236','tashar yari 019','0054',678018.06,'2021-10-20 16:42:32',5,'AGO FOR GEN = 6,200\r\nTRANSPORT = 2,500\r\n\r\nTOTAL = 8,700','414','','0000-00-00 00:00:00','664','2021-10-20 16:53:20'),(347732,'5','100','2021-10-09',106,'0054','','2',8700.00,'231336','','','','','',0.00,'2021-10-20 16:43:15',5,'','414','','0000-00-00 00:00:00','664','2021-10-20 16:53:20'),(347734,'5','100','2021-10-10',106,'0056','','5',308730.00,'231339','','','3236','tashar yari 019','0056',319990.19,'2021-10-20 16:46:18',5,'AG0 FOR GEN = 6,200\r\nTRANSPORT = 5,000\r\n\r\nTOTAL = 11,200','414','','0000-00-00 00:00:00','664','2021-10-20 16:53:19'),(347735,'5','100','2021-10-10',106,'0056','','2',11200.00,'231339','','','','','',0.00,'2021-10-20 16:47:14',5,'','414','','0000-00-00 00:00:00','664','2021-10-20 16:53:19'),(348244,'5','100','2021-10-15',106,'0039','','5',307125.00,'231715','','','3236','tashar yari 019','0039',511024.56,'2021-10-21 14:25:11',5,'AGO FOR GEN = 6,400\r\nTRANSPORT = 2,500\r\nSALARY FOR SEPT = 195,000\r\n\r\nTOTAL = 203,900','414','','0000-00-00 00:00:00','664','2021-10-21 14:45:12'),(348245,'5','100','2021-10-15',106,'0039','','2',203900.00,'231715','','','','','',0.00,'2021-10-21 14:26:10',5,'','414','','0000-00-00 00:00:00','664','2021-10-21 14:45:12'),(348247,'5','100','2021-10-16',106,'0035','','5',625420.00,'232063','','','3236','tashar yari 019','0035',634321.02,'2021-10-21 14:28:07',5,'AGO FOR GEN = 6,400\r\nTRANSPORT = 2,500\r\n\r\nTOTAL = 8,900','414','','0000-00-00 00:00:00','664','2021-10-21 14:45:12'),(348249,'5','100','2021-10-16',106,'0035','','2',8900.00,'232063','','','','','',0.00,'2021-10-21 14:28:51',5,'','414','','0000-00-00 00:00:00','664','2021-10-21 14:45:12'),(348251,'5','100','2021-10-17',106,'0038','','5',479975.00,'232329','','','3236','tashar yari 019','0038',488877.75,'2021-10-21 14:30:38',5,'AGO FOR GEN = 6,400\r\nTRANSPORT = 2,500\r\n\r\nTOTAL 8,900','414','','0000-00-00 00:00:00','664','2021-10-21 14:45:12'),(348252,'5','100','2021-10-17',106,'0038','','2',8900.00,'232329','','','','','',0.00,'2021-10-21 14:31:26',5,'','414','','0000-00-00 00:00:00','664','2021-10-21 14:45:12'),(348253,'5','100','2021-10-18',106,'0079','','5',521740.00,'232373','','','3236','tashar yari 019','0079',530780.16,'2021-10-21 14:33:33',5,'AGO FOR GEN = 6,540\r\nTRANSPORT = 2,500\r\n\r\nTOTAL = 9,040','414','','0000-00-00 00:00:00','664','2021-10-21 14:45:12'),(348254,'5','100','2021-10-18',106,'0079','','2',9040.00,'232373','','','','','',0.00,'2021-10-21 14:34:19',5,'','414','','0000-00-00 00:00:00','664','2021-10-21 14:45:12'),(348258,'5','100','2021-10-19',106,'0080','','5',552180.00,'232653','','','3236','tashar yari 019','0080',0.00,'2021-10-21 14:36:38',5,'AGO FOR GEN = 6,540\r\nTRANSPORT = 2,500\r\nGEN OIL = 3,000\r\n\r\nTOTAL = 12,040','414','','0000-00-00 00:00:00','664','2021-10-21 14:45:12'),(348260,'5','100','2021-10-19',106,'0080','','2',12040.00,'232653','','','','','',0.00,'2021-10-21 14:37:30',5,'','414','','0000-00-00 00:00:00','664','2021-10-21 14:45:12'),(348262,'5','100','2021-10-20',106,'0050','','5',731960.00,'232900','','','3236','tashar yari 019','0050',781060.14,'2021-10-21 14:40:21',5,'AGO FOR GEN = 6,600\r\nTRANSPORT = 2,500\r\nMAKARFI REVENUE = 40,000\r\n\r\nTOTAL = 49,100','414','','0000-00-00 00:00:00','664','2021-10-21 14:45:12'),(348264,'5','100','2021-10-20',106,'0050','','2',49100.00,'232900','','','','','',0.00,'2021-10-21 14:41:09',5,'','414','','0000-00-00 00:00:00','664','2021-10-21 14:45:12'),(348806,'5','100','2021-10-21',106,'0076','','5',928770.00,'233147','','','3236','tashar yari 019','0076',938172.58,'2021-10-22 13:16:39',5,'\r\nAGO FOR GEN = 6,900\r\nTRANSPORT = 2,500\r\n\r\nTOTAL = 9,400','414','','0000-00-00 00:00:00','664','2021-10-23 06:42:14'),(348807,'5','100','2021-10-21',106,'0076','','2',9400.00,'233147','','','','','',0.00,'2021-10-22 13:17:31',5,'','414','','0000-00-00 00:00:00','664','2021-10-23 06:42:14'),(350359,'5','100','2021-10-22',106,'0047','','5',865470.00,'233434','','','3236','tashar yari 019','0047',874869.90,'2021-10-25 13:08:28',5,'AGO FOR GEN = 6,900\r\nTRANSPORT = 2,500\r\n\r\nTOTAL = 9,400','414','','0000-00-00 00:00:00','664','2021-10-25 13:13:50'),(350360,'5','100','2021-10-22',106,'0047','','2',9400.00,'233434','','','','','',0.00,'2021-10-25 13:09:17',5,'','414','','0000-00-00 00:00:00','664','2021-10-25 13:13:50'),(350362,'5','100','2021-10-23',106,'0048','','5',988910.00,'233723','','','3236','tashar yari 019','0048',998309.80,'2021-10-25 13:11:12',5,'AGO FOR GEN = 6,900\r\nTRANSPORT = 2,500\r\n\r\nTOTAL = 9,400','414','','0000-00-00 00:00:00','664','2021-10-25 13:13:50'),(350364,'5','100','2021-10-23',106,'0048','','2',9400.00,'233723','','','','','',0.00,'2021-10-25 13:11:54',5,'','414','','0000-00-00 00:00:00','664','2021-10-25 13:13:50'),(350416,'5','100','2021-10-24',106,'0049','','5',589690.00,'234209','','','3236','tashar yari 019','0049',599091.83,'2021-10-25 13:50:48',5,'AGO FOR GEN = 6,900\r\nTRANSPORT = 2,500\r\n\r\nTOTAL = 9,400','414','','0000-00-00 00:00:00','664','2021-10-26 06:11:05'),(350417,'5','100','2021-10-24',106,'0049','','2',9400.00,'234209','','','','','',0.00,'2021-10-25 13:51:23',5,'','414','','0000-00-00 00:00:00','664','2021-10-26 06:11:05'),(350976,'5','100','2021-10-25',106,'0069','','5',745265.00,'234343','','','3236','tashar yari 019','0069',754665.55,'2021-10-26 14:42:49',5,'AGO FOR GEN = 6,900\r\nTRANSPORT = 2,500\r\n\r\nTOTAL = 9,400','414','','0000-00-00 00:00:00','664','2021-10-26 15:26:52'),(350977,'5','100','2021-10-25',106,'0069','','2',9400.00,'234343','','','','','',0.00,'2021-10-26 14:43:29',5,'','414','','0000-00-00 00:00:00','664','2021-10-26 15:26:52'),(351469,'5','100','2021-10-26',106,'0090','','5',679775.00,'234506','','','3236','tashar yari 019','0090',699174.30,'2021-10-27 12:11:12',5,'AGO FOR GEN = 6,900\r\nTRANSPORT = 2,500\r\nWEAHGT AND MESUAR = 10.000\r\n\r\nTOTAL = 19,400','414','','0000-00-00 00:00:00','664','2021-10-28 05:35:22'),(351470,'5','100','2021-10-26',106,'0090','','2',19400.00,'234506','','','','','',0.00,'2021-10-27 12:11:47',5,'','414','','0000-00-00 00:00:00','664','2021-10-28 05:35:22'),(352494,'5','100','2021-10-27',106,'0030','','5',389760.00,'234611','','','3236','tashar yari 019','0030',399158.10,'2021-10-29 12:00:42',5,'AGO FOR GEN = 6,900\r\nTRANSPORT = 2,500\r\n\r\nTOTAL = 9,400','414','','0000-00-00 00:00:00','664','2021-10-29 21:58:57'),(352495,'5','100','2021-10-27',106,'0030','','2',9400.00,'234611','','','','','',0.00,'2021-10-29 12:01:34',5,'','414','','0000-00-00 00:00:00','664','2021-10-29 21:58:57'),(352496,'5','100','2021-10-28',106,'0033','','5',162450.00,'234876','','','3236','tashar yari 019','0033',174348.90,'2021-10-29 12:04:32',5,'AGO FOR GEN = 6,900\r\nTRANSPORT TODAYS = 5,00\r\n\r\nTOTAL = 11,900','414','','0000-00-00 00:00:00','664','2021-10-29 21:58:57'),(352497,'5','100','2021-10-28',106,'0033','','2',11900.00,'234876','','','','','',0.00,'2021-10-29 12:05:10',5,'','414','','0000-00-00 00:00:00','664','2021-10-29 21:58:57'),(354214,'5','100','2021-10-31',106,'0042','','5',336150.00,'235766','','','3236','tashar yari 019','0042',345556.20,'2021-11-01 20:54:26',5,'AGO FOR GEN = 6,900\r\nTRANSPORT = 2,500\r\n\r\nTOTAL = 9,400','414','','0000-00-00 00:00:00','664','2021-11-02 04:28:01'),(354215,'5','100','2021-10-31',106,'0042','','2',9400.00,'235766','','','','','',0.00,'2021-11-01 20:55:28',5,'','414','','0000-00-00 00:00:00','664','2021-11-02 04:28:01'),(358248,'5','100','2021-11-01',106,'0031','','5',974220.00,'235841','','','3236','tashar yari 019','0031',983626.05,'2021-11-09 19:11:51',5,'AGO FOR GEN = 6,900\r\nTRANSPORT = 2,500\r\n\r\nTOTAL = 9,400','414','','0000-00-00 00:00:00','664','2021-11-09 19:18:50'),(358249,'5','100','2021-11-01',106,'0031','','2',9400.00,'235841','','','','','',0.00,'2021-11-09 19:12:41',5,'','414','','0000-00-00 00:00:00','664','2021-11-09 19:18:50'),(358250,'5','100','2021-11-02',106,'0008','','5',1592100.00,'236119','','','3236','tashar yari 019','0008',1601506.50,'2021-11-09 19:15:10',5,'AGO FOR GEN = 6,900\r\nTRANSPORT = 2,500\r\n\r\nTOTAL = 9,400','414','','0000-00-00 00:00:00','664','2021-11-09 19:18:50'),(358251,'5','100','2021-11-01',106,'0008','','2',9400.00,'236119','','','','','',0.00,'2021-11-09 19:16:01',5,'','414','','0000-00-00 00:00:00','664','2021-11-09 19:18:50'),(358921,'5','100','2021-11-03',106,'0074','','5',1802370.00,'236363','','','3236','tashar yari 019','0074',1837469.70,'2021-11-11 08:17:46',5,'AGO FOR GEN = 6,900\r\nTRANSPORT = 2,500\r\nGEN SERVICE = 5,000\r\nGEN OIL = 9,000\r\nSTATION EXPENSES = 11,700\r\n\r\nTOTAL = 35,100','414','','0000-00-00 00:00:00','664','2021-11-15 15:53:15'),(358922,'5','100','2021-11-03',106,'0074','','2',35100.00,'236363','','','','','',0.00,'2021-11-11 08:18:25',5,'','414','','0000-00-00 00:00:00','664','2021-11-15 15:53:15'),(358925,'5','100','2021-11-04',106,'0026','','5',158775.00,'236552','','','3236','tashar yari 019','0026',170676.00,'2021-11-11 08:20:42',5,'AGO FOR GEN = 6,900\r\nTRANSPORT TODAYS = 5,000\r\n\r\nTOTAL = 11,900','414','','0000-00-00 00:00:00','664','2021-11-15 15:53:15'),(358926,'5','100','2021-11-04',106,'0026','','2',11900.00,'236552','','','','','',0.00,'2021-11-11 08:21:26',5,'','414','','0000-00-00 00:00:00','664','2021-11-15 15:53:14'),(361181,'5','100','2021-11-12',106,'0021','','5',835715.00,'238421','','','3236','tashar yari 019','0021',845184.45,'2021-11-15 14:17:08',5,'AGO FOR GEN = 6,900\r\nTRANSPORT = 2,500\r\n\r\nTOTAL = 9,400','414','','0000-00-00 00:00:00','664','2021-11-15 15:53:14'),(361182,'5','100','2021-11-12',106,'0021','','2',9400.00,'238421','','','','','',0.00,'2021-11-15 14:17:49',5,'','414','','0000-00-00 00:00:00','664','2021-11-15 15:53:14'),(361183,'5','100','2021-11-13',106,'0020','','5',904000.00,'238649','','','3236','tashar yari 019','0020',913408.65,'2021-11-15 14:19:26',5,'AGO FOR GEN = 6,900\r\nTRANSPORT = 2,500\r\n\r\nTOTAL = 9,400','414','','0000-00-00 00:00:00','664','2021-11-15 15:53:14'),(361184,'5','100','2021-11-13',106,'0020','','2',9400.00,'238649','','','','','',0.00,'2021-11-15 14:20:07',5,'','414','','0000-00-00 00:00:00','664','2021-11-15 15:53:14'),(361191,'5','100','2021-11-14',106,'0022','','5',549820.00,'238892','','','3236','tashar yari 019','0022',559222.95,'2021-11-15 14:27:33',5,'AGO FOR GEN = 6,900\r\nTRANSPORT = 2,500\r\n\r\nTOTAL = 9,400','414','','0000-00-00 00:00:00','664','2021-11-15 15:53:14'),(361192,'5','100','2021-11-14',106,'0022','','2',9400.00,'238892','','','','','',0.00,'2021-11-15 14:28:37',5,'','414','','0000-00-00 00:00:00','664','2021-11-15 15:53:14'),(366874,'5','100','2021-11-15',106,'0068','','5',161680.00,'239112','','','3236','tashar yari 019','0068',176581.35,'2021-11-26 06:16:12',5,'AGO FOR GEN = 6,900\r\nTRANSPORT TODAYS = 5,000\r\nGEN OIL = 3,000\r\n\r\nTOTAL = 14,900','414','','0000-00-00 00:00:00','664','2021-11-26 06:23:45'),(366875,'5','100','2021-11-15',106,'0068','','2',14900.00,'239112','','','','','',0.00,'2021-11-26 06:16:58',5,'','414','','0000-00-00 00:00:00','664','2021-11-26 06:23:45'),(366876,'5','100','2021-11-23',106,'0045','','5',344065.00,'241051','','','3236','tashar yari 019','0045',548464.95,'2021-11-26 06:19:38',5,'AGO FOR GEN = 6,900\r\nTRANSPORT = 2,500\r\nSALARY FOR OCTOBER = 195,000\r\n\r\nTOTAL = 204,400','414','','0000-00-00 00:00:00','664','2021-11-26 06:23:45'),(366877,'5','100','2021-11-23',106,'0045','','2',204400.00,'241051','','','','','',0.00,'2021-11-26 06:20:25',5,'','414','','0000-00-00 00:00:00','664','2021-11-26 06:23:45'),(366878,'5','100','2021-11-24',106,'0024','','5',1231160.00,'241294','','','3236','tashar yari 019','0024',1250561.40,'2021-11-26 06:23:44',5,'AGO FOR GEN = 6,900\r\nTRANSPORT = 2,500\r\nPOLICE FUEL = 5,000\r\nTASPOS FUEL = 5,000\r\n\r\nTOTAL = 19,400','414','','0000-00-00 00:00:00','664','2021-11-26 09:45:18'),(366879,'5','100','2021-11-24',106,'0024','','2',19400.00,'241294','','','','','',0.00,'2021-11-26 06:24:29',5,'','414','','0000-00-00 00:00:00','664','2021-11-26 09:45:18'),(369066,'5','100','2021-11-25',106,'0053','','5',1211980.00,'241567','','','3236','tashar yari 019','0053',1221381.15,'2021-11-30 08:09:50',5,'AGO FOR GEN = 6,900\r\nTRANSPORT = 2,500\r\n\r\nTOTAL = 9,400','414','','0000-00-00 00:00:00','664','2021-11-30 09:22:17'),(369068,'5','100','2021-11-25',106,'0053','','2',9400.00,'241567','','','','','',0.00,'2021-11-30 08:10:49',5,'','414','','0000-00-00 00:00:00','664','2021-11-30 09:22:17'),(369072,'5','100','2021-11-26',106,'0024','','5',1012120.00,'241738','','','3236','tashar yari 019','0024',1021519.95,'2021-11-30 08:13:33',5,'AGO FOR GEN = 6,900\r\nTRANSPORT = 2,500\r\n\r\nTOTAL = 9,400','414','','0000-00-00 00:00:00','664','2021-11-30 09:22:17'),(369074,'5','100','2021-11-26',106,'0024','','2',9400.00,'241738','','','','','',0.00,'2021-11-30 08:14:43',5,'','414','','0000-00-00 00:00:00','664','2021-11-30 09:22:17'),(369079,'5','100','2021-11-27',106,'0023','','5',1120500.00,'242101','','','3236','tashar yari 019','0023',1134909.60,'2021-11-30 08:17:54',5,'AGO FOR GEN = 6,900\r\nTRANSPORT =2,500\r\nGEN SERVICE = 5,000\r\n\r\nTOTAL =14,400','414','','0000-00-00 00:00:00','664','2021-11-30 09:22:17'),(369081,'5','100','2021-11-27',106,'0023','','2',14400.00,'242101','','','','','',0.00,'2021-11-30 08:18:59',5,'','414','','0000-00-00 00:00:00','664','2021-11-30 09:22:17'),(369085,'5','100','2021-11-28',106,'0025','','5',1259810.00,'242401','','','3236','tashar yari 019','0025',1269209.70,'2021-11-30 08:21:15',5,'AGO FOR GEN = 6,900\r\nTRANSPORT = 2,500\r\n\r\nTOTAL = 9,400','414','','0000-00-00 00:00:00','664','2021-11-30 09:22:17'),(369088,'5','100','2021-11-28',106,'0025','','2',9400.00,'242401','','','','','',0.00,'2021-11-30 08:22:23',5,'','414','','0000-00-00 00:00:00','664','2021-11-30 09:22:17'),(377605,'5','100','2021-11-29',106,'0055','','5',801020.00,'242590','','','3236','tashar yari 019','0055',820419.60,'2021-12-16 11:37:21',5,'AGO FOR GEN = 6,900\r\nTRANSPORT = 2,500\r\nWHGHT AND MESUARE = 10,000\r\n\r\nTOTAL = 19,400','414','','0000-00-00 00:00:00','664','2021-12-16 15:52:14'),(377608,'5','100','2021-11-29',106,'0055','','2',19400.00,'242590','','','','','',0.00,'2021-12-16 11:38:10',5,'','414','','0000-00-00 00:00:00','664','2021-12-16 15:52:14'),(377613,'5','100','2021-11-30',106,'0069','','5',166450.00,'246303','','','3236','tashar yari 019','0069',208353.75,'2021-12-16 11:40:36',5,'AGO FOR GEN = 6,900\r\nTRANSPORT TODAYS = 5,000\r\n\r\nTOTAL = 11,900','414','','0000-00-00 00:00:00','664','2021-12-16 15:52:14'),(377614,'5','100','2021-11-30',106,'0069','','2',11900.00,'246303','','','','','',0.00,'2021-12-16 11:41:25',5,'','414','','0000-00-00 00:00:00','664','2021-12-16 15:52:14'),(377615,'5','100','2021-12-03',106,'0057','','5',580660.00,'246305','','','3236','tashar yari 019','0057',610762.35,'2021-12-16 11:44:56',5,'AGO FOR GEN = 6,900\r\nTRANSPORT = 2,500\r\nGEN OIL = 9,000\r\nSTATION EXP = 11,700\r\n\r\nTOTAL = 30,100','414','','0000-00-00 00:00:00','664','2021-12-16 15:52:14'),(377616,'5','100','2021-12-03',106,'0057','','2',30100.00,'246305','','','','','',0.00,'2021-12-16 11:45:44',5,'','414','','0000-00-00 00:00:00','664','2021-12-16 15:52:14'),(377619,'5','100','2021-12-04',106,'0055','','5',1198400.00,'246311','','','3236','tashar yari 019','0055',1207800.00,'2021-12-16 11:48:14',5,'AGO FOR GEN = 6,900\r\nTRANSPORT = 2,500\r\n\r\nTOTAL = 9,400','414','','0000-00-00 00:00:00','664','2021-12-16 15:52:14'),(377625,'5','100','2021-12-04',106,'0055','','2',9400.00,'246311','','','','','',0.00,'2021-12-16 11:52:48',5,'','414','','0000-00-00 00:00:00','664','2021-12-16 15:52:14'),(377626,'5','100','2021-12-05',106,'0056','','5',1083610.00,'246314','','','3236','tashar yari 019','0056',1103010.15,'2021-12-16 11:55:31',5,'AGO FOR GEN = 6,900\r\nTRANSPORT = 2,500\r\nGEN QUIAL = 10,000\r\n\r\nTOTAL = 19,400','414','','0000-00-00 00:00:00','664','2021-12-16 15:52:14'),(377628,'5','100','2021-12-05',106,'0056','','2',19400.00,'246314','','','','','',0.00,'2021-12-16 11:56:16',5,'','414','','0000-00-00 00:00:00','664','2021-12-16 15:52:14'),(377631,'5','100','2021-12-06',106,'0067','','5',1450110.00,'246316','','','3236','tashar yari 019','0067',1470009.75,'2021-12-16 11:58:55',5,'AGO FOR GEN = 6,900\r\nTRANSPORT = 2,500\r\nPUMP 4 REPAIR = 10,500\r\n\r\nTOTAL = 19,900','414','','0000-00-00 00:00:00','664','2021-12-16 15:52:14'),(377632,'5','100','2021-12-06',106,'0067','','2',19900.00,'246316','','','','','',0.00,'2021-12-16 11:59:38',5,'','414','','0000-00-00 00:00:00','664','2021-12-16 15:52:14'),(377639,'5','100','2021-12-07',106,'0032','','5',706140.00,'246317','','','3236','tashar yari 019','0032',910537.65,'2021-12-16 12:02:54',5,'AGO FOR GEN = 6,900\r\nTRANSPORT = 2,500\r\nSALARY FOR NUVENBER 2021 = 195,000\r\n\r\nTOTAL = 204,400','414','','0000-00-00 00:00:00','664','2021-12-16 15:52:14'),(377641,'5','100','2021-12-07',106,'0032','','2',204400.00,'246317','','','','','',0.00,'2021-12-16 12:03:41',5,'','414','','0000-00-00 00:00:00','664','2021-12-16 15:52:14'),(377644,'5','100','2021-12-08',106,'0067','','5',911900.00,'246319','','','3236','tashar yari 019','0067',921300.60,'2021-12-16 12:05:31',5,'AGO FOR GEN = 6,900\r\nTRANSPORT = 2,500\r\n\r\nTOTAL = 9,400','414','','0000-00-00 00:00:00','664','2021-12-16 15:52:14'),(377646,'5','100','2021-12-08',106,'0067','','2',9400.00,'246319','','','','','',0.00,'2021-12-16 12:06:08',5,'','414','','0000-00-00 00:00:00','664','2021-12-16 15:52:14'),(377648,'5','100','2021-12-09',106,'0016','','5',980400.00,'246323','','','3236','tashar yari 019','0016',989808.60,'2021-12-16 12:08:12',5,'AGO FOR GEN = 6,900\r\nTRANSPORT = 2,500\r\n\r\nTOTAL = 9,400','414','','0000-00-00 00:00:00','664','2021-12-16 15:52:14'),(377649,'5','100','2021-12-09',106,'','','2',9400.00,'246323','','','','','',0.00,'2021-12-16 12:08:44',5,'','414','','0000-00-00 00:00:00','664','2021-12-16 15:52:14'),(377651,'5','100','2021-12-10',106,'0033','','5',209760.00,'246324','','','3236','tashar yari 019','0033',221662.65,'2021-12-16 12:10:44',5,'AGO FOR GEN = 6,900\r\nTRANSPORT  TODAYS = 5,000\r\n\r\nTOTAL = 11,900','414','','0000-00-00 00:00:00','664','2021-12-16 15:52:14'),(377652,'5','100','2021-12-10',106,'0033','','2',11900.00,'246324','','','','','',0.00,'2021-12-16 12:11:24',5,'','414','','0000-00-00 00:00:00','664','2021-12-16 15:52:14'),(378459,'5','100','2021-12-16',106,'0074','','5',521940.00,'246637','','','3236','tashar yari 019','0074',534342.60,'2021-12-18 07:01:05',5,'AGO FOR GEN = 6,900\r\nTRANSPORT = 2,500\r\nGEN OIL = 3,000\r\n\r\nTOTAL = 12,400','414','','0000-00-00 00:00:00','664','2021-12-20 18:04:20'),(378461,'5','100','2021-12-16',106,'0074','','2',12400.00,'246637','','','','','',0.00,'2021-12-18 07:02:24',5,'','414','','0000-00-00 00:00:00','664','2021-12-20 18:04:20'),(380802,'5','100','2021-12-17',106,'0095','','5',979790.00,'246870','','','3236','tashar yari 019','0095',1005689.85,'2021-12-22 12:37:18',5,'AG0 FOR GEN = 6,900\r\nTRANSPORT= 2,500\r\nPUMP REPAIR = 16,500\r\n\r\nTOTAL = 25,900','414','','0000-00-00 00:00:00','664','2021-12-23 04:54:11'),(380803,'5','100','2021-12-17',106,'0095','','2',25900.00,'246870','','','','','',0.00,'2021-12-22 12:38:06',5,'','414','','0000-00-00 00:00:00','664','2021-12-23 04:54:11'),(388684,'5','100','2021-12-18',106,'0098','','5',1115975.00,'246962','','','3236','tashar yari 019','0098',1125375.90,'2022-01-06 16:21:05',5,'AGO FOR GEN = 6,900\r\nTRANSPORT = 2,500\r\n','414','','0000-00-00 00:00:00','664','2022-01-07 07:01:25'),(388685,'5','100','2021-12-18',106,'0098','','2',9400.00,'246962','','','','','',0.00,'2022-01-06 16:22:17',5,'','414','','0000-00-00 00:00:00','664','2022-01-07 07:01:25'),(388687,'5','100','2021-12-19',106,'0096','','5',971965.00,'247476','','','3236','tashar yari 019','0096',0.00,'2022-01-06 16:24:09',5,'AGO FOR GEN = 6,900\r\nTRANSPORT = 2,500\r\n\r\nTOTAL = 9,400','414','','0000-00-00 00:00:00','664','2022-01-07 07:01:25'),(388688,'5','100','2021-12-19',106,'0096','','2',9400.00,'247476','','','','','',0.00,'2022-01-06 16:25:32',5,'','414','','0000-00-00 00:00:00','664','2022-01-07 07:01:25'),(388689,'5','100','2021-12-20',106,'0034','','5',663390.00,'247611','','','3236','tashar yari 019','0034',675292.20,'2022-01-06 16:28:08',5,'AGO FOR GEN = 6,900\r\nTRANSPORT TODAYS = 5,000\r\n\r\nTOTAL = 11,900','414','','0000-00-00 00:00:00','664','2022-01-07 07:01:25'),(388691,'5','100','2021-12-20',106,'0034','','2',11900.00,'247611','','','','','',0.00,'2022-01-06 16:29:07',5,'','414','','0000-00-00 00:00:00','664','2022-01-07 07:01:25'),(388693,'5','100','2022-01-05',106,'0015','','5',283085.00,'251458','','','3236','tashar yari 019','0015',478184.85,'2022-01-06 16:35:28',5,'AGO FOR GEN = 6,900\r\nTRANSPORT = 2,500\r\nGEN OIL = 9,000\r\nSTATION EXP = 11,700\r\nSTAFF SALARY = 165,000\r\n\r\nTOTAL = 195,100','414','','0000-00-00 00:00:00','664','2022-01-07 07:01:25'),(388695,'5','100','2022-01-05',106,'0015','','2',195100.00,'251458','','','','','',0.00,'2022-01-06 16:36:20',5,'','414','','0000-00-00 00:00:00','664','2022-01-07 07:01:25'),(389177,'5','100','2022-01-06',106,'0048','','5',1144700.00,'251682','','','3236','tashar yari 019','0048',1154100.75,'2022-01-07 15:21:11',5,'AGO FOR GEN = 6,900\r\nTRANSPORT = 2,500\r\n\r\nTOTAL = 9,400','414','','0000-00-00 00:00:00','664','2022-01-08 08:06:54'),(389178,'5','100','2022-01-06',106,'0048','','2',9400.00,'251682','','','','','',0.00,'2022-01-07 15:21:57',5,'','414','','0000-00-00 00:00:00','664','2022-01-08 08:06:54'),(390897,'5','100','2022-01-07',106,'0049','','5',1332120.00,'251898','','','3236','tashar yari 019','0049',1162274.85,'2022-01-11 08:40:19',5,'AGO FOR GEN = 6,900\r\nTRANSPORT = 2,500\r\nSTAFFS HOUSE MONEY= 120,000\r\n\r\nTOTAL = 129,400','414','','0000-00-00 00:00:00','664','2022-01-11 09:42:42'),(390898,'5','100','2022-01-07',106,'0049','','2',129400.00,'251898','','','','','',0.00,'2022-01-11 08:41:18',5,'','414','','0000-00-00 00:00:00','664','2022-01-11 09:42:42'),(390902,'5','100','2022-01-08',106,'0051','','5',1032875.00,'252381','','','3236','tashar yari 019','0051',1361518.95,'2022-01-11 08:43:52',5,'AGO FOR GEN = 6,900\r\nTRANSPORT = 2,500\r\nTASPOST = 20,000\r\n\r\nTOTAL = 29,400','414','','0000-00-00 00:00:00','664','2022-01-11 09:42:42'),(390904,'5','100','2022-01-08',106,'0051','','2',29400.00,'252381','','','','','',0.00,'2022-01-11 08:44:36',5,'','414','','0000-00-00 00:00:00','664','2022-01-11 09:42:42'),(390906,'5','100','2022-01-09',106,'0050','','5',975350.00,'252545','','','3236','tashar yari 019','0050',984751.35,'2022-01-11 08:46:33',5,'AGO FOR GEN = 6,900\r\nTRANSPORT = 2,500\r\n\r\nTOTAL = 9,400','414','','0000-00-00 00:00:00','664','2022-01-11 09:42:42'),(390909,'5','100','2022-01-09',106,'0050','','2',9400.00,'252545','','','','','',0.00,'2022-01-11 08:47:14',5,'','414','','0000-00-00 00:00:00','664','2022-01-11 09:42:42'),(391390,'5','100','2022-01-10',106,'0034','','5',980540.00,'252675','','','3236','tashar yari 019','0034',999939.60,'2022-01-11 20:03:54',5,'AGO FOR GEN = 6,900\r\nTRANSPORT = 2,500\r\nWEHGT AND MESUARE =10,000\r\n\r\nTOTAL = 19,400','414','','0000-00-00 00:00:00','664','2022-01-12 08:12:18'),(391391,'5','100','2022-01-10',106,'0034','','2',19400.00,'252675','','','','','',0.00,'2022-01-11 20:04:49',5,'','414','','0000-00-00 00:00:00','664','2022-01-12 08:12:18'),(392206,'5','100','2022-01-11',106,'0125416','','5',397540.00,'252755','','','3236','tashar yari 019','0125416',409437.60,'2022-01-13 10:36:16',5,'AGO FOR GEN = 6,900\r\nTRANSPORT TODAYS = 5,000\r\n\r\nTOTAL 11,900','414','','0000-00-00 00:00:00','664','2022-01-13 10:45:11'),(392208,'5','100','2022-01-11',106,'0125416','','2',11900.00,'252755','','','','','',0.00,'2022-01-13 10:37:05',5,'','414','','0000-00-00 00:00:00','664','2022-01-13 10:45:11');
/*!40000 ALTER TABLE `purchases_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_receptions`
--

DROP TABLE IF EXISTS `purchases_receptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_receptions` (
  `bridge_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `purchase_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `loadingdate` datetime NOT NULL,
  `loadingpoint` varchar(100) DEFAULT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `received` decimal(20,2) NOT NULL,
  `distributed` decimal(20,2) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `vessel` varchar(50) NOT NULL,
  `drivername` varchar(30) NOT NULL,
  `driverphone` varchar(30) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`bridge_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`supplier_id`,`loadingdate`,`quantity`,`waybill`,`meterno`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`purchase_id`),
  KEY `truck_id` (`tank_id`)
) ENGINE=InnoDB AUTO_INCREMENT=129893 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_receptions`
--

LOCK TABLES `purchases_receptions` WRITE;
/*!40000 ALTER TABLE `purchases_receptions` DISABLE KEYS */;
INSERT INTO `purchases_receptions` VALUES (120159,'5',78179,'100',247,106,'2021-10-13 00:00:00','AA RANO DEPOT',100.00,100.00,0.00,'NIL','','629','NIL','NIL','0802','AGO RECIEVED',5,'2021-10-13 09:06:01','600','0000-00-00 00:00:00','','2021-10-13 09:08:12','600'),(120160,'5',78178,'100',246,106,'2021-10-13 00:00:00','AA RANO DEPOT',300.00,300.00,0.00,'NIL','','627','NIL','NIL','0802','PMS RECIEVED',5,'2021-10-13 09:07:37','600','0000-00-00 00:00:00','','2021-10-13 09:07:56','600'),(120161,'5',78178,'100',246,106,'2021-10-13 00:00:00','AA RANO DEPOT',350.00,350.00,0.00,'NIL','','628','NIL','NIL','0802','PMS RECIEVED',5,'2021-10-13 09:07:37','600','0000-00-00 00:00:00','','2021-10-13 09:07:56','600'),(120277,'5',78248,'100',246,106,'2021-10-13 00:00:00','AA RANO',29900.00,29900.00,0.00,'1961','','627','KMA 901 ZE','YUSIF','0805','PMS',5,'2021-10-13 17:14:37','414','0000-00-00 00:00:00','','2021-10-13 17:32:06','604'),(120505,'5',78391,'100',246,106,'2021-10-15 00:00:00','AA RANO',20000.00,20000.00,0.00,'2206','','627','RAN 554 XA','MOHD','0805','PMS',5,'2021-10-15 20:31:04','414','0000-00-00 00:00:00','','2021-10-16 08:05:14','604'),(120903,'5',78631,'100',246,106,'2021-10-19 00:00:00','AA RANO',30000.00,30000.00,0.00,'2212','','628','LSD 602 XY','DAN UDUWA','0805','PMS',5,'2021-10-19 18:10:27','414','0000-00-00 00:00:00','','2021-10-19 18:36:08','604'),(121179,'5',78858,'100',246,106,'2021-10-21 00:00:00','AA RANO',4000.00,4000.00,0.00,'2206','','627','RAN 554 XA','MOHD','080','PMS',5,'2021-10-21 19:25:11','414','0000-00-00 00:00:00','','2021-10-21 20:00:35','604'),(121416,'5',79001,'100',246,106,'2021-10-24 00:00:00','AA RANO',661.00,661.00,0.00,'2206','','627','RAN 554 XA','MOHD','080','PMS',5,'2021-10-24 06:49:17','414','0000-00-00 00:00:00','','2021-10-24 07:32:20','604'),(122226,'5',79500,'100',246,106,'2021-10-31 00:00:00','AA RANO',30000.00,30000.00,0.00,'1961','','627','LSD 602 XY','YUSIF','0805','PMS',5,'2021-10-31 19:25:11','414','0000-00-00 00:00:00','','2021-11-01 08:44:48','604'),(123597,'5',80382,'100',246,106,'2021-11-12 00:00:00','AA RANO',14900.00,14900.00,0.00,'2219','','627','LSD 602 XY','DAN UDUWA','0805','PMS',5,'2021-11-12 12:25:23','414','0000-00-00 00:00:00','','2021-11-12 12:30:49','604'),(124849,'5',85464,'100',246,106,'2021-11-23 00:00:00','AA RANO',27000.00,27000.00,0.00,'2221','','627','DKA 771 ZU','YUSIF RANO','080','PMS',5,'2021-11-23 09:32:36','414','0000-00-00 00:00:00','','2021-11-23 10:26:18','604'),(124850,'5',85464,'100',246,106,'2021-11-23 00:00:00','AA RANO',18000.00,18000.00,0.00,'2221','','628','DKA 771 ZU','YUSIF RANO','080','PMS',5,'2021-11-23 09:32:36','414','0000-00-00 00:00:00','','2021-11-23 10:26:37','604'),(127477,'5',87265,'100',246,106,'2021-12-15 00:00:00','AA RANO',27000.00,27000.00,0.00,'0228','','627','KMC 39 XX','MOHD','080','PMS',5,'2021-12-15 11:08:52','414','0000-00-00 00:00:00','','2021-12-15 11:13:00','604'),(127478,'5',87265,'100',246,106,'2021-12-15 00:00:00','AA RANO',18000.00,18000.00,0.00,'0228','','628','KMC 39 XX','MOHD','080','PMS',5,'2021-12-15 11:08:52','414','0000-00-00 00:00:00','','2021-12-15 11:13:12','604'),(127650,'5',87377,'100',246,106,'2021-12-16 00:00:00','AA RANO',26300.00,26300.00,0.00,'1266','','627','GWL 66 YJ','MOHD','080','PMS',5,'2021-12-16 18:46:50','414','0000-00-00 00:00:00','','2021-12-16 18:55:39','604'),(129891,'5',88916,'100',246,106,'2022-01-05 00:00:00','AA RANO',14000.00,14000.00,0.00,'2074','','627','KMC 146 YT','MOHD','0805','PMS',5,'2022-01-05 19:31:38','414','0000-00-00 00:00:00','','2022-01-06 00:50:17','604'),(129892,'5',88916,'100',246,106,'2022-01-05 00:00:00','AA RANO',25500.00,25500.00,0.00,'2074','','628','KMC 146 YT','MOHD','0805','PMS',5,'2022-01-05 19:31:38','414','0000-00-00 00:00:00','','2022-01-06 00:50:27','604');
/*!40000 ALTER TABLE `purchases_receptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports`
--

DROP TABLE IF EXISTS `reports`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  `type` varchar(20) NOT NULL,
  `sql` text NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`report_id`),
  KEY `companycode` (`company_id`,`name`,`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports`
--

LOCK TABLES `reports` WRITE;
/*!40000 ALTER TABLE `reports` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_fields`
--

DROP TABLE IF EXISTS `reports_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(20) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `fieldname` varchar(50) NOT NULL,
  `order` int NOT NULL,
  `visibility` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`report_id`,`field_id`,`order`,`visibility`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_fields`
--

LOCK TABLES `reports_fields` WRITE;
/*!40000 ALTER TABLE `reports_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_filters`
--

DROP TABLE IF EXISTS `reports_filters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_filters` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(50) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `filter_id` int NOT NULL AUTO_INCREMENT,
  `criteria` varchar(20) NOT NULL,
  `value` varchar(100) NOT NULL,
  PRIMARY KEY (`filter_id`),
  KEY `companycode` (`company_id`,`report_id`),
  KEY `field_id` (`field_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_filters`
--

LOCK TABLES `reports_filters` WRITE;
/*!40000 ALTER TABLE `reports_filters` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_filters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_customers`
--

DROP TABLE IF EXISTS `retail_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_customers` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(100) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`name`,`phone`,`email`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_customers`
--

LOCK TABLES `retail_customers` WRITE;
/*!40000 ALTER TABLE `retail_customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory`
--

DROP TABLE IF EXISTS `retail_inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` int NOT NULL,
  `qtyout` int NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory`
--

LOCK TABLES `retail_inventory` WRITE;
/*!40000 ALTER TABLE `retail_inventory` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_balances`
--

DROP TABLE IF EXISTS `retail_inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_balances`
--

LOCK TABLES `retail_inventory_balances` WRITE;
/*!40000 ALTER TABLE `retail_inventory_balances` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_costs`
--

DROP TABLE IF EXISTS `retail_inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_costs`
--

LOCK TABLES `retail_inventory_costs` WRITE;
/*!40000 ALTER TABLE `retail_inventory_costs` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products`
--

DROP TABLE IF EXISTS `retail_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`name`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `parent_id` (`parent_id`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products`
--

LOCK TABLES `retail_products` WRITE;
/*!40000 ALTER TABLE `retail_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_prices`
--

DROP TABLE IF EXISTS `retail_products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_prices`
--

LOCK TABLES `retail_products_prices` WRITE;
/*!40000 ALTER TABLE `retail_products_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_purchases`
--

DROP TABLE IF EXISTS `retail_purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_purchases`
--

LOCK TABLES `retail_purchases` WRITE;
/*!40000 ALTER TABLE `retail_purchases` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales`
--

DROP TABLE IF EXISTS `retail_sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `saledate` date NOT NULL,
  `customer_id` varchar(20) NOT NULL DEFAULT '',
  `customer_name` varchar(50) NOT NULL,
  `customer_phone` varchar(30) NOT NULL,
  `quantity_kg` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `payment_method` varchar(10) NOT NULL,
  `payment_account_type` varchar(20) NOT NULL,
  `payment_account_id` varchar(20) NOT NULL,
  `paid` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`customer_name`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `payment_method` (`payment_method`,`payment_account_type`,`payment_account_id`),
  KEY `customer_id` (`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales`
--

LOCK TABLES `retail_sales` WRITE;
/*!40000 ALTER TABLE `retail_sales` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_items`
--

DROP TABLE IF EXISTS `retail_sales_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `product_type` varchar(10) NOT NULL,
  `product_name` varchar(100) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `quantity_2` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `parent_cost` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`sale_id`,`product_id`,`rate`,`quantity`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`product_type`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_items`
--

LOCK TABLES `retail_sales_items` WRITE;
/*!40000 ALTER TABLE `retail_sales_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales`
--

DROP TABLE IF EXISTS `sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `is_credit` int NOT NULL DEFAULT '0',
  `saledate` date NOT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `paid` int NOT NULL,
  `details` text NOT NULL,
  `ledger_notes` varchar(150) DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`product_id`,`customer_id`,`rate`,`quantity`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`is_credit`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales`
--

LOCK TABLES `sales` WRITE;
/*!40000 ALTER TABLE `sales` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_daily`
--

DROP TABLE IF EXISTS `sales_daily`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_daily` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `saledate` date NOT NULL,
  `average` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `target` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`average`,`saledate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_daily`
--

LOCK TABLES `sales_daily` WRITE;
/*!40000 ALTER TABLE `sales_daily` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_daily` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions`
--

DROP TABLE IF EXISTS `sales_distributions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions` (
  `distribution_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `sale_id` int NOT NULL,
  `purchase_id` varchar(20) NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `loadingdate` date NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `destination` varchar(50) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `truckno` varchar(20) NOT NULL,
  `drivername` varchar(50) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`distribution_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`loadingdate`,`quantity`,`destination`,`waybill`,`meterno`,`nozzle_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`tank_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `truckno` (`truckno`),
  KEY `purchase_id_2` (`purchase_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions`
--

LOCK TABLES `sales_distributions` WRITE;
/*!40000 ALTER TABLE `sales_distributions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_delivery`
--

DROP TABLE IF EXISTS `sales_distributions_delivery`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_delivery` (
  `delivery_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `distribution_id` int NOT NULL,
  `sale_id` int NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `quantity` int NOT NULL,
  `truck_id` int NOT NULL,
  `deliveredon` date NOT NULL,
  `details` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`delivery_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`quantity`,`thedate`,`createdby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`truck_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `distribution_id` (`distribution_id`),
  KEY `deliveredon` (`deliveredon`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_delivery`
--

LOCK TABLES `sales_distributions_delivery` WRITE;
/*!40000 ALTER TABLE `sales_distributions_delivery` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_delivery` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_trucks`
--

DROP TABLE IF EXISTS `sales_distributions_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_trucks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sale_id` varchar(20) NOT NULL,
  `distribution_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `bridge_id` varchar(20) NOT NULL,
  `truck_id` varchar(20) NOT NULL,
  `driver_id` varchar(20) NOT NULL,
  `quantity` int NOT NULL,
  `destination` varchar(150) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `companycode` (`company_id`,`distribution_id`,`truck_id`),
  KEY `sale_id` (`sale_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_trucks`
--

LOCK TABLES `sales_distributions_trucks` WRITE;
/*!40000 ALTER TABLE `sales_distributions_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_fueltickets`
--

DROP TABLE IF EXISTS `sales_fueltickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_fueltickets` (
  `ticket_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `ticketdate` date NOT NULL,
  `code` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `allowance` decimal(10,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `truck_number` varchar(20) NOT NULL,
  `truck_capacity` int NOT NULL,
  `truck_provider` varchar(50) NOT NULL,
  `truck_from` varchar(50) NOT NULL,
  `truck_destination` varchar(50) NOT NULL,
  `driver_name` varchar(50) NOT NULL,
  `driver_phone` varchar(50) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`ticket_id`),
  KEY `companycode` (`company_id`,`ticketdate`,`product_id`,`truck_number`,`rate`,`quantity`,`status`),
  KEY `paid` (`truck_provider`),
  KEY `invoice` (`code`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_fueltickets`
--

LOCK TABLES `sales_fueltickets` WRITE;
/*!40000 ALTER TABLE `sales_fueltickets` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_fueltickets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_payments`
--

DROP TABLE IF EXISTS `sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `customer_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`customer_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_payments`
--

LOCK TABLES `sales_payments` WRITE;
/*!40000 ALTER TABLE `sales_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers`
--

DROP TABLE IF EXISTS `suppliers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers` (
  `supplier_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`supplier_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=107 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers`
--

LOCK TABLES `suppliers` WRITE;
/*!40000 ALTER TABLE `suppliers` DISABLE KEYS */;
INSERT INTO `suppliers` VALUES (106,'5','100','SALBAS OIL & GAS NIG. LIMITED','KABIRU GM','','','KANO','KANO STATE','','Nigeria',18244891.10,0.00,'0000-00-00','2019-02-23 18:44:57',5,'414','2020-02-09 07:37:04','473');
/*!40000 ALTER TABLE `suppliers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers_status`
--

DROP TABLE IF EXISTS `suppliers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `supplier_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers_status`
--

LOCK TABLES `suppliers_status` WRITE;
/*!40000 ALTER TABLE `suppliers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `suppliers_status` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2023-03-21  2:56:22
