-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_4_station_283
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_4_station_283`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_4_station_283` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_4_station_283`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,4000,'',0,'22','4','283','PURCHASES','','2022-09-12 19:49:22',5,0.00,0.00,'','954','2022-09-12 19:49:22','954',0,0),(2,8000,'',0,'24','4','283','PURCHASES','','2022-09-12 19:50:25',5,0.00,0.00,'','954','2022-09-12 19:50:25','954',0,0),(3,7000,'',0,'20','4','283','SALES','','2022-09-12 19:50:35',5,0.00,0.00,'','954','2022-09-12 19:50:35','954',0,0),(4,500,'',0,'6.1','4','283','CASH','','2022-09-12 19:50:49',5,0.00,0.00,'','954','2022-09-12 19:50:49','954',0,0),(5,8001,'',0,'24','4','283','SALARIES & WAGES','','2022-09-12 19:51:01',5,0.00,0.00,'','954','2022-09-12 19:51:01','954',0,0),(6,2500,'',0,'2','4','283','ALIKO-UBA-1024487879','','2023-02-06 15:21:58',5,0.00,0.00,'','955','2023-02-06 15:21:58','955',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1,'','4','283','SABRIN GAS','ABUBAKAR AHMAD','08039702656','info@','KANO','KANO','ZAWACIKI','Nigeria',20000000.00,0.00,0.00,'0000-00-00','2023-02-06 15:07:34',5,'955','2023-02-06 15:07:34','955'),(2,'','4','283','SALUHU GAS','SALIHU DANTATA','080357424300','info@','KANO','KANO','KOFAR RUWA.','Nigeria',5000000.00,0.00,0.00,'0000-00-00','2023-02-06 15:15:10',5,'955','2023-02-06 15:15:10','955'),(3,'','4','283','FRIDAY GAS','FRIDAY','08036238369','friday@gmail.com','KANO','KANO ','SABON GARI KANO','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-11 13:11:52',5,'955','2023-02-11 13:11:52','955'),(4,'','4','283','SENIOR GAS','USMAN SENIOR ','08068826955','usss@gmail.com','kano','ka','Gobirawa','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-14 18:13:08',5,'955','2023-02-14 18:13:08','955'),(5,'','4','283','MAIKIRAN SALLAH','MAIKIRAN SALLAH','08037336711','maikiransallah@gmail.com','kano','kano','dandishe','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-05 09:53:12',5,'955','2023-03-05 09:53:12','955');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('4','283','1',1,'5','LPG NOZZLE 1',10910.17,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('4','283','1',2,'5','LPG NOZZLE 2',2337.76,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('4','283','1',3,'5','LPG NOZZLE 3',118.00,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('4','283','1',4,'5','LPG NOZZLE 4',116.50,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('4','283','1',5,'5','LPG NOZZLE 5',0.00,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('4','283','1',6,'5','LPG NOZZLE 6',0.00,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('4','283',1,'DAILY SHIFT.','2023-02-05','2023-02-05 16:50:21','2023-02-06 16:50:21','954',0.00,0.00,'954','2023-02-05 17:23:42','954','2023-02-05 17:24:08',10,0),('4','283',2,'DAILY SHIFT.686','2023-02-06','2023-02-06 14:43:47','2023-02-07 14:43:47','955',0.00,0.00,'955','2023-02-06 15:18:07','955','2023-02-06 15:18:54',10,0),('4','283',3,'lpg','2023-02-11','2023-02-11 13:01:30','2023-02-18 13:01:30','955',0.00,0.00,'955','2023-02-12 16:30:45','955','2023-02-12 17:48:05',10,0),('4','283',4,'DAILY SHIFTS','2023-02-12','2023-02-12 17:49:44','2023-02-13 17:49:44','955',0.00,0.00,'955','2023-02-12 19:03:43','955','2023-02-12 19:04:13',10,0),('4','283',5,'DAILY SHIFTS','2023-02-12','2023-02-12 19:10:36','2023-02-13 19:10:36','955',0.00,0.00,'955','2023-02-12 19:48:16','955','2023-02-12 21:01:55',10,0),('4','283',6,'DAILY SHIFTS','2023-02-13','2023-02-13 08:09:04','2023-02-14 08:09:04','955',0.00,0.00,'955','2023-02-13 22:51:19','955','2023-02-13 22:51:53',10,0),('4','283',7,'DAILY SHIFTS','2023-02-14','2023-02-14 10:39:17','2023-02-15 10:39:17','955',0.00,0.00,'955','2023-02-16 13:28:22','955','2023-02-16 13:30:18',10,0),('4','283',8,'DAILY SHIFTS','2023-02-16','2023-02-16 13:31:24','2023-02-17 13:31:24','955',0.00,0.00,'955','2023-02-17 14:01:38','955','2023-02-17 14:03:02',10,0),('4','283',9,'DAILY SHIFTS','2023-02-22','2023-02-22 22:26:37','2023-02-23 22:26:37','955',0.00,0.00,'955','2023-03-02 18:28:22','955','2023-03-04 17:53:42',10,0),('4','283',10,'DAILY SHIFTS','2023-03-04','2023-03-04 17:54:33','2023-03-05 17:54:33','955',0.00,0.00,'955','2023-03-05 00:42:25','955','2023-03-05 00:43:00',10,0),('4','283',11,'DAILY SHIFTS','2023-03-05','2023-03-05 09:27:14','2023-03-06 09:27:14','955',0.00,0.00,'955','2023-03-09 13:00:50','955','2023-03-09 13:05:09',10,0),('4','283',12,'DAILY SHIFT','2023-03-09','2023-03-09 13:05:50','2023-03-10 13:05:50','955',0.00,0.00,'955','2023-03-10 08:46:03','955','2023-03-10 08:46:28',10,0),('4','283',13,'DAILY SHIFT','2023-03-10','2023-03-10 08:47:03','2023-03-11 08:47:03','955',0.00,0.00,'955','2023-03-10 23:08:49','955','2023-03-10 23:09:16',10,0),('4','283',14,'DAILY SHIFT','2023-03-11','2023-03-11 08:48:51','2023-03-12 08:48:51','955',0.00,0.00,'955','2023-03-12 10:29:19','955','2023-03-12 10:30:14',10,0),('4','283',15,'DAILY SHIFT','2023-03-12','2023-03-12 10:30:52','2023-03-13 10:30:52','955',0.00,0.00,'955','2023-03-13 08:11:00','955','2023-03-13 08:11:26',10,0),('4','283',16,'DAILY SHIFT','2023-03-13','2023-03-13 08:12:03','2023-03-14 08:12:03','955',0.00,0.00,'955','2023-03-13 20:46:46','955','2023-03-13 20:47:09',10,0),('4','283',17,'DAILY SHIFT','2023-03-14','2023-03-14 09:51:42','2023-03-15 09:51:42','955',0.00,0.00,'955','2023-03-15 10:38:58','955','2023-03-15 10:39:20',10,0),('4','283',18,'DAILY SHIFT','2023-03-15','2023-03-15 10:40:08','2023-03-16 10:40:08','955',0.00,0.00,'955','2023-03-16 11:01:39','955','2023-03-16 11:02:00',10,0),('4','283',19,'DAILY SHIFT','2023-03-16','2023-03-16 11:02:27','2023-03-17 11:02:27','955',0.00,0.00,'955','2023-03-16 23:57:51','955','2023-03-16 23:58:10',10,0),('4','283',20,'DAILY SHIFT','2023-03-17','2023-03-17 09:01:03','2023-03-18 09:01:03','955',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=121 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('4','283','1','1',1,'1','1',0.00,6.00,0.00,0.00,6.00,4560.00,0.00,0.00,0.00),('4','283','1','1',2,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','1',3,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','1',4,'4','1',0.00,12.50,0.00,0.00,12.50,9500.00,0.00,0.00,0.00),('4','283','1','1',5,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','1',6,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','2',7,'1','1',6.00,58.50,0.00,0.00,52.50,39900.00,0.00,0.00,0.00),('4','283','1','2',8,'2','1',0.00,303.00,0.00,0.00,303.00,227280.00,0.00,0.00,0.00),('4','283','1','2',9,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','2',10,'4','1',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','2',11,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','2',12,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','3',13,'1','1',58.50,71.00,0.00,0.00,12.50,9500.00,0.00,0.00,0.00),('4','283','1','3',14,'2','1',303.00,309.00,0.00,0.00,6.00,4560.00,0.00,0.00,0.00),('4','283','1','3',15,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','3',16,'4','1',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','3',17,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','3',18,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','4',19,'1','1',71.00,772.00,0.00,0.00,701.00,527760.00,0.00,0.00,0.00),('4','283','1','4',20,'2','1',309.00,1119.00,0.00,0.00,810.00,608100.00,0.00,0.00,0.00),('4','283','1','4',21,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','4',22,'4','1',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','4',23,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','4',24,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','5',25,'1','1',772.00,792.00,0.00,0.00,20.00,15200.00,0.00,0.00,0.00),('4','283','1','5',26,'2','1',1119.00,1176.50,0.00,0.00,57.50,43700.00,0.00,0.00,0.00),('4','283','1','5',27,'3','1',0.00,18.00,0.00,0.00,18.00,13680.00,0.00,0.00,0.00),('4','283','1','5',28,'4','1',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','5',29,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','5',30,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','6',31,'1','1',792.00,1538.50,0.00,0.00,746.50,560840.00,0.00,0.00,0.00),('4','283','1','6',32,'2','1',1176.50,1187.76,0.00,0.00,11.26,8557.60,0.00,0.00,0.00),('4','283','1','6',33,'3','1',18.00,18.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','6',34,'4','1',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','6',35,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','6',36,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','7',37,'1','1',1538.50,2078.50,0.00,0.00,540.00,405400.00,0.00,0.00,0.00),('4','283','1','7',38,'2','1',1187.76,1987.76,0.00,0.00,800.00,600000.00,0.00,0.00,0.00),('4','283','1','7',39,'3','1',18.00,18.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','7',40,'4','1',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','7',41,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','7',42,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','8',43,'1','1',2078.50,2486.50,0.00,0.00,408.00,289912.00,0.00,0.00,0.00),('4','283','1','8',44,'2','1',1987.76,2337.76,0.00,0.00,350.00,262500.00,0.00,0.00,0.00),('4','283','1','8',45,'3','1',18.00,118.00,0.00,0.00,100.00,76000.00,0.00,0.00,0.00),('4','283','1','8',46,'4','1',12.50,116.50,0.00,0.00,104.00,73040.00,0.00,0.00,0.00),('4','283','1','8',47,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','8',48,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','9',49,'1','1',2486.50,2486.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','9',50,'2','1',2337.76,2337.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','9',51,'3','1',118.00,118.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','9',52,'4','1',116.50,116.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','9',53,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','9',54,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','10',55,'1','1',2486.50,2495.50,0.00,0.00,9.00,6624.00,0.00,0.00,0.00),('4','283','1','10',56,'2','1',2337.76,2337.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','10',57,'3','1',118.00,118.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','10',58,'4','1',116.50,116.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','10',59,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','10',60,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','11',61,'1','1',2495.50,3182.14,0.00,0.00,686.64,504119.04,0.00,0.00,0.00),('4','283','1','11',62,'2','1',2337.76,2337.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','11',63,'3','1',118.00,118.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','11',64,'4','1',116.50,116.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','11',65,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','11',66,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','12',67,'1','1',3182.14,3603.13,0.00,0.00,420.99,309523.64,0.00,0.00,0.00),('4','283','1','12',68,'2','1',2337.76,2337.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','12',69,'3','1',118.00,118.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','12',70,'4','1',116.50,116.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','12',71,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','12',72,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','13',73,'1','1',3603.13,4460.94,0.00,0.00,857.81,623652.16,0.00,0.00,0.00),('4','283','1','13',74,'2','1',2337.76,2337.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','13',75,'3','1',118.00,118.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','13',76,'4','1',116.50,116.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','13',77,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','13',78,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','14',79,'1','1',4460.94,5134.97,0.00,0.00,674.03,494708.08,0.00,0.00,0.00),('4','283','1','14',80,'2','1',2337.76,2337.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','14',81,'3','1',118.00,118.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','14',82,'4','1',116.50,116.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','14',83,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','14',84,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','15',85,'1','1',5134.97,5727.39,0.00,0.00,592.42,433434.12,0.00,0.00,0.00),('4','283','1','15',86,'2','1',2337.76,2337.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','15',87,'3','1',118.00,118.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','15',88,'4','1',116.50,116.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','15',89,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','15',90,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','16',91,'1','1',5727.39,6512.48,0.00,0.00,785.09,569272.24,0.00,0.00,0.00),('4','283','1','16',92,'2','1',2337.76,2337.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','16',93,'3','1',118.00,118.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','16',94,'4','1',116.50,116.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','16',95,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','16',96,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','17',97,'1','1',6512.48,7204.52,0.00,0.00,692.04,509341.44,0.00,0.00,0.00),('4','283','1','17',98,'2','1',2337.76,2337.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','17',99,'3','1',118.00,118.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','17',100,'4','1',116.50,116.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','17',101,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','17',102,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','18',103,'1','1',7204.52,7859.68,0.00,0.00,655.16,472200.76,0.00,0.00,0.00),('4','283','1','18',104,'2','1',2337.76,2337.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','18',105,'3','1',118.00,118.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','18',106,'4','1',116.50,116.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','18',107,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','18',108,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','19',109,'1','1',7859.68,10910.17,0.00,0.00,3050.49,2229235.64,0.00,0.00,0.00),('4','283','1','19',110,'2','1',2337.76,2337.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','19',111,'3','1',118.00,118.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','19',112,'4','1',116.50,116.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','19',113,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','19',114,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','20',115,'1','1',10910.17,0.00,0.00,0.00,519.01,378650.36,0.00,0.00,0.00),('4','283','1','20',116,'2','1',2337.76,0.00,0.00,0.00,162.50,115700.00,0.00,0.00,0.00),('4','283','1','20',117,'3','1',118.00,0.00,0.00,0.00,12.50,9200.00,0.00,0.00,0.00),('4','283','1','20',118,'4','1',116.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','20',119,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','283','1','20',120,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('4','283','1','1',730.00,760.00,0.00,18.50,13505.00,14060.00,555.00,1),('4','283','2','1',690.00,760.00,0.00,355.50,245295.00,267180.00,21885.00,2),('4','283','3','1',690.00,760.00,0.00,18.50,12765.00,14060.00,1295.00,3),('4','283','4','1',690.00,760.00,0.00,1511.00,1042590.00,1135860.00,93270.00,4),('4','283','5','1',690.00,760.00,0.00,95.50,65895.00,72580.00,6685.00,5),('4','283','6','1',690.00,760.00,0.00,757.76,522854.40,569397.60,46543.20,6),('4','283','7','1',690.00,760.00,0.00,1340.00,924600.00,1005400.00,80800.00,7),('4','283','8','1',690.00,736.00,0.00,962.00,707848.00,701452.00,-6396.00,8),('4','283','9','1',736.00,736.00,0.00,0.00,0.00,0.00,0.00,9),('4','283','10','1',736.00,760.00,0.00,9.00,6624.00,6624.00,0.00,10),('4','283','11','1',736.00,736.00,0.00,686.64,505367.04,504119.04,-1248.00,11),('4','283','12','1',736.00,736.00,0.00,420.99,309848.64,309523.64,-325.00,12),('4','283','13','1',736.00,736.00,0.00,857.81,631348.16,623652.16,-7696.00,13),('4','283','14','1',736.00,736.00,0.00,674.03,496086.08,494708.08,-1378.00,14),('4','283','15','1',736.00,736.00,0.00,592.42,436021.12,433434.12,-2587.00,15),('4','283','16','1',736.00,736.00,0.00,785.09,577826.24,569272.24,-8554.00,16),('4','283','17','1',736.00,736.00,0.00,692.04,509341.44,509341.44,0.00,17),('4','283','18','1',736.00,736.00,0.00,655.16,482197.76,472200.76,-9997.00,18),('4','283','19','1',736.00,736.00,0.00,3050.49,2245160.64,2229235.64,-15925.00,19),('4','283','20','1',736.00,736.00,0.00,694.01,510791.36,503550.36,-7241.00,20);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('4',1,'283','LPG PRODUCT ','Tank Containing LPG Product.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('4','283','1',1,1,'1','LPG TANK 1 & 2',60000.00,0.00,NULL,'TANK CONTAINING LPG PRODUCT','954','2022-09-12 19:19:03','2022-09-12 19:19:03','954',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'4','283',1,24683.56,'2023-03-17 16:57:11');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=705 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (1,'4','283',NULL,1,'Purchased from ALIKO OIL NIGERIA LTD.',0.00,18045600.00,24720.00,0.00,0.00,'2023-02-05 16:26:58','',''),(2,'4','283',NULL,1,'Reception corrector for bridging 2',0.00,0.00,0.00,24720.00,0.00,'2023-02-05 16:42:37','',''),(3,'4','283','1',1,'Received from bridging 2',0.00,0.00,24720.00,0.00,0.00,'2023-02-05 16:42:37','',''),(4,'4','283','1',1,'Retail Sale Id 1',4560.00,0.00,0.00,6.00,180.00,'2023-02-05 16:57:51','',''),(5,'4','283','1',1,'Retail Sale Id 1',9500.00,0.00,0.00,12.50,375.00,'2023-02-05 16:57:51','',''),(6,'4','283',NULL,1,'Purchased from ALIKO OIL NIGERIA LTD.',0.00,16656600.00,24140.00,0.00,0.00,'2023-02-06 14:34:04','',''),(7,'4','283',NULL,1,'Reception corrector for bridging 3',0.00,0.00,0.00,24140.00,0.00,'2023-02-06 14:38:54','',''),(8,'4','283','1',1,'Received from bridging 3',0.00,0.00,24140.00,0.00,0.00,'2023-02-06 14:38:54','',''),(9,'4','283','1',1,'Retail Sale Id 2',2280.00,0.00,0.00,3.00,210.00,'2023-02-06 14:54:41','',''),(10,'4','283','1',1,'Retail Sale Id 2',9500.00,0.00,0.00,12.50,875.00,'2023-02-06 14:54:41','',''),(11,'4','283','1',1,'Retail Sale Id 3',19000.00,0.00,0.00,25.00,1750.00,'2023-02-06 14:58:13','',''),(12,'4','283','1',1,'Retail Sale Id 4',11400.00,0.00,0.00,15.00,1050.00,'2023-02-06 15:02:09','',''),(13,'4','283','1',1,'Distributed to SABRIN GAS for sales id:1',6900000.00,0.00,0.00,10000.00,0.00,'2023-02-06 15:12:35','',''),(14,'4','283','1',1,'Retail Sale Id 5',225000.00,0.00,0.00,300.00,18000.00,'2023-02-06 15:16:53','',''),(15,'4','283','1',1,'Retail Sale Id 6',4560.00,0.00,0.00,6.00,420.00,'2023-02-11 13:04:49','',''),(16,'4','283','1',1,'Retail Sale Id 6',9500.00,0.00,0.00,12.50,875.00,'2023-02-11 13:04:49','',''),(17,'4','283','1',1,'Retail Sale Id 7',760.00,0.00,0.00,1.00,70.00,'2023-02-12 17:55:21','',''),(18,'4','283','1',1,'Retail Sale Id 7',760.00,0.00,0.00,1.00,70.00,'2023-02-12 17:55:21','',''),(19,'4','283','1',1,'Retail Sale Id 8',375000.00,0.00,0.00,500.00,30000.00,'2023-02-12 17:57:08','',''),(20,'4','283','1',1,'Retail Sale Id 9',95000.00,0.00,0.00,125.00,8750.00,'2023-02-12 18:19:17','',''),(21,'4','283','1',1,'Retail Sale Id 10',760.00,0.00,0.00,1.00,70.00,'2023-02-12 18:20:11','',''),(22,'4','283','1',1,'Retail Sale Id 13',11400.00,0.00,0.00,15.00,1050.00,'2023-02-12 18:22:48','',''),(23,'4','283','1',1,'Retail Sale Id 12',11400.00,0.00,0.00,15.00,1050.00,'2023-02-12 18:23:28','',''),(24,'4','283','1',1,'Retail Sale Id 14',7600.00,0.00,0.00,10.00,700.00,'2023-02-12 18:30:21','',''),(25,'4','283','1',1,'Retail Sale Id 15',38000.00,0.00,0.00,50.00,3500.00,'2023-02-12 18:32:46','',''),(26,'4','283','1',1,'Retail Sale Id 16',562500.00,0.00,0.00,750.00,45000.00,'2023-02-12 18:34:45','',''),(27,'4','283','1',1,'Retail Sale Id 11',11400.00,0.00,0.00,15.00,1050.00,'2023-02-12 18:35:52','',''),(28,'4','283','1',1,'Retail Sale Id 17',2280.00,0.00,0.00,3.00,210.00,'2023-02-12 18:59:40','',''),(29,'4','283','1',1,'Retail Sale Id 18',19000.00,0.00,0.00,25.00,1750.00,'2023-02-12 19:02:53','',''),(30,'4','283','1',1,'Retail Sale Id 19',11400.00,0.00,0.00,15.00,1050.00,'2023-02-12 19:12:44','',''),(31,'4','283','1',1,'Retail Sale Id 20',3800.00,0.00,0.00,5.00,350.00,'2023-02-12 19:15:35','',''),(32,'4','283','1',1,'Retail Sale Id 20',7600.00,0.00,0.00,10.00,700.00,'2023-02-12 19:15:35','',''),(33,'4','283','1',1,'Retail Sale Id 21',2280.00,0.00,0.00,3.00,210.00,'2023-02-12 19:18:12','',''),(34,'4','283','1',1,'Retail Sale Id 21',4560.00,0.00,0.00,6.00,420.00,'2023-02-12 19:18:12','',''),(35,'4','283','1',1,'Retail Sale Id 21',9500.00,0.00,0.00,12.50,875.00,'2023-02-12 19:18:12','',''),(36,'4','283','1',1,'Retail Sale Id 22',3800.00,0.00,0.00,5.00,350.00,'2023-02-12 19:21:52','',''),(37,'4','283','1',1,'Retail Sale Id 23',6840.00,0.00,0.00,9.00,630.00,'2023-02-12 19:35:59','',''),(38,'4','283','1',1,'Retail Sale Id 24',11400.00,0.00,0.00,15.00,1050.00,'2023-02-12 19:41:34','',''),(39,'4','283','1',1,'Retail Sale Id 25',11400.00,0.00,0.00,15.00,1050.00,'2023-02-12 19:43:29','',''),(40,'4','283','1',1,'Retail Sale Id 27',3800.00,0.00,0.00,5.00,350.00,'2023-02-13 10:34:04','',''),(41,'4','283','1',1,'Retail Sale Id 28',3997.60,0.00,0.00,5.26,368.20,'2023-02-13 10:47:17','',''),(42,'4','283','1',1,'Retail Sale Id 28',19000.00,0.00,0.00,25.00,1750.00,'2023-02-13 10:47:17','',''),(43,'4','283','1',1,'Retail Sale Id 31',760.00,0.00,0.00,1.00,70.00,'2023-02-13 12:04:44','',''),(44,'4','283','1',1,'Retail Sale Id 32',375000.00,0.00,0.00,500.00,30000.00,'2023-02-13 17:18:41','',''),(45,'4','283','1',1,'Retail Sale Id 33',112500.00,0.00,0.00,150.00,9000.00,'2023-02-13 17:20:54','',''),(46,'4','283','1',1,'Retail Sale Id 34',2280.00,0.00,0.00,3.00,210.00,'2023-02-13 17:27:10','',''),(47,'4','283','1',1,'Retail Sale Id 35',4560.00,0.00,0.00,6.00,420.00,'2023-02-13 21:49:17','',''),(48,'4','283','1',1,'Retail Sale Id 35',9500.00,0.00,0.00,12.50,875.00,'2023-02-13 21:49:17','',''),(49,'4','283','1',1,'Retail Sale Id 36',19000.00,0.00,0.00,25.00,1750.00,'2023-02-13 22:21:41','',''),(50,'4','283','1',1,'Retail Sale Id 37',19000.00,0.00,0.00,25.00,1750.00,'2023-02-13 22:44:32','',''),(51,'4','283','1',1,'Retail Sale Id 38',4560.00,0.00,0.00,6.00,420.00,'2023-02-14 10:40:54','',''),(52,'4','283','1',1,'Retail Sale Id 40',6840.00,0.00,0.00,9.00,630.00,'2023-02-14 14:10:06','',''),(53,'4','283','1',1,'Retail Sale Id 41',225000.00,0.00,0.00,300.00,18000.00,'2023-02-14 15:08:50','',''),(54,'4','283','1',1,'Retail Sale Id 42',375000.00,0.00,0.00,500.00,30000.00,'2023-02-14 18:09:07','',''),(55,'4','283','1',1,'Retail Sale Id 43',375000.00,0.00,0.00,500.00,30000.00,'2023-02-14 18:15:17','',''),(56,'4','283','1',1,'Retail Sale Id 44',19000.00,0.00,0.00,25.00,1750.00,'2023-02-15 10:28:11','',''),(57,'4','283','1',1,'Retail Sale Id 45',3040.00,0.00,0.00,4.00,280.00,'2023-02-16 13:34:39','',''),(58,'4','283',NULL,1,'2023-02-16 13:38:02',0.00,862178.24,0.00,0.00,0.00,'2023-02-16 13:38:02','',''),(59,'4','283','1',1,'Retail Sale Id 46',262500.00,0.00,0.00,350.00,4900.00,'2023-02-16 13:53:13','',''),(60,'4','283','1',1,'Retail Sale Id 47',70000.00,0.00,0.00,100.00,-3600.00,'2023-02-16 14:04:48','',''),(61,'4','283','1',1,'Retail Sale Id 48',760.00,0.00,0.00,1.00,24.00,'2023-02-16 14:19:20','',''),(62,'4','283','1',1,'Retail Sale Id 50',5152.00,0.00,0.00,7.00,0.00,'2023-02-16 14:46:59','',''),(63,'4','283','1',1,'Retail Sale Id 51',76000.00,0.00,0.00,100.00,2400.00,'2023-02-16 15:04:19','',''),(64,'4','283','1',1,'Retail Sale Id 52',177500.00,0.00,0.00,250.00,-6500.00,'2023-02-16 16:02:30','',''),(65,'4','283','1',1,'Retail Sale Id 53',106500.00,0.00,0.00,150.00,-3900.00,'2023-02-16 16:10:08','',''),(66,'4','283','1',1,'Retail Sale Id 54',6624.00,0.00,0.00,9.00,0.00,'2023-03-04 18:26:28','',''),(67,'4','283','1',1,'Retail Sale Id 55',9200.00,0.00,0.00,12.50,0.00,'2023-03-05 09:31:16','',''),(68,'4','283','1',1,'Retail Sale Id 56',4416.00,0.00,0.00,6.00,0.00,'2023-03-05 09:46:16','',''),(69,'4','283','1',1,'Retail Sale Id 57',4401.28,0.00,0.00,5.98,0.00,'2023-03-05 09:55:06','',''),(70,'4','283','1',1,'Retail Sale Id 58',897.92,0.00,0.00,1.22,0.00,'2023-03-05 09:57:31','',''),(71,'4','283','1',1,'Retail Sale Id 59',4416.00,0.00,0.00,6.00,0.00,'2023-03-05 10:00:38','',''),(72,'4','283','1',1,'Retail Sale Id 60',13616.00,0.00,0.00,18.50,0.00,'2023-03-05 10:48:54','',''),(73,'4','283','1',1,'Retail Sale Id 61',2208.00,0.00,0.00,3.00,0.00,'2023-03-05 10:52:37','',''),(74,'4','283','1',1,'Retail Sale Id 62',3680.00,0.00,0.00,5.00,0.00,'2023-03-05 10:54:44','',''),(75,'4','283','1',1,'Retail Sale Id 63',1501.44,0.00,0.00,2.04,0.00,'2023-03-05 10:58:10','',''),(76,'4','283','1',1,'Retail Sale Id 65',4997.44,0.00,0.00,6.79,0.00,'2023-03-05 11:11:31','',''),(77,'4','283','1',1,'Retail Sale Id 66',4416.00,0.00,0.00,6.00,0.00,'2023-03-05 11:13:11','',''),(78,'4','283','1',1,'Retail Sale Id 67',9200.00,0.00,0.00,12.50,0.00,'2023-03-05 11:15:23','',''),(79,'4','283','1',1,'Retail Sale Id 69',2208.00,0.00,0.00,3.00,0.00,'2023-03-05 11:17:10','',''),(80,'4','283','1',1,'Retail Sale Id 71',9200.00,0.00,0.00,12.50,0.00,'2023-03-05 11:18:33','',''),(81,'4','283','1',1,'Retail Sale Id 73',1472.00,0.00,0.00,2.00,0.00,'2023-03-05 11:21:45','',''),(82,'4','283','1',1,'Retail Sale Id 74',4416.00,0.00,0.00,6.00,0.00,'2023-03-05 11:23:52','',''),(83,'4','283','1',1,'Retail Sale Id 75',9200.00,0.00,0.00,12.50,0.00,'2023-03-05 11:25:21','',''),(84,'4','283','1',1,'Retail Sale Id 78',9200.00,0.00,0.00,12.50,0.00,'2023-03-05 11:32:57','',''),(85,'4','283','1',1,'Retail Sale Id 79',1472.00,0.00,0.00,2.00,0.00,'2023-03-05 11:34:31','',''),(86,'4','283','1',1,'Retail Sale Id 80',12880.00,0.00,0.00,17.50,0.00,'2023-03-05 11:52:54','',''),(87,'4','283','1',1,'Retail Sale Id 81',6624.00,0.00,0.00,9.00,0.00,'2023-03-05 11:54:55','',''),(88,'4','283','1',1,'Retail Sale Id 82',2252.16,0.00,0.00,3.06,0.00,'2023-03-05 11:57:38','',''),(89,'4','283','1',1,'Retail Sale Id 83',3680.00,0.00,0.00,5.00,0.00,'2023-03-05 12:02:20','',''),(90,'4','283','1',1,'Retail Sale Id 84',5888.00,0.00,0.00,8.00,0.00,'2023-03-05 12:09:57','',''),(91,'4','283','1',1,'Retail Sale Id 85',2208.00,0.00,0.00,3.00,0.00,'2023-03-05 12:13:12','',''),(92,'4','283','1',1,'Retail Sale Id 86',736.00,0.00,0.00,1.00,0.00,'2023-03-05 12:16:41','',''),(93,'4','283','1',1,'Retail Sale Id 87',3680.00,0.00,0.00,5.00,0.00,'2023-03-05 12:20:33','',''),(94,'4','283','1',1,'Retail Sale Id 88',1472.00,0.00,0.00,2.00,0.00,'2023-03-05 12:22:14','',''),(95,'4','283','1',1,'Retail Sale Id 89',2208.00,0.00,0.00,3.00,0.00,'2023-03-05 12:23:56','',''),(96,'4','283','1',1,'Retail Sale Id 90',5152.00,0.00,0.00,7.00,0.00,'2023-03-05 12:26:23','',''),(97,'4','283','1',1,'Retail Sale Id 92',6624.00,0.00,0.00,9.00,0.00,'2023-03-05 12:28:06','',''),(98,'4','283','1',1,'Retail Sale Id 93',2502.40,0.00,0.00,3.40,0.00,'2023-03-05 12:29:54','',''),(99,'4','283','1',1,'Retail Sale Id 94',4416.00,0.00,0.00,6.00,0.00,'2023-03-05 12:32:23','',''),(100,'4','283','1',1,'Retail Sale Id 96',2208.00,0.00,0.00,3.00,0.00,'2023-03-05 12:35:27','',''),(101,'4','283','1',1,'Retail Sale Id 97',1472.00,0.00,0.00,2.00,0.00,'2023-03-05 12:37:51','',''),(102,'4','283','1',1,'Retail Sale Id 98',3002.88,0.00,0.00,4.08,0.00,'2023-03-05 12:39:44','',''),(103,'4','283','1',1,'Retail Sale Id 99',2208.00,0.00,0.00,3.00,0.00,'2023-03-05 12:41:42','',''),(104,'4','283','1',1,'Retail Sale Id 100',9200.00,0.00,0.00,12.50,0.00,'2023-03-05 12:47:20','',''),(105,'4','283','1',1,'Retail Sale Id 101',7360.00,0.00,0.00,10.00,0.00,'2023-03-05 12:50:16','',''),(106,'4','283','1',1,'Retail Sale Id 102',2001.92,0.00,0.00,2.72,0.00,'2023-03-05 12:52:19','',''),(107,'4','283','1',1,'Retail Sale Id 104',1501.44,0.00,0.00,2.04,0.00,'2023-03-05 12:53:32','',''),(108,'4','283','1',1,'Retail Sale Id 106',34080.00,0.00,0.00,48.00,-1248.00,'2023-03-05 13:00:05','',''),(109,'4','283','1',1,'Retail Sale Id 107',4997.44,0.00,0.00,6.79,0.00,'2023-03-05 13:02:28','',''),(110,'4','283','1',1,'Retail Sale Id 109',9200.00,0.00,0.00,12.50,0.00,'2023-03-05 13:04:15','',''),(111,'4','283','1',1,'Retail Sale Id 111',3996.48,0.00,0.00,5.43,0.00,'2023-03-05 13:10:42','',''),(112,'4','283','1',1,'Retail Sale Id 112',9200.00,0.00,0.00,12.50,0.00,'2023-03-05 13:17:32','',''),(113,'4','283','1',1,'Retail Sale Id 113',8832.00,0.00,0.00,12.00,0.00,'2023-03-05 13:21:21','',''),(114,'4','283','1',1,'Retail Sale Id 114',3680.00,0.00,0.00,5.00,0.00,'2023-03-05 13:24:18','',''),(115,'4','283','1',1,'Retail Sale Id 116',2208.00,0.00,0.00,3.00,0.00,'2023-03-05 13:29:20','',''),(116,'4','283','1',1,'Retail Sale Id 117',2208.00,0.00,0.00,3.00,0.00,'2023-03-05 13:32:13','',''),(117,'4','283','1',1,'Retail Sale Id 118',3680.00,0.00,0.00,5.00,0.00,'2023-03-05 13:34:55','',''),(118,'4','283','1',1,'Retail Sale Id 119',2944.00,0.00,0.00,4.00,0.00,'2023-03-05 13:37:32','',''),(119,'4','283','1',1,'Retail Sale Id 120',2502.40,0.00,0.00,3.40,0.00,'2023-03-05 13:39:55','',''),(120,'4','283','1',1,'Retail Sale Id 121',3002.88,0.00,0.00,4.08,0.00,'2023-03-05 13:43:09','',''),(121,'4','283','1',1,'Retail Sale Id 122',736.00,0.00,0.00,1.00,0.00,'2023-03-05 13:45:44','',''),(122,'4','283','1',1,'Retail Sale Id 123',18400.00,0.00,0.00,25.00,0.00,'2023-03-05 13:47:49','',''),(123,'4','283','1',1,'Retail Sale Id 124',9200.00,0.00,0.00,12.50,0.00,'2023-03-05 13:50:17','',''),(124,'4','283','1',1,'Retail Sale Id 125',1000.96,0.00,0.00,1.36,0.00,'2023-03-05 13:52:36','',''),(125,'4','283','1',1,'Retail Sale Id 126',4416.00,0.00,0.00,6.00,0.00,'2023-03-05 13:59:02','',''),(126,'4','283','1',1,'Retail Sale Id 127',4416.00,0.00,0.00,6.00,0.00,'2023-03-05 14:01:08','',''),(127,'4','283','1',1,'Retail Sale Id 128',1501.44,0.00,0.00,2.04,0.00,'2023-03-05 17:03:50','',''),(128,'4','283','1',1,'Retail Sale Id 129',12880.00,0.00,0.00,17.50,0.00,'2023-03-05 17:07:41','',''),(129,'4','283','1',1,'Retail Sale Id 130',12144.00,0.00,0.00,16.50,0.00,'2023-03-05 17:10:11','',''),(130,'4','283','1',1,'Retail Sale Id 131',9200.00,0.00,0.00,12.50,0.00,'2023-03-05 17:12:49','',''),(131,'4','283','1',1,'Retail Sale Id 132',1472.00,0.00,0.00,2.00,0.00,'2023-03-05 17:19:09','',''),(132,'4','283','1',1,'Retail Sale Id 133',397.44,0.00,0.00,0.54,0.00,'2023-03-05 17:21:59','',''),(133,'4','283','1',1,'Retail Sale Id 134',7360.00,0.00,0.00,10.00,0.00,'2023-03-05 17:24:40','',''),(134,'4','283','1',1,'Retail Sale Id 135',3680.00,0.00,0.00,5.00,0.00,'2023-03-05 17:28:31','',''),(135,'4','283','1',1,'Retail Sale Id 136',736.00,0.00,0.00,1.00,0.00,'2023-03-05 17:30:35','',''),(136,'4','283','1',1,'Retail Sale Id 137',3680.00,0.00,0.00,5.00,0.00,'2023-03-05 17:33:04','',''),(137,'4','283','1',1,'Retail Sale Id 138',2944.00,0.00,0.00,4.00,0.00,'2023-03-05 17:35:45','',''),(138,'4','283','1',1,'Retail Sale Id 139',3680.00,0.00,0.00,5.00,0.00,'2023-03-05 17:40:47','',''),(139,'4','283','1',1,'Retail Sale Id 140',3680.00,0.00,0.00,5.00,0.00,'2023-03-05 17:42:49','',''),(140,'4','283','1',1,'Retail Sale Id 141',4416.00,0.00,0.00,6.00,0.00,'2023-03-05 17:44:55','',''),(141,'4','283','1',1,'Retail Sale Id 142',3680.00,0.00,0.00,5.00,0.00,'2023-03-05 17:47:32','',''),(142,'4','283','1',1,'Retail Sale Id 143',1000.96,0.00,0.00,1.36,0.00,'2023-03-05 17:49:56','',''),(143,'4','283','1',1,'Retail Sale Id 144',3002.88,0.00,0.00,4.08,0.00,'2023-03-05 17:52:37','',''),(144,'4','283','1',1,'Return of Retail Sale Id 144',0.00,3002.88,4.08,0.00,0.00,'2023-03-05 17:53:41','',''),(145,'4','283','1',1,'Retail Sale Id 145',9200.00,0.00,0.00,12.50,0.00,'2023-03-05 17:55:25','',''),(146,'4','283','1',1,'Return of Retail Sale Id 140',0.00,3680.00,5.00,0.00,0.00,'2023-03-05 17:58:23','',''),(147,'4','283','1',1,'Retail Sale Id 146',9200.00,0.00,0.00,12.50,0.00,'2023-03-06 08:03:35','',''),(148,'4','283','1',1,'Retail Sale Id 149',2208.00,0.00,0.00,3.00,0.00,'2023-03-06 08:06:45','',''),(149,'4','283','1',1,'Retail Sale Id 150',18400.00,0.00,0.00,25.00,0.00,'2023-03-06 08:08:27','',''),(150,'4','283','1',1,'Retail Sale Id 151',5998.40,0.00,0.00,8.15,0.00,'2023-03-06 08:10:33','',''),(151,'4','283','1',1,'Retail Sale Id 152',1472.00,0.00,0.00,2.00,0.00,'2023-03-06 08:13:58','',''),(152,'4','283','1',1,'Retail Sale Id 155',9200.00,0.00,0.00,12.50,0.00,'2023-03-06 08:16:15','',''),(153,'4','283','1',1,'Retail Sale Id 157',8832.00,0.00,0.00,12.00,0.00,'2023-03-06 08:18:01','',''),(154,'4','283','1',1,'Retail Sale Id 158',750.72,0.00,0.00,1.02,0.00,'2023-03-06 08:30:11','',''),(155,'4','283','1',1,'Retail Sale Id 159',6992.00,0.00,0.00,9.50,0.00,'2023-03-06 08:33:23','',''),(156,'4','283','1',1,'Retail Sale Id 160',8832.00,0.00,0.00,12.00,0.00,'2023-03-06 08:43:50','',''),(157,'4','283','1',1,'Retail Sale Id 162',2303.68,0.00,0.00,3.13,0.00,'2023-03-06 08:49:27','',''),(158,'4','283','1',1,'Retail Sale Id 164',3996.48,0.00,0.00,5.43,0.00,'2023-03-06 09:03:07','',''),(159,'4','283','1',1,'Retail Sale Id 165',2208.00,0.00,0.00,3.00,0.00,'2023-03-06 09:10:33','',''),(160,'4','283','1',1,'Retail Sale Id 166',4416.00,0.00,0.00,6.00,0.00,'2023-03-06 09:12:19','',''),(161,'4','283','1',1,'Retail Sale Id 167',3002.88,0.00,0.00,4.08,0.00,'2023-03-06 09:15:27','',''),(162,'4','283','1',1,'Retail Sale Id 168',2208.00,0.00,0.00,3.00,0.00,'2023-03-06 09:17:14','',''),(163,'4','283','1',1,'Retail Sale Id 169',11408.00,0.00,0.00,15.50,0.00,'2023-03-06 09:20:35','',''),(164,'4','283','1',1,'Retail Sale Id 170',2208.00,0.00,0.00,3.00,0.00,'2023-03-06 09:23:56','',''),(165,'4','283','1',1,'Retail Sale Id 171',4416.00,0.00,0.00,6.00,0.00,'2023-03-06 09:26:30','',''),(166,'4','283','1',1,'Retail Sale Id 172',9200.00,0.00,0.00,12.50,0.00,'2023-03-09 13:07:05','',''),(167,'4','283','1',1,'Retail Sale Id 173',3680.00,0.00,0.00,5.00,0.00,'2023-03-09 13:17:43','',''),(168,'4','283','1',1,'Retail Sale Id 174',2208.00,0.00,0.00,3.00,0.00,'2023-03-09 13:24:50','',''),(169,'4','283','1',1,'Retail Sale Id 175',2208.00,0.00,0.00,3.00,0.00,'2023-03-09 13:53:23','',''),(170,'4','283','1',1,'Retail Sale Id 176',4416.00,0.00,0.00,6.00,0.00,'2023-03-09 13:57:53','',''),(171,'4','283','1',1,'Retail Sale Id 177',6624.00,0.00,0.00,9.00,0.00,'2023-03-09 14:08:01','',''),(172,'4','283','1',1,'Retail Sale Id 178',3680.00,0.00,0.00,5.00,0.00,'2023-03-09 14:23:34','',''),(173,'4','283','1',1,'Retail Sale Id 179',9200.00,0.00,0.00,12.50,0.00,'2023-03-09 14:38:25','',''),(174,'4','283','1',1,'Retail Sale Id 180',18400.00,0.00,0.00,25.00,0.00,'2023-03-09 14:41:37','',''),(175,'4','283','1',1,'Retail Sale Id 181',4416.00,0.00,0.00,6.00,0.00,'2023-03-09 14:44:01','',''),(176,'4','283','1',1,'Retail Sale Id 182',4416.00,0.00,0.00,6.00,0.00,'2023-03-09 14:45:47','',''),(177,'4','283','1',1,'Retail Sale Id 183',8875.00,0.00,0.00,12.50,-325.00,'2023-03-09 14:53:59','',''),(178,'4','283','1',1,'Retail Sale Id 184',736.00,0.00,0.00,1.00,0.00,'2023-03-09 14:56:17','',''),(179,'4','283','1',1,'Retail Sale Id 185',2001.92,0.00,0.00,2.72,0.00,'2023-03-09 14:58:46','',''),(180,'4','283','1',1,'Retail Sale Id 186',3680.00,0.00,0.00,5.00,0.00,'2023-03-09 15:01:34','',''),(181,'4','283','1',1,'Retail Sale Id 187',2208.00,0.00,0.00,3.00,0.00,'2023-03-09 15:03:52','',''),(182,'4','283','1',1,'Retail Sale Id 188',2208.00,0.00,0.00,3.00,0.00,'2023-03-09 15:05:54','',''),(183,'4','283','1',1,'Retail Sale Id 189',3680.00,0.00,0.00,5.00,0.00,'2023-03-09 15:08:01','',''),(184,'4','283','1',1,'Retail Sale Id 190',4997.44,0.00,0.00,6.79,0.00,'2023-03-09 15:09:54','',''),(185,'4','283','1',1,'Retail Sale Id 191',2001.92,0.00,0.00,2.72,0.00,'2023-03-09 15:11:51','',''),(186,'4','283','1',1,'Retail Sale Id 192',2944.00,0.00,0.00,4.00,0.00,'2023-03-09 15:13:34','',''),(187,'4','283','1',1,'Retail Sale Id 193',2208.00,0.00,0.00,3.00,0.00,'2023-03-09 15:15:58','',''),(188,'4','283','1',1,'Retail Sale Id 194',4416.00,0.00,0.00,6.00,0.00,'2023-03-09 15:17:53','',''),(189,'4','283','1',1,'Retail Sale Id 195',3680.00,0.00,0.00,5.00,0.00,'2023-03-09 15:23:27','',''),(190,'4','283','1',1,'Retail Sale Id 196',13616.00,0.00,0.00,18.50,0.00,'2023-03-09 15:27:53','',''),(191,'4','283','1',1,'Retail Sale Id 197',5888.00,0.00,0.00,8.00,0.00,'2023-03-09 15:30:21','',''),(192,'4','283','1',1,'Retail Sale Id 198',2944.00,0.00,0.00,4.00,0.00,'2023-03-09 15:35:43','',''),(193,'4','283','1',1,'Retail Sale Id 199',9200.00,0.00,0.00,12.50,0.00,'2023-03-09 15:38:01','',''),(194,'4','283','1',1,'Retail Sale Id 200',2208.00,0.00,0.00,3.00,0.00,'2023-03-09 15:41:21','',''),(195,'4','283','1',1,'Retail Sale Id 201',7360.00,0.00,0.00,10.00,0.00,'2023-03-09 15:43:09','',''),(196,'4','283','1',1,'Retail Sale Id 202',4416.00,0.00,0.00,6.00,0.00,'2023-03-09 15:45:44','',''),(197,'4','283','1',1,'Retail Sale Id 205',4416.00,0.00,0.00,6.00,0.00,'2023-03-09 15:59:05','',''),(198,'4','283','1',1,'Retail Sale Id 206',5152.00,0.00,0.00,7.00,0.00,'2023-03-09 16:01:52','',''),(199,'4','283','1',1,'Retail Sale Id 207',9200.00,0.00,0.00,12.50,0.00,'2023-03-09 16:07:16','',''),(200,'4','283','1',1,'Retail Sale Id 209',3680.00,0.00,0.00,5.00,0.00,'2023-03-09 16:10:59','',''),(201,'4','283','1',1,'Retail Sale Id 210',7360.00,0.00,0.00,10.00,0.00,'2023-03-09 16:30:13','',''),(202,'4','283','1',1,'Retail Sale Id 212',1501.44,0.00,0.00,2.04,0.00,'2023-03-09 16:33:46','',''),(203,'4','283','1',1,'Retail Sale Id 213',15456.00,0.00,0.00,21.00,0.00,'2023-03-09 16:38:29','',''),(204,'4','283','1',1,'Retail Sale Id 214',2944.00,0.00,0.00,4.00,0.00,'2023-03-09 16:40:21','',''),(205,'4','283','1',1,'Retail Sale Id 215',4416.00,0.00,0.00,6.00,0.00,'2023-03-09 16:45:49','',''),(206,'4','283','1',1,'Retail Sale Id 216',27232.00,0.00,0.00,37.00,0.00,'2023-03-09 16:51:41','',''),(207,'4','283','1',1,'Retail Sale Id 217',3996.48,0.00,0.00,5.43,0.00,'2023-03-09 16:55:31','',''),(208,'4','283','1',1,'Retail Sale Id 218',3680.00,0.00,0.00,5.00,0.00,'2023-03-09 17:06:29','',''),(209,'4','283','1',1,'Retail Sale Id 219',2208.00,0.00,0.00,3.00,0.00,'2023-03-09 17:12:08','',''),(210,'4','283','1',1,'Retail Sale Id 220',3996.48,0.00,0.00,5.43,0.00,'2023-03-09 17:14:26','',''),(211,'4','283','1',1,'Retail Sale Id 221',4997.44,0.00,0.00,6.79,0.00,'2023-03-09 17:19:29','',''),(212,'4','283','1',1,'Retail Sale Id 222',4416.00,0.00,0.00,6.00,0.00,'2023-03-09 17:21:38','',''),(213,'4','283','1',1,'Retail Sale Id 223',2208.00,0.00,0.00,3.00,0.00,'2023-03-09 17:23:44','',''),(214,'4','283','1',1,'Retail Sale Id 224',8832.00,0.00,0.00,12.00,0.00,'2023-03-09 17:25:32','',''),(215,'4','283','1',1,'Retail Sale Id 225',9200.00,0.00,0.00,12.50,0.00,'2023-03-09 17:27:26','',''),(216,'4','283','1',1,'Retail Sale Id 226',1472.00,0.00,0.00,2.00,0.00,'2023-03-09 17:31:29','',''),(217,'4','283','1',1,'Retail Sale Id 227',1199.68,0.00,0.00,1.63,0.00,'2023-03-09 17:36:10','',''),(218,'4','283','1',1,'Retail Sale Id 228',1501.44,0.00,0.00,2.04,0.00,'2023-03-09 17:39:35','',''),(219,'4','283','1',1,'Retail Sale Id 229',4416.00,0.00,0.00,6.00,0.00,'2023-03-09 17:42:10','',''),(220,'4','283','1',1,'Retail Sale Id 230',9200.00,0.00,0.00,12.50,0.00,'2023-03-09 17:44:07','',''),(221,'4','283','1',1,'Retail Sale Id 231',2208.00,0.00,0.00,3.00,0.00,'2023-03-09 17:49:39','',''),(222,'4','283','1',1,'Retail Sale Id 232',2502.40,0.00,0.00,3.40,0.00,'2023-03-09 17:51:36','',''),(223,'4','283','1',1,'Retail Sale Id 233',4416.00,0.00,0.00,6.00,0.00,'2023-03-09 17:53:32','',''),(224,'4','283','1',1,'Retail Sale Id 234',1000.96,0.00,0.00,1.36,0.00,'2023-03-10 09:00:09','',''),(225,'4','283','1',1,'Retail Sale Id 235',6624.00,0.00,0.00,9.00,0.00,'2023-03-10 09:30:06','',''),(226,'4','283','1',1,'Retail Sale Id 236',9200.00,0.00,0.00,12.50,0.00,'2023-03-10 09:47:01','',''),(227,'4','283','1',1,'Retail Sale Id 237',4416.00,0.00,0.00,6.00,0.00,'2023-03-10 09:48:35','',''),(228,'4','283','1',1,'Retail Sale Id 238',13616.00,0.00,0.00,18.50,0.00,'2023-03-10 09:50:50','',''),(229,'4','283','1',1,'Retail Sale Id 239',3680.00,0.00,0.00,5.00,0.00,'2023-03-10 09:52:11','',''),(230,'4','283','1',1,'Retail Sale Id 240',2208.00,0.00,0.00,3.00,0.00,'2023-03-10 09:53:26','',''),(231,'4','283','1',1,'Retail Sale Id 241',2001.92,0.00,0.00,2.72,0.00,'2023-03-10 09:55:36','',''),(232,'4','283','1',1,'Retail Sale Id 243',4416.00,0.00,0.00,6.00,0.00,'2023-03-10 09:57:59','',''),(233,'4','283','1',1,'Retail Sale Id 245',8096.00,0.00,0.00,11.00,0.00,'2023-03-10 09:59:08','',''),(234,'4','283','1',1,'Retail Sale Id 246',2944.00,0.00,0.00,4.00,0.00,'2023-03-10 10:00:14','',''),(235,'4','283','1',1,'Retail Sale Id 247',1472.00,0.00,0.00,2.00,0.00,'2023-03-10 10:01:54','',''),(236,'4','283','1',1,'Retail Sale Id 248',8832.00,0.00,0.00,12.00,0.00,'2023-03-10 10:04:11','',''),(237,'4','283','1',1,'Retail Sale Id 249',2208.00,0.00,0.00,3.00,0.00,'2023-03-10 10:06:38','',''),(238,'4','283','1',1,'Retail Sale Id 251',9200.00,0.00,0.00,12.50,0.00,'2023-03-10 10:08:02','',''),(239,'4','283','1',1,'Retail Sale Id 252',1472.00,0.00,0.00,2.00,0.00,'2023-03-10 10:14:18','',''),(240,'4','283','1',1,'Retail Sale Id 253',4416.00,0.00,0.00,6.00,0.00,'2023-03-10 10:15:50','',''),(241,'4','283','1',1,'Retail Sale Id 254',4997.44,0.00,0.00,6.79,0.00,'2023-03-10 10:17:19','',''),(242,'4','283','1',1,'Retail Sale Id 255',4416.00,0.00,0.00,6.00,0.00,'2023-03-10 10:18:48','',''),(243,'4','283','1',1,'Retail Sale Id 257',9200.00,0.00,0.00,12.50,0.00,'2023-03-10 10:20:33','',''),(244,'4','283','1',1,'Retail Sale Id 258',2208.00,0.00,0.00,3.00,0.00,'2023-03-10 10:23:50','',''),(245,'4','283','1',1,'Retail Sale Id 259',9200.00,0.00,0.00,12.50,0.00,'2023-03-10 10:27:12','',''),(246,'4','283','1',1,'Retail Sale Id 260',4997.44,0.00,0.00,6.79,0.00,'2023-03-10 10:40:07','',''),(247,'4','283','1',1,'Retail Sale Id 262',2208.00,0.00,0.00,3.00,0.00,'2023-03-10 10:42:04','',''),(248,'4','283','1',1,'Retail Sale Id 264',2001.92,0.00,0.00,2.72,0.00,'2023-03-10 10:45:28','',''),(249,'4','283','1',1,'Retail Sale Id 266',71000.00,0.00,0.00,100.00,-2600.00,'2023-03-10 10:48:40','',''),(250,'4','283','1',1,'Retail Sale Id 268',9200.00,0.00,0.00,12.50,0.00,'2023-03-10 10:52:21','',''),(251,'4','283','1',1,'Retail Sale Id 269',1472.00,0.00,0.00,2.00,0.00,'2023-03-10 10:53:50','',''),(252,'4','283','1',1,'Retail Sale Id 270',9200.00,0.00,0.00,12.50,0.00,'2023-03-10 10:55:05','',''),(253,'4','283','1',1,'Retail Sale Id 272',1000.96,0.00,0.00,1.36,0.00,'2023-03-10 10:58:04','',''),(254,'4','283','1',1,'Retail Sale Id 273',5998.40,0.00,0.00,8.15,0.00,'2023-03-10 11:02:48','',''),(255,'4','283','1',1,'Retail Sale Id 274',9200.00,0.00,0.00,12.50,0.00,'2023-03-10 11:05:25','',''),(256,'4','283','1',1,'Retail Sale Id 275',2001.92,0.00,0.00,2.72,0.00,'2023-03-10 11:06:51','',''),(257,'4','283','1',1,'Retail Sale Id 276',68160.00,0.00,0.00,96.00,-2496.00,'2023-03-10 11:13:54','',''),(258,'4','283','1',1,'Retail Sale Id 278',9200.00,0.00,0.00,12.50,0.00,'2023-03-10 11:24:46','',''),(259,'4','283','1',1,'Retail Sale Id 280',2001.92,0.00,0.00,2.72,0.00,'2023-03-10 11:26:49','',''),(260,'4','283','1',1,'Retail Sale Id 281',2200.64,0.00,0.00,2.99,0.00,'2023-03-10 11:39:30','',''),(261,'4','283','1',1,'Retail Sale Id 283',3680.00,0.00,0.00,5.00,0.00,'2023-03-10 11:48:35','',''),(262,'4','283','1',1,'Retail Sale Id 284',6624.00,0.00,0.00,9.00,0.00,'2023-03-10 11:51:43','',''),(263,'4','283','1',1,'Retail Sale Id 286',1000.96,0.00,0.00,1.36,0.00,'2023-03-10 12:03:49','',''),(264,'4','283','1',1,'Retail Sale Id 287',9200.00,0.00,0.00,12.50,0.00,'2023-03-10 12:08:02','',''),(265,'4','283','1',1,'Retail Sale Id 289',3002.88,0.00,0.00,4.08,0.00,'2023-03-10 12:10:24','',''),(266,'4','283','1',1,'Retail Sale Id 290',3996.48,0.00,0.00,5.43,0.00,'2023-03-10 12:22:57','',''),(267,'4','283','1',1,'Retail Sale Id 292',2502.40,0.00,0.00,3.40,0.00,'2023-03-10 12:27:29','',''),(268,'4','283','1',1,'Retail Sale Id 293',3680.00,0.00,0.00,5.00,0.00,'2023-03-10 12:32:30','',''),(269,'4','283','1',1,'Retail Sale Id 294',2208.00,0.00,0.00,3.00,0.00,'2023-03-10 12:35:41','',''),(270,'4','283','1',1,'Retail Sale Id 295',4416.00,0.00,0.00,6.00,0.00,'2023-03-10 12:50:56','',''),(271,'4','283','1',1,'Retail Sale Id 296',18400.00,0.00,0.00,25.00,0.00,'2023-03-10 12:52:46','',''),(272,'4','283','1',1,'Retail Sale Id 297',2200.64,0.00,0.00,2.99,0.00,'2023-03-10 12:57:40','',''),(273,'4','283','1',1,'Retail Sale Id 298',3002.88,0.00,0.00,4.08,0.00,'2023-03-10 13:08:22','',''),(274,'4','283','1',1,'Retail Sale Id 300',9200.00,0.00,0.00,12.50,0.00,'2023-03-10 13:11:01','',''),(275,'4','283','1',1,'Retail Sale Id 301',35500.00,0.00,0.00,50.00,-1300.00,'2023-03-10 13:13:55','',''),(276,'4','283','1',1,'Retail Sale Id 302',1472.00,0.00,0.00,2.00,0.00,'2023-03-10 13:15:31','',''),(277,'4','283','1',1,'Retail Sale Id 303',9200.00,0.00,0.00,12.50,0.00,'2023-03-10 13:18:36','',''),(278,'4','283','1',1,'Retail Sale Id 304',3996.48,0.00,0.00,5.43,0.00,'2023-03-10 13:21:04','',''),(279,'4','283','1',1,'Retail Sale Id 306',11408.00,0.00,0.00,15.50,0.00,'2023-03-10 13:23:43','',''),(280,'4','283','1',1,'Retail Sale Id 307',8832.00,0.00,0.00,12.00,0.00,'2023-03-10 14:10:30','',''),(281,'4','283','1',1,'Retail Sale Id 308',2208.00,0.00,0.00,3.00,0.00,'2023-03-10 14:21:58','',''),(282,'4','283','1',1,'Retail Sale Id 309',2208.00,0.00,0.00,3.00,0.00,'2023-03-10 14:23:29','',''),(283,'4','283','1',1,'Retail Sale Id 310',4997.44,0.00,0.00,6.79,0.00,'2023-03-10 14:26:14','',''),(284,'4','283','1',1,'Retail Sale Id 311',4416.00,0.00,0.00,6.00,0.00,'2023-03-10 14:28:50','',''),(285,'4','283','1',1,'Retail Sale Id 312',9200.00,0.00,0.00,12.50,0.00,'2023-03-10 14:47:20','',''),(286,'4','283','1',1,'Retail Sale Id 313',9200.00,0.00,0.00,12.50,0.00,'2023-03-10 14:49:07','',''),(287,'4','283','1',1,'Retail Sale Id 315',11408.00,0.00,0.00,15.50,0.00,'2023-03-10 14:55:08','',''),(288,'4','283','1',1,'Retail Sale Id 316',2944.00,0.00,0.00,4.00,0.00,'2023-03-10 15:06:30','',''),(289,'4','283','1',1,'Retail Sale Id 318',9200.00,0.00,0.00,12.50,0.00,'2023-03-10 15:08:06','',''),(290,'4','283','1',1,'Retail Sale Id 321',2001.92,0.00,0.00,2.72,0.00,'2023-03-10 15:09:50','',''),(291,'4','283','1',1,'Retail Sale Id 322',12880.00,0.00,0.00,17.50,0.00,'2023-03-10 15:47:32','',''),(292,'4','283','1',1,'Retail Sale Id 324',3680.00,0.00,0.00,5.00,0.00,'2023-03-10 15:49:24','',''),(293,'4','283','1',1,'Retail Sale Id 325',4416.00,0.00,0.00,6.00,0.00,'2023-03-10 15:58:38','',''),(294,'4','283','1',1,'Retail Sale Id 327',2208.00,0.00,0.00,3.00,0.00,'2023-03-10 16:15:34','',''),(295,'4','283','1',1,'Retail Sale Id 329',7360.00,0.00,0.00,10.00,0.00,'2023-03-10 16:17:37','',''),(296,'4','283','1',1,'Retail Sale Id 330',2303.68,0.00,0.00,3.13,0.00,'2023-03-10 16:20:00','',''),(297,'4','283','1',1,'Retail Sale Id 331',8832.00,0.00,0.00,12.00,0.00,'2023-03-10 16:22:28','',''),(298,'4','283','1',1,'Retail Sale Id 332',9200.00,0.00,0.00,12.50,0.00,'2023-03-10 16:23:30','',''),(299,'4','283','1',1,'Retail Sale Id 333',3680.00,0.00,0.00,5.00,0.00,'2023-03-10 16:25:00','',''),(300,'4','283','1',1,'Retail Sale Id 334',9200.00,0.00,0.00,12.50,0.00,'2023-03-10 16:34:09','',''),(301,'4','283','1',1,'Retail Sale Id 335',4416.00,0.00,0.00,6.00,0.00,'2023-03-10 16:38:01','',''),(302,'4','283','1',1,'Retail Sale Id 336',3002.88,0.00,0.00,4.08,0.00,'2023-03-10 16:39:31','',''),(303,'4','283','1',1,'Retail Sale Id 337',35500.00,0.00,0.00,50.00,-1300.00,'2023-03-10 17:35:52','',''),(304,'4','283','1',1,'Retail Sale Id 339',4416.00,0.00,0.00,6.00,0.00,'2023-03-11 09:45:10','',''),(305,'4','283','1',1,'Retail Sale Id 340',2208.00,0.00,0.00,3.00,0.00,'2023-03-11 10:54:14','',''),(306,'4','283','1',1,'Retail Sale Id 342',2208.00,0.00,0.00,3.00,0.00,'2023-03-11 10:57:12','',''),(307,'4','283','1',1,'Retail Sale Id 344',5299.20,0.00,0.00,7.20,0.00,'2023-03-11 11:24:42','',''),(308,'4','283','1',1,'Retail Sale Id 345',5888.00,0.00,0.00,8.00,0.00,'2023-03-11 11:27:29','',''),(309,'4','283','1',1,'Retail Sale Id 346',1501.44,0.00,0.00,2.04,0.00,'2023-03-11 11:32:33','',''),(310,'4','283','1',1,'Retail Sale Id 347',9200.00,0.00,0.00,12.50,0.00,'2023-03-11 11:37:08','',''),(311,'4','283','1',1,'Retail Sale Id 348',3996.48,0.00,0.00,5.43,0.00,'2023-03-11 11:40:42','',''),(312,'4','283','1',1,'Retail Sale Id 349',2944.00,0.00,0.00,4.00,0.00,'2023-03-11 11:45:05','',''),(313,'4','283','1',1,'Retail Sale Id 350',4416.00,0.00,0.00,6.00,0.00,'2023-03-11 11:56:01','',''),(314,'4','283','1',1,'Retail Sale Id 351',4416.00,0.00,0.00,6.00,0.00,'2023-03-11 12:02:07','',''),(315,'4','283','1',1,'Retail Sale Id 352',1472.00,0.00,0.00,2.00,0.00,'2023-03-11 12:20:16','',''),(316,'4','283','1',1,'Retail Sale Id 353',9200.00,0.00,0.00,12.50,0.00,'2023-03-11 12:24:31','',''),(317,'4','283','1',1,'Retail Sale Id 354',9200.00,0.00,0.00,12.50,0.00,'2023-03-11 12:26:57','',''),(318,'4','283','1',1,'Retail Sale Id 355',1000.96,0.00,0.00,1.36,0.00,'2023-03-11 12:28:41','',''),(319,'4','283','1',1,'Retail Sale Id 356',2208.00,0.00,0.00,3.00,0.00,'2023-03-11 12:31:43','',''),(320,'4','283','1',1,'Retail Sale Id 357',4997.44,0.00,0.00,6.79,0.00,'2023-03-11 12:34:51','',''),(321,'4','283','1',1,'Retail Sale Id 358',736.00,0.00,0.00,1.00,0.00,'2023-03-11 12:42:26','',''),(322,'4','283','1',1,'Retail Sale Id 359',3002.88,0.00,0.00,4.08,0.00,'2023-03-11 12:46:17','',''),(323,'4','283','1',1,'Retail Sale Id 360',2208.00,0.00,0.00,3.00,0.00,'2023-03-11 12:52:33','',''),(324,'4','283','1',1,'Retail Sale Id 361',9200.00,0.00,0.00,12.50,0.00,'2023-03-11 12:54:57','',''),(325,'4','283','1',1,'Retail Sale Id 362',9568.00,0.00,0.00,13.00,0.00,'2023-03-11 12:59:39','',''),(326,'4','283','1',1,'Retail Sale Id 363',11040.00,0.00,0.00,15.00,0.00,'2023-03-11 13:02:26','',''),(327,'4','283','1',1,'Retail Sale Id 364',35500.00,0.00,0.00,50.00,-1300.00,'2023-03-11 13:12:15','',''),(328,'4','283','1',1,'Retail Sale Id 365',9200.00,0.00,0.00,12.50,0.00,'2023-03-11 13:14:20','',''),(329,'4','283','1',1,'Retail Sale Id 366',9200.00,0.00,0.00,12.50,0.00,'2023-03-11 13:17:57','',''),(330,'4','283','1',1,'Retail Sale Id 367',9200.00,0.00,0.00,12.50,0.00,'2023-03-11 13:27:24','',''),(331,'4','283','1',1,'Retail Sale Id 368',6624.00,0.00,0.00,9.00,0.00,'2023-03-11 13:35:32','',''),(332,'4','283','1',1,'Retail Sale Id 369',4997.44,0.00,0.00,6.79,0.00,'2023-03-11 13:44:15','',''),(333,'4','283','1',1,'Retail Sale Id 370',1472.00,0.00,0.00,2.00,0.00,'2023-03-11 13:48:01','',''),(334,'4','283','1',1,'Retail Sale Id 371',9200.00,0.00,0.00,12.50,0.00,'2023-03-11 13:51:32','',''),(335,'4','283','1',1,'Retail Sale Id 372',1472.00,0.00,0.00,2.00,0.00,'2023-03-11 13:57:47','',''),(336,'4','283','1',1,'Retail Sale Id 373',2208.00,0.00,0.00,3.00,0.00,'2023-03-11 14:00:50','',''),(337,'4','283','1',1,'Retail Sale Id 375',4416.00,0.00,0.00,6.00,0.00,'2023-03-11 14:03:35','',''),(338,'4','283','1',1,'Retail Sale Id 376',3680.00,0.00,0.00,5.00,0.00,'2023-03-11 14:05:54','',''),(339,'4','283','1',1,'Retail Sale Id 377',8832.00,0.00,0.00,12.00,0.00,'2023-03-11 14:20:08','',''),(340,'4','283','1',1,'Retail Sale Id 378',9200.00,0.00,0.00,12.50,0.00,'2023-03-11 14:22:21','',''),(341,'4','283','1',1,'Retail Sale Id 379',2208.00,0.00,0.00,3.00,0.00,'2023-03-11 14:25:01','',''),(342,'4','283','1',1,'Retail Sale Id 380',9200.00,0.00,0.00,12.50,0.00,'2023-03-11 14:27:25','',''),(343,'4','283','1',1,'Retail Sale Id 381',2130.00,0.00,0.00,3.00,-78.00,'2023-03-11 14:30:48','',''),(344,'4','283','1',1,'Retail Sale Id 382',2208.00,0.00,0.00,3.00,0.00,'2023-03-11 14:33:20','',''),(345,'4','283','1',1,'Retail Sale Id 383',2944.00,0.00,0.00,4.00,0.00,'2023-03-11 14:35:54','',''),(346,'4','283','1',1,'Retail Sale Id 384',5152.00,0.00,0.00,7.00,0.00,'2023-03-11 14:38:39','',''),(347,'4','283','1',1,'Retail Sale Id 385',9200.00,0.00,0.00,12.50,0.00,'2023-03-11 14:42:37','',''),(348,'4','283','1',1,'Retail Sale Id 386',9200.00,0.00,0.00,12.50,0.00,'2023-03-11 14:46:11','',''),(349,'4','283','1',1,'Retail Sale Id 387',2001.92,0.00,0.00,2.72,0.00,'2023-03-11 14:57:22','',''),(350,'4','283','1',1,'Retail Sale Id 388',8832.00,0.00,0.00,12.00,0.00,'2023-03-11 15:00:37','',''),(351,'4','283','1',1,'Retail Sale Id 389',7360.00,0.00,0.00,10.00,0.00,'2023-03-11 15:12:40','',''),(352,'4','283','1',1,'Retail Sale Id 390',9200.00,0.00,0.00,12.50,0.00,'2023-03-11 15:22:44','',''),(353,'4','283','1',1,'Retail Sale Id 391',4416.00,0.00,0.00,6.00,0.00,'2023-03-11 15:34:14','',''),(354,'4','283','1',1,'Retail Sale Id 392',4416.00,0.00,0.00,6.00,0.00,'2023-03-11 15:41:50','',''),(355,'4','283','1',1,'Retail Sale Id 393',2944.00,0.00,0.00,4.00,0.00,'2023-03-11 15:44:23','',''),(356,'4','283','1',1,'Retail Sale Id 394',4401.28,0.00,0.00,5.98,0.00,'2023-03-11 15:48:20','',''),(357,'4','283','1',1,'Retail Sale Id 395',4496.96,0.00,0.00,6.11,0.00,'2023-03-11 15:50:43','',''),(358,'4','283','1',1,'Retail Sale Id 396',1501.44,0.00,0.00,2.04,0.00,'2023-03-11 15:52:46','',''),(359,'4','283','1',1,'Retail Sale Id 397',3680.00,0.00,0.00,5.00,0.00,'2023-03-11 15:55:06','',''),(360,'4','283','1',1,'Retail Sale Id 398',3680.00,0.00,0.00,5.00,0.00,'2023-03-11 15:56:50','',''),(361,'4','283','1',1,'Retail Sale Id 399',1000.96,0.00,0.00,1.36,0.00,'2023-03-11 15:59:59','',''),(362,'4','283','1',1,'Retail Sale Id 400',8832.00,0.00,0.00,12.00,0.00,'2023-03-11 16:01:52','',''),(363,'4','283','1',1,'Retail Sale Id 401',2208.00,0.00,0.00,3.00,0.00,'2023-03-11 16:03:59','',''),(364,'4','283','1',1,'Retail Sale Id 403',3996.48,0.00,0.00,5.43,0.00,'2023-03-11 16:09:33','',''),(365,'4','283','1',1,'Retail Sale Id 404',4416.00,0.00,0.00,6.00,0.00,'2023-03-11 16:18:35','',''),(366,'4','283','1',1,'Retail Sale Id 405',8096.00,0.00,0.00,11.00,0.00,'2023-03-11 16:21:26','',''),(367,'4','283','1',1,'Retail Sale Id 406',9200.00,0.00,0.00,12.50,0.00,'2023-03-11 16:23:23','',''),(368,'4','283','1',1,'Retail Sale Id 407',4997.44,0.00,0.00,6.79,0.00,'2023-03-11 16:28:29','',''),(369,'4','283','1',1,'Retail Sale Id 408',3002.88,0.00,0.00,4.08,0.00,'2023-03-11 16:31:50','',''),(370,'4','283','1',1,'Retail Sale Id 409',8832.00,0.00,0.00,12.00,0.00,'2023-03-11 16:35:26','',''),(371,'4','283','1',1,'Retail Sale Id 410',9200.00,0.00,0.00,12.50,0.00,'2023-03-11 16:39:38','',''),(372,'4','283','1',1,'Retail Sale Id 411',9200.00,0.00,0.00,12.50,0.00,'2023-03-11 16:42:22','',''),(373,'4','283','1',1,'Retail Sale Id 412',3680.00,0.00,0.00,5.00,0.00,'2023-03-11 16:46:15','',''),(374,'4','283','1',1,'Retail Sale Id 413',4997.44,0.00,0.00,6.79,0.00,'2023-03-11 16:48:28','',''),(375,'4','283','1',1,'Retail Sale Id 414',8832.00,0.00,0.00,12.00,0.00,'2023-03-11 16:52:24','',''),(376,'4','283','1',1,'Retail Sale Id 415',3680.00,0.00,0.00,5.00,0.00,'2023-03-11 16:54:48','',''),(377,'4','283','1',1,'Retail Sale Id 416',4416.00,0.00,0.00,6.00,0.00,'2023-03-11 17:03:33','',''),(378,'4','283','1',1,'Retail Sale Id 417',4416.00,0.00,0.00,6.00,0.00,'2023-03-11 17:06:36','',''),(379,'4','283','1',1,'Retail Sale Id 418',9200.00,0.00,0.00,12.50,0.00,'2023-03-11 17:10:18','',''),(380,'4','283','1',1,'Retail Sale Id 419',1501.44,0.00,0.00,2.04,0.00,'2023-03-11 17:14:27','',''),(381,'4','283','1',1,'Retail Sale Id 420',2208.00,0.00,0.00,3.00,0.00,'2023-03-11 17:17:20','',''),(382,'4','283','1',1,'Retail Sale Id 421',1472.00,0.00,0.00,2.00,0.00,'2023-03-11 17:20:14','',''),(383,'4','283','1',1,'Retail Sale Id 422',9200.00,0.00,0.00,12.50,0.00,'2023-03-11 17:22:13','',''),(384,'4','283','1',1,'Retail Sale Id 423',9200.00,0.00,0.00,12.50,0.00,'2023-03-11 17:28:54','',''),(385,'4','283','1',1,'Retail Sale Id 424',6624.00,0.00,0.00,9.00,0.00,'2023-03-11 17:30:51','',''),(386,'4','283','1',1,'Retail Sale Id 425',2208.00,0.00,0.00,3.00,0.00,'2023-03-11 17:35:11','',''),(387,'4','283','1',1,'Retail Sale Id 426',9200.00,0.00,0.00,12.50,0.00,'2023-03-11 17:37:52','',''),(388,'4','283','1',1,'Retail Sale Id 427',2944.00,0.00,0.00,4.00,0.00,'2023-03-11 17:40:38','',''),(389,'4','283','1',1,'Retail Sale Id 428',2208.00,0.00,0.00,3.00,0.00,'2023-03-11 17:43:18','',''),(390,'4','283','1',1,'Retail Sale Id 429',2208.00,0.00,0.00,3.00,0.00,'2023-03-11 17:48:04','',''),(391,'4','283','1',1,'Retail Sale Id 430',4416.00,0.00,0.00,6.00,0.00,'2023-03-11 17:51:53','',''),(392,'4','283','1',1,'Retail Sale Id 431',4416.00,0.00,0.00,6.00,0.00,'2023-03-11 17:57:56','',''),(393,'4','283','1',1,'Retail Sale Id 432',3002.88,0.00,0.00,4.08,0.00,'2023-03-12 10:35:46','',''),(394,'4','283','1',1,'Retail Sale Id 433',3002.88,0.00,0.00,4.08,0.00,'2023-03-12 10:41:27','',''),(395,'4','283','1',1,'Retail Sale Id 435',3680.00,0.00,0.00,5.00,0.00,'2023-03-12 10:43:41','',''),(396,'4','283','1',1,'Retail Sale Id 436',2208.00,0.00,0.00,3.00,0.00,'2023-03-12 10:48:38','',''),(397,'4','283','1',1,'Retail Sale Id 437',9200.00,0.00,0.00,12.50,0.00,'2023-03-12 11:05:29','',''),(398,'4','283','1',1,'Retail Sale Id 438',3680.00,0.00,0.00,5.00,0.00,'2023-03-12 11:06:57','',''),(399,'4','283','1',1,'Retail Sale Id 440',4416.00,0.00,0.00,6.00,0.00,'2023-03-12 11:08:27','',''),(400,'4','283','1',1,'Retail Sale Id 441',9200.00,0.00,0.00,12.50,0.00,'2023-03-12 11:10:19','',''),(401,'4','283','1',1,'Retail Sale Id 442',7499.84,0.00,0.00,10.19,0.00,'2023-03-12 11:13:00','',''),(402,'4','283','1',1,'Retail Sale Id 443',8832.00,0.00,0.00,12.00,0.00,'2023-03-12 11:14:49','',''),(403,'4','283','1',1,'Retail Sale Id 444',2208.00,0.00,0.00,3.00,0.00,'2023-03-12 11:16:16','',''),(404,'4','283','1',1,'Retail Sale Id 445',9200.00,0.00,0.00,12.50,0.00,'2023-03-12 11:27:06','',''),(405,'4','283','1',1,'Retail Sale Id 446',4416.00,0.00,0.00,6.00,0.00,'2023-03-12 11:31:39','',''),(406,'4','283','1',1,'Retail Sale Id 447',1501.44,0.00,0.00,2.04,0.00,'2023-03-12 11:33:50','',''),(407,'4','283','1',1,'Retail Sale Id 451',1472.00,0.00,0.00,2.00,0.00,'2023-03-12 11:38:59','',''),(408,'4','283','1',1,'Retail Sale Id 452',2208.00,0.00,0.00,3.00,0.00,'2023-03-12 11:40:26','',''),(409,'4','283','1',1,'Retail Sale Id 454',9200.00,0.00,0.00,12.50,0.00,'2023-03-12 11:42:57','',''),(410,'4','283','1',1,'Retail Sale Id 455',1000.96,0.00,0.00,1.36,0.00,'2023-03-12 11:45:20','',''),(411,'4','283','1',1,'Retail Sale Id 456',2944.00,0.00,0.00,4.00,0.00,'2023-03-12 11:47:03','',''),(412,'4','283','1',1,'Retail Sale Id 459',11776.00,0.00,0.00,16.00,0.00,'2023-03-12 11:52:39','',''),(413,'4','283','1',1,'Retail Sale Id 461',8000.32,0.00,0.00,10.87,0.00,'2023-03-12 11:55:39','',''),(414,'4','283','1',1,'Retail Sale Id 462',9200.00,0.00,0.00,12.50,0.00,'2023-03-12 12:01:27','',''),(415,'4','283','1',1,'Retail Sale Id 463',1501.44,0.00,0.00,2.04,0.00,'2023-03-12 12:04:30','',''),(416,'4','283','1',1,'Retail Sale Id 465',7360.00,0.00,0.00,10.00,0.00,'2023-03-12 12:06:27','',''),(417,'4','283','1',1,'Retail Sale Id 466',4416.00,0.00,0.00,6.00,0.00,'2023-03-12 12:08:01','',''),(418,'4','283','1',1,'Retail Sale Id 468',3680.00,0.00,0.00,5.00,0.00,'2023-03-12 12:09:45','',''),(419,'4','283','1',1,'Retail Sale Id 469',8832.00,0.00,0.00,12.00,0.00,'2023-03-12 12:11:16','',''),(420,'4','283','1',1,'Retail Sale Id 471',2208.00,0.00,0.00,3.00,0.00,'2023-03-12 12:13:17','',''),(421,'4','283','1',1,'Retail Sale Id 472',4416.00,0.00,0.00,6.00,0.00,'2023-03-12 12:17:19','',''),(422,'4','283','1',1,'Retail Sale Id 474',1398.40,0.00,0.00,1.90,0.00,'2023-03-12 12:21:28','',''),(423,'4','283','1',1,'Retail Sale Id 475',12144.00,0.00,0.00,16.50,0.00,'2023-03-12 12:26:36','',''),(424,'4','283','1',1,'Retail Sale Id 476',2200.64,0.00,0.00,2.99,0.00,'2023-03-12 12:28:16','',''),(425,'4','283','1',1,'Retail Sale Id 479',3002.88,0.00,0.00,4.08,0.00,'2023-03-12 12:31:54','',''),(426,'4','283','1',1,'Retail Sale Id 480',4416.00,0.00,0.00,6.00,0.00,'2023-03-12 12:33:21','',''),(427,'4','283','1',1,'Retail Sale Id 481',9568.00,0.00,0.00,13.00,0.00,'2023-03-12 12:36:12','',''),(428,'4','283','1',1,'Retail Sale Id 483',4416.00,0.00,0.00,6.00,0.00,'2023-03-12 12:37:13','',''),(429,'4','283','1',1,'Retail Sale Id 484',8832.00,0.00,0.00,12.00,0.00,'2023-03-12 12:38:45','',''),(430,'4','283','1',1,'Retail Sale Id 487',4416.00,0.00,0.00,6.00,0.00,'2023-03-12 12:40:46','',''),(431,'4','283','1',1,'Retail Sale Id 489',9200.00,0.00,0.00,12.50,0.00,'2023-03-12 12:47:56','',''),(432,'4','283','1',1,'Retail Sale Id 490',8832.00,0.00,0.00,12.00,0.00,'2023-03-12 12:50:00','',''),(433,'4','283','1',1,'Retail Sale Id 491',13616.00,0.00,0.00,18.50,0.00,'2023-03-12 12:54:52','',''),(434,'4','283','1',1,'Retail Sale Id 492',9200.00,0.00,0.00,12.50,0.00,'2023-03-12 12:57:10','',''),(435,'4','283','1',1,'Retail Sale Id 493',2208.00,0.00,0.00,3.00,0.00,'2023-03-12 12:59:48','',''),(436,'4','283','1',1,'Retail Sale Id 495',2001.92,0.00,0.00,2.72,0.00,'2023-03-12 13:07:38','',''),(437,'4','283','1',1,'Retail Sale Id 496',6624.00,0.00,0.00,9.00,0.00,'2023-03-12 13:11:55','',''),(438,'4','283','1',1,'Retail Sale Id 497',2208.00,0.00,0.00,3.00,0.00,'2023-03-12 13:14:45','',''),(439,'4','283','1',1,'Retail Sale Id 499',5998.40,0.00,0.00,8.15,0.00,'2023-03-12 13:17:15','',''),(440,'4','283','1',1,'Retail Sale Id 500',3680.00,0.00,0.00,5.00,0.00,'2023-03-12 13:19:47','',''),(441,'4','283','1',1,'Retail Sale Id 501',5888.00,0.00,0.00,8.00,0.00,'2023-03-12 13:22:34','',''),(442,'4','283','1',1,'Retail Sale Id 504',4416.00,0.00,0.00,6.00,0.00,'2023-03-12 13:26:05','',''),(443,'4','283','1',1,'Retail Sale Id 505',17750.00,0.00,0.00,25.00,-650.00,'2023-03-12 13:32:48','',''),(444,'4','283','1',1,'Retail Sale Id 508',44020.00,0.00,0.00,62.00,-1612.00,'2023-03-12 13:45:23','',''),(445,'4','283','1',1,'Retail Sale Id 509',1472.00,0.00,0.00,2.00,0.00,'2023-03-12 14:09:31','',''),(446,'4','283','1',1,'Retail Sale Id 510',2208.00,0.00,0.00,3.00,0.00,'2023-03-12 14:11:38','',''),(447,'4','283','1',1,'Retail Sale Id 511',736.00,0.00,0.00,1.00,0.00,'2023-03-12 14:14:41','',''),(448,'4','283','1',1,'Retail Sale Id 512',9200.00,0.00,0.00,12.50,0.00,'2023-03-12 14:22:28','',''),(449,'4','283','1',1,'Retail Sale Id 513',1472.00,0.00,0.00,2.00,0.00,'2023-03-12 14:26:39','',''),(450,'4','283','1',1,'Retail Sale Id 514',736.00,0.00,0.00,1.00,0.00,'2023-03-12 14:29:56','',''),(451,'4','283','1',1,'Retail Sale Id 515',4416.00,0.00,0.00,6.00,0.00,'2023-03-12 14:52:22','',''),(452,'4','283','1',1,'Retail Sale Id 516',2001.92,0.00,0.00,2.72,0.00,'2023-03-12 15:22:55','',''),(453,'4','283','1',1,'Retail Sale Id 518',7396.80,0.00,0.00,10.05,0.00,'2023-03-12 15:26:39','',''),(454,'4','283','1',1,'Retail Sale Id 519',9200.00,0.00,0.00,12.50,0.00,'2023-03-12 15:29:03','',''),(455,'4','283','1',1,'Retail Sale Id 520',2001.92,0.00,0.00,2.72,0.00,'2023-03-12 15:30:56','',''),(456,'4','283','1',1,'Retail Sale Id 523',4416.00,0.00,0.00,6.00,0.00,'2023-03-12 15:40:53','',''),(457,'4','283','1',1,'Retail Sale Id 525',2208.00,0.00,0.00,3.00,0.00,'2023-03-12 15:42:42','',''),(458,'4','283','1',1,'Retail Sale Id 526',4416.00,0.00,0.00,6.00,0.00,'2023-03-12 15:44:48','',''),(459,'4','283','1',1,'Retail Sale Id 527',1472.00,0.00,0.00,2.00,0.00,'2023-03-12 15:54:24','',''),(460,'4','283','1',1,'Retail Sale Id 528',3680.00,0.00,0.00,5.00,0.00,'2023-03-12 16:03:25','',''),(461,'4','283','1',1,'Retail Sale Id 529',4416.00,0.00,0.00,6.00,0.00,'2023-03-12 16:05:18','',''),(462,'4','283','1',1,'Retail Sale Id 531',9200.00,0.00,0.00,12.50,0.00,'2023-03-12 16:20:54','',''),(463,'4','283','1',1,'Retail Sale Id 532',4416.00,0.00,0.00,6.00,0.00,'2023-03-12 16:30:18','',''),(464,'4','283','1',1,'Retail Sale Id 533',8875.00,0.00,0.00,12.50,-325.00,'2023-03-12 16:33:33','',''),(465,'4','283','1',1,'Retail Sale Id 534',3996.48,0.00,0.00,5.43,0.00,'2023-03-12 16:37:04','',''),(466,'4','283','1',1,'Retail Sale Id 535',9200.00,0.00,0.00,12.50,0.00,'2023-03-12 16:41:07','',''),(467,'4','283','1',1,'Retail Sale Id 536',40825.00,0.00,0.00,57.50,-1495.00,'2023-03-13 08:21:46','',''),(468,'4','283','1',1,'Retail Sale Id 537',9200.00,0.00,0.00,12.50,0.00,'2023-03-13 08:23:47','',''),(469,'4','283','1',1,'Retail Sale Id 538',3996.48,0.00,0.00,5.43,0.00,'2023-03-13 08:25:37','',''),(470,'4','283','1',1,'Retail Sale Id 540',3550.00,0.00,0.00,5.00,-130.00,'2023-03-13 08:29:22','',''),(471,'4','283','1',1,'Retail Sale Id 541',6624.00,0.00,0.00,9.00,0.00,'2023-03-13 08:32:43','',''),(472,'4','283','1',1,'Retail Sale Id 542',3680.00,0.00,0.00,5.00,0.00,'2023-03-13 08:34:05','',''),(473,'4','283','1',1,'Retail Sale Id 544',5152.00,0.00,0.00,7.00,0.00,'2023-03-13 08:35:35','',''),(474,'4','283','1',1,'Retail Sale Id 545',9200.00,0.00,0.00,12.50,0.00,'2023-03-13 08:37:14','',''),(475,'4','283','1',1,'Retail Sale Id 547',736.00,0.00,0.00,1.00,0.00,'2023-03-13 08:40:04','',''),(476,'4','283','1',1,'Retail Sale Id 548',1000.96,0.00,0.00,1.36,0.00,'2023-03-13 08:41:38','',''),(477,'4','283','1',1,'Retail Sale Id 549',12880.00,0.00,0.00,17.50,0.00,'2023-03-13 08:45:21','',''),(478,'4','283','1',1,'Retail Sale Id 550',2208.00,0.00,0.00,3.00,0.00,'2023-03-13 08:46:40','',''),(479,'4','283','1',1,'Retail Sale Id 551',4416.00,0.00,0.00,6.00,0.00,'2023-03-13 08:48:25','',''),(480,'4','283','1',1,'Retail Sale Id 552',2208.00,0.00,0.00,3.00,0.00,'2023-03-13 08:49:50','',''),(481,'4','283','1',1,'Retail Sale Id 553',8832.00,0.00,0.00,12.00,0.00,'2023-03-13 08:51:05','',''),(482,'4','283','1',1,'Retail Sale Id 554',2208.00,0.00,0.00,3.00,0.00,'2023-03-13 08:52:54','',''),(483,'4','283','1',1,'Retail Sale Id 555',5888.00,0.00,0.00,8.00,0.00,'2023-03-13 08:55:07','',''),(484,'4','283','1',1,'Retail Sale Id 556',3002.88,0.00,0.00,4.08,0.00,'2023-03-13 08:56:53','',''),(485,'4','283','1',1,'Retail Sale Id 557',2252.16,0.00,0.00,3.06,0.00,'2023-03-13 09:01:12','',''),(486,'4','283','1',1,'Retail Sale Id 558',1302.72,0.00,0.00,1.77,0.00,'2023-03-13 09:12:29','',''),(487,'4','283','1',1,'Retail Sale Id 561',2208.00,0.00,0.00,3.00,0.00,'2023-03-13 09:25:33','',''),(488,'4','283','1',1,'Retail Sale Id 562',3680.00,0.00,0.00,5.00,0.00,'2023-03-13 09:30:05','',''),(489,'4','283','1',1,'Retail Sale Id 563',1000.96,0.00,0.00,1.36,0.00,'2023-03-13 09:34:49','',''),(490,'4','283','1',1,'Retail Sale Id 564',7360.00,0.00,0.00,10.00,0.00,'2023-03-13 09:37:37','',''),(491,'4','283','1',1,'Retail Sale Id 565',1000.96,0.00,0.00,1.36,0.00,'2023-03-13 09:56:19','',''),(492,'4','283','1',1,'Retail Sale Id 566',4997.44,0.00,0.00,6.79,0.00,'2023-03-13 09:59:58','',''),(493,'4','283','1',1,'Retail Sale Id 567',4416.00,0.00,0.00,6.00,0.00,'2023-03-13 10:17:00','',''),(494,'4','283','1',1,'Retail Sale Id 569',8832.00,0.00,0.00,12.00,0.00,'2023-03-13 10:18:51','',''),(495,'4','283','1',1,'Retail Sale Id 570',368.00,0.00,0.00,0.50,0.00,'2023-03-13 10:27:28','',''),(496,'4','283','1',1,'Retail Sale Id 571',9200.00,0.00,0.00,12.50,0.00,'2023-03-13 10:44:12','',''),(497,'4','283','1',1,'Retail Sale Id 572',2001.92,0.00,0.00,2.72,0.00,'2023-03-13 10:48:29','',''),(498,'4','283','1',1,'Retail Sale Id 573',2502.40,0.00,0.00,3.40,0.00,'2023-03-13 10:51:18','',''),(499,'4','283','1',1,'Retail Sale Id 574',9200.00,0.00,0.00,12.50,0.00,'2023-03-13 11:23:32','',''),(500,'4','283','1',1,'Retail Sale Id 575',4416.00,0.00,0.00,6.00,0.00,'2023-03-13 11:26:35','',''),(501,'4','283','1',1,'Retail Sale Id 576',4416.00,0.00,0.00,6.00,0.00,'2023-03-13 12:16:25','',''),(502,'4','283','1',1,'Retail Sale Id 577',1501.44,0.00,0.00,2.04,0.00,'2023-03-13 12:32:36','',''),(503,'4','283','1',1,'Retail Sale Id 579',4496.96,0.00,0.00,6.11,0.00,'2023-03-13 12:39:51','',''),(504,'4','283','1',1,'Retail Sale Id 581',1472.00,0.00,0.00,2.00,0.00,'2023-03-13 12:41:22','',''),(505,'4','283','1',1,'Retail Sale Id 583',4416.00,0.00,0.00,6.00,0.00,'2023-03-13 12:46:21','',''),(506,'4','283','1',1,'Retail Sale Id 584',1472.00,0.00,0.00,2.00,0.00,'2023-03-13 12:47:43','',''),(507,'4','283','1',1,'Retail Sale Id 585',9200.00,0.00,0.00,12.50,0.00,'2023-03-13 12:50:38','',''),(508,'4','283','1',1,'Retail Sale Id 586',7100.00,0.00,0.00,10.00,-260.00,'2023-03-13 12:55:37','',''),(509,'4','283','1',1,'Retail Sale Id 587',9200.00,0.00,0.00,12.50,0.00,'2023-03-13 13:06:26','',''),(510,'4','283','1',1,'Retail Sale Id 588',35500.00,0.00,0.00,50.00,-1300.00,'2023-03-13 13:20:09','',''),(511,'4','283','1',1,'Retail Sale Id 589',68870.00,0.00,0.00,97.00,-2522.00,'2023-03-13 13:22:14','',''),(512,'4','283','1',1,'Retail Sale Id 591',2208.00,0.00,0.00,3.00,0.00,'2023-03-13 13:23:35','',''),(513,'4','283','1',1,'Retail Sale Id 592',1000.96,0.00,0.00,1.36,0.00,'2023-03-13 13:36:34','',''),(514,'4','283','1',1,'Retail Sale Id 594',1501.44,0.00,0.00,2.04,0.00,'2023-03-13 13:45:34','',''),(515,'4','283','1',1,'Retail Sale Id 595',9200.00,0.00,0.00,12.50,0.00,'2023-03-13 13:48:04','',''),(516,'4','283','1',1,'Retail Sale Id 596',2208.00,0.00,0.00,3.00,0.00,'2023-03-13 13:49:00','',''),(517,'4','283','1',1,'Retail Sale Id 597',3002.88,0.00,0.00,4.08,0.00,'2023-03-13 14:37:18','',''),(518,'4','283','1',1,'Retail Sale Id 598',2001.92,0.00,0.00,2.72,0.00,'2023-03-13 14:38:40','',''),(519,'4','283','1',1,'Retail Sale Id 599',9200.00,0.00,0.00,12.50,0.00,'2023-03-13 14:41:28','',''),(520,'4','283','1',1,'Retail Sale Id 600',35500.00,0.00,0.00,50.00,-1300.00,'2023-03-13 14:46:20','',''),(521,'4','283','1',1,'Retail Sale Id 601',3002.88,0.00,0.00,4.08,0.00,'2023-03-13 14:48:01','',''),(522,'4','283','1',1,'Retail Sale Id 602',2944.00,0.00,0.00,4.00,0.00,'2023-03-13 14:50:43','',''),(523,'4','283','1',1,'Retail Sale Id 603',2208.00,0.00,0.00,3.00,0.00,'2023-03-13 15:21:49','',''),(524,'4','283','1',1,'Retail Sale Id 604',2001.92,0.00,0.00,2.72,0.00,'2023-03-13 15:30:53','',''),(525,'4','283','1',1,'Retail Sale Id 605',2944.00,0.00,0.00,4.00,0.00,'2023-03-13 15:34:17','',''),(526,'4','283','1',1,'Retail Sale Id 606',2944.00,0.00,0.00,4.00,0.00,'2023-03-13 15:36:45','',''),(527,'4','283','1',1,'Retail Sale Id 607',4416.00,0.00,0.00,6.00,0.00,'2023-03-13 15:39:11','',''),(528,'4','283','1',1,'Retail Sale Id 608',9200.00,0.00,0.00,12.50,0.00,'2023-03-13 15:40:53','',''),(529,'4','283','1',1,'Retail Sale Id 609',2001.92,0.00,0.00,2.72,0.00,'2023-03-13 15:48:30','',''),(530,'4','283','1',1,'Retail Sale Id 610',2944.00,0.00,0.00,4.00,0.00,'2023-03-13 15:52:25','',''),(531,'4','283','1',1,'Retail Sale Id 611',3680.00,0.00,0.00,5.00,0.00,'2023-03-13 15:55:37','',''),(532,'4','283','1',1,'Retail Sale Id 612',9200.00,0.00,0.00,12.50,0.00,'2023-03-13 15:57:47','',''),(533,'4','283','1',1,'Retail Sale Id 613',1472.00,0.00,0.00,2.00,0.00,'2023-03-13 15:58:53','',''),(534,'4','283','1',1,'Retail Sale Id 614',9200.00,0.00,0.00,12.50,0.00,'2023-03-13 16:00:21','',''),(535,'4','283','1',1,'Retail Sale Id 615',4997.44,0.00,0.00,6.79,0.00,'2023-03-13 16:03:23','',''),(536,'4','283','1',1,'Retail Sale Id 616',9200.00,0.00,0.00,12.50,0.00,'2023-03-13 16:08:32','',''),(537,'4','283','1',1,'Retail Sale Id 617',750.72,0.00,0.00,1.02,0.00,'2023-03-13 16:18:12','',''),(538,'4','283','1',1,'Retail Sale Id 618',2208.00,0.00,0.00,3.00,0.00,'2023-03-13 16:19:45','',''),(539,'4','283','1',1,'Retail Sale Id 619',5888.00,0.00,0.00,8.00,0.00,'2023-03-13 16:35:37','',''),(540,'4','283','1',1,'Retail Sale Id 620',2208.00,0.00,0.00,3.00,0.00,'2023-03-13 16:37:28','',''),(541,'4','283','1',1,'Retail Sale Id 621',3680.00,0.00,0.00,5.00,0.00,'2023-03-13 16:41:37','',''),(542,'4','283','1',1,'Retail Sale Id 622',9200.00,0.00,0.00,12.50,0.00,'2023-03-13 16:46:24','',''),(543,'4','283','1',1,'Retail Sale Id 623',9200.00,0.00,0.00,12.50,0.00,'2023-03-13 17:01:05','',''),(544,'4','283','1',1,'Retail Sale Id 624',33370.00,0.00,0.00,47.00,-1222.00,'2023-03-13 17:32:28','',''),(545,'4','283','1',1,'Retail Sale Id 625',8875.00,0.00,0.00,12.50,-325.00,'2023-03-13 17:35:58','',''),(546,'4','283','1',1,'Retail Sale Id 626',5152.00,0.00,0.00,7.00,0.00,'2023-03-13 17:38:13','',''),(547,'4','283','1',1,'Retail Sale Id 629',4416.00,0.00,0.00,6.00,0.00,'2023-03-13 17:53:51','',''),(548,'4','283','1',1,'Retail Sale Id 630',3002.88,0.00,0.00,4.08,0.00,'2023-03-13 17:55:20','',''),(549,'4','283','1',1,'Retail Sale Id 631',4416.00,0.00,0.00,6.00,0.00,'2023-03-13 17:56:35','',''),(550,'4','283','1',1,'Retail Sale Id 632',736.00,0.00,0.00,1.00,0.00,'2023-03-13 17:57:32','',''),(551,'4','283','1',1,'Retail Sale Id 634',145728.00,0.00,0.00,198.00,0.00,'2023-03-14 11:12:10','',''),(552,'4','283','1',1,'Retail Sale Id 635',8832.00,0.00,0.00,12.00,0.00,'2023-03-14 11:17:31','',''),(553,'4','283','1',1,'Retail Sale Id 636',2208.00,0.00,0.00,3.00,0.00,'2023-03-14 11:20:57','',''),(554,'4','283','1',1,'Retail Sale Id 637',52992.00,0.00,0.00,72.00,0.00,'2023-03-14 12:28:23','',''),(555,'4','283','1',1,'Retail Sale Id 638',9200.00,0.00,0.00,12.50,0.00,'2023-03-14 12:40:10','',''),(556,'4','283','1',1,'Retail Sale Id 639',4416.00,0.00,0.00,6.00,0.00,'2023-03-14 12:45:09','',''),(557,'4','283','1',1,'Retail Sale Id 640',1000.96,0.00,0.00,1.36,0.00,'2023-03-14 12:51:48','',''),(558,'4','283','1',1,'Retail Sale Id 641',2208.00,0.00,0.00,3.00,0.00,'2023-03-14 12:58:55','',''),(559,'4','283','1',1,'Retail Sale Id 642',2208.00,0.00,0.00,3.00,0.00,'2023-03-14 13:01:48','',''),(560,'4','283','1',1,'Retail Sale Id 643',110400.00,0.00,0.00,150.00,0.00,'2023-03-14 13:07:07','',''),(561,'4','283','1',1,'Retail Sale Id 644',3680.00,0.00,0.00,5.00,0.00,'2023-03-14 13:15:10','',''),(562,'4','283','1',1,'Retail Sale Id 645',2208.00,0.00,0.00,3.00,0.00,'2023-03-14 13:18:17','',''),(563,'4','283','1',1,'Retail Sale Id 646',4416.00,0.00,0.00,6.00,0.00,'2023-03-14 13:24:19','',''),(564,'4','283','1',1,'Retail Sale Id 647',92000.00,0.00,0.00,125.00,0.00,'2023-03-14 14:31:26','',''),(565,'4','283','1',1,'Retail Sale Id 648',9200.00,0.00,0.00,12.50,0.00,'2023-03-14 16:27:43','',''),(566,'4','283','1',1,'Retail Sale Id 650',27600.00,0.00,0.00,37.50,0.00,'2023-03-14 17:12:41','',''),(567,'4','283','1',1,'Retail Sale Id 651',26628.48,0.00,0.00,36.18,0.00,'2023-03-14 17:15:27','',''),(568,'4','283','1',1,'Retail Sale Id 652',4416.00,0.00,0.00,6.00,0.00,'2023-03-14 17:39:21','',''),(569,'4','283','1',1,'Retail Sale Id 653',4416.00,0.00,0.00,6.00,0.00,'2023-03-15 10:51:29','',''),(570,'4','283','1',1,'Retail Sale Id 654',9200.00,0.00,0.00,12.50,0.00,'2023-03-15 10:52:42','',''),(571,'4','283','1',1,'Retail Sale Id 655',4416.00,0.00,0.00,6.00,0.00,'2023-03-15 10:56:23','',''),(572,'4','283','1',1,'Retail Sale Id 656',4416.00,0.00,0.00,6.00,0.00,'2023-03-15 10:57:42','',''),(573,'4','283','1',1,'Retail Sale Id 658',18400.00,0.00,0.00,25.00,0.00,'2023-03-15 11:03:38','',''),(574,'4','283','1',1,'Retail Sale Id 659',9200.00,0.00,0.00,12.50,0.00,'2023-03-15 11:07:51','',''),(575,'4','283','1',1,'Retail Sale Id 660',35500.00,0.00,0.00,50.00,-1300.00,'2023-03-15 11:11:14','',''),(576,'4','283','1',1,'Retail Sale Id 661',5152.00,0.00,0.00,7.00,0.00,'2023-03-15 11:12:37','',''),(577,'4','283','1',1,'Retail Sale Id 663',35500.00,0.00,0.00,50.00,-1300.00,'2023-03-15 11:20:19','',''),(578,'4','283','1',1,'Retail Sale Id 664',8464.00,0.00,0.00,11.50,0.00,'2023-03-15 11:33:25','',''),(579,'4','283','1',1,'Retail Sale Id 665',4416.00,0.00,0.00,6.00,0.00,'2023-03-15 11:35:02','',''),(580,'4','283','1',1,'Retail Sale Id 666',2208.00,0.00,0.00,3.00,0.00,'2023-03-15 11:37:47','',''),(581,'4','283','1',1,'Retail Sale Id 667',8096.00,0.00,0.00,11.00,0.00,'2023-03-15 11:42:04','',''),(582,'4','283','1',1,'Retail Sale Id 668',3002.88,0.00,0.00,4.08,0.00,'2023-03-15 11:46:08','',''),(583,'4','283','1',1,'Retail Sale Id 669',3680.00,0.00,0.00,5.00,0.00,'2023-03-15 11:48:24','',''),(584,'4','283','1',1,'Retail Sale Id 670',1472.00,0.00,0.00,2.00,0.00,'2023-03-15 12:05:50','',''),(585,'4','283','1',1,'Retail Sale Id 671',4416.00,0.00,0.00,6.00,0.00,'2023-03-15 12:10:31','',''),(586,'4','283','1',1,'Retail Sale Id 672',9200.00,0.00,0.00,12.50,0.00,'2023-03-15 12:12:53','',''),(587,'4','283','1',1,'Retail Sale Id 673',3680.00,0.00,0.00,5.00,0.00,'2023-03-15 12:21:24','',''),(588,'4','283','1',1,'Retail Sale Id 674',44375.00,0.00,0.00,62.50,-1625.00,'2023-03-15 12:29:18','',''),(589,'4','283','1',1,'Retail Sale Id 675',1472.00,0.00,0.00,2.00,0.00,'2023-03-15 12:31:18','',''),(590,'4','283','1',1,'Retail Sale Id 676',3680.00,0.00,0.00,5.00,0.00,'2023-03-15 12:33:21','',''),(591,'4','283','1',1,'Retail Sale Id 677',2208.00,0.00,0.00,3.00,0.00,'2023-03-15 12:34:43','',''),(592,'4','283','1',1,'Retail Sale Id 678',3503.36,0.00,0.00,4.76,0.00,'2023-03-15 12:44:26','',''),(593,'4','283','1',1,'Retail Sale Id 679',4496.96,0.00,0.00,6.11,0.00,'2023-03-15 12:45:24','',''),(594,'4','283','1',1,'Retail Sale Id 680',2208.00,0.00,0.00,3.00,0.00,'2023-03-15 12:46:57','',''),(595,'4','283','1',1,'Retail Sale Id 681',2208.00,0.00,0.00,3.00,0.00,'2023-03-15 12:50:41','',''),(596,'4','283','1',1,'Retail Sale Id 682',8875.00,0.00,0.00,12.50,-325.00,'2023-03-15 12:53:07','',''),(597,'4','283','1',1,'Retail Sale Id 683',1472.00,0.00,0.00,2.00,0.00,'2023-03-15 12:55:04','',''),(598,'4','283','1',1,'Retail Sale Id 684',3002.88,0.00,0.00,4.08,0.00,'2023-03-15 12:56:49','',''),(599,'4','283','1',1,'Retail Sale Id 685',4416.00,0.00,0.00,6.00,0.00,'2023-03-15 16:44:35','',''),(600,'4','283','1',1,'Retail Sale Id 686',2208.00,0.00,0.00,3.00,0.00,'2023-03-15 16:46:36','',''),(601,'4','283','1',1,'Retail Sale Id 687',5998.40,0.00,0.00,8.15,0.00,'2023-03-15 16:49:41','',''),(602,'4','283','1',1,'Retail Sale Id 688',2944.00,0.00,0.00,4.00,0.00,'2023-03-15 16:50:40','',''),(603,'4','283','1',1,'Retail Sale Id 689',2208.00,0.00,0.00,3.00,0.00,'2023-03-15 16:57:51','',''),(604,'4','283','1',1,'Retail Sale Id 690',2001.92,0.00,0.00,2.72,0.00,'2023-03-15 17:03:19','',''),(605,'4','283','1',1,'Retail Sale Id 692',2944.00,0.00,0.00,4.00,0.00,'2023-03-15 17:20:20','',''),(606,'4','283','1',1,'Retail Sale Id 694',8875.00,0.00,0.00,12.50,-325.00,'2023-03-15 17:25:31','',''),(607,'4','283','1',1,'Retail Sale Id 695',4416.00,0.00,0.00,6.00,0.00,'2023-03-15 17:29:45','',''),(608,'4','283','1',1,'Retail Sale Id 696',2208.00,0.00,0.00,3.00,0.00,'2023-03-15 17:32:39','',''),(609,'4','283','1',1,'Retail Sale Id 697',2001.92,0.00,0.00,2.72,0.00,'2023-03-15 17:43:47','',''),(610,'4','283','1',1,'Retail Sale Id 698',2208.00,0.00,0.00,3.00,0.00,'2023-03-15 17:50:31','',''),(611,'4','283','1',1,'Retail Sale Id 699',2208.00,0.00,0.00,3.00,0.00,'2023-03-15 17:54:25','',''),(612,'4','283','1',1,'Retail Sale Id 700',1000.96,0.00,0.00,1.36,0.00,'2023-03-15 17:56:58','',''),(613,'4','283','1',1,'Retail Sale Id 701',2208.00,0.00,0.00,3.00,0.00,'2023-03-15 17:57:57','',''),(614,'4','283','1',1,'Retail Sale Id 702',1472.00,0.00,0.00,2.00,0.00,'2023-03-15 17:59:06','',''),(615,'4','283','1',1,'Retail Sale Id 703',35500.00,0.00,0.00,50.00,-1300.00,'2023-03-15 18:01:40','',''),(616,'4','283','1',1,'Retail Sale Id 704',104370.00,0.00,0.00,147.00,-3822.00,'2023-03-15 18:03:09','',''),(617,'4','283','1',1,'Retail Sale Id 705',9200.00,0.00,0.00,12.50,0.00,'2023-03-15 18:04:52','',''),(618,'4','283','1',1,'Retail Sale Id 706',2208.00,0.00,0.00,3.00,0.00,'2023-03-15 18:06:19','',''),(619,'4','283','1',1,'Retail Sale Id 707',4997.44,0.00,0.00,6.79,0.00,'2023-03-15 18:08:35','',''),(620,'4','283','1',1,'Retail Sale Id 708',1472.00,0.00,0.00,2.00,0.00,'2023-03-15 18:14:07','',''),(621,'4','283','1',1,'Retail Sale Id 709',3599.04,0.00,0.00,4.89,0.00,'2023-03-15 18:15:40','',''),(622,'4','283','1',1,'Retail Sale Id 711',9200.00,0.00,0.00,12.50,0.00,'2023-03-15 18:16:59','',''),(623,'4','283','1',1,'Retail Sale Id 712',355000.00,0.00,0.00,500.00,-13000.00,'2023-03-16 11:51:46','',''),(624,'4','283','1',1,'Retail Sale Id 713',57408.00,0.00,0.00,78.00,0.00,'2023-03-16 12:16:41','',''),(625,'4','283','1',1,'Retail Sale Id 714',4416.00,0.00,0.00,6.00,0.00,'2023-03-16 12:19:46','',''),(626,'4','283','1',1,'Retail Sale Id 715',1625088.00,0.00,0.00,2208.00,0.00,'2023-03-16 12:22:21','',''),(627,'4','283','1',1,'Retail Sale Id 716',2944.00,0.00,0.00,4.00,0.00,'2023-03-16 12:26:30','',''),(628,'4','283','1',1,'Retail Sale Id 717',7360.00,0.00,0.00,10.00,0.00,'2023-03-16 12:34:35','',''),(629,'4','283','1',1,'Retail Sale Id 718',3680.00,0.00,0.00,5.00,0.00,'2023-03-16 12:40:31','',''),(630,'4','283','1',1,'Retail Sale Id 719',4416.00,0.00,0.00,6.00,0.00,'2023-03-16 12:42:42','',''),(631,'4','283','1',1,'Retail Sale Id 720',3702.08,0.00,0.00,5.03,0.00,'2023-03-16 12:48:36','',''),(632,'4','283','1',1,'Retail Sale Id 722',71000.00,0.00,0.00,100.00,-2600.00,'2023-03-16 12:58:07','',''),(633,'4','283','1',1,'Retail Sale Id 723',1501.44,0.00,0.00,2.04,0.00,'2023-03-16 13:04:34','',''),(634,'4','283','1',1,'Retail Sale Id 724',2208.00,0.00,0.00,3.00,0.00,'2023-03-16 13:13:50','',''),(635,'4','283','1',1,'Retail Sale Id 725',1501.44,0.00,0.00,2.04,0.00,'2023-03-16 13:18:13','',''),(636,'4','283','1',1,'Retail Sale Id 726',5888.00,0.00,0.00,8.00,0.00,'2023-03-16 13:20:55','',''),(637,'4','283','1',1,'Retail Sale Id 728',4416.00,0.00,0.00,6.00,0.00,'2023-03-16 13:23:58','',''),(638,'4','283','1',1,'Retail Sale Id 729',1472.00,0.00,0.00,2.00,0.00,'2023-03-16 13:25:15','',''),(639,'4','283','1',1,'Retail Sale Id 730',9200.00,0.00,0.00,12.50,0.00,'2023-03-16 13:46:26','',''),(640,'4','283','1',1,'Retail Sale Id 731',802.24,0.00,0.00,1.09,0.00,'2023-03-16 13:56:59','',''),(641,'4','283','1',1,'Retail Sale Id 732',7360.00,0.00,0.00,10.00,0.00,'2023-03-16 13:59:16','',''),(642,'4','283','1',1,'Retail Sale Id 733',9200.00,0.00,0.00,12.50,0.00,'2023-03-16 14:04:34','',''),(643,'4','283','1',1,'Retail Sale Id 734',4997.44,0.00,0.00,6.79,0.00,'2023-03-16 14:09:52','',''),(644,'4','283','1',1,'Retail Sale Id 735',9200.00,0.00,0.00,12.50,0.00,'2023-03-16 14:13:34','',''),(645,'4','283','1',1,'Retail Sale Id 736',2208.00,0.00,0.00,3.00,0.00,'2023-03-16 14:19:33','',''),(646,'4','283','1',1,'Retail Sale Id 737',4416.00,0.00,0.00,6.00,0.00,'2023-03-16 14:23:23','',''),(647,'4','283','1',1,'Retail Sale Id 738',9200.00,0.00,0.00,12.50,0.00,'2023-03-16 14:32:34','',''),(648,'4','283','1',1,'Retail Sale Id 739',8875.00,0.00,0.00,12.50,-325.00,'2023-03-16 15:09:36','',''),(649,'4','283','1',1,'Retail Sale Id 740',7360.00,0.00,0.00,10.00,0.00,'2023-03-16 16:47:25','',''),(650,'4','283','1',1,'Retail Sale Id 741',4416.00,0.00,0.00,6.00,0.00,'2023-03-16 16:49:05','',''),(651,'4','283','1',1,'Retail Sale Id 742',2502.40,0.00,0.00,3.40,0.00,'2023-03-17 10:52:28','',''),(652,'4','283','1',1,'Retail Sale Id 743',9200.00,0.00,0.00,12.50,0.00,'2023-03-17 10:54:29','',''),(653,'4','283','1',1,'Retail Sale Id 745',1472.00,0.00,0.00,2.00,0.00,'2023-03-17 11:30:05','',''),(654,'4','283','1',1,'Retail Sale Id 746',2208.00,0.00,0.00,3.00,0.00,'2023-03-17 11:32:47','',''),(655,'4','283','1',1,'Retail Sale Id 747',2208.00,0.00,0.00,3.00,0.00,'2023-03-17 11:36:44','',''),(656,'4','283','1',1,'Retail Sale Id 748',1000.96,0.00,0.00,1.36,0.00,'2023-03-17 11:38:16','',''),(657,'4','283','1',1,'Retail Sale Id 749',5152.00,0.00,0.00,7.00,0.00,'2023-03-17 11:39:27','',''),(658,'4','283','1',1,'Retail Sale Id 750',9200.00,0.00,0.00,12.50,0.00,'2023-03-17 11:41:41','',''),(659,'4','283','1',1,'Retail Sale Id 752',3680.00,0.00,0.00,5.00,0.00,'2023-03-17 11:43:38','',''),(660,'4','283','1',1,'Retail Sale Id 753',4416.00,0.00,0.00,6.00,0.00,'2023-03-17 11:44:34','',''),(661,'4','283','1',1,'Retail Sale Id 754',9200.00,0.00,0.00,12.50,0.00,'2023-03-17 11:46:16','',''),(662,'4','283','1',1,'Retail Sale Id 756',9200.00,0.00,0.00,12.50,0.00,'2023-03-17 11:51:21','',''),(663,'4','283','1',1,'Retail Sale Id 758',4416.00,0.00,0.00,6.00,0.00,'2023-03-17 12:00:09','',''),(664,'4','283','1',1,'Retail Sale Id 759',9200.00,0.00,0.00,12.50,0.00,'2023-03-17 12:01:30','',''),(665,'4','283','1',1,'Retail Sale Id 760',7728.00,0.00,0.00,10.50,0.00,'2023-03-17 12:03:55','',''),(666,'4','283','1',1,'Retail Sale Id 761',4416.00,0.00,0.00,6.00,0.00,'2023-03-17 12:05:23','',''),(667,'4','283','1',1,'Retail Sale Id 762',9200.00,0.00,0.00,12.50,0.00,'2023-03-17 12:11:24','',''),(668,'4','283','1',1,'Retail Sale Id 763',9200.00,0.00,0.00,12.50,0.00,'2023-03-17 12:14:03','',''),(669,'4','283','1',1,'Retail Sale Id 764',3680.00,0.00,0.00,5.00,0.00,'2023-03-17 12:18:18','',''),(670,'4','283','1',1,'Retail Sale Id 765',4416.00,0.00,0.00,6.00,0.00,'2023-03-17 12:25:56','',''),(671,'4','283','1',1,'Retail Sale Id 766',9200.00,0.00,0.00,12.50,0.00,'2023-03-17 12:26:57','',''),(672,'4','283','1',1,'Retail Sale Id 767',3996.48,0.00,0.00,5.43,0.00,'2023-03-17 12:28:31','',''),(673,'4','283','1',1,'Retail Sale Id 768',2944.00,0.00,0.00,4.00,0.00,'2023-03-17 12:30:57','',''),(674,'4','283','1',1,'Retail Sale Id 769',9200.00,0.00,0.00,12.50,0.00,'2023-03-17 12:32:25','',''),(675,'4','283','1',1,'Retail Sale Id 770',2944.00,0.00,0.00,4.00,0.00,'2023-03-17 12:42:17','',''),(676,'4','283','1',1,'Retail Sale Id 771',4416.00,0.00,0.00,6.00,0.00,'2023-03-17 12:43:24','',''),(677,'4','283','1',1,'Retail Sale Id 772',2208.00,0.00,0.00,3.00,0.00,'2023-03-17 12:46:31','',''),(678,'4','283','1',1,'Retail Sale Id 773',6624.00,0.00,0.00,9.00,0.00,'2023-03-17 12:48:01','',''),(679,'4','283','1',1,'Retail Sale Id 774',14200.00,0.00,0.00,20.00,-520.00,'2023-03-17 12:53:34','',''),(680,'4','283','1',1,'Retail Sale Id 775',33370.00,0.00,0.00,47.00,-1222.00,'2023-03-17 12:54:58','',''),(681,'4','283','1',1,'Retail Sale Id 776',43665.00,0.00,0.00,61.50,-1599.00,'2023-03-17 13:00:25','',''),(682,'4','283','1',1,'Retail Sale Id 777',13248.00,0.00,0.00,18.00,0.00,'2023-03-17 13:05:55','',''),(683,'4','283','1',1,'Retail Sale Id 778',9200.00,0.00,0.00,12.50,0.00,'2023-03-17 13:07:15','',''),(684,'4','283','1',1,'Retail Sale Id 779',5152.00,0.00,0.00,7.00,0.00,'2023-03-17 13:16:15','',''),(685,'4','283','1',1,'Retail Sale Id 780',4416.00,0.00,0.00,6.00,0.00,'2023-03-17 13:19:54','',''),(686,'4','283','1',1,'Retail Sale Id 781',1000.96,0.00,0.00,1.36,0.00,'2023-03-17 14:15:37','',''),(687,'4','283','1',1,'Retail Sale Id 782',2208.00,0.00,0.00,3.00,0.00,'2023-03-17 14:17:57','',''),(688,'4','283','1',1,'Retail Sale Id 783',9200.00,0.00,0.00,12.50,0.00,'2023-03-17 14:19:28','',''),(689,'4','283','1',1,'Retail Sale Id 784',2001.92,0.00,0.00,2.72,0.00,'2023-03-17 14:21:03','',''),(690,'4','283','1',1,'Retail Sale Id 786',2208.00,0.00,0.00,3.00,0.00,'2023-03-17 14:25:55','',''),(691,'4','283','1',1,'Retail Sale Id 787',3002.88,0.00,0.00,4.08,0.00,'2023-03-17 14:27:30','',''),(692,'4','283','1',1,'Retail Sale Id 788',4416.00,0.00,0.00,6.00,0.00,'2023-03-17 14:29:11','',''),(693,'4','283','1',1,'Retail Sale Id 789',3996.48,0.00,0.00,5.43,0.00,'2023-03-17 14:37:37','',''),(694,'4','283','1',1,'Retail Sale Id 790',2944.00,0.00,0.00,4.00,0.00,'2023-03-17 14:41:03','',''),(695,'4','283','1',1,'Retail Sale Id 791',2208.00,0.00,0.00,3.00,0.00,'2023-03-17 14:42:54','',''),(696,'4','283','1',1,'Retail Sale Id 792',9200.00,0.00,0.00,12.50,0.00,'2023-03-17 14:47:17','',''),(697,'4','283','1',1,'Retail Sale Id 793',8096.00,0.00,0.00,11.00,0.00,'2023-03-17 14:49:07','',''),(698,'4','283','1',1,'Retail Sale Id 794',40480.00,0.00,0.00,55.00,0.00,'2023-03-17 14:57:03','',''),(699,'4','283','1',1,'Retail Sale Id 795',9001.28,0.00,0.00,12.23,0.00,'2023-03-17 15:07:49','',''),(700,'4','283','1',1,'Retail Sale Id 796',71000.00,0.00,0.00,100.00,-2600.00,'2023-03-17 15:52:12','',''),(701,'4','283','1',1,'Retail Sale Id 797',35500.00,0.00,0.00,50.00,-1300.00,'2023-03-17 15:54:12','',''),(702,'4','283','1',1,'Retail Sale Id 798',2208.00,0.00,0.00,3.00,0.00,'2023-03-17 16:53:21','',''),(703,'4','283','1',1,'Retail Sale Id 799',9200.00,0.00,0.00,12.50,0.00,'2023-03-17 16:54:29','',''),(704,'4','283','1',1,'Retail Sale Id 800',9200.00,0.00,0.00,12.50,0.00,'2023-03-17 16:56:28','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_balances`
--

DROP TABLE IF EXISTS `inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_balances`
--

LOCK TABLES `inventory_balances` WRITE;
/*!40000 ALTER TABLE `inventory_balances` DISABLE KEYS */;
INSERT INTO `inventory_balances` VALUES (1,'4','283',1,24683.56,'2023-03-17 16:57:11');
/*!40000 ALTER TABLE `inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=698 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (1,'4','283',1,'Retail Sale Id 1',0.00,4380.00,760.00,4560.00,180.00,'2023-02-05 16:57:51'),(2,'4','283',1,'Retail Sale Id 1',0.00,9125.00,760.00,9500.00,375.00,'2023-02-05 16:57:51'),(3,'4','283',1,'Retail Sale Id 2',0.00,2070.00,760.00,2280.00,210.00,'2023-02-06 14:54:41'),(4,'4','283',1,'Retail Sale Id 2',0.00,8625.00,760.00,9500.00,875.00,'2023-02-06 14:54:41'),(5,'4','283',1,'Retail Sale Id 3',0.00,17250.00,760.00,19000.00,1750.00,'2023-02-06 14:58:13'),(6,'4','283',1,'Retail Sale Id 4',0.00,10350.00,760.00,11400.00,1050.00,'2023-02-06 15:02:09'),(7,'4','283',1,'Sale Id 1',0.00,6900000.00,750.00,7500000.00,600000.00,'2023-02-06 15:10:45'),(8,'4','283',1,'Retail Sale Id 5',0.00,207000.00,750.00,225000.00,18000.00,'2023-02-06 15:16:53'),(9,'4','283',1,'Retail Sale Id 6',0.00,4140.00,760.00,4560.00,420.00,'2023-02-11 13:04:49'),(10,'4','283',1,'Retail Sale Id 6',0.00,8625.00,760.00,9500.00,875.00,'2023-02-11 13:04:49'),(11,'4','283',1,'Retail Sale Id 7',0.00,690.00,760.00,760.00,70.00,'2023-02-12 17:55:21'),(12,'4','283',1,'Retail Sale Id 7',0.00,690.00,760.00,760.00,70.00,'2023-02-12 17:55:21'),(13,'4','283',1,'Retail Sale Id 8',0.00,345000.00,750.00,375000.00,30000.00,'2023-02-12 17:57:08'),(14,'4','283',1,'Retail Sale Id 9',0.00,86250.00,760.00,95000.00,8750.00,'2023-02-12 18:19:17'),(15,'4','283',1,'Retail Sale Id 10',0.00,690.00,760.00,760.00,70.00,'2023-02-12 18:20:11'),(16,'4','283',1,'Retail Sale Id 13',0.00,10350.00,760.00,11400.00,1050.00,'2023-02-12 18:22:48'),(17,'4','283',1,'Retail Sale Id 12',0.00,10350.00,760.00,11400.00,1050.00,'2023-02-12 18:23:28'),(18,'4','283',1,'Retail Sale Id 14',0.00,6900.00,760.00,7600.00,700.00,'2023-02-12 18:30:21'),(19,'4','283',1,'Retail Sale Id 15',0.00,34500.00,760.00,38000.00,3500.00,'2023-02-12 18:32:46'),(20,'4','283',1,'Retail Sale Id 16',0.00,517500.00,750.00,562500.00,45000.00,'2023-02-12 18:34:45'),(21,'4','283',1,'Retail Sale Id 11',0.00,10350.00,760.00,11400.00,1050.00,'2023-02-12 18:35:52'),(22,'4','283',1,'Retail Sale Id 17',0.00,2070.00,760.00,2280.00,210.00,'2023-02-12 18:59:40'),(23,'4','283',1,'Retail Sale Id 18',0.00,17250.00,760.00,19000.00,1750.00,'2023-02-12 19:02:53'),(24,'4','283',1,'Retail Sale Id 19',0.00,10350.00,760.00,11400.00,1050.00,'2023-02-12 19:12:44'),(25,'4','283',1,'Retail Sale Id 20',0.00,3450.00,760.00,3800.00,350.00,'2023-02-12 19:15:35'),(26,'4','283',1,'Retail Sale Id 20',0.00,6900.00,760.00,7600.00,700.00,'2023-02-12 19:15:35'),(27,'4','283',1,'Retail Sale Id 21',0.00,2070.00,760.00,2280.00,210.00,'2023-02-12 19:18:12'),(28,'4','283',1,'Retail Sale Id 21',0.00,4140.00,760.00,4560.00,420.00,'2023-02-12 19:18:12'),(29,'4','283',1,'Retail Sale Id 21',0.00,8625.00,760.00,9500.00,875.00,'2023-02-12 19:18:12'),(30,'4','283',1,'Retail Sale Id 22',0.00,3450.00,760.00,3800.00,350.00,'2023-02-12 19:21:52'),(31,'4','283',1,'Retail Sale Id 23',0.00,6210.00,760.00,6840.00,630.00,'2023-02-12 19:35:59'),(32,'4','283',1,'Retail Sale Id 24',0.00,10350.00,760.00,11400.00,1050.00,'2023-02-12 19:41:34'),(33,'4','283',1,'Retail Sale Id 25',0.00,10350.00,760.00,11400.00,1050.00,'2023-02-12 19:43:29'),(34,'4','283',1,'Retail Sale Id 27',0.00,3450.00,760.00,3800.00,350.00,'2023-02-13 10:34:04'),(35,'4','283',1,'Retail Sale Id 28',0.00,3629.40,760.00,3997.60,368.20,'2023-02-13 10:47:17'),(36,'4','283',1,'Retail Sale Id 28',0.00,17250.00,760.00,19000.00,1750.00,'2023-02-13 10:47:17'),(37,'4','283',1,'Retail Sale Id 31',0.00,690.00,760.00,760.00,70.00,'2023-02-13 12:04:44'),(38,'4','283',1,'Retail Sale Id 32',0.00,345000.00,750.00,375000.00,30000.00,'2023-02-13 17:18:41'),(39,'4','283',1,'Retail Sale Id 33',0.00,103500.00,750.00,112500.00,9000.00,'2023-02-13 17:20:54'),(40,'4','283',1,'Retail Sale Id 34',0.00,2070.00,760.00,2280.00,210.00,'2023-02-13 17:27:10'),(41,'4','283',1,'Retail Sale Id 35',0.00,4140.00,760.00,4560.00,420.00,'2023-02-13 21:49:17'),(42,'4','283',1,'Retail Sale Id 35',0.00,8625.00,760.00,9500.00,875.00,'2023-02-13 21:49:17'),(43,'4','283',1,'Retail Sale Id 36',0.00,17250.00,760.00,19000.00,1750.00,'2023-02-13 22:21:41'),(44,'4','283',1,'Retail Sale Id 37',0.00,17250.00,760.00,19000.00,1750.00,'2023-02-13 22:44:32'),(45,'4','283',1,'Retail Sale Id 38',0.00,4140.00,760.00,4560.00,420.00,'2023-02-14 10:40:54'),(46,'4','283',1,'Retail Sale Id 40',0.00,6210.00,760.00,6840.00,630.00,'2023-02-14 14:10:06'),(47,'4','283',1,'Retail Sale Id 41',0.00,207000.00,750.00,225000.00,18000.00,'2023-02-14 15:08:50'),(48,'4','283',1,'Retail Sale Id 42',0.00,345000.00,750.00,375000.00,30000.00,'2023-02-14 18:09:07'),(49,'4','283',1,'Retail Sale Id 43',0.00,345000.00,750.00,375000.00,30000.00,'2023-02-14 18:15:17'),(50,'4','283',1,'Retail Sale Id 44',0.00,17250.00,760.00,19000.00,1750.00,'2023-02-15 10:28:11'),(51,'4','283',1,'Retail Sale Id 45',0.00,2760.00,760.00,3040.00,280.00,'2023-02-16 13:34:39'),(52,'4','283',1,'Retail Sale Id 46',0.00,257600.00,750.00,262500.00,4900.00,'2023-02-16 13:53:13'),(53,'4','283',1,'Retail Sale Id 47',0.00,73600.00,700.00,70000.00,-3600.00,'2023-02-16 14:04:48'),(54,'4','283',1,'Retail Sale Id 48',0.00,736.00,760.00,760.00,24.00,'2023-02-16 14:19:20'),(55,'4','283',1,'Retail Sale Id 50',0.00,5152.00,736.00,5152.00,0.00,'2023-02-16 14:46:59'),(56,'4','283',1,'Retail Sale Id 51',0.00,73600.00,760.00,76000.00,2400.00,'2023-02-16 15:04:19'),(57,'4','283',1,'Retail Sale Id 52',0.00,184000.00,710.00,177500.00,-6500.00,'2023-02-16 16:02:30'),(58,'4','283',1,'Retail Sale Id 53',0.00,110400.00,710.00,106500.00,-3900.00,'2023-02-16 16:10:08'),(59,'4','283',1,'Retail Sale Id 54',0.00,6624.00,736.00,6624.00,0.00,'2023-03-04 18:26:28'),(60,'4','283',1,'Retail Sale Id 55',0.00,9200.00,736.00,9200.00,0.00,'2023-03-05 09:31:16'),(61,'4','283',1,'Retail Sale Id 56',0.00,4416.00,736.00,4416.00,0.00,'2023-03-05 09:46:16'),(62,'4','283',1,'Retail Sale Id 57',0.00,4401.28,736.00,4401.28,0.00,'2023-03-05 09:55:06'),(63,'4','283',1,'Retail Sale Id 58',0.00,897.92,736.00,897.92,0.00,'2023-03-05 09:57:31'),(64,'4','283',1,'Retail Sale Id 59',0.00,4416.00,736.00,4416.00,0.00,'2023-03-05 10:00:38'),(65,'4','283',1,'Retail Sale Id 60',0.00,13616.00,736.00,13616.00,0.00,'2023-03-05 10:48:54'),(66,'4','283',1,'Retail Sale Id 61',0.00,2208.00,736.00,2208.00,0.00,'2023-03-05 10:52:37'),(67,'4','283',1,'Retail Sale Id 62',0.00,3680.00,736.00,3680.00,0.00,'2023-03-05 10:54:44'),(68,'4','283',1,'Retail Sale Id 63',0.00,1501.44,736.00,1501.44,0.00,'2023-03-05 10:58:10'),(69,'4','283',1,'Retail Sale Id 65',0.00,4997.44,736.00,4997.44,0.00,'2023-03-05 11:11:31'),(70,'4','283',1,'Retail Sale Id 66',0.00,4416.00,736.00,4416.00,0.00,'2023-03-05 11:13:11'),(71,'4','283',1,'Retail Sale Id 67',0.00,9200.00,736.00,9200.00,0.00,'2023-03-05 11:15:23'),(72,'4','283',1,'Retail Sale Id 69',0.00,2208.00,736.00,2208.00,0.00,'2023-03-05 11:17:10'),(73,'4','283',1,'Retail Sale Id 71',0.00,9200.00,736.00,9200.00,0.00,'2023-03-05 11:18:33'),(74,'4','283',1,'Retail Sale Id 73',0.00,1472.00,736.00,1472.00,0.00,'2023-03-05 11:21:45'),(75,'4','283',1,'Retail Sale Id 74',0.00,4416.00,736.00,4416.00,0.00,'2023-03-05 11:23:52'),(76,'4','283',1,'Retail Sale Id 75',0.00,9200.00,736.00,9200.00,0.00,'2023-03-05 11:25:21'),(77,'4','283',1,'Retail Sale Id 78',0.00,9200.00,736.00,9200.00,0.00,'2023-03-05 11:32:57'),(78,'4','283',1,'Retail Sale Id 79',0.00,1472.00,736.00,1472.00,0.00,'2023-03-05 11:34:31'),(79,'4','283',1,'Retail Sale Id 80',0.00,12880.00,736.00,12880.00,0.00,'2023-03-05 11:52:54'),(80,'4','283',1,'Retail Sale Id 81',0.00,6624.00,736.00,6624.00,0.00,'2023-03-05 11:54:55'),(81,'4','283',1,'Retail Sale Id 82',0.00,2252.16,736.00,2252.16,0.00,'2023-03-05 11:57:38'),(82,'4','283',1,'Retail Sale Id 83',0.00,3680.00,736.00,3680.00,0.00,'2023-03-05 12:02:20'),(83,'4','283',1,'Retail Sale Id 84',0.00,5888.00,736.00,5888.00,0.00,'2023-03-05 12:09:57'),(84,'4','283',1,'Retail Sale Id 85',0.00,2208.00,736.00,2208.00,0.00,'2023-03-05 12:13:12'),(85,'4','283',1,'Retail Sale Id 86',0.00,736.00,736.00,736.00,0.00,'2023-03-05 12:16:41'),(86,'4','283',1,'Retail Sale Id 87',0.00,3680.00,736.00,3680.00,0.00,'2023-03-05 12:20:33'),(87,'4','283',1,'Retail Sale Id 88',0.00,1472.00,736.00,1472.00,0.00,'2023-03-05 12:22:14'),(88,'4','283',1,'Retail Sale Id 89',0.00,2208.00,736.00,2208.00,0.00,'2023-03-05 12:23:56'),(89,'4','283',1,'Retail Sale Id 90',0.00,5152.00,736.00,5152.00,0.00,'2023-03-05 12:26:23'),(90,'4','283',1,'Retail Sale Id 92',0.00,6624.00,736.00,6624.00,0.00,'2023-03-05 12:28:06'),(91,'4','283',1,'Retail Sale Id 93',0.00,2502.40,736.00,2502.40,0.00,'2023-03-05 12:29:54'),(92,'4','283',1,'Retail Sale Id 94',0.00,4416.00,736.00,4416.00,0.00,'2023-03-05 12:32:23'),(93,'4','283',1,'Retail Sale Id 96',0.00,2208.00,736.00,2208.00,0.00,'2023-03-05 12:35:27'),(94,'4','283',1,'Retail Sale Id 97',0.00,1472.00,736.00,1472.00,0.00,'2023-03-05 12:37:51'),(95,'4','283',1,'Retail Sale Id 98',0.00,3002.88,736.00,3002.88,0.00,'2023-03-05 12:39:44'),(96,'4','283',1,'Retail Sale Id 99',0.00,2208.00,736.00,2208.00,0.00,'2023-03-05 12:41:42'),(97,'4','283',1,'Retail Sale Id 100',0.00,9200.00,736.00,9200.00,0.00,'2023-03-05 12:47:20'),(98,'4','283',1,'Retail Sale Id 101',0.00,7360.00,736.00,7360.00,0.00,'2023-03-05 12:50:16'),(99,'4','283',1,'Retail Sale Id 102',0.00,2001.92,736.00,2001.92,0.00,'2023-03-05 12:52:19'),(100,'4','283',1,'Retail Sale Id 104',0.00,1501.44,736.00,1501.44,0.00,'2023-03-05 12:53:32'),(101,'4','283',1,'Retail Sale Id 106',0.00,35328.00,710.00,34080.00,-1248.00,'2023-03-05 13:00:05'),(102,'4','283',1,'Retail Sale Id 107',0.00,4997.44,736.00,4997.44,0.00,'2023-03-05 13:02:28'),(103,'4','283',1,'Retail Sale Id 109',0.00,9200.00,736.00,9200.00,0.00,'2023-03-05 13:04:15'),(104,'4','283',1,'Retail Sale Id 111',0.00,3996.48,736.00,3996.48,0.00,'2023-03-05 13:10:42'),(105,'4','283',1,'Retail Sale Id 112',0.00,9200.00,736.00,9200.00,0.00,'2023-03-05 13:17:32'),(106,'4','283',1,'Retail Sale Id 113',0.00,8832.00,736.00,8832.00,0.00,'2023-03-05 13:21:21'),(107,'4','283',1,'Retail Sale Id 114',0.00,3680.00,736.00,3680.00,0.00,'2023-03-05 13:24:18'),(108,'4','283',1,'Retail Sale Id 116',0.00,2208.00,736.00,2208.00,0.00,'2023-03-05 13:29:20'),(109,'4','283',1,'Retail Sale Id 117',0.00,2208.00,736.00,2208.00,0.00,'2023-03-05 13:32:13'),(110,'4','283',1,'Retail Sale Id 118',0.00,3680.00,736.00,3680.00,0.00,'2023-03-05 13:34:55'),(111,'4','283',1,'Retail Sale Id 119',0.00,2944.00,736.00,2944.00,0.00,'2023-03-05 13:37:32'),(112,'4','283',1,'Retail Sale Id 120',0.00,2502.40,736.00,2502.40,0.00,'2023-03-05 13:39:55'),(113,'4','283',1,'Retail Sale Id 121',0.00,3002.88,736.00,3002.88,0.00,'2023-03-05 13:43:09'),(114,'4','283',1,'Retail Sale Id 122',0.00,736.00,736.00,736.00,0.00,'2023-03-05 13:45:44'),(115,'4','283',1,'Retail Sale Id 123',0.00,18400.00,736.00,18400.00,0.00,'2023-03-05 13:47:49'),(116,'4','283',1,'Retail Sale Id 124',0.00,9200.00,736.00,9200.00,0.00,'2023-03-05 13:50:17'),(117,'4','283',1,'Retail Sale Id 125',0.00,1000.96,736.00,1000.96,0.00,'2023-03-05 13:52:36'),(118,'4','283',1,'Retail Sale Id 126',0.00,4416.00,736.00,4416.00,0.00,'2023-03-05 13:59:02'),(119,'4','283',1,'Retail Sale Id 127',0.00,4416.00,736.00,4416.00,0.00,'2023-03-05 14:01:08'),(120,'4','283',1,'Retail Sale Id 128',0.00,1501.44,736.00,1501.44,0.00,'2023-03-05 17:03:50'),(121,'4','283',1,'Retail Sale Id 129',0.00,12880.00,736.00,12880.00,0.00,'2023-03-05 17:07:41'),(122,'4','283',1,'Retail Sale Id 130',0.00,12144.00,736.00,12144.00,0.00,'2023-03-05 17:10:11'),(123,'4','283',1,'Retail Sale Id 131',0.00,9200.00,736.00,9200.00,0.00,'2023-03-05 17:12:49'),(124,'4','283',1,'Retail Sale Id 132',0.00,1472.00,736.00,1472.00,0.00,'2023-03-05 17:19:09'),(125,'4','283',1,'Retail Sale Id 133',0.00,397.44,736.00,397.44,0.00,'2023-03-05 17:21:59'),(126,'4','283',1,'Retail Sale Id 134',0.00,7360.00,736.00,7360.00,0.00,'2023-03-05 17:24:40'),(127,'4','283',1,'Retail Sale Id 135',0.00,3680.00,736.00,3680.00,0.00,'2023-03-05 17:28:31'),(128,'4','283',1,'Retail Sale Id 136',0.00,736.00,736.00,736.00,0.00,'2023-03-05 17:30:35'),(129,'4','283',1,'Retail Sale Id 137',0.00,3680.00,736.00,3680.00,0.00,'2023-03-05 17:33:04'),(130,'4','283',1,'Retail Sale Id 138',0.00,2944.00,736.00,2944.00,0.00,'2023-03-05 17:35:45'),(131,'4','283',1,'Retail Sale Id 139',0.00,3680.00,736.00,3680.00,0.00,'2023-03-05 17:40:47'),(132,'4','283',1,'Retail Sale Id 140',0.00,3680.00,736.00,3680.00,0.00,'2023-03-05 17:42:49'),(133,'4','283',1,'Retail Sale Id 141',0.00,4416.00,736.00,4416.00,0.00,'2023-03-05 17:44:55'),(134,'4','283',1,'Retail Sale Id 142',0.00,3680.00,736.00,3680.00,0.00,'2023-03-05 17:47:32'),(135,'4','283',1,'Retail Sale Id 143',0.00,1000.96,736.00,1000.96,0.00,'2023-03-05 17:49:56'),(136,'4','283',1,'Retail Sale Id 144',0.00,3002.88,736.00,3002.88,0.00,'2023-03-05 17:52:37'),(137,'4','283',1,'Return of Retail Sale Id 144',3002.88,0.00,736.00,-3002.88,0.00,'2023-03-05 17:53:41'),(138,'4','283',1,'Retail Sale Id 145',0.00,9200.00,736.00,9200.00,0.00,'2023-03-05 17:55:25'),(139,'4','283',1,'Return of Retail Sale Id 140',3680.00,0.00,736.00,-3680.00,0.00,'2023-03-05 17:58:23'),(140,'4','283',1,'Retail Sale Id 146',0.00,9200.00,736.00,9200.00,0.00,'2023-03-06 08:03:35'),(141,'4','283',1,'Retail Sale Id 149',0.00,2208.00,736.00,2208.00,0.00,'2023-03-06 08:06:45'),(142,'4','283',1,'Retail Sale Id 150',0.00,18400.00,736.00,18400.00,0.00,'2023-03-06 08:08:27'),(143,'4','283',1,'Retail Sale Id 151',0.00,5998.40,736.00,5998.40,0.00,'2023-03-06 08:10:33'),(144,'4','283',1,'Retail Sale Id 152',0.00,1472.00,736.00,1472.00,0.00,'2023-03-06 08:13:58'),(145,'4','283',1,'Retail Sale Id 155',0.00,9200.00,736.00,9200.00,0.00,'2023-03-06 08:16:15'),(146,'4','283',1,'Retail Sale Id 157',0.00,8832.00,736.00,8832.00,0.00,'2023-03-06 08:18:01'),(147,'4','283',1,'Retail Sale Id 158',0.00,750.72,736.00,750.72,0.00,'2023-03-06 08:30:11'),(148,'4','283',1,'Retail Sale Id 159',0.00,6992.00,736.00,6992.00,0.00,'2023-03-06 08:33:23'),(149,'4','283',1,'Retail Sale Id 160',0.00,8832.00,736.00,8832.00,0.00,'2023-03-06 08:43:50'),(150,'4','283',1,'Retail Sale Id 162',0.00,2303.68,736.00,2303.68,0.00,'2023-03-06 08:49:27'),(151,'4','283',1,'Retail Sale Id 164',0.00,3996.48,736.00,3996.48,0.00,'2023-03-06 09:03:07'),(152,'4','283',1,'Retail Sale Id 165',0.00,2208.00,736.00,2208.00,0.00,'2023-03-06 09:10:33'),(153,'4','283',1,'Retail Sale Id 166',0.00,4416.00,736.00,4416.00,0.00,'2023-03-06 09:12:19'),(154,'4','283',1,'Retail Sale Id 167',0.00,3002.88,736.00,3002.88,0.00,'2023-03-06 09:15:27'),(155,'4','283',1,'Retail Sale Id 168',0.00,2208.00,736.00,2208.00,0.00,'2023-03-06 09:17:14'),(156,'4','283',1,'Retail Sale Id 169',0.00,11408.00,736.00,11408.00,0.00,'2023-03-06 09:20:35'),(157,'4','283',1,'Retail Sale Id 170',0.00,2208.00,736.00,2208.00,0.00,'2023-03-06 09:23:56'),(158,'4','283',1,'Retail Sale Id 171',0.00,4416.00,736.00,4416.00,0.00,'2023-03-06 09:26:30'),(159,'4','283',1,'Retail Sale Id 172',0.00,9200.00,736.00,9200.00,0.00,'2023-03-09 13:07:05'),(160,'4','283',1,'Retail Sale Id 173',0.00,3680.00,736.00,3680.00,0.00,'2023-03-09 13:17:43'),(161,'4','283',1,'Retail Sale Id 174',0.00,2208.00,736.00,2208.00,0.00,'2023-03-09 13:24:50'),(162,'4','283',1,'Retail Sale Id 175',0.00,2208.00,736.00,2208.00,0.00,'2023-03-09 13:53:23'),(163,'4','283',1,'Retail Sale Id 176',0.00,4416.00,736.00,4416.00,0.00,'2023-03-09 13:57:53'),(164,'4','283',1,'Retail Sale Id 177',0.00,6624.00,736.00,6624.00,0.00,'2023-03-09 14:08:01'),(165,'4','283',1,'Retail Sale Id 178',0.00,3680.00,736.00,3680.00,0.00,'2023-03-09 14:23:34'),(166,'4','283',1,'Retail Sale Id 179',0.00,9200.00,736.00,9200.00,0.00,'2023-03-09 14:38:25'),(167,'4','283',1,'Retail Sale Id 180',0.00,18400.00,736.00,18400.00,0.00,'2023-03-09 14:41:37'),(168,'4','283',1,'Retail Sale Id 181',0.00,4416.00,736.00,4416.00,0.00,'2023-03-09 14:44:01'),(169,'4','283',1,'Retail Sale Id 182',0.00,4416.00,736.00,4416.00,0.00,'2023-03-09 14:45:47'),(170,'4','283',1,'Retail Sale Id 183',0.00,9200.00,710.00,8875.00,-325.00,'2023-03-09 14:53:59'),(171,'4','283',1,'Retail Sale Id 184',0.00,736.00,736.00,736.00,0.00,'2023-03-09 14:56:17'),(172,'4','283',1,'Retail Sale Id 185',0.00,2001.92,736.00,2001.92,0.00,'2023-03-09 14:58:46'),(173,'4','283',1,'Retail Sale Id 186',0.00,3680.00,736.00,3680.00,0.00,'2023-03-09 15:01:34'),(174,'4','283',1,'Retail Sale Id 187',0.00,2208.00,736.00,2208.00,0.00,'2023-03-09 15:03:52'),(175,'4','283',1,'Retail Sale Id 188',0.00,2208.00,736.00,2208.00,0.00,'2023-03-09 15:05:54'),(176,'4','283',1,'Retail Sale Id 189',0.00,3680.00,736.00,3680.00,0.00,'2023-03-09 15:08:01'),(177,'4','283',1,'Retail Sale Id 190',0.00,4997.44,736.00,4997.44,0.00,'2023-03-09 15:09:54'),(178,'4','283',1,'Retail Sale Id 191',0.00,2001.92,736.00,2001.92,0.00,'2023-03-09 15:11:51'),(179,'4','283',1,'Retail Sale Id 192',0.00,2944.00,736.00,2944.00,0.00,'2023-03-09 15:13:34'),(180,'4','283',1,'Retail Sale Id 193',0.00,2208.00,736.00,2208.00,0.00,'2023-03-09 15:15:58'),(181,'4','283',1,'Retail Sale Id 194',0.00,4416.00,736.00,4416.00,0.00,'2023-03-09 15:17:53'),(182,'4','283',1,'Retail Sale Id 195',0.00,3680.00,736.00,3680.00,0.00,'2023-03-09 15:23:27'),(183,'4','283',1,'Retail Sale Id 196',0.00,13616.00,736.00,13616.00,0.00,'2023-03-09 15:27:53'),(184,'4','283',1,'Retail Sale Id 197',0.00,5888.00,736.00,5888.00,0.00,'2023-03-09 15:30:21'),(185,'4','283',1,'Retail Sale Id 198',0.00,2944.00,736.00,2944.00,0.00,'2023-03-09 15:35:43'),(186,'4','283',1,'Retail Sale Id 199',0.00,9200.00,736.00,9200.00,0.00,'2023-03-09 15:38:01'),(187,'4','283',1,'Retail Sale Id 200',0.00,2208.00,736.00,2208.00,0.00,'2023-03-09 15:41:21'),(188,'4','283',1,'Retail Sale Id 201',0.00,7360.00,736.00,7360.00,0.00,'2023-03-09 15:43:09'),(189,'4','283',1,'Retail Sale Id 202',0.00,4416.00,736.00,4416.00,0.00,'2023-03-09 15:45:44'),(190,'4','283',1,'Retail Sale Id 205',0.00,4416.00,736.00,4416.00,0.00,'2023-03-09 15:59:05'),(191,'4','283',1,'Retail Sale Id 206',0.00,5152.00,736.00,5152.00,0.00,'2023-03-09 16:01:52'),(192,'4','283',1,'Retail Sale Id 207',0.00,9200.00,736.00,9200.00,0.00,'2023-03-09 16:07:16'),(193,'4','283',1,'Retail Sale Id 209',0.00,3680.00,736.00,3680.00,0.00,'2023-03-09 16:10:59'),(194,'4','283',1,'Retail Sale Id 210',0.00,7360.00,736.00,7360.00,0.00,'2023-03-09 16:30:13'),(195,'4','283',1,'Retail Sale Id 212',0.00,1501.44,736.00,1501.44,0.00,'2023-03-09 16:33:46'),(196,'4','283',1,'Retail Sale Id 213',0.00,15456.00,736.00,15456.00,0.00,'2023-03-09 16:38:29'),(197,'4','283',1,'Retail Sale Id 214',0.00,2944.00,736.00,2944.00,0.00,'2023-03-09 16:40:21'),(198,'4','283',1,'Retail Sale Id 215',0.00,4416.00,736.00,4416.00,0.00,'2023-03-09 16:45:49'),(199,'4','283',1,'Retail Sale Id 216',0.00,27232.00,736.00,27232.00,0.00,'2023-03-09 16:51:41'),(200,'4','283',1,'Retail Sale Id 217',0.00,3996.48,736.00,3996.48,0.00,'2023-03-09 16:55:31'),(201,'4','283',1,'Retail Sale Id 218',0.00,3680.00,736.00,3680.00,0.00,'2023-03-09 17:06:29'),(202,'4','283',1,'Retail Sale Id 219',0.00,2208.00,736.00,2208.00,0.00,'2023-03-09 17:12:08'),(203,'4','283',1,'Retail Sale Id 220',0.00,3996.48,736.00,3996.48,0.00,'2023-03-09 17:14:26'),(204,'4','283',1,'Retail Sale Id 221',0.00,4997.44,736.00,4997.44,0.00,'2023-03-09 17:19:29'),(205,'4','283',1,'Retail Sale Id 222',0.00,4416.00,736.00,4416.00,0.00,'2023-03-09 17:21:38'),(206,'4','283',1,'Retail Sale Id 223',0.00,2208.00,736.00,2208.00,0.00,'2023-03-09 17:23:44'),(207,'4','283',1,'Retail Sale Id 224',0.00,8832.00,736.00,8832.00,0.00,'2023-03-09 17:25:32'),(208,'4','283',1,'Retail Sale Id 225',0.00,9200.00,736.00,9200.00,0.00,'2023-03-09 17:27:26'),(209,'4','283',1,'Retail Sale Id 226',0.00,1472.00,736.00,1472.00,0.00,'2023-03-09 17:31:29'),(210,'4','283',1,'Retail Sale Id 227',0.00,1199.68,736.00,1199.68,0.00,'2023-03-09 17:36:10'),(211,'4','283',1,'Retail Sale Id 228',0.00,1501.44,736.00,1501.44,0.00,'2023-03-09 17:39:35'),(212,'4','283',1,'Retail Sale Id 229',0.00,4416.00,736.00,4416.00,0.00,'2023-03-09 17:42:10'),(213,'4','283',1,'Retail Sale Id 230',0.00,9200.00,736.00,9200.00,0.00,'2023-03-09 17:44:07'),(214,'4','283',1,'Retail Sale Id 231',0.00,2208.00,736.00,2208.00,0.00,'2023-03-09 17:49:39'),(215,'4','283',1,'Retail Sale Id 232',0.00,2502.40,736.00,2502.40,0.00,'2023-03-09 17:51:36'),(216,'4','283',1,'Retail Sale Id 233',0.00,4416.00,736.00,4416.00,0.00,'2023-03-09 17:53:32'),(217,'4','283',1,'Retail Sale Id 234',0.00,1000.96,736.00,1000.96,0.00,'2023-03-10 09:00:09'),(218,'4','283',1,'Retail Sale Id 235',0.00,6624.00,736.00,6624.00,0.00,'2023-03-10 09:30:06'),(219,'4','283',1,'Retail Sale Id 236',0.00,9200.00,736.00,9200.00,0.00,'2023-03-10 09:47:01'),(220,'4','283',1,'Retail Sale Id 237',0.00,4416.00,736.00,4416.00,0.00,'2023-03-10 09:48:35'),(221,'4','283',1,'Retail Sale Id 238',0.00,13616.00,736.00,13616.00,0.00,'2023-03-10 09:50:50'),(222,'4','283',1,'Retail Sale Id 239',0.00,3680.00,736.00,3680.00,0.00,'2023-03-10 09:52:11'),(223,'4','283',1,'Retail Sale Id 240',0.00,2208.00,736.00,2208.00,0.00,'2023-03-10 09:53:25'),(224,'4','283',1,'Retail Sale Id 241',0.00,2001.92,736.00,2001.92,0.00,'2023-03-10 09:55:36'),(225,'4','283',1,'Retail Sale Id 243',0.00,4416.00,736.00,4416.00,0.00,'2023-03-10 09:57:59'),(226,'4','283',1,'Retail Sale Id 245',0.00,8096.00,736.00,8096.00,0.00,'2023-03-10 09:59:08'),(227,'4','283',1,'Retail Sale Id 246',0.00,2944.00,736.00,2944.00,0.00,'2023-03-10 10:00:14'),(228,'4','283',1,'Retail Sale Id 247',0.00,1472.00,736.00,1472.00,0.00,'2023-03-10 10:01:54'),(229,'4','283',1,'Retail Sale Id 248',0.00,8832.00,736.00,8832.00,0.00,'2023-03-10 10:04:11'),(230,'4','283',1,'Retail Sale Id 249',0.00,2208.00,736.00,2208.00,0.00,'2023-03-10 10:06:38'),(231,'4','283',1,'Retail Sale Id 251',0.00,9200.00,736.00,9200.00,0.00,'2023-03-10 10:08:02'),(232,'4','283',1,'Retail Sale Id 252',0.00,1472.00,736.00,1472.00,0.00,'2023-03-10 10:14:18'),(233,'4','283',1,'Retail Sale Id 253',0.00,4416.00,736.00,4416.00,0.00,'2023-03-10 10:15:50'),(234,'4','283',1,'Retail Sale Id 254',0.00,4997.44,736.00,4997.44,0.00,'2023-03-10 10:17:19'),(235,'4','283',1,'Retail Sale Id 255',0.00,4416.00,736.00,4416.00,0.00,'2023-03-10 10:18:48'),(236,'4','283',1,'Retail Sale Id 257',0.00,9200.00,736.00,9200.00,0.00,'2023-03-10 10:20:33'),(237,'4','283',1,'Retail Sale Id 258',0.00,2208.00,736.00,2208.00,0.00,'2023-03-10 10:23:50'),(238,'4','283',1,'Retail Sale Id 259',0.00,9200.00,736.00,9200.00,0.00,'2023-03-10 10:27:12'),(239,'4','283',1,'Retail Sale Id 260',0.00,4997.44,736.00,4997.44,0.00,'2023-03-10 10:40:07'),(240,'4','283',1,'Retail Sale Id 262',0.00,2208.00,736.00,2208.00,0.00,'2023-03-10 10:42:04'),(241,'4','283',1,'Retail Sale Id 264',0.00,2001.92,736.00,2001.92,0.00,'2023-03-10 10:45:28'),(242,'4','283',1,'Retail Sale Id 266',0.00,73600.00,710.00,71000.00,-2600.00,'2023-03-10 10:48:40'),(243,'4','283',1,'Retail Sale Id 268',0.00,9200.00,736.00,9200.00,0.00,'2023-03-10 10:52:21'),(244,'4','283',1,'Retail Sale Id 269',0.00,1472.00,736.00,1472.00,0.00,'2023-03-10 10:53:50'),(245,'4','283',1,'Retail Sale Id 270',0.00,9200.00,736.00,9200.00,0.00,'2023-03-10 10:55:05'),(246,'4','283',1,'Retail Sale Id 272',0.00,1000.96,736.00,1000.96,0.00,'2023-03-10 10:58:04'),(247,'4','283',1,'Retail Sale Id 273',0.00,5998.40,736.00,5998.40,0.00,'2023-03-10 11:02:48'),(248,'4','283',1,'Retail Sale Id 274',0.00,9200.00,736.00,9200.00,0.00,'2023-03-10 11:05:25'),(249,'4','283',1,'Retail Sale Id 275',0.00,2001.92,736.00,2001.92,0.00,'2023-03-10 11:06:51'),(250,'4','283',1,'Retail Sale Id 276',0.00,70656.00,710.00,68160.00,-2496.00,'2023-03-10 11:13:54'),(251,'4','283',1,'Retail Sale Id 278',0.00,9200.00,736.00,9200.00,0.00,'2023-03-10 11:24:46'),(252,'4','283',1,'Retail Sale Id 280',0.00,2001.92,736.00,2001.92,0.00,'2023-03-10 11:26:49'),(253,'4','283',1,'Retail Sale Id 281',0.00,2200.64,736.00,2200.64,0.00,'2023-03-10 11:39:30'),(254,'4','283',1,'Retail Sale Id 283',0.00,3680.00,736.00,3680.00,0.00,'2023-03-10 11:48:35'),(255,'4','283',1,'Retail Sale Id 284',0.00,6624.00,736.00,6624.00,0.00,'2023-03-10 11:51:43'),(256,'4','283',1,'Retail Sale Id 286',0.00,1000.96,736.00,1000.96,0.00,'2023-03-10 12:03:49'),(257,'4','283',1,'Retail Sale Id 287',0.00,9200.00,736.00,9200.00,0.00,'2023-03-10 12:08:02'),(258,'4','283',1,'Retail Sale Id 289',0.00,3002.88,736.00,3002.88,0.00,'2023-03-10 12:10:24'),(259,'4','283',1,'Retail Sale Id 290',0.00,3996.48,736.00,3996.48,0.00,'2023-03-10 12:22:57'),(260,'4','283',1,'Retail Sale Id 292',0.00,2502.40,736.00,2502.40,0.00,'2023-03-10 12:27:29'),(261,'4','283',1,'Retail Sale Id 293',0.00,3680.00,736.00,3680.00,0.00,'2023-03-10 12:32:30'),(262,'4','283',1,'Retail Sale Id 294',0.00,2208.00,736.00,2208.00,0.00,'2023-03-10 12:35:41'),(263,'4','283',1,'Retail Sale Id 295',0.00,4416.00,736.00,4416.00,0.00,'2023-03-10 12:50:56'),(264,'4','283',1,'Retail Sale Id 296',0.00,18400.00,736.00,18400.00,0.00,'2023-03-10 12:52:46'),(265,'4','283',1,'Retail Sale Id 297',0.00,2200.64,736.00,2200.64,0.00,'2023-03-10 12:57:40'),(266,'4','283',1,'Retail Sale Id 298',0.00,3002.88,736.00,3002.88,0.00,'2023-03-10 13:08:22'),(267,'4','283',1,'Retail Sale Id 300',0.00,9200.00,736.00,9200.00,0.00,'2023-03-10 13:11:01'),(268,'4','283',1,'Retail Sale Id 301',0.00,36800.00,710.00,35500.00,-1300.00,'2023-03-10 13:13:55'),(269,'4','283',1,'Retail Sale Id 302',0.00,1472.00,736.00,1472.00,0.00,'2023-03-10 13:15:31'),(270,'4','283',1,'Retail Sale Id 303',0.00,9200.00,736.00,9200.00,0.00,'2023-03-10 13:18:36'),(271,'4','283',1,'Retail Sale Id 304',0.00,3996.48,736.00,3996.48,0.00,'2023-03-10 13:21:04'),(272,'4','283',1,'Retail Sale Id 306',0.00,11408.00,736.00,11408.00,0.00,'2023-03-10 13:23:43'),(273,'4','283',1,'Retail Sale Id 307',0.00,8832.00,736.00,8832.00,0.00,'2023-03-10 14:10:30'),(274,'4','283',1,'Retail Sale Id 308',0.00,2208.00,736.00,2208.00,0.00,'2023-03-10 14:21:58'),(275,'4','283',1,'Retail Sale Id 309',0.00,2208.00,736.00,2208.00,0.00,'2023-03-10 14:23:29'),(276,'4','283',1,'Retail Sale Id 310',0.00,4997.44,736.00,4997.44,0.00,'2023-03-10 14:26:14'),(277,'4','283',1,'Retail Sale Id 311',0.00,4416.00,736.00,4416.00,0.00,'2023-03-10 14:28:50'),(278,'4','283',1,'Retail Sale Id 312',0.00,9200.00,736.00,9200.00,0.00,'2023-03-10 14:47:20'),(279,'4','283',1,'Retail Sale Id 313',0.00,9200.00,736.00,9200.00,0.00,'2023-03-10 14:49:07'),(280,'4','283',1,'Retail Sale Id 315',0.00,11408.00,736.00,11408.00,0.00,'2023-03-10 14:55:08'),(281,'4','283',1,'Retail Sale Id 316',0.00,2944.00,736.00,2944.00,0.00,'2023-03-10 15:06:30'),(282,'4','283',1,'Retail Sale Id 318',0.00,9200.00,736.00,9200.00,0.00,'2023-03-10 15:08:06'),(283,'4','283',1,'Retail Sale Id 321',0.00,2001.92,736.00,2001.92,0.00,'2023-03-10 15:09:50'),(284,'4','283',1,'Retail Sale Id 322',0.00,12880.00,736.00,12880.00,0.00,'2023-03-10 15:47:32'),(285,'4','283',1,'Retail Sale Id 324',0.00,3680.00,736.00,3680.00,0.00,'2023-03-10 15:49:24'),(286,'4','283',1,'Retail Sale Id 325',0.00,4416.00,736.00,4416.00,0.00,'2023-03-10 15:58:38'),(287,'4','283',1,'Retail Sale Id 327',0.00,2208.00,736.00,2208.00,0.00,'2023-03-10 16:15:34'),(288,'4','283',1,'Retail Sale Id 329',0.00,7360.00,736.00,7360.00,0.00,'2023-03-10 16:17:37'),(289,'4','283',1,'Retail Sale Id 330',0.00,2303.68,736.00,2303.68,0.00,'2023-03-10 16:20:00'),(290,'4','283',1,'Retail Sale Id 331',0.00,8832.00,736.00,8832.00,0.00,'2023-03-10 16:22:28'),(291,'4','283',1,'Retail Sale Id 332',0.00,9200.00,736.00,9200.00,0.00,'2023-03-10 16:23:30'),(292,'4','283',1,'Retail Sale Id 333',0.00,3680.00,736.00,3680.00,0.00,'2023-03-10 16:25:00'),(293,'4','283',1,'Retail Sale Id 334',0.00,9200.00,736.00,9200.00,0.00,'2023-03-10 16:34:09'),(294,'4','283',1,'Retail Sale Id 335',0.00,4416.00,736.00,4416.00,0.00,'2023-03-10 16:38:01'),(295,'4','283',1,'Retail Sale Id 336',0.00,3002.88,736.00,3002.88,0.00,'2023-03-10 16:39:31'),(296,'4','283',1,'Retail Sale Id 337',0.00,36800.00,710.00,35500.00,-1300.00,'2023-03-10 17:35:52'),(297,'4','283',1,'Retail Sale Id 339',0.00,4416.00,736.00,4416.00,0.00,'2023-03-11 09:45:10'),(298,'4','283',1,'Retail Sale Id 340',0.00,2208.00,736.00,2208.00,0.00,'2023-03-11 10:54:14'),(299,'4','283',1,'Retail Sale Id 342',0.00,2208.00,736.00,2208.00,0.00,'2023-03-11 10:57:12'),(300,'4','283',1,'Retail Sale Id 344',0.00,5299.20,736.00,5299.20,0.00,'2023-03-11 11:24:42'),(301,'4','283',1,'Retail Sale Id 345',0.00,5888.00,736.00,5888.00,0.00,'2023-03-11 11:27:29'),(302,'4','283',1,'Retail Sale Id 346',0.00,1501.44,736.00,1501.44,0.00,'2023-03-11 11:32:33'),(303,'4','283',1,'Retail Sale Id 347',0.00,9200.00,736.00,9200.00,0.00,'2023-03-11 11:37:08'),(304,'4','283',1,'Retail Sale Id 348',0.00,3996.48,736.00,3996.48,0.00,'2023-03-11 11:40:42'),(305,'4','283',1,'Retail Sale Id 349',0.00,2944.00,736.00,2944.00,0.00,'2023-03-11 11:45:05'),(306,'4','283',1,'Retail Sale Id 350',0.00,4416.00,736.00,4416.00,0.00,'2023-03-11 11:56:01'),(307,'4','283',1,'Retail Sale Id 351',0.00,4416.00,736.00,4416.00,0.00,'2023-03-11 12:02:07'),(308,'4','283',1,'Retail Sale Id 352',0.00,1472.00,736.00,1472.00,0.00,'2023-03-11 12:20:16'),(309,'4','283',1,'Retail Sale Id 353',0.00,9200.00,736.00,9200.00,0.00,'2023-03-11 12:24:31'),(310,'4','283',1,'Retail Sale Id 354',0.00,9200.00,736.00,9200.00,0.00,'2023-03-11 12:26:57'),(311,'4','283',1,'Retail Sale Id 355',0.00,1000.96,736.00,1000.96,0.00,'2023-03-11 12:28:41'),(312,'4','283',1,'Retail Sale Id 356',0.00,2208.00,736.00,2208.00,0.00,'2023-03-11 12:31:43'),(313,'4','283',1,'Retail Sale Id 357',0.00,4997.44,736.00,4997.44,0.00,'2023-03-11 12:34:51'),(314,'4','283',1,'Retail Sale Id 358',0.00,736.00,736.00,736.00,0.00,'2023-03-11 12:42:26'),(315,'4','283',1,'Retail Sale Id 359',0.00,3002.88,736.00,3002.88,0.00,'2023-03-11 12:46:17'),(316,'4','283',1,'Retail Sale Id 360',0.00,2208.00,736.00,2208.00,0.00,'2023-03-11 12:52:33'),(317,'4','283',1,'Retail Sale Id 361',0.00,9200.00,736.00,9200.00,0.00,'2023-03-11 12:54:57'),(318,'4','283',1,'Retail Sale Id 362',0.00,9568.00,736.00,9568.00,0.00,'2023-03-11 12:59:39'),(319,'4','283',1,'Retail Sale Id 363',0.00,11040.00,736.00,11040.00,0.00,'2023-03-11 13:02:26'),(320,'4','283',1,'Retail Sale Id 364',0.00,36800.00,710.00,35500.00,-1300.00,'2023-03-11 13:12:15'),(321,'4','283',1,'Retail Sale Id 365',0.00,9200.00,736.00,9200.00,0.00,'2023-03-11 13:14:20'),(322,'4','283',1,'Retail Sale Id 366',0.00,9200.00,736.00,9200.00,0.00,'2023-03-11 13:17:57'),(323,'4','283',1,'Retail Sale Id 367',0.00,9200.00,736.00,9200.00,0.00,'2023-03-11 13:27:24'),(324,'4','283',1,'Retail Sale Id 368',0.00,6624.00,736.00,6624.00,0.00,'2023-03-11 13:35:32'),(325,'4','283',1,'Retail Sale Id 369',0.00,4997.44,736.00,4997.44,0.00,'2023-03-11 13:44:15'),(326,'4','283',1,'Retail Sale Id 370',0.00,1472.00,736.00,1472.00,0.00,'2023-03-11 13:48:01'),(327,'4','283',1,'Retail Sale Id 371',0.00,9200.00,736.00,9200.00,0.00,'2023-03-11 13:51:32'),(328,'4','283',1,'Retail Sale Id 372',0.00,1472.00,736.00,1472.00,0.00,'2023-03-11 13:57:47'),(329,'4','283',1,'Retail Sale Id 373',0.00,2208.00,736.00,2208.00,0.00,'2023-03-11 14:00:50'),(330,'4','283',1,'Retail Sale Id 375',0.00,4416.00,736.00,4416.00,0.00,'2023-03-11 14:03:35'),(331,'4','283',1,'Retail Sale Id 376',0.00,3680.00,736.00,3680.00,0.00,'2023-03-11 14:05:54'),(332,'4','283',1,'Retail Sale Id 377',0.00,8832.00,736.00,8832.00,0.00,'2023-03-11 14:20:08'),(333,'4','283',1,'Retail Sale Id 378',0.00,9200.00,736.00,9200.00,0.00,'2023-03-11 14:22:21'),(334,'4','283',1,'Retail Sale Id 379',0.00,2208.00,736.00,2208.00,0.00,'2023-03-11 14:25:01'),(335,'4','283',1,'Retail Sale Id 380',0.00,9200.00,736.00,9200.00,0.00,'2023-03-11 14:27:25'),(336,'4','283',1,'Retail Sale Id 381',0.00,2208.00,710.00,2130.00,-78.00,'2023-03-11 14:30:48'),(337,'4','283',1,'Retail Sale Id 382',0.00,2208.00,736.00,2208.00,0.00,'2023-03-11 14:33:20'),(338,'4','283',1,'Retail Sale Id 383',0.00,2944.00,736.00,2944.00,0.00,'2023-03-11 14:35:54'),(339,'4','283',1,'Retail Sale Id 384',0.00,5152.00,736.00,5152.00,0.00,'2023-03-11 14:38:39'),(340,'4','283',1,'Retail Sale Id 385',0.00,9200.00,736.00,9200.00,0.00,'2023-03-11 14:42:37'),(341,'4','283',1,'Retail Sale Id 386',0.00,9200.00,736.00,9200.00,0.00,'2023-03-11 14:46:11'),(342,'4','283',1,'Retail Sale Id 387',0.00,2001.92,736.00,2001.92,0.00,'2023-03-11 14:57:22'),(343,'4','283',1,'Retail Sale Id 388',0.00,8832.00,736.00,8832.00,0.00,'2023-03-11 15:00:37'),(344,'4','283',1,'Retail Sale Id 389',0.00,7360.00,736.00,7360.00,0.00,'2023-03-11 15:12:40'),(345,'4','283',1,'Retail Sale Id 390',0.00,9200.00,736.00,9200.00,0.00,'2023-03-11 15:22:44'),(346,'4','283',1,'Retail Sale Id 391',0.00,4416.00,736.00,4416.00,0.00,'2023-03-11 15:34:14'),(347,'4','283',1,'Retail Sale Id 392',0.00,4416.00,736.00,4416.00,0.00,'2023-03-11 15:41:50'),(348,'4','283',1,'Retail Sale Id 393',0.00,2944.00,736.00,2944.00,0.00,'2023-03-11 15:44:23'),(349,'4','283',1,'Retail Sale Id 394',0.00,4401.28,736.00,4401.28,0.00,'2023-03-11 15:48:20'),(350,'4','283',1,'Retail Sale Id 395',0.00,4496.96,736.00,4496.96,0.00,'2023-03-11 15:50:43'),(351,'4','283',1,'Retail Sale Id 396',0.00,1501.44,736.00,1501.44,0.00,'2023-03-11 15:52:46'),(352,'4','283',1,'Retail Sale Id 397',0.00,3680.00,736.00,3680.00,0.00,'2023-03-11 15:55:06'),(353,'4','283',1,'Retail Sale Id 398',0.00,3680.00,736.00,3680.00,0.00,'2023-03-11 15:56:50'),(354,'4','283',1,'Retail Sale Id 399',0.00,1000.96,736.00,1000.96,0.00,'2023-03-11 15:59:59'),(355,'4','283',1,'Retail Sale Id 400',0.00,8832.00,736.00,8832.00,0.00,'2023-03-11 16:01:52'),(356,'4','283',1,'Retail Sale Id 401',0.00,2208.00,736.00,2208.00,0.00,'2023-03-11 16:03:59'),(357,'4','283',1,'Retail Sale Id 403',0.00,3996.48,736.00,3996.48,0.00,'2023-03-11 16:09:33'),(358,'4','283',1,'Retail Sale Id 404',0.00,4416.00,736.00,4416.00,0.00,'2023-03-11 16:18:35'),(359,'4','283',1,'Retail Sale Id 405',0.00,8096.00,736.00,8096.00,0.00,'2023-03-11 16:21:26'),(360,'4','283',1,'Retail Sale Id 406',0.00,9200.00,736.00,9200.00,0.00,'2023-03-11 16:23:23'),(361,'4','283',1,'Retail Sale Id 407',0.00,4997.44,736.00,4997.44,0.00,'2023-03-11 16:28:29'),(362,'4','283',1,'Retail Sale Id 408',0.00,3002.88,736.00,3002.88,0.00,'2023-03-11 16:31:50'),(363,'4','283',1,'Retail Sale Id 409',0.00,8832.00,736.00,8832.00,0.00,'2023-03-11 16:35:26'),(364,'4','283',1,'Retail Sale Id 410',0.00,9200.00,736.00,9200.00,0.00,'2023-03-11 16:39:38'),(365,'4','283',1,'Retail Sale Id 411',0.00,9200.00,736.00,9200.00,0.00,'2023-03-11 16:42:22'),(366,'4','283',1,'Retail Sale Id 412',0.00,3680.00,736.00,3680.00,0.00,'2023-03-11 16:46:15'),(367,'4','283',1,'Retail Sale Id 413',0.00,4997.44,736.00,4997.44,0.00,'2023-03-11 16:48:28'),(368,'4','283',1,'Retail Sale Id 414',0.00,8832.00,736.00,8832.00,0.00,'2023-03-11 16:52:24'),(369,'4','283',1,'Retail Sale Id 415',0.00,3680.00,736.00,3680.00,0.00,'2023-03-11 16:54:48'),(370,'4','283',1,'Retail Sale Id 416',0.00,4416.00,736.00,4416.00,0.00,'2023-03-11 17:03:33'),(371,'4','283',1,'Retail Sale Id 417',0.00,4416.00,736.00,4416.00,0.00,'2023-03-11 17:06:36'),(372,'4','283',1,'Retail Sale Id 418',0.00,9200.00,736.00,9200.00,0.00,'2023-03-11 17:10:18'),(373,'4','283',1,'Retail Sale Id 419',0.00,1501.44,736.00,1501.44,0.00,'2023-03-11 17:14:27'),(374,'4','283',1,'Retail Sale Id 420',0.00,2208.00,736.00,2208.00,0.00,'2023-03-11 17:17:20'),(375,'4','283',1,'Retail Sale Id 421',0.00,1472.00,736.00,1472.00,0.00,'2023-03-11 17:20:14'),(376,'4','283',1,'Retail Sale Id 422',0.00,9200.00,736.00,9200.00,0.00,'2023-03-11 17:22:13'),(377,'4','283',1,'Retail Sale Id 423',0.00,9200.00,736.00,9200.00,0.00,'2023-03-11 17:28:54'),(378,'4','283',1,'Retail Sale Id 424',0.00,6624.00,736.00,6624.00,0.00,'2023-03-11 17:30:51'),(379,'4','283',1,'Retail Sale Id 425',0.00,2208.00,736.00,2208.00,0.00,'2023-03-11 17:35:11'),(380,'4','283',1,'Retail Sale Id 426',0.00,9200.00,736.00,9200.00,0.00,'2023-03-11 17:37:52'),(381,'4','283',1,'Retail Sale Id 427',0.00,2944.00,736.00,2944.00,0.00,'2023-03-11 17:40:38'),(382,'4','283',1,'Retail Sale Id 428',0.00,2208.00,736.00,2208.00,0.00,'2023-03-11 17:43:18'),(383,'4','283',1,'Retail Sale Id 429',0.00,2208.00,736.00,2208.00,0.00,'2023-03-11 17:48:04'),(384,'4','283',1,'Retail Sale Id 430',0.00,4416.00,736.00,4416.00,0.00,'2023-03-11 17:51:53'),(385,'4','283',1,'Retail Sale Id 431',0.00,4416.00,736.00,4416.00,0.00,'2023-03-11 17:57:56'),(386,'4','283',1,'Retail Sale Id 432',0.00,3002.88,736.00,3002.88,0.00,'2023-03-12 10:35:46'),(387,'4','283',1,'Retail Sale Id 433',0.00,3002.88,736.00,3002.88,0.00,'2023-03-12 10:41:27'),(388,'4','283',1,'Retail Sale Id 435',0.00,3680.00,736.00,3680.00,0.00,'2023-03-12 10:43:41'),(389,'4','283',1,'Retail Sale Id 436',0.00,2208.00,736.00,2208.00,0.00,'2023-03-12 10:48:38'),(390,'4','283',1,'Retail Sale Id 437',0.00,9200.00,736.00,9200.00,0.00,'2023-03-12 11:05:29'),(391,'4','283',1,'Retail Sale Id 438',0.00,3680.00,736.00,3680.00,0.00,'2023-03-12 11:06:57'),(392,'4','283',1,'Retail Sale Id 440',0.00,4416.00,736.00,4416.00,0.00,'2023-03-12 11:08:27'),(393,'4','283',1,'Retail Sale Id 441',0.00,9200.00,736.00,9200.00,0.00,'2023-03-12 11:10:19'),(394,'4','283',1,'Retail Sale Id 442',0.00,7499.84,736.00,7499.84,0.00,'2023-03-12 11:13:00'),(395,'4','283',1,'Retail Sale Id 443',0.00,8832.00,736.00,8832.00,0.00,'2023-03-12 11:14:49'),(396,'4','283',1,'Retail Sale Id 444',0.00,2208.00,736.00,2208.00,0.00,'2023-03-12 11:16:16'),(397,'4','283',1,'Retail Sale Id 445',0.00,9200.00,736.00,9200.00,0.00,'2023-03-12 11:27:06'),(398,'4','283',1,'Retail Sale Id 446',0.00,4416.00,736.00,4416.00,0.00,'2023-03-12 11:31:39'),(399,'4','283',1,'Retail Sale Id 447',0.00,1501.44,736.00,1501.44,0.00,'2023-03-12 11:33:50'),(400,'4','283',1,'Retail Sale Id 451',0.00,1472.00,736.00,1472.00,0.00,'2023-03-12 11:38:59'),(401,'4','283',1,'Retail Sale Id 452',0.00,2208.00,736.00,2208.00,0.00,'2023-03-12 11:40:26'),(402,'4','283',1,'Retail Sale Id 454',0.00,9200.00,736.00,9200.00,0.00,'2023-03-12 11:42:57'),(403,'4','283',1,'Retail Sale Id 455',0.00,1000.96,736.00,1000.96,0.00,'2023-03-12 11:45:20'),(404,'4','283',1,'Retail Sale Id 456',0.00,2944.00,736.00,2944.00,0.00,'2023-03-12 11:47:03'),(405,'4','283',1,'Retail Sale Id 459',0.00,11776.00,736.00,11776.00,0.00,'2023-03-12 11:52:39'),(406,'4','283',1,'Retail Sale Id 461',0.00,8000.32,736.00,8000.32,0.00,'2023-03-12 11:55:39'),(407,'4','283',1,'Retail Sale Id 462',0.00,9200.00,736.00,9200.00,0.00,'2023-03-12 12:01:27'),(408,'4','283',1,'Retail Sale Id 463',0.00,1501.44,736.00,1501.44,0.00,'2023-03-12 12:04:30'),(409,'4','283',1,'Retail Sale Id 465',0.00,7360.00,736.00,7360.00,0.00,'2023-03-12 12:06:27'),(410,'4','283',1,'Retail Sale Id 466',0.00,4416.00,736.00,4416.00,0.00,'2023-03-12 12:08:01'),(411,'4','283',1,'Retail Sale Id 468',0.00,3680.00,736.00,3680.00,0.00,'2023-03-12 12:09:45'),(412,'4','283',1,'Retail Sale Id 469',0.00,8832.00,736.00,8832.00,0.00,'2023-03-12 12:11:16'),(413,'4','283',1,'Retail Sale Id 471',0.00,2208.00,736.00,2208.00,0.00,'2023-03-12 12:13:17'),(414,'4','283',1,'Retail Sale Id 472',0.00,4416.00,736.00,4416.00,0.00,'2023-03-12 12:17:19'),(415,'4','283',1,'Retail Sale Id 474',0.00,1398.40,736.00,1398.40,0.00,'2023-03-12 12:21:28'),(416,'4','283',1,'Retail Sale Id 475',0.00,12144.00,736.00,12144.00,0.00,'2023-03-12 12:26:36'),(417,'4','283',1,'Retail Sale Id 476',0.00,2200.64,736.00,2200.64,0.00,'2023-03-12 12:28:16'),(418,'4','283',1,'Retail Sale Id 479',0.00,3002.88,736.00,3002.88,0.00,'2023-03-12 12:31:54'),(419,'4','283',1,'Retail Sale Id 480',0.00,4416.00,736.00,4416.00,0.00,'2023-03-12 12:33:21'),(420,'4','283',1,'Retail Sale Id 481',0.00,9568.00,736.00,9568.00,0.00,'2023-03-12 12:36:12'),(421,'4','283',1,'Retail Sale Id 483',0.00,4416.00,736.00,4416.00,0.00,'2023-03-12 12:37:13'),(422,'4','283',1,'Retail Sale Id 484',0.00,8832.00,736.00,8832.00,0.00,'2023-03-12 12:38:45'),(423,'4','283',1,'Retail Sale Id 487',0.00,4416.00,736.00,4416.00,0.00,'2023-03-12 12:40:46'),(424,'4','283',1,'Retail Sale Id 489',0.00,9200.00,736.00,9200.00,0.00,'2023-03-12 12:47:56'),(425,'4','283',1,'Retail Sale Id 490',0.00,8832.00,736.00,8832.00,0.00,'2023-03-12 12:50:00'),(426,'4','283',1,'Retail Sale Id 491',0.00,13616.00,736.00,13616.00,0.00,'2023-03-12 12:54:52'),(427,'4','283',1,'Retail Sale Id 492',0.00,9200.00,736.00,9200.00,0.00,'2023-03-12 12:57:10'),(428,'4','283',1,'Retail Sale Id 493',0.00,2208.00,736.00,2208.00,0.00,'2023-03-12 12:59:48'),(429,'4','283',1,'Retail Sale Id 495',0.00,2001.92,736.00,2001.92,0.00,'2023-03-12 13:07:38'),(430,'4','283',1,'Retail Sale Id 496',0.00,6624.00,736.00,6624.00,0.00,'2023-03-12 13:11:55'),(431,'4','283',1,'Retail Sale Id 497',0.00,2208.00,736.00,2208.00,0.00,'2023-03-12 13:14:45'),(432,'4','283',1,'Retail Sale Id 499',0.00,5998.40,736.00,5998.40,0.00,'2023-03-12 13:17:15'),(433,'4','283',1,'Retail Sale Id 500',0.00,3680.00,736.00,3680.00,0.00,'2023-03-12 13:19:47'),(434,'4','283',1,'Retail Sale Id 501',0.00,5888.00,736.00,5888.00,0.00,'2023-03-12 13:22:34'),(435,'4','283',1,'Retail Sale Id 504',0.00,4416.00,736.00,4416.00,0.00,'2023-03-12 13:26:05'),(436,'4','283',1,'Retail Sale Id 505',0.00,18400.00,710.00,17750.00,-650.00,'2023-03-12 13:32:48'),(437,'4','283',1,'Retail Sale Id 508',0.00,45632.00,710.00,44020.00,-1612.00,'2023-03-12 13:45:23'),(438,'4','283',1,'Retail Sale Id 509',0.00,1472.00,736.00,1472.00,0.00,'2023-03-12 14:09:31'),(439,'4','283',1,'Retail Sale Id 510',0.00,2208.00,736.00,2208.00,0.00,'2023-03-12 14:11:38'),(440,'4','283',1,'Retail Sale Id 511',0.00,736.00,736.00,736.00,0.00,'2023-03-12 14:14:41'),(441,'4','283',1,'Retail Sale Id 512',0.00,9200.00,736.00,9200.00,0.00,'2023-03-12 14:22:28'),(442,'4','283',1,'Retail Sale Id 513',0.00,1472.00,736.00,1472.00,0.00,'2023-03-12 14:26:39'),(443,'4','283',1,'Retail Sale Id 514',0.00,736.00,736.00,736.00,0.00,'2023-03-12 14:29:56'),(444,'4','283',1,'Retail Sale Id 515',0.00,4416.00,736.00,4416.00,0.00,'2023-03-12 14:52:22'),(445,'4','283',1,'Retail Sale Id 516',0.00,2001.92,736.00,2001.92,0.00,'2023-03-12 15:22:55'),(446,'4','283',1,'Retail Sale Id 518',0.00,7396.80,736.00,7396.80,0.00,'2023-03-12 15:26:39'),(447,'4','283',1,'Retail Sale Id 519',0.00,9200.00,736.00,9200.00,0.00,'2023-03-12 15:29:03'),(448,'4','283',1,'Retail Sale Id 520',0.00,2001.92,736.00,2001.92,0.00,'2023-03-12 15:30:56'),(449,'4','283',1,'Retail Sale Id 523',0.00,4416.00,736.00,4416.00,0.00,'2023-03-12 15:40:53'),(450,'4','283',1,'Retail Sale Id 525',0.00,2208.00,736.00,2208.00,0.00,'2023-03-12 15:42:42'),(451,'4','283',1,'Retail Sale Id 526',0.00,4416.00,736.00,4416.00,0.00,'2023-03-12 15:44:48'),(452,'4','283',1,'Retail Sale Id 527',0.00,1472.00,736.00,1472.00,0.00,'2023-03-12 15:54:24'),(453,'4','283',1,'Retail Sale Id 528',0.00,3680.00,736.00,3680.00,0.00,'2023-03-12 16:03:25'),(454,'4','283',1,'Retail Sale Id 529',0.00,4416.00,736.00,4416.00,0.00,'2023-03-12 16:05:18'),(455,'4','283',1,'Retail Sale Id 531',0.00,9200.00,736.00,9200.00,0.00,'2023-03-12 16:20:54'),(456,'4','283',1,'Retail Sale Id 532',0.00,4416.00,736.00,4416.00,0.00,'2023-03-12 16:30:18'),(457,'4','283',1,'Retail Sale Id 533',0.00,9200.00,710.00,8875.00,-325.00,'2023-03-12 16:33:33'),(458,'4','283',1,'Retail Sale Id 534',0.00,3996.48,736.00,3996.48,0.00,'2023-03-12 16:37:04'),(459,'4','283',1,'Retail Sale Id 535',0.00,9200.00,736.00,9200.00,0.00,'2023-03-12 16:41:07'),(460,'4','283',1,'Retail Sale Id 536',0.00,42320.00,710.00,40825.00,-1495.00,'2023-03-13 08:21:46'),(461,'4','283',1,'Retail Sale Id 537',0.00,9200.00,736.00,9200.00,0.00,'2023-03-13 08:23:47'),(462,'4','283',1,'Retail Sale Id 538',0.00,3996.48,736.00,3996.48,0.00,'2023-03-13 08:25:37'),(463,'4','283',1,'Retail Sale Id 540',0.00,3680.00,710.00,3550.00,-130.00,'2023-03-13 08:29:22'),(464,'4','283',1,'Retail Sale Id 541',0.00,6624.00,736.00,6624.00,0.00,'2023-03-13 08:32:43'),(465,'4','283',1,'Retail Sale Id 542',0.00,3680.00,736.00,3680.00,0.00,'2023-03-13 08:34:05'),(466,'4','283',1,'Retail Sale Id 544',0.00,5152.00,736.00,5152.00,0.00,'2023-03-13 08:35:35'),(467,'4','283',1,'Retail Sale Id 545',0.00,9200.00,736.00,9200.00,0.00,'2023-03-13 08:37:14'),(468,'4','283',1,'Retail Sale Id 547',0.00,736.00,736.00,736.00,0.00,'2023-03-13 08:40:04'),(469,'4','283',1,'Retail Sale Id 548',0.00,1000.96,736.00,1000.96,0.00,'2023-03-13 08:41:38'),(470,'4','283',1,'Retail Sale Id 549',0.00,12880.00,736.00,12880.00,0.00,'2023-03-13 08:45:21'),(471,'4','283',1,'Retail Sale Id 550',0.00,2208.00,736.00,2208.00,0.00,'2023-03-13 08:46:40'),(472,'4','283',1,'Retail Sale Id 551',0.00,4416.00,736.00,4416.00,0.00,'2023-03-13 08:48:25'),(473,'4','283',1,'Retail Sale Id 552',0.00,2208.00,736.00,2208.00,0.00,'2023-03-13 08:49:50'),(474,'4','283',1,'Retail Sale Id 553',0.00,8832.00,736.00,8832.00,0.00,'2023-03-13 08:51:05'),(475,'4','283',1,'Retail Sale Id 554',0.00,2208.00,736.00,2208.00,0.00,'2023-03-13 08:52:54'),(476,'4','283',1,'Retail Sale Id 555',0.00,5888.00,736.00,5888.00,0.00,'2023-03-13 08:55:07'),(477,'4','283',1,'Retail Sale Id 556',0.00,3002.88,736.00,3002.88,0.00,'2023-03-13 08:56:53'),(478,'4','283',1,'Retail Sale Id 557',0.00,2252.16,736.00,2252.16,0.00,'2023-03-13 09:01:12'),(479,'4','283',1,'Retail Sale Id 558',0.00,1302.72,736.00,1302.72,0.00,'2023-03-13 09:12:29'),(480,'4','283',1,'Retail Sale Id 561',0.00,2208.00,736.00,2208.00,0.00,'2023-03-13 09:25:33'),(481,'4','283',1,'Retail Sale Id 562',0.00,3680.00,736.00,3680.00,0.00,'2023-03-13 09:30:05'),(482,'4','283',1,'Retail Sale Id 563',0.00,1000.96,736.00,1000.96,0.00,'2023-03-13 09:34:49'),(483,'4','283',1,'Retail Sale Id 564',0.00,7360.00,736.00,7360.00,0.00,'2023-03-13 09:37:37'),(484,'4','283',1,'Retail Sale Id 565',0.00,1000.96,736.00,1000.96,0.00,'2023-03-13 09:56:19'),(485,'4','283',1,'Retail Sale Id 566',0.00,4997.44,736.00,4997.44,0.00,'2023-03-13 09:59:58'),(486,'4','283',1,'Retail Sale Id 567',0.00,4416.00,736.00,4416.00,0.00,'2023-03-13 10:17:00'),(487,'4','283',1,'Retail Sale Id 569',0.00,8832.00,736.00,8832.00,0.00,'2023-03-13 10:18:51'),(488,'4','283',1,'Retail Sale Id 570',0.00,368.00,736.00,368.00,0.00,'2023-03-13 10:27:28'),(489,'4','283',1,'Retail Sale Id 571',0.00,9200.00,736.00,9200.00,0.00,'2023-03-13 10:44:12'),(490,'4','283',1,'Retail Sale Id 572',0.00,2001.92,736.00,2001.92,0.00,'2023-03-13 10:48:29'),(491,'4','283',1,'Retail Sale Id 573',0.00,2502.40,736.00,2502.40,0.00,'2023-03-13 10:51:18'),(492,'4','283',1,'Retail Sale Id 574',0.00,9200.00,736.00,9200.00,0.00,'2023-03-13 11:23:32'),(493,'4','283',1,'Retail Sale Id 575',0.00,4416.00,736.00,4416.00,0.00,'2023-03-13 11:26:35'),(494,'4','283',1,'Retail Sale Id 576',0.00,4416.00,736.00,4416.00,0.00,'2023-03-13 12:16:25'),(495,'4','283',1,'Retail Sale Id 577',0.00,1501.44,736.00,1501.44,0.00,'2023-03-13 12:32:36'),(496,'4','283',1,'Retail Sale Id 579',0.00,4496.96,736.00,4496.96,0.00,'2023-03-13 12:39:51'),(497,'4','283',1,'Retail Sale Id 581',0.00,1472.00,736.00,1472.00,0.00,'2023-03-13 12:41:22'),(498,'4','283',1,'Retail Sale Id 583',0.00,4416.00,736.00,4416.00,0.00,'2023-03-13 12:46:21'),(499,'4','283',1,'Retail Sale Id 584',0.00,1472.00,736.00,1472.00,0.00,'2023-03-13 12:47:43'),(500,'4','283',1,'Retail Sale Id 585',0.00,9200.00,736.00,9200.00,0.00,'2023-03-13 12:50:38'),(501,'4','283',1,'Retail Sale Id 586',0.00,7360.00,710.00,7100.00,-260.00,'2023-03-13 12:55:37'),(502,'4','283',1,'Retail Sale Id 587',0.00,9200.00,736.00,9200.00,0.00,'2023-03-13 13:06:26'),(503,'4','283',1,'Retail Sale Id 588',0.00,36800.00,710.00,35500.00,-1300.00,'2023-03-13 13:20:09'),(504,'4','283',1,'Retail Sale Id 589',0.00,71392.00,710.00,68870.00,-2522.00,'2023-03-13 13:22:14'),(505,'4','283',1,'Retail Sale Id 591',0.00,2208.00,736.00,2208.00,0.00,'2023-03-13 13:23:35'),(506,'4','283',1,'Retail Sale Id 592',0.00,1000.96,736.00,1000.96,0.00,'2023-03-13 13:36:34'),(507,'4','283',1,'Retail Sale Id 594',0.00,1501.44,736.00,1501.44,0.00,'2023-03-13 13:45:34'),(508,'4','283',1,'Retail Sale Id 595',0.00,9200.00,736.00,9200.00,0.00,'2023-03-13 13:48:04'),(509,'4','283',1,'Retail Sale Id 596',0.00,2208.00,736.00,2208.00,0.00,'2023-03-13 13:49:00'),(510,'4','283',1,'Retail Sale Id 597',0.00,3002.88,736.00,3002.88,0.00,'2023-03-13 14:37:18'),(511,'4','283',1,'Retail Sale Id 598',0.00,2001.92,736.00,2001.92,0.00,'2023-03-13 14:38:40'),(512,'4','283',1,'Retail Sale Id 599',0.00,9200.00,736.00,9200.00,0.00,'2023-03-13 14:41:28'),(513,'4','283',1,'Retail Sale Id 600',0.00,36800.00,710.00,35500.00,-1300.00,'2023-03-13 14:46:20'),(514,'4','283',1,'Retail Sale Id 601',0.00,3002.88,736.00,3002.88,0.00,'2023-03-13 14:48:01'),(515,'4','283',1,'Retail Sale Id 602',0.00,2944.00,736.00,2944.00,0.00,'2023-03-13 14:50:43'),(516,'4','283',1,'Retail Sale Id 603',0.00,2208.00,736.00,2208.00,0.00,'2023-03-13 15:21:49'),(517,'4','283',1,'Retail Sale Id 604',0.00,2001.92,736.00,2001.92,0.00,'2023-03-13 15:30:53'),(518,'4','283',1,'Retail Sale Id 605',0.00,2944.00,736.00,2944.00,0.00,'2023-03-13 15:34:17'),(519,'4','283',1,'Retail Sale Id 606',0.00,2944.00,736.00,2944.00,0.00,'2023-03-13 15:36:45'),(520,'4','283',1,'Retail Sale Id 607',0.00,4416.00,736.00,4416.00,0.00,'2023-03-13 15:39:11'),(521,'4','283',1,'Retail Sale Id 608',0.00,9200.00,736.00,9200.00,0.00,'2023-03-13 15:40:53'),(522,'4','283',1,'Retail Sale Id 609',0.00,2001.92,736.00,2001.92,0.00,'2023-03-13 15:48:30'),(523,'4','283',1,'Retail Sale Id 610',0.00,2944.00,736.00,2944.00,0.00,'2023-03-13 15:52:25'),(524,'4','283',1,'Retail Sale Id 611',0.00,3680.00,736.00,3680.00,0.00,'2023-03-13 15:55:37'),(525,'4','283',1,'Retail Sale Id 612',0.00,9200.00,736.00,9200.00,0.00,'2023-03-13 15:57:47'),(526,'4','283',1,'Retail Sale Id 613',0.00,1472.00,736.00,1472.00,0.00,'2023-03-13 15:58:53'),(527,'4','283',1,'Retail Sale Id 614',0.00,9200.00,736.00,9200.00,0.00,'2023-03-13 16:00:21'),(528,'4','283',1,'Retail Sale Id 615',0.00,4997.44,736.00,4997.44,0.00,'2023-03-13 16:03:23'),(529,'4','283',1,'Retail Sale Id 616',0.00,9200.00,736.00,9200.00,0.00,'2023-03-13 16:08:32'),(530,'4','283',1,'Retail Sale Id 617',0.00,750.72,736.00,750.72,0.00,'2023-03-13 16:18:12'),(531,'4','283',1,'Retail Sale Id 618',0.00,2208.00,736.00,2208.00,0.00,'2023-03-13 16:19:45'),(532,'4','283',1,'Retail Sale Id 619',0.00,5888.00,736.00,5888.00,0.00,'2023-03-13 16:35:37'),(533,'4','283',1,'Retail Sale Id 620',0.00,2208.00,736.00,2208.00,0.00,'2023-03-13 16:37:28'),(534,'4','283',1,'Retail Sale Id 621',0.00,3680.00,736.00,3680.00,0.00,'2023-03-13 16:41:37'),(535,'4','283',1,'Retail Sale Id 622',0.00,9200.00,736.00,9200.00,0.00,'2023-03-13 16:46:24'),(536,'4','283',1,'Retail Sale Id 623',0.00,9200.00,736.00,9200.00,0.00,'2023-03-13 17:01:05'),(537,'4','283',1,'Retail Sale Id 624',0.00,34592.00,710.00,33370.00,-1222.00,'2023-03-13 17:32:28'),(538,'4','283',1,'Retail Sale Id 625',0.00,9200.00,710.00,8875.00,-325.00,'2023-03-13 17:35:58'),(539,'4','283',1,'Retail Sale Id 626',0.00,5152.00,736.00,5152.00,0.00,'2023-03-13 17:38:13'),(540,'4','283',1,'Retail Sale Id 629',0.00,4416.00,736.00,4416.00,0.00,'2023-03-13 17:53:51'),(541,'4','283',1,'Retail Sale Id 630',0.00,3002.88,736.00,3002.88,0.00,'2023-03-13 17:55:20'),(542,'4','283',1,'Retail Sale Id 631',0.00,4416.00,736.00,4416.00,0.00,'2023-03-13 17:56:35'),(543,'4','283',1,'Retail Sale Id 632',0.00,736.00,736.00,736.00,0.00,'2023-03-13 17:57:32'),(544,'4','283',1,'Retail Sale Id 634',0.00,145728.00,736.00,145728.00,0.00,'2023-03-14 11:12:10'),(545,'4','283',1,'Retail Sale Id 635',0.00,8832.00,736.00,8832.00,0.00,'2023-03-14 11:17:31'),(546,'4','283',1,'Retail Sale Id 636',0.00,2208.00,736.00,2208.00,0.00,'2023-03-14 11:20:57'),(547,'4','283',1,'Retail Sale Id 637',0.00,52992.00,736.00,52992.00,0.00,'2023-03-14 12:28:23'),(548,'4','283',1,'Retail Sale Id 638',0.00,9200.00,736.00,9200.00,0.00,'2023-03-14 12:40:10'),(549,'4','283',1,'Retail Sale Id 639',0.00,4416.00,736.00,4416.00,0.00,'2023-03-14 12:45:09'),(550,'4','283',1,'Retail Sale Id 640',0.00,1000.96,736.00,1000.96,0.00,'2023-03-14 12:51:48'),(551,'4','283',1,'Retail Sale Id 641',0.00,2208.00,736.00,2208.00,0.00,'2023-03-14 12:58:55'),(552,'4','283',1,'Retail Sale Id 642',0.00,2208.00,736.00,2208.00,0.00,'2023-03-14 13:01:48'),(553,'4','283',1,'Retail Sale Id 643',0.00,110400.00,736.00,110400.00,0.00,'2023-03-14 13:07:07'),(554,'4','283',1,'Retail Sale Id 644',0.00,3680.00,736.00,3680.00,0.00,'2023-03-14 13:15:10'),(555,'4','283',1,'Retail Sale Id 645',0.00,2208.00,736.00,2208.00,0.00,'2023-03-14 13:18:17'),(556,'4','283',1,'Retail Sale Id 646',0.00,4416.00,736.00,4416.00,0.00,'2023-03-14 13:24:19'),(557,'4','283',1,'Retail Sale Id 647',0.00,92000.00,736.00,92000.00,0.00,'2023-03-14 14:31:26'),(558,'4','283',1,'Retail Sale Id 648',0.00,9200.00,736.00,9200.00,0.00,'2023-03-14 16:27:43'),(559,'4','283',1,'Retail Sale Id 650',0.00,27600.00,736.00,27600.00,0.00,'2023-03-14 17:12:41'),(560,'4','283',1,'Retail Sale Id 651',0.00,26628.48,736.00,26628.48,0.00,'2023-03-14 17:15:27'),(561,'4','283',1,'Retail Sale Id 652',0.00,4416.00,736.00,4416.00,0.00,'2023-03-14 17:39:21'),(562,'4','283',1,'Retail Sale Id 653',0.00,4416.00,736.00,4416.00,0.00,'2023-03-15 10:51:29'),(563,'4','283',1,'Retail Sale Id 654',0.00,9200.00,736.00,9200.00,0.00,'2023-03-15 10:52:42'),(564,'4','283',1,'Retail Sale Id 655',0.00,4416.00,736.00,4416.00,0.00,'2023-03-15 10:56:23'),(565,'4','283',1,'Retail Sale Id 656',0.00,4416.00,736.00,4416.00,0.00,'2023-03-15 10:57:42'),(566,'4','283',1,'Retail Sale Id 658',0.00,18400.00,736.00,18400.00,0.00,'2023-03-15 11:03:38'),(567,'4','283',1,'Retail Sale Id 659',0.00,9200.00,736.00,9200.00,0.00,'2023-03-15 11:07:51'),(568,'4','283',1,'Retail Sale Id 660',0.00,36800.00,710.00,35500.00,-1300.00,'2023-03-15 11:11:14'),(569,'4','283',1,'Retail Sale Id 661',0.00,5152.00,736.00,5152.00,0.00,'2023-03-15 11:12:37'),(570,'4','283',1,'Retail Sale Id 663',0.00,36800.00,710.00,35500.00,-1300.00,'2023-03-15 11:20:19'),(571,'4','283',1,'Retail Sale Id 664',0.00,8464.00,736.00,8464.00,0.00,'2023-03-15 11:33:25'),(572,'4','283',1,'Retail Sale Id 665',0.00,4416.00,736.00,4416.00,0.00,'2023-03-15 11:35:02'),(573,'4','283',1,'Retail Sale Id 666',0.00,2208.00,736.00,2208.00,0.00,'2023-03-15 11:37:47'),(574,'4','283',1,'Retail Sale Id 667',0.00,8096.00,736.00,8096.00,0.00,'2023-03-15 11:42:04'),(575,'4','283',1,'Retail Sale Id 668',0.00,3002.88,736.00,3002.88,0.00,'2023-03-15 11:46:08'),(576,'4','283',1,'Retail Sale Id 669',0.00,3680.00,736.00,3680.00,0.00,'2023-03-15 11:48:24'),(577,'4','283',1,'Retail Sale Id 670',0.00,1472.00,736.00,1472.00,0.00,'2023-03-15 12:05:50'),(578,'4','283',1,'Retail Sale Id 671',0.00,4416.00,736.00,4416.00,0.00,'2023-03-15 12:10:31'),(579,'4','283',1,'Retail Sale Id 672',0.00,9200.00,736.00,9200.00,0.00,'2023-03-15 12:12:53'),(580,'4','283',1,'Retail Sale Id 673',0.00,3680.00,736.00,3680.00,0.00,'2023-03-15 12:21:24'),(581,'4','283',1,'Retail Sale Id 674',0.00,46000.00,710.00,44375.00,-1625.00,'2023-03-15 12:29:18'),(582,'4','283',1,'Retail Sale Id 675',0.00,1472.00,736.00,1472.00,0.00,'2023-03-15 12:31:18'),(583,'4','283',1,'Retail Sale Id 676',0.00,3680.00,736.00,3680.00,0.00,'2023-03-15 12:33:21'),(584,'4','283',1,'Retail Sale Id 677',0.00,2208.00,736.00,2208.00,0.00,'2023-03-15 12:34:43'),(585,'4','283',1,'Retail Sale Id 678',0.00,3503.36,736.00,3503.36,0.00,'2023-03-15 12:44:26'),(586,'4','283',1,'Retail Sale Id 679',0.00,4496.96,736.00,4496.96,0.00,'2023-03-15 12:45:24'),(587,'4','283',1,'Retail Sale Id 680',0.00,2208.00,736.00,2208.00,0.00,'2023-03-15 12:46:57'),(588,'4','283',1,'Retail Sale Id 681',0.00,2208.00,736.00,2208.00,0.00,'2023-03-15 12:50:41'),(589,'4','283',1,'Retail Sale Id 682',0.00,9200.00,710.00,8875.00,-325.00,'2023-03-15 12:53:07'),(590,'4','283',1,'Retail Sale Id 683',0.00,1472.00,736.00,1472.00,0.00,'2023-03-15 12:55:04'),(591,'4','283',1,'Retail Sale Id 684',0.00,3002.88,736.00,3002.88,0.00,'2023-03-15 12:56:49'),(592,'4','283',1,'Retail Sale Id 685',0.00,4416.00,736.00,4416.00,0.00,'2023-03-15 16:44:35'),(593,'4','283',1,'Retail Sale Id 686',0.00,2208.00,736.00,2208.00,0.00,'2023-03-15 16:46:36'),(594,'4','283',1,'Retail Sale Id 687',0.00,5998.40,736.00,5998.40,0.00,'2023-03-15 16:49:41'),(595,'4','283',1,'Retail Sale Id 688',0.00,2944.00,736.00,2944.00,0.00,'2023-03-15 16:50:40'),(596,'4','283',1,'Retail Sale Id 689',0.00,2208.00,736.00,2208.00,0.00,'2023-03-15 16:57:51'),(597,'4','283',1,'Retail Sale Id 690',0.00,2001.92,736.00,2001.92,0.00,'2023-03-15 17:03:19'),(598,'4','283',1,'Retail Sale Id 692',0.00,2944.00,736.00,2944.00,0.00,'2023-03-15 17:20:20'),(599,'4','283',1,'Retail Sale Id 694',0.00,9200.00,710.00,8875.00,-325.00,'2023-03-15 17:25:31'),(600,'4','283',1,'Retail Sale Id 695',0.00,4416.00,736.00,4416.00,0.00,'2023-03-15 17:29:45'),(601,'4','283',1,'Retail Sale Id 696',0.00,2208.00,736.00,2208.00,0.00,'2023-03-15 17:32:39'),(602,'4','283',1,'Retail Sale Id 697',0.00,2001.92,736.00,2001.92,0.00,'2023-03-15 17:43:47'),(603,'4','283',1,'Retail Sale Id 698',0.00,2208.00,736.00,2208.00,0.00,'2023-03-15 17:50:31'),(604,'4','283',1,'Retail Sale Id 699',0.00,2208.00,736.00,2208.00,0.00,'2023-03-15 17:54:25'),(605,'4','283',1,'Retail Sale Id 700',0.00,1000.96,736.00,1000.96,0.00,'2023-03-15 17:56:58'),(606,'4','283',1,'Retail Sale Id 701',0.00,2208.00,736.00,2208.00,0.00,'2023-03-15 17:57:57'),(607,'4','283',1,'Retail Sale Id 702',0.00,1472.00,736.00,1472.00,0.00,'2023-03-15 17:59:06'),(608,'4','283',1,'Retail Sale Id 703',0.00,36800.00,710.00,35500.00,-1300.00,'2023-03-15 18:01:40'),(609,'4','283',1,'Retail Sale Id 704',0.00,108192.00,710.00,104370.00,-3822.00,'2023-03-15 18:03:09'),(610,'4','283',1,'Retail Sale Id 705',0.00,9200.00,736.00,9200.00,0.00,'2023-03-15 18:04:52'),(611,'4','283',1,'Retail Sale Id 706',0.00,2208.00,736.00,2208.00,0.00,'2023-03-15 18:06:19'),(612,'4','283',1,'Retail Sale Id 707',0.00,4997.44,736.00,4997.44,0.00,'2023-03-15 18:08:35'),(613,'4','283',1,'Retail Sale Id 708',0.00,1472.00,736.00,1472.00,0.00,'2023-03-15 18:14:07'),(614,'4','283',1,'Retail Sale Id 709',0.00,3599.04,736.00,3599.04,0.00,'2023-03-15 18:15:40'),(615,'4','283',1,'Retail Sale Id 711',0.00,9200.00,736.00,9200.00,0.00,'2023-03-15 18:16:59'),(616,'4','283',1,'Retail Sale Id 712',0.00,368000.00,710.00,355000.00,-13000.00,'2023-03-16 11:51:46'),(617,'4','283',1,'Retail Sale Id 713',0.00,57408.00,736.00,57408.00,0.00,'2023-03-16 12:16:41'),(618,'4','283',1,'Retail Sale Id 714',0.00,4416.00,736.00,4416.00,0.00,'2023-03-16 12:19:46'),(619,'4','283',1,'Retail Sale Id 715',0.00,1625088.00,736.00,1625088.00,0.00,'2023-03-16 12:22:21'),(620,'4','283',1,'Retail Sale Id 716',0.00,2944.00,736.00,2944.00,0.00,'2023-03-16 12:26:30'),(621,'4','283',1,'Retail Sale Id 717',0.00,7360.00,736.00,7360.00,0.00,'2023-03-16 12:34:35'),(622,'4','283',1,'Retail Sale Id 718',0.00,3680.00,736.00,3680.00,0.00,'2023-03-16 12:40:31'),(623,'4','283',1,'Retail Sale Id 719',0.00,4416.00,736.00,4416.00,0.00,'2023-03-16 12:42:42'),(624,'4','283',1,'Retail Sale Id 720',0.00,3702.08,736.00,3702.08,0.00,'2023-03-16 12:48:36'),(625,'4','283',1,'Retail Sale Id 722',0.00,73600.00,710.00,71000.00,-2600.00,'2023-03-16 12:58:07'),(626,'4','283',1,'Retail Sale Id 723',0.00,1501.44,736.00,1501.44,0.00,'2023-03-16 13:04:34'),(627,'4','283',1,'Retail Sale Id 724',0.00,2208.00,736.00,2208.00,0.00,'2023-03-16 13:13:50'),(628,'4','283',1,'Retail Sale Id 725',0.00,1501.44,736.00,1501.44,0.00,'2023-03-16 13:18:13'),(629,'4','283',1,'Retail Sale Id 726',0.00,5888.00,736.00,5888.00,0.00,'2023-03-16 13:20:55'),(630,'4','283',1,'Retail Sale Id 728',0.00,4416.00,736.00,4416.00,0.00,'2023-03-16 13:23:58'),(631,'4','283',1,'Retail Sale Id 729',0.00,1472.00,736.00,1472.00,0.00,'2023-03-16 13:25:15'),(632,'4','283',1,'Retail Sale Id 730',0.00,9200.00,736.00,9200.00,0.00,'2023-03-16 13:46:26'),(633,'4','283',1,'Retail Sale Id 731',0.00,802.24,736.00,802.24,0.00,'2023-03-16 13:56:59'),(634,'4','283',1,'Retail Sale Id 732',0.00,7360.00,736.00,7360.00,0.00,'2023-03-16 13:59:16'),(635,'4','283',1,'Retail Sale Id 733',0.00,9200.00,736.00,9200.00,0.00,'2023-03-16 14:04:34'),(636,'4','283',1,'Retail Sale Id 734',0.00,4997.44,736.00,4997.44,0.00,'2023-03-16 14:09:52'),(637,'4','283',1,'Retail Sale Id 735',0.00,9200.00,736.00,9200.00,0.00,'2023-03-16 14:13:34'),(638,'4','283',1,'Retail Sale Id 736',0.00,2208.00,736.00,2208.00,0.00,'2023-03-16 14:19:33'),(639,'4','283',1,'Retail Sale Id 737',0.00,4416.00,736.00,4416.00,0.00,'2023-03-16 14:23:23'),(640,'4','283',1,'Retail Sale Id 738',0.00,9200.00,736.00,9200.00,0.00,'2023-03-16 14:32:34'),(641,'4','283',1,'Retail Sale Id 739',0.00,9200.00,710.00,8875.00,-325.00,'2023-03-16 15:09:36'),(642,'4','283',1,'Retail Sale Id 740',0.00,7360.00,736.00,7360.00,0.00,'2023-03-16 16:47:25'),(643,'4','283',1,'Retail Sale Id 741',0.00,4416.00,736.00,4416.00,0.00,'2023-03-16 16:49:05'),(644,'4','283',1,'Retail Sale Id 742',0.00,2502.40,736.00,2502.40,0.00,'2023-03-17 10:52:28'),(645,'4','283',1,'Retail Sale Id 743',0.00,9200.00,736.00,9200.00,0.00,'2023-03-17 10:54:29'),(646,'4','283',1,'Retail Sale Id 745',0.00,1472.00,736.00,1472.00,0.00,'2023-03-17 11:30:05'),(647,'4','283',1,'Retail Sale Id 746',0.00,2208.00,736.00,2208.00,0.00,'2023-03-17 11:32:47'),(648,'4','283',1,'Retail Sale Id 747',0.00,2208.00,736.00,2208.00,0.00,'2023-03-17 11:36:44'),(649,'4','283',1,'Retail Sale Id 748',0.00,1000.96,736.00,1000.96,0.00,'2023-03-17 11:38:16'),(650,'4','283',1,'Retail Sale Id 749',0.00,5152.00,736.00,5152.00,0.00,'2023-03-17 11:39:27'),(651,'4','283',1,'Retail Sale Id 750',0.00,9200.00,736.00,9200.00,0.00,'2023-03-17 11:41:41'),(652,'4','283',1,'Retail Sale Id 752',0.00,3680.00,736.00,3680.00,0.00,'2023-03-17 11:43:38'),(653,'4','283',1,'Retail Sale Id 753',0.00,4416.00,736.00,4416.00,0.00,'2023-03-17 11:44:34'),(654,'4','283',1,'Retail Sale Id 754',0.00,9200.00,736.00,9200.00,0.00,'2023-03-17 11:46:16'),(655,'4','283',1,'Retail Sale Id 756',0.00,9200.00,736.00,9200.00,0.00,'2023-03-17 11:51:21'),(656,'4','283',1,'Retail Sale Id 758',0.00,4416.00,736.00,4416.00,0.00,'2023-03-17 12:00:09'),(657,'4','283',1,'Retail Sale Id 759',0.00,9200.00,736.00,9200.00,0.00,'2023-03-17 12:01:30'),(658,'4','283',1,'Retail Sale Id 760',0.00,7728.00,736.00,7728.00,0.00,'2023-03-17 12:03:55'),(659,'4','283',1,'Retail Sale Id 761',0.00,4416.00,736.00,4416.00,0.00,'2023-03-17 12:05:23'),(660,'4','283',1,'Retail Sale Id 762',0.00,9200.00,736.00,9200.00,0.00,'2023-03-17 12:11:24'),(661,'4','283',1,'Retail Sale Id 763',0.00,9200.00,736.00,9200.00,0.00,'2023-03-17 12:14:03'),(662,'4','283',1,'Retail Sale Id 764',0.00,3680.00,736.00,3680.00,0.00,'2023-03-17 12:18:18'),(663,'4','283',1,'Retail Sale Id 765',0.00,4416.00,736.00,4416.00,0.00,'2023-03-17 12:25:56'),(664,'4','283',1,'Retail Sale Id 766',0.00,9200.00,736.00,9200.00,0.00,'2023-03-17 12:26:57'),(665,'4','283',1,'Retail Sale Id 767',0.00,3996.48,736.00,3996.48,0.00,'2023-03-17 12:28:31'),(666,'4','283',1,'Retail Sale Id 768',0.00,2944.00,736.00,2944.00,0.00,'2023-03-17 12:30:57'),(667,'4','283',1,'Retail Sale Id 769',0.00,9200.00,736.00,9200.00,0.00,'2023-03-17 12:32:25'),(668,'4','283',1,'Retail Sale Id 770',0.00,2944.00,736.00,2944.00,0.00,'2023-03-17 12:42:17'),(669,'4','283',1,'Retail Sale Id 771',0.00,4416.00,736.00,4416.00,0.00,'2023-03-17 12:43:24'),(670,'4','283',1,'Retail Sale Id 772',0.00,2208.00,736.00,2208.00,0.00,'2023-03-17 12:46:31'),(671,'4','283',1,'Retail Sale Id 773',0.00,6624.00,736.00,6624.00,0.00,'2023-03-17 12:48:01'),(672,'4','283',1,'Retail Sale Id 774',0.00,14720.00,710.00,14200.00,-520.00,'2023-03-17 12:53:34'),(673,'4','283',1,'Retail Sale Id 775',0.00,34592.00,710.00,33370.00,-1222.00,'2023-03-17 12:54:58'),(674,'4','283',1,'Retail Sale Id 776',0.00,45264.00,710.00,43665.00,-1599.00,'2023-03-17 13:00:25'),(675,'4','283',1,'Retail Sale Id 777',0.00,13248.00,736.00,13248.00,0.00,'2023-03-17 13:05:55'),(676,'4','283',1,'Retail Sale Id 778',0.00,9200.00,736.00,9200.00,0.00,'2023-03-17 13:07:15'),(677,'4','283',1,'Retail Sale Id 779',0.00,5152.00,736.00,5152.00,0.00,'2023-03-17 13:16:15'),(678,'4','283',1,'Retail Sale Id 780',0.00,4416.00,736.00,4416.00,0.00,'2023-03-17 13:19:54'),(679,'4','283',1,'Retail Sale Id 781',0.00,1000.96,736.00,1000.96,0.00,'2023-03-17 14:15:37'),(680,'4','283',1,'Retail Sale Id 782',0.00,2208.00,736.00,2208.00,0.00,'2023-03-17 14:17:57'),(681,'4','283',1,'Retail Sale Id 783',0.00,9200.00,736.00,9200.00,0.00,'2023-03-17 14:19:28'),(682,'4','283',1,'Retail Sale Id 784',0.00,2001.92,736.00,2001.92,0.00,'2023-03-17 14:21:03'),(683,'4','283',1,'Retail Sale Id 786',0.00,2208.00,736.00,2208.00,0.00,'2023-03-17 14:25:55'),(684,'4','283',1,'Retail Sale Id 787',0.00,3002.88,736.00,3002.88,0.00,'2023-03-17 14:27:30'),(685,'4','283',1,'Retail Sale Id 788',0.00,4416.00,736.00,4416.00,0.00,'2023-03-17 14:29:11'),(686,'4','283',1,'Retail Sale Id 789',0.00,3996.48,736.00,3996.48,0.00,'2023-03-17 14:37:37'),(687,'4','283',1,'Retail Sale Id 790',0.00,2944.00,736.00,2944.00,0.00,'2023-03-17 14:41:03'),(688,'4','283',1,'Retail Sale Id 791',0.00,2208.00,736.00,2208.00,0.00,'2023-03-17 14:42:54'),(689,'4','283',1,'Retail Sale Id 792',0.00,9200.00,736.00,9200.00,0.00,'2023-03-17 14:47:17'),(690,'4','283',1,'Retail Sale Id 793',0.00,8096.00,736.00,8096.00,0.00,'2023-03-17 14:49:07'),(691,'4','283',1,'Retail Sale Id 794',0.00,40480.00,736.00,40480.00,0.00,'2023-03-17 14:57:03'),(692,'4','283',1,'Retail Sale Id 795',0.00,9001.28,736.00,9001.28,0.00,'2023-03-17 15:07:49'),(693,'4','283',1,'Retail Sale Id 796',0.00,73600.00,710.00,71000.00,-2600.00,'2023-03-17 15:52:12'),(694,'4','283',1,'Retail Sale Id 797',0.00,36800.00,710.00,35500.00,-1300.00,'2023-03-17 15:54:12'),(695,'4','283',1,'Retail Sale Id 798',0.00,2208.00,736.00,2208.00,0.00,'2023-03-17 16:53:20'),(696,'4','283',1,'Retail Sale Id 799',0.00,9200.00,736.00,9200.00,0.00,'2023-03-17 16:54:29'),(697,'4','283',1,'Retail Sale Id 800',0.00,9200.00,736.00,9200.00,0.00,'2023-03-17 16:56:28');
/*!40000 ALTER TABLE `inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ledgers`
--

DROP TABLE IF EXISTS `ledgers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ledgers` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` int NOT NULL AUTO_INCREMENT,
  `ledgertype` varchar(10) NOT NULL,
  `accounttype` varchar(50) NOT NULL,
  `accountid` varchar(50) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `details` varchar(1000) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `accounttype` (`accounttype`,`accountid`,`credit`,`debit`,`thedate`),
  KEY `cooperative` (`company_id`),
  KEY `depot_id` (`station_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=1473 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ledgers`
--

LOCK TABLES `ledgers` WRITE;
/*!40000 ALTER TABLE `ledgers` DISABLE KEYS */;
INSERT INTO `ledgers` VALUES ('4','283',1,'','24','2',0.00,18045600.00,'Purchase Id 1 for 24,720.00 litters of Cooking Gas - LPG from ALIKO OIL NIGERIA LTD.','2023-02-05 16:26:58','',''),('4','283',2,'','supplier','1',18045600.00,0.00,'Purchase Id 1 for 24,720.00 litters of Cooking Gas - LPG from ALIKO OIL NIGERIA LTD.','2023-02-05 16:26:58','',''),('4','283',3,'','20','3',14060.00,0.00,'Retail Sale Id 1 for multiple products','2023-02-05 16:57:51','',''),('4','283',4,'','6.1','4',0.00,14060.00,'Retail Sale Id 1 for retail product','2023-02-05 16:57:51','',''),('4','283',5,'','20','3',0.00,0.00,'Sales from shift 1 on 2023-02-05 17:24:08 ','2023-02-05 17:24:08','',''),('4','283',6,'','6.1','4',0.00,0.00,'Sales from shift 1 on 2023-02-05 17:24:08 ','2023-02-05 17:24:08','',''),('4','283',7,'','24','2',0.00,16656600.00,'Purchase Id 2 for 24,140.00 litters of Cooking Gas - LPG from ALIKO OIL NIGERIA LTD.','2023-02-06 14:34:04','',''),('4','283',8,'','supplier','1',16656600.00,0.00,'Purchase Id 2 for 24,140.00 litters of Cooking Gas - LPG from ALIKO OIL NIGERIA LTD.','2023-02-06 14:34:04','',''),('4','283',9,'','20','3',11780.00,0.00,'Retail Sale Id 2 for multiple products','2023-02-06 14:54:41','',''),('4','283',10,'','6.1','4',0.00,11780.00,'Retail Sale Id 2 for retail product','2023-02-06 14:54:41','',''),('4','283',11,'','20','3',19000.00,0.00,'Retail Sale Id 3 for 25.00 KG of Cooking Gas @ N760.00','2023-02-06 14:58:13','',''),('4','283',12,'','6.1','4',0.00,19000.00,'Retail Sale Id 3 for retail product','2023-02-06 14:58:13','',''),('4','283',13,'','20','3',11400.00,0.00,'Retail Sale Id 4 for 15.00 KG of Cooking Gas @ N760.00','2023-02-06 15:02:09','',''),('4','283',14,'','6.1','4',0.00,11400.00,'Retail Sale Id 4 for retail product','2023-02-06 15:02:09','',''),('4','283',15,'','20','3',7500000.00,0.00,'Sales Id 1 for 10,000.00 KG of Cooking Gas - LPG @ N750.00 to SABRIN GAS','2023-02-06 15:10:45','',''),('4','283',16,'','customer','1',0.00,7500000.00,'Sales Id 1 for 10,000.00 KG of Cooking Gas - LPG @ N750.00','2023-02-06 15:10:45','',''),('4','283',17,'','20','3',225000.00,0.00,'Retail Sale Id 5 for 300.00 KG of Cooking Gas @ N750.00','2023-02-06 15:16:53','',''),('4','283',18,'','6.1','4',0.00,225000.00,'Retail Sale Id 5 for retail product','2023-02-06 15:16:53','',''),('4','283',19,'','20','3',0.00,0.00,'Sales from shift 2 on 2023-02-06 15:18:54 ','2023-02-06 15:18:54','',''),('4','283',20,'','6.1','4',0.00,0.00,'Sales from shift 2 on 2023-02-06 15:18:54 ','2023-02-06 15:18:54','',''),('4','283',21,'','2','6',7767180.00,0.00,'Payment Id 1 for invoice:2, receipt: 111100 by ALIKO OIL NIGERIA LTD.','2023-02-06 15:26:28','',''),('4','283',22,'','supplier','1',0.00,7767180.00,'Payment Id 1 for invoice:2, receipt: 111100 by ALIKO OIL NIGERIA LTD.','2023-02-06 15:26:28','',''),('4','283',23,'','20','3',14060.00,0.00,'Retail Sale Id 6 for multiple products','2023-02-11 13:04:49','',''),('4','283',24,'','6.1','4',0.00,14060.00,'Retail Sale Id 6 for retail product','2023-02-11 13:04:49','',''),('4','283',25,'','20','3',0.00,0.00,'Sales from shift 3 on 2023-02-12 17:48:05 ','2023-02-12 17:48:05','',''),('4','283',26,'','6.1','4',0.00,0.00,'Sales from shift 3 on 2023-02-12 17:48:05 ','2023-02-12 17:48:05','',''),('4','283',27,'','20','3',1520.00,0.00,'Retail Sale Id 7 for multiple products','2023-02-12 17:55:21','',''),('4','283',28,'','6.1','4',0.00,1520.00,'Retail Sale Id 7 for retail product','2023-02-12 17:55:21','',''),('4','283',29,'','20','3',375000.00,0.00,'Retail Sale Id 8 for 500.00 KG of Cooking Gas @ N750.00','2023-02-12 17:57:08','',''),('4','283',30,'','6.1','4',0.00,375000.00,'Retail Sale Id 8 for retail product','2023-02-12 17:57:08','',''),('4','283',31,'','20','3',95000.00,0.00,'Retail Sale Id 9 for 125.00 KG of Cooking Gas @ N760.00','2023-02-12 18:19:17','',''),('4','283',32,'','2','6',0.00,95000.00,'Retail Sale Id 9 for retail product','2023-02-12 18:19:17','',''),('4','283',33,'','20','3',760.00,0.00,'Retail Sale Id 10 for 1.00 KG of Cooking Gas @ N760.00','2023-02-12 18:20:11','',''),('4','283',34,'','6.1','4',0.00,760.00,'Retail Sale Id 10 for retail product','2023-02-12 18:20:11','',''),('4','283',35,'','20','3',11400.00,0.00,'Retail Sale Id 13 for 15.00 KG of Cooking Gas @ N760.00','2023-02-12 18:22:48','',''),('4','283',36,'','6.1','4',0.00,11400.00,'Retail Sale Id 13 for retail product','2023-02-12 18:22:48','',''),('4','283',37,'','20','3',11400.00,0.00,'Retail Sale Id 12 for 15.00 KG of Cooking Gas @ N760.00','2023-02-12 18:23:28','',''),('4','283',38,'','6.1','4',0.00,11400.00,'Retail Sale Id 12 for retail product','2023-02-12 18:23:28','',''),('4','283',39,'','20','3',7600.00,0.00,'Retail Sale Id 14 for 10.00 KG of Cooking Gas @ N760.00','2023-02-12 18:30:21','',''),('4','283',40,'','6.1','4',0.00,7600.00,'Retail Sale Id 14 for retail product','2023-02-12 18:30:21','',''),('4','283',41,'','20','3',38000.00,0.00,'Retail Sale Id 15 for 50.00 KG of Cooking Gas @ N760.00','2023-02-12 18:32:46','',''),('4','283',42,'','6.1','4',0.00,38000.00,'Retail Sale Id 15 for retail product','2023-02-12 18:32:46','',''),('4','283',43,'','20','3',562500.00,0.00,'Retail Sale Id 16 for 750.00 KG of Cooking Gas @ N750.00','2023-02-12 18:34:45','',''),('4','283',44,'','2','6',0.00,562500.00,'Retail Sale Id 16 for retail product','2023-02-12 18:34:45','',''),('4','283',45,'','20','3',11400.00,0.00,'Retail Sale Id 11 for 15.00 KG of Cooking Gas @ N760.00','2023-02-12 18:35:52','',''),('4','283',46,'','6.1','4',0.00,11400.00,'Retail Sale Id 11 for retail product','2023-02-12 18:35:52','',''),('4','283',47,'','20','3',2280.00,0.00,'Retail Sale Id 17 for 3.00 KG of Cooking Gas @ N760.00','2023-02-12 18:59:40','',''),('4','283',48,'','6.1','4',0.00,2280.00,'Retail Sale Id 17 for retail product','2023-02-12 18:59:40','',''),('4','283',49,'','20','3',19000.00,0.00,'Retail Sale Id 18 for 25.00 KG of Cooking Gas @ N760.00','2023-02-12 19:02:53','',''),('4','283',50,'','6.1','4',0.00,19000.00,'Retail Sale Id 18 for retail product','2023-02-12 19:02:53','',''),('4','283',51,'','20','3',0.00,0.00,'Sales from shift 4 on 2023-02-12 19:04:13 ','2023-02-12 19:04:13','',''),('4','283',52,'','6.1','4',0.00,0.00,'Sales from shift 4 on 2023-02-12 19:04:13 ','2023-02-12 19:04:13','',''),('4','283',53,'','20','3',11400.00,0.00,'Retail Sale Id 19 for 15.00 KG of Cooking Gas @ N760.00','2023-02-12 19:12:44','',''),('4','283',54,'','6.1','4',0.00,11400.00,'Retail Sale Id 19 for retail product','2023-02-12 19:12:44','',''),('4','283',55,'','20','3',11400.00,0.00,'Retail Sale Id 20 for multiple products','2023-02-12 19:15:35','',''),('4','283',56,'','2','6',0.00,11400.00,'Retail Sale Id 20 for retail product','2023-02-12 19:15:35','',''),('4','283',57,'','20','3',16340.00,0.00,'Retail Sale Id 21 for multiple products','2023-02-12 19:18:12','',''),('4','283',58,'','6.1','4',0.00,16340.00,'Retail Sale Id 21 for retail product','2023-02-12 19:18:12','',''),('4','283',59,'','20','3',3800.00,0.00,'Retail Sale Id 22 for 5.00 KG of Cooking Gas @ N760.00','2023-02-12 19:21:52','',''),('4','283',60,'','6.1','4',0.00,3800.00,'Retail Sale Id 22 for retail product','2023-02-12 19:21:52','',''),('4','283',61,'','20','3',6840.00,0.00,'Retail Sale Id 23 for 9.00 KG of Cooking Gas @ N760.00','2023-02-12 19:35:59','',''),('4','283',62,'','6.1','4',0.00,6840.00,'Retail Sale Id 23 for retail product','2023-02-12 19:35:59','',''),('4','283',63,'','20','3',11400.00,0.00,'Retail Sale Id 24 for 15.00 KG of Cooking Gas @ N760.00','2023-02-12 19:41:34','',''),('4','283',64,'','6.1','4',0.00,11400.00,'Retail Sale Id 24 for retail product','2023-02-12 19:41:34','',''),('4','283',65,'','20','3',11400.00,0.00,'Retail Sale Id 25 for 15.00 KG of Cooking Gas @ N760.00','2023-02-12 19:43:29','',''),('4','283',66,'','6.1','4',0.00,11400.00,'Retail Sale Id 25 for retail product','2023-02-12 19:43:29','',''),('4','283',67,'','20','3',0.00,0.00,'Sales from shift 5 on 2023-02-12 21:01:55 ','2023-02-12 21:01:55','',''),('4','283',68,'','6.1','4',0.00,0.00,'Sales from shift 5 on 2023-02-12 21:01:55 ','2023-02-12 21:01:55','',''),('4','283',69,'','20','3',3800.00,0.00,'Retail Sale Id 27 for 5.00 KG of Cooking Gas @ N760.00','2023-02-13 10:34:04','',''),('4','283',70,'','2','6',0.00,3800.00,'Retail Sale Id 27 for retail product','2023-02-13 10:34:04','',''),('4','283',71,'','20','3',23000.00,0.00,'Retail Sale Id 28 for multiple products','2023-02-13 10:47:17','',''),('4','283',72,'','6.1','4',0.00,23000.00,'Retail Sale Id 28 for retail product','2023-02-13 10:47:17','',''),('4','283',73,'','20','3',760.00,0.00,'Retail Sale Id 31 for 1.00 KG of Cooking Gas @ N760.00','2023-02-13 12:04:44','',''),('4','283',74,'','6.1','4',0.00,760.00,'Retail Sale Id 31 for retail product','2023-02-13 12:04:44','',''),('4','283',75,'','20','3',375000.00,0.00,'Retail Sale Id 32 for 500.00 KG of Cooking Gas @ N750.00','2023-02-13 17:18:41','',''),('4','283',76,'','6.1','4',0.00,375000.00,'Retail Sale Id 32 for retail product','2023-02-13 17:18:41','',''),('4','283',77,'','20','3',112500.00,0.00,'Retail Sale Id 33 for 150.00 KG of Cooking Gas @ N750.00','2023-02-13 17:20:54','',''),('4','283',78,'','2','6',0.00,112500.00,'Retail Sale Id 33 for retail product','2023-02-13 17:20:54','',''),('4','283',79,'','20','3',2280.00,0.00,'Retail Sale Id 34 for 3.00 KG of Cooking Gas @ N760.00','2023-02-13 17:27:10','',''),('4','283',80,'','6.1','4',0.00,2280.00,'Retail Sale Id 34 for retail product','2023-02-13 17:27:10','',''),('4','283',81,'','2','6',72580.00,0.00,'Payment Id 2 for invoice:5, receipt: 0000 by ALIKO OIL NIGERIA LTD.','2023-02-13 17:41:04','',''),('4','283',82,'','supplier','1',0.00,72580.00,'Payment Id 2 for invoice:5, receipt: 0000 by ALIKO OIL NIGERIA LTD.','2023-02-13 17:41:04','',''),('4','283',83,'','2','6',1135860.00,0.00,'Payment Id 3 for invoice:4, receipt: 0000 by ALIKO OIL NIGERIA LTD.','2023-02-13 17:46:29','',''),('4','283',84,'','supplier','1',0.00,1135860.00,'Payment Id 3 for invoice:4, receipt: 0000 by ALIKO OIL NIGERIA LTD.','2023-02-13 17:46:29','',''),('4','283',85,'','2','6',14060.00,0.00,'Payment Id 4 for invoice:3, receipt: 0011 by ALIKO OIL NIGERIA LTD.','2023-02-13 17:56:52','',''),('4','283',86,'','supplier','1',0.00,14060.00,'Payment Id 4 for invoice:3, receipt: 0011 by ALIKO OIL NIGERIA LTD.','2023-02-13 17:56:52','',''),('4','283',87,'','2','6',7767180.00,0.00,'Payment Id 5 for invoice:2, receipt: 0012 by ALIKO OIL NIGERIA LTD.','2023-02-13 17:57:32','',''),('4','283',88,'','supplier','1',0.00,7767180.00,'Payment Id 5 for invoice:2, receipt: 0012 by ALIKO OIL NIGERIA LTD.','2023-02-13 17:57:32','',''),('4','283',89,'','2','6',7767180.00,0.00,'Payment Id 6 for invoice:2, receipt: 0012 by ALIKO OIL NIGERIA LTD.','2023-02-13 17:58:06','',''),('4','283',90,'','supplier','1',0.00,7767180.00,'Payment Id 6 for invoice:2, receipt: 0012 by ALIKO OIL NIGERIA LTD.','2023-02-13 17:58:06','',''),('4','283',91,'','20','3',14060.00,0.00,'Retail Sale Id 35 for multiple products','2023-02-13 21:49:17','',''),('4','283',92,'','6.1','4',0.00,14060.00,'Retail Sale Id 35 for retail product','2023-02-13 21:49:17','',''),('4','283',93,'','20','3',19000.00,0.00,'Retail Sale Id 36 for 25.00 KG of Cooking Gas @ N760.00','2023-02-13 22:21:41','',''),('4','283',94,'','6.1','4',0.00,19000.00,'Retail Sale Id 36 for retail product','2023-02-13 22:21:41','',''),('4','283',95,'','20','3',19000.00,0.00,'Retail Sale Id 37 for 25.00 KG of Cooking Gas @ N760.00','2023-02-13 22:44:32','',''),('4','283',96,'','6.1','4',0.00,19000.00,'Retail Sale Id 37 for retail product','2023-02-13 22:44:32','',''),('4','283',97,'','20','3',0.00,0.00,'Sales from shift 6 on 2023-02-13 22:51:53 ','2023-02-13 22:51:53','',''),('4','283',98,'','6.1','4',0.00,0.00,'Sales from shift 6 on 2023-02-13 22:51:53 ','2023-02-13 22:51:53','',''),('4','283',99,'','20','3',4560.00,0.00,'Retail Sale Id 38 for 6.00 KG of Cooking Gas @ N760.00','2023-02-14 10:40:54','',''),('4','283',100,'','6.1','4',0.00,4560.00,'Retail Sale Id 38 for retail product','2023-02-14 10:40:54','',''),('4','283',101,'','20','3',6840.00,0.00,'Retail Sale Id 40 for 9.00 KG of Cooking Gas @ N760.00','2023-02-14 14:10:06','',''),('4','283',102,'','6.1','4',0.00,6840.00,'Retail Sale Id 40 for retail product','2023-02-14 14:10:06','',''),('4','283',103,'','20','3',225000.00,0.00,'Retail Sale Id 41 for 300.00 KG of Cooking Gas @ N750.00','2023-02-14 15:08:50','',''),('4','283',104,'','6.1','4',0.00,225000.00,'Retail Sale Id 41 for retail product','2023-02-14 15:08:50','',''),('4','283',105,'','20','3',375000.00,0.00,'Retail Sale Id 42 for 500.00 KG of Cooking Gas @ N750.00','2023-02-14 18:09:07','',''),('4','283',106,'','6.1','4',0.00,375000.00,'Retail Sale Id 42 for retail product','2023-02-14 18:09:07','',''),('4','283',107,'','20','3',375000.00,0.00,'Retail Sale Id 43 for 500.00 KG of Cooking Gas @ N750.00','2023-02-14 18:15:17','',''),('4','283',108,'','6.1','4',0.00,375000.00,'Retail Sale Id 43 for retail product','2023-02-14 18:15:17','',''),('4','283',109,'','20','3',19000.00,0.00,'Retail Sale Id 44 for 25.00 KG of Cooking Gas @ N760.00','2023-02-15 10:28:11','',''),('4','283',110,'','6.1','4',0.00,19000.00,'Retail Sale Id 44 for retail product','2023-02-15 10:28:11','',''),('4','283',111,'','20','3',0.00,0.00,'Sales from shift 7 on 2023-02-16 13:30:18 ','2023-02-16 13:30:18','',''),('4','283',112,'','6.1','4',0.00,0.00,'Sales from shift 7 on 2023-02-16 13:30:18 ','2023-02-16 13:30:18','',''),('4','283',113,'','20','3',3040.00,0.00,'Retail Sale Id 45 for 4.00 KG of Cooking Gas @ N760.00','2023-02-16 13:34:39','',''),('4','283',114,'','6.1','4',0.00,3040.00,'Retail Sale Id 45 for retail product','2023-02-16 13:34:39','',''),('4','283',115,'','24','2',0.00,862178.24,'Inventory value adjustment for product Id 1 from 690.00 to 736','2023-02-16 13:38:02','',''),('4','283',116,'','supplier','1',862178.24,0.00,'Inventory value adjustment for product Id 1 from 690.00 to 736','2023-02-16 13:38:02','',''),('4','283',117,'','20','3',262500.00,0.00,'Retail Sale Id 46 for 350.00 KG of Cooking Gas @ N750.00','2023-02-16 13:53:13','',''),('4','283',118,'','2','6',0.00,262500.00,'Retail Sale Id 46 for retail product','2023-02-16 13:53:13','',''),('4','283',119,'','20','3',70000.00,0.00,'Retail Sale Id 47 for 100.00 KG of Cooking Gas @ N700.00','2023-02-16 14:04:48','',''),('4','283',120,'','2','6',0.00,70000.00,'Retail Sale Id 47 for retail product','2023-02-16 14:04:48','',''),('4','283',121,'','20','3',760.00,0.00,'Retail Sale Id 48 for 1.00 KG of Cooking Gas @ N760.00','2023-02-16 14:19:20','',''),('4','283',122,'','6.1','4',0.00,5000.00,'Retail Sale Id 48 for retail product','2023-02-16 14:19:20','',''),('4','283',123,'','20','3',5152.00,0.00,'Retail Sale Id 50 for 7.00 KG of Cooking Gas @ N736.00','2023-02-16 14:46:59','',''),('4','283',124,'','6.1','4',0.00,5152.00,'Retail Sale Id 50 for retail product','2023-02-16 14:46:59','',''),('4','283',125,'','20','3',76000.00,0.00,'Retail Sale Id 51 for 100.00 KG of Cooking Gas @ N760.00','2023-02-16 15:04:19','',''),('4','283',126,'','2','6',0.00,76000.00,'Retail Sale Id 51 for retail product','2023-02-16 15:04:19','',''),('4','283',127,'','20','3',177500.00,0.00,'Retail Sale Id 52 for 250.00 KG of Cooking Gas @ N710.00','2023-02-16 16:02:30','',''),('4','283',128,'','2','6',0.00,177500.00,'Retail Sale Id 52 for retail product','2023-02-16 16:02:30','',''),('4','283',129,'','20','3',106500.00,0.00,'Retail Sale Id 53 for 150.00 KG of Cooking Gas @ N710.00','2023-02-16 16:10:08','',''),('4','283',130,'','2','6',0.00,106500.00,'Retail Sale Id 53 for retail product','2023-02-16 16:10:08','',''),('4','283',131,'','20','3',0.00,0.00,'Sales from shift 8 on 2023-02-17 14:03:02 ','2023-02-17 14:03:02','',''),('4','283',132,'','6.1','4',0.00,0.00,'Sales from shift 8 on 2023-02-17 14:03:02 ','2023-02-17 14:03:02','',''),('4','283',133,'','20','3',0.00,0.00,'Sales from shift 9 on 2023-03-04 17:53:42 ','2023-03-04 17:53:42','',''),('4','283',134,'','6.1','4',0.00,0.00,'Sales from shift 9 on 2023-03-04 17:53:42 ','2023-03-04 17:53:42','',''),('4','283',135,'','20','3',6624.00,0.00,'Retail Sale Id 54 for 9.00 KG of Cooking Gas @ N736.00','2023-03-04 18:26:28','',''),('4','283',136,'','6.1','4',0.00,6624.00,'Retail Sale Id 54 for retail product','2023-03-04 18:26:28','',''),('4','283',137,'','20','3',0.00,0.00,'Sales from shift 10 on 2023-03-05 00:43:00 ','2023-03-05 00:43:00','',''),('4','283',138,'','6.1','4',0.00,0.00,'Sales from shift 10 on 2023-03-05 00:43:00 ','2023-03-05 00:43:00','',''),('4','283',139,'','20','3',9200.00,0.00,'Retail Sale Id 55 for 12.50 KG of Cooking Gas @ N736.00','2023-03-05 09:31:16','',''),('4','283',140,'','2','6',0.00,9200.00,'Retail Sale Id 55 for retail product','2023-03-05 09:31:16','',''),('4','283',141,'','20','3',4416.00,0.00,'Retail Sale Id 56 for 6.00 KG of Cooking Gas @ N736.00','2023-03-05 09:46:16','',''),('4','283',142,'','2','6',0.00,4416.00,'Retail Sale Id 56 for retail product','2023-03-05 09:46:16','',''),('4','283',143,'','20','3',4400.00,0.00,'Retail Sale Id 57 for 5.98 KG of Cooking Gas @ N736.00','2023-03-05 09:55:06','',''),('4','283',144,'','2','6',0.00,4400.00,'Retail Sale Id 57 for retail product','2023-03-05 09:55:06','',''),('4','283',145,'','20','3',900.00,0.00,'Retail Sale Id 58 for 1.22 KG of Cooking Gas @ N736.00','2023-03-05 09:57:31','',''),('4','283',146,'','2','6',0.00,900.00,'Retail Sale Id 58 for retail product','2023-03-05 09:57:31','',''),('4','283',147,'','20','3',4416.00,0.00,'Retail Sale Id 59 for 6.00 KG of Cooking Gas @ N736.00','2023-03-05 10:00:38','',''),('4','283',148,'','6.1','4',0.00,4416.00,'Retail Sale Id 59 for retail product','2023-03-05 10:00:38','',''),('4','283',149,'','20','3',13616.00,0.00,'Retail Sale Id 60 for 18.50 KG of Cooking Gas @ N736.00','2023-03-05 10:48:54','',''),('4','283',150,'','6.1','4',0.00,13616.00,'Retail Sale Id 60 for retail product','2023-03-05 10:48:54','',''),('4','283',151,'','20','3',2208.00,0.00,'Retail Sale Id 61 for 3.00 KG of Cooking Gas @ N736.00','2023-03-05 10:52:37','',''),('4','283',152,'','6.1','4',0.00,2208.00,'Retail Sale Id 61 for retail product','2023-03-05 10:52:37','',''),('4','283',153,'','20','3',3680.00,0.00,'Retail Sale Id 62 for 5.00 KG of Cooking Gas @ N736.00','2023-03-05 10:54:44','',''),('4','283',154,'','6.1','4',0.00,3680.00,'Retail Sale Id 62 for retail product','2023-03-05 10:54:44','',''),('4','283',155,'','6.1','4',0.00,3680.00,'Retail Sale Id 62 for retail product','2023-03-05 10:54:44','',''),('4','283',156,'','20','3',1500.00,0.00,'Retail Sale Id 63 for 2.04 KG of Cooking Gas @ N736.00','2023-03-05 10:58:10','',''),('4','283',157,'','6.1','4',0.00,1500.00,'Retail Sale Id 63 for retail product','2023-03-05 10:58:10','',''),('4','283',158,'','20','3',5000.00,0.00,'Retail Sale Id 65 for 6.79 KG of Cooking Gas @ N736.00','2023-03-05 11:11:31','',''),('4','283',159,'','6.1','4',0.00,5000.00,'Retail Sale Id 65 for retail product','2023-03-05 11:11:31','',''),('4','283',160,'','6.1','4',0.00,5000.00,'Retail Sale Id 65 for retail product','2023-03-05 11:11:31','',''),('4','283',161,'','20','3',4416.00,0.00,'Retail Sale Id 66 for 6.00 KG of Cooking Gas @ N736.00','2023-03-05 11:13:11','',''),('4','283',162,'','6.1','4',0.00,4416.00,'Retail Sale Id 66 for retail product','2023-03-05 11:13:11','',''),('4','283',163,'','20','3',9200.00,0.00,'Retail Sale Id 67 for 12.50 KG of Cooking Gas @ N736.00','2023-03-05 11:15:23','',''),('4','283',164,'','6.1','4',0.00,9200.00,'Retail Sale Id 67 for retail product','2023-03-05 11:15:23','',''),('4','283',165,'','20','3',2208.00,0.00,'Retail Sale Id 69 for 3.00 KG of Cooking Gas @ N736.00','2023-03-05 11:17:10','',''),('4','283',166,'','6.1','4',0.00,2208.00,'Retail Sale Id 69 for retail product','2023-03-05 11:17:10','',''),('4','283',167,'','20','3',9200.00,0.00,'Retail Sale Id 71 for 12.50 KG of Cooking Gas @ N736.00','2023-03-05 11:18:33','',''),('4','283',168,'','6.1','4',0.00,9200.00,'Retail Sale Id 71 for retail product','2023-03-05 11:18:33','',''),('4','283',169,'','20','3',1472.00,0.00,'Retail Sale Id 73 for 2.00 KG of Cooking Gas @ N736.00','2023-03-05 11:21:45','',''),('4','283',170,'','6.1','4',0.00,1472.00,'Retail Sale Id 73 for retail product','2023-03-05 11:21:45','',''),('4','283',171,'','6.1','4',0.00,1472.00,'Retail Sale Id 73 for retail product','2023-03-05 11:21:45','',''),('4','283',172,'','20','3',4416.00,0.00,'Retail Sale Id 74 for 6.00 KG of Cooking Gas @ N736.00','2023-03-05 11:23:52','',''),('4','283',173,'','6.1','4',0.00,4416.00,'Retail Sale Id 74 for retail product','2023-03-05 11:23:52','',''),('4','283',174,'','20','3',9200.00,0.00,'Retail Sale Id 75 for 12.50 KG of Cooking Gas @ N736.00','2023-03-05 11:25:21','',''),('4','283',175,'','6.1','4',0.00,9200.00,'Retail Sale Id 75 for retail product','2023-03-05 11:25:21','',''),('4','283',176,'','20','3',9200.00,0.00,'Retail Sale Id 78 for 12.50 KG of Cooking Gas @ N736.00','2023-03-05 11:32:57','',''),('4','283',177,'','2','6',0.00,9200.00,'Retail Sale Id 78 for retail product','2023-03-05 11:32:57','',''),('4','283',178,'','20','3',1472.00,0.00,'Retail Sale Id 79 for 2.00 KG of Cooking Gas @ N736.00','2023-03-05 11:34:31','',''),('4','283',179,'','2','6',0.00,1472.00,'Retail Sale Id 79 for retail product','2023-03-05 11:34:31','',''),('4','283',180,'','20','3',12880.00,0.00,'Retail Sale Id 80 for 17.50 KG of Cooking Gas @ N736.00','2023-03-05 11:52:54','',''),('4','283',181,'','6.1','4',0.00,12880.00,'Retail Sale Id 80 for retail product','2023-03-05 11:52:54','',''),('4','283',182,'','6.1','4',0.00,12880.00,'Retail Sale Id 80 for retail product','2023-03-05 11:52:54','',''),('4','283',183,'','20','3',6624.00,0.00,'Retail Sale Id 81 for 9.00 KG of Cooking Gas @ N736.00','2023-03-05 11:54:55','',''),('4','283',184,'','6.1','4',0.00,6624.00,'Retail Sale Id 81 for retail product','2023-03-05 11:54:55','',''),('4','283',185,'','20','3',2250.00,0.00,'Retail Sale Id 82 for 3.06 KG of Cooking Gas @ N736.00','2023-03-05 11:57:38','',''),('4','283',186,'','6.1','4',0.00,2250.00,'Retail Sale Id 82 for retail product','2023-03-05 11:57:38','',''),('4','283',187,'','20','3',3680.00,0.00,'Retail Sale Id 83 for 5.00 KG of Cooking Gas @ N736.00','2023-03-05 12:02:20','',''),('4','283',188,'','6.1','4',0.00,3680.00,'Retail Sale Id 83 for retail product','2023-03-05 12:02:20','',''),('4','283',189,'','6.1','4',0.00,3680.00,'Retail Sale Id 83 for retail product','2023-03-05 12:02:20','',''),('4','283',190,'','20','3',5888.00,0.00,'Retail Sale Id 84 for 8.00 KG of Cooking Gas @ N736.00','2023-03-05 12:09:57','',''),('4','283',191,'','6.1','4',0.00,5888.00,'Retail Sale Id 84 for retail product','2023-03-05 12:09:57','',''),('4','283',192,'','20','3',2208.00,0.00,'Retail Sale Id 85 for 3.00 KG of Cooking Gas @ N736.00','2023-03-05 12:13:12','',''),('4','283',193,'','6.1','4',0.00,2208.00,'Retail Sale Id 85 for retail product','2023-03-05 12:13:12','',''),('4','283',194,'','20','3',736.00,0.00,'Retail Sale Id 86 for 1.00 KG of Cooking Gas @ N736.00','2023-03-05 12:16:41','',''),('4','283',195,'','6.1','4',0.00,736.00,'Retail Sale Id 86 for retail product','2023-03-05 12:16:41','',''),('4','283',196,'','20','3',3680.00,0.00,'Retail Sale Id 87 for 5.00 KG of Cooking Gas @ N736.00','2023-03-05 12:20:33','',''),('4','283',197,'','6.1','4',0.00,3680.00,'Retail Sale Id 87 for retail product','2023-03-05 12:20:33','',''),('4','283',198,'','20','3',1472.00,0.00,'Retail Sale Id 88 for 2.00 KG of Cooking Gas @ N736.00','2023-03-05 12:22:14','',''),('4','283',199,'','6.1','4',0.00,1472.00,'Retail Sale Id 88 for retail product','2023-03-05 12:22:14','',''),('4','283',200,'','20','3',2208.00,0.00,'Retail Sale Id 89 for 3.00 KG of Cooking Gas @ N736.00','2023-03-05 12:23:56','',''),('4','283',201,'','6.1','4',0.00,2208.00,'Retail Sale Id 89 for retail product','2023-03-05 12:23:56','',''),('4','283',202,'','20','3',5152.00,0.00,'Retail Sale Id 90 for 7.00 KG of Cooking Gas @ N736.00','2023-03-05 12:26:23','',''),('4','283',203,'','6.1','4',0.00,5152.00,'Retail Sale Id 90 for retail product','2023-03-05 12:26:23','',''),('4','283',204,'','20','3',6624.00,0.00,'Retail Sale Id 92 for 9.00 KG of Cooking Gas @ N736.00','2023-03-05 12:28:06','',''),('4','283',205,'','6.1','4',0.00,6624.00,'Retail Sale Id 92 for retail product','2023-03-05 12:28:06','',''),('4','283',206,'','20','3',2500.00,0.00,'Retail Sale Id 93 for 3.40 KG of Cooking Gas @ N736.00','2023-03-05 12:29:54','',''),('4','283',207,'','6.1','4',0.00,2500.00,'Retail Sale Id 93 for retail product','2023-03-05 12:29:54','',''),('4','283',208,'','20','3',4416.00,0.00,'Retail Sale Id 94 for 6.00 KG of Cooking Gas @ N736.00','2023-03-05 12:32:23','',''),('4','283',209,'','6.1','4',0.00,4416.00,'Retail Sale Id 94 for retail product','2023-03-05 12:32:23','',''),('4','283',210,'','20','3',2208.00,0.00,'Retail Sale Id 96 for 3.00 KG of Cooking Gas @ N736.00','2023-03-05 12:35:27','',''),('4','283',211,'','6.1','4',0.00,2208.00,'Retail Sale Id 96 for retail product','2023-03-05 12:35:27','',''),('4','283',212,'','20','3',1472.00,0.00,'Retail Sale Id 97 for 2.00 KG of Cooking Gas @ N736.00','2023-03-05 12:37:51','',''),('4','283',213,'','6.1','4',0.00,1472.00,'Retail Sale Id 97 for retail product','2023-03-05 12:37:51','',''),('4','283',214,'','6.1','4',0.00,1472.00,'Retail Sale Id 97 for retail product','2023-03-05 12:37:51','',''),('4','283',215,'','20','3',3000.00,0.00,'Retail Sale Id 98 for 4.08 KG of Cooking Gas @ N736.00','2023-03-05 12:39:44','',''),('4','283',216,'','6.1','4',0.00,3000.00,'Retail Sale Id 98 for retail product','2023-03-05 12:39:44','',''),('4','283',217,'','20','3',2208.00,0.00,'Retail Sale Id 99 for 3.00 KG of Cooking Gas @ N736.00','2023-03-05 12:41:42','',''),('4','283',218,'','6.1','4',0.00,2208.00,'Retail Sale Id 99 for retail product','2023-03-05 12:41:42','',''),('4','283',219,'','20','3',9200.00,0.00,'Retail Sale Id 100 for 12.50 KG of Cooking Gas @ N736.00','2023-03-05 12:47:20','',''),('4','283',220,'','6.1','4',0.00,9200.00,'Retail Sale Id 100 for retail product','2023-03-05 12:47:20','',''),('4','283',221,'','20','3',7360.00,0.00,'Retail Sale Id 101 for 10.00 KG of Cooking Gas @ N736.00','2023-03-05 12:50:16','',''),('4','283',222,'','6.1','4',0.00,7360.00,'Retail Sale Id 101 for retail product','2023-03-05 12:50:16','',''),('4','283',223,'','6.1','4',0.00,7360.00,'Retail Sale Id 101 for retail product','2023-03-05 12:50:16','',''),('4','283',224,'','20','3',2000.00,0.00,'Retail Sale Id 102 for 2.72 KG of Cooking Gas @ N736.00','2023-03-05 12:52:19','',''),('4','283',225,'','6.1','4',0.00,2000.00,'Retail Sale Id 102 for retail product','2023-03-05 12:52:19','',''),('4','283',226,'','20','3',1500.00,0.00,'Retail Sale Id 104 for 2.04 KG of Cooking Gas @ N736.00','2023-03-05 12:53:32','',''),('4','283',227,'','6.1','4',0.00,1500.00,'Retail Sale Id 104 for retail product','2023-03-05 12:53:32','',''),('4','283',228,'','20','3',34080.00,0.00,'Retail Sale Id 106 for 48.00 KG of Cooking Gas @ N710.00','2023-03-05 13:00:05','',''),('4','283',229,'','6.1','4',0.00,34080.00,'Retail Sale Id 106 for retail product','2023-03-05 13:00:05','',''),('4','283',230,'','6.1','4',0.00,34080.00,'Retail Sale Id 106 for retail product','2023-03-05 13:00:05','',''),('4','283',231,'','20','3',5000.00,0.00,'Retail Sale Id 107 for 6.79 KG of Cooking Gas @ N736.00','2023-03-05 13:02:28','',''),('4','283',232,'','6.1','4',0.00,5000.00,'Retail Sale Id 107 for retail product','2023-03-05 13:02:28','',''),('4','283',233,'','20','3',9200.00,0.00,'Retail Sale Id 109 for 12.50 KG of Cooking Gas @ N736.00','2023-03-05 13:04:15','',''),('4','283',234,'','6.1','4',0.00,9200.00,'Retail Sale Id 109 for retail product','2023-03-05 13:04:15','',''),('4','283',235,'','6.1','4',0.00,9200.00,'Retail Sale Id 109 for retail product','2023-03-05 13:04:15','',''),('4','283',236,'','20','3',4000.00,0.00,'Retail Sale Id 111 for 5.43 KG of Cooking Gas @ N736.00','2023-03-05 13:10:42','',''),('4','283',237,'','2','6',0.00,4000.00,'Retail Sale Id 111 for retail product','2023-03-05 13:10:42','',''),('4','283',238,'','20','3',9200.00,0.00,'Retail Sale Id 112 for 12.50 KG of Cooking Gas @ N736.00','2023-03-05 13:17:32','',''),('4','283',239,'','2','6',0.00,9200.00,'Retail Sale Id 112 for retail product','2023-03-05 13:17:32','',''),('4','283',240,'','20','3',8832.00,0.00,'Retail Sale Id 113 for 12.00 KG of Cooking Gas @ N736.00','2023-03-05 13:21:21','',''),('4','283',241,'','2','6',0.00,8832.00,'Retail Sale Id 113 for retail product','2023-03-05 13:21:21','',''),('4','283',242,'','20','3',3680.00,0.00,'Retail Sale Id 114 for 5.00 KG of Cooking Gas @ N736.00','2023-03-05 13:24:18','',''),('4','283',243,'','2','6',0.00,3680.00,'Retail Sale Id 114 for retail product','2023-03-05 13:24:18','',''),('4','283',244,'','20','3',2208.00,0.00,'Retail Sale Id 116 for 3.00 KG of Cooking Gas @ N736.00','2023-03-05 13:29:20','',''),('4','283',245,'','2','6',0.00,2208.00,'Retail Sale Id 116 for retail product','2023-03-05 13:29:20','',''),('4','283',246,'','20','3',2208.00,0.00,'Retail Sale Id 117 for 3.00 KG of Cooking Gas @ N736.00','2023-03-05 13:32:13','',''),('4','283',247,'','2','6',0.00,2208.00,'Retail Sale Id 117 for retail product','2023-03-05 13:32:13','',''),('4','283',248,'','20','3',3680.00,0.00,'Retail Sale Id 118 for 5.00 KG of Cooking Gas @ N736.00','2023-03-05 13:34:55','',''),('4','283',249,'','2','6',0.00,3680.00,'Retail Sale Id 118 for retail product','2023-03-05 13:34:55','',''),('4','283',250,'','20','3',2944.00,0.00,'Retail Sale Id 119 for 4.00 KG of Cooking Gas @ N736.00','2023-03-05 13:37:32','',''),('4','283',251,'','2','6',0.00,2944.00,'Retail Sale Id 119 for retail product','2023-03-05 13:37:32','',''),('4','283',252,'','20','3',2500.00,0.00,'Retail Sale Id 120 for 3.40 KG of Cooking Gas @ N736.00','2023-03-05 13:39:55','',''),('4','283',253,'','6.1','4',0.00,2500.00,'Retail Sale Id 120 for retail product','2023-03-05 13:39:55','',''),('4','283',254,'','20','3',3000.00,0.00,'Retail Sale Id 121 for 4.08 KG of Cooking Gas @ N736.00','2023-03-05 13:43:09','',''),('4','283',255,'','2','6',0.00,3000.00,'Retail Sale Id 121 for retail product','2023-03-05 13:43:09','',''),('4','283',256,'','20','3',736.00,0.00,'Retail Sale Id 122 for 1.00 KG of Cooking Gas @ N736.00','2023-03-05 13:45:44','',''),('4','283',257,'','2','6',0.00,736.00,'Retail Sale Id 122 for retail product','2023-03-05 13:45:44','',''),('4','283',258,'','20','3',18400.00,0.00,'Retail Sale Id 123 for 25.00 KG of Cooking Gas @ N736.00','2023-03-05 13:47:49','',''),('4','283',259,'','2','6',0.00,18400.00,'Retail Sale Id 123 for retail product','2023-03-05 13:47:49','',''),('4','283',260,'','20','3',9200.00,0.00,'Retail Sale Id 124 for 12.50 KG of Cooking Gas @ N736.00','2023-03-05 13:50:17','',''),('4','283',261,'','2','6',0.00,9200.00,'Retail Sale Id 124 for retail product','2023-03-05 13:50:17','',''),('4','283',262,'','20','3',1000.00,0.00,'Retail Sale Id 125 for 1.36 KG of Cooking Gas @ N736.00','2023-03-05 13:52:36','',''),('4','283',263,'','2','6',0.00,1000.00,'Retail Sale Id 125 for retail product','2023-03-05 13:52:36','',''),('4','283',264,'','20','3',4416.00,0.00,'Retail Sale Id 126 for 6.00 KG of Cooking Gas @ N736.00','2023-03-05 13:59:02','',''),('4','283',265,'','2','6',0.00,4416.00,'Retail Sale Id 126 for retail product','2023-03-05 13:59:02','',''),('4','283',266,'','20','3',4416.00,0.00,'Retail Sale Id 127 for 6.00 KG of Cooking Gas @ N736.00','2023-03-05 14:01:08','',''),('4','283',267,'','2','6',0.00,4416.00,'Retail Sale Id 127 for retail product','2023-03-05 14:01:08','',''),('4','283',268,'','20','3',1500.00,0.00,'Retail Sale Id 128 for 2.04 KG of Cooking Gas @ N736.00','2023-03-05 17:03:50','',''),('4','283',269,'','6.1','4',0.00,1500.00,'Retail Sale Id 128 for retail product','2023-03-05 17:03:50','',''),('4','283',270,'','20','3',12880.00,0.00,'Retail Sale Id 129 for 17.50 KG of Cooking Gas @ N736.00','2023-03-05 17:07:41','',''),('4','283',271,'','2','6',0.00,12880.00,'Retail Sale Id 129 for retail product','2023-03-05 17:07:41','',''),('4','283',272,'','20','3',12144.00,0.00,'Retail Sale Id 130 for 16.50 KG of Cooking Gas @ N736.00','2023-03-05 17:10:11','',''),('4','283',273,'','2','6',0.00,12144.00,'Retail Sale Id 130 for retail product','2023-03-05 17:10:11','',''),('4','283',274,'','20','3',9200.00,0.00,'Retail Sale Id 131 for 12.50 KG of Cooking Gas @ N736.00','2023-03-05 17:12:49','',''),('4','283',275,'','2','6',0.00,9200.00,'Retail Sale Id 131 for retail product','2023-03-05 17:12:49','',''),('4','283',276,'','20','3',1472.00,0.00,'Retail Sale Id 132 for 2.00 KG of Cooking Gas @ N736.00','2023-03-05 17:19:09','',''),('4','283',277,'','2','6',0.00,1472.00,'Retail Sale Id 132 for retail product','2023-03-05 17:19:09','',''),('4','283',278,'','20','3',400.00,0.00,'Retail Sale Id 133 for 0.54 KG of Cooking Gas @ N736.00','2023-03-05 17:21:59','',''),('4','283',279,'','6.1','4',0.00,400.00,'Retail Sale Id 133 for retail product','2023-03-05 17:21:59','',''),('4','283',280,'','20','3',7360.00,0.00,'Retail Sale Id 134 for 10.00 KG of Cooking Gas @ N736.00','2023-03-05 17:24:40','',''),('4','283',281,'','2','6',0.00,7360.00,'Retail Sale Id 134 for retail product','2023-03-05 17:24:40','',''),('4','283',282,'','20','3',3680.00,0.00,'Retail Sale Id 135 for 5.00 KG of Cooking Gas @ N736.00','2023-03-05 17:28:31','',''),('4','283',283,'','2','6',0.00,3680.00,'Retail Sale Id 135 for retail product','2023-03-05 17:28:31','',''),('4','283',284,'','20','3',736.00,0.00,'Retail Sale Id 136 for 1.00 KG of Cooking Gas @ N736.00','2023-03-05 17:30:35','',''),('4','283',285,'','2','6',0.00,736.00,'Retail Sale Id 136 for retail product','2023-03-05 17:30:35','',''),('4','283',286,'','20','3',3680.00,0.00,'Retail Sale Id 137 for 5.00 KG of Cooking Gas @ N736.00','2023-03-05 17:33:04','',''),('4','283',287,'','2','6',0.00,3680.00,'Retail Sale Id 137 for retail product','2023-03-05 17:33:04','',''),('4','283',288,'','20','3',2944.00,0.00,'Retail Sale Id 138 for 4.00 KG of Cooking Gas @ N736.00','2023-03-05 17:35:45','',''),('4','283',289,'','2','6',0.00,2944.00,'Retail Sale Id 138 for retail product','2023-03-05 17:35:45','',''),('4','283',290,'','20','3',3680.00,0.00,'Retail Sale Id 139 for 5.00 KG of Cooking Gas @ N736.00','2023-03-05 17:40:47','',''),('4','283',291,'','2','6',0.00,3680.00,'Retail Sale Id 139 for retail product','2023-03-05 17:40:47','',''),('4','283',292,'','20','3',3680.00,0.00,'Retail Sale Id 140 for 5.00 KG of Cooking Gas @ N736.00','2023-03-05 17:42:49','',''),('4','283',293,'','2','6',0.00,3680.00,'Retail Sale Id 140 for retail product','2023-03-05 17:42:49','',''),('4','283',294,'','20','3',4416.00,0.00,'Retail Sale Id 141 for 6.00 KG of Cooking Gas @ N736.00','2023-03-05 17:44:55','',''),('4','283',295,'','2','6',0.00,4416.00,'Retail Sale Id 141 for retail product','2023-03-05 17:44:55','',''),('4','283',296,'','20','3',3680.00,0.00,'Retail Sale Id 142 for 5.00 KG of Cooking Gas @ N736.00','2023-03-05 17:47:32','',''),('4','283',297,'','2','6',0.00,3680.00,'Retail Sale Id 142 for retail product','2023-03-05 17:47:32','',''),('4','283',298,'','20','3',1000.00,0.00,'Retail Sale Id 143 for 1.36 KG of Cooking Gas @ N736.00','2023-03-05 17:49:57','',''),('4','283',299,'','2','6',0.00,1000.00,'Retail Sale Id 143 for retail product','2023-03-05 17:49:57','',''),('4','283',300,'','20','3',3000.00,0.00,'Retail Sale Id 144 for 4.08 KG of Cooking Gas @ N736.00','2023-03-05 17:52:37','',''),('4','283',301,'','2','6',0.00,3000.00,'Retail Sale Id 144 for retail product','2023-03-05 17:52:37','',''),('4','283',302,'','20','3',0.00,3000.00,'Return of Retail Sale Id 144 for products','2023-03-05 17:53:41','',''),('4','283',303,'','','',3000.00,0.00,'Return of Retail Sale Id 144 for products','2023-03-05 17:53:41','',''),('4','283',304,'','20','3',9200.00,0.00,'Retail Sale Id 145 for 12.50 KG of Cooking Gas @ N736.00','2023-03-05 17:55:25','',''),('4','283',305,'','2','6',0.00,9200.00,'Retail Sale Id 145 for retail product','2023-03-05 17:55:25','',''),('4','283',306,'','20','3',0.00,3680.00,'Return of Retail Sale Id 140 for products','2023-03-05 17:58:23','',''),('4','283',307,'','','',3680.00,0.00,'Return of Retail Sale Id 140 for products','2023-03-05 17:58:23','',''),('4','283',308,'','20','3',9200.00,0.00,'Retail Sale Id 146 for 12.50 KG of Cooking Gas @ N736.00','2023-03-06 08:03:35','',''),('4','283',309,'','6.1','4',0.00,9200.00,'Retail Sale Id 146 for retail product','2023-03-06 08:03:35','',''),('4','283',310,'','20','3',2208.00,0.00,'Retail Sale Id 149 for 3.00 KG of Cooking Gas @ N736.00','2023-03-06 08:06:45','',''),('4','283',311,'','6.1','4',0.00,2208.00,'Retail Sale Id 149 for retail product','2023-03-06 08:06:45','',''),('4','283',312,'','20','3',18400.00,0.00,'Retail Sale Id 150 for 25.00 KG of Cooking Gas @ N736.00','2023-03-06 08:08:27','',''),('4','283',313,'','6.1','4',0.00,18400.00,'Retail Sale Id 150 for retail product','2023-03-06 08:08:27','',''),('4','283',314,'','20','3',6000.00,0.00,'Retail Sale Id 151 for 8.15 KG of Cooking Gas @ N736.00','2023-03-06 08:10:33','',''),('4','283',315,'','6.1','4',0.00,6000.00,'Retail Sale Id 151 for retail product','2023-03-06 08:10:33','',''),('4','283',316,'','20','3',1472.00,0.00,'Retail Sale Id 152 for 2.00 KG of Cooking Gas @ N736.00','2023-03-06 08:13:58','',''),('4','283',317,'','6.1','4',0.00,1472.00,'Retail Sale Id 152 for retail product','2023-03-06 08:13:58','',''),('4','283',318,'','20','3',9200.00,0.00,'Retail Sale Id 155 for 12.50 KG of Cooking Gas @ N736.00','2023-03-06 08:16:15','',''),('4','283',319,'','6.1','4',0.00,9200.00,'Retail Sale Id 155 for retail product','2023-03-06 08:16:15','',''),('4','283',320,'','20','3',8832.00,0.00,'Retail Sale Id 157 for 12.00 KG of Cooking Gas @ N736.00','2023-03-06 08:18:01','',''),('4','283',321,'','6.1','4',0.00,8832.00,'Retail Sale Id 157 for retail product','2023-03-06 08:18:01','',''),('4','283',322,'','20','3',750.00,0.00,'Retail Sale Id 158 for 1.02 KG of Cooking Gas @ N736.00','2023-03-06 08:30:11','',''),('4','283',323,'','6.1','4',0.00,750.00,'Retail Sale Id 158 for retail product','2023-03-06 08:30:11','',''),('4','283',324,'','20','3',6992.00,0.00,'Retail Sale Id 159 for 9.50 KG of Cooking Gas @ N736.00','2023-03-06 08:33:23','',''),('4','283',325,'','6.1','4',0.00,6992.00,'Retail Sale Id 159 for retail product','2023-03-06 08:33:23','',''),('4','283',326,'','20','3',8832.00,0.00,'Retail Sale Id 160 for 12.00 KG of Cooking Gas @ N736.00','2023-03-06 08:43:50','',''),('4','283',327,'','6.1','4',0.00,8832.00,'Retail Sale Id 160 for retail product','2023-03-06 08:43:50','',''),('4','283',328,'','20','3',2300.00,0.00,'Retail Sale Id 162 for 3.13 KG of Cooking Gas @ N736.00','2023-03-06 08:49:27','',''),('4','283',329,'','6.1','4',0.00,2300.00,'Retail Sale Id 162 for retail product','2023-03-06 08:49:27','',''),('4','283',330,'','20','3',4000.00,0.00,'Retail Sale Id 164 for 5.43 KG of Cooking Gas @ N736.00','2023-03-06 09:03:07','',''),('4','283',331,'','6.1','4',0.00,4000.00,'Retail Sale Id 164 for retail product','2023-03-06 09:03:07','',''),('4','283',332,'','20','3',2208.00,0.00,'Retail Sale Id 165 for 3.00 KG of Cooking Gas @ N736.00','2023-03-06 09:10:33','',''),('4','283',333,'','6.1','4',0.00,2208.00,'Retail Sale Id 165 for retail product','2023-03-06 09:10:33','',''),('4','283',334,'','20','3',4416.00,0.00,'Retail Sale Id 166 for 6.00 KG of Cooking Gas @ N736.00','2023-03-06 09:12:19','',''),('4','283',335,'','6.1','4',0.00,4416.00,'Retail Sale Id 166 for retail product','2023-03-06 09:12:19','',''),('4','283',336,'','20','3',3000.00,0.00,'Retail Sale Id 167 for 4.08 KG of Cooking Gas @ N736.00','2023-03-06 09:15:27','',''),('4','283',337,'','6.1','4',0.00,3000.00,'Retail Sale Id 167 for retail product','2023-03-06 09:15:27','',''),('4','283',338,'','20','3',2208.00,0.00,'Retail Sale Id 168 for 3.00 KG of Cooking Gas @ N736.00','2023-03-06 09:17:14','',''),('4','283',339,'','6.1','4',0.00,2208.00,'Retail Sale Id 168 for retail product','2023-03-06 09:17:14','',''),('4','283',340,'','20','3',11408.00,0.00,'Retail Sale Id 169 for 15.50 KG of Cooking Gas @ N736.00','2023-03-06 09:20:35','',''),('4','283',341,'','6.1','4',0.00,11408.00,'Retail Sale Id 169 for retail product','2023-03-06 09:20:35','',''),('4','283',342,'','6.1','4',0.00,11408.00,'Retail Sale Id 169 for retail product','2023-03-06 09:20:35','',''),('4','283',343,'','20','3',2208.00,0.00,'Retail Sale Id 170 for 3.00 KG of Cooking Gas @ N736.00','2023-03-06 09:23:56','',''),('4','283',344,'','6.1','4',0.00,2208.00,'Retail Sale Id 170 for retail product','2023-03-06 09:23:56','',''),('4','283',345,'','20','3',4416.00,0.00,'Retail Sale Id 171 for 6.00 KG of Cooking Gas @ N736.00','2023-03-06 09:26:30','',''),('4','283',346,'','6.1','4',0.00,4416.00,'Retail Sale Id 171 for retail product','2023-03-06 09:26:30','',''),('4','283',347,'','20','3',0.00,0.00,'Sales from shift 11 on 2023-03-09 13:05:09 ','2023-03-09 13:05:09','',''),('4','283',348,'','6.1','4',0.00,0.00,'Sales from shift 11 on 2023-03-09 13:05:09 ','2023-03-09 13:05:09','',''),('4','283',349,'','20','3',9200.00,0.00,'Retail Sale Id 172 for 12.50 KG of Cooking Gas @ N736.00','2023-03-09 13:07:05','',''),('4','283',350,'','2','6',0.00,9200.00,'Retail Sale Id 172 for retail product','2023-03-09 13:07:05','',''),('4','283',351,'','20','3',3680.00,0.00,'Retail Sale Id 173 for 5.00 KG of Cooking Gas @ N736.00','2023-03-09 13:17:43','',''),('4','283',352,'','2','6',0.00,3680.00,'Retail Sale Id 173 for retail product','2023-03-09 13:17:43','',''),('4','283',353,'','20','3',2208.00,0.00,'Retail Sale Id 174 for 3.00 KG of Cooking Gas @ N736.00','2023-03-09 13:24:50','',''),('4','283',354,'','2','6',0.00,2208.00,'Retail Sale Id 174 for retail product','2023-03-09 13:24:50','',''),('4','283',355,'','20','3',2208.00,0.00,'Retail Sale Id 175 for 3.00 KG of Cooking Gas @ N736.00','2023-03-09 13:53:23','',''),('4','283',356,'','2','6',0.00,2208.00,'Retail Sale Id 175 for retail product','2023-03-09 13:53:23','',''),('4','283',357,'','20','3',4416.00,0.00,'Retail Sale Id 176 for 6.00 KG of Cooking Gas @ N736.00','2023-03-09 13:57:53','',''),('4','283',358,'','2','6',0.00,4416.00,'Retail Sale Id 176 for retail product','2023-03-09 13:57:53','',''),('4','283',359,'','20','3',6624.00,0.00,'Retail Sale Id 177 for 9.00 KG of Cooking Gas @ N736.00','2023-03-09 14:08:01','',''),('4','283',360,'','2','6',0.00,6624.00,'Retail Sale Id 177 for retail product','2023-03-09 14:08:01','',''),('4','283',361,'','20','3',3680.00,0.00,'Retail Sale Id 178 for 5.00 KG of Cooking Gas @ N736.00','2023-03-09 14:23:34','',''),('4','283',362,'','2','6',0.00,3680.00,'Retail Sale Id 178 for retail product','2023-03-09 14:23:34','',''),('4','283',363,'','20','3',9200.00,0.00,'Retail Sale Id 179 for 12.50 KG of Cooking Gas @ N736.00','2023-03-09 14:38:25','',''),('4','283',364,'','2','6',0.00,9200.00,'Retail Sale Id 179 for retail product','2023-03-09 14:38:25','',''),('4','283',365,'','20','3',18400.00,0.00,'Retail Sale Id 180 for 25.00 KG of Cooking Gas @ N736.00','2023-03-09 14:41:37','',''),('4','283',366,'','2','6',0.00,18400.00,'Retail Sale Id 180 for retail product','2023-03-09 14:41:37','',''),('4','283',367,'','20','3',4416.00,0.00,'Retail Sale Id 181 for 6.00 KG of Cooking Gas @ N736.00','2023-03-09 14:44:01','',''),('4','283',368,'','2','6',0.00,4416.00,'Retail Sale Id 181 for retail product','2023-03-09 14:44:01','',''),('4','283',369,'','20','3',4416.00,0.00,'Retail Sale Id 182 for 6.00 KG of Cooking Gas @ N736.00','2023-03-09 14:45:47','',''),('4','283',370,'','2','6',0.00,4416.00,'Retail Sale Id 182 for retail product','2023-03-09 14:45:47','',''),('4','283',371,'','20','3',8875.00,0.00,'Retail Sale Id 183 for 12.50 KG of Cooking Gas @ N710.00','2023-03-09 14:53:59','',''),('4','283',372,'','2','6',0.00,8875.00,'Retail Sale Id 183 for retail product','2023-03-09 14:53:59','',''),('4','283',373,'','20','3',736.00,0.00,'Retail Sale Id 184 for 1.00 KG of Cooking Gas @ N736.00','2023-03-09 14:56:17','',''),('4','283',374,'','6.1','4',0.00,736.00,'Retail Sale Id 184 for retail product','2023-03-09 14:56:17','',''),('4','283',375,'','20','3',2000.00,0.00,'Retail Sale Id 185 for 2.72 KG of Cooking Gas @ N736.00','2023-03-09 14:58:46','',''),('4','283',376,'','6.1','4',0.00,2000.00,'Retail Sale Id 185 for retail product','2023-03-09 14:58:46','',''),('4','283',377,'','20','3',3680.00,0.00,'Retail Sale Id 186 for 5.00 KG of Cooking Gas @ N736.00','2023-03-09 15:01:34','',''),('4','283',378,'','2','6',0.00,3680.00,'Retail Sale Id 186 for retail product','2023-03-09 15:01:34','',''),('4','283',379,'','20','3',2208.00,0.00,'Retail Sale Id 187 for 3.00 KG of Cooking Gas @ N736.00','2023-03-09 15:03:52','',''),('4','283',380,'','2','6',0.00,2208.00,'Retail Sale Id 187 for retail product','2023-03-09 15:03:52','',''),('4','283',381,'','20','3',2208.00,0.00,'Retail Sale Id 188 for 3.00 KG of Cooking Gas @ N736.00','2023-03-09 15:05:54','',''),('4','283',382,'','2','6',0.00,2208.00,'Retail Sale Id 188 for retail product','2023-03-09 15:05:54','',''),('4','283',383,'','20','3',3680.00,0.00,'Retail Sale Id 189 for 5.00 KG of Cooking Gas @ N736.00','2023-03-09 15:08:01','',''),('4','283',384,'','2','6',0.00,3680.00,'Retail Sale Id 189 for retail product','2023-03-09 15:08:01','',''),('4','283',385,'','20','3',5000.00,0.00,'Retail Sale Id 190 for 6.79 KG of Cooking Gas @ N736.00','2023-03-09 15:09:54','',''),('4','283',386,'','2','6',0.00,5000.00,'Retail Sale Id 190 for retail product','2023-03-09 15:09:54','',''),('4','283',387,'','20','3',2000.00,0.00,'Retail Sale Id 191 for 2.72 KG of Cooking Gas @ N736.00','2023-03-09 15:11:51','',''),('4','283',388,'','2','6',0.00,2000.00,'Retail Sale Id 191 for retail product','2023-03-09 15:11:51','',''),('4','283',389,'','20','3',2944.00,0.00,'Retail Sale Id 192 for 4.00 KG of Cooking Gas @ N736.00','2023-03-09 15:13:34','',''),('4','283',390,'','2','6',0.00,2944.00,'Retail Sale Id 192 for retail product','2023-03-09 15:13:34','',''),('4','283',391,'','20','3',2208.00,0.00,'Retail Sale Id 193 for 3.00 KG of Cooking Gas @ N736.00','2023-03-09 15:15:58','',''),('4','283',392,'','2','6',0.00,2208.00,'Retail Sale Id 193 for retail product','2023-03-09 15:15:58','',''),('4','283',393,'','20','3',4416.00,0.00,'Retail Sale Id 194 for 6.00 KG of Cooking Gas @ N736.00','2023-03-09 15:17:53','',''),('4','283',394,'','2','6',0.00,4416.00,'Retail Sale Id 194 for retail product','2023-03-09 15:17:53','',''),('4','283',395,'','20','3',3680.00,0.00,'Retail Sale Id 195 for 5.00 KG of Cooking Gas @ N736.00','2023-03-09 15:23:27','',''),('4','283',396,'','2','6',0.00,3680.00,'Retail Sale Id 195 for retail product','2023-03-09 15:23:27','',''),('4','283',397,'','20','3',13616.00,0.00,'Retail Sale Id 196 for 18.50 KG of Cooking Gas @ N736.00','2023-03-09 15:27:53','',''),('4','283',398,'','2','6',0.00,13616.00,'Retail Sale Id 196 for retail product','2023-03-09 15:27:53','',''),('4','283',399,'','20','3',5888.00,0.00,'Retail Sale Id 197 for 8.00 KG of Cooking Gas @ N736.00','2023-03-09 15:30:21','',''),('4','283',400,'','2','6',0.00,5888.00,'Retail Sale Id 197 for retail product','2023-03-09 15:30:21','',''),('4','283',401,'','20','3',2944.00,0.00,'Retail Sale Id 198 for 4.00 KG of Cooking Gas @ N736.00','2023-03-09 15:35:43','',''),('4','283',402,'','2','6',0.00,2944.00,'Retail Sale Id 198 for retail product','2023-03-09 15:35:43','',''),('4','283',403,'','20','3',9200.00,0.00,'Retail Sale Id 199 for 12.50 KG of Cooking Gas @ N736.00','2023-03-09 15:38:01','',''),('4','283',404,'','2','6',0.00,9200.00,'Retail Sale Id 199 for retail product','2023-03-09 15:38:01','',''),('4','283',405,'','20','3',2208.00,0.00,'Retail Sale Id 200 for 3.00 KG of Cooking Gas @ N736.00','2023-03-09 15:41:21','',''),('4','283',406,'','2','6',0.00,2208.00,'Retail Sale Id 200 for retail product','2023-03-09 15:41:21','',''),('4','283',407,'','20','3',7360.00,0.00,'Retail Sale Id 201 for 10.00 KG of Cooking Gas @ N736.00','2023-03-09 15:43:09','',''),('4','283',408,'','2','6',0.00,7360.00,'Retail Sale Id 201 for retail product','2023-03-09 15:43:09','',''),('4','283',409,'','20','3',4416.00,0.00,'Retail Sale Id 202 for 6.00 KG of Cooking Gas @ N736.00','2023-03-09 15:45:44','',''),('4','283',410,'','2','6',0.00,4416.00,'Retail Sale Id 202 for retail product','2023-03-09 15:45:44','',''),('4','283',411,'','20','3',4416.00,0.00,'Retail Sale Id 205 for 6.00 KG of Cooking Gas @ N736.00','2023-03-09 15:59:05','',''),('4','283',412,'','2','6',0.00,4416.00,'Retail Sale Id 205 for retail product','2023-03-09 15:59:05','',''),('4','283',413,'','20','3',5152.00,0.00,'Retail Sale Id 206 for 7.00 KG of Cooking Gas @ N736.00','2023-03-09 16:01:52','',''),('4','283',414,'','2','6',0.00,5152.00,'Retail Sale Id 206 for retail product','2023-03-09 16:01:52','',''),('4','283',415,'','20','3',9200.00,0.00,'Retail Sale Id 207 for 12.50 KG of Cooking Gas @ N736.00','2023-03-09 16:07:16','',''),('4','283',416,'','2','6',0.00,9200.00,'Retail Sale Id 207 for retail product','2023-03-09 16:07:16','',''),('4','283',417,'','20','3',3680.00,0.00,'Retail Sale Id 209 for 5.00 KG of Cooking Gas @ N736.00','2023-03-09 16:10:59','',''),('4','283',418,'','2','6',0.00,3680.00,'Retail Sale Id 209 for retail product','2023-03-09 16:10:59','',''),('4','283',419,'','20','3',7360.00,0.00,'Retail Sale Id 210 for 10.00 KG of Cooking Gas @ N736.00','2023-03-09 16:30:13','',''),('4','283',420,'','2','6',0.00,7360.00,'Retail Sale Id 210 for retail product','2023-03-09 16:30:13','',''),('4','283',421,'','20','3',1500.00,0.00,'Retail Sale Id 212 for 2.04 KG of Cooking Gas @ N736.00','2023-03-09 16:33:46','',''),('4','283',422,'','2','6',0.00,1500.00,'Retail Sale Id 212 for retail product','2023-03-09 16:33:46','',''),('4','283',423,'','20','3',15456.00,0.00,'Retail Sale Id 213 for 21.00 KG of Cooking Gas @ N736.00','2023-03-09 16:38:29','',''),('4','283',424,'','2','6',0.00,15456.00,'Retail Sale Id 213 for retail product','2023-03-09 16:38:29','',''),('4','283',425,'','20','3',2944.00,0.00,'Retail Sale Id 214 for 4.00 KG of Cooking Gas @ N736.00','2023-03-09 16:40:21','',''),('4','283',426,'','2','6',0.00,2944.00,'Retail Sale Id 214 for retail product','2023-03-09 16:40:21','',''),('4','283',427,'','20','3',4416.00,0.00,'Retail Sale Id 215 for 6.00 KG of Cooking Gas @ N736.00','2023-03-09 16:45:49','',''),('4','283',428,'','2','6',0.00,4416.00,'Retail Sale Id 215 for retail product','2023-03-09 16:45:49','',''),('4','283',429,'','20','3',27232.00,0.00,'Retail Sale Id 216 for 37.00 KG of Cooking Gas @ N736.00','2023-03-09 16:51:41','',''),('4','283',430,'','2','6',0.00,27232.00,'Retail Sale Id 216 for retail product','2023-03-09 16:51:41','',''),('4','283',431,'','20','3',4000.00,0.00,'Retail Sale Id 217 for 5.43 KG of Cooking Gas @ N736.00','2023-03-09 16:55:31','',''),('4','283',432,'','2','6',0.00,4000.00,'Retail Sale Id 217 for retail product','2023-03-09 16:55:31','',''),('4','283',433,'','20','3',3680.00,0.00,'Retail Sale Id 218 for 5.00 KG of Cooking Gas @ N736.00','2023-03-09 17:06:29','',''),('4','283',434,'','2','6',0.00,3680.00,'Retail Sale Id 218 for retail product','2023-03-09 17:06:29','',''),('4','283',435,'','20','3',2208.00,0.00,'Retail Sale Id 219 for 3.00 KG of Cooking Gas @ N736.00','2023-03-09 17:12:08','',''),('4','283',436,'','2','6',0.00,2208.00,'Retail Sale Id 219 for retail product','2023-03-09 17:12:08','',''),('4','283',437,'','20','3',4000.00,0.00,'Retail Sale Id 220 for 5.43 KG of Cooking Gas @ N736.00','2023-03-09 17:14:26','',''),('4','283',438,'','2','6',0.00,4000.00,'Retail Sale Id 220 for retail product','2023-03-09 17:14:26','',''),('4','283',439,'','20','3',5000.00,0.00,'Retail Sale Id 221 for 6.79 KG of Cooking Gas @ N736.00','2023-03-09 17:19:29','',''),('4','283',440,'','2','6',0.00,5000.00,'Retail Sale Id 221 for retail product','2023-03-09 17:19:29','',''),('4','283',441,'','20','3',4416.00,0.00,'Retail Sale Id 222 for 6.00 KG of Cooking Gas @ N736.00','2023-03-09 17:21:38','',''),('4','283',442,'','2','6',0.00,4416.00,'Retail Sale Id 222 for retail product','2023-03-09 17:21:38','',''),('4','283',443,'','20','3',2208.00,0.00,'Retail Sale Id 223 for 3.00 KG of Cooking Gas @ N736.00','2023-03-09 17:23:44','',''),('4','283',444,'','2','6',0.00,2208.00,'Retail Sale Id 223 for retail product','2023-03-09 17:23:44','',''),('4','283',445,'','20','3',8832.00,0.00,'Retail Sale Id 224 for 12.00 KG of Cooking Gas @ N736.00','2023-03-09 17:25:32','',''),('4','283',446,'','2','6',0.00,8832.00,'Retail Sale Id 224 for retail product','2023-03-09 17:25:32','',''),('4','283',447,'','20','3',9200.00,0.00,'Retail Sale Id 225 for 12.50 KG of Cooking Gas @ N736.00','2023-03-09 17:27:26','',''),('4','283',448,'','2','6',0.00,9200.00,'Retail Sale Id 225 for retail product','2023-03-09 17:27:26','',''),('4','283',449,'','20','3',1472.00,0.00,'Retail Sale Id 226 for 2.00 KG of Cooking Gas @ N736.00','2023-03-09 17:31:29','',''),('4','283',450,'','2','6',0.00,1472.00,'Retail Sale Id 226 for retail product','2023-03-09 17:31:29','',''),('4','283',451,'','20','3',1200.00,0.00,'Retail Sale Id 227 for 1.63 KG of Cooking Gas @ N736.00','2023-03-09 17:36:10','',''),('4','283',452,'','2','6',0.00,1200.00,'Retail Sale Id 227 for retail product','2023-03-09 17:36:10','',''),('4','283',453,'','20','3',1500.00,0.00,'Retail Sale Id 228 for 2.04 KG of Cooking Gas @ N736.00','2023-03-09 17:39:35','',''),('4','283',454,'','2','6',0.00,1500.00,'Retail Sale Id 228 for retail product','2023-03-09 17:39:35','',''),('4','283',455,'','20','3',4416.00,0.00,'Retail Sale Id 229 for 6.00 KG of Cooking Gas @ N736.00','2023-03-09 17:42:10','',''),('4','283',456,'','2','6',0.00,4416.00,'Retail Sale Id 229 for retail product','2023-03-09 17:42:10','',''),('4','283',457,'','20','3',9200.00,0.00,'Retail Sale Id 230 for 12.50 KG of Cooking Gas @ N736.00','2023-03-09 17:44:07','',''),('4','283',458,'','2','6',0.00,9200.00,'Retail Sale Id 230 for retail product','2023-03-09 17:44:07','',''),('4','283',459,'','20','3',2208.00,0.00,'Retail Sale Id 231 for 3.00 KG of Cooking Gas @ N736.00','2023-03-09 17:49:39','',''),('4','283',460,'','2','6',0.00,2208.00,'Retail Sale Id 231 for retail product','2023-03-09 17:49:39','',''),('4','283',461,'','20','3',2500.00,0.00,'Retail Sale Id 232 for 3.40 KG of Cooking Gas @ N736.00','2023-03-09 17:51:36','',''),('4','283',462,'','2','6',0.00,2500.00,'Retail Sale Id 232 for retail product','2023-03-09 17:51:36','',''),('4','283',463,'','20','3',4416.00,0.00,'Retail Sale Id 233 for 6.00 KG of Cooking Gas @ N736.00','2023-03-09 17:53:32','',''),('4','283',464,'','2','6',0.00,4416.00,'Retail Sale Id 233 for retail product','2023-03-09 17:53:32','',''),('4','283',465,'','20','3',0.00,0.00,'Sales from shift 12 on 2023-03-10 08:46:28 ','2023-03-10 08:46:28','',''),('4','283',466,'','6.1','4',0.00,0.00,'Sales from shift 12 on 2023-03-10 08:46:28 ','2023-03-10 08:46:28','',''),('4','283',467,'','20','3',1000.00,0.00,'Retail Sale Id 234 for 1.36 KG of Cooking Gas @ N736.00','2023-03-10 09:00:09','',''),('4','283',468,'','6.1','4',0.00,1000.00,'Retail Sale Id 234 for retail product','2023-03-10 09:00:09','',''),('4','283',469,'','20','3',6624.00,0.00,'Retail Sale Id 235 for 9.00 KG of Cooking Gas @ N736.00','2023-03-10 09:30:06','',''),('4','283',470,'','2','6',0.00,6624.00,'Retail Sale Id 235 for retail product','2023-03-10 09:30:06','',''),('4','283',471,'','20','3',9200.00,0.00,'Retail Sale Id 236 for 12.50 KG of Cooking Gas @ N736.00','2023-03-10 09:47:01','',''),('4','283',472,'','6.1','4',0.00,9200.00,'Retail Sale Id 236 for retail product','2023-03-10 09:47:01','',''),('4','283',473,'','6.1','4',0.00,9200.00,'Retail Sale Id 236 for retail product','2023-03-10 09:47:01','',''),('4','283',474,'','20','3',4416.00,0.00,'Retail Sale Id 237 for 6.00 KG of Cooking Gas @ N736.00','2023-03-10 09:48:35','',''),('4','283',475,'','6.1','4',0.00,4416.00,'Retail Sale Id 237 for retail product','2023-03-10 09:48:35','',''),('4','283',476,'','20','3',13616.00,0.00,'Retail Sale Id 238 for 18.50 KG of Cooking Gas @ N736.00','2023-03-10 09:50:50','',''),('4','283',477,'','6.1','4',0.00,13616.00,'Retail Sale Id 238 for retail product','2023-03-10 09:50:50','',''),('4','283',478,'','20','3',3680.00,0.00,'Retail Sale Id 239 for 5.00 KG of Cooking Gas @ N736.00','2023-03-10 09:52:11','',''),('4','283',479,'','6.1','4',0.00,3680.00,'Retail Sale Id 239 for retail product','2023-03-10 09:52:11','',''),('4','283',480,'','20','3',2208.00,0.00,'Retail Sale Id 240 for 3.00 KG of Cooking Gas @ N736.00','2023-03-10 09:53:26','',''),('4','283',481,'','6.1','4',0.00,2208.00,'Retail Sale Id 240 for retail product','2023-03-10 09:53:26','',''),('4','283',482,'','6.1','4',0.00,2208.00,'Retail Sale Id 240 for retail product','2023-03-10 09:53:26','',''),('4','283',483,'','20','3',2000.00,0.00,'Retail Sale Id 241 for 2.72 KG of Cooking Gas @ N736.00','2023-03-10 09:55:36','',''),('4','283',484,'','6.1','4',0.00,2000.00,'Retail Sale Id 241 for retail product','2023-03-10 09:55:36','',''),('4','283',485,'','6.1','4',0.00,2000.00,'Retail Sale Id 241 for retail product','2023-03-10 09:55:36','',''),('4','283',486,'','20','3',4416.00,0.00,'Retail Sale Id 243 for 6.00 KG of Cooking Gas @ N736.00','2023-03-10 09:57:59','',''),('4','283',487,'','6.1','4',0.00,4416.00,'Retail Sale Id 243 for retail product','2023-03-10 09:57:59','',''),('4','283',488,'','20','3',8096.00,0.00,'Retail Sale Id 245 for 11.00 KG of Cooking Gas @ N736.00','2023-03-10 09:59:08','',''),('4','283',489,'','6.1','4',0.00,8096.00,'Retail Sale Id 245 for retail product','2023-03-10 09:59:08','',''),('4','283',490,'','6.1','4',0.00,8096.00,'Retail Sale Id 245 for retail product','2023-03-10 09:59:08','',''),('4','283',491,'','20','3',2944.00,0.00,'Retail Sale Id 246 for 4.00 KG of Cooking Gas @ N736.00','2023-03-10 10:00:14','',''),('4','283',492,'','6.1','4',0.00,2944.00,'Retail Sale Id 246 for retail product','2023-03-10 10:00:14','',''),('4','283',493,'','20','3',1472.00,0.00,'Retail Sale Id 247 for 2.00 KG of Cooking Gas @ N736.00','2023-03-10 10:01:54','',''),('4','283',494,'','6.1','4',0.00,1472.00,'Retail Sale Id 247 for retail product','2023-03-10 10:01:54','',''),('4','283',495,'','20','3',8832.00,0.00,'Retail Sale Id 248 for 12.00 KG of Cooking Gas @ N736.00','2023-03-10 10:04:11','',''),('4','283',496,'','6.1','4',0.00,8832.00,'Retail Sale Id 248 for retail product','2023-03-10 10:04:11','',''),('4','283',497,'','20','3',2208.00,0.00,'Retail Sale Id 249 for 3.00 KG of Cooking Gas @ N736.00','2023-03-10 10:06:38','',''),('4','283',498,'','6.1','4',0.00,2208.00,'Retail Sale Id 249 for retail product','2023-03-10 10:06:38','',''),('4','283',499,'','20','3',9200.00,0.00,'Retail Sale Id 251 for 12.50 KG of Cooking Gas @ N736.00','2023-03-10 10:08:02','',''),('4','283',500,'','6.1','4',0.00,9200.00,'Retail Sale Id 251 for retail product','2023-03-10 10:08:02','',''),('4','283',501,'','20','3',1472.00,0.00,'Retail Sale Id 252 for 2.00 KG of Cooking Gas @ N736.00','2023-03-10 10:14:18','',''),('4','283',502,'','6.1','4',0.00,1472.00,'Retail Sale Id 252 for retail product','2023-03-10 10:14:18','',''),('4','283',503,'','20','3',4416.00,0.00,'Retail Sale Id 253 for 6.00 KG of Cooking Gas @ N736.00','2023-03-10 10:15:50','',''),('4','283',504,'','6.1','4',0.00,4416.00,'Retail Sale Id 253 for retail product','2023-03-10 10:15:50','',''),('4','283',505,'','6.1','4',0.00,4416.00,'Retail Sale Id 253 for retail product','2023-03-10 10:15:50','',''),('4','283',506,'','20','3',5000.00,0.00,'Retail Sale Id 254 for 6.79 KG of Cooking Gas @ N736.00','2023-03-10 10:17:19','',''),('4','283',507,'','6.1','4',0.00,5000.00,'Retail Sale Id 254 for retail product','2023-03-10 10:17:19','',''),('4','283',508,'','20','3',4416.00,0.00,'Retail Sale Id 255 for 6.00 KG of Cooking Gas @ N736.00','2023-03-10 10:18:48','',''),('4','283',509,'','6.1','4',0.00,4416.00,'Retail Sale Id 255 for retail product','2023-03-10 10:18:48','',''),('4','283',510,'','20','3',9200.00,0.00,'Retail Sale Id 257 for 12.50 KG of Cooking Gas @ N736.00','2023-03-10 10:20:33','',''),('4','283',511,'','6.1','4',0.00,9200.00,'Retail Sale Id 257 for retail product','2023-03-10 10:20:33','',''),('4','283',512,'','20','3',2208.00,0.00,'Retail Sale Id 258 for 3.00 KG of Cooking Gas @ N736.00','2023-03-10 10:23:50','',''),('4','283',513,'','6.1','4',0.00,2208.00,'Retail Sale Id 258 for retail product','2023-03-10 10:23:50','',''),('4','283',514,'','20','3',9200.00,0.00,'Retail Sale Id 259 for 12.50 KG of Cooking Gas @ N736.00','2023-03-10 10:27:12','',''),('4','283',515,'','6.1','4',0.00,9200.00,'Retail Sale Id 259 for retail product','2023-03-10 10:27:12','',''),('4','283',516,'','20','3',5000.00,0.00,'Retail Sale Id 260 for 6.79 KG of Cooking Gas @ N736.00','2023-03-10 10:40:07','',''),('4','283',517,'','6.1','4',0.00,5000.00,'Retail Sale Id 260 for retail product','2023-03-10 10:40:07','',''),('4','283',518,'','20','3',2208.00,0.00,'Retail Sale Id 262 for 3.00 KG of Cooking Gas @ N736.00','2023-03-10 10:42:04','',''),('4','283',519,'','6.1','4',0.00,2208.00,'Retail Sale Id 262 for retail product','2023-03-10 10:42:04','',''),('4','283',520,'','20','3',2000.00,0.00,'Retail Sale Id 264 for 2.72 KG of Cooking Gas @ N736.00','2023-03-10 10:45:28','',''),('4','283',521,'','6.1','4',0.00,2000.00,'Retail Sale Id 264 for retail product','2023-03-10 10:45:28','',''),('4','283',522,'','20','3',71000.00,0.00,'Retail Sale Id 266 for 100.00 KG of Cooking Gas @ N710.00','2023-03-10 10:48:40','',''),('4','283',523,'','6.1','4',0.00,71000.00,'Retail Sale Id 266 for retail product','2023-03-10 10:48:40','',''),('4','283',524,'','20','3',9200.00,0.00,'Retail Sale Id 268 for 12.50 KG of Cooking Gas @ N736.00','2023-03-10 10:52:21','',''),('4','283',525,'','6.1','4',0.00,9200.00,'Retail Sale Id 268 for retail product','2023-03-10 10:52:21','',''),('4','283',526,'','20','3',1472.00,0.00,'Retail Sale Id 269 for 2.00 KG of Cooking Gas @ N736.00','2023-03-10 10:53:50','',''),('4','283',527,'','6.1','4',0.00,1472.00,'Retail Sale Id 269 for retail product','2023-03-10 10:53:50','',''),('4','283',528,'','20','3',9200.00,0.00,'Retail Sale Id 270 for 12.50 KG of Cooking Gas @ N736.00','2023-03-10 10:55:05','',''),('4','283',529,'','6.1','4',0.00,9200.00,'Retail Sale Id 270 for retail product','2023-03-10 10:55:05','',''),('4','283',530,'','20','3',1000.00,0.00,'Retail Sale Id 272 for 1.36 KG of Cooking Gas @ N736.00','2023-03-10 10:58:04','',''),('4','283',531,'','6.1','4',0.00,1000.00,'Retail Sale Id 272 for retail product','2023-03-10 10:58:04','',''),('4','283',532,'','20','3',6000.00,0.00,'Retail Sale Id 273 for 8.15 KG of Cooking Gas @ N736.00','2023-03-10 11:02:48','',''),('4','283',533,'','6.1','4',0.00,6000.00,'Retail Sale Id 273 for retail product','2023-03-10 11:02:48','',''),('4','283',534,'','20','3',9200.00,0.00,'Retail Sale Id 274 for 12.50 KG of Cooking Gas @ N736.00','2023-03-10 11:05:25','',''),('4','283',535,'','6.1','4',0.00,9200.00,'Retail Sale Id 274 for retail product','2023-03-10 11:05:25','',''),('4','283',536,'','20','3',2000.00,0.00,'Retail Sale Id 275 for 2.72 KG of Cooking Gas @ N736.00','2023-03-10 11:06:51','',''),('4','283',537,'','6.1','4',0.00,2000.00,'Retail Sale Id 275 for retail product','2023-03-10 11:06:51','',''),('4','283',538,'','20','3',68160.00,0.00,'Retail Sale Id 276 for 96.00 KG of Cooking Gas @ N710.00','2023-03-10 11:13:54','',''),('4','283',539,'','6.1','4',0.00,68160.00,'Retail Sale Id 276 for retail product','2023-03-10 11:13:54','',''),('4','283',540,'','20','3',9200.00,0.00,'Retail Sale Id 278 for 12.50 KG of Cooking Gas @ N736.00','2023-03-10 11:24:46','',''),('4','283',541,'','6.1','4',0.00,9200.00,'Retail Sale Id 278 for retail product','2023-03-10 11:24:46','',''),('4','283',542,'','6.1','4',0.00,9200.00,'Retail Sale Id 278 for retail product','2023-03-10 11:24:46','',''),('4','283',543,'','20','3',2000.00,0.00,'Retail Sale Id 280 for 2.72 KG of Cooking Gas @ N736.00','2023-03-10 11:26:49','',''),('4','283',544,'','6.1','4',0.00,2000.00,'Retail Sale Id 280 for retail product','2023-03-10 11:26:49','',''),('4','283',545,'','20','3',2200.00,0.00,'Retail Sale Id 281 for 2.99 KG of Cooking Gas @ N736.00','2023-03-10 11:39:30','',''),('4','283',546,'','6.1','4',0.00,2200.00,'Retail Sale Id 281 for retail product','2023-03-10 11:39:30','',''),('4','283',547,'','6.1','4',0.00,2200.00,'Retail Sale Id 281 for retail product','2023-03-10 11:39:30','',''),('4','283',548,'','6.1','4',0.00,2200.00,'Retail Sale Id 281 for retail product','2023-03-10 11:39:30','',''),('4','283',549,'','20','3',3680.00,0.00,'Retail Sale Id 283 for 5.00 KG of Cooking Gas @ N736.00','2023-03-10 11:48:35','',''),('4','283',550,'','6.1','4',0.00,3680.00,'Retail Sale Id 283 for retail product','2023-03-10 11:48:35','',''),('4','283',551,'','20','3',6624.00,0.00,'Retail Sale Id 284 for 9.00 KG of Cooking Gas @ N736.00','2023-03-10 11:51:43','',''),('4','283',552,'','6.1','4',0.00,6624.00,'Retail Sale Id 284 for retail product','2023-03-10 11:51:43','',''),('4','283',553,'','20','3',1000.00,0.00,'Retail Sale Id 286 for 1.36 KG of Cooking Gas @ N736.00','2023-03-10 12:03:49','',''),('4','283',554,'','6.1','4',0.00,1000.00,'Retail Sale Id 286 for retail product','2023-03-10 12:03:49','',''),('4','283',555,'','20','3',9200.00,0.00,'Retail Sale Id 287 for 12.50 KG of Cooking Gas @ N736.00','2023-03-10 12:08:02','',''),('4','283',556,'','6.1','4',0.00,9200.00,'Retail Sale Id 287 for retail product','2023-03-10 12:08:02','',''),('4','283',557,'','20','3',3000.00,0.00,'Retail Sale Id 289 for 4.08 KG of Cooking Gas @ N736.00','2023-03-10 12:10:24','',''),('4','283',558,'','6.1','4',0.00,3000.00,'Retail Sale Id 289 for retail product','2023-03-10 12:10:24','',''),('4','283',559,'','20','3',4000.00,0.00,'Retail Sale Id 290 for 5.43 KG of Cooking Gas @ N736.00','2023-03-10 12:22:57','',''),('4','283',560,'','6.1','4',0.00,4000.00,'Retail Sale Id 290 for retail product','2023-03-10 12:22:57','',''),('4','283',561,'','20','3',2500.00,0.00,'Retail Sale Id 292 for 3.40 KG of Cooking Gas @ N736.00','2023-03-10 12:27:29','',''),('4','283',562,'','6.1','4',0.00,2500.00,'Retail Sale Id 292 for retail product','2023-03-10 12:27:29','',''),('4','283',563,'','20','3',3680.00,0.00,'Retail Sale Id 293 for 5.00 KG of Cooking Gas @ N736.00','2023-03-10 12:32:30','',''),('4','283',564,'','6.1','4',0.00,3680.00,'Retail Sale Id 293 for retail product','2023-03-10 12:32:30','',''),('4','283',565,'','20','3',2208.00,0.00,'Retail Sale Id 294 for 3.00 KG of Cooking Gas @ N736.00','2023-03-10 12:35:41','',''),('4','283',566,'','6.1','4',0.00,2208.00,'Retail Sale Id 294 for retail product','2023-03-10 12:35:41','',''),('4','283',567,'','20','3',4416.00,0.00,'Retail Sale Id 295 for 6.00 KG of Cooking Gas @ N736.00','2023-03-10 12:50:56','',''),('4','283',568,'','6.1','4',0.00,4416.00,'Retail Sale Id 295 for retail product','2023-03-10 12:50:56','',''),('4','283',569,'','20','3',18400.00,0.00,'Retail Sale Id 296 for 25.00 KG of Cooking Gas @ N736.00','2023-03-10 12:52:46','',''),('4','283',570,'','6.1','4',0.00,18400.00,'Retail Sale Id 296 for retail product','2023-03-10 12:52:46','',''),('4','283',571,'','20','3',2200.00,0.00,'Retail Sale Id 297 for 2.99 KG of Cooking Gas @ N736.00','2023-03-10 12:57:40','',''),('4','283',572,'','6.1','4',0.00,2200.00,'Retail Sale Id 297 for retail product','2023-03-10 12:57:40','',''),('4','283',573,'','20','3',3000.00,0.00,'Retail Sale Id 298 for 4.08 KG of Cooking Gas @ N736.00','2023-03-10 13:08:22','',''),('4','283',574,'','6.1','4',0.00,3000.00,'Retail Sale Id 298 for retail product','2023-03-10 13:08:22','',''),('4','283',575,'','20','3',9200.00,0.00,'Retail Sale Id 300 for 12.50 KG of Cooking Gas @ N736.00','2023-03-10 13:11:01','',''),('4','283',576,'','6.1','4',0.00,9200.00,'Retail Sale Id 300 for retail product','2023-03-10 13:11:01','',''),('4','283',577,'','20','3',35500.00,0.00,'Retail Sale Id 301 for 50.00 KG of Cooking Gas @ N710.00','2023-03-10 13:13:55','',''),('4','283',578,'','6.1','4',0.00,35500.00,'Retail Sale Id 301 for retail product','2023-03-10 13:13:55','',''),('4','283',579,'','20','3',1472.00,0.00,'Retail Sale Id 302 for 2.00 KG of Cooking Gas @ N736.00','2023-03-10 13:15:31','',''),('4','283',580,'','6.1','4',0.00,1472.00,'Retail Sale Id 302 for retail product','2023-03-10 13:15:31','',''),('4','283',581,'','20','3',9200.00,0.00,'Retail Sale Id 303 for 12.50 KG of Cooking Gas @ N736.00','2023-03-10 13:18:36','',''),('4','283',582,'','6.1','4',0.00,9200.00,'Retail Sale Id 303 for retail product','2023-03-10 13:18:36','',''),('4','283',583,'','20','3',4000.00,0.00,'Retail Sale Id 304 for 5.43 KG of Cooking Gas @ N736.00','2023-03-10 13:21:04','',''),('4','283',584,'','6.1','4',0.00,4000.00,'Retail Sale Id 304 for retail product','2023-03-10 13:21:04','',''),('4','283',585,'','20','3',11408.00,0.00,'Retail Sale Id 306 for 15.50 KG of Cooking Gas @ N736.00','2023-03-10 13:23:43','',''),('4','283',586,'','6.1','4',0.00,11408.00,'Retail Sale Id 306 for retail product','2023-03-10 13:23:43','',''),('4','283',587,'','20','3',8832.00,0.00,'Retail Sale Id 307 for 12.00 KG of Cooking Gas @ N736.00','2023-03-10 14:10:30','',''),('4','283',588,'','6.1','4',0.00,8832.00,'Retail Sale Id 307 for retail product','2023-03-10 14:10:30','',''),('4','283',589,'','20','3',2208.00,0.00,'Retail Sale Id 308 for 3.00 KG of Cooking Gas @ N736.00','2023-03-10 14:21:58','',''),('4','283',590,'','6.1','4',0.00,2208.00,'Retail Sale Id 308 for retail product','2023-03-10 14:21:58','',''),('4','283',591,'','20','3',2208.00,0.00,'Retail Sale Id 309 for 3.00 KG of Cooking Gas @ N736.00','2023-03-10 14:23:29','',''),('4','283',592,'','6.1','4',0.00,2208.00,'Retail Sale Id 309 for retail product','2023-03-10 14:23:29','',''),('4','283',593,'','20','3',5000.00,0.00,'Retail Sale Id 310 for 6.79 KG of Cooking Gas @ N736.00','2023-03-10 14:26:14','',''),('4','283',594,'','6.1','4',0.00,5000.00,'Retail Sale Id 310 for retail product','2023-03-10 14:26:14','',''),('4','283',595,'','20','3',4416.00,0.00,'Retail Sale Id 311 for 6.00 KG of Cooking Gas @ N736.00','2023-03-10 14:28:50','',''),('4','283',596,'','6.1','4',0.00,4416.00,'Retail Sale Id 311 for retail product','2023-03-10 14:28:50','',''),('4','283',597,'','20','3',9200.00,0.00,'Retail Sale Id 312 for 12.50 KG of Cooking Gas @ N736.00','2023-03-10 14:47:20','',''),('4','283',598,'','6.1','4',0.00,9200.00,'Retail Sale Id 312 for retail product','2023-03-10 14:47:20','',''),('4','283',599,'','20','3',9200.00,0.00,'Retail Sale Id 313 for 12.50 KG of Cooking Gas @ N736.00','2023-03-10 14:49:07','',''),('4','283',600,'','6.1','4',0.00,9200.00,'Retail Sale Id 313 for retail product','2023-03-10 14:49:07','',''),('4','283',601,'','20','3',11408.00,0.00,'Retail Sale Id 315 for 15.50 KG of Cooking Gas @ N736.00','2023-03-10 14:55:08','',''),('4','283',602,'','6.1','4',0.00,11408.00,'Retail Sale Id 315 for retail product','2023-03-10 14:55:08','',''),('4','283',603,'','20','3',2944.00,0.00,'Retail Sale Id 316 for 4.00 KG of Cooking Gas @ N736.00','2023-03-10 15:06:30','',''),('4','283',604,'','6.1','4',0.00,2944.00,'Retail Sale Id 316 for retail product','2023-03-10 15:06:30','',''),('4','283',605,'','20','3',9200.00,0.00,'Retail Sale Id 318 for 12.50 KG of Cooking Gas @ N736.00','2023-03-10 15:08:06','',''),('4','283',606,'','6.1','4',0.00,9200.00,'Retail Sale Id 318 for retail product','2023-03-10 15:08:06','',''),('4','283',607,'','20','3',2000.00,0.00,'Retail Sale Id 321 for 2.72 KG of Cooking Gas @ N736.00','2023-03-10 15:09:50','',''),('4','283',608,'','6.1','4',0.00,2000.00,'Retail Sale Id 321 for retail product','2023-03-10 15:09:50','',''),('4','283',609,'','20','3',12880.00,0.00,'Retail Sale Id 322 for 17.50 KG of Cooking Gas @ N736.00','2023-03-10 15:47:32','',''),('4','283',610,'','6.1','4',0.00,12880.00,'Retail Sale Id 322 for retail product','2023-03-10 15:47:32','',''),('4','283',611,'','20','3',3680.00,0.00,'Retail Sale Id 324 for 5.00 KG of Cooking Gas @ N736.00','2023-03-10 15:49:24','',''),('4','283',612,'','6.1','4',0.00,3680.00,'Retail Sale Id 324 for retail product','2023-03-10 15:49:24','',''),('4','283',613,'','20','3',4416.00,0.00,'Retail Sale Id 325 for 6.00 KG of Cooking Gas @ N736.00','2023-03-10 15:58:38','',''),('4','283',614,'','6.1','4',0.00,4416.00,'Retail Sale Id 325 for retail product','2023-03-10 15:58:38','',''),('4','283',615,'','20','3',2208.00,0.00,'Retail Sale Id 327 for 3.00 KG of Cooking Gas @ N736.00','2023-03-10 16:15:34','',''),('4','283',616,'','6.1','4',0.00,2208.00,'Retail Sale Id 327 for retail product','2023-03-10 16:15:34','',''),('4','283',617,'','20','3',7360.00,0.00,'Retail Sale Id 329 for 10.00 KG of Cooking Gas @ N736.00','2023-03-10 16:17:37','',''),('4','283',618,'','6.1','4',0.00,7360.00,'Retail Sale Id 329 for retail product','2023-03-10 16:17:37','',''),('4','283',619,'','20','3',2300.00,0.00,'Retail Sale Id 330 for 3.13 KG of Cooking Gas @ N736.00','2023-03-10 16:20:00','',''),('4','283',620,'','6.1','4',0.00,2300.00,'Retail Sale Id 330 for retail product','2023-03-10 16:20:00','',''),('4','283',621,'','20','3',8832.00,0.00,'Retail Sale Id 331 for 12.00 KG of Cooking Gas @ N736.00','2023-03-10 16:22:28','',''),('4','283',622,'','6.1','4',0.00,8832.00,'Retail Sale Id 331 for retail product','2023-03-10 16:22:28','',''),('4','283',623,'','20','3',9200.00,0.00,'Retail Sale Id 332 for 12.50 KG of Cooking Gas @ N736.00','2023-03-10 16:23:30','',''),('4','283',624,'','6.1','4',0.00,9200.00,'Retail Sale Id 332 for retail product','2023-03-10 16:23:30','',''),('4','283',625,'','20','3',3680.00,0.00,'Retail Sale Id 333 for 5.00 KG of Cooking Gas @ N736.00','2023-03-10 16:25:00','',''),('4','283',626,'','6.1','4',0.00,3680.00,'Retail Sale Id 333 for retail product','2023-03-10 16:25:00','',''),('4','283',627,'','20','3',9200.00,0.00,'Retail Sale Id 334 for 12.50 KG of Cooking Gas @ N736.00','2023-03-10 16:34:09','',''),('4','283',628,'','6.1','4',0.00,9200.00,'Retail Sale Id 334 for retail product','2023-03-10 16:34:09','',''),('4','283',629,'','20','3',4416.00,0.00,'Retail Sale Id 335 for 6.00 KG of Cooking Gas @ N736.00','2023-03-10 16:38:01','',''),('4','283',630,'','6.1','4',0.00,4416.00,'Retail Sale Id 335 for retail product','2023-03-10 16:38:01','',''),('4','283',631,'','20','3',3000.00,0.00,'Retail Sale Id 336 for 4.08 KG of Cooking Gas @ N736.00','2023-03-10 16:39:31','',''),('4','283',632,'','6.1','4',0.00,3000.00,'Retail Sale Id 336 for retail product','2023-03-10 16:39:31','',''),('4','283',633,'','20','3',35500.00,0.00,'Retail Sale Id 337 for 50.00 KG of Cooking Gas @ N710.00','2023-03-10 17:35:52','',''),('4','283',634,'','6.1','4',0.00,35500.00,'Retail Sale Id 337 for retail product','2023-03-10 17:35:52','',''),('4','283',635,'','20','3',0.00,0.00,'Sales from shift 13 on 2023-03-10 23:09:16 ','2023-03-10 23:09:16','',''),('4','283',636,'','6.1','4',0.00,0.00,'Sales from shift 13 on 2023-03-10 23:09:16 ','2023-03-10 23:09:16','',''),('4','283',637,'','20','3',4416.00,0.00,'Retail Sale Id 339 for 6.00 KG of Cooking Gas @ N736.00','2023-03-11 09:45:10','',''),('4','283',638,'','2','6',0.00,4416.00,'Retail Sale Id 339 for retail product','2023-03-11 09:45:11','',''),('4','283',639,'','20','3',2208.00,0.00,'Retail Sale Id 340 for 3.00 KG of Cooking Gas @ N736.00','2023-03-11 10:54:14','',''),('4','283',640,'','2','6',0.00,2208.00,'Retail Sale Id 340 for retail product','2023-03-11 10:54:14','',''),('4','283',641,'','20','3',2208.00,0.00,'Retail Sale Id 342 for 3.00 KG of Cooking Gas @ N736.00','2023-03-11 10:57:13','',''),('4','283',642,'','2','6',0.00,2208.00,'Retail Sale Id 342 for retail product','2023-03-11 10:57:13','',''),('4','283',643,'','20','3',5300.00,0.00,'Retail Sale Id 344 for 7.20 KG of Cooking Gas @ N736.00','2023-03-11 11:24:42','',''),('4','283',644,'','2','6',0.00,5300.00,'Retail Sale Id 344 for retail product','2023-03-11 11:24:42','',''),('4','283',645,'','20','3',5888.00,0.00,'Retail Sale Id 345 for 8.00 KG of Cooking Gas @ N736.00','2023-03-11 11:27:30','',''),('4','283',646,'','2','6',0.00,5888.00,'Retail Sale Id 345 for retail product','2023-03-11 11:27:30','',''),('4','283',647,'','20','3',1500.00,0.00,'Retail Sale Id 346 for 2.04 KG of Cooking Gas @ N736.00','2023-03-11 11:32:33','',''),('4','283',648,'','2','6',0.00,1500.00,'Retail Sale Id 346 for retail product','2023-03-11 11:32:33','',''),('4','283',649,'','20','3',9200.00,0.00,'Retail Sale Id 347 for 12.50 KG of Cooking Gas @ N736.00','2023-03-11 11:37:08','',''),('4','283',650,'','2','6',0.00,9200.00,'Retail Sale Id 347 for retail product','2023-03-11 11:37:08','',''),('4','283',651,'','20','3',4000.00,0.00,'Retail Sale Id 348 for 5.43 KG of Cooking Gas @ N736.00','2023-03-11 11:40:42','',''),('4','283',652,'','2','6',0.00,4000.00,'Retail Sale Id 348 for retail product','2023-03-11 11:40:42','',''),('4','283',653,'','20','3',2944.00,0.00,'Retail Sale Id 349 for 4.00 KG of Cooking Gas @ N736.00','2023-03-11 11:45:05','',''),('4','283',654,'','2','6',0.00,2944.00,'Retail Sale Id 349 for retail product','2023-03-11 11:45:05','',''),('4','283',655,'','20','3',4416.00,0.00,'Retail Sale Id 350 for 6.00 KG of Cooking Gas @ N736.00','2023-03-11 11:56:01','',''),('4','283',656,'','2','6',0.00,4416.00,'Retail Sale Id 350 for retail product','2023-03-11 11:56:01','',''),('4','283',657,'','20','3',4416.00,0.00,'Retail Sale Id 351 for 6.00 KG of Cooking Gas @ N736.00','2023-03-11 12:02:07','',''),('4','283',658,'','2','6',0.00,4416.00,'Retail Sale Id 351 for retail product','2023-03-11 12:02:07','',''),('4','283',659,'','20','3',1472.00,0.00,'Retail Sale Id 352 for 2.00 KG of Cooking Gas @ N736.00','2023-03-11 12:20:16','',''),('4','283',660,'','2','6',0.00,1472.00,'Retail Sale Id 352 for retail product','2023-03-11 12:20:16','',''),('4','283',661,'','20','3',9200.00,0.00,'Retail Sale Id 353 for 12.50 KG of Cooking Gas @ N736.00','2023-03-11 12:24:31','',''),('4','283',662,'','2','6',0.00,9200.00,'Retail Sale Id 353 for retail product','2023-03-11 12:24:31','',''),('4','283',663,'','20','3',9200.00,0.00,'Retail Sale Id 354 for 12.50 KG of Cooking Gas @ N736.00','2023-03-11 12:26:57','',''),('4','283',664,'','2','6',0.00,9200.00,'Retail Sale Id 354 for retail product','2023-03-11 12:26:57','',''),('4','283',665,'','20','3',1000.00,0.00,'Retail Sale Id 355 for 1.36 KG of Cooking Gas @ N736.00','2023-03-11 12:28:41','',''),('4','283',666,'','2','6',0.00,1000.00,'Retail Sale Id 355 for retail product','2023-03-11 12:28:41','',''),('4','283',667,'','20','3',2208.00,0.00,'Retail Sale Id 356 for 3.00 KG of Cooking Gas @ N736.00','2023-03-11 12:31:43','',''),('4','283',668,'','2','6',0.00,2208.00,'Retail Sale Id 356 for retail product','2023-03-11 12:31:43','',''),('4','283',669,'','20','3',5000.00,0.00,'Retail Sale Id 357 for 6.79 KG of Cooking Gas @ N736.00','2023-03-11 12:34:51','',''),('4','283',670,'','2','6',0.00,5000.00,'Retail Sale Id 357 for retail product','2023-03-11 12:34:51','',''),('4','283',671,'','20','3',736.00,0.00,'Retail Sale Id 358 for 1.00 KG of Cooking Gas @ N736.00','2023-03-11 12:42:26','',''),('4','283',672,'','2','6',0.00,736.00,'Retail Sale Id 358 for retail product','2023-03-11 12:42:26','',''),('4','283',673,'','20','3',3000.00,0.00,'Retail Sale Id 359 for 4.08 KG of Cooking Gas @ N736.00','2023-03-11 12:46:17','',''),('4','283',674,'','2','6',0.00,3000.00,'Retail Sale Id 359 for retail product','2023-03-11 12:46:17','',''),('4','283',675,'','20','3',2208.00,0.00,'Retail Sale Id 360 for 3.00 KG of Cooking Gas @ N736.00','2023-03-11 12:52:33','',''),('4','283',676,'','2','6',0.00,2208.00,'Retail Sale Id 360 for retail product','2023-03-11 12:52:33','',''),('4','283',677,'','20','3',9200.00,0.00,'Retail Sale Id 361 for 12.50 KG of Cooking Gas @ N736.00','2023-03-11 12:54:57','',''),('4','283',678,'','2','6',0.00,9200.00,'Retail Sale Id 361 for retail product','2023-03-11 12:54:57','',''),('4','283',679,'','20','3',9568.00,0.00,'Retail Sale Id 362 for 13.00 KG of Cooking Gas @ N736.00','2023-03-11 12:59:39','',''),('4','283',680,'','2','6',0.00,9568.00,'Retail Sale Id 362 for retail product','2023-03-11 12:59:39','',''),('4','283',681,'','20','3',11040.00,0.00,'Retail Sale Id 363 for 15.00 KG of Cooking Gas @ N736.00','2023-03-11 13:02:26','',''),('4','283',682,'','2','6',0.00,11040.00,'Retail Sale Id 363 for retail product','2023-03-11 13:02:26','',''),('4','283',683,'','20','3',35500.00,0.00,'Retail Sale Id 364 for 50.00 KG of Cooking Gas @ N710.00','2023-03-11 13:12:15','',''),('4','283',684,'','2','6',0.00,35500.00,'Retail Sale Id 364 for retail product','2023-03-11 13:12:15','',''),('4','283',685,'','20','3',9200.00,0.00,'Retail Sale Id 365 for 12.50 KG of Cooking Gas @ N736.00','2023-03-11 13:14:20','',''),('4','283',686,'','2','6',0.00,9200.00,'Retail Sale Id 365 for retail product','2023-03-11 13:14:20','',''),('4','283',687,'','20','3',9200.00,0.00,'Retail Sale Id 366 for 12.50 KG of Cooking Gas @ N736.00','2023-03-11 13:17:57','',''),('4','283',688,'','2','6',0.00,9200.00,'Retail Sale Id 366 for retail product','2023-03-11 13:17:58','',''),('4','283',689,'','20','3',9200.00,0.00,'Retail Sale Id 367 for 12.50 KG of Cooking Gas @ N736.00','2023-03-11 13:27:24','',''),('4','283',690,'','2','6',0.00,9200.00,'Retail Sale Id 367 for retail product','2023-03-11 13:27:24','',''),('4','283',691,'','20','3',6624.00,0.00,'Retail Sale Id 368 for 9.00 KG of Cooking Gas @ N736.00','2023-03-11 13:35:32','',''),('4','283',692,'','2','6',0.00,6624.00,'Retail Sale Id 368 for retail product','2023-03-11 13:35:32','',''),('4','283',693,'','20','3',5000.00,0.00,'Retail Sale Id 369 for 6.79 KG of Cooking Gas @ N736.00','2023-03-11 13:44:15','',''),('4','283',694,'','2','6',0.00,5000.00,'Retail Sale Id 369 for retail product','2023-03-11 13:44:15','',''),('4','283',695,'','20','3',1472.00,0.00,'Retail Sale Id 370 for 2.00 KG of Cooking Gas @ N736.00','2023-03-11 13:48:01','',''),('4','283',696,'','2','6',0.00,1472.00,'Retail Sale Id 370 for retail product','2023-03-11 13:48:01','',''),('4','283',697,'','20','3',9200.00,0.00,'Retail Sale Id 371 for 12.50 KG of Cooking Gas @ N736.00','2023-03-11 13:51:32','',''),('4','283',698,'','2','6',0.00,9200.00,'Retail Sale Id 371 for retail product','2023-03-11 13:51:32','',''),('4','283',699,'','20','3',1472.00,0.00,'Retail Sale Id 372 for 2.00 KG of Cooking Gas @ N736.00','2023-03-11 13:57:47','',''),('4','283',700,'','2','6',0.00,1472.00,'Retail Sale Id 372 for retail product','2023-03-11 13:57:47','',''),('4','283',701,'','20','3',2208.00,0.00,'Retail Sale Id 373 for 3.00 KG of Cooking Gas @ N736.00','2023-03-11 14:00:50','',''),('4','283',702,'','2','6',0.00,2208.00,'Retail Sale Id 373 for retail product','2023-03-11 14:00:50','',''),('4','283',703,'','20','3',4416.00,0.00,'Retail Sale Id 375 for 6.00 KG of Cooking Gas @ N736.00','2023-03-11 14:03:35','',''),('4','283',704,'','2','6',0.00,4416.00,'Retail Sale Id 375 for retail product','2023-03-11 14:03:35','',''),('4','283',705,'','20','3',3680.00,0.00,'Retail Sale Id 376 for 5.00 KG of Cooking Gas @ N736.00','2023-03-11 14:05:54','',''),('4','283',706,'','2','6',0.00,3680.00,'Retail Sale Id 376 for retail product','2023-03-11 14:05:54','',''),('4','283',707,'','20','3',8832.00,0.00,'Retail Sale Id 377 for 12.00 KG of Cooking Gas @ N736.00','2023-03-11 14:20:08','',''),('4','283',708,'','2','6',0.00,8832.00,'Retail Sale Id 377 for retail product','2023-03-11 14:20:08','',''),('4','283',709,'','20','3',9200.00,0.00,'Retail Sale Id 378 for 12.50 KG of Cooking Gas @ N736.00','2023-03-11 14:22:21','',''),('4','283',710,'','2','6',0.00,9200.00,'Retail Sale Id 378 for retail product','2023-03-11 14:22:21','',''),('4','283',711,'','20','3',2208.00,0.00,'Retail Sale Id 379 for 3.00 KG of Cooking Gas @ N736.00','2023-03-11 14:25:01','',''),('4','283',712,'','2','6',0.00,2208.00,'Retail Sale Id 379 for retail product','2023-03-11 14:25:01','',''),('4','283',713,'','20','3',9200.00,0.00,'Retail Sale Id 380 for 12.50 KG of Cooking Gas @ N736.00','2023-03-11 14:27:25','',''),('4','283',714,'','2','6',0.00,9200.00,'Retail Sale Id 380 for retail product','2023-03-11 14:27:25','',''),('4','283',715,'','20','3',2130.00,0.00,'Retail Sale Id 381 for 3.00 KG of Cooking Gas @ N710.00','2023-03-11 14:30:48','',''),('4','283',716,'','2','6',0.00,2130.00,'Retail Sale Id 381 for retail product','2023-03-11 14:30:48','',''),('4','283',717,'','20','3',2208.00,0.00,'Retail Sale Id 382 for 3.00 KG of Cooking Gas @ N736.00','2023-03-11 14:33:20','',''),('4','283',718,'','2','6',0.00,2208.00,'Retail Sale Id 382 for retail product','2023-03-11 14:33:20','',''),('4','283',719,'','20','3',2944.00,0.00,'Retail Sale Id 383 for 4.00 KG of Cooking Gas @ N736.00','2023-03-11 14:35:54','',''),('4','283',720,'','2','6',0.00,2944.00,'Retail Sale Id 383 for retail product','2023-03-11 14:35:54','',''),('4','283',721,'','20','3',5152.00,0.00,'Retail Sale Id 384 for 7.00 KG of Cooking Gas @ N736.00','2023-03-11 14:38:39','',''),('4','283',722,'','2','6',0.00,5152.00,'Retail Sale Id 384 for retail product','2023-03-11 14:38:39','',''),('4','283',723,'','20','3',9200.00,0.00,'Retail Sale Id 385 for 12.50 KG of Cooking Gas @ N736.00','2023-03-11 14:42:37','',''),('4','283',724,'','2','6',0.00,9200.00,'Retail Sale Id 385 for retail product','2023-03-11 14:42:37','',''),('4','283',725,'','20','3',9200.00,0.00,'Retail Sale Id 386 for 12.50 KG of Cooking Gas @ N736.00','2023-03-11 14:46:11','',''),('4','283',726,'','2','6',0.00,9200.00,'Retail Sale Id 386 for retail product','2023-03-11 14:46:11','',''),('4','283',727,'','20','3',2000.00,0.00,'Retail Sale Id 387 for 2.72 KG of Cooking Gas @ N736.00','2023-03-11 14:57:22','',''),('4','283',728,'','2','6',0.00,2000.00,'Retail Sale Id 387 for retail product','2023-03-11 14:57:22','',''),('4','283',729,'','20','3',8832.00,0.00,'Retail Sale Id 388 for 12.00 KG of Cooking Gas @ N736.00','2023-03-11 15:00:37','',''),('4','283',730,'','2','6',0.00,8832.00,'Retail Sale Id 388 for retail product','2023-03-11 15:00:37','',''),('4','283',731,'','20','3',7360.00,0.00,'Retail Sale Id 389 for 10.00 KG of Cooking Gas @ N736.00','2023-03-11 15:12:40','',''),('4','283',732,'','2','6',0.00,7360.00,'Retail Sale Id 389 for retail product','2023-03-11 15:12:40','',''),('4','283',733,'','20','3',9200.00,0.00,'Retail Sale Id 390 for 12.50 KG of Cooking Gas @ N736.00','2023-03-11 15:22:44','',''),('4','283',734,'','2','6',0.00,9200.00,'Retail Sale Id 390 for retail product','2023-03-11 15:22:44','',''),('4','283',735,'','20','3',4416.00,0.00,'Retail Sale Id 391 for 6.00 KG of Cooking Gas @ N736.00','2023-03-11 15:34:14','',''),('4','283',736,'','2','6',0.00,4416.00,'Retail Sale Id 391 for retail product','2023-03-11 15:34:14','',''),('4','283',737,'','20','3',4416.00,0.00,'Retail Sale Id 392 for 6.00 KG of Cooking Gas @ N736.00','2023-03-11 15:41:50','',''),('4','283',738,'','2','6',0.00,4416.00,'Retail Sale Id 392 for retail product','2023-03-11 15:41:50','',''),('4','283',739,'','20','3',2944.00,0.00,'Retail Sale Id 393 for 4.00 KG of Cooking Gas @ N736.00','2023-03-11 15:44:23','',''),('4','283',740,'','2','6',0.00,2944.00,'Retail Sale Id 393 for retail product','2023-03-11 15:44:23','',''),('4','283',741,'','20','3',4400.00,0.00,'Retail Sale Id 394 for 5.98 KG of Cooking Gas @ N736.00','2023-03-11 15:48:20','',''),('4','283',742,'','2','6',0.00,4400.00,'Retail Sale Id 394 for retail product','2023-03-11 15:48:20','',''),('4','283',743,'','20','3',4500.00,0.00,'Retail Sale Id 395 for 6.11 KG of Cooking Gas @ N736.00','2023-03-11 15:50:43','',''),('4','283',744,'','2','6',0.00,4500.00,'Retail Sale Id 395 for retail product','2023-03-11 15:50:43','',''),('4','283',745,'','2','6',0.00,4500.00,'Retail Sale Id 395 for retail product','2023-03-11 15:50:43','',''),('4','283',746,'','20','3',1500.00,0.00,'Retail Sale Id 396 for 2.04 KG of Cooking Gas @ N736.00','2023-03-11 15:52:46','',''),('4','283',747,'','2','6',0.00,1500.00,'Retail Sale Id 396 for retail product','2023-03-11 15:52:46','',''),('4','283',748,'','20','3',3680.00,0.00,'Retail Sale Id 397 for 5.00 KG of Cooking Gas @ N736.00','2023-03-11 15:55:06','',''),('4','283',749,'','2','6',0.00,3680.00,'Retail Sale Id 397 for retail product','2023-03-11 15:55:06','',''),('4','283',750,'','20','3',3680.00,0.00,'Retail Sale Id 398 for 5.00 KG of Cooking Gas @ N736.00','2023-03-11 15:56:50','',''),('4','283',751,'','2','6',0.00,3680.00,'Retail Sale Id 398 for retail product','2023-03-11 15:56:50','',''),('4','283',752,'','20','3',1000.00,0.00,'Retail Sale Id 399 for 1.36 KG of Cooking Gas @ N736.00','2023-03-11 15:59:59','',''),('4','283',753,'','2','6',0.00,1000.00,'Retail Sale Id 399 for retail product','2023-03-11 15:59:59','',''),('4','283',754,'','20','3',8832.00,0.00,'Retail Sale Id 400 for 12.00 KG of Cooking Gas @ N736.00','2023-03-11 16:01:52','',''),('4','283',755,'','2','6',0.00,8832.00,'Retail Sale Id 400 for retail product','2023-03-11 16:01:52','',''),('4','283',756,'','20','3',2208.00,0.00,'Retail Sale Id 401 for 3.00 KG of Cooking Gas @ N736.00','2023-03-11 16:03:59','',''),('4','283',757,'','2','6',0.00,2208.00,'Retail Sale Id 401 for retail product','2023-03-11 16:03:59','',''),('4','283',758,'','20','3',4000.00,0.00,'Retail Sale Id 403 for 5.43 KG of Cooking Gas @ N736.00','2023-03-11 16:09:33','',''),('4','283',759,'','2','6',0.00,4000.00,'Retail Sale Id 403 for retail product','2023-03-11 16:09:33','',''),('4','283',760,'','20','3',4416.00,0.00,'Retail Sale Id 404 for 6.00 KG of Cooking Gas @ N736.00','2023-03-11 16:18:35','',''),('4','283',761,'','2','6',0.00,4416.00,'Retail Sale Id 404 for retail product','2023-03-11 16:18:35','',''),('4','283',762,'','20','3',8096.00,0.00,'Retail Sale Id 405 for 11.00 KG of Cooking Gas @ N736.00','2023-03-11 16:21:26','',''),('4','283',763,'','2','6',0.00,8096.00,'Retail Sale Id 405 for retail product','2023-03-11 16:21:26','',''),('4','283',764,'','20','3',9200.00,0.00,'Retail Sale Id 406 for 12.50 KG of Cooking Gas @ N736.00','2023-03-11 16:23:23','',''),('4','283',765,'','2','6',0.00,9200.00,'Retail Sale Id 406 for retail product','2023-03-11 16:23:23','',''),('4','283',766,'','20','3',5000.00,0.00,'Retail Sale Id 407 for 6.79 KG of Cooking Gas @ N736.00','2023-03-11 16:28:29','',''),('4','283',767,'','2','6',0.00,5000.00,'Retail Sale Id 407 for retail product','2023-03-11 16:28:29','',''),('4','283',768,'','20','3',3000.00,0.00,'Retail Sale Id 408 for 4.08 KG of Cooking Gas @ N736.00','2023-03-11 16:31:50','',''),('4','283',769,'','2','6',0.00,3000.00,'Retail Sale Id 408 for retail product','2023-03-11 16:31:50','',''),('4','283',770,'','20','3',8832.00,0.00,'Retail Sale Id 409 for 12.00 KG of Cooking Gas @ N736.00','2023-03-11 16:35:26','',''),('4','283',771,'','2','6',0.00,8832.00,'Retail Sale Id 409 for retail product','2023-03-11 16:35:26','',''),('4','283',772,'','20','3',9200.00,0.00,'Retail Sale Id 410 for 12.50 KG of Cooking Gas @ N736.00','2023-03-11 16:39:38','',''),('4','283',773,'','2','6',0.00,9200.00,'Retail Sale Id 410 for retail product','2023-03-11 16:39:38','',''),('4','283',774,'','20','3',9200.00,0.00,'Retail Sale Id 411 for 12.50 KG of Cooking Gas @ N736.00','2023-03-11 16:42:22','',''),('4','283',775,'','2','6',0.00,9200.00,'Retail Sale Id 411 for retail product','2023-03-11 16:42:22','',''),('4','283',776,'','20','3',3680.00,0.00,'Retail Sale Id 412 for 5.00 KG of Cooking Gas @ N736.00','2023-03-11 16:46:15','',''),('4','283',777,'','2','6',0.00,3680.00,'Retail Sale Id 412 for retail product','2023-03-11 16:46:15','',''),('4','283',778,'','20','3',5000.00,0.00,'Retail Sale Id 413 for 6.79 KG of Cooking Gas @ N736.00','2023-03-11 16:48:28','',''),('4','283',779,'','2','6',0.00,5000.00,'Retail Sale Id 413 for retail product','2023-03-11 16:48:28','',''),('4','283',780,'','20','3',8832.00,0.00,'Retail Sale Id 414 for 12.00 KG of Cooking Gas @ N736.00','2023-03-11 16:52:24','',''),('4','283',781,'','2','6',0.00,8832.00,'Retail Sale Id 414 for retail product','2023-03-11 16:52:24','',''),('4','283',782,'','20','3',3680.00,0.00,'Retail Sale Id 415 for 5.00 KG of Cooking Gas @ N736.00','2023-03-11 16:54:48','',''),('4','283',783,'','2','6',0.00,3680.00,'Retail Sale Id 415 for retail product','2023-03-11 16:54:48','',''),('4','283',784,'','20','3',4416.00,0.00,'Retail Sale Id 416 for 6.00 KG of Cooking Gas @ N736.00','2023-03-11 17:03:33','',''),('4','283',785,'','2','6',0.00,4416.00,'Retail Sale Id 416 for retail product','2023-03-11 17:03:33','',''),('4','283',786,'','20','3',4416.00,0.00,'Retail Sale Id 417 for 6.00 KG of Cooking Gas @ N736.00','2023-03-11 17:06:36','',''),('4','283',787,'','2','6',0.00,4416.00,'Retail Sale Id 417 for retail product','2023-03-11 17:06:36','',''),('4','283',788,'','20','3',9200.00,0.00,'Retail Sale Id 418 for 12.50 KG of Cooking Gas @ N736.00','2023-03-11 17:10:18','',''),('4','283',789,'','2','6',0.00,9200.00,'Retail Sale Id 418 for retail product','2023-03-11 17:10:18','',''),('4','283',790,'','20','3',1500.00,0.00,'Retail Sale Id 419 for 2.04 KG of Cooking Gas @ N736.00','2023-03-11 17:14:27','',''),('4','283',791,'','2','6',0.00,1500.00,'Retail Sale Id 419 for retail product','2023-03-11 17:14:27','',''),('4','283',792,'','20','3',2208.00,0.00,'Retail Sale Id 420 for 3.00 KG of Cooking Gas @ N736.00','2023-03-11 17:17:20','',''),('4','283',793,'','2','6',0.00,2208.00,'Retail Sale Id 420 for retail product','2023-03-11 17:17:20','',''),('4','283',794,'','20','3',1472.00,0.00,'Retail Sale Id 421 for 2.00 KG of Cooking Gas @ N736.00','2023-03-11 17:20:14','',''),('4','283',795,'','2','6',0.00,1472.00,'Retail Sale Id 421 for retail product','2023-03-11 17:20:14','',''),('4','283',796,'','20','3',9200.00,0.00,'Retail Sale Id 422 for 12.50 KG of Cooking Gas @ N736.00','2023-03-11 17:22:13','',''),('4','283',797,'','2','6',0.00,9200.00,'Retail Sale Id 422 for retail product','2023-03-11 17:22:13','',''),('4','283',798,'','20','3',9200.00,0.00,'Retail Sale Id 423 for 12.50 KG of Cooking Gas @ N736.00','2023-03-11 17:28:54','',''),('4','283',799,'','2','6',0.00,9200.00,'Retail Sale Id 423 for retail product','2023-03-11 17:28:54','',''),('4','283',800,'','20','3',6624.00,0.00,'Retail Sale Id 424 for 9.00 KG of Cooking Gas @ N736.00','2023-03-11 17:30:51','',''),('4','283',801,'','2','6',0.00,6624.00,'Retail Sale Id 424 for retail product','2023-03-11 17:30:51','',''),('4','283',802,'','20','3',2208.00,0.00,'Retail Sale Id 425 for 3.00 KG of Cooking Gas @ N736.00','2023-03-11 17:35:12','',''),('4','283',803,'','2','6',0.00,2208.00,'Retail Sale Id 425 for retail product','2023-03-11 17:35:12','',''),('4','283',804,'','20','3',9200.00,0.00,'Retail Sale Id 426 for 12.50 KG of Cooking Gas @ N736.00','2023-03-11 17:37:52','',''),('4','283',805,'','2','6',0.00,9200.00,'Retail Sale Id 426 for retail product','2023-03-11 17:37:52','',''),('4','283',806,'','20','3',2944.00,0.00,'Retail Sale Id 427 for 4.00 KG of Cooking Gas @ N736.00','2023-03-11 17:40:38','',''),('4','283',807,'','2','6',0.00,2944.00,'Retail Sale Id 427 for retail product','2023-03-11 17:40:38','',''),('4','283',808,'','20','3',2208.00,0.00,'Retail Sale Id 428 for 3.00 KG of Cooking Gas @ N736.00','2023-03-11 17:43:18','',''),('4','283',809,'','2','6',0.00,2208.00,'Retail Sale Id 428 for retail product','2023-03-11 17:43:18','',''),('4','283',810,'','20','3',2208.00,0.00,'Retail Sale Id 429 for 3.00 KG of Cooking Gas @ N736.00','2023-03-11 17:48:04','',''),('4','283',811,'','2','6',0.00,2208.00,'Retail Sale Id 429 for retail product','2023-03-11 17:48:05','',''),('4','283',812,'','20','3',4416.00,0.00,'Retail Sale Id 430 for 6.00 KG of Cooking Gas @ N736.00','2023-03-11 17:51:53','',''),('4','283',813,'','2','6',0.00,4416.00,'Retail Sale Id 430 for retail product','2023-03-11 17:51:53','',''),('4','283',814,'','20','3',4416.00,0.00,'Retail Sale Id 431 for 6.00 KG of Cooking Gas @ N736.00','2023-03-11 17:57:56','',''),('4','283',815,'','2','6',0.00,4416.00,'Retail Sale Id 431 for retail product','2023-03-11 17:57:56','',''),('4','283',816,'','20','3',0.00,0.00,'Sales from shift 14 on 2023-03-12 10:30:14 ','2023-03-12 10:30:14','',''),('4','283',817,'','6.1','4',0.00,0.00,'Sales from shift 14 on 2023-03-12 10:30:14 ','2023-03-12 10:30:14','',''),('4','283',818,'','20','3',3000.00,0.00,'Retail Sale Id 432 for 4.08 KG of Cooking Gas @ N736.00','2023-03-12 10:35:46','',''),('4','283',819,'','6.1','4',0.00,3000.00,'Retail Sale Id 432 for retail product','2023-03-12 10:35:46','',''),('4','283',820,'','20','3',3000.00,0.00,'Retail Sale Id 433 for 4.08 KG of Cooking Gas @ N736.00','2023-03-12 10:41:28','',''),('4','283',821,'','6.1','4',0.00,3000.00,'Retail Sale Id 433 for retail product','2023-03-12 10:41:28','',''),('4','283',822,'','20','3',3680.00,0.00,'Retail Sale Id 435 for 5.00 KG of Cooking Gas @ N736.00','2023-03-12 10:43:41','',''),('4','283',823,'','6.1','4',0.00,3680.00,'Retail Sale Id 435 for retail product','2023-03-12 10:43:41','',''),('4','283',824,'','6.1','4',0.00,3680.00,'Retail Sale Id 435 for retail product','2023-03-12 10:43:41','',''),('4','283',825,'','20','3',2208.00,0.00,'Retail Sale Id 436 for 3.00 KG of Cooking Gas @ N736.00','2023-03-12 10:48:38','',''),('4','283',826,'','6.1','4',0.00,2208.00,'Retail Sale Id 436 for retail product','2023-03-12 10:48:38','',''),('4','283',827,'','6.1','4',0.00,2208.00,'Retail Sale Id 436 for retail product','2023-03-12 10:48:38','',''),('4','283',828,'','20','3',9200.00,0.00,'Retail Sale Id 437 for 12.50 KG of Cooking Gas @ N736.00','2023-03-12 11:05:29','',''),('4','283',829,'','6.1','4',0.00,9200.00,'Retail Sale Id 437 for retail product','2023-03-12 11:05:29','',''),('4','283',830,'','20','3',3680.00,0.00,'Retail Sale Id 438 for 5.00 KG of Cooking Gas @ N736.00','2023-03-12 11:06:57','',''),('4','283',831,'','6.1','4',0.00,3680.00,'Retail Sale Id 438 for retail product','2023-03-12 11:06:57','',''),('4','283',832,'','20','3',4416.00,0.00,'Retail Sale Id 440 for 6.00 KG of Cooking Gas @ N736.00','2023-03-12 11:08:27','',''),('4','283',833,'','6.1','4',0.00,4416.00,'Retail Sale Id 440 for retail product','2023-03-12 11:08:27','',''),('4','283',834,'','20','3',9200.00,0.00,'Retail Sale Id 441 for 12.50 KG of Cooking Gas @ N736.00','2023-03-12 11:10:19','',''),('4','283',835,'','6.1','4',0.00,9200.00,'Retail Sale Id 441 for retail product','2023-03-12 11:10:19','',''),('4','283',836,'','20','3',7500.00,0.00,'Retail Sale Id 442 for 10.19 KG of Cooking Gas @ N736.00','2023-03-12 11:13:00','',''),('4','283',837,'','6.1','4',0.00,7500.00,'Retail Sale Id 442 for retail product','2023-03-12 11:13:00','',''),('4','283',838,'','20','3',8832.00,0.00,'Retail Sale Id 443 for 12.00 KG of Cooking Gas @ N736.00','2023-03-12 11:14:49','',''),('4','283',839,'','6.1','4',0.00,8832.00,'Retail Sale Id 443 for retail product','2023-03-12 11:14:49','',''),('4','283',840,'','6.1','4',0.00,8832.00,'Retail Sale Id 443 for retail product','2023-03-12 11:14:49','',''),('4','283',841,'','20','3',2208.00,0.00,'Retail Sale Id 444 for 3.00 KG of Cooking Gas @ N736.00','2023-03-12 11:16:16','',''),('4','283',842,'','6.1','4',0.00,2208.00,'Retail Sale Id 444 for retail product','2023-03-12 11:16:16','',''),('4','283',843,'','20','3',9200.00,0.00,'Retail Sale Id 445 for 12.50 KG of Cooking Gas @ N736.00','2023-03-12 11:27:06','',''),('4','283',844,'','6.1','4',0.00,9200.00,'Retail Sale Id 445 for retail product','2023-03-12 11:27:06','',''),('4','283',845,'','20','3',4416.00,0.00,'Retail Sale Id 446 for 6.00 KG of Cooking Gas @ N736.00','2023-03-12 11:31:39','',''),('4','283',846,'','6.1','4',0.00,4416.00,'Retail Sale Id 446 for retail product','2023-03-12 11:31:39','',''),('4','283',847,'','6.1','4',0.00,4416.00,'Retail Sale Id 446 for retail product','2023-03-12 11:31:39','',''),('4','283',848,'','20','3',1500.00,0.00,'Retail Sale Id 447 for 2.04 KG of Cooking Gas @ N736.00','2023-03-12 11:33:50','',''),('4','283',849,'','6.1','4',0.00,1500.00,'Retail Sale Id 447 for retail product','2023-03-12 11:33:50','',''),('4','283',850,'','20','3',1472.00,0.00,'Retail Sale Id 451 for 2.00 KG of Cooking Gas @ N736.00','2023-03-12 11:38:59','',''),('4','283',851,'','6.1','4',0.00,1472.00,'Retail Sale Id 451 for retail product','2023-03-12 11:38:59','',''),('4','283',852,'','20','3',2208.00,0.00,'Retail Sale Id 452 for 3.00 KG of Cooking Gas @ N736.00','2023-03-12 11:40:26','',''),('4','283',853,'','6.1','4',0.00,2208.00,'Retail Sale Id 452 for retail product','2023-03-12 11:40:26','',''),('4','283',854,'','20','3',9200.00,0.00,'Retail Sale Id 454 for 12.50 KG of Cooking Gas @ N736.00','2023-03-12 11:42:57','',''),('4','283',855,'','6.1','4',0.00,9200.00,'Retail Sale Id 454 for retail product','2023-03-12 11:42:57','',''),('4','283',856,'','20','3',1000.00,0.00,'Retail Sale Id 455 for 1.36 KG of Cooking Gas @ N736.00','2023-03-12 11:45:20','',''),('4','283',857,'','6.1','4',0.00,1000.00,'Retail Sale Id 455 for retail product','2023-03-12 11:45:20','',''),('4','283',858,'','6.1','4',0.00,1000.00,'Retail Sale Id 455 for retail product','2023-03-12 11:45:20','',''),('4','283',859,'','20','3',2944.00,0.00,'Retail Sale Id 456 for 4.00 KG of Cooking Gas @ N736.00','2023-03-12 11:47:03','',''),('4','283',860,'','6.1','4',0.00,2944.00,'Retail Sale Id 456 for retail product','2023-03-12 11:47:03','',''),('4','283',861,'','20','3',11776.00,0.00,'Retail Sale Id 459 for 16.00 KG of Cooking Gas @ N736.00','2023-03-12 11:52:39','',''),('4','283',862,'','6.1','4',0.00,11776.00,'Retail Sale Id 459 for retail product','2023-03-12 11:52:39','',''),('4','283',863,'','20','3',8000.00,0.00,'Retail Sale Id 461 for 10.87 KG of Cooking Gas @ N736.00','2023-03-12 11:55:39','',''),('4','283',864,'','6.1','4',0.00,8000.00,'Retail Sale Id 461 for retail product','2023-03-12 11:55:39','',''),('4','283',865,'','20','3',9200.00,0.00,'Retail Sale Id 462 for 12.50 KG of Cooking Gas @ N736.00','2023-03-12 12:01:27','',''),('4','283',866,'','6.1','4',0.00,9200.00,'Retail Sale Id 462 for retail product','2023-03-12 12:01:27','',''),('4','283',867,'','20','3',1500.00,0.00,'Retail Sale Id 463 for 2.04 KG of Cooking Gas @ N736.00','2023-03-12 12:04:30','',''),('4','283',868,'','6.1','4',0.00,1500.00,'Retail Sale Id 463 for retail product','2023-03-12 12:04:30','',''),('4','283',869,'','6.1','4',0.00,1500.00,'Retail Sale Id 463 for retail product','2023-03-12 12:04:30','',''),('4','283',870,'','6.1','4',0.00,1500.00,'Retail Sale Id 463 for retail product','2023-03-12 12:04:30','',''),('4','283',871,'','20','3',7360.00,0.00,'Retail Sale Id 465 for 10.00 KG of Cooking Gas @ N736.00','2023-03-12 12:06:27','',''),('4','283',872,'','6.1','4',0.00,7360.00,'Retail Sale Id 465 for retail product','2023-03-12 12:06:27','',''),('4','283',873,'','20','3',4416.00,0.00,'Retail Sale Id 466 for 6.00 KG of Cooking Gas @ N736.00','2023-03-12 12:08:01','',''),('4','283',874,'','6.1','4',0.00,4416.00,'Retail Sale Id 466 for retail product','2023-03-12 12:08:01','',''),('4','283',875,'','20','3',3680.00,0.00,'Retail Sale Id 468 for 5.00 KG of Cooking Gas @ N736.00','2023-03-12 12:09:45','',''),('4','283',876,'','6.1','4',0.00,3680.00,'Retail Sale Id 468 for retail product','2023-03-12 12:09:45','',''),('4','283',877,'','20','3',8832.00,0.00,'Retail Sale Id 469 for 12.00 KG of Cooking Gas @ N736.00','2023-03-12 12:11:16','',''),('4','283',878,'','6.1','4',0.00,8832.00,'Retail Sale Id 469 for retail product','2023-03-12 12:11:16','',''),('4','283',879,'','20','3',2208.00,0.00,'Retail Sale Id 471 for 3.00 KG of Cooking Gas @ N736.00','2023-03-12 12:13:17','',''),('4','283',880,'','6.1','4',0.00,2208.00,'Retail Sale Id 471 for retail product','2023-03-12 12:13:17','',''),('4','283',881,'','20','3',4416.00,0.00,'Retail Sale Id 472 for 6.00 KG of Cooking Gas @ N736.00','2023-03-12 12:17:19','',''),('4','283',882,'','6.1','4',0.00,4416.00,'Retail Sale Id 472 for retail product','2023-03-12 12:17:19','',''),('4','283',883,'','6.1','4',0.00,4416.00,'Retail Sale Id 472 for retail product','2023-03-12 12:17:19','',''),('4','283',884,'','20','3',1400.00,0.00,'Retail Sale Id 474 for 1.90 KG of Cooking Gas @ N736.00','2023-03-12 12:21:28','',''),('4','283',885,'','6.1','4',0.00,1400.00,'Retail Sale Id 474 for retail product','2023-03-12 12:21:28','',''),('4','283',886,'','20','3',12144.00,0.00,'Retail Sale Id 475 for 16.50 KG of Cooking Gas @ N736.00','2023-03-12 12:26:36','',''),('4','283',887,'','6.1','4',0.00,12144.00,'Retail Sale Id 475 for retail product','2023-03-12 12:26:36','',''),('4','283',888,'','6.1','4',0.00,12144.00,'Retail Sale Id 475 for retail product','2023-03-12 12:26:36','',''),('4','283',889,'','20','3',2200.00,0.00,'Retail Sale Id 476 for 2.99 KG of Cooking Gas @ N736.00','2023-03-12 12:28:16','',''),('4','283',890,'','6.1','4',0.00,2200.00,'Retail Sale Id 476 for retail product','2023-03-12 12:28:16','',''),('4','283',891,'','6.1','4',0.00,2200.00,'Retail Sale Id 476 for retail product','2023-03-12 12:28:16','',''),('4','283',892,'','20','3',3000.00,0.00,'Retail Sale Id 479 for 4.08 KG of Cooking Gas @ N736.00','2023-03-12 12:31:54','',''),('4','283',893,'','6.1','4',0.00,3000.00,'Retail Sale Id 479 for retail product','2023-03-12 12:31:54','',''),('4','283',894,'','6.1','4',0.00,3000.00,'Retail Sale Id 479 for retail product','2023-03-12 12:31:54','',''),('4','283',895,'','20','3',4416.00,0.00,'Retail Sale Id 480 for 6.00 KG of Cooking Gas @ N736.00','2023-03-12 12:33:21','',''),('4','283',896,'','6.1','4',0.00,4416.00,'Retail Sale Id 480 for retail product','2023-03-12 12:33:21','',''),('4','283',897,'','20','3',9568.00,0.00,'Retail Sale Id 481 for 13.00 KG of Cooking Gas @ N736.00','2023-03-12 12:36:12','',''),('4','283',898,'','6.1','4',0.00,9568.00,'Retail Sale Id 481 for retail product','2023-03-12 12:36:12','',''),('4','283',899,'','6.1','4',0.00,9568.00,'Retail Sale Id 481 for retail product','2023-03-12 12:36:12','',''),('4','283',900,'','20','3',4416.00,0.00,'Retail Sale Id 483 for 6.00 KG of Cooking Gas @ N736.00','2023-03-12 12:37:13','',''),('4','283',901,'','6.1','4',0.00,4416.00,'Retail Sale Id 483 for retail product','2023-03-12 12:37:13','',''),('4','283',902,'','6.1','4',0.00,4416.00,'Retail Sale Id 483 for retail product','2023-03-12 12:37:13','',''),('4','283',903,'','20','3',8832.00,0.00,'Retail Sale Id 484 for 12.00 KG of Cooking Gas @ N736.00','2023-03-12 12:38:45','',''),('4','283',904,'','6.1','4',0.00,8832.00,'Retail Sale Id 484 for retail product','2023-03-12 12:38:45','',''),('4','283',905,'','20','3',4416.00,0.00,'Retail Sale Id 487 for 6.00 KG of Cooking Gas @ N736.00','2023-03-12 12:40:46','',''),('4','283',906,'','6.1','4',0.00,4416.00,'Retail Sale Id 487 for retail product','2023-03-12 12:40:46','',''),('4','283',907,'','20','3',9200.00,0.00,'Retail Sale Id 489 for 12.50 KG of Cooking Gas @ N736.00','2023-03-12 12:47:56','',''),('4','283',908,'','6.1','4',0.00,9200.00,'Retail Sale Id 489 for retail product','2023-03-12 12:47:56','',''),('4','283',909,'','20','3',8832.00,0.00,'Retail Sale Id 490 for 12.00 KG of Cooking Gas @ N736.00','2023-03-12 12:50:00','',''),('4','283',910,'','6.1','4',0.00,8832.00,'Retail Sale Id 490 for retail product','2023-03-12 12:50:00','',''),('4','283',911,'','6.1','4',0.00,8832.00,'Retail Sale Id 490 for retail product','2023-03-12 12:50:00','',''),('4','283',912,'','6.1','4',0.00,8832.00,'Retail Sale Id 490 for retail product','2023-03-12 12:50:00','',''),('4','283',913,'','20','3',13616.00,0.00,'Retail Sale Id 491 for 18.50 KG of Cooking Gas @ N736.00','2023-03-12 12:54:52','',''),('4','283',914,'','6.1','4',0.00,13616.00,'Retail Sale Id 491 for retail product','2023-03-12 12:54:52','',''),('4','283',915,'','20','3',9200.00,0.00,'Retail Sale Id 492 for 12.50 KG of Cooking Gas @ N736.00','2023-03-12 12:57:10','',''),('4','283',916,'','6.1','4',0.00,9200.00,'Retail Sale Id 492 for retail product','2023-03-12 12:57:10','',''),('4','283',917,'','20','3',2208.00,0.00,'Retail Sale Id 493 for 3.00 KG of Cooking Gas @ N736.00','2023-03-12 12:59:48','',''),('4','283',918,'','6.1','4',0.00,2208.00,'Retail Sale Id 493 for retail product','2023-03-12 12:59:48','',''),('4','283',919,'','20','3',2000.00,0.00,'Retail Sale Id 495 for 2.72 KG of Cooking Gas @ N736.00','2023-03-12 13:07:38','',''),('4','283',920,'','2','6',0.00,2000.00,'Retail Sale Id 495 for retail product','2023-03-12 13:07:38','',''),('4','283',921,'','20','3',6624.00,0.00,'Retail Sale Id 496 for 9.00 KG of Cooking Gas @ N736.00','2023-03-12 13:11:55','',''),('4','283',922,'','2','6',0.00,6624.00,'Retail Sale Id 496 for retail product','2023-03-12 13:11:55','',''),('4','283',923,'','20','3',2208.00,0.00,'Retail Sale Id 497 for 3.00 KG of Cooking Gas @ N736.00','2023-03-12 13:14:45','',''),('4','283',924,'','2','6',0.00,2208.00,'Retail Sale Id 497 for retail product','2023-03-12 13:14:45','',''),('4','283',925,'','20','3',6000.00,0.00,'Retail Sale Id 499 for 8.15 KG of Cooking Gas @ N736.00','2023-03-12 13:17:15','',''),('4','283',926,'','2','6',0.00,6000.00,'Retail Sale Id 499 for retail product','2023-03-12 13:17:15','',''),('4','283',927,'','20','3',3680.00,0.00,'Retail Sale Id 500 for 5.00 KG of Cooking Gas @ N736.00','2023-03-12 13:19:47','',''),('4','283',928,'','2','6',0.00,3680.00,'Retail Sale Id 500 for retail product','2023-03-12 13:19:47','',''),('4','283',929,'','20','3',5888.00,0.00,'Retail Sale Id 501 for 8.00 KG of Cooking Gas @ N736.00','2023-03-12 13:22:34','',''),('4','283',930,'','2','6',0.00,5888.00,'Retail Sale Id 501 for retail product','2023-03-12 13:22:34','',''),('4','283',931,'','20','3',4416.00,0.00,'Retail Sale Id 504 for 6.00 KG of Cooking Gas @ N736.00','2023-03-12 13:26:05','',''),('4','283',932,'','2','6',0.00,4416.00,'Retail Sale Id 504 for retail product','2023-03-12 13:26:05','',''),('4','283',933,'','20','3',17750.00,0.00,'Retail Sale Id 505 for 25.00 KG of Cooking Gas @ N710.00','2023-03-12 13:32:48','',''),('4','283',934,'','2','6',0.00,17750.00,'Retail Sale Id 505 for retail product','2023-03-12 13:32:48','',''),('4','283',935,'','20','3',44020.00,0.00,'Retail Sale Id 508 for 62.00 KG of Cooking Gas @ N710.00','2023-03-12 13:45:23','',''),('4','283',936,'','2','6',0.00,44020.00,'Retail Sale Id 508 for retail product','2023-03-12 13:45:23','',''),('4','283',937,'','20','3',1472.00,0.00,'Retail Sale Id 509 for 2.00 KG of Cooking Gas @ N736.00','2023-03-12 14:09:31','',''),('4','283',938,'','2','6',0.00,1472.00,'Retail Sale Id 509 for retail product','2023-03-12 14:09:31','',''),('4','283',939,'','20','3',2208.00,0.00,'Retail Sale Id 510 for 3.00 KG of Cooking Gas @ N736.00','2023-03-12 14:11:38','',''),('4','283',940,'','2','6',0.00,2208.00,'Retail Sale Id 510 for retail product','2023-03-12 14:11:38','',''),('4','283',941,'','20','3',736.00,0.00,'Retail Sale Id 511 for 1.00 KG of Cooking Gas @ N736.00','2023-03-12 14:14:41','',''),('4','283',942,'','2','6',0.00,736.00,'Retail Sale Id 511 for retail product','2023-03-12 14:14:41','',''),('4','283',943,'','20','3',9200.00,0.00,'Retail Sale Id 512 for 12.50 KG of Cooking Gas @ N736.00','2023-03-12 14:22:28','',''),('4','283',944,'','2','6',0.00,9200.00,'Retail Sale Id 512 for retail product','2023-03-12 14:22:28','',''),('4','283',945,'','20','3',1472.00,0.00,'Retail Sale Id 513 for 2.00 KG of Cooking Gas @ N736.00','2023-03-12 14:26:39','',''),('4','283',946,'','2','6',0.00,1472.00,'Retail Sale Id 513 for retail product','2023-03-12 14:26:39','',''),('4','283',947,'','20','3',736.00,0.00,'Retail Sale Id 514 for 1.00 KG of Cooking Gas @ N736.00','2023-03-12 14:29:56','',''),('4','283',948,'','6.1','4',0.00,736.00,'Retail Sale Id 514 for retail product','2023-03-12 14:29:56','',''),('4','283',949,'','20','3',4416.00,0.00,'Retail Sale Id 515 for 6.00 KG of Cooking Gas @ N736.00','2023-03-12 14:52:22','',''),('4','283',950,'','2','6',0.00,4416.00,'Retail Sale Id 515 for retail product','2023-03-12 14:52:22','',''),('4','283',951,'','20','3',2000.00,0.00,'Retail Sale Id 516 for 2.72 KG of Cooking Gas @ N736.00','2023-03-12 15:22:55','',''),('4','283',952,'','2','6',0.00,2000.00,'Retail Sale Id 516 for retail product','2023-03-12 15:22:55','',''),('4','283',953,'','20','3',7400.00,0.00,'Retail Sale Id 518 for 10.05 KG of Cooking Gas @ N736.00','2023-03-12 15:26:39','',''),('4','283',954,'','6.1','4',0.00,7400.00,'Retail Sale Id 518 for retail product','2023-03-12 15:26:39','',''),('4','283',955,'','20','3',9200.00,0.00,'Retail Sale Id 519 for 12.50 KG of Cooking Gas @ N736.00','2023-03-12 15:29:03','',''),('4','283',956,'','2','6',0.00,9200.00,'Retail Sale Id 519 for retail product','2023-03-12 15:29:03','',''),('4','283',957,'','20','3',2000.00,0.00,'Retail Sale Id 520 for 2.72 KG of Cooking Gas @ N736.00','2023-03-12 15:30:56','',''),('4','283',958,'','2','6',0.00,2000.00,'Retail Sale Id 520 for retail product','2023-03-12 15:30:56','',''),('4','283',959,'','20','3',4416.00,0.00,'Retail Sale Id 523 for 6.00 KG of Cooking Gas @ N736.00','2023-03-12 15:40:53','',''),('4','283',960,'','2','6',0.00,4416.00,'Retail Sale Id 523 for retail product','2023-03-12 15:40:53','',''),('4','283',961,'','20','3',2208.00,0.00,'Retail Sale Id 525 for 3.00 KG of Cooking Gas @ N736.00','2023-03-12 15:42:42','',''),('4','283',962,'','2','6',0.00,2208.00,'Retail Sale Id 525 for retail product','2023-03-12 15:42:42','',''),('4','283',963,'','20','3',4416.00,0.00,'Retail Sale Id 526 for 6.00 KG of Cooking Gas @ N736.00','2023-03-12 15:44:48','',''),('4','283',964,'','2','6',0.00,4416.00,'Retail Sale Id 526 for retail product','2023-03-12 15:44:48','',''),('4','283',965,'','20','3',1472.00,0.00,'Retail Sale Id 527 for 2.00 KG of Cooking Gas @ N736.00','2023-03-12 15:54:24','',''),('4','283',966,'','2','6',0.00,1472.00,'Retail Sale Id 527 for retail product','2023-03-12 15:54:24','',''),('4','283',967,'','20','3',3680.00,0.00,'Retail Sale Id 528 for 5.00 KG of Cooking Gas @ N736.00','2023-03-12 16:03:25','',''),('4','283',968,'','2','6',0.00,3680.00,'Retail Sale Id 528 for retail product','2023-03-12 16:03:25','',''),('4','283',969,'','20','3',4416.00,0.00,'Retail Sale Id 529 for 6.00 KG of Cooking Gas @ N736.00','2023-03-12 16:05:18','',''),('4','283',970,'','2','6',0.00,4416.00,'Retail Sale Id 529 for retail product','2023-03-12 16:05:18','',''),('4','283',971,'','20','3',9200.00,0.00,'Retail Sale Id 531 for 12.50 KG of Cooking Gas @ N736.00','2023-03-12 16:20:54','',''),('4','283',972,'','2','6',0.00,9200.00,'Retail Sale Id 531 for retail product','2023-03-12 16:20:54','',''),('4','283',973,'','20','3',4416.00,0.00,'Retail Sale Id 532 for 6.00 KG of Cooking Gas @ N736.00','2023-03-12 16:30:18','',''),('4','283',974,'','2','6',0.00,4416.00,'Retail Sale Id 532 for retail product','2023-03-12 16:30:18','',''),('4','283',975,'','20','3',8875.00,0.00,'Retail Sale Id 533 for 12.50 KG of Cooking Gas @ N710.00','2023-03-12 16:33:33','',''),('4','283',976,'','2','6',0.00,8875.00,'Retail Sale Id 533 for retail product','2023-03-12 16:33:33','',''),('4','283',977,'','20','3',4000.00,0.00,'Retail Sale Id 534 for 5.43 KG of Cooking Gas @ N736.00','2023-03-12 16:37:04','',''),('4','283',978,'','2','6',0.00,4000.00,'Retail Sale Id 534 for retail product','2023-03-12 16:37:04','',''),('4','283',979,'','20','3',9200.00,0.00,'Retail Sale Id 535 for 12.50 KG of Cooking Gas @ N736.00','2023-03-12 16:41:07','',''),('4','283',980,'','2','6',0.00,9200.00,'Retail Sale Id 535 for retail product','2023-03-12 16:41:07','',''),('4','283',981,'','20','3',0.00,0.00,'Sales from shift 15 on 2023-03-13 08:11:26 ','2023-03-13 08:11:26','',''),('4','283',982,'','6.1','4',0.00,0.00,'Sales from shift 15 on 2023-03-13 08:11:26 ','2023-03-13 08:11:26','',''),('4','283',983,'','20','3',40825.00,0.00,'Retail Sale Id 536 for 57.50 KG of Cooking Gas @ N710.00','2023-03-13 08:21:46','',''),('4','283',984,'','6.1','4',0.00,40825.00,'Retail Sale Id 536 for retail product','2023-03-13 08:21:46','',''),('4','283',985,'','20','3',9200.00,0.00,'Retail Sale Id 537 for 12.50 KG of Cooking Gas @ N736.00','2023-03-13 08:23:47','',''),('4','283',986,'','6.1','4',0.00,9200.00,'Retail Sale Id 537 for retail product','2023-03-13 08:23:47','',''),('4','283',987,'','20','3',4000.00,0.00,'Retail Sale Id 538 for 5.43 KG of Cooking Gas @ N736.00','2023-03-13 08:25:37','',''),('4','283',988,'','6.1','4',0.00,4000.00,'Retail Sale Id 538 for retail product','2023-03-13 08:25:37','',''),('4','283',989,'','20','3',3550.00,0.00,'Retail Sale Id 540 for 5.00 KG of Cooking Gas @ N710.00','2023-03-13 08:29:22','',''),('4','283',990,'','6.1','4',0.00,3550.00,'Retail Sale Id 540 for retail product','2023-03-13 08:29:22','',''),('4','283',991,'','20','3',6624.00,0.00,'Retail Sale Id 541 for 9.00 KG of Cooking Gas @ N736.00','2023-03-13 08:32:43','',''),('4','283',992,'','6.1','4',0.00,6624.00,'Retail Sale Id 541 for retail product','2023-03-13 08:32:43','',''),('4','283',993,'','20','3',3680.00,0.00,'Retail Sale Id 542 for 5.00 KG of Cooking Gas @ N736.00','2023-03-13 08:34:05','',''),('4','283',994,'','6.1','4',0.00,3680.00,'Retail Sale Id 542 for retail product','2023-03-13 08:34:05','',''),('4','283',995,'','20','3',5152.00,0.00,'Retail Sale Id 544 for 7.00 KG of Cooking Gas @ N736.00','2023-03-13 08:35:35','',''),('4','283',996,'','6.1','4',0.00,5152.00,'Retail Sale Id 544 for retail product','2023-03-13 08:35:35','',''),('4','283',997,'','6.1','4',0.00,5152.00,'Retail Sale Id 544 for retail product','2023-03-13 08:35:35','',''),('4','283',998,'','20','3',9200.00,0.00,'Retail Sale Id 545 for 12.50 KG of Cooking Gas @ N736.00','2023-03-13 08:37:14','',''),('4','283',999,'','6.1','4',0.00,9200.00,'Retail Sale Id 545 for retail product','2023-03-13 08:37:14','',''),('4','283',1000,'','6.1','4',0.00,9200.00,'Retail Sale Id 545 for retail product','2023-03-13 08:37:14','',''),('4','283',1001,'','20','3',736.00,0.00,'Retail Sale Id 547 for 1.00 KG of Cooking Gas @ N736.00','2023-03-13 08:40:04','',''),('4','283',1002,'','6.1','4',0.00,736.00,'Retail Sale Id 547 for retail product','2023-03-13 08:40:04','',''),('4','283',1003,'','20','3',1000.00,0.00,'Retail Sale Id 548 for 1.36 KG of Cooking Gas @ N736.00','2023-03-13 08:41:38','',''),('4','283',1004,'','6.1','4',0.00,1000.00,'Retail Sale Id 548 for retail product','2023-03-13 08:41:38','',''),('4','283',1005,'','20','3',12880.00,0.00,'Retail Sale Id 549 for 17.50 KG of Cooking Gas @ N736.00','2023-03-13 08:45:21','',''),('4','283',1006,'','6.1','4',0.00,12880.00,'Retail Sale Id 549 for retail product','2023-03-13 08:45:21','',''),('4','283',1007,'','20','3',2208.00,0.00,'Retail Sale Id 550 for 3.00 KG of Cooking Gas @ N736.00','2023-03-13 08:46:40','',''),('4','283',1008,'','6.1','4',0.00,2208.00,'Retail Sale Id 550 for retail product','2023-03-13 08:46:40','',''),('4','283',1009,'','20','3',4416.00,0.00,'Retail Sale Id 551 for 6.00 KG of Cooking Gas @ N736.00','2023-03-13 08:48:25','',''),('4','283',1010,'','6.1','4',0.00,4416.00,'Retail Sale Id 551 for retail product','2023-03-13 08:48:25','',''),('4','283',1011,'','20','3',2208.00,0.00,'Retail Sale Id 552 for 3.00 KG of Cooking Gas @ N736.00','2023-03-13 08:49:50','',''),('4','283',1012,'','6.1','4',0.00,2208.00,'Retail Sale Id 552 for retail product','2023-03-13 08:49:50','',''),('4','283',1013,'','20','3',8832.00,0.00,'Retail Sale Id 553 for 12.00 KG of Cooking Gas @ N736.00','2023-03-13 08:51:05','',''),('4','283',1014,'','6.1','4',0.00,8832.00,'Retail Sale Id 553 for retail product','2023-03-13 08:51:05','',''),('4','283',1015,'','20','3',2208.00,0.00,'Retail Sale Id 554 for 3.00 KG of Cooking Gas @ N736.00','2023-03-13 08:52:54','',''),('4','283',1016,'','6.1','4',0.00,2208.00,'Retail Sale Id 554 for retail product','2023-03-13 08:52:54','',''),('4','283',1017,'','20','3',5888.00,0.00,'Retail Sale Id 555 for 8.00 KG of Cooking Gas @ N736.00','2023-03-13 08:55:07','',''),('4','283',1018,'','6.1','4',0.00,5888.00,'Retail Sale Id 555 for retail product','2023-03-13 08:55:07','',''),('4','283',1019,'','20','3',3000.00,0.00,'Retail Sale Id 556 for 4.08 KG of Cooking Gas @ N736.00','2023-03-13 08:56:53','',''),('4','283',1020,'','6.1','4',0.00,3000.00,'Retail Sale Id 556 for retail product','2023-03-13 08:56:53','',''),('4','283',1021,'','20','3',2250.00,0.00,'Retail Sale Id 557 for 3.06 KG of Cooking Gas @ N736.00','2023-03-13 09:01:12','',''),('4','283',1022,'','6.1','4',0.00,2250.00,'Retail Sale Id 557 for retail product','2023-03-13 09:01:12','',''),('4','283',1023,'','20','3',1300.00,0.00,'Retail Sale Id 558 for 1.77 KG of Cooking Gas @ N736.00','2023-03-13 09:12:29','',''),('4','283',1024,'','6.1','4',0.00,1300.00,'Retail Sale Id 558 for retail product','2023-03-13 09:12:29','',''),('4','283',1025,'','20','3',2208.00,0.00,'Retail Sale Id 561 for 3.00 KG of Cooking Gas @ N736.00','2023-03-13 09:25:33','',''),('4','283',1026,'','6.1','4',0.00,2208.00,'Retail Sale Id 561 for retail product','2023-03-13 09:25:33','',''),('4','283',1027,'','20','3',3680.00,0.00,'Retail Sale Id 562 for 5.00 KG of Cooking Gas @ N736.00','2023-03-13 09:30:05','',''),('4','283',1028,'','6.1','4',0.00,3680.00,'Retail Sale Id 562 for retail product','2023-03-13 09:30:05','',''),('4','283',1029,'','20','3',1000.00,0.00,'Retail Sale Id 563 for 1.36 KG of Cooking Gas @ N736.00','2023-03-13 09:34:49','',''),('4','283',1030,'','6.1','4',0.00,1000.00,'Retail Sale Id 563 for retail product','2023-03-13 09:34:50','',''),('4','283',1031,'','20','3',7360.00,0.00,'Retail Sale Id 564 for 10.00 KG of Cooking Gas @ N736.00','2023-03-13 09:37:37','',''),('4','283',1032,'','6.1','4',0.00,7360.00,'Retail Sale Id 564 for retail product','2023-03-13 09:37:37','',''),('4','283',1033,'','20','3',1000.00,0.00,'Retail Sale Id 565 for 1.36 KG of Cooking Gas @ N736.00','2023-03-13 09:56:19','',''),('4','283',1034,'','6.1','4',0.00,1000.00,'Retail Sale Id 565 for retail product','2023-03-13 09:56:19','',''),('4','283',1035,'','20','3',5000.00,0.00,'Retail Sale Id 566 for 6.79 KG of Cooking Gas @ N736.00','2023-03-13 09:59:58','',''),('4','283',1036,'','6.1','4',0.00,5000.00,'Retail Sale Id 566 for retail product','2023-03-13 09:59:58','',''),('4','283',1037,'','20','3',4416.00,0.00,'Retail Sale Id 567 for 6.00 KG of Cooking Gas @ N736.00','2023-03-13 10:17:00','',''),('4','283',1038,'','6.1','4',0.00,4416.00,'Retail Sale Id 567 for retail product','2023-03-13 10:17:00','',''),('4','283',1039,'','20','3',8832.00,0.00,'Retail Sale Id 569 for 12.00 KG of Cooking Gas @ N736.00','2023-03-13 10:18:51','',''),('4','283',1040,'','6.1','4',0.00,8832.00,'Retail Sale Id 569 for retail product','2023-03-13 10:18:51','',''),('4','283',1041,'','20','3',368.00,0.00,'Retail Sale Id 570 for 0.50 KG of Cooking Gas @ N736.00','2023-03-13 10:27:28','',''),('4','283',1042,'','6.1','4',0.00,368.00,'Retail Sale Id 570 for retail product','2023-03-13 10:27:28','',''),('4','283',1043,'','20','3',9200.00,0.00,'Retail Sale Id 571 for 12.50 KG of Cooking Gas @ N736.00','2023-03-13 10:44:13','',''),('4','283',1044,'','6.1','4',0.00,9200.00,'Retail Sale Id 571 for retail product','2023-03-13 10:44:13','',''),('4','283',1045,'','20','3',2000.00,0.00,'Retail Sale Id 572 for 2.72 KG of Cooking Gas @ N736.00','2023-03-13 10:48:29','',''),('4','283',1046,'','6.1','4',0.00,2000.00,'Retail Sale Id 572 for retail product','2023-03-13 10:48:29','',''),('4','283',1047,'','20','3',2500.00,0.00,'Retail Sale Id 573 for 3.40 KG of Cooking Gas @ N736.00','2023-03-13 10:51:18','',''),('4','283',1048,'','6.1','4',0.00,2500.00,'Retail Sale Id 573 for retail product','2023-03-13 10:51:18','',''),('4','283',1049,'','20','3',9200.00,0.00,'Retail Sale Id 574 for 12.50 KG of Cooking Gas @ N736.00','2023-03-13 11:23:32','',''),('4','283',1050,'','6.1','4',0.00,9200.00,'Retail Sale Id 574 for retail product','2023-03-13 11:23:32','',''),('4','283',1051,'','6.1','4',0.00,9200.00,'Retail Sale Id 574 for retail product','2023-03-13 11:23:32','',''),('4','283',1052,'','20','3',4416.00,0.00,'Retail Sale Id 575 for 6.00 KG of Cooking Gas @ N736.00','2023-03-13 11:26:35','',''),('4','283',1053,'','6.1','4',0.00,4416.00,'Retail Sale Id 575 for retail product','2023-03-13 11:26:35','',''),('4','283',1054,'','6.1','4',0.00,4416.00,'Retail Sale Id 575 for retail product','2023-03-13 11:26:35','',''),('4','283',1055,'','20','3',4416.00,0.00,'Retail Sale Id 576 for 6.00 KG of Cooking Gas @ N736.00','2023-03-13 12:16:25','',''),('4','283',1056,'','6.1','4',0.00,4416.00,'Retail Sale Id 576 for retail product','2023-03-13 12:16:25','',''),('4','283',1057,'','20','3',1500.00,0.00,'Retail Sale Id 577 for 2.04 KG of Cooking Gas @ N736.00','2023-03-13 12:32:36','',''),('4','283',1058,'','6.1','4',0.00,1500.00,'Retail Sale Id 577 for retail product','2023-03-13 12:32:36','',''),('4','283',1059,'','20','3',4500.00,0.00,'Retail Sale Id 579 for 6.11 KG of Cooking Gas @ N736.00','2023-03-13 12:39:51','',''),('4','283',1060,'','6.1','4',0.00,4500.00,'Retail Sale Id 579 for retail product','2023-03-13 12:39:51','',''),('4','283',1061,'','20','3',1472.00,0.00,'Retail Sale Id 581 for 2.00 KG of Cooking Gas @ N736.00','2023-03-13 12:41:22','',''),('4','283',1062,'','6.1','4',0.00,1472.00,'Retail Sale Id 581 for retail product','2023-03-13 12:41:22','',''),('4','283',1063,'','20','3',4416.00,0.00,'Retail Sale Id 583 for 6.00 KG of Cooking Gas @ N736.00','2023-03-13 12:46:21','',''),('4','283',1064,'','6.1','4',0.00,4416.00,'Retail Sale Id 583 for retail product','2023-03-13 12:46:21','',''),('4','283',1065,'','20','3',1472.00,0.00,'Retail Sale Id 584 for 2.00 KG of Cooking Gas @ N736.00','2023-03-13 12:47:43','',''),('4','283',1066,'','6.1','4',0.00,1472.00,'Retail Sale Id 584 for retail product','2023-03-13 12:47:43','',''),('4','283',1067,'','20','3',9200.00,0.00,'Retail Sale Id 585 for 12.50 KG of Cooking Gas @ N736.00','2023-03-13 12:50:38','',''),('4','283',1068,'','6.1','4',0.00,9200.00,'Retail Sale Id 585 for retail product','2023-03-13 12:50:38','',''),('4','283',1069,'','20','3',7100.00,0.00,'Retail Sale Id 586 for 10.00 KG of Cooking Gas @ N710.00','2023-03-13 12:55:37','',''),('4','283',1070,'','6.1','4',0.00,7100.00,'Retail Sale Id 586 for retail product','2023-03-13 12:55:37','',''),('4','283',1071,'','20','3',9200.00,0.00,'Retail Sale Id 587 for 12.50 KG of Cooking Gas @ N736.00','2023-03-13 13:06:26','',''),('4','283',1072,'','6.1','4',0.00,9200.00,'Retail Sale Id 587 for retail product','2023-03-13 13:06:26','',''),('4','283',1073,'','20','3',35500.00,0.00,'Retail Sale Id 588 for 50.00 KG of Cooking Gas @ N710.00','2023-03-13 13:20:09','',''),('4','283',1074,'','6.1','4',0.00,35500.00,'Retail Sale Id 588 for retail product','2023-03-13 13:20:09','',''),('4','283',1075,'','20','3',68870.00,0.00,'Retail Sale Id 589 for 97.00 KG of Cooking Gas @ N710.00','2023-03-13 13:22:14','',''),('4','283',1076,'','6.1','4',0.00,68870.00,'Retail Sale Id 589 for retail product','2023-03-13 13:22:14','',''),('4','283',1077,'','20','3',2208.00,0.00,'Retail Sale Id 591 for 3.00 KG of Cooking Gas @ N736.00','2023-03-13 13:23:35','',''),('4','283',1078,'','6.1','4',0.00,2208.00,'Retail Sale Id 591 for retail product','2023-03-13 13:23:35','',''),('4','283',1079,'','20','3',1000.00,0.00,'Retail Sale Id 592 for 1.36 KG of Cooking Gas @ N736.00','2023-03-13 13:36:34','',''),('4','283',1080,'','6.1','4',0.00,1000.00,'Retail Sale Id 592 for retail product','2023-03-13 13:36:34','',''),('4','283',1081,'','20','3',1500.00,0.00,'Retail Sale Id 594 for 2.04 KG of Cooking Gas @ N736.00','2023-03-13 13:45:34','',''),('4','283',1082,'','6.1','4',0.00,1500.00,'Retail Sale Id 594 for retail product','2023-03-13 13:45:34','',''),('4','283',1083,'','20','3',9200.00,0.00,'Retail Sale Id 595 for 12.50 KG of Cooking Gas @ N736.00','2023-03-13 13:48:04','',''),('4','283',1084,'','6.1','4',0.00,9200.00,'Retail Sale Id 595 for retail product','2023-03-13 13:48:04','',''),('4','283',1085,'','20','3',2208.00,0.00,'Retail Sale Id 596 for 3.00 KG of Cooking Gas @ N736.00','2023-03-13 13:49:00','',''),('4','283',1086,'','6.1','4',0.00,2208.00,'Retail Sale Id 596 for retail product','2023-03-13 13:49:00','',''),('4','283',1087,'','20','3',3000.00,0.00,'Retail Sale Id 597 for 4.08 KG of Cooking Gas @ N736.00','2023-03-13 14:37:18','',''),('4','283',1088,'','6.1','4',0.00,3000.00,'Retail Sale Id 597 for retail product','2023-03-13 14:37:18','',''),('4','283',1089,'','20','3',2000.00,0.00,'Retail Sale Id 598 for 2.72 KG of Cooking Gas @ N736.00','2023-03-13 14:38:40','',''),('4','283',1090,'','6.1','4',0.00,2000.00,'Retail Sale Id 598 for retail product','2023-03-13 14:38:40','',''),('4','283',1091,'','20','3',9200.00,0.00,'Retail Sale Id 599 for 12.50 KG of Cooking Gas @ N736.00','2023-03-13 14:41:28','',''),('4','283',1092,'','6.1','4',0.00,9200.00,'Retail Sale Id 599 for retail product','2023-03-13 14:41:28','',''),('4','283',1093,'','20','3',35500.00,0.00,'Retail Sale Id 600 for 50.00 KG of Cooking Gas @ N710.00','2023-03-13 14:46:20','',''),('4','283',1094,'','6.1','4',0.00,35500.00,'Retail Sale Id 600 for retail product','2023-03-13 14:46:20','',''),('4','283',1095,'','20','3',3000.00,0.00,'Retail Sale Id 601 for 4.08 KG of Cooking Gas @ N736.00','2023-03-13 14:48:01','',''),('4','283',1096,'','6.1','4',0.00,3000.00,'Retail Sale Id 601 for retail product','2023-03-13 14:48:01','',''),('4','283',1097,'','20','3',2944.00,0.00,'Retail Sale Id 602 for 4.00 KG of Cooking Gas @ N736.00','2023-03-13 14:50:43','',''),('4','283',1098,'','6.1','4',0.00,2944.00,'Retail Sale Id 602 for retail product','2023-03-13 14:50:43','',''),('4','283',1099,'','20','3',2208.00,0.00,'Retail Sale Id 603 for 3.00 KG of Cooking Gas @ N736.00','2023-03-13 15:21:49','',''),('4','283',1100,'','6.1','4',0.00,2208.00,'Retail Sale Id 603 for retail product','2023-03-13 15:21:49','',''),('4','283',1101,'','20','3',2000.00,0.00,'Retail Sale Id 604 for 2.72 KG of Cooking Gas @ N736.00','2023-03-13 15:30:53','',''),('4','283',1102,'','6.1','4',0.00,2000.00,'Retail Sale Id 604 for retail product','2023-03-13 15:30:53','',''),('4','283',1103,'','20','3',2944.00,0.00,'Retail Sale Id 605 for 4.00 KG of Cooking Gas @ N736.00','2023-03-13 15:34:17','',''),('4','283',1104,'','6.1','4',0.00,2944.00,'Retail Sale Id 605 for retail product','2023-03-13 15:34:17','',''),('4','283',1105,'','20','3',2944.00,0.00,'Retail Sale Id 606 for 4.00 KG of Cooking Gas @ N736.00','2023-03-13 15:36:45','',''),('4','283',1106,'','6.1','4',0.00,2944.00,'Retail Sale Id 606 for retail product','2023-03-13 15:36:45','',''),('4','283',1107,'','20','3',4416.00,0.00,'Retail Sale Id 607 for 6.00 KG of Cooking Gas @ N736.00','2023-03-13 15:39:11','',''),('4','283',1108,'','6.1','4',0.00,4416.00,'Retail Sale Id 607 for retail product','2023-03-13 15:39:11','',''),('4','283',1109,'','20','3',9200.00,0.00,'Retail Sale Id 608 for 12.50 KG of Cooking Gas @ N736.00','2023-03-13 15:40:53','',''),('4','283',1110,'','6.1','4',0.00,9200.00,'Retail Sale Id 608 for retail product','2023-03-13 15:40:53','',''),('4','283',1111,'','20','3',2000.00,0.00,'Retail Sale Id 609 for 2.72 KG of Cooking Gas @ N736.00','2023-03-13 15:48:30','',''),('4','283',1112,'','6.1','4',0.00,2000.00,'Retail Sale Id 609 for retail product','2023-03-13 15:48:30','',''),('4','283',1113,'','20','3',2944.00,0.00,'Retail Sale Id 610 for 4.00 KG of Cooking Gas @ N736.00','2023-03-13 15:52:25','',''),('4','283',1114,'','6.1','4',0.00,2944.00,'Retail Sale Id 610 for retail product','2023-03-13 15:52:25','',''),('4','283',1115,'','20','3',3680.00,0.00,'Retail Sale Id 611 for 5.00 KG of Cooking Gas @ N736.00','2023-03-13 15:55:37','',''),('4','283',1116,'','6.1','4',0.00,3680.00,'Retail Sale Id 611 for retail product','2023-03-13 15:55:37','',''),('4','283',1117,'','20','3',9200.00,0.00,'Retail Sale Id 612 for 12.50 KG of Cooking Gas @ N736.00','2023-03-13 15:57:47','',''),('4','283',1118,'','6.1','4',0.00,9200.00,'Retail Sale Id 612 for retail product','2023-03-13 15:57:47','',''),('4','283',1119,'','20','3',1472.00,0.00,'Retail Sale Id 613 for 2.00 KG of Cooking Gas @ N736.00','2023-03-13 15:58:53','',''),('4','283',1120,'','6.1','4',0.00,1472.00,'Retail Sale Id 613 for retail product','2023-03-13 15:58:53','',''),('4','283',1121,'','20','3',9200.00,0.00,'Retail Sale Id 614 for 12.50 KG of Cooking Gas @ N736.00','2023-03-13 16:00:21','',''),('4','283',1122,'','6.1','4',0.00,9200.00,'Retail Sale Id 614 for retail product','2023-03-13 16:00:21','',''),('4','283',1123,'','20','3',5000.00,0.00,'Retail Sale Id 615 for 6.79 KG of Cooking Gas @ N736.00','2023-03-13 16:03:23','',''),('4','283',1124,'','6.1','4',0.00,5000.00,'Retail Sale Id 615 for retail product','2023-03-13 16:03:23','',''),('4','283',1125,'','20','3',9200.00,0.00,'Retail Sale Id 616 for 12.50 KG of Cooking Gas @ N736.00','2023-03-13 16:08:32','',''),('4','283',1126,'','6.1','4',0.00,9200.00,'Retail Sale Id 616 for retail product','2023-03-13 16:08:32','',''),('4','283',1127,'','20','3',750.00,0.00,'Retail Sale Id 617 for 1.02 KG of Cooking Gas @ N736.00','2023-03-13 16:18:12','',''),('4','283',1128,'','6.1','4',0.00,750.00,'Retail Sale Id 617 for retail product','2023-03-13 16:18:12','',''),('4','283',1129,'','20','3',2208.00,0.00,'Retail Sale Id 618 for 3.00 KG of Cooking Gas @ N736.00','2023-03-13 16:19:45','',''),('4','283',1130,'','6.1','4',0.00,2208.00,'Retail Sale Id 618 for retail product','2023-03-13 16:19:45','',''),('4','283',1131,'','20','3',5888.00,0.00,'Retail Sale Id 619 for 8.00 KG of Cooking Gas @ N736.00','2023-03-13 16:35:37','',''),('4','283',1132,'','6.1','4',0.00,5888.00,'Retail Sale Id 619 for retail product','2023-03-13 16:35:37','',''),('4','283',1133,'','20','3',2208.00,0.00,'Retail Sale Id 620 for 3.00 KG of Cooking Gas @ N736.00','2023-03-13 16:37:28','',''),('4','283',1134,'','6.1','4',0.00,2208.00,'Retail Sale Id 620 for retail product','2023-03-13 16:37:28','',''),('4','283',1135,'','20','3',3680.00,0.00,'Retail Sale Id 621 for 5.00 KG of Cooking Gas @ N736.00','2023-03-13 16:41:37','',''),('4','283',1136,'','6.1','4',0.00,3680.00,'Retail Sale Id 621 for retail product','2023-03-13 16:41:37','',''),('4','283',1137,'','20','3',9200.00,0.00,'Retail Sale Id 622 for 12.50 KG of Cooking Gas @ N736.00','2023-03-13 16:46:24','',''),('4','283',1138,'','6.1','4',0.00,9200.00,'Retail Sale Id 622 for retail product','2023-03-13 16:46:24','',''),('4','283',1139,'','20','3',9200.00,0.00,'Retail Sale Id 623 for 12.50 KG of Cooking Gas @ N736.00','2023-03-13 17:01:05','',''),('4','283',1140,'','6.1','4',0.00,9200.00,'Retail Sale Id 623 for retail product','2023-03-13 17:01:05','',''),('4','283',1141,'','20','3',33370.00,0.00,'Retail Sale Id 624 for 47.00 KG of Cooking Gas @ N710.00','2023-03-13 17:32:28','',''),('4','283',1142,'','6.1','4',0.00,33370.00,'Retail Sale Id 624 for retail product','2023-03-13 17:32:28','',''),('4','283',1143,'','20','3',8875.00,0.00,'Retail Sale Id 625 for 12.50 KG of Cooking Gas @ N710.00','2023-03-13 17:35:58','',''),('4','283',1144,'','6.1','4',0.00,8875.00,'Retail Sale Id 625 for retail product','2023-03-13 17:35:58','',''),('4','283',1145,'','20','3',5152.00,0.00,'Retail Sale Id 626 for 7.00 KG of Cooking Gas @ N736.00','2023-03-13 17:38:13','',''),('4','283',1146,'','6.1','4',0.00,5152.00,'Retail Sale Id 626 for retail product','2023-03-13 17:38:13','',''),('4','283',1147,'','20','3',4416.00,0.00,'Retail Sale Id 629 for 6.00 KG of Cooking Gas @ N736.00','2023-03-13 17:53:51','',''),('4','283',1148,'','6.1','4',0.00,4416.00,'Retail Sale Id 629 for retail product','2023-03-13 17:53:51','',''),('4','283',1149,'','20','3',3000.00,0.00,'Retail Sale Id 630 for 4.08 KG of Cooking Gas @ N736.00','2023-03-13 17:55:20','',''),('4','283',1150,'','6.1','4',0.00,3000.00,'Retail Sale Id 630 for retail product','2023-03-13 17:55:20','',''),('4','283',1151,'','20','3',4416.00,0.00,'Retail Sale Id 631 for 6.00 KG of Cooking Gas @ N736.00','2023-03-13 17:56:35','',''),('4','283',1152,'','6.1','4',0.00,4416.00,'Retail Sale Id 631 for retail product','2023-03-13 17:56:35','',''),('4','283',1153,'','20','3',736.00,0.00,'Retail Sale Id 632 for 1.00 KG of Cooking Gas @ N736.00','2023-03-13 17:57:32','',''),('4','283',1154,'','6.1','4',0.00,736.00,'Retail Sale Id 632 for retail product','2023-03-13 17:57:33','',''),('4','283',1155,'','20','3',0.00,0.00,'Sales from shift 16 on 2023-03-13 20:47:09 ','2023-03-13 20:47:09','',''),('4','283',1156,'','6.1','4',0.00,0.00,'Sales from shift 16 on 2023-03-13 20:47:09 ','2023-03-13 20:47:09','',''),('4','283',1157,'','20','3',145728.00,0.00,'Retail Sale Id 634 for 198.00 KG of Cooking Gas @ N736.00','2023-03-14 11:12:10','',''),('4','283',1158,'','2','6',0.00,145728.00,'Retail Sale Id 634 for retail product','2023-03-14 11:12:10','',''),('4','283',1159,'','20','3',8832.00,0.00,'Retail Sale Id 635 for 12.00 KG of Cooking Gas @ N736.00','2023-03-14 11:17:31','',''),('4','283',1160,'','2','6',0.00,8832.00,'Retail Sale Id 635 for retail product','2023-03-14 11:17:31','',''),('4','283',1161,'','20','3',2208.00,0.00,'Retail Sale Id 636 for 3.00 KG of Cooking Gas @ N736.00','2023-03-14 11:20:57','',''),('4','283',1162,'','2','6',0.00,2208.00,'Retail Sale Id 636 for retail product','2023-03-14 11:20:57','',''),('4','283',1163,'','20','3',52992.00,0.00,'Retail Sale Id 637 for 72.00 KG of Cooking Gas @ N736.00','2023-03-14 12:28:23','',''),('4','283',1164,'','2','6',0.00,52992.00,'Retail Sale Id 637 for retail product','2023-03-14 12:28:23','',''),('4','283',1165,'','20','3',9200.00,0.00,'Retail Sale Id 638 for 12.50 KG of Cooking Gas @ N736.00','2023-03-14 12:40:10','',''),('4','283',1166,'','2','6',0.00,9200.00,'Retail Sale Id 638 for retail product','2023-03-14 12:40:10','',''),('4','283',1167,'','20','3',4416.00,0.00,'Retail Sale Id 639 for 6.00 KG of Cooking Gas @ N736.00','2023-03-14 12:45:09','',''),('4','283',1168,'','2','6',0.00,4416.00,'Retail Sale Id 639 for retail product','2023-03-14 12:45:09','',''),('4','283',1169,'','20','3',1000.00,0.00,'Retail Sale Id 640 for 1.36 KG of Cooking Gas @ N736.00','2023-03-14 12:51:48','',''),('4','283',1170,'','6.1','4',0.00,1000.00,'Retail Sale Id 640 for retail product','2023-03-14 12:51:48','',''),('4','283',1171,'','20','3',2208.00,0.00,'Retail Sale Id 641 for 3.00 KG of Cooking Gas @ N736.00','2023-03-14 12:58:55','',''),('4','283',1172,'','2','6',0.00,2208.00,'Retail Sale Id 641 for retail product','2023-03-14 12:58:55','',''),('4','283',1173,'','20','3',2208.00,0.00,'Retail Sale Id 642 for 3.00 KG of Cooking Gas @ N736.00','2023-03-14 13:01:48','',''),('4','283',1174,'','2','6',0.00,2208.00,'Retail Sale Id 642 for retail product','2023-03-14 13:01:48','',''),('4','283',1175,'','20','3',110400.00,0.00,'Retail Sale Id 643 for 150.00 KG of Cooking Gas @ N736.00','2023-03-14 13:07:07','',''),('4','283',1176,'','2','6',0.00,110400.00,'Retail Sale Id 643 for retail product','2023-03-14 13:07:07','',''),('4','283',1177,'','20','3',3680.00,0.00,'Retail Sale Id 644 for 5.00 KG of Cooking Gas @ N736.00','2023-03-14 13:15:10','',''),('4','283',1178,'','2','6',0.00,3680.00,'Retail Sale Id 644 for retail product','2023-03-14 13:15:10','',''),('4','283',1179,'','20','3',2208.00,0.00,'Retail Sale Id 645 for 3.00 KG of Cooking Gas @ N736.00','2023-03-14 13:18:17','',''),('4','283',1180,'','2','6',0.00,2208.00,'Retail Sale Id 645 for retail product','2023-03-14 13:18:17','',''),('4','283',1181,'','20','3',4416.00,0.00,'Retail Sale Id 646 for 6.00 KG of Cooking Gas @ N736.00','2023-03-14 13:24:19','',''),('4','283',1182,'','2','6',0.00,4416.00,'Retail Sale Id 646 for retail product','2023-03-14 13:24:19','',''),('4','283',1183,'','20','3',92000.00,0.00,'Retail Sale Id 647 for 125.00 KG of Cooking Gas @ N736.00','2023-03-14 14:31:26','',''),('4','283',1184,'','2','6',0.00,92000.00,'Retail Sale Id 647 for retail product','2023-03-14 14:31:26','',''),('4','283',1185,'','20','3',9200.00,0.00,'Retail Sale Id 648 for 12.50 KG of Cooking Gas @ N736.00','2023-03-14 16:27:43','',''),('4','283',1186,'','2','6',0.00,9200.00,'Retail Sale Id 648 for retail product','2023-03-14 16:27:43','',''),('4','283',1187,'','20','3',27600.00,0.00,'Retail Sale Id 650 for 37.50 KG of Cooking Gas @ N736.00','2023-03-14 17:12:41','',''),('4','283',1188,'','2','6',0.00,27600.00,'Retail Sale Id 650 for retail product','2023-03-14 17:12:41','',''),('4','283',1189,'','20','3',26625.00,0.00,'Retail Sale Id 651 for 36.18 KG of Cooking Gas @ N736.00','2023-03-14 17:15:27','',''),('4','283',1190,'','2','6',0.00,26625.00,'Retail Sale Id 651 for retail product','2023-03-14 17:15:27','',''),('4','283',1191,'','20','3',4416.00,0.00,'Retail Sale Id 652 for 6.00 KG of Cooking Gas @ N736.00','2023-03-14 17:39:21','',''),('4','283',1192,'','2','6',0.00,4416.00,'Retail Sale Id 652 for retail product','2023-03-14 17:39:21','',''),('4','283',1193,'','20','3',0.00,0.00,'Sales from shift 17 on 2023-03-15 10:39:20 ','2023-03-15 10:39:20','',''),('4','283',1194,'','6.1','4',0.00,0.00,'Sales from shift 17 on 2023-03-15 10:39:20 ','2023-03-15 10:39:20','',''),('4','283',1195,'','20','3',4416.00,0.00,'Retail Sale Id 653 for 6.00 KG of Cooking Gas @ N736.00','2023-03-15 10:51:29','',''),('4','283',1196,'','6.1','4',0.00,4416.00,'Retail Sale Id 653 for retail product','2023-03-15 10:51:29','',''),('4','283',1197,'','20','3',9200.00,0.00,'Retail Sale Id 654 for 12.50 KG of Cooking Gas @ N736.00','2023-03-15 10:52:42','',''),('4','283',1198,'','6.1','4',0.00,9200.00,'Retail Sale Id 654 for retail product','2023-03-15 10:52:43','',''),('4','283',1199,'','20','3',4416.00,0.00,'Retail Sale Id 655 for 6.00 KG of Cooking Gas @ N736.00','2023-03-15 10:56:23','',''),('4','283',1200,'','6.1','4',0.00,4416.00,'Retail Sale Id 655 for retail product','2023-03-15 10:56:23','',''),('4','283',1201,'','20','3',4416.00,0.00,'Retail Sale Id 656 for 6.00 KG of Cooking Gas @ N736.00','2023-03-15 10:57:42','',''),('4','283',1202,'','6.1','4',0.00,4416.00,'Retail Sale Id 656 for retail product','2023-03-15 10:57:42','',''),('4','283',1203,'','20','3',18400.00,0.00,'Retail Sale Id 658 for 25.00 KG of Cooking Gas @ N736.00','2023-03-15 11:03:38','',''),('4','283',1204,'','6.1','4',0.00,18400.00,'Retail Sale Id 658 for retail product','2023-03-15 11:03:38','',''),('4','283',1205,'','20','3',9200.00,0.00,'Retail Sale Id 659 for 12.50 KG of Cooking Gas @ N736.00','2023-03-15 11:07:51','',''),('4','283',1206,'','6.1','4',0.00,9200.00,'Retail Sale Id 659 for retail product','2023-03-15 11:07:51','',''),('4','283',1207,'','20','3',35500.00,0.00,'Retail Sale Id 660 for 50.00 KG of Cooking Gas @ N710.00','2023-03-15 11:11:14','',''),('4','283',1208,'','6.1','4',0.00,35500.00,'Retail Sale Id 660 for retail product','2023-03-15 11:11:14','',''),('4','283',1209,'','20','3',5152.00,0.00,'Retail Sale Id 661 for 7.00 KG of Cooking Gas @ N736.00','2023-03-15 11:12:37','',''),('4','283',1210,'','6.1','4',0.00,5152.00,'Retail Sale Id 661 for retail product','2023-03-15 11:12:37','',''),('4','283',1211,'','20','3',35500.00,0.00,'Retail Sale Id 663 for 50.00 KG of Cooking Gas @ N710.00','2023-03-15 11:20:19','',''),('4','283',1212,'','6.1','4',0.00,35500.00,'Retail Sale Id 663 for retail product','2023-03-15 11:20:19','',''),('4','283',1213,'','20','3',8464.00,0.00,'Retail Sale Id 664 for 11.50 KG of Cooking Gas @ N736.00','2023-03-15 11:33:25','',''),('4','283',1214,'','6.1','4',0.00,8464.00,'Retail Sale Id 664 for retail product','2023-03-15 11:33:25','',''),('4','283',1215,'','20','3',4416.00,0.00,'Retail Sale Id 665 for 6.00 KG of Cooking Gas @ N736.00','2023-03-15 11:35:02','',''),('4','283',1216,'','6.1','4',0.00,4416.00,'Retail Sale Id 665 for retail product','2023-03-15 11:35:02','',''),('4','283',1217,'','20','3',2208.00,0.00,'Retail Sale Id 666 for 3.00 KG of Cooking Gas @ N736.00','2023-03-15 11:37:47','',''),('4','283',1218,'','6.1','4',0.00,2208.00,'Retail Sale Id 666 for retail product','2023-03-15 11:37:47','',''),('4','283',1219,'','20','3',8096.00,0.00,'Retail Sale Id 667 for 11.00 KG of Cooking Gas @ N736.00','2023-03-15 11:42:04','',''),('4','283',1220,'','6.1','4',0.00,8096.00,'Retail Sale Id 667 for retail product','2023-03-15 11:42:04','',''),('4','283',1221,'','20','3',3000.00,0.00,'Retail Sale Id 668 for 4.08 KG of Cooking Gas @ N736.00','2023-03-15 11:46:08','',''),('4','283',1222,'','6.1','4',0.00,3000.00,'Retail Sale Id 668 for retail product','2023-03-15 11:46:08','',''),('4','283',1223,'','20','3',3680.00,0.00,'Retail Sale Id 669 for 5.00 KG of Cooking Gas @ N736.00','2023-03-15 11:48:24','',''),('4','283',1224,'','6.1','4',0.00,3680.00,'Retail Sale Id 669 for retail product','2023-03-15 11:48:24','',''),('4','283',1225,'','20','3',1472.00,0.00,'Retail Sale Id 670 for 2.00 KG of Cooking Gas @ N736.00','2023-03-15 12:05:50','',''),('4','283',1226,'','6.1','4',0.00,1472.00,'Retail Sale Id 670 for retail product','2023-03-15 12:05:50','',''),('4','283',1227,'','20','3',4416.00,0.00,'Retail Sale Id 671 for 6.00 KG of Cooking Gas @ N736.00','2023-03-15 12:10:31','',''),('4','283',1228,'','6.1','4',0.00,4416.00,'Retail Sale Id 671 for retail product','2023-03-15 12:10:31','',''),('4','283',1229,'','20','3',9200.00,0.00,'Retail Sale Id 672 for 12.50 KG of Cooking Gas @ N736.00','2023-03-15 12:12:53','',''),('4','283',1230,'','6.1','4',0.00,9200.00,'Retail Sale Id 672 for retail product','2023-03-15 12:12:53','',''),('4','283',1231,'','20','3',3680.00,0.00,'Retail Sale Id 673 for 5.00 KG of Cooking Gas @ N736.00','2023-03-15 12:21:24','',''),('4','283',1232,'','6.1','4',0.00,3680.00,'Retail Sale Id 673 for retail product','2023-03-15 12:21:24','',''),('4','283',1233,'','20','3',44375.00,0.00,'Retail Sale Id 674 for 62.50 KG of Cooking Gas @ N710.00','2023-03-15 12:29:18','',''),('4','283',1234,'','6.1','4',0.00,44375.00,'Retail Sale Id 674 for retail product','2023-03-15 12:29:18','',''),('4','283',1235,'','20','3',1472.00,0.00,'Retail Sale Id 675 for 2.00 KG of Cooking Gas @ N736.00','2023-03-15 12:31:18','',''),('4','283',1236,'','6.1','4',0.00,1472.00,'Retail Sale Id 675 for retail product','2023-03-15 12:31:18','',''),('4','283',1237,'','20','3',3680.00,0.00,'Retail Sale Id 676 for 5.00 KG of Cooking Gas @ N736.00','2023-03-15 12:33:21','',''),('4','283',1238,'','6.1','4',0.00,3680.00,'Retail Sale Id 676 for retail product','2023-03-15 12:33:21','',''),('4','283',1239,'','20','3',2208.00,0.00,'Retail Sale Id 677 for 3.00 KG of Cooking Gas @ N736.00','2023-03-15 12:34:43','',''),('4','283',1240,'','6.1','4',0.00,2208.00,'Retail Sale Id 677 for retail product','2023-03-15 12:34:43','',''),('4','283',1241,'','20','3',3500.00,0.00,'Retail Sale Id 678 for 4.76 KG of Cooking Gas @ N736.00','2023-03-15 12:44:26','',''),('4','283',1242,'','6.1','4',0.00,3500.00,'Retail Sale Id 678 for retail product','2023-03-15 12:44:26','',''),('4','283',1243,'','20','3',4500.00,0.00,'Retail Sale Id 679 for 6.11 KG of Cooking Gas @ N736.00','2023-03-15 12:45:24','',''),('4','283',1244,'','6.1','4',0.00,4500.00,'Retail Sale Id 679 for retail product','2023-03-15 12:45:24','',''),('4','283',1245,'','20','3',2208.00,0.00,'Retail Sale Id 680 for 3.00 KG of Cooking Gas @ N736.00','2023-03-15 12:46:57','',''),('4','283',1246,'','6.1','4',0.00,2208.00,'Retail Sale Id 680 for retail product','2023-03-15 12:46:57','',''),('4','283',1247,'','20','3',2208.00,0.00,'Retail Sale Id 681 for 3.00 KG of Cooking Gas @ N736.00','2023-03-15 12:50:41','',''),('4','283',1248,'','6.1','4',0.00,2208.00,'Retail Sale Id 681 for retail product','2023-03-15 12:50:41','',''),('4','283',1249,'','20','3',8875.00,0.00,'Retail Sale Id 682 for 12.50 KG of Cooking Gas @ N710.00','2023-03-15 12:53:07','',''),('4','283',1250,'','6.1','4',0.00,8875.00,'Retail Sale Id 682 for retail product','2023-03-15 12:53:07','',''),('4','283',1251,'','20','3',1472.00,0.00,'Retail Sale Id 683 for 2.00 KG of Cooking Gas @ N736.00','2023-03-15 12:55:04','',''),('4','283',1252,'','6.1','4',0.00,1472.00,'Retail Sale Id 683 for retail product','2023-03-15 12:55:04','',''),('4','283',1253,'','20','3',3000.00,0.00,'Retail Sale Id 684 for 4.08 KG of Cooking Gas @ N736.00','2023-03-15 12:56:49','',''),('4','283',1254,'','6.1','4',0.00,3000.00,'Retail Sale Id 684 for retail product','2023-03-15 12:56:49','',''),('4','283',1255,'','20','3',4416.00,0.00,'Retail Sale Id 685 for 6.00 KG of Cooking Gas @ N736.00','2023-03-15 16:44:35','',''),('4','283',1256,'','6.1','4',0.00,4416.00,'Retail Sale Id 685 for retail product','2023-03-15 16:44:35','',''),('4','283',1257,'','6.1','4',0.00,4416.00,'Retail Sale Id 685 for retail product','2023-03-15 16:44:35','',''),('4','283',1258,'','20','3',2208.00,0.00,'Retail Sale Id 686 for 3.00 KG of Cooking Gas @ N736.00','2023-03-15 16:46:36','',''),('4','283',1259,'','6.1','4',0.00,2208.00,'Retail Sale Id 686 for retail product','2023-03-15 16:46:36','',''),('4','283',1260,'','20','3',6000.00,0.00,'Retail Sale Id 687 for 8.15 KG of Cooking Gas @ N736.00','2023-03-15 16:49:41','',''),('4','283',1261,'','6.1','4',0.00,6000.00,'Retail Sale Id 687 for retail product','2023-03-15 16:49:41','',''),('4','283',1262,'','20','3',2944.00,0.00,'Retail Sale Id 688 for 4.00 KG of Cooking Gas @ N736.00','2023-03-15 16:50:40','',''),('4','283',1263,'','6.1','4',0.00,2944.00,'Retail Sale Id 688 for retail product','2023-03-15 16:50:40','',''),('4','283',1264,'','20','3',2208.00,0.00,'Retail Sale Id 689 for 3.00 KG of Cooking Gas @ N736.00','2023-03-15 16:57:51','',''),('4','283',1265,'','6.1','4',0.00,2208.00,'Retail Sale Id 689 for retail product','2023-03-15 16:57:51','',''),('4','283',1266,'','20','3',2000.00,0.00,'Retail Sale Id 690 for 2.72 KG of Cooking Gas @ N736.00','2023-03-15 17:03:19','',''),('4','283',1267,'','6.1','4',0.00,2000.00,'Retail Sale Id 690 for retail product','2023-03-15 17:03:19','',''),('4','283',1268,'','20','3',2944.00,0.00,'Retail Sale Id 692 for 4.00 KG of Cooking Gas @ N736.00','2023-03-15 17:20:20','',''),('4','283',1269,'','6.1','4',0.00,2944.00,'Retail Sale Id 692 for retail product','2023-03-15 17:20:20','',''),('4','283',1270,'','20','3',8875.00,0.00,'Retail Sale Id 694 for 12.50 KG of Cooking Gas @ N710.00','2023-03-15 17:25:31','',''),('4','283',1271,'','6.1','4',0.00,8875.00,'Retail Sale Id 694 for retail product','2023-03-15 17:25:31','',''),('4','283',1272,'','20','3',4416.00,0.00,'Retail Sale Id 695 for 6.00 KG of Cooking Gas @ N736.00','2023-03-15 17:29:45','',''),('4','283',1273,'','6.1','4',0.00,4416.00,'Retail Sale Id 695 for retail product','2023-03-15 17:29:45','',''),('4','283',1274,'','20','3',2208.00,0.00,'Retail Sale Id 696 for 3.00 KG of Cooking Gas @ N736.00','2023-03-15 17:32:39','',''),('4','283',1275,'','6.1','4',0.00,2208.00,'Retail Sale Id 696 for retail product','2023-03-15 17:32:39','',''),('4','283',1276,'','20','3',2000.00,0.00,'Retail Sale Id 697 for 2.72 KG of Cooking Gas @ N736.00','2023-03-15 17:43:47','',''),('4','283',1277,'','6.1','4',0.00,2000.00,'Retail Sale Id 697 for retail product','2023-03-15 17:43:47','',''),('4','283',1278,'','20','3',2208.00,0.00,'Retail Sale Id 698 for 3.00 KG of Cooking Gas @ N736.00','2023-03-15 17:50:31','',''),('4','283',1279,'','6.1','4',0.00,2208.00,'Retail Sale Id 698 for retail product','2023-03-15 17:50:31','',''),('4','283',1280,'','20','3',2208.00,0.00,'Retail Sale Id 699 for 3.00 KG of Cooking Gas @ N736.00','2023-03-15 17:54:25','',''),('4','283',1281,'','6.1','4',0.00,2208.00,'Retail Sale Id 699 for retail product','2023-03-15 17:54:25','',''),('4','283',1282,'','6.1','4',0.00,2208.00,'Retail Sale Id 699 for retail product','2023-03-15 17:54:25','',''),('4','283',1283,'','20','3',1000.00,0.00,'Retail Sale Id 700 for 1.36 KG of Cooking Gas @ N736.00','2023-03-15 17:56:58','',''),('4','283',1284,'','6.1','4',0.00,1000.00,'Retail Sale Id 700 for retail product','2023-03-15 17:56:58','',''),('4','283',1285,'','20','3',2208.00,0.00,'Retail Sale Id 701 for 3.00 KG of Cooking Gas @ N736.00','2023-03-15 17:57:57','',''),('4','283',1286,'','6.1','4',0.00,2208.00,'Retail Sale Id 701 for retail product','2023-03-15 17:57:57','',''),('4','283',1287,'','20','3',1472.00,0.00,'Retail Sale Id 702 for 2.00 KG of Cooking Gas @ N736.00','2023-03-15 17:59:06','',''),('4','283',1288,'','6.1','4',0.00,1472.00,'Retail Sale Id 702 for retail product','2023-03-15 17:59:06','',''),('4','283',1289,'','20','3',35500.00,0.00,'Retail Sale Id 703 for 50.00 KG of Cooking Gas @ N710.00','2023-03-15 18:01:40','',''),('4','283',1290,'','6.1','4',0.00,35500.00,'Retail Sale Id 703 for retail product','2023-03-15 18:01:40','',''),('4','283',1291,'','20','3',104370.00,0.00,'Retail Sale Id 704 for 147.00 KG of Cooking Gas @ N710.00','2023-03-15 18:03:09','',''),('4','283',1292,'','6.1','4',0.00,104370.00,'Retail Sale Id 704 for retail product','2023-03-15 18:03:09','',''),('4','283',1293,'','20','3',9200.00,0.00,'Retail Sale Id 705 for 12.50 KG of Cooking Gas @ N736.00','2023-03-15 18:04:52','',''),('4','283',1294,'','6.1','4',0.00,9200.00,'Retail Sale Id 705 for retail product','2023-03-15 18:04:52','',''),('4','283',1295,'','20','3',2208.00,0.00,'Retail Sale Id 706 for 3.00 KG of Cooking Gas @ N736.00','2023-03-15 18:06:19','',''),('4','283',1296,'','6.1','4',0.00,2208.00,'Retail Sale Id 706 for retail product','2023-03-15 18:06:19','',''),('4','283',1297,'','20','3',5000.00,0.00,'Retail Sale Id 707 for 6.79 KG of Cooking Gas @ N736.00','2023-03-15 18:08:35','',''),('4','283',1298,'','6.1','4',0.00,5000.00,'Retail Sale Id 707 for retail product','2023-03-15 18:08:35','',''),('4','283',1299,'','20','3',1472.00,0.00,'Retail Sale Id 708 for 2.00 KG of Cooking Gas @ N736.00','2023-03-15 18:14:07','',''),('4','283',1300,'','6.1','4',0.00,1472.00,'Retail Sale Id 708 for retail product','2023-03-15 18:14:07','',''),('4','283',1301,'','20','3',3600.00,0.00,'Retail Sale Id 709 for 4.89 KG of Cooking Gas @ N736.00','2023-03-15 18:15:40','',''),('4','283',1302,'','6.1','4',0.00,3600.00,'Retail Sale Id 709 for retail product','2023-03-15 18:15:40','',''),('4','283',1303,'','20','3',9200.00,0.00,'Retail Sale Id 711 for 12.50 KG of Cooking Gas @ N736.00','2023-03-15 18:16:59','',''),('4','283',1304,'','6.1','4',0.00,9200.00,'Retail Sale Id 711 for retail product','2023-03-15 18:16:59','',''),('4','283',1305,'','20','3',0.00,0.00,'Sales from shift 18 on 2023-03-16 11:02:00 ','2023-03-16 11:02:00','',''),('4','283',1306,'','6.1','4',0.00,0.00,'Sales from shift 18 on 2023-03-16 11:02:00 ','2023-03-16 11:02:00','',''),('4','283',1307,'','20','3',355000.00,0.00,'Retail Sale Id 712 for 500.00 KG of Cooking Gas @ N710.00','2023-03-16 11:51:46','',''),('4','283',1308,'','2','6',0.00,355000.00,'Retail Sale Id 712 for retail product','2023-03-16 11:51:46','',''),('4','283',1309,'','20','3',57408.00,0.00,'Retail Sale Id 713 for 78.00 KG of Cooking Gas @ N736.00','2023-03-16 12:16:41','',''),('4','283',1310,'','2','6',0.00,57408.00,'Retail Sale Id 713 for retail product','2023-03-16 12:16:42','',''),('4','283',1311,'','20','3',4416.00,0.00,'Retail Sale Id 714 for 6.00 KG of Cooking Gas @ N736.00','2023-03-16 12:19:46','',''),('4','283',1312,'','2','6',0.00,4416.00,'Retail Sale Id 714 for retail product','2023-03-16 12:19:46','',''),('4','283',1313,'','20','3',1625088.00,0.00,'Retail Sale Id 715 for 2208.00 KG of Cooking Gas @ N736.00','2023-03-16 12:22:21','',''),('4','283',1314,'','2','6',0.00,1625088.00,'Retail Sale Id 715 for retail product','2023-03-16 12:22:21','',''),('4','283',1315,'','20','3',2944.00,0.00,'Retail Sale Id 716 for 4.00 KG of Cooking Gas @ N736.00','2023-03-16 12:26:30','',''),('4','283',1316,'','2','6',0.00,2944.00,'Retail Sale Id 716 for retail product','2023-03-16 12:26:30','',''),('4','283',1317,'','20','3',7360.00,0.00,'Retail Sale Id 717 for 10.00 KG of Cooking Gas @ N736.00','2023-03-16 12:34:35','',''),('4','283',1318,'','2','6',0.00,7360.00,'Retail Sale Id 717 for retail product','2023-03-16 12:34:35','',''),('4','283',1319,'','20','3',3680.00,0.00,'Retail Sale Id 718 for 5.00 KG of Cooking Gas @ N736.00','2023-03-16 12:40:31','',''),('4','283',1320,'','2','6',0.00,3680.00,'Retail Sale Id 718 for retail product','2023-03-16 12:40:31','',''),('4','283',1321,'','20','3',4416.00,0.00,'Retail Sale Id 719 for 6.00 KG of Cooking Gas @ N736.00','2023-03-16 12:42:42','',''),('4','283',1322,'','2','6',0.00,4416.00,'Retail Sale Id 719 for retail product','2023-03-16 12:42:42','',''),('4','283',1323,'','20','3',3700.00,0.00,'Retail Sale Id 720 for 5.03 KG of Cooking Gas @ N736.00','2023-03-16 12:48:36','',''),('4','283',1324,'','2','6',0.00,3700.00,'Retail Sale Id 720 for retail product','2023-03-16 12:48:36','',''),('4','283',1325,'','20','3',71000.00,0.00,'Retail Sale Id 722 for 100.00 KG of Cooking Gas @ N710.00','2023-03-16 12:58:07','',''),('4','283',1326,'','2','6',0.00,71000.00,'Retail Sale Id 722 for retail product','2023-03-16 12:58:07','',''),('4','283',1327,'','20','3',1500.00,0.00,'Retail Sale Id 723 for 2.04 KG of Cooking Gas @ N736.00','2023-03-16 13:04:34','',''),('4','283',1328,'','2','6',0.00,1500.00,'Retail Sale Id 723 for retail product','2023-03-16 13:04:34','',''),('4','283',1329,'','20','3',2208.00,0.00,'Retail Sale Id 724 for 3.00 KG of Cooking Gas @ N736.00','2023-03-16 13:13:50','',''),('4','283',1330,'','2','6',0.00,2208.00,'Retail Sale Id 724 for retail product','2023-03-16 13:13:50','',''),('4','283',1331,'','20','3',1500.00,0.00,'Retail Sale Id 725 for 2.04 KG of Cooking Gas @ N736.00','2023-03-16 13:18:13','',''),('4','283',1332,'','2','6',0.00,1500.00,'Retail Sale Id 725 for retail product','2023-03-16 13:18:13','',''),('4','283',1333,'','20','3',5888.00,0.00,'Retail Sale Id 726 for 8.00 KG of Cooking Gas @ N736.00','2023-03-16 13:20:55','',''),('4','283',1334,'','2','6',0.00,5888.00,'Retail Sale Id 726 for retail product','2023-03-16 13:20:55','',''),('4','283',1335,'','20','3',4416.00,0.00,'Retail Sale Id 728 for 6.00 KG of Cooking Gas @ N736.00','2023-03-16 13:23:58','',''),('4','283',1336,'','2','6',0.00,4416.00,'Retail Sale Id 728 for retail product','2023-03-16 13:23:58','',''),('4','283',1337,'','20','3',1472.00,0.00,'Retail Sale Id 729 for 2.00 KG of Cooking Gas @ N736.00','2023-03-16 13:25:15','',''),('4','283',1338,'','2','6',0.00,1472.00,'Retail Sale Id 729 for retail product','2023-03-16 13:25:15','',''),('4','283',1339,'','20','3',9200.00,0.00,'Retail Sale Id 730 for 12.50 KG of Cooking Gas @ N736.00','2023-03-16 13:46:26','',''),('4','283',1340,'','2','6',0.00,9200.00,'Retail Sale Id 730 for retail product','2023-03-16 13:46:26','',''),('4','283',1341,'','20','3',800.00,0.00,'Retail Sale Id 731 for 1.09 KG of Cooking Gas @ N736.00','2023-03-16 13:56:59','',''),('4','283',1342,'','6.1','4',0.00,800.00,'Retail Sale Id 731 for retail product','2023-03-16 13:56:59','',''),('4','283',1343,'','20','3',7360.00,0.00,'Retail Sale Id 732 for 10.00 KG of Cooking Gas @ N736.00','2023-03-16 13:59:16','',''),('4','283',1344,'','2','6',0.00,7360.00,'Retail Sale Id 732 for retail product','2023-03-16 13:59:16','',''),('4','283',1345,'','20','3',9200.00,0.00,'Retail Sale Id 733 for 12.50 KG of Cooking Gas @ N736.00','2023-03-16 14:04:34','',''),('4','283',1346,'','2','6',0.00,9200.00,'Retail Sale Id 733 for retail product','2023-03-16 14:04:34','',''),('4','283',1347,'','20','3',5000.00,0.00,'Retail Sale Id 734 for 6.79 KG of Cooking Gas @ N736.00','2023-03-16 14:09:52','',''),('4','283',1348,'','2','6',0.00,5000.00,'Retail Sale Id 734 for retail product','2023-03-16 14:09:52','',''),('4','283',1349,'','20','3',9200.00,0.00,'Retail Sale Id 735 for 12.50 KG of Cooking Gas @ N736.00','2023-03-16 14:13:34','',''),('4','283',1350,'','2','6',0.00,9200.00,'Retail Sale Id 735 for retail product','2023-03-16 14:13:34','',''),('4','283',1351,'','20','3',2208.00,0.00,'Retail Sale Id 736 for 3.00 KG of Cooking Gas @ N736.00','2023-03-16 14:19:33','',''),('4','283',1352,'','2','6',0.00,2208.00,'Retail Sale Id 736 for retail product','2023-03-16 14:19:33','',''),('4','283',1353,'','20','3',4416.00,0.00,'Retail Sale Id 737 for 6.00 KG of Cooking Gas @ N736.00','2023-03-16 14:23:23','',''),('4','283',1354,'','2','6',0.00,4416.00,'Retail Sale Id 737 for retail product','2023-03-16 14:23:23','',''),('4','283',1355,'','20','3',9200.00,0.00,'Retail Sale Id 738 for 12.50 KG of Cooking Gas @ N736.00','2023-03-16 14:32:34','',''),('4','283',1356,'','2','6',0.00,9200.00,'Retail Sale Id 738 for retail product','2023-03-16 14:32:34','',''),('4','283',1357,'','20','3',8875.00,0.00,'Retail Sale Id 739 for 12.50 KG of Cooking Gas @ N710.00','2023-03-16 15:09:36','',''),('4','283',1358,'','2','6',0.00,8875.00,'Retail Sale Id 739 for retail product','2023-03-16 15:09:36','',''),('4','283',1359,'','20','3',7360.00,0.00,'Retail Sale Id 740 for 10.00 KG of Cooking Gas @ N736.00','2023-03-16 16:47:25','',''),('4','283',1360,'','2','6',0.00,7360.00,'Retail Sale Id 740 for retail product','2023-03-16 16:47:25','',''),('4','283',1361,'','20','3',4416.00,0.00,'Retail Sale Id 741 for 6.00 KG of Cooking Gas @ N736.00','2023-03-16 16:49:05','',''),('4','283',1362,'','2','6',0.00,4416.00,'Retail Sale Id 741 for retail product','2023-03-16 16:49:05','',''),('4','283',1363,'','20','3',0.00,0.00,'Sales from shift 19 on 2023-03-16 23:58:10 ','2023-03-16 23:58:10','',''),('4','283',1364,'','6.1','4',0.00,0.00,'Sales from shift 19 on 2023-03-16 23:58:10 ','2023-03-16 23:58:10','',''),('4','283',1365,'','20','3',2500.00,0.00,'Retail Sale Id 742 for 3.40 KG of Cooking Gas @ N736.00','2023-03-17 10:52:28','',''),('4','283',1366,'','6.1','4',0.00,2500.00,'Retail Sale Id 742 for retail product','2023-03-17 10:52:28','',''),('4','283',1367,'','20','3',9200.00,0.00,'Retail Sale Id 743 for 12.50 KG of Cooking Gas @ N736.00','2023-03-17 10:54:29','',''),('4','283',1368,'','6.1','4',0.00,9200.00,'Retail Sale Id 743 for retail product','2023-03-17 10:54:29','',''),('4','283',1369,'','20','3',1472.00,0.00,'Retail Sale Id 745 for 2.00 KG of Cooking Gas @ N736.00','2023-03-17 11:30:05','',''),('4','283',1370,'','6.1','4',0.00,1472.00,'Retail Sale Id 745 for retail product','2023-03-17 11:30:05','',''),('4','283',1371,'','20','3',2208.00,0.00,'Retail Sale Id 746 for 3.00 KG of Cooking Gas @ N736.00','2023-03-17 11:32:47','',''),('4','283',1372,'','6.1','4',0.00,2208.00,'Retail Sale Id 746 for retail product','2023-03-17 11:32:47','',''),('4','283',1373,'','20','3',2208.00,0.00,'Retail Sale Id 747 for 3.00 KG of Cooking Gas @ N736.00','2023-03-17 11:36:44','',''),('4','283',1374,'','6.1','4',0.00,2208.00,'Retail Sale Id 747 for retail product','2023-03-17 11:36:44','',''),('4','283',1375,'','20','3',1000.00,0.00,'Retail Sale Id 748 for 1.36 KG of Cooking Gas @ N736.00','2023-03-17 11:38:16','',''),('4','283',1376,'','6.1','4',0.00,1000.00,'Retail Sale Id 748 for retail product','2023-03-17 11:38:16','',''),('4','283',1377,'','20','3',5152.00,0.00,'Retail Sale Id 749 for 7.00 KG of Cooking Gas @ N736.00','2023-03-17 11:39:27','',''),('4','283',1378,'','6.1','4',0.00,5152.00,'Retail Sale Id 749 for retail product','2023-03-17 11:39:27','',''),('4','283',1379,'','20','3',9200.00,0.00,'Retail Sale Id 750 for 12.50 KG of Cooking Gas @ N736.00','2023-03-17 11:41:41','',''),('4','283',1380,'','6.1','4',0.00,9200.00,'Retail Sale Id 750 for retail product','2023-03-17 11:41:41','',''),('4','283',1381,'','20','3',3680.00,0.00,'Retail Sale Id 752 for 5.00 KG of Cooking Gas @ N736.00','2023-03-17 11:43:38','',''),('4','283',1382,'','6.1','4',0.00,3680.00,'Retail Sale Id 752 for retail product','2023-03-17 11:43:38','',''),('4','283',1383,'','20','3',4416.00,0.00,'Retail Sale Id 753 for 6.00 KG of Cooking Gas @ N736.00','2023-03-17 11:44:34','',''),('4','283',1384,'','6.1','4',0.00,4416.00,'Retail Sale Id 753 for retail product','2023-03-17 11:44:34','',''),('4','283',1385,'','20','3',9200.00,0.00,'Retail Sale Id 754 for 12.50 KG of Cooking Gas @ N736.00','2023-03-17 11:46:16','',''),('4','283',1386,'','6.1','4',0.00,9200.00,'Retail Sale Id 754 for retail product','2023-03-17 11:46:16','',''),('4','283',1387,'','20','3',9200.00,0.00,'Retail Sale Id 756 for 12.50 KG of Cooking Gas @ N736.00','2023-03-17 11:51:21','',''),('4','283',1388,'','6.1','4',0.00,9200.00,'Retail Sale Id 756 for retail product','2023-03-17 11:51:21','',''),('4','283',1389,'','20','3',4416.00,0.00,'Retail Sale Id 758 for 6.00 KG of Cooking Gas @ N736.00','2023-03-17 12:00:09','',''),('4','283',1390,'','6.1','4',0.00,4416.00,'Retail Sale Id 758 for retail product','2023-03-17 12:00:09','',''),('4','283',1391,'','20','3',9200.00,0.00,'Retail Sale Id 759 for 12.50 KG of Cooking Gas @ N736.00','2023-03-17 12:01:30','',''),('4','283',1392,'','6.1','4',0.00,9200.00,'Retail Sale Id 759 for retail product','2023-03-17 12:01:30','',''),('4','283',1393,'','20','3',7728.00,0.00,'Retail Sale Id 760 for 10.50 KG of Cooking Gas @ N736.00','2023-03-17 12:03:55','',''),('4','283',1394,'','6.1','4',0.00,7728.00,'Retail Sale Id 760 for retail product','2023-03-17 12:03:55','',''),('4','283',1395,'','20','3',4416.00,0.00,'Retail Sale Id 761 for 6.00 KG of Cooking Gas @ N736.00','2023-03-17 12:05:23','',''),('4','283',1396,'','6.1','4',0.00,4416.00,'Retail Sale Id 761 for retail product','2023-03-17 12:05:23','',''),('4','283',1397,'','20','3',9200.00,0.00,'Retail Sale Id 762 for 12.50 KG of Cooking Gas @ N736.00','2023-03-17 12:11:24','',''),('4','283',1398,'','6.1','4',0.00,9200.00,'Retail Sale Id 762 for retail product','2023-03-17 12:11:24','',''),('4','283',1399,'','20','3',9200.00,0.00,'Retail Sale Id 763 for 12.50 KG of Cooking Gas @ N736.00','2023-03-17 12:14:03','',''),('4','283',1400,'','6.1','4',0.00,9200.00,'Retail Sale Id 763 for retail product','2023-03-17 12:14:03','',''),('4','283',1401,'','20','3',3680.00,0.00,'Retail Sale Id 764 for 5.00 KG of Cooking Gas @ N736.00','2023-03-17 12:18:18','',''),('4','283',1402,'','6.1','4',0.00,3680.00,'Retail Sale Id 764 for retail product','2023-03-17 12:18:18','',''),('4','283',1403,'','20','3',4416.00,0.00,'Retail Sale Id 765 for 6.00 KG of Cooking Gas @ N736.00','2023-03-17 12:25:56','',''),('4','283',1404,'','6.1','4',0.00,4416.00,'Retail Sale Id 765 for retail product','2023-03-17 12:25:56','',''),('4','283',1405,'','20','3',9200.00,0.00,'Retail Sale Id 766 for 12.50 KG of Cooking Gas @ N736.00','2023-03-17 12:26:57','',''),('4','283',1406,'','6.1','4',0.00,9200.00,'Retail Sale Id 766 for retail product','2023-03-17 12:26:57','',''),('4','283',1407,'','20','3',4000.00,0.00,'Retail Sale Id 767 for 5.43 KG of Cooking Gas @ N736.00','2023-03-17 12:28:31','',''),('4','283',1408,'','6.1','4',0.00,4000.00,'Retail Sale Id 767 for retail product','2023-03-17 12:28:31','',''),('4','283',1409,'','20','3',2944.00,0.00,'Retail Sale Id 768 for 4.00 KG of Cooking Gas @ N736.00','2023-03-17 12:30:57','',''),('4','283',1410,'','6.1','4',0.00,2944.00,'Retail Sale Id 768 for retail product','2023-03-17 12:30:57','',''),('4','283',1411,'','20','3',9200.00,0.00,'Retail Sale Id 769 for 12.50 KG of Cooking Gas @ N736.00','2023-03-17 12:32:25','',''),('4','283',1412,'','6.1','4',0.00,9200.00,'Retail Sale Id 769 for retail product','2023-03-17 12:32:25','',''),('4','283',1413,'','20','3',2944.00,0.00,'Retail Sale Id 770 for 4.00 KG of Cooking Gas @ N736.00','2023-03-17 12:42:17','',''),('4','283',1414,'','6.1','4',0.00,2944.00,'Retail Sale Id 770 for retail product','2023-03-17 12:42:17','',''),('4','283',1415,'','20','3',4416.00,0.00,'Retail Sale Id 771 for 6.00 KG of Cooking Gas @ N736.00','2023-03-17 12:43:24','',''),('4','283',1416,'','6.1','4',0.00,4416.00,'Retail Sale Id 771 for retail product','2023-03-17 12:43:24','',''),('4','283',1417,'','20','3',2208.00,0.00,'Retail Sale Id 772 for 3.00 KG of Cooking Gas @ N736.00','2023-03-17 12:46:31','',''),('4','283',1418,'','6.1','4',0.00,2208.00,'Retail Sale Id 772 for retail product','2023-03-17 12:46:31','',''),('4','283',1419,'','20','3',6624.00,0.00,'Retail Sale Id 773 for 9.00 KG of Cooking Gas @ N736.00','2023-03-17 12:48:01','',''),('4','283',1420,'','6.1','4',0.00,6624.00,'Retail Sale Id 773 for retail product','2023-03-17 12:48:01','',''),('4','283',1421,'','20','3',14200.00,0.00,'Retail Sale Id 774 for 20.00 KG of Cooking Gas @ N710.00','2023-03-17 12:53:34','',''),('4','283',1422,'','6.1','4',0.00,14200.00,'Retail Sale Id 774 for retail product','2023-03-17 12:53:34','',''),('4','283',1423,'','20','3',33370.00,0.00,'Retail Sale Id 775 for 47.00 KG of Cooking Gas @ N710.00','2023-03-17 12:54:58','',''),('4','283',1424,'','6.1','4',0.00,33370.00,'Retail Sale Id 775 for retail product','2023-03-17 12:54:58','',''),('4','283',1425,'','20','3',43665.00,0.00,'Retail Sale Id 776 for 61.50 KG of Cooking Gas @ N710.00','2023-03-17 13:00:25','',''),('4','283',1426,'','6.1','4',0.00,43665.00,'Retail Sale Id 776 for retail product','2023-03-17 13:00:25','',''),('4','283',1427,'','20','3',13248.00,0.00,'Retail Sale Id 777 for 18.00 KG of Cooking Gas @ N736.00','2023-03-17 13:05:55','',''),('4','283',1428,'','6.1','4',0.00,13248.00,'Retail Sale Id 777 for retail product','2023-03-17 13:05:55','',''),('4','283',1429,'','20','3',9200.00,0.00,'Retail Sale Id 778 for 12.50 KG of Cooking Gas @ N736.00','2023-03-17 13:07:15','',''),('4','283',1430,'','6.1','4',0.00,9200.00,'Retail Sale Id 778 for retail product','2023-03-17 13:07:15','',''),('4','283',1431,'','20','3',5152.00,0.00,'Retail Sale Id 779 for 7.00 KG of Cooking Gas @ N736.00','2023-03-17 13:16:15','',''),('4','283',1432,'','6.1','4',0.00,5152.00,'Retail Sale Id 779 for retail product','2023-03-17 13:16:15','',''),('4','283',1433,'','20','3',4416.00,0.00,'Retail Sale Id 780 for 6.00 KG of Cooking Gas @ N736.00','2023-03-17 13:19:54','',''),('4','283',1434,'','6.1','4',0.00,4416.00,'Retail Sale Id 780 for retail product','2023-03-17 13:19:54','',''),('4','283',1435,'','20','3',1000.00,0.00,'Retail Sale Id 781 for 1.36 KG of Cooking Gas @ N736.00','2023-03-17 14:15:37','',''),('4','283',1436,'','6.1','4',0.00,1000.00,'Retail Sale Id 781 for retail product','2023-03-17 14:15:37','',''),('4','283',1437,'','20','3',2208.00,0.00,'Retail Sale Id 782 for 3.00 KG of Cooking Gas @ N736.00','2023-03-17 14:17:57','',''),('4','283',1438,'','6.1','4',0.00,2208.00,'Retail Sale Id 782 for retail product','2023-03-17 14:17:57','',''),('4','283',1439,'','20','3',9200.00,0.00,'Retail Sale Id 783 for 12.50 KG of Cooking Gas @ N736.00','2023-03-17 14:19:28','',''),('4','283',1440,'','6.1','4',0.00,9200.00,'Retail Sale Id 783 for retail product','2023-03-17 14:19:28','',''),('4','283',1441,'','20','3',2000.00,0.00,'Retail Sale Id 784 for 2.72 KG of Cooking Gas @ N736.00','2023-03-17 14:21:03','',''),('4','283',1442,'','6.1','4',0.00,2000.00,'Retail Sale Id 784 for retail product','2023-03-17 14:21:03','',''),('4','283',1443,'','20','3',2208.00,0.00,'Retail Sale Id 786 for 3.00 KG of Cooking Gas @ N736.00','2023-03-17 14:25:55','',''),('4','283',1444,'','6.1','4',0.00,2208.00,'Retail Sale Id 786 for retail product','2023-03-17 14:25:55','',''),('4','283',1445,'','20','3',3000.00,0.00,'Retail Sale Id 787 for 4.08 KG of Cooking Gas @ N736.00','2023-03-17 14:27:30','',''),('4','283',1446,'','6.1','4',0.00,3000.00,'Retail Sale Id 787 for retail product','2023-03-17 14:27:30','',''),('4','283',1447,'','20','3',4416.00,0.00,'Retail Sale Id 788 for 6.00 KG of Cooking Gas @ N736.00','2023-03-17 14:29:11','',''),('4','283',1448,'','6.1','4',0.00,4416.00,'Retail Sale Id 788 for retail product','2023-03-17 14:29:11','',''),('4','283',1449,'','20','3',4000.00,0.00,'Retail Sale Id 789 for 5.43 KG of Cooking Gas @ N736.00','2023-03-17 14:37:37','',''),('4','283',1450,'','6.1','4',0.00,4000.00,'Retail Sale Id 789 for retail product','2023-03-17 14:37:37','',''),('4','283',1451,'','20','3',2944.00,0.00,'Retail Sale Id 790 for 4.00 KG of Cooking Gas @ N736.00','2023-03-17 14:41:03','',''),('4','283',1452,'','6.1','4',0.00,2944.00,'Retail Sale Id 790 for retail product','2023-03-17 14:41:03','',''),('4','283',1453,'','20','3',2208.00,0.00,'Retail Sale Id 791 for 3.00 KG of Cooking Gas @ N736.00','2023-03-17 14:42:54','',''),('4','283',1454,'','6.1','4',0.00,2208.00,'Retail Sale Id 791 for retail product','2023-03-17 14:42:54','',''),('4','283',1455,'','20','3',9200.00,0.00,'Retail Sale Id 792 for 12.50 KG of Cooking Gas @ N736.00','2023-03-17 14:47:17','',''),('4','283',1456,'','6.1','4',0.00,9200.00,'Retail Sale Id 792 for retail product','2023-03-17 14:47:17','',''),('4','283',1457,'','20','3',8096.00,0.00,'Retail Sale Id 793 for 11.00 KG of Cooking Gas @ N736.00','2023-03-17 14:49:07','',''),('4','283',1458,'','6.1','4',0.00,8096.00,'Retail Sale Id 793 for retail product','2023-03-17 14:49:07','',''),('4','283',1459,'','20','3',40480.00,0.00,'Retail Sale Id 794 for 55.00 KG of Cooking Gas @ N736.00','2023-03-17 14:57:03','',''),('4','283',1460,'','6.1','4',0.00,40480.00,'Retail Sale Id 794 for retail product','2023-03-17 14:57:03','',''),('4','283',1461,'','20','3',9000.00,0.00,'Retail Sale Id 795 for 12.23 KG of Cooking Gas @ N736.00','2023-03-17 15:07:49','',''),('4','283',1462,'','6.1','4',0.00,9000.00,'Retail Sale Id 795 for retail product','2023-03-17 15:07:49','',''),('4','283',1463,'','20','3',71000.00,0.00,'Retail Sale Id 796 for 100.00 KG of Cooking Gas @ N710.00','2023-03-17 15:52:12','',''),('4','283',1464,'','2','6',0.00,71000.00,'Retail Sale Id 796 for retail product','2023-03-17 15:52:12','',''),('4','283',1465,'','20','3',35500.00,0.00,'Retail Sale Id 797 for 50.00 KG of Cooking Gas @ N710.00','2023-03-17 15:54:12','',''),('4','283',1466,'','2','6',0.00,35500.00,'Retail Sale Id 797 for retail product','2023-03-17 15:54:12','',''),('4','283',1467,'','20','3',2208.00,0.00,'Retail Sale Id 798 for 3.00 KG of Cooking Gas @ N736.00','2023-03-17 16:53:21','',''),('4','283',1468,'','2','6',0.00,2208.00,'Retail Sale Id 798 for retail product','2023-03-17 16:53:21','',''),('4','283',1469,'','20','3',9200.00,0.00,'Retail Sale Id 799 for 12.50 KG of Cooking Gas @ N736.00','2023-03-17 16:54:29','',''),('4','283',1470,'','2','6',0.00,9200.00,'Retail Sale Id 799 for retail product','2023-03-17 16:54:29','',''),('4','283',1471,'','20','3',9200.00,0.00,'Retail Sale Id 800 for 12.50 KG of Cooking Gas @ N736.00','2023-03-17 16:56:28','',''),('4','283',1472,'','2','6',0.00,9200.00,'Retail Sale Id 800 for retail product','2023-03-17 16:56:28','','');
/*!40000 ALTER TABLE `ledgers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `options`
--

DROP TABLE IF EXISTS `options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `options` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` bigint NOT NULL,
  `station_id` bigint NOT NULL,
  `option_key` varchar(200) NOT NULL,
  `option_value` longtext,
  `thedate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `station_id` (`station_id`,`option_key`),
  KEY `company_id` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `options`
--

LOCK TABLES `options` WRITE;
/*!40000 ALTER TABLE `options` DISABLE KEYS */;
/*!40000 ALTER TABLE `options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products`
--

DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `measurement` varchar(20) NOT NULL,
  `quantity2` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`code`,`name`,`measurement`,`quantity2`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `cleanup` (`cleanup`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products`
--

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (1,'4','283','LPG','Cooking Gas','Kg',0,736.00,736.00,710.00,0.00,0.00,0,'2022-09-12 19:19:03','954','955','2023-03-04 17:58:59',0);
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_changevalues`
--

DROP TABLE IF EXISTS `products_changevalues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_changevalues` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `change_id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity` bigint NOT NULL,
  `oldrate` decimal(20,2) NOT NULL,
  `newrate` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`change_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_changevalues`
--

LOCK TABLES `products_changevalues` WRITE;
/*!40000 ALTER TABLE `products_changevalues` DISABLE KEYS */;
INSERT INTO `products_changevalues` VALUES ('4','283',1,'1','8',34759,690.00,736.00,'change of price of cooking gas','955','2023-02-16 13:38:02');
/*!40000 ALTER TABLE `products_changevalues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_prices`
--

DROP TABLE IF EXISTS `products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_prices`
--

LOCK TABLES `products_prices` WRITE;
/*!40000 ALTER TABLE `products_prices` DISABLE KEYS */;
INSERT INTO `products_prices` VALUES (1,'4','283',1,730.00,0.00,0.00,0.00,'Cost from purchase id #1','2023-02-05 16:26:58','954'),(2,'4','283',1,730.00,760.00,750.00,740.00,'PRICE UPDATE.','2023-02-05 16:48:52','954'),(3,'4','283',1,690.00,760.00,0.00,0.00,'Cost from purchase id #2','2023-02-06 14:34:04','955'),(4,'4','283',1,736.00,736.00,710.00,0.00,'PRICE UPDATE','2023-03-04 17:58:36','955');
/*!40000 ALTER TABLE `products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_reconciliations`
--

DROP TABLE IF EXISTS `products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_reconciliations`
--

LOCK TABLES `products_reconciliations` WRITE;
/*!40000 ALTER TABLE `products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_shortages`
--

DROP TABLE IF EXISTS `products_shortages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_shortages` (
  `shortage_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shortagedate` date NOT NULL,
  `product_id` varchar(10) NOT NULL,
  `type` int NOT NULL DEFAULT '0',
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`shortage_id`),
  KEY `companycode` (`company_id`,`shortagedate`,`product_id`,`rate`,`quantity`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_shortages`
--

LOCK TABLES `products_shortages` WRITE;
/*!40000 ALTER TABLE `products_shortages` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_shortages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pts_nozzles`
--

DROP TABLE IF EXISTS `pts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pts_nozzles` (
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pts_id` int NOT NULL,
  `pump` varchar(20) NOT NULL,
  `code` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `last_volume` decimal(20,2) NOT NULL,
  `last_price` decimal(20,2) NOT NULL,
  `last_amount` decimal(20,2) NOT NULL,
  `last_transaction` int NOT NULL DEFAULT '0',
  `total_volume` decimal(20,2) NOT NULL,
  `total_amount` decimal(20,2) NOT NULL,
  `total_transactions` decimal(20,2) NOT NULL,
  `lastconnect` datetime NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `terminal_id` (`pts_id`,`pump`,`code`,`lastconnect`),
  KEY `companycode` (`company_id`,`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pts_nozzles`
--

LOCK TABLES `pts_nozzles` WRITE;
/*!40000 ALTER TABLE `pts_nozzles` DISABLE KEYS */;
/*!40000 ALTER TABLE `pts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases`
--

DROP TABLE IF EXISTS `purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases`
--

LOCK TABLES `purchases` WRITE;
/*!40000 ALTER TABLE `purchases` DISABLE KEYS */;
INSERT INTO `purchases` VALUES (1,'4','283','2023-02-05',1,1,730.00,24720.00,0.00,0.00,18045600.00,0.00,'','1674314841','DRA 656 XA','','','','2023-02-05 16:25:47',15,'Being Purchased of LPG Product.','954','','0000-00-00 00:00:00','954','2023-02-05 16:26:58'),(2,'4','283','2023-02-06',1,1,690.00,24140.00,0.00,0.00,16656600.00,0.00,'','1670437600','DRA 656 XA','','','','2023-02-06 14:31:56',15,'PURCHASED OF LPG.','955','','0000-00-00 00:00:00','955','2023-02-06 14:34:04');
/*!40000 ALTER TABLE `purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_payments`
--

DROP TABLE IF EXISTS `purchases_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `supplier_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`supplier_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_payments`
--

LOCK TABLES `purchases_payments` WRITE;
/*!40000 ALTER TABLE `purchases_payments` DISABLE KEYS */;
INSERT INTO `purchases_payments` VALUES (1,'4','283','2023-02-06',1,'111100','','5',7767180.00,'2','','','6','MANIR ADO','222200',7767180.00,'2023-02-06 15:26:04',5,'BEING PAYMENT FOR SHIFT 2.\r\n','955','','0000-00-00 00:00:00','955','2023-02-06 15:26:28'),(2,'4','283','2023-02-13',1,'0000','','5',72580.00,'5','','','6','MUNNIR ADO YAU','0000',72580.00,'2023-02-13 17:39:43',5,'PAYMENT OF SHIFT 5','955','','0000-00-00 00:00:00','955','2023-02-13 17:41:04'),(3,'4','283','2023-02-13',1,'0000','','5',1135860.00,'4','','','6','MUNNIR ADO YAU','01234',1135860.00,'2023-02-13 17:45:45',5,'PAYMENT OF SHIFT  4','955','','0000-00-00 00:00:00','955','2023-02-13 17:46:29'),(4,'4','283','2023-02-13',1,'0011','','5',14060.00,'3','','','6','MUNNIR ADO YAU','0011',14060.00,'2023-02-13 17:53:39',5,'PAYMENT OF SHIFT 3','955','955','2023-02-13 17:56:19','955','2023-02-13 17:56:52'),(5,'4','283','2023-02-13',1,'0012','','5',7767180.00,'2','','','6','MUNNIR ADO YAU','0012',7767180.00,'2023-02-13 17:55:08',5,'PAYMENT OF  SHIFT 2','955','','0000-00-00 00:00:00','955','2023-02-13 17:57:32'),(6,'4','283','2023-02-13',1,'0012','','5',7767180.00,'2','','','6','MUNNIR ADO YAU','0013',7767180.00,'2023-02-13 17:55:32',5,'PAYMENT OF  SHIFT 2','955','','0000-00-00 00:00:00','955','2023-02-13 17:58:06');
/*!40000 ALTER TABLE `purchases_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_receptions`
--

DROP TABLE IF EXISTS `purchases_receptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_receptions` (
  `bridge_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `purchase_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `loadingdate` datetime NOT NULL,
  `loadingpoint` varchar(100) DEFAULT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `received` decimal(20,2) NOT NULL,
  `distributed` decimal(20,2) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `vessel` varchar(50) NOT NULL,
  `drivername` varchar(30) NOT NULL,
  `driverphone` varchar(30) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`bridge_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`supplier_id`,`loadingdate`,`quantity`,`waybill`,`meterno`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`purchase_id`),
  KEY `truck_id` (`tank_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_receptions`
--

LOCK TABLES `purchases_receptions` WRITE;
/*!40000 ALTER TABLE `purchases_receptions` DISABLE KEYS */;
INSERT INTO `purchases_receptions` VALUES (2,'4',1,'283',1,1,'2023-02-05 00:00:00','AA Rano LPG Depot Lagos.',24720.00,24720.00,0.00,'1674314841','','1','DRA 656 XA','Aliyu Hassan','0807777894.','RECEIVED OF LPG PRODUCT.',5,'2023-02-05 16:38:43','954','0000-00-00 00:00:00','','2023-02-05 16:42:37','954'),(3,'4',2,'283',1,1,'2023-02-06 00:00:00','AA Rano LPG Depot Lagos.',24140.00,24140.00,0.00,'1670437600','','1','DRA 656 XA','ADAMU SANI','08051600297','RECEIVED LPG OF PRODUCT.',5,'2023-02-06 14:38:03','955','0000-00-00 00:00:00','','2023-02-06 14:38:54','955');
/*!40000 ALTER TABLE `purchases_receptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports`
--

DROP TABLE IF EXISTS `reports`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  `type` varchar(20) NOT NULL,
  `sql` text NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`report_id`),
  KEY `companycode` (`company_id`,`name`,`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports`
--

LOCK TABLES `reports` WRITE;
/*!40000 ALTER TABLE `reports` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_fields`
--

DROP TABLE IF EXISTS `reports_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(20) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `fieldname` varchar(50) NOT NULL,
  `order` int NOT NULL,
  `visibility` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`report_id`,`field_id`,`order`,`visibility`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_fields`
--

LOCK TABLES `reports_fields` WRITE;
/*!40000 ALTER TABLE `reports_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_filters`
--

DROP TABLE IF EXISTS `reports_filters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_filters` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(50) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `filter_id` int NOT NULL AUTO_INCREMENT,
  `criteria` varchar(20) NOT NULL,
  `value` varchar(100) NOT NULL,
  PRIMARY KEY (`filter_id`),
  KEY `companycode` (`company_id`,`report_id`),
  KEY `field_id` (`field_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_filters`
--

LOCK TABLES `reports_filters` WRITE;
/*!40000 ALTER TABLE `reports_filters` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_filters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_customers`
--

DROP TABLE IF EXISTS `retail_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_customers` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(100) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`name`,`phone`,`email`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=263 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_customers`
--

LOCK TABLES `retail_customers` WRITE;
/*!40000 ALTER TABLE `retail_customers` DISABLE KEYS */;
INSERT INTO `retail_customers` VALUES (1,'4','283','Abubaker Mallam','2348039702656','','2023-02-05 16:54:11','954','0000-00-00 00:00:00',''),(2,'4','283','MUNNIR ADO','2348035677648','','2023-02-06 14:53:49','955','0000-00-00 00:00:00',''),(3,'4','283','MUHAMMAD','2348051600297','','2023-02-06 14:57:49','955','0000-00-00 00:00:00',''),(4,'4','283','ISAH','2349049440033','','2023-02-06 15:00:58','955','0000-00-00 00:00:00',''),(5,'4','283','MAI DALA','2348032130609','','2023-02-11 13:04:24','955','0000-00-00 00:00:00',''),(6,'4','283','FATIMA ADO','2347063475998','','2023-02-12 18:21:48','955','0000-00-00 00:00:00',''),(7,'4','283','ABDUL','2349049446337','','2023-02-12 18:30:05','955','0000-00-00 00:00:00',''),(8,'4','283','HASSAN','2348033206101','','2023-02-12 18:32:26','955','0000-00-00 00:00:00',''),(9,'4','283','SAIFUDDIN','2349030770306','','2023-02-12 18:59:24','955','0000-00-00 00:00:00',''),(10,'4','283','HAJ UMMI','2348036311800','','2023-02-12 19:02:38','955','0000-00-00 00:00:00',''),(11,'4','283','KAMILU','2348036120764','','2023-02-12 19:17:55','955','0000-00-00 00:00:00',''),(12,'4','283','H ABU','2348049446337','','2023-02-12 19:21:35','955','0000-00-00 00:00:00',''),(13,'4','283','BAFFA','2349063333034','','2023-02-12 19:35:30','955','0000-00-00 00:00:00',''),(14,'4','283','JIBSON','2348038135112','','2023-02-12 19:40:48','955','0000-00-00 00:00:00',''),(15,'4','283','MARYAM','2349035208461','','2023-02-13 12:04:24','955','0000-00-00 00:00:00',''),(16,'4','283','FATIMA ADO','2347036054673','','2023-02-13 21:49:00','955','0000-00-00 00:00:00',''),(17,'4','283','Deen Gas','2348030770306','','2023-02-16 14:18:30','955','0000-00-00 00:00:00',''),(18,'4','283','SAIFUDDIN','2348063433049','','2023-02-16 14:45:57','955','0000-00-00 00:00:00',''),(19,'4','283','EZEEWATA','2348061268436','','2023-03-05 09:30:52','955','0000-00-00 00:00:00',''),(20,'4','283','Bashir Idris','2347010949580','','2023-03-05 09:54:45','955','0000-00-00 00:00:00',''),(21,'4','283','UGUSTIN O','2348130402879','','2023-03-05 11:34:09','955','0000-00-00 00:00:00',''),(22,'4','283','HAJJIYA','2348061117394','','2023-03-05 13:09:03','955','0000-00-00 00:00:00',''),(23,'4','283','OGA','2347063621209','','2023-03-05 13:17:07','955','0000-00-00 00:00:00',''),(24,'4','283','OGA','2348038460573','','2023-03-05 13:20:47','955','0000-00-00 00:00:00',''),(25,'4','283','BROTHER','2348161824952','','2023-03-05 13:23:54','955','0000-00-00 00:00:00',''),(26,'4','283','BROTHER','2347045300745','','2023-03-05 13:28:36','955','0000-00-00 00:00:00',''),(27,'4','283','BROTHER','2349034230357','','2023-03-05 13:31:50','955','0000-00-00 00:00:00',''),(28,'4','283','BROTHER','2348056804736','','2023-03-05 13:34:34','955','0000-00-00 00:00:00',''),(29,'4','283','BROTHER','2349035170515','','2023-03-05 13:37:14','955','0000-00-00 00:00:00',''),(30,'4','283','BROTHER','2348014551722','','2023-03-05 13:39:32','955','0000-00-00 00:00:00',''),(31,'4','283','BROTHER','2348035853857','','2023-03-05 13:42:40','955','0000-00-00 00:00:00',''),(32,'4','283','BROTHER','2347037273845','','2023-03-05 13:45:19','955','0000-00-00 00:00:00',''),(33,'4','283','BROTHER','2347060712114','','2023-03-05 13:47:23','955','0000-00-00 00:00:00',''),(34,'4','283','BROTHER','2348035944036','','2023-03-05 13:49:40','955','0000-00-00 00:00:00',''),(35,'4','283','BROTHER','2348021031667','','2023-03-05 13:52:13','955','0000-00-00 00:00:00',''),(36,'4','283','BROTHER','2349018893723','','2023-03-05 13:58:38','955','0000-00-00 00:00:00',''),(37,'4','283','BROTHER','2348036999228','','2023-03-05 14:00:45','955','0000-00-00 00:00:00',''),(38,'4','283','AHMAD','2348064537580','','2023-03-05 17:03:28','955','0000-00-00 00:00:00',''),(39,'4','283','MADAM DINA','2348023935166','','2023-03-05 17:07:17','955','0000-00-00 00:00:00',''),(40,'4','283','RAKIYA','2348037130943','','2023-03-05 17:09:33','955','0000-00-00 00:00:00',''),(41,'4','283','BRAHIM SHEHU SHAYI','2348036956486','','2023-03-05 17:12:32','955','0000-00-00 00:00:00',''),(42,'4','283','ALIYU AMINU','2348120466643','','2023-03-05 17:18:33','955','0000-00-00 00:00:00',''),(43,'4','283','MOHD NURA','2349133579817','','2023-03-05 17:21:39','955','0000-00-00 00:00:00',''),(44,'4','283','OSEE','2348068037079','','2023-03-05 17:24:07','955','0000-00-00 00:00:00',''),(45,'4','283','MOHD','2348032447537','','2023-03-05 17:27:04','955','0000-00-00 00:00:00',''),(46,'4','283','OGA','2347035148953','','2023-03-05 17:32:34','955','0000-00-00 00:00:00',''),(47,'4','283','AHMAD UBA','2347026431074','','2023-03-05 17:35:26','955','0000-00-00 00:00:00',''),(48,'4','283','ABDURRAHMAN','2348033468449','','2023-03-05 17:40:30','955','0000-00-00 00:00:00',''),(49,'4','283','MURTALA SHEHU','2348036205513','','2023-03-05 17:42:31','955','0000-00-00 00:00:00',''),(50,'4','283','AISHA','2347041106555','','2023-03-05 17:44:32','955','0000-00-00 00:00:00',''),(51,'4','283','EZEREL','2348139328704','','2023-03-05 17:47:14','955','0000-00-00 00:00:00',''),(52,'4','283','DR. CHARLSE','2348067631935','','2023-03-05 17:52:17','955','0000-00-00 00:00:00',''),(53,'4','283','TOMSIN','2348092799951','','2023-03-05 17:55:04','955','0000-00-00 00:00:00',''),(54,'4','283','Emmafidon','2348077326902','','2023-03-09 13:17:24','955','0000-00-00 00:00:00',''),(55,'4','283','Rufai favor','2348038180532','','2023-03-09 13:24:24','955','0000-00-00 00:00:00',''),(56,'4','283','ebunu','2347035229261','','2023-03-09 13:53:05','955','0000-00-00 00:00:00',''),(57,'4','283','Samuel','2348109071185','','2023-03-09 13:57:26','955','0000-00-00 00:00:00',''),(58,'4','283','sundaey','2349027101384','','2023-03-09 14:07:28','955','0000-00-00 00:00:00',''),(59,'4','283','Mohd Bashir','2347032722238','','2023-03-09 14:23:15','955','0000-00-00 00:00:00',''),(60,'4','283','Ester','2348094296396','','2023-03-09 14:37:46','955','0000-00-00 00:00:00',''),(61,'4','283','Chidimma','2347039816533','','2023-03-09 14:40:31','955','0000-00-00 00:00:00',''),(62,'4','283','Chidimma','2348185994369','','2023-03-09 14:43:38','955','0000-00-00 00:00:00',''),(63,'4','283','Luqman','2349055273787','','2023-03-09 14:45:30','955','0000-00-00 00:00:00',''),(64,'4','283','Mustapha Muazu','2349025342607','','2023-03-09 14:53:34','955','0000-00-00 00:00:00',''),(65,'4','283','Kayode','2348032872159','','2023-03-09 15:01:08','955','0000-00-00 00:00:00',''),(66,'4','283','Jummai Zakari','2348034921492','','2023-03-09 15:03:33','955','0000-00-00 00:00:00',''),(67,'4','283','Mohd','2348065955280','','2023-03-09 15:05:37','955','0000-00-00 00:00:00',''),(68,'4','283','Ugostina','2348069536347','','2023-03-09 15:07:46','955','0000-00-00 00:00:00',''),(69,'4','283','Happiness','2348087698682','','2023-03-09 15:09:38','955','0000-00-00 00:00:00',''),(70,'4','283','Ferguson','2348167737417','','2023-03-09 15:11:33','955','0000-00-00 00:00:00',''),(71,'4','283','Madaki','2348035298908','','2023-03-09 15:13:20','955','0000-00-00 00:00:00',''),(72,'4','283','Godwin','2349061114887','','2023-03-09 15:15:43','955','0000-00-00 00:00:00',''),(73,'4','283','Prince','2349039428791','','2023-03-09 15:17:20','955','0000-00-00 00:00:00',''),(74,'4','283','Oga Bello','2347063252996','','2023-03-09 15:23:04','955','0000-00-00 00:00:00',''),(75,'4','283','Haj Aisha','2348166611718','','2023-03-09 15:27:35','955','0000-00-00 00:00:00',''),(76,'4','283','Hahama','2348059036410','','2023-03-09 15:29:57','955','0000-00-00 00:00:00',''),(77,'4','283','Faith Gerge','2349128337900','','2023-03-09 15:34:13','955','0000-00-00 00:00:00',''),(78,'4','283','Helen','2348038709803','','2023-03-09 15:37:24','955','0000-00-00 00:00:00',''),(79,'4','283','Chima','2348138677774','','2023-03-09 15:41:05','955','0000-00-00 00:00:00',''),(80,'4','283','Kone','2348055571474','','2023-03-09 15:42:52','955','0000-00-00 00:00:00',''),(81,'4','283','Segun','2348164924935','','2023-03-09 15:45:26','955','0000-00-00 00:00:00',''),(82,'4','283','Blessing Samuel','2348165026806','','2023-03-09 15:47:24','955','0000-00-00 00:00:00',''),(83,'4','283','Anjela','2348060651683','','2023-03-09 15:58:49','955','0000-00-00 00:00:00',''),(84,'4','283','Nafiu','2348108170009','','2023-03-09 16:01:35','955','0000-00-00 00:00:00',''),(85,'4','283','Fatima','2347016052775','','2023-03-09 16:06:53','955','0000-00-00 00:00:00',''),(86,'4','283','Abdullahi Alasan','2348038140017','','2023-03-09 16:29:55','955','0000-00-00 00:00:00',''),(87,'4','283','Kabiru','2348039643096','','2023-03-09 16:32:52','955','0000-00-00 00:00:00',''),(88,'4','283','Mustapha Jibrin','2348137959945','','2023-03-09 16:38:00','955','0000-00-00 00:00:00',''),(89,'4','283','James','2349076445482','','2023-03-09 16:40:06','955','0000-00-00 00:00:00',''),(90,'4','283','Obadaki Mohd Mustapha','2347031116200','','2023-03-09 16:45:28','955','0000-00-00 00:00:00',''),(91,'4','283','Khalid','2348068584048','','2023-03-09 16:51:19','955','0000-00-00 00:00:00',''),(92,'4','283','Babajide','2348088771940','','2023-03-09 16:55:11','955','0000-00-00 00:00:00',''),(93,'4','283','Samson Ade','2348023110931','','2023-03-09 17:05:56','955','0000-00-00 00:00:00',''),(94,'4','283','Bashir','2348165983044','','2023-03-09 17:14:09','955','0000-00-00 00:00:00',''),(95,'4','283','Simon Terwase','2347033202343','','2023-03-09 17:19:15','955','0000-00-00 00:00:00',''),(96,'4','283','Nasir Ibrahim','2348060841320','','2023-03-09 17:21:24','955','0000-00-00 00:00:00',''),(97,'4','283','Abubakar Abdullahi','2349073626268','','2023-03-09 17:23:29','955','0000-00-00 00:00:00',''),(98,'4','283','Sulaiman','2348063488224','','2023-03-09 17:25:16','955','0000-00-00 00:00:00',''),(99,'4','283','Jonson','2347065822778','','2023-03-09 17:27:10','955','0000-00-00 00:00:00',''),(100,'4','283','Jerry Julius','2348132005919','','2023-03-09 17:30:53','955','0000-00-00 00:00:00',''),(101,'4','283','Mutapha Abdulmumini Magaji','2349129209982','','2023-03-09 17:35:55','955','0000-00-00 00:00:00',''),(102,'4','283','Osita','2349165341966','','2023-03-09 17:39:15','955','0000-00-00 00:00:00',''),(103,'4','283','Yasir Sale','2349082615734','','2023-03-09 17:41:49','955','0000-00-00 00:00:00',''),(104,'4','283','Ahmed Adamu','2348034575486','','2023-03-09 17:43:50','955','0000-00-00 00:00:00',''),(105,'4','283','Saidu','2348034916479','','2023-03-09 17:49:22','955','0000-00-00 00:00:00',''),(106,'4','283','Haj Aisha','2348147854011','','2023-03-09 17:51:21','955','0000-00-00 00:00:00',''),(107,'4','283','Adamu Shuaibu','2348143105504','','2023-03-09 17:53:16','955','0000-00-00 00:00:00',''),(108,'4','283','Ojoma','2348030310630','','2023-03-11 10:53:39','955','0000-00-00 00:00:00',''),(109,'4','283','Don','2349077979777','','2023-03-11 10:56:11','955','0000-00-00 00:00:00',''),(110,'4','283','Kabiru Sani Baban Gwari','2348033324400','','2023-03-11 11:24:18','955','0000-00-00 00:00:00',''),(111,'4','283','Nnamdi ','2348102351333','','2023-03-11 11:27:14','955','0000-00-00 00:00:00',''),(112,'4','283','Mohd','2348169207771','','2023-03-11 11:32:17','955','0000-00-00 00:00:00',''),(113,'4','283','Chidi','2348036924449','','2023-03-11 11:36:14','955','0000-00-00 00:00:00',''),(114,'4','283','Mohd Ibrahim','2348065531922','','2023-03-11 11:40:13','955','0000-00-00 00:00:00',''),(115,'4','283','Boy Mata Bitrus','2347035702999','','2023-03-11 11:44:08','955','0000-00-00 00:00:00',''),(116,'4','283','Frances Eka','2348032874131','','2023-03-11 11:55:27','955','0000-00-00 00:00:00',''),(117,'4','283','Kingsley','2349070584938','','2023-03-11 12:01:52','955','0000-00-00 00:00:00',''),(118,'4','283','Beki','2348115642335','','2023-03-11 12:19:39','955','0000-00-00 00:00:00',''),(119,'4','283','Abdulmunaf Ado Bala','2348032704092','','2023-03-11 12:23:28','955','0000-00-00 00:00:00',''),(120,'4','283','Chinyere','2348028619772','','2023-03-11 12:26:19','955','0000-00-00 00:00:00',''),(121,'4','283','Faith','2348169190050','','2023-03-11 12:28:24','955','0000-00-00 00:00:00',''),(122,'4','283','Bima Maaruf','2349132188153','','2023-03-11 12:31:27','955','0000-00-00 00:00:00',''),(123,'4','283','Levi Akalonu','2347033903766','','2023-03-11 12:34:36','955','0000-00-00 00:00:00',''),(124,'4','283','Joshua Nanbol','2348130072066','','2023-03-11 12:36:54','955','0000-00-00 00:00:00',''),(125,'4','283','Abdussalamu','2347012735904','','2023-03-11 12:45:58','955','0000-00-00 00:00:00',''),(126,'4','283','Mohd Abdullatif','2348036585503','','2023-03-11 12:52:12','955','0000-00-00 00:00:00',''),(127,'4','283','Gopan','2349099151002','','2023-03-11 12:54:36','955','0000-00-00 00:00:00',''),(128,'4','283','Alexandra','2348030636179','','2023-03-11 12:59:25','955','0000-00-00 00:00:00',''),(129,'4','283','Emmanuel','2347039638171','','2023-03-11 13:01:32','955','0000-00-00 00:00:00',''),(130,'4','283','Abdullahi Gas','2348132442894','','2023-03-11 13:11:48','955','0000-00-00 00:00:00',''),(131,'4','283','Sani Panisau','2347030743030','','2023-03-11 13:13:33','955','0000-00-00 00:00:00',''),(132,'4','283','Faith Hardison','2349075044392','','2023-03-11 13:17:20','955','0000-00-00 00:00:00',''),(133,'4','283','Merrit','2349061646064','','2023-03-11 13:27:04','955','0000-00-00 00:00:00',''),(134,'4','283','Abigail Jamilu','2349073090467','','2023-03-11 13:35:14','955','0000-00-00 00:00:00',''),(135,'4','283','Salisu','2348063246342','','2023-03-11 13:43:50','955','0000-00-00 00:00:00',''),(136,'4','283','David','2348065416980','','2023-03-11 13:47:45','955','0000-00-00 00:00:00',''),(137,'4','283','Adiola Ajaye','2349062499468','','2023-03-11 13:51:11','955','0000-00-00 00:00:00',''),(138,'4','283','Mahmood','2348133816638','','2023-03-11 13:56:45','955','0000-00-00 00:00:00',''),(139,'4','283','Penelope','2348060358143','','2023-03-11 14:02:53','955','0000-00-00 00:00:00',''),(140,'4','283','Habiba ','2348106354753','','2023-03-11 14:05:34','955','0000-00-00 00:00:00',''),(141,'4','283','Emmanuel','2347035994441','','2023-03-11 14:19:51','955','0000-00-00 00:00:00',''),(142,'4','283','Jude Emeh','2348037036942','','2023-03-11 14:21:35','955','0000-00-00 00:00:00',''),(143,'4','283','Grease','2348085946969','','2023-03-11 14:24:24','955','0000-00-00 00:00:00',''),(144,'4','283','Kabiru Bala','2348035875878','','2023-03-11 14:27:04','955','0000-00-00 00:00:00',''),(145,'4','283','Izzuddeen','2348038862090','','2023-03-11 14:30:31','955','0000-00-00 00:00:00',''),(146,'4','283','Jamilu Mohd Fage','2348069242616','','2023-03-11 14:32:39','955','0000-00-00 00:00:00',''),(147,'4','283','Akindele','2348150865888','','2023-03-11 14:35:38','955','0000-00-00 00:00:00',''),(148,'4','283','Ashar','2348178011762','','2023-03-11 14:38:11','955','0000-00-00 00:00:00',''),(149,'4','283','Kodelia','2347031681688','','2023-03-11 14:42:20','955','0000-00-00 00:00:00',''),(150,'4','283','Lillian','2347037886315','','2023-03-11 14:45:55','955','0000-00-00 00:00:00',''),(151,'4','283','James','2348067762055','','2023-03-11 14:56:30','955','0000-00-00 00:00:00',''),(152,'4','283','Kayinde','2347062021542','','2023-03-11 15:00:12','955','0000-00-00 00:00:00',''),(153,'4','283','Idris Nasiru','2348060305970','','2023-03-11 15:12:23','955','0000-00-00 00:00:00',''),(154,'4','283','Mr Charlse','2348036014479','','2023-03-11 15:22:15','955','0000-00-00 00:00:00',''),(155,'4','283','Hassan Mahmud','2348178595366','','2023-03-11 15:33:27','955','0000-00-00 00:00:00',''),(156,'4','283','uwalu Usman','2348098700187','','2023-03-11 15:41:31','955','0000-00-00 00:00:00',''),(157,'4','283','Rafa\'t Yusuf','2347035211662','','2023-03-11 15:44:04','955','0000-00-00 00:00:00',''),(158,'4','283','Mustapha Shegun','2347031612173','','2023-03-11 15:48:05','955','0000-00-00 00:00:00',''),(159,'4','283','Hyacinth Sunday','2348065531130','','2023-03-11 15:50:12','955','0000-00-00 00:00:00',''),(160,'4','283','Fatima','2349122882693','','2023-03-11 15:52:28','955','0000-00-00 00:00:00',''),(161,'4','283','Yusuf Abubakar','2348035587085','','2023-03-11 15:54:48','955','0000-00-00 00:00:00',''),(162,'4','283','Surajo Nasidi Saleh','2347047977753','','2023-03-11 15:56:33','955','0000-00-00 00:00:00',''),(163,'4','283','Abdullahi Sani','2347067029083','','2023-03-11 15:59:44','955','0000-00-00 00:00:00',''),(164,'4','283','Louys','2348065456183','','2023-03-11 16:01:38','955','0000-00-00 00:00:00',''),(165,'4','283','Agata Tehembam','2348168962375','','2023-03-11 16:03:38','955','0000-00-00 00:00:00',''),(166,'4','283','Ahmed Muyiddeen','2348039432176','','2023-03-11 16:09:12','955','0000-00-00 00:00:00',''),(167,'4','283','Aisha','2348145334903','','2023-03-11 16:18:16','955','0000-00-00 00:00:00',''),(168,'4','283','Akim','2349114527519','','2023-03-11 16:21:06','955','0000-00-00 00:00:00',''),(169,'4','283','Isma\'il Sule','2348099326361','','2023-03-11 16:23:08','955','0000-00-00 00:00:00',''),(170,'4','283','Yakubu','2348032077089','','2023-03-11 16:28:12','955','0000-00-00 00:00:00',''),(171,'4','283','Mr. John','2348063123171','','2023-03-11 16:31:30','955','0000-00-00 00:00:00',''),(172,'4','283','Auwal Abdullahi','2348034037380','','2023-03-11 16:35:09','955','0000-00-00 00:00:00',''),(173,'4','283','Veronica Valantine','2347032342808','','2023-03-11 16:39:16','955','0000-00-00 00:00:00',''),(174,'4','283','Samuel','2348036305621','','2023-03-11 16:46:00','955','0000-00-00 00:00:00',''),(175,'4','283','Marcos','2347036109067','','2023-03-11 16:48:13','955','0000-00-00 00:00:00',''),(176,'4','283','Saihana Rabi\'u','2348032781617','','2023-03-11 16:52:08','955','0000-00-00 00:00:00',''),(177,'4','283','Auwalu Ibrahim','2348093423478','','2023-03-11 16:54:31','955','0000-00-00 00:00:00',''),(178,'4','283','Chuks Prince','2348065902673','','2023-03-11 17:03:19','955','0000-00-00 00:00:00',''),(179,'4','283','Oga Musa','2348054271778','','2023-03-11 17:06:19','955','0000-00-00 00:00:00',''),(180,'4','283','Vera','2348034544722','','2023-03-11 17:09:59','955','0000-00-00 00:00:00',''),(181,'4','283','Justina Omon','2348025874728','','2023-03-11 17:14:11','955','0000-00-00 00:00:00',''),(182,'4','283','Adebayo','2348065727285','','2023-03-11 17:17:03','955','0000-00-00 00:00:00',''),(183,'4','283','Bello Sulaiman','2348036156246','','2023-03-11 17:19:59','955','0000-00-00 00:00:00',''),(184,'4','283','Kingslely','2348132288373','','2023-03-11 17:21:56','955','0000-00-00 00:00:00',''),(185,'4','283','Mohd Jude','2348065529827','','2023-03-11 17:28:35','955','0000-00-00 00:00:00',''),(186,'4','283','Chiamaka ','2347032799234','','2023-03-11 17:30:13','955','0000-00-00 00:00:00',''),(187,'4','283','Felicia','2348034812727','','2023-03-11 17:34:36','955','0000-00-00 00:00:00',''),(188,'4','283','Oga Idris Baba Indomie','2347066212838','','2023-03-11 17:37:31','955','0000-00-00 00:00:00',''),(189,'4','283','Justine','2348034134899','','2023-03-11 17:40:20','955','0000-00-00 00:00:00',''),(190,'4','283','Abubakar Mustapha Ahmad','2348038624888','','2023-03-11 17:42:52','955','0000-00-00 00:00:00',''),(191,'4','283','Ali Saidu','2348103878727','','2023-03-11 17:47:38','955','0000-00-00 00:00:00',''),(192,'4','283','Ishaya','2348063867599','','2023-03-11 17:51:28','955','0000-00-00 00:00:00',''),(193,'4','283','Inuwa Shuaibu','2348138135752','','2023-03-11 17:57:40','955','0000-00-00 00:00:00',''),(194,'4','283','Daniel','2347031614177','','2023-03-12 13:07:16','955','0000-00-00 00:00:00',''),(195,'4','283','Smart Emmanuel','2347037431770','','2023-03-12 13:14:25','955','0000-00-00 00:00:00',''),(196,'4','283','Busayu','2348030855950','','2023-03-12 13:16:28','955','0000-00-00 00:00:00',''),(197,'4','283','Khadijat','2348037867837','','2023-03-12 13:19:32','955','0000-00-00 00:00:00',''),(198,'4','283','Oga Abubakar','2348065558932','','2023-03-12 13:22:19','955','0000-00-00 00:00:00',''),(199,'4','283','Fardausi Aminu','2347066039578','','2023-03-12 13:24:49','955','0000-00-00 00:00:00',''),(200,'4','283','Abba','2347062450666','','2023-03-12 13:32:16','955','0000-00-00 00:00:00',''),(201,'4','283','Abba','2347060450666','','2023-03-12 13:35:53','955','0000-00-00 00:00:00',''),(202,'4','283','Mr. Abbas Sunusi','2348095379330','','2023-03-12 14:09:12','955','0000-00-00 00:00:00',''),(203,'4','283','Merry','2347030629919','','2023-03-12 14:11:23','955','0000-00-00 00:00:00',''),(204,'4','283','John Chukuemeka','2348131549171','','2023-03-12 14:22:12','955','0000-00-00 00:00:00',''),(205,'4','283','Bolade','2348167450233','','2023-03-12 14:26:24','955','0000-00-00 00:00:00',''),(206,'4','283','Mustapha','2348060619758','','2023-03-12 14:29:37','955','0000-00-00 00:00:00',''),(207,'4','283','Gebriel Simon','2348037467874','','2023-03-12 14:52:04','955','0000-00-00 00:00:00',''),(208,'4','283','Friday','2348067438826','','2023-03-12 15:22:38','955','0000-00-00 00:00:00',''),(209,'4','283','Abdulaziz Afolabi','2347034227596','','2023-03-12 15:25:21','955','0000-00-00 00:00:00',''),(210,'4','283','Concilia','2348035831696','','2023-03-12 15:28:49','955','0000-00-00 00:00:00',''),(211,'4','283','Babawo','2348029808616','','2023-03-12 15:30:39','955','0000-00-00 00:00:00',''),(212,'4','283','Crist','2349164146406','','2023-03-12 15:40:37','955','0000-00-00 00:00:00',''),(213,'4','283','Nasir','2348137946464','','2023-03-12 15:42:26','955','0000-00-00 00:00:00',''),(214,'4','283','Moma Sunday Felix','2348033898143','','2023-03-12 15:44:32','955','0000-00-00 00:00:00',''),(215,'4','283','Mohd Umar','2349061186541','','2023-03-12 15:54:05','955','0000-00-00 00:00:00',''),(216,'4','283','Adekunle','2348060349049','','2023-03-12 16:02:51','955','0000-00-00 00:00:00',''),(217,'4','283','Sam','2348034519430','','2023-03-12 16:05:00','955','0000-00-00 00:00:00',''),(218,'4','283','Blessing','2348032970350','','2023-03-12 16:20:39','955','0000-00-00 00:00:00',''),(219,'4','283','pat','2348076778099','','2023-03-12 16:29:59','955','0000-00-00 00:00:00',''),(220,'4','283','Gift','2349123809995','','2023-03-12 16:36:46','955','0000-00-00 00:00:00',''),(221,'4','283','Mohd Shitu','2347036713974','','2023-03-12 16:40:26','955','0000-00-00 00:00:00',''),(222,'4','283','Ishaq','2348032220047','','2023-03-14 11:17:17','955','0000-00-00 00:00:00',''),(223,'4','283','Musa Okpanachi','2349039950802','','2023-03-14 11:20:43','955','0000-00-00 00:00:00',''),(224,'4','283','costomer','2349044756782','','2023-03-14 12:27:31','955','0000-00-00 00:00:00',''),(225,'4','283','Gebriel','2348054532261','','2023-03-14 12:39:43','955','0000-00-00 00:00:00',''),(226,'4','283','Ishaq','2349099878818','','2023-03-14 12:43:35','955','0000-00-00 00:00:00',''),(227,'4','283','Abdullahi Bera','2348071270683','','2023-03-14 12:51:34','955','0000-00-00 00:00:00',''),(228,'4','283','Anas Iliyasu','2347042070205','','2023-03-14 12:58:34','955','0000-00-00 00:00:00',''),(229,'4','283','KN Gas','2347037059919','','2023-03-14 13:06:47','955','0000-00-00 00:00:00',''),(230,'4','283','Mohd','2349123875050','','2023-03-14 13:14:50','955','0000-00-00 00:00:00',''),(231,'4','283','precios','2349047912584','','2023-03-14 13:18:01','955','0000-00-00 00:00:00',''),(232,'4','283','Zulkifulu Mohd','2348023267854','','2023-03-14 13:24:04','955','0000-00-00 00:00:00',''),(233,'4','283','Hassan Hassan','2348060393333','','2023-03-14 14:31:08','955','0000-00-00 00:00:00',''),(234,'4','283','Steaphen','2349072558976','','2023-03-14 16:27:26','955','0000-00-00 00:00:00',''),(235,'4','283','Mama Funke','2349129427135','','2023-03-14 17:10:34','955','0000-00-00 00:00:00',''),(236,'4','283','Jamil','2347086421200','','2023-03-14 17:39:07','955','0000-00-00 00:00:00',''),(237,'4','283','isa abdu iasa','2349037722655','','2023-03-16 12:16:23','955','0000-00-00 00:00:00',''),(238,'4','283','Mr Musa','2348163595114','','2023-03-16 12:18:50','955','0000-00-00 00:00:00',''),(239,'4','283','Lovina','2348151220917','','2023-03-16 12:21:50','955','0000-00-00 00:00:00',''),(240,'4','283','atima Musa','2349074233715','','2023-03-16 12:25:52','955','0000-00-00 00:00:00',''),(241,'4','283','Olayemi ','2348060303669','','2023-03-16 12:34:19','955','0000-00-00 00:00:00',''),(242,'4','283','Samaila Abdulkareem','2348028897431','','2023-03-16 12:40:17','955','0000-00-00 00:00:00',''),(243,'4','283','Ibrahim','2348136058732','','2023-03-16 12:42:26','955','0000-00-00 00:00:00',''),(244,'4','283','Emeka','2348077153882','','2023-03-16 12:48:19','955','0000-00-00 00:00:00',''),(245,'4','283','Bartho Gas','2348073394409','','2023-03-16 12:57:27','955','0000-00-00 00:00:00',''),(246,'4','283','Aisha Usman Mohd ','2349063602312','','2023-03-16 13:04:19','955','0000-00-00 00:00:00',''),(247,'4','283','Raymond','2348065954949','','2023-03-16 13:13:32','955','0000-00-00 00:00:00',''),(248,'4','283','David','2347069214311','','2023-03-16 13:17:56','955','0000-00-00 00:00:00',''),(249,'4','283','Ofulu Andrew','2348035956277','','2023-03-16 13:20:38','955','0000-00-00 00:00:00',''),(250,'4','283','Zulkifulu Mohd','2347040479348','','2023-03-16 13:23:43','955','0000-00-00 00:00:00',''),(251,'4','283','Emeka','2348140150845','','2023-03-16 13:24:58','955','0000-00-00 00:00:00',''),(252,'4','283','Michael','2348123142748','','2023-03-16 13:46:12','955','0000-00-00 00:00:00',''),(253,'4','283','Mustapha','2348184945474','','2023-03-16 13:56:43','955','0000-00-00 00:00:00',''),(254,'4','283','Abduljalil','2348028221692','','2023-03-16 13:58:54','955','0000-00-00 00:00:00',''),(255,'4','283','Abubakar','2348032323916','','2023-03-16 14:04:16','955','0000-00-00 00:00:00',''),(256,'4','283','Ahmad','2348069778590','','2023-03-16 14:09:35','955','0000-00-00 00:00:00',''),(257,'4','283','Dr CHUka','2348060069280','','2023-03-16 14:13:11','955','0000-00-00 00:00:00',''),(258,'4','283','Nura Hussain','2348038514634','','2023-03-16 14:19:18','955','0000-00-00 00:00:00',''),(259,'4','283','Zara','2347066693488','','2023-03-16 14:23:04','955','0000-00-00 00:00:00',''),(260,'4','283','Emma Fish','2348179351329','','2023-03-16 15:09:19','955','0000-00-00 00:00:00',''),(261,'4','283','Sabo Ibrahim Adamu','2349136110971','','2023-03-16 16:47:07','955','0000-00-00 00:00:00',''),(262,'4','283','Ayo','2347019823455','','2023-03-16 16:48:47','955','0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `retail_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory`
--

DROP TABLE IF EXISTS `retail_inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` int NOT NULL,
  `qtyout` int NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory`
--

LOCK TABLES `retail_inventory` WRITE;
/*!40000 ALTER TABLE `retail_inventory` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_balances`
--

DROP TABLE IF EXISTS `retail_inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_balances`
--

LOCK TABLES `retail_inventory_balances` WRITE;
/*!40000 ALTER TABLE `retail_inventory_balances` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_costs`
--

DROP TABLE IF EXISTS `retail_inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_costs`
--

LOCK TABLES `retail_inventory_costs` WRITE;
/*!40000 ALTER TABLE `retail_inventory_costs` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products`
--

DROP TABLE IF EXISTS `retail_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`name`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `parent_id` (`parent_id`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products`
--

LOCK TABLES `retail_products` WRITE;
/*!40000 ALTER TABLE `retail_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_prices`
--

DROP TABLE IF EXISTS `retail_products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_prices`
--

LOCK TABLES `retail_products_prices` WRITE;
/*!40000 ALTER TABLE `retail_products_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_reconciliations`
--

DROP TABLE IF EXISTS `retail_products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_reconciliations`
--

LOCK TABLES `retail_products_reconciliations` WRITE;
/*!40000 ALTER TABLE `retail_products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_purchases`
--

DROP TABLE IF EXISTS `retail_purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_purchases`
--

LOCK TABLES `retail_purchases` WRITE;
/*!40000 ALTER TABLE `retail_purchases` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales`
--

DROP TABLE IF EXISTS `retail_sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `saledate` date NOT NULL,
  `customer_id` varchar(20) NOT NULL DEFAULT '',
  `customer_name` varchar(50) NOT NULL,
  `customer_phone` varchar(30) NOT NULL,
  `quantity_kg` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `payment_method` varchar(10) NOT NULL,
  `payment_account_type` varchar(20) NOT NULL,
  `payment_account_id` varchar(20) NOT NULL,
  `paid` decimal(20,2) DEFAULT NULL,
  `change` decimal(20,2) DEFAULT '0.00',
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`customer_name`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `payment_method` (`payment_method`,`payment_account_type`,`payment_account_id`),
  KEY `customer_id` (`customer_id`),
  KEY `change` (`change`)
) ENGINE=InnoDB AUTO_INCREMENT=802 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales`
--

LOCK TABLES `retail_sales` WRITE;
/*!40000 ALTER TABLE `retail_sales` DISABLE KEYS */;
INSERT INTO `retail_sales` VALUES (1,'4','283','1','2023-02-05','','Abubaker Mallam','2348039702656',0.00,14060.00,'02051651','2023-02-05 16:54:11',5,'cash','','',14060.00,0.00,'Sales of LPG.','954','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(2,'4','283','2','2023-02-06','','MUNNIR ADO','2348035677648',0.00,11780.00,'02061452','2023-02-06 14:53:49',5,'cash','','',11780.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(3,'4','283','2','2023-02-06','','MUHAMMAD','2348051600297',0.00,19000.00,'02061455','2023-02-06 14:57:49',5,'cash','','',19000.00,0.00,'SALES OF LPG','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(4,'4','283','2','2023-02-06','','ISAH','2349049440033',0.00,11400.00,'02061458','2023-02-06 15:00:58',5,'cash','','',11400.00,0.00,'SALES OF LPG','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(5,'4','283','2','2023-02-06','2','SALUHU GAS','080357424300',0.00,225000.00,'02061515','2023-02-06 15:16:38',5,'cash','','',225000.00,0.00,'DEALER SALES OF LPG.','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(6,'4','283','3','2023-02-11','','MAI DALA','2348032130609',0.00,14060.00,'02111302','2023-02-11 13:04:24',5,'cash','','',14060.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(7,'4','283','4','2023-02-12','','MUHAMMAD','2348051600297',0.00,1520.00,'02121751','2023-02-12 17:54:23',5,'cash','','',1520.00,0.00,'PURCHASE OF GAS','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(8,'4','283','4','2023-02-12','3','FRIDAY GAS','08036238369',0.00,375000.00,'02121755','2023-02-12 17:56:25',5,'cash','','',375000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(9,'4','283','4','2023-02-12','','MUHAMMAD MUNNIR','2348051600297',0.00,95000.00,'02121817','2023-02-12 18:18:46',5,'pos','','',95000.00,0.00,'PURCHASE OF GAS','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(10,'4','283','4','2023-02-12','','MUHAMMAD SANI','2348051600297',0.00,760.00,'02121818','2023-02-12 18:19:55',5,'cash','','',760.00,0.00,'Sales of LPG.','954','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(11,'4','283','4','2023-02-12','','FATIMA ADO','2347063475998',0.00,11400.00,'02121819','2023-02-12 18:21:48',5,'cash','','',11400.00,0.00,'PURCHASE OF GAS','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(12,'4','283','4','2023-02-12','','FATIMA ADO','2347063475998',0.00,11400.00,'02121819','2023-02-12 18:21:54',5,'cash','','',11400.00,0.00,'PURCHASE OF GAS','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(13,'4','283','4','2023-02-12','','FATIMA ADO','2347063475998',0.00,11400.00,'02121819','2023-02-12 18:22:24',5,'cash','','',11400.00,0.00,'PURCHASE OF GAS','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(14,'4','283','4','2023-02-12','','ABDUL','2349049446337',0.00,7600.00,'02121829','2023-02-12 18:30:05',5,'cash','','',7600.00,0.00,'GAS PURCHASE','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(15,'4','283','4','2023-02-12','','HASSAN','2348033206101',0.00,38000.00,'02121831','2023-02-12 18:32:27',5,'cash','','',38000.00,0.00,'PURCHASE OF GAS','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(16,'4','283','4','2023-02-12','1','SABRIN GAS','08039702656',0.00,562500.00,'02121833','2023-02-12 18:34:18',5,'pos','','',562500.00,0.00,'PURCHASE OF GAS','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(17,'4','283','4','2023-02-12','','SAIFUDDIN','2349030770306',0.00,2280.00,'02121857','2023-02-12 18:59:24',5,'cash','','',2280.00,0.00,'PURCHASE OF GAS','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(18,'4','283','4','2023-02-12','','HAJ UMMI','2348036311800',0.00,19000.00,'02121901','2023-02-12 19:02:38',5,'cash','','',19000.00,0.00,'PURCHASE OF GAS','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(19,'4','283','5','2023-02-12','','HAJ UMMI','2348051600297',0.00,11400.00,'02121911','2023-02-12 19:12:26',5,'cash','','',11400.00,0.00,'SALES OF GAS','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(20,'4','283','5','2023-02-12','','FATIMA ADO','2347063475998',0.00,11400.00,'02121914','2023-02-12 19:15:05',5,'pos','','',11400.00,0.00,'SALES OF GAS','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(21,'4','283','5','2023-02-12','','KAMILU','2348036120764',0.00,16340.00,'02121916','2023-02-12 19:17:55',5,'cash','','',16340.00,0.00,'SALES OF GAS','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(22,'4','283','5','2023-02-12','','H ABU','2348049446337',0.00,3800.00,'02121920','2023-02-12 19:21:35',5,'cash','','',3800.00,0.00,'SALES OF GAS','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(23,'4','283','5','2023-02-12','','BAFFA','2349063333034',0.00,6840.00,'02121933','2023-02-12 19:35:30',5,'cash','','',6840.00,0.00,'SALES OF GAS','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(24,'4','283','5','2023-02-12','','JIBSON','2348038135112',0.00,11400.00,'02121937','2023-02-12 19:40:48',5,'cash','','',11400.00,0.00,'SALES OF COOKING GAS','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(25,'4','283','5','2023-02-12','','MUHAMMAD ADO','2348051600297',0.00,11400.00,'02121942','2023-02-12 19:43:11',5,'cash','','',11400.00,0.00,'SALES OF COKING GAS.','954','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(27,'4','283','6','2023-02-13','','MUHAMMAD','2348051600297',0.00,3800.00,'02131029','2023-02-13 10:31:37',5,'pos','','',3800.00,0.00,'PURCHASE OF GAS','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(28,'4','283','6','2023-02-13','','MUNNIR ADO','2348035677648',0.00,23000.00,'02131038','2023-02-13 10:42:53',5,'cash','','',23000.00,0.00,'PURCHASE OF GAS','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(31,'4','283','6','2023-02-13','','MARYAM','2349035208461',0.00,760.00,'02131135','2023-02-13 12:04:24',5,'cash','','',760.00,0.00,'PURCHASE OF GAS','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(32,'4','283','6','2023-02-13','3','FRIDAY GAS','08036238369',0.00,375000.00,'02131717','2023-02-13 17:18:21',5,'cash','','',375000.00,0.00,'PURCHASE OF COOKING GAS','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(33,'4','283','6','2023-02-13','2','SALUHU GAS','080357424300',0.00,112500.00,'02131719','2023-02-13 17:20:20',5,'pos','','',112500.00,0.00,'PURCHASE OF COOKING GAS','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(34,'4','283','6','2023-02-13','','SAFIYA','2349049446337',0.00,2280.00,'02131725','2023-02-13 17:26:55',5,'cash','','',2280.00,0.00,'SALES OF COOKING GAS','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(35,'4','283','6','2023-02-13','','FATIMA ADO','2347036054673',0.00,14060.00,'02132147','2023-02-13 21:49:00',5,'cash','','',14060.00,0.00,'purchase of cooking gas','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(36,'4','283','6','2023-02-13','','MUNNIR ADO','2348035677648',0.00,19000.00,'02132214','2023-02-13 22:21:16',5,'cash','','',19000.00,0.00,'purchase of cooking gas','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(37,'4','283','6','2023-02-13','','MUHAMMAD','2348051600297',0.00,19000.00,'02132243','2023-02-13 22:44:11',5,'cash','','',19000.00,0.00,'purchase of cooking gas','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(38,'4','283','7','2023-02-14','','MUNNIR ADO','2348035677648',0.00,4560.00,'02141039','2023-02-14 10:40:32',5,'cash','','',4560.00,0.00,'purchase of cooking gas','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(40,'4','283','7','2023-02-14','','NAJEEB SAGIR','2348038135112',0.00,6840.00,'02141303','2023-02-14 14:09:19',5,'cash','','',6840.00,0.00,'purchase of cooking gas','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(41,'4','283','7','2023-02-14','1','SABRIN GAS','08039702656',0.00,225000.00,'02141506','2023-02-14 15:07:40',5,'cash','','',225000.00,0.00,'Purchase of cooking Gas','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(42,'4','283','7','2023-02-14','3','FRIDAY GAS','08036238369',0.00,375000.00,'02141807','2023-02-14 18:08:23',5,'cash','','',375000.00,0.00,'purchase of cooking gas','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(43,'4','283','7','2023-02-14','4','SENIOR GAS','08068826955',0.00,375000.00,'02141813','2023-02-14 18:14:36',5,'cash','','',375000.00,0.00,'purchase of cooking gas','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(44,'4','283','7','2023-02-15','','BAFFA','2349063333034',0.00,19000.00,'02151026','2023-02-15 10:27:54',5,'cash','','',19000.00,0.00,'purchase of cooking gas','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(45,'4','283','8','2023-02-16','','JIBSON','2348038135112',0.00,3040.00,'02161331','2023-02-16 13:34:18',5,'cash','','',3040.00,0.00,'purchase of cooking gas','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(46,'4','283','8','2023-02-16','4','SENIOR GAS','08068826955',0.00,262500.00,'02161350','2023-02-16 13:52:27',5,'pos','','',262500.00,0.00,'Purchase of cooking gas','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(47,'4','283','8','2023-02-16','1','SABRIN GAS','08039702656',0.00,70000.00,'02161401','2023-02-16 14:03:38',5,'pos','','',70000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(48,'4','283','8','2023-02-16','','Deen Gas','2348030770306',0.00,760.00,'02161415','2023-02-16 14:18:30',5,'cash','','',5000.00,4240.00,'PURCHASE OF COOKING GAS','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(50,'4','283','8','2023-02-16','','SAIFUDDIN','2348063433049',0.00,5152.00,'02161444','2023-02-16 14:45:57',5,'cash','','',5152.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(51,'4','283','8','2023-02-16','3','FRIDAY GAS','08036238369',0.00,76000.00,'02161450','2023-02-16 15:03:47',5,'pos','','',76000.00,0.00,'PURCHASE OF COOKING GAS','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(52,'4','283','8','2023-02-16','2','SALUHU GAS','080357424300',0.00,177500.00,'02161600','2023-02-16 16:01:49',5,'pos','','',177500.00,0.00,'PURCHASE OF COOKING GAS','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(53,'4','283','8','2023-02-16','4','SENIOR GAS','08068826955',0.00,106500.00,'02161606','2023-02-16 16:09:29',5,'pos','','',106500.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(54,'4','283','10','2023-03-04','','MUHAMMAD','2348051600297',0.00,6624.00,'03041822','2023-03-04 18:24:40',5,'cash','','',6624.00,0.00,'PURCHASE OF COOKING GAS','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(55,'4','283','11','2023-03-05','','EZEEWATA','2348061268436',0.00,9200.00,'03050928','2023-03-05 09:30:52',5,'pos','','',9200.00,0.00,'PURCHASE OF GAS','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(56,'4','283','11','2023-03-05','','MUHAMMAD','2348035677648',0.00,4416.00,'03050936','2023-03-05 09:45:16',5,'pos','','',4416.00,0.00,'PURCHASE OF GAS','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(57,'4','283','11','2023-03-05','','Bashir Idris','2347010949580',0.00,4400.00,'03050953','2023-03-05 09:54:45',5,'pos','','',4400.00,0.00,'Purchase of cooking gas','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(58,'4','283','11','2023-03-05','','Bashir Idris','2347010949580',0.00,900.00,'03050956','2023-03-05 09:57:10',5,'pos','','',900.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(59,'4','283','11','2023-03-05','','MUNNIR ADOuser','2348035677648',0.00,4416.00,'03050958','2023-03-05 10:00:01',5,'cash','','',4416.00,0.00,'gs','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(60,'4','283','11','2023-03-05','','costomer','2348035677648',0.00,13616.00,'03051045','2023-03-05 10:48:35',5,'cash','','',13616.00,0.00,'gas','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(61,'4','283','11','2023-03-05','','customer','2348035677648',0.00,2208.00,'03051050','2023-03-05 10:52:15',5,'cash','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(62,'4','283','11','2023-03-05','','end user','2348035677648',0.00,3680.00,'03051053','2023-03-05 10:54:28',5,'cash','','',7360.00,3680.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(63,'4','283','11','2023-03-05','','customer','2349035208461',0.00,1500.00,'03051055','2023-03-05 10:57:51',5,'cash','','',1500.00,0.00,'gas','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(65,'4','283','11','2023-03-05','','MARYAM','2349035208461',0.00,5000.00,'03051059','2023-03-05 11:11:06',5,'cash','','',10000.00,5000.00,'gas','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(66,'4','283','11','2023-03-05','','MARYAM','2349035208461',0.00,4416.00,'03051112','2023-03-05 11:12:58',5,'cash','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(67,'4','283','11','2023-03-05','','MARYAM','2349035208461',0.00,9200.00,'03051114','2023-03-05 11:15:02',5,'cash','','',9200.00,0.00,'gas','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(69,'4','283','11','2023-03-05','','MARYAM','2349035208461',0.00,2208.00,'03051116','2023-03-05 11:16:47',5,'cash','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(71,'4','283','11','2023-03-05','','MARYAM','2349035208461',0.00,9200.00,'03051117','2023-03-05 11:18:19',5,'cash','','',9200.00,0.00,'gas','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(73,'4','283','11','2023-03-05','','MARYAM','2349035208461',0.00,1472.00,'03051119','2023-03-05 11:21:12',5,'cash','','',2944.00,1472.00,'gas','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(74,'4','283','11','2023-03-05','','MARYAM','2349035208461',0.00,4416.00,'03051122','2023-03-05 11:23:36',5,'cash','','',4416.00,0.00,'gas','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(75,'4','283','11','2023-03-05','','MARYAM','2349035208461',0.00,9200.00,'03051124','2023-03-05 11:25:08',5,'cash','','',9200.00,0.00,'gas','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(78,'4','283','11','2023-03-05','','CHINEDU','2349049446337',0.00,9200.00,'03051130','2023-03-05 11:32:21',5,'bank','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(79,'4','283','11','2023-03-05','','UGUSTIN O','2348130402879',0.00,1472.00,'03051133','2023-03-05 11:34:09',5,'bank','','',1472.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(80,'4','283','11','2023-03-05','','MARYAM','2349035208461',0.00,12880.00,'03051135','2023-03-05 11:52:40',5,'cash','','',25760.00,12880.00,'GAS','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(81,'4','283','11','2023-03-05','','MARYAM','2349035208461',0.00,6624.00,'03051154','2023-03-05 11:54:31',5,'cash','','',6624.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82,'4','283','11','2023-03-05','','MARYAM','2349035208461',0.00,2250.00,'03051156','2023-03-05 11:57:20',5,'cash','','',2250.00,0.00,'GAS','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(83,'4','283','11','2023-03-05','','MARYAM','2349035208461',0.00,3680.00,'03051158','2023-03-05 12:02:04',5,'cash','','',7360.00,3680.00,'GAS','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(84,'4','283','11','2023-03-05','','MARYAM','2349035208461',0.00,5888.00,'03051207','2023-03-05 12:09:39',5,'cash','','',5888.00,0.00,'GAS','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(85,'4','283','11','2023-03-05','','MARYAM','2349035208461',0.00,2208.00,'03051212','2023-03-05 12:12:50',5,'cash','','',2208.00,0.00,'GAS','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(86,'4','283','11','2023-03-05','','MARYAM','2349035208461',0.00,736.00,'03051214','2023-03-05 12:16:25',5,'cash','','',736.00,0.00,'GAS','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(87,'4','283','11','2023-03-05','','MARYAM','2349035208461',0.00,3680.00,'03051217','2023-03-05 12:20:16',5,'cash','','',3680.00,0.00,'GAS','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(88,'4','283','11','2023-03-05','','MARYAM','2349035208461',0.00,1472.00,'03051221','2023-03-05 12:21:59',5,'cash','','',1472.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(89,'4','283','11','2023-03-05','','MARYAM','2349035208461',0.00,2208.00,'03051222','2023-03-05 12:23:32',5,'cash','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(90,'4','283','11','2023-03-05','','MARYAM','2349035208461',0.00,5152.00,'03051225','2023-03-05 12:26:01',5,'cash','','',5152.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(92,'4','283','11','2023-03-05','','MARYAM','2349035208461',0.00,6624.00,'03051227','2023-03-05 12:27:49',5,'cash','','',6624.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(93,'4','283','11','2023-03-05','','MARYAM','2349035208461',0.00,2500.00,'03051228','2023-03-05 12:29:40',5,'cash','','',2500.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(94,'4','283','11','2023-03-05','','MARYAM','2349035208461',0.00,4416.00,'03051230','2023-03-05 12:31:49',5,'cash','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(96,'4','283','11','2023-03-05','','MARYAM','2349035208461',0.00,2208.00,'03051234','2023-03-05 12:35:09',5,'cash','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(97,'4','283','11','2023-03-05','','NAJEEB SAGIR','2349035208461',0.00,1472.00,'03051236','2023-03-05 12:37:37',5,'cash','','',2944.00,1472.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(98,'4','283','11','2023-03-05','','MARYAM','2349035208461',0.00,3000.00,'03051238','2023-03-05 12:39:25',5,'cash','','',3000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(99,'4','283','11','2023-03-05','','MARYAM','2349035208461',0.00,2208.00,'03051240','2023-03-05 12:41:26',5,'cash','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(100,'4','283','11','2023-03-05','','MARYAM','2349035208461',0.00,9200.00,'03051242','2023-03-05 12:46:50',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(101,'4','283','11','2023-03-05','','MARYAM','2349035208461',0.00,7360.00,'03051248','2023-03-05 12:49:29',5,'cash','','',14720.00,7360.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(102,'4','283','11','2023-03-05','','MARYAM','2349035208461',0.00,2000.00,'03051251','2023-03-05 12:51:52',5,'cash','','',2000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(104,'4','283','11','2023-03-05','','MARYAM','2349035208461',0.00,1500.00,'03051252','2023-03-05 12:53:20',5,'cash','','',1500.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(106,'4','283','11','2023-03-05','2','SALUHU GAS','080357424300',0.00,34080.00,'03051258','2023-03-05 12:59:48',5,'cash','','',68160.00,34080.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(107,'4','283','11','2023-03-05','','MARYAM','2349035208461',0.00,5000.00,'03051301','2023-03-05 13:02:16',5,'cash','','',5000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(109,'4','283','11','2023-03-05','','MARYAM','2349035208461',0.00,9200.00,'03051303','2023-03-05 13:03:57',5,'cash','','',18400.00,9200.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(111,'4','283','11','2023-03-05','','HAJJIYA','2348061117394',0.00,4000.00,'03051306','2023-03-05 13:09:03',5,'pos','','',4000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(112,'4','283','11','2023-03-05','','OGA','2347063621209',0.00,9200.00,'03051316','2023-03-05 13:17:07',5,'pos','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(113,'4','283','11','2023-03-05','','OGA','2348038460573',0.00,8832.00,'03051319','2023-03-05 13:20:47',5,'bank','','',8832.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(114,'4','283','11','2023-03-05','','BROTHER','2348161824952',0.00,3680.00,'03051322','2023-03-05 13:23:54',5,'pos','','',3680.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(116,'4','283','11','2023-03-05','','BROTHER','2347045300745',0.00,2208.00,'03051325','2023-03-05 13:28:43',5,'pos','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(117,'4','283','11','2023-03-05','','BROTHER','2349034230357',0.00,2208.00,'03051330','2023-03-05 13:31:50',5,'pos','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(118,'4','283','11','2023-03-05','','BROTHER','2348056804736',0.00,3680.00,'03051333','2023-03-05 13:34:34',5,'pos','','',3680.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(119,'4','283','11','2023-03-05','','BROTHER','2349035170515',0.00,2944.00,'03051336','2023-03-05 13:37:14',5,'pos','','',2944.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(120,'4','283','11','2023-03-05','','BROTHER','2348014551722',0.00,2500.00,'03051338','2023-03-05 13:39:32',5,'cash','','',2500.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(121,'4','283','11','2023-03-05','','BROTHER','2348035853857',0.00,3000.00,'03051341','2023-03-05 13:42:40',5,'pos','','',3000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(122,'4','283','11','2023-03-05','','BROTHER','2347037273845',0.00,736.00,'03051344','2023-03-05 13:45:19',5,'pos','','',736.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(123,'4','283','11','2023-03-05','','BROTHER','2347060712114',0.00,18400.00,'03051346','2023-03-05 13:47:23',5,'pos','','',18400.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(124,'4','283','11','2023-03-05','','BROTHER','2348035944036',0.00,9200.00,'03051348','2023-03-05 13:49:40',5,'pos','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(125,'4','283','11','2023-03-05','','BROTHER','2348021031667',0.00,1000.00,'03051350','2023-03-05 13:52:13',5,'pos','','',1000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(126,'4','283','11','2023-03-05','','BROTHER','2349018893723',0.00,4416.00,'03051357','2023-03-05 13:58:38',5,'pos','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(127,'4','283','11','2023-03-05','','BROTHER','2348036999228',0.00,4416.00,'03051359','2023-03-05 14:00:45',5,'pos','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(128,'4','283','11','2023-03-05','','AHMAD','2348064537580',0.00,1500.00,'03051702','2023-03-05 17:03:28',5,'cash','','',1500.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(129,'4','283','11','2023-03-05','','MADAM DINA','2348023935166',0.00,12880.00,'03051705','2023-03-05 17:07:17',5,'pos','','',12880.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(130,'4','283','11','2023-03-05','','RAKIYA','2348037130943',0.00,12144.00,'03051708','2023-03-05 17:09:33',5,'bank','','',12144.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(131,'4','283','11','2023-03-05','','BRAHIM SHEHU SHAYI','2348036956486',0.00,9200.00,'03051711','2023-03-05 17:12:32',5,'pos','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(132,'4','283','11','2023-03-05','','ALIYU AMINU','2348120466643',0.00,1472.00,'03051715','2023-03-05 17:18:33',5,'pos','','',1472.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(133,'4','283','11','2023-03-05','','MOHD NURA','2349133579817',0.00,400.00,'03051720','2023-03-05 17:21:39',5,'cash','','',400.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(134,'4','283','11','2023-03-05','','OSEE','2348068037079',0.00,7360.00,'03051723','2023-03-05 17:24:07',5,'pos','','',7360.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(135,'4','283','11','2023-03-05','','MOHD','2348032447537',0.00,3680.00,'03051726','2023-03-05 17:27:04',5,'pos','','',3680.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(136,'4','283','11','2023-03-05','','ALIYU AMINU','2348120466643',0.00,736.00,'03051729','2023-03-05 17:30:16',5,'pos','','',736.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(137,'4','283','11','2023-03-05','','OGA','2347035148953',0.00,3680.00,'03051731','2023-03-05 17:32:34',5,'pos','','',3680.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(138,'4','283','11','2023-03-05','','AHMAD UBA','2347026431074',0.00,2944.00,'03051734','2023-03-05 17:35:26',5,'pos','','',2944.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(139,'4','283','11','2023-03-05','','ABDURRAHMAN','2348033468449',0.00,3680.00,'03051739','2023-03-05 17:40:30',5,'pos','','',3680.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(140,'4','283','11','2023-03-05','','MURTALA SHEHU','2348036205513',0.00,3680.00,'03051741','2023-03-05 17:42:31',2,'pos','','',3680.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(141,'4','283','11','2023-03-05','','AISHA','2347041106555',0.00,4416.00,'03051743','2023-03-05 17:44:32',5,'pos','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(142,'4','283','11','2023-03-05','','EZEREL','2348139328704',0.00,3680.00,'03051746','2023-03-05 17:47:14',5,'pos','','',3680.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(143,'4','283','11','2023-03-05','','MUNNIR ADO','2348035677648',0.00,1000.00,'03051748','2023-03-05 17:49:23',5,'pos','','',1000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(144,'4','283','11','2023-03-05','','DR. CHARLSE','2348067631935',0.00,3000.00,'03051751','2023-03-05 17:52:17',2,'pos','','',3000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(145,'4','283','11','2023-03-05','','TOMSIN','2348092799951',0.00,9200.00,'03051754','2023-03-05 17:55:04',5,'pos','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(146,'4','283','11','2023-03-06','','MARYAM','2349035208461',0.00,9200.00,'03060746','2023-03-06 08:03:19',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(149,'4','283','11','2023-03-06','','MARYAM','2349035208461',0.00,2208.00,'03060804','2023-03-06 08:06:30',5,'cash','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(150,'4','283','11','2023-03-06','','MARYAM','2349035208461',0.00,18400.00,'03060807','2023-03-06 08:08:15',5,'cash','','',18400.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(151,'4','283','11','2023-03-06','','MARYAM','2349035208461',0.00,6000.00,'03060808','2023-03-06 08:10:07',5,'cash','','',6000.00,0.00,'gas','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(152,'4','283','11','2023-03-06','','MARYAM','2349035208461',0.00,1472.00,'03060812','2023-03-06 08:13:25',5,'cash','','',1472.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(155,'4','283','11','2023-03-06','','MARYAM','2349035208461',0.00,9200.00,'03060815','2023-03-06 08:16:00',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(157,'4','283','11','2023-03-06','','MARYAM','2349035208461',0.00,8832.00,'03060817','2023-03-06 08:17:47',5,'cash','','',8832.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(158,'4','283','11','2023-03-06','','MARYAM','2349035208461',0.00,750.00,'03060829','2023-03-06 08:29:56',5,'cash','','',750.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(159,'4','283','11','2023-03-06','','MARYAM','2349035208461',0.00,6992.00,'03060831','2023-03-06 08:33:07',5,'cash','','',6992.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(160,'4','283','11','2023-03-06','','customer','2349035208461',0.00,8832.00,'03060836','2023-03-06 08:43:28',5,'cash','','',8832.00,0.00,'gas','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(162,'4','283','11','2023-03-06','','end user','2349035208461',0.00,2300.00,'03060845','2023-03-06 08:49:13',5,'cash','','',2300.00,0.00,'gas','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(164,'4','283','11','2023-03-06','','customer','2349035208461',0.00,4000.00,'03060850','2023-03-06 09:02:55',5,'cash','','',4000.00,0.00,'gas','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(165,'4','283','11','2023-03-06','','customer','2349035208461',0.00,2208.00,'03060907','2023-03-06 09:10:10',5,'cash','','',2208.00,0.00,'gas','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(166,'4','283','11','2023-03-06','','customer','2349035208461',0.00,4416.00,'03060911','2023-03-06 09:12:00',5,'cash','','',4416.00,0.00,'gas','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(167,'4','283','11','2023-03-06','','end user','2349035208461',0.00,3000.00,'03060913','2023-03-06 09:15:15',5,'cash','','',3000.00,0.00,'gas','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(168,'4','283','11','2023-03-06','','end user','2349035208461',0.00,2208.00,'03060916','2023-03-06 09:17:03',5,'cash','','',2208.00,0.00,'gas','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(169,'4','283','11','2023-03-06','','end user','2349035208461',0.00,11408.00,'03060917','2023-03-06 09:20:17',5,'cash','','',22816.00,11408.00,'gas','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(170,'4','283','11','2023-03-06','','end user','2349035208461',0.00,2208.00,'03060923','2023-03-06 09:23:44',5,'cash','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(171,'4','283','11','2023-03-06','','end user','2349035208461',0.00,4416.00,'03060925','2023-03-06 09:26:15',5,'cash','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(172,'4','283','12','2023-03-09','','ABDUL','2349049446337',0.00,9200.00,'03091306','2023-03-09 13:06:39',5,'pos','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(173,'4','283','12','2023-03-09','','Emmafidon','2348077326902',0.00,3680.00,'03091314','2023-03-09 13:17:24',5,'pos','','',3680.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(174,'4','283','12','2023-03-09','','Rufai favor','2348038180532',0.00,2208.00,'03091322','2023-03-09 13:24:24',5,'pos','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(175,'4','283','12','2023-03-09','','ebunu','2347035229261',0.00,2208.00,'03091351','2023-03-09 13:53:05',5,'pos','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(176,'4','283','12','2023-03-09','','Samuel','2348109071185',0.00,4416.00,'03091354','2023-03-09 13:57:26',5,'pos','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(177,'4','283','12','2023-03-09','','sundaey','2349027101384',0.00,6624.00,'03091359','2023-03-09 14:07:28',5,'pos','','',6624.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(178,'4','283','12','2023-03-09','','Mohd Bashir','2347032722238',0.00,3680.00,'03091419','2023-03-09 14:23:15',5,'pos','','',3680.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(179,'4','283','12','2023-03-09','','Ester','2348094296396',0.00,9200.00,'03091424','2023-03-09 14:37:46',5,'pos','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(180,'4','283','12','2023-03-09','','Chidimma','2347039816533',0.00,18400.00,'03091439','2023-03-09 14:40:31',5,'pos','','',18400.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(181,'4','283','12','2023-03-09','','Chidimma','2348185994369',0.00,4416.00,'03091442','2023-03-09 14:43:38',5,'pos','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(182,'4','283','12','2023-03-09','','Luqman','2349055273787',0.00,4416.00,'03091444','2023-03-09 14:45:30',5,'pos','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(183,'4','283','12','2023-03-09','','Mustapha Muazu','2349025342607',0.00,8875.00,'03091446','2023-03-09 14:53:34',5,'pos','','',8875.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(184,'4','283','12','2023-03-09','','MUNNIR ADO','2348035677648',0.00,736.00,'03091454','2023-03-09 14:55:46',5,'cash','','',736.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(185,'4','283','12','2023-03-09','','MUNNIR ADO','2348035677648',0.00,2000.00,'03091457','2023-03-09 14:58:23',5,'cash','','',2000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(186,'4','283','12','2023-03-09','','Kayode','2348032872159',0.00,3680.00,'03091500','2023-03-09 15:01:08',5,'pos','','',3680.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(187,'4','283','12','2023-03-09','','Jummai Zakari','2348034921492',0.00,2208.00,'03091502','2023-03-09 15:03:33',5,'pos','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(188,'4','283','12','2023-03-09','','Mohd','2348065955280',0.00,2208.00,'03091504','2023-03-09 15:05:37',5,'pos','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(189,'4','283','12','2023-03-09','','Ugostina','2348069536347',0.00,3680.00,'03091506','2023-03-09 15:07:46',5,'pos','','',3680.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(190,'4','283','12','2023-03-09','','Happiness','2348087698682',0.00,5000.00,'03091508','2023-03-09 15:09:38',5,'pos','','',5000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(191,'4','283','12','2023-03-09','','Ferguson','2348167737417',0.00,2000.00,'03091510','2023-03-09 15:11:33',5,'pos','','',2000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(192,'4','283','12','2023-03-09','','Madaki','2348035298908',0.00,2944.00,'03091512','2023-03-09 15:13:20',5,'pos','','',2944.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(193,'4','283','12','2023-03-09','','Godwin','2349061114887',0.00,2208.00,'03091514','2023-03-09 15:15:43',5,'pos','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(194,'4','283','12','2023-03-09','','Prince','2349039428791',0.00,4416.00,'03091516','2023-03-09 15:17:20',5,'pos','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(195,'4','283','12','2023-03-09','','Oga Bello','2347063252996',0.00,3680.00,'03091519','2023-03-09 15:23:04',5,'pos','','',3680.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(196,'4','283','12','2023-03-09','','Haj Aisha','2348166611718',0.00,13616.00,'03091526','2023-03-09 15:27:35',5,'pos','','',13616.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(197,'4','283','12','2023-03-09','','Hahama','2348059036410',0.00,5888.00,'03091528','2023-03-09 15:29:57',5,'pos','','',5888.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(198,'4','283','12','2023-03-09','','Faith Gerge','2349128337900',0.00,2944.00,'03091531','2023-03-09 15:34:13',5,'pos','','',2944.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(199,'4','283','12','2023-03-09','','Helen','2348038709803',0.00,9200.00,'03091536','2023-03-09 15:37:24',5,'pos','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(200,'4','283','12','2023-03-09','','Chima','2348138677774',0.00,2208.00,'03091539','2023-03-09 15:41:05',5,'pos','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(201,'4','283','12','2023-03-09','','Kone','2348055571474',0.00,7360.00,'03091541','2023-03-09 15:42:52',5,'pos','','',7360.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(202,'4','283','12','2023-03-09','','Segun','2348164924935',0.00,4416.00,'03091544','2023-03-09 15:45:26',5,'pos','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(205,'4','283','12','2023-03-09','','Anjela','2348060651683',0.00,4416.00,'03091557','2023-03-09 15:58:49',5,'pos','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(206,'4','283','12','2023-03-09','','Nafiu','2348108170009',0.00,5152.00,'03091557','2023-03-09 16:01:35',5,'pos','','',5152.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(207,'4','283','12','2023-03-09','','Fatima','2347016052775',0.00,9200.00,'03091604','2023-03-09 16:06:53',5,'pos','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(209,'4','283','12','2023-03-09','','Blessing Sunday','2348165026806',0.00,3680.00,'03091608','2023-03-09 16:10:41',5,'pos','','',3680.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(210,'4','283','12','2023-03-09','','Abdullahi Alasan','2348038140017',0.00,7360.00,'03091628','2023-03-09 16:29:55',5,'pos','','',7360.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(212,'4','283','12','2023-03-09','','Kabiru','2348039643096',0.00,1500.00,'03091632','2023-03-09 16:33:29',5,'pos','','',1500.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(213,'4','283','12','2023-03-09','','Mustapha Jibrin','2348137959945',0.00,15456.00,'03091636','2023-03-09 16:38:00',5,'pos','','',15456.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(214,'4','283','12','2023-03-09','','James','2349076445482',0.00,2944.00,'03091639','2023-03-09 16:40:06',5,'pos','','',2944.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(215,'4','283','12','2023-03-09','','Obadaki Mohd Mustapha','2347031116200',0.00,4416.00,'03091642','2023-03-09 16:45:28',5,'pos','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(216,'4','283','12','2023-03-09','','Khalid','2348068584048',0.00,27232.00,'03091647','2023-03-09 16:51:19',5,'pos','','',27232.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(217,'4','283','12','2023-03-09','','Babajide','2348088771940',0.00,4000.00,'03091653','2023-03-09 16:55:11',5,'pos','','',4000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(218,'4','283','12','2023-03-09','','Samson Ade','2348023110931',0.00,3680.00,'03091656','2023-03-09 17:05:56',5,'pos','','',3680.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(219,'4','283','12','2023-03-09','','Amanda','2347035148953',0.00,2208.00,'03091709','2023-03-09 17:11:47',5,'pos','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(220,'4','283','12','2023-03-09','','Bashir','2348165983044',0.00,4000.00,'03091713','2023-03-09 17:14:09',5,'pos','','',4000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(221,'4','283','12','2023-03-09','','Simon Terwase','2347033202343',0.00,5000.00,'03091718','2023-03-09 17:19:15',5,'pos','','',5000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(222,'4','283','12','2023-03-09','','Nasir Ibrahim','2348060841320',0.00,4416.00,'03091720','2023-03-09 17:21:24',5,'pos','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(223,'4','283','12','2023-03-09','','Abubakar Abdullahi','2349073626268',0.00,2208.00,'03091722','2023-03-09 17:23:29',5,'pos','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(224,'4','283','12','2023-03-09','','Sulaiman','2348063488224',0.00,8832.00,'03091724','2023-03-09 17:25:16',5,'pos','','',8832.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(225,'4','283','12','2023-03-09','','Jonson','2347065822778',0.00,9200.00,'03091726','2023-03-09 17:27:10',5,'pos','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(226,'4','283','12','2023-03-09','','Jerry Julius','2348132005919',0.00,1472.00,'03091729','2023-03-09 17:30:53',5,'pos','','',1472.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(227,'4','283','12','2023-03-09','','Mutapha Abdulmumini Magaji','2349129209982',0.00,1200.00,'03091732','2023-03-09 17:35:55',5,'pos','','',1200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(228,'4','283','12','2023-03-09','','Osita','2349165341966',0.00,1500.00,'03091737','2023-03-09 17:39:15',5,'pos','','',1500.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(229,'4','283','12','2023-03-09','','Yasir Sale','2349082615734',0.00,4416.00,'03091740','2023-03-09 17:41:49',5,'pos','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(230,'4','283','12','2023-03-09','','Ahmed Adamu','2348034575486',0.00,9200.00,'03091742','2023-03-09 17:43:51',5,'pos','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(231,'4','283','12','2023-03-09','','Saidu','2348034916479',0.00,2208.00,'03091748','2023-03-09 17:49:22',5,'pos','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(232,'4','283','12','2023-03-09','','Haj Aisha','2348147854011',0.00,2500.00,'03091750','2023-03-09 17:51:21',5,'pos','','',2500.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(233,'4','283','12','2023-03-09','','Adamu Shuaibu','2348143105504',0.00,4416.00,'03091752','2023-03-09 17:53:16',5,'pos','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(234,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,1000.00,'03100853','2023-03-10 08:59:54',5,'cash','','',1000.00,0.00,'gas','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(235,'4','283','13','2023-03-10','','ABDUL','2349049446337',0.00,6624.00,'03100918','2023-03-10 09:29:42',5,'pos','','',6624.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(236,'4','283','13','2023-03-10','','customer','2349035208461',0.00,9200.00,'03100931','2023-03-10 09:46:33',5,'cash','','',18400.00,9200.00,'gas','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(237,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,4416.00,'03100947','2023-03-10 09:48:09',5,'cash','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(238,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,13616.00,'03100949','2023-03-10 09:50:37',5,'cash','','',13616.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(239,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,3680.00,'03100951','2023-03-10 09:51:57',5,'cash','','',3680.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(240,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,2208.00,'03100952','2023-03-10 09:53:13',5,'cash','','',4416.00,2208.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(241,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,2000.00,'03100954','2023-03-10 09:54:59',5,'cash','','',4000.00,2000.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(243,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,4416.00,'03100957','2023-03-10 09:57:48',5,'cash','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(245,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,8096.00,'03100958','2023-03-10 09:58:55',5,'cash','','',16192.00,8096.00,'gas','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(246,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,2944.00,'03100959','2023-03-10 10:00:02',5,'cash','','',2944.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(247,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,1472.00,'03101001','2023-03-10 10:01:21',5,'cash','','',1472.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(248,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,8832.00,'03101002','2023-03-10 10:03:53',5,'cash','','',8832.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(249,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,2208.00,'03101004','2023-03-10 10:06:16',5,'cash','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(251,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,9200.00,'03101007','2023-03-10 10:07:48',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(252,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,1472.00,'03101008','2023-03-10 10:14:03',5,'cash','','',1472.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(253,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,4416.00,'03101015','2023-03-10 10:15:38',5,'cash','','',8832.00,4416.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(254,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,5000.00,'03101016','2023-03-10 10:17:06',5,'cash','','',5000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(255,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,4416.00,'03101018','2023-03-10 10:18:33',5,'cash','','',4416.00,0.00,'gas','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(257,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,9200.00,'03101019','2023-03-10 10:20:07',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(258,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,2208.00,'03101021','2023-03-10 10:23:37',5,'cash','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(259,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,9200.00,'03101024','2023-03-10 10:26:11',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(260,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,5000.00,'03101030','2023-03-10 10:39:41',5,'cash','','',5000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(262,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,2208.00,'03101041','2023-03-10 10:41:51',5,'cash','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(264,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,2000.00,'03101042','2023-03-10 10:45:11',5,'cash','','',2000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(266,'4','283','13','2023-03-10','2','SALUHU GAS','080357424300',0.00,71000.00,'03101047','2023-03-10 10:48:17',5,'cash','','',71000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(268,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,9200.00,'03101051','2023-03-10 10:51:48',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(269,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,1472.00,'03101053','2023-03-10 10:53:31',5,'cash','','',1472.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(270,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,9200.00,'03101054','2023-03-10 10:54:52',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(272,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,1000.00,'03101057','2023-03-10 10:57:53',5,'cash','','',1000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(273,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,6000.00,'03101101','2023-03-10 11:02:33',5,'cash','','',6000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(274,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,9200.00,'03101103','2023-03-10 11:05:07',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(275,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,2000.00,'03101105','2023-03-10 11:06:36',5,'cash','','',2000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(276,'4','283','13','2023-03-10','2','SALUHU GAS','080357424300',0.00,68160.00,'03101113','2023-03-10 11:13:33',5,'cash','','',68160.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(278,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,9200.00,'03101117','2023-03-10 11:18:16',5,'cash','','',18400.00,9200.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(280,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,2000.00,'03101125','2023-03-10 11:26:30',5,'cash','','',2000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(281,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,2200.00,'03101136','2023-03-10 11:39:12',5,'cash','','',6600.00,4400.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(283,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,3680.00,'03101148','2023-03-10 11:48:21',5,'cash','','',3680.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(284,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,6624.00,'03101149','2023-03-10 11:50:35',5,'cash','','',6624.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(286,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,1000.00,'03100902','2023-03-10 12:03:26',5,'cash','','',1000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(287,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,9200.00,'03101204','2023-03-10 12:07:48',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(289,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,3000.00,'03101209','2023-03-10 12:10:04',5,'cash','','',3000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(290,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,4000.00,'03101212','2023-03-10 12:22:40',5,'cash','','',4000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(292,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,2500.00,'03101223','2023-03-10 12:27:18',5,'cash','','',2500.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(293,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,3680.00,'03101228','2023-03-10 12:32:14',5,'cash','','',3680.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(294,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,2208.00,'03101233','2023-03-10 12:35:28',5,'cash','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(295,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,4416.00,'03101237','2023-03-10 12:50:32',5,'cash','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(296,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,18400.00,'03101251','2023-03-10 12:52:29',5,'cash','','',18400.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(297,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,2200.00,'03101253','2023-03-10 12:57:27',5,'cash','','',2200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(298,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,3000.00,'03101258','2023-03-10 13:08:09',5,'cash','','',3000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(300,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,9200.00,'03101310','2023-03-10 13:10:40',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(301,'4','283','13','2023-03-10','1','SABRIN GAS','08039702656',0.00,35500.00,'03101311','2023-03-10 13:13:39',5,'cash','','',35500.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(302,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,1472.00,'03101314','2023-03-10 13:15:13',5,'cash','','',1472.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(303,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,9200.00,'03101316','2023-03-10 13:18:00',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(304,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,4000.00,'03101320','2023-03-10 13:20:53',5,'cash','','',4000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(306,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,11408.00,'03101321','2023-03-10 13:23:32',5,'cash','','',11408.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(307,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,8832.00,'03101324','2023-03-10 14:10:19',5,'cash','','',8832.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(308,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,2208.00,'03101411','2023-03-10 14:21:45',5,'cash','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(309,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,2208.00,'03101422','2023-03-10 14:23:09',5,'cash','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(310,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,5000.00,'03101424','2023-03-10 14:25:48',5,'cash','','',5000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(311,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,4416.00,'03101427','2023-03-10 14:28:24',5,'cash','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(312,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,9200.00,'03101429','2023-03-10 14:47:05',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(313,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,9200.00,'03101448','2023-03-10 14:48:35',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(315,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,11408.00,'03101454','2023-03-10 14:54:55',5,'cash','','',11408.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(316,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,2944.00,'03101456','2023-03-10 15:06:13',5,'cash','','',2944.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(318,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,9200.00,'03101507','2023-03-10 15:07:53',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(321,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,2000.00,'03101508','2023-03-10 15:09:32',5,'cash','','',2000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(322,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,12880.00,'03101543','2023-03-10 15:47:17',5,'cash','','',12880.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(324,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,3680.00,'03101548','2023-03-10 15:49:10',5,'cash','','',3680.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(325,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,4416.00,'03101550','2023-03-10 15:58:12',5,'cash','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(327,'4','283','13','2023-03-10','','customer','2349035208461',0.00,2208.00,'03101559','2023-03-10 16:15:21',5,'cash','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(329,'4','283','13','2023-03-10','','customer','2349035208461',0.00,7360.00,'03101616','2023-03-10 16:17:21',5,'cash','','',7360.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(330,'4','283','13','2023-03-10','','customer','2349035208461',0.00,2300.00,'03101618','2023-03-10 16:19:33',5,'cash','','',2300.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(331,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,8832.00,'03101621','2023-03-10 16:22:14',5,'cash','','',8832.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(332,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,9200.00,'03101622','2023-03-10 16:23:18',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(333,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,3680.00,'03101624','2023-03-10 16:24:48',5,'cash','','',3680.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(334,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,9200.00,'03101625','2023-03-10 16:33:55',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(335,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,4416.00,'03101637','2023-03-10 16:37:49',5,'cash','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(336,'4','283','13','2023-03-10','','MARYAM','2349035208461',0.00,3000.00,'03101638','2023-03-10 16:39:08',5,'cash','','',3000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(337,'4','283','13','2023-03-10','4','SENIOR GAS','08068826955',0.00,35500.00,'03101733','2023-03-10 17:35:35',5,'cash','','',35500.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(339,'4','283','14','2023-03-11','','MARYAM','2349035208461',0.00,4416.00,'03110849','2023-03-11 09:44:41',5,'pos','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(340,'4','283','14','2023-03-11','','Ojoma','2348030310630',0.00,2208.00,'03110959','2023-03-11 10:53:39',5,'bank','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(342,'4','283','14','2023-03-11','','Don','2349077979777',0.00,2208.00,'03111055','2023-03-11 10:56:52',5,'pos','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(344,'4','283','14','2023-03-11','','Kabiru Sani Baban Gwari','2348033324400',0.00,5300.00,'03111122','2023-03-11 11:24:18',5,'pos','','',5300.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(345,'4','283','14','2023-03-11','','Nnamdi ','2348102351333',0.00,5888.00,'03111126','2023-03-11 11:27:14',5,'pos','','',5888.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(346,'4','283','14','2023-03-11','','Mohd','2348169207771',0.00,1500.00,'03111130','2023-03-11 11:32:17',5,'pos','','',1500.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(347,'4','283','14','2023-03-11','','Chidi','2348036924449',0.00,9200.00,'03111135','2023-03-11 11:36:14',5,'pos','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(348,'4','283','14','2023-03-11','','Mohd Ibrahim','2348065531922',0.00,4000.00,'03111139','2023-03-11 11:40:13',5,'pos','','',4000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(349,'4','283','14','2023-03-11','','Boy Mata Bitrus','2347035702999',0.00,2944.00,'03111142','2023-03-11 11:44:08',5,'pos','','',2944.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(350,'4','283','14','2023-03-11','','Frances Eka','2348032874131',0.00,4416.00,'03111145','2023-03-11 11:55:28',5,'pos','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(351,'4','283','14','2023-03-11','','Kingsley','2349070584938',0.00,4416.00,'03111200','2023-03-11 12:01:52',5,'pos','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(352,'4','283','14','2023-03-11','','Beki','2348115642335',0.00,1472.00,'03111202','2023-03-11 12:19:39',5,'pos','','',1472.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(353,'4','283','14','2023-03-11','','Abdulmunaf Ado Bala','2348032704092',0.00,9200.00,'03111221','2023-03-11 12:23:28',5,'pos','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(354,'4','283','14','2023-03-11','','Chinyere','2348028619772',0.00,9200.00,'03111225','2023-03-11 12:26:19',5,'pos','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(355,'4','283','14','2023-03-11','','Faith','2348169190050',0.00,1000.00,'03111227','2023-03-11 12:28:24',5,'pos','','',1000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(356,'4','283','14','2023-03-11','','Bima Maaruf','2349132188153',0.00,2208.00,'03111230','2023-03-11 12:31:27',5,'pos','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(357,'4','283','14','2023-03-11','','Levi Akalonu','2347033903766',0.00,5000.00,'03111233','2023-03-11 12:34:36',5,'pos','','',5000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(358,'4','283','14','2023-03-11','','Joshua Nanbol','2348130072066',0.00,736.00,'03111235','2023-03-11 12:36:54',5,'pos','','',736.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(359,'4','283','14','2023-03-11','','Abdussalamu','2347012735904',0.00,3000.00,'03111244','2023-03-11 12:45:58',5,'pos','','',3000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(360,'4','283','14','2023-03-11','','Mohd Abdullatif','2348036585503',0.00,2208.00,'03111248','2023-03-11 12:52:12',5,'pos','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(361,'4','283','14','2023-03-11','','Gopan','2349099151002',0.00,9200.00,'03111253','2023-03-11 12:54:36',5,'pos','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(362,'4','283','14','2023-03-11','','Alexandra','2348030636179',0.00,9568.00,'03111258','2023-03-11 12:59:25',5,'pos','','',9568.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(363,'4','283','14','2023-03-11','','Emmanuel','2347039638171',0.00,11040.00,'03111300','2023-03-11 13:01:32',5,'pos','','',11040.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(364,'4','283','14','2023-03-11','','Abdullahi Gas','2348132442894',0.00,35500.00,'03111307','2023-03-11 13:11:48',5,'pos','','',35500.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(365,'4','283','14','2023-03-11','','Sani Panisau','2347030743030',0.00,9200.00,'03111312','2023-03-11 13:13:34',5,'pos','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(366,'4','283','14','2023-03-11','','Faith Hardison','2349075044392',0.00,9200.00,'03111315','2023-03-11 13:17:20',5,'pos','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(367,'4','283','14','2023-03-11','','Merrit','2349061646064',0.00,9200.00,'03111325','2023-03-11 13:27:04',5,'pos','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(368,'4','283','14','2023-03-11','','Abigail Jamilu','2349073090467',0.00,6624.00,'03111334','2023-03-11 13:35:14',5,'pos','','',6624.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(369,'4','283','14','2023-03-11','','Salisu','2348063246342',0.00,5000.00,'03111342','2023-03-11 13:43:50',5,'pos','','',5000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(370,'4','283','14','2023-03-11','','David','2348065416980',0.00,1472.00,'03111345','2023-03-11 13:47:45',5,'pos','','',1472.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(371,'4','283','14','2023-03-11','','Adiola Ajaye','2349062499468',0.00,9200.00,'03111349','2023-03-11 13:51:11',5,'pos','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(372,'4','283','14','2023-03-11','','Mahmood','2348133816638',0.00,1472.00,'03111355','2023-03-11 13:56:45',5,'pos','','',1472.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(373,'4','283','14','2023-03-11','','David','2348065416980',0.00,2208.00,'03111359','2023-03-11 14:00:34',5,'pos','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(375,'4','283','14','2023-03-11','','Penelope','2348060358143',0.00,4416.00,'03111401','2023-03-11 14:03:19',5,'pos','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(376,'4','283','14','2023-03-11','','Habiba ','2348106354753',0.00,3680.00,'03111404','2023-03-11 14:05:34',5,'pos','','',3680.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(377,'4','283','14','2023-03-11','','Emmanuel','2347035994441',0.00,8832.00,'03111419','2023-03-11 14:19:52',5,'pos','','',8832.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(378,'4','283','14','2023-03-11','','Jude Emeh','2348037036942',0.00,9200.00,'03111420','2023-03-11 14:21:35',5,'pos','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(379,'4','283','14','2023-03-11','','Grease','2348085946969',0.00,2208.00,'03111423','2023-03-11 14:24:24',5,'pos','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(380,'4','283','14','2023-03-11','','Kabiru Bala','2348035875878',0.00,9200.00,'03111425','2023-03-11 14:27:04',5,'pos','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(381,'4','283','14','2023-03-11','','Izzuddeen','2348038862090',0.00,2130.00,'03111429','2023-03-11 14:30:31',5,'pos','','',2130.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(382,'4','283','14','2023-03-11','','Jamilu Mohd Fage','2348069242616',0.00,2208.00,'03111431','2023-03-11 14:32:39',5,'pos','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(383,'4','283','14','2023-03-11','','Akindele','2348150865888',0.00,2944.00,'03111434','2023-03-11 14:35:38',5,'pos','','',2944.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(384,'4','283','14','2023-03-11','','Ashar','2348178011762',0.00,5152.00,'03111437','2023-03-11 14:38:11',5,'pos','','',5152.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(385,'4','283','14','2023-03-11','','Kodelia','2347031681688',0.00,9200.00,'03111439','2023-03-11 14:42:20',5,'pos','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(386,'4','283','14','2023-03-11','','Lillian','2347037886315',0.00,9200.00,'03111444','2023-03-11 14:45:55',5,'pos','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(387,'4','283','14','2023-03-11','','James','2348067762055',0.00,2000.00,'03111454','2023-03-11 14:56:31',5,'pos','','',2000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(388,'4','283','14','2023-03-11','','Kayinde','2347062021542',0.00,8832.00,'03111458','2023-03-11 15:00:12',5,'pos','','',8832.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(389,'4','283','14','2023-03-11','','Idris Nasiru','2348060305970',0.00,7360.00,'03111510','2023-03-11 15:12:23',5,'pos','','',7360.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(390,'4','283','14','2023-03-11','','Mr Charlse','2348036014479',0.00,9200.00,'03111520','2023-03-11 15:22:16',5,'pos','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(391,'4','283','14','2023-03-11','','Hassan Mahmud','2348178595366',0.00,4416.00,'03111532','2023-03-11 15:33:27',5,'pos','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(392,'4','283','14','2023-03-11','','uwalu Usman','2348098700187',0.00,4416.00,'03111540','2023-03-11 15:41:31',5,'pos','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(393,'4','283','14','2023-03-11','','Rafa\'t Yusuf','2347035211662',0.00,2944.00,'03111543','2023-03-11 15:44:04',5,'pos','','',2944.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(394,'4','283','14','2023-03-11','','Mustapha Shegun','2347031612173',0.00,4400.00,'03111547','2023-03-11 15:48:05',5,'pos','','',4400.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(395,'4','283','14','2023-03-11','','Hyacinth Sunday','2348065531130',0.00,4500.00,'03111549','2023-03-11 15:50:12',5,'pos','','',9000.00,4500.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(396,'4','283','14','2023-03-11','','Fatima','2349122882693',0.00,1500.00,'03111551','2023-03-11 15:52:28',5,'pos','','',1500.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(397,'4','283','14','2023-03-11','','Yusuf Abubakar','2348035587085',0.00,3680.00,'03111553','2023-03-11 15:54:48',5,'pos','','',3680.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(398,'4','283','14','2023-03-11','','Surajo Nasidi Saleh','2347047977753',0.00,3680.00,'03111555','2023-03-11 15:56:33',5,'pos','','',3680.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(399,'4','283','14','2023-03-11','','Abdullahi Sani','2347067029083',0.00,1000.00,'03111557','2023-03-11 15:59:44',5,'pos','','',1000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(400,'4','283','14','2023-03-11','','Louys','2348065456183',0.00,8832.00,'03111600','2023-03-11 16:01:38',5,'pos','','',8832.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(401,'4','283','14','2023-03-11','','Agata Tehembam','2348168962375',0.00,2208.00,'03111602','2023-03-11 16:03:38',5,'pos','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(403,'4','283','14','2023-03-11','','Ahmed Muyiddeen','2348039432176',0.00,4000.00,'03111608','2023-03-11 16:09:17',5,'pos','','',4000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(404,'4','283','14','2023-03-11','','Aisha','2348145334903',0.00,4416.00,'03111616','2023-03-11 16:18:16',5,'pos','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(405,'4','283','14','2023-03-11','','Akim','2349114527519',0.00,8096.00,'03111619','2023-03-11 16:21:06',5,'pos','','',8096.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(406,'4','283','14','2023-03-11','','Isma\'il Sule','2348099326361',0.00,9200.00,'03111622','2023-03-11 16:23:08',5,'pos','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(407,'4','283','14','2023-03-11','','Yakubu','2348032077089',0.00,5000.00,'03111627','2023-03-11 16:28:12',5,'pos','','',5000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(408,'4','283','14','2023-03-11','','Mr. John','2348063123171',0.00,3000.00,'03111630','2023-03-11 16:31:30',5,'pos','','',3000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(409,'4','283','14','2023-03-11','','Auwal Abdullahi','2348034037380',0.00,8832.00,'03111633','2023-03-11 16:35:09',5,'pos','','',8832.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(410,'4','283','14','2023-03-11','','Veronica Valantine','2347032342808',0.00,9200.00,'03111637','2023-03-11 16:39:16',5,'pos','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(411,'4','283','14','2023-03-11','','Mustapha Muazu','2349025342607',0.00,9200.00,'03111641','2023-03-11 16:42:07',5,'pos','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(412,'4','283','14','2023-03-11','','Samuel','2348036305621',0.00,3680.00,'03111644','2023-03-11 16:46:00',5,'pos','','',3680.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(413,'4','283','14','2023-03-11','','Marcos','2347036109067',0.00,5000.00,'03111647','2023-03-11 16:48:13',5,'pos','','',5000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(414,'4','283','14','2023-03-11','','Saihana Rabi\'u','2348032781617',0.00,8832.00,'03111650','2023-03-11 16:52:08',5,'pos','','',8832.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(415,'4','283','14','2023-03-11','','Auwalu Ibrahim','2348093423478',0.00,3680.00,'03111653','2023-03-11 16:54:31',5,'pos','','',3680.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(416,'4','283','14','2023-03-11','','Chuks Prince','2348065902673',0.00,4416.00,'03111655','2023-03-11 17:03:19',5,'pos','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(417,'4','283','14','2023-03-11','','Oga Musa','2348054271778',0.00,4416.00,'03111704','2023-03-11 17:06:19',5,'pos','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(418,'4','283','14','2023-03-11','','Vera','2348034544722',0.00,9200.00,'03111709','2023-03-11 17:09:59',5,'pos','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(419,'4','283','14','2023-03-11','','Justina Omon','2348025874728',0.00,1500.00,'03111711','2023-03-11 17:14:11',5,'pos','','',1500.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(420,'4','283','14','2023-03-11','','Adebayo','2348065727285',0.00,2208.00,'03111716','2023-03-11 17:17:03',5,'pos','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(421,'4','283','14','2023-03-11','','Bello Sulaiman','2348036156246',0.00,1472.00,'03111718','2023-03-11 17:19:59',5,'pos','','',1472.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(422,'4','283','14','2023-03-11','','Kingslely','2348132288373',0.00,9200.00,'03111720','2023-03-11 17:21:56',5,'pos','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(423,'4','283','14','2023-03-11','','Mohd Jude','2348065529827',0.00,9200.00,'03111727','2023-03-11 17:28:35',5,'pos','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(424,'4','283','14','2023-03-11','','Chiamaka ','2347032799234',0.00,6624.00,'03111729','2023-03-11 17:30:13',5,'pos','','',6624.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(425,'4','283','14','2023-03-11','','Felicia','2348034812727',0.00,2208.00,'03111733','2023-03-11 17:34:36',5,'pos','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(426,'4','283','14','2023-03-11','','Oga Idris Baba Indomie','2347066212838',0.00,9200.00,'03111736','2023-03-11 17:37:31',5,'pos','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(427,'4','283','14','2023-03-11','','Justine','2348034134899',0.00,2944.00,'03111739','2023-03-11 17:40:20',5,'pos','','',2944.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(428,'4','283','14','2023-03-11','','Abubakar Mustapha Ahmad','2348038624888',0.00,2208.00,'03111741','2023-03-11 17:42:52',5,'pos','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(429,'4','283','14','2023-03-11','','Ali Saidu','2348103878727',0.00,2208.00,'03111745','2023-03-11 17:47:38',5,'pos','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(430,'4','283','14','2023-03-11','','Ishaya','2348063867599',0.00,4416.00,'03111749','2023-03-11 17:51:29',5,'pos','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(431,'4','283','14','2023-03-11','','Inuwa Shuaibu','2348138135752',0.00,4416.00,'03111756','2023-03-11 17:57:40',5,'pos','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(432,'4','283','15','2023-03-12','','MARYAM','2349035208461',0.00,3000.00,'03121034','2023-03-12 10:35:27',5,'cash','','',3000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(433,'4','283','15','2023-03-12','','customer','2349035208461',0.00,3000.00,'03121036','2023-03-12 10:41:14',5,'cash','','',3000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(435,'4','283','15','2023-03-12','','MARYAM','2349035208461',0.00,3680.00,'03121042','2023-03-12 10:43:17',5,'cash','','',7360.00,3680.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(436,'4','283','15','2023-03-12','','MARYAM','2349035208461',0.00,2208.00,'03121044','2023-03-12 10:48:25',5,'cash','','',4416.00,2208.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(437,'4','283','15','2023-03-12','','MARYAM','2349035208461',0.00,9200.00,'03121049','2023-03-12 11:05:14',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(438,'4','283','15','2023-03-12','','MARYAM','2349035208461',0.00,3680.00,'03121106','2023-03-12 11:06:37',5,'cash','','',3680.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(440,'4','283','15','2023-03-12','','MARYAM','2349035208461',0.00,4416.00,'03121107','2023-03-12 11:08:14',5,'cash','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(441,'4','283','15','2023-03-12','','MARYAM','2349035208461',0.00,9200.00,'03121109','2023-03-12 11:10:06',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(442,'4','283','15','2023-03-12','','MARYAM','2349035208461',0.00,7500.00,'03121111','2023-03-12 11:12:50',5,'cash','','',7500.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(443,'4','283','15','2023-03-12','','MARYAM','2349035208461',0.00,8832.00,'03121113','2023-03-12 11:14:11',5,'cash','','',17664.00,8832.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(444,'4','283','15','2023-03-12','','MARYAM','2349035208461',0.00,2208.00,'03121115','2023-03-12 11:16:02',5,'cash','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(445,'4','283','15','2023-03-12','','MARYAM','2349035208461',0.00,9200.00,'03121117','2023-03-12 11:26:26',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(446,'4','283','15','2023-03-12','','customer','2349035208461',0.00,4416.00,'03121127','2023-03-12 11:31:20',5,'cash','','',8832.00,4416.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(447,'4','283','15','2023-03-12','','MARYAM','2349035208461',0.00,1500.00,'03121132','2023-03-12 11:33:39',5,'cash','','',1500.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(451,'4','283','15','2023-03-12','','MARYAM','2349035208461',0.00,1472.00,'03121135','2023-03-12 11:38:44',5,'cash','','',1472.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(452,'4','283','15','2023-03-12','','MARYAM','2349035208461',0.00,2208.00,'03121139','2023-03-12 11:40:15',5,'cash','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(454,'4','283','15','2023-03-12','','MARYAM','2349035208461',0.00,9200.00,'03121140','2023-03-12 11:42:40',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(455,'4','283','15','2023-03-12','','MARYAM','2349035208461',0.00,1000.00,'03121144','2023-03-12 11:45:05',5,'cash','','',2000.00,1000.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(456,'4','283','15','2023-03-12','','MARYAM','2349035208461',0.00,2944.00,'03121145','2023-03-12 11:46:47',5,'cash','','',2944.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(459,'4','283','15','2023-03-12','','MARYAM','2349035208461',0.00,11776.00,'03121149','2023-03-12 11:52:15',5,'cash','','',11776.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(461,'4','283','15','2023-03-12','','MARYAM','2349035208461',0.00,8000.00,'03121155','2023-03-12 11:55:24',5,'cash','','',8000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(462,'4','283','15','2023-03-12','','MARYAM','2349035208461',0.00,9200.00,'03121200','2023-03-12 12:01:16',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(463,'4','283','15','2023-03-12','','MARYAM','2349035208461',0.00,1500.00,'03121202','2023-03-12 12:04:16',5,'cash','','',4500.00,3000.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(465,'4','283','15','2023-03-12','','MARYAM','2349035208461',0.00,7360.00,'03121205','2023-03-12 12:06:15',5,'cash','','',7360.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(466,'4','283','15','2023-03-12','','MARYAM','2349035208461',0.00,4416.00,'03121207','2023-03-12 12:07:43',5,'cash','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(468,'4','283','15','2023-03-12','','MARYAM','2349035208461',0.00,3680.00,'03121209','2023-03-12 12:09:34',5,'cash','','',3680.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(469,'4','283','15','2023-03-12','','MARYAM','2349035208461',0.00,8832.00,'03121210','2023-03-12 12:11:03',5,'cash','','',8832.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(471,'4','283','15','2023-03-12','','MARYAM','2349035208461',0.00,2208.00,'03121211','2023-03-12 12:12:59',5,'cash','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(472,'4','283','15','2023-03-12','','MARYAM','2349035208461',0.00,4416.00,'03121215','2023-03-12 12:17:04',5,'cash','','',8832.00,4416.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(474,'4','283','15','2023-03-12','','MARYAM','2349035208461',0.00,1400.00,'03121220','2023-03-12 12:21:07',5,'cash','','',1400.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(475,'4','283','15','2023-03-12','','MARYAM','2349035208461',0.00,12144.00,'03121225','2023-03-12 12:26:21',5,'cash','','',24288.00,12144.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(476,'4','283','15','2023-03-12','','MARYAM','2349035208461',0.00,2200.00,'03121227','2023-03-12 12:28:03',5,'cash','','',4400.00,2200.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(479,'4','283','15','2023-03-12','','MARYAM','2349035208461',0.00,3000.00,'03121229','2023-03-12 12:31:40',5,'cash','','',6000.00,3000.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(480,'4','283','15','2023-03-12','','MARYAM','2349035208461',0.00,4416.00,'03121232','2023-03-12 12:33:06',5,'cash','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(481,'4','283','15','2023-03-12','','MARYAM','2349035208461',0.00,9568.00,'03121235','2023-03-12 12:36:01',5,'cash','','',19136.00,9568.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(483,'4','283','15','2023-03-12','','MARYAM','2349035208461',0.00,4416.00,'03121236','2023-03-12 12:37:02',5,'cash','','',8832.00,4416.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(484,'4','283','15','2023-03-12','','MARYAM','2349035208461',0.00,8832.00,'03121238','2023-03-12 12:38:34',5,'cash','','',8832.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(487,'4','283','15','2023-03-12','','MARYAM','2349035208461',0.00,4416.00,'03121240','2023-03-12 12:40:27',5,'cash','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(489,'4','283','15','2023-03-12','','MARYAM','2349035208461',0.00,9200.00,'03121243','2023-03-12 12:47:42',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(490,'4','283','15','2023-03-12','','MARYAM','2349035208461',0.00,8832.00,'03121248','2023-03-12 12:49:09',5,'cash','','',26496.00,17664.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(491,'4','283','15','2023-03-12','','MARYAM','2349035208461',0.00,13616.00,'03121251','2023-03-12 12:52:33',5,'cash','','',13616.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(492,'4','283','15','2023-03-12','','MARYAM','2349035208461',0.00,9200.00,'03121256','2023-03-12 12:56:57',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(493,'4','283','15','2023-03-12','','MARYAM','2349035208461',0.00,2208.00,'03121258','2023-03-12 12:59:33',5,'cash','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(495,'4','283','15','2023-03-12','','Daniel','2347031614177',0.00,2000.00,'03121301','2023-03-12 13:07:16',5,'pos','','',2000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(496,'4','283','15','2023-03-12','','Mohd Abdullatif','2348036585503',0.00,6624.00,'03121308','2023-03-12 13:09:58',5,'pos','','',6624.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(497,'4','283','15','2023-03-12','','Smart Emmanuel','2347037431770',0.00,2208.00,'03121313','2023-03-12 13:14:25',5,'pos','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(499,'4','283','15','2023-03-12','','Busayu','2348030855950',0.00,6000.00,'03121315','2023-03-12 13:16:57',5,'pos','','',6000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(500,'4','283','15','2023-03-12','','Khadijat','2348037867837',0.00,3680.00,'03121318','2023-03-12 13:19:32',5,'pos','','',3680.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(501,'4','283','15','2023-03-12','','Oga Abubakar','2348065558932',0.00,5888.00,'03121320','2023-03-12 13:22:19',5,'pos','','',5888.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(504,'4','283','15','2023-03-12','','Fardausi Aminu','2347066039578',0.00,4416.00,'03121323','2023-03-12 13:25:49',5,'pos','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(505,'4','283','15','2023-03-12','','Abba','2347062450666',0.00,17750.00,'03121330','2023-03-12 13:32:16',5,'pos','','',17750.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(508,'4','283','15','2023-03-12','','Abba','2347060450666',0.00,44020.00,'03121343','2023-03-12 13:45:08',5,'pos','','',44020.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(509,'4','283','15','2023-03-12','','Mr. Abbas Sunusi','2348095379330',0.00,1472.00,'03121401','2023-03-12 14:09:12',5,'pos','','',1472.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(510,'4','283','15','2023-03-12','','Merry','2347030629919',0.00,2208.00,'03121410','2023-03-12 14:11:23',5,'pos','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(511,'4','283','15','2023-03-12','','Khadijat','2348037867837',0.00,736.00,'03121413','2023-03-12 14:14:26',5,'pos','','',736.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(512,'4','283','15','2023-03-12','','John Chukuemeka','2348131549171',0.00,9200.00,'03121420','2023-03-12 14:22:12',5,'pos','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(513,'4','283','15','2023-03-12','','Bolade','2348167450233',0.00,1472.00,'03121423','2023-03-12 14:26:24',5,'pos','','',1472.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(514,'4','283','15','2023-03-12','','Mustapha','2348060619758',0.00,736.00,'03121427','2023-03-12 14:29:37',5,'cash','','',736.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(515,'4','283','15','2023-03-12','','Gebriel Simon','2348037467874',0.00,4416.00,'03121431','2023-03-12 14:52:04',5,'pos','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(516,'4','283','15','2023-03-12','','Friday','2348067438826',0.00,2000.00,'03121453','2023-03-12 15:22:38',5,'pos','','',2000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(518,'4','283','15','2023-03-12','','Abdulaziz Afolabi','2347034227596',0.00,7400.00,'03121524','2023-03-12 15:26:21',5,'cash','','',7400.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(519,'4','283','15','2023-03-12','','Concilia','2348035831696',0.00,9200.00,'03121527','2023-03-12 15:28:49',5,'pos','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(520,'4','283','15','2023-03-12','','Babawo','2348029808616',0.00,2000.00,'03121530','2023-03-12 15:30:39',5,'pos','','',2000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(523,'4','283','15','2023-03-12','','Crist','2349164146406',0.00,4416.00,'03121537','2023-03-12 15:40:37',5,'pos','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(525,'4','283','15','2023-03-12','','Nasir','2348137946464',0.00,2208.00,'03121541','2023-03-12 15:42:27',5,'pos','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(526,'4','283','15','2023-03-12','','Moma Sunday Felix','2348033898143',0.00,4416.00,'03121543','2023-03-12 15:44:32',5,'pos','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(527,'4','283','15','2023-03-12','','Mohd Umar','2349061186541',0.00,1472.00,'03121545','2023-03-12 15:54:05',5,'pos','','',1472.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(528,'4','283','15','2023-03-12','','Adekunle','2348060349049',0.00,3680.00,'03121600','2023-03-12 16:02:51',5,'bank','','',3680.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(529,'4','283','15','2023-03-12','','Sam','2348034519430',0.00,4416.00,'03121604','2023-03-12 16:05:00',5,'pos','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(531,'4','283','15','2023-03-12','','Blessing','2348032970350',0.00,9200.00,'03121619','2023-03-12 16:20:39',5,'pos','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(532,'4','283','15','2023-03-12','','pat','2348076778099',0.00,4416.00,'03121626','2023-03-12 16:29:59',5,'pos','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(533,'4','283','15','2023-03-12','','Mustapha Muazu','2349025342607',0.00,8875.00,'03121631','2023-03-12 16:32:11',5,'pos','','',8875.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(534,'4','283','15','2023-03-12','','Gift','2349123809995',0.00,4000.00,'03121634','2023-03-12 16:36:46',5,'pos','','',4000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(535,'4','283','15','2023-03-12','','Mohd Shitu','2347036713974',0.00,9200.00,'03121639','2023-03-12 16:40:26',5,'pos','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(536,'4','283','16','2023-03-13','2','SALUHU GAS','080357424300',0.00,40825.00,'03130819','2023-03-13 08:21:31',5,'cash','','',40825.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(537,'4','283','16','2023-03-13','','MARYAM','2349035208461',0.00,9200.00,'03130823','2023-03-13 08:23:28',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(538,'4','283','16','2023-03-13','','MARYAM','2349035208461',0.00,4000.00,'03130824','2023-03-13 08:24:59',5,'cash','','',4000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(540,'4','283','16','2023-03-13','4','SENIOR GAS','08068826955',0.00,3550.00,'03130828','2023-03-13 08:29:05',5,'cash','','',3550.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(541,'4','283','16','2023-03-13','','MARYAM','2349035208461',0.00,6624.00,'03130830','2023-03-13 08:32:31',5,'cash','','',6624.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(542,'4','283','16','2023-03-13','','customer','2349035208461',0.00,3680.00,'03130833','2023-03-13 08:33:52',5,'cash','','',3680.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(544,'4','283','16','2023-03-13','','customer','2349035208461',0.00,5152.00,'03130834','2023-03-13 08:35:02',5,'cash','','',10304.00,5152.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(545,'4','283','16','2023-03-13','','customer','2349035208461',0.00,9200.00,'03130836','2023-03-13 08:37:00',5,'cash','','',18400.00,9200.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(547,'4','283','16','2023-03-13','','customer','2349035208461',0.00,736.00,'03130838','2023-03-13 08:39:36',5,'cash','','',736.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(548,'4','283','16','2023-03-13','','customer','2349035208461',0.00,1000.00,'03130840','2023-03-13 08:41:18',5,'cash','','',1000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(549,'4','283','16','2023-03-13','','customer','2349035208461',0.00,12880.00,'03130842','2023-03-13 08:45:00',5,'cash','','',12880.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(550,'4','283','16','2023-03-13','','MARYAM','2349035208461',0.00,2208.00,'03130845','2023-03-13 08:46:25',5,'cash','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(551,'4','283','16','2023-03-13','','customer','2349035208461',0.00,4416.00,'03130847','2023-03-13 08:48:05',5,'cash','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(552,'4','283','16','2023-03-13','','customer','2349035208461',0.00,2208.00,'03130849','2023-03-13 08:49:36',5,'cash','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(553,'4','283','16','2023-03-13','','MARYAM','2349035208461',0.00,8832.00,'03130850','2023-03-13 08:50:52',5,'cash','','',8832.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(554,'4','283','16','2023-03-13','','MARYAM','2349035208461',0.00,2208.00,'03130851','2023-03-13 08:52:28',5,'cash','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(555,'4','283','16','2023-03-13','','MARYAM','2349035208461',0.00,5888.00,'03130853','2023-03-13 08:54:51',5,'cash','','',5888.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(556,'4','283','16','2023-03-13','','MARYAM','2349035208461',0.00,3000.00,'03130856','2023-03-13 08:56:38',5,'cash','','',3000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(557,'4','283','16','2023-03-13','','customer','2349035208461',0.00,2250.00,'03130858','2023-03-13 09:00:57',5,'cash','','',2250.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(558,'4','283','16','2023-03-13','','customer','2349035208461',0.00,1300.00,'03130905','2023-03-13 09:12:18',5,'cash','','',1300.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(561,'4','283','16','2023-03-13','','MARYAM','2349035208461',0.00,2208.00,'03130922','2023-03-13 09:25:06',5,'cash','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(562,'4','283','16','2023-03-13','','customer','2349035208461',0.00,3680.00,'03130926','2023-03-13 09:29:15',5,'cash','','',3680.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(563,'4','283','16','2023-03-13','','customer','2349035208461',0.00,1000.00,'03130932','2023-03-13 09:34:28',5,'cash','','',1000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(564,'4','283','16','2023-03-13','','customer','2349035208461',0.00,7360.00,'03130936','2023-03-13 09:37:02',5,'cash','','',7360.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(565,'4','283','16','2023-03-13','','MARYAM','2349035208461',0.00,1000.00,'03130943','2023-03-13 09:55:57',5,'cash','','',1000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(566,'4','283','16','2023-03-13','','customer','2349035208461',0.00,5000.00,'03130957','2023-03-13 09:59:37',5,'cash','','',5000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(567,'4','283','16','2023-03-13','','customer','2349035208461',0.00,4416.00,'03131000','2023-03-13 10:16:31',5,'cash','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(569,'4','283','16','2023-03-13','','MARYAM','2349035208461',0.00,8832.00,'03131018','2023-03-13 10:18:26',5,'cash','','',8832.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(570,'4','283','16','2023-03-13','','customer','2349035208461',0.00,368.00,'03131019','2023-03-13 10:27:14',5,'cash','','',368.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(571,'4','283','16','2023-03-13','','MARYAM','2349035208461',0.00,9200.00,'03131028','2023-03-13 10:43:43',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(572,'4','283','16','2023-03-13','','customer','2349035208461',0.00,2000.00,'03131044','2023-03-13 10:48:12',5,'cash','','',2000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(573,'4','283','16','2023-03-13','','MARYAM','2349035208461',0.00,2500.00,'03131049','2023-03-13 10:49:48',5,'cash','','',2500.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(574,'4','283','16','2023-03-13','','MARYAM','2349035208461',0.00,9200.00,'03131052','2023-03-13 11:23:04',5,'cash','','',18400.00,9200.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(575,'4','283','16','2023-03-13','','customer','2349035208461',0.00,4416.00,'03131124','2023-03-13 11:26:19',5,'cash','','',8832.00,4416.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(576,'4','283','16','2023-03-13','','customer','2349035208461',0.00,4416.00,'03131153','2023-03-13 12:16:12',5,'cash','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(577,'4','283','16','2023-03-13','','MARYAM','2349035208461',0.00,1500.00,'03131218','2023-03-13 12:32:21',5,'cash','','',1500.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(579,'4','283','16','2023-03-13','','customer','2349035208461',0.00,4500.00,'03131234','2023-03-13 12:39:41',5,'cash','','',4500.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(581,'4','283','16','2023-03-13','','MARYAM','2349035208461',0.00,1472.00,'03131240','2023-03-13 12:41:10',5,'cash','','',1472.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(583,'4','283','16','2023-03-13','','MARYAM','2349035208461',0.00,4416.00,'03131242','2023-03-13 12:46:08',5,'cash','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(584,'4','283','16','2023-03-13','','customer','2349035208461',0.00,1472.00,'03131246','2023-03-13 12:47:23',5,'cash','','',1472.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(585,'4','283','16','2023-03-13','','customer','2349035208461',0.00,9200.00,'03131248','2023-03-13 12:50:21',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(586,'4','283','16','2023-03-13','4','SENIOR GAS','08068826955',0.00,7100.00,'03131254','2023-03-13 12:55:25',5,'cash','','',7100.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(587,'4','283','16','2023-03-13','','MARYAM','2349035208461',0.00,9200.00,'03131305','2023-03-13 13:06:13',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(588,'4','283','16','2023-03-13','2','SALUHU GAS','080357424300',0.00,35500.00,'03131319','2023-03-13 13:19:51',5,'cash','','',35500.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(589,'4','283','16','2023-03-13','2','SALUHU GAS','080357424300',0.00,68870.00,'03131321','2023-03-13 13:22:02',5,'cash','','',68870.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(591,'4','283','16','2023-03-13','','MARYAM','2349035208461',0.00,2208.00,'03131323','2023-03-13 13:23:19',5,'cash','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(592,'4','283','16','2023-03-13','','customer','2349035208461',0.00,1000.00,'03131324','2023-03-13 13:36:22',5,'cash','','',1000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(594,'4','283','16','2023-03-13','','customer','2349035208461',0.00,1500.00,'03131337','2023-03-13 13:45:16',5,'cash','','',1500.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(595,'4','283','16','2023-03-13','','customer','2349035208461',0.00,9200.00,'03131346','2023-03-13 13:47:51',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(596,'4','283','16','2023-03-13','','MARYAM','2349035208461',0.00,2208.00,'03131348','2023-03-13 13:48:47',5,'cash','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(597,'4','283','16','2023-03-13','','MARYAM','2349035208461',0.00,3000.00,'03131356','2023-03-13 14:36:50',5,'cash','','',3000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(598,'4','283','16','2023-03-13','','MARYAM','2349035208461',0.00,2000.00,'03131438','2023-03-13 14:38:23',5,'cash','','',2000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(599,'4','283','16','2023-03-13','','MARYAM','2349035208461',0.00,9200.00,'03131440','2023-03-13 14:41:07',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(600,'4','283','16','2023-03-13','5','MAIKIRAN SALLAH','08037336711',0.00,35500.00,'03131445','2023-03-13 14:46:07',5,'cash','','',35500.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(601,'4','283','16','2023-03-13','','MARYAM','2349035208461',0.00,3000.00,'03131447','2023-03-13 14:47:49',5,'cash','','',3000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(602,'4','283','16','2023-03-13','','MARYAM','2349035208461',0.00,2944.00,'03131448','2023-03-13 14:50:28',5,'cash','','',2944.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(603,'4','283','16','2023-03-13','','MARYAM','2349035208461',0.00,2208.00,'03131520','2023-03-13 15:21:28',5,'cash','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(604,'4','283','16','2023-03-13','','customer','2349035208461',0.00,2000.00,'03131524','2023-03-13 15:30:37',5,'cash','','',2000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(605,'4','283','16','2023-03-13','','customer','2349035208461',0.00,2944.00,'03131531','2023-03-13 15:33:56',5,'cash','','',2944.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(606,'4','283','16','2023-03-13','','customer','2349035208461',0.00,2944.00,'03131535','2023-03-13 15:36:32',5,'cash','','',2944.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(607,'4','283','16','2023-03-13','','MARYAM','2349035208461',0.00,4416.00,'03131538','2023-03-13 15:39:01',5,'cash','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(608,'4','283','16','2023-03-13','','MARYAM','2349035208461',0.00,9200.00,'03131540','2023-03-13 15:40:22',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(609,'4','283','16','2023-03-13','','customer','2349035208461',0.00,2000.00,'03131541','2023-03-13 15:48:16',5,'cash','','',2000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(610,'4','283','16','2023-03-13','','customer','2349035208461',0.00,2944.00,'03131549','2023-03-13 15:51:42',5,'cash','','',2944.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(611,'4','283','16','2023-03-13','','MARYAM','2349035208461',0.00,3680.00,'03131553','2023-03-13 15:55:25',5,'cash','','',3680.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(612,'4','283','16','2023-03-13','','MARYAM','2349035208461',0.00,9200.00,'03131556','2023-03-13 15:57:30',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(613,'4','283','16','2023-03-13','','MARYAM','2349035208461',0.00,1472.00,'03131558','2023-03-13 15:58:39',5,'cash','','',1472.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(614,'4','283','16','2023-03-13','','MARYAM','2349035208461',0.00,9200.00,'03131559','2023-03-13 16:00:10',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(615,'4','283','16','2023-03-13','','customer','2349035208461',0.00,5000.00,'03131600','2023-03-13 16:02:51',5,'cash','','',5000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(616,'4','283','16','2023-03-13','','customer','2349035208461',0.00,9200.00,'03131604','2023-03-13 16:08:18',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(617,'4','283','16','2023-03-13','','MARYAM','2349035208461',0.00,750.00,'03131609','2023-03-13 16:18:02',5,'cash','','',750.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(618,'4','283','16','2023-03-13','','MARYAM','2349035208461',0.00,2208.00,'03131618','2023-03-13 16:19:33',5,'cash','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(619,'4','283','16','2023-03-13','','customer','2349035208461',0.00,5888.00,'03131634','2023-03-13 16:35:15',5,'cash','','',5888.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(620,'4','283','16','2023-03-13','','customer','2349035208461',0.00,2208.00,'03131636','2023-03-13 16:37:12',5,'cash','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(621,'4','283','16','2023-03-13','','customer','2349035208461',0.00,3680.00,'03131640','2023-03-13 16:41:27',5,'cash','','',3680.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(622,'4','283','16','2023-03-13','','MARYAM','2349035208461',0.00,9200.00,'03131645','2023-03-13 16:46:14',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(623,'4','283','16','2023-03-13','','customer','2349035208461',0.00,9200.00,'03131654','2023-03-13 17:00:43',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(624,'4','283','16','2023-03-13','5','MAIKIRAN SALLAH','08037336711',0.00,33370.00,'03131731','2023-03-13 17:32:16',5,'cash','','',33370.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(625,'4','283','16','2023-03-13','5','MAIKIRAN SALLAH','08037336711',0.00,8875.00,'03131734','2023-03-13 17:35:16',5,'cash','','',8875.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(626,'4','283','16','2023-03-13','','MARYAM','2349035208461',0.00,5152.00,'03131737','2023-03-13 17:37:51',5,'cash','','',5152.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(629,'4','283','16','2023-03-13','','MARYAM','2349035208461',0.00,4416.00,'03131747','2023-03-13 17:53:36',5,'cash','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(630,'4','283','16','2023-03-13','','MARYAM','2349035208461',0.00,3000.00,'03131754','2023-03-13 17:55:10',5,'cash','','',3000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(631,'4','283','16','2023-03-13','','MARYAM','2349035208461',0.00,4416.00,'03131755','2023-03-13 17:56:25',5,'cash','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(632,'4','283','16','2023-03-13','','MARYAM','2349035208461',0.00,736.00,'03131757','2023-03-13 17:57:20',5,'cash','','',736.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(634,'4','283','17','2023-03-14','','customer','2349030770306',0.00,145728.00,'03141110','2023-03-14 11:11:47',5,'pos','','',145728.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(635,'4','283','17','2023-03-14','','Ishaq','2348032220047',0.00,8832.00,'03141116','2023-03-14 11:17:17',5,'pos','','',8832.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(636,'4','283','17','2023-03-14','','Musa Okpanachi','2349039950802',0.00,2208.00,'03141119','2023-03-14 11:20:43',5,'pos','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(637,'4','283','17','2023-03-14','','costomer','2349044756782',0.00,52992.00,'03141226','2023-03-14 12:27:31',5,'pos','','',52992.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(638,'4','283','17','2023-03-14','','Gebriel','2348054532261',0.00,9200.00,'03141238','2023-03-14 12:39:43',5,'pos','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(639,'4','283','17','2023-03-14','','Ishaq','2349099878818',0.00,4416.00,'03141242','2023-03-14 12:43:35',5,'pos','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(640,'4','283','17','2023-03-14','','Abdullahi Bera','2348071270683',0.00,1000.00,'03141250','2023-03-14 12:51:34',5,'cash','','',1000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(641,'4','283','17','2023-03-14','','Anas Iliyasu','2347042070205',0.00,2208.00,'03141257','2023-03-14 12:58:34',5,'pos','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(642,'4','283','17','2023-03-14','','Anas Iliyasu','2347042070205',0.00,2208.00,'03141300','2023-03-14 13:01:32',5,'pos','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(643,'4','283','17','2023-03-14','','KN Gas','2347037059919',0.00,110400.00,'03141305','2023-03-14 13:06:47',5,'pos','','',110400.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(644,'4','283','17','2023-03-14','','Mohd','2349123875050',0.00,3680.00,'03141313','2023-03-14 13:14:50',5,'pos','','',3680.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(645,'4','283','17','2023-03-14','','precios','2349047912584',0.00,2208.00,'03141316','2023-03-14 13:18:01',5,'pos','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(646,'4','283','17','2023-03-14','','Zulkifulu Mohd','2348023267854',0.00,4416.00,'03141322','2023-03-14 13:24:04',5,'pos','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(647,'4','283','17','2023-03-14','','Hassan Hassan','2348060393333',0.00,92000.00,'03141413','2023-03-14 14:31:08',5,'pos','','',92000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(648,'4','283','17','2023-03-14','','Steaphen','2349072558976',0.00,9200.00,'03141626','2023-03-14 16:27:26',5,'pos','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(650,'4','283','17','2023-03-14','','Mama Funke','2349129427135',0.00,27600.00,'03141708','2023-03-14 17:12:04',5,'pos','','',27600.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(651,'4','283','17','2023-03-14','','Mama Funke','2349129427135',0.00,26625.00,'03141708','2023-03-14 17:15:10',5,'pos','','',26625.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(652,'4','283','17','2023-03-14','','Jamil','2347086421200',0.00,4416.00,'03141738','2023-03-14 17:39:07',5,'pos','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(653,'4','283','18','2023-03-15','','MARYAM','2349035208461',0.00,4416.00,'03151045','2023-03-15 10:51:12',5,'cash','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(654,'4','283','18','2023-03-15','','MARYAM','2349035208461',0.00,9200.00,'03151052','2023-03-15 10:52:28',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(655,'4','283','18','2023-03-15','','MARYAM','2349035208461',0.00,4416.00,'03151053','2023-03-15 10:56:02',5,'cash','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(656,'4','283','18','2023-03-15','','MARYAM','2349035208461',0.00,4416.00,'03151057','2023-03-15 10:57:31',5,'cash','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(658,'4','283','18','2023-03-15','','MARYAM','2349035208461',0.00,18400.00,'03151103','2023-03-15 11:03:25',5,'cash','','',18400.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(659,'4','283','18','2023-03-15','','MARYAM','2349035208461',0.00,9200.00,'03151104','2023-03-15 11:07:37',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(660,'4','283','18','2023-03-15','5','MAIKIRAN SALLAH','08037336711',0.00,35500.00,'03151110','2023-03-15 11:11:02',5,'cash','','',35500.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(661,'4','283','18','2023-03-15','','MARYAM','2349035208461',0.00,5152.00,'03151111','2023-03-15 11:12:24',5,'cash','','',5152.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(663,'4','283','18','2023-03-15','5','MAIKIRAN SALLAH','08037336711',0.00,35500.00,'03151119','2023-03-15 11:20:06',5,'cash','','',35500.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(664,'4','283','18','2023-03-15','','customer','2349035208461',0.00,8464.00,'03151120','2023-03-15 11:33:07',5,'cash','','',8464.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(665,'4','283','18','2023-03-15','','customer','2349035208461',0.00,4416.00,'03151134','2023-03-15 11:34:49',5,'cash','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(666,'4','283','18','2023-03-15','','customer','2349035208461',0.00,2208.00,'03151135','2023-03-15 11:37:35',5,'cash','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(667,'4','283','18','2023-03-15','','customer','2349035208461',0.00,8096.00,'03151139','2023-03-15 11:41:53',5,'cash','','',8096.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(668,'4','283','18','2023-03-15','','customer','2349035208461',0.00,3000.00,'03151145','2023-03-15 11:45:58',5,'cash','','',3000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(669,'4','283','18','2023-03-15','','customer','2349035208461',0.00,3680.00,'03151147','2023-03-15 11:48:10',5,'cash','','',3680.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(670,'4','283','18','2023-03-15','','customer','2349035208461',0.00,1472.00,'03151159','2023-03-15 12:05:32',5,'cash','','',1472.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(671,'4','283','18','2023-03-15','','customer','2349035208461',0.00,4416.00,'03151206','2023-03-15 12:10:16',5,'cash','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(672,'4','283','18','2023-03-15','','customer','2349035208461',0.00,9200.00,'03151211','2023-03-15 12:12:41',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(673,'4','283','18','2023-03-15','','customer','2349035208461',0.00,3680.00,'03151213','2023-03-15 12:21:07',5,'cash','','',3680.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(674,'4','283','18','2023-03-15','5','MAIKIRAN SALLAH','08037336711',0.00,44375.00,'03151228','2023-03-15 12:29:04',5,'cash','','',44375.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(675,'4','283','18','2023-03-15','','customer','2349035208461',0.00,1472.00,'03151230','2023-03-15 12:31:05',5,'cash','','',1472.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(676,'4','283','18','2023-03-15','','customer','2349035208461',0.00,3680.00,'03151232','2023-03-15 12:33:06',5,'cash','','',3680.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(677,'4','283','18','2023-03-15','','customer','2349035208461',0.00,2208.00,'03151233','2023-03-15 12:34:25',5,'cash','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(678,'4','283','18','2023-03-15','','customer','2349035208461',0.00,3500.00,'03151240','2023-03-15 12:44:05',5,'cash','','',3500.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(679,'4','283','18','2023-03-15','','MARYAM','2349035208461',0.00,4500.00,'03151244','2023-03-15 12:45:11',5,'cash','','',4500.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(680,'4','283','18','2023-03-15','','customer','2349035208461',0.00,2208.00,'03151245','2023-03-15 12:46:39',5,'cash','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(681,'4','283','18','2023-03-15','','customer','2349035208461',0.00,2208.00,'03151249','2023-03-15 12:50:31',5,'cash','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(682,'4','283','18','2023-03-15','4','SENIOR GAS','08068826955',0.00,8875.00,'03151252','2023-03-15 12:52:48',5,'cash','','',8875.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(683,'4','283','18','2023-03-15','','customer','2349035208461',0.00,1472.00,'03151253','2023-03-15 12:54:46',5,'cash','','',1472.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(684,'4','283','18','2023-03-15','','customer','2349035208461',0.00,3000.00,'03151256','2023-03-15 12:56:38',5,'cash','','',3000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(685,'4','283','18','2023-03-15','','customer','2349035208461',0.00,4416.00,'03151640','2023-03-15 16:40:34',5,'cash','','',8832.00,4416.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(686,'4','283','18','2023-03-15','','customer','2349035208461',0.00,2208.00,'03151645','2023-03-15 16:46:24',5,'cash','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(687,'4','283','18','2023-03-15','','customer','2349035208461',0.00,6000.00,'03151648','2023-03-15 16:48:53',5,'cash','','',6000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(688,'4','283','18','2023-03-15','','customer','2349035208461',0.00,2944.00,'03151650','2023-03-15 16:50:29',5,'cash','','',2944.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(689,'4','283','18','2023-03-15','','customer','2349035208461',0.00,2208.00,'03151651','2023-03-15 16:57:35',5,'cash','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(690,'4','283','18','2023-03-15','','customer','2349035208461',0.00,2000.00,'03151658','2023-03-15 17:03:04',5,'cash','','',2000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(692,'4','283','18','2023-03-15','','customer','2349035208461',0.00,2944.00,'03151703','2023-03-15 17:20:01',5,'cash','','',2944.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(694,'4','283','18','2023-03-15','4','SENIOR GAS','08068826955',0.00,8875.00,'03151724','2023-03-15 17:25:16',5,'cash','','',8875.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(695,'4','283','18','2023-03-15','','customer','2349035208461',0.00,4416.00,'03151726','2023-03-15 17:29:28',5,'cash','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(696,'4','283','18','2023-03-15','','customer','2349035208461',0.00,2208.00,'03151730','2023-03-15 17:32:20',5,'cash','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(697,'4','283','18','2023-03-15','','customer','2349035208461',0.00,2000.00,'03151734','2023-03-15 17:43:36',5,'cash','','',2000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(698,'4','283','18','2023-03-15','','customer','2349035208461',0.00,2208.00,'03151745','2023-03-15 17:50:07',5,'cash','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(699,'4','283','18','2023-03-15','','c','2349035208461',0.00,2208.00,'03151750','2023-03-15 17:54:03',5,'cash','','',4416.00,2208.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(700,'4','283','18','2023-03-15','','customer','2349035208461',0.00,1000.00,'03151755','2023-03-15 17:56:36',5,'cash','','',1000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(701,'4','283','18','2023-03-15','','customer','2349035208461',0.00,2208.00,'03151757','2023-03-15 17:57:45',5,'cash','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(702,'4','283','18','2023-03-15','','customer','2349035208461',0.00,1472.00,'03151758','2023-03-15 17:58:53',5,'cash','','',1472.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(703,'4','283','18','2023-03-15','2','SALUHU GAS','080357424300',0.00,35500.00,'03151800','2023-03-15 18:01:28',5,'cash','','',35500.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(704,'4','283','18','2023-03-15','2','SALUHU GAS','080357424300',0.00,104370.00,'03151802','2023-03-15 18:02:52',5,'cash','','',104370.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(705,'4','283','18','2023-03-15','','MARYAM','2349035208461',0.00,9200.00,'03151804','2023-03-15 18:04:26',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(706,'4','283','18','2023-03-15','','customer','2349035208461',0.00,2208.00,'03151805','2023-03-15 18:06:06',5,'cash','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(707,'4','283','18','2023-03-15','','customer','2349035208461',0.00,5000.00,'03151807','2023-03-15 18:08:24',5,'cash','','',5000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(708,'4','283','18','2023-03-15','','customer','2349035208461',0.00,1472.00,'03151809','2023-03-15 18:13:55',5,'cash','','',1472.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(709,'4','283','18','2023-03-15','','customer','2349035208461',0.00,3600.00,'03151815','2023-03-15 18:15:29',5,'cash','','',3600.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(711,'4','283','18','2023-03-15','','customer','2349035208461',0.00,9200.00,'03151816','2023-03-15 18:16:48',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(712,'4','283','19','2023-03-16','1','SABRIN GAS','08039702656',0.00,355000.00,'03161149','2023-03-16 11:50:19',5,'bank','','',355000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(713,'4','283','19','2023-03-16','','isa abdu iasa','2349037722655',0.00,57408.00,'03161207','2023-03-16 12:16:23',5,'pos','','',57408.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(714,'4','283','19','2023-03-16','','Mr Musa','2348163595114',0.00,4416.00,'03161217','2023-03-16 12:18:50',5,'pos','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(715,'4','283','19','2023-03-16','','Lovina','2348151220917',0.00,1625088.00,'03161220','2023-03-16 12:21:50',5,'pos','','',1625088.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(716,'4','283','19','2023-03-16','','atima Musa','2349074233715',0.00,2944.00,'03161224','2023-03-16 12:25:52',5,'pos','','',2944.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(717,'4','283','19','2023-03-16','','Olayemi ','2348060303669',0.00,7360.00,'03161233','2023-03-16 12:34:19',5,'pos','','',7360.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(718,'4','283','19','2023-03-16','','Samaila Abdulkareem','2348028897431',0.00,3680.00,'03161236','2023-03-16 12:40:17',5,'pos','','',3680.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(719,'4','283','19','2023-03-16','','Ibrahim','2348136058732',0.00,4416.00,'03161241','2023-03-16 12:42:26',5,'pos','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(720,'4','283','19','2023-03-16','','Emeka','2348077153882',0.00,3700.00,'03161244','2023-03-16 12:48:19',5,'pos','','',3700.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(722,'4','283','19','2023-03-16','','Bartho Gas','2348073394409',0.00,71000.00,'03161253','2023-03-16 12:57:49',5,'pos','','',71000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(723,'4','283','19','2023-03-16','','Aisha Usman Mohd ','2349063602312',0.00,1500.00,'03161301','2023-03-16 13:04:19',5,'pos','','',1500.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(724,'4','283','19','2023-03-16','','Raymond','2348065954949',0.00,2208.00,'03161305','2023-03-16 13:13:32',5,'pos','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(725,'4','283','19','2023-03-16','','David','2347069214311',0.00,1500.00,'03161316','2023-03-16 13:17:56',5,'pos','','',1500.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(726,'4','283','19','2023-03-16','','Ofulu Andrew','2348035956277',0.00,5888.00,'03161319','2023-03-16 13:20:38',5,'pos','','',5888.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(728,'4','283','19','2023-03-16','','Zulkifulu Mohd','2347040479348',0.00,4416.00,'03161322','2023-03-16 13:23:43',5,'pos','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(729,'4','283','19','2023-03-16','','Emeka','2348140150845',0.00,1472.00,'03161324','2023-03-16 13:24:58',5,'pos','','',1472.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(730,'4','283','19','2023-03-16','','Michael','2348123142748',0.00,9200.00,'03161344','2023-03-16 13:46:12',5,'pos','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(731,'4','283','19','2023-03-16','','Mustapha','2348184945474',0.00,800.00,'03161355','2023-03-16 13:56:43',5,'cash','','',800.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(732,'4','283','19','2023-03-16','','Abduljalil','2348028221692',0.00,7360.00,'03161358','2023-03-16 13:58:54',5,'pos','','',7360.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(733,'4','283','19','2023-03-16','','Abubakar','2348032323916',0.00,9200.00,'03161403','2023-03-16 14:04:16',5,'pos','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(734,'4','283','19','2023-03-16','','Ahmad','2348069778590',0.00,5000.00,'03161407','2023-03-16 14:09:35',5,'pos','','',5000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(735,'4','283','19','2023-03-16','','Dr CHUka','2348060069280',0.00,9200.00,'03161411','2023-03-16 14:13:11',5,'pos','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(736,'4','283','19','2023-03-16','','Nura Hussain','2348038514634',0.00,2208.00,'03161418','2023-03-16 14:19:18',5,'pos','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(737,'4','283','19','2023-03-16','','Zara','2347066693488',0.00,4416.00,'03161421','2023-03-16 14:23:04',5,'pos','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(738,'4','283','19','2023-03-16','','MUNNIR ADO','2348035677648',0.00,9200.00,'03161431','2023-03-16 14:32:18',5,'pos','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(739,'4','283','19','2023-03-16','','Emma Fish','2348179351329',0.00,8875.00,'03161508','2023-03-16 15:09:19',5,'pos','','',8875.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(740,'4','283','19','2023-03-16','','Sabo Ibrahim Adamu','2349136110971',0.00,7360.00,'03161645','2023-03-16 16:47:07',5,'pos','','',7360.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(741,'4','283','19','2023-03-16','','Ayo','2347019823455',0.00,4416.00,'03161648','2023-03-16 16:48:47',5,'pos','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(742,'4','283','20','2023-03-17','','MARYAM','2349035208461',0.00,2500.00,'03171026','2023-03-17 10:52:05',5,'cash','','',2500.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(743,'4','283','20','2023-03-17','','customer','2349035208461',0.00,9200.00,'03171053','2023-03-17 10:54:17',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(745,'4','283','20','2023-03-17','','customer','2349035208461',0.00,1472.00,'03171129','2023-03-17 11:29:37',5,'cash','','',1472.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(746,'4','283','20','2023-03-17','','customer','2349035208461',0.00,2208.00,'03171131','2023-03-17 11:32:35',5,'cash','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(747,'4','283','20','2023-03-17','','customer','2349035208461',0.00,2208.00,'03171133','2023-03-17 11:36:27',5,'cash','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(748,'4','283','20','2023-03-17','','MARYAM','2349035208461',0.00,1000.00,'03171137','2023-03-17 11:37:49',5,'cash','','',1000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(749,'4','283','20','2023-03-17','','customer','2349035208461',0.00,5152.00,'03171138','2023-03-17 11:39:14',5,'cash','','',5152.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(750,'4','283','20','2023-03-17','','customer','2349035208461',0.00,9200.00,'03171139','2023-03-17 11:41:16',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(751,'4','283','20','2023-03-17','','customer','2349035208461',0.00,9200.00,'03171139','2023-03-17 11:41:17',0,'','','',NULL,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(752,'4','283','20','2023-03-17','','MARYAM','2349035208461',0.00,3680.00,'03171142','2023-03-17 11:43:25',5,'cash','','',3680.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(753,'4','283','20','2023-03-17','','customer','2349035208461',0.00,4416.00,'03171144','2023-03-17 11:44:22',5,'cash','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(754,'4','283','20','2023-03-17','','customer','2349035208461',0.00,9200.00,'03171145','2023-03-17 11:46:01',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(755,'4','283','20','2023-03-17','','customer','2349035208461',0.00,4416.00,'03171149','2023-03-17 11:49:55',0,'cash','','',8832.00,4416.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(756,'4','283','20','2023-03-17','','customer','2349035208461',0.00,9200.00,'03171150','2023-03-17 11:51:07',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(757,'4','283','20','2023-03-17','','MARYAM','2349035208461',0.00,3680.00,'03171152','2023-03-17 11:53:46',0,'','','',NULL,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(758,'4','283','20','2023-03-17','','customer','2349035208461',0.00,4416.00,'03171155','2023-03-17 11:59:54',5,'cash','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(759,'4','283','20','2023-03-17','','customer','2349035208461',0.00,9200.00,'03171200','2023-03-17 12:01:15',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(760,'4','283','20','2023-03-17','','customer','2349035208461',0.00,7728.00,'03171202','2023-03-17 12:03:40',5,'cash','','',7728.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(761,'4','283','20','2023-03-17','','customer','2349035208461',0.00,4416.00,'03171204','2023-03-17 12:05:09',5,'cash','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(762,'4','283','20','2023-03-17','','customer','2349035208461',0.00,9200.00,'03171208','2023-03-17 12:10:46',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(763,'4','283','20','2023-03-17','','customer','2349035208461',0.00,9200.00,'03171212','2023-03-17 12:13:13',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(764,'4','283','20','2023-03-17','','customer','2349035208461',0.00,3680.00,'03171214','2023-03-17 12:17:57',5,'cash','','',3680.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(765,'4','283','20','2023-03-17','','MARYAM','2349035208461',0.00,4416.00,'03171219','2023-03-17 12:23:18',5,'cash','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(766,'4','283','20','2023-03-17','','customer','2349035208461',0.00,9200.00,'03171226','2023-03-17 12:26:42',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(767,'4','283','20','2023-03-17','','MARYAM','2349035208461',0.00,4000.00,'03171227','2023-03-17 12:28:15',5,'cash','','',4000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(768,'4','283','20','2023-03-17','','customer','2349035208461',0.00,2944.00,'03171229','2023-03-17 12:30:34',5,'cash','','',2944.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(769,'4','283','20','2023-03-17','','customer','2349035208461',0.00,9200.00,'03171231','2023-03-17 12:32:04',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(770,'4','283','20','2023-03-17','','customer','2349035208461',0.00,2944.00,'03171233','2023-03-17 12:42:05',5,'cash','','',2944.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(771,'4','283','20','2023-03-17','','customer','2349035208461',0.00,4416.00,'03171242','2023-03-17 12:43:11',5,'cash','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(772,'4','283','20','2023-03-17','','customer','2349035208461',0.00,2208.00,'03171243','2023-03-17 12:46:19',5,'cash','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(773,'4','283','20','2023-03-17','','customer','2349035208461',0.00,6624.00,'03171247','2023-03-17 12:47:47',5,'cash','','',6624.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(774,'4','283','20','2023-03-17','5','MAIKIRAN SALLAH','08037336711',0.00,14200.00,'03171252','2023-03-17 12:53:14',5,'cash','','',14200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(775,'4','283','20','2023-03-17','5','MAIKIRAN SALLAH','08037336711',0.00,33370.00,'03171254','2023-03-17 12:54:36',5,'cash','','',33370.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(776,'4','283','20','2023-03-17','5','MAIKIRAN SALLAH','08037336711',0.00,43665.00,'03171256','2023-03-17 12:59:49',5,'cash','','',43665.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(777,'4','283','20','2023-03-17','','customer','2349035208461',0.00,13248.00,'03171302','2023-03-17 13:05:44',5,'cash','','',13248.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(778,'4','283','20','2023-03-17','','customer','2349035208461',0.00,9200.00,'03171306','2023-03-17 13:06:58',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(779,'4','283','20','2023-03-17','','customer','2349035208461',0.00,5152.00,'03171307','2023-03-17 13:16:04',5,'cash','','',5152.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(780,'4','283','20','2023-03-17','','customer','2349035208461',0.00,4416.00,'03171317','2023-03-17 13:19:42',5,'cash','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(781,'4','283','20','2023-03-17','','customer','2349035208461',0.00,1000.00,'03171320','2023-03-17 14:15:15',5,'cash','','',1000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(782,'4','283','20','2023-03-17','','customer','2349035208461',0.00,2208.00,'03171416','2023-03-17 14:17:03',5,'cash','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(783,'4','283','20','2023-03-17','','customer','2349035208461',0.00,9200.00,'03171418','2023-03-17 14:19:06',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(784,'4','283','20','2023-03-17','','MARYAM','2349035208461',0.00,2000.00,'03171420','2023-03-17 14:20:51',5,'cash','','',2000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(785,'4','283','20','2023-03-17','','MARYAM','2349035208461',0.00,2000.00,'03171420','2023-03-17 14:20:52',0,'','','',NULL,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(786,'4','283','20','2023-03-17','','customer','2349035208461',0.00,2208.00,'03171424','2023-03-17 14:25:43',5,'cash','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(787,'4','283','20','2023-03-17','','customer','2349035208461',0.00,3000.00,'03171426','2023-03-17 14:27:12',5,'cash','','',3000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(788,'4','283','20','2023-03-17','','customer','2349035208461',0.00,4416.00,'03171428','2023-03-17 14:28:58',5,'cash','','',4416.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(789,'4','283','20','2023-03-17','','customer','2349035208461',0.00,4000.00,'03171430','2023-03-17 14:37:24',5,'cash','','',4000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(790,'4','283','20','2023-03-17','','customer','2349035208461',0.00,2944.00,'03171438','2023-03-17 14:40:51',5,'cash','','',2944.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(791,'4','283','20','2023-03-17','','customer','2349035208461',0.00,2208.00,'03171442','2023-03-17 14:42:34',5,'cash','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(792,'4','283','20','2023-03-17','','customer','2349035208461',0.00,9200.00,'03171443','2023-03-17 14:47:03',5,'cash','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(793,'4','283','20','2023-03-17','','MARYAM','2349035208461',0.00,8096.00,'03171448','2023-03-17 14:48:52',5,'cash','','',8096.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(794,'4','283','20','2023-03-17','','MARYAM','2349035208461',0.00,40480.00,'03171449','2023-03-17 14:56:48',5,'cash','','',40480.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(795,'4','283','20','2023-03-17','','customer','2349035208461',0.00,9000.00,'03171501','2023-03-17 15:07:32',5,'cash','','',9000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(796,'4','283','20','2023-03-17','2','SALUHU GAS','080357424300',0.00,71000.00,'03171550','2023-03-17 15:51:23',5,'pos','','',71000.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(797,'4','283','20','2023-03-17','2','SALUHU GAS','080357424300',0.00,35500.00,'03171553','2023-03-17 15:53:45',5,'pos','','',35500.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(798,'4','283','20','2023-03-17','','MARYAM','2349035208461',0.00,2208.00,'03171554','2023-03-17 16:51:49',5,'pos','','',2208.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(799,'4','283','20','2023-03-17','','Blessing Samuel','2348165026806',0.00,9200.00,'03171653','2023-03-17 16:54:04',5,'pos','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(800,'4','283','20','2023-03-17','','Mustapha Muazu','2349025342607',0.00,9200.00,'03171655','2023-03-17 16:56:06',5,'pos','','',9200.00,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(801,'4','283','20','2023-03-17','','Mustapha Muazu','2349025342607',0.00,9200.00,'03171655','2023-03-17 16:56:07',0,'','','',NULL,0.00,'','955','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `retail_sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_items`
--

DROP TABLE IF EXISTS `retail_sales_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `product_type` varchar(10) NOT NULL,
  `product_name` varchar(100) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `quantity_2` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `parent_cost` decimal(20,2) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`sale_id`,`product_id`,`rate`,`quantity`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`product_type`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `parent_id` (`parent_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=811 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_items`
--

LOCK TABLES `retail_sales_items` WRITE;
/*!40000 ALTER TABLE `retail_sales_items` DISABLE KEYS */;
INSERT INTO `retail_sales_items` VALUES (1,'4','283','1','1',1,'0','Cooking Gas','4',730.00,760.00,12.50,24.50,9500.00,'',0.00,0.00,0.00,5),(2,'4','283','1','1',1,'0','Cooking Gas','1',730.00,760.00,6.00,11.76,4560.00,'',0.00,0.00,0.00,5),(3,'4','283','2','2',1,'0','Cooking Gas','1',690.00,760.00,12.50,24.50,9500.00,'',0.00,0.00,0.00,5),(4,'4','283','2','2',1,'0','Cooking Gas','2',690.00,760.00,3.00,5.88,2280.00,'',0.00,0.00,0.00,5),(5,'4','283','2','3',1,'0','Cooking Gas','1',690.00,760.00,25.00,49.00,19000.00,'',0.00,0.00,0.00,5),(6,'4','283','2','4',1,'0','Cooking Gas','1',690.00,760.00,15.00,29.40,11400.00,'',0.00,0.00,0.00,5),(7,'4','283','2','5',1,'0','Cooking Gas','2',690.00,750.00,300.00,588.00,225000.00,'',0.00,0.00,0.00,5),(8,'4','283','3','6',1,'0','Cooking Gas','1',690.00,760.00,12.50,24.50,9500.00,'',0.00,0.00,0.00,5),(9,'4','283','3','6',1,'0','Cooking Gas','2',690.00,760.00,6.00,11.76,4560.00,'',0.00,0.00,0.00,5),(10,'4','283','4','7',1,'0','Cooking Gas','2',690.00,760.00,1.00,1.96,760.00,'',0.00,0.00,0.00,5),(11,'4','283','4','7',1,'0','Cooking Gas','2',690.00,760.00,1.00,1.96,760.00,'',0.00,0.00,0.00,5),(12,'4','283','4','8',1,'0','Cooking Gas','1',690.00,750.00,500.00,980.00,375000.00,'',0.00,0.00,0.00,5),(13,'4','283','4','9',1,'0','Cooking Gas','1',690.00,760.00,125.00,245.00,95000.00,'',0.00,0.00,0.00,5),(14,'4','283','4','10',1,'0','Cooking Gas','1',690.00,760.00,1.00,1.96,760.00,'',0.00,0.00,0.00,5),(15,'4','283','4','11',1,'0','Cooking Gas','2',690.00,760.00,15.00,29.40,11400.00,'',0.00,0.00,0.00,5),(16,'4','283','4','12',1,'0','Cooking Gas','2',690.00,760.00,15.00,29.40,11400.00,'',0.00,0.00,0.00,5),(17,'4','283','4','13',1,'0','Cooking Gas','2',690.00,760.00,15.00,29.40,11400.00,'',0.00,0.00,0.00,5),(18,'4','283','4','14',1,'0','Cooking Gas','2',690.00,760.00,10.00,19.60,7600.00,'',0.00,0.00,0.00,5),(19,'4','283','4','15',1,'0','Cooking Gas','1',690.00,760.00,50.00,98.00,38000.00,'',0.00,0.00,0.00,5),(20,'4','283','4','16',1,'0','Cooking Gas','2',690.00,750.00,750.00,1470.00,562500.00,'',0.00,0.00,0.00,5),(21,'4','283','4','17',1,'0','Cooking Gas','2',690.00,760.00,3.00,5.88,2280.00,'',0.00,0.00,0.00,5),(22,'4','283','4','18',1,'0','Cooking Gas','1',690.00,760.00,25.00,49.00,19000.00,'',0.00,0.00,0.00,5),(23,'4','283','5','19',1,'0','Cooking Gas','1',690.00,760.00,15.00,29.40,11400.00,'',0.00,0.00,0.00,5),(24,'4','283','5','20',1,'0','Cooking Gas','2',690.00,760.00,10.00,19.60,7600.00,'',0.00,0.00,0.00,5),(25,'4','283','5','20',1,'0','Cooking Gas','2',690.00,760.00,5.00,9.80,3800.00,'',0.00,0.00,0.00,5),(26,'4','283','5','21',1,'0','Cooking Gas','2',690.00,760.00,12.50,24.50,9500.00,'',0.00,0.00,0.00,5),(27,'4','283','5','21',1,'0','Cooking Gas','2',690.00,760.00,6.00,11.76,4560.00,'',0.00,0.00,0.00,5),(28,'4','283','5','21',1,'0','Cooking Gas','3',690.00,760.00,3.00,5.88,2280.00,'',0.00,0.00,0.00,5),(29,'4','283','5','22',1,'0','Cooking Gas','1',690.00,760.00,5.00,9.80,3800.00,'',0.00,0.00,0.00,5),(30,'4','283','5','23',1,'0','Cooking Gas','2',690.00,760.00,9.00,17.64,6840.00,'',0.00,0.00,0.00,5),(31,'4','283','5','24',1,'0','Cooking Gas','2',690.00,760.00,15.00,29.40,11400.00,'',0.00,0.00,0.00,5),(32,'4','283','5','25',1,'0','Cooking Gas','3',690.00,760.00,15.00,29.40,11400.00,'',0.00,0.00,0.00,5),(34,'4','283','6','27',1,'0','Cooking Gas','1',690.00,760.00,5.00,9.80,3800.00,'',0.00,0.00,0.00,5),(35,'4','283','6','28',1,'0','Cooking Gas','2',690.00,760.00,5.26,10.31,4000.00,'',0.00,0.00,0.00,5),(36,'4','283','6','28',1,'0','Cooking Gas','1',690.00,760.00,25.00,49.00,19000.00,'',0.00,0.00,0.00,5),(39,'4','283','6','31',1,'0','Cooking Gas','1',690.00,760.00,1.00,1.96,760.00,'',0.00,0.00,0.00,5),(40,'4','283','6','32',1,'0','Cooking Gas','1',690.00,750.00,500.00,980.00,375000.00,'',0.00,0.00,0.00,5),(41,'4','283','6','33',1,'0','Cooking Gas','1',690.00,750.00,150.00,294.00,112500.00,'',0.00,0.00,0.00,5),(42,'4','283','6','34',1,'0','Cooking Gas','1',690.00,760.00,3.00,5.88,2280.00,'',0.00,0.00,0.00,5),(43,'4','283','6','35',1,'0','Cooking Gas','2',690.00,760.00,6.00,11.76,4560.00,'',0.00,0.00,0.00,5),(44,'4','283','6','35',1,'0','Cooking Gas','1',690.00,760.00,12.50,24.50,9500.00,'',0.00,0.00,0.00,5),(45,'4','283','6','36',1,'0','Cooking Gas','1',690.00,760.00,25.00,49.00,19000.00,'',0.00,0.00,0.00,5),(46,'4','283','6','37',1,'0','Cooking Gas','1',690.00,760.00,25.00,49.00,19000.00,'',0.00,0.00,0.00,5),(47,'4','283','7','38',1,'0','Cooking Gas','1',690.00,760.00,6.00,11.76,4560.00,'',0.00,0.00,0.00,5),(49,'4','283','7','40',1,'0','Cooking Gas','1',690.00,760.00,9.00,17.64,6840.00,'',0.00,0.00,0.00,5),(50,'4','283','7','41',1,'0','Cooking Gas','2',690.00,750.00,300.00,588.00,225000.00,'',0.00,0.00,0.00,5),(51,'4','283','7','42',1,'0','Cooking Gas','2',690.00,750.00,500.00,980.00,375000.00,'',0.00,0.00,0.00,5),(52,'4','283','7','43',1,'0','Cooking Gas','1',690.00,750.00,500.00,980.00,375000.00,'',0.00,0.00,0.00,5),(53,'4','283','7','44',1,'0','Cooking Gas','1',690.00,760.00,25.00,49.00,19000.00,'',0.00,0.00,0.00,5),(54,'4','283','8','45',1,'0','Cooking Gas','4',690.00,760.00,4.00,7.84,3040.00,'',0.00,0.00,0.00,5),(55,'4','283','8','46',1,'0','Cooking Gas','2',736.00,750.00,350.00,686.00,262500.00,'',0.00,0.00,0.00,5),(56,'4','283','8','47',1,'0','Cooking Gas','4',736.00,700.00,100.00,196.00,70000.00,'',0.00,0.00,0.00,5),(57,'4','283','8','48',1,'0','Cooking Gas','1',736.00,760.00,1.00,1.96,760.00,'',0.00,0.00,0.00,5),(59,'4','283','8','50',1,'0','Cooking Gas','1',736.00,736.00,7.00,13.72,5152.00,'',0.00,0.00,0.00,5),(60,'4','283','8','51',1,'0','Cooking Gas','3',736.00,760.00,100.00,196.00,76000.00,'',0.00,0.00,0.00,5),(61,'4','283','8','52',1,'0','Cooking Gas','1',736.00,710.00,250.00,490.00,177500.00,'',0.00,0.00,0.00,5),(62,'4','283','8','53',1,'0','Cooking Gas','1',736.00,710.00,150.00,294.00,106500.00,'',0.00,0.00,0.00,5),(63,'4','283','10','54',1,'0','Cooking Gas','1',736.00,736.00,9.00,17.64,6624.00,'',0.00,0.00,0.00,5),(64,'4','283','11','55',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(65,'4','283','11','56',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(66,'4','283','11','57',1,'0','Cooking Gas','1',736.00,736.00,5.98,11.72,4400.00,'',0.00,0.00,0.00,5),(67,'4','283','11','58',1,'0','Cooking Gas','1',736.00,736.00,1.22,2.39,900.00,'',0.00,0.00,0.00,5),(68,'4','283','11','59',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(69,'4','283','11','60',1,'0','Cooking Gas','1',736.00,736.00,18.50,36.26,13616.00,'',0.00,0.00,0.00,5),(70,'4','283','11','61',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(71,'4','283','11','62',1,'0','Cooking Gas','1',736.00,736.00,5.00,9.80,3680.00,'',0.00,0.00,0.00,5),(72,'4','283','11','63',1,'0','Cooking Gas','1',736.00,736.00,2.04,4.00,1500.00,'',0.00,0.00,0.00,5),(74,'4','283','11','65',1,'0','Cooking Gas','1',736.00,736.00,6.79,13.31,5000.00,'',0.00,0.00,0.00,5),(75,'4','283','11','66',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(76,'4','283','11','67',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(78,'4','283','11','69',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(80,'4','283','11','71',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(82,'4','283','11','73',1,'0','Cooking Gas','1',736.00,736.00,2.00,3.92,1472.00,'',0.00,0.00,0.00,5),(83,'4','283','11','74',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(84,'4','283','11','75',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(87,'4','283','11','78',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(88,'4','283','11','79',1,'0','Cooking Gas','1',736.00,736.00,2.00,3.92,1472.00,'',0.00,0.00,0.00,5),(89,'4','283','11','80',1,'0','Cooking Gas','1',736.00,736.00,17.50,34.30,12880.00,'',0.00,0.00,0.00,5),(90,'4','283','11','81',1,'0','Cooking Gas','1',736.00,736.00,9.00,17.64,6624.00,'',0.00,0.00,0.00,5),(91,'4','283','11','82',1,'0','Cooking Gas','1',736.00,736.00,3.06,6.00,2250.00,'',0.00,0.00,0.00,5),(92,'4','283','11','83',1,'0','Cooking Gas','1',736.00,736.00,5.00,9.80,3680.00,'',0.00,0.00,0.00,5),(93,'4','283','11','84',1,'0','Cooking Gas','1',736.00,736.00,8.00,15.68,5888.00,'',0.00,0.00,0.00,5),(94,'4','283','11','85',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(95,'4','283','11','86',1,'0','Cooking Gas','1',736.00,736.00,1.00,1.96,736.00,'',0.00,0.00,0.00,5),(96,'4','283','11','87',1,'0','Cooking Gas','1',736.00,736.00,5.00,9.80,3680.00,'',0.00,0.00,0.00,5),(97,'4','283','11','88',1,'0','Cooking Gas','1',736.00,736.00,2.00,3.92,1472.00,'',0.00,0.00,0.00,5),(98,'4','283','11','89',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(99,'4','283','11','90',1,'0','Cooking Gas','1',736.00,736.00,7.00,13.72,5152.00,'',0.00,0.00,0.00,5),(101,'4','283','11','92',1,'0','Cooking Gas','1',736.00,736.00,9.00,17.64,6624.00,'',0.00,0.00,0.00,5),(102,'4','283','11','93',1,'0','Cooking Gas','1',736.00,736.00,3.40,6.66,2500.00,'',0.00,0.00,0.00,5),(103,'4','283','11','94',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(105,'4','283','11','96',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(106,'4','283','11','97',1,'0','Cooking Gas','1',736.00,736.00,2.00,3.92,1472.00,'',0.00,0.00,0.00,5),(107,'4','283','11','98',1,'0','Cooking Gas','1',736.00,736.00,4.08,8.00,3000.00,'',0.00,0.00,0.00,5),(108,'4','283','11','99',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(109,'4','283','11','100',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(110,'4','283','11','101',1,'0','Cooking Gas','1',736.00,736.00,10.00,19.60,7360.00,'',0.00,0.00,0.00,5),(111,'4','283','11','102',1,'0','Cooking Gas','1',736.00,736.00,2.72,5.33,2000.00,'',0.00,0.00,0.00,5),(113,'4','283','11','104',1,'0','Cooking Gas','1',736.00,736.00,2.04,4.00,1500.00,'',0.00,0.00,0.00,5),(115,'4','283','11','106',1,'0','Cooking Gas','1',736.00,710.00,48.00,94.08,34080.00,'',0.00,0.00,0.00,5),(116,'4','283','11','107',1,'0','Cooking Gas','1',736.00,736.00,6.79,13.31,5000.00,'',0.00,0.00,0.00,5),(118,'4','283','11','109',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(120,'4','283','11','111',1,'0','Cooking Gas','1',736.00,736.00,5.43,10.64,4000.00,'',0.00,0.00,0.00,5),(121,'4','283','11','112',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(122,'4','283','11','113',1,'0','Cooking Gas','1',736.00,736.00,12.00,23.52,8832.00,'',0.00,0.00,0.00,5),(123,'4','283','11','114',1,'0','Cooking Gas','1',736.00,736.00,5.00,9.80,3680.00,'',0.00,0.00,0.00,5),(125,'4','283','11','116',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(126,'4','283','11','117',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(127,'4','283','11','118',1,'0','Cooking Gas','1',736.00,736.00,5.00,9.80,3680.00,'',0.00,0.00,0.00,5),(128,'4','283','11','119',1,'0','Cooking Gas','1',736.00,736.00,4.00,7.84,2944.00,'',0.00,0.00,0.00,5),(129,'4','283','11','120',1,'0','Cooking Gas','1',736.00,736.00,3.40,6.66,2500.00,'',0.00,0.00,0.00,5),(130,'4','283','11','121',1,'0','Cooking Gas','1',736.00,736.00,4.08,8.00,3000.00,'',0.00,0.00,0.00,5),(131,'4','283','11','122',1,'0','Cooking Gas','1',736.00,736.00,1.00,1.96,736.00,'',0.00,0.00,0.00,5),(132,'4','283','11','123',1,'0','Cooking Gas','1',736.00,736.00,25.00,49.00,18400.00,'',0.00,0.00,0.00,5),(133,'4','283','11','124',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(134,'4','283','11','125',1,'0','Cooking Gas','1',736.00,736.00,1.36,2.67,1000.00,'',0.00,0.00,0.00,5),(135,'4','283','11','126',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(136,'4','283','11','127',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(137,'4','283','11','128',1,'0','Cooking Gas','1',736.00,736.00,2.04,4.00,1500.00,'',0.00,0.00,0.00,5),(138,'4','283','11','129',1,'0','Cooking Gas','1',736.00,736.00,17.50,34.30,12880.00,'',0.00,0.00,0.00,5),(139,'4','283','11','130',1,'0','Cooking Gas','1',736.00,736.00,16.50,32.34,12144.00,'',0.00,0.00,0.00,5),(140,'4','283','11','131',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(141,'4','283','11','132',1,'0','Cooking Gas','1',736.00,736.00,2.00,3.92,1472.00,'',0.00,0.00,0.00,5),(142,'4','283','11','133',1,'0','Cooking Gas','1',736.00,736.00,0.54,1.06,400.00,'',0.00,0.00,0.00,5),(143,'4','283','11','134',1,'0','Cooking Gas','1',736.00,736.00,10.00,19.60,7360.00,'',0.00,0.00,0.00,5),(144,'4','283','11','135',1,'0','Cooking Gas','1',736.00,736.00,5.00,9.80,3680.00,'',0.00,0.00,0.00,5),(145,'4','283','11','136',1,'0','Cooking Gas','1',736.00,736.00,1.00,1.96,736.00,'',0.00,0.00,0.00,5),(146,'4','283','11','137',1,'0','Cooking Gas','1',736.00,736.00,5.00,9.80,3680.00,'',0.00,0.00,0.00,5),(147,'4','283','11','138',1,'0','Cooking Gas','1',736.00,736.00,4.00,7.84,2944.00,'',0.00,0.00,0.00,5),(148,'4','283','11','139',1,'0','Cooking Gas','1',736.00,736.00,5.00,9.80,3680.00,'',0.00,0.00,0.00,5),(149,'4','283','11','140',1,'0','Cooking Gas','1',736.00,736.00,5.00,9.80,3680.00,'',0.00,0.00,0.00,5),(150,'4','283','11','141',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(151,'4','283','11','142',1,'0','Cooking Gas','1',736.00,736.00,5.00,9.80,3680.00,'',0.00,0.00,0.00,5),(152,'4','283','11','143',1,'0','Cooking Gas','1',736.00,736.00,1.36,2.67,1000.00,'',0.00,0.00,0.00,5),(153,'4','283','11','144',1,'0','Cooking Gas','1',736.00,736.00,4.08,8.00,3000.00,'',0.00,0.00,0.00,5),(154,'4','283','11','145',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(155,'4','283','11','146',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(158,'4','283','11','149',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(159,'4','283','11','150',1,'0','Cooking Gas','1',736.00,736.00,25.00,49.00,18400.00,'',0.00,0.00,0.00,5),(160,'4','283','11','151',1,'0','Cooking Gas','1',736.00,736.00,8.15,15.97,6000.00,'',0.00,0.00,0.00,5),(161,'4','283','11','152',1,'0','Cooking Gas','1',736.00,736.00,2.00,3.92,1472.00,'',0.00,0.00,0.00,5),(164,'4','283','11','155',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(166,'4','283','11','157',1,'0','Cooking Gas','1',736.00,736.00,12.00,23.52,8832.00,'',0.00,0.00,0.00,5),(167,'4','283','11','158',1,'0','Cooking Gas','1',736.00,736.00,1.02,2.00,750.00,'',0.00,0.00,0.00,5),(168,'4','283','11','159',1,'0','Cooking Gas','1',736.00,736.00,9.50,18.62,6992.00,'',0.00,0.00,0.00,5),(169,'4','283','11','160',1,'0','Cooking Gas','1',736.00,736.00,12.00,23.52,8832.00,'',0.00,0.00,0.00,5),(171,'4','283','11','162',1,'0','Cooking Gas','1',736.00,736.00,3.13,6.13,2300.00,'',0.00,0.00,0.00,5),(173,'4','283','11','164',1,'0','Cooking Gas','1',736.00,736.00,5.43,10.64,4000.00,'',0.00,0.00,0.00,5),(174,'4','283','11','165',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(175,'4','283','11','166',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(176,'4','283','11','167',1,'0','Cooking Gas','1',736.00,736.00,4.08,8.00,3000.00,'',0.00,0.00,0.00,5),(177,'4','283','11','168',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(178,'4','283','11','169',1,'0','Cooking Gas','1',736.00,736.00,15.50,30.38,11408.00,'',0.00,0.00,0.00,5),(179,'4','283','11','170',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(180,'4','283','11','171',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(181,'4','283','12','172',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(182,'4','283','12','173',1,'0','Cooking Gas','1',736.00,736.00,5.00,9.80,3680.00,'',0.00,0.00,0.00,5),(183,'4','283','12','174',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(184,'4','283','12','175',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(185,'4','283','12','176',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(186,'4','283','12','177',1,'0','Cooking Gas','1',736.00,736.00,9.00,17.64,6624.00,'',0.00,0.00,0.00,5),(187,'4','283','12','178',1,'0','Cooking Gas','1',736.00,736.00,5.00,9.80,3680.00,'',0.00,0.00,0.00,5),(188,'4','283','12','179',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(189,'4','283','12','180',1,'0','Cooking Gas','1',736.00,736.00,25.00,49.00,18400.00,'',0.00,0.00,0.00,5),(190,'4','283','12','181',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(191,'4','283','12','182',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(192,'4','283','12','183',1,'0','Cooking Gas','1',736.00,710.00,12.50,24.50,8875.00,'',0.00,0.00,0.00,5),(193,'4','283','12','184',1,'0','Cooking Gas','1',736.00,736.00,1.00,1.96,736.00,'',0.00,0.00,0.00,5),(194,'4','283','12','185',1,'0','Cooking Gas','1',736.00,736.00,2.72,5.33,2000.00,'',0.00,0.00,0.00,5),(195,'4','283','12','186',1,'0','Cooking Gas','1',736.00,736.00,5.00,9.80,3680.00,'',0.00,0.00,0.00,5),(196,'4','283','12','187',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(197,'4','283','12','188',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(198,'4','283','12','189',1,'0','Cooking Gas','1',736.00,736.00,5.00,9.80,3680.00,'',0.00,0.00,0.00,5),(199,'4','283','12','190',1,'0','Cooking Gas','1',736.00,736.00,6.79,13.31,5000.00,'',0.00,0.00,0.00,5),(200,'4','283','12','191',1,'0','Cooking Gas','1',736.00,736.00,2.72,5.33,2000.00,'',0.00,0.00,0.00,5),(201,'4','283','12','192',1,'0','Cooking Gas','1',736.00,736.00,4.00,7.84,2944.00,'',0.00,0.00,0.00,5),(202,'4','283','12','193',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(203,'4','283','12','194',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(204,'4','283','12','195',1,'0','Cooking Gas','1',736.00,736.00,5.00,9.80,3680.00,'',0.00,0.00,0.00,5),(205,'4','283','12','196',1,'0','Cooking Gas','1',736.00,736.00,18.50,36.26,13616.00,'',0.00,0.00,0.00,5),(206,'4','283','12','197',1,'0','Cooking Gas','1',736.00,736.00,8.00,15.68,5888.00,'',0.00,0.00,0.00,5),(207,'4','283','12','198',1,'0','Cooking Gas','1',736.00,736.00,4.00,7.84,2944.00,'',0.00,0.00,0.00,5),(208,'4','283','12','199',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(209,'4','283','12','200',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(210,'4','283','12','201',1,'0','Cooking Gas','1',736.00,736.00,10.00,19.60,7360.00,'',0.00,0.00,0.00,5),(211,'4','283','12','202',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(214,'4','283','12','205',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(215,'4','283','12','206',1,'0','Cooking Gas','1',736.00,736.00,7.00,13.72,5152.00,'',0.00,0.00,0.00,5),(216,'4','283','12','207',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(218,'4','283','12','209',1,'0','Cooking Gas','1',736.00,736.00,5.00,9.80,3680.00,'',0.00,0.00,0.00,5),(219,'4','283','12','210',1,'0','Cooking Gas','1',736.00,736.00,10.00,19.60,7360.00,'',0.00,0.00,0.00,5),(221,'4','283','12','212',1,'0','Cooking Gas','1',736.00,736.00,2.04,4.00,1500.00,'',0.00,0.00,0.00,5),(222,'4','283','12','213',1,'0','Cooking Gas','1',736.00,736.00,21.00,41.16,15456.00,'',0.00,0.00,0.00,5),(223,'4','283','12','214',1,'0','Cooking Gas','1',736.00,736.00,4.00,7.84,2944.00,'',0.00,0.00,0.00,5),(224,'4','283','12','215',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(225,'4','283','12','216',1,'0','Cooking Gas','1',736.00,736.00,37.00,72.52,27232.00,'',0.00,0.00,0.00,5),(226,'4','283','12','217',1,'0','Cooking Gas','1',736.00,736.00,5.43,10.64,4000.00,'',0.00,0.00,0.00,5),(227,'4','283','12','218',1,'0','Cooking Gas','1',736.00,736.00,5.00,9.80,3680.00,'',0.00,0.00,0.00,5),(228,'4','283','12','219',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(229,'4','283','12','220',1,'0','Cooking Gas','1',736.00,736.00,5.43,10.64,4000.00,'',0.00,0.00,0.00,5),(230,'4','283','12','221',1,'0','Cooking Gas','1',736.00,736.00,6.79,13.31,5000.00,'',0.00,0.00,0.00,5),(231,'4','283','12','222',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(232,'4','283','12','223',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(233,'4','283','12','224',1,'0','Cooking Gas','1',736.00,736.00,12.00,23.52,8832.00,'',0.00,0.00,0.00,5),(234,'4','283','12','225',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(235,'4','283','12','226',1,'0','Cooking Gas','1',736.00,736.00,2.00,3.92,1472.00,'',0.00,0.00,0.00,5),(236,'4','283','12','227',1,'0','Cooking Gas','1',736.00,736.00,1.63,3.19,1200.00,'',0.00,0.00,0.00,5),(237,'4','283','12','228',1,'0','Cooking Gas','1',736.00,736.00,2.04,4.00,1500.00,'',0.00,0.00,0.00,5),(238,'4','283','12','229',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(239,'4','283','12','230',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(240,'4','283','12','231',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(241,'4','283','12','232',1,'0','Cooking Gas','1',736.00,736.00,3.40,6.66,2500.00,'',0.00,0.00,0.00,5),(242,'4','283','12','233',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(243,'4','283','13','234',1,'0','Cooking Gas','1',736.00,736.00,1.36,2.67,1000.00,'',0.00,0.00,0.00,5),(244,'4','283','13','235',1,'0','Cooking Gas','1',736.00,736.00,9.00,17.64,6624.00,'',0.00,0.00,0.00,5),(245,'4','283','13','236',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(246,'4','283','13','237',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(247,'4','283','13','238',1,'0','Cooking Gas','1',736.00,736.00,18.50,36.26,13616.00,'',0.00,0.00,0.00,5),(248,'4','283','13','239',1,'0','Cooking Gas','1',736.00,736.00,5.00,9.80,3680.00,'',0.00,0.00,0.00,5),(249,'4','283','13','240',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(250,'4','283','13','241',1,'0','Cooking Gas','1',736.00,736.00,2.72,5.33,2000.00,'',0.00,0.00,0.00,5),(252,'4','283','13','243',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(254,'4','283','13','245',1,'0','Cooking Gas','1',736.00,736.00,11.00,21.56,8096.00,'',0.00,0.00,0.00,5),(255,'4','283','13','246',1,'0','Cooking Gas','1',736.00,736.00,4.00,7.84,2944.00,'',0.00,0.00,0.00,5),(256,'4','283','13','247',1,'0','Cooking Gas','1',736.00,736.00,2.00,3.92,1472.00,'',0.00,0.00,0.00,5),(257,'4','283','13','248',1,'0','Cooking Gas','1',736.00,736.00,12.00,23.52,8832.00,'',0.00,0.00,0.00,5),(258,'4','283','13','249',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(260,'4','283','13','251',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(261,'4','283','13','252',1,'0','Cooking Gas','1',736.00,736.00,2.00,3.92,1472.00,'',0.00,0.00,0.00,5),(262,'4','283','13','253',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(263,'4','283','13','254',1,'0','Cooking Gas','1',736.00,736.00,6.79,13.31,5000.00,'',0.00,0.00,0.00,5),(264,'4','283','13','255',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(266,'4','283','13','257',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(267,'4','283','13','258',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(268,'4','283','13','259',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(269,'4','283','13','260',1,'0','Cooking Gas','1',736.00,736.00,6.79,13.31,5000.00,'',0.00,0.00,0.00,5),(271,'4','283','13','262',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(273,'4','283','13','264',1,'0','Cooking Gas','1',736.00,736.00,2.72,5.33,2000.00,'',0.00,0.00,0.00,5),(275,'4','283','13','266',1,'0','Cooking Gas','1',736.00,710.00,100.00,196.00,71000.00,'',0.00,0.00,0.00,5),(277,'4','283','13','268',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(278,'4','283','13','269',1,'0','Cooking Gas','1',736.00,736.00,2.00,3.92,1472.00,'',0.00,0.00,0.00,5),(279,'4','283','13','270',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(281,'4','283','13','272',1,'0','Cooking Gas','1',736.00,736.00,1.36,2.67,1000.00,'',0.00,0.00,0.00,5),(282,'4','283','13','273',1,'0','Cooking Gas','1',736.00,736.00,8.15,15.97,6000.00,'',0.00,0.00,0.00,5),(283,'4','283','13','274',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(284,'4','283','13','275',1,'0','Cooking Gas','1',736.00,736.00,2.72,5.33,2000.00,'',0.00,0.00,0.00,5),(285,'4','283','13','276',1,'0','Cooking Gas','1',736.00,710.00,96.00,188.16,68160.00,'',0.00,0.00,0.00,5),(287,'4','283','13','278',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(289,'4','283','13','280',1,'0','Cooking Gas','1',736.00,736.00,2.72,5.33,2000.00,'',0.00,0.00,0.00,5),(290,'4','283','13','281',1,'0','Cooking Gas','1',736.00,736.00,2.99,5.86,2200.00,'',0.00,0.00,0.00,5),(292,'4','283','13','283',1,'0','Cooking Gas','1',736.00,736.00,5.00,9.80,3680.00,'',0.00,0.00,0.00,5),(293,'4','283','13','284',1,'0','Cooking Gas','1',736.00,736.00,9.00,17.64,6624.00,'',0.00,0.00,0.00,5),(295,'4','283','13','286',1,'0','Cooking Gas','1',736.00,736.00,1.36,2.67,1000.00,'',0.00,0.00,0.00,5),(296,'4','283','13','287',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(298,'4','283','13','289',1,'0','Cooking Gas','1',736.00,736.00,4.08,8.00,3000.00,'',0.00,0.00,0.00,5),(299,'4','283','13','290',1,'0','Cooking Gas','1',736.00,736.00,5.43,10.64,4000.00,'',0.00,0.00,0.00,5),(301,'4','283','13','292',1,'0','Cooking Gas','1',736.00,736.00,3.40,6.66,2500.00,'',0.00,0.00,0.00,5),(302,'4','283','13','293',1,'0','Cooking Gas','1',736.00,736.00,5.00,9.80,3680.00,'',0.00,0.00,0.00,5),(303,'4','283','13','294',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(304,'4','283','13','295',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(305,'4','283','13','296',1,'0','Cooking Gas','1',736.00,736.00,25.00,49.00,18400.00,'',0.00,0.00,0.00,5),(306,'4','283','13','297',1,'0','Cooking Gas','1',736.00,736.00,2.99,5.86,2200.00,'',0.00,0.00,0.00,5),(307,'4','283','13','298',1,'0','Cooking Gas','1',736.00,736.00,4.08,8.00,3000.00,'',0.00,0.00,0.00,5),(309,'4','283','13','300',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(310,'4','283','13','301',1,'0','Cooking Gas','1',736.00,710.00,50.00,98.00,35500.00,'',0.00,0.00,0.00,5),(311,'4','283','13','302',1,'0','Cooking Gas','1',736.00,736.00,2.00,3.92,1472.00,'',0.00,0.00,0.00,5),(312,'4','283','13','303',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(313,'4','283','13','304',1,'0','Cooking Gas','1',736.00,736.00,5.43,10.64,4000.00,'',0.00,0.00,0.00,5),(315,'4','283','13','306',1,'0','Cooking Gas','1',736.00,736.00,15.50,30.38,11408.00,'',0.00,0.00,0.00,5),(316,'4','283','13','307',1,'0','Cooking Gas','1',736.00,736.00,12.00,23.52,8832.00,'',0.00,0.00,0.00,5),(317,'4','283','13','308',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(318,'4','283','13','309',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(319,'4','283','13','310',1,'0','Cooking Gas','1',736.00,736.00,6.79,13.31,5000.00,'',0.00,0.00,0.00,5),(320,'4','283','13','311',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(321,'4','283','13','312',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(322,'4','283','13','313',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(324,'4','283','13','315',1,'0','Cooking Gas','1',736.00,736.00,15.50,30.38,11408.00,'',0.00,0.00,0.00,5),(325,'4','283','13','316',1,'0','Cooking Gas','1',736.00,736.00,4.00,7.84,2944.00,'',0.00,0.00,0.00,5),(327,'4','283','13','318',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(330,'4','283','13','321',1,'0','Cooking Gas','1',736.00,736.00,2.72,5.33,2000.00,'',0.00,0.00,0.00,5),(331,'4','283','13','322',1,'0','Cooking Gas','1',736.00,736.00,17.50,34.30,12880.00,'',0.00,0.00,0.00,5),(333,'4','283','13','324',1,'0','Cooking Gas','1',736.00,736.00,5.00,9.80,3680.00,'',0.00,0.00,0.00,5),(334,'4','283','13','325',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(336,'4','283','13','327',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(338,'4','283','13','329',1,'0','Cooking Gas','1',736.00,736.00,10.00,19.60,7360.00,'',0.00,0.00,0.00,5),(339,'4','283','13','330',1,'0','Cooking Gas','1',736.00,736.00,3.13,6.13,2300.00,'',0.00,0.00,0.00,5),(340,'4','283','13','331',1,'0','Cooking Gas','1',736.00,736.00,12.00,23.52,8832.00,'',0.00,0.00,0.00,5),(341,'4','283','13','332',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(342,'4','283','13','333',1,'0','Cooking Gas','1',736.00,736.00,5.00,9.80,3680.00,'',0.00,0.00,0.00,5),(343,'4','283','13','334',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(344,'4','283','13','335',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(345,'4','283','13','336',1,'0','Cooking Gas','1',736.00,736.00,4.08,8.00,3000.00,'',0.00,0.00,0.00,5),(346,'4','283','13','337',1,'0','Cooking Gas','1',736.00,710.00,50.00,98.00,35500.00,'',0.00,0.00,0.00,5),(348,'4','283','14','339',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(349,'4','283','14','340',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(351,'4','283','14','342',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(353,'4','283','14','344',1,'0','Cooking Gas','1',736.00,736.00,7.20,14.11,5300.00,'',0.00,0.00,0.00,5),(354,'4','283','14','345',1,'0','Cooking Gas','1',736.00,736.00,8.00,15.68,5888.00,'',0.00,0.00,0.00,5),(355,'4','283','14','346',1,'0','Cooking Gas','1',736.00,736.00,2.04,4.00,1500.00,'',0.00,0.00,0.00,5),(356,'4','283','14','347',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(357,'4','283','14','348',1,'0','Cooking Gas','1',736.00,736.00,5.43,10.64,4000.00,'',0.00,0.00,0.00,5),(358,'4','283','14','349',1,'0','Cooking Gas','1',736.00,736.00,4.00,7.84,2944.00,'',0.00,0.00,0.00,5),(359,'4','283','14','350',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(360,'4','283','14','351',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(361,'4','283','14','352',1,'0','Cooking Gas','1',736.00,736.00,2.00,3.92,1472.00,'',0.00,0.00,0.00,5),(362,'4','283','14','353',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(363,'4','283','14','354',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(364,'4','283','14','355',1,'0','Cooking Gas','1',736.00,736.00,1.36,2.67,1000.00,'',0.00,0.00,0.00,5),(365,'4','283','14','356',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(366,'4','283','14','357',1,'0','Cooking Gas','1',736.00,736.00,6.79,13.31,5000.00,'',0.00,0.00,0.00,5),(367,'4','283','14','358',1,'0','Cooking Gas','1',736.00,736.00,1.00,1.96,736.00,'',0.00,0.00,0.00,5),(368,'4','283','14','359',1,'0','Cooking Gas','1',736.00,736.00,4.08,8.00,3000.00,'',0.00,0.00,0.00,5),(369,'4','283','14','360',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(370,'4','283','14','361',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(371,'4','283','14','362',1,'0','Cooking Gas','1',736.00,736.00,13.00,25.48,9568.00,'',0.00,0.00,0.00,5),(372,'4','283','14','363',1,'0','Cooking Gas','1',736.00,736.00,15.00,29.40,11040.00,'',0.00,0.00,0.00,5),(373,'4','283','14','364',1,'0','Cooking Gas','1',736.00,710.00,50.00,98.00,35500.00,'',0.00,0.00,0.00,5),(374,'4','283','14','365',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(375,'4','283','14','366',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(376,'4','283','14','367',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(377,'4','283','14','368',1,'0','Cooking Gas','1',736.00,736.00,9.00,17.64,6624.00,'',0.00,0.00,0.00,5),(378,'4','283','14','369',1,'0','Cooking Gas','1',736.00,736.00,6.79,13.31,5000.00,'',0.00,0.00,0.00,5),(379,'4','283','14','370',1,'0','Cooking Gas','1',736.00,736.00,2.00,3.92,1472.00,'',0.00,0.00,0.00,5),(380,'4','283','14','371',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(381,'4','283','14','372',1,'0','Cooking Gas','1',736.00,736.00,2.00,3.92,1472.00,'',0.00,0.00,0.00,5),(382,'4','283','14','373',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(384,'4','283','14','375',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(385,'4','283','14','376',1,'0','Cooking Gas','1',736.00,736.00,5.00,9.80,3680.00,'',0.00,0.00,0.00,5),(386,'4','283','14','377',1,'0','Cooking Gas','1',736.00,736.00,12.00,23.52,8832.00,'',0.00,0.00,0.00,5),(387,'4','283','14','378',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(388,'4','283','14','379',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(389,'4','283','14','380',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(390,'4','283','14','381',1,'0','Cooking Gas','1',736.00,710.00,3.00,5.88,2130.00,'',0.00,0.00,0.00,5),(391,'4','283','14','382',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(392,'4','283','14','383',1,'0','Cooking Gas','1',736.00,736.00,4.00,7.84,2944.00,'',0.00,0.00,0.00,5),(393,'4','283','14','384',1,'0','Cooking Gas','1',736.00,736.00,7.00,13.72,5152.00,'',0.00,0.00,0.00,5),(394,'4','283','14','385',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(395,'4','283','14','386',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(396,'4','283','14','387',1,'0','Cooking Gas','1',736.00,736.00,2.72,5.33,2000.00,'',0.00,0.00,0.00,5),(397,'4','283','14','388',1,'0','Cooking Gas','1',736.00,736.00,12.00,23.52,8832.00,'',0.00,0.00,0.00,5),(398,'4','283','14','389',1,'0','Cooking Gas','1',736.00,736.00,10.00,19.60,7360.00,'',0.00,0.00,0.00,5),(399,'4','283','14','390',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(400,'4','283','14','391',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(401,'4','283','14','392',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(402,'4','283','14','393',1,'0','Cooking Gas','1',736.00,736.00,4.00,7.84,2944.00,'',0.00,0.00,0.00,5),(403,'4','283','14','394',1,'0','Cooking Gas','1',736.00,736.00,5.98,11.72,4400.00,'',0.00,0.00,0.00,5),(404,'4','283','14','395',1,'0','Cooking Gas','1',736.00,736.00,6.11,11.98,4500.00,'',0.00,0.00,0.00,5),(405,'4','283','14','396',1,'0','Cooking Gas','1',736.00,736.00,2.04,4.00,1500.00,'',0.00,0.00,0.00,5),(406,'4','283','14','397',1,'0','Cooking Gas','1',736.00,736.00,5.00,9.80,3680.00,'',0.00,0.00,0.00,5),(407,'4','283','14','398',1,'0','Cooking Gas','1',736.00,736.00,5.00,9.80,3680.00,'',0.00,0.00,0.00,5),(408,'4','283','14','399',1,'0','Cooking Gas','1',736.00,736.00,1.36,2.67,1000.00,'',0.00,0.00,0.00,5),(409,'4','283','14','400',1,'0','Cooking Gas','1',736.00,736.00,12.00,23.52,8832.00,'',0.00,0.00,0.00,5),(410,'4','283','14','401',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(412,'4','283','14','403',1,'0','Cooking Gas','1',736.00,736.00,5.43,10.64,4000.00,'',0.00,0.00,0.00,5),(413,'4','283','14','404',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(414,'4','283','14','405',1,'0','Cooking Gas','1',736.00,736.00,11.00,21.56,8096.00,'',0.00,0.00,0.00,5),(415,'4','283','14','406',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(416,'4','283','14','407',1,'0','Cooking Gas','1',736.00,736.00,6.79,13.31,5000.00,'',0.00,0.00,0.00,5),(417,'4','283','14','408',1,'0','Cooking Gas','1',736.00,736.00,4.08,8.00,3000.00,'',0.00,0.00,0.00,5),(418,'4','283','14','409',1,'0','Cooking Gas','1',736.00,736.00,12.00,23.52,8832.00,'',0.00,0.00,0.00,5),(419,'4','283','14','410',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(420,'4','283','14','411',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(421,'4','283','14','412',1,'0','Cooking Gas','1',736.00,736.00,5.00,9.80,3680.00,'',0.00,0.00,0.00,5),(422,'4','283','14','413',1,'0','Cooking Gas','1',736.00,736.00,6.79,13.31,5000.00,'',0.00,0.00,0.00,5),(423,'4','283','14','414',1,'0','Cooking Gas','1',736.00,736.00,12.00,23.52,8832.00,'',0.00,0.00,0.00,5),(424,'4','283','14','415',1,'0','Cooking Gas','1',736.00,736.00,5.00,9.80,3680.00,'',0.00,0.00,0.00,5),(425,'4','283','14','416',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(426,'4','283','14','417',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(427,'4','283','14','418',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(428,'4','283','14','419',1,'0','Cooking Gas','1',736.00,736.00,2.04,4.00,1500.00,'',0.00,0.00,0.00,5),(429,'4','283','14','420',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(430,'4','283','14','421',1,'0','Cooking Gas','1',736.00,736.00,2.00,3.92,1472.00,'',0.00,0.00,0.00,5),(431,'4','283','14','422',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(432,'4','283','14','423',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(433,'4','283','14','424',1,'0','Cooking Gas','1',736.00,736.00,9.00,17.64,6624.00,'',0.00,0.00,0.00,5),(434,'4','283','14','425',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(435,'4','283','14','426',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(436,'4','283','14','427',1,'0','Cooking Gas','1',736.00,736.00,4.00,7.84,2944.00,'',0.00,0.00,0.00,5),(437,'4','283','14','428',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(438,'4','283','14','429',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(439,'4','283','14','430',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(440,'4','283','14','431',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(441,'4','283','15','432',1,'0','Cooking Gas','1',736.00,736.00,4.08,8.00,3000.00,'',0.00,0.00,0.00,5),(442,'4','283','15','433',1,'0','Cooking Gas','1',736.00,736.00,4.08,8.00,3000.00,'',0.00,0.00,0.00,5),(444,'4','283','15','435',1,'0','Cooking Gas','1',736.00,736.00,5.00,9.80,3680.00,'',0.00,0.00,0.00,5),(445,'4','283','15','436',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(446,'4','283','15','437',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(447,'4','283','15','438',1,'0','Cooking Gas','1',736.00,736.00,5.00,9.80,3680.00,'',0.00,0.00,0.00,5),(449,'4','283','15','440',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(450,'4','283','15','441',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(451,'4','283','15','442',1,'0','Cooking Gas','1',736.00,736.00,10.19,19.97,7500.00,'',0.00,0.00,0.00,5),(452,'4','283','15','443',1,'0','Cooking Gas','1',736.00,736.00,12.00,23.52,8832.00,'',0.00,0.00,0.00,5),(453,'4','283','15','444',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(454,'4','283','15','445',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(455,'4','283','15','446',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(456,'4','283','15','447',1,'0','Cooking Gas','1',736.00,736.00,2.04,4.00,1500.00,'',0.00,0.00,0.00,5),(460,'4','283','15','451',1,'0','Cooking Gas','1',736.00,736.00,2.00,3.92,1472.00,'',0.00,0.00,0.00,5),(461,'4','283','15','452',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(463,'4','283','15','454',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(464,'4','283','15','455',1,'0','Cooking Gas','1',736.00,736.00,1.36,2.67,1000.00,'',0.00,0.00,0.00,5),(465,'4','283','15','456',1,'0','Cooking Gas','1',736.00,736.00,4.00,7.84,2944.00,'',0.00,0.00,0.00,5),(468,'4','283','15','459',1,'0','Cooking Gas','1',736.00,736.00,16.00,31.36,11776.00,'',0.00,0.00,0.00,5),(470,'4','283','15','461',1,'0','Cooking Gas','1',736.00,736.00,10.87,21.31,8000.00,'',0.00,0.00,0.00,5),(471,'4','283','15','462',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(472,'4','283','15','463',1,'0','Cooking Gas','1',736.00,736.00,2.04,4.00,1500.00,'',0.00,0.00,0.00,5),(474,'4','283','15','465',1,'0','Cooking Gas','1',736.00,736.00,10.00,19.60,7360.00,'',0.00,0.00,0.00,5),(475,'4','283','15','466',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(477,'4','283','15','468',1,'0','Cooking Gas','1',736.00,736.00,5.00,9.80,3680.00,'',0.00,0.00,0.00,5),(478,'4','283','15','469',1,'0','Cooking Gas','1',736.00,736.00,12.00,23.52,8832.00,'',0.00,0.00,0.00,5),(480,'4','283','15','471',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(481,'4','283','15','472',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(483,'4','283','15','474',1,'0','Cooking Gas','1',736.00,736.00,1.90,3.72,1400.00,'',0.00,0.00,0.00,5),(484,'4','283','15','475',1,'0','Cooking Gas','1',736.00,736.00,16.50,32.34,12144.00,'',0.00,0.00,0.00,5),(485,'4','283','15','476',1,'0','Cooking Gas','1',736.00,736.00,2.99,5.86,2200.00,'',0.00,0.00,0.00,5),(488,'4','283','15','479',1,'0','Cooking Gas','1',736.00,736.00,4.08,8.00,3000.00,'',0.00,0.00,0.00,5),(489,'4','283','15','480',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(490,'4','283','15','481',1,'0','Cooking Gas','1',736.00,736.00,13.00,25.48,9568.00,'',0.00,0.00,0.00,5),(492,'4','283','15','483',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(493,'4','283','15','484',1,'0','Cooking Gas','1',736.00,736.00,12.00,23.52,8832.00,'',0.00,0.00,0.00,5),(496,'4','283','15','487',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(498,'4','283','15','489',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(499,'4','283','15','490',1,'0','Cooking Gas','1',736.00,736.00,12.00,23.52,8832.00,'',0.00,0.00,0.00,5),(500,'4','283','15','491',1,'0','Cooking Gas','1',736.00,736.00,18.50,36.26,13616.00,'',0.00,0.00,0.00,5),(501,'4','283','15','492',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(502,'4','283','15','493',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(504,'4','283','15','495',1,'0','Cooking Gas','1',736.00,736.00,2.72,5.33,2000.00,'',0.00,0.00,0.00,5),(505,'4','283','15','496',1,'0','Cooking Gas','1',736.00,736.00,9.00,17.64,6624.00,'',0.00,0.00,0.00,5),(506,'4','283','15','497',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(508,'4','283','15','499',1,'0','Cooking Gas','1',736.00,736.00,8.15,15.97,6000.00,'',0.00,0.00,0.00,5),(509,'4','283','15','500',1,'0','Cooking Gas','1',736.00,736.00,5.00,9.80,3680.00,'',0.00,0.00,0.00,5),(510,'4','283','15','501',1,'0','Cooking Gas','1',736.00,736.00,8.00,15.68,5888.00,'',0.00,0.00,0.00,5),(513,'4','283','15','504',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(514,'4','283','15','505',1,'0','Cooking Gas','1',736.00,710.00,25.00,49.00,17750.00,'',0.00,0.00,0.00,5),(517,'4','283','15','508',1,'0','Cooking Gas','1',736.00,710.00,62.00,121.52,44020.00,'',0.00,0.00,0.00,5),(518,'4','283','15','509',1,'0','Cooking Gas','1',736.00,736.00,2.00,3.92,1472.00,'',0.00,0.00,0.00,5),(519,'4','283','15','510',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(520,'4','283','15','511',1,'0','Cooking Gas','1',736.00,736.00,1.00,1.96,736.00,'',0.00,0.00,0.00,5),(521,'4','283','15','512',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(522,'4','283','15','513',1,'0','Cooking Gas','1',736.00,736.00,2.00,3.92,1472.00,'',0.00,0.00,0.00,5),(523,'4','283','15','514',1,'0','Cooking Gas','1',736.00,736.00,1.00,1.96,736.00,'',0.00,0.00,0.00,5),(524,'4','283','15','515',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(525,'4','283','15','516',1,'0','Cooking Gas','1',736.00,736.00,2.72,5.33,2000.00,'',0.00,0.00,0.00,5),(527,'4','283','15','518',1,'0','Cooking Gas','1',736.00,736.00,10.05,19.70,7400.00,'',0.00,0.00,0.00,5),(528,'4','283','15','519',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(529,'4','283','15','520',1,'0','Cooking Gas','1',736.00,736.00,2.72,5.33,2000.00,'',0.00,0.00,0.00,5),(532,'4','283','15','523',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(534,'4','283','15','525',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(535,'4','283','15','526',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(536,'4','283','15','527',1,'0','Cooking Gas','1',736.00,736.00,2.00,3.92,1472.00,'',0.00,0.00,0.00,5),(537,'4','283','15','528',1,'0','Cooking Gas','1',736.00,736.00,5.00,9.80,3680.00,'',0.00,0.00,0.00,5),(538,'4','283','15','529',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(540,'4','283','15','531',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(541,'4','283','15','532',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(542,'4','283','15','533',1,'0','Cooking Gas','1',736.00,710.00,12.50,24.50,8875.00,'',0.00,0.00,0.00,5),(543,'4','283','15','534',1,'0','Cooking Gas','1',736.00,736.00,5.43,10.64,4000.00,'',0.00,0.00,0.00,5),(544,'4','283','15','535',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(545,'4','283','16','536',1,'0','Cooking Gas','1',736.00,710.00,57.50,112.70,40825.00,'',0.00,0.00,0.00,5),(546,'4','283','16','537',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(547,'4','283','16','538',1,'0','Cooking Gas','1',736.00,736.00,5.43,10.64,4000.00,'',0.00,0.00,0.00,5),(549,'4','283','16','540',1,'0','Cooking Gas','1',736.00,710.00,5.00,9.80,3550.00,'',0.00,0.00,0.00,5),(550,'4','283','16','541',1,'0','Cooking Gas','1',736.00,736.00,9.00,17.64,6624.00,'',0.00,0.00,0.00,5),(551,'4','283','16','542',1,'0','Cooking Gas','1',736.00,736.00,5.00,9.80,3680.00,'',0.00,0.00,0.00,5),(553,'4','283','16','544',1,'0','Cooking Gas','1',736.00,736.00,7.00,13.72,5152.00,'',0.00,0.00,0.00,5),(554,'4','283','16','545',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(556,'4','283','16','547',1,'0','Cooking Gas','1',736.00,736.00,1.00,1.96,736.00,'',0.00,0.00,0.00,5),(557,'4','283','16','548',1,'0','Cooking Gas','1',736.00,736.00,1.36,2.67,1000.00,'',0.00,0.00,0.00,5),(558,'4','283','16','549',1,'0','Cooking Gas','1',736.00,736.00,17.50,34.30,12880.00,'',0.00,0.00,0.00,5),(559,'4','283','16','550',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(560,'4','283','16','551',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(561,'4','283','16','552',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(562,'4','283','16','553',1,'0','Cooking Gas','1',736.00,736.00,12.00,23.52,8832.00,'',0.00,0.00,0.00,5),(563,'4','283','16','554',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(564,'4','283','16','555',1,'0','Cooking Gas','1',736.00,736.00,8.00,15.68,5888.00,'',0.00,0.00,0.00,5),(565,'4','283','16','556',1,'0','Cooking Gas','1',736.00,736.00,4.08,8.00,3000.00,'',0.00,0.00,0.00,5),(566,'4','283','16','557',1,'0','Cooking Gas','1',736.00,736.00,3.06,6.00,2250.00,'',0.00,0.00,0.00,5),(567,'4','283','16','558',1,'0','Cooking Gas','1',736.00,736.00,1.77,3.47,1300.00,'',0.00,0.00,0.00,5),(570,'4','283','16','561',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(571,'4','283','16','562',1,'0','Cooking Gas','1',736.00,736.00,5.00,9.80,3680.00,'',0.00,0.00,0.00,5),(572,'4','283','16','563',1,'0','Cooking Gas','1',736.00,736.00,1.36,2.67,1000.00,'',0.00,0.00,0.00,5),(573,'4','283','16','564',1,'0','Cooking Gas','1',736.00,736.00,10.00,19.60,7360.00,'',0.00,0.00,0.00,5),(574,'4','283','16','565',1,'0','Cooking Gas','1',736.00,736.00,1.36,2.67,1000.00,'',0.00,0.00,0.00,5),(575,'4','283','16','566',1,'0','Cooking Gas','1',736.00,736.00,6.79,13.31,5000.00,'',0.00,0.00,0.00,5),(576,'4','283','16','567',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(578,'4','283','16','569',1,'0','Cooking Gas','1',736.00,736.00,12.00,23.52,8832.00,'',0.00,0.00,0.00,5),(579,'4','283','16','570',1,'0','Cooking Gas','1',736.00,736.00,0.50,0.98,368.00,'',0.00,0.00,0.00,5),(580,'4','283','16','571',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(581,'4','283','16','572',1,'0','Cooking Gas','1',736.00,736.00,2.72,5.33,2000.00,'',0.00,0.00,0.00,5),(582,'4','283','16','573',1,'0','Cooking Gas','1',736.00,736.00,3.40,6.66,2500.00,'',0.00,0.00,0.00,5),(583,'4','283','16','574',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(584,'4','283','16','575',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(585,'4','283','16','576',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(586,'4','283','16','577',1,'0','Cooking Gas','1',736.00,736.00,2.04,4.00,1500.00,'',0.00,0.00,0.00,5),(588,'4','283','16','579',1,'0','Cooking Gas','1',736.00,736.00,6.11,11.98,4500.00,'',0.00,0.00,0.00,5),(590,'4','283','16','581',1,'0','Cooking Gas','1',736.00,736.00,2.00,3.92,1472.00,'',0.00,0.00,0.00,5),(592,'4','283','16','583',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(593,'4','283','16','584',1,'0','Cooking Gas','1',736.00,736.00,2.00,3.92,1472.00,'',0.00,0.00,0.00,5),(594,'4','283','16','585',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(595,'4','283','16','586',1,'0','Cooking Gas','1',736.00,710.00,10.00,19.60,7100.00,'',0.00,0.00,0.00,5),(596,'4','283','16','587',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(597,'4','283','16','588',1,'0','Cooking Gas','1',736.00,710.00,50.00,98.00,35500.00,'',0.00,0.00,0.00,5),(598,'4','283','16','589',1,'0','Cooking Gas','1',736.00,710.00,97.00,190.12,68870.00,'',0.00,0.00,0.00,5),(600,'4','283','16','591',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(601,'4','283','16','592',1,'0','Cooking Gas','1',736.00,736.00,1.36,2.67,1000.00,'',0.00,0.00,0.00,5),(603,'4','283','16','594',1,'0','Cooking Gas','1',736.00,736.00,2.04,4.00,1500.00,'',0.00,0.00,0.00,5),(604,'4','283','16','595',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(605,'4','283','16','596',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(606,'4','283','16','597',1,'0','Cooking Gas','1',736.00,736.00,4.08,8.00,3000.00,'',0.00,0.00,0.00,5),(607,'4','283','16','598',1,'0','Cooking Gas','1',736.00,736.00,2.72,5.33,2000.00,'',0.00,0.00,0.00,5),(608,'4','283','16','599',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(609,'4','283','16','600',1,'0','Cooking Gas','1',736.00,710.00,50.00,98.00,35500.00,'',0.00,0.00,0.00,5),(610,'4','283','16','601',1,'0','Cooking Gas','1',736.00,736.00,4.08,8.00,3000.00,'',0.00,0.00,0.00,5),(611,'4','283','16','602',1,'0','Cooking Gas','1',736.00,736.00,4.00,7.84,2944.00,'',0.00,0.00,0.00,5),(612,'4','283','16','603',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(613,'4','283','16','604',1,'0','Cooking Gas','1',736.00,736.00,2.72,5.33,2000.00,'',0.00,0.00,0.00,5),(614,'4','283','16','605',1,'0','Cooking Gas','1',736.00,736.00,4.00,7.84,2944.00,'',0.00,0.00,0.00,5),(615,'4','283','16','606',1,'0','Cooking Gas','1',736.00,736.00,4.00,7.84,2944.00,'',0.00,0.00,0.00,5),(616,'4','283','16','607',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(617,'4','283','16','608',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(618,'4','283','16','609',1,'0','Cooking Gas','1',736.00,736.00,2.72,5.33,2000.00,'',0.00,0.00,0.00,5),(619,'4','283','16','610',1,'0','Cooking Gas','1',736.00,736.00,4.00,7.84,2944.00,'',0.00,0.00,0.00,5),(620,'4','283','16','611',1,'0','Cooking Gas','1',736.00,736.00,5.00,9.80,3680.00,'',0.00,0.00,0.00,5),(621,'4','283','16','612',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(622,'4','283','16','613',1,'0','Cooking Gas','1',736.00,736.00,2.00,3.92,1472.00,'',0.00,0.00,0.00,5),(623,'4','283','16','614',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(624,'4','283','16','615',1,'0','Cooking Gas','1',736.00,736.00,6.79,13.31,5000.00,'',0.00,0.00,0.00,5),(625,'4','283','16','616',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(626,'4','283','16','617',1,'0','Cooking Gas','1',736.00,736.00,1.02,2.00,750.00,'',0.00,0.00,0.00,5),(627,'4','283','16','618',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(628,'4','283','16','619',1,'0','Cooking Gas','1',736.00,736.00,8.00,15.68,5888.00,'',0.00,0.00,0.00,5),(629,'4','283','16','620',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(630,'4','283','16','621',1,'0','Cooking Gas','1',736.00,736.00,5.00,9.80,3680.00,'',0.00,0.00,0.00,5),(631,'4','283','16','622',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(632,'4','283','16','623',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(633,'4','283','16','624',1,'0','Cooking Gas','1',736.00,710.00,47.00,92.12,33370.00,'',0.00,0.00,0.00,5),(634,'4','283','16','625',1,'0','Cooking Gas','1',736.00,710.00,12.50,24.50,8875.00,'',0.00,0.00,0.00,5),(635,'4','283','16','626',1,'0','Cooking Gas','1',736.00,736.00,7.00,13.72,5152.00,'',0.00,0.00,0.00,5),(638,'4','283','16','629',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(639,'4','283','16','630',1,'0','Cooking Gas','1',736.00,736.00,4.08,8.00,3000.00,'',0.00,0.00,0.00,5),(640,'4','283','16','631',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(641,'4','283','16','632',1,'0','Cooking Gas','1',736.00,736.00,1.00,1.96,736.00,'',0.00,0.00,0.00,5),(643,'4','283','17','634',1,'0','Cooking Gas','1',736.00,736.00,198.00,388.08,145728.00,'',0.00,0.00,0.00,5),(644,'4','283','17','635',1,'0','Cooking Gas','1',736.00,736.00,12.00,23.52,8832.00,'',0.00,0.00,0.00,5),(645,'4','283','17','636',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(646,'4','283','17','637',1,'0','Cooking Gas','1',736.00,736.00,72.00,141.12,52992.00,'',0.00,0.00,0.00,5),(647,'4','283','17','638',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(648,'4','283','17','639',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(649,'4','283','17','640',1,'0','Cooking Gas','1',736.00,736.00,1.36,2.67,1000.00,'',0.00,0.00,0.00,5),(650,'4','283','17','641',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(651,'4','283','17','642',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(652,'4','283','17','643',1,'0','Cooking Gas','1',736.00,736.00,150.00,294.00,110400.00,'',0.00,0.00,0.00,5),(653,'4','283','17','644',1,'0','Cooking Gas','1',736.00,736.00,5.00,9.80,3680.00,'',0.00,0.00,0.00,5),(654,'4','283','17','645',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(655,'4','283','17','646',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(656,'4','283','17','647',1,'0','Cooking Gas','1',736.00,736.00,125.00,245.00,92000.00,'',0.00,0.00,0.00,5),(657,'4','283','17','648',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(659,'4','283','17','650',1,'0','Cooking Gas','1',736.00,736.00,37.50,73.50,27600.00,'',0.00,0.00,0.00,5),(660,'4','283','17','651',1,'0','Cooking Gas','1',736.00,736.00,36.18,70.91,26625.00,'',0.00,0.00,0.00,5),(661,'4','283','17','652',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(662,'4','283','18','653',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(663,'4','283','18','654',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(664,'4','283','18','655',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(665,'4','283','18','656',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(667,'4','283','18','658',1,'0','Cooking Gas','1',736.00,736.00,25.00,49.00,18400.00,'',0.00,0.00,0.00,5),(668,'4','283','18','659',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(669,'4','283','18','660',1,'0','Cooking Gas','1',736.00,710.00,50.00,98.00,35500.00,'',0.00,0.00,0.00,5),(670,'4','283','18','661',1,'0','Cooking Gas','1',736.00,736.00,7.00,13.72,5152.00,'',0.00,0.00,0.00,5),(672,'4','283','18','663',1,'0','Cooking Gas','1',736.00,710.00,50.00,98.00,35500.00,'',0.00,0.00,0.00,5),(673,'4','283','18','664',1,'0','Cooking Gas','1',736.00,736.00,11.50,22.54,8464.00,'',0.00,0.00,0.00,5),(674,'4','283','18','665',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(675,'4','283','18','666',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(676,'4','283','18','667',1,'0','Cooking Gas','1',736.00,736.00,11.00,21.56,8096.00,'',0.00,0.00,0.00,5),(677,'4','283','18','668',1,'0','Cooking Gas','1',736.00,736.00,4.08,8.00,3000.00,'',0.00,0.00,0.00,5),(678,'4','283','18','669',1,'0','Cooking Gas','1',736.00,736.00,5.00,9.80,3680.00,'',0.00,0.00,0.00,5),(679,'4','283','18','670',1,'0','Cooking Gas','1',736.00,736.00,2.00,3.92,1472.00,'',0.00,0.00,0.00,5),(680,'4','283','18','671',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(681,'4','283','18','672',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(682,'4','283','18','673',1,'0','Cooking Gas','1',736.00,736.00,5.00,9.80,3680.00,'',0.00,0.00,0.00,5),(683,'4','283','18','674',1,'0','Cooking Gas','1',736.00,710.00,62.50,122.50,44375.00,'',0.00,0.00,0.00,5),(684,'4','283','18','675',1,'0','Cooking Gas','1',736.00,736.00,2.00,3.92,1472.00,'',0.00,0.00,0.00,5),(685,'4','283','18','676',1,'0','Cooking Gas','1',736.00,736.00,5.00,9.80,3680.00,'',0.00,0.00,0.00,5),(686,'4','283','18','677',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(687,'4','283','18','678',1,'0','Cooking Gas','1',736.00,736.00,4.76,9.33,3500.00,'',0.00,0.00,0.00,5),(688,'4','283','18','679',1,'0','Cooking Gas','1',736.00,736.00,6.11,11.98,4500.00,'',0.00,0.00,0.00,5),(689,'4','283','18','680',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(690,'4','283','18','681',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(691,'4','283','18','682',1,'0','Cooking Gas','1',736.00,710.00,12.50,24.50,8875.00,'',0.00,0.00,0.00,5),(692,'4','283','18','683',1,'0','Cooking Gas','1',736.00,736.00,2.00,3.92,1472.00,'',0.00,0.00,0.00,5),(693,'4','283','18','684',1,'0','Cooking Gas','1',736.00,736.00,4.08,8.00,3000.00,'',0.00,0.00,0.00,5),(694,'4','283','18','685',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(695,'4','283','18','686',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(696,'4','283','18','687',1,'0','Cooking Gas','1',736.00,736.00,8.15,15.97,6000.00,'',0.00,0.00,0.00,5),(697,'4','283','18','688',1,'0','Cooking Gas','1',736.00,736.00,4.00,7.84,2944.00,'',0.00,0.00,0.00,5),(698,'4','283','18','689',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(699,'4','283','18','690',1,'0','Cooking Gas','1',736.00,736.00,2.72,5.33,2000.00,'',0.00,0.00,0.00,5),(701,'4','283','18','692',1,'0','Cooking Gas','1',736.00,736.00,4.00,7.84,2944.00,'',0.00,0.00,0.00,5),(703,'4','283','18','694',1,'0','Cooking Gas','1',736.00,710.00,12.50,24.50,8875.00,'',0.00,0.00,0.00,5),(704,'4','283','18','695',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(705,'4','283','18','696',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(706,'4','283','18','697',1,'0','Cooking Gas','1',736.00,736.00,2.72,5.33,2000.00,'',0.00,0.00,0.00,5),(707,'4','283','18','698',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(708,'4','283','18','699',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(709,'4','283','18','700',1,'0','Cooking Gas','1',736.00,736.00,1.36,2.67,1000.00,'',0.00,0.00,0.00,5),(710,'4','283','18','701',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(711,'4','283','18','702',1,'0','Cooking Gas','1',736.00,736.00,2.00,3.92,1472.00,'',0.00,0.00,0.00,5),(712,'4','283','18','703',1,'0','Cooking Gas','1',736.00,710.00,50.00,98.00,35500.00,'',0.00,0.00,0.00,5),(713,'4','283','18','704',1,'0','Cooking Gas','1',736.00,710.00,147.00,288.12,104370.00,'',0.00,0.00,0.00,5),(714,'4','283','18','705',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(715,'4','283','18','706',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(716,'4','283','18','707',1,'0','Cooking Gas','1',736.00,736.00,6.79,13.31,5000.00,'',0.00,0.00,0.00,5),(717,'4','283','18','708',1,'0','Cooking Gas','1',736.00,736.00,2.00,3.92,1472.00,'',0.00,0.00,0.00,5),(718,'4','283','18','709',1,'0','Cooking Gas','1',736.00,736.00,4.89,9.58,3600.00,'',0.00,0.00,0.00,5),(720,'4','283','18','711',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(721,'4','283','19','712',1,'0','Cooking Gas','1',736.00,710.00,500.00,980.00,355000.00,'',0.00,0.00,0.00,5),(722,'4','283','19','713',1,'0','Cooking Gas','1',736.00,736.00,78.00,152.88,57408.00,'',0.00,0.00,0.00,5),(723,'4','283','19','714',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(724,'4','283','19','715',1,'0','Cooking Gas','1',736.00,736.00,2208.00,4327.68,1625088.00,'',0.00,0.00,0.00,5),(725,'4','283','19','716',1,'0','Cooking Gas','1',736.00,736.00,4.00,7.84,2944.00,'',0.00,0.00,0.00,5),(726,'4','283','19','717',1,'0','Cooking Gas','1',736.00,736.00,10.00,19.60,7360.00,'',0.00,0.00,0.00,5),(727,'4','283','19','718',1,'0','Cooking Gas','1',736.00,736.00,5.00,9.80,3680.00,'',0.00,0.00,0.00,5),(728,'4','283','19','719',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(729,'4','283','19','720',1,'0','Cooking Gas','1',736.00,736.00,5.03,9.86,3700.00,'',0.00,0.00,0.00,5),(731,'4','283','19','722',1,'0','Cooking Gas','1',736.00,710.00,100.00,196.00,71000.00,'',0.00,0.00,0.00,5),(732,'4','283','19','723',1,'0','Cooking Gas','1',736.00,736.00,2.04,4.00,1500.00,'',0.00,0.00,0.00,5),(733,'4','283','19','724',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(734,'4','283','19','725',1,'0','Cooking Gas','1',736.00,736.00,2.04,4.00,1500.00,'',0.00,0.00,0.00,5),(735,'4','283','19','726',1,'0','Cooking Gas','1',736.00,736.00,8.00,15.68,5888.00,'',0.00,0.00,0.00,5),(737,'4','283','19','728',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(738,'4','283','19','729',1,'0','Cooking Gas','1',736.00,736.00,2.00,3.92,1472.00,'',0.00,0.00,0.00,5),(739,'4','283','19','730',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(740,'4','283','19','731',1,'0','Cooking Gas','1',736.00,736.00,1.09,2.14,800.00,'',0.00,0.00,0.00,5),(741,'4','283','19','732',1,'0','Cooking Gas','1',736.00,736.00,10.00,19.60,7360.00,'',0.00,0.00,0.00,5),(742,'4','283','19','733',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(743,'4','283','19','734',1,'0','Cooking Gas','1',736.00,736.00,6.79,13.31,5000.00,'',0.00,0.00,0.00,5),(744,'4','283','19','735',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(745,'4','283','19','736',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(746,'4','283','19','737',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(747,'4','283','19','738',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(748,'4','283','19','739',1,'0','Cooking Gas','1',736.00,710.00,12.50,24.50,8875.00,'',0.00,0.00,0.00,5),(749,'4','283','19','740',1,'0','Cooking Gas','1',736.00,736.00,10.00,19.60,7360.00,'',0.00,0.00,0.00,5),(750,'4','283','19','741',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(751,'4','283','20','742',1,'0','Cooking Gas','1',736.00,736.00,3.40,6.66,2500.00,'',0.00,0.00,0.00,5),(752,'4','283','20','743',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(754,'4','283','20','745',1,'0','Cooking Gas','1',736.00,736.00,2.00,3.92,1472.00,'',0.00,0.00,0.00,5),(755,'4','283','20','746',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(756,'4','283','20','747',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(757,'4','283','20','748',1,'0','Cooking Gas','1',736.00,736.00,1.36,2.67,1000.00,'',0.00,0.00,0.00,5),(758,'4','283','20','749',1,'0','Cooking Gas','1',736.00,736.00,7.00,13.72,5152.00,'',0.00,0.00,0.00,5),(759,'4','283','20','750',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(760,'4','283','20','751',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(761,'4','283','20','752',1,'0','Cooking Gas','1',736.00,736.00,5.00,9.80,3680.00,'',0.00,0.00,0.00,5),(762,'4','283','20','753',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(763,'4','283','20','754',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(764,'4','283','20','755',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(765,'4','283','20','756',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(766,'4','283','20','757',1,'0','Cooking Gas','1',736.00,736.00,5.00,9.80,3680.00,'',0.00,0.00,0.00,5),(767,'4','283','20','758',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(768,'4','283','20','759',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(769,'4','283','20','760',1,'0','Cooking Gas','1',736.00,736.00,10.50,20.58,7728.00,'',0.00,0.00,0.00,5),(770,'4','283','20','761',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(771,'4','283','20','762',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(772,'4','283','20','763',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(773,'4','283','20','764',1,'0','Cooking Gas','1',736.00,736.00,5.00,9.80,3680.00,'',0.00,0.00,0.00,5),(774,'4','283','20','765',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(775,'4','283','20','766',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(776,'4','283','20','767',1,'0','Cooking Gas','1',736.00,736.00,5.43,10.64,4000.00,'',0.00,0.00,0.00,5),(777,'4','283','20','768',1,'0','Cooking Gas','1',736.00,736.00,4.00,7.84,2944.00,'',0.00,0.00,0.00,5),(778,'4','283','20','769',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(779,'4','283','20','770',1,'0','Cooking Gas','1',736.00,736.00,4.00,7.84,2944.00,'',0.00,0.00,0.00,5),(780,'4','283','20','771',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(781,'4','283','20','772',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(782,'4','283','20','773',1,'0','Cooking Gas','1',736.00,736.00,9.00,17.64,6624.00,'',0.00,0.00,0.00,5),(783,'4','283','20','774',1,'0','Cooking Gas','1',736.00,710.00,20.00,39.20,14200.00,'',0.00,0.00,0.00,5),(784,'4','283','20','775',1,'0','Cooking Gas','1',736.00,710.00,47.00,92.12,33370.00,'',0.00,0.00,0.00,5),(785,'4','283','20','776',1,'0','Cooking Gas','1',736.00,710.00,61.50,120.54,43665.00,'',0.00,0.00,0.00,5),(786,'4','283','20','777',1,'0','Cooking Gas','1',736.00,736.00,18.00,35.28,13248.00,'',0.00,0.00,0.00,5),(787,'4','283','20','778',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(788,'4','283','20','779',1,'0','Cooking Gas','1',736.00,736.00,7.00,13.72,5152.00,'',0.00,0.00,0.00,5),(789,'4','283','20','780',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(790,'4','283','20','781',1,'0','Cooking Gas','1',736.00,736.00,1.36,2.67,1000.00,'',0.00,0.00,0.00,5),(791,'4','283','20','782',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(792,'4','283','20','783',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(793,'4','283','20','784',1,'0','Cooking Gas','1',736.00,736.00,2.72,5.33,2000.00,'',0.00,0.00,0.00,5),(794,'4','283','20','785',1,'0','Cooking Gas','1',736.00,736.00,2.72,5.33,2000.00,'',0.00,0.00,0.00,5),(795,'4','283','20','786',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(796,'4','283','20','787',1,'0','Cooking Gas','1',736.00,736.00,4.08,8.00,3000.00,'',0.00,0.00,0.00,5),(797,'4','283','20','788',1,'0','Cooking Gas','1',736.00,736.00,6.00,11.76,4416.00,'',0.00,0.00,0.00,5),(798,'4','283','20','789',1,'0','Cooking Gas','1',736.00,736.00,5.43,10.64,4000.00,'',0.00,0.00,0.00,5),(799,'4','283','20','790',1,'0','Cooking Gas','1',736.00,736.00,4.00,7.84,2944.00,'',0.00,0.00,0.00,5),(800,'4','283','20','791',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(801,'4','283','20','792',1,'0','Cooking Gas','1',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(802,'4','283','20','793',1,'0','Cooking Gas','1',736.00,736.00,11.00,21.56,8096.00,'',0.00,0.00,0.00,5),(803,'4','283','20','794',1,'0','Cooking Gas','1',736.00,736.00,55.00,107.80,40480.00,'',0.00,0.00,0.00,5),(804,'4','283','20','795',1,'0','Cooking Gas','1',736.00,736.00,12.23,23.97,9000.00,'',0.00,0.00,0.00,5),(805,'4','283','20','796',1,'0','Cooking Gas','2',736.00,710.00,100.00,196.00,71000.00,'',0.00,0.00,0.00,5),(806,'4','283','20','797',1,'0','Cooking Gas','2',736.00,710.00,50.00,98.00,35500.00,'',0.00,0.00,0.00,5),(807,'4','283','20','798',1,'0','Cooking Gas','1',736.00,736.00,3.00,5.88,2208.00,'',0.00,0.00,0.00,5),(808,'4','283','20','799',1,'0','Cooking Gas','3',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(809,'4','283','20','800',1,'0','Cooking Gas','2',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5),(810,'4','283','20','801',1,'0','Cooking Gas','2',736.00,736.00,12.50,24.50,9200.00,'',0.00,0.00,0.00,5);
/*!40000 ALTER TABLE `retail_sales_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_payments`
--

DROP TABLE IF EXISTS `retail_sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_payments` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `payment_method` varchar(50) NOT NULL,
  `account_type` varchar(10) DEFAULT NULL,
  `account_id` bigint DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_by` bigint DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`sale_id`,`payment_method`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`account_type`),
  KEY `parent_id` (`created_by`)
) ENGINE=InnoDB AUTO_INCREMENT=733 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_payments`
--

LOCK TABLES `retail_sales_payments` WRITE;
/*!40000 ALTER TABLE `retail_sales_payments` DISABLE KEYS */;
INSERT INTO `retail_sales_payments` VALUES (1,'4','283','1','1','cash','6.1',4,14060.00,954,'2023-02-05 16:57:17'),(2,'4','283','2','2','cash','6.1',4,11780.00,955,'2023-02-06 14:54:33'),(3,'4','283','2','3','cash','6.1',4,19000.00,955,'2023-02-06 14:58:06'),(4,'4','283','2','4','cash','6.1',4,11400.00,955,'2023-02-06 15:01:10'),(5,'4','283','2','5','cash','6.1',4,225000.00,955,'2023-02-06 15:16:48'),(6,'4','283','3','6','cash','6.1',4,14060.00,955,'2023-02-11 13:04:42'),(7,'4','283','4','7','cash','6.1',4,1520.00,955,'2023-02-12 17:55:13'),(8,'4','283','4','8','cash','6.1',4,375000.00,955,'2023-02-12 17:56:53'),(9,'4','283','4','9','pos','2',6,95000.00,955,'2023-02-12 18:19:11'),(10,'4','283','4','10','cash','6.1',4,760.00,954,'2023-02-12 18:20:07'),(11,'4','283','4','13','cash','6.1',4,11400.00,955,'2023-02-12 18:22:40'),(12,'4','283','4','12','cash','6.1',4,11400.00,955,'2023-02-12 18:23:22'),(13,'4','283','4','14','cash','6.1',4,7600.00,955,'2023-02-12 18:30:16'),(14,'4','283','4','15','cash','6.1',4,38000.00,955,'2023-02-12 18:32:41'),(15,'4','283','4','16','pos','2',6,562500.00,955,'2023-02-12 18:34:39'),(16,'4','283','4','11','cash','6.1',4,11400.00,955,'2023-02-12 18:35:43'),(17,'4','283','4','17','cash','6.1',4,2280.00,955,'2023-02-12 18:59:34'),(18,'4','283','4','18','cash','6.1',4,19000.00,955,'2023-02-12 19:02:48'),(19,'4','283','5','19','cash','6.1',4,11400.00,955,'2023-02-12 19:12:38'),(20,'4','283','5','20','pos','2',6,11400.00,955,'2023-02-12 19:15:30'),(21,'4','283','5','21','cash','6.1',4,16340.00,955,'2023-02-12 19:18:06'),(22,'4','283','5','22','cash','6.1',4,3800.00,955,'2023-02-12 19:21:47'),(23,'4','283','5','23','cash','6.1',4,6840.00,955,'2023-02-12 19:35:44'),(24,'4','283','5','24','cash','6.1',4,11400.00,955,'2023-02-12 19:41:27'),(25,'4','283','5','25','cash','6.1',4,11400.00,954,'2023-02-12 19:43:24'),(26,'4','283','6','27','pos','2',6,3800.00,955,'2023-02-13 10:31:58'),(27,'4','283','6','28','cash','6.1',4,23000.00,955,'2023-02-13 10:43:04'),(28,'4','283','6','31','cash','6.1',4,760.00,955,'2023-02-13 12:04:37'),(29,'4','283','6','32','cash','6.1',4,375000.00,955,'2023-02-13 17:18:36'),(30,'4','283','6','33','pos','2',6,112500.00,955,'2023-02-13 17:20:39'),(31,'4','283','6','34','cash','6.1',4,2280.00,955,'2023-02-13 17:27:05'),(32,'4','283','6','35','cash','6.1',4,14060.00,955,'2023-02-13 21:49:11'),(33,'4','283','6','36','cash','6.1',4,19000.00,955,'2023-02-13 22:21:32'),(34,'4','283','6','37','cash','6.1',4,19000.00,955,'2023-02-13 22:44:24'),(35,'4','283','7','38','cash','6.1',4,4560.00,955,'2023-02-14 10:40:46'),(36,'4','283','7','40','cash','6.1',4,6840.00,955,'2023-02-14 14:09:59'),(37,'4','283','7','41','cash','6.1',4,225000.00,955,'2023-02-14 15:08:40'),(38,'4','283','7','42','cash','6.1',4,375000.00,955,'2023-02-14 18:08:51'),(39,'4','283','7','43','cash','6.1',4,375000.00,955,'2023-02-14 18:15:09'),(40,'4','283','7','44','cash','6.1',4,19000.00,955,'2023-02-15 10:28:05'),(41,'4','283','8','45','cash','6.1',4,3040.00,955,'2023-02-16 13:34:34'),(42,'4','283','8','46','pos','2',6,262500.00,955,'2023-02-16 13:53:03'),(43,'4','283','8','47','pos','2',6,70000.00,955,'2023-02-16 14:04:38'),(44,'4','283','8','48','cash','6.1',4,5000.00,955,'2023-02-16 14:19:04'),(45,'4','283','8','49','pos','2',6,70000.00,955,'2023-02-16 14:23:15'),(46,'4','283','8','50','cash','6.1',4,5152.00,955,'2023-02-16 14:46:51'),(47,'4','283','8','51','pos','2',6,76000.00,955,'2023-02-16 15:04:10'),(48,'4','283','8','52','pos','2',6,177500.00,955,'2023-02-16 16:02:16'),(49,'4','283','8','53','pos','2',6,106500.00,955,'2023-02-16 16:09:48'),(50,'4','283','10','54','cash','6.1',4,6624.00,955,'2023-03-04 18:25:06'),(51,'4','283','11','55','pos','2',6,9200.00,955,'2023-03-05 09:31:11'),(52,'4','283','11','56','pos','2',6,4416.00,955,'2023-03-05 09:46:03'),(53,'4','283','11','57','pos','2',6,4400.00,955,'2023-03-05 09:55:00'),(54,'4','283','11','58','pos','2',6,900.00,955,'2023-03-05 09:57:23'),(55,'4','283','11','59','cash','6.1',4,4416.00,955,'2023-03-05 10:00:24'),(56,'4','283','11','60','cash','6.1',4,13616.00,955,'2023-03-05 10:48:46'),(57,'4','283','11','61','cash','6.1',4,2208.00,955,'2023-03-05 10:52:29'),(58,'4','283','11','62','cash','6.1',4,3680.00,955,'2023-03-05 10:54:38'),(59,'4','283','11','62','cash','6.1',4,3680.00,955,'2023-03-05 10:54:39'),(60,'4','283','11','63','cash','6.1',4,1500.00,955,'2023-03-05 10:58:01'),(61,'4','283','11','65','cash','6.1',4,5000.00,955,'2023-03-05 11:11:24'),(62,'4','283','11','65','cash','6.1',4,5000.00,955,'2023-03-05 11:11:25'),(63,'4','283','11','66','cash','6.1',4,4416.00,955,'2023-03-05 11:13:06'),(64,'4','283','11','67','cash','6.1',4,9200.00,955,'2023-03-05 11:15:11'),(65,'4','283','11','69','cash','6.1',4,2208.00,955,'2023-03-05 11:17:00'),(66,'4','283','11','71','cash','6.1',4,9200.00,955,'2023-03-05 11:18:28'),(67,'4','283','11','73','cash','6.1',4,1472.00,955,'2023-03-05 11:21:36'),(68,'4','283','11','73','cash','6.1',4,1472.00,955,'2023-03-05 11:21:37'),(69,'4','283','11','74','cash','6.1',4,4416.00,955,'2023-03-05 11:23:46'),(70,'4','283','11','75','cash','6.1',4,9200.00,955,'2023-03-05 11:25:16'),(71,'4','283','11','78','bank','2',6,9200.00,955,'2023-03-05 11:32:36'),(72,'4','283','11','79','bank','2',6,1472.00,955,'2023-03-05 11:34:26'),(73,'4','283','11','80','cash','6.1',4,12880.00,955,'2023-03-05 11:52:49'),(74,'4','283','11','80','cash','6.1',4,12880.00,955,'2023-03-05 11:52:50'),(75,'4','283','11','81','cash','6.1',4,6624.00,955,'2023-03-05 11:54:48'),(76,'4','283','11','82','cash','6.1',4,2250.00,955,'2023-03-05 11:57:32'),(77,'4','283','11','83','cash','6.1',4,3680.00,955,'2023-03-05 12:02:12'),(78,'4','283','11','83','cash','6.1',4,3680.00,955,'2023-03-05 12:02:14'),(79,'4','283','11','84','cash','6.1',4,5888.00,955,'2023-03-05 12:09:50'),(80,'4','283','11','85','cash','6.1',4,2208.00,955,'2023-03-05 12:13:05'),(81,'4','283','11','86','cash','6.1',4,736.00,955,'2023-03-05 12:16:35'),(82,'4','283','11','87','cash','6.1',4,3680.00,955,'2023-03-05 12:20:26'),(83,'4','283','11','88','cash','6.1',4,1472.00,955,'2023-03-05 12:22:07'),(84,'4','283','11','89','cash','6.1',4,2208.00,955,'2023-03-05 12:23:50'),(85,'4','283','11','90','cash','6.1',4,5152.00,955,'2023-03-05 12:26:15'),(86,'4','283','11','92','cash','6.1',4,6624.00,955,'2023-03-05 12:27:58'),(87,'4','283','11','93','cash','6.1',4,2500.00,955,'2023-03-05 12:29:50'),(88,'4','283','11','94','cash','6.1',4,4416.00,955,'2023-03-05 12:32:16'),(89,'4','283','11','96','cash','6.1',4,2208.00,955,'2023-03-05 12:35:20'),(90,'4','283','11','97','cash','6.1',4,1472.00,955,'2023-03-05 12:37:46'),(91,'4','283','11','97','cash','6.1',4,1472.00,955,'2023-03-05 12:37:47'),(92,'4','283','11','98','cash','6.1',4,3000.00,955,'2023-03-05 12:39:33'),(93,'4','283','11','99','cash','6.1',4,2208.00,955,'2023-03-05 12:41:36'),(94,'4','283','11','100','cash','6.1',4,9200.00,955,'2023-03-05 12:47:13'),(95,'4','283','11','101','cash','6.1',4,7360.00,955,'2023-03-05 12:49:38'),(96,'4','283','11','101','cash','6.1',4,7360.00,955,'2023-03-05 12:49:39'),(97,'4','283','11','102','cash','6.1',4,2000.00,955,'2023-03-05 12:52:01'),(98,'4','283','11','104','cash','6.1',4,1500.00,955,'2023-03-05 12:53:27'),(99,'4','283','11','106','cash','6.1',4,34080.00,955,'2023-03-05 13:00:01'),(100,'4','283','11','106','cash','6.1',4,34080.00,955,'2023-03-05 13:00:02'),(101,'4','283','11','107','cash','6.1',4,5000.00,955,'2023-03-05 13:02:24'),(102,'4','283','11','109','cash','6.1',4,9200.00,955,'2023-03-05 13:04:09'),(103,'4','283','11','109','cash','6.1',4,9200.00,955,'2023-03-05 13:04:10'),(104,'4','283','11','111','pos','2',6,4000.00,955,'2023-03-05 13:10:34'),(105,'4','283','11','112','pos','2',6,9200.00,955,'2023-03-05 13:17:24'),(106,'4','283','11','113','bank','2',6,8832.00,955,'2023-03-05 13:21:11'),(107,'4','283','11','114','pos','2',6,3680.00,955,'2023-03-05 13:24:11'),(108,'4','283','11','116','pos','2',6,2208.00,955,'2023-03-05 13:29:12'),(109,'4','283','11','117','pos','2',6,2208.00,955,'2023-03-05 13:32:06'),(110,'4','283','11','118','pos','2',6,3680.00,955,'2023-03-05 13:34:49'),(111,'4','283','11','119','pos','2',6,2944.00,955,'2023-03-05 13:37:27'),(112,'4','283','11','120','cash','6.1',4,2500.00,955,'2023-03-05 13:39:49'),(113,'4','283','11','121','pos','2',6,3000.00,955,'2023-03-05 13:43:00'),(114,'4','283','11','122','pos','2',6,736.00,955,'2023-03-05 13:45:37'),(115,'4','283','11','123','pos','2',6,18400.00,955,'2023-03-05 13:47:40'),(116,'4','283','11','124','pos','2',6,9200.00,955,'2023-03-05 13:50:09'),(117,'4','283','11','125','pos','2',6,1000.00,955,'2023-03-05 13:52:30'),(118,'4','283','11','126','pos','2',6,4416.00,955,'2023-03-05 13:58:53'),(119,'4','283','11','127','pos','2',6,4416.00,955,'2023-03-05 14:01:02'),(120,'4','283','11','128','cash','6.1',4,1500.00,955,'2023-03-05 17:03:44'),(121,'4','283','11','129','pos','2',6,12880.00,955,'2023-03-05 17:07:35'),(122,'4','283','11','130','bank','2',6,12144.00,955,'2023-03-05 17:09:47'),(123,'4','283','11','131','pos','2',6,9200.00,955,'2023-03-05 17:12:44'),(124,'4','283','11','132','pos','2',6,1472.00,955,'2023-03-05 17:18:56'),(125,'4','283','11','133','cash','6.1',4,400.00,955,'2023-03-05 17:21:54'),(126,'4','283','11','134','pos','2',6,7360.00,955,'2023-03-05 17:24:36'),(127,'4','283','11','135','pos','2',6,3680.00,955,'2023-03-05 17:27:20'),(128,'4','283','11','136','pos','2',6,736.00,955,'2023-03-05 17:30:30'),(129,'4','283','11','137','pos','2',6,3680.00,955,'2023-03-05 17:32:53'),(130,'4','283','11','138','pos','2',6,2944.00,955,'2023-03-05 17:35:40'),(131,'4','283','11','139','pos','2',6,3680.00,955,'2023-03-05 17:40:43'),(132,'4','283','11','140','pos','2',6,3680.00,955,'2023-03-05 17:42:42'),(133,'4','283','11','141','pos','2',6,4416.00,955,'2023-03-05 17:44:46'),(134,'4','283','11','142','pos','2',6,3680.00,955,'2023-03-05 17:47:26'),(135,'4','283','11','143','pos','2',6,1000.00,955,'2023-03-05 17:49:52'),(136,'4','283','11','144','pos','2',6,3000.00,955,'2023-03-05 17:52:32'),(137,'4','283','11','145','pos','2',6,9200.00,955,'2023-03-05 17:55:18'),(138,'4','283','11','146','cash','6.1',4,9200.00,955,'2023-03-06 08:03:30'),(139,'4','283','11','149','cash','6.1',4,2208.00,955,'2023-03-06 08:06:40'),(140,'4','283','11','150','cash','6.1',4,18400.00,955,'2023-03-06 08:08:23'),(141,'4','283','11','151','cash','6.1',4,6000.00,955,'2023-03-06 08:10:22'),(142,'4','283','11','152','cash','6.1',4,1472.00,955,'2023-03-06 08:13:49'),(143,'4','283','11','155','cash','6.1',4,9200.00,955,'2023-03-06 08:16:10'),(144,'4','283','11','157','cash','6.1',4,8832.00,955,'2023-03-06 08:17:55'),(145,'4','283','11','158','cash','6.1',4,750.00,955,'2023-03-06 08:30:06'),(146,'4','283','11','159','cash','6.1',4,6992.00,955,'2023-03-06 08:33:18'),(147,'4','283','11','160','cash','6.1',4,8832.00,955,'2023-03-06 08:43:40'),(148,'4','283','11','162','cash','6.1',4,2300.00,955,'2023-03-06 08:49:21'),(149,'4','283','11','164','cash','6.1',4,4000.00,955,'2023-03-06 09:03:03'),(150,'4','283','11','165','cash','6.1',4,2208.00,955,'2023-03-06 09:10:23'),(151,'4','283','11','166','cash','6.1',4,4416.00,955,'2023-03-06 09:12:08'),(152,'4','283','11','167','cash','6.1',4,3000.00,955,'2023-03-06 09:15:23'),(153,'4','283','11','168','cash','6.1',4,2208.00,955,'2023-03-06 09:17:10'),(154,'4','283','11','169','cash','6.1',4,11408.00,955,'2023-03-06 09:20:28'),(155,'4','283','11','169','cash','6.1',4,11408.00,955,'2023-03-06 09:20:29'),(156,'4','283','11','170','cash','6.1',4,2208.00,955,'2023-03-06 09:23:52'),(157,'4','283','11','171','cash','6.1',4,4416.00,955,'2023-03-06 09:26:24'),(158,'4','283','12','172','pos','2',6,9200.00,955,'2023-03-09 13:06:55'),(159,'4','283','12','173','pos','2',6,3680.00,955,'2023-03-09 13:17:37'),(160,'4','283','12','174','pos','2',6,2208.00,955,'2023-03-09 13:24:39'),(161,'4','283','12','175','pos','2',6,2208.00,955,'2023-03-09 13:53:17'),(162,'4','283','12','176','pos','2',6,4416.00,955,'2023-03-09 13:57:40'),(163,'4','283','12','177','pos','2',6,6624.00,955,'2023-03-09 14:07:44'),(164,'4','283','12','178','pos','2',6,3680.00,955,'2023-03-09 14:23:28'),(165,'4','283','12','179','pos','2',6,9200.00,955,'2023-03-09 14:38:20'),(166,'4','283','12','180','pos','2',6,18400.00,955,'2023-03-09 14:40:42'),(167,'4','283','12','181','pos','2',6,4416.00,955,'2023-03-09 14:43:55'),(168,'4','283','12','182','pos','2',6,4416.00,955,'2023-03-09 14:45:41'),(169,'4','283','12','183','pos','2',6,8875.00,955,'2023-03-09 14:53:52'),(170,'4','283','12','184','cash','6.1',4,736.00,955,'2023-03-09 14:56:04'),(171,'4','283','12','185','cash','6.1',4,2000.00,955,'2023-03-09 14:58:41'),(172,'4','283','12','186','pos','2',6,3680.00,955,'2023-03-09 15:01:27'),(173,'4','283','12','187','pos','2',6,2208.00,955,'2023-03-09 15:03:46'),(174,'4','283','12','188','pos','2',6,2208.00,955,'2023-03-09 15:05:48'),(175,'4','283','12','189','pos','2',6,3680.00,955,'2023-03-09 15:07:55'),(176,'4','283','12','190','pos','2',6,5000.00,955,'2023-03-09 15:09:49'),(177,'4','283','12','191','pos','2',6,2000.00,955,'2023-03-09 15:11:46'),(178,'4','283','12','192','pos','2',6,2944.00,955,'2023-03-09 15:13:30'),(179,'4','283','12','193','pos','2',6,2208.00,955,'2023-03-09 15:15:53'),(180,'4','283','12','194','pos','2',6,4416.00,955,'2023-03-09 15:17:47'),(181,'4','283','12','195','pos','2',6,3680.00,955,'2023-03-09 15:23:23'),(182,'4','283','12','196','pos','2',6,13616.00,955,'2023-03-09 15:27:46'),(183,'4','283','12','197','pos','2',6,5888.00,955,'2023-03-09 15:30:08'),(184,'4','283','12','198','pos','2',6,2944.00,955,'2023-03-09 15:35:37'),(185,'4','283','12','199','pos','2',6,9200.00,955,'2023-03-09 15:37:34'),(186,'4','283','12','200','pos','2',6,2208.00,955,'2023-03-09 15:41:16'),(187,'4','283','12','201','pos','2',6,7360.00,955,'2023-03-09 15:43:03'),(188,'4','283','12','202','pos','2',6,4416.00,955,'2023-03-09 15:45:39'),(189,'4','283','12','203','pos','2',6,2600.00,955,'2023-03-09 15:48:21'),(190,'4','283','12','203','pos','2',6,2600.00,955,'2023-03-09 15:48:57'),(191,'4','283','12','205','pos','2',6,4416.00,955,'2023-03-09 15:59:00'),(192,'4','283','12','206','pos','2',6,5152.00,955,'2023-03-09 16:01:46'),(193,'4','283','12','207','pos','2',6,9200.00,955,'2023-03-09 16:07:07'),(194,'4','283','12','209','pos','2',6,3680.00,955,'2023-03-09 16:10:54'),(195,'4','283','12','210','pos','2',6,7360.00,955,'2023-03-09 16:30:07'),(196,'4','283','12','212','pos','2',6,1500.00,955,'2023-03-09 16:33:41'),(197,'4','283','12','213','pos','2',6,15456.00,955,'2023-03-09 16:38:24'),(198,'4','283','12','214','pos','2',6,2944.00,955,'2023-03-09 16:40:16'),(199,'4','283','12','215','pos','2',6,4416.00,955,'2023-03-09 16:45:39'),(200,'4','283','12','216','pos','2',6,27232.00,955,'2023-03-09 16:51:31'),(201,'4','283','12','217','pos','2',6,4000.00,955,'2023-03-09 16:55:25'),(202,'4','283','12','218','pos','2',6,3680.00,955,'2023-03-09 17:06:05'),(203,'4','283','12','219','pos','2',6,2208.00,955,'2023-03-09 17:12:01'),(204,'4','283','12','220','pos','2',6,4000.00,955,'2023-03-09 17:14:21'),(205,'4','283','12','221','pos','2',6,5000.00,955,'2023-03-09 17:19:24'),(206,'4','283','12','222','pos','2',6,4416.00,955,'2023-03-09 17:21:33'),(207,'4','283','12','223','pos','2',6,2208.00,955,'2023-03-09 17:23:39'),(208,'4','283','12','224','pos','2',6,8832.00,955,'2023-03-09 17:25:28'),(209,'4','283','12','225','pos','2',6,9200.00,955,'2023-03-09 17:27:21'),(210,'4','283','12','226','pos','2',6,1472.00,955,'2023-03-09 17:31:05'),(211,'4','283','12','227','pos','2',6,1200.00,955,'2023-03-09 17:36:06'),(212,'4','283','12','228','pos','2',6,1500.00,955,'2023-03-09 17:39:29'),(213,'4','283','12','229','pos','2',6,4416.00,955,'2023-03-09 17:42:06'),(214,'4','283','12','230','pos','2',6,9200.00,955,'2023-03-09 17:44:01'),(215,'4','283','12','231','pos','2',6,2208.00,955,'2023-03-09 17:49:33'),(216,'4','283','12','232','pos','2',6,2500.00,955,'2023-03-09 17:51:31'),(217,'4','283','12','233','pos','2',6,4416.00,955,'2023-03-09 17:53:27'),(218,'4','283','13','234','cash','6.1',4,1000.00,955,'2023-03-10 09:00:02'),(219,'4','283','13','235','pos','2',6,6624.00,955,'2023-03-10 09:30:00'),(220,'4','283','13','236','cash','6.1',4,9200.00,955,'2023-03-10 09:46:55'),(221,'4','283','13','236','cash','6.1',4,9200.00,955,'2023-03-10 09:46:56'),(222,'4','283','13','237','cash','6.1',4,4416.00,955,'2023-03-10 09:48:25'),(223,'4','283','13','238','cash','6.1',4,13616.00,955,'2023-03-10 09:50:46'),(224,'4','283','13','239','cash','6.1',4,3680.00,955,'2023-03-10 09:52:07'),(225,'4','283','13','240','cash','6.1',4,2208.00,955,'2023-03-10 09:53:19'),(226,'4','283','13','240','cash','6.1',4,2208.00,955,'2023-03-10 09:53:21'),(227,'4','283','13','241','cash','6.1',4,2000.00,955,'2023-03-10 09:55:30'),(228,'4','283','13','241','cash','6.1',4,2000.00,955,'2023-03-10 09:55:31'),(229,'4','283','13','243','cash','6.1',4,4416.00,955,'2023-03-10 09:57:55'),(230,'4','283','13','245','cash','6.1',4,8096.00,955,'2023-03-10 09:59:02'),(231,'4','283','13','245','cash','6.1',4,8096.00,955,'2023-03-10 09:59:03'),(232,'4','283','13','246','cash','6.1',4,2944.00,955,'2023-03-10 10:00:09'),(233,'4','283','13','247','cash','6.1',4,1472.00,955,'2023-03-10 10:01:44'),(234,'4','283','13','248','cash','6.1',4,8832.00,955,'2023-03-10 10:03:59'),(235,'4','283','13','249','cash','6.1',4,2208.00,955,'2023-03-10 10:06:27'),(236,'4','283','13','251','cash','6.1',4,9200.00,955,'2023-03-10 10:07:57'),(237,'4','283','13','252','cash','6.1',4,1472.00,955,'2023-03-10 10:14:12'),(238,'4','283','13','253','cash','6.1',4,4416.00,955,'2023-03-10 10:15:45'),(239,'4','283','13','253','cash','6.1',4,4416.00,955,'2023-03-10 10:15:46'),(240,'4','283','13','254','cash','6.1',4,5000.00,955,'2023-03-10 10:17:15'),(241,'4','283','13','255','cash','6.1',4,4416.00,955,'2023-03-10 10:18:42'),(242,'4','283','13','257','cash','6.1',4,9200.00,955,'2023-03-10 10:20:16'),(243,'4','283','13','258','cash','6.1',4,2208.00,955,'2023-03-10 10:23:46'),(244,'4','283','13','259','cash','6.1',4,9200.00,955,'2023-03-10 10:27:07'),(245,'4','283','13','260','cash','6.1',4,5000.00,955,'2023-03-10 10:39:59'),(246,'4','283','13','262','cash','6.1',4,2208.00,955,'2023-03-10 10:42:00'),(247,'4','283','13','264','cash','6.1',4,2000.00,955,'2023-03-10 10:45:21'),(248,'4','283','13','266','cash','6.1',4,71000.00,955,'2023-03-10 10:48:36'),(249,'4','283','13','268','cash','6.1',4,9200.00,955,'2023-03-10 10:52:01'),(250,'4','283','13','269','cash','6.1',4,1472.00,955,'2023-03-10 10:53:43'),(251,'4','283','13','270','cash','6.1',4,9200.00,955,'2023-03-10 10:54:59'),(252,'4','283','13','272','cash','6.1',4,1000.00,955,'2023-03-10 10:57:59'),(253,'4','283','13','273','cash','6.1',4,6000.00,955,'2023-03-10 11:02:41'),(254,'4','283','13','274','cash','6.1',4,9200.00,955,'2023-03-10 11:05:19'),(255,'4','283','13','275','cash','6.1',4,2000.00,955,'2023-03-10 11:06:46'),(256,'4','283','13','276','cash','6.1',4,68160.00,955,'2023-03-10 11:13:41'),(257,'4','283','13','278','cash','6.1',4,9200.00,955,'2023-03-10 11:24:41'),(258,'4','283','13','278','cash','6.1',4,9200.00,955,'2023-03-10 11:24:42'),(259,'4','283','13','280','cash','6.1',4,2000.00,955,'2023-03-10 11:26:42'),(260,'4','283','13','281','cash','6.1',4,2200.00,955,'2023-03-10 11:39:21'),(261,'4','283','13','281','cash','6.1',4,2200.00,955,'2023-03-10 11:39:21'),(262,'4','283','13','281','cash','6.1',4,2200.00,955,'2023-03-10 11:39:22'),(263,'4','283','13','283','cash','6.1',4,3680.00,955,'2023-03-10 11:48:28'),(264,'4','283','13','284','cash','6.1',4,6624.00,955,'2023-03-10 11:51:39'),(265,'4','283','13','286','cash','6.1',4,1000.00,955,'2023-03-10 12:03:39'),(266,'4','283','13','287','cash','6.1',4,9200.00,955,'2023-03-10 12:07:56'),(267,'4','283','13','289','cash','6.1',4,3000.00,955,'2023-03-10 12:10:11'),(268,'4','283','13','290','cash','6.1',4,4000.00,955,'2023-03-10 12:22:49'),(269,'4','283','13','292','cash','6.1',4,2500.00,955,'2023-03-10 12:27:24'),(270,'4','283','13','293','cash','6.1',4,3680.00,955,'2023-03-10 12:32:21'),(271,'4','283','13','294','cash','6.1',4,2208.00,955,'2023-03-10 12:35:36'),(272,'4','283','13','295','cash','6.1',4,4416.00,955,'2023-03-10 12:50:52'),(273,'4','283','13','296','cash','6.1',4,18400.00,955,'2023-03-10 12:52:40'),(274,'4','283','13','297','cash','6.1',4,2200.00,955,'2023-03-10 12:57:35'),(275,'4','283','13','298','cash','6.1',4,3000.00,955,'2023-03-10 13:08:17'),(276,'4','283','13','300','cash','6.1',4,9200.00,955,'2023-03-10 13:10:51'),(277,'4','283','13','301','cash','6.1',4,35500.00,955,'2023-03-10 13:13:50'),(278,'4','283','13','302','cash','6.1',4,1472.00,955,'2023-03-10 13:15:23'),(279,'4','283','13','303','cash','6.1',4,9200.00,955,'2023-03-10 13:18:31'),(280,'4','283','13','304','cash','6.1',4,4000.00,955,'2023-03-10 13:21:00'),(281,'4','283','13','306','cash','6.1',4,11408.00,955,'2023-03-10 13:23:39'),(282,'4','283','13','307','cash','6.1',4,8832.00,955,'2023-03-10 14:10:26'),(283,'4','283','13','308','cash','6.1',4,2208.00,955,'2023-03-10 14:21:54'),(284,'4','283','13','309','cash','6.1',4,2208.00,955,'2023-03-10 14:23:26'),(285,'4','283','13','310','cash','6.1',4,5000.00,955,'2023-03-10 14:26:03'),(286,'4','283','13','311','cash','6.1',4,4416.00,955,'2023-03-10 14:28:46'),(287,'4','283','13','312','cash','6.1',4,9200.00,955,'2023-03-10 14:47:12'),(288,'4','283','13','313','cash','6.1',4,9200.00,955,'2023-03-10 14:48:57'),(289,'4','283','13','315','cash','6.1',4,11408.00,955,'2023-03-10 14:55:04'),(290,'4','283','13','316','cash','6.1',4,2944.00,955,'2023-03-10 15:06:26'),(291,'4','283','13','318','cash','6.1',4,9200.00,955,'2023-03-10 15:08:01'),(292,'4','283','13','321','cash','6.1',4,2000.00,955,'2023-03-10 15:09:45'),(293,'4','283','13','322','cash','6.1',4,12880.00,955,'2023-03-10 15:47:27'),(294,'4','283','13','324','cash','6.1',4,3680.00,955,'2023-03-10 15:49:18'),(295,'4','283','13','325','cash','6.1',4,4416.00,955,'2023-03-10 15:58:34'),(296,'4','283','13','327','cash','6.1',4,2208.00,955,'2023-03-10 16:15:29'),(297,'4','283','13','329','cash','6.1',4,7360.00,955,'2023-03-10 16:17:30'),(298,'4','283','13','330','cash','6.1',4,2300.00,955,'2023-03-10 16:19:56'),(299,'4','283','13','331','cash','6.1',4,8832.00,955,'2023-03-10 16:22:24'),(300,'4','283','13','332','cash','6.1',4,9200.00,955,'2023-03-10 16:23:25'),(301,'4','283','13','333','cash','6.1',4,3680.00,955,'2023-03-10 16:24:56'),(302,'4','283','13','334','cash','6.1',4,9200.00,955,'2023-03-10 16:34:04'),(303,'4','283','13','335','cash','6.1',4,4416.00,955,'2023-03-10 16:37:57'),(304,'4','283','13','336','cash','6.1',4,3000.00,955,'2023-03-10 16:39:25'),(305,'4','283','13','337','cash','6.1',4,35500.00,955,'2023-03-10 17:35:48'),(306,'4','283','14','339','pos','2',6,4416.00,955,'2023-03-11 09:45:05'),(307,'4','283','14','340','bank','2',6,2208.00,955,'2023-03-11 10:54:02'),(308,'4','283','14','342','pos','2',6,2208.00,955,'2023-03-11 10:57:07'),(309,'4','283','14','344','pos','2',6,5300.00,955,'2023-03-11 11:24:35'),(310,'4','283','14','345','pos','2',6,5888.00,955,'2023-03-11 11:27:25'),(311,'4','283','14','346','pos','2',6,1500.00,955,'2023-03-11 11:32:28'),(312,'4','283','14','347','pos','2',6,9200.00,955,'2023-03-11 11:37:03'),(313,'4','283','14','348','pos','2',6,4000.00,955,'2023-03-11 11:40:37'),(314,'4','283','14','349','pos','2',6,2944.00,955,'2023-03-11 11:45:00'),(315,'4','283','14','350','pos','2',6,4416.00,955,'2023-03-11 11:55:55'),(316,'4','283','14','351','pos','2',6,4416.00,955,'2023-03-11 12:02:02'),(317,'4','283','14','352','pos','2',6,1472.00,955,'2023-03-11 12:20:11'),(318,'4','283','14','353','pos','2',6,9200.00,955,'2023-03-11 12:23:52'),(319,'4','283','14','354','pos','2',6,9200.00,955,'2023-03-11 12:26:51'),(320,'4','283','14','355','pos','2',6,1000.00,955,'2023-03-11 12:28:36'),(321,'4','283','14','356','pos','2',6,2208.00,955,'2023-03-11 12:31:38'),(322,'4','283','14','357','pos','2',6,5000.00,955,'2023-03-11 12:34:46'),(323,'4','283','14','358','pos','2',6,736.00,955,'2023-03-11 12:41:32'),(324,'4','283','14','359','pos','2',6,3000.00,955,'2023-03-11 12:46:12'),(325,'4','283','14','360','pos','2',6,2208.00,955,'2023-03-11 12:52:27'),(326,'4','283','14','361','pos','2',6,9200.00,955,'2023-03-11 12:54:52'),(327,'4','283','14','362','pos','2',6,9568.00,955,'2023-03-11 12:59:35'),(328,'4','283','14','363','pos','2',6,11040.00,955,'2023-03-11 13:02:18'),(329,'4','283','14','364','pos','2',6,35500.00,955,'2023-03-11 13:12:11'),(330,'4','283','14','365','pos','2',6,9200.00,955,'2023-03-11 13:14:16'),(331,'4','283','14','366','pos','2',6,9200.00,955,'2023-03-11 13:17:52'),(332,'4','283','14','367','pos','2',6,9200.00,955,'2023-03-11 13:27:16'),(333,'4','283','14','368','pos','2',6,6624.00,955,'2023-03-11 13:35:26'),(334,'4','283','14','369','pos','2',6,5000.00,955,'2023-03-11 13:44:09'),(335,'4','283','14','370','pos','2',6,1472.00,955,'2023-03-11 13:47:55'),(336,'4','283','14','371','pos','2',6,9200.00,955,'2023-03-11 13:51:23'),(337,'4','283','14','372','pos','2',6,1472.00,955,'2023-03-11 13:57:42'),(338,'4','283','14','373','pos','2',6,2208.00,955,'2023-03-11 14:00:45'),(339,'4','283','14','375','pos','2',6,4416.00,955,'2023-03-11 14:03:30'),(340,'4','283','14','376','pos','2',6,3680.00,955,'2023-03-11 14:05:48'),(341,'4','283','14','377','pos','2',6,8832.00,955,'2023-03-11 14:20:02'),(342,'4','283','14','378','pos','2',6,9200.00,955,'2023-03-11 14:22:13'),(343,'4','283','14','379','pos','2',6,2208.00,955,'2023-03-11 14:24:41'),(344,'4','283','14','380','pos','2',6,9200.00,955,'2023-03-11 14:27:14'),(345,'4','283','14','381','pos','2',6,2130.00,955,'2023-03-11 14:30:42'),(346,'4','283','14','382','pos','2',6,2208.00,955,'2023-03-11 14:32:50'),(347,'4','283','14','383','pos','2',6,2944.00,955,'2023-03-11 14:35:48'),(348,'4','283','14','384','pos','2',6,5152.00,955,'2023-03-11 14:38:21'),(349,'4','283','14','385','pos','2',6,9200.00,955,'2023-03-11 14:42:31'),(350,'4','283','14','386','pos','2',6,9200.00,955,'2023-03-11 14:46:06'),(351,'4','283','14','387','pos','2',6,2000.00,955,'2023-03-11 14:56:53'),(352,'4','283','14','388','pos','2',6,8832.00,955,'2023-03-11 15:00:25'),(353,'4','283','14','389','pos','2',6,7360.00,955,'2023-03-11 15:12:35'),(354,'4','283','14','390','pos','2',6,9200.00,955,'2023-03-11 15:22:35'),(355,'4','283','14','391','pos','2',6,4416.00,955,'2023-03-11 15:33:58'),(356,'4','283','14','392','pos','2',6,4416.00,955,'2023-03-11 15:41:42'),(357,'4','283','14','393','pos','2',6,2944.00,955,'2023-03-11 15:44:15'),(358,'4','283','14','394','pos','2',6,4400.00,955,'2023-03-11 15:48:15'),(359,'4','283','14','395','pos','2',6,4500.00,955,'2023-03-11 15:50:28'),(360,'4','283','14','395','pos','2',6,4500.00,955,'2023-03-11 15:50:38'),(361,'4','283','14','396','pos','2',6,1500.00,955,'2023-03-11 15:52:39'),(362,'4','283','14','397','pos','2',6,3680.00,955,'2023-03-11 15:55:02'),(363,'4','283','14','398','pos','2',6,3680.00,955,'2023-03-11 15:56:45'),(364,'4','283','14','399','pos','2',6,1000.00,955,'2023-03-11 15:59:54'),(365,'4','283','14','400','pos','2',6,8832.00,955,'2023-03-11 16:01:47'),(366,'4','283','14','401','pos','2',6,2208.00,955,'2023-03-11 16:03:53'),(367,'4','283','14','403','pos','2',6,4000.00,955,'2023-03-11 16:09:28'),(368,'4','283','14','404','pos','2',6,4416.00,955,'2023-03-11 16:18:29'),(369,'4','283','14','405','pos','2',6,8096.00,955,'2023-03-11 16:21:16'),(370,'4','283','14','406','pos','2',6,9200.00,955,'2023-03-11 16:23:19'),(371,'4','283','14','407','pos','2',6,5000.00,955,'2023-03-11 16:28:23'),(372,'4','283','14','408','pos','2',6,3000.00,955,'2023-03-11 16:31:46'),(373,'4','283','14','409','pos','2',6,8832.00,955,'2023-03-11 16:35:21'),(374,'4','283','14','410','pos','2',6,9200.00,955,'2023-03-11 16:39:28'),(375,'4','283','14','411','pos','2',6,9200.00,955,'2023-03-11 16:42:17'),(376,'4','283','14','412','pos','2',6,3680.00,955,'2023-03-11 16:46:10'),(377,'4','283','14','413','pos','2',6,5000.00,955,'2023-03-11 16:48:23'),(378,'4','283','14','414','pos','2',6,8832.00,955,'2023-03-11 16:52:19'),(379,'4','283','14','415','pos','2',6,3680.00,955,'2023-03-11 16:54:42'),(380,'4','283','14','416','pos','2',6,4416.00,955,'2023-03-11 17:03:29'),(381,'4','283','14','417','pos','2',6,4416.00,955,'2023-03-11 17:06:31'),(382,'4','283','14','418','pos','2',6,9200.00,955,'2023-03-11 17:10:12'),(383,'4','283','14','419','pos','2',6,1500.00,955,'2023-03-11 17:14:20'),(384,'4','283','14','420','pos','2',6,2208.00,955,'2023-03-11 17:17:12'),(385,'4','283','14','421','pos','2',6,1472.00,955,'2023-03-11 17:20:09'),(386,'4','283','14','422','pos','2',6,9200.00,955,'2023-03-11 17:22:08'),(387,'4','283','14','423','pos','2',6,9200.00,955,'2023-03-11 17:28:47'),(388,'4','283','14','424','pos','2',6,6624.00,955,'2023-03-11 17:30:46'),(389,'4','283','14','425','pos','2',6,2208.00,955,'2023-03-11 17:34:47'),(390,'4','283','14','426','pos','2',6,9200.00,955,'2023-03-11 17:37:41'),(391,'4','283','14','427','pos','2',6,2944.00,955,'2023-03-11 17:40:31'),(392,'4','283','14','428','pos','2',6,2208.00,955,'2023-03-11 17:43:11'),(393,'4','283','14','429','pos','2',6,2208.00,955,'2023-03-11 17:47:57'),(394,'4','283','14','430','pos','2',6,4416.00,955,'2023-03-11 17:51:49'),(395,'4','283','14','431','pos','2',6,4416.00,955,'2023-03-11 17:57:51'),(396,'4','283','15','432','cash','6.1',4,3000.00,955,'2023-03-12 10:35:35'),(397,'4','283','15','433','cash','6.1',4,3000.00,955,'2023-03-12 10:41:22'),(398,'4','283','15','435','cash','6.1',4,3680.00,955,'2023-03-12 10:43:32'),(399,'4','283','15','435','cash','6.1',4,3680.00,955,'2023-03-12 10:43:35'),(400,'4','283','15','436','cash','6.1',4,2208.00,955,'2023-03-12 10:48:33'),(401,'4','283','15','436','cash','6.1',4,2208.00,955,'2023-03-12 10:48:34'),(402,'4','283','15','437','cash','6.1',4,9200.00,955,'2023-03-12 11:05:25'),(403,'4','283','15','438','cash','6.1',4,3680.00,955,'2023-03-12 11:06:48'),(404,'4','283','15','440','cash','6.1',4,4416.00,955,'2023-03-12 11:08:22'),(405,'4','283','15','441','cash','6.1',4,9200.00,955,'2023-03-12 11:10:14'),(406,'4','283','15','442','cash','6.1',4,7500.00,955,'2023-03-12 11:12:57'),(407,'4','283','15','443','cash','6.1',4,8832.00,955,'2023-03-12 11:14:44'),(408,'4','283','15','443','cash','6.1',4,8832.00,955,'2023-03-12 11:14:45'),(409,'4','283','15','444','cash','6.1',4,2208.00,955,'2023-03-12 11:16:12'),(410,'4','283','15','445','cash','6.1',4,9200.00,955,'2023-03-12 11:26:54'),(411,'4','283','15','446','cash','6.1',4,4416.00,955,'2023-03-12 11:31:31'),(412,'4','283','15','446','cash','6.1',4,4416.00,955,'2023-03-12 11:31:33'),(413,'4','283','15','447','cash','6.1',4,1500.00,955,'2023-03-12 11:33:46'),(414,'4','283','15','451','cash','6.1',4,1472.00,955,'2023-03-12 11:38:55'),(415,'4','283','15','452','cash','6.1',4,2208.00,955,'2023-03-12 11:40:22'),(416,'4','283','15','454','cash','6.1',4,9200.00,955,'2023-03-12 11:42:47'),(417,'4','283','15','455','cash','6.1',4,1000.00,955,'2023-03-12 11:45:14'),(418,'4','283','15','455','cash','6.1',4,1000.00,955,'2023-03-12 11:45:16'),(419,'4','283','15','456','cash','6.1',4,2944.00,955,'2023-03-12 11:46:55'),(420,'4','283','15','459','cash','6.1',4,11776.00,955,'2023-03-12 11:52:28'),(421,'4','283','15','461','cash','6.1',4,8000.00,955,'2023-03-12 11:55:36'),(422,'4','283','15','462','cash','6.1',4,9200.00,955,'2023-03-12 12:01:23'),(423,'4','283','15','463','cash','6.1',4,1500.00,955,'2023-03-12 12:04:24'),(424,'4','283','15','463','cash','6.1',4,1500.00,955,'2023-03-12 12:04:25'),(425,'4','283','15','463','cash','6.1',4,1500.00,955,'2023-03-12 12:04:26'),(426,'4','283','15','465','cash','6.1',4,7360.00,955,'2023-03-12 12:06:24'),(427,'4','283','15','466','cash','6.1',4,4416.00,955,'2023-03-12 12:07:50'),(428,'4','283','15','468','cash','6.1',4,3680.00,955,'2023-03-12 12:09:41'),(429,'4','283','15','469','cash','6.1',4,8832.00,955,'2023-03-12 12:11:11'),(430,'4','283','15','471','cash','6.1',4,2208.00,955,'2023-03-12 12:13:12'),(431,'4','283','15','472','cash','6.1',4,4416.00,955,'2023-03-12 12:17:15'),(432,'4','283','15','472','cash','6.1',4,4416.00,955,'2023-03-12 12:17:16'),(433,'4','283','15','474','cash','6.1',4,1400.00,955,'2023-03-12 12:21:17'),(434,'4','283','15','475','cash','6.1',4,12144.00,955,'2023-03-12 12:26:32'),(435,'4','283','15','475','cash','6.1',4,12144.00,955,'2023-03-12 12:26:33'),(436,'4','283','15','476','cash','6.1',4,2200.00,955,'2023-03-12 12:28:10'),(437,'4','283','15','476','cash','6.1',4,2200.00,955,'2023-03-12 12:28:11'),(438,'4','283','15','479','cash','6.1',4,3000.00,955,'2023-03-12 12:31:48'),(439,'4','283','15','479','cash','6.1',4,3000.00,955,'2023-03-12 12:31:49'),(440,'4','283','15','480','cash','6.1',4,4416.00,955,'2023-03-12 12:33:15'),(441,'4','283','15','481','cash','6.1',4,9568.00,955,'2023-03-12 12:36:08'),(442,'4','283','15','481','cash','6.1',4,9568.00,955,'2023-03-12 12:36:09'),(443,'4','283','15','483','cash','6.1',4,4416.00,955,'2023-03-12 12:37:09'),(444,'4','283','15','483','cash','6.1',4,4416.00,955,'2023-03-12 12:37:10'),(445,'4','283','15','484','cash','6.1',4,8832.00,955,'2023-03-12 12:38:41'),(446,'4','283','15','487','cash','6.1',4,4416.00,955,'2023-03-12 12:40:35'),(447,'4','283','15','489','cash','6.1',4,9200.00,955,'2023-03-12 12:47:50'),(448,'4','283','15','490','cash','6.1',4,8832.00,955,'2023-03-12 12:49:47'),(449,'4','283','15','490','cash','6.1',4,8832.00,955,'2023-03-12 12:49:48'),(450,'4','283','15','490','cash','6.1',4,8832.00,955,'2023-03-12 12:49:49'),(451,'4','283','15','491','cash','6.1',4,13616.00,955,'2023-03-12 12:54:13'),(452,'4','283','15','492','cash','6.1',4,9200.00,955,'2023-03-12 12:57:05'),(453,'4','283','15','493','cash','6.1',4,2208.00,955,'2023-03-12 12:59:39'),(454,'4','283','15','495','pos','2',6,2000.00,955,'2023-03-12 13:07:32'),(455,'4','283','15','496','pos','2',6,6624.00,955,'2023-03-12 13:11:25'),(456,'4','283','15','497','pos','2',6,2208.00,955,'2023-03-12 13:14:39'),(457,'4','283','15','499','pos','2',6,6000.00,955,'2023-03-12 13:17:09'),(458,'4','283','15','500','pos','2',6,3680.00,955,'2023-03-12 13:19:42'),(459,'4','283','15','501','pos','2',6,5888.00,955,'2023-03-12 13:22:29'),(460,'4','283','15','504','pos','2',6,4416.00,955,'2023-03-12 13:26:00'),(461,'4','283','15','505','pos','2',6,17750.00,955,'2023-03-12 13:32:44'),(462,'4','283','15','508','pos','2',6,44020.00,955,'2023-03-12 13:45:19'),(463,'4','283','15','509','pos','2',6,1472.00,955,'2023-03-12 14:09:22'),(464,'4','283','15','510','pos','2',6,2208.00,955,'2023-03-12 14:11:33'),(465,'4','283','15','511','pos','2',6,736.00,955,'2023-03-12 14:14:36'),(466,'4','283','15','512','pos','2',6,9200.00,955,'2023-03-12 14:22:22'),(467,'4','283','15','513','pos','2',6,1472.00,955,'2023-03-12 14:26:33'),(468,'4','283','15','514','cash','6.1',4,736.00,955,'2023-03-12 14:29:51'),(469,'4','283','15','515','pos','2',6,4416.00,955,'2023-03-12 14:52:16'),(470,'4','283','15','516','pos','2',6,2000.00,955,'2023-03-12 15:22:49'),(471,'4','283','15','518','cash','6.1',4,7400.00,955,'2023-03-12 15:26:34'),(472,'4','283','15','519','pos','2',6,9200.00,955,'2023-03-12 15:28:59'),(473,'4','283','15','520','pos','2',6,2000.00,955,'2023-03-12 15:30:50'),(474,'4','283','15','523','pos','2',6,4416.00,955,'2023-03-12 15:40:49'),(475,'4','283','15','525','pos','2',6,2208.00,955,'2023-03-12 15:42:37'),(476,'4','283','15','526','pos','2',6,4416.00,955,'2023-03-12 15:44:42'),(477,'4','283','15','527','pos','2',6,1472.00,955,'2023-03-12 15:54:17'),(478,'4','283','15','528','bank','2',6,3680.00,955,'2023-03-12 16:03:20'),(479,'4','283','15','529','pos','2',6,4416.00,955,'2023-03-12 16:05:13'),(480,'4','283','15','531','pos','2',6,9200.00,955,'2023-03-12 16:20:49'),(481,'4','283','15','532','pos','2',6,4416.00,955,'2023-03-12 16:30:11'),(482,'4','283','15','533','pos','2',6,8875.00,955,'2023-03-12 16:33:26'),(483,'4','283','15','534','pos','2',6,4000.00,955,'2023-03-12 16:36:58'),(484,'4','283','15','535','pos','2',6,9200.00,955,'2023-03-12 16:41:01'),(485,'4','283','16','536','cash','6.1',4,40825.00,955,'2023-03-13 08:21:42'),(486,'4','283','16','537','cash','6.1',4,9200.00,955,'2023-03-13 08:23:42'),(487,'4','283','16','538','cash','6.1',4,4000.00,955,'2023-03-13 08:25:14'),(488,'4','283','16','540','cash','6.1',4,3550.00,955,'2023-03-13 08:29:13'),(489,'4','283','16','541','cash','6.1',4,6624.00,955,'2023-03-13 08:32:39'),(490,'4','283','16','542','cash','6.1',4,3680.00,955,'2023-03-13 08:33:59'),(491,'4','283','16','544','cash','6.1',4,5152.00,955,'2023-03-13 08:35:28'),(492,'4','283','16','544','cash','6.1',4,5152.00,955,'2023-03-13 08:35:28'),(493,'4','283','16','545','cash','6.1',4,9200.00,955,'2023-03-13 08:37:10'),(494,'4','283','16','545','cash','6.1',4,9200.00,955,'2023-03-13 08:37:11'),(495,'4','283','16','547','cash','6.1',4,736.00,955,'2023-03-13 08:39:50'),(496,'4','283','16','548','cash','6.1',4,1000.00,955,'2023-03-13 08:41:33'),(497,'4','283','16','549','cash','6.1',4,12880.00,955,'2023-03-13 08:45:13'),(498,'4','283','16','550','cash','6.1',4,2208.00,955,'2023-03-13 08:46:31'),(499,'4','283','16','551','cash','6.1',4,4416.00,955,'2023-03-13 08:48:17'),(500,'4','283','16','552','cash','6.1',4,2208.00,955,'2023-03-13 08:49:46'),(501,'4','283','16','553','cash','6.1',4,8832.00,955,'2023-03-13 08:50:58'),(502,'4','283','16','554','cash','6.1',4,2208.00,955,'2023-03-13 08:52:37'),(503,'4','283','16','555','cash','6.1',4,5888.00,955,'2023-03-13 08:55:02'),(504,'4','283','16','556','cash','6.1',4,3000.00,955,'2023-03-13 08:56:47'),(505,'4','283','16','557','cash','6.1',4,2250.00,955,'2023-03-13 09:01:07'),(506,'4','283','16','558','cash','6.1',4,1300.00,955,'2023-03-13 09:12:25'),(507,'4','283','16','559','cash','6.1',4,18400.00,955,'2023-03-13 09:19:54'),(508,'4','283','16','561','cash','6.1',4,2208.00,955,'2023-03-13 09:25:17'),(509,'4','283','16','562','cash','6.1',4,3680.00,955,'2023-03-13 09:29:59'),(510,'4','283','16','563','cash','6.1',4,1000.00,955,'2023-03-13 09:34:38'),(511,'4','283','16','564','cash','6.1',4,7360.00,955,'2023-03-13 09:37:20'),(512,'4','283','16','565','cash','6.1',4,1000.00,955,'2023-03-13 09:56:14'),(513,'4','283','16','566','cash','6.1',4,5000.00,955,'2023-03-13 09:59:53'),(514,'4','283','16','567','cash','6.1',4,4416.00,955,'2023-03-13 10:16:56'),(515,'4','283','16','569','cash','6.1',4,8832.00,955,'2023-03-13 10:18:40'),(516,'4','283','16','570','cash','6.1',4,368.00,955,'2023-03-13 10:27:23'),(517,'4','283','16','571','cash','6.1',4,9200.00,955,'2023-03-13 10:43:57'),(518,'4','283','16','572','cash','6.1',4,2000.00,955,'2023-03-13 10:48:19'),(519,'4','283','16','573','cash','6.1',4,2500.00,955,'2023-03-13 10:51:09'),(520,'4','283','16','574','cash','6.1',4,9200.00,955,'2023-03-13 11:23:20'),(521,'4','283','16','574','cash','6.1',4,9200.00,955,'2023-03-13 11:23:23'),(522,'4','283','16','575','cash','6.1',4,4416.00,955,'2023-03-13 11:26:26'),(523,'4','283','16','575','cash','6.1',4,4416.00,955,'2023-03-13 11:26:30'),(524,'4','283','16','576','cash','6.1',4,4416.00,955,'2023-03-13 12:16:21'),(525,'4','283','16','577','cash','6.1',4,1500.00,955,'2023-03-13 12:32:32'),(526,'4','283','16','579','cash','6.1',4,4500.00,955,'2023-03-13 12:39:47'),(527,'4','283','16','581','cash','6.1',4,1472.00,955,'2023-03-13 12:41:17'),(528,'4','283','16','583','cash','6.1',4,4416.00,955,'2023-03-13 12:46:15'),(529,'4','283','16','584','cash','6.1',4,1472.00,955,'2023-03-13 12:47:29'),(530,'4','283','16','585','cash','6.1',4,9200.00,955,'2023-03-13 12:50:33'),(531,'4','283','16','586','cash','6.1',4,7100.00,955,'2023-03-13 12:55:32'),(532,'4','283','16','587','cash','6.1',4,9200.00,955,'2023-03-13 13:06:21'),(533,'4','283','16','588','cash','6.1',4,35500.00,955,'2023-03-13 13:20:05'),(534,'4','283','16','589','cash','6.1',4,68870.00,955,'2023-03-13 13:22:10'),(535,'4','283','16','591','cash','6.1',4,2208.00,955,'2023-03-13 13:23:27'),(536,'4','283','16','592','cash','6.1',4,1000.00,955,'2023-03-13 13:36:29'),(537,'4','283','16','594','cash','6.1',4,1500.00,955,'2023-03-13 13:45:29'),(538,'4','283','16','595','cash','6.1',4,9200.00,955,'2023-03-13 13:48:00'),(539,'4','283','16','596','cash','6.1',4,2208.00,955,'2023-03-13 13:48:55'),(540,'4','283','16','597','cash','6.1',4,3000.00,955,'2023-03-13 14:36:57'),(541,'4','283','16','598','cash','6.1',4,2000.00,955,'2023-03-13 14:38:36'),(542,'4','283','16','599','cash','6.1',4,9200.00,955,'2023-03-13 14:41:23'),(543,'4','283','16','600','cash','6.1',4,35500.00,955,'2023-03-13 14:46:16'),(544,'4','283','16','601','cash','6.1',4,3000.00,955,'2023-03-13 14:47:55'),(545,'4','283','16','602','cash','6.1',4,2944.00,955,'2023-03-13 14:50:35'),(546,'4','283','16','603','cash','6.1',4,2208.00,955,'2023-03-13 15:21:42'),(547,'4','283','16','604','cash','6.1',4,2000.00,955,'2023-03-13 15:30:45'),(548,'4','283','16','605','cash','6.1',4,2944.00,955,'2023-03-13 15:34:04'),(549,'4','283','16','606','cash','6.1',4,2944.00,955,'2023-03-13 15:36:40'),(550,'4','283','16','607','cash','6.1',4,4416.00,955,'2023-03-13 15:39:07'),(551,'4','283','16','608','cash','6.1',4,9200.00,955,'2023-03-13 15:40:46'),(552,'4','283','16','609','cash','6.1',4,2000.00,955,'2023-03-13 15:48:26'),(553,'4','283','16','610','cash','6.1',4,2944.00,955,'2023-03-13 15:51:58'),(554,'4','283','16','611','cash','6.1',4,3680.00,955,'2023-03-13 15:55:32'),(555,'4','283','16','612','cash','6.1',4,9200.00,955,'2023-03-13 15:57:41'),(556,'4','283','16','613','cash','6.1',4,1472.00,955,'2023-03-13 15:58:48'),(557,'4','283','16','614','cash','6.1',4,9200.00,955,'2023-03-13 16:00:16'),(558,'4','283','16','615','cash','6.1',4,5000.00,955,'2023-03-13 16:03:19'),(559,'4','283','16','616','cash','6.1',4,9200.00,955,'2023-03-13 16:08:27'),(560,'4','283','16','617','cash','6.1',4,750.00,955,'2023-03-13 16:18:08'),(561,'4','283','16','618','cash','6.1',4,2208.00,955,'2023-03-13 16:19:40'),(562,'4','283','16','619','cash','6.1',4,5888.00,955,'2023-03-13 16:35:33'),(563,'4','283','16','620','cash','6.1',4,2208.00,955,'2023-03-13 16:37:24'),(564,'4','283','16','621','cash','6.1',4,3680.00,955,'2023-03-13 16:41:33'),(565,'4','283','16','622','cash','6.1',4,9200.00,955,'2023-03-13 16:46:21'),(566,'4','283','16','623','cash','6.1',4,9200.00,955,'2023-03-13 17:00:56'),(567,'4','283','16','624','cash','6.1',4,33370.00,955,'2023-03-13 17:32:23'),(568,'4','283','16','625','cash','6.1',4,8875.00,955,'2023-03-13 17:35:46'),(569,'4','283','16','626','cash','6.1',4,5152.00,955,'2023-03-13 17:38:03'),(570,'4','283','16','629','cash','6.1',4,4416.00,955,'2023-03-13 17:53:45'),(571,'4','283','16','630','cash','6.1',4,3000.00,955,'2023-03-13 17:55:17'),(572,'4','283','16','631','cash','6.1',4,4416.00,955,'2023-03-13 17:56:31'),(573,'4','283','16','632','cash','6.1',4,736.00,955,'2023-03-13 17:57:28'),(574,'4','283','17','634','pos','2',6,145728.00,955,'2023-03-14 11:12:04'),(575,'4','283','17','635','pos','2',6,8832.00,955,'2023-03-14 11:17:27'),(576,'4','283','17','636','pos','2',6,2208.00,955,'2023-03-14 11:20:53'),(577,'4','283','17','637','pos','2',6,52992.00,955,'2023-03-14 12:28:18'),(578,'4','283','17','638','pos','2',6,9200.00,955,'2023-03-14 12:40:01'),(579,'4','283','17','639','pos','2',6,4416.00,955,'2023-03-14 12:44:10'),(580,'4','283','17','640','cash','6.1',4,1000.00,955,'2023-03-14 12:51:43'),(581,'4','283','17','641','pos','2',6,2208.00,955,'2023-03-14 12:58:48'),(582,'4','283','17','642','pos','2',6,2208.00,955,'2023-03-14 13:01:43'),(583,'4','283','17','643','pos','2',6,110400.00,955,'2023-03-14 13:07:01'),(584,'4','283','17','644','pos','2',6,3680.00,955,'2023-03-14 13:15:02'),(585,'4','283','17','645','pos','2',6,2208.00,955,'2023-03-14 13:18:12'),(586,'4','283','17','646','pos','2',6,4416.00,955,'2023-03-14 13:24:14'),(587,'4','283','17','647','pos','2',6,92000.00,955,'2023-03-14 14:31:21'),(588,'4','283','17','648','pos','2',6,9200.00,955,'2023-03-14 16:27:38'),(589,'4','283','17','650','pos','2',6,27600.00,955,'2023-03-14 17:12:36'),(590,'4','283','17','651','pos','2',6,26625.00,955,'2023-03-14 17:15:22'),(591,'4','283','17','652','pos','2',6,4416.00,955,'2023-03-14 17:39:17'),(592,'4','283','18','653','cash','6.1',4,4416.00,955,'2023-03-15 10:51:20'),(593,'4','283','18','654','cash','6.1',4,9200.00,955,'2023-03-15 10:52:39'),(594,'4','283','18','655','cash','6.1',4,4416.00,955,'2023-03-15 10:56:19'),(595,'4','283','18','656','cash','6.1',4,4416.00,955,'2023-03-15 10:57:37'),(596,'4','283','18','658','cash','6.1',4,18400.00,955,'2023-03-15 11:03:32'),(597,'4','283','18','659','cash','6.1',4,9200.00,955,'2023-03-15 11:07:46'),(598,'4','283','18','660','cash','6.1',4,35500.00,955,'2023-03-15 11:11:10'),(599,'4','283','18','661','cash','6.1',4,5152.00,955,'2023-03-15 11:12:31'),(600,'4','283','18','663','cash','6.1',4,35500.00,955,'2023-03-15 11:20:13'),(601,'4','283','18','664','cash','6.1',4,8464.00,955,'2023-03-15 11:33:20'),(602,'4','283','18','665','cash','6.1',4,4416.00,955,'2023-03-15 11:34:58'),(603,'4','283','18','666','cash','6.1',4,2208.00,955,'2023-03-15 11:37:42'),(604,'4','283','18','667','cash','6.1',4,8096.00,955,'2023-03-15 11:42:00'),(605,'4','283','18','668','cash','6.1',4,3000.00,955,'2023-03-15 11:46:04'),(606,'4','283','18','669','cash','6.1',4,3680.00,955,'2023-03-15 11:48:18'),(607,'4','283','18','670','cash','6.1',4,1472.00,955,'2023-03-15 12:05:39'),(608,'4','283','18','671','cash','6.1',4,4416.00,955,'2023-03-15 12:10:25'),(609,'4','283','18','672','cash','6.1',4,9200.00,955,'2023-03-15 12:12:49'),(610,'4','283','18','673','cash','6.1',4,3680.00,955,'2023-03-15 12:21:19'),(611,'4','283','18','674','cash','6.1',4,44375.00,955,'2023-03-15 12:29:12'),(612,'4','283','18','675','cash','6.1',4,1472.00,955,'2023-03-15 12:31:13'),(613,'4','283','18','676','cash','6.1',4,3680.00,955,'2023-03-15 12:33:16'),(614,'4','283','18','677','cash','6.1',4,2208.00,955,'2023-03-15 12:34:36'),(615,'4','283','18','678','cash','6.1',4,3500.00,955,'2023-03-15 12:44:12'),(616,'4','283','18','679','cash','6.1',4,4500.00,955,'2023-03-15 12:45:19'),(617,'4','283','18','680','cash','6.1',4,2208.00,955,'2023-03-15 12:46:53'),(618,'4','283','18','681','cash','6.1',4,2208.00,955,'2023-03-15 12:50:37'),(619,'4','283','18','682','cash','6.1',4,8875.00,955,'2023-03-15 12:52:55'),(620,'4','283','18','683','cash','6.1',4,1472.00,955,'2023-03-15 12:55:00'),(621,'4','283','18','684','cash','6.1',4,3000.00,955,'2023-03-15 12:56:44'),(622,'4','283','18','685','cash','6.1',4,4416.00,955,'2023-03-15 16:44:30'),(623,'4','283','18','685','cash','6.1',4,4416.00,955,'2023-03-15 16:44:30'),(624,'4','283','18','686','cash','6.1',4,2208.00,955,'2023-03-15 16:46:32'),(625,'4','283','18','687','cash','6.1',4,6000.00,955,'2023-03-15 16:49:12'),(626,'4','283','18','688','cash','6.1',4,2944.00,955,'2023-03-15 16:50:36'),(627,'4','283','18','689','cash','6.1',4,2208.00,955,'2023-03-15 16:57:46'),(628,'4','283','18','690','cash','6.1',4,2000.00,955,'2023-03-15 17:03:14'),(629,'4','283','18','692','cash','6.1',4,2944.00,955,'2023-03-15 17:20:14'),(630,'4','283','18','694','cash','6.1',4,8875.00,955,'2023-03-15 17:25:25'),(631,'4','283','18','695','cash','6.1',4,4416.00,955,'2023-03-15 17:29:38'),(632,'4','283','18','696','cash','6.1',4,2208.00,955,'2023-03-15 17:32:28'),(633,'4','283','18','697','cash','6.1',4,2000.00,955,'2023-03-15 17:43:42'),(634,'4','283','18','698','cash','6.1',4,2208.00,955,'2023-03-15 17:50:13'),(635,'4','283','18','699','cash','6.1',4,2208.00,955,'2023-03-15 17:54:18'),(636,'4','283','18','699','cash','6.1',4,2208.00,955,'2023-03-15 17:54:18'),(637,'4','283','18','700','cash','6.1',4,1000.00,955,'2023-03-15 17:56:52'),(638,'4','283','18','701','cash','6.1',4,2208.00,955,'2023-03-15 17:57:53'),(639,'4','283','18','702','cash','6.1',4,1472.00,955,'2023-03-15 17:59:01'),(640,'4','283','18','703','cash','6.1',4,35500.00,955,'2023-03-15 18:01:34'),(641,'4','283','18','704','cash','6.1',4,104370.00,955,'2023-03-15 18:03:02'),(642,'4','283','18','705','cash','6.1',4,9200.00,955,'2023-03-15 18:04:33'),(643,'4','283','18','706','cash','6.1',4,2208.00,955,'2023-03-15 18:06:13'),(644,'4','283','18','707','cash','6.1',4,5000.00,955,'2023-03-15 18:08:32'),(645,'4','283','18','708','cash','6.1',4,1472.00,955,'2023-03-15 18:14:01'),(646,'4','283','18','709','cash','6.1',4,3600.00,955,'2023-03-15 18:15:36'),(647,'4','283','18','711','cash','6.1',4,9200.00,955,'2023-03-15 18:16:54'),(648,'4','283','19','712','bank','2',6,355000.00,955,'2023-03-16 11:50:57'),(649,'4','283','19','713','pos','2',6,57408.00,955,'2023-03-16 12:16:36'),(650,'4','283','19','714','pos','2',6,4416.00,955,'2023-03-16 12:19:42'),(651,'4','283','19','715','pos','2',6,1625088.00,955,'2023-03-16 12:22:11'),(652,'4','283','19','716','pos','2',6,2944.00,955,'2023-03-16 12:26:20'),(653,'4','283','19','717','pos','2',6,7360.00,955,'2023-03-16 12:34:30'),(654,'4','283','19','718','pos','2',6,3680.00,955,'2023-03-16 12:40:26'),(655,'4','283','19','719','pos','2',6,4416.00,955,'2023-03-16 12:42:38'),(656,'4','283','19','720','pos','2',6,3700.00,955,'2023-03-16 12:48:30'),(657,'4','283','19','722','pos','2',6,71000.00,955,'2023-03-16 12:58:02'),(658,'4','283','19','723','pos','2',6,1500.00,955,'2023-03-16 13:04:30'),(659,'4','283','19','724','pos','2',6,2208.00,955,'2023-03-16 13:13:44'),(660,'4','283','19','725','pos','2',6,1500.00,955,'2023-03-16 13:18:08'),(661,'4','283','19','726','pos','2',6,5888.00,955,'2023-03-16 13:20:50'),(662,'4','283','19','728','pos','2',6,4416.00,955,'2023-03-16 13:23:53'),(663,'4','283','19','729','pos','2',6,1472.00,955,'2023-03-16 13:25:09'),(664,'4','283','19','730','pos','2',6,9200.00,955,'2023-03-16 13:46:21'),(665,'4','283','19','731','cash','6.1',4,800.00,955,'2023-03-16 13:56:55'),(666,'4','283','19','732','pos','2',6,7360.00,955,'2023-03-16 13:59:11'),(667,'4','283','19','733','pos','2',6,9200.00,955,'2023-03-16 14:04:29'),(668,'4','283','19','734','pos','2',6,5000.00,955,'2023-03-16 14:09:46'),(669,'4','283','19','735','pos','2',6,9200.00,955,'2023-03-16 14:13:27'),(670,'4','283','19','736','pos','2',6,2208.00,955,'2023-03-16 14:19:28'),(671,'4','283','19','737','pos','2',6,4416.00,955,'2023-03-16 14:23:19'),(672,'4','283','19','738','pos','2',6,9200.00,955,'2023-03-16 14:32:29'),(673,'4','283','19','739','pos','2',6,8875.00,955,'2023-03-16 15:09:29'),(674,'4','283','19','740','pos','2',6,7360.00,955,'2023-03-16 16:47:20'),(675,'4','283','19','741','pos','2',6,4416.00,955,'2023-03-16 16:49:01'),(676,'4','283','20','742','cash','6.1',4,2500.00,955,'2023-03-17 10:52:24'),(677,'4','283','20','743','cash','6.1',4,9200.00,955,'2023-03-17 10:54:25'),(678,'4','283','20','744','cash','6.1',4,9200.00,955,'2023-03-17 10:57:48'),(679,'4','283','20','745','cash','6.1',4,1472.00,955,'2023-03-17 11:29:52'),(680,'4','283','20','746','cash','6.1',4,2208.00,955,'2023-03-17 11:32:43'),(681,'4','283','20','747','cash','6.1',4,2208.00,955,'2023-03-17 11:36:34'),(682,'4','283','20','748','cash','6.1',4,1000.00,955,'2023-03-17 11:38:00'),(683,'4','283','20','749','cash','6.1',4,5152.00,955,'2023-03-17 11:39:23'),(684,'4','283','20','750','cash','6.1',4,9200.00,955,'2023-03-17 11:41:37'),(685,'4','283','20','752','cash','6.1',4,3680.00,955,'2023-03-17 11:43:32'),(686,'4','283','20','753','cash','6.1',4,4416.00,955,'2023-03-17 11:44:31'),(687,'4','283','20','754','cash','6.1',4,9200.00,955,'2023-03-17 11:46:10'),(688,'4','283','20','755','cash','6.1',4,4416.00,955,'2023-03-17 11:50:04'),(689,'4','283','20','755','cash','6.1',4,4416.00,955,'2023-03-17 11:50:05'),(690,'4','283','20','756','cash','6.1',4,9200.00,955,'2023-03-17 11:51:14'),(691,'4','283','20','758','cash','6.1',4,4416.00,955,'2023-03-17 12:00:03'),(692,'4','283','20','759','cash','6.1',4,9200.00,955,'2023-03-17 12:01:22'),(693,'4','283','20','760','cash','6.1',4,7728.00,955,'2023-03-17 12:03:49'),(694,'4','283','20','761','cash','6.1',4,4416.00,955,'2023-03-17 12:05:18'),(695,'4','283','20','762','cash','6.1',4,9200.00,955,'2023-03-17 12:11:09'),(696,'4','283','20','763','cash','6.1',4,9200.00,955,'2023-03-17 12:13:50'),(697,'4','283','20','764','cash','6.1',4,3680.00,955,'2023-03-17 12:18:05'),(698,'4','283','20','765','cash','6.1',4,4416.00,955,'2023-03-17 12:25:50'),(699,'4','283','20','766','cash','6.1',4,9200.00,955,'2023-03-17 12:26:51'),(700,'4','283','20','767','cash','6.1',4,4000.00,955,'2023-03-17 12:28:24'),(701,'4','283','20','768','cash','6.1',4,2944.00,955,'2023-03-17 12:30:41'),(702,'4','283','20','769','cash','6.1',4,9200.00,955,'2023-03-17 12:32:21'),(703,'4','283','20','770','cash','6.1',4,2944.00,955,'2023-03-17 12:42:13'),(704,'4','283','20','771','cash','6.1',4,4416.00,955,'2023-03-17 12:43:19'),(705,'4','283','20','772','cash','6.1',4,2208.00,955,'2023-03-17 12:46:26'),(706,'4','283','20','773','cash','6.1',4,6624.00,955,'2023-03-17 12:47:57'),(707,'4','283','20','774','cash','6.1',4,14200.00,955,'2023-03-17 12:53:29'),(708,'4','283','20','775','cash','6.1',4,33370.00,955,'2023-03-17 12:54:53'),(709,'4','283','20','776','cash','6.1',4,43665.00,955,'2023-03-17 13:00:20'),(710,'4','283','20','777','cash','6.1',4,13248.00,955,'2023-03-17 13:05:51'),(711,'4','283','20','778','cash','6.1',4,9200.00,955,'2023-03-17 13:07:11'),(712,'4','283','20','779','cash','6.1',4,5152.00,955,'2023-03-17 13:16:11'),(713,'4','283','20','780','cash','6.1',4,4416.00,955,'2023-03-17 13:19:50'),(714,'4','283','20','781','cash','6.1',4,1000.00,955,'2023-03-17 14:15:33'),(715,'4','283','20','782','cash','6.1',4,2208.00,955,'2023-03-17 14:17:52'),(716,'4','283','20','783','cash','6.1',4,9200.00,955,'2023-03-17 14:19:23'),(717,'4','283','20','784','cash','6.1',4,2000.00,955,'2023-03-17 14:20:58'),(718,'4','283','20','786','cash','6.1',4,2208.00,955,'2023-03-17 14:25:51'),(719,'4','283','20','787','cash','6.1',4,3000.00,955,'2023-03-17 14:27:24'),(720,'4','283','20','788','cash','6.1',4,4416.00,955,'2023-03-17 14:29:07'),(721,'4','283','20','789','cash','6.1',4,4000.00,955,'2023-03-17 14:37:32'),(722,'4','283','20','790','cash','6.1',4,2944.00,955,'2023-03-17 14:40:58'),(723,'4','283','20','791','cash','6.1',4,2208.00,955,'2023-03-17 14:42:48'),(724,'4','283','20','792','cash','6.1',4,9200.00,955,'2023-03-17 14:47:13'),(725,'4','283','20','793','cash','6.1',4,8096.00,955,'2023-03-17 14:49:02'),(726,'4','283','20','794','cash','6.1',4,40480.00,955,'2023-03-17 14:56:57'),(727,'4','283','20','795','cash','6.1',4,9000.00,955,'2023-03-17 15:07:43'),(728,'4','283','20','796','pos','2',6,71000.00,955,'2023-03-17 15:51:55'),(729,'4','283','20','797','pos','2',6,35500.00,955,'2023-03-17 15:54:04'),(730,'4','283','20','798','pos','2',6,2208.00,955,'2023-03-17 16:52:38'),(731,'4','283','20','799','pos','2',6,9200.00,955,'2023-03-17 16:54:21'),(732,'4','283','20','800','pos','2',6,9200.00,955,'2023-03-17 16:56:17');
/*!40000 ALTER TABLE `retail_sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales`
--

DROP TABLE IF EXISTS `sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `is_credit` int NOT NULL DEFAULT '0',
  `saledate` date NOT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `paid` int NOT NULL,
  `details` text NOT NULL,
  `ledger_notes` varchar(150) DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`product_id`,`customer_id`,`rate`,`quantity`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`is_credit`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales`
--

LOCK TABLES `sales` WRITE;
/*!40000 ALTER TABLE `sales` DISABLE KEYS */;
INSERT INTO `sales` VALUES (1,'4','283','2',0,'2023-02-06',1,1,690.00,750.00,10000.00,0.00,0.00,7500000.00,'02061508','2023-02-06 15:10:05',15,0,'BULK SALES OF LPG TO ABUBAKAR AHMAD',NULL,'955','','0000-00-00 00:00:00','955','2023-02-06 15:10:45');
/*!40000 ALTER TABLE `sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_daily`
--

DROP TABLE IF EXISTS `sales_daily`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_daily` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `saledate` date NOT NULL,
  `average` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `target` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`average`,`saledate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_daily`
--

LOCK TABLES `sales_daily` WRITE;
/*!40000 ALTER TABLE `sales_daily` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_daily` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions`
--

DROP TABLE IF EXISTS `sales_distributions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions` (
  `distribution_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `sale_id` int NOT NULL,
  `purchase_id` varchar(20) NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `loadingdate` date NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `destination` varchar(50) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `truckno` varchar(20) NOT NULL,
  `drivername` varchar(50) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`distribution_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`loadingdate`,`quantity`,`destination`,`waybill`,`meterno`,`nozzle_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`tank_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `truckno` (`truckno`),
  KEY `purchase_id_2` (`purchase_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions`
--

LOCK TABLES `sales_distributions` WRITE;
/*!40000 ALTER TABLE `sales_distributions` DISABLE KEYS */;
INSERT INTO `sales_distributions` VALUES (1,'4',1,'',0,'283',1,1,'2023-02-06',10000.00,'ZAWACIKI','1800027727','','1','3','','','BULK SALES',5,'2023-02-06 15:11:55','955','0000-00-00 00:00:00','','2023-02-06 15:12:35','955');
/*!40000 ALTER TABLE `sales_distributions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_delivery`
--

DROP TABLE IF EXISTS `sales_distributions_delivery`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_delivery` (
  `delivery_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `distribution_id` int NOT NULL,
  `sale_id` int NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `quantity` int NOT NULL,
  `truck_id` int NOT NULL,
  `deliveredon` date NOT NULL,
  `details` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`delivery_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`quantity`,`thedate`,`createdby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`truck_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `distribution_id` (`distribution_id`),
  KEY `deliveredon` (`deliveredon`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_delivery`
--

LOCK TABLES `sales_distributions_delivery` WRITE;
/*!40000 ALTER TABLE `sales_distributions_delivery` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_delivery` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_trucks`
--

DROP TABLE IF EXISTS `sales_distributions_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_trucks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sale_id` varchar(20) NOT NULL,
  `distribution_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `bridge_id` varchar(20) NOT NULL,
  `truck_id` varchar(20) NOT NULL,
  `driver_id` varchar(20) NOT NULL,
  `quantity` int NOT NULL,
  `destination` varchar(150) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `companycode` (`company_id`,`distribution_id`,`truck_id`),
  KEY `sale_id` (`sale_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_trucks`
--

LOCK TABLES `sales_distributions_trucks` WRITE;
/*!40000 ALTER TABLE `sales_distributions_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_fueltickets`
--

DROP TABLE IF EXISTS `sales_fueltickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_fueltickets` (
  `ticket_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `ticketdate` date NOT NULL,
  `code` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `allowance` decimal(10,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `truck_number` varchar(20) NOT NULL,
  `truck_capacity` int NOT NULL,
  `truck_provider` varchar(50) NOT NULL,
  `truck_from` varchar(50) NOT NULL,
  `truck_destination` varchar(50) NOT NULL,
  `driver_name` varchar(50) NOT NULL,
  `driver_phone` varchar(50) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`ticket_id`),
  KEY `companycode` (`company_id`,`ticketdate`,`product_id`,`truck_number`,`rate`,`quantity`,`status`),
  KEY `paid` (`truck_provider`),
  KEY `invoice` (`code`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_fueltickets`
--

LOCK TABLES `sales_fueltickets` WRITE;
/*!40000 ALTER TABLE `sales_fueltickets` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_fueltickets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_payments`
--

DROP TABLE IF EXISTS `sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `customer_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`customer_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_payments`
--

LOCK TABLES `sales_payments` WRITE;
/*!40000 ALTER TABLE `sales_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shifts_cashbacks`
--

DROP TABLE IF EXISTS `shifts_cashbacks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shifts_cashbacks` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `shift_id` bigint unsigned NOT NULL,
  `regno` varchar(100) DEFAULT NULL,
  `cashdate` date NOT NULL,
  `driver` varchar(100) DEFAULT NULL,
  `customer_id` bigint unsigned NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_at` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`cashdate`,`driver`,`customer_id`,`status`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`regno`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shifts_cashbacks`
--

LOCK TABLES `shifts_cashbacks` WRITE;
/*!40000 ALTER TABLE `shifts_cashbacks` DISABLE KEYS */;
/*!40000 ALTER TABLE `shifts_cashbacks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shifts_remittance`
--

DROP TABLE IF EXISTS `shifts_remittance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shifts_remittance` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `shift_id` bigint unsigned NOT NULL,
  `paymentdate` date NOT NULL,
  `method` int DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paidby` varchar(50) DEFAULT NULL,
  `paidto` varchar(100) DEFAULT NULL,
  `bank` bigint unsigned DEFAULT NULL,
  `depositor` varchar(100) DEFAULT NULL,
  `teller` varchar(100) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text,
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  `reversed_at` datetime DEFAULT NULL,
  `reversed_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`paymentdate`,`method`,`bank`,`status`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shifts_remittance`
--

LOCK TABLES `shifts_remittance` WRITE;
/*!40000 ALTER TABLE `shifts_remittance` DISABLE KEYS */;
/*!40000 ALTER TABLE `shifts_remittance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers`
--

DROP TABLE IF EXISTS `suppliers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers` (
  `supplier_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`supplier_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers`
--

LOCK TABLES `suppliers` WRITE;
/*!40000 ALTER TABLE `suppliers` DISABLE KEYS */;
INSERT INTO `suppliers` VALUES (1,'4','283','ALIKO OIL NIGERIA LTD.','JUNAIDU ISAH','08065663347','info@','KANO','KANO','Aliko LPG Plant Panisau Kano.','Nigeria',0.00,0.00,'0000-00-00','2022-09-12 19:16:36',5,'954','2022-09-12 19:16:36','954');
/*!40000 ALTER TABLE `suppliers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers_status`
--

DROP TABLE IF EXISTS `suppliers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `supplier_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers_status`
--

LOCK TABLES `suppliers_status` WRITE;
/*!40000 ALTER TABLE `suppliers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `suppliers_status` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2023-03-21  2:56:20
