-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_4_station_110
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_4_station_110`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_4_station_110` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_4_station_110`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=2398 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (2386,8000,'',0,'24','4','110','SALARIES & WAGES','','2020-03-26 10:14:01',5,0.00,0.00,'','456','2020-03-26 10:14:01','456',0,1),(2387,7000,'',0,'20','4','110','SALES','','2020-03-26 10:14:29',5,0.00,0.00,'','456','2020-03-26 10:14:29','456',0,1),(2388,500,'',0,'6.1','4','110','CASH','','2020-03-26 10:16:12',5,0.00,0.00,'','456','2020-03-26 10:16:12','456',0,1),(2389,4000,'',0,'22','4','110','COST OF SALE','','2020-03-26 10:24:11',5,0.00,0.00,'','456','2020-03-26 10:24:11','456',0,1),(2390,8001,'',0,'24','4','110','PURCHASES','','2020-03-26 10:27:32',5,0.00,0.00,'','456','2020-03-26 10:27:32','456',0,1),(2393,2500,'',0,'2','4','110','ZENITH 1015092983','','2020-03-27 16:27:42',5,0.00,0.00,'','456','2020-03-27 16:27:42','456',0,1),(2394,2501,'',0,'2','4','110','ZENITH 1015093753','','2020-03-27 16:28:32',5,0.00,0.00,'','456','2020-03-27 16:28:32','456',0,1),(2395,2502,'',0,'2','4','110','ZENITH 1016623546','','2020-03-27 16:29:13',5,0.00,0.00,'','456','2020-03-27 16:29:13','456',0,1),(2396,2503,'',0,'2','4','110','ZENITH 1016623560','','2020-03-27 16:30:00',5,0.00,0.00,'','456','2020-03-27 16:30:00','456',0,1),(2397,2504,'',0,'2','4','110','ZENITH 1016623625','','2020-03-27 16:30:49',5,0.00,0.00,'','456','2020-03-27 16:30:49','456',0,1);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=1544 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1542,'','4','110','KALWA INDUSTRIES','HAFIZ NURA','0803276940','alikooiil@gmil.com','KANO','KANO','SHARADA','Nigeria',1000000.00,0.00,0.00,'0000-00-00','2020-04-01 09:48:29',5,'456','2020-04-01 09:48:29','456'),(1543,'','4','110','KEDCO PLC','MUNNIRAT','08035600736','kedco@gmail.com','KANO','KANO','KANO','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-14 08:54:39',5,'954','2023-02-14 08:54:39','954');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2111 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('4','110','710',1935,'5','PMS PUMP 2A',3572297.13,'PMS PUMP','',NULL,NULL,'',5,'2023-02-14 10:18:16','954'),('4','110','710',1936,'5','PMS PUMP 3A',1035977.90,'PMS PUMP','',NULL,NULL,'',5,'2023-02-14 10:20:04','954'),('4','110','710',1937,'5','PMS PUMP 9A',1982907.30,'PMS PUMP','',NULL,NULL,'',5,'2023-02-14 10:31:02','954'),('4','110','711',1938,'5','PMS PUMP 1A',899348.86,'PMS PUMP','',NULL,NULL,'',5,'2023-02-14 10:14:27','954'),('4','110','711',1939,'5','PMS PUMP 7A',2915476.23,'PMS PUMP','',NULL,NULL,'',5,'2023-02-14 10:27:18','954'),('4','110','711',1940,'5','PMS PUMP 8A',1952458.46,'PMS PUMP','',NULL,NULL,'',5,'2023-02-14 10:29:05','954'),('4','110','712',1941,'5','PMS PUMP 11A',1331469.73,'PMS PUMP','',NULL,NULL,'',5,'2023-02-14 10:34:18','954'),('4','110','712',1942,'5','PMS PUMP 12A',717421.41,'PMS PUMP','',NULL,NULL,'',5,'2023-02-14 10:36:17','954'),('4','110','712',1943,'5','PMS PUMP 6A',1794857.12,'PMS PUMP','',NULL,NULL,'',5,'2023-02-14 10:25:38','954'),('4','110','713',1944,'5','PMS PUMP 4A',133458.67,'TANKS CONTAINING PETROLEUM.','',NULL,NULL,'',5,'2023-02-14 10:21:47','954'),('4','110','713',1945,'5','PMS PUMP 5A',2396656.74,'PMS PUMP','',NULL,NULL,'',5,'2023-02-14 10:23:29','954'),('4','110','713',1946,'5','PMS PUMP 10A',1069405.67,'PMS PUMP','',NULL,NULL,'',5,'2023-02-14 10:32:29','954'),('4','110','714',1947,'5','AGO PUMP A',1766872.03,'AGO PUMP','',NULL,NULL,'',5,'2023-02-14 10:39:28','954'),('4','110','715',1948,'5','DPK PUMP',0.00,'DPK PUMP',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('4','110','710',2098,'5','PMS PUMP 2B',3722090.76,'','',NULL,NULL,'',5,'2023-02-14 10:19:06','954'),('4','110','710',2099,'5','PMS PUMP 9B',2795879.56,'','',NULL,NULL,'',5,'2023-02-14 10:31:46','954'),('4','110','710',2100,'5','PMS PUMP 3B',1954411.34,'','',NULL,NULL,'',5,'2023-02-14 10:21:01','954'),('4','110','711',2101,'5','PMS PUMP 1B',1466312.33,'','',NULL,NULL,'',5,'2023-02-14 10:16:54','954'),('4','110','711',2102,'5','PMS PUMP 7B',3733502.48,'','',NULL,NULL,'',5,'2023-02-14 10:28:13','954'),('4','110','711',2103,'5','PMS PUMP 8B',2465657.35,'','',NULL,NULL,'',5,'2023-02-14 10:30:17','954'),('4','110','712',2104,'5','PMS PUMP 11B',1331469.73,'','',NULL,NULL,'',5,'2023-02-14 10:35:36','954'),('4','110','712',2105,'5','PMS PUMP 12B',248648.67,'','',NULL,NULL,'',5,'2023-02-14 10:36:59','954'),('4','110','712',2106,'5','PMS PUMP 6B',2559302.92,'','',NULL,NULL,'',5,'2023-02-14 10:26:29','954'),('4','110','713',2107,'5','PMS PUMP 10B',1272998.13,'','',NULL,NULL,'',5,'2023-02-14 10:33:20','954'),('4','110','713',2108,'5','PMS PUMP 4B',439793.38,'','',NULL,NULL,'',5,'2023-02-14 10:22:41','954'),('4','110','713',2109,'5','PMS PUMP 5B',2587058.30,'','',NULL,NULL,'',5,'2023-02-14 10:24:36','954'),('4','110','714',2110,'5','AGO PUMP B',4217793.32,'','',NULL,NULL,'',5,'2023-02-14 10:40:22','954');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=131668 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('4','110',131060,'MORNING SHIFT','2020-03-24','2020-03-24 00:00:00',NULL,'456',2651768.50,2651768.50,'456','2020-04-02 08:49:06','456','2020-04-02 08:56:22',10,0),('4','110',131332,'AFTERNOON SHIFT','2020-03-24','2020-03-24 00:00:00',NULL,'456',4394045.60,4394045.60,'456','2020-04-04 10:41:16','456','2020-04-04 10:46:37',10,0),('4','110',131656,'AFTERNOON SHIFT','2020-04-07','2020-04-07 00:00:00',NULL,'456',21000.00,21000.00,'456','2020-04-07 09:34:58','456','2020-04-07 09:36:01',10,0),('4','110',131662,'PRICE CHANGE SHIFT','2020-04-07','2020-04-07 00:00:00',NULL,'456',1512000.00,1512000.00,'456','2020-04-07 09:56:37','456','2020-04-07 09:57:04',10,0),('4','110',131663,'PRICE CHANGE SHIFT','2020-04-07','2020-04-07 00:00:00',NULL,'456',0.00,0.00,'954','2023-02-14 09:53:19','954','2023-02-14 09:53:42',10,0),('4','110',131664,'DAILY SHIFT','2023-02-14','2023-02-14 10:10:39','2023-02-15 10:10:39','954',0.00,0.00,'954','2023-02-14 10:13:13','954','2023-02-14 10:13:33',10,0),('4','110',131665,'DAILY SHIFT','2023-02-14','2023-02-14 10:41:15','2023-02-15 10:41:15','954',10155230.40,10155230.40,'954','2023-02-14 11:30:48','954','2023-02-15 09:36:03',10,0),('4','110',131666,'DAILY SHIFT','2023-02-15','2023-02-15 09:37:33','2023-02-16 09:37:33','954',5015889.90,5015889.90,'954','2023-02-15 09:47:43','954','2023-02-15 09:49:38',10,0),('4','110',131667,'DAILY SHIFT','2023-02-15','2023-02-15 10:39:24','2023-02-16 10:39:24','954',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=2626494 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('4','110','710','131060',2613680,'1935','294',1496997.13,1497712.49,715.36,89420.00,0.00,0.00,0.00,0.00,0.00),('4','110','710','131060',2613681,'2098','294',1189738.69,1190832.17,1093.48,136685.00,0.00,0.00,0.00,0.00,0.00),('4','110','710','131060',2613682,'1936','294',1015092.22,1015828.95,736.73,92091.25,0.00,0.00,0.00,0.00,0.00),('4','110','710','131060',2613683,'2100','294',1294844.52,1295780.70,936.18,117022.50,0.00,0.00,0.00,0.00,0.00),('4','110','710','131060',2613684,'1937','294',1310909.21,1310933.74,24.53,3066.25,0.00,0.00,0.00,0.00,0.00),('4','110','710','131060',2613685,'2099','294',1196059.88,1196525.45,465.57,58196.25,0.00,0.00,0.00,0.00,0.00),('4','110','711','131060',2613686,'1938','294',1178111.77,1178607.11,495.34,61917.50,0.00,0.00,0.00,0.00,0.00),('4','110','711','131060',2613687,'2101','294',1075191.68,1076410.25,1218.57,152321.25,0.00,0.00,0.00,0.00,0.00),('4','110','711','131060',2613688,'1939','294',1000931.42,1001646.29,714.87,89358.75,0.00,0.00,0.00,0.00,0.00),('4','110','711','131060',2613689,'2102','294',1135711.19,1136393.26,682.07,85258.75,0.00,0.00,0.00,0.00,0.00),('4','110','711','131060',2613690,'1940','294',1180508.45,1181159.59,651.14,81392.50,0.00,0.00,0.00,0.00,0.00),('4','110','711','131060',2613691,'2103','294',1228411.82,1229037.15,625.33,78166.25,0.00,0.00,0.00,0.00,0.00),('4','110','712','131060',2613692,'1941','294',1536110.38,1537251.83,1141.45,142681.25,0.00,0.00,0.00,0.00,0.00),('4','110','712','131060',2613693,'2104','294',1351952.89,1352646.69,693.80,86725.00,0.00,0.00,0.00,0.00,0.00),('4','110','712','131060',2613694,'1942','294',1848185.80,1849570.97,1385.17,173146.25,0.00,0.00,0.00,0.00,0.00),('4','110','712','131060',2613695,'2105','294',1554828.07,1555638.48,810.41,101301.25,0.00,0.00,0.00,0.00,0.00),('4','110','712','131060',2613696,'1943','294',1073506.25,1074879.79,1373.54,171692.50,0.00,0.00,0.00,0.00,0.00),('4','110','712','131060',2613697,'2106','294',1240088.36,1241039.53,951.17,118896.25,0.00,0.00,0.00,0.00,0.00),('4','110','713','131060',2613698,'1946','294',1362887.03,1363874.78,987.75,123468.75,0.00,0.00,0.00,0.00,0.00),('4','110','713','131060',2613699,'2107','294',1292882.73,1293817.94,935.21,116901.25,0.00,0.00,0.00,0.00,0.00),('4','110','713','131060',2613700,'1944','294',1114741.98,1114741.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','713','131060',2613701,'2108','294',1136954.02,1137729.36,775.34,96917.50,0.00,0.00,0.00,0.00,0.00),('4','110','713','131060',2613702,'1945','294',1093267.85,1093894.77,626.92,78365.00,0.00,0.00,0.00,0.00,0.00),('4','110','713','131060',2613703,'2109','294',1096223.19,1096773.50,550.31,68788.75,0.00,0.00,0.00,0.00,0.00),('4','110','714','131060',2613704,'1947','295',623887.34,623887.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','714','131060',2613705,'2110','295',1796453.48,1798015.33,1561.85,327988.50,0.00,0.00,0.00,0.00,0.00),('4','110','715','131060',2613706,'1948','296',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','710','131332',2619562,'1935','294',1497712.49,1499868.85,2156.36,269545.00,0.00,0.00,0.00,0.00,0.00),('4','110','710','131332',2619563,'2098','294',1190832.17,1192295.94,1463.77,182971.25,0.00,0.00,0.00,0.00,0.00),('4','110','710','131332',2619564,'1936','294',1015828.95,1018172.05,2343.10,292887.50,0.00,0.00,0.00,0.00,0.00),('4','110','710','131332',2619565,'2100','294',1295780.70,1297214.15,1433.45,179181.25,0.00,0.00,0.00,0.00,0.00),('4','110','710','131332',2619566,'1937','294',1310933.74,1313546.38,2612.64,326580.00,0.00,0.00,0.00,0.00,0.00),('4','110','710','131332',2619567,'2099','294',1196525.45,1198272.91,1747.46,218432.50,0.00,0.00,0.00,0.00,0.00),('4','110','711','131332',2619568,'1938','294',1178607.11,1180504.86,1897.75,237218.75,0.00,0.00,0.00,0.00,0.00),('4','110','711','131332',2619569,'2101','294',1076410.25,1077760.76,1350.51,168813.75,0.00,0.00,0.00,0.00,0.00),('4','110','711','131332',2619570,'1939','294',1001646.29,1002747.42,1101.13,137641.25,0.00,0.00,0.00,0.00,0.00),('4','110','711','131332',2619571,'2102','294',1136393.26,1137476.45,1083.19,135398.75,0.00,0.00,0.00,0.00,0.00),('4','110','711','131332',2619572,'1940','294',1181159.59,1183060.60,1901.01,237626.25,0.00,0.00,0.00,0.00,0.00),('4','110','711','131332',2619573,'2103','294',1229037.15,1230912.59,1875.44,234430.00,0.00,0.00,0.00,0.00,0.00),('4','110','712','131332',2619574,'1941','294',1537251.83,1537538.28,286.45,35806.25,0.00,0.00,0.00,0.00,0.00),('4','110','712','131332',2619575,'2104','294',1352646.69,1352846.07,199.38,24922.50,0.00,0.00,0.00,0.00,0.00),('4','110','712','131332',2619576,'1942','294',1849570.97,1849794.20,223.23,27903.75,0.00,0.00,0.00,0.00,0.00),('4','110','712','131332',2619577,'2105','294',1555638.48,1555879.83,241.35,30168.75,0.00,0.00,0.00,0.00,0.00),('4','110','712','131332',2619578,'1943','294',1074879.79,1074928.52,48.73,6091.25,0.00,0.00,0.00,0.00,0.00),('4','110','712','131332',2619579,'2106','294',1241039.53,1241081.46,41.93,5241.25,0.00,0.00,0.00,0.00,0.00),('4','110','713','131332',2619580,'1946','294',1363874.78,1365664.85,1790.07,223758.75,0.00,0.00,0.00,0.00,0.00),('4','110','713','131332',2619581,'2107','294',1293817.94,1295294.32,1476.38,184547.50,0.00,0.00,0.00,0.00,0.00),('4','110','713','131332',2619582,'1944','294',1114741.98,1114751.22,9.24,1155.00,0.00,0.00,0.00,0.00,0.00),('4','110','713','131332',2619583,'2108','294',1137729.36,1139236.80,1507.44,188430.00,0.00,0.00,0.00,0.00,0.00),('4','110','713','131332',2619584,'1945','294',1093894.77,1095328.56,1433.79,179223.75,0.00,0.00,0.00,0.00,0.00),('4','110','713','131332',2619585,'2109','294',1096773.50,1097985.68,1212.18,151522.50,0.00,0.00,0.00,0.00,0.00),('4','110','714','131332',2619586,'1947','295',623887.34,624857.84,970.50,203805.00,0.00,0.00,0.00,0.00,0.00),('4','110','714','131332',2619587,'2110','295',1798015.33,1800447.44,2432.11,510743.10,0.00,0.00,0.00,0.00,0.00),('4','110','715','131332',2619588,'1948','296',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','710','131656',2626219,'1935','294',1499868.85,1499868.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','710','131656',2626220,'2098','294',1192295.94,1192295.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','710','131656',2626221,'1936','294',1018172.05,1018172.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','710','131656',2626222,'2100','294',1297214.15,1297214.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','710','131656',2626223,'1937','294',1313546.38,1313546.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','710','131656',2626224,'2099','294',1198272.91,1198272.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','711','131656',2626225,'1938','294',1180504.86,1180504.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','711','131656',2626226,'2101','294',1077760.76,1077760.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','711','131656',2626227,'1939','294',1002747.42,1002747.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','711','131656',2626228,'2102','294',1137476.45,1137476.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','711','131656',2626229,'1940','294',1183060.60,1183060.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','711','131656',2626230,'2103','294',1230912.59,1230912.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','712','131656',2626231,'1941','294',1537538.28,1537538.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','712','131656',2626232,'2104','294',1352846.07,1352846.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','712','131656',2626233,'1942','294',1849794.20,1849794.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','712','131656',2626234,'2105','294',1555879.83,1555879.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','712','131656',2626235,'1943','294',1074928.52,1074928.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','712','131656',2626236,'2106','294',1241081.46,1241081.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','713','131656',2626237,'1946','294',1365664.85,1365664.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','713','131656',2626238,'2107','294',1295294.32,1295294.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','713','131656',2626239,'1944','294',1114751.22,1114751.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','713','131656',2626240,'2108','294',1139236.80,1139236.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','713','131656',2626241,'1945','294',1095328.56,1095328.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','713','131656',2626242,'2109','294',1097985.68,1097985.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','714','131656',2626243,'1947','295',624857.84,624857.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','714','131656',2626244,'2110','295',1800447.44,1800547.44,100.00,21000.00,0.00,0.00,0.00,0.00,0.00),('4','110','715','131656',2626245,'1948','296',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','710','131662',2626332,'1935','294',1499868.85,1499868.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','710','131662',2626333,'2098','294',1192295.94,1192295.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','710','131662',2626334,'1936','294',1018172.05,1018172.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','710','131662',2626335,'2100','294',1297214.15,1297214.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','710','131662',2626336,'1937','294',1313546.38,1313546.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','710','131662',2626337,'2099','294',1198272.91,1198272.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','711','131662',2626338,'1938','294',1180504.86,1180504.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','711','131662',2626339,'2101','294',1077760.76,1077760.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','711','131662',2626340,'1939','294',1002747.42,1002747.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','711','131662',2626341,'2102','294',1137476.45,1137476.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','711','131662',2626342,'1940','294',1183060.60,1183060.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','711','131662',2626343,'2103','294',1230912.59,1230912.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','712','131662',2626344,'1941','294',1537538.28,1537538.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','712','131662',2626345,'2104','294',1352846.07,1352846.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','712','131662',2626346,'1942','294',1849794.20,1849794.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','712','131662',2626347,'2105','294',1555879.83,1555879.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','712','131662',2626348,'1943','294',1074928.52,1074928.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','712','131662',2626349,'2106','294',1241081.46,1241081.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','713','131662',2626350,'1946','294',1365664.85,1365664.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','713','131662',2626351,'2107','294',1295294.32,1295294.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','713','131662',2626352,'1944','294',1114751.22,1114751.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','713','131662',2626353,'2108','294',1139236.80,1139236.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','713','131662',2626354,'1945','294',1095328.56,1095328.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','713','131662',2626355,'2109','294',1097985.68,1097985.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','714','131662',2626356,'1947','295',624857.84,624857.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','714','131662',2626357,'2110','295',1800547.44,1807747.44,7200.00,1512000.00,0.00,0.00,0.00,0.00,0.00),('4','110','715','131662',2626358,'1948','296',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','710','131663',2626359,'1935','294',1499868.85,1499868.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','710','131663',2626360,'2098','294',1192295.94,1192295.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','710','131663',2626361,'1936','294',1018172.05,1018172.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','710','131663',2626362,'2100','294',1297214.15,1297214.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','710','131663',2626363,'1937','294',1313546.38,1313546.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','710','131663',2626364,'2099','294',1198272.91,1198272.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','711','131663',2626365,'1938','294',1180504.86,1180504.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','711','131663',2626366,'2101','294',1077760.76,1077760.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','711','131663',2626367,'1939','294',1002747.42,1002747.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','711','131663',2626368,'2102','294',1137476.45,1137476.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','711','131663',2626369,'1940','294',1183060.60,1183060.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','711','131663',2626370,'2103','294',1230912.59,1230912.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','712','131663',2626371,'1941','294',1537538.28,1537538.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','712','131663',2626372,'2104','294',1352846.07,1352846.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','712','131663',2626373,'1942','294',1849794.20,1849794.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','712','131663',2626374,'2105','294',1555879.83,1555879.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','712','131663',2626375,'1943','294',1074928.52,1074928.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','712','131663',2626376,'2106','294',1241081.46,1241081.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','713','131663',2626377,'1946','294',1365664.85,1365664.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','713','131663',2626378,'2107','294',1295294.32,1295294.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','713','131663',2626379,'1944','294',1114751.22,1114751.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','713','131663',2626380,'2108','294',1139236.80,1139236.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','713','131663',2626381,'1945','294',1095328.56,1095328.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','713','131663',2626382,'2109','294',1097985.68,1097985.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','714','131663',2626383,'1947','295',624857.84,624857.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','714','131663',2626384,'2110','295',1807747.44,1807747.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','715','131663',2626385,'1948','296',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','710','131664',2626386,'1935','294',1499868.85,1499868.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','710','131664',2626387,'1936','294',1018172.05,1018172.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','710','131664',2626388,'1937','294',1313546.38,1313546.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','711','131664',2626389,'1938','294',1180504.86,1180504.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','711','131664',2626390,'1939','294',1002747.42,1002747.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','711','131664',2626391,'1940','294',1183060.60,1183060.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','712','131664',2626392,'1941','294',1537538.28,1537538.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','712','131664',2626393,'1942','294',1849794.20,1849794.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','712','131664',2626394,'1943','294',1074928.52,1074928.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','713','131664',2626395,'1944','294',1114751.22,1114751.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','713','131664',2626396,'1945','294',1095328.56,1095328.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','713','131664',2626397,'1946','294',1365664.85,1365664.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','714','131664',2626398,'1947','295',624857.84,624857.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','715','131664',2626399,'1948','296',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','710','131664',2626400,'2098','294',1192295.94,1192295.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','710','131664',2626401,'2099','294',1198272.91,1198272.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','710','131664',2626402,'2100','294',1297214.15,1297214.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','711','131664',2626403,'2101','294',1077760.76,1077760.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','711','131664',2626404,'2102','294',1137476.45,1137476.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','711','131664',2626405,'2103','294',1230912.59,1230912.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','712','131664',2626406,'2104','294',1352846.07,1352846.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','712','131664',2626407,'2105','294',1555879.83,1555879.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','712','131664',2626408,'2106','294',1241081.46,1241081.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','713','131664',2626409,'2107','294',1295294.32,1295294.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','713','131664',2626410,'2108','294',1139236.80,1139236.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','713','131664',2626411,'2109','294',1097985.68,1097985.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','714','131664',2626412,'2110','295',1807747.44,1807747.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','710','131665',2626413,'1935','294',3566020.76,3569155.31,3134.55,658255.50,0.00,0.00,0.00,0.00,0.00),('4','110','710','131665',2626414,'1936','294',1031931.14,1034251.77,2320.63,487332.30,0.00,0.00,0.00,0.00,0.00),('4','110','710','131665',2626415,'1937','294',1982907.30,1982907.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','711','131665',2626416,'1938','294',899348.86,899348.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','711','131665',2626417,'1939','294',2915114.89,2915476.23,361.34,75881.40,0.00,0.00,0.00,0.00,0.00),('4','110','711','131665',2626418,'1940','294',1951918.05,1952458.46,540.41,113486.10,0.00,0.00,0.00,0.00,0.00),('4','110','712','131665',2626419,'1941','294',1324592.72,1324808.72,216.00,45360.00,0.00,0.00,0.00,0.00,0.00),('4','110','712','131665',2626420,'1942','294',717421.41,717421.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','712','131665',2626421,'1943','294',1794356.55,1794853.12,496.57,104279.70,0.00,0.00,0.00,0.00,0.00),('4','110','713','131665',2626422,'1944','294',133458.67,133458.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','713','131665',2626423,'1945','294',2396656.74,2396656.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','713','131665',2626424,'1946','294',1069405.67,1069405.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','714','131665',2626425,'1947','295',1766872.03,1766872.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','715','131665',2626426,'1948','296',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','710','131665',2626427,'2098','294',3715467.91,3719081.27,3613.36,758805.60,0.00,0.00,0.00,0.00,0.00),('4','110','710','131665',2626428,'2099','294',2776420.73,2790289.20,13868.47,2912378.70,0.00,0.00,0.00,0.00,0.00),('4','110','710','131665',2626429,'2100','294',1946178.13,1950658.96,4480.83,940974.30,0.00,0.00,0.00,0.00,0.00),('4','110','711','131665',2626430,'2101','294',1466312.33,1466312.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','711','131665',2626431,'2102','294',3718234.90,3733502.48,15267.58,3206191.80,0.00,0.00,0.00,0.00,0.00),('4','110','711','131665',2626432,'2103','294',2463957.13,2465657.35,1700.22,357046.20,0.00,0.00,0.00,0.00,0.00),('4','110','712','131665',2626433,'2104','294',1331207.30,1331469.73,262.43,55110.30,0.00,0.00,0.00,0.00,0.00),('4','110','712','131665',2626434,'2105','294',248648.67,248648.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','712','131665',2626435,'2106','294',2557207.07,2559302.92,2095.85,440128.50,0.00,0.00,0.00,0.00,0.00),('4','110','713','131665',2626436,'2107','294',1272998.13,1272998.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','713','131665',2626437,'2108','294',439793.38,439793.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','713','131665',2626438,'2109','294',2587058.30,2587058.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','714','131665',2626439,'2110','295',4217793.32,4217793.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','710','131666',2626440,'1935','294',3569155.31,3572297.13,3141.82,659782.20,0.00,0.00,0.00,0.00,0.00),('4','110','710','131666',2626441,'1936','294',1034251.77,1035977.90,1726.13,362487.30,0.00,0.00,0.00,0.00,0.00),('4','110','710','131666',2626442,'1937','294',1982907.30,1982907.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','711','131666',2626443,'1938','294',899348.86,899348.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','711','131666',2626444,'1939','294',2915476.23,2915476.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','711','131666',2626445,'1940','294',1952458.46,1952458.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','712','131666',2626446,'1941','294',1324808.72,1331469.73,6661.01,1398812.10,0.00,0.00,0.00,0.00,0.00),('4','110','712','131666',2626447,'1942','294',717421.41,717421.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','712','131666',2626448,'1943','294',1794853.12,1794857.12,4.00,840.00,0.00,0.00,0.00,0.00,0.00),('4','110','713','131666',2626449,'1944','294',133458.67,133458.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','713','131666',2626450,'1945','294',2396656.74,2396656.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','713','131666',2626451,'1946','294',1069405.67,1069405.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','714','131666',2626452,'1947','295',1766872.03,1766872.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','715','131666',2626453,'1948','296',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','710','131666',2626454,'2098','294',3719081.27,3722090.76,3009.49,631992.90,0.00,0.00,0.00,0.00,0.00),('4','110','710','131666',2626455,'2099','294',2790289.20,2795879.56,5590.36,1173975.60,0.00,0.00,0.00,0.00,0.00),('4','110','710','131666',2626456,'2100','294',1950658.96,1954411.34,3752.38,787999.80,0.00,0.00,0.00,0.00,0.00),('4','110','711','131666',2626457,'2101','294',1466312.33,1466312.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','711','131666',2626458,'2102','294',3733502.48,3733502.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','711','131666',2626459,'2103','294',2465657.35,2465657.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','712','131666',2626460,'2104','294',1331469.73,1331469.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','712','131666',2626461,'2105','294',248648.67,248648.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','712','131666',2626462,'2106','294',2559302.92,2559302.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','713','131666',2626463,'2107','294',1272998.13,1272998.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','713','131666',2626464,'2108','294',439793.38,439793.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','713','131666',2626465,'2109','294',2587058.30,2587058.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','714','131666',2626466,'2110','295',4217793.32,4217793.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','710','131667',2626467,'1935','294',3572297.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','710','131667',2626468,'1936','294',1035977.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','710','131667',2626469,'1937','294',1982907.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','711','131667',2626470,'1938','294',899348.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','711','131667',2626471,'1939','294',2915476.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','711','131667',2626472,'1940','294',1952458.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','712','131667',2626473,'1941','294',1331469.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','712','131667',2626474,'1942','294',717421.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','712','131667',2626475,'1943','294',1794857.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','713','131667',2626476,'1944','294',133458.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','713','131667',2626477,'1945','294',2396656.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','713','131667',2626478,'1946','294',1069405.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','714','131667',2626479,'1947','295',1766872.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','715','131667',2626480,'1948','296',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','710','131667',2626481,'2098','294',3722090.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','710','131667',2626482,'2099','294',2795879.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','710','131667',2626483,'2100','294',1954411.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','711','131667',2626484,'2101','294',1466312.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','711','131667',2626485,'2102','294',3733502.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','711','131667',2626486,'2103','294',2465657.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','712','131667',2626487,'2104','294',1331469.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','712','131667',2626488,'2105','294',248648.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','712','131667',2626489,'2106','294',2559302.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','713','131667',2626490,'2107','294',1272998.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','713','131667',2626491,'2108','294',439793.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','713','131667',2626492,'2109','294',2587058.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('4','110','714','131667',2626493,'2110','295',4217793.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=396160 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('4','110','131060','295',210.00,210.00,1561.85,0.00,0.00,0.00,0.00,394333),('4','110','131060','296',0.00,0.00,0.00,0.00,0.00,0.00,0.00,394334),('4','110','131060','294',125.00,125.00,18590.24,0.00,0.00,0.00,0.00,394335),('4','110','131332','295',210.00,210.00,3402.61,0.00,0.00,0.00,0.00,395152),('4','110','131332','296',0.00,0.00,0.00,0.00,0.00,0.00,0.00,395153),('4','110','131332','294',125.00,125.00,29435.98,0.00,0.00,0.00,0.00,395154),('4','110','131656','295',210.00,210.00,100.00,0.00,0.00,0.00,0.00,396124),('4','110','131656','296',0.00,0.00,0.00,0.00,0.00,0.00,0.00,396125),('4','110','131656','294',125.00,125.00,0.00,0.00,0.00,0.00,0.00,396126),('4','110','131662','295',210.00,210.00,7200.00,0.00,0.00,0.00,0.00,396142),('4','110','131662','296',0.00,0.00,0.00,0.00,0.00,0.00,0.00,396143),('4','110','131662','294',125.00,125.00,0.00,0.00,0.00,0.00,0.00,396144),('4','110','131663','295',210.00,210.00,0.00,0.00,0.00,0.00,0.00,396145),('4','110','131663','296',0.00,0.00,0.00,0.00,0.00,0.00,0.00,396146),('4','110','131663','294',125.00,125.00,0.00,0.00,0.00,0.00,0.00,396147),('4','110','131664','294',210.00,210.00,0.00,0.00,0.00,0.00,0.00,396148),('4','110','131664','295',850.00,850.00,0.00,0.00,0.00,0.00,0.00,396149),('4','110','131664','296',0.00,0.00,0.00,0.00,0.00,0.00,0.00,396150),('4','110','131665','295',850.00,850.00,0.00,0.00,0.00,0.00,0.00,396151),('4','110','131665','296',0.00,0.00,0.00,0.00,0.00,0.00,0.00,396152),('4','110','131665','294',210.00,210.00,48358.24,0.00,0.00,0.00,0.00,396153),('4','110','131666','294',210.00,210.00,23885.19,0.00,0.00,0.00,0.00,396154),('4','110','131666','295',850.00,850.00,0.00,0.00,0.00,0.00,0.00,396155),('4','110','131666','296',0.00,0.00,0.00,0.00,0.00,0.00,0.00,396156),('4','110','131667','294',210.00,210.00,0.00,0.00,0.00,0.00,0.00,396157),('4','110','131667','295',850.00,850.00,0.00,0.00,0.00,0.00,0.00,396158),('4','110','131667','296',0.00,0.00,0.00,0.00,0.00,0.00,0.00,396159);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=275 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('4',274,'110','PRODUCT TANKS','TANKS CONTAINING PRODUCTS.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=716 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('4','110','274',710,0,'294','PMS TANK 1&2',90000.00,1.00,29072.00,'TANKS CONTAINING PETROLEUM.','456','2019-09-30 20:13:26','2019-09-30 20:13:26','456',5,1),('4','110','274',711,0,'294','PMS TANK 3&4',90000.00,1.00,41104.00,'TANKS CONTAINING PETROLEUM.','456','2019-09-30 20:16:31','2019-09-30 20:16:31','456',5,1),('4','110','274',712,0,'294','PMS TANK 5&6',90000.00,1.00,47405.00,'TANKS CONTAINING PETROLEUM.','456','2019-09-30 20:19:11','2019-09-30 20:19:11','456',5,1),('4','110','274',713,0,'294','PMS TANK 7&8',90000.00,1.00,18497.00,'TANKS CONTAINING PETROLEUM.','456','2019-09-30 20:22:06','2019-09-30 20:22:06','456',5,1),('4','110','274',714,0,'295','AGO TANK',45000.00,1.00,32536.00,'TANKS CONTAINING DIESEL.','456','2019-09-30 20:25:03','2019-09-30 20:25:03','456',5,1),('4','110','274',715,0,'296','DPK TANK',45000.00,1.00,0.00,'TANKS CONTAINING KEROSENE.','456','2019-09-30 20:26:51','2019-09-30 20:26:51','456',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'4','110',715,0.00,'2023-02-15 10:39:24'),(2,'4','110',714,32536.00,'2023-02-15 10:39:24'),(3,'4','110',713,18497.00,'2023-02-15 10:39:24'),(4,'4','110',712,77669.14,'2023-02-15 10:39:24'),(5,'4','110',711,68234.45,'2023-02-15 10:39:24'),(6,'4','110',710,29433.98,'2023-02-15 10:39:24');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2613819 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2612903,'4','110',NULL,295,'Balance from closing inventory values 2021-11-31 23:59:59',2575536.60,9613561.60,45000.00,12265.00,0.00,'2021-11-30 23:59:59','',''),(2612969,'4','110',NULL,294,'Balance from closing inventory values 2021-11-31 23:59:59',6003277.50,23112500.00,184900.00,48026.00,0.00,'2021-11-30 23:59:59','',''),(2613134,'4','110',NULL,296,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613155,'4','110','715',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613212,'4','110','712',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,47405.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613224,'4','110','710',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,29072.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613445,'4','110','711',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,41104.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613584,'4','110','713',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,18497.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613776,'4','110','714',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,32536.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613777,'4','110',NULL,294,'Purchased from ALIKO OIL NIG. LIMITED',0.00,10500000.00,50000.00,0.00,0.00,'2023-02-14 09:21:28','',''),(2613778,'4','110',NULL,294,'Reception corrector for bridging 70796',0.00,0.00,0.00,15000.00,0.00,'2023-02-14 09:43:54','',''),(2613779,'4','110','711',294,'Received from bridging 70796',0.00,0.00,15000.00,0.00,0.00,'2023-02-14 09:43:54','',''),(2613780,'4','110',NULL,294,'Reception corrector for bridging 70795',0.00,0.00,0.00,15000.00,0.00,'2023-02-14 09:43:54','',''),(2613781,'4','110','710',294,'Received from bridging 70795',0.00,0.00,15000.00,0.00,0.00,'2023-02-14 09:43:54','',''),(2613782,'4','110',NULL,294,'Reception corrector for bridging 70797',0.00,0.00,0.00,20000.00,0.00,'2023-02-14 09:44:41','',''),(2613783,'4','110','712',294,'Received from bridging 70797',0.00,0.00,20000.00,0.00,0.00,'2023-02-14 09:44:41','',''),(2613784,'4','110',NULL,294,'Purchased from ALIKO OIL NIG. LIMITED',0.00,10500000.00,50000.00,0.00,0.00,'2023-02-15 09:26:48','',''),(2613785,'4','110',NULL,294,'Reception corrector for bridging 70798',0.00,0.00,0.00,15000.00,0.00,'2023-02-15 09:31:21','',''),(2613786,'4','110','710',294,'Received from bridging 70798',0.00,0.00,15000.00,0.00,0.00,'2023-02-15 09:31:21','',''),(2613787,'4','110',NULL,294,'Reception corrector for bridging 70800',0.00,0.00,0.00,20000.00,0.00,'2023-02-15 09:33:51','',''),(2613788,'4','110','712',294,'Received from bridging 70800',0.00,0.00,20000.00,0.00,0.00,'2023-02-15 09:33:51','',''),(2613789,'4','110',NULL,294,'Reception corrector for bridging 70799',0.00,0.00,0.00,15000.00,0.00,'2023-02-15 09:34:14','',''),(2613790,'4','110','711',294,'Received from bridging 70799',0.00,0.00,15000.00,0.00,0.00,'2023-02-15 09:34:14','',''),(2613791,'4','110','710',294,'Sale Id shift 131665',0.00,0.00,0.00,3134.55,0.00,'2023-02-15 09:36:03','',''),(2613792,'4','110','710',294,'Sale Id shift 131665',0.00,0.00,0.00,2320.63,0.00,'2023-02-15 09:36:03','',''),(2613793,'4','110','711',294,'Sale Id shift 131665',0.00,0.00,0.00,361.34,0.00,'2023-02-15 09:36:03','',''),(2613794,'4','110','711',294,'Sale Id shift 131665',0.00,0.00,0.00,540.41,0.00,'2023-02-15 09:36:03','',''),(2613795,'4','110','712',294,'Sale Id shift 131665',0.00,0.00,0.00,216.00,0.00,'2023-02-15 09:36:03','',''),(2613796,'4','110','712',294,'Sale Id shift 131665',0.00,0.00,0.00,496.57,0.00,'2023-02-15 09:36:03','',''),(2613797,'4','110','710',294,'Sale Id shift 131665',0.00,0.00,0.00,3613.36,0.00,'2023-02-15 09:36:03','',''),(2613798,'4','110','710',294,'Sale Id shift 131665',0.00,0.00,0.00,13868.47,0.00,'2023-02-15 09:36:03','',''),(2613799,'4','110','710',294,'Sale Id shift 131665',0.00,0.00,0.00,4480.83,0.00,'2023-02-15 09:36:03','',''),(2613800,'4','110','711',294,'Sale Id shift 131665',0.00,0.00,0.00,15267.58,0.00,'2023-02-15 09:36:03','',''),(2613801,'4','110','711',294,'Sale Id shift 131665',0.00,0.00,0.00,1700.22,0.00,'2023-02-15 09:36:03','',''),(2613802,'4','110','712',294,'Sale Id shift 131665',0.00,0.00,0.00,262.43,0.00,'2023-02-15 09:36:03','',''),(2613803,'4','110','712',294,'Sale Id shift 131665',0.00,0.00,0.00,2095.85,0.00,'2023-02-15 09:36:03','',''),(2613804,'4','110',NULL,294,'Sale Id shift 131665',10155230.40,0.00,0.00,0.00,0.00,'2023-02-15 09:36:03','',''),(2613805,'4','110','710',294,'Sale Id shift 131666',0.00,0.00,0.00,3141.82,0.00,'2023-02-15 09:49:38','',''),(2613806,'4','110','710',294,'Sale Id shift 131666',0.00,0.00,0.00,1726.13,0.00,'2023-02-15 09:49:38','',''),(2613807,'4','110','712',294,'Sale Id shift 131666',0.00,0.00,0.00,6661.01,0.00,'2023-02-15 09:49:38','',''),(2613808,'4','110','712',294,'Sale Id shift 131666',0.00,0.00,0.00,4.00,0.00,'2023-02-15 09:49:38','',''),(2613809,'4','110','710',294,'Sale Id shift 131666',0.00,0.00,0.00,3009.49,0.00,'2023-02-15 09:49:38','',''),(2613810,'4','110','710',294,'Sale Id shift 131666',0.00,0.00,0.00,5590.36,0.00,'2023-02-15 09:49:38','',''),(2613811,'4','110','710',294,'Sale Id shift 131666',0.00,0.00,0.00,3752.38,0.00,'2023-02-15 09:49:38','',''),(2613812,'4','110',NULL,294,'Sale Id shift 131666',5015889.90,0.00,0.00,0.00,0.00,'2023-02-15 09:49:38','',''),(2613813,'4','110',NULL,294,'Purchased from ALIKO OIL NIG. LIMITED',0.00,9450000.00,45000.00,0.00,0.00,'2023-02-15 10:10:53','',''),(2613814,'4','110',NULL,294,'Purchased from ALIKO OIL NIG. LIMITED',0.00,9450000.00,45000.00,0.00,0.00,'2023-02-15 10:24:40','',''),(2613815,'4','110',NULL,294,'Reception corrector for bridging 70801',0.00,0.00,0.00,15000.00,0.00,'2023-02-15 10:30:53','',''),(2613816,'4','110','710',294,'Received from bridging 70801',0.00,0.00,15000.00,0.00,0.00,'2023-02-15 10:30:53','',''),(2613817,'4','110',NULL,294,'Reception corrector for bridging 70802',0.00,0.00,0.00,15000.00,0.00,'2023-02-15 10:32:46','',''),(2613818,'4','110','711',294,'Received from bridging 70802',0.00,0.00,15000.00,0.00,0.00,'2023-02-15 10:32:46','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_balances`
--

DROP TABLE IF EXISTS `inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_balances`
--

LOCK TABLES `inventory_balances` WRITE;
/*!40000 ALTER TABLE `inventory_balances` DISABLE KEYS */;
INSERT INTO `inventory_balances` VALUES (1,'4','110',296,0.00,'2023-02-15 10:39:24'),(2,'4','110',295,32735.00,'2023-02-15 10:39:24'),(3,'4','110',294,254630.57,'2023-02-15 10:39:24');
/*!40000 ALTER TABLE `inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=353100 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (351801,'4','110',295,'Sale Id shift 131060',0.00,327988.50,210.00,327988.50,0.00,'2020-04-02 08:56:22'),(351802,'4','110',294,'Sale Id shift 131060',0.00,2323780.00,125.00,2323780.00,0.00,'2020-04-02 08:56:22'),(352393,'4','110',295,'Sale Id shift 131332',0.00,714548.10,210.00,714548.10,0.00,'2020-04-04 10:46:37'),(352394,'4','110',294,'Sale Id shift 131332',0.00,3679497.50,125.00,3679497.50,0.00,'2020-04-04 10:46:37'),(353085,'4','110',295,'Sale Id shift 131656',0.00,21000.00,210.00,21000.00,0.00,'2020-04-07 09:36:01'),(353097,'4','110',295,'Sale Id shift 131662',0.00,1512000.00,210.00,1512000.00,0.00,'2020-04-07 09:57:04'),(353098,'4','110',294,'Sale Id shift 131665',0.00,10155230.40,210.00,10155230.40,0.00,'2023-02-15 09:36:03'),(353099,'4','110',294,'Sale Id shift 131666',0.00,5015889.90,210.00,5015889.90,0.00,'2023-02-15 09:49:38');
/*!40000 ALTER TABLE `inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices`
--

DROP TABLE IF EXISTS `invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `expirydate` date NOT NULL,
  `notes` text,
  `status` int NOT NULL DEFAULT '0',
  `email` varchar(200) DEFAULT NULL,
  `email_sent_at` datetime DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `payment_method` varchar(50) DEFAULT NULL,
  `payment_details` text,
  `payment_status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `status` (`status`,`company_id`,`station_id`),
  KEY `email_sent_at` (`email_sent_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices`
--

LOCK TABLES `invoices` WRITE;
/*!40000 ALTER TABLE `invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices_items`
--

DROP TABLE IF EXISTS `invoices_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices_items` (
  `id` int NOT NULL AUTO_INCREMENT,
  `invoice_id` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(200) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `item_type` varchar(50) NOT NULL,
  `item_id` varchar(100) NOT NULL,
  `item_details` longtext,
  PRIMARY KEY (`id`),
  KEY `name` (`name`,`invoice_id`,`station_id`),
  KEY `companycode` (`company_id`),
  KEY `status` (`status`,`item_type`,`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices_items`
--

LOCK TABLES `invoices_items` WRITE;
/*!40000 ALTER TABLE `invoices_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ledgers`
--

DROP TABLE IF EXISTS `ledgers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ledgers` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` int NOT NULL AUTO_INCREMENT,
  `ledgertype` varchar(10) NOT NULL,
  `accounttype` varchar(50) NOT NULL,
  `accountid` varchar(50) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `details` varchar(1000) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `accounttype` (`accounttype`,`accountid`,`credit`,`debit`,`thedate`),
  KEY `cooperative` (`company_id`),
  KEY `depot_id` (`station_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=3770211 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ledgers`
--

LOCK TABLES `ledgers` WRITE;
/*!40000 ALTER TABLE `ledgers` DISABLE KEYS */;
INSERT INTO `ledgers` VALUES ('4','110',1163449,'','supplier','119',5612500.00,0.00,'Purchase Id 45911 for 44,900 litters of Petrol - PMS from ALIKO OIL NIG. LIMITED','2020-03-31 08:30:57','',''),('4','110',1163467,'','supplier','119',6250000.00,0.00,'Purchase Id 45912 for 50,000 litters of Petrol - PMS from ALIKO OIL NIG. LIMITED','2020-03-31 09:05:00','',''),('4','110',1163472,'','supplier','119',0.00,25000.00,'Payment Id 137696 for invoice:SHORTAGE, receipt: FKJ 50 XA by ALIKO OIL NIG. LIMITED','2020-03-31 09:31:29','',''),('4','110',1164387,'','supplier','119',6250000.00,0.00,'Purchase Id 45963 for 50,000 litters of Petrol - PMS from ALIKO OIL NIG. LIMITED','2020-04-01 08:19:30','',''),('4','110',1164436,'','supplier','119',9450000.00,0.00,'Purchase Id 45965 for 45,000 litters of Diesel - AGO from ALIKO OIL NIG. LIMITED','2020-04-01 09:33:35','',''),('4','110',1165331,'','customer','1542',0.00,6500.00,'Credit Sales for 52.00 Litres of Petrol from shift 131060 on 2020-04-02 08:56:22 ','2020-04-02 08:56:22','',''),('4','110',1167123,'','supplier','119',5000000.00,0.00,'Purchase Id 46124 for 40,000 litters of Petrol - PMS from ALIKO OIL NIG. LIMITED','2020-04-04 09:52:35','',''),('4','110',1167173,'','customer','1542',0.00,4000.00,'Credit Sales for 32.00 Litres of Petrol from shift 131332 on 2020-04-04 10:46:37 ','2020-04-04 10:46:37','',''),('4','110',1167181,'','supplier','119',0.00,25000.00,'Payment Id 138574 for invoice:SHORTAGE, receipt:  by ALIKO OIL NIG. LIMITED','2020-04-04 11:19:28','',''),('4','110',1167183,'','supplier','119',0.00,1995810.00,'Payment Id 138572 for invoice:131332, receipt:  by ALIKO OIL NIG. LIMITED','2020-04-04 11:19:58','',''),('4','110',1167185,'','supplier','119',0.00,1679691.00,'Payment Id 138573 for invoice:131332, receipt:  by ALIKO OIL NIG. LIMITED','2020-04-04 11:21:38','',''),('4','110',1167187,'','supplier','119',0.00,1679691.00,'Payment Id 138571 for invoice:131332, receipt:  by ALIKO OIL NIG. LIMITED','2020-04-04 11:21:38','',''),('4','110',1167189,'','supplier','119',0.00,1995810.00,'Payment Id 138569 for invoice:131332, receipt:  by ALIKO OIL NIG. LIMITED','2020-04-04 11:21:38','',''),('4','110',1167191,'','supplier','119',0.00,50000.00,'Payment Id 138128 for invoice:131060, receipt:  by ALIKO OIL NIG. LIMITED','2020-04-04 11:21:38','',''),('4','110',1167198,'','supplier','119',0.00,1000000.00,'Payment Id 138584 for invoice:131335, receipt:  by ALIKO OIL NIG. LIMITED','2020-04-04 11:31:00','',''),('4','110',1168553,'','supplier','119',0.00,714550.00,'Payment Id 138570 for invoice:131332, receipt:  by ALIKO OIL NIG. LIMITED','2020-04-07 09:04:31','',''),('4','110',1168555,'','supplier','119',0.00,50000.00,'Payment Id 139186 for invoice:131332, receipt:  by ALIKO OIL NIG. LIMITED','2020-04-07 09:10:25','',''),('4','110',1168633,'','customer','1542',100000.00,0.00,'Payment Id 85051 for invoice:, receipt:  by KALWA INDUSTRIES','2020-04-07 09:22:09','',''),('4','110',1168752,'','customer','1542',0.00,20790.00,'Credit Sales for 100.00 Litres of Diesel from shift 131656 on 2020-04-07 09:36:01 ','2020-04-07 09:36:01','',''),('4','110',1168839,'','supplier','119',163561.60,0.00,'Inventory value adjustment for product Id 295 from 210.00 to 215','2020-04-07 09:59:39','',''),('4','110',3766951,'','24','2386',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('4','110',3767137,'','24','2390',0.00,32726061.60,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('4','110',3768144,'','2','2394',8090552.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('4','110',3768261,'','6.1','2388',1100000.00,8647524.10,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('4','110',3768329,'','2','2395',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('4','110',3768865,'','20','2387',8578814.10,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('4','110',3769038,'','2','2396',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('4','110',3769997,'','2','2393',25000.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('4','110',3770102,'','2','2397',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('4','110',3770190,'','22','2389',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('4','110',3770191,'','24','2390',0.00,10500000.00,'Purchase Id 46125 for 50,000.00 litters of Petrol - PMS from ALIKO OIL NIG. LIMITED','2023-02-14 09:21:28','',''),('4','110',3770192,'','supplier','119',10500000.00,0.00,'Purchase Id 46125 for 50,000.00 litters of Petrol - PMS from ALIKO OIL NIG. LIMITED','2023-02-14 09:21:28','',''),('4','110',3770193,'','20','2387',0.00,0.00,'Sales from shift 131663 on 2023-02-14 09:53:42 ','2023-02-14 09:53:42','',''),('4','110',3770194,'','6.1','2388',0.00,0.00,'Sales from shift 131663 on 2023-02-14 09:53:42 ','2023-02-14 09:53:42','',''),('4','110',3770195,'','20','2387',0.00,0.00,'Sales from shift 131664 on 2023-02-14 10:13:33 ','2023-02-14 10:13:33','',''),('4','110',3770196,'','6.1','2388',0.00,0.00,'Sales from shift 131664 on 2023-02-14 10:13:33 ','2023-02-14 10:13:33','',''),('4','110',3770197,'','2','2393',10055230.54,0.00,'Payment Id 139187 for invoice:131665, receipt: 12345 by ALIKO OIL NIG. LIMITED','2023-02-14 11:44:23','',''),('4','110',3770198,'','supplier','119',0.00,10055230.54,'Payment Id 139187 for invoice:131665, receipt: 12345 by ALIKO OIL NIG. LIMITED','2023-02-14 11:44:23','',''),('4','110',3770199,'','24','2390',0.00,10500000.00,'Purchase Id 46126 for 50,000.00 litters of Petrol - PMS from ALIKO OIL NIG. LIMITED','2023-02-15 09:26:48','',''),('4','110',3770200,'','supplier','119',10500000.00,0.00,'Purchase Id 46126 for 50,000.00 litters of Petrol - PMS from ALIKO OIL NIG. LIMITED','2023-02-15 09:26:48','',''),('4','110',3770201,'','20','2387',10155230.40,0.00,'Sales from shift 131665 on 2023-02-15 09:36:03 ','2023-02-15 09:36:03','',''),('4','110',3770202,'','6.1','2388',0.00,10155230.40,'Sales from shift 131665 on 2023-02-15 09:36:03 ','2023-02-15 09:36:03','',''),('4','110',3770203,'','20','2387',5015889.90,0.00,'Sales from shift 131666 on 2023-02-15 09:49:38 ','2023-02-15 09:49:38','',''),('4','110',3770204,'','6.1','2388',0.00,5015889.90,'Sales from shift 131666 on 2023-02-15 09:49:38 ','2023-02-15 09:49:38','',''),('4','110',3770205,'','2','2393',5015889.90,0.00,'Payment Id 139188 for invoice:131666, receipt: 12345 by ALIKO OIL NIG. LIMITED','2023-02-15 09:58:21','',''),('4','110',3770206,'','supplier','119',0.00,5015889.90,'Payment Id 139188 for invoice:131666, receipt: 12345 by ALIKO OIL NIG. LIMITED','2023-02-15 09:58:21','',''),('4','110',3770207,'','24','2390',0.00,9450000.00,'Purchase Id 46127 for 45,000.00 litters of Petrol - PMS from ALIKO OIL NIG. LIMITED','2023-02-15 10:10:53','',''),('4','110',3770208,'','supplier','119',9450000.00,0.00,'Purchase Id 46127 for 45,000.00 litters of Petrol - PMS from ALIKO OIL NIG. LIMITED','2023-02-15 10:10:53','',''),('4','110',3770209,'','24','2390',0.00,9450000.00,'Purchase Id 46128 for 45,000.00 litters of Petrol - PMS from ALIKO OIL NIG. LIMITED','2023-02-15 10:24:40','',''),('4','110',3770210,'','supplier','119',9450000.00,0.00,'Purchase Id 46128 for 45,000.00 litters of Petrol - PMS from ALIKO OIL NIG. LIMITED','2023-02-15 10:24:40','','');
/*!40000 ALTER TABLE `ledgers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `options`
--

DROP TABLE IF EXISTS `options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `options` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` bigint NOT NULL,
  `station_id` bigint NOT NULL,
  `option_key` varchar(200) NOT NULL,
  `option_value` longtext,
  `thedate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `station_id` (`station_id`,`option_key`),
  KEY `company_id` (`company_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `options`
--

LOCK TABLES `options` WRITE;
/*!40000 ALTER TABLE `options` DISABLE KEYS */;
INSERT INTO `options` VALUES (1,4,110,'print_duplicate_receipt','Yes','2023-02-13 09:01:15'),(2,4,110,'remittance_account','2393','2023-02-13 09:01:15');
/*!40000 ALTER TABLE `options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products`
--

DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `measurement` varchar(20) NOT NULL,
  `quantity2` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`code`,`name`,`measurement`,`quantity2`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `cleanup` (`cleanup`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB AUTO_INCREMENT=297 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products`
--

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (294,'4','110','PMS','Petrol','Litres',1,210.00,210.00,210.00,210.00,0.00,0,'2019-09-30 20:13:26','456','456','2019-09-30 20:13:26',1),(295,'4','110','AGO','Diesel','Litres',1,850.00,850.00,850.00,850.00,30000.00,0,'2019-09-30 20:25:03','456','456','2020-04-07 10:03:51',1),(296,'4','110','DPK','Kerosene','Litres',1,0.00,0.00,0.00,0.00,0.00,0,'2019-09-30 20:26:51','456','456','2019-09-30 20:26:51',1);
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_changevalues`
--

DROP TABLE IF EXISTS `products_changevalues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_changevalues` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `change_id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity` bigint NOT NULL,
  `oldrate` decimal(20,2) NOT NULL,
  `newrate` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`change_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB AUTO_INCREMENT=470 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_changevalues`
--

LOCK TABLES `products_changevalues` WRITE;
/*!40000 ALTER TABLE `products_changevalues` DISABLE KEYS */;
INSERT INTO `products_changevalues` VALUES ('4','110',469,'295','131663',32735,210.00,215.00,'','456','2020-04-07 09:59:39');
/*!40000 ALTER TABLE `products_changevalues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_prices`
--

DROP TABLE IF EXISTS `products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB AUTO_INCREMENT=7881 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_prices`
--

LOCK TABLES `products_prices` WRITE;
/*!40000 ALTER TABLE `products_prices` DISABLE KEYS */;
INSERT INTO `products_prices` VALUES (7871,'4','110',294,125.00,0.00,0.00,0.00,'Cost from purchase id #45911','2020-03-31 08:30:57','456'),(7876,'4','110',294,125.00,125.00,0.00,123.00,'','2020-04-01 09:22:56','456'),(7877,'4','110',295,210.00,210.00,0.00,205.00,'','2020-04-01 09:29:10','456'),(7878,'4','110',294,210.00,125.00,0.00,0.00,'Cost from purchase id #46125','2023-02-14 09:21:28','954'),(7879,'4','110',294,210.00,210.00,210.00,210.00,'','2023-02-14 10:06:55','954'),(7880,'4','110',295,850.00,850.00,850.00,850.00,'','2023-02-14 10:08:19','954');
/*!40000 ALTER TABLE `products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_reconciliations`
--

DROP TABLE IF EXISTS `products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_reconciliations`
--

LOCK TABLES `products_reconciliations` WRITE;
/*!40000 ALTER TABLE `products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_shortages`
--

DROP TABLE IF EXISTS `products_shortages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_shortages` (
  `shortage_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shortagedate` date NOT NULL,
  `product_id` varchar(10) NOT NULL,
  `type` int NOT NULL DEFAULT '0',
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`shortage_id`),
  KEY `companycode` (`company_id`,`shortagedate`,`product_id`,`rate`,`quantity`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_shortages`
--

LOCK TABLES `products_shortages` WRITE;
/*!40000 ALTER TABLE `products_shortages` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_shortages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pts_nozzles`
--

DROP TABLE IF EXISTS `pts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pts_nozzles` (
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pts_id` int NOT NULL,
  `pump` varchar(20) NOT NULL,
  `code` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `last_volume` decimal(20,2) NOT NULL,
  `last_price` decimal(20,2) NOT NULL,
  `last_amount` decimal(20,2) NOT NULL,
  `last_transaction` int NOT NULL DEFAULT '0',
  `total_volume` decimal(20,2) NOT NULL,
  `total_amount` decimal(20,2) NOT NULL,
  `total_transactions` decimal(20,2) NOT NULL,
  `lastconnect` datetime NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `terminal_id` (`pts_id`,`pump`,`code`,`lastconnect`),
  KEY `companycode` (`company_id`,`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pts_nozzles`
--

LOCK TABLES `pts_nozzles` WRITE;
/*!40000 ALTER TABLE `pts_nozzles` DISABLE KEYS */;
/*!40000 ALTER TABLE `pts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases`
--

DROP TABLE IF EXISTS `purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=46129 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases`
--

LOCK TABLES `purchases` WRITE;
/*!40000 ALTER TABLE `purchases` DISABLE KEYS */;
INSERT INTO `purchases` VALUES (45911,'4','110','2020-03-31',294,119,125.00,44900.00,0.00,0.00,5612500.00,0.00,'','65789','KMC 54 ZB','','','','2020-03-31 08:26:21',15,'','456','456','2020-03-31 08:27:26','456','2020-03-31 08:30:57'),(45912,'4','110','2020-03-31',294,119,125.00,50000.00,0.00,0.00,6250000.00,0.00,'','65789','FKJ 73 XA','','','','2020-03-31 09:03:04',15,'','456','','0000-00-00 00:00:00','456','2020-03-31 09:05:00'),(45963,'4','110','2020-04-01',294,119,125.00,50000.00,0.00,0.00,6250000.00,0.00,'','67890','YAB 959 YR','','','','2020-04-01 08:19:05',15,'','456','','0000-00-00 00:00:00','456','2020-04-01 08:19:30'),(45965,'4','110','2020-04-01',295,119,210.00,45000.00,0.00,0.00,9450000.00,0.00,'','99999','KMC 54 ZB','','','','2020-04-01 09:32:50',15,'','456','','0000-00-00 00:00:00','456','2020-04-01 09:33:35'),(46124,'4','110','2020-04-04',294,119,125.00,40000.00,0.00,0.00,5000000.00,0.00,'','99999','KMC 54 ZB','','','','2020-04-04 09:50:08',15,'','456','','0000-00-00 00:00:00','456','2020-04-04 09:52:35'),(46125,'4','110','2023-02-02',294,119,210.00,50000.00,0.00,0.00,10500000.00,0.00,'','12345','KWL 55 ZZ','','','','2023-02-14 09:03:21',15,'','954','','0000-00-00 00:00:00','954','2023-02-14 09:21:28'),(46126,'4','110','2023-02-03',294,119,210.00,50000.00,0.00,0.00,10500000.00,0.00,'','1234','YAB959-YR','','','','2023-02-15 09:25:05',15,'','954','','0000-00-00 00:00:00','954','2023-02-15 09:26:48'),(46127,'4','110','2023-02-04',294,119,210.00,45000.00,0.00,0.00,9450000.00,0.00,'','12453','GWL129-XS','','','','2023-02-15 10:03:18',10,'','954','','0000-00-00 00:00:00','954','2023-02-15 10:10:53'),(46128,'4','110','2023-02-04',294,119,210.00,45000.00,0.00,0.00,9450000.00,0.00,'','12563','GWL-95-YR','','','','2023-02-15 10:04:53',5,'','954','','0000-00-00 00:00:00','954','2023-02-15 10:24:40');
/*!40000 ALTER TABLE `purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_payments`
--

DROP TABLE IF EXISTS `purchases_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `supplier_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`supplier_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=139189 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_payments`
--

LOCK TABLES `purchases_payments` WRITE;
/*!40000 ALTER TABLE `purchases_payments` DISABLE KEYS */;
INSERT INTO `purchases_payments` VALUES (137696,'4','110','2020-03-31',119,'FKJ 50 XA','','5',25000.00,'SHORTAGE','','','2393','NURA','5555',25000.00,'2020-03-31 09:30:39',5,'','456','','0000-00-00 00:00:00','456','2020-03-31 09:31:29'),(138128,'4','110','2020-04-02',119,'','','2',50000.00,'131060','','','','TARAUNI','',50000.00,'2020-04-02 08:58:09',5,'','456','','0000-00-00 00:00:00','456','2020-04-04 11:21:38'),(138569,'4','110','2020-04-04',119,'','','5',1995810.00,'131332','','','2394','ABBA BATAIYYA','756476',4394045.60,'2020-04-04 11:01:54',5,'','456','','0000-00-00 00:00:00','456','2020-04-04 11:21:38'),(138570,'4','110','2020-04-04',119,'','','5',714550.00,'131332','','','2394','ABBA BATAIYYA','756477',714548.10,'2020-04-04 11:03:15',5,'','456','456','2020-04-07 09:03:34','456','2020-04-07 09:04:31'),(138571,'4','110','2020-04-04',119,'','','10',1679691.00,'131332','','','2394','ABBA BATAIYYA','756477',4394045.60,'2020-04-04 11:04:24',5,'','456','','0000-00-00 00:00:00','456','2020-04-04 11:21:38'),(138572,'4','110','2020-04-04',119,'','','5',1995810.00,'131332','','','2394','ABBA BATAIYYA','756477',3679501.25,'2020-04-04 11:08:43',5,'','456','','0000-00-00 00:00:00','456','2020-04-04 11:19:58'),(138573,'4','110','2020-04-04',119,'','','10',1679691.00,'131332','','','2394','POS CUSTOMERS','54678',1679691.00,'2020-04-04 11:13:55',5,'','456','','0000-00-00 00:00:00','456','2020-04-04 11:21:38'),(138574,'4','110','2020-04-04',119,'','','5',25000.00,'SHORTAGE','','','2394','NURA','54678',25000.00,'2020-04-04 11:18:41',5,'KMC 54 ZB','456','','0000-00-00 00:00:00','456','2020-04-04 11:19:28'),(138584,'4','110','2020-04-04',119,'','','2',1000000.00,'131335','','','','','',1000000.00,'2020-04-04 11:29:52',5,'','456','456','2020-04-04 11:30:32','456','2020-04-04 11:31:00'),(139181,'4','110','2020-04-07',119,'','','5',1995810.00,'131332','','','2394','ABBA BATAIYYA','756477',1995810.00,'2020-04-07 08:55:59',0,'','456','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(139186,'4','110','2020-04-07',119,'','','2',50000.00,'131332','','','','','',50000.00,'2020-04-07 09:07:49',5,'CASH IFO HOP ZENITH BANK B/O CEO','456','','0000-00-00 00:00:00','456','2020-04-07 09:10:25'),(139187,'4','110','2023-02-14',119,'12345','','5',10055230.54,'131665','','','2393','HARUNA AYUBA','12345',10155230.40,'2023-02-14 11:35:40',5,'','954','954','2023-02-14 11:43:47','954','2023-02-14 11:44:23'),(139188,'4','110','2023-02-15',119,'12345','','5',5015889.90,'131666','','','2393','HAMZA','12385',5015889.90,'2023-02-15 09:55:28',5,'','954','954','2023-02-15 09:57:43','954','2023-02-15 09:58:21');
/*!40000 ALTER TABLE `purchases_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_receptions`
--

DROP TABLE IF EXISTS `purchases_receptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_receptions` (
  `bridge_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `purchase_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `loadingdate` datetime NOT NULL,
  `loadingpoint` varchar(100) DEFAULT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `received` decimal(20,2) NOT NULL,
  `distributed` decimal(20,2) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `vessel` varchar(50) NOT NULL,
  `drivername` varchar(30) NOT NULL,
  `driverphone` varchar(30) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`bridge_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`supplier_id`,`loadingdate`,`quantity`,`waybill`,`meterno`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`purchase_id`),
  KEY `truck_id` (`tank_id`)
) ENGINE=InnoDB AUTO_INCREMENT=70807 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_receptions`
--

LOCK TABLES `purchases_receptions` WRITE;
/*!40000 ALTER TABLE `purchases_receptions` DISABLE KEYS */;
INSERT INTO `purchases_receptions` VALUES (70469,'4',45911,'110',294,119,'2020-03-31 00:00:00','TOTAL APAPA',20000.00,20000.00,0.00,'77777','','710','KMC 54 ZB','ALHASSAN MUHAMMAD','090666666666','DISCHARGE OF PMS',5,'2020-03-31 08:49:38','456','0000-00-00 00:00:00','','2020-03-31 08:53:02','456'),(70470,'4',45911,'110',294,119,'2020-03-31 00:00:00','TOTAL APAPA',24900.00,24900.00,0.00,'77777','','711','KMC 54 ZB','ALHASSAN MUHAMMAD','090666666666','DISCHARGE OF PMS',5,'2020-03-31 08:49:38','456','0000-00-00 00:00:00','','2020-03-31 08:52:42','456'),(70471,'4',45912,'110',294,119,'2020-03-31 00:00:00','TOTAL APAPA',25000.00,25000.00,0.00,'656789','','712','FKJ 73 XA','ALHASSAN MUHAMMAD','0707777777777','DISCHARGE OF PMS',5,'2020-03-31 09:09:40','456','0000-00-00 00:00:00','','2020-03-31 09:10:46','456'),(70472,'4',45912,'110',294,119,'2020-03-31 00:00:00','TOTAL APAPA',25000.00,24800.00,0.00,'656789','','713','FKJ 73 XA','ALHASSAN MUHAMMAD','0707777777777','DISCHARGE OF PMS',5,'2020-03-31 09:09:40','456','0000-00-00 00:00:00','','2020-03-31 09:10:46','456'),(70543,'4',45963,'110',294,119,'2020-04-01 00:00:00','TOTAL APAPA',15000.00,15000.00,0.00,'77777','','710','YAB 959 YR','ALHASSAN MUHAMMAD','090666666666','DISCHARGE OF PMS',5,'2020-04-01 08:25:09','456','0000-00-00 00:00:00','','2020-04-01 08:26:05','456'),(70544,'4',45963,'110',294,119,'2020-04-01 00:00:00','TOTAL APAPA',15000.00,14800.00,0.00,'77777','','711','YAB 959 YR','ALHASSAN MUHAMMAD','090666666666','DISCHARGE OF PMS',5,'2020-04-01 08:25:09','456','0000-00-00 00:00:00','','2020-04-01 08:26:05','456'),(70545,'4',45963,'110',294,119,'2020-04-01 00:00:00','TOTAL APAPA',15000.00,15000.00,0.00,'77777','','712','YAB 959 YR','ALHASSAN MUHAMMAD','090666666666','DISCHARGE OF PMS',5,'2020-04-01 08:25:09','456','0000-00-00 00:00:00','','2020-04-01 08:26:05','456'),(70546,'4',45963,'110',294,119,'2020-04-01 00:00:00','TOTAL APAPA',5000.00,5000.00,0.00,'7777','','713','YAB 959 YR','ALHASSAN MUHAMMAD','090666666666','DISCHARGE OF PMS',5,'2020-04-01 08:25:09','456','0000-00-00 00:00:00','','2020-04-01 08:26:05','456'),(70557,'4',45965,'110',295,119,'2020-04-01 00:00:00','TOTAL APAPA',45000.00,44800.00,0.00,'77777','','714','KMC 54 ZB','ALHASSAN MUHAMMAD','090666666666','DISCHARGE OF AGO',5,'2020-04-01 09:35:17','456','0000-00-00 00:00:00','','2020-04-01 09:35:38','456'),(70792,'4',46124,'110',294,119,'2020-04-04 00:00:00','TOTAL APAPA',15000.00,15000.00,0.00,'77777','','711','KMC 54 ZB','ALHASSAN MUHAMMAD','0707777777777','DISCHARGE OF PMS',5,'2020-04-04 10:03:07','456','0000-00-00 00:00:00','','2020-04-04 10:04:37','456'),(70793,'4',46124,'110',294,119,'2020-04-04 00:00:00','TOTAL APAPA',15000.00,14800.00,0.00,'77777','','712','KMC 54 ZB','ALHASSAN MUHAMMAD','0707777777777','DISCHARGE OF PMS',5,'2020-04-04 10:03:07','456','0000-00-00 00:00:00','','2020-04-04 10:04:37','456'),(70794,'4',46124,'110',294,119,'2020-04-04 00:00:00','TOTAL APAPA',10000.00,9800.00,0.00,'77777','','710','KMC 54 ZB','ALHASSAN MUHAMMAD','090666666666','DISCHARGE OF PMS',5,'2020-04-04 10:07:12','456','0000-00-00 00:00:00','','2020-04-04 10:10:00','456'),(70795,'4',46125,'110',294,119,'2023-02-14 00:00:00','TOTAL DEPOT',15000.00,15000.00,0.00,'12345','','710','KWL 55 ZZ','MALAM MUSA ','08122149590','DISCHARGE OF PMS',5,'2023-02-14 09:39:06','954','0000-00-00 00:00:00','','2023-02-14 09:43:54','954'),(70796,'4',46125,'110',294,119,'2023-02-14 00:00:00','TOTAL DEPOT',15000.00,15000.00,0.00,'12345','','711','KWL 55 ZZ','MALAM MUSA ','08122149590','DISCHARGE OF PMS',5,'2023-02-14 09:39:06','954','0000-00-00 00:00:00','','2023-02-14 09:43:54','954'),(70797,'4',46125,'110',294,119,'2023-02-14 00:00:00','TOTAL DEPOT',20000.00,20000.00,0.00,'12345','','712','KWL 55 ZZ','MALAM MUSA ','08122149590','DISCHARGE OF PMS',5,'2023-02-14 09:39:06','954','0000-00-00 00:00:00','','2023-02-14 09:44:41','954'),(70798,'4',46126,'110',294,119,'2023-02-15 00:00:00','TARAUNI SERVICE STATION',15000.00,15000.00,0.00,'','','710','YAB959-YR','MALLAM BALA','08038556829','',5,'2023-02-15 09:29:59','954','0000-00-00 00:00:00','','2023-02-15 09:31:21','954'),(70799,'4',46126,'110',294,119,'2023-02-15 00:00:00','TARAUNI SERVICE STATION',15000.00,15000.00,0.00,'','','711','YAB959-YR','MALLAM BALA','08038556829','',5,'2023-02-15 09:29:59','954','0000-00-00 00:00:00','','2023-02-15 09:34:14','954'),(70800,'4',46126,'110',294,119,'2023-02-15 00:00:00','TARAUNI SERVICE STATION',20000.00,20000.00,0.00,'','','712','YAB959-YR','MALLAM BALA','08038556829','',5,'2023-02-15 09:29:59','954','0000-00-00 00:00:00','','2023-02-15 09:33:51','954'),(70801,'4',46127,'110',294,119,'2023-02-15 00:00:00','TOTAL DEPOT',15000.00,15000.00,0.00,'','','710','GWL129-XS','GAMBO','09020027248','',5,'2023-02-15 10:23:36','954','0000-00-00 00:00:00','','2023-02-15 10:30:53','954'),(70802,'4',46127,'110',294,119,'2023-02-15 00:00:00','TOTAL DEPOT',15000.00,15000.00,0.00,'','','711','GWL129-XS','GAMBO','09020027248','',5,'2023-02-15 10:23:36','954','0000-00-00 00:00:00','','2023-02-15 10:32:46','954'),(70803,'4',46127,'110',294,119,'2023-02-15 00:00:00','TOTAL DEPOT',15000.00,15000.00,0.00,'','','712','GWL129-XS','GAMBO','09020027248','',0,'2023-02-15 10:23:36','954','0000-00-00 00:00:00','','0000-00-00 00:00:00',''),(70804,'4',46128,'110',294,119,'2023-02-15 00:00:00','TOTAL DEPOT',15000.00,15000.00,0.00,'12356','','710','GWL-95-YR','NURA DIVER','07062759355','DISCHARGE OF PMS',0,'2023-02-15 10:29:53','954','0000-00-00 00:00:00','','0000-00-00 00:00:00',''),(70805,'4',46128,'110',294,119,'2023-02-15 00:00:00','TOTAL DEPOT',15000.00,15000.00,0.00,'12356','','711','GWL-95-YR','NURA DIVER','07062759355','DISCHARGE OF PMS',0,'2023-02-15 10:29:53','954','0000-00-00 00:00:00','','0000-00-00 00:00:00',''),(70806,'4',46128,'110',294,119,'2023-02-15 00:00:00','TOTAL DEPOT',15000.00,15000.00,0.00,'12356','','712','GWL-95-YR','NURA DIVER','07062759355','DISCHARGE OF PMS',0,'2023-02-15 10:29:53','954','0000-00-00 00:00:00','','0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `purchases_receptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports`
--

DROP TABLE IF EXISTS `reports`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  `type` varchar(20) NOT NULL,
  `sql` text NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`report_id`),
  KEY `companycode` (`company_id`,`name`,`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports`
--

LOCK TABLES `reports` WRITE;
/*!40000 ALTER TABLE `reports` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_fields`
--

DROP TABLE IF EXISTS `reports_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(20) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `fieldname` varchar(50) NOT NULL,
  `order` int NOT NULL,
  `visibility` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`report_id`,`field_id`,`order`,`visibility`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_fields`
--

LOCK TABLES `reports_fields` WRITE;
/*!40000 ALTER TABLE `reports_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_filters`
--

DROP TABLE IF EXISTS `reports_filters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_filters` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(50) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `filter_id` int NOT NULL AUTO_INCREMENT,
  `criteria` varchar(20) NOT NULL,
  `value` varchar(100) NOT NULL,
  PRIMARY KEY (`filter_id`),
  KEY `companycode` (`company_id`,`report_id`),
  KEY `field_id` (`field_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_filters`
--

LOCK TABLES `reports_filters` WRITE;
/*!40000 ALTER TABLE `reports_filters` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_filters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_customers`
--

DROP TABLE IF EXISTS `retail_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_customers` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(100) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`name`,`phone`,`email`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_customers`
--

LOCK TABLES `retail_customers` WRITE;
/*!40000 ALTER TABLE `retail_customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory`
--

DROP TABLE IF EXISTS `retail_inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` int NOT NULL,
  `qtyout` int NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory`
--

LOCK TABLES `retail_inventory` WRITE;
/*!40000 ALTER TABLE `retail_inventory` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_balances`
--

DROP TABLE IF EXISTS `retail_inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_balances`
--

LOCK TABLES `retail_inventory_balances` WRITE;
/*!40000 ALTER TABLE `retail_inventory_balances` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_costs`
--

DROP TABLE IF EXISTS `retail_inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_costs`
--

LOCK TABLES `retail_inventory_costs` WRITE;
/*!40000 ALTER TABLE `retail_inventory_costs` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products`
--

DROP TABLE IF EXISTS `retail_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`name`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `parent_id` (`parent_id`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products`
--

LOCK TABLES `retail_products` WRITE;
/*!40000 ALTER TABLE `retail_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_prices`
--

DROP TABLE IF EXISTS `retail_products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_prices`
--

LOCK TABLES `retail_products_prices` WRITE;
/*!40000 ALTER TABLE `retail_products_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_reconciliations`
--

DROP TABLE IF EXISTS `retail_products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_reconciliations`
--

LOCK TABLES `retail_products_reconciliations` WRITE;
/*!40000 ALTER TABLE `retail_products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_purchases`
--

DROP TABLE IF EXISTS `retail_purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_purchases`
--

LOCK TABLES `retail_purchases` WRITE;
/*!40000 ALTER TABLE `retail_purchases` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales`
--

DROP TABLE IF EXISTS `retail_sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `saledate` date NOT NULL,
  `customer_id` varchar(20) NOT NULL DEFAULT '',
  `customer_name` varchar(50) NOT NULL,
  `customer_phone` varchar(30) NOT NULL,
  `quantity_kg` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `payment_method` varchar(10) NOT NULL,
  `payment_account_type` varchar(20) NOT NULL,
  `payment_account_id` varchar(20) NOT NULL,
  `paid` decimal(20,2) DEFAULT NULL,
  `change` decimal(20,2) DEFAULT '0.00',
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`customer_name`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `payment_method` (`payment_method`,`payment_account_type`,`payment_account_id`),
  KEY `customer_id` (`customer_id`),
  KEY `change` (`change`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales`
--

LOCK TABLES `retail_sales` WRITE;
/*!40000 ALTER TABLE `retail_sales` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_items`
--

DROP TABLE IF EXISTS `retail_sales_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `product_type` varchar(10) NOT NULL,
  `product_name` varchar(100) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `quantity_2` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `parent_cost` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`sale_id`,`product_id`,`rate`,`quantity`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`product_type`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_items`
--

LOCK TABLES `retail_sales_items` WRITE;
/*!40000 ALTER TABLE `retail_sales_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_payments`
--

DROP TABLE IF EXISTS `retail_sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_payments` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `payment_method` varchar(50) NOT NULL,
  `account_type` varchar(10) DEFAULT NULL,
  `account_id` bigint DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_by` bigint DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`sale_id`,`payment_method`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`account_type`),
  KEY `parent_id` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_payments`
--

LOCK TABLES `retail_sales_payments` WRITE;
/*!40000 ALTER TABLE `retail_sales_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales`
--

DROP TABLE IF EXISTS `sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `is_credit` int NOT NULL DEFAULT '0',
  `saledate` date NOT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `paid` int NOT NULL,
  `details` text NOT NULL,
  `ledger_notes` varchar(150) DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`product_id`,`customer_id`,`rate`,`quantity`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`is_credit`)
) ENGINE=InnoDB AUTO_INCREMENT=224974 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales`
--

LOCK TABLES `sales` WRITE;
/*!40000 ALTER TABLE `sales` DISABLE KEYS */;
INSERT INTO `sales` VALUES (224327,'4','110','131060',1,'2020-04-02',294,1542,125.00,125.00,52.00,0.00,0.00,6500.00,'1585817346','2020-04-02 08:49:06',15,0,'',NULL,'456','','0000-00-00 00:00:00','456','2020-04-02 08:56:22'),(224616,'4','110','131332',1,'2020-04-04',294,1542,125.00,125.00,32.00,0.00,0.00,4000.00,'1585996876','2020-04-04 10:41:16',15,0,'',NULL,'456','','0000-00-00 00:00:00','456','2020-04-04 10:46:37'),(224973,'4','110','131656',1,'2020-04-07',295,1542,210.00,210.00,100.00,1.00,210.00,20790.00,'1586252098','2020-04-07 09:34:58',15,0,'',NULL,'456','','0000-00-00 00:00:00','456','2020-04-07 09:36:01');
/*!40000 ALTER TABLE `sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_daily`
--

DROP TABLE IF EXISTS `sales_daily`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_daily` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `saledate` date NOT NULL,
  `average` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `target` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`average`,`saledate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_daily`
--

LOCK TABLES `sales_daily` WRITE;
/*!40000 ALTER TABLE `sales_daily` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_daily` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions`
--

DROP TABLE IF EXISTS `sales_distributions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions` (
  `distribution_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `sale_id` int NOT NULL,
  `purchase_id` varchar(20) NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `loadingdate` date NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `destination` varchar(50) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `truckno` varchar(20) NOT NULL,
  `drivername` varchar(50) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`distribution_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`loadingdate`,`quantity`,`destination`,`waybill`,`meterno`,`nozzle_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`tank_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `truckno` (`truckno`),
  KEY `purchase_id_2` (`purchase_id`)
) ENGINE=InnoDB AUTO_INCREMENT=168691 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions`
--

LOCK TABLES `sales_distributions` WRITE;
/*!40000 ALTER TABLE `sales_distributions` DISABLE KEYS */;
INSERT INTO `sales_distributions` VALUES (168158,'4',224327,'',0,'110',294,1542,'2020-04-02',52.00,'','','','712','1942','','','Dispensed on shift # 131060',5,'2020-04-02 08:56:22','456','0000-00-00 00:00:00','','2020-04-02 08:56:22','456'),(168398,'4',224616,'',0,'110',294,1542,'2020-04-04',32.00,'','','','710','1937','','','Dispensed on shift # 131332',5,'2020-04-04 10:46:37','456','0000-00-00 00:00:00','','2020-04-04 10:46:37','456'),(168690,'4',224973,'',0,'110',295,1542,'2020-04-07',100.00,'','','','714','2110','','','Dispensed on shift # 131656',5,'2020-04-07 09:36:01','456','0000-00-00 00:00:00','','2020-04-07 09:36:01','456');
/*!40000 ALTER TABLE `sales_distributions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_delivery`
--

DROP TABLE IF EXISTS `sales_distributions_delivery`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_delivery` (
  `delivery_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `distribution_id` int NOT NULL,
  `sale_id` int NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `quantity` int NOT NULL,
  `truck_id` int NOT NULL,
  `deliveredon` date NOT NULL,
  `details` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`delivery_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`quantity`,`thedate`,`createdby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`truck_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `distribution_id` (`distribution_id`),
  KEY `deliveredon` (`deliveredon`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_delivery`
--

LOCK TABLES `sales_distributions_delivery` WRITE;
/*!40000 ALTER TABLE `sales_distributions_delivery` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_delivery` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_trucks`
--

DROP TABLE IF EXISTS `sales_distributions_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_trucks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sale_id` varchar(20) NOT NULL,
  `distribution_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `bridge_id` varchar(20) NOT NULL,
  `truck_id` varchar(20) NOT NULL,
  `driver_id` varchar(20) NOT NULL,
  `quantity` int NOT NULL,
  `destination` varchar(150) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `companycode` (`company_id`,`distribution_id`,`truck_id`),
  KEY `sale_id` (`sale_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_trucks`
--

LOCK TABLES `sales_distributions_trucks` WRITE;
/*!40000 ALTER TABLE `sales_distributions_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_fueltickets`
--

DROP TABLE IF EXISTS `sales_fueltickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_fueltickets` (
  `ticket_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `ticketdate` date NOT NULL,
  `code` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `allowance` decimal(10,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `truck_number` varchar(20) NOT NULL,
  `truck_capacity` int NOT NULL,
  `truck_provider` varchar(50) NOT NULL,
  `truck_from` varchar(50) NOT NULL,
  `truck_destination` varchar(50) NOT NULL,
  `driver_name` varchar(50) NOT NULL,
  `driver_phone` varchar(50) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`ticket_id`),
  KEY `companycode` (`company_id`,`ticketdate`,`product_id`,`truck_number`,`rate`,`quantity`,`status`),
  KEY `paid` (`truck_provider`),
  KEY `invoice` (`code`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_fueltickets`
--

LOCK TABLES `sales_fueltickets` WRITE;
/*!40000 ALTER TABLE `sales_fueltickets` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_fueltickets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_payments`
--

DROP TABLE IF EXISTS `sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `customer_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`customer_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=85052 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_payments`
--

LOCK TABLES `sales_payments` WRITE;
/*!40000 ALTER TABLE `sales_payments` DISABLE KEYS */;
INSERT INTO `sales_payments` VALUES (85051,'4','110','2020-04-07',1542,'','','0',100000.00,'','ABUBAKAR ','ABBA BATAIYYA','','','','2020-04-07 09:20:31',5,'','456','','0000-00-00 00:00:00','456','2020-04-07 09:22:09');
/*!40000 ALTER TABLE `sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shifts_cashbacks`
--

DROP TABLE IF EXISTS `shifts_cashbacks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shifts_cashbacks` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `shift_id` bigint unsigned NOT NULL,
  `regno` varchar(100) DEFAULT NULL,
  `cashdate` date NOT NULL,
  `driver` varchar(100) DEFAULT NULL,
  `customer_id` bigint unsigned NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_at` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`cashdate`,`driver`,`customer_id`,`status`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`regno`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shifts_cashbacks`
--

LOCK TABLES `shifts_cashbacks` WRITE;
/*!40000 ALTER TABLE `shifts_cashbacks` DISABLE KEYS */;
/*!40000 ALTER TABLE `shifts_cashbacks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shifts_remittance`
--

DROP TABLE IF EXISTS `shifts_remittance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shifts_remittance` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `shift_id` bigint unsigned NOT NULL,
  `paymentdate` date NOT NULL,
  `method` int DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paidby` varchar(50) DEFAULT NULL,
  `paidto` varchar(100) DEFAULT NULL,
  `bank` bigint unsigned DEFAULT NULL,
  `depositor` varchar(100) DEFAULT NULL,
  `teller` varchar(100) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text,
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  `reversed_at` datetime DEFAULT NULL,
  `reversed_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`paymentdate`,`method`,`bank`,`status`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shifts_remittance`
--

LOCK TABLES `shifts_remittance` WRITE;
/*!40000 ALTER TABLE `shifts_remittance` DISABLE KEYS */;
/*!40000 ALTER TABLE `shifts_remittance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers`
--

DROP TABLE IF EXISTS `suppliers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers` (
  `supplier_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`supplier_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=120 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers`
--

LOCK TABLES `suppliers` WRITE;
/*!40000 ALTER TABLE `suppliers` DISABLE KEYS */;
INSERT INTO `suppliers` VALUES (119,'4','110','ALIKO OIL NIG. LIMITED','MALLAM JUNIADU','+2348065663347','juniadu@alikooil.com','KANO','KANO','ALIKO HOUSE TARAUNI ALONG MAIDUGURI ROAD KANO STATE.','Nigeria',0.00,0.00,'0000-00-00','2019-09-30 20:06:06',5,'456','2019-09-30 20:06:06','456');
/*!40000 ALTER TABLE `suppliers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers_status`
--

DROP TABLE IF EXISTS `suppliers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `supplier_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers_status`
--

LOCK TABLES `suppliers_status` WRITE;
/*!40000 ALTER TABLE `suppliers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `suppliers_status` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2023-03-21  2:56:19
