-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_22_station_242
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_22_station_242`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_22_station_242` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_22_station_242`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,500,'',0,'6.1','22','242','Cash Account','Cash Account','2022-03-22 10:56:08',5,0.00,0.00,'','793','2022-03-22 10:56:08','793',0,0),(2,2500,'',0,'20','22','242','Sales Account','Sales Account','2022-03-22 10:56:37',5,0.00,0.00,'','793','2022-03-22 11:28:20','793',0,0),(3,8000,'',0,'24','22','242','Purchase Account','Purchase Account','2022-03-22 10:57:13',5,0.00,0.00,'','793','2022-03-22 10:57:13','793',0,0),(4,8001,'',0,'24','22','242','Salary Account','Salary Account','2022-03-22 10:57:39',5,0.00,0.00,'','793','2022-03-22 10:57:39','793',0,0),(5,501,'',0,'24','22','242','DISCHARGE ACCOUNT','MONEY GIVING TO TANKER DRIVER AFTER DISCHAGE','2022-04-16 13:53:32',5,0.00,0.00,'','793','2022-04-16 13:59:21','793',0,0),(6,2500,'',0,'2','22','242','ZENITH','CHEQUE PAYMENT','2022-04-16 14:12:37',5,0.00,0.00,'','793','2022-04-16 14:12:37','793',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
INSERT INTO `attendants` VALUES ('22','242',1,'ALLI','SAHEED','','0804566234','','ORILE','LAGOS','LAGOS','Nigeria','','','','',0,5,'0000-00-00 00:00:00','2022-04-16 13:37:49','793','2022-04-22 14:46:20','793'),('22','242',2,'ALAMEEN','FATHIA','EWA','08157182887','info@doyingroup.com','44,COKER ROAD ,ORILE IGANMU LAGOS','LAGOS','LAGOS','Nigeria','ALAMEEN','','','',0,5,'0000-00-00 00:00:00','2022-04-22 14:37:19','793','2022-04-22 14:43:26','793'),('22','242',3,'ADEOSUN','SHUKURAT','','','info@doyingroup.com','13,OPELOYERU STREET,ORILE IGANMU LAGOS','LAGOS','LAGOS','Nigeria','ADEOSUN','','','',0,5,'0000-00-00 00:00:00','2022-04-22 17:14:25','793','2022-04-22 17:16:09','793'),('22','242',4,'TAIWO ','QUAM','AUSTIN','08107769716','doyininvestment@gmail.com','5,OYAPEJE CRESCENT SARI IGANMU LAGOS','LAGOS','LAGOS','Nigeria','AUSTIN','','','',0,5,'0000-00-00 00:00:00','2022-04-22 17:21:23','793','2022-04-22 17:21:23','793'),('22','242',5,'OKUNOLA','DAMILOLA','','070117665205','info@doyingroup.com','30,FAGBEMI STREET AMUKOKO ,LAGOS','LAGOS','LAGOS','Nigeria','','','','',0,5,'0000-00-00 00:00:00','2022-04-22 17:26:34','793','2022-04-22 17:32:54','793'),('22','242',6,'MURAINA','BUKOLA','AMINAT','09071351795','info@doyingroup.com','23,IBRAHIM STREET ALAPERE,KETU LAGOS','LAGOS','LAGOS','Nigeria','','','','',0,5,'0000-00-00 00:00:00','2022-04-22 17:26:40','793','2022-04-22 17:26:40','793'),('22','242',7,'MURAINA','KABIR','','09039692625','info@doyingroup.com','15,OLAITAN STREET,SARI IGANMU,LAGOS','LAGOS','LAGOS','Nigeria','','','','',0,5,'0000-00-00 00:00:00','2022-04-22 17:26:42','793','2022-04-22 17:30:08','793'),('22','242',8,'OLATUNMISE ','ARINOLA','','08090584668','info@doyingroup.com','3B EMOPERE STREET ,ORILE IGANUMU LAGOS','LAGOS','LAGOS','Nigeria','','','','',0,5,'0000-00-00 00:00:00','2022-04-22 17:26:44','793','2022-04-22 17:42:03','793'),('22','242',9,'ADEFILA','OLABAYO','','08059767981','info@doyingroup.com','6,RABIU OKE OLA,BADIA IJORA LAGOS','LAGOS','LAGOS','Nigeria','ADEFILA','','','',0,5,'0000-00-00 00:00:00','2022-04-22 17:26:47','793','2022-04-22 17:47:32','793'),('22','242',10,'ABIKOYE','DOLAPO','RACHAEL','07082574022','info@doyingroup.com','20, IMAM STREET, AMUKOKO','LAGOS','LAGOS','Nigeria','MRS KEMI ABIKOYE','08022959279','','',0,5,'0000-00-00 00:00:00','2022-04-22 17:26:50','793','2022-05-06 14:10:56','808'),('22','242',11,'BALOGUN','DAMILARE','','09036252391','','58,ISIKALU STREET OLODI,APAPA LAGOS','LAGOS','LAGOS','Nigeria','BALOGUN','','','',0,5,'0000-00-00 00:00:00','2022-04-22 18:08:13','793','2022-04-22 18:08:13','793'),('22','242',12,'LAWAL','YUSUF','','08120106841','','52,EZEAGU STREET OFF OJO ROAD,AJEGULE APAPA','LAGOS','LAGOS','Nigeria','LAWAL','','','',0,5,'0000-00-00 00:00:00','2022-04-22 18:15:28','793','2022-04-22 18:15:28','793'),('22','242',13,'BALOGUN','VICTORIA','','09057336621','','26,ALH AJALA STREET ORILE IGANMU','LAGOS','LAGOS','Nigeria','BALOGUN','','','',0,5,'0000-00-00 00:00:00','2022-04-22 18:18:26','793','2022-04-22 18:18:26','793'),('22','242',14,'INNOCENT','VIVIAN','','08154011979','','13,SADIKU STREET ORILE IGANMU LAGOS','LAGOS','LAGOS','Nigeria','INNOCENT','','','',0,5,'0000-00-00 00:00:00','2022-04-22 18:22:17','793','2022-04-22 18:22:17','793'),('22','242',15,'AYETOSHO','TEMITOPE','','09162961957','','13,OPELOYERU SREET IGANMU LAGOS','LAGOS','LAGOS','Nigeria','AYETOSHO','','','',0,5,'0000-00-00 00:00:00','2022-04-22 18:24:12','793','2022-04-22 18:24:12','793'),('22','242',16,'SEMIU ','BASIRAT','','08092894448','','2,RAMOTU STREET SARI IGANMU ,LAGOS','LAGOS','LAGOS','Nigeria','SEMIU','','','',0,5,'0000-00-00 00:00:00','2022-04-22 18:26:11','793','2022-04-22 18:26:11','793');
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1,'','22','242','BENI GOLD V.I','MR DOTUN','08032249472','info@doyingroup.com','LAGOS','LAGOS','23,ademola adedoyin street,victoria island,lagos','Nigeria',10000000.00,0.00,0.00,'0000-00-00','2022-04-12 13:03:04',5,'793','2022-04-20 18:03:26','793'),(2,'','22','242','HEAD OFFICE','MR ALAYANDE','08029038724','doyininvestment@gmail.com','LAGOS','LAGOS','4,abagbon close,adeola odeku,victoria island lagos','Nigeria',1000000.00,0.00,0.00,'0000-00-00','2022-04-12 13:07:53',5,'793','2022-04-12 13:07:53','793'),(3,'','22','242','BENI MARINA','MRS  TITI','08068233773','doyininvestment@gmail.com','LAGOS','LAGOS','MARINA,LAGOS STATE','Nigeria',10000000.00,0.00,0.00,'0000-00-00','2022-04-20 17:47:28',5,'793','2022-04-20 17:47:28','793'),(4,'','22','242','BENI APARTMENT','MR KUNLE',' 08137644930','info@doyingroup.com','LAGOS','LAGOS','V.I,TOWARDS LAGOS,LAGOS STATE','Nigeria',10000000.00,0.00,0.00,'0000-00-00','2022-04-20 18:01:43',5,'793','2022-04-20 18:01:43','793'),(5,'','22','242','BENI IKOYI','MRS','08023726995','info@doyingroup.com','LAGOS','LAGOS','AGODOGBA,LAGOS LAGOS-STATE','Nigeria',10000000.00,0.00,0.00,'0000-00-00','2022-04-20 18:11:20',5,'793','2022-04-20 18:11:20','793'),(6,'','22','242','BENIGOLD APAPA','MR BAYO','08096796240','info@doyingroup.com','LAGOS','LAGOS','APAPA LAGOS ,LAGOS STATE','Nigeria',10000000.00,0.00,0.00,'0000-00-00','2022-04-20 18:40:29',5,'793','2022-04-20 18:40:29','793'),(7,'','22','242','STARCO FACTORY  OKOKO','MR AMUSU','08023827711','doyininvestment@gmail.com','LAGOS','LAGOS','OKOKO LAGOS,LAGOS-STATE','Nigeria',5000000.00,0.00,0.00,'0000-00-00','2022-04-20 18:54:34',5,'793','2022-04-20 18:54:34','793'),(8,'','22','242','DOYIN SALES','MR PRINCE OMOOBA','08028747557','doyininvestment@gmail.com','LAGOS','LAGOS','DOYIN COMPLEX,ORILE LAGOS','Nigeria',5000000.00,0.00,0.00,'0000-00-00','2022-04-20 18:57:16',5,'793','2022-04-20 18:57:16','793');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('22','242',1,'3',27000.00,42400.00,'2022-05-06','OK','2022-05-06 15:22:22','808','808',2022,'808','2022-05-06 15:22:22',5),('22','242',2,'4',13000.00,23800.00,'2022-05-06','OK','2022-05-06 15:23:30','808','808',2022,'808','2022-05-06 15:23:30',5),('22','242',3,'1',0.00,26800.00,'2022-05-06','OK','2022-05-06 15:24:29','808','808',2022,'808','2022-05-06 15:24:29',5),('22','242',4,'2',0.00,15200.00,'2022-05-06','','2022-05-06 15:29:32','808','808',2022,'808','2022-05-06 15:29:32',5),('22','242',5,'3',40010.35,39500.00,'2022-05-07','OK','2022-05-07 12:05:26','808','808',2022,'808','2022-05-07 12:05:26',5),('22','242',6,'4',22190.00,22100.00,'2022-05-07','','2022-05-07 12:06:04','808','808',2022,'808','2022-05-07 12:06:04',5),('22','242',7,'1',21413.92,21650.00,'2022-05-07','OK','2022-05-07 12:06:54','808','808',2022,'808','2022-05-07 12:06:54',5),('22','242',8,'2',24995.37,11600.00,'2022-05-07','OK','2022-05-07 12:09:01','808','808',2022,'808','2022-05-07 12:09:01',5),('22','242',9,'3',36731.67,37400.00,'2022-05-08','OPENING','2022-05-09 08:47:46','808','808',2022,'808','2022-05-09 08:47:46',5),('22','242',10,'4',20838.56,21100.00,'2022-05-08','OPENING','2022-05-09 08:49:33','808','808',2022,'808','2022-05-09 08:49:33',5),('22','242',11,'1',8757.30,13700.00,'2022-05-08','OPENING','2022-05-09 08:53:00','808','808',2022,'808','2022-05-09 08:53:00',5),('22','242',12,'2',6904.66,8200.00,'2022-05-09','OPENING','2022-05-09 08:53:30','808','808',2022,'808','2022-05-09 08:53:30',5),('22','242',13,'3',37400.00,36800.00,'2022-05-09','OPENING','2022-05-09 08:54:27','808','808',2022,'808','2022-05-09 08:54:27',5),('22','242',14,'4',21100.00,20900.00,'2022-05-09','OPENING','2022-05-09 08:54:55','808','808',2022,'808','2022-05-09 08:54:55',5),('22','242',15,'1',13700.00,9800.00,'2022-05-09','OPENING','2022-05-09 08:55:18','808','808',2022,'808','2022-05-09 08:55:18',5),('22','242',16,'2',8200.00,7000.00,'2022-05-09','OPENING','2022-05-09 08:55:46','808','808',2022,'808','2022-05-09 08:55:46',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('22','242','3',4,'5','NOZZLE 1',886196.71,'AGO 1','1',NULL,NULL,'',5,'2022-05-06 13:16:39','808'),('22','242','3',5,'5','NOZZLE 2',1212372.81,'AGO 2','1',NULL,NULL,'',5,'2022-05-06 13:30:46','808'),('22','242','4',6,'5','NOZZLE 3',1100414.82,'AGO 3','2',NULL,NULL,'',5,'2022-05-06 13:33:28','808'),('22','242','1',7,'5','NOZZLE 4',787733.19,'PMS 1','3',NULL,NULL,'',5,'2022-05-06 13:36:50','808'),('22','242','1',8,'5','NOZZLE 5',861953.50,'PMS 2','3',NULL,NULL,'',5,'2022-05-06 13:39:59','808'),('22','242','1',9,'5','NOZZLE 6',840638.51,'PMS 3','4',NULL,NULL,'',5,'2022-05-06 13:41:40','808'),('22','242','1',10,'5','NOZZLE 7',729446.38,'PMS 4','4',NULL,NULL,'',5,'2022-05-06 13:43:00','808'),('22','242','2',11,'5','NOZZEL 8',1015208.33,'PMS 5','5',NULL,NULL,'NOZZLE 8',5,'2022-05-06 13:44:10','808'),('22','242','1',12,'5','NOZZLE 9',822475.00,'PMS 6','6',NULL,NULL,'NOZZLE 9',5,'2022-05-06 13:46:19','808'),('22','242','2',13,'5','NOZZLE 10',586276.93,'PMS 7','7',NULL,NULL,'NOZZLE 10',5,'2022-05-06 13:49:15','808'),('22','242','2',14,'5','NOZZLE 11',15924.28,'PMS 8','7',NULL,NULL,'NOZZLE 11',5,'2022-05-07 11:46:18','808'),('22','242','2',15,'5','NOZZLE 12',521653.42,'PMS 9','8',NULL,NULL,'NOZZLE 12',5,'2022-05-06 13:52:00','808'),('22','242','2',16,'5','NOZZLE 13',338282.95,'13','8',NULL,NULL,'NOZZEL 13',5,'2022-05-06 13:53:33','808');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
INSERT INTO `depots_nozzles_tanks` VALUES (1,'22','242','1','3','CORRECT TANK','2022-04-12 13:25:12',0,'793');
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
INSERT INTO `depots_pumps` VALUES ('22','242',1,'CLEANTECH','STARCO','PUMP 1','','','','793','2022-03-26 14:22:27','2022-03-26 14:22:27','793',5),('22','242',2,'CLEANTECH','STARCO','PUMP 2','','','','793','2022-03-26 14:22:59','2022-03-26 14:22:59','793',5),('22','242',3,'CLEANTECH','STARCO','PUMP 3','','','','793','2022-03-26 14:23:26','2022-03-26 14:23:26','793',5),('22','242',4,'CLEANTECH','STARCO','PUMP 4','','','','793','2022-03-26 14:23:51','2022-03-26 14:23:51','793',5),('22','242',5,'CLEANTECH','STARCO','PUMP 5','','','','793','2022-03-26 14:24:12','2022-03-26 14:24:12','793',5),('22','242',6,'CLEANTECH','STARCO','PUMP 6','','','','793','2022-03-26 14:24:35','2022-03-26 14:24:35','793',5),('22','242',7,'CLEANTECH','STARCO','PUMP 7','','','','793','2022-04-12 13:17:11','2022-04-12 13:17:11','793',5),('22','242',8,'CLEANTECH','STARCO','PUMP 8','','','','793','2022-04-12 13:17:37','2022-04-12 13:17:37','793',5);
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=183 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('22','242',3,'OMOLADE AHMED ','2022-05-06','2022-05-06 14:33:15','2022-05-07 14:33:15','808',0.00,0.00,'808','2022-05-06 14:35:33','808','2022-05-06 14:36:37',10,0),('22','242',5,'BALLO','2022-05-06','2022-05-06 15:12:13','2022-05-07 15:12:13','808',3845206.33,4099739.65,'808','2022-05-07 11:37:56','808','2022-05-07 11:40:05',10,0),('22','242',6,'MR. RAPHAEL','2022-05-07','2022-05-07 11:47:42','2022-05-08 11:47:42','808',3749870.54,4034841.70,'808','2022-05-08 09:57:14','808','2022-05-08 10:03:13',10,0),('22','242',7,'MR. AHMED ','2022-05-08','2022-05-08 10:21:20','2022-05-09 10:21:20','808',1371765.63,1486535.40,'808','2022-05-08 18:47:16','808','2022-05-08 18:47:56',10,0),('22','242',8,'MR. RAPHAEL','2022-05-09','2022-05-09 08:36:43','2022-05-10 08:36:43','808',4704927.60,5027621.50,'808','2022-05-10 11:22:40','808','2022-05-10 11:23:57',10,0),('22','242',9,'MR. AHMED ','2022-05-10','2022-05-10 11:24:41','2022-05-11 11:24:41','808',3859313.47,1472730.60,'808','2022-05-11 07:45:37','808','2022-05-12 20:19:37',10,0),('22','242',10,'MR. AHMED ','2022-05-11','2022-05-12 20:22:31','2022-05-13 20:22:31','808',3852611.80,4128475.50,'808','2022-05-12 20:47:54','808','2022-05-12 21:03:19',10,0),('22','242',11,'BALLO','2022-05-12','2022-05-12 21:39:43','2022-05-13 21:39:43','808',5336246.63,5669255.90,'808','2022-05-12 21:54:32','808','2022-05-12 22:07:02',10,0),('22','242',12,'MR. RAPHAEL','2022-05-13','2022-05-13 08:51:29','2022-05-14 08:51:29','808',3996297.70,1774764.75,'808','2022-05-13 21:59:12','808','2022-05-13 22:00:54',10,0),('22','242',13,'MR. AHMED ','2022-05-14','2022-05-15 10:07:41','2022-05-16 10:07:41','808',4190966.24,1700800.20,'808','2022-05-15 10:16:27','808','2022-05-15 10:18:55',10,0),('22','242',14,'MR. RAPHAEL','2022-05-15','2022-05-15 10:19:53','2022-05-16 10:19:53','808',1097711.01,832279.80,'808','2022-05-16 17:32:29','808','2022-05-16 17:34:04',10,0),('22','242',15,'MR. AHMED ','2022-05-16','2022-05-16 17:35:46','2022-05-17 17:35:46','808',3945969.58,1904670.90,'808','2022-05-16 21:49:39','808','2022-05-16 21:51:39',10,0),('22','242',16,'MR. RAPHAEL','2022-05-17','2022-05-17 17:06:02','2022-05-18 17:06:02','808',3452718.88,1701778.65,'808','2022-05-17 22:12:36','808','2022-05-17 22:13:48',10,0),('22','242',17,'MR. AHMED ','2022-05-18','2022-05-18 13:50:52','2022-05-19 13:50:52','808',4653770.58,5030885.20,'808','2022-05-19 15:26:26','808','2022-05-19 15:27:14',10,0),('22','242',18,'MR. RAPHAEL','2022-05-19','2022-05-19 15:29:40','2022-05-20 15:29:40','808',4398836.50,4759409.80,'808','2022-05-20 16:08:56','808','2022-05-20 16:10:17',10,0),('22','242',19,'MR AHMED','2022-05-20','2022-05-20 22:05:12','2022-05-21 22:05:12','808',5510832.52,2113245.75,'808','2022-05-20 22:11:55','808','2022-05-20 22:12:38',10,0),('22','242',20,'MR. RAPHAEL','2022-05-21','2022-05-21 07:40:26','2022-05-22 07:40:26','808',3850007.00,4131851.85,'808','2022-05-22 08:50:32','808','2022-05-22 08:53:08',10,0),('22','242',21,'MR. AHMED','2022-05-22','2022-05-22 08:55:18','2022-05-23 08:55:18','808',1819786.64,1951940.50,'808','2022-05-23 09:39:59','808','2022-05-23 09:40:23',10,0),('22','242',22,'MR. RAPHAEL','2022-05-23','2022-05-23 09:41:15','2022-05-24 09:41:15','808',4075483.72,4381232.75,'808','2022-05-24 10:02:33','808','2022-05-24 10:02:52',10,0),('22','242',23,'MR. AHMED','2022-05-24','2022-05-24 10:03:35','2022-05-25 10:03:35','808',5872387.88,6260500.85,'808','2022-05-25 12:30:00','808','2022-05-25 12:30:22',10,0),('22','242',24,'MR. RAPHAEL','2022-05-25','2022-05-25 12:30:59','2022-05-26 12:30:59','808',3912111.60,4210360.30,'808','2022-05-26 16:17:57','808','2022-05-26 16:29:48',10,0),('22','242',25,'MR. AHMED ','2022-05-26','2022-05-27 22:02:11','2022-05-28 22:02:11','808',3526677.96,1581638.85,'808','2022-05-27 22:05:40','808','2022-05-27 22:06:13',10,0),('22','242',26,'MR. RAPHAEL','2022-05-27','2022-05-27 22:06:49','2022-05-28 22:06:49','808',4839027.68,5190928.70,'808','2022-05-27 22:15:15','808','2022-05-27 22:15:40',10,0),('22','242',27,'MR. AHMED ','2022-05-28','2022-05-28 14:38:01','2022-05-29 14:38:01','808',3179344.42,3487435.35,'808','2022-05-28 20:37:38','808','2022-05-28 20:37:58',10,0),('22','242',28,'MR. RAPHAEL','2022-05-29','2022-05-29 09:34:31','2022-05-30 09:34:31','808',1003054.28,1108071.75,'808','2022-05-29 18:16:40','808','2022-05-29 18:17:01',10,0),('22','242',29,'MR. AHMED','2022-05-30','2022-05-30 09:04:20','2022-05-31 09:04:20','808',3939396.84,4320853.20,'808','2022-05-31 08:47:20','808','2022-05-31 08:47:54',10,0),('22','242',30,'MR. RAPHAEL','2022-05-31','2022-05-31 08:48:47','2022-06-01 08:48:47','808',3781042.92,4143252.85,'808','2022-06-01 11:11:39','808','2022-06-01 11:11:54',10,0),('22','242',31,'MR. AHMED','2022-06-01','2022-06-01 11:23:26','2022-06-02 11:23:26','808',4876044.80,5324795.25,'808','2022-06-02 08:38:51','808','2022-06-02 08:39:12',10,0),('22','242',32,'MR. RAPHAEL','2022-06-02','2022-06-02 08:39:52','2022-06-03 08:39:52','808',3262250.52,3579993.35,'808','2022-06-03 08:17:13','808','2022-06-03 08:17:30',10,0),('22','242',33,'MR. AHMED','2022-06-03','2022-06-03 08:18:10','2022-06-04 08:18:10','808',4600055.62,5028631.35,'808','2022-06-04 11:05:39','808','2022-06-04 11:06:02',10,0),('22','242',34,'MR. RAPHAEL','2022-06-04','2022-06-04 11:06:34','2022-06-05 11:06:34','808',5133195.76,5607399.80,'808','2022-06-04 21:36:07','808','2022-06-04 21:37:09',10,0),('22','242',35,'MR. AHMED','2022-06-05','2022-06-05 08:59:04','2022-06-06 08:59:04','808',1672602.78,1834123.15,'808','2022-06-05 18:31:05','808','2022-06-05 18:31:43',10,0),('22','242',36,'MR. RAPHAEL','2022-06-06','2022-06-06 13:15:33','2022-06-07 13:15:33','808',6581862.34,7176453.20,'808','2022-06-06 21:51:19','808','2022-06-06 21:51:42',10,0),('22','242',37,'MR. AHMED','2022-06-07','2022-06-07 08:28:39','2022-06-08 08:28:39','808',5580793.60,6239705.25,'808','2022-06-07 22:05:47','808','2022-06-07 22:07:53',10,0),('22','242',38,'MR. RAPHAEL','2022-06-08','2022-06-08 09:45:22','2022-06-09 09:45:22','808',7832785.90,8760929.25,'808','2022-06-08 21:51:05','808','2022-06-08 21:51:28',10,0),('22','242',39,'MR. AHMED','2022-06-09','2022-06-09 22:26:34','2022-06-10 22:26:34','808',5618039.28,6281796.15,'808','2022-06-09 22:32:15','808','2022-06-09 22:32:38',10,0),('22','242',40,'MR. RAPHAEL','2022-06-10','2022-06-10 08:45:59','2022-06-11 08:45:59','808',5127407.68,5870628.90,'808','2022-06-11 10:31:32','808','2022-06-11 10:31:48',10,0),('22','242',41,'MR. AHMED','2022-06-11','2022-06-11 10:32:35','2022-06-12 10:32:35','808',5955019.76,6328461.30,'808','2022-06-11 21:17:01','808','2022-06-11 21:17:40',10,0),('22','242',42,'MR. AHMED','2022-06-13','2022-06-13 08:23:02','2022-06-14 08:23:02','808',1198151.76,1313424.80,'808','2022-06-14 15:17:19','808','2022-06-14 15:17:36',10,0),('22','242',43,'MR. RAPHAEL','2022-06-14','2022-06-14 15:18:47','2022-06-15 15:18:47','808',5175860.44,5644162.95,'808','2022-06-14 15:24:01','808','2022-06-14 15:24:22',10,0),('22','242',44,'MR. RAPHAEL','2022-06-14','2022-06-14 15:25:01','2022-06-15 15:25:01','808',5522618.52,6021970.35,'808','2022-06-15 09:38:20','808','2022-06-15 09:38:42',10,0),('22','242',45,'MR. AHMED','2022-06-15','2022-06-15 09:39:18','2022-06-16 09:39:18','808',3420029.88,3703577.15,'808','2022-06-16 11:23:54','808','2022-06-16 11:24:26',10,0),('22','242',46,'MR. RAPHAEL','2022-06-16','2022-06-16 11:25:00','2022-06-17 11:25:00','808',4569135.92,4987853.85,'808','2022-06-18 11:03:30','808','2022-06-18 11:04:09',10,0),('22','242',47,'MR. AHMED','2022-06-18','2022-06-18 11:04:45','2022-06-19 11:04:45','808',4950317.32,5403996.60,'808','2022-06-18 11:09:35','808','2022-06-18 11:09:50',10,0),('22','242',48,'MR. RAPHAEL','2022-06-18','2022-06-18 11:10:19','2022-06-19 11:10:19','808',3923315.72,4290003.35,'808','2022-06-18 21:26:28','808','2022-06-18 21:26:43',10,0),('22','242',49,'MR. AHMED','2022-06-20','2022-06-20 11:05:32','2022-06-21 11:05:32','808',1303764.24,1426715.20,'808','2022-06-20 11:08:20','808','2022-06-20 11:08:35',10,0),('22','242',50,'MR. RAPHAEL','2022-06-20','2022-06-20 11:09:07','2022-06-21 11:09:07','808',8243077.00,8948271.25,'808','2022-06-20 21:50:06','808','2022-06-20 21:50:24',10,0),('22','242',51,'MR. AHMED','2022-06-21','2022-06-21 21:30:57','2022-06-22 21:30:57','808',6311660.72,6878005.60,'808','2022-06-21 21:35:01','808','2022-06-21 21:35:44',10,0),('22','242',52,'MR. RAPHAEL','2022-06-22','2022-06-22 21:30:38','2022-06-23 21:30:38','808',3539469.48,3729704.15,'808','2022-06-22 21:32:26','808','2022-06-22 21:32:44',10,0),('22','242',53,'MR. AHMED','2022-06-23','2022-06-23 18:37:17','2022-06-24 18:37:17','808',3771835.12,4146933.20,'808','2022-06-25 11:56:46','808','2022-06-25 11:57:16',10,0),('22','242',54,'MR. RAPHAEL','2022-06-25','2022-06-25 11:59:29','2022-06-26 11:59:29','808',0.00,0.00,'808','2022-06-25 12:02:10','808','2022-06-25 12:02:24',10,0),('22','242',55,'MR. RAPHAEL','2022-06-24','2022-06-25 12:03:10','2022-06-26 12:03:10','808',3256940.12,3484323.85,'808','2022-06-25 12:10:05','808','2022-06-25 12:10:24',10,0),('22','242',56,'MR. AHMED','2022-06-25','2022-06-25 12:15:07','2022-06-26 12:15:07','808',3814985.60,4112885.50,'808','2022-06-26 06:33:00','808','2022-06-26 06:33:21',10,0),('22','242',57,'MR. RAPHAEL','2022-06-26','2022-06-26 06:33:50','2022-06-27 06:33:50','808',1178257.32,1291842.35,'808','2022-06-26 18:43:27','808','2022-06-26 18:43:42',10,0),('22','242',58,'MR. AHMED','2022-06-27','2022-06-27 12:39:15','2022-06-28 12:39:15','808',4680996.44,5037947.45,'808','2022-06-27 21:35:07','808','2022-06-27 21:35:23',10,0),('22','242',59,'MR. RAPHAEL','2022-06-28','2022-06-28 09:00:56','2022-06-29 09:00:56','808',3804589.84,4119853.20,'808','2022-06-28 20:58:01','808','2022-06-28 20:58:23',10,0),('22','242',60,'MR. AHMED','2022-06-29','2022-06-29 10:45:45','2022-06-30 10:45:45','808',6278478.72,6726213.10,'808','2022-06-29 21:42:31','808','2022-06-29 21:42:51',10,0),('22','242',61,'MR. RAPHAEL','2022-06-30','2022-06-30 08:22:12','2022-07-01 08:22:12','808',3917125.80,4227602.75,'808','2022-07-01 13:08:01','808','2022-07-01 13:08:14',10,0),('22','242',62,'MR. AHMED','2022-07-01','2022-07-01 13:08:41','2022-07-02 13:08:41','808',3742156.08,4058255.90,'808','2022-07-02 09:35:27','808','2022-07-02 09:35:54',10,0),('22','242',63,'MR. RAPHAEL','2022-07-02','2022-07-02 09:36:25','2022-07-03 09:36:25','808',5253118.80,5692736.50,'808','2022-07-02 21:50:45','808','2022-07-02 21:51:00',10,0),('22','242',64,'MR. AHMED','2022-07-03','2022-07-03 07:45:36','2022-07-04 07:45:36','808',2606969.64,2831368.45,'808','2022-07-04 08:12:08','808','2022-07-04 08:12:27',10,0),('22','242',65,'MR. RAPHAEL','2022-07-04','2022-07-04 08:14:47','2022-07-05 08:14:47','808',6757937.64,7546031.10,'808','2022-07-04 21:41:57','808','2022-07-04 21:42:19',10,0),('22','242',66,'MR. AHMED','2022-07-05','2022-07-05 18:54:55','2022-07-06 18:54:55','808',3620485.92,3987405.20,'808','2022-07-05 19:57:28','808','2022-07-05 19:57:45',10,0),('22','242',67,'MR. RAPHAEL','2022-07-06','2022-07-06 10:16:08','2022-07-07 10:16:08','808',4035371.04,4457700.30,'808','2022-07-06 21:04:53','808','2022-07-06 21:05:09',10,0),('22','242',68,'MR. AHMED','2022-07-07','2022-07-07 09:52:41','2022-07-08 09:52:41','808',3934026.80,4378670.50,'808','2022-07-10 17:53:16','808','2022-07-10 17:53:34',10,0),('22','242',69,'MR. RAPHAEL','2022-07-08','2022-07-10 17:55:04','2022-07-11 17:55:04','808',3566506.88,3804777.10,'808','2022-07-10 17:58:03','808','2022-07-10 17:58:24',10,0),('22','242',70,'MR. AHMED','2022-07-09','2022-07-10 17:59:25','2022-07-11 17:59:25','808',2317468.60,2445041.75,'808','2022-07-10 18:01:08','808','2022-07-10 18:02:20',10,0),('22','242',71,'MR. RAPHAEL','2022-07-10','2022-07-10 18:03:05','2022-07-11 18:03:05','808',1415228.44,1490398.55,'808','2022-07-10 18:38:28','808','2022-07-10 18:38:53',10,0),('22','242',72,'MR. AHMED','2022-07-11','2022-07-11 07:29:30','2022-07-12 07:29:30','808',3019591.04,3567571.30,'808','2022-07-13 07:47:44','808','2022-07-13 07:47:59',10,0),('22','242',73,'MR. RAPHAEL','2022-07-12','2022-07-13 07:49:27','2022-07-14 07:49:27','808',3751453.80,4287818.25,'808','2022-07-13 07:53:18','808','2022-07-13 07:53:32',10,0),('22','242',74,'MR. AHMED','2022-07-13','2022-07-13 07:56:45','2022-07-14 07:56:45','808',3992420.88,4607846.10,'808','2022-07-15 18:26:44','808','2022-07-15 18:27:24',10,0),('22','242',75,'MR. RAPHAEL','2022-07-14','2022-07-15 18:30:04','2022-07-16 18:30:04','808',3242877.48,3591643.35,'808','2022-07-15 18:33:40','808','2022-07-15 18:34:06',10,0),('22','242',76,'MR. AHMED','2022-07-15','2022-07-15 18:34:53','2022-07-16 18:34:53','808',4109836.00,4456962.50,'808','2022-07-15 21:08:00','808','2022-07-15 21:08:49',10,0),('22','242',77,'MR. RAPHAEL','2022-07-16','2022-07-16 15:48:32','2022-07-17 15:48:32','808',3626788.60,4031623.25,'808','2022-07-17 07:59:33','808','2022-07-17 08:00:56',10,0),('22','242',78,'MR. AHMED','2022-07-17','2022-07-17 08:02:06','2022-07-18 08:02:06','808',1688398.00,1911368.00,'808','2022-07-17 18:53:48','808','2022-07-17 18:54:05',10,0),('22','242',79,'MR. RAPHAEL','2022-07-18','2022-07-18 10:19:06','2022-07-19 10:19:06','808',3255553.80,3609197.25,'808','2022-07-18 21:57:26','808','2022-07-18 21:57:40',10,0),('22','242',80,'MR. AHMED','2022-07-19','2022-07-19 11:14:42','2022-07-20 11:14:42','808',2657284.12,2996172.65,'808','2022-07-20 12:17:12','808','2022-07-20 12:17:28',10,0),('22','242',81,'MR. RAPHAEL','2022-07-20','2022-07-20 12:17:59','2022-07-21 12:17:59','808',4915683.60,5408088.00,'808','2022-07-21 08:15:22','808','2022-07-21 08:15:38',10,0),('22','242',82,'MR. AHMED','2022-07-21','2022-07-21 08:16:10','2022-07-22 08:16:10','808',3452994.00,3816975.00,'808','2022-07-23 11:46:56','808','2022-07-23 11:47:11',10,0),('22','242',83,'MR. RAPHAEL','2022-07-22','2022-07-23 11:49:10','2022-07-24 11:49:10','808',2818881.08,3140780.35,'808','2022-07-23 11:52:02','808','2022-07-23 11:52:17',10,0),('22','242',84,'MR. AHMED','2022-07-23','2022-07-23 11:52:47','2022-07-24 11:52:47','808',2913444.36,3207945.45,'808','2022-07-23 21:30:01','808','2022-07-23 21:30:19',10,0),('22','242',85,'MR. RAPHAEL','2022-07-24','2022-07-24 11:33:50','2022-07-25 11:33:50','808',748844.40,863118.00,'808','2022-07-25 11:54:54','808','2022-07-25 11:55:17',10,0),('22','242',86,'MR. AHMED','2022-07-25','2022-07-25 11:55:57','2022-07-26 11:55:57','808',4060308.12,4455201.15,'808','2022-07-26 10:05:28','808','2022-07-26 10:05:43',10,0),('22','242',87,'MR. RAPHAEL','2022-07-26','2022-07-26 10:08:14','2022-07-27 10:08:14','808',3191740.92,3534879.15,'808','2022-07-27 11:47:18','808','2022-07-27 11:47:40',10,0),('22','242',88,'MR. AHMED','2022-07-27','2022-07-27 11:48:45','2022-07-28 11:48:45','808',2654048.20,2946311.75,'808','2022-07-28 14:32:40','808','2022-07-28 14:33:36',10,0),('22','242',89,'MR. RAPHAEL','2022-07-28','2022-07-28 14:34:13','2022-07-29 14:34:13','808',2733300.88,2988462.20,'808','2022-07-29 12:26:08','808','2022-07-29 12:26:20',10,0),('22','242',90,'MR. AHMED','2022-07-29','2022-07-29 12:26:58','2022-07-30 12:26:58','808',3352512.88,3654594.20,'808','2022-07-30 09:19:38','808','2022-07-30 09:20:09',10,0),('22','242',91,'MR. RAPHAEL','2022-07-30','2022-07-30 09:21:13','2022-07-31 09:21:13','808',3337476.92,3698140.30,'808','2022-07-31 09:17:55','808','2022-07-31 09:18:15',10,0),('22','242',92,'MR. AHMED','2022-07-31','2022-07-31 09:18:49','2022-08-01 09:18:49','808',1230660.32,1371809.80,'808','2022-08-01 13:08:23','808','2022-08-01 13:08:42',10,0),('22','242',93,'MR. RAPHAEL','2022-08-01','2022-08-01 13:09:25','2022-08-02 13:09:25','808',3229351.56,3538143.90,'808','2022-08-01 21:24:34','808','2022-08-01 21:24:50',10,0),('22','242',94,'MR. AHMED','2022-08-02','2022-08-03 09:35:05','2022-08-04 09:35:05','808',3204953.96,3515572.90,'808','2022-08-03 09:38:03','808','2022-08-03 09:38:20',10,0),('22','242',95,'MR. RAPHAEL','2022-08-03','2022-08-03 09:39:01','2022-08-04 09:39:01','808',3995228.52,4354080.30,'808','2022-08-04 10:39:16','808','2022-08-04 10:39:40',10,0),('22','242',96,'MR. AHMED','2022-08-04','2022-08-04 10:40:30','2022-08-05 10:40:30','808',2544382.48,2823855.20,'808','2022-08-06 07:50:41','808','2022-08-06 07:50:58',10,0),('22','242',97,'MR. RAPHAEL','2022-08-05','2022-08-06 07:51:41','2022-08-07 07:51:41','808',2956084.40,3235558.00,'808','2022-08-06 07:55:54','808','2022-08-06 07:56:09',10,0),('22','242',98,'MR. AHMED','2022-08-06','2022-08-06 07:56:52','2022-08-07 07:56:52','808',2284376.48,2543648.00,'808','2022-08-07 07:35:58','808','2022-08-07 07:36:22',10,0),('22','242',99,'MR. RAPHAEL','2022-08-07','2022-08-07 07:36:49','2022-08-08 07:36:49','808',1651727.76,1838481.00,'808','2022-08-13 11:02:58','808','2022-08-13 11:03:12',10,0),('22','242',100,'MR. AHMED','2022-08-08','2022-08-13 11:04:08','2022-08-14 11:04:08','808',2323030.00,2555859.00,'808','2022-08-13 11:07:34','808','2022-08-13 11:07:57',10,0),('22','242',101,'MR. RAPHAEL','2022-08-09','2022-08-13 11:18:28','2022-08-14 11:18:28','808',1268250.80,1335289.00,'808','2022-08-13 11:20:03','808','2022-08-13 11:20:14',10,0),('22','242',102,'MR. AHMED','2022-08-10','2022-08-13 11:21:34','2022-08-14 11:21:34','808',1415543.36,1491129.50,'808','2022-08-13 11:23:57','808','2022-08-13 11:24:11',10,0),('22','242',103,'MR. RAPHAEL','2022-08-11','2022-08-13 11:24:57','2022-08-14 11:24:57','808',2384775.80,2511593.75,'808','2022-08-13 11:26:19','808','2022-08-13 11:26:33',10,0),('22','242',104,'MR. AHMED','2022-08-12','2022-08-13 11:28:26','2022-08-14 11:28:26','808',0.00,0.00,'808','2022-08-13 11:30:26','808','2022-08-13 11:30:43',10,0),('22','242',105,'MR. AHMED','2022-08-12','2022-08-13 11:31:27','2022-08-14 11:31:27','808',2381936.16,2589445.60,'808','2022-08-13 11:36:17','808','2022-08-13 11:36:34',10,0),('22','242',106,'MR. RAPHAEL','2022-08-13','2022-08-13 11:37:09','2022-08-14 11:37:09','808',2306415.52,2555735.20,'808','2022-08-13 22:01:10','808','2022-08-13 22:01:49',10,0),('22','242',107,'MR. AHMED','2022-08-14','2022-08-14 08:56:04','2022-08-15 08:56:04','808',1543654.40,1735234.00,'808','2022-08-15 09:19:36','808','2022-08-15 09:19:50',10,0),('22','242',108,'MR. RAPHAEL','2022-08-15','2022-08-15 09:20:24','2022-08-16 09:20:24','808',2873908.72,3215419.20,'808','2022-08-16 10:54:21','808','2022-08-16 10:54:43',10,0),('22','242',109,'MR. AHMED','2022-08-16','2022-08-16 10:55:14','2022-08-17 10:55:14','808',3261458.96,3609343.60,'808','2022-08-17 10:12:23','808','2022-08-17 10:12:41',10,0),('22','242',110,'MR. RAPHAEL','2022-08-17','2022-08-17 10:13:33','2022-08-18 10:13:33','808',3024034.40,3329968.00,'808','2022-08-18 15:45:50','808','2022-08-18 15:46:03',10,0),('22','242',111,'MR. AHMED','2022-08-18','2022-08-18 15:46:34','2022-08-19 15:46:34','808',1920399.56,2150514.60,'808','2022-08-23 13:15:21','808','2022-08-23 13:15:36',10,0),('22','242',112,'MR. RAPHAEL','2022-08-19','2022-08-23 13:17:18','2022-08-24 13:17:18','808',2310837.24,2547371.40,'808','2022-08-23 13:20:52','808','2022-08-23 13:21:05',10,0),('22','242',113,'MR. AHMED','2022-08-20','2022-08-23 13:21:46','2022-08-24 13:21:46','808',819256.32,864809.20,'808','2022-08-23 13:23:05','808','2022-08-23 13:23:20',10,0),('22','242',114,'MR. RAPHAEL','2022-08-21','2022-08-23 13:24:08','2022-08-24 13:24:08','808',281102.80,296624.00,'808','2022-08-23 13:25:33','808','2022-08-23 13:25:49',10,0),('22','242',115,'MR. AHMED','2022-08-22','2022-08-23 13:26:29','2022-08-24 13:26:29','808',1590117.52,1746157.20,'808','2022-08-23 13:29:06','808','2022-08-23 13:29:19',10,0),('22','242',116,'MR. RAPHAEL','2022-08-23','2022-08-23 13:29:53','2022-08-24 13:29:53','808',2365833.04,2604880.40,'808','2022-08-23 22:29:42','808','2022-08-23 22:30:08',10,0),('22','242',117,'MR. AHMED','2022-08-24','2022-08-27 10:28:01','2022-08-28 10:28:01','808',2955800.92,3157492.20,'808','2022-08-27 10:34:30','808','2022-08-27 10:34:44',10,0),('22','242',118,'MR. RAPHAEL','2022-08-25','2022-08-27 10:35:26','2022-08-28 10:35:26','808',1615553.08,1803930.55,'808','2022-08-27 10:38:38','808','2022-08-27 10:38:51',10,0),('22','242',119,'MR. AHMED','2022-08-26','2022-08-27 10:40:31','2022-08-28 10:40:31','808',2868652.20,3101228.50,'808','2022-08-27 10:44:11','808','2022-08-27 10:44:26',10,0),('22','242',120,'MR. RAPHAEL','2022-08-27','2022-08-27 10:45:11','2022-08-28 10:45:11','808',2086916.72,2254324.20,'808','2022-08-28 06:49:39','808','2022-08-28 06:50:00',10,0),('22','242',121,'MR. AHMED','2022-08-28','2022-08-28 06:50:31','2022-08-29 06:50:31','808',1370986.52,1512735.45,'808','2022-08-29 22:10:57','808','2022-08-29 22:11:12',10,0),('22','242',122,'MR. RAPHAEL','2022-08-29','2022-08-29 22:11:43','2022-08-30 22:11:43','808',2374359.88,2585890.80,'808','2022-08-29 22:14:52','808','2022-08-29 22:15:05',10,0),('22','242',123,'MR. AHMED','2022-08-30','2022-08-30 09:50:51','2022-08-31 09:50:51','808',3160011.64,3455293.40,'808','2022-08-30 22:00:06','808','2022-08-30 22:00:19',10,0),('22','242',124,'MR. RAPHAEL','2022-08-31','2022-08-31 22:03:59','2022-09-01 22:03:59','808',2553032.52,2778810.70,'808','2022-08-31 22:07:20','808','2022-08-31 22:07:39',10,0),('22','242',125,'MR. AHMED','2022-09-01','2022-09-01 12:14:01','2022-09-02 12:14:01','808',3592107.20,3851589.75,'808','2022-09-03 10:14:15','808','2022-09-03 10:14:33',10,0),('22','242',126,'MR. RAPHAEL','2022-09-02','2022-09-03 10:15:20','2022-09-04 10:15:20','808',2604200.04,2841222.15,'808','2022-09-03 10:50:46','808','2022-09-03 10:51:08',10,0),('22','242',127,'MR. AHMED','2022-09-03','2022-09-03 10:51:45','2022-09-04 10:51:45','808',2631498.00,2840912.50,'808','2022-09-04 08:53:55','808','2022-09-04 08:54:18',10,0),('22','242',128,'MR. RAPHAEL','2022-09-04','2022-09-04 08:55:01','2022-09-05 08:55:01','808',1132928.76,1255779.35,'808','2022-09-05 10:50:41','808','2022-09-05 10:50:55',10,0),('22','242',129,'MR. AHMED','2022-09-05','2022-09-05 10:51:26','2022-09-06 10:51:26','808',4014166.28,4254857.30,'808','2022-09-06 22:07:51','808','2022-09-06 22:08:04',10,0),('22','242',130,'MR. RAPHAEL','2022-09-06','2022-09-06 22:08:36','2022-09-07 22:08:36','808',2070572.72,2305754.70,'808','2022-09-06 22:11:56','808','2022-09-06 22:12:54',10,0),('22','242',131,'MR. AHMED','2022-09-07','2022-09-08 21:57:05','2022-09-09 21:57:05','808',2338585.44,2543750.65,'808','2022-09-08 22:00:04','808','2022-09-08 22:00:16',10,0),('22','242',132,'MR. RAPHAEL','2022-09-08','2022-09-08 22:00:50','2022-09-09 22:00:50','808',2427369.20,2663034.75,'808','2022-09-08 22:04:54','808','2022-09-08 22:05:39',10,0),('22','242',133,'MR. AHMED','2022-09-09','2022-09-09 14:35:56','2022-09-10 14:35:56','808',2727965.44,2955390.15,'808','2022-09-12 11:02:20','808','2022-09-12 11:02:33',10,0),('22','242',134,'MR. RAPHAEL','2022-09-10','2022-09-12 11:03:22','2022-09-13 11:03:22','808',3088167.88,3332400.55,'808','2022-09-12 11:06:07','808','2022-09-12 11:06:21',10,0),('22','242',135,'MR. AHMED','2022-09-11','2022-09-12 11:07:31','2022-09-13 11:07:31','808',1269544.60,1410552.25,'808','2022-09-12 11:12:19','808','2022-09-12 11:12:36',10,0),('22','242',136,'MR. RAPHAEL','2022-09-12','2022-09-12 11:13:15','2022-09-13 11:13:15','808',2697975.44,2947629.40,'808','2022-09-12 21:39:43','808','2022-09-12 21:39:56',10,0),('22','242',137,'MR. AHMED','2022-09-13','2022-09-13 12:54:08','2022-09-14 12:54:08','808',2608722.68,2853971.75,'808','2022-09-13 21:43:44','808','2022-09-13 21:43:58',10,0),('22','242',138,'MR. RAPHAEL','2022-09-14','2022-09-14 22:16:30','2022-09-15 22:16:30','808',4003417.16,4247680.25,'808','2022-09-14 22:25:32','808','2022-09-14 22:25:46',10,0),('22','242',139,'MR. AHMED','2022-09-15','2022-09-17 15:17:22','2022-09-18 15:17:22','808',2703387.36,2927415.75,'808','2022-09-17 15:23:17','808','2022-09-17 15:23:28',10,0),('22','242',140,'MR. RAPHAEL','2022-09-17','2022-09-17 15:24:03','2022-09-18 15:24:03','808',2275500.48,2481005.25,'808','2022-09-17 15:28:01','808','2022-09-17 15:28:16',10,0),('22','242',141,'MR. AHMED','2022-09-17','2022-09-17 15:28:55','2022-09-18 15:28:55','808',2399613.28,2606395.00,'808','2022-09-17 21:55:09','808','2022-09-17 21:55:20',10,0),('22','242',142,'MR. RAPHAEL','2022-09-18','2022-09-19 09:40:25','2022-09-20 09:40:25','808',780473.84,877343.75,'808','2022-09-19 09:46:03','808','2022-09-19 09:46:24',10,0),('22','242',143,'MR. AHMED','2022-09-19','2022-09-19 09:47:50','2022-09-20 09:47:50','808',2697254.16,2898652.50,'808','2022-09-20 09:48:59','808','2022-09-20 09:49:11',10,0),('22','242',144,'MR. RAPHAEL','2022-09-20','2022-09-20 09:49:38','2022-09-21 09:49:38','808',2426982.32,2669962.25,'808','2022-09-24 19:13:19','808','2022-09-24 19:13:31',10,0),('22','242',145,'MR. AHMED','2022-09-21','2022-09-24 19:14:30','2022-09-25 19:14:30','808',2686392.32,2925301.25,'808','2022-09-24 19:25:18','808','2022-09-24 19:25:36',10,0),('22','242',146,'MR. RAPHAEL','2022-09-22','2022-09-24 19:26:13','2022-09-25 19:26:13','808',2001806.64,2169918.75,'808','2022-09-24 19:29:31','808','2022-09-24 19:29:48',10,0),('22','242',147,'MR. AHMED','2022-09-23','2022-09-24 19:30:48','2022-09-25 19:30:48','808',2450134.24,2669392.00,'808','2022-09-24 19:33:17','808','2022-09-24 19:33:33',10,0),('22','242',148,'MR. RAPHAEL','2022-09-24','2022-09-24 19:34:06','2022-09-25 19:34:06','808',2597184.16,2807500.75,'808','2022-09-25 08:33:47','808','2022-09-25 08:33:59',10,0),('22','242',149,'MR. AHMED','2022-09-25','2022-09-26 21:17:23','2022-09-27 21:17:23','808',1016980.24,1129486.00,'808','2022-09-26 21:28:23','808','2022-09-26 21:28:36',10,0),('22','242',150,'MR. RAPHAEL','2022-09-26','2022-09-26 21:29:49','2022-09-27 21:29:49','808',3959778.56,4214294.00,'808','2022-09-26 21:32:58','808','2022-09-26 21:33:11',10,0),('22','242',151,'MR. AHMED','2022-09-27','2022-09-27 14:47:49','2022-09-28 14:47:49','808',2392676.52,2652669.25,'808','2022-09-27 21:58:12','808','2022-09-27 21:58:32',10,0),('22','242',152,'MR. RAPHAEL','2022-09-28','2022-09-28 10:42:50','2022-09-29 10:42:50','808',3059374.92,3493065.75,'808','2022-09-29 09:43:54','808','2022-09-29 09:44:12',10,0),('22','242',153,'MR. AHMED','2022-09-29','2022-09-29 09:45:25','2022-09-30 09:45:25','808',2312772.72,2662354.50,'808','2022-09-29 22:24:58','808','2022-09-29 22:25:11',10,0),('22','242',154,'MR. RAPHAEL','2022-09-30','2022-09-30 09:57:35','2022-10-01 09:57:35','808',2415162.24,2782134.00,'808','2022-10-01 20:27:12','808','2022-10-01 20:27:31',10,0),('22','242',155,'MR. AHMED','2022-10-01','2022-10-01 20:29:02','2022-10-02 20:29:02','808',2215601.32,2546776.75,'808','2022-10-01 21:07:01','808','2022-10-01 21:07:13',10,0),('22','242',156,'MR. RAPHAEL','2022-10-02','2022-10-03 16:45:15','2022-10-04 16:45:15','808',1021014.48,1181221.50,'808','2022-10-03 16:54:22','808','2022-10-03 16:54:37',10,0),('22','242',157,'MR. AHMED','2022-10-03','2022-10-03 16:55:14','2022-10-04 16:55:14','808',2073871.88,2388425.75,'808','2022-10-04 11:01:41','808','2022-10-04 11:01:53',10,0),('22','242',158,'MR. RAPHAEL','2022-10-04','2022-10-04 11:02:22','2022-10-05 11:02:22','808',1941946.04,2250148.25,'808','2022-10-05 10:45:53','808','2022-10-05 10:46:08',10,0),('22','242',159,'MR. AHMED','2022-10-05','2022-10-05 10:47:02','2022-10-06 10:47:02','808',2286329.04,2638327.50,'808','2022-10-05 21:46:13','808','2022-10-05 21:46:29',10,0),('22','242',160,'MR. RAPHAEL','2022-10-06','2022-10-09 09:38:01','2022-10-10 09:38:01','808',1997907.40,2306563.75,'808','2022-10-09 09:41:25','808','2022-10-09 09:41:38',10,0),('22','242',161,'MR. AHMED','2022-10-07','2022-10-09 09:42:17','2022-10-10 09:42:17','808',2955229.24,3374232.25,'808','2022-10-09 09:45:23','808','2022-10-09 09:45:35',10,0),('22','242',162,'MR. RAPHAEL','2022-10-08','2022-10-09 09:46:21','2022-10-10 09:46:21','808',2290382.24,2625773.00,'808','2022-10-09 09:49:06','808','2022-10-09 09:49:19',10,0),('22','242',163,'MR. AHMED','2022-10-09','2022-10-09 09:50:00','2022-10-10 09:50:00','808',1169866.28,1342610.75,'808','2022-10-10 11:06:45','808','2022-10-10 11:06:59',10,0),('22','242',164,'MR. RAPHAEL','2022-10-10','2022-10-10 11:08:04','2022-10-11 11:08:04','808',1396879.32,1628699.25,'808','2022-10-14 12:39:35','808','2022-10-14 12:39:48',10,0),('22','242',165,'MR. AHMED','2022-10-11','2022-10-14 12:40:58','2022-10-15 12:40:58','808',1920811.60,2219513.50,'808','2022-10-14 12:43:53','808','2022-10-14 12:44:12',10,0),('22','242',166,'MR. RAPHAEL','2022-10-12','2022-10-14 12:44:56','2022-10-15 12:44:56','808',2175073.04,2504031.50,'808','2022-10-14 12:48:26','808','2022-10-14 12:48:43',10,0),('22','242',167,'MR. AHMED','2022-10-13','2022-10-14 12:49:19','2022-10-15 12:49:19','808',2107361.04,2419993.50,'808','2022-10-14 12:52:01','808','2022-10-14 12:52:15',10,0),('22','242',168,'MR. RAPHAEL','2022-10-14','2022-10-14 12:52:48','2022-10-15 12:52:48','808',1715881.92,1986846.00,'808','2022-10-15 10:27:17','808','2022-10-15 10:27:29',10,0),('22','242',169,'MR. AHMED','2022-10-15','2022-10-15 10:28:07','2022-10-16 10:28:07','808',3307195.92,3770413.50,'808','2022-10-16 13:08:25','808','2022-10-16 13:08:39',10,0),('22','242',170,'MR. RAPHAEL','2022-10-16','2022-10-16 13:09:09','2022-10-17 13:09:09','808',1008885.80,1168100.75,'808','2022-10-17 15:35:25','808','2022-10-17 15:35:40',10,0),('22','242',171,'MR. AHMED','2022-10-17','2022-10-17 15:36:17','2022-10-18 15:36:17','808',1873691.28,2165161.50,'808','2022-11-15 12:50:12','808','2022-11-15 12:50:30',10,0),('22','242',172,'MR. RAPHAEL','2022-10-18','2022-11-15 12:52:15','2022-11-16 12:52:15','808',2071318.96,2395202.50,'808','2022-11-15 12:55:25','808','2022-11-15 12:55:41',10,0),('22','242',173,'MR. AHMED','2022-10-19','2022-11-15 12:57:31','2022-11-16 12:57:31','808',1760840.32,2037874.00,'808','2022-11-15 13:00:46','808','2022-11-15 13:00:58',10,0),('22','242',174,'MR. RAPHAEL','2022-10-20','2022-11-15 13:01:52','2022-11-16 13:01:52','808',2817649.44,3216375.00,'808','2022-11-15 13:06:43','808','2022-11-15 13:06:56',10,0),('22','242',175,'MR. AHMED','2022-10-21','2022-11-15 13:08:31','2022-11-16 13:08:31','808',1884238.92,2162283.75,'808','2022-11-15 13:12:41','808','2022-11-15 13:12:55',10,0),('22','242',176,'MR. RAPHAEL','2022-10-22','2022-11-15 13:13:50','2022-11-16 13:13:50','808',1714468.48,1931398.00,'808','2022-11-15 13:18:08','808','2022-11-15 13:18:24',10,0),('22','242',177,'MR. AHMED','2022-10-23','2022-11-15 13:19:44','2022-11-16 13:19:44','808',456298.92,519108.75,'808','2022-11-15 13:22:45','808','2022-11-15 13:22:57',10,0),('22','242',178,'MR. RAPHAEL','2022-10-24','2022-11-15 13:23:57','2022-11-16 13:23:57','808',1411066.24,1579012.00,'808','2022-11-15 13:25:12','808','2022-11-15 13:25:26',10,0),('22','242',179,'MR. AHMED','2022-10-25','2022-11-15 13:26:36','2022-11-16 13:26:36','808',1824723.64,2044956.25,'808','2022-11-15 13:27:58','808','2022-11-15 13:28:11',10,0),('22','242',180,'MR. RAPHAEL','2022-10-26','2022-11-15 13:28:54','2022-11-16 13:28:54','808',1451292.12,1626671.25,'808','2022-11-15 13:30:04','808','2022-11-15 13:30:16',10,0),('22','242',181,'MR. AHMED','2022-10-27','2022-11-15 13:31:02','2022-11-16 13:31:02','808',2033480.60,2324107.25,'808','2022-11-15 13:33:48','808','2022-11-15 13:34:02',10,0),('22','242',182,'MR. RAPHAEL','2022-10-28','2022-11-15 13:35:02','2022-11-16 13:35:02','808',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',3,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=2343 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('22','242','3','3',15,'4','2',761244.73,761244.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','3',16,'5','2',1049877.14,1049877.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','3',17,'6','2',921348.66,921348.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','3',18,'7','1',590655.52,590655.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','3',19,'8','1',688077.83,688077.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','3',20,'9','1',681128.34,681128.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','3',21,'10','1',587850.66,587850.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','3',22,'11','1',847186.46,847186.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','3',23,'12','1',672613.86,672613.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','3',24,'13','1',437746.15,437746.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','3',25,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','3',26,'15','1',420259.32,420259.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','3',27,'16','1',264269.18,264269.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','5',29,'4','2',761244.73,761244.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','5',30,'5','2',1049877.14,1052266.79,2389.65,1553272.50,0.00,0.00,0.00,0.00,0.00),('22','242','4','5',31,'6','2',921348.66,922958.66,1610.00,1046500.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','5',32,'7','1',590655.52,592273.09,1617.57,266899.05,0.00,0.00,0.00,0.00,0.00),('22','242','1','5',33,'8','1',688077.83,689268.66,1190.83,196486.95,0.00,0.00,0.00,0.00,0.00),('22','242','1','5',34,'9','1',681128.34,682779.35,1651.01,272416.65,0.00,0.00,0.00,0.00,0.00),('22','242','1','5',35,'10','1',587850.66,588777.33,926.67,152900.55,0.00,0.00,0.00,0.00,0.00),('22','242','2','5',36,'11','1',847186.46,848600.75,1414.29,233357.85,0.00,0.00,0.00,0.00,0.00),('22','242','1','5',37,'12','1',672613.86,672613.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','5',38,'13','1',437746.15,438752.89,1006.74,166112.10,0.00,0.00,0.00,0.00,0.00),('22','242','2','5',39,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','5',40,'15','1',420259.32,421269.51,1010.19,166681.35,0.00,0.00,0.00,0.00,0.00),('22','242','2','5',41,'16','1',264269.18,264542.59,273.41,45112.65,0.00,0.00,0.00,0.00,0.00),('22','242','3','6',42,'4','2',761244.73,761610.09,365.36,237484.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','6',43,'5','2',1052266.79,1054055.09,1788.30,1162395.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','6',44,'6','2',922958.66,923920.10,961.44,624936.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','6',45,'7','1',592273.09,594845.41,2572.32,424432.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','6',46,'8','1',689268.66,690795.65,1526.99,251953.35,0.00,0.00,0.00,0.00,0.00),('22','242','1','6',47,'9','1',682779.35,684837.99,2058.64,339675.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','6',48,'10','1',588777.33,590113.06,1335.73,220395.45,0.00,0.00,0.00,0.00,0.00),('22','242','2','6',49,'11','1',848600.75,850648.39,2047.64,337860.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','6',50,'12','1',672613.86,673765.56,1151.70,190030.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','6',51,'13','1',438752.89,439455.18,702.29,115877.85,0.00,0.00,0.00,0.00,0.00),('22','242','2','6',52,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','6',53,'15','1',421269.51,421847.42,577.91,95355.15,0.00,0.00,0.00,0.00,0.00),('22','242','2','6',54,'16','1',264542.59,264751.35,208.76,34445.40,0.00,0.00,0.00,0.00,0.00),('22','242','3','7',55,'4','2',761610.09,761746.46,136.37,88640.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','7',56,'5','2',1054055.09,1054533.39,478.30,310895.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','7',57,'6','2',923920.10,924220.10,300.00,195000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','7',58,'7','1',594845.41,595857.39,1011.98,166976.70,0.00,0.00,0.00,0.00,0.00),('22','242','1','7',59,'8','1',690795.65,691574.36,778.71,128487.15,0.00,0.00,0.00,0.00,0.00),('22','242','1','7',60,'9','1',684837.99,686134.32,1296.33,213894.45,0.00,0.00,0.00,0.00,0.00),('22','242','1','7',61,'10','1',590113.06,590734.25,621.19,102496.35,0.00,0.00,0.00,0.00,0.00),('22','242','2','7',62,'11','1',850648.39,851342.15,693.76,114470.40,0.00,0.00,0.00,0.00,0.00),('22','242','1','7',63,'12','1',673765.56,674304.67,539.11,88953.15,0.00,0.00,0.00,0.00,0.00),('22','242','2','7',64,'13','1',439455.18,439920.16,464.98,76721.70,0.00,0.00,0.00,0.00,0.00),('22','242','2','7',65,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','7',66,'15','1',421847.42,421847.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','7',67,'16','1',264751.35,264751.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','8',68,'4','2',761746.46,762367.97,621.51,403981.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','8',69,'5','2',1054533.39,1056195.90,1662.51,1080631.50,0.00,0.00,0.00,0.00,0.00),('22','242','4','8',70,'6','2',924220.10,926589.52,2369.42,1540123.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','8',71,'7','1',595857.39,597769.07,1911.68,315427.20,0.00,0.00,0.00,0.00,0.00),('22','242','1','8',72,'8','1',691574.36,693511.45,1937.09,319619.85,0.00,0.00,0.00,0.00,0.00),('22','242','1','8',73,'9','1',686134.32,688101.34,1967.02,324558.30,0.00,0.00,0.00,0.00,0.00),('22','242','1','8',74,'10','1',590734.25,591970.71,1236.46,204015.90,0.00,0.00,0.00,0.00,0.00),('22','242','2','8',75,'11','1',851342.15,853205.56,1863.41,307462.65,0.00,0.00,0.00,0.00,0.00),('22','242','1','8',76,'12','1',674304.67,675571.93,1267.26,209097.90,0.00,0.00,0.00,0.00,0.00),('22','242','2','8',77,'13','1',439920.16,440901.73,981.57,161959.05,0.00,0.00,0.00,0.00,0.00),('22','242','2','8',78,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','8',79,'15','1',421847.42,422437.02,589.60,97284.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','8',80,'16','1',264751.35,265135.96,384.61,63460.65,0.00,0.00,0.00,0.00,0.00),('22','242','3','9',81,'4','2',762367.97,763449.36,1081.39,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','9',82,'5','2',1056195.90,1058225.25,2029.35,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','9',83,'6','2',926589.52,927540.09,950.57,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','9',84,'7','1',597769.07,599018.25,1249.18,206114.70,0.00,0.00,0.00,0.00,0.00),('22','242','1','9',85,'8','1',693511.45,694014.11,502.66,82938.90,0.00,0.00,0.00,0.00,0.00),('22','242','1','9',86,'9','1',688101.34,689208.79,1107.45,182729.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','9',87,'10','1',591970.71,592571.01,600.30,99049.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','9',88,'11','1',853205.56,855805.09,2599.53,428922.45,0.00,0.00,0.00,0.00,0.00),('22','242','1','9',89,'12','1',675571.93,675571.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','9',90,'13','1',440901.73,442311.95,1410.22,232686.30,0.00,0.00,0.00,0.00,0.00),('22','242','2','9',91,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','9',92,'15','1',422437.02,423490.70,1053.68,173857.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','9',93,'16','1',265135.96,265538.58,402.62,66432.30,0.00,0.00,0.00,0.00,0.00),('22','242','3','10',94,'4','2',763449.36,764563.12,1113.76,723944.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','10',95,'5','2',1058225.25,1059873.45,1648.20,1071330.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','10',96,'6','2',927540.09,928340.09,800.00,520000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','10',97,'7','1',599018.25,601086.70,2068.45,341294.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','10',98,'8','1',694014.11,695065.87,1051.76,173540.40,0.00,0.00,0.00,0.00,0.00),('22','242','1','10',99,'9','1',689208.79,690973.63,1764.84,291198.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','10',100,'10','1',592571.01,593877.70,1306.69,215603.85,0.00,0.00,0.00,0.00,0.00),('22','242','2','10',101,'11','1',855805.09,857192.17,1387.08,228868.20,0.00,0.00,0.00,0.00,0.00),('22','242','1','10',102,'12','1',675571.93,676721.23,1149.30,189634.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','10',103,'13','1',442311.95,443761.87,1449.92,239236.80,0.00,0.00,0.00,0.00,0.00),('22','242','2','10',104,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','10',105,'15','1',423490.70,424144.81,654.11,107928.15,0.00,0.00,0.00,0.00,0.00),('22','242','2','10',106,'16','1',265538.58,265695.53,156.95,25896.75,0.00,0.00,0.00,0.00,0.00),('22','242','3','11',107,'4','2',764563.12,765519.74,956.62,621803.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','11',108,'5','2',1059873.45,1061409.62,1536.17,998510.50,0.00,0.00,0.00,0.00,0.00),('22','242','4','11',109,'6','2',928340.09,931830.09,3490.00,2268500.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','11',110,'7','1',601086.70,602406.39,1319.69,217748.85,0.00,0.00,0.00,0.00,0.00),('22','242','1','11',111,'8','1',695065.87,695983.39,917.52,151390.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','11',112,'9','1',690973.63,692794.74,1821.11,300483.15,0.00,0.00,0.00,0.00,0.00),('22','242','1','11',113,'10','1',593877.70,595047.74,1170.04,193056.60,0.00,0.00,0.00,0.00,0.00),('22','242','2','11',114,'11','1',857192.17,858819.72,1627.55,268545.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','11',115,'12','1',676721.23,677888.62,1167.39,192619.35,0.00,0.00,0.00,0.00,0.00),('22','242','2','11',116,'13','1',443761.87,444881.29,1119.42,184704.30,0.00,0.00,0.00,0.00,0.00),('22','242','2','11',117,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','11',118,'15','1',424144.81,425213.05,1068.24,176259.60,0.00,0.00,0.00,0.00,0.00),('22','242','2','11',119,'16','1',265695.53,266275.13,579.60,95634.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','12',120,'4','2',765519.74,766529.82,1010.08,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','12',121,'5','2',1061409.62,1063436.56,2026.94,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','12',122,'6','2',931830.09,932640.09,810.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','12',123,'7','1',602406.39,604589.41,2183.02,360198.30,0.00,0.00,0.00,0.00,0.00),('22','242','1','12',124,'8','1',695983.39,697013.85,1030.46,170025.90,0.00,0.00,0.00,0.00,0.00),('22','242','1','12',125,'9','1',692794.74,694584.21,1789.47,295262.55,0.00,0.00,0.00,0.00,0.00),('22','242','1','12',126,'10','1',595047.74,596080.05,1032.31,170331.15,0.00,0.00,0.00,0.00,0.00),('22','242','2','12',127,'11','1',858819.72,860157.96,1338.24,220809.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','12',128,'12','1',677888.62,679185.99,1297.37,214066.05,0.00,0.00,0.00,0.00,0.00),('22','242','2','12',129,'13','1',444881.29,445408.48,527.19,86986.35,0.00,0.00,0.00,0.00,0.00),('22','242','2','12',130,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','12',131,'15','1',425213.05,426104.83,891.78,147143.70,0.00,0.00,0.00,0.00,0.00),('22','242','2','12',132,'16','1',266275.13,266941.44,666.31,109941.15,0.00,0.00,0.00,0.00,0.00),('22','242','3','13',133,'4','2',766529.82,767514.10,984.28,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','13',134,'5','2',1063436.56,1064706.92,1270.36,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','13',135,'6','2',932640.09,934650.09,2010.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','13',136,'7','1',604589.41,605747.26,1157.85,191045.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','13',137,'8','1',697013.85,698164.43,1150.58,189845.70,0.00,0.00,0.00,0.00,0.00),('22','242','1','13',138,'9','1',694584.21,696669.49,2085.28,344071.20,0.00,0.00,0.00,0.00,0.00),('22','242','1','13',139,'10','1',596080.05,597421.71,1341.66,221373.90,0.00,0.00,0.00,0.00,0.00),('22','242','2','13',140,'11','1',860157.96,860157.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','13',141,'12','1',679185.99,680909.23,1723.24,284334.60,0.00,0.00,0.00,0.00,0.00),('22','242','2','13',142,'13','1',445408.48,446536.14,1127.66,186063.90,0.00,0.00,0.00,0.00,0.00),('22','242','2','13',143,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','13',144,'15','1',426104.83,427271.32,1166.49,192470.85,0.00,0.00,0.00,0.00,0.00),('22','242','2','13',145,'16','1',266941.44,267496.56,555.12,91594.80,0.00,0.00,0.00,0.00,0.00),('22','242','3','14',146,'4','2',767514.10,767737.78,223.68,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','14',147,'5','2',1064706.92,1065045.13,338.21,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','14',148,'6','2',934650.09,934650.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','14',149,'7','1',605747.26,606978.22,1230.96,203108.40,0.00,0.00,0.00,0.00,0.00),('22','242','1','14',150,'8','1',698164.43,698991.52,827.09,136469.85,0.00,0.00,0.00,0.00,0.00),('22','242','1','14',151,'9','1',696669.49,697603.02,933.53,154032.45,0.00,0.00,0.00,0.00,0.00),('22','242','1','14',152,'10','1',597421.71,598060.35,638.64,105375.60,0.00,0.00,0.00,0.00,0.00),('22','242','2','14',153,'11','1',860157.96,860157.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','14',154,'12','1',680909.23,680909.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','14',155,'13','1',446536.14,447226.51,690.37,113911.05,0.00,0.00,0.00,0.00,0.00),('22','242','2','14',156,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','14',157,'15','1',427271.32,427828.21,556.89,91886.85,0.00,0.00,0.00,0.00,0.00),('22','242','2','14',158,'16','1',267496.56,267663.20,166.64,27495.60,0.00,0.00,0.00,0.00,0.00),('22','242','3','15',159,'4','2',767737.78,768585.03,847.25,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','15',160,'5','2',1065045.13,1066492.94,1447.81,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','15',161,'6','2',934650.09,935935.09,1285.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','15',162,'7','1',606978.22,608779.76,1801.54,297254.10,0.00,0.00,0.00,0.00,0.00),('22','242','1','15',163,'8','1',698991.52,699935.56,944.04,155766.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','15',164,'9','1',697603.02,698921.79,1318.77,217597.05,0.00,0.00,0.00,0.00,0.00),('22','242','1','15',165,'10','1',598060.35,599047.16,986.81,162823.65,0.00,0.00,0.00,0.00,0.00),('22','242','2','15',166,'11','1',860157.96,861986.48,1828.52,301705.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','15',167,'12','1',680909.23,682935.29,2026.06,334299.90,0.00,0.00,0.00,0.00,0.00),('22','242','2','15',168,'13','1',447226.51,448533.26,1306.75,215613.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','15',169,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','15',170,'15','1',427828.21,428881.15,1052.94,173735.10,0.00,0.00,0.00,0.00,0.00),('22','242','2','15',171,'16','1',267663.20,267941.23,278.03,45874.95,0.00,0.00,0.00,0.00,0.00),('22','242','3','16',172,'4','2',768585.03,769392.30,807.27,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','16',173,'5','2',1066492.94,1067757.71,1264.77,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','16',174,'6','2',935935.09,936945.09,1010.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','16',175,'7','1',608779.76,610162.88,1383.12,228214.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','16',176,'8','1',699935.56,700893.60,958.04,158076.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','16',177,'9','1',698921.79,700128.32,1206.53,199077.45,0.00,0.00,0.00,0.00,0.00),('22','242','1','16',178,'10','1',599047.16,599661.64,614.48,101389.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','16',179,'11','1',861986.48,863627.21,1640.73,270720.45,0.00,0.00,0.00,0.00,0.00),('22','242','1','16',180,'12','1',682935.29,684600.12,1664.83,274696.95,0.00,0.00,0.00,0.00,0.00),('22','242','2','16',181,'13','1',448533.26,449559.44,1026.18,169319.70,0.00,0.00,0.00,0.00,0.00),('22','242','2','16',182,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','16',183,'15','1',428881.15,430301.17,1420.02,234303.30,0.00,0.00,0.00,0.00,0.00),('22','242','2','16',184,'16','1',267941.23,268341.11,399.88,65980.20,0.00,0.00,0.00,0.00,0.00),('22','242','3','17',185,'4','2',769392.30,770342.55,950.25,631916.25,0.00,0.00,0.00,0.00,0.00),('22','242','3','17',186,'5','2',1067757.71,1069079.18,1321.47,878777.55,0.00,0.00,0.00,0.00,0.00),('22','242','4','17',187,'6','2',936945.09,939625.79,2680.70,1782665.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','17',188,'7','1',610162.88,612031.14,1868.26,308262.90,0.00,0.00,0.00,0.00,0.00),('22','242','1','17',189,'8','1',700893.60,702362.41,1468.81,242353.65,0.00,0.00,0.00,0.00,0.00),('22','242','1','17',190,'9','1',700128.32,701854.79,1726.47,284867.55,0.00,0.00,0.00,0.00,0.00),('22','242','1','17',191,'10','1',599661.64,600688.77,1027.13,169476.45,0.00,0.00,0.00,0.00,0.00),('22','242','2','17',192,'11','1',863627.21,864696.50,1069.29,176432.85,0.00,0.00,0.00,0.00,0.00),('22','242','1','17',193,'12','1',684600.12,686062.32,1462.20,241263.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','17',194,'13','1',449559.44,450453.02,893.58,147440.70,0.00,0.00,0.00,0.00,0.00),('22','242','2','17',195,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','17',196,'15','1',430301.17,431023.21,722.04,119136.60,0.00,0.00,0.00,0.00,0.00),('22','242','2','17',197,'16','1',268341.11,268633.79,292.68,48292.20,0.00,0.00,0.00,0.00,0.00),('22','242','3','18',198,'4','2',770342.55,771500.56,1158.01,770076.65,0.00,0.00,0.00,0.00,0.00),('22','242','3','18',199,'5','2',1069079.18,1071000.56,1921.38,1277717.70,0.00,0.00,0.00,0.00,0.00),('22','242','4','18',200,'6','2',939625.79,941098.02,1472.23,979032.95,0.00,0.00,0.00,0.00,0.00),('22','242','1','18',201,'7','1',612031.14,614375.63,2344.49,386840.85,0.00,0.00,0.00,0.00,0.00),('22','242','1','18',202,'8','1',702362.41,703775.59,1413.18,233174.70,0.00,0.00,0.00,0.00,0.00),('22','242','1','18',203,'9','1',701854.79,703475.96,1621.17,267493.05,0.00,0.00,0.00,0.00,0.00),('22','242','1','18',204,'10','1',600688.77,601377.37,688.60,113619.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','18',205,'11','1',864696.50,866382.90,1686.40,278256.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','18',206,'12','1',686062.32,686236.55,174.23,28747.95,0.00,0.00,0.00,0.00,0.00),('22','242','2','18',207,'13','1',450453.02,451797.65,1344.63,221863.95,0.00,0.00,0.00,0.00,0.00),('22','242','2','18',208,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','18',209,'15','1',431023.21,431929.83,906.62,149592.30,0.00,0.00,0.00,0.00,0.00),('22','242','2','18',210,'16','1',268633.79,268954.97,321.18,52994.70,0.00,0.00,0.00,0.00,0.00),('22','242','3','19',211,'4','2',771500.56,773089.79,1589.23,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','19',212,'5','2',1071000.56,1073500.52,2499.96,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','19',213,'6','2',941098.02,942588.02,1490.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','19',214,'7','1',614375.63,616391.51,2015.88,332620.20,0.00,0.00,0.00,0.00,0.00),('22','242','1','19',215,'8','1',703775.59,705306.87,1531.28,252661.20,0.00,0.00,0.00,0.00,0.00),('22','242','1','19',216,'9','1',703475.96,704787.46,1311.50,216397.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','19',217,'10','1',601377.37,602268.93,891.56,147107.40,0.00,0.00,0.00,0.00,0.00),('22','242','2','19',218,'11','1',866382.90,867881.78,1498.88,247315.20,0.00,0.00,0.00,0.00,0.00),('22','242','1','19',219,'12','1',686236.55,687960.71,1724.16,284486.40,0.00,0.00,0.00,0.00,0.00),('22','242','2','19',220,'13','1',451797.65,453346.68,1549.03,255589.95,0.00,0.00,0.00,0.00,0.00),('22','242','2','19',221,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','19',222,'15','1',431929.83,433513.83,1584.00,261360.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','19',223,'16','1',268954.97,269656.23,701.26,115707.90,0.00,0.00,0.00,0.00,0.00),('22','242','3','20',224,'4','2',773089.79,774239.32,1149.53,781680.40,0.00,0.00,0.00,0.00,0.00),('22','242','3','20',225,'5','2',1073500.52,1074650.86,1150.34,782231.20,0.00,0.00,0.00,0.00,0.00),('22','242','4','20',226,'6','2',942588.02,944067.94,1479.92,1006345.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','20',227,'7','1',616391.51,616953.11,561.60,92664.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','20',228,'8','1',705306.87,706231.43,924.56,152552.40,0.00,0.00,0.00,0.00,0.00),('22','242','1','20',229,'9','1',704787.46,706730.52,1943.06,320604.90,0.00,0.00,0.00,0.00,0.00),('22','242','1','20',230,'10','1',602268.93,603603.28,1334.35,220167.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','20',231,'11','1',867881.78,869196.24,1314.46,216885.90,0.00,0.00,0.00,0.00,0.00),('22','242','1','20',232,'12','1',687960.71,689104.65,1143.94,188750.10,0.00,0.00,0.00,0.00,0.00),('22','242','2','20',233,'13','1',453346.68,454401.06,1054.38,173972.70,0.00,0.00,0.00,0.00,0.00),('22','242','2','20',234,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','20',235,'15','1',433513.83,434452.62,938.79,154900.35,0.00,0.00,0.00,0.00,0.00),('22','242','2','20',236,'16','1',269656.23,269905.30,249.07,41096.55,0.00,0.00,0.00,0.00,0.00),('22','242','3','21',237,'4','2',774239.32,774317.41,78.09,53101.20,0.00,0.00,0.00,0.00,0.00),('22','242','3','21',238,'5','2',1074650.86,1075574.49,923.63,628068.40,0.00,0.00,0.00,0.00,0.00),('22','242','4','21',239,'6','2',944067.94,944877.94,810.00,550800.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','21',240,'7','1',616953.11,617958.81,1005.70,165940.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','21',241,'8','1',706231.43,707285.30,1053.87,173888.55,0.00,0.00,0.00,0.00,0.00),('22','242','1','21',242,'9','1',706730.52,707446.43,715.91,118125.15,0.00,0.00,0.00,0.00,0.00),('22','242','1','21',243,'10','1',603603.28,603995.81,392.53,64767.45,0.00,0.00,0.00,0.00,0.00),('22','242','2','21',244,'11','1',869196.24,869518.09,321.85,53105.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','21',245,'12','1',689104.65,689451.95,347.30,57304.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','21',246,'13','1',454401.06,454699.76,298.70,49285.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','21',247,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','21',248,'15','1',434452.62,434680.22,227.60,37554.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','21',249,'16','1',269905.30,269905.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','22',250,'4','2',774317.41,775015.80,698.39,474905.20,0.00,0.00,0.00,0.00,0.00),('22','242','3','22',251,'5','2',1075574.49,1078392.91,2818.42,1916525.60,0.00,0.00,0.00,0.00,0.00),('22','242','4','22',252,'6','2',944877.94,945187.94,310.00,210800.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','22',253,'7','1',617958.81,620622.26,2663.45,439469.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','22',254,'8','1',707285.30,708823.13,1537.83,253741.95,0.00,0.00,0.00,0.00,0.00),('22','242','1','22',255,'9','1',707446.43,708842.10,1395.67,230285.55,0.00,0.00,0.00,0.00,0.00),('22','242','1','22',256,'10','1',603995.81,604752.51,756.70,124855.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','22',257,'11','1',869518.09,871032.93,1514.84,249948.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','22',258,'12','1',689451.95,690394.35,942.40,155496.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','22',259,'13','1',454699.76,455762.49,1062.73,175350.45,0.00,0.00,0.00,0.00,0.00),('22','242','2','22',260,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','22',261,'15','1',434680.22,435388.44,708.22,116856.30,0.00,0.00,0.00,0.00,0.00),('22','242','2','22',262,'16','1',269905.30,270105.29,199.99,32998.35,0.00,0.00,0.00,0.00,0.00),('22','242','3','23',263,'4','2',775015.80,777267.22,2251.42,1530965.60,0.00,0.00,0.00,0.00,0.00),('22','242','3','23',264,'5','2',1078392.91,1081581.47,3188.56,2168220.80,0.00,0.00,0.00,0.00,0.00),('22','242','4','23',265,'6','2',945187.94,946497.94,1310.00,890800.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','23',266,'7','1',620622.26,622294.64,1672.38,275942.70,0.00,0.00,0.00,0.00,0.00),('22','242','1','23',267,'8','1',708823.13,709974.36,1151.23,189952.95,0.00,0.00,0.00,0.00,0.00),('22','242','1','23',268,'9','1',708842.10,710410.47,1568.37,258781.05,0.00,0.00,0.00,0.00,0.00),('22','242','1','23',269,'10','1',604752.51,605692.66,940.15,155124.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','23',270,'11','1',871032.93,872073.17,1040.24,171639.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','23',271,'12','1',690394.35,692370.67,1976.32,326092.80,0.00,0.00,0.00,0.00,0.00),('22','242','2','23',272,'13','1',455762.49,456587.01,824.52,136045.80,0.00,0.00,0.00,0.00,0.00),('22','242','2','23',273,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','23',274,'15','1',435388.44,436230.48,842.04,138936.60,0.00,0.00,0.00,0.00,0.00),('22','242','2','23',275,'16','1',270105.29,270214.37,109.08,17998.20,0.00,0.00,0.00,0.00,0.00),('22','242','3','24',276,'4','2',777267.22,778059.71,792.49,538893.20,0.00,0.00,0.00,0.00,0.00),('22','242','3','24',277,'5','2',1081581.47,1082870.30,1288.83,876404.40,0.00,0.00,0.00,0.00,0.00),('22','242','4','24',278,'6','2',946497.94,947977.94,1480.00,1006400.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','24',279,'7','1',622294.64,623320.31,1025.67,169235.55,0.00,0.00,0.00,0.00,0.00),('22','242','1','24',280,'8','1',709974.36,710725.23,750.87,123893.55,0.00,0.00,0.00,0.00,0.00),('22','242','1','24',281,'9','1',710410.47,712444.34,2033.87,335588.55,0.00,0.00,0.00,0.00,0.00),('22','242','1','24',282,'10','1',605692.66,607067.88,1375.22,226911.30,0.00,0.00,0.00,0.00,0.00),('22','242','2','24',283,'11','1',872073.17,873807.92,1734.75,286233.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','24',284,'12','1',692370.67,693941.12,1570.45,259124.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','24',285,'13','1',456587.01,457889.88,1302.87,214973.55,0.00,0.00,0.00,0.00,0.00),('22','242','2','24',286,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','24',287,'15','1',436230.48,436903.89,673.41,111112.65,0.00,0.00,0.00,0.00,0.00),('22','242','2','24',288,'16','1',270214.37,270587.64,373.27,61589.55,0.00,0.00,0.00,0.00,0.00),('22','242','3','25',289,'4','2',778059.71,779338.53,1278.82,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','25',290,'5','2',1082870.30,1084234.56,1364.26,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','25',291,'6','2',947977.94,948587.94,610.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','25',292,'7','1',623320.31,623320.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','25',293,'8','1',710725.23,710725.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','25',294,'9','1',712444.34,712444.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','25',295,'10','1',607067.88,607067.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','25',296,'11','1',873807.92,877756.38,3948.46,651495.90,0.00,0.00,0.00,0.00,0.00),('22','242','1','25',297,'12','1',693941.12,693941.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','25',298,'13','1',457889.88,460718.45,2828.57,466714.05,0.00,0.00,0.00,0.00,0.00),('22','242','2','25',299,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','25',300,'15','1',436903.89,438931.12,2027.23,334492.95,0.00,0.00,0.00,0.00,0.00),('22','242','2','25',301,'16','1',270587.64,271369.07,781.43,128935.95,0.00,0.00,0.00,0.00,0.00),('22','242','3','26',302,'4','2',779338.53,780752.07,1413.54,961207.20,0.00,0.00,0.00,0.00,0.00),('22','242','3','26',303,'5','2',1084234.56,1085417.09,1182.53,804120.40,0.00,0.00,0.00,0.00,0.00),('22','242','4','26',304,'6','2',948587.94,950797.94,2210.00,1502800.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','26',305,'7','1',623320.31,625998.25,2677.94,441860.10,0.00,0.00,0.00,0.00,0.00),('22','242','1','26',306,'8','1',710725.23,712472.33,1747.10,288271.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','26',307,'9','1',712444.34,713987.67,1543.33,254649.45,0.00,0.00,0.00,0.00,0.00),('22','242','1','26',308,'10','1',607067.88,608277.95,1210.07,199661.55,0.00,0.00,0.00,0.00,0.00),('22','242','2','26',309,'11','1',877756.38,879007.09,1250.71,206367.15,0.00,0.00,0.00,0.00,0.00),('22','242','1','26',310,'12','1',693941.12,695124.47,1183.35,195252.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','26',311,'13','1',460718.45,461838.68,1120.23,184837.95,0.00,0.00,0.00,0.00,0.00),('22','242','2','26',312,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','26',313,'15','1',438931.12,439777.20,846.08,139603.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','26',314,'16','1',271369.07,271443.60,74.53,12297.45,0.00,0.00,0.00,0.00,0.00),('22','242','3','27',315,'4','2',780752.07,781066.09,314.02,227664.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','27',316,'5','2',1085417.09,1085910.49,493.40,357715.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','27',317,'6','2',950797.94,952590.95,1793.01,1299932.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','27',318,'7','1',625998.25,627044.50,1046.25,172631.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','27',319,'8','1',712472.33,713482.63,1010.30,166699.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','27',320,'9','1',713987.67,715564.90,1577.23,260242.95,0.00,0.00,0.00,0.00,0.00),('22','242','1','27',321,'10','1',608277.95,609696.58,1418.63,234073.95,0.00,0.00,0.00,0.00,0.00),('22','242','2','27',322,'11','1',879007.09,880616.02,1608.93,265473.45,0.00,0.00,0.00,0.00,0.00),('22','242','1','27',323,'12','1',695124.47,696290.90,1166.43,192460.95,0.00,0.00,0.00,0.00,0.00),('22','242','2','27',324,'13','1',461838.68,462613.20,774.52,127795.80,0.00,0.00,0.00,0.00,0.00),('22','242','2','27',325,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','27',326,'15','1',439777.20,440616.90,839.70,138550.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','27',327,'16','1',271443.60,271711.45,267.85,44195.25,0.00,0.00,0.00,0.00,0.00),('22','242','3','28',328,'4','2',781066.09,781214.72,148.63,107013.60,0.00,0.00,0.00,0.00,0.00),('22','242','3','28',329,'5','2',1085910.49,1086140.14,229.65,165348.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','28',330,'6','2',952590.95,952590.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','28',331,'7','1',627044.50,627828.01,783.51,129279.15,0.00,0.00,0.00,0.00,0.00),('22','242','1','28',332,'8','1',713482.63,714235.31,752.68,124192.20,0.00,0.00,0.00,0.00,0.00),('22','242','1','28',333,'9','1',715564.90,716754.58,1189.68,196297.20,0.00,0.00,0.00,0.00,0.00),('22','242','1','28',334,'10','1',609696.58,610323.45,626.87,103433.55,0.00,0.00,0.00,0.00,0.00),('22','242','2','28',335,'11','1',880616.02,881097.15,481.13,79386.45,0.00,0.00,0.00,0.00,0.00),('22','242','1','28',336,'12','1',696290.90,696927.13,636.23,104977.95,0.00,0.00,0.00,0.00,0.00),('22','242','2','28',337,'13','1',462613.20,462866.53,253.33,41799.45,0.00,0.00,0.00,0.00,0.00),('22','242','2','28',338,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','28',339,'15','1',440616.90,440958.38,341.48,56344.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','28',340,'16','1',271711.45,271711.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','29',341,'4','2',781214.72,782279.19,1064.47,771740.75,0.00,0.00,0.00,0.00,0.00),('22','242','3','29',342,'5','2',1086140.14,1087020.81,880.67,638485.75,0.00,0.00,0.00,0.00,0.00),('22','242','4','29',343,'6','2',952590.95,953880.95,1290.00,935250.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','29',344,'7','1',627828.01,629334.56,1506.55,248580.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','29',345,'8','1',714235.31,715136.77,901.46,148740.90,0.00,0.00,0.00,0.00,0.00),('22','242','1','29',346,'9','1',716754.58,718227.27,1472.69,242993.85,0.00,0.00,0.00,0.00,0.00),('22','242','1','29',347,'10','1',610323.45,611770.93,1447.48,238834.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','29',348,'11','1',881097.15,882953.56,1856.41,306307.65,0.00,0.00,0.00,0.00,0.00),('22','242','1','29',349,'12','1',696927.13,698970.96,2043.83,337231.95,0.00,0.00,0.00,0.00,0.00),('22','242','2','29',350,'13','1',462866.53,464178.08,1311.55,216405.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','29',351,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','29',352,'15','1',440958.38,442030.60,1072.22,176916.30,0.00,0.00,0.00,0.00,0.00),('22','242','2','29',353,'16','1',271711.45,272071.24,359.79,59365.35,0.00,0.00,0.00,0.00,0.00),('22','242','3','30',354,'4','2',782279.19,782708.16,428.97,311003.25,0.00,0.00,0.00,0.00,0.00),('22','242','3','30',355,'5','2',1087020.81,1088020.12,999.31,724499.75,0.00,0.00,0.00,0.00,0.00),('22','242','4','30',356,'6','2',953880.95,955735.95,1855.00,1344875.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','30',357,'7','1',629334.56,630646.25,1311.69,216428.85,0.00,0.00,0.00,0.00,0.00),('22','242','1','30',358,'8','1',715136.77,716160.41,1023.64,168900.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','30',359,'9','1',718227.27,719251.99,1024.72,169078.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','30',360,'10','1',611770.93,612997.50,1226.57,202384.05,0.00,0.00,0.00,0.00,0.00),('22','242','2','30',361,'11','1',882953.56,884962.50,2008.94,331475.10,0.00,0.00,0.00,0.00,0.00),('22','242','1','30',362,'12','1',698970.96,700835.56,1864.60,307659.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','30',363,'13','1',464178.08,465442.36,1264.28,208606.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','30',364,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','30',365,'15','1',442030.60,442959.95,929.35,153342.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','30',366,'16','1',272071.24,272101.54,30.30,4999.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','31',367,'4','2',782708.16,783370.46,662.30,480167.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','31',368,'5','2',1088020.12,1089122.88,1102.76,799501.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','31',369,'6','2',955735.95,959040.95,3305.00,2396125.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','31',370,'7','1',630646.25,632278.58,1632.33,269334.45,0.00,0.00,0.00,0.00,0.00),('22','242','1','31',371,'8','1',716160.41,717547.75,1387.34,228911.10,0.00,0.00,0.00,0.00,0.00),('22','242','1','31',372,'9','1',719251.99,720585.18,1333.19,219976.35,0.00,0.00,0.00,0.00,0.00),('22','242','1','31',373,'10','1',612997.50,614086.25,1088.75,179643.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','31',374,'11','1',884962.50,886365.78,1403.28,231541.20,0.00,0.00,0.00,0.00,0.00),('22','242','1','31',375,'12','1',700835.56,702832.44,1996.88,329485.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','31',376,'13','1',465442.36,466430.27,987.91,163005.15,0.00,0.00,0.00,0.00,0.00),('22','242','2','31',377,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','31',378,'15','1',442959.95,443031.04,71.09,11729.85,0.00,0.00,0.00,0.00,0.00),('22','242','2','31',379,'16','1',272101.54,272194.72,93.18,15374.70,0.00,0.00,0.00,0.00,0.00),('22','242','3','32',380,'4','2',783370.46,784304.22,933.76,676976.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','32',381,'5','2',1089122.88,1090233.68,1110.80,805330.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','32',382,'6','2',959040.95,959590.95,550.00,398750.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','32',383,'7','1',632278.58,633820.92,1542.34,254486.10,0.00,0.00,0.00,0.00,0.00),('22','242','1','32',384,'8','1',717547.75,718939.03,1391.28,229561.20,0.00,0.00,0.00,0.00,0.00),('22','242','1','32',385,'9','1',720585.18,721985.21,1400.03,231004.95,0.00,0.00,0.00,0.00,0.00),('22','242','1','32',386,'10','1',614086.25,615281.40,1195.15,197199.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','32',387,'11','1',886365.78,887728.17,1362.39,224794.35,0.00,0.00,0.00,0.00,0.00),('22','242','1','32',388,'12','1',702832.44,704165.54,1333.10,219961.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','32',389,'13','1',466430.27,467064.01,633.74,104567.10,0.00,0.00,0.00,0.00,0.00),('22','242','2','32',390,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','32',391,'15','1',443031.04,443939.53,908.49,149900.85,0.00,0.00,0.00,0.00,0.00),('22','242','2','32',392,'16','1',272194.72,272724.79,530.07,87461.55,0.00,0.00,0.00,0.00,0.00),('22','242','3','33',393,'4','2',784304.22,785453.05,1148.83,832901.75,0.00,0.00,0.00,0.00,0.00),('22','242','3','33',394,'5','2',1090233.68,1091508.00,1274.32,923882.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','33',395,'6','2',959590.95,961712.95,2122.00,1538450.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','33',396,'7','1',633820.92,635532.50,1711.58,282410.70,0.00,0.00,0.00,0.00,0.00),('22','242','1','33',397,'8','1',718939.03,720287.12,1348.09,222434.85,0.00,0.00,0.00,0.00,0.00),('22','242','1','33',398,'9','1',721985.21,723501.41,1516.20,250173.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','33',399,'10','1',615281.40,616466.90,1185.50,195607.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','33',400,'11','1',887728.17,888649.35,921.18,151994.70,0.00,0.00,0.00,0.00,0.00),('22','242','1','33',401,'12','1',704165.54,705333.09,1167.55,192645.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','33',402,'13','1',467064.01,468255.34,1191.33,196569.45,0.00,0.00,0.00,0.00,0.00),('22','242','2','33',403,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','33',404,'15','1',443939.53,444946.64,1007.11,166173.15,0.00,0.00,0.00,0.00,0.00),('22','242','2','33',405,'16','1',272724.79,273181.69,456.90,75388.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','34',406,'4','2',785453.05,786607.41,1154.36,836911.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','34',407,'5','2',1091508.00,1093075.25,1567.25,1136256.25,0.00,0.00,0.00,0.00,0.00),('22','242','4','34',408,'6','2',961712.95,964247.38,2534.43,1837461.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','34',409,'7','1',635532.50,636854.53,1322.03,218134.95,0.00,0.00,0.00,0.00,0.00),('22','242','1','34',410,'8','1',720287.12,721576.47,1289.35,212742.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','34',411,'9','1',723501.41,724401.38,899.97,148495.05,0.00,0.00,0.00,0.00,0.00),('22','242','1','34',412,'10','1',616466.90,617150.95,684.05,112868.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','34',413,'11','1',888649.35,891143.38,2494.03,411514.95,0.00,0.00,0.00,0.00,0.00),('22','242','1','34',414,'12','1',705333.09,706341.42,1008.33,166374.45,0.00,0.00,0.00,0.00,0.00),('22','242','2','34',415,'13','1',468255.34,469665.15,1409.81,232618.65,0.00,0.00,0.00,0.00,0.00),('22','242','2','34',416,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','34',417,'15','1',444946.64,446162.96,1216.32,200692.80,0.00,0.00,0.00,0.00,0.00),('22','242','2','34',418,'16','1',273181.69,273747.32,565.63,93328.95,0.00,0.00,0.00,0.00,0.00),('22','242','3','35',419,'4','2',786607.41,786928.90,321.49,233080.25,0.00,0.00,0.00,0.00,0.00),('22','242','3','35',420,'5','2',1093075.25,1093547.37,472.12,342287.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','35',421,'6','2',964247.38,964847.38,600.00,435000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','35',422,'7','1',636854.53,637414.08,559.55,92325.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','35',423,'8','1',721576.47,722504.69,928.22,153156.30,0.00,0.00,0.00,0.00,0.00),('22','242','1','35',424,'9','1',724401.38,725294.88,893.50,147427.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','35',425,'10','1',617150.95,617711.49,560.54,92489.10,0.00,0.00,0.00,0.00,0.00),('22','242','2','35',426,'11','1',891143.38,892002.86,859.48,141814.20,0.00,0.00,0.00,0.00,0.00),('22','242','1','35',427,'12','1',706341.42,706341.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','35',428,'13','1',469665.15,470030.57,365.42,60294.30,0.00,0.00,0.00,0.00,0.00),('22','242','2','35',429,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','35',430,'15','1',446162.96,446636.71,473.75,78168.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','35',431,'16','1',273747.32,274099.32,352.00,58080.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','36',432,'4','2',786928.90,788376.10,1447.20,1049220.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','36',433,'5','2',1093547.37,1096310.57,2763.20,2003320.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','36',434,'6','2',964847.38,967988.43,3141.05,2277261.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','36',435,'7','1',637414.08,639461.76,2047.68,337867.20,0.00,0.00,0.00,0.00,0.00),('22','242','1','36',436,'8','1',722504.69,723795.08,1290.39,212914.35,0.00,0.00,0.00,0.00,0.00),('22','242','1','36',437,'9','1',725294.88,726905.55,1610.67,265760.55,0.00,0.00,0.00,0.00,0.00),('22','242','1','36',438,'10','1',617711.49,619482.42,1770.93,292203.45,0.00,0.00,0.00,0.00,0.00),('22','242','2','36',439,'11','1',892002.86,893981.32,1978.46,326445.90,0.00,0.00,0.00,0.00,0.00),('22','242','1','36',440,'12','1',706341.42,706341.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','36',441,'13','1',470030.57,471519.38,1488.81,245653.65,0.00,0.00,0.00,0.00,0.00),('22','242','2','36',442,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','36',443,'15','1',446636.71,447263.92,627.21,103489.65,0.00,0.00,0.00,0.00,0.00),('22','242','2','36',444,'16','1',274099.32,274477.00,377.68,62317.20,0.00,0.00,0.00,0.00,0.00),('22','242','3','37',445,'4','2',788376.10,789715.37,1339.27,1004452.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','37',446,'5','2',1096310.57,1099420.04,3109.47,2332102.50,0.00,0.00,0.00,0.00,0.00),('22','242','4','37',447,'6','2',967988.43,969418.43,1430.00,1072500.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','37',448,'7','1',639461.76,640691.40,1229.64,202890.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','37',449,'8','1',723795.08,725749.95,1954.87,322553.55,0.00,0.00,0.00,0.00,0.00),('22','242','1','37',450,'9','1',726905.55,728361.66,1456.11,240258.15,0.00,0.00,0.00,0.00,0.00),('22','242','1','37',451,'10','1',619482.42,620514.03,1031.61,170215.65,0.00,0.00,0.00,0.00,0.00),('22','242','2','37',452,'11','1',893981.32,895775.24,1793.92,295996.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','37',453,'12','1',706341.42,707940.24,1598.82,263805.30,0.00,0.00,0.00,0.00,0.00),('22','242','2','37',454,'13','1',471519.38,472422.45,903.07,149006.55,0.00,0.00,0.00,0.00,0.00),('22','242','2','37',455,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','37',456,'15','1',447263.92,447982.89,718.97,118630.05,0.00,0.00,0.00,0.00,0.00),('22','242','2','37',457,'16','1',274477.00,274884.84,407.84,67293.60,0.00,0.00,0.00,0.00,0.00),('22','242','3','38',458,'4','2',789715.37,793892.25,4176.88,3132660.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','38',459,'5','2',1099420.04,1102996.69,3576.65,2682487.50,0.00,0.00,0.00,0.00,0.00),('22','242','4','38',460,'6','2',969418.43,971015.69,1597.26,1197945.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','38',461,'7','1',640691.40,642864.45,2173.05,358553.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','38',462,'8','1',725749.95,727191.18,1441.23,237802.95,0.00,0.00,0.00,0.00,0.00),('22','242','1','38',463,'9','1',728361.66,729694.60,1332.94,219935.10,0.00,0.00,0.00,0.00,0.00),('22','242','1','38',464,'10','1',620514.03,621886.44,1372.41,226447.65,0.00,0.00,0.00,0.00,0.00),('22','242','2','38',465,'11','1',895775.24,896804.64,1029.40,169851.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','38',466,'12','1',707940.24,709383.62,1443.38,238157.70,0.00,0.00,0.00,0.00,0.00),('22','242','2','38',467,'13','1',472422.45,473653.23,1230.78,203078.70,0.00,0.00,0.00,0.00,0.00),('22','242','2','38',468,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','38',469,'15','1',447982.89,448443.57,460.68,76012.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','38',470,'16','1',274884.84,274993.92,109.08,17998.20,0.00,0.00,0.00,0.00,0.00),('22','242','3','39',471,'4','2',793892.25,795174.26,1282.01,961507.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','39',472,'5','2',1102996.69,1104801.88,1805.19,1353892.50,0.00,0.00,0.00,0.00,0.00),('22','242','4','39',473,'6','2',971015.69,973993.71,2978.02,2233515.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','39',474,'7','1',642864.45,644373.74,1509.29,249032.85,0.00,0.00,0.00,0.00,0.00),('22','242','1','39',475,'8','1',727191.18,728694.67,1503.49,248075.85,0.00,0.00,0.00,0.00,0.00),('22','242','1','39',476,'9','1',729694.60,731192.88,1498.28,247216.20,0.00,0.00,0.00,0.00,0.00),('22','242','1','39',477,'10','1',621886.44,623389.68,1503.24,248034.60,0.00,0.00,0.00,0.00,0.00),('22','242','2','39',478,'11','1',896804.64,897791.45,986.81,162823.65,0.00,0.00,0.00,0.00,0.00),('22','242','1','39',479,'12','1',709383.62,710754.03,1370.41,226117.65,0.00,0.00,0.00,0.00,0.00),('22','242','2','39',480,'13','1',473653.23,474816.23,1163.00,191895.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','39',481,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','39',482,'15','1',448443.57,449197.16,753.59,124342.35,0.00,0.00,0.00,0.00,0.00),('22','242','2','39',483,'16','1',274993.92,275208.12,214.20,35343.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','40',484,'4','2',795174.26,796933.86,1759.60,1363690.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','40',485,'5','2',1104801.88,1106126.67,1324.79,1026712.25,0.00,0.00,0.00,0.00,0.00),('22','242','4','40',486,'6','2',973993.71,976410.72,2417.01,1873182.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','40',487,'7','1',644373.74,645375.94,1002.20,165363.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','40',488,'8','1',728694.67,729611.26,916.59,151237.35,0.00,0.00,0.00,0.00,0.00),('22','242','1','40',489,'9','1',731192.88,732515.44,1322.56,218222.40,0.00,0.00,0.00,0.00,0.00),('22','242','1','40',490,'10','1',623389.68,624898.27,1508.59,248917.35,0.00,0.00,0.00,0.00,0.00),('22','242','2','40',491,'11','1',897791.45,899149.48,1358.03,224074.95,0.00,0.00,0.00,0.00,0.00),('22','242','1','40',492,'12','1',710754.03,712177.22,1423.19,234826.35,0.00,0.00,0.00,0.00,0.00),('22','242','2','40',493,'13','1',474816.23,475815.72,999.49,164915.85,0.00,0.00,0.00,0.00,0.00),('22','242','2','40',494,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','40',495,'15','1',449197.16,449382.28,185.12,30544.80,0.00,0.00,0.00,0.00,0.00),('22','242','2','40',496,'16','1',275208.12,276232.01,1023.89,168941.85,0.00,0.00,0.00,0.00,0.00),('22','242','3','41',497,'4','2',796933.86,798640.69,1706.83,1322793.25,0.00,0.00,0.00,0.00,0.00),('22','242','3','41',498,'5','2',1106126.67,1108131.46,2004.79,1553712.25,0.00,0.00,0.00,0.00,0.00),('22','242','4','41',499,'6','2',976410.72,978910.72,2500.00,1937500.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','41',500,'7','1',645375.94,646434.69,1058.75,174693.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','41',501,'8','1',729611.26,731063.05,1451.79,239545.35,0.00,0.00,0.00,0.00,0.00),('22','242','1','41',502,'9','1',732515.44,733405.75,890.31,146901.15,0.00,0.00,0.00,0.00,0.00),('22','242','1','41',503,'10','1',624898.27,626066.64,1168.37,192781.05,0.00,0.00,0.00,0.00,0.00),('22','242','2','41',504,'11','1',899149.48,901013.45,1863.97,307555.05,0.00,0.00,0.00,0.00,0.00),('22','242','1','41',505,'12','1',712177.22,713386.95,1209.73,199605.45,0.00,0.00,0.00,0.00,0.00),('22','242','2','41',506,'13','1',475815.72,477158.84,1343.12,221614.80,0.00,0.00,0.00,0.00,0.00),('22','242','2','41',507,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','41',508,'15','1',449382.28,449550.51,168.23,27757.95,0.00,0.00,0.00,0.00,0.00),('22','242','2','41',509,'16','1',276232.01,276256.26,24.25,4001.25,0.00,0.00,0.00,0.00,0.00),('22','242','3','42',510,'4','2',798640.69,798775.49,134.80,107840.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','42',511,'5','2',1108131.46,1108390.76,259.30,207440.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','42',512,'6','2',978910.72,979410.72,500.00,400000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','42',513,'7','1',646434.69,647254.46,819.77,135262.05,0.00,0.00,0.00,0.00,0.00),('22','242','1','42',514,'8','1',731063.05,731874.49,811.44,133887.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','42',515,'9','1',733405.75,734177.11,771.36,127274.40,0.00,0.00,0.00,0.00,0.00),('22','242','1','42',516,'10','1',626066.64,626646.57,579.93,95688.45,0.00,0.00,0.00,0.00,0.00),('22','242','2','42',517,'11','1',901013.45,901306.24,292.79,48310.35,0.00,0.00,0.00,0.00,0.00),('22','242','1','42',518,'12','1',713386.95,713585.74,198.79,32800.35,0.00,0.00,0.00,0.00,0.00),('22','242','2','42',519,'13','1',477158.84,477309.88,151.04,24921.60,0.00,0.00,0.00,0.00,0.00),('22','242','2','42',520,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','42',521,'15','1',449550.51,449550.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','42',522,'16','1',276256.26,276256.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','43',523,'4','2',798775.49,799694.55,919.06,735248.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','43',524,'5','2',1108390.76,1110240.23,1849.47,1479576.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','43',525,'6','2',979410.72,981691.07,2280.35,1824280.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','43',526,'7','1',647254.46,648272.09,1017.63,167908.95,0.00,0.00,0.00,0.00,0.00),('22','242','1','43',527,'8','1',731874.49,733078.07,1203.58,198590.70,0.00,0.00,0.00,0.00,0.00),('22','242','1','43',528,'9','1',734177.11,735255.63,1078.52,177955.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','43',529,'10','1',626646.57,628135.74,1489.17,245713.05,0.00,0.00,0.00,0.00,0.00),('22','242','2','43',530,'11','1',901306.24,902955.00,1648.76,272045.40,0.00,0.00,0.00,0.00,0.00),('22','242','1','43',531,'12','1',713585.74,715759.72,2173.98,358706.70,0.00,0.00,0.00,0.00,0.00),('22','242','2','43',532,'13','1',477309.88,478425.87,1115.99,184138.35,0.00,0.00,0.00,0.00,0.00),('22','242','2','43',533,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','43',534,'15','1',449550.51,449550.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','43',535,'16','1',276256.26,276256.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','44',536,'4','2',799694.55,801030.88,1336.33,1069064.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','44',537,'5','2',1110240.23,1112654.02,2413.79,1931032.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','44',538,'6','2',981691.07,983341.07,1650.00,1320000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','44',539,'7','1',648272.09,649348.16,1076.07,177551.55,0.00,0.00,0.00,0.00,0.00),('22','242','1','44',540,'8','1',733078.07,734122.33,1044.26,172302.90,0.00,0.00,0.00,0.00,0.00),('22','242','1','44',541,'9','1',735255.63,736454.08,1198.45,197744.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','44',542,'10','1',628135.74,629177.20,1041.46,171840.90,0.00,0.00,0.00,0.00,0.00),('22','242','2','44',543,'11','1',902955.00,905142.20,2187.20,360888.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','44',544,'12','1',715759.72,716633.38,873.66,144153.90,0.00,0.00,0.00,0.00,0.00),('22','242','2','44',545,'13','1',478425.87,479431.33,1005.46,165900.90,0.00,0.00,0.00,0.00,0.00),('22','242','2','44',546,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','44',547,'15','1',449550.51,450693.05,1142.54,188519.10,0.00,0.00,0.00,0.00,0.00),('22','242','2','44',548,'16','1',276256.26,277001.55,745.29,122972.85,0.00,0.00,0.00,0.00,0.00),('22','242','3','45',549,'4','2',801030.88,802104.05,1073.17,858536.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','45',550,'5','2',1112654.02,1114664.14,2010.12,1608096.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','45',551,'6','2',983341.07,984629.54,1288.47,1030776.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','45',552,'7','1',649348.16,649490.56,142.40,23496.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','45',553,'8','1',734122.33,734200.07,77.74,12827.10,0.00,0.00,0.00,0.00,0.00),('22','242','1','45',554,'9','1',736454.08,736473.51,19.43,3205.95,0.00,0.00,0.00,0.00,0.00),('22','242','1','45',555,'10','1',629177.20,629195.38,18.18,2999.70,0.00,0.00,0.00,0.00,0.00),('22','242','2','45',556,'11','1',905142.20,905536.33,394.13,65031.45,0.00,0.00,0.00,0.00,0.00),('22','242','1','45',557,'12','1',716633.38,716830.67,197.29,32552.85,0.00,0.00,0.00,0.00,0.00),('22','242','2','45',558,'13','1',479431.33,479643.24,211.91,34965.15,0.00,0.00,0.00,0.00,0.00),('22','242','2','45',559,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','45',560,'15','1',450693.05,450820.88,127.83,21091.95,0.00,0.00,0.00,0.00,0.00),('22','242','2','45',561,'16','1',277001.55,277062.15,60.60,9999.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','46',562,'4','2',802104.05,803146.74,1042.69,834152.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','46',563,'5','2',1114664.14,1116446.06,1781.92,1425536.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','46',564,'6','2',984629.54,986049.54,1420.00,1136000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','46',565,'7','1',649490.56,651002.42,1511.86,249456.90,0.00,0.00,0.00,0.00,0.00),('22','242','1','46',566,'8','1',734200.07,735402.94,1202.87,198473.55,0.00,0.00,0.00,0.00,0.00),('22','242','1','46',567,'9','1',736473.51,737411.83,938.32,154822.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','46',568,'10','1',629195.38,630338.74,1143.36,188654.40,0.00,0.00,0.00,0.00,0.00),('22','242','2','46',569,'11','1',905536.33,907471.34,1935.01,319276.65,0.00,0.00,0.00,0.00,0.00),('22','242','1','46',570,'12','1',716830.67,717519.62,688.95,113676.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','46',571,'13','1',479643.24,481237.37,1594.13,263031.45,0.00,0.00,0.00,0.00,0.00),('22','242','2','46',572,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','46',573,'15','1',450820.88,451455.87,634.99,104773.35,0.00,0.00,0.00,0.00,0.00),('22','242','2','46',574,'16','1',277062.15,277062.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','47',575,'4','2',803146.74,804142.19,995.45,796360.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','47',576,'5','2',1116446.06,1118254.03,1807.97,1446376.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','47',577,'6','2',986049.54,987843.65,1794.11,1435288.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','47',578,'7','1',651002.42,652730.61,1728.19,285151.35,0.00,0.00,0.00,0.00,0.00),('22','242','1','47',579,'8','1',735402.94,737243.56,1840.62,303702.30,0.00,0.00,0.00,0.00,0.00),('22','242','1','47',580,'9','1',737411.83,738924.08,1512.25,249521.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','47',581,'10','1',630338.74,631666.86,1328.12,219139.80,0.00,0.00,0.00,0.00,0.00),('22','242','2','47',582,'11','1',907471.34,908549.66,1078.32,177922.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','47',583,'12','1',717519.62,718687.33,1167.71,192672.15,0.00,0.00,0.00,0.00,0.00),('22','242','2','47',584,'13','1',481237.37,481943.48,706.11,116508.15,0.00,0.00,0.00,0.00,0.00),('22','242','2','47',585,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','47',586,'15','1',451455.87,452056.86,600.99,99163.35,0.00,0.00,0.00,0.00,0.00),('22','242','2','47',587,'16','1',277062.15,277560.28,498.13,82191.45,0.00,0.00,0.00,0.00,0.00),('22','242','3','48',588,'4','2',804142.19,804928.68,786.49,629192.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','48',589,'5','2',1118254.03,1119526.08,1272.05,1017640.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','48',590,'6','2',987843.65,989143.65,1300.00,1040000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','48',591,'7','1',652730.61,654515.04,1784.43,294430.95,0.00,0.00,0.00,0.00,0.00),('22','242','1','48',592,'8','1',737243.56,737895.60,652.04,107586.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','48',593,'9','1',738924.08,740432.25,1508.17,248848.05,0.00,0.00,0.00,0.00,0.00),('22','242','1','48',594,'10','1',631666.86,633232.25,1565.39,258289.35,0.00,0.00,0.00,0.00,0.00),('22','242','2','48',595,'11','1',908549.66,909769.66,1220.00,201300.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','48',596,'12','1',718687.33,720555.98,1868.65,308327.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','48',597,'13','1',481943.48,481943.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','48',598,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','48',599,'15','1',452056.86,452803.18,746.32,123142.80,0.00,0.00,0.00,0.00,0.00),('22','242','2','48',600,'16','1',277560.28,277931.47,371.19,61246.35,0.00,0.00,0.00,0.00,0.00),('22','242','3','49',601,'4','2',804928.68,805161.85,233.17,186536.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','49',602,'5','2',1119526.08,1119859.66,333.58,266864.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','49',603,'6','2',989143.65,989143.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','49',604,'7','1',654515.04,655731.42,1216.38,200702.70,0.00,0.00,0.00,0.00,0.00),('22','242','1','49',605,'8','1',737895.60,738755.13,859.53,141822.45,0.00,0.00,0.00,0.00,0.00),('22','242','1','49',606,'9','1',740432.25,741257.45,825.20,136158.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','49',607,'10','1',633232.25,634152.48,920.23,151837.95,0.00,0.00,0.00,0.00,0.00),('22','242','2','49',608,'11','1',909769.66,910676.18,906.52,149575.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','49',609,'12','1',720555.98,721092.88,536.90,88588.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','49',610,'13','1',481943.48,481943.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','49',611,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','49',612,'15','1',452803.18,453174.74,371.56,61307.40,0.00,0.00,0.00,0.00,0.00),('22','242','2','49',613,'16','1',277931.47,278194.03,262.56,43322.40,0.00,0.00,0.00,0.00,0.00),('22','242','3','50',614,'4','2',805161.85,805914.06,752.21,601768.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','50',615,'5','2',1119859.66,1121531.17,1671.51,1337208.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','50',616,'6','2',989143.65,991829.01,2685.36,2148288.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','50',617,'7','1',655731.42,661232.00,5500.58,907595.70,0.00,0.00,0.00,0.00,0.00),('22','242','1','50',618,'8','1',738755.13,744746.44,5991.31,988566.15,0.00,0.00,0.00,0.00,0.00),('22','242','1','50',619,'9','1',741257.45,743512.18,2254.73,372030.45,0.00,0.00,0.00,0.00,0.00),('22','242','1','50',620,'10','1',634152.48,635717.09,1564.61,258160.65,0.00,0.00,0.00,0.00,0.00),('22','242','2','50',621,'11','1',910676.18,913934.51,3258.33,537624.45,0.00,0.00,0.00,0.00,0.00),('22','242','1','50',622,'12','1',721092.88,724060.98,2968.10,489736.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','50',623,'13','1',481943.48,481979.84,36.36,5999.40,0.00,0.00,0.00,0.00,0.00),('22','242','2','50',624,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','50',625,'15','1',453174.74,457248.50,4073.76,672170.40,0.00,0.00,0.00,0.00,0.00),('22','242','2','50',626,'16','1',278194.03,282006.90,3812.87,629123.55,0.00,0.00,0.00,0.00,0.00),('22','242','3','51',627,'4','2',805914.06,806921.67,1007.61,806088.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','51',628,'5','2',1121531.17,1122632.73,1101.56,881248.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','51',629,'6','2',991829.01,993074.01,1245.00,996000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','51',630,'7','1',661232.00,665484.33,4252.33,701634.45,0.00,0.00,0.00,0.00,0.00),('22','242','1','51',631,'8','1',744746.44,749536.39,4789.95,790341.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','51',632,'9','1',743512.18,744571.36,1059.18,174764.70,0.00,0.00,0.00,0.00,0.00),('22','242','1','51',633,'10','1',635717.09,636683.72,966.63,159493.95,0.00,0.00,0.00,0.00,0.00),('22','242','2','51',634,'11','1',913934.51,915072.07,1137.56,187697.40,0.00,0.00,0.00,0.00,0.00),('22','242','1','51',635,'12','1',724060.98,730163.40,6102.42,1006899.30,0.00,0.00,0.00,0.00,0.00),('22','242','2','51',636,'13','1',481979.84,482126.86,147.02,24258.30,0.00,0.00,0.00,0.00,0.00),('22','242','2','51',637,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','51',638,'15','1',457248.50,460420.21,3171.71,523332.15,0.00,0.00,0.00,0.00,0.00),('22','242','2','51',639,'16','1',282006.90,285802.34,3795.44,626247.60,0.00,0.00,0.00,0.00,0.00),('22','242','3','52',640,'4','2',806921.67,808607.13,1685.46,1348368.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','52',641,'5','2',1122632.73,1124431.02,1798.29,1438632.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','52',642,'6','2',993074.01,994164.01,1090.00,872000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','52',643,'7','1',665484.33,665484.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','52',644,'8','1',749536.39,749964.90,428.51,70704.15,0.00,0.00,0.00,0.00,0.00),('22','242','1','52',645,'9','1',744571.36,744571.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','52',646,'10','1',636683.72,636683.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','52',647,'11','1',915072.07,915072.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','52',648,'12','1',730163.40,730163.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','52',649,'13','1',482126.86,482126.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','52',650,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','52',651,'15','1',460420.21,460420.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','52',652,'16','1',285802.34,285802.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','53',653,'4','2',808607.13,809729.72,1122.59,898072.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','53',654,'5','2',1124431.02,1125566.05,1135.03,908024.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','53',655,'6','2',994164.01,995449.01,1285.00,1028000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','53',656,'7','1',665484.33,667627.76,2143.43,385817.40,0.00,0.00,0.00,0.00,0.00),('22','242','1','53',657,'8','1',749964.90,752062.95,2098.05,377649.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','53',658,'9','1',744571.36,744571.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','53',659,'10','1',636683.72,636683.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','53',660,'11','1',915072.07,915072.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','53',661,'12','1',730163.40,730163.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','53',662,'13','1',482126.86,482126.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','53',663,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','53',664,'15','1',460420.21,461769.80,1349.59,242926.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','53',665,'16','1',285802.34,287504.81,1702.47,306444.60,0.00,0.00,0.00,0.00,0.00),('22','242','3','54',666,'4','2',809729.72,809729.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','54',667,'5','2',1125566.05,1125566.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','54',668,'6','2',995449.01,995449.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','54',669,'7','1',667627.76,667627.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','54',670,'8','1',752062.95,752062.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','54',671,'9','1',744571.36,744571.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','54',672,'10','1',636683.72,636683.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','54',673,'11','1',915072.07,915072.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','54',674,'12','1',730163.40,730163.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','54',675,'13','1',482126.86,482126.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','54',676,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','54',677,'15','1',461769.80,461769.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','54',678,'16','1',287504.81,287504.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','55',679,'4','2',809729.72,810336.10,606.38,485104.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','55',680,'5','2',1125566.05,1127081.84,1515.79,1212632.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','55',681,'6','2',995449.01,996429.01,980.00,784000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','55',682,'7','1',667627.76,668422.32,794.56,131102.40,0.00,0.00,0.00,0.00,0.00),('22','242','1','55',683,'8','1',752062.95,753088.14,1025.19,169156.35,0.00,0.00,0.00,0.00,0.00),('22','242','1','55',684,'9','1',744571.36,745270.19,698.83,115306.95,0.00,0.00,0.00,0.00,0.00),('22','242','1','55',685,'10','1',636683.72,637541.51,857.79,141535.35,0.00,0.00,0.00,0.00,0.00),('22','242','2','55',686,'11','1',915072.07,915667.60,595.53,98262.45,0.00,0.00,0.00,0.00,0.00),('22','242','1','55',687,'12','1',730163.40,730561.10,397.70,65620.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','55',688,'13','1',482126.86,483053.00,926.14,152813.10,0.00,0.00,0.00,0.00,0.00),('22','242','2','55',689,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','55',690,'15','1',461769.80,462284.19,514.39,84874.35,0.00,0.00,0.00,0.00,0.00),('22','242','2','55',691,'16','1',287504.81,287770.97,266.16,43916.40,0.00,0.00,0.00,0.00,0.00),('22','242','3','56',692,'4','2',810336.10,810982.20,646.10,516880.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','56',693,'5','2',1127081.84,1128242.25,1160.41,928328.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','56',694,'6','2',996429.01,997589.01,1160.00,928000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','56',695,'7','1',668422.32,670621.72,2199.40,362901.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','56',696,'8','1',753088.14,754864.52,1776.38,293102.70,0.00,0.00,0.00,0.00,0.00),('22','242','1','56',697,'9','1',745270.19,745964.07,693.88,114490.20,0.00,0.00,0.00,0.00,0.00),('22','242','1','56',698,'10','1',637541.51,638196.44,654.93,108063.45,0.00,0.00,0.00,0.00,0.00),('22','242','2','56',699,'11','1',915667.60,917160.33,1492.73,246300.45,0.00,0.00,0.00,0.00,0.00),('22','242','1','56',700,'12','1',730561.10,732129.66,1568.56,258812.40,0.00,0.00,0.00,0.00,0.00),('22','242','2','56',701,'13','1',483053.00,483965.18,912.18,150509.70,0.00,0.00,0.00,0.00,0.00),('22','242','2','56',702,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','56',703,'15','1',462284.19,463164.80,880.61,145300.65,0.00,0.00,0.00,0.00,0.00),('22','242','2','56',704,'16','1',287770.97,288135.80,364.83,60196.95,0.00,0.00,0.00,0.00,0.00),('22','242','3','57',705,'4','2',810982.20,811211.84,229.64,183712.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','57',706,'5','2',1128242.25,1128472.58,230.33,184264.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','57',707,'6','2',997589.01,997589.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','57',708,'7','1',670621.72,670931.69,309.97,51145.05,0.00,0.00,0.00,0.00,0.00),('22','242','1','57',709,'8','1',754864.52,755804.65,940.13,155121.45,0.00,0.00,0.00,0.00,0.00),('22','242','1','57',710,'9','1',745964.07,747425.77,1461.70,241180.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','57',711,'10','1',638196.44,639574.99,1378.55,227460.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','57',712,'11','1',917160.33,918089.97,929.64,153390.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','57',713,'12','1',732129.66,732360.20,230.54,38039.10,0.00,0.00,0.00,0.00,0.00),('22','242','2','57',714,'13','1',483965.18,484271.42,306.24,50529.60,0.00,0.00,0.00,0.00,0.00),('22','242','2','57',715,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','57',716,'15','1',463164.80,463164.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','57',717,'16','1',288135.80,288178.22,42.42,6999.30,0.00,0.00,0.00,0.00,0.00),('22','242','3','58',718,'4','2',811211.84,812161.68,949.84,759872.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','58',719,'5','2',1128472.58,1129713.91,1241.33,993064.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','58',720,'6','2',997589.01,999219.01,1630.00,1304000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','58',721,'7','1',670931.69,672309.55,1377.86,227346.90,0.00,0.00,0.00,0.00,0.00),('22','242','1','58',722,'8','1',755804.65,757840.59,2035.94,335930.10,0.00,0.00,0.00,0.00,0.00),('22','242','1','58',723,'9','1',747425.77,748839.68,1413.91,233295.15,0.00,0.00,0.00,0.00,0.00),('22','242','1','58',724,'10','1',639574.99,640561.00,986.01,162691.65,0.00,0.00,0.00,0.00,0.00),('22','242','2','58',725,'11','1',918089.97,921057.19,2967.22,489591.30,0.00,0.00,0.00,0.00,0.00),('22','242','1','58',726,'12','1',732360.20,733913.87,1553.67,256355.55,0.00,0.00,0.00,0.00,0.00),('22','242','2','58',727,'13','1',484271.42,485942.94,1671.52,275800.80,0.00,0.00,0.00,0.00,0.00),('22','242','2','58',728,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','58',729,'15','1',463164.80,463164.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','58',730,'16','1',288178.22,288178.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','59',731,'4','2',812161.68,813041.93,880.25,704200.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','59',732,'5','2',1129713.91,1130957.81,1243.90,995120.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','59',733,'6','2',999219.01,999669.01,450.00,360000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','59',734,'7','1',672309.55,674755.90,2446.35,403647.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','59',735,'8','1',757840.59,760322.91,2482.32,409582.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','59',736,'9','1',748839.68,750052.75,1213.07,200156.55,0.00,0.00,0.00,0.00,0.00),('22','242','1','59',737,'10','1',640561.00,641927.52,1366.52,225475.80,0.00,0.00,0.00,0.00,0.00),('22','242','2','59',738,'11','1',921057.19,923840.39,2783.20,459228.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','59',739,'12','1',733913.87,734887.21,973.34,160601.10,0.00,0.00,0.00,0.00,0.00),('22','242','2','59',740,'13','1',485942.94,487166.22,1223.28,201841.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','59',741,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','59',742,'15','1',463164.80,463164.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','59',743,'16','1',288178.22,288178.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','60',744,'4','2',813041.93,813988.06,946.13,756904.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','60',745,'5','2',1130957.81,1131778.90,821.09,656872.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','60',746,'6','2',999669.01,1003683.14,4014.13,3211304.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','60',747,'7','1',674755.90,675703.07,947.17,156283.05,0.00,0.00,0.00,0.00,0.00),('22','242','1','60',748,'8','1',760322.91,762455.80,2132.89,351926.85,0.00,0.00,0.00,0.00,0.00),('22','242','1','60',749,'9','1',750052.75,751391.93,1339.18,220964.70,0.00,0.00,0.00,0.00,0.00),('22','242','1','60',750,'10','1',641927.52,644342.84,2415.32,398527.80,0.00,0.00,0.00,0.00,0.00),('22','242','2','60',751,'11','1',923840.39,925843.54,2003.15,330519.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','60',752,'12','1',734887.21,736544.83,1657.62,273507.30,0.00,0.00,0.00,0.00,0.00),('22','242','2','60',753,'13','1',487166.22,489402.38,2236.16,368966.40,0.00,0.00,0.00,0.00,0.00),('22','242','2','60',754,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','60',755,'15','1',463164.80,463165.48,0.68,112.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','60',756,'16','1',288178.22,288180.19,1.97,325.05,0.00,0.00,0.00,0.00,0.00),('22','242','3','61',757,'4','2',813988.06,815198.63,1210.57,968456.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','61',758,'5','2',1131778.90,1132726.98,948.08,758464.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','61',759,'6','2',1003683.14,1004473.14,790.00,632000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','61',760,'7','1',675703.07,676450.87,747.80,123387.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','61',761,'8','1',762455.80,763957.94,1502.14,247853.10,0.00,0.00,0.00,0.00,0.00),('22','242','1','61',762,'9','1',751391.93,753292.15,1900.22,313536.30,0.00,0.00,0.00,0.00,0.00),('22','242','1','61',763,'10','1',644342.84,646514.10,2171.26,358257.90,0.00,0.00,0.00,0.00,0.00),('22','242','2','61',764,'11','1',925843.54,926926.71,1083.17,178723.05,0.00,0.00,0.00,0.00,0.00),('22','242','1','61',765,'12','1',736544.83,739099.21,2554.38,421472.70,0.00,0.00,0.00,0.00,0.00),('22','242','2','61',766,'13','1',489402.38,490768.76,1366.38,225452.70,0.00,0.00,0.00,0.00,0.00),('22','242','2','61',767,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','61',768,'15','1',463165.48,463165.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','61',769,'16','1',288180.19,288180.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','62',770,'4','2',815198.63,815924.92,726.29,581032.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','62',771,'5','2',1132726.98,1133563.60,836.62,669296.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','62',772,'6','2',1004473.14,1005315.07,841.93,673544.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','62',773,'7','1',676450.87,678888.15,2437.28,402151.20,0.00,0.00,0.00,0.00,0.00),('22','242','1','62',774,'8','1',763957.94,766364.37,2406.43,397060.95,0.00,0.00,0.00,0.00,0.00),('22','242','1','62',775,'9','1',753292.15,754613.47,1321.32,218017.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','62',776,'10','1',646514.10,647895.12,1381.02,227868.30,0.00,0.00,0.00,0.00,0.00),('22','242','2','62',777,'11','1',926926.71,929051.06,2124.35,350517.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','62',778,'12','1',739099.21,740788.72,1689.51,278769.15,0.00,0.00,0.00,0.00,0.00),('22','242','2','62',779,'13','1',490768.76,492344.51,1575.75,259998.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','62',780,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','62',781,'15','1',463165.48,463165.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','62',782,'16','1',288180.19,288180.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','63',783,'4','2',815924.92,816848.73,923.81,739048.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','63',784,'5','2',1133563.60,1135052.59,1488.99,1191192.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','63',785,'6','2',1005315.07,1006365.07,1050.00,840000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','63',786,'7','1',678888.15,681634.80,2746.65,453197.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','63',787,'8','1',766364.37,769403.24,3038.87,501413.55,0.00,0.00,0.00,0.00,0.00),('22','242','1','63',788,'9','1',754613.47,756591.20,1977.73,326325.45,0.00,0.00,0.00,0.00,0.00),('22','242','1','63',789,'10','1',647895.12,649296.73,1401.61,231265.65,0.00,0.00,0.00,0.00,0.00),('22','242','2','63',790,'11','1',929051.06,931287.33,2236.27,368984.55,0.00,0.00,0.00,0.00,0.00),('22','242','1','63',791,'12','1',740788.72,743349.21,2560.49,422480.85,0.00,0.00,0.00,0.00,0.00),('22','242','2','63',792,'13','1',492344.51,496094.99,3750.48,618829.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','63',793,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','63',794,'15','1',463165.48,463165.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','63',795,'16','1',288180.19,288180.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','64',796,'4','2',816848.73,817122.10,273.37,218696.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','64',797,'5','2',1135052.59,1135366.00,313.41,250728.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','64',798,'6','2',1006365.07,1007365.07,1000.00,800000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','64',799,'7','1',681634.80,683059.18,1424.38,235022.70,0.00,0.00,0.00,0.00,0.00),('22','242','1','64',800,'8','1',769403.24,770745.98,1342.74,221552.10,0.00,0.00,0.00,0.00,0.00),('22','242','1','64',801,'9','1',756591.20,757834.51,1243.31,205146.15,0.00,0.00,0.00,0.00,0.00),('22','242','1','64',802,'10','1',649296.73,650453.30,1156.57,190834.05,0.00,0.00,0.00,0.00,0.00),('22','242','2','64',803,'11','1',931287.33,932297.80,1010.47,166727.55,0.00,0.00,0.00,0.00,0.00),('22','242','1','64',804,'12','1',743349.21,744215.60,866.39,142954.35,0.00,0.00,0.00,0.00,0.00),('22','242','2','64',805,'13','1',496094.99,498517.46,2422.47,399707.55,0.00,0.00,0.00,0.00,0.00),('22','242','2','64',806,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','64',807,'15','1',463165.48,463165.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','64',808,'16','1',288180.19,288180.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','65',809,'4','2',817122.10,818168.24,1046.14,836912.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','65',810,'5','2',1135366.00,1136606.23,1240.23,992184.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','65',811,'6','2',1007365.07,1008045.07,680.00,544000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','65',812,'7','1',683059.18,686152.89,3093.71,525930.70,0.00,0.00,0.00,0.00,0.00),('22','242','1','65',813,'8','1',770745.98,774451.56,3705.58,629948.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','65',814,'9','1',757834.51,760286.36,2451.85,416814.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','65',815,'10','1',650453.30,652802.82,2349.52,399418.40,0.00,0.00,0.00,0.00,0.00),('22','242','2','65',816,'11','1',932297.80,935226.93,2929.13,497952.10,0.00,0.00,0.00,0.00,0.00),('22','242','1','65',817,'12','1',744215.60,749088.97,4873.37,828472.90,0.00,0.00,0.00,0.00,0.00),('22','242','2','65',818,'13','1',498517.46,505743.01,7225.55,1228343.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','65',819,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','65',820,'15','1',463165.48,464957.83,1792.35,304699.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','65',821,'16','1',288180.19,290188.16,2007.97,341354.90,0.00,0.00,0.00,0.00,0.00),('22','242','3','66',822,'4','2',818168.24,819067.61,899.37,719496.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','66',823,'5','2',1136606.23,1138002.05,1395.82,1116656.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','66',824,'6','2',1008045.07,1009095.07,1050.00,840000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','66',825,'7','1',686152.89,686700.61,547.72,98589.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','66',826,'8','1',774451.56,775461.23,1009.67,181740.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','66',827,'9','1',760286.36,761101.19,814.83,146669.40,0.00,0.00,0.00,0.00,0.00),('22','242','1','66',828,'10','1',652802.82,653337.67,534.85,96273.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','66',829,'11','1',935226.93,937292.05,2065.12,371721.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','66',830,'12','1',749088.97,749632.26,543.29,97792.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','66',831,'13','1',505743.01,507403.41,1660.40,298872.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','66',832,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','66',833,'15','1',464957.83,465036.43,78.60,14148.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','66',834,'16','1',290188.16,290218.42,30.26,5446.80,0.00,0.00,0.00,0.00,0.00),('22','242','3','67',835,'4','2',819067.61,820383.67,1316.06,1052848.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','67',836,'5','2',1138002.05,1139196.08,1194.03,955224.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','67',837,'6','2',1009095.07,1010495.07,1400.00,1120000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','67',838,'7','1',686700.61,688592.12,1891.51,349929.35,0.00,0.00,0.00,0.00,0.00),('22','242','1','67',839,'8','1',775461.23,777081.18,1619.95,299690.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','67',840,'9','1',761101.19,761101.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','67',841,'10','1',653337.67,653337.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','67',842,'11','1',937292.05,938155.86,863.81,159804.85,0.00,0.00,0.00,0.00,0.00),('22','242','1','67',843,'12','1',749632.26,750232.45,600.19,111035.15,0.00,0.00,0.00,0.00,0.00),('22','242','2','67',844,'13','1',507403.41,509615.13,2211.72,409168.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','67',845,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','67',846,'15','1',465036.43,465036.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','67',847,'16','1',290218.42,290218.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','68',848,'4','2',820383.67,821736.26,1352.59,1082072.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','68',849,'5','2',1139196.08,1140250.97,1054.89,843912.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','68',850,'6','2',1010495.07,1011680.01,1184.94,947952.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','68',851,'7','1',688592.12,690022.16,1430.04,264557.40,0.00,0.00,0.00,0.00,0.00),('22','242','1','68',852,'8','1',777081.18,778638.70,1557.52,288141.20,0.00,0.00,0.00,0.00,0.00),('22','242','1','68',853,'9','1',761101.19,762372.65,1271.46,235220.10,0.00,0.00,0.00,0.00,0.00),('22','242','1','68',854,'10','1',653337.67,654356.99,1019.32,188574.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','68',855,'11','1',938155.86,938225.86,70.00,12950.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','68',856,'12','1',750232.45,752931.11,2698.66,499252.10,0.00,0.00,0.00,0.00,0.00),('22','242','2','68',857,'13','1',509615.13,509701.83,86.70,16039.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','68',858,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','68',859,'15','1',465036.43,465036.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','68',860,'16','1',290218.42,290218.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','69',861,'4','2',821736.26,822963.35,1227.09,981672.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','69',862,'5','2',1140250.97,1142100.84,1849.87,1479896.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','69',863,'6','2',1011680.01,1012958.76,1278.75,1023000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','69',864,'7','1',690022.16,690022.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','69',865,'8','1',778638.70,778638.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','69',866,'9','1',762372.65,762407.44,34.79,6436.15,0.00,0.00,0.00,0.00,0.00),('22','242','1','69',867,'10','1',654356.99,654356.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','69',868,'11','1',938225.86,938275.19,49.33,9126.05,0.00,0.00,0.00,0.00,0.00),('22','242','1','69',869,'12','1',752931.11,752931.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','69',870,'13','1',509701.83,511348.57,1646.74,304646.90,0.00,0.00,0.00,0.00,0.00),('22','242','2','69',871,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','69',872,'15','1',465036.43,465036.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','69',873,'16','1',290218.42,290218.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','70',874,'4','2',822963.35,823603.31,639.96,511968.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','70',875,'5','2',1142100.84,1143012.84,912.00,729600.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','70',876,'6','2',1012958.76,1014418.76,1460.00,1168000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','70',877,'7','1',690022.16,690022.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','70',878,'8','1',778638.70,778638.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','70',879,'9','1',762407.44,762407.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','70',880,'10','1',654356.99,654356.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','70',881,'11','1',938275.19,938466.94,191.75,35473.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','70',882,'12','1',752931.11,752931.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','70',883,'13','1',511348.57,511348.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','70',884,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','70',885,'15','1',465036.43,465036.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','70',886,'16','1',290218.42,290218.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','71',887,'4','2',823603.31,823944.77,341.46,273168.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','71',888,'5','2',1143012.84,1143978.96,966.12,772896.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','71',889,'6','2',1014418.76,1014968.76,550.00,440000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','71',890,'7','1',690022.16,690022.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','71',891,'8','1',778638.70,778638.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','71',892,'9','1',762407.44,762407.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','71',893,'10','1',654356.99,654356.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','71',894,'11','1',938466.94,938490.37,23.43,4334.55,0.00,0.00,0.00,0.00,0.00),('22','242','1','71',895,'12','1',752931.11,752931.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','71',896,'13','1',511348.57,511348.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','71',897,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','71',898,'15','1',465036.43,465036.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','71',899,'16','1',290218.42,290218.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','72',900,'4','2',823944.77,824752.20,807.43,645944.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','72',901,'5','2',1143978.96,1144550.98,572.02,457616.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','72',902,'6','2',1014968.76,1014968.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','72',903,'7','1',690022.16,691211.64,1189.48,220053.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','72',904,'8','1',778638.70,780843.57,2204.87,407900.95,0.00,0.00,0.00,0.00,0.00),('22','242','1','72',905,'9','1',762407.44,764136.98,1729.54,319964.90,0.00,0.00,0.00,0.00,0.00),('22','242','1','72',906,'10','1',654356.99,655902.62,1545.63,285941.55,0.00,0.00,0.00,0.00,0.00),('22','242','2','72',907,'11','1',938490.37,940610.04,2119.67,392138.95,0.00,0.00,0.00,0.00,0.00),('22','242','1','72',908,'12','1',752931.11,753710.24,779.13,144139.05,0.00,0.00,0.00,0.00,0.00),('22','242','2','72',909,'13','1',511348.57,513098.10,1749.53,323663.05,0.00,0.00,0.00,0.00,0.00),('22','242','2','72',910,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','72',911,'15','1',465036.43,465800.21,763.78,141299.30,0.00,0.00,0.00,0.00,0.00),('22','242','2','72',912,'16','1',290218.42,291455.77,1237.35,228909.75,0.00,0.00,0.00,0.00,0.00),('22','242','3','73',913,'4','2',824752.20,825327.88,575.68,460544.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','73',914,'5','2',1144550.98,1145651.96,1100.98,880784.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','73',915,'6','2',1014968.76,1015968.76,1000.00,800000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','73',916,'7','1',691211.64,692154.07,942.43,174349.55,0.00,0.00,0.00,0.00,0.00),('22','242','1','73',917,'8','1',780843.57,782825.84,1982.27,366719.95,0.00,0.00,0.00,0.00,0.00),('22','242','1','73',918,'9','1',764136.98,765848.91,1711.93,316707.05,0.00,0.00,0.00,0.00,0.00),('22','242','1','73',919,'10','1',655902.62,657935.36,2032.74,376056.90,0.00,0.00,0.00,0.00,0.00),('22','242','2','73',920,'11','1',940610.04,941362.95,752.91,139288.35,0.00,0.00,0.00,0.00,0.00),('22','242','1','73',921,'12','1',753710.24,755570.26,1860.02,344103.70,0.00,0.00,0.00,0.00,0.00),('22','242','2','73',922,'13','1',513098.10,513912.63,814.53,150688.05,0.00,0.00,0.00,0.00,0.00),('22','242','2','73',923,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','73',924,'15','1',465800.21,466887.80,1087.59,201204.15,0.00,0.00,0.00,0.00,0.00),('22','242','2','73',925,'16','1',291455.77,291874.00,418.23,77372.55,0.00,0.00,0.00,0.00,0.00),('22','242','3','74',926,'4','2',825327.88,826480.05,1152.17,921736.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','74',927,'5','2',1145651.96,1146570.99,919.03,735224.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','74',928,'6','2',1015968.76,1016448.76,480.00,384000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','74',929,'7','1',692154.07,693812.48,1658.41,306805.85,0.00,0.00,0.00,0.00,0.00),('22','242','1','74',930,'8','1',782825.84,784858.21,2032.37,375988.45,0.00,0.00,0.00,0.00,0.00),('22','242','1','74',931,'9','1',765848.91,767264.66,1415.75,261913.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','74',932,'10','1',657935.36,659527.56,1592.20,294557.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','74',933,'11','1',941362.95,943087.60,1724.65,319060.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','74',934,'12','1',755570.26,757375.02,1804.76,333880.60,0.00,0.00,0.00,0.00,0.00),('22','242','2','74',935,'13','1',513912.63,515479.80,1567.17,289926.45,0.00,0.00,0.00,0.00,0.00),('22','242','2','74',936,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','74',937,'15','1',466887.80,467972.43,1084.63,200656.55,0.00,0.00,0.00,0.00,0.00),('22','242','2','74',938,'16','1',291874.00,292869.12,995.12,184097.20,0.00,0.00,0.00,0.00,0.00),('22','242','3','75',939,'4','2',826480.05,827814.77,1334.72,1067776.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','75',940,'5','2',1146570.99,1147845.96,1274.97,1019976.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','75',941,'6','2',1016448.76,1016918.76,470.00,376000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','75',942,'7','1',693812.48,694902.48,1090.00,201650.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','75',943,'8','1',784858.21,786146.84,1288.63,238396.55,0.00,0.00,0.00,0.00,0.00),('22','242','1','75',944,'9','1',767264.66,767683.25,418.59,77439.15,0.00,0.00,0.00,0.00,0.00),('22','242','1','75',945,'10','1',659527.56,660264.75,737.19,136380.15,0.00,0.00,0.00,0.00,0.00),('22','242','2','75',946,'11','1',943087.60,943107.61,20.01,3701.85,0.00,0.00,0.00,0.00,0.00),('22','242','1','75',947,'12','1',757375.02,758753.05,1378.03,254935.55,0.00,0.00,0.00,0.00,0.00),('22','242','2','75',948,'13','1',515479.80,515479.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','75',949,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','75',950,'15','1',467972.43,468606.64,634.21,117328.85,0.00,0.00,0.00,0.00,0.00),('22','242','2','75',951,'16','1',292869.12,293399.17,530.05,98059.25,0.00,0.00,0.00,0.00,0.00),('22','242','3','76',952,'4','2',827814.77,828965.86,1151.09,920872.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','76',953,'5','2',1147845.96,1149130.43,1284.47,1027576.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','76',954,'6','2',1016918.76,1019018.75,2099.99,1679992.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','76',955,'7','1',694902.48,695302.24,399.76,73955.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','76',956,'8','1',786146.84,786497.54,350.70,64879.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','76',957,'9','1',767683.25,768240.36,557.11,103065.35,0.00,0.00,0.00,0.00,0.00),('22','242','1','76',958,'10','1',660264.75,661070.48,805.73,149060.05,0.00,0.00,0.00,0.00,0.00),('22','242','2','76',959,'11','1',943107.61,943574.37,466.76,86350.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','76',960,'12','1',758753.05,759621.01,867.96,160572.60,0.00,0.00,0.00,0.00,0.00),('22','242','2','76',961,'13','1',515479.80,515846.16,366.36,67776.60,0.00,0.00,0.00,0.00,0.00),('22','242','2','76',962,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','76',963,'15','1',468606.64,468973.67,367.03,67900.55,0.00,0.00,0.00,0.00,0.00),('22','242','2','76',964,'16','1',293399.17,293696.26,297.09,54961.65,0.00,0.00,0.00,0.00,0.00),('22','242','3','77',965,'4','2',828965.86,829620.62,654.76,523808.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','77',966,'5','2',1149130.43,1149944.67,814.24,651392.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','77',967,'6','2',1019018.75,1020895.50,1876.75,1501400.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','77',968,'7','1',695302.24,696048.18,745.94,137998.90,0.00,0.00,0.00,0.00,0.00),('22','242','1','77',969,'8','1',786497.54,787352.44,854.90,158156.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','77',970,'9','1',768240.36,769227.59,987.23,182637.55,0.00,0.00,0.00,0.00,0.00),('22','242','1','77',971,'10','1',661070.48,661823.25,752.77,139262.45,0.00,0.00,0.00,0.00,0.00),('22','242','2','77',972,'11','1',943574.37,944211.72,637.35,117909.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','77',973,'12','1',759621.01,760779.10,1158.09,214246.65,0.00,0.00,0.00,0.00,0.00),('22','242','2','77',974,'13','1',515846.16,516557.21,711.05,131544.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','77',975,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','77',976,'15','1',468973.67,469676.62,702.95,130045.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','77',977,'16','1',293696.26,294470.43,774.17,143221.45,0.00,0.00,0.00,0.00,0.00),('22','242','3','78',978,'4','2',829620.62,830098.19,477.57,382056.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','78',979,'5','2',1149944.67,1150009.99,65.32,52256.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','78',980,'6','2',1020895.50,1021495.50,600.00,480000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','78',981,'7','1',696048.18,696635.96,587.78,105800.40,0.00,0.00,0.00,0.00,0.00),('22','242','1','78',982,'8','1',787352.44,788467.61,1115.17,200730.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','78',983,'9','1',769227.59,769687.64,460.05,82809.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','78',984,'10','1',661823.25,662594.37,771.12,138801.60,0.00,0.00,0.00,0.00,0.00),('22','242','2','78',985,'11','1',944211.72,944528.06,316.34,56941.20,0.00,0.00,0.00,0.00,0.00),('22','242','1','78',986,'12','1',760779.10,761714.19,935.09,168316.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','78',987,'13','1',516557.21,517910.86,1353.65,243657.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','78',988,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','78',989,'15','1',469676.62,469676.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','78',990,'16','1',294470.43,294470.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','79',991,'4','2',830098.19,832478.13,2379.94,1903952.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','79',992,'5','2',1150009.99,1150518.35,508.36,406688.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','79',993,'6','2',1021495.50,1021675.50,180.00,144000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','79',994,'7','1',696635.96,697389.31,753.35,139369.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','79',995,'8','1',788467.61,789556.38,1088.77,201422.45,0.00,0.00,0.00,0.00,0.00),('22','242','1','79',996,'9','1',769687.64,770266.55,578.91,107098.35,0.00,0.00,0.00,0.00,0.00),('22','242','1','79',997,'10','1',662594.37,663150.70,556.33,102921.05,0.00,0.00,0.00,0.00,0.00),('22','242','2','79',998,'11','1',944528.06,945833.62,1305.56,241528.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','79',999,'12','1',761714.19,762169.17,454.98,84171.30,0.00,0.00,0.00,0.00,0.00),('22','242','2','79',1000,'13','1',517910.86,518943.30,1032.44,191001.40,0.00,0.00,0.00,0.00,0.00),('22','242','2','79',1001,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','79',1002,'15','1',469676.62,469969.63,293.01,54206.85,0.00,0.00,0.00,0.00,0.00),('22','242','2','79',1003,'16','1',294470.43,294647.93,177.50,32837.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','80',1004,'4','2',832478.13,833224.22,746.09,596872.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','80',1005,'5','2',1150518.35,1151761.81,1243.46,994768.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','80',1006,'6','2',1021675.50,1021855.50,180.00,144000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','80',1007,'7','1',697389.31,698418.52,1029.21,190403.85,0.00,0.00,0.00,0.00,0.00),('22','242','1','80',1008,'8','1',789556.38,790548.84,992.46,183605.10,0.00,0.00,0.00,0.00,0.00),('22','242','1','80',1009,'9','1',770266.55,770968.88,702.33,129931.05,0.00,0.00,0.00,0.00,0.00),('22','242','1','80',1010,'10','1',663150.70,663951.18,800.48,148088.80,0.00,0.00,0.00,0.00,0.00),('22','242','2','80',1011,'11','1',945833.62,946380.88,547.26,101243.10,0.00,0.00,0.00,0.00,0.00),('22','242','1','80',1012,'12','1',762169.17,763289.18,1120.01,207201.85,0.00,0.00,0.00,0.00,0.00),('22','242','2','80',1013,'13','1',518943.30,519724.83,781.53,144583.05,0.00,0.00,0.00,0.00,0.00),('22','242','2','80',1014,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','80',1015,'15','1',469969.63,470467.16,497.53,92043.05,0.00,0.00,0.00,0.00,0.00),('22','242','2','80',1016,'16','1',294647.93,294990.81,342.88,63432.80,0.00,0.00,0.00,0.00,0.00),('22','242','3','81',1017,'4','2',833224.22,834747.03,1522.81,1218248.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','81',1018,'5','2',1151761.81,1153060.03,1298.22,1038576.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','81',1019,'6','2',1021855.50,1023944.58,2089.08,1671264.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','81',1020,'7','1',698418.52,699184.84,766.32,141769.20,0.00,0.00,0.00,0.00,0.00),('22','242','1','81',1021,'8','1',790548.84,791508.81,959.97,177594.45,0.00,0.00,0.00,0.00,0.00),('22','242','1','81',1022,'9','1',770968.88,771666.22,697.34,129007.90,0.00,0.00,0.00,0.00,0.00),('22','242','1','81',1023,'10','1',663951.18,664616.09,664.91,123008.35,0.00,0.00,0.00,0.00,0.00),('22','242','2','81',1024,'11','1',946380.88,947433.46,1052.58,194727.30,0.00,0.00,0.00,0.00,0.00),('22','242','1','81',1025,'12','1',763289.18,764685.28,1396.10,258278.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','81',1026,'13','1',519724.83,519898.97,174.14,32215.90,0.00,0.00,0.00,0.00,0.00),('22','242','2','81',1027,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','81',1028,'15','1',470467.16,471646.21,1179.05,218124.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','81',1029,'16','1',294990.81,296100.40,1109.59,205274.15,0.00,0.00,0.00,0.00,0.00),('22','242','3','82',1030,'4','2',834747.03,835736.05,989.02,791216.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','82',1031,'5','2',1153060.03,1154059.46,999.43,799544.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','82',1032,'6','2',1023944.58,1025284.58,1340.00,1072000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','82',1033,'7','1',699184.84,699943.89,759.05,140424.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','82',1034,'8','1',791508.81,792638.40,1129.59,208974.15,0.00,0.00,0.00,0.00,0.00),('22','242','1','82',1035,'9','1',771666.22,772253.15,586.93,108582.05,0.00,0.00,0.00,0.00,0.00),('22','242','1','82',1036,'10','1',664616.09,665494.94,878.85,162587.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','82',1037,'11','1',947433.46,948013.08,579.62,107229.70,0.00,0.00,0.00,0.00,0.00),('22','242','1','82',1038,'12','1',764685.28,765256.16,570.88,105612.80,0.00,0.00,0.00,0.00,0.00),('22','242','2','82',1039,'13','1',519898.97,520624.55,725.58,134232.30,0.00,0.00,0.00,0.00,0.00),('22','242','2','82',1040,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','82',1041,'15','1',471646.21,472258.30,612.09,113236.65,0.00,0.00,0.00,0.00,0.00),('22','242','2','82',1042,'16','1',296100.40,296496.81,396.41,73335.85,0.00,0.00,0.00,0.00,0.00),('22','242','3','83',1043,'4','2',835736.05,837023.20,1287.15,1029720.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','83',1044,'5','2',1154059.46,1154794.45,734.99,587992.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','83',1045,'6','2',1025284.58,1025814.58,530.00,424000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','83',1046,'7','1',699943.89,700949.13,1005.24,185969.40,0.00,0.00,0.00,0.00,0.00),('22','242','1','83',1047,'8','1',792638.40,793715.49,1077.09,199261.65,0.00,0.00,0.00,0.00,0.00),('22','242','1','83',1048,'9','1',772253.15,772715.16,462.01,85471.85,0.00,0.00,0.00,0.00,0.00),('22','242','1','83',1049,'10','1',665494.94,665883.33,388.39,71852.15,0.00,0.00,0.00,0.00,0.00),('22','242','2','83',1050,'11','1',948013.08,948874.72,861.64,159403.40,0.00,0.00,0.00,0.00,0.00),('22','242','1','83',1051,'12','1',765256.16,765682.74,426.58,78917.30,0.00,0.00,0.00,0.00,0.00),('22','242','2','83',1052,'13','1',520624.55,521713.72,1089.17,201496.45,0.00,0.00,0.00,0.00,0.00),('22','242','2','83',1053,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','83',1054,'15','1',472258.30,472781.68,523.38,96825.30,0.00,0.00,0.00,0.00,0.00),('22','242','2','83',1055,'16','1',296496.81,296604.22,107.41,19870.85,0.00,0.00,0.00,0.00,0.00),('22','242','3','84',1056,'4','2',837023.20,837597.63,574.43,459544.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','84',1057,'5','2',1154794.45,1155409.42,614.97,491976.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','84',1058,'6','2',1025814.58,1027517.58,1703.00,1362400.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','84',1059,'7','1',700949.13,701883.69,934.56,172893.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','84',1060,'8','1',793715.49,794722.46,1006.97,186289.45,0.00,0.00,0.00,0.00,0.00),('22','242','1','84',1061,'9','1',772715.16,773129.58,414.42,76667.70,0.00,0.00,0.00,0.00,0.00),('22','242','1','84',1062,'10','1',665883.33,666529.84,646.51,119604.35,0.00,0.00,0.00,0.00,0.00),('22','242','2','84',1063,'11','1',948874.72,948965.36,90.64,16768.40,0.00,0.00,0.00,0.00,0.00),('22','242','1','84',1064,'12','1',765682.74,766295.22,612.48,113308.80,0.00,0.00,0.00,0.00,0.00),('22','242','2','84',1065,'13','1',521713.72,522154.69,440.97,81579.45,0.00,0.00,0.00,0.00,0.00),('22','242','2','84',1066,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','84',1067,'15','1',472781.68,473260.83,479.15,88642.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','84',1068,'16','1',296604.22,296811.09,206.87,38270.95,0.00,0.00,0.00,0.00,0.00),('22','242','3','85',1069,'4','2',837597.63,837819.72,222.09,177672.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','85',1070,'5','2',1155409.42,1155473.58,64.16,51328.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','85',1071,'6','2',1027517.58,1027717.58,200.00,160000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','85',1072,'7','1',701883.69,701923.00,39.31,7272.35,0.00,0.00,0.00,0.00,0.00),('22','242','1','85',1073,'8','1',794722.46,795001.24,278.78,51574.30,0.00,0.00,0.00,0.00,0.00),('22','242','1','85',1074,'9','1',773129.58,773629.47,499.89,92479.65,0.00,0.00,0.00,0.00,0.00),('22','242','1','85',1075,'10','1',666529.84,667005.46,475.62,87989.70,0.00,0.00,0.00,0.00,0.00),('22','242','2','85',1076,'11','1',948965.36,949401.81,436.45,80743.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','85',1077,'12','1',766295.22,766613.43,318.21,58868.85,0.00,0.00,0.00,0.00,0.00),('22','242','2','85',1078,'13','1',522154.69,522346.49,191.80,35483.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','85',1079,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','85',1080,'15','1',473260.83,473354.80,93.97,17384.45,0.00,0.00,0.00,0.00,0.00),('22','242','2','85',1081,'16','1',296811.09,297039.86,228.77,42322.45,0.00,0.00,0.00,0.00,0.00),('22','242','3','86',1082,'4','2',837819.72,838891.84,1072.12,857696.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','86',1083,'5','2',1155473.58,1156535.36,1061.78,849424.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','86',1084,'6','2',1027717.58,1029718.24,2000.66,1600528.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','86',1085,'7','1',701923.00,702785.46,862.46,159555.10,0.00,0.00,0.00,0.00,0.00),('22','242','1','86',1086,'8','1',795001.24,796187.62,1186.38,219480.30,0.00,0.00,0.00,0.00,0.00),('22','242','1','86',1087,'9','1',773629.47,774554.05,924.58,171047.30,0.00,0.00,0.00,0.00,0.00),('22','242','1','86',1088,'10','1',667005.46,667921.88,916.42,169537.70,0.00,0.00,0.00,0.00,0.00),('22','242','2','86',1089,'11','1',949401.81,949998.19,596.38,110330.30,0.00,0.00,0.00,0.00,0.00),('22','242','1','86',1090,'12','1',766613.43,767136.05,522.62,96684.70,0.00,0.00,0.00,0.00,0.00),('22','242','2','86',1091,'13','1',522346.49,522874.60,528.11,97700.35,0.00,0.00,0.00,0.00,0.00),('22','242','2','86',1092,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','86',1093,'15','1',473354.80,473779.14,424.34,78502.90,0.00,0.00,0.00,0.00,0.00),('22','242','2','86',1094,'16','1',297039.86,297281.56,241.70,44714.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','87',1095,'4','2',838891.84,839888.14,996.30,797040.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','87',1096,'5','2',1156535.36,1157371.04,835.68,668544.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','87',1097,'6','2',1029718.24,1030918.24,1200.00,960000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','87',1098,'7','1',702785.46,704004.10,1218.64,225448.40,0.00,0.00,0.00,0.00,0.00),('22','242','1','87',1099,'8','1',796187.62,797582.23,1394.61,258002.85,0.00,0.00,0.00,0.00,0.00),('22','242','1','87',1100,'9','1',774554.05,775084.15,530.10,98068.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','87',1101,'10','1',667921.88,668437.54,515.66,95397.10,0.00,0.00,0.00,0.00,0.00),('22','242','2','87',1102,'11','1',949998.19,950763.07,764.88,141502.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','87',1103,'12','1',767136.05,767467.50,331.45,61318.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','87',1104,'13','1',522874.60,523409.08,534.48,98878.80,0.00,0.00,0.00,0.00,0.00),('22','242','2','87',1105,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','87',1106,'15','1',473779.14,474288.75,509.61,94277.85,0.00,0.00,0.00,0.00,0.00),('22','242','2','87',1107,'16','1',297281.56,297478.32,196.76,36400.60,0.00,0.00,0.00,0.00,0.00),('22','242','3','88',1108,'4','2',839888.14,840416.77,528.63,422904.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','88',1109,'5','2',1157371.04,1158400.40,1029.36,823488.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','88',1110,'6','2',1030918.24,1031835.24,917.00,733600.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','88',1111,'7','1',704004.10,704854.06,849.96,157242.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','88',1112,'8','1',797582.23,798314.36,732.13,135444.05,0.00,0.00,0.00,0.00,0.00),('22','242','1','88',1113,'9','1',775084.15,775821.77,737.62,136459.70,0.00,0.00,0.00,0.00,0.00),('22','242','1','88',1114,'10','1',668437.54,669170.01,732.47,135506.95,0.00,0.00,0.00,0.00,0.00),('22','242','2','88',1115,'11','1',950763.07,951075.97,312.90,57886.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','88',1116,'12','1',767467.50,767749.46,281.96,52162.60,0.00,0.00,0.00,0.00,0.00),('22','242','2','88',1117,'13','1',523409.08,523893.89,484.81,89689.85,0.00,0.00,0.00,0.00,0.00),('22','242','2','88',1118,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','88',1119,'15','1',474288.75,474747.26,458.51,84824.35,0.00,0.00,0.00,0.00,0.00),('22','242','2','88',1120,'16','1',297478.32,298111.31,632.99,117103.15,0.00,0.00,0.00,0.00,0.00),('22','242','3','89',1121,'4','2',840416.77,841290.99,874.22,699376.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','89',1122,'5','2',1158400.40,1159412.36,1011.96,809568.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','89',1123,'6','2',1031835.24,1032020.24,185.00,148000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','89',1124,'7','1',704854.06,705678.26,824.20,140114.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','89',1125,'8','1',798314.36,799236.95,922.59,156840.30,0.00,0.00,0.00,0.00,0.00),('22','242','1','89',1126,'9','1',775821.77,777096.60,1274.83,216721.10,0.00,0.00,0.00,0.00,0.00),('22','242','1','89',1127,'10','1',669170.01,671041.44,1871.43,318143.10,0.00,0.00,0.00,0.00,0.00),('22','242','2','89',1128,'11','1',951075.97,951771.80,695.83,118291.10,0.00,0.00,0.00,0.00,0.00),('22','242','1','89',1129,'12','1',767749.46,769000.52,1251.06,212680.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','89',1130,'13','1',523893.89,524886.41,992.52,168728.40,0.00,0.00,0.00,0.00,0.00),('22','242','2','89',1131,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','89',1132,'15','1',474747.26,474747.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','89',1133,'16','1',298111.31,298111.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','90',1134,'4','2',841290.99,841960.67,669.68,535744.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','90',1135,'5','2',1159412.36,1160452.24,1039.88,831904.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','90',1136,'6','2',1032020.24,1033000.24,980.00,784000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','90',1137,'7','1',705678.26,706958.51,1280.25,217642.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','90',1138,'8','1',799236.95,800379.72,1142.77,194270.90,0.00,0.00,0.00,0.00,0.00),('22','242','1','90',1139,'9','1',777096.60,778269.53,1172.93,199398.10,0.00,0.00,0.00,0.00,0.00),('22','242','1','90',1140,'10','1',671041.44,672198.71,1157.27,196735.90,0.00,0.00,0.00,0.00,0.00),('22','242','2','90',1141,'11','1',951771.80,952948.75,1176.95,200081.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','90',1142,'12','1',769000.52,769610.71,610.19,103732.30,0.00,0.00,0.00,0.00,0.00),('22','242','2','90',1143,'13','1',524886.41,525172.77,286.36,48681.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','90',1144,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','90',1145,'15','1',474747.26,475524.91,777.65,132200.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','90',1146,'16','1',298111.31,299347.80,1236.49,210203.30,0.00,0.00,0.00,0.00,0.00),('22','242','3','91',1147,'4','2',841960.67,842446.30,485.63,388504.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','91',1148,'5','2',1160452.24,1161080.75,628.51,502808.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','91',1149,'6','2',1033000.24,1033742.24,742.00,593600.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','91',1150,'7','1',706958.51,709364.40,2405.89,409001.30,0.00,0.00,0.00,0.00,0.00),('22','242','1','91',1151,'8','1',800379.72,801425.91,1046.19,177852.30,0.00,0.00,0.00,0.00,0.00),('22','242','1','91',1152,'9','1',778269.53,779218.14,948.61,161263.70,0.00,0.00,0.00,0.00,0.00),('22','242','1','91',1153,'10','1',672198.71,672958.83,760.12,129220.40,0.00,0.00,0.00,0.00,0.00),('22','242','2','91',1154,'11','1',952948.75,955648.57,2699.82,458969.40,0.00,0.00,0.00,0.00,0.00),('22','242','1','91',1155,'12','1',769610.71,770564.47,953.76,162139.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','91',1156,'13','1',525172.77,527199.42,2026.65,344530.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','91',1157,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','91',1158,'15','1',475524.91,476706.10,1181.19,200802.30,0.00,0.00,0.00,0.00,0.00),('22','242','2','91',1159,'16','1',299347.80,300344.56,996.76,169449.20,0.00,0.00,0.00,0.00,0.00),('22','242','3','92',1160,'4','2',842446.30,842587.44,141.14,112912.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','92',1161,'5','2',1161080.75,1161382.24,301.49,241192.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','92',1162,'6','2',1033742.24,1033872.24,130.00,104000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','92',1163,'7','1',709364.40,709788.20,423.80,72046.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','92',1164,'8','1',801425.91,802330.65,904.74,153805.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','92',1165,'9','1',779218.14,779881.21,663.07,112721.90,0.00,0.00,0.00,0.00,0.00),('22','242','1','92',1166,'10','1',672958.83,673337.59,378.76,64389.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','92',1167,'11','1',955648.57,957596.92,1948.35,331219.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','92',1168,'12','1',770564.47,771061.70,497.23,84529.10,0.00,0.00,0.00,0.00,0.00),('22','242','2','92',1169,'13','1',527199.42,527199.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','92',1170,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','92',1171,'15','1',476706.10,477045.09,338.99,57628.30,0.00,0.00,0.00,0.00,0.00),('22','242','2','92',1172,'16','1',300344.56,300564.36,219.80,37366.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','93',1173,'4','2',842587.44,843305.35,717.91,574328.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','93',1174,'5','2',1161382.24,1162331.04,948.80,759040.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','93',1175,'6','2',1033872.24,1034552.24,680.00,544000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','93',1176,'7','1',709788.20,710959.40,1171.20,199104.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','93',1177,'8','1',802330.65,803687.90,1357.25,230732.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','93',1178,'9','1',779881.21,781059.98,1178.77,200390.90,0.00,0.00,0.00,0.00,0.00),('22','242','1','93',1179,'10','1',673337.59,674817.34,1479.75,251557.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','93',1180,'11','1',957596.92,958351.54,754.62,128285.40,0.00,0.00,0.00,0.00,0.00),('22','242','1','93',1181,'12','1',771061.70,772546.52,1484.82,252419.40,0.00,0.00,0.00,0.00,0.00),('22','242','2','93',1182,'13','1',527199.42,527966.64,767.22,130427.40,0.00,0.00,0.00,0.00,0.00),('22','242','2','93',1183,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','93',1184,'15','1',477045.09,477810.14,765.05,130058.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','93',1185,'16','1',300564.36,301374.95,810.59,137800.30,0.00,0.00,0.00,0.00,0.00),('22','242','3','94',1186,'4','2',843305.35,844256.62,951.27,761016.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','94',1187,'5','2',1162331.04,1163111.75,780.71,624568.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','94',1188,'6','2',1034552.24,1035092.24,540.00,432000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','94',1189,'7','1',710959.40,712466.34,1506.94,256179.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','94',1190,'8','1',803687.90,804566.74,878.84,149402.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','94',1191,'9','1',781059.98,782191.32,1131.34,192327.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','94',1192,'10','1',674817.34,676205.32,1387.98,235956.60,0.00,0.00,0.00,0.00,0.00),('22','242','2','94',1193,'11','1',958351.54,959420.22,1068.68,181675.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','94',1194,'12','1',772546.52,773414.20,867.68,147505.60,0.00,0.00,0.00,0.00,0.00),('22','242','2','94',1195,'13','1',527966.64,529108.17,1141.53,194060.10,0.00,0.00,0.00,0.00,0.00),('22','242','2','94',1196,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','94',1197,'15','1',477810.14,478765.26,955.12,162370.40,0.00,0.00,0.00,0.00,0.00),('22','242','2','94',1198,'16','1',301374.95,302425.01,1050.06,178510.20,0.00,0.00,0.00,0.00,0.00),('22','242','3','95',1199,'4','2',844256.62,845108.20,851.58,681264.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','95',1200,'5','2',1163111.75,1164281.00,1169.25,935400.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','95',1201,'6','2',1035092.24,1036292.24,1200.00,960000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','95',1202,'7','1',712466.34,713877.06,1410.72,239822.40,0.00,0.00,0.00,0.00,0.00),('22','242','1','95',1203,'8','1',804566.74,805334.64,767.90,130543.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','95',1204,'9','1',782191.32,783119.34,928.02,157763.40,0.00,0.00,0.00,0.00,0.00),('22','242','1','95',1205,'10','1',676205.32,676995.41,790.09,134315.30,0.00,0.00,0.00,0.00,0.00),('22','242','2','95',1206,'11','1',959420.22,961252.14,1831.92,311426.40,0.00,0.00,0.00,0.00,0.00),('22','242','1','95',1207,'12','1',773414.20,774357.75,943.55,160403.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','95',1208,'13','1',529108.17,531382.36,2274.19,386612.30,0.00,0.00,0.00,0.00,0.00),('22','242','2','95',1209,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','95',1210,'15','1',478765.26,479620.94,855.68,145465.60,0.00,0.00,0.00,0.00,0.00),('22','242','2','95',1211,'16','1',302425.01,303078.33,653.32,111064.40,0.00,0.00,0.00,0.00,0.00),('22','242','3','96',1212,'4','2',845108.20,845474.83,366.63,293304.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','96',1213,'5','2',1164281.00,1164912.58,631.58,505264.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','96',1214,'6','2',1036292.24,1036647.22,354.98,283984.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','96',1215,'7','1',713877.06,715511.36,1634.30,277831.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','96',1216,'8','1',805334.64,806336.39,1001.75,170297.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','96',1217,'9','1',783119.34,784685.15,1565.81,266187.70,0.00,0.00,0.00,0.00,0.00),('22','242','1','96',1218,'10','1',676995.41,678358.22,1362.81,231677.70,0.00,0.00,0.00,0.00,0.00),('22','242','2','96',1219,'11','1',961252.14,961252.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','96',1220,'12','1',774357.75,775703.14,1345.39,228716.30,0.00,0.00,0.00,0.00,0.00),('22','242','2','96',1221,'13','1',531382.36,533089.48,1707.12,290210.40,0.00,0.00,0.00,0.00,0.00),('22','242','2','96',1222,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','96',1223,'15','1',479620.94,480364.30,743.36,126371.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','96',1224,'16','1',303078.33,303960.75,882.42,150011.40,0.00,0.00,0.00,0.00,0.00),('22','242','3','97',1225,'4','2',845474.83,846051.12,576.29,461032.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','97',1226,'5','2',1164912.58,1166198.12,1285.54,1028432.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','97',1227,'6','2',1036647.22,1036977.22,330.00,264000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','97',1228,'7','1',715511.36,716645.80,1134.44,192854.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','97',1229,'8','1',806336.39,807391.29,1054.90,179333.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','97',1230,'9','1',784685.15,785395.22,710.07,120711.90,0.00,0.00,0.00,0.00,0.00),('22','242','1','97',1231,'10','1',678358.22,679143.77,785.55,133543.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','97',1232,'11','1',961252.14,962181.80,929.66,158042.20,0.00,0.00,0.00,0.00,0.00),('22','242','1','97',1233,'12','1',775703.14,777352.40,1649.26,280374.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','97',1234,'13','1',533089.48,534233.74,1144.26,194524.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','97',1235,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','97',1236,'15','1',480364.30,481174.24,809.94,137689.80,0.00,0.00,0.00,0.00,0.00),('22','242','2','97',1237,'16','1',303960.75,304460.87,500.12,85020.40,0.00,0.00,0.00,0.00,0.00),('22','242','3','98',1238,'4','2',846051.12,846778.37,727.25,581800.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','98',1239,'5','2',1166198.12,1166667.17,469.05,375240.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','98',1240,'6','2',1036977.22,1037377.22,400.00,320000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','98',1241,'7','1',716645.80,717661.53,1015.73,177752.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','98',1242,'8','1',807391.29,808522.66,1131.37,197989.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','98',1243,'9','1',785395.22,786226.86,831.64,145537.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','98',1244,'10','1',679143.77,680243.40,1099.63,192435.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','98',1245,'11','1',962181.80,962994.37,812.57,142199.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','98',1246,'12','1',777352.40,778292.15,939.75,164456.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','98',1247,'13','1',534233.74,534233.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','98',1248,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','98',1249,'15','1',481174.24,481847.78,673.54,117869.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','98',1250,'16','1',304460.87,305194.40,733.53,128367.75,0.00,0.00,0.00,0.00,0.00),('22','242','3','99',1251,'4','2',846778.37,846994.13,215.76,172608.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','99',1252,'5','2',1166667.17,1166912.86,245.69,196552.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','99',1253,'6','2',1037377.22,1038077.22,700.00,560000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','99',1254,'7','1',717661.53,718645.33,983.80,172165.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','99',1255,'8','1',808522.66,809001.27,478.61,83756.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','99',1256,'9','1',786226.86,786735.50,508.64,89012.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','99',1257,'10','1',680243.40,680956.30,712.90,124757.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','99',1258,'11','1',962994.37,963875.17,880.80,154140.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','99',1259,'12','1',778292.15,778583.58,291.43,51000.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','99',1260,'13','1',534233.74,534726.02,492.28,86149.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','99',1261,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','99',1262,'15','1',481847.78,482209.84,362.06,63360.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','99',1263,'16','1',305194.40,305680.00,485.60,84980.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','100',1264,'4','2',846994.13,847830.68,836.55,669240.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','100',1265,'5','2',1166912.86,1167647.14,734.28,587424.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','100',1266,'6','2',1038077.22,1038442.22,365.00,292000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','100',1267,'7','1',718645.33,718645.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','100',1268,'8','1',809001.27,809001.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','100',1269,'9','1',786735.50,786735.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','100',1270,'10','1',680956.30,680956.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','100',1271,'11','1',963875.17,966187.20,2312.03,404605.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','100',1272,'12','1',778583.58,778583.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','100',1273,'13','1',534726.02,535753.65,1027.63,179835.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','100',1274,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','100',1275,'15','1',482209.84,483281.08,1071.24,187467.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','100',1276,'16','1',305680.00,307024.50,1344.50,235287.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','101',1277,'4','2',847830.68,848556.02,725.34,580272.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','101',1278,'5','2',1167647.14,1168402.63,755.49,604392.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','101',1279,'6','2',1038442.22,1038627.22,185.00,148000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','101',1280,'7','1',718645.33,718645.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','101',1281,'8','1',809001.27,809001.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','101',1282,'9','1',786735.50,786735.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','101',1283,'10','1',680956.30,680956.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','101',1284,'11','1',966187.20,966187.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','101',1285,'12','1',778583.58,778583.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','101',1286,'13','1',535753.65,535768.65,15.00,2625.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','101',1287,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','101',1288,'15','1',483281.08,483281.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','101',1289,'16','1',307024.50,307024.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','102',1290,'4','2',848556.02,849050.14,494.12,395296.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','102',1291,'5','2',1168402.63,1169220.08,817.45,653960.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','102',1292,'6','2',1038627.22,1039167.22,540.00,432000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','102',1293,'7','1',718645.33,718645.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','102',1294,'8','1',809001.27,809001.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','102',1295,'9','1',786735.50,786735.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','102',1296,'10','1',680956.30,680956.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','102',1297,'11','1',966187.20,966202.20,15.00,2625.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','102',1298,'12','1',778583.58,778583.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','102',1299,'13','1',535768.65,535810.07,41.42,7248.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','102',1300,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','102',1301,'15','1',483281.08,483281.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','102',1302,'16','1',307024.50,307024.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','103',1303,'4','2',849050.14,849535.93,485.79,388632.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','103',1304,'5','2',1169220.08,1170012.96,792.88,634304.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','103',1305,'6','2',1039167.22,1041013.20,1845.98,1476784.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','103',1306,'7','1',718645.33,718645.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','103',1307,'8','1',809001.27,809001.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','103',1308,'9','1',786735.50,786735.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','103',1309,'10','1',680956.30,680956.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','103',1310,'11','1',966202.20,966202.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','103',1311,'12','1',778583.58,778583.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','103',1312,'13','1',535810.07,535877.92,67.85,11873.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','103',1313,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','103',1314,'15','1',483281.08,483281.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','103',1315,'16','1',307024.50,307024.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','104',1316,'4','2',849535.93,849535.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','104',1317,'5','2',1170012.96,1170012.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','104',1318,'6','2',1041013.20,1041013.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','104',1319,'7','1',718645.33,718645.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','104',1320,'8','1',809001.27,809001.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','104',1321,'9','1',786735.50,786735.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','104',1322,'10','1',680956.30,680956.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','104',1323,'11','1',966202.20,966202.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','104',1324,'12','1',778583.58,778583.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','104',1325,'13','1',535877.92,535877.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','104',1326,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','104',1327,'15','1',483281.08,483281.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','104',1328,'16','1',307024.50,307024.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','105',1329,'4','2',849535.93,850759.55,1223.62,978896.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','105',1330,'5','2',1170012.96,1170692.74,679.78,543824.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','105',1331,'6','2',1041013.20,1041583.20,570.00,456000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','105',1332,'7','1',718645.33,719205.60,560.27,100848.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','105',1333,'8','1',809001.27,809404.59,403.32,72597.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','105',1334,'9','1',786735.50,787133.27,397.77,71598.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','105',1335,'10','1',680956.30,681276.30,320.00,57600.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','105',1336,'11','1',966202.20,966564.43,362.23,65201.40,0.00,0.00,0.00,0.00,0.00),('22','242','1','105',1337,'12','1',778583.58,778922.26,338.68,60962.40,0.00,0.00,0.00,0.00,0.00),('22','242','2','105',1338,'13','1',535877.92,536350.44,472.52,85053.60,0.00,0.00,0.00,0.00,0.00),('22','242','2','105',1339,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','105',1340,'15','1',483281.08,483558.24,277.16,49888.80,0.00,0.00,0.00,0.00,0.00),('22','242','2','105',1341,'16','1',307024.50,307285.47,260.97,46974.60,0.00,0.00,0.00,0.00,0.00),('22','242','3','106',1342,'4','2',850759.55,851478.57,719.02,575216.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','106',1343,'5','2',1170692.74,1171379.48,686.74,549392.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','106',1344,'6','2',1041583.20,1042183.20,600.00,480000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','106',1345,'7','1',719205.60,720248.22,1042.62,187671.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','106',1346,'8','1',809404.59,809946.40,541.81,97525.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','106',1347,'9','1',787133.27,787911.91,778.64,140155.20,0.00,0.00,0.00,0.00,0.00),('22','242','1','106',1348,'10','1',681276.30,682174.75,898.45,161721.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','106',1349,'11','1',966564.43,967741.81,1177.38,211928.40,0.00,0.00,0.00,0.00,0.00),('22','242','1','106',1350,'12','1',778922.26,778922.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','106',1351,'13','1',536350.44,536350.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','106',1352,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','106',1353,'15','1',483558.24,484047.86,489.62,88131.60,0.00,0.00,0.00,0.00,0.00),('22','242','2','106',1354,'16','1',307285.47,307640.99,355.52,63993.60,0.00,0.00,0.00,0.00,0.00),('22','242','3','107',1355,'4','2',851478.57,851719.74,241.17,192936.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','107',1356,'5','2',1171379.48,1171689.46,309.98,247984.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','107',1357,'6','2',1042183.20,1042775.70,592.50,474000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','107',1358,'7','1',720248.22,721039.55,791.33,142439.40,0.00,0.00,0.00,0.00,0.00),('22','242','1','107',1359,'8','1',809946.40,810307.39,360.99,64978.20,0.00,0.00,0.00,0.00,0.00),('22','242','1','107',1360,'9','1',787911.91,788811.98,900.07,162012.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','107',1361,'10','1',682174.75,682807.10,632.35,113823.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','107',1362,'11','1',967741.81,968478.71,736.90,132642.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','107',1363,'12','1',778922.26,779156.44,234.18,42152.40,0.00,0.00,0.00,0.00,0.00),('22','242','2','107',1364,'13','1',536350.44,536769.51,419.07,75432.60,0.00,0.00,0.00,0.00,0.00),('22','242','2','107',1365,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','107',1366,'15','1',484047.86,484349.75,301.89,54340.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','107',1367,'16','1',307640.99,307821.51,180.52,32493.60,0.00,0.00,0.00,0.00,0.00),('22','242','3','108',1368,'4','2',851719.74,852285.98,566.24,452992.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','108',1369,'5','2',1171689.46,1172424.39,734.93,587944.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','108',1370,'6','2',1042775.70,1043725.70,950.00,760000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','108',1371,'7','1',721039.55,723075.15,2035.60,366408.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','108',1372,'8','1',810307.39,811336.08,1028.69,185164.20,0.00,0.00,0.00,0.00,0.00),('22','242','1','108',1373,'9','1',788811.98,789818.02,1006.04,181087.20,0.00,0.00,0.00,0.00,0.00),('22','242','1','108',1374,'10','1',682807.10,683818.67,1011.57,182082.60,0.00,0.00,0.00,0.00,0.00),('22','242','2','108',1375,'11','1',968478.71,969211.76,733.05,131949.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','108',1376,'12','1',779156.44,779747.21,590.77,106338.60,0.00,0.00,0.00,0.00,0.00),('22','242','2','108',1377,'13','1',536769.51,537381.26,611.75,110115.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','108',1378,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','108',1379,'15','1',484349.75,484957.17,607.42,109335.60,0.00,0.00,0.00,0.00,0.00),('22','242','2','108',1380,'16','1',307821.51,308054.86,233.35,42003.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','109',1381,'4','2',852285.98,852948.84,662.86,530288.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','109',1382,'5','2',1172424.39,1173235.43,811.04,648832.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','109',1383,'6','2',1043725.70,1045125.70,1400.00,1120000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','109',1384,'7','1',723075.15,724321.30,1246.15,224307.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','109',1385,'8','1',811336.08,812083.64,747.56,134560.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','109',1386,'9','1',789818.02,790604.60,786.58,141584.40,0.00,0.00,0.00,0.00,0.00),('22','242','1','109',1387,'10','1',683818.67,684814.84,996.17,179310.60,0.00,0.00,0.00,0.00,0.00),('22','242','2','109',1388,'11','1',969211.76,970207.37,995.61,179209.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','109',1389,'12','1',779747.21,780675.76,928.55,167139.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','109',1390,'13','1',537381.26,538143.20,761.94,137149.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','109',1391,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','109',1392,'15','1',484957.17,485429.24,472.07,84972.60,0.00,0.00,0.00,0.00,0.00),('22','242','2','109',1393,'16','1',308054.86,308399.25,344.39,61990.20,0.00,0.00,0.00,0.00,0.00),('22','242','3','110',1394,'4','2',852948.84,853454.80,505.96,404768.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','110',1395,'5','2',1173235.43,1174254.89,1019.46,815568.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','110',1396,'6','2',1045125.70,1046398.70,1273.00,1018400.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','110',1397,'7','1',724321.30,725173.11,851.81,153325.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','110',1398,'8','1',812083.64,812534.05,450.41,81073.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','110',1399,'9','1',790604.60,791855.28,1250.68,225122.40,0.00,0.00,0.00,0.00,0.00),('22','242','1','110',1400,'10','1',684814.84,685704.91,890.07,160212.60,0.00,0.00,0.00,0.00,0.00),('22','242','2','110',1401,'11','1',970207.37,970207.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','110',1402,'12','1',780675.76,782192.59,1516.83,273029.40,0.00,0.00,0.00,0.00,0.00),('22','242','2','110',1403,'13','1',538143.20,538593.06,449.86,80974.80,0.00,0.00,0.00,0.00,0.00),('22','242','2','110',1404,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','110',1405,'15','1',485429.24,485878.64,449.40,80892.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','110',1406,'16','1',308399.25,308602.59,203.34,36601.20,0.00,0.00,0.00,0.00,0.00),('22','242','3','111',1407,'4','2',853454.80,853945.42,490.62,392496.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','111',1408,'5','2',1174254.89,1174703.17,448.28,358624.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','111',1409,'6','2',1046398.70,1046948.70,550.00,440000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','111',1410,'7','1',725173.11,726699.83,1526.72,274809.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','111',1411,'8','1',812534.05,812846.40,312.35,56223.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','111',1412,'9','1',791855.28,792820.54,965.26,173746.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','111',1413,'10','1',685704.91,686589.31,884.40,159192.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','111',1414,'11','1',970207.37,970515.83,308.46,55522.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','111',1415,'12','1',782192.59,782821.30,628.71,113167.80,0.00,0.00,0.00,0.00,0.00),('22','242','2','111',1416,'13','1',538593.06,538842.45,249.39,44890.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','111',1417,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','111',1418,'15','1',485878.64,486186.43,307.79,55402.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','111',1419,'16','1',308602.59,308749.48,146.89,26440.20,0.00,0.00,0.00,0.00,0.00),('22','242','3','112',1420,'4','2',853945.42,854712.49,767.07,613656.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','112',1421,'5','2',1174703.17,1175252.39,549.22,439376.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','112',1422,'6','2',1046948.70,1047748.70,800.00,640000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','112',1423,'7','1',726699.83,727532.19,832.36,149824.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','112',1424,'8','1',812846.40,813305.79,459.39,82690.20,0.00,0.00,0.00,0.00,0.00),('22','242','1','112',1425,'9','1',792820.54,793154.23,333.69,60064.20,0.00,0.00,0.00,0.00,0.00),('22','242','1','112',1426,'10','1',686589.31,687140.04,550.73,99131.40,0.00,0.00,0.00,0.00,0.00),('22','242','2','112',1427,'11','1',970515.83,971096.50,580.67,104520.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','112',1428,'12','1',782821.30,783121.52,300.22,54039.60,0.00,0.00,0.00,0.00,0.00),('22','242','2','112',1429,'13','1',538842.45,540019.96,1177.51,211951.80,0.00,0.00,0.00,0.00,0.00),('22','242','2','112',1430,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','112',1431,'15','1',486186.43,486474.46,288.03,51845.40,0.00,0.00,0.00,0.00,0.00),('22','242','2','112',1432,'16','1',308749.48,308973.21,223.73,40271.40,0.00,0.00,0.00,0.00,0.00),('22','242','3','113',1433,'4','2',854712.49,855027.47,314.98,251984.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','113',1434,'5','2',1175252.39,1175585.80,333.41,266728.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','113',1435,'6','2',1047748.70,1048158.70,410.00,328000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','113',1436,'7','1',727532.19,727532.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','113',1437,'8','1',813305.79,813305.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','113',1438,'9','1',793154.23,793154.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','113',1439,'10','1',687140.04,687140.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','113',1440,'11','1',971096.50,971096.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','113',1441,'12','1',783121.52,783121.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','113',1442,'13','1',540019.96,540120.50,100.54,18097.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','113',1443,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','113',1444,'15','1',486474.46,486474.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','113',1445,'16','1',308973.21,308973.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','114',1446,'4','2',855027.47,855226.57,199.10,159280.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','114',1447,'5','2',1175585.80,1175750.73,164.93,131944.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','114',1448,'6','2',1048158.70,1048158.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','114',1449,'7','1',727532.19,727532.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','114',1450,'8','1',813305.79,813305.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','114',1451,'9','1',793154.23,793154.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','114',1452,'10','1',687140.04,687140.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','114',1453,'11','1',971096.50,971126.50,30.00,5400.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','114',1454,'12','1',783121.52,783121.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','114',1455,'13','1',540120.50,540120.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','114',1456,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','114',1457,'15','1',486474.46,486474.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','114',1458,'16','1',308973.21,308973.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','115',1459,'4','2',855226.57,855766.22,539.65,431720.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','115',1460,'5','2',1175750.73,1176421.40,670.67,536536.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','115',1461,'6','2',1048158.70,1048458.70,300.00,240000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','115',1462,'7','1',727532.19,727909.50,377.31,67915.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','115',1463,'8','1',813305.79,813680.77,374.98,67496.40,0.00,0.00,0.00,0.00,0.00),('22','242','1','115',1464,'9','1',793154.23,793422.74,268.51,48331.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','115',1465,'10','1',687140.04,687452.98,312.94,56329.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','115',1466,'11','1',971126.50,971610.94,484.44,87199.20,0.00,0.00,0.00,0.00,0.00),('22','242','1','115',1467,'12','1',783121.52,783579.80,458.28,82490.40,0.00,0.00,0.00,0.00,0.00),('22','242','2','115',1468,'13','1',540120.50,540386.21,265.71,47827.80,0.00,0.00,0.00,0.00,0.00),('22','242','2','115',1469,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','115',1470,'15','1',486474.46,486809.29,334.83,60269.40,0.00,0.00,0.00,0.00,0.00),('22','242','2','115',1471,'16','1',308973.21,309084.55,111.34,20041.20,0.00,0.00,0.00,0.00,0.00),('22','242','3','116',1472,'4','2',855766.22,856184.93,418.71,334968.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','116',1473,'5','2',1176421.40,1177054.41,633.01,506408.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','116',1474,'6','2',1048458.70,1049598.70,1140.00,912000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','116',1475,'7','1',727909.50,728625.69,716.19,128914.20,0.00,0.00,0.00,0.00,0.00),('22','242','1','116',1476,'8','1',813680.77,814392.12,711.35,128043.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','116',1477,'9','1',793422.74,794103.77,681.03,122585.40,0.00,0.00,0.00,0.00,0.00),('22','242','1','116',1478,'10','1',687452.98,687911.86,458.88,82598.40,0.00,0.00,0.00,0.00,0.00),('22','242','2','116',1479,'11','1',971610.94,972009.95,399.01,71821.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','116',1480,'12','1',783579.80,783860.83,281.03,50585.40,0.00,0.00,0.00,0.00,0.00),('22','242','2','116',1481,'13','1',540386.21,541328.85,942.64,169675.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','116',1482,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','116',1483,'15','1',486809.29,487065.87,256.58,46184.40,0.00,0.00,0.00,0.00,0.00),('22','242','2','116',1484,'16','1',309084.55,309368.42,283.87,51096.60,0.00,0.00,0.00,0.00,0.00),('22','242','3','117',1485,'4','2',856184.93,856852.68,667.75,517506.25,0.00,0.00,0.00,0.00,0.00),('22','242','3','117',1486,'5','2',1177054.41,1177795.85,741.44,574616.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','117',1487,'6','2',1049598.70,1051118.71,1520.01,1178007.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','117',1488,'7','1',728625.69,729342.32,716.63,128993.40,0.00,0.00,0.00,0.00,0.00),('22','242','1','117',1489,'8','1',814392.12,815142.80,750.68,135122.40,0.00,0.00,0.00,0.00,0.00),('22','242','1','117',1490,'9','1',794103.77,794640.49,536.72,96609.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','117',1491,'10','1',687911.86,688609.26,697.40,125532.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','117',1492,'11','1',972009.95,972553.67,543.72,97869.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','117',1493,'12','1',783860.83,784488.45,627.62,112971.60,0.00,0.00,0.00,0.00,0.00),('22','242','2','117',1494,'13','1',541328.85,541658.79,329.94,59389.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','117',1495,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','117',1496,'15','1',487065.87,487631.37,565.50,101790.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','117',1497,'16','1',309368.42,309530.00,161.58,29084.40,0.00,0.00,0.00,0.00,0.00),('22','242','3','118',1498,'4','2',856852.68,857261.36,408.68,316727.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','118',1499,'5','2',1177795.85,1178186.52,390.67,302769.25,0.00,0.00,0.00,0.00,0.00),('22','242','4','118',1500,'6','2',1051118.71,1051397.09,278.38,215744.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','118',1501,'7','1',729342.32,730333.65,991.33,178439.40,0.00,0.00,0.00,0.00,0.00),('22','242','1','118',1502,'8','1',815142.80,815859.10,716.30,128934.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','118',1503,'9','1',794640.49,795375.89,735.40,132372.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','118',1504,'10','1',688609.26,689163.38,554.12,99741.60,0.00,0.00,0.00,0.00,0.00),('22','242','2','118',1505,'11','1',972553.67,972859.20,305.53,54995.40,0.00,0.00,0.00,0.00,0.00),('22','242','1','118',1506,'12','1',784488.45,784949.60,461.15,83007.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','118',1507,'13','1',541658.79,542223.68,564.89,101680.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','118',1508,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','118',1509,'15','1',487631.37,488165.73,534.36,96184.80,0.00,0.00,0.00,0.00,0.00),('22','242','2','118',1510,'16','1',309530.00,310048.53,518.53,93335.40,0.00,0.00,0.00,0.00,0.00),('22','242','3','119',1511,'4','2',857261.36,857796.64,535.28,414842.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','119',1512,'5','2',1178186.52,1179147.42,960.90,744697.50,0.00,0.00,0.00,0.00,0.00),('22','242','4','119',1513,'6','2',1051397.09,1052497.09,1100.00,852500.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','119',1514,'7','1',730333.65,730949.71,616.06,110890.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','119',1515,'8','1',815859.10,816371.19,512.09,92176.20,0.00,0.00,0.00,0.00,0.00),('22','242','1','119',1516,'9','1',795375.89,796095.03,719.14,129445.20,0.00,0.00,0.00,0.00,0.00),('22','242','1','119',1517,'10','1',689163.38,689940.33,776.95,139851.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','119',1518,'11','1',972859.20,973345.06,485.86,87454.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','119',1519,'12','1',784949.60,785499.86,550.26,99046.80,0.00,0.00,0.00,0.00,0.00),('22','242','2','119',1520,'13','1',542223.68,542649.02,425.34,76561.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','119',1521,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','119',1522,'15','1',488165.73,489205.38,1039.65,187137.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','119',1523,'16','1',310048.53,310974.23,925.70,166626.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','120',1524,'4','2',857796.64,858495.27,698.63,541438.25,0.00,0.00,0.00,0.00,0.00),('22','242','3','120',1525,'5','2',1179147.42,1179622.47,475.05,368163.75,0.00,0.00,0.00,0.00,0.00),('22','242','4','120',1526,'6','2',1052497.09,1053224.09,727.00,563425.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','120',1527,'7','1',730949.71,732060.25,1110.54,199897.20,0.00,0.00,0.00,0.00,0.00),('22','242','1','120',1528,'8','1',816371.19,817109.10,737.91,132823.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','120',1529,'9','1',796095.03,796469.78,374.75,67455.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','120',1530,'10','1',689940.33,690542.26,601.93,108347.40,0.00,0.00,0.00,0.00,0.00),('22','242','2','120',1531,'11','1',973345.06,973475.83,130.77,23538.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','120',1532,'12','1',785499.86,785983.86,484.00,87120.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','120',1533,'13','1',542649.02,542938.82,289.80,52164.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','120',1534,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','120',1535,'15','1',489205.38,489586.03,380.65,68517.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','120',1536,'16','1',310974.23,311204.42,230.19,41434.20,0.00,0.00,0.00,0.00,0.00),('22','242','3','121',1537,'4','2',858495.27,858630.86,135.59,105082.25,0.00,0.00,0.00,0.00,0.00),('22','242','3','121',1538,'5','2',1179622.47,1179822.75,200.28,155217.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','121',1539,'6','2',1053224.09,1053924.09,700.00,542500.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','121',1540,'7','1',732060.25,732727.23,666.98,120056.40,0.00,0.00,0.00,0.00,0.00),('22','242','1','121',1541,'8','1',817109.10,817628.96,519.86,93574.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','121',1542,'9','1',796469.78,797278.66,808.88,145598.40,0.00,0.00,0.00,0.00,0.00),('22','242','1','121',1543,'10','1',690542.26,691693.92,1151.66,207298.80,0.00,0.00,0.00,0.00,0.00),('22','242','2','121',1544,'11','1',973475.83,973778.53,302.70,54486.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','121',1545,'12','1',785983.86,786214.71,230.85,41553.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','121',1546,'13','1',542938.82,543086.01,147.19,26494.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','121',1547,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','121',1548,'15','1',489586.03,489701.91,115.88,20858.40,0.00,0.00,0.00,0.00,0.00),('22','242','2','121',1549,'16','1',311204.42,311204.51,0.09,16.20,0.00,0.00,0.00,0.00,0.00),('22','242','3','122',1550,'4','2',858630.86,859585.11,954.25,739543.75,0.00,0.00,0.00,0.00,0.00),('22','242','3','122',1551,'5','2',1179822.75,1180699.90,877.15,679791.25,0.00,0.00,0.00,0.00,0.00),('22','242','4','122',1552,'6','2',1053924.09,1054114.09,190.00,147250.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','122',1553,'7','1',732727.23,733471.39,744.16,133948.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','122',1554,'8','1',817628.96,818390.98,762.02,137163.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','122',1555,'9','1',797278.66,798144.16,865.50,155790.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','122',1556,'10','1',691693.92,692872.21,1178.29,212092.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','122',1557,'11','1',973778.53,974230.08,451.55,81279.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','122',1558,'12','1',786214.71,787306.48,1091.77,196518.60,0.00,0.00,0.00,0.00,0.00),('22','242','2','122',1559,'13','1',543086.01,543465.36,379.35,68283.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','122',1560,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','122',1561,'15','1',489701.91,489864.22,162.31,29215.80,0.00,0.00,0.00,0.00,0.00),('22','242','2','122',1562,'16','1',311204.51,311232.37,27.86,5014.80,0.00,0.00,0.00,0.00,0.00),('22','242','3','123',1563,'4','2',859585.11,860555.29,970.18,776144.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','123',1564,'5','2',1180699.90,1181468.24,768.34,614672.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','123',1565,'6','2',1054114.09,1055496.15,1382.06,1105648.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','123',1566,'7','1',733471.39,734326.10,854.71,153847.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','123',1567,'8','1',818390.98,819029.65,638.67,114960.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','123',1568,'9','1',798144.16,798535.17,391.01,70381.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','123',1569,'10','1',692872.21,693718.41,846.20,152316.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','123',1570,'11','1',974230.08,974943.10,713.02,128343.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','123',1571,'12','1',787306.48,787907.46,600.98,108176.40,0.00,0.00,0.00,0.00,0.00),('22','242','2','123',1572,'13','1',543465.36,544079.03,613.67,110460.60,0.00,0.00,0.00,0.00,0.00),('22','242','2','123',1573,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','123',1574,'15','1',489864.22,490532.79,668.57,120342.60,0.00,0.00,0.00,0.00,0.00),('22','242','2','123',1575,'16','1',311232.37,311232.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','124',1576,'4','2',860555.29,861245.09,689.80,534595.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','124',1577,'5','2',1181468.24,1182343.14,874.90,678047.50,0.00,0.00,0.00,0.00,0.00),('22','242','4','124',1578,'6','2',1055496.15,1056116.15,620.00,480500.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','124',1579,'7','1',734326.10,735629.26,1303.16,234568.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','124',1580,'8','1',819029.65,819713.29,683.64,123055.20,0.00,0.00,0.00,0.00,0.00),('22','242','1','124',1581,'9','1',798535.17,799008.35,473.18,85172.40,0.00,0.00,0.00,0.00,0.00),('22','242','1','124',1582,'10','1',693718.41,694340.72,622.31,112015.80,0.00,0.00,0.00,0.00,0.00),('22','242','2','124',1583,'11','1',974943.10,975775.56,832.46,149842.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','124',1584,'12','1',787907.46,788362.50,455.04,81907.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','124',1585,'13','1',544079.03,544807.29,728.26,131086.80,0.00,0.00,0.00,0.00,0.00),('22','242','2','124',1586,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','124',1587,'15','1',490532.79,491199.37,666.58,119984.40,0.00,0.00,0.00,0.00,0.00),('22','242','2','124',1588,'16','1',311232.37,311499.23,266.86,48034.80,0.00,0.00,0.00,0.00,0.00),('22','242','3','125',1589,'4','2',861245.09,862452.60,1207.51,935820.25,0.00,0.00,0.00,0.00,0.00),('22','242','3','125',1590,'5','2',1182343.14,1183579.67,1236.53,958310.75,0.00,0.00,0.00,0.00,0.00),('22','242','4','125',1591,'6','2',1056116.15,1057135.64,1019.49,790104.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','125',1592,'7','1',735629.26,736549.53,920.27,165648.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','125',1593,'8','1',819713.29,820325.83,612.54,110257.20,0.00,0.00,0.00,0.00,0.00),('22','242','1','125',1594,'9','1',799008.35,799979.01,970.66,174718.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','125',1595,'10','1',694340.72,694921.88,581.16,104608.80,0.00,0.00,0.00,0.00,0.00),('22','242','2','125',1596,'11','1',975775.56,976521.04,745.48,134186.40,0.00,0.00,0.00,0.00,0.00),('22','242','1','125',1597,'12','1',788362.50,788985.61,623.11,112159.80,0.00,0.00,0.00,0.00,0.00),('22','242','2','125',1598,'13','1',544807.29,545259.23,451.94,81349.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','125',1599,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','125',1600,'15','1',491199.37,492779.40,1580.03,284405.40,0.00,0.00,0.00,0.00,0.00),('22','242','2','125',1601,'16','1',311499.23,311499.34,0.11,19.80,0.00,0.00,0.00,0.00,0.00),('22','242','3','126',1602,'4','2',862452.60,863079.12,626.52,485553.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','126',1603,'5','2',1183579.67,1184536.64,956.97,741651.75,0.00,0.00,0.00,0.00,0.00),('22','242','4','126',1604,'6','2',1057135.64,1057735.64,600.00,465000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','126',1605,'7','1',736549.53,737822.69,1273.16,229168.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','126',1606,'8','1',820325.83,820960.19,634.36,114184.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','126',1607,'9','1',799979.01,800510.53,531.52,95673.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','126',1608,'10','1',694921.88,695698.26,776.38,139748.40,0.00,0.00,0.00,0.00,0.00),('22','242','2','126',1609,'11','1',976521.04,977108.88,587.84,105811.20,0.00,0.00,0.00,0.00,0.00),('22','242','1','126',1610,'12','1',788985.61,789460.69,475.08,85514.40,0.00,0.00,0.00,0.00,0.00),('22','242','2','126',1611,'13','1',545259.23,546027.56,768.33,138299.40,0.00,0.00,0.00,0.00,0.00),('22','242','2','126',1612,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','126',1613,'15','1',492779.40,493336.75,557.35,100323.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','126',1614,'16','1',311499.34,312278.75,779.41,140293.80,0.00,0.00,0.00,0.00,0.00),('22','242','3','127',1615,'4','2',863079.12,863684.49,605.37,469161.75,0.00,0.00,0.00,0.00,0.00),('22','242','3','127',1616,'5','2',1184536.64,1185759.17,1222.53,947460.75,0.00,0.00,0.00,0.00,0.00),('22','242','4','127',1617,'6','2',1057735.64,1058315.64,580.00,449500.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','127',1618,'7','1',737822.69,738615.73,793.04,142747.20,0.00,0.00,0.00,0.00,0.00),('22','242','1','127',1619,'8','1',820960.19,821463.29,503.10,90558.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','127',1620,'9','1',800510.53,801701.77,1191.24,214423.20,0.00,0.00,0.00,0.00,0.00),('22','242','1','127',1621,'10','1',695698.26,696830.27,1132.01,203761.80,0.00,0.00,0.00,0.00,0.00),('22','242','2','127',1622,'11','1',977108.88,977108.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','127',1623,'12','1',789460.69,789921.67,460.98,82976.40,0.00,0.00,0.00,0.00,0.00),('22','242','2','127',1624,'13','1',546027.56,546361.80,334.24,60163.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','127',1625,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','127',1626,'15','1',493336.75,493856.95,520.20,93636.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','127',1627,'16','1',312278.75,312759.44,480.69,86524.20,0.00,0.00,0.00,0.00,0.00),('22','242','3','128',1628,'4','2',863684.49,863713.51,29.02,22490.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','128',1629,'5','2',1185759.17,1185947.88,188.71,146250.25,0.00,0.00,0.00,0.00,0.00),('22','242','4','128',1630,'6','2',1058315.64,1058915.64,600.00,465000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','128',1631,'7','1',738615.73,739124.09,508.36,91504.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','128',1632,'8','1',821463.29,822086.36,623.07,112152.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','128',1633,'9','1',801701.77,801932.56,230.79,41542.20,0.00,0.00,0.00,0.00,0.00),('22','242','1','128',1634,'10','1',696830.27,697236.24,405.97,73074.60,0.00,0.00,0.00,0.00,0.00),('22','242','2','128',1635,'11','1',977108.88,978011.73,902.85,162513.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','128',1636,'12','1',789921.67,789921.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','128',1637,'13','1',546361.80,546843.22,481.42,86655.60,0.00,0.00,0.00,0.00,0.00),('22','242','2','128',1638,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','128',1639,'15','1',493856.95,494160.26,303.31,54595.80,0.00,0.00,0.00,0.00,0.00),('22','242','2','128',1640,'16','1',312759.44,312759.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','129',1641,'4','2',863713.51,864619.73,906.22,702320.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','129',1642,'5','2',1185947.88,1186697.70,749.82,581110.50,0.00,0.00,0.00,0.00,0.00),('22','242','4','129',1643,'6','2',1058915.64,1061460.10,2544.46,1971956.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','129',1644,'7','1',739124.09,739989.91,865.82,155847.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','129',1645,'8','1',822086.36,822852.07,765.71,137827.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','129',1646,'9','1',801932.56,802727.58,795.02,143103.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','129',1647,'10','1',697236.24,697889.72,653.48,117626.40,0.00,0.00,0.00,0.00,0.00),('22','242','2','129',1648,'11','1',978011.73,978789.72,777.99,140038.20,0.00,0.00,0.00,0.00,0.00),('22','242','1','129',1649,'12','1',789921.67,790496.04,574.37,103386.60,0.00,0.00,0.00,0.00,0.00),('22','242','2','129',1650,'13','1',546843.22,547280.01,436.79,78622.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','129',1651,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','129',1652,'15','1',494160.26,494668.66,508.40,91512.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','129',1653,'16','1',312759.44,312934.47,175.03,31505.40,0.00,0.00,0.00,0.00,0.00),('22','242','3','130',1654,'4','2',864619.73,865197.50,577.77,447771.75,0.00,0.00,0.00,0.00,0.00),('22','242','3','130',1655,'5','2',1186697.70,1187363.07,665.37,515661.75,0.00,0.00,0.00,0.00,0.00),('22','242','4','130',1656,'6','2',1061460.10,1061640.10,180.00,139500.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','130',1657,'7','1',739989.91,740719.71,729.80,131364.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','130',1658,'8','1',822852.07,823418.27,566.20,101916.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','130',1659,'9','1',802727.58,803490.20,762.62,137271.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','130',1660,'10','1',697889.72,698251.86,362.14,65185.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','130',1661,'11','1',978789.72,979584.86,795.14,143125.20,0.00,0.00,0.00,0.00,0.00),('22','242','1','130',1662,'12','1',790496.04,792129.66,1633.62,294051.60,0.00,0.00,0.00,0.00,0.00),('22','242','2','130',1663,'13','1',547280.01,548064.10,784.09,141136.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','130',1664,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','130',1665,'15','1',494668.66,495289.68,621.02,111783.60,0.00,0.00,0.00,0.00,0.00),('22','242','2','130',1666,'16','1',312934.47,313362.18,427.71,76987.80,0.00,0.00,0.00,0.00,0.00),('22','242','3','131',1667,'4','2',865197.50,865835.85,638.35,494721.25,0.00,0.00,0.00,0.00,0.00),('22','242','3','131',1668,'5','2',1187363.07,1188331.95,968.88,750882.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','131',1669,'6','2',1061640.10,1062045.10,405.00,313875.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','131',1670,'7','1',740719.71,741834.48,1114.77,200658.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','131',1671,'8','1',823418.27,823989.52,571.25,102825.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','131',1672,'9','1',803490.20,804285.67,795.47,143184.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','131',1673,'10','1',698251.86,698715.21,463.35,83403.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','131',1674,'11','1',979584.86,980192.07,607.21,109297.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','131',1675,'12','1',792129.66,792799.74,670.08,120614.40,0.00,0.00,0.00,0.00,0.00),('22','242','2','131',1676,'13','1',548064.10,548461.75,397.65,71577.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','131',1677,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','131',1678,'15','1',495289.68,495848.16,558.48,100526.40,0.00,0.00,0.00,0.00,0.00),('22','242','2','131',1679,'16','1',313362.18,313652.10,289.92,52185.60,0.00,0.00,0.00,0.00,0.00),('22','242','3','132',1680,'4','2',865835.85,866485.95,650.10,503827.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','132',1681,'5','2',1188331.95,1189038.48,706.53,547560.75,0.00,0.00,0.00,0.00,0.00),('22','242','4','132',1682,'6','2',1062045.10,1062625.00,579.90,449422.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','132',1683,'7','1',741834.48,743358.06,1523.58,274244.40,0.00,0.00,0.00,0.00,0.00),('22','242','1','132',1684,'8','1',823989.52,824800.58,811.06,145990.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','132',1685,'9','1',804285.67,804916.72,631.05,113589.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','132',1686,'10','1',698715.21,699200.09,484.88,87278.40,0.00,0.00,0.00,0.00,0.00),('22','242','2','132',1687,'11','1',980192.07,980414.00,221.93,39947.40,0.00,0.00,0.00,0.00,0.00),('22','242','1','132',1688,'12','1',792799.74,793250.88,451.14,81205.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','132',1689,'13','1',548461.75,549876.99,1415.24,254743.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','132',1690,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','132',1691,'15','1',495848.16,496353.62,505.46,90982.80,0.00,0.00,0.00,0.00,0.00),('22','242','2','132',1692,'16','1',313652.10,314064.56,412.46,74242.80,0.00,0.00,0.00,0.00,0.00),('22','242','3','133',1693,'4','2',866485.95,867197.12,711.17,551156.75,0.00,0.00,0.00,0.00,0.00),('22','242','3','133',1694,'5','2',1189038.48,1190064.18,1025.70,794917.50,0.00,0.00,0.00,0.00,0.00),('22','242','4','133',1695,'6','2',1062625.00,1063315.10,690.10,534827.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','133',1696,'7','1',743358.06,744182.25,824.19,148354.20,0.00,0.00,0.00,0.00,0.00),('22','242','1','133',1697,'8','1',824800.58,825564.35,763.77,137478.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','133',1698,'9','1',804916.72,805592.58,675.86,121654.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','133',1699,'10','1',699200.09,699872.26,672.17,120990.60,0.00,0.00,0.00,0.00,0.00),('22','242','2','133',1700,'11','1',980414.00,981262.20,848.20,152676.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','133',1701,'12','1',793250.88,793769.01,518.13,93263.40,0.00,0.00,0.00,0.00,0.00),('22','242','2','133',1702,'13','1',549876.99,550510.31,633.32,113997.60,0.00,0.00,0.00,0.00,0.00),('22','242','2','133',1703,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','133',1704,'15','1',496353.62,497119.70,766.08,137894.40,0.00,0.00,0.00,0.00,0.00),('22','242','2','133',1705,'16','1',314064.56,314332.22,267.66,48178.80,0.00,0.00,0.00,0.00,0.00),('22','242','3','134',1706,'4','2',867197.12,867719.13,522.01,404557.75,0.00,0.00,0.00,0.00,0.00),('22','242','3','134',1707,'5','2',1190064.18,1190848.14,783.96,607569.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','134',1708,'6','2',1063315.10,1064845.10,1530.00,1185750.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','134',1709,'7','1',744182.25,745110.98,928.73,167171.40,0.00,0.00,0.00,0.00,0.00),('22','242','1','134',1710,'8','1',825564.35,826101.98,537.63,96773.40,0.00,0.00,0.00,0.00,0.00),('22','242','1','134',1711,'9','1',805592.58,806460.41,867.83,156209.40,0.00,0.00,0.00,0.00,0.00),('22','242','1','134',1712,'10','1',699872.26,700556.57,684.31,123175.80,0.00,0.00,0.00,0.00,0.00),('22','242','2','134',1713,'11','1',981262.20,981702.10,439.90,79182.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','134',1714,'12','1',793769.01,794156.61,387.60,69768.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','134',1715,'13','1',550510.31,551190.13,679.82,122367.60,0.00,0.00,0.00,0.00,0.00),('22','242','2','134',1716,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','134',1717,'15','1',497119.70,498096.46,976.76,175816.80,0.00,0.00,0.00,0.00,0.00),('22','242','2','134',1718,'16','1',314332.22,315132.55,800.33,144059.40,0.00,0.00,0.00,0.00,0.00),('22','242','3','135',1719,'4','2',867719.13,867980.55,261.42,202600.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','135',1720,'5','2',1190848.14,1191038.24,190.10,147327.50,0.00,0.00,0.00,0.00,0.00),('22','242','4','135',1721,'6','2',1064845.10,1065287.53,442.43,342883.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','135',1722,'7','1',745110.98,745864.93,753.95,135711.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','135',1723,'8','1',826101.98,826973.72,871.74,156913.20,0.00,0.00,0.00,0.00,0.00),('22','242','1','135',1724,'9','1',806460.41,807153.96,693.55,124839.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','135',1725,'10','1',700556.57,701065.26,508.69,91564.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','135',1726,'11','1',981702.10,981964.71,262.61,47269.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','135',1727,'12','1',794156.61,794217.14,60.53,10895.40,0.00,0.00,0.00,0.00,0.00),('22','242','2','135',1728,'13','1',551190.13,551592.36,402.23,72401.40,0.00,0.00,0.00,0.00,0.00),('22','242','2','135',1729,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','135',1730,'15','1',498096.46,498423.41,326.95,58851.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','135',1731,'16','1',315132.55,315239.75,107.20,19296.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','136',1732,'4','2',867980.55,868453.16,472.61,366272.75,0.00,0.00,0.00,0.00,0.00),('22','242','3','136',1733,'5','2',1191038.24,1191943.81,905.57,701816.75,0.00,0.00,0.00,0.00,0.00),('22','242','4','136',1734,'6','2',1065287.53,1066144.03,856.50,663787.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','136',1735,'7','1',745864.93,747536.36,1671.43,300857.40,0.00,0.00,0.00,0.00,0.00),('22','242','1','136',1736,'8','1',826973.72,828251.15,1277.43,229937.40,0.00,0.00,0.00,0.00,0.00),('22','242','1','136',1737,'9','1',807153.96,807863.63,709.67,127740.60,0.00,0.00,0.00,0.00,0.00),('22','242','1','136',1738,'10','1',701065.26,701923.85,858.59,154546.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','136',1739,'11','1',981964.71,982480.82,516.11,92899.80,0.00,0.00,0.00,0.00,0.00),('22','242','1','136',1740,'12','1',794217.14,794645.73,428.59,77146.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','136',1741,'13','1',551592.36,552038.67,446.31,80335.80,0.00,0.00,0.00,0.00,0.00),('22','242','2','136',1742,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','136',1743,'15','1',498423.41,498887.45,464.04,83527.20,0.00,0.00,0.00,0.00,0.00),('22','242','2','136',1744,'16','1',315239.75,315621.76,382.01,68761.80,0.00,0.00,0.00,0.00,0.00),('22','242','3','137',1745,'4','2',868453.16,868981.17,528.01,409207.75,0.00,0.00,0.00,0.00,0.00),('22','242','3','137',1746,'5','2',1191943.81,1192897.43,953.62,739055.50,0.00,0.00,0.00,0.00,0.00),('22','242','4','137',1747,'6','2',1066144.03,1066527.90,383.87,297499.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','137',1748,'7','1',747536.36,748814.43,1278.07,223662.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','137',1749,'8','1',828251.15,829292.03,1040.88,182154.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','137',1750,'9','1',807863.63,808978.27,1114.64,195062.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','137',1751,'10','1',701923.85,702604.29,680.44,119077.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','137',1752,'11','1',982480.82,983213.29,732.47,128182.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','137',1753,'12','1',794645.73,795511.34,865.61,151481.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','137',1754,'13','1',552038.67,552994.70,956.03,167305.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','137',1755,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','137',1756,'15','1',498887.45,499567.57,680.12,119021.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','137',1757,'16','1',315621.76,316320.41,698.65,122263.75,0.00,0.00,0.00,0.00,0.00),('22','242','3','138',1758,'4','2',868981.17,869861.53,880.36,682279.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','138',1759,'5','2',1192897.43,1193541.69,644.26,499301.50,0.00,0.00,0.00,0.00,0.00),('22','242','4','138',1760,'6','2',1066527.90,1068934.50,2406.60,1865115.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','138',1761,'7','1',748814.43,748940.01,125.58,21976.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','138',1762,'8','1',829292.03,830260.06,968.03,169405.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','138',1763,'9','1',808978.27,809968.36,990.09,173265.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','138',1764,'10','1',702604.29,703676.61,1072.32,187656.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','138',1765,'11','1',983213.29,984098.00,884.71,154824.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','138',1766,'12','1',795511.34,796699.38,1188.04,207907.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','138',1767,'13','1',552994.70,553718.18,723.48,126609.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','138',1768,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','138',1769,'15','1',499567.57,500247.24,679.67,118942.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','138',1770,'16','1',316320.41,316551.26,230.85,40398.75,0.00,0.00,0.00,0.00,0.00),('22','242','3','139',1771,'4','2',869861.53,870286.40,424.87,329274.25,0.00,0.00,0.00,0.00,0.00),('22','242','3','139',1772,'5','2',1193541.69,1194205.20,663.51,514220.25,0.00,0.00,0.00,0.00,0.00),('22','242','4','139',1773,'6','2',1068934.50,1070022.91,1088.41,843517.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','139',1774,'7','1',748940.01,750474.58,1534.57,268549.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','139',1775,'8','1',830260.06,831094.02,833.96,145943.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','139',1776,'9','1',809968.36,810849.97,881.61,154281.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','139',1777,'10','1',703676.61,704642.10,965.49,168960.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','139',1778,'11','1',984098.00,984781.91,683.91,119684.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','139',1779,'12','1',796699.38,797269.28,569.90,99732.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','139',1780,'13','1',553718.18,554403.94,685.76,120008.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','139',1781,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','139',1782,'15','1',500247.24,500831.79,584.55,102296.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','139',1783,'16','1',316551.26,316899.53,348.27,60947.25,0.00,0.00,0.00,0.00,0.00),('22','242','3','140',1784,'4','2',870286.40,870886.01,599.61,464697.75,0.00,0.00,0.00,0.00,0.00),('22','242','3','140',1785,'5','2',1194205.20,1195100.88,895.68,694152.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','140',1786,'6','2',1070022.91,1070222.91,200.00,155000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','140',1787,'7','1',750474.58,751788.40,1313.82,229918.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','140',1788,'8','1',831094.02,831634.49,540.47,94582.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','140',1789,'9','1',810849.97,811510.07,660.10,115517.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','140',1790,'10','1',704642.10,705260.92,618.82,108293.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','140',1791,'11','1',984781.91,985643.25,861.34,150734.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','140',1792,'12','1',797269.28,798193.73,924.45,161778.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','140',1793,'13','1',554403.94,555084.35,680.41,119071.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','140',1794,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','140',1795,'15','1',500831.79,501486.95,655.16,114653.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','140',1796,'16','1',316899.53,317314.42,414.89,72605.75,0.00,0.00,0.00,0.00,0.00),('22','242','3','141',1797,'4','2',870886.01,871257.81,371.80,288145.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','141',1798,'5','2',1195100.88,1195527.60,426.72,330708.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','141',1799,'6','2',1070222.91,1071292.47,1069.56,828909.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','141',1800,'7','1',751788.40,752847.47,1059.07,185337.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','141',1801,'8','1',831634.49,832368.54,734.05,128458.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','141',1802,'9','1',811510.07,812345.84,835.77,146259.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','141',1803,'10','1',705260.92,705731.03,470.11,82269.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','141',1804,'11','1',985643.25,987045.02,1401.77,245309.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','141',1805,'12','1',798193.73,799021.37,827.64,144837.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','141',1806,'13','1',555084.35,555592.77,508.42,88973.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','141',1807,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','141',1808,'15','1',501486.95,501983.85,496.90,86957.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','141',1809,'16','1',317314.42,317601.45,287.03,50230.25,0.00,0.00,0.00,0.00,0.00),('22','242','3','142',1810,'4','2',871257.81,871405.51,147.70,114467.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','142',1811,'5','2',1195527.60,1195747.99,220.39,170802.25,0.00,0.00,0.00,0.00,0.00),('22','242','4','142',1812,'6','2',1071292.47,1071292.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','142',1813,'7','1',752847.47,753301.24,453.77,79409.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','142',1814,'8','1',832368.54,832896.53,527.99,92398.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','142',1815,'9','1',812345.84,812914.13,568.29,99450.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','142',1816,'10','1',705731.03,706321.56,590.53,103342.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','142',1817,'11','1',987045.02,987045.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','142',1818,'12','1',799021.37,799593.73,572.36,100163.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','142',1819,'13','1',555592.77,555792.54,199.77,34959.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','142',1820,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','142',1821,'15','1',501983.85,502360.38,376.53,65892.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','142',1822,'16','1',317601.45,317695.49,94.04,16457.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','143',1823,'4','2',871405.51,872406.22,1000.71,775550.25,0.00,0.00,0.00,0.00,0.00),('22','242','3','143',1824,'5','2',1195747.99,1196698.04,950.05,736288.75,0.00,0.00,0.00,0.00,0.00),('22','242','4','143',1825,'6','2',1071292.47,1071692.47,400.00,310000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','143',1826,'7','1',753301.24,753913.14,611.90,107082.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','143',1827,'8','1',832896.53,833547.91,651.38,113991.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','143',1828,'9','1',812914.13,813504.16,590.03,103255.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','143',1829,'10','1',706321.56,707163.49,841.93,147337.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','143',1830,'11','1',987045.02,988243.35,1198.33,209707.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','143',1831,'12','1',799593.73,799916.82,323.09,56540.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','143',1832,'13','1',555792.54,556395.10,602.56,105448.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','143',1833,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','143',1834,'15','1',502360.38,503099.11,738.73,129277.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','143',1835,'16','1',317695.49,318290.76,595.27,104172.25,0.00,0.00,0.00,0.00,0.00),('22','242','3','144',1836,'4','2',872406.22,873016.97,610.75,473331.25,0.00,0.00,0.00,0.00,0.00),('22','242','3','144',1837,'5','2',1196698.04,1197403.00,704.96,546344.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','144',1838,'6','2',1071692.47,1071992.47,300.00,232500.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','144',1839,'7','1',753913.14,754782.36,869.22,152113.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','144',1840,'8','1',833547.91,834076.66,528.75,92531.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','144',1841,'9','1',813504.16,814476.27,972.11,170119.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','144',1842,'10','1',707163.49,707676.77,513.28,89824.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','144',1843,'11','1',988243.35,990438.70,2195.35,384186.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','144',1844,'12','1',799916.82,800650.64,733.82,128418.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','144',1845,'13','1',556395.10,557525.19,1130.09,197765.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','144',1846,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','144',1847,'15','1',503099.11,503701.47,602.36,105413.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','144',1848,'16','1',318290.76,318847.42,556.66,97415.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','145',1849,'4','2',873016.97,873980.44,963.47,746689.25,0.00,0.00,0.00,0.00,0.00),('22','242','3','145',1850,'5','2',1197403.00,1197830.90,427.90,331622.50,0.00,0.00,0.00,0.00,0.00),('22','242','4','145',1851,'6','2',1071992.47,1072632.47,640.00,496000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','145',1852,'7','1',754782.36,755783.56,1001.20,175210.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','145',1853,'8','1',834076.66,834952.84,876.18,153331.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','145',1854,'9','1',814476.27,815435.04,958.77,167784.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','145',1855,'10','1',707676.77,708510.94,834.17,145979.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','145',1856,'11','1',990438.70,991336.90,898.20,157185.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','145',1857,'12','1',800650.64,801433.71,783.07,137037.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','145',1858,'13','1',557525.19,558566.19,1041.00,182175.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','145',1859,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','145',1860,'15','1',503701.47,504464.22,762.75,133481.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','145',1861,'16','1',318847.42,319412.02,564.60,98805.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','146',1862,'4','2',873980.44,874492.46,512.02,396815.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','146',1863,'5','2',1197830.90,1198472.77,641.87,497449.25,0.00,0.00,0.00,0.00,0.00),('22','242','4','146',1864,'6','2',1072632.47,1073072.47,440.00,341000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','146',1865,'7','1',755783.56,756647.82,864.26,151245.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','146',1866,'8','1',834952.84,835571.68,618.84,108297.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','146',1867,'9','1',815435.04,816237.75,802.71,140474.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','146',1868,'10','1',708510.94,709409.78,898.84,157297.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','146',1869,'11','1',991336.90,991501.41,164.51,28789.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','146',1870,'12','1',801433.71,801856.37,422.66,73965.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','146',1871,'13','1',558566.19,558986.66,420.47,73582.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','146',1872,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','146',1873,'15','1',504464.22,504939.89,475.67,83242.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','146',1874,'16','1',319412.02,320084.94,672.92,117761.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','147',1875,'4','2',874492.46,875118.49,626.03,485173.25,0.00,0.00,0.00,0.00,0.00),('22','242','3','147',1876,'5','2',1198472.77,1199193.90,721.13,558875.75,0.00,0.00,0.00,0.00,0.00),('22','242','4','147',1877,'6','2',1073072.47,1073567.03,494.56,383284.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','147',1878,'7','1',756647.82,757689.15,1041.33,182232.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','147',1879,'8','1',835571.68,836305.56,733.88,128429.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','147',1880,'9','1',816237.75,817302.31,1064.56,186298.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','147',1881,'10','1',709409.78,710215.76,805.98,141046.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','147',1882,'11','1',991501.41,992062.66,561.25,98218.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','147',1883,'12','1',801856.37,802495.69,639.32,111881.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','147',1884,'13','1',558986.66,559865.88,879.22,153863.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','147',1885,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','147',1886,'15','1',504939.89,505630.45,690.56,120848.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','147',1887,'16','1',320084.94,320766.32,681.38,119241.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','148',1888,'4','2',875118.49,875767.26,648.77,502796.75,0.00,0.00,0.00,0.00,0.00),('22','242','3','148',1889,'5','2',1199193.90,1199726.12,532.22,412470.50,0.00,0.00,0.00,0.00,0.00),('22','242','4','148',1890,'6','2',1073567.03,1074517.03,950.00,736250.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','148',1891,'7','1',757689.15,759236.45,1547.30,270777.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','148',1892,'8','1',836305.56,837229.68,924.12,161721.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','148',1893,'9','1',817302.31,818192.32,890.01,155751.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','148',1894,'10','1',710215.76,710797.68,581.92,101836.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','148',1895,'11','1',992062.66,992586.99,524.33,91757.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','148',1896,'12','1',802495.69,802890.48,394.79,69088.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','148',1897,'13','1',559865.88,560750.77,884.89,154855.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','148',1898,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','148',1899,'15','1',505630.45,506297.71,667.26,116770.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','148',1900,'16','1',320766.32,320957.32,191.00,33425.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','149',1901,'4','2',875767.26,875912.88,145.62,112855.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','149',1902,'5','2',1199726.12,1199971.08,244.96,189844.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','149',1903,'6','2',1074517.03,1074717.03,200.00,155000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','149',1904,'7','1',759236.45,759924.12,687.67,120342.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','149',1905,'8','1',837229.68,837801.59,571.91,100084.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','149',1906,'9','1',818192.32,818989.73,797.41,139546.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','149',1907,'10','1',710797.68,711426.04,628.36,109963.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','149',1908,'11','1',992586.99,993035.25,448.26,78445.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','149',1909,'12','1',802890.48,802899.00,8.52,1491.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','149',1910,'13','1',560750.77,561057.02,306.25,53593.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','149',1911,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','149',1912,'15','1',506297.71,506466.42,168.71,29524.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','149',1913,'16','1',320957.32,321179.01,221.69,38795.75,0.00,0.00,0.00,0.00,0.00),('22','242','3','150',1914,'4','2',875912.88,876376.66,463.78,359429.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','150',1915,'5','2',1199971.08,1200674.92,703.84,545476.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','150',1916,'6','2',1074717.03,1077333.33,2616.30,2027632.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','150',1917,'7','1',759924.12,761521.14,1597.02,279478.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','150',1918,'8','1',837801.59,838789.93,988.34,172959.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','150',1919,'9','1',818989.73,820106.33,1116.60,195405.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','150',1920,'10','1',711426.04,712348.16,922.12,161371.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','150',1921,'11','1',993035.25,993354.07,318.82,55793.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','150',1922,'12','1',802899.00,802899.04,0.04,7.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','150',1923,'13','1',561057.02,561920.95,863.93,151187.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','150',1924,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','150',1925,'15','1',506466.42,507336.20,869.78,152211.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','150',1926,'16','1',321179.01,321826.68,647.67,113342.25,0.00,0.00,0.00,0.00,0.00),('22','242','3','151',1927,'4','2',876376.66,876844.14,467.48,373984.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','151',1928,'5','2',1200674.92,1201259.71,584.79,467832.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','151',1929,'6','2',1077333.33,1078070.33,737.00,589600.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','151',1930,'7','1',761521.14,762678.59,1157.45,202553.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','151',1931,'8','1',838789.93,839607.76,817.83,143120.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','151',1932,'9','1',820106.33,821205.83,1099.50,192412.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','151',1933,'10','1',712348.16,712983.14,634.98,111121.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','151',1934,'11','1',993354.07,994448.12,1094.05,191458.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','151',1935,'12','1',802899.04,803451.85,552.81,96741.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','151',1936,'13','1',561920.95,562472.45,551.50,96512.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','151',1937,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','151',1938,'15','1',507336.20,507850.95,514.75,90081.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','151',1939,'16','1',321826.68,322382.40,555.72,97251.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','152',1940,'4','2',876844.14,877345.03,500.89,425756.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','152',1941,'5','2',1201259.71,1201686.72,427.01,362958.50,0.00,0.00,0.00,0.00,0.00),('22','242','4','152',1942,'6','2',1078070.33,1079700.33,1630.00,1385500.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','152',1943,'7','1',762678.59,763955.97,1277.38,223541.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','152',1944,'8','1',839607.76,841215.97,1608.21,281436.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','152',1945,'9','1',821205.83,822105.65,899.82,157468.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','152',1946,'10','1',712983.14,713644.05,660.91,115659.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','152',1947,'11','1',994448.12,995070.03,621.91,108834.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','152',1948,'12','1',803451.85,803971.11,519.26,90870.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','152',1949,'13','1',562472.45,563201.97,729.52,127666.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','152',1950,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','152',1951,'15','1',507850.95,508703.42,852.47,149182.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','152',1952,'16','1',322382.40,322749.21,366.81,64191.75,0.00,0.00,0.00,0.00,0.00),('22','242','3','153',1953,'4','2',877345.03,877754.02,408.99,347641.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','153',1954,'5','2',1201686.72,1202114.78,428.06,363851.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','153',1955,'6','2',1079700.33,1080350.33,650.00,552500.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','153',1956,'7','1',763955.97,764918.07,962.10,168367.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','153',1957,'8','1',841215.97,842312.19,1096.22,191838.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','153',1958,'9','1',822105.65,823246.96,1141.31,199729.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','153',1959,'10','1',713644.05,714435.55,791.50,138512.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','153',1960,'11','1',995070.03,996005.12,935.09,163640.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','153',1961,'12','1',803971.11,804710.83,739.72,129451.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','153',1962,'13','1',563201.97,564419.05,1217.08,212989.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','153',1963,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','153',1964,'15','1',508703.42,509235.90,532.48,93184.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','153',1965,'16','1',322749.21,323324.35,575.14,100649.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','154',1966,'4','2',877754.02,878194.98,440.96,374816.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','154',1967,'5','2',1202114.78,1202547.37,432.59,367701.50,0.00,0.00,0.00,0.00,0.00),('22','242','4','154',1968,'6','2',1080350.33,1080990.33,640.00,544000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','154',1969,'7','1',764918.07,767248.17,2330.10,407767.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','154',1970,'8','1',842312.19,843745.03,1432.84,250747.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','154',1971,'9','1',823246.96,823321.23,74.27,12997.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','154',1972,'10','1',714435.55,714435.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','154',1973,'11','1',996005.12,997237.97,1232.85,215748.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','154',1974,'12','1',804710.83,805592.94,882.11,154369.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','154',1975,'13','1',564419.05,565358.13,939.08,164339.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','154',1976,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','154',1977,'15','1',509235.90,510205.29,969.39,169643.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','154',1978,'16','1',323324.35,324010.09,685.74,120004.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','155',1979,'4','2',878194.98,878626.78,431.80,367030.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','155',1980,'5','2',1202547.37,1202695.58,148.21,125978.50,0.00,0.00,0.00,0.00,0.00),('22','242','4','155',1981,'6','2',1080990.33,1081911.33,921.00,782850.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','155',1982,'7','1',767248.17,768488.48,1240.31,217054.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','155',1983,'8','1',843745.03,845143.60,1398.57,244749.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','155',1984,'9','1',823321.23,824115.06,793.83,138920.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','155',1985,'10','1',714435.55,714920.82,485.27,84922.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','155',1986,'11','1',997237.97,998230.40,992.43,173675.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','155',1987,'12','1',805592.94,805843.60,250.66,43865.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','155',1988,'13','1',565358.13,566384.58,1026.45,179628.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','155',1989,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','155',1990,'15','1',510205.29,510749.37,544.08,95214.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','155',1991,'16','1',324010.09,324540.88,530.79,92888.25,0.00,0.00,0.00,0.00,0.00),('22','242','3','156',1992,'4','2',878626.78,878681.67,54.89,46656.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','156',1993,'5','2',1202695.58,1202876.35,180.77,153654.50,0.00,0.00,0.00,0.00,0.00),('22','242','4','156',1994,'6','2',1081911.33,1082211.33,300.00,255000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','156',1995,'7','1',768488.48,769117.80,629.32,110131.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','156',1996,'8','1',845143.60,846043.67,900.07,157512.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','156',1997,'9','1',824115.06,824498.91,383.85,67173.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','156',1998,'10','1',714920.82,715060.76,139.94,24489.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','156',1999,'11','1',998230.40,999432.76,1202.36,210413.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','156',2000,'12','1',805843.60,806072.84,229.24,40117.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','156',2001,'13','1',566384.58,566384.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','156',2002,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','156',2003,'15','1',510749.37,511135.79,386.42,67623.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','156',2004,'16','1',324540.88,324817.74,276.86,48450.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','157',2005,'4','2',878681.67,879196.85,515.18,437903.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','157',2006,'5','2',1202876.35,1203122.36,246.01,209108.50,0.00,0.00,0.00,0.00,0.00),('22','242','4','157',2007,'6','2',1082211.33,1082761.33,550.00,467500.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','157',2008,'7','1',769117.80,770178.79,1060.99,185673.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','157',2009,'8','1',846043.67,846733.17,689.50,120662.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','157',2010,'9','1',824498.91,825694.34,1195.43,209200.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','157',2011,'10','1',715060.76,716039.32,978.56,171248.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','157',2012,'11','1',999432.76,1000507.45,1074.69,188070.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','157',2013,'12','1',806072.84,806723.81,650.97,113919.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','157',2014,'13','1',566384.58,566384.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','157',2015,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','157',2016,'15','1',511135.79,511897.02,761.23,133215.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','157',2017,'16','1',324817.74,325685.88,868.14,151924.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','158',2018,'4','2',879196.85,879413.61,216.76,184246.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','158',2019,'5','2',1203122.36,1203382.53,260.17,221144.50,0.00,0.00,0.00,0.00,0.00),('22','242','4','158',2020,'6','2',1082761.33,1083231.43,470.10,399585.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','158',2021,'7','1',770178.79,770853.72,674.93,118112.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','158',2022,'8','1',846733.17,847094.62,361.45,63253.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','158',2023,'9','1',825694.34,826327.92,633.58,110876.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','158',2024,'10','1',716039.32,716480.67,441.35,77236.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','158',2025,'11','1',1000507.45,1000859.71,352.26,61645.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','158',2026,'12','1',806723.81,809444.16,2720.35,476061.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','158',2027,'13','1',566384.58,566912.74,528.16,92428.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','158',2028,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','158',2029,'15','1',511897.02,512978.76,1081.74,189304.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','158',2030,'16','1',325685.88,327150.19,1464.31,256254.25,0.00,0.00,0.00,0.00,0.00),('22','242','3','159',2031,'4','2',879413.61,879843.38,429.77,365304.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','159',2032,'5','2',1203382.53,1203790.97,408.44,347174.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','159',2033,'6','2',1083231.43,1083731.43,500.00,425000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','159',2034,'7','1',770853.72,771912.23,1058.51,185239.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','159',2035,'8','1',847094.62,847654.73,560.11,98019.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','159',2036,'9','1',826327.92,827412.13,1084.21,189736.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','159',2037,'10','1',716480.67,717514.96,1034.29,181000.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','159',2038,'11','1',1000859.71,1002262.37,1402.66,245465.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','159',2039,'12','1',809444.16,810547.29,1103.13,193047.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','159',2040,'13','1',566912.74,567820.19,907.45,158803.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','159',2041,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','159',2042,'15','1',512978.76,513579.56,600.80,105140.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','159',2043,'16','1',327150.19,327975.31,825.12,144396.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','160',2044,'4','2',879843.38,880147.03,303.65,258102.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','160',2045,'5','2',1203790.97,1204176.87,385.90,328015.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','160',2046,'6','2',1083731.43,1084189.43,458.00,389300.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','160',2047,'7','1',771912.23,773086.09,1173.86,205425.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','160',2048,'8','1',847654.73,848175.69,520.96,91168.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','160',2049,'9','1',827412.13,828320.89,908.76,159033.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','160',2050,'10','1',717514.96,718179.20,664.24,116242.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','160',2051,'11','1',1002262.37,1004252.18,1989.81,348216.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','160',2052,'12','1',810547.29,811206.93,659.64,115437.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','160',2053,'13','1',567820.19,568668.34,848.15,148426.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','160',2054,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','160',2055,'15','1',513579.56,514133.38,553.82,96918.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','160',2056,'16','1',327975.31,328262.62,287.31,50279.25,0.00,0.00,0.00,0.00,0.00),('22','242','3','161',2057,'4','2',880147.03,880478.54,331.51,281783.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','161',2058,'5','2',1204176.87,1204794.63,617.76,525096.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','161',2059,'6','2',1084189.43,1085709.43,1520.00,1292000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','161',2060,'7','1',773086.09,774456.12,1370.03,239755.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','161',2061,'8','1',848175.69,848780.90,605.21,105911.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','161',2062,'9','1',828320.89,829302.19,981.30,171727.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','161',2063,'10','1',718179.20,719021.57,842.37,147414.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','161',2064,'11','1',1004252.18,1004826.21,574.03,100455.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','161',2065,'12','1',811206.93,812215.90,1008.97,176569.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','161',2066,'13','1',568668.34,569510.57,842.23,147390.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','161',2067,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','161',2068,'15','1',514133.38,514596.95,463.57,81124.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','161',2069,'16','1',328262.62,328862.64,600.02,105003.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','162',2070,'4','2',880478.54,880755.77,277.23,235645.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','162',2071,'5','2',1204794.63,1205076.44,281.81,239538.50,0.00,0.00,0.00,0.00,0.00),('22','242','4','162',2072,'6','2',1085709.43,1086845.18,1135.75,965387.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','162',2073,'7','1',774456.12,775379.27,923.15,161551.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','162',2074,'8','1',848780.90,849452.90,672.00,117600.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','162',2075,'9','1',829302.19,830144.15,841.96,147343.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','162',2076,'10','1',719021.57,719554.83,533.26,93320.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','162',2077,'11','1',1004826.21,1005258.94,432.73,75727.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','162',2078,'12','1',812215.90,813594.79,1378.89,241305.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','162',2079,'13','1',569510.57,569742.11,231.54,40519.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','162',2080,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','162',2081,'15','1',514596.95,515309.83,712.88,124754.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','162',2082,'16','1',328862.64,329908.81,1046.17,183079.75,0.00,0.00,0.00,0.00,0.00),('22','242','3','163',2083,'4','2',880755.77,880863.36,107.59,91451.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','163',2084,'5','2',1205076.44,1205254.99,178.55,151767.50,0.00,0.00,0.00,0.00,0.00),('22','242','4','163',2085,'6','2',1086845.18,1087395.18,550.00,467500.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','163',2086,'7','1',775379.27,775929.03,549.76,96208.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','163',2087,'8','1',849452.90,850323.34,870.44,152327.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','163',2088,'9','1',830144.15,830850.40,706.25,123593.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','163',2089,'10','1',719554.83,719980.86,426.03,74555.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','163',2090,'11','1',1005258.94,1005619.91,360.97,63169.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','163',2091,'12','1',813594.79,813702.99,108.20,18935.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','163',2092,'13','1',569742.11,569742.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','163',2093,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','163',2094,'15','1',515309.83,515752.03,442.20,77385.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','163',2095,'16','1',329908.81,330055.77,146.96,25718.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','164',2096,'4','2',880863.36,881119.56,256.20,217770.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','164',2097,'5','2',1205254.99,1205471.90,216.91,184373.50,0.00,0.00,0.00,0.00,0.00),('22','242','4','164',2098,'6','2',1087395.18,1087395.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','164',2099,'7','1',775929.03,775929.36,0.33,57.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','164',2100,'8','1',850323.34,852580.10,2256.76,394933.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','164',2101,'9','1',830850.40,831799.73,949.33,166132.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','164',2102,'10','1',719980.86,720355.07,374.21,65486.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','164',2103,'11','1',1005619.91,1006282.78,662.87,116002.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','164',2104,'12','1',813702.99,814188.83,485.84,85022.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','164',2105,'13','1',569742.11,570926.79,1184.68,207319.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','164',2106,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','164',2107,'15','1',515752.03,516374.55,622.52,108941.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','164',2108,'16','1',330055.77,330528.12,472.35,82661.25,0.00,0.00,0.00,0.00,0.00),('22','242','3','165',2109,'4','2',881119.56,881473.45,353.89,300806.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','165',2110,'5','2',1205471.90,1205851.07,379.17,322294.50,0.00,0.00,0.00,0.00,0.00),('22','242','4','165',2111,'6','2',1087395.18,1087725.18,330.00,280500.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','165',2112,'7','1',775929.36,776664.60,735.24,128667.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','165',2113,'8','1',852580.10,853900.67,1320.57,231099.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','165',2114,'9','1',831799.73,832718.68,918.95,160816.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','165',2115,'10','1',720355.07,721344.85,989.78,173211.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','165',2116,'11','1',1006282.78,1006909.40,626.62,109658.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','165',2117,'12','1',814188.83,814897.66,708.83,124045.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','165',2118,'13','1',570926.79,571891.18,964.39,168768.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','165',2119,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','165',2120,'15','1',516374.55,517035.21,660.66,115615.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','165',2121,'16','1',330528.12,331122.58,594.46,104030.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','166',2122,'4','2',881473.45,881974.64,501.19,426011.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','166',2123,'5','2',1205851.07,1206314.48,463.41,393898.50,0.00,0.00,0.00,0.00,0.00),('22','242','4','166',2124,'6','2',1087725.18,1088155.18,430.00,365500.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','166',2125,'7','1',776664.60,777961.45,1296.85,226948.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','166',2126,'8','1',853900.67,854710.08,809.41,141646.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','166',2127,'9','1',832718.68,833498.09,779.41,136396.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','166',2128,'10','1',721344.85,722175.59,830.74,145379.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','166',2129,'11','1',1006909.40,1007406.59,497.19,87008.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','166',2130,'12','1',814897.66,815360.07,462.41,80921.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','166',2131,'13','1',571891.18,572835.59,944.41,165271.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','166',2132,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','166',2133,'15','1',517035.21,517778.78,743.57,130124.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','166',2134,'16','1',331122.58,332293.57,1170.99,204923.25,0.00,0.00,0.00,0.00,0.00),('22','242','3','167',2135,'4','2',881974.64,882387.78,413.14,351169.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','167',2136,'5','2',1206314.48,1206644.73,330.25,280712.50,0.00,0.00,0.00,0.00,0.00),('22','242','4','167',2137,'6','2',1088155.18,1088888.06,732.88,622948.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','167',2138,'7','1',777961.45,778841.40,879.95,153991.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','167',2139,'8','1',854710.08,855368.50,658.42,115223.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','167',2140,'9','1',833498.09,834511.96,1013.87,177427.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','167',2141,'10','1',722175.59,722901.18,725.59,126978.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','167',2142,'11','1',1007406.59,1008494.07,1087.48,190309.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','167',2143,'12','1',815360.07,815822.97,462.90,81007.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','167',2144,'13','1',572835.59,573809.96,974.37,170514.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','167',2145,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','167',2146,'15','1',517778.78,517972.62,193.84,33922.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','167',2147,'16','1',332293.57,332955.23,661.66,115790.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','168',2148,'4','2',882387.78,882604.23,216.45,183982.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','168',2149,'5','2',1206644.73,1207043.02,398.29,338546.50,0.00,0.00,0.00,0.00,0.00),('22','242','4','168',2150,'6','2',1088888.06,1089138.06,250.00,212500.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','168',2151,'7','1',778841.40,780149.89,1308.49,228985.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','168',2152,'8','1',855368.50,856811.13,1442.63,252460.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','168',2153,'9','1',834511.96,835425.04,913.08,159789.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','168',2154,'10','1',722901.18,723611.96,710.78,124386.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','168',2155,'11','1',1008494.07,1008494.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','168',2156,'12','1',815822.97,816717.54,894.57,156549.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','168',2157,'13','1',573809.96,574912.72,1102.76,192983.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','168',2158,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','168',2159,'15','1',517972.62,518263.00,290.38,50816.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','168',2160,'16','1',332955.23,333445.78,490.55,85846.25,0.00,0.00,0.00,0.00,0.00),('22','242','3','169',2161,'4','2',882604.23,882850.56,246.33,209380.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','169',2162,'5','2',1207043.02,1207539.98,496.96,422416.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','169',2163,'6','2',1089138.06,1091275.06,2137.00,1816450.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','169',2164,'7','1',780149.89,781090.58,940.69,164620.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','169',2165,'8','1',856811.13,857744.81,933.68,163394.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','169',2166,'9','1',835425.04,836267.43,842.39,147418.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','169',2167,'10','1',723611.96,724364.46,752.50,131687.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','169',2168,'11','1',1008494.07,1009669.52,1175.45,205703.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','169',2169,'12','1',816717.54,817347.73,630.19,110283.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','169',2170,'13','1',574912.72,576401.99,1489.27,260622.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','169',2171,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','169',2172,'15','1',518263.00,518612.27,349.27,61122.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','169',2173,'16','1',333445.78,333887.58,441.80,77315.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','170',2174,'4','2',882850.56,882950.48,99.92,84932.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','170',2175,'5','2',1207539.98,1207750.63,210.65,179052.50,0.00,0.00,0.00,0.00,0.00),('22','242','4','170',2176,'6','2',1091275.06,1091475.06,200.00,170000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','170',2177,'7','1',781090.58,781388.41,297.83,52120.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','170',2178,'8','1',857744.81,858254.69,509.88,89229.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','170',2179,'9','1',836267.43,837081.05,813.62,142383.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','170',2180,'10','1',724364.46,725506.84,1142.38,199916.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','170',2181,'11','1',1009669.52,1009669.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','170',2182,'12','1',817347.73,817976.89,629.16,110103.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','170',2183,'13','1',576401.99,576810.97,408.98,71571.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','170',2184,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','170',2185,'15','1',518612.27,518829.19,216.92,37961.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','170',2186,'16','1',333887.58,334063.76,176.18,30831.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','171',2187,'4','2',882950.48,883326.59,376.11,319693.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','171',2188,'5','2',1207750.63,1208139.53,388.90,330565.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','171',2189,'6','2',1091475.06,1091745.06,270.00,229500.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','171',2190,'7','1',781388.41,782559.21,1170.80,204890.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','171',2191,'8','1',858254.69,858993.66,738.97,129319.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','171',2192,'9','1',837081.05,837750.74,669.69,117195.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','171',2193,'10','1',725506.84,726381.13,874.29,153000.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','171',2194,'11','1',1009669.52,1010435.52,766.00,134050.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','171',2195,'12','1',817976.89,818688.50,711.61,124531.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','171',2196,'13','1',576810.97,578115.10,1304.13,228222.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','171',2197,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','171',2198,'15','1',518829.19,519238.28,409.09,71590.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','171',2199,'16','1',334063.76,334764.34,700.58,122601.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','172',2200,'4','2',883326.59,883597.10,270.51,229933.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','172',2201,'5','2',1208139.53,1208538.86,399.33,339430.50,0.00,0.00,0.00,0.00,0.00),('22','242','4','172',2202,'6','2',1091745.06,1092185.06,440.00,374000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','172',2203,'7','1',782559.21,784641.68,2082.47,364432.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','172',2204,'8','1',858993.66,859795.73,802.07,140362.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','172',2205,'9','1',837750.74,838394.89,644.15,112726.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','172',2206,'10','1',726381.13,726966.04,584.91,102359.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','172',2207,'11','1',1010435.52,1010735.27,299.75,52456.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','172',2208,'12','1',818688.50,819558.69,870.19,152283.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','172',2209,'13','1',578115.10,579994.42,1879.32,328881.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','172',2210,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','172',2211,'15','1',519238.28,519807.54,569.26,99620.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','172',2212,'16','1',334764.34,335328.44,564.10,98717.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','173',2213,'4','2',883597.10,883874.59,277.49,235866.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','173',2214,'5','2',1208538.86,1208869.94,331.08,281418.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','173',2215,'6','2',1092185.06,1092485.06,300.00,255000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','173',2216,'7','1',784641.68,785707.19,1065.51,186464.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','173',2217,'8','1',859795.73,860313.47,517.74,90604.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','173',2218,'9','1',838394.89,839313.17,918.28,160699.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','173',2219,'10','1',726966.04,727937.07,971.03,169930.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','173',2220,'11','1',1010735.27,1011467.18,731.91,128084.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','173',2221,'12','1',819558.69,820244.33,685.64,119987.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','173',2222,'13','1',579994.42,581465.97,1471.55,257521.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','173',2223,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','173',2224,'15','1',519807.54,520085.52,277.98,48646.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','173',2225,'16','1',335328.44,335920.74,592.30,103652.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','174',2226,'4','2',883874.59,884056.43,181.84,154564.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','174',2227,'5','2',1208869.94,1209208.26,338.32,287572.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','174',2228,'6','2',1092485.06,1094335.06,1850.00,1572500.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','174',2229,'7','1',785707.19,786532.28,825.09,144390.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','174',2230,'8','1',860313.47,861025.76,712.29,124650.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','174',2231,'9','1',839313.17,840091.23,778.06,136160.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','174',2232,'10','1',727937.07,728757.75,820.68,143619.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','174',2233,'11','1',1011467.18,1011992.30,525.12,91896.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','174',2234,'12','1',820244.33,821158.20,913.87,159927.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','174',2235,'13','1',581465.97,582636.40,1170.43,204825.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','174',2236,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','174',2237,'15','1',520085.52,520477.12,391.60,68530.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','174',2238,'16','1',335920.74,336650.68,729.94,127739.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','175',2239,'4','2',884056.43,884308.15,251.72,213962.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','175',2240,'5','2',1209208.26,1209685.31,477.05,405492.50,0.00,0.00,0.00,0.00,0.00),('22','242','4','175',2241,'6','2',1094335.06,1094956.82,621.76,528496.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','175',2242,'7','1',786532.28,787169.72,637.44,111552.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','175',2243,'8','1',861025.76,861560.38,534.62,93558.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','175',2244,'9','1',840091.23,840398.58,307.35,53786.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','175',2245,'10','1',728757.75,729058.37,300.62,52608.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','175',2246,'11','1',1011992.30,1012848.66,856.36,149863.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','175',2247,'12','1',821158.20,822003.09,844.89,147855.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','175',2248,'13','1',582636.40,584021.71,1385.31,242429.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','175',2249,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','175',2250,'15','1',520477.12,520848.09,370.97,64919.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','175',2251,'16','1',336650.68,337209.31,558.63,97760.25,0.00,0.00,0.00,0.00,0.00),('22','242','3','176',2252,'4','2',884308.15,884579.24,271.09,230426.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','176',2253,'5','2',1209685.31,1210046.37,361.06,306901.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','176',2254,'6','2',1094956.82,1096294.82,1338.00,1137300.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','176',2255,'7','1',787169.72,787169.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','176',2256,'8','1',861560.38,861560.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','176',2257,'9','1',840398.58,840398.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','176',2258,'10','1',729058.37,729058.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','176',2259,'11','1',1012848.66,1013188.45,339.79,59463.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','176',2260,'12','1',822003.09,822003.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','176',2261,'13','1',584021.71,584362.73,341.02,59678.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','176',2262,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','176',2263,'15','1',520848.09,521238.54,390.45,68328.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','176',2264,'16','1',337209.31,337605.31,396.00,69300.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','177',2265,'4','2',884579.24,884644.49,65.25,55462.50,0.00,0.00,0.00,0.00,0.00),('22','242','3','177',2266,'5','2',1210046.37,1210201.15,154.78,131563.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','177',2267,'6','2',1096294.82,1096494.82,200.00,170000.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','177',2268,'7','1',787169.72,787169.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','177',2269,'8','1',861560.38,861560.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','177',2270,'9','1',840398.58,840398.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','177',2271,'10','1',729058.37,729058.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','177',2272,'11','1',1013188.45,1013682.73,494.28,86499.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','177',2273,'12','1',822003.09,822003.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','177',2274,'13','1',584362.73,584632.19,269.46,47155.50,0.00,0.00,0.00,0.00,0.00),('22','242','2','177',2275,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','177',2276,'15','1',521238.54,521350.06,111.52,19516.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','177',2277,'16','1',337605.31,337656.24,50.93,8912.75,0.00,0.00,0.00,0.00,0.00),('22','242','3','178',2278,'4','2',884644.49,884943.57,299.08,254218.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','178',2279,'5','2',1210201.15,1210711.35,510.20,433670.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','178',2280,'6','2',1096494.82,1097524.82,1030.00,875500.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','178',2281,'7','1',787169.72,787169.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','178',2282,'8','1',861560.38,861560.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','178',2283,'9','1',840398.58,840398.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','178',2284,'10','1',729058.37,729058.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','178',2285,'11','1',1013682.73,1013682.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','178',2286,'12','1',822003.09,822003.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','178',2287,'13','1',584632.19,584721.47,89.28,15624.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','178',2288,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','178',2289,'15','1',521350.06,521350.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','178',2290,'16','1',337656.24,337656.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','179',2291,'4','2',884943.57,885395.81,452.24,384404.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','179',2292,'5','2',1210711.35,1211344.82,633.47,538449.50,0.00,0.00,0.00,0.00,0.00),('22','242','4','179',2293,'6','2',1097524.82,1098754.82,1230.00,1045500.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','179',2294,'7','1',787169.72,787169.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','179',2295,'8','1',861560.38,861560.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','179',2296,'9','1',840398.58,840398.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','179',2297,'10','1',729058.37,729058.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','179',2298,'11','1',1013682.73,1013699.87,17.14,2999.50,0.00,0.00,0.00,0.00,0.00),('22','242','1','179',2299,'12','1',822003.09,822003.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','179',2300,'13','1',584721.47,585142.06,420.59,73603.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','179',2301,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','179',2302,'15','1',521350.06,521350.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','179',2303,'16','1',337656.24,337656.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','180',2304,'4','2',885395.81,885904.11,508.30,432055.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','180',2305,'5','2',1211344.82,1211863.85,519.03,441175.50,0.00,0.00,0.00,0.00,0.00),('22','242','4','180',2306,'6','2',1098754.82,1099564.82,810.00,688500.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','180',2307,'7','1',787169.72,787169.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','180',2308,'8','1',861560.38,861560.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','180',2309,'9','1',840398.58,840398.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','180',2310,'10','1',729058.37,729058.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','180',2311,'11','1',1013699.87,1014070.96,371.09,64940.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','180',2312,'12','1',822003.09,822003.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','180',2313,'13','1',585142.06,585142.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','180',2314,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','180',2315,'15','1',521350.06,521350.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','180',2316,'16','1',337656.24,337656.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','181',2317,'4','2',885904.11,886196.71,292.60,248710.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','181',2318,'5','2',1211863.85,1212372.81,508.96,432616.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','181',2319,'6','2',1099564.82,1100414.82,850.00,722500.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','181',2320,'7','1',787169.72,787733.19,563.47,98607.25,0.00,0.00,0.00,0.00,0.00),('22','242','1','181',2321,'8','1',861560.38,861953.50,393.12,68796.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','181',2322,'9','1',840398.58,840638.51,239.93,41987.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','181',2323,'10','1',729058.37,729446.38,388.01,67901.75,0.00,0.00,0.00,0.00,0.00),('22','242','2','181',2324,'11','1',1014070.96,1015208.33,1137.37,199039.75,0.00,0.00,0.00,0.00,0.00),('22','242','1','181',2325,'12','1',822003.09,822475.00,471.91,82584.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','181',2326,'13','1',585142.06,586276.93,1134.87,198602.25,0.00,0.00,0.00,0.00,0.00),('22','242','2','181',2327,'14','1',15924.28,15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','181',2328,'15','1',521350.06,521653.42,303.36,53088.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','181',2329,'16','1',337656.24,338282.95,626.71,109674.25,0.00,0.00,0.00,0.00,0.00),('22','242','3','182',2330,'4','2',886196.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','3','182',2331,'5','2',1212372.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','4','182',2332,'6','2',1100414.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','182',2333,'7','1',787733.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','182',2334,'8','1',861953.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','182',2335,'9','1',840638.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','182',2336,'10','1',729446.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','182',2337,'11','1',1015208.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','1','182',2338,'12','1',822475.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','182',2339,'13','1',586276.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','182',2340,'14','1',15924.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','182',2341,'15','1',521653.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('22','242','2','182',2342,'16','1',338282.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=365 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('22','242','3','2',625.00,650.00,0.00,0.00,0.00,0.00,0.00,5),('22','242','3','1',148.00,165.00,0.00,0.00,0.00,0.00,0.00,6),('22','242','5','2',625.00,650.00,3999.65,0.00,0.00,0.00,0.00,9),('22','242','5','1',148.00,165.00,9090.71,0.00,0.00,0.00,0.00,10),('22','242','6','2',625.00,650.00,3115.10,0.00,0.00,0.00,0.00,11),('22','242','6','1',148.00,165.00,12181.98,0.00,0.00,0.00,0.00,12),('22','242','7','2',625.00,650.00,914.67,0.00,0.00,0.00,0.00,13),('22','242','7','1',148.00,165.00,5406.06,0.00,0.00,0.00,0.00,14),('22','242','8','2',625.00,650.00,4653.44,0.00,0.00,0.00,0.00,15),('22','242','8','1',148.00,165.00,12138.70,0.00,0.00,0.00,0.00,16),('22','242','9','2',625.00,0.00,4061.31,0.00,0.00,0.00,0.00,17),('22','242','9','1',148.00,165.00,8925.64,0.00,0.00,0.00,0.00,18),('22','242','10','2',625.00,650.00,3561.96,0.00,0.00,0.00,0.00,19),('22','242','10','1',148.00,165.00,10989.10,0.00,0.00,0.00,0.00,20),('22','242','11','2',625.00,650.00,5982.79,0.00,0.00,0.00,0.00,21),('22','242','11','1',148.00,165.00,10790.56,0.00,0.00,0.00,0.00,22),('22','242','12','2',625.00,0.00,3847.02,0.00,0.00,0.00,0.00,23),('22','242','12','1',148.00,165.00,10756.15,0.00,0.00,0.00,0.00,24),('22','242','13','2',625.00,0.00,4264.64,0.00,0.00,0.00,0.00,25),('22','242','13','1',148.00,165.00,10307.88,0.00,0.00,0.00,0.00,26),('22','242','14','2',625.00,0.00,561.89,0.00,0.00,0.00,0.00,27),('22','242','14','1',148.00,165.00,5044.12,0.00,0.00,0.00,0.00,28),('22','242','15','2',625.00,0.00,3580.06,0.00,0.00,0.00,0.00,29),('22','242','15','1',148.00,165.00,11543.46,0.00,0.00,0.00,0.00,30),('22','242','16','2',625.00,0.00,3082.04,0.00,0.00,0.00,0.00,31),('22','242','16','1',148.00,165.00,10313.81,0.00,0.00,0.00,0.00,32),('22','242','17','2',625.00,665.00,4952.42,0.00,0.00,0.00,0.00,33),('22','242','17','1',148.00,165.00,10530.46,0.00,0.00,0.00,0.00,34),('22','242','18','2',625.00,665.00,4551.62,0.00,0.00,0.00,0.00,35),('22','242','18','1',148.00,165.00,10500.50,0.00,0.00,0.00,0.00,36),('22','242','19','2',648.00,0.00,5579.19,0.00,0.00,0.00,0.00,37),('22','242','19','1',148.00,165.00,12807.55,0.00,0.00,0.00,0.00,38),('22','242','20','2',648.00,680.00,3779.79,0.00,0.00,0.00,0.00,39),('22','242','20','1',148.00,165.00,9464.21,0.00,0.00,0.00,0.00,40),('22','242','21','2',648.00,680.00,1811.72,0.00,0.00,0.00,0.00,41),('22','242','21','1',148.00,165.00,4363.46,0.00,0.00,0.00,0.00,42),('22','242','22','2',648.00,680.00,3826.81,0.00,0.00,0.00,0.00,43),('22','242','22','1',148.00,165.00,10781.83,0.00,0.00,0.00,0.00,44),('22','242','23','2',648.00,680.00,6749.98,0.00,0.00,0.00,0.00,45),('22','242','23','1',148.00,165.00,10124.33,0.00,0.00,0.00,0.00,46),('22','242','24','2',648.00,680.00,3561.32,0.00,0.00,0.00,0.00,47),('22','242','24','1',148.00,165.00,10840.38,0.00,0.00,0.00,0.00,48),('22','242','25','2',648.00,0.00,3253.08,0.00,0.00,0.00,0.00,49),('22','242','25','1',148.00,165.00,9585.69,0.00,0.00,0.00,0.00,50),('22','242','26','2',648.00,680.00,4806.07,0.00,0.00,0.00,0.00,51),('22','242','26','1',148.00,165.00,11653.34,0.00,0.00,0.00,0.00,52),('22','242','27','2',670.00,725.00,2600.43,0.00,0.00,0.00,0.00,53),('22','242','27','1',148.00,165.00,9709.84,0.00,0.00,0.00,0.00,54),('22','242','28','2',670.00,720.00,378.28,0.00,0.00,0.00,0.00,55),('22','242','28','1',148.00,165.00,5064.91,0.00,0.00,0.00,0.00,56),('22','242','29','2',670.00,725.00,3235.14,0.00,0.00,0.00,0.00,57),('22','242','29','1',148.00,165.00,11971.98,0.00,0.00,0.00,0.00,58),('22','242','30','2',670.00,725.00,3283.28,0.00,0.00,0.00,0.00,59),('22','242','30','1',148.00,165.00,10684.09,0.00,0.00,0.00,0.00,60),('22','242','31','2',670.00,725.00,5070.06,0.00,0.00,0.00,0.00,61),('22','242','31','1',148.00,165.00,9993.95,0.00,0.00,0.00,0.00,62),('22','242','32','2',670.00,725.00,2594.56,0.00,0.00,0.00,0.00,63),('22','242','32','1',148.00,165.00,10296.59,0.00,0.00,0.00,0.00,64),('22','242','33','2',670.00,725.00,4545.15,0.00,0.00,0.00,0.00,65),('22','242','33','1',148.00,165.00,10505.44,0.00,0.00,0.00,0.00,66),('22','242','34','2',670.00,725.00,5256.04,0.00,0.00,0.00,0.00,67),('22','242','34','1',148.00,165.00,10889.52,0.00,0.00,0.00,0.00,68),('22','242','35','2',670.00,725.00,1393.61,0.00,0.00,0.00,0.00,69),('22','242','35','1',148.00,165.00,4992.46,0.00,0.00,0.00,0.00,70),('22','242','36','2',670.00,725.00,7351.45,0.00,0.00,0.00,0.00,71),('22','242','36','1',148.00,165.00,11191.83,0.00,0.00,0.00,0.00,72),('22','242','37','2',670.00,750.00,5878.74,0.00,0.00,0.00,0.00,73),('22','242','37','1',148.00,165.00,11094.85,0.00,0.00,0.00,0.00,74),('22','242','38','2',670.00,750.00,9350.79,0.00,0.00,0.00,0.00,75),('22','242','38','1',148.00,165.00,10592.95,0.00,0.00,0.00,0.00,76),('22','242','39','2',670.00,750.00,6065.22,0.00,0.00,0.00,0.00,77),('22','242','39','1',148.00,165.00,10502.31,0.00,0.00,0.00,0.00,78),('22','242','40','2',670.00,775.00,5501.40,0.00,0.00,0.00,0.00,79),('22','242','40','1',148.00,165.00,9739.66,0.00,0.00,0.00,0.00,80),('22','242','41','2',740.00,775.00,6211.62,0.00,0.00,0.00,0.00,81),('22','242','41','1',148.00,165.00,9178.52,0.00,0.00,0.00,0.00,82),('22','242','42','2',740.00,800.00,894.10,0.00,0.00,0.00,0.00,83),('22','242','42','1',148.00,165.00,3625.12,0.00,0.00,0.00,0.00,84),('22','242','43','2',740.00,800.00,5048.88,0.00,0.00,0.00,0.00,85),('22','242','43','1',148.00,165.00,9727.63,0.00,0.00,0.00,0.00,86),('22','242','44','2',740.00,800.00,5400.12,0.00,0.00,0.00,0.00,87),('22','242','44','1',148.00,165.00,10314.39,0.00,0.00,0.00,0.00,88),('22','242','45','2',740.00,800.00,4371.76,0.00,0.00,0.00,0.00,89),('22','242','45','1',148.00,165.00,1249.51,0.00,0.00,0.00,0.00,90),('22','242','46','2',740.00,800.00,4244.61,0.00,0.00,0.00,0.00,91),('22','242','46','1',148.00,165.00,9649.49,0.00,0.00,0.00,0.00,92),('22','242','47','2',740.00,800.00,4597.53,0.00,0.00,0.00,0.00,93),('22','242','47','1',148.00,165.00,10460.44,0.00,0.00,0.00,0.00,94),('22','242','48','2',740.00,800.00,3358.54,0.00,0.00,0.00,0.00,95),('22','242','48','1',148.00,165.00,9716.19,0.00,0.00,0.00,0.00,96),('22','242','49','2',760.00,800.00,566.75,0.00,0.00,0.00,0.00,97),('22','242','49','1',148.00,165.00,5898.88,0.00,0.00,0.00,0.00,98),('22','242','50','2',760.00,800.00,5109.08,0.00,0.00,0.00,0.00,99),('22','242','50','1',148.00,165.00,29460.65,0.00,0.00,0.00,0.00,100),('22','242','51','2',760.00,800.00,3354.17,0.00,0.00,0.00,0.00,101),('22','242','51','1',148.00,165.00,25422.24,0.00,0.00,0.00,0.00,102),('22','242','52','2',760.00,800.00,4573.75,0.00,0.00,0.00,0.00,103),('22','242','52','1',148.00,165.00,428.51,0.00,0.00,0.00,0.00,104),('22','242','53','2',760.00,800.00,3542.62,0.00,0.00,0.00,0.00,105),('22','242','53','1',148.00,180.00,7293.54,0.00,0.00,0.00,0.00,106),('22','242','54','2',760.00,800.00,0.00,0.00,0.00,0.00,0.00,107),('22','242','54','1',148.00,165.00,0.00,0.00,0.00,0.00,0.00,108),('22','242','55','2',760.00,800.00,3102.17,0.00,0.00,0.00,0.00,109),('22','242','55','1',148.00,165.00,6076.29,0.00,0.00,0.00,0.00,110),('22','242','56','2',760.00,800.00,2966.51,0.00,0.00,0.00,0.00,111),('22','242','56','1',148.00,165.00,10543.50,0.00,0.00,0.00,0.00,112),('22','242','57','2',760.00,800.00,459.97,0.00,0.00,0.00,0.00,113),('22','242','57','1',148.00,165.00,5599.19,0.00,0.00,0.00,0.00,114),('22','242','58','2',760.00,800.00,3821.17,0.00,0.00,0.00,0.00,115),('22','242','58','1',148.00,165.00,12006.13,0.00,0.00,0.00,0.00,116),('22','242','59','2',760.00,800.00,2574.15,0.00,0.00,0.00,0.00,117),('22','242','59','1',148.00,165.00,12488.08,0.00,0.00,0.00,0.00,118),('22','242','60','2',760.00,800.00,5781.35,0.00,0.00,0.00,0.00,119),('22','242','60','1',148.00,165.00,12734.14,0.00,0.00,0.00,0.00,120),('22','242','61','2',760.00,800.00,2948.65,0.00,0.00,0.00,0.00,121),('22','242','61','1',148.00,165.00,11325.35,0.00,0.00,0.00,0.00,122),('22','242','62','2',760.00,800.00,2404.84,0.00,0.00,0.00,0.00,123),('22','242','62','1',148.00,165.00,12935.66,0.00,0.00,0.00,0.00,124),('22','242','63','2',760.00,800.00,3462.80,0.00,0.00,0.00,0.00,125),('22','242','63','1',148.00,165.00,17712.10,0.00,0.00,0.00,0.00,126),('22','242','64','2',760.00,800.00,1586.78,0.00,0.00,0.00,0.00,127),('22','242','64','1',148.00,165.00,9466.33,0.00,0.00,0.00,0.00,128),('22','242','65','2',760.00,800.00,2966.37,0.00,0.00,0.00,0.00,129),('22','242','65','1',148.00,170.00,30429.03,0.00,0.00,0.00,0.00,130),('22','242','66','2',760.00,800.00,3345.19,0.00,0.00,0.00,0.00,131),('22','242','66','1',148.00,180.00,7284.74,0.00,0.00,0.00,0.00,132),('22','242','67','2',760.00,800.00,3910.09,0.00,0.00,0.00,0.00,133),('22','242','67','1',148.00,185.00,7187.18,0.00,0.00,0.00,0.00,134),('22','242','68','2',760.00,800.00,3592.42,0.00,0.00,0.00,0.00,135),('22','242','68','1',148.00,185.00,8133.70,0.00,0.00,0.00,0.00,136),('22','242','69','2',760.00,800.00,4355.71,0.00,0.00,0.00,0.00,137),('22','242','69','1',148.00,185.00,1730.86,0.00,0.00,0.00,0.00,138),('22','242','70','2',760.00,800.00,3011.96,0.00,0.00,0.00,0.00,139),('22','242','70','1',148.00,185.00,191.75,0.00,0.00,0.00,0.00,140),('22','242','71','2',760.00,800.00,1857.58,0.00,0.00,0.00,0.00,141),('22','242','71','1',148.00,185.00,23.43,0.00,0.00,0.00,0.00,142),('22','242','72','2',760.00,800.00,1379.45,0.00,0.00,0.00,0.00,143),('22','242','72','1',148.00,185.00,13318.98,0.00,0.00,0.00,0.00,144),('22','242','73','2',760.00,800.00,2676.66,0.00,0.00,0.00,0.00,145),('22','242','73','1',148.00,185.00,11602.65,0.00,0.00,0.00,0.00,146),('22','242','74','2',760.00,800.00,2551.20,0.00,0.00,0.00,0.00,147),('22','242','74','1',148.00,185.00,13875.06,0.00,0.00,0.00,0.00,148),('22','242','75','2',760.00,800.00,3079.69,0.00,0.00,0.00,0.00,149),('22','242','75','1',148.00,185.00,6096.71,0.00,0.00,0.00,0.00,150),('22','242','76','2',760.00,800.00,4535.55,0.00,0.00,0.00,0.00,151),('22','242','76','1',148.00,185.00,4478.50,0.00,0.00,0.00,0.00,152),('22','242','77','2',760.00,800.00,3345.75,0.00,0.00,0.00,0.00,153),('22','242','77','1',148.00,185.00,7324.45,0.00,0.00,0.00,0.00,154),('22','242','78','2',760.00,800.00,1142.89,0.00,0.00,0.00,0.00,155),('22','242','78','1',148.00,180.00,5539.20,0.00,0.00,0.00,0.00,156),('22','242','79','2',760.00,800.00,3068.30,0.00,0.00,0.00,0.00,157),('22','242','79','1',148.00,185.00,6240.85,0.00,0.00,0.00,0.00,158),('22','242','80','2',760.00,800.00,2169.55,0.00,0.00,0.00,0.00,159),('22','242','80','1',148.00,185.00,6813.69,0.00,0.00,0.00,0.00,160),('22','242','81','2',760.00,800.00,4910.11,0.00,0.00,0.00,0.00,161),('22','242','81','1',148.00,185.00,8000.00,0.00,0.00,0.00,0.00,162),('22','242','82','2',760.00,800.00,3328.45,0.00,0.00,0.00,0.00,163),('22','242','82','1',148.00,185.00,6239.00,0.00,0.00,0.00,0.00,164),('22','242','83','2',760.00,800.00,2552.14,0.00,0.00,0.00,0.00,165),('22','242','83','1',148.00,185.00,5940.91,0.00,0.00,0.00,0.00,166),('22','242','84','2',760.00,800.00,2892.40,0.00,0.00,0.00,0.00,167),('22','242','84','1',148.00,185.00,4832.57,0.00,0.00,0.00,0.00,168),('22','242','85','2',760.00,800.00,486.25,0.00,0.00,0.00,0.00,169),('22','242','85','1',148.00,185.00,2562.80,0.00,0.00,0.00,0.00,170),('22','242','86','2',760.00,800.00,4134.56,0.00,0.00,0.00,0.00,171),('22','242','86','1',148.00,185.00,6202.99,0.00,0.00,0.00,0.00,172),('22','242','87','2',760.00,800.00,3031.98,0.00,0.00,0.00,0.00,173),('22','242','87','1',148.00,185.00,5996.19,0.00,0.00,0.00,0.00,174),('22','242','88','2',760.00,800.00,2474.99,0.00,0.00,0.00,0.00,175),('22','242','88','1',148.00,185.00,5223.35,0.00,0.00,0.00,0.00,176),('22','242','89','2',760.00,800.00,2071.18,0.00,0.00,0.00,0.00,177),('22','242','89','1',148.00,170.00,7832.46,0.00,0.00,0.00,0.00,178),('22','242','90','2',760.00,800.00,2689.56,0.00,0.00,0.00,0.00,179),('22','242','90','1',148.00,170.00,8840.86,0.00,0.00,0.00,0.00,180),('22','242','91','2',760.00,800.00,1856.14,0.00,0.00,0.00,0.00,181),('22','242','91','1',148.00,170.00,13018.99,0.00,0.00,0.00,0.00,182),('22','242','92','2',760.00,800.00,572.63,0.00,0.00,0.00,0.00,183),('22','242','92','1',148.00,170.00,5374.74,0.00,0.00,0.00,0.00,184),('22','242','93','2',760.00,800.00,2346.71,0.00,0.00,0.00,0.00,185),('22','242','93','1',148.00,170.00,9769.27,0.00,0.00,0.00,0.00,186),('22','242','94','2',760.00,800.00,2271.98,0.00,0.00,0.00,0.00,187),('22','242','94','1',148.00,170.00,9988.17,0.00,0.00,0.00,0.00,188),('22','242','95','2',760.00,800.00,3220.83,0.00,0.00,0.00,0.00,189),('22','242','95','1',148.00,170.00,10455.39,0.00,0.00,0.00,0.00,190),('22','242','96','2',760.00,800.00,1353.19,0.00,0.00,0.00,0.00,191),('22','242','96','1',148.00,170.00,10242.96,0.00,0.00,0.00,0.00,192),('22','242','97','2',760.00,800.00,2191.83,0.00,0.00,0.00,0.00,193),('22','242','97','1',148.00,170.00,8718.20,0.00,0.00,0.00,0.00,194),('22','242','98','2',760.00,800.00,1596.30,0.00,0.00,0.00,0.00,195),('22','242','98','1',148.00,175.00,7237.76,0.00,0.00,0.00,0.00,196),('22','242','99','2',760.00,800.00,1161.45,0.00,0.00,0.00,0.00,197),('22','242','99','1',148.00,175.00,5196.12,0.00,0.00,0.00,0.00,198),('22','242','100','2',760.00,800.00,1935.83,0.00,0.00,0.00,0.00,199),('22','242','100','1',148.00,175.00,5755.40,0.00,0.00,0.00,0.00,200),('22','242','101','2',760.00,800.00,1665.83,0.00,0.00,0.00,0.00,201),('22','242','101','1',148.00,175.00,15.00,0.00,0.00,0.00,0.00,202),('22','242','102','2',760.00,800.00,1851.57,0.00,0.00,0.00,0.00,203),('22','242','102','1',148.00,175.00,56.42,0.00,0.00,0.00,0.00,204),('22','242','103','2',760.00,800.00,3124.65,0.00,0.00,0.00,0.00,205),('22','242','103','1',148.00,175.00,67.85,0.00,0.00,0.00,0.00,206),('22','242','104','2',760.00,800.00,0.00,0.00,0.00,0.00,0.00,207),('22','242','104','1',148.00,175.00,0.00,0.00,0.00,0.00,0.00,208),('22','242','105','2',760.00,800.00,2473.40,0.00,0.00,0.00,0.00,209),('22','242','105','1',148.00,180.00,3392.92,0.00,0.00,0.00,0.00,210),('22','242','106','2',760.00,800.00,2005.76,0.00,0.00,0.00,0.00,211),('22','242','106','1',148.00,180.00,5284.04,0.00,0.00,0.00,0.00,212),('22','242','107','2',760.00,800.00,1143.65,0.00,0.00,0.00,0.00,213),('22','242','107','1',148.00,180.00,4557.30,0.00,0.00,0.00,0.00,214),('22','242','108','2',760.00,800.00,2251.17,0.00,0.00,0.00,0.00,215),('22','242','108','1',148.00,180.00,7858.24,0.00,0.00,0.00,0.00,216),('22','242','109','2',760.00,800.00,2873.90,0.00,0.00,0.00,0.00,217),('22','242','109','1',148.00,180.00,7279.02,0.00,0.00,0.00,0.00,218),('22','242','110','2',760.00,800.00,2798.42,0.00,0.00,0.00,0.00,219),('22','242','110','1',148.00,180.00,6062.40,0.00,0.00,0.00,0.00,220),('22','242','111','2',760.00,800.00,1488.90,0.00,0.00,0.00,0.00,221),('22','242','111','1',148.00,180.00,5329.97,0.00,0.00,0.00,0.00,222),('22','242','112','2',760.00,800.00,2116.29,0.00,0.00,0.00,0.00,223),('22','242','112','1',148.00,180.00,4746.33,0.00,0.00,0.00,0.00,224),('22','242','113','2',760.00,800.00,1058.39,0.00,0.00,0.00,0.00,225),('22','242','113','1',148.00,180.00,100.54,0.00,0.00,0.00,0.00,226),('22','242','114','2',760.00,800.00,364.03,0.00,0.00,0.00,0.00,227),('22','242','114','1',148.00,180.00,30.00,0.00,0.00,0.00,0.00,228),('22','242','115','2',760.00,800.00,1510.32,0.00,0.00,0.00,0.00,229),('22','242','115','1',148.00,180.00,2988.34,0.00,0.00,0.00,0.00,230),('22','242','116','2',760.00,800.00,2191.72,0.00,0.00,0.00,0.00,231),('22','242','116','1',148.00,180.00,4730.58,0.00,0.00,0.00,0.00,232),('22','242','117','2',760.00,775.00,2929.20,0.00,0.00,0.00,0.00,233),('22','242','117','1',148.00,180.00,4929.79,0.00,0.00,0.00,0.00,234),('22','242','118','2',760.00,775.00,1077.73,0.00,0.00,0.00,0.00,235),('22','242','118','1',148.00,180.00,5381.61,0.00,0.00,0.00,0.00,236),('22','242','119','2',760.00,775.00,2596.18,0.00,0.00,0.00,0.00,237),('22','242','119','1',148.00,180.00,6051.05,0.00,0.00,0.00,0.00,238),('22','242','120','2',760.00,775.00,1900.68,0.00,0.00,0.00,0.00,239),('22','242','120','1',148.00,180.00,4340.54,0.00,0.00,0.00,0.00,240),('22','242','121','2',760.00,775.00,1035.87,0.00,0.00,0.00,0.00,241),('22','242','121','1',148.00,180.00,3944.09,0.00,0.00,0.00,0.00,242),('22','242','122','2',760.00,775.00,2021.40,0.00,0.00,0.00,0.00,243),('22','242','122','1',148.00,180.00,5662.81,0.00,0.00,0.00,0.00,244),('22','242','123','2',760.00,800.00,3120.58,0.00,0.00,0.00,0.00,245),('22','242','123','1',148.00,180.00,5326.83,0.00,0.00,0.00,0.00,246),('22','242','124','2',760.00,775.00,2184.70,0.00,0.00,0.00,0.00,247),('22','242','124','1',148.00,180.00,6031.49,0.00,0.00,0.00,0.00,248),('22','242','125','2',760.00,775.00,3463.53,0.00,0.00,0.00,0.00,249),('22','242','125','1',148.00,180.00,6485.30,0.00,0.00,0.00,0.00,250),('22','242','126','2',760.00,775.00,2183.49,0.00,0.00,0.00,0.00,251),('22','242','126','1',148.00,180.00,6383.43,0.00,0.00,0.00,0.00,252),('22','242','127','2',760.00,775.00,2407.90,0.00,0.00,0.00,0.00,253),('22','242','127','1',148.00,180.00,5415.50,0.00,0.00,0.00,0.00,254),('22','242','128','2',760.00,775.00,817.73,0.00,0.00,0.00,0.00,255),('22','242','128','1',148.00,180.00,3455.77,0.00,0.00,0.00,0.00,256),('22','242','129','2',760.00,775.00,4200.50,0.00,0.00,0.00,0.00,257),('22','242','129','1',148.00,180.00,5552.61,0.00,0.00,0.00,0.00,258),('22','242','130','2',760.00,775.00,1423.14,0.00,0.00,0.00,0.00,259),('22','242','130','1',148.00,180.00,6682.34,0.00,0.00,0.00,0.00,260),('22','242','131','2',760.00,775.00,2012.23,0.00,0.00,0.00,0.00,261),('22','242','131','1',148.00,180.00,5468.18,0.00,0.00,0.00,0.00,262),('22','242','132','2',760.00,775.00,1936.53,0.00,0.00,0.00,0.00,263),('22','242','132','1',148.00,180.00,6456.80,0.00,0.00,0.00,0.00,264),('22','242','133','2',760.00,775.00,2426.97,0.00,0.00,0.00,0.00,265),('22','242','133','1',148.00,180.00,5969.38,0.00,0.00,0.00,0.00,266),('22','242','134','2',760.00,775.00,2835.97,0.00,0.00,0.00,0.00,267),('22','242','134','1',148.00,180.00,6302.91,0.00,0.00,0.00,0.00,268),('22','242','135','2',760.00,775.00,893.95,0.00,0.00,0.00,0.00,269),('22','242','135','1',148.00,180.00,3987.45,0.00,0.00,0.00,0.00,270),('22','242','136','2',760.00,775.00,2234.68,0.00,0.00,0.00,0.00,271),('22','242','136','1',148.00,180.00,6754.18,0.00,0.00,0.00,0.00,272),('22','242','137','2',760.00,775.00,1865.50,0.00,0.00,0.00,0.00,273),('22','242','137','1',148.00,175.00,8046.91,0.00,0.00,0.00,0.00,274),('22','242','138','2',760.00,775.00,3931.22,0.00,0.00,0.00,0.00,275),('22','242','138','1',148.00,175.00,6862.77,0.00,0.00,0.00,0.00,276),('22','242','139','2',760.00,775.00,2176.79,0.00,0.00,0.00,0.00,277),('22','242','139','1',148.00,175.00,7088.02,0.00,0.00,0.00,0.00,278),('22','242','140','2',760.00,775.00,1695.29,0.00,0.00,0.00,0.00,279),('22','242','140','1',148.00,175.00,6669.46,0.00,0.00,0.00,0.00,280),('22','242','141','2',760.00,775.00,1868.08,0.00,0.00,0.00,0.00,281),('22','242','141','1',148.00,175.00,6620.76,0.00,0.00,0.00,0.00,282),('22','242','142','2',760.00,775.00,368.09,0.00,0.00,0.00,0.00,283),('22','242','142','1',148.00,175.00,3383.28,0.00,0.00,0.00,0.00,284),('22','242','143','2',760.00,775.00,2350.76,0.00,0.00,0.00,0.00,285),('22','242','143','1',148.00,175.00,6153.22,0.00,0.00,0.00,0.00,286),('22','242','144','2',760.00,775.00,1615.71,0.00,0.00,0.00,0.00,287),('22','242','144','1',148.00,175.00,8101.64,0.00,0.00,0.00,0.00,288),('22','242','145','2',760.00,775.00,2031.37,0.00,0.00,0.00,0.00,289),('22','242','145','1',148.00,175.00,7719.94,0.00,0.00,0.00,0.00,290),('22','242','146','2',760.00,775.00,1593.89,0.00,0.00,0.00,0.00,291),('22','242','146','1',148.00,175.00,5340.88,0.00,0.00,0.00,0.00,292),('22','242','147','2',760.00,775.00,1841.72,0.00,0.00,0.00,0.00,293),('22','242','147','1',148.00,175.00,7097.48,0.00,0.00,0.00,0.00,294),('22','242','148','2',760.00,775.00,2130.99,0.00,0.00,0.00,0.00,295),('22','242','148','1',148.00,175.00,6605.62,0.00,0.00,0.00,0.00,296),('22','242','149','2',760.00,775.00,590.58,0.00,0.00,0.00,0.00,297),('22','242','149','1',148.00,175.00,3838.78,0.00,0.00,0.00,0.00,298),('22','242','150','2',760.00,775.00,3783.92,0.00,0.00,0.00,0.00,299),('22','242','150','1',148.00,175.00,7324.32,0.00,0.00,0.00,0.00,300),('22','242','151','2',760.00,800.00,1789.27,0.00,0.00,0.00,0.00,301),('22','242','151','1',148.00,175.00,6978.59,0.00,0.00,0.00,0.00,302),('22','242','152','2',760.00,850.00,2557.90,0.00,0.00,0.00,0.00,303),('22','242','152','1',148.00,175.00,7536.29,0.00,0.00,0.00,0.00,304),('22','242','153','2',760.00,850.00,1487.05,0.00,0.00,0.00,0.00,305),('22','242','153','1',148.00,175.00,7990.64,0.00,0.00,0.00,0.00,306),('22','242','154','2',760.00,850.00,1513.55,0.00,0.00,0.00,0.00,307),('22','242','154','1',148.00,175.00,8546.38,0.00,0.00,0.00,0.00,308),('22','242','155','2',760.00,850.00,1501.01,0.00,0.00,0.00,0.00,309),('22','242','155','1',148.00,175.00,7262.39,0.00,0.00,0.00,0.00,310),('22','242','156','2',760.00,850.00,535.66,0.00,0.00,0.00,0.00,311),('22','242','156','1',148.00,175.00,4148.06,0.00,0.00,0.00,0.00,312),('22','242','157','2',760.00,850.00,1311.19,0.00,0.00,0.00,0.00,313),('22','242','157','1',148.00,175.00,7279.51,0.00,0.00,0.00,0.00,314),('22','242','158','2',760.00,850.00,947.03,0.00,0.00,0.00,0.00,315),('22','242','158','1',148.00,175.00,8258.13,0.00,0.00,0.00,0.00,316),('22','242','159','2',760.00,850.00,1338.21,0.00,0.00,0.00,0.00,317),('22','242','159','1',148.00,175.00,8576.28,0.00,0.00,0.00,0.00,318),('22','242','160','2',760.00,850.00,1147.55,0.00,0.00,0.00,0.00,319),('22','242','160','1',148.00,175.00,7606.55,0.00,0.00,0.00,0.00,320),('22','242','161','2',760.00,850.00,2469.27,0.00,0.00,0.00,0.00,321),('22','242','161','1',148.00,175.00,7287.73,0.00,0.00,0.00,0.00,322),('22','242','162','2',760.00,850.00,1694.79,0.00,0.00,0.00,0.00,323),('22','242','162','1',148.00,175.00,6772.58,0.00,0.00,0.00,0.00,324),('22','242','163','2',760.00,850.00,836.14,0.00,0.00,0.00,0.00,325),('22','242','163','1',148.00,175.00,3610.81,0.00,0.00,0.00,0.00,326),('22','242','164','2',760.00,850.00,473.11,0.00,0.00,0.00,0.00,327),('22','242','164','1',148.00,175.00,7008.89,0.00,0.00,0.00,0.00,328),('22','242','165','2',760.00,850.00,1063.06,0.00,0.00,0.00,0.00,329),('22','242','165','1',148.00,175.00,7519.50,0.00,0.00,0.00,0.00,330),('22','242','166','2',760.00,850.00,1394.60,0.00,0.00,0.00,0.00,331),('22','242','166','1',148.00,175.00,7534.98,0.00,0.00,0.00,0.00,332),('22','242','167','2',760.00,850.00,1476.27,0.00,0.00,0.00,0.00,333),('22','242','167','1',148.00,175.00,6658.08,0.00,0.00,0.00,0.00,334),('22','242','168','2',760.00,850.00,864.74,0.00,0.00,0.00,0.00,335),('22','242','168','1',148.00,175.00,7153.24,0.00,0.00,0.00,0.00,336),('22','242','169','2',760.00,850.00,2880.29,0.00,0.00,0.00,0.00,337),('22','242','169','1',148.00,175.00,7555.24,0.00,0.00,0.00,0.00,338),('22','242','170','2',760.00,850.00,510.57,0.00,0.00,0.00,0.00,339),('22','242','170','1',148.00,175.00,4194.95,0.00,0.00,0.00,0.00,340),('22','242','171','2',760.00,850.00,1035.01,0.00,0.00,0.00,0.00,341),('22','242','171','1',148.00,175.00,7345.16,0.00,0.00,0.00,0.00,342),('22','242','172','2',760.00,850.00,1109.84,0.00,0.00,0.00,0.00,343),('22','242','172','1',148.00,175.00,8296.22,0.00,0.00,0.00,0.00,344),('22','242','173','2',760.00,850.00,908.57,0.00,0.00,0.00,0.00,345),('22','242','173','1',148.00,175.00,7231.94,0.00,0.00,0.00,0.00,346),('22','242','174','2',760.00,850.00,2370.16,0.00,0.00,0.00,0.00,347),('22','242','174','1',148.00,175.00,6867.08,0.00,0.00,0.00,0.00,348),('22','242','175','2',760.00,850.00,1350.53,0.00,0.00,0.00,0.00,349),('22','242','175','1',148.00,175.00,5796.19,0.00,0.00,0.00,0.00,350),('22','242','176','2',760.00,850.00,1970.15,0.00,0.00,0.00,0.00,351),('22','242','176','1',148.00,175.00,1467.26,0.00,0.00,0.00,0.00,352),('22','242','177','2',760.00,850.00,420.03,0.00,0.00,0.00,0.00,353),('22','242','177','1',148.00,175.00,926.19,0.00,0.00,0.00,0.00,354),('22','242','178','2',760.00,850.00,1839.28,0.00,0.00,0.00,0.00,355),('22','242','178','1',148.00,175.00,89.28,0.00,0.00,0.00,0.00,356),('22','242','179','2',760.00,850.00,2315.71,0.00,0.00,0.00,0.00,357),('22','242','179','1',148.00,175.00,437.73,0.00,0.00,0.00,0.00,358),('22','242','180','2',760.00,850.00,1837.33,0.00,0.00,0.00,0.00,359),('22','242','180','1',148.00,175.00,371.09,0.00,0.00,0.00,0.00,360),('22','242','181','2',760.00,850.00,1651.56,0.00,0.00,0.00,0.00,361),('22','242','181','1',148.00,175.00,5258.75,0.00,0.00,0.00,0.00,362),('22','242','182','2',760.00,850.00,0.00,0.00,0.00,0.00,0.00,363),('22','242','182','1',148.00,185.00,0.00,0.00,0.00,0.00,0.00,364);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('22',1,'242','PMS Group','PMS Group'),('22',2,'242','AGO Group','AGO Group');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('22','242','1',1,0,'1','PMS Tank 1',45000.00,0.00,NULL,'Tank 1','793','2022-03-22 11:40:08','2022-04-12 13:40:34','793',5,0),('22','242','1',2,0,'1','PMS Tank 2',45000.00,0.00,NULL,'Tank 2','793','2022-03-22 11:50:56','2022-05-04 17:42:17','808',5,0),('22','242','2',3,0,'2','AGO tank 1',45000.00,0.00,NULL,'AGO - Tank 1','793','2022-03-22 11:52:06','2022-03-22 11:52:06','793',5,0),('22','242','2',4,0,'2','AGO tank 2',33000.00,0.00,NULL,'AGO - Tank 2','793','2022-03-22 11:52:41','2022-04-12 13:33:44','793',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
INSERT INTO `hr_departments` VALUES (1,'22','242','ATTENDANCE','','2022-04-16 13:25:53','793','2022-04-16 13:25:53','793'),(2,'22','242','CASHIER','COUNTING OF MONEY','2022-04-21 16:21:47','793','2022-04-21 16:21:47','793'),(3,'22','242','CAPTAIN','IN-CHARGE OF DIPPING, OPENING & CLOSING METER FOR ATTENDANT ','2022-04-21 16:26:11','793','2022-04-21 16:26:11','793'),(4,'22','242','SUPERVISOR','SUPERVISE CAPTAIN & CASHIER','2022-04-21 16:33:29','793','2022-04-21 16:33:29','793'),(5,'22','242','ACCOUNTANT','IN-CHARGE OF MONEY FUND','2022-04-21 16:34:54','793','2022-04-21 16:34:54','793'),(6,'22','242','MANAGER','IN-CHARGE OF ALL ACTIVITIES IN ALL STATION','2022-04-21 16:36:18','793','2022-04-21 16:36:18','793');
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
INSERT INTO `hr_employees` VALUES ('22','242',1,'ALLI','SAHEED','','M','2012-04-10','SSCE','AJANGBADI,ORILE IGANMU','LAGOS','LAGOS','Nigeria','','08092894448','YES','4334','','','',1,'1','FUEL','2021-08-10',0,'0','0000-00-00','','2022-04-20 20:06:40','793','793','2022-04-20 20:06:40'),('22','242',2,'SEMIU ','BASIRAT','','F','2022-04-25','SSCE','ORILE IGANMU','LAGOS','LAGOS','Nigeria','','09134974091','YES','4334','','','',1,'1','','2021-04-07',0,'0','0000-00-00','','2022-04-20 19:39:25','793','793','2022-04-20 19:39:25'),('22','242',3,'LAWAL','YUSUF','','M','1995-06-11','SSCE','AJEGUNLE','LAGOS','LAGOS','Nigeria','','08120106841','YES','4334','','','',1,'1','','2021-06-14',0,'0','0000-00-00','','2022-04-20 19:43:26','793','793','2022-04-20 19:43:26'),('22','242',4,'ALAMEEN','FATHIA','','F','2000-02-15','SSCE','NO.44 COKER ROAD ORILE IGANMU','LAGOS','LAGOS','Nigeria','','08157182887','YES','4334','','','',1,'1','FUEL','2021-11-17',0,'0','0000-00-00','NO.44 COKER ROAD ORILE IGANMU','2022-04-21 17:16:32','793','793','2022-04-21 17:16:32'),('22','242',5,'AYETOSHO','TEMITOPE','','F','2000-12-13','SSCE','OPELOYERU,ORILE IGANMU','LAGOS','LAGOS','Nigeria','','09162961957','YES','4334','','','',1,'1','','2021-11-17',0,'0','0000-00-00','OPELOYERU,ORILE IGANMU','2022-04-21 12:51:00','793','793','2022-04-21 12:51:00'),('22','242',6,'ABIKOYE','DOLAPO','RACHAEL','F','1997-11-28','SSCE','20, IMAM STREET, AMUKOKO, ','LAGOS','LAGOS','Nigeria','','07082574022','','4334','','','',1,'1','','2022-04-28',0,'0','0000-00-00','','2022-05-06 14:05:07','808','808','2022-05-06 14:05:07'),('22','242',7,'BALOGUN','DAMILARE','','M','1995-04-21','SSCE','','LAGOS','LAGOS','Nigeria','','09036252391','YES','4334','','','',1,'1','','2021-07-20',0,'0','0000-00-00','','2022-04-21 14:37:11','793','793','2022-04-21 14:37:11'),('22','242',8,'BALOGUN','VICTORIA','','F','2000-11-16','SSCE','ORILE,IGANMU','LAGOS','LAGOS','Nigeria','','09057336621','YES','4334','','','',1,'1','','2021-10-12',0,'0','0000-00-00','','2022-04-20 19:57:13','793','793','2022-04-20 19:57:13'),('22','242',9,'INNOCENT','VIVIAN','','F','1998-09-08','SSCE','ORILE,IGANMU','LAGOS','LAGOS','Nigeria','','08154011979','YES','4334','','','',1,'1','','2022-03-23',0,'0','0000-00-00','','2022-04-20 19:59:47','793','793','2022-04-20 19:59:47'),('22','242',10,'ADEOSUN','SHUKURAT','','F','2001-12-02','SSCE','NO.13 OPELOYERU, ORILE IGANMU','LAGOS','LAGOS','Nigeria','','','YES','4334','','','',1,'1','','2021-09-14',0,'0','0000-00-00','NO.13 OPELOYERU, ORILE IGANMU','2022-04-21 17:15:40','793','793','2022-04-21 17:15:40'),('22','242',11,'TAIWO ','QUAM','','M','1997-07-14','SSCE','','LAGOS','LAGOS','Nigeria','','08107769716','YES','4334','','','',1,'1','','2022-03-17',0,'0','0000-00-00','','2022-04-21 14:33:55','793','793','2022-04-21 14:33:55'),('22','242',12,'MURAINA','BUKOLA','','F','1990-07-14','SSCE','','LAGOS','LAGOS','Nigeria','','09071351795','YES','4334','','','',1,'1','','2022-08-03',0,'0','0000-00-00','','2022-04-21 17:14:40','793','793','2022-04-21 17:14:40'),('22','242',13,'OKUNOLA','DAMILOLA','','F','1997-12-26','SSCE','','LAGOS','LAGOS','Nigeria','','070117665205','YES','4334','','','',1,'1','','2021-07-30',0,'0','0000-00-00','','2022-04-21 17:13:47','793','793','2022-04-21 17:13:47'),('22','242',14,'MURAINA','KABIR','','M','2001-05-20','SSCE','','LAGOS','LAGOS','Nigeria','','09039692625','YES','4334','','','',1,'1','','2022-01-12',0,'0','0000-00-00','','2022-04-21 14:29:36','793','793','2022-04-21 14:29:36'),('22','242',15,'OLATUNMISE ','ARINOLA','','F','2002-09-23','SSCE','','LAGOS','LAGOS','Nigeria','','08090584668','YES','4334','','','',1,'1','','2022-03-30',0,'0','0000-00-00','','2022-04-21 17:11:50','793','793','2022-04-21 17:11:50'),('22','242',16,'ADEFILA','OLABAYO','','M','1990-05-05','SSCE','','LAGOS','LAGOS','Nigeria','','08059767981','YES','4334','','','',1,'1','','2021-04-30',0,'0','0000-00-00','','2022-04-21 14:40:27','793','793','2022-04-21 14:40:27');
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
INSERT INTO `hr_levels` VALUES ('22','242',1,'LEVEL 1',20000.00,15,0.00,5,'ATTEND TO CUSTOMER','793','2022-04-16 13:32:05','2022-04-21 16:47:07','793'),('22','242',2,'CAPTAIN',360000.00,20,0.00,5,'','793','2022-04-21 16:50:00','2022-04-21 16:51:38','793'),('22','242',3,'SUPERVISOR',600000.00,20,0.00,5,'','793','2022-04-21 16:53:06','2022-04-21 16:53:28','793'),('22','242',4,'ACCOUNTANT',660000.00,20,0.00,5,'','793','2022-04-21 16:54:48','2022-04-21 16:56:12','793'),('22','242',5,'MANAGER',720000.00,20,0.00,5,'','793','2022-04-21 16:58:33','2022-04-21 17:03:39','793');
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2512 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (1,'22','242',NULL,2,'Purchased from MAO PETROLEUM COMPANY LTD',0.00,25000000.00,40000.00,0.00,0.00,'2022-05-05 14:08:39','',''),(2,'22','242',NULL,2,'Reception corrector for bridging 5',0.00,0.00,0.00,27000.00,0.00,'2022-05-05 15:06:42','',''),(3,'22','242','3',2,'Received from bridging 5',0.00,0.00,27000.00,0.00,0.00,'2022-05-05 15:06:42','',''),(4,'22','242',NULL,2,'Reception corrector for bridging 6',0.00,0.00,0.00,13000.00,0.00,'2022-05-05 15:07:23','',''),(5,'22','242','4',2,'Received from bridging 6',0.00,0.00,13000.00,0.00,0.00,'2022-05-05 15:07:23','',''),(6,'22','242',NULL,1,'Purchased from FIRST ROYAL OIL & GAS LTD',0.00,5920000.00,40000.00,0.00,0.00,'2022-05-06 12:59:03','',''),(7,'22','242','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,27000.00,0.00,'2022-05-06 15:22:22','',''),(8,'22','242','3',0,'Inventory adjustment from tank dipping to 42400',0.00,0.00,42400.00,0.00,0.00,'2022-05-06 15:22:22','',''),(9,'22','242','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,13000.00,0.00,'2022-05-06 15:23:30','',''),(10,'22','242','4',0,'Inventory adjustment from tank dipping to 23800',0.00,0.00,23800.00,0.00,0.00,'2022-05-06 15:23:30','',''),(11,'22','242','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,0.00,0.00,'2022-05-06 15:24:29','',''),(12,'22','242','1',0,'Inventory adjustment from tank dipping to 26800',0.00,0.00,26800.00,0.00,0.00,'2022-05-06 15:24:29','',''),(13,'22','242','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,0.00,0.00,'2022-05-06 15:29:32','',''),(14,'22','242','2',0,'Inventory adjustment from tank dipping to 15200',0.00,0.00,15200.00,0.00,0.00,'2022-05-06 15:29:32','',''),(15,'22','242',NULL,1,'Reception corrector for bridging 8',0.00,0.00,0.00,13500.00,0.00,'2022-05-07 11:03:40','',''),(16,'22','242','2',1,'Received from bridging 8',0.00,0.00,13500.00,0.00,0.00,'2022-05-07 11:03:40','',''),(17,'22','242','3',2,'Sale Id shift 5',0.00,0.00,0.00,2389.65,0.00,'2022-05-07 11:40:05','',''),(18,'22','242','4',2,'Sale Id shift 5',0.00,0.00,0.00,1610.00,0.00,'2022-05-07 11:40:05','',''),(19,'22','242','1',1,'Sale Id shift 5',0.00,0.00,0.00,1617.57,0.00,'2022-05-07 11:40:05','',''),(20,'22','242','1',1,'Sale Id shift 5',0.00,0.00,0.00,1190.83,0.00,'2022-05-07 11:40:05','',''),(21,'22','242','1',1,'Sale Id shift 5',0.00,0.00,0.00,1651.01,0.00,'2022-05-07 11:40:05','',''),(22,'22','242','1',1,'Sale Id shift 5',0.00,0.00,0.00,926.67,0.00,'2022-05-07 11:40:05','',''),(23,'22','242','2',1,'Sale Id shift 5',0.00,0.00,0.00,1414.29,0.00,'2022-05-07 11:40:05','',''),(24,'22','242','2',1,'Sale Id shift 5',0.00,0.00,0.00,1006.74,0.00,'2022-05-07 11:40:05','',''),(25,'22','242','2',1,'Sale Id shift 5',0.00,0.00,0.00,1010.19,0.00,'2022-05-07 11:40:05','',''),(26,'22','242','2',1,'Sale Id shift 5',0.00,0.00,0.00,273.41,0.00,'2022-05-07 11:40:05','',''),(27,'22','242',NULL,2,'Sale Id shift 5',2499781.25,0.00,0.00,0.00,0.00,'2022-05-07 11:40:05','',''),(28,'22','242',NULL,1,'Sale Id shift 5',1345425.08,0.00,0.00,0.00,0.00,'2022-05-07 11:40:05','',''),(29,'22','242','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,40010.35,0.00,'2022-05-07 12:05:26','',''),(30,'22','242','3',0,'Inventory adjustment from tank dipping to 39500',0.00,0.00,39500.00,0.00,0.00,'2022-05-07 12:05:26','',''),(31,'22','242','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,22190.00,0.00,'2022-05-07 12:06:04','',''),(32,'22','242','4',0,'Inventory adjustment from tank dipping to 22100',0.00,0.00,22100.00,0.00,0.00,'2022-05-07 12:06:04','',''),(33,'22','242','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,21413.92,0.00,'2022-05-07 12:06:54','',''),(34,'22','242','1',0,'Inventory adjustment from tank dipping to 21650',0.00,0.00,21650.00,0.00,0.00,'2022-05-07 12:06:54','',''),(35,'22','242','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,24995.37,0.00,'2022-05-07 12:09:01','',''),(36,'22','242','2',0,'Inventory adjustment from tank dipping to 11600',0.00,0.00,11600.00,0.00,0.00,'2022-05-07 12:09:01','',''),(37,'22','242','1',1,'Sale Id shift 6',0.00,0.00,0.00,1335.73,0.00,'2022-05-08 10:03:13','',''),(38,'22','242','2',1,'Sale Id shift 6',0.00,0.00,0.00,2047.64,0.00,'2022-05-08 10:03:13','',''),(39,'22','242','1',1,'Sale Id shift 6',0.00,0.00,0.00,1151.70,0.00,'2022-05-08 10:03:13','',''),(40,'22','242','2',1,'Sale Id shift 6',0.00,0.00,0.00,702.29,0.00,'2022-05-08 10:03:13','',''),(41,'22','242','2',1,'Sale Id shift 6',0.00,0.00,0.00,577.91,0.00,'2022-05-08 10:03:13','',''),(42,'22','242','2',1,'Sale Id shift 6',0.00,0.00,0.00,208.76,0.00,'2022-05-08 10:03:13','',''),(43,'22','242','3',2,'Sale Id shift 6',0.00,0.00,0.00,365.36,0.00,'2022-05-08 10:03:13','',''),(44,'22','242','3',2,'Sale Id shift 6',0.00,0.00,0.00,1788.30,0.00,'2022-05-08 10:03:13','',''),(45,'22','242','4',2,'Sale Id shift 6',0.00,0.00,0.00,961.44,0.00,'2022-05-08 10:03:13','',''),(46,'22','242','1',1,'Sale Id shift 6',0.00,0.00,0.00,2572.32,0.00,'2022-05-08 10:03:13','',''),(47,'22','242','1',1,'Sale Id shift 6',0.00,0.00,0.00,1526.99,0.00,'2022-05-08 10:03:13','',''),(48,'22','242','1',1,'Sale Id shift 6',0.00,0.00,0.00,2058.64,0.00,'2022-05-08 10:03:13','',''),(49,'22','242',NULL,2,'Sale Id shift 6',1946937.50,0.00,0.00,0.00,0.00,'2022-05-08 10:03:13','',''),(50,'22','242',NULL,1,'Sale Id shift 6',1802933.04,0.00,0.00,0.00,0.00,'2022-05-08 10:03:13','',''),(51,'22','242','1',1,'Sale Id shift 7',0.00,0.00,0.00,621.19,0.00,'2022-05-08 18:47:56','',''),(52,'22','242','2',1,'Sale Id shift 7',0.00,0.00,0.00,693.76,0.00,'2022-05-08 18:47:56','',''),(53,'22','242','1',1,'Sale Id shift 7',0.00,0.00,0.00,539.11,0.00,'2022-05-08 18:47:56','',''),(54,'22','242','2',1,'Sale Id shift 7',0.00,0.00,0.00,464.98,0.00,'2022-05-08 18:47:56','',''),(55,'22','242','3',2,'Sale Id shift 7',0.00,0.00,0.00,136.37,0.00,'2022-05-08 18:47:56','',''),(56,'22','242','3',2,'Sale Id shift 7',0.00,0.00,0.00,478.30,0.00,'2022-05-08 18:47:56','',''),(57,'22','242','4',2,'Sale Id shift 7',0.00,0.00,0.00,300.00,0.00,'2022-05-08 18:47:56','',''),(58,'22','242','1',1,'Sale Id shift 7',0.00,0.00,0.00,1011.98,0.00,'2022-05-08 18:47:56','',''),(59,'22','242','1',1,'Sale Id shift 7',0.00,0.00,0.00,778.71,0.00,'2022-05-08 18:47:56','',''),(60,'22','242','1',1,'Sale Id shift 7',0.00,0.00,0.00,1296.33,0.00,'2022-05-08 18:47:56','',''),(61,'22','242',NULL,2,'Sale Id shift 7',571668.75,0.00,0.00,0.00,0.00,'2022-05-08 18:47:56','',''),(62,'22','242',NULL,1,'Sale Id shift 7',800096.88,0.00,0.00,0.00,0.00,'2022-05-08 18:47:56','',''),(63,'22','242','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,36731.67,0.00,'2022-05-09 08:47:46','',''),(64,'22','242','3',0,'Inventory adjustment from tank dipping to 37400',0.00,0.00,37400.00,0.00,0.00,'2022-05-09 08:47:46','',''),(65,'22','242','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,20838.56,0.00,'2022-05-09 08:49:33','',''),(66,'22','242','4',0,'Inventory adjustment from tank dipping to 21100',0.00,0.00,21100.00,0.00,0.00,'2022-05-09 08:49:33','',''),(67,'22','242','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,8757.30,0.00,'2022-05-09 08:53:00','',''),(68,'22','242','1',0,'Inventory adjustment from tank dipping to 13700',0.00,0.00,13700.00,0.00,0.00,'2022-05-09 08:53:00','',''),(69,'22','242','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,6904.66,0.00,'2022-05-09 08:53:30','',''),(70,'22','242','2',0,'Inventory adjustment from tank dipping to 8200',0.00,0.00,8200.00,0.00,0.00,'2022-05-09 08:53:30','',''),(71,'22','242','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,37400.00,0.00,'2022-05-09 08:54:27','',''),(72,'22','242','3',0,'Inventory adjustment from tank dipping to 36800',0.00,0.00,36800.00,0.00,0.00,'2022-05-09 08:54:27','',''),(73,'22','242','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,21100.00,0.00,'2022-05-09 08:54:55','',''),(74,'22','242','4',0,'Inventory adjustment from tank dipping to 20900',0.00,0.00,20900.00,0.00,0.00,'2022-05-09 08:54:55','',''),(75,'22','242','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,13700.00,0.00,'2022-05-09 08:55:18','',''),(76,'22','242','1',0,'Inventory adjustment from tank dipping to 9800',0.00,0.00,9800.00,0.00,0.00,'2022-05-09 08:55:18','',''),(77,'22','242','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,8200.00,0.00,'2022-05-09 08:55:46','',''),(78,'22','242','2',0,'Inventory adjustment from tank dipping to 7000',0.00,0.00,7000.00,0.00,0.00,'2022-05-09 08:55:46','',''),(79,'22','242','1',1,'Sale Id shift 8',0.00,0.00,0.00,1236.46,0.00,'2022-05-10 11:23:57','',''),(80,'22','242','2',1,'Sale Id shift 8',0.00,0.00,0.00,1863.41,0.00,'2022-05-10 11:23:57','',''),(81,'22','242','1',1,'Sale Id shift 8',0.00,0.00,0.00,1267.26,0.00,'2022-05-10 11:23:57','',''),(82,'22','242','2',1,'Sale Id shift 8',0.00,0.00,0.00,981.57,0.00,'2022-05-10 11:23:57','',''),(83,'22','242','2',1,'Sale Id shift 8',0.00,0.00,0.00,589.60,0.00,'2022-05-10 11:23:57','',''),(84,'22','242','2',1,'Sale Id shift 8',0.00,0.00,0.00,384.61,0.00,'2022-05-10 11:23:57','',''),(85,'22','242','3',2,'Sale Id shift 8',0.00,0.00,0.00,621.51,0.00,'2022-05-10 11:23:57','',''),(86,'22','242','3',2,'Sale Id shift 8',0.00,0.00,0.00,1662.51,0.00,'2022-05-10 11:23:57','',''),(87,'22','242','4',2,'Sale Id shift 8',0.00,0.00,0.00,2369.42,0.00,'2022-05-10 11:23:57','',''),(88,'22','242','1',1,'Sale Id shift 8',0.00,0.00,0.00,1911.68,0.00,'2022-05-10 11:23:57','',''),(89,'22','242','1',1,'Sale Id shift 8',0.00,0.00,0.00,1937.09,0.00,'2022-05-10 11:23:57','',''),(90,'22','242','1',1,'Sale Id shift 8',0.00,0.00,0.00,1967.02,0.00,'2022-05-10 11:23:57','',''),(91,'22','242',NULL,2,'Sale Id shift 8',2908400.00,0.00,0.00,0.00,0.00,'2022-05-10 11:23:57','',''),(92,'22','242',NULL,1,'Sale Id shift 8',1796527.60,0.00,0.00,0.00,0.00,'2022-05-10 11:23:57','',''),(93,'22','242',NULL,1,'Reception corrector for bridging 7',0.00,0.00,0.00,26500.00,0.00,'2022-05-10 19:08:33','',''),(94,'22','242','1',1,'Received from bridging 7',0.00,0.00,26500.00,0.00,0.00,'2022-05-10 19:08:33','',''),(95,'22','242',NULL,1,'Purchased from AA RANO NIGERIA LIMITED',0.00,5920000.00,40000.00,0.00,0.00,'2022-05-10 19:09:55','',''),(96,'22','242',NULL,1,'Reception corrector for bridging 10',0.00,0.00,0.00,13500.00,0.00,'2022-05-10 19:17:20','',''),(97,'22','242','2',1,'Received from bridging 10',0.00,0.00,13500.00,0.00,0.00,'2022-05-10 19:17:20','',''),(98,'22','242',NULL,1,'Reception corrector for bridging 12',0.00,0.00,0.00,9500.00,0.00,'2022-05-10 19:27:34','',''),(99,'22','242','2',1,'Received from bridging 12',0.00,0.00,9500.00,0.00,0.00,'2022-05-10 19:27:34','',''),(100,'22','242',NULL,1,'Reception corrector for bridging 11',0.00,0.00,0.00,17000.00,0.00,'2022-05-10 19:27:52','',''),(101,'22','242','1',1,'Received from bridging 11',0.00,0.00,17000.00,0.00,0.00,'2022-05-10 19:27:52','',''),(102,'22','242',NULL,1,'Purchased from FIRST ROYAL OIL & GAS LTD',0.00,5920000.00,40000.00,0.00,0.00,'2022-05-12 19:51:45','',''),(103,'22','242','1',1,'Sale Id shift 9',0.00,0.00,0.00,600.30,0.00,'2022-05-12 20:19:37','',''),(104,'22','242','2',1,'Sale Id shift 9',0.00,0.00,0.00,2599.53,0.00,'2022-05-12 20:19:37','',''),(105,'22','242','2',1,'Sale Id shift 9',0.00,0.00,0.00,1410.22,0.00,'2022-05-12 20:19:37','',''),(106,'22','242','2',1,'Sale Id shift 9',0.00,0.00,0.00,1053.68,0.00,'2022-05-12 20:19:37','',''),(107,'22','242','2',1,'Sale Id shift 9',0.00,0.00,0.00,402.62,0.00,'2022-05-12 20:19:37','',''),(108,'22','242','3',2,'Sale Id shift 9',0.00,0.00,0.00,1081.39,0.00,'2022-05-12 20:19:37','',''),(109,'22','242','3',2,'Sale Id shift 9',0.00,0.00,0.00,2029.35,0.00,'2022-05-12 20:19:37','',''),(110,'22','242','4',2,'Sale Id shift 9',0.00,0.00,0.00,950.57,0.00,'2022-05-12 20:19:37','',''),(111,'22','242','1',1,'Sale Id shift 9',0.00,0.00,0.00,1249.18,0.00,'2022-05-12 20:19:37','',''),(112,'22','242','1',1,'Sale Id shift 9',0.00,0.00,0.00,502.66,0.00,'2022-05-12 20:19:37','',''),(113,'22','242','1',1,'Sale Id shift 9',0.00,0.00,0.00,1107.45,0.00,'2022-05-12 20:19:37','',''),(114,'22','242',NULL,2,'Sale Id shift 9',2538318.75,0.00,0.00,0.00,0.00,'2022-05-12 20:19:37','',''),(115,'22','242',NULL,1,'Sale Id shift 9',1320994.72,0.00,0.00,0.00,0.00,'2022-05-12 20:19:37','',''),(116,'22','242','1',1,'Sale Id shift 10',0.00,0.00,0.00,1306.69,0.00,'2022-05-12 21:03:19','',''),(117,'22','242','2',1,'Sale Id shift 10',0.00,0.00,0.00,1387.08,0.00,'2022-05-12 21:03:19','',''),(118,'22','242','1',1,'Sale Id shift 10',0.00,0.00,0.00,1149.30,0.00,'2022-05-12 21:03:19','',''),(119,'22','242','2',1,'Sale Id shift 10',0.00,0.00,0.00,1449.92,0.00,'2022-05-12 21:03:19','',''),(120,'22','242','2',1,'Sale Id shift 10',0.00,0.00,0.00,654.11,0.00,'2022-05-12 21:03:19','',''),(121,'22','242','2',1,'Sale Id shift 10',0.00,0.00,0.00,156.95,0.00,'2022-05-12 21:03:19','',''),(122,'22','242','3',2,'Sale Id shift 10',0.00,0.00,0.00,1113.76,0.00,'2022-05-12 21:03:19','',''),(123,'22','242','3',2,'Sale Id shift 10',0.00,0.00,0.00,1648.20,0.00,'2022-05-12 21:03:19','',''),(124,'22','242','4',2,'Sale Id shift 10',0.00,0.00,0.00,800.00,0.00,'2022-05-12 21:03:19','',''),(125,'22','242','1',1,'Sale Id shift 10',0.00,0.00,0.00,2068.45,0.00,'2022-05-12 21:03:19','',''),(126,'22','242','1',1,'Sale Id shift 10',0.00,0.00,0.00,1051.76,0.00,'2022-05-12 21:03:19','',''),(127,'22','242','1',1,'Sale Id shift 10',0.00,0.00,0.00,1764.84,0.00,'2022-05-12 21:03:19','',''),(128,'22','242',NULL,2,'Sale Id shift 10',2226225.00,0.00,0.00,0.00,0.00,'2022-05-12 21:03:19','',''),(129,'22','242',NULL,1,'Sale Id shift 10',1626386.80,0.00,0.00,0.00,0.00,'2022-05-12 21:03:19','',''),(130,'22','242','1',1,'Sale Id shift 11',0.00,0.00,0.00,1170.04,0.00,'2022-05-12 22:07:02','',''),(131,'22','242','2',1,'Sale Id shift 11',0.00,0.00,0.00,1627.55,0.00,'2022-05-12 22:07:02','',''),(132,'22','242','1',1,'Sale Id shift 11',0.00,0.00,0.00,1167.39,0.00,'2022-05-12 22:07:02','',''),(133,'22','242','2',1,'Sale Id shift 11',0.00,0.00,0.00,1119.42,0.00,'2022-05-12 22:07:02','',''),(134,'22','242','2',1,'Sale Id shift 11',0.00,0.00,0.00,1068.24,0.00,'2022-05-12 22:07:02','',''),(135,'22','242','2',1,'Sale Id shift 11',0.00,0.00,0.00,579.60,0.00,'2022-05-12 22:07:02','',''),(136,'22','242','3',2,'Sale Id shift 11',0.00,0.00,0.00,956.62,0.00,'2022-05-12 22:07:02','',''),(137,'22','242','3',2,'Sale Id shift 11',0.00,0.00,0.00,1536.17,0.00,'2022-05-12 22:07:02','',''),(138,'22','242','4',2,'Sale Id shift 11',0.00,0.00,0.00,3490.00,0.00,'2022-05-12 22:07:02','',''),(139,'22','242','1',1,'Sale Id shift 11',0.00,0.00,0.00,1319.69,0.00,'2022-05-12 22:07:02','',''),(140,'22','242','1',1,'Sale Id shift 11',0.00,0.00,0.00,917.52,0.00,'2022-05-12 22:07:02','',''),(141,'22','242','1',1,'Sale Id shift 11',0.00,0.00,0.00,1821.11,0.00,'2022-05-12 22:07:02','',''),(142,'22','242',NULL,2,'Sale Id shift 11',3739243.75,0.00,0.00,0.00,0.00,'2022-05-12 22:07:02','',''),(143,'22','242',NULL,1,'Sale Id shift 11',1597002.88,0.00,0.00,0.00,0.00,'2022-05-12 22:07:02','',''),(144,'22','242','1',1,'Sale Id shift 12',0.00,0.00,0.00,1032.31,0.00,'2022-05-13 22:00:54','',''),(145,'22','242','2',1,'Sale Id shift 12',0.00,0.00,0.00,1338.24,0.00,'2022-05-13 22:00:54','',''),(146,'22','242','1',1,'Sale Id shift 12',0.00,0.00,0.00,1297.37,0.00,'2022-05-13 22:00:54','',''),(147,'22','242','2',1,'Sale Id shift 12',0.00,0.00,0.00,527.19,0.00,'2022-05-13 22:00:54','',''),(148,'22','242','2',1,'Sale Id shift 12',0.00,0.00,0.00,891.78,0.00,'2022-05-13 22:00:54','',''),(149,'22','242','2',1,'Sale Id shift 12',0.00,0.00,0.00,666.31,0.00,'2022-05-13 22:00:54','',''),(150,'22','242','3',2,'Sale Id shift 12',0.00,0.00,0.00,1010.08,0.00,'2022-05-13 22:00:54','',''),(151,'22','242','3',2,'Sale Id shift 12',0.00,0.00,0.00,2026.94,0.00,'2022-05-13 22:00:54','',''),(152,'22','242','4',2,'Sale Id shift 12',0.00,0.00,0.00,810.00,0.00,'2022-05-13 22:00:54','',''),(153,'22','242','1',1,'Sale Id shift 12',0.00,0.00,0.00,2183.02,0.00,'2022-05-13 22:00:54','',''),(154,'22','242','1',1,'Sale Id shift 12',0.00,0.00,0.00,1030.46,0.00,'2022-05-13 22:00:54','',''),(155,'22','242','1',1,'Sale Id shift 12',0.00,0.00,0.00,1789.47,0.00,'2022-05-13 22:00:54','',''),(156,'22','242',NULL,2,'Sale Id shift 12',2404387.50,0.00,0.00,0.00,0.00,'2022-05-13 22:00:54','',''),(157,'22','242',NULL,1,'Sale Id shift 12',1591910.20,0.00,0.00,0.00,0.00,'2022-05-13 22:00:54','',''),(158,'22','242','1',1,'Sale Id shift 13',0.00,0.00,0.00,1341.66,0.00,'2022-05-15 10:18:56','',''),(159,'22','242','1',1,'Sale Id shift 13',0.00,0.00,0.00,1723.24,0.00,'2022-05-15 10:18:56','',''),(160,'22','242','2',1,'Sale Id shift 13',0.00,0.00,0.00,1127.66,0.00,'2022-05-15 10:18:56','',''),(161,'22','242','2',1,'Sale Id shift 13',0.00,0.00,0.00,1166.49,0.00,'2022-05-15 10:18:56','',''),(162,'22','242','2',1,'Sale Id shift 13',0.00,0.00,0.00,555.12,0.00,'2022-05-15 10:18:56','',''),(163,'22','242','3',2,'Sale Id shift 13',0.00,0.00,0.00,984.28,0.00,'2022-05-15 10:18:56','',''),(164,'22','242','3',2,'Sale Id shift 13',0.00,0.00,0.00,1270.36,0.00,'2022-05-15 10:18:56','',''),(165,'22','242','4',2,'Sale Id shift 13',0.00,0.00,0.00,2010.00,0.00,'2022-05-15 10:18:56','',''),(166,'22','242','1',1,'Sale Id shift 13',0.00,0.00,0.00,1157.85,0.00,'2022-05-15 10:18:56','',''),(167,'22','242','1',1,'Sale Id shift 13',0.00,0.00,0.00,1150.58,0.00,'2022-05-15 10:18:56','',''),(168,'22','242','1',1,'Sale Id shift 13',0.00,0.00,0.00,2085.28,0.00,'2022-05-15 10:18:56','',''),(169,'22','242',NULL,2,'Sale Id shift 13',2665400.00,0.00,0.00,0.00,0.00,'2022-05-15 10:18:56','',''),(170,'22','242',NULL,1,'Sale Id shift 13',1525566.24,0.00,0.00,0.00,0.00,'2022-05-15 10:18:56','',''),(171,'22','242','1',1,'Sale Id shift 14',0.00,0.00,0.00,638.64,0.00,'2022-05-16 17:34:04','',''),(172,'22','242','2',1,'Sale Id shift 14',0.00,0.00,0.00,690.37,0.00,'2022-05-16 17:34:04','',''),(173,'22','242','2',1,'Sale Id shift 14',0.00,0.00,0.00,556.89,0.00,'2022-05-16 17:34:04','',''),(174,'22','242','2',1,'Sale Id shift 14',0.00,0.00,0.00,166.64,0.00,'2022-05-16 17:34:04','',''),(175,'22','242','3',2,'Sale Id shift 14',0.00,0.00,0.00,223.68,0.00,'2022-05-16 17:34:04','',''),(176,'22','242','3',2,'Sale Id shift 14',0.00,0.00,0.00,338.21,0.00,'2022-05-16 17:34:04','',''),(177,'22','242','1',1,'Sale Id shift 14',0.00,0.00,0.00,1230.96,0.00,'2022-05-16 17:34:04','',''),(178,'22','242','1',1,'Sale Id shift 14',0.00,0.00,0.00,827.09,0.00,'2022-05-16 17:34:04','',''),(179,'22','242','1',1,'Sale Id shift 14',0.00,0.00,0.00,933.53,0.00,'2022-05-16 17:34:04','',''),(180,'22','242',NULL,2,'Sale Id shift 14',351181.25,0.00,0.00,0.00,0.00,'2022-05-16 17:34:04','',''),(181,'22','242',NULL,1,'Sale Id shift 14',746529.76,0.00,0.00,0.00,0.00,'2022-05-16 17:34:04','',''),(182,'22','242','1',1,'Sale Id shift 15',0.00,0.00,0.00,986.81,0.00,'2022-05-16 21:51:39','',''),(183,'22','242','2',1,'Sale Id shift 15',0.00,0.00,0.00,1828.52,0.00,'2022-05-16 21:51:39','',''),(184,'22','242','1',1,'Sale Id shift 15',0.00,0.00,0.00,2026.06,0.00,'2022-05-16 21:51:39','',''),(185,'22','242','2',1,'Sale Id shift 15',0.00,0.00,0.00,1306.75,0.00,'2022-05-16 21:51:39','',''),(186,'22','242','2',1,'Sale Id shift 15',0.00,0.00,0.00,1052.94,0.00,'2022-05-16 21:51:39','',''),(187,'22','242','2',1,'Sale Id shift 15',0.00,0.00,0.00,278.03,0.00,'2022-05-16 21:51:39','',''),(188,'22','242','3',2,'Sale Id shift 15',0.00,0.00,0.00,847.25,0.00,'2022-05-16 21:51:39','',''),(189,'22','242','3',2,'Sale Id shift 15',0.00,0.00,0.00,1447.81,0.00,'2022-05-16 21:51:39','',''),(190,'22','242','4',2,'Sale Id shift 15',0.00,0.00,0.00,1285.00,0.00,'2022-05-16 21:51:39','',''),(191,'22','242','1',1,'Sale Id shift 15',0.00,0.00,0.00,1801.54,0.00,'2022-05-16 21:51:39','',''),(192,'22','242','1',1,'Sale Id shift 15',0.00,0.00,0.00,944.04,0.00,'2022-05-16 21:51:39','',''),(193,'22','242','1',1,'Sale Id shift 15',0.00,0.00,0.00,1318.77,0.00,'2022-05-16 21:51:39','',''),(194,'22','242',NULL,2,'Sale Id shift 15',2237537.50,0.00,0.00,0.00,0.00,'2022-05-16 21:51:39','',''),(195,'22','242',NULL,1,'Sale Id shift 15',1708432.08,0.00,0.00,0.00,0.00,'2022-05-16 21:51:39','',''),(196,'22','242',NULL,1,'Reception corrector for bridging 16',0.00,0.00,0.00,39980.49,0.00,'2022-05-17 22:00:55','',''),(197,'22','242','2',1,'Received from bridging 16',0.00,0.00,39980.49,0.00,0.00,'2022-05-17 22:00:55','',''),(198,'22','242',NULL,1,'Reception corrector for bridging 15',0.00,0.00,0.00,19.51,0.00,'2022-05-17 22:01:15','',''),(199,'22','242','1',1,'Received from bridging 15',0.00,0.00,19.51,0.00,0.00,'2022-05-17 22:01:15','',''),(200,'22','242',NULL,1,'Purchased from AA RANO NIGERIA LIMITED',0.00,5920000.00,40000.00,0.00,0.00,'2022-05-17 22:04:16','',''),(201,'22','242',NULL,1,'Reception corrector for bridging 18',0.00,0.00,0.00,4500.00,0.00,'2022-05-17 22:08:25','',''),(202,'22','242','2',1,'Received from bridging 18',0.00,0.00,4500.00,0.00,0.00,'2022-05-17 22:08:25','',''),(203,'22','242',NULL,1,'Reception corrector for bridging 17',0.00,0.00,0.00,35500.00,0.00,'2022-05-17 22:08:54','',''),(204,'22','242','1',1,'Received from bridging 17',0.00,0.00,35500.00,0.00,0.00,'2022-05-17 22:08:54','',''),(205,'22','242','1',1,'Sale Id shift 16',0.00,0.00,0.00,614.48,0.00,'2022-05-17 22:13:48','',''),(206,'22','242','2',1,'Sale Id shift 16',0.00,0.00,0.00,1640.73,0.00,'2022-05-17 22:13:48','',''),(207,'22','242','1',1,'Sale Id shift 16',0.00,0.00,0.00,1664.83,0.00,'2022-05-17 22:13:48','',''),(208,'22','242','2',1,'Sale Id shift 16',0.00,0.00,0.00,1026.18,0.00,'2022-05-17 22:13:48','',''),(209,'22','242','2',1,'Sale Id shift 16',0.00,0.00,0.00,1420.02,0.00,'2022-05-17 22:13:48','',''),(210,'22','242','2',1,'Sale Id shift 16',0.00,0.00,0.00,399.88,0.00,'2022-05-17 22:13:48','',''),(211,'22','242','3',2,'Sale Id shift 16',0.00,0.00,0.00,807.27,0.00,'2022-05-17 22:13:48','',''),(212,'22','242','3',2,'Sale Id shift 16',0.00,0.00,0.00,1264.77,0.00,'2022-05-17 22:13:48','',''),(213,'22','242','4',2,'Sale Id shift 16',0.00,0.00,0.00,1010.00,0.00,'2022-05-17 22:13:48','',''),(214,'22','242','1',1,'Sale Id shift 16',0.00,0.00,0.00,1383.12,0.00,'2022-05-17 22:13:48','',''),(215,'22','242','1',1,'Sale Id shift 16',0.00,0.00,0.00,958.04,0.00,'2022-05-17 22:13:48','',''),(216,'22','242','1',1,'Sale Id shift 16',0.00,0.00,0.00,1206.53,0.00,'2022-05-17 22:13:48','',''),(217,'22','242',NULL,2,'Sale Id shift 16',1926275.00,0.00,0.00,0.00,0.00,'2022-05-17 22:13:48','',''),(218,'22','242',NULL,1,'Sale Id shift 16',1526443.88,0.00,0.00,0.00,0.00,'2022-05-17 22:13:48','',''),(219,'22','242','1',1,'Sale Id shift 17',0.00,0.00,0.00,1027.13,0.00,'2022-05-19 15:27:15','',''),(220,'22','242','2',1,'Sale Id shift 17',0.00,0.00,0.00,1069.29,0.00,'2022-05-19 15:27:15','',''),(221,'22','242','1',1,'Sale Id shift 17',0.00,0.00,0.00,1462.20,0.00,'2022-05-19 15:27:15','',''),(222,'22','242','2',1,'Sale Id shift 17',0.00,0.00,0.00,893.58,0.00,'2022-05-19 15:27:15','',''),(223,'22','242','2',1,'Sale Id shift 17',0.00,0.00,0.00,722.04,0.00,'2022-05-19 15:27:15','',''),(224,'22','242','2',1,'Sale Id shift 17',0.00,0.00,0.00,292.68,0.00,'2022-05-19 15:27:15','',''),(225,'22','242','3',2,'Sale Id shift 17',0.00,0.00,0.00,950.25,0.00,'2022-05-19 15:27:15','',''),(226,'22','242','3',2,'Sale Id shift 17',0.00,0.00,0.00,1321.47,0.00,'2022-05-19 15:27:15','',''),(227,'22','242','4',2,'Sale Id shift 17',0.00,0.00,0.00,2680.70,0.00,'2022-05-19 15:27:15','',''),(228,'22','242','1',1,'Sale Id shift 17',0.00,0.00,0.00,1868.26,0.00,'2022-05-19 15:27:15','',''),(229,'22','242','1',1,'Sale Id shift 17',0.00,0.00,0.00,1468.81,0.00,'2022-05-19 15:27:15','',''),(230,'22','242','1',1,'Sale Id shift 17',0.00,0.00,0.00,1726.47,0.00,'2022-05-19 15:27:15','',''),(231,'22','242',NULL,2,'Sale Id shift 17',3095262.50,0.00,0.00,0.00,0.00,'2022-05-19 15:27:15','',''),(232,'22','242',NULL,1,'Sale Id shift 17',1558508.08,0.00,0.00,0.00,0.00,'2022-05-19 15:27:15','',''),(233,'22','242',NULL,2,'Purchased from CHIPET INTERNATIONAL LTD',0.00,29160000.00,45000.00,0.00,0.00,'2022-05-19 15:47:03','',''),(234,'22','242','1',1,'Sale Id shift 18',0.00,0.00,0.00,688.60,0.00,'2022-05-20 16:10:17','',''),(235,'22','242','2',1,'Sale Id shift 18',0.00,0.00,0.00,1686.40,0.00,'2022-05-20 16:10:17','',''),(236,'22','242','1',1,'Sale Id shift 18',0.00,0.00,0.00,174.23,0.00,'2022-05-20 16:10:17','',''),(237,'22','242','2',1,'Sale Id shift 18',0.00,0.00,0.00,1344.63,0.00,'2022-05-20 16:10:17','',''),(238,'22','242','2',1,'Sale Id shift 18',0.00,0.00,0.00,906.62,0.00,'2022-05-20 16:10:17','',''),(239,'22','242','2',1,'Sale Id shift 18',0.00,0.00,0.00,321.18,0.00,'2022-05-20 16:10:17','',''),(240,'22','242','3',2,'Sale Id shift 18',0.00,0.00,0.00,1158.01,0.00,'2022-05-20 16:10:17','',''),(241,'22','242','3',2,'Sale Id shift 18',0.00,0.00,0.00,1921.38,0.00,'2022-05-20 16:10:17','',''),(242,'22','242','4',2,'Sale Id shift 18',0.00,0.00,0.00,1472.23,0.00,'2022-05-20 16:10:17','',''),(243,'22','242','1',1,'Sale Id shift 18',0.00,0.00,0.00,2344.49,0.00,'2022-05-20 16:10:17','',''),(244,'22','242','1',1,'Sale Id shift 18',0.00,0.00,0.00,1413.18,0.00,'2022-05-20 16:10:17','',''),(245,'22','242','1',1,'Sale Id shift 18',0.00,0.00,0.00,1621.17,0.00,'2022-05-20 16:10:17','',''),(246,'22','242',NULL,2,'Sale Id shift 18',2844762.50,0.00,0.00,0.00,0.00,'2022-05-20 16:10:17','',''),(247,'22','242',NULL,1,'Sale Id shift 18',1554074.00,0.00,0.00,0.00,0.00,'2022-05-20 16:10:17','',''),(248,'22','242','1',1,'Sale Id shift 19',0.00,0.00,0.00,891.56,0.00,'2022-05-20 22:12:38','',''),(249,'22','242','2',1,'Sale Id shift 19',0.00,0.00,0.00,1498.88,0.00,'2022-05-20 22:12:38','',''),(250,'22','242','1',1,'Sale Id shift 19',0.00,0.00,0.00,1724.16,0.00,'2022-05-20 22:12:38','',''),(251,'22','242','2',1,'Sale Id shift 19',0.00,0.00,0.00,1549.03,0.00,'2022-05-20 22:12:38','',''),(252,'22','242','2',1,'Sale Id shift 19',0.00,0.00,0.00,1584.00,0.00,'2022-05-20 22:12:38','',''),(253,'22','242','2',1,'Sale Id shift 19',0.00,0.00,0.00,701.26,0.00,'2022-05-20 22:12:38','',''),(254,'22','242','3',2,'Sale Id shift 19',0.00,0.00,0.00,1589.23,0.00,'2022-05-20 22:12:38','',''),(255,'22','242','3',2,'Sale Id shift 19',0.00,0.00,0.00,2499.96,0.00,'2022-05-20 22:12:38','',''),(256,'22','242','4',2,'Sale Id shift 19',0.00,0.00,0.00,1490.00,0.00,'2022-05-20 22:12:38','',''),(257,'22','242','1',1,'Sale Id shift 19',0.00,0.00,0.00,2015.88,0.00,'2022-05-20 22:12:38','',''),(258,'22','242','1',1,'Sale Id shift 19',0.00,0.00,0.00,1531.28,0.00,'2022-05-20 22:12:38','',''),(259,'22','242','1',1,'Sale Id shift 19',0.00,0.00,0.00,1311.50,0.00,'2022-05-20 22:12:38','',''),(260,'22','242',NULL,2,'Sale Id shift 19',3615315.12,0.00,0.00,0.00,0.00,'2022-05-20 22:12:38','',''),(261,'22','242',NULL,1,'Sale Id shift 19',1895517.40,0.00,0.00,0.00,0.00,'2022-05-20 22:12:38','',''),(262,'22','242','1',1,'Sale Id shift 20',0.00,0.00,0.00,1334.35,0.00,'2022-05-22 08:53:08','',''),(263,'22','242','2',1,'Sale Id shift 20',0.00,0.00,0.00,1314.46,0.00,'2022-05-22 08:53:08','',''),(264,'22','242','1',1,'Sale Id shift 20',0.00,0.00,0.00,1143.94,0.00,'2022-05-22 08:53:08','',''),(265,'22','242','2',1,'Sale Id shift 20',0.00,0.00,0.00,1054.38,0.00,'2022-05-22 08:53:08','',''),(266,'22','242','2',1,'Sale Id shift 20',0.00,0.00,0.00,938.79,0.00,'2022-05-22 08:53:08','',''),(267,'22','242','2',1,'Sale Id shift 20',0.00,0.00,0.00,249.07,0.00,'2022-05-22 08:53:08','',''),(268,'22','242','3',2,'Sale Id shift 20',0.00,0.00,0.00,1149.53,0.00,'2022-05-22 08:53:08','',''),(269,'22','242','3',2,'Sale Id shift 20',0.00,0.00,0.00,1150.34,0.00,'2022-05-22 08:53:08','',''),(270,'22','242','4',2,'Sale Id shift 20',0.00,0.00,0.00,1479.92,0.00,'2022-05-22 08:53:08','',''),(271,'22','242','1',1,'Sale Id shift 20',0.00,0.00,0.00,561.60,0.00,'2022-05-22 08:53:08','',''),(272,'22','242','1',1,'Sale Id shift 20',0.00,0.00,0.00,924.56,0.00,'2022-05-22 08:53:08','',''),(273,'22','242','1',1,'Sale Id shift 20',0.00,0.00,0.00,1943.06,0.00,'2022-05-22 08:53:08','',''),(274,'22','242',NULL,2,'Sale Id shift 20',2449303.92,0.00,0.00,0.00,0.00,'2022-05-22 08:53:08','',''),(275,'22','242',NULL,1,'Sale Id shift 20',1400703.08,0.00,0.00,0.00,0.00,'2022-05-22 08:53:08','',''),(276,'22','242','1',1,'Sale Id shift 21',0.00,0.00,0.00,392.53,0.00,'2022-05-23 09:40:23','',''),(277,'22','242','2',1,'Sale Id shift 21',0.00,0.00,0.00,321.85,0.00,'2022-05-23 09:40:23','',''),(278,'22','242','1',1,'Sale Id shift 21',0.00,0.00,0.00,347.30,0.00,'2022-05-23 09:40:23','',''),(279,'22','242','2',1,'Sale Id shift 21',0.00,0.00,0.00,298.70,0.00,'2022-05-23 09:40:23','',''),(280,'22','242','2',1,'Sale Id shift 21',0.00,0.00,0.00,227.60,0.00,'2022-05-23 09:40:23','',''),(281,'22','242','3',2,'Sale Id shift 21',0.00,0.00,0.00,78.09,0.00,'2022-05-23 09:40:23','',''),(282,'22','242','3',2,'Sale Id shift 21',0.00,0.00,0.00,923.63,0.00,'2022-05-23 09:40:23','',''),(283,'22','242','4',2,'Sale Id shift 21',0.00,0.00,0.00,810.00,0.00,'2022-05-23 09:40:23','',''),(284,'22','242','1',1,'Sale Id shift 21',0.00,0.00,0.00,1005.70,0.00,'2022-05-23 09:40:23','',''),(285,'22','242','1',1,'Sale Id shift 21',0.00,0.00,0.00,1053.87,0.00,'2022-05-23 09:40:23','',''),(286,'22','242','1',1,'Sale Id shift 21',0.00,0.00,0.00,715.91,0.00,'2022-05-23 09:40:23','',''),(287,'22','242',NULL,2,'Sale Id shift 21',1173994.56,0.00,0.00,0.00,0.00,'2022-05-23 09:40:23','',''),(288,'22','242',NULL,1,'Sale Id shift 21',645792.08,0.00,0.00,0.00,0.00,'2022-05-23 09:40:23','',''),(289,'22','242',NULL,1,'Purchased from AA RANO NIGERIA LIMITED',0.00,5920000.00,40000.00,0.00,0.00,'2022-05-24 09:46:52','',''),(290,'22','242',NULL,2,'Reception corrector for bridging 19',0.00,0.00,0.00,30000.00,0.00,'2022-05-24 09:49:00','',''),(291,'22','242','3',2,'Received from bridging 19',0.00,0.00,30000.00,0.00,0.00,'2022-05-24 09:49:00','',''),(292,'22','242',NULL,2,'Reception corrector for bridging 20',0.00,0.00,0.00,15000.00,0.00,'2022-05-24 09:49:31','',''),(293,'22','242','4',2,'Received from bridging 20',0.00,0.00,15000.00,0.00,0.00,'2022-05-24 09:49:31','',''),(294,'22','242',NULL,1,'Reception corrector for bridging 22',0.00,0.00,0.00,13000.00,0.00,'2022-05-24 09:59:41','',''),(295,'22','242','2',1,'Received from bridging 22',0.00,0.00,13000.00,0.00,0.00,'2022-05-24 09:59:41','',''),(296,'22','242',NULL,1,'Reception corrector for bridging 21',0.00,0.00,0.00,27000.00,0.00,'2022-05-24 10:00:03','',''),(297,'22','242','1',1,'Received from bridging 21',0.00,0.00,27000.00,0.00,0.00,'2022-05-24 10:00:03','',''),(298,'22','242','1',1,'Sale Id shift 22',0.00,0.00,0.00,756.70,0.00,'2022-05-24 10:02:52','',''),(299,'22','242','2',1,'Sale Id shift 22',0.00,0.00,0.00,1514.84,0.00,'2022-05-24 10:02:52','',''),(300,'22','242','1',1,'Sale Id shift 22',0.00,0.00,0.00,942.40,0.00,'2022-05-24 10:02:52','',''),(301,'22','242','2',1,'Sale Id shift 22',0.00,0.00,0.00,1062.73,0.00,'2022-05-24 10:02:52','',''),(302,'22','242','2',1,'Sale Id shift 22',0.00,0.00,0.00,708.22,0.00,'2022-05-24 10:02:52','',''),(303,'22','242','2',1,'Sale Id shift 22',0.00,0.00,0.00,199.99,0.00,'2022-05-24 10:02:52','',''),(304,'22','242','3',2,'Sale Id shift 22',0.00,0.00,0.00,698.39,0.00,'2022-05-24 10:02:52','',''),(305,'22','242','3',2,'Sale Id shift 22',0.00,0.00,0.00,2818.42,0.00,'2022-05-24 10:02:52','',''),(306,'22','242','4',2,'Sale Id shift 22',0.00,0.00,0.00,310.00,0.00,'2022-05-24 10:02:52','',''),(307,'22','242','1',1,'Sale Id shift 22',0.00,0.00,0.00,2663.45,0.00,'2022-05-24 10:02:52','',''),(308,'22','242','1',1,'Sale Id shift 22',0.00,0.00,0.00,1537.83,0.00,'2022-05-24 10:02:52','',''),(309,'22','242','1',1,'Sale Id shift 22',0.00,0.00,0.00,1395.67,0.00,'2022-05-24 10:02:52','',''),(310,'22','242',NULL,2,'Sale Id shift 22',2479772.88,0.00,0.00,0.00,0.00,'2022-05-24 10:02:52','',''),(311,'22','242',NULL,1,'Sale Id shift 22',1595710.84,0.00,0.00,0.00,0.00,'2022-05-24 10:02:52','',''),(312,'22','242','1',1,'Sale Id shift 23',0.00,0.00,0.00,940.15,0.00,'2022-05-25 12:30:22','',''),(313,'22','242','2',1,'Sale Id shift 23',0.00,0.00,0.00,1040.24,0.00,'2022-05-25 12:30:22','',''),(314,'22','242','1',1,'Sale Id shift 23',0.00,0.00,0.00,1976.32,0.00,'2022-05-25 12:30:22','',''),(315,'22','242','2',1,'Sale Id shift 23',0.00,0.00,0.00,824.52,0.00,'2022-05-25 12:30:22','',''),(316,'22','242','2',1,'Sale Id shift 23',0.00,0.00,0.00,842.04,0.00,'2022-05-25 12:30:22','',''),(317,'22','242','2',1,'Sale Id shift 23',0.00,0.00,0.00,109.08,0.00,'2022-05-25 12:30:22','',''),(318,'22','242','3',2,'Sale Id shift 23',0.00,0.00,0.00,2251.42,0.00,'2022-05-25 12:30:22','',''),(319,'22','242','3',2,'Sale Id shift 23',0.00,0.00,0.00,3188.56,0.00,'2022-05-25 12:30:22','',''),(320,'22','242','4',2,'Sale Id shift 23',0.00,0.00,0.00,1310.00,0.00,'2022-05-25 12:30:22','',''),(321,'22','242','1',1,'Sale Id shift 23',0.00,0.00,0.00,1672.38,0.00,'2022-05-25 12:30:22','',''),(322,'22','242','1',1,'Sale Id shift 23',0.00,0.00,0.00,1151.23,0.00,'2022-05-25 12:30:22','',''),(323,'22','242','1',1,'Sale Id shift 23',0.00,0.00,0.00,1568.37,0.00,'2022-05-25 12:30:22','',''),(324,'22','242',NULL,2,'Sale Id shift 23',4373987.04,0.00,0.00,0.00,0.00,'2022-05-25 12:30:22','',''),(325,'22','242',NULL,1,'Sale Id shift 23',1498400.84,0.00,0.00,0.00,0.00,'2022-05-25 12:30:22','',''),(326,'22','242','1',1,'Sale Id shift 24',0.00,0.00,0.00,1375.22,0.00,'2022-05-26 16:29:48','',''),(327,'22','242','2',1,'Sale Id shift 24',0.00,0.00,0.00,1734.75,0.00,'2022-05-26 16:29:48','',''),(328,'22','242','1',1,'Sale Id shift 24',0.00,0.00,0.00,1570.45,0.00,'2022-05-26 16:29:48','',''),(329,'22','242','2',1,'Sale Id shift 24',0.00,0.00,0.00,1302.87,0.00,'2022-05-26 16:29:48','',''),(330,'22','242','2',1,'Sale Id shift 24',0.00,0.00,0.00,673.41,0.00,'2022-05-26 16:29:48','',''),(331,'22','242','2',1,'Sale Id shift 24',0.00,0.00,0.00,373.27,0.00,'2022-05-26 16:29:48','',''),(332,'22','242','3',2,'Sale Id shift 24',0.00,0.00,0.00,792.49,0.00,'2022-05-26 16:29:48','',''),(333,'22','242','3',2,'Sale Id shift 24',0.00,0.00,0.00,1288.83,0.00,'2022-05-26 16:29:48','',''),(334,'22','242','4',2,'Sale Id shift 24',0.00,0.00,0.00,1480.00,0.00,'2022-05-26 16:29:48','',''),(335,'22','242','1',1,'Sale Id shift 24',0.00,0.00,0.00,1025.67,0.00,'2022-05-26 16:29:48','',''),(336,'22','242','1',1,'Sale Id shift 24',0.00,0.00,0.00,750.87,0.00,'2022-05-26 16:29:48','',''),(337,'22','242','1',1,'Sale Id shift 24',0.00,0.00,0.00,2033.87,0.00,'2022-05-26 16:29:48','',''),(338,'22','242',NULL,2,'Sale Id shift 24',2307735.36,0.00,0.00,0.00,0.00,'2022-05-26 16:29:48','',''),(339,'22','242',NULL,1,'Sale Id shift 24',1604376.24,0.00,0.00,0.00,0.00,'2022-05-26 16:29:48','',''),(340,'22','242',NULL,1,'Purchased from STALLIONAIRE NIGERIA LIMITED',0.00,6660000.00,45000.00,0.00,0.00,'2022-05-27 18:13:37','',''),(341,'22','242',NULL,1,'Reception corrector for bridging 24',0.00,0.00,0.00,15000.00,0.00,'2022-05-27 18:20:21','',''),(342,'22','242','2',1,'Received from bridging 24',0.00,0.00,15000.00,0.00,0.00,'2022-05-27 18:20:21','',''),(343,'22','242',NULL,1,'Reception corrector for bridging 23',0.00,0.00,0.00,30000.00,0.00,'2022-05-27 18:20:49','',''),(344,'22','242','1',1,'Received from bridging 23',0.00,0.00,30000.00,0.00,0.00,'2022-05-27 18:20:49','',''),(345,'22','242','2',1,'Sale Id shift 25',0.00,0.00,0.00,3948.46,0.00,'2022-05-27 22:06:13','',''),(346,'22','242','2',1,'Sale Id shift 25',0.00,0.00,0.00,2828.57,0.00,'2022-05-27 22:06:13','',''),(347,'22','242','2',1,'Sale Id shift 25',0.00,0.00,0.00,2027.23,0.00,'2022-05-27 22:06:13','',''),(348,'22','242','2',1,'Sale Id shift 25',0.00,0.00,0.00,781.43,0.00,'2022-05-27 22:06:13','',''),(349,'22','242','3',2,'Sale Id shift 25',0.00,0.00,0.00,1278.82,0.00,'2022-05-27 22:06:13','',''),(350,'22','242','3',2,'Sale Id shift 25',0.00,0.00,0.00,1364.26,0.00,'2022-05-27 22:06:13','',''),(351,'22','242','4',2,'Sale Id shift 25',0.00,0.00,0.00,610.00,0.00,'2022-05-27 22:06:13','',''),(352,'22','242',NULL,2,'Sale Id shift 25',2107995.84,0.00,0.00,0.00,0.00,'2022-05-27 22:06:13','',''),(353,'22','242',NULL,1,'Sale Id shift 25',1418682.12,0.00,0.00,0.00,0.00,'2022-05-27 22:06:13','',''),(354,'22','242','1',1,'Sale Id shift 26',0.00,0.00,0.00,1210.07,0.00,'2022-05-27 22:15:40','',''),(355,'22','242','2',1,'Sale Id shift 26',0.00,0.00,0.00,1250.71,0.00,'2022-05-27 22:15:40','',''),(356,'22','242','1',1,'Sale Id shift 26',0.00,0.00,0.00,1183.35,0.00,'2022-05-27 22:15:40','',''),(357,'22','242','2',1,'Sale Id shift 26',0.00,0.00,0.00,1120.23,0.00,'2022-05-27 22:15:40','',''),(358,'22','242','2',1,'Sale Id shift 26',0.00,0.00,0.00,846.08,0.00,'2022-05-27 22:15:40','',''),(359,'22','242','2',1,'Sale Id shift 26',0.00,0.00,0.00,74.53,0.00,'2022-05-27 22:15:40','',''),(360,'22','242','3',2,'Sale Id shift 26',0.00,0.00,0.00,1413.54,0.00,'2022-05-27 22:15:40','',''),(361,'22','242','3',2,'Sale Id shift 26',0.00,0.00,0.00,1182.53,0.00,'2022-05-27 22:15:40','',''),(362,'22','242','4',2,'Sale Id shift 26',0.00,0.00,0.00,2210.00,0.00,'2022-05-27 22:15:40','',''),(363,'22','242','1',1,'Sale Id shift 26',0.00,0.00,0.00,2677.94,0.00,'2022-05-27 22:15:40','',''),(364,'22','242','1',1,'Sale Id shift 26',0.00,0.00,0.00,1747.10,0.00,'2022-05-27 22:15:40','',''),(365,'22','242','1',1,'Sale Id shift 26',0.00,0.00,0.00,1543.33,0.00,'2022-05-27 22:15:40','',''),(366,'22','242',NULL,2,'Sale Id shift 26',3114333.36,0.00,0.00,0.00,0.00,'2022-05-27 22:15:40','',''),(367,'22','242',NULL,1,'Sale Id shift 26',1724694.32,0.00,0.00,0.00,0.00,'2022-05-27 22:15:40','',''),(368,'22','242',NULL,2,'Purchased from CHIPET INTERNATIONAL LTD',0.00,30150000.00,45000.00,0.00,0.00,'2022-05-28 14:31:30','',''),(369,'22','242',NULL,2,'Reception corrector for bridging 26',0.00,0.00,0.00,20500.00,0.00,'2022-05-28 14:35:51','',''),(370,'22','242','4',2,'Received from bridging 26',0.00,0.00,20500.00,0.00,0.00,'2022-05-28 14:35:51','',''),(371,'22','242',NULL,2,'Reception corrector for bridging 25',0.00,0.00,0.00,24500.00,0.00,'2022-05-28 14:36:13','',''),(372,'22','242','3',2,'Received from bridging 25',0.00,0.00,24500.00,0.00,0.00,'2022-05-28 14:36:13','',''),(373,'22','242','1',1,'Sale Id shift 27',0.00,0.00,0.00,1418.63,0.00,'2022-05-28 20:37:58','',''),(374,'22','242','2',1,'Sale Id shift 27',0.00,0.00,0.00,1608.93,0.00,'2022-05-28 20:37:58','',''),(375,'22','242','1',1,'Sale Id shift 27',0.00,0.00,0.00,1166.43,0.00,'2022-05-28 20:37:58','',''),(376,'22','242','2',1,'Sale Id shift 27',0.00,0.00,0.00,774.52,0.00,'2022-05-28 20:37:58','',''),(377,'22','242','2',1,'Sale Id shift 27',0.00,0.00,0.00,839.70,0.00,'2022-05-28 20:37:58','',''),(378,'22','242','2',1,'Sale Id shift 27',0.00,0.00,0.00,267.85,0.00,'2022-05-28 20:37:58','',''),(379,'22','242','3',2,'Sale Id shift 27',0.00,0.00,0.00,314.02,0.00,'2022-05-28 20:37:58','',''),(380,'22','242','3',2,'Sale Id shift 27',0.00,0.00,0.00,493.40,0.00,'2022-05-28 20:37:58','',''),(381,'22','242','4',2,'Sale Id shift 27',0.00,0.00,0.00,1793.01,0.00,'2022-05-28 20:37:58','',''),(382,'22','242','1',1,'Sale Id shift 27',0.00,0.00,0.00,1046.25,0.00,'2022-05-28 20:37:58','',''),(383,'22','242','1',1,'Sale Id shift 27',0.00,0.00,0.00,1010.30,0.00,'2022-05-28 20:37:58','',''),(384,'22','242','1',1,'Sale Id shift 27',0.00,0.00,0.00,1577.23,0.00,'2022-05-28 20:37:58','',''),(385,'22','242',NULL,2,'Sale Id shift 27',1742288.10,0.00,0.00,0.00,0.00,'2022-05-28 20:37:58','',''),(386,'22','242',NULL,1,'Sale Id shift 27',1437056.32,0.00,0.00,0.00,0.00,'2022-05-28 20:37:58','',''),(387,'22','242','1',1,'Sale Id shift 28',0.00,0.00,0.00,626.87,0.00,'2022-05-29 18:17:01','',''),(388,'22','242','2',1,'Sale Id shift 28',0.00,0.00,0.00,481.13,0.00,'2022-05-29 18:17:01','',''),(389,'22','242','1',1,'Sale Id shift 28',0.00,0.00,0.00,636.23,0.00,'2022-05-29 18:17:01','',''),(390,'22','242','2',1,'Sale Id shift 28',0.00,0.00,0.00,253.33,0.00,'2022-05-29 18:17:01','',''),(391,'22','242','2',1,'Sale Id shift 28',0.00,0.00,0.00,341.48,0.00,'2022-05-29 18:17:01','',''),(392,'22','242','3',2,'Sale Id shift 28',0.00,0.00,0.00,148.63,0.00,'2022-05-29 18:17:01','',''),(393,'22','242','3',2,'Sale Id shift 28',0.00,0.00,0.00,229.65,0.00,'2022-05-29 18:17:01','',''),(394,'22','242','1',1,'Sale Id shift 28',0.00,0.00,0.00,783.51,0.00,'2022-05-29 18:17:01','',''),(395,'22','242','1',1,'Sale Id shift 28',0.00,0.00,0.00,752.68,0.00,'2022-05-29 18:17:01','',''),(396,'22','242','1',1,'Sale Id shift 28',0.00,0.00,0.00,1189.68,0.00,'2022-05-29 18:17:01','',''),(397,'22','242',NULL,2,'Sale Id shift 28',253447.60,0.00,0.00,0.00,0.00,'2022-05-29 18:17:01','',''),(398,'22','242',NULL,1,'Sale Id shift 28',749606.68,0.00,0.00,0.00,0.00,'2022-05-29 18:17:01','',''),(399,'22','242','1',1,'Sale Id shift 29',0.00,0.00,0.00,1447.48,0.00,'2022-05-31 08:47:54','',''),(400,'22','242','2',1,'Sale Id shift 29',0.00,0.00,0.00,1856.41,0.00,'2022-05-31 08:47:54','',''),(401,'22','242','1',1,'Sale Id shift 29',0.00,0.00,0.00,2043.83,0.00,'2022-05-31 08:47:54','',''),(402,'22','242','2',1,'Sale Id shift 29',0.00,0.00,0.00,1311.55,0.00,'2022-05-31 08:47:54','',''),(403,'22','242','2',1,'Sale Id shift 29',0.00,0.00,0.00,1072.22,0.00,'2022-05-31 08:47:54','',''),(404,'22','242','2',1,'Sale Id shift 29',0.00,0.00,0.00,359.79,0.00,'2022-05-31 08:47:54','',''),(405,'22','242','3',2,'Sale Id shift 29',0.00,0.00,0.00,1064.47,0.00,'2022-05-31 08:47:54','',''),(406,'22','242','3',2,'Sale Id shift 29',0.00,0.00,0.00,880.67,0.00,'2022-05-31 08:47:54','',''),(407,'22','242','4',2,'Sale Id shift 29',0.00,0.00,0.00,1290.00,0.00,'2022-05-31 08:47:54','',''),(408,'22','242','1',1,'Sale Id shift 29',0.00,0.00,0.00,1506.55,0.00,'2022-05-31 08:47:54','',''),(409,'22','242','1',1,'Sale Id shift 29',0.00,0.00,0.00,901.46,0.00,'2022-05-31 08:47:54','',''),(410,'22','242','1',1,'Sale Id shift 29',0.00,0.00,0.00,1472.69,0.00,'2022-05-31 08:47:54','',''),(411,'22','242',NULL,2,'Sale Id shift 29',2167543.80,0.00,0.00,0.00,0.00,'2022-05-31 08:47:54','',''),(412,'22','242',NULL,1,'Sale Id shift 29',1771853.04,0.00,0.00,0.00,0.00,'2022-05-31 08:47:54','',''),(413,'22','242',NULL,1,'Purchased from AA RANO NIGERIA LIMITED',0.00,5920000.00,40000.00,0.00,0.00,'2022-05-31 13:47:41','',''),(414,'22','242',NULL,1,'Reception corrector for bridging 28',0.00,0.00,0.00,13500.00,0.00,'2022-05-31 13:50:38','',''),(415,'22','242','2',1,'Received from bridging 28',0.00,0.00,13500.00,0.00,0.00,'2022-05-31 13:50:38','',''),(416,'22','242',NULL,1,'Reception corrector for bridging 27',0.00,0.00,0.00,26500.00,0.00,'2022-05-31 13:50:58','',''),(417,'22','242','1',1,'Received from bridging 27',0.00,0.00,26500.00,0.00,0.00,'2022-05-31 13:50:58','',''),(418,'22','242','1',1,'Sale Id shift 30',0.00,0.00,0.00,1226.57,0.00,'2022-06-01 11:11:54','',''),(419,'22','242','2',1,'Sale Id shift 30',0.00,0.00,0.00,2008.94,0.00,'2022-06-01 11:11:54','',''),(420,'22','242','1',1,'Sale Id shift 30',0.00,0.00,0.00,1864.60,0.00,'2022-06-01 11:11:54','',''),(421,'22','242','2',1,'Sale Id shift 30',0.00,0.00,0.00,1264.28,0.00,'2022-06-01 11:11:54','',''),(422,'22','242','2',1,'Sale Id shift 30',0.00,0.00,0.00,929.35,0.00,'2022-06-01 11:11:54','',''),(423,'22','242','2',1,'Sale Id shift 30',0.00,0.00,0.00,30.30,0.00,'2022-06-01 11:11:54','',''),(424,'22','242','3',2,'Sale Id shift 30',0.00,0.00,0.00,428.97,0.00,'2022-06-01 11:11:54','',''),(425,'22','242','3',2,'Sale Id shift 30',0.00,0.00,0.00,999.31,0.00,'2022-06-01 11:11:54','',''),(426,'22','242','4',2,'Sale Id shift 30',0.00,0.00,0.00,1855.00,0.00,'2022-06-01 11:11:54','',''),(427,'22','242','1',1,'Sale Id shift 30',0.00,0.00,0.00,1311.69,0.00,'2022-06-01 11:11:54','',''),(428,'22','242','1',1,'Sale Id shift 30',0.00,0.00,0.00,1023.64,0.00,'2022-06-01 11:11:54','',''),(429,'22','242','1',1,'Sale Id shift 30',0.00,0.00,0.00,1024.72,0.00,'2022-06-01 11:11:54','',''),(430,'22','242',NULL,2,'Sale Id shift 30',2199797.60,0.00,0.00,0.00,0.00,'2022-06-01 11:11:54','',''),(431,'22','242',NULL,1,'Sale Id shift 30',1581245.32,0.00,0.00,0.00,0.00,'2022-06-01 11:11:54','',''),(432,'22','242','1',1,'Sale Id shift 31',0.00,0.00,0.00,1088.75,0.00,'2022-06-02 08:39:12','',''),(433,'22','242','2',1,'Sale Id shift 31',0.00,0.00,0.00,1403.28,0.00,'2022-06-02 08:39:12','',''),(434,'22','242','1',1,'Sale Id shift 31',0.00,0.00,0.00,1996.88,0.00,'2022-06-02 08:39:12','',''),(435,'22','242','2',1,'Sale Id shift 31',0.00,0.00,0.00,987.91,0.00,'2022-06-02 08:39:12','',''),(436,'22','242','2',1,'Sale Id shift 31',0.00,0.00,0.00,71.09,0.00,'2022-06-02 08:39:12','',''),(437,'22','242','2',1,'Sale Id shift 31',0.00,0.00,0.00,93.18,0.00,'2022-06-02 08:39:12','',''),(438,'22','242','3',2,'Sale Id shift 31',0.00,0.00,0.00,662.30,0.00,'2022-06-02 08:39:12','',''),(439,'22','242','3',2,'Sale Id shift 31',0.00,0.00,0.00,1102.76,0.00,'2022-06-02 08:39:12','',''),(440,'22','242','4',2,'Sale Id shift 31',0.00,0.00,0.00,3305.00,0.00,'2022-06-02 08:39:12','',''),(441,'22','242','1',1,'Sale Id shift 31',0.00,0.00,0.00,1632.33,0.00,'2022-06-02 08:39:12','',''),(442,'22','242','1',1,'Sale Id shift 31',0.00,0.00,0.00,1387.34,0.00,'2022-06-02 08:39:12','',''),(443,'22','242','1',1,'Sale Id shift 31',0.00,0.00,0.00,1333.19,0.00,'2022-06-02 08:39:12','',''),(444,'22','242',NULL,2,'Sale Id shift 31',3396940.20,0.00,0.00,0.00,0.00,'2022-06-02 08:39:12','',''),(445,'22','242',NULL,1,'Sale Id shift 31',1479104.60,0.00,0.00,0.00,0.00,'2022-06-02 08:39:12','',''),(446,'22','242','1',1,'Sale Id shift 32',0.00,0.00,0.00,1195.15,0.00,'2022-06-03 08:17:30','',''),(447,'22','242','2',1,'Sale Id shift 32',0.00,0.00,0.00,1362.39,0.00,'2022-06-03 08:17:30','',''),(448,'22','242','1',1,'Sale Id shift 32',0.00,0.00,0.00,1333.10,0.00,'2022-06-03 08:17:30','',''),(449,'22','242','2',1,'Sale Id shift 32',0.00,0.00,0.00,633.74,0.00,'2022-06-03 08:17:30','',''),(450,'22','242','2',1,'Sale Id shift 32',0.00,0.00,0.00,908.49,0.00,'2022-06-03 08:17:30','',''),(451,'22','242','2',1,'Sale Id shift 32',0.00,0.00,0.00,530.07,0.00,'2022-06-03 08:17:30','',''),(452,'22','242','3',2,'Sale Id shift 32',0.00,0.00,0.00,933.76,0.00,'2022-06-03 08:17:30','',''),(453,'22','242','3',2,'Sale Id shift 32',0.00,0.00,0.00,1110.80,0.00,'2022-06-03 08:17:30','',''),(454,'22','242','4',2,'Sale Id shift 32',0.00,0.00,0.00,550.00,0.00,'2022-06-03 08:17:30','',''),(455,'22','242','1',1,'Sale Id shift 32',0.00,0.00,0.00,1542.34,0.00,'2022-06-03 08:17:30','',''),(456,'22','242','1',1,'Sale Id shift 32',0.00,0.00,0.00,1391.28,0.00,'2022-06-03 08:17:30','',''),(457,'22','242','1',1,'Sale Id shift 32',0.00,0.00,0.00,1400.03,0.00,'2022-06-03 08:17:30','',''),(458,'22','242',NULL,2,'Sale Id shift 32',1738355.20,0.00,0.00,0.00,0.00,'2022-06-03 08:17:30','',''),(459,'22','242',NULL,1,'Sale Id shift 32',1523895.32,0.00,0.00,0.00,0.00,'2022-06-03 08:17:30','',''),(460,'22','242','1',1,'Sale Id shift 33',0.00,0.00,0.00,1185.50,0.00,'2022-06-04 11:06:02','',''),(461,'22','242','2',1,'Sale Id shift 33',0.00,0.00,0.00,921.18,0.00,'2022-06-04 11:06:02','',''),(462,'22','242','1',1,'Sale Id shift 33',0.00,0.00,0.00,1167.55,0.00,'2022-06-04 11:06:02','',''),(463,'22','242','2',1,'Sale Id shift 33',0.00,0.00,0.00,1191.33,0.00,'2022-06-04 11:06:02','',''),(464,'22','242','2',1,'Sale Id shift 33',0.00,0.00,0.00,1007.11,0.00,'2022-06-04 11:06:02','',''),(465,'22','242','2',1,'Sale Id shift 33',0.00,0.00,0.00,456.90,0.00,'2022-06-04 11:06:02','',''),(466,'22','242','3',2,'Sale Id shift 33',0.00,0.00,0.00,1148.83,0.00,'2022-06-04 11:06:02','',''),(467,'22','242','3',2,'Sale Id shift 33',0.00,0.00,0.00,1274.32,0.00,'2022-06-04 11:06:02','',''),(468,'22','242','4',2,'Sale Id shift 33',0.00,0.00,0.00,2122.00,0.00,'2022-06-04 11:06:02','',''),(469,'22','242','1',1,'Sale Id shift 33',0.00,0.00,0.00,1711.58,0.00,'2022-06-04 11:06:02','',''),(470,'22','242','1',1,'Sale Id shift 33',0.00,0.00,0.00,1348.09,0.00,'2022-06-04 11:06:02','',''),(471,'22','242','1',1,'Sale Id shift 33',0.00,0.00,0.00,1516.20,0.00,'2022-06-04 11:06:02','',''),(472,'22','242',NULL,2,'Sale Id shift 33',3045250.50,0.00,0.00,0.00,0.00,'2022-06-04 11:06:02','',''),(473,'22','242',NULL,1,'Sale Id shift 33',1554805.12,0.00,0.00,0.00,0.00,'2022-06-04 11:06:02','',''),(474,'22','242',NULL,1,'Purchased from NIPC0 PLC',0.00,6660000.00,45000.00,0.00,0.00,'2022-06-04 19:47:16','',''),(475,'22','242',NULL,1,'Reception corrector for bridging 30',0.00,0.00,0.00,15000.00,0.00,'2022-06-04 19:50:30','',''),(476,'22','242','2',1,'Received from bridging 30',0.00,0.00,15000.00,0.00,0.00,'2022-06-04 19:50:30','',''),(477,'22','242',NULL,1,'Reception corrector for bridging 29',0.00,0.00,0.00,30000.00,0.00,'2022-06-04 19:50:52','',''),(478,'22','242','1',1,'Received from bridging 29',0.00,0.00,30000.00,0.00,0.00,'2022-06-04 19:50:52','',''),(479,'22','242','1',1,'Sale Id shift 34',0.00,0.00,0.00,684.05,0.00,'2022-06-04 21:37:09','',''),(480,'22','242','2',1,'Sale Id shift 34',0.00,0.00,0.00,2494.03,0.00,'2022-06-04 21:37:09','',''),(481,'22','242','1',1,'Sale Id shift 34',0.00,0.00,0.00,1008.33,0.00,'2022-06-04 21:37:09','',''),(482,'22','242','2',1,'Sale Id shift 34',0.00,0.00,0.00,1409.81,0.00,'2022-06-04 21:37:09','',''),(483,'22','242','2',1,'Sale Id shift 34',0.00,0.00,0.00,1216.32,0.00,'2022-06-04 21:37:09','',''),(484,'22','242','2',1,'Sale Id shift 34',0.00,0.00,0.00,565.63,0.00,'2022-06-04 21:37:09','',''),(485,'22','242','3',2,'Sale Id shift 34',0.00,0.00,0.00,1154.36,0.00,'2022-06-04 21:37:09','',''),(486,'22','242','3',2,'Sale Id shift 34',0.00,0.00,0.00,1567.25,0.00,'2022-06-04 21:37:09','',''),(487,'22','242','4',2,'Sale Id shift 34',0.00,0.00,0.00,2534.43,0.00,'2022-06-04 21:37:09','',''),(488,'22','242','1',1,'Sale Id shift 34',0.00,0.00,0.00,1322.03,0.00,'2022-06-04 21:37:09','',''),(489,'22','242','1',1,'Sale Id shift 34',0.00,0.00,0.00,1289.35,0.00,'2022-06-04 21:37:09','',''),(490,'22','242','1',1,'Sale Id shift 34',0.00,0.00,0.00,899.97,0.00,'2022-06-04 21:37:09','',''),(491,'22','242',NULL,2,'Sale Id shift 34',3521546.80,0.00,0.00,0.00,0.00,'2022-06-04 21:37:09','',''),(492,'22','242',NULL,1,'Sale Id shift 34',1611648.96,0.00,0.00,0.00,0.00,'2022-06-04 21:37:09','',''),(493,'22','242','1',1,'Sale Id shift 35',0.00,0.00,0.00,560.54,0.00,'2022-06-05 18:31:43','',''),(494,'22','242','2',1,'Sale Id shift 35',0.00,0.00,0.00,859.48,0.00,'2022-06-05 18:31:43','',''),(495,'22','242','2',1,'Sale Id shift 35',0.00,0.00,0.00,365.42,0.00,'2022-06-05 18:31:43','',''),(496,'22','242','2',1,'Sale Id shift 35',0.00,0.00,0.00,473.75,0.00,'2022-06-05 18:31:43','',''),(497,'22','242','2',1,'Sale Id shift 35',0.00,0.00,0.00,352.00,0.00,'2022-06-05 18:31:43','',''),(498,'22','242','3',2,'Sale Id shift 35',0.00,0.00,0.00,321.49,0.00,'2022-06-05 18:31:43','',''),(499,'22','242','3',2,'Sale Id shift 35',0.00,0.00,0.00,472.12,0.00,'2022-06-05 18:31:43','',''),(500,'22','242','4',2,'Sale Id shift 35',0.00,0.00,0.00,600.00,0.00,'2022-06-05 18:31:43','',''),(501,'22','242','1',1,'Sale Id shift 35',0.00,0.00,0.00,559.55,0.00,'2022-06-05 18:31:43','',''),(502,'22','242','1',1,'Sale Id shift 35',0.00,0.00,0.00,928.22,0.00,'2022-06-05 18:31:43','',''),(503,'22','242','1',1,'Sale Id shift 35',0.00,0.00,0.00,893.50,0.00,'2022-06-05 18:31:43','',''),(504,'22','242',NULL,2,'Sale Id shift 35',933718.70,0.00,0.00,0.00,0.00,'2022-06-05 18:31:43','',''),(505,'22','242',NULL,1,'Sale Id shift 35',738884.08,0.00,0.00,0.00,0.00,'2022-06-05 18:31:43','',''),(506,'22','242','1',1,'Sale Id shift 36',0.00,0.00,0.00,1770.93,0.00,'2022-06-06 21:51:42','',''),(507,'22','242','2',1,'Sale Id shift 36',0.00,0.00,0.00,1978.46,0.00,'2022-06-06 21:51:42','',''),(508,'22','242','2',1,'Sale Id shift 36',0.00,0.00,0.00,1488.81,0.00,'2022-06-06 21:51:42','',''),(509,'22','242','2',1,'Sale Id shift 36',0.00,0.00,0.00,627.21,0.00,'2022-06-06 21:51:42','',''),(510,'22','242','2',1,'Sale Id shift 36',0.00,0.00,0.00,377.68,0.00,'2022-06-06 21:51:42','',''),(511,'22','242','3',2,'Sale Id shift 36',0.00,0.00,0.00,1447.20,0.00,'2022-06-06 21:51:42','',''),(512,'22','242','3',2,'Sale Id shift 36',0.00,0.00,0.00,2763.20,0.00,'2022-06-06 21:51:42','',''),(513,'22','242','4',2,'Sale Id shift 36',0.00,0.00,0.00,3141.05,0.00,'2022-06-06 21:51:42','',''),(514,'22','242','1',1,'Sale Id shift 36',0.00,0.00,0.00,2047.68,0.00,'2022-06-06 21:51:42','',''),(515,'22','242','1',1,'Sale Id shift 36',0.00,0.00,0.00,1290.39,0.00,'2022-06-06 21:51:42','',''),(516,'22','242','1',1,'Sale Id shift 36',0.00,0.00,0.00,1610.67,0.00,'2022-06-06 21:51:42','',''),(517,'22','242',NULL,2,'Sale Id shift 36',4925471.50,0.00,0.00,0.00,0.00,'2022-06-06 21:51:42','',''),(518,'22','242',NULL,1,'Sale Id shift 36',1656390.84,0.00,0.00,0.00,0.00,'2022-06-06 21:51:42','',''),(519,'22','242','1',1,'Sale Id shift 37',0.00,0.00,0.00,1031.61,0.00,'2022-06-07 22:07:53','',''),(520,'22','242','2',1,'Sale Id shift 37',0.00,0.00,0.00,1793.92,0.00,'2022-06-07 22:07:53','',''),(521,'22','242','1',1,'Sale Id shift 37',0.00,0.00,0.00,1598.82,0.00,'2022-06-07 22:07:53','',''),(522,'22','242','2',1,'Sale Id shift 37',0.00,0.00,0.00,903.07,0.00,'2022-06-07 22:07:53','',''),(523,'22','242','2',1,'Sale Id shift 37',0.00,0.00,0.00,718.97,0.00,'2022-06-07 22:07:53','',''),(524,'22','242','2',1,'Sale Id shift 37',0.00,0.00,0.00,407.84,0.00,'2022-06-07 22:07:53','',''),(525,'22','242','3',2,'Sale Id shift 37',0.00,0.00,0.00,1339.27,0.00,'2022-06-07 22:07:53','',''),(526,'22','242','3',2,'Sale Id shift 37',0.00,0.00,0.00,3109.47,0.00,'2022-06-07 22:07:53','',''),(527,'22','242','4',2,'Sale Id shift 37',0.00,0.00,0.00,1430.00,0.00,'2022-06-07 22:07:53','',''),(528,'22','242','1',1,'Sale Id shift 37',0.00,0.00,0.00,1229.64,0.00,'2022-06-07 22:07:53','',''),(529,'22','242','1',1,'Sale Id shift 37',0.00,0.00,0.00,1954.87,0.00,'2022-06-07 22:07:53','',''),(530,'22','242','1',1,'Sale Id shift 37',0.00,0.00,0.00,1456.11,0.00,'2022-06-07 22:07:53','',''),(531,'22','242',NULL,2,'Sale Id shift 37',3938755.80,0.00,0.00,0.00,0.00,'2022-06-07 22:07:53','',''),(532,'22','242',NULL,1,'Sale Id shift 37',1642037.80,0.00,0.00,0.00,0.00,'2022-06-07 22:07:53','',''),(533,'22','242','1',1,'Sale Id shift 38',0.00,0.00,0.00,1372.41,0.00,'2022-06-08 21:51:28','',''),(534,'22','242','2',1,'Sale Id shift 38',0.00,0.00,0.00,1029.40,0.00,'2022-06-08 21:51:28','',''),(535,'22','242','1',1,'Sale Id shift 38',0.00,0.00,0.00,1443.38,0.00,'2022-06-08 21:51:28','',''),(536,'22','242','2',1,'Sale Id shift 38',0.00,0.00,0.00,1230.78,0.00,'2022-06-08 21:51:28','',''),(537,'22','242','2',1,'Sale Id shift 38',0.00,0.00,0.00,460.68,0.00,'2022-06-08 21:51:28','',''),(538,'22','242','2',1,'Sale Id shift 38',0.00,0.00,0.00,109.08,0.00,'2022-06-08 21:51:28','',''),(539,'22','242','3',2,'Sale Id shift 38',0.00,0.00,0.00,4176.88,0.00,'2022-06-08 21:51:28','',''),(540,'22','242','3',2,'Sale Id shift 38',0.00,0.00,0.00,3576.65,0.00,'2022-06-08 21:51:28','',''),(541,'22','242','4',2,'Sale Id shift 38',0.00,0.00,0.00,1597.26,0.00,'2022-06-08 21:51:28','',''),(542,'22','242','1',1,'Sale Id shift 38',0.00,0.00,0.00,2173.05,0.00,'2022-06-08 21:51:28','',''),(543,'22','242','1',1,'Sale Id shift 38',0.00,0.00,0.00,1441.23,0.00,'2022-06-08 21:51:28','',''),(544,'22','242','1',1,'Sale Id shift 38',0.00,0.00,0.00,1332.94,0.00,'2022-06-08 21:51:28','',''),(545,'22','242',NULL,2,'Sale Id shift 38',6265029.30,0.00,0.00,0.00,0.00,'2022-06-08 21:51:28','',''),(546,'22','242',NULL,1,'Sale Id shift 38',1567756.60,0.00,0.00,0.00,0.00,'2022-06-08 21:51:28','',''),(547,'22','242','1',1,'Sale Id shift 39',0.00,0.00,0.00,1503.24,0.00,'2022-06-09 22:32:38','',''),(548,'22','242','2',1,'Sale Id shift 39',0.00,0.00,0.00,986.81,0.00,'2022-06-09 22:32:38','',''),(549,'22','242','1',1,'Sale Id shift 39',0.00,0.00,0.00,1370.41,0.00,'2022-06-09 22:32:38','',''),(550,'22','242','2',1,'Sale Id shift 39',0.00,0.00,0.00,1163.00,0.00,'2022-06-09 22:32:38','',''),(551,'22','242','2',1,'Sale Id shift 39',0.00,0.00,0.00,753.59,0.00,'2022-06-09 22:32:38','',''),(552,'22','242','2',1,'Sale Id shift 39',0.00,0.00,0.00,214.20,0.00,'2022-06-09 22:32:38','',''),(553,'22','242','3',2,'Sale Id shift 39',0.00,0.00,0.00,1282.01,0.00,'2022-06-09 22:32:38','',''),(554,'22','242','3',2,'Sale Id shift 39',0.00,0.00,0.00,1805.19,0.00,'2022-06-09 22:32:38','',''),(555,'22','242','4',2,'Sale Id shift 39',0.00,0.00,0.00,2978.02,0.00,'2022-06-09 22:32:38','',''),(556,'22','242','1',1,'Sale Id shift 39',0.00,0.00,0.00,1509.29,0.00,'2022-06-09 22:32:38','',''),(557,'22','242','1',1,'Sale Id shift 39',0.00,0.00,0.00,1503.49,0.00,'2022-06-09 22:32:38','',''),(558,'22','242','1',1,'Sale Id shift 39',0.00,0.00,0.00,1498.28,0.00,'2022-06-09 22:32:38','',''),(559,'22','242',NULL,2,'Sale Id shift 39',4063697.40,0.00,0.00,0.00,0.00,'2022-06-09 22:32:38','',''),(560,'22','242',NULL,1,'Sale Id shift 39',1554341.88,0.00,0.00,0.00,0.00,'2022-06-09 22:32:38','',''),(561,'22','242',NULL,2,'Purchased from NIPC0 PLC',0.00,33300000.00,45000.00,0.00,0.00,'2022-06-10 18:29:13','',''),(562,'22','242',NULL,2,'Reception corrector for bridging 32',0.00,0.00,0.00,15000.00,0.00,'2022-06-10 18:32:50','',''),(563,'22','242','4',2,'Received from bridging 32',0.00,0.00,15000.00,0.00,0.00,'2022-06-10 18:32:50','',''),(564,'22','242',NULL,2,'Reception corrector for bridging 31',0.00,0.00,0.00,30000.00,0.00,'2022-06-10 18:33:02','',''),(565,'22','242','3',2,'Received from bridging 31',0.00,0.00,30000.00,0.00,0.00,'2022-06-10 18:33:02','',''),(566,'22','242',NULL,1,'Purchased from AITEO ENERGY RESOURCES',0.00,5920000.00,40000.00,0.00,0.00,'2022-06-10 18:37:51','',''),(567,'22','242',NULL,1,'Reception corrector for bridging 34',0.00,0.00,0.00,13500.00,0.00,'2022-06-10 18:43:30','',''),(568,'22','242','2',1,'Received from bridging 34',0.00,0.00,13500.00,0.00,0.00,'2022-06-10 18:43:30','',''),(569,'22','242',NULL,1,'Reception corrector for bridging 33',0.00,0.00,0.00,26500.00,0.00,'2022-06-10 18:43:46','',''),(570,'22','242','1',1,'Received from bridging 33',0.00,0.00,26500.00,0.00,0.00,'2022-06-10 18:43:46','',''),(571,'22','242','1',1,'Sale Id shift 40',0.00,0.00,0.00,1508.59,0.00,'2022-06-11 10:31:48','',''),(572,'22','242','2',1,'Sale Id shift 40',0.00,0.00,0.00,1358.03,0.00,'2022-06-11 10:31:48','',''),(573,'22','242','1',1,'Sale Id shift 40',0.00,0.00,0.00,1423.19,0.00,'2022-06-11 10:31:48','',''),(574,'22','242','2',1,'Sale Id shift 40',0.00,0.00,0.00,999.49,0.00,'2022-06-11 10:31:48','',''),(575,'22','242','2',1,'Sale Id shift 40',0.00,0.00,0.00,185.12,0.00,'2022-06-11 10:31:48','',''),(576,'22','242','2',1,'Sale Id shift 40',0.00,0.00,0.00,1023.89,0.00,'2022-06-11 10:31:48','',''),(577,'22','242','3',2,'Sale Id shift 40',0.00,0.00,0.00,1759.60,0.00,'2022-06-11 10:31:48','',''),(578,'22','242','3',2,'Sale Id shift 40',0.00,0.00,0.00,1324.79,0.00,'2022-06-11 10:31:48','',''),(579,'22','242','4',2,'Sale Id shift 40',0.00,0.00,0.00,2417.01,0.00,'2022-06-11 10:31:48','',''),(580,'22','242','1',1,'Sale Id shift 40',0.00,0.00,0.00,1002.20,0.00,'2022-06-11 10:31:48','',''),(581,'22','242','1',1,'Sale Id shift 40',0.00,0.00,0.00,916.59,0.00,'2022-06-11 10:31:48','',''),(582,'22','242','1',1,'Sale Id shift 40',0.00,0.00,0.00,1322.56,0.00,'2022-06-11 10:31:48','',''),(583,'22','242',NULL,2,'Sale Id shift 40',3685938.00,0.00,0.00,0.00,0.00,'2022-06-11 10:31:48','',''),(584,'22','242',NULL,1,'Sale Id shift 40',1441469.68,0.00,0.00,0.00,0.00,'2022-06-11 10:31:48','',''),(585,'22','242','1',1,'Sale Id shift 41',0.00,0.00,0.00,1168.37,0.00,'2022-06-11 21:17:40','',''),(586,'22','242','2',1,'Sale Id shift 41',0.00,0.00,0.00,1863.97,0.00,'2022-06-11 21:17:40','',''),(587,'22','242','1',1,'Sale Id shift 41',0.00,0.00,0.00,1209.73,0.00,'2022-06-11 21:17:40','',''),(588,'22','242','2',1,'Sale Id shift 41',0.00,0.00,0.00,1343.12,0.00,'2022-06-11 21:17:40','',''),(589,'22','242','2',1,'Sale Id shift 41',0.00,0.00,0.00,168.23,0.00,'2022-06-11 21:17:40','',''),(590,'22','242','2',1,'Sale Id shift 41',0.00,0.00,0.00,24.25,0.00,'2022-06-11 21:17:40','',''),(591,'22','242','3',2,'Sale Id shift 41',0.00,0.00,0.00,1706.83,0.00,'2022-06-11 21:17:40','',''),(592,'22','242','3',2,'Sale Id shift 41',0.00,0.00,0.00,2004.79,0.00,'2022-06-11 21:17:40','',''),(593,'22','242','4',2,'Sale Id shift 41',0.00,0.00,0.00,2500.00,0.00,'2022-06-11 21:17:40','',''),(594,'22','242','1',1,'Sale Id shift 41',0.00,0.00,0.00,1058.75,0.00,'2022-06-11 21:17:40','',''),(595,'22','242','1',1,'Sale Id shift 41',0.00,0.00,0.00,1451.79,0.00,'2022-06-11 21:17:40','',''),(596,'22','242','1',1,'Sale Id shift 41',0.00,0.00,0.00,890.31,0.00,'2022-06-11 21:17:40','',''),(597,'22','242',NULL,2,'Sale Id shift 41',4596598.80,0.00,0.00,0.00,0.00,'2022-06-11 21:17:40','',''),(598,'22','242',NULL,1,'Sale Id shift 41',1358420.96,0.00,0.00,0.00,0.00,'2022-06-11 21:17:40','',''),(599,'22','242','1',1,'Sale Id shift 42',0.00,0.00,0.00,579.93,0.00,'2022-06-14 15:17:36','',''),(600,'22','242','2',1,'Sale Id shift 42',0.00,0.00,0.00,292.79,0.00,'2022-06-14 15:17:36','',''),(601,'22','242','1',1,'Sale Id shift 42',0.00,0.00,0.00,198.79,0.00,'2022-06-14 15:17:36','',''),(602,'22','242','2',1,'Sale Id shift 42',0.00,0.00,0.00,151.04,0.00,'2022-06-14 15:17:36','',''),(603,'22','242','3',2,'Sale Id shift 42',0.00,0.00,0.00,134.80,0.00,'2022-06-14 15:17:36','',''),(604,'22','242','3',2,'Sale Id shift 42',0.00,0.00,0.00,259.30,0.00,'2022-06-14 15:17:36','',''),(605,'22','242','4',2,'Sale Id shift 42',0.00,0.00,0.00,500.00,0.00,'2022-06-14 15:17:36','',''),(606,'22','242','1',1,'Sale Id shift 42',0.00,0.00,0.00,819.77,0.00,'2022-06-14 15:17:36','',''),(607,'22','242','1',1,'Sale Id shift 42',0.00,0.00,0.00,811.44,0.00,'2022-06-14 15:17:36','',''),(608,'22','242','1',1,'Sale Id shift 42',0.00,0.00,0.00,771.36,0.00,'2022-06-14 15:17:36','',''),(609,'22','242',NULL,2,'Sale Id shift 42',661634.00,0.00,0.00,0.00,0.00,'2022-06-14 15:17:36','',''),(610,'22','242',NULL,1,'Sale Id shift 42',536517.76,0.00,0.00,0.00,0.00,'2022-06-14 15:17:36','',''),(611,'22','242','1',1,'Sale Id shift 43',0.00,0.00,0.00,1489.17,0.00,'2022-06-14 15:24:22','',''),(612,'22','242','2',1,'Sale Id shift 43',0.00,0.00,0.00,1648.76,0.00,'2022-06-14 15:24:22','',''),(613,'22','242','1',1,'Sale Id shift 43',0.00,0.00,0.00,2173.98,0.00,'2022-06-14 15:24:22','',''),(614,'22','242','2',1,'Sale Id shift 43',0.00,0.00,0.00,1115.99,0.00,'2022-06-14 15:24:22','',''),(615,'22','242','3',2,'Sale Id shift 43',0.00,0.00,0.00,919.06,0.00,'2022-06-14 15:24:22','',''),(616,'22','242','3',2,'Sale Id shift 43',0.00,0.00,0.00,1849.47,0.00,'2022-06-14 15:24:22','',''),(617,'22','242','4',2,'Sale Id shift 43',0.00,0.00,0.00,2280.35,0.00,'2022-06-14 15:24:22','',''),(618,'22','242','1',1,'Sale Id shift 43',0.00,0.00,0.00,1017.63,0.00,'2022-06-14 15:24:22','',''),(619,'22','242','1',1,'Sale Id shift 43',0.00,0.00,0.00,1203.58,0.00,'2022-06-14 15:24:22','',''),(620,'22','242','1',1,'Sale Id shift 43',0.00,0.00,0.00,1078.52,0.00,'2022-06-14 15:24:22','',''),(621,'22','242',NULL,2,'Sale Id shift 43',3736171.20,0.00,0.00,0.00,0.00,'2022-06-14 15:24:22','',''),(622,'22','242',NULL,1,'Sale Id shift 43',1439689.24,0.00,0.00,0.00,0.00,'2022-06-14 15:24:22','',''),(623,'22','242','1',1,'Sale Id shift 44',0.00,0.00,0.00,1041.46,0.00,'2022-06-15 09:38:42','',''),(624,'22','242','2',1,'Sale Id shift 44',0.00,0.00,0.00,2187.20,0.00,'2022-06-15 09:38:42','',''),(625,'22','242','1',1,'Sale Id shift 44',0.00,0.00,0.00,873.66,0.00,'2022-06-15 09:38:42','',''),(626,'22','242','2',1,'Sale Id shift 44',0.00,0.00,0.00,1005.46,0.00,'2022-06-15 09:38:42','',''),(627,'22','242','2',1,'Sale Id shift 44',0.00,0.00,0.00,1142.54,0.00,'2022-06-15 09:38:42','',''),(628,'22','242','2',1,'Sale Id shift 44',0.00,0.00,0.00,745.29,0.00,'2022-06-15 09:38:42','',''),(629,'22','242','3',2,'Sale Id shift 44',0.00,0.00,0.00,1336.33,0.00,'2022-06-15 09:38:42','',''),(630,'22','242','3',2,'Sale Id shift 44',0.00,0.00,0.00,2413.79,0.00,'2022-06-15 09:38:42','',''),(631,'22','242','4',2,'Sale Id shift 44',0.00,0.00,0.00,1650.00,0.00,'2022-06-15 09:38:42','',''),(632,'22','242','1',1,'Sale Id shift 44',0.00,0.00,0.00,1076.07,0.00,'2022-06-15 09:38:42','',''),(633,'22','242','1',1,'Sale Id shift 44',0.00,0.00,0.00,1044.26,0.00,'2022-06-15 09:38:42','',''),(634,'22','242','1',1,'Sale Id shift 44',0.00,0.00,0.00,1198.45,0.00,'2022-06-15 09:38:42','',''),(635,'22','242',NULL,2,'Sale Id shift 44',3996088.80,0.00,0.00,0.00,0.00,'2022-06-15 09:38:42','',''),(636,'22','242',NULL,1,'Sale Id shift 44',1526529.72,0.00,0.00,0.00,0.00,'2022-06-15 09:38:42','',''),(637,'22','242',NULL,1,'Purchased from AA RANO NIGERIA LIMITED',0.00,6660000.00,45000.00,0.00,0.00,'2022-06-15 18:32:12','',''),(638,'22','242',NULL,1,'Reception corrector for bridging 36',0.00,0.00,0.00,15000.00,0.00,'2022-06-15 18:35:36','',''),(639,'22','242','2',1,'Received from bridging 36',0.00,0.00,15000.00,0.00,0.00,'2022-06-15 18:35:36','',''),(640,'22','242',NULL,1,'Reception corrector for bridging 35',0.00,0.00,0.00,30000.00,0.00,'2022-06-15 18:35:55','',''),(641,'22','242','1',1,'Received from bridging 35',0.00,0.00,30000.00,0.00,0.00,'2022-06-15 18:35:55','',''),(642,'22','242','1',1,'Sale Id shift 45',0.00,0.00,0.00,18.18,0.00,'2022-06-16 11:24:26','',''),(643,'22','242','2',1,'Sale Id shift 45',0.00,0.00,0.00,394.13,0.00,'2022-06-16 11:24:26','',''),(644,'22','242','1',1,'Sale Id shift 45',0.00,0.00,0.00,197.29,0.00,'2022-06-16 11:24:26','',''),(645,'22','242','2',1,'Sale Id shift 45',0.00,0.00,0.00,211.91,0.00,'2022-06-16 11:24:26','',''),(646,'22','242','2',1,'Sale Id shift 45',0.00,0.00,0.00,127.83,0.00,'2022-06-16 11:24:26','',''),(647,'22','242','2',1,'Sale Id shift 45',0.00,0.00,0.00,60.60,0.00,'2022-06-16 11:24:26','',''),(648,'22','242','3',2,'Sale Id shift 45',0.00,0.00,0.00,1073.17,0.00,'2022-06-16 11:24:26','',''),(649,'22','242','3',2,'Sale Id shift 45',0.00,0.00,0.00,2010.12,0.00,'2022-06-16 11:24:26','',''),(650,'22','242','4',2,'Sale Id shift 45',0.00,0.00,0.00,1288.47,0.00,'2022-06-16 11:24:26','',''),(651,'22','242','1',1,'Sale Id shift 45',0.00,0.00,0.00,142.40,0.00,'2022-06-16 11:24:26','',''),(652,'22','242','1',1,'Sale Id shift 45',0.00,0.00,0.00,77.74,0.00,'2022-06-16 11:24:26','',''),(653,'22','242','1',1,'Sale Id shift 45',0.00,0.00,0.00,19.43,0.00,'2022-06-16 11:24:26','',''),(654,'22','242',NULL,2,'Sale Id shift 45',3235102.40,0.00,0.00,0.00,0.00,'2022-06-16 11:24:26','',''),(655,'22','242',NULL,1,'Sale Id shift 45',184927.48,0.00,0.00,0.00,0.00,'2022-06-16 11:24:26','',''),(656,'22','242','1',1,'Sale Id shift 46',0.00,0.00,0.00,1143.36,0.00,'2022-06-18 11:04:09','',''),(657,'22','242','2',1,'Sale Id shift 46',0.00,0.00,0.00,1935.01,0.00,'2022-06-18 11:04:09','',''),(658,'22','242','1',1,'Sale Id shift 46',0.00,0.00,0.00,688.95,0.00,'2022-06-18 11:04:09','',''),(659,'22','242','2',1,'Sale Id shift 46',0.00,0.00,0.00,1594.13,0.00,'2022-06-18 11:04:09','',''),(660,'22','242','2',1,'Sale Id shift 46',0.00,0.00,0.00,634.99,0.00,'2022-06-18 11:04:09','',''),(661,'22','242','3',2,'Sale Id shift 46',0.00,0.00,0.00,1042.69,0.00,'2022-06-18 11:04:09','',''),(662,'22','242','3',2,'Sale Id shift 46',0.00,0.00,0.00,1781.92,0.00,'2022-06-18 11:04:09','',''),(663,'22','242','4',2,'Sale Id shift 46',0.00,0.00,0.00,1420.00,0.00,'2022-06-18 11:04:09','',''),(664,'22','242','1',1,'Sale Id shift 46',0.00,0.00,0.00,1511.86,0.00,'2022-06-18 11:04:09','',''),(665,'22','242','1',1,'Sale Id shift 46',0.00,0.00,0.00,1202.87,0.00,'2022-06-18 11:04:09','',''),(666,'22','242','1',1,'Sale Id shift 46',0.00,0.00,0.00,938.32,0.00,'2022-06-18 11:04:09','',''),(667,'22','242',NULL,2,'Sale Id shift 46',3141011.40,0.00,0.00,0.00,0.00,'2022-06-18 11:04:09','',''),(668,'22','242',NULL,1,'Sale Id shift 46',1428124.52,0.00,0.00,0.00,0.00,'2022-06-18 11:04:09','',''),(669,'22','242','1',1,'Sale Id shift 47',0.00,0.00,0.00,1328.12,0.00,'2022-06-18 11:09:50','',''),(670,'22','242','2',1,'Sale Id shift 47',0.00,0.00,0.00,1078.32,0.00,'2022-06-18 11:09:50','',''),(671,'22','242','1',1,'Sale Id shift 47',0.00,0.00,0.00,1167.71,0.00,'2022-06-18 11:09:50','',''),(672,'22','242','2',1,'Sale Id shift 47',0.00,0.00,0.00,706.11,0.00,'2022-06-18 11:09:50','',''),(673,'22','242','2',1,'Sale Id shift 47',0.00,0.00,0.00,600.99,0.00,'2022-06-18 11:09:50','',''),(674,'22','242','2',1,'Sale Id shift 47',0.00,0.00,0.00,498.13,0.00,'2022-06-18 11:09:50','',''),(675,'22','242','3',2,'Sale Id shift 47',0.00,0.00,0.00,995.45,0.00,'2022-06-18 11:09:50','',''),(676,'22','242','3',2,'Sale Id shift 47',0.00,0.00,0.00,1807.97,0.00,'2022-06-18 11:09:50','',''),(677,'22','242','4',2,'Sale Id shift 47',0.00,0.00,0.00,1794.11,0.00,'2022-06-18 11:09:50','',''),(678,'22','242','1',1,'Sale Id shift 47',0.00,0.00,0.00,1728.19,0.00,'2022-06-18 11:09:50','',''),(679,'22','242','1',1,'Sale Id shift 47',0.00,0.00,0.00,1840.62,0.00,'2022-06-18 11:09:50','',''),(680,'22','242','1',1,'Sale Id shift 47',0.00,0.00,0.00,1512.25,0.00,'2022-06-18 11:09:50','',''),(681,'22','242',NULL,2,'Sale Id shift 47',3402172.20,0.00,0.00,0.00,0.00,'2022-06-18 11:09:50','',''),(682,'22','242',NULL,1,'Sale Id shift 47',1548145.12,0.00,0.00,0.00,0.00,'2022-06-18 11:09:50','',''),(683,'22','242',NULL,2,'Purchased from NIPC0 PLC',0.00,34200000.00,45000.00,0.00,0.00,'2022-06-18 11:15:21','',''),(684,'22','242',NULL,2,'Reception corrector for bridging 38',0.00,0.00,0.00,21000.00,0.00,'2022-06-18 11:17:01','',''),(685,'22','242','4',2,'Received from bridging 38',0.00,0.00,21000.00,0.00,0.00,'2022-06-18 11:17:01','',''),(686,'22','242',NULL,2,'Reception corrector for bridging 37',0.00,0.00,0.00,24000.00,0.00,'2022-06-18 11:17:25','',''),(687,'22','242','3',2,'Received from bridging 37',0.00,0.00,24000.00,0.00,0.00,'2022-06-18 11:17:25','',''),(688,'22','242','1',1,'Sale Id shift 48',0.00,0.00,0.00,1565.39,0.00,'2022-06-18 21:26:43','',''),(689,'22','242','2',1,'Sale Id shift 48',0.00,0.00,0.00,1220.00,0.00,'2022-06-18 21:26:43','',''),(690,'22','242','1',1,'Sale Id shift 48',0.00,0.00,0.00,1868.65,0.00,'2022-06-18 21:26:43','',''),(691,'22','242','2',1,'Sale Id shift 48',0.00,0.00,0.00,746.32,0.00,'2022-06-18 21:26:43','',''),(692,'22','242','2',1,'Sale Id shift 48',0.00,0.00,0.00,371.19,0.00,'2022-06-18 21:26:43','',''),(693,'22','242','3',2,'Sale Id shift 48',0.00,0.00,0.00,786.49,0.00,'2022-06-18 21:26:43','',''),(694,'22','242','3',2,'Sale Id shift 48',0.00,0.00,0.00,1272.05,0.00,'2022-06-18 21:26:43','',''),(695,'22','242','4',2,'Sale Id shift 48',0.00,0.00,0.00,1300.00,0.00,'2022-06-18 21:26:43','',''),(696,'22','242','1',1,'Sale Id shift 48',0.00,0.00,0.00,1784.43,0.00,'2022-06-18 21:26:43','',''),(697,'22','242','1',1,'Sale Id shift 48',0.00,0.00,0.00,652.04,0.00,'2022-06-18 21:26:43','',''),(698,'22','242','1',1,'Sale Id shift 48',0.00,0.00,0.00,1508.17,0.00,'2022-06-18 21:26:43','',''),(699,'22','242',NULL,2,'Sale Id shift 48',2485319.60,0.00,0.00,0.00,0.00,'2022-06-18 21:26:43','',''),(700,'22','242',NULL,1,'Sale Id shift 48',1437996.12,0.00,0.00,0.00,0.00,'2022-06-18 21:26:43','',''),(701,'22','242','1',1,'Sale Id shift 49',0.00,0.00,0.00,920.23,0.00,'2022-06-20 11:08:35','',''),(702,'22','242','2',1,'Sale Id shift 49',0.00,0.00,0.00,906.52,0.00,'2022-06-20 11:08:35','',''),(703,'22','242','1',1,'Sale Id shift 49',0.00,0.00,0.00,536.90,0.00,'2022-06-20 11:08:35','',''),(704,'22','242','2',1,'Sale Id shift 49',0.00,0.00,0.00,371.56,0.00,'2022-06-20 11:08:35','',''),(705,'22','242','2',1,'Sale Id shift 49',0.00,0.00,0.00,262.56,0.00,'2022-06-20 11:08:35','',''),(706,'22','242','3',2,'Sale Id shift 49',0.00,0.00,0.00,233.17,0.00,'2022-06-20 11:08:35','',''),(707,'22','242','3',2,'Sale Id shift 49',0.00,0.00,0.00,333.58,0.00,'2022-06-20 11:08:35','',''),(708,'22','242','1',1,'Sale Id shift 49',0.00,0.00,0.00,1216.38,0.00,'2022-06-20 11:08:35','',''),(709,'22','242','1',1,'Sale Id shift 49',0.00,0.00,0.00,859.53,0.00,'2022-06-20 11:08:35','',''),(710,'22','242','1',1,'Sale Id shift 49',0.00,0.00,0.00,825.20,0.00,'2022-06-20 11:08:35','',''),(711,'22','242',NULL,2,'Sale Id shift 49',430730.00,0.00,0.00,0.00,0.00,'2022-06-20 11:08:35','',''),(712,'22','242',NULL,1,'Sale Id shift 49',873034.24,0.00,0.00,0.00,0.00,'2022-06-20 11:08:35','',''),(713,'22','242',NULL,1,'Purchased from AA RANO NIGERIA LIMITED',0.00,6660000.00,45000.00,0.00,0.00,'2022-06-20 11:13:29','',''),(714,'22','242',NULL,1,'Reception corrector for bridging 40',0.00,0.00,0.00,15000.00,0.00,'2022-06-20 11:16:08','',''),(715,'22','242','2',1,'Received from bridging 40',0.00,0.00,15000.00,0.00,0.00,'2022-06-20 11:16:08','',''),(716,'22','242',NULL,1,'Reception corrector for bridging 39',0.00,0.00,0.00,30000.00,0.00,'2022-06-20 11:16:21','',''),(717,'22','242','1',1,'Received from bridging 39',0.00,0.00,30000.00,0.00,0.00,'2022-06-20 11:16:21','',''),(718,'22','242','1',1,'Sale Id shift 50',0.00,0.00,0.00,1564.61,0.00,'2022-06-20 21:50:24','',''),(719,'22','242','2',1,'Sale Id shift 50',0.00,0.00,0.00,3258.33,0.00,'2022-06-20 21:50:24','',''),(720,'22','242','1',1,'Sale Id shift 50',0.00,0.00,0.00,2968.10,0.00,'2022-06-20 21:50:24','',''),(721,'22','242','2',1,'Sale Id shift 50',0.00,0.00,0.00,36.36,0.00,'2022-06-20 21:50:24','',''),(722,'22','242','2',1,'Sale Id shift 50',0.00,0.00,0.00,4073.76,0.00,'2022-06-20 21:50:24','',''),(723,'22','242','2',1,'Sale Id shift 50',0.00,0.00,0.00,3812.87,0.00,'2022-06-20 21:50:24','',''),(724,'22','242','3',2,'Sale Id shift 50',0.00,0.00,0.00,752.21,0.00,'2022-06-20 21:50:24','',''),(725,'22','242','3',2,'Sale Id shift 50',0.00,0.00,0.00,1671.51,0.00,'2022-06-20 21:50:24','',''),(726,'22','242','4',2,'Sale Id shift 50',0.00,0.00,0.00,2685.36,0.00,'2022-06-20 21:50:24','',''),(727,'22','242','1',1,'Sale Id shift 50',0.00,0.00,0.00,5500.58,0.00,'2022-06-20 21:50:24','',''),(728,'22','242','1',1,'Sale Id shift 50',0.00,0.00,0.00,5991.31,0.00,'2022-06-20 21:50:24','',''),(729,'22','242','1',1,'Sale Id shift 50',0.00,0.00,0.00,2254.73,0.00,'2022-06-20 21:50:24','',''),(730,'22','242',NULL,2,'Sale Id shift 50',3882900.80,0.00,0.00,0.00,0.00,'2022-06-20 21:50:24','',''),(731,'22','242',NULL,1,'Sale Id shift 50',4360176.20,0.00,0.00,0.00,0.00,'2022-06-20 21:50:24','',''),(732,'22','242','1',1,'Sale Id shift 51',0.00,0.00,0.00,966.63,0.00,'2022-06-21 21:35:44','',''),(733,'22','242','2',1,'Sale Id shift 51',0.00,0.00,0.00,1137.56,0.00,'2022-06-21 21:35:44','',''),(734,'22','242','1',1,'Sale Id shift 51',0.00,0.00,0.00,6102.42,0.00,'2022-06-21 21:35:44','',''),(735,'22','242','2',1,'Sale Id shift 51',0.00,0.00,0.00,147.02,0.00,'2022-06-21 21:35:44','',''),(736,'22','242','2',1,'Sale Id shift 51',0.00,0.00,0.00,3171.71,0.00,'2022-06-21 21:35:44','',''),(737,'22','242','2',1,'Sale Id shift 51',0.00,0.00,0.00,3795.44,0.00,'2022-06-21 21:35:44','',''),(738,'22','242','3',2,'Sale Id shift 51',0.00,0.00,0.00,1007.61,0.00,'2022-06-21 21:35:44','',''),(739,'22','242','3',2,'Sale Id shift 51',0.00,0.00,0.00,1101.56,0.00,'2022-06-21 21:35:44','',''),(740,'22','242','4',2,'Sale Id shift 51',0.00,0.00,0.00,1245.00,0.00,'2022-06-21 21:35:44','',''),(741,'22','242','1',1,'Sale Id shift 51',0.00,0.00,0.00,4252.33,0.00,'2022-06-21 21:35:44','',''),(742,'22','242','1',1,'Sale Id shift 51',0.00,0.00,0.00,4789.95,0.00,'2022-06-21 21:35:44','',''),(743,'22','242','1',1,'Sale Id shift 51',0.00,0.00,0.00,1059.18,0.00,'2022-06-21 21:35:44','',''),(744,'22','242',NULL,2,'Sale Id shift 51',2549169.20,0.00,0.00,0.00,0.00,'2022-06-21 21:35:44','',''),(745,'22','242',NULL,1,'Sale Id shift 51',3762491.52,0.00,0.00,0.00,0.00,'2022-06-21 21:35:44','',''),(746,'22','242','3',2,'Sale Id shift 52',0.00,0.00,0.00,1685.46,0.00,'2022-06-22 21:32:44','',''),(747,'22','242','3',2,'Sale Id shift 52',0.00,0.00,0.00,1798.29,0.00,'2022-06-22 21:32:44','',''),(748,'22','242','4',2,'Sale Id shift 52',0.00,0.00,0.00,1090.00,0.00,'2022-06-22 21:32:44','',''),(749,'22','242','1',1,'Sale Id shift 52',0.00,0.00,0.00,428.51,0.00,'2022-06-22 21:32:44','',''),(750,'22','242',NULL,2,'Sale Id shift 52',3476050.00,0.00,0.00,0.00,0.00,'2022-06-22 21:32:44','',''),(751,'22','242',NULL,1,'Sale Id shift 52',63419.48,0.00,0.00,0.00,0.00,'2022-06-22 21:32:44','',''),(752,'22','242',NULL,1,'Purchased from AA RANO NIGERIA LIMITED',0.00,5920000.00,40000.00,0.00,0.00,'2022-06-25 11:46:59','',''),(753,'22','242',NULL,1,'Reception corrector for bridging 42',0.00,0.00,0.00,13500.00,0.00,'2022-06-25 11:53:15','',''),(754,'22','242','2',1,'Received from bridging 42',0.00,0.00,13500.00,0.00,0.00,'2022-06-25 11:53:15','',''),(755,'22','242',NULL,1,'Reception corrector for bridging 41',0.00,0.00,0.00,26500.00,0.00,'2022-06-25 11:53:30','',''),(756,'22','242','1',1,'Received from bridging 41',0.00,0.00,26500.00,0.00,0.00,'2022-06-25 11:53:30','',''),(757,'22','242','2',1,'Sale Id shift 53',0.00,0.00,0.00,1349.59,0.00,'2022-06-25 11:57:16','',''),(758,'22','242','2',1,'Sale Id shift 53',0.00,0.00,0.00,1702.47,0.00,'2022-06-25 11:57:16','',''),(759,'22','242','3',2,'Sale Id shift 53',0.00,0.00,0.00,1122.59,0.00,'2022-06-25 11:57:16','',''),(760,'22','242','3',2,'Sale Id shift 53',0.00,0.00,0.00,1135.03,0.00,'2022-06-25 11:57:16','',''),(761,'22','242','4',2,'Sale Id shift 53',0.00,0.00,0.00,1285.00,0.00,'2022-06-25 11:57:16','',''),(762,'22','242','1',1,'Sale Id shift 53',0.00,0.00,0.00,2143.43,0.00,'2022-06-25 11:57:16','',''),(763,'22','242','1',1,'Sale Id shift 53',0.00,0.00,0.00,2098.05,0.00,'2022-06-25 11:57:16','',''),(764,'22','242',NULL,2,'Sale Id shift 53',2692391.20,0.00,0.00,0.00,0.00,'2022-06-25 11:57:16','',''),(765,'22','242',NULL,1,'Sale Id shift 53',1079443.92,0.00,0.00,0.00,0.00,'2022-06-25 11:57:16','',''),(766,'22','242','1',1,'Sale Id shift 55',0.00,0.00,0.00,857.79,0.00,'2022-06-25 12:10:24','',''),(767,'22','242','2',1,'Sale Id shift 55',0.00,0.00,0.00,595.53,0.00,'2022-06-25 12:10:24','',''),(768,'22','242','1',1,'Sale Id shift 55',0.00,0.00,0.00,397.70,0.00,'2022-06-25 12:10:24','',''),(769,'22','242','2',1,'Sale Id shift 55',0.00,0.00,0.00,926.14,0.00,'2022-06-25 12:10:24','',''),(770,'22','242','2',1,'Sale Id shift 55',0.00,0.00,0.00,514.39,0.00,'2022-06-25 12:10:24','',''),(771,'22','242','2',1,'Sale Id shift 55',0.00,0.00,0.00,266.16,0.00,'2022-06-25 12:10:24','',''),(772,'22','242','3',2,'Sale Id shift 55',0.00,0.00,0.00,606.38,0.00,'2022-06-25 12:10:24','',''),(773,'22','242','3',2,'Sale Id shift 55',0.00,0.00,0.00,1515.79,0.00,'2022-06-25 12:10:24','',''),(774,'22','242','4',2,'Sale Id shift 55',0.00,0.00,0.00,980.00,0.00,'2022-06-25 12:10:24','',''),(775,'22','242','1',1,'Sale Id shift 55',0.00,0.00,0.00,794.56,0.00,'2022-06-25 12:10:24','',''),(776,'22','242','1',1,'Sale Id shift 55',0.00,0.00,0.00,1025.19,0.00,'2022-06-25 12:10:24','',''),(777,'22','242','1',1,'Sale Id shift 55',0.00,0.00,0.00,698.83,0.00,'2022-06-25 12:10:24','',''),(778,'22','242',NULL,2,'Sale Id shift 55',2357649.20,0.00,0.00,0.00,0.00,'2022-06-25 12:10:24','',''),(779,'22','242',NULL,1,'Sale Id shift 55',899290.92,0.00,0.00,0.00,0.00,'2022-06-25 12:10:24','',''),(780,'22','242','1',1,'Sale Id shift 56',0.00,0.00,0.00,654.93,0.00,'2022-06-26 06:33:21','',''),(781,'22','242','2',1,'Sale Id shift 56',0.00,0.00,0.00,1492.73,0.00,'2022-06-26 06:33:21','',''),(782,'22','242','1',1,'Sale Id shift 56',0.00,0.00,0.00,1568.56,0.00,'2022-06-26 06:33:21','',''),(783,'22','242','2',1,'Sale Id shift 56',0.00,0.00,0.00,912.18,0.00,'2022-06-26 06:33:21','',''),(784,'22','242','2',1,'Sale Id shift 56',0.00,0.00,0.00,880.61,0.00,'2022-06-26 06:33:21','',''),(785,'22','242','2',1,'Sale Id shift 56',0.00,0.00,0.00,364.83,0.00,'2022-06-26 06:33:21','',''),(786,'22','242','3',2,'Sale Id shift 56',0.00,0.00,0.00,646.10,0.00,'2022-06-26 06:33:21','',''),(787,'22','242','3',2,'Sale Id shift 56',0.00,0.00,0.00,1160.41,0.00,'2022-06-26 06:33:21','',''),(788,'22','242','4',2,'Sale Id shift 56',0.00,0.00,0.00,1160.00,0.00,'2022-06-26 06:33:21','',''),(789,'22','242','1',1,'Sale Id shift 56',0.00,0.00,0.00,2199.40,0.00,'2022-06-26 06:33:21','',''),(790,'22','242','1',1,'Sale Id shift 56',0.00,0.00,0.00,1776.38,0.00,'2022-06-26 06:33:21','',''),(791,'22','242','1',1,'Sale Id shift 56',0.00,0.00,0.00,693.88,0.00,'2022-06-26 06:33:21','',''),(792,'22','242',NULL,2,'Sale Id shift 56',2254547.60,0.00,0.00,0.00,0.00,'2022-06-26 06:33:21','',''),(793,'22','242',NULL,1,'Sale Id shift 56',1560438.00,0.00,0.00,0.00,0.00,'2022-06-26 06:33:21','',''),(794,'22','242','1',1,'Sale Id shift 57',0.00,0.00,0.00,1378.55,0.00,'2022-06-26 18:43:42','',''),(795,'22','242','2',1,'Sale Id shift 57',0.00,0.00,0.00,929.64,0.00,'2022-06-26 18:43:42','',''),(796,'22','242','1',1,'Sale Id shift 57',0.00,0.00,0.00,230.54,0.00,'2022-06-26 18:43:42','',''),(797,'22','242','2',1,'Sale Id shift 57',0.00,0.00,0.00,306.24,0.00,'2022-06-26 18:43:42','',''),(798,'22','242','2',1,'Sale Id shift 57',0.00,0.00,0.00,42.42,0.00,'2022-06-26 18:43:42','',''),(799,'22','242','3',2,'Sale Id shift 57',0.00,0.00,0.00,229.64,0.00,'2022-06-26 18:43:42','',''),(800,'22','242','3',2,'Sale Id shift 57',0.00,0.00,0.00,230.33,0.00,'2022-06-26 18:43:42','',''),(801,'22','242','1',1,'Sale Id shift 57',0.00,0.00,0.00,309.97,0.00,'2022-06-26 18:43:42','',''),(802,'22','242','1',1,'Sale Id shift 57',0.00,0.00,0.00,940.13,0.00,'2022-06-26 18:43:42','',''),(803,'22','242','1',1,'Sale Id shift 57',0.00,0.00,0.00,1461.70,0.00,'2022-06-26 18:43:42','',''),(804,'22','242',NULL,2,'Sale Id shift 57',349577.20,0.00,0.00,0.00,0.00,'2022-06-26 18:43:42','',''),(805,'22','242',NULL,1,'Sale Id shift 57',828680.12,0.00,0.00,0.00,0.00,'2022-06-26 18:43:42','',''),(806,'22','242',NULL,1,'Purchased from AITEO ENERGY RESOURCES',0.00,6660000.00,45000.00,0.00,0.00,'2022-06-27 12:47:58','',''),(807,'22','242',NULL,1,'Reception corrector for bridging 44',0.00,0.00,0.00,15000.00,0.00,'2022-06-27 12:50:45','',''),(808,'22','242','2',1,'Received from bridging 44',0.00,0.00,15000.00,0.00,0.00,'2022-06-27 12:50:45','',''),(809,'22','242',NULL,1,'Reception corrector for bridging 43',0.00,0.00,0.00,30000.00,0.00,'2022-06-27 12:51:06','',''),(810,'22','242','1',1,'Received from bridging 43',0.00,0.00,30000.00,0.00,0.00,'2022-06-27 12:51:06','',''),(811,'22','242','1',1,'Sale Id shift 58',0.00,0.00,0.00,986.01,0.00,'2022-06-27 21:35:23','',''),(812,'22','242','2',1,'Sale Id shift 58',0.00,0.00,0.00,2967.22,0.00,'2022-06-27 21:35:23','',''),(813,'22','242','1',1,'Sale Id shift 58',0.00,0.00,0.00,1553.67,0.00,'2022-06-27 21:35:23','',''),(814,'22','242','2',1,'Sale Id shift 58',0.00,0.00,0.00,1671.52,0.00,'2022-06-27 21:35:23','',''),(815,'22','242','3',2,'Sale Id shift 58',0.00,0.00,0.00,949.84,0.00,'2022-06-27 21:35:23','',''),(816,'22','242','3',2,'Sale Id shift 58',0.00,0.00,0.00,1241.33,0.00,'2022-06-27 21:35:23','',''),(817,'22','242','4',2,'Sale Id shift 58',0.00,0.00,0.00,1630.00,0.00,'2022-06-27 21:35:23','',''),(818,'22','242','1',1,'Sale Id shift 58',0.00,0.00,0.00,1377.86,0.00,'2022-06-27 21:35:23','',''),(819,'22','242','1',1,'Sale Id shift 58',0.00,0.00,0.00,2035.94,0.00,'2022-06-27 21:35:23','',''),(820,'22','242','1',1,'Sale Id shift 58',0.00,0.00,0.00,1413.91,0.00,'2022-06-27 21:35:23','',''),(821,'22','242',NULL,2,'Sale Id shift 58',2904089.20,0.00,0.00,0.00,0.00,'2022-06-27 21:35:23','',''),(822,'22','242',NULL,1,'Sale Id shift 58',1776907.24,0.00,0.00,0.00,0.00,'2022-06-27 21:35:23','',''),(823,'22','242','1',1,'Sale Id shift 59',0.00,0.00,0.00,1366.52,0.00,'2022-06-28 20:58:23','',''),(824,'22','242','2',1,'Sale Id shift 59',0.00,0.00,0.00,2783.20,0.00,'2022-06-28 20:58:23','',''),(825,'22','242','1',1,'Sale Id shift 59',0.00,0.00,0.00,973.34,0.00,'2022-06-28 20:58:23','',''),(826,'22','242','2',1,'Sale Id shift 59',0.00,0.00,0.00,1223.28,0.00,'2022-06-28 20:58:23','',''),(827,'22','242','3',2,'Sale Id shift 59',0.00,0.00,0.00,880.25,0.00,'2022-06-28 20:58:23','',''),(828,'22','242','3',2,'Sale Id shift 59',0.00,0.00,0.00,1243.90,0.00,'2022-06-28 20:58:23','',''),(829,'22','242','4',2,'Sale Id shift 59',0.00,0.00,0.00,450.00,0.00,'2022-06-28 20:58:23','',''),(830,'22','242','1',1,'Sale Id shift 59',0.00,0.00,0.00,2446.35,0.00,'2022-06-28 20:58:23','',''),(831,'22','242','1',1,'Sale Id shift 59',0.00,0.00,0.00,2482.32,0.00,'2022-06-28 20:58:23','',''),(832,'22','242','1',1,'Sale Id shift 59',0.00,0.00,0.00,1213.07,0.00,'2022-06-28 20:58:23','',''),(833,'22','242',NULL,2,'Sale Id shift 59',1956354.00,0.00,0.00,0.00,0.00,'2022-06-28 20:58:23','',''),(834,'22','242',NULL,1,'Sale Id shift 59',1848235.84,0.00,0.00,0.00,0.00,'2022-06-28 20:58:23','',''),(835,'22','242','1',1,'Sale Id shift 60',0.00,0.00,0.00,2415.32,0.00,'2022-06-29 21:42:51','',''),(836,'22','242','2',1,'Sale Id shift 60',0.00,0.00,0.00,2003.15,0.00,'2022-06-29 21:42:51','',''),(837,'22','242','1',1,'Sale Id shift 60',0.00,0.00,0.00,1657.62,0.00,'2022-06-29 21:42:51','',''),(838,'22','242','2',1,'Sale Id shift 60',0.00,0.00,0.00,2236.16,0.00,'2022-06-29 21:42:51','',''),(839,'22','242','2',1,'Sale Id shift 60',0.00,0.00,0.00,0.68,0.00,'2022-06-29 21:42:51','',''),(840,'22','242','2',1,'Sale Id shift 60',0.00,0.00,0.00,1.97,0.00,'2022-06-29 21:42:51','',''),(841,'22','242','3',2,'Sale Id shift 60',0.00,0.00,0.00,946.13,0.00,'2022-06-29 21:42:51','',''),(842,'22','242','3',2,'Sale Id shift 60',0.00,0.00,0.00,821.09,0.00,'2022-06-29 21:42:51','',''),(843,'22','242','4',2,'Sale Id shift 60',0.00,0.00,0.00,4014.13,0.00,'2022-06-29 21:42:51','',''),(844,'22','242','1',1,'Sale Id shift 60',0.00,0.00,0.00,947.17,0.00,'2022-06-29 21:42:51','',''),(845,'22','242','1',1,'Sale Id shift 60',0.00,0.00,0.00,2132.89,0.00,'2022-06-29 21:42:51','',''),(846,'22','242','1',1,'Sale Id shift 60',0.00,0.00,0.00,1339.18,0.00,'2022-06-29 21:42:51','',''),(847,'22','242',NULL,2,'Sale Id shift 60',4393826.00,0.00,0.00,0.00,0.00,'2022-06-29 21:42:51','',''),(848,'22','242',NULL,1,'Sale Id shift 60',1884652.72,0.00,0.00,0.00,0.00,'2022-06-29 21:42:51','',''),(849,'22','242',NULL,1,'Purchased from AITEO ENERGY RESOURCES',0.00,5920000.00,40000.00,0.00,0.00,'2022-06-30 18:00:35','',''),(850,'22','242',NULL,1,'Reception corrector for bridging 46',0.00,0.00,0.00,13500.00,0.00,'2022-06-30 18:02:21','',''),(851,'22','242','2',1,'Received from bridging 46',0.00,0.00,13500.00,0.00,0.00,'2022-06-30 18:02:21','',''),(852,'22','242',NULL,1,'Reception corrector for bridging 45',0.00,0.00,0.00,26500.00,0.00,'2022-06-30 18:02:42','',''),(853,'22','242','1',1,'Received from bridging 45',0.00,0.00,26500.00,0.00,0.00,'2022-06-30 18:02:42','',''),(854,'22','242',NULL,2,'Purchased from WOSBAB ENERGY SOLUTIONS NIG LT',0.00,34200000.00,45000.00,0.00,0.00,'2022-07-01 13:02:54','',''),(855,'22','242','1',1,'Sale Id shift 61',0.00,0.00,0.00,2171.26,0.00,'2022-07-01 13:08:14','',''),(856,'22','242','2',1,'Sale Id shift 61',0.00,0.00,0.00,1083.17,0.00,'2022-07-01 13:08:14','',''),(857,'22','242','1',1,'Sale Id shift 61',0.00,0.00,0.00,2554.38,0.00,'2022-07-01 13:08:14','',''),(858,'22','242','2',1,'Sale Id shift 61',0.00,0.00,0.00,1366.38,0.00,'2022-07-01 13:08:14','',''),(859,'22','242','3',2,'Sale Id shift 61',0.00,0.00,0.00,1210.57,0.00,'2022-07-01 13:08:14','',''),(860,'22','242','3',2,'Sale Id shift 61',0.00,0.00,0.00,948.08,0.00,'2022-07-01 13:08:14','',''),(861,'22','242','4',2,'Sale Id shift 61',0.00,0.00,0.00,790.00,0.00,'2022-07-01 13:08:14','',''),(862,'22','242','1',1,'Sale Id shift 61',0.00,0.00,0.00,747.80,0.00,'2022-07-01 13:08:14','',''),(863,'22','242','1',1,'Sale Id shift 61',0.00,0.00,0.00,1502.14,0.00,'2022-07-01 13:08:14','',''),(864,'22','242','1',1,'Sale Id shift 61',0.00,0.00,0.00,1900.22,0.00,'2022-07-01 13:08:14','',''),(865,'22','242',NULL,2,'Sale Id shift 61',2240974.00,0.00,0.00,0.00,0.00,'2022-07-01 13:08:14','',''),(866,'22','242',NULL,1,'Sale Id shift 61',1676151.80,0.00,0.00,0.00,0.00,'2022-07-01 13:08:14','',''),(867,'22','242',NULL,2,'Reception corrector for bridging 48',0.00,0.00,0.00,16900.00,0.00,'2022-07-01 13:12:27','',''),(868,'22','242','4',2,'Received from bridging 48',0.00,0.00,16900.00,0.00,0.00,'2022-07-01 13:12:27','',''),(869,'22','242',NULL,2,'Reception corrector for bridging 47',0.00,0.00,0.00,28100.00,0.00,'2022-07-01 13:12:42','',''),(870,'22','242','3',2,'Received from bridging 47',0.00,0.00,28100.00,0.00,0.00,'2022-07-01 13:12:42','',''),(871,'22','242','1',1,'Sale Id shift 62',0.00,0.00,0.00,1381.02,0.00,'2022-07-02 09:35:54','',''),(872,'22','242','2',1,'Sale Id shift 62',0.00,0.00,0.00,2124.35,0.00,'2022-07-02 09:35:54','',''),(873,'22','242','1',1,'Sale Id shift 62',0.00,0.00,0.00,1689.51,0.00,'2022-07-02 09:35:54','',''),(874,'22','242','2',1,'Sale Id shift 62',0.00,0.00,0.00,1575.75,0.00,'2022-07-02 09:35:54','',''),(875,'22','242','3',2,'Sale Id shift 62',0.00,0.00,0.00,726.29,0.00,'2022-07-02 09:35:54','',''),(876,'22','242','3',2,'Sale Id shift 62',0.00,0.00,0.00,836.62,0.00,'2022-07-02 09:35:54','',''),(877,'22','242','4',2,'Sale Id shift 62',0.00,0.00,0.00,841.93,0.00,'2022-07-02 09:35:54','',''),(878,'22','242','1',1,'Sale Id shift 62',0.00,0.00,0.00,2437.28,0.00,'2022-07-02 09:35:54','',''),(879,'22','242','1',1,'Sale Id shift 62',0.00,0.00,0.00,2406.43,0.00,'2022-07-02 09:35:54','',''),(880,'22','242','1',1,'Sale Id shift 62',0.00,0.00,0.00,1321.32,0.00,'2022-07-02 09:35:54','',''),(881,'22','242',NULL,2,'Sale Id shift 62',1827678.40,0.00,0.00,0.00,0.00,'2022-07-02 09:35:54','',''),(882,'22','242',NULL,1,'Sale Id shift 62',1914477.68,0.00,0.00,0.00,0.00,'2022-07-02 09:35:54','',''),(883,'22','242',NULL,1,'Purchased from AITEO ENERGY RESOURCES',0.00,5920000.00,40000.00,0.00,0.00,'2022-07-02 11:06:09','',''),(884,'22','242',NULL,1,'Reception corrector for bridging 50',0.00,0.00,0.00,18900.00,0.00,'2022-07-02 19:48:37','',''),(885,'22','242','2',1,'Received from bridging 50',0.00,0.00,18900.00,0.00,0.00,'2022-07-02 19:48:37','',''),(886,'22','242',NULL,1,'Reception corrector for bridging 49',0.00,0.00,0.00,21100.00,0.00,'2022-07-02 19:55:43','',''),(887,'22','242','1',1,'Received from bridging 49',0.00,0.00,21100.00,0.00,0.00,'2022-07-02 19:55:43','',''),(888,'22','242','1',1,'Sale Id shift 63',0.00,0.00,0.00,1401.61,0.00,'2022-07-02 21:51:00','',''),(889,'22','242','2',1,'Sale Id shift 63',0.00,0.00,0.00,2236.27,0.00,'2022-07-02 21:51:00','',''),(890,'22','242','1',1,'Sale Id shift 63',0.00,0.00,0.00,2560.49,0.00,'2022-07-02 21:51:00','',''),(891,'22','242','2',1,'Sale Id shift 63',0.00,0.00,0.00,3750.48,0.00,'2022-07-02 21:51:00','',''),(892,'22','242','3',2,'Sale Id shift 63',0.00,0.00,0.00,923.81,0.00,'2022-07-02 21:51:00','',''),(893,'22','242','3',2,'Sale Id shift 63',0.00,0.00,0.00,1488.99,0.00,'2022-07-02 21:51:00','',''),(894,'22','242','4',2,'Sale Id shift 63',0.00,0.00,0.00,1050.00,0.00,'2022-07-02 21:51:00','',''),(895,'22','242','1',1,'Sale Id shift 63',0.00,0.00,0.00,2746.65,0.00,'2022-07-02 21:51:00','',''),(896,'22','242','1',1,'Sale Id shift 63',0.00,0.00,0.00,3038.87,0.00,'2022-07-02 21:51:00','',''),(897,'22','242','1',1,'Sale Id shift 63',0.00,0.00,0.00,1977.73,0.00,'2022-07-02 21:51:00','',''),(898,'22','242',NULL,2,'Sale Id shift 63',2631728.00,0.00,0.00,0.00,0.00,'2022-07-02 21:51:00','',''),(899,'22','242',NULL,1,'Sale Id shift 63',2621390.80,0.00,0.00,0.00,0.00,'2022-07-02 21:51:00','',''),(900,'22','242','1',1,'Sale Id shift 64',0.00,0.00,0.00,1156.57,0.00,'2022-07-04 08:12:27','',''),(901,'22','242','2',1,'Sale Id shift 64',0.00,0.00,0.00,1010.47,0.00,'2022-07-04 08:12:27','',''),(902,'22','242','1',1,'Sale Id shift 64',0.00,0.00,0.00,866.39,0.00,'2022-07-04 08:12:27','',''),(903,'22','242','2',1,'Sale Id shift 64',0.00,0.00,0.00,2422.47,0.00,'2022-07-04 08:12:27','',''),(904,'22','242','3',2,'Sale Id shift 64',0.00,0.00,0.00,273.37,0.00,'2022-07-04 08:12:27','',''),(905,'22','242','3',2,'Sale Id shift 64',0.00,0.00,0.00,313.41,0.00,'2022-07-04 08:12:27','',''),(906,'22','242','4',2,'Sale Id shift 64',0.00,0.00,0.00,1000.00,0.00,'2022-07-04 08:12:27','',''),(907,'22','242','1',1,'Sale Id shift 64',0.00,0.00,0.00,1424.38,0.00,'2022-07-04 08:12:27','',''),(908,'22','242','1',1,'Sale Id shift 64',0.00,0.00,0.00,1342.74,0.00,'2022-07-04 08:12:27','',''),(909,'22','242','1',1,'Sale Id shift 64',0.00,0.00,0.00,1243.31,0.00,'2022-07-04 08:12:27','',''),(910,'22','242',NULL,2,'Sale Id shift 64',1205952.80,0.00,0.00,0.00,0.00,'2022-07-04 08:12:27','',''),(911,'22','242',NULL,1,'Sale Id shift 64',1401016.84,0.00,0.00,0.00,0.00,'2022-07-04 08:12:27','',''),(912,'22','242','1',1,'Sale Id shift 65',0.00,0.00,0.00,2349.52,0.00,'2022-07-04 21:42:19','',''),(913,'22','242','2',1,'Sale Id shift 65',0.00,0.00,0.00,2929.13,0.00,'2022-07-04 21:42:19','',''),(914,'22','242','1',1,'Sale Id shift 65',0.00,0.00,0.00,4873.37,0.00,'2022-07-04 21:42:19','',''),(915,'22','242','2',1,'Sale Id shift 65',0.00,0.00,0.00,7225.55,0.00,'2022-07-04 21:42:19','',''),(916,'22','242','2',1,'Sale Id shift 65',0.00,0.00,0.00,1792.35,0.00,'2022-07-04 21:42:19','',''),(917,'22','242','2',1,'Sale Id shift 65',0.00,0.00,0.00,2007.97,0.00,'2022-07-04 21:42:19','',''),(918,'22','242','3',2,'Sale Id shift 65',0.00,0.00,0.00,1046.14,0.00,'2022-07-04 21:42:19','',''),(919,'22','242','3',2,'Sale Id shift 65',0.00,0.00,0.00,1240.23,0.00,'2022-07-04 21:42:19','',''),(920,'22','242','4',2,'Sale Id shift 65',0.00,0.00,0.00,680.00,0.00,'2022-07-04 21:42:19','',''),(921,'22','242','1',1,'Sale Id shift 65',0.00,0.00,0.00,3093.71,0.00,'2022-07-04 21:42:19','',''),(922,'22','242','1',1,'Sale Id shift 65',0.00,0.00,0.00,3705.58,0.00,'2022-07-04 21:42:19','',''),(923,'22','242','1',1,'Sale Id shift 65',0.00,0.00,0.00,2451.85,0.00,'2022-07-04 21:42:19','',''),(924,'22','242',NULL,2,'Sale Id shift 65',2254441.20,0.00,0.00,0.00,0.00,'2022-07-04 21:42:19','',''),(925,'22','242',NULL,1,'Sale Id shift 65',4503496.44,0.00,0.00,0.00,0.00,'2022-07-04 21:42:19','',''),(926,'22','242','1',1,'Sale Id shift 66',0.00,0.00,0.00,534.85,0.00,'2022-07-05 19:57:45','',''),(927,'22','242','2',1,'Sale Id shift 66',0.00,0.00,0.00,2065.12,0.00,'2022-07-05 19:57:45','',''),(928,'22','242','1',1,'Sale Id shift 66',0.00,0.00,0.00,543.29,0.00,'2022-07-05 19:57:45','',''),(929,'22','242','2',1,'Sale Id shift 66',0.00,0.00,0.00,1660.40,0.00,'2022-07-05 19:57:45','',''),(930,'22','242','2',1,'Sale Id shift 66',0.00,0.00,0.00,78.60,0.00,'2022-07-05 19:57:45','',''),(931,'22','242','2',1,'Sale Id shift 66',0.00,0.00,0.00,30.26,0.00,'2022-07-05 19:57:45','',''),(932,'22','242','3',2,'Sale Id shift 66',0.00,0.00,0.00,899.37,0.00,'2022-07-05 19:57:45','',''),(933,'22','242','3',2,'Sale Id shift 66',0.00,0.00,0.00,1395.82,0.00,'2022-07-05 19:57:45','',''),(934,'22','242','4',2,'Sale Id shift 66',0.00,0.00,0.00,1050.00,0.00,'2022-07-05 19:57:45','',''),(935,'22','242','1',1,'Sale Id shift 66',0.00,0.00,0.00,547.72,0.00,'2022-07-05 19:57:45','',''),(936,'22','242','1',1,'Sale Id shift 66',0.00,0.00,0.00,1009.67,0.00,'2022-07-05 19:57:45','',''),(937,'22','242','1',1,'Sale Id shift 66',0.00,0.00,0.00,814.83,0.00,'2022-07-05 19:57:45','',''),(938,'22','242',NULL,2,'Sale Id shift 66',2542344.40,0.00,0.00,0.00,0.00,'2022-07-05 19:57:45','',''),(939,'22','242',NULL,1,'Sale Id shift 66',1078141.52,0.00,0.00,0.00,0.00,'2022-07-05 19:57:45','',''),(940,'22','242','2',1,'Sale Id shift 67',0.00,0.00,0.00,863.81,0.00,'2022-07-06 21:05:09','',''),(941,'22','242','1',1,'Sale Id shift 67',0.00,0.00,0.00,600.19,0.00,'2022-07-06 21:05:09','',''),(942,'22','242','2',1,'Sale Id shift 67',0.00,0.00,0.00,2211.72,0.00,'2022-07-06 21:05:09','',''),(943,'22','242','3',2,'Sale Id shift 67',0.00,0.00,0.00,1316.06,0.00,'2022-07-06 21:05:09','',''),(944,'22','242','3',2,'Sale Id shift 67',0.00,0.00,0.00,1194.03,0.00,'2022-07-06 21:05:09','',''),(945,'22','242','4',2,'Sale Id shift 67',0.00,0.00,0.00,1400.00,0.00,'2022-07-06 21:05:09','',''),(946,'22','242','1',1,'Sale Id shift 67',0.00,0.00,0.00,1891.51,0.00,'2022-07-06 21:05:09','',''),(947,'22','242','1',1,'Sale Id shift 67',0.00,0.00,0.00,1619.95,0.00,'2022-07-06 21:05:09','',''),(948,'22','242',NULL,2,'Sale Id shift 67',2971668.40,0.00,0.00,0.00,0.00,'2022-07-06 21:05:09','',''),(949,'22','242',NULL,1,'Sale Id shift 67',1063702.64,0.00,0.00,0.00,0.00,'2022-07-06 21:05:09','',''),(950,'22','242',NULL,1,'Purchased from AA RANO NIGERIA LIMITED',0.00,6660000.00,45000.00,0.00,0.00,'2022-07-10 17:43:51','',''),(951,'22','242',NULL,1,'Reception corrector for bridging 52',0.00,0.00,0.00,15000.00,0.00,'2022-07-10 17:45:05','',''),(952,'22','242','2',1,'Received from bridging 52',0.00,0.00,15000.00,0.00,0.00,'2022-07-10 17:45:05','',''),(953,'22','242',NULL,1,'Reception corrector for bridging 51',0.00,0.00,0.00,30000.00,0.00,'2022-07-10 17:45:17','',''),(954,'22','242','1',1,'Received from bridging 51',0.00,0.00,30000.00,0.00,0.00,'2022-07-10 17:45:17','',''),(955,'22','242','1',1,'Sale Id shift 68',0.00,0.00,0.00,1019.32,0.00,'2022-07-10 17:53:34','',''),(956,'22','242','2',1,'Sale Id shift 68',0.00,0.00,0.00,70.00,0.00,'2022-07-10 17:53:34','',''),(957,'22','242','1',1,'Sale Id shift 68',0.00,0.00,0.00,2698.66,0.00,'2022-07-10 17:53:34','',''),(958,'22','242','2',1,'Sale Id shift 68',0.00,0.00,0.00,86.70,0.00,'2022-07-10 17:53:34','',''),(959,'22','242','3',2,'Sale Id shift 68',0.00,0.00,0.00,1352.59,0.00,'2022-07-10 17:53:34','',''),(960,'22','242','3',2,'Sale Id shift 68',0.00,0.00,0.00,1054.89,0.00,'2022-07-10 17:53:34','',''),(961,'22','242','4',2,'Sale Id shift 68',0.00,0.00,0.00,1184.94,0.00,'2022-07-10 17:53:34','',''),(962,'22','242','1',1,'Sale Id shift 68',0.00,0.00,0.00,1430.04,0.00,'2022-07-10 17:53:34','',''),(963,'22','242','1',1,'Sale Id shift 68',0.00,0.00,0.00,1557.52,0.00,'2022-07-10 17:53:34','',''),(964,'22','242','1',1,'Sale Id shift 68',0.00,0.00,0.00,1271.46,0.00,'2022-07-10 17:53:34','',''),(965,'22','242',NULL,2,'Sale Id shift 68',2730239.20,0.00,0.00,0.00,0.00,'2022-07-10 17:53:34','',''),(966,'22','242',NULL,1,'Sale Id shift 68',1203787.60,0.00,0.00,0.00,0.00,'2022-07-10 17:53:34','',''),(967,'22','242','2',1,'Sale Id shift 69',0.00,0.00,0.00,49.33,0.00,'2022-07-10 17:58:24','',''),(968,'22','242','2',1,'Sale Id shift 69',0.00,0.00,0.00,1646.74,0.00,'2022-07-10 17:58:24','',''),(969,'22','242','3',2,'Sale Id shift 69',0.00,0.00,0.00,1227.09,0.00,'2022-07-10 17:58:24','',''),(970,'22','242','3',2,'Sale Id shift 69',0.00,0.00,0.00,1849.87,0.00,'2022-07-10 17:58:24','',''),(971,'22','242','4',2,'Sale Id shift 69',0.00,0.00,0.00,1278.75,0.00,'2022-07-10 17:58:24','',''),(972,'22','242','1',1,'Sale Id shift 69',0.00,0.00,0.00,34.79,0.00,'2022-07-10 17:58:24','',''),(973,'22','242',NULL,2,'Sale Id shift 69',3310339.60,0.00,0.00,0.00,0.00,'2022-07-10 17:58:24','',''),(974,'22','242',NULL,1,'Sale Id shift 69',256167.28,0.00,0.00,0.00,0.00,'2022-07-10 17:58:24','',''),(975,'22','242','2',1,'Sale Id shift 70',0.00,0.00,0.00,191.75,0.00,'2022-07-10 18:02:20','',''),(976,'22','242','3',2,'Sale Id shift 70',0.00,0.00,0.00,639.96,0.00,'2022-07-10 18:02:20','',''),(977,'22','242','3',2,'Sale Id shift 70',0.00,0.00,0.00,912.00,0.00,'2022-07-10 18:02:20','',''),(978,'22','242','4',2,'Sale Id shift 70',0.00,0.00,0.00,1460.00,0.00,'2022-07-10 18:02:20','',''),(979,'22','242',NULL,2,'Sale Id shift 70',2289089.60,0.00,0.00,0.00,0.00,'2022-07-10 18:02:20','',''),(980,'22','242',NULL,1,'Sale Id shift 70',28379.00,0.00,0.00,0.00,0.00,'2022-07-10 18:02:20','',''),(981,'22','242','2',1,'Sale Id shift 71',0.00,0.00,0.00,23.43,0.00,'2022-07-10 18:38:53','',''),(982,'22','242','3',2,'Sale Id shift 71',0.00,0.00,0.00,341.46,0.00,'2022-07-10 18:38:53','',''),(983,'22','242','3',2,'Sale Id shift 71',0.00,0.00,0.00,966.12,0.00,'2022-07-10 18:38:53','',''),(984,'22','242','4',2,'Sale Id shift 71',0.00,0.00,0.00,550.00,0.00,'2022-07-10 18:38:53','',''),(985,'22','242',NULL,2,'Sale Id shift 71',1411760.80,0.00,0.00,0.00,0.00,'2022-07-10 18:38:53','',''),(986,'22','242',NULL,1,'Sale Id shift 71',3467.64,0.00,0.00,0.00,0.00,'2022-07-10 18:38:53','',''),(987,'22','242','1',1,'Sale Id shift 72',0.00,0.00,0.00,1545.63,0.00,'2022-07-13 07:47:59','',''),(988,'22','242','2',1,'Sale Id shift 72',0.00,0.00,0.00,2119.67,0.00,'2022-07-13 07:47:59','',''),(989,'22','242','1',1,'Sale Id shift 72',0.00,0.00,0.00,779.13,0.00,'2022-07-13 07:47:59','',''),(990,'22','242','2',1,'Sale Id shift 72',0.00,0.00,0.00,1749.53,0.00,'2022-07-13 07:47:59','',''),(991,'22','242','2',1,'Sale Id shift 72',0.00,0.00,0.00,763.78,0.00,'2022-07-13 07:47:59','',''),(992,'22','242','2',1,'Sale Id shift 72',0.00,0.00,0.00,1237.35,0.00,'2022-07-13 07:47:59','',''),(993,'22','242','3',2,'Sale Id shift 72',0.00,0.00,0.00,807.43,0.00,'2022-07-13 07:47:59','',''),(994,'22','242','3',2,'Sale Id shift 72',0.00,0.00,0.00,572.02,0.00,'2022-07-13 07:47:59','',''),(995,'22','242','1',1,'Sale Id shift 72',0.00,0.00,0.00,1189.48,0.00,'2022-07-13 07:47:59','',''),(996,'22','242','1',1,'Sale Id shift 72',0.00,0.00,0.00,2204.87,0.00,'2022-07-13 07:47:59','',''),(997,'22','242','1',1,'Sale Id shift 72',0.00,0.00,0.00,1729.54,0.00,'2022-07-13 07:47:59','',''),(998,'22','242',NULL,2,'Sale Id shift 72',1048382.00,0.00,0.00,0.00,0.00,'2022-07-13 07:47:59','',''),(999,'22','242',NULL,1,'Sale Id shift 72',1971209.04,0.00,0.00,0.00,0.00,'2022-07-13 07:47:59','',''),(1000,'22','242','1',1,'Sale Id shift 73',0.00,0.00,0.00,2032.74,0.00,'2022-07-13 07:53:32','',''),(1001,'22','242','2',1,'Sale Id shift 73',0.00,0.00,0.00,752.91,0.00,'2022-07-13 07:53:32','',''),(1002,'22','242','1',1,'Sale Id shift 73',0.00,0.00,0.00,1860.02,0.00,'2022-07-13 07:53:32','',''),(1003,'22','242','2',1,'Sale Id shift 73',0.00,0.00,0.00,814.53,0.00,'2022-07-13 07:53:32','',''),(1004,'22','242','2',1,'Sale Id shift 73',0.00,0.00,0.00,1087.59,0.00,'2022-07-13 07:53:32','',''),(1005,'22','242','2',1,'Sale Id shift 73',0.00,0.00,0.00,418.23,0.00,'2022-07-13 07:53:32','',''),(1006,'22','242','3',2,'Sale Id shift 73',0.00,0.00,0.00,575.68,0.00,'2022-07-13 07:53:32','',''),(1007,'22','242','3',2,'Sale Id shift 73',0.00,0.00,0.00,1100.98,0.00,'2022-07-13 07:53:32','',''),(1008,'22','242','4',2,'Sale Id shift 73',0.00,0.00,0.00,1000.00,0.00,'2022-07-13 07:53:32','',''),(1009,'22','242','1',1,'Sale Id shift 73',0.00,0.00,0.00,942.43,0.00,'2022-07-13 07:53:32','',''),(1010,'22','242','1',1,'Sale Id shift 73',0.00,0.00,0.00,1982.27,0.00,'2022-07-13 07:53:32','',''),(1011,'22','242','1',1,'Sale Id shift 73',0.00,0.00,0.00,1711.93,0.00,'2022-07-13 07:53:32','',''),(1012,'22','242',NULL,2,'Sale Id shift 73',2034261.60,0.00,0.00,0.00,0.00,'2022-07-13 07:53:32','',''),(1013,'22','242',NULL,1,'Sale Id shift 73',1717192.20,0.00,0.00,0.00,0.00,'2022-07-13 07:53:32','',''),(1014,'22','242',NULL,1,'Purchased from PINNACLE OIL & GAS LIMITED ',0.00,6660000.00,45000.00,0.00,0.00,'2022-07-15 18:17:44','',''),(1015,'22','242',NULL,1,'Reception corrector for bridging 54',0.00,0.00,0.00,15000.00,0.00,'2022-07-15 18:19:16','',''),(1016,'22','242','2',1,'Received from bridging 54',0.00,0.00,15000.00,0.00,0.00,'2022-07-15 18:19:16','',''),(1017,'22','242',NULL,1,'Reception corrector for bridging 53',0.00,0.00,0.00,30000.00,0.00,'2022-07-15 18:19:31','',''),(1018,'22','242','1',1,'Received from bridging 53',0.00,0.00,30000.00,0.00,0.00,'2022-07-15 18:19:31','',''),(1019,'22','242','1',1,'Sale Id shift 74',0.00,0.00,0.00,1592.20,0.00,'2022-07-15 18:27:24','',''),(1020,'22','242','2',1,'Sale Id shift 74',0.00,0.00,0.00,1724.65,0.00,'2022-07-15 18:27:24','',''),(1021,'22','242','1',1,'Sale Id shift 74',0.00,0.00,0.00,1804.76,0.00,'2022-07-15 18:27:24','',''),(1022,'22','242','2',1,'Sale Id shift 74',0.00,0.00,0.00,1567.17,0.00,'2022-07-15 18:27:24','',''),(1023,'22','242','2',1,'Sale Id shift 74',0.00,0.00,0.00,1084.63,0.00,'2022-07-15 18:27:24','',''),(1024,'22','242','2',1,'Sale Id shift 74',0.00,0.00,0.00,995.12,0.00,'2022-07-15 18:27:24','',''),(1025,'22','242','3',2,'Sale Id shift 74',0.00,0.00,0.00,1152.17,0.00,'2022-07-15 18:27:24','',''),(1026,'22','242','3',2,'Sale Id shift 74',0.00,0.00,0.00,919.03,0.00,'2022-07-15 18:27:24','',''),(1027,'22','242','4',2,'Sale Id shift 74',0.00,0.00,0.00,480.00,0.00,'2022-07-15 18:27:24','',''),(1028,'22','242','1',1,'Sale Id shift 74',0.00,0.00,0.00,1658.41,0.00,'2022-07-15 18:27:24','',''),(1029,'22','242','1',1,'Sale Id shift 74',0.00,0.00,0.00,2032.37,0.00,'2022-07-15 18:27:24','',''),(1030,'22','242','1',1,'Sale Id shift 74',0.00,0.00,0.00,1415.75,0.00,'2022-07-15 18:27:24','',''),(1031,'22','242',NULL,2,'Sale Id shift 74',1938912.00,0.00,0.00,0.00,0.00,'2022-07-15 18:27:24','',''),(1032,'22','242',NULL,1,'Sale Id shift 74',2053508.88,0.00,0.00,0.00,0.00,'2022-07-15 18:27:24','',''),(1033,'22','242','1',1,'Sale Id shift 75',0.00,0.00,0.00,737.19,0.00,'2022-07-15 18:34:06','',''),(1034,'22','242','2',1,'Sale Id shift 75',0.00,0.00,0.00,20.01,0.00,'2022-07-15 18:34:06','',''),(1035,'22','242','1',1,'Sale Id shift 75',0.00,0.00,0.00,1378.03,0.00,'2022-07-15 18:34:06','',''),(1036,'22','242','2',1,'Sale Id shift 75',0.00,0.00,0.00,634.21,0.00,'2022-07-15 18:34:06','',''),(1037,'22','242','2',1,'Sale Id shift 75',0.00,0.00,0.00,530.05,0.00,'2022-07-15 18:34:06','',''),(1038,'22','242','3',2,'Sale Id shift 75',0.00,0.00,0.00,1334.72,0.00,'2022-07-15 18:34:06','',''),(1039,'22','242','3',2,'Sale Id shift 75',0.00,0.00,0.00,1274.97,0.00,'2022-07-15 18:34:06','',''),(1040,'22','242','4',2,'Sale Id shift 75',0.00,0.00,0.00,470.00,0.00,'2022-07-15 18:34:06','',''),(1041,'22','242','1',1,'Sale Id shift 75',0.00,0.00,0.00,1090.00,0.00,'2022-07-15 18:34:06','',''),(1042,'22','242','1',1,'Sale Id shift 75',0.00,0.00,0.00,1288.63,0.00,'2022-07-15 18:34:06','',''),(1043,'22','242','1',1,'Sale Id shift 75',0.00,0.00,0.00,418.59,0.00,'2022-07-15 18:34:06','',''),(1044,'22','242',NULL,2,'Sale Id shift 75',2340564.40,0.00,0.00,0.00,0.00,'2022-07-15 18:34:06','',''),(1045,'22','242',NULL,1,'Sale Id shift 75',902313.08,0.00,0.00,0.00,0.00,'2022-07-15 18:34:06','',''),(1046,'22','242','1',1,'Sale Id shift 76',0.00,0.00,0.00,805.73,0.00,'2022-07-15 21:08:49','',''),(1047,'22','242','2',1,'Sale Id shift 76',0.00,0.00,0.00,466.76,0.00,'2022-07-15 21:08:49','',''),(1048,'22','242','1',1,'Sale Id shift 76',0.00,0.00,0.00,867.96,0.00,'2022-07-15 21:08:49','',''),(1049,'22','242','2',1,'Sale Id shift 76',0.00,0.00,0.00,366.36,0.00,'2022-07-15 21:08:49','',''),(1050,'22','242','2',1,'Sale Id shift 76',0.00,0.00,0.00,367.03,0.00,'2022-07-15 21:08:49','',''),(1051,'22','242','2',1,'Sale Id shift 76',0.00,0.00,0.00,297.09,0.00,'2022-07-15 21:08:49','',''),(1052,'22','242','3',2,'Sale Id shift 76',0.00,0.00,0.00,1151.09,0.00,'2022-07-15 21:08:49','',''),(1053,'22','242','3',2,'Sale Id shift 76',0.00,0.00,0.00,1284.47,0.00,'2022-07-15 21:08:49','',''),(1054,'22','242','4',2,'Sale Id shift 76',0.00,0.00,0.00,2099.99,0.00,'2022-07-15 21:08:49','',''),(1055,'22','242','1',1,'Sale Id shift 76',0.00,0.00,0.00,399.76,0.00,'2022-07-15 21:08:49','',''),(1056,'22','242','1',1,'Sale Id shift 76',0.00,0.00,0.00,350.70,0.00,'2022-07-15 21:08:49','',''),(1057,'22','242','1',1,'Sale Id shift 76',0.00,0.00,0.00,557.11,0.00,'2022-07-15 21:08:49','',''),(1058,'22','242',NULL,2,'Sale Id shift 76',3447018.00,0.00,0.00,0.00,0.00,'2022-07-15 21:08:49','',''),(1059,'22','242',NULL,1,'Sale Id shift 76',662818.00,0.00,0.00,0.00,0.00,'2022-07-15 21:08:49','',''),(1060,'22','242','1',1,'Sale Id shift 77',0.00,0.00,0.00,752.77,0.00,'2022-07-17 08:00:56','',''),(1061,'22','242','2',1,'Sale Id shift 77',0.00,0.00,0.00,637.35,0.00,'2022-07-17 08:00:56','',''),(1062,'22','242','1',1,'Sale Id shift 77',0.00,0.00,0.00,1158.09,0.00,'2022-07-17 08:00:56','',''),(1063,'22','242','2',1,'Sale Id shift 77',0.00,0.00,0.00,711.05,0.00,'2022-07-17 08:00:56','',''),(1064,'22','242','2',1,'Sale Id shift 77',0.00,0.00,0.00,702.95,0.00,'2022-07-17 08:00:56','',''),(1065,'22','242','2',1,'Sale Id shift 77',0.00,0.00,0.00,774.17,0.00,'2022-07-17 08:00:56','',''),(1066,'22','242','3',2,'Sale Id shift 77',0.00,0.00,0.00,654.76,0.00,'2022-07-17 08:00:56','',''),(1067,'22','242','3',2,'Sale Id shift 77',0.00,0.00,0.00,814.24,0.00,'2022-07-17 08:00:56','',''),(1068,'22','242','4',2,'Sale Id shift 77',0.00,0.00,0.00,1876.75,0.00,'2022-07-17 08:00:56','',''),(1069,'22','242','1',1,'Sale Id shift 77',0.00,0.00,0.00,745.94,0.00,'2022-07-17 08:00:56','',''),(1070,'22','242','1',1,'Sale Id shift 77',0.00,0.00,0.00,854.90,0.00,'2022-07-17 08:00:56','',''),(1071,'22','242','1',1,'Sale Id shift 77',0.00,0.00,0.00,987.23,0.00,'2022-07-17 08:00:56','',''),(1072,'22','242',NULL,2,'Sale Id shift 77',2542770.00,0.00,0.00,0.00,0.00,'2022-07-17 08:00:56','',''),(1073,'22','242',NULL,1,'Sale Id shift 77',1084018.60,0.00,0.00,0.00,0.00,'2022-07-17 08:00:56','',''),(1074,'22','242','1',1,'Sale Id shift 78',0.00,0.00,0.00,771.12,0.00,'2022-07-17 18:54:06','',''),(1075,'22','242','2',1,'Sale Id shift 78',0.00,0.00,0.00,316.34,0.00,'2022-07-17 18:54:06','',''),(1076,'22','242','1',1,'Sale Id shift 78',0.00,0.00,0.00,935.09,0.00,'2022-07-17 18:54:06','',''),(1077,'22','242','2',1,'Sale Id shift 78',0.00,0.00,0.00,1353.65,0.00,'2022-07-17 18:54:06','',''),(1078,'22','242','3',2,'Sale Id shift 78',0.00,0.00,0.00,477.57,0.00,'2022-07-17 18:54:06','',''),(1079,'22','242','3',2,'Sale Id shift 78',0.00,0.00,0.00,65.32,0.00,'2022-07-17 18:54:06','',''),(1080,'22','242','4',2,'Sale Id shift 78',0.00,0.00,0.00,600.00,0.00,'2022-07-17 18:54:06','',''),(1081,'22','242','1',1,'Sale Id shift 78',0.00,0.00,0.00,587.78,0.00,'2022-07-17 18:54:06','',''),(1082,'22','242','1',1,'Sale Id shift 78',0.00,0.00,0.00,1115.17,0.00,'2022-07-17 18:54:06','',''),(1083,'22','242','1',1,'Sale Id shift 78',0.00,0.00,0.00,460.05,0.00,'2022-07-17 18:54:06','',''),(1084,'22','242',NULL,2,'Sale Id shift 78',868596.40,0.00,0.00,0.00,0.00,'2022-07-17 18:54:06','',''),(1085,'22','242',NULL,1,'Sale Id shift 78',819801.60,0.00,0.00,0.00,0.00,'2022-07-17 18:54:06','',''),(1086,'22','242','1',1,'Sale Id shift 79',0.00,0.00,0.00,556.33,0.00,'2022-07-18 21:57:40','',''),(1087,'22','242','2',1,'Sale Id shift 79',0.00,0.00,0.00,1305.56,0.00,'2022-07-18 21:57:40','',''),(1088,'22','242','1',1,'Sale Id shift 79',0.00,0.00,0.00,454.98,0.00,'2022-07-18 21:57:40','',''),(1089,'22','242','2',1,'Sale Id shift 79',0.00,0.00,0.00,1032.44,0.00,'2022-07-18 21:57:40','',''),(1090,'22','242','2',1,'Sale Id shift 79',0.00,0.00,0.00,293.01,0.00,'2022-07-18 21:57:40','',''),(1091,'22','242','2',1,'Sale Id shift 79',0.00,0.00,0.00,177.50,0.00,'2022-07-18 21:57:40','',''),(1092,'22','242','3',2,'Sale Id shift 79',0.00,0.00,0.00,2379.94,0.00,'2022-07-18 21:57:40','',''),(1093,'22','242','3',2,'Sale Id shift 79',0.00,0.00,0.00,508.36,0.00,'2022-07-18 21:57:40','',''),(1094,'22','242','4',2,'Sale Id shift 79',0.00,0.00,0.00,180.00,0.00,'2022-07-18 21:57:40','',''),(1095,'22','242','1',1,'Sale Id shift 79',0.00,0.00,0.00,753.35,0.00,'2022-07-18 21:57:40','',''),(1096,'22','242','1',1,'Sale Id shift 79',0.00,0.00,0.00,1088.77,0.00,'2022-07-18 21:57:40','',''),(1097,'22','242','1',1,'Sale Id shift 79',0.00,0.00,0.00,578.91,0.00,'2022-07-18 21:57:40','',''),(1098,'22','242',NULL,2,'Sale Id shift 79',2331908.00,0.00,0.00,0.00,0.00,'2022-07-18 21:57:40','',''),(1099,'22','242',NULL,1,'Sale Id shift 79',923645.80,0.00,0.00,0.00,0.00,'2022-07-18 21:57:40','',''),(1100,'22','242',NULL,1,'Purchased from PINNACLE OIL & GAS LIMITED ',0.00,6660000.00,45000.00,0.00,0.00,'2022-07-19 15:48:07','',''),(1101,'22','242',NULL,1,'Reception corrector for bridging 56',0.00,0.00,0.00,15000.00,0.00,'2022-07-19 15:52:35','',''),(1102,'22','242','2',1,'Received from bridging 56',0.00,0.00,15000.00,0.00,0.00,'2022-07-19 15:52:35','',''),(1103,'22','242',NULL,1,'Reception corrector for bridging 55',0.00,0.00,0.00,30000.00,0.00,'2022-07-19 15:52:50','',''),(1104,'22','242','1',1,'Received from bridging 55',0.00,0.00,30000.00,0.00,0.00,'2022-07-19 15:52:50','',''),(1105,'22','242',NULL,2,'Purchased from WOSBAB ENERGY SOLUTIONS NIG LT',0.00,30400000.00,40000.00,0.00,0.00,'2022-07-20 12:07:40','',''),(1106,'22','242',NULL,2,'Reception corrector for bridging 58',0.00,0.00,0.00,13500.00,0.00,'2022-07-20 12:09:09','',''),(1107,'22','242','4',2,'Received from bridging 58',0.00,0.00,13500.00,0.00,0.00,'2022-07-20 12:09:09','',''),(1108,'22','242',NULL,2,'Reception corrector for bridging 57',0.00,0.00,0.00,26500.00,0.00,'2022-07-20 12:09:31','',''),(1109,'22','242','3',2,'Received from bridging 57',0.00,0.00,26500.00,0.00,0.00,'2022-07-20 12:09:31','',''),(1110,'22','242','1',1,'Sale Id shift 80',0.00,0.00,0.00,800.48,0.00,'2022-07-20 12:17:28','',''),(1111,'22','242','2',1,'Sale Id shift 80',0.00,0.00,0.00,547.26,0.00,'2022-07-20 12:17:28','',''),(1112,'22','242','1',1,'Sale Id shift 80',0.00,0.00,0.00,1120.01,0.00,'2022-07-20 12:17:28','',''),(1113,'22','242','2',1,'Sale Id shift 80',0.00,0.00,0.00,781.53,0.00,'2022-07-20 12:17:28','',''),(1114,'22','242','2',1,'Sale Id shift 80',0.00,0.00,0.00,497.53,0.00,'2022-07-20 12:17:28','',''),(1115,'22','242','2',1,'Sale Id shift 80',0.00,0.00,0.00,342.88,0.00,'2022-07-20 12:17:28','',''),(1116,'22','242','3',2,'Sale Id shift 80',0.00,0.00,0.00,746.09,0.00,'2022-07-20 12:17:28','',''),(1117,'22','242','3',2,'Sale Id shift 80',0.00,0.00,0.00,1243.46,0.00,'2022-07-20 12:17:28','',''),(1118,'22','242','4',2,'Sale Id shift 80',0.00,0.00,0.00,180.00,0.00,'2022-07-20 12:17:28','',''),(1119,'22','242','1',1,'Sale Id shift 80',0.00,0.00,0.00,1029.21,0.00,'2022-07-20 12:17:28','',''),(1120,'22','242','1',1,'Sale Id shift 80',0.00,0.00,0.00,992.46,0.00,'2022-07-20 12:17:28','',''),(1121,'22','242','1',1,'Sale Id shift 80',0.00,0.00,0.00,702.33,0.00,'2022-07-20 12:17:28','',''),(1122,'22','242',NULL,2,'Sale Id shift 80',1648858.00,0.00,0.00,0.00,0.00,'2022-07-20 12:17:28','',''),(1123,'22','242',NULL,1,'Sale Id shift 80',1008426.12,0.00,0.00,0.00,0.00,'2022-07-20 12:17:28','',''),(1124,'22','242','1',1,'Sale Id shift 81',0.00,0.00,0.00,664.91,0.00,'2022-07-21 08:15:38','',''),(1125,'22','242','2',1,'Sale Id shift 81',0.00,0.00,0.00,1052.58,0.00,'2022-07-21 08:15:38','',''),(1126,'22','242','1',1,'Sale Id shift 81',0.00,0.00,0.00,1396.10,0.00,'2022-07-21 08:15:38','',''),(1127,'22','242','2',1,'Sale Id shift 81',0.00,0.00,0.00,174.14,0.00,'2022-07-21 08:15:38','',''),(1128,'22','242','2',1,'Sale Id shift 81',0.00,0.00,0.00,1179.05,0.00,'2022-07-21 08:15:38','',''),(1129,'22','242','2',1,'Sale Id shift 81',0.00,0.00,0.00,1109.59,0.00,'2022-07-21 08:15:38','',''),(1130,'22','242','3',2,'Sale Id shift 81',0.00,0.00,0.00,1522.81,0.00,'2022-07-21 08:15:38','',''),(1131,'22','242','3',2,'Sale Id shift 81',0.00,0.00,0.00,1298.22,0.00,'2022-07-21 08:15:38','',''),(1132,'22','242','4',2,'Sale Id shift 81',0.00,0.00,0.00,2089.08,0.00,'2022-07-21 08:15:38','',''),(1133,'22','242','1',1,'Sale Id shift 81',0.00,0.00,0.00,766.32,0.00,'2022-07-21 08:15:38','',''),(1134,'22','242','1',1,'Sale Id shift 81',0.00,0.00,0.00,959.97,0.00,'2022-07-21 08:15:38','',''),(1135,'22','242','1',1,'Sale Id shift 81',0.00,0.00,0.00,697.34,0.00,'2022-07-21 08:15:38','',''),(1136,'22','242',NULL,2,'Sale Id shift 81',3731683.60,0.00,0.00,0.00,0.00,'2022-07-21 08:15:38','',''),(1137,'22','242',NULL,1,'Sale Id shift 81',1184000.00,0.00,0.00,0.00,0.00,'2022-07-21 08:15:38','',''),(1138,'22','242','1',1,'Sale Id shift 82',0.00,0.00,0.00,878.85,0.00,'2022-07-23 11:47:11','',''),(1139,'22','242','2',1,'Sale Id shift 82',0.00,0.00,0.00,579.62,0.00,'2022-07-23 11:47:11','',''),(1140,'22','242','1',1,'Sale Id shift 82',0.00,0.00,0.00,570.88,0.00,'2022-07-23 11:47:11','',''),(1141,'22','242','2',1,'Sale Id shift 82',0.00,0.00,0.00,725.58,0.00,'2022-07-23 11:47:11','',''),(1142,'22','242','2',1,'Sale Id shift 82',0.00,0.00,0.00,612.09,0.00,'2022-07-23 11:47:11','',''),(1143,'22','242','2',1,'Sale Id shift 82',0.00,0.00,0.00,396.41,0.00,'2022-07-23 11:47:11','',''),(1144,'22','242','3',2,'Sale Id shift 82',0.00,0.00,0.00,989.02,0.00,'2022-07-23 11:47:11','',''),(1145,'22','242','3',2,'Sale Id shift 82',0.00,0.00,0.00,999.43,0.00,'2022-07-23 11:47:11','',''),(1146,'22','242','4',2,'Sale Id shift 82',0.00,0.00,0.00,1340.00,0.00,'2022-07-23 11:47:11','',''),(1147,'22','242','1',1,'Sale Id shift 82',0.00,0.00,0.00,759.05,0.00,'2022-07-23 11:47:11','',''),(1148,'22','242','1',1,'Sale Id shift 82',0.00,0.00,0.00,1129.59,0.00,'2022-07-23 11:47:11','',''),(1149,'22','242','1',1,'Sale Id shift 82',0.00,0.00,0.00,586.93,0.00,'2022-07-23 11:47:11','',''),(1150,'22','242',NULL,2,'Sale Id shift 82',2529622.00,0.00,0.00,0.00,0.00,'2022-07-23 11:47:11','',''),(1151,'22','242',NULL,1,'Sale Id shift 82',923372.00,0.00,0.00,0.00,0.00,'2022-07-23 11:47:11','',''),(1152,'22','242','1',1,'Sale Id shift 83',0.00,0.00,0.00,388.39,0.00,'2022-07-23 11:52:17','',''),(1153,'22','242','2',1,'Sale Id shift 83',0.00,0.00,0.00,861.64,0.00,'2022-07-23 11:52:17','',''),(1154,'22','242','1',1,'Sale Id shift 83',0.00,0.00,0.00,426.58,0.00,'2022-07-23 11:52:17','',''),(1155,'22','242','2',1,'Sale Id shift 83',0.00,0.00,0.00,1089.17,0.00,'2022-07-23 11:52:17','',''),(1156,'22','242','2',1,'Sale Id shift 83',0.00,0.00,0.00,523.38,0.00,'2022-07-23 11:52:17','',''),(1157,'22','242','2',1,'Sale Id shift 83',0.00,0.00,0.00,107.41,0.00,'2022-07-23 11:52:17','',''),(1158,'22','242','3',2,'Sale Id shift 83',0.00,0.00,0.00,1287.15,0.00,'2022-07-23 11:52:17','',''),(1159,'22','242','3',2,'Sale Id shift 83',0.00,0.00,0.00,734.99,0.00,'2022-07-23 11:52:17','',''),(1160,'22','242','4',2,'Sale Id shift 83',0.00,0.00,0.00,530.00,0.00,'2022-07-23 11:52:17','',''),(1161,'22','242','1',1,'Sale Id shift 83',0.00,0.00,0.00,1005.24,0.00,'2022-07-23 11:52:17','',''),(1162,'22','242','1',1,'Sale Id shift 83',0.00,0.00,0.00,1077.09,0.00,'2022-07-23 11:52:17','',''),(1163,'22','242','1',1,'Sale Id shift 83',0.00,0.00,0.00,462.01,0.00,'2022-07-23 11:52:17','',''),(1164,'22','242',NULL,2,'Sale Id shift 83',1939626.40,0.00,0.00,0.00,0.00,'2022-07-23 11:52:17','',''),(1165,'22','242',NULL,1,'Sale Id shift 83',879254.68,0.00,0.00,0.00,0.00,'2022-07-23 11:52:17','',''),(1166,'22','242','1',1,'Sale Id shift 84',0.00,0.00,0.00,646.51,0.00,'2022-07-23 21:30:19','',''),(1167,'22','242','2',1,'Sale Id shift 84',0.00,0.00,0.00,90.64,0.00,'2022-07-23 21:30:19','',''),(1168,'22','242','1',1,'Sale Id shift 84',0.00,0.00,0.00,612.48,0.00,'2022-07-23 21:30:19','',''),(1169,'22','242','2',1,'Sale Id shift 84',0.00,0.00,0.00,440.97,0.00,'2022-07-23 21:30:19','',''),(1170,'22','242','2',1,'Sale Id shift 84',0.00,0.00,0.00,479.15,0.00,'2022-07-23 21:30:19','',''),(1171,'22','242','2',1,'Sale Id shift 84',0.00,0.00,0.00,206.87,0.00,'2022-07-23 21:30:19','',''),(1172,'22','242','3',2,'Sale Id shift 84',0.00,0.00,0.00,574.43,0.00,'2022-07-23 21:30:19','',''),(1173,'22','242','3',2,'Sale Id shift 84',0.00,0.00,0.00,614.97,0.00,'2022-07-23 21:30:19','',''),(1174,'22','242','4',2,'Sale Id shift 84',0.00,0.00,0.00,1703.00,0.00,'2022-07-23 21:30:19','',''),(1175,'22','242','1',1,'Sale Id shift 84',0.00,0.00,0.00,934.56,0.00,'2022-07-23 21:30:19','',''),(1176,'22','242','1',1,'Sale Id shift 84',0.00,0.00,0.00,1006.97,0.00,'2022-07-23 21:30:19','',''),(1177,'22','242','1',1,'Sale Id shift 84',0.00,0.00,0.00,414.42,0.00,'2022-07-23 21:30:19','',''),(1178,'22','242',NULL,2,'Sale Id shift 84',2198224.00,0.00,0.00,0.00,0.00,'2022-07-23 21:30:19','',''),(1179,'22','242',NULL,1,'Sale Id shift 84',715220.36,0.00,0.00,0.00,0.00,'2022-07-23 21:30:19','',''),(1180,'22','242','1',1,'Sale Id shift 85',0.00,0.00,0.00,475.62,0.00,'2022-07-25 11:55:17','',''),(1181,'22','242','2',1,'Sale Id shift 85',0.00,0.00,0.00,436.45,0.00,'2022-07-25 11:55:17','',''),(1182,'22','242','1',1,'Sale Id shift 85',0.00,0.00,0.00,318.21,0.00,'2022-07-25 11:55:17','',''),(1183,'22','242','2',1,'Sale Id shift 85',0.00,0.00,0.00,191.80,0.00,'2022-07-25 11:55:17','',''),(1184,'22','242','2',1,'Sale Id shift 85',0.00,0.00,0.00,93.97,0.00,'2022-07-25 11:55:17','',''),(1185,'22','242','2',1,'Sale Id shift 85',0.00,0.00,0.00,228.77,0.00,'2022-07-25 11:55:17','',''),(1186,'22','242','3',2,'Sale Id shift 85',0.00,0.00,0.00,222.09,0.00,'2022-07-25 11:55:17','',''),(1187,'22','242','3',2,'Sale Id shift 85',0.00,0.00,0.00,64.16,0.00,'2022-07-25 11:55:17','',''),(1188,'22','242','4',2,'Sale Id shift 85',0.00,0.00,0.00,200.00,0.00,'2022-07-25 11:55:17','',''),(1189,'22','242','1',1,'Sale Id shift 85',0.00,0.00,0.00,39.31,0.00,'2022-07-25 11:55:17','',''),(1190,'22','242','1',1,'Sale Id shift 85',0.00,0.00,0.00,278.78,0.00,'2022-07-25 11:55:17','',''),(1191,'22','242','1',1,'Sale Id shift 85',0.00,0.00,0.00,499.89,0.00,'2022-07-25 11:55:17','',''),(1192,'22','242',NULL,2,'Sale Id shift 85',369550.00,0.00,0.00,0.00,0.00,'2022-07-25 11:55:17','',''),(1193,'22','242',NULL,1,'Sale Id shift 85',379294.40,0.00,0.00,0.00,0.00,'2022-07-25 11:55:17','',''),(1194,'22','242','1',1,'Sale Id shift 86',0.00,0.00,0.00,916.42,0.00,'2022-07-26 10:05:43','',''),(1195,'22','242','2',1,'Sale Id shift 86',0.00,0.00,0.00,596.38,0.00,'2022-07-26 10:05:43','',''),(1196,'22','242','1',1,'Sale Id shift 86',0.00,0.00,0.00,522.62,0.00,'2022-07-26 10:05:43','',''),(1197,'22','242','2',1,'Sale Id shift 86',0.00,0.00,0.00,528.11,0.00,'2022-07-26 10:05:43','',''),(1198,'22','242','2',1,'Sale Id shift 86',0.00,0.00,0.00,424.34,0.00,'2022-07-26 10:05:43','',''),(1199,'22','242','2',1,'Sale Id shift 86',0.00,0.00,0.00,241.70,0.00,'2022-07-26 10:05:43','',''),(1200,'22','242','3',2,'Sale Id shift 86',0.00,0.00,0.00,1072.12,0.00,'2022-07-26 10:05:43','',''),(1201,'22','242','3',2,'Sale Id shift 86',0.00,0.00,0.00,1061.78,0.00,'2022-07-26 10:05:43','',''),(1202,'22','242','4',2,'Sale Id shift 86',0.00,0.00,0.00,2000.66,0.00,'2022-07-26 10:05:43','',''),(1203,'22','242','1',1,'Sale Id shift 86',0.00,0.00,0.00,862.46,0.00,'2022-07-26 10:05:43','',''),(1204,'22','242','1',1,'Sale Id shift 86',0.00,0.00,0.00,1186.38,0.00,'2022-07-26 10:05:43','',''),(1205,'22','242','1',1,'Sale Id shift 86',0.00,0.00,0.00,924.58,0.00,'2022-07-26 10:05:43','',''),(1206,'22','242',NULL,2,'Sale Id shift 86',3142265.60,0.00,0.00,0.00,0.00,'2022-07-26 10:05:43','',''),(1207,'22','242',NULL,1,'Sale Id shift 86',918042.52,0.00,0.00,0.00,0.00,'2022-07-26 10:05:43','',''),(1208,'22','242','1',1,'Sale Id shift 87',0.00,0.00,0.00,515.66,0.00,'2022-07-27 11:47:40','',''),(1209,'22','242','2',1,'Sale Id shift 87',0.00,0.00,0.00,764.88,0.00,'2022-07-27 11:47:40','',''),(1210,'22','242','1',1,'Sale Id shift 87',0.00,0.00,0.00,331.45,0.00,'2022-07-27 11:47:40','',''),(1211,'22','242','2',1,'Sale Id shift 87',0.00,0.00,0.00,534.48,0.00,'2022-07-27 11:47:40','',''),(1212,'22','242','2',1,'Sale Id shift 87',0.00,0.00,0.00,509.61,0.00,'2022-07-27 11:47:40','',''),(1213,'22','242','2',1,'Sale Id shift 87',0.00,0.00,0.00,196.76,0.00,'2022-07-27 11:47:40','',''),(1214,'22','242','3',2,'Sale Id shift 87',0.00,0.00,0.00,996.30,0.00,'2022-07-27 11:47:40','',''),(1215,'22','242','3',2,'Sale Id shift 87',0.00,0.00,0.00,835.68,0.00,'2022-07-27 11:47:40','',''),(1216,'22','242','4',2,'Sale Id shift 87',0.00,0.00,0.00,1200.00,0.00,'2022-07-27 11:47:40','',''),(1217,'22','242','1',1,'Sale Id shift 87',0.00,0.00,0.00,1218.64,0.00,'2022-07-27 11:47:40','',''),(1218,'22','242','1',1,'Sale Id shift 87',0.00,0.00,0.00,1394.61,0.00,'2022-07-27 11:47:40','',''),(1219,'22','242','1',1,'Sale Id shift 87',0.00,0.00,0.00,530.10,0.00,'2022-07-27 11:47:40','',''),(1220,'22','242',NULL,2,'Sale Id shift 87',2304304.80,0.00,0.00,0.00,0.00,'2022-07-27 11:47:40','',''),(1221,'22','242',NULL,1,'Sale Id shift 87',887436.12,0.00,0.00,0.00,0.00,'2022-07-27 11:47:40','',''),(1222,'22','242','1',1,'Sale Id shift 88',0.00,0.00,0.00,732.47,0.00,'2022-07-28 14:33:36','',''),(1223,'22','242','2',1,'Sale Id shift 88',0.00,0.00,0.00,312.90,0.00,'2022-07-28 14:33:36','',''),(1224,'22','242','1',1,'Sale Id shift 88',0.00,0.00,0.00,281.96,0.00,'2022-07-28 14:33:36','',''),(1225,'22','242','2',1,'Sale Id shift 88',0.00,0.00,0.00,484.81,0.00,'2022-07-28 14:33:36','',''),(1226,'22','242','2',1,'Sale Id shift 88',0.00,0.00,0.00,458.51,0.00,'2022-07-28 14:33:36','',''),(1227,'22','242','2',1,'Sale Id shift 88',0.00,0.00,0.00,632.99,0.00,'2022-07-28 14:33:36','',''),(1228,'22','242','3',2,'Sale Id shift 88',0.00,0.00,0.00,528.63,0.00,'2022-07-28 14:33:36','',''),(1229,'22','242','3',2,'Sale Id shift 88',0.00,0.00,0.00,1029.36,0.00,'2022-07-28 14:33:36','',''),(1230,'22','242','4',2,'Sale Id shift 88',0.00,0.00,0.00,917.00,0.00,'2022-07-28 14:33:36','',''),(1231,'22','242','1',1,'Sale Id shift 88',0.00,0.00,0.00,849.96,0.00,'2022-07-28 14:33:36','',''),(1232,'22','242','1',1,'Sale Id shift 88',0.00,0.00,0.00,732.13,0.00,'2022-07-28 14:33:36','',''),(1233,'22','242','1',1,'Sale Id shift 88',0.00,0.00,0.00,737.62,0.00,'2022-07-28 14:33:36','',''),(1234,'22','242',NULL,2,'Sale Id shift 88',1880992.40,0.00,0.00,0.00,0.00,'2022-07-28 14:33:36','',''),(1235,'22','242',NULL,1,'Sale Id shift 88',773055.80,0.00,0.00,0.00,0.00,'2022-07-28 14:33:36','',''),(1236,'22','242',NULL,1,'Purchased from PINNACLE OIL & GAS LIMITED ',0.00,5920000.00,40000.00,0.00,0.00,'2022-07-29 12:17:05','',''),(1237,'22','242',NULL,1,'Reception corrector for bridging 61',0.00,0.00,0.00,40000.00,0.00,'2022-07-29 12:23:06','',''),(1238,'22','242','2',1,'Received from bridging 61',0.00,0.00,40000.00,0.00,0.00,'2022-07-29 12:23:06','',''),(1239,'22','242',NULL,1,'Reception corrector for bridging 60',0.00,0.00,0.00,10000.00,0.00,'2022-07-29 12:23:22','',''),(1240,'22','242','1',1,'Received from bridging 60',0.00,0.00,10000.00,0.00,0.00,'2022-07-29 12:23:22','',''),(1241,'22','242','1',1,'Sale Id shift 89',0.00,0.00,0.00,1871.43,0.00,'2022-07-29 12:26:20','',''),(1242,'22','242','2',1,'Sale Id shift 89',0.00,0.00,0.00,695.83,0.00,'2022-07-29 12:26:20','',''),(1243,'22','242','1',1,'Sale Id shift 89',0.00,0.00,0.00,1251.06,0.00,'2022-07-29 12:26:20','',''),(1244,'22','242','2',1,'Sale Id shift 89',0.00,0.00,0.00,992.52,0.00,'2022-07-29 12:26:20','',''),(1245,'22','242','3',2,'Sale Id shift 89',0.00,0.00,0.00,874.22,0.00,'2022-07-29 12:26:20','',''),(1246,'22','242','3',2,'Sale Id shift 89',0.00,0.00,0.00,1011.96,0.00,'2022-07-29 12:26:20','',''),(1247,'22','242','4',2,'Sale Id shift 89',0.00,0.00,0.00,185.00,0.00,'2022-07-29 12:26:20','',''),(1248,'22','242','1',1,'Sale Id shift 89',0.00,0.00,0.00,824.20,0.00,'2022-07-29 12:26:20','',''),(1249,'22','242','1',1,'Sale Id shift 89',0.00,0.00,0.00,922.59,0.00,'2022-07-29 12:26:20','',''),(1250,'22','242','1',1,'Sale Id shift 89',0.00,0.00,0.00,1274.83,0.00,'2022-07-29 12:26:20','',''),(1251,'22','242',NULL,2,'Sale Id shift 89',1574096.80,0.00,0.00,0.00,0.00,'2022-07-29 12:26:20','',''),(1252,'22','242',NULL,1,'Sale Id shift 89',1159204.08,0.00,0.00,0.00,0.00,'2022-07-29 12:26:20','',''),(1253,'22','242','1',1,'Sale Id shift 90',0.00,0.00,0.00,1157.27,0.00,'2022-07-30 09:20:09','',''),(1254,'22','242','2',1,'Sale Id shift 90',0.00,0.00,0.00,1176.95,0.00,'2022-07-30 09:20:09','',''),(1255,'22','242','1',1,'Sale Id shift 90',0.00,0.00,0.00,610.19,0.00,'2022-07-30 09:20:09','',''),(1256,'22','242','2',1,'Sale Id shift 90',0.00,0.00,0.00,286.36,0.00,'2022-07-30 09:20:09','',''),(1257,'22','242','2',1,'Sale Id shift 90',0.00,0.00,0.00,777.65,0.00,'2022-07-30 09:20:09','',''),(1258,'22','242','2',1,'Sale Id shift 90',0.00,0.00,0.00,1236.49,0.00,'2022-07-30 09:20:09','',''),(1259,'22','242','3',2,'Sale Id shift 90',0.00,0.00,0.00,669.68,0.00,'2022-07-30 09:20:09','',''),(1260,'22','242','3',2,'Sale Id shift 90',0.00,0.00,0.00,1039.88,0.00,'2022-07-30 09:20:09','',''),(1261,'22','242','4',2,'Sale Id shift 90',0.00,0.00,0.00,980.00,0.00,'2022-07-30 09:20:09','',''),(1262,'22','242','1',1,'Sale Id shift 90',0.00,0.00,0.00,1280.25,0.00,'2022-07-30 09:20:09','',''),(1263,'22','242','1',1,'Sale Id shift 90',0.00,0.00,0.00,1142.77,0.00,'2022-07-30 09:20:09','',''),(1264,'22','242','1',1,'Sale Id shift 90',0.00,0.00,0.00,1172.93,0.00,'2022-07-30 09:20:09','',''),(1265,'22','242',NULL,2,'Sale Id shift 90',2044065.60,0.00,0.00,0.00,0.00,'2022-07-30 09:20:09','',''),(1266,'22','242',NULL,1,'Sale Id shift 90',1308447.28,0.00,0.00,0.00,0.00,'2022-07-30 09:20:09','',''),(1267,'22','242',NULL,1,'Purchased from PINNACLE OIL & GAS LIMITED ',0.00,5920000.00,40000.00,0.00,0.00,'2022-07-30 22:17:37','',''),(1268,'22','242',NULL,1,'Reception corrector for bridging 62',0.00,0.00,0.00,30000.00,0.00,'2022-07-30 22:20:01','',''),(1269,'22','242','1',1,'Received from bridging 62',0.00,0.00,30000.00,0.00,0.00,'2022-07-30 22:20:01','',''),(1270,'22','242',NULL,1,'Reception corrector for bridging 64',0.00,0.00,0.00,10000.00,0.00,'2022-07-30 22:23:37','',''),(1271,'22','242','1',1,'Received from bridging 64',0.00,0.00,10000.00,0.00,0.00,'2022-07-30 22:23:37','',''),(1272,'22','242','1',1,'Sale Id shift 91',0.00,0.00,0.00,760.12,0.00,'2022-07-31 09:18:15','',''),(1273,'22','242','2',1,'Sale Id shift 91',0.00,0.00,0.00,2699.82,0.00,'2022-07-31 09:18:15','',''),(1274,'22','242','1',1,'Sale Id shift 91',0.00,0.00,0.00,953.76,0.00,'2022-07-31 09:18:15','',''),(1275,'22','242','2',1,'Sale Id shift 91',0.00,0.00,0.00,2026.65,0.00,'2022-07-31 09:18:15','',''),(1276,'22','242','2',1,'Sale Id shift 91',0.00,0.00,0.00,1181.19,0.00,'2022-07-31 09:18:15','',''),(1277,'22','242','2',1,'Sale Id shift 91',0.00,0.00,0.00,996.76,0.00,'2022-07-31 09:18:15','',''),(1278,'22','242','3',2,'Sale Id shift 91',0.00,0.00,0.00,485.63,0.00,'2022-07-31 09:18:15','',''),(1279,'22','242','3',2,'Sale Id shift 91',0.00,0.00,0.00,628.51,0.00,'2022-07-31 09:18:15','',''),(1280,'22','242','4',2,'Sale Id shift 91',0.00,0.00,0.00,742.00,0.00,'2022-07-31 09:18:15','',''),(1281,'22','242','1',1,'Sale Id shift 91',0.00,0.00,0.00,2405.89,0.00,'2022-07-31 09:18:15','',''),(1282,'22','242','1',1,'Sale Id shift 91',0.00,0.00,0.00,1046.19,0.00,'2022-07-31 09:18:15','',''),(1283,'22','242','1',1,'Sale Id shift 91',0.00,0.00,0.00,948.61,0.00,'2022-07-31 09:18:15','',''),(1284,'22','242',NULL,2,'Sale Id shift 91',1410666.40,0.00,0.00,0.00,0.00,'2022-07-31 09:18:15','',''),(1285,'22','242',NULL,1,'Sale Id shift 91',1926810.52,0.00,0.00,0.00,0.00,'2022-07-31 09:18:15','',''),(1286,'22','242','1',1,'Sale Id shift 92',0.00,0.00,0.00,378.76,0.00,'2022-08-01 13:08:42','',''),(1287,'22','242','2',1,'Sale Id shift 92',0.00,0.00,0.00,1948.35,0.00,'2022-08-01 13:08:42','',''),(1288,'22','242','1',1,'Sale Id shift 92',0.00,0.00,0.00,497.23,0.00,'2022-08-01 13:08:42','',''),(1289,'22','242','2',1,'Sale Id shift 92',0.00,0.00,0.00,338.99,0.00,'2022-08-01 13:08:42','',''),(1290,'22','242','2',1,'Sale Id shift 92',0.00,0.00,0.00,219.80,0.00,'2022-08-01 13:08:42','',''),(1291,'22','242','3',2,'Sale Id shift 92',0.00,0.00,0.00,141.14,0.00,'2022-08-01 13:08:42','',''),(1292,'22','242','3',2,'Sale Id shift 92',0.00,0.00,0.00,301.49,0.00,'2022-08-01 13:08:42','',''),(1293,'22','242','4',2,'Sale Id shift 92',0.00,0.00,0.00,130.00,0.00,'2022-08-01 13:08:42','',''),(1294,'22','242','1',1,'Sale Id shift 92',0.00,0.00,0.00,423.80,0.00,'2022-08-01 13:08:42','',''),(1295,'22','242','1',1,'Sale Id shift 92',0.00,0.00,0.00,904.74,0.00,'2022-08-01 13:08:42','',''),(1296,'22','242','1',1,'Sale Id shift 92',0.00,0.00,0.00,663.07,0.00,'2022-08-01 13:08:42','',''),(1297,'22','242',NULL,2,'Sale Id shift 92',435198.80,0.00,0.00,0.00,0.00,'2022-08-01 13:08:42','',''),(1298,'22','242',NULL,1,'Sale Id shift 92',795461.52,0.00,0.00,0.00,0.00,'2022-08-01 13:08:42','',''),(1299,'22','242','1',1,'Sale Id shift 93',0.00,0.00,0.00,1479.75,0.00,'2022-08-01 21:24:50','',''),(1300,'22','242','2',1,'Sale Id shift 93',0.00,0.00,0.00,754.62,0.00,'2022-08-01 21:24:50','',''),(1301,'22','242','1',1,'Sale Id shift 93',0.00,0.00,0.00,1484.82,0.00,'2022-08-01 21:24:50','',''),(1302,'22','242','2',1,'Sale Id shift 93',0.00,0.00,0.00,767.22,0.00,'2022-08-01 21:24:50','',''),(1303,'22','242','2',1,'Sale Id shift 93',0.00,0.00,0.00,765.05,0.00,'2022-08-01 21:24:50','',''),(1304,'22','242','2',1,'Sale Id shift 93',0.00,0.00,0.00,810.59,0.00,'2022-08-01 21:24:50','',''),(1305,'22','242','3',2,'Sale Id shift 93',0.00,0.00,0.00,717.91,0.00,'2022-08-01 21:24:50','',''),(1306,'22','242','3',2,'Sale Id shift 93',0.00,0.00,0.00,948.80,0.00,'2022-08-01 21:24:50','',''),(1307,'22','242','4',2,'Sale Id shift 93',0.00,0.00,0.00,680.00,0.00,'2022-08-01 21:24:50','',''),(1308,'22','242','1',1,'Sale Id shift 93',0.00,0.00,0.00,1171.20,0.00,'2022-08-01 21:24:50','',''),(1309,'22','242','1',1,'Sale Id shift 93',0.00,0.00,0.00,1357.25,0.00,'2022-08-01 21:24:50','',''),(1310,'22','242','1',1,'Sale Id shift 93',0.00,0.00,0.00,1178.77,0.00,'2022-08-01 21:24:50','',''),(1311,'22','242',NULL,2,'Sale Id shift 93',1783499.60,0.00,0.00,0.00,0.00,'2022-08-01 21:24:50','',''),(1312,'22','242',NULL,1,'Sale Id shift 93',1445851.96,0.00,0.00,0.00,0.00,'2022-08-01 21:24:50','',''),(1313,'22','242','1',1,'Sale Id shift 94',0.00,0.00,0.00,1387.98,0.00,'2022-08-03 09:38:20','',''),(1314,'22','242','2',1,'Sale Id shift 94',0.00,0.00,0.00,1068.68,0.00,'2022-08-03 09:38:20','',''),(1315,'22','242','1',1,'Sale Id shift 94',0.00,0.00,0.00,867.68,0.00,'2022-08-03 09:38:20','',''),(1316,'22','242','2',1,'Sale Id shift 94',0.00,0.00,0.00,1141.53,0.00,'2022-08-03 09:38:20','',''),(1317,'22','242','2',1,'Sale Id shift 94',0.00,0.00,0.00,955.12,0.00,'2022-08-03 09:38:20','',''),(1318,'22','242','2',1,'Sale Id shift 94',0.00,0.00,0.00,1050.06,0.00,'2022-08-03 09:38:20','',''),(1319,'22','242','3',2,'Sale Id shift 94',0.00,0.00,0.00,951.27,0.00,'2022-08-03 09:38:20','',''),(1320,'22','242','3',2,'Sale Id shift 94',0.00,0.00,0.00,780.71,0.00,'2022-08-03 09:38:20','',''),(1321,'22','242','4',2,'Sale Id shift 94',0.00,0.00,0.00,540.00,0.00,'2022-08-03 09:38:20','',''),(1322,'22','242','1',1,'Sale Id shift 94',0.00,0.00,0.00,1506.94,0.00,'2022-08-03 09:38:20','',''),(1323,'22','242','1',1,'Sale Id shift 94',0.00,0.00,0.00,878.84,0.00,'2022-08-03 09:38:20','',''),(1324,'22','242','1',1,'Sale Id shift 94',0.00,0.00,0.00,1131.34,0.00,'2022-08-03 09:38:20','',''),(1325,'22','242',NULL,2,'Sale Id shift 94',1726704.80,0.00,0.00,0.00,0.00,'2022-08-03 09:38:20','',''),(1326,'22','242',NULL,1,'Sale Id shift 94',1478249.16,0.00,0.00,0.00,0.00,'2022-08-03 09:38:20','',''),(1327,'22','242',NULL,2,'Purchased from NIPC0 PLC',0.00,34200000.00,45000.00,0.00,0.00,'2022-08-04 10:24:56','',''),(1328,'22','242',NULL,2,'Reception corrector for bridging 66',0.00,0.00,0.00,15000.00,0.00,'2022-08-04 10:26:13','',''),(1329,'22','242','4',2,'Received from bridging 66',0.00,0.00,15000.00,0.00,0.00,'2022-08-04 10:26:13','',''),(1330,'22','242',NULL,2,'Reception corrector for bridging 65',0.00,0.00,0.00,30000.00,0.00,'2022-08-04 10:26:25','',''),(1331,'22','242','3',2,'Received from bridging 65',0.00,0.00,30000.00,0.00,0.00,'2022-08-04 10:26:25','',''),(1332,'22','242','1',1,'Sale Id shift 95',0.00,0.00,0.00,790.09,0.00,'2022-08-04 10:39:40','',''),(1333,'22','242','2',1,'Sale Id shift 95',0.00,0.00,0.00,1831.92,0.00,'2022-08-04 10:39:40','',''),(1334,'22','242','1',1,'Sale Id shift 95',0.00,0.00,0.00,943.55,0.00,'2022-08-04 10:39:40','',''),(1335,'22','242','2',1,'Sale Id shift 95',0.00,0.00,0.00,2274.19,0.00,'2022-08-04 10:39:40','',''),(1336,'22','242','2',1,'Sale Id shift 95',0.00,0.00,0.00,855.68,0.00,'2022-08-04 10:39:40','',''),(1337,'22','242','2',1,'Sale Id shift 95',0.00,0.00,0.00,653.32,0.00,'2022-08-04 10:39:40','',''),(1338,'22','242','3',2,'Sale Id shift 95',0.00,0.00,0.00,851.58,0.00,'2022-08-04 10:39:40','',''),(1339,'22','242','3',2,'Sale Id shift 95',0.00,0.00,0.00,1169.25,0.00,'2022-08-04 10:39:40','',''),(1340,'22','242','4',2,'Sale Id shift 95',0.00,0.00,0.00,1200.00,0.00,'2022-08-04 10:39:40','',''),(1341,'22','242','1',1,'Sale Id shift 95',0.00,0.00,0.00,1410.72,0.00,'2022-08-04 10:39:40','',''),(1342,'22','242','1',1,'Sale Id shift 95',0.00,0.00,0.00,767.90,0.00,'2022-08-04 10:39:40','',''),(1343,'22','242','1',1,'Sale Id shift 95',0.00,0.00,0.00,928.02,0.00,'2022-08-04 10:39:40','',''),(1344,'22','242',NULL,2,'Sale Id shift 95',2447830.80,0.00,0.00,0.00,0.00,'2022-08-04 10:39:40','',''),(1345,'22','242',NULL,1,'Sale Id shift 95',1547397.72,0.00,0.00,0.00,0.00,'2022-08-04 10:39:40','',''),(1346,'22','242','1',1,'Sale Id shift 96',0.00,0.00,0.00,1362.81,0.00,'2022-08-06 07:50:58','',''),(1347,'22','242','1',1,'Sale Id shift 96',0.00,0.00,0.00,1345.39,0.00,'2022-08-06 07:50:58','',''),(1348,'22','242','2',1,'Sale Id shift 96',0.00,0.00,0.00,1707.12,0.00,'2022-08-06 07:50:58','',''),(1349,'22','242','2',1,'Sale Id shift 96',0.00,0.00,0.00,743.36,0.00,'2022-08-06 07:50:58','',''),(1350,'22','242','2',1,'Sale Id shift 96',0.00,0.00,0.00,882.42,0.00,'2022-08-06 07:50:58','',''),(1351,'22','242','3',2,'Sale Id shift 96',0.00,0.00,0.00,366.63,0.00,'2022-08-06 07:50:58','',''),(1352,'22','242','3',2,'Sale Id shift 96',0.00,0.00,0.00,631.58,0.00,'2022-08-06 07:50:58','',''),(1353,'22','242','4',2,'Sale Id shift 96',0.00,0.00,0.00,354.98,0.00,'2022-08-06 07:50:58','',''),(1354,'22','242','1',1,'Sale Id shift 96',0.00,0.00,0.00,1634.30,0.00,'2022-08-06 07:50:58','',''),(1355,'22','242','1',1,'Sale Id shift 96',0.00,0.00,0.00,1001.75,0.00,'2022-08-06 07:50:58','',''),(1356,'22','242','1',1,'Sale Id shift 96',0.00,0.00,0.00,1565.81,0.00,'2022-08-06 07:50:58','',''),(1357,'22','242',NULL,2,'Sale Id shift 96',1028424.40,0.00,0.00,0.00,0.00,'2022-08-06 07:50:58','',''),(1358,'22','242',NULL,1,'Sale Id shift 96',1515958.08,0.00,0.00,0.00,0.00,'2022-08-06 07:50:58','',''),(1359,'22','242','1',1,'Sale Id shift 97',0.00,0.00,0.00,785.55,0.00,'2022-08-06 07:56:09','',''),(1360,'22','242','2',1,'Sale Id shift 97',0.00,0.00,0.00,929.66,0.00,'2022-08-06 07:56:09','',''),(1361,'22','242','1',1,'Sale Id shift 97',0.00,0.00,0.00,1649.26,0.00,'2022-08-06 07:56:09','',''),(1362,'22','242','2',1,'Sale Id shift 97',0.00,0.00,0.00,1144.26,0.00,'2022-08-06 07:56:09','',''),(1363,'22','242','2',1,'Sale Id shift 97',0.00,0.00,0.00,809.94,0.00,'2022-08-06 07:56:09','',''),(1364,'22','242','2',1,'Sale Id shift 97',0.00,0.00,0.00,500.12,0.00,'2022-08-06 07:56:09','',''),(1365,'22','242','3',2,'Sale Id shift 97',0.00,0.00,0.00,576.29,0.00,'2022-08-06 07:56:09','',''),(1366,'22','242','3',2,'Sale Id shift 97',0.00,0.00,0.00,1285.54,0.00,'2022-08-06 07:56:09','',''),(1367,'22','242','4',2,'Sale Id shift 97',0.00,0.00,0.00,330.00,0.00,'2022-08-06 07:56:09','',''),(1368,'22','242','1',1,'Sale Id shift 97',0.00,0.00,0.00,1134.44,0.00,'2022-08-06 07:56:09','',''),(1369,'22','242','1',1,'Sale Id shift 97',0.00,0.00,0.00,1054.90,0.00,'2022-08-06 07:56:09','',''),(1370,'22','242','1',1,'Sale Id shift 97',0.00,0.00,0.00,710.07,0.00,'2022-08-06 07:56:09','',''),(1371,'22','242',NULL,2,'Sale Id shift 97',1665790.80,0.00,0.00,0.00,0.00,'2022-08-06 07:56:09','',''),(1372,'22','242',NULL,1,'Sale Id shift 97',1290293.60,0.00,0.00,0.00,0.00,'2022-08-06 07:56:09','',''),(1373,'22','242','1',1,'Sale Id shift 98',0.00,0.00,0.00,1099.63,0.00,'2022-08-07 07:36:22','',''),(1374,'22','242','2',1,'Sale Id shift 98',0.00,0.00,0.00,812.57,0.00,'2022-08-07 07:36:22','',''),(1375,'22','242','1',1,'Sale Id shift 98',0.00,0.00,0.00,939.75,0.00,'2022-08-07 07:36:22','',''),(1376,'22','242','2',1,'Sale Id shift 98',0.00,0.00,0.00,673.54,0.00,'2022-08-07 07:36:22','',''),(1377,'22','242','2',1,'Sale Id shift 98',0.00,0.00,0.00,733.53,0.00,'2022-08-07 07:36:22','',''),(1378,'22','242','3',2,'Sale Id shift 98',0.00,0.00,0.00,727.25,0.00,'2022-08-07 07:36:22','',''),(1379,'22','242','3',2,'Sale Id shift 98',0.00,0.00,0.00,469.05,0.00,'2022-08-07 07:36:22','',''),(1380,'22','242','4',2,'Sale Id shift 98',0.00,0.00,0.00,400.00,0.00,'2022-08-07 07:36:22','',''),(1381,'22','242','1',1,'Sale Id shift 98',0.00,0.00,0.00,1015.73,0.00,'2022-08-07 07:36:22','',''),(1382,'22','242','1',1,'Sale Id shift 98',0.00,0.00,0.00,1131.37,0.00,'2022-08-07 07:36:22','',''),(1383,'22','242','1',1,'Sale Id shift 98',0.00,0.00,0.00,831.64,0.00,'2022-08-07 07:36:22','',''),(1384,'22','242',NULL,2,'Sale Id shift 98',1213188.00,0.00,0.00,0.00,0.00,'2022-08-07 07:36:22','',''),(1385,'22','242',NULL,1,'Sale Id shift 98',1071188.48,0.00,0.00,0.00,0.00,'2022-08-07 07:36:22','',''),(1386,'22','242',NULL,1,'Purchased from NIPC0 PLC',0.00,6660000.00,45000.00,0.00,0.00,'2022-08-13 10:56:55','',''),(1387,'22','242',NULL,1,'Reception corrector for bridging 68',0.00,0.00,0.00,15000.00,0.00,'2022-08-13 10:58:22','',''),(1388,'22','242','2',1,'Received from bridging 68',0.00,0.00,15000.00,0.00,0.00,'2022-08-13 10:58:22','',''),(1389,'22','242',NULL,1,'Reception corrector for bridging 67',0.00,0.00,0.00,30000.00,0.00,'2022-08-13 10:58:38','',''),(1390,'22','242','1',1,'Received from bridging 67',0.00,0.00,30000.00,0.00,0.00,'2022-08-13 10:58:38','',''),(1391,'22','242','1',1,'Sale Id shift 99',0.00,0.00,0.00,712.90,0.00,'2022-08-13 11:03:12','',''),(1392,'22','242','2',1,'Sale Id shift 99',0.00,0.00,0.00,880.80,0.00,'2022-08-13 11:03:12','',''),(1393,'22','242','1',1,'Sale Id shift 99',0.00,0.00,0.00,291.43,0.00,'2022-08-13 11:03:12','',''),(1394,'22','242','2',1,'Sale Id shift 99',0.00,0.00,0.00,492.28,0.00,'2022-08-13 11:03:12','',''),(1395,'22','242','2',1,'Sale Id shift 99',0.00,0.00,0.00,362.06,0.00,'2022-08-13 11:03:12','',''),(1396,'22','242','2',1,'Sale Id shift 99',0.00,0.00,0.00,485.60,0.00,'2022-08-13 11:03:12','',''),(1397,'22','242','3',2,'Sale Id shift 99',0.00,0.00,0.00,215.76,0.00,'2022-08-13 11:03:12','',''),(1398,'22','242','3',2,'Sale Id shift 99',0.00,0.00,0.00,245.69,0.00,'2022-08-13 11:03:12','',''),(1399,'22','242','4',2,'Sale Id shift 99',0.00,0.00,0.00,700.00,0.00,'2022-08-13 11:03:12','',''),(1400,'22','242','1',1,'Sale Id shift 99',0.00,0.00,0.00,983.80,0.00,'2022-08-13 11:03:12','',''),(1401,'22','242','1',1,'Sale Id shift 99',0.00,0.00,0.00,478.61,0.00,'2022-08-13 11:03:12','',''),(1402,'22','242','1',1,'Sale Id shift 99',0.00,0.00,0.00,508.64,0.00,'2022-08-13 11:03:12','',''),(1403,'22','242',NULL,2,'Sale Id shift 99',882702.00,0.00,0.00,0.00,0.00,'2022-08-13 11:03:12','',''),(1404,'22','242',NULL,1,'Sale Id shift 99',769025.76,0.00,0.00,0.00,0.00,'2022-08-13 11:03:12','',''),(1405,'22','242','2',1,'Sale Id shift 100',0.00,0.00,0.00,2312.03,0.00,'2022-08-13 11:07:57','',''),(1406,'22','242','2',1,'Sale Id shift 100',0.00,0.00,0.00,1027.63,0.00,'2022-08-13 11:07:57','',''),(1407,'22','242','2',1,'Sale Id shift 100',0.00,0.00,0.00,1071.24,0.00,'2022-08-13 11:07:57','',''),(1408,'22','242','2',1,'Sale Id shift 100',0.00,0.00,0.00,1344.50,0.00,'2022-08-13 11:07:57','',''),(1409,'22','242','3',2,'Sale Id shift 100',0.00,0.00,0.00,836.55,0.00,'2022-08-13 11:07:57','',''),(1410,'22','242','3',2,'Sale Id shift 100',0.00,0.00,0.00,734.28,0.00,'2022-08-13 11:07:57','',''),(1411,'22','242','4',2,'Sale Id shift 100',0.00,0.00,0.00,365.00,0.00,'2022-08-13 11:07:57','',''),(1412,'22','242',NULL,2,'Sale Id shift 100',1471230.80,0.00,0.00,0.00,0.00,'2022-08-13 11:07:57','',''),(1413,'22','242',NULL,1,'Sale Id shift 100',851799.20,0.00,0.00,0.00,0.00,'2022-08-13 11:07:57','',''),(1414,'22','242','2',1,'Sale Id shift 101',0.00,0.00,0.00,15.00,0.00,'2022-08-13 11:20:14','',''),(1415,'22','242','3',2,'Sale Id shift 101',0.00,0.00,0.00,725.34,0.00,'2022-08-13 11:20:14','',''),(1416,'22','242','3',2,'Sale Id shift 101',0.00,0.00,0.00,755.49,0.00,'2022-08-13 11:20:14','',''),(1417,'22','242','4',2,'Sale Id shift 101',0.00,0.00,0.00,185.00,0.00,'2022-08-13 11:20:14','',''),(1418,'22','242',NULL,2,'Sale Id shift 101',1266030.80,0.00,0.00,0.00,0.00,'2022-08-13 11:20:14','',''),(1419,'22','242',NULL,1,'Sale Id shift 101',2220.00,0.00,0.00,0.00,0.00,'2022-08-13 11:20:14','',''),(1420,'22','242','2',1,'Sale Id shift 102',0.00,0.00,0.00,15.00,0.00,'2022-08-13 11:24:11','',''),(1421,'22','242','2',1,'Sale Id shift 102',0.00,0.00,0.00,41.42,0.00,'2022-08-13 11:24:11','',''),(1422,'22','242','3',2,'Sale Id shift 102',0.00,0.00,0.00,494.12,0.00,'2022-08-13 11:24:11','',''),(1423,'22','242','3',2,'Sale Id shift 102',0.00,0.00,0.00,817.45,0.00,'2022-08-13 11:24:11','',''),(1424,'22','242','4',2,'Sale Id shift 102',0.00,0.00,0.00,540.00,0.00,'2022-08-13 11:24:11','',''),(1425,'22','242',NULL,2,'Sale Id shift 102',1407193.20,0.00,0.00,0.00,0.00,'2022-08-13 11:24:11','',''),(1426,'22','242',NULL,1,'Sale Id shift 102',8350.16,0.00,0.00,0.00,0.00,'2022-08-13 11:24:11','',''),(1427,'22','242','2',1,'Sale Id shift 103',0.00,0.00,0.00,67.85,0.00,'2022-08-13 11:26:33','',''),(1428,'22','242','3',2,'Sale Id shift 103',0.00,0.00,0.00,485.79,0.00,'2022-08-13 11:26:33','',''),(1429,'22','242','3',2,'Sale Id shift 103',0.00,0.00,0.00,792.88,0.00,'2022-08-13 11:26:33','',''),(1430,'22','242','4',2,'Sale Id shift 103',0.00,0.00,0.00,1845.98,0.00,'2022-08-13 11:26:33','',''),(1431,'22','242',NULL,2,'Sale Id shift 103',2374734.00,0.00,0.00,0.00,0.00,'2022-08-13 11:26:33','',''),(1432,'22','242',NULL,1,'Sale Id shift 103',10041.80,0.00,0.00,0.00,0.00,'2022-08-13 11:26:33','',''),(1433,'22','242','1',1,'Sale Id shift 105',0.00,0.00,0.00,320.00,0.00,'2022-08-13 11:36:34','',''),(1434,'22','242','2',1,'Sale Id shift 105',0.00,0.00,0.00,362.23,0.00,'2022-08-13 11:36:34','',''),(1435,'22','242','1',1,'Sale Id shift 105',0.00,0.00,0.00,338.68,0.00,'2022-08-13 11:36:34','',''),(1436,'22','242','2',1,'Sale Id shift 105',0.00,0.00,0.00,472.52,0.00,'2022-08-13 11:36:34','',''),(1437,'22','242','2',1,'Sale Id shift 105',0.00,0.00,0.00,277.16,0.00,'2022-08-13 11:36:34','',''),(1438,'22','242','2',1,'Sale Id shift 105',0.00,0.00,0.00,260.97,0.00,'2022-08-13 11:36:34','',''),(1439,'22','242','3',2,'Sale Id shift 105',0.00,0.00,0.00,1223.62,0.00,'2022-08-13 11:36:34','',''),(1440,'22','242','3',2,'Sale Id shift 105',0.00,0.00,0.00,679.78,0.00,'2022-08-13 11:36:34','',''),(1441,'22','242','4',2,'Sale Id shift 105',0.00,0.00,0.00,570.00,0.00,'2022-08-13 11:36:34','',''),(1442,'22','242','1',1,'Sale Id shift 105',0.00,0.00,0.00,560.27,0.00,'2022-08-13 11:36:34','',''),(1443,'22','242','1',1,'Sale Id shift 105',0.00,0.00,0.00,403.32,0.00,'2022-08-13 11:36:34','',''),(1444,'22','242','1',1,'Sale Id shift 105',0.00,0.00,0.00,397.77,0.00,'2022-08-13 11:36:34','',''),(1445,'22','242',NULL,2,'Sale Id shift 105',1879784.00,0.00,0.00,0.00,0.00,'2022-08-13 11:36:34','',''),(1446,'22','242',NULL,1,'Sale Id shift 105',502152.16,0.00,0.00,0.00,0.00,'2022-08-13 11:36:34','',''),(1447,'22','242','1',1,'Sale Id shift 106',0.00,0.00,0.00,898.45,0.00,'2022-08-13 22:01:49','',''),(1448,'22','242','2',1,'Sale Id shift 106',0.00,0.00,0.00,1177.38,0.00,'2022-08-13 22:01:49','',''),(1449,'22','242','2',1,'Sale Id shift 106',0.00,0.00,0.00,489.62,0.00,'2022-08-13 22:01:49','',''),(1450,'22','242','2',1,'Sale Id shift 106',0.00,0.00,0.00,355.52,0.00,'2022-08-13 22:01:49','',''),(1451,'22','242','3',2,'Sale Id shift 106',0.00,0.00,0.00,719.02,0.00,'2022-08-13 22:01:49','',''),(1452,'22','242','3',2,'Sale Id shift 106',0.00,0.00,0.00,686.74,0.00,'2022-08-13 22:01:49','',''),(1453,'22','242','4',2,'Sale Id shift 106',0.00,0.00,0.00,600.00,0.00,'2022-08-13 22:01:49','',''),(1454,'22','242','1',1,'Sale Id shift 106',0.00,0.00,0.00,1042.62,0.00,'2022-08-13 22:01:49','',''),(1455,'22','242','1',1,'Sale Id shift 106',0.00,0.00,0.00,541.81,0.00,'2022-08-13 22:01:49','',''),(1456,'22','242','1',1,'Sale Id shift 106',0.00,0.00,0.00,778.64,0.00,'2022-08-13 22:01:49','',''),(1457,'22','242',NULL,2,'Sale Id shift 106',1524377.60,0.00,0.00,0.00,0.00,'2022-08-13 22:01:49','',''),(1458,'22','242',NULL,1,'Sale Id shift 106',782037.92,0.00,0.00,0.00,0.00,'2022-08-13 22:01:49','',''),(1459,'22','242','1',1,'Sale Id shift 107',0.00,0.00,0.00,632.35,0.00,'2022-08-15 09:19:50','',''),(1460,'22','242','2',1,'Sale Id shift 107',0.00,0.00,0.00,736.90,0.00,'2022-08-15 09:19:50','',''),(1461,'22','242','1',1,'Sale Id shift 107',0.00,0.00,0.00,234.18,0.00,'2022-08-15 09:19:50','',''),(1462,'22','242','2',1,'Sale Id shift 107',0.00,0.00,0.00,419.07,0.00,'2022-08-15 09:19:50','',''),(1463,'22','242','2',1,'Sale Id shift 107',0.00,0.00,0.00,301.89,0.00,'2022-08-15 09:19:50','',''),(1464,'22','242','2',1,'Sale Id shift 107',0.00,0.00,0.00,180.52,0.00,'2022-08-15 09:19:50','',''),(1465,'22','242','3',2,'Sale Id shift 107',0.00,0.00,0.00,241.17,0.00,'2022-08-15 09:19:50','',''),(1466,'22','242','3',2,'Sale Id shift 107',0.00,0.00,0.00,309.98,0.00,'2022-08-15 09:19:50','',''),(1467,'22','242','4',2,'Sale Id shift 107',0.00,0.00,0.00,592.50,0.00,'2022-08-15 09:19:50','',''),(1468,'22','242','1',1,'Sale Id shift 107',0.00,0.00,0.00,791.33,0.00,'2022-08-15 09:19:50','',''),(1469,'22','242','1',1,'Sale Id shift 107',0.00,0.00,0.00,360.99,0.00,'2022-08-15 09:19:50','',''),(1470,'22','242','1',1,'Sale Id shift 107',0.00,0.00,0.00,900.07,0.00,'2022-08-15 09:19:50','',''),(1471,'22','242',NULL,2,'Sale Id shift 107',869174.00,0.00,0.00,0.00,0.00,'2022-08-15 09:19:50','',''),(1472,'22','242',NULL,1,'Sale Id shift 107',674480.40,0.00,0.00,0.00,0.00,'2022-08-15 09:19:50','',''),(1473,'22','242','1',1,'Sale Id shift 108',0.00,0.00,0.00,1011.57,0.00,'2022-08-16 10:54:43','',''),(1474,'22','242','2',1,'Sale Id shift 108',0.00,0.00,0.00,733.05,0.00,'2022-08-16 10:54:43','',''),(1475,'22','242','1',1,'Sale Id shift 108',0.00,0.00,0.00,590.77,0.00,'2022-08-16 10:54:43','',''),(1476,'22','242','2',1,'Sale Id shift 108',0.00,0.00,0.00,611.75,0.00,'2022-08-16 10:54:43','',''),(1477,'22','242','2',1,'Sale Id shift 108',0.00,0.00,0.00,607.42,0.00,'2022-08-16 10:54:43','',''),(1478,'22','242','2',1,'Sale Id shift 108',0.00,0.00,0.00,233.35,0.00,'2022-08-16 10:54:43','',''),(1479,'22','242','3',2,'Sale Id shift 108',0.00,0.00,0.00,566.24,0.00,'2022-08-16 10:54:43','',''),(1480,'22','242','3',2,'Sale Id shift 108',0.00,0.00,0.00,734.93,0.00,'2022-08-16 10:54:43','',''),(1481,'22','242','4',2,'Sale Id shift 108',0.00,0.00,0.00,950.00,0.00,'2022-08-16 10:54:43','',''),(1482,'22','242','1',1,'Sale Id shift 108',0.00,0.00,0.00,2035.60,0.00,'2022-08-16 10:54:43','',''),(1483,'22','242','1',1,'Sale Id shift 108',0.00,0.00,0.00,1028.69,0.00,'2022-08-16 10:54:43','',''),(1484,'22','242','1',1,'Sale Id shift 108',0.00,0.00,0.00,1006.04,0.00,'2022-08-16 10:54:43','',''),(1485,'22','242',NULL,2,'Sale Id shift 108',1710889.20,0.00,0.00,0.00,0.00,'2022-08-16 10:54:43','',''),(1486,'22','242',NULL,1,'Sale Id shift 108',1163019.52,0.00,0.00,0.00,0.00,'2022-08-16 10:54:43','',''),(1487,'22','242','1',1,'Sale Id shift 109',0.00,0.00,0.00,996.17,0.00,'2022-08-17 10:12:41','',''),(1488,'22','242','2',1,'Sale Id shift 109',0.00,0.00,0.00,995.61,0.00,'2022-08-17 10:12:41','',''),(1489,'22','242','1',1,'Sale Id shift 109',0.00,0.00,0.00,928.55,0.00,'2022-08-17 10:12:41','',''),(1490,'22','242','2',1,'Sale Id shift 109',0.00,0.00,0.00,761.94,0.00,'2022-08-17 10:12:41','',''),(1491,'22','242','2',1,'Sale Id shift 109',0.00,0.00,0.00,472.07,0.00,'2022-08-17 10:12:41','',''),(1492,'22','242','2',1,'Sale Id shift 109',0.00,0.00,0.00,344.39,0.00,'2022-08-17 10:12:41','',''),(1493,'22','242','3',2,'Sale Id shift 109',0.00,0.00,0.00,662.86,0.00,'2022-08-17 10:12:41','',''),(1494,'22','242','3',2,'Sale Id shift 109',0.00,0.00,0.00,811.04,0.00,'2022-08-17 10:12:41','',''),(1495,'22','242','4',2,'Sale Id shift 109',0.00,0.00,0.00,1400.00,0.00,'2022-08-17 10:12:41','',''),(1496,'22','242','1',1,'Sale Id shift 109',0.00,0.00,0.00,1246.15,0.00,'2022-08-17 10:12:41','',''),(1497,'22','242','1',1,'Sale Id shift 109',0.00,0.00,0.00,747.56,0.00,'2022-08-17 10:12:41','',''),(1498,'22','242','1',1,'Sale Id shift 109',0.00,0.00,0.00,786.58,0.00,'2022-08-17 10:12:41','',''),(1499,'22','242',NULL,2,'Sale Id shift 109',2184164.00,0.00,0.00,0.00,0.00,'2022-08-17 10:12:41','',''),(1500,'22','242',NULL,1,'Sale Id shift 109',1077294.96,0.00,0.00,0.00,0.00,'2022-08-17 10:12:41','',''),(1501,'22','242','1',1,'Sale Id shift 110',0.00,0.00,0.00,890.07,0.00,'2022-08-18 15:46:03','',''),(1502,'22','242','1',1,'Sale Id shift 110',0.00,0.00,0.00,1516.83,0.00,'2022-08-18 15:46:03','',''),(1503,'22','242','2',1,'Sale Id shift 110',0.00,0.00,0.00,449.86,0.00,'2022-08-18 15:46:03','',''),(1504,'22','242','2',1,'Sale Id shift 110',0.00,0.00,0.00,449.40,0.00,'2022-08-18 15:46:03','',''),(1505,'22','242','2',1,'Sale Id shift 110',0.00,0.00,0.00,203.34,0.00,'2022-08-18 15:46:03','',''),(1506,'22','242','3',2,'Sale Id shift 110',0.00,0.00,0.00,505.96,0.00,'2022-08-18 15:46:03','',''),(1507,'22','242','3',2,'Sale Id shift 110',0.00,0.00,0.00,1019.46,0.00,'2022-08-18 15:46:03','',''),(1508,'22','242','4',2,'Sale Id shift 110',0.00,0.00,0.00,1273.00,0.00,'2022-08-18 15:46:03','',''),(1509,'22','242','1',1,'Sale Id shift 110',0.00,0.00,0.00,851.81,0.00,'2022-08-18 15:46:03','',''),(1510,'22','242','1',1,'Sale Id shift 110',0.00,0.00,0.00,450.41,0.00,'2022-08-18 15:46:03','',''),(1511,'22','242','1',1,'Sale Id shift 110',0.00,0.00,0.00,1250.68,0.00,'2022-08-18 15:46:03','',''),(1512,'22','242',NULL,2,'Sale Id shift 110',2126799.20,0.00,0.00,0.00,0.00,'2022-08-18 15:46:03','',''),(1513,'22','242',NULL,1,'Sale Id shift 110',897235.20,0.00,0.00,0.00,0.00,'2022-08-18 15:46:03','',''),(1514,'22','242',NULL,1,'Purchased from ETERNA PLC',0.00,6660000.00,45000.00,0.00,0.00,'2022-08-23 13:09:36','',''),(1515,'22','242',NULL,1,'Reception corrector for bridging 70',0.00,0.00,0.00,15000.00,0.00,'2022-08-23 13:11:49','',''),(1516,'22','242','2',1,'Received from bridging 70',0.00,0.00,15000.00,0.00,0.00,'2022-08-23 13:11:49','',''),(1517,'22','242',NULL,1,'Reception corrector for bridging 69',0.00,0.00,0.00,30000.00,0.00,'2022-08-23 13:12:06','',''),(1518,'22','242','1',1,'Received from bridging 69',0.00,0.00,30000.00,0.00,0.00,'2022-08-23 13:12:06','',''),(1519,'22','242','1',1,'Sale Id shift 111',0.00,0.00,0.00,884.40,0.00,'2022-08-23 13:15:36','',''),(1520,'22','242','2',1,'Sale Id shift 111',0.00,0.00,0.00,308.46,0.00,'2022-08-23 13:15:36','',''),(1521,'22','242','1',1,'Sale Id shift 111',0.00,0.00,0.00,628.71,0.00,'2022-08-23 13:15:36','',''),(1522,'22','242','2',1,'Sale Id shift 111',0.00,0.00,0.00,249.39,0.00,'2022-08-23 13:15:36','',''),(1523,'22','242','2',1,'Sale Id shift 111',0.00,0.00,0.00,307.79,0.00,'2022-08-23 13:15:36','',''),(1524,'22','242','2',1,'Sale Id shift 111',0.00,0.00,0.00,146.89,0.00,'2022-08-23 13:15:36','',''),(1525,'22','242','3',2,'Sale Id shift 111',0.00,0.00,0.00,490.62,0.00,'2022-08-23 13:15:36','',''),(1526,'22','242','3',2,'Sale Id shift 111',0.00,0.00,0.00,448.28,0.00,'2022-08-23 13:15:36','',''),(1527,'22','242','4',2,'Sale Id shift 111',0.00,0.00,0.00,550.00,0.00,'2022-08-23 13:15:36','',''),(1528,'22','242','1',1,'Sale Id shift 111',0.00,0.00,0.00,1526.72,0.00,'2022-08-23 13:15:36','',''),(1529,'22','242','1',1,'Sale Id shift 111',0.00,0.00,0.00,312.35,0.00,'2022-08-23 13:15:36','',''),(1530,'22','242','1',1,'Sale Id shift 111',0.00,0.00,0.00,965.26,0.00,'2022-08-23 13:15:36','',''),(1531,'22','242',NULL,2,'Sale Id shift 111',1131564.00,0.00,0.00,0.00,0.00,'2022-08-23 13:15:36','',''),(1532,'22','242',NULL,1,'Sale Id shift 111',788835.56,0.00,0.00,0.00,0.00,'2022-08-23 13:15:36','',''),(1533,'22','242','1',1,'Sale Id shift 112',0.00,0.00,0.00,550.73,0.00,'2022-08-23 13:21:05','',''),(1534,'22','242','2',1,'Sale Id shift 112',0.00,0.00,0.00,580.67,0.00,'2022-08-23 13:21:05','',''),(1535,'22','242','1',1,'Sale Id shift 112',0.00,0.00,0.00,300.22,0.00,'2022-08-23 13:21:05','',''),(1536,'22','242','2',1,'Sale Id shift 112',0.00,0.00,0.00,1177.51,0.00,'2022-08-23 13:21:05','',''),(1537,'22','242','2',1,'Sale Id shift 112',0.00,0.00,0.00,288.03,0.00,'2022-08-23 13:21:05','',''),(1538,'22','242','2',1,'Sale Id shift 112',0.00,0.00,0.00,223.73,0.00,'2022-08-23 13:21:05','',''),(1539,'22','242','3',2,'Sale Id shift 112',0.00,0.00,0.00,767.07,0.00,'2022-08-23 13:21:05','',''),(1540,'22','242','3',2,'Sale Id shift 112',0.00,0.00,0.00,549.22,0.00,'2022-08-23 13:21:05','',''),(1541,'22','242','4',2,'Sale Id shift 112',0.00,0.00,0.00,800.00,0.00,'2022-08-23 13:21:05','',''),(1542,'22','242','1',1,'Sale Id shift 112',0.00,0.00,0.00,832.36,0.00,'2022-08-23 13:21:05','',''),(1543,'22','242','1',1,'Sale Id shift 112',0.00,0.00,0.00,459.39,0.00,'2022-08-23 13:21:05','',''),(1544,'22','242','1',1,'Sale Id shift 112',0.00,0.00,0.00,333.69,0.00,'2022-08-23 13:21:05','',''),(1545,'22','242',NULL,2,'Sale Id shift 112',1608380.40,0.00,0.00,0.00,0.00,'2022-08-23 13:21:05','',''),(1546,'22','242',NULL,1,'Sale Id shift 112',702456.84,0.00,0.00,0.00,0.00,'2022-08-23 13:21:05','',''),(1547,'22','242','2',1,'Sale Id shift 113',0.00,0.00,0.00,100.54,0.00,'2022-08-23 13:23:20','',''),(1548,'22','242','3',2,'Sale Id shift 113',0.00,0.00,0.00,314.98,0.00,'2022-08-23 13:23:20','',''),(1549,'22','242','3',2,'Sale Id shift 113',0.00,0.00,0.00,333.41,0.00,'2022-08-23 13:23:20','',''),(1550,'22','242','4',2,'Sale Id shift 113',0.00,0.00,0.00,410.00,0.00,'2022-08-23 13:23:20','',''),(1551,'22','242',NULL,2,'Sale Id shift 113',804376.40,0.00,0.00,0.00,0.00,'2022-08-23 13:23:20','',''),(1552,'22','242',NULL,1,'Sale Id shift 113',14879.92,0.00,0.00,0.00,0.00,'2022-08-23 13:23:20','',''),(1553,'22','242','2',1,'Sale Id shift 114',0.00,0.00,0.00,30.00,0.00,'2022-08-23 13:25:49','',''),(1554,'22','242','3',2,'Sale Id shift 114',0.00,0.00,0.00,199.10,0.00,'2022-08-23 13:25:49','',''),(1555,'22','242','3',2,'Sale Id shift 114',0.00,0.00,0.00,164.93,0.00,'2022-08-23 13:25:49','',''),(1556,'22','242',NULL,2,'Sale Id shift 114',276662.80,0.00,0.00,0.00,0.00,'2022-08-23 13:25:49','',''),(1557,'22','242',NULL,1,'Sale Id shift 114',4440.00,0.00,0.00,0.00,0.00,'2022-08-23 13:25:49','',''),(1558,'22','242','1',1,'Sale Id shift 115',0.00,0.00,0.00,312.94,0.00,'2022-08-23 13:29:19','',''),(1559,'22','242','2',1,'Sale Id shift 115',0.00,0.00,0.00,484.44,0.00,'2022-08-23 13:29:19','',''),(1560,'22','242','1',1,'Sale Id shift 115',0.00,0.00,0.00,458.28,0.00,'2022-08-23 13:29:19','',''),(1561,'22','242','2',1,'Sale Id shift 115',0.00,0.00,0.00,265.71,0.00,'2022-08-23 13:29:19','',''),(1562,'22','242','2',1,'Sale Id shift 115',0.00,0.00,0.00,334.83,0.00,'2022-08-23 13:29:19','',''),(1563,'22','242','2',1,'Sale Id shift 115',0.00,0.00,0.00,111.34,0.00,'2022-08-23 13:29:19','',''),(1564,'22','242','3',2,'Sale Id shift 115',0.00,0.00,0.00,539.65,0.00,'2022-08-23 13:29:19','',''),(1565,'22','242','3',2,'Sale Id shift 115',0.00,0.00,0.00,670.67,0.00,'2022-08-23 13:29:19','',''),(1566,'22','242','4',2,'Sale Id shift 115',0.00,0.00,0.00,300.00,0.00,'2022-08-23 13:29:19','',''),(1567,'22','242','1',1,'Sale Id shift 115',0.00,0.00,0.00,377.31,0.00,'2022-08-23 13:29:19','',''),(1568,'22','242','1',1,'Sale Id shift 115',0.00,0.00,0.00,374.98,0.00,'2022-08-23 13:29:19','',''),(1569,'22','242','1',1,'Sale Id shift 115',0.00,0.00,0.00,268.51,0.00,'2022-08-23 13:29:19','',''),(1570,'22','242',NULL,2,'Sale Id shift 115',1147843.20,0.00,0.00,0.00,0.00,'2022-08-23 13:29:19','',''),(1571,'22','242',NULL,1,'Sale Id shift 115',442274.32,0.00,0.00,0.00,0.00,'2022-08-23 13:29:19','',''),(1572,'22','242','1',1,'Sale Id shift 116',0.00,0.00,0.00,458.88,0.00,'2022-08-23 22:30:08','',''),(1573,'22','242','2',1,'Sale Id shift 116',0.00,0.00,0.00,399.01,0.00,'2022-08-23 22:30:08','',''),(1574,'22','242','1',1,'Sale Id shift 116',0.00,0.00,0.00,281.03,0.00,'2022-08-23 22:30:08','',''),(1575,'22','242','2',1,'Sale Id shift 116',0.00,0.00,0.00,942.64,0.00,'2022-08-23 22:30:08','',''),(1576,'22','242','2',1,'Sale Id shift 116',0.00,0.00,0.00,256.58,0.00,'2022-08-23 22:30:08','',''),(1577,'22','242','2',1,'Sale Id shift 116',0.00,0.00,0.00,283.87,0.00,'2022-08-23 22:30:08','',''),(1578,'22','242','3',2,'Sale Id shift 116',0.00,0.00,0.00,418.71,0.00,'2022-08-23 22:30:08','',''),(1579,'22','242','3',2,'Sale Id shift 116',0.00,0.00,0.00,633.01,0.00,'2022-08-23 22:30:08','',''),(1580,'22','242','4',2,'Sale Id shift 116',0.00,0.00,0.00,1140.00,0.00,'2022-08-23 22:30:08','',''),(1581,'22','242','1',1,'Sale Id shift 116',0.00,0.00,0.00,716.19,0.00,'2022-08-23 22:30:08','',''),(1582,'22','242','1',1,'Sale Id shift 116',0.00,0.00,0.00,711.35,0.00,'2022-08-23 22:30:08','',''),(1583,'22','242','1',1,'Sale Id shift 116',0.00,0.00,0.00,681.03,0.00,'2022-08-23 22:30:08','',''),(1584,'22','242',NULL,2,'Sale Id shift 116',1665707.20,0.00,0.00,0.00,0.00,'2022-08-23 22:30:08','',''),(1585,'22','242',NULL,1,'Sale Id shift 116',700125.84,0.00,0.00,0.00,0.00,'2022-08-23 22:30:08','',''),(1586,'22','242','1',1,'Sale Id shift 117',0.00,0.00,0.00,697.40,0.00,'2022-08-27 10:34:44','',''),(1587,'22','242','2',1,'Sale Id shift 117',0.00,0.00,0.00,543.72,0.00,'2022-08-27 10:34:44','',''),(1588,'22','242','1',1,'Sale Id shift 117',0.00,0.00,0.00,627.62,0.00,'2022-08-27 10:34:44','',''),(1589,'22','242','2',1,'Sale Id shift 117',0.00,0.00,0.00,329.94,0.00,'2022-08-27 10:34:44','',''),(1590,'22','242','2',1,'Sale Id shift 117',0.00,0.00,0.00,565.50,0.00,'2022-08-27 10:34:44','',''),(1591,'22','242','2',1,'Sale Id shift 117',0.00,0.00,0.00,161.58,0.00,'2022-08-27 10:34:44','',''),(1592,'22','242','3',2,'Sale Id shift 117',0.00,0.00,0.00,667.75,0.00,'2022-08-27 10:34:44','',''),(1593,'22','242','3',2,'Sale Id shift 117',0.00,0.00,0.00,741.44,0.00,'2022-08-27 10:34:44','',''),(1594,'22','242','4',2,'Sale Id shift 117',0.00,0.00,0.00,1520.01,0.00,'2022-08-27 10:34:44','',''),(1595,'22','242','1',1,'Sale Id shift 117',0.00,0.00,0.00,716.63,0.00,'2022-08-27 10:34:44','',''),(1596,'22','242','1',1,'Sale Id shift 117',0.00,0.00,0.00,750.68,0.00,'2022-08-27 10:34:44','',''),(1597,'22','242','1',1,'Sale Id shift 117',0.00,0.00,0.00,536.72,0.00,'2022-08-27 10:34:44','',''),(1598,'22','242',NULL,2,'Sale Id shift 117',2226192.00,0.00,0.00,0.00,0.00,'2022-08-27 10:34:44','',''),(1599,'22','242',NULL,1,'Sale Id shift 117',729608.92,0.00,0.00,0.00,0.00,'2022-08-27 10:34:44','',''),(1600,'22','242','1',1,'Sale Id shift 118',0.00,0.00,0.00,554.12,0.00,'2022-08-27 10:38:51','',''),(1601,'22','242','2',1,'Sale Id shift 118',0.00,0.00,0.00,305.53,0.00,'2022-08-27 10:38:51','',''),(1602,'22','242','1',1,'Sale Id shift 118',0.00,0.00,0.00,461.15,0.00,'2022-08-27 10:38:51','',''),(1603,'22','242','2',1,'Sale Id shift 118',0.00,0.00,0.00,564.89,0.00,'2022-08-27 10:38:51','',''),(1604,'22','242','2',1,'Sale Id shift 118',0.00,0.00,0.00,534.36,0.00,'2022-08-27 10:38:51','',''),(1605,'22','242','2',1,'Sale Id shift 118',0.00,0.00,0.00,518.53,0.00,'2022-08-27 10:38:51','',''),(1606,'22','242','3',2,'Sale Id shift 118',0.00,0.00,0.00,408.68,0.00,'2022-08-27 10:38:51','',''),(1607,'22','242','3',2,'Sale Id shift 118',0.00,0.00,0.00,390.67,0.00,'2022-08-27 10:38:51','',''),(1608,'22','242','4',2,'Sale Id shift 118',0.00,0.00,0.00,278.38,0.00,'2022-08-27 10:38:51','',''),(1609,'22','242','1',1,'Sale Id shift 118',0.00,0.00,0.00,991.33,0.00,'2022-08-27 10:38:51','',''),(1610,'22','242','1',1,'Sale Id shift 118',0.00,0.00,0.00,716.30,0.00,'2022-08-27 10:38:51','',''),(1611,'22','242','1',1,'Sale Id shift 118',0.00,0.00,0.00,735.40,0.00,'2022-08-27 10:38:51','',''),(1612,'22','242',NULL,2,'Sale Id shift 118',819074.80,0.00,0.00,0.00,0.00,'2022-08-27 10:38:51','',''),(1613,'22','242',NULL,1,'Sale Id shift 118',796478.28,0.00,0.00,0.00,0.00,'2022-08-27 10:38:51','',''),(1614,'22','242','1',1,'Sale Id shift 119',0.00,0.00,0.00,776.95,0.00,'2022-08-27 10:44:26','',''),(1615,'22','242','2',1,'Sale Id shift 119',0.00,0.00,0.00,485.86,0.00,'2022-08-27 10:44:26','',''),(1616,'22','242','1',1,'Sale Id shift 119',0.00,0.00,0.00,550.26,0.00,'2022-08-27 10:44:26','',''),(1617,'22','242','2',1,'Sale Id shift 119',0.00,0.00,0.00,425.34,0.00,'2022-08-27 10:44:26','',''),(1618,'22','242','2',1,'Sale Id shift 119',0.00,0.00,0.00,1039.65,0.00,'2022-08-27 10:44:26','',''),(1619,'22','242','2',1,'Sale Id shift 119',0.00,0.00,0.00,925.70,0.00,'2022-08-27 10:44:26','',''),(1620,'22','242','3',2,'Sale Id shift 119',0.00,0.00,0.00,535.28,0.00,'2022-08-27 10:44:26','',''),(1621,'22','242','3',2,'Sale Id shift 119',0.00,0.00,0.00,960.90,0.00,'2022-08-27 10:44:26','',''),(1622,'22','242','4',2,'Sale Id shift 119',0.00,0.00,0.00,1100.00,0.00,'2022-08-27 10:44:26','',''),(1623,'22','242','1',1,'Sale Id shift 119',0.00,0.00,0.00,616.06,0.00,'2022-08-27 10:44:26','',''),(1624,'22','242','1',1,'Sale Id shift 119',0.00,0.00,0.00,512.09,0.00,'2022-08-27 10:44:26','',''),(1625,'22','242','1',1,'Sale Id shift 119',0.00,0.00,0.00,719.14,0.00,'2022-08-27 10:44:26','',''),(1626,'22','242',NULL,2,'Sale Id shift 119',1973096.80,0.00,0.00,0.00,0.00,'2022-08-27 10:44:26','',''),(1627,'22','242',NULL,1,'Sale Id shift 119',895555.40,0.00,0.00,0.00,0.00,'2022-08-27 10:44:26','',''),(1628,'22','242','1',1,'Sale Id shift 120',0.00,0.00,0.00,601.93,0.00,'2022-08-28 06:50:00','',''),(1629,'22','242','2',1,'Sale Id shift 120',0.00,0.00,0.00,130.77,0.00,'2022-08-28 06:50:00','',''),(1630,'22','242','1',1,'Sale Id shift 120',0.00,0.00,0.00,484.00,0.00,'2022-08-28 06:50:00','',''),(1631,'22','242','2',1,'Sale Id shift 120',0.00,0.00,0.00,289.80,0.00,'2022-08-28 06:50:00','',''),(1632,'22','242','2',1,'Sale Id shift 120',0.00,0.00,0.00,380.65,0.00,'2022-08-28 06:50:00','',''),(1633,'22','242','2',1,'Sale Id shift 120',0.00,0.00,0.00,230.19,0.00,'2022-08-28 06:50:00','',''),(1634,'22','242','3',2,'Sale Id shift 120',0.00,0.00,0.00,698.63,0.00,'2022-08-28 06:50:00','',''),(1635,'22','242','3',2,'Sale Id shift 120',0.00,0.00,0.00,475.05,0.00,'2022-08-28 06:50:00','',''),(1636,'22','242','4',2,'Sale Id shift 120',0.00,0.00,0.00,727.00,0.00,'2022-08-28 06:50:00','',''),(1637,'22','242','1',1,'Sale Id shift 120',0.00,0.00,0.00,1110.54,0.00,'2022-08-28 06:50:00','',''),(1638,'22','242','1',1,'Sale Id shift 120',0.00,0.00,0.00,737.91,0.00,'2022-08-28 06:50:00','',''),(1639,'22','242','1',1,'Sale Id shift 120',0.00,0.00,0.00,374.75,0.00,'2022-08-28 06:50:00','',''),(1640,'22','242',NULL,2,'Sale Id shift 120',1444516.80,0.00,0.00,0.00,0.00,'2022-08-28 06:50:00','',''),(1641,'22','242',NULL,1,'Sale Id shift 120',642399.92,0.00,0.00,0.00,0.00,'2022-08-28 06:50:00','',''),(1642,'22','242','1',1,'Sale Id shift 121',0.00,0.00,0.00,1151.66,0.00,'2022-08-29 22:11:12','',''),(1643,'22','242','2',1,'Sale Id shift 121',0.00,0.00,0.00,302.70,0.00,'2022-08-29 22:11:12','',''),(1644,'22','242','1',1,'Sale Id shift 121',0.00,0.00,0.00,230.85,0.00,'2022-08-29 22:11:12','',''),(1645,'22','242','2',1,'Sale Id shift 121',0.00,0.00,0.00,147.19,0.00,'2022-08-29 22:11:12','',''),(1646,'22','242','2',1,'Sale Id shift 121',0.00,0.00,0.00,115.88,0.00,'2022-08-29 22:11:12','',''),(1647,'22','242','2',1,'Sale Id shift 121',0.00,0.00,0.00,0.09,0.00,'2022-08-29 22:11:12','',''),(1648,'22','242','3',2,'Sale Id shift 121',0.00,0.00,0.00,135.59,0.00,'2022-08-29 22:11:12','',''),(1649,'22','242','3',2,'Sale Id shift 121',0.00,0.00,0.00,200.28,0.00,'2022-08-29 22:11:12','',''),(1650,'22','242','4',2,'Sale Id shift 121',0.00,0.00,0.00,700.00,0.00,'2022-08-29 22:11:12','',''),(1651,'22','242','1',1,'Sale Id shift 121',0.00,0.00,0.00,666.98,0.00,'2022-08-29 22:11:12','',''),(1652,'22','242','1',1,'Sale Id shift 121',0.00,0.00,0.00,519.86,0.00,'2022-08-29 22:11:12','',''),(1653,'22','242','1',1,'Sale Id shift 121',0.00,0.00,0.00,808.88,0.00,'2022-08-29 22:11:12','',''),(1654,'22','242',NULL,2,'Sale Id shift 121',787261.20,0.00,0.00,0.00,0.00,'2022-08-29 22:11:12','',''),(1655,'22','242',NULL,1,'Sale Id shift 121',583725.32,0.00,0.00,0.00,0.00,'2022-08-29 22:11:12','',''),(1656,'22','242','1',1,'Sale Id shift 122',0.00,0.00,0.00,1178.29,0.00,'2022-08-29 22:15:05','',''),(1657,'22','242','2',1,'Sale Id shift 122',0.00,0.00,0.00,451.55,0.00,'2022-08-29 22:15:05','',''),(1658,'22','242','1',1,'Sale Id shift 122',0.00,0.00,0.00,1091.77,0.00,'2022-08-29 22:15:05','',''),(1659,'22','242','2',1,'Sale Id shift 122',0.00,0.00,0.00,379.35,0.00,'2022-08-29 22:15:05','',''),(1660,'22','242','2',1,'Sale Id shift 122',0.00,0.00,0.00,162.31,0.00,'2022-08-29 22:15:05','',''),(1661,'22','242','2',1,'Sale Id shift 122',0.00,0.00,0.00,27.86,0.00,'2022-08-29 22:15:05','',''),(1662,'22','242','3',2,'Sale Id shift 122',0.00,0.00,0.00,954.25,0.00,'2022-08-29 22:15:05','',''),(1663,'22','242','3',2,'Sale Id shift 122',0.00,0.00,0.00,877.15,0.00,'2022-08-29 22:15:05','',''),(1664,'22','242','4',2,'Sale Id shift 122',0.00,0.00,0.00,190.00,0.00,'2022-08-29 22:15:05','',''),(1665,'22','242','1',1,'Sale Id shift 122',0.00,0.00,0.00,744.16,0.00,'2022-08-29 22:15:05','',''),(1666,'22','242','1',1,'Sale Id shift 122',0.00,0.00,0.00,762.02,0.00,'2022-08-29 22:15:05','',''),(1667,'22','242','1',1,'Sale Id shift 122',0.00,0.00,0.00,865.50,0.00,'2022-08-29 22:15:05','',''),(1668,'22','242',NULL,2,'Sale Id shift 122',1536264.00,0.00,0.00,0.00,0.00,'2022-08-29 22:15:05','',''),(1669,'22','242',NULL,1,'Sale Id shift 122',838095.88,0.00,0.00,0.00,0.00,'2022-08-29 22:15:05','',''),(1670,'22','242',NULL,2,'Purchased from PPMC',0.00,34200000.00,45000.00,0.00,0.00,'2022-08-30 10:21:28','',''),(1671,'22','242',NULL,2,'Reception corrector for bridging 71',0.00,0.00,0.00,30000.00,0.00,'2022-08-30 10:24:53','',''),(1672,'22','242','3',2,'Received from bridging 71',0.00,0.00,30000.00,0.00,0.00,'2022-08-30 10:24:53','',''),(1673,'22','242',NULL,2,'Reception corrector for bridging 72',0.00,0.00,0.00,15000.00,0.00,'2022-08-30 10:25:21','',''),(1674,'22','242','4',2,'Received from bridging 72',0.00,0.00,15000.00,0.00,0.00,'2022-08-30 10:25:21','',''),(1675,'22','242',NULL,1,'Purchased from ASCON OIL COMPANY LIMITED ',0.00,6216000.00,42000.00,0.00,0.00,'2022-08-30 10:25:50','',''),(1676,'22','242',NULL,1,'Reception corrector for bridging 74',0.00,0.00,0.00,14000.00,0.00,'2022-08-30 10:27:17','',''),(1677,'22','242','2',1,'Received from bridging 74',0.00,0.00,14000.00,0.00,0.00,'2022-08-30 10:27:17','',''),(1678,'22','242',NULL,1,'Reception corrector for bridging 73',0.00,0.00,0.00,28000.00,0.00,'2022-08-30 10:27:27','',''),(1679,'22','242','1',1,'Received from bridging 73',0.00,0.00,28000.00,0.00,0.00,'2022-08-30 10:27:27','',''),(1680,'22','242','1',1,'Sale Id shift 123',0.00,0.00,0.00,846.20,0.00,'2022-08-30 22:00:19','',''),(1681,'22','242','2',1,'Sale Id shift 123',0.00,0.00,0.00,713.02,0.00,'2022-08-30 22:00:19','',''),(1682,'22','242','1',1,'Sale Id shift 123',0.00,0.00,0.00,600.98,0.00,'2022-08-30 22:00:19','',''),(1683,'22','242','2',1,'Sale Id shift 123',0.00,0.00,0.00,613.67,0.00,'2022-08-30 22:00:19','',''),(1684,'22','242','2',1,'Sale Id shift 123',0.00,0.00,0.00,668.57,0.00,'2022-08-30 22:00:19','',''),(1685,'22','242','3',2,'Sale Id shift 123',0.00,0.00,0.00,970.18,0.00,'2022-08-30 22:00:19','',''),(1686,'22','242','3',2,'Sale Id shift 123',0.00,0.00,0.00,768.34,0.00,'2022-08-30 22:00:19','',''),(1687,'22','242','4',2,'Sale Id shift 123',0.00,0.00,0.00,1382.06,0.00,'2022-08-30 22:00:19','',''),(1688,'22','242','1',1,'Sale Id shift 123',0.00,0.00,0.00,854.71,0.00,'2022-08-30 22:00:19','',''),(1689,'22','242','1',1,'Sale Id shift 123',0.00,0.00,0.00,638.67,0.00,'2022-08-30 22:00:19','',''),(1690,'22','242','1',1,'Sale Id shift 123',0.00,0.00,0.00,391.01,0.00,'2022-08-30 22:00:19','',''),(1691,'22','242',NULL,2,'Sale Id shift 123',2371640.80,0.00,0.00,0.00,0.00,'2022-08-30 22:00:19','',''),(1692,'22','242',NULL,1,'Sale Id shift 123',788370.84,0.00,0.00,0.00,0.00,'2022-08-30 22:00:19','',''),(1693,'22','242','1',1,'Sale Id shift 124',0.00,0.00,0.00,622.31,0.00,'2022-08-31 22:07:39','',''),(1694,'22','242','2',1,'Sale Id shift 124',0.00,0.00,0.00,832.46,0.00,'2022-08-31 22:07:39','',''),(1695,'22','242','1',1,'Sale Id shift 124',0.00,0.00,0.00,455.04,0.00,'2022-08-31 22:07:39','',''),(1696,'22','242','2',1,'Sale Id shift 124',0.00,0.00,0.00,728.26,0.00,'2022-08-31 22:07:39','',''),(1697,'22','242','2',1,'Sale Id shift 124',0.00,0.00,0.00,666.58,0.00,'2022-08-31 22:07:39','',''),(1698,'22','242','2',1,'Sale Id shift 124',0.00,0.00,0.00,266.86,0.00,'2022-08-31 22:07:39','',''),(1699,'22','242','3',2,'Sale Id shift 124',0.00,0.00,0.00,689.80,0.00,'2022-08-31 22:07:39','',''),(1700,'22','242','3',2,'Sale Id shift 124',0.00,0.00,0.00,874.90,0.00,'2022-08-31 22:07:39','',''),(1701,'22','242','4',2,'Sale Id shift 124',0.00,0.00,0.00,620.00,0.00,'2022-08-31 22:07:39','',''),(1702,'22','242','1',1,'Sale Id shift 124',0.00,0.00,0.00,1303.16,0.00,'2022-08-31 22:07:39','',''),(1703,'22','242','1',1,'Sale Id shift 124',0.00,0.00,0.00,683.64,0.00,'2022-08-31 22:07:39','',''),(1704,'22','242','1',1,'Sale Id shift 124',0.00,0.00,0.00,473.18,0.00,'2022-08-31 22:07:39','',''),(1705,'22','242',NULL,2,'Sale Id shift 124',1660372.00,0.00,0.00,0.00,0.00,'2022-08-31 22:07:39','',''),(1706,'22','242',NULL,1,'Sale Id shift 124',892660.52,0.00,0.00,0.00,0.00,'2022-08-31 22:07:39','',''),(1707,'22','242',NULL,1,'Purchased from NIPC0 PLC',0.00,6660000.00,45000.00,0.00,0.00,'2022-09-01 19:42:46','',''),(1708,'22','242',NULL,1,'Reception corrector for bridging 76',0.00,0.00,0.00,25000.00,0.00,'2022-09-01 19:45:25','',''),(1709,'22','242','2',1,'Received from bridging 76',0.00,0.00,25000.00,0.00,0.00,'2022-09-01 19:45:25','',''),(1710,'22','242',NULL,1,'Reception corrector for bridging 75',0.00,0.00,0.00,20000.00,0.00,'2022-09-01 19:45:36','',''),(1711,'22','242','1',1,'Received from bridging 75',0.00,0.00,20000.00,0.00,0.00,'2022-09-01 19:45:36','',''),(1712,'22','242','1',1,'Sale Id shift 125',0.00,0.00,0.00,581.16,0.00,'2022-09-03 10:14:33','',''),(1713,'22','242','2',1,'Sale Id shift 125',0.00,0.00,0.00,745.48,0.00,'2022-09-03 10:14:33','',''),(1714,'22','242','1',1,'Sale Id shift 125',0.00,0.00,0.00,623.11,0.00,'2022-09-03 10:14:33','',''),(1715,'22','242','2',1,'Sale Id shift 125',0.00,0.00,0.00,451.94,0.00,'2022-09-03 10:14:33','',''),(1716,'22','242','2',1,'Sale Id shift 125',0.00,0.00,0.00,1580.03,0.00,'2022-09-03 10:14:33','',''),(1717,'22','242','2',1,'Sale Id shift 125',0.00,0.00,0.00,0.11,0.00,'2022-09-03 10:14:33','',''),(1718,'22','242','3',2,'Sale Id shift 125',0.00,0.00,0.00,1207.51,0.00,'2022-09-03 10:14:33','',''),(1719,'22','242','3',2,'Sale Id shift 125',0.00,0.00,0.00,1236.53,0.00,'2022-09-03 10:14:33','',''),(1720,'22','242','4',2,'Sale Id shift 125',0.00,0.00,0.00,1019.49,0.00,'2022-09-03 10:14:33','',''),(1721,'22','242','1',1,'Sale Id shift 125',0.00,0.00,0.00,920.27,0.00,'2022-09-03 10:14:33','',''),(1722,'22','242','1',1,'Sale Id shift 125',0.00,0.00,0.00,612.54,0.00,'2022-09-03 10:14:33','',''),(1723,'22','242','1',1,'Sale Id shift 125',0.00,0.00,0.00,970.66,0.00,'2022-09-03 10:14:33','',''),(1724,'22','242',NULL,2,'Sale Id shift 125',2632282.80,0.00,0.00,0.00,0.00,'2022-09-03 10:14:33','',''),(1725,'22','242',NULL,1,'Sale Id shift 125',959824.40,0.00,0.00,0.00,0.00,'2022-09-03 10:14:33','',''),(1726,'22','242','1',1,'Sale Id shift 126',0.00,0.00,0.00,776.38,0.00,'2022-09-03 10:51:08','',''),(1727,'22','242','2',1,'Sale Id shift 126',0.00,0.00,0.00,587.84,0.00,'2022-09-03 10:51:08','',''),(1728,'22','242','1',1,'Sale Id shift 126',0.00,0.00,0.00,475.08,0.00,'2022-09-03 10:51:08','',''),(1729,'22','242','2',1,'Sale Id shift 126',0.00,0.00,0.00,768.33,0.00,'2022-09-03 10:51:08','',''),(1730,'22','242','2',1,'Sale Id shift 126',0.00,0.00,0.00,557.35,0.00,'2022-09-03 10:51:08','',''),(1731,'22','242','2',1,'Sale Id shift 126',0.00,0.00,0.00,779.41,0.00,'2022-09-03 10:51:08','',''),(1732,'22','242','3',2,'Sale Id shift 126',0.00,0.00,0.00,626.52,0.00,'2022-09-03 10:51:08','',''),(1733,'22','242','3',2,'Sale Id shift 126',0.00,0.00,0.00,956.97,0.00,'2022-09-03 10:51:08','',''),(1734,'22','242','4',2,'Sale Id shift 126',0.00,0.00,0.00,600.00,0.00,'2022-09-03 10:51:08','',''),(1735,'22','242','1',1,'Sale Id shift 126',0.00,0.00,0.00,1273.16,0.00,'2022-09-03 10:51:08','',''),(1736,'22','242','1',1,'Sale Id shift 126',0.00,0.00,0.00,634.36,0.00,'2022-09-03 10:51:08','',''),(1737,'22','242','1',1,'Sale Id shift 126',0.00,0.00,0.00,531.52,0.00,'2022-09-03 10:51:08','',''),(1738,'22','242',NULL,2,'Sale Id shift 126',1659452.40,0.00,0.00,0.00,0.00,'2022-09-03 10:51:08','',''),(1739,'22','242',NULL,1,'Sale Id shift 126',944747.64,0.00,0.00,0.00,0.00,'2022-09-03 10:51:08','',''),(1740,'22','242','1',1,'Sale Id shift 127',0.00,0.00,0.00,1132.01,0.00,'2022-09-04 08:54:18','',''),(1741,'22','242','1',1,'Sale Id shift 127',0.00,0.00,0.00,460.98,0.00,'2022-09-04 08:54:18','',''),(1742,'22','242','2',1,'Sale Id shift 127',0.00,0.00,0.00,334.24,0.00,'2022-09-04 08:54:18','',''),(1743,'22','242','2',1,'Sale Id shift 127',0.00,0.00,0.00,520.20,0.00,'2022-09-04 08:54:18','',''),(1744,'22','242','2',1,'Sale Id shift 127',0.00,0.00,0.00,480.69,0.00,'2022-09-04 08:54:18','',''),(1745,'22','242','3',2,'Sale Id shift 127',0.00,0.00,0.00,605.37,0.00,'2022-09-04 08:54:18','',''),(1746,'22','242','3',2,'Sale Id shift 127',0.00,0.00,0.00,1222.53,0.00,'2022-09-04 08:54:18','',''),(1747,'22','242','4',2,'Sale Id shift 127',0.00,0.00,0.00,580.00,0.00,'2022-09-04 08:54:18','',''),(1748,'22','242','1',1,'Sale Id shift 127',0.00,0.00,0.00,793.04,0.00,'2022-09-04 08:54:18','',''),(1749,'22','242','1',1,'Sale Id shift 127',0.00,0.00,0.00,503.10,0.00,'2022-09-04 08:54:18','',''),(1750,'22','242','1',1,'Sale Id shift 127',0.00,0.00,0.00,1191.24,0.00,'2022-09-04 08:54:18','',''),(1751,'22','242',NULL,2,'Sale Id shift 127',1830004.00,0.00,0.00,0.00,0.00,'2022-09-04 08:54:18','',''),(1752,'22','242',NULL,1,'Sale Id shift 127',801494.00,0.00,0.00,0.00,0.00,'2022-09-04 08:54:18','',''),(1753,'22','242','1',1,'Sale Id shift 128',0.00,0.00,0.00,405.97,0.00,'2022-09-05 10:50:55','',''),(1754,'22','242','2',1,'Sale Id shift 128',0.00,0.00,0.00,902.85,0.00,'2022-09-05 10:50:55','',''),(1755,'22','242','2',1,'Sale Id shift 128',0.00,0.00,0.00,481.42,0.00,'2022-09-05 10:50:55','',''),(1756,'22','242','2',1,'Sale Id shift 128',0.00,0.00,0.00,303.31,0.00,'2022-09-05 10:50:55','',''),(1757,'22','242','3',2,'Sale Id shift 128',0.00,0.00,0.00,29.02,0.00,'2022-09-05 10:50:55','',''),(1758,'22','242','3',2,'Sale Id shift 128',0.00,0.00,0.00,188.71,0.00,'2022-09-05 10:50:55','',''),(1759,'22','242','4',2,'Sale Id shift 128',0.00,0.00,0.00,600.00,0.00,'2022-09-05 10:50:55','',''),(1760,'22','242','1',1,'Sale Id shift 128',0.00,0.00,0.00,508.36,0.00,'2022-09-05 10:50:55','',''),(1761,'22','242','1',1,'Sale Id shift 128',0.00,0.00,0.00,623.07,0.00,'2022-09-05 10:50:55','',''),(1762,'22','242','1',1,'Sale Id shift 128',0.00,0.00,0.00,230.79,0.00,'2022-09-05 10:50:55','',''),(1763,'22','242',NULL,2,'Sale Id shift 128',621474.80,0.00,0.00,0.00,0.00,'2022-09-05 10:50:55','',''),(1764,'22','242',NULL,1,'Sale Id shift 128',511453.96,0.00,0.00,0.00,0.00,'2022-09-05 10:50:55','',''),(1765,'22','242','1',1,'Sale Id shift 129',0.00,0.00,0.00,653.48,0.00,'2022-09-06 22:08:04','',''),(1766,'22','242','2',1,'Sale Id shift 129',0.00,0.00,0.00,777.99,0.00,'2022-09-06 22:08:04','',''),(1767,'22','242','1',1,'Sale Id shift 129',0.00,0.00,0.00,574.37,0.00,'2022-09-06 22:08:04','',''),(1768,'22','242','2',1,'Sale Id shift 129',0.00,0.00,0.00,436.79,0.00,'2022-09-06 22:08:04','',''),(1769,'22','242','2',1,'Sale Id shift 129',0.00,0.00,0.00,508.40,0.00,'2022-09-06 22:08:04','',''),(1770,'22','242','2',1,'Sale Id shift 129',0.00,0.00,0.00,175.03,0.00,'2022-09-06 22:08:04','',''),(1771,'22','242','3',2,'Sale Id shift 129',0.00,0.00,0.00,906.22,0.00,'2022-09-06 22:08:04','',''),(1772,'22','242','3',2,'Sale Id shift 129',0.00,0.00,0.00,749.82,0.00,'2022-09-06 22:08:04','',''),(1773,'22','242','4',2,'Sale Id shift 129',0.00,0.00,0.00,2544.46,0.00,'2022-09-06 22:08:04','',''),(1774,'22','242','1',1,'Sale Id shift 129',0.00,0.00,0.00,865.82,0.00,'2022-09-06 22:08:04','',''),(1775,'22','242','1',1,'Sale Id shift 129',0.00,0.00,0.00,765.71,0.00,'2022-09-06 22:08:04','',''),(1776,'22','242','1',1,'Sale Id shift 129',0.00,0.00,0.00,795.02,0.00,'2022-09-06 22:08:04','',''),(1777,'22','242',NULL,2,'Sale Id shift 129',3192380.00,0.00,0.00,0.00,0.00,'2022-09-06 22:08:04','',''),(1778,'22','242',NULL,1,'Sale Id shift 129',821786.28,0.00,0.00,0.00,0.00,'2022-09-06 22:08:04','',''),(1779,'22','242','1',1,'Sale Id shift 130',0.00,0.00,0.00,362.14,0.00,'2022-09-06 22:12:54','',''),(1780,'22','242','2',1,'Sale Id shift 130',0.00,0.00,0.00,795.14,0.00,'2022-09-06 22:12:54','',''),(1781,'22','242','1',1,'Sale Id shift 130',0.00,0.00,0.00,1633.62,0.00,'2022-09-06 22:12:54','',''),(1782,'22','242','2',1,'Sale Id shift 130',0.00,0.00,0.00,784.09,0.00,'2022-09-06 22:12:54','',''),(1783,'22','242','2',1,'Sale Id shift 130',0.00,0.00,0.00,621.02,0.00,'2022-09-06 22:12:54','',''),(1784,'22','242','2',1,'Sale Id shift 130',0.00,0.00,0.00,427.71,0.00,'2022-09-06 22:12:54','',''),(1785,'22','242','3',2,'Sale Id shift 130',0.00,0.00,0.00,577.77,0.00,'2022-09-06 22:12:54','',''),(1786,'22','242','3',2,'Sale Id shift 130',0.00,0.00,0.00,665.37,0.00,'2022-09-06 22:12:54','',''),(1787,'22','242','4',2,'Sale Id shift 130',0.00,0.00,0.00,180.00,0.00,'2022-09-06 22:12:54','',''),(1788,'22','242','1',1,'Sale Id shift 130',0.00,0.00,0.00,729.80,0.00,'2022-09-06 22:12:54','',''),(1789,'22','242','1',1,'Sale Id shift 130',0.00,0.00,0.00,566.20,0.00,'2022-09-06 22:12:54','',''),(1790,'22','242','1',1,'Sale Id shift 130',0.00,0.00,0.00,762.62,0.00,'2022-09-06 22:12:54','',''),(1791,'22','242',NULL,2,'Sale Id shift 130',1081586.40,0.00,0.00,0.00,0.00,'2022-09-06 22:12:54','',''),(1792,'22','242',NULL,1,'Sale Id shift 130',988986.32,0.00,0.00,0.00,0.00,'2022-09-06 22:12:54','',''),(1793,'22','242','1',1,'Sale Id shift 131',0.00,0.00,0.00,463.35,0.00,'2022-09-08 22:00:16','',''),(1794,'22','242','2',1,'Sale Id shift 131',0.00,0.00,0.00,607.21,0.00,'2022-09-08 22:00:16','',''),(1795,'22','242','1',1,'Sale Id shift 131',0.00,0.00,0.00,670.08,0.00,'2022-09-08 22:00:16','',''),(1796,'22','242','2',1,'Sale Id shift 131',0.00,0.00,0.00,397.65,0.00,'2022-09-08 22:00:16','',''),(1797,'22','242','2',1,'Sale Id shift 131',0.00,0.00,0.00,558.48,0.00,'2022-09-08 22:00:16','',''),(1798,'22','242','2',1,'Sale Id shift 131',0.00,0.00,0.00,289.92,0.00,'2022-09-08 22:00:16','',''),(1799,'22','242','3',2,'Sale Id shift 131',0.00,0.00,0.00,638.35,0.00,'2022-09-08 22:00:16','',''),(1800,'22','242','3',2,'Sale Id shift 131',0.00,0.00,0.00,968.88,0.00,'2022-09-08 22:00:17','',''),(1801,'22','242','4',2,'Sale Id shift 131',0.00,0.00,0.00,405.00,0.00,'2022-09-08 22:00:17','',''),(1802,'22','242','1',1,'Sale Id shift 131',0.00,0.00,0.00,1114.77,0.00,'2022-09-08 22:00:17','',''),(1803,'22','242','1',1,'Sale Id shift 131',0.00,0.00,0.00,571.25,0.00,'2022-09-08 22:00:17','',''),(1804,'22','242','1',1,'Sale Id shift 131',0.00,0.00,0.00,795.47,0.00,'2022-09-08 22:00:17','',''),(1805,'22','242',NULL,2,'Sale Id shift 131',1529294.80,0.00,0.00,0.00,0.00,'2022-09-08 22:00:17','',''),(1806,'22','242',NULL,1,'Sale Id shift 131',809290.64,0.00,0.00,0.00,0.00,'2022-09-08 22:00:17','',''),(1807,'22','242','1',1,'Sale Id shift 132',0.00,0.00,0.00,484.88,0.00,'2022-09-08 22:05:39','',''),(1808,'22','242','2',1,'Sale Id shift 132',0.00,0.00,0.00,221.93,0.00,'2022-09-08 22:05:39','',''),(1809,'22','242','1',1,'Sale Id shift 132',0.00,0.00,0.00,451.14,0.00,'2022-09-08 22:05:39','',''),(1810,'22','242','2',1,'Sale Id shift 132',0.00,0.00,0.00,1415.24,0.00,'2022-09-08 22:05:39','',''),(1811,'22','242','2',1,'Sale Id shift 132',0.00,0.00,0.00,505.46,0.00,'2022-09-08 22:05:39','',''),(1812,'22','242','2',1,'Sale Id shift 132',0.00,0.00,0.00,412.46,0.00,'2022-09-08 22:05:39','',''),(1813,'22','242','3',2,'Sale Id shift 132',0.00,0.00,0.00,650.10,0.00,'2022-09-08 22:05:39','',''),(1814,'22','242','3',2,'Sale Id shift 132',0.00,0.00,0.00,706.53,0.00,'2022-09-08 22:05:39','',''),(1815,'22','242','4',2,'Sale Id shift 132',0.00,0.00,0.00,579.90,0.00,'2022-09-08 22:05:39','',''),(1816,'22','242','1',1,'Sale Id shift 132',0.00,0.00,0.00,1523.58,0.00,'2022-09-08 22:05:39','',''),(1817,'22','242','1',1,'Sale Id shift 132',0.00,0.00,0.00,811.06,0.00,'2022-09-08 22:05:39','',''),(1818,'22','242','1',1,'Sale Id shift 132',0.00,0.00,0.00,631.05,0.00,'2022-09-08 22:05:39','',''),(1819,'22','242',NULL,2,'Sale Id shift 132',1471762.80,0.00,0.00,0.00,0.00,'2022-09-08 22:05:39','',''),(1820,'22','242',NULL,1,'Sale Id shift 132',955606.40,0.00,0.00,0.00,0.00,'2022-09-08 22:05:39','',''),(1821,'22','242','1',1,'Sale Id shift 133',0.00,0.00,0.00,672.17,0.00,'2022-09-12 11:02:34','',''),(1822,'22','242','2',1,'Sale Id shift 133',0.00,0.00,0.00,848.20,0.00,'2022-09-12 11:02:34','',''),(1823,'22','242','1',1,'Sale Id shift 133',0.00,0.00,0.00,518.13,0.00,'2022-09-12 11:02:34','',''),(1824,'22','242','2',1,'Sale Id shift 133',0.00,0.00,0.00,633.32,0.00,'2022-09-12 11:02:34','',''),(1825,'22','242','2',1,'Sale Id shift 133',0.00,0.00,0.00,766.08,0.00,'2022-09-12 11:02:34','',''),(1826,'22','242','2',1,'Sale Id shift 133',0.00,0.00,0.00,267.66,0.00,'2022-09-12 11:02:34','',''),(1827,'22','242','3',2,'Sale Id shift 133',0.00,0.00,0.00,711.17,0.00,'2022-09-12 11:02:34','',''),(1828,'22','242','3',2,'Sale Id shift 133',0.00,0.00,0.00,1025.70,0.00,'2022-09-12 11:02:34','',''),(1829,'22','242','4',2,'Sale Id shift 133',0.00,0.00,0.00,690.10,0.00,'2022-09-12 11:02:34','',''),(1830,'22','242','1',1,'Sale Id shift 133',0.00,0.00,0.00,824.19,0.00,'2022-09-12 11:02:34','',''),(1831,'22','242','1',1,'Sale Id shift 133',0.00,0.00,0.00,763.77,0.00,'2022-09-12 11:02:34','',''),(1832,'22','242','1',1,'Sale Id shift 133',0.00,0.00,0.00,675.86,0.00,'2022-09-12 11:02:34','',''),(1833,'22','242',NULL,2,'Sale Id shift 133',1844497.20,0.00,0.00,0.00,0.00,'2022-09-12 11:02:34','',''),(1834,'22','242',NULL,1,'Sale Id shift 133',883468.24,0.00,0.00,0.00,0.00,'2022-09-12 11:02:34','',''),(1835,'22','242','1',1,'Sale Id shift 134',0.00,0.00,0.00,684.31,0.00,'2022-09-12 11:06:21','',''),(1836,'22','242','2',1,'Sale Id shift 134',0.00,0.00,0.00,439.90,0.00,'2022-09-12 11:06:21','',''),(1837,'22','242','1',1,'Sale Id shift 134',0.00,0.00,0.00,387.60,0.00,'2022-09-12 11:06:21','',''),(1838,'22','242','2',1,'Sale Id shift 134',0.00,0.00,0.00,679.82,0.00,'2022-09-12 11:06:21','',''),(1839,'22','242','2',1,'Sale Id shift 134',0.00,0.00,0.00,976.76,0.00,'2022-09-12 11:06:21','',''),(1840,'22','242','2',1,'Sale Id shift 134',0.00,0.00,0.00,800.33,0.00,'2022-09-12 11:06:21','',''),(1841,'22','242','3',2,'Sale Id shift 134',0.00,0.00,0.00,522.01,0.00,'2022-09-12 11:06:21','',''),(1842,'22','242','3',2,'Sale Id shift 134',0.00,0.00,0.00,783.96,0.00,'2022-09-12 11:06:21','',''),(1843,'22','242','4',2,'Sale Id shift 134',0.00,0.00,0.00,1530.00,0.00,'2022-09-12 11:06:21','',''),(1844,'22','242','1',1,'Sale Id shift 134',0.00,0.00,0.00,928.73,0.00,'2022-09-12 11:06:21','',''),(1845,'22','242','1',1,'Sale Id shift 134',0.00,0.00,0.00,537.63,0.00,'2022-09-12 11:06:21','',''),(1846,'22','242','1',1,'Sale Id shift 134',0.00,0.00,0.00,867.83,0.00,'2022-09-12 11:06:21','',''),(1847,'22','242',NULL,2,'Sale Id shift 134',2155337.20,0.00,0.00,0.00,0.00,'2022-09-12 11:06:21','',''),(1848,'22','242',NULL,1,'Sale Id shift 134',932830.68,0.00,0.00,0.00,0.00,'2022-09-12 11:06:21','',''),(1849,'22','242','1',1,'Sale Id shift 135',0.00,0.00,0.00,508.69,0.00,'2022-09-12 11:12:36','',''),(1850,'22','242','2',1,'Sale Id shift 135',0.00,0.00,0.00,262.61,0.00,'2022-09-12 11:12:36','',''),(1851,'22','242','1',1,'Sale Id shift 135',0.00,0.00,0.00,60.53,0.00,'2022-09-12 11:12:36','',''),(1852,'22','242','2',1,'Sale Id shift 135',0.00,0.00,0.00,402.23,0.00,'2022-09-12 11:12:36','',''),(1853,'22','242','2',1,'Sale Id shift 135',0.00,0.00,0.00,326.95,0.00,'2022-09-12 11:12:36','',''),(1854,'22','242','2',1,'Sale Id shift 135',0.00,0.00,0.00,107.20,0.00,'2022-09-12 11:12:36','',''),(1855,'22','242','3',2,'Sale Id shift 135',0.00,0.00,0.00,261.42,0.00,'2022-09-12 11:12:36','',''),(1856,'22','242','3',2,'Sale Id shift 135',0.00,0.00,0.00,190.10,0.00,'2022-09-12 11:12:36','',''),(1857,'22','242','4',2,'Sale Id shift 135',0.00,0.00,0.00,442.43,0.00,'2022-09-12 11:12:36','',''),(1858,'22','242','1',1,'Sale Id shift 135',0.00,0.00,0.00,753.95,0.00,'2022-09-12 11:12:36','',''),(1859,'22','242','1',1,'Sale Id shift 135',0.00,0.00,0.00,871.74,0.00,'2022-09-12 11:12:36','',''),(1860,'22','242','1',1,'Sale Id shift 135',0.00,0.00,0.00,693.55,0.00,'2022-09-12 11:12:36','',''),(1861,'22','242',NULL,2,'Sale Id shift 135',679402.00,0.00,0.00,0.00,0.00,'2022-09-12 11:12:36','',''),(1862,'22','242',NULL,1,'Sale Id shift 135',590142.60,0.00,0.00,0.00,0.00,'2022-09-12 11:12:36','',''),(1863,'22','242',NULL,1,'Purchased from PINNACLE OIL & GAS LIMITED ',0.00,6660000.00,45000.00,0.00,0.00,'2022-09-12 21:34:30','',''),(1864,'22','242',NULL,1,'Reception corrector for bridging 78',0.00,0.00,0.00,15000.00,0.00,'2022-09-12 21:35:58','',''),(1865,'22','242','2',1,'Received from bridging 78',0.00,0.00,15000.00,0.00,0.00,'2022-09-12 21:35:58','',''),(1866,'22','242',NULL,1,'Reception corrector for bridging 77',0.00,0.00,0.00,30000.00,0.00,'2022-09-12 21:36:08','',''),(1867,'22','242','1',1,'Received from bridging 77',0.00,0.00,30000.00,0.00,0.00,'2022-09-12 21:36:08','',''),(1868,'22','242','1',1,'Sale Id shift 136',0.00,0.00,0.00,858.59,0.00,'2022-09-12 21:39:56','',''),(1869,'22','242','2',1,'Sale Id shift 136',0.00,0.00,0.00,516.11,0.00,'2022-09-12 21:39:56','',''),(1870,'22','242','1',1,'Sale Id shift 136',0.00,0.00,0.00,428.59,0.00,'2022-09-12 21:39:56','',''),(1871,'22','242','2',1,'Sale Id shift 136',0.00,0.00,0.00,446.31,0.00,'2022-09-12 21:39:56','',''),(1872,'22','242','2',1,'Sale Id shift 136',0.00,0.00,0.00,464.04,0.00,'2022-09-12 21:39:56','',''),(1873,'22','242','2',1,'Sale Id shift 136',0.00,0.00,0.00,382.01,0.00,'2022-09-12 21:39:56','',''),(1874,'22','242','3',2,'Sale Id shift 136',0.00,0.00,0.00,472.61,0.00,'2022-09-12 21:39:56','',''),(1875,'22','242','3',2,'Sale Id shift 136',0.00,0.00,0.00,905.57,0.00,'2022-09-12 21:39:56','',''),(1876,'22','242','4',2,'Sale Id shift 136',0.00,0.00,0.00,856.50,0.00,'2022-09-12 21:39:56','',''),(1877,'22','242','1',1,'Sale Id shift 136',0.00,0.00,0.00,1671.43,0.00,'2022-09-12 21:39:56','',''),(1878,'22','242','1',1,'Sale Id shift 136',0.00,0.00,0.00,1277.43,0.00,'2022-09-12 21:39:56','',''),(1879,'22','242','1',1,'Sale Id shift 136',0.00,0.00,0.00,709.67,0.00,'2022-09-12 21:39:56','',''),(1880,'22','242',NULL,2,'Sale Id shift 136',1698356.80,0.00,0.00,0.00,0.00,'2022-09-12 21:39:56','',''),(1881,'22','242',NULL,1,'Sale Id shift 136',999618.64,0.00,0.00,0.00,0.00,'2022-09-12 21:39:56','',''),(1882,'22','242','1',1,'Sale Id shift 137',0.00,0.00,0.00,680.44,0.00,'2022-09-13 21:43:58','',''),(1883,'22','242','2',1,'Sale Id shift 137',0.00,0.00,0.00,732.47,0.00,'2022-09-13 21:43:58','',''),(1884,'22','242','1',1,'Sale Id shift 137',0.00,0.00,0.00,865.61,0.00,'2022-09-13 21:43:58','',''),(1885,'22','242','2',1,'Sale Id shift 137',0.00,0.00,0.00,956.03,0.00,'2022-09-13 21:43:58','',''),(1886,'22','242','2',1,'Sale Id shift 137',0.00,0.00,0.00,680.12,0.00,'2022-09-13 21:43:58','',''),(1887,'22','242','2',1,'Sale Id shift 137',0.00,0.00,0.00,698.65,0.00,'2022-09-13 21:43:58','',''),(1888,'22','242','3',2,'Sale Id shift 137',0.00,0.00,0.00,528.01,0.00,'2022-09-13 21:43:58','',''),(1889,'22','242','3',2,'Sale Id shift 137',0.00,0.00,0.00,953.62,0.00,'2022-09-13 21:43:58','',''),(1890,'22','242','4',2,'Sale Id shift 137',0.00,0.00,0.00,383.87,0.00,'2022-09-13 21:43:58','',''),(1891,'22','242','1',1,'Sale Id shift 137',0.00,0.00,0.00,1278.07,0.00,'2022-09-13 21:43:58','',''),(1892,'22','242','1',1,'Sale Id shift 137',0.00,0.00,0.00,1040.88,0.00,'2022-09-13 21:43:58','',''),(1893,'22','242','1',1,'Sale Id shift 137',0.00,0.00,0.00,1114.64,0.00,'2022-09-13 21:43:58','',''),(1894,'22','242',NULL,2,'Sale Id shift 137',1417780.00,0.00,0.00,0.00,0.00,'2022-09-13 21:43:58','',''),(1895,'22','242',NULL,1,'Sale Id shift 137',1190942.68,0.00,0.00,0.00,0.00,'2022-09-13 21:43:58','',''),(1896,'22','242','1',1,'Sale Id shift 138',0.00,0.00,0.00,1072.32,0.00,'2022-09-14 22:25:46','',''),(1897,'22','242','2',1,'Sale Id shift 138',0.00,0.00,0.00,884.71,0.00,'2022-09-14 22:25:46','',''),(1898,'22','242','1',1,'Sale Id shift 138',0.00,0.00,0.00,1188.04,0.00,'2022-09-14 22:25:46','',''),(1899,'22','242','2',1,'Sale Id shift 138',0.00,0.00,0.00,723.48,0.00,'2022-09-14 22:25:46','',''),(1900,'22','242','2',1,'Sale Id shift 138',0.00,0.00,0.00,679.67,0.00,'2022-09-14 22:25:46','',''),(1901,'22','242','2',1,'Sale Id shift 138',0.00,0.00,0.00,230.85,0.00,'2022-09-14 22:25:46','',''),(1902,'22','242','3',2,'Sale Id shift 138',0.00,0.00,0.00,880.36,0.00,'2022-09-14 22:25:46','',''),(1903,'22','242','3',2,'Sale Id shift 138',0.00,0.00,0.00,644.26,0.00,'2022-09-14 22:25:46','',''),(1904,'22','242','4',2,'Sale Id shift 138',0.00,0.00,0.00,2406.60,0.00,'2022-09-14 22:25:46','',''),(1905,'22','242','1',1,'Sale Id shift 138',0.00,0.00,0.00,125.58,0.00,'2022-09-14 22:25:46','',''),(1906,'22','242','1',1,'Sale Id shift 138',0.00,0.00,0.00,968.03,0.00,'2022-09-14 22:25:46','',''),(1907,'22','242','1',1,'Sale Id shift 138',0.00,0.00,0.00,990.09,0.00,'2022-09-14 22:25:46','',''),(1908,'22','242',NULL,2,'Sale Id shift 138',2987727.20,0.00,0.00,0.00,0.00,'2022-09-14 22:25:46','',''),(1909,'22','242',NULL,1,'Sale Id shift 138',1015689.96,0.00,0.00,0.00,0.00,'2022-09-14 22:25:46','',''),(1910,'22','242','1',1,'Sale Id shift 139',0.00,0.00,0.00,965.49,0.00,'2022-09-17 15:23:28','',''),(1911,'22','242','2',1,'Sale Id shift 139',0.00,0.00,0.00,683.91,0.00,'2022-09-17 15:23:28','',''),(1912,'22','242','1',1,'Sale Id shift 139',0.00,0.00,0.00,569.90,0.00,'2022-09-17 15:23:28','',''),(1913,'22','242','2',1,'Sale Id shift 139',0.00,0.00,0.00,685.76,0.00,'2022-09-17 15:23:28','',''),(1914,'22','242','2',1,'Sale Id shift 139',0.00,0.00,0.00,584.55,0.00,'2022-09-17 15:23:28','',''),(1915,'22','242','2',1,'Sale Id shift 139',0.00,0.00,0.00,348.27,0.00,'2022-09-17 15:23:28','',''),(1916,'22','242','3',2,'Sale Id shift 139',0.00,0.00,0.00,424.87,0.00,'2022-09-17 15:23:28','',''),(1917,'22','242','3',2,'Sale Id shift 139',0.00,0.00,0.00,663.51,0.00,'2022-09-17 15:23:28','',''),(1918,'22','242','4',2,'Sale Id shift 139',0.00,0.00,0.00,1088.41,0.00,'2022-09-17 15:23:28','',''),(1919,'22','242','1',1,'Sale Id shift 139',0.00,0.00,0.00,1534.57,0.00,'2022-09-17 15:23:28','',''),(1920,'22','242','1',1,'Sale Id shift 139',0.00,0.00,0.00,833.96,0.00,'2022-09-17 15:23:28','',''),(1921,'22','242','1',1,'Sale Id shift 139',0.00,0.00,0.00,881.61,0.00,'2022-09-17 15:23:28','',''),(1922,'22','242',NULL,2,'Sale Id shift 139',1654360.40,0.00,0.00,0.00,0.00,'2022-09-17 15:23:28','',''),(1923,'22','242',NULL,1,'Sale Id shift 139',1049026.96,0.00,0.00,0.00,0.00,'2022-09-17 15:23:28','',''),(1924,'22','242','1',1,'Sale Id shift 140',0.00,0.00,0.00,618.82,0.00,'2022-09-17 15:28:16','',''),(1925,'22','242','2',1,'Sale Id shift 140',0.00,0.00,0.00,861.34,0.00,'2022-09-17 15:28:16','',''),(1926,'22','242','1',1,'Sale Id shift 140',0.00,0.00,0.00,924.45,0.00,'2022-09-17 15:28:16','',''),(1927,'22','242','2',1,'Sale Id shift 140',0.00,0.00,0.00,680.41,0.00,'2022-09-17 15:28:16','',''),(1928,'22','242','2',1,'Sale Id shift 140',0.00,0.00,0.00,655.16,0.00,'2022-09-17 15:28:16','',''),(1929,'22','242','2',1,'Sale Id shift 140',0.00,0.00,0.00,414.89,0.00,'2022-09-17 15:28:16','',''),(1930,'22','242','3',2,'Sale Id shift 140',0.00,0.00,0.00,599.61,0.00,'2022-09-17 15:28:16','',''),(1931,'22','242','3',2,'Sale Id shift 140',0.00,0.00,0.00,895.68,0.00,'2022-09-17 15:28:16','',''),(1932,'22','242','4',2,'Sale Id shift 140',0.00,0.00,0.00,200.00,0.00,'2022-09-17 15:28:16','',''),(1933,'22','242','1',1,'Sale Id shift 140',0.00,0.00,0.00,1313.82,0.00,'2022-09-17 15:28:16','',''),(1934,'22','242','1',1,'Sale Id shift 140',0.00,0.00,0.00,540.47,0.00,'2022-09-17 15:28:16','',''),(1935,'22','242','1',1,'Sale Id shift 140',0.00,0.00,0.00,660.10,0.00,'2022-09-17 15:28:16','',''),(1936,'22','242',NULL,2,'Sale Id shift 140',1288420.40,0.00,0.00,0.00,0.00,'2022-09-17 15:28:16','',''),(1937,'22','242',NULL,1,'Sale Id shift 140',987080.08,0.00,0.00,0.00,0.00,'2022-09-17 15:28:16','',''),(1938,'22','242','1',1,'Sale Id shift 141',0.00,0.00,0.00,470.11,0.00,'2022-09-17 21:55:20','',''),(1939,'22','242','2',1,'Sale Id shift 141',0.00,0.00,0.00,1401.77,0.00,'2022-09-17 21:55:20','',''),(1940,'22','242','1',1,'Sale Id shift 141',0.00,0.00,0.00,827.64,0.00,'2022-09-17 21:55:20','',''),(1941,'22','242','2',1,'Sale Id shift 141',0.00,0.00,0.00,508.42,0.00,'2022-09-17 21:55:20','',''),(1942,'22','242','2',1,'Sale Id shift 141',0.00,0.00,0.00,496.90,0.00,'2022-09-17 21:55:20','',''),(1943,'22','242','2',1,'Sale Id shift 141',0.00,0.00,0.00,287.03,0.00,'2022-09-17 21:55:20','',''),(1944,'22','242','3',2,'Sale Id shift 141',0.00,0.00,0.00,371.80,0.00,'2022-09-17 21:55:20','',''),(1945,'22','242','3',2,'Sale Id shift 141',0.00,0.00,0.00,426.72,0.00,'2022-09-17 21:55:20','',''),(1946,'22','242','4',2,'Sale Id shift 141',0.00,0.00,0.00,1069.56,0.00,'2022-09-17 21:55:20','',''),(1947,'22','242','1',1,'Sale Id shift 141',0.00,0.00,0.00,1059.07,0.00,'2022-09-17 21:55:20','',''),(1948,'22','242','1',1,'Sale Id shift 141',0.00,0.00,0.00,734.05,0.00,'2022-09-17 21:55:20','',''),(1949,'22','242','1',1,'Sale Id shift 141',0.00,0.00,0.00,835.77,0.00,'2022-09-17 21:55:20','',''),(1950,'22','242',NULL,2,'Sale Id shift 141',1419740.80,0.00,0.00,0.00,0.00,'2022-09-17 21:55:20','',''),(1951,'22','242',NULL,1,'Sale Id shift 141',979872.48,0.00,0.00,0.00,0.00,'2022-09-17 21:55:20','',''),(1952,'22','242','1',1,'Sale Id shift 142',0.00,0.00,0.00,590.53,0.00,'2022-09-19 09:46:24','',''),(1953,'22','242','1',1,'Sale Id shift 142',0.00,0.00,0.00,572.36,0.00,'2022-09-19 09:46:24','',''),(1954,'22','242','2',1,'Sale Id shift 142',0.00,0.00,0.00,199.77,0.00,'2022-09-19 09:46:24','',''),(1955,'22','242','2',1,'Sale Id shift 142',0.00,0.00,0.00,376.53,0.00,'2022-09-19 09:46:24','',''),(1956,'22','242','2',1,'Sale Id shift 142',0.00,0.00,0.00,94.04,0.00,'2022-09-19 09:46:24','',''),(1957,'22','242','3',2,'Sale Id shift 142',0.00,0.00,0.00,147.70,0.00,'2022-09-19 09:46:24','',''),(1958,'22','242','3',2,'Sale Id shift 142',0.00,0.00,0.00,220.39,0.00,'2022-09-19 09:46:24','',''),(1959,'22','242','1',1,'Sale Id shift 142',0.00,0.00,0.00,453.77,0.00,'2022-09-19 09:46:24','',''),(1960,'22','242','1',1,'Sale Id shift 142',0.00,0.00,0.00,527.99,0.00,'2022-09-19 09:46:24','',''),(1961,'22','242','1',1,'Sale Id shift 142',0.00,0.00,0.00,568.29,0.00,'2022-09-19 09:46:24','',''),(1962,'22','242',NULL,2,'Sale Id shift 142',279748.40,0.00,0.00,0.00,0.00,'2022-09-19 09:46:24','',''),(1963,'22','242',NULL,1,'Sale Id shift 142',500725.44,0.00,0.00,0.00,0.00,'2022-09-19 09:46:24','',''),(1964,'22','242',NULL,2,'Purchased from TIME PETROLEUM SERVICES',0.00,34200000.00,45000.00,0.00,0.00,'2022-09-19 10:22:11','',''),(1965,'22','242',NULL,2,'Reception corrector for bridging 80',0.00,0.00,0.00,15000.00,0.00,'2022-09-19 10:24:28','',''),(1966,'22','242','4',2,'Received from bridging 80',0.00,0.00,15000.00,0.00,0.00,'2022-09-19 10:24:28','',''),(1967,'22','242',NULL,2,'Reception corrector for bridging 79',0.00,0.00,0.00,30000.00,0.00,'2022-09-19 10:24:40','',''),(1968,'22','242','3',2,'Received from bridging 79',0.00,0.00,30000.00,0.00,0.00,'2022-09-19 10:24:40','',''),(1969,'22','242','1',1,'Sale Id shift 143',0.00,0.00,0.00,841.93,0.00,'2022-09-20 09:49:11','',''),(1970,'22','242','2',1,'Sale Id shift 143',0.00,0.00,0.00,1198.33,0.00,'2022-09-20 09:49:11','',''),(1971,'22','242','1',1,'Sale Id shift 143',0.00,0.00,0.00,323.09,0.00,'2022-09-20 09:49:11','',''),(1972,'22','242','2',1,'Sale Id shift 143',0.00,0.00,0.00,602.56,0.00,'2022-09-20 09:49:11','',''),(1973,'22','242','2',1,'Sale Id shift 143',0.00,0.00,0.00,738.73,0.00,'2022-09-20 09:49:11','',''),(1974,'22','242','2',1,'Sale Id shift 143',0.00,0.00,0.00,595.27,0.00,'2022-09-20 09:49:11','',''),(1975,'22','242','3',2,'Sale Id shift 143',0.00,0.00,0.00,1000.71,0.00,'2022-09-20 09:49:11','',''),(1976,'22','242','3',2,'Sale Id shift 143',0.00,0.00,0.00,950.05,0.00,'2022-09-20 09:49:11','',''),(1977,'22','242','4',2,'Sale Id shift 143',0.00,0.00,0.00,400.00,0.00,'2022-09-20 09:49:11','',''),(1978,'22','242','1',1,'Sale Id shift 143',0.00,0.00,0.00,611.90,0.00,'2022-09-20 09:49:11','',''),(1979,'22','242','1',1,'Sale Id shift 143',0.00,0.00,0.00,651.38,0.00,'2022-09-20 09:49:11','',''),(1980,'22','242','1',1,'Sale Id shift 143',0.00,0.00,0.00,590.03,0.00,'2022-09-20 09:49:11','',''),(1981,'22','242',NULL,2,'Sale Id shift 143',1786577.60,0.00,0.00,0.00,0.00,'2022-09-20 09:49:11','',''),(1982,'22','242',NULL,1,'Sale Id shift 143',910676.56,0.00,0.00,0.00,0.00,'2022-09-20 09:49:11','',''),(1983,'22','242',NULL,1,'Purchased from PINNACLE OIL & GAS LIMITED ',0.00,6660000.00,45000.00,0.00,0.00,'2022-09-24 19:04:03','',''),(1984,'22','242',NULL,1,'Reception corrector for bridging 82',0.00,0.00,0.00,15000.00,0.00,'2022-09-24 19:05:29','',''),(1985,'22','242','2',1,'Received from bridging 82',0.00,0.00,15000.00,0.00,0.00,'2022-09-24 19:05:29','',''),(1986,'22','242',NULL,1,'Reception corrector for bridging 81',0.00,0.00,0.00,30000.00,0.00,'2022-09-24 19:09:28','',''),(1987,'22','242','1',1,'Received from bridging 81',0.00,0.00,30000.00,0.00,0.00,'2022-09-24 19:09:28','',''),(1988,'22','242','1',1,'Sale Id shift 144',0.00,0.00,0.00,513.28,0.00,'2022-09-24 19:13:31','',''),(1989,'22','242','2',1,'Sale Id shift 144',0.00,0.00,0.00,2195.35,0.00,'2022-09-24 19:13:31','',''),(1990,'22','242','1',1,'Sale Id shift 144',0.00,0.00,0.00,733.82,0.00,'2022-09-24 19:13:31','',''),(1991,'22','242','2',1,'Sale Id shift 144',0.00,0.00,0.00,1130.09,0.00,'2022-09-24 19:13:31','',''),(1992,'22','242','2',1,'Sale Id shift 144',0.00,0.00,0.00,602.36,0.00,'2022-09-24 19:13:31','',''),(1993,'22','242','2',1,'Sale Id shift 144',0.00,0.00,0.00,556.66,0.00,'2022-09-24 19:13:31','',''),(1994,'22','242','3',2,'Sale Id shift 144',0.00,0.00,0.00,610.75,0.00,'2022-09-24 19:13:31','',''),(1995,'22','242','3',2,'Sale Id shift 144',0.00,0.00,0.00,704.96,0.00,'2022-09-24 19:13:31','',''),(1996,'22','242','4',2,'Sale Id shift 144',0.00,0.00,0.00,300.00,0.00,'2022-09-24 19:13:31','',''),(1997,'22','242','1',1,'Sale Id shift 144',0.00,0.00,0.00,869.22,0.00,'2022-09-24 19:13:31','',''),(1998,'22','242','1',1,'Sale Id shift 144',0.00,0.00,0.00,528.75,0.00,'2022-09-24 19:13:31','',''),(1999,'22','242','1',1,'Sale Id shift 144',0.00,0.00,0.00,972.11,0.00,'2022-09-24 19:13:31','',''),(2000,'22','242',NULL,2,'Sale Id shift 144',1227939.60,0.00,0.00,0.00,0.00,'2022-09-24 19:13:31','',''),(2001,'22','242',NULL,1,'Sale Id shift 144',1199042.72,0.00,0.00,0.00,0.00,'2022-09-24 19:13:31','',''),(2002,'22','242','1',1,'Sale Id shift 145',0.00,0.00,0.00,834.17,0.00,'2022-09-24 19:25:36','',''),(2003,'22','242','2',1,'Sale Id shift 145',0.00,0.00,0.00,898.20,0.00,'2022-09-24 19:25:36','',''),(2004,'22','242','1',1,'Sale Id shift 145',0.00,0.00,0.00,783.07,0.00,'2022-09-24 19:25:36','',''),(2005,'22','242','2',1,'Sale Id shift 145',0.00,0.00,0.00,1041.00,0.00,'2022-09-24 19:25:36','',''),(2006,'22','242','2',1,'Sale Id shift 145',0.00,0.00,0.00,762.75,0.00,'2022-09-24 19:25:36','',''),(2007,'22','242','2',1,'Sale Id shift 145',0.00,0.00,0.00,564.60,0.00,'2022-09-24 19:25:36','',''),(2008,'22','242','3',2,'Sale Id shift 145',0.00,0.00,0.00,963.47,0.00,'2022-09-24 19:25:36','',''),(2009,'22','242','3',2,'Sale Id shift 145',0.00,0.00,0.00,427.90,0.00,'2022-09-24 19:25:36','',''),(2010,'22','242','4',2,'Sale Id shift 145',0.00,0.00,0.00,640.00,0.00,'2022-09-24 19:25:36','',''),(2011,'22','242','1',1,'Sale Id shift 145',0.00,0.00,0.00,1001.20,0.00,'2022-09-24 19:25:36','',''),(2012,'22','242','1',1,'Sale Id shift 145',0.00,0.00,0.00,876.18,0.00,'2022-09-24 19:25:36','',''),(2013,'22','242','1',1,'Sale Id shift 145',0.00,0.00,0.00,958.77,0.00,'2022-09-24 19:25:36','',''),(2014,'22','242',NULL,2,'Sale Id shift 145',1543841.20,0.00,0.00,0.00,0.00,'2022-09-24 19:25:36','',''),(2015,'22','242',NULL,1,'Sale Id shift 145',1142551.12,0.00,0.00,0.00,0.00,'2022-09-24 19:25:36','',''),(2016,'22','242','1',1,'Sale Id shift 146',0.00,0.00,0.00,898.84,0.00,'2022-09-24 19:29:49','',''),(2017,'22','242','2',1,'Sale Id shift 146',0.00,0.00,0.00,164.51,0.00,'2022-09-24 19:29:49','',''),(2018,'22','242','1',1,'Sale Id shift 146',0.00,0.00,0.00,422.66,0.00,'2022-09-24 19:29:49','',''),(2019,'22','242','2',1,'Sale Id shift 146',0.00,0.00,0.00,420.47,0.00,'2022-09-24 19:29:49','',''),(2020,'22','242','2',1,'Sale Id shift 146',0.00,0.00,0.00,475.67,0.00,'2022-09-24 19:29:49','',''),(2021,'22','242','2',1,'Sale Id shift 146',0.00,0.00,0.00,672.92,0.00,'2022-09-24 19:29:49','',''),(2022,'22','242','3',2,'Sale Id shift 146',0.00,0.00,0.00,512.02,0.00,'2022-09-24 19:29:49','',''),(2023,'22','242','3',2,'Sale Id shift 146',0.00,0.00,0.00,641.87,0.00,'2022-09-24 19:29:49','',''),(2024,'22','242','4',2,'Sale Id shift 146',0.00,0.00,0.00,440.00,0.00,'2022-09-24 19:29:49','',''),(2025,'22','242','1',1,'Sale Id shift 146',0.00,0.00,0.00,864.26,0.00,'2022-09-24 19:29:49','',''),(2026,'22','242','1',1,'Sale Id shift 146',0.00,0.00,0.00,618.84,0.00,'2022-09-24 19:29:49','',''),(2027,'22','242','1',1,'Sale Id shift 146',0.00,0.00,0.00,802.71,0.00,'2022-09-24 19:29:49','',''),(2028,'22','242',NULL,2,'Sale Id shift 146',1211356.40,0.00,0.00,0.00,0.00,'2022-09-24 19:29:49','',''),(2029,'22','242',NULL,1,'Sale Id shift 146',790450.24,0.00,0.00,0.00,0.00,'2022-09-24 19:29:49','',''),(2030,'22','242','1',1,'Sale Id shift 147',0.00,0.00,0.00,805.98,0.00,'2022-09-24 19:33:33','',''),(2031,'22','242','2',1,'Sale Id shift 147',0.00,0.00,0.00,561.25,0.00,'2022-09-24 19:33:33','',''),(2032,'22','242','1',1,'Sale Id shift 147',0.00,0.00,0.00,639.32,0.00,'2022-09-24 19:33:33','',''),(2033,'22','242','2',1,'Sale Id shift 147',0.00,0.00,0.00,879.22,0.00,'2022-09-24 19:33:33','',''),(2034,'22','242','2',1,'Sale Id shift 147',0.00,0.00,0.00,690.56,0.00,'2022-09-24 19:33:33','',''),(2035,'22','242','2',1,'Sale Id shift 147',0.00,0.00,0.00,681.38,0.00,'2022-09-24 19:33:33','',''),(2036,'22','242','3',2,'Sale Id shift 147',0.00,0.00,0.00,626.03,0.00,'2022-09-24 19:33:33','',''),(2037,'22','242','3',2,'Sale Id shift 147',0.00,0.00,0.00,721.13,0.00,'2022-09-24 19:33:33','',''),(2038,'22','242','4',2,'Sale Id shift 147',0.00,0.00,0.00,494.56,0.00,'2022-09-24 19:33:33','',''),(2039,'22','242','1',1,'Sale Id shift 147',0.00,0.00,0.00,1041.33,0.00,'2022-09-24 19:33:33','',''),(2040,'22','242','1',1,'Sale Id shift 147',0.00,0.00,0.00,733.88,0.00,'2022-09-24 19:33:33','',''),(2041,'22','242','1',1,'Sale Id shift 147',0.00,0.00,0.00,1064.56,0.00,'2022-09-24 19:33:33','',''),(2042,'22','242',NULL,2,'Sale Id shift 147',1399707.20,0.00,0.00,0.00,0.00,'2022-09-24 19:33:33','',''),(2043,'22','242',NULL,1,'Sale Id shift 147',1050427.04,0.00,0.00,0.00,0.00,'2022-09-24 19:33:33','',''),(2044,'22','242','1',1,'Sale Id shift 148',0.00,0.00,0.00,581.92,0.00,'2022-09-25 08:33:59','',''),(2045,'22','242','2',1,'Sale Id shift 148',0.00,0.00,0.00,524.33,0.00,'2022-09-25 08:33:59','',''),(2046,'22','242','1',1,'Sale Id shift 148',0.00,0.00,0.00,394.79,0.00,'2022-09-25 08:33:59','',''),(2047,'22','242','2',1,'Sale Id shift 148',0.00,0.00,0.00,884.89,0.00,'2022-09-25 08:33:59','',''),(2048,'22','242','2',1,'Sale Id shift 148',0.00,0.00,0.00,667.26,0.00,'2022-09-25 08:33:59','',''),(2049,'22','242','2',1,'Sale Id shift 148',0.00,0.00,0.00,191.00,0.00,'2022-09-25 08:33:59','',''),(2050,'22','242','3',2,'Sale Id shift 148',0.00,0.00,0.00,648.77,0.00,'2022-09-25 08:33:59','',''),(2051,'22','242','3',2,'Sale Id shift 148',0.00,0.00,0.00,532.22,0.00,'2022-09-25 08:33:59','',''),(2052,'22','242','4',2,'Sale Id shift 148',0.00,0.00,0.00,950.00,0.00,'2022-09-25 08:33:59','',''),(2053,'22','242','1',1,'Sale Id shift 148',0.00,0.00,0.00,1547.30,0.00,'2022-09-25 08:33:59','',''),(2054,'22','242','1',1,'Sale Id shift 148',0.00,0.00,0.00,924.12,0.00,'2022-09-25 08:33:59','',''),(2055,'22','242','1',1,'Sale Id shift 148',0.00,0.00,0.00,890.01,0.00,'2022-09-25 08:33:59','',''),(2056,'22','242',NULL,2,'Sale Id shift 148',1619552.40,0.00,0.00,0.00,0.00,'2022-09-25 08:33:59','',''),(2057,'22','242',NULL,1,'Sale Id shift 148',977631.76,0.00,0.00,0.00,0.00,'2022-09-25 08:33:59','',''),(2058,'22','242','1',1,'Sale Id shift 149',0.00,0.00,0.00,628.36,0.00,'2022-09-26 21:28:36','',''),(2059,'22','242','2',1,'Sale Id shift 149',0.00,0.00,0.00,448.26,0.00,'2022-09-26 21:28:36','',''),(2060,'22','242','1',1,'Sale Id shift 149',0.00,0.00,0.00,8.52,0.00,'2022-09-26 21:28:36','',''),(2061,'22','242','2',1,'Sale Id shift 149',0.00,0.00,0.00,306.25,0.00,'2022-09-26 21:28:36','',''),(2062,'22','242','2',1,'Sale Id shift 149',0.00,0.00,0.00,168.71,0.00,'2022-09-26 21:28:36','',''),(2063,'22','242','2',1,'Sale Id shift 149',0.00,0.00,0.00,221.69,0.00,'2022-09-26 21:28:36','',''),(2064,'22','242','3',2,'Sale Id shift 149',0.00,0.00,0.00,145.62,0.00,'2022-09-26 21:28:36','',''),(2065,'22','242','3',2,'Sale Id shift 149',0.00,0.00,0.00,244.96,0.00,'2022-09-26 21:28:36','',''),(2066,'22','242','4',2,'Sale Id shift 149',0.00,0.00,0.00,200.00,0.00,'2022-09-26 21:28:36','',''),(2067,'22','242','1',1,'Sale Id shift 149',0.00,0.00,0.00,687.67,0.00,'2022-09-26 21:28:36','',''),(2068,'22','242','1',1,'Sale Id shift 149',0.00,0.00,0.00,571.91,0.00,'2022-09-26 21:28:36','',''),(2069,'22','242','1',1,'Sale Id shift 149',0.00,0.00,0.00,797.41,0.00,'2022-09-26 21:28:36','',''),(2070,'22','242',NULL,2,'Sale Id shift 149',448840.80,0.00,0.00,0.00,0.00,'2022-09-26 21:28:36','',''),(2071,'22','242',NULL,1,'Sale Id shift 149',568139.44,0.00,0.00,0.00,0.00,'2022-09-26 21:28:36','',''),(2072,'22','242','1',1,'Sale Id shift 150',0.00,0.00,0.00,922.12,0.00,'2022-09-26 21:33:11','',''),(2073,'22','242','2',1,'Sale Id shift 150',0.00,0.00,0.00,318.82,0.00,'2022-09-26 21:33:11','',''),(2074,'22','242','1',1,'Sale Id shift 150',0.00,0.00,0.00,0.04,0.00,'2022-09-26 21:33:11','',''),(2075,'22','242','2',1,'Sale Id shift 150',0.00,0.00,0.00,863.93,0.00,'2022-09-26 21:33:11','',''),(2076,'22','242','2',1,'Sale Id shift 150',0.00,0.00,0.00,869.78,0.00,'2022-09-26 21:33:11','',''),(2077,'22','242','2',1,'Sale Id shift 150',0.00,0.00,0.00,647.67,0.00,'2022-09-26 21:33:11','',''),(2078,'22','242','3',2,'Sale Id shift 150',0.00,0.00,0.00,463.78,0.00,'2022-09-26 21:33:11','',''),(2079,'22','242','3',2,'Sale Id shift 150',0.00,0.00,0.00,703.84,0.00,'2022-09-26 21:33:11','',''),(2080,'22','242','4',2,'Sale Id shift 150',0.00,0.00,0.00,2616.30,0.00,'2022-09-26 21:33:11','',''),(2081,'22','242','1',1,'Sale Id shift 150',0.00,0.00,0.00,1597.02,0.00,'2022-09-26 21:33:11','',''),(2082,'22','242','1',1,'Sale Id shift 150',0.00,0.00,0.00,988.34,0.00,'2022-09-26 21:33:11','',''),(2083,'22','242','1',1,'Sale Id shift 150',0.00,0.00,0.00,1116.60,0.00,'2022-09-26 21:33:11','',''),(2084,'22','242',NULL,2,'Sale Id shift 150',2875779.20,0.00,0.00,0.00,0.00,'2022-09-26 21:33:11','',''),(2085,'22','242',NULL,1,'Sale Id shift 150',1083999.36,0.00,0.00,0.00,0.00,'2022-09-26 21:33:11','',''),(2086,'22','242',NULL,1,'Purchased from PINNACLE OIL & GAS LIMITED ',0.00,6660000.00,45000.00,0.00,0.00,'2022-09-27 21:53:23','',''),(2087,'22','242',NULL,1,'Reception corrector for bridging 84',0.00,0.00,0.00,15000.00,0.00,'2022-09-27 21:54:56','',''),(2088,'22','242','2',1,'Received from bridging 84',0.00,0.00,15000.00,0.00,0.00,'2022-09-27 21:54:56','',''),(2089,'22','242',NULL,1,'Reception corrector for bridging 83',0.00,0.00,0.00,30000.00,0.00,'2022-09-27 21:55:13','',''),(2090,'22','242','1',1,'Received from bridging 83',0.00,0.00,30000.00,0.00,0.00,'2022-09-27 21:55:13','',''),(2091,'22','242','1',1,'Sale Id shift 151',0.00,0.00,0.00,634.98,0.00,'2022-09-27 21:58:32','',''),(2092,'22','242','2',1,'Sale Id shift 151',0.00,0.00,0.00,1094.05,0.00,'2022-09-27 21:58:32','',''),(2093,'22','242','1',1,'Sale Id shift 151',0.00,0.00,0.00,552.81,0.00,'2022-09-27 21:58:32','',''),(2094,'22','242','2',1,'Sale Id shift 151',0.00,0.00,0.00,551.50,0.00,'2022-09-27 21:58:32','',''),(2095,'22','242','2',1,'Sale Id shift 151',0.00,0.00,0.00,514.75,0.00,'2022-09-27 21:58:32','',''),(2096,'22','242','2',1,'Sale Id shift 151',0.00,0.00,0.00,555.72,0.00,'2022-09-27 21:58:32','',''),(2097,'22','242','3',2,'Sale Id shift 151',0.00,0.00,0.00,467.48,0.00,'2022-09-27 21:58:32','',''),(2098,'22','242','3',2,'Sale Id shift 151',0.00,0.00,0.00,584.79,0.00,'2022-09-27 21:58:32','',''),(2099,'22','242','4',2,'Sale Id shift 151',0.00,0.00,0.00,737.00,0.00,'2022-09-27 21:58:32','',''),(2100,'22','242','1',1,'Sale Id shift 151',0.00,0.00,0.00,1157.45,0.00,'2022-09-27 21:58:32','',''),(2101,'22','242','1',1,'Sale Id shift 151',0.00,0.00,0.00,817.83,0.00,'2022-09-27 21:58:32','',''),(2102,'22','242','1',1,'Sale Id shift 151',0.00,0.00,0.00,1099.50,0.00,'2022-09-27 21:58:32','',''),(2103,'22','242',NULL,2,'Sale Id shift 151',1359845.20,0.00,0.00,0.00,0.00,'2022-09-27 21:58:32','',''),(2104,'22','242',NULL,1,'Sale Id shift 151',1032831.32,0.00,0.00,0.00,0.00,'2022-09-27 21:58:32','',''),(2105,'22','242','1',1,'Sale Id shift 152',0.00,0.00,0.00,660.91,0.00,'2022-09-29 09:44:12','',''),(2106,'22','242','2',1,'Sale Id shift 152',0.00,0.00,0.00,621.91,0.00,'2022-09-29 09:44:12','',''),(2107,'22','242','1',1,'Sale Id shift 152',0.00,0.00,0.00,519.26,0.00,'2022-09-29 09:44:12','',''),(2108,'22','242','2',1,'Sale Id shift 152',0.00,0.00,0.00,729.52,0.00,'2022-09-29 09:44:12','',''),(2109,'22','242','2',1,'Sale Id shift 152',0.00,0.00,0.00,852.47,0.00,'2022-09-29 09:44:12','',''),(2110,'22','242','2',1,'Sale Id shift 152',0.00,0.00,0.00,366.81,0.00,'2022-09-29 09:44:12','',''),(2111,'22','242','3',2,'Sale Id shift 152',0.00,0.00,0.00,500.89,0.00,'2022-09-29 09:44:12','',''),(2112,'22','242','3',2,'Sale Id shift 152',0.00,0.00,0.00,427.01,0.00,'2022-09-29 09:44:12','',''),(2113,'22','242','4',2,'Sale Id shift 152',0.00,0.00,0.00,1630.00,0.00,'2022-09-29 09:44:12','',''),(2114,'22','242','1',1,'Sale Id shift 152',0.00,0.00,0.00,1277.38,0.00,'2022-09-29 09:44:12','',''),(2115,'22','242','1',1,'Sale Id shift 152',0.00,0.00,0.00,1608.21,0.00,'2022-09-29 09:44:12','',''),(2116,'22','242','1',1,'Sale Id shift 152',0.00,0.00,0.00,899.82,0.00,'2022-09-29 09:44:12','',''),(2117,'22','242',NULL,2,'Sale Id shift 152',1944004.00,0.00,0.00,0.00,0.00,'2022-09-29 09:44:12','',''),(2118,'22','242',NULL,1,'Sale Id shift 152',1115370.92,0.00,0.00,0.00,0.00,'2022-09-29 09:44:12','',''),(2119,'22','242','1',1,'Sale Id shift 153',0.00,0.00,0.00,791.50,0.00,'2022-09-29 22:25:11','',''),(2120,'22','242','2',1,'Sale Id shift 153',0.00,0.00,0.00,935.09,0.00,'2022-09-29 22:25:11','',''),(2121,'22','242','1',1,'Sale Id shift 153',0.00,0.00,0.00,739.72,0.00,'2022-09-29 22:25:11','',''),(2122,'22','242','2',1,'Sale Id shift 153',0.00,0.00,0.00,1217.08,0.00,'2022-09-29 22:25:11','',''),(2123,'22','242','2',1,'Sale Id shift 153',0.00,0.00,0.00,532.48,0.00,'2022-09-29 22:25:11','',''),(2124,'22','242','2',1,'Sale Id shift 153',0.00,0.00,0.00,575.14,0.00,'2022-09-29 22:25:11','',''),(2125,'22','242','3',2,'Sale Id shift 153',0.00,0.00,0.00,408.99,0.00,'2022-09-29 22:25:11','',''),(2126,'22','242','3',2,'Sale Id shift 153',0.00,0.00,0.00,428.06,0.00,'2022-09-29 22:25:11','',''),(2127,'22','242','4',2,'Sale Id shift 153',0.00,0.00,0.00,650.00,0.00,'2022-09-29 22:25:11','',''),(2128,'22','242','1',1,'Sale Id shift 153',0.00,0.00,0.00,962.10,0.00,'2022-09-29 22:25:11','',''),(2129,'22','242','1',1,'Sale Id shift 153',0.00,0.00,0.00,1096.22,0.00,'2022-09-29 22:25:11','',''),(2130,'22','242','1',1,'Sale Id shift 153',0.00,0.00,0.00,1141.31,0.00,'2022-09-29 22:25:11','',''),(2131,'22','242',NULL,2,'Sale Id shift 153',1130158.00,0.00,0.00,0.00,0.00,'2022-09-29 22:25:11','',''),(2132,'22','242',NULL,1,'Sale Id shift 153',1182614.72,0.00,0.00,0.00,0.00,'2022-09-29 22:25:11','',''),(2133,'22','242','2',1,'Sale Id shift 154',0.00,0.00,0.00,1232.85,0.00,'2022-10-01 20:27:31','',''),(2134,'22','242','1',1,'Sale Id shift 154',0.00,0.00,0.00,882.11,0.00,'2022-10-01 20:27:31','',''),(2135,'22','242','2',1,'Sale Id shift 154',0.00,0.00,0.00,939.08,0.00,'2022-10-01 20:27:31','',''),(2136,'22','242','2',1,'Sale Id shift 154',0.00,0.00,0.00,969.39,0.00,'2022-10-01 20:27:31','',''),(2137,'22','242','2',1,'Sale Id shift 154',0.00,0.00,0.00,685.74,0.00,'2022-10-01 20:27:31','',''),(2138,'22','242','3',2,'Sale Id shift 154',0.00,0.00,0.00,440.96,0.00,'2022-10-01 20:27:31','',''),(2139,'22','242','3',2,'Sale Id shift 154',0.00,0.00,0.00,432.59,0.00,'2022-10-01 20:27:31','',''),(2140,'22','242','4',2,'Sale Id shift 154',0.00,0.00,0.00,640.00,0.00,'2022-10-01 20:27:31','',''),(2141,'22','242','1',1,'Sale Id shift 154',0.00,0.00,0.00,2330.10,0.00,'2022-10-01 20:27:31','',''),(2142,'22','242','1',1,'Sale Id shift 154',0.00,0.00,0.00,1432.84,0.00,'2022-10-01 20:27:31','',''),(2143,'22','242','1',1,'Sale Id shift 154',0.00,0.00,0.00,74.27,0.00,'2022-10-01 20:27:31','',''),(2144,'22','242',NULL,2,'Sale Id shift 154',1150298.00,0.00,0.00,0.00,0.00,'2022-10-01 20:27:31','',''),(2145,'22','242',NULL,1,'Sale Id shift 154',1264864.24,0.00,0.00,0.00,0.00,'2022-10-01 20:27:31','',''),(2146,'22','242','1',1,'Sale Id shift 155',0.00,0.00,0.00,485.27,0.00,'2022-10-01 21:07:13','',''),(2147,'22','242','2',1,'Sale Id shift 155',0.00,0.00,0.00,992.43,0.00,'2022-10-01 21:07:13','',''),(2148,'22','242','1',1,'Sale Id shift 155',0.00,0.00,0.00,250.66,0.00,'2022-10-01 21:07:13','',''),(2149,'22','242','2',1,'Sale Id shift 155',0.00,0.00,0.00,1026.45,0.00,'2022-10-01 21:07:13','',''),(2150,'22','242','2',1,'Sale Id shift 155',0.00,0.00,0.00,544.08,0.00,'2022-10-01 21:07:13','',''),(2151,'22','242','2',1,'Sale Id shift 155',0.00,0.00,0.00,530.79,0.00,'2022-10-01 21:07:13','',''),(2152,'22','242','3',2,'Sale Id shift 155',0.00,0.00,0.00,431.80,0.00,'2022-10-01 21:07:13','',''),(2153,'22','242','3',2,'Sale Id shift 155',0.00,0.00,0.00,148.21,0.00,'2022-10-01 21:07:13','',''),(2154,'22','242','4',2,'Sale Id shift 155',0.00,0.00,0.00,921.00,0.00,'2022-10-01 21:07:13','',''),(2155,'22','242','1',1,'Sale Id shift 155',0.00,0.00,0.00,1240.31,0.00,'2022-10-01 21:07:13','',''),(2156,'22','242','1',1,'Sale Id shift 155',0.00,0.00,0.00,1398.57,0.00,'2022-10-01 21:07:13','',''),(2157,'22','242','1',1,'Sale Id shift 155',0.00,0.00,0.00,793.83,0.00,'2022-10-01 21:07:13','',''),(2158,'22','242',NULL,2,'Sale Id shift 155',1140767.60,0.00,0.00,0.00,0.00,'2022-10-01 21:07:13','',''),(2159,'22','242',NULL,1,'Sale Id shift 155',1074833.72,0.00,0.00,0.00,0.00,'2022-10-01 21:07:13','',''),(2160,'22','242',NULL,1,'Purchased from PINNACLE OIL & GAS LIMITED ',0.00,6660000.00,45000.00,0.00,0.00,'2022-10-03 16:47:15','',''),(2161,'22','242',NULL,1,'Reception corrector for bridging 86',0.00,0.00,0.00,15000.00,0.00,'2022-10-03 16:48:41','',''),(2162,'22','242','2',1,'Received from bridging 86',0.00,0.00,15000.00,0.00,0.00,'2022-10-03 16:48:41','',''),(2163,'22','242',NULL,1,'Reception corrector for bridging 85',0.00,0.00,0.00,30000.00,0.00,'2022-10-03 16:48:51','',''),(2164,'22','242','1',1,'Received from bridging 85',0.00,0.00,30000.00,0.00,0.00,'2022-10-03 16:48:51','',''),(2165,'22','242','1',1,'Sale Id shift 156',0.00,0.00,0.00,139.94,0.00,'2022-10-03 16:54:37','',''),(2166,'22','242','2',1,'Sale Id shift 156',0.00,0.00,0.00,1202.36,0.00,'2022-10-03 16:54:37','',''),(2167,'22','242','1',1,'Sale Id shift 156',0.00,0.00,0.00,229.24,0.00,'2022-10-03 16:54:37','',''),(2168,'22','242','2',1,'Sale Id shift 156',0.00,0.00,0.00,386.42,0.00,'2022-10-03 16:54:37','',''),(2169,'22','242','2',1,'Sale Id shift 156',0.00,0.00,0.00,276.86,0.00,'2022-10-03 16:54:37','',''),(2170,'22','242','3',2,'Sale Id shift 156',0.00,0.00,0.00,54.89,0.00,'2022-10-03 16:54:37','',''),(2171,'22','242','3',2,'Sale Id shift 156',0.00,0.00,0.00,180.77,0.00,'2022-10-03 16:54:37','',''),(2172,'22','242','4',2,'Sale Id shift 156',0.00,0.00,0.00,300.00,0.00,'2022-10-03 16:54:37','',''),(2173,'22','242','1',1,'Sale Id shift 156',0.00,0.00,0.00,629.32,0.00,'2022-10-03 16:54:37','',''),(2174,'22','242','1',1,'Sale Id shift 156',0.00,0.00,0.00,900.07,0.00,'2022-10-03 16:54:37','',''),(2175,'22','242','1',1,'Sale Id shift 156',0.00,0.00,0.00,383.85,0.00,'2022-10-03 16:54:37','',''),(2176,'22','242',NULL,2,'Sale Id shift 156',407101.60,0.00,0.00,0.00,0.00,'2022-10-03 16:54:37','',''),(2177,'22','242',NULL,1,'Sale Id shift 156',613912.88,0.00,0.00,0.00,0.00,'2022-10-03 16:54:37','',''),(2178,'22','242','1',1,'Sale Id shift 157',0.00,0.00,0.00,978.56,0.00,'2022-10-04 11:01:53','',''),(2179,'22','242','2',1,'Sale Id shift 157',0.00,0.00,0.00,1074.69,0.00,'2022-10-04 11:01:53','',''),(2180,'22','242','1',1,'Sale Id shift 157',0.00,0.00,0.00,650.97,0.00,'2022-10-04 11:01:53','',''),(2181,'22','242','2',1,'Sale Id shift 157',0.00,0.00,0.00,761.23,0.00,'2022-10-04 11:01:53','',''),(2182,'22','242','2',1,'Sale Id shift 157',0.00,0.00,0.00,868.14,0.00,'2022-10-04 11:01:53','',''),(2183,'22','242','3',2,'Sale Id shift 157',0.00,0.00,0.00,515.18,0.00,'2022-10-04 11:01:53','',''),(2184,'22','242','3',2,'Sale Id shift 157',0.00,0.00,0.00,246.01,0.00,'2022-10-04 11:01:53','',''),(2185,'22','242','4',2,'Sale Id shift 157',0.00,0.00,0.00,550.00,0.00,'2022-10-04 11:01:53','',''),(2186,'22','242','1',1,'Sale Id shift 157',0.00,0.00,0.00,1060.99,0.00,'2022-10-04 11:01:53','',''),(2187,'22','242','1',1,'Sale Id shift 157',0.00,0.00,0.00,689.50,0.00,'2022-10-04 11:01:53','',''),(2188,'22','242','1',1,'Sale Id shift 157',0.00,0.00,0.00,1195.43,0.00,'2022-10-04 11:01:53','',''),(2189,'22','242',NULL,2,'Sale Id shift 157',996504.40,0.00,0.00,0.00,0.00,'2022-10-04 11:01:53','',''),(2190,'22','242',NULL,1,'Sale Id shift 157',1077367.48,0.00,0.00,0.00,0.00,'2022-10-04 11:01:53','',''),(2191,'22','242','1',1,'Sale Id shift 158',0.00,0.00,0.00,441.35,0.00,'2022-10-05 10:46:08','',''),(2192,'22','242','2',1,'Sale Id shift 158',0.00,0.00,0.00,352.26,0.00,'2022-10-05 10:46:08','',''),(2193,'22','242','1',1,'Sale Id shift 158',0.00,0.00,0.00,2720.35,0.00,'2022-10-05 10:46:08','',''),(2194,'22','242','2',1,'Sale Id shift 158',0.00,0.00,0.00,528.16,0.00,'2022-10-05 10:46:08','',''),(2195,'22','242','2',1,'Sale Id shift 158',0.00,0.00,0.00,1081.74,0.00,'2022-10-05 10:46:08','',''),(2196,'22','242','2',1,'Sale Id shift 158',0.00,0.00,0.00,1464.31,0.00,'2022-10-05 10:46:08','',''),(2197,'22','242','3',2,'Sale Id shift 158',0.00,0.00,0.00,216.76,0.00,'2022-10-05 10:46:08','',''),(2198,'22','242','3',2,'Sale Id shift 158',0.00,0.00,0.00,260.17,0.00,'2022-10-05 10:46:08','',''),(2199,'22','242','4',2,'Sale Id shift 158',0.00,0.00,0.00,470.10,0.00,'2022-10-05 10:46:08','',''),(2200,'22','242','1',1,'Sale Id shift 158',0.00,0.00,0.00,674.93,0.00,'2022-10-05 10:46:08','',''),(2201,'22','242','1',1,'Sale Id shift 158',0.00,0.00,0.00,361.45,0.00,'2022-10-05 10:46:08','',''),(2202,'22','242','1',1,'Sale Id shift 158',0.00,0.00,0.00,633.58,0.00,'2022-10-05 10:46:08','',''),(2203,'22','242',NULL,2,'Sale Id shift 158',719742.80,0.00,0.00,0.00,0.00,'2022-10-05 10:46:08','',''),(2204,'22','242',NULL,1,'Sale Id shift 158',1222203.24,0.00,0.00,0.00,0.00,'2022-10-05 10:46:08','',''),(2205,'22','242','1',1,'Sale Id shift 159',0.00,0.00,0.00,1034.29,0.00,'2022-10-05 21:46:29','',''),(2206,'22','242','2',1,'Sale Id shift 159',0.00,0.00,0.00,1402.66,0.00,'2022-10-05 21:46:29','',''),(2207,'22','242','1',1,'Sale Id shift 159',0.00,0.00,0.00,1103.13,0.00,'2022-10-05 21:46:29','',''),(2208,'22','242','2',1,'Sale Id shift 159',0.00,0.00,0.00,907.45,0.00,'2022-10-05 21:46:29','',''),(2209,'22','242','2',1,'Sale Id shift 159',0.00,0.00,0.00,600.80,0.00,'2022-10-05 21:46:29','',''),(2210,'22','242','2',1,'Sale Id shift 159',0.00,0.00,0.00,825.12,0.00,'2022-10-05 21:46:29','',''),(2211,'22','242','3',2,'Sale Id shift 159',0.00,0.00,0.00,429.77,0.00,'2022-10-05 21:46:29','',''),(2212,'22','242','3',2,'Sale Id shift 159',0.00,0.00,0.00,408.44,0.00,'2022-10-05 21:46:29','',''),(2213,'22','242','4',2,'Sale Id shift 159',0.00,0.00,0.00,500.00,0.00,'2022-10-05 21:46:29','',''),(2214,'22','242','1',1,'Sale Id shift 159',0.00,0.00,0.00,1058.51,0.00,'2022-10-05 21:46:29','',''),(2215,'22','242','1',1,'Sale Id shift 159',0.00,0.00,0.00,560.11,0.00,'2022-10-05 21:46:29','',''),(2216,'22','242','1',1,'Sale Id shift 159',0.00,0.00,0.00,1084.21,0.00,'2022-10-05 21:46:29','',''),(2217,'22','242',NULL,2,'Sale Id shift 159',1017039.60,0.00,0.00,0.00,0.00,'2022-10-05 21:46:29','',''),(2218,'22','242',NULL,1,'Sale Id shift 159',1269289.44,0.00,0.00,0.00,0.00,'2022-10-05 21:46:29','',''),(2219,'22','242','1',1,'Sale Id shift 160',0.00,0.00,0.00,664.24,0.00,'2022-10-09 09:41:38','',''),(2220,'22','242','2',1,'Sale Id shift 160',0.00,0.00,0.00,1989.81,0.00,'2022-10-09 09:41:38','',''),(2221,'22','242','1',1,'Sale Id shift 160',0.00,0.00,0.00,659.64,0.00,'2022-10-09 09:41:38','',''),(2222,'22','242','2',1,'Sale Id shift 160',0.00,0.00,0.00,848.15,0.00,'2022-10-09 09:41:38','',''),(2223,'22','242','2',1,'Sale Id shift 160',0.00,0.00,0.00,553.82,0.00,'2022-10-09 09:41:38','',''),(2224,'22','242','2',1,'Sale Id shift 160',0.00,0.00,0.00,287.31,0.00,'2022-10-09 09:41:38','',''),(2225,'22','242','3',2,'Sale Id shift 160',0.00,0.00,0.00,303.65,0.00,'2022-10-09 09:41:38','',''),(2226,'22','242','3',2,'Sale Id shift 160',0.00,0.00,0.00,385.90,0.00,'2022-10-09 09:41:38','',''),(2227,'22','242','4',2,'Sale Id shift 160',0.00,0.00,0.00,458.00,0.00,'2022-10-09 09:41:38','',''),(2228,'22','242','1',1,'Sale Id shift 160',0.00,0.00,0.00,1173.86,0.00,'2022-10-09 09:41:38','',''),(2229,'22','242','1',1,'Sale Id shift 160',0.00,0.00,0.00,520.96,0.00,'2022-10-09 09:41:38','',''),(2230,'22','242','1',1,'Sale Id shift 160',0.00,0.00,0.00,908.76,0.00,'2022-10-09 09:41:38','',''),(2231,'22','242',NULL,2,'Sale Id shift 160',872138.00,0.00,0.00,0.00,0.00,'2022-10-09 09:41:38','',''),(2232,'22','242',NULL,1,'Sale Id shift 160',1125769.40,0.00,0.00,0.00,0.00,'2022-10-09 09:41:38','',''),(2233,'22','242','1',1,'Sale Id shift 161',0.00,0.00,0.00,842.37,0.00,'2022-10-09 09:45:35','',''),(2234,'22','242','2',1,'Sale Id shift 161',0.00,0.00,0.00,574.03,0.00,'2022-10-09 09:45:35','',''),(2235,'22','242','1',1,'Sale Id shift 161',0.00,0.00,0.00,1008.97,0.00,'2022-10-09 09:45:35','',''),(2236,'22','242','2',1,'Sale Id shift 161',0.00,0.00,0.00,842.23,0.00,'2022-10-09 09:45:35','',''),(2237,'22','242','2',1,'Sale Id shift 161',0.00,0.00,0.00,463.57,0.00,'2022-10-09 09:45:35','',''),(2238,'22','242','2',1,'Sale Id shift 161',0.00,0.00,0.00,600.02,0.00,'2022-10-09 09:45:35','',''),(2239,'22','242','3',2,'Sale Id shift 161',0.00,0.00,0.00,331.51,0.00,'2022-10-09 09:45:35','',''),(2240,'22','242','3',2,'Sale Id shift 161',0.00,0.00,0.00,617.76,0.00,'2022-10-09 09:45:35','',''),(2241,'22','242','4',2,'Sale Id shift 161',0.00,0.00,0.00,1520.00,0.00,'2022-10-09 09:45:35','',''),(2242,'22','242','1',1,'Sale Id shift 161',0.00,0.00,0.00,1370.03,0.00,'2022-10-09 09:45:35','',''),(2243,'22','242','1',1,'Sale Id shift 161',0.00,0.00,0.00,605.21,0.00,'2022-10-09 09:45:35','',''),(2244,'22','242','1',1,'Sale Id shift 161',0.00,0.00,0.00,981.30,0.00,'2022-10-09 09:45:35','',''),(2245,'22','242',NULL,2,'Sale Id shift 161',1876645.20,0.00,0.00,0.00,0.00,'2022-10-09 09:45:35','',''),(2246,'22','242',NULL,1,'Sale Id shift 161',1078584.04,0.00,0.00,0.00,0.00,'2022-10-09 09:45:35','',''),(2247,'22','242','1',1,'Sale Id shift 162',0.00,0.00,0.00,533.26,0.00,'2022-10-09 09:49:19','',''),(2248,'22','242','2',1,'Sale Id shift 162',0.00,0.00,0.00,432.73,0.00,'2022-10-09 09:49:19','',''),(2249,'22','242','1',1,'Sale Id shift 162',0.00,0.00,0.00,1378.89,0.00,'2022-10-09 09:49:19','',''),(2250,'22','242','2',1,'Sale Id shift 162',0.00,0.00,0.00,231.54,0.00,'2022-10-09 09:49:19','',''),(2251,'22','242','2',1,'Sale Id shift 162',0.00,0.00,0.00,712.88,0.00,'2022-10-09 09:49:19','',''),(2252,'22','242','2',1,'Sale Id shift 162',0.00,0.00,0.00,1046.17,0.00,'2022-10-09 09:49:19','',''),(2253,'22','242','3',2,'Sale Id shift 162',0.00,0.00,0.00,277.23,0.00,'2022-10-09 09:49:19','',''),(2254,'22','242','3',2,'Sale Id shift 162',0.00,0.00,0.00,281.81,0.00,'2022-10-09 09:49:19','',''),(2255,'22','242','4',2,'Sale Id shift 162',0.00,0.00,0.00,1135.75,0.00,'2022-10-09 09:49:19','',''),(2256,'22','242','1',1,'Sale Id shift 162',0.00,0.00,0.00,923.15,0.00,'2022-10-09 09:49:19','',''),(2257,'22','242','1',1,'Sale Id shift 162',0.00,0.00,0.00,672.00,0.00,'2022-10-09 09:49:19','',''),(2258,'22','242','1',1,'Sale Id shift 162',0.00,0.00,0.00,841.96,0.00,'2022-10-09 09:49:19','',''),(2259,'22','242',NULL,2,'Sale Id shift 162',1288040.40,0.00,0.00,0.00,0.00,'2022-10-09 09:49:19','',''),(2260,'22','242',NULL,1,'Sale Id shift 162',1002341.84,0.00,0.00,0.00,0.00,'2022-10-09 09:49:19','',''),(2261,'22','242',NULL,1,'Purchased from PINNACLE OIL & GAS LIMITED ',0.00,6660000.00,45000.00,0.00,0.00,'2022-10-10 10:35:20','',''),(2262,'22','242',NULL,1,'Reception corrector for bridging 88',0.00,0.00,0.00,21600.00,0.00,'2022-10-10 10:47:30','',''),(2263,'22','242','2',1,'Received from bridging 88',0.00,0.00,21600.00,0.00,0.00,'2022-10-10 10:47:30','',''),(2264,'22','242',NULL,1,'Reception corrector for bridging 87',0.00,0.00,0.00,23400.00,0.00,'2022-10-10 10:47:44','',''),(2265,'22','242','1',1,'Received from bridging 87',0.00,0.00,23400.00,0.00,0.00,'2022-10-10 10:47:44','',''),(2266,'22','242','1',1,'Sale Id shift 163',0.00,0.00,0.00,426.03,0.00,'2022-10-10 11:06:59','',''),(2267,'22','242','2',1,'Sale Id shift 163',0.00,0.00,0.00,360.97,0.00,'2022-10-10 11:06:59','',''),(2268,'22','242','1',1,'Sale Id shift 163',0.00,0.00,0.00,108.20,0.00,'2022-10-10 11:06:59','',''),(2269,'22','242','2',1,'Sale Id shift 163',0.00,0.00,0.00,442.20,0.00,'2022-10-10 11:06:59','',''),(2270,'22','242','2',1,'Sale Id shift 163',0.00,0.00,0.00,146.96,0.00,'2022-10-10 11:06:59','',''),(2271,'22','242','3',2,'Sale Id shift 163',0.00,0.00,0.00,107.59,0.00,'2022-10-10 11:06:59','',''),(2272,'22','242','3',2,'Sale Id shift 163',0.00,0.00,0.00,178.55,0.00,'2022-10-10 11:06:59','',''),(2273,'22','242','4',2,'Sale Id shift 163',0.00,0.00,0.00,550.00,0.00,'2022-10-10 11:06:59','',''),(2274,'22','242','1',1,'Sale Id shift 163',0.00,0.00,0.00,549.76,0.00,'2022-10-10 11:06:59','',''),(2275,'22','242','1',1,'Sale Id shift 163',0.00,0.00,0.00,870.44,0.00,'2022-10-10 11:06:59','',''),(2276,'22','242','1',1,'Sale Id shift 163',0.00,0.00,0.00,706.25,0.00,'2022-10-10 11:06:59','',''),(2277,'22','242',NULL,2,'Sale Id shift 163',635466.40,0.00,0.00,0.00,0.00,'2022-10-10 11:06:59','',''),(2278,'22','242',NULL,1,'Sale Id shift 163',534399.88,0.00,0.00,0.00,0.00,'2022-10-10 11:06:59','',''),(2279,'22','242',NULL,2,'Purchased from NIPC0 PLC',0.00,34176440.00,44969.00,0.00,0.00,'2022-10-14 12:32:15','',''),(2280,'22','242',NULL,2,'Reception corrector for bridging 90',0.00,0.00,0.00,14969.00,0.00,'2022-10-14 12:34:13','',''),(2281,'22','242','4',2,'Received from bridging 90',0.00,0.00,14969.00,0.00,0.00,'2022-10-14 12:34:13','',''),(2282,'22','242','1',1,'Sale Id shift 164',0.00,0.00,0.00,374.21,0.00,'2022-10-14 12:39:48','',''),(2283,'22','242','2',1,'Sale Id shift 164',0.00,0.00,0.00,662.87,0.00,'2022-10-14 12:39:48','',''),(2284,'22','242','1',1,'Sale Id shift 164',0.00,0.00,0.00,485.84,0.00,'2022-10-14 12:39:48','',''),(2285,'22','242','2',1,'Sale Id shift 164',0.00,0.00,0.00,1184.68,0.00,'2022-10-14 12:39:48','',''),(2286,'22','242','2',1,'Sale Id shift 164',0.00,0.00,0.00,622.52,0.00,'2022-10-14 12:39:48','',''),(2287,'22','242','2',1,'Sale Id shift 164',0.00,0.00,0.00,472.35,0.00,'2022-10-14 12:39:48','',''),(2288,'22','242','3',2,'Sale Id shift 164',0.00,0.00,0.00,256.20,0.00,'2022-10-14 12:39:48','',''),(2289,'22','242','3',2,'Sale Id shift 164',0.00,0.00,0.00,216.91,0.00,'2022-10-14 12:39:48','',''),(2290,'22','242','1',1,'Sale Id shift 164',0.00,0.00,0.00,0.33,0.00,'2022-10-14 12:39:48','',''),(2291,'22','242','1',1,'Sale Id shift 164',0.00,0.00,0.00,2256.76,0.00,'2022-10-14 12:39:48','',''),(2292,'22','242','1',1,'Sale Id shift 164',0.00,0.00,0.00,949.33,0.00,'2022-10-14 12:39:48','',''),(2293,'22','242',NULL,2,'Sale Id shift 164',359563.60,0.00,0.00,0.00,0.00,'2022-10-14 12:39:48','',''),(2294,'22','242',NULL,1,'Sale Id shift 164',1037315.72,0.00,0.00,0.00,0.00,'2022-10-14 12:39:48','',''),(2295,'22','242','1',1,'Sale Id shift 165',0.00,0.00,0.00,989.78,0.00,'2022-10-14 12:44:12','',''),(2296,'22','242','2',1,'Sale Id shift 165',0.00,0.00,0.00,626.62,0.00,'2022-10-14 12:44:12','',''),(2297,'22','242','1',1,'Sale Id shift 165',0.00,0.00,0.00,708.83,0.00,'2022-10-14 12:44:12','',''),(2298,'22','242','2',1,'Sale Id shift 165',0.00,0.00,0.00,964.39,0.00,'2022-10-14 12:44:12','',''),(2299,'22','242','2',1,'Sale Id shift 165',0.00,0.00,0.00,660.66,0.00,'2022-10-14 12:44:12','',''),(2300,'22','242','2',1,'Sale Id shift 165',0.00,0.00,0.00,594.46,0.00,'2022-10-14 12:44:12','',''),(2301,'22','242','3',2,'Sale Id shift 165',0.00,0.00,0.00,353.89,0.00,'2022-10-14 12:44:12','',''),(2302,'22','242','3',2,'Sale Id shift 165',0.00,0.00,0.00,379.17,0.00,'2022-10-14 12:44:12','',''),(2303,'22','242','4',2,'Sale Id shift 165',0.00,0.00,0.00,330.00,0.00,'2022-10-14 12:44:12','',''),(2304,'22','242','1',1,'Sale Id shift 165',0.00,0.00,0.00,735.24,0.00,'2022-10-14 12:44:12','',''),(2305,'22','242','1',1,'Sale Id shift 165',0.00,0.00,0.00,1320.57,0.00,'2022-10-14 12:44:12','',''),(2306,'22','242','1',1,'Sale Id shift 165',0.00,0.00,0.00,918.95,0.00,'2022-10-14 12:44:12','',''),(2307,'22','242',NULL,2,'Sale Id shift 165',807925.60,0.00,0.00,0.00,0.00,'2022-10-14 12:44:12','',''),(2308,'22','242',NULL,1,'Sale Id shift 165',1112886.00,0.00,0.00,0.00,0.00,'2022-10-14 12:44:12','',''),(2309,'22','242','1',1,'Sale Id shift 166',0.00,0.00,0.00,830.74,0.00,'2022-10-14 12:48:43','',''),(2310,'22','242','2',1,'Sale Id shift 166',0.00,0.00,0.00,497.19,0.00,'2022-10-14 12:48:43','',''),(2311,'22','242','1',1,'Sale Id shift 166',0.00,0.00,0.00,462.41,0.00,'2022-10-14 12:48:43','',''),(2312,'22','242','2',1,'Sale Id shift 166',0.00,0.00,0.00,944.41,0.00,'2022-10-14 12:48:43','',''),(2313,'22','242','2',1,'Sale Id shift 166',0.00,0.00,0.00,743.57,0.00,'2022-10-14 12:48:43','',''),(2314,'22','242','2',1,'Sale Id shift 166',0.00,0.00,0.00,1170.99,0.00,'2022-10-14 12:48:43','',''),(2315,'22','242','3',2,'Sale Id shift 166',0.00,0.00,0.00,501.19,0.00,'2022-10-14 12:48:43','',''),(2316,'22','242','3',2,'Sale Id shift 166',0.00,0.00,0.00,463.41,0.00,'2022-10-14 12:48:43','',''),(2317,'22','242','4',2,'Sale Id shift 166',0.00,0.00,0.00,430.00,0.00,'2022-10-14 12:48:43','',''),(2318,'22','242','1',1,'Sale Id shift 166',0.00,0.00,0.00,1296.85,0.00,'2022-10-14 12:48:43','',''),(2319,'22','242','1',1,'Sale Id shift 166',0.00,0.00,0.00,809.41,0.00,'2022-10-14 12:48:43','',''),(2320,'22','242','1',1,'Sale Id shift 166',0.00,0.00,0.00,779.41,0.00,'2022-10-14 12:48:43','',''),(2321,'22','242',NULL,2,'Sale Id shift 166',1059896.00,0.00,0.00,0.00,0.00,'2022-10-14 12:48:43','',''),(2322,'22','242',NULL,1,'Sale Id shift 166',1115177.04,0.00,0.00,0.00,0.00,'2022-10-14 12:48:43','',''),(2323,'22','242','1',1,'Sale Id shift 167',0.00,0.00,0.00,725.59,0.00,'2022-10-14 12:52:15','',''),(2324,'22','242','2',1,'Sale Id shift 167',0.00,0.00,0.00,1087.48,0.00,'2022-10-14 12:52:15','',''),(2325,'22','242','1',1,'Sale Id shift 167',0.00,0.00,0.00,462.90,0.00,'2022-10-14 12:52:15','',''),(2326,'22','242','2',1,'Sale Id shift 167',0.00,0.00,0.00,974.37,0.00,'2022-10-14 12:52:15','',''),(2327,'22','242','2',1,'Sale Id shift 167',0.00,0.00,0.00,193.84,0.00,'2022-10-14 12:52:15','',''),(2328,'22','242','2',1,'Sale Id shift 167',0.00,0.00,0.00,661.66,0.00,'2022-10-14 12:52:15','',''),(2329,'22','242','3',2,'Sale Id shift 167',0.00,0.00,0.00,413.14,0.00,'2022-10-14 12:52:15','',''),(2330,'22','242','3',2,'Sale Id shift 167',0.00,0.00,0.00,330.25,0.00,'2022-10-14 12:52:15','',''),(2331,'22','242','4',2,'Sale Id shift 167',0.00,0.00,0.00,732.88,0.00,'2022-10-14 12:52:15','',''),(2332,'22','242','1',1,'Sale Id shift 167',0.00,0.00,0.00,879.95,0.00,'2022-10-14 12:52:15','',''),(2333,'22','242','1',1,'Sale Id shift 167',0.00,0.00,0.00,658.42,0.00,'2022-10-14 12:52:15','',''),(2334,'22','242','1',1,'Sale Id shift 167',0.00,0.00,0.00,1013.87,0.00,'2022-10-14 12:52:15','',''),(2335,'22','242',NULL,2,'Sale Id shift 167',1121965.20,0.00,0.00,0.00,0.00,'2022-10-14 12:52:15','',''),(2336,'22','242',NULL,1,'Sale Id shift 167',985395.84,0.00,0.00,0.00,0.00,'2022-10-14 12:52:15','',''),(2337,'22','242','1',1,'Sale Id shift 168',0.00,0.00,0.00,710.78,0.00,'2022-10-15 10:27:29','',''),(2338,'22','242','1',1,'Sale Id shift 168',0.00,0.00,0.00,894.57,0.00,'2022-10-15 10:27:29','',''),(2339,'22','242','2',1,'Sale Id shift 168',0.00,0.00,0.00,1102.76,0.00,'2022-10-15 10:27:29','',''),(2340,'22','242','2',1,'Sale Id shift 168',0.00,0.00,0.00,290.38,0.00,'2022-10-15 10:27:29','',''),(2341,'22','242','2',1,'Sale Id shift 168',0.00,0.00,0.00,490.55,0.00,'2022-10-15 10:27:29','',''),(2342,'22','242','3',2,'Sale Id shift 168',0.00,0.00,0.00,216.45,0.00,'2022-10-15 10:27:29','',''),(2343,'22','242','3',2,'Sale Id shift 168',0.00,0.00,0.00,398.29,0.00,'2022-10-15 10:27:29','',''),(2344,'22','242','4',2,'Sale Id shift 168',0.00,0.00,0.00,250.00,0.00,'2022-10-15 10:27:29','',''),(2345,'22','242','1',1,'Sale Id shift 168',0.00,0.00,0.00,1308.49,0.00,'2022-10-15 10:27:29','',''),(2346,'22','242','1',1,'Sale Id shift 168',0.00,0.00,0.00,1442.63,0.00,'2022-10-15 10:27:29','',''),(2347,'22','242','1',1,'Sale Id shift 168',0.00,0.00,0.00,913.08,0.00,'2022-10-15 10:27:29','',''),(2348,'22','242',NULL,2,'Sale Id shift 168',657202.40,0.00,0.00,0.00,0.00,'2022-10-15 10:27:29','',''),(2349,'22','242',NULL,1,'Sale Id shift 168',1058679.52,0.00,0.00,0.00,0.00,'2022-10-15 10:27:29','',''),(2350,'22','242','1',1,'Sale Id shift 169',0.00,0.00,0.00,752.50,0.00,'2022-10-16 13:08:39','',''),(2351,'22','242','2',1,'Sale Id shift 169',0.00,0.00,0.00,1175.45,0.00,'2022-10-16 13:08:39','',''),(2352,'22','242','1',1,'Sale Id shift 169',0.00,0.00,0.00,630.19,0.00,'2022-10-16 13:08:39','',''),(2353,'22','242','2',1,'Sale Id shift 169',0.00,0.00,0.00,1489.27,0.00,'2022-10-16 13:08:39','',''),(2354,'22','242','2',1,'Sale Id shift 169',0.00,0.00,0.00,349.27,0.00,'2022-10-16 13:08:39','',''),(2355,'22','242','2',1,'Sale Id shift 169',0.00,0.00,0.00,441.80,0.00,'2022-10-16 13:08:39','',''),(2356,'22','242','3',2,'Sale Id shift 169',0.00,0.00,0.00,246.33,0.00,'2022-10-16 13:08:39','',''),(2357,'22','242','3',2,'Sale Id shift 169',0.00,0.00,0.00,496.96,0.00,'2022-10-16 13:08:39','',''),(2358,'22','242','4',2,'Sale Id shift 169',0.00,0.00,0.00,2137.00,0.00,'2022-10-16 13:08:39','',''),(2359,'22','242','1',1,'Sale Id shift 169',0.00,0.00,0.00,940.69,0.00,'2022-10-16 13:08:39','',''),(2360,'22','242','1',1,'Sale Id shift 169',0.00,0.00,0.00,933.68,0.00,'2022-10-16 13:08:39','',''),(2361,'22','242','1',1,'Sale Id shift 169',0.00,0.00,0.00,842.39,0.00,'2022-10-16 13:08:39','',''),(2362,'22','242',NULL,2,'Sale Id shift 169',2189020.40,0.00,0.00,0.00,0.00,'2022-10-16 13:08:39','',''),(2363,'22','242',NULL,1,'Sale Id shift 169',1118175.52,0.00,0.00,0.00,0.00,'2022-10-16 13:08:39','',''),(2364,'22','242','1',1,'Sale Id shift 170',0.00,0.00,0.00,1142.38,0.00,'2022-10-17 15:35:40','',''),(2365,'22','242','1',1,'Sale Id shift 170',0.00,0.00,0.00,629.16,0.00,'2022-10-17 15:35:40','',''),(2366,'22','242','2',1,'Sale Id shift 170',0.00,0.00,0.00,408.98,0.00,'2022-10-17 15:35:40','',''),(2367,'22','242','2',1,'Sale Id shift 170',0.00,0.00,0.00,216.92,0.00,'2022-10-17 15:35:40','',''),(2368,'22','242','2',1,'Sale Id shift 170',0.00,0.00,0.00,176.18,0.00,'2022-10-17 15:35:40','',''),(2369,'22','242','3',2,'Sale Id shift 170',0.00,0.00,0.00,99.92,0.00,'2022-10-17 15:35:40','',''),(2370,'22','242','3',2,'Sale Id shift 170',0.00,0.00,0.00,210.65,0.00,'2022-10-17 15:35:40','',''),(2371,'22','242','4',2,'Sale Id shift 170',0.00,0.00,0.00,200.00,0.00,'2022-10-17 15:35:40','',''),(2372,'22','242','1',1,'Sale Id shift 170',0.00,0.00,0.00,297.83,0.00,'2022-10-17 15:35:40','',''),(2373,'22','242','1',1,'Sale Id shift 170',0.00,0.00,0.00,509.88,0.00,'2022-10-17 15:35:40','',''),(2374,'22','242','1',1,'Sale Id shift 170',0.00,0.00,0.00,813.62,0.00,'2022-10-17 15:35:40','',''),(2375,'22','242',NULL,2,'Sale Id shift 170',388033.20,0.00,0.00,0.00,0.00,'2022-10-17 15:35:40','',''),(2376,'22','242',NULL,1,'Sale Id shift 170',620852.60,0.00,0.00,0.00,0.00,'2022-10-17 15:35:40','',''),(2377,'22','242',NULL,2,'Reception corrector for bridging 92',0.00,0.00,0.00,17000.00,0.00,'2022-11-02 16:07:59','',''),(2378,'22','242','4',2,'Received from bridging 92',0.00,0.00,17000.00,0.00,0.00,'2022-11-02 16:07:59','',''),(2379,'22','242',NULL,2,'Reception corrector for bridging 91',0.00,0.00,0.00,13000.00,0.00,'2022-11-02 16:08:12','',''),(2380,'22','242','3',2,'Received from bridging 91',0.00,0.00,13000.00,0.00,0.00,'2022-11-02 16:08:12','',''),(2381,'22','242',NULL,1,'Purchased from NIPC0 PLC',0.00,6660000.00,45000.00,0.00,0.00,'2022-11-14 22:03:01','',''),(2382,'22','242',NULL,1,'Reception corrector for bridging 94',0.00,0.00,0.00,15000.00,0.00,'2022-11-14 22:06:26','',''),(2383,'22','242','2',1,'Received from bridging 94',0.00,0.00,15000.00,0.00,0.00,'2022-11-14 22:06:26','',''),(2384,'22','242',NULL,1,'Reception corrector for bridging 93',0.00,0.00,0.00,30000.00,0.00,'2022-11-14 22:06:42','',''),(2385,'22','242','1',1,'Received from bridging 93',0.00,0.00,30000.00,0.00,0.00,'2022-11-14 22:06:42','',''),(2386,'22','242','1',1,'Sale Id shift 171',0.00,0.00,0.00,874.29,0.00,'2022-11-15 12:50:30','',''),(2387,'22','242','2',1,'Sale Id shift 171',0.00,0.00,0.00,766.00,0.00,'2022-11-15 12:50:30','',''),(2388,'22','242','1',1,'Sale Id shift 171',0.00,0.00,0.00,711.61,0.00,'2022-11-15 12:50:30','',''),(2389,'22','242','2',1,'Sale Id shift 171',0.00,0.00,0.00,1304.13,0.00,'2022-11-15 12:50:30','',''),(2390,'22','242','2',1,'Sale Id shift 171',0.00,0.00,0.00,409.09,0.00,'2022-11-15 12:50:30','',''),(2391,'22','242','2',1,'Sale Id shift 171',0.00,0.00,0.00,700.58,0.00,'2022-11-15 12:50:30','',''),(2392,'22','242','3',2,'Sale Id shift 171',0.00,0.00,0.00,376.11,0.00,'2022-11-15 12:50:30','',''),(2393,'22','242','3',2,'Sale Id shift 171',0.00,0.00,0.00,388.90,0.00,'2022-11-15 12:50:30','',''),(2394,'22','242','4',2,'Sale Id shift 171',0.00,0.00,0.00,270.00,0.00,'2022-11-15 12:50:30','',''),(2395,'22','242','1',1,'Sale Id shift 171',0.00,0.00,0.00,1170.80,0.00,'2022-11-15 12:50:30','',''),(2396,'22','242','1',1,'Sale Id shift 171',0.00,0.00,0.00,738.97,0.00,'2022-11-15 12:50:30','',''),(2397,'22','242','1',1,'Sale Id shift 171',0.00,0.00,0.00,669.69,0.00,'2022-11-15 12:50:30','',''),(2398,'22','242',NULL,2,'Sale Id shift 171',786607.60,0.00,0.00,0.00,0.00,'2022-11-15 12:50:30','',''),(2399,'22','242',NULL,1,'Sale Id shift 171',1087083.68,0.00,0.00,0.00,0.00,'2022-11-15 12:50:30','',''),(2400,'22','242','1',1,'Sale Id shift 172',0.00,0.00,0.00,584.91,0.00,'2022-11-15 12:55:41','',''),(2401,'22','242','2',1,'Sale Id shift 172',0.00,0.00,0.00,299.75,0.00,'2022-11-15 12:55:41','',''),(2402,'22','242','1',1,'Sale Id shift 172',0.00,0.00,0.00,870.19,0.00,'2022-11-15 12:55:41','',''),(2403,'22','242','2',1,'Sale Id shift 172',0.00,0.00,0.00,1879.32,0.00,'2022-11-15 12:55:41','',''),(2404,'22','242','2',1,'Sale Id shift 172',0.00,0.00,0.00,569.26,0.00,'2022-11-15 12:55:41','',''),(2405,'22','242','2',1,'Sale Id shift 172',0.00,0.00,0.00,564.10,0.00,'2022-11-15 12:55:41','',''),(2406,'22','242','3',2,'Sale Id shift 172',0.00,0.00,0.00,270.51,0.00,'2022-11-15 12:55:41','',''),(2407,'22','242','3',2,'Sale Id shift 172',0.00,0.00,0.00,399.33,0.00,'2022-11-15 12:55:41','',''),(2408,'22','242','4',2,'Sale Id shift 172',0.00,0.00,0.00,440.00,0.00,'2022-11-15 12:55:41','',''),(2409,'22','242','1',1,'Sale Id shift 172',0.00,0.00,0.00,2082.47,0.00,'2022-11-15 12:55:41','',''),(2410,'22','242','1',1,'Sale Id shift 172',0.00,0.00,0.00,802.07,0.00,'2022-11-15 12:55:41','',''),(2411,'22','242','1',1,'Sale Id shift 172',0.00,0.00,0.00,644.15,0.00,'2022-11-15 12:55:41','',''),(2412,'22','242',NULL,2,'Sale Id shift 172',843478.40,0.00,0.00,0.00,0.00,'2022-11-15 12:55:41','',''),(2413,'22','242',NULL,1,'Sale Id shift 172',1227840.56,0.00,0.00,0.00,0.00,'2022-11-15 12:55:41','',''),(2414,'22','242','1',1,'Sale Id shift 173',0.00,0.00,0.00,971.03,0.00,'2022-11-15 13:00:58','',''),(2415,'22','242','2',1,'Sale Id shift 173',0.00,0.00,0.00,731.91,0.00,'2022-11-15 13:00:58','',''),(2416,'22','242','1',1,'Sale Id shift 173',0.00,0.00,0.00,685.64,0.00,'2022-11-15 13:00:58','',''),(2417,'22','242','2',1,'Sale Id shift 173',0.00,0.00,0.00,1471.55,0.00,'2022-11-15 13:00:58','',''),(2418,'22','242','2',1,'Sale Id shift 173',0.00,0.00,0.00,277.98,0.00,'2022-11-15 13:00:58','',''),(2419,'22','242','2',1,'Sale Id shift 173',0.00,0.00,0.00,592.30,0.00,'2022-11-15 13:00:58','',''),(2420,'22','242','3',2,'Sale Id shift 173',0.00,0.00,0.00,277.49,0.00,'2022-11-15 13:00:58','',''),(2421,'22','242','3',2,'Sale Id shift 173',0.00,0.00,0.00,331.08,0.00,'2022-11-15 13:00:58','',''),(2422,'22','242','4',2,'Sale Id shift 173',0.00,0.00,0.00,300.00,0.00,'2022-11-15 13:00:58','',''),(2423,'22','242','1',1,'Sale Id shift 173',0.00,0.00,0.00,1065.51,0.00,'2022-11-15 13:00:58','',''),(2424,'22','242','1',1,'Sale Id shift 173',0.00,0.00,0.00,517.74,0.00,'2022-11-15 13:00:58','',''),(2425,'22','242','1',1,'Sale Id shift 173',0.00,0.00,0.00,918.28,0.00,'2022-11-15 13:00:58','',''),(2426,'22','242',NULL,2,'Sale Id shift 173',690513.20,0.00,0.00,0.00,0.00,'2022-11-15 13:00:58','',''),(2427,'22','242',NULL,1,'Sale Id shift 173',1070327.12,0.00,0.00,0.00,0.00,'2022-11-15 13:00:58','',''),(2428,'22','242','1',1,'Sale Id shift 174',0.00,0.00,0.00,820.68,0.00,'2022-11-15 13:06:56','',''),(2429,'22','242','2',1,'Sale Id shift 174',0.00,0.00,0.00,525.12,0.00,'2022-11-15 13:06:56','',''),(2430,'22','242','1',1,'Sale Id shift 174',0.00,0.00,0.00,913.87,0.00,'2022-11-15 13:06:56','',''),(2431,'22','242','2',1,'Sale Id shift 174',0.00,0.00,0.00,1170.43,0.00,'2022-11-15 13:06:56','',''),(2432,'22','242','2',1,'Sale Id shift 174',0.00,0.00,0.00,391.60,0.00,'2022-11-15 13:06:56','',''),(2433,'22','242','2',1,'Sale Id shift 174',0.00,0.00,0.00,729.94,0.00,'2022-11-15 13:06:56','',''),(2434,'22','242','3',2,'Sale Id shift 174',0.00,0.00,0.00,181.84,0.00,'2022-11-15 13:06:56','',''),(2435,'22','242','3',2,'Sale Id shift 174',0.00,0.00,0.00,338.32,0.00,'2022-11-15 13:06:56','',''),(2436,'22','242','4',2,'Sale Id shift 174',0.00,0.00,0.00,1850.00,0.00,'2022-11-15 13:06:56','',''),(2437,'22','242','1',1,'Sale Id shift 174',0.00,0.00,0.00,825.09,0.00,'2022-11-15 13:06:56','',''),(2438,'22','242','1',1,'Sale Id shift 174',0.00,0.00,0.00,712.29,0.00,'2022-11-15 13:06:56','',''),(2439,'22','242','1',1,'Sale Id shift 174',0.00,0.00,0.00,778.06,0.00,'2022-11-15 13:06:56','',''),(2440,'22','242',NULL,2,'Sale Id shift 174',1801321.60,0.00,0.00,0.00,0.00,'2022-11-15 13:06:57','',''),(2441,'22','242',NULL,1,'Sale Id shift 174',1016327.84,0.00,0.00,0.00,0.00,'2022-11-15 13:06:57','',''),(2442,'22','242','1',1,'Sale Id shift 175',0.00,0.00,0.00,300.62,0.00,'2022-11-15 13:12:55','',''),(2443,'22','242','2',1,'Sale Id shift 175',0.00,0.00,0.00,856.36,0.00,'2022-11-15 13:12:55','',''),(2444,'22','242','1',1,'Sale Id shift 175',0.00,0.00,0.00,844.89,0.00,'2022-11-15 13:12:55','',''),(2445,'22','242','2',1,'Sale Id shift 175',0.00,0.00,0.00,1385.31,0.00,'2022-11-15 13:12:55','',''),(2446,'22','242','2',1,'Sale Id shift 175',0.00,0.00,0.00,370.97,0.00,'2022-11-15 13:12:55','',''),(2447,'22','242','2',1,'Sale Id shift 175',0.00,0.00,0.00,558.63,0.00,'2022-11-15 13:12:55','',''),(2448,'22','242','3',2,'Sale Id shift 175',0.00,0.00,0.00,251.72,0.00,'2022-11-15 13:12:55','',''),(2449,'22','242','3',2,'Sale Id shift 175',0.00,0.00,0.00,477.05,0.00,'2022-11-15 13:12:55','',''),(2450,'22','242','4',2,'Sale Id shift 175',0.00,0.00,0.00,621.76,0.00,'2022-11-15 13:12:55','',''),(2451,'22','242','1',1,'Sale Id shift 175',0.00,0.00,0.00,637.44,0.00,'2022-11-15 13:12:55','',''),(2452,'22','242','1',1,'Sale Id shift 175',0.00,0.00,0.00,534.62,0.00,'2022-11-15 13:12:55','',''),(2453,'22','242','1',1,'Sale Id shift 175',0.00,0.00,0.00,307.35,0.00,'2022-11-15 13:12:55','',''),(2454,'22','242',NULL,2,'Sale Id shift 175',1026402.80,0.00,0.00,0.00,0.00,'2022-11-15 13:12:55','',''),(2455,'22','242',NULL,1,'Sale Id shift 175',857836.12,0.00,0.00,0.00,0.00,'2022-11-15 13:12:55','',''),(2456,'22','242','2',1,'Sale Id shift 176',0.00,0.00,0.00,339.79,0.00,'2022-11-15 13:18:24','',''),(2457,'22','242','2',1,'Sale Id shift 176',0.00,0.00,0.00,341.02,0.00,'2022-11-15 13:18:24','',''),(2458,'22','242','2',1,'Sale Id shift 176',0.00,0.00,0.00,390.45,0.00,'2022-11-15 13:18:24','',''),(2459,'22','242','2',1,'Sale Id shift 176',0.00,0.00,0.00,396.00,0.00,'2022-11-15 13:18:24','',''),(2460,'22','242','3',2,'Sale Id shift 176',0.00,0.00,0.00,271.09,0.00,'2022-11-15 13:18:24','',''),(2461,'22','242','3',2,'Sale Id shift 176',0.00,0.00,0.00,361.06,0.00,'2022-11-15 13:18:24','',''),(2462,'22','242','4',2,'Sale Id shift 176',0.00,0.00,0.00,1338.00,0.00,'2022-11-15 13:18:24','',''),(2463,'22','242',NULL,2,'Sale Id shift 176',1497314.00,0.00,0.00,0.00,0.00,'2022-11-15 13:18:24','',''),(2464,'22','242',NULL,1,'Sale Id shift 176',217154.48,0.00,0.00,0.00,0.00,'2022-11-15 13:18:24','',''),(2465,'22','242','2',1,'Sale Id shift 177',0.00,0.00,0.00,494.28,0.00,'2022-11-15 13:22:57','',''),(2466,'22','242','2',1,'Sale Id shift 177',0.00,0.00,0.00,269.46,0.00,'2022-11-15 13:22:57','',''),(2467,'22','242','2',1,'Sale Id shift 177',0.00,0.00,0.00,111.52,0.00,'2022-11-15 13:22:57','',''),(2468,'22','242','2',1,'Sale Id shift 177',0.00,0.00,0.00,50.93,0.00,'2022-11-15 13:22:57','',''),(2469,'22','242','3',2,'Sale Id shift 177',0.00,0.00,0.00,65.25,0.00,'2022-11-15 13:22:57','',''),(2470,'22','242','3',2,'Sale Id shift 177',0.00,0.00,0.00,154.78,0.00,'2022-11-15 13:22:57','',''),(2471,'22','242','4',2,'Sale Id shift 177',0.00,0.00,0.00,200.00,0.00,'2022-11-15 13:22:57','',''),(2472,'22','242',NULL,2,'Sale Id shift 177',319222.80,0.00,0.00,0.00,0.00,'2022-11-15 13:22:57','',''),(2473,'22','242',NULL,1,'Sale Id shift 177',137076.12,0.00,0.00,0.00,0.00,'2022-11-15 13:22:57','',''),(2474,'22','242','2',1,'Sale Id shift 178',0.00,0.00,0.00,89.28,0.00,'2022-11-15 13:25:26','',''),(2475,'22','242','3',2,'Sale Id shift 178',0.00,0.00,0.00,299.08,0.00,'2022-11-15 13:25:26','',''),(2476,'22','242','3',2,'Sale Id shift 178',0.00,0.00,0.00,510.20,0.00,'2022-11-15 13:25:26','',''),(2477,'22','242','4',2,'Sale Id shift 178',0.00,0.00,0.00,1030.00,0.00,'2022-11-15 13:25:26','',''),(2478,'22','242',NULL,2,'Sale Id shift 178',1397852.80,0.00,0.00,0.00,0.00,'2022-11-15 13:25:26','',''),(2479,'22','242',NULL,1,'Sale Id shift 178',13213.44,0.00,0.00,0.00,0.00,'2022-11-15 13:25:26','',''),(2480,'22','242','2',1,'Sale Id shift 179',0.00,0.00,0.00,17.14,0.00,'2022-11-15 13:28:11','',''),(2481,'22','242','2',1,'Sale Id shift 179',0.00,0.00,0.00,420.59,0.00,'2022-11-15 13:28:11','',''),(2482,'22','242','3',2,'Sale Id shift 179',0.00,0.00,0.00,452.24,0.00,'2022-11-15 13:28:11','',''),(2483,'22','242','3',2,'Sale Id shift 179',0.00,0.00,0.00,633.47,0.00,'2022-11-15 13:28:11','',''),(2484,'22','242','4',2,'Sale Id shift 179',0.00,0.00,0.00,1230.00,0.00,'2022-11-15 13:28:11','',''),(2485,'22','242',NULL,2,'Sale Id shift 179',1759939.60,0.00,0.00,0.00,0.00,'2022-11-15 13:28:11','',''),(2486,'22','242',NULL,1,'Sale Id shift 179',64784.04,0.00,0.00,0.00,0.00,'2022-11-15 13:28:11','',''),(2487,'22','242','2',1,'Sale Id shift 180',0.00,0.00,0.00,371.09,0.00,'2022-11-15 13:30:16','',''),(2488,'22','242','3',2,'Sale Id shift 180',0.00,0.00,0.00,508.30,0.00,'2022-11-15 13:30:16','',''),(2489,'22','242','3',2,'Sale Id shift 180',0.00,0.00,0.00,519.03,0.00,'2022-11-15 13:30:16','',''),(2490,'22','242','4',2,'Sale Id shift 180',0.00,0.00,0.00,810.00,0.00,'2022-11-15 13:30:16','',''),(2491,'22','242',NULL,2,'Sale Id shift 180',1396370.80,0.00,0.00,0.00,0.00,'2022-11-15 13:30:16','',''),(2492,'22','242',NULL,1,'Sale Id shift 180',54921.32,0.00,0.00,0.00,0.00,'2022-11-15 13:30:16','',''),(2493,'22','242','1',1,'Sale Id shift 181',0.00,0.00,0.00,388.01,0.00,'2022-11-15 13:34:02','',''),(2494,'22','242','2',1,'Sale Id shift 181',0.00,0.00,0.00,1137.37,0.00,'2022-11-15 13:34:02','',''),(2495,'22','242','1',1,'Sale Id shift 181',0.00,0.00,0.00,471.91,0.00,'2022-11-15 13:34:02','',''),(2496,'22','242','2',1,'Sale Id shift 181',0.00,0.00,0.00,1134.87,0.00,'2022-11-15 13:34:02','',''),(2497,'22','242','2',1,'Sale Id shift 181',0.00,0.00,0.00,303.36,0.00,'2022-11-15 13:34:02','',''),(2498,'22','242','2',1,'Sale Id shift 181',0.00,0.00,0.00,626.71,0.00,'2022-11-15 13:34:02','',''),(2499,'22','242','3',2,'Sale Id shift 181',0.00,0.00,0.00,292.60,0.00,'2022-11-15 13:34:02','',''),(2500,'22','242','3',2,'Sale Id shift 181',0.00,0.00,0.00,508.96,0.00,'2022-11-15 13:34:02','',''),(2501,'22','242','4',2,'Sale Id shift 181',0.00,0.00,0.00,850.00,0.00,'2022-11-15 13:34:02','',''),(2502,'22','242','1',1,'Sale Id shift 181',0.00,0.00,0.00,563.47,0.00,'2022-11-15 13:34:02','',''),(2503,'22','242','1',1,'Sale Id shift 181',0.00,0.00,0.00,393.12,0.00,'2022-11-15 13:34:02','',''),(2504,'22','242','1',1,'Sale Id shift 181',0.00,0.00,0.00,239.93,0.00,'2022-11-15 13:34:02','',''),(2505,'22','242',NULL,2,'Sale Id shift 181',1255185.60,0.00,0.00,0.00,0.00,'2022-11-15 13:34:02','',''),(2506,'22','242',NULL,1,'Sale Id shift 181',778295.00,0.00,0.00,0.00,0.00,'2022-11-15 13:34:02','',''),(2507,'22','242',NULL,1,'Purchased from PINNACLE OIL & GAS LIMITED ',0.00,6660000.00,45000.00,0.00,0.00,'2022-11-16 15:58:26','',''),(2508,'22','242',NULL,1,'Reception corrector for bridging 96',0.00,0.00,0.00,30000.00,0.00,'2022-11-16 16:00:05','',''),(2509,'22','242','2',1,'Received from bridging 96',0.00,0.00,30000.00,0.00,0.00,'2022-11-16 16:00:05','',''),(2510,'22','242',NULL,1,'Reception corrector for bridging 95',0.00,0.00,0.00,15000.00,0.00,'2022-11-16 16:00:18','',''),(2511,'22','242','1',1,'Received from bridging 95',0.00,0.00,15000.00,0.00,0.00,'2022-11-16 16:00:18','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_balances`
--

DROP TABLE IF EXISTS `inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_balances`
--

LOCK TABLES `inventory_balances` WRITE;
/*!40000 ALTER TABLE `inventory_balances` DISABLE KEYS */;
/*!40000 ALTER TABLE `inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=352 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (2,'22','242',2,'Sale Id shift 5',0.00,2499781.25,650.00,2599772.50,99991.25,'2022-05-07 11:40:05'),(3,'22','242',1,'Sale Id shift 5',0.00,1345425.08,165.00,1499967.15,154542.07,'2022-05-07 11:40:05'),(4,'22','242',2,'Sale Id shift 6',0.00,1946937.50,650.00,2024815.00,77877.50,'2022-05-08 10:03:13'),(5,'22','242',1,'Sale Id shift 6',0.00,1802933.04,165.00,2010026.70,207093.66,'2022-05-08 10:03:13'),(6,'22','242',2,'Sale Id shift 7',0.00,571668.75,650.00,594535.50,22866.75,'2022-05-08 18:47:56'),(7,'22','242',1,'Sale Id shift 7',0.00,800096.88,165.00,891999.90,91903.02,'2022-05-08 18:47:56'),(8,'22','242',2,'Sale Id shift 8',0.00,2908400.00,650.00,3024736.00,116336.00,'2022-05-10 11:23:57'),(9,'22','242',1,'Sale Id shift 8',0.00,1796527.60,165.00,2002885.50,206357.90,'2022-05-10 11:23:57'),(10,'22','242',2,'Sale Id shift 9',0.00,2538318.75,0.00,0.00,-2538318.75,'2022-05-12 20:19:37'),(11,'22','242',1,'Sale Id shift 9',0.00,1320994.72,165.00,1472730.60,151735.88,'2022-05-12 20:19:37'),(12,'22','242',2,'Sale Id shift 10',0.00,2226225.00,650.00,2315274.00,89049.00,'2022-05-12 21:03:19'),(13,'22','242',1,'Sale Id shift 10',0.00,1626386.80,165.00,1813201.50,186814.70,'2022-05-12 21:03:19'),(14,'22','242',2,'Sale Id shift 11',0.00,3739243.75,650.00,3888813.50,149569.75,'2022-05-12 22:07:02'),(15,'22','242',1,'Sale Id shift 11',0.00,1597002.88,165.00,1780442.40,183439.52,'2022-05-12 22:07:02'),(16,'22','242',2,'Sale Id shift 12',0.00,2404387.50,0.00,0.00,-2404387.50,'2022-05-13 22:00:54'),(17,'22','242',1,'Sale Id shift 12',0.00,1591910.20,165.00,1774764.75,182854.55,'2022-05-13 22:00:54'),(18,'22','242',2,'Sale Id shift 13',0.00,2665400.00,0.00,0.00,-2665400.00,'2022-05-15 10:18:56'),(19,'22','242',1,'Sale Id shift 13',0.00,1525566.24,165.00,1700800.20,175233.96,'2022-05-15 10:18:56'),(20,'22','242',2,'Sale Id shift 14',0.00,351181.25,0.00,0.00,-351181.25,'2022-05-16 17:34:04'),(21,'22','242',1,'Sale Id shift 14',0.00,746529.76,165.00,832279.80,85750.04,'2022-05-16 17:34:04'),(22,'22','242',2,'Sale Id shift 15',0.00,2237537.50,0.00,0.00,-2237537.50,'2022-05-16 21:51:39'),(23,'22','242',1,'Sale Id shift 15',0.00,1708432.08,165.00,1904670.90,196238.82,'2022-05-16 21:51:39'),(24,'22','242',2,'Sale Id shift 16',0.00,1926275.00,0.00,0.00,-1926275.00,'2022-05-17 22:13:48'),(25,'22','242',1,'Sale Id shift 16',0.00,1526443.88,165.00,1701778.65,175334.77,'2022-05-17 22:13:48'),(26,'22','242',2,'Sale Id shift 17',0.00,3095262.50,665.00,3293359.30,198096.80,'2022-05-19 15:27:15'),(27,'22','242',1,'Sale Id shift 17',0.00,1558508.08,165.00,1737525.90,179017.82,'2022-05-19 15:27:15'),(28,'22','242',2,'Sale Id shift 18',0.00,2844762.50,665.00,3026827.30,182064.80,'2022-05-20 16:10:17'),(29,'22','242',1,'Sale Id shift 18',0.00,1554074.00,165.00,1732582.50,178508.50,'2022-05-20 16:10:17'),(30,'22','242',2,'Sale Id shift 19',0.00,3615315.12,0.00,0.00,-3615315.12,'2022-05-20 22:12:38'),(31,'22','242',1,'Sale Id shift 19',0.00,1895517.40,165.00,2113245.75,217728.35,'2022-05-20 22:12:38'),(32,'22','242',2,'Sale Id shift 20',0.00,2449303.92,680.00,2570257.20,120953.28,'2022-05-22 08:53:08'),(33,'22','242',1,'Sale Id shift 20',0.00,1400703.08,165.00,1561594.65,160891.57,'2022-05-22 08:53:08'),(34,'22','242',2,'Sale Id shift 21',0.00,1173994.56,680.00,1231969.60,57975.04,'2022-05-23 09:40:23'),(35,'22','242',1,'Sale Id shift 21',0.00,645792.08,165.00,719970.90,74178.82,'2022-05-23 09:40:23'),(36,'22','242',2,'Sale Id shift 22',0.00,2479772.88,680.00,2602230.80,122457.92,'2022-05-24 10:02:52'),(37,'22','242',1,'Sale Id shift 22',0.00,1595710.84,165.00,1779001.95,183291.11,'2022-05-24 10:02:52'),(38,'22','242',2,'Sale Id shift 23',0.00,4373987.04,680.00,4589986.40,215999.36,'2022-05-25 12:30:22'),(39,'22','242',1,'Sale Id shift 23',0.00,1498400.84,165.00,1670514.45,172113.61,'2022-05-25 12:30:22'),(40,'22','242',2,'Sale Id shift 24',0.00,2307735.36,680.00,2421697.60,113962.24,'2022-05-26 16:29:48'),(41,'22','242',1,'Sale Id shift 24',0.00,1604376.24,165.00,1788662.70,184286.46,'2022-05-26 16:29:48'),(42,'22','242',2,'Sale Id shift 25',0.00,2107995.84,0.00,0.00,-2107995.84,'2022-05-27 22:06:13'),(43,'22','242',1,'Sale Id shift 25',0.00,1418682.12,165.00,1581638.85,162956.73,'2022-05-27 22:06:13'),(44,'22','242',2,'Sale Id shift 26',0.00,3114333.36,680.00,3268127.60,153794.24,'2022-05-27 22:15:40'),(45,'22','242',1,'Sale Id shift 26',0.00,1724694.32,165.00,1922801.10,198106.78,'2022-05-27 22:15:40'),(46,'22','242',2,'Sale Id shift 27',0.00,1742288.10,725.00,1885311.75,143023.65,'2022-05-28 20:37:58'),(47,'22','242',1,'Sale Id shift 27',0.00,1437056.32,165.00,1602123.60,165067.28,'2022-05-28 20:37:58'),(48,'22','242',2,'Sale Id shift 28',0.00,253447.60,720.00,272361.60,18914.00,'2022-05-29 18:17:01'),(49,'22','242',1,'Sale Id shift 28',0.00,749606.68,165.00,835710.15,86103.47,'2022-05-29 18:17:01'),(50,'22','242',2,'Sale Id shift 29',0.00,2167543.80,725.00,2345476.50,177932.70,'2022-05-31 08:47:54'),(51,'22','242',1,'Sale Id shift 29',0.00,1771853.04,165.00,1975376.70,203523.66,'2022-05-31 08:47:54'),(52,'22','242',2,'Sale Id shift 30',0.00,2199797.60,725.00,2380378.00,180580.40,'2022-06-01 11:11:54'),(53,'22','242',1,'Sale Id shift 30',0.00,1581245.32,165.00,1762874.85,181629.53,'2022-06-01 11:11:54'),(54,'22','242',2,'Sale Id shift 31',0.00,3396940.20,725.00,3675793.50,278853.30,'2022-06-02 08:39:12'),(55,'22','242',1,'Sale Id shift 31',0.00,1479104.60,165.00,1649001.75,169897.15,'2022-06-02 08:39:12'),(56,'22','242',2,'Sale Id shift 32',0.00,1738355.20,725.00,1881056.00,142700.80,'2022-06-03 08:17:30'),(57,'22','242',1,'Sale Id shift 32',0.00,1523895.32,165.00,1698937.35,175042.03,'2022-06-03 08:17:30'),(58,'22','242',2,'Sale Id shift 33',0.00,3045250.50,725.00,3295233.75,249983.25,'2022-06-04 11:06:02'),(59,'22','242',1,'Sale Id shift 33',0.00,1554805.12,165.00,1733397.60,178592.48,'2022-06-04 11:06:02'),(60,'22','242',2,'Sale Id shift 34',0.00,3521546.80,725.00,3810629.00,289082.20,'2022-06-04 21:37:09'),(61,'22','242',1,'Sale Id shift 34',0.00,1611648.96,165.00,1796770.80,185121.84,'2022-06-04 21:37:09'),(62,'22','242',2,'Sale Id shift 35',0.00,933718.70,725.00,1010367.25,76648.55,'2022-06-05 18:31:43'),(63,'22','242',1,'Sale Id shift 35',0.00,738884.08,165.00,823755.90,84871.82,'2022-06-05 18:31:43'),(64,'22','242',2,'Sale Id shift 36',0.00,4925471.50,725.00,5329801.25,404329.75,'2022-06-06 21:51:42'),(65,'22','242',1,'Sale Id shift 36',0.00,1656390.84,165.00,1846651.95,190261.11,'2022-06-06 21:51:42'),(66,'22','242',2,'Sale Id shift 37',0.00,3938755.80,750.00,4409055.00,470299.20,'2022-06-07 22:07:53'),(67,'22','242',1,'Sale Id shift 37',0.00,1642037.80,165.00,1830650.25,188612.45,'2022-06-07 22:07:53'),(68,'22','242',2,'Sale Id shift 38',0.00,6265029.30,750.00,7013092.50,748063.20,'2022-06-08 21:51:28'),(69,'22','242',1,'Sale Id shift 38',0.00,1567756.60,165.00,1747836.75,180080.15,'2022-06-08 21:51:28'),(70,'22','242',2,'Sale Id shift 39',0.00,4063697.40,750.00,4548915.00,485217.60,'2022-06-09 22:32:38'),(71,'22','242',1,'Sale Id shift 39',0.00,1554341.88,165.00,1732881.15,178539.27,'2022-06-09 22:32:38'),(72,'22','242',2,'Sale Id shift 40',0.00,3685938.00,775.00,4263585.00,577647.00,'2022-06-11 10:31:48'),(73,'22','242',1,'Sale Id shift 40',0.00,1441469.68,165.00,1607043.90,165574.22,'2022-06-11 10:31:48'),(74,'22','242',2,'Sale Id shift 41',0.00,4596598.80,775.00,4814005.50,217406.70,'2022-06-11 21:17:40'),(75,'22','242',1,'Sale Id shift 41',0.00,1358420.96,165.00,1514455.80,156034.84,'2022-06-11 21:17:40'),(76,'22','242',2,'Sale Id shift 42',0.00,661634.00,800.00,715280.00,53646.00,'2022-06-14 15:17:36'),(77,'22','242',1,'Sale Id shift 42',0.00,536517.76,165.00,598144.80,61627.04,'2022-06-14 15:17:36'),(78,'22','242',2,'Sale Id shift 43',0.00,3736171.20,800.00,4039104.00,302932.80,'2022-06-14 15:24:22'),(79,'22','242',1,'Sale Id shift 43',0.00,1439689.24,165.00,1605058.95,165369.71,'2022-06-14 15:24:22'),(80,'22','242',2,'Sale Id shift 44',0.00,3996088.80,800.00,4320096.00,324007.20,'2022-06-15 09:38:42'),(81,'22','242',1,'Sale Id shift 44',0.00,1526529.72,165.00,1701874.35,175344.63,'2022-06-15 09:38:42'),(82,'22','242',2,'Sale Id shift 45',0.00,3235102.40,800.00,3497408.00,262305.60,'2022-06-16 11:24:26'),(83,'22','242',1,'Sale Id shift 45',0.00,184927.48,165.00,206169.15,21241.67,'2022-06-16 11:24:26'),(84,'22','242',2,'Sale Id shift 46',0.00,3141011.40,800.00,3395688.00,254676.60,'2022-06-18 11:04:09'),(85,'22','242',1,'Sale Id shift 46',0.00,1428124.52,165.00,1592165.85,164041.33,'2022-06-18 11:04:09'),(86,'22','242',2,'Sale Id shift 47',0.00,3402172.20,800.00,3678024.00,275851.80,'2022-06-18 11:09:50'),(87,'22','242',1,'Sale Id shift 47',0.00,1548145.12,165.00,1725972.60,177827.48,'2022-06-18 11:09:50'),(88,'22','242',2,'Sale Id shift 48',0.00,2485319.60,800.00,2686832.00,201512.40,'2022-06-18 21:26:43'),(89,'22','242',1,'Sale Id shift 48',0.00,1437996.12,165.00,1603171.35,165175.23,'2022-06-18 21:26:43'),(90,'22','242',2,'Sale Id shift 49',0.00,430730.00,800.00,453400.00,22670.00,'2022-06-20 11:08:35'),(91,'22','242',1,'Sale Id shift 49',0.00,873034.24,165.00,973315.20,100280.96,'2022-06-20 11:08:35'),(92,'22','242',2,'Sale Id shift 50',0.00,3882900.80,800.00,4087264.00,204363.20,'2022-06-20 21:50:24'),(93,'22','242',1,'Sale Id shift 50',0.00,4360176.20,165.00,4861007.25,500831.05,'2022-06-20 21:50:24'),(94,'22','242',2,'Sale Id shift 51',0.00,2549169.20,800.00,2683336.00,134166.80,'2022-06-21 21:35:44'),(95,'22','242',1,'Sale Id shift 51',0.00,3762491.52,165.00,4194669.60,432178.08,'2022-06-21 21:35:44'),(96,'22','242',2,'Sale Id shift 52',0.00,3476050.00,800.00,3659000.00,182950.00,'2022-06-22 21:32:44'),(97,'22','242',1,'Sale Id shift 52',0.00,63419.48,165.00,70704.15,7284.67,'2022-06-22 21:32:44'),(98,'22','242',2,'Sale Id shift 53',0.00,2692391.20,800.00,2834096.00,141704.80,'2022-06-25 11:57:16'),(99,'22','242',1,'Sale Id shift 53',0.00,1079443.92,180.00,1312837.20,233393.28,'2022-06-25 11:57:16'),(100,'22','242',2,'Sale Id shift 55',0.00,2357649.20,800.00,2481736.00,124086.80,'2022-06-25 12:10:24'),(101,'22','242',1,'Sale Id shift 55',0.00,899290.92,165.00,1002587.85,103296.93,'2022-06-25 12:10:24'),(102,'22','242',2,'Sale Id shift 56',0.00,2254547.60,800.00,2373208.00,118660.40,'2022-06-26 06:33:21'),(103,'22','242',1,'Sale Id shift 56',0.00,1560438.00,165.00,1739677.50,179239.50,'2022-06-26 06:33:21'),(104,'22','242',2,'Sale Id shift 57',0.00,349577.20,800.00,367976.00,18398.80,'2022-06-26 18:43:42'),(105,'22','242',1,'Sale Id shift 57',0.00,828680.12,165.00,923866.35,95186.23,'2022-06-26 18:43:42'),(106,'22','242',2,'Sale Id shift 58',0.00,2904089.20,800.00,3056936.00,152846.80,'2022-06-27 21:35:23'),(107,'22','242',1,'Sale Id shift 58',0.00,1776907.24,165.00,1981011.45,204104.21,'2022-06-27 21:35:23'),(108,'22','242',2,'Sale Id shift 59',0.00,1956354.00,800.00,2059320.00,102966.00,'2022-06-28 20:58:23'),(109,'22','242',1,'Sale Id shift 59',0.00,1848235.84,165.00,2060533.20,212297.36,'2022-06-28 20:58:23'),(110,'22','242',2,'Sale Id shift 60',0.00,4393826.00,800.00,4625080.00,231254.00,'2022-06-29 21:42:51'),(111,'22','242',1,'Sale Id shift 60',0.00,1884652.72,165.00,2101133.10,216480.38,'2022-06-29 21:42:51'),(112,'22','242',2,'Sale Id shift 61',0.00,2240974.00,800.00,2358920.00,117946.00,'2022-07-01 13:08:14'),(113,'22','242',1,'Sale Id shift 61',0.00,1676151.80,165.00,1868682.75,192530.95,'2022-07-01 13:08:14'),(114,'22','242',2,'Sale Id shift 62',0.00,1827678.40,800.00,1923872.00,96193.60,'2022-07-02 09:35:54'),(115,'22','242',1,'Sale Id shift 62',0.00,1914477.68,165.00,2134383.90,219906.22,'2022-07-02 09:35:54'),(116,'22','242',2,'Sale Id shift 63',0.00,2631728.00,800.00,2770240.00,138512.00,'2022-07-02 21:51:00'),(117,'22','242',1,'Sale Id shift 63',0.00,2621390.80,165.00,2922496.50,301105.70,'2022-07-02 21:51:00'),(118,'22','242',2,'Sale Id shift 64',0.00,1205952.80,800.00,1269424.00,63471.20,'2022-07-04 08:12:27'),(119,'22','242',1,'Sale Id shift 64',0.00,1401016.84,165.00,1561944.45,160927.61,'2022-07-04 08:12:27'),(120,'22','242',2,'Sale Id shift 65',0.00,2254441.20,800.00,2373096.00,118654.80,'2022-07-04 21:42:19'),(121,'22','242',1,'Sale Id shift 65',0.00,4503496.44,170.00,5172935.10,669438.66,'2022-07-04 21:42:19'),(122,'22','242',2,'Sale Id shift 66',0.00,2542344.40,800.00,2676152.00,133807.60,'2022-07-05 19:57:45'),(123,'22','242',1,'Sale Id shift 66',0.00,1078141.52,180.00,1311253.20,233111.68,'2022-07-05 19:57:45'),(124,'22','242',2,'Sale Id shift 67',0.00,2971668.40,800.00,3128072.00,156403.60,'2022-07-06 21:05:09'),(125,'22','242',1,'Sale Id shift 67',0.00,1063702.64,185.00,1329628.30,265925.66,'2022-07-06 21:05:09'),(126,'22','242',2,'Sale Id shift 68',0.00,2730239.20,800.00,2873936.00,143696.80,'2022-07-10 17:53:34'),(127,'22','242',1,'Sale Id shift 68',0.00,1203787.60,185.00,1504734.50,300946.90,'2022-07-10 17:53:34'),(128,'22','242',2,'Sale Id shift 69',0.00,3310339.60,800.00,3484568.00,174228.40,'2022-07-10 17:58:24'),(129,'22','242',1,'Sale Id shift 69',0.00,256167.28,185.00,320209.10,64041.82,'2022-07-10 17:58:24'),(130,'22','242',2,'Sale Id shift 70',0.00,2289089.60,800.00,2409568.00,120478.40,'2022-07-10 18:02:20'),(131,'22','242',1,'Sale Id shift 70',0.00,28379.00,185.00,35473.75,7094.75,'2022-07-10 18:02:20'),(132,'22','242',2,'Sale Id shift 71',0.00,1411760.80,800.00,1486064.00,74303.20,'2022-07-10 18:38:53'),(133,'22','242',1,'Sale Id shift 71',0.00,3467.64,185.00,4334.55,866.91,'2022-07-10 18:38:53'),(134,'22','242',2,'Sale Id shift 72',0.00,1048382.00,800.00,1103560.00,55178.00,'2022-07-13 07:47:59'),(135,'22','242',1,'Sale Id shift 72',0.00,1971209.04,185.00,2464011.30,492802.26,'2022-07-13 07:47:59'),(136,'22','242',2,'Sale Id shift 73',0.00,2034261.60,800.00,2141328.00,107066.40,'2022-07-13 07:53:32'),(137,'22','242',1,'Sale Id shift 73',0.00,1717192.20,185.00,2146490.25,429298.05,'2022-07-13 07:53:32'),(138,'22','242',2,'Sale Id shift 74',0.00,1938912.00,800.00,2040960.00,102048.00,'2022-07-15 18:27:24'),(139,'22','242',1,'Sale Id shift 74',0.00,2053508.88,185.00,2566886.10,513377.22,'2022-07-15 18:27:24'),(140,'22','242',2,'Sale Id shift 75',0.00,2340564.40,800.00,2463752.00,123187.60,'2022-07-15 18:34:06'),(141,'22','242',1,'Sale Id shift 75',0.00,902313.08,185.00,1127891.35,225578.27,'2022-07-15 18:34:06'),(142,'22','242',2,'Sale Id shift 76',0.00,3447018.00,800.00,3628440.00,181422.00,'2022-07-15 21:08:49'),(143,'22','242',1,'Sale Id shift 76',0.00,662818.00,185.00,828522.50,165704.50,'2022-07-15 21:08:49'),(144,'22','242',2,'Sale Id shift 77',0.00,2542770.00,800.00,2676600.00,133830.00,'2022-07-17 08:00:56'),(145,'22','242',1,'Sale Id shift 77',0.00,1084018.60,185.00,1355023.25,271004.65,'2022-07-17 08:00:56'),(146,'22','242',2,'Sale Id shift 78',0.00,868596.40,800.00,914312.00,45715.60,'2022-07-17 18:54:06'),(147,'22','242',1,'Sale Id shift 78',0.00,819801.60,180.00,997056.00,177254.40,'2022-07-17 18:54:06'),(148,'22','242',2,'Sale Id shift 79',0.00,2331908.00,800.00,2454640.00,122732.00,'2022-07-18 21:57:40'),(149,'22','242',1,'Sale Id shift 79',0.00,923645.80,185.00,1154557.25,230911.45,'2022-07-18 21:57:40'),(150,'22','242',2,'Sale Id shift 80',0.00,1648858.00,800.00,1735640.00,86782.00,'2022-07-20 12:17:28'),(151,'22','242',1,'Sale Id shift 80',0.00,1008426.12,185.00,1260532.65,252106.53,'2022-07-20 12:17:28'),(152,'22','242',2,'Sale Id shift 81',0.00,3731683.60,800.00,3928088.00,196404.40,'2022-07-21 08:15:38'),(153,'22','242',1,'Sale Id shift 81',0.00,1184000.00,185.00,1480000.00,296000.00,'2022-07-21 08:15:38'),(154,'22','242',2,'Sale Id shift 82',0.00,2529622.00,800.00,2662760.00,133138.00,'2022-07-23 11:47:11'),(155,'22','242',1,'Sale Id shift 82',0.00,923372.00,185.00,1154215.00,230843.00,'2022-07-23 11:47:11'),(156,'22','242',2,'Sale Id shift 83',0.00,1939626.40,800.00,2041712.00,102085.60,'2022-07-23 11:52:17'),(157,'22','242',1,'Sale Id shift 83',0.00,879254.68,185.00,1099068.35,219813.67,'2022-07-23 11:52:17'),(158,'22','242',2,'Sale Id shift 84',0.00,2198224.00,800.00,2313920.00,115696.00,'2022-07-23 21:30:19'),(159,'22','242',1,'Sale Id shift 84',0.00,715220.36,185.00,894025.45,178805.09,'2022-07-23 21:30:19'),(160,'22','242',2,'Sale Id shift 85',0.00,369550.00,800.00,389000.00,19450.00,'2022-07-25 11:55:17'),(161,'22','242',1,'Sale Id shift 85',0.00,379294.40,185.00,474118.00,94823.60,'2022-07-25 11:55:17'),(162,'22','242',2,'Sale Id shift 86',0.00,3142265.60,800.00,3307648.00,165382.40,'2022-07-26 10:05:43'),(163,'22','242',1,'Sale Id shift 86',0.00,918042.52,185.00,1147553.15,229510.63,'2022-07-26 10:05:43'),(164,'22','242',2,'Sale Id shift 87',0.00,2304304.80,800.00,2425584.00,121279.20,'2022-07-27 11:47:40'),(165,'22','242',1,'Sale Id shift 87',0.00,887436.12,185.00,1109295.15,221859.03,'2022-07-27 11:47:40'),(166,'22','242',2,'Sale Id shift 88',0.00,1880992.40,800.00,1979992.00,98999.60,'2022-07-28 14:33:36'),(167,'22','242',1,'Sale Id shift 88',0.00,773055.80,185.00,966319.75,193263.95,'2022-07-28 14:33:36'),(168,'22','242',2,'Sale Id shift 89',0.00,1574096.80,800.00,1656944.00,82847.20,'2022-07-29 12:26:20'),(169,'22','242',1,'Sale Id shift 89',0.00,1159204.08,170.00,1331518.20,172314.12,'2022-07-29 12:26:20'),(170,'22','242',2,'Sale Id shift 90',0.00,2044065.60,800.00,2151648.00,107582.40,'2022-07-30 09:20:09'),(171,'22','242',1,'Sale Id shift 90',0.00,1308447.28,170.00,1502946.20,194498.92,'2022-07-30 09:20:09'),(172,'22','242',2,'Sale Id shift 91',0.00,1410666.40,800.00,1484912.00,74245.60,'2022-07-31 09:18:15'),(173,'22','242',1,'Sale Id shift 91',0.00,1926810.52,170.00,2213228.30,286417.78,'2022-07-31 09:18:15'),(174,'22','242',2,'Sale Id shift 92',0.00,435198.80,800.00,458104.00,22905.20,'2022-08-01 13:08:42'),(175,'22','242',1,'Sale Id shift 92',0.00,795461.52,170.00,913705.80,118244.28,'2022-08-01 13:08:42'),(176,'22','242',2,'Sale Id shift 93',0.00,1783499.60,800.00,1877368.00,93868.40,'2022-08-01 21:24:50'),(177,'22','242',1,'Sale Id shift 93',0.00,1445851.96,170.00,1660775.90,214923.94,'2022-08-01 21:24:50'),(178,'22','242',2,'Sale Id shift 94',0.00,1726704.80,800.00,1817584.00,90879.20,'2022-08-03 09:38:20'),(179,'22','242',1,'Sale Id shift 94',0.00,1478249.16,170.00,1697988.90,219739.74,'2022-08-03 09:38:20'),(180,'22','242',2,'Sale Id shift 95',0.00,2447830.80,800.00,2576664.00,128833.20,'2022-08-04 10:39:40'),(181,'22','242',1,'Sale Id shift 95',0.00,1547397.72,170.00,1777416.30,230018.58,'2022-08-04 10:39:40'),(182,'22','242',2,'Sale Id shift 96',0.00,1028424.40,800.00,1082552.00,54127.60,'2022-08-06 07:50:58'),(183,'22','242',1,'Sale Id shift 96',0.00,1515958.08,170.00,1741303.20,225345.12,'2022-08-06 07:50:58'),(184,'22','242',2,'Sale Id shift 97',0.00,1665790.80,800.00,1753464.00,87673.20,'2022-08-06 07:56:09'),(185,'22','242',1,'Sale Id shift 97',0.00,1290293.60,170.00,1482094.00,191800.40,'2022-08-06 07:56:09'),(186,'22','242',2,'Sale Id shift 98',0.00,1213188.00,800.00,1277040.00,63852.00,'2022-08-07 07:36:22'),(187,'22','242',1,'Sale Id shift 98',0.00,1071188.48,175.00,1266608.00,195419.52,'2022-08-07 07:36:22'),(188,'22','242',2,'Sale Id shift 99',0.00,882702.00,800.00,929160.00,46458.00,'2022-08-13 11:03:12'),(189,'22','242',1,'Sale Id shift 99',0.00,769025.76,175.00,909321.00,140295.24,'2022-08-13 11:03:12'),(190,'22','242',2,'Sale Id shift 100',0.00,1471230.80,800.00,1548664.00,77433.20,'2022-08-13 11:07:57'),(191,'22','242',1,'Sale Id shift 100',0.00,851799.20,175.00,1007195.00,155395.80,'2022-08-13 11:07:57'),(192,'22','242',2,'Sale Id shift 101',0.00,1266030.80,800.00,1332664.00,66633.20,'2022-08-13 11:20:14'),(193,'22','242',1,'Sale Id shift 101',0.00,2220.00,175.00,2625.00,405.00,'2022-08-13 11:20:14'),(194,'22','242',2,'Sale Id shift 102',0.00,1407193.20,800.00,1481256.00,74062.80,'2022-08-13 11:24:11'),(195,'22','242',1,'Sale Id shift 102',0.00,8350.16,175.00,9873.50,1523.34,'2022-08-13 11:24:11'),(196,'22','242',2,'Sale Id shift 103',0.00,2374734.00,800.00,2499720.00,124986.00,'2022-08-13 11:26:33'),(197,'22','242',1,'Sale Id shift 103',0.00,10041.80,175.00,11873.75,1831.95,'2022-08-13 11:26:33'),(198,'22','242',2,'Sale Id shift 105',0.00,1879784.00,800.00,1978720.00,98936.00,'2022-08-13 11:36:34'),(199,'22','242',1,'Sale Id shift 105',0.00,502152.16,180.00,610725.60,108573.44,'2022-08-13 11:36:34'),(200,'22','242',2,'Sale Id shift 106',0.00,1524377.60,800.00,1604608.00,80230.40,'2022-08-13 22:01:49'),(201,'22','242',1,'Sale Id shift 106',0.00,782037.92,180.00,951127.20,169089.28,'2022-08-13 22:01:49'),(202,'22','242',2,'Sale Id shift 107',0.00,869174.00,800.00,914920.00,45746.00,'2022-08-15 09:19:50'),(203,'22','242',1,'Sale Id shift 107',0.00,674480.40,180.00,820314.00,145833.60,'2022-08-15 09:19:50'),(204,'22','242',2,'Sale Id shift 108',0.00,1710889.20,800.00,1800936.00,90046.80,'2022-08-16 10:54:43'),(205,'22','242',1,'Sale Id shift 108',0.00,1163019.52,180.00,1414483.20,251463.68,'2022-08-16 10:54:43'),(206,'22','242',2,'Sale Id shift 109',0.00,2184164.00,800.00,2299120.00,114956.00,'2022-08-17 10:12:41'),(207,'22','242',1,'Sale Id shift 109',0.00,1077294.96,180.00,1310223.60,232928.64,'2022-08-17 10:12:41'),(208,'22','242',2,'Sale Id shift 110',0.00,2126799.20,800.00,2238736.00,111936.80,'2022-08-18 15:46:03'),(209,'22','242',1,'Sale Id shift 110',0.00,897235.20,180.00,1091232.00,193996.80,'2022-08-18 15:46:03'),(210,'22','242',2,'Sale Id shift 111',0.00,1131564.00,800.00,1191120.00,59556.00,'2022-08-23 13:15:36'),(211,'22','242',1,'Sale Id shift 111',0.00,788835.56,180.00,959394.60,170559.04,'2022-08-23 13:15:36'),(212,'22','242',2,'Sale Id shift 112',0.00,1608380.40,800.00,1693032.00,84651.60,'2022-08-23 13:21:05'),(213,'22','242',1,'Sale Id shift 112',0.00,702456.84,180.00,854339.40,151882.56,'2022-08-23 13:21:05'),(214,'22','242',2,'Sale Id shift 113',0.00,804376.40,800.00,846712.00,42335.60,'2022-08-23 13:23:20'),(215,'22','242',1,'Sale Id shift 113',0.00,14879.92,180.00,18097.20,3217.28,'2022-08-23 13:23:20'),(216,'22','242',2,'Sale Id shift 114',0.00,276662.80,800.00,291224.00,14561.20,'2022-08-23 13:25:49'),(217,'22','242',1,'Sale Id shift 114',0.00,4440.00,180.00,5400.00,960.00,'2022-08-23 13:25:49'),(218,'22','242',2,'Sale Id shift 115',0.00,1147843.20,800.00,1208256.00,60412.80,'2022-08-23 13:29:19'),(219,'22','242',1,'Sale Id shift 115',0.00,442274.32,180.00,537901.20,95626.88,'2022-08-23 13:29:19'),(220,'22','242',2,'Sale Id shift 116',0.00,1665707.20,800.00,1753376.00,87668.80,'2022-08-23 22:30:08'),(221,'22','242',1,'Sale Id shift 116',0.00,700125.84,180.00,851504.40,151378.56,'2022-08-23 22:30:08'),(222,'22','242',2,'Sale Id shift 117',0.00,2226192.00,775.00,2270130.00,43938.00,'2022-08-27 10:34:44'),(223,'22','242',1,'Sale Id shift 117',0.00,729608.92,180.00,887362.20,157753.28,'2022-08-27 10:34:44'),(224,'22','242',2,'Sale Id shift 118',0.00,819074.80,775.00,835240.75,16165.95,'2022-08-27 10:38:51'),(225,'22','242',1,'Sale Id shift 118',0.00,796478.28,180.00,968689.80,172211.52,'2022-08-27 10:38:51'),(226,'22','242',2,'Sale Id shift 119',0.00,1973096.80,775.00,2012039.50,38942.70,'2022-08-27 10:44:26'),(227,'22','242',1,'Sale Id shift 119',0.00,895555.40,180.00,1089189.00,193633.60,'2022-08-27 10:44:26'),(228,'22','242',2,'Sale Id shift 120',0.00,1444516.80,775.00,1473027.00,28510.20,'2022-08-28 06:50:00'),(229,'22','242',1,'Sale Id shift 120',0.00,642399.92,180.00,781297.20,138897.28,'2022-08-28 06:50:00'),(230,'22','242',2,'Sale Id shift 121',0.00,787261.20,775.00,802799.25,15538.05,'2022-08-29 22:11:12'),(231,'22','242',1,'Sale Id shift 121',0.00,583725.32,180.00,709936.20,126210.88,'2022-08-29 22:11:12'),(232,'22','242',2,'Sale Id shift 122',0.00,1536264.00,775.00,1566585.00,30321.00,'2022-08-29 22:15:05'),(233,'22','242',1,'Sale Id shift 122',0.00,838095.88,180.00,1019305.80,181209.92,'2022-08-29 22:15:05'),(234,'22','242',2,'Sale Id shift 123',0.00,2371640.80,800.00,2496464.00,124823.20,'2022-08-30 22:00:19'),(235,'22','242',1,'Sale Id shift 123',0.00,788370.84,180.00,958829.40,170458.56,'2022-08-30 22:00:19'),(236,'22','242',2,'Sale Id shift 124',0.00,1660372.00,775.00,1693142.50,32770.50,'2022-08-31 22:07:39'),(237,'22','242',1,'Sale Id shift 124',0.00,892660.52,180.00,1085668.20,193007.68,'2022-08-31 22:07:39'),(238,'22','242',2,'Sale Id shift 125',0.00,2632282.80,775.00,2684235.75,51952.95,'2022-09-03 10:14:33'),(239,'22','242',1,'Sale Id shift 125',0.00,959824.40,180.00,1167354.00,207529.60,'2022-09-03 10:14:33'),(240,'22','242',2,'Sale Id shift 126',0.00,1659452.40,775.00,1692204.75,32752.35,'2022-09-03 10:51:08'),(241,'22','242',1,'Sale Id shift 126',0.00,944747.64,180.00,1149017.40,204269.76,'2022-09-03 10:51:08'),(242,'22','242',2,'Sale Id shift 127',0.00,1830004.00,775.00,1866122.50,36118.50,'2022-09-04 08:54:18'),(243,'22','242',1,'Sale Id shift 127',0.00,801494.00,180.00,974790.00,173296.00,'2022-09-04 08:54:18'),(244,'22','242',2,'Sale Id shift 128',0.00,621474.80,775.00,633740.75,12265.95,'2022-09-05 10:50:55'),(245,'22','242',1,'Sale Id shift 128',0.00,511453.96,180.00,622038.60,110584.64,'2022-09-05 10:50:55'),(246,'22','242',2,'Sale Id shift 129',0.00,3192380.00,775.00,3255387.50,63007.50,'2022-09-06 22:08:04'),(247,'22','242',1,'Sale Id shift 129',0.00,821786.28,180.00,999469.80,177683.52,'2022-09-06 22:08:04'),(248,'22','242',2,'Sale Id shift 130',0.00,1081586.40,775.00,1102933.50,21347.10,'2022-09-06 22:12:54'),(249,'22','242',1,'Sale Id shift 130',0.00,988986.32,180.00,1202821.20,213834.88,'2022-09-06 22:12:54'),(250,'22','242',2,'Sale Id shift 131',0.00,1529294.80,775.00,1559478.25,30183.45,'2022-09-08 22:00:17'),(251,'22','242',1,'Sale Id shift 131',0.00,809290.64,180.00,984272.40,174981.76,'2022-09-08 22:00:17'),(252,'22','242',2,'Sale Id shift 132',0.00,1471762.80,775.00,1500810.75,29047.95,'2022-09-08 22:05:39'),(253,'22','242',1,'Sale Id shift 132',0.00,955606.40,180.00,1162224.00,206617.60,'2022-09-08 22:05:39'),(254,'22','242',2,'Sale Id shift 133',0.00,1844497.20,775.00,1880901.75,36404.55,'2022-09-12 11:02:34'),(255,'22','242',1,'Sale Id shift 133',0.00,883468.24,180.00,1074488.40,191020.16,'2022-09-12 11:02:34'),(256,'22','242',2,'Sale Id shift 134',0.00,2155337.20,775.00,2197876.75,42539.55,'2022-09-12 11:06:21'),(257,'22','242',1,'Sale Id shift 134',0.00,932830.68,180.00,1134523.80,201693.12,'2022-09-12 11:06:21'),(258,'22','242',2,'Sale Id shift 135',0.00,679402.00,775.00,692811.25,13409.25,'2022-09-12 11:12:36'),(259,'22','242',1,'Sale Id shift 135',0.00,590142.60,180.00,717741.00,127598.40,'2022-09-12 11:12:36'),(260,'22','242',2,'Sale Id shift 136',0.00,1698356.80,775.00,1731877.00,33520.20,'2022-09-12 21:39:56'),(261,'22','242',1,'Sale Id shift 136',0.00,999618.64,180.00,1215752.40,216133.76,'2022-09-12 21:39:56'),(262,'22','242',2,'Sale Id shift 137',0.00,1417780.00,775.00,1445762.50,27982.50,'2022-09-13 21:43:58'),(263,'22','242',1,'Sale Id shift 137',0.00,1190942.68,175.00,1408209.25,217266.57,'2022-09-13 21:43:58'),(264,'22','242',2,'Sale Id shift 138',0.00,2987727.20,775.00,3046695.50,58968.30,'2022-09-14 22:25:46'),(265,'22','242',1,'Sale Id shift 138',0.00,1015689.96,175.00,1200984.75,185294.79,'2022-09-14 22:25:46'),(266,'22','242',2,'Sale Id shift 139',0.00,1654360.40,775.00,1687012.25,32651.85,'2022-09-17 15:23:28'),(267,'22','242',1,'Sale Id shift 139',0.00,1049026.96,175.00,1240403.50,191376.54,'2022-09-17 15:23:28'),(268,'22','242',2,'Sale Id shift 140',0.00,1288420.40,775.00,1313849.75,25429.35,'2022-09-17 15:28:16'),(269,'22','242',1,'Sale Id shift 140',0.00,987080.08,175.00,1167155.50,180075.42,'2022-09-17 15:28:16'),(270,'22','242',2,'Sale Id shift 141',0.00,1419740.80,775.00,1447762.00,28021.20,'2022-09-17 21:55:20'),(271,'22','242',1,'Sale Id shift 141',0.00,979872.48,175.00,1158633.00,178760.52,'2022-09-17 21:55:20'),(272,'22','242',2,'Sale Id shift 142',0.00,279748.40,775.00,285269.75,5521.35,'2022-09-19 09:46:24'),(273,'22','242',1,'Sale Id shift 142',0.00,500725.44,175.00,592074.00,91348.56,'2022-09-19 09:46:24'),(274,'22','242',2,'Sale Id shift 143',0.00,1786577.60,775.00,1821839.00,35261.40,'2022-09-20 09:49:11'),(275,'22','242',1,'Sale Id shift 143',0.00,910676.56,175.00,1076813.50,166136.94,'2022-09-20 09:49:11'),(276,'22','242',2,'Sale Id shift 144',0.00,1227939.60,775.00,1252175.25,24235.65,'2022-09-24 19:13:31'),(277,'22','242',1,'Sale Id shift 144',0.00,1199042.72,175.00,1417787.00,218744.28,'2022-09-24 19:13:31'),(278,'22','242',2,'Sale Id shift 145',0.00,1543841.20,775.00,1574311.75,30470.55,'2022-09-24 19:25:36'),(279,'22','242',1,'Sale Id shift 145',0.00,1142551.12,175.00,1350989.50,208438.38,'2022-09-24 19:25:36'),(280,'22','242',2,'Sale Id shift 146',0.00,1211356.40,775.00,1235264.75,23908.35,'2022-09-24 19:29:49'),(281,'22','242',1,'Sale Id shift 146',0.00,790450.24,175.00,934654.00,144203.76,'2022-09-24 19:29:49'),(282,'22','242',2,'Sale Id shift 147',0.00,1399707.20,775.00,1427333.00,27625.80,'2022-09-24 19:33:33'),(283,'22','242',1,'Sale Id shift 147',0.00,1050427.04,175.00,1242059.00,191631.96,'2022-09-24 19:33:33'),(284,'22','242',2,'Sale Id shift 148',0.00,1619552.40,775.00,1651517.25,31964.85,'2022-09-25 08:33:59'),(285,'22','242',1,'Sale Id shift 148',0.00,977631.76,175.00,1155983.50,178351.74,'2022-09-25 08:33:59'),(286,'22','242',2,'Sale Id shift 149',0.00,448840.80,775.00,457699.50,8858.70,'2022-09-26 21:28:36'),(287,'22','242',1,'Sale Id shift 149',0.00,568139.44,175.00,671786.50,103647.06,'2022-09-26 21:28:36'),(288,'22','242',2,'Sale Id shift 150',0.00,2875779.20,775.00,2932538.00,56758.80,'2022-09-26 21:33:11'),(289,'22','242',1,'Sale Id shift 150',0.00,1083999.36,175.00,1281756.00,197756.64,'2022-09-26 21:33:11'),(290,'22','242',2,'Sale Id shift 151',0.00,1359845.20,800.00,1431416.00,71570.80,'2022-09-27 21:58:32'),(291,'22','242',1,'Sale Id shift 151',0.00,1032831.32,175.00,1221253.25,188421.93,'2022-09-27 21:58:32'),(292,'22','242',2,'Sale Id shift 152',0.00,1944004.00,850.00,2174215.00,230211.00,'2022-09-29 09:44:12'),(293,'22','242',1,'Sale Id shift 152',0.00,1115370.92,175.00,1318850.75,203479.83,'2022-09-29 09:44:12'),(294,'22','242',2,'Sale Id shift 153',0.00,1130158.00,850.00,1263992.50,133834.50,'2022-09-29 22:25:11'),(295,'22','242',1,'Sale Id shift 153',0.00,1182614.72,175.00,1398362.00,215747.28,'2022-09-29 22:25:11'),(296,'22','242',2,'Sale Id shift 154',0.00,1150298.00,850.00,1286517.50,136219.50,'2022-10-01 20:27:31'),(297,'22','242',1,'Sale Id shift 154',0.00,1264864.24,175.00,1495616.50,230752.26,'2022-10-01 20:27:31'),(298,'22','242',2,'Sale Id shift 155',0.00,1140767.60,850.00,1275858.50,135090.90,'2022-10-01 21:07:13'),(299,'22','242',1,'Sale Id shift 155',0.00,1074833.72,175.00,1270918.25,196084.53,'2022-10-01 21:07:13'),(300,'22','242',2,'Sale Id shift 156',0.00,407101.60,850.00,455311.00,48209.40,'2022-10-03 16:54:37'),(301,'22','242',1,'Sale Id shift 156',0.00,613912.88,175.00,725910.50,111997.62,'2022-10-03 16:54:37'),(302,'22','242',2,'Sale Id shift 157',0.00,996504.40,850.00,1114511.50,118007.10,'2022-10-04 11:01:53'),(303,'22','242',1,'Sale Id shift 157',0.00,1077367.48,175.00,1273914.25,196546.77,'2022-10-04 11:01:53'),(304,'22','242',2,'Sale Id shift 158',0.00,719742.80,850.00,804975.50,85232.70,'2022-10-05 10:46:08'),(305,'22','242',1,'Sale Id shift 158',0.00,1222203.24,175.00,1445172.75,222969.51,'2022-10-05 10:46:08'),(306,'22','242',2,'Sale Id shift 159',0.00,1017039.60,850.00,1137478.50,120438.90,'2022-10-05 21:46:29'),(307,'22','242',1,'Sale Id shift 159',0.00,1269289.44,175.00,1500849.00,231559.56,'2022-10-05 21:46:29'),(308,'22','242',2,'Sale Id shift 160',0.00,872138.00,850.00,975417.50,103279.50,'2022-10-09 09:41:38'),(309,'22','242',1,'Sale Id shift 160',0.00,1125769.40,175.00,1331146.25,205376.85,'2022-10-09 09:41:38'),(310,'22','242',2,'Sale Id shift 161',0.00,1876645.20,850.00,2098879.50,222234.30,'2022-10-09 09:45:35'),(311,'22','242',1,'Sale Id shift 161',0.00,1078584.04,175.00,1275352.75,196768.71,'2022-10-09 09:45:35'),(312,'22','242',2,'Sale Id shift 162',0.00,1288040.40,850.00,1440571.50,152531.10,'2022-10-09 09:49:19'),(313,'22','242',1,'Sale Id shift 162',0.00,1002341.84,175.00,1185201.50,182859.66,'2022-10-09 09:49:19'),(314,'22','242',2,'Sale Id shift 163',0.00,635466.40,850.00,710719.00,75252.60,'2022-10-10 11:06:59'),(315,'22','242',1,'Sale Id shift 163',0.00,534399.88,175.00,631891.75,97491.87,'2022-10-10 11:06:59'),(316,'22','242',2,'Sale Id shift 164',0.00,359563.60,850.00,402143.50,42579.90,'2022-10-14 12:39:48'),(317,'22','242',1,'Sale Id shift 164',0.00,1037315.72,175.00,1226555.75,189240.03,'2022-10-14 12:39:48'),(318,'22','242',2,'Sale Id shift 165',0.00,807925.60,850.00,903601.00,95675.40,'2022-10-14 12:44:12'),(319,'22','242',1,'Sale Id shift 165',0.00,1112886.00,175.00,1315912.50,203026.50,'2022-10-14 12:44:12'),(320,'22','242',2,'Sale Id shift 166',0.00,1059896.00,850.00,1185410.00,125514.00,'2022-10-14 12:48:43'),(321,'22','242',1,'Sale Id shift 166',0.00,1115177.04,175.00,1318621.50,203444.46,'2022-10-14 12:48:43'),(322,'22','242',2,'Sale Id shift 167',0.00,1121965.20,850.00,1254829.50,132864.30,'2022-10-14 12:52:15'),(323,'22','242',1,'Sale Id shift 167',0.00,985395.84,175.00,1165164.00,179768.16,'2022-10-14 12:52:15'),(324,'22','242',2,'Sale Id shift 168',0.00,657202.40,850.00,735029.00,77826.60,'2022-10-15 10:27:29'),(325,'22','242',1,'Sale Id shift 168',0.00,1058679.52,175.00,1251817.00,193137.48,'2022-10-15 10:27:29'),(326,'22','242',2,'Sale Id shift 169',0.00,2189020.40,850.00,2448246.50,259226.10,'2022-10-16 13:08:39'),(327,'22','242',1,'Sale Id shift 169',0.00,1118175.52,175.00,1322167.00,203991.48,'2022-10-16 13:08:39'),(328,'22','242',2,'Sale Id shift 170',0.00,388033.20,850.00,433984.50,45951.30,'2022-10-17 15:35:40'),(329,'22','242',1,'Sale Id shift 170',0.00,620852.60,175.00,734116.25,113263.65,'2022-10-17 15:35:40'),(330,'22','242',2,'Sale Id shift 171',0.00,786607.60,850.00,879758.50,93150.90,'2022-11-15 12:50:30'),(331,'22','242',1,'Sale Id shift 171',0.00,1087083.68,175.00,1285403.00,198319.32,'2022-11-15 12:50:30'),(332,'22','242',2,'Sale Id shift 172',0.00,843478.40,850.00,943364.00,99885.60,'2022-11-15 12:55:41'),(333,'22','242',1,'Sale Id shift 172',0.00,1227840.56,175.00,1451838.50,223997.94,'2022-11-15 12:55:41'),(334,'22','242',2,'Sale Id shift 173',0.00,690513.20,850.00,772284.50,81771.30,'2022-11-15 13:00:58'),(335,'22','242',1,'Sale Id shift 173',0.00,1070327.12,175.00,1265589.50,195262.38,'2022-11-15 13:00:58'),(336,'22','242',2,'Sale Id shift 174',0.00,1801321.60,850.00,2014636.00,213314.40,'2022-11-15 13:06:57'),(337,'22','242',1,'Sale Id shift 174',0.00,1016327.84,175.00,1201739.00,185411.16,'2022-11-15 13:06:57'),(338,'22','242',2,'Sale Id shift 175',0.00,1026402.80,850.00,1147950.50,121547.70,'2022-11-15 13:12:55'),(339,'22','242',1,'Sale Id shift 175',0.00,857836.12,175.00,1014333.25,156497.13,'2022-11-15 13:12:55'),(340,'22','242',2,'Sale Id shift 176',0.00,1497314.00,850.00,1674627.50,177313.50,'2022-11-15 13:18:24'),(341,'22','242',1,'Sale Id shift 176',0.00,217154.48,175.00,256770.50,39616.02,'2022-11-15 13:18:24'),(342,'22','242',2,'Sale Id shift 177',0.00,319222.80,850.00,357025.50,37802.70,'2022-11-15 13:22:57'),(343,'22','242',1,'Sale Id shift 177',0.00,137076.12,175.00,162083.25,25007.13,'2022-11-15 13:22:57'),(344,'22','242',2,'Sale Id shift 178',0.00,1397852.80,850.00,1563388.00,165535.20,'2022-11-15 13:25:26'),(345,'22','242',1,'Sale Id shift 178',0.00,13213.44,175.00,15624.00,2410.56,'2022-11-15 13:25:26'),(346,'22','242',2,'Sale Id shift 179',0.00,1759939.60,850.00,1968353.50,208413.90,'2022-11-15 13:28:11'),(347,'22','242',1,'Sale Id shift 179',0.00,64784.04,175.00,76602.75,11818.71,'2022-11-15 13:28:11'),(348,'22','242',2,'Sale Id shift 180',0.00,1396370.80,850.00,1561730.50,165359.70,'2022-11-15 13:30:16'),(349,'22','242',1,'Sale Id shift 180',0.00,54921.32,175.00,64940.75,10019.43,'2022-11-15 13:30:16'),(350,'22','242',2,'Sale Id shift 181',0.00,1255185.60,850.00,1403826.00,148640.40,'2022-11-15 13:34:02'),(351,'22','242',1,'Sale Id shift 181',0.00,778295.00,175.00,920281.25,141986.25,'2022-11-15 13:34:02');
/*!40000 ALTER TABLE `inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ledgers`
--

DROP TABLE IF EXISTS `ledgers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ledgers` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` int NOT NULL AUTO_INCREMENT,
  `ledgertype` varchar(10) NOT NULL,
  `accounttype` varchar(50) NOT NULL,
  `accountid` varchar(50) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `details` varchar(1000) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `accounttype` (`accounttype`,`accountid`,`credit`,`debit`,`thedate`),
  KEY `cooperative` (`company_id`),
  KEY `depot_id` (`station_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=460 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ledgers`
--

LOCK TABLES `ledgers` WRITE;
/*!40000 ALTER TABLE `ledgers` DISABLE KEYS */;
INSERT INTO `ledgers` VALUES ('22','242',7,'','24','3',0.00,25000000.00,'Purchase Id 4 for 40,000.00 litters of Diesel - AGO from MAO PETROLEUM COMPANY LTD','2022-05-05 14:08:39','',''),('22','242',8,'','supplier','3',25000000.00,0.00,'Purchase Id 4 for 40,000.00 litters of Diesel - AGO from MAO PETROLEUM COMPANY LTD','2022-05-05 14:08:39','',''),('22','242',9,'','24','3',0.00,5920000.00,'Purchase Id 5 for 40,000.00 litters of Petrol - PMS from FIRST ROYAL OIL & GAS LTD','2022-05-06 12:59:03','',''),('22','242',10,'','supplier','4',5920000.00,0.00,'Purchase Id 5 for 40,000.00 litters of Petrol - PMS from FIRST ROYAL OIL & GAS LTD','2022-05-06 12:59:03','',''),('22','242',11,'','20','2',0.00,0.00,'Sales from shift 3 on 2022-05-06 14:36:37 ','2022-05-06 14:36:37','',''),('22','242',12,'','6.1','1',0.00,0.00,'Sales from shift 3 on 2022-05-06 14:36:37 ','2022-05-06 14:36:37','',''),('22','242',13,'','customer','3',0.00,325000.00,'Credit Sales for 500.00 Litres of Diesel from shift 5 on 2022-05-07 11:40:05 ','2022-05-07 11:40:05','',''),('22','242',14,'','customer','5',0.00,520000.00,'Credit Sales for 800.00 Litres of Diesel from shift 5 on 2022-05-07 11:40:05 ','2022-05-07 11:40:05','',''),('22','242',15,'','customer','4',0.00,201500.00,'Credit Sales for 310.00 Litres of Diesel from shift 5 on 2022-05-07 11:40:05 ','2022-05-07 11:40:05','',''),('22','242',16,'','customer','5',0.00,5999.40,'Credit Sales for 36.36 Litres of Petrol from shift 5 on 2022-05-07 11:40:05 ','2022-05-07 11:40:05','',''),('22','242',17,'','20','2',4099739.65,0.00,'Sales from shift 5 on 2022-05-07 11:40:05 ','2022-05-07 11:40:05','',''),('22','242',18,'','6.1','1',0.00,3047240.25,'Sales from shift 5 on 2022-05-07 11:40:05 ','2022-05-07 11:40:05','',''),('22','242',19,'','customer','6',0.00,195000.00,'Credit Sales for 300.00 Litres of Diesel from shift 6 on 2022-05-08 10:03:13 ','2022-05-08 10:03:13','',''),('22','242',20,'','customer','1',0.00,227500.00,'Credit Sales for 350.00 Litres of Diesel from shift 6 on 2022-05-08 10:03:13 ','2022-05-08 10:03:13','',''),('22','242',21,'','customer','4',0.00,201500.00,'Credit Sales for 310.00 Litres of Diesel from shift 6 on 2022-05-08 10:03:13 ','2022-05-08 10:03:13','',''),('22','242',22,'','20','2',4034841.70,0.00,'Sales from shift 6 on 2022-05-08 10:03:13 ','2022-05-08 10:03:13','',''),('22','242',23,'','6.1','1',0.00,3410841.70,'Sales from shift 6 on 2022-05-08 10:03:13 ','2022-05-08 10:03:13','',''),('22','242',24,'','customer','4',0.00,195000.00,'Credit Sales for 300.00 Litres of Diesel from shift 7 on 2022-05-08 18:47:56 ','2022-05-08 18:47:56','',''),('22','242',25,'','20','2',1486535.40,0.00,'Sales from shift 7 on 2022-05-08 18:47:56 ','2022-05-08 18:47:56','',''),('22','242',26,'','6.1','1',0.00,1291535.40,'Sales from shift 7 on 2022-05-08 18:47:56 ','2022-05-08 18:47:56','',''),('22','242',27,'','customer','4',0.00,201500.00,'Credit Sales for 310.00 Litres of Diesel from shift 8 on 2022-05-10 11:23:57 ','2022-05-10 11:23:57','',''),('22','242',28,'','customer','1',0.00,260000.00,'Credit Sales for 400.00 Litres of Diesel from shift 8 on 2022-05-10 11:23:57 ','2022-05-10 11:23:57','',''),('22','242',29,'','customer','1',0.00,4745.40,'Credit Sales for 28.76 Litres of Petrol from shift 8 on 2022-05-10 11:23:57 ','2022-05-10 11:23:57','',''),('22','242',30,'','20','2',5027621.50,0.00,'Sales from shift 8 on 2022-05-10 11:23:57 ','2022-05-10 11:23:57','',''),('22','242',31,'','6.1','1',0.00,4561376.10,'Sales from shift 8 on 2022-05-10 11:23:57 ','2022-05-10 11:23:57','',''),('22','242',32,'','24','3',0.00,5920000.00,'Purchase Id 6 for 40,000.00 litters of Petrol - PMS from AA RANO NIGERIA LIMITED','2022-05-10 19:09:55','',''),('22','242',33,'','supplier','5',5920000.00,0.00,'Purchase Id 6 for 40,000.00 litters of Petrol - PMS from AA RANO NIGERIA LIMITED','2022-05-10 19:09:55','',''),('22','242',34,'','24','3',0.00,5920000.00,'Purchase Id 7 for 40,000.00 litters of Petrol - PMS from FIRST ROYAL OIL & GAS LTD','2022-05-12 19:51:45','',''),('22','242',35,'','supplier','4',5920000.00,0.00,'Purchase Id 7 for 40,000.00 litters of Petrol - PMS from FIRST ROYAL OIL & GAS LTD','2022-05-12 19:51:45','',''),('22','242',36,'','customer','4',0.00,0.00,'Credit Sales for 310.00 Litres of Diesel from shift 9 on 2022-05-12 20:19:37 ','2022-05-12 20:19:37','',''),('22','242',37,'','customer','2',0.00,0.00,'Credit Sales for 550.00 Litres of Diesel from shift 9 on 2022-05-12 20:19:37 ','2022-05-12 20:19:37','',''),('22','242',38,'','20','2',1472730.60,0.00,'Sales from shift 9 on 2022-05-12 20:19:37 ','2022-05-12 20:19:37','',''),('22','242',39,'','6.1','1',0.00,1472730.60,'Sales from shift 9 on 2022-05-12 20:19:37 ','2022-05-12 20:19:37','',''),('22','242',40,'','20','2',4128475.50,0.00,'Sales from shift 10 on 2022-05-12 21:03:19 ','2022-05-12 21:03:19','',''),('22','242',41,'','6.1','1',0.00,4128475.50,'Sales from shift 10 on 2022-05-12 21:03:19 ','2022-05-12 21:03:19','',''),('22','242',42,'','20','2',5669255.90,0.00,'Sales from shift 11 on 2022-05-12 22:07:02 ','2022-05-12 22:07:02','',''),('22','242',43,'','6.1','1',0.00,5669255.90,'Sales from shift 11 on 2022-05-12 22:07:02 ','2022-05-12 22:07:02','',''),('22','242',44,'','20','2',1774764.75,0.00,'Sales from shift 12 on 2022-05-13 22:00:54 ','2022-05-13 22:00:54','',''),('22','242',45,'','6.1','1',0.00,1774764.75,'Sales from shift 12 on 2022-05-13 22:00:54 ','2022-05-13 22:00:54','',''),('22','242',46,'','20','2',1700800.20,0.00,'Sales from shift 13 on 2022-05-15 10:18:55 ','2022-05-15 10:18:55','',''),('22','242',47,'','6.1','1',0.00,1700800.20,'Sales from shift 13 on 2022-05-15 10:18:55 ','2022-05-15 10:18:55','',''),('22','242',48,'','20','2',832279.80,0.00,'Sales from shift 14 on 2022-05-16 17:34:04 ','2022-05-16 17:34:04','',''),('22','242',49,'','6.1','1',0.00,832279.80,'Sales from shift 14 on 2022-05-16 17:34:04 ','2022-05-16 17:34:04','',''),('22','242',50,'','20','2',1904670.90,0.00,'Sales from shift 15 on 2022-05-16 21:51:39 ','2022-05-16 21:51:39','',''),('22','242',51,'','6.1','1',0.00,1904670.90,'Sales from shift 15 on 2022-05-16 21:51:39 ','2022-05-16 21:51:39','',''),('22','242',52,'','24','3',0.00,5920000.00,'Purchase Id 8 for 40,000.00 litters of Petrol - PMS from AA RANO NIGERIA LIMITED','2022-05-17 22:04:16','',''),('22','242',53,'','supplier','5',5920000.00,0.00,'Purchase Id 8 for 40,000.00 litters of Petrol - PMS from AA RANO NIGERIA LIMITED','2022-05-17 22:04:16','',''),('22','242',54,'','20','2',1701778.65,0.00,'Sales from shift 16 on 2022-05-17 22:13:48 ','2022-05-17 22:13:48','',''),('22','242',55,'','6.1','1',0.00,1701778.65,'Sales from shift 16 on 2022-05-17 22:13:48 ','2022-05-17 22:13:48','',''),('22','242',56,'','20','2',5030885.20,0.00,'Sales from shift 17 on 2022-05-19 15:27:14 ','2022-05-19 15:27:14','',''),('22','242',57,'','6.1','1',0.00,5030885.20,'Sales from shift 17 on 2022-05-19 15:27:14 ','2022-05-19 15:27:14','',''),('22','242',58,'','24','3',0.00,29160000.00,'Purchase Id 9 for 45,000.00 litters of Diesel - AGO from CHIPET INTERNATIONAL LTD','2022-05-19 15:47:03','',''),('22','242',59,'','supplier','6',29160000.00,0.00,'Purchase Id 9 for 45,000.00 litters of Diesel - AGO from CHIPET INTERNATIONAL LTD','2022-05-19 15:47:03','',''),('22','242',60,'','20','2',4759409.80,0.00,'Sales from shift 18 on 2022-05-20 16:10:17 ','2022-05-20 16:10:17','',''),('22','242',61,'','6.1','1',0.00,4759409.80,'Sales from shift 18 on 2022-05-20 16:10:17 ','2022-05-20 16:10:17','',''),('22','242',62,'','20','2',2113245.75,0.00,'Sales from shift 19 on 2022-05-20 22:12:38 ','2022-05-20 22:12:38','',''),('22','242',63,'','6.1','1',0.00,2113245.75,'Sales from shift 19 on 2022-05-20 22:12:38 ','2022-05-20 22:12:38','',''),('22','242',64,'','20','2',4131851.85,0.00,'Sales from shift 20 on 2022-05-22 08:53:08 ','2022-05-22 08:53:08','',''),('22','242',65,'','6.1','1',0.00,4131851.85,'Sales from shift 20 on 2022-05-22 08:53:08 ','2022-05-22 08:53:08','',''),('22','242',66,'','20','2',1951940.50,0.00,'Sales from shift 21 on 2022-05-23 09:40:23 ','2022-05-23 09:40:23','',''),('22','242',67,'','6.1','1',0.00,1951940.50,'Sales from shift 21 on 2022-05-23 09:40:23 ','2022-05-23 09:40:23','',''),('22','242',68,'','24','3',0.00,5920000.00,'Purchase Id 10 for 40,000.00 litters of Petrol - PMS from AA RANO NIGERIA LIMITED','2022-05-24 09:46:52','',''),('22','242',69,'','supplier','5',5920000.00,0.00,'Purchase Id 10 for 40,000.00 litters of Petrol - PMS from AA RANO NIGERIA LIMITED','2022-05-24 09:46:52','',''),('22','242',70,'','20','2',4381232.75,0.00,'Sales from shift 22 on 2022-05-24 10:02:52 ','2022-05-24 10:02:52','',''),('22','242',71,'','6.1','1',0.00,4381232.75,'Sales from shift 22 on 2022-05-24 10:02:52 ','2022-05-24 10:02:52','',''),('22','242',72,'','20','2',6260500.85,0.00,'Sales from shift 23 on 2022-05-25 12:30:22 ','2022-05-25 12:30:22','',''),('22','242',73,'','6.1','1',0.00,6260500.85,'Sales from shift 23 on 2022-05-25 12:30:22 ','2022-05-25 12:30:22','',''),('22','242',74,'','20','2',4210360.30,0.00,'Sales from shift 24 on 2022-05-26 16:29:48 ','2022-05-26 16:29:48','',''),('22','242',75,'','6.1','1',0.00,4210360.30,'Sales from shift 24 on 2022-05-26 16:29:48 ','2022-05-26 16:29:48','',''),('22','242',76,'','24','3',0.00,6660000.00,'Purchase Id 11 for 45,000.00 litters of Petrol - PMS from STALLIONAIRE NIGERIA LIMITED','2022-05-27 18:13:37','',''),('22','242',77,'','supplier','7',6660000.00,0.00,'Purchase Id 11 for 45,000.00 litters of Petrol - PMS from STALLIONAIRE NIGERIA LIMITED','2022-05-27 18:13:37','',''),('22','242',78,'','20','2',1581638.85,0.00,'Sales from shift 25 on 2022-05-27 22:06:13 ','2022-05-27 22:06:13','',''),('22','242',79,'','6.1','1',0.00,1581638.85,'Sales from shift 25 on 2022-05-27 22:06:13 ','2022-05-27 22:06:13','',''),('22','242',80,'','20','2',5190928.70,0.00,'Sales from shift 26 on 2022-05-27 22:15:40 ','2022-05-27 22:15:40','',''),('22','242',81,'','6.1','1',0.00,5190928.70,'Sales from shift 26 on 2022-05-27 22:15:40 ','2022-05-27 22:15:40','',''),('22','242',82,'','24','3',0.00,30150000.00,'Purchase Id 12 for 45,000.00 litters of Diesel - AGO from CHIPET INTERNATIONAL LTD','2022-05-28 14:31:30','',''),('22','242',83,'','supplier','6',30150000.00,0.00,'Purchase Id 12 for 45,000.00 litters of Diesel - AGO from CHIPET INTERNATIONAL LTD','2022-05-28 14:31:30','',''),('22','242',84,'','20','2',3487435.35,0.00,'Sales from shift 27 on 2022-05-28 20:37:58 ','2022-05-28 20:37:58','',''),('22','242',85,'','6.1','1',0.00,3487435.35,'Sales from shift 27 on 2022-05-28 20:37:58 ','2022-05-28 20:37:58','',''),('22','242',86,'','20','2',1108071.75,0.00,'Sales from shift 28 on 2022-05-29 18:17:01 ','2022-05-29 18:17:01','',''),('22','242',87,'','6.1','1',0.00,1108071.75,'Sales from shift 28 on 2022-05-29 18:17:01 ','2022-05-29 18:17:01','',''),('22','242',88,'','20','2',4320853.20,0.00,'Sales from shift 29 on 2022-05-31 08:47:54 ','2022-05-31 08:47:54','',''),('22','242',89,'','6.1','1',0.00,4320853.20,'Sales from shift 29 on 2022-05-31 08:47:54 ','2022-05-31 08:47:54','',''),('22','242',90,'','24','3',0.00,5920000.00,'Purchase Id 13 for 40,000.00 litters of Petrol - PMS from AA RANO NIGERIA LIMITED','2022-05-31 13:47:41','',''),('22','242',91,'','supplier','5',5920000.00,0.00,'Purchase Id 13 for 40,000.00 litters of Petrol - PMS from AA RANO NIGERIA LIMITED','2022-05-31 13:47:41','',''),('22','242',92,'','20','2',4143252.85,0.00,'Sales from shift 30 on 2022-06-01 11:11:54 ','2022-06-01 11:11:54','',''),('22','242',93,'','6.1','1',0.00,4143252.85,'Sales from shift 30 on 2022-06-01 11:11:54 ','2022-06-01 11:11:54','',''),('22','242',94,'','20','2',5324795.25,0.00,'Sales from shift 31 on 2022-06-02 08:39:12 ','2022-06-02 08:39:12','',''),('22','242',95,'','6.1','1',0.00,5324795.25,'Sales from shift 31 on 2022-06-02 08:39:12 ','2022-06-02 08:39:12','',''),('22','242',96,'','20','2',3579993.35,0.00,'Sales from shift 32 on 2022-06-03 08:17:30 ','2022-06-03 08:17:30','',''),('22','242',97,'','6.1','1',0.00,3579993.35,'Sales from shift 32 on 2022-06-03 08:17:30 ','2022-06-03 08:17:30','',''),('22','242',98,'','20','2',5028631.35,0.00,'Sales from shift 33 on 2022-06-04 11:06:02 ','2022-06-04 11:06:02','',''),('22','242',99,'','6.1','1',0.00,5028631.35,'Sales from shift 33 on 2022-06-04 11:06:02 ','2022-06-04 11:06:02','',''),('22','242',100,'','24','3',0.00,6660000.00,'Purchase Id 14 for 45,000.00 litters of Petrol - PMS from NIPC0 PLC','2022-06-04 19:47:16','',''),('22','242',101,'','supplier','8',6660000.00,0.00,'Purchase Id 14 for 45,000.00 litters of Petrol - PMS from NIPC0 PLC','2022-06-04 19:47:16','',''),('22','242',102,'','20','2',5607399.80,0.00,'Sales from shift 34 on 2022-06-04 21:37:09 ','2022-06-04 21:37:09','',''),('22','242',103,'','6.1','1',0.00,5607399.80,'Sales from shift 34 on 2022-06-04 21:37:09 ','2022-06-04 21:37:09','',''),('22','242',104,'','20','2',1834123.15,0.00,'Sales from shift 35 on 2022-06-05 18:31:43 ','2022-06-05 18:31:43','',''),('22','242',105,'','6.1','1',0.00,1834123.15,'Sales from shift 35 on 2022-06-05 18:31:43 ','2022-06-05 18:31:43','',''),('22','242',106,'','20','2',7176453.20,0.00,'Sales from shift 36 on 2022-06-06 21:51:42 ','2022-06-06 21:51:42','',''),('22','242',107,'','6.1','1',0.00,7176453.20,'Sales from shift 36 on 2022-06-06 21:51:42 ','2022-06-06 21:51:42','',''),('22','242',108,'','20','2',6239705.25,0.00,'Sales from shift 37 on 2022-06-07 22:07:53 ','2022-06-07 22:07:53','',''),('22','242',109,'','6.1','1',0.00,6239705.25,'Sales from shift 37 on 2022-06-07 22:07:53 ','2022-06-07 22:07:53','',''),('22','242',110,'','20','2',8760929.25,0.00,'Sales from shift 38 on 2022-06-08 21:51:28 ','2022-06-08 21:51:28','',''),('22','242',111,'','6.1','1',0.00,8760929.25,'Sales from shift 38 on 2022-06-08 21:51:28 ','2022-06-08 21:51:28','',''),('22','242',112,'','20','2',6281796.15,0.00,'Sales from shift 39 on 2022-06-09 22:32:38 ','2022-06-09 22:32:38','',''),('22','242',113,'','6.1','1',0.00,6281796.15,'Sales from shift 39 on 2022-06-09 22:32:38 ','2022-06-09 22:32:38','',''),('22','242',114,'','24','3',0.00,33300000.00,'Purchase Id 15 for 45,000.00 litters of Diesel - AGO from NIPC0 PLC','2022-06-10 18:29:13','',''),('22','242',115,'','supplier','8',33300000.00,0.00,'Purchase Id 15 for 45,000.00 litters of Diesel - AGO from NIPC0 PLC','2022-06-10 18:29:13','',''),('22','242',116,'','24','3',0.00,5920000.00,'Purchase Id 16 for 40,000.00 litters of Petrol - PMS from AITEO ENERGY RESOURCES','2022-06-10 18:37:51','',''),('22','242',117,'','supplier','9',5920000.00,0.00,'Purchase Id 16 for 40,000.00 litters of Petrol - PMS from AITEO ENERGY RESOURCES','2022-06-10 18:37:51','',''),('22','242',118,'','20','2',5870628.90,0.00,'Sales from shift 40 on 2022-06-11 10:31:48 ','2022-06-11 10:31:48','',''),('22','242',119,'','6.1','1',0.00,5870628.90,'Sales from shift 40 on 2022-06-11 10:31:48 ','2022-06-11 10:31:48','',''),('22','242',120,'','20','2',6328461.30,0.00,'Sales from shift 41 on 2022-06-11 21:17:40 ','2022-06-11 21:17:40','',''),('22','242',121,'','6.1','1',0.00,6328461.30,'Sales from shift 41 on 2022-06-11 21:17:40 ','2022-06-11 21:17:40','',''),('22','242',122,'','20','2',1313424.80,0.00,'Sales from shift 42 on 2022-06-14 15:17:36 ','2022-06-14 15:17:36','',''),('22','242',123,'','6.1','1',0.00,1313424.80,'Sales from shift 42 on 2022-06-14 15:17:36 ','2022-06-14 15:17:36','',''),('22','242',124,'','20','2',5644162.95,0.00,'Sales from shift 43 on 2022-06-14 15:24:22 ','2022-06-14 15:24:22','',''),('22','242',125,'','6.1','1',0.00,5644162.95,'Sales from shift 43 on 2022-06-14 15:24:22 ','2022-06-14 15:24:22','',''),('22','242',126,'','20','2',6021970.35,0.00,'Sales from shift 44 on 2022-06-15 09:38:42 ','2022-06-15 09:38:42','',''),('22','242',127,'','6.1','1',0.00,6021970.35,'Sales from shift 44 on 2022-06-15 09:38:42 ','2022-06-15 09:38:42','',''),('22','242',128,'','24','3',0.00,6660000.00,'Purchase Id 17 for 45,000.00 litters of Petrol - PMS from AA RANO NIGERIA LIMITED','2022-06-15 18:32:12','',''),('22','242',129,'','supplier','5',6660000.00,0.00,'Purchase Id 17 for 45,000.00 litters of Petrol - PMS from AA RANO NIGERIA LIMITED','2022-06-15 18:32:12','',''),('22','242',130,'','20','2',3703577.15,0.00,'Sales from shift 45 on 2022-06-16 11:24:26 ','2022-06-16 11:24:26','',''),('22','242',131,'','6.1','1',0.00,3703577.15,'Sales from shift 45 on 2022-06-16 11:24:26 ','2022-06-16 11:24:26','',''),('22','242',132,'','20','2',4987853.85,0.00,'Sales from shift 46 on 2022-06-18 11:04:09 ','2022-06-18 11:04:09','',''),('22','242',133,'','6.1','1',0.00,4987853.85,'Sales from shift 46 on 2022-06-18 11:04:09 ','2022-06-18 11:04:09','',''),('22','242',134,'','20','2',5403996.60,0.00,'Sales from shift 47 on 2022-06-18 11:09:50 ','2022-06-18 11:09:50','',''),('22','242',135,'','6.1','1',0.00,5403996.60,'Sales from shift 47 on 2022-06-18 11:09:50 ','2022-06-18 11:09:50','',''),('22','242',136,'','24','3',0.00,34200000.00,'Purchase Id 18 for 45,000.00 litters of Diesel - AGO from NIPC0 PLC','2022-06-18 11:15:21','',''),('22','242',137,'','supplier','8',34200000.00,0.00,'Purchase Id 18 for 45,000.00 litters of Diesel - AGO from NIPC0 PLC','2022-06-18 11:15:21','',''),('22','242',138,'','20','2',4290003.35,0.00,'Sales from shift 48 on 2022-06-18 21:26:43 ','2022-06-18 21:26:43','',''),('22','242',139,'','6.1','1',0.00,4290003.35,'Sales from shift 48 on 2022-06-18 21:26:43 ','2022-06-18 21:26:43','',''),('22','242',140,'','20','2',1426715.20,0.00,'Sales from shift 49 on 2022-06-20 11:08:35 ','2022-06-20 11:08:35','',''),('22','242',141,'','6.1','1',0.00,1426715.20,'Sales from shift 49 on 2022-06-20 11:08:35 ','2022-06-20 11:08:35','',''),('22','242',142,'','24','3',0.00,6660000.00,'Purchase Id 19 for 45,000.00 litters of Petrol - PMS from AA RANO NIGERIA LIMITED','2022-06-20 11:13:29','',''),('22','242',143,'','supplier','5',6660000.00,0.00,'Purchase Id 19 for 45,000.00 litters of Petrol - PMS from AA RANO NIGERIA LIMITED','2022-06-20 11:13:29','',''),('22','242',144,'','20','2',8948271.25,0.00,'Sales from shift 50 on 2022-06-20 21:50:24 ','2022-06-20 21:50:24','',''),('22','242',145,'','6.1','1',0.00,8948271.25,'Sales from shift 50 on 2022-06-20 21:50:24 ','2022-06-20 21:50:24','',''),('22','242',146,'','20','2',6878005.60,0.00,'Sales from shift 51 on 2022-06-21 21:35:44 ','2022-06-21 21:35:44','',''),('22','242',147,'','6.1','1',0.00,6878005.60,'Sales from shift 51 on 2022-06-21 21:35:44 ','2022-06-21 21:35:44','',''),('22','242',148,'','20','2',3729704.15,0.00,'Sales from shift 52 on 2022-06-22 21:32:44 ','2022-06-22 21:32:44','',''),('22','242',149,'','6.1','1',0.00,3729704.15,'Sales from shift 52 on 2022-06-22 21:32:44 ','2022-06-22 21:32:44','',''),('22','242',150,'','24','3',0.00,5920000.00,'Purchase Id 20 for 40,000.00 litters of Petrol - PMS from AA RANO NIGERIA LIMITED','2022-06-25 11:46:59','',''),('22','242',151,'','supplier','5',5920000.00,0.00,'Purchase Id 20 for 40,000.00 litters of Petrol - PMS from AA RANO NIGERIA LIMITED','2022-06-25 11:46:59','',''),('22','242',152,'','20','2',4146933.20,0.00,'Sales from shift 53 on 2022-06-25 11:57:16 ','2022-06-25 11:57:16','',''),('22','242',153,'','6.1','1',0.00,4146933.20,'Sales from shift 53 on 2022-06-25 11:57:16 ','2022-06-25 11:57:16','',''),('22','242',154,'','20','2',0.00,0.00,'Sales from shift 54 on 2022-06-25 12:02:24 ','2022-06-25 12:02:24','',''),('22','242',155,'','6.1','1',0.00,0.00,'Sales from shift 54 on 2022-06-25 12:02:24 ','2022-06-25 12:02:24','',''),('22','242',156,'','20','2',3484323.85,0.00,'Sales from shift 55 on 2022-06-25 12:10:24 ','2022-06-25 12:10:24','',''),('22','242',157,'','6.1','1',0.00,3484323.85,'Sales from shift 55 on 2022-06-25 12:10:24 ','2022-06-25 12:10:24','',''),('22','242',158,'','20','2',4112885.50,0.00,'Sales from shift 56 on 2022-06-26 06:33:21 ','2022-06-26 06:33:21','',''),('22','242',159,'','6.1','1',0.00,4112885.50,'Sales from shift 56 on 2022-06-26 06:33:21 ','2022-06-26 06:33:21','',''),('22','242',160,'','20','2',1291842.35,0.00,'Sales from shift 57 on 2022-06-26 18:43:42 ','2022-06-26 18:43:42','',''),('22','242',161,'','6.1','1',0.00,1291842.35,'Sales from shift 57 on 2022-06-26 18:43:42 ','2022-06-26 18:43:42','',''),('22','242',162,'','24','3',0.00,6660000.00,'Purchase Id 21 for 45,000.00 litters of Petrol - PMS from AITEO ENERGY RESOURCES','2022-06-27 12:47:58','',''),('22','242',163,'','supplier','9',6660000.00,0.00,'Purchase Id 21 for 45,000.00 litters of Petrol - PMS from AITEO ENERGY RESOURCES','2022-06-27 12:47:58','',''),('22','242',164,'','20','2',5037947.45,0.00,'Sales from shift 58 on 2022-06-27 21:35:23 ','2022-06-27 21:35:23','',''),('22','242',165,'','6.1','1',0.00,5037947.45,'Sales from shift 58 on 2022-06-27 21:35:23 ','2022-06-27 21:35:23','',''),('22','242',166,'','20','2',4119853.20,0.00,'Sales from shift 59 on 2022-06-28 20:58:23 ','2022-06-28 20:58:23','',''),('22','242',167,'','6.1','1',0.00,4119853.20,'Sales from shift 59 on 2022-06-28 20:58:23 ','2022-06-28 20:58:23','',''),('22','242',168,'','20','2',6726213.10,0.00,'Sales from shift 60 on 2022-06-29 21:42:51 ','2022-06-29 21:42:51','',''),('22','242',169,'','6.1','1',0.00,6726213.10,'Sales from shift 60 on 2022-06-29 21:42:51 ','2022-06-29 21:42:51','',''),('22','242',170,'','24','3',0.00,5920000.00,'Purchase Id 22 for 40,000.00 litters of Petrol - PMS from AITEO ENERGY RESOURCES','2022-06-30 18:00:35','',''),('22','242',171,'','supplier','9',5920000.00,0.00,'Purchase Id 22 for 40,000.00 litters of Petrol - PMS from AITEO ENERGY RESOURCES','2022-06-30 18:00:35','',''),('22','242',172,'','24','3',0.00,34200000.00,'Purchase Id 23 for 45,000.00 litters of Diesel - AGO from WOSBAB ENERGY SOLUTIONS NIG LT','2022-07-01 13:02:54','',''),('22','242',173,'','supplier','10',34200000.00,0.00,'Purchase Id 23 for 45,000.00 litters of Diesel - AGO from WOSBAB ENERGY SOLUTIONS NIG LT','2022-07-01 13:02:54','',''),('22','242',174,'','20','2',4227602.75,0.00,'Sales from shift 61 on 2022-07-01 13:08:14 ','2022-07-01 13:08:14','',''),('22','242',175,'','6.1','1',0.00,4227602.75,'Sales from shift 61 on 2022-07-01 13:08:14 ','2022-07-01 13:08:14','',''),('22','242',176,'','20','2',4058255.90,0.00,'Sales from shift 62 on 2022-07-02 09:35:54 ','2022-07-02 09:35:54','',''),('22','242',177,'','6.1','1',0.00,4058255.90,'Sales from shift 62 on 2022-07-02 09:35:54 ','2022-07-02 09:35:54','',''),('22','242',178,'','24','3',0.00,5920000.00,'Purchase Id 24 for 40,000.00 litters of Petrol - PMS from AITEO ENERGY RESOURCES','2022-07-02 11:06:09','',''),('22','242',179,'','supplier','9',5920000.00,0.00,'Purchase Id 24 for 40,000.00 litters of Petrol - PMS from AITEO ENERGY RESOURCES','2022-07-02 11:06:09','',''),('22','242',180,'','20','2',5692736.50,0.00,'Sales from shift 63 on 2022-07-02 21:51:00 ','2022-07-02 21:51:00','',''),('22','242',181,'','6.1','1',0.00,5692736.50,'Sales from shift 63 on 2022-07-02 21:51:00 ','2022-07-02 21:51:00','',''),('22','242',182,'','20','2',2831368.45,0.00,'Sales from shift 64 on 2022-07-04 08:12:27 ','2022-07-04 08:12:27','',''),('22','242',183,'','6.1','1',0.00,2831368.45,'Sales from shift 64 on 2022-07-04 08:12:27 ','2022-07-04 08:12:27','',''),('22','242',184,'','20','2',7546031.10,0.00,'Sales from shift 65 on 2022-07-04 21:42:19 ','2022-07-04 21:42:19','',''),('22','242',185,'','6.1','1',0.00,7546031.10,'Sales from shift 65 on 2022-07-04 21:42:19 ','2022-07-04 21:42:19','',''),('22','242',186,'','20','2',3987405.20,0.00,'Sales from shift 66 on 2022-07-05 19:57:45 ','2022-07-05 19:57:45','',''),('22','242',187,'','6.1','1',0.00,3987405.20,'Sales from shift 66 on 2022-07-05 19:57:45 ','2022-07-05 19:57:45','',''),('22','242',188,'','20','2',4457700.30,0.00,'Sales from shift 67 on 2022-07-06 21:05:09 ','2022-07-06 21:05:09','',''),('22','242',189,'','6.1','1',0.00,4457700.30,'Sales from shift 67 on 2022-07-06 21:05:09 ','2022-07-06 21:05:09','',''),('22','242',190,'','24','3',0.00,6660000.00,'Purchase Id 25 for 45,000.00 litters of Petrol - PMS from AA RANO NIGERIA LIMITED','2022-07-10 17:43:51','',''),('22','242',191,'','supplier','5',6660000.00,0.00,'Purchase Id 25 for 45,000.00 litters of Petrol - PMS from AA RANO NIGERIA LIMITED','2022-07-10 17:43:51','',''),('22','242',192,'','20','2',4378670.50,0.00,'Sales from shift 68 on 2022-07-10 17:53:34 ','2022-07-10 17:53:34','',''),('22','242',193,'','6.1','1',0.00,4378670.50,'Sales from shift 68 on 2022-07-10 17:53:34 ','2022-07-10 17:53:34','',''),('22','242',194,'','20','2',3804777.10,0.00,'Sales from shift 69 on 2022-07-10 17:58:24 ','2022-07-10 17:58:24','',''),('22','242',195,'','6.1','1',0.00,3804777.10,'Sales from shift 69 on 2022-07-10 17:58:24 ','2022-07-10 17:58:24','',''),('22','242',196,'','20','2',2445041.75,0.00,'Sales from shift 70 on 2022-07-10 18:02:20 ','2022-07-10 18:02:20','',''),('22','242',197,'','6.1','1',0.00,2445041.75,'Sales from shift 70 on 2022-07-10 18:02:20 ','2022-07-10 18:02:20','',''),('22','242',198,'','20','2',1490398.55,0.00,'Sales from shift 71 on 2022-07-10 18:38:53 ','2022-07-10 18:38:53','',''),('22','242',199,'','6.1','1',0.00,1490398.55,'Sales from shift 71 on 2022-07-10 18:38:53 ','2022-07-10 18:38:53','',''),('22','242',200,'','20','2',3567571.30,0.00,'Sales from shift 72 on 2022-07-13 07:47:59 ','2022-07-13 07:47:59','',''),('22','242',201,'','6.1','1',0.00,3567571.30,'Sales from shift 72 on 2022-07-13 07:47:59 ','2022-07-13 07:47:59','',''),('22','242',202,'','20','2',4287818.25,0.00,'Sales from shift 73 on 2022-07-13 07:53:32 ','2022-07-13 07:53:32','',''),('22','242',203,'','6.1','1',0.00,4287818.25,'Sales from shift 73 on 2022-07-13 07:53:32 ','2022-07-13 07:53:32','',''),('22','242',204,'','24','3',0.00,6660000.00,'Purchase Id 26 for 45,000.00 litters of Petrol - PMS from PINNACLE OIL & GAS LIMITED ','2022-07-15 18:17:44','',''),('22','242',205,'','supplier','11',6660000.00,0.00,'Purchase Id 26 for 45,000.00 litters of Petrol - PMS from PINNACLE OIL & GAS LIMITED ','2022-07-15 18:17:44','',''),('22','242',206,'','20','2',4607846.10,0.00,'Sales from shift 74 on 2022-07-15 18:27:24 ','2022-07-15 18:27:24','',''),('22','242',207,'','6.1','1',0.00,4607846.10,'Sales from shift 74 on 2022-07-15 18:27:24 ','2022-07-15 18:27:24','',''),('22','242',208,'','20','2',3591643.35,0.00,'Sales from shift 75 on 2022-07-15 18:34:06 ','2022-07-15 18:34:06','',''),('22','242',209,'','6.1','1',0.00,3591643.35,'Sales from shift 75 on 2022-07-15 18:34:06 ','2022-07-15 18:34:06','',''),('22','242',210,'','20','2',4456962.50,0.00,'Sales from shift 76 on 2022-07-15 21:08:49 ','2022-07-15 21:08:49','',''),('22','242',211,'','6.1','1',0.00,4456962.50,'Sales from shift 76 on 2022-07-15 21:08:49 ','2022-07-15 21:08:49','',''),('22','242',212,'','20','2',4031623.25,0.00,'Sales from shift 77 on 2022-07-17 08:00:56 ','2022-07-17 08:00:56','',''),('22','242',213,'','6.1','1',0.00,4031623.25,'Sales from shift 77 on 2022-07-17 08:00:56 ','2022-07-17 08:00:56','',''),('22','242',214,'','20','2',1911368.00,0.00,'Sales from shift 78 on 2022-07-17 18:54:05 ','2022-07-17 18:54:05','',''),('22','242',215,'','6.1','1',0.00,1911368.00,'Sales from shift 78 on 2022-07-17 18:54:05 ','2022-07-17 18:54:05','',''),('22','242',216,'','20','2',3609197.25,0.00,'Sales from shift 79 on 2022-07-18 21:57:40 ','2022-07-18 21:57:40','',''),('22','242',217,'','6.1','1',0.00,3609197.25,'Sales from shift 79 on 2022-07-18 21:57:40 ','2022-07-18 21:57:40','',''),('22','242',218,'','24','3',0.00,6660000.00,'Purchase Id 27 for 45,000.00 litters of Petrol - PMS from PINNACLE OIL & GAS LIMITED ','2022-07-19 15:48:07','',''),('22','242',219,'','supplier','11',6660000.00,0.00,'Purchase Id 27 for 45,000.00 litters of Petrol - PMS from PINNACLE OIL & GAS LIMITED ','2022-07-19 15:48:07','',''),('22','242',220,'','24','3',0.00,30400000.00,'Purchase Id 28 for 40,000.00 litters of Diesel - AGO from WOSBAB ENERGY SOLUTIONS NIG LT','2022-07-20 12:07:40','',''),('22','242',221,'','supplier','10',30400000.00,0.00,'Purchase Id 28 for 40,000.00 litters of Diesel - AGO from WOSBAB ENERGY SOLUTIONS NIG LT','2022-07-20 12:07:40','',''),('22','242',222,'','20','2',2996172.65,0.00,'Sales from shift 80 on 2022-07-20 12:17:28 ','2022-07-20 12:17:28','',''),('22','242',223,'','6.1','1',0.00,2996172.65,'Sales from shift 80 on 2022-07-20 12:17:28 ','2022-07-20 12:17:28','',''),('22','242',224,'','20','2',5408088.00,0.00,'Sales from shift 81 on 2022-07-21 08:15:38 ','2022-07-21 08:15:38','',''),('22','242',225,'','6.1','1',0.00,5408088.00,'Sales from shift 81 on 2022-07-21 08:15:38 ','2022-07-21 08:15:38','',''),('22','242',226,'','20','2',3816975.00,0.00,'Sales from shift 82 on 2022-07-23 11:47:11 ','2022-07-23 11:47:11','',''),('22','242',227,'','6.1','1',0.00,3816975.00,'Sales from shift 82 on 2022-07-23 11:47:11 ','2022-07-23 11:47:11','',''),('22','242',228,'','20','2',3140780.35,0.00,'Sales from shift 83 on 2022-07-23 11:52:17 ','2022-07-23 11:52:17','',''),('22','242',229,'','6.1','1',0.00,3140780.35,'Sales from shift 83 on 2022-07-23 11:52:17 ','2022-07-23 11:52:17','',''),('22','242',230,'','20','2',3207945.45,0.00,'Sales from shift 84 on 2022-07-23 21:30:19 ','2022-07-23 21:30:19','',''),('22','242',231,'','6.1','1',0.00,3207945.45,'Sales from shift 84 on 2022-07-23 21:30:19 ','2022-07-23 21:30:19','',''),('22','242',232,'','20','2',863118.00,0.00,'Sales from shift 85 on 2022-07-25 11:55:17 ','2022-07-25 11:55:17','',''),('22','242',233,'','6.1','1',0.00,863118.00,'Sales from shift 85 on 2022-07-25 11:55:17 ','2022-07-25 11:55:17','',''),('22','242',234,'','20','2',4455201.15,0.00,'Sales from shift 86 on 2022-07-26 10:05:43 ','2022-07-26 10:05:43','',''),('22','242',235,'','6.1','1',0.00,4455201.15,'Sales from shift 86 on 2022-07-26 10:05:43 ','2022-07-26 10:05:43','',''),('22','242',236,'','20','2',3534879.15,0.00,'Sales from shift 87 on 2022-07-27 11:47:40 ','2022-07-27 11:47:40','',''),('22','242',237,'','6.1','1',0.00,3534879.15,'Sales from shift 87 on 2022-07-27 11:47:40 ','2022-07-27 11:47:40','',''),('22','242',238,'','20','2',2946311.75,0.00,'Sales from shift 88 on 2022-07-28 14:33:36 ','2022-07-28 14:33:36','',''),('22','242',239,'','6.1','1',0.00,2946311.75,'Sales from shift 88 on 2022-07-28 14:33:36 ','2022-07-28 14:33:36','',''),('22','242',240,'','24','3',0.00,5920000.00,'Purchase Id 29 for 40,000.00 litters of Petrol - PMS from PINNACLE OIL & GAS LIMITED ','2022-07-29 12:17:05','',''),('22','242',241,'','supplier','11',5920000.00,0.00,'Purchase Id 29 for 40,000.00 litters of Petrol - PMS from PINNACLE OIL & GAS LIMITED ','2022-07-29 12:17:05','',''),('22','242',242,'','20','2',2988462.20,0.00,'Sales from shift 89 on 2022-07-29 12:26:20 ','2022-07-29 12:26:20','',''),('22','242',243,'','6.1','1',0.00,2988462.20,'Sales from shift 89 on 2022-07-29 12:26:20 ','2022-07-29 12:26:20','',''),('22','242',244,'','20','2',3654594.20,0.00,'Sales from shift 90 on 2022-07-30 09:20:09 ','2022-07-30 09:20:09','',''),('22','242',245,'','6.1','1',0.00,3654594.20,'Sales from shift 90 on 2022-07-30 09:20:09 ','2022-07-30 09:20:09','',''),('22','242',246,'','24','3',0.00,5920000.00,'Purchase Id 30 for 40,000.00 litters of Petrol - PMS from PINNACLE OIL & GAS LIMITED ','2022-07-30 22:17:37','',''),('22','242',247,'','supplier','11',5920000.00,0.00,'Purchase Id 30 for 40,000.00 litters of Petrol - PMS from PINNACLE OIL & GAS LIMITED ','2022-07-30 22:17:37','',''),('22','242',248,'','20','2',3698140.30,0.00,'Sales from shift 91 on 2022-07-31 09:18:15 ','2022-07-31 09:18:15','',''),('22','242',249,'','6.1','1',0.00,3698140.30,'Sales from shift 91 on 2022-07-31 09:18:15 ','2022-07-31 09:18:15','',''),('22','242',250,'','20','2',1371809.80,0.00,'Sales from shift 92 on 2022-08-01 13:08:42 ','2022-08-01 13:08:42','',''),('22','242',251,'','6.1','1',0.00,1371809.80,'Sales from shift 92 on 2022-08-01 13:08:42 ','2022-08-01 13:08:42','',''),('22','242',252,'','20','2',3538143.90,0.00,'Sales from shift 93 on 2022-08-01 21:24:50 ','2022-08-01 21:24:50','',''),('22','242',253,'','6.1','1',0.00,3538143.90,'Sales from shift 93 on 2022-08-01 21:24:50 ','2022-08-01 21:24:50','',''),('22','242',254,'','20','2',3515572.90,0.00,'Sales from shift 94 on 2022-08-03 09:38:20 ','2022-08-03 09:38:20','',''),('22','242',255,'','6.1','1',0.00,3515572.90,'Sales from shift 94 on 2022-08-03 09:38:20 ','2022-08-03 09:38:20','',''),('22','242',256,'','24','3',0.00,34200000.00,'Purchase Id 31 for 45,000.00 litters of Diesel - AGO from NIPC0 PLC','2022-08-04 10:24:56','',''),('22','242',257,'','supplier','8',34200000.00,0.00,'Purchase Id 31 for 45,000.00 litters of Diesel - AGO from NIPC0 PLC','2022-08-04 10:24:56','',''),('22','242',258,'','20','2',4354080.30,0.00,'Sales from shift 95 on 2022-08-04 10:39:40 ','2022-08-04 10:39:40','',''),('22','242',259,'','6.1','1',0.00,4354080.30,'Sales from shift 95 on 2022-08-04 10:39:40 ','2022-08-04 10:39:40','',''),('22','242',260,'','20','2',2823855.20,0.00,'Sales from shift 96 on 2022-08-06 07:50:58 ','2022-08-06 07:50:58','',''),('22','242',261,'','6.1','1',0.00,2823855.20,'Sales from shift 96 on 2022-08-06 07:50:58 ','2022-08-06 07:50:58','',''),('22','242',262,'','20','2',3235558.00,0.00,'Sales from shift 97 on 2022-08-06 07:56:09 ','2022-08-06 07:56:09','',''),('22','242',263,'','6.1','1',0.00,3235558.00,'Sales from shift 97 on 2022-08-06 07:56:09 ','2022-08-06 07:56:09','',''),('22','242',264,'','20','2',2543648.00,0.00,'Sales from shift 98 on 2022-08-07 07:36:22 ','2022-08-07 07:36:22','',''),('22','242',265,'','6.1','1',0.00,2543648.00,'Sales from shift 98 on 2022-08-07 07:36:22 ','2022-08-07 07:36:22','',''),('22','242',266,'','24','3',0.00,6660000.00,'Purchase Id 32 for 45,000.00 litters of Petrol - PMS from NIPC0 PLC','2022-08-13 10:56:55','',''),('22','242',267,'','supplier','8',6660000.00,0.00,'Purchase Id 32 for 45,000.00 litters of Petrol - PMS from NIPC0 PLC','2022-08-13 10:56:55','',''),('22','242',268,'','20','2',1838481.00,0.00,'Sales from shift 99 on 2022-08-13 11:03:12 ','2022-08-13 11:03:12','',''),('22','242',269,'','6.1','1',0.00,1838481.00,'Sales from shift 99 on 2022-08-13 11:03:12 ','2022-08-13 11:03:12','',''),('22','242',270,'','20','2',2555859.00,0.00,'Sales from shift 100 on 2022-08-13 11:07:57 ','2022-08-13 11:07:57','',''),('22','242',271,'','6.1','1',0.00,2555859.00,'Sales from shift 100 on 2022-08-13 11:07:57 ','2022-08-13 11:07:57','',''),('22','242',272,'','20','2',1335289.00,0.00,'Sales from shift 101 on 2022-08-13 11:20:14 ','2022-08-13 11:20:14','',''),('22','242',273,'','6.1','1',0.00,1335289.00,'Sales from shift 101 on 2022-08-13 11:20:14 ','2022-08-13 11:20:14','',''),('22','242',274,'','20','2',1491129.50,0.00,'Sales from shift 102 on 2022-08-13 11:24:11 ','2022-08-13 11:24:11','',''),('22','242',275,'','6.1','1',0.00,1491129.50,'Sales from shift 102 on 2022-08-13 11:24:11 ','2022-08-13 11:24:11','',''),('22','242',276,'','20','2',2511593.75,0.00,'Sales from shift 103 on 2022-08-13 11:26:33 ','2022-08-13 11:26:33','',''),('22','242',277,'','6.1','1',0.00,2511593.75,'Sales from shift 103 on 2022-08-13 11:26:33 ','2022-08-13 11:26:33','',''),('22','242',278,'','20','2',0.00,0.00,'Sales from shift 104 on 2022-08-13 11:30:43 ','2022-08-13 11:30:43','',''),('22','242',279,'','6.1','1',0.00,0.00,'Sales from shift 104 on 2022-08-13 11:30:43 ','2022-08-13 11:30:43','',''),('22','242',280,'','20','2',2589445.60,0.00,'Sales from shift 105 on 2022-08-13 11:36:34 ','2022-08-13 11:36:34','',''),('22','242',281,'','6.1','1',0.00,2589445.60,'Sales from shift 105 on 2022-08-13 11:36:34 ','2022-08-13 11:36:34','',''),('22','242',282,'','20','2',2555735.20,0.00,'Sales from shift 106 on 2022-08-13 22:01:49 ','2022-08-13 22:01:49','',''),('22','242',283,'','6.1','1',0.00,2555735.20,'Sales from shift 106 on 2022-08-13 22:01:49 ','2022-08-13 22:01:49','',''),('22','242',284,'','20','2',1735234.00,0.00,'Sales from shift 107 on 2022-08-15 09:19:50 ','2022-08-15 09:19:50','',''),('22','242',285,'','6.1','1',0.00,1735234.00,'Sales from shift 107 on 2022-08-15 09:19:50 ','2022-08-15 09:19:50','',''),('22','242',286,'','20','2',3215419.20,0.00,'Sales from shift 108 on 2022-08-16 10:54:43 ','2022-08-16 10:54:43','',''),('22','242',287,'','6.1','1',0.00,3215419.20,'Sales from shift 108 on 2022-08-16 10:54:43 ','2022-08-16 10:54:43','',''),('22','242',288,'','20','2',3609343.60,0.00,'Sales from shift 109 on 2022-08-17 10:12:41 ','2022-08-17 10:12:41','',''),('22','242',289,'','6.1','1',0.00,3609343.60,'Sales from shift 109 on 2022-08-17 10:12:41 ','2022-08-17 10:12:41','',''),('22','242',290,'','20','2',3329968.00,0.00,'Sales from shift 110 on 2022-08-18 15:46:03 ','2022-08-18 15:46:03','',''),('22','242',291,'','6.1','1',0.00,3329968.00,'Sales from shift 110 on 2022-08-18 15:46:03 ','2022-08-18 15:46:03','',''),('22','242',292,'','24','3',0.00,6660000.00,'Purchase Id 33 for 45,000.00 litters of Petrol - PMS from ETERNA PLC','2022-08-23 13:09:36','',''),('22','242',293,'','supplier','12',6660000.00,0.00,'Purchase Id 33 for 45,000.00 litters of Petrol - PMS from ETERNA PLC','2022-08-23 13:09:36','',''),('22','242',294,'','20','2',2150514.60,0.00,'Sales from shift 111 on 2022-08-23 13:15:36 ','2022-08-23 13:15:36','',''),('22','242',295,'','6.1','1',0.00,2150514.60,'Sales from shift 111 on 2022-08-23 13:15:36 ','2022-08-23 13:15:36','',''),('22','242',296,'','20','2',2547371.40,0.00,'Sales from shift 112 on 2022-08-23 13:21:05 ','2022-08-23 13:21:05','',''),('22','242',297,'','6.1','1',0.00,2547371.40,'Sales from shift 112 on 2022-08-23 13:21:05 ','2022-08-23 13:21:05','',''),('22','242',298,'','20','2',864809.20,0.00,'Sales from shift 113 on 2022-08-23 13:23:20 ','2022-08-23 13:23:20','',''),('22','242',299,'','6.1','1',0.00,864809.20,'Sales from shift 113 on 2022-08-23 13:23:20 ','2022-08-23 13:23:20','',''),('22','242',300,'','20','2',296624.00,0.00,'Sales from shift 114 on 2022-08-23 13:25:49 ','2022-08-23 13:25:49','',''),('22','242',301,'','6.1','1',0.00,296624.00,'Sales from shift 114 on 2022-08-23 13:25:49 ','2022-08-23 13:25:49','',''),('22','242',302,'','20','2',1746157.20,0.00,'Sales from shift 115 on 2022-08-23 13:29:19 ','2022-08-23 13:29:19','',''),('22','242',303,'','6.1','1',0.00,1746157.20,'Sales from shift 115 on 2022-08-23 13:29:19 ','2022-08-23 13:29:19','',''),('22','242',304,'','20','2',2604880.40,0.00,'Sales from shift 116 on 2022-08-23 22:30:08 ','2022-08-23 22:30:08','',''),('22','242',305,'','6.1','1',0.00,2604880.40,'Sales from shift 116 on 2022-08-23 22:30:08 ','2022-08-23 22:30:08','',''),('22','242',306,'','20','2',3157492.20,0.00,'Sales from shift 117 on 2022-08-27 10:34:44 ','2022-08-27 10:34:44','',''),('22','242',307,'','6.1','1',0.00,3157492.20,'Sales from shift 117 on 2022-08-27 10:34:44 ','2022-08-27 10:34:44','',''),('22','242',308,'','20','2',1803930.55,0.00,'Sales from shift 118 on 2022-08-27 10:38:51 ','2022-08-27 10:38:51','',''),('22','242',309,'','6.1','1',0.00,1803930.55,'Sales from shift 118 on 2022-08-27 10:38:51 ','2022-08-27 10:38:51','',''),('22','242',310,'','20','2',3101228.50,0.00,'Sales from shift 119 on 2022-08-27 10:44:26 ','2022-08-27 10:44:26','',''),('22','242',311,'','6.1','1',0.00,3101228.50,'Sales from shift 119 on 2022-08-27 10:44:26 ','2022-08-27 10:44:26','',''),('22','242',312,'','20','2',2254324.20,0.00,'Sales from shift 120 on 2022-08-28 06:50:00 ','2022-08-28 06:50:00','',''),('22','242',313,'','6.1','1',0.00,2254324.20,'Sales from shift 120 on 2022-08-28 06:50:00 ','2022-08-28 06:50:00','',''),('22','242',314,'','20','2',1512735.45,0.00,'Sales from shift 121 on 2022-08-29 22:11:12 ','2022-08-29 22:11:12','',''),('22','242',315,'','6.1','1',0.00,1512735.45,'Sales from shift 121 on 2022-08-29 22:11:12 ','2022-08-29 22:11:12','',''),('22','242',316,'','20','2',2585890.80,0.00,'Sales from shift 122 on 2022-08-29 22:15:05 ','2022-08-29 22:15:05','',''),('22','242',317,'','6.1','1',0.00,2585890.80,'Sales from shift 122 on 2022-08-29 22:15:05 ','2022-08-29 22:15:05','',''),('22','242',318,'','24','3',0.00,34200000.00,'Purchase Id 34 for 45,000.00 litters of Diesel - AGO from PPMC','2022-08-30 10:21:28','',''),('22','242',319,'','supplier','2',34200000.00,0.00,'Purchase Id 34 for 45,000.00 litters of Diesel - AGO from PPMC','2022-08-30 10:21:28','',''),('22','242',320,'','24','3',0.00,6216000.00,'Purchase Id 35 for 42,000.00 litters of Petrol - PMS from ASCON OIL COMPANY LIMITED ','2022-08-30 10:25:50','',''),('22','242',321,'','supplier','13',6216000.00,0.00,'Purchase Id 35 for 42,000.00 litters of Petrol - PMS from ASCON OIL COMPANY LIMITED ','2022-08-30 10:25:50','',''),('22','242',322,'','20','2',3455293.40,0.00,'Sales from shift 123 on 2022-08-30 22:00:19 ','2022-08-30 22:00:19','',''),('22','242',323,'','6.1','1',0.00,3455293.40,'Sales from shift 123 on 2022-08-30 22:00:19 ','2022-08-30 22:00:19','',''),('22','242',324,'','20','2',2778810.70,0.00,'Sales from shift 124 on 2022-08-31 22:07:39 ','2022-08-31 22:07:39','',''),('22','242',325,'','6.1','1',0.00,2778810.70,'Sales from shift 124 on 2022-08-31 22:07:39 ','2022-08-31 22:07:39','',''),('22','242',326,'','24','3',0.00,6660000.00,'Purchase Id 36 for 45,000.00 litters of Petrol - PMS from NIPC0 PLC','2022-09-01 19:42:46','',''),('22','242',327,'','supplier','8',6660000.00,0.00,'Purchase Id 36 for 45,000.00 litters of Petrol - PMS from NIPC0 PLC','2022-09-01 19:42:46','',''),('22','242',328,'','20','2',3851589.75,0.00,'Sales from shift 125 on 2022-09-03 10:14:33 ','2022-09-03 10:14:33','',''),('22','242',329,'','6.1','1',0.00,3851589.75,'Sales from shift 125 on 2022-09-03 10:14:33 ','2022-09-03 10:14:33','',''),('22','242',330,'','20','2',2841222.15,0.00,'Sales from shift 126 on 2022-09-03 10:51:08 ','2022-09-03 10:51:08','',''),('22','242',331,'','6.1','1',0.00,2841222.15,'Sales from shift 126 on 2022-09-03 10:51:08 ','2022-09-03 10:51:08','',''),('22','242',332,'','20','2',2840912.50,0.00,'Sales from shift 127 on 2022-09-04 08:54:18 ','2022-09-04 08:54:18','',''),('22','242',333,'','6.1','1',0.00,2840912.50,'Sales from shift 127 on 2022-09-04 08:54:18 ','2022-09-04 08:54:18','',''),('22','242',334,'','20','2',1255779.35,0.00,'Sales from shift 128 on 2022-09-05 10:50:55 ','2022-09-05 10:50:55','',''),('22','242',335,'','6.1','1',0.00,1255779.35,'Sales from shift 128 on 2022-09-05 10:50:55 ','2022-09-05 10:50:55','',''),('22','242',336,'','20','2',4254857.30,0.00,'Sales from shift 129 on 2022-09-06 22:08:04 ','2022-09-06 22:08:04','',''),('22','242',337,'','6.1','1',0.00,4254857.30,'Sales from shift 129 on 2022-09-06 22:08:04 ','2022-09-06 22:08:04','',''),('22','242',338,'','20','2',2305754.70,0.00,'Sales from shift 130 on 2022-09-06 22:12:54 ','2022-09-06 22:12:54','',''),('22','242',339,'','6.1','1',0.00,2305754.70,'Sales from shift 130 on 2022-09-06 22:12:54 ','2022-09-06 22:12:54','',''),('22','242',340,'','20','2',2543750.65,0.00,'Sales from shift 131 on 2022-09-08 22:00:16 ','2022-09-08 22:00:16','',''),('22','242',341,'','6.1','1',0.00,2543750.65,'Sales from shift 131 on 2022-09-08 22:00:16 ','2022-09-08 22:00:16','',''),('22','242',342,'','20','2',2663034.75,0.00,'Sales from shift 132 on 2022-09-08 22:05:39 ','2022-09-08 22:05:39','',''),('22','242',343,'','6.1','1',0.00,2663034.75,'Sales from shift 132 on 2022-09-08 22:05:39 ','2022-09-08 22:05:39','',''),('22','242',344,'','20','2',2955390.15,0.00,'Sales from shift 133 on 2022-09-12 11:02:33 ','2022-09-12 11:02:33','',''),('22','242',345,'','6.1','1',0.00,2955390.15,'Sales from shift 133 on 2022-09-12 11:02:33 ','2022-09-12 11:02:33','',''),('22','242',346,'','20','2',3332400.55,0.00,'Sales from shift 134 on 2022-09-12 11:06:21 ','2022-09-12 11:06:21','',''),('22','242',347,'','6.1','1',0.00,3332400.55,'Sales from shift 134 on 2022-09-12 11:06:21 ','2022-09-12 11:06:21','',''),('22','242',348,'','20','2',1410552.25,0.00,'Sales from shift 135 on 2022-09-12 11:12:36 ','2022-09-12 11:12:36','',''),('22','242',349,'','6.1','1',0.00,1410552.25,'Sales from shift 135 on 2022-09-12 11:12:36 ','2022-09-12 11:12:36','',''),('22','242',350,'','24','3',0.00,6660000.00,'Purchase Id 37 for 45,000.00 litters of Petrol - PMS from PINNACLE OIL & GAS LIMITED ','2022-09-12 21:34:30','',''),('22','242',351,'','supplier','11',6660000.00,0.00,'Purchase Id 37 for 45,000.00 litters of Petrol - PMS from PINNACLE OIL & GAS LIMITED ','2022-09-12 21:34:30','',''),('22','242',352,'','20','2',2947629.40,0.00,'Sales from shift 136 on 2022-09-12 21:39:56 ','2022-09-12 21:39:56','',''),('22','242',353,'','6.1','1',0.00,2947629.40,'Sales from shift 136 on 2022-09-12 21:39:56 ','2022-09-12 21:39:56','',''),('22','242',354,'','20','2',2853971.75,0.00,'Sales from shift 137 on 2022-09-13 21:43:58 ','2022-09-13 21:43:58','',''),('22','242',355,'','6.1','1',0.00,2853971.75,'Sales from shift 137 on 2022-09-13 21:43:58 ','2022-09-13 21:43:58','',''),('22','242',356,'','20','2',4247680.25,0.00,'Sales from shift 138 on 2022-09-14 22:25:46 ','2022-09-14 22:25:46','',''),('22','242',357,'','6.1','1',0.00,4247680.25,'Sales from shift 138 on 2022-09-14 22:25:46 ','2022-09-14 22:25:46','',''),('22','242',358,'','20','2',2927415.75,0.00,'Sales from shift 139 on 2022-09-17 15:23:28 ','2022-09-17 15:23:28','',''),('22','242',359,'','6.1','1',0.00,2927415.75,'Sales from shift 139 on 2022-09-17 15:23:28 ','2022-09-17 15:23:28','',''),('22','242',360,'','20','2',2481005.25,0.00,'Sales from shift 140 on 2022-09-17 15:28:16 ','2022-09-17 15:28:16','',''),('22','242',361,'','6.1','1',0.00,2481005.25,'Sales from shift 140 on 2022-09-17 15:28:16 ','2022-09-17 15:28:16','',''),('22','242',362,'','20','2',2606395.00,0.00,'Sales from shift 141 on 2022-09-17 21:55:20 ','2022-09-17 21:55:20','',''),('22','242',363,'','6.1','1',0.00,2606395.00,'Sales from shift 141 on 2022-09-17 21:55:20 ','2022-09-17 21:55:20','',''),('22','242',364,'','20','2',877343.75,0.00,'Sales from shift 142 on 2022-09-19 09:46:24 ','2022-09-19 09:46:24','',''),('22','242',365,'','6.1','1',0.00,877343.75,'Sales from shift 142 on 2022-09-19 09:46:24 ','2022-09-19 09:46:24','',''),('22','242',366,'','24','3',0.00,34200000.00,'Purchase Id 38 for 45,000.00 litters of Diesel - AGO from TIME PETROLEUM SERVICES','2022-09-19 10:22:11','',''),('22','242',367,'','supplier','14',34200000.00,0.00,'Purchase Id 38 for 45,000.00 litters of Diesel - AGO from TIME PETROLEUM SERVICES','2022-09-19 10:22:11','',''),('22','242',368,'','20','2',2898652.50,0.00,'Sales from shift 143 on 2022-09-20 09:49:11 ','2022-09-20 09:49:11','',''),('22','242',369,'','6.1','1',0.00,2898652.50,'Sales from shift 143 on 2022-09-20 09:49:11 ','2022-09-20 09:49:11','',''),('22','242',370,'','24','3',0.00,6660000.00,'Purchase Id 39 for 45,000.00 litters of Petrol - PMS from PINNACLE OIL & GAS LIMITED ','2022-09-24 19:04:03','',''),('22','242',371,'','supplier','11',6660000.00,0.00,'Purchase Id 39 for 45,000.00 litters of Petrol - PMS from PINNACLE OIL & GAS LIMITED ','2022-09-24 19:04:03','',''),('22','242',372,'','20','2',2669962.25,0.00,'Sales from shift 144 on 2022-09-24 19:13:31 ','2022-09-24 19:13:31','',''),('22','242',373,'','6.1','1',0.00,2669962.25,'Sales from shift 144 on 2022-09-24 19:13:31 ','2022-09-24 19:13:31','',''),('22','242',374,'','20','2',2925301.25,0.00,'Sales from shift 145 on 2022-09-24 19:25:36 ','2022-09-24 19:25:36','',''),('22','242',375,'','6.1','1',0.00,2925301.25,'Sales from shift 145 on 2022-09-24 19:25:36 ','2022-09-24 19:25:36','',''),('22','242',376,'','20','2',2169918.75,0.00,'Sales from shift 146 on 2022-09-24 19:29:48 ','2022-09-24 19:29:48','',''),('22','242',377,'','6.1','1',0.00,2169918.75,'Sales from shift 146 on 2022-09-24 19:29:48 ','2022-09-24 19:29:48','',''),('22','242',378,'','20','2',2669392.00,0.00,'Sales from shift 147 on 2022-09-24 19:33:33 ','2022-09-24 19:33:33','',''),('22','242',379,'','6.1','1',0.00,2669392.00,'Sales from shift 147 on 2022-09-24 19:33:33 ','2022-09-24 19:33:33','',''),('22','242',380,'','20','2',2807500.75,0.00,'Sales from shift 148 on 2022-09-25 08:33:59 ','2022-09-25 08:33:59','',''),('22','242',381,'','6.1','1',0.00,2807500.75,'Sales from shift 148 on 2022-09-25 08:33:59 ','2022-09-25 08:33:59','',''),('22','242',382,'','20','2',1129486.00,0.00,'Sales from shift 149 on 2022-09-26 21:28:36 ','2022-09-26 21:28:36','',''),('22','242',383,'','6.1','1',0.00,1129486.00,'Sales from shift 149 on 2022-09-26 21:28:36 ','2022-09-26 21:28:36','',''),('22','242',384,'','20','2',4214294.00,0.00,'Sales from shift 150 on 2022-09-26 21:33:11 ','2022-09-26 21:33:11','',''),('22','242',385,'','6.1','1',0.00,4214294.00,'Sales from shift 150 on 2022-09-26 21:33:11 ','2022-09-26 21:33:11','',''),('22','242',386,'','24','3',0.00,6660000.00,'Purchase Id 40 for 45,000.00 litters of Petrol - PMS from PINNACLE OIL & GAS LIMITED ','2022-09-27 21:53:23','',''),('22','242',387,'','supplier','11',6660000.00,0.00,'Purchase Id 40 for 45,000.00 litters of Petrol - PMS from PINNACLE OIL & GAS LIMITED ','2022-09-27 21:53:23','',''),('22','242',388,'','20','2',2652669.25,0.00,'Sales from shift 151 on 2022-09-27 21:58:32 ','2022-09-27 21:58:32','',''),('22','242',389,'','6.1','1',0.00,2652669.25,'Sales from shift 151 on 2022-09-27 21:58:32 ','2022-09-27 21:58:32','',''),('22','242',390,'','20','2',3493065.75,0.00,'Sales from shift 152 on 2022-09-29 09:44:12 ','2022-09-29 09:44:12','',''),('22','242',391,'','6.1','1',0.00,3493065.75,'Sales from shift 152 on 2022-09-29 09:44:12 ','2022-09-29 09:44:12','',''),('22','242',392,'','20','2',2662354.50,0.00,'Sales from shift 153 on 2022-09-29 22:25:11 ','2022-09-29 22:25:11','',''),('22','242',393,'','6.1','1',0.00,2662354.50,'Sales from shift 153 on 2022-09-29 22:25:11 ','2022-09-29 22:25:11','',''),('22','242',394,'','20','2',2782134.00,0.00,'Sales from shift 154 on 2022-10-01 20:27:31 ','2022-10-01 20:27:31','',''),('22','242',395,'','6.1','1',0.00,2782134.00,'Sales from shift 154 on 2022-10-01 20:27:31 ','2022-10-01 20:27:31','',''),('22','242',396,'','20','2',2546776.75,0.00,'Sales from shift 155 on 2022-10-01 21:07:13 ','2022-10-01 21:07:13','',''),('22','242',397,'','6.1','1',0.00,2546776.75,'Sales from shift 155 on 2022-10-01 21:07:13 ','2022-10-01 21:07:13','',''),('22','242',398,'','24','3',0.00,6660000.00,'Purchase Id 41 for 45,000.00 litters of Petrol - PMS from PINNACLE OIL & GAS LIMITED ','2022-10-03 16:47:15','',''),('22','242',399,'','supplier','11',6660000.00,0.00,'Purchase Id 41 for 45,000.00 litters of Petrol - PMS from PINNACLE OIL & GAS LIMITED ','2022-10-03 16:47:15','',''),('22','242',400,'','20','2',1181221.50,0.00,'Sales from shift 156 on 2022-10-03 16:54:37 ','2022-10-03 16:54:37','',''),('22','242',401,'','6.1','1',0.00,1181221.50,'Sales from shift 156 on 2022-10-03 16:54:37 ','2022-10-03 16:54:37','',''),('22','242',402,'','20','2',2388425.75,0.00,'Sales from shift 157 on 2022-10-04 11:01:53 ','2022-10-04 11:01:53','',''),('22','242',403,'','6.1','1',0.00,2388425.75,'Sales from shift 157 on 2022-10-04 11:01:53 ','2022-10-04 11:01:53','',''),('22','242',404,'','20','2',2250148.25,0.00,'Sales from shift 158 on 2022-10-05 10:46:08 ','2022-10-05 10:46:08','',''),('22','242',405,'','6.1','1',0.00,2250148.25,'Sales from shift 158 on 2022-10-05 10:46:08 ','2022-10-05 10:46:08','',''),('22','242',406,'','20','2',2638327.50,0.00,'Sales from shift 159 on 2022-10-05 21:46:29 ','2022-10-05 21:46:29','',''),('22','242',407,'','6.1','1',0.00,2638327.50,'Sales from shift 159 on 2022-10-05 21:46:29 ','2022-10-05 21:46:29','',''),('22','242',408,'','20','2',2306563.75,0.00,'Sales from shift 160 on 2022-10-09 09:41:38 ','2022-10-09 09:41:38','',''),('22','242',409,'','6.1','1',0.00,2306563.75,'Sales from shift 160 on 2022-10-09 09:41:38 ','2022-10-09 09:41:38','',''),('22','242',410,'','20','2',3374232.25,0.00,'Sales from shift 161 on 2022-10-09 09:45:35 ','2022-10-09 09:45:35','',''),('22','242',411,'','6.1','1',0.00,3374232.25,'Sales from shift 161 on 2022-10-09 09:45:35 ','2022-10-09 09:45:35','',''),('22','242',412,'','20','2',2625773.00,0.00,'Sales from shift 162 on 2022-10-09 09:49:19 ','2022-10-09 09:49:19','',''),('22','242',413,'','6.1','1',0.00,2625773.00,'Sales from shift 162 on 2022-10-09 09:49:19 ','2022-10-09 09:49:19','',''),('22','242',414,'','24','3',0.00,6660000.00,'Purchase Id 42 for 45,000.00 litters of Petrol - PMS from PINNACLE OIL & GAS LIMITED ','2022-10-10 10:35:20','',''),('22','242',415,'','supplier','11',6660000.00,0.00,'Purchase Id 42 for 45,000.00 litters of Petrol - PMS from PINNACLE OIL & GAS LIMITED ','2022-10-10 10:35:20','',''),('22','242',416,'','20','2',1342610.75,0.00,'Sales from shift 163 on 2022-10-10 11:06:59 ','2022-10-10 11:06:59','',''),('22','242',417,'','6.1','1',0.00,1342610.75,'Sales from shift 163 on 2022-10-10 11:06:59 ','2022-10-10 11:06:59','',''),('22','242',418,'','24','3',0.00,34176440.00,'Purchase Id 43 for 44,969.00 litters of Diesel - AGO from NIPC0 PLC','2022-10-14 12:32:15','',''),('22','242',419,'','supplier','8',34176440.00,0.00,'Purchase Id 43 for 44,969.00 litters of Diesel - AGO from NIPC0 PLC','2022-10-14 12:32:15','',''),('22','242',420,'','20','2',1628699.25,0.00,'Sales from shift 164 on 2022-10-14 12:39:48 ','2022-10-14 12:39:48','',''),('22','242',421,'','6.1','1',0.00,1628699.25,'Sales from shift 164 on 2022-10-14 12:39:48 ','2022-10-14 12:39:48','',''),('22','242',422,'','20','2',2219513.50,0.00,'Sales from shift 165 on 2022-10-14 12:44:12 ','2022-10-14 12:44:12','',''),('22','242',423,'','6.1','1',0.00,2219513.50,'Sales from shift 165 on 2022-10-14 12:44:12 ','2022-10-14 12:44:12','',''),('22','242',424,'','20','2',2504031.50,0.00,'Sales from shift 166 on 2022-10-14 12:48:43 ','2022-10-14 12:48:43','',''),('22','242',425,'','6.1','1',0.00,2504031.50,'Sales from shift 166 on 2022-10-14 12:48:43 ','2022-10-14 12:48:43','',''),('22','242',426,'','20','2',2419993.50,0.00,'Sales from shift 167 on 2022-10-14 12:52:15 ','2022-10-14 12:52:15','',''),('22','242',427,'','6.1','1',0.00,2419993.50,'Sales from shift 167 on 2022-10-14 12:52:15 ','2022-10-14 12:52:15','',''),('22','242',428,'','20','2',1986846.00,0.00,'Sales from shift 168 on 2022-10-15 10:27:29 ','2022-10-15 10:27:29','',''),('22','242',429,'','6.1','1',0.00,1986846.00,'Sales from shift 168 on 2022-10-15 10:27:29 ','2022-10-15 10:27:29','',''),('22','242',430,'','20','2',3770413.50,0.00,'Sales from shift 169 on 2022-10-16 13:08:39 ','2022-10-16 13:08:39','',''),('22','242',431,'','6.1','1',0.00,3770413.50,'Sales from shift 169 on 2022-10-16 13:08:39 ','2022-10-16 13:08:39','',''),('22','242',432,'','20','2',1168100.75,0.00,'Sales from shift 170 on 2022-10-17 15:35:40 ','2022-10-17 15:35:40','',''),('22','242',433,'','6.1','1',0.00,1168100.75,'Sales from shift 170 on 2022-10-17 15:35:40 ','2022-10-17 15:35:40','',''),('22','242',434,'','24','3',0.00,6660000.00,'Purchase Id 44 for 45,000.00 litters of Petrol - PMS from NIPC0 PLC','2022-11-14 22:03:01','',''),('22','242',435,'','supplier','8',6660000.00,0.00,'Purchase Id 44 for 45,000.00 litters of Petrol - PMS from NIPC0 PLC','2022-11-14 22:03:01','',''),('22','242',436,'','20','2',2165161.50,0.00,'Sales from shift 171 on 2022-11-15 12:50:30 ','2022-11-15 12:50:30','',''),('22','242',437,'','6.1','1',0.00,2165161.50,'Sales from shift 171 on 2022-11-15 12:50:30 ','2022-11-15 12:50:30','',''),('22','242',438,'','20','2',2395202.50,0.00,'Sales from shift 172 on 2022-11-15 12:55:41 ','2022-11-15 12:55:41','',''),('22','242',439,'','6.1','1',0.00,2395202.50,'Sales from shift 172 on 2022-11-15 12:55:41 ','2022-11-15 12:55:41','',''),('22','242',440,'','20','2',2037874.00,0.00,'Sales from shift 173 on 2022-11-15 13:00:58 ','2022-11-15 13:00:58','',''),('22','242',441,'','6.1','1',0.00,2037874.00,'Sales from shift 173 on 2022-11-15 13:00:58 ','2022-11-15 13:00:58','',''),('22','242',442,'','20','2',3216375.00,0.00,'Sales from shift 174 on 2022-11-15 13:06:56 ','2022-11-15 13:06:56','',''),('22','242',443,'','6.1','1',0.00,3216375.00,'Sales from shift 174 on 2022-11-15 13:06:56 ','2022-11-15 13:06:56','',''),('22','242',444,'','20','2',2162283.75,0.00,'Sales from shift 175 on 2022-11-15 13:12:55 ','2022-11-15 13:12:55','',''),('22','242',445,'','6.1','1',0.00,2162283.75,'Sales from shift 175 on 2022-11-15 13:12:55 ','2022-11-15 13:12:55','',''),('22','242',446,'','20','2',1931398.00,0.00,'Sales from shift 176 on 2022-11-15 13:18:24 ','2022-11-15 13:18:24','',''),('22','242',447,'','6.1','1',0.00,1931398.00,'Sales from shift 176 on 2022-11-15 13:18:24 ','2022-11-15 13:18:24','',''),('22','242',448,'','20','2',519108.75,0.00,'Sales from shift 177 on 2022-11-15 13:22:57 ','2022-11-15 13:22:57','',''),('22','242',449,'','6.1','1',0.00,519108.75,'Sales from shift 177 on 2022-11-15 13:22:57 ','2022-11-15 13:22:57','',''),('22','242',450,'','20','2',1579012.00,0.00,'Sales from shift 178 on 2022-11-15 13:25:26 ','2022-11-15 13:25:26','',''),('22','242',451,'','6.1','1',0.00,1579012.00,'Sales from shift 178 on 2022-11-15 13:25:26 ','2022-11-15 13:25:26','',''),('22','242',452,'','20','2',2044956.25,0.00,'Sales from shift 179 on 2022-11-15 13:28:11 ','2022-11-15 13:28:11','',''),('22','242',453,'','6.1','1',0.00,2044956.25,'Sales from shift 179 on 2022-11-15 13:28:11 ','2022-11-15 13:28:11','',''),('22','242',454,'','20','2',1626671.25,0.00,'Sales from shift 180 on 2022-11-15 13:30:16 ','2022-11-15 13:30:16','',''),('22','242',455,'','6.1','1',0.00,1626671.25,'Sales from shift 180 on 2022-11-15 13:30:16 ','2022-11-15 13:30:16','',''),('22','242',456,'','20','2',2324107.25,0.00,'Sales from shift 181 on 2022-11-15 13:34:02 ','2022-11-15 13:34:02','',''),('22','242',457,'','6.1','1',0.00,2324107.25,'Sales from shift 181 on 2022-11-15 13:34:02 ','2022-11-15 13:34:02','',''),('22','242',458,'','24','3',0.00,6660000.00,'Purchase Id 45 for 45,000.00 litters of Petrol - PMS from PINNACLE OIL & GAS LIMITED ','2022-11-16 15:58:26','',''),('22','242',459,'','supplier','11',6660000.00,0.00,'Purchase Id 45 for 45,000.00 litters of Petrol - PMS from PINNACLE OIL & GAS LIMITED ','2022-11-16 15:58:26','','');
/*!40000 ALTER TABLE `ledgers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `options`
--

DROP TABLE IF EXISTS `options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `options` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` bigint NOT NULL,
  `station_id` bigint NOT NULL,
  `option_key` varchar(200) NOT NULL,
  `option_value` longtext,
  `thedate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `station_id` (`station_id`,`option_key`),
  KEY `company_id` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `options`
--

LOCK TABLES `options` WRITE;
/*!40000 ALTER TABLE `options` DISABLE KEYS */;
/*!40000 ALTER TABLE `options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products`
--

DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `measurement` varchar(20) NOT NULL,
  `quantity2` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`code`,`name`,`measurement`,`quantity2`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `cleanup` (`cleanup`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products`
--

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (1,'22','242','PMS','Petrol','Litres',0,148.00,165.00,165.00,165.00,0.00,0,'2022-03-22 11:40:08','793','808','2022-04-25 12:39:55',0),(2,'22','242','AGO','Diesel','Litres',0,760.00,0.00,0.00,0.00,0.00,0,'2022-03-22 11:52:06','793','793','2022-03-22 11:52:06',0);
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_changevalues`
--

DROP TABLE IF EXISTS `products_changevalues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_changevalues` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `change_id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity` bigint NOT NULL,
  `oldrate` decimal(20,2) NOT NULL,
  `newrate` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`change_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_changevalues`
--

LOCK TABLES `products_changevalues` WRITE;
/*!40000 ALTER TABLE `products_changevalues` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_changevalues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_prices`
--

DROP TABLE IF EXISTS `products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_prices`
--

LOCK TABLES `products_prices` WRITE;
/*!40000 ALTER TABLE `products_prices` DISABLE KEYS */;
INSERT INTO `products_prices` VALUES (1,'22','242',1,1.58,0.00,0.00,0.00,'Cost from purchase id #1','2022-04-16 13:01:03','793'),(2,'22','242',1,158.00,165.00,165.00,165.00,'BECAUSE OF PRICE ERROR','2022-04-16 13:12:21','793'),(3,'22','242',2,625.00,0.00,0.00,0.00,'Cost from purchase id #4','2022-05-05 14:08:39','808'),(4,'22','242',1,148.00,165.00,0.00,0.00,'Cost from purchase id #5','2022-05-06 12:59:03','808'),(5,'22','242',2,648.00,0.00,0.00,0.00,'Cost from purchase id #9','2022-05-19 15:47:03','808'),(6,'22','242',2,670.00,0.00,0.00,0.00,'Cost from purchase id #12','2022-05-28 14:31:30','808'),(7,'22','242',2,740.00,0.00,0.00,0.00,'Cost from purchase id #15','2022-06-10 18:29:13','808'),(8,'22','242',2,760.00,0.00,0.00,0.00,'Cost from purchase id #18','2022-06-18 11:15:21','808');
/*!40000 ALTER TABLE `products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_reconciliations`
--

DROP TABLE IF EXISTS `products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_reconciliations`
--

LOCK TABLES `products_reconciliations` WRITE;
/*!40000 ALTER TABLE `products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_shortages`
--

DROP TABLE IF EXISTS `products_shortages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_shortages` (
  `shortage_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shortagedate` date NOT NULL,
  `product_id` varchar(10) NOT NULL,
  `type` int NOT NULL DEFAULT '0',
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`shortage_id`),
  KEY `companycode` (`company_id`,`shortagedate`,`product_id`,`rate`,`quantity`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_shortages`
--

LOCK TABLES `products_shortages` WRITE;
/*!40000 ALTER TABLE `products_shortages` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_shortages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pts_nozzles`
--

DROP TABLE IF EXISTS `pts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pts_nozzles` (
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pts_id` int NOT NULL,
  `pump` varchar(20) NOT NULL,
  `code` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `last_volume` decimal(20,2) NOT NULL,
  `last_price` decimal(20,2) NOT NULL,
  `last_amount` decimal(20,2) NOT NULL,
  `last_transaction` int NOT NULL DEFAULT '0',
  `total_volume` decimal(20,2) NOT NULL,
  `total_amount` decimal(20,2) NOT NULL,
  `total_transactions` decimal(20,2) NOT NULL,
  `lastconnect` datetime NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `terminal_id` (`pts_id`,`pump`,`code`,`lastconnect`),
  KEY `companycode` (`company_id`,`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pts_nozzles`
--

LOCK TABLES `pts_nozzles` WRITE;
/*!40000 ALTER TABLE `pts_nozzles` DISABLE KEYS */;
/*!40000 ALTER TABLE `pts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases`
--

DROP TABLE IF EXISTS `purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=46 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases`
--

LOCK TABLES `purchases` WRITE;
/*!40000 ALTER TABLE `purchases` DISABLE KEYS */;
INSERT INTO `purchases` VALUES (4,'22','242','2022-05-05',2,3,625.00,40000.00,0.00,0.00,25000000.00,0.00,'','0024077','T-15130-LA','','','','2022-05-05 14:03:08',15,'DIESEL TO SUPPLY TO STARCO FILLING STATION','808','','0000-00-00 00:00:00','808','2022-05-05 14:08:39'),(5,'22','242','2022-05-06',1,4,148.00,40000.00,0.00,0.00,5920000.00,0.00,'','0000591','T-15130-LA','','','','2022-05-06 12:58:05',15,'PMS TO DELIVERED TO STARCO FILLING STATION ,DOYIN ORILE BUS-STOP','808','','0000-00-00 00:00:00','808','2022-05-06 12:59:03'),(6,'22','242','2022-05-10',1,5,148.00,40000.00,0.00,0.00,5920000.00,0.00,'','0289984','T-15130-LA','','','','2022-05-10 19:06:45',15,'','808','','0000-00-00 00:00:00','808','2022-05-10 19:09:55'),(7,'22','242','2022-05-12',1,4,148.00,40000.00,0.00,0.00,5920000.00,0.00,'','11052239','T-15130-LA','','','','2022-05-12 19:50:29',15,'OK','808','','0000-00-00 00:00:00','808','2022-05-12 19:51:45'),(8,'22','242','2022-05-17',1,5,148.00,40000.00,0.00,0.00,5920000.00,0.00,'','','T15130LA','','','','2022-05-17 21:59:59',15,'','808','','0000-00-00 00:00:00','808','2022-05-17 22:04:16'),(9,'22','242','2022-05-19',2,6,648.00,45000.00,0.00,0.00,29160000.00,0.00,'','','T15130LA','','','','2022-05-19 15:44:27',15,'To starco filling station','808','','0000-00-00 00:00:00','808','2022-05-19 15:47:03'),(10,'22','242','2022-05-24',1,5,148.00,40000.00,0.00,0.00,5920000.00,0.00,'','','T15130LA','','','','2022-05-24 09:46:06',15,'','808','','0000-00-00 00:00:00','808','2022-05-24 09:46:52'),(11,'22','242','2022-05-27',1,7,148.00,45000.00,0.00,0.00,6660000.00,0.00,'','','T15130LA','','','','2022-05-27 18:11:57',15,'','808','','0000-00-00 00:00:00','808','2022-05-27 18:13:37'),(12,'22','242','2022-05-27',2,6,670.00,45000.00,0.00,0.00,30150000.00,0.00,'','0040682','T15130LA','','','','2022-05-28 14:29:19',15,'','808','808','2022-05-28 14:31:05','808','2022-05-28 14:31:30'),(13,'22','242','2022-05-31',1,5,148.00,40000.00,0.00,0.00,5920000.00,0.00,'','M/T 1600047943','T15130LA','','','','2022-05-31 13:46:49',15,'','808','','0000-00-00 00:00:00','808','2022-05-31 13:47:41'),(14,'22','242','2022-06-04',1,8,148.00,45000.00,0.00,0.00,6660000.00,0.00,'','N504579','T15130LA','','','','2022-06-04 19:46:27',15,'','808','','0000-00-00 00:00:00','808','2022-06-04 19:47:16'),(15,'22','242','2022-06-09',2,8,740.00,45000.00,0.00,0.00,33300000.00,0.00,'','N504579','T15130LA','','','','2022-06-10 18:28:13',15,'','808','','0000-00-00 00:00:00','808','2022-06-10 18:29:13'),(16,'22','242','2022-06-10',1,9,148.00,40000.00,0.00,0.00,5920000.00,0.00,'','AE136741','T15130LA','','','','2022-06-10 18:37:19',15,'','808','','0000-00-00 00:00:00','808','2022-06-10 18:37:51'),(17,'22','242','2022-06-15',1,5,148.00,45000.00,0.00,0.00,6660000.00,0.00,'','00131545TP','JJJ18XZ','','','','2022-06-15 18:31:42',15,'','808','','0000-00-00 00:00:00','808','2022-06-15 18:32:12'),(18,'22','242','2022-06-13',2,8,760.00,45000.00,0.00,0.00,34200000.00,0.00,'','N504579','T15130LA','','','','2022-06-18 11:14:29',15,'','808','','0000-00-00 00:00:00','808','2022-06-18 11:15:21'),(19,'22','242','2022-06-18',1,5,148.00,45000.00,0.00,0.00,6660000.00,0.00,'','M/T 1600049937','T15130LA','','','','2022-06-20 11:12:47',15,'','808','','0000-00-00 00:00:00','808','2022-06-20 11:13:29'),(20,'22','242','2022-06-22',1,5,148.00,40000.00,0.00,0.00,5920000.00,0.00,'','M/T 1600049936','T15130LA','','','','2022-06-25 11:46:18',15,'','808','','0000-00-00 00:00:00','808','2022-06-25 11:46:59'),(21,'22','242','2022-06-27',1,9,148.00,45000.00,0.00,0.00,6660000.00,0.00,'','AE138191','T15130LA','','','','2022-06-27 12:47:24',15,'','808','','0000-00-00 00:00:00','808','2022-06-27 12:47:58'),(22,'22','242','2022-06-30',1,9,148.00,40000.00,0.00,0.00,5920000.00,0.00,'','AE138640','T15130LA','','','','2022-06-30 18:00:14',15,'','808','','0000-00-00 00:00:00','808','2022-06-30 18:00:35'),(23,'22','242','2022-06-22',2,10,760.00,45000.00,0.00,0.00,34200000.00,0.00,'','000031185TP','T15130LA','','','','2022-07-01 13:02:16',15,'','808','','0000-00-00 00:00:00','808','2022-07-01 13:02:54'),(24,'22','242','2022-07-02',1,9,148.00,40000.00,0.00,0.00,5920000.00,0.00,'','AE138749','T15130LA','','','','2022-07-02 11:05:42',15,'','808','','0000-00-00 00:00:00','808','2022-07-02 11:06:09'),(25,'22','242','2022-07-10',1,5,148.00,45000.00,0.00,0.00,6660000.00,0.00,'','000134134TP','T15130LA','','','','2022-07-10 17:43:25',15,'','808','','0000-00-00 00:00:00','808','2022-07-10 17:43:51'),(26,'22','242','2022-07-15',1,11,148.00,45000.00,0.00,0.00,6660000.00,0.00,'','S_015227','T15130LA','','','','2022-07-15 18:17:20',15,'','808','','0000-00-00 00:00:00','808','2022-07-15 18:17:44'),(27,'22','242','2022-07-19',1,11,148.00,45000.00,0.00,0.00,6660000.00,0.00,'','S_015833','T15777LA','','','','2022-07-19 15:47:21',15,'','808','','0000-00-00 00:00:00','808','2022-07-19 15:48:07'),(28,'22','242','2022-07-20',2,10,760.00,40000.00,0.00,0.00,30400000.00,0.00,'','000031625TP','T15130LA','','','','2022-07-20 12:07:21',15,'','808','','0000-00-00 00:00:00','808','2022-07-20 12:07:40'),(29,'22','242','2022-07-28',1,11,148.00,40000.00,0.00,0.00,5920000.00,0.00,'','S_019571','T15777LA','','','','2022-07-29 12:16:46',15,'','808','','0000-00-00 00:00:00','808','2022-07-29 12:17:05'),(30,'22','242','2022-07-28',1,11,148.00,40000.00,0.00,0.00,5920000.00,0.00,'','S_019573','T15130LA','','','','2022-07-30 22:16:46',15,'','808','','0000-00-00 00:00:00','808','2022-07-30 22:17:37'),(31,'22','242','2022-08-04',2,8,760.00,45000.00,0.00,0.00,34200000.00,0.00,'','N504579','T15777LA','','','','2022-08-04 10:24:33',15,'','808','','0000-00-00 00:00:00','808','2022-08-04 10:24:56'),(32,'22','242','2022-08-12',1,8,148.00,45000.00,0.00,0.00,6660000.00,0.00,'','N305028','T15130LA','','','','2022-08-13 10:55:23',15,'','808','','0000-00-00 00:00:00','808','2022-08-13 10:56:55'),(33,'22','242','2022-08-23',1,12,148.00,45000.00,0.00,0.00,6660000.00,0.00,'','W1D1-PRO2201101','T15130LA','','','','2022-08-23 13:08:59',15,'','808','','0000-00-00 00:00:00','808','2022-08-23 13:09:36'),(34,'22','242','2022-08-25',2,2,760.00,45000.00,0.00,0.00,34200000.00,0.00,'','0033471','TI5130LA','','','','2022-08-25 13:28:12',15,'Ago 45,000','808','','0000-00-00 00:00:00','808','2022-08-30 10:21:28'),(35,'22','242','2022-08-30',1,13,148.00,42000.00,0.00,0.00,6216000.00,0.00,'','0007827','T15777LA','','','','2022-08-30 10:20:59',15,'','808','','0000-00-00 00:00:00','808','2022-08-30 10:25:50'),(36,'22','242','2022-08-30',1,8,148.00,45000.00,0.00,0.00,6660000.00,0.00,'','2022041258','T15130LA','','','','2022-09-01 19:42:05',15,'','808','','0000-00-00 00:00:00','808','2022-09-01 19:42:46'),(37,'22','242','2022-09-08',1,11,148.00,45000.00,0.00,0.00,6660000.00,0.00,'','S_023700','T15130LA','','','','2022-09-12 21:33:01',15,'','808','808','2022-09-12 21:34:10','808','2022-09-12 21:34:30'),(38,'22','242','2022-09-16',2,14,760.00,45000.00,0.00,0.00,34200000.00,0.00,'','0027676','T15777LA','','','','2022-09-19 10:20:46',15,'','808','808','2022-09-19 10:21:53','808','2022-09-19 10:22:11'),(39,'22','242','2022-09-23',1,11,148.00,45000.00,0.00,0.00,6660000.00,0.00,'','S_024916','T15130LA','','','','2022-09-24 19:03:43',15,'','808','','0000-00-00 00:00:00','808','2022-09-24 19:04:03'),(40,'22','242','2022-09-22',1,11,148.00,45000.00,0.00,0.00,6660000.00,0.00,'','S_024920','T15777LA','','','','2022-09-27 21:52:46',15,'','808','808','2022-09-27 21:53:15','808','2022-09-27 21:53:23'),(41,'22','242','2022-09-29',1,11,148.00,45000.00,0.00,0.00,6660000.00,0.00,'','S_026267','T15130LA','','','','2022-10-03 16:46:38',15,'','808','808','2022-10-03 16:47:05','808','2022-10-03 16:47:15'),(42,'22','242','2022-10-09',1,11,148.00,45000.00,0.00,0.00,6660000.00,0.00,'','S_028148','T15130LA','','','','2022-10-10 10:35:03',15,'','808','','0000-00-00 00:00:00','808','2022-10-10 10:35:20'),(43,'22','242','2022-10-13',2,8,760.00,44969.00,0.00,0.00,34176440.00,0.00,'','2022046567','T15777LA','','','','2022-10-14 12:31:14',15,'','808','808','2022-10-14 12:31:46','808','2022-10-14 12:32:15'),(44,'22','242','2022-11-14',1,8,148.00,45000.00,0.00,0.00,6660000.00,0.00,'','2022051774','T15777LA','','','','2022-11-14 22:02:12',15,'','808','','0000-00-00 00:00:00','808','2022-11-14 22:03:01'),(45,'22','242','2022-11-16',1,11,148.00,45000.00,0.00,0.00,6660000.00,0.00,'','S_033913','T15130LA','','','','2022-11-16 15:57:54',15,'','808','','0000-00-00 00:00:00','808','2022-11-16 15:58:26');
/*!40000 ALTER TABLE `purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_payments`
--

DROP TABLE IF EXISTS `purchases_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `supplier_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`supplier_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_payments`
--

LOCK TABLES `purchases_payments` WRITE;
/*!40000 ALTER TABLE `purchases_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `purchases_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_receptions`
--

DROP TABLE IF EXISTS `purchases_receptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_receptions` (
  `bridge_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `purchase_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `loadingdate` datetime NOT NULL,
  `loadingpoint` varchar(100) DEFAULT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `received` decimal(20,2) NOT NULL,
  `distributed` decimal(20,2) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `vessel` varchar(50) NOT NULL,
  `drivername` varchar(30) NOT NULL,
  `driverphone` varchar(30) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`bridge_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`supplier_id`,`loadingdate`,`quantity`,`waybill`,`meterno`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`purchase_id`),
  KEY `truck_id` (`tank_id`)
) ENGINE=InnoDB AUTO_INCREMENT=97 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_receptions`
--

LOCK TABLES `purchases_receptions` WRITE;
/*!40000 ALTER TABLE `purchases_receptions` DISABLE KEYS */;
INSERT INTO `purchases_receptions` VALUES (5,'22',4,'242',2,3,'2022-05-05 00:00:00','MAO',27000.00,27000.00,0.00,'0024077','','3','T-15130-LA','MOSURU','08055618799','OK',5,'2022-05-05 14:23:48','808','0000-00-00 00:00:00','','2022-05-05 15:06:42','808'),(6,'22',4,'242',2,3,'2022-05-05 00:00:00','MAO',13000.00,13000.00,0.00,'0024077','','4','T-15130-LA','MOSURU','08055618799','OK',5,'2022-05-05 14:23:48','808','0000-00-00 00:00:00','','2022-05-05 15:07:23','808'),(7,'22',5,'242',1,4,'2022-05-06 00:00:00','FIRST ROYAL',26500.00,26500.00,0.00,'0000591','','1','T-15130-LA','MOSURU','08055618799','OK',5,'2022-05-06 13:06:40','808','0000-00-00 00:00:00','','2022-05-10 19:08:33','808'),(8,'22',5,'242',1,4,'2022-05-06 00:00:00','FIRST ROYAL',13500.00,13500.00,0.00,'0000591','','2','T-15130-LA','MOSURU','08055618799','OK',5,'2022-05-06 13:06:40','808','0000-00-00 00:00:00','','2022-05-07 11:03:40','808'),(10,'22',6,'242',1,5,'2022-05-10 00:00:00','AA RANO',13500.00,13500.00,0.00,'0289984','','2','T-15130-LA','MOSURU','08055618799','',5,'2022-05-10 19:16:53','808','0000-00-00 00:00:00','','2022-05-10 19:17:20','808'),(11,'22',6,'242',1,5,'2022-05-10 00:00:00','AA RANO',17000.00,17000.00,0.00,'0289984','','1','T-15130-LA','MOSURU','08055618799','OK',5,'2022-05-10 19:27:07','808','0000-00-00 00:00:00','','2022-05-10 19:27:52','808'),(12,'22',6,'242',1,5,'2022-05-10 00:00:00','AA RANO',9500.00,9500.00,0.00,'0289984','','2','T-15130-LA','MOSURU','08055618799','OK',5,'2022-05-10 19:27:07','808','0000-00-00 00:00:00','','2022-05-10 19:27:34','808'),(15,'22',7,'242',1,4,'2022-05-12 00:00:00','FIRST ROYAL',13500.00,19.51,0.00,'11052238','','1','T-15130-LA','MOSURU','08055618799','OK',5,'2022-05-12 20:12:39','808','0000-00-00 00:00:00','','2022-05-17 22:01:15','808'),(16,'22',7,'242',1,4,'2022-05-12 00:00:00','FIRST ROYAL',26500.00,39980.49,0.00,'11052238','','2','T-15130-LA','MOSURU','08055618799','OK',5,'2022-05-12 20:12:39','808','0000-00-00 00:00:00','','2022-05-17 22:00:55','808'),(17,'22',8,'242',1,5,'2022-05-17 00:00:00','AA RANO',35500.00,35500.00,0.00,'M/T1600047945','','1','T15130LA','MOSURU','08055618799','',5,'2022-05-17 22:07:55','808','0000-00-00 00:00:00','','2022-05-17 22:08:54','808'),(18,'22',8,'242',1,5,'2022-05-17 00:00:00','AA RANO',4500.00,4500.00,0.00,'M/T1600047945','','2','T15130LA','MOSURU','08055618799','',5,'2022-05-17 22:07:55','808','0000-00-00 00:00:00','','2022-05-17 22:08:25','808'),(19,'22',9,'242',2,6,'2022-05-19 00:00:00','CHIPET',30000.00,30000.00,0.00,'0001146','','3','T15130LA','MOSURU','08055618799','OK',5,'2022-05-19 15:49:35','808','0000-00-00 00:00:00','','2022-05-24 09:49:00','808'),(20,'22',9,'242',2,6,'2022-05-19 00:00:00','CHIPET',15000.00,15000.00,0.00,'0001146','','4','T15130LA','MOSURU','08055618799','OK',5,'2022-05-19 15:49:35','808','0000-00-00 00:00:00','','2022-05-24 09:49:31','808'),(21,'22',10,'242',1,5,'2022-05-24 00:00:00','AA RANO',27000.00,27000.00,0.00,'1600047944','','1','T15130LA','MR. MONSURU','08059495375','',5,'2022-05-24 09:59:13','808','0000-00-00 00:00:00','','2022-05-24 10:00:03','808'),(22,'22',10,'242',1,5,'2022-05-24 00:00:00','AA RANO',13000.00,13000.00,0.00,'1600047944','','2','T15130LA','MR. MONSURU','08059495375','',5,'2022-05-24 09:59:13','808','0000-00-00 00:00:00','','2022-05-24 09:59:41','808'),(23,'22',11,'242',1,7,'2022-05-27 00:00:00','STALLIONAIRE NIG LTD',30000.00,30000.00,0.00,'WA300005850','','1','T15130LA','MOSURU','08180757612','',5,'2022-05-27 18:19:34','808','0000-00-00 00:00:00','','2022-05-27 18:20:49','808'),(24,'22',11,'242',1,7,'2022-05-27 00:00:00','STALLIONAIRE NIG LTD',15000.00,15000.00,0.00,'WA300005850','','2','T15130LA','MOSURU','08180757612','',5,'2022-05-27 18:19:34','808','0000-00-00 00:00:00','','2022-05-27 18:20:21','808'),(25,'22',12,'242',2,6,'2022-05-28 00:00:00','CHIPET INT\'L LTD',24500.00,24500.00,0.00,'0040682','','3','T15130LA','MOSURU','08180757612','',5,'2022-05-28 14:35:16','808','0000-00-00 00:00:00','','2022-05-28 14:36:13','808'),(26,'22',12,'242',2,6,'2022-05-28 00:00:00','CHIPET INT\'L LTD',20500.00,20500.00,0.00,'0040682','','4','T15130LA','MOSURU','08180757612','',5,'2022-05-28 14:35:16','808','0000-00-00 00:00:00','','2022-05-28 14:35:51','808'),(27,'22',13,'242',1,5,'2022-05-31 00:00:00','AA RANO',26500.00,26500.00,0.00,'M/T 1600047943','','1','T15130LA','MR. MONSURU','08059495375','',5,'2022-05-31 13:50:19','808','0000-00-00 00:00:00','','2022-05-31 13:50:58','808'),(28,'22',13,'242',1,5,'2022-05-31 00:00:00','AA RANO',13500.00,13500.00,0.00,'M/T 1600047943','','2','T15130LA','MR. MONSURU','08059495375','',5,'2022-05-31 13:50:19','808','0000-00-00 00:00:00','','2022-05-31 13:50:38','808'),(29,'22',14,'242',1,8,'2022-06-04 00:00:00','NNPC EJIGBO DEPOT',30000.00,30000.00,0.00,'N504579','','1','T15130LA','MR. MONSURU','08059495375','',5,'2022-06-04 19:49:30','808','0000-00-00 00:00:00','','2022-06-04 19:50:52','808'),(30,'22',14,'242',1,8,'2022-06-04 00:00:00','NNPC EJIGBO DEPOT',15000.00,15000.00,0.00,'N504579','','2','T15130LA','MR. MONSURU','08059495375','',5,'2022-06-04 19:49:30','808','0000-00-00 00:00:00','','2022-06-04 19:50:30','808'),(31,'22',15,'242',2,8,'2022-06-10 00:00:00','NIPC0 PLC',30000.00,30000.00,0.00,'N504579','','3','T15130LA','MR. MONSURU','08059495375','',5,'2022-06-10 18:31:50','808','0000-00-00 00:00:00','','2022-06-10 18:33:02','808'),(32,'22',15,'242',2,8,'2022-06-10 00:00:00','NIPC0 PLC',15000.00,15000.00,0.00,'N504579','','4','T15130LA','MR. MONSURU','08059495375','',5,'2022-06-10 18:31:50','808','0000-00-00 00:00:00','','2022-06-10 18:32:50','808'),(33,'22',16,'242',1,9,'2022-06-10 00:00:00','AITEO APAPA',26500.00,26500.00,0.00,'AE136741','','1','T15130LA','MR. MONSURU','08059495375','',5,'2022-06-10 18:43:13','808','0000-00-00 00:00:00','','2022-06-10 18:43:46','808'),(34,'22',16,'242',1,9,'2022-06-10 00:00:00','AITEO APAPA',13500.00,13500.00,0.00,'AE136741','','2','T15130LA','MR. MONSURU','08059495375','',5,'2022-06-10 18:43:13','808','0000-00-00 00:00:00','','2022-06-10 18:43:30','808'),(35,'22',17,'242',1,5,'2022-06-15 00:00:00','AA RANO',30000.00,30000.00,0.00,'000131545TP','','1','JJJ18XZ','MR. MONSURU','08059495375','',5,'2022-06-15 18:34:51','808','0000-00-00 00:00:00','','2022-06-15 18:35:55','808'),(36,'22',17,'242',1,5,'2022-06-15 00:00:00','AA RANO',15000.00,15000.00,0.00,'000131545TP','','2','JJJ18XZ','MR. MONSURU','08059495375','',5,'2022-06-15 18:34:51','808','0000-00-00 00:00:00','','2022-06-15 18:35:36','808'),(37,'22',18,'242',2,8,'2022-06-18 00:00:00','NIPC0 PLC',24000.00,24000.00,0.00,'N504579','','3','T15130LA','MR. MONSURU','08059495375','',5,'2022-06-18 11:16:40','808','0000-00-00 00:00:00','','2022-06-18 11:17:25','808'),(38,'22',18,'242',2,8,'2022-06-18 00:00:00','NIPC0 PLC',21000.00,21000.00,0.00,'N504579','','4','T15130LA','MR. MONSURU','08059495375','',5,'2022-06-18 11:16:40','808','0000-00-00 00:00:00','','2022-06-18 11:17:01','808'),(39,'22',19,'242',1,5,'2022-06-20 00:00:00','AA RANO',30000.00,30000.00,0.00,'M/T 1600049937','','1','T15130LA','MR. MONSURU','08059495375','',5,'2022-06-20 11:15:53','808','0000-00-00 00:00:00','','2022-06-20 11:16:21','808'),(40,'22',19,'242',1,5,'2022-06-20 00:00:00','AA RANO',15000.00,15000.00,0.00,'M/T 1600049937','','2','T15130LA','MR. MONSURU','08059495375','',5,'2022-06-20 11:15:53','808','0000-00-00 00:00:00','','2022-06-20 11:16:08','808'),(41,'22',20,'242',1,5,'2022-06-25 00:00:00','AA RANO',26500.00,26500.00,0.00,'M/T 1600049936','','1','T15130LA','MR. MONSURU','08180757612','',5,'2022-06-25 11:52:32','808','0000-00-00 00:00:00','','2022-06-25 11:53:30','808'),(42,'22',20,'242',1,5,'2022-06-25 00:00:00','AA RANO',13500.00,13500.00,0.00,'M/T 1600049936','','2','T15130LA','MR. MONSURU','08180757612','',5,'2022-06-25 11:52:32','808','0000-00-00 00:00:00','','2022-06-25 11:53:15','808'),(43,'22',21,'242',1,9,'2022-06-27 00:00:00','AITEO ENERGY RESOURCES ',30000.00,30000.00,0.00,'AE138191','','1','T15130LA','MR. MONSURU','08180757612','',5,'2022-06-27 12:49:46','808','0000-00-00 00:00:00','','2022-06-27 12:51:06','808'),(44,'22',21,'242',1,9,'2022-06-27 00:00:00','AITEO ENERGY RESOURCES ',15000.00,15000.00,0.00,'AE138191','','2','T15130LA','MR. MONSURU','08180757612','',5,'2022-06-27 12:49:46','808','0000-00-00 00:00:00','','2022-06-27 12:50:45','808'),(45,'22',22,'242',1,9,'2022-06-30 00:00:00','AITEO APAPA',26500.00,26500.00,0.00,'AE138640','','1','T15130LA','MR. MONSURU','08180757612','',5,'2022-06-30 18:02:06','808','0000-00-00 00:00:00','','2022-06-30 18:02:42','808'),(46,'22',22,'242',1,9,'2022-06-30 00:00:00','AITEO APAPA',13500.00,13500.00,0.00,'AE138640','','2','T15130LA','MR. MONSURU','08180757612','',5,'2022-06-30 18:02:06','808','0000-00-00 00:00:00','','2022-06-30 18:02:21','808'),(47,'22',23,'242',2,10,'2022-07-01 00:00:00','WOSBAB ENERGY SOLUTIONS ',28100.00,28100.00,0.00,'000031185TP','','3','T15130LA','MR. MONSURU','08180757612','',5,'2022-07-01 13:11:53','808','0000-00-00 00:00:00','','2022-07-01 13:12:42','808'),(48,'22',23,'242',2,10,'2022-07-01 00:00:00','WOSBAB ENERGY SOLUTIONS ',16900.00,16900.00,0.00,'000031185TP','','4','T15130LA','MR. MONSURU','08180757612','',5,'2022-07-01 13:11:53','808','0000-00-00 00:00:00','','2022-07-01 13:12:27','808'),(49,'22',24,'242',1,9,'2022-07-02 00:00:00','AITEO APAPA',21100.00,21100.00,0.00,'AE138749','','1','T15130LA','MR. MONSURU','08180757612','',5,'2022-07-02 19:47:55','808','0000-00-00 00:00:00','','2022-07-02 19:55:43','808'),(50,'22',24,'242',1,9,'2022-07-02 00:00:00','AITEO APAPA',18900.00,18900.00,0.00,'AE138749','','2','T15130LA','MR. MONSURU','08180757612','',5,'2022-07-02 19:47:55','808','0000-00-00 00:00:00','','2022-07-02 19:48:37','808'),(51,'22',25,'242',1,5,'2022-07-10 00:00:00','AA RANO',30000.00,30000.00,0.00,'000134134TP','','1','T15130LA','MR. MONSURU','08180757612','',5,'2022-07-10 17:44:49','808','0000-00-00 00:00:00','','2022-07-10 17:45:17','808'),(52,'22',25,'242',1,5,'2022-07-10 00:00:00','AA RANO',15000.00,15000.00,0.00,'000131434TP','','2','T15130LA','MR. MONSURU','08180757612','',5,'2022-07-10 17:44:49','808','0000-00-00 00:00:00','','2022-07-10 17:45:05','808'),(53,'22',26,'242',1,11,'2022-07-15 00:00:00','PINNACLE OIL & GAS',30000.00,30000.00,0.00,'S_015227','','1','T15130LA','MR. MONSURU','08180757612','',5,'2022-07-15 18:18:53','808','0000-00-00 00:00:00','','2022-07-15 18:19:31','808'),(54,'22',26,'242',1,11,'2022-07-15 00:00:00','PINNACLE OIL & GAS',15000.00,15000.00,0.00,'S_015227','','2','T15130LA','MR. MONSURU','08180757612','',5,'2022-07-15 18:18:53','808','0000-00-00 00:00:00','','2022-07-15 18:19:16','808'),(55,'22',27,'242',1,11,'2022-07-19 00:00:00','PINNACLE OIL & GAS',30000.00,30000.00,0.00,'S_015833','','1','T15777LA','IDOWU','09035237159','',5,'2022-07-19 15:52:15','808','0000-00-00 00:00:00','','2022-07-19 15:52:50','808'),(56,'22',27,'242',1,11,'2022-07-19 00:00:00','PINNACLE OIL & GAS',15000.00,15000.00,0.00,'S_015833','','2','T15777LA','IDOWU','09035237159','',5,'2022-07-19 15:52:15','808','0000-00-00 00:00:00','','2022-07-19 15:52:35','808'),(57,'22',28,'242',2,10,'2022-07-20 00:00:00','WOSBAB ENERGY SOLUTIONS ',26500.00,26500.00,0.00,'000031625TP','','3','T15130LA','MR. MONSURU','08180757612','',5,'2022-07-20 12:08:51','808','0000-00-00 00:00:00','','2022-07-20 12:09:31','808'),(58,'22',28,'242',2,10,'2022-07-20 00:00:00','WOSBAB ENERGY SOLUTIONS ',13500.00,13500.00,0.00,'000031625TP','','4','T15130LA','MR. MONSURU','08180757612','',5,'2022-07-20 12:08:51','808','0000-00-00 00:00:00','','2022-07-20 12:09:09','808'),(60,'22',29,'242',1,11,'2022-07-29 00:00:00','PINNACLE OIL & GAS',10000.00,10000.00,0.00,'S_019571','','1','T15777LA','MR. IDOWU','09035237159','',5,'2022-07-29 12:22:51','808','0000-00-00 00:00:00','','2022-07-29 12:23:22','808'),(61,'22',29,'242',1,11,'2022-07-29 00:00:00','PINNACLE OIL & GAS',30000.00,40000.00,0.00,'S_019571','','2','T15777LA','MR. IDOWU','09035237159','',5,'2022-07-29 12:22:51','808','0000-00-00 00:00:00','','2022-07-29 12:23:06','808'),(62,'22',30,'242',1,11,'2022-07-30 00:00:00','PINNACLE OIL & GAS',30000.00,30000.00,0.00,'S_019573','','1','T15130LA','MR. MONSURU','08180757612','',5,'2022-07-30 22:19:39','808','0000-00-00 00:00:00','','2022-07-30 22:20:01','808'),(64,'22',30,'242',1,11,'2022-07-30 00:00:00','PINNACLE OIL & GAS',10000.00,10000.00,0.00,'S_019573','','1','T15130LA','MR. MONSURU','08180757612','',5,'2022-07-30 22:23:14','808','0000-00-00 00:00:00','','2022-07-30 22:23:37','808'),(65,'22',31,'242',2,8,'2022-08-04 00:00:00','NIPC0 PLC',30000.00,30000.00,0.00,'N504579','','3','T15777LA','MR. IDOWU','09035237159','',5,'2022-08-04 10:25:56','808','0000-00-00 00:00:00','','2022-08-04 10:26:25','808'),(66,'22',31,'242',2,8,'2022-08-04 00:00:00','NIPC0 PLC',15000.00,15000.00,0.00,'N504579','','4','T15777LA','MR. IDOWU','09035237159','',5,'2022-08-04 10:25:56','808','0000-00-00 00:00:00','','2022-08-04 10:26:13','808'),(67,'22',32,'242',1,8,'2022-08-13 00:00:00','NIPC0 PLC',30000.00,30000.00,0.00,'N305028','','1','T15130LA','MR. MONSURU','08180757612','',5,'2022-08-13 10:58:01','808','0000-00-00 00:00:00','','2022-08-13 10:58:38','808'),(68,'22',32,'242',1,8,'2022-08-13 00:00:00','NIPC0 PLC',15000.00,15000.00,0.00,'N305028','','2','T15130LA','MR. MONSURU','08180757612','',5,'2022-08-13 10:58:01','808','0000-00-00 00:00:00','','2022-08-13 10:58:22','808'),(69,'22',33,'242',1,12,'2022-08-23 00:00:00','ETERNA PLC',30000.00,30000.00,0.00,'W1D1-PRO2201101','','1','T15130LA','MR. MONSURU','08180757612','',5,'2022-08-23 13:11:31','808','0000-00-00 00:00:00','','2022-08-23 13:12:06','808'),(70,'22',33,'242',1,12,'2022-08-23 00:00:00','ETERNA PLC',15000.00,15000.00,0.00,'W1D1-PRO2201101','','2','T15130LA','MR. MONSURU','08180757612','',5,'2022-08-23 13:11:31','808','0000-00-00 00:00:00','','2022-08-23 13:11:49','808'),(71,'22',34,'242',2,2,'2022-08-30 00:00:00','AFRICA TERMINALS',30000.00,30000.00,0.00,'0033471','','3','TI5130LA','MR. MONSURU','08180757612','',5,'2022-08-30 10:24:27','808','0000-00-00 00:00:00','','2022-08-30 10:24:53','808'),(72,'22',34,'242',2,2,'2022-08-30 00:00:00','AFRICA TERMINALS',15000.00,15000.00,0.00,'0033471','','4','TI5130LA','MR. MONSURU','08180757612','',5,'2022-08-30 10:24:27','808','0000-00-00 00:00:00','','2022-08-30 10:25:21','808'),(73,'22',35,'242',1,13,'2022-08-30 00:00:00','ASCON ',28000.00,28000.00,0.00,'0007827','','1','T15777LA','MR. MONSURU','08180757612','',5,'2022-08-30 10:27:03','808','0000-00-00 00:00:00','','2022-08-30 10:27:27','808'),(74,'22',35,'242',1,13,'2022-08-30 00:00:00','ASCON ',14000.00,14000.00,0.00,'0007827','','2','T15777LA','MR. MONSURU','08180757612','',5,'2022-08-30 10:27:03','808','0000-00-00 00:00:00','','2022-08-30 10:27:17','808'),(75,'22',36,'242',1,8,'2022-09-01 00:00:00','NIPC0 PLC',20000.00,20000.00,0.00,'2022041258','','1','T15130LA','MR. MONSURU','08180757612','',5,'2022-09-01 19:45:10','808','0000-00-00 00:00:00','','2022-09-01 19:45:36','808'),(76,'22',36,'242',1,8,'2022-09-01 00:00:00','NIPC0 PLC',25000.00,25000.00,0.00,'2022041258','','2','T15130LA','MR. MONSURU','08180757612','',5,'2022-09-01 19:45:10','808','0000-00-00 00:00:00','','2022-09-01 19:45:25','808'),(77,'22',37,'242',1,11,'2022-09-12 00:00:00','PINNACLE OIL & GAS',30000.00,30000.00,0.00,'S_023700','','1','T15130LA','MR. IDOWU','09035237159','',5,'2022-09-12 21:35:42','808','0000-00-00 00:00:00','','2022-09-12 21:36:08','808'),(78,'22',37,'242',1,11,'2022-09-12 00:00:00','PINNACLE OIL & GAS',15000.00,15000.00,0.00,'S_023700','','2','T15130LA','MR. IDOWU','09035237159','',5,'2022-09-12 21:35:42','808','0000-00-00 00:00:00','','2022-09-12 21:35:58','808'),(79,'22',38,'242',2,14,'2022-09-19 00:00:00','T-TIME DEPOT IBAFON ',30000.00,30000.00,0.00,'0027676','','3','T15777LA','MR. IDOWU','09035237159','',5,'2022-09-19 10:23:53','808','0000-00-00 00:00:00','','2022-09-19 10:24:40','808'),(80,'22',38,'242',2,14,'2022-09-19 00:00:00','T-TIME DEPOT IBAFON ',15000.00,15000.00,0.00,'0027676','','4','T15777LA','MR. IDOWU','09035237159','',5,'2022-09-19 10:23:53','808','0000-00-00 00:00:00','','2022-09-19 10:24:28','808'),(81,'22',39,'242',1,11,'2022-09-24 00:00:00','PINNACLE OIL & GAS',30000.00,30000.00,0.00,'S_024916','','1','T15130LA','MR. MONSURU','08180757612','',5,'2022-09-24 19:05:06','808','0000-00-00 00:00:00','','2022-09-24 19:09:28','808'),(82,'22',39,'242',1,11,'2022-09-24 00:00:00','PINNACLE OIL & GAS',15000.00,15000.00,0.00,'S_024916','','2','T15130LA','MR. MONSURU','08180757612','',5,'2022-09-24 19:05:06','808','0000-00-00 00:00:00','','2022-09-24 19:05:29','808'),(83,'22',40,'242',1,11,'2022-09-27 00:00:00','PINNACLE OIL & GAS',30000.00,30000.00,0.00,'S_024920','','1','T15777LA','MR. IDOWU','09035237159','',5,'2022-09-27 21:54:39','808','0000-00-00 00:00:00','','2022-09-27 21:55:13','808'),(84,'22',40,'242',1,11,'2022-09-27 00:00:00','PINNACLE OIL & GAS',15000.00,15000.00,0.00,'S_024920','','2','T15777LA','MR. IDOWU','09035237159','',5,'2022-09-27 21:54:39','808','0000-00-00 00:00:00','','2022-09-27 21:54:56','808'),(85,'22',41,'242',1,11,'2022-10-03 00:00:00','PINNACLE OIL & GAS',30000.00,30000.00,0.00,'S_026267','','1','T15130LA','MR. MONSURU','08180757612','',5,'2022-10-03 16:48:15','808','0000-00-00 00:00:00','','2022-10-03 16:48:51','808'),(86,'22',41,'242',1,11,'2022-10-03 00:00:00','PINNACLE OIL & GAS',15000.00,15000.00,0.00,'S_026267','','2','T15130LA','MR. MONSURU','08180757612','',5,'2022-10-03 16:48:15','808','0000-00-00 00:00:00','','2022-10-03 16:48:41','808'),(87,'22',42,'242',1,11,'2022-10-10 00:00:00','PINNACLE OIL & GAS',23400.00,23400.00,0.00,'S_028148','','1','T15130LA','MR. MONSURU','08180757612','',5,'2022-10-10 10:46:38','808','0000-00-00 00:00:00','','2022-10-10 10:47:44','808'),(88,'22',42,'242',1,11,'2022-10-10 00:00:00','PINNACLE OIL & GAS',21600.00,21600.00,0.00,'S_028148','','2','T15130LA','MR. MONSURU','08180757612','',5,'2022-10-10 10:46:38','808','0000-00-00 00:00:00','','2022-10-10 10:47:30','808'),(90,'22',43,'242',2,8,'2022-10-14 00:00:00','NIPC0 PLC',14969.00,14969.00,0.00,'2022046567','','4','T15777LA','MR. SALAWU','08059495375','',5,'2022-10-14 12:33:55','808','0000-00-00 00:00:00','','2022-10-14 12:34:13','808'),(91,'22',43,'242',2,8,'2022-11-02 00:00:00','NIPC0 PLC',13000.00,13000.00,0.00,'2022046567','','3','T15777LA','MR. SALAWU','09035237159','',5,'2022-11-02 16:07:42','808','0000-00-00 00:00:00','','2022-11-02 16:08:12','808'),(92,'22',43,'242',2,8,'2022-11-02 00:00:00','NIPC0 PLC',17000.00,17000.00,0.00,'2022046567','','4','T15777LA','MR. SALAWU','09035237159','',5,'2022-11-02 16:07:42','808','0000-00-00 00:00:00','','2022-11-02 16:07:59','808'),(93,'22',44,'242',1,8,'2022-11-14 00:00:00','NIPC0 PLC',30000.00,30000.00,0.00,'2022051774','','1','T15777LA','MR. SALAWU','09035237159','',5,'2022-11-14 22:06:08','808','0000-00-00 00:00:00','','2022-11-14 22:06:42','808'),(94,'22',44,'242',1,8,'2022-11-14 00:00:00','NIPC0 PLC',15000.00,15000.00,0.00,'2022051774','','2','T15777LA','MR. SALAWU','09035237159','',5,'2022-11-14 22:06:08','808','0000-00-00 00:00:00','','2022-11-14 22:06:26','808'),(95,'22',45,'242',1,11,'2022-11-16 00:00:00','PINNACLE OIL & GAS',15000.00,15000.00,0.00,'S_033913','','1','T15130LA','MR. MONSURU','08180757612','',5,'2022-11-16 15:59:50','808','0000-00-00 00:00:00','','2022-11-16 16:00:18','808'),(96,'22',45,'242',1,11,'2022-11-16 00:00:00','PINNACLE OIL & GAS',30000.00,30000.00,0.00,'S_033913','','2','T15130LA','MR. MONSURU','08180757612','',5,'2022-11-16 15:59:50','808','0000-00-00 00:00:00','','2022-11-16 16:00:05','808');
/*!40000 ALTER TABLE `purchases_receptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports`
--

DROP TABLE IF EXISTS `reports`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  `type` varchar(20) NOT NULL,
  `sql` text NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`report_id`),
  KEY `companycode` (`company_id`,`name`,`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports`
--

LOCK TABLES `reports` WRITE;
/*!40000 ALTER TABLE `reports` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_fields`
--

DROP TABLE IF EXISTS `reports_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(20) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `fieldname` varchar(50) NOT NULL,
  `order` int NOT NULL,
  `visibility` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`report_id`,`field_id`,`order`,`visibility`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_fields`
--

LOCK TABLES `reports_fields` WRITE;
/*!40000 ALTER TABLE `reports_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_filters`
--

DROP TABLE IF EXISTS `reports_filters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_filters` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(50) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `filter_id` int NOT NULL AUTO_INCREMENT,
  `criteria` varchar(20) NOT NULL,
  `value` varchar(100) NOT NULL,
  PRIMARY KEY (`filter_id`),
  KEY `companycode` (`company_id`,`report_id`),
  KEY `field_id` (`field_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_filters`
--

LOCK TABLES `reports_filters` WRITE;
/*!40000 ALTER TABLE `reports_filters` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_filters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_customers`
--

DROP TABLE IF EXISTS `retail_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_customers` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(100) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`name`,`phone`,`email`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_customers`
--

LOCK TABLES `retail_customers` WRITE;
/*!40000 ALTER TABLE `retail_customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory`
--

DROP TABLE IF EXISTS `retail_inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` int NOT NULL,
  `qtyout` int NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory`
--

LOCK TABLES `retail_inventory` WRITE;
/*!40000 ALTER TABLE `retail_inventory` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_balances`
--

DROP TABLE IF EXISTS `retail_inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_balances`
--

LOCK TABLES `retail_inventory_balances` WRITE;
/*!40000 ALTER TABLE `retail_inventory_balances` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_costs`
--

DROP TABLE IF EXISTS `retail_inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_costs`
--

LOCK TABLES `retail_inventory_costs` WRITE;
/*!40000 ALTER TABLE `retail_inventory_costs` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products`
--

DROP TABLE IF EXISTS `retail_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`name`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `parent_id` (`parent_id`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products`
--

LOCK TABLES `retail_products` WRITE;
/*!40000 ALTER TABLE `retail_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_prices`
--

DROP TABLE IF EXISTS `retail_products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_prices`
--

LOCK TABLES `retail_products_prices` WRITE;
/*!40000 ALTER TABLE `retail_products_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_reconciliations`
--

DROP TABLE IF EXISTS `retail_products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_reconciliations`
--

LOCK TABLES `retail_products_reconciliations` WRITE;
/*!40000 ALTER TABLE `retail_products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_purchases`
--

DROP TABLE IF EXISTS `retail_purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_purchases`
--

LOCK TABLES `retail_purchases` WRITE;
/*!40000 ALTER TABLE `retail_purchases` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales`
--

DROP TABLE IF EXISTS `retail_sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `saledate` date NOT NULL,
  `customer_id` varchar(20) NOT NULL DEFAULT '',
  `customer_name` varchar(50) NOT NULL,
  `customer_phone` varchar(30) NOT NULL,
  `quantity_kg` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `payment_method` varchar(10) NOT NULL,
  `payment_account_type` varchar(20) NOT NULL,
  `payment_account_id` varchar(20) NOT NULL,
  `paid` decimal(20,2) DEFAULT NULL,
  `change` decimal(20,2) DEFAULT '0.00',
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`customer_name`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `payment_method` (`payment_method`,`payment_account_type`,`payment_account_id`),
  KEY `customer_id` (`customer_id`),
  KEY `change` (`change`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales`
--

LOCK TABLES `retail_sales` WRITE;
/*!40000 ALTER TABLE `retail_sales` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_items`
--

DROP TABLE IF EXISTS `retail_sales_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `product_type` varchar(10) NOT NULL,
  `product_name` varchar(100) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `quantity_2` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `parent_cost` decimal(20,2) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`sale_id`,`product_id`,`rate`,`quantity`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`product_type`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `parent_id` (`parent_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_items`
--

LOCK TABLES `retail_sales_items` WRITE;
/*!40000 ALTER TABLE `retail_sales_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_payments`
--

DROP TABLE IF EXISTS `retail_sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_payments` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `payment_method` varchar(50) NOT NULL,
  `account_type` varchar(10) DEFAULT NULL,
  `account_id` bigint DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_by` bigint DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`sale_id`,`payment_method`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`account_type`),
  KEY `parent_id` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_payments`
--

LOCK TABLES `retail_sales_payments` WRITE;
/*!40000 ALTER TABLE `retail_sales_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales`
--

DROP TABLE IF EXISTS `sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `is_credit` int NOT NULL DEFAULT '0',
  `saledate` date NOT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `paid` int NOT NULL,
  `details` text NOT NULL,
  `ledger_notes` varchar(150) DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`product_id`,`customer_id`,`rate`,`quantity`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`is_credit`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales`
--

LOCK TABLES `sales` WRITE;
/*!40000 ALTER TABLE `sales` DISABLE KEYS */;
INSERT INTO `sales` VALUES (1,'22','242','5',1,'2022-05-07',2,3,625.00,650.00,500.00,0.00,0.00,325000.00,'1651919876','2022-05-07 11:37:56',15,0,'IOU',NULL,'808','','0000-00-00 00:00:00','808','2022-05-07 11:40:05'),(2,'22','242','5',1,'2022-05-07',2,5,625.00,650.00,800.00,0.00,0.00,520000.00,'1651919876','2022-05-07 11:37:56',15,0,'IOU',NULL,'808','','0000-00-00 00:00:00','808','2022-05-07 11:40:05'),(3,'22','242','5',1,'2022-05-07',2,4,625.00,650.00,310.00,0.00,0.00,201500.00,'1651919876','2022-05-07 11:37:56',15,0,'IOU',NULL,'808','','0000-00-00 00:00:00','808','2022-05-07 11:40:05'),(4,'22','242','5',1,'2022-05-07',1,5,148.00,165.00,36.36,0.00,0.00,5999.40,'1651919876','2022-05-07 11:37:56',15,0,'IOU',NULL,'808','','0000-00-00 00:00:00','808','2022-05-07 11:40:05'),(5,'22','242','6',1,'2022-05-08',2,6,625.00,650.00,300.00,0.00,0.00,195000.00,'1652000234','2022-05-08 09:57:14',15,0,'IOU',NULL,'808','','0000-00-00 00:00:00','808','2022-05-08 10:03:13'),(6,'22','242','6',1,'2022-05-08',2,1,625.00,650.00,350.00,0.00,0.00,227500.00,'1652000234','2022-05-08 09:57:14',15,0,'IOU',NULL,'808','','0000-00-00 00:00:00','808','2022-05-08 10:03:13'),(7,'22','242','6',1,'2022-05-08',2,4,625.00,650.00,310.00,0.00,0.00,201500.00,'1652000234','2022-05-08 09:57:14',15,0,'IOU',NULL,'808','','0000-00-00 00:00:00','808','2022-05-08 10:03:13'),(9,'22','242','7',1,'2022-05-08',2,4,625.00,650.00,300.00,0.00,0.00,195000.00,'1652032036','2022-05-08 18:47:16',15,0,'IOU',NULL,'808','','0000-00-00 00:00:00','808','2022-05-08 18:47:56'),(10,'22','242','8',1,'2022-05-10',2,4,625.00,650.00,310.00,0.00,0.00,201500.00,'1652178160','2022-05-10 11:22:40',15,0,'IOU',NULL,'808','','0000-00-00 00:00:00','808','2022-05-10 11:23:57'),(11,'22','242','8',1,'2022-05-10',2,1,625.00,650.00,400.00,0.00,0.00,260000.00,'1652178160','2022-05-10 11:22:40',15,0,'IOU',NULL,'808','','0000-00-00 00:00:00','808','2022-05-10 11:23:57'),(12,'22','242','8',1,'2022-05-10',1,1,148.00,165.00,28.76,0.00,0.00,4745.40,'1652178160','2022-05-10 11:22:40',15,0,'IOU',NULL,'808','','0000-00-00 00:00:00','808','2022-05-10 11:23:57'),(13,'22','242','9',1,'2022-05-11',2,4,625.00,0.00,310.00,0.00,0.00,0.00,'1652251537','2022-05-11 07:45:37',15,0,'IOU',NULL,'808','','0000-00-00 00:00:00','808','2022-05-12 20:19:37'),(14,'22','242','9',1,'2022-05-11',2,2,625.00,0.00,550.00,0.00,0.00,0.00,'1652251537','2022-05-11 07:45:37',15,0,'IOU',NULL,'808','','0000-00-00 00:00:00','808','2022-05-12 20:19:37');
/*!40000 ALTER TABLE `sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_daily`
--

DROP TABLE IF EXISTS `sales_daily`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_daily` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `saledate` date NOT NULL,
  `average` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `target` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`average`,`saledate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_daily`
--

LOCK TABLES `sales_daily` WRITE;
/*!40000 ALTER TABLE `sales_daily` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_daily` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions`
--

DROP TABLE IF EXISTS `sales_distributions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions` (
  `distribution_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `sale_id` int NOT NULL,
  `purchase_id` varchar(20) NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `loadingdate` date NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `destination` varchar(50) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `truckno` varchar(20) NOT NULL,
  `drivername` varchar(50) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`distribution_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`loadingdate`,`quantity`,`destination`,`waybill`,`meterno`,`nozzle_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`tank_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `truckno` (`truckno`),
  KEY `purchase_id_2` (`purchase_id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions`
--

LOCK TABLES `sales_distributions` WRITE;
/*!40000 ALTER TABLE `sales_distributions` DISABLE KEYS */;
INSERT INTO `sales_distributions` VALUES (1,'22',1,'',0,'242',2,3,'2022-05-07',500.00,'','','','3','5','','','Dispensed on shift # 5',5,'2022-05-07 11:40:05','808','0000-00-00 00:00:00','','2022-05-07 11:40:05','808'),(2,'22',2,'',0,'242',2,5,'2022-05-07',800.00,'','','','3','5','','','Dispensed on shift # 5',5,'2022-05-07 11:40:05','808','0000-00-00 00:00:00','','2022-05-07 11:40:05','808'),(3,'22',3,'',0,'242',2,4,'2022-05-07',310.00,'','','','3','5','','','Dispensed on shift # 5',5,'2022-05-07 11:40:05','808','0000-00-00 00:00:00','','2022-05-07 11:40:05','808'),(4,'22',4,'',0,'242',1,5,'2022-05-07',36.36,'','','','1','9','','','Dispensed on shift # 5',5,'2022-05-07 11:40:05','808','0000-00-00 00:00:00','','2022-05-07 11:40:05','808'),(5,'22',5,'',0,'242',2,6,'2022-05-08',300.00,'','','','3','5','','','Dispensed on shift # 6',5,'2022-05-08 10:03:13','808','0000-00-00 00:00:00','','2022-05-08 10:03:13','808'),(6,'22',6,'',0,'242',2,1,'2022-05-08',350.00,'','','','3','5','','','Dispensed on shift # 6',5,'2022-05-08 10:03:13','808','0000-00-00 00:00:00','','2022-05-08 10:03:13','808'),(7,'22',7,'',0,'242',2,4,'2022-05-08',310.00,'','','','3','5','','','Dispensed on shift # 6',5,'2022-05-08 10:03:13','808','0000-00-00 00:00:00','','2022-05-08 10:03:13','808'),(8,'22',9,'',0,'242',2,4,'2022-05-08',300.00,'','','','3','5','','','Dispensed on shift # 7',5,'2022-05-08 18:47:56','808','0000-00-00 00:00:00','','2022-05-08 18:47:56','808'),(9,'22',10,'',0,'242',2,4,'2022-05-10',310.00,'','','','4','6','','','Dispensed on shift # 8',5,'2022-05-10 11:23:57','808','0000-00-00 00:00:00','','2022-05-10 11:23:57','808'),(10,'22',11,'',0,'242',2,1,'2022-05-10',400.00,'','','','4','6','','','Dispensed on shift # 8',5,'2022-05-10 11:23:57','808','0000-00-00 00:00:00','','2022-05-10 11:23:57','808'),(11,'22',12,'',0,'242',1,1,'2022-05-10',28.76,'','','','1','9','','','Dispensed on shift # 8',5,'2022-05-10 11:23:57','808','0000-00-00 00:00:00','','2022-05-10 11:23:57','808'),(12,'22',13,'',0,'242',2,4,'2022-05-12',310.00,'','','','3','5','','','Dispensed on shift # 9',5,'2022-05-12 20:19:37','808','0000-00-00 00:00:00','','2022-05-12 20:19:37','808'),(13,'22',14,'',0,'242',2,2,'2022-05-12',550.00,'','','','3','5','','','Dispensed on shift # 9',5,'2022-05-12 20:19:37','808','0000-00-00 00:00:00','','2022-05-12 20:19:37','808');
/*!40000 ALTER TABLE `sales_distributions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_delivery`
--

DROP TABLE IF EXISTS `sales_distributions_delivery`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_delivery` (
  `delivery_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `distribution_id` int NOT NULL,
  `sale_id` int NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `quantity` int NOT NULL,
  `truck_id` int NOT NULL,
  `deliveredon` date NOT NULL,
  `details` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`delivery_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`quantity`,`thedate`,`createdby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`truck_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `distribution_id` (`distribution_id`),
  KEY `deliveredon` (`deliveredon`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_delivery`
--

LOCK TABLES `sales_distributions_delivery` WRITE;
/*!40000 ALTER TABLE `sales_distributions_delivery` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_delivery` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_trucks`
--

DROP TABLE IF EXISTS `sales_distributions_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_trucks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sale_id` varchar(20) NOT NULL,
  `distribution_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `bridge_id` varchar(20) NOT NULL,
  `truck_id` varchar(20) NOT NULL,
  `driver_id` varchar(20) NOT NULL,
  `quantity` int NOT NULL,
  `destination` varchar(150) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `companycode` (`company_id`,`distribution_id`,`truck_id`),
  KEY `sale_id` (`sale_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_trucks`
--

LOCK TABLES `sales_distributions_trucks` WRITE;
/*!40000 ALTER TABLE `sales_distributions_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_fueltickets`
--

DROP TABLE IF EXISTS `sales_fueltickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_fueltickets` (
  `ticket_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `ticketdate` date NOT NULL,
  `code` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `allowance` decimal(10,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `truck_number` varchar(20) NOT NULL,
  `truck_capacity` int NOT NULL,
  `truck_provider` varchar(50) NOT NULL,
  `truck_from` varchar(50) NOT NULL,
  `truck_destination` varchar(50) NOT NULL,
  `driver_name` varchar(50) NOT NULL,
  `driver_phone` varchar(50) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`ticket_id`),
  KEY `companycode` (`company_id`,`ticketdate`,`product_id`,`truck_number`,`rate`,`quantity`,`status`),
  KEY `paid` (`truck_provider`),
  KEY `invoice` (`code`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_fueltickets`
--

LOCK TABLES `sales_fueltickets` WRITE;
/*!40000 ALTER TABLE `sales_fueltickets` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_fueltickets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_payments`
--

DROP TABLE IF EXISTS `sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `customer_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`customer_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_payments`
--

LOCK TABLES `sales_payments` WRITE;
/*!40000 ALTER TABLE `sales_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shifts_cashbacks`
--

DROP TABLE IF EXISTS `shifts_cashbacks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shifts_cashbacks` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `shift_id` bigint unsigned NOT NULL,
  `regno` varchar(100) DEFAULT NULL,
  `cashdate` date NOT NULL,
  `driver` varchar(100) DEFAULT NULL,
  `customer_id` bigint unsigned NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_at` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`cashdate`,`driver`,`customer_id`,`status`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`regno`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shifts_cashbacks`
--

LOCK TABLES `shifts_cashbacks` WRITE;
/*!40000 ALTER TABLE `shifts_cashbacks` DISABLE KEYS */;
/*!40000 ALTER TABLE `shifts_cashbacks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shifts_remittance`
--

DROP TABLE IF EXISTS `shifts_remittance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shifts_remittance` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `shift_id` bigint unsigned NOT NULL,
  `paymentdate` date NOT NULL,
  `method` int DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paidby` varchar(50) DEFAULT NULL,
  `paidto` varchar(100) DEFAULT NULL,
  `bank` bigint unsigned DEFAULT NULL,
  `depositor` varchar(100) DEFAULT NULL,
  `teller` varchar(100) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text,
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  `reversed_at` datetime DEFAULT NULL,
  `reversed_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`paymentdate`,`method`,`bank`,`status`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shifts_remittance`
--

LOCK TABLES `shifts_remittance` WRITE;
/*!40000 ALTER TABLE `shifts_remittance` DISABLE KEYS */;
/*!40000 ALTER TABLE `shifts_remittance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers`
--

DROP TABLE IF EXISTS `suppliers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers` (
  `supplier_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`supplier_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers`
--

LOCK TABLES `suppliers` WRITE;
/*!40000 ALTER TABLE `suppliers` DISABLE KEYS */;
INSERT INTO `suppliers` VALUES (1,'22','242','MENJ OIL LTD','Nin','08029478654','doyininvestment@gmail.com','Lagos','Lagos','Pioneer driver, off Marwa Road  Ijegun Satellite Town ','Nigeria',0.00,0.00,'0000-00-00','2022-04-12 13:08:07',5,'793','2022-04-12 13:15:07','793'),(2,'22','242','PPMC','Mr Isiyaku abdullahi','08029478654','olurotimi4love@yahoo.com','Abuja ','Abuja','NNPC towers block Abuja ','Nigeria',0.00,0.00,'0000-00-00','2022-04-12 13:11:57',5,'793','2022-04-12 13:14:39','793'),(3,'22','242','MAO PETROLEUM COMPANY LTD','MR IBRAHIM','08163570429, 08120870966','maopetroleum@gmail.com','Satelite Town','LAGOS','Mao Petroleum Depot Ijegun Egba Satelite Town, Lagos.','Nigeria',0.00,0.00,'0000-00-00','2022-05-05 13:42:45',5,'808','2022-05-05 13:42:45','808'),(4,'22','242','FIRST ROYAL OIL & GAS LTD','MR AKANDE','08187349507','info@firstroyaloilng.com','LAGOS','LAGOS','IJEGUN-EGBA,SATTALLITE TOWN,LAGOS','Nigeria',0.00,0.00,'0000-00-00','2022-05-06 12:47:35',5,'808','2022-05-06 12:47:35','808'),(5,'22','242','AA RANO NIGERIA LIMITED','ITOM UBE','08032249472','info@aarano.com','SATELITE TOWN','LAGOS','IJEGUN EGBA WATERFRONT','Nigeria',0.00,0.00,'0000-00-00','2022-05-10 19:04:35',5,'808','2022-05-10 19:04:35','808'),(6,'22','242','CHIPET INTERNATIONAL LTD','MR.JOHNSON','07015451775','chipetdepotlagos@gmail.com','SATELITE TOWN','LAGOS','1-10 chipet roadijegun,Satelite Town,Lagos.','Nigeria',0.00,0.00,'0000-00-00','2022-05-19 15:38:14',5,'808','2022-05-19 15:38:14','808'),(7,'22','242','STALLIONAIRE NIGERIA LIMITED','UCHE','+2340177326693','info@sgholdingslimited.com','SATELITE TOWN','LAGOS','Stallionaire Drive, Ijegun Egba ','Nigeria',0.00,0.00,'0000-00-00','2022-05-27 18:11:11',5,'808','2022-05-27 18:11:11','808'),(8,'22','242','NIPC0 PLC','MR. EMEKA','01-5873184','info@nipcoplc.com','Apapa','Lagos','1 & 15, Dockyard Road,','Nigeria',0.00,0.00,'0000-00-00','2022-06-04 19:41:59',5,'808','2022-06-04 19:41:59','808'),(9,'22','242','AITEO ENERGY RESOURCES','SALISU','+234-16212183-5','info@aiteogroup.com','Apapa','Lagos','5/7 Dockyard Road,','Nigeria',0.00,0.00,'0000-00-00','2022-06-10 18:36:33',5,'808','2022-06-10 18:36:33','808'),(10,'22','242','WOSBAB ENERGY SOLUTIONS NIG LT','Mr. Ganiu Mohd ','+234-16212183-5','info@wosbadenergysolutions.ng','Satelite Town ','Lagos','Folarin Street, Ijegun','Nigeria',0.00,0.00,'0000-00-00','2022-07-01 13:00:00',5,'808','2022-07-01 13:00:00','808'),(11,'22','242','PINNACLE OIL & GAS LIMITED ','Mr. Popoola ','09087502020','info@pinnacleoilandgaa.com','Lekki','Lagos','Block 1, E3 Road, Lekki Free Zone Development Area','Nigeria',0.00,0.00,'0000-00-00','2022-07-15 18:16:26',5,'808','2022-07-15 18:16:26','808'),(12,'22','242','ETERNA PLC','Mr. Michael Okakwu ','+23314605316','info@eternaplc.com','Ikoyi','Lagos','5A, Oba Adeyinka Oyekan Ave.','Nigeria',0.00,0.00,'0000-00-00','2022-08-23 13:06:40',5,'808','2022-08-23 13:06:40','808'),(13,'22','242','ASCON OIL COMPANY LIMITED ','IBUKUN ','08032614289','info@asconltd.com','Satelite Town ','Lagos','ASCON ABULE-ADO ','Nigeria',0.00,0.00,'0000-00-00','2022-08-30 10:19:19',5,'808','2022-08-30 10:19:19','808'),(14,'22','242','TIME PETROLEUM SERVICES','OKAFOR ROWLAND','01-8400382','info@timepetroleumservices.com','Amuwo odofin ','Lagos','2nd Rainbow Bus/Stop, Oshodi-Apapa Expressway, ','Nigeria',0.00,0.00,'0000-00-00','2022-09-19 10:19:53',5,'808','2022-09-19 10:19:53','808');
/*!40000 ALTER TABLE `suppliers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers_status`
--

DROP TABLE IF EXISTS `suppliers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `supplier_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers_status`
--

LOCK TABLES `suppliers_status` WRITE;
/*!40000 ALTER TABLE `suppliers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `suppliers_status` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2023-03-21  2:55:52
