-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_21_station_238
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_21_station_238`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_21_station_238` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_21_station_238`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,4000,'',0,'22','21','238','PURCHASES','','2022-03-04 00:01:04',5,0.00,0.00,'','764','2022-03-04 00:01:04','764',0,0),(2,7000,'',0,'20','21','238','SALES','','2022-03-04 00:01:36',5,0.00,0.00,'','764','2022-03-04 00:01:36','764',0,0),(3,500,'',0,'6.1','21','238','CASH','','2022-03-04 00:01:57',5,0.00,0.00,'','764','2022-03-04 00:01:57','764',0,0),(4,8000,'',0,'24','21','238','SALARIES & WAGES','','2022-03-04 00:02:18',5,0.00,0.00,'','764','2022-03-04 00:02:18','764',0,0),(5,8001,'',0,'24','21','238','PURCHASES','','2022-03-04 00:02:58',5,0.00,0.00,'','764','2022-03-04 00:02:58','764',0,0),(6,2500,'',0,'2','21','238','ZENITH BANK','','2022-03-23 14:02:40',5,0.00,0.00,'','764','2022-03-23 14:02:40','764',0,0),(7,2501,'',0,'2','21','238','zenith Bank pos','','2022-03-23 14:02:49',5,0.00,0.00,'','764','2022-03-23 14:02:49','764',0,0),(8,2502,'',0,'2','21','238','ZENITH BANK TRANSFER ACC','','2022-03-23 14:02:58',5,0.00,0.00,'','764','2022-03-23 14:02:58','764',0,0),(9,2503,'',0,'2','21','238','FIRST BANK TRANSFER ACCOUNT','','2022-03-23 14:03:10',5,0.00,0.00,'','764','2022-03-23 14:03:10','764',0,0),(10,2504,'',0,'2','21','238','FIRST BANK POS','','2022-03-23 14:03:19',5,0.00,0.00,'','764','2022-03-23 14:03:19','764',0,0),(11,2505,'',0,'2','21','238','FIRST BANK','','2022-03-23 14:03:28',5,0.00,0.00,'','764','2022-03-23 14:03:28','764',0,0),(12,2506,'',0,'2','21','238','UBA BANK','','2022-03-23 14:03:39',5,0.00,0.00,'','764','2022-03-23 14:03:39','764',0,0),(13,2507,'',0,'2','21','238','UBA TRANSFER ACC','','2022-03-23 14:03:48',5,0.00,0.00,'','764','2022-03-23 14:03:48','764',0,0),(14,2508,'',0,'2','21','238','UBA POS','','2022-03-23 14:03:58',5,0.00,0.00,'','764','2022-03-23 14:03:58','764',0,0),(15,2509,'',0,'2','21','238','IBTC POS','','2022-03-23 14:04:10',5,0.00,0.00,'','764','2022-03-23 14:04:10','764',0,0),(16,2510,'',0,'2','21','238','IBTC TRANSFER ACCOUNT','','2022-03-23 14:04:21',5,0.00,0.00,'','764','2022-03-23 14:04:21','764',0,0),(17,2511,'',0,'2','21','238','IBTC BANK','','2022-03-23 14:04:32',5,0.00,0.00,'','764','2022-03-23 14:04:32','764',0,0),(18,2512,'',0,'2','21','238','GT BANK POS','','2022-03-23 14:04:53',5,0.00,0.00,'','764','2022-03-23 14:04:53','764',0,0),(19,2513,'',0,'2','21','238','GT BANK TRANSFER ACCOUNT','','2022-03-23 14:05:03',5,0.00,0.00,'','764','2022-03-23 14:05:03','764',0,0),(20,2514,'',0,'2','21','238','GT BANK','','2022-03-23 14:05:13',5,0.00,0.00,'','764','2022-03-23 14:05:13','764',0,0),(21,2515,'',0,'2','21','238','JAIZ BANK','','2022-03-23 14:05:34',5,0.00,0.00,'','764','2022-03-23 14:05:34','764',0,0),(22,2516,'',0,'2','21','238','JAIZ POS','','2022-03-23 14:05:43',5,0.00,0.00,'','764','2022-03-23 14:05:43','764',0,0),(23,2517,'',0,'2','21','238','JAIZ TRANSFER ACCOUNT','','2022-03-23 14:05:53',5,0.00,0.00,'','764','2022-03-23 14:05:53','764',0,0),(24,2518,'',0,'2','21','238','Ecobank ','','2022-03-26 17:43:04',5,0.00,0.00,'','764','2022-03-26 17:43:04','764',0,0),(25,2519,'',0,'2','21','238','Ecobank POS','','2022-03-26 17:43:12',5,0.00,0.00,'','764','2022-03-26 17:43:12','764',0,0),(26,2520,'',0,'2','21','238','Ecobank Transfer account ','','2022-03-26 17:43:19',5,0.00,0.00,'','764','2022-03-26 17:43:19','764',0,0),(27,2521,'',0,'2','21','238','Unity Bank','','2022-03-26 17:43:28',5,0.00,0.00,'','764','2022-03-26 17:43:28','764',0,0),(28,2522,'',0,'2','21','238','Unity Bank POS','','2022-03-26 17:43:38',5,0.00,0.00,'','764','2022-03-26 17:43:38','764',0,0),(29,2523,'',0,'2','21','238','UNITY Bank Transfer account ','','2022-03-26 17:43:46',5,0.00,0.00,'','764','2022-03-26 17:43:46','764',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1,'','21','238','ALH. MALAM ','ALH.MALAM','08030694281','alhmalam@gmail.com',' BAUCHI','BAUCHI','KOFAR GOMBE, GOMBE ROAD, BAUCHI','Nigeria',120000.00,0.00,0.00,'0000-00-00','2022-04-12 13:23:39',5,'773','2022-04-12 13:24:08','773'),(2,'','21','238','SANI YASHI','SANI YASHI','07035436600','saniyashi@gmail.com',' BAUCHI','BAUCHI','INKIL GOMBE ROAD BAUCHI','Nigeria',450000.00,0.00,0.00,'0000-00-00','2022-04-12 13:28:11',5,'773','2022-04-12 13:28:11','773'),(3,'','21','238','AL\'ANSAR','ALH. RABI\'U','08072552395','alansar@gmail.com',' BAUCHI','BAUCHI','KANDAHAR QUATERS BAUCHI','Nigeria',1700000.00,0.00,0.00,'0000-00-00','2022-04-12 13:31:50',5,'773','2022-04-12 13:31:50','773'),(4,'','21','238','HASSAN JIGAWA','HASSAN JIGAWA','08034362582','hassanjigawa@gmail.com',' BAUCHI','BAUCHI','KASUWAN SHANU BAUCHI','Nigeria',350000.00,0.00,0.00,'0000-00-00','2022-04-12 13:38:49',5,'773','2022-04-12 13:38:49','773'),(5,'','21','238','ALH. SHUAIBU DANBATTA','ALH. SHUAIBU DANBATTA','08034411428','alhshuaibudanbatta@gmail.com',' BAUCHI','BAUCHI','GWALLAGA QUATERS BAUCHI','Nigeria',650000.00,0.00,0.00,'0000-00-00','2022-04-12 13:42:26',5,'773','2022-04-12 13:42:26','773'),(6,'','21','238','BASFROS','ALH. YUSUF','08035922827','basfros@gmail.com',' BAUCHI','BAUCHI','BASFROS FILLING STATION YELWA BAUCHI','Nigeria',650000.00,0.00,0.00,'0000-00-00','2022-04-12 13:47:10',5,'773','2022-04-12 13:47:10','773'),(7,'','21','238','ALH. ABDULHAMID GAJI','ALH. ABDULHAMID GAJI','07037074652','alh. abdulhamid gaji@gmail.com',' BAUCHI','BAUCHI','IBRAHIM QUATERS BAUCHI','Nigeria',320000.00,0.00,0.00,'0000-00-00','2022-04-12 13:49:03',5,'773','2022-04-12 13:49:03','773'),(8,'','21','238','ALH. ISA 411','ALH. ISA 411','08034275429','alhisa411@gmail.com','ALKALERI','BAUCHI','GWARAM QUATERS ALKALERI','Nigeria',720000.00,0.00,0.00,'0000-00-00','2022-04-12 13:51:17',5,'773','2022-04-12 13:51:17','773'),(9,'','21','238','ALH. KAWU','ALH. KAWU','08060057088','alhkawu@gmail.com',' BAUCHI','BAUCHI','KASUWAN SHANU BAUCHI','Nigeria',350000.00,0.00,0.00,'0000-00-00','2022-04-12 13:54:13',5,'773','2022-04-15 15:23:17','773'),(10,'','21','238','ALH. JUMBA A. GAMBO','ALH. JUMBA A. GAMBO','08069120555','jumba@gmail.com',' BAUCHI','BAUCHI','GOMBE ROAD BAUCHI','Nigeria',220000.00,0.00,0.00,'0000-00-00','2022-04-12 13:57:08',5,'773','2022-04-12 13:57:08','773'),(11,'','21','238','ALH.  YAU','ALH YAU','08034909250','alhyau@gmail.com',' BAUCHI','BAUCHI','FADAMAN MADA BAUCHI','Nigeria',785000.00,0.00,0.00,'0000-00-00','2022-04-12 14:07:44',5,'773','2022-04-12 14:07:44','773'),(12,'','21','238','SALEH SALEH','SALEH SALEH','08024239899','salesale@gmail.com',' BAUCHI','BAUCHI','GANJUWA QUATERS BAUCHI','Nigeria',1750000.00,0.00,0.00,'0000-00-00','2022-04-12 14:27:37',5,'773','2022-04-12 14:27:37','773'),(13,'','21','238','ALH RABIU MAI KUDIN GERO','ALH RABIU MAI KUDIN GERO','08034458899','rabiu@gmail.com',' BAUCHI','BAUCHI','GOMBE ROAD BAUCHI','Nigeria',120000.00,0.00,0.00,'0000-00-00','2022-04-12 14:29:46',5,'773','2022-04-12 14:29:46','773'),(14,'','21','238','RILWANU POLICE','RILWANU POLICE','07036624445','rilwanu@gmail.com',' BAUCHI','BAUCHI','GOMBE ROAD BAUCHI','Nigeria',650000.00,0.00,0.00,'0000-00-00','2022-04-12 14:32:11',5,'773','2022-04-12 14:32:11','773'),(15,'','21','238','ALH UMARU SINIYA','ALH UMARU SINIYA','08029331339','usiniya@gmail.com',' BAUCHI','BAUCHI','GOMBE ROAD BAUCHI','Nigeria',800000.00,0.00,0.00,'0000-00-00','2022-04-12 14:34:10',5,'773','2022-04-12 14:34:10','773'),(16,'','21','238','HABIBU DANGOTE','HABIBU DANGOTE','08023618888','habibu@gmail.com','KADUNA','KADUNA','SAMUNAKA KADUNA','Nigeria',2500000.00,0.00,0.00,'0000-00-00','2022-04-12 14:36:51',5,'773','2022-04-13 11:57:58','773'),(17,'','21','238','BABA KARAMI DANGOTE','BABA KARAMI DANGOTE','08160650203','bkarami@gmail.com','TORO','BAUCHI','TILDEN FULANI JOS ROAD','Nigeria',600000.00,0.00,0.00,'0000-00-00','2022-04-12 14:39:39',5,'773','2022-04-12 14:39:39','773'),(18,'','21','238','ALH MAHMUDA MAI TRAILER','ALH MAHMUDA MAI TRAILER','08069133878','alhmahmuda@gmail.com',' BAUCHI','BAUCHI','GOMBE ROAD BAUCHI','Nigeria',450000.00,0.00,0.00,'0000-00-00','2022-04-12 14:42:27',5,'773','2022-04-12 14:42:27','773'),(19,'','21','238','ALH MUKTARI MAI TRAILER','ALH MUKTARI MAI TRAILER','08063999133','alhmuktari@gmail.com',' BAUCHI','BAUCHI','GOMBE ROAD BAUCHI','Nigeria',450000.00,0.00,0.00,'0000-00-00','2022-04-12 14:47:01',5,'773','2022-04-12 14:47:01','773'),(20,'','21','238','ALH ZAKARI GWARAM','ALH ZAKARI GWARAM','08069630088','zakarigwaram@gmail.com','ALKALERI','BAUCHI','gwaram','Nigeria',230000.00,0.00,0.00,'0000-00-00','2022-04-12 14:50:14',5,'773','2022-04-12 14:50:14','773'),(21,'','21','238','ALH DANJUMA BIU','ALH DANJUMA BIU','08120072890','danjumabiu@gmail.com','BIU','BORNO','BIU','Nigeria',350000.00,0.00,0.00,'0000-00-00','2022-04-12 14:52:25',5,'773','2022-04-12 14:52:25','773'),(22,'','21','238','NASIRU ABK','NASIRU ABK','07066021255','adknasr@gmail.com','ALKALERI','BAUCHI','ALKALERI','Nigeria',750000.00,0.00,0.00,'0000-00-00','2022-04-12 14:54:59',5,'773','2022-04-15 12:00:44','773'),(23,'','21','238','ABDULRAZAK DUGURI','ABDULRAZAK DUGURI','08033196887','abdulrazak@gmail.com','ALKALERI','BAUCHI','DUGURI','Nigeria',300000.00,0.00,0.00,'0000-00-00','2022-04-12 14:56:58',5,'773','2022-04-12 14:56:58','773'),(24,'','21','238','BABA MUHAMMADU','BABA MUHAMMADU','07080788844','bmuh\'d@gmail.com',' BAUCHI','BAUCHI','GOMBE ROAD BAUCHI','Nigeria',250000.00,0.00,0.00,'0000-00-00','2022-04-12 14:59:45',5,'773','2022-04-12 14:59:45','773'),(25,'','21','238','ABBAS BELLO','ABBAS BELLO','081644441266','belloabbas@gmail.com',' BAUCHI','BAUCHI','GOMBE ROAD BAUCHI','Nigeria',155000.00,0.00,0.00,'0000-00-00','2022-04-12 15:05:09',5,'773','2022-04-12 15:05:09','773'),(26,'','21','238','ALH AUWALU','ALH AUWALU','0706042242','alhauwal@gmail.com',' BAUCHI','BAUCHI','INKIL','Nigeria',350000.00,0.00,0.00,'0000-00-00','2022-04-12 15:09:01',5,'773','2022-04-12 15:09:01','773'),(27,'','21','238','ALH UBA BABANKARATU','ALH UBA BABANKARATU','08035913931','babankaratu@gmail.com',' BAUCHI','BAUCHI','TASHAN BABIYE WUNTI STREET','Nigeria',350000.00,0.00,0.00,'0000-00-00','2022-04-12 15:11:38',5,'773','2022-04-12 15:11:38','773'),(28,'','21','238','ALH SAIDU LIMANKATAGUM','ALH SAIDU LIMANKATAGUM','08168960301','alhsaidulk@gmail.com',' BAUCHI','BAUCHI','LIMANKATAGUM','Nigeria',500000.00,0.00,0.00,'0000-00-00','2022-04-12 15:24:00',5,'773','2022-04-12 15:24:00','773'),(29,'','21','238','ALH SAMAILA SAMARI','ALH SAMAILA SAMARI','08033388838','samari@gmail.com',' BAUCHI','BAUCHI','BAKIN KURA','Nigeria',450000.00,0.00,0.00,'0000-00-00','2022-04-12 15:27:38',5,'773','2022-04-12 15:27:38','773'),(30,'','21','238','ALH SANI WADA','ALH SANI WADA','07036109399','alhsaniwada@gmail.com',' BAUCHI','BAUCHI','CENTRAL MARKET','Nigeria',600000.00,0.00,0.00,'0000-00-00','2022-04-12 15:31:24',5,'773','2022-04-15 15:22:24','773'),(31,'','21','238','BABA YAHAYA MAI TRAILER','BABA YAHAYA MAI TRAILER','08035676520','maitrailer@gmail.com',' BAUCHI','BAUCHI','KOFAR IDI','Nigeria',220000.00,0.00,0.00,'0000-00-00','2022-04-12 15:34:13',5,'773','2022-04-12 16:06:37','773'),(32,'','21','238','SULAIMAN BALEWA','SULAIMAN BALEWA','08036259689','balewa@gmail.com',' BAUCHI','BAUCHI','KOFAR IDI','Nigeria',120000.00,0.00,0.00,'0000-00-00','2022-04-12 15:37:50',5,'773','2022-04-12 15:37:50','773'),(33,'','21','238','ALH SHITU LUDA','ALH SHITU LUDA','08146163448','alhshituluda@gmail.com',' BAUCHI','BAUCHI','LUDA LIMANKATAGUM','Nigeria',350000.00,0.00,0.00,'0000-00-00','2022-04-12 15:41:20',5,'773','2022-04-12 15:41:20','773'),(34,'','21','238','ABDULAZEEZ BIG','ABDULAZEEZ BIG','080351559409','abdulazeez@gmail.com',' BAUCHI','BAUCHI','KASUWAR SHANU BAUCHI','Nigeria',700000.00,0.00,0.00,'0000-00-00','2022-04-12 15:44:17',5,'773','2022-04-12 15:44:17','773'),(35,'','21','238','SAIDU MAI TRAILER','SAIDU MAI TRAILER','08066242612','saidu@gmail.com',' BAUCHI','BAUCHI','KANDAHAR BAUCHI','Nigeria',220000.00,0.00,0.00,'0000-00-00','2022-04-12 15:46:47',5,'773','2022-04-12 15:46:47','773'),(36,'','21','238','DANTALA ATTA','DANTALA ATTA','08101090471','dantala@gmail.com',' BAUCHI','BAUCHI','YOLA DOKA','Nigeria',950000.00,0.00,0.00,'0000-00-00','2022-04-12 17:22:45',0,'773','2022-04-12 17:22:45','773'),(37,'','21','238','SUNUSIN MALAM','SUNUSIN MALAM','07066613983','sunusinmalam@gmail.com',' BAUCHI','BAUCHI','GOMBE ROAD BAUCHI','Nigeria',1200000.00,0.00,0.00,'0000-00-00','2022-04-12 17:24:42',0,'773','2022-04-12 17:24:42','773'),(38,'','21','238','ABUBAKAR MANAGER','ABUBAKAR MANAGER','08036612802','abkmanager@gmail.com',' BAUCHI','BAUCHI','GOMKBE ROAD BAUCHI','Nigeria',800000.00,0.00,0.00,'0000-00-00','2022-04-12 17:26:47',0,'773','2022-04-12 17:26:47','773'),(39,'','21','238','PRISON SERVICE','YARI','07039467906','nps@gmail.com',' BAUCHI','BAUCHI','N P S BAUCHI','Nigeria',230000.00,0.00,0.00,'0000-00-00','2022-04-12 17:30:52',0,'773','2022-04-12 17:30:52','773'),(40,'','21','238','GIDAN SHEHI','SULAIMAN','08040587230','shehi@gmail.com',' BAUCHI','BAUCHI','GIDAN SHEHI GOMBE ROAD','Nigeria',350000.00,0.00,0.00,'0000-00-00','2022-04-12 17:36:30',0,'773','2022-04-12 17:36:30','773'),(41,'','21','238','ALH ABBA','ALH ABBA','08092643414','abba@gmail.com',' BAUCHI','BAUCHI','GOMBE ROAD BAUCHI','Nigeria',120000.00,0.00,0.00,'0000-00-00','2022-04-15 12:05:33',5,'773','2022-04-15 12:05:33','773'),(42,'','21','238','ALH ALI MAI PARKERS','ALH ALI MAI PARKERS','08034714814','parkers@gmail.com',' BAUCHI','BAUCHI','KANDAHAR QUATERS BAUCHI','Nigeria',250000.00,0.00,0.00,'0000-00-00','2022-04-15 12:08:41',5,'773','2022-04-15 12:08:41','773');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
INSERT INTO `customers_status` VALUES (1,'21','238','40',0,'only first list are considered','2022-04-15 11:53:20'),(2,'21','238','39',0,'only first list are considered','2022-04-15 11:54:20'),(3,'21','238','38',0,'only first list are considered','2022-04-15 11:54:54'),(4,'21','238','37',0,'only first list are considered','2022-04-15 11:55:13'),(5,'21','238','36',0,'only first list are considered','2022-04-15 11:55:35');
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('21','238',1,'1',0.00,1200.00,'2022-03-20','','2022-03-30 12:08:32','764','764',2022,'764','2022-03-30 12:08:32',5),('21','238',2,'2',0.00,750.00,'2022-03-20','','2022-03-30 12:09:01','764','764',2022,'764','2022-03-30 12:09:01',5),('21','238',3,'3',0.00,1200.00,'2022-03-20','','2022-03-30 12:09:19','764','764',2022,'764','2022-03-30 12:09:19',5),('21','238',4,'4',0.00,1000.00,'2022-03-20','','2022-03-30 12:09:43','764','764',2022,'764','2022-03-30 12:09:43',5),('21','238',5,'5',0.00,650.00,'2022-03-20','','2022-03-30 12:10:01','764','764',2022,'764','2022-03-30 12:10:01',5),('21','238',6,'6',0.00,15450.00,'2022-03-20','','2022-03-30 12:10:46','764','764',2022,'764','2022-03-30 12:10:46',5),('21','238',7,'4',1000.00,20900.00,'2022-03-20','','2022-03-30 12:12:45','764','764',2022,'764','2022-03-30 12:12:45',5),('21','238',8,'5',650.00,18500.00,'2022-03-20','','2022-03-30 12:13:08','764','764',2022,'764','2022-03-30 12:13:08',5),('21','238',9,'1',1200.00,1200.00,'2022-03-29','','2022-03-31 12:20:00','764','764',2022,'764','2022-03-31 12:20:00',5),('21','238',10,'2',599.10,13600.00,'2022-03-29','','2022-03-31 12:20:26','764','764',2022,'764','2022-03-31 12:20:26',5),('21','238',11,'3',1200.00,11100.00,'2022-03-29','','2022-03-31 12:20:48','764','764',2022,'764','2022-03-31 12:20:48',5),('21','238',12,'4',19084.14,26000.00,'2022-03-29','','2022-03-31 12:21:18','764','764',2022,'764','2022-03-31 12:21:18',5),('21','238',13,'5',13742.15,24350.00,'2022-03-29','','2022-03-31 12:21:49','764','764',2022,'764','2022-03-31 12:21:49',5),('21','238',14,'6',15283.29,28800.00,'2022-03-29','','2022-03-31 12:22:11','764','764',2022,'764','2022-03-31 12:22:11',5),('21','238',15,'3',4029.91,6457.00,'2022-04-30','','2022-04-01 11:29:35','764','764',2022,'764','2022-04-01 11:29:35',5),('21','238',16,'3',1674.79,1845.00,'2022-04-25','','2022-04-25 09:11:56','764','764',2022,'764','2022-04-25 09:11:56',5),('21','238',17,'4',4337.74,4950.00,'2022-05-25','','2022-05-25 14:30:05','764','764',2022,'764','2022-05-25 14:30:05',5),('21','238',18,'5',4305.04,4398.00,'2022-05-25','','2022-05-25 14:31:25','764','764',2022,'764','2022-05-25 14:31:25',5),('21','238',19,'2',13891.97,14400.00,'2022-07-29','','2022-07-29 16:24:26','764','764',2022,'764','2022-07-29 16:24:26',5),('21','238',20,'2',29916.26,30916.00,'2022-08-08','','2022-08-08 16:53:52','764','764',2022,'764','2022-08-08 16:53:52',5),('21','238',21,'4',2386.28,3587.00,'2022-08-08','','2022-08-08 16:54:28','764','764',2022,'764','2022-08-08 16:54:28',5),('21','238',22,'5',14991.19,16991.00,'2022-08-08','','2022-08-08 16:54:55','764','764',2022,'764','2022-08-08 16:54:55',5),('21','238',23,'4',1644.60,1745.00,'2022-08-24','','2022-08-24 12:20:42','764','764',2022,'764','2022-08-24 12:20:42',5),('21','238',24,'1',3726.38,3766.00,'2022-09-07','','2022-09-07 23:24:18','764','764',2022,'764','2022-09-07 23:24:18',5),('21','238',25,'2',6146.44,4780.00,'2022-09-07','','2022-09-07 23:25:05','764','764',2022,'764','2022-09-07 23:25:05',5),('21','238',26,'3',2550.90,3567.00,'2022-09-07','','2022-09-07 23:26:13','764','764',2022,'764','2022-09-07 23:26:13',5),('21','238',27,'4',2173.35,2673.00,'2022-09-14','','2022-09-14 16:43:55','764','764',2022,'764','2022-09-14 16:43:55',5),('21','238',28,'4',2673.00,2673.00,'2022-09-14','','2022-09-14 16:43:55','764','764',2022,'764','2022-09-14 16:43:55',5),('21','238',29,'3',4955.41,5455.00,'2022-09-14','','2022-09-14 20:39:54','764','764',2022,'764','2022-09-14 20:39:54',5),('21','238',30,'1',6080.70,6381.00,'2022-09-24','','2022-09-24 19:11:01','764','764',2022,'764','2022-09-24 19:11:01',5),('21','238',31,'4',5957.13,6107.00,'2022-09-29','','2022-09-29 13:27:32','764','764',2022,'764','2022-09-29 13:27:32',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('21','238','1',1,'5','PMS NOZZLE 1',5834775.88,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-31 12:04:24','764'),('21','238','1',2,'5','PMS NOZZLE 2',5181540.69,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-31 12:03:52','764'),('21','238','2',5,'5','PMS NOZZLE 3',81348.72,'PMS DISPENSER','',NULL,NULL,'',5,'2022-09-29 16:26:05','764'),('21','238','2',6,'5','PMS NOZZLE 6',5774208.18,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-31 12:05:43','764'),('21','238','3',9,'5','PMS NOZZLE 4',5175243.92,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-31 12:06:43','764'),('21','238','3',11,'5','PMS NOZZLE 5',5848467.36,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-31 12:07:11','764'),('21','238','4',13,'5','AGO NOZZLE 8',2967360.38,'AGO DISPENSER','',NULL,NULL,'',5,'2022-03-31 12:07:39','764'),('21','238','5',15,'5','AGO NOZZLE 7A',564513.78,'AGO DISPENSER','',NULL,NULL,'',5,'2022-03-31 12:08:01','764'),('21','238','5',16,'5','AGO NOZZLE 7B',287852.01,'AGO DISPENSER','',NULL,NULL,'',5,'2022-03-31 12:08:30','764'),('21','238','6',17,'5','DPK NOZZLE 9',598496.73,'DPK DISPENSER','',NULL,NULL,'',5,'2022-03-31 12:08:55','764');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=240 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('21','238',1,'DAILY','2022-03-21','2022-03-30 12:50:38','2022-03-31 12:50:38','764',4705038.58,4705038.58,'764','2022-03-30 13:15:46','764','2022-03-30 14:07:25',10,0),('21','238',2,'DAILY','2022-03-22','2022-03-30 14:53:20','2022-03-31 14:53:20','773',0.00,0.00,'773','2022-03-30 15:34:16','764','2022-03-31 11:58:32',10,0),('21','238',3,'DAILY','2022-03-30','2022-03-31 12:29:22','2022-04-01 12:29:22','764',11386251.60,11386251.60,'764','2022-03-31 12:56:07','773','2022-03-31 13:55:47',10,0),('21','238',4,'DAILY','2022-03-31','2022-04-01 10:41:22','2022-04-02 10:41:22','773',10250686.25,10250686.25,'773','2022-04-01 11:33:17','773','2022-04-01 12:40:17',10,0),('21','238',5,'DAILY','2022-04-01','2022-04-02 10:58:55','2022-04-03 10:58:55','773',3623868.86,3623868.86,'773','2022-04-02 11:09:49','773','2022-04-02 11:35:39',10,0),('21','238',6,'DAILY','2022-04-03','2022-04-03 10:39:38','2022-04-04 10:39:38','773',6129726.32,6129726.32,'773','2022-04-03 10:43:28','773','2022-04-03 11:11:44',10,0),('21','238',7,'DAILY','2022-04-04','2022-04-04 10:03:19','2022-04-05 10:03:19','773',7066397.37,7066397.37,'773','2022-04-04 10:11:09','773','2022-04-04 10:31:11',10,0),('21','238',8,'DAILY','2022-04-05','2022-04-05 13:15:40','2022-04-06 13:15:40','773',8518288.78,8518288.78,'773','2022-04-05 13:25:36','773','2022-04-06 08:53:05',10,0),('21','238',9,'DAILY','2022-04-06','2022-04-06 11:03:55','2022-04-07 11:03:55','773',10213223.46,10213223.46,'773','2022-04-06 11:10:42','773','2022-04-06 12:34:14',10,0),('21','238',10,'DAILY','2022-04-07','2022-04-07 09:15:04','2022-04-08 09:15:04','773',8701027.91,8701027.91,'773','2022-04-07 09:21:41','773','2022-04-07 09:47:12',10,0),('21','238',11,'DAILY','2022-04-07','2022-04-08 10:18:57','2022-04-09 10:18:57','773',7867604.32,7867604.32,'773','2022-04-08 10:24:51','773','2022-04-08 11:05:27',10,0),('21','238',12,'DAILY','2022-04-08','2022-04-09 10:38:30','2022-04-10 10:38:30','773',6415980.49,6415980.49,'773','2022-04-09 10:44:13','773','2022-04-09 12:09:25',10,0),('21','238',13,'DAILY','2022-04-09','2022-04-10 09:20:51','2022-04-11 09:20:51','773',6901510.90,6901510.90,'773','2022-04-10 09:28:01','773','2022-04-10 09:36:38',10,0),('21','238',14,'DAILY','2022-04-10','2022-04-10 09:37:31','2022-04-11 09:37:31','773',5548983.72,5548983.72,'773','2022-04-11 08:02:06','773','2022-04-11 08:14:19',10,0),('21','238',15,'MORNING SHIFT (PRICE DECREAMENT)','2022-04-11','2022-04-11 20:55:35','2022-04-12 20:55:35','773',2177948.46,2177948.46,'773','2022-04-11 20:58:02','773','2022-04-12 16:12:41',10,0),('21','238',16,'DAILY','2022-04-12','2022-04-12 16:13:07','2022-04-13 16:13:07','773',0.00,0.00,'773','2022-04-13 17:25:40','773','2022-04-13 17:26:23',10,0),('21','238',17,'DAILY','2022-04-11','2022-04-15 13:27:35','2022-04-16 13:27:35','773',5848023.94,5848023.94,'773','2022-04-15 13:40:41','773','2022-04-15 14:12:02',10,0),('21','238',18,'DAILY','2022-04-12','2022-04-15 14:13:47','2022-04-16 14:13:47','773',6495450.36,6495450.36,'773','2022-04-15 14:37:58','773','2022-04-15 14:55:46',10,0),('21','238',19,'DAILY','2022-04-13','2022-04-15 14:57:03','2022-04-16 14:57:03','773',8612190.51,8612190.51,'773','2022-04-15 15:26:53','773','2022-04-15 15:40:43',10,0),('21','238',20,'DAILY','2022-04-14','2022-04-15 15:41:09','2022-04-16 15:41:09','773',7932779.59,7932779.59,'773','2022-04-16 10:38:20','773','2022-04-16 11:07:39',10,0),('21','238',21,'DAILY','2022-04-15','2022-04-16 15:54:30','2022-04-17 15:54:30','773',4009042.46,4009042.46,'773','2022-04-16 16:04:03','773','2022-04-16 16:28:56',10,0),('21','238',22,'DAILY','2022-04-16','2022-04-17 10:52:00','2022-04-18 10:52:00','773',7324471.62,7324471.62,'773','2022-04-17 20:57:56','773','2022-04-18 15:23:21',10,0),('21','238',23,'DAILY','2022-04-17','2022-04-18 15:24:10','2022-04-19 15:24:10','773',12098892.37,12098892.37,'773','2022-04-18 15:27:38','773','2022-04-18 15:47:06',10,0),('21','238',24,'MORNING SHIFT (PRICE DECREAMENT)','2022-04-19','2022-04-19 10:08:13','2022-04-20 10:08:13','773',382703.88,382703.88,'773','2022-04-19 10:36:00','773','2022-04-19 10:54:59',10,0),('21','238',25,'DAILY','2022-04-18','2022-04-19 11:15:12','2022-04-20 11:15:12','773',4650533.57,4650533.57,'773','2022-04-19 14:27:00','773','2022-04-20 12:05:56',10,0),('21','238',26,'DAILY','2022-04-19','2022-04-20 12:06:23','2022-04-21 12:06:23','773',5124866.19,5124866.19,'773','2022-04-21 10:37:59','773','2022-04-21 11:32:06',10,0),('21','238',27,'DAILY','2022-04-20','2022-04-21 11:34:36','2022-04-22 11:34:36','773',10182373.87,10182373.87,'773','2022-04-21 11:56:33','773','2022-04-21 12:08:03',10,0),('21','238',28,'DAILY','2022-04-21','2022-04-22 13:16:38','2022-04-23 13:16:38','773',8379769.25,8379769.25,'773','2022-04-22 13:32:11','773','2022-04-22 13:57:58',10,0),('21','238',29,'DAILY','2022-04-22','2022-04-22 13:59:30','2022-04-23 13:59:30','773',7132390.38,7132390.38,'773','2022-04-23 11:05:02','773','2022-04-23 11:16:30',10,0),('21','238',30,'DAILY','2022-04-23','2022-04-24 10:59:02','2022-04-25 10:59:02','773',7447930.72,7447930.72,'773','2022-04-24 11:04:18','773','2022-04-24 11:18:13',10,0),('21','238',31,'Daily','2022-04-24','2022-04-24 11:29:59','2022-04-25 11:29:59','773',8129793.02,8129793.02,'773','2022-04-25 10:53:19','773','2022-04-25 10:54:31',10,0),('21','238',32,'DAILY','2022-04-25','2022-04-25 11:18:18','2022-04-26 11:18:18','773',6126433.84,6126433.84,'773','2022-04-26 10:51:58','773','2022-04-26 11:03:30',10,0),('21','238',33,'DAILY','2022-04-26','2022-04-26 11:11:38','2022-04-27 11:11:38','773',10058446.75,10058446.75,'773','2022-04-27 12:06:48','773','2022-04-27 12:24:45',10,0),('21','238',34,'DAILY','2022-04-27','2022-04-28 11:29:29','2022-04-29 11:29:29','773',7816701.56,7816701.56,'773','2022-04-28 13:27:56','773','2022-04-28 14:03:25',10,0),('21','238',35,'DAILY','2022-04-28','2022-04-29 08:58:31','2022-04-30 08:58:31','773',4751357.21,4751357.21,'773','2022-04-29 09:04:26','773','2022-04-29 09:15:07',10,0),('21','238',36,'DAILY','2022-04-29','2022-04-30 12:50:17','2022-05-01 12:50:17','773',8832742.11,8832742.11,'773','2022-04-30 12:56:36','773','2022-04-30 13:10:20',10,0),('21','238',37,'DAILY','2022-04-30','2022-05-01 08:36:01','2022-05-02 08:36:01','773',7541431.04,7541431.04,'773','2022-05-01 08:46:16','773','2022-05-01 09:00:52',10,0),('21','238',38,'DAILY','2022-04-30','2022-05-05 20:06:34','2022-05-06 20:06:34','773',8634058.12,8634058.12,'773','2022-05-06 11:25:05','773','2022-05-06 11:43:54',10,0),('21','238',39,'DAILY','2022-05-02','2022-05-06 11:46:24','2022-05-07 11:46:24','773',4385491.40,4385491.40,'773','2022-05-06 12:16:13','773','2022-05-06 12:37:03',10,0),('21','238',40,'DAILY','2022-05-03','2022-05-06 12:38:40','2022-05-07 12:38:40','773',2947895.84,2947895.84,'773','2022-05-06 14:29:46','773','2022-05-06 14:37:29',10,0),('21','238',41,'DAILY','2022-05-04','2022-05-06 14:37:58','2022-05-07 14:37:58','773',9504314.77,9504314.77,'773','2022-05-06 14:43:53','773','2022-05-06 15:06:37',10,0),('21','238',42,'DAILY','2022-05-05','2022-05-06 15:08:06','2022-05-07 15:08:06','773',12366671.04,12366671.04,'773','2022-05-07 14:56:04','773','2022-05-07 16:23:52',10,0),('21','238',43,'DAILY','2022-05-06','2022-05-17 13:40:20','2022-05-18 13:40:20','773',0.00,0.00,'773','2022-05-17 15:47:14','773','2022-05-17 15:47:34',10,0),('21','238',44,'DAILY','2022-05-06','2022-05-17 15:48:01','2022-05-18 15:48:01','773',11947565.10,11947565.10,'773','2022-05-17 15:59:02','773','2022-05-17 16:22:07',10,0),('21','238',45,'MORNING SHIFT (PRICE INCREAMENT)','2022-05-07','2022-05-17 16:35:35','2022-05-18 16:35:35','773',1497635.28,1497635.28,'773','2022-05-17 16:38:58','773','2022-05-17 16:40:03',10,0),('21','238',46,'DAILY','2022-05-07','2022-05-17 16:42:46','2022-05-18 16:42:46','773',9613370.00,9613370.00,'773','2022-05-17 16:55:19','773','2022-05-17 17:13:31',10,0),('21','238',47,'DAILY','2022-05-08','2022-05-17 17:22:52','2022-05-18 17:22:52','773',6440903.51,6440903.51,'773','2022-05-17 17:35:20','773','2022-05-17 17:49:48',10,0),('21','238',48,'DAILY','2022-05-09','2022-05-17 17:50:28','2022-05-18 17:50:28','773',9379889.30,9379889.30,'773','2022-05-17 18:02:52','773','2022-05-17 18:19:22',10,0),('21','238',49,'DAILY','2022-05-10','2022-05-17 18:38:38','2022-05-18 18:38:38','773',12829044.85,12829044.85,'773','2022-05-17 19:09:41','773','2022-05-17 19:37:39',10,0),('21','238',50,'DAILY','2022-05-11','2022-05-17 20:07:29','2022-05-18 20:07:29','773',9222224.68,9222224.68,'773','2022-05-17 20:16:15','773','2022-05-17 21:17:13',10,0),('21','238',51,'DAILY','2022-05-12','2022-05-18 13:26:55','2022-05-19 13:26:55','773',72637.50,72637.50,'773','2022-05-18 13:28:04','773','2022-05-18 13:45:22',10,0),('21','238',52,'DAILY','2022-05-13','2022-05-18 13:46:10','2022-05-19 13:46:10','773',58662.50,58662.50,'773','2022-05-18 13:46:49','773','2022-05-18 13:57:38',10,0),('21','238',53,'DAILY','2022-05-14','2022-05-18 16:19:55','2022-05-19 16:19:55','773',6038403.82,6038403.82,'773','2022-05-18 16:25:46','773','2022-05-18 16:39:27',10,0),('21','238',54,'DAILY','2022-05-15','2022-05-18 16:41:10','2022-05-19 16:41:10','773',7726177.00,7726177.00,'773','2022-05-18 16:54:51','773','2022-05-18 17:05:07',10,0),('21','238',55,'DAILY','2022-05-16','2022-05-18 17:05:46','2022-05-19 17:05:46','773',76011.00,76011.00,'773','2022-05-18 17:07:44','773','2022-05-18 17:16:05',10,0),('21','238',56,'DAILY','2022-05-17','2022-05-18 17:36:15','2022-05-19 17:36:15','773',9502163.12,9502163.12,'773','2022-05-18 17:44:16','773','2022-05-18 17:58:53',10,0),('21','238',57,'DAILY','2022-05-18','2022-05-19 17:00:25','2022-05-20 17:00:25','773',10124882.48,10124882.48,'773','2022-05-19 17:11:59','773','2022-05-20 09:15:59',10,0),('21','238',58,'DAILY','2022-05-19','2022-05-20 09:28:43','2022-05-21 09:28:43','773',8778231.20,8778231.20,'773','2022-05-20 09:37:03','773','2022-05-20 09:52:52',10,0),('21','238',59,'DAILY','2022-05-20','2022-05-22 17:37:24','2022-05-23 17:37:24','773',6350946.21,6350946.21,'773','2022-05-22 17:43:23','773','2022-05-22 18:06:25',10,0),('21','238',60,'DAILY','2022-05-21','2022-05-22 18:13:25','2022-05-23 18:13:25','773',4987103.76,4987103.76,'773','2022-05-22 18:17:40','773','2022-05-22 18:25:50',10,0),('21','238',61,'MORNING SHIFT (PRICE INCREAMENT)','2022-05-22','2022-05-25 14:35:25','2022-05-26 14:35:25','773',6601478.68,6601478.68,'773','2022-05-25 14:45:07','773','2022-05-25 15:03:37',10,0),('21','238',62,'DAILY','2022-05-22','2022-05-25 15:05:49','2022-05-26 15:05:49','773',2839669.92,2839669.92,'773','2022-05-25 15:38:56','773','2022-05-25 15:45:28',10,0),('21','238',63,'DAILY','2022-05-23','2022-05-25 15:45:57','2022-05-26 15:45:57','773',145249.00,145249.00,'773','2022-05-25 15:51:16','773','2022-05-25 15:54:41',10,0),('21','238',64,'DAILY','2022-05-24','2022-05-25 15:55:08','2022-05-26 15:55:08','773',3826022.90,3826022.90,'773','2022-05-25 16:23:27','773','2022-05-25 16:41:07',10,0),('21','238',65,'DAILY','2022-05-25','2022-05-30 11:15:57','2022-05-31 11:15:57','773',5578641.85,5578641.85,'773','2022-05-30 12:12:03','773','2022-05-30 12:14:55',10,0),('21','238',66,'DAILY','2022-05-26','2022-05-30 12:16:23','2022-05-31 12:16:23','773',8575066.90,8575066.90,'773','2022-05-30 17:10:44','773','2022-05-30 17:31:12',10,0),('21','238',67,'DAILY','2022-05-27','2022-05-30 17:31:45','2022-05-31 17:31:45','773',6719563.34,6719563.34,'773','2022-05-30 17:36:25','773','2022-05-30 17:47:05',10,0),('21','238',68,'DAILY','2022-05-28','2022-05-30 17:47:50','2022-05-31 17:47:50','773',7352659.00,7352659.00,'773','2022-05-30 17:52:22','773','2022-05-30 18:12:40',10,0),('21','238',69,'DAILY','2022-05-29','2022-05-30 18:13:34','2022-05-31 18:13:34','773',3155057.08,3155057.08,'773','2022-05-30 18:18:27','773','2022-05-30 18:24:11',10,0),('21','238',70,'DAILY','2022-05-30','2022-05-31 10:57:24','2022-06-01 10:57:24','773',3402718.26,3402718.26,'773','2022-05-31 10:59:15','773','2022-06-01 12:28:53',10,0),('21','238',71,'DAILY','2022-05-31','2022-06-01 13:18:32','2022-06-02 13:18:32','773',8753771.94,8753771.94,'773','2022-06-01 15:00:37','773','2022-06-01 15:34:00',10,0),('21','238',72,'DAILY','2022-06-01','2022-06-02 12:05:39','2022-06-03 12:05:39','773',6422233.89,6422233.89,'773','2022-06-02 12:24:21','773','2022-06-02 12:53:42',10,0),('21','238',73,'DAILY','2022-06-02','2022-06-06 14:12:50','2022-06-07 14:12:50','773',12536012.44,12536012.44,'773','2022-06-06 15:38:43','773','2022-06-06 16:19:25',10,0),('21','238',74,'DAILY','2022-06-03','2022-06-06 16:21:41','2022-06-07 16:21:41','773',5354917.72,5354917.72,'773','2022-06-06 16:31:30','773','2022-06-06 16:45:49',10,0),('21','238',75,'MORNING SHIFT (PRICE INCREAMENT)','2022-06-04','2022-06-06 16:53:59','2022-06-07 16:53:59','773',5221225.28,5221225.28,'773','2022-06-06 16:57:10','773','2022-06-06 16:59:58',10,0),('21','238',76,'EVENING ','2022-06-04','2022-06-06 17:03:24','2022-06-07 17:03:24','773',3555063.27,3555063.27,'773','2022-06-06 17:17:28','773','2022-06-06 17:52:25',10,0),('21','238',77,'DAILY','2022-06-05','2022-06-07 13:09:02','2022-06-08 13:09:02','773',7432707.09,7432707.09,'773','2022-06-07 14:54:41','773','2022-06-07 14:58:58',10,0),('21','238',78,'DAILY','2022-06-06','2022-06-07 15:03:05','2022-06-08 15:03:05','773',9539581.17,9539581.17,'773','2022-06-07 15:23:26','773','2022-06-07 16:04:17',10,0),('21','238',79,'DAILY','2022-06-07','2022-06-09 14:40:53','2022-06-10 14:40:53','773',12117422.80,12117422.80,'773','2022-06-09 14:50:11','773','2022-06-09 15:01:00',10,0),('21','238',80,'MORNING SHIFT (PRICE INCREAMENT)','2022-06-08','2022-06-14 15:01:44','2022-06-15 15:01:44','773',2244544.46,2244544.46,'773','2022-06-14 15:31:58','773','2022-06-14 15:38:02',10,0),('21','238',81,'EVENING ','2022-06-08','2022-06-14 15:42:05','2022-06-15 15:42:05','773',5893830.37,5893830.37,'773','2022-06-14 15:47:57','773','2022-06-14 16:03:46',10,0),('21','238',82,'DAILY','2022-06-09','2022-06-14 16:05:48','2022-06-15 16:05:48','773',13277326.86,13277326.86,'773','2022-06-15 15:27:07','773','2022-06-15 15:46:52',10,0),('21','238',83,'DAILY','2022-06-10','2022-06-15 15:48:40','2022-06-16 15:48:40','773',4576991.20,4576991.20,'773','2022-06-15 15:59:14','773','2022-06-15 16:11:29',10,0),('21','238',84,'MORNING SHIFT (PRICE INCREAMENT)','2022-06-11','2022-06-15 16:13:25','2022-06-16 16:13:25','773',2539499.34,2539499.34,'773','2022-06-15 16:16:58','773','2022-06-15 16:22:32',10,0),('21','238',85,'DAILY','2022-06-11','2022-06-15 16:26:27','2022-06-16 16:26:27','773',898506.00,898506.00,'773','2022-06-15 16:27:25','773','2022-06-15 16:32:13',10,0),('21','238',86,'DAILY','2022-06-12','2022-06-15 16:33:38','2022-06-16 16:33:38','773',6035952.26,6035952.26,'773','2022-06-15 16:38:55','773','2022-06-15 16:43:47',10,0),('21','238',87,'MORNING SHIFT (PRICE INCREAMENT)','2022-06-13','2022-06-17 14:28:36','2022-06-18 14:28:36','773',0.00,0.00,'773','2022-06-17 14:30:55','773','2022-06-17 14:31:16',10,0),('21','238',88,'DAILY','2022-06-13','2022-06-17 14:49:04','2022-06-18 14:49:04','773',5946170.09,5946170.09,'773','2022-06-17 15:06:52','773','2022-06-17 15:31:20',10,0),('21','238',89,'EVENING SHIFT (PRICE INCREAMENT)','2022-06-13','2022-06-17 15:32:41','2022-06-18 15:32:41','773',0.00,0.00,'773','2022-06-17 15:35:22','773','2022-06-17 15:35:39',10,0),('21','238',90,'EVENING SHIFT (PRICE INCREAMENT)','2022-06-13','2022-06-17 15:36:53','2022-06-18 15:36:53','773',57659.00,57659.00,'773','2022-06-17 15:39:52','773','2022-06-17 15:49:14',10,0),('21','238',91,'DAILY','2022-06-14','2022-06-17 15:50:36','2022-06-18 15:50:36','773',12799333.06,12799333.06,'773','2022-06-17 16:09:24','773','2022-06-17 16:31:55',10,0),('21','238',92,'DAILY','2022-06-15','2022-06-21 14:25:27','2022-06-22 14:25:27','773',7234293.54,7234293.54,'773','2022-06-21 14:33:49','773','2022-06-21 14:44:19',10,0),('21','238',93,'DAILY','2022-06-16','2022-06-21 15:13:13','2022-06-22 15:13:13','773',4679597.75,4679597.75,'773','2022-06-21 15:18:16','773','2022-06-21 15:24:50',10,0),('21','238',94,'DAILY','2022-06-17','2022-06-21 15:25:50','2022-06-22 15:25:50','773',37335.00,37335.00,'773','2022-06-21 15:26:46','773','2022-06-21 15:28:22',10,0),('21','238',95,'DAILY','2022-06-18','2022-06-21 15:28:47','2022-06-22 15:28:47','773',77505.00,77505.00,'773','2022-06-21 15:30:11','773','2022-06-21 15:31:38',10,0),('21','238',96,'DAILY','2022-06-19','2022-06-21 15:43:27','2022-06-22 15:43:27','773',10111121.67,10111121.67,'773','2022-06-21 15:57:53','773','2022-06-21 16:08:55',10,0),('21','238',97,'DAILY','2022-06-20','2022-06-21 16:09:48','2022-06-22 16:09:48','773',6525259.50,6525259.50,'773','2022-06-21 16:16:21','773','2022-06-21 16:40:55',10,0),('21','238',98,'DAILY','2022-06-21','2022-06-22 13:00:28','2022-06-23 13:00:28','773',11149368.06,11149368.06,'773','2022-06-22 13:38:50','773','2022-06-22 14:39:10',10,0),('21','238',99,'DAILY','2022-06-22','2022-06-28 13:46:58','2022-06-29 13:46:58','773',7970207.37,7970207.37,'773','2022-06-28 13:53:07','773','2022-06-28 14:03:27',10,0),('21','238',100,'DAILY','2022-06-23','2022-06-28 14:03:51','2022-06-29 14:03:51','773',7590896.34,7590896.34,'773','2022-06-28 14:09:52','773','2022-06-28 14:24:04',10,0),('21','238',101,'DAILY','2022-06-24','2022-06-28 14:24:38','2022-06-29 14:24:38','773',3653427.84,3653427.84,'773','2022-06-28 14:47:27','773','2022-06-28 15:07:42',10,0),('21','238',102,'DAILY','2022-06-25','2022-06-28 15:08:23','2022-06-29 15:08:23','773',8443867.56,8443867.56,'773','2022-06-28 15:47:29','773','2022-06-28 16:02:25',10,0),('21','238',103,'DAILY','2022-06-26','2022-06-28 16:03:12','2022-06-29 16:03:12','773',5966941.56,5966941.56,'773','2022-06-28 16:09:08','773','2022-06-28 16:18:06',10,0),('21','238',104,'DAILY','2022-06-27','2022-06-28 16:19:03','2022-06-29 16:19:03','773',9287602.38,9287602.38,'773','2022-06-28 16:21:06','773','2022-06-28 16:57:32',10,0),('21','238',105,'DAILY','2022-06-28','2022-06-29 13:18:48','2022-06-30 13:18:48','773',11283680.85,11283680.85,'773','2022-06-29 13:46:12','773','2022-06-29 14:39:57',10,0),('21','238',106,'DAILY','2022-06-29','2022-07-08 11:52:05','2022-07-09 11:52:05','773',12372280.38,12372280.38,'773','2022-07-08 12:27:31','773','2022-07-08 12:45:28',10,0),('21','238',107,'DAILY','2022-06-30','2022-07-08 12:47:33','2022-07-09 12:47:33','773',6422275.65,6422275.65,'773','2022-07-08 13:03:18','773','2022-07-08 15:07:23',10,0),('21','238',108,'DAILY','2022-07-01','2022-07-08 15:09:20','2022-07-09 15:09:20','773',6057665.97,6057665.97,'773','2022-07-08 15:14:51','773','2022-07-08 15:22:17',10,0),('21','238',109,'DAILY','2022-07-02','2022-07-08 15:23:44','2022-07-09 15:23:44','773',5847341.40,5847341.40,'773','2022-07-08 15:33:50','773','2022-07-08 15:43:49',10,0),('21','238',110,'DAILY','2022-07-03','2022-07-08 15:44:31','2022-07-09 15:44:31','773',4874879.64,4874879.64,'773','2022-07-08 16:14:53','773','2022-07-08 16:20:57',10,0),('21','238',111,'DAILY','2022-07-04','2022-07-08 16:21:22','2022-07-09 16:21:22','773',5840660.34,5840660.34,'773','2022-07-08 16:26:05','773','2022-07-08 16:35:30',10,0),('21','238',112,'DAILY','2022-07-05','2022-07-08 16:36:31','2022-07-09 16:36:31','773',6832015.20,6832015.20,'773','2022-07-08 16:41:04','773','2022-07-08 16:52:12',10,0),('21','238',113,'DAILY','2022-07-06','2022-07-09 15:51:20','2022-07-10 15:51:20','773',4323034.26,4323034.26,'773','2022-07-09 15:54:55','773','2022-07-09 16:04:36',10,0),('21','238',114,'DAILY','2022-07-07','2022-07-09 16:04:58','2022-07-10 16:04:58','773',6866104.47,6866104.47,'773','2022-07-09 16:13:46','773','2022-07-09 16:31:49',10,0),('21','238',115,'DAILY','2022-07-08','2022-07-13 16:45:27','2022-07-14 16:45:27','773',2766436.26,2766436.26,'773','2022-07-13 16:50:22','773','2022-07-13 17:18:13',10,0),('21','238',116,'DAILY','2022-07-09','2022-07-13 17:27:53','2022-07-14 17:27:53','773',3937271.86,3937271.86,'773','2022-07-13 17:31:51','773','2022-07-13 17:45:05',10,0),('21','238',117,'DAILY','2022-07-10','2022-07-13 17:46:03','2022-07-14 17:46:03','773',1684302.90,1684302.90,'773','2022-07-13 17:48:19','773','2022-07-13 17:52:29',10,0),('21','238',118,'DAILY','2022-07-11','2022-07-13 17:53:14','2022-07-14 17:53:14','773',3774293.16,3774293.16,'773','2022-07-13 17:56:21','773','2022-07-13 17:59:15',10,0),('21','238',119,'DAILY','2022-07-12','2022-07-15 08:48:39','2022-07-16 08:48:39','773',6735193.62,6735193.62,'773','2022-07-15 08:54:26','773','2022-07-15 09:07:07',10,0),('21','238',120,'DAILY','2022-07-13','2022-07-15 09:13:31','2022-07-16 09:13:31','773',13469037.78,13469037.78,'773','2022-07-15 09:25:05','773','2022-07-15 09:32:53',10,0),('21','238',121,'DAILY','2022-07-14','2022-07-15 09:33:29','2022-07-16 09:33:29','773',5425914.24,5425914.24,'773','2022-07-15 09:46:16','773','2022-07-18 08:45:46',10,0),('21','238',122,'DAILY','2022-07-15','2022-07-18 08:48:16','2022-07-19 08:48:16','773',9116538.79,9116538.79,'773','2022-07-18 09:12:24','773','2022-07-18 09:46:41',10,0),('21','238',123,'DAILY','2022-07-16','2022-07-18 09:47:27','2022-07-19 09:47:27','773',3278201.52,3278201.52,'773','2022-07-18 09:54:32','773','2022-07-18 10:04:46',10,0),('21','238',124,'DAILY','2022-07-17','2022-07-18 10:06:32','2022-07-19 10:06:32','773',4980873.78,4980873.78,'773','2022-07-18 13:21:30','773','2022-07-18 13:29:10',10,0),('21','238',125,'DAILY','2022-07-18','2022-07-19 13:51:14','2022-07-20 13:51:14','773',8420055.12,8420055.12,'773','2022-07-19 14:03:29','773','2022-07-19 14:23:34',10,0),('21','238',126,'DAILY','2022-07-19','2022-07-20 09:05:01','2022-07-21 09:05:01','773',4786933.68,4786933.68,'773','2022-07-20 09:11:52','773','2022-07-20 09:28:55',10,0),('21','238',127,'MORNING SHIFT ','2022-07-20','2022-07-21 11:19:44','2022-07-22 11:19:44','773',3775688.28,3775688.28,'773','2022-07-21 11:27:22','773','2022-07-21 11:35:40',10,0),('21','238',128,'EVENING SHIFT (PRICE DECREMENT)','2022-07-20','2022-07-21 11:37:15','2022-07-22 11:37:15','773',7380007.30,7380007.30,'773','2022-07-21 11:54:51','773','2022-07-21 12:57:47',10,0),('21','238',129,'DAILY','2022-07-21','2022-07-22 11:18:39','2022-07-23 11:18:39','773',6934685.90,6934685.90,'773','2022-07-22 11:27:22','773','2022-07-22 11:35:35',10,0),('21','238',130,'DAILY','2022-07-22','2022-07-25 12:56:12','2022-07-26 12:56:12','773',7165976.43,7165976.43,'773','2022-07-25 13:07:37','773','2022-07-25 13:14:37',10,0),('21','238',131,'DAILY','2022-07-23','2022-07-25 13:16:05','2022-07-26 13:16:05','773',5148425.94,5148425.94,'773','2022-07-25 13:33:33','773','2022-07-25 13:39:40',10,0),('21','238',132,'DAILY','2022-07-24','2022-07-25 13:40:13','2022-07-26 13:40:13','773',4854281.37,4854281.37,'773','2022-07-25 13:53:39','773','2022-07-25 14:03:28',10,0),('21','238',133,'DAILY','2022-07-25','2022-07-26 16:53:58','2022-07-27 16:53:58','773',5477620.23,5477620.23,'773','2022-07-26 17:03:23','773','2022-07-26 17:12:47',10,0),('21','238',134,'MORNING SHIFT ','2022-07-26','2022-07-27 18:55:04','2022-07-28 18:55:04','773',25335.00,25335.00,'773','2022-07-27 18:57:30','773','2022-07-27 18:59:30',10,0),('21','238',135,'EVENING SHIFT (PRICE INCREAMENT)','2022-07-26','2022-07-27 19:01:38','2022-07-28 19:01:38','773',6983391.51,6983391.51,'773','2022-07-27 19:10:47','773','2022-07-27 19:33:43',10,0),('21','238',136,'DAILY','2022-07-27','2022-07-28 17:11:08','2022-07-29 17:11:08','773',7940516.63,7940516.63,'773','2022-07-28 17:18:52','773','2022-07-28 17:30:38',10,0),('21','238',137,'DAILY','2022-07-28','2022-07-29 13:35:06','2022-07-30 13:35:06','773',9137201.14,9137201.14,'773','2022-07-29 15:24:50','773','2022-07-29 15:33:51',10,0),('21','238',138,'DAILY','2022-07-29','2022-07-30 17:15:43','2022-07-31 17:15:43','773',8835019.84,8835019.84,'773','2022-07-30 17:47:13','773','2022-07-30 18:45:55',10,0),('21','238',139,'DAILY','2022-07-29','2022-08-02 16:00:57','2022-08-03 16:00:57','773',5965758.46,5965758.46,'773','2022-08-02 16:10:47','773','2022-08-02 16:26:35',10,0),('21','238',140,'DAILY','2022-07-31','2022-08-02 16:29:04','2022-08-03 16:29:04','773',7665798.14,7665798.14,'773','2022-08-02 17:07:17','773','2022-08-02 17:16:15',10,0),('21','238',141,'DAILY','2022-08-01','2022-08-02 17:21:03','2022-08-03 17:21:03','773',11054042.23,11054042.23,'773','2022-08-02 17:30:02','773','2022-08-02 17:40:03',10,0),('21','238',142,'DAILY','2022-08-02','2022-08-03 15:06:03','2022-08-04 15:06:03','773',5749020.58,5749020.58,'773','2022-08-03 15:24:01','773','2022-08-04 14:37:17',10,0),('21','238',143,'DAILY','2022-08-03','2022-08-04 14:38:15','2022-08-05 14:38:15','773',11510570.58,11510570.58,'773','2022-08-04 14:48:20','773','2022-08-04 14:55:21',10,0),('21','238',144,'DAILY','2022-08-04','2022-08-05 19:51:32','2022-08-06 19:51:32','773',0.00,0.00,'773','2022-08-07 17:29:19','773','2022-08-07 17:29:58',10,0),('21','238',145,'DAILY','2022-08-04','2022-08-07 17:49:39','2022-08-08 17:49:39','773',7902952.78,7902952.78,'773','2022-08-07 17:57:45','773','2022-08-07 18:22:50',10,0),('21','238',146,'DAILY','2022-08-05','2022-08-08 09:21:04','2022-08-09 09:21:04','773',10126695.99,10126695.99,'773','2022-08-08 09:28:59','773','2022-08-08 09:50:21',10,0),('21','238',147,'DAILY','2022-08-06','2022-08-08 17:04:10','2022-08-09 17:04:10','773',5466473.31,5466473.31,'773','2022-08-08 17:10:16','773','2022-08-08 17:16:57',10,0),('21','238',148,'DAILY','2022-08-07','2022-08-08 17:20:31','2022-08-09 17:20:31','773',5496758.13,5496758.13,'773','2022-08-08 17:28:53','773','2022-08-09 11:33:12',10,0),('21','238',149,'DAILY','2022-08-08','2022-08-09 11:35:39','2022-08-10 11:35:39','773',4407291.25,4407291.25,'773','2022-08-09 11:44:21','773','2022-08-10 17:30:03',10,0),('21','238',150,'DAILY','2022-08-09','2022-08-10 17:31:26','2022-08-11 17:31:26','773',9505463.88,9505463.88,'773','2022-08-10 17:39:24','773','2022-08-10 18:19:32',10,0),('21','238',151,'DAILY','2022-08-10','2022-08-11 16:35:53','2022-08-12 16:35:53','773',6114072.00,6114072.00,'773','2022-08-11 16:42:42','773','2022-08-11 16:44:18',10,0),('21','238',152,'DAILY','2022-08-11','2022-08-12 17:23:47','2022-08-13 17:23:47','773',10872237.85,10872237.85,'773','2022-08-12 17:38:10','773','2022-08-12 17:50:20',10,0),('21','238',153,'MORNING SHIFT ','2022-08-12','2022-08-15 12:43:23','2022-08-16 12:43:23','773',17134.20,17134.20,'773','2022-08-15 12:45:23','773','2022-08-15 12:45:49',10,0),('21','238',154,'EVENING SHIFT (PRICE INCREAMENT)','2022-08-12','2022-08-15 12:48:05','2022-08-16 12:48:05','773',11764034.89,11764034.89,'773','2022-08-15 13:00:10','773','2022-08-15 13:10:24',10,0),('21','238',155,'DAILY','2022-08-13','2022-08-15 13:12:15','2022-08-16 13:12:15','773',4913097.65,4913097.65,'773','2022-08-15 13:32:31','773','2022-08-15 13:52:44',10,0),('21','238',156,'DAILY','2022-08-14','2022-08-15 14:35:10','2022-08-16 14:35:10','773',6875065.10,6875065.10,'773','2022-08-15 14:44:37','773','2022-08-15 19:41:36',10,0),('21','238',157,'DAILY','2022-08-15','2022-08-16 10:17:51','2022-08-17 10:17:51','773',3934226.28,3934226.28,'773','2022-08-16 10:22:28','773','2022-08-16 19:34:48',10,0),('21','238',158,'DAILY','2022-08-16','2022-08-17 10:30:20','2022-08-18 10:30:20','773',8162674.30,8162674.30,'773','2022-08-17 10:37:55','773','2022-08-17 11:04:34',10,0),('21','238',159,'DAILY','2022-08-17','2022-08-18 11:07:55','2022-08-19 11:07:55','773',9172610.90,9172610.90,'773','2022-08-18 11:20:38','773','2022-08-18 19:34:42',10,0),('21','238',160,'DAILY','2022-08-18','2022-08-19 11:21:01','2022-08-20 11:21:01','773',8394332.15,8394332.15,'773','2022-08-19 11:40:15','773','2022-08-19 11:49:52',10,0),('21','238',161,'DAILY','2022-08-19','2022-08-22 15:44:45','2022-08-23 15:44:45','773',7943066.00,7943066.00,'773','2022-08-24 10:13:17','773','2022-08-24 10:32:03',10,0),('21','238',162,'DAILY','2022-08-20','2022-08-24 10:53:33','2022-08-25 10:53:33','773',7337957.44,7337957.44,'773','2022-08-24 12:42:05','773','2022-08-24 12:48:29',10,0),('21','238',163,'DAILY','2022-08-21','2022-08-24 12:50:00','2022-08-25 12:50:00','773',7814503.96,7814503.96,'773','2022-08-24 18:25:36','773','2022-08-24 18:30:58',10,0),('21','238',164,'DAILY','2022-08-22','2022-08-24 18:32:20','2022-08-25 18:32:20','773',8960435.50,8960435.50,'773','2022-08-24 18:36:18','773','2022-08-24 18:44:15',10,0),('21','238',165,'DAILY','2022-08-23','2022-08-24 19:17:49','2022-08-25 19:17:49','773',4858615.52,4858615.52,'773','2022-08-24 19:24:32','773','2022-08-24 19:30:25',10,0),('21','238',166,'DAILY','2022-08-24','2022-08-26 12:02:04','2022-08-27 12:02:04','773',5496500.48,5496500.48,'773','2022-08-26 13:13:04','773','2022-08-26 13:13:35',10,0),('21','238',167,'DAILY','2022-08-25','2022-08-26 13:30:15','2022-08-27 13:30:15','773',7359732.72,7359732.72,'773','2022-08-26 13:35:46','773','2022-08-26 13:36:03',10,0),('21','238',168,'DAILY','2022-08-26','2022-08-29 12:04:00','2022-08-30 12:04:00','773',6633549.02,6633549.02,'773','2022-08-29 12:08:22','773','2022-08-29 12:08:52',10,0),('21','238',169,'DAILY','2022-08-27','2022-08-29 12:32:51','2022-08-30 12:32:51','773',6652850.96,6652850.96,'773','2022-08-29 12:36:21','773','2022-08-29 12:36:35',10,0),('21','238',170,'DAILY','2022-08-28','2022-08-29 12:41:35','2022-08-30 12:41:35','773',7082993.26,7082993.26,'773','2022-08-29 12:46:50','773','2022-08-29 12:47:08',10,0),('21','238',171,'DAILY','2022-08-29','2022-08-30 11:24:50','2022-08-31 11:24:50','773',7589662.26,7589662.26,'773','2022-08-30 11:29:19','773','2022-08-30 11:29:57',10,0),('21','238',172,'DAILY','2022-08-30','2022-08-31 11:08:57','2022-09-01 11:08:57','773',7122988.34,7122988.34,'773','2022-08-31 11:18:57','773','2022-08-31 13:19:20',10,0),('21','238',173,'DAILY','2022-08-31','2022-09-01 11:55:24','2022-09-02 11:55:24','773',8056367.42,8056367.42,'773','2022-09-01 12:01:37','773','2022-09-01 12:22:53',10,0),('21','238',174,'DAILY','2022-09-01','2022-09-02 15:14:21','2022-09-03 15:14:21','773',5696454.96,5696454.96,'773','2022-09-02 15:33:56','773','2022-09-02 15:34:41',10,0),('21','238',175,'DAILY','2022-09-02','2022-09-03 19:40:25','2022-09-04 19:40:25','773',7414172.14,7414172.14,'773','2022-09-03 19:47:42','773','2022-09-03 19:48:08',10,0),('21','238',176,'Daily','2022-09-03','2022-09-04 15:46:59','2022-09-05 15:46:59','773',7762707.10,7762707.10,'773','2022-09-04 15:55:01','773','2022-09-04 15:56:43',10,0),('21','238',177,'Daily','2022-09-04','2022-09-05 11:23:17','2022-09-06 11:23:17','773',9540673.74,9540673.74,'773','2022-09-05 11:32:23','773','2022-09-05 11:32:50',10,0),('21','238',178,'DAILY','2022-09-05','2022-09-06 17:54:03','2022-09-07 17:54:03','773',8420161.40,8420161.40,'773','2022-09-06 17:58:49','773','2022-09-06 17:59:07',10,0),('21','238',179,'DAILY','2022-09-06','2022-09-12 18:56:21','2022-09-13 18:56:21','773',7831048.88,7831048.88,'773','2022-09-12 19:36:37','773','2022-09-12 19:37:09',10,0),('21','238',180,'DAILY','2022-09-07','2022-09-12 20:53:25','2022-09-13 20:53:25','773',4997368.22,4997368.22,'773','2022-09-12 20:56:06','773','2022-09-12 20:56:51',10,0),('21','238',181,'DAILY','2022-09-08','2022-09-12 21:23:35','2022-09-13 21:23:35','773',7429701.22,7429701.22,'773','2022-09-12 21:26:44','773','2022-09-12 21:27:39',10,0),('21','238',182,'DAILY','2022-09-09','2022-09-13 13:35:42','2022-09-14 13:35:42','773',7355496.70,7355496.70,'773','2022-09-13 13:38:29','773','2022-09-13 13:38:49',10,0),('21','238',183,'DAILY','2022-09-10','2022-09-13 18:58:18','2022-09-14 18:58:18','773',8045609.06,8045609.06,'773','2022-09-13 19:08:25','773','2022-09-13 19:08:42',10,0),('21','238',184,'DAILY','2022-09-11','2022-09-13 19:39:38','2022-09-14 19:39:38','773',6898548.26,6898548.26,'773','2022-09-13 19:42:00','773','2022-09-13 19:42:38',10,0),('21','238',185,'DAILY','2022-09-12','2022-09-13 20:32:49','2022-09-14 20:32:49','773',7190522.44,7190522.44,'773','2022-09-14 19:44:48','773','2022-09-14 19:45:22',10,0),('21','238',186,'DAILY','2022-09-13','2022-09-14 20:46:16','2022-09-15 20:46:16','773',2822229.80,2822229.80,'773','2022-09-14 21:47:57','773','2022-09-14 21:48:42',10,0),('21','238',187,'DAILY','2022-09-14','2022-09-15 11:10:21','2022-09-16 11:10:21','773',3114953.40,3114953.40,'773','2022-09-15 11:15:27','773','2022-09-15 11:16:07',10,0),('21','238',188,'DAILY','2022-09-15','2022-09-16 12:50:19','2022-09-17 12:50:19','773',2801349.90,2801349.90,'773','2022-09-16 12:52:19','773','2022-09-16 12:52:35',10,0),('21','238',189,'DAILY','2022-09-16','2022-09-17 12:58:37','2022-09-18 12:58:37','773',2444321.70,2444321.70,'773','2022-09-17 13:05:04','773','2022-09-17 13:06:19',10,0),('21','238',190,'DAILY','2022-09-17','2022-09-18 17:34:39','2022-09-19 17:34:39','773',5989114.62,5989114.62,'773','2022-09-18 17:38:22','773','2022-09-18 17:38:47',10,0),('21','238',191,'Daily','2022-09-18','2022-09-19 18:27:08','2022-09-20 18:27:08','773',8781658.08,8781658.08,'773','2022-09-19 18:32:41','773','2022-09-19 18:33:35',10,0),('21','238',192,'DAILY','2022-09-19','2022-09-20 14:07:14','2022-09-21 14:07:14','773',4174067.36,4174067.36,'773','2022-09-20 14:11:20','773','2022-09-20 14:11:36',10,0),('21','238',193,'DAILY','2022-09-20','2022-09-21 16:52:23','2022-09-22 16:52:23','773',3997690.80,3997690.80,'773','2022-09-21 16:55:07','773','2022-09-21 16:55:35',10,0),('21','238',194,'MORNING SHIFT ','2022-09-21','2022-09-22 12:54:49','2022-09-23 12:54:49','773',1428541.60,1428541.60,'773','2022-09-22 12:56:34','773','2022-09-22 12:58:03',10,0),('21','238',195,'EVENING SHIFT (PRICE DECREAMENT)','2022-09-21','2022-09-22 13:02:00','2022-09-23 13:02:00','773',6222441.17,6222441.17,'773','2022-09-22 13:06:33','773','2022-09-22 13:06:51',10,0),('21','238',196,'DAILY','2022-09-22','2022-09-23 17:24:31','2022-09-24 17:24:31','773',7584531.31,7584531.31,'773','2022-09-23 17:27:08','773','2022-09-23 17:27:43',10,0),('21','238',197,'DAILY','2022-09-23','2022-09-25 12:07:05','2022-09-26 12:07:05','773',2954461.70,2954461.70,'773','2022-09-25 12:12:22','773','2022-09-25 12:12:47',10,0),('21','238',198,'DAILY','2022-09-24','2022-09-25 12:33:56','2022-09-26 12:33:56','773',2163039.90,2163039.90,'773','2022-09-25 12:39:13','773','2022-09-25 12:39:33',10,0),('21','238',199,'DAILY','2022-09-25','2022-09-26 14:38:41','2022-09-27 14:38:41','773',2889036.25,2889036.25,'773','2022-09-26 14:46:45','773','2022-09-26 14:47:27',10,0),('21','238',200,'DAILY','2022-09-26','2022-09-27 16:07:52','2022-09-28 16:07:52','773',4039152.46,4039152.46,'773','2022-09-27 16:12:41','773','2022-09-27 16:13:14',10,0),('21','238',201,'DAILY','2022-09-27','2022-09-28 21:06:20','2022-09-29 21:06:20','773',8210910.50,8210910.50,'773','2022-09-28 21:12:28','773','2022-09-28 21:12:48',10,0),('21','238',202,'DAILY','2022-09-28','2022-09-29 14:07:11','2022-09-30 14:07:11','773',0.00,0.00,'764','2022-09-29 16:23:24','764','2022-09-29 16:24:50',10,0),('21','238',203,'DAILY','2022-09-28','2022-09-29 17:31:46','2022-09-30 17:31:46','773',7531113.50,7531113.50,'773','2022-09-29 17:36:14','773','2022-09-29 17:37:15',10,0),('21','238',204,'DAILY','2022-09-29','2022-10-12 16:16:19','2022-10-13 16:16:19','773',3179850.80,3179850.80,'773','2022-10-12 16:20:45','773','2022-10-12 16:51:26',10,0),('21','238',205,'DAILY','2022-09-29','2022-10-13 07:53:17','2022-10-14 07:53:17','773',3753297.70,3753297.70,'773','2022-10-13 08:31:16','773','2022-10-13 08:31:57',10,0),('21','238',206,'DAILY','2022-10-01','2022-10-13 12:54:14','2022-10-14 12:54:14','773',3734492.40,3734492.40,'773','2022-10-13 13:07:02','773','2022-10-13 13:07:23',10,0),('21','238',207,'DAILY','2022-10-02','2022-10-14 16:24:41','2022-10-15 16:24:41','773',3774896.30,3774896.30,'773','2022-10-14 16:41:01','773','2022-10-14 16:41:32',10,0),('21','238',208,'DAILY','2022-10-03','2022-10-14 17:02:26','2022-10-15 17:02:26','773',3494557.95,3494557.95,'773','2022-10-14 17:07:28','773','2022-10-14 17:07:56',10,0),('21','238',209,'DAILY','2022-10-04','2022-10-14 17:22:50','2022-10-15 17:22:50','773',3360227.00,3360227.00,'773','2022-10-14 17:40:18','773','2022-10-14 17:40:45',10,0),('21','238',210,'DAILY','2022-10-05','2022-10-14 18:58:50','2022-10-15 18:58:50','773',13742939.43,13742939.43,'773','2022-10-14 19:05:06','773','2022-10-14 19:05:31',10,0),('21','238',211,'DAILY','2022-10-06','2022-10-15 20:06:08','2022-10-16 20:06:08','773',13800235.21,13800235.21,'773','2022-10-15 20:11:25','773','2022-10-15 20:11:56',10,0),('21','238',212,'DAILY','2022-10-07','2022-10-15 20:31:48','2022-10-16 20:31:48','773',6729459.37,6729459.37,'773','2022-10-15 20:36:06','773','2022-10-15 20:36:30',10,0),('21','238',213,'DAILY','2022-10-08','2022-10-15 21:07:11','2022-10-16 21:07:11','773',3498479.04,3498479.04,'773','2022-10-15 21:10:26','773','2022-10-15 21:10:46',10,0),('21','238',214,'DAILY','2022-10-09','2022-10-15 21:22:29','2022-10-16 21:22:29','773',4635370.15,4635370.15,'773','2022-10-15 21:29:31','773','2022-10-15 21:30:27',10,0),('21','238',215,'DAILY','2022-10-10','2022-10-16 17:46:16','2022-10-17 17:46:16','773',3314090.71,3314090.71,'773','2022-10-16 17:50:44','773','2022-10-16 17:51:07',10,0),('21','238',216,'DAILY','2022-10-11','2022-10-16 18:01:35','2022-10-17 18:01:35','773',6674198.75,6674198.75,'773','2022-10-16 18:06:11','773','2022-10-16 18:06:45',10,0),('21','238',217,'DAILY','2022-10-12','2022-10-16 19:12:52','2022-10-17 19:12:52','773',5085515.16,5085515.16,'773','2022-10-16 19:19:52','773','2022-10-16 19:20:14',10,0),('21','238',218,'DAILY','2022-10-13','2022-10-16 19:42:57','2022-10-17 19:42:57','773',5084903.39,5084903.39,'773','2022-10-16 19:49:03','773','2022-10-16 19:49:27',10,0),('21','238',219,'DAILY','2022-10-14','2022-10-17 21:15:29','2022-10-18 21:15:29','773',859944.95,859944.95,'773','2022-10-17 21:19:33','773','2022-10-17 21:20:06',10,0),('21','238',220,'DAILY','2022-10-15','2022-10-17 21:38:04','2022-10-18 21:38:04','773',2668295.10,2668295.10,'773','2022-10-17 21:49:09','773','2022-10-17 21:49:56',10,0),('21','238',221,'DAILY','2022-10-16','2022-10-17 22:02:48','2022-10-18 22:02:48','773',5177285.50,5177285.50,'773','2022-10-17 22:14:02','773','2022-10-17 22:14:23',10,0),('21','238',222,'DAILY','2022-10-17','2022-10-18 22:33:53','2022-10-19 22:33:53','773',4571755.49,4571755.49,'773','2022-10-18 22:37:21','773','2022-10-18 22:37:58',10,0),('21','238',223,'DAILY','2022-10-18','2022-10-20 19:01:11','2022-10-21 19:01:11','773',7571267.53,7571267.53,'773','2022-10-20 19:06:40','773','2022-10-20 19:07:13',10,0),('21','238',224,'DAILY','2022-10-19','2022-10-20 19:47:01','2022-10-21 19:47:01','773',7362614.93,7362614.93,'773','2022-10-20 19:53:26','773','2022-10-20 19:53:45',10,0),('21','238',225,'DAILY','2022-10-20','2022-10-24 16:32:40','2022-10-25 16:32:40','773',4195973.39,4195973.39,'773','2022-10-24 16:36:30','773','2022-10-24 16:37:24',10,0),('21','238',226,'DAILY','2022-10-21','2022-10-24 16:44:25','2022-10-25 16:44:25','773',2287265.74,2287265.74,'773','2022-10-24 16:57:00','773','2022-10-24 16:57:28',10,0),('21','238',227,'DAILY','2022-10-22','2022-10-24 17:24:23','2022-10-25 17:24:23','773',6290038.40,6290038.40,'773','2022-10-24 17:26:08','773','2022-10-24 17:26:36',10,0),('21','238',228,'DAILY','2022-10-23','2022-10-24 17:40:51','2022-10-25 17:40:51','773',6756845.54,6756845.54,'773','2022-10-24 17:46:36','773','2022-10-24 17:46:59',10,0),('21','238',229,'DAILY','2022-10-25','2022-10-27 09:23:22','2022-10-28 09:23:22','773',4735646.04,4735646.04,'773','2022-10-27 09:27:02','773','2022-10-27 09:28:01',10,0),('21','238',230,'DAILY','2022-10-25','2022-10-27 09:41:03','2022-10-28 09:41:03','773',5133611.12,5133611.12,'773','2022-10-27 09:58:04','773','2022-10-27 09:58:37',10,0),('21','238',231,'DAILY','2022-10-26','2022-10-31 16:27:39','2022-11-01 16:27:39','773',11811654.52,11811654.52,'773','2022-10-31 16:33:17','773','2022-10-31 17:12:21',10,0),('21','238',232,'DAILY','2022-10-27','2022-10-31 17:20:22','2022-11-01 17:20:22','773',4831048.64,4831048.64,'773','2022-10-31 17:22:32','773','2022-10-31 17:37:31',10,0),('21','238',233,'DAILY','2022-10-28','2022-11-01 12:06:59','2022-11-02 12:06:59','773',2844302.46,2844302.46,'773','2022-11-01 12:10:15','773','2022-11-01 12:19:31',10,0),('21','238',234,'DAILY','2022-10-29','2022-11-01 12:20:57','2022-11-02 12:20:57','773',47899.24,47899.24,'773','2022-11-01 12:25:01','773','2022-11-01 12:33:09',10,0),('21','238',235,'DAILY','2022-10-30','2022-11-01 14:10:01','2022-11-02 14:10:01','773',2122964.76,2122964.76,'773','2022-11-01 14:16:08','773','2022-11-02 12:51:39',10,0),('21','238',236,'DAILY','2022-10-31','2022-11-02 12:52:44','2022-11-03 12:52:44','773',3257921.68,3257921.68,'773','2022-11-02 13:09:30','773','2022-11-02 13:24:44',10,0),('21','238',237,'DAILY','2022-11-01','2022-11-02 14:24:46','2022-11-03 14:24:46','773',6795018.02,6795018.02,'773','2022-11-02 14:34:19','773','2022-11-02 14:54:23',10,0),('21','238',238,'DAILY','2022-11-02','2022-11-03 13:26:52','2022-11-04 13:26:52','773',6293639.96,6293639.96,'773','2022-11-03 13:28:41','773','2022-11-03 13:44:41',10,0),('21','238',239,'DAILY','2022-11-03','2022-11-04 14:51:37','2022-11-05 14:51:37','773',2675530.30,2675530.30,'773','2022-11-04 15:00:17','773','2022-11-04 15:13:43',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=2391 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('21','238','1','1',1,'1','1',5629590.26,5629590.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','1',2,'2','1',4820504.65,4820504.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','1',3,'5','1',2005659.00,2005659.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','1',4,'6','1',4929852.25,4930003.15,150.90,24898.50,0.00,0.00,0.00,0.00,0.00),('21','238','3','1',5,'9','1',4634661.58,4634661.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','1',6,'11','1',5538447.96,5538447.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','1',7,'13','2',2195853.74,2197669.60,1815.86,1267470.28,0.00,0.00,0.00,0.00,0.00),('21','238','5','1',8,'15','2',174850.57,176437.18,1586.61,1107453.78,0.00,0.00,0.00,0.00,0.00),('21','238','5','1',9,'16','2',116206.22,119377.46,3171.24,2213525.52,0.00,0.00,0.00,0.00,0.00),('21','238','6','1',10,'17','3',574504.47,574671.18,166.71,91690.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','2',11,'1','1',5629590.26,5629590.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','2',12,'2','1',4820504.65,4820504.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','2',13,'5','1',2005659.00,2005659.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','2',14,'6','1',4930003.15,4930003.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','2',15,'9','1',4634661.58,4634661.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','2',16,'11','1',5538447.96,5538447.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','2',17,'13','2',2197669.60,2197669.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','2',18,'15','2',176437.18,176437.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','2',19,'16','2',119377.46,119377.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','2',20,'17','3',574671.18,574671.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','3',21,'1','1',5629751.56,5629751.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','3',22,'2','1',4820709.73,4820709.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','3',23,'5','1',2040444.49,2050312.69,9838.20,1623303.00,0.00,0.00,30.00,0.00,0.00),('21','238','2','3',24,'6','1',4975429.58,4978660.83,3211.25,529856.25,0.00,0.00,20.00,0.00,0.00),('21','238','3','3',25,'9','1',4660256.58,4670894.23,10588.93,1747173.45,0.00,0.00,48.72,0.00,0.00),('21','238','3','3',26,'11','1',5546379.70,5548880.86,2481.16,409391.40,0.00,0.00,20.00,0.00,0.00),('21','238','4','3',27,'13','2',2231542.72,2238418.58,6875.86,4799350.28,0.00,0.00,0.00,0.00,0.00),('21','238','5','3',28,'15','2',195742.24,198201.22,2458.98,1716368.04,0.00,0.00,0.00,0.00,0.00),('21','238','5','3',29,'16','2',128874.60,129479.76,605.16,422401.68,0.00,0.00,0.00,0.00,0.00),('21','238','6','3',30,'17','3',576550.03,576801.68,251.65,138407.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','4',31,'1','1',5629751.56,5629751.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','4',32,'2','1',4820709.73,4820709.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','4',33,'5','1',2050312.69,2055352.87,5040.18,831629.70,0.00,0.00,0.00,0.00,0.00),('21','238','2','4',34,'6','1',4978660.83,4981831.62,3170.79,523180.35,0.00,0.00,0.00,0.00,0.00),('21','238','3','4',35,'9','1',4670894.23,4674756.85,3862.62,637332.30,0.00,0.00,0.00,0.00,0.00),('21','238','3','4',36,'11','1',5548880.86,5550276.18,1395.32,230227.80,0.00,0.00,0.00,0.00,0.00),('21','238','4','4',37,'13','2',2238418.58,2243903.40,5484.82,3828404.36,0.00,0.00,0.00,0.00,0.00),('21','238','5','4',38,'15','2',198201.22,203194.16,4992.94,3485072.12,0.00,0.00,0.00,0.00,0.00),('21','238','5','4',39,'16','2',129479.76,130153.95,674.19,470584.62,0.00,0.00,0.00,0.00,0.00),('21','238','6','4',40,'17','3',576801.68,577245.78,444.10,244255.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','5',41,'1','1',5629751.56,5629751.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','5',42,'2','1',4820709.73,4820709.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','5',43,'5','1',2055352.87,2055352.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','5',44,'6','1',4981831.62,4982168.94,337.32,55657.80,0.00,0.00,0.00,0.00,0.00),('21','238','3','5',45,'9','1',4674756.85,4674756.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','5',46,'11','1',5550276.18,5550276.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','5',47,'13','2',2243903.40,2246071.46,2168.06,1513305.88,0.00,0.00,0.00,0.00,0.00),('21','238','5','5',48,'15','2',203194.16,205133.47,1939.31,1353638.38,0.00,0.00,0.00,0.00,0.00),('21','238','5','5',49,'16','2',130153.95,130749.55,595.60,415728.80,0.00,0.00,0.00,0.00,0.00),('21','238','6','5',50,'17','3',577245.78,577764.94,519.16,285538.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','6',51,'1','1',5629751.56,5629751.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','6',52,'2','1',4820709.73,4820709.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','6',53,'5','1',2055352.87,2059473.92,4121.05,679973.25,0.00,0.00,0.00,0.00,0.00),('21','238','2','6',54,'6','1',4982168.94,4987055.80,4886.86,806331.90,0.00,0.00,0.00,0.00,0.00),('21','238','3','6',55,'9','1',4674756.85,4677994.60,3237.75,534228.75,0.00,0.00,0.00,0.00,0.00),('21','238','3','6',56,'11','1',5550276.18,5551718.16,1441.98,237926.70,0.00,0.00,0.00,0.00,0.00),('21','238','4','6',57,'13','2',2246071.46,2249568.60,3497.14,2441003.72,0.00,0.00,0.00,0.00,0.00),('21','238','5','6',58,'15','2',205133.47,206383.19,1249.72,872304.56,0.00,0.00,0.00,0.00,0.00),('21','238','5','6',59,'16','2',130749.55,131250.08,500.53,349369.94,0.00,0.00,0.00,0.00,0.00),('21','238','6','6',60,'17','3',577764.94,578144.19,379.25,208587.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','7',61,'1','1',5629751.56,5629751.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','7',62,'2','1',4820709.73,4820709.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','7',63,'5','1',2059473.92,2064925.99,5432.07,896291.55,0.00,0.00,20.00,0.00,0.00),('21','238','2','7',64,'6','1',4987055.80,4992177.81,5102.01,841831.65,0.00,0.00,20.00,0.00,0.00),('21','238','3','7',65,'9','1',4677994.60,4682785.85,4761.25,785606.25,0.00,0.00,30.00,0.00,0.00),('21','238','3','7',66,'11','1',5551718.16,5552046.34,308.18,50849.70,0.00,0.00,20.00,0.00,0.00),('21','238','4','7',67,'13','2',2249568.60,2251882.49,2313.89,1615095.22,0.00,0.00,0.00,0.00,0.00),('21','238','5','7',68,'15','2',206383.19,209084.22,2701.03,1885318.94,0.00,0.00,0.00,0.00,0.00),('21','238','5','7',69,'16','2',131250.08,132470.05,1219.97,851539.06,0.00,0.00,0.00,0.00,0.00),('21','238','6','7',70,'17','3',578144.19,578409.32,254.30,139865.00,0.00,0.00,10.83,0.00,0.00),('21','238','1','8',71,'1','1',5629751.56,5629751.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','8',72,'2','1',4820709.73,4820709.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','8',73,'5','1',2064925.99,2070983.85,6057.86,999546.90,0.00,0.00,0.00,0.00,0.00),('21','238','2','8',74,'6','1',4992177.81,4998263.97,6086.16,1004216.40,0.00,0.00,0.00,0.00,0.00),('21','238','3','8',75,'9','1',4682785.85,4686832.65,4046.80,667722.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','8',76,'11','1',5552046.34,5552120.26,73.92,12196.80,0.00,0.00,0.00,0.00,0.00),('21','238','4','8',77,'13','2',2251882.49,2255018.41,3135.92,2188872.16,0.00,0.00,0.00,0.00,0.00),('21','238','5','8',78,'15','2',209084.22,209560.36,476.14,332345.72,0.00,0.00,0.00,0.00,0.00),('21','238','5','8',79,'16','2',132470.05,137055.65,4585.60,3200748.80,0.00,0.00,0.00,0.00,0.00),('21','238','6','8',80,'17','3',578409.32,578614.12,204.80,112640.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','9',81,'1','1',5629751.56,5629751.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','9',82,'2','1',4820709.73,4820709.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','9',83,'5','1',2070983.85,2079753.33,8769.48,1446964.20,0.00,0.00,0.00,0.00,0.00),('21','238','2','9',84,'6','1',4998263.97,5004624.41,6350.44,1047822.60,0.00,0.00,10.00,0.00,0.00),('21','238','3','9',85,'9','1',4686832.65,4699881.78,13028.19,2149651.35,0.00,0.00,20.94,0.00,0.00),('21','238','3','9',86,'11','1',5552120.26,5554022.85,1892.59,312277.35,0.00,0.00,10.00,0.00,0.00),('21','238','4','9',87,'13','2',2255018.41,2259319.19,4300.78,3001944.44,0.00,0.00,0.00,0.00,0.00),('21','238','5','9',88,'15','2',209560.36,212235.68,2675.32,1867373.36,0.00,0.00,0.00,0.00,0.00),('21','238','5','9',89,'16','2',137055.65,137450.32,394.67,275479.66,0.00,0.00,0.00,0.00,0.00),('21','238','6','9',90,'17','3',578614.12,578817.23,203.11,111710.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','10',91,'1','1',5629751.56,5629751.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','10',92,'2','1',4820709.73,4820709.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','10',93,'5','1',2079753.33,2086927.40,7174.07,1183721.55,0.00,0.00,0.00,0.00,0.00),('21','238','2','10',94,'6','1',5004624.41,5011318.71,6694.30,1104559.50,0.00,0.00,0.00,0.00,0.00),('21','238','3','10',95,'9','1',4699881.78,4712188.78,12307.00,2030655.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','10',96,'11','1',5554022.85,5555111.23,1088.38,179582.70,0.00,0.00,0.00,0.00,0.00),('21','238','4','10',97,'13','2',2259319.19,2261308.23,1989.04,1388349.92,0.00,0.00,0.00,0.00,0.00),('21','238','5','10',98,'15','2',212235.68,214519.37,2283.69,1594015.62,0.00,0.00,0.00,0.00,0.00),('21','238','5','10',99,'16','2',137450.32,139123.26,1672.94,1167712.12,0.00,0.00,0.00,0.00,0.00),('21','238','6','10',100,'17','3',578817.23,578912.56,95.33,52431.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','11',101,'1','1',5629751.56,5629751.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','11',102,'2','1',4820709.73,4820709.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','11',103,'5','1',2086927.40,2091691.43,4764.03,786064.95,0.00,0.00,0.00,0.00,0.00),('21','238','2','11',104,'6','1',5011318.71,5015885.93,4567.22,753591.30,0.00,0.00,0.00,0.00,0.00),('21','238','3','11',105,'9','1',4712188.78,4719610.44,7421.66,1224573.90,0.00,0.00,0.00,0.00,0.00),('21','238','3','11',106,'11','1',5555111.23,5555402.61,258.35,42627.75,0.00,0.00,33.03,0.00,0.00),('21','238','4','11',107,'13','2',2261308.23,2264403.76,3095.53,2160679.94,0.00,0.00,0.00,0.00,0.00),('21','238','5','11',108,'15','2',214519.37,216591.83,2072.46,1446577.08,0.00,0.00,0.00,0.00,0.00),('21','238','5','11',109,'16','2',139123.26,141112.06,1988.80,1388182.40,0.00,0.00,0.00,0.00,0.00),('21','238','6','11',110,'17','3',578912.56,579031.30,118.74,65307.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','12',111,'1','1',5629751.56,5629751.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','12',112,'2','1',4820709.73,4820709.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','12',113,'5','1',2091691.43,2096258.77,4537.34,748661.10,0.00,0.00,30.00,0.00,0.00),('21','238','2','12',114,'6','1',5015885.93,5022204.52,6288.59,1037617.35,0.00,0.00,30.00,0.00,0.00),('21','238','3','12',115,'9','1',4719610.44,4724964.60,5324.16,878486.40,0.00,0.00,30.00,0.00,0.00),('21','238','3','12',116,'11','1',5555402.61,5555402.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','12',117,'13','2',2264403.76,2267694.02,3290.26,2296601.48,0.00,0.00,0.00,0.00,0.00),('21','238','5','12',118,'15','2',216591.83,217135.68,543.85,379607.30,0.00,0.00,0.00,0.00,0.00),('21','238','5','12',119,'16','2',141112.06,142523.88,1411.82,985450.36,0.00,0.00,0.00,0.00,0.00),('21','238','6','12',120,'17','3',579031.30,579214.13,162.83,89556.50,0.00,0.00,20.00,0.00,0.00),('21','238','1','13',121,'1','1',5629751.56,5629751.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','13',122,'2','1',4820709.73,4820709.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','13',123,'5','1',2096258.77,2102019.51,5760.74,950522.10,0.00,0.00,0.00,0.00,0.00),('21','238','2','13',124,'6','1',5022204.52,5026561.13,4356.61,718840.65,0.00,0.00,0.00,0.00,0.00),('21','238','3','13',125,'9','1',4724964.60,4728964.05,3999.45,659909.25,0.00,0.00,0.00,0.00,0.00),('21','238','3','13',126,'11','1',5555402.61,5555628.99,226.38,37352.70,0.00,0.00,0.00,0.00,0.00),('21','238','4','13',127,'13','2',2267694.02,2270454.04,2760.02,1926493.96,0.00,0.00,0.00,0.00,0.00),('21','238','5','13',128,'15','2',217135.68,219043.23,1907.55,1331469.90,0.00,0.00,0.00,0.00,0.00),('21','238','5','13',129,'16','2',142523.88,144242.21,1718.33,1199394.34,0.00,0.00,0.00,0.00,0.00),('21','238','6','13',130,'17','3',579214.13,579355.09,140.96,77528.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','14',131,'1','1',5629751.56,5629751.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','14',132,'2','1',4820709.73,4820709.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','14',133,'5','1',2102019.51,2102019.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','14',134,'6','1',5026561.13,5026561.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','14',135,'9','1',4728964.05,4728964.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','14',136,'11','1',5555628.99,5555628.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','14',137,'13','2',2270454.04,2273733.55,3279.51,2289097.98,0.00,0.00,0.00,0.00,0.00),('21','238','5','14',138,'15','2',219043.23,220869.15,1825.92,1274492.16,0.00,0.00,0.00,0.00,0.00),('21','238','5','14',139,'16','2',144242.21,147028.17,2785.96,1944600.08,0.00,0.00,0.00,0.00,0.00),('21','238','6','14',140,'17','3',579355.09,579429.26,74.17,40793.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','15',141,'1','1',5629751.56,5629751.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','15',142,'2','1',4820709.73,4820709.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','15',143,'5','1',2102019.51,2102019.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','15',144,'6','1',5026561.13,5026561.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','15',145,'9','1',4728964.05,4728964.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','15',146,'11','1',5555628.99,5555628.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','15',147,'13','2',2273733.55,2275248.34,1514.79,1057323.42,0.00,0.00,0.00,0.00,0.00),('21','238','5','15',148,'15','2',220869.15,222256.58,1387.43,968426.14,0.00,0.00,0.00,0.00,0.00),('21','238','5','15',149,'16','2',147028.17,147246.22,218.05,152198.90,0.00,0.00,0.00,0.00,0.00),('21','238','6','15',150,'17','3',579429.26,579429.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','16',151,'1','1',5629751.56,5629751.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','16',152,'2','1',4820709.73,4820709.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','16',153,'5','1',2102019.51,2102019.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','16',154,'6','1',5026561.13,5026561.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','16',155,'9','1',4728964.05,4728964.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','16',156,'11','1',5555628.99,5555628.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','16',157,'13','2',2275248.34,2275248.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','16',158,'15','2',222256.58,222256.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','16',159,'16','2',147246.22,147246.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','16',160,'17','3',579429.26,579429.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','17',161,'1','1',5629751.56,5629751.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','17',162,'2','1',4820709.73,4820709.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','17',163,'5','1',2102019.51,2108085.35,6065.84,1000863.60,0.00,0.00,0.00,0.00,0.00),('21','238','2','17',164,'6','1',5026561.13,5032323.31,5762.18,950759.70,0.00,0.00,0.00,0.00,0.00),('21','238','3','17',165,'9','1',4728964.05,4733750.80,4786.75,789813.75,0.00,0.00,0.00,0.00,0.00),('21','238','3','17',166,'11','1',5555628.99,5556227.02,598.03,98674.95,0.00,0.00,0.00,0.00,0.00),('21','238','4','17',167,'13','2',2275248.34,2279600.82,4352.48,2950981.44,0.00,0.00,0.00,0.00,0.00),('21','238','5','17',168,'15','2',222256.58,222256.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','17',169,'16','2',147246.22,147246.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','17',170,'17','3',579429.26,579532.77,103.51,56930.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','18',171,'1','1',5629751.56,5629751.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','18',172,'2','1',4820709.73,4820709.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','18',173,'5','1',2108085.35,2112976.90,4891.55,807105.75,0.00,0.00,0.00,0.00,0.00),('21','238','2','18',174,'6','1',5032323.31,5036826.67,4503.36,743054.40,0.00,0.00,0.00,0.00,0.00),('21','238','3','18',175,'9','1',4733750.80,4738504.24,4753.44,784317.60,0.00,0.00,0.00,0.00,0.00),('21','238','3','18',176,'11','1',5556227.02,5556945.01,717.99,118468.35,0.00,0.00,0.00,0.00,0.00),('21','238','4','18',177,'13','2',2279600.82,2285494.49,5893.67,3995908.26,0.00,0.00,0.00,0.00,0.00),('21','238','5','18',178,'15','2',222256.58,222256.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','18',179,'16','2',147246.22,147246.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','18',180,'17','3',579532.77,579617.49,84.72,46596.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','19',181,'1','1',5629751.56,5629751.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','19',182,'2','1',4820709.73,4820709.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','19',183,'5','1',2112976.90,2116215.34,3218.44,531042.60,0.00,0.00,20.00,0.00,0.00),('21','238','2','19',184,'6','1',5036826.67,5041743.68,4897.01,808006.65,0.00,0.00,20.00,0.00,0.00),('21','238','3','19',185,'9','1',4738504.24,4742092.96,3568.72,588838.80,0.00,0.00,20.00,0.00,0.00),('21','238','3','19',186,'11','1',5556945.01,5557575.77,610.76,100775.40,0.00,0.00,20.00,0.00,0.00),('21','238','4','19',187,'13','2',2285494.49,2289642.61,4148.12,2812425.36,0.00,0.00,0.00,0.00,0.00),('21','238','5','19',188,'15','2',222256.58,224634.67,2378.09,1612345.02,0.00,0.00,0.00,0.00,0.00),('21','238','5','19',189,'16','2',147246.22,150329.28,3083.06,2090314.68,0.00,0.00,0.00,0.00,0.00),('21','238','6','19',190,'17','3',579617.49,579741.93,124.44,68442.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','20',191,'1','1',5629751.56,5629751.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','20',192,'2','1',4820709.73,4820709.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','20',193,'5','1',2116215.34,2120645.08,4409.74,727607.10,0.00,0.00,20.00,0.00,0.00),('21','238','2','20',194,'6','1',5041743.68,5046858.44,5104.76,842285.40,0.00,0.00,10.00,0.00,0.00),('21','238','3','20',195,'9','1',4742092.96,4746002.32,3899.36,643394.40,0.00,0.00,10.00,0.00,0.00),('21','238','3','20',196,'11','1',5557575.77,5559110.12,1514.35,249867.75,0.00,0.00,20.00,0.00,0.00),('21','238','4','20',197,'13','2',2289642.61,2293404.94,3762.33,2550859.74,0.00,0.00,0.00,0.00,0.00),('21','238','5','20',198,'15','2',224634.67,227775.01,3140.34,2129150.52,0.00,0.00,0.00,0.00,0.00),('21','238','5','20',199,'16','2',150329.28,151331.84,1002.56,679735.68,0.00,0.00,0.00,0.00,0.00),('21','238','6','20',200,'17','3',579741.93,579941.71,199.78,109879.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','21',201,'1','1',5629751.56,5629751.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','21',202,'2','1',4820709.73,4820709.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','21',203,'5','1',2120645.08,2120645.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','21',204,'6','1',5046858.44,5046858.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','21',205,'9','1',4746002.32,4746002.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','21',206,'11','1',5559110.12,5559110.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','21',207,'13','2',2293404.94,2296364.04,2959.10,2006269.80,0.00,0.00,0.00,0.00,0.00),('21','238','5','21',208,'15','2',227775.01,229954.50,2179.49,1477694.22,0.00,0.00,0.00,0.00,0.00),('21','238','5','21',209,'16','2',151331.84,151990.07,658.23,446279.94,0.00,0.00,0.00,0.00,0.00),('21','238','6','21',210,'17','3',579941.71,580084.98,143.27,78798.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','22',211,'1','1',5629751.56,5629751.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','22',212,'2','1',4820709.73,4820709.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','22',213,'5','1',2120645.08,2125456.56,4801.48,792244.20,0.00,0.00,10.00,0.00,0.00),('21','238','2','22',214,'6','1',5046858.44,5053578.28,6699.84,1105473.60,0.00,0.00,20.00,0.00,0.00),('21','238','3','22',215,'9','1',4746002.32,4748893.56,2871.24,473754.60,0.00,0.00,20.00,0.00,0.00),('21','238','3','22',216,'11','1',5559110.12,5559588.72,468.60,77319.00,0.00,0.00,10.00,0.00,0.00),('21','238','4','22',217,'13','2',2296364.04,2300423.27,4059.23,2752157.94,0.00,0.00,0.00,0.00,0.00),('21','238','5','22',218,'15','2',229954.50,232252.79,2298.29,1558240.62,0.00,0.00,0.00,0.00,0.00),('21','238','5','22',219,'16','2',151990.07,152715.79,725.72,492038.16,0.00,0.00,0.00,0.00,0.00),('21','238','6','22',220,'17','3',580084.98,580218.15,133.17,73243.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','23',221,'1','1',5629751.56,5629751.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','23',222,'2','1',4820709.73,4820709.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','23',223,'5','1',2125456.56,2133215.01,7738.45,1276844.25,0.00,0.00,20.00,0.00,0.00),('21','238','2','23',224,'6','1',5053578.28,5059445.03,5856.75,966363.75,0.00,0.00,10.00,0.00,0.00),('21','238','3','23',225,'9','1',4748893.56,4756750.73,7847.17,1294783.05,0.00,0.00,10.00,0.00,0.00),('21','238','3','23',226,'11','1',5559588.72,5560312.44,713.72,117763.80,0.00,0.00,10.00,0.00,0.00),('21','238','4','23',227,'13','2',2300423.27,2309542.53,9119.26,6182858.28,0.00,0.00,0.00,0.00,0.00),('21','238','5','23',228,'15','2',232252.79,235387.31,3134.52,2125204.56,0.00,0.00,0.00,0.00,0.00),('21','238','5','23',229,'16','2',152715.79,152826.35,110.56,74959.68,0.00,0.00,0.00,0.00,0.00),('21','238','6','23',230,'17','3',580218.15,580337.45,109.30,60115.00,0.00,0.00,10.00,0.00,0.00),('21','238','1','24',231,'1','1',5629751.56,5629751.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','24',232,'2','1',4820709.73,4820709.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','24',233,'5','1',2133215.01,2133215.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','24',234,'6','1',5059445.03,5059445.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','24',235,'9','1',4756750.73,4756750.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','24',236,'11','1',5560312.44,5560312.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','24',237,'13','2',2309542.53,2309879.18,336.65,228248.70,0.00,0.00,0.00,0.00,0.00),('21','238','5','24',238,'15','2',235387.31,235589.95,202.64,137389.92,0.00,0.00,0.00,0.00,0.00),('21','238','5','24',239,'16','2',152826.35,152851.52,25.17,17065.26,0.00,0.00,0.00,0.00,0.00),('21','238','6','24',240,'17','3',580337.45,580337.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','25',241,'1','1',5629751.56,5629751.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','25',242,'2','1',4820709.73,4820709.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','25',243,'5','1',2133215.01,2133323.62,108.61,17920.65,0.00,0.00,0.00,0.00,0.00),('21','238','2','25',244,'6','1',5059445.03,5060596.43,1151.40,189981.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','25',245,'9','1',4756750.73,4761349.22,4598.49,758750.85,0.00,0.00,0.00,0.00,0.00),('21','238','3','25',246,'11','1',5560312.44,5562399.01,2086.57,344284.05,0.00,0.00,0.00,0.00,0.00),('21','238','4','25',247,'13','2',2309879.18,2313049.21,3170.03,2101729.89,0.00,0.00,0.00,0.00,0.00),('21','238','5','25',248,'15','2',235589.95,236736.96,1147.01,760467.63,0.00,0.00,0.00,0.00,0.00),('21','238','5','25',249,'16','2',152851.52,153350.02,498.50,330505.50,0.00,0.00,0.00,0.00,0.00),('21','238','6','25',250,'17','3',580337.45,580604.53,267.08,146894.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','26',251,'1','1',5629751.56,5629751.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','26',252,'2','1',4820709.73,4820709.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','26',253,'5','1',2133323.62,2135806.10,2482.48,409609.20,0.00,0.00,0.00,0.00,0.00),('21','238','2','26',254,'6','1',5060596.43,5063492.84,2896.41,477907.65,0.00,0.00,0.00,0.00,0.00),('21','238','3','26',255,'9','1',4761349.22,4761636.90,287.68,47467.20,0.00,0.00,0.00,0.00,0.00),('21','238','3','26',256,'11','1',5562399.01,5562399.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','26',257,'13','2',2313049.21,2316642.67,3593.46,2382463.98,0.00,0.00,0.00,0.00,0.00),('21','238','5','26',258,'15','2',236736.96,238843.11,2106.15,1396377.45,0.00,0.00,0.00,0.00,0.00),('21','238','5','26',259,'16','2',153350.02,153788.69,438.67,290838.21,0.00,0.00,0.00,0.00,0.00),('21','238','6','26',260,'17','3',580604.53,580823.08,218.55,120202.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','27',261,'1','1',5629751.56,5629751.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','27',262,'2','1',4820709.73,4820709.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','27',263,'5','1',2135806.10,2144003.02,8156.92,1345891.80,0.00,0.00,40.00,0.00,0.00),('21','238','2','27',264,'6','1',5063492.84,5072274.98,8742.14,1442453.10,0.00,0.00,40.00,0.00,0.00),('21','238','3','27',265,'9','1',4761636.90,4770332.87,8655.97,1428235.05,0.00,0.00,40.00,0.00,0.00),('21','238','3','27',266,'11','1',5562399.01,5562399.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','27',267,'13','2',2316642.67,2320625.35,3982.68,2640516.84,0.00,0.00,0.00,0.00,0.00),('21','238','5','27',268,'15','2',238843.11,242759.99,3916.88,2596891.44,0.00,0.00,0.00,0.00,0.00),('21','238','5','27',269,'16','2',153788.69,154828.47,1039.78,689374.14,0.00,0.00,0.00,0.00,0.00),('21','238','6','27',270,'17','3',580823.08,580914.01,70.93,39011.50,0.00,0.00,20.00,0.00,0.00),('21','238','1','28',271,'1','1',5629751.56,5629751.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','28',272,'2','1',4820709.73,4820709.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','28',273,'5','1',2144003.02,2149759.10,5746.08,948103.20,0.00,0.00,10.00,0.00,0.00),('21','238','2','28',274,'6','1',5072274.98,5074495.84,2210.86,364791.90,0.00,0.00,10.00,0.00,0.00),('21','238','3','28',275,'9','1',4770332.87,4774923.85,4580.98,755861.70,0.00,0.00,10.00,0.00,0.00),('21','238','3','28',276,'11','1',5562399.01,5564208.66,1799.65,296942.25,0.00,0.00,10.00,0.00,0.00),('21','238','4','28',277,'13','2',2320625.35,2325848.36,5223.01,3462855.63,0.00,0.00,0.00,0.00,0.00),('21','238','5','28',278,'15','2',242759.99,245001.88,2241.89,1486373.07,0.00,0.00,0.00,0.00,0.00),('21','238','5','28',279,'16','2',154828.47,156292.47,1464.00,970632.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','28',280,'17','3',580914.01,581095.42,171.29,94209.50,0.00,0.00,10.12,0.00,0.00),('21','238','1','29',281,'1','1',5629751.56,5629751.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','29',282,'2','1',4820709.73,4820709.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','29',283,'5','1',2149759.10,2156639.10,6880.00,1135200.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','29',284,'6','1',5074495.84,5082778.35,8282.51,1366614.15,0.00,0.00,0.00,0.00,0.00),('21','238','3','29',285,'9','1',4774923.85,4774923.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','29',286,'11','1',5564208.66,5564208.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','29',287,'13','2',2325848.36,2330140.73,4292.37,2845841.31,0.00,0.00,0.00,0.00,0.00),('21','238','5','29',288,'15','2',245001.88,247545.06,2543.18,1686128.34,0.00,0.00,0.00,0.00,0.00),('21','238','5','29',289,'16','2',156292.47,156302.13,9.66,6404.58,0.00,0.00,0.00,0.00,0.00),('21','238','6','29',290,'17','3',581095.42,581263.06,167.64,92202.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','30',291,'1','1',5629751.56,5629751.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','30',292,'2','1',4820709.73,4820709.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','30',293,'5','1',2156639.10,2161977.42,5308.32,875872.80,0.00,0.00,30.00,0.00,0.00),('21','238','2','30',294,'6','1',5082778.35,5087903.05,5104.70,842275.50,0.00,0.00,20.00,0.00,0.00),('21','238','3','30',295,'9','1',4774923.85,4779385.31,4441.46,732840.90,0.00,0.00,20.00,0.00,0.00),('21','238','3','30',296,'11','1',5564208.66,5566395.96,2157.30,355954.50,0.00,0.00,30.00,0.00,0.00),('21','238','4','30',297,'13','2',2330140.73,2334385.51,4244.78,2814289.14,0.00,0.00,0.00,0.00,0.00),('21','238','5','30',298,'15','2',247545.06,249569.23,2024.17,1342024.71,0.00,0.00,0.00,0.00,0.00),('21','238','5','30',299,'16','2',156302.13,156825.72,523.59,347140.17,0.00,0.00,0.00,0.00,0.00),('21','238','6','30',300,'17','3',581263.06,581513.12,250.06,137533.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','31',301,'1','1',5629751.56,5629751.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','31',302,'2','1',4820709.73,4820709.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','31',303,'5','1',2161977.42,2168255.47,6278.05,1035878.25,0.00,0.00,0.00,0.00,0.00),('21','238','2','31',304,'6','1',5087903.05,5095134.53,7231.48,1193194.20,0.00,0.00,0.00,0.00,0.00),('21','238','3','31',305,'9','1',4779385.31,4781020.44,1635.13,269796.45,0.00,0.00,0.00,0.00,0.00),('21','238','3','31',306,'11','1',5566395.96,5566602.05,206.09,34004.85,0.00,0.00,0.00,0.00,0.00),('21','238','4','31',307,'13','2',2334385.51,2339485.91,5100.40,3381565.20,0.00,0.00,0.00,0.00,0.00),('21','238','5','31',308,'15','2',249569.23,251392.23,1823.00,1208649.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','31',309,'16','2',156825.72,158069.61,1243.89,824699.07,0.00,0.00,0.00,0.00,0.00),('21','238','6','31',310,'17','3',581513.12,581844.04,330.92,182006.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','32',311,'1','1',5629751.56,5629751.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','32',312,'2','1',4820709.73,4820709.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','32',313,'5','1',2168255.47,2168255.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','32',314,'6','1',5095134.53,5095134.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','32',315,'9','1',4781020.44,4781020.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','32',316,'11','1',5566602.05,5566602.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','32',317,'13','2',2339485.91,2345663.10,6177.19,4095476.97,0.00,0.00,0.00,0.00,0.00),('21','238','5','32',318,'15','2',251392.23,252491.02,1098.79,728497.77,0.00,0.00,0.00,0.00,0.00),('21','238','5','32',319,'16','2',158069.61,159915.31,1845.70,1223699.10,0.00,0.00,0.00,0.00,0.00),('21','238','6','32',320,'17','3',581844.04,581987.24,143.20,78760.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','33',321,'1','1',5629751.56,5629751.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','33',322,'2','1',4820709.73,4820709.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','33',323,'5','1',2168255.47,2176184.16,7878.69,1299983.85,0.00,0.00,50.00,0.00,0.00),('21','238','2','33',324,'6','1',5095134.53,5102366.97,7192.44,1186752.60,0.00,0.00,40.00,0.00,0.00),('21','238','3','33',325,'9','1',4781020.44,4793379.17,12318.73,2032590.45,0.00,0.00,40.00,0.00,0.00),('21','238','3','33',326,'11','1',5566602.05,5568855.46,2202.53,363417.45,0.00,0.00,50.88,0.00,0.00),('21','238','4','33',327,'13','2',2345663.10,2350238.69,4575.59,3033616.17,0.00,0.00,0.00,0.00,0.00),('21','238','5','33',328,'15','2',252491.02,254628.27,2137.25,1416996.75,0.00,0.00,0.00,0.00,0.00),('21','238','5','33',329,'16','2',159915.31,160894.77,979.46,649381.98,0.00,0.00,0.00,0.00,0.00),('21','238','6','33',330,'17','3',581987.24,582124.89,137.65,75707.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','34',331,'1','1',5629751.56,5629751.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','34',332,'2','1',4820709.73,4820709.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','34',333,'5','1',2176184.16,2181914.01,5709.85,942125.25,0.00,0.00,20.00,0.00,0.00),('21','238','2','34',334,'6','1',5102366.97,5107416.73,5029.76,829910.40,0.00,0.00,20.00,0.00,0.00),('21','238','3','34',335,'9','1',4793379.17,4799272.33,5873.16,969071.40,0.00,0.00,20.00,0.00,0.00),('21','238','3','34',336,'11','1',5568855.46,5569094.72,229.26,37827.90,0.00,0.00,10.00,0.00,0.00),('21','238','4','34',337,'13','2',2350238.69,2352730.55,2491.86,1652103.18,0.00,0.00,0.00,0.00,0.00),('21','238','5','34',338,'15','2',254628.27,258395.70,3767.43,2497806.09,0.00,0.00,0.00,0.00,0.00),('21','238','5','34',339,'16','2',160894.77,162152.45,1257.68,833841.84,0.00,0.00,0.00,0.00,0.00),('21','238','6','34',340,'17','3',582124.89,582253.28,98.21,54015.50,0.00,0.00,30.18,0.00,0.00),('21','238','1','35',341,'1','1',5629751.56,5629751.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','35',342,'2','1',4820709.73,4820709.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','35',343,'5','1',2181914.01,2188002.12,6088.11,1004538.15,0.00,0.00,0.00,0.00,0.00),('21','238','2','35',344,'6','1',5107416.73,5114303.35,6886.62,1136292.30,0.00,0.00,0.00,0.00,0.00),('21','238','3','35',345,'9','1',4799272.33,4802089.22,2816.89,464786.85,0.00,0.00,0.00,0.00,0.00),('21','238','3','35',346,'11','1',5569094.72,5569650.44,555.72,91693.80,0.00,0.00,0.00,0.00,0.00),('21','238','4','35',347,'13','2',2352730.55,2354520.93,1790.38,1187021.94,0.00,0.00,0.00,0.00,0.00),('21','238','5','35',348,'15','2',258395.70,259112.60,716.90,475304.70,0.00,0.00,0.00,0.00,0.00),('21','238','5','35',349,'16','2',162152.45,162550.14,397.69,263668.47,0.00,0.00,0.00,0.00,0.00),('21','238','6','35',350,'17','3',582253.28,582486.10,232.82,128051.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','36',351,'1','1',5629751.56,5629751.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','36',352,'2','1',4820709.73,4820709.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','36',353,'5','1',2188002.12,2192506.72,4504.60,743259.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','36',354,'6','1',5114303.35,5121711.39,7408.04,1222326.60,0.00,0.00,0.00,0.00,0.00),('21','238','3','36',355,'9','1',4802089.22,4804664.12,2574.90,424858.50,0.00,0.00,0.00,0.00,0.00),('21','238','3','36',356,'11','1',5569650.44,5569920.28,269.84,44523.60,0.00,0.00,0.00,0.00,0.00),('21','238','4','36',357,'13','2',2354520.93,2358343.52,3822.59,2534377.17,0.00,0.00,0.00,0.00,0.00),('21','238','5','36',358,'15','2',259112.60,262532.75,3420.15,2267559.45,0.00,0.00,0.00,0.00,0.00),('21','238','5','36',359,'16','2',162550.14,164657.97,2107.83,1397491.29,0.00,0.00,0.00,0.00,0.00),('21','238','6','36',360,'17','3',582486.10,582846.73,360.63,198346.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','37',361,'1','1',5629751.56,5629751.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','37',362,'2','1',4820709.73,4820709.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','37',363,'5','1',2192506.72,2199738.28,7201.56,1188257.40,0.00,0.00,30.00,0.00,0.00),('21','238','2','37',364,'6','1',5121711.39,5129041.70,7310.31,1206201.15,0.00,0.00,20.00,0.00,0.00),('21','238','3','37',365,'9','1',4804664.12,4808778.57,4074.45,672284.25,0.00,0.00,40.00,0.00,0.00),('21','238','3','37',366,'11','1',5569920.28,5571956.19,1995.91,329325.15,0.00,0.00,40.00,0.00,0.00),('21','238','4','37',367,'13','2',2358343.52,2361790.48,3446.96,2285334.48,0.00,0.00,0.00,0.00,0.00),('21','238','5','37',368,'15','2',262532.75,264732.71,2199.96,1458573.48,0.00,0.00,0.00,0.00,0.00),('21','238','5','37',369,'16','2',164657.97,165100.98,443.01,293715.63,0.00,0.00,0.00,0.00,0.00),('21','238','6','37',370,'17','3',582846.73,583062.62,195.89,107739.50,0.00,0.00,20.00,0.00,0.00),('21','238','1','38',371,'1','1',5629751.56,5629751.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','38',372,'2','1',4820709.73,4820709.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','38',373,'5','1',2199738.28,2211231.91,11483.63,1894798.95,0.00,0.00,10.00,0.00,0.00),('21','238','2','38',374,'6','1',5129041.70,5141690.40,12648.70,2087035.50,0.00,0.00,0.00,0.00,0.00),('21','238','3','38',375,'9','1',4808778.57,4813652.01,4873.44,804117.60,0.00,0.00,0.00,0.00,0.00),('21','238','3','38',376,'11','1',5571956.19,5571956.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','38',377,'13','2',2361790.48,2365053.01,3262.53,2163057.39,0.00,0.00,0.00,0.00,0.00),('21','238','5','38',378,'15','2',264732.71,266672.87,1940.16,1286326.08,0.00,0.00,0.00,0.00,0.00),('21','238','5','38',379,'16','2',165100.98,165583.18,482.20,319698.60,0.00,0.00,0.00,0.00,0.00),('21','238','6','38',380,'17','3',583062.62,583206.30,143.68,79024.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','39',381,'1','1',5629751.56,5629751.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','39',382,'2','1',4820709.73,4820709.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','39',383,'5','1',2211231.91,2215612.82,4360.65,719507.25,0.00,0.00,20.26,0.00,0.00),('21','238','2','39',384,'6','1',5141690.40,5147019.66,5308.94,875975.10,0.00,0.00,20.32,0.00,0.00),('21','238','3','39',385,'9','1',4813652.01,4817572.26,3899.96,643493.40,0.00,0.00,20.29,0.00,0.00),('21','238','3','39',386,'11','1',5571956.19,5572432.88,456.46,75315.90,0.00,0.00,20.23,0.00,0.00),('21','238','4','39',387,'13','2',2365053.01,2367848.40,2795.39,1853343.57,0.00,0.00,0.00,0.00,0.00),('21','238','5','39',388,'15','2',266672.87,266966.23,293.36,194497.68,0.00,0.00,0.00,0.00,0.00),('21','238','5','39',389,'16','2',165583.18,165583.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','39',390,'17','3',583206.30,583248.77,42.47,23358.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','40',391,'1','1',5629751.56,5629751.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','40',392,'2','1',4820709.73,4820709.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','40',393,'5','1',2215612.82,2215612.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','40',394,'6','1',5147019.66,5147019.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','40',395,'9','1',4817572.26,4822394.40,4822.14,795653.10,0.00,0.00,0.00,0.00,0.00),('21','238','3','40',396,'11','1',5572432.88,5574558.48,2125.60,350724.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','40',397,'13','2',2367848.40,2369855.81,2007.41,1330912.83,0.00,0.00,0.00,0.00,0.00),('21','238','5','40',398,'15','2',266966.23,267610.30,644.07,427018.41,0.00,0.00,0.00,0.00,0.00),('21','238','5','40',399,'16','2',165583.18,165583.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','40',400,'17','3',583248.77,583328.02,79.25,43587.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','41',401,'1','1',5629751.56,5629751.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','41',402,'2','1',4820709.73,4820709.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','41',403,'5','1',2215612.82,2220536.32,4883.50,805777.50,0.00,0.00,40.00,0.00,0.00),('21','238','2','41',404,'6','1',5147019.66,5151673.59,4613.93,761298.45,0.00,0.00,40.00,0.00,0.00),('21','238','3','41',405,'9','1',4822394.40,4824355.29,1940.89,320246.85,0.00,0.00,20.00,0.00,0.00),('21','238','3','41',406,'11','1',5574558.48,5574558.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','41',407,'13','2',2369855.81,2371313.13,1457.32,966203.16,0.00,0.00,0.00,0.00,0.00),('21','238','5','41',408,'15','2',267610.30,273678.49,6068.19,4023209.97,0.00,0.00,0.00,0.00,0.00),('21','238','5','41',409,'16','2',165583.18,169387.36,3804.18,2522171.34,0.00,0.00,0.00,0.00,0.00),('21','238','6','41',410,'17','3',583328.02,583519.67,191.65,105407.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','42',411,'1','1',5629751.56,5629751.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','42',412,'2','1',4820709.73,4820709.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','42',413,'5','1',2220536.32,2230353.07,9816.75,1619763.75,0.00,0.00,0.00,0.00,0.00),('21','238','2','42',414,'6','1',5151673.59,5162843.80,11170.21,1843084.65,0.00,0.00,0.00,0.00,0.00),('21','238','3','42',415,'9','1',4824355.29,4828234.64,3879.35,640092.75,0.00,0.00,0.00,0.00,0.00),('21','238','3','42',416,'11','1',5574558.48,5574764.39,205.91,33975.15,0.00,0.00,0.00,0.00,0.00),('21','238','4','42',417,'13','2',2371313.13,2377470.82,6157.69,4082548.47,0.00,0.00,0.00,0.00,0.00),('21','238','5','42',418,'15','2',273678.49,279113.68,5435.19,3603530.97,0.00,0.00,0.00,0.00,0.00),('21','238','5','42',419,'16','2',169387.36,169821.96,434.60,288139.80,0.00,0.00,0.00,0.00,0.00),('21','238','6','42',420,'17','3',583519.67,583984.28,464.61,255535.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','43',421,'1','1',5629751.56,5629751.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','43',422,'2','1',4820709.73,4820709.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','43',423,'5','1',2230353.07,2230353.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','43',424,'6','1',5162843.80,5162843.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','43',425,'9','1',4828234.64,4828234.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','43',426,'11','1',5574764.39,5574764.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','43',427,'13','2',2377470.82,2377470.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','43',428,'15','2',279113.68,279113.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','43',429,'16','2',169821.96,169821.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','43',430,'17','3',583984.28,583984.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','44',431,'1','1',5629751.56,5629751.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','44',432,'2','1',4820709.73,4820709.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','44',433,'5','1',2230353.07,2238730.39,8357.32,1378957.80,0.00,0.00,20.00,0.00,0.00),('21','238','2','44',434,'6','1',5162843.80,5173785.77,10921.97,1802125.05,0.00,0.00,20.00,0.00,0.00),('21','238','3','44',435,'9','1',4828234.64,4836051.30,7796.66,1286448.90,0.00,0.00,20.00,0.00,0.00),('21','238','3','44',436,'11','1',5574764.39,5577670.63,2886.24,476229.60,0.00,0.00,20.00,0.00,0.00),('21','238','4','44',437,'13','2',2377470.82,2385461.82,7991.00,5298033.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','44',438,'15','2',279113.68,280352.88,1239.20,821589.60,0.00,0.00,0.00,0.00,0.00),('21','238','5','44',439,'16','2',169821.96,171003.01,1181.05,783036.15,0.00,0.00,0.00,0.00,0.00),('21','238','6','44',440,'17','3',583984.28,584168.18,183.90,101145.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','45',441,'1','1',5629751.56,5629751.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','45',442,'2','1',4820709.73,4820709.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','45',443,'5','1',2238730.39,2238730.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','45',444,'6','1',5173785.77,5173785.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','45',445,'9','1',4836051.30,4836051.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','45',446,'11','1',5577670.63,5577670.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','45',447,'13','2',2385461.82,2387718.88,2257.06,1496430.78,0.00,0.00,0.00,0.00,0.00),('21','238','5','45',448,'15','2',280352.88,280352.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','45',449,'16','2',171003.01,171003.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','45',450,'17','3',584168.18,584170.37,2.19,1204.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','46',451,'1','1',5629751.56,5629751.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','46',452,'2','1',4820709.73,4820709.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','46',453,'5','1',2238730.39,2248349.24,9588.85,1582160.25,0.00,0.00,30.00,0.00,0.00),('21','238','2','46',454,'6','1',5173785.77,5183172.18,9356.41,1543807.65,0.00,0.00,30.00,0.00,0.00),('21','238','3','46',455,'9','1',4836051.30,4843641.44,7570.14,1249073.10,0.00,0.00,20.00,0.00,0.00),('21','238','3','46',456,'11','1',5577670.63,5583022.35,5331.72,879733.80,0.00,0.00,20.00,0.00,0.00),('21','238','4','46',457,'13','2',2387718.88,2393954.03,6235.15,4227431.70,0.00,0.00,0.00,0.00,0.00),('21','238','5','46',458,'15','2',280352.88,280352.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','46',459,'16','2',171003.01,171003.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','46',460,'17','3',584170.37,584372.16,201.79,131163.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','47',461,'1','1',5629751.56,5629751.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','47',462,'2','1',4820709.73,4820709.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','47',463,'5','1',2248349.24,2249304.40,955.16,157601.40,0.00,0.00,0.00,0.00,0.00),('21','238','2','47',464,'6','1',5183172.18,5185119.61,1947.43,321325.95,0.00,0.00,0.00,0.00,0.00),('21','238','3','47',465,'9','1',4843641.44,4843641.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','47',466,'11','1',5583022.35,5583022.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','47',467,'13','2',2393954.03,2401191.00,7236.97,4906665.66,0.00,0.00,0.00,0.00,0.00),('21','238','5','47',468,'15','2',280352.88,281202.89,850.01,576306.78,0.00,0.00,0.00,0.00,0.00),('21','238','5','47',469,'16','2',171003.01,171516.25,513.24,347976.72,0.00,0.00,0.00,0.00,0.00),('21','238','6','47',470,'17','3',584372.16,584573.74,201.58,131027.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','48',471,'1','1',5629751.56,5629751.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','48',472,'2','1',4820709.73,4820709.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','48',473,'5','1',2249304.40,2249304.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','48',474,'6','1',5185119.61,5185119.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','48',475,'9','1',4843641.44,4843641.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','48',476,'11','1',5583022.35,5583022.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','48',477,'13','2',2401191.00,2407293.31,6102.31,4137366.18,0.00,0.00,0.00,0.00,0.00),('21','238','5','48',478,'15','2',281202.89,285966.20,4763.31,3229524.18,0.00,0.00,0.00,0.00,0.00),('21','238','5','48',479,'16','2',171516.25,174308.73,2792.48,1893301.44,0.00,0.00,0.00,0.00,0.00),('21','238','6','48',480,'17','3',584573.74,584757.89,184.15,119697.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','49',481,'1','1',5629751.56,5634513.28,4731.72,780733.80,0.00,0.00,30.00,0.00,0.00),('21','238','1','49',482,'2','1',4820709.73,4827243.75,6504.02,1073163.30,0.00,0.00,30.00,0.00,0.00),('21','238','2','49',483,'5','1',2249304.40,2249304.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','49',484,'6','1',5185119.61,5185119.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','49',485,'9','1',4843641.44,4846685.10,3013.66,497253.90,0.00,0.00,30.00,0.00,0.00),('21','238','3','49',486,'11','1',5583022.35,5583810.86,758.51,125154.15,0.00,0.00,30.00,0.00,0.00),('21','238','4','49',487,'13','2',2407293.31,2415911.03,8617.72,5842814.16,0.00,0.00,0.00,0.00,0.00),('21','238','5','49',488,'15','2',285966.20,290191.00,4224.80,2864414.40,0.00,0.00,0.00,0.00,0.00),('21','238','5','49',489,'16','2',174308.73,176427.86,2119.13,1436770.14,0.00,0.00,0.00,0.00,0.00),('21','238','6','49',490,'17','3',584757.89,585099.03,321.14,208741.00,0.00,0.00,20.00,0.00,0.00),('21','238','1','50',491,'1','1',5634513.28,5634513.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','50',492,'2','1',4827243.75,4827243.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','50',493,'5','1',2249304.40,2249304.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','50',494,'6','1',5185119.61,5185119.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','50',495,'9','1',4846685.10,4846685.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','50',496,'11','1',5583810.86,5583810.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','50',497,'13','2',2415911.03,2429406.84,13495.81,9150159.18,0.00,0.00,0.00,0.00,0.00),('21','238','5','50',498,'15','2',290191.00,290191.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','50',499,'16','2',176427.86,176427.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','50',500,'17','3',585099.03,585209.90,110.87,72065.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','51',501,'1','1',5634513.28,5634513.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','51',502,'2','1',4827243.75,4827243.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','51',503,'5','1',2249304.40,2249304.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','51',504,'6','1',5185119.61,5185119.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','51',505,'9','1',4846685.10,4846685.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','51',506,'11','1',5583810.86,5583810.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','51',507,'13','2',2429406.84,2429406.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','51',508,'15','2',290191.00,290191.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','51',509,'16','2',176427.86,176427.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','51',510,'17','3',585209.90,585321.65,111.75,72637.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','52',511,'1','1',5634513.28,5634513.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','52',512,'2','1',4827243.75,4827243.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','52',513,'5','1',2249304.40,2249304.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','52',514,'6','1',5185119.61,5185119.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','52',515,'9','1',4846685.10,4846685.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','52',516,'11','1',5583810.86,5583810.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','52',517,'13','2',2429406.84,2429406.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','52',518,'15','2',290191.00,290191.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','52',519,'16','2',176427.86,176427.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','52',520,'17','3',585321.65,585411.90,90.25,58662.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','53',521,'1','1',5634513.28,5634513.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','53',522,'2','1',4827243.75,4827243.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','53',523,'5','1',2249304.40,2249304.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','53',524,'6','1',5185119.61,5185119.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','53',525,'9','1',4846685.10,4846685.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','53',526,'11','1',5583810.86,5583810.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','53',527,'13','2',2429406.84,2433694.75,4287.91,3078719.38,0.00,0.00,0.00,0.00,0.00),('21','238','5','53',528,'15','2',290191.00,292683.48,2492.48,1789600.64,0.00,0.00,0.00,0.00,0.00),('21','238','5','53',529,'16','2',176427.86,177900.96,1473.10,1057685.80,0.00,0.00,0.00,0.00,0.00),('21','238','6','53',530,'17','3',585411.90,585584.82,172.92,112398.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','54',531,'1','1',5634513.28,5634513.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','54',532,'2','1',4827243.75,4827243.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','54',533,'5','1',2249304.40,2253632.88,4328.48,714199.20,0.00,0.00,0.00,0.00,0.00),('21','238','2','54',534,'6','1',5185119.61,5187798.94,2679.33,442089.45,0.00,0.00,0.00,0.00,0.00),('21','238','3','54',535,'9','1',4846685.10,4854653.45,7968.35,1314777.75,0.00,0.00,0.00,0.00,0.00),('21','238','3','54',536,'11','1',5583810.86,5585432.44,1621.58,267560.70,0.00,0.00,0.00,0.00,0.00),('21','238','4','54',537,'13','2',2433694.75,2435983.73,2288.98,1643487.64,0.00,0.00,0.00,0.00,0.00),('21','238','5','54',538,'15','2',292683.48,295798.69,3115.21,2236720.78,0.00,0.00,0.00,0.00,0.00),('21','238','5','54',539,'16','2',177900.96,179342.07,1441.11,1034716.98,0.00,0.00,0.00,0.00,0.00),('21','238','6','54',540,'17','3',585584.82,585696.55,111.73,72624.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','55',541,'1','1',5634513.28,5634513.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','55',542,'2','1',4827243.75,4827243.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','55',543,'5','1',2253632.88,2253632.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','55',544,'6','1',5187798.94,5187798.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','55',545,'9','1',4854653.45,4854653.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','55',546,'11','1',5585432.44,5585432.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','55',547,'13','2',2435983.73,2435983.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','55',548,'15','2',295798.69,295798.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','55',549,'16','2',179342.07,179342.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','55',550,'17','3',585696.55,585813.49,116.94,76011.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','56',551,'1','1',5634513.28,5634513.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','56',552,'2','1',4827243.75,4827243.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','56',553,'5','1',2253632.88,2263755.60,10102.72,1666948.80,0.00,0.00,20.00,0.00,0.00),('21','238','2','56',554,'6','1',5187798.94,5194116.23,6317.29,1042352.85,0.00,0.00,0.00,0.00,0.00),('21','238','3','56',555,'9','1',4854653.45,4865410.20,10756.75,1774863.75,0.00,0.00,0.00,0.00,0.00),('21','238','3','56',556,'11','1',5585432.44,5594502.40,9069.96,1496543.40,0.00,0.00,0.00,0.00,0.00),('21','238','4','56',557,'13','2',2435983.73,2437959.25,1975.52,1418423.36,0.00,0.00,0.00,0.00,0.00),('21','238','5','56',558,'15','2',295798.69,297733.52,1934.83,1389207.94,0.00,0.00,0.00,0.00,0.00),('21','238','5','56',559,'16','2',179342.07,180175.21,833.14,598194.52,0.00,0.00,0.00,0.00,0.00),('21','238','6','56',560,'17','3',585813.49,585991.38,177.89,115628.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','57',561,'1','1',5634513.28,5641920.82,7397.54,1220594.10,0.00,0.00,10.00,0.00,0.00),('21','238','1','57',562,'2','1',4827243.75,4835136.35,7882.60,1300629.00,0.00,0.00,10.00,0.00,0.00),('21','238','2','57',563,'5','1',2263755.60,2263755.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','57',564,'6','1',5194116.23,5194116.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','57',565,'9','1',4865410.20,4865410.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','57',566,'11','1',5594502.40,5594502.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','57',567,'13','2',2437959.25,2444598.99,6639.74,4767333.32,0.00,0.00,0.00,0.00,0.00),('21','238','5','57',568,'15','2',297733.52,300841.69,3108.17,2231666.06,0.00,0.00,0.00,0.00,0.00),('21','238','5','57',569,'16','2',180175.21,180909.96,734.75,527550.50,0.00,0.00,0.00,0.00,0.00),('21','238','6','57',570,'17','3',585991.38,586120.01,118.63,77109.50,0.00,0.00,10.00,0.00,0.00),('21','238','1','58',571,'1','1',5641920.82,5649756.29,7825.47,1291202.55,0.00,0.00,10.00,0.00,0.00),('21','238','1','58',572,'2','1',4835136.35,4843472.02,8325.67,1373735.55,0.00,0.00,10.00,0.00,0.00),('21','238','2','58',573,'5','1',2263755.60,2263755.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','58',574,'6','1',5194116.23,5194116.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','58',575,'9','1',4865410.20,4865410.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','58',576,'11','1',5594502.40,5594502.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','58',577,'13','2',2444598.99,2448076.55,3477.56,2496888.08,0.00,0.00,0.00,0.00,0.00),('21','238','5','58',578,'15','2',300841.69,304053.19,3211.50,2305857.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','58',579,'16','2',180909.96,182592.10,1682.14,1207776.52,0.00,0.00,0.00,0.00,0.00),('21','238','6','58',580,'17','3',586120.01,586278.12,158.11,102771.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','59',581,'1','1',5649756.29,5656729.93,6973.64,1150650.60,0.00,0.00,0.00,0.00,0.00),('21','238','1','59',582,'2','1',4843472.02,4851599.25,8127.23,1340992.95,0.00,0.00,0.00,0.00,0.00),('21','238','2','59',583,'5','1',2263755.60,2263755.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','59',584,'6','1',5194116.23,5194116.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','59',585,'9','1',4865410.20,4865410.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','59',586,'11','1',5594502.40,5594502.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','59',587,'13','2',2448076.55,2450592.22,2515.67,1806251.06,0.00,0.00,0.00,0.00,0.00),('21','238','5','59',588,'15','2',304053.19,305819.39,1766.20,1268131.60,0.00,0.00,0.00,0.00,0.00),('21','238','5','59',589,'16','2',182592.10,183559.35,967.25,694485.50,0.00,0.00,0.00,0.00,0.00),('21','238','6','59',590,'17','3',586278.12,586417.25,139.13,90434.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','60',591,'1','1',5656729.93,5656729.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','60',592,'2','1',4851599.25,4851599.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','60',593,'5','1',2263755.60,2263755.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','60',594,'6','1',5194116.23,5194116.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','60',595,'9','1',4865410.20,4865410.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','60',596,'11','1',5594502.40,5594502.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','60',597,'13','2',2450592.22,2454604.98,4012.76,2881161.68,0.00,0.00,0.00,0.00,0.00),('21','238','5','60',598,'15','2',305819.39,308177.32,2357.93,1692993.74,0.00,0.00,0.00,0.00,0.00),('21','238','5','60',599,'16','2',183559.35,183984.48,425.13,305243.34,0.00,0.00,0.00,0.00,0.00),('21','238','6','60',600,'17','3',586417.25,586582.95,165.70,107705.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','61',601,'1','1',5656729.93,5656729.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','61',602,'2','1',4851599.25,4851599.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','61',603,'5','1',2263755.60,2263755.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','61',604,'6','1',5194116.23,5194116.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','61',605,'9','1',4865410.20,4865410.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','61',606,'11','1',5594502.40,5594502.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','61',607,'13','2',2454604.98,2459504.34,4899.36,3517740.48,0.00,0.00,0.00,0.00,0.00),('21','238','5','61',608,'15','2',308177.32,311885.69,3708.37,2662609.66,0.00,0.00,0.00,0.00,0.00),('21','238','5','61',609,'16','2',183984.48,184571.01,586.53,421128.54,0.00,0.00,0.00,0.00,0.00),('21','238','6','61',610,'17','3',586582.95,586582.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','62',611,'1','1',5656729.93,5658321.78,1571.85,259355.25,0.00,0.00,20.00,0.00,0.00),('21','238','1','62',612,'2','1',4851599.25,4856113.17,4493.92,741496.80,0.00,0.00,20.00,0.00,0.00),('21','238','2','62',613,'5','1',2263755.60,2266495.12,2719.52,448720.80,0.00,0.00,20.00,0.00,0.00),('21','238','2','62',614,'6','1',5194116.23,5201472.36,7336.13,1210461.45,0.00,0.00,20.00,0.00,0.00),('21','238','3','62',615,'9','1',4865410.20,4865410.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','62',616,'11','1',5594502.40,5594502.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','62',617,'13','2',2459504.34,2459504.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','62',618,'15','2',311885.69,311926.33,40.64,30805.12,0.00,0.00,0.00,0.00,0.00),('21','238','5','62',619,'16','2',184571.01,184571.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','62',620,'17','3',586582.95,586831.92,228.97,148830.50,0.00,0.00,20.00,0.00,0.00),('21','238','1','63',621,'1','1',5658321.78,5658321.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','63',622,'2','1',4856113.17,4856113.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','63',623,'5','1',2266495.12,2266495.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','63',624,'6','1',5201472.36,5201472.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','63',625,'9','1',4865410.20,4865410.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','63',626,'11','1',5594502.40,5594502.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','63',627,'13','2',2459504.34,2459504.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','63',628,'15','2',311926.33,311926.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','63',629,'16','2',184571.01,184571.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','63',630,'17','3',586831.92,587065.38,223.46,145249.00,0.00,0.00,10.00,0.00,0.00),('21','238','1','64',631,'1','1',5658321.78,5658553.19,211.41,34882.65,0.00,0.00,20.00,0.00,0.00),('21','238','1','64',632,'2','1',4856113.17,4863316.07,7202.90,1188478.50,0.00,0.00,0.00,0.00,0.00),('21','238','2','64',633,'5','1',2266495.12,2269800.01,3304.89,545306.85,0.00,0.00,0.00,0.00,0.00),('21','238','2','64',634,'6','1',5201472.36,5213365.12,11892.76,1962305.40,0.00,0.00,0.00,0.00,0.00),('21','238','3','64',635,'9','1',4865410.20,4865410.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','64',636,'11','1',5594502.40,5594502.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','64',637,'13','2',2459504.34,2459504.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','64',638,'15','2',311926.33,311926.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','64',639,'16','2',184571.01,184571.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','64',640,'17','3',587065.38,587211.61,146.23,95049.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','65',641,'1','1',5658553.19,5659559.40,945.71,156042.15,0.00,0.00,60.50,0.00,0.00),('21','238','1','65',642,'2','1',4863316.07,4869921.73,6545.66,1080033.90,0.00,0.00,60.00,0.00,0.00),('21','238','2','65',643,'5','1',2269800.01,2271923.95,2103.94,347150.10,0.00,0.00,20.00,0.00,0.00),('21','238','2','65',644,'6','1',5213365.12,5226351.16,12966.04,2139396.60,0.00,0.00,20.00,0.00,0.00),('21','238','3','65',645,'9','1',4865410.20,4865410.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','65',646,'11','1',5594502.40,5594502.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','65',647,'13','2',2459504.34,2460198.79,694.45,526393.10,0.00,0.00,0.00,0.00,0.00),('21','238','5','65',648,'15','2',311926.33,313031.77,1105.44,837923.52,0.00,0.00,0.00,0.00,0.00),('21','238','5','65',649,'16','2',184571.01,185142.32,571.31,433052.98,0.00,0.00,0.00,0.00,0.00),('21','238','6','65',650,'17','3',587211.61,587301.84,90.23,58649.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','66',651,'1','1',5659559.40,5659559.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','66',652,'2','1',4869921.73,4869921.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','66',653,'5','1',2271923.95,2271923.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','66',654,'6','1',5226351.16,5226351.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','66',655,'9','1',4865410.20,4865410.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','66',656,'11','1',5594502.40,5594502.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','66',657,'13','2',2460198.79,2466656.96,6458.17,4895292.86,0.00,0.00,0.00,0.00,0.00),('21','238','5','66',658,'15','2',313031.77,316937.31,3905.54,2960399.32,0.00,0.00,0.00,0.00,0.00),('21','238','5','66',659,'16','2',185142.32,185772.16,629.84,477418.72,0.00,0.00,0.00,0.00,0.00),('21','238','6','66',660,'17','3',587301.84,587674.08,372.24,241956.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','67',661,'1','1',5659559.40,5662477.85,2888.25,476561.25,0.00,0.00,30.20,0.00,0.00),('21','238','1','67',662,'2','1',4869921.73,4879692.81,9721.08,1603978.20,0.00,0.00,50.00,0.00,0.00),('21','238','2','67',663,'5','1',2271923.95,2271923.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','67',664,'6','1',5226351.16,5231650.29,5249.13,866106.45,0.00,0.00,50.00,0.00,0.00),('21','238','3','67',665,'9','1',4865410.20,4865410.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','67',666,'11','1',5594502.40,5594502.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','67',667,'13','2',2466656.96,2469491.21,2834.25,2148361.50,0.00,0.00,0.00,0.00,0.00),('21','238','5','67',668,'15','2',316937.31,318820.09,1882.78,1427147.24,0.00,0.00,0.00,0.00,0.00),('21','238','5','67',669,'16','2',185772.16,185978.81,206.65,156640.70,0.00,0.00,0.00,0.00,0.00),('21','238','6','67',670,'17','3',587674.08,587736.80,62.72,40768.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','68',671,'1','1',5662477.85,5662477.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','68',672,'2','1',4879692.81,4879692.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','68',673,'5','1',2271923.95,2271923.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','68',674,'6','1',5231650.29,5231650.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','68',675,'9','1',4865410.20,4865410.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','68',676,'11','1',5594502.40,5594502.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','68',677,'13','2',2469491.21,2475168.75,5677.54,4303575.32,0.00,0.00,0.00,0.00,0.00),('21','238','5','68',678,'15','2',318820.09,322555.71,3735.62,2831599.96,0.00,0.00,0.00,0.00,0.00),('21','238','5','68',679,'16','2',185978.81,186137.40,158.59,120211.22,0.00,0.00,0.00,0.00,0.00),('21','238','6','68',680,'17','3',587736.80,587886.45,149.65,97272.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','69',681,'1','1',5662477.85,5664022.84,1534.99,253273.35,0.00,0.00,10.00,0.00,0.00),('21','238','1','69',682,'2','1',4879692.81,4882079.11,2376.30,392089.50,0.00,0.00,10.00,0.00,0.00),('21','238','2','69',683,'5','1',2271923.95,2271923.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','69',684,'6','1',5231650.29,5231650.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','69',685,'9','1',4865410.20,4871798.11,6377.91,1052355.15,0.00,0.00,10.00,0.00,0.00),('21','238','3','69',686,'11','1',5594502.40,5599209.62,4697.22,775041.30,0.00,0.00,10.00,0.00,0.00),('21','238','4','69',687,'13','2',2475168.75,2475993.16,824.41,624902.78,0.00,0.00,0.00,0.00,0.00),('21','238','5','69',688,'15','2',322555.71,322555.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','69',689,'16','2',186137.40,186137.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','69',690,'17','3',587886.45,587974.75,88.30,57395.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','70',691,'1','1',5664022.84,5664022.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','70',692,'2','1',4882079.11,4882079.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','70',693,'5','1',2271923.95,2271923.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','70',694,'6','1',5231650.29,5231650.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','70',695,'9','1',4871798.11,4871798.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','70',696,'11','1',5599209.62,5599209.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','70',697,'13','2',2475993.16,2478132.85,2139.69,1621885.02,0.00,0.00,0.00,0.00,0.00),('21','238','5','70',698,'15','2',322555.71,324515.71,1960.00,1485680.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','70',699,'16','2',186137.40,186409.93,272.53,206577.74,0.00,0.00,0.00,0.00,0.00),('21','238','6','70',700,'17','3',587974.75,588111.02,136.27,88575.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','71',701,'1','1',5664022.84,5665937.23,1894.39,312574.35,0.00,0.00,20.00,0.00,0.00),('21','238','1','71',702,'2','1',4882079.11,4884808.43,2709.32,447037.80,0.00,0.00,20.00,0.00,0.00),('21','238','2','71',703,'5','1',2271923.95,2271923.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','71',704,'6','1',5231650.29,5231650.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','71',705,'9','1',4871798.11,4874919.74,3111.63,513418.95,0.00,0.00,10.00,0.00,0.00),('21','238','3','71',706,'11','1',5599209.62,5599209.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','71',707,'13','2',2478132.85,2484150.03,6017.18,4561022.44,0.00,0.00,0.00,0.00,0.00),('21','238','5','71',708,'15','2',324515.71,328179.05,3663.34,2776811.72,0.00,0.00,0.00,0.00,0.00),('21','238','5','71',709,'16','2',186409.93,186511.14,101.21,76717.18,0.00,0.00,0.00,0.00,0.00),('21','238','6','71',710,'17','3',588111.02,588212.85,101.83,66189.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','72',711,'1','1',5665937.23,5667499.09,1511.86,249456.90,0.00,0.00,50.00,0.00,0.00),('21','238','1','72',712,'2','1',4884808.43,4888574.84,3736.41,616507.65,0.00,0.00,30.00,0.00,0.00),('21','238','2','72',713,'5','1',2271923.95,2271923.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','72',714,'6','1',5231650.29,5231650.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','72',715,'9','1',4874919.74,4880261.30,5321.56,878057.40,0.00,0.00,20.00,0.00,0.00),('21','238','3','72',716,'11','1',5599209.62,5600447.58,1217.96,200963.40,0.00,0.00,20.00,0.00,0.00),('21','238','4','72',717,'13','2',2484150.03,2487383.46,3233.43,2450939.94,0.00,0.00,0.00,0.00,0.00),('21','238','5','72',718,'15','2',328179.05,330610.35,2431.30,1842925.40,0.00,0.00,0.00,0.00,0.00),('21','238','5','72',719,'16','2',186511.14,186693.79,182.65,138448.70,0.00,0.00,0.00,0.00,0.00),('21','238','6','72',720,'17','3',588212.85,588281.98,69.13,44934.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','73',721,'1','1',5667499.09,5667747.74,228.65,37727.25,0.00,0.00,20.00,0.00,0.00),('21','238','1','73',722,'2','1',4888574.84,4893323.54,4728.70,780235.50,0.00,0.00,20.00,0.00,0.00),('21','238','2','73',723,'5','1',2271923.95,2271923.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','73',724,'6','1',5231650.29,5231650.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','73',725,'9','1',4880261.30,4885756.07,5474.77,903337.05,0.00,0.00,20.00,0.00,0.00),('21','238','3','73',726,'11','1',5600447.58,5601330.66,863.08,142408.20,0.00,0.00,20.00,0.00,0.00),('21','238','4','73',727,'13','2',2487383.46,2494114.19,6730.73,5101893.34,0.00,0.00,0.00,0.00,0.00),('21','238','5','73',728,'15','2',330610.35,337072.39,6462.04,4898226.32,0.00,0.00,0.00,0.00,0.00),('21','238','5','73',729,'16','2',186693.79,187411.20,717.41,543796.78,0.00,0.00,0.00,0.00,0.00),('21','238','6','73',730,'17','3',588281.98,588489.50,197.52,128388.00,0.00,0.00,10.00,0.00,0.00),('21','238','1','74',731,'1','1',5667747.74,5667747.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','74',732,'2','1',4893323.54,4893323.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','74',733,'5','1',2271923.95,2271923.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','74',734,'6','1',5231650.29,5231650.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','74',735,'9','1',4885756.07,4885756.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','74',736,'11','1',5601330.66,5601330.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','74',737,'13','2',2494114.19,2497898.74,3784.55,2868688.90,0.00,0.00,0.00,0.00,0.00),('21','238','5','74',738,'15','2',337072.39,340170.54,3098.15,2348397.70,0.00,0.00,0.00,0.00,0.00),('21','238','5','74',739,'16','2',187411.20,187516.09,104.89,79506.62,0.00,0.00,0.00,0.00,0.00),('21','238','6','74',740,'17','3',588489.50,588589.23,89.73,58324.50,0.00,0.00,10.00,0.00,0.00),('21','238','1','75',741,'1','1',5667747.74,5667747.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','75',742,'2','1',4893323.54,4893323.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','75',743,'5','1',2271923.95,2271923.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','75',744,'6','1',5231650.29,5231650.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','75',745,'9','1',4885756.07,4885756.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','75',746,'11','1',5601330.66,5601330.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','75',747,'13','2',2497898.74,2502509.42,4610.68,3494895.44,0.00,0.00,0.00,0.00,0.00),('21','238','5','75',748,'15','2',340170.54,342031.30,1860.76,1410456.08,0.00,0.00,0.00,0.00,0.00),('21','238','5','75',749,'16','2',187516.09,187932.81,416.72,315873.76,0.00,0.00,0.00,0.00,0.00),('21','238','6','75',750,'17','3',588589.23,588589.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','76',751,'1','1',5667747.74,5668284.67,496.93,81993.45,0.00,0.00,40.00,0.00,0.00),('21','238','1','76',752,'2','1',4893323.54,4899629.41,6285.87,1037168.55,0.00,0.00,20.00,0.00,0.00),('21','238','2','76',753,'5','1',2271923.95,2271923.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','76',754,'6','1',5231650.29,5239900.94,8230.65,1358057.25,0.00,0.00,20.00,0.00,0.00),('21','238','3','76',755,'9','1',4885756.07,4885756.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','76',756,'11','1',5601330.66,5601330.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','76',757,'13','2',2502509.42,2502719.36,209.94,163333.32,0.00,0.00,0.00,0.00,0.00),('21','238','5','76',758,'15','2',342031.30,342792.26,760.96,592026.88,0.00,0.00,0.00,0.00,0.00),('21','238','5','76',759,'16','2',187932.81,188270.50,337.69,262722.82,0.00,0.00,0.00,0.00,0.00),('21','238','6','76',760,'17','3',588589.23,588681.17,91.94,59761.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','77',761,'1','1',5668284.67,5668284.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','77',762,'2','1',4899629.41,4904520.81,4861.40,802131.00,0.00,0.00,30.00,0.00,0.00),('21','238','2','77',763,'5','1',2271923.95,2271923.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','77',764,'6','1',5239900.94,5246718.69,6797.75,1121628.75,0.00,0.00,20.00,0.00,0.00),('21','238','3','77',765,'9','1',4885756.07,4885756.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','77',766,'11','1',5601330.66,5601330.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','77',767,'13','2',2502719.36,2508843.86,6124.50,4764861.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','77',768,'15','2',342792.26,343057.82,265.56,206605.68,0.00,0.00,0.00,0.00,0.00),('21','238','5','77',769,'16','2',188270.50,188777.72,507.22,394617.16,0.00,0.00,0.00,0.00,0.00),('21','238','6','77',770,'17','3',588681.17,588900.96,219.79,142863.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','78',771,'1','1',5668284.67,5669050.16,755.49,124655.85,0.00,0.00,10.00,0.00,0.00),('21','238','1','78',772,'2','1',4904520.81,4906453.40,1932.59,318877.35,0.00,0.00,0.00,0.00,0.00),('21','238','2','78',773,'5','1',2271923.95,2271923.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','78',774,'6','1',5246718.69,5247439.84,721.15,118989.75,0.00,0.00,0.00,0.00,0.00),('21','238','3','78',775,'9','1',4885756.07,4885756.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','78',776,'11','1',5601330.66,5601330.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','78',777,'13','2',2508843.86,2515996.37,7152.51,5564652.78,0.00,0.00,0.00,0.00,0.00),('21','238','5','78',778,'15','2',343057.82,347081.67,4023.85,3130555.30,0.00,0.00,0.00,0.00,0.00),('21','238','5','78',779,'16','2',188777.72,189044.35,266.63,207438.14,0.00,0.00,0.00,0.00,0.00),('21','238','6','78',780,'17','3',588900.96,589015.44,114.48,74412.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','79',781,'1','1',5669050.16,5670213.04,1152.42,190149.30,0.00,0.00,10.46,0.00,0.00),('21','238','1','79',782,'2','1',4906453.40,4916060.47,9597.07,1583516.55,0.00,0.00,10.00,0.00,0.00),('21','238','2','79',783,'5','1',2271923.95,2272426.33,502.38,82892.70,0.00,0.00,0.00,0.00,0.00),('21','238','2','79',784,'6','1',5247439.84,5263635.77,16185.93,2670678.45,0.00,0.00,10.00,0.00,0.00),('21','238','3','79',785,'9','1',4885756.07,4885756.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','79',786,'11','1',5601330.66,5601330.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','79',787,'13','2',2515996.37,2515996.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','79',788,'15','2',347081.67,355429.59,8347.92,6494681.76,0.00,0.00,0.00,0.00,0.00),('21','238','5','79',789,'16','2',189044.35,190388.28,1343.93,1045577.54,0.00,0.00,0.00,0.00,0.00),('21','238','6','79',790,'17','3',589015.44,589092.25,76.81,49926.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','80',791,'1','1',5670213.04,5670213.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','80',792,'2','1',4916060.47,4916060.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','80',793,'5','1',2272426.33,2272426.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','80',794,'6','1',5263635.77,5263635.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','80',795,'9','1',4885756.07,4885756.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','80',796,'11','1',5601330.66,5601330.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','80',797,'13','2',2515996.37,2517795.13,1798.76,1399435.28,0.00,0.00,0.00,0.00,0.00),('21','238','5','80',798,'15','2',355429.59,356480.39,1050.80,817522.40,0.00,0.00,0.00,0.00,0.00),('21','238','5','80',799,'16','2',190388.28,190391.79,3.51,2730.78,0.00,0.00,0.00,0.00,0.00),('21','238','6','80',800,'17','3',589092.25,589130.49,38.24,24856.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','81',801,'1','1',5670213.04,5674908.88,4695.84,774813.60,0.00,0.00,0.00,0.00,0.00),('21','238','1','81',802,'2','1',4916060.47,4925260.29,9199.82,1517970.30,0.00,0.00,0.00,0.00,0.00),('21','238','2','81',803,'5','1',2272426.33,2272426.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','81',804,'6','1',5263635.77,5278229.72,14593.95,2408001.75,0.00,0.00,0.00,0.00,0.00),('21','238','3','81',805,'9','1',4885756.07,4885756.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','81',806,'11','1',5601330.66,5601330.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','81',807,'13','2',2517795.13,2519242.27,1447.14,1154817.72,0.00,0.00,0.00,0.00,0.00),('21','238','5','81',808,'15','2',356480.39,356480.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','81',809,'16','2',190391.79,190391.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','81',810,'17','3',589130.49,589185.10,54.61,38227.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','82',811,'1','1',5674908.88,5675786.01,837.13,138126.45,0.00,0.00,40.00,0.00,0.00),('21','238','1','82',812,'2','1',4925260.29,4931994.27,6693.98,1104506.70,0.00,0.00,40.00,0.00,0.00),('21','238','2','82',813,'5','1',2272426.33,2277139.55,4673.22,771081.30,0.00,0.00,40.00,0.00,0.00),('21','238','2','82',814,'6','1',5278229.72,5292066.00,13805.84,2277963.60,0.00,0.00,30.44,0.00,0.00),('21','238','3','82',815,'9','1',4885756.07,4886054.36,267.89,44201.85,0.00,0.00,30.40,0.00,0.00),('21','238','3','82',816,'11','1',5601330.66,5602485.14,1114.48,183889.20,0.00,0.00,40.00,0.00,0.00),('21','238','4','82',817,'13','2',2519242.27,2530102.39,10860.12,8666375.76,0.00,0.00,0.00,0.00,0.00),('21','238','5','82',818,'15','2',356480.39,356480.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','82',819,'16','2',190391.79,190391.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','82',820,'17','3',589185.10,589335.56,130.26,91182.00,0.00,0.00,20.20,0.00,0.00),('21','238','1','83',821,'1','1',5675786.01,5675786.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','83',822,'2','1',4931994.27,4931994.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','83',823,'5','1',2277139.55,2277139.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','83',824,'6','1',5292066.00,5292066.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','83',825,'9','1',4886054.36,4893075.37,6981.01,1151866.65,0.00,0.00,40.00,0.00,0.00),('21','238','3','83',826,'11','1',5602485.14,5609126.17,6601.03,1089169.95,0.00,0.00,40.00,0.00,0.00),('21','238','4','83',827,'13','2',2530102.39,2532983.09,2880.70,2298798.60,0.00,0.00,0.00,0.00,0.00),('21','238','5','83',828,'15','2',356480.39,356480.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','83',829,'16','2',190391.79,190391.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','83',830,'17','3',589335.56,589388.64,53.08,37156.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','84',831,'1','1',5675786.01,5675786.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','84',832,'2','1',4931994.27,4931994.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','84',833,'5','1',2277139.55,2277139.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','84',834,'6','1',5292066.00,5292066.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','84',835,'9','1',4893075.37,4893075.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','84',836,'11','1',5609126.17,5609126.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','84',837,'13','2',2532983.09,2534128.84,1145.75,914308.50,0.00,0.00,0.00,0.00,0.00),('21','238','5','84',838,'15','2',356480.39,358437.28,1956.89,1561598.22,0.00,0.00,0.00,0.00,0.00),('21','238','5','84',839,'16','2',190391.79,190471.48,79.69,63592.62,0.00,0.00,0.00,0.00,0.00),('21','238','6','84',840,'17','3',589388.64,589388.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','85',841,'1','1',5675786.01,5675786.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','85',842,'2','1',4931994.27,4931994.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','85',843,'5','1',2277139.55,2277139.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','85',844,'6','1',5292066.00,5292066.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','85',845,'9','1',4893075.37,4893075.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','85',846,'11','1',5609126.17,5609126.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','85',847,'13','2',2534128.84,2535150.84,1022.00,835996.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','85',848,'15','2',358437.28,358437.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','85',849,'16','2',190471.48,190471.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','85',850,'17','3',589388.64,589477.94,89.30,62510.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','86',851,'1','1',5675786.01,5675786.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','86',852,'2','1',4931994.27,4931994.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','86',853,'5','1',2277139.55,2277139.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','86',854,'6','1',5292066.00,5292066.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','86',855,'9','1',4893075.37,4893075.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','86',856,'11','1',5609126.17,5609126.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','86',857,'13','2',2535150.84,2538840.04,3689.20,3017765.60,0.00,0.00,0.00,0.00,0.00),('21','238','5','86',858,'15','2',358437.28,361505.32,3068.04,2509656.72,0.00,0.00,0.00,0.00,0.00),('21','238','5','86',859,'16','2',190471.48,190933.31,461.83,377776.94,0.00,0.00,0.00,0.00,0.00),('21','238','6','86',860,'17','3',589477.94,589664.73,186.79,130753.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','87',861,'1','1',5675786.01,5675786.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','87',862,'2','1',4931994.27,4931994.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','87',863,'5','1',2277139.55,2277139.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','87',864,'6','1',5292066.00,5292066.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','87',865,'9','1',4893075.37,4893075.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','87',866,'11','1',5609126.17,5609126.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','87',867,'13','2',2538840.04,2538840.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','87',868,'15','2',361505.32,361505.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','87',869,'16','2',190933.31,190933.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','87',870,'17','3',589664.73,589664.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','88',871,'1','1',5675786.01,5675786.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','88',872,'2','1',4931994.27,4931994.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','88',873,'5','1',2277139.55,2277139.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','88',874,'6','1',5292066.00,5293365.57,1299.57,214429.05,0.00,0.00,0.00,0.00,0.00),('21','238','3','88',875,'9','1',4893075.37,4893075.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','88',876,'11','1',5609126.17,5609126.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','88',877,'13','2',2538840.04,2543081.41,4241.37,3469440.66,0.00,0.00,0.00,0.00,0.00),('21','238','5','88',878,'15','2',361505.32,363942.79,2437.47,1993850.46,0.00,0.00,0.00,0.00,0.00),('21','238','5','88',879,'16','2',190933.31,191241.25,307.94,251894.92,0.00,0.00,0.00,0.00,0.00),('21','238','6','88',880,'17','3',589664.73,589688.38,23.65,16555.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','89',881,'1','1',5675786.01,5675786.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','89',882,'2','1',4931994.27,4931994.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','89',883,'5','1',2277139.55,2277139.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','89',884,'6','1',5293365.57,5293365.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','89',885,'9','1',4893075.37,4893075.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','89',886,'11','1',5609126.17,5609126.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','89',887,'13','2',2543081.41,2543081.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','89',888,'15','2',363942.79,363942.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','89',889,'16','2',191241.25,191241.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','89',890,'17','3',589688.38,589688.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','90',891,'1','1',5675786.01,5675786.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','90',892,'2','1',4931994.27,4931994.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','90',893,'5','1',2277139.55,2277139.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','90',894,'6','1',5293365.57,5293365.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','90',895,'9','1',4893075.37,4893075.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','90',896,'11','1',5609126.17,5609126.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','90',897,'13','2',2543081.41,2543081.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','90',898,'15','2',363942.79,363942.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','90',899,'16','2',191241.25,191241.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','90',900,'17','3',589688.38,589770.75,82.37,57659.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','91',901,'1','1',5675786.01,5678839.85,3043.84,502233.60,0.00,0.00,10.00,0.00,0.00),('21','238','1','91',902,'2','1',4931994.27,4944862.31,12858.04,2121576.60,0.00,0.00,10.00,0.00,0.00),('21','238','2','91',903,'5','1',2277139.55,2278357.06,1207.51,199239.15,0.00,0.00,10.00,0.00,0.00),('21','238','2','91',904,'6','1',5293365.57,5307957.98,14582.41,2406097.65,0.00,0.00,10.00,0.00,0.00),('21','238','3','91',905,'9','1',4893075.37,4893075.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','91',906,'11','1',5609126.17,5609126.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','91',907,'13','2',2543081.41,2548906.05,5824.64,4764555.52,0.00,0.00,0.00,0.00,0.00),('21','238','5','91',908,'15','2',363942.79,366374.98,2432.19,1989531.42,0.00,0.00,0.00,0.00,0.00),('21','238','5','91',909,'16','2',191241.25,192166.09,924.84,756519.12,0.00,0.00,0.00,0.00,0.00),('21','238','6','91',910,'17','3',589770.75,589850.19,79.44,59580.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','92',911,'1','1',5678839.85,5682112.20,3272.35,539937.75,0.00,0.00,0.00,0.00,0.00),('21','238','1','92',912,'2','1',4944862.31,4949251.22,4388.91,724170.15,0.00,0.00,0.00,0.00,0.00),('21','238','2','92',913,'5','1',2278357.06,2278357.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','92',914,'6','1',5307957.98,5307957.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','92',915,'9','1',4893075.37,4893075.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','92',916,'11','1',5609126.17,5611069.73,1943.56,320687.40,0.00,0.00,0.00,0.00,0.00),('21','238','4','92',917,'13','2',2548906.05,2555724.48,6818.43,5577475.74,0.00,0.00,0.00,0.00,0.00),('21','238','5','92',918,'15','2',366374.98,366374.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','92',919,'16','2',192166.09,192166.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','92',920,'17','3',589850.19,589946.22,96.03,72022.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','93',921,'1','1',5682112.20,5682112.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','93',922,'2','1',4949251.22,4949251.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','93',923,'5','1',2278357.06,2278357.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','93',924,'6','1',5307957.98,5312378.18,4420.20,729333.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','93',925,'9','1',4893075.37,4893075.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','93',926,'11','1',5611069.73,5611357.02,287.29,47402.85,0.00,0.00,0.00,0.00,0.00),('21','238','4','93',927,'13','2',2555724.48,2560357.78,4633.30,3790039.40,0.00,0.00,0.00,0.00,0.00),('21','238','5','93',928,'15','2',366374.98,366374.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','93',929,'16','2',192166.09,192166.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','93',930,'17','3',589946.22,590096.65,150.43,112822.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','94',931,'1','1',5682112.20,5682112.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','94',932,'2','1',4949251.22,4949251.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','94',933,'5','1',2278357.06,2278357.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','94',934,'6','1',5312378.18,5312378.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','94',935,'9','1',4893075.37,4893075.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','94',936,'11','1',5611357.02,5611357.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','94',937,'13','2',2560357.78,2560357.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','94',938,'15','2',366374.98,366374.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','94',939,'16','2',192166.09,192166.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','94',940,'17','3',590096.65,590146.43,49.78,37335.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','95',941,'1','1',5682112.20,5682112.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','95',942,'2','1',4949251.22,4949251.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','95',943,'5','1',2278357.06,2278357.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','95',944,'6','1',5312378.18,5312378.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','95',945,'9','1',4893075.37,4893075.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','95',946,'11','1',5611357.02,5611357.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','95',947,'13','2',2560357.78,2560357.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','95',948,'15','2',366374.98,366374.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','95',949,'16','2',192166.09,192166.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','95',950,'17','3',590146.43,590249.77,103.34,77505.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','96',951,'1','1',5682112.20,5682112.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','96',952,'2','1',4949251.22,4949251.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','96',953,'5','1',2278357.06,2283386.60,4989.54,823274.10,0.00,0.00,40.00,0.00,0.00),('21','238','2','96',954,'6','1',5312378.18,5318291.36,5873.18,969074.70,0.00,0.00,40.00,0.00,0.00),('21','238','3','96',955,'9','1',4893075.37,4897569.11,4453.74,734867.10,0.00,0.00,40.00,0.00,0.00),('21','238','3','96',956,'11','1',5611357.02,5612392.75,995.73,164295.45,0.00,0.00,40.00,0.00,0.00),('21','238','4','96',957,'13','2',2560357.78,2561213.35,855.57,708411.96,0.00,0.00,0.00,0.00,0.00),('21','238','5','96',958,'15','2',366374.98,373086.67,6711.69,5557279.32,0.00,0.00,0.00,0.00,0.00),('21','238','5','96',959,'16','2',192166.09,193498.77,1332.68,1103459.04,0.00,0.00,0.00,0.00,0.00),('21','238','6','96',960,'17','3',590249.77,590317.05,67.28,50460.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','97',961,'1','1',5682112.20,5682112.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','97',962,'2','1',4949251.22,4949251.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','97',963,'5','1',2283386.60,2283386.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','97',964,'6','1',5318291.36,5318291.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','97',965,'9','1',4897569.11,4897569.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','97',966,'11','1',5612392.75,5612392.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','97',967,'13','2',2561213.35,2565594.21,4380.86,3627352.08,0.00,0.00,0.00,0.00,0.00),('21','238','5','97',968,'15','2',373086.67,375736.34,2649.67,2193926.76,0.00,0.00,0.00,0.00,0.00),('21','238','5','97',969,'16','2',193498.77,194247.24,748.47,619733.16,0.00,0.00,0.00,0.00,0.00),('21','238','6','97',970,'17','3',590317.05,590429.38,112.33,84247.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','98',971,'1','1',5682112.20,5682112.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','98',972,'2','1',4949251.22,4949251.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','98',973,'5','1',2283386.60,2291198.01,7811.41,1288882.65,0.00,0.00,0.00,0.00,0.00),('21','238','2','98',974,'6','1',5318291.36,5324894.46,6603.10,1089511.50,0.00,0.00,0.00,0.00,0.00),('21','238','3','98',975,'9','1',4897569.11,4902991.09,5421.98,894626.70,0.00,0.00,0.00,0.00,0.00),('21','238','3','98',976,'11','1',5612392.75,5612635.68,242.93,40083.45,0.00,0.00,0.00,0.00,0.00),('21','238','4','98',977,'13','2',2565594.21,2571405.65,5811.44,4811872.32,0.00,0.00,0.00,0.00,0.00),('21','238','5','98',978,'15','2',375736.34,378217.11,2480.77,2054077.56,0.00,0.00,0.00,0.00,0.00),('21','238','5','98',979,'16','2',194247.24,195339.95,1092.71,904763.88,0.00,0.00,0.00,0.00,0.00),('21','238','6','98',980,'17','3',590429.38,590516.78,87.40,65550.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','99',981,'1','1',5682112.20,5682112.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','99',982,'2','1',4949251.22,4949251.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','99',983,'5','1',2291198.01,2293677.42,2479.41,409102.65,0.00,0.00,0.00,0.00,0.00),('21','238','2','99',984,'6','1',5324894.46,5328632.17,3737.71,616722.15,0.00,0.00,0.00,0.00,0.00),('21','238','3','99',985,'9','1',4902991.09,4903884.00,892.91,147330.15,0.00,0.00,0.00,0.00,0.00),('21','238','3','99',986,'11','1',5612635.68,5614929.46,2293.78,378473.70,0.00,0.00,0.00,0.00,0.00),('21','238','4','99',987,'13','2',2571405.65,2575582.80,4177.15,3458680.20,0.00,0.00,0.00,0.00,0.00),('21','238','5','99',988,'15','2',378217.11,380651.67,2434.56,2015815.68,0.00,0.00,0.00,0.00,0.00),('21','238','5','99',989,'16','2',195339.95,196390.98,1051.03,870252.84,0.00,0.00,0.00,0.00,0.00),('21','238','6','99',990,'17','3',590516.78,590615.22,98.44,73830.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','100',991,'1','1',5682112.20,5682112.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','100',992,'2','1',4949251.22,4949251.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','100',993,'5','1',2293677.42,2293677.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','100',994,'6','1',5328632.17,5328632.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','100',995,'9','1',4903884.00,4903884.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','100',996,'11','1',5614929.46,5614929.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','100',997,'13','2',2575582.80,2575582.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','100',998,'15','2',380651.67,388883.54,8231.87,6815988.36,0.00,0.00,0.00,0.00,0.00),('21','238','5','100',999,'16','2',196390.98,197238.39,847.41,701655.48,0.00,0.00,0.00,0.00,0.00),('21','238','6','100',1000,'17','3',590615.22,590712.89,97.67,73252.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','101',1001,'1','1',5682112.20,5682112.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','101',1002,'2','1',4949251.22,4949251.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','101',1003,'5','1',2293677.42,2293677.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','101',1004,'6','1',5328632.17,5328632.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','101',1005,'9','1',4903884.00,4903884.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','101',1006,'11','1',5614929.46,5614929.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','101',1007,'13','2',2575582.80,2576277.59,664.79,550446.12,0.00,0.00,30.00,0.00,0.00),('21','238','5','101',1008,'15','2',388883.54,391936.33,3031.85,2510371.80,0.00,0.00,20.94,0.00,0.00),('21','238','5','101',1009,'16','2',197238.39,197864.03,625.64,518029.92,0.00,0.00,0.00,0.00,0.00),('21','238','6','101',1010,'17','3',590712.89,590812.33,99.44,74580.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','102',1011,'1','1',5682112.20,5682112.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','102',1012,'2','1',4949251.22,4949251.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','102',1013,'5','1',2293677.42,2293677.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','102',1014,'6','1',5328632.17,5328632.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','102',1015,'9','1',4903884.00,4903884.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','102',1016,'11','1',5614929.46,5614929.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','102',1017,'13','2',2576277.59,2581078.64,4801.05,3975269.40,0.00,0.00,0.00,0.00,0.00),('21','238','5','102',1018,'15','2',391936.33,394675.95,2739.62,2268405.36,0.00,0.00,0.00,0.00,0.00),('21','238','5','102',1019,'16','2',197864.03,200452.88,2588.85,2143567.80,0.00,0.00,0.00,0.00,0.00),('21','238','6','102',1020,'17','3',590812.33,590929.83,75.50,56625.00,0.00,0.00,42.00,0.00,0.00),('21','238','1','103',1021,'1','1',5682112.20,5682112.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','103',1022,'2','1',4949251.22,4949251.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','103',1023,'5','1',2293677.42,2293677.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','103',1024,'6','1',5328632.17,5328632.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','103',1025,'9','1',4903884.00,4903884.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','103',1026,'11','1',5614929.46,5614929.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','103',1027,'13','2',2581078.64,2584322.44,3243.80,2685866.40,0.00,0.00,0.00,0.00,0.00),('21','238','5','103',1028,'15','2',394675.95,397241.73,2565.78,2124465.84,0.00,0.00,0.00,0.00,0.00),('21','238','5','103',1029,'16','2',200452.88,201803.32,1350.44,1118164.32,0.00,0.00,0.00,0.00,0.00),('21','238','6','103',1030,'17','3',590929.83,590981.09,51.26,38445.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','104',1031,'1','1',5682112.20,5682112.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','104',1032,'2','1',4949251.22,4949251.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','104',1033,'5','1',2293677.42,2293677.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','104',1034,'6','1',5328632.17,5328632.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','104',1035,'9','1',4903884.00,4903884.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','104',1036,'11','1',5614929.46,5614929.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','104',1037,'13','2',2584322.44,2586919.31,2596.87,2150208.36,0.00,0.00,0.00,0.00,0.00),('21','238','5','104',1038,'15','2',397241.73,401448.82,4207.09,3483470.52,0.00,0.00,0.00,0.00,0.00),('21','238','5','104',1039,'16','2',201803.32,206159.07,4355.75,3606561.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','104',1040,'17','3',590981.09,591044.24,63.15,47362.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','105',1041,'1','1',5682112.20,5682112.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','105',1042,'2','1',4949251.22,4949251.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','105',1043,'5','1',2293677.42,2298599.46,4902.04,808836.60,0.00,0.00,20.00,0.00,0.00),('21','238','2','105',1044,'6','1',5328632.17,5334305.70,5653.53,932832.45,0.00,0.00,20.00,0.00,0.00),('21','238','3','105',1045,'9','1',4903884.00,4906076.11,2172.11,358398.15,0.00,0.00,20.00,0.00,0.00),('21','238','3','105',1046,'11','1',5614929.46,5617130.83,2181.37,359926.05,0.00,0.00,20.00,0.00,0.00),('21','238','4','105',1047,'13','2',2586919.31,2592031.99,5112.68,4233299.04,0.00,0.00,0.00,0.00,0.00),('21','238','5','105',1048,'15','2',401448.82,404875.66,3426.84,2837423.52,0.00,0.00,0.00,0.00,0.00),('21','238','5','105',1049,'16','2',206159.07,208181.25,2022.18,1674365.04,0.00,0.00,0.00,0.00,0.00),('21','238','6','105',1050,'17','3',591044.24,591149.04,104.80,78600.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','106',1051,'1','1',5682112.20,5682112.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','106',1052,'2','1',4949251.22,4949251.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','106',1053,'5','1',2298599.46,2298599.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','106',1054,'6','1',5334305.70,5337141.51,2805.81,462958.65,0.00,0.00,30.00,0.00,0.00),('21','238','3','106',1055,'9','1',4906076.11,4911018.49,4912.38,810542.70,0.00,0.00,30.00,0.00,0.00),('21','238','3','106',1056,'11','1',5617130.83,5623865.12,6694.29,1104557.85,0.00,0.00,40.00,0.00,0.00),('21','238','4','106',1057,'13','2',2592031.99,2596836.05,4804.06,3977761.68,0.00,0.00,0.00,0.00,0.00),('21','238','5','106',1058,'15','2',404875.66,409318.39,4442.73,3678580.44,0.00,0.00,0.00,0.00,0.00),('21','238','5','106',1059,'16','2',208181.25,210882.52,2701.27,2236651.56,0.00,0.00,0.00,0.00,0.00),('21','238','6','106',1060,'17','3',591149.04,591284.01,134.97,101227.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','107',1061,'1','1',5682112.20,5682112.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','107',1062,'2','1',4949251.22,4949251.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','107',1063,'5','1',2298599.46,2298599.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','107',1064,'6','1',5337141.51,5337644.68,503.17,83023.05,0.00,0.00,0.00,0.00,0.00),('21','238','3','107',1065,'9','1',4911018.49,4911018.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','107',1066,'11','1',5623865.12,5623865.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','107',1067,'13','2',2596836.05,2600592.30,3756.25,3110175.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','107',1068,'15','2',409318.39,412651.23,3332.84,2759591.52,0.00,0.00,0.00,0.00,0.00),('21','238','5','107',1069,'16','2',210882.52,211415.13,532.61,441001.08,0.00,0.00,0.00,0.00,0.00),('21','238','6','107',1070,'17','3',591284.01,591321.99,37.98,28485.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','108',1071,'1','1',5682112.20,5682112.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','108',1072,'2','1',4949251.22,4949251.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','108',1073,'5','1',2298599.46,2298599.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','108',1074,'6','1',5337644.68,5337749.51,104.83,17296.95,0.00,0.00,0.00,0.00,0.00),('21','238','3','108',1075,'9','1',4911018.49,4911018.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','108',1076,'11','1',5623865.12,5623865.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','108',1077,'13','2',2600592.30,2605408.74,4816.44,3988012.32,0.00,0.00,0.00,0.00,0.00),('21','238','5','108',1078,'15','2',412651.23,414115.79,1464.56,1212655.68,0.00,0.00,0.00,0.00,0.00),('21','238','5','108',1079,'16','2',211415.13,212361.97,946.84,783983.52,0.00,0.00,0.00,0.00,0.00),('21','238','6','108',1080,'17','3',591321.99,591396.28,74.29,55717.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','109',1081,'1','1',5682112.20,5682112.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','109',1082,'2','1',4949251.22,4949251.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','109',1083,'5','1',2298599.46,2298599.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','109',1084,'6','1',5337749.51,5337749.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','109',1085,'9','1',4911018.49,4911018.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','109',1086,'11','1',5623865.12,5623865.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','109',1087,'13','2',2605408.74,2607681.29,2272.55,1881671.40,0.00,0.00,0.00,0.00,0.00),('21','238','5','109',1088,'15','2',414115.79,415687.20,1571.41,1301127.48,0.00,0.00,0.00,0.00,0.00),('21','238','5','109',1089,'16','2',212361.97,215500.56,3138.59,2598752.52,0.00,0.00,0.00,0.00,0.00),('21','238','6','109',1090,'17','3',591396.28,591484.00,87.72,65790.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','110',1091,'1','1',5682112.20,5682112.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','110',1092,'2','1',4949251.22,4949251.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','110',1093,'5','1',2298599.46,2298599.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','110',1094,'6','1',5337749.51,5337749.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','110',1095,'9','1',4911018.49,4911018.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','110',1096,'11','1',5623865.12,5623865.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','110',1097,'13','2',2607681.29,2611286.68,3605.39,2985262.92,0.00,0.00,0.00,0.00,0.00),('21','238','5','110',1098,'15','2',415687.20,417008.68,1321.48,1094185.44,0.00,0.00,0.00,0.00,0.00),('21','238','5','110',1099,'16','2',215500.56,216372.82,872.26,722231.28,0.00,0.00,0.00,0.00,0.00),('21','238','6','110',1100,'17','3',591484.00,591581.60,97.60,73200.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','111',1101,'1','1',5682112.20,5682112.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','111',1102,'2','1',4949251.22,4949251.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','111',1103,'5','1',2298599.46,2298599.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','111',1104,'6','1',5337749.51,5337749.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','111',1105,'9','1',4911018.49,4911018.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','111',1106,'11','1',5623865.12,5623865.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','111',1107,'13','2',2611286.68,2614605.42,3318.74,2747916.72,0.00,0.00,0.00,0.00,0.00),('21','238','5','111',1108,'15','2',417008.68,419480.83,2472.15,2046940.20,0.00,0.00,0.00,0.00,0.00),('21','238','5','111',1109,'16','2',216372.82,217517.96,1145.14,948175.92,0.00,0.00,0.00,0.00,0.00),('21','238','6','111',1110,'17','3',591581.60,591711.77,130.17,97627.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','112',1111,'1','1',5682112.20,5682112.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','112',1112,'2','1',4949251.22,4949251.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','112',1113,'5','1',2298599.46,2298599.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','112',1114,'6','1',5337749.51,5337749.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','112',1115,'9','1',4911018.49,4911018.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','112',1116,'11','1',5623865.12,5623865.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','112',1117,'13','2',2614605.42,2617361.56,2756.14,2282083.92,0.00,0.00,0.00,0.00,0.00),('21','238','5','112',1118,'15','2',419480.83,422682.44,3201.61,2650933.08,0.00,0.00,0.00,0.00,0.00),('21','238','5','112',1119,'16','2',217517.96,219643.61,2125.65,1760038.20,0.00,0.00,0.00,0.00,0.00),('21','238','6','112',1120,'17','3',591711.77,591897.05,185.28,138960.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','113',1121,'1','1',5682112.20,5682112.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','113',1122,'2','1',4949251.22,4949251.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','113',1123,'5','1',2298599.46,2298599.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','113',1124,'6','1',5337749.51,5337749.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','113',1125,'9','1',4911018.49,4911018.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','113',1126,'11','1',5623865.12,5623865.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','113',1127,'13','2',2617361.56,2620246.15,2884.59,2388440.52,0.00,0.00,0.00,0.00,0.00),('21','238','5','113',1128,'15','2',422682.44,424199.50,1517.06,1256125.68,0.00,0.00,0.00,0.00,0.00),('21','238','5','113',1129,'16','2',219643.61,220382.88,739.27,612115.56,0.00,0.00,0.00,0.00,0.00),('21','238','6','113',1130,'17','3',591897.05,591985.52,88.47,66352.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','114',1131,'1','1',5682112.20,5682112.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','114',1132,'2','1',4949251.22,4949251.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','114',1133,'5','1',2298599.46,2303688.22,5058.76,834695.40,0.00,0.00,30.00,0.00,0.00),('21','238','2','114',1134,'6','1',5337749.51,5341984.28,4204.77,693787.05,0.00,0.00,30.00,0.00,0.00),('21','238','3','114',1135,'9','1',4911018.49,4916150.20,5101.71,841782.15,0.00,0.00,30.00,0.00,0.00),('21','238','3','114',1136,'11','1',5623865.12,5626638.23,2743.11,452613.15,0.00,0.00,30.00,0.00,0.00),('21','238','4','114',1137,'13','2',2620246.15,2622834.93,2588.78,2143509.84,0.00,0.00,0.00,0.00,0.00),('21','238','5','114',1138,'15','2',424199.50,425924.75,1725.25,1428507.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','114',1139,'16','2',220382.88,220833.84,450.96,373394.88,0.00,0.00,0.00,0.00,0.00),('21','238','6','114',1140,'17','3',591985.52,592115.94,130.42,97815.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','115',1141,'1','1',5682112.20,5682112.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','115',1142,'2','1',4949251.22,4949251.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','115',1143,'5','1',2303688.22,2303688.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','115',1144,'6','1',5341984.28,5341984.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','115',1145,'9','1',4916150.20,4916150.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','115',1146,'11','1',5626638.23,5626638.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','115',1147,'13','2',2622834.93,2624331.00,1496.07,1238745.96,0.00,0.00,0.00,0.00,0.00),('21','238','5','115',1148,'15','2',425924.75,427459.67,1534.92,1270913.76,0.00,0.00,0.00,0.00,0.00),('21','238','5','115',1149,'16','2',220833.84,221024.02,190.18,157469.04,0.00,0.00,0.00,0.00,0.00),('21','238','6','115',1150,'17','3',592115.94,592248.35,132.41,99307.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','116',1151,'1','1',5682112.20,5682112.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','116',1152,'2','1',4949251.22,4949251.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','116',1153,'5','1',2303688.22,2309333.33,5645.11,1044345.35,0.00,0.00,0.00,0.00,0.00),('21','238','2','116',1154,'6','1',5341984.28,5351510.91,9526.63,1762426.55,0.00,0.00,0.00,0.00,0.00),('21','238','3','116',1155,'9','1',4916150.20,4916150.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','116',1156,'11','1',5626638.23,5626638.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','116',1157,'13','2',2624331.00,2625640.07,1309.07,1083909.96,0.00,0.00,0.00,0.00,0.00),('21','238','5','116',1158,'15','2',427459.67,427459.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','116',1159,'16','2',221024.02,221024.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','116',1160,'17','3',592248.35,592310.47,62.12,46590.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','117',1161,'1','1',5682112.20,5682112.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','117',1162,'2','1',4949251.22,4949251.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','117',1163,'5','1',2309333.33,2309333.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','117',1164,'6','1',5351510.91,5351510.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','117',1165,'9','1',4916150.20,4916150.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','117',1166,'11','1',5626638.23,5626638.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','117',1167,'13','2',2625640.07,2626505.55,865.48,716617.44,0.00,0.00,0.00,0.00,0.00),('21','238','5','117',1168,'15','2',427459.67,428377.84,918.17,760244.76,0.00,0.00,0.00,0.00,0.00),('21','238','5','117',1169,'16','2',221024.02,221202.17,178.15,147508.20,0.00,0.00,0.00,0.00,0.00),('21','238','6','117',1170,'17','3',592310.47,592390.38,79.91,59932.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','118',1171,'1','1',5682112.20,5682112.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','118',1172,'2','1',4949251.22,4949251.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','118',1173,'5','1',2309333.33,2309333.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','118',1174,'6','1',5351510.91,5351510.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','118',1175,'9','1',4916150.20,4916150.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','118',1176,'11','1',5626638.23,5626638.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','118',1177,'13','2',2626505.55,2628592.61,2087.06,1728085.68,0.00,0.00,0.00,0.00,0.00),('21','238','5','118',1178,'15','2',428377.84,430303.54,1925.70,1594479.60,0.00,0.00,0.00,0.00,0.00),('21','238','5','118',1179,'16','2',221202.17,221631.63,429.46,355592.88,0.00,0.00,0.00,0.00,0.00),('21','238','6','118',1180,'17','3',592390.38,592518.56,128.18,96135.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','119',1181,'1','1',5682112.20,5682112.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','119',1182,'2','1',4949251.22,4949251.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','119',1183,'5','1',2309333.33,2309333.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','119',1184,'6','1',5351510.91,5351510.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','119',1185,'9','1',4916150.20,4916150.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','119',1186,'11','1',5626638.23,5626638.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','119',1187,'13','2',2628592.61,2632369.69,3777.08,3127422.24,0.00,0.00,0.00,0.00,0.00),('21','238','5','119',1188,'15','2',430303.54,432911.63,2608.09,2159498.52,0.00,0.00,0.00,0.00,0.00),('21','238','5','119',1189,'16','2',221631.63,223321.25,1689.62,1399005.36,0.00,0.00,0.00,0.00,0.00),('21','238','6','119',1190,'17','3',592518.56,592594.25,65.69,49267.50,0.00,0.00,10.00,0.00,0.00),('21','238','1','120',1191,'1','1',5682112.20,5682112.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','120',1192,'2','1',4949251.22,4949251.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','120',1193,'5','1',2309333.33,2320410.49,11047.16,2043724.60,0.00,0.00,30.00,0.00,0.00),('21','238','2','120',1194,'6','1',5351510.91,5365122.15,13581.24,2512529.40,0.00,0.00,30.00,0.00,0.00),('21','238','3','120',1195,'9','1',4916150.20,4925658.50,9478.30,1753485.50,0.00,0.00,30.00,0.00,0.00),('21','238','3','120',1196,'11','1',5626638.23,5628988.67,2320.44,429281.40,0.00,0.00,30.00,0.00,0.00),('21','238','4','120',1197,'13','2',2632369.69,2635240.05,2870.36,2376658.08,0.00,0.00,0.00,0.00,0.00),('21','238','5','120',1198,'15','2',432911.63,436465.76,3554.13,2942819.64,0.00,0.00,0.00,0.00,0.00),('21','238','5','120',1199,'16','2',223321.25,224959.22,1637.97,1356239.16,0.00,0.00,0.00,0.00,0.00),('21','238','6','120',1200,'17','3',592594.25,592666.65,72.40,54300.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','121',1201,'1','1',5682112.20,5682112.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','121',1202,'2','1',4949251.22,4949251.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','121',1203,'5','1',2320410.49,2321234.30,823.81,152404.85,0.00,0.00,0.00,0.00,0.00),('21','238','2','121',1204,'6','1',5365122.15,5369722.28,4600.13,851024.05,0.00,0.00,0.00,0.00,0.00),('21','238','3','121',1205,'9','1',4925658.50,4927367.08,1708.58,316087.30,0.00,0.00,0.00,0.00,0.00),('21','238','3','121',1206,'11','1',5628988.67,5630621.85,1633.18,302138.30,0.00,0.00,0.00,0.00,0.00),('21','238','4','121',1207,'13','2',2635240.05,2636979.18,1739.13,1439999.64,0.00,0.00,0.00,0.00,0.00),('21','238','5','121',1208,'15','2',436465.76,439048.04,2582.28,2138127.84,0.00,0.00,0.00,0.00,0.00),('21','238','5','121',1209,'16','2',224959.22,225184.89,225.67,186854.76,0.00,0.00,0.00,0.00,0.00),('21','238','6','121',1210,'17','3',592666.65,592719.02,52.37,39277.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','122',1211,'1','1',5682112.20,5682112.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','122',1212,'2','1',4949251.22,4949251.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','122',1213,'5','1',2321234.30,2327650.20,6375.90,1179541.50,0.00,0.00,40.00,0.00,0.00),('21','238','2','122',1214,'6','1',5369722.28,5378542.31,8780.03,1624305.55,0.00,0.00,40.00,0.00,0.00),('21','238','3','122',1215,'9','1',4927367.08,4927367.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','122',1216,'11','1',5630621.85,5630621.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','122',1217,'13','2',2636979.18,2640865.12,3885.94,3217558.32,0.00,0.00,0.00,0.00,0.00),('21','238','5','122',1218,'15','2',439048.04,442402.35,3354.31,2777368.68,0.00,0.00,0.00,0.00,0.00),('21','238','5','122',1219,'16','2',225184.89,225520.72,335.83,278067.24,0.00,0.00,0.00,0.00,0.00),('21','238','6','122',1220,'17','3',592719.02,592781.95,52.93,39697.50,0.00,0.00,10.00,0.00,0.00),('21','238','1','123',1221,'1','1',5682112.20,5682112.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','123',1222,'2','1',4949251.22,4949251.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','123',1223,'5','1',2327650.20,2327650.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','123',1224,'6','1',5378542.31,5378542.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','123',1225,'9','1',4927367.08,4927367.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','123',1226,'11','1',5630621.85,5630621.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','123',1227,'13','2',2640865.12,2643491.28,2626.16,2174460.48,0.00,0.00,0.00,0.00,0.00),('21','238','5','123',1228,'15','2',442402.35,443406.68,1004.33,831585.24,0.00,0.00,0.00,0.00,0.00),('21','238','5','123',1229,'16','2',225520.72,225684.32,163.60,135460.80,0.00,0.00,0.00,0.00,0.00),('21','238','6','123',1230,'17','3',592781.95,592974.21,182.26,136695.00,0.00,0.00,10.00,0.00,0.00),('21','238','1','124',1231,'1','1',5682112.20,5682112.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','124',1232,'2','1',4949251.22,4949251.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','124',1233,'5','1',2327650.20,2328573.02,922.82,170721.70,0.00,0.00,0.00,0.00,0.00),('21','238','2','124',1234,'6','1',5378542.31,5379421.65,879.34,162677.90,0.00,0.00,0.00,0.00,0.00),('21','238','3','124',1235,'9','1',4927367.08,4927367.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','124',1236,'11','1',5630621.85,5630621.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','124',1237,'13','2',2643491.28,2646733.76,3242.48,2684773.44,0.00,0.00,0.00,0.00,0.00),('21','238','5','124',1238,'15','2',443406.68,444211.43,804.75,666333.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','124',1239,'16','2',225684.32,227158.65,1474.33,1220745.24,0.00,0.00,0.00,0.00,0.00),('21','238','6','124',1240,'17','3',592974.21,593075.04,100.83,75622.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','125',1241,'1','1',5682112.20,5682112.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','125',1242,'2','1',4949251.22,4949251.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','125',1243,'5','1',2328573.02,2334445.92,5812.90,1104451.00,0.00,0.00,60.00,0.00,0.00),('21','238','2','125',1244,'6','1',5379421.65,5387187.29,7705.64,1464071.60,0.00,0.00,60.00,0.00,0.00),('21','238','3','125',1245,'9','1',4927367.08,4927367.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','125',1246,'11','1',5630621.85,5630621.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','125',1247,'13','2',2646733.76,2650957.23,4223.47,3497033.16,0.00,0.00,0.00,0.00,0.00),('21','238','5','125',1248,'15','2',444211.43,446716.53,2505.10,2074222.80,0.00,0.00,0.00,0.00,0.00),('21','238','5','125',1249,'16','2',227158.65,227371.17,212.52,175966.56,0.00,0.00,0.00,0.00,0.00),('21','238','6','125',1250,'17','3',593075.04,593214.12,139.08,104310.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','126',1251,'1','1',5682112.20,5682112.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','126',1252,'2','1',4949251.22,4949251.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','126',1253,'5','1',2334445.92,2334445.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','126',1254,'6','1',5387187.29,5387187.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','126',1255,'9','1',4927367.08,4927367.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','126',1256,'11','1',5630621.85,5630621.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','126',1257,'13','2',2650957.23,2653911.99,2954.76,2446541.28,0.00,0.00,0.00,0.00,0.00),('21','238','5','126',1258,'15','2',446716.53,447932.53,1216.00,1006848.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','126',1259,'16','2',227371.17,228882.22,1511.05,1251149.40,0.00,0.00,0.00,0.00,0.00),('21','238','6','126',1260,'17','3',593214.12,593323.98,109.86,82395.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','127',1261,'1','1',5682112.20,5682112.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','127',1262,'2','1',4949251.22,4949251.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','127',1263,'5','1',2334445.92,2334445.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','127',1264,'6','1',5387187.29,5387187.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','127',1265,'9','1',4927367.08,4927367.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','127',1266,'11','1',5630621.85,5630621.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','127',1267,'13','2',2653911.99,2656048.89,2136.90,1769353.20,0.00,0.00,0.00,0.00,0.00),('21','238','5','127',1268,'15','2',447932.53,450085.97,2153.44,1783048.32,0.00,0.00,0.00,0.00,0.00),('21','238','5','127',1269,'16','2',228882.22,229151.89,269.67,223286.76,0.00,0.00,0.00,0.00,0.00),('21','238','6','127',1270,'17','3',593323.98,593323.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','128',1271,'1','1',5682112.20,5682112.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','128',1272,'2','1',4949251.22,4949251.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','128',1273,'5','1',2334445.92,2342429.98,7984.06,1516971.40,0.00,0.00,0.00,0.00,0.00),('21','238','2','128',1274,'6','1',5387187.29,5395718.60,8531.31,1620948.90,0.00,0.00,0.00,0.00,0.00),('21','238','3','128',1275,'9','1',4927367.08,4927367.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','128',1276,'11','1',5630621.85,5630621.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','128',1277,'13','2',2656048.89,2658466.64,2417.75,2001897.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','128',1278,'15','2',450085.97,451894.15,1808.18,1497173.04,0.00,0.00,0.00,0.00,0.00),('21','238','5','128',1279,'16','2',229151.89,229978.71,826.82,684606.96,0.00,0.00,0.00,0.00,0.00),('21','238','6','128',1280,'17','3',593323.98,593401.86,77.88,58410.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','129',1281,'1','1',5682112.20,5682112.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','129',1282,'2','1',4949251.22,4949251.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','129',1283,'5','1',2342429.98,2348489.85,6059.87,1151375.30,0.00,0.00,0.00,0.00,0.00),('21','238','2','129',1284,'6','1',5395718.60,5404154.00,8435.40,1602726.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','129',1285,'9','1',4927367.08,4927367.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','129',1286,'11','1',5630621.85,5630621.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','129',1287,'13','2',2658466.64,2661420.00,2953.36,2401081.68,0.00,0.00,0.00,0.00,0.00),('21','238','5','129',1288,'15','2',451894.15,453550.99,1656.84,1347010.92,0.00,0.00,0.00,0.00,0.00),('21','238','5','129',1289,'16','2',229978.71,230460.21,481.50,391459.50,0.00,0.00,0.00,0.00,0.00),('21','238','6','129',1290,'17','3',593401.86,593476.57,54.71,41032.50,0.00,0.00,20.00,0.00,0.00),('21','238','1','130',1291,'1','1',5682112.20,5682112.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','130',1292,'2','1',4949251.22,4949251.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','130',1293,'5','1',2348489.85,2348489.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','130',1294,'6','1',5404154.00,5404154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','130',1295,'9','1',4927367.08,4927367.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','130',1296,'11','1',5630621.85,5630621.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','130',1297,'13','2',2661420.00,2666334.96,4914.96,3995862.48,0.00,0.00,0.00,0.00,0.00),('21','238','5','130',1298,'15','2',453550.99,456141.09,2590.10,2105751.30,0.00,0.00,0.00,0.00,0.00),('21','238','5','130',1299,'16','2',230460.21,231706.76,1246.55,1013445.15,0.00,0.00,0.00,0.00,0.00),('21','238','6','130',1300,'17','3',593476.57,593554.46,67.89,50917.50,0.00,0.00,10.00,0.00,0.00),('21','238','1','131',1301,'1','1',5682112.20,5682112.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','131',1302,'2','1',4949251.22,4949251.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','131',1303,'5','1',2348489.85,2348489.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','131',1304,'6','1',5404154.00,5404154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','131',1305,'9','1',4927367.08,4927367.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','131',1306,'11','1',5630621.85,5630621.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','131',1307,'13','2',2666334.96,2669785.06,3450.10,2804931.30,0.00,0.00,0.00,0.00,0.00),('21','238','5','131',1308,'15','2',456141.09,458238.71,2097.62,1705365.06,0.00,0.00,0.00,0.00,0.00),('21','238','5','131',1309,'16','2',231706.76,232368.42,661.66,537929.58,0.00,0.00,0.00,0.00,0.00),('21','238','6','131',1310,'17','3',593554.46,593688.06,133.60,100200.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','132',1311,'1','1',5682112.20,5682112.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','132',1312,'2','1',4949251.22,4949251.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','132',1313,'5','1',2348489.85,2348489.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','132',1314,'6','1',5404154.00,5404154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','132',1315,'9','1',4927367.08,4927367.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','132',1316,'11','1',5630621.85,5630621.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','132',1317,'13','2',2669785.06,2672271.79,2486.73,2021711.49,0.00,0.00,0.00,0.00,0.00),('21','238','5','132',1318,'15','2',458238.71,460170.78,1932.07,1570772.91,0.00,0.00,0.00,0.00,0.00),('21','238','5','132',1319,'16','2',232368.42,233843.61,1475.19,1199329.47,0.00,0.00,0.00,0.00,0.00),('21','238','6','132',1320,'17','3',593688.06,593771.35,83.29,62467.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','133',1321,'1','1',5682112.20,5682112.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','133',1322,'2','1',4949251.22,4949251.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','133',1323,'5','1',2348489.85,2348489.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','133',1324,'6','1',5404154.00,5404154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','133',1325,'9','1',4927367.08,4927367.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','133',1326,'11','1',5630621.85,5630621.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','133',1327,'13','2',2672271.79,2675850.16,3578.37,2909214.81,0.00,0.00,0.00,0.00,0.00),('21','238','5','133',1328,'15','2',460170.78,461696.68,1525.90,1240556.70,0.00,0.00,0.00,0.00,0.00),('21','238','5','133',1329,'16','2',233843.61,235376.05,1532.44,1245873.72,0.00,0.00,0.00,0.00,0.00),('21','238','6','133',1330,'17','3',593771.35,593880.65,109.30,81975.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','134',1331,'1','1',5682112.20,5682112.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','134',1332,'2','1',4949251.22,4949251.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','134',1333,'5','1',2348489.85,2348489.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','134',1334,'6','1',5404154.00,5404154.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','134',1335,'9','1',4927367.08,4927367.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','134',1336,'11','1',5630621.85,5630621.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','134',1337,'13','2',2675850.16,2675850.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','134',1338,'15','2',461696.68,461696.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','134',1339,'16','2',235376.05,235376.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','134',1340,'17','3',593880.65,593914.43,33.78,25335.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','135',1341,'1','1',5682112.20,5685309.80,3177.60,603744.00,0.00,0.00,20.00,0.00,0.00),('21','238','1','135',1342,'2','1',4949251.22,4952972.54,3704.21,703799.90,0.00,0.00,17.11,0.00,0.00),('21','238','2','135',1343,'5','1',2348489.85,2353417.72,4917.87,934395.30,0.00,0.00,10.00,0.00,0.00),('21','238','2','135',1344,'6','1',5404154.00,5407853.71,3679.71,699144.90,0.00,0.00,20.00,0.00,0.00),('21','238','3','135',1345,'9','1',4927367.08,4927367.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','135',1346,'11','1',5630621.85,5630621.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','135',1347,'13','2',2675850.16,2679041.43,3191.27,2594502.51,0.00,0.00,0.00,0.00,0.00),('21','238','5','135',1348,'15','2',461696.68,462559.84,863.16,701749.08,0.00,0.00,0.00,0.00,0.00),('21','238','5','135',1349,'16','2',235376.05,236243.69,867.64,705391.32,0.00,0.00,0.00,0.00,0.00),('21','238','6','135',1350,'17','3',593914.43,593963.13,48.70,40664.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','136',1351,'1','1',5685309.80,5688580.89,3261.09,619607.10,0.00,0.00,10.00,0.00,0.00),('21','238','1','136',1352,'2','1',4952972.54,4957752.65,4770.11,906320.90,0.00,0.00,10.00,0.00,0.00),('21','238','2','136',1353,'5','1',2353417.72,2356466.48,3048.76,579264.40,0.00,0.00,0.00,0.00,0.00),('21','238','2','136',1354,'6','1',5407853.71,5411462.69,3598.98,683806.20,0.00,0.00,10.00,0.00,0.00),('21','238','3','136',1355,'9','1',4927367.08,4927367.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','136',1356,'11','1',5630621.85,5630621.85,-10.00,-1900.00,0.00,0.00,10.00,0.00,0.00),('21','238','4','136',1357,'13','2',2679041.43,2682309.59,3268.16,2657014.08,0.00,0.00,0.00,0.00,0.00),('21','238','5','136',1358,'15','2',462559.84,465133.29,2573.45,2092214.85,0.00,0.00,0.00,0.00,0.00),('21','238','5','136',1359,'16','2',236243.69,236598.99,355.30,288858.90,0.00,0.00,0.00,0.00,0.00),('21','238','6','136',1360,'17','3',593963.13,594101.25,138.12,115330.20,0.00,0.00,0.00,0.00,0.00),('21','238','1','137',1361,'1','1',5688580.89,5688580.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','137',1362,'2','1',4957752.65,4957752.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','137',1363,'5','1',2356466.48,2363777.66,7281.18,1383424.20,0.00,0.00,30.00,0.00,0.00),('21','238','2','137',1364,'6','1',5411462.69,5421265.46,9772.77,1856826.30,0.00,0.00,30.00,0.00,0.00),('21','238','3','137',1365,'9','1',4927367.08,4927367.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','137',1366,'11','1',5630621.85,5630621.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','137',1367,'13','2',2682309.59,2686259.24,3949.65,3211065.45,0.00,0.00,0.00,0.00,0.00),('21','238','5','137',1368,'15','2',465133.29,467354.88,2221.59,1806152.67,0.00,0.00,0.00,0.00,0.00),('21','238','5','137',1369,'16','2',236598.99,237633.18,1034.19,840796.47,0.00,0.00,0.00,0.00,0.00),('21','238','6','137',1370,'17','3',594101.25,594147.88,46.63,38936.05,0.00,0.00,0.00,0.00,0.00),('21','238','1','138',1371,'1','1',5688580.89,5688580.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','138',1372,'2','1',4957752.65,4957752.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','138',1373,'5','1',2363777.66,2369664.54,5866.88,1114707.20,0.00,0.00,20.00,0.00,0.00),('21','238','2','138',1374,'6','1',5421265.46,5424227.24,2961.78,562738.20,0.00,0.00,0.00,0.00,0.00),('21','238','3','138',1375,'9','1',4927367.08,4929932.47,2545.39,483624.10,0.00,0.00,20.00,0.00,0.00),('21','238','3','138',1376,'11','1',5630621.85,5630621.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','138',1377,'13','2',2686259.24,2689810.24,3551.00,2886963.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','138',1378,'15','2',467354.88,471167.74,3812.86,3099855.18,0.00,0.00,0.00,0.00,0.00),('21','238','5','138',1379,'16','2',237633.18,238430.50,797.32,648221.16,0.00,0.00,0.00,0.00,0.00),('21','238','6','138',1380,'17','3',594147.88,594194.48,46.60,38911.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','139',1381,'1','1',5688580.89,5688580.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','139',1382,'2','1',4957752.65,4957752.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','139',1383,'5','1',2369664.54,2372992.28,3317.74,630370.60,0.00,0.00,10.00,0.00,0.00),('21','238','2','139',1384,'6','1',5424227.24,5426559.28,2322.04,441187.60,0.00,0.00,10.00,0.00,0.00),('21','238','3','139',1385,'9','1',4929932.47,4935070.32,5127.85,974291.50,0.00,0.00,10.00,0.00,0.00),('21','238','3','139',1386,'11','1',5630621.85,5634551.19,3919.34,744674.60,0.00,0.00,10.00,0.00,0.00),('21','238','4','139',1387,'13','2',2689810.24,2692224.45,2414.21,1962752.73,0.00,0.00,0.00,0.00,0.00),('21','238','5','139',1388,'15','2',471167.74,472532.92,1365.18,1109891.34,0.00,0.00,0.00,0.00,0.00),('21','238','5','139',1389,'16','2',238430.50,238496.83,66.33,53926.29,0.00,0.00,0.00,0.00,0.00),('21','238','6','139',1390,'17','3',594194.48,594252.76,58.28,48663.80,0.00,0.00,0.00,0.00,0.00),('21','238','1','140',1391,'1','1',5688580.89,5688580.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','140',1392,'2','1',4957752.65,4957752.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','140',1393,'5','1',2372992.28,2372992.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','140',1394,'6','1',5426559.28,5426559.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','140',1395,'9','1',4935070.32,4943146.37,8036.05,1526849.50,0.00,0.00,40.00,0.00,0.00),('21','238','3','140',1396,'11','1',5634551.19,5642424.18,7832.99,1488268.10,0.00,0.00,40.00,0.00,0.00),('21','238','4','140',1397,'13','2',2692224.45,2695360.67,3136.22,2549746.86,0.00,0.00,0.00,0.00,0.00),('21','238','5','140',1398,'15','2',472532.92,473822.90,1289.98,1048753.74,0.00,0.00,0.00,0.00,0.00),('21','238','5','140',1399,'16','2',238496.83,239675.86,1179.03,958551.39,0.00,0.00,0.00,0.00,0.00),('21','238','6','140',1400,'17','3',594252.76,594364.89,112.13,93628.55,0.00,0.00,0.00,0.00,0.00),('21','238','1','141',1401,'1','1',5688580.89,5688580.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','141',1402,'2','1',4957752.65,4957752.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','141',1403,'5','1',2372992.28,2382256.56,9234.28,1754513.20,0.00,0.00,30.00,0.00,0.00),('21','238','2','141',1404,'6','1',5426559.28,5432444.09,5864.81,1114313.90,0.00,0.00,20.00,0.00,0.00),('21','238','3','141',1405,'9','1',4943146.37,4943146.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','141',1406,'11','1',5642424.18,5642424.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','141',1407,'13','2',2695360.67,2701042.59,5681.92,4619400.96,0.00,0.00,0.00,0.00,0.00),('21','238','5','141',1408,'15','2',473822.90,476990.10,3167.20,2574933.60,0.00,0.00,0.00,0.00,0.00),('21','238','5','141',1409,'16','2',239675.86,240823.10,1147.24,932706.12,0.00,0.00,0.00,0.00,0.00),('21','238','6','141',1410,'17','3',594364.89,594434.56,69.67,58174.45,0.00,0.00,0.00,0.00,0.00),('21','238','1','142',1411,'1','1',5688580.89,5688580.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','142',1412,'2','1',4957752.65,4957752.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','142',1413,'5','1',2382256.56,2382256.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','142',1414,'6','1',5432444.09,5432444.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','142',1415,'9','1',4943146.37,4950896.86,7710.49,1464993.10,0.00,0.00,40.00,0.00,0.00),('21','238','3','142',1416,'11','1',5642424.18,5649792.86,7328.68,1392449.20,0.00,0.00,40.00,0.00,0.00),('21','238','4','142',1417,'13','2',2701042.59,2702625.33,1582.74,1286767.62,0.00,0.00,0.00,0.00,0.00),('21','238','5','142',1418,'15','2',476990.10,478577.27,1587.17,1290369.21,0.00,0.00,0.00,0.00,0.00),('21','238','5','142',1419,'16','2',240823.10,241115.10,292.00,237396.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','142',1420,'17','3',594434.56,594526.83,92.27,77045.45,0.00,0.00,0.00,0.00,0.00),('21','238','1','143',1421,'1','1',5688580.89,5688580.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','143',1422,'2','1',4957752.65,4957752.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','143',1423,'5','1',2382256.56,2388268.01,6011.45,1142175.50,0.00,0.00,0.00,0.00,0.00),('21','238','2','143',1424,'6','1',5432444.09,5438819.78,6375.69,1211381.10,0.00,0.00,0.00,0.00,0.00),('21','238','3','143',1425,'9','1',4950896.86,4955106.86,4210.00,799900.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','143',1426,'11','1',5649792.86,5654062.15,4269.29,811165.10,0.00,0.00,0.00,0.00,0.00),('21','238','4','143',1427,'13','2',2702625.33,2707026.78,4401.45,3578378.85,0.00,0.00,0.00,0.00,0.00),('21','238','5','143',1428,'15','2',478577.27,482442.18,3864.91,3142171.83,0.00,0.00,0.00,0.00,0.00),('21','238','5','143',1429,'16','2',241115.10,242048.75,933.65,759057.45,0.00,0.00,0.00,0.00,0.00),('21','238','6','143',1430,'17','3',594526.83,594606.28,79.45,66340.75,0.00,0.00,0.00,0.00,0.00),('21','238','1','144',1431,'1','1',5688580.89,5688580.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','144',1432,'2','1',4957752.65,4957752.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','144',1433,'5','1',2388268.01,2388268.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','144',1434,'6','1',5438819.78,5438819.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','144',1435,'9','1',4955106.86,4955106.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','144',1436,'11','1',5654062.15,5654062.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','144',1437,'13','2',2707026.78,2707026.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','144',1438,'15','2',482442.18,482442.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','144',1439,'16','2',242048.75,242048.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','144',1440,'17','3',594606.28,594606.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','145',1441,'1','1',5688580.89,5688580.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','145',1442,'2','1',4957752.65,4957752.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','145',1443,'5','1',2388268.01,2389125.22,837.21,159069.90,0.00,0.00,20.00,0.00,0.00),('21','238','2','145',1444,'6','1',5438819.78,5440406.52,1566.74,297680.60,0.00,0.00,20.00,0.00,0.00),('21','238','3','145',1445,'9','1',4955106.86,4958250.60,3143.74,597310.60,0.00,0.00,0.00,0.00,0.00),('21','238','3','145',1446,'11','1',5654062.15,5657551.68,3469.53,659210.70,0.00,0.00,20.00,0.00,0.00),('21','238','4','145',1447,'13','2',2707026.78,2709759.42,2732.64,2221636.32,0.00,0.00,0.00,0.00,0.00),('21','238','5','145',1448,'15','2',482442.18,485142.17,2699.99,2195091.87,0.00,0.00,0.00,0.00,0.00),('21','238','5','145',1449,'16','2',242048.75,244147.38,2098.63,1706186.19,0.00,0.00,0.00,0.00,0.00),('21','238','6','145',1450,'17','3',594606.28,594686.24,79.96,66766.60,0.00,0.00,0.00,0.00,0.00),('21','238','1','146',1451,'1','1',5688580.89,5688580.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','146',1452,'2','1',4957752.65,4957752.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','146',1453,'5','1',2389125.22,2396431.35,7296.13,1386264.70,0.00,0.00,10.00,0.00,0.00),('21','238','2','146',1454,'6','1',5440406.52,5448245.51,7828.99,1487508.10,0.00,0.00,10.00,0.00,0.00),('21','238','3','146',1455,'9','1',4958250.60,4966012.19,7751.59,1472802.10,0.00,0.00,10.00,0.00,0.00),('21','238','3','146',1456,'11','1',5657551.68,5664072.30,6510.62,1237017.80,0.00,0.00,10.00,0.00,0.00),('21','238','4','146',1457,'13','2',2709759.42,2715248.70,5489.28,4462784.64,0.00,0.00,0.00,0.00,0.00),('21','238','5','146',1458,'15','2',485142.17,485142.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','146',1459,'16','2',244147.38,244147.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','146',1460,'17','3',594686.24,594792.43,96.19,80318.65,0.00,0.00,10.00,0.00,0.00),('21','238','1','147',1461,'1','1',5688580.89,5688580.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','147',1462,'2','1',4957752.65,4957752.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','147',1463,'5','1',2396431.35,2404448.71,7977.36,1515698.40,0.00,0.00,40.00,0.00,0.00),('21','238','2','147',1464,'6','1',5448245.51,5455398.21,7112.70,1351413.00,0.00,0.00,40.00,0.00,0.00),('21','238','3','147',1465,'9','1',4966012.19,4966012.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','147',1466,'11','1',5664072.30,5664072.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','147',1467,'13','2',2715248.70,2718392.92,3144.22,2556250.86,0.00,0.00,0.00,0.00,0.00),('21','238','5','147',1468,'15','2',485142.17,485142.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','147',1469,'16','2',244147.38,244147.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','147',1470,'17','3',594792.43,594854.06,51.63,43111.05,0.00,0.00,10.00,0.00,0.00),('21','238','1','148',1471,'1','1',5688580.89,5688580.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','148',1472,'2','1',4957752.65,4957752.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','148',1473,'5','1',2404448.71,2411765.35,7296.64,1386361.60,0.00,0.00,20.00,0.00,0.00),('21','238','2','148',1474,'6','1',5455398.21,5463132.09,7733.88,1469437.20,0.00,0.00,0.00,0.00,0.00),('21','238','3','148',1475,'9','1',4966012.19,4966012.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','148',1476,'11','1',5664072.30,5664072.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','148',1477,'13','2',2718392.92,2718392.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','148',1478,'15','2',485142.17,486843.93,1701.76,1383530.88,0.00,0.00,0.00,0.00,0.00),('21','238','5','148',1479,'16','2',244147.38,245643.08,1495.70,1216004.10,0.00,0.00,0.00,0.00,0.00),('21','238','6','148',1480,'17','3',594854.06,594903.67,49.61,41424.35,0.00,0.00,0.00,0.00,0.00),('21','238','1','149',1481,'1','1',5688580.89,5688580.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','149',1482,'2','1',4957752.65,4957752.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','149',1483,'5','1',2411765.35,2411765.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','149',1484,'6','1',5463132.09,5463132.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','149',1485,'9','1',4966012.19,4966012.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','149',1486,'11','1',5664072.30,5664072.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','149',1487,'13','2',2718392.92,2718392.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','149',1488,'15','2',486843.93,489897.76,3053.83,2482763.79,0.00,0.00,0.00,0.00,0.00),('21','238','5','149',1489,'16','2',245643.08,247951.35,2308.27,1876623.51,0.00,0.00,0.00,0.00,0.00),('21','238','6','149',1490,'17','3',594903.67,594961.04,57.37,47903.95,0.00,0.00,0.00,0.00,0.00),('21','238','1','150',1491,'1','1',5688580.89,5688580.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','150',1492,'2','1',4957752.65,4957752.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','150',1493,'5','1',2411765.35,2418923.69,7110.97,1351084.30,0.00,0.00,47.37,0.00,0.00),('21','238','2','150',1494,'6','1',5463132.09,5471126.43,7984.34,1517024.60,0.00,0.00,10.00,0.00,0.00),('21','238','3','150',1495,'9','1',4966012.19,4966012.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','150',1496,'11','1',5664072.30,5664072.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','150',1497,'13','2',2718392.92,2718392.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','150',1498,'15','2',489897.76,494639.07,4741.31,3854685.03,0.00,0.00,0.00,0.00,0.00),('21','238','5','150',1499,'16','2',247951.35,251319.10,3367.75,2737980.75,0.00,0.00,0.00,0.00,0.00),('21','238','6','150',1500,'17','3',594961.04,595014.56,53.52,44689.20,0.00,0.00,0.00,0.00,0.00),('21','238','1','151',1501,'1','1',5688580.89,5688580.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','151',1502,'2','1',4957752.65,4957752.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','151',1503,'5','1',2418923.69,2418923.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','151',1504,'6','1',5471126.43,5471126.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','151',1505,'9','1',4966012.19,4966012.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','151',1506,'11','1',5664072.30,5664072.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','151',1507,'13','2',2718392.92,2725888.87,7495.95,6094207.35,0.00,0.00,0.00,0.00,0.00),('21','238','5','151',1508,'15','2',494639.07,494639.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','151',1509,'16','2',251319.10,251319.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','151',1510,'17','3',595014.56,595038.35,23.79,19864.65,0.00,0.00,0.00,0.00,0.00),('21','238','1','152',1511,'1','1',5688580.89,5688580.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','152',1512,'2','1',4957752.65,4957752.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','152',1513,'5','1',2418923.69,2424487.14,5553.45,1055155.50,0.00,0.00,10.00,0.00,0.00),('21','238','2','152',1514,'6','1',5471126.43,5475107.80,3971.37,754560.30,0.00,0.00,10.00,0.00,0.00),('21','238','3','152',1515,'9','1',4966012.19,4971458.67,5436.48,1032931.20,0.00,0.00,10.00,0.00,0.00),('21','238','3','152',1516,'11','1',5664072.30,5668230.89,4148.59,788232.10,0.00,0.00,10.00,0.00,0.00),('21','238','4','152',1517,'13','2',2725888.87,2732757.45,6868.58,5584155.54,0.00,0.00,0.00,0.00,0.00),('21','238','5','152',1518,'15','2',494639.07,495879.98,1240.91,1008859.83,0.00,0.00,0.00,0.00,0.00),('21','238','5','152',1519,'16','2',251319.10,252072.91,753.81,612847.53,0.00,0.00,0.00,0.00,0.00),('21','238','6','152',1520,'17','3',595038.35,595080.86,42.51,35495.85,0.00,0.00,0.00,0.00,0.00),('21','238','1','153',1521,'1','1',5688580.89,5688580.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','153',1522,'2','1',4957752.65,4957752.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','153',1523,'5','1',2424487.14,2424487.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','153',1524,'6','1',5475107.80,5475107.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','153',1525,'9','1',4971458.67,4971458.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','153',1526,'11','1',5668230.89,5668230.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','153',1527,'13','2',2732757.45,2732757.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','153',1528,'15','2',495879.98,495879.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','153',1529,'16','2',252072.91,252072.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','153',1530,'17','3',595080.86,595101.38,20.52,17134.20,0.00,0.00,0.00,0.00,0.00),('21','238','1','154',1531,'1','1',5688580.89,5688580.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','154',1532,'2','1',4957752.65,4957752.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','154',1533,'5','1',2424487.14,2431638.54,7131.40,1354966.00,0.00,0.00,20.00,0.00,0.00),('21','238','2','154',1534,'6','1',5475107.80,5482870.62,7742.82,1471135.80,0.00,0.00,20.00,0.00,0.00),('21','238','3','154',1535,'9','1',4971458.67,4974034.61,2555.94,485628.60,0.00,0.00,20.00,0.00,0.00),('21','238','3','154',1536,'11','1',5668230.89,5671084.41,2813.52,534568.80,0.00,0.00,40.00,0.00,0.00),('21','238','4','154',1537,'13','2',2732757.45,2737395.59,4638.14,3770807.82,0.00,0.00,0.00,0.00,0.00),('21','238','5','154',1538,'15','2',495879.98,500185.13,4305.15,3500086.95,0.00,0.00,0.00,0.00,0.00),('21','238','5','154',1539,'16','2',252072.91,252842.75,769.84,625879.92,0.00,0.00,0.00,0.00,0.00),('21','238','6','154',1540,'17','3',595101.38,595146.04,24.66,20961.00,0.00,0.00,20.00,0.00,0.00),('21','238','1','155',1541,'1','1',5688580.89,5688580.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','155',1542,'2','1',4957752.65,4957752.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','155',1543,'5','1',2431638.54,2433554.16,1905.62,362067.80,0.00,0.00,10.00,0.00,0.00),('21','238','2','155',1544,'6','1',5482870.62,5486930.71,4050.09,769517.10,0.00,0.00,10.00,0.00,0.00),('21','238','3','155',1545,'9','1',4974034.61,4974034.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','155',1546,'11','1',5671084.41,5671084.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','155',1547,'13','2',2737395.59,2739796.94,2401.35,1952297.55,0.00,0.00,0.00,0.00,0.00),('21','238','5','155',1548,'15','2',500185.13,502004.43,1819.30,1479090.90,0.00,0.00,0.00,0.00,0.00),('21','238','5','155',1549,'16','2',252842.75,253240.85,398.10,323655.30,0.00,0.00,0.00,0.00,0.00),('21','238','6','155',1550,'17','3',595146.04,595177.18,31.14,26469.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','156',1551,'1','1',5688580.89,5688580.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','156',1552,'2','1',4957752.65,4957752.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','156',1553,'5','1',2433554.16,2439353.32,5779.16,1098040.40,0.00,0.00,20.00,0.00,0.00),('21','238','2','156',1554,'6','1',5486930.71,5495164.38,8213.67,1560597.30,0.00,0.00,20.00,0.00,0.00),('21','238','3','156',1555,'9','1',4974034.61,4974034.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','156',1556,'11','1',5671084.41,5671084.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','156',1557,'13','2',2739796.94,2742188.85,2391.91,1944622.83,0.00,0.00,0.00,0.00,0.00),('21','238','5','156',1558,'15','2',502004.43,503413.11,1408.68,1145256.84,0.00,0.00,0.00,0.00,0.00),('21','238','5','156',1559,'16','2',253240.85,254570.06,1329.21,1080647.73,0.00,0.00,0.00,0.00,0.00),('21','238','6','156',1560,'17','3',595177.18,595231.18,54.00,45900.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','157',1561,'1','1',5688580.89,5688580.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','157',1562,'2','1',4957752.65,4957752.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','157',1563,'5','1',2439353.32,2439353.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','157',1564,'6','1',5495164.38,5495164.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','157',1565,'9','1',4974034.61,4974034.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','157',1566,'11','1',5671084.41,5671084.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','157',1567,'13','2',2742188.85,2743976.34,1787.49,1453229.37,0.00,0.00,0.00,0.00,0.00),('21','238','5','157',1568,'15','2',503413.11,505623.40,2210.29,1796965.77,0.00,0.00,0.00,0.00,0.00),('21','238','5','157',1569,'16','2',254570.06,255370.84,800.78,651034.14,0.00,0.00,0.00,0.00,0.00),('21','238','6','157',1570,'17','3',595231.18,595270.00,38.82,32997.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','158',1571,'1','1',5688580.89,5688580.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','158',1572,'2','1',4957752.65,4957752.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','158',1573,'5','1',2439353.32,2441736.25,2382.93,452756.70,0.00,0.00,0.00,0.00,0.00),('21','238','2','158',1574,'6','1',5495164.38,5497193.39,2029.01,385511.90,0.00,0.00,0.00,0.00,0.00),('21','238','3','158',1575,'9','1',4974034.61,4975660.61,1616.00,307040.00,0.00,0.00,10.00,0.00,0.00),('21','238','3','158',1576,'11','1',5671084.41,5672776.82,1692.41,321557.90,0.00,0.00,0.00,0.00,0.00),('21','238','4','158',1577,'13','2',2743976.34,2748361.07,4384.73,3564785.49,0.00,0.00,0.00,0.00,0.00),('21','238','5','158',1578,'15','2',505623.40,507875.25,2251.85,1830754.05,0.00,0.00,0.00,0.00,0.00),('21','238','5','158',1579,'16','2',255370.84,256918.36,1547.52,1258133.76,0.00,0.00,0.00,0.00,0.00),('21','238','6','158',1580,'17','3',595270.00,595319.57,49.57,42134.50,0.00,0.00,0.00,0.00,0.00),('21','238','1','159',1581,'1','1',5688580.89,5690630.90,2040.01,387601.90,0.00,0.00,10.00,0.00,0.00),('21','238','1','159',1582,'2','1',4957752.65,4958705.94,953.29,181125.10,0.00,0.00,0.00,0.00,0.00),('21','238','2','159',1583,'5','1',2441736.25,2444998.54,3262.29,619835.10,0.00,0.00,0.00,0.00,0.00),('21','238','2','159',1584,'6','1',5497193.39,5499714.88,2521.49,479083.10,0.00,0.00,0.00,0.00,0.00),('21','238','3','159',1585,'9','1',4975660.61,4978157.93,2497.32,474490.80,0.00,0.00,0.00,0.00,0.00),('21','238','3','159',1586,'11','1',5672776.82,5675216.33,2439.51,463506.90,0.00,0.00,0.00,0.00,0.00),('21','238','4','159',1587,'13','2',2748361.07,2754762.51,6401.44,5204370.72,0.00,0.00,0.00,0.00,0.00),('21','238','5','159',1588,'15','2',507875.25,509348.84,1473.59,1198028.67,0.00,0.00,0.00,0.00,0.00),('21','238','5','159',1589,'16','2',256918.36,257077.33,158.97,129242.61,0.00,0.00,0.00,0.00,0.00),('21','238','6','159',1590,'17','3',595319.57,595361.13,41.56,35326.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','160',1591,'1','1',5690630.90,5693818.90,3188.00,605720.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','160',1592,'2','1',4958705.94,4959946.78,1240.84,235759.60,0.00,0.00,0.00,0.00,0.00),('21','238','2','160',1593,'5','1',2444998.54,2446305.39,1306.85,248301.50,0.00,0.00,0.00,0.00,0.00),('21','238','2','160',1594,'6','1',5499714.88,5502869.15,3154.27,599311.30,0.00,0.00,0.00,0.00,0.00),('21','238','3','160',1595,'9','1',4978157.93,4981245.52,3087.59,586642.10,0.00,0.00,0.00,0.00,0.00),('21','238','3','160',1596,'11','1',5675216.33,5677491.49,2275.16,432280.40,0.00,0.00,0.00,0.00,0.00),('21','238','4','160',1597,'13','2',2754762.51,2759398.58,4636.07,3769124.91,0.00,0.00,0.00,0.00,0.00),('21','238','5','160',1598,'15','2',509348.84,511069.35,1720.51,1398774.63,0.00,0.00,0.00,0.00,0.00),('21','238','5','160',1599,'16','2',257077.33,257674.00,596.67,485092.71,0.00,0.00,0.00,0.00,0.00),('21','238','6','160',1600,'17','3',595361.13,595399.88,38.75,33325.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','161',1601,'1','1',5693818.90,5695446.92,1628.02,309323.80,0.00,0.00,0.00,0.00,0.00),('21','238','1','161',1602,'2','1',4959946.78,4963795.35,3838.57,729328.30,0.00,0.00,10.00,0.00,0.00),('21','238','2','161',1603,'5','1',2446305.39,2446305.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','161',1604,'6','1',5502869.15,5507284.60,4415.45,838935.50,0.00,0.00,0.00,0.00,0.00),('21','238','3','161',1605,'9','1',4981245.52,4985611.30,4365.78,829498.20,0.00,0.00,0.00,0.00,0.00),('21','238','3','161',1606,'11','1',5677491.49,5680485.12,2993.63,568789.70,0.00,0.00,0.00,0.00,0.00),('21','238','4','161',1607,'13','2',2759398.58,2762191.10,2792.52,2228430.96,0.00,0.00,0.00,0.00,0.00),('21','238','5','161',1608,'15','2',511069.35,512974.33,1904.98,1520174.04,0.00,0.00,0.00,0.00,0.00),('21','238','5','161',1609,'16','2',257674.00,258746.05,1072.05,855495.90,0.00,0.00,0.00,0.00,0.00),('21','238','6','161',1610,'17','3',595399.88,595473.24,73.36,63089.60,0.00,0.00,0.00,0.00,0.00),('21','238','1','162',1611,'1','1',5695446.92,5697676.12,2229.20,423548.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','162',1612,'2','1',4963795.35,4967746.86,3951.51,750786.90,0.00,0.00,0.00,0.00,0.00),('21','238','2','162',1613,'5','1',2446305.39,2446305.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','162',1614,'6','1',5507284.60,5511903.44,4618.84,877579.60,0.00,0.00,0.00,0.00,0.00),('21','238','3','162',1615,'9','1',4985611.30,4990125.52,4514.22,857701.80,0.00,0.00,0.00,0.00,0.00),('21','238','3','162',1616,'11','1',5680485.12,5683045.03,2559.91,486382.90,0.00,0.00,0.00,0.00,0.00),('21','238','4','162',1617,'13','2',2762191.10,2763897.19,1706.09,1361459.82,0.00,0.00,0.00,0.00,0.00),('21','238','5','162',1618,'15','2',512974.33,514357.95,1383.62,1104128.76,0.00,0.00,0.00,0.00,0.00),('21','238','5','162',1619,'16','2',258746.05,260552.62,1806.57,1441642.86,0.00,0.00,0.00,0.00,0.00),('21','238','6','162',1620,'17','3',595473.24,595513.62,40.38,34726.80,0.00,0.00,0.00,0.00,0.00),('21','238','1','163',1621,'1','1',5697676.12,5698725.66,1039.54,197512.60,0.00,0.00,10.00,0.00,0.00),('21','238','1','163',1622,'2','1',4967746.86,4971709.80,3952.94,751058.60,0.00,0.00,10.00,0.00,0.00),('21','238','2','163',1623,'5','1',2446305.39,2446305.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','163',1624,'6','1',5511903.44,5516585.32,4671.88,887657.20,0.00,0.00,10.00,0.00,0.00),('21','238','3','163',1625,'9','1',4990125.52,4994760.14,4624.62,878677.80,0.00,0.00,10.00,0.00,0.00),('21','238','3','163',1626,'11','1',5683045.03,5685549.05,2484.02,471963.80,0.00,0.00,20.00,0.00,0.00),('21','238','4','163',1627,'13','2',2763897.19,2768893.78,4996.59,3987278.82,0.00,0.00,0.00,0.00,0.00),('21','238','5','163',1628,'15','2',514357.95,515123.78,765.83,611132.34,0.00,0.00,0.00,0.00,0.00),('21','238','5','163',1629,'16','2',260552.62,260552.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','163',1630,'17','3',595513.62,595547.60,33.98,29222.80,0.00,0.00,0.00,0.00,0.00),('21','238','1','164',1631,'1','1',5698725.66,5698725.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','164',1632,'2','1',4971709.80,4976601.17,4891.37,929360.30,0.00,0.00,0.00,0.00,0.00),('21','238','2','164',1633,'5','1',2446305.39,2446305.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','164',1634,'6','1',5516585.32,5520510.82,3915.50,743945.00,0.00,0.00,10.00,0.00,0.00),('21','238','3','164',1635,'9','1',4994760.14,4999399.46,4639.32,881470.80,0.00,0.00,0.00,0.00,0.00),('21','238','3','164',1636,'11','1',5685549.05,5688597.74,3048.69,579251.10,0.00,0.00,0.00,0.00,0.00),('21','238','4','164',1637,'13','2',2768893.78,2776158.93,7265.15,5797589.70,0.00,0.00,0.00,0.00,0.00),('21','238','5','164',1638,'15','2',515123.78,515123.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','164',1639,'16','2',260552.62,260552.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','164',1640,'17','3',595547.60,595581.11,33.51,28818.60,0.00,0.00,0.00,0.00,0.00),('21','238','1','165',1641,'1','1',5698725.66,5700272.99,1537.33,292092.70,0.00,0.00,10.00,0.00,0.00),('21','238','1','165',1642,'2','1',4976601.17,4979859.34,3238.17,615252.30,0.00,0.00,20.00,0.00,0.00),('21','238','2','165',1643,'5','1',2446305.39,2446305.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','165',1644,'6','1',5520510.82,5526773.68,6252.86,1188043.40,0.00,0.00,10.00,0.00,0.00),('21','238','3','165',1645,'9','1',4999399.46,5001773.19,2363.73,449108.70,0.00,0.00,10.00,0.00,0.00),('21','238','3','165',1646,'11','1',5688597.74,5690178.29,1570.55,298404.50,0.00,0.00,10.00,0.00,0.00),('21','238','4','165',1647,'13','2',2776158.93,2778136.44,1977.51,1578052.98,0.00,0.00,0.00,0.00,0.00),('21','238','5','165',1648,'15','2',515123.78,515571.13,447.35,356985.30,0.00,0.00,0.00,0.00,0.00),('21','238','5','165',1649,'16','2',260552.62,260605.90,53.28,42517.44,0.00,0.00,0.00,0.00,0.00),('21','238','6','165',1650,'17','3',595581.11,595635.48,44.37,38158.20,0.00,0.00,10.00,0.00,0.00),('21','238','1','166',1651,'1','1',5700272.99,5701002.63,729.64,138631.60,0.00,0.00,0.00,0.00,0.00),('21','238','1','166',1652,'2','1',4979859.34,4984666.58,4807.24,913375.60,0.00,0.00,0.00,0.00,0.00),('21','238','2','166',1653,'5','1',2446305.39,2446305.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','166',1654,'6','1',5526773.68,5527801.85,1028.17,195352.30,0.00,0.00,0.00,0.00,0.00),('21','238','3','166',1655,'9','1',5001773.19,5007680.98,5907.79,1122480.10,0.00,0.00,0.00,0.00,0.00),('21','238','3','166',1656,'11','1',5690178.29,5693820.11,3641.82,691945.80,0.00,0.00,0.00,0.00,0.00),('21','238','4','166',1657,'13','2',2778136.44,2779943.00,1806.56,1441634.88,0.00,0.00,0.00,0.00,0.00),('21','238','5','166',1658,'15','2',515571.13,516359.11,787.98,628808.04,0.00,0.00,0.00,0.00,0.00),('21','238','5','166',1659,'16','2',260605.90,261030.32,424.42,338687.16,0.00,0.00,0.00,0.00,0.00),('21','238','6','166',1660,'17','3',595635.48,595665.23,29.75,25585.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','167',1661,'1','1',5701002.63,5703417.35,2414.72,458796.80,0.00,0.00,0.00,0.00,0.00),('21','238','1','167',1662,'2','1',4984666.58,4989965.88,5299.30,1006867.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','167',1663,'5','1',2446305.39,2446305.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','167',1664,'6','1',5527801.85,5527801.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','167',1665,'9','1',5007680.98,5010701.55,3020.57,573908.30,0.00,0.00,0.00,0.00,0.00),('21','238','3','167',1666,'11','1',5693820.11,5696306.23,2486.12,472362.80,0.00,0.00,0.00,0.00,0.00),('21','238','4','167',1667,'13','2',2779943.00,2783992.96,4049.96,3231868.08,0.00,0.00,0.00,0.00,0.00),('21','238','5','167',1668,'15','2',516359.11,518037.06,1677.95,1339004.10,0.00,0.00,0.00,0.00,0.00),('21','238','5','167',1669,'16','2',261030.32,261340.80,310.48,247763.04,0.00,0.00,0.00,0.00,0.00),('21','238','6','167',1670,'17','3',595665.23,595699.14,33.91,29162.60,0.00,0.00,0.00,0.00,0.00),('21','238','1','168',1671,'1','1',5703417.35,5703450.44,33.09,6287.10,0.00,0.00,0.00,0.00,0.00),('21','238','1','168',1672,'2','1',4989965.88,4991316.97,1351.09,256707.10,0.00,0.00,0.00,0.00,0.00),('21','238','2','168',1673,'5','1',2446305.39,2446305.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','168',1674,'6','1',5527801.85,5533219.84,5407.99,1027518.10,0.00,0.00,10.00,0.00,0.00),('21','238','3','168',1675,'9','1',5010701.55,5015906.41,5204.86,988923.40,0.00,0.00,0.00,0.00,0.00),('21','238','3','168',1676,'11','1',5696306.23,5700217.13,3910.90,743071.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','168',1677,'13','2',2783992.96,2785089.40,1096.44,874959.12,0.00,0.00,0.00,0.00,0.00),('21','238','5','168',1678,'15','2',518037.06,519494.21,1457.15,1162805.70,0.00,0.00,0.00,0.00,0.00),('21','238','5','168',1679,'16','2',261340.80,263288.25,1947.45,1554065.10,0.00,0.00,0.00,0.00,0.00),('21','238','6','168',1680,'17','3',595699.14,595721.48,22.34,19212.40,0.00,0.00,0.00,0.00,0.00),('21','238','1','169',1681,'1','1',5703450.44,5703450.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','169',1682,'2','1',4991316.97,4991876.04,559.07,106223.30,0.00,0.00,0.00,0.00,0.00),('21','238','2','169',1683,'5','1',2446305.39,2446305.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','169',1684,'6','1',5533219.84,5537127.55,3907.71,742464.90,0.00,0.00,0.00,0.00,0.00),('21','238','3','169',1685,'9','1',5015906.41,5019504.93,3598.52,683718.80,0.00,0.00,0.00,0.00,0.00),('21','238','3','169',1686,'11','1',5700217.13,5703818.83,3601.70,684323.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','169',1687,'13','2',2785089.40,2785934.62,845.22,674485.56,0.00,0.00,0.00,0.00,0.00),('21','238','5','169',1688,'15','2',519494.21,522692.18,3197.97,2551980.06,0.00,0.00,0.00,0.00,0.00),('21','238','5','169',1689,'16','2',263288.25,264748.78,1460.53,1165502.94,0.00,0.00,0.00,0.00,0.00),('21','238','6','169',1690,'17','3',595721.48,595772.82,51.34,44152.40,0.00,0.00,0.00,0.00,0.00),('21','238','1','170',1691,'1','1',5703450.44,5704259.46,809.02,153713.80,0.00,0.00,0.00,0.00,0.00),('21','238','1','170',1692,'2','1',4991876.04,4996023.71,4147.67,788057.30,0.00,0.00,0.00,0.00,0.00),('21','238','2','170',1693,'5','1',2446305.39,2446305.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','170',1694,'6','1',5537127.55,5541010.23,3872.68,735809.20,0.00,0.00,10.00,0.00,0.00),('21','238','3','170',1695,'9','1',5019504.93,5022829.48,3314.55,629764.50,0.00,0.00,10.00,0.00,0.00),('21','238','3','170',1696,'11','1',5703818.83,5706314.35,2495.52,474148.80,0.00,0.00,0.00,0.00,0.00),('21','238','4','170',1697,'13','2',2785934.62,2786934.62,1000.00,798000.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','170',1698,'15','2',522692.18,525378.90,2686.72,2144002.56,0.00,0.00,0.00,0.00,0.00),('21','238','5','170',1699,'16','2',264748.78,266410.93,1662.15,1326395.70,0.00,0.00,0.00,0.00,0.00),('21','238','6','170',1700,'17','3',595772.82,595811.31,38.49,33101.40,0.00,0.00,0.00,0.00,0.00),('21','238','1','171',1701,'1','1',5704259.46,5706171.73,1902.27,361431.30,0.00,0.00,10.00,0.00,0.00),('21','238','1','171',1702,'2','1',4996023.71,4999578.44,3544.73,673498.70,0.00,0.00,10.00,0.00,0.00),('21','238','2','171',1703,'5','1',2446305.39,2446305.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','171',1704,'6','1',5541010.23,5543946.96,2926.73,556078.70,0.00,0.00,10.00,0.00,0.00),('21','238','3','171',1705,'9','1',5022829.48,5025851.57,3012.09,572297.10,0.00,0.00,10.00,0.00,0.00),('21','238','3','171',1706,'11','1',5706314.35,5709326.27,2991.92,568464.80,0.00,0.00,20.00,0.00,0.00),('21','238','4','171',1707,'13','2',2786934.62,2788914.33,1979.71,1579808.58,0.00,0.00,0.00,0.00,0.00),('21','238','5','171',1708,'15','2',525378.90,528427.06,3048.16,2432431.68,0.00,0.00,0.00,0.00,0.00),('21','238','5','171',1709,'16','2',266410.93,267425.93,1015.00,809970.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','171',1710,'17','3',595811.31,595852.80,41.49,35681.40,0.00,0.00,0.00,0.00,0.00),('21','238','1','172',1711,'1','1',5706171.73,5709027.21,2855.48,542541.20,0.00,0.00,0.00,0.00,0.00),('21','238','1','172',1712,'2','1',4999578.44,5002352.97,2774.53,527160.70,0.00,0.00,0.00,0.00,0.00),('21','238','2','172',1713,'5','1',2446305.39,2446305.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','172',1714,'6','1',5543946.96,5547923.17,3976.21,755479.90,0.00,0.00,0.00,0.00,0.00),('21','238','3','172',1715,'9','1',5025851.57,5030246.70,4395.13,835074.70,0.00,0.00,0.00,0.00,0.00),('21','238','3','172',1716,'11','1',5709326.27,5710168.27,842.00,159980.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','172',1717,'13','2',2788914.33,2791161.01,2246.68,1792850.64,0.00,0.00,0.00,0.00,0.00),('21','238','5','172',1718,'15','2',528427.06,529467.87,1040.81,830566.38,0.00,0.00,0.00,0.00,0.00),('21','238','5','172',1719,'16','2',267425.93,269496.52,2070.59,1652330.82,0.00,0.00,0.00,0.00,0.00),('21','238','6','172',1720,'17','3',595852.80,595884.20,31.40,27004.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','173',1721,'1','1',5709027.21,5712148.35,3121.14,593016.60,0.00,0.00,0.00,0.00,0.00),('21','238','1','173',1722,'2','1',5002352.97,5005614.88,3261.91,619762.90,0.00,0.00,0.00,0.00,0.00),('21','238','2','173',1723,'5','1',2446305.39,2446305.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','173',1724,'6','1',5547923.17,5551276.96,3353.79,637220.10,0.00,0.00,0.00,0.00,0.00),('21','238','3','173',1725,'9','1',5030246.70,5033301.51,3054.81,580413.90,0.00,0.00,0.00,0.00,0.00),('21','238','3','173',1726,'11','1',5710168.27,5712191.64,2023.37,384440.30,0.00,0.00,0.00,0.00,0.00),('21','238','4','173',1727,'13','2',2791161.01,2796260.73,5099.72,4069576.56,0.00,0.00,0.00,0.00,0.00),('21','238','5','173',1728,'15','2',529467.87,530489.83,1021.96,815524.08,0.00,0.00,0.00,0.00,0.00),('21','238','5','173',1729,'16','2',269496.52,269900.53,404.01,322399.98,0.00,0.00,0.00,0.00,0.00),('21','238','6','173',1730,'17','3',595884.20,595923.75,39.55,34013.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','174',1731,'1','1',5712148.35,5714879.17,2720.82,516955.80,0.00,0.00,10.00,0.00,0.00),('21','238','1','174',1732,'2','1',5005614.88,5009060.47,3435.59,652762.10,0.00,0.00,10.00,0.00,0.00),('21','238','2','174',1733,'5','1',2446305.39,2446305.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','174',1734,'6','1',5551276.96,5553901.39,2614.43,496741.70,0.00,0.00,10.00,0.00,0.00),('21','238','3','174',1735,'9','1',5033301.51,5036127.40,2815.89,535019.10,0.00,0.00,10.00,0.00,0.00),('21','238','3','174',1736,'11','1',5712191.64,5714754.78,2543.14,483196.60,0.00,0.00,20.00,0.00,0.00),('21','238','4','174',1737,'13','2',2796260.73,2797585.46,1324.73,1057134.54,0.00,0.00,0.00,0.00,0.00),('21','238','5','174',1738,'15','2',530489.83,532528.45,2038.62,1626818.76,0.00,0.00,0.00,0.00,0.00),('21','238','5','174',1739,'16','2',269900.53,270269.45,368.92,294398.16,0.00,0.00,0.00,0.00,0.00),('21','238','6','174',1740,'17','3',595923.75,595962.62,38.87,33428.20,0.00,0.00,0.00,0.00,0.00),('21','238','1','175',1741,'1','1',5714879.17,5717697.66,2818.49,535513.10,0.00,0.00,0.00,0.00,0.00),('21','238','1','175',1742,'2','1',5009060.47,5012206.00,3145.53,597650.70,0.00,0.00,0.00,0.00,0.00),('21','238','2','175',1743,'5','1',2446305.39,2446305.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','175',1744,'6','1',5553901.39,5557714.01,3812.62,724397.80,0.00,0.00,0.00,0.00,0.00),('21','238','3','175',1745,'9','1',5036127.40,5040930.59,4803.19,912606.10,0.00,0.00,0.00,0.00,0.00),('21','238','3','175',1746,'11','1',5714754.78,5717995.71,3240.93,615776.70,0.00,0.00,0.00,0.00,0.00),('21','238','4','175',1747,'13','2',2797585.46,2800041.73,2456.27,1960103.46,0.00,0.00,0.00,0.00,0.00),('21','238','5','175',1748,'15','2',532528.45,533781.42,1252.97,999870.06,0.00,0.00,0.00,0.00,0.00),('21','238','5','175',1749,'16','2',270269.45,271566.44,1296.99,1034998.02,0.00,0.00,0.00,0.00,0.00),('21','238','6','175',1750,'17','3',595962.62,596001.29,38.67,33256.20,0.00,0.00,0.00,0.00,0.00),('21','238','1','176',1751,'1','1',5717697.66,5721083.32,3385.66,643275.40,0.00,0.00,0.00,0.00,0.00),('21','238','1','176',1752,'2','1',5012206.00,5016227.67,4021.67,764117.30,0.00,0.00,0.00,0.00,0.00),('21','238','2','176',1753,'5','1',2446305.39,2446305.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','176',1754,'6','1',5557714.01,5560694.91,2980.90,566371.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','176',1755,'9','1',5040930.59,5044791.74,3861.15,733618.50,0.00,0.00,0.00,0.00,0.00),('21','238','3','176',1756,'11','1',5717995.71,5720836.17,2840.46,539687.40,0.00,0.00,0.00,0.00,0.00),('21','238','4','176',1757,'13','2',2800041.73,2803123.01,3081.28,2458861.44,0.00,0.00,0.00,0.00,0.00),('21','238','5','176',1758,'15','2',533781.42,535332.52,1551.10,1237777.80,0.00,0.00,0.00,0.00,0.00),('21','238','5','176',1759,'16','2',271566.44,272540.41,973.97,777228.06,0.00,0.00,0.00,0.00,0.00),('21','238','6','176',1760,'17','3',596001.29,596049.86,48.57,41770.20,0.00,0.00,0.00,0.00,0.00),('21','238','1','177',1761,'1','1',5721083.32,5724028.01,2924.69,555691.10,0.00,0.00,20.00,0.00,0.00),('21','238','1','177',1762,'2','1',5016227.67,5020664.35,4416.68,839169.20,0.00,0.00,20.00,0.00,0.00),('21','238','2','177',1763,'5','1',2446305.39,2446305.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','177',1764,'6','1',5560694.91,5564903.72,4188.81,795873.90,0.00,0.00,20.00,0.00,0.00),('21','238','3','177',1765,'9','1',5044791.74,5049941.41,5129.67,974637.30,0.00,0.00,20.00,0.00,0.00),('21','238','3','177',1766,'11','1',5720836.17,5723548.07,2691.90,511461.00,0.00,0.00,20.00,0.00,0.00),('21','238','4','177',1767,'13','2',2803123.01,2804660.10,1537.09,1226597.82,0.00,0.00,0.00,0.00,0.00),('21','238','5','177',1768,'15','2',535332.52,538910.55,3578.03,2855267.94,0.00,0.00,0.00,0.00,0.00),('21','238','5','177',1769,'16','2',272540.41,274720.17,2179.76,1739448.48,0.00,0.00,0.00,0.00,0.00),('21','238','6','177',1770,'17','3',596049.86,596099.31,49.45,42527.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','178',1771,'1','1',5724028.01,5726372.00,2333.99,443458.10,0.00,0.00,10.00,0.00,0.00),('21','238','1','178',1772,'2','1',5020664.35,5025501.18,4826.83,917097.70,0.00,0.00,10.00,0.00,0.00),('21','238','2','178',1773,'5','1',2446305.39,2446305.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','178',1774,'6','1',5564903.72,5568008.40,3104.68,589889.20,0.00,0.00,0.00,0.00,0.00),('21','238','3','178',1775,'9','1',5049941.41,5054208.65,4257.24,808875.60,0.00,0.00,10.00,0.00,0.00),('21','238','3','178',1776,'11','1',5723548.07,5727108.52,3550.45,674585.50,0.00,0.00,10.00,0.00,0.00),('21','238','4','178',1777,'13','2',2804660.10,2807568.15,2908.05,2320623.90,0.00,0.00,0.00,0.00,0.00),('21','238','5','178',1778,'15','2',538910.55,541367.41,2456.86,1960574.28,0.00,0.00,0.00,0.00,0.00),('21','238','5','178',1779,'16','2',274720.17,275537.81,817.64,652476.72,0.00,0.00,0.00,0.00,0.00),('21','238','6','178',1780,'17','3',596099.31,596160.45,61.14,52580.40,0.00,0.00,0.00,0.00,0.00),('21','238','1','179',1781,'1','1',5726372.00,5728172.89,1790.89,340269.10,0.00,0.00,10.00,0.00,0.00),('21','238','1','179',1782,'2','1',5025501.18,5027466.38,1955.20,371488.00,0.00,0.00,10.00,0.00,0.00),('21','238','2','179',1783,'5','1',2446305.39,2446305.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','179',1784,'6','1',5568008.40,5572788.99,4770.59,906412.10,0.00,0.00,10.00,0.00,0.00),('21','238','3','179',1785,'9','1',5054208.65,5055861.23,1642.58,312090.20,0.00,0.00,10.00,0.00,0.00),('21','238','3','179',1786,'11','1',5727108.52,5728983.10,1854.58,352370.20,0.00,0.00,20.00,0.00,0.00),('21','238','4','179',1787,'13','2',2807568.15,2811641.66,4073.51,3250660.98,0.00,0.00,0.00,0.00,0.00),('21','238','5','179',1788,'15','2',541367.41,542694.03,1326.62,1058642.76,0.00,0.00,0.00,0.00,0.00),('21','238','5','179',1789,'16','2',275537.81,277058.04,1520.23,1213143.54,0.00,0.00,0.00,0.00,0.00),('21','238','6','179',1790,'17','3',596160.45,596190.65,30.20,25972.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','180',1791,'1','1',5728172.89,5728172.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','180',1792,'2','1',5027466.38,5027466.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','180',1793,'5','1',2446305.39,2446305.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','180',1794,'6','1',5572788.99,5572788.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','180',1795,'9','1',5055861.23,5055861.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','180',1796,'11','1',5728983.10,5728983.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','180',1797,'13','2',2811641.66,2815063.83,3422.17,2730891.66,0.00,0.00,0.00,0.00,0.00),('21','238','5','180',1798,'15','2',542694.03,544809.56,2115.53,1688192.94,0.00,0.00,0.00,0.00,0.00),('21','238','5','180',1799,'16','2',277058.04,277702.03,643.99,513904.02,0.00,0.00,0.00,0.00,0.00),('21','238','6','180',1800,'17','3',596190.65,596265.51,74.86,64379.60,0.00,0.00,0.00,0.00,0.00),('21','238','1','181',1801,'1','1',5728172.89,5735388.46,7215.57,1370958.30,0.00,0.00,0.00,0.00,0.00),('21','238','1','181',1802,'2','1',5027466.38,5034935.54,7469.16,1419140.40,0.00,0.00,0.00,0.00,0.00),('21','238','2','181',1803,'5','1',2446305.39,2446305.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','181',1804,'6','1',5572788.99,5572788.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','181',1805,'9','1',5055861.23,5056909.39,1048.16,199150.40,0.00,0.00,0.00,0.00,0.00),('21','238','3','181',1806,'11','1',5728983.10,5729883.32,900.22,171041.80,0.00,0.00,0.00,0.00,0.00),('21','238','4','181',1807,'13','2',2815063.83,2817599.48,2535.65,2023448.70,0.00,0.00,0.00,0.00,0.00),('21','238','5','181',1808,'15','2',544809.56,545846.62,1037.06,827573.88,0.00,0.00,0.00,0.00,0.00),('21','238','5','181',1809,'16','2',277702.03,279441.06,1739.03,1387745.94,0.00,0.00,0.00,0.00,0.00),('21','238','6','181',1810,'17','3',596265.51,596301.14,35.63,30641.80,0.00,0.00,0.00,0.00,0.00),('21','238','1','182',1811,'1','1',5735388.46,5738913.69,3525.23,669793.70,0.00,0.00,0.00,0.00,0.00),('21','238','1','182',1812,'2','1',5034935.54,5039084.88,4149.34,788374.60,0.00,0.00,0.00,0.00,0.00),('21','238','2','182',1813,'5','1',2446305.39,2446305.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','182',1814,'6','1',5572788.99,5572788.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','182',1815,'9','1',5056909.39,5060403.43,3494.04,663867.60,0.00,0.00,0.00,0.00,0.00),('21','238','3','182',1816,'11','1',5729883.32,5733674.31,3790.99,720288.10,0.00,0.00,0.00,0.00,0.00),('21','238','4','182',1817,'13','2',2817599.48,2819956.27,2356.79,1880718.42,0.00,0.00,0.00,0.00,0.00),('21','238','5','182',1818,'15','2',545846.62,547560.23,1713.61,1367460.78,0.00,0.00,0.00,0.00,0.00),('21','238','5','182',1819,'16','2',279441.06,280986.11,1545.05,1232949.90,0.00,0.00,0.00,0.00,0.00),('21','238','6','182',1820,'17','3',596301.14,596338.40,37.26,32043.60,0.00,0.00,0.00,0.00,0.00),('21','238','1','183',1821,'1','1',5738913.69,5740885.35,1960.95,372580.50,0.00,0.00,10.71,0.00,0.00),('21','238','1','183',1822,'2','1',5039084.88,5043141.14,4046.26,768789.40,0.00,0.00,10.00,0.00,0.00),('21','238','2','183',1823,'5','1',2446305.39,2446305.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','183',1824,'6','1',5572788.99,5574387.80,1588.81,301873.90,0.00,0.00,10.00,0.00,0.00),('21','238','3','183',1825,'9','1',5060403.43,5065028.01,4614.58,876770.20,0.00,0.00,10.00,0.00,0.00),('21','238','3','183',1826,'11','1',5733674.31,5737130.75,3446.44,654823.60,0.00,0.00,10.00,0.00,0.00),('21','238','4','183',1827,'13','2',2819956.27,2822793.15,2836.88,2263830.24,0.00,0.00,0.00,0.00,0.00),('21','238','5','183',1828,'15','2',547560.23,550167.85,2607.62,2080880.76,0.00,0.00,0.00,0.00,0.00),('21','238','5','183',1829,'16','2',280986.11,281865.58,879.47,701817.06,0.00,0.00,0.00,0.00,0.00),('21','238','6','183',1830,'17','3',596338.40,596366.59,28.19,24243.40,0.00,0.00,0.00,0.00,0.00),('21','238','1','184',1831,'1','1',5740885.35,5742501.77,1616.42,307119.80,0.00,0.00,0.00,0.00,0.00),('21','238','1','184',1832,'2','1',5043141.14,5046051.95,2910.81,553053.90,0.00,0.00,0.00,0.00,0.00),('21','238','2','184',1833,'5','1',2446305.39,2446305.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','184',1834,'6','1',5574387.80,5578102.48,3714.68,705789.20,0.00,0.00,0.00,0.00,0.00),('21','238','3','184',1835,'9','1',5065028.01,5068504.11,3476.10,660459.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','184',1836,'11','1',5737130.75,5740576.81,3446.06,654751.40,0.00,0.00,0.00,0.00,0.00),('21','238','4','184',1837,'13','2',2822793.15,2824723.75,1930.60,1540618.80,0.00,0.00,0.00,0.00,0.00),('21','238','5','184',1838,'15','2',550167.85,551825.42,1657.57,1322740.86,0.00,0.00,0.00,0.00,0.00),('21','238','5','184',1839,'16','2',281865.58,283247.43,1381.85,1102716.30,0.00,0.00,0.00,0.00,0.00),('21','238','6','184',1840,'17','3',596366.59,596426.24,59.65,51299.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','185',1841,'1','1',5742501.77,5742501.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','185',1842,'2','1',5046051.95,5046051.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','185',1843,'5','1',2446305.39,2446305.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','185',1844,'6','1',5578102.48,5583775.03,5672.55,1077784.50,0.00,0.00,0.00,0.00,0.00),('21','238','3','185',1845,'9','1',5068504.11,5073990.81,5486.70,1042473.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','185',1846,'11','1',5740576.81,5745487.95,4911.14,933116.60,0.00,0.00,0.00,0.00,0.00),('21','238','4','185',1847,'13','2',2824723.75,2827305.92,2582.17,2060571.66,0.00,0.00,0.00,0.00,0.00),('21','238','5','185',1848,'15','2',551825.42,554371.38,2545.96,2031676.08,0.00,0.00,0.00,0.00,0.00),('21','238','5','185',1849,'16','2',283247.43,283247.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','185',1850,'17','3',596426.24,596478.45,52.21,44900.60,0.00,0.00,0.00,0.00,0.00),('21','238','1','186',1851,'1','1',5742501.77,5744437.95,1916.18,364074.20,0.00,0.00,20.00,0.00,0.00),('21','238','1','186',1852,'2','1',5046051.95,5050293.01,4221.06,802001.40,0.00,0.00,20.00,0.00,0.00),('21','238','2','186',1853,'5','1',2446305.39,2446305.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','186',1854,'6','1',5583775.03,5587131.19,3336.16,633870.40,0.00,0.00,20.00,0.00,0.00),('21','238','3','186',1855,'9','1',5073990.81,5076324.29,2313.48,439561.20,0.00,0.00,20.00,0.00,0.00),('21','238','3','186',1856,'11','1',5745487.95,5748467.23,2959.28,562263.20,0.00,0.00,20.00,0.00,0.00),('21','238','4','186',1857,'13','2',2827305.92,2827305.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','186',1858,'15','2',554371.38,554371.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','186',1859,'16','2',283247.43,283247.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','186',1860,'17','3',596478.45,596512.24,23.79,20459.40,0.00,0.00,10.00,0.00,0.00),('21','238','1','187',1861,'1','1',5744437.95,5747230.76,2792.81,530633.90,0.00,0.00,0.00,0.00,0.00),('21','238','1','187',1862,'2','1',5050293.01,5057032.72,6739.71,1280544.90,0.00,0.00,0.00,0.00,0.00),('21','238','2','187',1863,'5','1',2446305.39,2446305.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','187',1864,'6','1',5587131.19,5593844.11,6712.92,1275454.80,0.00,0.00,0.00,0.00,0.00),('21','238','3','187',1865,'9','1',5076324.29,5076324.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','187',1866,'11','1',5748467.23,5748467.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','187',1867,'13','2',2827305.92,2827305.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','187',1868,'15','2',554371.38,554371.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','187',1869,'16','2',283247.43,283247.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','187',1870,'17','3',596512.24,596545.17,32.93,28319.80,0.00,0.00,0.00,0.00,0.00),('21','238','1','188',1871,'1','1',5747230.76,5748663.26,1432.50,272175.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','188',1872,'2','1',5057032.72,5063240.98,6208.26,1179569.40,0.00,0.00,0.00,0.00,0.00),('21','238','2','188',1873,'5','1',2446305.39,2446305.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','188',1874,'6','1',5593844.11,5600588.36,6744.25,1281407.50,0.00,0.00,0.00,0.00,0.00),('21','238','3','188',1875,'9','1',5076324.29,5076324.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','188',1876,'11','1',5748467.23,5748467.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','188',1877,'13','2',2827305.92,2827305.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','188',1878,'15','2',554371.38,554371.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','188',1879,'16','2',283247.43,283247.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','188',1880,'17','3',596545.17,596624.47,79.30,68198.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','189',1881,'1','1',5748663.26,5748663.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','189',1882,'2','1',5063240.98,5068351.80,5110.82,971055.80,0.00,0.00,0.00,0.00,0.00),('21','238','2','189',1883,'5','1',2446305.39,2446305.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','189',1884,'6','1',5600588.36,5603514.12,2925.76,555894.40,0.00,0.00,0.00,0.00,0.00),('21','238','3','189',1885,'9','1',5076324.29,5078938.75,2614.46,496747.40,0.00,0.00,0.00,0.00,0.00),('21','238','3','189',1886,'11','1',5748467.23,5750529.50,2062.27,391831.30,0.00,0.00,0.00,0.00,0.00),('21','238','4','189',1887,'13','2',2827305.92,2827305.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','189',1888,'15','2',554371.38,554371.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','189',1889,'16','2',283247.43,283247.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','189',1890,'17','3',596624.47,596657.95,33.48,28792.80,0.00,0.00,0.00,0.00,0.00),('21','238','1','190',1891,'1','1',5748663.26,5748720.76,57.50,10925.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','190',1892,'2','1',5068351.80,5072359.65,4007.85,761491.50,0.00,0.00,0.00,0.00,0.00),('21','238','2','190',1893,'5','1',2446305.39,2446305.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','190',1894,'6','1',5603514.12,5607155.17,3641.05,691799.50,0.00,0.00,0.00,0.00,0.00),('21','238','3','190',1895,'9','1',5078938.75,5082301.42,3362.67,638907.30,0.00,0.00,0.00,0.00,0.00),('21','238','3','190',1896,'11','1',5750529.50,5752874.89,2345.39,445624.10,0.00,0.00,0.00,0.00,0.00),('21','238','4','190',1897,'13','2',2827305.92,2831581.41,4275.49,3411841.02,0.00,0.00,0.00,0.00,0.00),('21','238','5','190',1898,'15','2',554371.38,554371.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','190',1899,'16','2',283247.43,283247.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','190',1900,'17','3',596657.95,596691.12,33.17,28526.20,0.00,0.00,0.00,0.00,0.00),('21','238','1','191',1901,'1','1',5748720.76,5748720.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','191',1902,'2','1',5072359.65,5076335.17,3975.52,755348.80,0.00,0.00,0.00,0.00,0.00),('21','238','2','191',1903,'5','1',2446305.39,2446305.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','191',1904,'6','1',5607155.17,5609999.33,2844.16,540390.40,0.00,0.00,0.00,0.00,0.00),('21','238','3','191',1905,'9','1',5082301.42,5085647.74,3346.32,635800.80,0.00,0.00,0.00,0.00,0.00),('21','238','3','191',1906,'11','1',5752874.89,5755861.62,2986.73,567478.70,0.00,0.00,0.00,0.00,0.00),('21','238','4','191',1907,'13','2',2831581.41,2839427.32,7845.91,6261036.18,0.00,0.00,0.00,0.00,0.00),('21','238','5','191',1908,'15','2',554371.38,554371.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','191',1909,'16','2',283247.43,283247.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','191',1910,'17','3',596691.12,596716.24,25.12,21603.20,0.00,0.00,0.00,0.00,0.00),('21','238','1','192',1911,'1','1',5748720.76,5749330.66,599.90,113981.00,0.00,0.00,10.00,0.00,0.00),('21','238','1','192',1912,'2','1',5076335.17,5079616.48,3271.31,621548.90,0.00,0.00,10.00,0.00,0.00),('21','238','2','192',1913,'5','1',2446305.39,2446305.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','192',1914,'6','1',5609999.33,5611982.23,1972.90,374851.00,0.00,0.00,10.00,0.00,0.00),('21','238','3','192',1915,'9','1',5085647.74,5087934.08,2276.34,432504.60,0.00,0.00,10.00,0.00,0.00),('21','238','3','192',1916,'11','1',5755861.62,5757651.05,1779.43,338091.70,0.00,0.00,10.00,0.00,0.00),('21','238','4','192',1917,'13','2',2839427.32,2842250.84,2823.52,2253168.96,0.00,0.00,0.00,0.00,0.00),('21','238','5','192',1918,'15','2',554371.38,554371.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','192',1919,'16','2',283247.43,283247.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','192',1920,'17','3',596716.24,596762.66,46.42,39921.20,0.00,0.00,0.00,0.00,0.00),('21','238','1','193',1921,'1','1',5749330.66,5750675.84,1345.18,255584.20,0.00,0.00,0.00,0.00,0.00),('21','238','1','193',1922,'2','1',5079616.48,5082812.51,3196.03,607245.70,0.00,0.00,0.00,0.00,0.00),('21','238','2','193',1923,'5','1',2446305.39,2446305.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','193',1924,'6','1',5611982.23,5615230.06,3247.83,617087.70,0.00,0.00,0.00,0.00,0.00),('21','238','3','193',1925,'9','1',5087934.08,5090168.82,2234.74,424600.60,0.00,0.00,0.00,0.00,0.00),('21','238','3','193',1926,'11','1',5757651.05,5759855.57,2204.52,418858.80,0.00,0.00,0.00,0.00,0.00),('21','238','4','193',1927,'13','2',2842250.84,2844296.44,2045.60,1632388.80,0.00,0.00,0.00,0.00,0.00),('21','238','5','193',1928,'15','2',554371.38,554371.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','193',1929,'16','2',283247.43,283247.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','193',1930,'17','3',596762.66,596811.41,48.75,41925.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','194',1931,'1','1',5750675.84,5752369.56,1693.72,321806.80,0.00,0.00,0.00,0.00,0.00),('21','238','1','194',1932,'2','1',5082812.51,5084403.23,1590.72,302236.80,0.00,0.00,0.00,0.00,0.00),('21','238','2','194',1933,'5','1',2446305.39,2446305.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','194',1934,'6','1',5615230.06,5616957.07,1727.01,328131.90,0.00,0.00,0.00,0.00,0.00),('21','238','3','194',1935,'9','1',5090168.82,5091595.77,1426.95,271120.50,0.00,0.00,0.00,0.00,0.00),('21','238','3','194',1936,'11','1',5759855.57,5760935.81,1080.24,205245.60,0.00,0.00,0.00,0.00,0.00),('21','238','4','194',1937,'13','2',2844296.44,2844296.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','194',1938,'15','2',554371.38,554371.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','194',1939,'16','2',283247.43,283247.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','194',1940,'17','3',596811.41,596811.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','195',1941,'1','1',5752369.56,5753018.52,648.96,120057.60,0.00,0.00,0.00,0.00,0.00),('21','238','1','195',1942,'2','1',5084403.23,5085783.83,1380.60,255411.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','195',1943,'5','1',2446305.39,2446305.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','195',1944,'6','1',5616957.07,5617814.88,857.81,158694.85,0.00,0.00,0.00,0.00,0.00),('21','238','3','195',1945,'9','1',5091595.77,5092830.72,1234.95,228465.75,0.00,0.00,0.00,0.00,0.00),('21','238','3','195',1946,'11','1',5760935.81,5761753.34,817.53,151243.05,0.00,0.00,0.00,0.00,0.00),('21','238','4','195',1947,'13','2',2844296.44,2850915.88,6619.44,5282313.12,0.00,0.00,0.00,0.00,0.00),('21','238','5','195',1948,'15','2',554371.38,554371.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','195',1949,'16','2',283247.43,283247.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','195',1950,'17','3',596811.41,596841.94,30.53,26255.80,0.00,0.00,0.00,0.00,0.00),('21','238','1','196',1951,'1','1',5753018.52,5754776.66,1758.14,325255.90,0.00,0.00,0.00,0.00,0.00),('21','238','1','196',1952,'2','1',5085783.83,5088882.53,3098.70,573259.50,0.00,0.00,0.00,0.00,0.00),('21','238','2','196',1953,'5','1',2446305.39,2446305.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','196',1954,'6','1',5617814.88,5620375.23,2560.35,473664.75,0.00,0.00,0.00,0.00,0.00),('21','238','3','196',1955,'9','1',5092830.72,5096325.14,3494.42,646467.70,0.00,0.00,0.00,0.00,0.00),('21','238','3','196',1956,'11','1',5761753.34,5763914.90,2161.56,399888.60,0.00,0.00,0.00,0.00,0.00),('21','238','4','196',1957,'13','2',2850915.88,2857350.75,6434.87,5135026.26,0.00,0.00,0.00,0.00,0.00),('21','238','5','196',1958,'15','2',554371.38,554371.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','196',1959,'16','2',283247.43,283247.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','196',1960,'17','3',596841.94,596877.95,36.01,30968.60,0.00,0.00,0.00,0.00,0.00),('21','238','1','197',1961,'1','1',5754776.66,5757111.65,2314.99,428273.15,0.00,0.00,20.00,0.00,0.00),('21','238','1','197',1962,'2','1',5088882.53,5092819.06,3916.53,724558.05,0.00,0.00,20.00,0.00,0.00),('21','238','2','197',1963,'5','1',2446305.39,2446305.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','197',1964,'6','1',5620375.23,5623632.10,3236.87,598820.95,0.00,0.00,20.00,0.00,0.00),('21','238','3','197',1965,'9','1',5096325.14,5099192.78,2847.64,526813.40,0.00,0.00,20.00,0.00,0.00),('21','238','3','197',1966,'11','1',5763914.90,5767464.21,3529.31,652922.35,0.00,0.00,20.00,0.00,0.00),('21','238','4','197',1967,'13','2',2857350.75,2857350.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','197',1968,'15','2',554371.38,554371.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','197',1969,'16','2',283247.43,283247.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','197',1970,'17','3',596877.95,596904.78,26.83,23073.80,0.00,0.00,0.00,0.00,0.00),('21','238','1','198',1971,'1','1',5757111.65,5759337.76,2226.11,411830.35,0.00,0.00,0.00,0.00,0.00),('21','238','1','198',1972,'2','1',5092819.06,5094930.07,2111.01,390536.85,0.00,0.00,0.00,0.00,0.00),('21','238','2','198',1973,'5','1',2446305.39,2446305.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','198',1974,'6','1',5623632.10,5625979.65,2347.55,434296.75,0.00,0.00,0.00,0.00,0.00),('21','238','3','198',1975,'9','1',5099192.78,5101708.20,2515.42,465352.70,0.00,0.00,0.00,0.00,0.00),('21','238','3','198',1976,'11','1',5767464.21,5769848.10,2383.89,441019.65,0.00,0.00,0.00,0.00,0.00),('21','238','4','198',1977,'13','2',2857350.75,2857350.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','198',1978,'15','2',554371.38,554371.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','198',1979,'16','2',283247.43,283247.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','198',1980,'17','3',596904.78,596928.04,23.26,20003.60,0.00,0.00,0.00,0.00,0.00),('21','238','1','199',1981,'1','1',5759337.76,5762453.65,3095.89,572739.65,0.00,0.00,20.00,0.00,0.00),('21','238','1','199',1982,'2','1',5094930.07,5098433.20,3483.13,644379.05,0.00,0.00,20.00,0.00,0.00),('21','238','2','199',1983,'5','1',2446305.39,2446305.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','199',1984,'6','1',5625979.65,5628730.59,2730.94,505223.90,0.00,0.00,20.00,0.00,0.00),('21','238','3','199',1985,'9','1',5101708.20,5104936.02,3207.82,593446.70,0.00,0.00,20.00,0.00,0.00),('21','238','3','199',1986,'11','1',5769848.10,5772619.85,2751.75,509073.75,0.00,0.00,20.00,0.00,0.00),('21','238','4','199',1987,'13','2',2857350.75,2857350.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','199',1988,'15','2',554371.38,554371.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','199',1989,'16','2',283247.43,283247.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','199',1990,'17','3',596928.04,597022.66,74.62,64173.20,0.00,0.00,20.00,0.00,0.00),('21','238','1','200',1991,'1','1',5762453.65,5764128.60,1674.95,309865.75,0.00,0.00,0.00,0.00,0.00),('21','238','1','200',1992,'2','1',5098433.20,5100257.87,1824.67,337563.95,0.00,0.00,0.00,0.00,0.00),('21','238','2','200',1993,'5','1',2446305.39,2446305.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','200',1994,'6','1',5628730.59,5632472.10,3741.51,692179.35,0.00,0.00,0.00,0.00,0.00),('21','238','3','200',1995,'9','1',5104936.02,5108552.27,3616.25,669006.25,0.00,0.00,0.00,0.00,0.00),('21','238','3','200',1996,'11','1',5772619.85,5776043.91,3424.06,633451.10,0.00,0.00,0.00,0.00,0.00),('21','238','4','200',1997,'13','2',2857350.75,2859069.52,1718.77,1371578.46,0.00,0.00,0.00,0.00,0.00),('21','238','5','200',1998,'15','2',554371.38,554371.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','200',1999,'16','2',283247.43,283247.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','200',2000,'17','3',597022.66,597052.32,29.66,25507.60,0.00,0.00,0.00,0.00,0.00),('21','238','1','201',2001,'1','1',5764128.60,5766463.90,2315.30,428330.50,0.00,0.00,20.00,0.00,0.00),('21','238','1','201',2002,'2','1',5100257.87,5104329.92,4052.05,749629.25,0.00,0.00,20.00,0.00,0.00),('21','238','2','201',2003,'5','1',2446305.39,2446305.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','201',2004,'6','1',5632472.10,5633421.77,929.67,171988.95,0.00,0.00,20.00,0.00,0.00),('21','238','3','201',2005,'9','1',5108552.27,5112360.32,3788.05,700789.25,0.00,0.00,20.00,0.00,0.00),('21','238','3','201',2006,'11','1',5776043.91,5777783.70,1719.79,318161.15,0.00,0.00,20.00,0.00,0.00),('21','238','4','201',2007,'13','2',2859069.52,2866339.62,7270.10,5801539.80,0.00,0.00,0.00,0.00,0.00),('21','238','5','201',2008,'15','2',554371.38,554371.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','201',2009,'16','2',283247.43,283247.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','201',2010,'17','3',597052.32,597099.38,47.06,40471.60,0.00,0.00,0.00,0.00,0.00),('21','238','1','202',2011,'1','1',5766463.90,5766463.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','202',2012,'2','1',5104329.92,5104329.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','202',2013,'5','1',2446305.39,2446305.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','202',2014,'6','1',5633421.77,5633421.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','202',2015,'9','1',5112360.32,5112360.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','202',2016,'11','1',5777783.70,5777783.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','202',2017,'13','2',2866339.62,2866339.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','202',2018,'15','2',554371.38,554371.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','202',2019,'16','2',283247.43,283247.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','202',2020,'17','3',597099.38,597099.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','203',2021,'1','1',5766463.90,5769406.82,2942.92,544440.20,0.00,0.00,0.00,0.00,0.00),('21','238','1','203',2022,'2','1',5104329.92,5107906.89,3576.97,661739.45,0.00,0.00,0.00,0.00,0.00),('21','238','2','203',2023,'5','1',326.71,620.83,294.12,54412.20,0.00,0.00,0.00,0.00,0.00),('21','238','2','203',2024,'6','1',5633421.77,5636335.90,2914.13,539114.05,0.00,0.00,0.00,0.00,0.00),('21','238','3','203',2025,'9','1',5112360.32,5114574.64,2214.32,409649.20,0.00,0.00,0.00,0.00,0.00),('21','238','3','203',2026,'11','1',5777783.70,5780419.32,2635.62,487589.70,0.00,0.00,0.00,0.00,0.00),('21','238','4','203',2027,'13','2',2866339.62,2872376.87,6037.25,4817725.50,0.00,0.00,0.00,0.00,0.00),('21','238','5','203',2028,'15','2',554371.38,554371.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','203',2029,'16','2',283247.43,283247.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','203',2030,'17','3',597099.38,597118.50,19.12,16443.20,0.00,0.00,0.00,0.00,0.00),('21','238','1','204',2031,'1','1',5769406.82,5772973.67,3566.85,659867.25,0.00,0.00,0.00,0.00,0.00),('21','238','1','204',2032,'2','1',5107906.89,5111472.47,3565.58,659632.30,0.00,0.00,0.00,0.00,0.00),('21','238','2','204',2033,'5','1',620.83,622.07,1.24,229.40,0.00,0.00,0.00,0.00,0.00),('21','238','2','204',2034,'6','1',5636335.90,5639376.30,3040.40,562474.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','204',2035,'9','1',5114574.64,5117948.81,3374.17,624221.45,0.00,0.00,0.00,0.00,0.00),('21','238','3','204',2036,'11','1',5780419.32,5783759.16,3339.84,617870.40,0.00,0.00,0.00,0.00,0.00),('21','238','4','204',2037,'13','2',2872376.87,2872376.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','204',2038,'15','2',554371.38,554371.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','204',2039,'16','2',283247.43,283247.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','204',2040,'17','3',597118.50,597183.10,64.60,55556.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','205',2041,'1','1',5772973.67,5778008.83,5015.16,927804.60,0.00,0.00,20.00,0.00,0.00),('21','238','1','205',2042,'2','1',5111472.47,5116378.37,4885.90,903891.50,0.00,0.00,20.00,0.00,0.00),('21','238','2','205',2043,'5','1',622.07,1137.65,495.58,91682.30,0.00,0.00,20.00,0.00,0.00),('21','238','2','205',2044,'6','1',5639376.30,5645457.52,6061.22,1121325.70,0.00,0.00,20.00,0.00,0.00),('21','238','3','205',2045,'9','1',5117948.81,5119994.31,2025.50,374717.50,0.00,0.00,20.00,0.00,0.00),('21','238','3','205',2046,'11','1',5783759.16,5785519.14,1739.98,321896.30,0.00,0.00,20.00,0.00,0.00),('21','238','4','205',2047,'13','2',2872376.87,2872376.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','205',2048,'15','2',554371.38,554371.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','205',2049,'16','2',283247.43,283247.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','205',2050,'17','3',597183.10,597197.03,13.93,11979.80,0.00,0.00,0.00,0.00,0.00),('21','238','1','206',2051,'1','1',5778008.83,5782005.12,3996.29,739313.65,0.00,0.00,0.00,0.00,0.00),('21','238','1','206',2052,'2','1',5116378.37,5120408.25,4029.88,745527.80,0.00,0.00,0.00,0.00,0.00),('21','238','2','206',2053,'5','1',1137.65,1137.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','206',2054,'6','1',5645457.52,5648634.95,3177.43,587824.55,0.00,0.00,0.00,0.00,0.00),('21','238','3','206',2055,'9','1',5119994.31,5125159.65,5165.34,955587.90,0.00,0.00,0.00,0.00,0.00),('21','238','3','206',2056,'11','1',5785519.14,5789107.56,3588.42,663857.70,0.00,0.00,0.00,0.00,0.00),('21','238','4','206',2057,'13','2',2872376.87,2872376.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','206',2058,'15','2',554371.38,554371.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','206',2059,'16','2',283247.43,283247.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','206',2060,'17','3',597197.03,597246.31,49.28,42380.80,0.00,0.00,0.00,0.00,0.00),('21','238','1','207',2061,'1','1',5782005.12,5786649.75,4624.63,855556.55,0.00,0.00,20.00,0.00,0.00),('21','238','1','207',2062,'2','1',5120408.25,5125151.92,4723.67,873878.95,0.00,0.00,20.00,0.00,0.00),('21','238','2','207',2063,'5','1',1137.65,1137.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','207',2064,'6','1',5648634.95,5653481.99,4827.04,893002.40,0.00,0.00,20.00,0.00,0.00),('21','238','3','207',2065,'9','1',5125159.65,5128218.89,3039.24,562259.40,0.00,0.00,20.00,0.00,0.00),('21','238','3','207',2066,'11','1',5789107.56,5792190.08,3062.52,566566.20,0.00,0.00,20.00,0.00,0.00),('21','238','4','207',2067,'13','2',2872376.87,2872376.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','207',2068,'15','2',554371.38,554371.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','207',2069,'16','2',283247.43,283247.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','207',2070,'17','3',597246.31,597273.79,27.48,23632.80,0.00,0.00,0.00,0.00,0.00),('21','238','1','208',2071,'1','1',5786649.75,5790005.18,3355.43,620754.55,0.00,0.00,0.00,0.00,0.00),('21','238','1','208',2072,'2','1',5125151.92,5129290.51,4138.59,765639.15,0.00,0.00,0.00,0.00,0.00),('21','238','2','208',2073,'5','1',1137.65,3205.16,2067.51,382489.35,0.00,0.00,0.00,0.00,0.00),('21','238','2','208',2074,'6','1',5653481.99,5662587.85,9105.86,1684584.10,0.00,0.00,0.00,0.00,0.00),('21','238','3','208',2075,'9','1',5128218.89,5128218.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','208',2076,'11','1',5792190.08,5792190.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','208',2077,'13','2',2872376.87,2872376.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','208',2078,'15','2',554371.38,554371.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','208',2079,'16','2',283247.43,283247.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','208',2080,'17','3',597273.79,597321.57,47.78,41090.80,0.00,0.00,0.00,0.00,0.00),('21','238','1','209',2081,'1','1',5790005.18,5793073.29,3068.11,567600.35,0.00,0.00,0.00,0.00,0.00),('21','238','1','209',2082,'2','1',5129290.51,5132821.02,3530.51,653144.35,0.00,0.00,0.00,0.00,0.00),('21','238','2','209',2083,'5','1',3205.16,5124.57,1919.41,355090.85,0.00,0.00,0.00,0.00,0.00),('21','238','2','209',2084,'6','1',5662587.85,5666086.84,3498.99,647313.15,0.00,0.00,0.00,0.00,0.00),('21','238','3','209',2085,'9','1',5128218.89,5130957.37,2738.48,506618.80,0.00,0.00,0.00,0.00,0.00),('21','238','3','209',2086,'11','1',5792190.08,5795380.18,3190.10,590168.50,0.00,0.00,0.00,0.00,0.00),('21','238','4','209',2087,'13','2',2872376.87,2872376.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','209',2088,'15','2',554371.38,554371.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','209',2089,'16','2',283247.43,283247.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','209',2090,'17','3',597321.57,597368.42,46.85,40291.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','210',2091,'1','1',5793073.29,5796020.43,2947.14,545220.90,0.00,0.00,0.00,0.00,0.00),('21','238','1','210',2092,'2','1',5132821.02,5135925.40,3104.38,574310.30,0.00,0.00,0.00,0.00,0.00),('21','238','2','210',2093,'5','1',5124.57,8956.84,3832.27,708969.95,0.00,0.00,0.00,0.00,0.00),('21','238','2','210',2094,'6','1',5666086.84,5669766.97,3680.13,680824.05,0.00,0.00,0.00,0.00,0.00),('21','238','3','210',2095,'9','1',5130957.37,5131056.93,99.56,18418.60,0.00,0.00,0.00,0.00,0.00),('21','238','3','210',2096,'11','1',5795380.18,5798847.53,3467.35,641459.75,0.00,0.00,0.00,0.00,0.00),('21','238','4','210',2097,'13','2',2872376.87,2880943.86,8566.99,7007797.82,0.00,0.00,0.00,0.00,0.00),('21','238','5','210',2098,'15','2',554371.38,558070.38,3699.00,3025782.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','210',2099,'16','2',283247.43,283868.30,620.87,507871.66,0.00,0.00,0.00,0.00,0.00),('21','238','6','210',2100,'17','3',597368.42,597405.96,37.54,32284.40,0.00,0.00,0.00,0.00,0.00),('21','238','1','211',2101,'1','1',5796020.43,5800741.41,4720.98,873381.30,0.00,0.00,0.00,0.00,0.00),('21','238','1','211',2102,'2','1',5135925.40,5140365.85,4440.45,821483.25,0.00,0.00,0.00,0.00,0.00),('21','238','2','211',2103,'5','1',8956.84,11121.28,2164.44,400421.40,0.00,0.00,0.00,0.00,0.00),('21','238','2','211',2104,'6','1',5669766.97,5673651.67,3884.70,718669.50,0.00,0.00,0.00,0.00,0.00),('21','238','3','211',2105,'9','1',5131056.93,5131056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','211',2106,'11','1',5798847.53,5803263.71,4416.18,816993.30,0.00,0.00,0.00,0.00,0.00),('21','238','4','211',2107,'13','2',2880943.86,2886466.31,5522.45,4517364.10,0.00,0.00,0.00,0.00,0.00),('21','238','5','211',2108,'15','2',558070.38,561964.60,3894.22,3185471.96,0.00,0.00,0.00,0.00,0.00),('21','238','5','211',2109,'16','2',283868.30,286848.70,2980.40,2437967.20,0.00,0.00,0.00,0.00,0.00),('21','238','6','211',2110,'17','3',597405.96,597439.08,33.12,28483.20,0.00,0.00,0.00,0.00,0.00),('21','238','1','212',2111,'1','1',5800741.41,5804599.98,3858.57,713835.45,0.00,0.00,0.00,0.00,0.00),('21','238','1','212',2112,'2','1',5140365.85,5145511.39,5145.54,951924.90,0.00,0.00,0.00,0.00,0.00),('21','238','2','212',2113,'5','1',11121.28,11121.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','212',2114,'6','1',5673651.67,5673651.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','212',2115,'9','1',5131056.93,5131056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','212',2116,'11','1',5803263.71,5804408.47,1144.76,211780.60,0.00,0.00,0.00,0.00,0.00),('21','238','4','212',2117,'13','2',2886466.31,2888787.71,2321.40,1898905.20,0.00,0.00,0.00,0.00,0.00),('21','238','5','212',2118,'15','2',561964.60,564513.78,2549.18,2085229.24,0.00,0.00,0.00,0.00,0.00),('21','238','5','212',2119,'16','2',286848.70,287852.01,1003.31,820707.58,0.00,0.00,0.00,0.00,0.00),('21','238','6','212',2120,'17','3',597439.08,597493.82,54.74,47076.40,0.00,0.00,0.00,0.00,0.00),('21','238','1','213',2121,'1','1',5804599.98,5804599.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','213',2122,'2','1',5145511.39,5145511.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','213',2123,'5','1',11121.28,11121.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','213',2124,'6','1',5673651.67,5673651.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','213',2125,'9','1',5131056.93,5131056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','213',2126,'11','1',5804408.47,5804408.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','213',2127,'13','2',2888787.71,2893038.59,4250.88,3477219.84,0.00,0.00,0.00,0.00,0.00),('21','238','5','213',2128,'15','2',564513.78,564513.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','213',2129,'16','2',287852.01,287852.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','213',2130,'17','3',597493.82,597518.54,24.72,21259.20,0.00,0.00,0.00,0.00,0.00),('21','238','1','214',2131,'1','1',5804599.98,5806176.41,1556.43,287939.55,0.00,0.00,20.00,0.00,0.00),('21','238','1','214',2132,'2','1',5145511.39,5149197.47,3666.08,678224.80,0.00,0.00,20.00,0.00,0.00),('21','238','2','214',2133,'5','1',11121.28,19468.83,8317.55,1538746.75,0.00,0.00,30.00,0.00,0.00),('21','238','2','214',2134,'6','1',5673651.67,5684733.03,11051.36,2044501.60,0.00,0.00,30.00,0.00,0.00),('21','238','3','214',2135,'9','1',5131056.93,5131058.22,1.29,238.65,0.00,0.00,0.00,0.00,0.00),('21','238','3','214',2136,'11','1',5804408.47,5804416.07,7.60,1406.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','214',2137,'13','2',2893038.59,2893088.59,50.00,40900.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','214',2138,'15','2',564513.78,564513.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','214',2139,'16','2',287852.01,287852.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','214',2140,'17','3',597518.54,597569.02,50.48,43412.80,0.00,0.00,0.00,0.00,10.00),('21','238','1','215',2141,'1','1',5806176.41,5812831.12,6654.71,1231121.35,0.00,0.00,0.00,0.00,0.00),('21','238','1','215',2142,'2','1',5149197.47,5156947.01,7749.54,1433664.90,0.00,0.00,0.00,0.00,0.00),('21','238','2','215',2143,'5','1',19468.83,19490.47,21.64,4003.40,0.00,0.00,0.00,0.00,0.00),('21','238','2','215',2144,'6','1',5684733.03,5685312.49,579.46,107200.10,0.00,0.00,0.00,0.00,0.00),('21','238','3','215',2145,'9','1',5131058.22,5131058.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','215',2146,'11','1',5804416.07,5804416.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','215',2147,'13','2',2893088.59,2893707.61,619.02,506358.36,0.00,0.00,0.00,0.00,0.00),('21','238','5','215',2148,'15','2',564513.78,564513.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','215',2149,'16','2',287852.01,287852.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','215',2150,'17','3',597569.02,597605.93,36.91,31742.60,0.00,0.00,0.00,0.00,0.00),('21','238','1','216',2151,'1','1',5812831.12,5818165.85,5334.73,986925.05,0.00,0.00,0.00,0.00,0.00),('21','238','1','216',2152,'2','1',5156947.01,5165814.54,8867.53,1640493.05,0.00,0.00,0.00,0.00,0.00),('21','238','2','216',2153,'5','1',19490.47,23364.42,3873.95,716680.75,0.00,0.00,0.00,0.00,0.00),('21','238','2','216',2154,'6','1',5685312.49,5693192.44,7879.95,1457790.75,0.00,0.00,0.00,0.00,0.00),('21','238','3','216',2155,'9','1',5131058.22,5134189.10,3130.88,579212.80,0.00,0.00,0.00,0.00,0.00),('21','238','3','216',2156,'11','1',5804416.07,5811140.18,6724.11,1243960.35,0.00,0.00,0.00,0.00,0.00),('21','238','4','216',2157,'13','2',2893707.61,2893737.61,30.00,24540.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','216',2158,'15','2',564513.78,564513.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','216',2159,'16','2',287852.01,287852.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','216',2160,'17','3',597605.93,597634.53,28.60,24596.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','217',2161,'1','1',5818165.85,5824508.40,6342.55,1173371.75,0.00,0.00,0.00,0.00,0.00),('21','238','1','217',2162,'2','1',5165814.54,5170705.23,4890.69,904777.65,0.00,0.00,0.00,0.00,0.00),('21','238','2','217',2163,'5','1',23364.42,28891.49,5527.07,1022507.95,0.00,0.00,0.00,0.00,0.00),('21','238','2','217',2164,'6','1',5693192.44,5698688.94,5496.50,1016852.50,0.00,0.00,0.00,0.00,0.00),('21','238','3','217',2165,'9','1',5134189.10,5136271.08,2081.98,385166.30,0.00,0.00,0.00,0.00,0.00),('21','238','3','217',2166,'11','1',5811140.18,5813941.93,2801.75,518323.75,0.00,0.00,0.00,0.00,0.00),('21','238','4','217',2167,'13','2',2893737.61,2893777.38,39.77,32531.86,0.00,0.00,0.00,0.00,0.00),('21','238','5','217',2168,'15','2',564513.78,564513.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','217',2169,'16','2',287852.01,287852.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','217',2170,'17','3',597634.53,597671.72,37.19,31983.40,0.00,0.00,0.00,0.00,0.00),('21','238','1','218',2171,'1','1',5824508.40,5827602.33,3093.93,572377.05,0.00,0.00,0.00,0.00,0.00),('21','238','1','218',2172,'2','1',5170705.23,5174147.70,3442.47,636856.95,0.00,0.00,0.00,0.00,0.00),('21','238','2','218',2173,'5','1',28891.49,33455.70,4564.21,844378.85,0.00,0.00,0.00,0.00,0.00),('21','238','2','218',2174,'6','1',5698688.94,5702832.98,4144.04,766647.40,0.00,0.00,0.00,0.00,0.00),('21','238','3','218',2175,'9','1',5136271.08,5141729.12,5458.04,1009737.40,0.00,0.00,0.00,0.00,0.00),('21','238','3','218',2176,'11','1',5813941.93,5818783.63,4841.70,895714.50,0.00,0.00,0.00,0.00,0.00),('21','238','4','218',2177,'13','2',2893777.38,2894184.36,406.98,332909.64,0.00,0.00,0.00,0.00,0.00),('21','238','5','218',2178,'15','2',564513.78,564513.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','218',2179,'16','2',287852.01,287852.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','218',2180,'17','3',597671.72,597702.28,30.56,26281.60,0.00,0.00,0.00,0.00,0.00),('21','238','1','219',2181,'1','1',5827602.33,5827602.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','219',2182,'2','1',5174147.70,5174147.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','219',2183,'5','1',33455.70,33455.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','219',2184,'6','1',5702832.98,5702832.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','219',2185,'9','1',5141729.12,5143886.58,2157.46,399130.10,0.00,0.00,0.00,0.00,0.00),('21','238','3','219',2186,'11','1',5818783.63,5821135.48,2351.85,435092.25,0.00,0.00,0.00,0.00,0.00),('21','238','4','219',2187,'13','2',2894184.36,2894184.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','219',2188,'15','2',564513.78,564513.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','219',2189,'16','2',287852.01,287852.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','219',2190,'17','3',597702.28,597732.19,29.91,25722.60,0.00,0.00,0.00,0.00,0.00),('21','238','1','220',2191,'1','1',5827602.33,5831043.70,3441.37,636653.45,0.00,0.00,0.00,0.00,0.00),('21','238','1','220',2192,'2','1',5174147.70,5177638.34,3490.64,645768.40,0.00,0.00,0.00,0.00,0.00),('21','238','2','220',2193,'5','1',33455.70,36727.03,3271.33,605196.05,0.00,0.00,0.00,0.00,0.00),('21','238','2','220',2194,'6','1',5702832.98,5706818.10,3985.12,737247.20,0.00,0.00,0.00,0.00,0.00),('21','238','3','220',2195,'9','1',5143886.58,5143886.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','220',2196,'11','1',5821135.48,5821135.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','220',2197,'13','2',2894184.36,2894184.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','220',2198,'15','2',564513.78,564513.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','220',2199,'16','2',287852.01,287852.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','220',2200,'17','3',597732.19,597782.69,50.50,43430.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','221',2201,'1','1',5831043.70,5834775.88,3732.18,690453.30,0.00,0.00,0.00,0.00,0.00),('21','238','1','221',2202,'2','1',5177638.34,5181540.69,3902.35,721934.75,0.00,0.00,0.00,0.00,0.00),('21','238','2','221',2203,'5','1',36727.03,40134.89,3407.86,630454.10,0.00,0.00,0.00,0.00,0.00),('21','238','2','221',2204,'6','1',5706818.10,5711408.32,4590.22,849190.70,0.00,0.00,0.00,0.00,0.00),('21','238','3','221',2205,'9','1',5143886.58,5150684.21,6797.63,1257561.55,0.00,0.00,0.00,0.00,0.00),('21','238','3','221',2206,'11','1',5821135.48,5826480.82,5345.34,988887.90,0.00,0.00,0.00,0.00,0.00),('21','238','4','221',2207,'13','2',2894184.36,2894184.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','221',2208,'15','2',564513.78,564513.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','221',2209,'16','2',287852.01,287852.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','221',2210,'17','3',597782.69,597827.81,45.12,38803.20,0.00,0.00,0.00,0.00,0.00),('21','238','1','222',2211,'1','1',5834775.88,5834775.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','222',2212,'2','1',5181540.69,5181540.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','222',2213,'5','1',40134.89,40134.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','222',2214,'6','1',5711408.32,5711408.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','222',2215,'9','1',5150684.21,5152088.87,1404.66,259862.10,0.00,0.00,0.00,0.00,0.00),('21','238','3','222',2216,'11','1',5826480.82,5828011.57,1530.75,283188.75,0.00,0.00,0.00,0.00,0.00),('21','238','4','222',2217,'13','2',2894184.36,2899007.34,4822.98,3993427.44,0.00,0.00,0.00,0.00,0.00),('21','238','5','222',2218,'15','2',564513.78,564513.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','222',2219,'16','2',287852.01,287852.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','222',2220,'17','3',597827.81,597868.83,41.02,35277.20,0.00,0.00,0.00,0.00,0.00),('21','238','1','223',2221,'1','1',5834775.88,5834775.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','223',2222,'2','1',5181540.69,5181540.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','223',2223,'5','1',40134.89,43851.30,3676.41,680135.85,0.00,0.00,40.00,0.00,0.00),('21','238','2','223',2224,'6','1',5711408.32,5716627.16,5188.84,959935.40,0.00,0.00,30.00,0.00,0.00),('21','238','3','223',2225,'9','1',5152088.87,5152088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','223',2226,'11','1',5828011.57,5828011.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','223',2227,'13','2',2899007.34,2906101.00,7093.66,5873550.48,0.00,0.00,0.00,0.00,0.00),('21','238','5','223',2228,'15','2',564513.78,564513.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','223',2229,'16','2',287852.01,287852.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','223',2230,'17','3',597868.83,597935.86,67.03,57645.80,0.00,0.00,0.00,0.00,0.00),('21','238','1','224',2231,'1','1',5834775.88,5834775.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','224',2232,'2','1',5181540.69,5181540.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','224',2233,'5','1',43851.30,46237.03,2385.73,441360.05,0.00,0.00,0.00,0.00,0.00),('21','238','2','224',2234,'6','1',5716627.16,5720213.76,3586.60,663521.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','224',2235,'9','1',5152088.87,5152088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','224',2236,'11','1',5828011.57,5828011.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','224',2237,'13','2',2906101.00,2913600.61,7499.61,6209677.08,0.00,0.00,0.00,0.00,0.00),('21','238','5','224',2238,'15','2',564513.78,564513.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','224',2239,'16','2',287852.01,287852.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','224',2240,'17','3',597935.86,597991.74,55.88,48056.80,0.00,0.00,0.00,0.00,0.00),('21','238','1','225',2241,'1','1',5834775.88,5834775.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','225',2242,'2','1',5181540.69,5181540.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','225',2243,'5','1',46237.03,51823.60,5586.57,1033515.45,0.00,0.00,0.00,0.00,0.00),('21','238','2','225',2244,'6','1',5720213.76,5726390.54,6176.78,1142704.30,0.00,0.00,0.00,0.00,0.00),('21','238','3','225',2245,'9','1',5152088.87,5152088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','225',2246,'11','1',5828011.57,5828011.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','225',2247,'13','2',2913600.61,2916008.59,2407.98,1993807.44,0.00,0.00,0.00,0.00,0.00),('21','238','5','225',2248,'15','2',564513.78,564513.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','225',2249,'16','2',287852.01,287852.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','225',2250,'17','3',597991.74,598021.91,30.17,25946.20,0.00,0.00,0.00,0.00,0.00),('21','238','1','226',2251,'1','1',5834775.88,5834775.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','226',2252,'2','1',5181540.69,5181540.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','226',2253,'5','1',51823.60,52139.27,315.67,58398.95,0.00,0.00,0.00,0.00,0.00),('21','238','2','226',2254,'6','1',5726390.54,5729639.85,3249.31,601122.35,0.00,0.00,0.00,0.00,0.00),('21','238','3','226',2255,'9','1',5152088.87,5152088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','226',2256,'11','1',5828011.57,5828011.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','226',2257,'13','2',2916008.59,2917936.17,1927.58,1596036.24,0.00,0.00,0.00,0.00,0.00),('21','238','5','226',2258,'15','2',564513.78,564513.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','226',2259,'16','2',287852.01,287852.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','226',2260,'17','3',598021.91,598058.78,36.87,31708.20,0.00,0.00,0.00,0.00,0.00),('21','238','1','227',2261,'1','1',5834775.88,5834775.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','227',2262,'2','1',5181540.69,5181540.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','227',2263,'5','1',52139.27,52139.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','227',2264,'6','1',5729639.85,5729639.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','227',2265,'9','1',5152088.87,5152088.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','227',2266,'11','1',5828011.57,5828011.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','227',2267,'13','2',2917936.17,2925517.12,7580.95,6277026.60,0.00,0.00,0.00,0.00,0.00),('21','238','5','227',2268,'15','2',564513.78,564513.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','227',2269,'16','2',287852.01,287852.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','227',2270,'17','3',598058.78,598073.91,15.13,13011.80,0.00,0.00,0.00,0.00,0.00),('21','238','1','228',2271,'1','1',5834775.88,5834775.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','228',2272,'2','1',5181540.69,5181540.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','228',2273,'5','1',52139.27,52139.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','228',2274,'6','1',5729639.85,5729639.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','228',2275,'9','1',5152088.87,5158704.86,6615.99,1257038.10,0.00,0.00,0.00,0.00,0.00),('21','238','3','228',2276,'11','1',5828011.57,5835380.43,7368.86,1400083.40,0.00,0.00,0.00,0.00,0.00),('21','238','4','228',2277,'13','2',2925517.12,2930434.95,4917.83,4071963.24,0.00,0.00,0.00,0.00,0.00),('21','238','5','228',2278,'15','2',564513.78,564513.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','228',2279,'16','2',287852.01,287852.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','228',2280,'17','3',598073.91,598106.19,32.28,27760.80,0.00,0.00,0.00,0.00,0.00),('21','238','1','229',2281,'1','1',5834775.88,5834775.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','229',2282,'2','1',5181540.69,5181540.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','229',2283,'5','1',52139.27,52139.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','229',2284,'6','1',5729639.85,5729639.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','229',2285,'9','1',5158704.86,5158704.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','229',2286,'11','1',5835380.43,5835380.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','229',2287,'13','2',2930434.95,2936130.43,5695.48,4715857.44,0.00,0.00,0.00,0.00,0.00),('21','238','5','229',2288,'15','2',564513.78,564513.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','229',2289,'16','2',287852.01,287852.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','229',2290,'17','3',598106.19,598129.20,23.01,19788.60,0.00,0.00,0.00,0.00,0.00),('21','238','1','230',2291,'1','1',5834775.88,5834775.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','230',2292,'2','1',5181540.69,5181540.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','230',2293,'5','1',52139.27,57643.67,5504.40,1045836.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','230',2294,'6','1',5729639.85,5732448.66,2808.81,533673.90,0.00,0.00,0.00,0.00,0.00),('21','238','3','230',2295,'9','1',5158704.86,5163656.23,4951.37,940760.30,0.00,0.00,0.00,0.00,0.00),('21','238','3','230',2296,'11','1',5835380.43,5838513.85,3133.42,595349.80,0.00,0.00,0.00,0.00,0.00),('21','238','4','230',2297,'13','2',2936130.43,2938530.87,2400.44,1987564.32,0.00,0.00,0.00,0.00,0.00),('21','238','5','230',2298,'15','2',564513.78,564513.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','230',2299,'16','2',287852.01,287852.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','230',2300,'17','3',598129.20,598164.58,35.38,30426.80,0.00,0.00,0.00,0.00,0.00),('21','238','1','231',2301,'1','1',5834775.88,5834775.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','231',2302,'2','1',5181540.69,5181540.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','231',2303,'5','1',57643.67,58552.09,908.42,172599.80,0.00,0.00,0.00,0.00,0.00),('21','238','2','231',2304,'6','1',5732448.66,5738323.08,5874.42,1116139.80,0.00,0.00,0.00,0.00,0.00),('21','238','3','231',2305,'9','1',5163656.23,5168026.34,4370.11,830320.90,0.00,0.00,0.00,0.00,0.00),('21','238','3','231',2306,'11','1',5838513.85,5840963.36,2449.51,465406.90,0.00,0.00,0.00,0.00,0.00),('21','238','4','231',2307,'13','2',2938530.87,2949644.56,11113.69,9202135.32,0.00,0.00,0.00,0.00,0.00),('21','238','5','231',2308,'15','2',564513.78,564513.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','231',2309,'16','2',287852.01,287852.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','231',2310,'17','3',598164.58,598193.71,29.13,25051.80,0.00,0.00,0.00,0.00,0.00),('21','238','1','232',2311,'1','1',5834775.88,5834775.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','232',2312,'2','1',5181540.69,5181540.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','232',2313,'5','1',58552.09,58552.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','232',2314,'6','1',5738323.08,5738323.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','232',2315,'9','1',5168026.34,5175243.92,7217.58,1371340.20,0.00,0.00,0.00,0.00,0.00),('21','238','3','232',2316,'11','1',5840963.36,5848467.36,7504.00,1425760.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','232',2317,'13','2',2949644.56,2952041.64,2397.08,1984782.24,0.00,0.00,0.00,0.00,0.00),('21','238','5','232',2318,'15','2',564513.78,564513.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','232',2319,'16','2',287852.01,287852.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','232',2320,'17','3',598193.71,598250.88,57.17,49166.20,0.00,0.00,0.00,0.00,0.00),('21','238','1','233',2321,'1','1',5834775.88,5834775.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','233',2322,'2','1',5181540.69,5181540.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','233',2323,'5','1',58552.09,65262.49,6690.40,1271176.00,0.00,0.00,20.00,0.00,0.00),('21','238','2','233',2324,'6','1',5738323.08,5746455.55,8112.47,1541369.30,0.00,0.00,20.00,0.00,0.00),('21','238','3','233',2325,'9','1',5175243.92,5175243.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','233',2326,'11','1',5848467.36,5848467.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','233',2327,'13','2',2952041.64,2952061.61,19.97,16535.16,0.00,0.00,0.00,0.00,0.00),('21','238','5','233',2328,'15','2',564513.78,564513.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','233',2329,'16','2',287852.01,287852.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','233',2330,'17','3',598250.88,598268.58,17.70,15222.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','234',2331,'1','1',5834775.88,5834775.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','234',2332,'2','1',5181540.69,5181540.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','234',2333,'5','1',65262.49,65262.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','234',2334,'6','1',5746455.55,5746455.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','234',2335,'9','1',5175243.92,5175243.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','234',2336,'11','1',5848467.36,5848467.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','234',2337,'13','2',2952061.61,2952071.64,10.03,8304.84,0.00,0.00,0.00,0.00,0.00),('21','238','5','234',2338,'15','2',564513.78,564513.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','234',2339,'16','2',287852.01,287852.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','234',2340,'17','3',598268.58,598314.62,46.04,39594.40,0.00,0.00,0.00,0.00,0.00),('21','238','1','235',2341,'1','1',5834775.88,5834775.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','235',2342,'2','1',5181540.69,5181540.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','235',2343,'5','1',65262.49,69819.00,4556.51,865736.90,0.00,0.00,0.00,0.00,0.00),('21','238','2','235',2344,'6','1',5746455.55,5752587.18,6131.63,1165009.70,0.00,0.00,0.00,0.00,0.00),('21','238','3','235',2345,'9','1',5175243.92,5175243.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','235',2346,'11','1',5848467.36,5848467.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','235',2347,'13','2',2952071.64,2952144.46,72.82,60294.96,0.00,0.00,0.00,0.00,0.00),('21','238','5','235',2348,'15','2',564513.78,564513.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','235',2349,'16','2',287852.01,287852.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','235',2350,'17','3',598314.62,598351.74,37.12,31923.20,0.00,0.00,0.00,0.00,0.00),('21','238','1','236',2351,'1','1',5834775.88,5834775.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','236',2352,'2','1',5181540.69,5181540.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','236',2353,'5','1',69819.00,70229.67,410.67,78027.30,0.00,0.00,0.00,0.00,0.00),('21','238','2','236',2354,'6','1',5752587.18,5756469.87,3882.69,737711.10,0.00,0.00,0.00,0.00,0.00),('21','238','3','236',2355,'9','1',5175243.92,5175243.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','236',2356,'11','1',5848467.36,5848467.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','236',2357,'13','2',2952144.46,2955045.67,2901.21,2402201.88,0.00,0.00,0.00,0.00,0.00),('21','238','5','236',2358,'15','2',564513.78,564513.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','236',2359,'16','2',287852.01,287852.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','236',2360,'17','3',598351.74,598398.23,46.49,39981.40,0.00,0.00,0.00,0.00,0.00),('21','238','1','237',2361,'1','1',5834775.88,5834775.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','237',2362,'2','1',5181540.69,5181540.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','237',2363,'5','1',70229.67,74626.73,4397.06,835441.40,0.00,0.00,0.00,0.00,0.00),('21','238','2','237',2364,'6','1',5756469.87,5763225.74,6755.87,1283615.30,0.00,0.00,0.00,0.00,0.00),('21','238','3','237',2365,'9','1',5175243.92,5175243.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','237',2366,'11','1',5848467.36,5848467.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','237',2367,'13','2',2955045.67,2960653.56,5607.89,4643332.92,0.00,0.00,0.00,0.00,0.00),('21','238','5','237',2368,'15','2',564513.78,564513.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','237',2369,'16','2',287852.01,287852.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','237',2370,'17','3',598398.23,598436.17,37.94,32628.40,0.00,0.00,0.00,0.00,0.00),('21','238','1','238',2371,'1','1',5834775.88,5834775.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','238',2372,'2','1',5181540.69,5181540.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','238',2373,'5','1',74626.73,75839.70,1212.97,230464.30,0.00,0.00,0.00,0.00,0.00),('21','238','2','238',2374,'6','1',5763225.74,5765796.01,2570.27,488351.30,0.00,0.00,0.00,0.00,0.00),('21','238','3','238',2375,'9','1',5175243.92,5175243.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','238',2376,'11','1',5848467.36,5848467.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','238',2377,'13','2',2960653.56,2967360.38,6706.82,5553246.96,0.00,0.00,0.00,0.00,0.00),('21','238','5','238',2378,'15','2',564513.78,564513.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','238',2379,'16','2',287852.01,287852.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','238',2380,'17','3',598436.17,598461.26,25.09,21577.40,0.00,0.00,0.00,0.00,0.00),('21','238','1','239',2381,'1','1',5834775.88,5834775.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','1','239',2382,'2','1',5181540.69,5181540.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','2','239',2383,'5','1',75839.70,81348.72,5509.02,1046713.80,0.00,0.00,0.00,0.00,0.00),('21','238','2','239',2384,'6','1',5765796.01,5774208.18,8412.17,1598312.30,0.00,0.00,0.00,0.00,0.00),('21','238','3','239',2385,'9','1',5175243.92,5175243.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','3','239',2386,'11','1',5848467.36,5848467.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','4','239',2387,'13','2',2967360.38,2967360.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','239',2388,'15','2',564513.78,564513.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','5','239',2389,'16','2',287852.01,287852.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','238','6','239',2390,'17','3',598461.26,598496.73,35.47,30504.20,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=718 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('21','238','1','2',698.00,698.00,6573.71,0.00,0.00,0.00,0.00,1),('21','238','1','3',550.00,550.00,166.71,0.00,0.00,0.00,0.00,2),('21','238','1','1',165.00,165.00,150.90,0.00,0.00,0.00,0.00,3),('21','238','2','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,4),('21','238','2','2',698.00,698.00,0.00,0.00,0.00,0.00,0.00,5),('21','238','2','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,6),('21','238','3','1',165.00,165.00,26119.54,0.00,0.00,0.00,0.00,7),('21','238','3','2',698.00,698.00,9940.00,0.00,0.00,0.00,0.00,8),('21','238','3','3',550.00,550.00,251.65,0.00,0.00,0.00,0.00,9),('21','238','4','1',165.00,165.00,13468.91,0.00,0.00,0.00,0.00,10),('21','238','4','2',698.00,698.00,11151.95,0.00,0.00,0.00,0.00,11),('21','238','4','3',550.00,550.00,444.10,0.00,0.00,0.00,0.00,12),('21','238','5','1',165.00,165.00,337.32,0.00,0.00,0.00,0.00,13),('21','238','5','2',698.00,698.00,4702.97,0.00,0.00,0.00,0.00,14),('21','238','5','3',550.00,550.00,519.16,0.00,0.00,0.00,0.00,15),('21','238','6','1',165.00,165.00,13687.64,0.00,0.00,0.00,0.00,16),('21','238','6','2',698.00,698.00,5247.39,0.00,0.00,0.00,0.00,17),('21','238','6','3',550.00,550.00,379.25,0.00,0.00,0.00,0.00,18),('21','238','7','1',165.00,165.00,15603.51,0.00,0.00,0.00,0.00,19),('21','238','7','2',698.00,698.00,6234.89,0.00,0.00,0.00,0.00,20),('21','238','7','3',550.00,550.00,254.30,0.00,0.00,0.00,0.00,21),('21','238','8','2',698.00,698.00,8197.66,0.00,0.00,0.00,0.00,22),('21','238','8','3',550.00,550.00,204.80,0.00,0.00,0.00,0.00,23),('21','238','8','1',165.00,165.00,16264.74,0.00,0.00,0.00,0.00,24),('21','238','9','2',698.00,698.00,7370.77,0.00,0.00,0.00,0.00,25),('21','238','9','3',550.00,550.00,203.11,0.00,0.00,0.00,0.00,26),('21','238','9','1',165.00,165.00,30040.70,0.00,0.00,0.00,0.00,27),('21','238','10','2',698.00,698.00,5945.67,0.00,0.00,0.00,0.00,28),('21','238','10','3',550.00,550.00,95.33,0.00,0.00,0.00,0.00,29),('21','238','10','1',165.00,165.00,27263.75,0.00,0.00,0.00,0.00,30),('21','238','11','1',165.00,165.00,17011.26,0.00,0.00,0.00,0.00,31),('21','238','11','2',698.00,698.00,7156.79,0.00,0.00,0.00,0.00,32),('21','238','11','3',550.00,550.00,118.74,0.00,0.00,0.00,0.00,33),('21','238','12','2',698.00,698.00,5245.93,0.00,0.00,0.00,0.00,34),('21','238','12','3',550.00,550.00,162.83,0.00,0.00,0.00,0.00,35),('21','238','12','1',165.00,165.00,16150.09,0.00,0.00,0.00,0.00,36),('21','238','13','1',165.00,165.00,14343.18,0.00,0.00,0.00,0.00,37),('21','238','13','2',698.00,698.00,6385.90,0.00,0.00,0.00,0.00,38),('21','238','13','3',550.00,550.00,140.96,0.00,0.00,0.00,0.00,39),('21','238','14','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,40),('21','238','14','2',698.00,698.00,7891.39,0.00,0.00,0.00,0.00,41),('21','238','14','3',550.00,550.00,74.17,0.00,0.00,0.00,0.00,42),('21','238','15','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,43),('21','238','15','2',698.00,698.00,3120.27,0.00,0.00,0.00,0.00,44),('21','238','15','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,45),('21','238','16','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,46),('21','238','16','2',678.00,678.00,0.00,0.00,0.00,0.00,0.00,47),('21','238','16','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,48),('21','238','17','2',678.00,678.00,4352.48,0.00,0.00,0.00,0.00,49),('21','238','17','3',550.00,550.00,103.51,0.00,0.00,0.00,0.00,50),('21','238','17','1',165.00,165.00,17212.80,0.00,0.00,0.00,0.00,51),('21','238','18','2',678.00,678.00,5893.67,0.00,0.00,0.00,0.00,52),('21','238','18','3',550.00,550.00,84.72,0.00,0.00,0.00,0.00,53),('21','238','18','1',165.00,165.00,14866.34,0.00,0.00,0.00,0.00,54),('21','238','19','1',165.00,165.00,12294.93,0.00,0.00,0.00,0.00,55),('21','238','19','2',678.00,678.00,9609.27,0.00,0.00,0.00,0.00,56),('21','238','19','3',550.00,550.00,124.44,0.00,0.00,0.00,0.00,57),('21','238','20','2',678.00,678.00,7905.23,0.00,0.00,0.00,0.00,58),('21','238','20','3',550.00,550.00,199.78,0.00,0.00,0.00,0.00,59),('21','238','20','1',165.00,165.00,14928.21,0.00,0.00,0.00,0.00,60),('21','238','21','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,61),('21','238','21','2',678.00,678.00,5796.82,0.00,0.00,0.00,0.00,62),('21','238','21','3',550.00,550.00,143.27,0.00,0.00,0.00,0.00,63),('21','238','22','1',165.00,165.00,14841.16,0.00,0.00,0.00,0.00,64),('21','238','22','2',678.00,678.00,7083.24,0.00,0.00,0.00,0.00,65),('21','238','22','3',550.00,550.00,133.17,0.00,0.00,0.00,0.00,66),('21','238','23','2',678.00,678.00,12364.34,0.00,0.00,0.00,0.00,67),('21','238','23','3',550.00,550.00,109.30,0.00,0.00,0.00,0.00,68),('21','238','23','1',165.00,165.00,22156.09,0.00,0.00,0.00,0.00,69),('21','238','24','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,70),('21','238','24','2',678.00,678.00,564.46,0.00,0.00,0.00,0.00,71),('21','238','24','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,72),('21','238','25','1',165.00,165.00,7945.07,0.00,0.00,0.00,0.00,73),('21','238','25','2',663.00,663.00,4815.54,0.00,0.00,0.00,0.00,74),('21','238','25','3',550.00,550.00,267.08,0.00,0.00,0.00,0.00,75),('21','238','26','2',663.00,663.00,6138.28,0.00,0.00,0.00,0.00,76),('21','238','26','3',550.00,550.00,218.55,0.00,0.00,0.00,0.00,77),('21','238','26','1',165.00,165.00,5666.57,0.00,0.00,0.00,0.00,78),('21','238','27','1',165.00,165.00,25555.03,0.00,0.00,0.00,0.00,79),('21','238','27','2',663.00,663.00,8939.34,0.00,0.00,0.00,0.00,80),('21','238','27','3',550.00,550.00,70.93,0.00,0.00,0.00,0.00,81),('21','238','28','1',165.00,165.00,14337.57,0.00,0.00,0.00,0.00,82),('21','238','28','2',663.00,663.00,8928.90,0.00,0.00,0.00,0.00,83),('21','238','28','3',550.00,550.00,171.29,0.00,0.00,0.00,0.00,84),('21','238','29','1',165.00,165.00,15162.51,0.00,0.00,0.00,0.00,85),('21','238','29','2',663.00,663.00,6845.21,0.00,0.00,0.00,0.00,86),('21','238','29','3',550.00,550.00,167.64,0.00,0.00,0.00,0.00,87),('21','238','30','1',165.00,165.00,17011.78,0.00,0.00,0.00,0.00,88),('21','238','30','2',663.00,663.00,6792.54,0.00,0.00,0.00,0.00,89),('21','238','30','3',550.00,550.00,250.06,0.00,0.00,0.00,0.00,90),('21','238','31','1',165.00,165.00,15350.75,0.00,0.00,0.00,0.00,91),('21','238','31','2',663.00,663.00,8167.29,0.00,0.00,0.00,0.00,92),('21','238','31','3',550.00,550.00,330.92,0.00,0.00,0.00,0.00,93),('21','238','32','2',663.00,663.00,9121.68,0.00,0.00,0.00,0.00,94),('21','238','32','3',550.00,550.00,143.20,0.00,0.00,0.00,0.00,95),('21','238','32','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,96),('21','238','33','1',165.00,165.00,29592.39,0.00,0.00,0.00,0.00,97),('21','238','33','2',663.00,663.00,7692.30,0.00,0.00,0.00,0.00,98),('21','238','33','3',550.00,550.00,137.65,0.00,0.00,0.00,0.00,99),('21','238','34','1',165.00,165.00,16842.03,0.00,0.00,0.00,0.00,100),('21','238','34','2',663.00,663.00,7516.97,0.00,0.00,0.00,0.00,101),('21','238','34','3',550.00,550.00,98.21,0.00,0.00,0.00,0.00,102),('21','238','35','2',663.00,663.00,2904.97,0.00,0.00,0.00,0.00,103),('21','238','35','3',550.00,550.00,232.82,0.00,0.00,0.00,0.00,104),('21','238','35','1',165.00,165.00,16347.34,0.00,0.00,0.00,0.00,105),('21','238','36','1',165.00,165.00,14757.38,0.00,0.00,0.00,0.00,106),('21','238','36','2',663.00,663.00,9350.57,0.00,0.00,0.00,0.00,107),('21','238','36','3',550.00,550.00,360.63,0.00,0.00,0.00,0.00,108),('21','238','37','1',165.00,165.00,20582.23,0.00,0.00,0.00,0.00,109),('21','238','37','2',663.00,663.00,6089.93,0.00,0.00,0.00,0.00,110),('21','238','37','3',550.00,550.00,195.89,0.00,0.00,0.00,0.00,111),('21','238','38','1',165.00,165.00,29005.77,0.00,0.00,0.00,0.00,112),('21','238','38','2',663.00,663.00,5684.89,0.00,0.00,0.00,0.00,113),('21','238','38','3',550.00,550.00,143.68,0.00,0.00,0.00,0.00,114),('21','238','39','1',165.00,165.00,14026.01,0.00,0.00,0.00,0.00,115),('21','238','39','2',663.00,663.00,3088.75,0.00,0.00,0.00,0.00,116),('21','238','39','3',550.00,550.00,42.47,0.00,0.00,0.00,0.00,117),('21','238','40','1',165.00,165.00,6947.74,0.00,0.00,0.00,0.00,118),('21','238','40','2',663.00,663.00,2651.48,0.00,0.00,0.00,0.00,119),('21','238','40','3',550.00,550.00,79.25,0.00,0.00,0.00,0.00,120),('21','238','41','2',663.00,663.00,11329.69,0.00,0.00,0.00,0.00,121),('21','238','41','3',550.00,550.00,191.65,0.00,0.00,0.00,0.00,122),('21','238','41','1',165.00,165.00,11438.32,0.00,0.00,0.00,0.00,123),('21','238','42','1',165.00,165.00,25072.22,0.00,0.00,0.00,0.00,124),('21','238','42','2',663.00,663.00,12027.48,0.00,0.00,0.00,0.00,125),('21','238','42','3',550.00,550.00,464.61,0.00,0.00,0.00,0.00,126),('21','238','43','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,127),('21','238','43','2',678.00,678.00,0.00,0.00,0.00,0.00,0.00,128),('21','238','43','3',550.00,550.00,0.00,0.00,0.00,0.00,0.00,129),('21','238','44','1',165.00,165.00,29962.19,0.00,0.00,0.00,0.00,130),('21','238','44','2',663.00,663.00,10411.25,0.00,0.00,0.00,0.00,131),('21','238','44','3',550.00,550.00,183.90,0.00,0.00,0.00,0.00,132),('21','238','45','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,133),('21','238','45','2',663.00,663.00,2257.06,0.00,0.00,0.00,0.00,134),('21','238','45','3',550.00,550.00,2.19,0.00,0.00,0.00,0.00,135),('21','238','46','2',678.00,678.00,6235.15,0.00,0.00,0.00,0.00,136),('21','238','46','3',650.00,650.00,201.79,0.00,0.00,0.00,0.00,137),('21','238','46','1',165.00,165.00,31847.12,0.00,0.00,0.00,0.00,138),('21','238','47','1',165.00,165.00,2902.59,0.00,0.00,0.00,0.00,139),('21','238','47','2',678.00,678.00,8600.22,0.00,0.00,0.00,0.00,140),('21','238','47','3',650.00,650.00,201.58,0.00,0.00,0.00,0.00,141),('21','238','48','2',678.00,678.00,13658.10,0.00,0.00,0.00,0.00,142),('21','238','48','3',650.00,650.00,184.15,0.00,0.00,0.00,0.00,143),('21','238','48','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,144),('21','238','49','2',678.00,678.00,14961.65,0.00,0.00,0.00,0.00,145),('21','238','49','3',650.00,650.00,321.14,0.00,0.00,0.00,0.00,146),('21','238','49','1',165.00,165.00,15007.91,0.00,0.00,0.00,0.00,147),('21','238','50','2',678.00,678.00,13495.81,0.00,0.00,0.00,0.00,148),('21','238','50','3',650.00,650.00,110.87,0.00,0.00,0.00,0.00,149),('21','238','50','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,150),('21','238','51','2',678.00,678.00,0.00,0.00,0.00,0.00,0.00,151),('21','238','51','3',650.00,650.00,111.75,0.00,0.00,0.00,0.00,152),('21','238','51','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,153),('21','238','52','2',678.00,678.00,0.00,0.00,0.00,0.00,0.00,154),('21','238','52','3',650.00,650.00,90.25,0.00,0.00,0.00,0.00,155),('21','238','52','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,156),('21','238','53','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,157),('21','238','53','2',718.00,718.00,8253.49,0.00,0.00,0.00,0.00,158),('21','238','53','3',650.00,650.00,172.92,0.00,0.00,0.00,0.00,159),('21','238','54','1',165.00,165.00,16597.74,0.00,0.00,0.00,0.00,160),('21','238','54','2',718.00,718.00,6845.30,0.00,0.00,0.00,0.00,161),('21','238','54','3',650.00,650.00,111.73,0.00,0.00,0.00,0.00,162),('21','238','55','2',718.00,718.00,0.00,0.00,0.00,0.00,0.00,163),('21','238','55','3',650.00,650.00,116.94,0.00,0.00,0.00,0.00,164),('21','238','55','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,165),('21','238','56','1',165.00,165.00,36246.72,0.00,0.00,0.00,0.00,166),('21','238','56','2',718.00,718.00,4743.49,0.00,0.00,0.00,0.00,167),('21','238','56','3',650.00,650.00,177.89,0.00,0.00,0.00,0.00,168),('21','238','57','1',165.00,165.00,15280.14,0.00,0.00,0.00,0.00,169),('21','238','57','2',718.00,718.00,10482.66,0.00,0.00,0.00,0.00,170),('21','238','57','3',650.00,650.00,118.63,0.00,0.00,0.00,0.00,171),('21','238','58','1',165.00,165.00,16151.14,0.00,0.00,0.00,0.00,172),('21','238','58','2',718.00,718.00,8371.20,0.00,0.00,0.00,0.00,173),('21','238','58','3',650.00,650.00,158.11,0.00,0.00,0.00,0.00,174),('21','238','59','1',165.00,165.00,15100.87,0.00,0.00,0.00,0.00,175),('21','238','59','2',718.00,718.00,5249.12,0.00,0.00,0.00,0.00,176),('21','238','59','3',650.00,650.00,139.13,0.00,0.00,0.00,0.00,177),('21','238','60','2',718.00,718.00,6795.82,0.00,0.00,0.00,0.00,178),('21','238','60','3',650.00,650.00,165.70,0.00,0.00,0.00,0.00,179),('21','238','60','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,180),('21','238','61','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,181),('21','238','61','2',718.00,718.00,9194.26,0.00,0.00,0.00,0.00,182),('21','238','61','3',650.00,650.00,0.00,0.00,0.00,0.00,0.00,183),('21','238','62','2',758.00,758.00,40.64,0.00,0.00,0.00,0.00,184),('21','238','62','3',650.00,650.00,228.97,0.00,0.00,0.00,0.00,185),('21','238','62','1',165.00,165.00,16121.42,0.00,0.00,0.00,0.00,186),('21','238','63','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,187),('21','238','63','2',758.00,758.00,0.00,0.00,0.00,0.00,0.00,188),('21','238','63','3',650.00,650.00,223.46,0.00,0.00,0.00,0.00,189),('21','238','64','2',758.00,758.00,0.00,0.00,0.00,0.00,0.00,190),('21','238','64','3',650.00,650.00,146.23,0.00,0.00,0.00,0.00,191),('21','238','64','1',165.00,165.00,22611.96,0.00,0.00,0.00,0.00,192),('21','238','65','1',165.00,165.00,22561.35,0.00,0.00,0.00,0.00,193),('21','238','65','2',758.00,758.00,2371.20,0.00,0.00,0.00,0.00,194),('21','238','65','3',650.00,650.00,90.23,0.00,0.00,0.00,0.00,195),('21','238','66','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,196),('21','238','66','2',758.00,758.00,10993.55,0.00,0.00,0.00,0.00,197),('21','238','66','3',650.00,650.00,372.24,0.00,0.00,0.00,0.00,198),('21','238','67','2',758.00,758.00,4923.68,0.00,0.00,0.00,0.00,199),('21','238','67','3',650.00,650.00,62.72,0.00,0.00,0.00,0.00,200),('21','238','67','1',165.00,165.00,17858.46,0.00,0.00,0.00,0.00,201),('21','238','68','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,202),('21','238','68','2',758.00,758.00,9571.75,0.00,0.00,0.00,0.00,203),('21','238','68','3',650.00,650.00,149.65,0.00,0.00,0.00,0.00,204),('21','238','69','1',165.00,165.00,14986.42,0.00,0.00,0.00,0.00,205),('21','238','69','2',758.00,758.00,824.41,0.00,0.00,0.00,0.00,206),('21','238','69','3',650.00,650.00,88.30,0.00,0.00,0.00,0.00,207),('21','238','70','2',758.00,758.00,4372.22,0.00,0.00,0.00,0.00,208),('21','238','70','3',650.00,650.00,136.27,0.00,0.00,0.00,0.00,209),('21','238','70','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,210),('21','238','71','1',165.00,165.00,7715.34,0.00,0.00,0.00,0.00,211),('21','238','71','2',758.00,758.00,9781.73,0.00,0.00,0.00,0.00,212),('21','238','71','3',650.00,650.00,101.83,0.00,0.00,0.00,0.00,213),('21','238','72','2',758.00,758.00,5847.38,0.00,0.00,0.00,0.00,214),('21','238','72','3',650.00,650.00,69.13,0.00,0.00,0.00,0.00,215),('21','238','72','1',165.00,165.00,11787.79,0.00,0.00,0.00,0.00,216),('21','238','73','1',165.00,165.00,11295.20,0.00,0.00,0.00,0.00,217),('21','238','73','2',758.00,758.00,13910.18,0.00,0.00,0.00,0.00,218),('21','238','73','3',650.00,650.00,197.52,0.00,0.00,0.00,0.00,219),('21','238','74','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,220),('21','238','74','2',758.00,758.00,6987.59,0.00,0.00,0.00,0.00,221),('21','238','74','3',650.00,650.00,89.73,0.00,0.00,0.00,0.00,222),('21','238','75','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,223),('21','238','75','2',758.00,758.00,6888.16,0.00,0.00,0.00,0.00,224),('21','238','75','3',650.00,650.00,0.00,0.00,0.00,0.00,0.00,225),('21','238','76','1',165.00,165.00,15013.45,0.00,0.00,0.00,0.00,226),('21','238','76','2',778.00,778.00,1308.59,0.00,0.00,0.00,0.00,227),('21','238','76','3',650.00,650.00,91.94,0.00,0.00,0.00,0.00,228),('21','238','77','2',778.00,778.00,6897.28,0.00,0.00,0.00,0.00,229),('21','238','77','3',650.00,650.00,219.79,0.00,0.00,0.00,0.00,230),('21','238','77','1',165.00,165.00,11659.15,0.00,0.00,0.00,0.00,231),('21','238','78','1',165.00,165.00,3409.23,0.00,0.00,0.00,0.00,232),('21','238','78','2',778.00,778.00,11442.99,0.00,0.00,0.00,0.00,233),('21','238','78','3',650.00,650.00,114.48,0.00,0.00,0.00,0.00,234),('21','238','79','1',165.00,165.00,27437.80,0.00,0.00,0.00,0.00,235),('21','238','79','2',778.00,778.00,9691.85,0.00,0.00,0.00,0.00,236),('21','238','79','3',650.00,650.00,76.81,0.00,0.00,0.00,0.00,237),('21','238','80','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,238),('21','238','80','2',778.00,778.00,2853.07,0.00,0.00,0.00,0.00,239),('21','238','80','3',650.00,650.00,38.24,0.00,0.00,0.00,0.00,240),('21','238','81','2',798.00,798.00,1447.14,0.00,0.00,0.00,0.00,241),('21','238','81','3',700.00,700.00,54.61,0.00,0.00,0.00,0.00,242),('21','238','81','1',165.00,165.00,28489.61,0.00,0.00,0.00,0.00,243),('21','238','82','1',165.00,165.00,27392.54,0.00,0.00,0.00,0.00,244),('21','238','82','2',798.00,798.00,10860.12,0.00,0.00,0.00,0.00,245),('21','238','82','3',700.00,700.00,130.26,0.00,0.00,0.00,0.00,246),('21','238','83','2',798.00,798.00,2880.70,0.00,0.00,0.00,0.00,247),('21','238','83','3',700.00,700.00,53.08,0.00,0.00,0.00,0.00,248),('21','238','83','1',165.00,165.00,13582.04,0.00,0.00,0.00,0.00,249),('21','238','84','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,250),('21','238','84','2',798.00,798.00,3182.33,0.00,0.00,0.00,0.00,251),('21','238','84','3',700.00,700.00,0.00,0.00,0.00,0.00,0.00,252),('21','238','85','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,253),('21','238','85','2',818.00,818.00,1022.00,0.00,0.00,0.00,0.00,254),('21','238','85','3',700.00,700.00,89.30,0.00,0.00,0.00,0.00,255),('21','238','86','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,256),('21','238','86','2',818.00,818.00,7219.07,0.00,0.00,0.00,0.00,257),('21','238','86','3',700.00,700.00,186.79,0.00,0.00,0.00,0.00,258),('21','238','87','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,259),('21','238','87','2',818.00,818.00,0.00,0.00,0.00,0.00,0.00,260),('21','238','87','3',700.00,700.00,0.00,0.00,0.00,0.00,0.00,261),('21','238','88','1',165.00,165.00,1299.57,0.00,0.00,0.00,0.00,262),('21','238','88','2',818.00,818.00,6986.78,0.00,0.00,0.00,0.00,263),('21','238','88','3',700.00,700.00,23.65,0.00,0.00,0.00,0.00,264),('21','238','89','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,265),('21','238','89','2',818.00,818.00,0.00,0.00,0.00,0.00,0.00,266),('21','238','89','3',700.00,700.00,0.00,0.00,0.00,0.00,0.00,267),('21','238','90','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,268),('21','238','90','2',818.00,818.00,0.00,0.00,0.00,0.00,0.00,269),('21','238','90','3',700.00,700.00,82.37,0.00,0.00,0.00,0.00,270),('21','238','91','1',165.00,165.00,31691.80,0.00,0.00,0.00,0.00,271),('21','238','91','2',818.00,818.00,9181.67,0.00,0.00,0.00,0.00,272),('21','238','91','3',750.00,750.00,79.44,0.00,0.00,0.00,0.00,273),('21','238','92','1',165.00,165.00,9604.82,0.00,0.00,0.00,0.00,274),('21','238','92','2',818.00,818.00,6818.43,0.00,0.00,0.00,0.00,275),('21','238','92','3',750.00,750.00,96.03,0.00,0.00,0.00,0.00,276),('21','238','93','2',818.00,818.00,4633.30,0.00,0.00,0.00,0.00,277),('21','238','93','3',750.00,750.00,150.43,0.00,0.00,0.00,0.00,278),('21','238','93','1',165.00,165.00,4707.49,0.00,0.00,0.00,0.00,279),('21','238','94','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,280),('21','238','94','2',818.00,818.00,0.00,0.00,0.00,0.00,0.00,281),('21','238','94','3',750.00,750.00,49.78,0.00,0.00,0.00,0.00,282),('21','238','95','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,283),('21','238','95','2',818.00,818.00,0.00,0.00,0.00,0.00,0.00,284),('21','238','95','3',750.00,750.00,103.34,0.00,0.00,0.00,0.00,285),('21','238','96','1',165.00,165.00,16312.19,0.00,0.00,0.00,0.00,286),('21','238','96','2',828.00,828.00,8899.94,0.00,0.00,0.00,0.00,287),('21','238','96','3',750.00,750.00,67.28,0.00,0.00,0.00,0.00,288),('21','238','97','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,289),('21','238','97','2',828.00,828.00,7779.00,0.00,0.00,0.00,0.00,290),('21','238','97','3',750.00,750.00,112.33,0.00,0.00,0.00,0.00,291),('21','238','98','1',165.00,165.00,20079.42,0.00,0.00,0.00,0.00,292),('21','238','98','2',828.00,828.00,9384.92,0.00,0.00,0.00,0.00,293),('21','238','98','3',750.00,750.00,87.40,0.00,0.00,0.00,0.00,294),('21','238','99','1',165.00,165.00,9403.81,0.00,0.00,0.00,0.00,295),('21','238','99','2',828.00,828.00,7662.74,0.00,0.00,0.00,0.00,296),('21','238','99','3',750.00,750.00,98.44,0.00,0.00,0.00,0.00,297),('21','238','100','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,298),('21','238','100','2',828.00,828.00,9079.28,0.00,0.00,0.00,0.00,299),('21','238','100','3',750.00,750.00,97.67,0.00,0.00,0.00,0.00,300),('21','238','101','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,301),('21','238','101','2',828.00,828.00,4322.28,0.00,0.00,0.00,0.00,302),('21','238','101','3',750.00,750.00,99.44,0.00,0.00,0.00,0.00,303),('21','238','102','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,304),('21','238','102','2',828.00,828.00,10129.52,0.00,0.00,0.00,0.00,305),('21','238','102','3',750.00,750.00,75.50,0.00,0.00,0.00,0.00,306),('21','238','103','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,307),('21','238','103','2',828.00,828.00,7160.02,0.00,0.00,0.00,0.00,308),('21','238','103','3',750.00,750.00,51.26,0.00,0.00,0.00,0.00,309),('21','238','104','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,310),('21','238','104','2',828.00,828.00,11159.71,0.00,0.00,0.00,0.00,311),('21','238','104','3',750.00,750.00,63.15,0.00,0.00,0.00,0.00,312),('21','238','105','1',165.00,165.00,14909.05,0.00,0.00,0.00,0.00,313),('21','238','105','2',828.00,828.00,10561.70,0.00,0.00,0.00,0.00,314),('21','238','105','3',750.00,750.00,104.80,0.00,0.00,0.00,0.00,315),('21','238','106','1',165.00,165.00,14412.48,0.00,0.00,0.00,0.00,316),('21','238','106','2',828.00,828.00,11948.06,0.00,0.00,0.00,0.00,317),('21','238','106','3',750.00,750.00,134.97,0.00,0.00,0.00,0.00,318),('21','238','107','1',165.00,165.00,503.17,0.00,0.00,0.00,0.00,319),('21','238','107','2',828.00,828.00,7621.70,0.00,0.00,0.00,0.00,320),('21','238','107','3',750.00,750.00,37.98,0.00,0.00,0.00,0.00,321),('21','238','108','1',165.00,165.00,104.83,0.00,0.00,0.00,0.00,322),('21','238','108','2',828.00,828.00,7227.84,0.00,0.00,0.00,0.00,323),('21','238','108','3',750.00,750.00,74.29,0.00,0.00,0.00,0.00,324),('21','238','109','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,325),('21','238','109','2',828.00,828.00,6982.55,0.00,0.00,0.00,0.00,326),('21','238','109','3',750.00,750.00,87.72,0.00,0.00,0.00,0.00,327),('21','238','110','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,328),('21','238','110','2',828.00,828.00,5799.13,0.00,0.00,0.00,0.00,329),('21','238','110','3',750.00,750.00,97.60,0.00,0.00,0.00,0.00,330),('21','238','111','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,331),('21','238','111','2',828.00,828.00,6936.03,0.00,0.00,0.00,0.00,332),('21','238','111','3',750.00,750.00,130.17,0.00,0.00,0.00,0.00,333),('21','238','112','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,334),('21','238','112','2',828.00,828.00,8083.40,0.00,0.00,0.00,0.00,335),('21','238','112','3',750.00,750.00,185.28,0.00,0.00,0.00,0.00,336),('21','238','113','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,337),('21','238','113','2',828.00,828.00,5140.92,0.00,0.00,0.00,0.00,338),('21','238','113','3',750.00,750.00,88.47,0.00,0.00,0.00,0.00,339),('21','238','114','1',165.00,165.00,17108.35,0.00,0.00,0.00,0.00,340),('21','238','114','2',828.00,828.00,4764.99,0.00,0.00,0.00,0.00,341),('21','238','114','3',750.00,750.00,130.42,0.00,0.00,0.00,0.00,342),('21','238','115','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,343),('21','238','115','2',828.00,828.00,3221.17,0.00,0.00,0.00,0.00,344),('21','238','115','3',750.00,750.00,132.41,0.00,0.00,0.00,0.00,345),('21','238','116','1',185.00,185.00,15171.74,0.00,0.00,0.00,0.00,346),('21','238','116','2',828.00,828.00,1309.07,0.00,0.00,0.00,0.00,347),('21','238','116','3',750.00,750.00,62.12,0.00,0.00,0.00,0.00,348),('21','238','117','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,349),('21','238','117','2',828.00,828.00,1961.80,0.00,0.00,0.00,0.00,350),('21','238','117','3',750.00,750.00,79.91,0.00,0.00,0.00,0.00,351),('21','238','118','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,352),('21','238','118','2',828.00,828.00,4442.22,0.00,0.00,0.00,0.00,353),('21','238','118','3',750.00,750.00,128.18,0.00,0.00,0.00,0.00,354),('21','238','119','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,355),('21','238','119','2',828.00,828.00,8074.79,0.00,0.00,0.00,0.00,356),('21','238','119','3',750.00,750.00,65.69,0.00,0.00,0.00,0.00,357),('21','238','120','2',828.00,828.00,8062.46,0.00,0.00,0.00,0.00,358),('21','238','120','3',750.00,750.00,72.40,0.00,0.00,0.00,0.00,359),('21','238','120','1',185.00,185.00,36427.14,0.00,0.00,0.00,0.00,360),('21','238','121','1',185.00,185.00,8765.70,0.00,0.00,0.00,0.00,361),('21','238','121','2',828.00,828.00,4547.08,0.00,0.00,0.00,0.00,362),('21','238','121','3',750.00,750.00,52.37,0.00,0.00,0.00,0.00,363),('21','238','122','1',185.00,185.00,15155.93,0.00,0.00,0.00,0.00,364),('21','238','122','2',828.00,828.00,7576.08,0.00,0.00,0.00,0.00,365),('21','238','122','3',750.00,750.00,52.93,0.00,0.00,0.00,0.00,366),('21','238','123','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,367),('21','238','123','2',828.00,828.00,3794.09,0.00,0.00,0.00,0.00,368),('21','238','123','3',750.00,750.00,182.26,0.00,0.00,0.00,0.00,369),('21','238','124','1',185.00,185.00,1802.16,0.00,0.00,0.00,0.00,370),('21','238','124','2',828.00,828.00,5521.56,0.00,0.00,0.00,0.00,371),('21','238','124','3',750.00,750.00,100.83,0.00,0.00,0.00,0.00,372),('21','238','125','1',190.00,190.00,13518.54,0.00,0.00,0.00,0.00,373),('21','238','125','2',828.00,828.00,6941.09,0.00,0.00,0.00,0.00,374),('21','238','125','3',750.00,750.00,139.08,0.00,0.00,0.00,0.00,375),('21','238','126','1',190.00,190.00,0.00,0.00,0.00,0.00,0.00,376),('21','238','126','2',828.00,828.00,5681.81,0.00,0.00,0.00,0.00,377),('21','238','126','3',750.00,750.00,109.86,0.00,0.00,0.00,0.00,378),('21','238','127','1',190.00,190.00,0.00,0.00,0.00,0.00,0.00,379),('21','238','127','2',828.00,828.00,4560.01,0.00,0.00,0.00,0.00,380),('21','238','127','3',750.00,750.00,0.00,0.00,0.00,0.00,0.00,381),('21','238','128','1',190.00,190.00,16515.37,0.00,0.00,0.00,0.00,382),('21','238','128','2',828.00,828.00,5052.75,0.00,0.00,0.00,0.00,383),('21','238','128','3',750.00,750.00,77.88,0.00,0.00,0.00,0.00,384),('21','238','129','1',190.00,190.00,14495.27,0.00,0.00,0.00,0.00,385),('21','238','129','2',813.00,813.00,5091.70,0.00,0.00,0.00,0.00,386),('21','238','129','3',750.00,750.00,54.71,0.00,0.00,0.00,0.00,387),('21','238','130','1',190.00,190.00,0.00,0.00,0.00,0.00,0.00,388),('21','238','130','2',813.00,813.00,8751.61,0.00,0.00,0.00,0.00,389),('21','238','130','3',750.00,750.00,67.89,0.00,0.00,0.00,0.00,390),('21','238','131','1',190.00,190.00,0.00,0.00,0.00,0.00,0.00,391),('21','238','131','2',813.00,813.00,6209.38,0.00,0.00,0.00,0.00,392),('21','238','131','3',750.00,750.00,133.60,0.00,0.00,0.00,0.00,393),('21','238','132','1',190.00,190.00,0.00,0.00,0.00,0.00,0.00,394),('21','238','132','2',813.00,813.00,5893.99,0.00,0.00,0.00,0.00,395),('21','238','132','3',750.00,750.00,83.29,0.00,0.00,0.00,0.00,396),('21','238','133','1',190.00,190.00,0.00,0.00,0.00,0.00,0.00,397),('21','238','133','2',813.00,813.00,6636.71,0.00,0.00,0.00,0.00,398),('21','238','133','3',750.00,750.00,109.30,0.00,0.00,0.00,0.00,399),('21','238','134','1',190.00,190.00,0.00,0.00,0.00,0.00,0.00,400),('21','238','134','2',813.00,813.00,0.00,0.00,0.00,0.00,0.00,401),('21','238','134','3',750.00,750.00,33.78,0.00,0.00,0.00,0.00,402),('21','238','135','2',813.00,813.00,4922.07,0.00,0.00,0.00,0.00,403),('21','238','135','3',835.00,835.00,48.70,0.00,0.00,0.00,0.00,404),('21','238','135','1',190.00,190.00,15479.39,0.00,0.00,0.00,0.00,405),('21','238','136','2',813.00,813.00,6196.91,0.00,0.00,0.00,0.00,406),('21','238','136','3',835.00,835.00,138.12,0.00,0.00,0.00,0.00,407),('21','238','136','1',190.00,190.00,14668.94,0.00,0.00,0.00,0.00,408),('21','238','137','1',190.00,190.00,17053.95,0.00,0.00,0.00,0.00,409),('21','238','137','2',813.00,813.00,7205.43,0.00,0.00,0.00,0.00,410),('21','238','137','3',835.00,835.00,46.63,0.00,0.00,0.00,0.00,411),('21','238','138','1',190.00,190.00,11374.05,0.00,0.00,0.00,0.00,412),('21','238','138','2',813.00,813.00,8161.18,0.00,0.00,0.00,0.00,413),('21','238','138','3',835.00,835.00,46.60,0.00,0.00,0.00,0.00,414),('21','238','139','1',190.00,190.00,14686.97,0.00,0.00,0.00,0.00,415),('21','238','139','2',813.00,813.00,3845.72,0.00,0.00,0.00,0.00,416),('21','238','139','3',835.00,835.00,58.28,0.00,0.00,0.00,0.00,417),('21','238','140','1',190.00,190.00,15869.04,0.00,0.00,0.00,0.00,418),('21','238','140','2',813.00,813.00,5605.23,0.00,0.00,0.00,0.00,419),('21','238','140','3',835.00,835.00,112.13,0.00,0.00,0.00,0.00,420),('21','238','141','1',190.00,190.00,15099.09,0.00,0.00,0.00,0.00,421),('21','238','141','2',813.00,813.00,9996.36,0.00,0.00,0.00,0.00,422),('21','238','141','3',835.00,835.00,69.67,0.00,0.00,0.00,0.00,423),('21','238','142','1',190.00,190.00,15039.17,0.00,0.00,0.00,0.00,424),('21','238','142','2',813.00,813.00,3461.91,0.00,0.00,0.00,0.00,425),('21','238','142','3',835.00,835.00,92.27,0.00,0.00,0.00,0.00,426),('21','238','143','1',190.00,190.00,20866.43,0.00,0.00,0.00,0.00,427),('21','238','143','2',813.00,813.00,9200.01,0.00,0.00,0.00,0.00,428),('21','238','143','3',835.00,835.00,79.45,0.00,0.00,0.00,0.00,429),('21','238','144','1',190.00,190.00,0.00,0.00,0.00,0.00,0.00,430),('21','238','144','2',813.00,813.00,0.00,0.00,0.00,0.00,0.00,431),('21','238','144','3',835.00,835.00,0.00,0.00,0.00,0.00,0.00,432),('21','238','145','1',190.00,190.00,9017.22,0.00,0.00,0.00,0.00,433),('21','238','145','2',813.00,813.00,7531.26,0.00,0.00,0.00,0.00,434),('21','238','145','3',835.00,835.00,79.96,0.00,0.00,0.00,0.00,435),('21','238','146','2',813.00,813.00,5489.28,0.00,0.00,0.00,0.00,436),('21','238','146','3',835.00,835.00,96.19,0.00,0.00,0.00,0.00,437),('21','238','146','1',190.00,190.00,29387.33,0.00,0.00,0.00,0.00,438),('21','238','147','1',190.00,190.00,15090.06,0.00,0.00,0.00,0.00,439),('21','238','147','2',813.00,813.00,3144.22,0.00,0.00,0.00,0.00,440),('21','238','147','3',835.00,835.00,51.63,0.00,0.00,0.00,0.00,441),('21','238','148','1',190.00,190.00,15030.52,0.00,0.00,0.00,0.00,442),('21','238','148','2',813.00,813.00,3197.46,0.00,0.00,0.00,0.00,443),('21','238','148','3',835.00,835.00,49.61,0.00,0.00,0.00,0.00,444),('21','238','149','1',190.00,190.00,0.00,0.00,0.00,0.00,0.00,445),('21','238','149','2',813.00,813.00,5362.10,0.00,0.00,0.00,0.00,446),('21','238','149','3',835.00,835.00,57.37,0.00,0.00,0.00,0.00,447),('21','238','150','1',190.00,190.00,15095.31,0.00,0.00,0.00,0.00,448),('21','238','150','2',813.00,813.00,8109.06,0.00,0.00,0.00,0.00,449),('21','238','150','3',835.00,835.00,53.52,0.00,0.00,0.00,0.00,450),('21','238','151','1',190.00,190.00,0.00,0.00,0.00,0.00,0.00,451),('21','238','151','2',813.00,813.00,7495.95,0.00,0.00,0.00,0.00,452),('21','238','151','3',835.00,835.00,23.79,0.00,0.00,0.00,0.00,453),('21','238','152','1',190.00,190.00,19109.89,0.00,0.00,0.00,0.00,454),('21','238','152','2',813.00,813.00,8863.30,0.00,0.00,0.00,0.00,455),('21','238','152','3',835.00,835.00,42.51,0.00,0.00,0.00,0.00,456),('21','238','153','1',190.00,190.00,0.00,0.00,0.00,0.00,0.00,457),('21','238','153','2',813.00,813.00,0.00,0.00,0.00,0.00,0.00,458),('21','238','153','3',835.00,835.00,20.52,0.00,0.00,0.00,0.00,459),('21','238','154','2',813.00,813.00,9713.13,0.00,0.00,0.00,0.00,460),('21','238','154','3',850.00,850.00,24.66,0.00,0.00,0.00,0.00,461),('21','238','154','1',190.00,190.00,20243.68,0.00,0.00,0.00,0.00,462),('21','238','155','1',190.00,190.00,5955.71,0.00,0.00,0.00,0.00,463),('21','238','155','2',813.00,813.00,4618.75,0.00,0.00,0.00,0.00,464),('21','238','155','3',850.00,850.00,31.14,0.00,0.00,0.00,0.00,465),('21','238','156','1',190.00,190.00,13992.83,0.00,0.00,0.00,0.00,466),('21','238','156','2',813.00,813.00,5129.80,0.00,0.00,0.00,0.00,467),('21','238','156','3',850.00,850.00,54.00,0.00,0.00,0.00,0.00,468),('21','238','157','1',190.00,190.00,0.00,0.00,0.00,0.00,0.00,469),('21','238','157','2',813.00,813.00,4798.56,0.00,0.00,0.00,0.00,470),('21','238','157','3',850.00,850.00,38.82,0.00,0.00,0.00,0.00,471),('21','238','158','1',190.00,190.00,7720.35,0.00,0.00,0.00,0.00,472),('21','238','158','2',813.00,813.00,8184.10,0.00,0.00,0.00,0.00,473),('21','238','158','3',850.00,850.00,49.57,0.00,0.00,0.00,0.00,474),('21','238','159','1',190.00,190.00,13713.91,0.00,0.00,0.00,0.00,475),('21','238','159','2',813.00,813.00,8034.00,0.00,0.00,0.00,0.00,476),('21','238','159','3',850.00,850.00,41.56,0.00,0.00,0.00,0.00,477),('21','238','160','1',190.00,190.00,14252.71,0.00,0.00,0.00,0.00,478),('21','238','160','2',813.00,813.00,6953.25,0.00,0.00,0.00,0.00,479),('21','238','160','3',860.00,860.00,38.75,0.00,0.00,0.00,0.00,480),('21','238','161','1',190.00,190.00,17241.45,0.00,0.00,0.00,0.00,481),('21','238','161','2',798.00,798.00,5769.55,0.00,0.00,0.00,0.00,482),('21','238','161','3',860.00,860.00,73.36,0.00,0.00,0.00,0.00,483),('21','238','162','1',190.00,190.00,17873.68,0.00,0.00,0.00,0.00,484),('21','238','162','2',798.00,798.00,4896.28,0.00,0.00,0.00,0.00,485),('21','238','162','3',860.00,860.00,40.38,0.00,0.00,0.00,0.00,486),('21','238','163','1',190.00,190.00,16773.00,0.00,0.00,0.00,0.00,487),('21','238','163','2',798.00,798.00,5762.42,0.00,0.00,0.00,0.00,488),('21','238','163','3',860.00,860.00,33.98,0.00,0.00,0.00,0.00,489),('21','238','164','1',190.00,190.00,16494.88,0.00,0.00,0.00,0.00,490),('21','238','164','2',798.00,798.00,7265.15,0.00,0.00,0.00,0.00,491),('21','238','164','3',860.00,860.00,33.51,0.00,0.00,0.00,0.00,492),('21','238','165','1',190.00,190.00,14962.64,0.00,0.00,0.00,0.00,493),('21','238','165','2',798.00,798.00,2478.14,0.00,0.00,0.00,0.00,494),('21','238','165','3',860.00,860.00,44.37,0.00,0.00,0.00,0.00,495),('21','238','166','1',190.00,190.00,16114.66,0.00,0.00,0.00,0.00,496),('21','238','166','2',798.00,798.00,3018.96,0.00,0.00,0.00,0.00,497),('21','238','166','3',860.00,860.00,29.75,0.00,0.00,0.00,0.00,498),('21','238','167','2',798.00,798.00,6038.39,0.00,0.00,0.00,0.00,499),('21','238','167','3',860.00,860.00,33.91,0.00,0.00,0.00,0.00,500),('21','238','167','1',190.00,190.00,13220.71,0.00,0.00,0.00,0.00,501),('21','238','168','1',190.00,190.00,15907.93,0.00,0.00,0.00,0.00,502),('21','238','168','2',798.00,798.00,4501.04,0.00,0.00,0.00,0.00,503),('21','238','168','3',860.00,860.00,22.34,0.00,0.00,0.00,0.00,504),('21','238','169','1',190.00,190.00,11667.00,0.00,0.00,0.00,0.00,505),('21','238','169','2',798.00,798.00,5503.72,0.00,0.00,0.00,0.00,506),('21','238','169','3',860.00,860.00,51.34,0.00,0.00,0.00,0.00,507),('21','238','170','1',190.00,190.00,14639.44,0.00,0.00,0.00,0.00,508),('21','238','170','2',798.00,798.00,5348.87,0.00,0.00,0.00,0.00,509),('21','238','170','3',860.00,860.00,38.49,0.00,0.00,0.00,0.00,510),('21','238','171','1',190.00,190.00,14377.74,0.00,0.00,0.00,0.00,511),('21','238','171','2',798.00,798.00,6042.87,0.00,0.00,0.00,0.00,512),('21','238','171','3',860.00,860.00,41.49,0.00,0.00,0.00,0.00,513),('21','238','172','1',190.00,190.00,14843.35,0.00,0.00,0.00,0.00,514),('21','238','172','2',798.00,798.00,5358.08,0.00,0.00,0.00,0.00,515),('21','238','172','3',860.00,860.00,31.40,0.00,0.00,0.00,0.00,516),('21','238','173','1',190.00,190.00,14815.02,0.00,0.00,0.00,0.00,517),('21','238','173','2',798.00,798.00,6525.69,0.00,0.00,0.00,0.00,518),('21','238','173','3',860.00,860.00,39.55,0.00,0.00,0.00,0.00,519),('21','238','174','1',190.00,190.00,14129.87,0.00,0.00,0.00,0.00,520),('21','238','174','2',798.00,798.00,3732.27,0.00,0.00,0.00,0.00,521),('21','238','174','3',860.00,860.00,38.87,0.00,0.00,0.00,0.00,522),('21','238','175','1',190.00,190.00,17820.76,0.00,0.00,0.00,0.00,523),('21','238','175','2',798.00,798.00,5006.23,0.00,0.00,0.00,0.00,524),('21','238','175','3',860.00,860.00,38.67,0.00,0.00,0.00,0.00,525),('21','238','176','1',190.00,190.00,17089.84,0.00,0.00,0.00,0.00,526),('21','238','176','2',798.00,798.00,5606.35,0.00,0.00,0.00,0.00,527),('21','238','176','3',860.00,860.00,48.57,0.00,0.00,0.00,0.00,528),('21','238','177','2',798.00,798.00,7294.88,0.00,0.00,0.00,0.00,529),('21','238','177','3',860.00,860.00,49.45,0.00,0.00,0.00,0.00,530),('21','238','177','1',190.00,190.00,19351.75,0.00,0.00,0.00,0.00,531),('21','238','178','1',190.00,190.00,18073.19,0.00,0.00,0.00,0.00,532),('21','238','178','2',798.00,798.00,6182.55,0.00,0.00,0.00,0.00,533),('21','238','178','3',860.00,860.00,61.14,0.00,0.00,0.00,0.00,534),('21','238','179','1',190.00,190.00,12013.84,0.00,0.00,0.00,0.00,535),('21','238','179','2',798.00,798.00,6920.36,0.00,0.00,0.00,0.00,536),('21','238','179','3',860.00,860.00,30.20,0.00,0.00,0.00,0.00,537),('21','238','180','1',190.00,190.00,0.00,0.00,0.00,0.00,0.00,538),('21','238','180','2',798.00,798.00,6181.69,0.00,0.00,0.00,0.00,539),('21','238','180','3',860.00,860.00,74.86,0.00,0.00,0.00,0.00,540),('21','238','181','1',190.00,190.00,16633.11,0.00,0.00,0.00,0.00,541),('21','238','181','2',798.00,798.00,5311.74,0.00,0.00,0.00,0.00,542),('21','238','181','3',860.00,860.00,35.63,0.00,0.00,0.00,0.00,543),('21','238','182','1',190.00,190.00,14959.60,0.00,0.00,0.00,0.00,544),('21','238','182','2',798.00,798.00,5615.45,0.00,0.00,0.00,0.00,545),('21','238','182','3',860.00,860.00,37.26,0.00,0.00,0.00,0.00,546),('21','238','183','2',798.00,798.00,6323.97,0.00,0.00,0.00,0.00,547),('21','238','183','3',860.00,860.00,28.19,0.00,0.00,0.00,0.00,548),('21','238','183','1',190.00,190.00,15657.04,0.00,0.00,0.00,0.00,549),('21','238','184','1',190.00,190.00,15164.07,0.00,0.00,0.00,0.00,550),('21','238','184','2',798.00,798.00,4970.02,0.00,0.00,0.00,0.00,551),('21','238','184','3',860.00,860.00,59.65,0.00,0.00,0.00,0.00,552),('21','238','185','2',798.00,798.00,5128.13,0.00,0.00,0.00,0.00,553),('21','238','185','3',860.00,860.00,52.21,0.00,0.00,0.00,0.00,554),('21','238','185','1',190.00,190.00,16070.39,0.00,0.00,0.00,0.00,555),('21','238','186','2',798.00,798.00,0.00,0.00,0.00,0.00,0.00,556),('21','238','186','3',860.00,860.00,23.79,0.00,0.00,0.00,0.00,557),('21','238','186','1',190.00,190.00,14746.16,0.00,0.00,0.00,0.00,558),('21','238','187','1',190.00,190.00,16245.44,0.00,0.00,0.00,0.00,559),('21','238','187','2',798.00,798.00,0.00,0.00,0.00,0.00,0.00,560),('21','238','187','3',860.00,860.00,32.93,0.00,0.00,0.00,0.00,561),('21','238','188','1',190.00,190.00,14385.01,0.00,0.00,0.00,0.00,562),('21','238','188','2',798.00,798.00,0.00,0.00,0.00,0.00,0.00,563),('21','238','188','3',860.00,860.00,79.30,0.00,0.00,0.00,0.00,564),('21','238','189','1',190.00,190.00,12713.31,0.00,0.00,0.00,0.00,565),('21','238','189','2',798.00,798.00,0.00,0.00,0.00,0.00,0.00,566),('21','238','189','3',860.00,860.00,33.48,0.00,0.00,0.00,0.00,567),('21','238','190','1',190.00,190.00,13414.46,0.00,0.00,0.00,0.00,568),('21','238','190','2',798.00,798.00,4275.49,0.00,0.00,0.00,0.00,569),('21','238','190','3',860.00,860.00,33.17,0.00,0.00,0.00,0.00,570),('21','238','191','1',190.00,190.00,13152.73,0.00,0.00,0.00,0.00,571),('21','238','191','2',798.00,798.00,7845.91,0.00,0.00,0.00,0.00,572),('21','238','191','3',860.00,860.00,25.12,0.00,0.00,0.00,0.00,573),('21','238','192','1',190.00,190.00,9899.88,0.00,0.00,0.00,0.00,574),('21','238','192','2',798.00,798.00,2823.52,0.00,0.00,0.00,0.00,575),('21','238','192','3',860.00,860.00,46.42,0.00,0.00,0.00,0.00,576),('21','238','193','1',190.00,190.00,12228.30,0.00,0.00,0.00,0.00,577),('21','238','193','2',798.00,798.00,2045.60,0.00,0.00,0.00,0.00,578),('21','238','193','3',860.00,860.00,48.75,0.00,0.00,0.00,0.00,579),('21','238','194','2',798.00,798.00,0.00,0.00,0.00,0.00,0.00,580),('21','238','194','3',860.00,860.00,0.00,0.00,0.00,0.00,0.00,581),('21','238','194','1',190.00,190.00,7518.64,0.00,0.00,0.00,0.00,582),('21','238','195','1',185.00,185.00,4939.85,0.00,0.00,0.00,0.00,583),('21','238','195','2',798.00,798.00,6619.44,0.00,0.00,0.00,0.00,584),('21','238','195','3',860.00,860.00,30.53,0.00,0.00,0.00,0.00,585),('21','238','196','1',185.00,185.00,13073.17,0.00,0.00,0.00,0.00,586),('21','238','196','2',798.00,798.00,6434.87,0.00,0.00,0.00,0.00,587),('21','238','196','3',860.00,860.00,36.01,0.00,0.00,0.00,0.00,588),('21','238','197','1',185.00,185.00,15845.34,0.00,0.00,0.00,0.00,589),('21','238','197','2',798.00,798.00,0.00,0.00,0.00,0.00,0.00,590),('21','238','197','3',860.00,860.00,26.83,0.00,0.00,0.00,0.00,591),('21','238','198','1',185.00,185.00,11583.98,0.00,0.00,0.00,0.00,592),('21','238','198','2',798.00,798.00,0.00,0.00,0.00,0.00,0.00,593),('21','238','198','3',860.00,860.00,23.26,0.00,0.00,0.00,0.00,594),('21','238','199','1',185.00,185.00,15269.53,0.00,0.00,0.00,0.00,595),('21','238','199','2',798.00,798.00,0.00,0.00,0.00,0.00,0.00,596),('21','238','199','3',860.00,860.00,74.62,0.00,0.00,0.00,0.00,597),('21','238','200','1',185.00,185.00,14281.44,0.00,0.00,0.00,0.00,598),('21','238','200','2',798.00,798.00,1718.77,0.00,0.00,0.00,0.00,599),('21','238','200','3',860.00,860.00,29.66,0.00,0.00,0.00,0.00,600),('21','238','201','2',798.00,798.00,7270.10,0.00,0.00,0.00,0.00,601),('21','238','201','3',860.00,860.00,47.06,0.00,0.00,0.00,0.00,602),('21','238','201','1',185.00,185.00,12804.86,0.00,0.00,0.00,0.00,603),('21','238','202','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,604),('21','238','202','2',798.00,798.00,0.00,0.00,0.00,0.00,0.00,605),('21','238','202','3',860.00,860.00,0.00,0.00,0.00,0.00,0.00,606),('21','238','203','1',185.00,185.00,14578.08,0.00,0.00,0.00,0.00,607),('21','238','203','2',798.00,798.00,6037.25,0.00,0.00,0.00,0.00,608),('21','238','203','3',860.00,860.00,19.12,0.00,0.00,0.00,0.00,609),('21','238','204','1',185.00,185.00,16888.08,0.00,0.00,0.00,0.00,610),('21','238','204','2',798.00,798.00,0.00,0.00,0.00,0.00,0.00,611),('21','238','204','3',860.00,860.00,64.60,0.00,0.00,0.00,0.00,612),('21','238','205','1',185.00,185.00,20223.34,0.00,0.00,0.00,0.00,613),('21','238','205','2',818.00,818.00,0.00,0.00,0.00,0.00,0.00,614),('21','238','205','3',860.00,860.00,13.93,0.00,0.00,0.00,0.00,615),('21','238','206','1',185.00,185.00,19957.36,0.00,0.00,0.00,0.00,616),('21','238','206','2',818.00,818.00,0.00,0.00,0.00,0.00,0.00,617),('21','238','206','3',860.00,860.00,49.28,0.00,0.00,0.00,0.00,618),('21','238','207','1',185.00,185.00,20277.10,0.00,0.00,0.00,0.00,619),('21','238','207','2',818.00,818.00,0.00,0.00,0.00,0.00,0.00,620),('21','238','207','3',860.00,860.00,27.48,0.00,0.00,0.00,0.00,621),('21','238','208','1',185.00,185.00,18667.39,0.00,0.00,0.00,0.00,622),('21','238','208','2',818.00,818.00,0.00,0.00,0.00,0.00,0.00,623),('21','238','208','3',860.00,860.00,47.78,0.00,0.00,0.00,0.00,624),('21','238','209','1',185.00,185.00,17945.60,0.00,0.00,0.00,0.00,625),('21','238','209','2',818.00,818.00,0.00,0.00,0.00,0.00,0.00,626),('21','238','209','3',860.00,860.00,46.85,0.00,0.00,0.00,0.00,627),('21','238','210','1',185.00,185.00,17130.83,0.00,0.00,0.00,0.00,628),('21','238','210','2',818.00,818.00,12886.86,0.00,0.00,0.00,0.00,629),('21','238','210','3',860.00,860.00,37.54,0.00,0.00,0.00,0.00,630),('21','238','211','1',185.00,185.00,19626.75,0.00,0.00,0.00,0.00,631),('21','238','211','2',818.00,818.00,12397.07,0.00,0.00,0.00,0.00,632),('21','238','211','3',860.00,860.00,33.12,0.00,0.00,0.00,0.00,633),('21','238','212','1',185.00,185.00,10148.87,0.00,0.00,0.00,0.00,634),('21','238','212','2',818.00,818.00,5873.89,0.00,0.00,0.00,0.00,635),('21','238','212','3',860.00,860.00,54.74,0.00,0.00,0.00,0.00,636),('21','238','213','2',818.00,818.00,4250.88,0.00,0.00,0.00,0.00,637),('21','238','213','3',860.00,860.00,24.72,0.00,0.00,0.00,0.00,638),('21','238','213','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,639),('21','238','214','1',185.00,185.00,24600.31,0.00,0.00,0.00,0.00,640),('21','238','214','2',818.00,818.00,50.00,0.00,0.00,0.00,0.00,641),('21','238','214','3',860.00,860.00,50.48,0.00,0.00,0.00,0.00,642),('21','238','215','1',185.00,185.00,15005.35,0.00,0.00,0.00,0.00,643),('21','238','215','2',818.00,818.00,619.02,0.00,0.00,0.00,0.00,644),('21','238','215','3',860.00,860.00,36.91,0.00,0.00,0.00,0.00,645),('21','238','216','1',185.00,185.00,35811.15,0.00,0.00,0.00,0.00,646),('21','238','216','2',818.00,818.00,30.00,0.00,0.00,0.00,0.00,647),('21','238','216','3',860.00,860.00,28.60,0.00,0.00,0.00,0.00,648),('21','238','217','1',185.00,185.00,27140.54,0.00,0.00,0.00,0.00,649),('21','238','217','2',818.00,818.00,39.77,0.00,0.00,0.00,0.00,650),('21','238','217','3',860.00,860.00,37.19,0.00,0.00,0.00,0.00,651),('21','238','218','1',185.00,185.00,25544.39,0.00,0.00,0.00,0.00,652),('21','238','218','2',818.00,818.00,406.98,0.00,0.00,0.00,0.00,653),('21','238','218','3',860.00,860.00,30.56,0.00,0.00,0.00,0.00,654),('21','238','219','1',185.00,185.00,4509.31,0.00,0.00,0.00,0.00,655),('21','238','219','2',818.00,818.00,0.00,0.00,0.00,0.00,0.00,656),('21','238','219','3',860.00,860.00,29.91,0.00,0.00,0.00,0.00,657),('21','238','220','2',828.00,828.00,0.00,0.00,0.00,0.00,0.00,658),('21','238','220','3',860.00,860.00,50.50,0.00,0.00,0.00,0.00,659),('21','238','220','1',185.00,185.00,14188.46,0.00,0.00,0.00,0.00,660),('21','238','221','1',185.00,185.00,27775.58,0.00,0.00,0.00,0.00,661),('21','238','221','2',828.00,828.00,0.00,0.00,0.00,0.00,0.00,662),('21','238','221','3',860.00,860.00,45.12,0.00,0.00,0.00,0.00,663),('21','238','222','2',828.00,828.00,4822.98,0.00,0.00,0.00,0.00,664),('21','238','222','3',860.00,860.00,41.02,0.00,0.00,0.00,0.00,665),('21','238','222','1',185.00,185.00,2935.41,0.00,0.00,0.00,0.00,666),('21','238','223','1',185.00,185.00,8865.25,0.00,0.00,0.00,0.00,667),('21','238','223','2',828.00,828.00,7093.66,0.00,0.00,0.00,0.00,668),('21','238','223','3',860.00,860.00,67.03,0.00,0.00,0.00,0.00,669),('21','238','224','1',185.00,185.00,5972.33,0.00,0.00,0.00,0.00,670),('21','238','224','2',828.00,828.00,7499.61,0.00,0.00,0.00,0.00,671),('21','238','224','3',860.00,860.00,55.88,0.00,0.00,0.00,0.00,672),('21','238','225','1',185.00,185.00,11763.35,0.00,0.00,0.00,0.00,673),('21','238','225','2',828.00,828.00,2407.98,0.00,0.00,0.00,0.00,674),('21','238','225','3',860.00,860.00,30.17,0.00,0.00,0.00,0.00,675),('21','238','226','1',185.00,185.00,3564.98,0.00,0.00,0.00,0.00,676),('21','238','226','2',828.00,828.00,1927.58,0.00,0.00,0.00,0.00,677),('21','238','226','3',860.00,860.00,36.87,0.00,0.00,0.00,0.00,678),('21','238','227','1',185.00,185.00,0.00,0.00,0.00,0.00,0.00,679),('21','238','227','2',828.00,828.00,7580.95,0.00,0.00,0.00,0.00,680),('21','238','227','3',860.00,860.00,15.13,0.00,0.00,0.00,0.00,681),('21','238','228','1',190.00,190.00,13984.85,0.00,0.00,0.00,0.00,682),('21','238','228','2',828.00,828.00,4917.83,0.00,0.00,0.00,0.00,683),('21','238','228','3',860.00,860.00,32.28,0.00,0.00,0.00,0.00,684),('21','238','229','1',190.00,190.00,0.00,0.00,0.00,0.00,0.00,685),('21','238','229','2',828.00,828.00,5695.48,0.00,0.00,0.00,0.00,686),('21','238','229','3',860.00,860.00,23.01,0.00,0.00,0.00,0.00,687),('21','238','230','1',190.00,190.00,16398.00,0.00,0.00,0.00,0.00,688),('21','238','230','2',828.00,828.00,2400.44,0.00,0.00,0.00,0.00,689),('21','238','230','3',860.00,860.00,35.38,0.00,0.00,0.00,0.00,690),('21','238','231','1',190.00,190.00,13602.46,0.00,0.00,0.00,0.00,691),('21','238','231','2',828.00,828.00,11113.69,0.00,0.00,0.00,0.00,692),('21','238','231','3',860.00,860.00,29.13,0.00,0.00,0.00,0.00,693),('21','238','232','2',828.00,828.00,2397.08,0.00,0.00,0.00,0.00,694),('21','238','232','3',860.00,860.00,57.17,0.00,0.00,0.00,0.00,695),('21','238','232','1',190.00,190.00,14721.58,0.00,0.00,0.00,0.00,696),('21','238','233','1',190.00,190.00,14802.87,0.00,0.00,0.00,0.00,697),('21','238','233','2',828.00,828.00,19.97,0.00,0.00,0.00,0.00,698),('21','238','233','3',860.00,860.00,17.70,0.00,0.00,0.00,0.00,699),('21','238','234','1',190.00,190.00,0.00,0.00,0.00,0.00,0.00,700),('21','238','234','2',828.00,828.00,10.03,0.00,0.00,0.00,0.00,701),('21','238','234','3',860.00,860.00,46.04,0.00,0.00,0.00,0.00,702),('21','238','235','1',190.00,190.00,10688.14,0.00,0.00,0.00,0.00,703),('21','238','235','2',828.00,828.00,72.82,0.00,0.00,0.00,0.00,704),('21','238','235','3',860.00,860.00,37.12,0.00,0.00,0.00,0.00,705),('21','238','236','1',190.00,190.00,4293.36,0.00,0.00,0.00,0.00,706),('21','238','236','2',828.00,828.00,2901.21,0.00,0.00,0.00,0.00,707),('21','238','236','3',860.00,860.00,46.49,0.00,0.00,0.00,0.00,708),('21','238','237','1',190.00,190.00,11152.93,0.00,0.00,0.00,0.00,709),('21','238','237','2',828.00,828.00,5607.89,0.00,0.00,0.00,0.00,710),('21','238','237','3',860.00,860.00,37.94,0.00,0.00,0.00,0.00,711),('21','238','238','1',190.00,190.00,3783.24,0.00,0.00,0.00,0.00,712),('21','238','238','2',828.00,828.00,6706.82,0.00,0.00,0.00,0.00,713),('21','238','238','3',860.00,860.00,25.09,0.00,0.00,0.00,0.00,714),('21','238','239','1',190.00,190.00,13921.19,0.00,0.00,0.00,0.00,715),('21','238','239','2',828.00,828.00,0.00,0.00,0.00,0.00,0.00,716),('21','238','239','3',860.00,860.00,35.47,0.00,0.00,0.00,0.00,717);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('21',1,'238','PRODUCT TANKS','TANKS CONTAINING PETROLEUM PRODUCTS');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('21','238','1',1,0,'1','PMS TANK 1',33000.00,0.00,NULL,'TANK CONTAINING PETROLEUM PRODUCT.','764','2022-03-03 23:46:37','2022-03-03 23:46:37','764',5,0),('21','238','1',2,0,'1','PMS TANK 2',33000.00,0.00,NULL,'TANK CONTAINING PETROLEUM PRODUCT.','764','2022-03-03 23:49:30','2022-03-03 23:49:30','764',5,0),('21','238','1',3,0,'1','PMS TANK 3',33000.00,0.00,NULL,'TANK CONTAINING PETROLEUM PRODUCTS.','764','2022-03-03 23:52:37','2022-03-03 23:52:37','764',5,0),('21','238','1',4,0,'2','AGO TANK',33000.00,0.00,NULL,'TANK CONTAINING DEISEL PRODUCTS.','764','2022-03-03 23:55:37','2022-03-03 23:55:37','764',5,0),('21','238','1',5,0,'2','AGO TANK 2',33000.00,0.00,NULL,'TANK CONTAINING DEISEL PRODUCTS.','764','2022-03-03 23:57:28','2022-03-03 23:57:28','764',5,0),('21','238','1',6,0,'3','DPK TANK ',33000.00,0.00,NULL,'TANK CONTAINING KEROSINE PRODUCTS','764','2022-03-03 23:59:20','2022-03-03 23:59:40','764',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2806 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (1,'21','238','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,0.00,0.00,'2022-03-30 12:08:32','',''),(2,'21','238','1',0,'Inventory adjustment from tank dipping to 1200',0.00,0.00,1200.00,0.00,0.00,'2022-03-30 12:08:32','',''),(3,'21','238','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,0.00,0.00,'2022-03-30 12:09:01','',''),(4,'21','238','2',0,'Inventory adjustment from tank dipping to 750',0.00,0.00,750.00,0.00,0.00,'2022-03-30 12:09:01','',''),(5,'21','238','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,0.00,0.00,'2022-03-30 12:09:19','',''),(6,'21','238','3',0,'Inventory adjustment from tank dipping to 1200',0.00,0.00,1200.00,0.00,0.00,'2022-03-30 12:09:19','',''),(7,'21','238','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,0.00,0.00,'2022-03-30 12:09:43','',''),(8,'21','238','4',0,'Inventory adjustment from tank dipping to 1000',0.00,0.00,1000.00,0.00,0.00,'2022-03-30 12:09:43','',''),(9,'21','238','5',0,'Tank level zero out for dipping',0.00,0.00,0.00,0.00,0.00,'2022-03-30 12:10:01','',''),(10,'21','238','5',0,'Inventory adjustment from tank dipping to 650',0.00,0.00,650.00,0.00,0.00,'2022-03-30 12:10:01','',''),(11,'21','238','6',0,'Tank level zero out for dipping',0.00,0.00,0.00,0.00,0.00,'2022-03-30 12:10:46','',''),(12,'21','238','6',0,'Inventory adjustment from tank dipping to 15450',0.00,0.00,15450.00,0.00,0.00,'2022-03-30 12:10:46','',''),(13,'21','238','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,1000.00,0.00,'2022-03-30 12:12:45','',''),(14,'21','238','4',0,'Inventory adjustment from tank dipping to 20900',0.00,0.00,20900.00,0.00,0.00,'2022-03-30 12:12:45','',''),(15,'21','238','5',0,'Tank level zero out for dipping',0.00,0.00,0.00,650.00,0.00,'2022-03-30 12:13:08','',''),(16,'21','238','5',0,'Inventory adjustment from tank dipping to 18500',0.00,0.00,18500.00,0.00,0.00,'2022-03-30 12:13:08','',''),(17,'21','238','2',1,'Sale Id shift 1',0.00,0.00,0.00,150.90,0.00,'2022-03-30 14:07:25','',''),(18,'21','238','4',2,'Sale Id shift 1',0.00,0.00,0.00,1815.86,0.00,'2022-03-30 14:07:25','',''),(19,'21','238','5',2,'Sale Id shift 1',0.00,0.00,0.00,1586.61,0.00,'2022-03-30 14:07:25','',''),(20,'21','238','5',2,'Sale Id shift 1',0.00,0.00,0.00,3171.24,0.00,'2022-03-30 14:07:25','',''),(21,'21','238','6',3,'Sale Id shift 1',0.00,0.00,0.00,166.71,0.00,'2022-03-30 14:07:25','',''),(22,'21','238',NULL,2,'Sale Id shift 1',4588449.58,0.00,0.00,0.00,0.00,'2022-03-30 14:07:25','',''),(23,'21','238',NULL,3,'Sale Id shift 1',91690.50,0.00,0.00,0.00,0.00,'2022-03-30 14:07:25','',''),(24,'21','238',NULL,1,'Sale Id shift 1',24898.50,0.00,0.00,0.00,0.00,'2022-03-30 14:07:25','',''),(25,'21','238','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,1200.00,0.00,'2022-03-31 12:20:00','',''),(26,'21','238','1',0,'Inventory adjustment from tank dipping to 1200',0.00,0.00,1200.00,0.00,0.00,'2022-03-31 12:20:00','',''),(27,'21','238','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,599.10,0.00,'2022-03-31 12:20:26','',''),(28,'21','238','2',0,'Inventory adjustment from tank dipping to 13600',0.00,0.00,13600.00,0.00,0.00,'2022-03-31 12:20:26','',''),(29,'21','238','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,1200.00,0.00,'2022-03-31 12:20:48','',''),(30,'21','238','3',0,'Inventory adjustment from tank dipping to 11100',0.00,0.00,11100.00,0.00,0.00,'2022-03-31 12:20:48','',''),(31,'21','238','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,19084.14,0.00,'2022-03-31 12:21:18','',''),(32,'21','238','4',0,'Inventory adjustment from tank dipping to 26000',0.00,0.00,26000.00,0.00,0.00,'2022-03-31 12:21:18','',''),(33,'21','238','5',0,'Tank level zero out for dipping',0.00,0.00,0.00,13742.15,0.00,'2022-03-31 12:21:49','',''),(34,'21','238','5',0,'Inventory adjustment from tank dipping to 24350',0.00,0.00,24350.00,0.00,0.00,'2022-03-31 12:21:49','',''),(35,'21','238','6',0,'Tank level zero out for dipping',0.00,0.00,0.00,15283.29,0.00,'2022-03-31 12:22:11','',''),(36,'21','238','6',0,'Inventory adjustment from tank dipping to 28800',0.00,0.00,28800.00,0.00,0.00,'2022-03-31 12:22:12','',''),(37,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2475000.00,15000.00,0.00,0.00,'2022-03-31 12:38:55','',''),(38,'21','238',NULL,1,'Reception corrector for bridging 2',0.00,0.00,0.00,6000.00,0.00,'2022-03-31 12:43:43','',''),(39,'21','238','3',1,'Received from bridging 2',0.00,0.00,6000.00,0.00,0.00,'2022-03-31 12:43:43','',''),(40,'21','238',NULL,1,'Reception corrector for bridging 1',0.00,0.00,0.00,9000.00,0.00,'2022-03-31 12:43:43','',''),(41,'21','238','2',1,'Received from bridging 1',0.00,0.00,9000.00,0.00,0.00,'2022-03-31 12:43:43','',''),(42,'21','238','3',1,'Sale Id shift 3',0.00,0.00,0.00,2481.16,0.00,'2022-03-31 13:55:47','',''),(43,'21','238','4',2,'Sale Id shift 3',0.00,0.00,0.00,6875.86,0.00,'2022-03-31 13:55:47','',''),(44,'21','238','5',2,'Sale Id shift 3',0.00,0.00,0.00,2458.98,0.00,'2022-03-31 13:55:47','',''),(45,'21','238','5',2,'Sale Id shift 3',0.00,0.00,0.00,605.16,0.00,'2022-03-31 13:55:47','',''),(46,'21','238','6',3,'Sale Id shift 3',0.00,0.00,0.00,251.65,0.00,'2022-03-31 13:55:47','',''),(47,'21','238','2',1,'Sale Id shift 3',0.00,0.00,0.00,9838.20,0.00,'2022-03-31 13:55:47','',''),(48,'21','238','2',1,'Sale Id shift 3',0.00,0.00,0.00,3211.25,0.00,'2022-03-31 13:55:47','',''),(49,'21','238','3',1,'Sale Id shift 3',0.00,0.00,0.00,10588.93,0.00,'2022-03-31 13:55:47','',''),(50,'21','238',NULL,1,'Sale Id shift 3',4309724.10,0.00,0.00,0.00,0.00,'2022-03-31 13:55:47','',''),(51,'21','238',NULL,2,'Sale Id shift 3',6938120.00,0.00,0.00,0.00,0.00,'2022-03-31 13:55:47','',''),(52,'21','238',NULL,3,'Sale Id shift 3',138407.50,0.00,0.00,0.00,0.00,'2022-03-31 13:55:47','',''),(53,'21','238','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,4029.91,0.00,'2022-04-01 11:29:35','',''),(54,'21','238','3',0,'Inventory adjustment from tank dipping to 6457',0.00,0.00,6457.00,0.00,0.00,'2022-04-01 11:29:35','',''),(55,'21','238','3',1,'Sale Id shift 4',0.00,0.00,0.00,1395.32,0.00,'2022-04-01 12:40:17','',''),(56,'21','238','4',2,'Sale Id shift 4',0.00,0.00,0.00,5484.82,0.00,'2022-04-01 12:40:17','',''),(57,'21','238','5',2,'Sale Id shift 4',0.00,0.00,0.00,4992.94,0.00,'2022-04-01 12:40:17','',''),(58,'21','238','5',2,'Sale Id shift 4',0.00,0.00,0.00,674.19,0.00,'2022-04-01 12:40:17','',''),(59,'21','238','6',3,'Sale Id shift 4',0.00,0.00,0.00,444.10,0.00,'2022-04-01 12:40:17','',''),(60,'21','238','2',1,'Sale Id shift 4',0.00,0.00,0.00,5040.18,0.00,'2022-04-01 12:40:17','',''),(61,'21','238','2',1,'Sale Id shift 4',0.00,0.00,0.00,3170.79,0.00,'2022-04-01 12:40:17','',''),(62,'21','238','3',1,'Sale Id shift 4',0.00,0.00,0.00,3862.62,0.00,'2022-04-01 12:40:17','',''),(63,'21','238',NULL,1,'Sale Id shift 4',2222370.15,0.00,0.00,0.00,0.00,'2022-04-01 12:40:17','',''),(64,'21','238',NULL,2,'Sale Id shift 4',7784061.10,0.00,0.00,0.00,0.00,'2022-04-01 12:40:17','',''),(65,'21','238',NULL,3,'Sale Id shift 4',244255.00,0.00,0.00,0.00,0.00,'2022-04-01 12:40:17','',''),(66,'21','238','4',2,'Sale Id shift 5',0.00,0.00,0.00,2168.06,0.00,'2022-04-02 11:35:39','',''),(67,'21','238','5',2,'Sale Id shift 5',0.00,0.00,0.00,1939.31,0.00,'2022-04-02 11:35:39','',''),(68,'21','238','5',2,'Sale Id shift 5',0.00,0.00,0.00,595.60,0.00,'2022-04-02 11:35:39','',''),(69,'21','238','6',3,'Sale Id shift 5',0.00,0.00,0.00,519.16,0.00,'2022-04-02 11:35:39','',''),(70,'21','238','2',1,'Sale Id shift 5',0.00,0.00,0.00,337.32,0.00,'2022-04-02 11:35:39','',''),(71,'21','238',NULL,1,'Sale Id shift 5',55657.80,0.00,0.00,0.00,0.00,'2022-04-02 11:35:40','',''),(72,'21','238',NULL,2,'Sale Id shift 5',3282673.06,0.00,0.00,0.00,0.00,'2022-04-02 11:35:40','',''),(73,'21','238',NULL,3,'Sale Id shift 5',285538.00,0.00,0.00,0.00,0.00,'2022-04-02 11:35:40','',''),(74,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2277000.00,13800.00,0.00,0.00,'2022-04-02 11:42:56','',''),(75,'21','238',NULL,1,'Reception corrector for bridging 4',0.00,0.00,0.00,5200.00,0.00,'2022-04-02 11:47:47','',''),(76,'21','238','3',1,'Received from bridging 4',0.00,0.00,5200.00,0.00,0.00,'2022-04-02 11:47:47','',''),(77,'21','238',NULL,1,'Reception corrector for bridging 3',0.00,0.00,0.00,8600.00,0.00,'2022-04-02 11:47:47','',''),(78,'21','238','2',1,'Received from bridging 3',0.00,0.00,8600.00,0.00,0.00,'2022-04-02 11:47:47','',''),(79,'21','238','3',1,'Sale Id shift 6',0.00,0.00,0.00,1441.98,0.00,'2022-04-03 11:11:44','',''),(80,'21','238','4',2,'Sale Id shift 6',0.00,0.00,0.00,3497.14,0.00,'2022-04-03 11:11:44','',''),(81,'21','238','5',2,'Sale Id shift 6',0.00,0.00,0.00,1249.72,0.00,'2022-04-03 11:11:44','',''),(82,'21','238','5',2,'Sale Id shift 6',0.00,0.00,0.00,500.53,0.00,'2022-04-03 11:11:44','',''),(83,'21','238','6',3,'Sale Id shift 6',0.00,0.00,0.00,379.25,0.00,'2022-04-03 11:11:44','',''),(84,'21','238','2',1,'Sale Id shift 6',0.00,0.00,0.00,4121.05,0.00,'2022-04-03 11:11:44','',''),(85,'21','238','2',1,'Sale Id shift 6',0.00,0.00,0.00,4886.86,0.00,'2022-04-03 11:11:44','',''),(86,'21','238','3',1,'Sale Id shift 6',0.00,0.00,0.00,3237.75,0.00,'2022-04-03 11:11:44','',''),(87,'21','238',NULL,1,'Sale Id shift 6',2258460.60,0.00,0.00,0.00,0.00,'2022-04-03 11:11:44','',''),(88,'21','238',NULL,2,'Sale Id shift 6',3662678.22,0.00,0.00,0.00,0.00,'2022-04-03 11:11:44','',''),(89,'21','238',NULL,3,'Sale Id shift 6',208587.50,0.00,0.00,0.00,0.00,'2022-04-03 11:11:44','',''),(90,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2574000.00,15600.00,0.00,0.00,'2022-04-03 11:17:46','',''),(91,'21','238',NULL,1,'Reception corrector for bridging 6',0.00,0.00,0.00,5300.00,0.00,'2022-04-03 11:20:46','',''),(92,'21','238','3',1,'Received from bridging 6',0.00,0.00,5300.00,0.00,0.00,'2022-04-03 11:20:46','',''),(93,'21','238',NULL,1,'Reception corrector for bridging 5',0.00,0.00,0.00,10300.00,0.00,'2022-04-03 11:21:09','',''),(94,'21','238','2',1,'Received from bridging 5',0.00,0.00,10300.00,0.00,0.00,'2022-04-03 11:21:09','',''),(95,'21','238','3',1,'Sale Id shift 7',0.00,0.00,0.00,308.18,0.00,'2022-04-04 10:31:11','',''),(96,'21','238','4',2,'Sale Id shift 7',0.00,0.00,0.00,2313.89,0.00,'2022-04-04 10:31:11','',''),(97,'21','238','5',2,'Sale Id shift 7',0.00,0.00,0.00,2701.03,0.00,'2022-04-04 10:31:11','',''),(98,'21','238','5',2,'Sale Id shift 7',0.00,0.00,0.00,1219.97,0.00,'2022-04-04 10:31:11','',''),(99,'21','238','6',3,'Sale Id shift 7',0.00,0.00,0.00,254.30,0.00,'2022-04-04 10:31:11','',''),(100,'21','238','2',1,'Sale Id shift 7',0.00,0.00,0.00,5432.07,0.00,'2022-04-04 10:31:11','',''),(101,'21','238','2',1,'Sale Id shift 7',0.00,0.00,0.00,5102.01,0.00,'2022-04-04 10:31:11','',''),(102,'21','238','3',1,'Sale Id shift 7',0.00,0.00,0.00,4761.25,0.00,'2022-04-04 10:31:11','',''),(103,'21','238',NULL,1,'Sale Id shift 7',2574579.15,0.00,0.00,0.00,0.00,'2022-04-04 10:31:11','',''),(104,'21','238',NULL,2,'Sale Id shift 7',4351953.22,0.00,0.00,0.00,0.00,'2022-04-04 10:31:11','',''),(105,'21','238',NULL,3,'Sale Id shift 7',139865.00,0.00,0.00,0.00,0.00,'2022-04-04 10:31:11','',''),(106,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2640000.00,16000.00,0.00,0.00,'2022-04-04 20:41:37','',''),(107,'21','238',NULL,1,'Reception corrector for bridging 7',0.00,0.00,0.00,12200.00,0.00,'2022-04-04 20:47:38','',''),(108,'21','238','2',1,'Received from bridging 7',0.00,0.00,12200.00,0.00,0.00,'2022-04-04 20:47:38','',''),(109,'21','238',NULL,1,'Reception corrector for bridging 8',0.00,0.00,0.00,3800.00,0.00,'2022-04-04 20:47:53','',''),(110,'21','238','3',1,'Received from bridging 8',0.00,0.00,3800.00,0.00,0.00,'2022-04-04 20:47:53','',''),(111,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,21987000.00,31500.00,0.00,0.00,'2022-04-04 20:48:25','',''),(112,'21','238',NULL,2,'Reception corrector for bridging 10',0.00,0.00,0.00,12200.00,0.00,'2022-04-04 20:51:06','',''),(113,'21','238','5',2,'Received from bridging 10',0.00,0.00,12200.00,0.00,0.00,'2022-04-04 20:51:06','',''),(114,'21','238',NULL,2,'Reception corrector for bridging 9',0.00,0.00,0.00,19300.00,0.00,'2022-04-04 20:51:23','',''),(115,'21','238','4',2,'Received from bridging 9',0.00,0.00,19300.00,0.00,0.00,'2022-04-04 20:51:23','',''),(116,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,4950000.00,30000.00,0.00,0.00,'2022-04-04 20:53:28','',''),(117,'21','238',NULL,1,'Reception corrector for bridging 12',0.00,0.00,0.00,15000.00,0.00,'2022-04-04 20:55:37','',''),(118,'21','238','3',1,'Received from bridging 12',0.00,0.00,15000.00,0.00,0.00,'2022-04-04 20:55:37','',''),(119,'21','238',NULL,1,'Reception corrector for bridging 11',0.00,0.00,0.00,15000.00,0.00,'2022-04-04 20:55:51','',''),(120,'21','238','2',1,'Received from bridging 11',0.00,0.00,15000.00,0.00,0.00,'2022-04-04 20:55:51','',''),(121,'21','238','3',1,'Sale Id shift 8',0.00,0.00,0.00,73.92,0.00,'2022-04-06 08:53:05','',''),(122,'21','238','4',2,'Sale Id shift 8',0.00,0.00,0.00,3135.92,0.00,'2022-04-06 08:53:05','',''),(123,'21','238','5',2,'Sale Id shift 8',0.00,0.00,0.00,476.14,0.00,'2022-04-06 08:53:05','',''),(124,'21','238','5',2,'Sale Id shift 8',0.00,0.00,0.00,4585.60,0.00,'2022-04-06 08:53:05','',''),(125,'21','238','6',3,'Sale Id shift 8',0.00,0.00,0.00,204.80,0.00,'2022-04-06 08:53:05','',''),(126,'21','238','2',1,'Sale Id shift 8',0.00,0.00,0.00,6057.86,0.00,'2022-04-06 08:53:05','',''),(127,'21','238','2',1,'Sale Id shift 8',0.00,0.00,0.00,6086.16,0.00,'2022-04-06 08:53:05','',''),(128,'21','238','3',1,'Sale Id shift 8',0.00,0.00,0.00,4046.80,0.00,'2022-04-06 08:53:05','',''),(129,'21','238',NULL,2,'Sale Id shift 8',5721966.68,0.00,0.00,0.00,0.00,'2022-04-06 08:53:05','',''),(130,'21','238',NULL,3,'Sale Id shift 8',112640.00,0.00,0.00,0.00,0.00,'2022-04-06 08:53:05','',''),(131,'21','238',NULL,1,'Sale Id shift 8',2683682.10,0.00,0.00,0.00,0.00,'2022-04-06 08:53:05','',''),(132,'21','238','3',1,'Sale Id shift 9',0.00,0.00,0.00,1892.59,0.00,'2022-04-06 12:34:14','',''),(133,'21','238','4',2,'Sale Id shift 9',0.00,0.00,0.00,4300.78,0.00,'2022-04-06 12:34:14','',''),(134,'21','238','5',2,'Sale Id shift 9',0.00,0.00,0.00,2675.32,0.00,'2022-04-06 12:34:14','',''),(135,'21','238','5',2,'Sale Id shift 9',0.00,0.00,0.00,394.67,0.00,'2022-04-06 12:34:14','',''),(136,'21','238','6',3,'Sale Id shift 9',0.00,0.00,0.00,203.11,0.00,'2022-04-06 12:34:14','',''),(137,'21','238','2',1,'Sale Id shift 9',0.00,0.00,0.00,8769.48,0.00,'2022-04-06 12:34:14','',''),(138,'21','238','2',1,'Sale Id shift 9',0.00,0.00,0.00,6350.44,0.00,'2022-04-06 12:34:14','',''),(139,'21','238','3',1,'Sale Id shift 9',0.00,0.00,0.00,13028.19,0.00,'2022-04-06 12:34:14','',''),(140,'21','238',NULL,2,'Sale Id shift 9',5144797.46,0.00,0.00,0.00,0.00,'2022-04-06 12:34:14','',''),(141,'21','238',NULL,3,'Sale Id shift 9',111710.50,0.00,0.00,0.00,0.00,'2022-04-06 12:34:14','',''),(142,'21','238',NULL,1,'Sale Id shift 9',4956715.50,0.00,0.00,0.00,0.00,'2022-04-06 12:34:14','',''),(143,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,4455000.00,27000.00,0.00,0.00,'2022-04-06 20:30:26','',''),(144,'21','238',NULL,1,'Reception corrector for bridging 14',0.00,0.00,0.00,13500.00,0.00,'2022-04-06 20:34:11','',''),(145,'21','238','3',1,'Received from bridging 14',0.00,0.00,13500.00,0.00,0.00,'2022-04-06 20:34:11','',''),(146,'21','238',NULL,1,'Reception corrector for bridging 13',0.00,0.00,0.00,13500.00,0.00,'2022-04-06 20:34:28','',''),(147,'21','238','2',1,'Received from bridging 13',0.00,0.00,13500.00,0.00,0.00,'2022-04-06 20:34:28','',''),(148,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2805000.00,17000.00,0.00,0.00,'2022-04-06 21:42:49','',''),(149,'21','238',NULL,1,'Reception corrector for bridging 16',0.00,0.00,0.00,7000.00,0.00,'2022-04-06 21:46:48','',''),(150,'21','238','3',1,'Received from bridging 16',0.00,0.00,7000.00,0.00,0.00,'2022-04-06 21:46:48','',''),(151,'21','238',NULL,1,'Reception corrector for bridging 15',0.00,0.00,0.00,10000.00,0.00,'2022-04-06 21:47:00','',''),(152,'21','238','2',1,'Received from bridging 15',0.00,0.00,10000.00,0.00,0.00,'2022-04-06 21:47:00','',''),(153,'21','238','3',1,'Sale Id shift 10',0.00,0.00,0.00,1088.38,0.00,'2022-04-07 09:47:12','',''),(154,'21','238','4',2,'Sale Id shift 10',0.00,0.00,0.00,1989.04,0.00,'2022-04-07 09:47:12','',''),(155,'21','238','5',2,'Sale Id shift 10',0.00,0.00,0.00,2283.69,0.00,'2022-04-07 09:47:12','',''),(156,'21','238','5',2,'Sale Id shift 10',0.00,0.00,0.00,1672.94,0.00,'2022-04-07 09:47:12','',''),(157,'21','238','6',3,'Sale Id shift 10',0.00,0.00,0.00,95.33,0.00,'2022-04-07 09:47:12','',''),(158,'21','238','2',1,'Sale Id shift 10',0.00,0.00,0.00,7174.07,0.00,'2022-04-07 09:47:12','',''),(159,'21','238','2',1,'Sale Id shift 10',0.00,0.00,0.00,6694.30,0.00,'2022-04-07 09:47:12','',''),(160,'21','238','3',1,'Sale Id shift 10',0.00,0.00,0.00,12307.00,0.00,'2022-04-07 09:47:12','',''),(161,'21','238',NULL,2,'Sale Id shift 10',4150077.66,0.00,0.00,0.00,0.00,'2022-04-07 09:47:12','',''),(162,'21','238',NULL,3,'Sale Id shift 10',52431.50,0.00,0.00,0.00,0.00,'2022-04-07 09:47:12','',''),(163,'21','238',NULL,1,'Sale Id shift 10',4498518.75,0.00,0.00,0.00,0.00,'2022-04-07 09:47:12','',''),(164,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,12215000.00,17500.00,0.00,0.00,'2022-04-07 20:53:22','',''),(165,'21','238',NULL,2,'Reception corrector for bridging 17',0.00,0.00,0.00,17500.00,0.00,'2022-04-07 20:55:37','',''),(166,'21','238','5',2,'Received from bridging 17',0.00,0.00,17500.00,0.00,0.00,'2022-04-07 20:55:37','',''),(167,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2475000.00,15000.00,0.00,0.00,'2022-04-08 10:05:49','',''),(168,'21','238',NULL,1,'Reception corrector for bridging 19',0.00,0.00,0.00,5200.00,0.00,'2022-04-08 10:11:45','',''),(169,'21','238','3',1,'Received from bridging 19',0.00,0.00,5200.00,0.00,0.00,'2022-04-08 10:11:45','',''),(170,'21','238',NULL,1,'Reception corrector for bridging 18',0.00,0.00,0.00,9800.00,0.00,'2022-04-08 10:12:05','',''),(171,'21','238','2',1,'Received from bridging 18',0.00,0.00,9800.00,0.00,0.00,'2022-04-08 10:12:05','',''),(172,'21','238','3',1,'Sale Id shift 11',0.00,0.00,0.00,258.35,0.00,'2022-04-08 11:05:27','',''),(173,'21','238','4',2,'Sale Id shift 11',0.00,0.00,0.00,3095.53,0.00,'2022-04-08 11:05:27','',''),(174,'21','238','5',2,'Sale Id shift 11',0.00,0.00,0.00,2072.46,0.00,'2022-04-08 11:05:27','',''),(175,'21','238','5',2,'Sale Id shift 11',0.00,0.00,0.00,1988.80,0.00,'2022-04-08 11:05:27','',''),(176,'21','238','6',3,'Sale Id shift 11',0.00,0.00,0.00,118.74,0.00,'2022-04-08 11:05:27','',''),(177,'21','238','2',1,'Sale Id shift 11',0.00,0.00,0.00,4764.03,0.00,'2022-04-08 11:05:27','',''),(178,'21','238','2',1,'Sale Id shift 11',0.00,0.00,0.00,4567.22,0.00,'2022-04-08 11:05:27','',''),(179,'21','238','3',1,'Sale Id shift 11',0.00,0.00,0.00,7421.66,0.00,'2022-04-08 11:05:27','',''),(180,'21','238',NULL,1,'Sale Id shift 11',2806857.90,0.00,0.00,0.00,0.00,'2022-04-08 11:05:27','',''),(181,'21','238',NULL,2,'Sale Id shift 11',4995439.42,0.00,0.00,0.00,0.00,'2022-04-08 11:05:27','',''),(182,'21','238',NULL,3,'Sale Id shift 11',65307.00,0.00,0.00,0.00,0.00,'2022-04-08 11:05:27','',''),(183,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2557500.00,15500.00,0.00,0.00,'2022-04-09 10:32:58','',''),(184,'21','238',NULL,1,'Reception corrector for bridging 21',0.00,0.00,0.00,4050.00,0.00,'2022-04-09 10:36:47','',''),(185,'21','238','3',1,'Received from bridging 21',0.00,0.00,4050.00,0.00,0.00,'2022-04-09 10:36:47','',''),(186,'21','238',NULL,1,'Reception corrector for bridging 20',0.00,0.00,0.00,11450.00,0.00,'2022-04-09 10:37:18','',''),(187,'21','238','2',1,'Received from bridging 20',0.00,0.00,11450.00,0.00,0.00,'2022-04-09 10:37:18','',''),(188,'21','238','4',2,'Sale Id shift 12',0.00,0.00,0.00,3290.26,0.00,'2022-04-09 12:09:25','',''),(189,'21','238','5',2,'Sale Id shift 12',0.00,0.00,0.00,543.85,0.00,'2022-04-09 12:09:25','',''),(190,'21','238','5',2,'Sale Id shift 12',0.00,0.00,0.00,1411.82,0.00,'2022-04-09 12:09:25','',''),(191,'21','238','6',3,'Sale Id shift 12',0.00,0.00,0.00,162.83,0.00,'2022-04-09 12:09:25','',''),(192,'21','238','2',1,'Sale Id shift 12',0.00,0.00,0.00,4537.34,0.00,'2022-04-09 12:09:25','',''),(193,'21','238','2',1,'Sale Id shift 12',0.00,0.00,0.00,6288.59,0.00,'2022-04-09 12:09:25','',''),(194,'21','238','3',1,'Sale Id shift 12',0.00,0.00,0.00,5324.16,0.00,'2022-04-09 12:09:25','',''),(195,'21','238',NULL,2,'Sale Id shift 12',3661659.14,0.00,0.00,0.00,0.00,'2022-04-09 12:09:25','',''),(196,'21','238',NULL,3,'Sale Id shift 12',89556.50,0.00,0.00,0.00,0.00,'2022-04-09 12:09:25','',''),(197,'21','238',NULL,1,'Sale Id shift 12',2664764.85,0.00,0.00,0.00,0.00,'2022-04-09 12:09:25','',''),(198,'21','238','3',1,'Sale Id shift 13',0.00,0.00,0.00,226.38,0.00,'2022-04-10 09:36:38','',''),(199,'21','238','4',2,'Sale Id shift 13',0.00,0.00,0.00,2760.02,0.00,'2022-04-10 09:36:38','',''),(200,'21','238','5',2,'Sale Id shift 13',0.00,0.00,0.00,1907.55,0.00,'2022-04-10 09:36:38','',''),(201,'21','238','5',2,'Sale Id shift 13',0.00,0.00,0.00,1718.33,0.00,'2022-04-10 09:36:38','',''),(202,'21','238','6',3,'Sale Id shift 13',0.00,0.00,0.00,140.96,0.00,'2022-04-10 09:36:38','',''),(203,'21','238','2',1,'Sale Id shift 13',0.00,0.00,0.00,5760.74,0.00,'2022-04-10 09:36:38','',''),(204,'21','238','2',1,'Sale Id shift 13',0.00,0.00,0.00,4356.61,0.00,'2022-04-10 09:36:38','',''),(205,'21','238','3',1,'Sale Id shift 13',0.00,0.00,0.00,3999.45,0.00,'2022-04-10 09:36:38','',''),(206,'21','238',NULL,1,'Sale Id shift 13',2366624.70,0.00,0.00,0.00,0.00,'2022-04-10 09:36:38','',''),(207,'21','238',NULL,2,'Sale Id shift 13',4457358.20,0.00,0.00,0.00,0.00,'2022-04-10 09:36:38','',''),(208,'21','238',NULL,3,'Sale Id shift 13',77528.00,0.00,0.00,0.00,0.00,'2022-04-10 09:36:38','',''),(209,'21','238','4',2,'Sale Id shift 14',0.00,0.00,0.00,3279.51,0.00,'2022-04-11 08:14:19','',''),(210,'21','238','5',2,'Sale Id shift 14',0.00,0.00,0.00,1825.92,0.00,'2022-04-11 08:14:19','',''),(211,'21','238','5',2,'Sale Id shift 14',0.00,0.00,0.00,2785.96,0.00,'2022-04-11 08:14:19','',''),(212,'21','238','6',3,'Sale Id shift 14',0.00,0.00,0.00,74.17,0.00,'2022-04-11 08:14:19','',''),(213,'21','238',NULL,2,'Sale Id shift 14',5508190.22,0.00,0.00,0.00,0.00,'2022-04-11 08:14:19','',''),(214,'21','238',NULL,3,'Sale Id shift 14',40793.50,0.00,0.00,0.00,0.00,'2022-04-11 08:14:19','',''),(215,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2722500.00,16500.00,0.00,0.00,'2022-04-11 21:10:48','',''),(216,'21','238',NULL,1,'Reception corrector for bridging 23',0.00,0.00,0.00,5050.00,0.00,'2022-04-11 21:13:17','',''),(217,'21','238','3',1,'Received from bridging 23',0.00,0.00,5050.00,0.00,0.00,'2022-04-11 21:13:17','',''),(218,'21','238',NULL,1,'Reception corrector for bridging 22',0.00,0.00,0.00,11450.00,0.00,'2022-04-11 21:13:42','',''),(219,'21','238','2',1,'Received from bridging 22',0.00,0.00,11450.00,0.00,0.00,'2022-04-11 21:13:42','',''),(220,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2475000.00,15000.00,0.00,0.00,'2022-04-12 12:13:21','',''),(221,'21','238',NULL,1,'Reception corrector for bridging 25',0.00,0.00,0.00,5700.00,0.00,'2022-04-12 12:16:26','',''),(222,'21','238','3',1,'Received from bridging 25',0.00,0.00,5700.00,0.00,0.00,'2022-04-12 12:16:26','',''),(223,'21','238',NULL,1,'Reception corrector for bridging 24',0.00,0.00,0.00,9300.00,0.00,'2022-04-12 12:16:39','',''),(224,'21','238','2',1,'Received from bridging 24',0.00,0.00,9300.00,0.00,0.00,'2022-04-12 12:16:39','',''),(225,'21','238','4',2,'Sale Id shift 15',0.00,0.00,0.00,1514.79,0.00,'2022-04-12 16:12:41','',''),(226,'21','238','5',2,'Sale Id shift 15',0.00,0.00,0.00,1387.43,0.00,'2022-04-12 16:12:41','',''),(227,'21','238','5',2,'Sale Id shift 15',0.00,0.00,0.00,218.05,0.00,'2022-04-12 16:12:41','',''),(228,'21','238',NULL,2,'Sale Id shift 15',2177948.46,0.00,0.00,0.00,0.00,'2022-04-12 16:12:41','',''),(229,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,20340000.00,30000.00,0.00,0.00,'2022-04-13 17:42:51','',''),(230,'21','238',NULL,2,'Reception corrector for bridging 27',0.00,0.00,0.00,7000.00,0.00,'2022-04-13 17:45:42','',''),(231,'21','238','5',2,'Received from bridging 27',0.00,0.00,7000.00,0.00,0.00,'2022-04-13 17:45:42','',''),(232,'21','238',NULL,2,'Reception corrector for bridging 26',0.00,0.00,0.00,23000.00,0.00,'2022-04-13 17:46:03','',''),(233,'21','238','4',2,'Received from bridging 26',0.00,0.00,23000.00,0.00,0.00,'2022-04-13 17:46:03','',''),(234,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,1980000.00,12000.00,0.00,0.00,'2022-04-13 17:49:27','',''),(235,'21','238',NULL,1,'Reception corrector for bridging 29',0.00,0.00,0.00,3800.00,0.00,'2022-04-13 17:53:32','',''),(236,'21','238','3',1,'Received from bridging 29',0.00,0.00,3800.00,0.00,0.00,'2022-04-13 17:53:32','',''),(237,'21','238',NULL,1,'Reception corrector for bridging 28',0.00,0.00,0.00,8200.00,0.00,'2022-04-13 17:53:47','',''),(238,'21','238','2',1,'Received from bridging 28',0.00,0.00,8200.00,0.00,0.00,'2022-04-13 17:53:47','',''),(239,'21','238','3',1,'Sale Id shift 17',0.00,0.00,0.00,598.03,0.00,'2022-04-15 14:12:02','',''),(240,'21','238','4',2,'Sale Id shift 17',0.00,0.00,0.00,4352.48,0.00,'2022-04-15 14:12:02','',''),(241,'21','238','6',3,'Sale Id shift 17',0.00,0.00,0.00,103.51,0.00,'2022-04-15 14:12:02','',''),(242,'21','238','2',1,'Sale Id shift 17',0.00,0.00,0.00,6065.84,0.00,'2022-04-15 14:12:02','',''),(243,'21','238','2',1,'Sale Id shift 17',0.00,0.00,0.00,5762.18,0.00,'2022-04-15 14:12:02','',''),(244,'21','238','3',1,'Sale Id shift 17',0.00,0.00,0.00,4786.75,0.00,'2022-04-15 14:12:02','',''),(245,'21','238',NULL,2,'Sale Id shift 17',2950981.44,0.00,0.00,0.00,0.00,'2022-04-15 14:12:02','',''),(246,'21','238',NULL,3,'Sale Id shift 17',56930.50,0.00,0.00,0.00,0.00,'2022-04-15 14:12:02','',''),(247,'21','238',NULL,1,'Sale Id shift 17',2840112.00,0.00,0.00,0.00,0.00,'2022-04-15 14:12:02','',''),(248,'21','238','3',1,'Sale Id shift 18',0.00,0.00,0.00,717.99,0.00,'2022-04-15 14:55:46','',''),(249,'21','238','4',2,'Sale Id shift 18',0.00,0.00,0.00,5893.67,0.00,'2022-04-15 14:55:46','',''),(250,'21','238','6',3,'Sale Id shift 18',0.00,0.00,0.00,84.72,0.00,'2022-04-15 14:55:46','',''),(251,'21','238','2',1,'Sale Id shift 18',0.00,0.00,0.00,4891.55,0.00,'2022-04-15 14:55:46','',''),(252,'21','238','2',1,'Sale Id shift 18',0.00,0.00,0.00,4503.36,0.00,'2022-04-15 14:55:46','',''),(253,'21','238','3',1,'Sale Id shift 18',0.00,0.00,0.00,4753.44,0.00,'2022-04-15 14:55:46','',''),(254,'21','238',NULL,2,'Sale Id shift 18',3995908.26,0.00,0.00,0.00,0.00,'2022-04-15 14:55:46','',''),(255,'21','238',NULL,3,'Sale Id shift 18',46596.00,0.00,0.00,0.00,0.00,'2022-04-15 14:55:46','',''),(256,'21','238',NULL,1,'Sale Id shift 18',2452946.10,0.00,0.00,0.00,0.00,'2022-04-15 14:55:46','',''),(257,'21','238','3',1,'Sale Id shift 19',0.00,0.00,0.00,610.76,0.00,'2022-04-15 15:40:43','',''),(258,'21','238','4',2,'Sale Id shift 19',0.00,0.00,0.00,4148.12,0.00,'2022-04-15 15:40:43','',''),(259,'21','238','5',2,'Sale Id shift 19',0.00,0.00,0.00,2378.09,0.00,'2022-04-15 15:40:43','',''),(260,'21','238','5',2,'Sale Id shift 19',0.00,0.00,0.00,3083.06,0.00,'2022-04-15 15:40:43','',''),(261,'21','238','6',3,'Sale Id shift 19',0.00,0.00,0.00,124.44,0.00,'2022-04-15 15:40:43','',''),(262,'21','238','2',1,'Sale Id shift 19',0.00,0.00,0.00,3218.44,0.00,'2022-04-15 15:40:43','',''),(263,'21','238','2',1,'Sale Id shift 19',0.00,0.00,0.00,4897.01,0.00,'2022-04-15 15:40:43','',''),(264,'21','238','3',1,'Sale Id shift 19',0.00,0.00,0.00,3568.72,0.00,'2022-04-15 15:40:43','',''),(265,'21','238',NULL,1,'Sale Id shift 19',2028663.45,0.00,0.00,0.00,0.00,'2022-04-15 15:40:43','',''),(266,'21','238',NULL,2,'Sale Id shift 19',6515085.06,0.00,0.00,0.00,0.00,'2022-04-15 15:40:43','',''),(267,'21','238',NULL,3,'Sale Id shift 19',68442.00,0.00,0.00,0.00,0.00,'2022-04-15 15:40:43','',''),(268,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2475000.00,15000.00,0.00,0.00,'2022-04-16 09:55:47','',''),(269,'21','238',NULL,1,'Reception corrector for bridging 31',0.00,0.00,0.00,5800.00,0.00,'2022-04-16 09:58:11','',''),(270,'21','238','3',1,'Received from bridging 31',0.00,0.00,5800.00,0.00,0.00,'2022-04-16 09:58:11','',''),(271,'21','238',NULL,1,'Reception corrector for bridging 30',0.00,0.00,0.00,9200.00,0.00,'2022-04-16 09:58:24','',''),(272,'21','238','2',1,'Received from bridging 30',0.00,0.00,9200.00,0.00,0.00,'2022-04-16 09:58:24','',''),(273,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,10848000.00,16000.00,0.00,0.00,'2022-04-16 10:00:58','',''),(274,'21','238',NULL,2,'Reception corrector for bridging 32',0.00,0.00,0.00,16000.00,0.00,'2022-04-16 10:02:16','',''),(275,'21','238','5',2,'Received from bridging 32',0.00,0.00,16000.00,0.00,0.00,'2022-04-16 10:02:16','',''),(276,'21','238','3',1,'Sale Id shift 20',0.00,0.00,0.00,1514.35,0.00,'2022-04-16 11:07:39','',''),(277,'21','238','4',2,'Sale Id shift 20',0.00,0.00,0.00,3762.33,0.00,'2022-04-16 11:07:39','',''),(278,'21','238','5',2,'Sale Id shift 20',0.00,0.00,0.00,3140.34,0.00,'2022-04-16 11:07:39','',''),(279,'21','238','5',2,'Sale Id shift 20',0.00,0.00,0.00,1002.56,0.00,'2022-04-16 11:07:39','',''),(280,'21','238','6',3,'Sale Id shift 20',0.00,0.00,0.00,199.78,0.00,'2022-04-16 11:07:39','',''),(281,'21','238','2',1,'Sale Id shift 20',0.00,0.00,0.00,4409.74,0.00,'2022-04-16 11:07:39','',''),(282,'21','238','2',1,'Sale Id shift 20',0.00,0.00,0.00,5104.76,0.00,'2022-04-16 11:07:39','',''),(283,'21','238','3',1,'Sale Id shift 20',0.00,0.00,0.00,3899.36,0.00,'2022-04-16 11:07:39','',''),(284,'21','238',NULL,2,'Sale Id shift 20',5359745.94,0.00,0.00,0.00,0.00,'2022-04-16 11:07:39','',''),(285,'21','238',NULL,3,'Sale Id shift 20',109879.00,0.00,0.00,0.00,0.00,'2022-04-16 11:07:39','',''),(286,'21','238',NULL,1,'Sale Id shift 20',2463154.65,0.00,0.00,0.00,0.00,'2022-04-16 11:07:39','',''),(287,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2475000.00,15000.00,0.00,0.00,'2022-04-16 15:50:47','',''),(288,'21','238',NULL,1,'Reception corrector for bridging 34',0.00,0.00,0.00,3450.00,0.00,'2022-04-16 15:52:52','',''),(289,'21','238','3',1,'Received from bridging 34',0.00,0.00,3450.00,0.00,0.00,'2022-04-16 15:52:52','',''),(290,'21','238',NULL,1,'Reception corrector for bridging 33',0.00,0.00,0.00,11550.00,0.00,'2022-04-16 15:53:14','',''),(291,'21','238','2',1,'Received from bridging 33',0.00,0.00,11550.00,0.00,0.00,'2022-04-16 15:53:14','',''),(292,'21','238','4',2,'Sale Id shift 21',0.00,0.00,0.00,2959.10,0.00,'2022-04-16 16:28:56','',''),(293,'21','238','5',2,'Sale Id shift 21',0.00,0.00,0.00,2179.49,0.00,'2022-04-16 16:28:56','',''),(294,'21','238','5',2,'Sale Id shift 21',0.00,0.00,0.00,658.23,0.00,'2022-04-16 16:28:56','',''),(295,'21','238','6',3,'Sale Id shift 21',0.00,0.00,0.00,143.27,0.00,'2022-04-16 16:28:56','',''),(296,'21','238',NULL,2,'Sale Id shift 21',3930243.96,0.00,0.00,0.00,0.00,'2022-04-16 16:28:56','',''),(297,'21','238',NULL,3,'Sale Id shift 21',78798.50,0.00,0.00,0.00,0.00,'2022-04-16 16:28:56','',''),(298,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,20679000.00,30500.00,0.00,0.00,'2022-04-17 18:06:25','',''),(299,'21','238',NULL,2,'Reception corrector for bridging 35',0.00,0.00,0.00,15500.00,0.00,'2022-04-17 20:37:07','',''),(300,'21','238','4',2,'Received from bridging 35',0.00,0.00,15500.00,0.00,0.00,'2022-04-17 20:37:07','',''),(301,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,4950000.00,30000.00,0.00,0.00,'2022-04-18 15:12:36','',''),(302,'21','238',NULL,1,'Reception corrector for bridging 37',0.00,0.00,0.00,15000.00,0.00,'2022-04-18 15:22:37','',''),(303,'21','238','2',1,'Received from bridging 37',0.00,0.00,15000.00,0.00,0.00,'2022-04-18 15:22:37','',''),(304,'21','238',NULL,1,'Reception corrector for bridging 38',0.00,0.00,0.00,15000.00,0.00,'2022-04-18 15:22:52','',''),(305,'21','238','3',1,'Received from bridging 38',0.00,0.00,15000.00,0.00,0.00,'2022-04-18 15:22:52','',''),(306,'21','238','3',1,'Sale Id shift 22',0.00,0.00,0.00,468.60,0.00,'2022-04-18 15:23:21','',''),(307,'21','238','4',2,'Sale Id shift 22',0.00,0.00,0.00,4059.23,0.00,'2022-04-18 15:23:21','',''),(308,'21','238','5',2,'Sale Id shift 22',0.00,0.00,0.00,2298.29,0.00,'2022-04-18 15:23:21','',''),(309,'21','238','5',2,'Sale Id shift 22',0.00,0.00,0.00,725.72,0.00,'2022-04-18 15:23:21','',''),(310,'21','238','6',3,'Sale Id shift 22',0.00,0.00,0.00,133.17,0.00,'2022-04-18 15:23:21','',''),(311,'21','238','2',1,'Sale Id shift 22',0.00,0.00,0.00,4801.48,0.00,'2022-04-18 15:23:21','',''),(312,'21','238','2',1,'Sale Id shift 22',0.00,0.00,0.00,6699.84,0.00,'2022-04-18 15:23:21','',''),(313,'21','238','3',1,'Sale Id shift 22',0.00,0.00,0.00,2871.24,0.00,'2022-04-18 15:23:21','',''),(314,'21','238',NULL,1,'Sale Id shift 22',2448791.40,0.00,0.00,0.00,0.00,'2022-04-18 15:23:21','',''),(315,'21','238',NULL,2,'Sale Id shift 22',4802436.72,0.00,0.00,0.00,0.00,'2022-04-18 15:23:21','',''),(316,'21','238',NULL,3,'Sale Id shift 22',73243.50,0.00,0.00,0.00,0.00,'2022-04-18 15:23:21','',''),(317,'21','238','3',1,'Sale Id shift 23',0.00,0.00,0.00,713.72,0.00,'2022-04-18 15:47:06','',''),(318,'21','238','4',2,'Sale Id shift 23',0.00,0.00,0.00,9119.26,0.00,'2022-04-18 15:47:06','',''),(319,'21','238','5',2,'Sale Id shift 23',0.00,0.00,0.00,3134.52,0.00,'2022-04-18 15:47:06','',''),(320,'21','238','5',2,'Sale Id shift 23',0.00,0.00,0.00,110.56,0.00,'2022-04-18 15:47:06','',''),(321,'21','238','6',3,'Sale Id shift 23',0.00,0.00,0.00,109.30,0.00,'2022-04-18 15:47:06','',''),(322,'21','238','2',1,'Sale Id shift 23',0.00,0.00,0.00,7738.45,0.00,'2022-04-18 15:47:06','',''),(323,'21','238','2',1,'Sale Id shift 23',0.00,0.00,0.00,5856.75,0.00,'2022-04-18 15:47:06','',''),(324,'21','238','3',1,'Sale Id shift 23',0.00,0.00,0.00,7847.17,0.00,'2022-04-18 15:47:06','',''),(325,'21','238',NULL,2,'Sale Id shift 23',8383022.52,0.00,0.00,0.00,0.00,'2022-04-18 15:47:06','',''),(326,'21','238',NULL,3,'Sale Id shift 23',60115.00,0.00,0.00,0.00,0.00,'2022-04-18 15:47:06','',''),(327,'21','238',NULL,1,'Sale Id shift 23',3655754.85,0.00,0.00,0.00,0.00,'2022-04-18 15:47:06','',''),(328,'21','238',NULL,2,'Reception corrector for bridging 36',0.00,0.00,0.00,15000.00,0.00,'2022-04-18 15:47:34','',''),(329,'21','238','5',2,'Received from bridging 36',0.00,0.00,15000.00,0.00,0.00,'2022-04-18 15:47:34','',''),(330,'21','238','4',2,'Sale Id shift 24',0.00,0.00,0.00,336.65,0.00,'2022-04-19 10:54:59','',''),(331,'21','238','5',2,'Sale Id shift 24',0.00,0.00,0.00,202.64,0.00,'2022-04-19 10:54:59','',''),(332,'21','238','5',2,'Sale Id shift 24',0.00,0.00,0.00,25.17,0.00,'2022-04-19 10:54:59','',''),(333,'21','238',NULL,2,'Sale Id shift 24',382703.88,0.00,0.00,0.00,0.00,'2022-04-19 10:54:59','',''),(334,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2475000.00,15000.00,0.00,0.00,'2022-04-19 20:25:56','',''),(335,'21','238',NULL,1,'Reception corrector for bridging 39',0.00,0.00,0.00,15000.00,0.00,'2022-04-19 20:30:00','',''),(336,'21','238','2',1,'Received from bridging 39',0.00,0.00,15000.00,0.00,0.00,'2022-04-19 20:30:00','',''),(337,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,4950000.00,30000.00,0.00,0.00,'2022-04-20 11:43:31','',''),(338,'21','238',NULL,1,'Reception corrector for bridging 41',0.00,0.00,0.00,15000.00,0.00,'2022-04-20 11:56:58','',''),(339,'21','238','3',1,'Received from bridging 41',0.00,0.00,15000.00,0.00,0.00,'2022-04-20 11:56:58','',''),(340,'21','238',NULL,1,'Reception corrector for bridging 40',0.00,0.00,0.00,15000.00,0.00,'2022-04-20 12:01:13','',''),(341,'21','238','2',1,'Received from bridging 40',0.00,0.00,15000.00,0.00,0.00,'2022-04-20 12:01:13','',''),(342,'21','238','3',1,'Sale Id shift 25',0.00,0.00,0.00,2086.57,0.00,'2022-04-20 12:05:56','',''),(343,'21','238','4',2,'Sale Id shift 25',0.00,0.00,0.00,3170.03,0.00,'2022-04-20 12:05:56','',''),(344,'21','238','5',2,'Sale Id shift 25',0.00,0.00,0.00,1147.01,0.00,'2022-04-20 12:05:56','',''),(345,'21','238','5',2,'Sale Id shift 25',0.00,0.00,0.00,498.50,0.00,'2022-04-20 12:05:56','',''),(346,'21','238','6',3,'Sale Id shift 25',0.00,0.00,0.00,267.08,0.00,'2022-04-20 12:05:56','',''),(347,'21','238','2',1,'Sale Id shift 25',0.00,0.00,0.00,108.61,0.00,'2022-04-20 12:05:56','',''),(348,'21','238','2',1,'Sale Id shift 25',0.00,0.00,0.00,1151.40,0.00,'2022-04-20 12:05:56','',''),(349,'21','238','3',1,'Sale Id shift 25',0.00,0.00,0.00,4598.49,0.00,'2022-04-20 12:05:56','',''),(350,'21','238',NULL,1,'Sale Id shift 25',1310936.55,0.00,0.00,0.00,0.00,'2022-04-20 12:05:56','',''),(351,'21','238',NULL,2,'Sale Id shift 25',3192703.02,0.00,0.00,0.00,0.00,'2022-04-20 12:05:56','',''),(352,'21','238',NULL,3,'Sale Id shift 25',146894.00,0.00,0.00,0.00,0.00,'2022-04-20 12:05:56','',''),(353,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,13260000.00,20000.00,0.00,0.00,'2022-04-21 10:17:22','',''),(354,'21','238',NULL,2,'Reception corrector for bridging 42',0.00,0.00,0.00,15000.00,0.00,'2022-04-21 10:29:35','',''),(355,'21','238','4',2,'Received from bridging 42',0.00,0.00,15000.00,0.00,0.00,'2022-04-21 10:29:35','',''),(356,'21','238',NULL,2,'Reception corrector for bridging 43',0.00,0.00,0.00,5000.00,0.00,'2022-04-21 10:29:50','',''),(357,'21','238','5',2,'Received from bridging 43',0.00,0.00,5000.00,0.00,0.00,'2022-04-21 10:29:50','',''),(358,'21','238','4',2,'Sale Id shift 26',0.00,0.00,0.00,3593.46,0.00,'2022-04-21 11:32:06','',''),(359,'21','238','5',2,'Sale Id shift 26',0.00,0.00,0.00,2106.15,0.00,'2022-04-21 11:32:06','',''),(360,'21','238','5',2,'Sale Id shift 26',0.00,0.00,0.00,438.67,0.00,'2022-04-21 11:32:06','',''),(361,'21','238','6',3,'Sale Id shift 26',0.00,0.00,0.00,218.55,0.00,'2022-04-21 11:32:06','',''),(362,'21','238','2',1,'Sale Id shift 26',0.00,0.00,0.00,2482.48,0.00,'2022-04-21 11:32:06','',''),(363,'21','238','2',1,'Sale Id shift 26',0.00,0.00,0.00,2896.41,0.00,'2022-04-21 11:32:06','',''),(364,'21','238','3',1,'Sale Id shift 26',0.00,0.00,0.00,287.68,0.00,'2022-04-21 11:32:06','',''),(365,'21','238',NULL,2,'Sale Id shift 26',4069679.64,0.00,0.00,0.00,0.00,'2022-04-21 11:32:06','',''),(366,'21','238',NULL,3,'Sale Id shift 26',120202.50,0.00,0.00,0.00,0.00,'2022-04-21 11:32:06','',''),(367,'21','238',NULL,1,'Sale Id shift 26',934984.05,0.00,0.00,0.00,0.00,'2022-04-21 11:32:06','',''),(368,'21','238','4',2,'Sale Id shift 27',0.00,0.00,0.00,3982.68,0.00,'2022-04-21 12:08:03','',''),(369,'21','238','5',2,'Sale Id shift 27',0.00,0.00,0.00,3916.88,0.00,'2022-04-21 12:08:03','',''),(370,'21','238','5',2,'Sale Id shift 27',0.00,0.00,0.00,1039.78,0.00,'2022-04-21 12:08:03','',''),(371,'21','238','6',3,'Sale Id shift 27',0.00,0.00,0.00,70.93,0.00,'2022-04-21 12:08:03','',''),(372,'21','238','2',1,'Sale Id shift 27',0.00,0.00,0.00,8156.92,0.00,'2022-04-21 12:08:03','',''),(373,'21','238','2',1,'Sale Id shift 27',0.00,0.00,0.00,8742.14,0.00,'2022-04-21 12:08:03','',''),(374,'21','238','3',1,'Sale Id shift 27',0.00,0.00,0.00,8655.97,0.00,'2022-04-21 12:08:03','',''),(375,'21','238',NULL,1,'Sale Id shift 27',4216579.95,0.00,0.00,0.00,0.00,'2022-04-21 12:08:03','',''),(376,'21','238',NULL,2,'Sale Id shift 27',5926782.42,0.00,0.00,0.00,0.00,'2022-04-21 12:08:03','',''),(377,'21','238',NULL,3,'Sale Id shift 27',39011.50,0.00,0.00,0.00,0.00,'2022-04-21 12:08:03','',''),(378,'21','238','3',1,'Sale Id shift 28',0.00,0.00,0.00,1799.65,0.00,'2022-04-22 13:57:58','',''),(379,'21','238','4',2,'Sale Id shift 28',0.00,0.00,0.00,5223.01,0.00,'2022-04-22 13:57:58','',''),(380,'21','238','5',2,'Sale Id shift 28',0.00,0.00,0.00,2241.89,0.00,'2022-04-22 13:57:58','',''),(381,'21','238','5',2,'Sale Id shift 28',0.00,0.00,0.00,1464.00,0.00,'2022-04-22 13:57:58','',''),(382,'21','238','6',3,'Sale Id shift 28',0.00,0.00,0.00,171.29,0.00,'2022-04-22 13:57:58','',''),(383,'21','238','2',1,'Sale Id shift 28',0.00,0.00,0.00,5746.08,0.00,'2022-04-22 13:57:58','',''),(384,'21','238','2',1,'Sale Id shift 28',0.00,0.00,0.00,2210.86,0.00,'2022-04-22 13:57:58','',''),(385,'21','238','3',1,'Sale Id shift 28',0.00,0.00,0.00,4580.98,0.00,'2022-04-22 13:57:58','',''),(386,'21','238',NULL,1,'Sale Id shift 28',2365699.05,0.00,0.00,0.00,0.00,'2022-04-22 13:57:58','',''),(387,'21','238',NULL,2,'Sale Id shift 28',5919860.70,0.00,0.00,0.00,0.00,'2022-04-22 13:57:58','',''),(388,'21','238',NULL,3,'Sale Id shift 28',94209.50,0.00,0.00,0.00,0.00,'2022-04-22 13:57:58','',''),(389,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2475000.00,15000.00,0.00,0.00,'2022-04-23 10:16:44','',''),(390,'21','238',NULL,1,'Reception corrector for bridging 44',0.00,0.00,0.00,15000.00,0.00,'2022-04-23 10:18:29','',''),(391,'21','238','2',1,'Received from bridging 44',0.00,0.00,15000.00,0.00,0.00,'2022-04-23 10:18:29','',''),(392,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2805000.00,17000.00,0.00,0.00,'2022-04-23 10:20:51','',''),(393,'21','238',NULL,1,'Reception corrector for bridging 46',0.00,0.00,0.00,6300.00,0.00,'2022-04-23 10:23:36','',''),(394,'21','238','3',1,'Received from bridging 46',0.00,0.00,6300.00,0.00,0.00,'2022-04-23 10:23:36','',''),(395,'21','238',NULL,1,'Reception corrector for bridging 45',0.00,0.00,0.00,10700.00,0.00,'2022-04-23 10:23:49','',''),(396,'21','238','2',1,'Received from bridging 45',0.00,0.00,10700.00,0.00,0.00,'2022-04-23 10:23:49','',''),(397,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,13923000.00,21000.00,0.00,0.00,'2022-04-23 10:25:58','',''),(398,'21','238',NULL,2,'Reception corrector for bridging 47',0.00,0.00,0.00,21000.00,0.00,'2022-04-23 10:29:59','',''),(399,'21','238','4',2,'Received from bridging 47',0.00,0.00,21000.00,0.00,0.00,'2022-04-23 10:29:59','',''),(400,'21','238','4',2,'Sale Id shift 29',0.00,0.00,0.00,4292.37,0.00,'2022-04-23 11:16:30','',''),(401,'21','238','5',2,'Sale Id shift 29',0.00,0.00,0.00,2543.18,0.00,'2022-04-23 11:16:30','',''),(402,'21','238','5',2,'Sale Id shift 29',0.00,0.00,0.00,9.66,0.00,'2022-04-23 11:16:30','',''),(403,'21','238','6',3,'Sale Id shift 29',0.00,0.00,0.00,167.64,0.00,'2022-04-23 11:16:30','',''),(404,'21','238','2',1,'Sale Id shift 29',0.00,0.00,0.00,6880.00,0.00,'2022-04-23 11:16:30','',''),(405,'21','238','2',1,'Sale Id shift 29',0.00,0.00,0.00,8282.51,0.00,'2022-04-23 11:16:30','',''),(406,'21','238',NULL,1,'Sale Id shift 29',2501814.15,0.00,0.00,0.00,0.00,'2022-04-23 11:16:30','',''),(407,'21','238',NULL,2,'Sale Id shift 29',4538374.23,0.00,0.00,0.00,0.00,'2022-04-23 11:16:30','',''),(408,'21','238',NULL,3,'Sale Id shift 29',92202.00,0.00,0.00,0.00,0.00,'2022-04-23 11:16:30','',''),(409,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2475000.00,15000.00,0.00,0.00,'2022-04-24 10:55:35','',''),(410,'21','238',NULL,1,'Reception corrector for bridging 49',0.00,0.00,0.00,1700.00,0.00,'2022-04-24 10:57:34','',''),(411,'21','238','3',1,'Received from bridging 49',0.00,0.00,1700.00,0.00,0.00,'2022-04-24 10:57:34','',''),(412,'21','238',NULL,1,'Reception corrector for bridging 48',0.00,0.00,0.00,13300.00,0.00,'2022-04-24 10:57:46','',''),(413,'21','238','2',1,'Received from bridging 48',0.00,0.00,13300.00,0.00,0.00,'2022-04-24 10:57:46','',''),(414,'21','238','3',1,'Sale Id shift 30',0.00,0.00,0.00,2157.30,0.00,'2022-04-24 11:18:13','',''),(415,'21','238','4',2,'Sale Id shift 30',0.00,0.00,0.00,4244.78,0.00,'2022-04-24 11:18:13','',''),(416,'21','238','5',2,'Sale Id shift 30',0.00,0.00,0.00,2024.17,0.00,'2022-04-24 11:18:13','',''),(417,'21','238','5',2,'Sale Id shift 30',0.00,0.00,0.00,523.59,0.00,'2022-04-24 11:18:13','',''),(418,'21','238','6',3,'Sale Id shift 30',0.00,0.00,0.00,250.06,0.00,'2022-04-24 11:18:13','',''),(419,'21','238','2',1,'Sale Id shift 30',0.00,0.00,0.00,5308.32,0.00,'2022-04-24 11:18:13','',''),(420,'21','238','2',1,'Sale Id shift 30',0.00,0.00,0.00,5104.70,0.00,'2022-04-24 11:18:13','',''),(421,'21','238','3',1,'Sale Id shift 30',0.00,0.00,0.00,4441.46,0.00,'2022-04-24 11:18:13','',''),(422,'21','238',NULL,1,'Sale Id shift 30',2806943.70,0.00,0.00,0.00,0.00,'2022-04-24 11:18:13','',''),(423,'21','238',NULL,2,'Sale Id shift 30',4503454.02,0.00,0.00,0.00,0.00,'2022-04-24 11:18:13','',''),(424,'21','238',NULL,3,'Sale Id shift 30',137533.00,0.00,0.00,0.00,0.00,'2022-04-24 11:18:13','',''),(425,'21','238','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,1674.79,0.00,'2022-04-25 09:11:56','',''),(426,'21','238','3',0,'Inventory adjustment from tank dipping to 1845',0.00,0.00,1845.00,0.00,0.00,'2022-04-25 09:11:56','',''),(427,'21','238','3',1,'Sale Id shift 31',0.00,0.00,0.00,206.09,0.00,'2022-04-25 10:54:31','',''),(428,'21','238','4',2,'Sale Id shift 31',0.00,0.00,0.00,5100.40,0.00,'2022-04-25 10:54:31','',''),(429,'21','238','5',2,'Sale Id shift 31',0.00,0.00,0.00,1823.00,0.00,'2022-04-25 10:54:31','',''),(430,'21','238','5',2,'Sale Id shift 31',0.00,0.00,0.00,1243.89,0.00,'2022-04-25 10:54:31','',''),(431,'21','238','6',3,'Sale Id shift 31',0.00,0.00,0.00,330.92,0.00,'2022-04-25 10:54:31','',''),(432,'21','238','2',1,'Sale Id shift 31',0.00,0.00,0.00,6278.05,0.00,'2022-04-25 10:54:31','',''),(433,'21','238','2',1,'Sale Id shift 31',0.00,0.00,0.00,7231.48,0.00,'2022-04-25 10:54:31','',''),(434,'21','238','3',1,'Sale Id shift 31',0.00,0.00,0.00,1635.13,0.00,'2022-04-25 10:54:31','',''),(435,'21','238',NULL,1,'Sale Id shift 31',2532873.75,0.00,0.00,0.00,0.00,'2022-04-25 10:54:31','',''),(436,'21','238',NULL,2,'Sale Id shift 31',5414913.27,0.00,0.00,0.00,0.00,'2022-04-25 10:54:31','',''),(437,'21','238',NULL,3,'Sale Id shift 31',182006.00,0.00,0.00,0.00,0.00,'2022-04-25 10:54:31','',''),(438,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5032500.00,30500.00,0.00,0.00,'2022-04-26 10:37:59','',''),(439,'21','238',NULL,1,'Reception corrector for bridging 50',0.00,0.00,0.00,15000.00,0.00,'2022-04-26 10:41:53','',''),(440,'21','238','2',1,'Received from bridging 50',0.00,0.00,15000.00,0.00,0.00,'2022-04-26 10:41:53','',''),(441,'21','238',NULL,1,'Reception corrector for bridging 51',0.00,0.00,0.00,15500.00,0.00,'2022-04-26 10:42:11','',''),(442,'21','238','3',1,'Received from bridging 51',0.00,0.00,15500.00,0.00,0.00,'2022-04-26 10:42:11','',''),(443,'21','238','4',2,'Sale Id shift 32',0.00,0.00,0.00,6177.19,0.00,'2022-04-26 11:03:30','',''),(444,'21','238','5',2,'Sale Id shift 32',0.00,0.00,0.00,1098.79,0.00,'2022-04-26 11:03:30','',''),(445,'21','238','5',2,'Sale Id shift 32',0.00,0.00,0.00,1845.70,0.00,'2022-04-26 11:03:30','',''),(446,'21','238','6',3,'Sale Id shift 32',0.00,0.00,0.00,143.20,0.00,'2022-04-26 11:03:30','',''),(447,'21','238',NULL,2,'Sale Id shift 32',6047673.84,0.00,0.00,0.00,0.00,'2022-04-26 11:03:30','',''),(448,'21','238',NULL,3,'Sale Id shift 32',78760.00,0.00,0.00,0.00,0.00,'2022-04-26 11:03:30','',''),(449,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2722500.00,16500.00,0.00,0.00,'2022-04-27 12:01:47','',''),(450,'21','238',NULL,1,'Reception corrector for bridging 53',0.00,0.00,0.00,4500.00,0.00,'2022-04-27 12:03:46','',''),(451,'21','238','3',1,'Received from bridging 53',0.00,0.00,4500.00,0.00,0.00,'2022-04-27 12:03:46','',''),(452,'21','238',NULL,1,'Reception corrector for bridging 52',0.00,0.00,0.00,12000.00,0.00,'2022-04-27 12:03:57','',''),(453,'21','238','2',1,'Received from bridging 52',0.00,0.00,12000.00,0.00,0.00,'2022-04-27 12:03:57','',''),(454,'21','238','3',1,'Sale Id shift 33',0.00,0.00,0.00,2202.53,0.00,'2022-04-27 12:24:45','',''),(455,'21','238','4',2,'Sale Id shift 33',0.00,0.00,0.00,4575.59,0.00,'2022-04-27 12:24:45','',''),(456,'21','238','5',2,'Sale Id shift 33',0.00,0.00,0.00,2137.25,0.00,'2022-04-27 12:24:45','',''),(457,'21','238','5',2,'Sale Id shift 33',0.00,0.00,0.00,979.46,0.00,'2022-04-27 12:24:45','',''),(458,'21','238','6',3,'Sale Id shift 33',0.00,0.00,0.00,137.65,0.00,'2022-04-27 12:24:45','',''),(459,'21','238','2',1,'Sale Id shift 33',0.00,0.00,0.00,7878.69,0.00,'2022-04-27 12:24:45','',''),(460,'21','238','2',1,'Sale Id shift 33',0.00,0.00,0.00,7192.44,0.00,'2022-04-27 12:24:45','',''),(461,'21','238','3',1,'Sale Id shift 33',0.00,0.00,0.00,12318.73,0.00,'2022-04-27 12:24:45','',''),(462,'21','238',NULL,1,'Sale Id shift 33',4882744.35,0.00,0.00,0.00,0.00,'2022-04-27 12:24:45','',''),(463,'21','238',NULL,2,'Sale Id shift 33',5099994.90,0.00,0.00,0.00,0.00,'2022-04-27 12:24:45','',''),(464,'21','238',NULL,3,'Sale Id shift 33',75707.50,0.00,0.00,0.00,0.00,'2022-04-27 12:24:45','',''),(465,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2475000.00,15000.00,0.00,0.00,'2022-04-28 11:24:26','',''),(466,'21','238',NULL,1,'Reception corrector for bridging 55',0.00,0.00,0.00,3500.00,0.00,'2022-04-28 11:27:59','',''),(467,'21','238','3',1,'Received from bridging 55',0.00,0.00,3500.00,0.00,0.00,'2022-04-28 11:27:59','',''),(468,'21','238',NULL,1,'Reception corrector for bridging 54',0.00,0.00,0.00,11500.00,0.00,'2022-04-28 11:28:12','',''),(469,'21','238','2',1,'Received from bridging 54',0.00,0.00,11500.00,0.00,0.00,'2022-04-28 11:28:12','',''),(470,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,13326300.00,20100.00,0.00,0.00,'2022-04-28 13:20:46','',''),(471,'21','238',NULL,2,'Reception corrector for bridging 57',0.00,0.00,0.00,10000.00,0.00,'2022-04-28 13:23:38','',''),(472,'21','238','5',2,'Received from bridging 57',0.00,0.00,10000.00,0.00,0.00,'2022-04-28 13:23:38','',''),(473,'21','238',NULL,2,'Reception corrector for bridging 56',0.00,0.00,0.00,10100.00,0.00,'2022-04-28 13:24:01','',''),(474,'21','238','4',2,'Received from bridging 56',0.00,0.00,10100.00,0.00,0.00,'2022-04-28 13:24:01','',''),(475,'21','238','3',1,'Sale Id shift 34',0.00,0.00,0.00,229.26,0.00,'2022-04-28 14:03:25','',''),(476,'21','238','4',2,'Sale Id shift 34',0.00,0.00,0.00,2491.86,0.00,'2022-04-28 14:03:25','',''),(477,'21','238','5',2,'Sale Id shift 34',0.00,0.00,0.00,3767.43,0.00,'2022-04-28 14:03:25','',''),(478,'21','238','5',2,'Sale Id shift 34',0.00,0.00,0.00,1257.68,0.00,'2022-04-28 14:03:25','',''),(479,'21','238','6',3,'Sale Id shift 34',0.00,0.00,0.00,98.21,0.00,'2022-04-28 14:03:25','',''),(480,'21','238','2',1,'Sale Id shift 34',0.00,0.00,0.00,5709.85,0.00,'2022-04-28 14:03:25','',''),(481,'21','238','2',1,'Sale Id shift 34',0.00,0.00,0.00,5029.76,0.00,'2022-04-28 14:03:25','',''),(482,'21','238','3',1,'Sale Id shift 34',0.00,0.00,0.00,5873.16,0.00,'2022-04-28 14:03:25','',''),(483,'21','238',NULL,1,'Sale Id shift 34',2778934.95,0.00,0.00,0.00,0.00,'2022-04-28 14:03:25','',''),(484,'21','238',NULL,2,'Sale Id shift 34',4983751.11,0.00,0.00,0.00,0.00,'2022-04-28 14:03:25','',''),(485,'21','238',NULL,3,'Sale Id shift 34',54015.50,0.00,0.00,0.00,0.00,'2022-04-28 14:03:25','',''),(486,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2475000.00,15000.00,0.00,0.00,'2022-04-29 08:56:04','',''),(487,'21','238',NULL,1,'Reception corrector for bridging 59',0.00,0.00,0.00,3000.00,0.00,'2022-04-29 08:57:44','',''),(488,'21','238','3',1,'Received from bridging 59',0.00,0.00,3000.00,0.00,0.00,'2022-04-29 08:57:44','',''),(489,'21','238',NULL,1,'Reception corrector for bridging 58',0.00,0.00,0.00,12000.00,0.00,'2022-04-29 08:57:59','',''),(490,'21','238','2',1,'Received from bridging 58',0.00,0.00,12000.00,0.00,0.00,'2022-04-29 08:57:59','',''),(491,'21','238','3',1,'Sale Id shift 35',0.00,0.00,0.00,555.72,0.00,'2022-04-29 09:15:07','',''),(492,'21','238','4',2,'Sale Id shift 35',0.00,0.00,0.00,1790.38,0.00,'2022-04-29 09:15:07','',''),(493,'21','238','5',2,'Sale Id shift 35',0.00,0.00,0.00,716.90,0.00,'2022-04-29 09:15:07','',''),(494,'21','238','5',2,'Sale Id shift 35',0.00,0.00,0.00,397.69,0.00,'2022-04-29 09:15:07','',''),(495,'21','238','6',3,'Sale Id shift 35',0.00,0.00,0.00,232.82,0.00,'2022-04-29 09:15:07','',''),(496,'21','238','2',1,'Sale Id shift 35',0.00,0.00,0.00,6088.11,0.00,'2022-04-29 09:15:07','',''),(497,'21','238','2',1,'Sale Id shift 35',0.00,0.00,0.00,6886.62,0.00,'2022-04-29 09:15:07','',''),(498,'21','238','3',1,'Sale Id shift 35',0.00,0.00,0.00,2816.89,0.00,'2022-04-29 09:15:07','',''),(499,'21','238',NULL,2,'Sale Id shift 35',1925995.11,0.00,0.00,0.00,0.00,'2022-04-29 09:15:07','',''),(500,'21','238',NULL,3,'Sale Id shift 35',128051.00,0.00,0.00,0.00,0.00,'2022-04-29 09:15:07','',''),(501,'21','238',NULL,1,'Sale Id shift 35',2697311.10,0.00,0.00,0.00,0.00,'2022-04-29 09:15:07','',''),(502,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8950500.00,13500.00,0.00,0.00,'2022-04-30 12:44:02','',''),(503,'21','238',NULL,2,'Reception corrector for bridging 61',0.00,0.00,0.00,5200.00,0.00,'2022-04-30 12:46:19','',''),(504,'21','238','5',2,'Received from bridging 61',0.00,0.00,5200.00,0.00,0.00,'2022-04-30 12:46:19','',''),(505,'21','238',NULL,2,'Reception corrector for bridging 60',0.00,0.00,0.00,8300.00,0.00,'2022-04-30 12:46:37','',''),(506,'21','238','4',2,'Received from bridging 60',0.00,0.00,8300.00,0.00,0.00,'2022-04-30 12:46:37','',''),(507,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,3300000.00,20000.00,0.00,0.00,'2022-04-30 12:46:52','',''),(508,'21','238',NULL,1,'Reception corrector for bridging 63',0.00,0.00,0.00,5050.00,0.00,'2022-04-30 12:48:58','',''),(509,'21','238','3',1,'Received from bridging 63',0.00,0.00,5050.00,0.00,0.00,'2022-04-30 12:48:58','',''),(510,'21','238',NULL,1,'Reception corrector for bridging 62',0.00,0.00,0.00,14950.00,0.00,'2022-04-30 12:49:14','',''),(511,'21','238','2',1,'Received from bridging 62',0.00,0.00,14950.00,0.00,0.00,'2022-04-30 12:49:14','',''),(512,'21','238','3',1,'Sale Id shift 36',0.00,0.00,0.00,269.84,0.00,'2022-04-30 13:10:20','',''),(513,'21','238','4',2,'Sale Id shift 36',0.00,0.00,0.00,3822.59,0.00,'2022-04-30 13:10:20','',''),(514,'21','238','5',2,'Sale Id shift 36',0.00,0.00,0.00,3420.15,0.00,'2022-04-30 13:10:20','',''),(515,'21','238','5',2,'Sale Id shift 36',0.00,0.00,0.00,2107.83,0.00,'2022-04-30 13:10:20','',''),(516,'21','238','6',3,'Sale Id shift 36',0.00,0.00,0.00,360.63,0.00,'2022-04-30 13:10:20','',''),(517,'21','238','2',1,'Sale Id shift 36',0.00,0.00,0.00,4504.60,0.00,'2022-04-30 13:10:20','',''),(518,'21','238','2',1,'Sale Id shift 36',0.00,0.00,0.00,7408.04,0.00,'2022-04-30 13:10:20','',''),(519,'21','238','3',1,'Sale Id shift 36',0.00,0.00,0.00,2574.90,0.00,'2022-04-30 13:10:20','',''),(520,'21','238',NULL,1,'Sale Id shift 36',2434967.70,0.00,0.00,0.00,0.00,'2022-04-30 13:10:20','',''),(521,'21','238',NULL,2,'Sale Id shift 36',6199427.91,0.00,0.00,0.00,0.00,'2022-04-30 13:10:20','',''),(522,'21','238',NULL,3,'Sale Id shift 36',198346.50,0.00,0.00,0.00,0.00,'2022-04-30 13:10:20','',''),(523,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-01 08:30:59','',''),(524,'21','238',NULL,1,'Reception corrector for bridging 65',0.00,0.00,0.00,16000.00,0.00,'2022-05-01 08:32:43','',''),(525,'21','238','3',1,'Received from bridging 65',0.00,0.00,16000.00,0.00,0.00,'2022-05-01 08:32:43','',''),(526,'21','238','3',1,'Sale Id shift 37',0.00,0.00,0.00,1995.91,0.00,'2022-05-01 09:00:52','',''),(527,'21','238','4',2,'Sale Id shift 37',0.00,0.00,0.00,3446.96,0.00,'2022-05-01 09:00:52','',''),(528,'21','238','5',2,'Sale Id shift 37',0.00,0.00,0.00,2199.96,0.00,'2022-05-01 09:00:52','',''),(529,'21','238','5',2,'Sale Id shift 37',0.00,0.00,0.00,443.01,0.00,'2022-05-01 09:00:52','',''),(530,'21','238','6',3,'Sale Id shift 37',0.00,0.00,0.00,195.89,0.00,'2022-05-01 09:00:52','',''),(531,'21','238','2',1,'Sale Id shift 37',0.00,0.00,0.00,7201.56,0.00,'2022-05-01 09:00:52','',''),(532,'21','238','2',1,'Sale Id shift 37',0.00,0.00,0.00,7310.31,0.00,'2022-05-01 09:00:52','',''),(533,'21','238','3',1,'Sale Id shift 37',0.00,0.00,0.00,4074.45,0.00,'2022-05-01 09:00:52','',''),(534,'21','238',NULL,1,'Sale Id shift 37',3396067.95,0.00,0.00,0.00,0.00,'2022-05-01 09:00:52','',''),(535,'21','238',NULL,2,'Sale Id shift 37',4037623.59,0.00,0.00,0.00,0.00,'2022-05-01 09:00:52','',''),(536,'21','238',NULL,3,'Sale Id shift 37',107739.50,0.00,0.00,0.00,0.00,'2022-05-01 09:00:52','',''),(537,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,3300000.00,20000.00,0.00,0.00,'2022-05-05 12:37:07','',''),(538,'21','238',NULL,1,'Reception corrector for bridging 67',0.00,0.00,0.00,5200.00,0.00,'2022-05-05 12:39:11','',''),(539,'21','238','3',1,'Received from bridging 67',0.00,0.00,5200.00,0.00,0.00,'2022-05-05 12:39:11','',''),(540,'21','238','3',1,'Returned bridging 65',0.00,0.00,0.00,16000.00,0.00,'2022-05-05 12:42:31','',''),(541,'21','238',NULL,1,'Reception Return corrector for bridging 65',0.00,0.00,16000.00,0.00,0.00,'2022-05-05 12:42:31','',''),(542,'21','238',NULL,1,'Reception corrector for bridging 68',0.00,0.00,0.00,30000.00,0.00,'2022-05-05 18:19:55','',''),(543,'21','238','2',1,'Received from bridging 68',0.00,0.00,30000.00,0.00,0.00,'2022-05-05 18:19:55','',''),(544,'21','238',NULL,1,'Reception corrector for bridging 69',0.00,0.00,0.00,20000.00,0.00,'2022-05-05 18:20:38','',''),(545,'21','238','3',1,'Received from bridging 69',0.00,0.00,20000.00,0.00,0.00,'2022-05-05 18:20:38','',''),(546,'21','238','4',2,'Sale Id shift 38',0.00,0.00,0.00,3262.53,0.00,'2022-05-06 11:43:54','',''),(547,'21','238','5',2,'Sale Id shift 38',0.00,0.00,0.00,1940.16,0.00,'2022-05-06 11:43:54','',''),(548,'21','238','5',2,'Sale Id shift 38',0.00,0.00,0.00,482.20,0.00,'2022-05-06 11:43:54','',''),(549,'21','238','6',3,'Sale Id shift 38',0.00,0.00,0.00,143.68,0.00,'2022-05-06 11:43:54','',''),(550,'21','238','2',1,'Sale Id shift 38',0.00,0.00,0.00,11483.63,0.00,'2022-05-06 11:43:54','',''),(551,'21','238','2',1,'Sale Id shift 38',0.00,0.00,0.00,12648.70,0.00,'2022-05-06 11:43:54','',''),(552,'21','238','3',1,'Sale Id shift 38',0.00,0.00,0.00,4873.44,0.00,'2022-05-06 11:43:54','',''),(553,'21','238',NULL,1,'Sale Id shift 38',4785952.05,0.00,0.00,0.00,0.00,'2022-05-06 11:43:54','',''),(554,'21','238',NULL,2,'Sale Id shift 38',3769082.07,0.00,0.00,0.00,0.00,'2022-05-06 11:43:54','',''),(555,'21','238',NULL,3,'Sale Id shift 38',79024.00,0.00,0.00,0.00,0.00,'2022-05-06 11:43:54','',''),(556,'21','238',NULL,1,'Reception corrector for bridging 66',0.00,0.00,0.00,14800.00,0.00,'2022-05-06 12:10:22','',''),(557,'21','238','2',1,'Received from bridging 66',0.00,0.00,14800.00,0.00,0.00,'2022-05-06 12:10:22','',''),(558,'21','238','3',1,'Sale Id shift 39',0.00,0.00,0.00,456.46,0.00,'2022-05-06 12:37:03','',''),(559,'21','238','4',2,'Sale Id shift 39',0.00,0.00,0.00,2795.39,0.00,'2022-05-06 12:37:03','',''),(560,'21','238','5',2,'Sale Id shift 39',0.00,0.00,0.00,293.36,0.00,'2022-05-06 12:37:03','',''),(561,'21','238','6',3,'Sale Id shift 39',0.00,0.00,0.00,42.47,0.00,'2022-05-06 12:37:03','',''),(562,'21','238','2',1,'Sale Id shift 39',0.00,0.00,0.00,4360.65,0.00,'2022-05-06 12:37:03','',''),(563,'21','238','2',1,'Sale Id shift 39',0.00,0.00,0.00,5308.94,0.00,'2022-05-06 12:37:03','',''),(564,'21','238','3',1,'Sale Id shift 39',0.00,0.00,0.00,3899.96,0.00,'2022-05-06 12:37:03','',''),(565,'21','238',NULL,1,'Sale Id shift 39',2314291.65,0.00,0.00,0.00,0.00,'2022-05-06 12:37:03','',''),(566,'21','238',NULL,2,'Sale Id shift 39',2047841.25,0.00,0.00,0.00,0.00,'2022-05-06 12:37:03','',''),(567,'21','238',NULL,3,'Sale Id shift 39',23358.50,0.00,0.00,0.00,0.00,'2022-05-06 12:37:03','',''),(568,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9945000.00,15000.00,0.00,0.00,'2022-05-06 14:21:28','',''),(569,'21','238',NULL,2,'Reception corrector for bridging 70',0.00,0.00,0.00,15000.00,0.00,'2022-05-06 14:23:42','',''),(570,'21','238','5',2,'Received from bridging 70',0.00,0.00,15000.00,0.00,0.00,'2022-05-06 14:23:42','',''),(571,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9945000.00,15000.00,0.00,0.00,'2022-05-06 14:25:20','',''),(572,'21','238',NULL,2,'Reception corrector for bridging 71',0.00,0.00,0.00,15000.00,0.00,'2022-05-06 14:27:41','',''),(573,'21','238','4',2,'Received from bridging 71',0.00,0.00,15000.00,0.00,0.00,'2022-05-06 14:27:41','',''),(574,'21','238','3',1,'Sale Id shift 40',0.00,0.00,0.00,2125.60,0.00,'2022-05-06 14:37:29','',''),(575,'21','238','4',2,'Sale Id shift 40',0.00,0.00,0.00,2007.41,0.00,'2022-05-06 14:37:29','',''),(576,'21','238','5',2,'Sale Id shift 40',0.00,0.00,0.00,644.07,0.00,'2022-05-06 14:37:29','',''),(577,'21','238','6',3,'Sale Id shift 40',0.00,0.00,0.00,79.25,0.00,'2022-05-06 14:37:29','',''),(578,'21','238','3',1,'Sale Id shift 40',0.00,0.00,0.00,4822.14,0.00,'2022-05-06 14:37:29','',''),(579,'21','238',NULL,1,'Sale Id shift 40',1146377.10,0.00,0.00,0.00,0.00,'2022-05-06 14:37:29','',''),(580,'21','238',NULL,2,'Sale Id shift 40',1757931.24,0.00,0.00,0.00,0.00,'2022-05-06 14:37:29','',''),(581,'21','238',NULL,3,'Sale Id shift 40',43587.50,0.00,0.00,0.00,0.00,'2022-05-06 14:37:29','',''),(582,'21','238','4',2,'Sale Id shift 41',0.00,0.00,0.00,1457.32,0.00,'2022-05-06 15:06:37','',''),(583,'21','238','5',2,'Sale Id shift 41',0.00,0.00,0.00,6068.19,0.00,'2022-05-06 15:06:37','',''),(584,'21','238','5',2,'Sale Id shift 41',0.00,0.00,0.00,3804.18,0.00,'2022-05-06 15:06:37','',''),(585,'21','238','6',3,'Sale Id shift 41',0.00,0.00,0.00,191.65,0.00,'2022-05-06 15:06:37','',''),(586,'21','238','2',1,'Sale Id shift 41',0.00,0.00,0.00,4883.50,0.00,'2022-05-06 15:06:37','',''),(587,'21','238','2',1,'Sale Id shift 41',0.00,0.00,0.00,4613.93,0.00,'2022-05-06 15:06:37','',''),(588,'21','238','3',1,'Sale Id shift 41',0.00,0.00,0.00,1940.89,0.00,'2022-05-06 15:06:37','',''),(589,'21','238',NULL,2,'Sale Id shift 41',7511584.47,0.00,0.00,0.00,0.00,'2022-05-06 15:06:37','',''),(590,'21','238',NULL,3,'Sale Id shift 41',105407.50,0.00,0.00,0.00,0.00,'2022-05-06 15:06:37','',''),(591,'21','238',NULL,1,'Sale Id shift 41',1887322.80,0.00,0.00,0.00,0.00,'2022-05-06 15:06:37','',''),(592,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-06 15:29:22','',''),(593,'21','238',NULL,1,'Reception corrector for bridging 73',0.00,0.00,0.00,13400.00,0.00,'2022-05-06 15:32:50','',''),(594,'21','238','3',1,'Received from bridging 73',0.00,0.00,13400.00,0.00,0.00,'2022-05-06 15:32:50','',''),(595,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2805000.00,17000.00,0.00,0.00,'2022-05-06 15:44:11','',''),(596,'21','238',NULL,1,'Reception corrector for bridging 74',0.00,0.00,0.00,3000.00,0.00,'2022-05-06 15:46:07','',''),(597,'21','238','2',1,'Received from bridging 74',0.00,0.00,3000.00,0.00,0.00,'2022-05-06 15:46:07','',''),(598,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,3300000.00,20000.00,0.00,0.00,'2022-05-07 14:46:05','',''),(599,'21','238',NULL,1,'Reception corrector for bridging 76',0.00,0.00,0.00,17600.00,0.00,'2022-05-07 14:50:13','',''),(600,'21','238','2',1,'Received from bridging 76',0.00,0.00,17600.00,0.00,0.00,'2022-05-07 14:50:13','',''),(601,'21','238','3',1,'Sale Id shift 42',0.00,0.00,0.00,205.91,0.00,'2022-05-07 16:23:52','',''),(602,'21','238','4',2,'Sale Id shift 42',0.00,0.00,0.00,6157.69,0.00,'2022-05-07 16:23:52','',''),(603,'21','238','5',2,'Sale Id shift 42',0.00,0.00,0.00,5435.19,0.00,'2022-05-07 16:23:52','',''),(604,'21','238','5',2,'Sale Id shift 42',0.00,0.00,0.00,434.60,0.00,'2022-05-07 16:23:52','',''),(605,'21','238','6',3,'Sale Id shift 42',0.00,0.00,0.00,464.61,0.00,'2022-05-07 16:23:52','',''),(606,'21','238','2',1,'Sale Id shift 42',0.00,0.00,0.00,9816.75,0.00,'2022-05-07 16:23:52','',''),(607,'21','238','2',1,'Sale Id shift 42',0.00,0.00,0.00,11170.21,0.00,'2022-05-07 16:23:52','',''),(608,'21','238','3',1,'Sale Id shift 42',0.00,0.00,0.00,3879.35,0.00,'2022-05-07 16:23:52','',''),(609,'21','238',NULL,1,'Sale Id shift 42',4136916.30,0.00,0.00,0.00,0.00,'2022-05-07 16:23:52','',''),(610,'21','238',NULL,2,'Sale Id shift 42',7974219.24,0.00,0.00,0.00,0.00,'2022-05-07 16:23:52','',''),(611,'21','238',NULL,3,'Sale Id shift 42',255535.50,0.00,0.00,0.00,0.00,'2022-05-07 16:23:52','',''),(612,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,10170000.00,15000.00,0.00,0.00,'2022-05-08 12:37:06','',''),(613,'21','238',NULL,2,'Reception corrector for bridging 78',0.00,0.00,0.00,15000.00,0.00,'2022-05-08 12:38:57','',''),(614,'21','238','4',2,'Received from bridging 78',0.00,0.00,15000.00,0.00,0.00,'2022-05-08 12:38:57','',''),(615,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2475000.00,15000.00,0.00,0.00,'2022-05-17 13:23:13','',''),(616,'21','238',NULL,1,'Reception corrector for bridging 80',0.00,0.00,0.00,3700.00,0.00,'2022-05-17 13:25:14','',''),(617,'21','238','3',1,'Received from bridging 80',0.00,0.00,3700.00,0.00,0.00,'2022-05-17 13:25:14','',''),(618,'21','238',NULL,1,'Reception corrector for bridging 79',0.00,0.00,0.00,11300.00,0.00,'2022-05-17 13:25:28','',''),(619,'21','238','1',1,'Received from bridging 79',0.00,0.00,11300.00,0.00,0.00,'2022-05-17 13:25:28','',''),(620,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,6270000.00,38000.00,0.00,0.00,'2022-05-17 13:33:03','',''),(621,'21','238',NULL,1,'Reception corrector for bridging 81',0.00,0.00,0.00,18000.00,0.00,'2022-05-17 13:35:39','',''),(622,'21','238','2',1,'Received from bridging 81',0.00,0.00,18000.00,0.00,0.00,'2022-05-17 13:35:39','',''),(623,'21','238','3',1,'Sale Id shift 44',0.00,0.00,0.00,2886.24,0.00,'2022-05-17 16:22:07','',''),(624,'21','238','4',2,'Sale Id shift 44',0.00,0.00,0.00,7991.00,0.00,'2022-05-17 16:22:07','',''),(625,'21','238','5',2,'Sale Id shift 44',0.00,0.00,0.00,1239.20,0.00,'2022-05-17 16:22:07','',''),(626,'21','238','5',2,'Sale Id shift 44',0.00,0.00,0.00,1181.05,0.00,'2022-05-17 16:22:07','',''),(627,'21','238','6',3,'Sale Id shift 44',0.00,0.00,0.00,183.90,0.00,'2022-05-17 16:22:07','',''),(628,'21','238','2',1,'Sale Id shift 44',0.00,0.00,0.00,8357.32,0.00,'2022-05-17 16:22:07','',''),(629,'21','238','2',1,'Sale Id shift 44',0.00,0.00,0.00,10921.97,0.00,'2022-05-17 16:22:07','',''),(630,'21','238','3',1,'Sale Id shift 44',0.00,0.00,0.00,7796.66,0.00,'2022-05-17 16:22:07','',''),(631,'21','238',NULL,1,'Sale Id shift 44',4943761.35,0.00,0.00,0.00,0.00,'2022-05-17 16:22:07','',''),(632,'21','238',NULL,2,'Sale Id shift 44',6902658.75,0.00,0.00,0.00,0.00,'2022-05-17 16:22:07','',''),(633,'21','238',NULL,3,'Sale Id shift 44',101145.00,0.00,0.00,0.00,0.00,'2022-05-17 16:22:07','',''),(634,'21','238',NULL,1,'Reception corrector for bridging 72',0.00,0.00,0.00,31600.00,0.00,'2022-05-17 16:23:55','',''),(635,'21','238','2',1,'Received from bridging 72',0.00,0.00,31600.00,0.00,0.00,'2022-05-17 16:23:55','',''),(636,'21','238',NULL,1,'Reception corrector for bridging 75',0.00,0.00,0.00,14000.00,0.00,'2022-05-17 16:25:45','',''),(637,'21','238','3',1,'Received from bridging 75',0.00,0.00,14000.00,0.00,0.00,'2022-05-17 16:25:45','',''),(638,'21','238','4',2,'Sale Id shift 45',0.00,0.00,0.00,2257.06,0.00,'2022-05-17 16:40:03','',''),(639,'21','238','6',3,'Sale Id shift 45',0.00,0.00,0.00,2.19,0.00,'2022-05-17 16:40:03','',''),(640,'21','238',NULL,2,'Sale Id shift 45',1496430.78,0.00,0.00,0.00,0.00,'2022-05-17 16:40:03','',''),(641,'21','238',NULL,3,'Sale Id shift 45',1204.50,0.00,0.00,0.00,0.00,'2022-05-17 16:40:03','',''),(642,'21','238','3',1,'Sale Id shift 46',0.00,0.00,0.00,5331.72,0.00,'2022-05-17 17:13:31','',''),(643,'21','238','4',2,'Sale Id shift 46',0.00,0.00,0.00,6235.15,0.00,'2022-05-17 17:13:31','',''),(644,'21','238','6',3,'Sale Id shift 46',0.00,0.00,0.00,201.79,0.00,'2022-05-17 17:13:31','',''),(645,'21','238','2',1,'Sale Id shift 46',0.00,0.00,0.00,9588.85,0.00,'2022-05-17 17:13:31','',''),(646,'21','238','2',1,'Sale Id shift 46',0.00,0.00,0.00,9356.41,0.00,'2022-05-17 17:13:31','',''),(647,'21','238','3',1,'Sale Id shift 46',0.00,0.00,0.00,7570.14,0.00,'2022-05-17 17:13:31','',''),(648,'21','238',NULL,2,'Sale Id shift 46',4227431.70,0.00,0.00,0.00,0.00,'2022-05-17 17:13:31','',''),(649,'21','238',NULL,3,'Sale Id shift 46',131163.50,0.00,0.00,0.00,0.00,'2022-05-17 17:13:31','',''),(650,'21','238',NULL,1,'Sale Id shift 46',5254774.80,0.00,0.00,0.00,0.00,'2022-05-17 17:13:31','',''),(651,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,30035400.00,44300.00,0.00,0.00,'2022-05-17 17:17:43','',''),(652,'21','238',NULL,2,'Reception corrector for bridging 84',0.00,0.00,0.00,29300.00,0.00,'2022-05-17 17:19:34','',''),(653,'21','238','5',2,'Received from bridging 84',0.00,0.00,29300.00,0.00,0.00,'2022-05-17 17:19:34','',''),(654,'21','238',NULL,2,'Reception corrector for bridging 83',0.00,0.00,0.00,15000.00,0.00,'2022-05-17 17:19:58','',''),(655,'21','238','4',2,'Received from bridging 83',0.00,0.00,15000.00,0.00,0.00,'2022-05-17 17:19:58','',''),(656,'21','238',NULL,1,'Reception corrector for bridging 77',0.00,0.00,0.00,2400.00,0.00,'2022-05-17 17:20:19','',''),(657,'21','238','3',1,'Received from bridging 77',0.00,0.00,2400.00,0.00,0.00,'2022-05-17 17:20:19','',''),(658,'21','238',NULL,1,'Reception corrector for bridging 82',0.00,0.00,0.00,20000.00,0.00,'2022-05-17 17:21:20','',''),(659,'21','238','3',1,'Received from bridging 82',0.00,0.00,20000.00,0.00,0.00,'2022-05-17 17:21:20','',''),(660,'21','238','4',2,'Sale Id shift 47',0.00,0.00,0.00,7236.97,0.00,'2022-05-17 17:49:48','',''),(661,'21','238','5',2,'Sale Id shift 47',0.00,0.00,0.00,850.01,0.00,'2022-05-17 17:49:48','',''),(662,'21','238','5',2,'Sale Id shift 47',0.00,0.00,0.00,513.24,0.00,'2022-05-17 17:49:48','',''),(663,'21','238','6',3,'Sale Id shift 47',0.00,0.00,0.00,201.58,0.00,'2022-05-17 17:49:48','',''),(664,'21','238','2',1,'Sale Id shift 47',0.00,0.00,0.00,955.16,0.00,'2022-05-17 17:49:48','',''),(665,'21','238','2',1,'Sale Id shift 47',0.00,0.00,0.00,1947.43,0.00,'2022-05-17 17:49:48','',''),(666,'21','238',NULL,1,'Sale Id shift 47',478927.35,0.00,0.00,0.00,0.00,'2022-05-17 17:49:48','',''),(667,'21','238',NULL,2,'Sale Id shift 47',5830949.16,0.00,0.00,0.00,0.00,'2022-05-17 17:49:48','',''),(668,'21','238',NULL,3,'Sale Id shift 47',131027.00,0.00,0.00,0.00,0.00,'2022-05-17 17:49:48','',''),(669,'21','238','4',2,'Sale Id shift 48',0.00,0.00,0.00,6102.31,0.00,'2022-05-17 18:19:22','',''),(670,'21','238','5',2,'Sale Id shift 48',0.00,0.00,0.00,4763.31,0.00,'2022-05-17 18:19:22','',''),(671,'21','238','5',2,'Sale Id shift 48',0.00,0.00,0.00,2792.48,0.00,'2022-05-17 18:19:22','',''),(672,'21','238','6',3,'Sale Id shift 48',0.00,0.00,0.00,184.15,0.00,'2022-05-17 18:19:22','',''),(673,'21','238',NULL,2,'Sale Id shift 48',9260191.80,0.00,0.00,0.00,0.00,'2022-05-17 18:19:22','',''),(674,'21','238',NULL,3,'Sale Id shift 48',119697.50,0.00,0.00,0.00,0.00,'2022-05-17 18:19:22','',''),(675,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,10770000.00,15000.00,0.00,0.00,'2022-05-17 18:30:15','',''),(676,'21','238',NULL,2,'Reception corrector for bridging 85',0.00,0.00,0.00,15000.00,0.00,'2022-05-17 18:36:39','',''),(677,'21','238','4',2,'Received from bridging 85',0.00,0.00,15000.00,0.00,0.00,'2022-05-17 18:36:39','',''),(678,'21','238','1',1,'Sale Id shift 49',0.00,0.00,0.00,4731.72,0.00,'2022-05-17 19:37:39','',''),(679,'21','238','3',1,'Sale Id shift 49',0.00,0.00,0.00,758.51,0.00,'2022-05-17 19:37:39','',''),(680,'21','238','4',2,'Sale Id shift 49',0.00,0.00,0.00,8617.72,0.00,'2022-05-17 19:37:39','',''),(681,'21','238','5',2,'Sale Id shift 49',0.00,0.00,0.00,4224.80,0.00,'2022-05-17 19:37:39','',''),(682,'21','238','5',2,'Sale Id shift 49',0.00,0.00,0.00,2119.13,0.00,'2022-05-17 19:37:39','',''),(683,'21','238','6',3,'Sale Id shift 49',0.00,0.00,0.00,321.14,0.00,'2022-05-17 19:37:39','',''),(684,'21','238','1',1,'Sale Id shift 49',0.00,0.00,0.00,6504.02,0.00,'2022-05-17 19:37:39','',''),(685,'21','238','3',1,'Sale Id shift 49',0.00,0.00,0.00,3013.66,0.00,'2022-05-17 19:37:39','',''),(686,'21','238',NULL,2,'Sale Id shift 49',10143998.70,0.00,0.00,0.00,0.00,'2022-05-17 19:37:39','',''),(687,'21','238',NULL,3,'Sale Id shift 49',208741.00,0.00,0.00,0.00,0.00,'2022-05-17 19:37:39','',''),(688,'21','238',NULL,1,'Sale Id shift 49',2476305.15,0.00,0.00,0.00,0.00,'2022-05-17 19:37:39','',''),(689,'21','238','4',2,'Sale Id shift 50',0.00,0.00,0.00,13495.81,0.00,'2022-05-17 21:17:13','',''),(690,'21','238','6',3,'Sale Id shift 50',0.00,0.00,0.00,110.87,0.00,'2022-05-17 21:17:13','',''),(691,'21','238',NULL,2,'Sale Id shift 50',9150159.18,0.00,0.00,0.00,0.00,'2022-05-17 21:17:13','',''),(692,'21','238',NULL,3,'Sale Id shift 50',72065.50,0.00,0.00,0.00,0.00,'2022-05-17 21:17:13','',''),(693,'21','238','6',3,'Sale Id shift 51',0.00,0.00,0.00,111.75,0.00,'2022-05-18 13:45:22','',''),(694,'21','238',NULL,3,'Sale Id shift 51',72637.50,0.00,0.00,0.00,0.00,'2022-05-18 13:45:22','',''),(695,'21','238','6',3,'Sale Id shift 52',0.00,0.00,0.00,90.25,0.00,'2022-05-18 13:57:38','',''),(696,'21','238',NULL,3,'Sale Id shift 52',58662.50,0.00,0.00,0.00,0.00,'2022-05-18 13:57:38','',''),(697,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,10770000.00,15000.00,0.00,0.00,'2022-05-18 15:57:04','',''),(698,'21','238',NULL,2,'Reception corrector for bridging 86',0.00,0.00,0.00,15000.00,0.00,'2022-05-18 16:17:41','',''),(699,'21','238','4',2,'Received from bridging 86',0.00,0.00,15000.00,0.00,0.00,'2022-05-18 16:17:41','',''),(700,'21','238','4',2,'Sale Id shift 53',0.00,0.00,0.00,4287.91,0.00,'2022-05-18 16:39:27','',''),(701,'21','238','5',2,'Sale Id shift 53',0.00,0.00,0.00,2492.48,0.00,'2022-05-18 16:39:27','',''),(702,'21','238','5',2,'Sale Id shift 53',0.00,0.00,0.00,1473.10,0.00,'2022-05-18 16:39:27','',''),(703,'21','238','6',3,'Sale Id shift 53',0.00,0.00,0.00,172.92,0.00,'2022-05-18 16:39:27','',''),(704,'21','238',NULL,2,'Sale Id shift 53',5926005.82,0.00,0.00,0.00,0.00,'2022-05-18 16:39:27','',''),(705,'21','238',NULL,3,'Sale Id shift 53',112398.00,0.00,0.00,0.00,0.00,'2022-05-18 16:39:27','',''),(706,'21','238','3',1,'Sale Id shift 54',0.00,0.00,0.00,1621.58,0.00,'2022-05-18 17:05:07','',''),(707,'21','238','4',2,'Sale Id shift 54',0.00,0.00,0.00,2288.98,0.00,'2022-05-18 17:05:07','',''),(708,'21','238','5',2,'Sale Id shift 54',0.00,0.00,0.00,3115.21,0.00,'2022-05-18 17:05:07','',''),(709,'21','238','5',2,'Sale Id shift 54',0.00,0.00,0.00,1441.11,0.00,'2022-05-18 17:05:07','',''),(710,'21','238','6',3,'Sale Id shift 54',0.00,0.00,0.00,111.73,0.00,'2022-05-18 17:05:07','',''),(711,'21','238','2',1,'Sale Id shift 54',0.00,0.00,0.00,4328.48,0.00,'2022-05-18 17:05:07','',''),(712,'21','238','2',1,'Sale Id shift 54',0.00,0.00,0.00,2679.33,0.00,'2022-05-18 17:05:07','',''),(713,'21','238','3',1,'Sale Id shift 54',0.00,0.00,0.00,7968.35,0.00,'2022-05-18 17:05:07','',''),(714,'21','238',NULL,1,'Sale Id shift 54',2738627.10,0.00,0.00,0.00,0.00,'2022-05-18 17:05:07','',''),(715,'21','238',NULL,2,'Sale Id shift 54',4914925.40,0.00,0.00,0.00,0.00,'2022-05-18 17:05:07','',''),(716,'21','238',NULL,3,'Sale Id shift 54',72624.50,0.00,0.00,0.00,0.00,'2022-05-18 17:05:07','',''),(717,'21','238','6',3,'Sale Id shift 55',0.00,0.00,0.00,116.94,0.00,'2022-05-18 17:16:05','',''),(718,'21','238',NULL,3,'Sale Id shift 55',76011.00,0.00,0.00,0.00,0.00,'2022-05-18 17:16:05','',''),(719,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2722500.00,16500.00,0.00,0.00,'2022-05-18 17:22:45','',''),(720,'21','238',NULL,1,'Reception corrector for bridging 88',0.00,0.00,0.00,2500.00,0.00,'2022-05-18 17:29:32','',''),(721,'21','238','3',1,'Received from bridging 88',0.00,0.00,2500.00,0.00,0.00,'2022-05-18 17:29:32','',''),(722,'21','238',NULL,1,'Reception corrector for bridging 87',0.00,0.00,0.00,14000.00,0.00,'2022-05-18 17:29:46','',''),(723,'21','238','2',1,'Received from bridging 87',0.00,0.00,14000.00,0.00,0.00,'2022-05-18 17:29:46','',''),(724,'21','238','3',1,'Sale Id shift 56',0.00,0.00,0.00,9069.96,0.00,'2022-05-18 17:58:53','',''),(725,'21','238','4',2,'Sale Id shift 56',0.00,0.00,0.00,1975.52,0.00,'2022-05-18 17:58:53','',''),(726,'21','238','5',2,'Sale Id shift 56',0.00,0.00,0.00,1934.83,0.00,'2022-05-18 17:58:53','',''),(727,'21','238','5',2,'Sale Id shift 56',0.00,0.00,0.00,833.14,0.00,'2022-05-18 17:58:53','',''),(728,'21','238','6',3,'Sale Id shift 56',0.00,0.00,0.00,177.89,0.00,'2022-05-18 17:58:53','',''),(729,'21','238','2',1,'Sale Id shift 56',0.00,0.00,0.00,10102.72,0.00,'2022-05-18 17:58:53','',''),(730,'21','238','2',1,'Sale Id shift 56',0.00,0.00,0.00,6317.29,0.00,'2022-05-18 17:58:53','',''),(731,'21','238','3',1,'Sale Id shift 56',0.00,0.00,0.00,10756.75,0.00,'2022-05-18 17:58:53','',''),(732,'21','238',NULL,1,'Sale Id shift 56',5980708.80,0.00,0.00,0.00,0.00,'2022-05-18 17:58:53','',''),(733,'21','238',NULL,2,'Sale Id shift 56',3405825.82,0.00,0.00,0.00,0.00,'2022-05-18 17:58:53','',''),(734,'21','238',NULL,3,'Sale Id shift 56',115628.50,0.00,0.00,0.00,0.00,'2022-05-18 17:58:53','',''),(735,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2475000.00,15000.00,0.00,0.00,'2022-05-18 18:01:26','',''),(736,'21','238',NULL,1,'Reception corrector for bridging 89',0.00,0.00,0.00,15000.00,0.00,'2022-05-18 18:05:22','',''),(737,'21','238','1',1,'Received from bridging 89',0.00,0.00,15000.00,0.00,0.00,'2022-05-18 18:05:22','',''),(738,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2640000.00,16000.00,0.00,0.00,'2022-05-19 11:31:34','',''),(739,'21','238',NULL,1,'Reception corrector for bridging 90',0.00,0.00,0.00,16000.00,0.00,'2022-05-19 11:35:13','',''),(740,'21','238','1',1,'Received from bridging 90',0.00,0.00,16000.00,0.00,0.00,'2022-05-19 11:35:13','',''),(741,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,10770000.00,15000.00,0.00,0.00,'2022-05-19 16:55:21','',''),(742,'21','238',NULL,2,'Reception corrector for bridging 92',0.00,0.00,0.00,7700.00,0.00,'2022-05-19 16:58:55','',''),(743,'21','238','5',2,'Received from bridging 92',0.00,0.00,7700.00,0.00,0.00,'2022-05-19 16:58:55','',''),(744,'21','238',NULL,2,'Reception corrector for bridging 91',0.00,0.00,0.00,7300.00,0.00,'2022-05-19 16:59:09','',''),(745,'21','238','4',2,'Received from bridging 91',0.00,0.00,7300.00,0.00,0.00,'2022-05-19 16:59:09','',''),(746,'21','238','1',1,'Sale Id shift 57',0.00,0.00,0.00,7397.54,0.00,'2022-05-20 09:15:59','',''),(747,'21','238','4',2,'Sale Id shift 57',0.00,0.00,0.00,6639.74,0.00,'2022-05-20 09:15:59','',''),(748,'21','238','5',2,'Sale Id shift 57',0.00,0.00,0.00,3108.17,0.00,'2022-05-20 09:15:59','',''),(749,'21','238','5',2,'Sale Id shift 57',0.00,0.00,0.00,734.75,0.00,'2022-05-20 09:15:59','',''),(750,'21','238','6',3,'Sale Id shift 57',0.00,0.00,0.00,118.63,0.00,'2022-05-20 09:15:59','',''),(751,'21','238','1',1,'Sale Id shift 57',0.00,0.00,0.00,7882.60,0.00,'2022-05-20 09:15:59','',''),(752,'21','238',NULL,1,'Sale Id shift 57',2521223.10,0.00,0.00,0.00,0.00,'2022-05-20 09:15:59','',''),(753,'21','238',NULL,2,'Sale Id shift 57',7526549.88,0.00,0.00,0.00,0.00,'2022-05-20 09:15:59','',''),(754,'21','238',NULL,3,'Sale Id shift 57',77109.50,0.00,0.00,0.00,0.00,'2022-05-20 09:15:59','',''),(755,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2475000.00,15000.00,0.00,0.00,'2022-05-20 09:26:34','',''),(756,'21','238',NULL,1,'Reception corrector for bridging 93',0.00,0.00,0.00,15000.00,0.00,'2022-05-20 09:27:52','',''),(757,'21','238','1',1,'Received from bridging 93',0.00,0.00,15000.00,0.00,0.00,'2022-05-20 09:27:52','',''),(758,'21','238','1',1,'Sale Id shift 58',0.00,0.00,0.00,7825.47,0.00,'2022-05-20 09:52:52','',''),(759,'21','238','4',2,'Sale Id shift 58',0.00,0.00,0.00,3477.56,0.00,'2022-05-20 09:52:52','',''),(760,'21','238','5',2,'Sale Id shift 58',0.00,0.00,0.00,3211.50,0.00,'2022-05-20 09:52:52','',''),(761,'21','238','5',2,'Sale Id shift 58',0.00,0.00,0.00,1682.14,0.00,'2022-05-20 09:52:52','',''),(762,'21','238','6',3,'Sale Id shift 58',0.00,0.00,0.00,158.11,0.00,'2022-05-20 09:52:52','',''),(763,'21','238','1',1,'Sale Id shift 58',0.00,0.00,0.00,8325.67,0.00,'2022-05-20 09:52:52','',''),(764,'21','238',NULL,1,'Sale Id shift 58',2664938.10,0.00,0.00,0.00,0.00,'2022-05-20 09:52:52','',''),(765,'21','238',NULL,2,'Sale Id shift 58',6010521.60,0.00,0.00,0.00,0.00,'2022-05-20 09:52:52','',''),(766,'21','238',NULL,3,'Sale Id shift 58',102771.50,0.00,0.00,0.00,0.00,'2022-05-20 09:52:52','',''),(767,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,10411000.00,14500.00,0.00,0.00,'2022-05-22 17:32:34','',''),(768,'21','238',NULL,2,'Reception corrector for bridging 95',0.00,0.00,0.00,7600.00,0.00,'2022-05-22 17:34:26','',''),(769,'21','238','5',2,'Received from bridging 95',0.00,0.00,7600.00,0.00,0.00,'2022-05-22 17:34:26','',''),(770,'21','238',NULL,2,'Reception corrector for bridging 94',0.00,0.00,0.00,6900.00,0.00,'2022-05-22 17:34:42','',''),(771,'21','238','4',2,'Received from bridging 94',0.00,0.00,6900.00,0.00,0.00,'2022-05-22 17:34:42','',''),(772,'21','238','1',1,'Sale Id shift 59',0.00,0.00,0.00,6973.64,0.00,'2022-05-22 18:06:25','',''),(773,'21','238','4',2,'Sale Id shift 59',0.00,0.00,0.00,2515.67,0.00,'2022-05-22 18:06:25','',''),(774,'21','238','5',2,'Sale Id shift 59',0.00,0.00,0.00,1766.20,0.00,'2022-05-22 18:06:25','',''),(775,'21','238','5',2,'Sale Id shift 59',0.00,0.00,0.00,967.25,0.00,'2022-05-22 18:06:25','',''),(776,'21','238','6',3,'Sale Id shift 59',0.00,0.00,0.00,139.13,0.00,'2022-05-22 18:06:25','',''),(777,'21','238','1',1,'Sale Id shift 59',0.00,0.00,0.00,8127.23,0.00,'2022-05-22 18:06:25','',''),(778,'21','238',NULL,1,'Sale Id shift 59',2491643.55,0.00,0.00,0.00,0.00,'2022-05-22 18:06:25','',''),(779,'21','238',NULL,2,'Sale Id shift 59',3768868.16,0.00,0.00,0.00,0.00,'2022-05-22 18:06:25','',''),(780,'21','238',NULL,3,'Sale Id shift 59',90434.50,0.00,0.00,0.00,0.00,'2022-05-22 18:06:25','',''),(781,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2640000.00,16000.00,0.00,0.00,'2022-05-22 18:10:21','',''),(782,'21','238',NULL,1,'Reception corrector for bridging 97',0.00,0.00,0.00,10000.00,0.00,'2022-05-22 18:12:07','',''),(783,'21','238','3',1,'Received from bridging 97',0.00,0.00,10000.00,0.00,0.00,'2022-05-22 18:12:07','',''),(784,'21','238',NULL,1,'Reception corrector for bridging 96',0.00,0.00,0.00,6000.00,0.00,'2022-05-22 18:12:22','',''),(785,'21','238','1',1,'Received from bridging 96',0.00,0.00,6000.00,0.00,0.00,'2022-05-22 18:12:22','',''),(786,'21','238','4',2,'Sale Id shift 60',0.00,0.00,0.00,4012.76,0.00,'2022-05-22 18:25:50','',''),(787,'21','238','5',2,'Sale Id shift 60',0.00,0.00,0.00,2357.93,0.00,'2022-05-22 18:25:50','',''),(788,'21','238','5',2,'Sale Id shift 60',0.00,0.00,0.00,425.13,0.00,'2022-05-22 18:25:50','',''),(789,'21','238','6',3,'Sale Id shift 60',0.00,0.00,0.00,165.70,0.00,'2022-05-22 18:25:50','',''),(790,'21','238',NULL,2,'Sale Id shift 60',4879398.76,0.00,0.00,0.00,0.00,'2022-05-22 18:25:50','',''),(791,'21','238',NULL,3,'Sale Id shift 60',107705.00,0.00,0.00,0.00,0.00,'2022-05-22 18:25:50','',''),(792,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,4950000.00,30000.00,0.00,0.00,'2022-05-24 08:14:56','',''),(793,'21','238',NULL,1,'Reception corrector for bridging 99',0.00,0.00,0.00,15000.00,0.00,'2022-05-24 08:16:47','',''),(794,'21','238','2',1,'Received from bridging 99',0.00,0.00,15000.00,0.00,0.00,'2022-05-24 08:16:47','',''),(795,'21','238',NULL,1,'Reception corrector for bridging 98',0.00,0.00,0.00,15000.00,0.00,'2022-05-24 08:17:05','',''),(796,'21','238','1',1,'Received from bridging 98',0.00,0.00,15000.00,0.00,0.00,'2022-05-24 08:17:05','',''),(797,'21','238','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,4337.74,0.00,'2022-05-25 14:30:05','',''),(798,'21','238','4',0,'Inventory adjustment from tank dipping to 4950',0.00,0.00,4950.00,0.00,0.00,'2022-05-25 14:30:05','',''),(799,'21','238','5',0,'Tank level zero out for dipping',0.00,0.00,0.00,4305.04,0.00,'2022-05-25 14:31:25','',''),(800,'21','238','5',0,'Inventory adjustment from tank dipping to 4398',0.00,0.00,4398.00,0.00,0.00,'2022-05-25 14:31:25','',''),(801,'21','238','4',2,'Sale Id shift 61',0.00,0.00,0.00,4899.36,0.00,'2022-05-25 15:03:37','',''),(802,'21','238','5',2,'Sale Id shift 61',0.00,0.00,0.00,3708.37,0.00,'2022-05-25 15:03:37','',''),(803,'21','238','5',2,'Sale Id shift 61',0.00,0.00,0.00,586.53,0.00,'2022-05-25 15:03:37','',''),(804,'21','238',NULL,2,'Sale Id shift 61',6601478.68,0.00,0.00,0.00,0.00,'2022-05-25 15:03:37','',''),(805,'21','238','1',1,'Sale Id shift 62',0.00,0.00,0.00,1571.85,0.00,'2022-05-25 15:45:28','',''),(806,'21','238','5',2,'Sale Id shift 62',0.00,0.00,0.00,40.64,0.00,'2022-05-25 15:45:28','',''),(807,'21','238','6',3,'Sale Id shift 62',0.00,0.00,0.00,228.97,0.00,'2022-05-25 15:45:28','',''),(808,'21','238','1',1,'Sale Id shift 62',0.00,0.00,0.00,4493.92,0.00,'2022-05-25 15:45:28','',''),(809,'21','238','2',1,'Sale Id shift 62',0.00,0.00,0.00,2719.52,0.00,'2022-05-25 15:45:28','',''),(810,'21','238','2',1,'Sale Id shift 62',0.00,0.00,0.00,7336.13,0.00,'2022-05-25 15:45:28','',''),(811,'21','238',NULL,2,'Sale Id shift 62',30805.12,0.00,0.00,0.00,0.00,'2022-05-25 15:45:28','',''),(812,'21','238',NULL,3,'Sale Id shift 62',148830.50,0.00,0.00,0.00,0.00,'2022-05-25 15:45:28','',''),(813,'21','238',NULL,1,'Sale Id shift 62',2660034.30,0.00,0.00,0.00,0.00,'2022-05-25 15:45:28','',''),(814,'21','238','6',3,'Sale Id shift 63',0.00,0.00,0.00,223.46,0.00,'2022-05-25 15:54:41','',''),(815,'21','238',NULL,3,'Sale Id shift 63',145249.00,0.00,0.00,0.00,0.00,'2022-05-25 15:54:41','',''),(816,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2475000.00,15000.00,0.00,0.00,'2022-05-25 16:12:22','',''),(817,'21','238',NULL,1,'Reception corrector for bridging 100',0.00,0.00,0.00,15000.00,0.00,'2022-05-25 16:17:09','',''),(818,'21','238','2',1,'Received from bridging 100',0.00,0.00,15000.00,0.00,0.00,'2022-05-25 16:17:09','',''),(819,'21','238','1',1,'Sale Id shift 64',0.00,0.00,0.00,211.41,0.00,'2022-05-25 16:41:07','',''),(820,'21','238','6',3,'Sale Id shift 64',0.00,0.00,0.00,146.23,0.00,'2022-05-25 16:41:07','',''),(821,'21','238','1',1,'Sale Id shift 64',0.00,0.00,0.00,7202.90,0.00,'2022-05-25 16:41:07','',''),(822,'21','238','2',1,'Sale Id shift 64',0.00,0.00,0.00,3304.89,0.00,'2022-05-25 16:41:07','',''),(823,'21','238','2',1,'Sale Id shift 64',0.00,0.00,0.00,11892.76,0.00,'2022-05-25 16:41:07','',''),(824,'21','238',NULL,3,'Sale Id shift 64',95049.50,0.00,0.00,0.00,0.00,'2022-05-25 16:41:07','',''),(825,'21','238',NULL,1,'Sale Id shift 64',3730973.40,0.00,0.00,0.00,0.00,'2022-05-25 16:41:07','',''),(826,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2970000.00,18000.00,0.00,0.00,'2022-05-30 10:39:05','',''),(827,'21','238',NULL,1,'Reception corrector for bridging 101',0.00,0.00,0.00,12600.00,0.00,'2022-05-30 10:43:20','',''),(828,'21','238','1',1,'Received from bridging 101',0.00,0.00,12600.00,0.00,0.00,'2022-05-30 10:43:20','',''),(829,'21','238',NULL,1,'Reception corrector for bridging 102',0.00,0.00,0.00,5400.00,0.00,'2022-05-30 10:43:32','',''),(830,'21','238','2',1,'Received from bridging 102',0.00,0.00,5400.00,0.00,0.00,'2022-05-30 10:43:32','',''),(831,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2475000.00,15000.00,0.00,0.00,'2022-05-30 10:56:01','',''),(832,'21','238',NULL,1,'Reception corrector for bridging 103',0.00,0.00,0.00,4000.00,0.00,'2022-05-30 10:59:45','',''),(833,'21','238','1',1,'Received from bridging 103',0.00,0.00,4000.00,0.00,0.00,'2022-05-30 10:59:45','',''),(834,'21','238',NULL,1,'Reception corrector for bridging 104',0.00,0.00,0.00,10000.00,0.00,'2022-05-30 10:59:59','',''),(835,'21','238','2',1,'Received from bridging 104',0.00,0.00,10000.00,0.00,0.00,'2022-05-30 10:59:59','',''),(836,'21','238',NULL,1,'Reception corrector for bridging 105',0.00,0.00,0.00,1000.00,0.00,'2022-05-30 11:00:10','',''),(837,'21','238','3',1,'Received from bridging 105',0.00,0.00,1000.00,0.00,0.00,'2022-05-30 11:00:10','',''),(838,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,10612000.00,14000.00,0.00,0.00,'2022-05-30 11:02:58','',''),(839,'21','238',NULL,2,'Reception corrector for bridging 106',0.00,0.00,0.00,11000.00,0.00,'2022-05-30 11:13:42','',''),(840,'21','238','4',2,'Received from bridging 106',0.00,0.00,11000.00,0.00,0.00,'2022-05-30 11:13:42','',''),(841,'21','238',NULL,2,'Reception corrector for bridging 107',0.00,0.00,0.00,3000.00,0.00,'2022-05-30 11:13:59','',''),(842,'21','238','5',2,'Received from bridging 107',0.00,0.00,3000.00,0.00,0.00,'2022-05-30 11:13:59','',''),(843,'21','238','1',1,'Sale Id shift 65',0.00,0.00,0.00,945.71,0.00,'2022-05-30 12:14:55','',''),(844,'21','238','4',2,'Sale Id shift 65',0.00,0.00,0.00,694.45,0.00,'2022-05-30 12:14:55','',''),(845,'21','238','5',2,'Sale Id shift 65',0.00,0.00,0.00,1105.44,0.00,'2022-05-30 12:14:55','',''),(846,'21','238','5',2,'Sale Id shift 65',0.00,0.00,0.00,571.31,0.00,'2022-05-30 12:14:55','',''),(847,'21','238','6',3,'Sale Id shift 65',0.00,0.00,0.00,90.23,0.00,'2022-05-30 12:14:55','',''),(848,'21','238','1',1,'Sale Id shift 65',0.00,0.00,0.00,6545.66,0.00,'2022-05-30 12:14:55','',''),(849,'21','238','2',1,'Sale Id shift 65',0.00,0.00,0.00,2103.94,0.00,'2022-05-30 12:14:55','',''),(850,'21','238','2',1,'Sale Id shift 65',0.00,0.00,0.00,12966.04,0.00,'2022-05-30 12:14:55','',''),(851,'21','238',NULL,1,'Sale Id shift 65',3722622.75,0.00,0.00,0.00,0.00,'2022-05-30 12:14:55','',''),(852,'21','238',NULL,2,'Sale Id shift 65',1797369.60,0.00,0.00,0.00,0.00,'2022-05-30 12:14:55','',''),(853,'21','238',NULL,3,'Sale Id shift 65',58649.50,0.00,0.00,0.00,0.00,'2022-05-30 12:14:55','',''),(854,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,11370000.00,15000.00,0.00,0.00,'2022-05-30 17:02:48','',''),(855,'21','238',NULL,2,'Reception corrector for bridging 108',0.00,0.00,0.00,5700.00,0.00,'2022-05-30 17:04:33','',''),(856,'21','238','4',2,'Received from bridging 108',0.00,0.00,5700.00,0.00,0.00,'2022-05-30 17:04:33','',''),(857,'21','238',NULL,2,'Reception corrector for bridging 109',0.00,0.00,0.00,9300.00,0.00,'2022-05-30 17:04:43','',''),(858,'21','238','5',2,'Received from bridging 109',0.00,0.00,9300.00,0.00,0.00,'2022-05-30 17:04:43','',''),(859,'21','238','4',2,'Sale Id shift 66',0.00,0.00,0.00,6458.17,0.00,'2022-05-30 17:31:13','',''),(860,'21','238','5',2,'Sale Id shift 66',0.00,0.00,0.00,3905.54,0.00,'2022-05-30 17:31:13','',''),(861,'21','238','5',2,'Sale Id shift 66',0.00,0.00,0.00,629.84,0.00,'2022-05-30 17:31:13','',''),(862,'21','238','6',3,'Sale Id shift 66',0.00,0.00,0.00,372.24,0.00,'2022-05-30 17:31:13','',''),(863,'21','238',NULL,2,'Sale Id shift 66',8333110.90,0.00,0.00,0.00,0.00,'2022-05-30 17:31:13','',''),(864,'21','238',NULL,3,'Sale Id shift 66',241956.00,0.00,0.00,0.00,0.00,'2022-05-30 17:31:13','',''),(865,'21','238','1',1,'Sale Id shift 67',0.00,0.00,0.00,2888.25,0.00,'2022-05-30 17:47:05','',''),(866,'21','238','4',2,'Sale Id shift 67',0.00,0.00,0.00,2834.25,0.00,'2022-05-30 17:47:05','',''),(867,'21','238','5',2,'Sale Id shift 67',0.00,0.00,0.00,1882.78,0.00,'2022-05-30 17:47:05','',''),(868,'21','238','5',2,'Sale Id shift 67',0.00,0.00,0.00,206.65,0.00,'2022-05-30 17:47:05','',''),(869,'21','238','6',3,'Sale Id shift 67',0.00,0.00,0.00,62.72,0.00,'2022-05-30 17:47:05','',''),(870,'21','238','1',1,'Sale Id shift 67',0.00,0.00,0.00,9721.08,0.00,'2022-05-30 17:47:05','',''),(871,'21','238','2',1,'Sale Id shift 67',0.00,0.00,0.00,5249.13,0.00,'2022-05-30 17:47:05','',''),(872,'21','238',NULL,2,'Sale Id shift 67',3732149.44,0.00,0.00,0.00,0.00,'2022-05-30 17:47:05','',''),(873,'21','238',NULL,3,'Sale Id shift 67',40768.00,0.00,0.00,0.00,0.00,'2022-05-30 17:47:05','',''),(874,'21','238',NULL,1,'Sale Id shift 67',2946645.90,0.00,0.00,0.00,0.00,'2022-05-30 17:47:05','',''),(875,'21','238','4',2,'Sale Id shift 68',0.00,0.00,0.00,5677.54,0.00,'2022-05-30 18:12:40','',''),(876,'21','238','5',2,'Sale Id shift 68',0.00,0.00,0.00,3735.62,0.00,'2022-05-30 18:12:40','',''),(877,'21','238','5',2,'Sale Id shift 68',0.00,0.00,0.00,158.59,0.00,'2022-05-30 18:12:40','',''),(878,'21','238','6',3,'Sale Id shift 68',0.00,0.00,0.00,149.65,0.00,'2022-05-30 18:12:40','',''),(879,'21','238',NULL,2,'Sale Id shift 68',7255386.50,0.00,0.00,0.00,0.00,'2022-05-30 18:12:40','',''),(880,'21','238',NULL,3,'Sale Id shift 68',97272.50,0.00,0.00,0.00,0.00,'2022-05-30 18:12:40','',''),(881,'21','238','1',1,'Sale Id shift 69',0.00,0.00,0.00,1534.99,0.00,'2022-05-30 18:24:11','',''),(882,'21','238','3',1,'Sale Id shift 69',0.00,0.00,0.00,4697.22,0.00,'2022-05-30 18:24:11','',''),(883,'21','238','4',2,'Sale Id shift 69',0.00,0.00,0.00,824.41,0.00,'2022-05-30 18:24:11','',''),(884,'21','238','6',3,'Sale Id shift 69',0.00,0.00,0.00,88.30,0.00,'2022-05-30 18:24:11','',''),(885,'21','238','1',1,'Sale Id shift 69',0.00,0.00,0.00,2376.30,0.00,'2022-05-30 18:24:11','',''),(886,'21','238','3',1,'Sale Id shift 69',0.00,0.00,0.00,6377.91,0.00,'2022-05-30 18:24:11','',''),(887,'21','238',NULL,1,'Sale Id shift 69',2472759.30,0.00,0.00,0.00,0.00,'2022-05-30 18:24:11','',''),(888,'21','238',NULL,2,'Sale Id shift 69',624902.78,0.00,0.00,0.00,0.00,'2022-05-30 18:24:11','',''),(889,'21','238',NULL,3,'Sale Id shift 69',57395.00,0.00,0.00,0.00,0.00,'2022-05-30 18:24:11','',''),(890,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,11370000.00,15000.00,0.00,0.00,'2022-05-31 10:55:00','',''),(891,'21','238',NULL,2,'Reception corrector for bridging 111',0.00,0.00,0.00,5600.00,0.00,'2022-05-31 10:56:40','',''),(892,'21','238','5',2,'Received from bridging 111',0.00,0.00,5600.00,0.00,0.00,'2022-05-31 10:56:40','',''),(893,'21','238',NULL,2,'Reception corrector for bridging 110',0.00,0.00,0.00,9400.00,0.00,'2022-05-31 10:56:53','',''),(894,'21','238','4',2,'Received from bridging 110',0.00,0.00,9400.00,0.00,0.00,'2022-05-31 10:56:53','',''),(895,'21','238','4',2,'Sale Id shift 70',0.00,0.00,0.00,2139.69,0.00,'2022-06-01 12:28:53','',''),(896,'21','238','5',2,'Sale Id shift 70',0.00,0.00,0.00,1960.00,0.00,'2022-06-01 12:28:53','',''),(897,'21','238','5',2,'Sale Id shift 70',0.00,0.00,0.00,272.53,0.00,'2022-06-01 12:28:53','',''),(898,'21','238','6',3,'Sale Id shift 70',0.00,0.00,0.00,136.27,0.00,'2022-06-01 12:28:53','',''),(899,'21','238',NULL,2,'Sale Id shift 70',3314142.76,0.00,0.00,0.00,0.00,'2022-06-01 12:28:53','',''),(900,'21','238',NULL,3,'Sale Id shift 70',88575.50,0.00,0.00,0.00,0.00,'2022-06-01 12:28:53','',''),(901,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2293500.00,13900.00,0.00,0.00,'2022-06-01 12:49:21','',''),(902,'21','238',NULL,1,'Reception corrector for bridging 112',0.00,0.00,0.00,6200.00,0.00,'2022-06-01 13:08:38','',''),(903,'21','238','1',1,'Received from bridging 112',0.00,0.00,6200.00,0.00,0.00,'2022-06-01 13:08:38','',''),(904,'21','238',NULL,1,'Reception corrector for bridging 113',0.00,0.00,0.00,3000.00,0.00,'2022-06-01 13:09:00','',''),(905,'21','238','2',1,'Received from bridging 113',0.00,0.00,3000.00,0.00,0.00,'2022-06-01 13:09:00','',''),(906,'21','238',NULL,1,'Reception corrector for bridging 114',0.00,0.00,0.00,4700.00,0.00,'2022-06-01 13:09:16','',''),(907,'21','238','3',1,'Received from bridging 114',0.00,0.00,4700.00,0.00,0.00,'2022-06-01 13:09:16','',''),(908,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,25772000.00,34000.00,0.00,0.00,'2022-06-01 13:48:08','',''),(909,'21','238',NULL,2,'Reception corrector for bridging 115',0.00,0.00,0.00,17000.00,0.00,'2022-06-01 14:51:47','',''),(910,'21','238','4',2,'Received from bridging 115',0.00,0.00,17000.00,0.00,0.00,'2022-06-01 14:51:47','',''),(911,'21','238',NULL,2,'Reception corrector for bridging 116',0.00,0.00,0.00,17000.00,0.00,'2022-06-01 14:52:41','',''),(912,'21','238','5',2,'Received from bridging 116',0.00,0.00,17000.00,0.00,0.00,'2022-06-01 14:52:41','',''),(913,'21','238','1',1,'Sale Id shift 71',0.00,0.00,0.00,1894.39,0.00,'2022-06-01 15:34:00','',''),(914,'21','238','4',2,'Sale Id shift 71',0.00,0.00,0.00,6017.18,0.00,'2022-06-01 15:34:00','',''),(915,'21','238','5',2,'Sale Id shift 71',0.00,0.00,0.00,3663.34,0.00,'2022-06-01 15:34:00','',''),(916,'21','238','5',2,'Sale Id shift 71',0.00,0.00,0.00,101.21,0.00,'2022-06-01 15:34:00','',''),(917,'21','238','6',3,'Sale Id shift 71',0.00,0.00,0.00,101.83,0.00,'2022-06-01 15:34:00','',''),(918,'21','238','1',1,'Sale Id shift 71',0.00,0.00,0.00,2709.32,0.00,'2022-06-01 15:34:00','',''),(919,'21','238','3',1,'Sale Id shift 71',0.00,0.00,0.00,3111.63,0.00,'2022-06-01 15:34:00','',''),(920,'21','238',NULL,1,'Sale Id shift 71',1273031.10,0.00,0.00,0.00,0.00,'2022-06-01 15:34:00','',''),(921,'21','238',NULL,2,'Sale Id shift 71',7414551.34,0.00,0.00,0.00,0.00,'2022-06-01 15:34:00','',''),(922,'21','238',NULL,3,'Sale Id shift 71',66189.50,0.00,0.00,0.00,0.00,'2022-06-01 15:34:00','',''),(923,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2805000.00,17000.00,0.00,0.00,'2022-06-02 11:58:52','',''),(924,'21','238',NULL,1,'Reception corrector for bridging 117',0.00,0.00,0.00,7500.00,0.00,'2022-06-02 12:04:12','',''),(925,'21','238','1',1,'Received from bridging 117',0.00,0.00,7500.00,0.00,0.00,'2022-06-02 12:04:12','',''),(926,'21','238',NULL,1,'Reception corrector for bridging 118',0.00,0.00,0.00,9500.00,0.00,'2022-06-02 12:04:23','',''),(927,'21','238','3',1,'Received from bridging 118',0.00,0.00,9500.00,0.00,0.00,'2022-06-02 12:04:23','',''),(928,'21','238','1',1,'Sale Id shift 72',0.00,0.00,0.00,1511.86,0.00,'2022-06-02 12:53:42','',''),(929,'21','238','3',1,'Sale Id shift 72',0.00,0.00,0.00,1217.96,0.00,'2022-06-02 12:53:42','',''),(930,'21','238','4',2,'Sale Id shift 72',0.00,0.00,0.00,3233.43,0.00,'2022-06-02 12:53:42','',''),(931,'21','238','5',2,'Sale Id shift 72',0.00,0.00,0.00,2431.30,0.00,'2022-06-02 12:53:42','',''),(932,'21','238','5',2,'Sale Id shift 72',0.00,0.00,0.00,182.65,0.00,'2022-06-02 12:53:42','',''),(933,'21','238','6',3,'Sale Id shift 72',0.00,0.00,0.00,69.13,0.00,'2022-06-02 12:53:42','',''),(934,'21','238','1',1,'Sale Id shift 72',0.00,0.00,0.00,3736.41,0.00,'2022-06-02 12:53:42','',''),(935,'21','238','3',1,'Sale Id shift 72',0.00,0.00,0.00,5321.56,0.00,'2022-06-02 12:53:42','',''),(936,'21','238',NULL,2,'Sale Id shift 72',4432314.04,0.00,0.00,0.00,0.00,'2022-06-02 12:53:42','',''),(937,'21','238',NULL,3,'Sale Id shift 72',44934.50,0.00,0.00,0.00,0.00,'2022-06-02 12:53:42','',''),(938,'21','238',NULL,1,'Sale Id shift 72',1944985.35,0.00,0.00,0.00,0.00,'2022-06-02 12:53:42','',''),(939,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2475000.00,15000.00,0.00,0.00,'2022-06-06 14:04:41','',''),(940,'21','238',NULL,1,'Reception corrector for bridging 119',0.00,0.00,0.00,6850.00,0.00,'2022-06-06 14:09:37','',''),(941,'21','238','1',1,'Received from bridging 119',0.00,0.00,6850.00,0.00,0.00,'2022-06-06 14:09:37','',''),(942,'21','238',NULL,1,'Reception corrector for bridging 120',0.00,0.00,0.00,8150.00,0.00,'2022-06-06 14:09:49','',''),(943,'21','238','2',1,'Received from bridging 120',0.00,0.00,8150.00,0.00,0.00,'2022-06-06 14:09:49','',''),(944,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,11370000.00,15000.00,0.00,0.00,'2022-06-06 14:50:55','',''),(945,'21','238',NULL,2,'Reception corrector for bridging 121',0.00,0.00,0.00,15000.00,0.00,'2022-06-06 14:58:32','',''),(946,'21','238','4',2,'Received from bridging 121',0.00,0.00,15000.00,0.00,0.00,'2022-06-06 14:58:32','',''),(947,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2475000.00,15000.00,0.00,0.00,'2022-06-06 15:27:59','',''),(948,'21','238',NULL,1,'Reception corrector for bridging 122',0.00,0.00,0.00,5000.00,0.00,'2022-06-06 15:34:02','',''),(949,'21','238','1',1,'Received from bridging 122',0.00,0.00,5000.00,0.00,0.00,'2022-06-06 15:34:02','',''),(950,'21','238',NULL,1,'Reception corrector for bridging 123',0.00,0.00,0.00,6000.00,0.00,'2022-06-06 15:34:15','',''),(951,'21','238','2',1,'Received from bridging 123',0.00,0.00,6000.00,0.00,0.00,'2022-06-06 15:34:15','',''),(952,'21','238',NULL,1,'Reception corrector for bridging 124',0.00,0.00,0.00,4000.00,0.00,'2022-06-06 15:34:28','',''),(953,'21','238','3',1,'Received from bridging 124',0.00,0.00,4000.00,0.00,0.00,'2022-06-06 15:34:28','',''),(954,'21','238','1',1,'Sale Id shift 73',0.00,0.00,0.00,228.65,0.00,'2022-06-06 16:19:25','',''),(955,'21','238','3',1,'Sale Id shift 73',0.00,0.00,0.00,863.08,0.00,'2022-06-06 16:19:25','',''),(956,'21','238','4',2,'Sale Id shift 73',0.00,0.00,0.00,6730.73,0.00,'2022-06-06 16:19:25','',''),(957,'21','238','5',2,'Sale Id shift 73',0.00,0.00,0.00,6462.04,0.00,'2022-06-06 16:19:25','',''),(958,'21','238','5',2,'Sale Id shift 73',0.00,0.00,0.00,717.41,0.00,'2022-06-06 16:19:25','',''),(959,'21','238','6',3,'Sale Id shift 73',0.00,0.00,0.00,197.52,0.00,'2022-06-06 16:19:25','',''),(960,'21','238','1',1,'Sale Id shift 73',0.00,0.00,0.00,4728.70,0.00,'2022-06-06 16:19:25','',''),(961,'21','238','3',1,'Sale Id shift 73',0.00,0.00,0.00,5474.77,0.00,'2022-06-06 16:19:25','',''),(962,'21','238',NULL,1,'Sale Id shift 73',1863708.00,0.00,0.00,0.00,0.00,'2022-06-06 16:19:25','',''),(963,'21','238',NULL,2,'Sale Id shift 73',10543916.44,0.00,0.00,0.00,0.00,'2022-06-06 16:19:25','',''),(964,'21','238',NULL,3,'Sale Id shift 73',128388.00,0.00,0.00,0.00,0.00,'2022-06-06 16:19:25','',''),(965,'21','238','4',2,'Sale Id shift 74',0.00,0.00,0.00,3784.55,0.00,'2022-06-06 16:45:49','',''),(966,'21','238','5',2,'Sale Id shift 74',0.00,0.00,0.00,3098.15,0.00,'2022-06-06 16:45:49','',''),(967,'21','238','5',2,'Sale Id shift 74',0.00,0.00,0.00,104.89,0.00,'2022-06-06 16:45:49','',''),(968,'21','238','6',3,'Sale Id shift 74',0.00,0.00,0.00,89.73,0.00,'2022-06-06 16:45:49','',''),(969,'21','238',NULL,2,'Sale Id shift 74',5296593.22,0.00,0.00,0.00,0.00,'2022-06-06 16:45:49','',''),(970,'21','238',NULL,3,'Sale Id shift 74',58324.50,0.00,0.00,0.00,0.00,'2022-06-06 16:45:49','',''),(971,'21','238','4',2,'Sale Id shift 75',0.00,0.00,0.00,4610.68,0.00,'2022-06-06 16:59:58','',''),(972,'21','238','5',2,'Sale Id shift 75',0.00,0.00,0.00,1860.76,0.00,'2022-06-06 16:59:58','',''),(973,'21','238','5',2,'Sale Id shift 75',0.00,0.00,0.00,416.72,0.00,'2022-06-06 16:59:58','',''),(974,'21','238',NULL,2,'Sale Id shift 75',5221225.28,0.00,0.00,0.00,0.00,'2022-06-06 16:59:58','',''),(975,'21','238','1',1,'Sale Id shift 76',0.00,0.00,0.00,496.93,0.00,'2022-06-06 17:52:25','',''),(976,'21','238','4',2,'Sale Id shift 76',0.00,0.00,0.00,209.94,0.00,'2022-06-06 17:52:25','',''),(977,'21','238','5',2,'Sale Id shift 76',0.00,0.00,0.00,760.96,0.00,'2022-06-06 17:52:25','',''),(978,'21','238','5',2,'Sale Id shift 76',0.00,0.00,0.00,337.69,0.00,'2022-06-06 17:52:25','',''),(979,'21','238','6',3,'Sale Id shift 76',0.00,0.00,0.00,91.94,0.00,'2022-06-06 17:52:25','',''),(980,'21','238','1',1,'Sale Id shift 76',0.00,0.00,0.00,6285.87,0.00,'2022-06-06 17:52:25','',''),(981,'21','238','2',1,'Sale Id shift 76',0.00,0.00,0.00,8230.65,0.00,'2022-06-06 17:52:25','',''),(982,'21','238',NULL,1,'Sale Id shift 76',2477219.25,0.00,0.00,0.00,0.00,'2022-06-06 17:52:25','',''),(983,'21','238',NULL,2,'Sale Id shift 76',1018083.02,0.00,0.00,0.00,0.00,'2022-06-06 17:52:25','',''),(984,'21','238',NULL,3,'Sale Id shift 76',59761.00,0.00,0.00,0.00,0.00,'2022-06-06 17:52:25','',''),(985,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,4950000.00,30000.00,0.00,0.00,'2022-06-07 13:05:25','',''),(986,'21','238',NULL,1,'Reception corrector for bridging 125',0.00,0.00,0.00,15000.00,0.00,'2022-06-07 13:07:56','',''),(987,'21','238','1',1,'Received from bridging 125',0.00,0.00,15000.00,0.00,0.00,'2022-06-07 13:07:56','',''),(988,'21','238',NULL,1,'Reception corrector for bridging 126',0.00,0.00,0.00,15000.00,0.00,'2022-06-07 13:08:10','',''),(989,'21','238','2',1,'Received from bridging 126',0.00,0.00,15000.00,0.00,0.00,'2022-06-07 13:08:10','',''),(990,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,11670000.00,15000.00,0.00,0.00,'2022-06-07 13:50:33','',''),(991,'21','238',NULL,2,'Reception corrector for bridging 127',0.00,0.00,0.00,15000.00,0.00,'2022-06-07 13:52:58','',''),(992,'21','238','5',2,'Received from bridging 127',0.00,0.00,15000.00,0.00,0.00,'2022-06-07 13:52:58','',''),(993,'21','238','4',2,'Sale Id shift 77',0.00,0.00,0.00,6124.50,0.00,'2022-06-07 14:58:58','',''),(994,'21','238','5',2,'Sale Id shift 77',0.00,0.00,0.00,265.56,0.00,'2022-06-07 14:58:58','',''),(995,'21','238','5',2,'Sale Id shift 77',0.00,0.00,0.00,507.22,0.00,'2022-06-07 14:58:58','',''),(996,'21','238','6',3,'Sale Id shift 77',0.00,0.00,0.00,219.79,0.00,'2022-06-07 14:58:58','',''),(997,'21','238','1',1,'Sale Id shift 77',0.00,0.00,0.00,4861.40,0.00,'2022-06-07 14:58:58','',''),(998,'21','238','2',1,'Sale Id shift 77',0.00,0.00,0.00,6797.75,0.00,'2022-06-07 14:58:58','',''),(999,'21','238',NULL,2,'Sale Id shift 77',5366083.84,0.00,0.00,0.00,0.00,'2022-06-07 14:58:58','',''),(1000,'21','238',NULL,3,'Sale Id shift 77',142863.50,0.00,0.00,0.00,0.00,'2022-06-07 14:58:58','',''),(1001,'21','238',NULL,1,'Sale Id shift 77',1923759.75,0.00,0.00,0.00,0.00,'2022-06-07 14:58:58','',''),(1002,'21','238','1',1,'Sale Id shift 78',0.00,0.00,0.00,755.49,0.00,'2022-06-07 16:04:17','',''),(1003,'21','238','4',2,'Sale Id shift 78',0.00,0.00,0.00,7152.51,0.00,'2022-06-07 16:04:17','',''),(1004,'21','238','5',2,'Sale Id shift 78',0.00,0.00,0.00,4023.85,0.00,'2022-06-07 16:04:17','',''),(1005,'21','238','5',2,'Sale Id shift 78',0.00,0.00,0.00,266.63,0.00,'2022-06-07 16:04:17','',''),(1006,'21','238','6',3,'Sale Id shift 78',0.00,0.00,0.00,114.48,0.00,'2022-06-07 16:04:17','',''),(1007,'21','238','1',1,'Sale Id shift 78',0.00,0.00,0.00,1932.59,0.00,'2022-06-07 16:04:17','',''),(1008,'21','238','2',1,'Sale Id shift 78',0.00,0.00,0.00,721.15,0.00,'2022-06-07 16:04:17','',''),(1009,'21','238',NULL,1,'Sale Id shift 78',562522.95,0.00,0.00,0.00,0.00,'2022-06-07 16:04:17','',''),(1010,'21','238',NULL,2,'Sale Id shift 78',8902646.22,0.00,0.00,0.00,0.00,'2022-06-07 16:04:17','',''),(1011,'21','238',NULL,3,'Sale Id shift 78',74412.00,0.00,0.00,0.00,0.00,'2022-06-07 16:04:17','',''),(1012,'21','238','1',1,'Sale Id shift 79',0.00,0.00,0.00,1152.42,0.00,'2022-06-09 15:01:00','',''),(1013,'21','238','5',2,'Sale Id shift 79',0.00,0.00,0.00,8347.92,0.00,'2022-06-09 15:01:00','',''),(1014,'21','238','5',2,'Sale Id shift 79',0.00,0.00,0.00,1343.93,0.00,'2022-06-09 15:01:00','',''),(1015,'21','238','6',3,'Sale Id shift 79',0.00,0.00,0.00,76.81,0.00,'2022-06-09 15:01:00','',''),(1016,'21','238','1',1,'Sale Id shift 79',0.00,0.00,0.00,9597.07,0.00,'2022-06-09 15:01:00','',''),(1017,'21','238','2',1,'Sale Id shift 79',0.00,0.00,0.00,502.38,0.00,'2022-06-09 15:01:00','',''),(1018,'21','238','2',1,'Sale Id shift 79',0.00,0.00,0.00,16185.93,0.00,'2022-06-09 15:01:00','',''),(1019,'21','238',NULL,1,'Sale Id shift 79',4527237.00,0.00,0.00,0.00,0.00,'2022-06-09 15:01:00','',''),(1020,'21','238',NULL,2,'Sale Id shift 79',7540259.30,0.00,0.00,0.00,0.00,'2022-06-09 15:01:00','',''),(1021,'21','238',NULL,3,'Sale Id shift 79',49926.50,0.00,0.00,0.00,0.00,'2022-06-09 15:01:00','',''),(1022,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5610000.00,34000.00,0.00,0.00,'2022-06-09 15:05:52','',''),(1023,'21','238',NULL,1,'Reception corrector for bridging 128',0.00,0.00,0.00,17000.00,0.00,'2022-06-09 15:07:28','',''),(1024,'21','238','1',1,'Received from bridging 128',0.00,0.00,17000.00,0.00,0.00,'2022-06-09 15:07:28','',''),(1025,'21','238',NULL,1,'Reception corrector for bridging 129',0.00,0.00,0.00,17000.00,0.00,'2022-06-09 15:07:39','',''),(1026,'21','238','2',1,'Received from bridging 129',0.00,0.00,17000.00,0.00,0.00,'2022-06-09 15:07:39','',''),(1027,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2475000.00,15000.00,0.00,0.00,'2022-06-14 13:54:20','',''),(1028,'21','238',NULL,1,'Reception corrector for bridging 130',0.00,0.00,0.00,15000.00,0.00,'2022-06-14 13:56:18','',''),(1029,'21','238','3',1,'Received from bridging 130',0.00,0.00,15000.00,0.00,0.00,'2022-06-14 13:56:18','',''),(1030,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2970000.00,18000.00,0.00,0.00,'2022-06-14 13:59:33','',''),(1031,'21','238',NULL,1,'Reception corrector for bridging 131',0.00,0.00,0.00,3200.00,0.00,'2022-06-14 14:05:51','',''),(1032,'21','238','1',1,'Received from bridging 131',0.00,0.00,3200.00,0.00,0.00,'2022-06-14 14:05:51','',''),(1033,'21','238',NULL,1,'Reception corrector for bridging 132',0.00,0.00,0.00,14800.00,0.00,'2022-06-14 14:06:05','',''),(1034,'21','238','2',1,'Received from bridging 132',0.00,0.00,14800.00,0.00,0.00,'2022-06-14 14:06:05','',''),(1035,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5445000.00,33000.00,0.00,0.00,'2022-06-14 14:44:39','',''),(1036,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,18438600.00,23700.00,0.00,0.00,'2022-06-14 14:53:25','',''),(1037,'21','238',NULL,2,'Reception corrector for bridging 135',0.00,0.00,0.00,23700.00,0.00,'2022-06-14 14:54:52','',''),(1038,'21','238','4',2,'Received from bridging 135',0.00,0.00,23700.00,0.00,0.00,'2022-06-14 14:54:52','',''),(1039,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,11670000.00,15000.00,0.00,0.00,'2022-06-14 14:56:20','',''),(1040,'21','238',NULL,2,'Reception corrector for bridging 136',0.00,0.00,0.00,15000.00,0.00,'2022-06-14 14:57:51','',''),(1041,'21','238','5',2,'Received from bridging 136',0.00,0.00,15000.00,0.00,0.00,'2022-06-14 14:57:51','',''),(1042,'21','238','4',2,'Sale Id shift 80',0.00,0.00,0.00,1798.76,0.00,'2022-06-14 15:38:02','',''),(1043,'21','238','5',2,'Sale Id shift 80',0.00,0.00,0.00,1050.80,0.00,'2022-06-14 15:38:02','',''),(1044,'21','238','5',2,'Sale Id shift 80',0.00,0.00,0.00,3.51,0.00,'2022-06-14 15:38:02','',''),(1045,'21','238','6',3,'Sale Id shift 80',0.00,0.00,0.00,38.24,0.00,'2022-06-14 15:38:02','',''),(1046,'21','238',NULL,2,'Sale Id shift 80',2219688.46,0.00,0.00,0.00,0.00,'2022-06-14 15:38:02','',''),(1047,'21','238',NULL,3,'Sale Id shift 80',24856.00,0.00,0.00,0.00,0.00,'2022-06-14 15:38:02','',''),(1048,'21','238','1',1,'Sale Id shift 81',0.00,0.00,0.00,4695.84,0.00,'2022-06-14 16:03:46','',''),(1049,'21','238','4',2,'Sale Id shift 81',0.00,0.00,0.00,1447.14,0.00,'2022-06-14 16:03:46','',''),(1050,'21','238','6',3,'Sale Id shift 81',0.00,0.00,0.00,54.61,0.00,'2022-06-14 16:03:46','',''),(1051,'21','238','1',1,'Sale Id shift 81',0.00,0.00,0.00,9199.82,0.00,'2022-06-14 16:03:46','',''),(1052,'21','238','2',1,'Sale Id shift 81',0.00,0.00,0.00,14593.95,0.00,'2022-06-14 16:03:46','',''),(1053,'21','238',NULL,2,'Sale Id shift 81',1154817.72,0.00,0.00,0.00,0.00,'2022-06-14 16:03:46','',''),(1054,'21','238',NULL,3,'Sale Id shift 81',38227.00,0.00,0.00,0.00,0.00,'2022-06-14 16:03:46','',''),(1055,'21','238',NULL,1,'Sale Id shift 81',4700785.65,0.00,0.00,0.00,0.00,'2022-06-14 16:03:46','',''),(1056,'21','238',NULL,1,'Reception corrector for bridging 133',0.00,0.00,0.00,16000.00,0.00,'2022-06-14 16:46:17','',''),(1057,'21','238','1',1,'Received from bridging 133',0.00,0.00,16000.00,0.00,0.00,'2022-06-14 16:46:17','',''),(1058,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2475000.00,15000.00,0.00,0.00,'2022-06-15 15:18:19','',''),(1059,'21','238',NULL,1,'Reception corrector for bridging 139',0.00,0.00,0.00,2300.00,0.00,'2022-06-15 15:20:17','',''),(1060,'21','238','3',1,'Received from bridging 139',0.00,0.00,2300.00,0.00,0.00,'2022-06-15 15:20:17','',''),(1061,'21','238',NULL,1,'Reception corrector for bridging 138',0.00,0.00,0.00,6200.00,0.00,'2022-06-15 15:20:31','',''),(1062,'21','238','2',1,'Received from bridging 138',0.00,0.00,6200.00,0.00,0.00,'2022-06-15 15:20:31','',''),(1063,'21','238',NULL,1,'Reception corrector for bridging 137',0.00,0.00,0.00,6500.00,0.00,'2022-06-15 15:20:59','',''),(1064,'21','238','1',1,'Received from bridging 137',0.00,0.00,6500.00,0.00,0.00,'2022-06-15 15:20:59','',''),(1065,'21','238','1',1,'Sale Id shift 82',0.00,0.00,0.00,837.13,0.00,'2022-06-15 15:46:52','',''),(1066,'21','238','3',1,'Sale Id shift 82',0.00,0.00,0.00,1114.48,0.00,'2022-06-15 15:46:52','',''),(1067,'21','238','4',2,'Sale Id shift 82',0.00,0.00,0.00,10860.12,0.00,'2022-06-15 15:46:52','',''),(1068,'21','238','6',3,'Sale Id shift 82',0.00,0.00,0.00,130.26,0.00,'2022-06-15 15:46:52','',''),(1069,'21','238','1',1,'Sale Id shift 82',0.00,0.00,0.00,6693.98,0.00,'2022-06-15 15:46:52','',''),(1070,'21','238','2',1,'Sale Id shift 82',0.00,0.00,0.00,4673.22,0.00,'2022-06-15 15:46:52','',''),(1071,'21','238','2',1,'Sale Id shift 82',0.00,0.00,0.00,13805.84,0.00,'2022-06-15 15:46:52','',''),(1072,'21','238','3',1,'Sale Id shift 82',0.00,0.00,0.00,267.89,0.00,'2022-06-15 15:46:52','',''),(1073,'21','238',NULL,1,'Sale Id shift 82',4519769.10,0.00,0.00,0.00,0.00,'2022-06-15 15:46:52','',''),(1074,'21','238',NULL,2,'Sale Id shift 82',8666375.76,0.00,0.00,0.00,0.00,'2022-06-15 15:46:52','',''),(1075,'21','238',NULL,3,'Sale Id shift 82',91182.00,0.00,0.00,0.00,0.00,'2022-06-15 15:46:52','',''),(1076,'21','238',NULL,1,'Reception corrector for bridging 134',0.00,0.00,0.00,17000.00,0.00,'2022-06-15 15:47:14','',''),(1077,'21','238','2',1,'Received from bridging 134',0.00,0.00,17000.00,0.00,0.00,'2022-06-15 15:47:14','',''),(1078,'21','238','3',1,'Sale Id shift 83',0.00,0.00,0.00,6601.03,0.00,'2022-06-15 16:11:29','',''),(1079,'21','238','4',2,'Sale Id shift 83',0.00,0.00,0.00,2880.70,0.00,'2022-06-15 16:11:29','',''),(1080,'21','238','6',3,'Sale Id shift 83',0.00,0.00,0.00,53.08,0.00,'2022-06-15 16:11:29','',''),(1081,'21','238','3',1,'Sale Id shift 83',0.00,0.00,0.00,6981.01,0.00,'2022-06-15 16:11:29','',''),(1082,'21','238',NULL,2,'Sale Id shift 83',2298798.60,0.00,0.00,0.00,0.00,'2022-06-15 16:11:29','',''),(1083,'21','238',NULL,3,'Sale Id shift 83',37156.00,0.00,0.00,0.00,0.00,'2022-06-15 16:11:29','',''),(1084,'21','238',NULL,1,'Sale Id shift 83',2241036.60,0.00,0.00,0.00,0.00,'2022-06-15 16:11:29','',''),(1085,'21','238','4',2,'Sale Id shift 84',0.00,0.00,0.00,1145.75,0.00,'2022-06-15 16:22:32','',''),(1086,'21','238','5',2,'Sale Id shift 84',0.00,0.00,0.00,1956.89,0.00,'2022-06-15 16:22:32','',''),(1087,'21','238','5',2,'Sale Id shift 84',0.00,0.00,0.00,79.69,0.00,'2022-06-15 16:22:32','',''),(1088,'21','238',NULL,2,'Sale Id shift 84',2539499.34,0.00,0.00,0.00,0.00,'2022-06-15 16:22:32','',''),(1089,'21','238','4',2,'Sale Id shift 85',0.00,0.00,0.00,1022.00,0.00,'2022-06-15 16:32:13','',''),(1090,'21','238','6',3,'Sale Id shift 85',0.00,0.00,0.00,89.30,0.00,'2022-06-15 16:32:13','',''),(1091,'21','238',NULL,2,'Sale Id shift 85',835996.00,0.00,0.00,0.00,0.00,'2022-06-15 16:32:13','',''),(1092,'21','238',NULL,3,'Sale Id shift 85',62510.00,0.00,0.00,0.00,0.00,'2022-06-15 16:32:13','',''),(1093,'21','238','4',2,'Sale Id shift 86',0.00,0.00,0.00,3689.20,0.00,'2022-06-15 16:43:47','',''),(1094,'21','238','5',2,'Sale Id shift 86',0.00,0.00,0.00,3068.04,0.00,'2022-06-15 16:43:47','',''),(1095,'21','238','5',2,'Sale Id shift 86',0.00,0.00,0.00,461.83,0.00,'2022-06-15 16:43:47','',''),(1096,'21','238','6',3,'Sale Id shift 86',0.00,0.00,0.00,186.79,0.00,'2022-06-15 16:43:47','',''),(1097,'21','238',NULL,2,'Sale Id shift 86',5905199.26,0.00,0.00,0.00,0.00,'2022-06-15 16:43:47','',''),(1098,'21','238',NULL,3,'Sale Id shift 86',130753.00,0.00,0.00,0.00,0.00,'2022-06-15 16:43:47','',''),(1099,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,12310900.00,15050.00,0.00,0.00,'2022-06-17 14:19:31','',''),(1100,'21','238',NULL,2,'Reception corrector for bridging 140',0.00,0.00,0.00,15050.00,0.00,'2022-06-17 14:21:44','',''),(1101,'21','238','4',2,'Received from bridging 140',0.00,0.00,15050.00,0.00,0.00,'2022-06-17 14:21:44','',''),(1102,'21','238','4',2,'Sale Id shift 88',0.00,0.00,0.00,4241.37,0.00,'2022-06-17 15:31:20','',''),(1103,'21','238','5',2,'Sale Id shift 88',0.00,0.00,0.00,2437.47,0.00,'2022-06-17 15:31:20','',''),(1104,'21','238','5',2,'Sale Id shift 88',0.00,0.00,0.00,307.94,0.00,'2022-06-17 15:31:20','',''),(1105,'21','238','6',3,'Sale Id shift 88',0.00,0.00,0.00,23.65,0.00,'2022-06-17 15:31:20','',''),(1106,'21','238','2',1,'Sale Id shift 88',0.00,0.00,0.00,1299.57,0.00,'2022-06-17 15:31:20','',''),(1107,'21','238',NULL,1,'Sale Id shift 88',214429.05,0.00,0.00,0.00,0.00,'2022-06-17 15:31:20','',''),(1108,'21','238',NULL,2,'Sale Id shift 88',5715186.04,0.00,0.00,0.00,0.00,'2022-06-17 15:31:20','',''),(1109,'21','238',NULL,3,'Sale Id shift 88',16555.00,0.00,0.00,0.00,0.00,'2022-06-17 15:31:20','',''),(1110,'21','238','6',3,'Sale Id shift 90',0.00,0.00,0.00,82.37,0.00,'2022-06-17 15:49:14','',''),(1111,'21','238',NULL,3,'Sale Id shift 90',57659.00,0.00,0.00,0.00,0.00,'2022-06-17 15:49:14','',''),(1112,'21','238','1',1,'Sale Id shift 91',0.00,0.00,0.00,3043.84,0.00,'2022-06-17 16:31:55','',''),(1113,'21','238','4',2,'Sale Id shift 91',0.00,0.00,0.00,5824.64,0.00,'2022-06-17 16:31:55','',''),(1114,'21','238','5',2,'Sale Id shift 91',0.00,0.00,0.00,2432.19,0.00,'2022-06-17 16:31:55','',''),(1115,'21','238','5',2,'Sale Id shift 91',0.00,0.00,0.00,924.84,0.00,'2022-06-17 16:31:55','',''),(1116,'21','238','6',3,'Sale Id shift 91',0.00,0.00,0.00,79.44,0.00,'2022-06-17 16:31:55','',''),(1117,'21','238','1',1,'Sale Id shift 91',0.00,0.00,0.00,12858.04,0.00,'2022-06-17 16:31:55','',''),(1118,'21','238','2',1,'Sale Id shift 91',0.00,0.00,0.00,1207.51,0.00,'2022-06-17 16:31:55','',''),(1119,'21','238','2',1,'Sale Id shift 91',0.00,0.00,0.00,14582.41,0.00,'2022-06-17 16:31:55','',''),(1120,'21','238',NULL,1,'Sale Id shift 91',5229147.00,0.00,0.00,0.00,0.00,'2022-06-17 16:31:55','',''),(1121,'21','238',NULL,2,'Sale Id shift 91',7510606.06,0.00,0.00,0.00,0.00,'2022-06-17 16:31:55','',''),(1122,'21','238',NULL,3,'Sale Id shift 91',59580.00,0.00,0.00,0.00,0.00,'2022-06-17 16:31:55','',''),(1123,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2475000.00,15000.00,0.00,0.00,'2022-06-21 14:20:52','',''),(1124,'21','238',NULL,1,'Reception corrector for bridging 141',0.00,0.00,0.00,1300.00,0.00,'2022-06-21 14:22:56','',''),(1125,'21','238','1',1,'Received from bridging 141',0.00,0.00,1300.00,0.00,0.00,'2022-06-21 14:22:56','',''),(1126,'21','238',NULL,1,'Reception corrector for bridging 142',0.00,0.00,0.00,10700.00,0.00,'2022-06-21 14:23:08','',''),(1127,'21','238','2',1,'Received from bridging 142',0.00,0.00,10700.00,0.00,0.00,'2022-06-21 14:23:08','',''),(1128,'21','238',NULL,1,'Reception corrector for bridging 143',0.00,0.00,0.00,3000.00,0.00,'2022-06-21 14:23:19','',''),(1129,'21','238','3',1,'Received from bridging 143',0.00,0.00,3000.00,0.00,0.00,'2022-06-21 14:23:19','',''),(1130,'21','238','1',1,'Sale Id shift 92',0.00,0.00,0.00,3272.35,0.00,'2022-06-21 14:44:19','',''),(1131,'21','238','3',1,'Sale Id shift 92',0.00,0.00,0.00,1943.56,0.00,'2022-06-21 14:44:19','',''),(1132,'21','238','4',2,'Sale Id shift 92',0.00,0.00,0.00,6818.43,0.00,'2022-06-21 14:44:19','',''),(1133,'21','238','6',3,'Sale Id shift 92',0.00,0.00,0.00,96.03,0.00,'2022-06-21 14:44:19','',''),(1134,'21','238','1',1,'Sale Id shift 92',0.00,0.00,0.00,4388.91,0.00,'2022-06-21 14:44:19','',''),(1135,'21','238',NULL,1,'Sale Id shift 92',1584795.30,0.00,0.00,0.00,0.00,'2022-06-21 14:44:19','',''),(1136,'21','238',NULL,2,'Sale Id shift 92',5577475.74,0.00,0.00,0.00,0.00,'2022-06-21 14:44:19','',''),(1137,'21','238',NULL,3,'Sale Id shift 92',72022.50,0.00,0.00,0.00,0.00,'2022-06-21 14:44:19','',''),(1138,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,12420000.00,15000.00,0.00,0.00,'2022-06-21 15:07:49','',''),(1139,'21','238',NULL,2,'Reception corrector for bridging 144',0.00,0.00,0.00,4000.00,0.00,'2022-06-21 15:11:09','',''),(1140,'21','238','4',2,'Received from bridging 144',0.00,0.00,4000.00,0.00,0.00,'2022-06-21 15:11:09','',''),(1141,'21','238',NULL,2,'Reception corrector for bridging 145',0.00,0.00,0.00,11000.00,0.00,'2022-06-21 15:11:24','',''),(1142,'21','238','5',2,'Received from bridging 145',0.00,0.00,11000.00,0.00,0.00,'2022-06-21 15:11:24','',''),(1143,'21','238','3',1,'Sale Id shift 93',0.00,0.00,0.00,287.29,0.00,'2022-06-21 15:24:50','',''),(1144,'21','238','4',2,'Sale Id shift 93',0.00,0.00,0.00,4633.30,0.00,'2022-06-21 15:24:50','',''),(1145,'21','238','6',3,'Sale Id shift 93',0.00,0.00,0.00,150.43,0.00,'2022-06-21 15:24:50','',''),(1146,'21','238','2',1,'Sale Id shift 93',0.00,0.00,0.00,4420.20,0.00,'2022-06-21 15:24:50','',''),(1147,'21','238',NULL,2,'Sale Id shift 93',3790039.40,0.00,0.00,0.00,0.00,'2022-06-21 15:24:50','',''),(1148,'21','238',NULL,3,'Sale Id shift 93',112822.50,0.00,0.00,0.00,0.00,'2022-06-21 15:24:50','',''),(1149,'21','238',NULL,1,'Sale Id shift 93',776735.85,0.00,0.00,0.00,0.00,'2022-06-21 15:24:50','',''),(1150,'21','238','6',3,'Sale Id shift 94',0.00,0.00,0.00,49.78,0.00,'2022-06-21 15:28:22','',''),(1151,'21','238',NULL,3,'Sale Id shift 94',37335.00,0.00,0.00,0.00,0.00,'2022-06-21 15:28:22','',''),(1152,'21','238','6',3,'Sale Id shift 95',0.00,0.00,0.00,103.34,0.00,'2022-06-21 15:31:38','',''),(1153,'21','238',NULL,3,'Sale Id shift 95',77505.00,0.00,0.00,0.00,0.00,'2022-06-21 15:31:38','',''),(1154,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,12420000.00,15000.00,0.00,0.00,'2022-06-21 15:39:27','',''),(1155,'21','238',NULL,2,'Reception corrector for bridging 146',0.00,0.00,0.00,5200.00,0.00,'2022-06-21 15:42:09','',''),(1156,'21','238','4',2,'Received from bridging 146',0.00,0.00,5200.00,0.00,0.00,'2022-06-21 15:42:09','',''),(1157,'21','238',NULL,2,'Reception corrector for bridging 147',0.00,0.00,0.00,9800.00,0.00,'2022-06-21 15:42:20','',''),(1158,'21','238','5',2,'Received from bridging 147',0.00,0.00,9800.00,0.00,0.00,'2022-06-21 15:42:20','',''),(1159,'21','238','3',1,'Sale Id shift 96',0.00,0.00,0.00,995.73,0.00,'2022-06-21 16:08:55','',''),(1160,'21','238','4',2,'Sale Id shift 96',0.00,0.00,0.00,855.57,0.00,'2022-06-21 16:08:55','',''),(1161,'21','238','5',2,'Sale Id shift 96',0.00,0.00,0.00,6711.69,0.00,'2022-06-21 16:08:55','',''),(1162,'21','238','5',2,'Sale Id shift 96',0.00,0.00,0.00,1332.68,0.00,'2022-06-21 16:08:55','',''),(1163,'21','238','6',3,'Sale Id shift 96',0.00,0.00,0.00,67.28,0.00,'2022-06-21 16:08:55','',''),(1164,'21','238','2',1,'Sale Id shift 96',0.00,0.00,0.00,4989.54,0.00,'2022-06-21 16:08:55','',''),(1165,'21','238','2',1,'Sale Id shift 96',0.00,0.00,0.00,5873.18,0.00,'2022-06-21 16:08:55','',''),(1166,'21','238','3',1,'Sale Id shift 96',0.00,0.00,0.00,4453.74,0.00,'2022-06-21 16:08:55','',''),(1167,'21','238',NULL,1,'Sale Id shift 96',2691511.35,0.00,0.00,0.00,0.00,'2022-06-21 16:08:55','',''),(1168,'21','238',NULL,2,'Sale Id shift 96',7369150.32,0.00,0.00,0.00,0.00,'2022-06-21 16:08:55','',''),(1169,'21','238',NULL,3,'Sale Id shift 96',50460.00,0.00,0.00,0.00,0.00,'2022-06-21 16:08:55','',''),(1170,'21','238','4',2,'Sale Id shift 97',0.00,0.00,0.00,4380.86,0.00,'2022-06-21 16:40:55','',''),(1171,'21','238','5',2,'Sale Id shift 97',0.00,0.00,0.00,2649.67,0.00,'2022-06-21 16:40:55','',''),(1172,'21','238','5',2,'Sale Id shift 97',0.00,0.00,0.00,748.47,0.00,'2022-06-21 16:40:55','',''),(1173,'21','238','6',3,'Sale Id shift 97',0.00,0.00,0.00,112.33,0.00,'2022-06-21 16:40:55','',''),(1174,'21','238',NULL,2,'Sale Id shift 97',6441012.00,0.00,0.00,0.00,0.00,'2022-06-21 16:40:55','',''),(1175,'21','238',NULL,3,'Sale Id shift 97',84247.50,0.00,0.00,0.00,0.00,'2022-06-21 16:40:55','',''),(1176,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2475000.00,15000.00,0.00,0.00,'2022-06-22 12:52:59','',''),(1177,'21','238',NULL,1,'Reception corrector for bridging 148',0.00,0.00,0.00,15000.00,0.00,'2022-06-22 12:56:20','',''),(1178,'21','238','2',1,'Received from bridging 148',0.00,0.00,15000.00,0.00,0.00,'2022-06-22 12:56:20','',''),(1179,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2392500.00,14500.00,0.00,0.00,'2022-06-22 12:57:15','',''),(1180,'21','238',NULL,1,'Reception corrector for bridging 149',0.00,0.00,0.00,14500.00,0.00,'2022-06-22 12:59:21','',''),(1181,'21','238','3',1,'Received from bridging 149',0.00,0.00,14500.00,0.00,0.00,'2022-06-22 12:59:21','',''),(1182,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,12420000.00,15000.00,0.00,0.00,'2022-06-22 13:29:46','',''),(1183,'21','238',NULL,2,'Reception corrector for bridging 150',0.00,0.00,0.00,11000.00,0.00,'2022-06-22 13:33:44','',''),(1184,'21','238','4',2,'Received from bridging 150',0.00,0.00,11000.00,0.00,0.00,'2022-06-22 13:33:44','',''),(1185,'21','238',NULL,2,'Reception corrector for bridging 151',0.00,0.00,0.00,4000.00,0.00,'2022-06-22 13:33:54','',''),(1186,'21','238','5',2,'Received from bridging 151',0.00,0.00,4000.00,0.00,0.00,'2022-06-22 13:33:54','',''),(1187,'21','238','3',1,'Sale Id shift 98',0.00,0.00,0.00,242.93,0.00,'2022-06-22 14:39:10','',''),(1188,'21','238','4',2,'Sale Id shift 98',0.00,0.00,0.00,5811.44,0.00,'2022-06-22 14:39:10','',''),(1189,'21','238','5',2,'Sale Id shift 98',0.00,0.00,0.00,2480.77,0.00,'2022-06-22 14:39:10','',''),(1190,'21','238','5',2,'Sale Id shift 98',0.00,0.00,0.00,1092.71,0.00,'2022-06-22 14:39:10','',''),(1191,'21','238','6',3,'Sale Id shift 98',0.00,0.00,0.00,87.40,0.00,'2022-06-22 14:39:10','',''),(1192,'21','238','2',1,'Sale Id shift 98',0.00,0.00,0.00,7811.41,0.00,'2022-06-22 14:39:10','',''),(1193,'21','238','2',1,'Sale Id shift 98',0.00,0.00,0.00,6603.10,0.00,'2022-06-22 14:39:10','',''),(1194,'21','238','3',1,'Sale Id shift 98',0.00,0.00,0.00,5421.98,0.00,'2022-06-22 14:39:10','',''),(1195,'21','238',NULL,1,'Sale Id shift 98',3313104.30,0.00,0.00,0.00,0.00,'2022-06-22 14:39:10','',''),(1196,'21','238',NULL,2,'Sale Id shift 98',7770713.76,0.00,0.00,0.00,0.00,'2022-06-22 14:39:10','',''),(1197,'21','238',NULL,3,'Sale Id shift 98',65550.00,0.00,0.00,0.00,0.00,'2022-06-22 14:39:10','',''),(1198,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2475000.00,15000.00,0.00,0.00,'2022-06-28 13:43:34','',''),(1199,'21','238',NULL,1,'Reception corrector for bridging 153',0.00,0.00,0.00,4300.00,0.00,'2022-06-28 13:45:57','',''),(1200,'21','238','3',1,'Received from bridging 153',0.00,0.00,4300.00,0.00,0.00,'2022-06-28 13:45:57','',''),(1201,'21','238',NULL,1,'Reception corrector for bridging 152',0.00,0.00,0.00,10700.00,0.00,'2022-06-28 13:46:15','',''),(1202,'21','238','2',1,'Received from bridging 152',0.00,0.00,10700.00,0.00,0.00,'2022-06-28 13:46:15','',''),(1203,'21','238','3',1,'Sale Id shift 99',0.00,0.00,0.00,2293.78,0.00,'2022-06-28 14:03:27','',''),(1204,'21','238','4',2,'Sale Id shift 99',0.00,0.00,0.00,4177.15,0.00,'2022-06-28 14:03:27','',''),(1205,'21','238','5',2,'Sale Id shift 99',0.00,0.00,0.00,2434.56,0.00,'2022-06-28 14:03:27','',''),(1206,'21','238','5',2,'Sale Id shift 99',0.00,0.00,0.00,1051.03,0.00,'2022-06-28 14:03:27','',''),(1207,'21','238','6',3,'Sale Id shift 99',0.00,0.00,0.00,98.44,0.00,'2022-06-28 14:03:27','',''),(1208,'21','238','2',1,'Sale Id shift 99',0.00,0.00,0.00,2479.41,0.00,'2022-06-28 14:03:27','',''),(1209,'21','238','2',1,'Sale Id shift 99',0.00,0.00,0.00,3737.71,0.00,'2022-06-28 14:03:27','',''),(1210,'21','238','3',1,'Sale Id shift 99',0.00,0.00,0.00,892.91,0.00,'2022-06-28 14:03:27','',''),(1211,'21','238',NULL,1,'Sale Id shift 99',1551628.65,0.00,0.00,0.00,0.00,'2022-06-28 14:03:27','',''),(1212,'21','238',NULL,2,'Sale Id shift 99',6344748.72,0.00,0.00,0.00,0.00,'2022-06-28 14:03:27','',''),(1213,'21','238',NULL,3,'Sale Id shift 99',73830.00,0.00,0.00,0.00,0.00,'2022-06-28 14:03:27','',''),(1214,'21','238','5',2,'Sale Id shift 100',0.00,0.00,0.00,8231.87,0.00,'2022-06-28 14:24:04','',''),(1215,'21','238','5',2,'Sale Id shift 100',0.00,0.00,0.00,847.41,0.00,'2022-06-28 14:24:04','',''),(1216,'21','238','6',3,'Sale Id shift 100',0.00,0.00,0.00,97.67,0.00,'2022-06-28 14:24:04','',''),(1217,'21','238',NULL,2,'Sale Id shift 100',7517643.84,0.00,0.00,0.00,0.00,'2022-06-28 14:24:04','',''),(1218,'21','238',NULL,3,'Sale Id shift 100',73252.50,0.00,0.00,0.00,0.00,'2022-06-28 14:24:04','',''),(1219,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,24840000.00,30000.00,0.00,0.00,'2022-06-28 14:39:24','',''),(1220,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,24840000.00,30000.00,0.00,0.00,'2022-06-28 14:41:29','',''),(1221,'21','238',NULL,2,'Reception corrector for bridging 157',0.00,0.00,0.00,15000.00,0.00,'2022-06-28 14:42:54','',''),(1222,'21','238','5',2,'Received from bridging 157',0.00,0.00,15000.00,0.00,0.00,'2022-06-28 14:42:54','',''),(1223,'21','238',NULL,2,'Reception corrector for bridging 156',0.00,0.00,0.00,15000.00,0.00,'2022-06-28 14:43:07','',''),(1224,'21','238','4',2,'Received from bridging 156',0.00,0.00,15000.00,0.00,0.00,'2022-06-28 14:43:07','',''),(1225,'21','238',NULL,2,'Reception corrector for bridging 155',0.00,0.00,0.00,15000.00,0.00,'2022-06-28 14:43:20','',''),(1226,'21','238','5',2,'Received from bridging 155',0.00,0.00,15000.00,0.00,0.00,'2022-06-28 14:43:20','',''),(1227,'21','238',NULL,2,'Reception corrector for bridging 154',0.00,0.00,0.00,15000.00,0.00,'2022-06-28 14:43:33','',''),(1228,'21','238','4',2,'Received from bridging 154',0.00,0.00,15000.00,0.00,0.00,'2022-06-28 14:43:33','',''),(1229,'21','238','4',2,'Sale Id shift 101',0.00,0.00,0.00,664.79,0.00,'2022-06-28 15:07:42','',''),(1230,'21','238','5',2,'Sale Id shift 101',0.00,0.00,0.00,3031.85,0.00,'2022-06-28 15:07:42','',''),(1231,'21','238','5',2,'Sale Id shift 101',0.00,0.00,0.00,625.64,0.00,'2022-06-28 15:07:42','',''),(1232,'21','238','6',3,'Sale Id shift 101',0.00,0.00,0.00,99.44,0.00,'2022-06-28 15:07:42','',''),(1233,'21','238',NULL,2,'Sale Id shift 101',3578847.84,0.00,0.00,0.00,0.00,'2022-06-28 15:07:42','',''),(1234,'21','238',NULL,3,'Sale Id shift 101',74580.00,0.00,0.00,0.00,0.00,'2022-06-28 15:07:42','',''),(1235,'21','238','4',2,'Sale Id shift 102',0.00,0.00,0.00,4801.05,0.00,'2022-06-28 16:02:25','',''),(1236,'21','238','5',2,'Sale Id shift 102',0.00,0.00,0.00,2739.62,0.00,'2022-06-28 16:02:25','',''),(1237,'21','238','5',2,'Sale Id shift 102',0.00,0.00,0.00,2588.85,0.00,'2022-06-28 16:02:25','',''),(1238,'21','238','6',3,'Sale Id shift 102',0.00,0.00,0.00,75.50,0.00,'2022-06-28 16:02:25','',''),(1239,'21','238',NULL,2,'Sale Id shift 102',8387242.56,0.00,0.00,0.00,0.00,'2022-06-28 16:02:25','',''),(1240,'21','238',NULL,3,'Sale Id shift 102',56625.00,0.00,0.00,0.00,0.00,'2022-06-28 16:02:25','',''),(1241,'21','238','4',2,'Sale Id shift 103',0.00,0.00,0.00,3243.80,0.00,'2022-06-28 16:18:07','',''),(1242,'21','238','5',2,'Sale Id shift 103',0.00,0.00,0.00,2565.78,0.00,'2022-06-28 16:18:07','',''),(1243,'21','238','5',2,'Sale Id shift 103',0.00,0.00,0.00,1350.44,0.00,'2022-06-28 16:18:07','',''),(1244,'21','238','6',3,'Sale Id shift 103',0.00,0.00,0.00,51.26,0.00,'2022-06-28 16:18:07','',''),(1245,'21','238',NULL,2,'Sale Id shift 103',5928496.56,0.00,0.00,0.00,0.00,'2022-06-28 16:18:07','',''),(1246,'21','238',NULL,3,'Sale Id shift 103',38445.00,0.00,0.00,0.00,0.00,'2022-06-28 16:18:07','',''),(1247,'21','238','4',2,'Sale Id shift 104',0.00,0.00,0.00,2596.87,0.00,'2022-06-28 16:57:32','',''),(1248,'21','238','5',2,'Sale Id shift 104',0.00,0.00,0.00,4207.09,0.00,'2022-06-28 16:57:32','',''),(1249,'21','238','5',2,'Sale Id shift 104',0.00,0.00,0.00,4355.75,0.00,'2022-06-28 16:57:32','',''),(1250,'21','238','6',3,'Sale Id shift 104',0.00,0.00,0.00,63.15,0.00,'2022-06-28 16:57:32','',''),(1251,'21','238',NULL,2,'Sale Id shift 104',9240239.88,0.00,0.00,0.00,0.00,'2022-06-28 16:57:32','',''),(1252,'21','238',NULL,3,'Sale Id shift 104',47362.50,0.00,0.00,0.00,0.00,'2022-06-28 16:57:32','',''),(1253,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2475000.00,15000.00,0.00,0.00,'2022-06-29 13:13:35','',''),(1254,'21','238',NULL,1,'Reception corrector for bridging 158',0.00,0.00,0.00,10800.00,0.00,'2022-06-29 13:16:45','',''),(1255,'21','238','2',1,'Received from bridging 158',0.00,0.00,10800.00,0.00,0.00,'2022-06-29 13:16:45','',''),(1256,'21','238',NULL,1,'Reception corrector for bridging 159',0.00,0.00,0.00,4200.00,0.00,'2022-06-29 13:17:10','',''),(1257,'21','238','3',1,'Received from bridging 159',0.00,0.00,4200.00,0.00,0.00,'2022-06-29 13:17:10','',''),(1258,'21','238','3',1,'Sale Id shift 105',0.00,0.00,0.00,2181.37,0.00,'2022-06-29 14:39:57','',''),(1259,'21','238','4',2,'Sale Id shift 105',0.00,0.00,0.00,5112.68,0.00,'2022-06-29 14:39:57','',''),(1260,'21','238','5',2,'Sale Id shift 105',0.00,0.00,0.00,3426.84,0.00,'2022-06-29 14:39:57','',''),(1261,'21','238','5',2,'Sale Id shift 105',0.00,0.00,0.00,2022.18,0.00,'2022-06-29 14:39:57','',''),(1262,'21','238','6',3,'Sale Id shift 105',0.00,0.00,0.00,104.80,0.00,'2022-06-29 14:39:57','',''),(1263,'21','238','2',1,'Sale Id shift 105',0.00,0.00,0.00,4902.04,0.00,'2022-06-29 14:39:57','',''),(1264,'21','238','2',1,'Sale Id shift 105',0.00,0.00,0.00,5653.53,0.00,'2022-06-29 14:39:57','',''),(1265,'21','238','3',1,'Sale Id shift 105',0.00,0.00,0.00,2172.11,0.00,'2022-06-29 14:39:57','',''),(1266,'21','238',NULL,1,'Sale Id shift 105',2459993.25,0.00,0.00,0.00,0.00,'2022-06-29 14:39:57','',''),(1267,'21','238',NULL,2,'Sale Id shift 105',8745087.60,0.00,0.00,0.00,0.00,'2022-06-29 14:39:57','',''),(1268,'21','238',NULL,3,'Sale Id shift 105',78600.00,0.00,0.00,0.00,0.00,'2022-06-29 14:39:57','',''),(1269,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,12420000.00,15000.00,0.00,0.00,'2022-06-30 20:37:59','',''),(1270,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,27324000.00,33000.00,0.00,0.00,'2022-06-30 20:44:18','',''),(1271,'21','238',NULL,2,'Reception corrector for bridging 160',0.00,0.00,0.00,15000.00,0.00,'2022-06-30 20:47:42','',''),(1272,'21','238','5',2,'Received from bridging 160',0.00,0.00,15000.00,0.00,0.00,'2022-06-30 20:47:42','',''),(1273,'21','238',NULL,2,'Reception corrector for bridging 161',0.00,0.00,0.00,17000.00,0.00,'2022-06-30 20:48:37','',''),(1274,'21','238','4',2,'Received from bridging 161',0.00,0.00,17000.00,0.00,0.00,'2022-06-30 20:48:37','',''),(1275,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2805000.00,17000.00,0.00,0.00,'2022-07-08 11:44:00','',''),(1276,'21','238',NULL,1,'Reception corrector for bridging 163',0.00,0.00,0.00,7700.00,0.00,'2022-07-08 11:47:30','',''),(1277,'21','238','2',1,'Received from bridging 163',0.00,0.00,7700.00,0.00,0.00,'2022-07-08 11:47:30','',''),(1278,'21','238',NULL,1,'Reception corrector for bridging 164',0.00,0.00,0.00,9300.00,0.00,'2022-07-08 11:47:50','',''),(1279,'21','238','3',1,'Received from bridging 164',0.00,0.00,9300.00,0.00,0.00,'2022-07-08 11:47:50','',''),(1280,'21','238','3',1,'Sale Id shift 106',0.00,0.00,0.00,6694.29,0.00,'2022-07-08 12:45:28','',''),(1281,'21','238','4',2,'Sale Id shift 106',0.00,0.00,0.00,4804.06,0.00,'2022-07-08 12:45:28','',''),(1282,'21','238','5',2,'Sale Id shift 106',0.00,0.00,0.00,4442.73,0.00,'2022-07-08 12:45:28','',''),(1283,'21','238','5',2,'Sale Id shift 106',0.00,0.00,0.00,2701.27,0.00,'2022-07-08 12:45:28','',''),(1284,'21','238','6',3,'Sale Id shift 106',0.00,0.00,0.00,134.97,0.00,'2022-07-08 12:45:28','',''),(1285,'21','238','2',1,'Sale Id shift 106',0.00,0.00,0.00,2805.81,0.00,'2022-07-08 12:45:28','',''),(1286,'21','238','3',1,'Sale Id shift 106',0.00,0.00,0.00,4912.38,0.00,'2022-07-08 12:45:28','',''),(1287,'21','238',NULL,1,'Sale Id shift 106',2378059.20,0.00,0.00,0.00,0.00,'2022-07-08 12:45:28','',''),(1288,'21','238',NULL,2,'Sale Id shift 106',9892993.68,0.00,0.00,0.00,0.00,'2022-07-08 12:45:28','',''),(1289,'21','238',NULL,3,'Sale Id shift 106',101227.50,0.00,0.00,0.00,0.00,'2022-07-08 12:45:28','',''),(1290,'21','238','4',2,'Sale Id shift 107',0.00,0.00,0.00,3756.25,0.00,'2022-07-08 15:07:23','',''),(1291,'21','238','5',2,'Sale Id shift 107',0.00,0.00,0.00,3332.84,0.00,'2022-07-08 15:07:23','',''),(1292,'21','238','5',2,'Sale Id shift 107',0.00,0.00,0.00,532.61,0.00,'2022-07-08 15:07:23','',''),(1293,'21','238','6',3,'Sale Id shift 107',0.00,0.00,0.00,37.98,0.00,'2022-07-08 15:07:23','',''),(1294,'21','238','2',1,'Sale Id shift 107',0.00,0.00,0.00,503.17,0.00,'2022-07-08 15:07:23','',''),(1295,'21','238',NULL,1,'Sale Id shift 107',83023.05,0.00,0.00,0.00,0.00,'2022-07-08 15:07:23','',''),(1296,'21','238',NULL,2,'Sale Id shift 107',6310767.60,0.00,0.00,0.00,0.00,'2022-07-08 15:07:23','',''),(1297,'21','238',NULL,3,'Sale Id shift 107',28485.00,0.00,0.00,0.00,0.00,'2022-07-08 15:07:23','',''),(1298,'21','238','4',2,'Sale Id shift 108',0.00,0.00,0.00,4816.44,0.00,'2022-07-08 15:22:17','',''),(1299,'21','238','5',2,'Sale Id shift 108',0.00,0.00,0.00,1464.56,0.00,'2022-07-08 15:22:17','',''),(1300,'21','238','5',2,'Sale Id shift 108',0.00,0.00,0.00,946.84,0.00,'2022-07-08 15:22:17','',''),(1301,'21','238','6',3,'Sale Id shift 108',0.00,0.00,0.00,74.29,0.00,'2022-07-08 15:22:17','',''),(1302,'21','238','2',1,'Sale Id shift 108',0.00,0.00,0.00,104.83,0.00,'2022-07-08 15:22:17','',''),(1303,'21','238',NULL,1,'Sale Id shift 108',17296.95,0.00,0.00,0.00,0.00,'2022-07-08 15:22:17','',''),(1304,'21','238',NULL,2,'Sale Id shift 108',5984651.52,0.00,0.00,0.00,0.00,'2022-07-08 15:22:17','',''),(1305,'21','238',NULL,3,'Sale Id shift 108',55717.50,0.00,0.00,0.00,0.00,'2022-07-08 15:22:17','',''),(1306,'21','238','4',2,'Sale Id shift 109',0.00,0.00,0.00,2272.55,0.00,'2022-07-08 15:43:49','',''),(1307,'21','238','5',2,'Sale Id shift 109',0.00,0.00,0.00,1571.41,0.00,'2022-07-08 15:43:49','',''),(1308,'21','238','5',2,'Sale Id shift 109',0.00,0.00,0.00,3138.59,0.00,'2022-07-08 15:43:49','',''),(1309,'21','238','6',3,'Sale Id shift 109',0.00,0.00,0.00,87.72,0.00,'2022-07-08 15:43:49','',''),(1310,'21','238',NULL,2,'Sale Id shift 109',5781551.40,0.00,0.00,0.00,0.00,'2022-07-08 15:43:49','',''),(1311,'21','238',NULL,3,'Sale Id shift 109',65790.00,0.00,0.00,0.00,0.00,'2022-07-08 15:43:49','',''),(1312,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,24840000.00,30000.00,0.00,0.00,'2022-07-08 16:06:08','',''),(1313,'21','238',NULL,2,'Reception corrector for bridging 165',0.00,0.00,0.00,15000.00,0.00,'2022-07-08 16:08:45','',''),(1314,'21','238','4',2,'Received from bridging 165',0.00,0.00,15000.00,0.00,0.00,'2022-07-08 16:08:45','',''),(1315,'21','238',NULL,2,'Reception corrector for bridging 166',0.00,0.00,0.00,15000.00,0.00,'2022-07-08 16:09:02','',''),(1316,'21','238','5',2,'Received from bridging 166',0.00,0.00,15000.00,0.00,0.00,'2022-07-08 16:09:02','',''),(1317,'21','238','4',2,'Sale Id shift 110',0.00,0.00,0.00,3605.39,0.00,'2022-07-08 16:20:57','',''),(1318,'21','238','5',2,'Sale Id shift 110',0.00,0.00,0.00,1321.48,0.00,'2022-07-08 16:20:57','',''),(1319,'21','238','5',2,'Sale Id shift 110',0.00,0.00,0.00,872.26,0.00,'2022-07-08 16:20:57','',''),(1320,'21','238','6',3,'Sale Id shift 110',0.00,0.00,0.00,97.60,0.00,'2022-07-08 16:20:57','',''),(1321,'21','238',NULL,2,'Sale Id shift 110',4801679.64,0.00,0.00,0.00,0.00,'2022-07-08 16:20:57','',''),(1322,'21','238',NULL,3,'Sale Id shift 110',73200.00,0.00,0.00,0.00,0.00,'2022-07-08 16:20:57','',''),(1323,'21','238','4',2,'Sale Id shift 111',0.00,0.00,0.00,3318.74,0.00,'2022-07-08 16:35:30','',''),(1324,'21','238','5',2,'Sale Id shift 111',0.00,0.00,0.00,2472.15,0.00,'2022-07-08 16:35:30','',''),(1325,'21','238','5',2,'Sale Id shift 111',0.00,0.00,0.00,1145.14,0.00,'2022-07-08 16:35:30','',''),(1326,'21','238','6',3,'Sale Id shift 111',0.00,0.00,0.00,130.17,0.00,'2022-07-08 16:35:30','',''),(1327,'21','238',NULL,2,'Sale Id shift 111',5743032.84,0.00,0.00,0.00,0.00,'2022-07-08 16:35:30','',''),(1328,'21','238',NULL,3,'Sale Id shift 111',97627.50,0.00,0.00,0.00,0.00,'2022-07-08 16:35:30','',''),(1329,'21','238','4',2,'Sale Id shift 112',0.00,0.00,0.00,2756.14,0.00,'2022-07-08 16:52:12','',''),(1330,'21','238','5',2,'Sale Id shift 112',0.00,0.00,0.00,3201.61,0.00,'2022-07-08 16:52:12','',''),(1331,'21','238','5',2,'Sale Id shift 112',0.00,0.00,0.00,2125.65,0.00,'2022-07-08 16:52:12','',''),(1332,'21','238','6',3,'Sale Id shift 112',0.00,0.00,0.00,185.28,0.00,'2022-07-08 16:52:12','',''),(1333,'21','238',NULL,2,'Sale Id shift 112',6693055.20,0.00,0.00,0.00,0.00,'2022-07-08 16:52:12','',''),(1334,'21','238',NULL,3,'Sale Id shift 112',138960.00,0.00,0.00,0.00,0.00,'2022-07-08 16:52:12','',''),(1335,'21','238',NULL,2,'Reception corrector for bridging 162',0.00,0.00,0.00,16000.00,0.00,'2022-07-08 19:48:54','',''),(1336,'21','238','5',2,'Received from bridging 162',0.00,0.00,16000.00,0.00,0.00,'2022-07-08 19:48:54','',''),(1337,'21','238','4',2,'Sale Id shift 113',0.00,0.00,0.00,2884.59,0.00,'2022-07-09 16:04:36','',''),(1338,'21','238','5',2,'Sale Id shift 113',0.00,0.00,0.00,1517.06,0.00,'2022-07-09 16:04:36','',''),(1339,'21','238','5',2,'Sale Id shift 113',0.00,0.00,0.00,739.27,0.00,'2022-07-09 16:04:36','',''),(1340,'21','238','6',3,'Sale Id shift 113',0.00,0.00,0.00,88.47,0.00,'2022-07-09 16:04:36','',''),(1341,'21','238',NULL,2,'Sale Id shift 113',4256681.76,0.00,0.00,0.00,0.00,'2022-07-09 16:04:36','',''),(1342,'21','238',NULL,3,'Sale Id shift 113',66352.50,0.00,0.00,0.00,0.00,'2022-07-09 16:04:36','',''),(1343,'21','238','3',1,'Sale Id shift 114',0.00,0.00,0.00,2743.11,0.00,'2022-07-09 16:31:49','',''),(1344,'21','238','4',2,'Sale Id shift 114',0.00,0.00,0.00,2588.78,0.00,'2022-07-09 16:31:49','',''),(1345,'21','238','5',2,'Sale Id shift 114',0.00,0.00,0.00,1725.25,0.00,'2022-07-09 16:31:49','',''),(1346,'21','238','5',2,'Sale Id shift 114',0.00,0.00,0.00,450.96,0.00,'2022-07-09 16:31:49','',''),(1347,'21','238','6',3,'Sale Id shift 114',0.00,0.00,0.00,130.42,0.00,'2022-07-09 16:31:49','',''),(1348,'21','238','2',1,'Sale Id shift 114',0.00,0.00,0.00,5058.76,0.00,'2022-07-09 16:31:49','',''),(1349,'21','238','2',1,'Sale Id shift 114',0.00,0.00,0.00,4204.77,0.00,'2022-07-09 16:31:49','',''),(1350,'21','238','3',1,'Sale Id shift 114',0.00,0.00,0.00,5101.71,0.00,'2022-07-09 16:31:49','',''),(1351,'21','238',NULL,1,'Sale Id shift 114',2822877.75,0.00,0.00,0.00,0.00,'2022-07-09 16:31:49','',''),(1352,'21','238',NULL,2,'Sale Id shift 114',3945411.72,0.00,0.00,0.00,0.00,'2022-07-09 16:31:49','',''),(1353,'21','238',NULL,3,'Sale Id shift 114',97815.00,0.00,0.00,0.00,0.00,'2022-07-09 16:31:49','',''),(1354,'21','238','4',2,'Sale Id shift 115',0.00,0.00,0.00,1496.07,0.00,'2022-07-13 17:18:13','',''),(1355,'21','238','5',2,'Sale Id shift 115',0.00,0.00,0.00,1534.92,0.00,'2022-07-13 17:18:13','',''),(1356,'21','238','5',2,'Sale Id shift 115',0.00,0.00,0.00,190.18,0.00,'2022-07-13 17:18:13','',''),(1357,'21','238','6',3,'Sale Id shift 115',0.00,0.00,0.00,132.41,0.00,'2022-07-13 17:18:13','',''),(1358,'21','238',NULL,2,'Sale Id shift 115',2667128.76,0.00,0.00,0.00,0.00,'2022-07-13 17:18:13','',''),(1359,'21','238',NULL,3,'Sale Id shift 115',99307.50,0.00,0.00,0.00,0.00,'2022-07-13 17:18:13','',''),(1360,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2775000.00,15000.00,0.00,0.00,'2022-07-13 17:23:42','',''),(1361,'21','238',NULL,1,'Reception corrector for bridging 167',0.00,0.00,0.00,15000.00,0.00,'2022-07-13 17:25:28','',''),(1362,'21','238','2',1,'Received from bridging 167',0.00,0.00,15000.00,0.00,0.00,'2022-07-13 17:25:28','',''),(1363,'21','238','4',2,'Sale Id shift 116',0.00,0.00,0.00,1309.07,0.00,'2022-07-13 17:45:05','',''),(1364,'21','238','6',3,'Sale Id shift 116',0.00,0.00,0.00,62.12,0.00,'2022-07-13 17:45:05','',''),(1365,'21','238','2',1,'Sale Id shift 116',0.00,0.00,0.00,5645.11,0.00,'2022-07-13 17:45:05','',''),(1366,'21','238','2',1,'Sale Id shift 116',0.00,0.00,0.00,9526.63,0.00,'2022-07-13 17:45:05','',''),(1367,'21','238',NULL,1,'Sale Id shift 116',2806771.90,0.00,0.00,0.00,0.00,'2022-07-13 17:45:05','',''),(1368,'21','238',NULL,2,'Sale Id shift 116',1083909.96,0.00,0.00,0.00,0.00,'2022-07-13 17:45:05','',''),(1369,'21','238',NULL,3,'Sale Id shift 116',46590.00,0.00,0.00,0.00,0.00,'2022-07-13 17:45:05','',''),(1370,'21','238','4',2,'Sale Id shift 117',0.00,0.00,0.00,865.48,0.00,'2022-07-13 17:52:29','',''),(1371,'21','238','5',2,'Sale Id shift 117',0.00,0.00,0.00,918.17,0.00,'2022-07-13 17:52:29','',''),(1372,'21','238','5',2,'Sale Id shift 117',0.00,0.00,0.00,178.15,0.00,'2022-07-13 17:52:29','',''),(1373,'21','238','6',3,'Sale Id shift 117',0.00,0.00,0.00,79.91,0.00,'2022-07-13 17:52:29','',''),(1374,'21','238',NULL,2,'Sale Id shift 117',1624370.40,0.00,0.00,0.00,0.00,'2022-07-13 17:52:29','',''),(1375,'21','238',NULL,3,'Sale Id shift 117',59932.50,0.00,0.00,0.00,0.00,'2022-07-13 17:52:29','',''),(1376,'21','238','4',2,'Sale Id shift 118',0.00,0.00,0.00,2087.06,0.00,'2022-07-13 17:59:15','',''),(1377,'21','238','5',2,'Sale Id shift 118',0.00,0.00,0.00,1925.70,0.00,'2022-07-13 17:59:15','',''),(1378,'21','238','5',2,'Sale Id shift 118',0.00,0.00,0.00,429.46,0.00,'2022-07-13 17:59:15','',''),(1379,'21','238','6',3,'Sale Id shift 118',0.00,0.00,0.00,128.18,0.00,'2022-07-13 17:59:15','',''),(1380,'21','238',NULL,2,'Sale Id shift 118',3678158.16,0.00,0.00,0.00,0.00,'2022-07-13 17:59:15','',''),(1381,'21','238',NULL,3,'Sale Id shift 118',96135.00,0.00,0.00,0.00,0.00,'2022-07-13 17:59:15','',''),(1382,'21','238',NULL,3,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,12375000.00,16500.00,0.00,0.00,'2022-07-14 14:43:09','',''),(1383,'21','238',NULL,3,'Reception corrector for bridging 168',0.00,0.00,0.00,16500.00,0.00,'2022-07-14 14:45:22','',''),(1384,'21','238','6',3,'Received from bridging 168',0.00,0.00,16500.00,0.00,0.00,'2022-07-14 14:45:22','',''),(1385,'21','238','4',2,'Sale Id shift 119',0.00,0.00,0.00,3777.08,0.00,'2022-07-15 09:07:07','',''),(1386,'21','238','5',2,'Sale Id shift 119',0.00,0.00,0.00,2608.09,0.00,'2022-07-15 09:07:07','',''),(1387,'21','238','5',2,'Sale Id shift 119',0.00,0.00,0.00,1689.62,0.00,'2022-07-15 09:07:07','',''),(1388,'21','238','6',3,'Sale Id shift 119',0.00,0.00,0.00,65.69,0.00,'2022-07-15 09:07:07','',''),(1389,'21','238',NULL,2,'Sale Id shift 119',6685926.12,0.00,0.00,0.00,0.00,'2022-07-15 09:07:07','',''),(1390,'21','238',NULL,3,'Sale Id shift 119',49267.50,0.00,0.00,0.00,0.00,'2022-07-15 09:07:07','',''),(1391,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8325000.00,45000.00,0.00,0.00,'2022-07-15 09:10:27','',''),(1392,'21','238',NULL,1,'Reception corrector for bridging 169',0.00,0.00,0.00,30000.00,0.00,'2022-07-15 09:12:49','',''),(1393,'21','238','2',1,'Received from bridging 169',0.00,0.00,30000.00,0.00,0.00,'2022-07-15 09:12:49','',''),(1394,'21','238',NULL,1,'Reception corrector for bridging 170',0.00,0.00,0.00,15000.00,0.00,'2022-07-15 09:12:58','',''),(1395,'21','238','3',1,'Received from bridging 170',0.00,0.00,15000.00,0.00,0.00,'2022-07-15 09:12:58','',''),(1396,'21','238','3',1,'Sale Id shift 120',0.00,0.00,0.00,2320.44,0.00,'2022-07-15 09:32:53','',''),(1397,'21','238','4',2,'Sale Id shift 120',0.00,0.00,0.00,2870.36,0.00,'2022-07-15 09:32:53','',''),(1398,'21','238','5',2,'Sale Id shift 120',0.00,0.00,0.00,3554.13,0.00,'2022-07-15 09:32:53','',''),(1399,'21','238','5',2,'Sale Id shift 120',0.00,0.00,0.00,1637.97,0.00,'2022-07-15 09:32:53','',''),(1400,'21','238','6',3,'Sale Id shift 120',0.00,0.00,0.00,72.40,0.00,'2022-07-15 09:32:53','',''),(1401,'21','238','2',1,'Sale Id shift 120',0.00,0.00,0.00,11047.16,0.00,'2022-07-15 09:32:53','',''),(1402,'21','238','2',1,'Sale Id shift 120',0.00,0.00,0.00,13581.24,0.00,'2022-07-15 09:32:53','',''),(1403,'21','238','3',1,'Sale Id shift 120',0.00,0.00,0.00,9478.30,0.00,'2022-07-15 09:32:53','',''),(1404,'21','238',NULL,2,'Sale Id shift 120',6675716.88,0.00,0.00,0.00,0.00,'2022-07-15 09:32:53','',''),(1405,'21','238',NULL,3,'Sale Id shift 120',54300.00,0.00,0.00,0.00,0.00,'2022-07-15 09:32:53','',''),(1406,'21','238',NULL,1,'Sale Id shift 120',6739020.90,0.00,0.00,0.00,0.00,'2022-07-15 09:32:53','',''),(1407,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,28152000.00,34000.00,0.00,0.00,'2022-07-15 09:42:01','',''),(1408,'21','238',NULL,2,'Reception corrector for bridging 172',0.00,0.00,0.00,17000.00,0.00,'2022-07-15 09:43:55','',''),(1409,'21','238','5',2,'Received from bridging 172',0.00,0.00,17000.00,0.00,0.00,'2022-07-15 09:43:55','',''),(1410,'21','238',NULL,2,'Reception corrector for bridging 171',0.00,0.00,0.00,17000.00,0.00,'2022-07-15 09:44:14','',''),(1411,'21','238','4',2,'Received from bridging 171',0.00,0.00,17000.00,0.00,0.00,'2022-07-15 09:44:14','',''),(1412,'21','238','3',1,'Sale Id shift 121',0.00,0.00,0.00,1633.18,0.00,'2022-07-18 08:45:46','',''),(1413,'21','238','4',2,'Sale Id shift 121',0.00,0.00,0.00,1739.13,0.00,'2022-07-18 08:45:46','',''),(1414,'21','238','5',2,'Sale Id shift 121',0.00,0.00,0.00,2582.28,0.00,'2022-07-18 08:45:46','',''),(1415,'21','238','5',2,'Sale Id shift 121',0.00,0.00,0.00,225.67,0.00,'2022-07-18 08:45:46','',''),(1416,'21','238','6',3,'Sale Id shift 121',0.00,0.00,0.00,52.37,0.00,'2022-07-18 08:45:46','',''),(1417,'21','238','2',1,'Sale Id shift 121',0.00,0.00,0.00,823.81,0.00,'2022-07-18 08:45:46','',''),(1418,'21','238','2',1,'Sale Id shift 121',0.00,0.00,0.00,4600.13,0.00,'2022-07-18 08:45:46','',''),(1419,'21','238','3',1,'Sale Id shift 121',0.00,0.00,0.00,1708.58,0.00,'2022-07-18 08:45:46','',''),(1420,'21','238',NULL,1,'Sale Id shift 121',1621654.50,0.00,0.00,0.00,0.00,'2022-07-18 08:45:46','',''),(1421,'21','238',NULL,2,'Sale Id shift 121',3764982.24,0.00,0.00,0.00,0.00,'2022-07-18 08:45:46','',''),(1422,'21','238',NULL,3,'Sale Id shift 121',39277.50,0.00,0.00,0.00,0.00,'2022-07-18 08:45:46','',''),(1423,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2775000.00,15000.00,0.00,0.00,'2022-07-18 08:53:20','',''),(1424,'21','238',NULL,1,'Reception corrector for bridging 173',0.00,0.00,0.00,15000.00,0.00,'2022-07-18 08:56:30','',''),(1425,'21','238','2',1,'Received from bridging 173',0.00,0.00,15000.00,0.00,0.00,'2022-07-18 08:56:30','',''),(1426,'21','238','4',2,'Sale Id shift 122',0.00,0.00,0.00,3885.94,0.00,'2022-07-18 09:46:41','',''),(1427,'21','238','5',2,'Sale Id shift 122',0.00,0.00,0.00,3354.31,0.00,'2022-07-18 09:46:41','',''),(1428,'21','238','5',2,'Sale Id shift 122',0.00,0.00,0.00,335.83,0.00,'2022-07-18 09:46:41','',''),(1429,'21','238','6',3,'Sale Id shift 122',0.00,0.00,0.00,52.93,0.00,'2022-07-18 09:46:41','',''),(1430,'21','238','2',1,'Sale Id shift 122',0.00,0.00,0.00,6375.90,0.00,'2022-07-18 09:46:41','',''),(1431,'21','238','2',1,'Sale Id shift 122',0.00,0.00,0.00,8780.03,0.00,'2022-07-18 09:46:41','',''),(1432,'21','238',NULL,1,'Sale Id shift 122',2803847.05,0.00,0.00,0.00,0.00,'2022-07-18 09:46:41','',''),(1433,'21','238',NULL,2,'Sale Id shift 122',6272994.24,0.00,0.00,0.00,0.00,'2022-07-18 09:46:41','',''),(1434,'21','238',NULL,3,'Sale Id shift 122',39697.50,0.00,0.00,0.00,0.00,'2022-07-18 09:46:41','',''),(1435,'21','238','4',2,'Sale Id shift 123',0.00,0.00,0.00,2626.16,0.00,'2022-07-18 10:04:46','',''),(1436,'21','238','5',2,'Sale Id shift 123',0.00,0.00,0.00,1004.33,0.00,'2022-07-18 10:04:46','',''),(1437,'21','238','5',2,'Sale Id shift 123',0.00,0.00,0.00,163.60,0.00,'2022-07-18 10:04:46','',''),(1438,'21','238','6',3,'Sale Id shift 123',0.00,0.00,0.00,182.26,0.00,'2022-07-18 10:04:46','',''),(1439,'21','238',NULL,2,'Sale Id shift 123',3141506.52,0.00,0.00,0.00,0.00,'2022-07-18 10:04:46','',''),(1440,'21','238',NULL,3,'Sale Id shift 123',136695.00,0.00,0.00,0.00,0.00,'2022-07-18 10:04:46','',''),(1441,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2830500.00,15300.00,0.00,0.00,'2022-07-18 12:52:54','',''),(1442,'21','238',NULL,1,'Reception corrector for bridging 174',0.00,0.00,0.00,15300.00,0.00,'2022-07-18 13:10:57','',''),(1443,'21','238','2',1,'Received from bridging 174',0.00,0.00,15300.00,0.00,0.00,'2022-07-18 13:10:57','',''),(1444,'21','238','4',2,'Sale Id shift 124',0.00,0.00,0.00,3242.48,0.00,'2022-07-18 13:29:10','',''),(1445,'21','238','5',2,'Sale Id shift 124',0.00,0.00,0.00,804.75,0.00,'2022-07-18 13:29:10','',''),(1446,'21','238','5',2,'Sale Id shift 124',0.00,0.00,0.00,1474.33,0.00,'2022-07-18 13:29:10','',''),(1447,'21','238','6',3,'Sale Id shift 124',0.00,0.00,0.00,100.83,0.00,'2022-07-18 13:29:10','',''),(1448,'21','238','2',1,'Sale Id shift 124',0.00,0.00,0.00,922.82,0.00,'2022-07-18 13:29:10','',''),(1449,'21','238','2',1,'Sale Id shift 124',0.00,0.00,0.00,879.34,0.00,'2022-07-18 13:29:10','',''),(1450,'21','238',NULL,1,'Sale Id shift 124',333399.60,0.00,0.00,0.00,0.00,'2022-07-18 13:29:10','',''),(1451,'21','238',NULL,2,'Sale Id shift 124',4571851.68,0.00,0.00,0.00,0.00,'2022-07-18 13:29:10','',''),(1452,'21','238',NULL,3,'Sale Id shift 124',75622.50,0.00,0.00,0.00,0.00,'2022-07-18 13:29:10','',''),(1453,'21','238','4',2,'Sale Id shift 125',0.00,0.00,0.00,4223.47,0.00,'2022-07-19 14:23:34','',''),(1454,'21','238','5',2,'Sale Id shift 125',0.00,0.00,0.00,2505.10,0.00,'2022-07-19 14:23:34','',''),(1455,'21','238','5',2,'Sale Id shift 125',0.00,0.00,0.00,212.52,0.00,'2022-07-19 14:23:34','',''),(1456,'21','238','6',3,'Sale Id shift 125',0.00,0.00,0.00,139.08,0.00,'2022-07-19 14:23:34','',''),(1457,'21','238','2',1,'Sale Id shift 125',0.00,0.00,0.00,5812.90,0.00,'2022-07-19 14:23:34','',''),(1458,'21','238','2',1,'Sale Id shift 125',0.00,0.00,0.00,7705.64,0.00,'2022-07-19 14:23:34','',''),(1459,'21','238',NULL,1,'Sale Id shift 125',2568522.60,0.00,0.00,0.00,0.00,'2022-07-19 14:23:34','',''),(1460,'21','238',NULL,2,'Sale Id shift 125',5747222.52,0.00,0.00,0.00,0.00,'2022-07-19 14:23:34','',''),(1461,'21','238',NULL,3,'Sale Id shift 125',104310.00,0.00,0.00,0.00,0.00,'2022-07-19 14:23:34','',''),(1462,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,24840000.00,30000.00,0.00,0.00,'2022-07-19 18:11:27','',''),(1463,'21','238',NULL,2,'Reception corrector for bridging 176',0.00,0.00,0.00,15000.00,0.00,'2022-07-19 18:14:09','',''),(1464,'21','238','5',2,'Received from bridging 176',0.00,0.00,15000.00,0.00,0.00,'2022-07-19 18:14:09','',''),(1465,'21','238',NULL,2,'Reception corrector for bridging 175',0.00,0.00,0.00,15000.00,0.00,'2022-07-19 18:14:22','',''),(1466,'21','238','4',2,'Received from bridging 175',0.00,0.00,15000.00,0.00,0.00,'2022-07-19 18:14:22','',''),(1467,'21','238','4',2,'Sale Id shift 126',0.00,0.00,0.00,2954.76,0.00,'2022-07-20 09:28:55','',''),(1468,'21','238','5',2,'Sale Id shift 126',0.00,0.00,0.00,1216.00,0.00,'2022-07-20 09:28:55','',''),(1469,'21','238','5',2,'Sale Id shift 126',0.00,0.00,0.00,1511.05,0.00,'2022-07-20 09:28:55','',''),(1470,'21','238','6',3,'Sale Id shift 126',0.00,0.00,0.00,109.86,0.00,'2022-07-20 09:28:55','',''),(1471,'21','238',NULL,2,'Sale Id shift 126',4704538.68,0.00,0.00,0.00,0.00,'2022-07-20 09:28:55','',''),(1472,'21','238',NULL,3,'Sale Id shift 126',82395.00,0.00,0.00,0.00,0.00,'2022-07-20 09:28:55','',''),(1473,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,3135000.00,16500.00,0.00,0.00,'2022-07-20 09:35:32','',''),(1474,'21','238',NULL,1,'Reception corrector for bridging 177',0.00,0.00,0.00,16500.00,0.00,'2022-07-20 09:42:49','',''),(1475,'21','238','2',1,'Received from bridging 177',0.00,0.00,16500.00,0.00,0.00,'2022-07-20 09:42:49','',''),(1476,'21','238','4',2,'Sale Id shift 127',0.00,0.00,0.00,2136.90,0.00,'2022-07-21 11:35:40','',''),(1477,'21','238','5',2,'Sale Id shift 127',0.00,0.00,0.00,2153.44,0.00,'2022-07-21 11:35:40','',''),(1478,'21','238','5',2,'Sale Id shift 127',0.00,0.00,0.00,269.67,0.00,'2022-07-21 11:35:40','',''),(1479,'21','238',NULL,2,'Sale Id shift 127',3775688.28,0.00,0.00,0.00,0.00,'2022-07-21 11:35:40','',''),(1480,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,13414500.00,16500.00,0.00,0.00,'2022-07-21 12:46:40','',''),(1481,'21','238',NULL,2,'Reception corrector for bridging 178',0.00,0.00,0.00,16500.00,0.00,'2022-07-21 12:48:08','',''),(1482,'21','238','5',2,'Received from bridging 178',0.00,0.00,16500.00,0.00,0.00,'2022-07-21 12:48:08','',''),(1483,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,12195000.00,15000.00,0.00,0.00,'2022-07-21 12:53:00','',''),(1484,'21','238',NULL,2,'Reception corrector for bridging 179',0.00,0.00,0.00,15000.00,0.00,'2022-07-21 12:54:26','',''),(1485,'21','238','4',2,'Received from bridging 179',0.00,0.00,15000.00,0.00,0.00,'2022-07-21 12:54:26','',''),(1486,'21','238','4',2,'Sale Id shift 128',0.00,0.00,0.00,2417.75,0.00,'2022-07-21 12:57:47','',''),(1487,'21','238','5',2,'Sale Id shift 128',0.00,0.00,0.00,1808.18,0.00,'2022-07-21 12:57:47','',''),(1488,'21','238','5',2,'Sale Id shift 128',0.00,0.00,0.00,826.82,0.00,'2022-07-21 12:57:47','',''),(1489,'21','238','6',3,'Sale Id shift 128',0.00,0.00,0.00,77.88,0.00,'2022-07-21 12:57:47','',''),(1490,'21','238','2',1,'Sale Id shift 128',0.00,0.00,0.00,7984.06,0.00,'2022-07-21 12:57:47','',''),(1491,'21','238','2',1,'Sale Id shift 128',0.00,0.00,0.00,8531.31,0.00,'2022-07-21 12:57:47','',''),(1492,'21','238',NULL,1,'Sale Id shift 128',3137920.30,0.00,0.00,0.00,0.00,'2022-07-21 12:57:47','',''),(1493,'21','238',NULL,2,'Sale Id shift 128',4183677.00,0.00,0.00,0.00,0.00,'2022-07-21 12:57:47','',''),(1494,'21','238',NULL,3,'Sale Id shift 128',58410.00,0.00,0.00,0.00,0.00,'2022-07-21 12:57:47','',''),(1495,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2755000.00,14500.00,0.00,0.00,'2022-07-21 17:57:14','',''),(1496,'21','238',NULL,1,'Reception corrector for bridging 180',0.00,0.00,0.00,14500.00,0.00,'2022-07-21 17:59:03','',''),(1497,'21','238','2',1,'Received from bridging 180',0.00,0.00,14500.00,0.00,0.00,'2022-07-21 17:59:03','',''),(1498,'21','238','4',2,'Sale Id shift 129',0.00,0.00,0.00,2953.36,0.00,'2022-07-22 11:35:35','',''),(1499,'21','238','5',2,'Sale Id shift 129',0.00,0.00,0.00,1656.84,0.00,'2022-07-22 11:35:35','',''),(1500,'21','238','5',2,'Sale Id shift 129',0.00,0.00,0.00,481.50,0.00,'2022-07-22 11:35:35','',''),(1501,'21','238','6',3,'Sale Id shift 129',0.00,0.00,0.00,54.71,0.00,'2022-07-22 11:35:35','',''),(1502,'21','238','2',1,'Sale Id shift 129',0.00,0.00,0.00,6059.87,0.00,'2022-07-22 11:35:35','',''),(1503,'21','238','2',1,'Sale Id shift 129',0.00,0.00,0.00,8435.40,0.00,'2022-07-22 11:35:35','',''),(1504,'21','238',NULL,1,'Sale Id shift 129',2754101.30,0.00,0.00,0.00,0.00,'2022-07-22 11:35:35','',''),(1505,'21','238',NULL,2,'Sale Id shift 129',4139552.10,0.00,0.00,0.00,0.00,'2022-07-22 11:35:35','',''),(1506,'21','238',NULL,3,'Sale Id shift 129',41032.50,0.00,0.00,0.00,0.00,'2022-07-22 11:35:35','',''),(1507,'21','238','4',2,'Sale Id shift 130',0.00,0.00,0.00,4914.96,0.00,'2022-07-25 13:14:37','',''),(1508,'21','238','5',2,'Sale Id shift 130',0.00,0.00,0.00,2590.10,0.00,'2022-07-25 13:14:37','',''),(1509,'21','238','5',2,'Sale Id shift 130',0.00,0.00,0.00,1246.55,0.00,'2022-07-25 13:14:37','',''),(1510,'21','238','6',3,'Sale Id shift 130',0.00,0.00,0.00,67.89,0.00,'2022-07-25 13:14:37','',''),(1511,'21','238',NULL,2,'Sale Id shift 130',7115058.93,0.00,0.00,0.00,0.00,'2022-07-25 13:14:37','',''),(1512,'21','238',NULL,3,'Sale Id shift 130',50917.50,0.00,0.00,0.00,0.00,'2022-07-25 13:14:37','',''),(1513,'21','238','4',2,'Sale Id shift 131',0.00,0.00,0.00,3450.10,0.00,'2022-07-25 13:39:40','',''),(1514,'21','238','5',2,'Sale Id shift 131',0.00,0.00,0.00,2097.62,0.00,'2022-07-25 13:39:40','',''),(1515,'21','238','5',2,'Sale Id shift 131',0.00,0.00,0.00,661.66,0.00,'2022-07-25 13:39:40','',''),(1516,'21','238','6',3,'Sale Id shift 131',0.00,0.00,0.00,133.60,0.00,'2022-07-25 13:39:40','',''),(1517,'21','238',NULL,2,'Sale Id shift 131',5048225.94,0.00,0.00,0.00,0.00,'2022-07-25 13:39:40','',''),(1518,'21','238',NULL,3,'Sale Id shift 131',100200.00,0.00,0.00,0.00,0.00,'2022-07-25 13:39:40','',''),(1519,'21','238','4',2,'Sale Id shift 132',0.00,0.00,0.00,2486.73,0.00,'2022-07-25 14:03:28','',''),(1520,'21','238','5',2,'Sale Id shift 132',0.00,0.00,0.00,1932.07,0.00,'2022-07-25 14:03:28','',''),(1521,'21','238','5',2,'Sale Id shift 132',0.00,0.00,0.00,1475.19,0.00,'2022-07-25 14:03:28','',''),(1522,'21','238','6',3,'Sale Id shift 132',0.00,0.00,0.00,83.29,0.00,'2022-07-25 14:03:28','',''),(1523,'21','238',NULL,2,'Sale Id shift 132',4791813.87,0.00,0.00,0.00,0.00,'2022-07-25 14:03:28','',''),(1524,'21','238',NULL,3,'Sale Id shift 132',62467.50,0.00,0.00,0.00,0.00,'2022-07-25 14:03:28','',''),(1525,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,12195000.00,15000.00,0.00,0.00,'2022-07-25 14:06:50','',''),(1526,'21','238',NULL,2,'Reception corrector for bridging 181',0.00,0.00,0.00,15000.00,0.00,'2022-07-25 14:08:28','',''),(1527,'21','238','4',2,'Received from bridging 181',0.00,0.00,15000.00,0.00,0.00,'2022-07-25 14:08:28','',''),(1528,'21','238','4',2,'Sale Id shift 133',0.00,0.00,0.00,3578.37,0.00,'2022-07-26 17:12:47','',''),(1529,'21','238','5',2,'Sale Id shift 133',0.00,0.00,0.00,1525.90,0.00,'2022-07-26 17:12:47','',''),(1530,'21','238','5',2,'Sale Id shift 133',0.00,0.00,0.00,1532.44,0.00,'2022-07-26 17:12:47','',''),(1531,'21','238','6',3,'Sale Id shift 133',0.00,0.00,0.00,109.30,0.00,'2022-07-26 17:12:47','',''),(1532,'21','238',NULL,2,'Sale Id shift 133',5395645.23,0.00,0.00,0.00,0.00,'2022-07-26 17:12:47','',''),(1533,'21','238',NULL,3,'Sale Id shift 133',81975.00,0.00,0.00,0.00,0.00,'2022-07-26 17:12:47','',''),(1534,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5700000.00,30000.00,0.00,0.00,'2022-07-27 18:43:13','',''),(1535,'21','238',NULL,1,'Reception corrector for bridging 183',0.00,0.00,0.00,15000.00,0.00,'2022-07-27 18:47:24','',''),(1536,'21','238','2',1,'Received from bridging 183',0.00,0.00,15000.00,0.00,0.00,'2022-07-27 18:47:24','',''),(1537,'21','238',NULL,1,'Reception corrector for bridging 182',0.00,0.00,0.00,15000.00,0.00,'2022-07-27 18:47:39','',''),(1538,'21','238','1',1,'Received from bridging 182',0.00,0.00,15000.00,0.00,0.00,'2022-07-27 18:47:39','',''),(1539,'21','238','6',3,'Sale Id shift 134',0.00,0.00,0.00,33.78,0.00,'2022-07-27 18:59:30','',''),(1540,'21','238',NULL,3,'Sale Id shift 134',25335.00,0.00,0.00,0.00,0.00,'2022-07-27 18:59:30','',''),(1541,'21','238','1',1,'Sale Id shift 135',0.00,0.00,0.00,3177.60,0.00,'2022-07-27 19:33:43','',''),(1542,'21','238','4',2,'Sale Id shift 135',0.00,0.00,0.00,3191.27,0.00,'2022-07-27 19:33:43','',''),(1543,'21','238','5',2,'Sale Id shift 135',0.00,0.00,0.00,863.16,0.00,'2022-07-27 19:33:43','',''),(1544,'21','238','5',2,'Sale Id shift 135',0.00,0.00,0.00,867.64,0.00,'2022-07-27 19:33:43','',''),(1545,'21','238','6',3,'Sale Id shift 135',0.00,0.00,0.00,48.70,0.00,'2022-07-27 19:33:43','',''),(1546,'21','238','1',1,'Sale Id shift 135',0.00,0.00,0.00,3704.21,0.00,'2022-07-27 19:33:43','',''),(1547,'21','238','2',1,'Sale Id shift 135',0.00,0.00,0.00,4917.87,0.00,'2022-07-27 19:33:43','',''),(1548,'21','238','2',1,'Sale Id shift 135',0.00,0.00,0.00,3679.71,0.00,'2022-07-27 19:33:43','',''),(1549,'21','238',NULL,2,'Sale Id shift 135',4001642.91,0.00,0.00,0.00,0.00,'2022-07-27 19:33:43','',''),(1550,'21','238',NULL,3,'Sale Id shift 135',40664.50,0.00,0.00,0.00,0.00,'2022-07-27 19:33:43','',''),(1551,'21','238',NULL,1,'Sale Id shift 135',2941084.10,0.00,0.00,0.00,0.00,'2022-07-27 19:33:43','',''),(1552,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,3230000.00,17000.00,0.00,0.00,'2022-07-27 19:42:17','',''),(1553,'21','238',NULL,1,'Reception corrector for bridging 184',0.00,0.00,0.00,17000.00,0.00,'2022-07-27 19:43:42','',''),(1554,'21','238','2',1,'Received from bridging 184',0.00,0.00,17000.00,0.00,0.00,'2022-07-27 19:43:42','',''),(1555,'21','238','1',1,'Sale Id shift 136',0.00,0.00,0.00,3261.09,0.00,'2022-07-28 17:30:38','',''),(1556,'21','238','3',1,'Sale Id shift 136',0.00,0.00,0.00,-10.00,0.00,'2022-07-28 17:30:38','',''),(1557,'21','238','4',2,'Sale Id shift 136',0.00,0.00,0.00,3268.16,0.00,'2022-07-28 17:30:38','',''),(1558,'21','238','5',2,'Sale Id shift 136',0.00,0.00,0.00,2573.45,0.00,'2022-07-28 17:30:38','',''),(1559,'21','238','5',2,'Sale Id shift 136',0.00,0.00,0.00,355.30,0.00,'2022-07-28 17:30:38','',''),(1560,'21','238','6',3,'Sale Id shift 136',0.00,0.00,0.00,138.12,0.00,'2022-07-28 17:30:38','',''),(1561,'21','238','1',1,'Sale Id shift 136',0.00,0.00,0.00,4770.11,0.00,'2022-07-28 17:30:38','',''),(1562,'21','238','2',1,'Sale Id shift 136',0.00,0.00,0.00,3048.76,0.00,'2022-07-28 17:30:38','',''),(1563,'21','238','2',1,'Sale Id shift 136',0.00,0.00,0.00,3598.98,0.00,'2022-07-28 17:30:38','',''),(1564,'21','238',NULL,2,'Sale Id shift 136',5038087.83,0.00,0.00,0.00,0.00,'2022-07-28 17:30:38','',''),(1565,'21','238',NULL,3,'Sale Id shift 136',115330.20,0.00,0.00,0.00,0.00,'2022-07-28 17:30:38','',''),(1566,'21','238',NULL,1,'Sale Id shift 136',2787098.60,0.00,0.00,0.00,0.00,'2022-07-28 17:30:38','',''),(1567,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5700000.00,30000.00,0.00,0.00,'2022-07-29 15:18:46','',''),(1568,'21','238',NULL,1,'Reception corrector for bridging 186',0.00,0.00,0.00,16000.00,0.00,'2022-07-29 15:21:45','',''),(1569,'21','238','3',1,'Received from bridging 186',0.00,0.00,16000.00,0.00,0.00,'2022-07-29 15:21:45','',''),(1570,'21','238',NULL,1,'Reception corrector for bridging 185',0.00,0.00,0.00,14000.00,0.00,'2022-07-29 15:21:58','',''),(1571,'21','238','2',1,'Received from bridging 185',0.00,0.00,14000.00,0.00,0.00,'2022-07-29 15:21:58','',''),(1572,'21','238','4',2,'Sale Id shift 137',0.00,0.00,0.00,3949.65,0.00,'2022-07-29 15:33:51','',''),(1573,'21','238','5',2,'Sale Id shift 137',0.00,0.00,0.00,2221.59,0.00,'2022-07-29 15:33:51','',''),(1574,'21','238','5',2,'Sale Id shift 137',0.00,0.00,0.00,1034.19,0.00,'2022-07-29 15:33:51','',''),(1575,'21','238','6',3,'Sale Id shift 137',0.00,0.00,0.00,46.63,0.00,'2022-07-29 15:33:51','',''),(1576,'21','238','2',1,'Sale Id shift 137',0.00,0.00,0.00,7281.18,0.00,'2022-07-29 15:33:51','',''),(1577,'21','238','2',1,'Sale Id shift 137',0.00,0.00,0.00,9772.77,0.00,'2022-07-29 15:33:51','',''),(1578,'21','238',NULL,1,'Sale Id shift 137',3240250.50,0.00,0.00,0.00,0.00,'2022-07-29 15:33:51','',''),(1579,'21','238',NULL,2,'Sale Id shift 137',5858014.59,0.00,0.00,0.00,0.00,'2022-07-29 15:33:51','',''),(1580,'21','238',NULL,3,'Sale Id shift 137',38936.05,0.00,0.00,0.00,0.00,'2022-07-29 15:33:51','',''),(1581,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,27642000.00,34000.00,0.00,0.00,'2022-07-29 15:36:57','',''),(1582,'21','238',NULL,2,'Reception corrector for bridging 188',0.00,0.00,0.00,17000.00,0.00,'2022-07-29 15:38:48','',''),(1583,'21','238','5',2,'Received from bridging 188',0.00,0.00,17000.00,0.00,0.00,'2022-07-29 15:38:48','',''),(1584,'21','238',NULL,2,'Reception corrector for bridging 187',0.00,0.00,0.00,17000.00,0.00,'2022-07-29 15:39:02','',''),(1585,'21','238','4',2,'Received from bridging 187',0.00,0.00,17000.00,0.00,0.00,'2022-07-29 15:39:02','',''),(1586,'21','238','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,13891.97,0.00,'2022-07-29 16:24:26','',''),(1587,'21','238','2',0,'Inventory adjustment from tank dipping to 14400',0.00,0.00,14400.00,0.00,0.00,'2022-07-29 16:24:26','',''),(1588,'21','238','4',2,'Sale Id shift 138',0.00,0.00,0.00,3551.00,0.00,'2022-07-30 18:45:55','',''),(1589,'21','238','5',2,'Sale Id shift 138',0.00,0.00,0.00,3812.86,0.00,'2022-07-30 18:45:55','',''),(1590,'21','238','5',2,'Sale Id shift 138',0.00,0.00,0.00,797.32,0.00,'2022-07-30 18:45:55','',''),(1591,'21','238','6',3,'Sale Id shift 138',0.00,0.00,0.00,46.60,0.00,'2022-07-30 18:45:55','',''),(1592,'21','238','2',1,'Sale Id shift 138',0.00,0.00,0.00,5866.88,0.00,'2022-07-30 18:45:55','',''),(1593,'21','238','2',1,'Sale Id shift 138',0.00,0.00,0.00,2961.78,0.00,'2022-07-30 18:45:55','',''),(1594,'21','238','3',1,'Sale Id shift 138',0.00,0.00,0.00,2545.39,0.00,'2022-07-30 18:45:55','',''),(1595,'21','238',NULL,1,'Sale Id shift 138',2161069.50,0.00,0.00,0.00,0.00,'2022-07-30 18:45:55','',''),(1596,'21','238',NULL,2,'Sale Id shift 138',6635039.34,0.00,0.00,0.00,0.00,'2022-07-30 18:45:55','',''),(1597,'21','238',NULL,3,'Sale Id shift 138',38911.00,0.00,0.00,0.00,0.00,'2022-07-30 18:45:55','',''),(1598,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2128000.00,11200.00,0.00,0.00,'2022-08-02 15:57:06','',''),(1599,'21','238',NULL,1,'Reception corrector for bridging 189',0.00,0.00,0.00,11200.00,0.00,'2022-08-02 15:58:42','',''),(1600,'21','238','2',1,'Received from bridging 189',0.00,0.00,11200.00,0.00,0.00,'2022-08-02 15:58:42','',''),(1601,'21','238','3',1,'Sale Id shift 139',0.00,0.00,0.00,3919.34,0.00,'2022-08-02 16:26:35','',''),(1602,'21','238','4',2,'Sale Id shift 139',0.00,0.00,0.00,2414.21,0.00,'2022-08-02 16:26:35','',''),(1603,'21','238','5',2,'Sale Id shift 139',0.00,0.00,0.00,1365.18,0.00,'2022-08-02 16:26:35','',''),(1604,'21','238','5',2,'Sale Id shift 139',0.00,0.00,0.00,66.33,0.00,'2022-08-02 16:26:35','',''),(1605,'21','238','6',3,'Sale Id shift 139',0.00,0.00,0.00,58.28,0.00,'2022-08-02 16:26:35','',''),(1606,'21','238','2',1,'Sale Id shift 139',0.00,0.00,0.00,3317.74,0.00,'2022-08-02 16:26:35','',''),(1607,'21','238','2',1,'Sale Id shift 139',0.00,0.00,0.00,2322.04,0.00,'2022-08-02 16:26:35','',''),(1608,'21','238','3',1,'Sale Id shift 139',0.00,0.00,0.00,5127.85,0.00,'2022-08-02 16:26:35','',''),(1609,'21','238',NULL,1,'Sale Id shift 139',2790524.30,0.00,0.00,0.00,0.00,'2022-08-02 16:26:35','',''),(1610,'21','238',NULL,2,'Sale Id shift 139',3126570.36,0.00,0.00,0.00,0.00,'2022-08-02 16:26:35','',''),(1611,'21','238',NULL,3,'Sale Id shift 139',48663.80,0.00,0.00,0.00,0.00,'2022-08-02 16:26:35','',''),(1612,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2850000.00,15000.00,0.00,0.00,'2022-08-02 16:44:41','',''),(1613,'21','238',NULL,1,'Reception corrector for bridging 190',0.00,0.00,0.00,15000.00,0.00,'2022-08-02 16:47:11','',''),(1614,'21','238','2',1,'Received from bridging 190',0.00,0.00,15000.00,0.00,0.00,'2022-08-02 16:47:11','',''),(1615,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2850000.00,15000.00,0.00,0.00,'2022-08-02 16:59:22','',''),(1616,'21','238',NULL,1,'Reception corrector for bridging 191',0.00,0.00,0.00,15000.00,0.00,'2022-08-02 17:01:22','',''),(1617,'21','238','3',1,'Received from bridging 191',0.00,0.00,15000.00,0.00,0.00,'2022-08-02 17:01:22','',''),(1618,'21','238','3',1,'Sale Id shift 140',0.00,0.00,0.00,7832.99,0.00,'2022-08-02 17:16:15','',''),(1619,'21','238','4',2,'Sale Id shift 140',0.00,0.00,0.00,3136.22,0.00,'2022-08-02 17:16:15','',''),(1620,'21','238','5',2,'Sale Id shift 140',0.00,0.00,0.00,1289.98,0.00,'2022-08-02 17:16:15','',''),(1621,'21','238','5',2,'Sale Id shift 140',0.00,0.00,0.00,1179.03,0.00,'2022-08-02 17:16:15','',''),(1622,'21','238','6',3,'Sale Id shift 140',0.00,0.00,0.00,112.13,0.00,'2022-08-02 17:16:15','',''),(1623,'21','238','3',1,'Sale Id shift 140',0.00,0.00,0.00,8036.05,0.00,'2022-08-02 17:16:15','',''),(1624,'21','238',NULL,1,'Sale Id shift 140',3015117.60,0.00,0.00,0.00,0.00,'2022-08-02 17:16:15','',''),(1625,'21','238',NULL,2,'Sale Id shift 140',4557051.99,0.00,0.00,0.00,0.00,'2022-08-02 17:16:15','',''),(1626,'21','238',NULL,3,'Sale Id shift 140',93628.55,0.00,0.00,0.00,0.00,'2022-08-02 17:16:15','',''),(1627,'21','238','4',2,'Sale Id shift 141',0.00,0.00,0.00,5681.92,0.00,'2022-08-02 17:40:03','',''),(1628,'21','238','5',2,'Sale Id shift 141',0.00,0.00,0.00,3167.20,0.00,'2022-08-02 17:40:03','',''),(1629,'21','238','5',2,'Sale Id shift 141',0.00,0.00,0.00,1147.24,0.00,'2022-08-02 17:40:03','',''),(1630,'21','238','6',3,'Sale Id shift 141',0.00,0.00,0.00,69.67,0.00,'2022-08-02 17:40:03','',''),(1631,'21','238','2',1,'Sale Id shift 141',0.00,0.00,0.00,9234.28,0.00,'2022-08-02 17:40:03','',''),(1632,'21','238','2',1,'Sale Id shift 141',0.00,0.00,0.00,5864.81,0.00,'2022-08-02 17:40:03','',''),(1633,'21','238',NULL,1,'Sale Id shift 141',2868827.10,0.00,0.00,0.00,0.00,'2022-08-02 17:40:03','',''),(1634,'21','238',NULL,2,'Sale Id shift 141',8127040.68,0.00,0.00,0.00,0.00,'2022-08-02 17:40:03','',''),(1635,'21','238',NULL,3,'Sale Id shift 141',58174.45,0.00,0.00,0.00,0.00,'2022-08-02 17:40:03','',''),(1636,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5700000.00,30000.00,0.00,0.00,'2022-08-03 15:00:24','',''),(1637,'21','238',NULL,1,'Reception corrector for bridging 192',0.00,0.00,0.00,3800.00,0.00,'2022-08-03 15:03:40','',''),(1638,'21','238','2',1,'Received from bridging 192',0.00,0.00,3800.00,0.00,0.00,'2022-08-03 15:03:40','',''),(1639,'21','238',NULL,1,'Reception corrector for bridging 193',0.00,0.00,0.00,26200.00,0.00,'2022-08-03 15:03:52','',''),(1640,'21','238','3',1,'Received from bridging 193',0.00,0.00,26200.00,0.00,0.00,'2022-08-03 15:03:52','',''),(1641,'21','238','3',1,'Sale Id shift 142',0.00,0.00,0.00,7328.68,0.00,'2022-08-04 14:37:17','',''),(1642,'21','238','4',2,'Sale Id shift 142',0.00,0.00,0.00,1582.74,0.00,'2022-08-04 14:37:17','',''),(1643,'21','238','5',2,'Sale Id shift 142',0.00,0.00,0.00,1587.17,0.00,'2022-08-04 14:37:17','',''),(1644,'21','238','5',2,'Sale Id shift 142',0.00,0.00,0.00,292.00,0.00,'2022-08-04 14:37:17','',''),(1645,'21','238','6',3,'Sale Id shift 142',0.00,0.00,0.00,92.27,0.00,'2022-08-04 14:37:17','',''),(1646,'21','238','3',1,'Sale Id shift 142',0.00,0.00,0.00,7710.49,0.00,'2022-08-04 14:37:17','',''),(1647,'21','238',NULL,1,'Sale Id shift 142',2857442.30,0.00,0.00,0.00,0.00,'2022-08-04 14:37:17','',''),(1648,'21','238',NULL,2,'Sale Id shift 142',2814532.83,0.00,0.00,0.00,0.00,'2022-08-04 14:37:17','',''),(1649,'21','238',NULL,3,'Sale Id shift 142',77045.45,0.00,0.00,0.00,0.00,'2022-08-04 14:37:17','',''),(1650,'21','238','3',1,'Sale Id shift 143',0.00,0.00,0.00,4269.29,0.00,'2022-08-04 14:55:21','',''),(1651,'21','238','4',2,'Sale Id shift 143',0.00,0.00,0.00,4401.45,0.00,'2022-08-04 14:55:22','',''),(1652,'21','238','5',2,'Sale Id shift 143',0.00,0.00,0.00,3864.91,0.00,'2022-08-04 14:55:22','',''),(1653,'21','238','5',2,'Sale Id shift 143',0.00,0.00,0.00,933.65,0.00,'2022-08-04 14:55:22','',''),(1654,'21','238','6',3,'Sale Id shift 143',0.00,0.00,0.00,79.45,0.00,'2022-08-04 14:55:22','',''),(1655,'21','238','2',1,'Sale Id shift 143',0.00,0.00,0.00,6011.45,0.00,'2022-08-04 14:55:22','',''),(1656,'21','238','2',1,'Sale Id shift 143',0.00,0.00,0.00,6375.69,0.00,'2022-08-04 14:55:22','',''),(1657,'21','238','3',1,'Sale Id shift 143',0.00,0.00,0.00,4210.00,0.00,'2022-08-04 14:55:22','',''),(1658,'21','238',NULL,1,'Sale Id shift 143',3964621.70,0.00,0.00,0.00,0.00,'2022-08-04 14:55:22','',''),(1659,'21','238',NULL,2,'Sale Id shift 143',7479608.13,0.00,0.00,0.00,0.00,'2022-08-04 14:55:22','',''),(1660,'21','238',NULL,3,'Sale Id shift 143',66340.75,0.00,0.00,0.00,0.00,'2022-08-04 14:55:22','',''),(1661,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5700000.00,30000.00,0.00,0.00,'2022-08-05 19:47:58','',''),(1662,'21','238',NULL,1,'Reception corrector for bridging 195',0.00,0.00,0.00,15000.00,0.00,'2022-08-05 19:50:21','',''),(1663,'21','238','3',1,'Received from bridging 195',0.00,0.00,15000.00,0.00,0.00,'2022-08-05 19:50:21','',''),(1664,'21','238',NULL,1,'Reception corrector for bridging 194',0.00,0.00,0.00,15000.00,0.00,'2022-08-05 19:50:34','',''),(1665,'21','238','2',1,'Received from bridging 194',0.00,0.00,15000.00,0.00,0.00,'2022-08-05 19:50:34','',''),(1666,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2850000.00,15000.00,0.00,0.00,'2022-08-07 17:36:33','',''),(1667,'21','238',NULL,1,'Reception corrector for bridging 196',0.00,0.00,0.00,15000.00,0.00,'2022-08-07 17:43:11','',''),(1668,'21','238','2',1,'Received from bridging 196',0.00,0.00,15000.00,0.00,0.00,'2022-08-07 17:43:11','',''),(1669,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,13414500.00,16500.00,0.00,0.00,'2022-08-07 17:46:05','',''),(1670,'21','238',NULL,2,'Reception corrector for bridging 197',0.00,0.00,0.00,16500.00,0.00,'2022-08-07 17:48:11','',''),(1671,'21','238','5',2,'Received from bridging 197',0.00,0.00,16500.00,0.00,0.00,'2022-08-07 17:48:11','',''),(1672,'21','238','3',1,'Sale Id shift 145',0.00,0.00,0.00,3469.53,0.00,'2022-08-07 18:22:50','',''),(1673,'21','238','4',2,'Sale Id shift 145',0.00,0.00,0.00,2732.64,0.00,'2022-08-07 18:22:50','',''),(1674,'21','238','5',2,'Sale Id shift 145',0.00,0.00,0.00,2699.99,0.00,'2022-08-07 18:22:50','',''),(1675,'21','238','5',2,'Sale Id shift 145',0.00,0.00,0.00,2098.63,0.00,'2022-08-07 18:22:50','',''),(1676,'21','238','6',3,'Sale Id shift 145',0.00,0.00,0.00,79.96,0.00,'2022-08-07 18:22:50','',''),(1677,'21','238','2',1,'Sale Id shift 145',0.00,0.00,0.00,837.21,0.00,'2022-08-07 18:22:50','',''),(1678,'21','238','2',1,'Sale Id shift 145',0.00,0.00,0.00,1566.74,0.00,'2022-08-07 18:22:50','',''),(1679,'21','238','3',1,'Sale Id shift 145',0.00,0.00,0.00,3143.74,0.00,'2022-08-07 18:22:50','',''),(1680,'21','238',NULL,1,'Sale Id shift 145',1713271.80,0.00,0.00,0.00,0.00,'2022-08-07 18:22:50','',''),(1681,'21','238',NULL,2,'Sale Id shift 145',6122914.38,0.00,0.00,0.00,0.00,'2022-08-07 18:22:50','',''),(1682,'21','238',NULL,3,'Sale Id shift 145',66766.60,0.00,0.00,0.00,0.00,'2022-08-07 18:22:50','',''),(1683,'21','238','3',1,'Sale Id shift 146',0.00,0.00,0.00,6510.62,0.00,'2022-08-08 09:50:21','',''),(1684,'21','238','4',2,'Sale Id shift 146',0.00,0.00,0.00,5489.28,0.00,'2022-08-08 09:50:21','',''),(1685,'21','238','6',3,'Sale Id shift 146',0.00,0.00,0.00,96.19,0.00,'2022-08-08 09:50:21','',''),(1686,'21','238','2',1,'Sale Id shift 146',0.00,0.00,0.00,7296.13,0.00,'2022-08-08 09:50:21','',''),(1687,'21','238','2',1,'Sale Id shift 146',0.00,0.00,0.00,7828.99,0.00,'2022-08-08 09:50:21','',''),(1688,'21','238','3',1,'Sale Id shift 146',0.00,0.00,0.00,7751.59,0.00,'2022-08-08 09:50:21','',''),(1689,'21','238',NULL,2,'Sale Id shift 146',4462784.64,0.00,0.00,0.00,0.00,'2022-08-08 09:50:21','',''),(1690,'21','238',NULL,3,'Sale Id shift 146',80318.65,0.00,0.00,0.00,0.00,'2022-08-08 09:50:21','',''),(1691,'21','238',NULL,1,'Sale Id shift 146',5583592.70,0.00,0.00,0.00,0.00,'2022-08-08 09:50:21','',''),(1692,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2850000.00,15000.00,0.00,0.00,'2022-08-08 09:56:10','',''),(1693,'21','238',NULL,1,'Reception corrector for bridging 198',0.00,0.00,0.00,15000.00,0.00,'2022-08-08 09:57:20','',''),(1694,'21','238','2',1,'Received from bridging 198',0.00,0.00,15000.00,0.00,0.00,'2022-08-08 09:57:20','',''),(1695,'21','238','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,29916.26,0.00,'2022-08-08 16:53:52','',''),(1696,'21','238','2',0,'Inventory adjustment from tank dipping to 30916',0.00,0.00,30916.00,0.00,0.00,'2022-08-08 16:53:52','',''),(1697,'21','238','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,2386.28,0.00,'2022-08-08 16:54:28','',''),(1698,'21','238','4',0,'Inventory adjustment from tank dipping to 3587',0.00,0.00,3587.00,0.00,0.00,'2022-08-08 16:54:28','',''),(1699,'21','238','5',0,'Tank level zero out for dipping',0.00,0.00,0.00,14991.19,0.00,'2022-08-08 16:54:55','',''),(1700,'21','238','5',0,'Inventory adjustment from tank dipping to 16991',0.00,0.00,16991.00,0.00,0.00,'2022-08-08 16:54:55','',''),(1701,'21','238','4',2,'Sale Id shift 147',0.00,0.00,0.00,3144.22,0.00,'2022-08-08 17:16:57','',''),(1702,'21','238','6',3,'Sale Id shift 147',0.00,0.00,0.00,51.63,0.00,'2022-08-08 17:16:57','',''),(1703,'21','238','2',1,'Sale Id shift 147',0.00,0.00,0.00,7977.36,0.00,'2022-08-08 17:16:57','',''),(1704,'21','238','2',1,'Sale Id shift 147',0.00,0.00,0.00,7112.70,0.00,'2022-08-08 17:16:57','',''),(1705,'21','238',NULL,1,'Sale Id shift 147',2867111.40,0.00,0.00,0.00,0.00,'2022-08-08 17:16:57','',''),(1706,'21','238',NULL,2,'Sale Id shift 147',2556250.86,0.00,0.00,0.00,0.00,'2022-08-08 17:16:57','',''),(1707,'21','238',NULL,3,'Sale Id shift 147',43111.05,0.00,0.00,0.00,0.00,'2022-08-08 17:16:57','',''),(1708,'21','238','5',2,'Sale Id shift 148',0.00,0.00,0.00,1701.76,0.00,'2022-08-09 11:33:12','',''),(1709,'21','238','5',2,'Sale Id shift 148',0.00,0.00,0.00,1495.70,0.00,'2022-08-09 11:33:12','',''),(1710,'21','238','6',3,'Sale Id shift 148',0.00,0.00,0.00,49.61,0.00,'2022-08-09 11:33:12','',''),(1711,'21','238','2',1,'Sale Id shift 148',0.00,0.00,0.00,7296.64,0.00,'2022-08-09 11:33:12','',''),(1712,'21','238','2',1,'Sale Id shift 148',0.00,0.00,0.00,7733.88,0.00,'2022-08-09 11:33:12','',''),(1713,'21','238',NULL,1,'Sale Id shift 148',2855798.80,0.00,0.00,0.00,0.00,'2022-08-09 11:33:12','',''),(1714,'21','238',NULL,2,'Sale Id shift 148',2599534.98,0.00,0.00,0.00,0.00,'2022-08-09 11:33:12','',''),(1715,'21','238',NULL,3,'Sale Id shift 148',41424.35,0.00,0.00,0.00,0.00,'2022-08-09 11:33:12','',''),(1716,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2850000.00,15000.00,0.00,0.00,'2022-08-09 12:37:10','',''),(1717,'21','238',NULL,1,'Reception corrector for bridging 199',0.00,0.00,0.00,15000.00,0.00,'2022-08-09 12:40:12','',''),(1718,'21','238','2',1,'Received from bridging 199',0.00,0.00,15000.00,0.00,0.00,'2022-08-09 12:40:12','',''),(1719,'21','238','5',2,'Sale Id shift 149',0.00,0.00,0.00,3053.83,0.00,'2022-08-10 17:30:03','',''),(1720,'21','238','5',2,'Sale Id shift 149',0.00,0.00,0.00,2308.27,0.00,'2022-08-10 17:30:03','',''),(1721,'21','238','6',3,'Sale Id shift 149',0.00,0.00,0.00,57.37,0.00,'2022-08-10 17:30:03','',''),(1722,'21','238',NULL,2,'Sale Id shift 149',4359387.30,0.00,0.00,0.00,0.00,'2022-08-10 17:30:03','',''),(1723,'21','238',NULL,3,'Sale Id shift 149',47903.95,0.00,0.00,0.00,0.00,'2022-08-10 17:30:03','',''),(1724,'21','238','5',2,'Sale Id shift 150',0.00,0.00,0.00,4741.31,0.00,'2022-08-10 18:19:32','',''),(1725,'21','238','5',2,'Sale Id shift 150',0.00,0.00,0.00,3367.75,0.00,'2022-08-10 18:19:32','',''),(1726,'21','238','6',3,'Sale Id shift 150',0.00,0.00,0.00,53.52,0.00,'2022-08-10 18:19:32','',''),(1727,'21','238','2',1,'Sale Id shift 150',0.00,0.00,0.00,7110.97,0.00,'2022-08-10 18:19:32','',''),(1728,'21','238','2',1,'Sale Id shift 150',0.00,0.00,0.00,7984.34,0.00,'2022-08-10 18:19:32','',''),(1729,'21','238',NULL,1,'Sale Id shift 150',2868108.90,0.00,0.00,0.00,0.00,'2022-08-10 18:19:32','',''),(1730,'21','238',NULL,2,'Sale Id shift 150',6592665.78,0.00,0.00,0.00,0.00,'2022-08-10 18:19:32','',''),(1731,'21','238',NULL,3,'Sale Id shift 150',44689.20,0.00,0.00,0.00,0.00,'2022-08-10 18:19:32','',''),(1732,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,12195000.00,15000.00,0.00,0.00,'2022-08-10 18:31:28','',''),(1733,'21','238',NULL,2,'Reception corrector for bridging 200',0.00,0.00,0.00,15000.00,0.00,'2022-08-10 18:40:34','',''),(1734,'21','238','4',2,'Received from bridging 200',0.00,0.00,15000.00,0.00,0.00,'2022-08-10 18:40:34','',''),(1735,'21','238','4',2,'Sale Id shift 151',0.00,0.00,0.00,7495.95,0.00,'2022-08-11 16:44:18','',''),(1736,'21','238','6',3,'Sale Id shift 151',0.00,0.00,0.00,23.79,0.00,'2022-08-11 16:44:18','',''),(1737,'21','238',NULL,2,'Sale Id shift 151',6094207.35,0.00,0.00,0.00,0.00,'2022-08-11 16:44:18','',''),(1738,'21','238',NULL,3,'Sale Id shift 151',19864.65,0.00,0.00,0.00,0.00,'2022-08-11 16:44:18','',''),(1739,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5700000.00,30000.00,0.00,0.00,'2022-08-12 15:32:03','',''),(1740,'21','238',NULL,1,'Reception corrector for bridging 202',0.00,0.00,0.00,15000.00,0.00,'2022-08-12 15:36:34','',''),(1741,'21','238','2',1,'Received from bridging 202',0.00,0.00,15000.00,0.00,0.00,'2022-08-12 15:36:34','',''),(1742,'21','238',NULL,1,'Reception corrector for bridging 201',0.00,0.00,0.00,15000.00,0.00,'2022-08-12 15:36:48','',''),(1743,'21','238','1',1,'Received from bridging 201',0.00,0.00,15000.00,0.00,0.00,'2022-08-12 15:36:48','',''),(1744,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,24390000.00,30000.00,0.00,0.00,'2022-08-12 15:41:07','',''),(1745,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,24390000.00,30000.00,0.00,0.00,'2022-08-12 15:51:13','',''),(1746,'21','238',NULL,2,'Reception corrector for bridging 203',0.00,0.00,0.00,30000.00,0.00,'2022-08-12 15:53:06','',''),(1747,'21','238','5',2,'Received from bridging 203',0.00,0.00,30000.00,0.00,0.00,'2022-08-12 15:53:06','',''),(1748,'21','238','1',1,'Returned bridging 201',0.00,0.00,0.00,15000.00,0.00,'2022-08-12 17:02:43','',''),(1749,'21','238',NULL,1,'Reception Return corrector for bridging 201',0.00,0.00,15000.00,0.00,0.00,'2022-08-12 17:02:43','',''),(1750,'21','238',NULL,1,'Reception corrector for bridging 205',0.00,0.00,0.00,15000.00,0.00,'2022-08-12 17:06:20','',''),(1751,'21','238','3',1,'Received from bridging 205',0.00,0.00,15000.00,0.00,0.00,'2022-08-12 17:06:20','',''),(1752,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2945000.00,15500.00,0.00,0.00,'2022-08-12 17:15:26','',''),(1753,'21','238',NULL,1,'Reception corrector for bridging 206',0.00,0.00,0.00,15500.00,0.00,'2022-08-12 17:18:28','',''),(1754,'21','238','2',1,'Received from bridging 206',0.00,0.00,15500.00,0.00,0.00,'2022-08-12 17:18:28','',''),(1755,'21','238','3',1,'Sale Id shift 152',0.00,0.00,0.00,4148.59,0.00,'2022-08-12 17:50:20','',''),(1756,'21','238','4',2,'Sale Id shift 152',0.00,0.00,0.00,6868.58,0.00,'2022-08-12 17:50:20','',''),(1757,'21','238','5',2,'Sale Id shift 152',0.00,0.00,0.00,1240.91,0.00,'2022-08-12 17:50:20','',''),(1758,'21','238','5',2,'Sale Id shift 152',0.00,0.00,0.00,753.81,0.00,'2022-08-12 17:50:20','',''),(1759,'21','238','6',3,'Sale Id shift 152',0.00,0.00,0.00,42.51,0.00,'2022-08-12 17:50:20','',''),(1760,'21','238','2',1,'Sale Id shift 152',0.00,0.00,0.00,5553.45,0.00,'2022-08-12 17:50:20','',''),(1761,'21','238','2',1,'Sale Id shift 152',0.00,0.00,0.00,3971.37,0.00,'2022-08-12 17:50:20','',''),(1762,'21','238','3',1,'Sale Id shift 152',0.00,0.00,0.00,5436.48,0.00,'2022-08-12 17:50:20','',''),(1763,'21','238',NULL,1,'Sale Id shift 152',3630879.10,0.00,0.00,0.00,0.00,'2022-08-12 17:50:20','',''),(1764,'21','238',NULL,2,'Sale Id shift 152',7205862.90,0.00,0.00,0.00,0.00,'2022-08-12 17:50:20','',''),(1765,'21','238',NULL,3,'Sale Id shift 152',35495.85,0.00,0.00,0.00,0.00,'2022-08-12 17:50:20','',''),(1766,'21','238',NULL,2,'Reception corrector for bridging 204',0.00,0.00,0.00,30000.00,0.00,'2022-08-12 17:51:25','',''),(1767,'21','238','4',2,'Received from bridging 204',0.00,0.00,30000.00,0.00,0.00,'2022-08-12 17:51:25','',''),(1768,'21','238','6',3,'Sale Id shift 153',0.00,0.00,0.00,20.52,0.00,'2022-08-15 12:45:49','',''),(1769,'21','238',NULL,3,'Sale Id shift 153',17134.20,0.00,0.00,0.00,0.00,'2022-08-15 12:45:49','',''),(1770,'21','238','3',1,'Sale Id shift 154',0.00,0.00,0.00,2813.52,0.00,'2022-08-15 13:10:24','',''),(1771,'21','238','4',2,'Sale Id shift 154',0.00,0.00,0.00,4638.14,0.00,'2022-08-15 13:10:24','',''),(1772,'21','238','5',2,'Sale Id shift 154',0.00,0.00,0.00,4305.15,0.00,'2022-08-15 13:10:24','',''),(1773,'21','238','5',2,'Sale Id shift 154',0.00,0.00,0.00,769.84,0.00,'2022-08-15 13:10:24','',''),(1774,'21','238','6',3,'Sale Id shift 154',0.00,0.00,0.00,24.66,0.00,'2022-08-15 13:10:24','',''),(1775,'21','238','2',1,'Sale Id shift 154',0.00,0.00,0.00,7131.40,0.00,'2022-08-15 13:10:24','',''),(1776,'21','238','2',1,'Sale Id shift 154',0.00,0.00,0.00,7742.82,0.00,'2022-08-15 13:10:24','',''),(1777,'21','238','3',1,'Sale Id shift 154',0.00,0.00,0.00,2555.94,0.00,'2022-08-15 13:10:24','',''),(1778,'21','238',NULL,2,'Sale Id shift 154',7896774.69,0.00,0.00,0.00,0.00,'2022-08-15 13:10:24','',''),(1779,'21','238',NULL,3,'Sale Id shift 154',20961.00,0.00,0.00,0.00,0.00,'2022-08-15 13:10:24','',''),(1780,'21','238',NULL,1,'Sale Id shift 154',3846299.20,0.00,0.00,0.00,0.00,'2022-08-15 13:10:24','',''),(1781,'21','238','4',2,'Sale Id shift 155',0.00,0.00,0.00,2401.35,0.00,'2022-08-15 13:52:44','',''),(1782,'21','238','5',2,'Sale Id shift 155',0.00,0.00,0.00,1819.30,0.00,'2022-08-15 13:52:44','',''),(1783,'21','238','5',2,'Sale Id shift 155',0.00,0.00,0.00,398.10,0.00,'2022-08-15 13:52:44','',''),(1784,'21','238','6',3,'Sale Id shift 155',0.00,0.00,0.00,31.14,0.00,'2022-08-15 13:52:44','',''),(1785,'21','238','2',1,'Sale Id shift 155',0.00,0.00,0.00,1905.62,0.00,'2022-08-15 13:52:44','',''),(1786,'21','238','2',1,'Sale Id shift 155',0.00,0.00,0.00,4050.09,0.00,'2022-08-15 13:52:44','',''),(1787,'21','238',NULL,1,'Sale Id shift 155',1131584.90,0.00,0.00,0.00,0.00,'2022-08-15 13:52:44','',''),(1788,'21','238',NULL,2,'Sale Id shift 155',3755043.75,0.00,0.00,0.00,0.00,'2022-08-15 13:52:44','',''),(1789,'21','238',NULL,3,'Sale Id shift 155',26469.00,0.00,0.00,0.00,0.00,'2022-08-15 13:52:44','',''),(1790,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2660000.00,14000.00,0.00,0.00,'2022-08-15 14:30:33','',''),(1791,'21','238',NULL,1,'Reception corrector for bridging 207',0.00,0.00,0.00,14000.00,0.00,'2022-08-15 14:32:38','',''),(1792,'21','238','2',1,'Received from bridging 207',0.00,0.00,14000.00,0.00,0.00,'2022-08-15 14:32:38','',''),(1793,'21','238','4',2,'Sale Id shift 156',0.00,0.00,0.00,2391.91,0.00,'2022-08-15 19:41:36','',''),(1794,'21','238','5',2,'Sale Id shift 156',0.00,0.00,0.00,1408.68,0.00,'2022-08-15 19:41:36','',''),(1795,'21','238','5',2,'Sale Id shift 156',0.00,0.00,0.00,1329.21,0.00,'2022-08-15 19:41:36','',''),(1796,'21','238','6',3,'Sale Id shift 156',0.00,0.00,0.00,54.00,0.00,'2022-08-15 19:41:36','',''),(1797,'21','238','2',1,'Sale Id shift 156',0.00,0.00,0.00,5779.16,0.00,'2022-08-15 19:41:36','',''),(1798,'21','238','2',1,'Sale Id shift 156',0.00,0.00,0.00,8213.67,0.00,'2022-08-15 19:41:36','',''),(1799,'21','238',NULL,1,'Sale Id shift 156',2658637.70,0.00,0.00,0.00,0.00,'2022-08-15 19:41:36','',''),(1800,'21','238',NULL,2,'Sale Id shift 156',4170527.40,0.00,0.00,0.00,0.00,'2022-08-15 19:41:36','',''),(1801,'21','238',NULL,3,'Sale Id shift 156',45900.00,0.00,0.00,0.00,0.00,'2022-08-15 19:41:36','',''),(1802,'21','238','4',2,'Sale Id shift 157',0.00,0.00,0.00,1787.49,0.00,'2022-08-16 19:34:48','',''),(1803,'21','238','5',2,'Sale Id shift 157',0.00,0.00,0.00,2210.29,0.00,'2022-08-16 19:34:48','',''),(1804,'21','238','5',2,'Sale Id shift 157',0.00,0.00,0.00,800.78,0.00,'2022-08-16 19:34:48','',''),(1805,'21','238','6',3,'Sale Id shift 157',0.00,0.00,0.00,38.82,0.00,'2022-08-16 19:34:48','',''),(1806,'21','238',NULL,2,'Sale Id shift 157',3901229.28,0.00,0.00,0.00,0.00,'2022-08-16 19:34:48','',''),(1807,'21','238',NULL,3,'Sale Id shift 157',32997.00,0.00,0.00,0.00,0.00,'2022-08-16 19:34:48','',''),(1808,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,4921000.00,25900.00,0.00,0.00,'2022-08-16 19:49:50','',''),(1809,'21','238',NULL,1,'Reception corrector for bridging 209',0.00,0.00,0.00,12900.00,0.00,'2022-08-17 09:39:20','',''),(1810,'21','238','3',1,'Received from bridging 209',0.00,0.00,12900.00,0.00,0.00,'2022-08-17 09:39:20','',''),(1811,'21','238',NULL,1,'Reception corrector for bridging 208',0.00,0.00,0.00,13000.00,0.00,'2022-08-17 09:39:31','',''),(1812,'21','238','2',1,'Received from bridging 208',0.00,0.00,13000.00,0.00,0.00,'2022-08-17 09:39:31','',''),(1813,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5700000.00,30000.00,0.00,0.00,'2022-08-17 09:41:58','',''),(1814,'21','238',NULL,1,'Reception corrector for bridging 210',0.00,0.00,0.00,18000.00,0.00,'2022-08-17 09:50:24','',''),(1815,'21','238','1',1,'Received from bridging 210',0.00,0.00,18000.00,0.00,0.00,'2022-08-17 09:50:24','',''),(1816,'21','238',NULL,1,'Reception corrector for bridging 211',0.00,0.00,0.00,12000.00,0.00,'2022-08-17 09:50:42','',''),(1817,'21','238','2',1,'Received from bridging 211',0.00,0.00,12000.00,0.00,0.00,'2022-08-17 09:50:42','',''),(1818,'21','238','3',1,'Sale Id shift 158',0.00,0.00,0.00,1692.41,0.00,'2022-08-17 11:04:34','',''),(1819,'21','238','4',2,'Sale Id shift 158',0.00,0.00,0.00,4384.73,0.00,'2022-08-17 11:04:34','',''),(1820,'21','238','5',2,'Sale Id shift 158',0.00,0.00,0.00,2251.85,0.00,'2022-08-17 11:04:34','',''),(1821,'21','238','5',2,'Sale Id shift 158',0.00,0.00,0.00,1547.52,0.00,'2022-08-17 11:04:34','',''),(1822,'21','238','6',3,'Sale Id shift 158',0.00,0.00,0.00,49.57,0.00,'2022-08-17 11:04:34','',''),(1823,'21','238','2',1,'Sale Id shift 158',0.00,0.00,0.00,2382.93,0.00,'2022-08-17 11:04:34','',''),(1824,'21','238','2',1,'Sale Id shift 158',0.00,0.00,0.00,2029.01,0.00,'2022-08-17 11:04:34','',''),(1825,'21','238','3',1,'Sale Id shift 158',0.00,0.00,0.00,1616.00,0.00,'2022-08-17 11:04:34','',''),(1826,'21','238',NULL,1,'Sale Id shift 158',1466866.50,0.00,0.00,0.00,0.00,'2022-08-17 11:04:34','',''),(1827,'21','238',NULL,2,'Sale Id shift 158',6653673.30,0.00,0.00,0.00,0.00,'2022-08-17 11:04:34','',''),(1828,'21','238',NULL,3,'Sale Id shift 158',42134.50,0.00,0.00,0.00,0.00,'2022-08-17 11:04:34','',''),(1829,'21','238','1',1,'Sale Id shift 159',0.00,0.00,0.00,2040.01,0.00,'2022-08-18 19:34:42','',''),(1830,'21','238','3',1,'Sale Id shift 159',0.00,0.00,0.00,2439.51,0.00,'2022-08-18 19:34:42','',''),(1831,'21','238','4',2,'Sale Id shift 159',0.00,0.00,0.00,6401.44,0.00,'2022-08-18 19:34:42','',''),(1832,'21','238','5',2,'Sale Id shift 159',0.00,0.00,0.00,1473.59,0.00,'2022-08-18 19:34:42','',''),(1833,'21','238','5',2,'Sale Id shift 159',0.00,0.00,0.00,158.97,0.00,'2022-08-18 19:34:42','',''),(1834,'21','238','6',3,'Sale Id shift 159',0.00,0.00,0.00,41.56,0.00,'2022-08-18 19:34:42','',''),(1835,'21','238','1',1,'Sale Id shift 159',0.00,0.00,0.00,953.29,0.00,'2022-08-18 19:34:42','',''),(1836,'21','238','2',1,'Sale Id shift 159',0.00,0.00,0.00,3262.29,0.00,'2022-08-18 19:34:42','',''),(1837,'21','238','2',1,'Sale Id shift 159',0.00,0.00,0.00,2521.49,0.00,'2022-08-18 19:34:42','',''),(1838,'21','238','3',1,'Sale Id shift 159',0.00,0.00,0.00,2497.32,0.00,'2022-08-18 19:34:42','',''),(1839,'21','238',NULL,1,'Sale Id shift 159',2605642.90,0.00,0.00,0.00,0.00,'2022-08-18 19:34:42','',''),(1840,'21','238',NULL,2,'Sale Id shift 159',6531642.00,0.00,0.00,0.00,0.00,'2022-08-18 19:34:42','',''),(1841,'21','238',NULL,3,'Sale Id shift 159',35326.00,0.00,0.00,0.00,0.00,'2022-08-18 19:34:42','',''),(1842,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,3249000.00,17100.00,0.00,0.00,'2022-08-19 11:10:41','',''),(1843,'21','238',NULL,1,'Reception corrector for bridging 212',0.00,0.00,0.00,17100.00,0.00,'2022-08-19 11:13:25','',''),(1844,'21','238','3',1,'Received from bridging 212',0.00,0.00,17100.00,0.00,0.00,'2022-08-19 11:13:25','',''),(1845,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2850000.00,15000.00,0.00,0.00,'2022-08-19 11:16:31','',''),(1846,'21','238','1',1,'Sale Id shift 160',0.00,0.00,0.00,3188.00,0.00,'2022-08-19 11:49:52','',''),(1847,'21','238','3',1,'Sale Id shift 160',0.00,0.00,0.00,2275.16,0.00,'2022-08-19 11:49:52','',''),(1848,'21','238','4',2,'Sale Id shift 160',0.00,0.00,0.00,4636.07,0.00,'2022-08-19 11:49:52','',''),(1849,'21','238','5',2,'Sale Id shift 160',0.00,0.00,0.00,1720.51,0.00,'2022-08-19 11:49:52','',''),(1850,'21','238','5',2,'Sale Id shift 160',0.00,0.00,0.00,596.67,0.00,'2022-08-19 11:49:52','',''),(1851,'21','238','6',3,'Sale Id shift 160',0.00,0.00,0.00,38.75,0.00,'2022-08-19 11:49:52','',''),(1852,'21','238','1',1,'Sale Id shift 160',0.00,0.00,0.00,1240.84,0.00,'2022-08-19 11:49:52','',''),(1853,'21','238','2',1,'Sale Id shift 160',0.00,0.00,0.00,1306.85,0.00,'2022-08-19 11:49:52','',''),(1854,'21','238','2',1,'Sale Id shift 160',0.00,0.00,0.00,3154.27,0.00,'2022-08-19 11:49:52','',''),(1855,'21','238','3',1,'Sale Id shift 160',0.00,0.00,0.00,3087.59,0.00,'2022-08-19 11:49:52','',''),(1856,'21','238',NULL,1,'Sale Id shift 160',2708014.90,0.00,0.00,0.00,0.00,'2022-08-19 11:49:52','',''),(1857,'21','238',NULL,2,'Sale Id shift 160',5652992.25,0.00,0.00,0.00,0.00,'2022-08-19 11:49:52','',''),(1858,'21','238',NULL,3,'Sale Id shift 160',33325.00,0.00,0.00,0.00,0.00,'2022-08-19 11:49:52','',''),(1859,'21','238',NULL,1,'Reception corrector for bridging 213',0.00,0.00,0.00,15000.00,0.00,'2022-08-19 11:50:28','',''),(1860,'21','238','3',1,'Received from bridging 213',0.00,0.00,15000.00,0.00,0.00,'2022-08-19 11:50:28','',''),(1861,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5700000.00,30000.00,0.00,0.00,'2022-08-24 09:46:52','',''),(1862,'21','238',NULL,1,'Reception corrector for bridging 215',0.00,0.00,0.00,15000.00,0.00,'2022-08-24 09:48:40','',''),(1863,'21','238','2',1,'Received from bridging 215',0.00,0.00,15000.00,0.00,0.00,'2022-08-24 09:48:40','',''),(1864,'21','238',NULL,1,'Reception corrector for bridging 214',0.00,0.00,0.00,15000.00,0.00,'2022-08-24 09:48:57','',''),(1865,'21','238','1',1,'Received from bridging 214',0.00,0.00,15000.00,0.00,0.00,'2022-08-24 09:48:57','',''),(1866,'21','238','1',1,'Sale Id shift 161',0.00,0.00,0.00,1628.02,0.00,'2022-08-24 10:32:03','',''),(1867,'21','238','3',1,'Sale Id shift 161',0.00,0.00,0.00,2993.63,0.00,'2022-08-24 10:32:03','',''),(1868,'21','238','4',2,'Sale Id shift 161',0.00,0.00,0.00,2792.52,0.00,'2022-08-24 10:32:03','',''),(1869,'21','238','5',2,'Sale Id shift 161',0.00,0.00,0.00,1904.98,0.00,'2022-08-24 10:32:03','',''),(1870,'21','238','5',2,'Sale Id shift 161',0.00,0.00,0.00,1072.05,0.00,'2022-08-24 10:32:03','',''),(1871,'21','238','6',3,'Sale Id shift 161',0.00,0.00,0.00,73.36,0.00,'2022-08-24 10:32:03','',''),(1872,'21','238','1',1,'Sale Id shift 161',0.00,0.00,0.00,3838.57,0.00,'2022-08-24 10:32:03','',''),(1873,'21','238','2',1,'Sale Id shift 161',0.00,0.00,0.00,4415.45,0.00,'2022-08-24 10:32:03','',''),(1874,'21','238','3',1,'Sale Id shift 161',0.00,0.00,0.00,4365.78,0.00,'2022-08-24 10:32:03','',''),(1875,'21','238',NULL,1,'Sale Id shift 161',3275875.50,0.00,0.00,0.00,0.00,'2022-08-24 10:32:03','',''),(1876,'21','238',NULL,2,'Sale Id shift 161',4604100.90,0.00,0.00,0.00,0.00,'2022-08-24 10:32:03','',''),(1877,'21','238',NULL,3,'Sale Id shift 161',63089.60,0.00,0.00,0.00,0.00,'2022-08-24 10:32:03','',''),(1878,'21','238','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,1644.60,0.00,'2022-08-24 12:20:42','',''),(1879,'21','238','4',0,'Inventory adjustment from tank dipping to 1745',0.00,0.00,1745.00,0.00,0.00,'2022-08-24 12:20:42','',''),(1880,'21','238','1',1,'Sale Id shift 162',0.00,0.00,0.00,2229.20,0.00,'2022-08-24 12:48:29','',''),(1881,'21','238','3',1,'Sale Id shift 162',0.00,0.00,0.00,2559.91,0.00,'2022-08-24 12:48:29','',''),(1882,'21','238','4',2,'Sale Id shift 162',0.00,0.00,0.00,1706.09,0.00,'2022-08-24 12:48:29','',''),(1883,'21','238','5',2,'Sale Id shift 162',0.00,0.00,0.00,1383.62,0.00,'2022-08-24 12:48:29','',''),(1884,'21','238','5',2,'Sale Id shift 162',0.00,0.00,0.00,1806.57,0.00,'2022-08-24 12:48:29','',''),(1885,'21','238','6',3,'Sale Id shift 162',0.00,0.00,0.00,40.38,0.00,'2022-08-24 12:48:29','',''),(1886,'21','238','1',1,'Sale Id shift 162',0.00,0.00,0.00,3951.51,0.00,'2022-08-24 12:48:29','',''),(1887,'21','238','2',1,'Sale Id shift 162',0.00,0.00,0.00,4618.84,0.00,'2022-08-24 12:48:29','',''),(1888,'21','238','3',1,'Sale Id shift 162',0.00,0.00,0.00,4514.22,0.00,'2022-08-24 12:48:29','',''),(1889,'21','238',NULL,1,'Sale Id shift 162',3395999.20,0.00,0.00,0.00,0.00,'2022-08-24 12:48:29','',''),(1890,'21','238',NULL,2,'Sale Id shift 162',3907231.44,0.00,0.00,0.00,0.00,'2022-08-24 12:48:29','',''),(1891,'21','238',NULL,3,'Sale Id shift 162',34726.80,0.00,0.00,0.00,0.00,'2022-08-24 12:48:29','',''),(1892,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,35910000.00,45000.00,0.00,0.00,'2022-08-24 18:17:10','',''),(1893,'21','238',NULL,2,'Reception corrector for bridging 217',0.00,0.00,0.00,12039.00,0.00,'2022-08-24 18:19:46','',''),(1894,'21','238','5',2,'Received from bridging 217',0.00,0.00,12039.00,0.00,0.00,'2022-08-24 18:19:46','',''),(1895,'21','238',NULL,2,'Reception corrector for bridging 216',0.00,0.00,0.00,32961.00,0.00,'2022-08-24 18:19:58','',''),(1896,'21','238','4',2,'Received from bridging 216',0.00,0.00,32961.00,0.00,0.00,'2022-08-24 18:19:58','',''),(1897,'21','238','1',1,'Sale Id shift 163',0.00,0.00,0.00,1039.54,0.00,'2022-08-24 18:30:58','',''),(1898,'21','238','3',1,'Sale Id shift 163',0.00,0.00,0.00,2484.02,0.00,'2022-08-24 18:30:58','',''),(1899,'21','238','4',2,'Sale Id shift 163',0.00,0.00,0.00,4996.59,0.00,'2022-08-24 18:30:58','',''),(1900,'21','238','5',2,'Sale Id shift 163',0.00,0.00,0.00,765.83,0.00,'2022-08-24 18:30:58','',''),(1901,'21','238','6',3,'Sale Id shift 163',0.00,0.00,0.00,33.98,0.00,'2022-08-24 18:30:58','',''),(1902,'21','238','1',1,'Sale Id shift 163',0.00,0.00,0.00,3952.94,0.00,'2022-08-24 18:30:58','',''),(1903,'21','238','2',1,'Sale Id shift 163',0.00,0.00,0.00,4671.88,0.00,'2022-08-24 18:30:58','',''),(1904,'21','238','3',1,'Sale Id shift 163',0.00,0.00,0.00,4624.62,0.00,'2022-08-24 18:30:58','',''),(1905,'21','238',NULL,1,'Sale Id shift 163',3186870.00,0.00,0.00,0.00,0.00,'2022-08-24 18:30:58','',''),(1906,'21','238',NULL,2,'Sale Id shift 163',4598411.16,0.00,0.00,0.00,0.00,'2022-08-24 18:30:58','',''),(1907,'21','238',NULL,3,'Sale Id shift 163',29222.80,0.00,0.00,0.00,0.00,'2022-08-24 18:30:58','',''),(1908,'21','238','3',1,'Sale Id shift 164',0.00,0.00,0.00,3048.69,0.00,'2022-08-24 18:44:15','',''),(1909,'21','238','4',2,'Sale Id shift 164',0.00,0.00,0.00,7265.15,0.00,'2022-08-24 18:44:15','',''),(1910,'21','238','6',3,'Sale Id shift 164',0.00,0.00,0.00,33.51,0.00,'2022-08-24 18:44:15','',''),(1911,'21','238','1',1,'Sale Id shift 164',0.00,0.00,0.00,4891.37,0.00,'2022-08-24 18:44:15','',''),(1912,'21','238','2',1,'Sale Id shift 164',0.00,0.00,0.00,3915.50,0.00,'2022-08-24 18:44:15','',''),(1913,'21','238','3',1,'Sale Id shift 164',0.00,0.00,0.00,4639.32,0.00,'2022-08-24 18:44:15','',''),(1914,'21','238',NULL,1,'Sale Id shift 164',3134027.20,0.00,0.00,0.00,0.00,'2022-08-24 18:44:15','',''),(1915,'21','238',NULL,2,'Sale Id shift 164',5797589.70,0.00,0.00,0.00,0.00,'2022-08-24 18:44:15','',''),(1916,'21','238',NULL,3,'Sale Id shift 164',28818.60,0.00,0.00,0.00,0.00,'2022-08-24 18:44:15','',''),(1917,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5795000.00,30500.00,0.00,0.00,'2022-08-24 19:12:09','',''),(1918,'21','238',NULL,1,'Reception corrector for bridging 219',0.00,0.00,0.00,15500.00,0.00,'2022-08-24 19:15:55','',''),(1919,'21','238','3',1,'Received from bridging 219',0.00,0.00,15500.00,0.00,0.00,'2022-08-24 19:15:55','',''),(1920,'21','238',NULL,1,'Reception corrector for bridging 218',0.00,0.00,0.00,15000.00,0.00,'2022-08-24 19:16:21','',''),(1921,'21','238','1',1,'Received from bridging 218',0.00,0.00,15000.00,0.00,0.00,'2022-08-24 19:16:21','',''),(1922,'21','238','1',1,'Sale Id shift 165',0.00,0.00,0.00,1537.33,0.00,'2022-08-24 19:30:25','',''),(1923,'21','238','3',1,'Sale Id shift 165',0.00,0.00,0.00,1570.55,0.00,'2022-08-24 19:30:25','',''),(1924,'21','238','4',2,'Sale Id shift 165',0.00,0.00,0.00,1977.51,0.00,'2022-08-24 19:30:25','',''),(1925,'21','238','5',2,'Sale Id shift 165',0.00,0.00,0.00,447.35,0.00,'2022-08-24 19:30:25','',''),(1926,'21','238','5',2,'Sale Id shift 165',0.00,0.00,0.00,53.28,0.00,'2022-08-24 19:30:25','',''),(1927,'21','238','6',3,'Sale Id shift 165',0.00,0.00,0.00,44.37,0.00,'2022-08-24 19:30:25','',''),(1928,'21','238','1',1,'Sale Id shift 165',0.00,0.00,0.00,3238.17,0.00,'2022-08-24 19:30:25','',''),(1929,'21','238','2',1,'Sale Id shift 165',0.00,0.00,0.00,6252.86,0.00,'2022-08-24 19:30:25','',''),(1930,'21','238','3',1,'Sale Id shift 165',0.00,0.00,0.00,2363.73,0.00,'2022-08-24 19:30:25','',''),(1931,'21','238',NULL,1,'Sale Id shift 165',2842901.60,0.00,0.00,0.00,0.00,'2022-08-24 19:30:26','',''),(1932,'21','238',NULL,2,'Sale Id shift 165',1977555.72,0.00,0.00,0.00,0.00,'2022-08-24 19:30:26','',''),(1933,'21','238',NULL,3,'Sale Id shift 165',38158.20,0.00,0.00,0.00,0.00,'2022-08-24 19:30:26','',''),(1934,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,15960000.00,20000.00,0.00,0.00,'2022-08-24 19:33:43','',''),(1935,'21','238',NULL,2,'Reception corrector for bridging 220',0.00,0.00,0.00,20000.00,0.00,'2022-08-24 19:35:16','',''),(1936,'21','238','5',2,'Received from bridging 220',0.00,0.00,20000.00,0.00,0.00,'2022-08-24 19:35:16','',''),(1937,'21','238','1',1,'Sale Id shift 166',0.00,0.00,0.00,729.64,0.00,'2022-08-26 13:13:35','',''),(1938,'21','238','3',1,'Sale Id shift 166',0.00,0.00,0.00,3641.82,0.00,'2022-08-26 13:13:35','',''),(1939,'21','238','4',2,'Sale Id shift 166',0.00,0.00,0.00,1806.56,0.00,'2022-08-26 13:13:35','',''),(1940,'21','238','5',2,'Sale Id shift 166',0.00,0.00,0.00,787.98,0.00,'2022-08-26 13:13:35','',''),(1941,'21','238','5',2,'Sale Id shift 166',0.00,0.00,0.00,424.42,0.00,'2022-08-26 13:13:35','',''),(1942,'21','238','6',3,'Sale Id shift 166',0.00,0.00,0.00,29.75,0.00,'2022-08-26 13:13:35','',''),(1943,'21','238','1',1,'Sale Id shift 166',0.00,0.00,0.00,4807.24,0.00,'2022-08-26 13:13:35','',''),(1944,'21','238','2',1,'Sale Id shift 166',0.00,0.00,0.00,1028.17,0.00,'2022-08-26 13:13:35','',''),(1945,'21','238','3',1,'Sale Id shift 166',0.00,0.00,0.00,5907.79,0.00,'2022-08-26 13:13:35','',''),(1946,'21','238',NULL,1,'Sale Id shift 166',3061785.40,0.00,0.00,0.00,0.00,'2022-08-26 13:13:35','',''),(1947,'21','238',NULL,2,'Sale Id shift 166',2409130.08,0.00,0.00,0.00,0.00,'2022-08-26 13:13:35','',''),(1948,'21','238',NULL,3,'Sale Id shift 166',25585.00,0.00,0.00,0.00,0.00,'2022-08-26 13:13:35','',''),(1949,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5700000.00,30000.00,0.00,0.00,'2022-08-26 13:26:38','',''),(1950,'21','238',NULL,1,'Reception corrector for bridging 222',0.00,0.00,0.00,15000.00,0.00,'2022-08-26 13:29:12','',''),(1951,'21','238','3',1,'Received from bridging 222',0.00,0.00,15000.00,0.00,0.00,'2022-08-26 13:29:12','',''),(1952,'21','238',NULL,1,'Reception corrector for bridging 221',0.00,0.00,0.00,15000.00,0.00,'2022-08-26 13:29:24','',''),(1953,'21','238','1',1,'Received from bridging 221',0.00,0.00,15000.00,0.00,0.00,'2022-08-26 13:29:24','',''),(1954,'21','238','1',1,'Sale Id shift 167',0.00,0.00,0.00,2414.72,0.00,'2022-08-26 13:36:03','',''),(1955,'21','238','3',1,'Sale Id shift 167',0.00,0.00,0.00,2486.12,0.00,'2022-08-26 13:36:03','',''),(1956,'21','238','4',2,'Sale Id shift 167',0.00,0.00,0.00,4049.96,0.00,'2022-08-26 13:36:03','',''),(1957,'21','238','5',2,'Sale Id shift 167',0.00,0.00,0.00,1677.95,0.00,'2022-08-26 13:36:03','',''),(1958,'21','238','5',2,'Sale Id shift 167',0.00,0.00,0.00,310.48,0.00,'2022-08-26 13:36:03','',''),(1959,'21','238','6',3,'Sale Id shift 167',0.00,0.00,0.00,33.91,0.00,'2022-08-26 13:36:03','',''),(1960,'21','238','1',1,'Sale Id shift 167',0.00,0.00,0.00,5299.30,0.00,'2022-08-26 13:36:03','',''),(1961,'21','238','3',1,'Sale Id shift 167',0.00,0.00,0.00,3020.57,0.00,'2022-08-26 13:36:03','',''),(1962,'21','238',NULL,2,'Sale Id shift 167',4818635.22,0.00,0.00,0.00,0.00,'2022-08-26 13:36:03','',''),(1963,'21','238',NULL,3,'Sale Id shift 167',29162.60,0.00,0.00,0.00,0.00,'2022-08-26 13:36:03','',''),(1964,'21','238',NULL,1,'Sale Id shift 167',2511934.90,0.00,0.00,0.00,0.00,'2022-08-26 13:36:03','',''),(1965,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5700000.00,30000.00,0.00,0.00,'2022-08-28 19:58:04','',''),(1966,'21','238',NULL,1,'Reception corrector for bridging 224',0.00,0.00,0.00,16000.00,0.00,'2022-08-28 20:00:59','',''),(1967,'21','238','3',1,'Received from bridging 224',0.00,0.00,16000.00,0.00,0.00,'2022-08-28 20:00:59','',''),(1968,'21','238',NULL,1,'Reception corrector for bridging 223',0.00,0.00,0.00,14000.00,0.00,'2022-08-28 20:01:14','',''),(1969,'21','238','1',1,'Received from bridging 223',0.00,0.00,14000.00,0.00,0.00,'2022-08-28 20:01:14','',''),(1970,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8550000.00,45000.00,0.00,0.00,'2022-08-28 20:02:50','',''),(1971,'21','238',NULL,1,'Reception corrector for bridging 226',0.00,0.00,0.00,15000.00,0.00,'2022-08-29 11:57:49','',''),(1972,'21','238','2',1,'Received from bridging 226',0.00,0.00,15000.00,0.00,0.00,'2022-08-29 11:57:49','',''),(1973,'21','238','1',1,'Sale Id shift 168',0.00,0.00,0.00,33.09,0.00,'2022-08-29 12:08:52','',''),(1974,'21','238','3',1,'Sale Id shift 168',0.00,0.00,0.00,3910.90,0.00,'2022-08-29 12:08:52','',''),(1975,'21','238','4',2,'Sale Id shift 168',0.00,0.00,0.00,1096.44,0.00,'2022-08-29 12:08:52','',''),(1976,'21','238','5',2,'Sale Id shift 168',0.00,0.00,0.00,1457.15,0.00,'2022-08-29 12:08:52','',''),(1977,'21','238','5',2,'Sale Id shift 168',0.00,0.00,0.00,1947.45,0.00,'2022-08-29 12:08:52','',''),(1978,'21','238','6',3,'Sale Id shift 168',0.00,0.00,0.00,22.34,0.00,'2022-08-29 12:08:52','',''),(1979,'21','238','1',1,'Sale Id shift 168',0.00,0.00,0.00,1351.09,0.00,'2022-08-29 12:08:52','',''),(1980,'21','238','2',1,'Sale Id shift 168',0.00,0.00,0.00,5407.99,0.00,'2022-08-29 12:08:52','',''),(1981,'21','238','3',1,'Sale Id shift 168',0.00,0.00,0.00,5204.86,0.00,'2022-08-29 12:08:52','',''),(1982,'21','238',NULL,1,'Sale Id shift 168',3022506.70,0.00,0.00,0.00,0.00,'2022-08-29 12:08:52','',''),(1983,'21','238',NULL,2,'Sale Id shift 168',3591829.92,0.00,0.00,0.00,0.00,'2022-08-29 12:08:52','',''),(1984,'21','238',NULL,3,'Sale Id shift 168',19212.40,0.00,0.00,0.00,0.00,'2022-08-29 12:08:52','',''),(1985,'21','238','3',1,'Sale Id shift 169',0.00,0.00,0.00,3601.70,0.00,'2022-08-29 12:36:35','',''),(1986,'21','238','4',2,'Sale Id shift 169',0.00,0.00,0.00,845.22,0.00,'2022-08-29 12:36:35','',''),(1987,'21','238','5',2,'Sale Id shift 169',0.00,0.00,0.00,3197.97,0.00,'2022-08-29 12:36:35','',''),(1988,'21','238','5',2,'Sale Id shift 169',0.00,0.00,0.00,1460.53,0.00,'2022-08-29 12:36:35','',''),(1989,'21','238','6',3,'Sale Id shift 169',0.00,0.00,0.00,51.34,0.00,'2022-08-29 12:36:35','',''),(1990,'21','238','1',1,'Sale Id shift 169',0.00,0.00,0.00,559.07,0.00,'2022-08-29 12:36:35','',''),(1991,'21','238','2',1,'Sale Id shift 169',0.00,0.00,0.00,3907.71,0.00,'2022-08-29 12:36:35','',''),(1992,'21','238','3',1,'Sale Id shift 169',0.00,0.00,0.00,3598.52,0.00,'2022-08-29 12:36:35','',''),(1993,'21','238',NULL,1,'Sale Id shift 169',2216730.00,0.00,0.00,0.00,0.00,'2022-08-29 12:36:35','',''),(1994,'21','238',NULL,2,'Sale Id shift 169',4391968.56,0.00,0.00,0.00,0.00,'2022-08-29 12:36:35','',''),(1995,'21','238',NULL,3,'Sale Id shift 169',44152.40,0.00,0.00,0.00,0.00,'2022-08-29 12:36:35','',''),(1996,'21','238','1',1,'Sale Id shift 170',0.00,0.00,0.00,809.02,0.00,'2022-08-29 12:47:08','',''),(1997,'21','238','3',1,'Sale Id shift 170',0.00,0.00,0.00,2495.52,0.00,'2022-08-29 12:47:08','',''),(1998,'21','238','4',2,'Sale Id shift 170',0.00,0.00,0.00,1000.00,0.00,'2022-08-29 12:47:08','',''),(1999,'21','238','5',2,'Sale Id shift 170',0.00,0.00,0.00,2686.72,0.00,'2022-08-29 12:47:08','',''),(2000,'21','238','5',2,'Sale Id shift 170',0.00,0.00,0.00,1662.15,0.00,'2022-08-29 12:47:08','',''),(2001,'21','238','6',3,'Sale Id shift 170',0.00,0.00,0.00,38.49,0.00,'2022-08-29 12:47:08','',''),(2002,'21','238','1',1,'Sale Id shift 170',0.00,0.00,0.00,4147.67,0.00,'2022-08-29 12:47:08','',''),(2003,'21','238','2',1,'Sale Id shift 170',0.00,0.00,0.00,3872.68,0.00,'2022-08-29 12:47:08','',''),(2004,'21','238','3',1,'Sale Id shift 170',0.00,0.00,0.00,3314.55,0.00,'2022-08-29 12:47:08','',''),(2005,'21','238',NULL,1,'Sale Id shift 170',2781493.60,0.00,0.00,0.00,0.00,'2022-08-29 12:47:08','',''),(2006,'21','238',NULL,2,'Sale Id shift 170',4268398.26,0.00,0.00,0.00,0.00,'2022-08-29 12:47:08','',''),(2007,'21','238',NULL,3,'Sale Id shift 170',33101.40,0.00,0.00,0.00,0.00,'2022-08-29 12:47:08','',''),(2008,'21','238',NULL,1,'Reception corrector for bridging 227',0.00,0.00,0.00,15000.00,0.00,'2022-08-29 12:50:00','',''),(2009,'21','238','3',1,'Received from bridging 227',0.00,0.00,15000.00,0.00,0.00,'2022-08-29 12:50:00','',''),(2010,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2850000.00,15000.00,0.00,0.00,'2022-08-30 11:16:10','',''),(2011,'21','238',NULL,1,'Reception corrector for bridging 228',0.00,0.00,0.00,15000.00,0.00,'2022-08-30 11:17:56','',''),(2012,'21','238','2',1,'Received from bridging 228',0.00,0.00,15000.00,0.00,0.00,'2022-08-30 11:17:56','',''),(2013,'21','238','1',1,'Sale Id shift 171',0.00,0.00,0.00,1902.27,0.00,'2022-08-30 11:29:57','',''),(2014,'21','238','3',1,'Sale Id shift 171',0.00,0.00,0.00,2991.92,0.00,'2022-08-30 11:29:57','',''),(2015,'21','238','4',2,'Sale Id shift 171',0.00,0.00,0.00,1979.71,0.00,'2022-08-30 11:29:57','',''),(2016,'21','238','5',2,'Sale Id shift 171',0.00,0.00,0.00,3048.16,0.00,'2022-08-30 11:29:57','',''),(2017,'21','238','5',2,'Sale Id shift 171',0.00,0.00,0.00,1015.00,0.00,'2022-08-30 11:29:57','',''),(2018,'21','238','6',3,'Sale Id shift 171',0.00,0.00,0.00,41.49,0.00,'2022-08-30 11:29:57','',''),(2019,'21','238','1',1,'Sale Id shift 171',0.00,0.00,0.00,3544.73,0.00,'2022-08-30 11:29:57','',''),(2020,'21','238','2',1,'Sale Id shift 171',0.00,0.00,0.00,2926.73,0.00,'2022-08-30 11:29:57','',''),(2021,'21','238','3',1,'Sale Id shift 171',0.00,0.00,0.00,3012.09,0.00,'2022-08-30 11:29:57','',''),(2022,'21','238',NULL,1,'Sale Id shift 171',2731770.60,0.00,0.00,0.00,0.00,'2022-08-30 11:29:57','',''),(2023,'21','238',NULL,2,'Sale Id shift 171',4822210.26,0.00,0.00,0.00,0.00,'2022-08-30 11:29:57','',''),(2024,'21','238',NULL,3,'Sale Id shift 171',35681.40,0.00,0.00,0.00,0.00,'2022-08-30 11:29:57','',''),(2025,'21','238','1',1,'Sale Id shift 172',0.00,0.00,0.00,2855.48,0.00,'2022-08-31 13:19:20','',''),(2026,'21','238','3',1,'Sale Id shift 172',0.00,0.00,0.00,842.00,0.00,'2022-08-31 13:19:20','',''),(2027,'21','238','4',2,'Sale Id shift 172',0.00,0.00,0.00,2246.68,0.00,'2022-08-31 13:19:20','',''),(2028,'21','238','5',2,'Sale Id shift 172',0.00,0.00,0.00,1040.81,0.00,'2022-08-31 13:19:20','',''),(2029,'21','238','5',2,'Sale Id shift 172',0.00,0.00,0.00,2070.59,0.00,'2022-08-31 13:19:20','',''),(2030,'21','238','6',3,'Sale Id shift 172',0.00,0.00,0.00,31.40,0.00,'2022-08-31 13:19:20','',''),(2031,'21','238','1',1,'Sale Id shift 172',0.00,0.00,0.00,2774.53,0.00,'2022-08-31 13:19:20','',''),(2032,'21','238','2',1,'Sale Id shift 172',0.00,0.00,0.00,3976.21,0.00,'2022-08-31 13:19:20','',''),(2033,'21','238','3',1,'Sale Id shift 172',0.00,0.00,0.00,4395.13,0.00,'2022-08-31 13:19:20','',''),(2034,'21','238',NULL,1,'Sale Id shift 172',2820236.50,0.00,0.00,0.00,0.00,'2022-08-31 13:19:20','',''),(2035,'21','238',NULL,2,'Sale Id shift 172',4275747.84,0.00,0.00,0.00,0.00,'2022-08-31 13:19:20','',''),(2036,'21','238',NULL,3,'Sale Id shift 172',27004.00,0.00,0.00,0.00,0.00,'2022-08-31 13:19:20','',''),(2037,'21','238','1',1,'Sale Id shift 173',0.00,0.00,0.00,3121.14,0.00,'2022-09-01 12:22:53','',''),(2038,'21','238','3',1,'Sale Id shift 173',0.00,0.00,0.00,2023.37,0.00,'2022-09-01 12:22:53','',''),(2039,'21','238','4',2,'Sale Id shift 173',0.00,0.00,0.00,5099.72,0.00,'2022-09-01 12:22:53','',''),(2040,'21','238','5',2,'Sale Id shift 173',0.00,0.00,0.00,1021.96,0.00,'2022-09-01 12:22:53','',''),(2041,'21','238','5',2,'Sale Id shift 173',0.00,0.00,0.00,404.01,0.00,'2022-09-01 12:22:53','',''),(2042,'21','238','6',3,'Sale Id shift 173',0.00,0.00,0.00,39.55,0.00,'2022-09-01 12:22:53','',''),(2043,'21','238','1',1,'Sale Id shift 173',0.00,0.00,0.00,3261.91,0.00,'2022-09-01 12:22:53','',''),(2044,'21','238','2',1,'Sale Id shift 173',0.00,0.00,0.00,3353.79,0.00,'2022-09-01 12:22:53','',''),(2045,'21','238','3',1,'Sale Id shift 173',0.00,0.00,0.00,3054.81,0.00,'2022-09-01 12:22:53','',''),(2046,'21','238',NULL,1,'Sale Id shift 173',2814853.80,0.00,0.00,0.00,0.00,'2022-09-01 12:22:53','',''),(2047,'21','238',NULL,2,'Sale Id shift 173',5207500.62,0.00,0.00,0.00,0.00,'2022-09-01 12:22:53','',''),(2048,'21','238',NULL,3,'Sale Id shift 173',34013.00,0.00,0.00,0.00,0.00,'2022-09-01 12:22:53','',''),(2049,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,23940000.00,30000.00,0.00,0.00,'2022-09-02 14:54:52','',''),(2050,'21','238',NULL,2,'Reception corrector for bridging 229',0.00,0.00,0.00,30000.00,0.00,'2022-09-02 14:59:58','',''),(2051,'21','238','4',2,'Received from bridging 229',0.00,0.00,30000.00,0.00,0.00,'2022-09-02 14:59:58','',''),(2052,'21','238',NULL,1,'Reception corrector for bridging 225',0.00,0.00,0.00,15000.00,0.00,'2022-09-02 15:02:58','',''),(2053,'21','238','1',1,'Received from bridging 225',0.00,0.00,15000.00,0.00,0.00,'2022-09-02 15:02:58','',''),(2054,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5700000.00,30000.00,0.00,0.00,'2022-09-02 15:07:18','',''),(2055,'21','238',NULL,1,'Reception corrector for bridging 231',0.00,0.00,0.00,15000.00,0.00,'2022-09-02 15:11:53','',''),(2056,'21','238','3',1,'Received from bridging 231',0.00,0.00,15000.00,0.00,0.00,'2022-09-02 15:11:53','',''),(2057,'21','238',NULL,1,'Reception corrector for bridging 230',0.00,0.00,0.00,15000.00,0.00,'2022-09-02 15:12:11','',''),(2058,'21','238','2',1,'Received from bridging 230',0.00,0.00,15000.00,0.00,0.00,'2022-09-02 15:12:11','',''),(2059,'21','238','1',1,'Sale Id shift 174',0.00,0.00,0.00,2720.82,0.00,'2022-09-02 15:34:41','',''),(2060,'21','238','3',1,'Sale Id shift 174',0.00,0.00,0.00,2543.14,0.00,'2022-09-02 15:34:41','',''),(2061,'21','238','4',2,'Sale Id shift 174',0.00,0.00,0.00,1324.73,0.00,'2022-09-02 15:34:41','',''),(2062,'21','238','5',2,'Sale Id shift 174',0.00,0.00,0.00,2038.62,0.00,'2022-09-02 15:34:41','',''),(2063,'21','238','5',2,'Sale Id shift 174',0.00,0.00,0.00,368.92,0.00,'2022-09-02 15:34:41','',''),(2064,'21','238','6',3,'Sale Id shift 174',0.00,0.00,0.00,38.87,0.00,'2022-09-02 15:34:41','',''),(2065,'21','238','1',1,'Sale Id shift 174',0.00,0.00,0.00,3435.59,0.00,'2022-09-02 15:34:41','',''),(2066,'21','238','2',1,'Sale Id shift 174',0.00,0.00,0.00,2614.43,0.00,'2022-09-02 15:34:41','',''),(2067,'21','238','3',1,'Sale Id shift 174',0.00,0.00,0.00,2815.89,0.00,'2022-09-02 15:34:41','',''),(2068,'21','238',NULL,1,'Sale Id shift 174',2684675.30,0.00,0.00,0.00,0.00,'2022-09-02 15:34:41','',''),(2069,'21','238',NULL,2,'Sale Id shift 174',2978351.46,0.00,0.00,0.00,0.00,'2022-09-02 15:34:41','',''),(2070,'21','238',NULL,3,'Sale Id shift 174',33428.20,0.00,0.00,0.00,0.00,'2022-09-02 15:34:41','',''),(2071,'21','238','1',1,'Sale Id shift 175',0.00,0.00,0.00,2818.49,0.00,'2022-09-03 19:48:08','',''),(2072,'21','238','3',1,'Sale Id shift 175',0.00,0.00,0.00,3240.93,0.00,'2022-09-03 19:48:08','',''),(2073,'21','238','4',2,'Sale Id shift 175',0.00,0.00,0.00,2456.27,0.00,'2022-09-03 19:48:08','',''),(2074,'21','238','5',2,'Sale Id shift 175',0.00,0.00,0.00,1252.97,0.00,'2022-09-03 19:48:08','',''),(2075,'21','238','5',2,'Sale Id shift 175',0.00,0.00,0.00,1296.99,0.00,'2022-09-03 19:48:08','',''),(2076,'21','238','6',3,'Sale Id shift 175',0.00,0.00,0.00,38.67,0.00,'2022-09-03 19:48:08','',''),(2077,'21','238','1',1,'Sale Id shift 175',0.00,0.00,0.00,3145.53,0.00,'2022-09-03 19:48:08','',''),(2078,'21','238','2',1,'Sale Id shift 175',0.00,0.00,0.00,3812.62,0.00,'2022-09-03 19:48:08','',''),(2079,'21','238','3',1,'Sale Id shift 175',0.00,0.00,0.00,4803.19,0.00,'2022-09-03 19:48:08','',''),(2080,'21','238',NULL,1,'Sale Id shift 175',3385944.40,0.00,0.00,0.00,0.00,'2022-09-03 19:48:08','',''),(2081,'21','238',NULL,2,'Sale Id shift 175',3994971.54,0.00,0.00,0.00,0.00,'2022-09-03 19:48:08','',''),(2082,'21','238',NULL,3,'Sale Id shift 175',33256.20,0.00,0.00,0.00,0.00,'2022-09-03 19:48:08','',''),(2083,'21','238','1',1,'Sale Id shift 176',0.00,0.00,0.00,3385.66,0.00,'2022-09-04 15:56:43','',''),(2084,'21','238','3',1,'Sale Id shift 176',0.00,0.00,0.00,2840.46,0.00,'2022-09-04 15:56:43','',''),(2085,'21','238','4',2,'Sale Id shift 176',0.00,0.00,0.00,3081.28,0.00,'2022-09-04 15:56:43','',''),(2086,'21','238','5',2,'Sale Id shift 176',0.00,0.00,0.00,1551.10,0.00,'2022-09-04 15:56:43','',''),(2087,'21','238','5',2,'Sale Id shift 176',0.00,0.00,0.00,973.97,0.00,'2022-09-04 15:56:43','',''),(2088,'21','238','6',3,'Sale Id shift 176',0.00,0.00,0.00,48.57,0.00,'2022-09-04 15:56:43','',''),(2089,'21','238','1',1,'Sale Id shift 176',0.00,0.00,0.00,4021.67,0.00,'2022-09-04 15:56:43','',''),(2090,'21','238','2',1,'Sale Id shift 176',0.00,0.00,0.00,2980.90,0.00,'2022-09-04 15:56:43','',''),(2091,'21','238','3',1,'Sale Id shift 176',0.00,0.00,0.00,3861.15,0.00,'2022-09-04 15:56:43','',''),(2092,'21','238',NULL,1,'Sale Id shift 176',3247069.60,0.00,0.00,0.00,0.00,'2022-09-04 15:56:43','',''),(2093,'21','238',NULL,2,'Sale Id shift 176',4473867.30,0.00,0.00,0.00,0.00,'2022-09-04 15:56:43','',''),(2094,'21','238',NULL,3,'Sale Id shift 176',41770.20,0.00,0.00,0.00,0.00,'2022-09-04 15:56:43','',''),(2095,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,23940000.00,30000.00,0.00,0.00,'2022-09-04 16:21:10','',''),(2096,'21','238',NULL,2,'Reception corrector for bridging 232',0.00,0.00,0.00,30000.00,0.00,'2022-09-04 16:24:34','',''),(2097,'21','238','5',2,'Received from bridging 232',0.00,0.00,30000.00,0.00,0.00,'2022-09-04 16:24:34','',''),(2098,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,6270000.00,33000.00,0.00,0.00,'2022-09-04 16:28:03','',''),(2099,'21','238',NULL,1,'Reception corrector for bridging 234',0.00,0.00,0.00,16500.00,0.00,'2022-09-04 16:31:58','',''),(2100,'21','238','3',1,'Received from bridging 234',0.00,0.00,16500.00,0.00,0.00,'2022-09-04 16:31:58','',''),(2101,'21','238',NULL,1,'Reception corrector for bridging 233',0.00,0.00,0.00,16500.00,0.00,'2022-09-04 16:32:34','',''),(2102,'21','238','1',1,'Received from bridging 233',0.00,0.00,16500.00,0.00,0.00,'2022-09-04 16:32:34','',''),(2103,'21','238','1',1,'Sale Id shift 177',0.00,0.00,0.00,2924.69,0.00,'2022-09-05 11:32:50','',''),(2104,'21','238','3',1,'Sale Id shift 177',0.00,0.00,0.00,2691.90,0.00,'2022-09-05 11:32:50','',''),(2105,'21','238','4',2,'Sale Id shift 177',0.00,0.00,0.00,1537.09,0.00,'2022-09-05 11:32:50','',''),(2106,'21','238','5',2,'Sale Id shift 177',0.00,0.00,0.00,3578.03,0.00,'2022-09-05 11:32:50','',''),(2107,'21','238','5',2,'Sale Id shift 177',0.00,0.00,0.00,2179.76,0.00,'2022-09-05 11:32:50','',''),(2108,'21','238','6',3,'Sale Id shift 177',0.00,0.00,0.00,49.45,0.00,'2022-09-05 11:32:50','',''),(2109,'21','238','1',1,'Sale Id shift 177',0.00,0.00,0.00,4416.68,0.00,'2022-09-05 11:32:50','',''),(2110,'21','238','2',1,'Sale Id shift 177',0.00,0.00,0.00,4188.81,0.00,'2022-09-05 11:32:50','',''),(2111,'21','238','3',1,'Sale Id shift 177',0.00,0.00,0.00,5129.67,0.00,'2022-09-05 11:32:50','',''),(2112,'21','238',NULL,2,'Sale Id shift 177',5821314.24,0.00,0.00,0.00,0.00,'2022-09-05 11:32:50','',''),(2113,'21','238',NULL,3,'Sale Id shift 177',42527.00,0.00,0.00,0.00,0.00,'2022-09-05 11:32:50','',''),(2114,'21','238',NULL,1,'Sale Id shift 177',3676832.50,0.00,0.00,0.00,0.00,'2022-09-05 11:32:50','',''),(2115,'21','238','1',1,'Sale Id shift 178',0.00,0.00,0.00,2333.99,0.00,'2022-09-06 17:59:07','',''),(2116,'21','238','3',1,'Sale Id shift 178',0.00,0.00,0.00,3550.45,0.00,'2022-09-06 17:59:07','',''),(2117,'21','238','4',2,'Sale Id shift 178',0.00,0.00,0.00,2908.05,0.00,'2022-09-06 17:59:07','',''),(2118,'21','238','5',2,'Sale Id shift 178',0.00,0.00,0.00,2456.86,0.00,'2022-09-06 17:59:07','',''),(2119,'21','238','5',2,'Sale Id shift 178',0.00,0.00,0.00,817.64,0.00,'2022-09-06 17:59:07','',''),(2120,'21','238','6',3,'Sale Id shift 178',0.00,0.00,0.00,61.14,0.00,'2022-09-06 17:59:07','',''),(2121,'21','238','1',1,'Sale Id shift 178',0.00,0.00,0.00,4826.83,0.00,'2022-09-06 17:59:07','',''),(2122,'21','238','2',1,'Sale Id shift 178',0.00,0.00,0.00,3104.68,0.00,'2022-09-06 17:59:07','',''),(2123,'21','238','3',1,'Sale Id shift 178',0.00,0.00,0.00,4257.24,0.00,'2022-09-06 17:59:07','',''),(2124,'21','238',NULL,1,'Sale Id shift 178',3433906.10,0.00,0.00,0.00,0.00,'2022-09-06 17:59:07','',''),(2125,'21','238',NULL,2,'Sale Id shift 178',4933674.90,0.00,0.00,0.00,0.00,'2022-09-06 17:59:07','',''),(2126,'21','238',NULL,3,'Sale Id shift 178',52580.40,0.00,0.00,0.00,0.00,'2022-09-06 17:59:07','',''),(2127,'21','238','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,3726.38,0.00,'2022-09-07 23:24:18','',''),(2128,'21','238','1',0,'Inventory adjustment from tank dipping to 3766',0.00,0.00,3766.00,0.00,0.00,'2022-09-07 23:24:18','',''),(2129,'21','238','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,6146.44,0.00,'2022-09-07 23:25:05','',''),(2130,'21','238','2',0,'Inventory adjustment from tank dipping to 4780',0.00,0.00,4780.00,0.00,0.00,'2022-09-07 23:25:05','',''),(2131,'21','238','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,2550.90,0.00,'2022-09-07 23:26:13','',''),(2132,'21','238','3',0,'Inventory adjustment from tank dipping to 3567',0.00,0.00,3567.00,0.00,0.00,'2022-09-07 23:26:13','',''),(2133,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,6270000.00,33000.00,0.00,0.00,'2022-09-12 18:34:10','',''),(2134,'21','238',NULL,1,'Reception corrector for bridging 236',0.00,0.00,0.00,10000.00,0.00,'2022-09-12 18:35:52','',''),(2135,'21','238','3',1,'Received from bridging 236',0.00,0.00,10000.00,0.00,0.00,'2022-09-12 18:35:52','',''),(2136,'21','238',NULL,1,'Reception corrector for bridging 235',0.00,0.00,0.00,23000.00,0.00,'2022-09-12 18:36:04','',''),(2137,'21','238','1',1,'Received from bridging 235',0.00,0.00,23000.00,0.00,0.00,'2022-09-12 18:36:04','',''),(2138,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8493000.00,44700.00,0.00,0.00,'2022-09-12 19:26:29','',''),(2139,'21','238',NULL,1,'Reception corrector for bridging 238',0.00,0.00,0.00,11700.00,0.00,'2022-09-12 19:32:58','',''),(2140,'21','238','2',1,'Received from bridging 238',0.00,0.00,11700.00,0.00,0.00,'2022-09-12 19:32:58','',''),(2141,'21','238','1',1,'Sale Id shift 179',0.00,0.00,0.00,1790.89,0.00,'2022-09-12 19:37:09','',''),(2142,'21','238','3',1,'Sale Id shift 179',0.00,0.00,0.00,1854.58,0.00,'2022-09-12 19:37:09','',''),(2143,'21','238','4',2,'Sale Id shift 179',0.00,0.00,0.00,4073.51,0.00,'2022-09-12 19:37:09','',''),(2144,'21','238','5',2,'Sale Id shift 179',0.00,0.00,0.00,1326.62,0.00,'2022-09-12 19:37:09','',''),(2145,'21','238','5',2,'Sale Id shift 179',0.00,0.00,0.00,1520.23,0.00,'2022-09-12 19:37:09','',''),(2146,'21','238','6',3,'Sale Id shift 179',0.00,0.00,0.00,30.20,0.00,'2022-09-12 19:37:09','',''),(2147,'21','238','1',1,'Sale Id shift 179',0.00,0.00,0.00,1955.20,0.00,'2022-09-12 19:37:09','',''),(2148,'21','238','2',1,'Sale Id shift 179',0.00,0.00,0.00,4770.59,0.00,'2022-09-12 19:37:09','',''),(2149,'21','238','3',1,'Sale Id shift 179',0.00,0.00,0.00,1642.58,0.00,'2022-09-12 19:37:09','',''),(2150,'21','238',NULL,1,'Sale Id shift 179',2282629.60,0.00,0.00,0.00,0.00,'2022-09-12 19:37:09','',''),(2151,'21','238',NULL,2,'Sale Id shift 179',5522447.28,0.00,0.00,0.00,0.00,'2022-09-12 19:37:09','',''),(2152,'21','238',NULL,3,'Sale Id shift 179',25972.00,0.00,0.00,0.00,0.00,'2022-09-12 19:37:09','',''),(2153,'21','238','4',2,'Sale Id shift 180',0.00,0.00,0.00,3422.17,0.00,'2022-09-12 20:56:51','',''),(2154,'21','238','5',2,'Sale Id shift 180',0.00,0.00,0.00,2115.53,0.00,'2022-09-12 20:56:51','',''),(2155,'21','238','5',2,'Sale Id shift 180',0.00,0.00,0.00,643.99,0.00,'2022-09-12 20:56:51','',''),(2156,'21','238','6',3,'Sale Id shift 180',0.00,0.00,0.00,74.86,0.00,'2022-09-12 20:56:51','',''),(2157,'21','238',NULL,2,'Sale Id shift 180',4932988.62,0.00,0.00,0.00,0.00,'2022-09-12 20:56:51','',''),(2158,'21','238',NULL,3,'Sale Id shift 180',64379.60,0.00,0.00,0.00,0.00,'2022-09-12 20:56:51','',''),(2159,'21','238','1',1,'Sale Id shift 181',0.00,0.00,0.00,7215.57,0.00,'2022-09-12 21:27:39','',''),(2160,'21','238','3',1,'Sale Id shift 181',0.00,0.00,0.00,900.22,0.00,'2022-09-12 21:27:39','',''),(2161,'21','238','4',2,'Sale Id shift 181',0.00,0.00,0.00,2535.65,0.00,'2022-09-12 21:27:39','',''),(2162,'21','238','5',2,'Sale Id shift 181',0.00,0.00,0.00,1037.06,0.00,'2022-09-12 21:27:39','',''),(2163,'21','238','5',2,'Sale Id shift 181',0.00,0.00,0.00,1739.03,0.00,'2022-09-12 21:27:39','',''),(2164,'21','238','6',3,'Sale Id shift 181',0.00,0.00,0.00,35.63,0.00,'2022-09-12 21:27:39','',''),(2165,'21','238','1',1,'Sale Id shift 181',0.00,0.00,0.00,7469.16,0.00,'2022-09-12 21:27:39','',''),(2166,'21','238','3',1,'Sale Id shift 181',0.00,0.00,0.00,1048.16,0.00,'2022-09-12 21:27:39','',''),(2167,'21','238',NULL,1,'Sale Id shift 181',3160290.90,0.00,0.00,0.00,0.00,'2022-09-12 21:27:39','',''),(2168,'21','238',NULL,2,'Sale Id shift 181',4238768.52,0.00,0.00,0.00,0.00,'2022-09-12 21:27:39','',''),(2169,'21','238',NULL,3,'Sale Id shift 181',30641.80,0.00,0.00,0.00,0.00,'2022-09-12 21:27:39','',''),(2170,'21','238','1',1,'Sale Id shift 182',0.00,0.00,0.00,3525.23,0.00,'2022-09-13 13:38:49','',''),(2171,'21','238','3',1,'Sale Id shift 182',0.00,0.00,0.00,3790.99,0.00,'2022-09-13 13:38:49','',''),(2172,'21','238','4',2,'Sale Id shift 182',0.00,0.00,0.00,2356.79,0.00,'2022-09-13 13:38:49','',''),(2173,'21','238','5',2,'Sale Id shift 182',0.00,0.00,0.00,1713.61,0.00,'2022-09-13 13:38:49','',''),(2174,'21','238','5',2,'Sale Id shift 182',0.00,0.00,0.00,1545.05,0.00,'2022-09-13 13:38:49','',''),(2175,'21','238','6',3,'Sale Id shift 182',0.00,0.00,0.00,37.26,0.00,'2022-09-13 13:38:49','',''),(2176,'21','238','1',1,'Sale Id shift 182',0.00,0.00,0.00,4149.34,0.00,'2022-09-13 13:38:49','',''),(2177,'21','238','3',1,'Sale Id shift 182',0.00,0.00,0.00,3494.04,0.00,'2022-09-13 13:38:49','',''),(2178,'21','238',NULL,1,'Sale Id shift 182',2842324.00,0.00,0.00,0.00,0.00,'2022-09-13 13:38:49','',''),(2179,'21','238',NULL,2,'Sale Id shift 182',4481129.10,0.00,0.00,0.00,0.00,'2022-09-13 13:38:49','',''),(2180,'21','238',NULL,3,'Sale Id shift 182',32043.60,0.00,0.00,0.00,0.00,'2022-09-13 13:38:49','',''),(2181,'21','238',NULL,1,'Reception corrector for bridging 239',0.00,0.00,0.00,23000.00,0.00,'2022-09-13 19:05:27','',''),(2182,'21','238','3',1,'Received from bridging 239',0.00,0.00,23000.00,0.00,0.00,'2022-09-13 19:05:27','',''),(2183,'21','238',NULL,1,'Reception corrector for bridging 237',0.00,0.00,0.00,10000.00,0.00,'2022-09-13 19:05:41','',''),(2184,'21','238','1',1,'Received from bridging 237',0.00,0.00,10000.00,0.00,0.00,'2022-09-13 19:05:41','',''),(2185,'21','238','1',1,'Sale Id shift 183',0.00,0.00,0.00,1960.95,0.00,'2022-09-13 19:08:42','',''),(2186,'21','238','3',1,'Sale Id shift 183',0.00,0.00,0.00,3446.44,0.00,'2022-09-13 19:08:42','',''),(2187,'21','238','4',2,'Sale Id shift 183',0.00,0.00,0.00,2836.88,0.00,'2022-09-13 19:08:42','',''),(2188,'21','238','5',2,'Sale Id shift 183',0.00,0.00,0.00,2607.62,0.00,'2022-09-13 19:08:42','',''),(2189,'21','238','5',2,'Sale Id shift 183',0.00,0.00,0.00,879.47,0.00,'2022-09-13 19:08:42','',''),(2190,'21','238','6',3,'Sale Id shift 183',0.00,0.00,0.00,28.19,0.00,'2022-09-13 19:08:42','',''),(2191,'21','238','1',1,'Sale Id shift 183',0.00,0.00,0.00,4046.26,0.00,'2022-09-13 19:08:42','',''),(2192,'21','238','2',1,'Sale Id shift 183',0.00,0.00,0.00,1588.81,0.00,'2022-09-13 19:08:42','',''),(2193,'21','238','3',1,'Sale Id shift 183',0.00,0.00,0.00,4614.58,0.00,'2022-09-13 19:08:42','',''),(2194,'21','238',NULL,2,'Sale Id shift 183',5046528.06,0.00,0.00,0.00,0.00,'2022-09-13 19:08:42','',''),(2195,'21','238',NULL,3,'Sale Id shift 183',24243.40,0.00,0.00,0.00,0.00,'2022-09-13 19:08:42','',''),(2196,'21','238',NULL,1,'Sale Id shift 183',2974837.60,0.00,0.00,0.00,0.00,'2022-09-13 19:08:42','',''),(2197,'21','238','1',1,'Sale Id shift 184',0.00,0.00,0.00,1616.42,0.00,'2022-09-13 19:42:38','',''),(2198,'21','238','3',1,'Sale Id shift 184',0.00,0.00,0.00,3446.06,0.00,'2022-09-13 19:42:38','',''),(2199,'21','238','4',2,'Sale Id shift 184',0.00,0.00,0.00,1930.60,0.00,'2022-09-13 19:42:38','',''),(2200,'21','238','5',2,'Sale Id shift 184',0.00,0.00,0.00,1657.57,0.00,'2022-09-13 19:42:38','',''),(2201,'21','238','5',2,'Sale Id shift 184',0.00,0.00,0.00,1381.85,0.00,'2022-09-13 19:42:38','',''),(2202,'21','238','6',3,'Sale Id shift 184',0.00,0.00,0.00,59.65,0.00,'2022-09-13 19:42:38','',''),(2203,'21','238','1',1,'Sale Id shift 184',0.00,0.00,0.00,2910.81,0.00,'2022-09-13 19:42:38','',''),(2204,'21','238','2',1,'Sale Id shift 184',0.00,0.00,0.00,3714.68,0.00,'2022-09-13 19:42:38','',''),(2205,'21','238','3',1,'Sale Id shift 184',0.00,0.00,0.00,3476.10,0.00,'2022-09-13 19:42:38','',''),(2206,'21','238',NULL,1,'Sale Id shift 184',2881173.30,0.00,0.00,0.00,0.00,'2022-09-13 19:42:38','',''),(2207,'21','238',NULL,2,'Sale Id shift 184',3966075.96,0.00,0.00,0.00,0.00,'2022-09-13 19:42:38','',''),(2208,'21','238',NULL,3,'Sale Id shift 184',51299.00,0.00,0.00,0.00,0.00,'2022-09-13 19:42:38','',''),(2209,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5339000.00,28100.00,0.00,0.00,'2022-09-13 20:27:35','',''),(2210,'21','238',NULL,1,'Reception corrector for bridging 241',0.00,0.00,0.00,6500.00,0.00,'2022-09-13 20:29:37','',''),(2211,'21','238','3',1,'Received from bridging 241',0.00,0.00,6500.00,0.00,0.00,'2022-09-13 20:29:37','',''),(2212,'21','238',NULL,1,'Reception corrector for bridging 240',0.00,0.00,0.00,21600.00,0.00,'2022-09-13 20:29:51','',''),(2213,'21','238','2',1,'Received from bridging 240',0.00,0.00,21600.00,0.00,0.00,'2022-09-13 20:29:51','',''),(2214,'21','238','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,2173.35,0.00,'2022-09-14 16:43:55','',''),(2215,'21','238','4',0,'Inventory adjustment from tank dipping to 2673',0.00,0.00,2673.00,0.00,0.00,'2022-09-14 16:43:55','',''),(2216,'21','238','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,2673.00,0.00,'2022-09-14 16:43:55','',''),(2217,'21','238','4',0,'Inventory adjustment from tank dipping to 2673',0.00,0.00,2673.00,0.00,0.00,'2022-09-14 16:43:55','',''),(2218,'21','238','3',1,'Sale Id shift 185',0.00,0.00,0.00,4911.14,0.00,'2022-09-14 19:45:22','',''),(2219,'21','238','4',2,'Sale Id shift 185',0.00,0.00,0.00,2582.17,0.00,'2022-09-14 19:45:22','',''),(2220,'21','238','5',2,'Sale Id shift 185',0.00,0.00,0.00,2545.96,0.00,'2022-09-14 19:45:22','',''),(2221,'21','238','6',3,'Sale Id shift 185',0.00,0.00,0.00,52.21,0.00,'2022-09-14 19:45:22','',''),(2222,'21','238','2',1,'Sale Id shift 185',0.00,0.00,0.00,5672.55,0.00,'2022-09-14 19:45:22','',''),(2223,'21','238','3',1,'Sale Id shift 185',0.00,0.00,0.00,5486.70,0.00,'2022-09-14 19:45:22','',''),(2224,'21','238',NULL,2,'Sale Id shift 185',4092247.74,0.00,0.00,0.00,0.00,'2022-09-14 19:45:22','',''),(2225,'21','238',NULL,3,'Sale Id shift 185',44900.60,0.00,0.00,0.00,0.00,'2022-09-14 19:45:22','',''),(2226,'21','238',NULL,1,'Sale Id shift 185',3053374.10,0.00,0.00,0.00,0.00,'2022-09-14 19:45:22','',''),(2227,'21','238','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,4955.41,0.00,'2022-09-14 20:39:54','',''),(2228,'21','238','3',0,'Inventory adjustment from tank dipping to 5455',0.00,0.00,5455.00,0.00,0.00,'2022-09-14 20:39:54','',''),(2229,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5890000.00,31000.00,0.00,0.00,'2022-09-14 20:40:24','',''),(2230,'21','238',NULL,1,'Reception corrector for bridging 242',0.00,0.00,0.00,31000.00,0.00,'2022-09-14 20:44:10','',''),(2231,'21','238','1',1,'Received from bridging 242',0.00,0.00,31000.00,0.00,0.00,'2022-09-14 20:44:10','',''),(2232,'21','238','1',1,'Sale Id shift 186',0.00,0.00,0.00,1916.18,0.00,'2022-09-14 21:48:42','',''),(2233,'21','238','3',1,'Sale Id shift 186',0.00,0.00,0.00,2959.28,0.00,'2022-09-14 21:48:42','',''),(2234,'21','238','6',3,'Sale Id shift 186',0.00,0.00,0.00,23.79,0.00,'2022-09-14 21:48:42','',''),(2235,'21','238','1',1,'Sale Id shift 186',0.00,0.00,0.00,4221.06,0.00,'2022-09-14 21:48:42','',''),(2236,'21','238','2',1,'Sale Id shift 186',0.00,0.00,0.00,3336.16,0.00,'2022-09-14 21:48:42','',''),(2237,'21','238','3',1,'Sale Id shift 186',0.00,0.00,0.00,2313.48,0.00,'2022-09-14 21:48:42','',''),(2238,'21','238',NULL,3,'Sale Id shift 186',20459.40,0.00,0.00,0.00,0.00,'2022-09-14 21:48:42','',''),(2239,'21','238',NULL,1,'Sale Id shift 186',2801770.40,0.00,0.00,0.00,0.00,'2022-09-14 21:48:42','',''),(2240,'21','238','1',1,'Sale Id shift 187',0.00,0.00,0.00,2792.81,0.00,'2022-09-15 11:16:07','',''),(2241,'21','238','6',3,'Sale Id shift 187',0.00,0.00,0.00,32.93,0.00,'2022-09-15 11:16:07','',''),(2242,'21','238','1',1,'Sale Id shift 187',0.00,0.00,0.00,6739.71,0.00,'2022-09-15 11:16:07','',''),(2243,'21','238','2',1,'Sale Id shift 187',0.00,0.00,0.00,6712.92,0.00,'2022-09-15 11:16:07','',''),(2244,'21','238',NULL,1,'Sale Id shift 187',3086633.60,0.00,0.00,0.00,0.00,'2022-09-15 11:16:07','',''),(2245,'21','238',NULL,3,'Sale Id shift 187',28319.80,0.00,0.00,0.00,0.00,'2022-09-15 11:16:07','',''),(2246,'21','238','1',1,'Sale Id shift 188',0.00,0.00,0.00,1432.50,0.00,'2022-09-16 12:52:35','',''),(2247,'21','238','6',3,'Sale Id shift 188',0.00,0.00,0.00,79.30,0.00,'2022-09-16 12:52:35','',''),(2248,'21','238','1',1,'Sale Id shift 188',0.00,0.00,0.00,6208.26,0.00,'2022-09-16 12:52:35','',''),(2249,'21','238','2',1,'Sale Id shift 188',0.00,0.00,0.00,6744.25,0.00,'2022-09-16 12:52:35','',''),(2250,'21','238',NULL,1,'Sale Id shift 188',2733151.90,0.00,0.00,0.00,0.00,'2022-09-16 12:52:35','',''),(2251,'21','238',NULL,3,'Sale Id shift 188',68198.00,0.00,0.00,0.00,0.00,'2022-09-16 12:52:35','',''),(2252,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5605000.00,29500.00,0.00,0.00,'2022-09-17 12:53:00','',''),(2253,'21','238',NULL,1,'Reception corrector for bridging 244',0.00,0.00,0.00,15000.00,0.00,'2022-09-17 12:56:29','',''),(2254,'21','238','3',1,'Received from bridging 244',0.00,0.00,15000.00,0.00,0.00,'2022-09-17 12:56:29','',''),(2255,'21','238',NULL,1,'Reception corrector for bridging 243',0.00,0.00,0.00,14500.00,0.00,'2022-09-17 12:56:48','',''),(2256,'21','238','2',1,'Received from bridging 243',0.00,0.00,14500.00,0.00,0.00,'2022-09-17 12:56:48','',''),(2257,'21','238','3',1,'Sale Id shift 189',0.00,0.00,0.00,2062.27,0.00,'2022-09-17 13:06:19','',''),(2258,'21','238','6',3,'Sale Id shift 189',0.00,0.00,0.00,33.48,0.00,'2022-09-17 13:06:19','',''),(2259,'21','238','1',1,'Sale Id shift 189',0.00,0.00,0.00,5110.82,0.00,'2022-09-17 13:06:19','',''),(2260,'21','238','2',1,'Sale Id shift 189',0.00,0.00,0.00,2925.76,0.00,'2022-09-17 13:06:19','',''),(2261,'21','238','3',1,'Sale Id shift 189',0.00,0.00,0.00,2614.46,0.00,'2022-09-17 13:06:19','',''),(2262,'21','238',NULL,1,'Sale Id shift 189',2415528.90,0.00,0.00,0.00,0.00,'2022-09-17 13:06:19','',''),(2263,'21','238',NULL,3,'Sale Id shift 189',28792.80,0.00,0.00,0.00,0.00,'2022-09-17 13:06:19','',''),(2264,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,11970000.00,15000.00,0.00,0.00,'2022-09-18 17:28:40','',''),(2265,'21','238',NULL,2,'Reception corrector for bridging 245',0.00,0.00,0.00,15000.00,0.00,'2022-09-18 17:29:58','',''),(2266,'21','238','4',2,'Received from bridging 245',0.00,0.00,15000.00,0.00,0.00,'2022-09-18 17:29:58','',''),(2267,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5700000.00,30000.00,0.00,0.00,'2022-09-18 17:31:53','',''),(2268,'21','238',NULL,1,'Reception corrector for bridging 247',0.00,0.00,0.00,15000.00,0.00,'2022-09-18 17:33:39','',''),(2269,'21','238','3',1,'Received from bridging 247',0.00,0.00,15000.00,0.00,0.00,'2022-09-18 17:33:39','',''),(2270,'21','238',NULL,1,'Reception corrector for bridging 246',0.00,0.00,0.00,15000.00,0.00,'2022-09-18 17:33:51','',''),(2271,'21','238','1',1,'Received from bridging 246',0.00,0.00,15000.00,0.00,0.00,'2022-09-18 17:33:51','',''),(2272,'21','238','1',1,'Sale Id shift 190',0.00,0.00,0.00,57.50,0.00,'2022-09-18 17:38:47','',''),(2273,'21','238','3',1,'Sale Id shift 190',0.00,0.00,0.00,2345.39,0.00,'2022-09-18 17:38:47','',''),(2274,'21','238','4',2,'Sale Id shift 190',0.00,0.00,0.00,4275.49,0.00,'2022-09-18 17:38:47','',''),(2275,'21','238','6',3,'Sale Id shift 190',0.00,0.00,0.00,33.17,0.00,'2022-09-18 17:38:47','',''),(2276,'21','238','1',1,'Sale Id shift 190',0.00,0.00,0.00,4007.85,0.00,'2022-09-18 17:38:47','',''),(2277,'21','238','2',1,'Sale Id shift 190',0.00,0.00,0.00,3641.05,0.00,'2022-09-18 17:38:47','',''),(2278,'21','238','3',1,'Sale Id shift 190',0.00,0.00,0.00,3362.67,0.00,'2022-09-18 17:38:47','',''),(2279,'21','238',NULL,1,'Sale Id shift 190',2548747.40,0.00,0.00,0.00,0.00,'2022-09-18 17:38:47','',''),(2280,'21','238',NULL,2,'Sale Id shift 190',3411841.02,0.00,0.00,0.00,0.00,'2022-09-18 17:38:47','',''),(2281,'21','238',NULL,3,'Sale Id shift 190',28526.20,0.00,0.00,0.00,0.00,'2022-09-18 17:38:47','',''),(2282,'21','238','3',1,'Sale Id shift 191',0.00,0.00,0.00,2986.73,0.00,'2022-09-19 18:33:35','',''),(2283,'21','238','4',2,'Sale Id shift 191',0.00,0.00,0.00,7845.91,0.00,'2022-09-19 18:33:35','',''),(2284,'21','238','6',3,'Sale Id shift 191',0.00,0.00,0.00,25.12,0.00,'2022-09-19 18:33:35','',''),(2285,'21','238','1',1,'Sale Id shift 191',0.00,0.00,0.00,3975.52,0.00,'2022-09-19 18:33:35','',''),(2286,'21','238','2',1,'Sale Id shift 191',0.00,0.00,0.00,2844.16,0.00,'2022-09-19 18:33:35','',''),(2287,'21','238','3',1,'Sale Id shift 191',0.00,0.00,0.00,3346.32,0.00,'2022-09-19 18:33:35','',''),(2288,'21','238',NULL,1,'Sale Id shift 191',2499018.70,0.00,0.00,0.00,0.00,'2022-09-19 18:33:35','',''),(2289,'21','238',NULL,2,'Sale Id shift 191',6261036.18,0.00,0.00,0.00,0.00,'2022-09-19 18:33:35','',''),(2290,'21','238',NULL,3,'Sale Id shift 191',21603.20,0.00,0.00,0.00,0.00,'2022-09-19 18:33:35','',''),(2291,'21','238','1',1,'Sale Id shift 192',0.00,0.00,0.00,599.90,0.00,'2022-09-20 14:11:36','',''),(2292,'21','238','3',1,'Sale Id shift 192',0.00,0.00,0.00,1779.43,0.00,'2022-09-20 14:11:36','',''),(2293,'21','238','4',2,'Sale Id shift 192',0.00,0.00,0.00,2823.52,0.00,'2022-09-20 14:11:36','',''),(2294,'21','238','6',3,'Sale Id shift 192',0.00,0.00,0.00,46.42,0.00,'2022-09-20 14:11:36','',''),(2295,'21','238','1',1,'Sale Id shift 192',0.00,0.00,0.00,3271.31,0.00,'2022-09-20 14:11:36','',''),(2296,'21','238','2',1,'Sale Id shift 192',0.00,0.00,0.00,1972.90,0.00,'2022-09-20 14:11:36','',''),(2297,'21','238','3',1,'Sale Id shift 192',0.00,0.00,0.00,2276.34,0.00,'2022-09-20 14:11:36','',''),(2298,'21','238',NULL,1,'Sale Id shift 192',1880977.20,0.00,0.00,0.00,0.00,'2022-09-20 14:11:36','',''),(2299,'21','238',NULL,2,'Sale Id shift 192',2253168.96,0.00,0.00,0.00,0.00,'2022-09-20 14:11:36','',''),(2300,'21','238',NULL,3,'Sale Id shift 192',39921.20,0.00,0.00,0.00,0.00,'2022-09-20 14:11:36','',''),(2301,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8550000.00,45000.00,0.00,0.00,'2022-09-21 11:46:42','',''),(2302,'21','238',NULL,1,'Reception corrector for bridging 250',0.00,0.00,0.00,15000.00,0.00,'2022-09-21 11:54:46','',''),(2303,'21','238','3',1,'Received from bridging 250',0.00,0.00,15000.00,0.00,0.00,'2022-09-21 11:54:46','',''),(2304,'21','238',NULL,1,'Reception corrector for bridging 249',0.00,0.00,0.00,15000.00,0.00,'2022-09-21 11:54:59','',''),(2305,'21','238','2',1,'Received from bridging 249',0.00,0.00,15000.00,0.00,0.00,'2022-09-21 11:54:59','',''),(2306,'21','238',NULL,1,'Reception corrector for bridging 248',0.00,0.00,0.00,15000.00,0.00,'2022-09-21 11:55:09','',''),(2307,'21','238','1',1,'Received from bridging 248',0.00,0.00,15000.00,0.00,0.00,'2022-09-21 11:55:09','',''),(2308,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,11970000.00,15000.00,0.00,0.00,'2022-09-21 16:42:07','',''),(2309,'21','238',NULL,2,'Reception corrector for bridging 251',0.00,0.00,0.00,99257105.00,0.00,'2022-09-21 16:44:11','',''),(2310,'21','238','4',2,'Received from bridging 251',0.00,0.00,99257105.00,0.00,0.00,'2022-09-21 16:44:11','',''),(2311,'21','238','4',2,'Returned bridging 251',0.00,0.00,0.00,99257105.00,0.00,'2022-09-21 16:48:13','',''),(2312,'21','238',NULL,2,'Reception Return corrector for bridging 251',0.00,0.00,99257105.00,0.00,0.00,'2022-09-21 16:48:13','',''),(2313,'21','238',NULL,2,'Reception corrector for bridging 252',0.00,0.00,0.00,15000.00,0.00,'2022-09-21 16:50:50','',''),(2314,'21','238','4',2,'Received from bridging 252',0.00,0.00,15000.00,0.00,0.00,'2022-09-21 16:50:50','',''),(2315,'21','238','1',1,'Sale Id shift 193',0.00,0.00,0.00,1345.18,0.00,'2022-09-21 16:55:35','',''),(2316,'21','238','3',1,'Sale Id shift 193',0.00,0.00,0.00,2204.52,0.00,'2022-09-21 16:55:35','',''),(2317,'21','238','4',2,'Sale Id shift 193',0.00,0.00,0.00,2045.60,0.00,'2022-09-21 16:55:35','',''),(2318,'21','238','6',3,'Sale Id shift 193',0.00,0.00,0.00,48.75,0.00,'2022-09-21 16:55:35','',''),(2319,'21','238','1',1,'Sale Id shift 193',0.00,0.00,0.00,3196.03,0.00,'2022-09-21 16:55:35','',''),(2320,'21','238','2',1,'Sale Id shift 193',0.00,0.00,0.00,3247.83,0.00,'2022-09-21 16:55:35','',''),(2321,'21','238','3',1,'Sale Id shift 193',0.00,0.00,0.00,2234.74,0.00,'2022-09-21 16:55:35','',''),(2322,'21','238',NULL,1,'Sale Id shift 193',2323377.00,0.00,0.00,0.00,0.00,'2022-09-21 16:55:35','',''),(2323,'21','238',NULL,2,'Sale Id shift 193',1632388.80,0.00,0.00,0.00,0.00,'2022-09-21 16:55:35','',''),(2324,'21','238',NULL,3,'Sale Id shift 193',41925.00,0.00,0.00,0.00,0.00,'2022-09-21 16:55:35','',''),(2325,'21','238','1',1,'Sale Id shift 194',0.00,0.00,0.00,1693.72,0.00,'2022-09-22 12:58:03','',''),(2326,'21','238','3',1,'Sale Id shift 194',0.00,0.00,0.00,1080.24,0.00,'2022-09-22 12:58:03','',''),(2327,'21','238','1',1,'Sale Id shift 194',0.00,0.00,0.00,1590.72,0.00,'2022-09-22 12:58:03','',''),(2328,'21','238','2',1,'Sale Id shift 194',0.00,0.00,0.00,1727.01,0.00,'2022-09-22 12:58:03','',''),(2329,'21','238','3',1,'Sale Id shift 194',0.00,0.00,0.00,1426.95,0.00,'2022-09-22 12:58:03','',''),(2330,'21','238',NULL,1,'Sale Id shift 194',1428541.60,0.00,0.00,0.00,0.00,'2022-09-22 12:58:03','',''),(2331,'21','238','1',1,'Sale Id shift 195',0.00,0.00,0.00,648.96,0.00,'2022-09-22 13:06:51','',''),(2332,'21','238','3',1,'Sale Id shift 195',0.00,0.00,0.00,817.53,0.00,'2022-09-22 13:06:51','',''),(2333,'21','238','4',2,'Sale Id shift 195',0.00,0.00,0.00,6619.44,0.00,'2022-09-22 13:06:51','',''),(2334,'21','238','6',3,'Sale Id shift 195',0.00,0.00,0.00,30.53,0.00,'2022-09-22 13:06:51','',''),(2335,'21','238','1',1,'Sale Id shift 195',0.00,0.00,0.00,1380.60,0.00,'2022-09-22 13:06:51','',''),(2336,'21','238','2',1,'Sale Id shift 195',0.00,0.00,0.00,857.81,0.00,'2022-09-22 13:06:51','',''),(2337,'21','238','3',1,'Sale Id shift 195',0.00,0.00,0.00,1234.95,0.00,'2022-09-22 13:06:51','',''),(2338,'21','238',NULL,1,'Sale Id shift 195',913872.25,0.00,0.00,0.00,0.00,'2022-09-22 13:06:51','',''),(2339,'21','238',NULL,2,'Sale Id shift 195',5282313.12,0.00,0.00,0.00,0.00,'2022-09-22 13:06:51','',''),(2340,'21','238',NULL,3,'Sale Id shift 195',26255.80,0.00,0.00,0.00,0.00,'2022-09-22 13:06:51','',''),(2341,'21','238','1',1,'Sale Id shift 196',0.00,0.00,0.00,1758.14,0.00,'2022-09-23 17:27:43','',''),(2342,'21','238','3',1,'Sale Id shift 196',0.00,0.00,0.00,2161.56,0.00,'2022-09-23 17:27:43','',''),(2343,'21','238','4',2,'Sale Id shift 196',0.00,0.00,0.00,6434.87,0.00,'2022-09-23 17:27:43','',''),(2344,'21','238','6',3,'Sale Id shift 196',0.00,0.00,0.00,36.01,0.00,'2022-09-23 17:27:43','',''),(2345,'21','238','1',1,'Sale Id shift 196',0.00,0.00,0.00,3098.70,0.00,'2022-09-23 17:27:43','',''),(2346,'21','238','2',1,'Sale Id shift 196',0.00,0.00,0.00,2560.35,0.00,'2022-09-23 17:27:43','',''),(2347,'21','238','3',1,'Sale Id shift 196',0.00,0.00,0.00,3494.42,0.00,'2022-09-23 17:27:43','',''),(2348,'21','238',NULL,1,'Sale Id shift 196',2418536.45,0.00,0.00,0.00,0.00,'2022-09-23 17:27:43','',''),(2349,'21','238',NULL,2,'Sale Id shift 196',5135026.26,0.00,0.00,0.00,0.00,'2022-09-23 17:27:43','',''),(2350,'21','238',NULL,3,'Sale Id shift 196',30968.60,0.00,0.00,0.00,0.00,'2022-09-23 17:27:43','',''),(2351,'21','238','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,6080.70,0.00,'2022-09-24 19:11:01','',''),(2352,'21','238','1',0,'Inventory adjustment from tank dipping to 6381',0.00,0.00,6381.00,0.00,0.00,'2022-09-24 19:11:01','',''),(2353,'21','238','1',1,'Sale Id shift 197',0.00,0.00,0.00,2314.99,0.00,'2022-09-25 12:12:47','',''),(2354,'21','238','3',1,'Sale Id shift 197',0.00,0.00,0.00,3529.31,0.00,'2022-09-25 12:12:47','',''),(2355,'21','238','6',3,'Sale Id shift 197',0.00,0.00,0.00,26.83,0.00,'2022-09-25 12:12:47','',''),(2356,'21','238','1',1,'Sale Id shift 197',0.00,0.00,0.00,3916.53,0.00,'2022-09-25 12:12:47','',''),(2357,'21','238','2',1,'Sale Id shift 197',0.00,0.00,0.00,3236.87,0.00,'2022-09-25 12:12:47','',''),(2358,'21','238','3',1,'Sale Id shift 197',0.00,0.00,0.00,2847.64,0.00,'2022-09-25 12:12:47','',''),(2359,'21','238',NULL,1,'Sale Id shift 197',2931387.90,0.00,0.00,0.00,0.00,'2022-09-25 12:12:47','',''),(2360,'21','238',NULL,3,'Sale Id shift 197',23073.80,0.00,0.00,0.00,0.00,'2022-09-25 12:12:47','',''),(2361,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2775000.00,15000.00,0.00,0.00,'2022-09-25 12:25:55','',''),(2362,'21','238',NULL,1,'Reception corrector for bridging 253',0.00,0.00,0.00,15000.00,0.00,'2022-09-25 12:28:32','',''),(2363,'21','238','1',1,'Received from bridging 253',0.00,0.00,15000.00,0.00,0.00,'2022-09-25 12:28:32','',''),(2364,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,3700000.00,20000.00,0.00,0.00,'2022-09-25 12:30:29','',''),(2365,'21','238',NULL,1,'Reception corrector for bridging 254',0.00,0.00,0.00,20000.00,0.00,'2022-09-25 12:32:31','',''),(2366,'21','238','3',1,'Received from bridging 254',0.00,0.00,20000.00,0.00,0.00,'2022-09-25 12:32:31','',''),(2367,'21','238','1',1,'Sale Id shift 198',0.00,0.00,0.00,2226.11,0.00,'2022-09-25 12:39:33','',''),(2368,'21','238','3',1,'Sale Id shift 198',0.00,0.00,0.00,2383.89,0.00,'2022-09-25 12:39:33','',''),(2369,'21','238','6',3,'Sale Id shift 198',0.00,0.00,0.00,23.26,0.00,'2022-09-25 12:39:33','',''),(2370,'21','238','1',1,'Sale Id shift 198',0.00,0.00,0.00,2111.01,0.00,'2022-09-25 12:39:33','',''),(2371,'21','238','2',1,'Sale Id shift 198',0.00,0.00,0.00,2347.55,0.00,'2022-09-25 12:39:33','',''),(2372,'21','238','3',1,'Sale Id shift 198',0.00,0.00,0.00,2515.42,0.00,'2022-09-25 12:39:33','',''),(2373,'21','238',NULL,1,'Sale Id shift 198',2143036.30,0.00,0.00,0.00,0.00,'2022-09-25 12:39:33','',''),(2374,'21','238',NULL,3,'Sale Id shift 198',20003.60,0.00,0.00,0.00,0.00,'2022-09-25 12:39:33','',''),(2375,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2775000.00,15000.00,0.00,0.00,'2022-09-26 14:29:49','',''),(2376,'21','238',NULL,1,'Reception corrector for bridging 255',0.00,0.00,0.00,15000.00,0.00,'2022-09-26 14:31:28','',''),(2377,'21','238','2',1,'Received from bridging 255',0.00,0.00,15000.00,0.00,0.00,'2022-09-26 14:31:28','',''),(2378,'21','238','1',1,'Sale Id shift 199',0.00,0.00,0.00,3095.89,0.00,'2022-09-26 14:47:27','',''),(2379,'21','238','3',1,'Sale Id shift 199',0.00,0.00,0.00,2751.75,0.00,'2022-09-26 14:47:27','',''),(2380,'21','238','6',3,'Sale Id shift 199',0.00,0.00,0.00,74.62,0.00,'2022-09-26 14:47:27','',''),(2381,'21','238','1',1,'Sale Id shift 199',0.00,0.00,0.00,3483.13,0.00,'2022-09-26 14:47:27','',''),(2382,'21','238','2',1,'Sale Id shift 199',0.00,0.00,0.00,2730.94,0.00,'2022-09-26 14:47:27','',''),(2383,'21','238','3',1,'Sale Id shift 199',0.00,0.00,0.00,3207.82,0.00,'2022-09-26 14:47:27','',''),(2384,'21','238',NULL,1,'Sale Id shift 199',2824863.05,0.00,0.00,0.00,0.00,'2022-09-26 14:47:27','',''),(2385,'21','238',NULL,3,'Sale Id shift 199',64173.20,0.00,0.00,0.00,0.00,'2022-09-26 14:47:27','',''),(2386,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,11890200.00,14900.00,0.00,0.00,'2022-09-27 15:51:53','',''),(2387,'21','238',NULL,2,'Reception corrector for bridging 256',0.00,0.00,0.00,14900.00,0.00,'2022-09-27 16:03:34','',''),(2388,'21','238','4',2,'Received from bridging 256',0.00,0.00,14900.00,0.00,0.00,'2022-09-27 16:03:34','',''),(2389,'21','238','1',1,'Sale Id shift 200',0.00,0.00,0.00,1674.95,0.00,'2022-09-27 16:13:14','',''),(2390,'21','238','3',1,'Sale Id shift 200',0.00,0.00,0.00,3424.06,0.00,'2022-09-27 16:13:14','',''),(2391,'21','238','4',2,'Sale Id shift 200',0.00,0.00,0.00,1718.77,0.00,'2022-09-27 16:13:14','',''),(2392,'21','238','6',3,'Sale Id shift 200',0.00,0.00,0.00,29.66,0.00,'2022-09-27 16:13:14','',''),(2393,'21','238','1',1,'Sale Id shift 200',0.00,0.00,0.00,1824.67,0.00,'2022-09-27 16:13:14','',''),(2394,'21','238','2',1,'Sale Id shift 200',0.00,0.00,0.00,3741.51,0.00,'2022-09-27 16:13:14','',''),(2395,'21','238','3',1,'Sale Id shift 200',0.00,0.00,0.00,3616.25,0.00,'2022-09-27 16:13:14','',''),(2396,'21','238',NULL,1,'Sale Id shift 200',2642066.40,0.00,0.00,0.00,0.00,'2022-09-27 16:13:14','',''),(2397,'21','238',NULL,2,'Sale Id shift 200',1371578.46,0.00,0.00,0.00,0.00,'2022-09-27 16:13:14','',''),(2398,'21','238',NULL,3,'Sale Id shift 200',25507.60,0.00,0.00,0.00,0.00,'2022-09-27 16:13:14','',''),(2399,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8325000.00,45000.00,0.00,0.00,'2022-09-27 16:50:01','',''),(2400,'21','238',NULL,1,'Reception corrector for bridging 258',0.00,0.00,0.00,15000.00,0.00,'2022-09-27 16:53:11','',''),(2401,'21','238','3',1,'Received from bridging 258',0.00,0.00,15000.00,0.00,0.00,'2022-09-27 16:53:11','',''),(2402,'21','238',NULL,1,'Reception corrector for bridging 257',0.00,0.00,0.00,30000.00,0.00,'2022-09-27 16:53:36','',''),(2403,'21','238','1',1,'Received from bridging 257',0.00,0.00,30000.00,0.00,0.00,'2022-09-27 16:53:36','',''),(2404,'21','238','1',1,'Sale Id shift 201',0.00,0.00,0.00,2315.30,0.00,'2022-09-28 21:12:48','',''),(2405,'21','238','3',1,'Sale Id shift 201',0.00,0.00,0.00,1719.79,0.00,'2022-09-28 21:12:48','',''),(2406,'21','238','4',2,'Sale Id shift 201',0.00,0.00,0.00,7270.10,0.00,'2022-09-28 21:12:48','',''),(2407,'21','238','6',3,'Sale Id shift 201',0.00,0.00,0.00,47.06,0.00,'2022-09-28 21:12:48','',''),(2408,'21','238','1',1,'Sale Id shift 201',0.00,0.00,0.00,4052.05,0.00,'2022-09-28 21:12:48','',''),(2409,'21','238','2',1,'Sale Id shift 201',0.00,0.00,0.00,929.67,0.00,'2022-09-28 21:12:48','',''),(2410,'21','238','3',1,'Sale Id shift 201',0.00,0.00,0.00,3788.05,0.00,'2022-09-28 21:12:48','',''),(2411,'21','238',NULL,2,'Sale Id shift 201',5801539.80,0.00,0.00,0.00,0.00,'2022-09-28 21:12:48','',''),(2412,'21','238',NULL,3,'Sale Id shift 201',40471.60,0.00,0.00,0.00,0.00,'2022-09-28 21:12:49','',''),(2413,'21','238',NULL,1,'Sale Id shift 201',2368899.10,0.00,0.00,0.00,0.00,'2022-09-28 21:12:49','',''),(2414,'21','238','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,5957.13,0.00,'2022-09-29 13:27:32','',''),(2415,'21','238','4',0,'Inventory adjustment from tank dipping to 6107',0.00,0.00,6107.00,0.00,0.00,'2022-09-29 13:27:32','',''),(2416,'21','238','1',1,'Sale Id shift 203',0.00,0.00,0.00,2942.92,0.00,'2022-09-29 17:37:15','',''),(2417,'21','238','3',1,'Sale Id shift 203',0.00,0.00,0.00,2635.62,0.00,'2022-09-29 17:37:15','',''),(2418,'21','238','4',2,'Sale Id shift 203',0.00,0.00,0.00,6037.25,0.00,'2022-09-29 17:37:15','',''),(2419,'21','238','6',3,'Sale Id shift 203',0.00,0.00,0.00,19.12,0.00,'2022-09-29 17:37:15','',''),(2420,'21','238','1',1,'Sale Id shift 203',0.00,0.00,0.00,3576.97,0.00,'2022-09-29 17:37:15','',''),(2421,'21','238','2',1,'Sale Id shift 203',0.00,0.00,0.00,294.12,0.00,'2022-09-29 17:37:15','',''),(2422,'21','238','2',1,'Sale Id shift 203',0.00,0.00,0.00,2914.13,0.00,'2022-09-29 17:37:15','',''),(2423,'21','238','3',1,'Sale Id shift 203',0.00,0.00,0.00,2214.32,0.00,'2022-09-29 17:37:15','',''),(2424,'21','238',NULL,1,'Sale Id shift 203',2696944.80,0.00,0.00,0.00,0.00,'2022-09-29 17:37:15','',''),(2425,'21','238',NULL,2,'Sale Id shift 203',4817725.50,0.00,0.00,0.00,0.00,'2022-09-29 17:37:15','',''),(2426,'21','238',NULL,3,'Sale Id shift 203',16443.20,0.00,0.00,0.00,0.00,'2022-09-29 17:37:15','',''),(2427,'21','238','1',1,'Sale Id shift 204',0.00,0.00,0.00,3566.85,0.00,'2022-10-12 16:51:26','',''),(2428,'21','238','3',1,'Sale Id shift 204',0.00,0.00,0.00,3339.84,0.00,'2022-10-12 16:51:26','',''),(2429,'21','238','6',3,'Sale Id shift 204',0.00,0.00,0.00,64.60,0.00,'2022-10-12 16:51:26','',''),(2430,'21','238','1',1,'Sale Id shift 204',0.00,0.00,0.00,3565.58,0.00,'2022-10-12 16:51:26','',''),(2431,'21','238','2',1,'Sale Id shift 204',0.00,0.00,0.00,1.24,0.00,'2022-10-12 16:51:26','',''),(2432,'21','238','2',1,'Sale Id shift 204',0.00,0.00,0.00,3040.40,0.00,'2022-10-12 16:51:26','',''),(2433,'21','238','3',1,'Sale Id shift 204',0.00,0.00,0.00,3374.17,0.00,'2022-10-12 16:51:26','',''),(2434,'21','238',NULL,1,'Sale Id shift 204',3124294.80,0.00,0.00,0.00,0.00,'2022-10-12 16:51:26','',''),(2435,'21','238',NULL,3,'Sale Id shift 204',55556.00,0.00,0.00,0.00,0.00,'2022-10-12 16:51:26','',''),(2436,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5550000.00,30000.00,0.00,0.00,'2022-10-13 08:21:51','',''),(2437,'21','238',NULL,1,'Reception corrector for bridging 259',0.00,0.00,0.00,15000.00,0.00,'2022-10-13 08:25:36','',''),(2438,'21','238','1',1,'Received from bridging 259',0.00,0.00,15000.00,0.00,0.00,'2022-10-13 08:25:36','',''),(2439,'21','238',NULL,1,'Reception corrector for bridging 260',0.00,0.00,0.00,15000.00,0.00,'2022-10-13 08:26:02','',''),(2440,'21','238','3',1,'Received from bridging 260',0.00,0.00,15000.00,0.00,0.00,'2022-10-13 08:26:02','',''),(2441,'21','238','1',1,'Sale Id shift 205',0.00,0.00,0.00,5015.16,0.00,'2022-10-13 08:31:57','',''),(2442,'21','238','3',1,'Sale Id shift 205',0.00,0.00,0.00,1739.98,0.00,'2022-10-13 08:31:57','',''),(2443,'21','238','6',3,'Sale Id shift 205',0.00,0.00,0.00,13.93,0.00,'2022-10-13 08:31:57','',''),(2444,'21','238','1',1,'Sale Id shift 205',0.00,0.00,0.00,4885.90,0.00,'2022-10-13 08:31:57','',''),(2445,'21','238','2',1,'Sale Id shift 205',0.00,0.00,0.00,495.58,0.00,'2022-10-13 08:31:57','',''),(2446,'21','238','2',1,'Sale Id shift 205',0.00,0.00,0.00,6061.22,0.00,'2022-10-13 08:31:57','',''),(2447,'21','238','3',1,'Sale Id shift 205',0.00,0.00,0.00,2025.50,0.00,'2022-10-13 08:31:57','',''),(2448,'21','238',NULL,1,'Sale Id shift 205',3741317.90,0.00,0.00,0.00,0.00,'2022-10-13 08:31:57','',''),(2449,'21','238',NULL,3,'Sale Id shift 205',11979.80,0.00,0.00,0.00,0.00,'2022-10-13 08:31:57','',''),(2450,'21','238','1',1,'Sale Id shift 206',0.00,0.00,0.00,3996.29,0.00,'2022-10-13 13:07:23','',''),(2451,'21','238','3',1,'Sale Id shift 206',0.00,0.00,0.00,3588.42,0.00,'2022-10-13 13:07:23','',''),(2452,'21','238','6',3,'Sale Id shift 206',0.00,0.00,0.00,49.28,0.00,'2022-10-13 13:07:23','',''),(2453,'21','238','1',1,'Sale Id shift 206',0.00,0.00,0.00,4029.88,0.00,'2022-10-13 13:07:23','',''),(2454,'21','238','2',1,'Sale Id shift 206',0.00,0.00,0.00,3177.43,0.00,'2022-10-13 13:07:23','',''),(2455,'21','238','3',1,'Sale Id shift 206',0.00,0.00,0.00,5165.34,0.00,'2022-10-13 13:07:23','',''),(2456,'21','238',NULL,1,'Sale Id shift 206',3692111.60,0.00,0.00,0.00,0.00,'2022-10-13 13:07:23','',''),(2457,'21','238',NULL,3,'Sale Id shift 206',42380.80,0.00,0.00,0.00,0.00,'2022-10-13 13:07:23','',''),(2458,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5550000.00,30000.00,0.00,0.00,'2022-10-14 16:20:12','',''),(2459,'21','238',NULL,1,'Reception corrector for bridging 263',0.00,0.00,0.00,7550.00,0.00,'2022-10-14 16:22:04','',''),(2460,'21','238','3',1,'Received from bridging 263',0.00,0.00,7550.00,0.00,0.00,'2022-10-14 16:22:04','',''),(2461,'21','238',NULL,1,'Reception corrector for bridging 262',0.00,0.00,0.00,15000.00,0.00,'2022-10-14 16:22:36','',''),(2462,'21','238','2',1,'Received from bridging 262',0.00,0.00,15000.00,0.00,0.00,'2022-10-14 16:22:36','',''),(2463,'21','238',NULL,1,'Reception corrector for bridging 261',0.00,0.00,0.00,7450.00,0.00,'2022-10-14 16:22:51','',''),(2464,'21','238','1',1,'Received from bridging 261',0.00,0.00,7450.00,0.00,0.00,'2022-10-14 16:22:51','',''),(2465,'21','238','1',1,'Sale Id shift 207',0.00,0.00,0.00,4624.63,0.00,'2022-10-14 16:41:32','',''),(2466,'21','238','3',1,'Sale Id shift 207',0.00,0.00,0.00,3062.52,0.00,'2022-10-14 16:41:32','',''),(2467,'21','238','6',3,'Sale Id shift 207',0.00,0.00,0.00,27.48,0.00,'2022-10-14 16:41:32','',''),(2468,'21','238','1',1,'Sale Id shift 207',0.00,0.00,0.00,4723.67,0.00,'2022-10-14 16:41:32','',''),(2469,'21','238','2',1,'Sale Id shift 207',0.00,0.00,0.00,4827.04,0.00,'2022-10-14 16:41:32','',''),(2470,'21','238','3',1,'Sale Id shift 207',0.00,0.00,0.00,3039.24,0.00,'2022-10-14 16:41:32','',''),(2471,'21','238',NULL,1,'Sale Id shift 207',3751263.50,0.00,0.00,0.00,0.00,'2022-10-14 16:41:32','',''),(2472,'21','238',NULL,3,'Sale Id shift 207',23632.80,0.00,0.00,0.00,0.00,'2022-10-14 16:41:32','',''),(2473,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8325000.00,45000.00,0.00,0.00,'2022-10-14 16:58:00','',''),(2474,'21','238',NULL,1,'Reception corrector for bridging 266',0.00,0.00,0.00,15000.00,0.00,'2022-10-14 17:00:12','',''),(2475,'21','238','3',1,'Received from bridging 266',0.00,0.00,15000.00,0.00,0.00,'2022-10-14 17:00:12','',''),(2476,'21','238',NULL,1,'Reception corrector for bridging 265',0.00,0.00,0.00,15000.00,0.00,'2022-10-14 17:00:35','',''),(2477,'21','238','2',1,'Received from bridging 265',0.00,0.00,15000.00,0.00,0.00,'2022-10-14 17:00:35','',''),(2478,'21','238',NULL,1,'Reception corrector for bridging 264',0.00,0.00,0.00,15000.00,0.00,'2022-10-14 17:00:53','',''),(2479,'21','238','1',1,'Received from bridging 264',0.00,0.00,15000.00,0.00,0.00,'2022-10-14 17:00:53','',''),(2480,'21','238','1',1,'Sale Id shift 208',0.00,0.00,0.00,3355.43,0.00,'2022-10-14 17:07:56','',''),(2481,'21','238','6',3,'Sale Id shift 208',0.00,0.00,0.00,47.78,0.00,'2022-10-14 17:07:56','',''),(2482,'21','238','1',1,'Sale Id shift 208',0.00,0.00,0.00,4138.59,0.00,'2022-10-14 17:07:56','',''),(2483,'21','238','2',1,'Sale Id shift 208',0.00,0.00,0.00,2067.51,0.00,'2022-10-14 17:07:56','',''),(2484,'21','238','2',1,'Sale Id shift 208',0.00,0.00,0.00,9105.86,0.00,'2022-10-14 17:07:56','',''),(2485,'21','238',NULL,1,'Sale Id shift 208',3453467.15,0.00,0.00,0.00,0.00,'2022-10-14 17:07:56','',''),(2486,'21','238',NULL,3,'Sale Id shift 208',41090.80,0.00,0.00,0.00,0.00,'2022-10-14 17:07:56','',''),(2487,'21','238','1',1,'Sale Id shift 209',0.00,0.00,0.00,3068.11,0.00,'2022-10-14 17:40:45','',''),(2488,'21','238','3',1,'Sale Id shift 209',0.00,0.00,0.00,3190.10,0.00,'2022-10-14 17:40:45','',''),(2489,'21','238','6',3,'Sale Id shift 209',0.00,0.00,0.00,46.85,0.00,'2022-10-14 17:40:45','',''),(2490,'21','238','1',1,'Sale Id shift 209',0.00,0.00,0.00,3530.51,0.00,'2022-10-14 17:40:45','',''),(2491,'21','238','2',1,'Sale Id shift 209',0.00,0.00,0.00,1919.41,0.00,'2022-10-14 17:40:45','',''),(2492,'21','238','2',1,'Sale Id shift 209',0.00,0.00,0.00,3498.99,0.00,'2022-10-14 17:40:45','',''),(2493,'21','238','3',1,'Sale Id shift 209',0.00,0.00,0.00,2738.48,0.00,'2022-10-14 17:40:45','',''),(2494,'21','238',NULL,1,'Sale Id shift 209',3319936.00,0.00,0.00,0.00,0.00,'2022-10-14 17:40:45','',''),(2495,'21','238',NULL,3,'Sale Id shift 209',40291.00,0.00,0.00,0.00,0.00,'2022-10-14 17:40:45','',''),(2496,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,12147300.00,14850.00,0.00,0.00,'2022-10-14 18:06:15','',''),(2497,'21','238',NULL,2,'Reception corrector for bridging 267',0.00,0.00,0.00,14850.00,0.00,'2022-10-14 18:07:50','',''),(2498,'21','238','5',2,'Received from bridging 267',0.00,0.00,14850.00,0.00,0.00,'2022-10-14 18:07:50','',''),(2499,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,17996000.00,22000.00,0.00,0.00,'2022-10-14 18:11:38','',''),(2500,'21','238',NULL,2,'Reception corrector for bridging 269',0.00,0.00,0.00,22000.00,0.00,'2022-10-14 18:14:26','',''),(2501,'21','238','4',2,'Received from bridging 269',0.00,0.00,22000.00,0.00,0.00,'2022-10-14 18:14:26','',''),(2502,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2960000.00,16000.00,0.00,0.00,'2022-10-14 18:50:56','',''),(2503,'21','238',NULL,1,'Reception corrector for bridging 270',0.00,0.00,0.00,16000.00,0.00,'2022-10-14 18:52:22','',''),(2504,'21','238','1',1,'Received from bridging 270',0.00,0.00,16000.00,0.00,0.00,'2022-10-14 18:52:22','',''),(2505,'21','238','1',1,'Sale Id shift 210',0.00,0.00,0.00,2947.14,0.00,'2022-10-14 19:05:31','',''),(2506,'21','238','3',1,'Sale Id shift 210',0.00,0.00,0.00,3467.35,0.00,'2022-10-14 19:05:31','',''),(2507,'21','238','4',2,'Sale Id shift 210',0.00,0.00,0.00,8566.99,0.00,'2022-10-14 19:05:31','',''),(2508,'21','238','5',2,'Sale Id shift 210',0.00,0.00,0.00,3699.00,0.00,'2022-10-14 19:05:31','',''),(2509,'21','238','5',2,'Sale Id shift 210',0.00,0.00,0.00,620.87,0.00,'2022-10-14 19:05:31','',''),(2510,'21','238','6',3,'Sale Id shift 210',0.00,0.00,0.00,37.54,0.00,'2022-10-14 19:05:31','',''),(2511,'21','238','1',1,'Sale Id shift 210',0.00,0.00,0.00,3104.38,0.00,'2022-10-14 19:05:31','',''),(2512,'21','238','2',1,'Sale Id shift 210',0.00,0.00,0.00,3832.27,0.00,'2022-10-14 19:05:31','',''),(2513,'21','238','2',1,'Sale Id shift 210',0.00,0.00,0.00,3680.13,0.00,'2022-10-14 19:05:31','',''),(2514,'21','238','3',1,'Sale Id shift 210',0.00,0.00,0.00,99.56,0.00,'2022-10-14 19:05:31','',''),(2515,'21','238',NULL,1,'Sale Id shift 210',3169203.55,0.00,0.00,0.00,0.00,'2022-10-14 19:05:31','',''),(2516,'21','238',NULL,2,'Sale Id shift 210',10541451.48,0.00,0.00,0.00,0.00,'2022-10-14 19:05:31','',''),(2517,'21','238',NULL,3,'Sale Id shift 210',32284.40,0.00,0.00,0.00,0.00,'2022-10-14 19:05:31','',''),(2518,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7400000.00,40000.00,0.00,0.00,'2022-10-15 20:02:32','',''),(2519,'21','238',NULL,1,'Reception corrector for bridging 272',0.00,0.00,0.00,23300.00,0.00,'2022-10-15 20:05:03','',''),(2520,'21','238','2',1,'Received from bridging 272',0.00,0.00,23300.00,0.00,0.00,'2022-10-15 20:05:03','',''),(2521,'21','238','1',1,'Sale Id shift 211',0.00,0.00,0.00,4720.98,0.00,'2022-10-15 20:11:56','',''),(2522,'21','238','3',1,'Sale Id shift 211',0.00,0.00,0.00,4416.18,0.00,'2022-10-15 20:11:56','',''),(2523,'21','238','4',2,'Sale Id shift 211',0.00,0.00,0.00,5522.45,0.00,'2022-10-15 20:11:56','',''),(2524,'21','238','5',2,'Sale Id shift 211',0.00,0.00,0.00,3894.22,0.00,'2022-10-15 20:11:56','',''),(2525,'21','238','5',2,'Sale Id shift 211',0.00,0.00,0.00,2980.40,0.00,'2022-10-15 20:11:56','',''),(2526,'21','238','6',3,'Sale Id shift 211',0.00,0.00,0.00,33.12,0.00,'2022-10-15 20:11:56','',''),(2527,'21','238','1',1,'Sale Id shift 211',0.00,0.00,0.00,4440.45,0.00,'2022-10-15 20:11:56','',''),(2528,'21','238','2',1,'Sale Id shift 211',0.00,0.00,0.00,2164.44,0.00,'2022-10-15 20:11:56','',''),(2529,'21','238','2',1,'Sale Id shift 211',0.00,0.00,0.00,3884.70,0.00,'2022-10-15 20:11:56','',''),(2530,'21','238',NULL,1,'Sale Id shift 211',3630948.75,0.00,0.00,0.00,0.00,'2022-10-15 20:11:56','',''),(2531,'21','238',NULL,2,'Sale Id shift 211',10140803.26,0.00,0.00,0.00,0.00,'2022-10-15 20:11:56','',''),(2532,'21','238',NULL,3,'Sale Id shift 211',28483.20,0.00,0.00,0.00,0.00,'2022-10-15 20:11:56','',''),(2533,'21','238',NULL,1,'Reception corrector for bridging 271',0.00,0.00,0.00,16700.00,0.00,'2022-10-15 20:29:47','',''),(2534,'21','238','1',1,'Received from bridging 271',0.00,0.00,16700.00,0.00,0.00,'2022-10-15 20:29:47','',''),(2535,'21','238','1',1,'Sale Id shift 212',0.00,0.00,0.00,3858.57,0.00,'2022-10-15 20:36:30','',''),(2536,'21','238','3',1,'Sale Id shift 212',0.00,0.00,0.00,1144.76,0.00,'2022-10-15 20:36:30','',''),(2537,'21','238','4',2,'Sale Id shift 212',0.00,0.00,0.00,2321.40,0.00,'2022-10-15 20:36:30','',''),(2538,'21','238','5',2,'Sale Id shift 212',0.00,0.00,0.00,2549.18,0.00,'2022-10-15 20:36:30','',''),(2539,'21','238','5',2,'Sale Id shift 212',0.00,0.00,0.00,1003.31,0.00,'2022-10-15 20:36:30','',''),(2540,'21','238','6',3,'Sale Id shift 212',0.00,0.00,0.00,54.74,0.00,'2022-10-15 20:36:30','',''),(2541,'21','238','1',1,'Sale Id shift 212',0.00,0.00,0.00,5145.54,0.00,'2022-10-15 20:36:30','',''),(2542,'21','238',NULL,1,'Sale Id shift 212',1877540.95,0.00,0.00,0.00,0.00,'2022-10-15 20:36:30','',''),(2543,'21','238',NULL,2,'Sale Id shift 212',4804842.02,0.00,0.00,0.00,0.00,'2022-10-15 20:36:30','',''),(2544,'21','238',NULL,3,'Sale Id shift 212',47076.40,0.00,0.00,0.00,0.00,'2022-10-15 20:36:30','',''),(2545,'21','238','4',2,'Sale Id shift 213',0.00,0.00,0.00,4250.88,0.00,'2022-10-15 21:10:46','',''),(2546,'21','238','6',3,'Sale Id shift 213',0.00,0.00,0.00,24.72,0.00,'2022-10-15 21:10:46','',''),(2547,'21','238',NULL,2,'Sale Id shift 213',3477219.84,0.00,0.00,0.00,0.00,'2022-10-15 21:10:46','',''),(2548,'21','238',NULL,3,'Sale Id shift 213',21259.20,0.00,0.00,0.00,0.00,'2022-10-15 21:10:46','',''),(2549,'21','238','1',1,'Sale Id shift 214',0.00,0.00,0.00,1556.43,0.00,'2022-10-15 21:30:27','',''),(2550,'21','238','3',1,'Sale Id shift 214',0.00,0.00,0.00,7.60,0.00,'2022-10-15 21:30:27','',''),(2551,'21','238','4',2,'Sale Id shift 214',0.00,0.00,0.00,50.00,0.00,'2022-10-15 21:30:27','',''),(2552,'21','238','6',3,'Sale Id shift 214',0.00,0.00,0.00,50.48,0.00,'2022-10-15 21:30:27','',''),(2553,'21','238','1',1,'Sale Id shift 214',0.00,0.00,0.00,3666.08,0.00,'2022-10-15 21:30:27','',''),(2554,'21','238','2',1,'Sale Id shift 214',0.00,0.00,0.00,8317.55,0.00,'2022-10-15 21:30:27','',''),(2555,'21','238','2',1,'Sale Id shift 214',0.00,0.00,0.00,11051.36,0.00,'2022-10-15 21:30:27','',''),(2556,'21','238','3',1,'Sale Id shift 214',0.00,0.00,0.00,1.29,0.00,'2022-10-15 21:30:27','',''),(2557,'21','238',NULL,1,'Sale Id shift 214',4551057.35,0.00,0.00,0.00,0.00,'2022-10-15 21:30:27','',''),(2558,'21','238',NULL,2,'Sale Id shift 214',40900.00,0.00,0.00,0.00,0.00,'2022-10-15 21:30:27','',''),(2559,'21','238',NULL,3,'Sale Id shift 214',43412.80,0.00,0.00,0.00,0.00,'2022-10-15 21:30:27','',''),(2560,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8325000.00,45000.00,0.00,0.00,'2022-10-16 17:42:31','',''),(2561,'21','238',NULL,1,'Reception corrector for bridging 275',0.00,0.00,0.00,8500.00,0.00,'2022-10-16 17:44:17','',''),(2562,'21','238','3',1,'Received from bridging 275',0.00,0.00,8500.00,0.00,0.00,'2022-10-16 17:44:17','',''),(2563,'21','238',NULL,1,'Reception corrector for bridging 274',0.00,0.00,0.00,17000.00,0.00,'2022-10-16 17:44:34','',''),(2564,'21','238','2',1,'Received from bridging 274',0.00,0.00,17000.00,0.00,0.00,'2022-10-16 17:44:34','',''),(2565,'21','238',NULL,1,'Reception corrector for bridging 273',0.00,0.00,0.00,19500.00,0.00,'2022-10-16 17:44:47','',''),(2566,'21','238','1',1,'Received from bridging 273',0.00,0.00,19500.00,0.00,0.00,'2022-10-16 17:44:47','',''),(2567,'21','238','1',1,'Sale Id shift 215',0.00,0.00,0.00,6654.71,0.00,'2022-10-16 17:51:07','',''),(2568,'21','238','4',2,'Sale Id shift 215',0.00,0.00,0.00,619.02,0.00,'2022-10-16 17:51:07','',''),(2569,'21','238','6',3,'Sale Id shift 215',0.00,0.00,0.00,36.91,0.00,'2022-10-16 17:51:07','',''),(2570,'21','238','1',1,'Sale Id shift 215',0.00,0.00,0.00,7749.54,0.00,'2022-10-16 17:51:07','',''),(2571,'21','238','2',1,'Sale Id shift 215',0.00,0.00,0.00,21.64,0.00,'2022-10-16 17:51:07','',''),(2572,'21','238','2',1,'Sale Id shift 215',0.00,0.00,0.00,579.46,0.00,'2022-10-16 17:51:07','',''),(2573,'21','238',NULL,1,'Sale Id shift 215',2775989.75,0.00,0.00,0.00,0.00,'2022-10-16 17:51:07','',''),(2574,'21','238',NULL,2,'Sale Id shift 215',506358.36,0.00,0.00,0.00,0.00,'2022-10-16 17:51:07','',''),(2575,'21','238',NULL,3,'Sale Id shift 215',31742.60,0.00,0.00,0.00,0.00,'2022-10-16 17:51:07','',''),(2576,'21','238','1',1,'Sale Id shift 216',0.00,0.00,0.00,5334.73,0.00,'2022-10-16 18:06:45','',''),(2577,'21','238','3',1,'Sale Id shift 216',0.00,0.00,0.00,6724.11,0.00,'2022-10-16 18:06:45','',''),(2578,'21','238','4',2,'Sale Id shift 216',0.00,0.00,0.00,30.00,0.00,'2022-10-16 18:06:45','',''),(2579,'21','238','6',3,'Sale Id shift 216',0.00,0.00,0.00,28.60,0.00,'2022-10-16 18:06:45','',''),(2580,'21','238','1',1,'Sale Id shift 216',0.00,0.00,0.00,8867.53,0.00,'2022-10-16 18:06:45','',''),(2581,'21','238','2',1,'Sale Id shift 216',0.00,0.00,0.00,3873.95,0.00,'2022-10-16 18:06:45','',''),(2582,'21','238','2',1,'Sale Id shift 216',0.00,0.00,0.00,7879.95,0.00,'2022-10-16 18:06:45','',''),(2583,'21','238','3',1,'Sale Id shift 216',0.00,0.00,0.00,3130.88,0.00,'2022-10-16 18:06:45','',''),(2584,'21','238',NULL,1,'Sale Id shift 216',6625062.75,0.00,0.00,0.00,0.00,'2022-10-16 18:06:45','',''),(2585,'21','238',NULL,2,'Sale Id shift 216',24540.00,0.00,0.00,0.00,0.00,'2022-10-16 18:06:45','',''),(2586,'21','238',NULL,3,'Sale Id shift 216',24596.00,0.00,0.00,0.00,0.00,'2022-10-16 18:06:45','',''),(2587,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,6243750.00,33750.00,0.00,0.00,'2022-10-16 19:08:09','',''),(2588,'21','238',NULL,1,'Reception corrector for bridging 277',0.00,0.00,0.00,16750.00,0.00,'2022-10-16 19:09:53','',''),(2589,'21','238','2',1,'Received from bridging 277',0.00,0.00,16750.00,0.00,0.00,'2022-10-16 19:09:53','',''),(2590,'21','238',NULL,1,'Reception corrector for bridging 276',0.00,0.00,0.00,17000.00,0.00,'2022-10-16 19:10:11','',''),(2591,'21','238','1',1,'Received from bridging 276',0.00,0.00,17000.00,0.00,0.00,'2022-10-16 19:10:11','',''),(2592,'21','238','1',1,'Sale Id shift 217',0.00,0.00,0.00,6342.55,0.00,'2022-10-16 19:20:14','',''),(2593,'21','238','3',1,'Sale Id shift 217',0.00,0.00,0.00,2801.75,0.00,'2022-10-16 19:20:14','',''),(2594,'21','238','4',2,'Sale Id shift 217',0.00,0.00,0.00,39.77,0.00,'2022-10-16 19:20:14','',''),(2595,'21','238','6',3,'Sale Id shift 217',0.00,0.00,0.00,37.19,0.00,'2022-10-16 19:20:14','',''),(2596,'21','238','1',1,'Sale Id shift 217',0.00,0.00,0.00,4890.69,0.00,'2022-10-16 19:20:14','',''),(2597,'21','238','2',1,'Sale Id shift 217',0.00,0.00,0.00,5527.07,0.00,'2022-10-16 19:20:14','',''),(2598,'21','238','2',1,'Sale Id shift 217',0.00,0.00,0.00,5496.50,0.00,'2022-10-16 19:20:14','',''),(2599,'21','238','3',1,'Sale Id shift 217',0.00,0.00,0.00,2081.98,0.00,'2022-10-16 19:20:14','',''),(2600,'21','238',NULL,1,'Sale Id shift 217',5020999.90,0.00,0.00,0.00,0.00,'2022-10-16 19:20:14','',''),(2601,'21','238',NULL,2,'Sale Id shift 217',32531.86,0.00,0.00,0.00,0.00,'2022-10-16 19:20:14','',''),(2602,'21','238',NULL,3,'Sale Id shift 217',31983.40,0.00,0.00,0.00,0.00,'2022-10-16 19:20:14','',''),(2603,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2728750.00,14750.00,0.00,0.00,'2022-10-16 19:39:31','',''),(2604,'21','238',NULL,1,'Reception corrector for bridging 278',0.00,0.00,0.00,14750.00,0.00,'2022-10-16 19:41:05','',''),(2605,'21','238','3',1,'Received from bridging 278',0.00,0.00,14750.00,0.00,0.00,'2022-10-16 19:41:05','',''),(2606,'21','238','1',1,'Sale Id shift 218',0.00,0.00,0.00,3093.93,0.00,'2022-10-16 19:49:27','',''),(2607,'21','238','3',1,'Sale Id shift 218',0.00,0.00,0.00,4841.70,0.00,'2022-10-16 19:49:27','',''),(2608,'21','238','4',2,'Sale Id shift 218',0.00,0.00,0.00,406.98,0.00,'2022-10-16 19:49:27','',''),(2609,'21','238','6',3,'Sale Id shift 218',0.00,0.00,0.00,30.56,0.00,'2022-10-16 19:49:27','',''),(2610,'21','238','1',1,'Sale Id shift 218',0.00,0.00,0.00,3442.47,0.00,'2022-10-16 19:49:27','',''),(2611,'21','238','2',1,'Sale Id shift 218',0.00,0.00,0.00,4564.21,0.00,'2022-10-16 19:49:27','',''),(2612,'21','238','2',1,'Sale Id shift 218',0.00,0.00,0.00,4144.04,0.00,'2022-10-16 19:49:27','',''),(2613,'21','238','3',1,'Sale Id shift 218',0.00,0.00,0.00,5458.04,0.00,'2022-10-16 19:49:27','',''),(2614,'21','238',NULL,1,'Sale Id shift 218',4725712.15,0.00,0.00,0.00,0.00,'2022-10-16 19:49:27','',''),(2615,'21','238',NULL,2,'Sale Id shift 218',332909.64,0.00,0.00,0.00,0.00,'2022-10-16 19:49:27','',''),(2616,'21','238',NULL,3,'Sale Id shift 218',26281.60,0.00,0.00,0.00,0.00,'2022-10-16 19:49:27','',''),(2617,'21','238','3',1,'Sale Id shift 219',0.00,0.00,0.00,2351.85,0.00,'2022-10-17 21:20:06','',''),(2618,'21','238','6',3,'Sale Id shift 219',0.00,0.00,0.00,29.91,0.00,'2022-10-17 21:20:06','',''),(2619,'21','238','3',1,'Sale Id shift 219',0.00,0.00,0.00,2157.46,0.00,'2022-10-17 21:20:06','',''),(2620,'21','238',NULL,1,'Sale Id shift 219',834222.35,0.00,0.00,0.00,0.00,'2022-10-17 21:20:06','',''),(2621,'21','238',NULL,3,'Sale Id shift 219',25722.60,0.00,0.00,0.00,0.00,'2022-10-17 21:20:06','',''),(2622,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5550000.00,30000.00,0.00,0.00,'2022-10-17 21:42:41','',''),(2623,'21','238',NULL,1,'Reception corrector for bridging 280',0.00,0.00,0.00,15000.00,0.00,'2022-10-17 21:43:50','',''),(2624,'21','238','2',1,'Received from bridging 280',0.00,0.00,15000.00,0.00,0.00,'2022-10-17 21:43:50','',''),(2625,'21','238',NULL,1,'Reception corrector for bridging 279',0.00,0.00,0.00,15000.00,0.00,'2022-10-17 21:44:10','',''),(2626,'21','238','1',1,'Received from bridging 279',0.00,0.00,15000.00,0.00,0.00,'2022-10-17 21:44:10','',''),(2627,'21','238','1',1,'Sale Id shift 220',0.00,0.00,0.00,3441.37,0.00,'2022-10-17 21:49:56','',''),(2628,'21','238','6',3,'Sale Id shift 220',0.00,0.00,0.00,50.50,0.00,'2022-10-17 21:49:56','',''),(2629,'21','238','1',1,'Sale Id shift 220',0.00,0.00,0.00,3490.64,0.00,'2022-10-17 21:49:56','',''),(2630,'21','238','2',1,'Sale Id shift 220',0.00,0.00,0.00,3271.33,0.00,'2022-10-17 21:49:56','',''),(2631,'21','238','2',1,'Sale Id shift 220',0.00,0.00,0.00,3985.12,0.00,'2022-10-17 21:49:56','',''),(2632,'21','238',NULL,3,'Sale Id shift 220',43430.00,0.00,0.00,0.00,0.00,'2022-10-17 21:49:56','',''),(2633,'21','238',NULL,1,'Sale Id shift 220',2624865.10,0.00,0.00,0.00,0.00,'2022-10-17 21:49:56','',''),(2634,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2775000.00,15000.00,0.00,0.00,'2022-10-17 22:06:17','',''),(2635,'21','238',NULL,1,'Reception corrector for bridging 283',0.00,0.00,0.00,15000.00,0.00,'2022-10-17 22:08:17','',''),(2636,'21','238','3',1,'Received from bridging 283',0.00,0.00,15000.00,0.00,0.00,'2022-10-17 22:08:17','',''),(2637,'21','238','1',1,'Sale Id shift 221',0.00,0.00,0.00,3732.18,0.00,'2022-10-17 22:14:23','',''),(2638,'21','238','3',1,'Sale Id shift 221',0.00,0.00,0.00,5345.34,0.00,'2022-10-17 22:14:23','',''),(2639,'21','238','6',3,'Sale Id shift 221',0.00,0.00,0.00,45.12,0.00,'2022-10-17 22:14:23','',''),(2640,'21','238','1',1,'Sale Id shift 221',0.00,0.00,0.00,3902.35,0.00,'2022-10-17 22:14:23','',''),(2641,'21','238','2',1,'Sale Id shift 221',0.00,0.00,0.00,3407.86,0.00,'2022-10-17 22:14:23','',''),(2642,'21','238','2',1,'Sale Id shift 221',0.00,0.00,0.00,4590.22,0.00,'2022-10-17 22:14:23','',''),(2643,'21','238','3',1,'Sale Id shift 221',0.00,0.00,0.00,6797.63,0.00,'2022-10-17 22:14:23','',''),(2644,'21','238',NULL,1,'Sale Id shift 221',5138482.30,0.00,0.00,0.00,0.00,'2022-10-17 22:14:23','',''),(2645,'21','238',NULL,3,'Sale Id shift 221',38803.20,0.00,0.00,0.00,0.00,'2022-10-17 22:14:23','',''),(2646,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,18216000.00,22000.00,0.00,0.00,'2022-10-18 22:31:49','',''),(2647,'21','238',NULL,2,'Reception corrector for bridging 284',0.00,0.00,0.00,22000.00,0.00,'2022-10-18 22:32:57','',''),(2648,'21','238','4',2,'Received from bridging 284',0.00,0.00,22000.00,0.00,0.00,'2022-10-18 22:32:57','',''),(2649,'21','238','3',1,'Sale Id shift 222',0.00,0.00,0.00,1530.75,0.00,'2022-10-18 22:37:58','',''),(2650,'21','238','4',2,'Sale Id shift 222',0.00,0.00,0.00,4822.98,0.00,'2022-10-18 22:37:58','',''),(2651,'21','238','6',3,'Sale Id shift 222',0.00,0.00,0.00,41.02,0.00,'2022-10-18 22:37:58','',''),(2652,'21','238','3',1,'Sale Id shift 222',0.00,0.00,0.00,1404.66,0.00,'2022-10-18 22:37:58','',''),(2653,'21','238',NULL,2,'Sale Id shift 222',3993427.44,0.00,0.00,0.00,0.00,'2022-10-18 22:37:58','',''),(2654,'21','238',NULL,3,'Sale Id shift 222',35277.20,0.00,0.00,0.00,0.00,'2022-10-18 22:37:58','',''),(2655,'21','238',NULL,1,'Sale Id shift 222',543050.85,0.00,0.00,0.00,0.00,'2022-10-18 22:37:58','',''),(2656,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2775000.00,15000.00,0.00,0.00,'2022-10-20 18:58:38','',''),(2657,'21','238',NULL,1,'Reception corrector for bridging 285',0.00,0.00,0.00,15000.00,0.00,'2022-10-20 18:59:45','',''),(2658,'21','238','2',1,'Received from bridging 285',0.00,0.00,15000.00,0.00,0.00,'2022-10-20 18:59:45','',''),(2659,'21','238','4',2,'Sale Id shift 223',0.00,0.00,0.00,7093.66,0.00,'2022-10-20 19:07:13','',''),(2660,'21','238','6',3,'Sale Id shift 223',0.00,0.00,0.00,67.03,0.00,'2022-10-20 19:07:13','',''),(2661,'21','238','2',1,'Sale Id shift 223',0.00,0.00,0.00,3676.41,0.00,'2022-10-20 19:07:13','',''),(2662,'21','238','2',1,'Sale Id shift 223',0.00,0.00,0.00,5188.84,0.00,'2022-10-20 19:07:13','',''),(2663,'21','238',NULL,1,'Sale Id shift 223',1640071.25,0.00,0.00,0.00,0.00,'2022-10-20 19:07:13','',''),(2664,'21','238',NULL,2,'Sale Id shift 223',5873550.48,0.00,0.00,0.00,0.00,'2022-10-20 19:07:13','',''),(2665,'21','238',NULL,3,'Sale Id shift 223',57645.80,0.00,0.00,0.00,0.00,'2022-10-20 19:07:13','',''),(2666,'21','238','4',2,'Sale Id shift 224',0.00,0.00,0.00,7499.61,0.00,'2022-10-20 19:53:45','',''),(2667,'21','238','6',3,'Sale Id shift 224',0.00,0.00,0.00,55.88,0.00,'2022-10-20 19:53:45','',''),(2668,'21','238','2',1,'Sale Id shift 224',0.00,0.00,0.00,2385.73,0.00,'2022-10-20 19:53:45','',''),(2669,'21','238','2',1,'Sale Id shift 224',0.00,0.00,0.00,3586.60,0.00,'2022-10-20 19:53:45','',''),(2670,'21','238',NULL,1,'Sale Id shift 224',1104881.05,0.00,0.00,0.00,0.00,'2022-10-20 19:53:45','',''),(2671,'21','238',NULL,2,'Sale Id shift 224',6209677.08,0.00,0.00,0.00,0.00,'2022-10-20 19:53:45','',''),(2672,'21','238',NULL,3,'Sale Id shift 224',48056.80,0.00,0.00,0.00,0.00,'2022-10-20 19:53:45','',''),(2673,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2830500.00,15300.00,0.00,0.00,'2022-10-24 16:29:24','',''),(2674,'21','238',NULL,1,'Reception corrector for bridging 286',0.00,0.00,0.00,15300.00,0.00,'2022-10-24 16:31:21','',''),(2675,'21','238','2',1,'Received from bridging 286',0.00,0.00,15300.00,0.00,0.00,'2022-10-24 16:31:21','',''),(2676,'21','238','4',2,'Sale Id shift 225',0.00,0.00,0.00,2407.98,0.00,'2022-10-24 16:37:24','',''),(2677,'21','238','6',3,'Sale Id shift 225',0.00,0.00,0.00,30.17,0.00,'2022-10-24 16:37:24','',''),(2678,'21','238','2',1,'Sale Id shift 225',0.00,0.00,0.00,5586.57,0.00,'2022-10-24 16:37:24','',''),(2679,'21','238','2',1,'Sale Id shift 225',0.00,0.00,0.00,6176.78,0.00,'2022-10-24 16:37:24','',''),(2680,'21','238',NULL,1,'Sale Id shift 225',2176219.75,0.00,0.00,0.00,0.00,'2022-10-24 16:37:24','',''),(2681,'21','238',NULL,2,'Sale Id shift 225',1993807.44,0.00,0.00,0.00,0.00,'2022-10-24 16:37:24','',''),(2682,'21','238',NULL,3,'Sale Id shift 225',25946.20,0.00,0.00,0.00,0.00,'2022-10-24 16:37:24','',''),(2683,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,17388000.00,21000.00,0.00,0.00,'2022-10-24 16:49:30','',''),(2684,'21','238',NULL,2,'Reception corrector for bridging 287',0.00,0.00,0.00,21000.00,0.00,'2022-10-24 16:53:05','',''),(2685,'21','238','4',2,'Received from bridging 287',0.00,0.00,21000.00,0.00,0.00,'2022-10-24 16:53:05','',''),(2686,'21','238','4',2,'Sale Id shift 226',0.00,0.00,0.00,1927.58,0.00,'2022-10-24 16:57:28','',''),(2687,'21','238','6',3,'Sale Id shift 226',0.00,0.00,0.00,36.87,0.00,'2022-10-24 16:57:28','',''),(2688,'21','238','2',1,'Sale Id shift 226',0.00,0.00,0.00,315.67,0.00,'2022-10-24 16:57:28','',''),(2689,'21','238','2',1,'Sale Id shift 226',0.00,0.00,0.00,3249.31,0.00,'2022-10-24 16:57:28','',''),(2690,'21','238',NULL,1,'Sale Id shift 226',659521.30,0.00,0.00,0.00,0.00,'2022-10-24 16:57:28','',''),(2691,'21','238',NULL,2,'Sale Id shift 226',1596036.24,0.00,0.00,0.00,0.00,'2022-10-24 16:57:28','',''),(2692,'21','238',NULL,3,'Sale Id shift 226',31708.20,0.00,0.00,0.00,0.00,'2022-10-24 16:57:28','',''),(2693,'21','238','4',2,'Sale Id shift 227',0.00,0.00,0.00,7580.95,0.00,'2022-10-24 17:26:36','',''),(2694,'21','238','6',3,'Sale Id shift 227',0.00,0.00,0.00,15.13,0.00,'2022-10-24 17:26:36','',''),(2695,'21','238',NULL,2,'Sale Id shift 227',6277026.60,0.00,0.00,0.00,0.00,'2022-10-24 17:26:36','',''),(2696,'21','238',NULL,3,'Sale Id shift 227',13011.80,0.00,0.00,0.00,0.00,'2022-10-24 17:26:36','',''),(2697,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2660000.00,14000.00,0.00,0.00,'2022-10-24 17:38:40','',''),(2698,'21','238',NULL,1,'Reception corrector for bridging 288',0.00,0.00,0.00,14000.00,0.00,'2022-10-24 17:40:13','',''),(2699,'21','238','3',1,'Received from bridging 288',0.00,0.00,14000.00,0.00,0.00,'2022-10-24 17:40:13','',''),(2700,'21','238','3',1,'Sale Id shift 228',0.00,0.00,0.00,7368.86,0.00,'2022-10-24 17:46:59','',''),(2701,'21','238','4',2,'Sale Id shift 228',0.00,0.00,0.00,4917.83,0.00,'2022-10-24 17:46:59','',''),(2702,'21','238','6',3,'Sale Id shift 228',0.00,0.00,0.00,32.28,0.00,'2022-10-24 17:46:59','',''),(2703,'21','238','3',1,'Sale Id shift 228',0.00,0.00,0.00,6615.99,0.00,'2022-10-24 17:46:59','',''),(2704,'21','238',NULL,1,'Sale Id shift 228',2657121.50,0.00,0.00,0.00,0.00,'2022-10-24 17:46:59','',''),(2705,'21','238',NULL,2,'Sale Id shift 228',4071963.24,0.00,0.00,0.00,0.00,'2022-10-24 17:46:59','',''),(2706,'21','238',NULL,3,'Sale Id shift 228',27760.80,0.00,0.00,0.00,0.00,'2022-10-24 17:46:59','',''),(2707,'21','238','4',2,'Sale Id shift 229',0.00,0.00,0.00,5695.48,0.00,'2022-10-27 09:28:01','',''),(2708,'21','238','6',3,'Sale Id shift 229',0.00,0.00,0.00,23.01,0.00,'2022-10-27 09:28:01','',''),(2709,'21','238',NULL,2,'Sale Id shift 229',4715857.44,0.00,0.00,0.00,0.00,'2022-10-27 09:28:01','',''),(2710,'21','238',NULL,3,'Sale Id shift 229',19788.60,0.00,0.00,0.00,0.00,'2022-10-27 09:28:01','',''),(2711,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5700000.00,30000.00,0.00,0.00,'2022-10-27 09:45:07','',''),(2712,'21','238',NULL,1,'Reception corrector for bridging 290',0.00,0.00,0.00,15000.00,0.00,'2022-10-27 09:46:30','',''),(2713,'21','238','3',1,'Received from bridging 290',0.00,0.00,15000.00,0.00,0.00,'2022-10-27 09:46:30','',''),(2714,'21','238',NULL,1,'Reception corrector for bridging 289',0.00,0.00,0.00,15000.00,0.00,'2022-10-27 09:46:55','',''),(2715,'21','238','2',1,'Received from bridging 289',0.00,0.00,15000.00,0.00,0.00,'2022-10-27 09:46:55','',''),(2716,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,12461400.00,15050.00,0.00,0.00,'2022-10-27 09:50:04','',''),(2717,'21','238',NULL,2,'Reception corrector for bridging 291',0.00,0.00,0.00,15050.00,0.00,'2022-10-27 09:51:59','',''),(2718,'21','238','4',2,'Received from bridging 291',0.00,0.00,15050.00,0.00,0.00,'2022-10-27 09:51:59','',''),(2719,'21','238','3',1,'Sale Id shift 230',0.00,0.00,0.00,3133.42,0.00,'2022-10-27 09:58:38','',''),(2720,'21','238','4',2,'Sale Id shift 230',0.00,0.00,0.00,2400.44,0.00,'2022-10-27 09:58:38','',''),(2721,'21','238','6',3,'Sale Id shift 230',0.00,0.00,0.00,35.38,0.00,'2022-10-27 09:58:38','',''),(2722,'21','238','2',1,'Sale Id shift 230',0.00,0.00,0.00,5504.40,0.00,'2022-10-27 09:58:38','',''),(2723,'21','238','2',1,'Sale Id shift 230',0.00,0.00,0.00,2808.81,0.00,'2022-10-27 09:58:38','',''),(2724,'21','238','3',1,'Sale Id shift 230',0.00,0.00,0.00,4951.37,0.00,'2022-10-27 09:58:38','',''),(2725,'21','238',NULL,1,'Sale Id shift 230',3115620.00,0.00,0.00,0.00,0.00,'2022-10-27 09:58:38','',''),(2726,'21','238',NULL,2,'Sale Id shift 230',1987564.32,0.00,0.00,0.00,0.00,'2022-10-27 09:58:38','',''),(2727,'21','238',NULL,3,'Sale Id shift 230',30426.80,0.00,0.00,0.00,0.00,'2022-10-27 09:58:38','',''),(2728,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2850000.00,15000.00,0.00,0.00,'2022-10-31 15:49:29','',''),(2729,'21','238',NULL,1,'Reception corrector for bridging 292',0.00,0.00,0.00,15000.00,0.00,'2022-10-31 15:51:29','',''),(2730,'21','238','3',1,'Received from bridging 292',0.00,0.00,15000.00,0.00,0.00,'2022-10-31 15:51:29','',''),(2731,'21','238','3',1,'Sale Id shift 231',0.00,0.00,0.00,2449.51,0.00,'2022-10-31 17:12:21','',''),(2732,'21','238','4',2,'Sale Id shift 231',0.00,0.00,0.00,11113.69,0.00,'2022-10-31 17:12:21','',''),(2733,'21','238','6',3,'Sale Id shift 231',0.00,0.00,0.00,29.13,0.00,'2022-10-31 17:12:21','',''),(2734,'21','238','2',1,'Sale Id shift 231',0.00,0.00,0.00,908.42,0.00,'2022-10-31 17:12:21','',''),(2735,'21','238','2',1,'Sale Id shift 231',0.00,0.00,0.00,5874.42,0.00,'2022-10-31 17:12:21','',''),(2736,'21','238','3',1,'Sale Id shift 231',0.00,0.00,0.00,4370.11,0.00,'2022-10-31 17:12:21','',''),(2737,'21','238',NULL,1,'Sale Id shift 231',2584467.40,0.00,0.00,0.00,0.00,'2022-10-31 17:12:21','',''),(2738,'21','238',NULL,2,'Sale Id shift 231',9202135.32,0.00,0.00,0.00,0.00,'2022-10-31 17:12:21','',''),(2739,'21','238',NULL,3,'Sale Id shift 231',25051.80,0.00,0.00,0.00,0.00,'2022-10-31 17:12:21','',''),(2740,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2850000.00,15000.00,0.00,0.00,'2022-10-31 17:18:49','',''),(2741,'21','238',NULL,1,'Reception corrector for bridging 293',0.00,0.00,0.00,15000.00,0.00,'2022-10-31 17:19:45','',''),(2742,'21','238','2',1,'Received from bridging 293',0.00,0.00,15000.00,0.00,0.00,'2022-10-31 17:19:45','',''),(2743,'21','238','3',1,'Sale Id shift 232',0.00,0.00,0.00,7504.00,0.00,'2022-10-31 17:37:31','',''),(2744,'21','238','4',2,'Sale Id shift 232',0.00,0.00,0.00,2397.08,0.00,'2022-10-31 17:37:31','',''),(2745,'21','238','6',3,'Sale Id shift 232',0.00,0.00,0.00,57.17,0.00,'2022-10-31 17:37:31','',''),(2746,'21','238','3',1,'Sale Id shift 232',0.00,0.00,0.00,7217.58,0.00,'2022-10-31 17:37:31','',''),(2747,'21','238',NULL,2,'Sale Id shift 232',1984782.24,0.00,0.00,0.00,0.00,'2022-10-31 17:37:31','',''),(2748,'21','238',NULL,3,'Sale Id shift 232',49166.20,0.00,0.00,0.00,0.00,'2022-10-31 17:37:31','',''),(2749,'21','238',NULL,1,'Sale Id shift 232',2797100.20,0.00,0.00,0.00,0.00,'2022-10-31 17:37:31','',''),(2750,'21','238','4',2,'Sale Id shift 233',0.00,0.00,0.00,19.97,0.00,'2022-11-01 12:19:31','',''),(2751,'21','238','6',3,'Sale Id shift 233',0.00,0.00,0.00,17.70,0.00,'2022-11-01 12:19:31','',''),(2752,'21','238','2',1,'Sale Id shift 233',0.00,0.00,0.00,6690.40,0.00,'2022-11-01 12:19:31','',''),(2753,'21','238','2',1,'Sale Id shift 233',0.00,0.00,0.00,8112.47,0.00,'2022-11-01 12:19:31','',''),(2754,'21','238',NULL,1,'Sale Id shift 233',2812545.30,0.00,0.00,0.00,0.00,'2022-11-01 12:19:31','',''),(2755,'21','238',NULL,2,'Sale Id shift 233',16535.16,0.00,0.00,0.00,0.00,'2022-11-01 12:19:31','',''),(2756,'21','238',NULL,3,'Sale Id shift 233',15222.00,0.00,0.00,0.00,0.00,'2022-11-01 12:19:31','',''),(2757,'21','238','4',2,'Sale Id shift 234',0.00,0.00,0.00,10.03,0.00,'2022-11-01 12:33:09','',''),(2758,'21','238','6',3,'Sale Id shift 234',0.00,0.00,0.00,46.04,0.00,'2022-11-01 12:33:09','',''),(2759,'21','238',NULL,2,'Sale Id shift 234',8304.84,0.00,0.00,0.00,0.00,'2022-11-01 12:33:09','',''),(2760,'21','238',NULL,3,'Sale Id shift 234',39594.40,0.00,0.00,0.00,0.00,'2022-11-01 12:33:09','',''),(2761,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2831000.00,14900.00,0.00,0.00,'2022-11-01 12:43:01','',''),(2762,'21','238',NULL,1,'Reception corrector for bridging 294',0.00,0.00,0.00,14900.00,0.00,'2022-11-01 12:45:55','',''),(2763,'21','238','2',1,'Received from bridging 294',0.00,0.00,14900.00,0.00,0.00,'2022-11-01 12:45:55','',''),(2764,'21','238','4',2,'Sale Id shift 235',0.00,0.00,0.00,72.82,0.00,'2022-11-02 12:51:39','',''),(2765,'21','238','6',3,'Sale Id shift 235',0.00,0.00,0.00,37.12,0.00,'2022-11-02 12:51:39','',''),(2766,'21','238','2',1,'Sale Id shift 235',0.00,0.00,0.00,4556.51,0.00,'2022-11-02 12:51:39','',''),(2767,'21','238','2',1,'Sale Id shift 235',0.00,0.00,0.00,6131.63,0.00,'2022-11-02 12:51:39','',''),(2768,'21','238',NULL,1,'Sale Id shift 235',2030746.60,0.00,0.00,0.00,0.00,'2022-11-02 12:51:39','',''),(2769,'21','238',NULL,2,'Sale Id shift 235',60294.96,0.00,0.00,0.00,0.00,'2022-11-02 12:51:39','',''),(2770,'21','238',NULL,3,'Sale Id shift 235',31923.20,0.00,0.00,0.00,0.00,'2022-11-02 12:51:39','',''),(2771,'21','238',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,12420000.00,15000.00,0.00,0.00,'2022-11-02 13:05:43','',''),(2772,'21','238',NULL,2,'Reception corrector for bridging 295',0.00,0.00,0.00,15000.00,0.00,'2022-11-02 13:07:28','',''),(2773,'21','238','4',2,'Received from bridging 295',0.00,0.00,15000.00,0.00,0.00,'2022-11-02 13:07:28','',''),(2774,'21','238','4',2,'Sale Id shift 236',0.00,0.00,0.00,2901.21,0.00,'2022-11-02 13:24:44','',''),(2775,'21','238','6',3,'Sale Id shift 236',0.00,0.00,0.00,46.49,0.00,'2022-11-02 13:24:44','',''),(2776,'21','238','2',1,'Sale Id shift 236',0.00,0.00,0.00,410.67,0.00,'2022-11-02 13:24:44','',''),(2777,'21','238','2',1,'Sale Id shift 236',0.00,0.00,0.00,3882.69,0.00,'2022-11-02 13:24:44','',''),(2778,'21','238',NULL,1,'Sale Id shift 236',815738.40,0.00,0.00,0.00,0.00,'2022-11-02 13:24:44','',''),(2779,'21','238',NULL,2,'Sale Id shift 236',2402201.88,0.00,0.00,0.00,0.00,'2022-11-02 13:24:44','',''),(2780,'21','238',NULL,3,'Sale Id shift 236',39981.40,0.00,0.00,0.00,0.00,'2022-11-02 13:24:44','',''),(2781,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2850000.00,15000.00,0.00,0.00,'2022-11-02 14:29:18','',''),(2782,'21','238',NULL,1,'Reception corrector for bridging 296',0.00,0.00,0.00,15000.00,0.00,'2022-11-02 14:30:47','',''),(2783,'21','238','2',1,'Received from bridging 296',0.00,0.00,15000.00,0.00,0.00,'2022-11-02 14:30:47','',''),(2784,'21','238','4',2,'Sale Id shift 237',0.00,0.00,0.00,5607.89,0.00,'2022-11-02 14:54:23','',''),(2785,'21','238','6',3,'Sale Id shift 237',0.00,0.00,0.00,37.94,0.00,'2022-11-02 14:54:23','',''),(2786,'21','238','2',1,'Sale Id shift 237',0.00,0.00,0.00,4397.06,0.00,'2022-11-02 14:54:23','',''),(2787,'21','238','2',1,'Sale Id shift 237',0.00,0.00,0.00,6755.87,0.00,'2022-11-02 14:54:23','',''),(2788,'21','238',NULL,1,'Sale Id shift 237',2119056.70,0.00,0.00,0.00,0.00,'2022-11-02 14:54:23','',''),(2789,'21','238',NULL,2,'Sale Id shift 237',4643332.92,0.00,0.00,0.00,0.00,'2022-11-02 14:54:23','',''),(2790,'21','238',NULL,3,'Sale Id shift 237',32628.40,0.00,0.00,0.00,0.00,'2022-11-02 14:54:23','',''),(2791,'21','238','4',2,'Sale Id shift 238',0.00,0.00,0.00,6706.82,0.00,'2022-11-03 13:44:41','',''),(2792,'21','238','6',3,'Sale Id shift 238',0.00,0.00,0.00,25.09,0.00,'2022-11-03 13:44:41','',''),(2793,'21','238','2',1,'Sale Id shift 238',0.00,0.00,0.00,1212.97,0.00,'2022-11-03 13:44:41','',''),(2794,'21','238','2',1,'Sale Id shift 238',0.00,0.00,0.00,2570.27,0.00,'2022-11-03 13:44:41','',''),(2795,'21','238',NULL,1,'Sale Id shift 238',718815.60,0.00,0.00,0.00,0.00,'2022-11-03 13:44:41','',''),(2796,'21','238',NULL,2,'Sale Id shift 238',5553246.96,0.00,0.00,0.00,0.00,'2022-11-03 13:44:41','',''),(2797,'21','238',NULL,3,'Sale Id shift 238',21577.40,0.00,0.00,0.00,0.00,'2022-11-03 13:44:41','',''),(2798,'21','238',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,2660000.00,14000.00,0.00,0.00,'2022-11-04 14:54:31','',''),(2799,'21','238',NULL,1,'Reception corrector for bridging 297',0.00,0.00,0.00,14000.00,0.00,'2022-11-04 14:56:48','',''),(2800,'21','238','2',1,'Received from bridging 297',0.00,0.00,14000.00,0.00,0.00,'2022-11-04 14:56:48','',''),(2801,'21','238','6',3,'Sale Id shift 239',0.00,0.00,0.00,35.47,0.00,'2022-11-04 15:13:43','',''),(2802,'21','238','2',1,'Sale Id shift 239',0.00,0.00,0.00,5509.02,0.00,'2022-11-04 15:13:43','',''),(2803,'21','238','2',1,'Sale Id shift 239',0.00,0.00,0.00,8412.17,0.00,'2022-11-04 15:13:43','',''),(2804,'21','238',NULL,1,'Sale Id shift 239',2645026.10,0.00,0.00,0.00,0.00,'2022-11-04 15:13:43','',''),(2805,'21','238',NULL,3,'Sale Id shift 239',30504.20,0.00,0.00,0.00,0.00,'2022-11-04 15:13:43','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=603 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (1,'21','238',2,'Sale Id shift 1',0.00,4588449.58,698.00,4588449.58,0.00,'2022-03-30 14:07:25'),(2,'21','238',3,'Sale Id shift 1',0.00,91690.50,550.00,91690.50,0.00,'2022-03-30 14:07:25'),(3,'21','238',1,'Sale Id shift 1',0.00,24898.50,165.00,24898.50,0.00,'2022-03-30 14:07:25'),(4,'21','238',1,'Sale Id shift 3',0.00,4309724.10,165.00,4309724.10,0.00,'2022-03-31 13:55:47'),(5,'21','238',2,'Sale Id shift 3',0.00,6938120.00,698.00,6938120.00,0.00,'2022-03-31 13:55:47'),(6,'21','238',3,'Sale Id shift 3',0.00,138407.50,550.00,138407.50,0.00,'2022-03-31 13:55:47'),(7,'21','238',1,'Sale Id shift 4',0.00,2222370.15,165.00,2222370.15,0.00,'2022-04-01 12:40:17'),(8,'21','238',2,'Sale Id shift 4',0.00,7784061.10,698.00,7784061.10,0.00,'2022-04-01 12:40:17'),(9,'21','238',3,'Sale Id shift 4',0.00,244255.00,550.00,244255.00,0.00,'2022-04-01 12:40:17'),(10,'21','238',1,'Sale Id shift 5',0.00,55657.80,165.00,55657.80,0.00,'2022-04-02 11:35:40'),(11,'21','238',2,'Sale Id shift 5',0.00,3282673.06,698.00,3282673.06,0.00,'2022-04-02 11:35:40'),(12,'21','238',3,'Sale Id shift 5',0.00,285538.00,550.00,285538.00,0.00,'2022-04-02 11:35:40'),(13,'21','238',1,'Sale Id shift 6',0.00,2258460.60,165.00,2258460.60,0.00,'2022-04-03 11:11:44'),(14,'21','238',2,'Sale Id shift 6',0.00,3662678.22,698.00,3662678.22,0.00,'2022-04-03 11:11:44'),(15,'21','238',3,'Sale Id shift 6',0.00,208587.50,550.00,208587.50,0.00,'2022-04-03 11:11:44'),(16,'21','238',1,'Sale Id shift 7',0.00,2574579.15,165.00,2574579.15,0.00,'2022-04-04 10:31:11'),(17,'21','238',2,'Sale Id shift 7',0.00,4351953.22,698.00,4351953.22,0.00,'2022-04-04 10:31:11'),(18,'21','238',3,'Sale Id shift 7',0.00,139865.00,550.00,139865.00,0.00,'2022-04-04 10:31:11'),(19,'21','238',2,'Sale Id shift 8',0.00,5721966.68,698.00,5721966.68,0.00,'2022-04-06 08:53:05'),(20,'21','238',3,'Sale Id shift 8',0.00,112640.00,550.00,112640.00,0.00,'2022-04-06 08:53:05'),(21,'21','238',1,'Sale Id shift 8',0.00,2683682.10,165.00,2683682.10,0.00,'2022-04-06 08:53:05'),(22,'21','238',2,'Sale Id shift 9',0.00,5144797.46,698.00,5144797.46,0.00,'2022-04-06 12:34:14'),(23,'21','238',3,'Sale Id shift 9',0.00,111710.50,550.00,111710.50,0.00,'2022-04-06 12:34:14'),(24,'21','238',1,'Sale Id shift 9',0.00,4956715.50,165.00,4956715.50,0.00,'2022-04-06 12:34:14'),(25,'21','238',2,'Sale Id shift 10',0.00,4150077.66,698.00,4150077.66,0.00,'2022-04-07 09:47:12'),(26,'21','238',3,'Sale Id shift 10',0.00,52431.50,550.00,52431.50,0.00,'2022-04-07 09:47:12'),(27,'21','238',1,'Sale Id shift 10',0.00,4498518.75,165.00,4498518.75,0.00,'2022-04-07 09:47:12'),(28,'21','238',1,'Sale Id shift 11',0.00,2806857.90,165.00,2806857.90,0.00,'2022-04-08 11:05:27'),(29,'21','238',2,'Sale Id shift 11',0.00,4995439.42,698.00,4995439.42,0.00,'2022-04-08 11:05:27'),(30,'21','238',3,'Sale Id shift 11',0.00,65307.00,550.00,65307.00,0.00,'2022-04-08 11:05:27'),(31,'21','238',2,'Sale Id shift 12',0.00,3661659.14,698.00,3661659.14,0.00,'2022-04-09 12:09:25'),(32,'21','238',3,'Sale Id shift 12',0.00,89556.50,550.00,89556.50,0.00,'2022-04-09 12:09:25'),(33,'21','238',1,'Sale Id shift 12',0.00,2664764.85,165.00,2664764.85,0.00,'2022-04-09 12:09:25'),(34,'21','238',1,'Sale Id shift 13',0.00,2366624.70,165.00,2366624.70,0.00,'2022-04-10 09:36:38'),(35,'21','238',2,'Sale Id shift 13',0.00,4457358.20,698.00,4457358.20,0.00,'2022-04-10 09:36:38'),(36,'21','238',3,'Sale Id shift 13',0.00,77528.00,550.00,77528.00,0.00,'2022-04-10 09:36:38'),(37,'21','238',2,'Sale Id shift 14',0.00,5508190.22,698.00,5508190.22,0.00,'2022-04-11 08:14:19'),(38,'21','238',3,'Sale Id shift 14',0.00,40793.50,550.00,40793.50,0.00,'2022-04-11 08:14:19'),(39,'21','238',2,'Sale Id shift 15',0.00,2177948.46,698.00,2177948.46,0.00,'2022-04-12 16:12:41'),(40,'21','238',2,'Sale Id shift 17',0.00,2950981.44,678.00,2950981.44,0.00,'2022-04-15 14:12:02'),(41,'21','238',3,'Sale Id shift 17',0.00,56930.50,550.00,56930.50,0.00,'2022-04-15 14:12:02'),(42,'21','238',1,'Sale Id shift 17',0.00,2840112.00,165.00,2840112.00,0.00,'2022-04-15 14:12:02'),(43,'21','238',2,'Sale Id shift 18',0.00,3995908.26,678.00,3995908.26,0.00,'2022-04-15 14:55:46'),(44,'21','238',3,'Sale Id shift 18',0.00,46596.00,550.00,46596.00,0.00,'2022-04-15 14:55:46'),(45,'21','238',1,'Sale Id shift 18',0.00,2452946.10,165.00,2452946.10,0.00,'2022-04-15 14:55:46'),(46,'21','238',1,'Sale Id shift 19',0.00,2028663.45,165.00,2028663.45,0.00,'2022-04-15 15:40:43'),(47,'21','238',2,'Sale Id shift 19',0.00,6515085.06,678.00,6515085.06,0.00,'2022-04-15 15:40:43'),(48,'21','238',3,'Sale Id shift 19',0.00,68442.00,550.00,68442.00,0.00,'2022-04-15 15:40:43'),(49,'21','238',2,'Sale Id shift 20',0.00,5359745.94,678.00,5359745.94,0.00,'2022-04-16 11:07:39'),(50,'21','238',3,'Sale Id shift 20',0.00,109879.00,550.00,109879.00,0.00,'2022-04-16 11:07:39'),(51,'21','238',1,'Sale Id shift 20',0.00,2463154.65,165.00,2463154.65,0.00,'2022-04-16 11:07:39'),(52,'21','238',2,'Sale Id shift 21',0.00,3930243.96,678.00,3930243.96,0.00,'2022-04-16 16:28:56'),(53,'21','238',3,'Sale Id shift 21',0.00,78798.50,550.00,78798.50,0.00,'2022-04-16 16:28:56'),(54,'21','238',1,'Sale Id shift 22',0.00,2448791.40,165.00,2448791.40,0.00,'2022-04-18 15:23:21'),(55,'21','238',2,'Sale Id shift 22',0.00,4802436.72,678.00,4802436.72,0.00,'2022-04-18 15:23:21'),(56,'21','238',3,'Sale Id shift 22',0.00,73243.50,550.00,73243.50,0.00,'2022-04-18 15:23:21'),(57,'21','238',2,'Sale Id shift 23',0.00,8383022.52,678.00,8383022.52,0.00,'2022-04-18 15:47:06'),(58,'21','238',3,'Sale Id shift 23',0.00,60115.00,550.00,60115.00,0.00,'2022-04-18 15:47:06'),(59,'21','238',1,'Sale Id shift 23',0.00,3655754.85,165.00,3655754.85,0.00,'2022-04-18 15:47:06'),(60,'21','238',2,'Sale Id shift 24',0.00,382703.88,678.00,382703.88,0.00,'2022-04-19 10:54:59'),(61,'21','238',1,'Sale Id shift 25',0.00,1310936.55,165.00,1310936.55,0.00,'2022-04-20 12:05:56'),(62,'21','238',2,'Sale Id shift 25',0.00,3192703.02,663.00,3192703.02,0.00,'2022-04-20 12:05:56'),(63,'21','238',3,'Sale Id shift 25',0.00,146894.00,550.00,146894.00,0.00,'2022-04-20 12:05:56'),(64,'21','238',2,'Sale Id shift 26',0.00,4069679.64,663.00,4069679.64,0.00,'2022-04-21 11:32:06'),(65,'21','238',3,'Sale Id shift 26',0.00,120202.50,550.00,120202.50,0.00,'2022-04-21 11:32:06'),(66,'21','238',1,'Sale Id shift 26',0.00,934984.05,165.00,934984.05,0.00,'2022-04-21 11:32:06'),(67,'21','238',1,'Sale Id shift 27',0.00,4216579.95,165.00,4216579.95,0.00,'2022-04-21 12:08:03'),(68,'21','238',2,'Sale Id shift 27',0.00,5926782.42,663.00,5926782.42,0.00,'2022-04-21 12:08:03'),(69,'21','238',3,'Sale Id shift 27',0.00,39011.50,550.00,39011.50,0.00,'2022-04-21 12:08:03'),(70,'21','238',1,'Sale Id shift 28',0.00,2365699.05,165.00,2365699.05,0.00,'2022-04-22 13:57:58'),(71,'21','238',2,'Sale Id shift 28',0.00,5919860.70,663.00,5919860.70,0.00,'2022-04-22 13:57:58'),(72,'21','238',3,'Sale Id shift 28',0.00,94209.50,550.00,94209.50,0.00,'2022-04-22 13:57:58'),(73,'21','238',1,'Sale Id shift 29',0.00,2501814.15,165.00,2501814.15,0.00,'2022-04-23 11:16:30'),(74,'21','238',2,'Sale Id shift 29',0.00,4538374.23,663.00,4538374.23,0.00,'2022-04-23 11:16:30'),(75,'21','238',3,'Sale Id shift 29',0.00,92202.00,550.00,92202.00,0.00,'2022-04-23 11:16:30'),(76,'21','238',1,'Sale Id shift 30',0.00,2806943.70,165.00,2806943.70,0.00,'2022-04-24 11:18:13'),(77,'21','238',2,'Sale Id shift 30',0.00,4503454.02,663.00,4503454.02,0.00,'2022-04-24 11:18:13'),(78,'21','238',3,'Sale Id shift 30',0.00,137533.00,550.00,137533.00,0.00,'2022-04-24 11:18:13'),(79,'21','238',1,'Sale Id shift 31',0.00,2532873.75,165.00,2532873.75,0.00,'2022-04-25 10:54:31'),(80,'21','238',2,'Sale Id shift 31',0.00,5414913.27,663.00,5414913.27,0.00,'2022-04-25 10:54:31'),(81,'21','238',3,'Sale Id shift 31',0.00,182006.00,550.00,182006.00,0.00,'2022-04-25 10:54:31'),(82,'21','238',2,'Sale Id shift 32',0.00,6047673.84,663.00,6047673.84,0.00,'2022-04-26 11:03:30'),(83,'21','238',3,'Sale Id shift 32',0.00,78760.00,550.00,78760.00,0.00,'2022-04-26 11:03:30'),(84,'21','238',1,'Sale Id shift 33',0.00,4882744.35,165.00,4882744.35,0.00,'2022-04-27 12:24:45'),(85,'21','238',2,'Sale Id shift 33',0.00,5099994.90,663.00,5099994.90,0.00,'2022-04-27 12:24:45'),(86,'21','238',3,'Sale Id shift 33',0.00,75707.50,550.00,75707.50,0.00,'2022-04-27 12:24:45'),(87,'21','238',1,'Sale Id shift 34',0.00,2778934.95,165.00,2778934.95,0.00,'2022-04-28 14:03:25'),(88,'21','238',2,'Sale Id shift 34',0.00,4983751.11,663.00,4983751.11,0.00,'2022-04-28 14:03:25'),(89,'21','238',3,'Sale Id shift 34',0.00,54015.50,550.00,54015.50,0.00,'2022-04-28 14:03:25'),(90,'21','238',2,'Sale Id shift 35',0.00,1925995.11,663.00,1925995.11,0.00,'2022-04-29 09:15:07'),(91,'21','238',3,'Sale Id shift 35',0.00,128051.00,550.00,128051.00,0.00,'2022-04-29 09:15:07'),(92,'21','238',1,'Sale Id shift 35',0.00,2697311.10,165.00,2697311.10,0.00,'2022-04-29 09:15:07'),(93,'21','238',1,'Sale Id shift 36',0.00,2434967.70,165.00,2434967.70,0.00,'2022-04-30 13:10:20'),(94,'21','238',2,'Sale Id shift 36',0.00,6199427.91,663.00,6199427.91,0.00,'2022-04-30 13:10:20'),(95,'21','238',3,'Sale Id shift 36',0.00,198346.50,550.00,198346.50,0.00,'2022-04-30 13:10:20'),(96,'21','238',1,'Sale Id shift 37',0.00,3396067.95,165.00,3396067.95,0.00,'2022-05-01 09:00:52'),(97,'21','238',2,'Sale Id shift 37',0.00,4037623.59,663.00,4037623.59,0.00,'2022-05-01 09:00:52'),(98,'21','238',3,'Sale Id shift 37',0.00,107739.50,550.00,107739.50,0.00,'2022-05-01 09:00:52'),(99,'21','238',1,'Sale Id shift 38',0.00,4785952.05,165.00,4785952.05,0.00,'2022-05-06 11:43:54'),(100,'21','238',2,'Sale Id shift 38',0.00,3769082.07,663.00,3769082.07,0.00,'2022-05-06 11:43:54'),(101,'21','238',3,'Sale Id shift 38',0.00,79024.00,550.00,79024.00,0.00,'2022-05-06 11:43:54'),(102,'21','238',1,'Sale Id shift 39',0.00,2314291.65,165.00,2314291.65,0.00,'2022-05-06 12:37:03'),(103,'21','238',2,'Sale Id shift 39',0.00,2047841.25,663.00,2047841.25,0.00,'2022-05-06 12:37:03'),(104,'21','238',3,'Sale Id shift 39',0.00,23358.50,550.00,23358.50,0.00,'2022-05-06 12:37:03'),(105,'21','238',1,'Sale Id shift 40',0.00,1146377.10,165.00,1146377.10,0.00,'2022-05-06 14:37:29'),(106,'21','238',2,'Sale Id shift 40',0.00,1757931.24,663.00,1757931.24,0.00,'2022-05-06 14:37:29'),(107,'21','238',3,'Sale Id shift 40',0.00,43587.50,550.00,43587.50,0.00,'2022-05-06 14:37:29'),(108,'21','238',2,'Sale Id shift 41',0.00,7511584.47,663.00,7511584.47,0.00,'2022-05-06 15:06:37'),(109,'21','238',3,'Sale Id shift 41',0.00,105407.50,550.00,105407.50,0.00,'2022-05-06 15:06:37'),(110,'21','238',1,'Sale Id shift 41',0.00,1887322.80,165.00,1887322.80,0.00,'2022-05-06 15:06:37'),(111,'21','238',1,'Sale Id shift 42',0.00,4136916.30,165.00,4136916.30,0.00,'2022-05-07 16:23:52'),(112,'21','238',2,'Sale Id shift 42',0.00,7974219.24,663.00,7974219.24,0.00,'2022-05-07 16:23:52'),(113,'21','238',3,'Sale Id shift 42',0.00,255535.50,550.00,255535.50,0.00,'2022-05-07 16:23:52'),(114,'21','238',1,'Sale Id shift 44',0.00,4943761.35,165.00,4943761.35,0.00,'2022-05-17 16:22:07'),(115,'21','238',2,'Sale Id shift 44',0.00,6902658.75,663.00,6902658.75,0.00,'2022-05-17 16:22:07'),(116,'21','238',3,'Sale Id shift 44',0.00,101145.00,550.00,101145.00,0.00,'2022-05-17 16:22:07'),(117,'21','238',2,'Sale Id shift 45',0.00,1496430.78,663.00,1496430.78,0.00,'2022-05-17 16:40:03'),(118,'21','238',3,'Sale Id shift 45',0.00,1204.50,550.00,1204.50,0.00,'2022-05-17 16:40:03'),(119,'21','238',2,'Sale Id shift 46',0.00,4227431.70,678.00,4227431.70,0.00,'2022-05-17 17:13:31'),(120,'21','238',3,'Sale Id shift 46',0.00,131163.50,650.00,131163.50,0.00,'2022-05-17 17:13:31'),(121,'21','238',1,'Sale Id shift 46',0.00,5254774.80,165.00,5254774.80,0.00,'2022-05-17 17:13:31'),(122,'21','238',1,'Sale Id shift 47',0.00,478927.35,165.00,478927.35,0.00,'2022-05-17 17:49:48'),(123,'21','238',2,'Sale Id shift 47',0.00,5830949.16,678.00,5830949.16,0.00,'2022-05-17 17:49:48'),(124,'21','238',3,'Sale Id shift 47',0.00,131027.00,650.00,131027.00,0.00,'2022-05-17 17:49:48'),(125,'21','238',2,'Sale Id shift 48',0.00,9260191.80,678.00,9260191.80,0.00,'2022-05-17 18:19:22'),(126,'21','238',3,'Sale Id shift 48',0.00,119697.50,650.00,119697.50,0.00,'2022-05-17 18:19:22'),(127,'21','238',2,'Sale Id shift 49',0.00,10143998.70,678.00,10143998.70,0.00,'2022-05-17 19:37:39'),(128,'21','238',3,'Sale Id shift 49',0.00,208741.00,650.00,208741.00,0.00,'2022-05-17 19:37:39'),(129,'21','238',1,'Sale Id shift 49',0.00,2476305.15,165.00,2476305.15,0.00,'2022-05-17 19:37:39'),(130,'21','238',2,'Sale Id shift 50',0.00,9150159.18,678.00,9150159.18,0.00,'2022-05-17 21:17:13'),(131,'21','238',3,'Sale Id shift 50',0.00,72065.50,650.00,72065.50,0.00,'2022-05-17 21:17:13'),(132,'21','238',3,'Sale Id shift 51',0.00,72637.50,650.00,72637.50,0.00,'2022-05-18 13:45:22'),(133,'21','238',3,'Sale Id shift 52',0.00,58662.50,650.00,58662.50,0.00,'2022-05-18 13:57:38'),(134,'21','238',2,'Sale Id shift 53',0.00,5926005.82,718.00,5926005.82,0.00,'2022-05-18 16:39:27'),(135,'21','238',3,'Sale Id shift 53',0.00,112398.00,650.00,112398.00,0.00,'2022-05-18 16:39:27'),(136,'21','238',1,'Sale Id shift 54',0.00,2738627.10,165.00,2738627.10,0.00,'2022-05-18 17:05:07'),(137,'21','238',2,'Sale Id shift 54',0.00,4914925.40,718.00,4914925.40,0.00,'2022-05-18 17:05:07'),(138,'21','238',3,'Sale Id shift 54',0.00,72624.50,650.00,72624.50,0.00,'2022-05-18 17:05:07'),(139,'21','238',3,'Sale Id shift 55',0.00,76011.00,650.00,76011.00,0.00,'2022-05-18 17:16:05'),(140,'21','238',1,'Sale Id shift 56',0.00,5980708.80,165.00,5980708.80,0.00,'2022-05-18 17:58:53'),(141,'21','238',2,'Sale Id shift 56',0.00,3405825.82,718.00,3405825.82,0.00,'2022-05-18 17:58:53'),(142,'21','238',3,'Sale Id shift 56',0.00,115628.50,650.00,115628.50,0.00,'2022-05-18 17:58:53'),(143,'21','238',1,'Sale Id shift 57',0.00,2521223.10,165.00,2521223.10,0.00,'2022-05-20 09:15:59'),(144,'21','238',2,'Sale Id shift 57',0.00,7526549.88,718.00,7526549.88,0.00,'2022-05-20 09:15:59'),(145,'21','238',3,'Sale Id shift 57',0.00,77109.50,650.00,77109.50,0.00,'2022-05-20 09:15:59'),(146,'21','238',1,'Sale Id shift 58',0.00,2664938.10,165.00,2664938.10,0.00,'2022-05-20 09:52:52'),(147,'21','238',2,'Sale Id shift 58',0.00,6010521.60,718.00,6010521.60,0.00,'2022-05-20 09:52:52'),(148,'21','238',3,'Sale Id shift 58',0.00,102771.50,650.00,102771.50,0.00,'2022-05-20 09:52:52'),(149,'21','238',1,'Sale Id shift 59',0.00,2491643.55,165.00,2491643.55,0.00,'2022-05-22 18:06:25'),(150,'21','238',2,'Sale Id shift 59',0.00,3768868.16,718.00,3768868.16,0.00,'2022-05-22 18:06:25'),(151,'21','238',3,'Sale Id shift 59',0.00,90434.50,650.00,90434.50,0.00,'2022-05-22 18:06:25'),(152,'21','238',2,'Sale Id shift 60',0.00,4879398.76,718.00,4879398.76,0.00,'2022-05-22 18:25:50'),(153,'21','238',3,'Sale Id shift 60',0.00,107705.00,650.00,107705.00,0.00,'2022-05-22 18:25:50'),(154,'21','238',2,'Sale Id shift 61',0.00,6601478.68,718.00,6601478.68,0.00,'2022-05-25 15:03:37'),(155,'21','238',2,'Sale Id shift 62',0.00,30805.12,758.00,30805.12,0.00,'2022-05-25 15:45:28'),(156,'21','238',3,'Sale Id shift 62',0.00,148830.50,650.00,148830.50,0.00,'2022-05-25 15:45:28'),(157,'21','238',1,'Sale Id shift 62',0.00,2660034.30,165.00,2660034.30,0.00,'2022-05-25 15:45:28'),(158,'21','238',3,'Sale Id shift 63',0.00,145249.00,650.00,145249.00,0.00,'2022-05-25 15:54:41'),(159,'21','238',3,'Sale Id shift 64',0.00,95049.50,650.00,95049.50,0.00,'2022-05-25 16:41:07'),(160,'21','238',1,'Sale Id shift 64',0.00,3730973.40,165.00,3730973.40,0.00,'2022-05-25 16:41:07'),(161,'21','238',1,'Sale Id shift 65',0.00,3722622.75,165.00,3722622.75,0.00,'2022-05-30 12:14:55'),(162,'21','238',2,'Sale Id shift 65',0.00,1797369.60,758.00,1797369.60,0.00,'2022-05-30 12:14:55'),(163,'21','238',3,'Sale Id shift 65',0.00,58649.50,650.00,58649.50,0.00,'2022-05-30 12:14:55'),(164,'21','238',2,'Sale Id shift 66',0.00,8333110.90,758.00,8333110.90,0.00,'2022-05-30 17:31:13'),(165,'21','238',3,'Sale Id shift 66',0.00,241956.00,650.00,241956.00,0.00,'2022-05-30 17:31:13'),(166,'21','238',2,'Sale Id shift 67',0.00,3732149.44,758.00,3732149.44,0.00,'2022-05-30 17:47:05'),(167,'21','238',3,'Sale Id shift 67',0.00,40768.00,650.00,40768.00,0.00,'2022-05-30 17:47:05'),(168,'21','238',1,'Sale Id shift 67',0.00,2946645.90,165.00,2946645.90,0.00,'2022-05-30 17:47:05'),(169,'21','238',2,'Sale Id shift 68',0.00,7255386.50,758.00,7255386.50,0.00,'2022-05-30 18:12:40'),(170,'21','238',3,'Sale Id shift 68',0.00,97272.50,650.00,97272.50,0.00,'2022-05-30 18:12:40'),(171,'21','238',1,'Sale Id shift 69',0.00,2472759.30,165.00,2472759.30,0.00,'2022-05-30 18:24:11'),(172,'21','238',2,'Sale Id shift 69',0.00,624902.78,758.00,624902.78,0.00,'2022-05-30 18:24:11'),(173,'21','238',3,'Sale Id shift 69',0.00,57395.00,650.00,57395.00,0.00,'2022-05-30 18:24:11'),(174,'21','238',2,'Sale Id shift 70',0.00,3314142.76,758.00,3314142.76,0.00,'2022-06-01 12:28:53'),(175,'21','238',3,'Sale Id shift 70',0.00,88575.50,650.00,88575.50,0.00,'2022-06-01 12:28:53'),(176,'21','238',1,'Sale Id shift 71',0.00,1273031.10,165.00,1273031.10,0.00,'2022-06-01 15:34:00'),(177,'21','238',2,'Sale Id shift 71',0.00,7414551.34,758.00,7414551.34,0.00,'2022-06-01 15:34:00'),(178,'21','238',3,'Sale Id shift 71',0.00,66189.50,650.00,66189.50,0.00,'2022-06-01 15:34:00'),(179,'21','238',2,'Sale Id shift 72',0.00,4432314.04,758.00,4432314.04,0.00,'2022-06-02 12:53:42'),(180,'21','238',3,'Sale Id shift 72',0.00,44934.50,650.00,44934.50,0.00,'2022-06-02 12:53:42'),(181,'21','238',1,'Sale Id shift 72',0.00,1944985.35,165.00,1944985.35,0.00,'2022-06-02 12:53:42'),(182,'21','238',1,'Sale Id shift 73',0.00,1863708.00,165.00,1863708.00,0.00,'2022-06-06 16:19:25'),(183,'21','238',2,'Sale Id shift 73',0.00,10543916.44,758.00,10543916.44,0.00,'2022-06-06 16:19:25'),(184,'21','238',3,'Sale Id shift 73',0.00,128388.00,650.00,128388.00,0.00,'2022-06-06 16:19:25'),(185,'21','238',2,'Sale Id shift 74',0.00,5296593.22,758.00,5296593.22,0.00,'2022-06-06 16:45:49'),(186,'21','238',3,'Sale Id shift 74',0.00,58324.50,650.00,58324.50,0.00,'2022-06-06 16:45:49'),(187,'21','238',2,'Sale Id shift 75',0.00,5221225.28,758.00,5221225.28,0.00,'2022-06-06 16:59:58'),(188,'21','238',1,'Sale Id shift 76',0.00,2477219.25,165.00,2477219.25,0.00,'2022-06-06 17:52:25'),(189,'21','238',2,'Sale Id shift 76',0.00,1018083.02,778.00,1018083.02,0.00,'2022-06-06 17:52:25'),(190,'21','238',3,'Sale Id shift 76',0.00,59761.00,650.00,59761.00,0.00,'2022-06-06 17:52:25'),(191,'21','238',2,'Sale Id shift 77',0.00,5366083.84,778.00,5366083.84,0.00,'2022-06-07 14:58:58'),(192,'21','238',3,'Sale Id shift 77',0.00,142863.50,650.00,142863.50,0.00,'2022-06-07 14:58:58'),(193,'21','238',1,'Sale Id shift 77',0.00,1923759.75,165.00,1923759.75,0.00,'2022-06-07 14:58:58'),(194,'21','238',1,'Sale Id shift 78',0.00,562522.95,165.00,562522.95,0.00,'2022-06-07 16:04:17'),(195,'21','238',2,'Sale Id shift 78',0.00,8902646.22,778.00,8902646.22,0.00,'2022-06-07 16:04:17'),(196,'21','238',3,'Sale Id shift 78',0.00,74412.00,650.00,74412.00,0.00,'2022-06-07 16:04:17'),(197,'21','238',1,'Sale Id shift 79',0.00,4527237.00,165.00,4527237.00,0.00,'2022-06-09 15:01:00'),(198,'21','238',2,'Sale Id shift 79',0.00,7540259.30,778.00,7540259.30,0.00,'2022-06-09 15:01:00'),(199,'21','238',3,'Sale Id shift 79',0.00,49926.50,650.00,49926.50,0.00,'2022-06-09 15:01:00'),(200,'21','238',2,'Sale Id shift 80',0.00,2219688.46,778.00,2219688.46,0.00,'2022-06-14 15:38:02'),(201,'21','238',3,'Sale Id shift 80',0.00,24856.00,650.00,24856.00,0.00,'2022-06-14 15:38:02'),(202,'21','238',2,'Sale Id shift 81',0.00,1154817.72,798.00,1154817.72,0.00,'2022-06-14 16:03:46'),(203,'21','238',3,'Sale Id shift 81',0.00,38227.00,700.00,38227.00,0.00,'2022-06-14 16:03:46'),(204,'21','238',1,'Sale Id shift 81',0.00,4700785.65,165.00,4700785.65,0.00,'2022-06-14 16:03:46'),(205,'21','238',1,'Sale Id shift 82',0.00,4519769.10,165.00,4519769.10,0.00,'2022-06-15 15:46:52'),(206,'21','238',2,'Sale Id shift 82',0.00,8666375.76,798.00,8666375.76,0.00,'2022-06-15 15:46:52'),(207,'21','238',3,'Sale Id shift 82',0.00,91182.00,700.00,91182.00,0.00,'2022-06-15 15:46:52'),(208,'21','238',2,'Sale Id shift 83',0.00,2298798.60,798.00,2298798.60,0.00,'2022-06-15 16:11:29'),(209,'21','238',3,'Sale Id shift 83',0.00,37156.00,700.00,37156.00,0.00,'2022-06-15 16:11:29'),(210,'21','238',1,'Sale Id shift 83',0.00,2241036.60,165.00,2241036.60,0.00,'2022-06-15 16:11:29'),(211,'21','238',2,'Sale Id shift 84',0.00,2539499.34,798.00,2539499.34,0.00,'2022-06-15 16:22:32'),(212,'21','238',2,'Sale Id shift 85',0.00,835996.00,818.00,835996.00,0.00,'2022-06-15 16:32:13'),(213,'21','238',3,'Sale Id shift 85',0.00,62510.00,700.00,62510.00,0.00,'2022-06-15 16:32:13'),(214,'21','238',2,'Sale Id shift 86',0.00,5905199.26,818.00,5905199.26,0.00,'2022-06-15 16:43:47'),(215,'21','238',3,'Sale Id shift 86',0.00,130753.00,700.00,130753.00,0.00,'2022-06-15 16:43:47'),(216,'21','238',1,'Sale Id shift 88',0.00,214429.05,165.00,214429.05,0.00,'2022-06-17 15:31:20'),(217,'21','238',2,'Sale Id shift 88',0.00,5715186.04,818.00,5715186.04,0.00,'2022-06-17 15:31:20'),(218,'21','238',3,'Sale Id shift 88',0.00,16555.00,700.00,16555.00,0.00,'2022-06-17 15:31:20'),(219,'21','238',3,'Sale Id shift 90',0.00,57659.00,700.00,57659.00,0.00,'2022-06-17 15:49:14'),(220,'21','238',1,'Sale Id shift 91',0.00,5229147.00,165.00,5229147.00,0.00,'2022-06-17 16:31:55'),(221,'21','238',2,'Sale Id shift 91',0.00,7510606.06,818.00,7510606.06,0.00,'2022-06-17 16:31:55'),(222,'21','238',3,'Sale Id shift 91',0.00,59580.00,750.00,59580.00,0.00,'2022-06-17 16:31:55'),(223,'21','238',1,'Sale Id shift 92',0.00,1584795.30,165.00,1584795.30,0.00,'2022-06-21 14:44:19'),(224,'21','238',2,'Sale Id shift 92',0.00,5577475.74,818.00,5577475.74,0.00,'2022-06-21 14:44:19'),(225,'21','238',3,'Sale Id shift 92',0.00,72022.50,750.00,72022.50,0.00,'2022-06-21 14:44:19'),(226,'21','238',2,'Sale Id shift 93',0.00,3790039.40,818.00,3790039.40,0.00,'2022-06-21 15:24:50'),(227,'21','238',3,'Sale Id shift 93',0.00,112822.50,750.00,112822.50,0.00,'2022-06-21 15:24:50'),(228,'21','238',1,'Sale Id shift 93',0.00,776735.85,165.00,776735.85,0.00,'2022-06-21 15:24:50'),(229,'21','238',3,'Sale Id shift 94',0.00,37335.00,750.00,37335.00,0.00,'2022-06-21 15:28:22'),(230,'21','238',3,'Sale Id shift 95',0.00,77505.00,750.00,77505.00,0.00,'2022-06-21 15:31:38'),(231,'21','238',1,'Sale Id shift 96',0.00,2691511.35,165.00,2691511.35,0.00,'2022-06-21 16:08:55'),(232,'21','238',2,'Sale Id shift 96',0.00,7369150.32,828.00,7369150.32,0.00,'2022-06-21 16:08:55'),(233,'21','238',3,'Sale Id shift 96',0.00,50460.00,750.00,50460.00,0.00,'2022-06-21 16:08:55'),(234,'21','238',2,'Sale Id shift 97',0.00,6441012.00,828.00,6441012.00,0.00,'2022-06-21 16:40:55'),(235,'21','238',3,'Sale Id shift 97',0.00,84247.50,750.00,84247.50,0.00,'2022-06-21 16:40:55'),(236,'21','238',1,'Sale Id shift 98',0.00,3313104.30,165.00,3313104.30,0.00,'2022-06-22 14:39:10'),(237,'21','238',2,'Sale Id shift 98',0.00,7770713.76,828.00,7770713.76,0.00,'2022-06-22 14:39:10'),(238,'21','238',3,'Sale Id shift 98',0.00,65550.00,750.00,65550.00,0.00,'2022-06-22 14:39:10'),(239,'21','238',1,'Sale Id shift 99',0.00,1551628.65,165.00,1551628.65,0.00,'2022-06-28 14:03:27'),(240,'21','238',2,'Sale Id shift 99',0.00,6344748.72,828.00,6344748.72,0.00,'2022-06-28 14:03:27'),(241,'21','238',3,'Sale Id shift 99',0.00,73830.00,750.00,73830.00,0.00,'2022-06-28 14:03:27'),(242,'21','238',2,'Sale Id shift 100',0.00,7517643.84,828.00,7517643.84,0.00,'2022-06-28 14:24:04'),(243,'21','238',3,'Sale Id shift 100',0.00,73252.50,750.00,73252.50,0.00,'2022-06-28 14:24:04'),(244,'21','238',2,'Sale Id shift 101',0.00,3578847.84,828.00,3578847.84,0.00,'2022-06-28 15:07:42'),(245,'21','238',3,'Sale Id shift 101',0.00,74580.00,750.00,74580.00,0.00,'2022-06-28 15:07:42'),(246,'21','238',2,'Sale Id shift 102',0.00,8387242.56,828.00,8387242.56,0.00,'2022-06-28 16:02:25'),(247,'21','238',3,'Sale Id shift 102',0.00,56625.00,750.00,56625.00,0.00,'2022-06-28 16:02:25'),(248,'21','238',2,'Sale Id shift 103',0.00,5928496.56,828.00,5928496.56,0.00,'2022-06-28 16:18:07'),(249,'21','238',3,'Sale Id shift 103',0.00,38445.00,750.00,38445.00,0.00,'2022-06-28 16:18:07'),(250,'21','238',2,'Sale Id shift 104',0.00,9240239.88,828.00,9240239.88,0.00,'2022-06-28 16:57:32'),(251,'21','238',3,'Sale Id shift 104',0.00,47362.50,750.00,47362.50,0.00,'2022-06-28 16:57:32'),(252,'21','238',1,'Sale Id shift 105',0.00,2459993.25,165.00,2459993.25,0.00,'2022-06-29 14:39:57'),(253,'21','238',2,'Sale Id shift 105',0.00,8745087.60,828.00,8745087.60,0.00,'2022-06-29 14:39:57'),(254,'21','238',3,'Sale Id shift 105',0.00,78600.00,750.00,78600.00,0.00,'2022-06-29 14:39:57'),(255,'21','238',1,'Sale Id shift 106',0.00,2378059.20,165.00,2378059.20,0.00,'2022-07-08 12:45:28'),(256,'21','238',2,'Sale Id shift 106',0.00,9892993.68,828.00,9892993.68,0.00,'2022-07-08 12:45:28'),(257,'21','238',3,'Sale Id shift 106',0.00,101227.50,750.00,101227.50,0.00,'2022-07-08 12:45:28'),(258,'21','238',1,'Sale Id shift 107',0.00,83023.05,165.00,83023.05,0.00,'2022-07-08 15:07:23'),(259,'21','238',2,'Sale Id shift 107',0.00,6310767.60,828.00,6310767.60,0.00,'2022-07-08 15:07:23'),(260,'21','238',3,'Sale Id shift 107',0.00,28485.00,750.00,28485.00,0.00,'2022-07-08 15:07:23'),(261,'21','238',1,'Sale Id shift 108',0.00,17296.95,165.00,17296.95,0.00,'2022-07-08 15:22:17'),(262,'21','238',2,'Sale Id shift 108',0.00,5984651.52,828.00,5984651.52,0.00,'2022-07-08 15:22:17'),(263,'21','238',3,'Sale Id shift 108',0.00,55717.50,750.00,55717.50,0.00,'2022-07-08 15:22:17'),(264,'21','238',2,'Sale Id shift 109',0.00,5781551.40,828.00,5781551.40,0.00,'2022-07-08 15:43:49'),(265,'21','238',3,'Sale Id shift 109',0.00,65790.00,750.00,65790.00,0.00,'2022-07-08 15:43:49'),(266,'21','238',2,'Sale Id shift 110',0.00,4801679.64,828.00,4801679.64,0.00,'2022-07-08 16:20:57'),(267,'21','238',3,'Sale Id shift 110',0.00,73200.00,750.00,73200.00,0.00,'2022-07-08 16:20:57'),(268,'21','238',2,'Sale Id shift 111',0.00,5743032.84,828.00,5743032.84,0.00,'2022-07-08 16:35:30'),(269,'21','238',3,'Sale Id shift 111',0.00,97627.50,750.00,97627.50,0.00,'2022-07-08 16:35:30'),(270,'21','238',2,'Sale Id shift 112',0.00,6693055.20,828.00,6693055.20,0.00,'2022-07-08 16:52:12'),(271,'21','238',3,'Sale Id shift 112',0.00,138960.00,750.00,138960.00,0.00,'2022-07-08 16:52:12'),(272,'21','238',2,'Sale Id shift 113',0.00,4256681.76,828.00,4256681.76,0.00,'2022-07-09 16:04:36'),(273,'21','238',3,'Sale Id shift 113',0.00,66352.50,750.00,66352.50,0.00,'2022-07-09 16:04:36'),(274,'21','238',1,'Sale Id shift 114',0.00,2822877.75,165.00,2822877.75,0.00,'2022-07-09 16:31:49'),(275,'21','238',2,'Sale Id shift 114',0.00,3945411.72,828.00,3945411.72,0.00,'2022-07-09 16:31:49'),(276,'21','238',3,'Sale Id shift 114',0.00,97815.00,750.00,97815.00,0.00,'2022-07-09 16:31:49'),(277,'21','238',2,'Sale Id shift 115',0.00,2667128.76,828.00,2667128.76,0.00,'2022-07-13 17:18:13'),(278,'21','238',3,'Sale Id shift 115',0.00,99307.50,750.00,99307.50,0.00,'2022-07-13 17:18:13'),(279,'21','238',1,'Sale Id shift 116',0.00,2806771.90,185.00,2806771.90,0.00,'2022-07-13 17:45:05'),(280,'21','238',2,'Sale Id shift 116',0.00,1083909.96,828.00,1083909.96,0.00,'2022-07-13 17:45:05'),(281,'21','238',3,'Sale Id shift 116',0.00,46590.00,750.00,46590.00,0.00,'2022-07-13 17:45:05'),(282,'21','238',2,'Sale Id shift 117',0.00,1624370.40,828.00,1624370.40,0.00,'2022-07-13 17:52:29'),(283,'21','238',3,'Sale Id shift 117',0.00,59932.50,750.00,59932.50,0.00,'2022-07-13 17:52:29'),(284,'21','238',2,'Sale Id shift 118',0.00,3678158.16,828.00,3678158.16,0.00,'2022-07-13 17:59:15'),(285,'21','238',3,'Sale Id shift 118',0.00,96135.00,750.00,96135.00,0.00,'2022-07-13 17:59:15'),(286,'21','238',2,'Sale Id shift 119',0.00,6685926.12,828.00,6685926.12,0.00,'2022-07-15 09:07:07'),(287,'21','238',3,'Sale Id shift 119',0.00,49267.50,750.00,49267.50,0.00,'2022-07-15 09:07:07'),(288,'21','238',2,'Sale Id shift 120',0.00,6675716.88,828.00,6675716.88,0.00,'2022-07-15 09:32:53'),(289,'21','238',3,'Sale Id shift 120',0.00,54300.00,750.00,54300.00,0.00,'2022-07-15 09:32:53'),(290,'21','238',1,'Sale Id shift 120',0.00,6739020.90,185.00,6739020.90,0.00,'2022-07-15 09:32:53'),(291,'21','238',1,'Sale Id shift 121',0.00,1621654.50,185.00,1621654.50,0.00,'2022-07-18 08:45:46'),(292,'21','238',2,'Sale Id shift 121',0.00,3764982.24,828.00,3764982.24,0.00,'2022-07-18 08:45:46'),(293,'21','238',3,'Sale Id shift 121',0.00,39277.50,750.00,39277.50,0.00,'2022-07-18 08:45:46'),(294,'21','238',1,'Sale Id shift 122',0.00,2803847.05,185.00,2803847.05,0.00,'2022-07-18 09:46:41'),(295,'21','238',2,'Sale Id shift 122',0.00,6272994.24,828.00,6272994.24,0.00,'2022-07-18 09:46:41'),(296,'21','238',3,'Sale Id shift 122',0.00,39697.50,750.00,39697.50,0.00,'2022-07-18 09:46:41'),(297,'21','238',2,'Sale Id shift 123',0.00,3141506.52,828.00,3141506.52,0.00,'2022-07-18 10:04:46'),(298,'21','238',3,'Sale Id shift 123',0.00,136695.00,750.00,136695.00,0.00,'2022-07-18 10:04:46'),(299,'21','238',1,'Sale Id shift 124',0.00,333399.60,185.00,333399.60,0.00,'2022-07-18 13:29:10'),(300,'21','238',2,'Sale Id shift 124',0.00,4571851.68,828.00,4571851.68,0.00,'2022-07-18 13:29:10'),(301,'21','238',3,'Sale Id shift 124',0.00,75622.50,750.00,75622.50,0.00,'2022-07-18 13:29:10'),(302,'21','238',1,'Sale Id shift 125',0.00,2568522.60,190.00,2568522.60,0.00,'2022-07-19 14:23:34'),(303,'21','238',2,'Sale Id shift 125',0.00,5747222.52,828.00,5747222.52,0.00,'2022-07-19 14:23:34'),(304,'21','238',3,'Sale Id shift 125',0.00,104310.00,750.00,104310.00,0.00,'2022-07-19 14:23:34'),(305,'21','238',2,'Sale Id shift 126',0.00,4704538.68,828.00,4704538.68,0.00,'2022-07-20 09:28:55'),(306,'21','238',3,'Sale Id shift 126',0.00,82395.00,750.00,82395.00,0.00,'2022-07-20 09:28:55'),(307,'21','238',2,'Sale Id shift 127',0.00,3775688.28,828.00,3775688.28,0.00,'2022-07-21 11:35:40'),(308,'21','238',1,'Sale Id shift 128',0.00,3137920.30,190.00,3137920.30,0.00,'2022-07-21 12:57:47'),(309,'21','238',2,'Sale Id shift 128',0.00,4183677.00,828.00,4183677.00,0.00,'2022-07-21 12:57:47'),(310,'21','238',3,'Sale Id shift 128',0.00,58410.00,750.00,58410.00,0.00,'2022-07-21 12:57:47'),(311,'21','238',1,'Sale Id shift 129',0.00,2754101.30,190.00,2754101.30,0.00,'2022-07-22 11:35:35'),(312,'21','238',2,'Sale Id shift 129',0.00,4139552.10,813.00,4139552.10,0.00,'2022-07-22 11:35:35'),(313,'21','238',3,'Sale Id shift 129',0.00,41032.50,750.00,41032.50,0.00,'2022-07-22 11:35:35'),(314,'21','238',2,'Sale Id shift 130',0.00,7115058.93,813.00,7115058.93,0.00,'2022-07-25 13:14:37'),(315,'21','238',3,'Sale Id shift 130',0.00,50917.50,750.00,50917.50,0.00,'2022-07-25 13:14:37'),(316,'21','238',2,'Sale Id shift 131',0.00,5048225.94,813.00,5048225.94,0.00,'2022-07-25 13:39:40'),(317,'21','238',3,'Sale Id shift 131',0.00,100200.00,750.00,100200.00,0.00,'2022-07-25 13:39:40'),(318,'21','238',2,'Sale Id shift 132',0.00,4791813.87,813.00,4791813.87,0.00,'2022-07-25 14:03:28'),(319,'21','238',3,'Sale Id shift 132',0.00,62467.50,750.00,62467.50,0.00,'2022-07-25 14:03:28'),(320,'21','238',2,'Sale Id shift 133',0.00,5395645.23,813.00,5395645.23,0.00,'2022-07-26 17:12:47'),(321,'21','238',3,'Sale Id shift 133',0.00,81975.00,750.00,81975.00,0.00,'2022-07-26 17:12:47'),(322,'21','238',3,'Sale Id shift 134',0.00,25335.00,750.00,25335.00,0.00,'2022-07-27 18:59:30'),(323,'21','238',2,'Sale Id shift 135',0.00,4001642.91,813.00,4001642.91,0.00,'2022-07-27 19:33:43'),(324,'21','238',3,'Sale Id shift 135',0.00,40664.50,835.00,40664.50,0.00,'2022-07-27 19:33:43'),(325,'21','238',1,'Sale Id shift 135',0.00,2941084.10,190.00,2941084.10,0.00,'2022-07-27 19:33:43'),(326,'21','238',2,'Sale Id shift 136',0.00,5038087.83,813.00,5038087.83,0.00,'2022-07-28 17:30:38'),(327,'21','238',3,'Sale Id shift 136',0.00,115330.20,835.00,115330.20,0.00,'2022-07-28 17:30:38'),(328,'21','238',1,'Sale Id shift 136',0.00,2787098.60,190.00,2787098.60,0.00,'2022-07-28 17:30:38'),(329,'21','238',1,'Sale Id shift 137',0.00,3240250.50,190.00,3240250.50,0.00,'2022-07-29 15:33:51'),(330,'21','238',2,'Sale Id shift 137',0.00,5858014.59,813.00,5858014.59,0.00,'2022-07-29 15:33:51'),(331,'21','238',3,'Sale Id shift 137',0.00,38936.05,835.00,38936.05,0.00,'2022-07-29 15:33:51'),(332,'21','238',1,'Sale Id shift 138',0.00,2161069.50,190.00,2161069.50,0.00,'2022-07-30 18:45:55'),(333,'21','238',2,'Sale Id shift 138',0.00,6635039.34,813.00,6635039.34,0.00,'2022-07-30 18:45:55'),(334,'21','238',3,'Sale Id shift 138',0.00,38911.00,835.00,38911.00,0.00,'2022-07-30 18:45:55'),(335,'21','238',1,'Sale Id shift 139',0.00,2790524.30,190.00,2790524.30,0.00,'2022-08-02 16:26:35'),(336,'21','238',2,'Sale Id shift 139',0.00,3126570.36,813.00,3126570.36,0.00,'2022-08-02 16:26:35'),(337,'21','238',3,'Sale Id shift 139',0.00,48663.80,835.00,48663.80,0.00,'2022-08-02 16:26:35'),(338,'21','238',1,'Sale Id shift 140',0.00,3015117.60,190.00,3015117.60,0.00,'2022-08-02 17:16:15'),(339,'21','238',2,'Sale Id shift 140',0.00,4557051.99,813.00,4557051.99,0.00,'2022-08-02 17:16:15'),(340,'21','238',3,'Sale Id shift 140',0.00,93628.55,835.00,93628.55,0.00,'2022-08-02 17:16:15'),(341,'21','238',1,'Sale Id shift 141',0.00,2868827.10,190.00,2868827.10,0.00,'2022-08-02 17:40:03'),(342,'21','238',2,'Sale Id shift 141',0.00,8127040.68,813.00,8127040.68,0.00,'2022-08-02 17:40:03'),(343,'21','238',3,'Sale Id shift 141',0.00,58174.45,835.00,58174.45,0.00,'2022-08-02 17:40:03'),(344,'21','238',1,'Sale Id shift 142',0.00,2857442.30,190.00,2857442.30,0.00,'2022-08-04 14:37:17'),(345,'21','238',2,'Sale Id shift 142',0.00,2814532.83,813.00,2814532.83,0.00,'2022-08-04 14:37:17'),(346,'21','238',3,'Sale Id shift 142',0.00,77045.45,835.00,77045.45,0.00,'2022-08-04 14:37:17'),(347,'21','238',1,'Sale Id shift 143',0.00,3964621.70,190.00,3964621.70,0.00,'2022-08-04 14:55:22'),(348,'21','238',2,'Sale Id shift 143',0.00,7479608.13,813.00,7479608.13,0.00,'2022-08-04 14:55:22'),(349,'21','238',3,'Sale Id shift 143',0.00,66340.75,835.00,66340.75,0.00,'2022-08-04 14:55:22'),(350,'21','238',1,'Sale Id shift 145',0.00,1713271.80,190.00,1713271.80,0.00,'2022-08-07 18:22:50'),(351,'21','238',2,'Sale Id shift 145',0.00,6122914.38,813.00,6122914.38,0.00,'2022-08-07 18:22:50'),(352,'21','238',3,'Sale Id shift 145',0.00,66766.60,835.00,66766.60,0.00,'2022-08-07 18:22:50'),(353,'21','238',2,'Sale Id shift 146',0.00,4462784.64,813.00,4462784.64,0.00,'2022-08-08 09:50:21'),(354,'21','238',3,'Sale Id shift 146',0.00,80318.65,835.00,80318.65,0.00,'2022-08-08 09:50:21'),(355,'21','238',1,'Sale Id shift 146',0.00,5583592.70,190.00,5583592.70,0.00,'2022-08-08 09:50:21'),(356,'21','238',1,'Sale Id shift 147',0.00,2867111.40,190.00,2867111.40,0.00,'2022-08-08 17:16:57'),(357,'21','238',2,'Sale Id shift 147',0.00,2556250.86,813.00,2556250.86,0.00,'2022-08-08 17:16:57'),(358,'21','238',3,'Sale Id shift 147',0.00,43111.05,835.00,43111.05,0.00,'2022-08-08 17:16:57'),(359,'21','238',1,'Sale Id shift 148',0.00,2855798.80,190.00,2855798.80,0.00,'2022-08-09 11:33:12'),(360,'21','238',2,'Sale Id shift 148',0.00,2599534.98,813.00,2599534.98,0.00,'2022-08-09 11:33:12'),(361,'21','238',3,'Sale Id shift 148',0.00,41424.35,835.00,41424.35,0.00,'2022-08-09 11:33:12'),(362,'21','238',2,'Sale Id shift 149',0.00,4359387.30,813.00,4359387.30,0.00,'2022-08-10 17:30:03'),(363,'21','238',3,'Sale Id shift 149',0.00,47903.95,835.00,47903.95,0.00,'2022-08-10 17:30:03'),(364,'21','238',1,'Sale Id shift 150',0.00,2868108.90,190.00,2868108.90,0.00,'2022-08-10 18:19:32'),(365,'21','238',2,'Sale Id shift 150',0.00,6592665.78,813.00,6592665.78,0.00,'2022-08-10 18:19:32'),(366,'21','238',3,'Sale Id shift 150',0.00,44689.20,835.00,44689.20,0.00,'2022-08-10 18:19:32'),(367,'21','238',2,'Sale Id shift 151',0.00,6094207.35,813.00,6094207.35,0.00,'2022-08-11 16:44:18'),(368,'21','238',3,'Sale Id shift 151',0.00,19864.65,835.00,19864.65,0.00,'2022-08-11 16:44:18'),(369,'21','238',1,'Sale Id shift 152',0.00,3630879.10,190.00,3630879.10,0.00,'2022-08-12 17:50:20'),(370,'21','238',2,'Sale Id shift 152',0.00,7205862.90,813.00,7205862.90,0.00,'2022-08-12 17:50:20'),(371,'21','238',3,'Sale Id shift 152',0.00,35495.85,835.00,35495.85,0.00,'2022-08-12 17:50:20'),(372,'21','238',3,'Sale Id shift 153',0.00,17134.20,835.00,17134.20,0.00,'2022-08-15 12:45:49'),(373,'21','238',2,'Sale Id shift 154',0.00,7896774.69,813.00,7896774.69,0.00,'2022-08-15 13:10:24'),(374,'21','238',3,'Sale Id shift 154',0.00,20961.00,850.00,20961.00,0.00,'2022-08-15 13:10:24'),(375,'21','238',1,'Sale Id shift 154',0.00,3846299.20,190.00,3846299.20,0.00,'2022-08-15 13:10:24'),(376,'21','238',1,'Sale Id shift 155',0.00,1131584.90,190.00,1131584.90,0.00,'2022-08-15 13:52:44'),(377,'21','238',2,'Sale Id shift 155',0.00,3755043.75,813.00,3755043.75,0.00,'2022-08-15 13:52:44'),(378,'21','238',3,'Sale Id shift 155',0.00,26469.00,850.00,26469.00,0.00,'2022-08-15 13:52:44'),(379,'21','238',1,'Sale Id shift 156',0.00,2658637.70,190.00,2658637.70,0.00,'2022-08-15 19:41:36'),(380,'21','238',2,'Sale Id shift 156',0.00,4170527.40,813.00,4170527.40,0.00,'2022-08-15 19:41:36'),(381,'21','238',3,'Sale Id shift 156',0.00,45900.00,850.00,45900.00,0.00,'2022-08-15 19:41:36'),(382,'21','238',2,'Sale Id shift 157',0.00,3901229.28,813.00,3901229.28,0.00,'2022-08-16 19:34:48'),(383,'21','238',3,'Sale Id shift 157',0.00,32997.00,850.00,32997.00,0.00,'2022-08-16 19:34:48'),(384,'21','238',1,'Sale Id shift 158',0.00,1466866.50,190.00,1466866.50,0.00,'2022-08-17 11:04:34'),(385,'21','238',2,'Sale Id shift 158',0.00,6653673.30,813.00,6653673.30,0.00,'2022-08-17 11:04:34'),(386,'21','238',3,'Sale Id shift 158',0.00,42134.50,850.00,42134.50,0.00,'2022-08-17 11:04:34'),(387,'21','238',1,'Sale Id shift 159',0.00,2605642.90,190.00,2605642.90,0.00,'2022-08-18 19:34:42'),(388,'21','238',2,'Sale Id shift 159',0.00,6531642.00,813.00,6531642.00,0.00,'2022-08-18 19:34:42'),(389,'21','238',3,'Sale Id shift 159',0.00,35326.00,850.00,35326.00,0.00,'2022-08-18 19:34:42'),(390,'21','238',1,'Sale Id shift 160',0.00,2708014.90,190.00,2708014.90,0.00,'2022-08-19 11:49:52'),(391,'21','238',2,'Sale Id shift 160',0.00,5652992.25,813.00,5652992.25,0.00,'2022-08-19 11:49:52'),(392,'21','238',3,'Sale Id shift 160',0.00,33325.00,860.00,33325.00,0.00,'2022-08-19 11:49:52'),(393,'21','238',1,'Sale Id shift 161',0.00,3275875.50,190.00,3275875.50,0.00,'2022-08-24 10:32:03'),(394,'21','238',2,'Sale Id shift 161',0.00,4604100.90,798.00,4604100.90,0.00,'2022-08-24 10:32:03'),(395,'21','238',3,'Sale Id shift 161',0.00,63089.60,860.00,63089.60,0.00,'2022-08-24 10:32:03'),(396,'21','238',1,'Sale Id shift 162',0.00,3395999.20,190.00,3395999.20,0.00,'2022-08-24 12:48:29'),(397,'21','238',2,'Sale Id shift 162',0.00,3907231.44,798.00,3907231.44,0.00,'2022-08-24 12:48:29'),(398,'21','238',3,'Sale Id shift 162',0.00,34726.80,860.00,34726.80,0.00,'2022-08-24 12:48:29'),(399,'21','238',1,'Sale Id shift 163',0.00,3186870.00,190.00,3186870.00,0.00,'2022-08-24 18:30:58'),(400,'21','238',2,'Sale Id shift 163',0.00,4598411.16,798.00,4598411.16,0.00,'2022-08-24 18:30:58'),(401,'21','238',3,'Sale Id shift 163',0.00,29222.80,860.00,29222.80,0.00,'2022-08-24 18:30:58'),(402,'21','238',1,'Sale Id shift 164',0.00,3134027.20,190.00,3134027.20,0.00,'2022-08-24 18:44:15'),(403,'21','238',2,'Sale Id shift 164',0.00,5797589.70,798.00,5797589.70,0.00,'2022-08-24 18:44:15'),(404,'21','238',3,'Sale Id shift 164',0.00,28818.60,860.00,28818.60,0.00,'2022-08-24 18:44:15'),(405,'21','238',1,'Sale Id shift 165',0.00,2842901.60,190.00,2842901.60,0.00,'2022-08-24 19:30:26'),(406,'21','238',2,'Sale Id shift 165',0.00,1977555.72,798.00,1977555.72,0.00,'2022-08-24 19:30:26'),(407,'21','238',3,'Sale Id shift 165',0.00,38158.20,860.00,38158.20,0.00,'2022-08-24 19:30:26'),(408,'21','238',1,'Sale Id shift 166',0.00,3061785.40,190.00,3061785.40,0.00,'2022-08-26 13:13:35'),(409,'21','238',2,'Sale Id shift 166',0.00,2409130.08,798.00,2409130.08,0.00,'2022-08-26 13:13:35'),(410,'21','238',3,'Sale Id shift 166',0.00,25585.00,860.00,25585.00,0.00,'2022-08-26 13:13:35'),(411,'21','238',2,'Sale Id shift 167',0.00,4818635.22,798.00,4818635.22,0.00,'2022-08-26 13:36:03'),(412,'21','238',3,'Sale Id shift 167',0.00,29162.60,860.00,29162.60,0.00,'2022-08-26 13:36:03'),(413,'21','238',1,'Sale Id shift 167',0.00,2511934.90,190.00,2511934.90,0.00,'2022-08-26 13:36:03'),(414,'21','238',1,'Sale Id shift 168',0.00,3022506.70,190.00,3022506.70,0.00,'2022-08-29 12:08:52'),(415,'21','238',2,'Sale Id shift 168',0.00,3591829.92,798.00,3591829.92,0.00,'2022-08-29 12:08:52'),(416,'21','238',3,'Sale Id shift 168',0.00,19212.40,860.00,19212.40,0.00,'2022-08-29 12:08:52'),(417,'21','238',1,'Sale Id shift 169',0.00,2216730.00,190.00,2216730.00,0.00,'2022-08-29 12:36:35'),(418,'21','238',2,'Sale Id shift 169',0.00,4391968.56,798.00,4391968.56,0.00,'2022-08-29 12:36:35'),(419,'21','238',3,'Sale Id shift 169',0.00,44152.40,860.00,44152.40,0.00,'2022-08-29 12:36:35'),(420,'21','238',1,'Sale Id shift 170',0.00,2781493.60,190.00,2781493.60,0.00,'2022-08-29 12:47:08'),(421,'21','238',2,'Sale Id shift 170',0.00,4268398.26,798.00,4268398.26,0.00,'2022-08-29 12:47:08'),(422,'21','238',3,'Sale Id shift 170',0.00,33101.40,860.00,33101.40,0.00,'2022-08-29 12:47:08'),(423,'21','238',1,'Sale Id shift 171',0.00,2731770.60,190.00,2731770.60,0.00,'2022-08-30 11:29:57'),(424,'21','238',2,'Sale Id shift 171',0.00,4822210.26,798.00,4822210.26,0.00,'2022-08-30 11:29:57'),(425,'21','238',3,'Sale Id shift 171',0.00,35681.40,860.00,35681.40,0.00,'2022-08-30 11:29:57'),(426,'21','238',1,'Sale Id shift 172',0.00,2820236.50,190.00,2820236.50,0.00,'2022-08-31 13:19:20'),(427,'21','238',2,'Sale Id shift 172',0.00,4275747.84,798.00,4275747.84,0.00,'2022-08-31 13:19:20'),(428,'21','238',3,'Sale Id shift 172',0.00,27004.00,860.00,27004.00,0.00,'2022-08-31 13:19:20'),(429,'21','238',1,'Sale Id shift 173',0.00,2814853.80,190.00,2814853.80,0.00,'2022-09-01 12:22:53'),(430,'21','238',2,'Sale Id shift 173',0.00,5207500.62,798.00,5207500.62,0.00,'2022-09-01 12:22:53'),(431,'21','238',3,'Sale Id shift 173',0.00,34013.00,860.00,34013.00,0.00,'2022-09-01 12:22:53'),(432,'21','238',1,'Sale Id shift 174',0.00,2684675.30,190.00,2684675.30,0.00,'2022-09-02 15:34:41'),(433,'21','238',2,'Sale Id shift 174',0.00,2978351.46,798.00,2978351.46,0.00,'2022-09-02 15:34:41'),(434,'21','238',3,'Sale Id shift 174',0.00,33428.20,860.00,33428.20,0.00,'2022-09-02 15:34:41'),(435,'21','238',1,'Sale Id shift 175',0.00,3385944.40,190.00,3385944.40,0.00,'2022-09-03 19:48:08'),(436,'21','238',2,'Sale Id shift 175',0.00,3994971.54,798.00,3994971.54,0.00,'2022-09-03 19:48:08'),(437,'21','238',3,'Sale Id shift 175',0.00,33256.20,860.00,33256.20,0.00,'2022-09-03 19:48:08'),(438,'21','238',1,'Sale Id shift 176',0.00,3247069.60,190.00,3247069.60,0.00,'2022-09-04 15:56:43'),(439,'21','238',2,'Sale Id shift 176',0.00,4473867.30,798.00,4473867.30,0.00,'2022-09-04 15:56:43'),(440,'21','238',3,'Sale Id shift 176',0.00,41770.20,860.00,41770.20,0.00,'2022-09-04 15:56:43'),(441,'21','238',2,'Sale Id shift 177',0.00,5821314.24,798.00,5821314.24,0.00,'2022-09-05 11:32:50'),(442,'21','238',3,'Sale Id shift 177',0.00,42527.00,860.00,42527.00,0.00,'2022-09-05 11:32:50'),(443,'21','238',1,'Sale Id shift 177',0.00,3676832.50,190.00,3676832.50,0.00,'2022-09-05 11:32:50'),(444,'21','238',1,'Sale Id shift 178',0.00,3433906.10,190.00,3433906.10,0.00,'2022-09-06 17:59:07'),(445,'21','238',2,'Sale Id shift 178',0.00,4933674.90,798.00,4933674.90,0.00,'2022-09-06 17:59:07'),(446,'21','238',3,'Sale Id shift 178',0.00,52580.40,860.00,52580.40,0.00,'2022-09-06 17:59:07'),(447,'21','238',1,'Sale Id shift 179',0.00,2282629.60,190.00,2282629.60,0.00,'2022-09-12 19:37:09'),(448,'21','238',2,'Sale Id shift 179',0.00,5522447.28,798.00,5522447.28,0.00,'2022-09-12 19:37:09'),(449,'21','238',3,'Sale Id shift 179',0.00,25972.00,860.00,25972.00,0.00,'2022-09-12 19:37:09'),(450,'21','238',2,'Sale Id shift 180',0.00,4932988.62,798.00,4932988.62,0.00,'2022-09-12 20:56:51'),(451,'21','238',3,'Sale Id shift 180',0.00,64379.60,860.00,64379.60,0.00,'2022-09-12 20:56:51'),(452,'21','238',1,'Sale Id shift 181',0.00,3160290.90,190.00,3160290.90,0.00,'2022-09-12 21:27:39'),(453,'21','238',2,'Sale Id shift 181',0.00,4238768.52,798.00,4238768.52,0.00,'2022-09-12 21:27:39'),(454,'21','238',3,'Sale Id shift 181',0.00,30641.80,860.00,30641.80,0.00,'2022-09-12 21:27:39'),(455,'21','238',1,'Sale Id shift 182',0.00,2842324.00,190.00,2842324.00,0.00,'2022-09-13 13:38:49'),(456,'21','238',2,'Sale Id shift 182',0.00,4481129.10,798.00,4481129.10,0.00,'2022-09-13 13:38:49'),(457,'21','238',3,'Sale Id shift 182',0.00,32043.60,860.00,32043.60,0.00,'2022-09-13 13:38:49'),(458,'21','238',2,'Sale Id shift 183',0.00,5046528.06,798.00,5046528.06,0.00,'2022-09-13 19:08:42'),(459,'21','238',3,'Sale Id shift 183',0.00,24243.40,860.00,24243.40,0.00,'2022-09-13 19:08:42'),(460,'21','238',1,'Sale Id shift 183',0.00,2974837.60,190.00,2974837.60,0.00,'2022-09-13 19:08:42'),(461,'21','238',1,'Sale Id shift 184',0.00,2881173.30,190.00,2881173.30,0.00,'2022-09-13 19:42:38'),(462,'21','238',2,'Sale Id shift 184',0.00,3966075.96,798.00,3966075.96,0.00,'2022-09-13 19:42:38'),(463,'21','238',3,'Sale Id shift 184',0.00,51299.00,860.00,51299.00,0.00,'2022-09-13 19:42:38'),(464,'21','238',2,'Sale Id shift 185',0.00,4092247.74,798.00,4092247.74,0.00,'2022-09-14 19:45:22'),(465,'21','238',3,'Sale Id shift 185',0.00,44900.60,860.00,44900.60,0.00,'2022-09-14 19:45:22'),(466,'21','238',1,'Sale Id shift 185',0.00,3053374.10,190.00,3053374.10,0.00,'2022-09-14 19:45:22'),(467,'21','238',3,'Sale Id shift 186',0.00,20459.40,860.00,20459.40,0.00,'2022-09-14 21:48:42'),(468,'21','238',1,'Sale Id shift 186',0.00,2801770.40,190.00,2801770.40,0.00,'2022-09-14 21:48:42'),(469,'21','238',1,'Sale Id shift 187',0.00,3086633.60,190.00,3086633.60,0.00,'2022-09-15 11:16:07'),(470,'21','238',3,'Sale Id shift 187',0.00,28319.80,860.00,28319.80,0.00,'2022-09-15 11:16:07'),(471,'21','238',1,'Sale Id shift 188',0.00,2733151.90,190.00,2733151.90,0.00,'2022-09-16 12:52:35'),(472,'21','238',3,'Sale Id shift 188',0.00,68198.00,860.00,68198.00,0.00,'2022-09-16 12:52:35'),(473,'21','238',1,'Sale Id shift 189',0.00,2415528.90,190.00,2415528.90,0.00,'2022-09-17 13:06:19'),(474,'21','238',3,'Sale Id shift 189',0.00,28792.80,860.00,28792.80,0.00,'2022-09-17 13:06:19'),(475,'21','238',1,'Sale Id shift 190',0.00,2548747.40,190.00,2548747.40,0.00,'2022-09-18 17:38:47'),(476,'21','238',2,'Sale Id shift 190',0.00,3411841.02,798.00,3411841.02,0.00,'2022-09-18 17:38:47'),(477,'21','238',3,'Sale Id shift 190',0.00,28526.20,860.00,28526.20,0.00,'2022-09-18 17:38:47'),(478,'21','238',1,'Sale Id shift 191',0.00,2499018.70,190.00,2499018.70,0.00,'2022-09-19 18:33:35'),(479,'21','238',2,'Sale Id shift 191',0.00,6261036.18,798.00,6261036.18,0.00,'2022-09-19 18:33:35'),(480,'21','238',3,'Sale Id shift 191',0.00,21603.20,860.00,21603.20,0.00,'2022-09-19 18:33:35'),(481,'21','238',1,'Sale Id shift 192',0.00,1880977.20,190.00,1880977.20,0.00,'2022-09-20 14:11:36'),(482,'21','238',2,'Sale Id shift 192',0.00,2253168.96,798.00,2253168.96,0.00,'2022-09-20 14:11:36'),(483,'21','238',3,'Sale Id shift 192',0.00,39921.20,860.00,39921.20,0.00,'2022-09-20 14:11:36'),(484,'21','238',1,'Sale Id shift 193',0.00,2323377.00,190.00,2323377.00,0.00,'2022-09-21 16:55:35'),(485,'21','238',2,'Sale Id shift 193',0.00,1632388.80,798.00,1632388.80,0.00,'2022-09-21 16:55:35'),(486,'21','238',3,'Sale Id shift 193',0.00,41925.00,860.00,41925.00,0.00,'2022-09-21 16:55:35'),(487,'21','238',1,'Sale Id shift 194',0.00,1428541.60,190.00,1428541.60,0.00,'2022-09-22 12:58:03'),(488,'21','238',1,'Sale Id shift 195',0.00,913872.25,185.00,913872.25,0.00,'2022-09-22 13:06:51'),(489,'21','238',2,'Sale Id shift 195',0.00,5282313.12,798.00,5282313.12,0.00,'2022-09-22 13:06:51'),(490,'21','238',3,'Sale Id shift 195',0.00,26255.80,860.00,26255.80,0.00,'2022-09-22 13:06:51'),(491,'21','238',1,'Sale Id shift 196',0.00,2418536.45,185.00,2418536.45,0.00,'2022-09-23 17:27:43'),(492,'21','238',2,'Sale Id shift 196',0.00,5135026.26,798.00,5135026.26,0.00,'2022-09-23 17:27:43'),(493,'21','238',3,'Sale Id shift 196',0.00,30968.60,860.00,30968.60,0.00,'2022-09-23 17:27:43'),(494,'21','238',1,'Sale Id shift 197',0.00,2931387.90,185.00,2931387.90,0.00,'2022-09-25 12:12:47'),(495,'21','238',3,'Sale Id shift 197',0.00,23073.80,860.00,23073.80,0.00,'2022-09-25 12:12:47'),(496,'21','238',1,'Sale Id shift 198',0.00,2143036.30,185.00,2143036.30,0.00,'2022-09-25 12:39:33'),(497,'21','238',3,'Sale Id shift 198',0.00,20003.60,860.00,20003.60,0.00,'2022-09-25 12:39:33'),(498,'21','238',1,'Sale Id shift 199',0.00,2824863.05,185.00,2824863.05,0.00,'2022-09-26 14:47:27'),(499,'21','238',3,'Sale Id shift 199',0.00,64173.20,860.00,64173.20,0.00,'2022-09-26 14:47:27'),(500,'21','238',1,'Sale Id shift 200',0.00,2642066.40,185.00,2642066.40,0.00,'2022-09-27 16:13:14'),(501,'21','238',2,'Sale Id shift 200',0.00,1371578.46,798.00,1371578.46,0.00,'2022-09-27 16:13:14'),(502,'21','238',3,'Sale Id shift 200',0.00,25507.60,860.00,25507.60,0.00,'2022-09-27 16:13:14'),(503,'21','238',2,'Sale Id shift 201',0.00,5801539.80,798.00,5801539.80,0.00,'2022-09-28 21:12:48'),(504,'21','238',3,'Sale Id shift 201',0.00,40471.60,860.00,40471.60,0.00,'2022-09-28 21:12:49'),(505,'21','238',1,'Sale Id shift 201',0.00,2368899.10,185.00,2368899.10,0.00,'2022-09-28 21:12:49'),(506,'21','238',1,'Sale Id shift 203',0.00,2696944.80,185.00,2696944.80,0.00,'2022-09-29 17:37:15'),(507,'21','238',2,'Sale Id shift 203',0.00,4817725.50,798.00,4817725.50,0.00,'2022-09-29 17:37:15'),(508,'21','238',3,'Sale Id shift 203',0.00,16443.20,860.00,16443.20,0.00,'2022-09-29 17:37:15'),(509,'21','238',1,'Sale Id shift 204',0.00,3124294.80,185.00,3124294.80,0.00,'2022-10-12 16:51:26'),(510,'21','238',3,'Sale Id shift 204',0.00,55556.00,860.00,55556.00,0.00,'2022-10-12 16:51:26'),(511,'21','238',1,'Sale Id shift 205',0.00,3741317.90,185.00,3741317.90,0.00,'2022-10-13 08:31:57'),(512,'21','238',3,'Sale Id shift 205',0.00,11979.80,860.00,11979.80,0.00,'2022-10-13 08:31:57'),(513,'21','238',1,'Sale Id shift 206',0.00,3692111.60,185.00,3692111.60,0.00,'2022-10-13 13:07:23'),(514,'21','238',3,'Sale Id shift 206',0.00,42380.80,860.00,42380.80,0.00,'2022-10-13 13:07:23'),(515,'21','238',1,'Sale Id shift 207',0.00,3751263.50,185.00,3751263.50,0.00,'2022-10-14 16:41:32'),(516,'21','238',3,'Sale Id shift 207',0.00,23632.80,860.00,23632.80,0.00,'2022-10-14 16:41:32'),(517,'21','238',1,'Sale Id shift 208',0.00,3453467.15,185.00,3453467.15,0.00,'2022-10-14 17:07:56'),(518,'21','238',3,'Sale Id shift 208',0.00,41090.80,860.00,41090.80,0.00,'2022-10-14 17:07:56'),(519,'21','238',1,'Sale Id shift 209',0.00,3319936.00,185.00,3319936.00,0.00,'2022-10-14 17:40:45'),(520,'21','238',3,'Sale Id shift 209',0.00,40291.00,860.00,40291.00,0.00,'2022-10-14 17:40:45'),(521,'21','238',1,'Sale Id shift 210',0.00,3169203.55,185.00,3169203.55,0.00,'2022-10-14 19:05:31'),(522,'21','238',2,'Sale Id shift 210',0.00,10541451.48,818.00,10541451.48,0.00,'2022-10-14 19:05:31'),(523,'21','238',3,'Sale Id shift 210',0.00,32284.40,860.00,32284.40,0.00,'2022-10-14 19:05:31'),(524,'21','238',1,'Sale Id shift 211',0.00,3630948.75,185.00,3630948.75,0.00,'2022-10-15 20:11:56'),(525,'21','238',2,'Sale Id shift 211',0.00,10140803.26,818.00,10140803.26,0.00,'2022-10-15 20:11:56'),(526,'21','238',3,'Sale Id shift 211',0.00,28483.20,860.00,28483.20,0.00,'2022-10-15 20:11:56'),(527,'21','238',1,'Sale Id shift 212',0.00,1877540.95,185.00,1877540.95,0.00,'2022-10-15 20:36:30'),(528,'21','238',2,'Sale Id shift 212',0.00,4804842.02,818.00,4804842.02,0.00,'2022-10-15 20:36:30'),(529,'21','238',3,'Sale Id shift 212',0.00,47076.40,860.00,47076.40,0.00,'2022-10-15 20:36:30'),(530,'21','238',2,'Sale Id shift 213',0.00,3477219.84,818.00,3477219.84,0.00,'2022-10-15 21:10:46'),(531,'21','238',3,'Sale Id shift 213',0.00,21259.20,860.00,21259.20,0.00,'2022-10-15 21:10:46'),(532,'21','238',1,'Sale Id shift 214',0.00,4551057.35,185.00,4551057.35,0.00,'2022-10-15 21:30:27'),(533,'21','238',2,'Sale Id shift 214',0.00,40900.00,818.00,40900.00,0.00,'2022-10-15 21:30:27'),(534,'21','238',3,'Sale Id shift 214',0.00,43412.80,860.00,43412.80,0.00,'2022-10-15 21:30:27'),(535,'21','238',1,'Sale Id shift 215',0.00,2775989.75,185.00,2775989.75,0.00,'2022-10-16 17:51:07'),(536,'21','238',2,'Sale Id shift 215',0.00,506358.36,818.00,506358.36,0.00,'2022-10-16 17:51:07'),(537,'21','238',3,'Sale Id shift 215',0.00,31742.60,860.00,31742.60,0.00,'2022-10-16 17:51:07'),(538,'21','238',1,'Sale Id shift 216',0.00,6625062.75,185.00,6625062.75,0.00,'2022-10-16 18:06:45'),(539,'21','238',2,'Sale Id shift 216',0.00,24540.00,818.00,24540.00,0.00,'2022-10-16 18:06:45'),(540,'21','238',3,'Sale Id shift 216',0.00,24596.00,860.00,24596.00,0.00,'2022-10-16 18:06:45'),(541,'21','238',1,'Sale Id shift 217',0.00,5020999.90,185.00,5020999.90,0.00,'2022-10-16 19:20:14'),(542,'21','238',2,'Sale Id shift 217',0.00,32531.86,818.00,32531.86,0.00,'2022-10-16 19:20:14'),(543,'21','238',3,'Sale Id shift 217',0.00,31983.40,860.00,31983.40,0.00,'2022-10-16 19:20:14'),(544,'21','238',1,'Sale Id shift 218',0.00,4725712.15,185.00,4725712.15,0.00,'2022-10-16 19:49:27'),(545,'21','238',2,'Sale Id shift 218',0.00,332909.64,818.00,332909.64,0.00,'2022-10-16 19:49:27'),(546,'21','238',3,'Sale Id shift 218',0.00,26281.60,860.00,26281.60,0.00,'2022-10-16 19:49:27'),(547,'21','238',1,'Sale Id shift 219',0.00,834222.35,185.00,834222.35,0.00,'2022-10-17 21:20:06'),(548,'21','238',3,'Sale Id shift 219',0.00,25722.60,860.00,25722.60,0.00,'2022-10-17 21:20:06'),(549,'21','238',3,'Sale Id shift 220',0.00,43430.00,860.00,43430.00,0.00,'2022-10-17 21:49:56'),(550,'21','238',1,'Sale Id shift 220',0.00,2624865.10,185.00,2624865.10,0.00,'2022-10-17 21:49:56'),(551,'21','238',1,'Sale Id shift 221',0.00,5138482.30,185.00,5138482.30,0.00,'2022-10-17 22:14:23'),(552,'21','238',3,'Sale Id shift 221',0.00,38803.20,860.00,38803.20,0.00,'2022-10-17 22:14:23'),(553,'21','238',2,'Sale Id shift 222',0.00,3993427.44,828.00,3993427.44,0.00,'2022-10-18 22:37:58'),(554,'21','238',3,'Sale Id shift 222',0.00,35277.20,860.00,35277.20,0.00,'2022-10-18 22:37:58'),(555,'21','238',1,'Sale Id shift 222',0.00,543050.85,185.00,543050.85,0.00,'2022-10-18 22:37:58'),(556,'21','238',1,'Sale Id shift 223',0.00,1640071.25,185.00,1640071.25,0.00,'2022-10-20 19:07:13'),(557,'21','238',2,'Sale Id shift 223',0.00,5873550.48,828.00,5873550.48,0.00,'2022-10-20 19:07:13'),(558,'21','238',3,'Sale Id shift 223',0.00,57645.80,860.00,57645.80,0.00,'2022-10-20 19:07:13'),(559,'21','238',1,'Sale Id shift 224',0.00,1104881.05,185.00,1104881.05,0.00,'2022-10-20 19:53:45'),(560,'21','238',2,'Sale Id shift 224',0.00,6209677.08,828.00,6209677.08,0.00,'2022-10-20 19:53:45'),(561,'21','238',3,'Sale Id shift 224',0.00,48056.80,860.00,48056.80,0.00,'2022-10-20 19:53:45'),(562,'21','238',1,'Sale Id shift 225',0.00,2176219.75,185.00,2176219.75,0.00,'2022-10-24 16:37:24'),(563,'21','238',2,'Sale Id shift 225',0.00,1993807.44,828.00,1993807.44,0.00,'2022-10-24 16:37:24'),(564,'21','238',3,'Sale Id shift 225',0.00,25946.20,860.00,25946.20,0.00,'2022-10-24 16:37:24'),(565,'21','238',1,'Sale Id shift 226',0.00,659521.30,185.00,659521.30,0.00,'2022-10-24 16:57:28'),(566,'21','238',2,'Sale Id shift 226',0.00,1596036.24,828.00,1596036.24,0.00,'2022-10-24 16:57:28'),(567,'21','238',3,'Sale Id shift 226',0.00,31708.20,860.00,31708.20,0.00,'2022-10-24 16:57:28'),(568,'21','238',2,'Sale Id shift 227',0.00,6277026.60,828.00,6277026.60,0.00,'2022-10-24 17:26:36'),(569,'21','238',3,'Sale Id shift 227',0.00,13011.80,860.00,13011.80,0.00,'2022-10-24 17:26:36'),(570,'21','238',1,'Sale Id shift 228',0.00,2657121.50,190.00,2657121.50,0.00,'2022-10-24 17:46:59'),(571,'21','238',2,'Sale Id shift 228',0.00,4071963.24,828.00,4071963.24,0.00,'2022-10-24 17:46:59'),(572,'21','238',3,'Sale Id shift 228',0.00,27760.80,860.00,27760.80,0.00,'2022-10-24 17:46:59'),(573,'21','238',2,'Sale Id shift 229',0.00,4715857.44,828.00,4715857.44,0.00,'2022-10-27 09:28:01'),(574,'21','238',3,'Sale Id shift 229',0.00,19788.60,860.00,19788.60,0.00,'2022-10-27 09:28:01'),(575,'21','238',1,'Sale Id shift 230',0.00,3115620.00,190.00,3115620.00,0.00,'2022-10-27 09:58:38'),(576,'21','238',2,'Sale Id shift 230',0.00,1987564.32,828.00,1987564.32,0.00,'2022-10-27 09:58:38'),(577,'21','238',3,'Sale Id shift 230',0.00,30426.80,860.00,30426.80,0.00,'2022-10-27 09:58:38'),(578,'21','238',1,'Sale Id shift 231',0.00,2584467.40,190.00,2584467.40,0.00,'2022-10-31 17:12:21'),(579,'21','238',2,'Sale Id shift 231',0.00,9202135.32,828.00,9202135.32,0.00,'2022-10-31 17:12:21'),(580,'21','238',3,'Sale Id shift 231',0.00,25051.80,860.00,25051.80,0.00,'2022-10-31 17:12:21'),(581,'21','238',2,'Sale Id shift 232',0.00,1984782.24,828.00,1984782.24,0.00,'2022-10-31 17:37:31'),(582,'21','238',3,'Sale Id shift 232',0.00,49166.20,860.00,49166.20,0.00,'2022-10-31 17:37:31'),(583,'21','238',1,'Sale Id shift 232',0.00,2797100.20,190.00,2797100.20,0.00,'2022-10-31 17:37:31'),(584,'21','238',1,'Sale Id shift 233',0.00,2812545.30,190.00,2812545.30,0.00,'2022-11-01 12:19:31'),(585,'21','238',2,'Sale Id shift 233',0.00,16535.16,828.00,16535.16,0.00,'2022-11-01 12:19:31'),(586,'21','238',3,'Sale Id shift 233',0.00,15222.00,860.00,15222.00,0.00,'2022-11-01 12:19:31'),(587,'21','238',2,'Sale Id shift 234',0.00,8304.84,828.00,8304.84,0.00,'2022-11-01 12:33:09'),(588,'21','238',3,'Sale Id shift 234',0.00,39594.40,860.00,39594.40,0.00,'2022-11-01 12:33:09'),(589,'21','238',1,'Sale Id shift 235',0.00,2030746.60,190.00,2030746.60,0.00,'2022-11-02 12:51:39'),(590,'21','238',2,'Sale Id shift 235',0.00,60294.96,828.00,60294.96,0.00,'2022-11-02 12:51:39'),(591,'21','238',3,'Sale Id shift 235',0.00,31923.20,860.00,31923.20,0.00,'2022-11-02 12:51:39'),(592,'21','238',1,'Sale Id shift 236',0.00,815738.40,190.00,815738.40,0.00,'2022-11-02 13:24:44'),(593,'21','238',2,'Sale Id shift 236',0.00,2402201.88,828.00,2402201.88,0.00,'2022-11-02 13:24:44'),(594,'21','238',3,'Sale Id shift 236',0.00,39981.40,860.00,39981.40,0.00,'2022-11-02 13:24:44'),(595,'21','238',1,'Sale Id shift 237',0.00,2119056.70,190.00,2119056.70,0.00,'2022-11-02 14:54:23'),(596,'21','238',2,'Sale Id shift 237',0.00,4643332.92,828.00,4643332.92,0.00,'2022-11-02 14:54:23'),(597,'21','238',3,'Sale Id shift 237',0.00,32628.40,860.00,32628.40,0.00,'2022-11-02 14:54:23'),(598,'21','238',1,'Sale Id shift 238',0.00,718815.60,190.00,718815.60,0.00,'2022-11-03 13:44:41'),(599,'21','238',2,'Sale Id shift 238',0.00,5553246.96,828.00,5553246.96,0.00,'2022-11-03 13:44:41'),(600,'21','238',3,'Sale Id shift 238',0.00,21577.40,860.00,21577.40,0.00,'2022-11-03 13:44:41'),(601,'21','238',1,'Sale Id shift 239',0.00,2645026.10,190.00,2645026.10,0.00,'2022-11-04 15:13:43'),(602,'21','238',3,'Sale Id shift 239',0.00,30504.20,860.00,30504.20,0.00,'2022-11-04 15:13:43');
/*!40000 ALTER TABLE `inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ledgers`
--

DROP TABLE IF EXISTS `ledgers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ledgers` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` int NOT NULL AUTO_INCREMENT,
  `ledgertype` varchar(10) NOT NULL,
  `accounttype` varchar(50) NOT NULL,
  `accountid` varchar(50) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `details` varchar(1000) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `accounttype` (`accounttype`,`accountid`,`credit`,`debit`,`thedate`),
  KEY `cooperative` (`company_id`),
  KEY `depot_id` (`station_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=1851 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ledgers`
--

LOCK TABLES `ledgers` WRITE;
/*!40000 ALTER TABLE `ledgers` DISABLE KEYS */;
INSERT INTO `ledgers` VALUES ('21','238',1,'','20','2',4705038.58,0.00,'Sales from shift 1 on 2022-03-30 14:07:25 ','2022-03-30 14:07:25','',''),('21','238',2,'','6.1','3',0.00,4705038.58,'Sales from shift 1 on 2022-03-30 14:07:25 ','2022-03-30 14:07:25','',''),('21','238',3,'','20','2',0.00,0.00,'Sales from shift 2 on 2022-03-31 11:58:32 ','2022-03-31 11:58:32','',''),('21','238',4,'','6.1','3',0.00,0.00,'Sales from shift 2 on 2022-03-31 11:58:32 ','2022-03-31 11:58:32','',''),('21','238',5,'','24','5',0.00,2475000.00,'Purchase Id 1 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-03-31 12:38:55','',''),('21','238',6,'','supplier','1',2475000.00,0.00,'Purchase Id 1 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-03-31 12:38:55','',''),('21','238',7,'','20','2',11386251.60,0.00,'Sales from shift 3 on 2022-03-31 13:55:47 ','2022-03-31 13:55:47','',''),('21','238',8,'','6.1','3',0.00,11386251.60,'Sales from shift 3 on 2022-03-31 13:55:47 ','2022-03-31 13:55:47','',''),('21','238',9,'','6.1','3',7900.00,0.00,'Payment Id 40 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:53:19','',''),('21','238',10,'','supplier','1',0.00,7900.00,'Payment Id 40 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:53:19','',''),('21','238',11,'','2','13',1089900.00,0.00,'Payment Id 39 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:53:19','',''),('21','238',12,'','supplier','1',0.00,1089900.00,'Payment Id 39 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:53:19','',''),('21','238',13,'','6.1','3',14000.00,0.00,'Payment Id 38 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:53:19','',''),('21','238',14,'','supplier','1',0.00,14000.00,'Payment Id 38 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:53:19','',''),('21','238',15,'','6.1','3',104700.00,0.00,'Payment Id 37 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:53:19','',''),('21','238',16,'','supplier','1',0.00,104700.00,'Payment Id 37 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:53:19','',''),('21','238',17,'','6.1','3',30000.00,0.00,'Payment Id 36 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:53:19','',''),('21','238',18,'','supplier','1',0.00,30000.00,'Payment Id 36 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:53:19','',''),('21','238',19,'','6.1','3',34900.00,0.00,'Payment Id 35 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:53:19','',''),('21','238',20,'','supplier','1',0.00,34900.00,'Payment Id 35 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:53:19','',''),('21','238',21,'','6.1','3',342276.67,0.00,'Payment Id 34 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:53:19','',''),('21','238',22,'','supplier','1',0.00,342276.67,'Payment Id 34 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:53:19','',''),('21','238',23,'','6.1','3',20000.00,0.00,'Payment Id 33 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:53:19','',''),('21','238',24,'','supplier','1',0.00,20000.00,'Payment Id 33 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:53:19','',''),('21','238',25,'','6.1','3',1200.00,0.00,'Payment Id 32 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:53:19','',''),('21','238',26,'','supplier','1',0.00,1200.00,'Payment Id 32 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:53:19','',''),('21','238',27,'','6.1','3',73350.00,0.00,'Payment Id 31 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:53:19','',''),('21','238',28,'','supplier','1',0.00,73350.00,'Payment Id 31 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:53:19','',''),('21','238',29,'','6.1','3',13960.00,0.00,'Payment Id 30 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:03','',''),('21','238',30,'','supplier','1',0.00,13960.00,'Payment Id 30 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:03','',''),('21','238',31,'','6.1','3',95370.00,0.00,'Payment Id 29 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:03','',''),('21','238',32,'','supplier','1',0.00,95370.00,'Payment Id 29 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:03','',''),('21','238',33,'','6.1','3',53700.00,0.00,'Payment Id 28 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:03','',''),('21','238',34,'','supplier','1',0.00,53700.00,'Payment Id 28 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:03','',''),('21','238',35,'','6.1','3',508600.00,0.00,'Payment Id 27 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:03','',''),('21','238',36,'','supplier','1',0.00,508600.00,'Payment Id 27 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:03','',''),('21','238',37,'','6.1','3',181480.00,0.00,'Payment Id 26 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:03','',''),('21','238',38,'','supplier','1',0.00,181480.00,'Payment Id 26 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:03','',''),('21','238',39,'','6.1','3',83760.00,0.00,'Payment Id 25 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:03','',''),('21','238',40,'','supplier','1',0.00,83760.00,'Payment Id 25 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:03','',''),('21','238',41,'','6.1','3',11000.00,0.00,'Payment Id 24 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:03','',''),('21','238',42,'','supplier','1',0.00,11000.00,'Payment Id 24 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:03','',''),('21','238',43,'','6.1','3',1792120.00,0.00,'Payment Id 23 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:03','',''),('21','238',44,'','supplier','1',0.00,1792120.00,'Payment Id 23 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:03','',''),('21','238',45,'','2','27',4084000.00,0.00,'Payment Id 22 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:03','',''),('21','238',46,'','supplier','1',0.00,4084000.00,'Payment Id 22 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:03','',''),('21','238',47,'','2','27',774870.00,0.00,'Payment Id 21 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:03','',''),('21','238',48,'','supplier','1',0.00,774870.00,'Payment Id 21 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:03','',''),('21','238',49,'','2','15',1688325.00,0.00,'Payment Id 20 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:25','',''),('21','238',50,'','supplier','1',0.00,1688325.00,'Payment Id 20 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:25','',''),('21','238',51,'','6.1','3',500000.00,0.00,'Payment Id 19 for invoice:1, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:25','',''),('21','238',52,'','supplier','1',0.00,500000.00,'Payment Id 19 for invoice:1, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:25','',''),('21','238',53,'','6.1','3',14000.00,0.00,'Payment Id 18 for invoice:1, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:25','',''),('21','238',54,'','supplier','1',0.00,14000.00,'Payment Id 18 for invoice:1, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:25','',''),('21','238',55,'','6.1','3',79000.00,0.00,'Payment Id 17 for invoice:1, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:25','',''),('21','238',56,'','supplier','1',0.00,79000.00,'Payment Id 17 for invoice:1, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:25','',''),('21','238',57,'','6.1','3',10000.00,0.00,'Payment Id 16 for invoice:1, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:25','',''),('21','238',58,'','supplier','1',0.00,10000.00,'Payment Id 16 for invoice:1, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:25','',''),('21','238',59,'','6.1','3',20000.00,0.00,'Payment Id 15 for invoice:1, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:25','',''),('21','238',60,'','supplier','1',0.00,20000.00,'Payment Id 15 for invoice:1, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:25','',''),('21','238',61,'','6.1','3',10000.00,0.00,'Payment Id 14 for invoice:1, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:25','',''),('21','238',62,'','supplier','1',0.00,10000.00,'Payment Id 14 for invoice:1, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:25','',''),('21','238',63,'','6.1','3',6000.00,0.00,'Payment Id 13 for invoice:1, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:25','',''),('21','238',64,'','supplier','1',0.00,6000.00,'Payment Id 13 for invoice:1, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:25','',''),('21','238',65,'','6.1','3',139640.00,0.00,'Payment Id 12 for invoice:1, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:25','',''),('21','238',66,'','supplier','1',0.00,139640.00,'Payment Id 12 for invoice:1, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:25','',''),('21','238',67,'','6.1','3',273480.00,0.00,'Payment Id 11 for invoice:1, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:25','',''),('21','238',68,'','supplier','1',0.00,273480.00,'Payment Id 11 for invoice:1, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:25','',''),('21','238',69,'','6.1','3',335020.00,0.00,'Payment Id 10 for invoice:1, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:59','',''),('21','238',70,'','supplier','1',0.00,335020.00,'Payment Id 10 for invoice:1, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:59','',''),('21','238',71,'','6.1','3',1200.00,0.00,'Payment Id 9 for invoice:1, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:59','',''),('21','238',72,'','supplier','1',0.00,1200.00,'Payment Id 9 for invoice:1, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:59','',''),('21','238',73,'','6.1','3',104700.00,0.00,'Payment Id 8 for invoice:1, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:59','',''),('21','238',74,'','supplier','1',0.00,104700.00,'Payment Id 8 for invoice:1, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:59','',''),('21','238',75,'','6.1','3',5000.00,0.00,'Payment Id 7 for invoice:1, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:59','',''),('21','238',76,'','supplier','1',0.00,5000.00,'Payment Id 7 for invoice:1, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:59','',''),('21','238',77,'','6.1','3',69800.00,0.00,'Payment Id 6 for invoice:1, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:59','',''),('21','238',78,'','supplier','1',0.00,69800.00,'Payment Id 6 for invoice:1, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:59','',''),('21','238',79,'','6.1','3',34900.00,0.00,'Payment Id 5 for invoice:1, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:59','',''),('21','238',80,'','supplier','1',0.00,34900.00,'Payment Id 5 for invoice:1, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:59','',''),('21','238',81,'','6.1','3',254300.00,0.00,'Payment Id 4 for invoice:1, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:59','',''),('21','238',82,'','supplier','1',0.00,254300.00,'Payment Id 4 for invoice:1, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:59','',''),('21','238',83,'','2','27',1627660.00,0.00,'Payment Id 3 for invoice:1, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:59','',''),('21','238',84,'','supplier','1',0.00,1627660.00,'Payment Id 3 for invoice:1, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:59','',''),('21','238',85,'','2','13',783500.00,0.00,'Payment Id 2 for invoice:1, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:59','',''),('21','238',86,'','supplier','1',0.00,783500.00,'Payment Id 2 for invoice:1, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:59','',''),('21','238',87,'','2','15',436840.00,0.00,'Payment Id 1 for invoice:1, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:59','',''),('21','238',88,'','supplier','1',0.00,436840.00,'Payment Id 1 for invoice:1, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-31 14:54:59','',''),('21','238',89,'','20','2',10250686.25,0.00,'Sales from shift 4 on 2022-04-01 12:40:17 ','2022-04-01 12:40:17','',''),('21','238',90,'','6.1','3',0.00,10250686.25,'Sales from shift 4 on 2022-04-01 12:40:17 ','2022-04-01 12:40:17','',''),('21','238',91,'','20','2',3623868.86,0.00,'Sales from shift 5 on 2022-04-02 11:35:39 ','2022-04-02 11:35:39','',''),('21','238',92,'','6.1','3',0.00,3623868.86,'Sales from shift 5 on 2022-04-02 11:35:39 ','2022-04-02 11:35:39','',''),('21','238',93,'','24','5',0.00,2277000.00,'Purchase Id 2 for 13,800.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-02 11:42:56','',''),('21','238',94,'','supplier','1',2277000.00,0.00,'Purchase Id 2 for 13,800.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-02 11:42:56','',''),('21','238',95,'','6.1','3',28000.00,0.00,'Payment Id 80 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:31:14','',''),('21','238',96,'','supplier','1',0.00,28000.00,'Payment Id 80 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:31:14','',''),('21','238',97,'','6.1','3',132620.00,0.00,'Payment Id 79 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:31:14','',''),('21','238',98,'','supplier','1',0.00,132620.00,'Payment Id 79 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:31:14','',''),('21','238',99,'','6.1','3',104700.00,0.00,'Payment Id 78 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:31:14','',''),('21','238',100,'','supplier','1',0.00,104700.00,'Payment Id 78 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:31:14','',''),('21','238',101,'','2','13',855920.00,0.00,'Payment Id 77 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:31:14','',''),('21','238',102,'','supplier','1',0.00,855920.00,'Payment Id 77 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:31:14','',''),('21','238',103,'','6.1','3',34900.00,0.00,'Payment Id 76 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:31:15','',''),('21','238',104,'','supplier','1',0.00,34900.00,'Payment Id 76 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:31:15','',''),('21','238',105,'','6.1','3',980.00,0.00,'Payment Id 75 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:31:15','',''),('21','238',106,'','supplier','1',0.00,980.00,'Payment Id 75 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:31:15','',''),('21','238',107,'','6.1','3',40000.00,0.00,'Payment Id 74 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:31:15','',''),('21','238',108,'','supplier','1',0.00,40000.00,'Payment Id 74 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:31:15','',''),('21','238',109,'','6.1','3',69800.00,0.00,'Payment Id 73 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:31:15','',''),('21','238',110,'','supplier','1',0.00,69800.00,'Payment Id 73 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:31:15','',''),('21','238',111,'','6.1','3',69800.00,0.00,'Payment Id 72 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:31:15','',''),('21','238',112,'','supplier','1',0.00,69800.00,'Payment Id 72 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:31:15','',''),('21','238',113,'','6.1','3',349000.00,0.00,'Payment Id 71 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:31:15','',''),('21','238',114,'','supplier','1',0.00,349000.00,'Payment Id 71 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:31:15','',''),('21','238',115,'','6.1','3',20940.00,0.00,'Payment Id 70 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:31:46','',''),('21','238',116,'','supplier','1',0.00,20940.00,'Payment Id 70 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:31:46','',''),('21','238',117,'','6.1','3',1750.00,0.00,'Payment Id 69 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:31:46','',''),('21','238',118,'','supplier','1',0.00,1750.00,'Payment Id 69 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:31:46','',''),('21','238',119,'','2','27',645825.00,0.00,'Payment Id 65 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:31:46','',''),('21','238',120,'','supplier','1',0.00,645825.00,'Payment Id 65 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:31:46','',''),('21','238',121,'','2','15',832920.00,0.00,'Payment Id 64 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:31:46','',''),('21','238',122,'','supplier','1',0.00,832920.00,'Payment Id 64 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:31:46','',''),('21','238',123,'','2','27',1760875.00,0.00,'Payment Id 63 for invoice:4, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:31:46','',''),('21','238',124,'','supplier','1',0.00,1760875.00,'Payment Id 63 for invoice:4, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:31:46','',''),('21','238',125,'','6.1','3',468700.00,0.00,'Payment Id 62 for invoice:4, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:31:46','',''),('21','238',126,'','supplier','1',0.00,468700.00,'Payment Id 62 for invoice:4, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:31:46','',''),('21','238',127,'','6.1','3',34900.00,0.00,'Payment Id 61 for invoice:4, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:31:46','',''),('21','238',128,'','supplier','1',0.00,34900.00,'Payment Id 61 for invoice:4, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:31:46','',''),('21','238',129,'','6.1','3',2100.00,0.00,'Payment Id 60 for invoice:4, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:31:46','',''),('21','238',130,'','supplier','1',0.00,2100.00,'Payment Id 60 for invoice:4, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:31:46','',''),('21','238',131,'','6.1','3',13960.00,0.00,'Payment Id 59 for invoice:4, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:31:46','',''),('21','238',132,'','supplier','1',0.00,13960.00,'Payment Id 59 for invoice:4, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:31:46','',''),('21','238',133,'','6.1','3',7000.00,0.00,'Payment Id 58 for invoice:4, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:31:46','',''),('21','238',134,'','supplier','1',0.00,7000.00,'Payment Id 58 for invoice:4, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:31:46','',''),('21','238',135,'','6.1','3',4500.00,0.00,'Payment Id 57 for invoice:4, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:32:10','',''),('21','238',136,'','supplier','1',0.00,4500.00,'Payment Id 57 for invoice:4, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:32:10','',''),('21','238',137,'','6.1','3',35300.00,0.00,'Payment Id 56 for invoice:4, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:32:10','',''),('21','238',138,'','supplier','1',0.00,35300.00,'Payment Id 56 for invoice:4, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:32:10','',''),('21','238',139,'','6.1','3',533272.00,0.00,'Payment Id 55 for invoice:4, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:32:10','',''),('21','238',140,'','supplier','1',0.00,533272.00,'Payment Id 55 for invoice:4, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:32:10','',''),('21','238',141,'','6.1','3',244300.00,0.00,'Payment Id 54 for invoice:4, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:32:10','',''),('21','238',142,'','supplier','1',0.00,244300.00,'Payment Id 54 for invoice:4, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:32:10','',''),('21','238',143,'','6.1','3',488600.00,0.00,'Payment Id 53 for invoice:4, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:32:10','',''),('21','238',144,'','supplier','1',0.00,488600.00,'Payment Id 53 for invoice:4, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:32:10','',''),('21','238',145,'','6.1','3',4000.00,0.00,'Payment Id 52 for invoice:4, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:32:10','',''),('21','238',146,'','supplier','1',0.00,4000.00,'Payment Id 52 for invoice:4, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:32:10','',''),('21','238',147,'','6.1','3',427100.00,0.00,'Payment Id 51 for invoice:4, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:32:10','',''),('21','238',148,'','supplier','1',0.00,427100.00,'Payment Id 51 for invoice:4, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:32:10','',''),('21','238',149,'','6.1','3',887500.00,0.00,'Payment Id 50 for invoice:4, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:32:10','',''),('21','238',150,'','supplier','1',0.00,887500.00,'Payment Id 50 for invoice:4, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:32:10','',''),('21','238',151,'','6.1','3',349000.00,0.00,'Payment Id 49 for invoice:4, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:32:10','',''),('21','238',152,'','supplier','1',0.00,349000.00,'Payment Id 49 for invoice:4, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:32:10','',''),('21','238',153,'','6.1','3',26000.00,0.00,'Payment Id 48 for invoice:4, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:32:10','',''),('21','238',154,'','supplier','1',0.00,26000.00,'Payment Id 48 for invoice:4, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:32:10','',''),('21','238',155,'','6.1','3',17000.00,0.00,'Payment Id 47 for invoice:4, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:33:06','',''),('21','238',156,'','supplier','1',0.00,17000.00,'Payment Id 47 for invoice:4, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:33:06','',''),('21','238',157,'','6.1','3',314100.00,0.00,'Payment Id 46 for invoice:4, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:33:06','',''),('21','238',158,'','supplier','1',0.00,314100.00,'Payment Id 46 for invoice:4, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:33:06','',''),('21','238',159,'','6.1','3',151320.00,0.00,'Payment Id 45 for invoice:4, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:33:06','',''),('21','238',160,'','supplier','1',0.00,151320.00,'Payment Id 45 for invoice:4, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:33:06','',''),('21','238',161,'','2','13',1315400.00,0.00,'Payment Id 44 for invoice:4, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:33:06','',''),('21','238',162,'','supplier','1',0.00,1315400.00,'Payment Id 44 for invoice:4, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:33:06','',''),('21','238',163,'','2','27',1817060.00,0.00,'Payment Id 43 for invoice:4, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:33:06','',''),('21','238',164,'','supplier','1',0.00,1817060.00,'Payment Id 43 for invoice:4, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:33:06','',''),('21','238',165,'','2','15',1348700.00,0.00,'Payment Id 42 for invoice:4, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:33:06','',''),('21','238',166,'','supplier','1',0.00,1348700.00,'Payment Id 42 for invoice:4, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:33:06','',''),('21','238',167,'','2','27',380840.00,0.00,'Payment Id 41 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:33:06','',''),('21','238',168,'','supplier','1',0.00,380840.00,'Payment Id 41 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-03 08:33:06','',''),('21','238',169,'','20','2',6129726.32,0.00,'Sales from shift 6 on 2022-04-03 11:11:44 ','2022-04-03 11:11:44','',''),('21','238',170,'','6.1','3',0.00,6129726.32,'Sales from shift 6 on 2022-04-03 11:11:44 ','2022-04-03 11:11:44','',''),('21','238',171,'','24','5',0.00,2574000.00,'Purchase Id 3 for 15,600.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-03 11:17:46','',''),('21','238',172,'','supplier','1',2574000.00,0.00,'Purchase Id 3 for 15,600.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-03 11:17:46','',''),('21','238',173,'','20','2',7066397.37,0.00,'Sales from shift 7 on 2022-04-04 10:31:11 ','2022-04-04 10:31:11','',''),('21','238',174,'','6.1','3',0.00,7066397.37,'Sales from shift 7 on 2022-04-04 10:31:11 ','2022-04-04 10:31:11','',''),('21','238',175,'','2','27',3693730.00,0.00,'Payment Id 107 for invoice:7, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:29:57','',''),('21','238',176,'','supplier','1',0.00,3693730.00,'Payment Id 107 for invoice:7, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:29:57','',''),('21','238',177,'','2','27',96100.00,0.00,'Payment Id 106 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:29:57','',''),('21','238',178,'','supplier','1',0.00,96100.00,'Payment Id 106 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:29:57','',''),('21','238',179,'','2','27',436715.00,0.00,'Payment Id 105 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:29:57','',''),('21','238',180,'','supplier','1',0.00,436715.00,'Payment Id 105 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:29:57','',''),('21','238',181,'','6.1','3',34900.00,0.00,'Payment Id 104 for invoice:7, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:29:57','',''),('21','238',182,'','supplier','1',0.00,34900.00,'Payment Id 104 for invoice:7, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:29:57','',''),('21','238',183,'','6.1','3',104700.00,0.00,'Payment Id 103 for invoice:7, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:29:57','',''),('21','238',184,'','supplier','1',0.00,104700.00,'Payment Id 103 for invoice:7, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:29:57','',''),('21','238',185,'','6.1','3',300.00,0.00,'Payment Id 102 for invoice:7, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:29:57','',''),('21','238',186,'','supplier','1',0.00,300.00,'Payment Id 102 for invoice:7, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:29:57','',''),('21','238',187,'','6.1','3',300000.00,0.00,'Payment Id 101 for invoice:7, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:29:57','',''),('21','238',188,'','supplier','1',0.00,300000.00,'Payment Id 101 for invoice:7, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:29:57','',''),('21','238',189,'','6.1','3',83760.00,0.00,'Payment Id 100 for invoice:7, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:29:57','',''),('21','238',190,'','supplier','1',0.00,83760.00,'Payment Id 100 for invoice:7, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:29:57','',''),('21','238',191,'','6.1','3',383900.00,0.00,'Payment Id 99 for invoice:7, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:29:57','',''),('21','238',192,'','supplier','1',0.00,383900.00,'Payment Id 99 for invoice:7, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:29:57','',''),('21','238',193,'','6.1','3',151000.00,0.00,'Payment Id 98 for invoice:7, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:29:57','',''),('21','238',194,'','supplier','1',0.00,151000.00,'Payment Id 98 for invoice:7, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:29:57','',''),('21','238',195,'','6.1','3',44600.00,0.00,'Payment Id 97 for invoice:7, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:30:21','',''),('21','238',196,'','supplier','1',0.00,44600.00,'Payment Id 97 for invoice:7, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:30:21','',''),('21','238',197,'','2','13',755500.00,0.00,'Payment Id 96 for invoice:7, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:30:21','',''),('21','238',198,'','supplier','1',0.00,755500.00,'Payment Id 96 for invoice:7, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:30:21','',''),('21','238',199,'','2','18',1053037.00,0.00,'Payment Id 95 for invoice:7, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:30:21','',''),('21','238',200,'','supplier','1',0.00,1053037.00,'Payment Id 95 for invoice:7, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:30:21','',''),('21','238',201,'','2','18',460970.00,0.00,'Payment Id 94 for invoice:7, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:30:21','',''),('21','238',202,'','supplier','1',0.00,460970.00,'Payment Id 94 for invoice:7, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:30:21','',''),('21','238',203,'','2','13',574200.00,0.00,'Payment Id 93 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:30:21','',''),('21','238',204,'','supplier','1',0.00,574200.00,'Payment Id 93 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:30:21','',''),('21','238',205,'','6.1','3',51000.00,0.00,'Payment Id 92 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:30:21','',''),('21','238',206,'','supplier','1',0.00,51000.00,'Payment Id 92 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:30:21','',''),('21','238',207,'','6.1','3',5000.00,0.00,'Payment Id 91 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:30:21','',''),('21','238',208,'','supplier','1',0.00,5000.00,'Payment Id 91 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:30:21','',''),('21','238',209,'','6.1','3',300000.00,0.00,'Payment Id 90 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:30:21','',''),('21','238',210,'','supplier','1',0.00,300000.00,'Payment Id 90 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:30:21','',''),('21','238',211,'','6.1','3',20000.00,0.00,'Payment Id 89 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:30:21','',''),('21','238',212,'','supplier','1',0.00,20000.00,'Payment Id 89 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:30:21','',''),('21','238',213,'','6.1','3',69800.00,0.00,'Payment Id 88 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:30:21','',''),('21','238',214,'','supplier','1',0.00,69800.00,'Payment Id 88 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:30:21','',''),('21','238',215,'','6.1','3',244300.00,0.00,'Payment Id 87 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:30:51','',''),('21','238',216,'','supplier','1',0.00,244300.00,'Payment Id 87 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:30:51','',''),('21','238',217,'','6.1','3',1630.00,0.00,'Payment Id 86 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:30:51','',''),('21','238',218,'','supplier','1',0.00,1630.00,'Payment Id 86 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:30:51','',''),('21','238',219,'','6.1','3',34900.00,0.00,'Payment Id 85 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:30:51','',''),('21','238',220,'','supplier','1',0.00,34900.00,'Payment Id 85 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:30:51','',''),('21','238',221,'','6.1','3',887500.00,0.00,'Payment Id 84 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:30:51','',''),('21','238',222,'','supplier','1',0.00,887500.00,'Payment Id 84 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:30:51','',''),('21','238',223,'','6.1','3',104700.00,0.00,'Payment Id 83 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:30:51','',''),('21','238',224,'','supplier','1',0.00,104700.00,'Payment Id 83 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:30:51','',''),('21','238',225,'','6.1','3',104700.00,0.00,'Payment Id 82 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:30:51','',''),('21','238',226,'','supplier','1',0.00,104700.00,'Payment Id 82 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:30:51','',''),('21','238',227,'','2','18',3635900.00,0.00,'Payment Id 81 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:30:51','',''),('21','238',228,'','supplier','1',0.00,3635900.00,'Payment Id 81 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:30:51','',''),('21','238',229,'','24','5',0.00,2640000.00,'Purchase Id 4 for 16,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-04 20:41:37','',''),('21','238',230,'','supplier','1',2640000.00,0.00,'Purchase Id 4 for 16,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-04 20:41:37','',''),('21','238',231,'','24','5',0.00,21987000.00,'Purchase Id 5 for 31,500.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-04-04 20:48:25','',''),('21','238',232,'','supplier','1',21987000.00,0.00,'Purchase Id 5 for 31,500.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-04-04 20:48:25','',''),('21','238',233,'','24','5',0.00,4950000.00,'Purchase Id 6 for 30,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-04 20:53:28','',''),('21','238',234,'','supplier','1',4950000.00,0.00,'Purchase Id 6 for 30,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-04 20:53:28','',''),('21','238',235,'','6.1','3',3455.00,0.00,'Payment Id 129 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:23:42','',''),('21','238',236,'','supplier','1',0.00,3455.00,'Payment Id 129 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:23:42','',''),('21','238',237,'','2','27',795865.00,0.00,'Payment Id 128 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:23:42','',''),('21','238',238,'','supplier','1',0.00,795865.00,'Payment Id 128 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:23:42','',''),('21','238',239,'','2','15',55840.00,0.00,'Payment Id 127 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:23:42','',''),('21','238',240,'','supplier','1',0.00,55840.00,'Payment Id 127 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:23:42','',''),('21','238',241,'','2','13',754400.00,0.00,'Payment Id 126 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:23:42','',''),('21','238',242,'','supplier','1',0.00,754400.00,'Payment Id 126 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:23:42','',''),('21','238',243,'','6.1','3',38390.00,0.00,'Payment Id 125 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:23:42','',''),('21','238',244,'','supplier','1',0.00,38390.00,'Payment Id 125 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:23:42','',''),('21','238',245,'','6.1','3',229200.00,0.00,'Payment Id 124 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:23:42','',''),('21','238',246,'','supplier','1',0.00,229200.00,'Payment Id 124 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:23:42','',''),('21','238',247,'','6.1','3',104700.00,0.00,'Payment Id 123 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:23:42','',''),('21','238',248,'','supplier','1',0.00,104700.00,'Payment Id 123 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:23:42','',''),('21','238',249,'','6.1','3',358400.00,0.00,'Payment Id 122 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:23:42','',''),('21','238',250,'','supplier','1',0.00,358400.00,'Payment Id 122 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:23:42','',''),('21','238',251,'','6.1','3',104700.00,0.00,'Payment Id 121 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:23:42','',''),('21','238',252,'','supplier','1',0.00,104700.00,'Payment Id 121 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:23:42','',''),('21','238',253,'','6.1','3',27920.00,0.00,'Payment Id 120 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:23:42','',''),('21','238',254,'','supplier','1',0.00,27920.00,'Payment Id 120 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:23:42','',''),('21','238',255,'','6.1','3',418800.00,0.00,'Payment Id 119 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:24:05','',''),('21','238',256,'','supplier','1',0.00,418800.00,'Payment Id 119 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:24:05','',''),('21','238',257,'','6.1','3',139600.00,0.00,'Payment Id 118 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:24:05','',''),('21','238',258,'','supplier','1',0.00,139600.00,'Payment Id 118 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:24:05','',''),('21','238',259,'','6.1','3',79000.00,0.00,'Payment Id 117 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:24:05','',''),('21','238',260,'','supplier','1',0.00,79000.00,'Payment Id 117 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:24:05','',''),('21','238',261,'','6.1','3',488600.00,0.00,'Payment Id 116 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:24:05','',''),('21','238',262,'','supplier','1',0.00,488600.00,'Payment Id 116 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:24:05','',''),('21','238',263,'','6.1','3',20940.00,0.00,'Payment Id 115 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:24:05','',''),('21','238',264,'','supplier','1',0.00,20940.00,'Payment Id 115 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:24:05','',''),('21','238',265,'','6.1','3',349000.00,0.00,'Payment Id 114 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:24:05','',''),('21','238',266,'','supplier','1',0.00,349000.00,'Payment Id 114 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:24:05','',''),('21','238',267,'','6.1','3',887500.00,0.00,'Payment Id 113 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:24:05','',''),('21','238',268,'','supplier','1',0.00,887500.00,'Payment Id 113 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:24:05','',''),('21','238',269,'','6.1','3',150.00,0.00,'Payment Id 112 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:24:05','',''),('21','238',270,'','supplier','1',0.00,150.00,'Payment Id 112 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:24:05','',''),('21','238',271,'','6.1','3',34900.00,0.00,'Payment Id 111 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:24:05','',''),('21','238',272,'','supplier','1',0.00,34900.00,'Payment Id 111 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:24:05','',''),('21','238',273,'','2','27',2200030.00,0.00,'Payment Id 110 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:24:05','',''),('21','238',274,'','supplier','1',0.00,2200030.00,'Payment Id 110 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 16:24:05','',''),('21','238',275,'','20','2',8518288.78,0.00,'Sales from shift 8 on 2022-04-06 08:53:05 ','2022-04-06 08:53:05','',''),('21','238',276,'','6.1','3',0.00,8518288.78,'Sales from shift 8 on 2022-04-06 08:53:05 ','2022-04-06 08:53:05','',''),('21','238',277,'','20','2',10213223.46,0.00,'Sales from shift 9 on 2022-04-06 12:34:14 ','2022-04-06 12:34:14','',''),('21','238',278,'','6.1','3',0.00,10213223.46,'Sales from shift 9 on 2022-04-06 12:34:14 ','2022-04-06 12:34:14','',''),('21','238',279,'','24','5',0.00,4455000.00,'Purchase Id 7 for 27,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-06 20:30:26','',''),('21','238',280,'','supplier','1',4455000.00,0.00,'Purchase Id 7 for 27,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-06 20:30:26','',''),('21','238',281,'','24','5',0.00,2805000.00,'Purchase Id 8 for 17,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-06 21:42:49','',''),('21','238',282,'','supplier','1',2805000.00,0.00,'Purchase Id 8 for 17,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-06 21:42:49','',''),('21','238',283,'','20','2',8701027.91,0.00,'Sales from shift 10 on 2022-04-07 09:47:12 ','2022-04-07 09:47:12','',''),('21','238',284,'','6.1','3',0.00,8701027.91,'Sales from shift 10 on 2022-04-07 09:47:12 ','2022-04-07 09:47:12','',''),('21','238',285,'','24','5',0.00,12215000.00,'Purchase Id 9 for 17,500.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-04-07 20:53:22','',''),('21','238',286,'','supplier','1',12215000.00,0.00,'Purchase Id 9 for 17,500.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-04-07 20:53:22','',''),('21','238',287,'','24','5',0.00,2475000.00,'Purchase Id 10 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-08 10:05:49','',''),('21','238',288,'','supplier','1',2475000.00,0.00,'Purchase Id 10 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-08 10:05:49','',''),('21','238',289,'','20','2',7867604.32,0.00,'Sales from shift 11 on 2022-04-08 11:05:27 ','2022-04-08 11:05:27','',''),('21','238',290,'','6.1','3',0.00,7867604.32,'Sales from shift 11 on 2022-04-08 11:05:27 ','2022-04-08 11:05:27','',''),('21','238',291,'','24','5',0.00,2557500.00,'Purchase Id 11 for 15,500.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-09 10:32:58','',''),('21','238',292,'','supplier','1',2557500.00,0.00,'Purchase Id 11 for 15,500.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-09 10:32:58','',''),('21','238',293,'','20','2',6415980.49,0.00,'Sales from shift 12 on 2022-04-09 12:09:25 ','2022-04-09 12:09:25','',''),('21','238',294,'','6.1','3',0.00,6415980.49,'Sales from shift 12 on 2022-04-09 12:09:25 ','2022-04-09 12:09:25','',''),('21','238',295,'','20','2',6901510.90,0.00,'Sales from shift 13 on 2022-04-10 09:36:38 ','2022-04-10 09:36:38','',''),('21','238',296,'','6.1','3',0.00,6901510.90,'Sales from shift 13 on 2022-04-10 09:36:38 ','2022-04-10 09:36:38','',''),('21','238',297,'','20','2',5548983.72,0.00,'Sales from shift 14 on 2022-04-11 08:14:19 ','2022-04-11 08:14:19','',''),('21','238',298,'','6.1','3',0.00,5548983.72,'Sales from shift 14 on 2022-04-11 08:14:19 ','2022-04-11 08:14:19','',''),('21','238',299,'','24','5',0.00,2722500.00,'Purchase Id 12 for 16,500.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-11 21:10:48','',''),('21','238',300,'','supplier','1',2722500.00,0.00,'Purchase Id 12 for 16,500.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-11 21:10:48','',''),('21','238',301,'','24','5',0.00,2475000.00,'Purchase Id 13 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-12 12:13:21','',''),('21','238',302,'','supplier','1',2475000.00,0.00,'Purchase Id 13 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-12 12:13:21','',''),('21','238',303,'','20','2',2177948.46,0.00,'Sales from shift 15 on 2022-04-12 16:12:41 ','2022-04-12 16:12:41','',''),('21','238',304,'','6.1','3',0.00,2177948.46,'Sales from shift 15 on 2022-04-12 16:12:41 ','2022-04-12 16:12:41','',''),('21','238',305,'','2','18',668700.00,0.00,'Payment Id 108 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-12 18:21:43','',''),('21','238',306,'','supplier','1',0.00,668700.00,'Payment Id 108 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-12 18:21:43','',''),('21','238',307,'','20','2',0.00,0.00,'Sales from shift 16 on 2022-04-13 17:26:23 ','2022-04-13 17:26:23','',''),('21','238',308,'','6.1','3',0.00,0.00,'Sales from shift 16 on 2022-04-13 17:26:23 ','2022-04-13 17:26:23','',''),('21','238',309,'','24','5',0.00,20340000.00,'Purchase Id 14 for 30,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-04-13 17:42:51','',''),('21','238',310,'','supplier','1',20340000.00,0.00,'Purchase Id 14 for 30,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-04-13 17:42:51','',''),('21','238',311,'','24','5',0.00,1980000.00,'Purchase Id 15 for 12,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-13 17:49:27','',''),('21','238',312,'','supplier','1',1980000.00,0.00,'Purchase Id 15 for 12,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-13 17:49:27','',''),('21','238',313,'','2','18',188700.00,0.00,'Payment Id 203 for invoice:14, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-13 18:10:44','',''),('21','238',314,'','supplier','1',0.00,188700.00,'Payment Id 203 for invoice:14, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-13 18:10:44','',''),('21','238',315,'','2','18',859500.00,0.00,'Payment Id 202 for invoice:14, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-13 18:11:32','',''),('21','238',316,'','supplier','1',0.00,859500.00,'Payment Id 202 for invoice:14, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-13 18:11:32','',''),('21','238',317,'','2','27',103660.00,0.00,'Payment Id 168 for invoice:9, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-13 18:21:03','',''),('21','238',318,'','supplier','1',0.00,103660.00,'Payment Id 168 for invoice:9, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-13 18:21:03','',''),('21','238',319,'','2','27',2092615.00,0.00,'Payment Id 206 for invoice:12, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-13 18:29:41','',''),('21','238',320,'','supplier','1',0.00,2092615.00,'Payment Id 206 for invoice:12, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-13 18:29:41','',''),('21','238',321,'','2','27',4136265.00,0.00,'Payment Id 207 for invoice:13, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-13 18:33:31','',''),('21','238',322,'','supplier','1',0.00,4136265.00,'Payment Id 207 for invoice:13, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-13 18:33:31','',''),('21','238',323,'','2','27',1153655.00,0.00,'Payment Id 208 for invoice:14, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-13 19:08:47','',''),('21','238',324,'','supplier','1',0.00,1153655.00,'Payment Id 208 for invoice:14, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-13 19:08:47','',''),('21','238',325,'','2','27',1031010.00,0.00,'Payment Id 209 for invoice:15, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-14 17:15:03','',''),('21','238',326,'','supplier','1',0.00,1031010.00,'Payment Id 209 for invoice:15, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-14 17:15:03','',''),('21','238',327,'','customer','29',0.00,208498.56,'Credit Sales for 307.52 Litres of Diesel from shift 17 on 2022-04-15 14:12:02 ','2022-04-15 14:12:02','',''),('21','238',328,'','20','2',5848023.94,0.00,'Sales from shift 17 on 2022-04-15 14:12:02 ','2022-04-15 14:12:02','',''),('21','238',329,'','6.1','3',0.00,5639525.38,'Sales from shift 17 on 2022-04-15 14:12:02 ','2022-04-15 14:12:02','',''),('21','238',330,'','2','15',1757200.00,0.00,'Payment Id 130 for invoice:9, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-15 14:50:47','',''),('21','238',331,'','supplier','1',0.00,1757200.00,'Payment Id 130 for invoice:9, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-15 14:50:47','',''),('21','238',332,'','2','27',3210080.00,0.00,'Payment Id 133 for invoice:9, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-15 14:53:47','',''),('21','238',333,'','supplier','1',0.00,3210080.00,'Payment Id 133 for invoice:9, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-15 14:53:47','',''),('21','238',334,'','2','13',1411820.00,0.00,'Payment Id 132 for invoice:9, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-15 14:54:40','',''),('21','238',335,'','supplier','1',0.00,1411820.00,'Payment Id 132 for invoice:9, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-15 14:54:40','',''),('21','238',336,'','2','18',1537581.00,0.00,'Payment Id 131 for invoice:9, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-15 14:55:23','',''),('21','238',337,'','supplier','1',0.00,1537581.00,'Payment Id 131 for invoice:9, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-15 14:55:23','',''),('21','238',338,'','customer','12',0.00,294421.50,'Credit Sales for 434.25 Litres of Diesel from shift 18 on 2022-04-15 14:55:46 ','2022-04-15 14:55:46','',''),('21','238',339,'','customer','42',0.00,50002.50,'Credit Sales for 73.75 Litres of Diesel from shift 18 on 2022-04-15 14:55:46 ','2022-04-15 14:55:46','',''),('21','238',340,'','customer','35',0.00,67800.00,'Credit Sales for 100.00 Litres of Diesel from shift 18 on 2022-04-15 14:55:46 ','2022-04-15 14:55:46','',''),('21','238',341,'','customer','20',0.00,147600.60,'Credit Sales for 217.70 Litres of Diesel from shift 18 on 2022-04-15 14:55:46 ','2022-04-15 14:55:46','',''),('21','238',342,'','20','2',6495450.36,0.00,'Sales from shift 18 on 2022-04-15 14:55:46 ','2022-04-15 14:55:46','',''),('21','238',343,'','6.1','3',0.00,5935625.76,'Sales from shift 18 on 2022-04-15 14:55:46 ','2022-04-15 14:55:46','',''),('21','238',344,'','2','15',2030900.00,0.00,'Payment Id 151 for invoice:10, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-15 15:06:38','',''),('21','238',345,'','supplier','1',0.00,2030900.00,'Payment Id 151 for invoice:10, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-15 15:06:38','',''),('21','238',346,'','2','18',111000.00,0.00,'Payment Id 152 for invoice:10, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-15 15:07:17','',''),('21','238',347,'','supplier','1',0.00,111000.00,'Payment Id 152 for invoice:10, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-15 15:07:17','',''),('21','238',348,'','2','27',881340.00,0.00,'Payment Id 154 for invoice:10, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-15 15:07:46','',''),('21','238',349,'','supplier','1',0.00,881340.00,'Payment Id 154 for invoice:10, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-15 15:07:46','',''),('21','238',350,'','2','27',2707435.00,0.00,'Payment Id 155 for invoice:10, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-15 15:08:36','',''),('21','238',351,'','supplier','1',0.00,2707435.00,'Payment Id 155 for invoice:10, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-15 15:08:36','',''),('21','238',352,'','2','18',2403600.00,0.00,'Payment Id 171 for invoice:11, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-15 15:14:58','',''),('21','238',353,'','supplier','1',0.00,2403600.00,'Payment Id 171 for invoice:11, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-15 15:14:58','',''),('21','238',354,'','2','18',1455590.00,0.00,'Payment Id 200 for invoice:13, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-15 15:30:58','',''),('21','238',355,'','supplier','1',0.00,1455590.00,'Payment Id 200 for invoice:13, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-15 15:30:58','',''),('21','238',356,'','2','27',905585.00,0.00,'Payment Id 196 for invoice:12, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-15 15:31:53','',''),('21','238',357,'','supplier','1',0.00,905585.00,'Payment Id 196 for invoice:12, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-15 15:31:53','',''),('21','238',358,'','customer','12',0.00,5999.40,'Credit Sales for 36.36 Litres of Petrol from shift 19 on 2022-04-15 15:40:43 ','2022-04-15 15:40:43','',''),('21','238',359,'','customer','12',0.00,24557.16,'Credit Sales for 36.22 Litres of Diesel from shift 19 on 2022-04-15 15:40:43 ','2022-04-15 15:40:43','',''),('21','238',360,'','customer','8',0.00,20340.00,'Credit Sales for 30.00 Litres of Diesel from shift 19 on 2022-04-15 15:40:43 ','2022-04-15 15:40:43','',''),('21','238',361,'','customer','9',0.00,50002.50,'Credit Sales for 73.75 Litres of Diesel from shift 19 on 2022-04-15 15:40:43 ','2022-04-15 15:40:43','',''),('21','238',362,'','customer','30',0.00,542400.00,'Credit Sales for 800.00 Litres of Diesel from shift 19 on 2022-04-15 15:40:43 ','2022-04-15 15:40:43','',''),('21','238',363,'','customer','34',0.00,305100.00,'Credit Sales for 450.00 Litres of Diesel from shift 19 on 2022-04-15 15:40:43 ','2022-04-15 15:40:43','',''),('21','238',364,'','20','2',8612190.51,0.00,'Sales from shift 19 on 2022-04-15 15:40:43 ','2022-04-15 15:40:43','',''),('21','238',365,'','6.1','3',0.00,7663791.45,'Sales from shift 19 on 2022-04-15 15:40:43 ','2022-04-15 15:40:43','',''),('21','238',366,'','24','5',0.00,2475000.00,'Purchase Id 16 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-16 09:55:47','',''),('21','238',367,'','supplier','1',2475000.00,0.00,'Purchase Id 16 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-16 09:55:47','',''),('21','238',368,'','24','5',0.00,10848000.00,'Purchase Id 17 for 16,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-04-16 10:00:58','',''),('21','238',369,'','supplier','1',10848000.00,0.00,'Purchase Id 17 for 16,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-04-16 10:00:58','',''),('21','238',370,'','customer','16',0.00,1230570.00,'Credit Sales for 1,815.00 Litres of Diesel from shift 20 on 2022-04-16 11:07:39 ','2022-04-16 11:07:39','',''),('21','238',371,'','customer','37',0.00,61020.00,'Credit Sales for 90.00 Litres of Diesel from shift 20 on 2022-04-16 11:07:39 ','2022-04-16 11:07:39','',''),('21','238',372,'','customer','9',0.00,210003.72,'Credit Sales for 309.74 Litres of Diesel from shift 20 on 2022-04-16 11:07:39 ','2022-04-16 11:07:39','',''),('21','238',373,'','customer','8',0.00,89177.34,'Credit Sales for 131.53 Litres of Diesel from shift 20 on 2022-04-16 11:07:39 ','2022-04-16 11:07:39','',''),('21','238',374,'','customer','34',0.00,484770.00,'Credit Sales for 715.00 Litres of Diesel from shift 20 on 2022-04-16 11:07:39 ','2022-04-16 11:07:39','',''),('21','238',375,'','20','2',7932779.59,0.00,'Sales from shift 20 on 2022-04-16 11:07:39 ','2022-04-16 11:07:39','',''),('21','238',376,'','6.1','3',0.00,5857238.53,'Sales from shift 20 on 2022-04-16 11:07:39 ','2022-04-16 11:07:39','',''),('21','238',377,'','2','18',758200.00,0.00,'Payment Id 109 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-16 12:21:42','',''),('21','238',378,'','supplier','1',0.00,758200.00,'Payment Id 109 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-16 12:21:42','',''),('21','238',379,'','2','27',1511965.00,0.00,'Payment Id 169 for invoice:10, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-16 12:31:57','',''),('21','238',380,'','supplier','1',0.00,1511965.00,'Payment Id 169 for invoice:10, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-16 12:31:57','',''),('21','238',381,'','2','27',1017365.00,0.00,'Payment Id 170 for invoice:11, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-16 12:32:54','',''),('21','238',382,'','supplier','1',0.00,1017365.00,'Payment Id 170 for invoice:11, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-16 12:32:54','',''),('21','238',383,'','2','18',48200.00,0.00,'Payment Id 199 for invoice:13, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-16 13:15:53','',''),('21','238',384,'','supplier','1',0.00,48200.00,'Payment Id 199 for invoice:13, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-16 13:15:53','',''),('21','238',385,'','2','27',451915.00,0.00,'Payment Id 195 for invoice:11, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-16 13:19:07','',''),('21','238',386,'','supplier','1',0.00,451915.00,'Payment Id 195 for invoice:11, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-16 13:19:07','',''),('21','238',387,'','2','18',12200.00,0.00,'Payment Id 190 for invoice:12, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-16 13:19:57','',''),('21','238',388,'','supplier','1',0.00,12200.00,'Payment Id 190 for invoice:12, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-16 13:19:57','',''),('21','238',389,'','2','15',1420950.00,0.00,'Payment Id 189 for invoice:12, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-16 13:20:48','',''),('21','238',390,'','supplier','1',0.00,1420950.00,'Payment Id 189 for invoice:12, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-16 13:20:48','',''),('21','238',391,'','2','15',1441180.00,0.00,'Payment Id 211 for invoice:17, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-16 13:31:51','',''),('21','238',392,'','supplier','1',0.00,1441180.00,'Payment Id 211 for invoice:17, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-16 13:31:51','',''),('21','238',393,'','2','18',674000.00,0.00,'Payment Id 212 for invoice:17, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-16 13:32:32','',''),('21','238',394,'','supplier','1',0.00,674000.00,'Payment Id 212 for invoice:17, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-16 13:32:32','',''),('21','238',395,'','2','15',289900.00,0.00,'Payment Id 216 for invoice:18, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-16 13:33:37','',''),('21','238',396,'','supplier','1',0.00,289900.00,'Payment Id 216 for invoice:18, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-16 13:33:37','',''),('21','238',397,'','2','18',18500.00,0.00,'Payment Id 217 for invoice:18, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-16 13:34:29','',''),('21','238',398,'','supplier','1',0.00,18500.00,'Payment Id 217 for invoice:18, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-16 13:34:29','',''),('21','238',399,'','2','18',537960.00,0.00,'Payment Id 218 for invoice:18, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-16 13:35:14','',''),('21','238',400,'','supplier','1',0.00,537960.00,'Payment Id 218 for invoice:18, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-16 13:35:14','',''),('21','238',401,'','24','5',0.00,2475000.00,'Purchase Id 18 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-16 15:50:47','',''),('21','238',402,'','supplier','1',2475000.00,0.00,'Purchase Id 18 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-16 15:50:47','',''),('21','238',403,'','customer','8',0.00,474600.00,'Credit Sales for 700.00 Litres of Diesel from shift 21 on 2022-04-16 16:28:56 ','2022-04-16 16:28:56','',''),('21','238',404,'','customer','35',0.00,20340.00,'Credit Sales for 30.00 Litres of Diesel from shift 21 on 2022-04-16 16:28:56 ','2022-04-16 16:28:56','',''),('21','238',405,'','customer','12',0.00,349102.20,'Credit Sales for 514.90 Litres of Diesel from shift 21 on 2022-04-16 16:28:56 ','2022-04-16 16:28:56','',''),('21','238',406,'','20','2',4009042.46,0.00,'Sales from shift 21 on 2022-04-16 16:28:56 ','2022-04-16 16:28:56','',''),('21','238',407,'','6.1','3',0.00,3165000.26,'Sales from shift 21 on 2022-04-16 16:28:56 ','2022-04-16 16:28:56','',''),('21','238',408,'','24','5',0.00,20679000.00,'Purchase Id 19 for 30,500.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-04-17 18:06:25','',''),('21','238',409,'','supplier','1',20679000.00,0.00,'Purchase Id 19 for 30,500.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-04-17 18:06:25','',''),('21','238',410,'','2','27',2099880.00,0.00,'Payment Id 220 for invoice:18, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-18 10:00:21','',''),('21','238',411,'','supplier','1',0.00,2099880.00,'Payment Id 220 for invoice:18, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-18 10:00:21','',''),('21','238',412,'','2','27',1894830.00,0.00,'Payment Id 221 for invoice:18, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-18 10:01:16','',''),('21','238',413,'','supplier','1',0.00,1894830.00,'Payment Id 221 for invoice:18, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-18 10:01:16','',''),('21','238',414,'','2','27',1195895.00,0.00,'Payment Id 226 for invoice:19, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-18 10:02:54','',''),('21','238',415,'','supplier','1',0.00,1195895.00,'Payment Id 226 for invoice:19, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-18 10:02:54','',''),('21','238',416,'','2','27',925605.00,0.00,'Payment Id 227 for invoice:19, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-18 10:03:33','',''),('21','238',417,'','supplier','1',0.00,925605.00,'Payment Id 227 for invoice:19, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-18 10:03:33','',''),('21','238',418,'','24','5',0.00,4950000.00,'Purchase Id 20 for 30,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-18 15:12:36','',''),('21','238',419,'','supplier','1',4950000.00,0.00,'Purchase Id 20 for 30,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-18 15:12:36','',''),('21','238',420,'','customer','12',0.00,696299.22,'Credit Sales for 1,026.99 Litres of Diesel from shift 22 on 2022-04-18 15:23:21 ','2022-04-18 15:23:21','',''),('21','238',421,'','customer','12',0.00,8700.45,'Credit Sales for 52.73 Litres of Petrol from shift 22 on 2022-04-18 15:23:21 ','2022-04-18 15:23:21','',''),('21','238',422,'','customer','18',0.00,13560.00,'Credit Sales for 20.00 Litres of Diesel from shift 22 on 2022-04-18 15:23:21 ','2022-04-18 15:23:21','',''),('21','238',423,'','customer','9',0.00,15004.14,'Credit Sales for 22.13 Litres of Diesel from shift 22 on 2022-04-18 15:23:21 ','2022-04-18 15:23:21','',''),('21','238',424,'','customer','37',0.00,94920.00,'Credit Sales for 140.00 Litres of Diesel from shift 22 on 2022-04-18 15:23:21 ','2022-04-18 15:23:21','',''),('21','238',425,'','customer','22',0.00,394948.56,'Credit Sales for 582.52 Litres of Diesel from shift 22 on 2022-04-18 15:23:21 ','2022-04-18 15:23:21','',''),('21','238',426,'','customer','40',0.00,14000.70,'Credit Sales for 20.65 Litres of Diesel from shift 22 on 2022-04-18 15:23:21 ','2022-04-18 15:23:21','',''),('21','238',427,'','20','2',7324471.62,0.00,'Sales from shift 22 on 2022-04-18 15:23:21 ','2022-04-18 15:23:21','',''),('21','238',428,'','6.1','3',0.00,6087038.55,'Sales from shift 22 on 2022-04-18 15:23:21 ','2022-04-18 15:23:21','',''),('21','238',429,'','20','2',12098892.37,0.00,'Sales from shift 23 on 2022-04-18 15:47:06 ','2022-04-18 15:47:06','',''),('21','238',430,'','6.1','3',0.00,12098892.37,'Sales from shift 23 on 2022-04-18 15:47:06 ','2022-04-18 15:47:06','',''),('21','238',431,'','20','2',382703.88,0.00,'Sales from shift 24 on 2022-04-19 10:54:59 ','2022-04-19 10:54:59','',''),('21','238',432,'','6.1','3',0.00,382703.88,'Sales from shift 24 on 2022-04-19 10:54:59 ','2022-04-19 10:54:59','',''),('21','238',433,'','24','5',0.00,2475000.00,'Purchase Id 21 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-19 20:25:56','',''),('21','238',434,'','supplier','1',2475000.00,0.00,'Purchase Id 21 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-19 20:25:56','',''),('21','238',435,'','24','5',0.00,4950000.00,'Purchase Id 22 for 30,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-20 11:43:31','',''),('21','238',436,'','supplier','1',4950000.00,0.00,'Purchase Id 22 for 30,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-20 11:43:31','',''),('21','238',437,'','20','2',4650533.57,0.00,'Sales from shift 25 on 2022-04-20 12:05:56 ','2022-04-20 12:05:56','',''),('21','238',438,'','6.1','3',0.00,4650533.57,'Sales from shift 25 on 2022-04-20 12:05:56 ','2022-04-20 12:05:56','',''),('21','238',439,'','24','5',0.00,13260000.00,'Purchase Id 23 for 20,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-04-21 10:17:22','',''),('21','238',440,'','supplier','1',13260000.00,0.00,'Purchase Id 23 for 20,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-04-21 10:17:22','',''),('21','238',441,'','customer','24',0.00,60001.50,'Credit Sales for 90.50 Litres of Diesel from shift 26 on 2022-04-21 11:32:06 ','2022-04-21 11:32:06','',''),('21','238',442,'','customer','34',0.00,345847.32,'Credit Sales for 521.64 Litres of Diesel from shift 26 on 2022-04-21 11:32:06 ','2022-04-21 11:32:06','',''),('21','238',443,'','customer','39',0.00,9998.04,'Credit Sales for 15.08 Litres of Diesel from shift 26 on 2022-04-21 11:32:06 ','2022-04-21 11:32:06','',''),('21','238',444,'','customer','12',0.00,20002.71,'Credit Sales for 30.17 Litres of Diesel from shift 26 on 2022-04-21 11:32:06 ','2022-04-21 11:32:06','',''),('21','238',445,'','customer','40',0.00,9998.04,'Credit Sales for 15.08 Litres of Diesel from shift 26 on 2022-04-21 11:32:06 ','2022-04-21 11:32:06','',''),('21','238',446,'','20','2',5124866.19,0.00,'Sales from shift 26 on 2022-04-21 11:32:06 ','2022-04-21 11:32:06','',''),('21','238',447,'','6.1','3',0.00,4679018.58,'Sales from shift 26 on 2022-04-21 11:32:06 ','2022-04-21 11:32:06','',''),('21','238',448,'','customer','7',0.00,79560.00,'Credit Sales for 120.00 Litres of Diesel from shift 27 on 2022-04-21 12:08:03 ','2022-04-21 12:08:03','',''),('21','238',449,'','customer','12',0.00,8002.41,'Credit Sales for 12.07 Litres of Diesel from shift 27 on 2022-04-21 12:08:03 ','2022-04-21 12:08:03','',''),('21','238',450,'','customer','9',0.00,315588.00,'Credit Sales for 476.00 Litres of Diesel from shift 27 on 2022-04-21 12:08:03 ','2022-04-21 12:08:03','',''),('21','238',451,'','customer','3',0.00,19890.00,'Credit Sales for 30.00 Litres of Diesel from shift 27 on 2022-04-21 12:08:03 ','2022-04-21 12:08:03','',''),('21','238',452,'','20','2',10182373.87,0.00,'Sales from shift 27 on 2022-04-21 12:08:03 ','2022-04-21 12:08:03','',''),('21','238',453,'','6.1','3',0.00,9759333.46,'Sales from shift 27 on 2022-04-21 12:08:03 ','2022-04-21 12:08:03','',''),('21','238',454,'','2','18',54900.00,0.00,'Payment Id 263 for invoice:25, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-21 16:37:32','',''),('21','238',455,'','supplier','1',0.00,54900.00,'Payment Id 263 for invoice:25, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-21 16:37:32','',''),('21','238',456,'','2','18',2105140.00,0.00,'Payment Id 262 for invoice:25, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-21 16:38:06','',''),('21','238',457,'','supplier','1',0.00,2105140.00,'Payment Id 262 for invoice:25, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-21 16:38:06','',''),('21','238',458,'','2','18',1320500.00,0.00,'Payment Id 245 for invoice:22, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-21 16:44:02','',''),('21','238',459,'','supplier','1',0.00,1320500.00,'Payment Id 245 for invoice:22, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-21 16:44:02','',''),('21','238',460,'','2','18',622800.00,0.00,'Payment Id 241 for invoice:21, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-21 16:45:03','',''),('21','238',461,'','supplier','1',0.00,622800.00,'Payment Id 241 for invoice:21, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-21 16:45:03','',''),('21','238',462,'','customer','20',0.00,144600.30,'Credit Sales for 218.10 Litres of Diesel from shift 28 on 2022-04-22 13:57:58 ','2022-04-22 13:57:58','',''),('21','238',463,'','customer','3',0.00,29994.12,'Credit Sales for 45.24 Litres of Diesel from shift 28 on 2022-04-22 13:57:58 ','2022-04-22 13:57:58','',''),('21','238',464,'','customer','8',0.00,164099.13,'Credit Sales for 247.51 Litres of Diesel from shift 28 on 2022-04-22 13:57:58 ','2022-04-22 13:57:58','',''),('21','238',465,'','customer','16',0.00,430950.00,'Credit Sales for 650.00 Litres of Diesel from shift 28 on 2022-04-22 13:57:58 ','2022-04-22 13:57:58','',''),('21','238',466,'','20','2',8379769.25,0.00,'Sales from shift 28 on 2022-04-22 13:57:58 ','2022-04-22 13:57:58','',''),('21','238',467,'','6.1','3',0.00,7610125.70,'Sales from shift 28 on 2022-04-22 13:57:58 ','2022-04-22 13:57:58','',''),('21','238',468,'','24','5',0.00,2475000.00,'Purchase Id 24 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-23 10:16:44','',''),('21','238',469,'','supplier','1',2475000.00,0.00,'Purchase Id 24 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-23 10:16:44','',''),('21','238',470,'','24','5',0.00,2805000.00,'Purchase Id 25 for 17,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-23 10:20:51','',''),('21','238',471,'','supplier','1',2805000.00,0.00,'Purchase Id 25 for 17,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-23 10:20:51','',''),('21','238',472,'','24','5',0.00,13923000.00,'Purchase Id 26 for 21,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-04-23 10:25:58','',''),('21','238',473,'','supplier','1',13923000.00,0.00,'Purchase Id 26 for 21,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-04-23 10:25:58','',''),('21','238',474,'','customer','16',0.00,377910.00,'Credit Sales for 570.00 Litres of Diesel from shift 29 on 2022-04-23 11:16:30 ','2022-04-23 11:16:30','',''),('21','238',475,'','customer','12',0.00,6000.15,'Credit Sales for 9.05 Litres of Diesel from shift 29 on 2022-04-23 11:16:30 ','2022-04-23 11:16:30','',''),('21','238',476,'','customer','24',0.00,60001.50,'Credit Sales for 90.50 Litres of Diesel from shift 29 on 2022-04-23 11:16:30 ','2022-04-23 11:16:30','',''),('21','238',477,'','customer','8',0.00,9998.04,'Credit Sales for 15.08 Litres of Diesel from shift 29 on 2022-04-23 11:16:30 ','2022-04-23 11:16:30','',''),('21','238',478,'','20','2',7132390.38,0.00,'Sales from shift 29 on 2022-04-23 11:16:30 ','2022-04-23 11:16:30','',''),('21','238',479,'','6.1','3',0.00,6678480.69,'Sales from shift 29 on 2022-04-23 11:16:30 ','2022-04-23 11:16:30','',''),('21','238',480,'','24','5',0.00,2475000.00,'Purchase Id 27 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-24 10:55:35','',''),('21','238',481,'','supplier','1',2475000.00,0.00,'Purchase Id 27 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-24 10:55:35','',''),('21','238',482,'','20','2',7447930.72,0.00,'Sales from shift 30 on 2022-04-24 11:18:13 ','2022-04-24 11:18:13','',''),('21','238',483,'','6.1','3',0.00,7447930.72,'Sales from shift 30 on 2022-04-24 11:18:13 ','2022-04-24 11:18:13','',''),('21','238',484,'','customer','8',0.00,464100.00,'Credit Sales for 700.00 Litres of Diesel from shift 31 on 2022-04-25 10:54:31 ','2022-04-25 10:54:31','',''),('21','238',485,'','customer','24',0.00,40005.42,'Credit Sales for 60.34 Litres of Diesel from shift 31 on 2022-04-25 10:54:31 ','2022-04-25 10:54:31','',''),('21','238',486,'','customer','22',0.00,442884.00,'Credit Sales for 668.00 Litres of Diesel from shift 31 on 2022-04-25 10:54:31 ','2022-04-25 10:54:31','',''),('21','238',487,'','customer','9',0.00,99993.66,'Credit Sales for 150.82 Litres of Diesel from shift 31 on 2022-04-25 10:54:31 ','2022-04-25 10:54:31','',''),('21','238',488,'','customer','16',0.00,364650.00,'Credit Sales for 550.00 Litres of Diesel from shift 31 on 2022-04-25 10:54:31 ','2022-04-25 10:54:31','',''),('21','238',489,'','customer','12',0.00,48505.08,'Credit Sales for 73.16 Litres of Diesel from shift 31 on 2022-04-25 10:54:31 ','2022-04-25 10:54:31','',''),('21','238',490,'','customer','18',0.00,81900.39,'Credit Sales for 123.53 Litres of Diesel from shift 31 on 2022-04-25 10:54:31 ','2022-04-25 10:54:31','',''),('21','238',491,'','20','2',8129793.02,0.00,'Sales from shift 31 on 2022-04-25 10:54:31 ','2022-04-25 10:54:31','',''),('21','238',492,'','6.1','3',0.00,6587754.47,'Sales from shift 31 on 2022-04-25 10:54:31 ','2022-04-25 10:54:31','',''),('21','238',493,'','2','13',1365500.00,0.00,'Payment Id 283 for invoice:27, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-25 12:13:27','',''),('21','238',494,'','supplier','1',0.00,1365500.00,'Payment Id 283 for invoice:27, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-25 12:13:27','',''),('21','238',495,'','2','18',174700.00,0.00,'Payment Id 281 for invoice:27, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-25 12:14:13','',''),('21','238',496,'','supplier','1',0.00,174700.00,'Payment Id 281 for invoice:27, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-25 12:14:13','',''),('21','238',497,'','2','27',355820.00,0.00,'Payment Id 277 for invoice:26, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-25 12:14:54','',''),('21','238',498,'','supplier','1',0.00,355820.00,'Payment Id 277 for invoice:26, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-25 12:14:54','',''),('21','238',499,'','2','13',607200.00,0.00,'Payment Id 242 for invoice:21, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-25 12:28:44','',''),('21','238',500,'','supplier','1',0.00,607200.00,'Payment Id 242 for invoice:21, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-25 12:28:44','',''),('21','238',501,'','2','27',522495.00,0.00,'Payment Id 239 for invoice:20, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-25 12:30:04','',''),('21','238',502,'','supplier','1',0.00,522495.00,'Payment Id 239 for invoice:20, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-25 12:30:04','',''),('21','238',503,'','2','15',232740.00,0.00,'Payment Id 223 for invoice:19, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-25 12:37:52','',''),('21','238',504,'','supplier','1',0.00,232740.00,'Payment Id 223 for invoice:19, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-25 12:37:52','',''),('21','238',505,'','2','13',543740.00,0.00,'Payment Id 219 for invoice:18, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-25 12:38:17','',''),('21','238',506,'','supplier','1',0.00,543740.00,'Payment Id 219 for invoice:18, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-25 12:38:17','',''),('21','238',507,'','24','5',0.00,5032500.00,'Purchase Id 28 for 30,500.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-26 10:37:59','',''),('21','238',508,'','supplier','1',5032500.00,0.00,'Purchase Id 28 for 30,500.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-26 10:37:59','',''),('21','238',509,'','customer','15',0.00,396706.05,'Credit Sales for 598.35 Litres of Diesel from shift 32 on 2022-04-26 11:03:30 ','2022-04-26 11:03:30','',''),('21','238',510,'','customer','34',0.00,474045.00,'Credit Sales for 715.00 Litres of Diesel from shift 32 on 2022-04-26 11:03:30 ','2022-04-26 11:03:30','',''),('21','238',511,'','customer','16',0.00,464100.00,'Credit Sales for 700.00 Litres of Diesel from shift 32 on 2022-04-26 11:03:30 ','2022-04-26 11:03:30','',''),('21','238',512,'','customer','11',0.00,16575.00,'Credit Sales for 25.00 Litres of Diesel from shift 32 on 2022-04-26 11:03:30 ','2022-04-26 11:03:30','',''),('21','238',513,'','20','2',6126433.84,0.00,'Sales from shift 32 on 2022-04-26 11:03:30 ','2022-04-26 11:03:30','',''),('21','238',514,'','6.1','3',0.00,4775007.79,'Sales from shift 32 on 2022-04-26 11:03:30 ','2022-04-26 11:03:30','',''),('21','238',515,'','2','27',1574900.00,0.00,'Payment Id 292 for invoice:28, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 16:19:06','',''),('21','238',516,'','supplier','1',0.00,1574900.00,'Payment Id 292 for invoice:28, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 16:19:06','',''),('21','238',517,'','2','27',3673455.00,0.00,'Payment Id 293 for invoice:27, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 16:19:33','',''),('21','238',518,'','supplier','1',0.00,3673455.00,'Payment Id 293 for invoice:27, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 16:19:33','',''),('21','238',519,'','2','13',432930.00,0.00,'Payment Id 271 for invoice:26, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 16:26:24','',''),('21','238',520,'','supplier','1',0.00,432930.00,'Payment Id 271 for invoice:26, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 16:26:24','',''),('21','238',521,'','2','18',1145040.00,0.00,'Payment Id 280 for invoice:27, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 16:26:45','',''),('21','238',522,'','supplier','1',0.00,1145040.00,'Payment Id 280 for invoice:27, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 16:26:45','',''),('21','238',523,'','2','18',562450.00,0.00,'Payment Id 251 for invoice:23, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 16:31:40','',''),('21','238',524,'','supplier','1',0.00,562450.00,'Payment Id 251 for invoice:23, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 16:31:40','',''),('21','238',525,'','2','13',4090995.00,0.00,'Payment Id 252 for invoice:23, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 16:32:05','',''),('21','238',526,'','supplier','1',0.00,4090995.00,'Payment Id 252 for invoice:23, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 16:32:05','',''),('21','238',527,'','2','18',944200.00,0.00,'Payment Id 232 for invoice:20, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 16:37:52','',''),('21','238',528,'','supplier','1',0.00,944200.00,'Payment Id 232 for invoice:20, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-26 16:37:52','',''),('21','238',529,'','24','5',0.00,2722500.00,'Purchase Id 29 for 16,500.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-27 12:01:47','',''),('21','238',530,'','supplier','1',2722500.00,0.00,'Purchase Id 29 for 16,500.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-27 12:01:47','',''),('21','238',531,'','customer','16',0.00,1186770.00,'Credit Sales for 1,790.00 Litres of Diesel from shift 33 on 2022-04-27 12:24:45 ','2022-04-27 12:24:45','',''),('21','238',532,'','customer','36',0.00,251940.00,'Credit Sales for 380.00 Litres of Diesel from shift 33 on 2022-04-27 12:24:45 ','2022-04-27 12:24:45','',''),('21','238',533,'','customer','34',0.00,474045.00,'Credit Sales for 715.00 Litres of Diesel from shift 33 on 2022-04-27 12:24:45 ','2022-04-27 12:24:45','',''),('21','238',534,'','customer','35',0.00,10004.67,'Credit Sales for 15.09 Litres of Diesel from shift 33 on 2022-04-27 12:24:45 ','2022-04-27 12:24:45','',''),('21','238',535,'','customer','24',0.00,49996.83,'Credit Sales for 75.41 Litres of Diesel from shift 33 on 2022-04-27 12:24:45 ','2022-04-27 12:24:45','',''),('21','238',536,'','20','2',10058446.75,0.00,'Sales from shift 33 on 2022-04-27 12:24:45 ','2022-04-27 12:24:45','',''),('21','238',537,'','6.1','3',0.00,8085690.25,'Sales from shift 33 on 2022-04-27 12:24:45 ','2022-04-27 12:24:45','',''),('21','238',538,'','2','13',1213100.00,0.00,'Payment Id 301 for invoice:30, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 16:00:45','',''),('21','238',539,'','supplier','1',0.00,1213100.00,'Payment Id 301 for invoice:30, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 16:00:45','',''),('21','238',540,'','2','27',368775.00,0.00,'Payment Id 304 for invoice:28, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 16:01:13','',''),('21','238',541,'','supplier','1',0.00,368775.00,'Payment Id 304 for invoice:28, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 16:01:13','',''),('21','238',542,'','2','13',1617491.00,0.00,'Payment Id 308 for invoice:31, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 16:01:35','',''),('21','238',543,'','supplier','1',0.00,1617491.00,'Payment Id 308 for invoice:31, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 16:01:35','',''),('21','238',544,'','2','18',2488860.00,0.00,'Payment Id 307 for invoice:31, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 16:02:09','',''),('21','238',545,'','supplier','1',0.00,2488860.00,'Payment Id 307 for invoice:31, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 16:02:09','',''),('21','238',546,'','2','27',1748090.00,0.00,'Payment Id 306 for invoice:30, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 16:02:45','',''),('21','238',547,'','supplier','1',0.00,1748090.00,'Payment Id 306 for invoice:30, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 16:02:45','',''),('21','238',548,'','2','27',1939270.00,0.00,'Payment Id 305 for invoice:29, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 16:03:12','',''),('21','238',549,'','supplier','1',0.00,1939270.00,'Payment Id 305 for invoice:29, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 16:03:12','',''),('21','238',550,'','2','13',676950.00,0.00,'Payment Id 289 for invoice:28, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 16:17:09','',''),('21','238',551,'','supplier','1',0.00,676950.00,'Payment Id 289 for invoice:28, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 16:17:09','',''),('21','238',552,'','2','18',523250.00,0.00,'Payment Id 288 for invoice:28, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 16:17:30','',''),('21','238',553,'','supplier','1',0.00,523250.00,'Payment Id 288 for invoice:28, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 16:17:30','',''),('21','238',554,'','2','18',2443740.00,0.00,'Payment Id 287 for invoice:28, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 16:17:55','',''),('21','238',555,'','supplier','1',0.00,2443740.00,'Payment Id 287 for invoice:28, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 16:17:55','',''),('21','238',556,'','2','15',513960.00,0.00,'Payment Id 286 for invoice:28, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 16:18:29','',''),('21','238',557,'','supplier','1',0.00,513960.00,'Payment Id 286 for invoice:28, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 16:18:29','',''),('21','238',558,'','2','15',1068350.00,0.00,'Payment Id 270 for invoice:26, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 16:47:04','',''),('21','238',559,'','supplier','1',0.00,1068350.00,'Payment Id 270 for invoice:26, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 16:47:04','',''),('21','238',560,'','2','18',404540.00,0.00,'Payment Id 269 for invoice:26, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 16:47:26','',''),('21','238',561,'','supplier','1',0.00,404540.00,'Payment Id 269 for invoice:26, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 16:47:26','',''),('21','238',562,'','6.1','3',0.00,404540.00,'Payment Id 269 for invoice:26, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 16:48:15','',''),('21','238',563,'','supplier','1',404540.00,0.00,'Payment Id 269 for invoice:26, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 16:48:15','',''),('21','238',564,'','2','18',32100.00,0.00,'Payment Id 268 for invoice:26, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 16:48:38','',''),('21','238',565,'','supplier','1',0.00,32100.00,'Payment Id 268 for invoice:26, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 16:48:38','',''),('21','238',566,'','2','27',1015955.00,0.00,'Payment Id 267 for invoice:20, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 16:49:03','',''),('21','238',567,'','supplier','1',0.00,1015955.00,'Payment Id 267 for invoice:20, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 16:49:03','',''),('21','238',568,'','2','27',1202605.00,0.00,'Payment Id 266 for invoice:21, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 16:49:26','',''),('21','238',569,'','supplier','1',0.00,1202605.00,'Payment Id 266 for invoice:21, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 16:49:26','',''),('21','238',570,'','2','27',194495.00,0.00,'Payment Id 265 for invoice:22, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 16:49:47','',''),('21','238',571,'','supplier','1',0.00,194495.00,'Payment Id 265 for invoice:22, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 16:49:47','',''),('21','238',572,'','2','27',470665.00,0.00,'Payment Id 264 for invoice:23, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 16:50:11','',''),('21','238',573,'','supplier','1',0.00,470665.00,'Payment Id 264 for invoice:23, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 16:50:11','',''),('21','238',574,'','2','18',1245300.00,0.00,'Payment Id 224 for invoice:19, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 16:57:05','',''),('21','238',575,'','supplier','1',0.00,1245300.00,'Payment Id 224 for invoice:19, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 16:57:05','',''),('21','238',576,'','2','13',1105600.00,0.00,'Payment Id 225 for invoice:19, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 16:59:14','',''),('21','238',577,'','supplier','1',0.00,1105600.00,'Payment Id 225 for invoice:19, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-27 16:59:14','',''),('21','238',578,'','24','5',0.00,2475000.00,'Purchase Id 30 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-28 11:24:26','',''),('21','238',579,'','supplier','1',2475000.00,0.00,'Purchase Id 30 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-28 11:24:26','',''),('21','238',580,'','24','5',0.00,13326300.00,'Purchase Id 31 for 20,100.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-04-28 13:20:46','',''),('21','238',581,'','supplier','1',13326300.00,0.00,'Purchase Id 31 for 20,100.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-04-28 13:20:46','',''),('21','238',582,'','customer','15',0.00,10302.60,'Credit Sales for 62.44 Litres of Petrol from shift 34 on 2022-04-28 14:03:25 ','2022-04-28 14:03:25','',''),('21','238',583,'','customer','8',0.00,164105.76,'Credit Sales for 247.52 Litres of Diesel from shift 34 on 2022-04-28 14:03:25 ','2022-04-28 14:03:25','',''),('21','238',584,'','customer','16',0.00,430950.00,'Credit Sales for 650.00 Litres of Diesel from shift 34 on 2022-04-28 14:03:25 ','2022-04-28 14:03:25','',''),('21','238',585,'','20','2',7816701.56,0.00,'Sales from shift 34 on 2022-04-28 14:03:25 ','2022-04-28 14:03:25','',''),('21','238',586,'','6.1','3',0.00,7211343.20,'Sales from shift 34 on 2022-04-28 14:03:25 ','2022-04-28 14:03:25','',''),('21','238',587,'','2','18',546990.00,0.00,'Payment Id 315 for invoice:32, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-28 17:18:22','',''),('21','238',588,'','supplier','1',0.00,546990.00,'Payment Id 315 for invoice:32, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-28 17:18:22','',''),('21','238',589,'','2','15',2373300.00,0.00,'Payment Id 314 for invoice:32, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-28 17:18:44','',''),('21','238',590,'','supplier','1',0.00,2373300.00,'Payment Id 314 for invoice:32, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-28 17:18:44','',''),('21','238',591,'','2','27',1765705.00,0.00,'Payment Id 313 for invoice:31, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-28 17:19:08','',''),('21','238',592,'','supplier','1',0.00,1765705.00,'Payment Id 313 for invoice:31, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-28 17:19:08','',''),('21','238',593,'','2','15',1503140.00,0.00,'Payment Id 294 for invoice:29, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-28 17:22:45','',''),('21','238',594,'','supplier','1',0.00,1503140.00,'Payment Id 294 for invoice:29, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-28 17:22:45','',''),('21','238',595,'','2','18',2701455.00,0.00,'Payment Id 300 for invoice:30, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-28 17:23:45','',''),('21','238',596,'','supplier','1',0.00,2701455.00,'Payment Id 300 for invoice:30, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-28 17:23:45','',''),('21','238',597,'','2','18',114850.00,0.00,'Payment Id 295 for invoice:29, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-28 17:26:49','',''),('21','238',598,'','supplier','1',0.00,114850.00,'Payment Id 295 for invoice:29, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-28 17:26:49','',''),('21','238',599,'','24','5',0.00,2475000.00,'Purchase Id 32 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-29 08:56:04','',''),('21','238',600,'','supplier','1',2475000.00,0.00,'Purchase Id 32 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-29 08:56:04','',''),('21','238',601,'','customer','12',0.00,36000.90,'Credit Sales for 54.30 Litres of Diesel from shift 35 on 2022-04-29 09:15:07 ','2022-04-29 09:15:07','',''),('21','238',602,'','customer','16',0.00,381225.00,'Credit Sales for 575.00 Litres of Diesel from shift 35 on 2022-04-29 09:15:07 ','2022-04-29 09:15:07','',''),('21','238',603,'','customer','35',0.00,20241.39,'Credit Sales for 30.53 Litres of Diesel from shift 35 on 2022-04-29 09:15:07 ','2022-04-29 09:15:07','',''),('21','238',604,'','customer','9',0.00,198900.00,'Credit Sales for 300.00 Litres of Diesel from shift 35 on 2022-04-29 09:15:07 ','2022-04-29 09:15:07','',''),('21','238',605,'','20','2',4751357.21,0.00,'Sales from shift 35 on 2022-04-29 09:15:07 ','2022-04-29 09:15:07','',''),('21','238',606,'','6.1','3',0.00,4114989.92,'Sales from shift 35 on 2022-04-29 09:15:07 ','2022-04-29 09:15:07','',''),('21','238',607,'','2','27',900155.00,0.00,'Payment Id 341 for invoice:33, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-29 14:59:01','',''),('21','238',608,'','supplier','1',0.00,900155.00,'Payment Id 341 for invoice:33, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-29 14:59:01','',''),('21','238',609,'','2','18',2503235.00,0.00,'Payment Id 322 for invoice:33, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-29 15:07:23','',''),('21','238',610,'','supplier','1',0.00,2503235.00,'Payment Id 322 for invoice:33, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-29 15:07:23','',''),('21','238',611,'','24','5',0.00,8950500.00,'Purchase Id 34 for 13,500.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-04-30 12:44:02','',''),('21','238',612,'','supplier','1',8950500.00,0.00,'Purchase Id 34 for 13,500.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-04-30 12:44:02','',''),('21','238',613,'','24','5',0.00,3300000.00,'Purchase Id 33 for 20,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-30 12:46:52','',''),('21','238',614,'','supplier','1',3300000.00,0.00,'Purchase Id 33 for 20,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-30 12:46:52','',''),('21','238',615,'','customer','16',0.00,430950.00,'Credit Sales for 650.00 Litres of Diesel from shift 36 on 2022-04-30 13:10:20 ','2022-04-30 13:10:20','',''),('21','238',616,'','customer','36',0.00,198900.00,'Credit Sales for 300.00 Litres of Diesel from shift 36 on 2022-04-30 13:10:20 ','2022-04-30 13:10:20','',''),('21','238',617,'','customer','15',0.00,795600.00,'Credit Sales for 1,200.00 Litres of Diesel from shift 36 on 2022-04-30 13:10:20 ','2022-04-30 13:10:20','',''),('21','238',618,'','customer','12',0.00,47000.07,'Credit Sales for 70.89 Litres of Diesel from shift 36 on 2022-04-30 13:10:20 ','2022-04-30 13:10:20','',''),('21','238',619,'','20','2',8832742.11,0.00,'Sales from shift 36 on 2022-04-30 13:10:20 ','2022-04-30 13:10:20','',''),('21','238',620,'','6.1','3',0.00,7360292.04,'Sales from shift 36 on 2022-04-30 13:10:20 ','2022-04-30 13:10:20','',''),('21','238',621,'','24','5',0.00,8250000.00,'Purchase Id 35 for 50,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-01 08:30:59','',''),('21','238',622,'','supplier','1',8250000.00,0.00,'Purchase Id 35 for 50,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-01 08:30:59','',''),('21','238',623,'','customer','16',0.00,1226550.00,'Credit Sales for 1,850.00 Litres of Diesel from shift 37 on 2022-05-01 09:00:52 ','2022-05-01 09:00:52','',''),('21','238',624,'','20','2',7541431.04,0.00,'Sales from shift 37 on 2022-05-01 09:00:52 ','2022-05-01 09:00:52','',''),('21','238',625,'','6.1','3',0.00,6314881.04,'Sales from shift 37 on 2022-05-01 09:00:52 ','2022-05-01 09:00:52','',''),('21','238',626,'','24','5',0.00,3300000.00,'Purchase Id 36 for 20,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-05 12:37:07','',''),('21','238',627,'','supplier','1',3300000.00,0.00,'Purchase Id 36 for 20,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-05 12:37:07','',''),('21','238',628,'','customer','15',0.00,66300.00,'Credit Sales for 100.00 Litres of Diesel from shift 38 on 2022-05-06 11:43:54 ','2022-05-06 11:43:54','',''),('21','238',629,'','20','2',8634058.12,0.00,'Sales from shift 38 on 2022-05-06 11:43:54 ','2022-05-06 11:43:54','',''),('21','238',630,'','6.1','3',0.00,8567758.12,'Sales from shift 38 on 2022-05-06 11:43:54 ','2022-05-06 11:43:54','',''),('21','238',631,'','customer','20',0.00,152403.81,'Credit Sales for 229.87 Litres of Diesel from shift 39 on 2022-05-06 12:37:03 ','2022-05-06 12:37:03','',''),('21','238',632,'','20','2',4385491.40,0.00,'Sales from shift 39 on 2022-05-06 12:37:03 ','2022-05-06 12:37:03','',''),('21','238',633,'','6.1','3',0.00,4233087.59,'Sales from shift 39 on 2022-05-06 12:37:03 ','2022-05-06 12:37:03','',''),('21','238',634,'','24','5',0.00,9945000.00,'Purchase Id 37 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-06 14:21:28','',''),('21','238',635,'','supplier','1',9945000.00,0.00,'Purchase Id 37 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-06 14:21:28','',''),('21','238',636,'','24','5',0.00,9945000.00,'Purchase Id 38 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-06 14:25:20','',''),('21','238',637,'','supplier','1',9945000.00,0.00,'Purchase Id 38 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-06 14:25:20','',''),('21','238',638,'','customer','15',0.00,397800.00,'Credit Sales for 600.00 Litres of Diesel from shift 40 on 2022-05-06 14:37:29 ','2022-05-06 14:37:29','',''),('21','238',639,'','20','2',2947895.84,0.00,'Sales from shift 40 on 2022-05-06 14:37:29 ','2022-05-06 14:37:29','',''),('21','238',640,'','6.1','3',0.00,2550095.84,'Sales from shift 40 on 2022-05-06 14:37:29 ','2022-05-06 14:37:29','',''),('21','238',641,'','customer','34',0.00,397800.00,'Credit Sales for 600.00 Litres of Diesel from shift 41 on 2022-05-06 15:06:37 ','2022-05-06 15:06:37','',''),('21','238',642,'','customer','12',0.00,36000.90,'Credit Sales for 54.30 Litres of Diesel from shift 41 on 2022-05-06 15:06:37 ','2022-05-06 15:06:37','',''),('21','238',643,'','20','2',9504314.77,0.00,'Sales from shift 41 on 2022-05-06 15:06:37 ','2022-05-06 15:06:37','',''),('21','238',644,'','6.1','3',0.00,9070513.87,'Sales from shift 41 on 2022-05-06 15:06:37 ','2022-05-06 15:06:37','',''),('21','238',645,'','24','5',0.00,7425000.00,'Purchase Id 39 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-06 15:29:22','',''),('21','238',646,'','supplier','1',7425000.00,0.00,'Purchase Id 39 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-06 15:29:22','',''),('21','238',647,'','24','5',0.00,2805000.00,'Purchase Id 40 for 17,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-06 15:44:11','',''),('21','238',648,'','supplier','1',2805000.00,0.00,'Purchase Id 40 for 17,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-06 15:44:11','',''),('21','238',649,'','24','5',0.00,3300000.00,'Purchase Id 41 for 20,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-07 14:46:05','',''),('21','238',650,'','supplier','1',3300000.00,0.00,'Purchase Id 41 for 20,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-07 14:46:05','',''),('21','238',651,'','customer','11',0.00,265200.00,'Credit Sales for 400.00 Litres of Diesel from shift 42 on 2022-05-07 16:23:52 ','2022-05-07 16:23:52','',''),('21','238',652,'','customer','34',0.00,364650.00,'Credit Sales for 550.00 Litres of Diesel from shift 42 on 2022-05-07 16:23:52 ','2022-05-07 16:23:52','',''),('21','238',653,'','customer','8',0.00,49095.15,'Credit Sales for 74.05 Litres of Diesel from shift 42 on 2022-05-07 16:23:52 ','2022-05-07 16:23:52','',''),('21','238',654,'','20','2',12366671.04,0.00,'Sales from shift 42 on 2022-05-07 16:23:52 ','2022-05-07 16:23:52','',''),('21','238',655,'','6.1','3',0.00,11687725.89,'Sales from shift 42 on 2022-05-07 16:23:52 ','2022-05-07 16:23:52','',''),('21','238',656,'','24','5',0.00,10170000.00,'Purchase Id 42 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-08 12:37:06','',''),('21','238',657,'','supplier','1',10170000.00,0.00,'Purchase Id 42 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-08 12:37:06','',''),('21','238',658,'','2','27',549500.00,0.00,'Payment Id 401 for invoice:42, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-09 13:46:49','',''),('21','238',659,'','supplier','1',0.00,549500.00,'Payment Id 401 for invoice:42, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-09 13:46:49','',''),('21','238',660,'','2','27',4375.00,0.00,'Payment Id 381 for invoice:40, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-09 13:54:49','',''),('21','238',661,'','supplier','1',0.00,4375.00,'Payment Id 381 for invoice:40, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-09 13:54:49','',''),('21','238',662,'','2','27',95275.00,0.00,'Payment Id 373 for invoice:39, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-09 14:08:24','',''),('21','238',663,'','supplier','1',0.00,95275.00,'Payment Id 373 for invoice:39, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-09 14:08:24','',''),('21','238',664,'','2','15',1803100.00,0.00,'Payment Id 342 for invoice:35, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-09 14:29:22','',''),('21','238',665,'','supplier','1',0.00,1803100.00,'Payment Id 342 for invoice:35, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-09 14:29:22','',''),('21','238',666,'','2','27',1637605.00,0.00,'Payment Id 334 for invoice:34, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-09 14:31:48','',''),('21','238',667,'','supplier','1',0.00,1637605.00,'Payment Id 334 for invoice:34, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-09 14:31:48','',''),('21','238',668,'','2','21',872105.00,0.00,'Payment Id 321 for invoice:32, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-09 14:39:30','',''),('21','238',669,'','supplier','1',0.00,872105.00,'Payment Id 321 for invoice:32, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-09 14:39:30','',''),('21','238',670,'','24','5',0.00,2475000.00,'Purchase Id 43 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-17 13:23:13','',''),('21','238',671,'','supplier','1',2475000.00,0.00,'Purchase Id 43 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-17 13:23:13','',''),('21','238',672,'','24','5',0.00,6270000.00,'Purchase Id 44 for 38,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-17 13:33:03','',''),('21','238',673,'','supplier','1',6270000.00,0.00,'Purchase Id 44 for 38,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-17 13:33:03','',''),('21','238',674,'','20','2',0.00,0.00,'Sales from shift 43 on 2022-05-17 15:47:34 ','2022-05-17 15:47:34','',''),('21','238',675,'','6.1','3',0.00,0.00,'Sales from shift 43 on 2022-05-17 15:47:34 ','2022-05-17 15:47:34','',''),('21','238',676,'','customer','41',0.00,53040.00,'Credit Sales for 80.00 Litres of Diesel from shift 44 on 2022-05-17 16:22:07 ','2022-05-17 16:22:07','',''),('21','238',677,'','customer','41',0.00,53040.00,'Credit Sales for 80.00 Litres of Diesel from shift 44 on 2022-05-17 16:22:07 ','2022-05-17 16:22:07','',''),('21','238',678,'','customer','37',0.00,33150.00,'Credit Sales for 50.00 Litres of Diesel from shift 44 on 2022-05-17 16:22:07 ','2022-05-17 16:22:07','',''),('21','238',679,'','customer','37',0.00,33150.00,'Credit Sales for 50.00 Litres of Diesel from shift 44 on 2022-05-17 16:22:07 ','2022-05-17 16:22:07','',''),('21','238',680,'','customer','34',0.00,474045.00,'Credit Sales for 715.00 Litres of Diesel from shift 44 on 2022-05-17 16:22:07 ','2022-05-17 16:22:07','',''),('21','238',681,'','20','2',11947565.10,0.00,'Sales from shift 44 on 2022-05-17 16:22:07 ','2022-05-17 16:22:07','',''),('21','238',682,'','6.1','3',0.00,11301140.10,'Sales from shift 44 on 2022-05-17 16:22:07 ','2022-05-17 16:22:07','',''),('21','238',683,'','20','2',1497635.28,0.00,'Sales from shift 45 on 2022-05-17 16:40:03 ','2022-05-17 16:40:03','',''),('21','238',684,'','6.1','3',0.00,1497635.28,'Sales from shift 45 on 2022-05-17 16:40:03 ','2022-05-17 16:40:03','',''),('21','238',685,'','customer','12',0.00,103137.36,'Credit Sales for 152.12 Litres of Diesel from shift 46 on 2022-05-17 17:13:31 ','2022-05-17 17:13:31','',''),('21','238',686,'','20','2',9613370.00,0.00,'Sales from shift 46 on 2022-05-17 17:13:31 ','2022-05-17 17:13:31','',''),('21','238',687,'','6.1','3',0.00,9510232.64,'Sales from shift 46 on 2022-05-17 17:13:31 ','2022-05-17 17:13:31','',''),('21','238',688,'','24','5',0.00,30035400.00,'Purchase Id 45 for 44,300.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-17 17:17:43','',''),('21','238',689,'','supplier','1',30035400.00,0.00,'Purchase Id 45 for 44,300.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-17 17:17:43','',''),('21','238',690,'','customer','16',0.00,271200.00,'Credit Sales for 400.00 Litres of Diesel from shift 47 on 2022-05-17 17:49:48 ','2022-05-17 17:49:48','',''),('21','238',691,'','customer','12',0.00,300421.80,'Credit Sales for 443.10 Litres of Diesel from shift 47 on 2022-05-17 17:49:48 ','2022-05-17 17:49:48','',''),('21','238',692,'','customer','42',0.00,121199.28,'Credit Sales for 178.76 Litres of Diesel from shift 47 on 2022-05-17 17:49:48 ','2022-05-17 17:49:48','',''),('21','238',693,'','customer','37',0.00,20340.00,'Credit Sales for 30.00 Litres of Diesel from shift 47 on 2022-05-17 17:49:48 ','2022-05-17 17:49:48','',''),('21','238',694,'','20','2',6440903.51,0.00,'Sales from shift 47 on 2022-05-17 17:49:48 ','2022-05-17 17:49:48','',''),('21','238',695,'','6.1','3',0.00,5727742.43,'Sales from shift 47 on 2022-05-17 17:49:48 ','2022-05-17 17:49:48','',''),('21','238',696,'','customer','37',0.00,33900.00,'Credit Sales for 50.00 Litres of Diesel from shift 48 on 2022-05-17 18:19:22 ','2022-05-17 18:19:22','',''),('21','238',697,'','customer','37',0.00,16950.00,'Credit Sales for 25.00 Litres of Diesel from shift 48 on 2022-05-17 18:19:22 ','2022-05-17 18:19:22','',''),('21','238',698,'','customer','9',0.00,101700.00,'Credit Sales for 150.00 Litres of Diesel from shift 48 on 2022-05-17 18:19:22 ','2022-05-17 18:19:22','',''),('21','238',699,'','customer','16',0.00,372900.00,'Credit Sales for 550.00 Litres of Diesel from shift 48 on 2022-05-17 18:19:22 ','2022-05-17 18:19:22','',''),('21','238',700,'','customer','34',0.00,484770.00,'Credit Sales for 715.00 Litres of Diesel from shift 48 on 2022-05-17 18:19:22 ','2022-05-17 18:19:22','',''),('21','238',701,'','customer','39',0.00,14997.36,'Credit Sales for 22.12 Litres of Diesel from shift 48 on 2022-05-17 18:19:22 ','2022-05-17 18:19:22','',''),('21','238',702,'','customer','36',0.00,145905.60,'Credit Sales for 215.20 Litres of Diesel from shift 48 on 2022-05-17 18:19:22 ','2022-05-17 18:19:22','',''),('21','238',703,'','customer','12',0.00,36001.80,'Credit Sales for 53.10 Litres of Diesel from shift 48 on 2022-05-17 18:19:22 ','2022-05-17 18:19:22','',''),('21','238',704,'','20','2',9379889.30,0.00,'Sales from shift 48 on 2022-05-17 18:19:22 ','2022-05-17 18:19:22','',''),('21','238',705,'','6.1','3',0.00,8172764.54,'Sales from shift 48 on 2022-05-17 18:19:22 ','2022-05-17 18:19:22','',''),('21','238',706,'','24','5',0.00,10770000.00,'Purchase Id 46 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-17 18:30:15','',''),('21','238',707,'','supplier','1',10770000.00,0.00,'Purchase Id 46 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-17 18:30:15','',''),('21','238',708,'','customer','37',0.00,20340.00,'Credit Sales for 30.00 Litres of Diesel from shift 49 on 2022-05-17 19:37:39 ','2022-05-17 19:37:39','',''),('21','238',709,'','customer','37',0.00,33900.00,'Credit Sales for 50.00 Litres of Diesel from shift 49 on 2022-05-17 19:37:39 ','2022-05-17 19:37:39','',''),('21','238',710,'','customer','16',0.00,389850.00,'Credit Sales for 575.00 Litres of Diesel from shift 49 on 2022-05-17 19:37:39 ','2022-05-17 19:37:39','',''),('21','238',711,'','customer','27',0.00,67800.00,'Credit Sales for 100.00 Litres of Diesel from shift 49 on 2022-05-17 19:37:39 ','2022-05-17 19:37:39','',''),('21','238',712,'','customer','3',0.00,13560.00,'Credit Sales for 20.00 Litres of Diesel from shift 49 on 2022-05-17 19:37:39 ','2022-05-17 19:37:39','',''),('21','238',713,'','customer','15',0.00,33900.00,'Credit Sales for 50.00 Litres of Diesel from shift 49 on 2022-05-17 19:37:39 ','2022-05-17 19:37:39','',''),('21','238',714,'','customer','39',0.00,4700.85,'Credit Sales for 28.49 Litres of Petrol from shift 49 on 2022-05-17 19:37:39 ','2022-05-17 19:37:39','',''),('21','238',715,'','20','2',12829044.85,0.00,'Sales from shift 49 on 2022-05-17 19:37:39 ','2022-05-17 19:37:39','',''),('21','238',716,'','6.1','3',0.00,12264994.00,'Sales from shift 49 on 2022-05-17 19:37:39 ','2022-05-17 19:37:39','',''),('21','238',717,'','customer','37',0.00,16950.00,'Credit Sales for 25.00 Litres of Diesel from shift 50 on 2022-05-17 21:17:13 ','2022-05-17 21:17:13','',''),('21','238',718,'','customer','37',0.00,67800.00,'Credit Sales for 100.00 Litres of Diesel from shift 50 on 2022-05-17 21:17:13 ','2022-05-17 21:17:13','',''),('21','238',719,'','customer','37',0.00,33900.00,'Credit Sales for 50.00 Litres of Diesel from shift 50 on 2022-05-17 21:17:13 ','2022-05-17 21:17:13','',''),('21','238',720,'','customer','8',0.00,33900.00,'Credit Sales for 50.00 Litres of Diesel from shift 50 on 2022-05-17 21:17:13 ','2022-05-17 21:17:13','',''),('21','238',721,'','customer','9',0.00,335610.00,'Credit Sales for 495.00 Litres of Diesel from shift 50 on 2022-05-17 21:17:13 ','2022-05-17 21:17:13','',''),('21','238',722,'','20','2',9222224.68,0.00,'Sales from shift 50 on 2022-05-17 21:17:13 ','2022-05-17 21:17:13','',''),('21','238',723,'','6.1','3',0.00,8734064.68,'Sales from shift 50 on 2022-05-17 21:17:13 ','2022-05-17 21:17:13','',''),('21','238',724,'','20','2',72637.50,0.00,'Sales from shift 51 on 2022-05-18 13:45:22 ','2022-05-18 13:45:22','',''),('21','238',725,'','6.1','3',0.00,72637.50,'Sales from shift 51 on 2022-05-18 13:45:22 ','2022-05-18 13:45:22','',''),('21','238',726,'','20','2',58662.50,0.00,'Sales from shift 52 on 2022-05-18 13:57:38 ','2022-05-18 13:57:38','',''),('21','238',727,'','6.1','3',0.00,58662.50,'Sales from shift 52 on 2022-05-18 13:57:38 ','2022-05-18 13:57:38','',''),('21','238',728,'','2','27',18485.00,0.00,'Payment Id 462 for invoice:52, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-18 14:56:09','',''),('21','238',729,'','supplier','1',0.00,18485.00,'Payment Id 462 for invoice:52, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-18 14:56:09','',''),('21','238',730,'','2','27',547570.00,0.00,'Payment Id 453 for invoice:49, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-18 15:12:23','',''),('21','238',731,'','supplier','1',0.00,547570.00,'Payment Id 453 for invoice:49, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-18 15:12:23','',''),('21','238',732,'','24','5',0.00,10770000.00,'Purchase Id 47 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-18 15:57:04','',''),('21','238',733,'','supplier','1',10770000.00,0.00,'Purchase Id 47 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-18 15:57:04','',''),('21','238',734,'','customer','12',0.00,5999.40,'Credit Sales for 36.36 Litres of Petrol from shift 53 on 2022-05-18 16:39:27 ','2022-05-18 16:39:27','',''),('21','238',735,'','customer','27',0.00,107700.00,'Credit Sales for 150.00 Litres of Diesel from shift 53 on 2022-05-18 16:39:27 ','2022-05-18 16:39:27','',''),('21','238',736,'','customer','15',0.00,35900.00,'Credit Sales for 50.00 Litres of Diesel from shift 53 on 2022-05-18 16:39:27 ','2022-05-18 16:39:27','',''),('21','238',737,'','20','2',6038403.82,0.00,'Sales from shift 53 on 2022-05-18 16:39:27 ','2022-05-18 16:39:27','',''),('21','238',738,'','6.1','3',0.00,5888804.42,'Sales from shift 53 on 2022-05-18 16:39:27 ','2022-05-18 16:39:27','',''),('21','238',739,'','customer','37',0.00,71800.00,'Credit Sales for 100.00 Litres of Diesel from shift 54 on 2022-05-18 17:05:07 ','2022-05-18 17:05:07','',''),('21','238',740,'','customer','37',0.00,35900.00,'Credit Sales for 50.00 Litres of Diesel from shift 54 on 2022-05-18 17:05:07 ','2022-05-18 17:05:07','',''),('21','238',741,'','customer','12',0.00,103341.74,'Credit Sales for 143.93 Litres of Diesel from shift 54 on 2022-05-18 17:05:07 ','2022-05-18 17:05:07','',''),('21','238',742,'','customer','12',0.00,17950.00,'Credit Sales for 25.00 Litres of Diesel from shift 54 on 2022-05-18 17:05:07 ','2022-05-18 17:05:07','',''),('21','238',743,'','customer','15',0.00,29998.04,'Credit Sales for 41.78 Litres of Diesel from shift 54 on 2022-05-18 17:05:07 ','2022-05-18 17:05:07','',''),('21','238',744,'','20','2',7726177.00,0.00,'Sales from shift 54 on 2022-05-18 17:05:07 ','2022-05-18 17:05:07','',''),('21','238',745,'','6.1','3',0.00,7467187.22,'Sales from shift 54 on 2022-05-18 17:05:07 ','2022-05-18 17:05:07','',''),('21','238',746,'','customer','12',0.00,5999.50,'Credit Sales for 9.23 Litres of Kerosene from shift 55 on 2022-05-18 17:16:05 ','2022-05-18 17:16:05','',''),('21','238',747,'','20','2',76011.00,0.00,'Sales from shift 55 on 2022-05-18 17:16:05 ','2022-05-18 17:16:05','',''),('21','238',748,'','6.1','3',0.00,70011.50,'Sales from shift 55 on 2022-05-18 17:16:05 ','2022-05-18 17:16:05','',''),('21','238',749,'','24','5',0.00,2722500.00,'Purchase Id 48 for 16,500.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-18 17:22:45','',''),('21','238',750,'','supplier','1',2722500.00,0.00,'Purchase Id 48 for 16,500.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-18 17:22:45','',''),('21','238',751,'','customer','37',0.00,93340.00,'Credit Sales for 130.00 Litres of Diesel from shift 56 on 2022-05-18 17:58:53 ','2022-05-18 17:58:53','',''),('21','238',752,'','customer','37',0.00,93340.00,'Credit Sales for 130.00 Litres of Diesel from shift 56 on 2022-05-18 17:58:53 ','2022-05-18 17:58:53','',''),('21','238',753,'','customer','37',0.00,93340.00,'Credit Sales for 130.00 Litres of Diesel from shift 56 on 2022-05-18 17:58:53 ','2022-05-18 17:58:53','',''),('21','238',754,'','customer','37',0.00,143600.00,'Credit Sales for 200.00 Litres of Diesel from shift 56 on 2022-05-18 17:58:53 ','2022-05-18 17:58:53','',''),('21','238',755,'','customer','37',0.00,93340.00,'Credit Sales for 130.00 Litres of Diesel from shift 56 on 2022-05-18 17:58:53 ','2022-05-18 17:58:53','',''),('21','238',756,'','customer','12',0.00,20003.48,'Credit Sales for 27.86 Litres of Diesel from shift 56 on 2022-05-18 17:58:53 ','2022-05-18 17:58:53','',''),('21','238',757,'','customer','20',0.00,129240.00,'Credit Sales for 180.00 Litres of Diesel from shift 56 on 2022-05-18 17:58:53 ','2022-05-18 17:58:53','',''),('21','238',758,'','customer','39',0.00,11000.55,'Credit Sales for 66.67 Litres of Petrol from shift 56 on 2022-05-18 17:58:53 ','2022-05-18 17:58:53','',''),('21','238',759,'','customer','42',0.00,3102.00,'Credit Sales for 18.80 Litres of Petrol from shift 56 on 2022-05-18 17:58:53 ','2022-05-18 17:58:53','',''),('21','238',760,'','20','2',9502163.12,0.00,'Sales from shift 56 on 2022-05-18 17:58:53 ','2022-05-18 17:58:53','',''),('21','238',761,'','6.1','3',0.00,8821857.09,'Sales from shift 56 on 2022-05-18 17:58:53 ','2022-05-18 17:58:53','',''),('21','238',762,'','24','5',0.00,2475000.00,'Purchase Id 49 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-18 18:01:26','',''),('21','238',763,'','supplier','1',2475000.00,0.00,'Purchase Id 49 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-18 18:01:26','',''),('21','238',764,'','24','5',0.00,2640000.00,'Purchase Id 50 for 16,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-19 11:31:34','',''),('21','238',765,'','supplier','1',2640000.00,0.00,'Purchase Id 50 for 16,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-19 11:31:34','',''),('21','238',766,'','24','5',0.00,10770000.00,'Purchase Id 51 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-19 16:55:21','',''),('21','238',767,'','supplier','1',10770000.00,0.00,'Purchase Id 51 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-19 16:55:21','',''),('21','238',768,'','2','15',2731670.00,0.00,'Payment Id 479 for invoice:56, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-19 17:36:13','',''),('21','238',769,'','supplier','1',0.00,2731670.00,'Payment Id 479 for invoice:56, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-19 17:36:13','',''),('21','238',770,'','customer','12',0.00,100520.00,'Credit Sales for 140.00 Litres of Diesel from shift 57 on 2022-05-20 09:15:59 ','2022-05-20 09:15:59','',''),('21','238',771,'','customer','39',0.00,14999.02,'Credit Sales for 20.89 Litres of Diesel from shift 57 on 2022-05-20 09:15:59 ','2022-05-20 09:15:59','',''),('21','238',772,'','20','2',10124882.48,0.00,'Sales from shift 57 on 2022-05-20 09:15:59 ','2022-05-20 09:15:59','',''),('21','238',773,'','6.1','3',0.00,10009363.46,'Sales from shift 57 on 2022-05-20 09:15:59 ','2022-05-20 09:15:59','',''),('21','238',774,'','24','5',0.00,2475000.00,'Purchase Id 52 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-20 09:26:34','',''),('21','238',775,'','supplier','1',2475000.00,0.00,'Purchase Id 52 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-20 09:26:34','',''),('21','238',776,'','customer','16',0.00,412850.00,'Credit Sales for 575.00 Litres of Diesel from shift 58 on 2022-05-20 09:52:52 ','2022-05-20 09:52:52','',''),('21','238',777,'','customer','11',0.00,21540.00,'Credit Sales for 30.00 Litres of Diesel from shift 58 on 2022-05-20 09:52:52 ','2022-05-20 09:52:52','',''),('21','238',778,'','customer','12',0.00,57440.00,'Credit Sales for 80.00 Litres of Diesel from shift 58 on 2022-05-20 09:52:52 ','2022-05-20 09:52:52','',''),('21','238',779,'','customer','42',0.00,79999.56,'Credit Sales for 111.42 Litres of Diesel from shift 58 on 2022-05-20 09:52:52 ','2022-05-20 09:52:52','',''),('21','238',780,'','20','2',8778231.20,0.00,'Sales from shift 58 on 2022-05-20 09:52:52 ','2022-05-20 09:52:52','',''),('21','238',781,'','6.1','3',0.00,8206401.64,'Sales from shift 58 on 2022-05-20 09:52:52 ','2022-05-20 09:52:52','',''),('21','238',782,'','24','5',0.00,10411000.00,'Purchase Id 53 for 14,500.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-22 17:32:34','',''),('21','238',783,'','supplier','1',10411000.00,0.00,'Purchase Id 53 for 14,500.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-22 17:32:34','',''),('21','238',784,'','customer','11',0.00,193860.00,'Credit Sales for 270.00 Litres of Diesel from shift 59 on 2022-05-22 18:06:25 ','2022-05-22 18:06:25','',''),('21','238',785,'','customer','12',0.00,50260.00,'Credit Sales for 70.00 Litres of Diesel from shift 59 on 2022-05-22 18:06:25 ','2022-05-22 18:06:25','',''),('21','238',786,'','20','2',6350946.21,0.00,'Sales from shift 59 on 2022-05-22 18:06:25 ','2022-05-22 18:06:25','',''),('21','238',787,'','6.1','3',0.00,6106826.21,'Sales from shift 59 on 2022-05-22 18:06:25 ','2022-05-22 18:06:25','',''),('21','238',788,'','24','5',0.00,2640000.00,'Purchase Id 54 for 16,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-22 18:10:21','',''),('21','238',789,'','supplier','1',2640000.00,0.00,'Purchase Id 54 for 16,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-22 18:10:21','',''),('21','238',790,'','customer','3',0.00,168205.86,'Credit Sales for 234.27 Litres of Diesel from shift 60 on 2022-05-22 18:25:50 ','2022-05-22 18:25:50','',''),('21','238',791,'','customer','18',0.00,65000.54,'Credit Sales for 90.53 Litres of Diesel from shift 60 on 2022-05-22 18:25:50 ','2022-05-22 18:25:50','',''),('21','238',792,'','20','2',4987103.76,0.00,'Sales from shift 60 on 2022-05-22 18:25:50 ','2022-05-22 18:25:50','',''),('21','238',793,'','6.1','3',0.00,4753897.36,'Sales from shift 60 on 2022-05-22 18:25:50 ','2022-05-22 18:25:50','',''),('21','238',794,'','24','5',0.00,4950000.00,'Purchase Id 55 for 30,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-24 08:14:56','',''),('21','238',795,'','supplier','1',4950000.00,0.00,'Purchase Id 55 for 30,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-24 08:14:56','',''),('21','238',796,'','customer','2',0.00,43080.00,'Credit Sales for 60.00 Litres of Diesel from shift 61 on 2022-05-25 15:03:37 ','2022-05-25 15:03:37','',''),('21','238',797,'','20','2',6601478.68,0.00,'Sales from shift 61 on 2022-05-25 15:03:37 ','2022-05-25 15:03:37','',''),('21','238',798,'','6.1','3',0.00,6558398.68,'Sales from shift 61 on 2022-05-25 15:03:37 ','2022-05-25 15:03:37','',''),('21','238',799,'','20','2',2839669.92,0.00,'Sales from shift 62 on 2022-05-25 15:45:28 ','2022-05-25 15:45:28','',''),('21','238',800,'','6.1','3',0.00,2839669.92,'Sales from shift 62 on 2022-05-25 15:45:28 ','2022-05-25 15:45:28','',''),('21','238',801,'','customer','12',0.00,36003.50,'Credit Sales for 55.39 Litres of Kerosene from shift 63 on 2022-05-25 15:54:41 ','2022-05-25 15:54:41','',''),('21','238',802,'','20','2',145249.00,0.00,'Sales from shift 63 on 2022-05-25 15:54:41 ','2022-05-25 15:54:41','',''),('21','238',803,'','6.1','3',0.00,109245.50,'Sales from shift 63 on 2022-05-25 15:54:41 ','2022-05-25 15:54:41','',''),('21','238',804,'','24','5',0.00,2475000.00,'Purchase Id 56 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-25 16:12:22','',''),('21','238',805,'','supplier','1',2475000.00,0.00,'Purchase Id 56 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-25 16:12:22','',''),('21','238',806,'','customer','39',0.00,11000.55,'Credit Sales for 66.67 Litres of Petrol from shift 64 on 2022-05-25 16:41:07 ','2022-05-25 16:41:07','',''),('21','238',807,'','20','2',3826022.90,0.00,'Sales from shift 64 on 2022-05-25 16:41:07 ','2022-05-25 16:41:07','',''),('21','238',808,'','6.1','3',0.00,3815022.35,'Sales from shift 64 on 2022-05-25 16:41:07 ','2022-05-25 16:41:07','',''),('21','238',809,'','2','18',1789240.00,0.00,'Payment Id 514 for invoice:60, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-26 12:30:14','',''),('21','238',810,'','supplier','1',0.00,1789240.00,'Payment Id 514 for invoice:60, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-26 12:30:14','',''),('21','238',811,'','2','27',108050.00,0.00,'Payment Id 506 for invoice:57, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-26 12:31:03','',''),('21','238',812,'','supplier','1',0.00,108050.00,'Payment Id 506 for invoice:57, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-26 12:31:03','',''),('21','238',813,'','2','27',1813680.00,0.00,'Payment Id 505 for invoice:58, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-26 12:31:24','',''),('21','238',814,'','supplier','1',0.00,1813680.00,'Payment Id 505 for invoice:58, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-26 12:31:24','',''),('21','238',815,'','2','27',2475700.00,0.00,'Payment Id 534 for invoice:64, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-26 12:45:05','',''),('21','238',816,'','supplier','1',0.00,2475700.00,'Payment Id 534 for invoice:64, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-26 12:45:05','',''),('21','238',817,'','2','12',773065.00,0.00,'Payment Id 533 for invoice:64, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-26 12:46:25','',''),('21','238',818,'','supplier','1',0.00,773065.00,'Payment Id 533 for invoice:64, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-26 12:46:25','',''),('21','238',819,'','2','13',155800.00,0.00,'Payment Id 530 for invoice:64, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-26 12:46:44','',''),('21','238',820,'','supplier','1',0.00,155800.00,'Payment Id 530 for invoice:64, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-26 12:46:44','',''),('21','238',821,'','2','15',2182950.00,0.00,'Payment Id 487 for invoice:57, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-26 12:56:32','',''),('21','238',822,'','supplier','1',0.00,2182950.00,'Payment Id 487 for invoice:57, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-26 12:56:32','',''),('21','238',823,'','2','13',1983740.00,0.00,'Payment Id 472 for invoice:54, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-26 14:17:06','',''),('21','238',824,'','supplier','1',0.00,1983740.00,'Payment Id 472 for invoice:54, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-26 14:17:06','',''),('21','238',825,'','2','18',1977000.00,0.00,'Payment Id 464 for invoice:53, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-26 14:20:58','',''),('21','238',826,'','supplier','1',0.00,1977000.00,'Payment Id 464 for invoice:53, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-26 14:20:58','',''),('21','238',827,'','2','27',526510.00,0.00,'Payment Id 452 for invoice:48, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-26 14:32:54','',''),('21','238',828,'','supplier','1',0.00,526510.00,'Payment Id 452 for invoice:48, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-26 14:32:54','',''),('21','238',829,'','2','27',2235045.00,0.00,'Payment Id 451 for invoice:47, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-26 14:33:14','',''),('21','238',830,'','supplier','1',0.00,2235045.00,'Payment Id 451 for invoice:47, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-26 14:33:14','',''),('21','238',831,'','2','27',3915620.00,0.00,'Payment Id 450 for invoice:46, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-26 14:33:34','',''),('21','238',832,'','supplier','1',0.00,3915620.00,'Payment Id 450 for invoice:46, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-26 14:33:34','',''),('21','238',833,'','2','27',3808585.00,0.00,'Payment Id 449 for invoice:44, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-26 14:33:54','',''),('21','238',834,'','supplier','1',0.00,3808585.00,'Payment Id 449 for invoice:44, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-26 14:33:54','',''),('21','238',835,'','2','27',549500.00,0.00,'Payment Id 448 for invoice:42, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-26 14:34:12','',''),('21','238',836,'','supplier','1',0.00,549500.00,'Payment Id 448 for invoice:42, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-26 14:34:12','',''),('21','238',837,'','2','27',2885270.00,0.00,'Payment Id 447 for invoice:42, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-26 14:34:34','',''),('21','238',838,'','supplier','1',0.00,2885270.00,'Payment Id 447 for invoice:42, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-26 14:34:34','',''),('21','238',839,'','2','13',936865.00,0.00,'Payment Id 429 for invoice:48, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-26 14:39:18','',''),('21','238',840,'','supplier','1',0.00,936865.00,'Payment Id 429 for invoice:48, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-26 14:39:18','',''),('21','238',841,'','2','18',222860.00,0.00,'Payment Id 529 for invoice:64, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-30 08:50:21','',''),('21','238',842,'','supplier','1',0.00,222860.00,'Payment Id 529 for invoice:64, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-30 08:50:21','',''),('21','238',843,'','2','15',122500.00,0.00,'Payment Id 528 for invoice:64, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-30 08:53:53','',''),('21','238',844,'','supplier','1',0.00,122500.00,'Payment Id 528 for invoice:64, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-30 08:53:53','',''),('21','238',845,'','2','27',70670.00,0.00,'Payment Id 535 for invoice:63, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-30 08:54:06','',''),('21','238',846,'','supplier','1',0.00,70670.00,'Payment Id 535 for invoice:63, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-30 08:54:06','',''),('21','238',847,'','2','27',3000000.00,0.00,'Payment Id 485 for invoice:56, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-30 09:06:22','',''),('21','238',848,'','supplier','1',0.00,3000000.00,'Payment Id 485 for invoice:56, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-30 09:06:22','',''),('21','238',849,'','2','27',827060.00,0.00,'Payment Id 484 for invoice:56, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-30 09:06:43','',''),('21','238',850,'','supplier','1',0.00,827060.00,'Payment Id 484 for invoice:56, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-30 09:06:43','',''),('21','238',851,'','2','27',48600.00,0.00,'Payment Id 470 for invoice:53, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-30 09:17:49','',''),('21','238',852,'','supplier','1',0.00,48600.00,'Payment Id 470 for invoice:53, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-30 09:17:49','',''),('21','238',853,'','2','15',3200750.00,0.00,'Payment Id 385 for invoice:41, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-30 10:10:22','',''),('21','238',854,'','supplier','1',0.00,3200750.00,'Payment Id 385 for invoice:41, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-30 10:10:22','',''),('21','238',855,'','2','13',999000.00,0.00,'Payment Id 386 for invoice:41, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-30 10:10:47','',''),('21','238',856,'','supplier','1',0.00,999000.00,'Payment Id 386 for invoice:41, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-30 10:10:47','',''),('21','238',857,'','2','27',408905.00,0.00,'Payment Id 387 for invoice:41, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-30 10:11:15','',''),('21','238',858,'','supplier','1',0.00,408905.00,'Payment Id 387 for invoice:41, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-30 10:11:15','',''),('21','238',859,'','24','5',0.00,2970000.00,'Purchase Id 57 for 18,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-30 10:39:05','',''),('21','238',860,'','supplier','1',2970000.00,0.00,'Purchase Id 57 for 18,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-30 10:39:05','',''),('21','238',861,'','24','5',0.00,2475000.00,'Purchase Id 58 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-30 10:56:01','',''),('21','238',862,'','supplier','1',2475000.00,0.00,'Purchase Id 58 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-30 10:56:01','',''),('21','238',863,'','24','5',0.00,10612000.00,'Purchase Id 59 for 14,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-30 11:02:58','',''),('21','238',864,'','supplier','1',10612000.00,0.00,'Purchase Id 59 for 14,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-30 11:02:58','',''),('21','238',865,'','customer','37',0.00,98540.00,'Credit Sales for 130.00 Litres of Diesel from shift 65 on 2022-05-30 12:14:55 ','2022-05-30 12:14:55','',''),('21','238',866,'','customer','41',0.00,113700.00,'Credit Sales for 150.00 Litres of Diesel from shift 65 on 2022-05-30 12:14:55 ','2022-05-30 12:14:55','',''),('21','238',867,'','20','2',5578641.85,0.00,'Sales from shift 65 on 2022-05-30 12:14:55 ','2022-05-30 12:14:55','',''),('21','238',868,'','6.1','3',0.00,5366401.85,'Sales from shift 65 on 2022-05-30 12:14:55 ','2022-05-30 12:14:55','',''),('21','238',869,'','24','5',0.00,11370000.00,'Purchase Id 60 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-30 17:02:48','',''),('21','238',870,'','supplier','1',11370000.00,0.00,'Purchase Id 60 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-30 17:02:48','',''),('21','238',871,'','customer','16',0.00,413110.00,'Credit Sales for 545.00 Litres of Diesel from shift 66 on 2022-05-30 17:31:12 ','2022-05-30 17:31:12','',''),('21','238',872,'','customer','16',0.00,151600.00,'Credit Sales for 200.00 Litres of Diesel from shift 66 on 2022-05-30 17:31:12 ','2022-05-30 17:31:12','',''),('21','238',873,'','customer','37',0.00,45480.00,'Credit Sales for 60.00 Litres of Diesel from shift 66 on 2022-05-30 17:31:12 ','2022-05-30 17:31:12','',''),('21','238',874,'','customer','37',0.00,45480.00,'Credit Sales for 60.00 Litres of Diesel from shift 66 on 2022-05-30 17:31:12 ','2022-05-30 17:31:12','',''),('21','238',875,'','customer','24',0.00,100002.94,'Credit Sales for 131.93 Litres of Diesel from shift 66 on 2022-05-30 17:31:12 ','2022-05-30 17:31:12','',''),('21','238',876,'','customer','3',0.00,137599.74,'Credit Sales for 181.53 Litres of Diesel from shift 66 on 2022-05-30 17:31:12 ','2022-05-30 17:31:12','',''),('21','238',877,'','20','2',8575066.90,0.00,'Sales from shift 66 on 2022-05-30 17:31:12 ','2022-05-30 17:31:12','',''),('21','238',878,'','6.1','3',0.00,7681794.22,'Sales from shift 66 on 2022-05-30 17:31:12 ','2022-05-30 17:31:12','',''),('21','238',879,'','customer','37',0.00,22740.00,'Credit Sales for 30.00 Litres of Diesel from shift 67 on 2022-05-30 17:47:05 ','2022-05-30 17:47:05','',''),('21','238',880,'','20','2',6719563.34,0.00,'Sales from shift 67 on 2022-05-30 17:47:05 ','2022-05-30 17:47:05','',''),('21','238',881,'','6.1','3',0.00,6696823.34,'Sales from shift 67 on 2022-05-30 17:47:05 ','2022-05-30 17:47:05','',''),('21','238',882,'','customer','37',0.00,22740.00,'Credit Sales for 30.00 Litres of Diesel from shift 68 on 2022-05-30 18:12:40 ','2022-05-30 18:12:40','',''),('21','238',883,'','customer','9',0.00,115003.76,'Credit Sales for 151.72 Litres of Diesel from shift 68 on 2022-05-30 18:12:40 ','2022-05-30 18:12:40','',''),('21','238',884,'','customer','16',0.00,151600.00,'Credit Sales for 200.00 Litres of Diesel from shift 68 on 2022-05-30 18:12:40 ','2022-05-30 18:12:40','',''),('21','238',885,'','20','2',7352659.00,0.00,'Sales from shift 68 on 2022-05-30 18:12:40 ','2022-05-30 18:12:40','',''),('21','238',886,'','6.1','3',0.00,7063315.24,'Sales from shift 68 on 2022-05-30 18:12:40 ','2022-05-30 18:12:40','',''),('21','238',887,'','customer','37',0.00,43206.00,'Credit Sales for 57.00 Litres of Diesel from shift 69 on 2022-05-30 18:24:11 ','2022-05-30 18:24:11','',''),('21','238',888,'','20','2',3155057.08,0.00,'Sales from shift 69 on 2022-05-30 18:24:11 ','2022-05-30 18:24:11','',''),('21','238',889,'','6.1','3',0.00,3111851.08,'Sales from shift 69 on 2022-05-30 18:24:11 ','2022-05-30 18:24:11','',''),('21','238',890,'','24','5',0.00,11370000.00,'Purchase Id 61 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-31 10:55:00','',''),('21','238',891,'','supplier','1',11370000.00,0.00,'Purchase Id 61 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-31 10:55:00','',''),('21','238',892,'','20','2',3402718.26,0.00,'Sales from shift 70 on 2022-06-01 12:28:53 ','2022-06-01 12:28:53','',''),('21','238',893,'','6.1','3',0.00,3402718.26,'Sales from shift 70 on 2022-06-01 12:28:53 ','2022-06-01 12:28:53','',''),('21','238',894,'','24','5',0.00,2293500.00,'Purchase Id 62 for 13,900.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-01 12:49:21','',''),('21','238',895,'','supplier','1',2293500.00,0.00,'Purchase Id 62 for 13,900.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-01 12:49:21','',''),('21','238',896,'','24','5',0.00,25772000.00,'Purchase Id 63 for 34,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-01 13:48:08','',''),('21','238',897,'','supplier','1',25772000.00,0.00,'Purchase Id 63 for 34,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-01 13:48:08','',''),('21','238',898,'','customer','2',0.00,21982.00,'Credit Sales for 29.00 Litres of Diesel from shift 71 on 2022-06-01 15:34:00 ','2022-06-01 15:34:00','',''),('21','238',899,'','customer','2',0.00,64998.50,'Credit Sales for 85.75 Litres of Diesel from shift 71 on 2022-06-01 15:34:00 ','2022-06-01 15:34:00','',''),('21','238',900,'','customer','14',0.00,568500.00,'Credit Sales for 750.00 Litres of Diesel from shift 71 on 2022-06-01 15:34:00 ','2022-06-01 15:34:00','',''),('21','238',901,'','customer','37',0.00,151600.00,'Credit Sales for 200.00 Litres of Diesel from shift 71 on 2022-06-01 15:34:00 ','2022-06-01 15:34:00','',''),('21','238',902,'','customer','39',0.00,15000.82,'Credit Sales for 19.79 Litres of Diesel from shift 71 on 2022-06-01 15:34:00 ','2022-06-01 15:34:00','',''),('21','238',903,'','20','2',8753771.94,0.00,'Sales from shift 71 on 2022-06-01 15:34:00 ','2022-06-01 15:34:00','',''),('21','238',904,'','6.1','3',0.00,7931690.62,'Sales from shift 71 on 2022-06-01 15:34:00 ','2022-06-01 15:34:00','',''),('21','238',905,'','24','5',0.00,2805000.00,'Purchase Id 64 for 17,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-02 11:58:52','',''),('21','238',906,'','supplier','1',2805000.00,0.00,'Purchase Id 64 for 17,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-02 11:58:52','',''),('21','238',907,'','20','2',6422233.89,0.00,'Sales from shift 72 on 2022-06-02 12:53:42 ','2022-06-02 12:53:42','',''),('21','238',908,'','6.1','3',0.00,6422233.89,'Sales from shift 72 on 2022-06-02 12:53:42 ','2022-06-02 12:53:42','',''),('21','238',909,'','24','5',0.00,2475000.00,'Purchase Id 65 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-06 14:04:41','',''),('21','238',910,'','supplier','1',2475000.00,0.00,'Purchase Id 65 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-06 14:04:41','',''),('21','238',911,'','24','5',0.00,11370000.00,'Purchase Id 66 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-06 14:50:55','',''),('21','238',912,'','supplier','1',11370000.00,0.00,'Purchase Id 66 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-06 14:50:55','',''),('21','238',913,'','24','5',0.00,2475000.00,'Purchase Id 67 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-06 15:27:59','',''),('21','238',914,'','supplier','1',2475000.00,0.00,'Purchase Id 67 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-06 15:27:59','',''),('21','238',915,'','customer','15',0.00,758000.00,'Credit Sales for 1,000.00 Litres of Diesel from shift 73 on 2022-06-06 16:19:25 ','2022-06-06 16:19:25','',''),('21','238',916,'','customer','16',0.00,75800.00,'Credit Sales for 100.00 Litres of Diesel from shift 73 on 2022-06-06 16:19:25 ','2022-06-06 16:19:25','',''),('21','238',917,'','customer','37',0.00,30320.00,'Credit Sales for 40.00 Litres of Diesel from shift 73 on 2022-06-06 16:19:25 ','2022-06-06 16:19:25','',''),('21','238',918,'','20','2',12536012.44,0.00,'Sales from shift 73 on 2022-06-06 16:19:25 ','2022-06-06 16:19:25','',''),('21','238',919,'','6.1','3',0.00,11671892.44,'Sales from shift 73 on 2022-06-06 16:19:25 ','2022-06-06 16:19:25','',''),('21','238',920,'','2','27',3094530.00,0.00,'Payment Id 591 for invoice:67, receipt:  by AYM SHAFA NIGERIA. LTD','2022-06-06 16:44:57','',''),('21','238',921,'','supplier','1',0.00,3094530.00,'Payment Id 591 for invoice:67, receipt:  by AYM SHAFA NIGERIA. LTD','2022-06-06 16:44:57','',''),('21','238',922,'','customer','37',0.00,45480.00,'Credit Sales for 60.00 Litres of Diesel from shift 74 on 2022-06-06 16:45:49 ','2022-06-06 16:45:49','',''),('21','238',923,'','customer','38',0.00,75800.00,'Credit Sales for 100.00 Litres of Diesel from shift 74 on 2022-06-06 16:45:49 ','2022-06-06 16:45:49','',''),('21','238',924,'','customer','22',0.00,310780.00,'Credit Sales for 410.00 Litres of Diesel from shift 74 on 2022-06-06 16:45:49 ','2022-06-06 16:45:49','',''),('21','238',925,'','20','2',5354917.72,0.00,'Sales from shift 74 on 2022-06-06 16:45:49 ','2022-06-06 16:45:49','',''),('21','238',926,'','6.1','3',0.00,4922857.72,'Sales from shift 74 on 2022-06-06 16:45:49 ','2022-06-06 16:45:49','',''),('21','238',927,'','2','27',2566180.00,0.00,'Payment Id 592 for invoice:68, receipt:  by AYM SHAFA NIGERIA. LTD','2022-06-06 16:46:28','',''),('21','238',928,'','supplier','1',0.00,2566180.00,'Payment Id 592 for invoice:68, receipt:  by AYM SHAFA NIGERIA. LTD','2022-06-06 16:46:28','',''),('21','238',929,'','2','18',1216432.00,0.00,'Payment Id 573 for invoice:69, receipt:  by AYM SHAFA NIGERIA. LTD','2022-06-06 16:50:14','',''),('21','238',930,'','supplier','1',0.00,1216432.00,'Payment Id 573 for invoice:69, receipt:  by AYM SHAFA NIGERIA. LTD','2022-06-06 16:50:14','',''),('21','238',931,'','20','2',5221225.28,0.00,'Sales from shift 75 on 2022-06-06 16:59:58 ','2022-06-06 16:59:58','',''),('21','238',932,'','6.1','3',0.00,5221225.28,'Sales from shift 75 on 2022-06-06 16:59:58 ','2022-06-06 16:59:58','',''),('21','238',933,'','customer','37',0.00,77800.00,'Credit Sales for 100.00 Litres of Diesel from shift 76 on 2022-06-06 17:52:25 ','2022-06-06 17:52:25','',''),('21','238',934,'','20','2',3555063.27,0.00,'Sales from shift 76 on 2022-06-06 17:52:25 ','2022-06-06 17:52:25','',''),('21','238',935,'','6.1','3',0.00,3477263.27,'Sales from shift 76 on 2022-06-06 17:52:25 ','2022-06-06 17:52:25','',''),('21','238',936,'','24','5',0.00,4950000.00,'Purchase Id 68 for 30,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-07 13:05:25','',''),('21','238',937,'','supplier','1',4950000.00,0.00,'Purchase Id 68 for 30,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-07 13:05:25','',''),('21','238',938,'','24','5',0.00,11670000.00,'Purchase Id 69 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-07 13:50:33','',''),('21','238',939,'','supplier','1',11670000.00,0.00,'Purchase Id 69 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-07 13:50:33','',''),('21','238',940,'','customer','17',0.00,194500.00,'Credit Sales for 250.00 Litres of Diesel from shift 77 on 2022-06-07 14:58:58 ','2022-06-07 14:58:58','',''),('21','238',941,'','customer','16',0.00,77800.00,'Credit Sales for 100.00 Litres of Diesel from shift 77 on 2022-06-07 14:58:58 ','2022-06-07 14:58:58','',''),('21','238',942,'','customer','36',0.00,152301.28,'Credit Sales for 195.76 Litres of Diesel from shift 77 on 2022-06-07 14:58:58 ','2022-06-07 14:58:58','',''),('21','238',943,'','customer','14',0.00,3003.08,'Credit Sales for 3.86 Litres of Diesel from shift 77 on 2022-06-07 14:58:58 ','2022-06-07 14:58:58','',''),('21','238',944,'','20','2',7432707.09,0.00,'Sales from shift 77 on 2022-06-07 14:58:58 ','2022-06-07 14:58:58','',''),('21','238',945,'','6.1','3',0.00,7005102.73,'Sales from shift 77 on 2022-06-07 14:58:58 ','2022-06-07 14:58:58','',''),('21','238',946,'','customer','17',0.00,202280.00,'Credit Sales for 260.00 Litres of Diesel from shift 78 on 2022-06-07 16:04:17 ','2022-06-07 16:04:17','',''),('21','238',947,'','customer','17',0.00,241958.00,'Credit Sales for 311.00 Litres of Diesel from shift 78 on 2022-06-07 16:04:17 ','2022-06-07 16:04:17','',''),('21','238',948,'','customer','16',0.00,326760.00,'Credit Sales for 420.00 Litres of Diesel from shift 78 on 2022-06-07 16:04:17 ','2022-06-07 16:04:17','',''),('21','238',949,'','customer','16',0.00,326760.00,'Credit Sales for 420.00 Litres of Diesel from shift 78 on 2022-06-07 16:04:17 ','2022-06-07 16:04:17','',''),('21','238',950,'','customer','16',0.00,326760.00,'Credit Sales for 420.00 Litres of Diesel from shift 78 on 2022-06-07 16:04:17 ','2022-06-07 16:04:17','',''),('21','238',951,'','customer','16',0.00,326760.00,'Credit Sales for 420.00 Litres of Diesel from shift 78 on 2022-06-07 16:04:17 ','2022-06-07 16:04:17','',''),('21','238',952,'','customer','16',0.00,326760.00,'Credit Sales for 420.00 Litres of Diesel from shift 78 on 2022-06-07 16:04:17 ','2022-06-07 16:04:17','',''),('21','238',953,'','customer','12',0.00,63002.44,'Credit Sales for 80.98 Litres of Diesel from shift 78 on 2022-06-07 16:04:17 ','2022-06-07 16:04:17','',''),('21','238',954,'','20','2',9539581.17,0.00,'Sales from shift 78 on 2022-06-07 16:04:17 ','2022-06-07 16:04:17','',''),('21','238',955,'','6.1','3',0.00,7398540.73,'Sales from shift 78 on 2022-06-07 16:04:17 ','2022-06-07 16:04:17','',''),('21','238',956,'','customer','16',0.00,326760.00,'Credit Sales for 420.00 Litres of Diesel from shift 79 on 2022-06-09 15:01:00 ','2022-06-09 15:01:00','',''),('21','238',957,'','customer','1',0.00,77800.00,'Credit Sales for 100.00 Litres of Diesel from shift 79 on 2022-06-09 15:01:00 ','2022-06-09 15:01:00','',''),('21','238',958,'','customer','37',0.00,233400.00,'Credit Sales for 300.00 Litres of Diesel from shift 79 on 2022-06-09 15:01:00 ','2022-06-09 15:01:00','',''),('21','238',959,'','20','2',12117422.80,0.00,'Sales from shift 79 on 2022-06-09 15:01:00 ','2022-06-09 15:01:00','',''),('21','238',960,'','6.1','3',0.00,11479462.80,'Sales from shift 79 on 2022-06-09 15:01:00 ','2022-06-09 15:01:00','',''),('21','238',961,'','24','5',0.00,5610000.00,'Purchase Id 70 for 34,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-09 15:05:52','',''),('21','238',962,'','supplier','1',5610000.00,0.00,'Purchase Id 70 for 34,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-09 15:05:52','',''),('21','238',963,'','24','5',0.00,2475000.00,'Purchase Id 71 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-14 13:54:20','',''),('21','238',964,'','supplier','1',2475000.00,0.00,'Purchase Id 71 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-14 13:54:20','',''),('21','238',965,'','24','5',0.00,2970000.00,'Purchase Id 72 for 18,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-14 13:59:33','',''),('21','238',966,'','supplier','1',2970000.00,0.00,'Purchase Id 72 for 18,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-14 13:59:33','',''),('21','238',967,'','24','5',0.00,5445000.00,'Purchase Id 73 for 33,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-14 14:44:39','',''),('21','238',968,'','supplier','1',5445000.00,0.00,'Purchase Id 73 for 33,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-14 14:44:39','',''),('21','238',969,'','24','5',0.00,18438600.00,'Purchase Id 74 for 23,700.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-14 14:53:25','',''),('21','238',970,'','supplier','1',18438600.00,0.00,'Purchase Id 74 for 23,700.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-14 14:53:25','',''),('21','238',971,'','24','5',0.00,11670000.00,'Purchase Id 75 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-14 14:56:20','',''),('21','238',972,'','supplier','1',11670000.00,0.00,'Purchase Id 75 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-14 14:56:20','',''),('21','238',973,'','20','2',2244544.46,0.00,'Sales from shift 80 on 2022-06-14 15:38:02 ','2022-06-14 15:38:02','',''),('21','238',974,'','6.1','3',0.00,2244544.46,'Sales from shift 80 on 2022-06-14 15:38:02 ','2022-06-14 15:38:02','',''),('21','238',975,'','customer','12',0.00,56003.64,'Credit Sales for 70.18 Litres of Diesel from shift 81 on 2022-06-14 16:03:46 ','2022-06-14 16:03:46','',''),('21','238',976,'','customer','39',0.00,4999.50,'Credit Sales for 30.30 Litres of Petrol from shift 81 on 2022-06-14 16:03:46 ','2022-06-14 16:03:46','',''),('21','238',977,'','customer','39',0.00,5999.40,'Credit Sales for 36.36 Litres of Petrol from shift 81 on 2022-06-14 16:03:46 ','2022-06-14 16:03:46','',''),('21','238',978,'','20','2',5893830.37,0.00,'Sales from shift 81 on 2022-06-14 16:03:46 ','2022-06-14 16:03:46','',''),('21','238',979,'','6.1','3',0.00,5826827.83,'Sales from shift 81 on 2022-06-14 16:03:46 ','2022-06-14 16:03:46','',''),('21','238',980,'','24','5',0.00,2475000.00,'Purchase Id 76 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-15 15:18:19','',''),('21','238',981,'','supplier','1',2475000.00,0.00,'Purchase Id 76 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-15 15:18:19','',''),('21','238',982,'','customer','17',0.00,39900.00,'Credit Sales for 50.00 Litres of Diesel from shift 82 on 2022-06-15 15:46:52 ','2022-06-15 15:46:52','',''),('21','238',983,'','customer','17',0.00,518700.00,'Credit Sales for 650.00 Litres of Diesel from shift 82 on 2022-06-15 15:46:52 ','2022-06-15 15:46:52','',''),('21','238',984,'','customer','17',0.00,422940.00,'Credit Sales for 530.00 Litres of Diesel from shift 82 on 2022-06-15 15:46:52 ','2022-06-15 15:46:52','',''),('21','238',985,'','customer','17',0.00,399000.00,'Credit Sales for 500.00 Litres of Diesel from shift 82 on 2022-06-15 15:46:52 ','2022-06-15 15:46:52','',''),('21','238',986,'','customer','17',0.00,478800.00,'Credit Sales for 600.00 Litres of Diesel from shift 82 on 2022-06-15 15:46:52 ','2022-06-15 15:46:52','',''),('21','238',987,'','customer','17',0.00,478800.00,'Credit Sales for 600.00 Litres of Diesel from shift 82 on 2022-06-15 15:46:52 ','2022-06-15 15:46:52','',''),('21','238',988,'','customer','17',0.00,478800.00,'Credit Sales for 600.00 Litres of Diesel from shift 82 on 2022-06-15 15:46:52 ','2022-06-15 15:46:52','',''),('21','238',989,'','customer','18',0.00,118104.00,'Credit Sales for 148.00 Litres of Diesel from shift 82 on 2022-06-15 15:46:52 ','2022-06-15 15:46:52','',''),('21','238',990,'','customer','37',0.00,159600.00,'Credit Sales for 200.00 Litres of Diesel from shift 82 on 2022-06-15 15:46:52 ','2022-06-15 15:46:52','',''),('21','238',991,'','20','2',13277326.86,0.00,'Sales from shift 82 on 2022-06-15 15:46:52 ','2022-06-15 15:46:52','',''),('21','238',992,'','6.1','3',0.00,10182682.86,'Sales from shift 82 on 2022-06-15 15:46:52 ','2022-06-15 15:46:52','',''),('21','238',993,'','customer','42',0.00,23940.00,'Credit Sales for 30.00 Litres of Diesel from shift 83 on 2022-06-15 16:11:29 ','2022-06-15 16:11:29','',''),('21','238',994,'','customer','8',0.00,23940.00,'Credit Sales for 30.00 Litres of Diesel from shift 83 on 2022-06-15 16:11:29 ','2022-06-15 16:11:29','',''),('21','238',995,'','20','2',4576991.20,0.00,'Sales from shift 83 on 2022-06-15 16:11:29 ','2022-06-15 16:11:29','',''),('21','238',996,'','6.1','3',0.00,4529111.20,'Sales from shift 83 on 2022-06-15 16:11:29 ','2022-06-15 16:11:29','',''),('21','238',997,'','20','2',2539499.34,0.00,'Sales from shift 84 on 2022-06-15 16:22:32 ','2022-06-15 16:22:32','',''),('21','238',998,'','6.1','3',0.00,2539499.34,'Sales from shift 84 on 2022-06-15 16:22:32 ','2022-06-15 16:22:32','',''),('21','238',999,'','20','2',898506.00,0.00,'Sales from shift 85 on 2022-06-15 16:32:13 ','2022-06-15 16:32:13','',''),('21','238',1000,'','6.1','3',0.00,898506.00,'Sales from shift 85 on 2022-06-15 16:32:13 ','2022-06-15 16:32:13','',''),('21','238',1001,'','customer','17',0.00,531700.00,'Credit Sales for 650.00 Litres of Diesel from shift 86 on 2022-06-15 16:43:47 ','2022-06-15 16:43:47','',''),('21','238',1002,'','customer','16',0.00,343560.00,'Credit Sales for 420.00 Litres of Diesel from shift 86 on 2022-06-15 16:43:47 ','2022-06-15 16:43:47','',''),('21','238',1003,'','20','2',6035952.26,0.00,'Sales from shift 86 on 2022-06-15 16:43:47 ','2022-06-15 16:43:47','',''),('21','238',1004,'','6.1','3',0.00,5160692.26,'Sales from shift 86 on 2022-06-15 16:43:47 ','2022-06-15 16:43:47','',''),('21','238',1005,'','24','5',0.00,12310900.00,'Purchase Id 77 for 15,050.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-17 14:19:31','',''),('21','238',1006,'','supplier','1',12310900.00,0.00,'Purchase Id 77 for 15,050.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-17 14:19:31','',''),('21','238',1007,'','20','2',0.00,0.00,'Sales from shift 87 on 2022-06-17 14:31:16 ','2022-06-17 14:31:16','',''),('21','238',1008,'','6.1','3',0.00,0.00,'Sales from shift 87 on 2022-06-17 14:31:16 ','2022-06-17 14:31:16','',''),('21','238',1009,'','customer','16',0.00,343560.00,'Credit Sales for 420.00 Litres of Diesel from shift 88 on 2022-06-17 15:31:20 ','2022-06-17 15:31:20','',''),('21','238',1010,'','customer','16',0.00,343560.00,'Credit Sales for 420.00 Litres of Diesel from shift 88 on 2022-06-17 15:31:20 ','2022-06-17 15:31:20','',''),('21','238',1011,'','customer','16',0.00,343560.00,'Credit Sales for 420.00 Litres of Diesel from shift 88 on 2022-06-17 15:31:20 ','2022-06-17 15:31:20','',''),('21','238',1012,'','customer','16',0.00,343560.00,'Credit Sales for 420.00 Litres of Diesel from shift 88 on 2022-06-17 15:31:20 ','2022-06-17 15:31:20','',''),('21','238',1013,'','customer','24',0.00,39264.00,'Credit Sales for 48.00 Litres of Diesel from shift 88 on 2022-06-17 15:31:20 ','2022-06-17 15:31:20','',''),('21','238',1014,'','customer','37',0.00,32720.00,'Credit Sales for 40.00 Litres of Diesel from shift 88 on 2022-06-17 15:31:20 ','2022-06-17 15:31:20','',''),('21','238',1015,'','20','2',5946170.09,0.00,'Sales from shift 88 on 2022-06-17 15:31:20 ','2022-06-17 15:31:20','',''),('21','238',1016,'','6.1','3',0.00,4499946.09,'Sales from shift 88 on 2022-06-17 15:31:20 ','2022-06-17 15:31:20','',''),('21','238',1017,'','20','2',0.00,0.00,'Sales from shift 89 on 2022-06-17 15:35:39 ','2022-06-17 15:35:39','',''),('21','238',1018,'','6.1','3',0.00,0.00,'Sales from shift 89 on 2022-06-17 15:35:39 ','2022-06-17 15:35:39','',''),('21','238',1019,'','20','2',57659.00,0.00,'Sales from shift 90 on 2022-06-17 15:49:14 ','2022-06-17 15:49:14','',''),('21','238',1020,'','6.1','3',0.00,57659.00,'Sales from shift 90 on 2022-06-17 15:49:14 ','2022-06-17 15:49:14','',''),('21','238',1021,'','customer','37',0.00,81800.00,'Credit Sales for 100.00 Litres of Diesel from shift 91 on 2022-06-17 16:31:55 ','2022-06-17 16:31:55','',''),('21','238',1022,'','customer','42',0.00,224950.00,'Credit Sales for 275.00 Litres of Diesel from shift 91 on 2022-06-17 16:31:55 ','2022-06-17 16:31:55','',''),('21','238',1023,'','customer','38',0.00,163600.00,'Credit Sales for 200.00 Litres of Diesel from shift 91 on 2022-06-17 16:31:55 ','2022-06-17 16:31:55','',''),('21','238',1024,'','20','2',12799333.06,0.00,'Sales from shift 91 on 2022-06-17 16:31:55 ','2022-06-17 16:31:55','',''),('21','238',1025,'','6.1','3',0.00,12328983.06,'Sales from shift 91 on 2022-06-17 16:31:55 ','2022-06-17 16:31:55','',''),('21','238',1026,'','24','5',0.00,2475000.00,'Purchase Id 78 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-21 14:20:52','',''),('21','238',1027,'','supplier','1',2475000.00,0.00,'Purchase Id 78 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-21 14:20:52','',''),('21','238',1028,'','customer','37',0.00,49080.00,'Credit Sales for 60.00 Litres of Diesel from shift 92 on 2022-06-21 14:44:19 ','2022-06-21 14:44:19','',''),('21','238',1029,'','customer','36',0.00,45808.00,'Credit Sales for 56.00 Litres of Diesel from shift 92 on 2022-06-21 14:44:19 ','2022-06-21 14:44:19','',''),('21','238',1030,'','customer','11',0.00,16360.00,'Credit Sales for 20.00 Litres of Diesel from shift 92 on 2022-06-21 14:44:19 ','2022-06-21 14:44:19','',''),('21','238',1031,'','customer','39',0.00,14724.00,'Credit Sales for 18.00 Litres of Diesel from shift 92 on 2022-06-21 14:44:19 ','2022-06-21 14:44:19','',''),('21','238',1032,'','customer','9',0.00,284664.00,'Credit Sales for 348.00 Litres of Diesel from shift 92 on 2022-06-21 14:44:19 ','2022-06-21 14:44:19','',''),('21','238',1033,'','20','2',7234293.54,0.00,'Sales from shift 92 on 2022-06-21 14:44:19 ','2022-06-21 14:44:19','',''),('21','238',1034,'','6.1','3',0.00,6823657.54,'Sales from shift 92 on 2022-06-21 14:44:19 ','2022-06-21 14:44:19','',''),('21','238',1035,'','24','5',0.00,12420000.00,'Purchase Id 79 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-21 15:07:49','',''),('21','238',1036,'','supplier','1',12420000.00,0.00,'Purchase Id 79 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-21 15:07:49','',''),('21','238',1037,'','20','2',4679597.75,0.00,'Sales from shift 93 on 2022-06-21 15:24:50 ','2022-06-21 15:24:50','',''),('21','238',1038,'','6.1','3',0.00,4679597.75,'Sales from shift 93 on 2022-06-21 15:24:50 ','2022-06-21 15:24:50','',''),('21','238',1039,'','20','2',37335.00,0.00,'Sales from shift 94 on 2022-06-21 15:28:22 ','2022-06-21 15:28:22','',''),('21','238',1040,'','6.1','3',0.00,37335.00,'Sales from shift 94 on 2022-06-21 15:28:22 ','2022-06-21 15:28:22','',''),('21','238',1041,'','20','2',77505.00,0.00,'Sales from shift 95 on 2022-06-21 15:31:38 ','2022-06-21 15:31:38','',''),('21','238',1042,'','6.1','3',0.00,77505.00,'Sales from shift 95 on 2022-06-21 15:31:38 ','2022-06-21 15:31:38','',''),('21','238',1043,'','24','5',0.00,12420000.00,'Purchase Id 80 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-21 15:39:27','',''),('21','238',1044,'','supplier','1',12420000.00,0.00,'Purchase Id 80 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-21 15:39:27','',''),('21','238',1045,'','20','2',10111121.67,0.00,'Sales from shift 96 on 2022-06-21 16:08:55 ','2022-06-21 16:08:55','',''),('21','238',1046,'','6.1','3',0.00,10111121.67,'Sales from shift 96 on 2022-06-21 16:08:55 ','2022-06-21 16:08:55','',''),('21','238',1047,'','customer','36',0.00,82800.00,'Credit Sales for 100.00 Litres of Diesel from shift 97 on 2022-06-21 16:40:55 ','2022-06-21 16:40:55','',''),('21','238',1048,'','customer','24',0.00,99360.00,'Credit Sales for 120.00 Litres of Diesel from shift 97 on 2022-06-21 16:40:55 ','2022-06-21 16:40:55','',''),('21','238',1049,'','20','2',6525259.50,0.00,'Sales from shift 97 on 2022-06-21 16:40:55 ','2022-06-21 16:40:55','',''),('21','238',1050,'','6.1','3',0.00,6343099.50,'Sales from shift 97 on 2022-06-21 16:40:55 ','2022-06-21 16:40:55','',''),('21','238',1051,'','24','5',0.00,2475000.00,'Purchase Id 81 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-22 12:52:59','',''),('21','238',1052,'','supplier','1',2475000.00,0.00,'Purchase Id 81 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-22 12:52:59','',''),('21','238',1053,'','24','5',0.00,2392500.00,'Purchase Id 82 for 14,500.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-22 12:57:15','',''),('21','238',1054,'','supplier','1',2392500.00,0.00,'Purchase Id 82 for 14,500.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-22 12:57:15','',''),('21','238',1055,'','24','5',0.00,12420000.00,'Purchase Id 83 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-22 13:29:46','',''),('21','238',1056,'','supplier','1',12420000.00,0.00,'Purchase Id 83 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-22 13:29:46','',''),('21','238',1057,'','customer','37',0.00,82800.00,'Credit Sales for 100.00 Litres of Diesel from shift 98 on 2022-06-22 14:39:10 ','2022-06-22 14:39:10','',''),('21','238',1058,'','customer','37',0.00,322920.00,'Credit Sales for 390.00 Litres of Diesel from shift 98 on 2022-06-22 14:39:10 ','2022-06-22 14:39:10','',''),('21','238',1059,'','customer','16',0.00,356040.00,'Credit Sales for 430.00 Litres of Diesel from shift 98 on 2022-06-22 14:39:10 ','2022-06-22 14:39:10','',''),('21','238',1060,'','20','2',11149368.06,0.00,'Sales from shift 98 on 2022-06-22 14:39:10 ','2022-06-22 14:39:10','',''),('21','238',1061,'','6.1','3',0.00,10387608.06,'Sales from shift 98 on 2022-06-22 14:39:10 ','2022-06-22 14:39:10','',''),('21','238',1062,'','24','5',0.00,2475000.00,'Purchase Id 84 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-28 13:43:34','',''),('21','238',1063,'','supplier','1',2475000.00,0.00,'Purchase Id 84 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-28 13:43:34','',''),('21','238',1064,'','customer','37',0.00,41400.00,'Credit Sales for 50.00 Litres of Diesel from shift 99 on 2022-06-28 14:03:27 ','2022-06-28 14:03:27','',''),('21','238',1065,'','customer','11',0.00,579600.00,'Credit Sales for 700.00 Litres of Diesel from shift 99 on 2022-06-28 14:03:27 ','2022-06-28 14:03:27','',''),('21','238',1066,'','20','2',7970207.37,0.00,'Sales from shift 99 on 2022-06-28 14:03:27 ','2022-06-28 14:03:27','',''),('21','238',1067,'','6.1','3',0.00,7349207.37,'Sales from shift 99 on 2022-06-28 14:03:27 ','2022-06-28 14:03:27','',''),('21','238',1068,'','customer','24',0.00,159804.00,'Credit Sales for 193.00 Litres of Diesel from shift 100 on 2022-06-28 14:24:04 ','2022-06-28 14:24:04','',''),('21','238',1069,'','customer','16',0.00,356040.00,'Credit Sales for 430.00 Litres of Diesel from shift 100 on 2022-06-28 14:24:04 ','2022-06-28 14:24:04','',''),('21','238',1070,'','20','2',7590896.34,0.00,'Sales from shift 100 on 2022-06-28 14:24:04 ','2022-06-28 14:24:04','',''),('21','238',1071,'','6.1','3',0.00,7075052.34,'Sales from shift 100 on 2022-06-28 14:24:04 ','2022-06-28 14:24:04','',''),('21','238',1072,'','24','5',0.00,24840000.00,'Purchase Id 86 for 30,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-28 14:39:24','',''),('21','238',1073,'','supplier','1',24840000.00,0.00,'Purchase Id 86 for 30,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-28 14:39:24','',''),('21','238',1074,'','24','5',0.00,24840000.00,'Purchase Id 85 for 30,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-28 14:41:29','',''),('21','238',1075,'','supplier','1',24840000.00,0.00,'Purchase Id 85 for 30,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-28 14:41:29','',''),('21','238',1076,'','customer','37',0.00,140760.00,'Credit Sales for 170.00 Litres of Diesel from shift 101 on 2022-06-28 15:07:42 ','2022-06-28 15:07:42','',''),('21','238',1077,'','customer','37',0.00,140760.00,'Credit Sales for 170.00 Litres of Diesel from shift 101 on 2022-06-28 15:07:42 ','2022-06-28 15:07:42','',''),('21','238',1078,'','customer','22',0.00,100188.00,'Credit Sales for 121.00 Litres of Diesel from shift 101 on 2022-06-28 15:07:42 ','2022-06-28 15:07:42','',''),('21','238',1079,'','customer','12',0.00,70380.00,'Credit Sales for 85.00 Litres of Diesel from shift 101 on 2022-06-28 15:07:42 ','2022-06-28 15:07:42','',''),('21','238',1080,'','20','2',3653427.84,0.00,'Sales from shift 101 on 2022-06-28 15:07:42 ','2022-06-28 15:07:42','',''),('21','238',1081,'','6.1','3',0.00,3201339.84,'Sales from shift 101 on 2022-06-28 15:07:42 ','2022-06-28 15:07:42','',''),('21','238',1082,'','customer','16',0.00,356040.00,'Credit Sales for 430.00 Litres of Diesel from shift 102 on 2022-06-28 16:02:25 ','2022-06-28 16:02:25','',''),('21','238',1083,'','customer','3',0.00,16560.00,'Credit Sales for 20.00 Litres of Diesel from shift 102 on 2022-06-28 16:02:25 ','2022-06-28 16:02:25','',''),('21','238',1084,'','customer','36',0.00,289800.00,'Credit Sales for 350.00 Litres of Diesel from shift 102 on 2022-06-28 16:02:25 ','2022-06-28 16:02:25','',''),('21','238',1085,'','customer','34',0.00,289800.00,'Credit Sales for 350.00 Litres of Diesel from shift 102 on 2022-06-28 16:02:25 ','2022-06-28 16:02:25','',''),('21','238',1086,'','customer','34',0.00,331200.00,'Credit Sales for 400.00 Litres of Diesel from shift 102 on 2022-06-28 16:02:25 ','2022-06-28 16:02:25','',''),('21','238',1087,'','customer','34',0.00,331200.00,'Credit Sales for 400.00 Litres of Diesel from shift 102 on 2022-06-28 16:02:25 ','2022-06-28 16:02:25','',''),('21','238',1088,'','20','2',8443867.56,0.00,'Sales from shift 102 on 2022-06-28 16:02:25 ','2022-06-28 16:02:25','',''),('21','238',1089,'','6.1','3',0.00,6829267.56,'Sales from shift 102 on 2022-06-28 16:02:25 ','2022-06-28 16:02:25','',''),('21','238',1090,'','customer','16',0.00,356040.00,'Credit Sales for 430.00 Litres of Diesel from shift 103 on 2022-06-28 16:18:06 ','2022-06-28 16:18:06','',''),('21','238',1091,'','20','2',5966941.56,0.00,'Sales from shift 103 on 2022-06-28 16:18:06 ','2022-06-28 16:18:06','',''),('21','238',1092,'','6.1','3',0.00,5610901.56,'Sales from shift 103 on 2022-06-28 16:18:06 ','2022-06-28 16:18:06','',''),('21','238',1093,'','20','2',9287602.38,0.00,'Sales from shift 104 on 2022-06-28 16:57:32 ','2022-06-28 16:57:32','',''),('21','238',1094,'','6.1','3',0.00,9287602.38,'Sales from shift 104 on 2022-06-28 16:57:32 ','2022-06-28 16:57:32','',''),('21','238',1095,'','24','5',0.00,2475000.00,'Purchase Id 87 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-29 13:13:35','',''),('21','238',1096,'','supplier','1',2475000.00,0.00,'Purchase Id 87 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-29 13:13:35','',''),('21','238',1097,'','customer','24',0.00,99939.60,'Credit Sales for 120.70 Litres of Diesel from shift 105 on 2022-06-29 14:39:57 ','2022-06-29 14:39:57','',''),('21','238',1098,'','customer','39',0.00,14986.80,'Credit Sales for 18.10 Litres of Diesel from shift 105 on 2022-06-29 14:39:57 ','2022-06-29 14:39:57','',''),('21','238',1099,'','customer','22',0.00,229538.16,'Credit Sales for 277.22 Litres of Diesel from shift 105 on 2022-06-29 14:39:57 ','2022-06-29 14:39:57','',''),('21','238',1100,'','20','2',11283680.85,0.00,'Sales from shift 105 on 2022-06-29 14:39:57 ','2022-06-29 14:39:57','',''),('21','238',1101,'','6.1','3',0.00,10939216.29,'Sales from shift 105 on 2022-06-29 14:39:57 ','2022-06-29 14:39:57','',''),('21','238',1102,'','24','5',0.00,12420000.00,'Purchase Id 88 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-30 20:37:59','',''),('21','238',1103,'','supplier','1',12420000.00,0.00,'Purchase Id 88 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-30 20:37:59','',''),('21','238',1104,'','24','5',0.00,27324000.00,'Purchase Id 89 for 33,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-30 20:44:18','',''),('21','238',1105,'','supplier','1',27324000.00,0.00,'Purchase Id 89 for 33,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-30 20:44:18','',''),('21','238',1106,'','2','13',3026180.00,0.00,'Payment Id 763 for invoice:102, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-01 17:13:45','',''),('21','238',1107,'','supplier','1',0.00,3026180.00,'Payment Id 763 for invoice:102, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-01 17:13:45','',''),('21','238',1108,'','2','18',100000.00,0.00,'Payment Id 757 for invoice:101, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-01 17:14:09','',''),('21','238',1109,'','supplier','1',0.00,100000.00,'Payment Id 757 for invoice:101, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-01 17:14:09','',''),('21','238',1110,'','2','18',160020.00,0.00,'Payment Id 741 for invoice:99, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-01 17:22:04','',''),('21','238',1111,'','supplier','1',0.00,160020.00,'Payment Id 741 for invoice:99, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-01 17:22:04','',''),('21','238',1112,'','2','15',2121750.00,0.00,'Payment Id 740 for invoice:99, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-01 17:22:52','',''),('21','238',1113,'','supplier','1',0.00,2121750.00,'Payment Id 740 for invoice:99, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-01 17:22:52','',''),('21','238',1114,'','2','27',388120.00,0.00,'Payment Id 739 for invoice:93, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-01 17:23:26','',''),('21','238',1115,'','supplier','1',0.00,388120.00,'Payment Id 739 for invoice:93, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-01 17:23:26','',''),('21','238',1116,'','2','27',1414965.00,0.00,'Payment Id 738 for invoice:92, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-01 17:23:42','',''),('21','238',1117,'','supplier','1',0.00,1414965.00,'Payment Id 738 for invoice:92, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-01 17:23:42','',''),('21','238',1118,'','2','27',1606000.00,0.00,'Payment Id 737 for invoice:92, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-01 17:23:55','',''),('21','238',1119,'','supplier','1',0.00,1606000.00,'Payment Id 737 for invoice:92, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-01 17:23:55','',''),('21','238',1120,'','2','27',1385835.00,0.00,'Payment Id 736 for invoice:91, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-01 17:24:09','',''),('21','238',1121,'','supplier','1',0.00,1385835.00,'Payment Id 736 for invoice:91, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-01 17:24:09','',''),('21','238',1122,'','2','27',1659745.00,0.00,'Payment Id 735 for invoice:97, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-01 17:24:22','',''),('21','238',1123,'','supplier','1',0.00,1659745.00,'Payment Id 735 for invoice:97, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-01 17:24:22','',''),('21','238',1124,'','2','18',697150.00,0.00,'Payment Id 723 for invoice:98, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-01 17:32:07','',''),('21','238',1125,'','supplier','1',0.00,697150.00,'Payment Id 723 for invoice:98, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-01 17:32:07','',''),('21','238',1126,'','2','15',783810.00,0.00,'Payment Id 722 for invoice:98, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-01 17:32:32','',''),('21','238',1127,'','supplier','1',0.00,783810.00,'Payment Id 722 for invoice:98, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-01 17:32:32','',''),('21','238',1128,'','2','27',2967090.00,0.00,'Payment Id 720 for invoice:96, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-01 17:32:49','',''),('21','238',1129,'','supplier','1',0.00,2967090.00,'Payment Id 720 for invoice:96, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-01 17:32:49','',''),('21','238',1130,'','2','13',742650.00,0.00,'Payment Id 716 for invoice:97, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-01 17:33:15','',''),('21','238',1131,'','supplier','1',0.00,742650.00,'Payment Id 716 for invoice:97, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-01 17:33:15','',''),('21','238',1132,'','2','18',1478420.00,0.00,'Payment Id 715 for invoice:97, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-01 17:33:44','',''),('21','238',1133,'','supplier','1',0.00,1478420.00,'Payment Id 715 for invoice:97, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-01 17:33:44','',''),('21','238',1134,'','2','15',76500.00,0.00,'Payment Id 695 for invoice:92, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-01 17:36:26','',''),('21','238',1135,'','supplier','1',0.00,76500.00,'Payment Id 695 for invoice:92, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-01 17:36:26','',''),('21','238',1136,'','2','18',2147650.00,0.00,'Payment Id 703 for invoice:93, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-01 17:36:52','',''),('21','238',1137,'','supplier','1',0.00,2147650.00,'Payment Id 703 for invoice:93, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-01 17:36:52','',''),('21','238',1138,'','2','27',1856740.00,0.00,'Payment Id 683 for invoice:88, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-01 17:45:32','',''),('21','238',1139,'','supplier','1',0.00,1856740.00,'Payment Id 683 for invoice:88, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-01 17:45:32','',''),('21','238',1140,'','2','13',920950.00,0.00,'Payment Id 681 for invoice:88, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-01 17:45:51','',''),('21','238',1141,'','supplier','1',0.00,920950.00,'Payment Id 681 for invoice:88, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-01 17:45:51','',''),('21','238',1142,'','2','13',1298400.00,0.00,'Payment Id 678 for invoice:86, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-01 17:46:08','',''),('21','238',1143,'','supplier','1',0.00,1298400.00,'Payment Id 678 for invoice:86, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-01 17:46:08','',''),('21','238',1144,'','2','18',1375800.00,0.00,'Payment Id 677 for invoice:86, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-01 17:46:29','',''),('21','238',1145,'','supplier','1',0.00,1375800.00,'Payment Id 677 for invoice:86, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-01 17:46:29','',''),('21','238',1146,'','2','13',327800.00,0.00,'Payment Id 675 for invoice:84, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-01 17:46:49','',''),('21','238',1147,'','supplier','1',0.00,327800.00,'Payment Id 675 for invoice:84, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-01 17:46:49','',''),('21','238',1148,'','2','18',821197.00,0.00,'Payment Id 674 for invoice:84, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-01 17:47:07','',''),('21','238',1149,'','supplier','1',0.00,821197.00,'Payment Id 674 for invoice:84, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-01 17:47:07','',''),('21','238',1150,'','2','27',993930.00,0.00,'Payment Id 662 for invoice:82, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-01 17:52:24','',''),('21','238',1151,'','supplier','1',0.00,993930.00,'Payment Id 662 for invoice:82, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-01 17:52:24','',''),('21','238',1152,'','24','5',0.00,2805000.00,'Purchase Id 90 for 17,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-07-08 11:44:00','',''),('21','238',1153,'','supplier','1',2805000.00,0.00,'Purchase Id 90 for 17,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-07-08 11:44:00','',''),('21','238',1154,'','customer','16',0.00,124200.00,'Credit Sales for 150.00 Litres of Diesel from shift 106 on 2022-07-08 12:45:28 ','2022-07-08 12:45:28','',''),('21','238',1155,'','customer','16',0.00,57960.00,'Credit Sales for 70.00 Litres of Diesel from shift 106 on 2022-07-08 12:45:28 ','2022-07-08 12:45:28','',''),('21','238',1156,'','customer','16',0.00,57960.00,'Credit Sales for 70.00 Litres of Diesel from shift 106 on 2022-07-08 12:45:28 ','2022-07-08 12:45:28','',''),('21','238',1157,'','customer','24',0.00,40000.68,'Credit Sales for 48.31 Litres of Diesel from shift 106 on 2022-07-08 12:45:28 ','2022-07-08 12:45:28','',''),('21','238',1158,'','customer','14',0.00,331200.00,'Credit Sales for 400.00 Litres of Diesel from shift 106 on 2022-07-08 12:45:28 ','2022-07-08 12:45:28','',''),('21','238',1159,'','20','2',12372280.38,0.00,'Sales from shift 106 on 2022-07-08 12:45:28 ','2022-07-08 12:45:28','',''),('21','238',1160,'','6.1','3',0.00,11760959.70,'Sales from shift 106 on 2022-07-08 12:45:28 ','2022-07-08 12:45:28','',''),('21','238',1161,'','customer','16',0.00,165600.00,'Credit Sales for 200.00 Litres of Diesel from shift 107 on 2022-07-08 15:07:23 ','2022-07-08 15:07:23','',''),('21','238',1162,'','20','2',6422275.65,0.00,'Sales from shift 107 on 2022-07-08 15:07:23 ','2022-07-08 15:07:23','',''),('21','238',1163,'','6.1','3',0.00,6256675.65,'Sales from shift 107 on 2022-07-08 15:07:23 ','2022-07-08 15:07:23','',''),('21','238',1164,'','customer','34',0.00,496800.00,'Credit Sales for 600.00 Litres of Diesel from shift 108 on 2022-07-08 15:22:17 ','2022-07-08 15:22:17','',''),('21','238',1165,'','20','2',6057665.97,0.00,'Sales from shift 108 on 2022-07-08 15:22:17 ','2022-07-08 15:22:17','',''),('21','238',1166,'','6.1','3',0.00,5560865.97,'Sales from shift 108 on 2022-07-08 15:22:17 ','2022-07-08 15:22:17','',''),('21','238',1167,'','customer','16',0.00,538200.00,'Credit Sales for 650.00 Litres of Diesel from shift 109 on 2022-07-08 15:43:49 ','2022-07-08 15:43:49','',''),('21','238',1168,'','customer','16',0.00,538200.00,'Credit Sales for 650.00 Litres of Diesel from shift 109 on 2022-07-08 15:43:49 ','2022-07-08 15:43:49','',''),('21','238',1169,'','20','2',5847341.40,0.00,'Sales from shift 109 on 2022-07-08 15:43:49 ','2022-07-08 15:43:49','',''),('21','238',1170,'','6.1','3',0.00,4770941.40,'Sales from shift 109 on 2022-07-08 15:43:49 ','2022-07-08 15:43:49','',''),('21','238',1171,'','24','5',0.00,24840000.00,'Purchase Id 91 for 30,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-07-08 16:06:08','',''),('21','238',1172,'','supplier','1',24840000.00,0.00,'Purchase Id 91 for 30,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-07-08 16:06:08','',''),('21','238',1173,'','customer','36',0.00,115092.00,'Credit Sales for 139.00 Litres of Diesel from shift 110 on 2022-07-08 16:20:57 ','2022-07-08 16:20:57','',''),('21','238',1174,'','customer','24',0.00,79488.00,'Credit Sales for 96.00 Litres of Diesel from shift 110 on 2022-07-08 16:20:57 ','2022-07-08 16:20:57','',''),('21','238',1175,'','20','2',4874879.64,0.00,'Sales from shift 110 on 2022-07-08 16:20:57 ','2022-07-08 16:20:57','',''),('21','238',1176,'','6.1','3',0.00,4680299.64,'Sales from shift 110 on 2022-07-08 16:20:57 ','2022-07-08 16:20:57','',''),('21','238',1177,'','customer','34',0.00,662400.00,'Credit Sales for 800.00 Litres of Diesel from shift 111 on 2022-07-08 16:35:30 ','2022-07-08 16:35:30','',''),('21','238',1178,'','20','2',5840660.34,0.00,'Sales from shift 111 on 2022-07-08 16:35:30 ','2022-07-08 16:35:30','',''),('21','238',1179,'','6.1','3',0.00,5178260.34,'Sales from shift 111 on 2022-07-08 16:35:30 ','2022-07-08 16:35:30','',''),('21','238',1180,'','customer','8',0.00,129168.00,'Credit Sales for 156.00 Litres of Diesel from shift 112 on 2022-07-08 16:52:12 ','2022-07-08 16:52:12','',''),('21','238',1181,'','customer','24',0.00,82800.00,'Credit Sales for 100.00 Litres of Diesel from shift 112 on 2022-07-08 16:52:12 ','2022-07-08 16:52:12','',''),('21','238',1182,'','20','2',6832015.20,0.00,'Sales from shift 112 on 2022-07-08 16:52:12 ','2022-07-08 16:52:12','',''),('21','238',1183,'','6.1','3',0.00,6620047.20,'Sales from shift 112 on 2022-07-08 16:52:12 ','2022-07-08 16:52:12','',''),('21','238',1184,'','20','2',4323034.26,0.00,'Sales from shift 113 on 2022-07-09 16:04:36 ','2022-07-09 16:04:36','',''),('21','238',1185,'','6.1','3',0.00,4323034.26,'Sales from shift 113 on 2022-07-09 16:04:36 ','2022-07-09 16:04:36','',''),('21','238',1186,'','customer','8',0.00,289800.00,'Credit Sales for 350.00 Litres of Diesel from shift 114 on 2022-07-09 16:31:49 ','2022-07-09 16:31:49','',''),('21','238',1187,'','customer','22',0.00,124200.00,'Credit Sales for 150.00 Litres of Diesel from shift 114 on 2022-07-09 16:31:49 ','2022-07-09 16:31:49','',''),('21','238',1188,'','20','2',6866104.47,0.00,'Sales from shift 114 on 2022-07-09 16:31:49 ','2022-07-09 16:31:49','',''),('21','238',1189,'','6.1','3',0.00,6452104.47,'Sales from shift 114 on 2022-07-09 16:31:49 ','2022-07-09 16:31:49','',''),('21','238',1190,'','20','2',2766436.26,0.00,'Sales from shift 115 on 2022-07-13 17:18:13 ','2022-07-13 17:18:13','',''),('21','238',1191,'','6.1','3',0.00,2766436.26,'Sales from shift 115 on 2022-07-13 17:18:13 ','2022-07-13 17:18:13','',''),('21','238',1192,'','24','5',0.00,2775000.00,'Purchase Id 92 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-07-13 17:23:42','',''),('21','238',1193,'','supplier','1',2775000.00,0.00,'Purchase Id 92 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-07-13 17:23:42','',''),('21','238',1194,'','20','2',3937271.86,0.00,'Sales from shift 116 on 2022-07-13 17:45:05 ','2022-07-13 17:45:05','',''),('21','238',1195,'','6.1','3',0.00,3937271.86,'Sales from shift 116 on 2022-07-13 17:45:05 ','2022-07-13 17:45:05','',''),('21','238',1196,'','20','2',1684302.90,0.00,'Sales from shift 117 on 2022-07-13 17:52:29 ','2022-07-13 17:52:29','',''),('21','238',1197,'','6.1','3',0.00,1684302.90,'Sales from shift 117 on 2022-07-13 17:52:29 ','2022-07-13 17:52:29','',''),('21','238',1198,'','customer','37',0.00,82800.00,'Credit Sales for 100.00 Litres of Diesel from shift 118 on 2022-07-13 17:59:15 ','2022-07-13 17:59:15','',''),('21','238',1199,'','20','2',3774293.16,0.00,'Sales from shift 118 on 2022-07-13 17:59:15 ','2022-07-13 17:59:15','',''),('21','238',1200,'','6.1','3',0.00,3691493.16,'Sales from shift 118 on 2022-07-13 17:59:15 ','2022-07-13 17:59:15','',''),('21','238',1201,'','24','5',0.00,12375000.00,'Purchase Id 93 for 16,500.00 litters of Kerosene - DPK from AYM SHAFA NIGERIA. LTD','2022-07-14 14:43:09','',''),('21','238',1202,'','supplier','1',12375000.00,0.00,'Purchase Id 93 for 16,500.00 litters of Kerosene - DPK from AYM SHAFA NIGERIA. LTD','2022-07-14 14:43:09','',''),('21','238',1203,'','customer','34',0.00,231840.00,'Credit Sales for 280.00 Litres of Diesel from shift 119 on 2022-07-15 09:07:07 ','2022-07-15 09:07:07','',''),('21','238',1204,'','customer','24',0.00,39992.40,'Credit Sales for 48.30 Litres of Diesel from shift 119 on 2022-07-15 09:07:07 ','2022-07-15 09:07:07','',''),('21','238',1205,'','20','2',6735193.62,0.00,'Sales from shift 119 on 2022-07-15 09:07:07 ','2022-07-15 09:07:07','',''),('21','238',1206,'','6.1','3',0.00,6463361.22,'Sales from shift 119 on 2022-07-15 09:07:07 ','2022-07-15 09:07:07','',''),('21','238',1207,'','24','5',0.00,8325000.00,'Purchase Id 94 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-07-15 09:10:27','',''),('21','238',1208,'','supplier','1',8325000.00,0.00,'Purchase Id 94 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-07-15 09:10:27','',''),('21','238',1209,'','customer','16',0.00,538200.00,'Credit Sales for 650.00 Litres of Diesel from shift 120 on 2022-07-15 09:32:53 ','2022-07-15 09:32:53','',''),('21','238',1210,'','customer','16',0.00,414000.00,'Credit Sales for 500.00 Litres of Diesel from shift 120 on 2022-07-15 09:32:53 ','2022-07-15 09:32:53','',''),('21','238',1211,'','customer','24',0.00,19996.20,'Credit Sales for 24.15 Litres of Diesel from shift 120 on 2022-07-15 09:32:53 ','2022-07-15 09:32:53','',''),('21','238',1212,'','20','2',13469037.78,0.00,'Sales from shift 120 on 2022-07-15 09:32:53 ','2022-07-15 09:32:53','',''),('21','238',1213,'','6.1','3',0.00,12496841.58,'Sales from shift 120 on 2022-07-15 09:32:53 ','2022-07-15 09:32:53','',''),('21','238',1214,'','24','5',0.00,28152000.00,'Purchase Id 95 for 34,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-07-15 09:42:01','',''),('21','238',1215,'','supplier','1',28152000.00,0.00,'Purchase Id 95 for 34,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-07-15 09:42:01','',''),('21','238',1216,'','20','2',5425914.24,0.00,'Sales from shift 121 on 2022-07-18 08:45:46 ','2022-07-18 08:45:46','',''),('21','238',1217,'','6.1','3',0.00,5425914.24,'Sales from shift 121 on 2022-07-18 08:45:46 ','2022-07-18 08:45:46','',''),('21','238',1218,'','24','5',0.00,2775000.00,'Purchase Id 96 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-07-18 08:53:20','',''),('21','238',1219,'','supplier','1',2775000.00,0.00,'Purchase Id 96 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-07-18 08:53:20','',''),('21','238',1220,'','customer','42',0.00,43999.92,'Credit Sales for 53.14 Litres of Diesel from shift 122 on 2022-07-18 09:46:41 ','2022-07-18 09:46:41','',''),('21','238',1221,'','customer','42',0.00,82800.00,'Credit Sales for 100.00 Litres of Diesel from shift 122 on 2022-07-18 09:46:41 ','2022-07-18 09:46:41','',''),('21','238',1222,'','customer','34',0.00,484380.00,'Credit Sales for 585.00 Litres of Diesel from shift 122 on 2022-07-18 09:46:41 ','2022-07-18 09:46:41','',''),('21','238',1223,'','customer','34',0.00,449604.00,'Credit Sales for 543.00 Litres of Diesel from shift 122 on 2022-07-18 09:46:41 ','2022-07-18 09:46:41','',''),('21','238',1224,'','customer','12',0.00,13993.20,'Credit Sales for 16.90 Litres of Diesel from shift 122 on 2022-07-18 09:46:41 ','2022-07-18 09:46:41','',''),('21','238',1225,'','customer','14',0.00,100022.40,'Credit Sales for 120.80 Litres of Diesel from shift 122 on 2022-07-18 09:46:41 ','2022-07-18 09:46:41','',''),('21','238',1226,'','20','2',9116538.79,0.00,'Sales from shift 122 on 2022-07-18 09:46:41 ','2022-07-18 09:46:41','',''),('21','238',1227,'','6.1','3',0.00,7941739.27,'Sales from shift 122 on 2022-07-18 09:46:41 ','2022-07-18 09:46:41','',''),('21','238',1228,'','customer','37',0.00,66240.00,'Credit Sales for 80.00 Litres of Diesel from shift 123 on 2022-07-18 10:04:46 ','2022-07-18 10:04:46','',''),('21','238',1229,'','customer','37',0.00,66240.00,'Credit Sales for 80.00 Litres of Diesel from shift 123 on 2022-07-18 10:04:46 ','2022-07-18 10:04:46','',''),('21','238',1230,'','customer','11',0.00,82800.00,'Credit Sales for 100.00 Litres of Diesel from shift 123 on 2022-07-18 10:04:46 ','2022-07-18 10:04:46','',''),('21','238',1231,'','customer','24',0.00,50002.92,'Credit Sales for 60.39 Litres of Diesel from shift 123 on 2022-07-18 10:04:46 ','2022-07-18 10:04:46','',''),('21','238',1232,'','20','2',3278201.52,0.00,'Sales from shift 123 on 2022-07-18 10:04:46 ','2022-07-18 10:04:46','',''),('21','238',1233,'','6.1','3',0.00,3012918.60,'Sales from shift 123 on 2022-07-18 10:04:46 ','2022-07-18 10:04:46','',''),('21','238',1234,'','24','5',0.00,2830500.00,'Purchase Id 97 for 15,300.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-07-18 12:52:54','',''),('21','238',1235,'','supplier','1',2830500.00,0.00,'Purchase Id 97 for 15,300.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-07-18 12:52:54','',''),('21','238',1236,'','customer','7',0.00,3742.56,'Credit Sales for 4.52 Litres of Diesel from shift 124 on 2022-07-18 13:29:10 ','2022-07-18 13:29:10','',''),('21','238',1237,'','customer','22',0.00,546480.00,'Credit Sales for 660.00 Litres of Diesel from shift 124 on 2022-07-18 13:29:10 ','2022-07-18 13:29:10','',''),('21','238',1238,'','customer','37',0.00,107640.00,'Credit Sales for 130.00 Litres of Diesel from shift 124 on 2022-07-18 13:29:10 ','2022-07-18 13:29:10','',''),('21','238',1239,'','20','2',4980873.78,0.00,'Sales from shift 124 on 2022-07-18 13:29:10 ','2022-07-18 13:29:10','',''),('21','238',1240,'','6.1','3',0.00,4323011.22,'Sales from shift 124 on 2022-07-18 13:29:10 ','2022-07-18 13:29:10','',''),('21','238',1241,'','2','27',1786905.00,0.00,'Payment Id 901 for invoice:119, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-18 17:09:01','',''),('21','238',1242,'','supplier','1',0.00,1786905.00,'Payment Id 901 for invoice:119, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-18 17:09:01','',''),('21','238',1243,'','2','27',109685.00,0.00,'Payment Id 900 for invoice:118, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-18 17:09:18','',''),('21','238',1244,'','supplier','1',0.00,109685.00,'Payment Id 900 for invoice:118, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-18 17:09:18','',''),('21','238',1245,'','2','27',552585.00,0.00,'Payment Id 899 for invoice:117, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-18 17:09:32','',''),('21','238',1246,'','supplier','1',0.00,552585.00,'Payment Id 899 for invoice:117, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-18 17:09:32','',''),('21','238',1247,'','2','27',1670270.00,0.00,'Payment Id 898 for invoice:116, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-18 17:09:45','',''),('21','238',1248,'','supplier','1',0.00,1670270.00,'Payment Id 898 for invoice:116, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-18 17:09:45','',''),('21','238',1249,'','2','27',629060.00,0.00,'Payment Id 897 for invoice:115, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-18 17:09:58','',''),('21','238',1250,'','supplier','1',0.00,629060.00,'Payment Id 897 for invoice:115, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-18 17:09:58','',''),('21','238',1251,'','2','15',2912468.00,0.00,'Payment Id 884 for invoice:121, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-18 17:13:08','',''),('21','238',1252,'','supplier','1',0.00,2912468.00,'Payment Id 884 for invoice:121, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-18 17:13:08','',''),('21','238',1253,'','2','13',35200.00,0.00,'Payment Id 879 for invoice:120, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-18 17:13:27','',''),('21','238',1254,'','supplier','1',0.00,35200.00,'Payment Id 879 for invoice:120, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-18 17:13:27','',''),('21','238',1255,'','2','15',3331420.00,0.00,'Payment Id 878 for invoice:120, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-18 17:13:43','',''),('21','238',1256,'','supplier','1',0.00,3331420.00,'Payment Id 878 for invoice:120, receipt:  by AYM SHAFA NIGERIA. LTD','2022-07-18 17:13:43','',''),('21','238',1257,'','customer','34',0.00,592020.00,'Credit Sales for 715.00 Litres of Diesel from shift 125 on 2022-07-19 14:23:34 ','2022-07-19 14:23:34','',''),('21','238',1258,'','20','2',8420055.12,0.00,'Sales from shift 125 on 2022-07-19 14:23:34 ','2022-07-19 14:23:34','',''),('21','238',1259,'','6.1','3',0.00,7828035.12,'Sales from shift 125 on 2022-07-19 14:23:34 ','2022-07-19 14:23:34','',''),('21','238',1260,'','24','5',0.00,24840000.00,'Purchase Id 98 for 30,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-07-19 18:11:27','',''),('21','238',1261,'','supplier','1',24840000.00,0.00,'Purchase Id 98 for 30,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-07-19 18:11:27','',''),('21','238',1262,'','customer','40',0.00,10002.24,'Credit Sales for 12.08 Litres of Diesel from shift 126 on 2022-07-20 09:28:55 ','2022-07-20 09:28:55','',''),('21','238',1263,'','customer','15',0.00,51998.40,'Credit Sales for 62.80 Litres of Diesel from shift 126 on 2022-07-20 09:28:55 ','2022-07-20 09:28:55','',''),('21','238',1264,'','customer','3',0.00,147839.40,'Credit Sales for 178.55 Litres of Diesel from shift 126 on 2022-07-20 09:28:55 ','2022-07-20 09:28:55','',''),('21','238',1265,'','20','2',4786933.68,0.00,'Sales from shift 126 on 2022-07-20 09:28:55 ','2022-07-20 09:28:55','',''),('21','238',1266,'','6.1','3',0.00,4577093.64,'Sales from shift 126 on 2022-07-20 09:28:55 ','2022-07-20 09:28:55','',''),('21','238',1267,'','24','5',0.00,3135000.00,'Purchase Id 99 for 16,500.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-07-20 09:35:32','',''),('21','238',1268,'','supplier','1',3135000.00,0.00,'Purchase Id 99 for 16,500.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-07-20 09:35:32','',''),('21','238',1269,'','customer','34',0.00,546480.00,'Credit Sales for 660.00 Litres of Diesel from shift 127 on 2022-07-21 11:35:40 ','2022-07-21 11:35:40','',''),('21','238',1270,'','customer','34',0.00,662400.00,'Credit Sales for 800.00 Litres of Diesel from shift 127 on 2022-07-21 11:35:40 ','2022-07-21 11:35:40','',''),('21','238',1271,'','customer','34',0.00,368460.00,'Credit Sales for 445.00 Litres of Diesel from shift 127 on 2022-07-21 11:35:40 ','2022-07-21 11:35:40','',''),('21','238',1272,'','20','2',3775688.28,0.00,'Sales from shift 127 on 2022-07-21 11:35:40 ','2022-07-21 11:35:40','',''),('21','238',1273,'','6.1','3',0.00,2198348.28,'Sales from shift 127 on 2022-07-21 11:35:40 ','2022-07-21 11:35:40','',''),('21','238',1274,'','24','5',0.00,13414500.00,'Purchase Id 100 for 16,500.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-07-21 12:46:40','',''),('21','238',1275,'','supplier','1',13414500.00,0.00,'Purchase Id 100 for 16,500.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-07-21 12:46:40','',''),('21','238',1276,'','24','5',0.00,12195000.00,'Purchase Id 101 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-07-21 12:53:00','',''),('21','238',1277,'','supplier','1',12195000.00,0.00,'Purchase Id 101 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-07-21 12:53:00','',''),('21','238',1278,'','customer','40',0.00,15284.88,'Credit Sales for 18.46 Litres of Diesel from shift 128 on 2022-07-21 12:57:47 ','2022-07-21 12:57:47','',''),('21','238',1279,'','customer','12',0.00,7129.08,'Credit Sales for 8.61 Litres of Diesel from shift 128 on 2022-07-21 12:57:47 ','2022-07-21 12:57:47','',''),('21','238',1280,'','20','2',7380007.30,0.00,'Sales from shift 128 on 2022-07-21 12:57:47 ','2022-07-21 12:57:47','',''),('21','238',1281,'','6.1','3',0.00,7357593.34,'Sales from shift 128 on 2022-07-21 12:57:47 ','2022-07-21 12:57:47','',''),('21','238',1282,'','24','5',0.00,2755000.00,'Purchase Id 102 for 14,500.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-07-21 17:57:14','',''),('21','238',1283,'','supplier','1',2755000.00,0.00,'Purchase Id 102 for 14,500.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-07-21 17:57:14','',''),('21','238',1284,'','customer','40',0.00,15007.98,'Credit Sales for 18.46 Litres of Diesel from shift 129 on 2022-07-22 11:35:35 ','2022-07-22 11:35:35','',''),('21','238',1285,'','customer','11',0.00,121950.00,'Credit Sales for 150.00 Litres of Diesel from shift 129 on 2022-07-22 11:35:35 ','2022-07-22 11:35:35','',''),('21','238',1286,'','20','2',6934685.90,0.00,'Sales from shift 129 on 2022-07-22 11:35:35 ','2022-07-22 11:35:35','',''),('21','238',1287,'','6.1','3',0.00,6797727.92,'Sales from shift 129 on 2022-07-22 11:35:35 ','2022-07-22 11:35:35','',''),('21','238',1288,'','customer','16',0.00,467475.00,'Credit Sales for 575.00 Litres of Diesel from shift 130 on 2022-07-25 13:14:37 ','2022-07-25 13:14:37','',''),('21','238',1289,'','customer','16',0.00,528450.00,'Credit Sales for 650.00 Litres of Diesel from shift 130 on 2022-07-25 13:14:37 ','2022-07-25 13:14:37','',''),('21','238',1290,'','customer','16',0.00,540645.00,'Credit Sales for 665.00 Litres of Diesel from shift 130 on 2022-07-25 13:14:37 ','2022-07-25 13:14:37','',''),('21','238',1291,'','customer','16',0.00,349996.50,'Credit Sales for 430.50 Litres of Diesel from shift 130 on 2022-07-25 13:14:37 ','2022-07-25 13:14:37','',''),('21','238',1292,'','customer','16',0.00,349996.50,'Credit Sales for 430.50 Litres of Diesel from shift 130 on 2022-07-25 13:14:37 ','2022-07-25 13:14:37','',''),('21','238',1293,'','customer','37',0.00,40650.00,'Credit Sales for 50.00 Litres of Diesel from shift 130 on 2022-07-25 13:14:37 ','2022-07-25 13:14:37','',''),('21','238',1294,'','customer','37',0.00,81300.00,'Credit Sales for 100.00 Litres of Diesel from shift 130 on 2022-07-25 13:14:37 ','2022-07-25 13:14:37','',''),('21','238',1295,'','customer','37',0.00,40650.00,'Credit Sales for 50.00 Litres of Diesel from shift 130 on 2022-07-25 13:14:37 ','2022-07-25 13:14:37','',''),('21','238',1296,'','customer','36',0.00,81300.00,'Credit Sales for 100.00 Litres of Diesel from shift 130 on 2022-07-25 13:14:37 ','2022-07-25 13:14:37','',''),('21','238',1297,'','customer','40',0.00,15007.98,'Credit Sales for 18.46 Litres of Diesel from shift 130 on 2022-07-25 13:14:37 ','2022-07-25 13:14:37','',''),('21','238',1298,'','customer','12',0.00,40650.00,'Credit Sales for 50.00 Litres of Diesel from shift 130 on 2022-07-25 13:14:37 ','2022-07-25 13:14:37','',''),('21','238',1299,'','customer','37',0.00,24390.00,'Credit Sales for 30.00 Litres of Diesel from shift 130 on 2022-07-25 13:14:37 ','2022-07-25 13:14:37','',''),('21','238',1300,'','20','2',7165976.43,0.00,'Sales from shift 130 on 2022-07-25 13:14:37 ','2022-07-25 13:14:37','',''),('21','238',1301,'','6.1','3',0.00,4605465.45,'Sales from shift 130 on 2022-07-25 13:14:37 ','2022-07-25 13:14:37','',''),('21','238',1302,'','customer','16',0.00,447150.00,'Credit Sales for 550.00 Litres of Diesel from shift 131 on 2022-07-25 13:39:40 ','2022-07-25 13:39:40','',''),('21','238',1303,'','customer','16',0.00,467475.00,'Credit Sales for 575.00 Litres of Diesel from shift 131 on 2022-07-25 13:39:40 ','2022-07-25 13:39:40','',''),('21','238',1304,'','customer','16',0.00,528450.00,'Credit Sales for 650.00 Litres of Diesel from shift 131 on 2022-07-25 13:39:40 ','2022-07-25 13:39:40','',''),('21','238',1305,'','customer','37',0.00,40650.00,'Credit Sales for 50.00 Litres of Diesel from shift 131 on 2022-07-25 13:39:40 ','2022-07-25 13:39:40','',''),('21','238',1306,'','customer','37',0.00,40650.00,'Credit Sales for 50.00 Litres of Diesel from shift 131 on 2022-07-25 13:39:40 ','2022-07-25 13:39:40','',''),('21','238',1307,'','customer','15',0.00,650400.00,'Credit Sales for 800.00 Litres of Diesel from shift 131 on 2022-07-25 13:39:40 ','2022-07-25 13:39:40','',''),('21','238',1308,'','customer','15',0.00,162600.00,'Credit Sales for 200.00 Litres of Diesel from shift 131 on 2022-07-25 13:39:40 ','2022-07-25 13:39:40','',''),('21','238',1309,'','customer','11',0.00,81300.00,'Credit Sales for 100.00 Litres of Diesel from shift 131 on 2022-07-25 13:39:40 ','2022-07-25 13:39:40','',''),('21','238',1310,'','customer','36',0.00,40650.00,'Credit Sales for 50.00 Litres of Diesel from shift 131 on 2022-07-25 13:39:40 ','2022-07-25 13:39:40','',''),('21','238',1311,'','customer','18',0.00,175201.50,'Credit Sales for 215.50 Litres of Diesel from shift 131 on 2022-07-25 13:39:40 ','2022-07-25 13:39:40','',''),('21','238',1312,'','customer','40',0.00,9999.90,'Credit Sales for 12.30 Litres of Diesel from shift 131 on 2022-07-25 13:39:40 ','2022-07-25 13:39:40','',''),('21','238',1313,'','20','2',5148425.94,0.00,'Sales from shift 131 on 2022-07-25 13:39:40 ','2022-07-25 13:39:40','',''),('21','238',1314,'','6.1','3',0.00,2503899.54,'Sales from shift 131 on 2022-07-25 13:39:40 ','2022-07-25 13:39:40','',''),('21','238',1315,'','customer','16',0.00,528450.00,'Credit Sales for 650.00 Litres of Diesel from shift 132 on 2022-07-25 14:03:28 ','2022-07-25 14:03:28','',''),('21','238',1316,'','customer','40',0.00,9999.90,'Credit Sales for 12.30 Litres of Diesel from shift 132 on 2022-07-25 14:03:28 ','2022-07-25 14:03:28','',''),('21','238',1317,'','customer','9',0.00,162600.00,'Credit Sales for 200.00 Litres of Diesel from shift 132 on 2022-07-25 14:03:28 ','2022-07-25 14:03:28','',''),('21','238',1318,'','customer','18',0.00,125006.88,'Credit Sales for 153.76 Litres of Diesel from shift 132 on 2022-07-25 14:03:28 ','2022-07-25 14:03:28','',''),('21','238',1319,'','20','2',4854281.37,0.00,'Sales from shift 132 on 2022-07-25 14:03:28 ','2022-07-25 14:03:28','',''),('21','238',1320,'','6.1','3',0.00,4028224.59,'Sales from shift 132 on 2022-07-25 14:03:28 ','2022-07-25 14:03:28','',''),('21','238',1321,'','24','5',0.00,12195000.00,'Purchase Id 103 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-07-25 14:06:50','',''),('21','238',1322,'','supplier','1',12195000.00,0.00,'Purchase Id 103 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-07-25 14:06:50','',''),('21','238',1323,'','customer','16',0.00,528450.00,'Credit Sales for 650.00 Litres of Diesel from shift 133 on 2022-07-26 17:12:47 ','2022-07-26 17:12:47','',''),('21','238',1324,'','customer','15',0.00,9756.00,'Credit Sales for 12.00 Litres of Diesel from shift 133 on 2022-07-26 17:12:47 ','2022-07-26 17:12:47','',''),('21','238',1325,'','customer','40',0.00,9999.90,'Credit Sales for 12.30 Litres of Diesel from shift 133 on 2022-07-26 17:12:47 ','2022-07-26 17:12:47','',''),('21','238',1326,'','customer','9',0.00,150006.63,'Credit Sales for 184.51 Litres of Diesel from shift 133 on 2022-07-26 17:12:47 ','2022-07-26 17:12:47','',''),('21','238',1327,'','20','2',5477620.23,0.00,'Sales from shift 133 on 2022-07-26 17:12:47 ','2022-07-26 17:12:47','',''),('21','238',1328,'','6.1','3',0.00,4779407.70,'Sales from shift 133 on 2022-07-26 17:12:47 ','2022-07-26 17:12:47','',''),('21','238',1329,'','24','5',0.00,5700000.00,'Purchase Id 104 for 30,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-07-27 18:43:13','',''),('21','238',1330,'','supplier','1',5700000.00,0.00,'Purchase Id 104 for 30,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-07-27 18:43:13','',''),('21','238',1331,'','20','2',25335.00,0.00,'Sales from shift 134 on 2022-07-27 18:59:30 ','2022-07-27 18:59:30','',''),('21','238',1332,'','6.1','3',0.00,25335.00,'Sales from shift 134 on 2022-07-27 18:59:30 ','2022-07-27 18:59:30','',''),('21','238',1333,'','customer','40',0.00,15007.98,'Credit Sales for 18.46 Litres of Diesel from shift 135 on 2022-07-27 19:33:43 ','2022-07-27 19:33:43','',''),('21','238',1334,'','customer','41',0.00,20325.00,'Credit Sales for 25.00 Litres of Diesel from shift 135 on 2022-07-27 19:33:43 ','2022-07-27 19:33:43','',''),('21','238',1335,'','customer','11',0.00,20325.00,'Credit Sales for 25.00 Litres of Diesel from shift 135 on 2022-07-27 19:33:43 ','2022-07-27 19:33:43','',''),('21','238',1336,'','customer','12',0.00,40007.73,'Credit Sales for 49.21 Litres of Diesel from shift 135 on 2022-07-27 19:33:43 ','2022-07-27 19:33:43','',''),('21','238',1337,'','customer','12',0.00,16260.00,'Credit Sales for 20.00 Litres of Diesel from shift 135 on 2022-07-27 19:33:43 ','2022-07-27 19:33:43','',''),('21','238',1338,'','20','2',6983391.51,0.00,'Sales from shift 135 on 2022-07-27 19:33:43 ','2022-07-27 19:33:43','',''),('21','238',1339,'','6.1','3',0.00,6871465.80,'Sales from shift 135 on 2022-07-27 19:33:43 ','2022-07-27 19:33:43','',''),('21','238',1340,'','24','5',0.00,3230000.00,'Purchase Id 105 for 17,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-07-27 19:42:17','',''),('21','238',1341,'','supplier','1',3230000.00,0.00,'Purchase Id 105 for 17,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-07-27 19:42:17','',''),('21','238',1342,'','customer','37',0.00,81300.00,'Credit Sales for 100.00 Litres of Diesel from shift 136 on 2022-07-28 17:30:38 ','2022-07-28 17:30:38','',''),('21','238',1343,'','customer','40',0.00,15007.98,'Credit Sales for 18.46 Litres of Diesel from shift 136 on 2022-07-28 17:30:38 ','2022-07-28 17:30:38','',''),('21','238',1344,'','customer','16',0.00,467475.00,'Credit Sales for 575.00 Litres of Diesel from shift 136 on 2022-07-28 17:30:38 ','2022-07-28 17:30:38','',''),('21','238',1345,'','customer','18',0.00,55007.58,'Credit Sales for 67.66 Litres of Diesel from shift 136 on 2022-07-28 17:30:38 ','2022-07-28 17:30:38','',''),('21','238',1346,'','customer','11',0.00,569100.00,'Credit Sales for 700.00 Litres of Diesel from shift 136 on 2022-07-28 17:30:38 ','2022-07-28 17:30:38','',''),('21','238',1347,'','20','2',7940516.63,0.00,'Sales from shift 136 on 2022-07-28 17:30:38 ','2022-07-28 17:30:38','',''),('21','238',1348,'','6.1','3',0.00,6752626.07,'Sales from shift 136 on 2022-07-28 17:30:38 ','2022-07-28 17:30:38','',''),('21','238',1349,'','24','5',0.00,5700000.00,'Purchase Id 106 for 30,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-07-29 15:18:46','',''),('21','238',1350,'','supplier','1',5700000.00,0.00,'Purchase Id 106 for 30,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-07-29 15:18:46','',''),('21','238',1351,'','customer','12',0.00,29268.00,'Credit Sales for 36.00 Litres of Diesel from shift 137 on 2022-07-29 15:33:51 ','2022-07-29 15:33:51','',''),('21','238',1352,'','customer','12',0.00,20325.00,'Credit Sales for 25.00 Litres of Diesel from shift 137 on 2022-07-29 15:33:51 ','2022-07-29 15:33:51','',''),('21','238',1353,'','customer','11',0.00,162600.00,'Credit Sales for 200.00 Litres of Diesel from shift 137 on 2022-07-29 15:33:51 ','2022-07-29 15:33:51','',''),('21','238',1354,'','customer','42',0.00,203900.40,'Credit Sales for 250.80 Litres of Diesel from shift 137 on 2022-07-29 15:33:51 ','2022-07-29 15:33:51','',''),('21','238',1355,'','customer','11',0.00,65040.00,'Credit Sales for 80.00 Litres of Diesel from shift 137 on 2022-07-29 15:33:51 ','2022-07-29 15:33:51','',''),('21','238',1356,'','customer','40',0.00,9999.90,'Credit Sales for 12.30 Litres of Diesel from shift 137 on 2022-07-29 15:33:51 ','2022-07-29 15:33:51','',''),('21','238',1357,'','20','2',9137201.14,0.00,'Sales from shift 137 on 2022-07-29 15:33:51 ','2022-07-29 15:33:51','',''),('21','238',1358,'','6.1','3',0.00,8646067.84,'Sales from shift 137 on 2022-07-29 15:33:51 ','2022-07-29 15:33:51','',''),('21','238',1359,'','24','5',0.00,27642000.00,'Purchase Id 107 for 34,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-07-29 15:36:57','',''),('21','238',1360,'','supplier','1',27642000.00,0.00,'Purchase Id 107 for 34,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-07-29 15:36:57','',''),('21','238',1361,'','customer','16',0.00,386175.00,'Credit Sales for 475.00 Litres of Diesel from shift 138 on 2022-07-30 18:45:55 ','2022-07-30 18:45:55','',''),('21','238',1362,'','customer','16',0.00,467475.00,'Credit Sales for 575.00 Litres of Diesel from shift 138 on 2022-07-30 18:45:55 ','2022-07-30 18:45:55','',''),('21','238',1363,'','customer','16',0.00,467475.00,'Credit Sales for 575.00 Litres of Diesel from shift 138 on 2022-07-30 18:45:55 ','2022-07-30 18:45:55','',''),('21','238',1364,'','customer','3',0.00,203250.00,'Credit Sales for 250.00 Litres of Diesel from shift 138 on 2022-07-30 18:45:55 ','2022-07-30 18:45:55','',''),('21','238',1365,'','customer','3',0.00,234729.36,'Credit Sales for 288.72 Litres of Diesel from shift 138 on 2022-07-30 18:45:55 ','2022-07-30 18:45:55','',''),('21','238',1366,'','customer','11',0.00,13999.86,'Credit Sales for 17.22 Litres of Diesel from shift 138 on 2022-07-30 18:45:55 ','2022-07-30 18:45:55','',''),('21','238',1367,'','20','2',8835019.84,0.00,'Sales from shift 138 on 2022-07-30 18:45:55 ','2022-07-30 18:45:55','',''),('21','238',1368,'','6.1','3',0.00,7061915.62,'Sales from shift 138 on 2022-07-30 18:45:55 ','2022-07-30 18:45:55','',''),('21','238',1369,'','24','5',0.00,2128000.00,'Purchase Id 108 for 11,200.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-08-02 15:57:06','',''),('21','238',1370,'','supplier','1',2128000.00,0.00,'Purchase Id 108 for 11,200.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-08-02 15:57:06','',''),('21','238',1371,'','customer','16',0.00,467475.00,'Credit Sales for 575.00 Litres of Diesel from shift 139 on 2022-08-02 16:26:35 ','2022-08-02 16:26:35','',''),('21','238',1372,'','customer','16',0.00,467475.00,'Credit Sales for 575.00 Litres of Diesel from shift 139 on 2022-08-02 16:26:35 ','2022-08-02 16:26:35','',''),('21','238',1373,'','customer','16',0.00,467475.00,'Credit Sales for 575.00 Litres of Diesel from shift 139 on 2022-08-02 16:26:35 ','2022-08-02 16:26:35','',''),('21','238',1374,'','customer','12',0.00,108129.00,'Credit Sales for 133.00 Litres of Diesel from shift 139 on 2022-08-02 16:26:35 ','2022-08-02 16:26:35','',''),('21','238',1375,'','customer','12',0.00,41999.58,'Credit Sales for 51.66 Litres of Diesel from shift 139 on 2022-08-02 16:26:35 ','2022-08-02 16:26:35','',''),('21','238',1376,'','customer','27',0.00,121950.00,'Credit Sales for 150.00 Litres of Diesel from shift 139 on 2022-08-02 16:26:35 ','2022-08-02 16:26:35','',''),('21','238',1377,'','customer','27',0.00,121950.00,'Credit Sales for 150.00 Litres of Diesel from shift 139 on 2022-08-02 16:26:35 ','2022-08-02 16:26:35','',''),('21','238',1378,'','customer','40',0.00,15007.98,'Credit Sales for 18.46 Litres of Diesel from shift 139 on 2022-08-02 16:26:35 ','2022-08-02 16:26:35','',''),('21','238',1379,'','customer','11',0.00,24390.00,'Credit Sales for 30.00 Litres of Diesel from shift 139 on 2022-08-02 16:26:35 ','2022-08-02 16:26:35','',''),('21','238',1380,'','20','2',5965758.46,0.00,'Sales from shift 139 on 2022-08-02 16:26:35 ','2022-08-02 16:26:35','',''),('21','238',1381,'','6.1','3',0.00,4129906.90,'Sales from shift 139 on 2022-08-02 16:26:35 ','2022-08-02 16:26:35','',''),('21','238',1382,'','24','5',0.00,2850000.00,'Purchase Id 109 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-08-02 16:44:41','',''),('21','238',1383,'','supplier','1',2850000.00,0.00,'Purchase Id 109 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-08-02 16:44:41','',''),('21','238',1384,'','24','5',0.00,2850000.00,'Purchase Id 110 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-08-02 16:59:22','',''),('21','238',1385,'','supplier','1',2850000.00,0.00,'Purchase Id 110 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-08-02 16:59:22','',''),('21','238',1386,'','customer','40',0.00,15007.98,'Credit Sales for 18.46 Litres of Diesel from shift 140 on 2022-08-02 17:16:15 ','2022-08-02 17:16:15','',''),('21','238',1387,'','customer','12',0.00,21007.92,'Credit Sales for 25.84 Litres of Diesel from shift 140 on 2022-08-02 17:16:15 ','2022-08-02 17:16:15','',''),('21','238',1388,'','20','2',7665798.14,0.00,'Sales from shift 140 on 2022-08-02 17:16:15 ','2022-08-02 17:16:15','',''),('21','238',1389,'','6.1','3',0.00,7629782.24,'Sales from shift 140 on 2022-08-02 17:16:15 ','2022-08-02 17:16:15','',''),('21','238',1390,'','customer','40',0.00,15007.98,'Credit Sales for 18.46 Litres of Diesel from shift 141 on 2022-08-02 17:40:03 ','2022-08-02 17:40:03','',''),('21','238',1391,'','customer','11',0.00,40650.00,'Credit Sales for 50.00 Litres of Diesel from shift 141 on 2022-08-02 17:40:03 ','2022-08-02 17:40:03','',''),('21','238',1392,'','customer','9',0.00,150006.63,'Credit Sales for 184.51 Litres of Diesel from shift 141 on 2022-08-02 17:40:03 ','2022-08-02 17:40:03','',''),('21','238',1393,'','customer','8',0.00,20325.00,'Credit Sales for 25.00 Litres of Diesel from shift 141 on 2022-08-02 17:40:03 ','2022-08-02 17:40:03','',''),('21','238',1394,'','customer','20',0.00,199998.00,'Credit Sales for 246.00 Litres of Diesel from shift 141 on 2022-08-02 17:40:03 ','2022-08-02 17:40:03','',''),('21','238',1395,'','20','2',11054042.23,0.00,'Sales from shift 141 on 2022-08-02 17:40:03 ','2022-08-02 17:40:03','',''),('21','238',1396,'','6.1','3',0.00,10628054.62,'Sales from shift 141 on 2022-08-02 17:40:03 ','2022-08-02 17:40:03','',''),('21','238',1397,'','24','5',0.00,5700000.00,'Purchase Id 111 for 30,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-08-03 15:00:24','',''),('21','238',1398,'','supplier','1',5700000.00,0.00,'Purchase Id 111 for 30,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-08-03 15:00:24','',''),('21','238',1399,'','customer','40',0.00,15007.98,'Credit Sales for 18.46 Litres of Diesel from shift 142 on 2022-08-04 14:37:17 ','2022-08-04 14:37:17','',''),('21','238',1400,'','20','2',5749020.58,0.00,'Sales from shift 142 on 2022-08-04 14:37:17 ','2022-08-04 14:37:17','',''),('21','238',1401,'','6.1','3',0.00,5734012.60,'Sales from shift 142 on 2022-08-04 14:37:17 ','2022-08-04 14:37:17','',''),('21','238',1402,'','customer','22',0.00,588823.38,'Credit Sales for 724.26 Litres of Diesel from shift 143 on 2022-08-04 14:55:21 ','2022-08-04 14:55:21','',''),('21','238',1403,'','customer','18',0.00,440003.73,'Credit Sales for 541.21 Litres of Diesel from shift 143 on 2022-08-04 14:55:21 ','2022-08-04 14:55:21','',''),('21','238',1404,'','customer','36',0.00,84454.44,'Credit Sales for 103.88 Litres of Diesel from shift 143 on 2022-08-04 14:55:21 ','2022-08-04 14:55:21','',''),('21','238',1405,'','customer','27',0.00,40650.00,'Credit Sales for 50.00 Litres of Diesel from shift 143 on 2022-08-04 14:55:21 ','2022-08-04 14:55:21','',''),('21','238',1406,'','customer','40',0.00,15007.98,'Credit Sales for 18.46 Litres of Diesel from shift 143 on 2022-08-04 14:55:21 ','2022-08-04 14:55:21','',''),('21','238',1407,'','20','2',11510570.58,0.00,'Sales from shift 143 on 2022-08-04 14:55:21 ','2022-08-04 14:55:21','',''),('21','238',1408,'','6.1','3',0.00,10341631.05,'Sales from shift 143 on 2022-08-04 14:55:21 ','2022-08-04 14:55:21','',''),('21','238',1409,'','24','5',0.00,5700000.00,'Purchase Id 112 for 30,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-08-05 19:47:58','',''),('21','238',1410,'','supplier','1',5700000.00,0.00,'Purchase Id 112 for 30,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-08-05 19:47:58','',''),('21','238',1411,'','customer','40',0.00,10008.03,'Credit Sales for 12.31 Litres of Diesel from shift 144 on 2022-08-07 17:29:58 ','2022-08-07 17:29:58','',''),('21','238',1412,'','customer','40',0.00,4998.90,'Credit Sales for 26.31 Litres of Petrol from shift 144 on 2022-08-07 17:29:58 ','2022-08-07 17:29:58','',''),('21','238',1413,'','customer','11',0.00,528450.00,'Credit Sales for 650.00 Litres of Diesel from shift 144 on 2022-08-07 17:29:58 ','2022-08-07 17:29:58','',''),('21','238',1414,'','customer','35',0.00,24390.00,'Credit Sales for 30.00 Litres of Diesel from shift 144 on 2022-08-07 17:29:58 ','2022-08-07 17:29:58','',''),('21','238',1415,'','20','2',0.00,0.00,'Sales from shift 144 on 2022-08-07 17:29:58 ','2022-08-07 17:29:58','',''),('21','238',1416,'','6.1','3',0.00,-567846.93,'Sales from shift 144 on 2022-08-07 17:29:58 ','2022-08-07 17:29:58','',''),('21','238',1417,'','24','5',0.00,2850000.00,'Purchase Id 113 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-08-07 17:36:33','',''),('21','238',1418,'','supplier','1',2850000.00,0.00,'Purchase Id 113 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-08-07 17:36:33','',''),('21','238',1419,'','24','5',0.00,13414500.00,'Purchase Id 114 for 16,500.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-08-07 17:46:05','',''),('21','238',1420,'','supplier','1',13414500.00,0.00,'Purchase Id 114 for 16,500.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-08-07 17:46:05','',''),('21','238',1421,'','customer','40',0.00,10008.03,'Credit Sales for 12.31 Litres of Diesel from shift 145 on 2022-08-07 18:22:50 ','2022-08-07 18:22:50','',''),('21','238',1422,'','customer','40',0.00,4998.90,'Credit Sales for 26.31 Litres of Petrol from shift 145 on 2022-08-07 18:22:50 ','2022-08-07 18:22:50','',''),('21','238',1423,'','customer','11',0.00,528450.00,'Credit Sales for 650.00 Litres of Diesel from shift 145 on 2022-08-07 18:22:50 ','2022-08-07 18:22:50','',''),('21','238',1424,'','customer','35',0.00,24390.00,'Credit Sales for 30.00 Litres of Diesel from shift 145 on 2022-08-07 18:22:50 ','2022-08-07 18:22:50','',''),('21','238',1425,'','20','2',7902952.78,0.00,'Sales from shift 145 on 2022-08-07 18:22:50 ','2022-08-07 18:22:50','',''),('21','238',1426,'','6.1','3',0.00,7335105.85,'Sales from shift 145 on 2022-08-07 18:22:50 ','2022-08-07 18:22:50','',''),('21','238',1427,'','customer','37',0.00,40650.00,'Credit Sales for 50.00 Litres of Diesel from shift 146 on 2022-08-08 09:50:21 ','2022-08-08 09:50:21','',''),('21','238',1428,'','customer','40',0.00,24007.89,'Credit Sales for 29.53 Litres of Diesel from shift 146 on 2022-08-08 09:50:21 ','2022-08-08 09:50:21','',''),('21','238',1429,'','customer','40',0.00,4998.90,'Credit Sales for 26.31 Litres of Petrol from shift 146 on 2022-08-08 09:50:21 ','2022-08-08 09:50:21','',''),('21','238',1430,'','customer','8',0.00,16260.00,'Credit Sales for 20.00 Litres of Diesel from shift 146 on 2022-08-08 09:50:21 ','2022-08-08 09:50:21','',''),('21','238',1431,'','20','2',10126695.99,0.00,'Sales from shift 146 on 2022-08-08 09:50:21 ','2022-08-08 09:50:21','',''),('21','238',1432,'','6.1','3',0.00,10040779.20,'Sales from shift 146 on 2022-08-08 09:50:21 ','2022-08-08 09:50:21','',''),('21','238',1433,'','24','5',0.00,2850000.00,'Purchase Id 115 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-08-08 09:56:10','',''),('21','238',1434,'','supplier','1',2850000.00,0.00,'Purchase Id 115 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-08-08 09:56:10','',''),('21','238',1435,'','customer','35',0.00,7503.99,'Credit Sales for 9.23 Litres of Diesel from shift 147 on 2022-08-08 17:16:57 ','2022-08-08 17:16:57','',''),('21','238',1436,'','customer','40',0.00,21503.85,'Credit Sales for 26.45 Litres of Diesel from shift 147 on 2022-08-08 17:16:57 ','2022-08-08 17:16:57','',''),('21','238',1437,'','customer','40',0.00,21390.03,'Credit Sales for 26.31 Litres of Diesel from shift 147 on 2022-08-08 17:16:57 ','2022-08-08 17:16:57','',''),('21','238',1438,'','20','2',5466473.31,0.00,'Sales from shift 147 on 2022-08-08 17:16:57 ','2022-08-08 17:16:57','',''),('21','238',1439,'','6.1','3',0.00,5416075.44,'Sales from shift 147 on 2022-08-08 17:16:57 ','2022-08-08 17:16:57','',''),('21','238',1440,'','customer','40',0.00,24007.89,'Credit Sales for 29.53 Litres of Diesel from shift 148 on 2022-08-09 11:33:12 ','2022-08-09 11:33:12','',''),('21','238',1441,'','customer','40',0.00,4998.90,'Credit Sales for 26.31 Litres of Petrol from shift 148 on 2022-08-09 11:33:12 ','2022-08-09 11:33:12','',''),('21','238',1442,'','customer','8',0.00,16260.00,'Credit Sales for 20.00 Litres of Diesel from shift 148 on 2022-08-09 11:33:12 ','2022-08-09 11:33:12','',''),('21','238',1443,'','20','2',5496758.13,0.00,'Sales from shift 148 on 2022-08-09 11:33:12 ','2022-08-09 11:33:12','',''),('21','238',1444,'','6.1','3',0.00,5451491.34,'Sales from shift 148 on 2022-08-09 11:33:12 ','2022-08-09 11:33:12','',''),('21','238',1445,'','24','5',0.00,2850000.00,'Purchase Id 116 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-08-09 12:37:10','',''),('21','238',1446,'','supplier','1',2850000.00,0.00,'Purchase Id 116 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-08-09 12:37:10','',''),('21','238',1447,'','customer','24',0.00,70007.43,'Credit Sales for 86.11 Litres of Diesel from shift 149 on 2022-08-10 17:30:03 ','2022-08-10 17:30:03','',''),('21','238',1448,'','customer','40',0.00,10008.03,'Credit Sales for 12.31 Litres of Diesel from shift 149 on 2022-08-10 17:30:03 ','2022-08-10 17:30:03','',''),('21','238',1449,'','customer','12',0.00,67804.20,'Credit Sales for 83.40 Litres of Diesel from shift 149 on 2022-08-10 17:30:03 ','2022-08-10 17:30:03','',''),('21','238',1450,'','20','2',4407291.25,0.00,'Sales from shift 149 on 2022-08-10 17:30:03 ','2022-08-10 17:30:03','',''),('21','238',1451,'','6.1','3',0.00,4259471.59,'Sales from shift 149 on 2022-08-10 17:30:03 ','2022-08-10 17:30:03','',''),('21','238',1452,'','customer','8',0.00,16528.29,'Credit Sales for 20.33 Litres of Diesel from shift 150 on 2022-08-10 18:19:32 ','2022-08-10 18:19:32','',''),('21','238',1453,'','customer','40',0.00,10008.03,'Credit Sales for 12.31 Litres of Diesel from shift 150 on 2022-08-10 18:19:32 ','2022-08-10 18:19:32','',''),('21','238',1454,'','customer','40',0.00,4998.90,'Credit Sales for 26.31 Litres of Petrol from shift 150 on 2022-08-10 18:19:32 ','2022-08-10 18:19:32','',''),('21','238',1455,'','customer','9',0.00,150006.63,'Credit Sales for 184.51 Litres of Diesel from shift 150 on 2022-08-10 18:19:32 ','2022-08-10 18:19:32','',''),('21','238',1456,'','20','2',9505463.88,0.00,'Sales from shift 150 on 2022-08-10 18:19:32 ','2022-08-10 18:19:32','',''),('21','238',1457,'','6.1','3',0.00,9323922.03,'Sales from shift 150 on 2022-08-10 18:19:32 ','2022-08-10 18:19:32','',''),('21','238',1458,'','24','5',0.00,12195000.00,'Purchase Id 117 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-08-10 18:31:28','',''),('21','238',1459,'','supplier','1',12195000.00,0.00,'Purchase Id 117 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-08-10 18:31:28','',''),('21','238',1460,'','customer','18',0.00,99999.00,'Credit Sales for 123.00 Litres of Diesel from shift 151 on 2022-08-11 16:44:18 ','2022-08-11 16:44:18','',''),('21','238',1461,'','customer','8',0.00,81300.00,'Credit Sales for 100.00 Litres of Diesel from shift 151 on 2022-08-11 16:44:18 ','2022-08-11 16:44:18','',''),('21','238',1462,'','customer','22',0.00,638205.00,'Credit Sales for 785.00 Litres of Diesel from shift 151 on 2022-08-11 16:44:18 ','2022-08-11 16:44:18','',''),('21','238',1463,'','customer','35',0.00,40300.41,'Credit Sales for 49.57 Litres of Diesel from shift 151 on 2022-08-11 16:44:18 ','2022-08-11 16:44:18','',''),('21','238',1464,'','customer','40',0.00,10008.03,'Credit Sales for 12.31 Litres of Diesel from shift 151 on 2022-08-11 16:44:18 ','2022-08-11 16:44:18','',''),('21','238',1465,'','customer','14',0.00,419101.50,'Credit Sales for 515.50 Litres of Diesel from shift 151 on 2022-08-11 16:44:18 ','2022-08-11 16:44:18','',''),('21','238',1466,'','20','2',6114072.00,0.00,'Sales from shift 151 on 2022-08-11 16:44:18 ','2022-08-11 16:44:18','',''),('21','238',1467,'','6.1','3',0.00,4825158.06,'Sales from shift 151 on 2022-08-11 16:44:18 ','2022-08-11 16:44:18','',''),('21','238',1468,'','24','5',0.00,5700000.00,'Purchase Id 118 for 30,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-08-12 15:32:03','',''),('21','238',1469,'','supplier','1',5700000.00,0.00,'Purchase Id 118 for 30,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-08-12 15:32:03','',''),('21','238',1470,'','24','5',0.00,24390000.00,'Purchase Id 119 for 30,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-08-12 15:41:07','',''),('21','238',1471,'','supplier','1',24390000.00,0.00,'Purchase Id 119 for 30,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-08-12 15:41:07','',''),('21','238',1472,'','24','5',0.00,24390000.00,'Purchase Id 120 for 30,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-08-12 15:51:13','',''),('21','238',1473,'','supplier','1',24390000.00,0.00,'Purchase Id 120 for 30,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-08-12 15:51:13','',''),('21','238',1474,'','24','5',0.00,2945000.00,'Purchase Id 122 for 15,500.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-08-12 17:15:26','',''),('21','238',1475,'','supplier','1',2945000.00,0.00,'Purchase Id 122 for 15,500.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-08-12 17:15:26','',''),('21','238',1476,'','customer','8',0.00,24390.00,'Credit Sales for 30.00 Litres of Diesel from shift 152 on 2022-08-12 17:50:20 ','2022-08-12 17:50:20','',''),('21','238',1477,'','customer','16',0.00,528450.00,'Credit Sales for 650.00 Litres of Diesel from shift 152 on 2022-08-12 17:50:20 ','2022-08-12 17:50:20','',''),('21','238',1478,'','customer','40',0.00,10008.03,'Credit Sales for 12.31 Litres of Diesel from shift 152 on 2022-08-12 17:50:20 ','2022-08-12 17:50:20','',''),('21','238',1479,'','customer','40',0.00,4998.90,'Credit Sales for 26.31 Litres of Petrol from shift 152 on 2022-08-12 17:50:20 ','2022-08-12 17:50:20','',''),('21','238',1480,'','20','2',10872237.85,0.00,'Sales from shift 152 on 2022-08-12 17:50:20 ','2022-08-12 17:50:20','',''),('21','238',1481,'','6.1','3',0.00,10304390.92,'Sales from shift 152 on 2022-08-12 17:50:20 ','2022-08-12 17:50:20','',''),('21','238',1482,'','20','2',17134.20,0.00,'Sales from shift 153 on 2022-08-15 12:45:49 ','2022-08-15 12:45:49','',''),('21','238',1483,'','6.1','3',0.00,17134.20,'Sales from shift 153 on 2022-08-15 12:45:49 ','2022-08-15 12:45:49','',''),('21','238',1484,'','customer','16',0.00,467475.00,'Credit Sales for 575.00 Litres of Diesel from shift 154 on 2022-08-15 13:10:24 ','2022-08-15 13:10:24','',''),('21','238',1485,'','customer','16',0.00,467475.00,'Credit Sales for 575.00 Litres of Diesel from shift 154 on 2022-08-15 13:10:24 ','2022-08-15 13:10:24','',''),('21','238',1486,'','customer','8',0.00,544710.00,'Credit Sales for 670.00 Litres of Diesel from shift 154 on 2022-08-15 13:10:24 ','2022-08-15 13:10:24','',''),('21','238',1487,'','customer','40',0.00,15007.98,'Credit Sales for 18.46 Litres of Diesel from shift 154 on 2022-08-15 13:10:24 ','2022-08-15 13:10:24','',''),('21','238',1488,'','20','2',11764034.89,0.00,'Sales from shift 154 on 2022-08-15 13:10:24 ','2022-08-15 13:10:24','',''),('21','238',1489,'','6.1','3',0.00,10269366.91,'Sales from shift 154 on 2022-08-15 13:10:24 ','2022-08-15 13:10:24','',''),('21','238',1490,'','customer','37',0.00,81300.00,'Credit Sales for 100.00 Litres of Diesel from shift 155 on 2022-08-15 13:52:44 ','2022-08-15 13:52:44','',''),('21','238',1491,'','customer','37',0.00,32520.00,'Credit Sales for 40.00 Litres of Diesel from shift 155 on 2022-08-15 13:52:44 ','2022-08-15 13:52:44','',''),('21','238',1492,'','customer','40',0.00,15007.98,'Credit Sales for 18.46 Litres of Diesel from shift 155 on 2022-08-15 13:52:44 ','2022-08-15 13:52:44','',''),('21','238',1493,'','customer','35',0.00,10008.03,'Credit Sales for 12.31 Litres of Diesel from shift 155 on 2022-08-15 13:52:44 ','2022-08-15 13:52:44','',''),('21','238',1494,'','20','2',4913097.65,0.00,'Sales from shift 155 on 2022-08-15 13:52:44 ','2022-08-15 13:52:44','',''),('21','238',1495,'','6.1','3',0.00,4774261.64,'Sales from shift 155 on 2022-08-15 13:52:44 ','2022-08-15 13:52:44','',''),('21','238',1496,'','24','5',0.00,2660000.00,'Purchase Id 123 for 14,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-08-15 14:30:33','',''),('21','238',1497,'','supplier','1',2660000.00,0.00,'Purchase Id 123 for 14,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-08-15 14:30:33','',''),('21','238',1498,'','customer','40',0.00,10100.40,'Credit Sales for 53.16 Litres of Petrol from shift 156 on 2022-08-15 19:41:36 ','2022-08-15 19:41:36','',''),('21','238',1499,'','customer','40',0.00,10008.03,'Credit Sales for 12.31 Litres of Diesel from shift 156 on 2022-08-15 19:41:36 ','2022-08-15 19:41:36','',''),('21','238',1500,'','customer','11',0.00,81300.00,'Credit Sales for 100.00 Litres of Diesel from shift 156 on 2022-08-15 19:41:36 ','2022-08-15 19:41:36','',''),('21','238',1501,'','customer','18',0.00,75007.38,'Credit Sales for 92.26 Litres of Diesel from shift 156 on 2022-08-15 19:41:36 ','2022-08-15 19:41:36','',''),('21','238',1502,'','customer','16',0.00,487800.00,'Credit Sales for 600.00 Litres of Diesel from shift 156 on 2022-08-15 19:41:36 ','2022-08-15 19:41:36','',''),('21','238',1503,'','20','2',6875065.10,0.00,'Sales from shift 156 on 2022-08-15 19:41:36 ','2022-08-15 19:41:36','',''),('21','238',1504,'','6.1','3',0.00,6210849.29,'Sales from shift 156 on 2022-08-15 19:41:36 ','2022-08-15 19:41:36','',''),('21','238',1505,'','20','2',3934226.28,0.00,'Sales from shift 157 on 2022-08-16 19:34:48 ','2022-08-16 19:34:48','',''),('21','238',1506,'','6.1','3',0.00,3934226.28,'Sales from shift 157 on 2022-08-16 19:34:48 ','2022-08-16 19:34:48','',''),('21','238',1507,'','24','5',0.00,4921000.00,'Purchase Id 124 for 25,900.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-08-16 19:49:50','',''),('21','238',1508,'','supplier','1',4921000.00,0.00,'Purchase Id 124 for 25,900.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-08-16 19:49:50','',''),('21','238',1509,'','24','5',0.00,5700000.00,'Purchase Id 125 for 30,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-08-17 09:41:58','',''),('21','238',1510,'','supplier','1',5700000.00,0.00,'Purchase Id 125 for 30,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-08-17 09:41:58','',''),('21','238',1511,'','customer','40',0.00,10008.03,'Credit Sales for 12.31 Litres of Diesel from shift 158 on 2022-08-17 11:04:34 ','2022-08-17 11:04:34','',''),('21','238',1512,'','customer','40',0.00,4998.90,'Credit Sales for 26.31 Litres of Petrol from shift 158 on 2022-08-17 11:04:34 ','2022-08-17 11:04:34','',''),('21','238',1513,'','customer','37',0.00,32520.00,'Credit Sales for 40.00 Litres of Diesel from shift 158 on 2022-08-17 11:04:34 ','2022-08-17 11:04:34','',''),('21','238',1514,'','customer','16',0.00,487800.00,'Credit Sales for 600.00 Litres of Diesel from shift 158 on 2022-08-17 11:04:34 ','2022-08-17 11:04:34','',''),('21','238',1515,'','20','2',8162674.30,0.00,'Sales from shift 158 on 2022-08-17 11:04:34 ','2022-08-17 11:04:34','',''),('21','238',1516,'','6.1','3',0.00,7627347.37,'Sales from shift 158 on 2022-08-17 11:04:34 ','2022-08-17 11:04:34','',''),('21','238',1517,'','2','27',149550.00,0.00,'Payment Id 1100 for invoice:154, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 17:20:05','',''),('21','238',1518,'','supplier','1',0.00,149550.00,'Payment Id 1100 for invoice:154, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 17:20:05','',''),('21','238',1519,'','2','27',274940.00,0.00,'Payment Id 1099 for invoice:155, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 17:20:25','',''),('21','238',1520,'','supplier','1',0.00,274940.00,'Payment Id 1099 for invoice:155, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 17:20:25','',''),('21','238',1521,'','2','27',2647870.00,0.00,'Payment Id 1097 for invoice:156, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 17:20:46','',''),('21','238',1522,'','supplier','1',0.00,2647870.00,'Payment Id 1097 for invoice:156, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 17:20:46','',''),('21','238',1523,'','2','27',4724790.00,0.00,'Payment Id 1078 for invoice:152, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 17:25:07','',''),('21','238',1524,'','supplier','1',0.00,4724790.00,'Payment Id 1078 for invoice:152, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 17:25:07','',''),('21','238',1525,'','2','18',1327511.00,0.00,'Payment Id 1072 for invoice:152, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 17:25:32','',''),('21','238',1526,'','supplier','1',0.00,1327511.00,'Payment Id 1072 for invoice:152, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 17:25:32','',''),('21','238',1527,'','2','27',1084250.00,0.00,'Payment Id 1071 for invoice:151, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 17:25:57','',''),('21','238',1528,'','supplier','1',0.00,1084250.00,'Payment Id 1071 for invoice:151, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 17:25:57','',''),('21','238',1529,'','2','27',1807895.00,0.00,'Payment Id 1045 for invoice:149, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 17:28:25','',''),('21','238',1530,'','supplier','1',0.00,1807895.00,'Payment Id 1045 for invoice:149, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 17:28:25','',''),('21','238',1531,'','2','18',684100.00,0.00,'Payment Id 1048 for invoice:150, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 17:29:00','',''),('21','238',1532,'','supplier','1',0.00,684100.00,'Payment Id 1048 for invoice:150, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 17:29:00','',''),('21','238',1533,'','2','18',180450.00,0.00,'Payment Id 1031 for invoice:147, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 17:32:02','',''),('21','238',1534,'','supplier','1',0.00,180450.00,'Payment Id 1031 for invoice:147, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 17:32:02','',''),('21','238',1535,'','2','27',2845160.00,0.00,'Payment Id 1013 for invoice:143, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 17:35:55','',''),('21','238',1536,'','supplier','1',0.00,2845160.00,'Payment Id 1013 for invoice:143, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 17:35:55','',''),('21','238',1537,'','2','15',1543855.00,0.00,'Payment Id 1011 for invoice:143, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 17:36:22','',''),('21','238',1538,'','supplier','1',0.00,1543855.00,'Payment Id 1011 for invoice:143, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 17:36:22','',''),('21','238',1539,'','2','27',2413480.00,0.00,'Payment Id 1010 for invoice:142, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 17:36:45','',''),('21','238',1540,'','supplier','1',0.00,2413480.00,'Payment Id 1010 for invoice:142, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 17:36:45','',''),('21','238',1541,'','2','15',1166200.00,0.00,'Payment Id 1007 for invoice:142, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 17:37:06','',''),('21','238',1542,'','supplier','1',0.00,1166200.00,'Payment Id 1007 for invoice:142, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 17:37:06','',''),('21','238',1543,'','2','27',1252445.00,0.00,'Payment Id 1006 for invoice:141, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 17:37:25','',''),('21','238',1544,'','supplier','1',0.00,1252445.00,'Payment Id 1006 for invoice:141, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 17:37:25','',''),('21','238',1545,'','2','18',134710.00,0.00,'Payment Id 991 for invoice:139, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 17:39:50','',''),('21','238',1546,'','supplier','1',0.00,134710.00,'Payment Id 991 for invoice:139, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 17:39:50','',''),('21','238',1547,'','2','18',815640.00,0.00,'Payment Id 967 for invoice:135, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 17:44:07','',''),('21','238',1548,'','supplier','1',0.00,815640.00,'Payment Id 967 for invoice:135, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 17:44:07','',''),('21','238',1549,'','2','27',285430.00,0.00,'Payment Id 971 for invoice:135, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 17:44:38','',''),('21','238',1550,'','supplier','1',0.00,285430.00,'Payment Id 971 for invoice:135, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 17:44:38','',''),('21','238',1551,'','2','27',956050.00,0.00,'Payment Id 953 for invoice:131, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 18:19:34','',''),('21','238',1552,'','supplier','1',0.00,956050.00,'Payment Id 953 for invoice:131, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 18:19:34','',''),('21','238',1553,'','2','27',1323290.00,0.00,'Payment Id 952 for invoice:130, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 18:19:57','',''),('21','238',1554,'','supplier','1',0.00,1323290.00,'Payment Id 952 for invoice:130, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 18:19:57','',''),('21','238',1555,'','2','18',150000.00,0.00,'Payment Id 948 for invoice:132, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 18:20:23','',''),('21','238',1556,'','supplier','1',0.00,150000.00,'Payment Id 948 for invoice:132, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 18:20:23','',''),('21','238',1557,'','2','27',1915080.00,0.00,'Payment Id 933 for invoice:128, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 18:26:50','',''),('21','238',1558,'','supplier','1',0.00,1915080.00,'Payment Id 933 for invoice:128, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 18:26:50','',''),('21','238',1559,'','2','15',1890137.07,0.00,'Payment Id 931 for invoice:128, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 18:27:16','',''),('21','238',1560,'','supplier','1',0.00,1890137.07,'Payment Id 931 for invoice:128, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 18:27:16','',''),('21','238',1561,'','2','27',96125.00,0.00,'Payment Id 928 for invoice:126, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 18:27:37','',''),('21','238',1562,'','supplier','1',0.00,96125.00,'Payment Id 928 for invoice:126, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 18:27:37','',''),('21','238',1563,'','2','27',940235.00,0.00,'Payment Id 927 for invoice:126, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 18:28:08','',''),('21','238',1564,'','supplier','1',0.00,940235.00,'Payment Id 927 for invoice:126, receipt:  by AYM SHAFA NIGERIA. LTD','2022-08-18 18:28:08','',''),('21','238',1565,'','customer','11',0.00,751707.93,'Credit Sales for 924.61 Litres of Diesel from shift 159 on 2022-08-18 19:34:42 ','2022-08-18 19:34:42','',''),('21','238',1566,'','customer','11',0.00,213258.03,'Credit Sales for 262.31 Litres of Diesel from shift 159 on 2022-08-18 19:34:42 ','2022-08-18 19:34:42','',''),('21','238',1567,'','customer','40',0.00,15007.98,'Credit Sales for 18.46 Litres of Diesel from shift 159 on 2022-08-18 19:34:42 ','2022-08-18 19:34:42','',''),('21','238',1568,'','20','2',9172610.90,0.00,'Sales from shift 159 on 2022-08-18 19:34:42 ','2022-08-18 19:34:42','',''),('21','238',1569,'','6.1','3',0.00,8192636.96,'Sales from shift 159 on 2022-08-18 19:34:42 ','2022-08-18 19:34:42','',''),('21','238',1570,'','24','5',0.00,3249000.00,'Purchase Id 126 for 17,100.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-08-19 11:10:41','',''),('21','238',1571,'','supplier','1',3249000.00,0.00,'Purchase Id 126 for 17,100.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-08-19 11:10:41','',''),('21','238',1572,'','24','5',0.00,2850000.00,'Purchase Id 127 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-08-19 11:16:31','',''),('21','238',1573,'','supplier','1',2850000.00,0.00,'Purchase Id 127 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-08-19 11:16:31','',''),('21','238',1574,'','customer','12',0.00,413004.00,'Credit Sales for 508.00 Litres of Diesel from shift 160 on 2022-08-19 11:49:52 ','2022-08-19 11:49:52','',''),('21','238',1575,'','customer','27',0.00,162600.00,'Credit Sales for 200.00 Litres of Diesel from shift 160 on 2022-08-19 11:49:52 ','2022-08-19 11:49:52','',''),('21','238',1576,'','customer','40',0.00,15007.98,'Credit Sales for 18.46 Litres of Diesel from shift 160 on 2022-08-19 11:49:52 ','2022-08-19 11:49:52','',''),('21','238',1577,'','customer','16',0.00,487800.00,'Credit Sales for 600.00 Litres of Diesel from shift 160 on 2022-08-19 11:49:52 ','2022-08-19 11:49:52','',''),('21','238',1578,'','customer','16',0.00,528450.00,'Credit Sales for 650.00 Litres of Diesel from shift 160 on 2022-08-19 11:49:52 ','2022-08-19 11:49:52','',''),('21','238',1579,'','customer','16',0.00,467475.00,'Credit Sales for 575.00 Litres of Diesel from shift 160 on 2022-08-19 11:49:52 ','2022-08-19 11:49:52','',''),('21','238',1580,'','20','2',8394332.15,0.00,'Sales from shift 160 on 2022-08-19 11:49:52 ','2022-08-19 11:49:52','',''),('21','238',1581,'','6.1','3',0.00,6319995.17,'Sales from shift 160 on 2022-08-19 11:49:52 ','2022-08-19 11:49:52','',''),('21','238',1582,'','24','5',0.00,5700000.00,'Purchase Id 128 for 30,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-08-24 09:46:52','',''),('21','238',1583,'','supplier','1',5700000.00,0.00,'Purchase Id 128 for 30,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-08-24 09:46:52','',''),('21','238',1584,'','customer','37',0.00,103740.00,'Credit Sales for 130.00 Litres of Diesel from shift 161 on 2022-08-24 10:32:03 ','2022-08-24 10:32:03','',''),('21','238',1585,'','customer','37',0.00,103740.00,'Credit Sales for 130.00 Litres of Diesel from shift 161 on 2022-08-24 10:32:03 ','2022-08-24 10:32:03','',''),('21','238',1586,'','customer','37',0.00,103740.00,'Credit Sales for 130.00 Litres of Diesel from shift 161 on 2022-08-24 10:32:03 ','2022-08-24 10:32:03','',''),('21','238',1587,'','customer','8',0.00,58597.14,'Credit Sales for 73.43 Litres of Diesel from shift 161 on 2022-08-24 10:32:03 ','2022-08-24 10:32:03','',''),('21','238',1588,'','customer','16',0.00,458850.00,'Credit Sales for 575.00 Litres of Diesel from shift 161 on 2022-08-24 10:32:03 ','2022-08-24 10:32:03','',''),('21','238',1589,'','customer','40',0.00,15002.40,'Credit Sales for 18.80 Litres of Diesel from shift 161 on 2022-08-24 10:32:03 ','2022-08-24 10:32:03','',''),('21','238',1590,'','20','2',7943066.00,0.00,'Sales from shift 161 on 2022-08-24 10:32:03 ','2022-08-24 10:32:03','',''),('21','238',1591,'','6.1','3',0.00,7099396.46,'Sales from shift 161 on 2022-08-24 10:32:03 ','2022-08-24 10:32:03','',''),('21','238',1592,'','customer','18',0.00,19950.00,'Credit Sales for 25.00 Litres of Diesel from shift 162 on 2022-08-24 12:48:29 ','2022-08-24 12:48:29','',''),('21','238',1593,'','customer','18',0.00,59506.86,'Credit Sales for 74.57 Litres of Diesel from shift 162 on 2022-08-24 12:48:29 ','2022-08-24 12:48:29','',''),('21','238',1594,'','customer','40',0.00,15002.40,'Credit Sales for 18.80 Litres of Diesel from shift 162 on 2022-08-24 12:48:29 ','2022-08-24 12:48:29','',''),('21','238',1595,'','20','2',7337957.44,0.00,'Sales from shift 162 on 2022-08-24 12:48:29 ','2022-08-24 12:48:29','',''),('21','238',1596,'','6.1','3',0.00,7243498.18,'Sales from shift 162 on 2022-08-24 12:48:29 ','2022-08-24 12:48:29','',''),('21','238',1597,'','24','5',0.00,35910000.00,'Purchase Id 129 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-08-24 18:17:10','',''),('21','238',1598,'','supplier','1',35910000.00,0.00,'Purchase Id 129 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-08-24 18:17:10','',''),('21','238',1599,'','20','2',7814503.96,0.00,'Sales from shift 163 on 2022-08-24 18:30:58 ','2022-08-24 18:30:58','',''),('21','238',1600,'','6.1','3',0.00,7814503.96,'Sales from shift 163 on 2022-08-24 18:30:58 ','2022-08-24 18:30:58','',''),('21','238',1601,'','20','2',8960435.50,0.00,'Sales from shift 164 on 2022-08-24 18:44:15 ','2022-08-24 18:44:15','',''),('21','238',1602,'','6.1','3',0.00,8960435.50,'Sales from shift 164 on 2022-08-24 18:44:15 ','2022-08-24 18:44:15','',''),('21','238',1603,'','24','5',0.00,5795000.00,'Purchase Id 130 for 30,500.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-08-24 19:12:09','',''),('21','238',1604,'','supplier','1',5795000.00,0.00,'Purchase Id 130 for 30,500.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-08-24 19:12:09','',''),('21','238',1605,'','20','2',4858615.52,0.00,'Sales from shift 165 on 2022-08-24 19:30:25 ','2022-08-24 19:30:25','',''),('21','238',1606,'','6.1','3',0.00,4858615.52,'Sales from shift 165 on 2022-08-24 19:30:25 ','2022-08-24 19:30:25','',''),('21','238',1607,'','24','5',0.00,15960000.00,'Purchase Id 131 for 20,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-08-24 19:33:43','',''),('21','238',1608,'','supplier','1',15960000.00,0.00,'Purchase Id 131 for 20,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-08-24 19:33:43','',''),('21','238',1609,'','20','2',5496500.48,0.00,'Sales from shift 166 on 2022-08-26 13:13:35 ','2022-08-26 13:13:35','',''),('21','238',1610,'','6.1','3',0.00,5496500.48,'Sales from shift 166 on 2022-08-26 13:13:35 ','2022-08-26 13:13:35','',''),('21','238',1611,'','24','5',0.00,5700000.00,'Purchase Id 132 for 30,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-08-26 13:26:38','',''),('21','238',1612,'','supplier','1',5700000.00,0.00,'Purchase Id 132 for 30,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-08-26 13:26:38','',''),('21','238',1613,'','20','2',7359732.72,0.00,'Sales from shift 167 on 2022-08-26 13:36:03 ','2022-08-26 13:36:03','',''),('21','238',1614,'','6.1','3',0.00,7359732.72,'Sales from shift 167 on 2022-08-26 13:36:03 ','2022-08-26 13:36:03','',''),('21','238',1615,'','24','5',0.00,5700000.00,'Purchase Id 133 for 30,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-08-28 19:58:04','',''),('21','238',1616,'','supplier','1',5700000.00,0.00,'Purchase Id 133 for 30,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-08-28 19:58:04','',''),('21','238',1617,'','24','5',0.00,8550000.00,'Purchase Id 134 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-08-28 20:02:50','',''),('21','238',1618,'','supplier','1',8550000.00,0.00,'Purchase Id 134 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-08-28 20:02:50','',''),('21','238',1619,'','20','2',6633549.02,0.00,'Sales from shift 168 on 2022-08-29 12:08:52 ','2022-08-29 12:08:52','',''),('21','238',1620,'','6.1','3',0.00,6633549.02,'Sales from shift 168 on 2022-08-29 12:08:52 ','2022-08-29 12:08:52','',''),('21','238',1621,'','20','2',6652850.96,0.00,'Sales from shift 169 on 2022-08-29 12:36:35 ','2022-08-29 12:36:35','',''),('21','238',1622,'','6.1','3',0.00,6652850.96,'Sales from shift 169 on 2022-08-29 12:36:35 ','2022-08-29 12:36:35','',''),('21','238',1623,'','20','2',7082993.26,0.00,'Sales from shift 170 on 2022-08-29 12:47:08 ','2022-08-29 12:47:08','',''),('21','238',1624,'','6.1','3',0.00,7082993.26,'Sales from shift 170 on 2022-08-29 12:47:08 ','2022-08-29 12:47:08','',''),('21','238',1625,'','24','5',0.00,2850000.00,'Purchase Id 135 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-08-30 11:16:10','',''),('21','238',1626,'','supplier','1',2850000.00,0.00,'Purchase Id 135 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-08-30 11:16:10','',''),('21','238',1627,'','20','2',7589662.26,0.00,'Sales from shift 171 on 2022-08-30 11:29:57 ','2022-08-30 11:29:57','',''),('21','238',1628,'','6.1','3',0.00,7589662.26,'Sales from shift 171 on 2022-08-30 11:29:57 ','2022-08-30 11:29:57','',''),('21','238',1629,'','20','2',7122988.34,0.00,'Sales from shift 172 on 2022-08-31 13:19:20 ','2022-08-31 13:19:20','',''),('21','238',1630,'','6.1','3',0.00,7122988.34,'Sales from shift 172 on 2022-08-31 13:19:20 ','2022-08-31 13:19:20','',''),('21','238',1631,'','20','2',8056367.42,0.00,'Sales from shift 173 on 2022-09-01 12:22:53 ','2022-09-01 12:22:53','',''),('21','238',1632,'','6.1','3',0.00,8056367.42,'Sales from shift 173 on 2022-09-01 12:22:53 ','2022-09-01 12:22:53','',''),('21','238',1633,'','24','5',0.00,23940000.00,'Purchase Id 136 for 30,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-09-02 14:54:52','',''),('21','238',1634,'','supplier','1',23940000.00,0.00,'Purchase Id 136 for 30,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-09-02 14:54:52','',''),('21','238',1635,'','24','5',0.00,5700000.00,'Purchase Id 137 for 30,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-09-02 15:07:18','',''),('21','238',1636,'','supplier','1',5700000.00,0.00,'Purchase Id 137 for 30,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-09-02 15:07:18','',''),('21','238',1637,'','20','2',5696454.96,0.00,'Sales from shift 174 on 2022-09-02 15:34:41 ','2022-09-02 15:34:41','',''),('21','238',1638,'','6.1','3',0.00,5696454.96,'Sales from shift 174 on 2022-09-02 15:34:41 ','2022-09-02 15:34:41','',''),('21','238',1639,'','20','2',7414172.14,0.00,'Sales from shift 175 on 2022-09-03 19:48:08 ','2022-09-03 19:48:08','',''),('21','238',1640,'','6.1','3',0.00,7414172.14,'Sales from shift 175 on 2022-09-03 19:48:08 ','2022-09-03 19:48:08','',''),('21','238',1641,'','20','2',7762707.10,0.00,'Sales from shift 176 on 2022-09-04 15:56:43 ','2022-09-04 15:56:43','',''),('21','238',1642,'','6.1','3',0.00,7762707.10,'Sales from shift 176 on 2022-09-04 15:56:43 ','2022-09-04 15:56:43','',''),('21','238',1643,'','24','5',0.00,23940000.00,'Purchase Id 138 for 30,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-09-04 16:21:10','',''),('21','238',1644,'','supplier','1',23940000.00,0.00,'Purchase Id 138 for 30,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-09-04 16:21:10','',''),('21','238',1645,'','24','5',0.00,6270000.00,'Purchase Id 139 for 33,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-09-04 16:28:03','',''),('21','238',1646,'','supplier','1',6270000.00,0.00,'Purchase Id 139 for 33,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-09-04 16:28:03','',''),('21','238',1647,'','20','2',9540673.74,0.00,'Sales from shift 177 on 2022-09-05 11:32:50 ','2022-09-05 11:32:50','',''),('21','238',1648,'','6.1','3',0.00,9540673.74,'Sales from shift 177 on 2022-09-05 11:32:50 ','2022-09-05 11:32:50','',''),('21','238',1649,'','20','2',8420161.40,0.00,'Sales from shift 178 on 2022-09-06 17:59:07 ','2022-09-06 17:59:07','',''),('21','238',1650,'','6.1','3',0.00,8420161.40,'Sales from shift 178 on 2022-09-06 17:59:07 ','2022-09-06 17:59:07','',''),('21','238',1651,'','24','5',0.00,6270000.00,'Purchase Id 140 for 33,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-09-12 18:34:10','',''),('21','238',1652,'','supplier','1',6270000.00,0.00,'Purchase Id 140 for 33,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-09-12 18:34:10','',''),('21','238',1653,'','24','5',0.00,8493000.00,'Purchase Id 141 for 44,700.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-09-12 19:26:29','',''),('21','238',1654,'','supplier','1',8493000.00,0.00,'Purchase Id 141 for 44,700.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-09-12 19:26:29','',''),('21','238',1655,'','20','2',7831048.88,0.00,'Sales from shift 179 on 2022-09-12 19:37:09 ','2022-09-12 19:37:09','',''),('21','238',1656,'','6.1','3',0.00,7831048.88,'Sales from shift 179 on 2022-09-12 19:37:09 ','2022-09-12 19:37:09','',''),('21','238',1657,'','20','2',4997368.22,0.00,'Sales from shift 180 on 2022-09-12 20:56:51 ','2022-09-12 20:56:51','',''),('21','238',1658,'','6.1','3',0.00,4997368.22,'Sales from shift 180 on 2022-09-12 20:56:51 ','2022-09-12 20:56:51','',''),('21','238',1659,'','20','2',7429701.22,0.00,'Sales from shift 181 on 2022-09-12 21:27:39 ','2022-09-12 21:27:39','',''),('21','238',1660,'','6.1','3',0.00,7429701.22,'Sales from shift 181 on 2022-09-12 21:27:39 ','2022-09-12 21:27:39','',''),('21','238',1661,'','20','2',7355496.70,0.00,'Sales from shift 182 on 2022-09-13 13:38:49 ','2022-09-13 13:38:49','',''),('21','238',1662,'','6.1','3',0.00,7355496.70,'Sales from shift 182 on 2022-09-13 13:38:49 ','2022-09-13 13:38:49','',''),('21','238',1663,'','20','2',8045609.06,0.00,'Sales from shift 183 on 2022-09-13 19:08:42 ','2022-09-13 19:08:42','',''),('21','238',1664,'','6.1','3',0.00,8045609.06,'Sales from shift 183 on 2022-09-13 19:08:42 ','2022-09-13 19:08:42','',''),('21','238',1665,'','20','2',6898548.26,0.00,'Sales from shift 184 on 2022-09-13 19:42:38 ','2022-09-13 19:42:38','',''),('21','238',1666,'','6.1','3',0.00,6898548.26,'Sales from shift 184 on 2022-09-13 19:42:38 ','2022-09-13 19:42:38','',''),('21','238',1667,'','24','5',0.00,5339000.00,'Purchase Id 142 for 28,100.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-09-13 20:27:35','',''),('21','238',1668,'','supplier','1',5339000.00,0.00,'Purchase Id 142 for 28,100.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-09-13 20:27:35','',''),('21','238',1669,'','20','2',7190522.44,0.00,'Sales from shift 185 on 2022-09-14 19:45:22 ','2022-09-14 19:45:22','',''),('21','238',1670,'','6.1','3',0.00,7190522.44,'Sales from shift 185 on 2022-09-14 19:45:22 ','2022-09-14 19:45:22','',''),('21','238',1671,'','24','5',0.00,5890000.00,'Purchase Id 143 for 31,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-09-14 20:40:24','',''),('21','238',1672,'','supplier','1',5890000.00,0.00,'Purchase Id 143 for 31,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-09-14 20:40:24','',''),('21','238',1673,'','20','2',2822229.80,0.00,'Sales from shift 186 on 2022-09-14 21:48:42 ','2022-09-14 21:48:42','',''),('21','238',1674,'','6.1','3',0.00,2822229.80,'Sales from shift 186 on 2022-09-14 21:48:42 ','2022-09-14 21:48:42','',''),('21','238',1675,'','20','2',3114953.40,0.00,'Sales from shift 187 on 2022-09-15 11:16:07 ','2022-09-15 11:16:07','',''),('21','238',1676,'','6.1','3',0.00,3114953.40,'Sales from shift 187 on 2022-09-15 11:16:07 ','2022-09-15 11:16:07','',''),('21','238',1677,'','20','2',2801349.90,0.00,'Sales from shift 188 on 2022-09-16 12:52:35 ','2022-09-16 12:52:35','',''),('21','238',1678,'','6.1','3',0.00,2801349.90,'Sales from shift 188 on 2022-09-16 12:52:35 ','2022-09-16 12:52:35','',''),('21','238',1679,'','24','5',0.00,5605000.00,'Purchase Id 144 for 29,500.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-09-17 12:53:00','',''),('21','238',1680,'','supplier','1',5605000.00,0.00,'Purchase Id 144 for 29,500.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-09-17 12:53:00','',''),('21','238',1681,'','20','2',2444321.70,0.00,'Sales from shift 189 on 2022-09-17 13:06:19 ','2022-09-17 13:06:19','',''),('21','238',1682,'','6.1','3',0.00,2444321.70,'Sales from shift 189 on 2022-09-17 13:06:19 ','2022-09-17 13:06:19','',''),('21','238',1683,'','24','5',0.00,11970000.00,'Purchase Id 145 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-09-18 17:28:40','',''),('21','238',1684,'','supplier','1',11970000.00,0.00,'Purchase Id 145 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-09-18 17:28:40','',''),('21','238',1685,'','24','5',0.00,5700000.00,'Purchase Id 146 for 30,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-09-18 17:31:53','',''),('21','238',1686,'','supplier','1',5700000.00,0.00,'Purchase Id 146 for 30,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-09-18 17:31:53','',''),('21','238',1687,'','20','2',5989114.62,0.00,'Sales from shift 190 on 2022-09-18 17:38:47 ','2022-09-18 17:38:47','',''),('21','238',1688,'','6.1','3',0.00,5989114.62,'Sales from shift 190 on 2022-09-18 17:38:47 ','2022-09-18 17:38:47','',''),('21','238',1689,'','20','2',8781658.08,0.00,'Sales from shift 191 on 2022-09-19 18:33:35 ','2022-09-19 18:33:35','',''),('21','238',1690,'','6.1','3',0.00,8781658.08,'Sales from shift 191 on 2022-09-19 18:33:35 ','2022-09-19 18:33:35','',''),('21','238',1691,'','20','2',4174067.36,0.00,'Sales from shift 192 on 2022-09-20 14:11:36 ','2022-09-20 14:11:36','',''),('21','238',1692,'','6.1','3',0.00,4174067.36,'Sales from shift 192 on 2022-09-20 14:11:36 ','2022-09-20 14:11:36','',''),('21','238',1693,'','24','5',0.00,8550000.00,'Purchase Id 147 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-09-21 11:46:42','',''),('21','238',1694,'','supplier','1',8550000.00,0.00,'Purchase Id 147 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-09-21 11:46:42','',''),('21','238',1695,'','24','5',0.00,11970000.00,'Purchase Id 148 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-09-21 16:42:07','',''),('21','238',1696,'','supplier','1',11970000.00,0.00,'Purchase Id 148 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-09-21 16:42:07','',''),('21','238',1697,'','20','2',3997690.80,0.00,'Sales from shift 193 on 2022-09-21 16:55:35 ','2022-09-21 16:55:35','',''),('21','238',1698,'','6.1','3',0.00,3997690.80,'Sales from shift 193 on 2022-09-21 16:55:35 ','2022-09-21 16:55:35','',''),('21','238',1699,'','20','2',1428541.60,0.00,'Sales from shift 194 on 2022-09-22 12:58:03 ','2022-09-22 12:58:03','',''),('21','238',1700,'','6.1','3',0.00,1428541.60,'Sales from shift 194 on 2022-09-22 12:58:03 ','2022-09-22 12:58:03','',''),('21','238',1701,'','20','2',6222441.17,0.00,'Sales from shift 195 on 2022-09-22 13:06:51 ','2022-09-22 13:06:51','',''),('21','238',1702,'','6.1','3',0.00,6222441.17,'Sales from shift 195 on 2022-09-22 13:06:51 ','2022-09-22 13:06:51','',''),('21','238',1703,'','20','2',7584531.31,0.00,'Sales from shift 196 on 2022-09-23 17:27:43 ','2022-09-23 17:27:43','',''),('21','238',1704,'','6.1','3',0.00,7584531.31,'Sales from shift 196 on 2022-09-23 17:27:43 ','2022-09-23 17:27:43','',''),('21','238',1705,'','20','2',2954461.70,0.00,'Sales from shift 197 on 2022-09-25 12:12:47 ','2022-09-25 12:12:47','',''),('21','238',1706,'','6.1','3',0.00,2954461.70,'Sales from shift 197 on 2022-09-25 12:12:47 ','2022-09-25 12:12:47','',''),('21','238',1707,'','24','5',0.00,2775000.00,'Purchase Id 149 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-09-25 12:25:55','',''),('21','238',1708,'','supplier','1',2775000.00,0.00,'Purchase Id 149 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-09-25 12:25:55','',''),('21','238',1709,'','24','5',0.00,3700000.00,'Purchase Id 150 for 20,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-09-25 12:30:29','',''),('21','238',1710,'','supplier','1',3700000.00,0.00,'Purchase Id 150 for 20,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-09-25 12:30:29','',''),('21','238',1711,'','20','2',2163039.90,0.00,'Sales from shift 198 on 2022-09-25 12:39:33 ','2022-09-25 12:39:33','',''),('21','238',1712,'','6.1','3',0.00,2163039.90,'Sales from shift 198 on 2022-09-25 12:39:33 ','2022-09-25 12:39:33','',''),('21','238',1713,'','24','5',0.00,2775000.00,'Purchase Id 151 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-09-26 14:29:49','',''),('21','238',1714,'','supplier','1',2775000.00,0.00,'Purchase Id 151 for 15,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-09-26 14:29:49','',''),('21','238',1715,'','20','2',2889036.25,0.00,'Sales from shift 199 on 2022-09-26 14:47:27 ','2022-09-26 14:47:27','',''),('21','238',1716,'','6.1','3',0.00,2889036.25,'Sales from shift 199 on 2022-09-26 14:47:27 ','2022-09-26 14:47:27','',''),('21','238',1717,'','24','5',0.00,11890200.00,'Purchase Id 152 for 14,900.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-09-27 15:51:53','',''),('21','238',1718,'','supplier','1',11890200.00,0.00,'Purchase Id 152 for 14,900.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-09-27 15:51:53','',''),('21','238',1719,'','20','2',4039152.46,0.00,'Sales from shift 200 on 2022-09-27 16:13:14 ','2022-09-27 16:13:14','',''),('21','238',1720,'','6.1','3',0.00,4039152.46,'Sales from shift 200 on 2022-09-27 16:13:14 ','2022-09-27 16:13:14','',''),('21','238',1721,'','24','5',0.00,8325000.00,'Purchase Id 153 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-09-27 16:50:01','',''),('21','238',1722,'','supplier','1',8325000.00,0.00,'Purchase Id 153 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-09-27 16:50:01','',''),('21','238',1723,'','20','2',8210910.50,0.00,'Sales from shift 201 on 2022-09-28 21:12:48 ','2022-09-28 21:12:48','',''),('21','238',1724,'','6.1','3',0.00,8210910.50,'Sales from shift 201 on 2022-09-28 21:12:48 ','2022-09-28 21:12:48','',''),('21','238',1725,'','20','2',0.00,0.00,'Sales from shift 202 on 2022-09-29 16:24:50 ','2022-09-29 16:24:50','',''),('21','238',1726,'','6.1','3',0.00,0.00,'Sales from shift 202 on 2022-09-29 16:24:50 ','2022-09-29 16:24:50','',''),('21','238',1727,'','20','2',7531113.50,0.00,'Sales from shift 203 on 2022-09-29 17:37:15 ','2022-09-29 17:37:15','',''),('21','238',1728,'','6.1','3',0.00,7531113.50,'Sales from shift 203 on 2022-09-29 17:37:15 ','2022-09-29 17:37:15','',''),('21','238',1729,'','20','2',3179850.80,0.00,'Sales from shift 204 on 2022-10-12 16:51:26 ','2022-10-12 16:51:26','',''),('21','238',1730,'','6.