-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_21_station_237
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_21_station_237`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_21_station_237` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_21_station_237`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,7000,'',0,'20','21','237','SALES','','2022-03-03 23:37:06',5,0.00,0.00,'','764','2022-03-03 23:37:06','764',0,0),(2,500,'',0,'6.1','21','237','CASH','','2022-03-03 23:37:20',5,0.00,0.00,'','764','2022-03-03 23:37:20','764',0,0),(3,8000,'',0,'24','21','237','SALARIES & WAGES','','2022-03-03 23:38:06',5,0.00,0.00,'','764','2022-03-03 23:38:06','764',0,0),(4,8001,'',0,'24','21','237','PURCHASES','','2022-03-03 23:38:32',5,0.00,0.00,'','764','2022-03-03 23:38:32','764',0,0),(5,4000,'',0,'22','21','237','PURCHASES','','2022-03-03 23:39:23',5,0.00,0.00,'','764','2022-03-03 23:39:23','764',0,0),(6,2500,'',0,'2','21','237','ZENITH BANK','','2022-03-23 14:20:20',5,0.00,0.00,'','764','2022-03-23 14:20:20','764',0,0),(7,2501,'',0,'2','21','237','zenith Bank pos','','2022-03-23 14:20:28',5,0.00,0.00,'','764','2022-03-23 14:20:28','764',0,0),(8,2502,'',0,'2','21','237','ZENITH BANK TRANSFER ACC','','2022-03-23 14:20:35',5,0.00,0.00,'','764','2022-03-23 14:20:35','764',0,0),(9,2503,'',0,'2','21','237','FIRST BANK POS\\','','2022-03-23 14:20:44',5,0.00,0.00,'','764','2022-03-23 14:20:44','764',0,0),(10,2504,'',0,'2','21','237','FIRST BANK TRANSFER ACCOUNT','','2022-03-23 14:20:52',5,0.00,0.00,'','764','2022-03-23 14:20:52','764',0,0),(11,2505,'',0,'2','21','237','FIRST BANK','','2022-03-23 14:21:00',5,0.00,0.00,'','764','2022-03-23 14:21:00','764',0,0),(12,2506,'',0,'2','21','237','UBA BANK','','2022-03-23 14:21:12',5,0.00,0.00,'','764','2022-03-23 14:21:12','764',0,0),(13,2507,'',0,'2','21','237','UBA TRANSFER ACC','','2022-03-23 14:21:22',5,0.00,0.00,'','764','2022-03-23 14:21:22','764',0,0),(14,2508,'',0,'2','21','237','UBA POS','','2022-03-23 14:21:32',5,0.00,0.00,'','764','2022-03-23 14:21:32','764',0,0),(15,2509,'',0,'2','21','237','IBTC POS','','2022-03-23 14:21:40',5,0.00,0.00,'','764','2022-03-23 14:21:40','764',0,0),(16,2510,'',0,'2','21','237','IBTC TRANSFER ACCOUNT','','2022-03-23 14:21:48',5,0.00,0.00,'','764','2022-03-23 14:21:48','764',0,0),(17,2511,'',0,'2','21','237','IBTC BANK','','2022-03-23 14:22:00',5,0.00,0.00,'','764','2022-03-23 14:22:00','764',0,0),(18,2512,'',0,'2','21','237','GT BANK POS','','2022-03-23 14:22:11',5,0.00,0.00,'','764','2022-03-23 14:22:11','764',0,0),(19,2513,'',0,'2','21','237','GT BANK TRANSFER ACCOUNT','','2022-03-23 14:22:18',5,0.00,0.00,'','764','2022-03-23 14:22:18','764',0,0),(20,2514,'',0,'2','21','237','GT BANK','','2022-03-23 14:22:34',5,0.00,0.00,'','764','2022-03-23 14:22:34','764',0,0),(21,2515,'',0,'2','21','237','JAIZ BANK','','2022-03-23 14:22:45',5,0.00,0.00,'','764','2022-03-23 14:22:45','764',0,0),(22,2516,'',0,'2','21','237','JAIZ POS','','2022-03-23 14:22:52',5,0.00,0.00,'','764','2022-03-23 14:22:52','764',0,0),(23,2517,'',0,'2','21','237','JAIZ TRANSFER ACCOUNT','','2022-03-23 14:23:01',5,0.00,0.00,'','764','2022-03-23 14:23:01','764',0,0),(24,2518,'',0,'2','21','237','Unity Bank','','2022-03-26 17:33:46',5,0.00,0.00,'','764','2022-03-26 17:33:46','764',0,0),(25,2519,'',0,'2','21','237','Ecobank plc','','2022-03-26 17:34:28',5,0.00,0.00,'','764','2022-03-26 17:34:28','764',0,0),(26,2520,'',0,'2','21','237','Unity Bank POS','','2022-03-26 17:34:47',5,0.00,0.00,'','764','2022-03-26 17:34:47','764',0,0),(27,2521,'',0,'2','21','237','UNITY Bank Transfer account ','','2022-03-26 17:35:12',5,0.00,0.00,'','764','2022-03-26 17:35:12','764',0,0),(28,2522,'',0,'2','21','237','Ecobank POS','','2022-03-26 17:35:38',5,0.00,0.00,'','764','2022-03-26 17:35:38','764',0,0),(29,2523,'',0,'2','21','237','Ecobank Transfer account ','','2022-03-26 17:35:53',5,0.00,0.00,'','764','2022-03-26 17:35:53','764',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=53 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('21','237',1,'1',0.00,2200.00,'2022-03-23','','2022-03-26 14:02:02','764','764',2022,'764','2022-03-26 14:02:02',5),('21','237',2,'2',0.00,29600.00,'2022-03-23','','2022-03-26 14:02:29','764','764',2022,'764','2022-03-26 14:02:29',5),('21','237',3,'3',0.00,27500.00,'2022-03-23','','2022-03-26 14:03:45','764','764',2022,'764','2022-03-26 14:03:45',5),('21','237',4,'4',0.00,43600.00,'2022-03-23','','2022-03-26 14:04:13','764','764',2022,'764','2022-03-26 14:04:13',5),('21','237',5,'5',0.00,8850.00,'2022-03-23','','2022-03-26 14:04:36','764','764',2022,'764','2022-03-26 14:04:36',5),('21','237',6,'6',0.00,4000.00,'2022-03-23','','2022-03-26 14:04:59','764','764',2022,'764','2022-03-26 14:04:59',5),('21','237',7,'7',0.00,10600.00,'2022-03-23','','2022-03-26 14:05:23','764','764',2022,'764','2022-03-26 14:05:23',5),('21','237',8,'2',8104.56,5800.00,'2022-03-25','','2022-03-27 12:07:38','764','764',2022,'764','2022-03-27 12:07:38',5),('21','237',9,'1',32200.00,17200.00,'2022-03-25','','2022-03-31 14:19:56','764','764',2022,'764','2022-03-31 14:19:56',5),('21','237',10,'2',46418.52,46400.00,'2022-03-25','','2022-03-31 14:20:31','764','764',2022,'764','2022-03-31 14:20:31',5),('21','237',11,'3',1353.75,46700.00,'2022-03-25','','2022-03-31 14:21:11','764','764',2022,'764','2022-03-31 14:21:11',5),('21','237',12,'4',43292.70,46400.00,'2022-03-25','','2022-03-31 14:21:49','764','764',2022,'764','2022-03-31 14:21:49',5),('21','237',13,'5',37159.85,38200.00,'2022-03-25','','2022-03-31 14:22:10','764','764',2022,'764','2022-03-31 14:22:10',5),('21','237',14,'6',53637.84,49700.00,'2022-03-25','','2022-03-31 14:22:28','764','764',2022,'764','2022-03-31 14:22:28',5),('21','237',15,'7',50543.71,57000.00,'2022-03-25','','2022-03-31 14:22:49','764','764',2022,'764','2022-03-31 14:22:49',5),('21','237',16,'1',17145.40,2250.00,'2022-03-31','','2022-04-29 10:22:15','764','764',2022,'764','2022-04-29 10:22:15',5),('21','237',17,'2',5571.18,25850.00,'2022-03-31','','2022-04-29 10:23:53','764','764',2022,'764','2022-04-29 10:23:53',5),('21','237',18,'3',19399.51,20250.00,'2022-03-31','','2022-04-29 10:25:55','764','764',2022,'764','2022-04-29 10:25:55',5),('21','237',19,'4',885.60,16400.00,'2022-03-31','','2022-04-29 10:27:15','764','764',2022,'764','2022-04-29 10:27:15',5),('21','237',20,'5',1109.77,14800.00,'2022-03-31','','2022-04-29 10:28:36','764','764',2022,'764','2022-04-29 10:28:36',5),('21','237',21,'6',1949.36,1450.00,'2022-03-31','','2022-04-29 10:29:45','764','764',2022,'764','2022-04-29 10:29:45',5),('21','237',22,'7',34318.26,34600.00,'2022-03-31','','2022-04-29 10:31:22','764','764',2022,'764','2022-04-29 10:31:22',5),('21','237',23,'1',2250.00,2000.00,'2022-04-02','','2022-05-07 17:13:22','764','764',2022,'764','2022-05-07 17:13:22',5),('21','237',24,'2',23285.33,21000.00,'2022-04-09','','2022-05-07 17:15:20','764','764',2022,'764','2022-05-07 17:15:20',5),('21','237',25,'3',21386.59,21200.00,'2022-04-02','','2022-05-07 17:16:30','764','764',2022,'764','2022-05-07 17:16:30',5),('21','237',26,'4',24774.63,20900.00,'2022-04-02','','2022-05-07 17:17:06','764','764',2022,'764','2022-05-07 17:17:06',5),('21','237',27,'5',28151.74,43800.00,'2022-04-02','','2022-05-07 17:17:55','764','764',2022,'764','2022-05-07 17:17:55',5),('21','237',28,'6',43377.58,32800.00,'2022-04-02','','2022-05-07 17:18:51','764','764',2022,'764','2022-05-07 17:18:51',5),('21','237',29,'7',36454.50,44750.00,'2022-04-02','','2022-05-07 17:19:25','764','764',2022,'764','2022-05-07 17:19:25',5),('21','237',30,'5',28731.42,35400.00,'2022-05-13','','2022-05-13 17:57:35','764','764',2022,'764','2022-05-13 17:57:35',5),('21','237',31,'6',20363.86,45400.00,'2022-05-13','','2022-05-13 17:57:52','764','764',2022,'764','2022-05-13 17:57:52',5),('21','237',32,'6',45400.00,35000.00,'2022-05-13','','2022-05-13 17:58:06','764','764',2022,'764','2022-05-13 17:58:06',5),('21','237',33,'1',2000.00,32000.00,'2022-05-13','','2022-05-13 17:59:05','764','764',2022,'764','2022-05-13 17:59:05',5),('21','237',34,'2',3663.75,48650.00,'2022-05-13','','2022-05-13 17:59:35','764','764',2022,'764','2022-05-13 17:59:35',5),('21','237',35,'1',32000.00,17000.00,'2022-05-13','','2022-05-13 18:08:48','764','764',2022,'764','2022-05-13 18:08:48',5),('21','237',36,'2',48650.00,18650.00,'2022-05-13','','2022-05-13 18:09:08','764','764',2022,'764','2022-05-13 18:09:08',5),('21','237',37,'3',6058.95,41200.00,'2022-05-13','','2022-05-13 18:09:25','764','764',2022,'764','2022-05-13 18:09:25',5),('21','237',38,'4',2003.14,41000.00,'2022-05-13','','2022-05-13 18:09:40','764','764',2022,'764','2022-05-13 18:09:40',5),('21','237',39,'6',35000.00,45400.00,'2022-05-13','','2022-05-13 18:11:24','764','764',2022,'764','2022-05-13 18:11:24',5),('21','237',40,'7',37601.40,35000.00,'2022-05-13','','2022-05-13 18:11:38','764','764',2022,'764','2022-05-13 18:11:38',5),('21','237',41,'1',1014.22,2000.00,'2022-05-19','','2022-05-19 16:20:24','764','764',2022,'764','2022-05-19 16:20:24',5),('21','237',42,'5',19811.06,24611.00,'2022-06-04','','2022-06-04 18:32:27','764','764',2022,'764','2022-06-04 18:32:27',5),('21','237',43,'5',163.85,3900.00,'2022-06-05','','2022-06-05 16:40:24','764','764',2022,'764','2022-06-05 16:40:24',5),('21','237',44,'6',485.91,4350.00,'2022-06-05','','2022-06-05 16:41:06','764','764',2022,'764','2022-06-05 16:41:06',5),('21','237',45,'7',35866.50,38200.00,'2022-06-05','','2022-06-05 16:41:34','764','764',2022,'764','2022-06-05 16:41:34',5),('21','237',46,'1',6334.20,8800.00,'2022-07-24','','2022-07-24 13:47:07','764','764',2022,'764','2022-07-24 13:47:07',5),('21','237',47,'2',30210.33,30200.00,'2022-07-24','','2022-07-24 13:47:42','764','764',2022,'764','2022-07-24 13:47:42',5),('21','237',48,'3',39030.54,39600.00,'2022-07-24','','2022-07-24 13:48:07','764','764',2022,'764','2022-07-24 13:48:07',5),('21','237',49,'4',4321.52,7200.00,'2022-07-24','','2022-07-24 13:48:41','764','764',2022,'764','2022-07-24 13:48:41',5),('21','237',50,'5',492.32,2700.00,'2022-07-24','','2022-07-24 13:49:06','764','764',2022,'764','2022-07-24 13:49:06',5),('21','237',51,'6',25870.95,3300.00,'2022-07-24','','2022-07-24 13:49:31','764','764',2022,'764','2022-07-24 13:49:31',5),('21','237',52,'7',17242.04,1700.00,'2022-07-24','','2022-07-24 13:50:17','764','764',2022,'764','2022-07-24 13:50:17',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('21','237','1',1,'5','PMS NOZZLE 1A',1426139.50,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-26 14:08:55','764'),('21','237','1',3,'5','PMS NOZZLE 2A',867354.75,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-26 14:09:28','764'),('21','237','1',5,'5','PMS NOZZLE 15A',653197.41,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-26 14:10:08','764'),('21','237','1',7,'5','PMS NOZZLE 16A',1452325.33,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-26 14:29:58','764'),('21','237','2',9,'5','PMS NOZZLE 3A',770585.49,'PMS DISPENSER','',NULL,NULL,'',5,'2022-05-13 17:36:02','764'),('21','237','2',11,'5','PMS NOZZLE 4A',581909.91,'PMS DISPENSER','',NULL,NULL,'',5,'2022-05-13 17:37:40','764'),('21','237','2',13,'5','PMS NOZZLE 13A',369334.34,'PMS DISPENSER','',NULL,NULL,'',5,'2022-05-13 17:39:06','764'),('21','237','2',15,'5','PMS NOZZLE 14A',576615.52,'PMS DISPENSER','',NULL,NULL,'',5,'2022-05-13 17:40:16','764'),('21','237','3',17,'5','PMS NOZZLE 5A',418134.30,'PMS DISPENSER','',NULL,NULL,'',5,'2022-05-13 17:41:42','764'),('21','237','3',18,'5','PMS NOZZLE 6A',337335.64,'PMS DISPENSER','',NULL,NULL,'',5,'2022-05-13 17:42:49','764'),('21','237','3',21,'5','PMS NOZZLE 11A',0.00,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-26 14:14:48','764'),('21','237','3',23,'5','PMS NOZZLE 12A',438592.70,'PMS DISPENSER','',NULL,NULL,'',5,'2022-05-13 17:45:33','764'),('21','237','4',25,'5','PMS NOZZLE 7A',188301.30,'PMS DISPENSER','',NULL,NULL,'',5,'2022-05-13 17:47:23','764'),('21','237','4',27,'5','PMS NOZZLE 8A',196318.20,'PMS DISPENSER','',NULL,NULL,'',5,'2022-05-13 17:48:49','764'),('21','237','4',29,'5','PMS NOZZLE 9A',179292.21,'PMS DISPENSER','',NULL,NULL,'',5,'2022-05-13 17:50:16','764'),('21','237','4',31,'5','PMS NOZZLE 10A',276170.86,'PMS DISPENSER','',NULL,NULL,'',5,'2022-05-13 17:51:16','764'),('21','237','5',33,'5','AGO NOZZLE 1A',3535137.80,'AGO DISPENSER','',NULL,NULL,'',5,'2022-05-13 17:52:36','764'),('21','237','5',35,'5','AGO NOZZLE 2A',4025933.15,'AGO DISPENSER','',NULL,NULL,'',5,'2022-05-13 17:53:04','764'),('21','237','5',42,'5','AGO NOZZLE 3',2907757.03,'AGO DISPENSER','',NULL,NULL,'',5,'2022-05-13 17:53:29','764'),('21','237','5',43,'5','AGO NOZZLE 4',2988628.26,'AGO DISPENSER','',NULL,NULL,'',5,'2022-05-13 17:53:58','764'),('21','237','6',44,'5','AGO NOZZLE 5',0.00,'AGO DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('21','237','6',45,'5','AGO NOZZLE 6',2027069.31,'AGO DISPENSER','',NULL,NULL,'',5,'2022-05-13 17:54:36','764'),('21','237','6',46,'5','AGO NOZZLE 7',4904915.87,'AGO DISPENSER','',NULL,NULL,'',5,'2022-05-13 17:55:11','764'),('21','237','6',47,'5','AGO NOZZLE 8',4159019.23,'AGO DISPENSER','',NULL,NULL,'',5,'2022-05-13 17:55:47','764'),('21','237','7',48,'5','AGO NOZZLE 9',2569698.21,'AGO DISPENSER','',NULL,NULL,'',5,'2022-05-13 17:56:13','764'),('21','237','7',49,'5','AGO NOZZLE 10',2923569.89,'AGO DISPENSER','',NULL,NULL,'',5,'2022-05-13 17:56:46','764'),('21','237','1',50,'5','PMS NOZZLE 1B',1001256.27,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-26 16:08:38','764'),('21','237','1',51,'5','PMS NOZZLE 2B',677853.23,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-26 16:09:18','764'),('21','237','1',52,'5','PMS NOZZLE 15B',821101.91,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-26 16:10:14','764'),('21','237','1',53,'5','PMS NOZZLE 16B',949844.82,'PMS DISPENSER','',NULL,NULL,'',5,'2022-03-26 16:10:55','764'),('21','237','2',54,'5','PMS NOZZLE 3B',653300.95,'PMS DISPENSER','',NULL,NULL,'',5,'2022-05-13 17:36:46','764'),('21','237','2',55,'5','PMS NOZZLE 4B',473126.80,'PMS DISPENSER','',NULL,NULL,'',5,'2022-05-13 17:38:15','764'),('21','237','2',56,'5','PMS NOZZLE 13B',417062.40,'PMS DISPENSER','',NULL,NULL,'',5,'2022-05-13 17:39:35','764'),('21','237','2',57,'5','PMS NOZZLE 14B',800421.00,'PMS DISPENSER','',NULL,NULL,'',5,'2022-05-13 17:40:43','764'),('21','237','3',58,'5','PMS NOZZLE 5B',762881.27,'PMS DISPENSER','',NULL,NULL,'',5,'2022-05-13 17:42:13','764'),('21','237','3',59,'5','PMS NOZZLE 6B',344185.04,'PMS DISPENSER','',NULL,NULL,'',5,'2022-05-13 17:43:56','764'),('21','237','3',60,'5','PMS NOZZLE 11B',487630.54,'PMS DISPENSER','',NULL,NULL,'',5,'2022-05-13 17:44:50','764'),('21','237','3',61,'5','PMS NOZZLE 12B',672771.57,'PMS DISPENSER','',NULL,NULL,'',5,'2022-05-13 17:46:13','764'),('21','237','4',62,'5','PMS NOZZLE 7B',224051.63,'PMS DISPENSER','',NULL,NULL,'',5,'2022-05-13 17:48:10','764'),('21','237','4',63,'5','PMS NOZZLE 8B',643991.55,'PMS DISPENSER','',NULL,NULL,'',5,'2022-05-13 17:49:34','764'),('21','237','4',64,'5','PMS NOZZLE 9B',509457.86,'PMS DISPENSER','',NULL,NULL,'',5,'2022-05-13 17:50:46','764'),('21','237','4',65,'5','PMS NOZZLE 10B',247778.45,'PMS DISPENSER','',NULL,NULL,'',5,'2022-05-13 17:51:44','764');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`)
) ENGINE=InnoDB AUTO_INCREMENT=81 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('21','237',1,'DAILY','2022-03-24','2022-03-26 14:38:35','2022-03-27 14:38:35','764',0.00,0.00,'764','2022-03-26 15:48:05','764','2022-03-26 16:07:41',10),('21','237',2,'DAILY','2022-03-26','2022-03-26 16:44:28','2022-03-27 16:44:28','764',36788112.00,36788112.00,'764','2022-03-26 17:09:30','764','2022-03-26 18:03:53',10),('21','237',3,'DAILY','2022-03-25','2022-03-27 12:10:17','2022-03-28 12:10:17','764',30830719.55,30830719.55,'764','2022-03-27 12:30:15','764','2022-03-27 12:31:04',10),('21','237',4,'DAILY','2022-03-26','2022-03-28 15:40:51','2022-03-29 15:40:51','772',0.00,0.00,'764','2022-03-29 21:00:50','772','2022-03-31 17:48:42',10),('21','237',5,'DAILY','2022-03-31','2022-03-31 17:51:29','2022-04-01 17:51:29','772',25417176.35,25417176.35,'772','2022-03-31 18:07:46','772','2022-03-31 18:09:16',10),('21','237',6,'DAILY','2022-03-27','2022-04-05 10:42:55','2022-04-06 10:42:55','772',24252097.50,24252097.50,'772','2022-04-05 11:26:07','772','2022-04-05 12:26:35',10),('21','237',7,'DAILY','2022-04-05','2022-04-05 12:32:29','2022-04-06 12:32:29','772',20532513.05,20532513.05,'772','2022-04-05 12:47:05','772','2022-04-12 11:05:50',10),('21','237',8,'DAILY','2022-03-29','2022-04-12 11:09:11','2022-04-13 11:09:11','772',24493549.50,24493549.50,'772','2022-04-12 12:24:57','772','2022-04-14 17:21:04',10),('21','237',9,'DAILY','2022-03-30','2022-04-14 17:22:42','2022-04-15 17:22:42','772',36715896.40,36715896.40,'772','2022-04-14 17:44:43','772','2022-04-14 17:48:57',10),('21','237',10,'DAILY','2022-04-26','2022-04-26 10:37:16','2022-04-27 10:37:16','772',0.00,0.00,'764','2022-04-27 15:16:00','764','2022-04-27 15:16:15',10),('21','237',11,'DAILY','2022-03-31','2022-04-27 15:18:57','2022-04-28 15:18:57','764',38513458.75,38513458.75,'772','2022-04-28 13:28:29','772','2022-04-28 15:11:22',10),('21','237',12,'DAILY','2022-04-28','2022-04-28 15:12:19','2022-04-29 15:12:19','772',29788174.45,29788174.45,'772','2022-04-29 12:43:45','764','2022-04-30 19:37:52',10),('21','237',13,'DAILY','2022-05-06','2022-05-06 15:38:19','2022-05-07 15:38:19','772',0.00,0.00,'772','2022-05-08 10:40:29','772','2022-05-08 10:41:08',10),('21','237',14,'DAILY','2022-05-08','2022-05-08 10:47:57','2022-05-09 10:47:57','772',30654861.20,30654861.20,'772','2022-05-08 11:01:44','764','2022-05-09 08:44:12',10),('21','237',15,'DAILY','2022-05-14','2022-05-14 08:08:53','2022-05-15 08:08:53','772',31634567.90,31634567.90,'772','2022-05-14 08:28:35','764','2022-05-14 09:56:18',10),('21','237',16,'DAILY','2022-05-14','2022-05-14 10:01:36','2022-05-15 10:01:36','772',33859192.45,33859192.45,'772','2022-05-14 13:37:20','772','2022-05-14 14:14:36',10),('21','237',17,'DAILY','2022-05-14','2022-05-14 14:41:47','2022-05-15 14:41:47','772',37502849.15,37502849.15,'772','2022-05-14 15:41:48','764','2022-05-14 17:01:20',10),('21','237',18,'DAILY','2022-05-15','2022-05-15 11:41:00','2022-05-16 11:41:00','772',32775703.30,32775703.30,'772','2022-05-15 12:06:36','764','2022-05-15 12:37:11',10),('21','237',19,'DAILY','2022-05-15','2022-05-15 13:16:33','2022-05-16 13:16:33','772',31005409.60,31005409.60,'772','2022-05-15 13:59:16','764','2022-05-15 14:20:57',10),('21','237',20,'DAILY','2022-05-15','2022-05-15 14:22:36','2022-05-16 14:22:36','772',17562042.35,17562042.35,'772','2022-05-15 15:06:48','764','2022-05-17 11:21:45',10),('21','237',21,'DAILY','2022-05-17','2022-05-17 13:27:29','2022-05-18 13:27:29','772',37182473.60,37182473.60,'772','2022-05-17 15:31:55','764','2022-05-17 16:24:58',10),('21','237',22,'DAILY','2022-05-18','2022-05-18 19:45:50','2022-05-19 19:45:50','772',35919232.65,35919232.65,'772','2022-05-18 20:21:40','764','2022-05-19 14:26:55',10),('21','237',23,'DAILY','2022-05-19','2022-05-19 14:50:52','2022-05-20 14:50:52','772',33130399.30,33130399.30,'772','2022-05-19 16:53:49','764','2022-05-19 17:30:16',10),('21','237',24,'DAILY','2022-05-19','2022-05-19 17:54:18','2022-05-20 17:54:18','772',36779739.70,36779739.70,'772','2022-05-19 18:24:11','764','2022-05-19 19:12:43',10),('21','237',25,'DAILY','2022-05-19','2022-05-19 19:28:51','2022-05-20 19:28:51','772',39573877.95,39573877.95,'772','2022-05-19 19:47:45','764','2022-05-20 19:29:27',10),('21','237',26,'DAILY','2022-05-26','2022-05-26 19:41:44','2022-05-27 19:41:44','772',32878500.05,32878500.05,'772','2022-05-26 20:02:55','764','2022-05-27 15:08:21',10),('21','237',27,'DAILY','2022-05-30','2022-05-30 20:18:31','2022-05-31 20:18:31','772',27010766.55,27010766.55,'772','2022-05-30 22:09:24','764','2022-05-31 11:32:55',10),('21','237',28,'DAILY','2022-05-31','2022-05-31 14:22:25','2022-06-01 14:22:25','772',33414767.45,33414767.45,'772','2022-05-31 14:54:32','764','2022-05-31 15:48:29',10),('21','237',29,'DAILY','2022-05-31','2022-05-31 17:03:31','2022-06-01 17:03:31','772',36359419.90,36359419.90,'772','2022-05-31 17:21:00','764','2022-05-31 18:28:07',10),('21','237',30,'DAILY','2022-05-31','2022-05-31 18:31:08','2022-06-01 18:31:08','772',41101926.06,41101926.06,'772','2022-05-31 19:16:06','764','2022-06-01 05:55:50',10),('21','237',31,'DAILY','2022-06-01','2022-06-01 09:34:05','2022-06-02 09:34:05','772',0.00,0.00,'764','2022-06-02 11:23:58','764','2022-06-02 11:24:30',10),('21','237',32,'DAILY','2022-06-02','2022-06-02 11:26:13','2022-06-03 11:26:13','772',38681448.05,38681448.05,'772','2022-06-02 11:44:22','764','2022-06-02 11:54:27',10),('21','237',33,'DAILY','2022-06-02','2022-06-02 12:09:34','2022-06-03 12:09:34','772',38398414.15,38398414.15,'772','2022-06-02 12:27:27','764','2022-06-02 13:22:39',10),('21','237',34,'DAILY','2022-06-02','2022-06-02 13:26:16','2022-06-03 13:26:16','772',41991489.85,41991489.85,'772','2022-06-02 13:58:09','764','2022-06-02 16:34:16',10),('21','237',35,'DAILY','2022-06-02','2022-06-02 20:40:36','2022-06-03 20:40:36','772',31274203.05,31274203.05,'772','2022-06-02 21:47:05','764','2022-06-02 22:13:43',10),('21','237',36,'DAILY','2022-06-02','2022-06-02 22:31:50','2022-06-03 22:31:50','772',30392553.95,30392553.95,'772','2022-06-02 22:52:18','764','2022-06-03 05:37:24',10),('21','237',37,'DAILY','2022-06-03','2022-06-03 10:30:03','2022-06-04 10:30:03','772',0.00,0.00,'772','2022-06-04 18:49:20','764','2022-06-04 19:50:11',10),('21','237',38,'DAILY','2022-06-05','2022-06-05 08:45:59','2022-06-06 08:45:59','772',44042233.70,44042233.70,'772','2022-06-05 09:01:09','764','2022-06-05 09:37:58',10),('21','237',39,'DAILY','2022-06-05','2022-06-05 11:11:36','2022-06-06 11:11:36','772',29113854.40,29113854.40,'772','2022-06-06 07:57:01','764','2022-06-06 08:42:26',10),('21','237',40,'DAILY','2022-06-06','2022-06-06 08:53:24','2022-06-07 08:53:24','772',6713531.55,6713531.55,'772','2022-06-06 09:09:20','764','2022-06-06 09:32:08',10),('21','237',41,'DAILY','2022-06-07','2022-06-07 08:06:29','2022-06-08 08:06:29','772',25415685.40,25415685.40,'772','2022-06-07 08:23:03','764','2022-06-07 09:58:22',10),('21','237',42,'DAILY','2022-06-07','2022-06-07 15:42:02','2022-06-08 15:42:02','772',0.00,0.00,'772','2022-06-08 08:11:48','764','2022-06-08 08:49:20',10),('21','237',43,'DAILY','2022-06-08','2022-06-08 08:50:47','2022-06-09 08:50:47','772',44534928.80,45108414.40,'772','2022-06-08 09:18:46','764','2022-06-08 10:14:47',10),('21','237',44,'DAILY','2022-06-08','2022-06-08 10:50:24','2022-06-09 10:50:24','772',18749975.10,18956905.50,'772','2022-06-08 12:38:22','764','2022-06-08 13:01:48',10),('21','237',45,'DAILY','2022-06-08','2022-06-08 13:16:23','2022-06-09 13:16:23','772',17949930.45,18204851.55,'772','2022-06-08 13:38:19','764','2022-06-08 15:01:09',10),('21','237',46,'DAILY','2022-06-08','2022-06-08 17:59:57','2022-06-09 17:59:57','772',11964647.20,11981347.40,'772','2022-06-08 18:14:32','764','2022-06-08 18:38:33',10),('21','237',47,'DAILY','2022-06-08','2022-06-08 20:03:47','2022-06-09 20:03:47','772',17565194.20,17565194.20,'772','2022-06-08 20:33:07','764','2022-06-08 21:16:42',10),('21','237',48,'DAILY','2022-06-09','2022-06-09 12:05:10','2022-06-10 12:05:10','772',32120226.15,32120226.15,'772','2022-06-10 07:00:52','764','2022-06-10 11:58:35',10),('21','237',49,'DAILY','2022-06-10','2022-06-10 12:15:38','2022-06-11 12:15:38','772',32264961.70,32264961.70,'772','2022-06-11 07:49:50','764','2022-06-11 08:39:00',10),('21','237',50,'DAILY','2022-06-11','2022-06-11 09:23:20','2022-06-12 09:23:20','772',26480519.30,26480519.30,'772','2022-06-11 09:47:11','764','2022-06-11 10:07:53',10),('21','237',51,'DAILY','2022-06-11','2022-06-11 10:11:50','2022-06-12 10:11:50','772',29966211.80,29966211.80,'772','2022-06-11 10:47:25','764','2022-06-11 11:03:42',10),('21','237',52,'DAILY','2022-06-11','2022-06-11 11:14:33','2022-06-12 11:14:33','772',26488122.25,26488122.25,'772','2022-06-11 12:02:10','764','2022-06-11 12:53:49',10),('21','237',53,'DAILY','2022-06-11','2022-06-11 17:54:06','2022-06-12 17:54:06','772',47420026.80,47420026.80,'772','2022-06-12 07:10:53','764','2022-06-12 08:00:10',10),('21','237',54,'DAILY','2022-06-12','2022-06-12 08:39:56','2022-06-13 08:39:56','772',35804997.20,35804997.20,'772','2022-06-12 08:59:41','764','2022-06-12 09:23:50',10),('21','237',55,'DAILY','2022-06-12','2022-06-12 09:32:38','2022-06-13 09:32:38','772',43228278.40,43228278.40,'772','2022-06-12 09:49:11','764','2022-06-12 11:02:53',10),('21','237',56,'DAILY','2022-06-12','2022-06-12 11:13:27','2022-06-13 11:13:27','772',0.00,0.00,'764','2022-06-14 10:49:58','764','2022-06-14 10:50:37',10),('21','237',57,'DAILY','2022-06-18','2022-06-18 17:04:46','2022-06-19 17:04:46','772',31946072.30,31946072.30,'772','2022-06-18 17:23:14','764','2022-06-18 17:51:22',10),('21','237',58,'DAILY','2022-06-18','2022-06-18 19:47:12','2022-06-19 19:47:12','772',43204229.10,45468575.10,'772','2022-06-18 20:25:05','764','2022-06-18 20:56:52',10),('21','237',59,'DAILY','2022-06-18','2022-06-18 20:58:28','2022-06-19 20:58:28','772',26853338.15,28138810.95,'772','2022-06-18 21:39:37','764','2022-06-18 22:08:31',10),('21','237',60,'DAILY','2022-06-21','2022-06-21 12:27:52','2022-06-22 12:27:52','772',0.00,0.00,'772','2022-06-22 08:20:40','764','2022-06-22 08:32:34',10),('21','237',61,'DAILY','2022-06-22','2022-06-22 08:42:26','2022-06-23 08:42:26','772',0.00,0.00,'764','2022-06-22 09:01:11','764','2022-06-22 09:02:04',10),('21','237',62,'DAILY','2022-06-22','2022-06-22 09:09:08','2022-06-23 09:09:08','772',18820189.65,18820189.65,'772','2022-06-22 09:28:57','764','2022-06-22 10:20:51',10),('21','237',63,'DAILY','2022-06-22','2022-06-22 10:23:17','2022-06-23 10:23:17','772',0.00,0.00,'772','2022-06-22 10:48:07','764','2022-06-22 10:53:24',10),('21','237',64,'DAILY','2022-06-22','2022-06-22 11:03:15','2022-06-23 11:03:15','772',14563084.00,14563084.00,'772','2022-06-22 11:13:36','764','2022-06-22 12:00:27',10),('21','237',65,'DAILY','2022-06-22','2022-06-22 12:08:21','2022-06-23 12:08:21','772',41921730.65,41921730.65,'772','2022-06-22 12:31:43','764','2022-06-22 13:00:39',10),('21','237',66,'DAILY','2022-06-22','2022-06-22 14:16:55','2022-06-23 14:16:55','772',43978041.55,43978041.55,'772','2022-06-22 14:56:57','764','2022-06-22 15:49:24',10),('21','237',67,'DAILY','2022-06-22','2022-06-22 16:39:02','2022-06-23 16:39:02','772',43611497.30,43611497.30,'772','2022-06-22 17:00:17','764','2022-06-22 17:54:06',10),('21','237',68,'DAILY','2022-06-23','2022-06-23 06:58:16','2022-06-24 06:58:16','772',34429473.45,34429473.45,'772','2022-06-23 09:18:59','764','2022-06-23 11:40:58',10),('21','237',69,'DAILY','2022-06-24','2022-06-24 08:54:51','2022-06-25 08:54:51','772',33046009.60,33046009.60,'772','2022-06-24 09:34:29','764','2022-06-24 10:37:09',10),('21','237',70,'DAILY','2022-06-24','2022-06-24 16:47:53','2022-06-25 16:47:53','772',32490082.90,32490082.90,'772','2022-06-25 08:36:38','764','2022-06-25 09:03:46',10),('21','237',71,'DAILY','2022-07-20','2022-07-20 12:35:21','2022-07-21 12:35:21','772',31966649.45,31966649.45,'772','2022-07-20 16:53:26','764','2022-07-20 17:37:19',10),('21','237',72,'DAILY','2022-07-22','2022-07-22 11:08:30','2022-07-23 11:08:30','772',16332353.55,16332353.55,'772','2022-07-22 14:24:20','764','2022-07-22 15:26:48',10),('21','237',73,'DAILY','2022-07-25','2022-07-25 18:13:14','2022-07-26 18:13:14','772',24990095.15,24990095.15,'772','2022-07-25 18:53:41','764','2022-07-26 21:34:33',10),('21','237',74,'DAILY','2022-07-27','2022-07-27 15:00:45','2022-07-28 15:00:45','772',32378489.80,32378489.80,'772','2022-07-27 15:43:54','764','2022-07-27 16:24:38',10),('21','237',75,'DAILY','2022-07-27','2022-07-27 16:44:12','2022-07-28 16:44:12','772',11119600.80,11119600.80,'772','2022-07-27 16:55:20','764','2022-07-27 17:23:07',10),('21','237',76,'DAILY','2022-07-27','2022-07-27 18:13:29','2022-07-28 18:13:29','772',34773831.75,34773831.75,'772','2022-07-27 18:28:26','764','2022-07-27 19:14:12',10),('21','237',77,'DAILY','2022-07-27','2022-07-27 19:54:03','2022-07-28 19:54:03','772',30217468.35,30217468.35,'772','2022-07-27 20:27:47','764','2022-07-27 20:57:18',10),('21','237',78,'DAILY','2022-07-30','2022-07-30 10:08:28','2022-07-31 10:08:28','772',23563640.40,23563640.40,'772','2022-07-30 10:23:09','764','2022-07-30 10:51:55',10),('21','237',79,'DAILY','2022-07-31','2022-07-31 15:37:44','2022-08-01 15:37:44','772',26011393.05,26011393.05,'772','2022-07-31 16:03:21','764','2022-07-31 16:43:51',10),('21','237',80,'DAILY','2022-07-31','2022-07-31 17:00:08','2022-08-01 17:00:08','772',28829660.70,28829660.70,'772','2022-07-31 18:18:46','764','2022-07-31 18:58:02',10);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=3345 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('21','237','1','1',1,'1','1',1310837.97,1310837.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','1',2,'3','1',767407.51,767407.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','1',3,'5','1',624072.91,624072.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','1',4,'7','1',1336163.35,1336163.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','1',5,'9','1',613795.89,613795.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','1',6,'11','1',469535.52,469535.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','1',7,'13','1',309689.29,309689.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','1',8,'15','1',506857.62,506857.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','1',9,'17','1',338533.07,338533.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','1',10,'18','1',297951.87,297951.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','1',11,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','1',12,'23','1',370100.47,370100.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','1',13,'25','1',102036.39,102036.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','1',14,'27','1',188066.14,188066.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','1',15,'29','1',145409.58,145409.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','1',16,'31','1',218980.12,218980.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','1',17,'33','2',3283327.68,3283327.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','1',18,'35','2',3688028.61,3688028.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','1',19,'42','2',2697463.93,2697463.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','1',20,'43','2',2699229.79,2699229.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','1',21,'44','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','1',22,'45','1',1802217.32,1802217.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','1',23,'46','1',4526941.11,4526941.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','1',24,'47','1',3832777.49,3832777.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','1',25,'48','2',2298393.30,2298393.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','1',26,'49','2',2589861.55,2589861.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','2',27,'1','1',1310837.97,1310837.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','2',28,'3','1',767407.51,767407.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','2',29,'5','1',624072.91,624072.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','2',30,'7','1',1336163.35,1336163.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','2',31,'9','1',613795.89,618119.78,4323.89,713441.85,0.00,0.00,0.00,0.00,0.00),('21','237','2','2',32,'11','1',469535.52,471361.02,1825.50,301207.50,0.00,0.00,0.00,0.00,0.00),('21','237','2','2',33,'13','1',309689.29,309826.26,136.97,22600.05,0.00,0.00,0.00,0.00,0.00),('21','237','2','2',34,'15','1',506857.62,509832.86,2975.24,490914.60,0.00,0.00,0.00,0.00,0.00),('21','237','3','2',35,'17','1',338533.07,342083.86,3550.79,585880.35,0.00,0.00,0.00,0.00,0.00),('21','237','3','2',36,'18','1',297951.87,299474.10,1522.23,251167.95,0.00,0.00,0.00,0.00,0.00),('21','237','3','2',37,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','2',38,'23','1',370100.47,371736.32,1635.85,269915.25,0.00,0.00,0.00,0.00,0.00),('21','237','4','2',39,'25','1',102036.39,105822.98,3786.59,624787.35,0.00,0.00,0.00,0.00,0.00),('21','237','4','2',40,'27','1',188066.14,188066.17,0.03,4.95,0.00,0.00,0.00,0.00,0.00),('21','237','4','2',41,'29','1',145409.58,147382.20,1972.62,325482.30,0.00,0.00,0.00,0.00,0.00),('21','237','4','2',42,'31','1',218980.12,220180.04,1199.92,197986.80,0.00,0.00,0.00,0.00,0.00),('21','237','5','2',43,'33','2',3283327.68,3288132.83,4805.15,3075296.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','2',44,'35','2',3688028.61,3691751.58,3722.97,2382700.80,0.00,0.00,0.00,0.00,0.00),('21','237','5','2',45,'42','2',2697463.93,2701267.09,3803.16,2434022.40,0.00,0.00,0.00,0.00,0.00),('21','237','5','2',46,'43','2',2699229.79,2704597.28,5367.49,3435193.60,0.00,0.00,0.00,0.00,0.00),('21','237','6','2',47,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','2',48,'45','2',1802217.32,1804987.55,2770.23,1772947.20,0.00,0.00,0.00,0.00,0.00),('21','237','6','2',49,'46','2',4526941.11,4531450.08,4508.97,2885740.80,0.00,0.00,0.00,0.00,0.00),('21','237','6','2',50,'47','2',3832777.49,3836073.54,3296.05,2109472.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','2',51,'48','2',2298393.30,2305205.86,6812.56,4360038.40,0.00,0.00,0.00,0.00,0.00),('21','237','7','2',52,'49','2',2589861.55,2596890.11,7028.56,4498278.40,0.00,0.00,0.00,0.00,0.00),('21','237','1','2',53,'50','1',930201.84,930201.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','2',54,'51','1',668231.15,668231.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','2',55,'52','1',719618.51,719618.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','2',56,'53','1',847825.02,847825.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','2',57,'54','1',558656.86,560183.50,1526.64,251895.60,0.00,0.00,0.00,0.00,0.00),('21','237','2','2',58,'55','1',394851.49,397038.50,2187.01,360856.65,0.00,0.00,0.00,0.00,0.00),('21','237','2','2',59,'56','1',313065.77,314763.42,1697.65,280112.25,0.00,0.00,0.00,0.00,0.00),('21','237','2','2',60,'57','1',647234.43,654056.97,6822.54,1125719.10,0.00,0.00,0.00,0.00,0.00),('21','237','3','2',61,'58','1',613288.58,616864.35,3575.77,590002.05,0.00,0.00,0.00,0.00,0.00),('21','237','3','2',62,'59','1',278858.67,280744.08,1885.41,311092.65,0.00,0.00,0.00,0.00,0.00),('21','237','3','2',63,'60','1',379196.13,384498.12,5301.99,874828.35,0.00,0.00,0.00,0.00,0.00),('21','237','3','2',64,'61','1',536186.50,537521.68,1335.18,220304.70,0.00,0.00,0.00,0.00,0.00),('21','237','4','2',65,'62','1',210397.22,210397.47,0.25,41.25,0.00,0.00,0.00,0.00,0.00),('21','237','4','2',66,'63','1',451278.59,456317.16,5038.57,831364.05,0.00,0.00,0.00,0.00,0.00),('21','237','4','2',67,'64','1',346780.18,350711.75,3931.57,648709.05,0.00,0.00,0.00,0.00,0.00),('21','237','4','2',68,'65','1',124917.98,128288.33,3370.35,556107.75,0.00,0.00,0.00,0.00,0.00),('21','237','1','3',69,'1','1',1310837.97,1310837.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','3',70,'3','1',767407.51,767407.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','3',71,'5','1',624072.91,624072.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','3',72,'7','1',1336163.35,1336163.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','3',73,'9','1',618119.78,618469.82,350.04,57756.60,0.00,0.00,0.00,0.00,0.00),('21','237','2','3',74,'11','1',471361.02,471891.11,530.09,87464.85,0.00,0.00,0.00,0.00,0.00),('21','237','2','3',75,'13','1',309826.26,310481.19,654.93,108063.45,0.00,0.00,0.00,0.00,0.00),('21','237','2','3',76,'15','1',509832.86,510199.36,366.50,60472.50,0.00,0.00,0.00,0.00,0.00),('21','237','3','3',77,'17','1',342083.86,342310.62,226.76,37415.40,0.00,0.00,0.00,0.00,0.00),('21','237','3','3',78,'18','1',299474.10,300893.01,1418.91,234120.15,0.00,0.00,0.00,0.00,0.00),('21','237','3','3',79,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','3',80,'23','1',371736.32,372216.12,479.80,79167.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','3',81,'25','1',105822.98,108263.78,2440.80,402732.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','3',82,'27','1',188066.17,188066.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','3',83,'29','1',147382.20,148714.61,1332.41,219847.65,0.00,0.00,0.00,0.00,0.00),('21','237','4','3',84,'31','1',220180.04,221377.11,1197.07,197516.55,0.00,0.00,0.00,0.00,0.00),('21','237','5','3',85,'33','2',3288132.83,3292767.85,4635.02,2966412.80,0.00,0.00,0.00,0.00,0.00),('21','237','5','3',86,'35','2',3691751.58,3698015.61,6264.03,4008979.20,0.00,0.00,0.00,0.00,0.00),('21','237','5','3',87,'42','2',2701267.09,2701359.43,92.34,59097.60,0.00,0.00,0.00,0.00,0.00),('21','237','5','3',88,'43','2',2704597.28,2709917.27,5319.99,3404793.60,0.00,0.00,0.00,0.00,0.00),('21','237','6','3',89,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','3',90,'45','2',1804987.55,1812459.77,7472.22,4782220.80,0.00,0.00,0.00,0.00,0.00),('21','237','6','3',91,'46','2',4531450.08,4537578.33,6128.25,3922080.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','3',92,'47','2',3836073.54,3842259.98,6186.44,3959321.60,0.00,0.00,0.00,0.00,0.00),('21','237','7','3',93,'48','2',2305205.86,2307352.95,2147.09,1374137.60,0.00,0.00,0.00,0.00,0.00),('21','237','7','3',94,'49','2',2596890.11,2600958.19,4068.08,2603571.20,0.00,0.00,0.00,0.00,0.00),('21','237','1','3',95,'50','1',930201.84,930201.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','3',96,'51','1',668231.15,668231.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','3',97,'52','1',719618.51,719618.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','3',98,'53','1',847825.02,847825.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','3',99,'54','1',560183.50,560503.57,320.07,52811.55,0.00,0.00,0.00,0.00,0.00),('21','237','2','3',100,'55','1',397038.50,397877.08,838.58,138365.70,0.00,0.00,0.00,0.00,0.00),('21','237','2','3',101,'56','1',314763.42,315481.59,718.17,118498.05,0.00,0.00,0.00,0.00,0.00),('21','237','2','3',102,'57','1',654056.97,654660.07,603.10,99511.50,0.00,0.00,0.00,0.00,0.00),('21','237','3','3',103,'58','1',616864.35,617178.54,314.19,51841.35,0.00,0.00,0.00,0.00,0.00),('21','237','3','3',104,'59','1',280744.08,282493.15,1749.07,288596.55,0.00,0.00,0.00,0.00,0.00),('21','237','3','3',105,'60','1',384498.12,387441.31,2943.19,485626.35,0.00,0.00,0.00,0.00,0.00),('21','237','3','3',106,'61','1',537521.68,537728.79,207.11,34173.15,0.00,0.00,0.00,0.00,0.00),('21','237','4','3',107,'62','1',210397.47,210397.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','3',108,'63','1',456317.16,458517.50,2200.34,363056.10,0.00,0.00,0.00,0.00,0.00),('21','237','4','3',109,'64','1',350711.75,352604.70,1892.95,312336.75,0.00,0.00,0.00,0.00,0.00),('21','237','4','3',110,'65','1',128288.33,130232.16,1943.83,320731.95,0.00,0.00,0.00,0.00,0.00),('21','237','1','4',111,'1','1',1310837.97,1310837.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','4',112,'3','1',767407.51,767407.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','4',113,'5','1',624072.91,624072.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','4',114,'7','1',1336163.35,1336163.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','4',115,'9','1',618469.82,618469.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','4',116,'11','1',471891.11,471891.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','4',117,'13','1',310481.19,310481.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','4',118,'15','1',510199.36,510199.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','4',119,'17','1',342310.62,342310.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','4',120,'18','1',300893.01,300893.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','4',121,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','4',122,'23','1',372216.12,372216.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','4',123,'25','1',108263.78,108263.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','4',124,'27','1',188066.17,188066.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','4',125,'29','1',148714.61,148714.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','4',126,'31','1',221377.11,221377.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','4',127,'33','2',3292767.85,3292767.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','4',128,'35','2',3698015.61,3698015.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','4',129,'42','2',2701359.43,2701359.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','4',130,'43','2',2709917.27,2709917.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','4',131,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','4',132,'45','2',1812459.77,1812459.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','4',133,'46','2',4537578.33,4537578.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','4',134,'47','2',3842259.98,3842259.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','4',135,'48','2',2307352.95,2307352.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','4',136,'49','2',2600958.19,2600958.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','4',137,'50','1',930201.84,930201.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','4',138,'51','1',668231.15,668231.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','4',139,'52','1',719618.51,719618.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','4',140,'53','1',847825.02,847825.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','4',141,'54','1',560503.57,560503.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','4',142,'55','1',397877.08,397877.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','4',143,'56','1',315481.59,315481.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','4',144,'57','1',654660.07,654660.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','4',145,'58','1',617178.54,617178.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','4',146,'59','1',282493.15,282493.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','4',147,'60','1',387441.31,387441.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','4',148,'61','1',537728.79,537728.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','4',149,'62','1',210397.47,210397.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','4',150,'63','1',458517.50,458517.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','4',151,'64','1',352604.70,352604.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','4',152,'65','1',130232.16,130232.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','5',153,'1','1',1310837.97,1310837.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','5',154,'3','1',767407.51,767407.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','5',155,'5','1',624072.91,624072.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','5',156,'7','1',1336163.35,1336163.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','5',157,'9','1',618469.82,618469.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','5',158,'11','1',471891.11,471891.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','5',159,'13','1',310481.19,310481.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','5',160,'15','1',510199.36,510199.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','5',161,'17','1',342310.62,346983.16,4672.54,770969.10,0.00,0.00,0.00,0.00,0.00),('21','237','3','5',162,'18','1',300893.01,302403.08,1510.07,249161.55,0.00,0.00,0.00,0.00,0.00),('21','237','3','5',163,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','5',164,'23','1',372216.12,378055.96,5839.84,963573.60,0.00,0.00,0.00,0.00,0.00),('21','237','4','5',165,'25','1',108263.78,112323.20,4059.42,669804.30,0.00,0.00,0.00,0.00,0.00),('21','237','4','5',166,'27','1',188066.17,188066.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','5',167,'29','1',148714.61,151394.62,2680.01,442201.65,0.00,0.00,0.00,0.00,0.00),('21','237','4','5',168,'31','1',221377.11,224478.30,3101.19,511696.35,0.00,0.00,0.00,0.00,0.00),('21','237','5','5',169,'33','2',3292767.85,3295236.78,2468.93,1580115.20,0.00,0.00,0.00,0.00,0.00),('21','237','5','5',170,'35','2',3698015.61,3701910.67,3895.06,2492838.40,0.00,0.00,0.00,0.00,0.00),('21','237','5','5',171,'42','2',2701359.43,2703379.03,2019.60,1292544.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','5',172,'43','2',2709917.27,2713116.31,3199.04,2047385.60,0.00,0.00,0.00,0.00,0.00),('21','237','6','5',173,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','5',174,'45','2',1812459.77,1813940.85,1481.08,947891.20,0.00,0.00,0.00,0.00,0.00),('21','237','6','5',175,'46','2',4537578.33,4540910.42,3332.09,2132537.60,0.00,0.00,0.00,0.00,0.00),('21','237','6','5',176,'47','2',3842259.98,3846784.61,4524.63,2895763.20,0.00,0.00,0.00,0.00,0.00),('21','237','7','5',177,'48','2',2307352.95,2307352.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','5',178,'49','2',2600958.19,2606029.36,5071.17,3245548.80,0.00,0.00,0.00,0.00,0.00),('21','237','1','5',179,'50','1',930201.84,930201.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','5',180,'51','1',668231.15,668231.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','5',181,'52','1',719618.51,719618.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','5',182,'53','1',847825.02,847825.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','5',183,'54','1',560503.57,560503.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','5',184,'55','1',397877.08,397877.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','5',185,'56','1',315481.59,315481.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','5',186,'57','1',654660.07,654660.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','5',187,'58','1',617178.54,623076.26,5897.72,973123.80,0.00,0.00,0.00,0.00,0.00),('21','237','3','5',188,'59','1',282493.15,286356.91,3863.76,637520.40,0.00,0.00,0.00,0.00,0.00),('21','237','3','5',189,'60','1',387441.31,391496.63,4055.32,669127.80,0.00,0.00,0.00,0.00,0.00),('21','237','3','5',190,'61','1',537728.79,541744.29,4015.50,662557.50,0.00,0.00,0.00,0.00,0.00),('21','237','4','5',191,'62','1',210397.47,210397.50,0.03,4.95,0.00,0.00,0.00,0.00,0.00),('21','237','4','5',192,'63','1',458517.50,463756.35,5238.85,864410.25,0.00,0.00,0.00,0.00,0.00),('21','237','4','5',193,'64','1',352604.70,356983.71,4379.01,722536.65,0.00,0.00,0.00,0.00,0.00),('21','237','4','5',194,'65','1',130232.16,134146.49,3914.33,645864.45,0.00,0.00,0.00,0.00,0.00),('21','237','1','6',195,'1','1',1310837.97,1313691.27,2853.30,470794.50,0.00,0.00,0.00,0.00,0.00),('21','237','1','6',196,'3','1',767407.51,769430.25,2022.74,333752.10,0.00,0.00,0.00,0.00,0.00),('21','237','1','6',197,'5','1',624072.91,626617.36,2544.45,419834.25,0.00,0.00,0.00,0.00,0.00),('21','237','1','6',198,'7','1',1336163.35,1338415.27,2251.92,371566.80,0.00,0.00,0.00,0.00,0.00),('21','237','2','6',199,'9','1',618469.82,618469.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','6',200,'11','1',471891.11,471891.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','6',201,'13','1',310481.19,310481.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','6',202,'15','1',510199.36,510199.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','6',203,'17','1',346983.16,350125.89,3142.73,518550.45,0.00,0.00,0.00,0.00,0.00),('21','237','3','6',204,'18','1',302403.08,303909.81,1506.73,248610.45,0.00,0.00,0.00,0.00,0.00),('21','237','3','6',205,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','6',206,'23','1',378055.96,380224.46,2168.50,357802.50,0.00,0.00,0.00,0.00,0.00),('21','237','4','6',207,'25','1',112323.20,116495.87,4172.67,688490.55,0.00,0.00,0.00,0.00,0.00),('21','237','4','6',208,'27','1',188066.17,188066.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','6',209,'29','1',151394.62,154746.71,3352.09,553094.85,0.00,0.00,0.00,0.00,0.00),('21','237','4','6',210,'31','1',224478.30,228626.97,4148.67,684530.55,0.00,0.00,0.00,0.00,0.00),('21','237','5','6',211,'33','2',3295236.78,3298454.31,3217.53,2059219.20,0.00,0.00,0.00,0.00,0.00),('21','237','5','6',212,'35','2',3701910.67,3704415.80,2505.13,1603283.20,0.00,0.00,0.00,0.00,0.00),('21','237','5','6',213,'42','2',2703379.03,2705162.17,1783.14,1141209.60,0.00,0.00,0.00,0.00,0.00),('21','237','5','6',214,'43','2',2713116.31,2714269.23,1152.92,737868.80,0.00,0.00,0.00,0.00,0.00),('21','237','6','6',215,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','6',216,'45','2',1813940.85,1815729.45,1788.60,1144704.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','6',217,'46','2',4540910.42,4546559.68,5649.26,3615526.40,0.00,0.00,0.00,0.00,0.00),('21','237','6','6',218,'47','2',3846784.61,3849621.00,2836.39,1815289.60,0.00,0.00,0.00,0.00,0.00),('21','237','7','6',219,'48','2',2307352.95,2307691.90,338.95,216928.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','6',220,'49','2',2606029.36,2611112.52,5083.16,3253222.40,0.00,0.00,0.00,0.00,0.00),('21','237','1','6',221,'50','1',930201.84,930201.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','6',222,'51','1',668231.15,670569.57,2338.42,385839.30,0.00,0.00,0.00,0.00,0.00),('21','237','1','6',223,'52','1',719618.51,722662.14,3043.63,502198.95,0.00,0.00,0.00,0.00,0.00),('21','237','1','6',224,'53','1',847825.02,847825.16,0.14,23.10,0.00,0.00,0.00,0.00,0.00),('21','237','2','6',225,'54','1',560503.57,560503.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','6',226,'55','1',397877.08,397877.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','6',227,'56','1',315481.59,315481.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','6',228,'57','1',654660.07,654660.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','6',229,'58','1',623076.26,626142.83,3066.57,505984.05,0.00,0.00,0.00,0.00,0.00),('21','237','3','6',230,'59','1',286356.91,287120.45,763.54,125984.10,0.00,0.00,0.00,0.00,0.00),('21','237','3','6',231,'60','1',391496.63,393963.05,2466.42,406959.30,0.00,0.00,0.00,0.00,0.00),('21','237','3','6',232,'61','1',541744.29,544139.07,2394.78,395138.70,0.00,0.00,0.00,0.00,0.00),('21','237','4','6',233,'62','1',210397.50,210397.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','6',234,'63','1',463756.35,467285.90,3529.55,582375.75,0.00,0.00,0.00,0.00,0.00),('21','237','4','6',235,'64','1',356983.71,361129.86,4146.15,684114.75,0.00,0.00,0.00,0.00,0.00),('21','237','4','6',236,'65','1',134146.49,136747.71,2601.22,429201.30,0.00,0.00,0.00,0.00,0.00),('21','237','1','7',237,'1','1',1313691.27,1313691.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','7',238,'3','1',769430.25,769430.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','7',239,'5','1',626617.36,626617.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','7',240,'7','1',1338415.27,1338415.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','7',241,'9','1',618469.82,624964.93,6495.11,1071693.15,0.00,0.00,0.00,0.00,0.00),('21','237','2','7',242,'11','1',471891.11,476958.45,5067.34,836111.10,0.00,0.00,0.00,0.00,0.00),('21','237','2','7',243,'13','1',310481.19,314617.91,4136.72,682558.80,0.00,0.00,0.00,0.00,0.00),('21','237','2','7',244,'15','1',510199.36,515467.64,5268.28,869266.20,0.00,0.00,0.00,0.00,0.00),('21','237','3','7',245,'17','1',350125.89,350125.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','7',246,'18','1',303909.81,303909.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','7',247,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','7',248,'23','1',380224.46,380224.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','7',249,'25','1',116495.87,116495.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','7',250,'27','1',188066.17,188066.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','7',251,'29','1',154746.71,154746.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','7',252,'31','1',228626.97,228626.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','7',253,'33','2',3298454.31,3300744.89,2290.58,1465971.20,0.00,0.00,0.00,0.00,0.00),('21','237','5','7',254,'35','2',3704415.80,3707205.02,2789.22,1785100.80,0.00,0.00,0.00,0.00,0.00),('21','237','5','7',255,'42','2',2705162.17,2707043.99,1881.82,1204364.80,0.00,0.00,0.00,0.00,0.00),('21','237','5','7',256,'43','2',2714269.23,2715857.64,1588.41,1016582.40,0.00,0.00,0.00,0.00,0.00),('21','237','6','7',257,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','7',258,'45','2',1815729.45,1816298.21,568.76,364006.40,0.00,0.00,0.00,0.00,0.00),('21','237','6','7',259,'46','2',4546559.68,4550945.37,4385.69,2806841.60,0.00,0.00,0.00,0.00,0.00),('21','237','6','7',260,'47','2',3849621.00,3854358.11,4737.11,3031750.40,0.00,0.00,0.00,0.00,0.00),('21','237','7','7',261,'48','2',2307691.90,2308585.62,893.72,571980.80,0.00,0.00,0.00,0.00,0.00),('21','237','7','7',262,'49','2',2611112.52,2613955.02,2842.50,1819200.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','7',263,'50','1',930201.84,930201.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','7',264,'51','1',670569.57,670569.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','7',265,'52','1',722662.14,722662.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','7',266,'53','1',847825.16,847825.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','7',267,'54','1',560503.57,565902.72,5399.15,890859.75,0.00,0.00,0.00,0.00,0.00),('21','237','2','7',268,'55','1',397877.08,401404.38,3527.30,582004.50,0.00,0.00,0.00,0.00,0.00),('21','237','2','7',269,'56','1',315481.59,320134.20,4652.61,767680.65,0.00,0.00,0.00,0.00,0.00),('21','237','2','7',270,'57','1',654660.07,659305.77,4645.70,766540.50,0.00,0.00,0.00,0.00,0.00),('21','237','3','7',271,'58','1',626142.83,626142.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','7',272,'59','1',287120.45,287120.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','7',273,'60','1',393963.05,393963.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','7',274,'61','1',544139.07,544139.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','7',275,'62','1',210397.50,210397.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','7',276,'63','1',467285.90,467285.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','7',277,'64','1',361129.86,361129.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','7',278,'65','1',136747.71,136747.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','8',279,'1','1',1313691.27,1313691.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','8',280,'3','1',769430.25,769430.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','8',281,'5','1',626617.36,626617.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','8',282,'7','1',1338415.27,1338415.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','8',283,'9','1',624964.93,625926.36,961.43,158635.95,0.00,0.00,0.00,0.00,0.00),('21','237','2','8',284,'11','1',476958.45,477510.87,552.42,91149.30,0.00,0.00,0.00,0.00,0.00),('21','237','2','8',285,'13','1',314617.91,315204.51,586.60,96789.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','8',286,'15','1',515467.64,516072.28,604.64,99765.60,0.00,0.00,0.00,0.00,0.00),('21','237','3','8',287,'17','1',350125.89,350125.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','8',288,'18','1',303909.81,303909.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','8',289,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','8',290,'23','1',380224.46,380224.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','8',291,'25','1',116495.87,116495.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','8',292,'27','1',188066.17,188066.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','8',293,'29','1',154746.71,154746.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','8',294,'31','1',228626.97,228626.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','8',295,'33','2',3300744.89,3307110.12,6365.23,4073747.20,0.00,0.00,0.00,0.00,0.00),('21','237','5','8',296,'35','2',3707205.02,3709030.87,1825.85,1168544.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','8',297,'42','2',2707043.99,2710247.20,3203.21,2050054.40,0.00,0.00,0.00,0.00,0.00),('21','237','5','8',298,'43','2',2715857.64,2718277.35,2419.71,1548614.40,0.00,0.00,0.00,0.00,0.00),('21','237','6','8',299,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','8',300,'45','2',1816298.21,1821557.90,5259.69,3366201.60,0.00,0.00,0.00,0.00,0.00),('21','237','6','8',301,'46','2',4550945.37,4555943.54,4998.17,3198828.80,0.00,0.00,0.00,0.00,0.00),('21','237','6','8',302,'47','2',3854358.11,3859846.06,5487.95,3512288.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','8',303,'48','2',2308585.62,2311712.40,3126.78,2001139.20,0.00,0.00,0.00,0.00,0.00),('21','237','7','8',304,'49','2',2613955.02,2618119.41,4164.39,2665209.60,0.00,0.00,0.00,0.00,0.00),('21','237','1','8',305,'50','1',930201.84,930201.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','8',306,'51','1',670569.57,670569.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','8',307,'52','1',722662.14,722662.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','8',308,'53','1',847825.16,847825.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','8',309,'54','1',565902.72,566462.21,559.49,92315.85,0.00,0.00,0.00,0.00,0.00),('21','237','2','8',310,'55','1',401404.38,402165.41,761.03,125569.95,0.00,0.00,0.00,0.00,0.00),('21','237','2','8',311,'56','1',320134.20,321007.37,873.17,144073.05,0.00,0.00,0.00,0.00,0.00),('21','237','2','8',312,'57','1',659305.77,659915.61,609.84,100623.60,0.00,0.00,0.00,0.00,0.00),('21','237','3','8',313,'58','1',626142.83,626142.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','8',314,'59','1',287120.45,287120.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','8',315,'60','1',393963.05,393963.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','8',316,'61','1',544139.07,544139.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','8',317,'62','1',210397.50,210397.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','8',318,'63','1',467285.90,467285.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','8',319,'64','1',361129.86,361129.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','8',320,'65','1',136747.71,136747.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','9',321,'1','1',1313691.27,1313691.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','9',322,'3','1',769430.25,769430.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','9',323,'5','1',626617.36,626617.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','9',324,'7','1',1338415.27,1338415.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','9',325,'9','1',625926.36,625926.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','9',326,'11','1',477510.87,477510.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','9',327,'13','1',315204.51,315204.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','9',328,'15','1',516072.28,516072.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','9',329,'17','1',350125.89,356706.95,6581.06,1085874.90,0.00,0.00,0.00,0.00,0.00),('21','237','3','9',330,'18','1',303909.81,307111.10,3201.29,528212.85,0.00,0.00,0.00,0.00,0.00),('21','237','3','9',331,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','9',332,'23','1',380224.46,381359.21,1134.75,187233.75,0.00,0.00,0.00,0.00,0.00),('21','237','4','9',333,'25','1',116495.87,121194.29,4698.42,775239.30,0.00,0.00,0.00,0.00,0.00),('21','237','4','9',334,'27','1',188066.17,188066.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','9',335,'29','1',154746.71,158546.52,3799.81,626968.65,0.00,0.00,0.00,0.00,0.00),('21','237','4','9',336,'31','1',228626.97,233310.10,4683.13,772716.45,0.00,0.00,0.00,0.00,0.00),('21','237','5','9',337,'33','2',3307110.12,3314019.28,6909.16,4421862.40,0.00,0.00,0.00,0.00,0.00),('21','237','5','9',338,'35','2',3709030.87,3713504.79,4473.92,2863308.80,0.00,0.00,0.00,0.00,0.00),('21','237','5','9',339,'42','2',2710247.20,2715103.28,4856.08,3107891.20,0.00,0.00,0.00,0.00,0.00),('21','237','5','9',340,'43','2',2718277.35,2721571.07,3293.72,2107980.80,0.00,0.00,0.00,0.00,0.00),('21','237','6','9',341,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','9',342,'45','2',1821557.90,1825337.72,3779.82,2419084.80,0.00,0.00,0.00,0.00,0.00),('21','237','6','9',343,'46','2',4555943.54,4562345.77,6402.23,4097427.20,0.00,0.00,0.00,0.00,0.00),('21','237','6','9',344,'47','2',3859846.06,3864633.31,4787.25,3063840.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','9',345,'48','2',2311712.40,2314597.89,2885.49,1846713.60,0.00,0.00,0.00,0.00,0.00),('21','237','7','9',346,'49','2',2618119.41,2622942.83,4823.42,3086988.80,0.00,0.00,0.00,0.00,0.00),('21','237','1','9',347,'50','1',930201.84,930201.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','9',348,'51','1',670569.57,670569.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','9',349,'52','1',722662.14,722662.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','9',350,'53','1',847825.16,847825.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','9',351,'54','1',566462.21,566462.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','9',352,'55','1',402165.41,402165.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','9',353,'56','1',321007.37,321007.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','9',354,'57','1',659915.61,659915.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','9',355,'58','1',626142.83,632343.60,6200.77,1023127.05,0.00,0.00,0.00,0.00,0.00),('21','237','3','9',356,'59','1',287120.45,291304.90,4184.45,690434.25,0.00,0.00,0.00,0.00,0.00),('21','237','3','9',357,'60','1',393963.05,399168.61,5205.56,858917.40,0.00,0.00,0.00,0.00,0.00),('21','237','3','9',358,'61','1',544139.07,550232.70,6093.63,1005448.95,0.00,0.00,0.00,0.00,0.00),('21','237','4','9',359,'62','1',210397.50,210397.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','9',360,'63','1',467285.90,472219.97,4934.07,814121.55,0.00,0.00,0.00,0.00,0.00),('21','237','4','9',361,'64','1',361129.86,366366.17,5236.31,863991.15,0.00,0.00,0.00,0.00,0.00),('21','237','4','9',362,'65','1',136747.71,139587.18,2839.47,468512.55,0.00,0.00,0.00,0.00,0.00),('21','237','1','10',363,'1','1',1313691.27,1313691.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','10',364,'3','1',769430.25,769430.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','10',365,'5','1',626617.36,626617.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','10',366,'7','1',1338415.27,1338415.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','10',367,'9','1',625926.36,625926.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','10',368,'11','1',477510.87,477510.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','10',369,'13','1',315204.51,315204.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','10',370,'15','1',516072.28,516072.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','10',371,'17','1',356706.95,356706.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','10',372,'18','1',307111.10,307111.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','10',373,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','10',374,'23','1',381359.21,381359.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','10',375,'25','1',121194.29,121194.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','10',376,'27','1',188066.17,188066.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','10',377,'29','1',158546.52,158546.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','10',378,'31','1',233310.10,233310.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','10',379,'33','2',3314019.28,3314019.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','10',380,'35','2',3713504.79,3713504.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','10',381,'42','2',2715103.28,2715103.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','10',382,'43','2',2721571.07,2721571.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','10',383,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','10',384,'45','2',1825337.72,1825337.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','10',385,'46','2',4562345.77,4562345.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','10',386,'47','2',3864633.31,3864633.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','10',387,'48','2',2314597.89,2314597.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','10',388,'49','2',2622942.83,2622942.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','10',389,'50','1',930201.84,930201.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','10',390,'51','1',670569.57,670569.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','10',391,'52','1',722662.14,722662.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','10',392,'53','1',847825.16,847825.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','10',393,'54','1',566462.21,566462.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','10',394,'55','1',402165.41,402165.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','10',395,'56','1',321007.37,321007.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','10',396,'57','1',659915.61,659915.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','10',397,'58','1',632343.60,632343.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','10',398,'59','1',291304.90,291304.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','10',399,'60','1',399168.61,399168.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','10',400,'61','1',550232.70,550232.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','10',401,'62','1',210397.50,210397.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','10',402,'63','1',472219.97,472219.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','10',403,'64','1',366366.17,366366.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','10',404,'65','1',139587.18,139587.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','11',405,'1','1',1313691.27,1313691.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','11',406,'3','1',769430.25,769430.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','11',407,'5','1',626617.36,626617.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','11',408,'7','1',1338415.27,1338415.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','11',409,'9','1',625926.36,631710.51,5784.15,954384.75,0.00,0.00,0.00,0.00,0.00),('21','237','2','11',410,'11','1',477510.87,482329.77,4818.90,795118.50,0.00,0.00,0.00,0.00,0.00),('21','237','2','11',411,'13','1',315204.51,320254.39,5049.88,833230.20,0.00,0.00,0.00,0.00,0.00),('21','237','2','11',412,'15','1',516072.28,520697.21,4624.93,763113.45,0.00,0.00,0.00,0.00,0.00),('21','237','3','11',413,'17','1',356706.95,359519.04,2812.09,463994.85,0.00,0.00,0.00,0.00,0.00),('21','237','3','11',414,'18','1',307111.10,307634.36,523.26,86337.90,0.00,0.00,0.00,0.00,0.00),('21','237','3','11',415,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','11',416,'23','1',381359.21,383225.64,1866.43,307960.95,0.00,0.00,0.00,0.00,0.00),('21','237','4','11',417,'25','1',121194.29,121194.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','11',418,'27','1',188066.17,188066.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','11',419,'29','1',158546.52,158546.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','11',420,'31','1',233310.10,233310.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','11',421,'33','2',3314019.28,3317051.50,3032.22,1940620.80,0.00,0.00,0.00,0.00,0.00),('21','237','5','11',422,'35','2',3713504.79,3723438.89,9934.10,6357824.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','11',423,'42','2',2715103.28,2719594.45,4491.17,2874348.80,0.00,0.00,0.00,0.00,0.00),('21','237','5','11',424,'43','2',2721571.07,2724065.55,2494.48,1596467.20,0.00,0.00,0.00,0.00,0.00),('21','237','6','11',425,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','11',426,'45','2',1825337.72,1829939.59,4601.87,2945196.80,0.00,0.00,0.00,0.00,0.00),('21','237','6','11',427,'46','2',4562345.77,4569881.76,7535.99,4823033.60,0.00,0.00,0.00,0.00,0.00),('21','237','6','11',428,'47','2',3864633.31,3870227.37,5594.06,3580198.40,0.00,0.00,0.00,0.00,0.00),('21','237','7','11',429,'48','2',2314597.89,2319772.97,5175.08,3312051.20,0.00,0.00,0.00,0.00,0.00),('21','237','7','11',430,'49','2',2622942.83,2626219.91,3277.08,2097331.20,0.00,0.00,0.00,0.00,0.00),('21','237','1','11',431,'50','1',930201.84,930201.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','11',432,'51','1',670569.57,670569.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','11',433,'52','1',722662.14,722662.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','11',434,'53','1',847825.16,847825.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','11',435,'54','1',566462.21,572476.03,6013.82,992280.30,0.00,0.00,0.00,0.00,0.00),('21','237','2','11',436,'55','1',402165.41,407154.99,4989.58,823280.70,0.00,0.00,0.00,0.00,0.00),('21','237','2','11',437,'56','1',321007.37,325796.50,4789.13,790206.45,0.00,0.00,0.00,0.00,0.00),('21','237','2','11',438,'57','1',659915.61,664973.21,5057.60,834504.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','11',439,'58','1',632343.60,636454.41,4110.81,678283.65,0.00,0.00,0.00,0.00,0.00),('21','237','3','11',440,'59','1',291304.90,292820.36,1515.46,250050.90,0.00,0.00,0.00,0.00,0.00),('21','237','3','11',441,'60','1',399168.61,400193.70,1025.09,169139.85,0.00,0.00,0.00,0.00,0.00),('21','237','3','11',442,'61','1',550232.70,551714.52,1481.82,244500.30,0.00,0.00,0.00,0.00,0.00),('21','237','4','11',443,'62','1',210397.50,210397.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','11',444,'63','1',472219.97,472219.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','11',445,'64','1',366366.17,366366.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','11',446,'65','1',139587.18,139587.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','12',447,'1','1',1313691.27,1313691.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','12',448,'3','1',769430.25,769430.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','12',449,'5','1',626617.36,626617.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','12',450,'7','1',1338415.27,1338415.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','12',451,'9','1',631710.51,634687.44,2976.93,491193.45,0.00,0.00,0.00,0.00,0.00),('21','237','2','12',452,'11','1',482329.77,487009.65,4679.88,772180.20,0.00,0.00,0.00,0.00,0.00),('21','237','2','12',453,'13','1',320254.39,323028.61,2774.22,457746.30,0.00,0.00,0.00,0.00,0.00),('21','237','2','12',454,'15','1',520697.21,522106.73,1409.52,232570.80,0.00,0.00,0.00,0.00,0.00),('21','237','3','12',455,'17','1',359519.04,361455.65,1936.61,319540.65,0.00,0.00,0.00,0.00,0.00),('21','237','3','12',456,'18','1',307634.36,309386.68,1752.32,289132.80,0.00,0.00,0.00,0.00,0.00),('21','237','3','12',457,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','12',458,'23','1',383225.64,384131.27,905.63,149428.95,0.00,0.00,0.00,0.00,0.00),('21','237','4','12',459,'25','1',121194.29,126303.13,5108.84,842958.60,0.00,0.00,0.00,0.00,0.00),('21','237','4','12',460,'27','1',188066.17,188066.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','12',461,'29','1',158546.52,158546.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','12',462,'31','1',233310.10,234810.11,1500.01,247501.65,0.00,0.00,0.00,0.00,0.00),('21','237','5','12',463,'33','2',3317051.50,3318092.12,1040.62,665996.80,0.00,0.00,0.00,0.00,0.00),('21','237','5','12',464,'35','2',3723438.89,3728027.45,4588.56,2936678.40,0.00,0.00,0.00,0.00,0.00),('21','237','5','12',465,'42','2',2719594.45,2725270.61,5676.16,3632742.40,0.00,0.00,0.00,0.00,0.00),('21','237','5','12',466,'43','2',2724065.55,2729408.47,5342.92,3419468.80,0.00,0.00,0.00,0.00,0.00),('21','237','6','12',467,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','12',468,'45','2',1829939.59,1830544.72,605.13,387283.20,0.00,0.00,0.00,0.00,0.00),('21','237','6','12',469,'46','2',4569881.76,4571447.48,1565.72,1002060.80,0.00,0.00,0.00,0.00,0.00),('21','237','6','12',470,'47','2',3870227.37,3871128.94,901.57,577004.80,0.00,0.00,0.00,0.00,0.00),('21','237','7','12',471,'48','2',2319772.97,2325160.48,5387.51,3448006.40,0.00,0.00,0.00,0.00,0.00),('21','237','7','12',472,'49','2',2626219.91,2633977.90,7757.99,4965113.60,0.00,0.00,0.00,0.00,0.00),('21','237','1','12',473,'50','1',930201.84,930201.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','12',474,'51','1',670569.57,670569.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','12',475,'52','1',722662.14,722662.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','12',476,'53','1',847825.16,847825.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','12',477,'54','1',572476.03,573560.54,1084.51,178944.15,0.00,0.00,0.00,0.00,0.00),('21','237','2','12',478,'55','1',407154.99,410384.09,3229.10,532801.50,0.00,0.00,0.00,0.00,0.00),('21','237','2','12',479,'56','1',325796.50,329338.12,3541.62,584367.30,0.00,0.00,0.00,0.00,0.00),('21','237','2','12',480,'57','1',664973.21,667842.10,2868.89,473366.85,0.00,0.00,0.00,0.00,0.00),('21','237','3','12',481,'58','1',636454.41,640201.37,3746.96,618248.40,0.00,0.00,0.00,0.00,0.00),('21','237','3','12',482,'59','1',292820.36,295550.70,2730.34,450506.10,0.00,0.00,0.00,0.00,0.00),('21','237','3','12',483,'60','1',400193.70,402997.29,2803.59,462592.35,0.00,0.00,0.00,0.00,0.00),('21','237','3','12',484,'61','1',551714.52,556702.48,4987.96,823013.40,0.00,0.00,0.00,0.00,0.00),('21','237','4','12',485,'62','1',210397.50,210398.36,0.86,141.90,0.00,0.00,0.00,0.00,0.00),('21','237','4','12',486,'63','1',472219.97,474856.00,2636.03,434944.95,0.00,0.00,0.00,0.00,0.00),('21','237','4','12',487,'64','1',366366.17,366366.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','12',488,'65','1',139587.18,141966.81,2379.63,392638.95,0.00,0.00,0.00,0.00,0.00),('21','237','1','13',489,'1','1',1313691.27,1313691.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','13',490,'3','1',769430.25,769430.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','13',491,'5','1',626617.36,626617.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','13',492,'7','1',1338415.27,1338415.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','13',493,'9','1',634687.44,634687.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','13',494,'11','1',487009.65,487009.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','13',495,'13','1',323028.61,323028.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','13',496,'15','1',522106.73,522106.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','13',497,'17','1',361455.65,361455.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','13',498,'18','1',309386.68,309386.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','13',499,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','13',500,'23','1',384131.27,384131.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','13',501,'25','1',126303.13,126303.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','13',502,'27','1',188066.17,188066.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','13',503,'29','1',158546.52,158546.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','13',504,'31','1',234810.11,234810.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','13',505,'33','2',3318092.12,3318092.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','13',506,'35','2',3728027.45,3728027.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','13',507,'42','2',2725270.61,2725270.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','13',508,'43','2',2729408.47,2729408.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','13',509,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','13',510,'45','2',1830544.72,1830544.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','13',511,'46','2',4571447.48,4571447.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','13',512,'47','2',3871128.94,3871128.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','13',513,'48','2',2325160.48,2325160.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','13',514,'49','2',2633977.90,2633977.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','13',515,'50','1',930201.84,930201.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','13',516,'51','1',670569.57,670569.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','13',517,'52','1',722662.14,722662.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','13',518,'53','1',847825.16,847825.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','13',519,'54','1',573560.54,573560.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','13',520,'55','1',410384.09,410384.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','13',521,'56','1',329338.12,329338.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','13',522,'57','1',667842.10,667842.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','13',523,'58','1',640201.37,640201.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','13',524,'59','1',295550.70,295550.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','13',525,'60','1',402997.29,402997.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','13',526,'61','1',556702.48,556702.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','13',527,'62','1',210398.36,210398.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','13',528,'63','1',474856.00,474856.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','13',529,'64','1',366366.17,366366.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','13',530,'65','1',141966.81,141966.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','14',531,'1','1',1313691.27,1313691.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','14',532,'3','1',769430.25,769430.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','14',533,'5','1',626617.36,626617.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','14',534,'7','1',1338415.27,1338415.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','14',535,'9','1',634687.44,637533.35,2845.91,469575.15,0.00,0.00,0.00,0.00,0.00),('21','237','2','14',536,'11','1',487009.65,489968.99,2959.34,488291.10,0.00,0.00,0.00,0.00,0.00),('21','237','2','14',537,'13','1',323028.61,323733.95,705.34,116381.10,0.00,0.00,0.00,0.00,0.00),('21','237','2','14',538,'15','1',522106.73,524633.53,2526.80,416922.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','14',539,'17','1',361455.65,362988.13,1532.48,252859.20,0.00,0.00,0.00,0.00,0.00),('21','237','3','14',540,'18','1',309386.68,309883.06,496.38,81902.70,0.00,0.00,0.00,0.00,0.00),('21','237','3','14',541,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','14',542,'23','1',384131.27,386259.60,2128.33,351174.45,0.00,0.00,0.00,0.00,0.00),('21','237','4','14',543,'25','1',126303.13,130286.66,3983.53,657282.45,0.00,0.00,0.00,0.00,0.00),('21','237','4','14',544,'27','1',188066.17,188066.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','14',545,'29','1',158546.52,159921.87,1375.35,226932.75,0.00,0.00,0.00,0.00,0.00),('21','237','4','14',546,'31','1',234810.11,236119.95,1309.84,216123.60,0.00,0.00,0.00,0.00,0.00),('21','237','5','14',547,'33','2',3318092.12,3319763.40,1671.28,1069619.20,0.00,0.00,0.00,0.00,0.00),('21','237','5','14',548,'35','2',3728027.45,3734509.05,6481.60,4148224.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','14',549,'42','2',2725270.61,2727209.43,1938.82,1240844.80,0.00,0.00,0.00,0.00,0.00),('21','237','5','14',550,'43','2',2729408.47,2734385.35,4976.88,3185203.20,0.00,0.00,0.00,0.00,0.00),('21','237','6','14',551,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','14',552,'45','2',1830544.72,1831863.74,1319.02,844172.80,0.00,0.00,0.00,0.00,0.00),('21','237','6','14',553,'46','2',4571447.48,4575732.71,4285.23,2742547.20,0.00,0.00,0.00,0.00,0.00),('21','237','6','14',554,'47','2',3871128.94,3877960.83,6831.89,4372409.60,0.00,0.00,0.00,0.00,0.00),('21','237','7','14',555,'48','2',2325160.48,2328711.58,3551.10,2272704.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','14',556,'49','2',2633977.90,2637575.40,3597.50,2302400.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','14',557,'50','1',930201.84,930201.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','14',558,'51','1',670569.57,670569.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','14',559,'52','1',722662.14,722662.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','14',560,'53','1',847825.16,847825.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','14',561,'54','1',573560.54,575099.08,1538.54,253859.10,0.00,0.00,0.00,0.00,0.00),('21','237','2','14',562,'55','1',410384.09,412310.08,1925.99,317788.35,0.00,0.00,0.00,0.00,0.00),('21','237','2','14',563,'56','1',329338.12,330354.86,1016.74,167762.10,0.00,0.00,0.00,0.00,0.00),('21','237','2','14',564,'57','1',667842.10,671659.69,3817.59,629902.35,0.00,0.00,0.00,0.00,0.00),('21','237','3','14',565,'58','1',640201.37,642604.83,2403.46,396570.90,0.00,0.00,0.00,0.00,0.00),('21','237','3','14',566,'59','1',295550.70,297824.73,2274.03,375214.95,0.00,0.00,0.00,0.00,0.00),('21','237','3','14',567,'60','1',402997.29,406272.70,3275.41,540442.65,0.00,0.00,0.00,0.00,0.00),('21','237','3','14',568,'61','1',556702.48,559733.44,3030.96,500108.40,0.00,0.00,0.00,0.00,0.00),('21','237','4','14',569,'62','1',210398.36,210398.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','14',570,'63','1',474856.00,480506.80,5650.80,932382.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','14',571,'64','1',366366.17,369905.29,3539.12,583954.80,0.00,0.00,0.00,0.00,0.00),('21','237','4','14',572,'65','1',141966.81,145005.03,3038.22,501306.30,0.00,0.00,0.00,0.00,0.00),('21','237','1','15',573,'1','1',1313691.27,1313695.31,4.04,666.60,0.00,0.00,0.00,0.00,0.00),('21','237','1','15',574,'3','1',769430.25,774655.28,5225.03,862129.95,0.00,0.00,0.00,0.00,0.00),('21','237','1','15',575,'5','1',626617.36,628373.49,1756.13,289761.45,0.00,0.00,0.00,0.00,0.00),('21','237','1','15',576,'7','1',1338415.27,1339181.85,766.58,126485.70,0.00,0.00,0.00,0.00,0.00),('21','237','2','15',577,'9','1',643243.66,648728.62,5484.96,905018.40,0.00,0.00,0.00,0.00,0.00),('21','237','2','15',578,'11','1',494817.97,497255.83,2437.86,402246.90,0.00,0.00,0.00,0.00,0.00),('21','237','2','15',579,'13','1',326639.93,327807.47,1167.54,192644.10,0.00,0.00,0.00,0.00,0.00),('21','237','2','15',580,'15','1',528048.27,529830.44,1782.17,294058.05,0.00,0.00,0.00,0.00,0.00),('21','237','3','15',581,'17','1',365500.86,366929.22,1428.36,235679.40,0.00,0.00,0.00,0.00,0.00),('21','237','3','15',582,'18','1',313551.27,313949.12,397.85,65645.25,0.00,0.00,0.00,0.00,0.00),('21','237','3','15',583,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','15',584,'23','1',390561.69,393223.15,2661.46,439140.90,0.00,0.00,0.00,0.00,0.00),('21','237','4','15',585,'25','1',134381.95,135093.52,711.57,117409.05,0.00,0.00,0.00,0.00,0.00),('21','237','4','15',586,'27','1',188066.17,188066.36,0.19,31.35,0.00,0.00,0.00,0.00,0.00),('21','237','4','15',587,'29','1',160757.25,162227.77,1470.52,242635.80,0.00,0.00,0.00,0.00,0.00),('21','237','4','15',588,'31','1',239059.63,239132.36,72.73,12000.45,0.00,0.00,0.00,0.00,0.00),('21','237','5','15',589,'33','2',3324029.92,3327808.16,3778.24,2418073.60,0.00,0.00,0.00,0.00,0.00),('21','237','5','15',590,'35','2',3743321.03,3746043.55,2722.52,1742412.80,0.00,0.00,0.00,0.00,0.00),('21','237','5','15',591,'42','2',2732150.87,2735705.16,3554.29,2274745.60,0.00,0.00,0.00,0.00,0.00),('21','237','5','15',592,'43','2',2741680.80,2748065.17,6384.37,4085996.80,0.00,0.00,0.00,0.00,0.00),('21','237','6','15',593,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','15',594,'45','2',1836168.69,1837955.64,1786.95,1143648.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','15',595,'46','2',4583317.63,4590487.24,7169.61,4588550.40,0.00,0.00,0.00,0.00,0.00),('21','237','6','15',596,'47','2',3886626.34,3890983.85,4357.51,2788806.40,0.00,0.00,0.00,0.00,0.00),('21','237','7','15',597,'48','2',2332304.05,2334598.18,2294.13,1468243.20,0.00,0.00,0.00,0.00,0.00),('21','237','7','15',598,'49','2',2643724.53,2645160.74,1436.21,919174.40,0.00,0.00,0.00,0.00,0.00),('21','237','1','15',599,'50','1',930201.84,930202.26,0.42,69.30,0.00,0.00,0.00,0.00,0.00),('21','237','1','15',600,'51','1',670569.57,670573.21,3.64,600.60,0.00,0.00,0.00,0.00,0.00),('21','237','1','15',601,'52','1',722662.14,724282.58,1620.44,267372.60,0.00,0.00,0.00,0.00,0.00),('21','237','1','15',602,'53','1',847825.16,853679.05,5853.89,965891.85,0.00,0.00,0.00,0.00,0.00),('21','237','2','15',603,'54','1',578347.21,580303.05,1955.84,322713.60,0.00,0.00,0.00,0.00,0.00),('21','237','2','15',604,'55','1',416439.80,417954.76,1514.96,249968.40,0.00,0.00,0.00,0.00,0.00),('21','237','2','15',605,'56','1',334711.97,335586.10,874.13,144231.45,0.00,0.00,0.00,0.00,0.00),('21','237','2','15',606,'57','1',675955.91,678228.32,2272.41,374947.65,0.00,0.00,0.00,0.00,0.00),('21','237','3','15',607,'58','1',646003.31,649321.05,3317.74,547427.10,0.00,0.00,0.00,0.00,0.00),('21','237','3','15',608,'59','1',301604.12,306184.80,4580.68,755812.20,0.00,0.00,0.00,0.00,0.00),('21','237','3','15',609,'60','1',411124.78,413919.20,2794.42,461079.30,0.00,0.00,0.00,0.00,0.00),('21','237','3','15',610,'61','1',565131.89,566628.88,1496.99,247003.35,0.00,0.00,0.00,0.00,0.00),('21','237','4','15',611,'62','1',210398.36,210398.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','15',612,'63','1',487259.13,491702.45,4443.32,733147.80,0.00,0.00,0.00,0.00,0.00),('21','237','4','15',613,'64','1',375255.29,378978.19,3722.90,614278.50,0.00,0.00,0.00,0.00,0.00),('21','237','4','15',614,'65','1',148298.44,150327.65,2029.21,334819.65,0.00,0.00,0.00,0.00,0.00),('21','237','1','16',615,'1','1',1313695.31,1313695.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','16',616,'3','1',774655.28,779274.95,4619.67,762245.55,0.00,0.00,0.00,0.00,0.00),('21','237','1','16',617,'5','1',628373.49,632319.72,3946.23,651127.95,0.00,0.00,0.00,0.00,0.00),('21','237','1','16',618,'7','1',1339181.85,1342646.64,3464.79,571690.35,0.00,0.00,0.00,0.00,0.00),('21','237','2','16',619,'9','1',648728.62,652836.90,4108.28,677866.20,0.00,0.00,0.00,0.00,0.00),('21','237','2','16',620,'11','1',497255.83,498702.56,1446.73,238710.45,0.00,0.00,0.00,0.00,0.00),('21','237','2','16',621,'13','1',327807.47,328550.60,743.13,122616.45,0.00,0.00,0.00,0.00,0.00),('21','237','2','16',622,'15','1',529830.44,531769.14,1938.70,319885.50,0.00,0.00,0.00,0.00,0.00),('21','237','3','16',623,'17','1',366929.22,367747.37,818.15,134994.75,0.00,0.00,0.00,0.00,0.00),('21','237','3','16',624,'18','1',313949.12,313949.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','16',625,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','16',626,'23','1',393223.15,394689.94,1466.79,242020.35,0.00,0.00,0.00,0.00,0.00),('21','237','4','16',627,'25','1',135093.52,139211.52,4118.00,679470.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','16',628,'27','1',188066.36,188072.88,6.52,1075.80,0.00,0.00,0.00,0.00,0.00),('21','237','4','16',629,'29','1',162227.77,162506.42,278.65,45977.25,0.00,0.00,0.00,0.00,0.00),('21','237','4','16',630,'31','1',239132.36,239132.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','16',631,'33','2',3327808.16,3331106.24,3298.08,2110771.20,0.00,0.00,0.00,0.00,0.00),('21','237','5','16',632,'35','2',3746043.55,3750541.04,4497.49,2878393.60,0.00,0.00,0.00,0.00,0.00),('21','237','5','16',633,'42','2',2735705.16,2742708.45,7003.29,4482105.60,0.00,0.00,0.00,0.00,0.00),('21','237','5','16',634,'43','2',2748065.17,2750652.27,2587.10,1655744.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','16',635,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','16',636,'45','2',1837955.64,1840852.94,2897.30,1854272.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','16',637,'46','2',4590487.24,4597135.24,6648.00,4254720.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','16',638,'47','2',3890983.85,3893552.54,2568.69,1643961.60,0.00,0.00,0.00,0.00,0.00),('21','237','7','16',639,'48','2',2334598.18,2338380.09,3781.91,2420422.40,0.00,0.00,0.00,0.00,0.00),('21','237','7','16',640,'49','2',2645160.74,2651108.15,5947.41,3806342.40,0.00,0.00,0.00,0.00,0.00),('21','237','1','16',641,'50','1',930202.26,930202.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','16',642,'51','1',670573.21,671019.44,446.23,73627.95,0.00,0.00,0.00,0.00,0.00),('21','237','1','16',643,'52','1',724282.58,725409.67,1127.09,185969.85,0.00,0.00,0.00,0.00,0.00),('21','237','1','16',644,'53','1',853679.05,855152.80,1473.75,243168.75,0.00,0.00,0.00,0.00,0.00),('21','237','2','16',645,'54','1',580303.05,580982.03,678.98,112031.70,0.00,0.00,0.00,0.00,0.00),('21','237','2','16',646,'55','1',417954.76,420196.12,2241.36,369824.40,0.00,0.00,0.00,0.00,0.00),('21','237','2','16',647,'56','1',335586.10,339160.00,3573.90,589693.50,0.00,0.00,0.00,0.00,0.00),('21','237','2','16',648,'57','1',678228.32,679958.19,1729.87,285428.55,0.00,0.00,0.00,0.00,0.00),('21','237','3','16',649,'58','1',649321.05,652390.96,3069.91,506535.15,0.00,0.00,0.00,0.00,0.00),('21','237','3','16',650,'59','1',306184.80,306184.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','16',651,'60','1',413919.20,415580.97,1661.77,274192.05,0.00,0.00,0.00,0.00,0.00),('21','237','3','16',652,'61','1',566628.88,568983.58,2354.70,388525.50,0.00,0.00,0.00,0.00,0.00),('21','237','4','16',653,'62','1',210398.36,210398.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','16',654,'63','1',491702.45,496434.52,4732.07,780791.55,0.00,0.00,0.00,0.00,0.00),('21','237','4','16',655,'64','1',378978.19,381978.13,2999.94,494990.10,0.00,0.00,0.00,0.00,0.00),('21','237','4','16',656,'65','1',150327.65,150327.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','17',657,'1','1',1313695.31,1313695.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','17',658,'3','1',779274.95,782973.11,3698.16,610196.40,0.00,0.00,0.00,0.00,0.00),('21','237','1','17',659,'5','1',632319.72,633435.29,1115.57,184069.05,0.00,0.00,0.00,0.00,0.00),('21','237','1','17',660,'7','1',1342646.64,1344242.41,1595.77,263302.05,0.00,0.00,0.00,0.00,0.00),('21','237','2','17',661,'9','1',652836.90,657682.33,4845.43,799495.95,0.00,0.00,0.00,0.00,0.00),('21','237','2','17',662,'11','1',498702.56,502144.51,3441.95,567921.75,0.00,0.00,0.00,0.00,0.00),('21','237','2','17',663,'13','1',328550.60,330320.16,1769.56,291977.40,0.00,0.00,0.00,0.00,0.00),('21','237','2','17',664,'15','1',531769.14,533696.55,1927.41,318022.65,0.00,0.00,0.00,0.00,0.00),('21','237','3','17',665,'17','1',367747.37,370051.21,2303.84,380133.60,0.00,0.00,0.00,0.00,0.00),('21','237','3','17',666,'18','1',313949.12,315246.77,1297.65,214112.25,0.00,0.00,0.00,0.00,0.00),('21','237','3','17',667,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','17',668,'23','1',394689.94,396123.30,1433.36,236504.40,0.00,0.00,0.00,0.00,0.00),('21','237','4','17',669,'25','1',139211.52,144361.25,5149.73,849705.45,0.00,0.00,0.00,0.00,0.00),('21','237','4','17',670,'27','1',188072.88,188072.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','17',671,'29','1',162506.42,163331.79,825.37,136186.05,0.00,0.00,0.00,0.00,0.00),('21','237','4','17',672,'31','1',239132.36,239132.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','17',673,'33','2',3331106.24,3332322.49,1216.25,778400.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','17',674,'35','2',3750541.04,3757966.55,7425.51,4752326.40,0.00,0.00,0.00,0.00,0.00),('21','237','5','17',675,'42','2',2742708.45,2745428.45,2720.00,1740800.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','17',676,'43','2',2750652.27,2754038.92,3386.65,2167456.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','17',677,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','17',678,'45','2',1840852.94,1846984.20,6131.26,3924006.40,0.00,0.00,0.00,0.00,0.00),('21','237','6','17',679,'46','2',4597135.24,4603587.95,6452.71,4129734.40,0.00,0.00,0.00,0.00,0.00),('21','237','6','17',680,'47','2',3893552.54,3899759.61,6207.07,3972524.80,0.00,0.00,0.00,0.00,0.00),('21','237','7','17',681,'48','2',2338380.09,2341869.93,3489.84,2233497.60,0.00,0.00,0.00,0.00,0.00),('21','237','7','17',682,'49','2',2651108.15,2656407.59,5299.44,3391641.60,0.00,0.00,0.00,0.00,0.00),('21','237','1','17',683,'50','1',930202.26,930202.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','17',684,'51','1',671019.44,671563.38,543.94,89750.10,0.00,0.00,0.00,0.00,0.00),('21','237','1','17',685,'52','1',725409.67,727668.65,2258.98,372731.70,0.00,0.00,0.00,0.00,0.00),('21','237','1','17',686,'53','1',855152.80,859958.44,4805.64,792930.60,0.00,0.00,0.00,0.00,0.00),('21','237','2','17',687,'54','1',580982.03,583302.01,2319.98,382796.70,0.00,0.00,0.00,0.00,0.00),('21','237','2','17',688,'55','1',420196.12,420776.59,580.47,95777.55,0.00,0.00,0.00,0.00,0.00),('21','237','2','17',689,'56','1',339160.00,341840.14,2680.14,442223.10,0.00,0.00,0.00,0.00,0.00),('21','237','2','17',690,'57','1',679958.19,682309.55,2351.36,387974.40,0.00,0.00,0.00,0.00,0.00),('21','237','3','17',691,'58','1',652390.96,655766.64,3375.68,556987.20,0.00,0.00,0.00,0.00,0.00),('21','237','3','17',692,'59','1',306184.80,306319.51,134.71,22227.15,0.00,0.00,0.00,0.00,0.00),('21','237','3','17',693,'60','1',415580.97,418671.64,3090.67,509960.55,0.00,0.00,0.00,0.00,0.00),('21','237','3','17',694,'61','1',568983.58,572273.92,3290.34,542906.10,0.00,0.00,0.00,0.00,0.00),('21','237','4','17',695,'62','1',210398.36,210398.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','17',696,'63','1',496434.52,500679.61,4245.09,700439.85,0.00,0.00,0.00,0.00,0.00),('21','237','4','17',697,'64','1',381978.13,384040.61,2062.48,340309.20,0.00,0.00,0.00,0.00,0.00),('21','237','4','17',698,'65','1',150327.65,152290.20,1962.55,323820.75,0.00,0.00,0.00,0.00,0.00),('21','237','1','18',699,'1','1',1313695.31,1313695.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','18',700,'3','1',782973.11,788062.25,5089.14,839708.10,0.00,0.00,0.00,0.00,0.00),('21','237','1','18',701,'5','1',633435.29,636654.35,3219.06,531144.90,0.00,0.00,0.00,0.00,0.00),('21','237','1','18',702,'7','1',1344242.41,1345387.46,1145.05,188933.25,0.00,0.00,0.00,0.00,0.00),('21','237','2','18',703,'9','1',657682.33,658504.54,822.21,135664.65,0.00,0.00,0.00,0.00,0.00),('21','237','2','18',704,'11','1',502144.51,502144.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','18',705,'13','1',330320.16,330320.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','18',706,'15','1',533696.55,533696.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','18',707,'17','1',370051.21,372535.85,2484.64,409965.60,0.00,0.00,0.00,0.00,0.00),('21','237','3','18',708,'18','1',315246.77,317647.79,2401.02,396168.30,0.00,0.00,0.00,0.00,0.00),('21','237','3','18',709,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','18',710,'23','1',396123.30,399082.61,2959.31,488286.15,0.00,0.00,0.00,0.00,0.00),('21','237','4','18',711,'25','1',144361.25,147557.45,3196.20,527373.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','18',712,'27','1',188072.88,188072.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','18',713,'29','1',163331.79,164216.86,885.07,146036.55,0.00,0.00,0.00,0.00,0.00),('21','237','4','18',714,'31','1',239132.36,239132.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','18',715,'33','2',3332322.49,3336128.49,3806.00,2435840.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','18',716,'35','2',3757966.55,3762350.44,4383.89,2805689.60,0.00,0.00,0.00,0.00,0.00),('21','237','5','18',717,'42','2',2745428.45,2749055.10,3626.65,2321056.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','18',718,'43','2',2754038.92,2761068.63,7029.71,4499014.40,0.00,0.00,0.00,0.00,0.00),('21','237','6','18',719,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','18',720,'45','2',1846984.20,1848802.63,1818.43,1163795.20,0.00,0.00,0.00,0.00,0.00),('21','237','6','18',721,'46','2',4603587.95,4609708.85,6120.90,3917376.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','18',722,'47','2',3899759.61,3902968.93,3209.32,2053964.80,0.00,0.00,0.00,0.00,0.00),('21','237','7','18',723,'48','2',2341869.93,2344140.20,2270.27,1452972.80,0.00,0.00,0.00,0.00,0.00),('21','237','7','18',724,'49','2',2656407.59,2659972.12,3564.53,2281299.20,0.00,0.00,0.00,0.00,0.00),('21','237','1','18',725,'50','1',930202.26,930202.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','18',726,'51','1',671563.38,671676.14,112.76,18605.40,0.00,0.00,0.00,0.00,0.00),('21','237','1','18',727,'52','1',727668.65,730887.10,3218.45,531044.25,0.00,0.00,0.00,0.00,0.00),('21','237','1','18',728,'53','1',859958.44,864846.96,4888.52,806605.80,0.00,0.00,0.00,0.00,0.00),('21','237','2','18',729,'54','1',583302.01,583638.06,336.05,55448.25,0.00,0.00,0.00,0.00,0.00),('21','237','2','18',730,'55','1',420776.59,420776.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','18',731,'56','1',341840.14,341840.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','18',732,'57','1',682309.55,682309.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','18',733,'58','1',655766.64,659104.46,3337.82,550740.30,0.00,0.00,0.00,0.00,0.00),('21','237','3','18',734,'59','1',306319.51,308430.97,2111.46,348390.90,0.00,0.00,0.00,0.00,0.00),('21','237','3','18',735,'60','1',418671.64,423890.36,5218.72,861088.80,0.00,0.00,0.00,0.00,0.00),('21','237','3','18',736,'61','1',572273.92,578220.68,5946.76,981215.40,0.00,0.00,0.00,0.00,0.00),('21','237','4','18',737,'62','1',210398.36,210398.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','18',738,'63','1',500679.61,505625.99,4946.38,816152.70,0.00,0.00,0.00,0.00,0.00),('21','237','4','18',739,'64','1',384040.61,388077.06,4036.45,666014.25,0.00,0.00,0.00,0.00,0.00),('21','237','4','18',740,'65','1',152290.20,155599.95,3309.75,546108.75,0.00,0.00,0.00,0.00,0.00),('21','237','1','19',741,'1','1',1313695.31,1318710.40,5015.09,827489.85,0.00,0.00,0.00,0.00,0.00),('21','237','1','19',742,'3','1',788062.25,792776.71,4714.46,777885.90,0.00,0.00,0.00,0.00,0.00),('21','237','1','19',743,'5','1',636654.35,637368.39,714.04,117816.60,0.00,0.00,0.00,0.00,0.00),('21','237','1','19',744,'7','1',1345387.46,1349172.38,3784.92,624511.80,0.00,0.00,0.00,0.00,0.00),('21','237','2','19',745,'9','1',658504.54,662069.74,3565.20,588258.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','19',746,'11','1',502144.51,505745.22,3600.71,594117.15,0.00,0.00,0.00,0.00,0.00),('21','237','2','19',747,'13','1',330320.16,332353.63,2033.47,335522.55,0.00,0.00,0.00,0.00,0.00),('21','237','2','19',748,'15','1',533696.55,535957.61,2261.06,373074.90,0.00,0.00,0.00,0.00,0.00),('21','237','3','19',749,'17','1',372535.85,373488.77,952.92,157231.80,0.00,0.00,0.00,0.00,0.00),('21','237','3','19',750,'18','1',317647.79,318086.70,438.91,72420.15,0.00,0.00,0.00,0.00,0.00),('21','237','3','19',751,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','19',752,'23','1',399082.61,399084.09,1.48,244.20,0.00,0.00,0.00,0.00,0.00),('21','237','4','19',753,'25','1',147557.45,149861.23,2303.78,380123.70,0.00,0.00,0.00,0.00,0.00),('21','237','4','19',754,'27','1',188072.88,188072.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','19',755,'29','1',164216.86,164472.97,256.11,42258.15,0.00,0.00,0.00,0.00,0.00),('21','237','4','19',756,'31','1',239132.36,240609.74,1477.38,243767.70,0.00,0.00,0.00,0.00,0.00),('21','237','5','19',757,'33','2',3336128.49,3339519.91,3391.42,2170508.80,0.00,0.00,0.00,0.00,0.00),('21','237','5','19',758,'35','2',3762350.44,3767381.53,5031.09,3219897.60,0.00,0.00,0.00,0.00,0.00),('21','237','5','19',759,'42','2',2749055.10,2750720.10,1665.00,1065600.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','19',760,'43','2',2761068.63,2765193.21,4124.58,2639731.20,0.00,0.00,0.00,0.00,0.00),('21','237','6','19',761,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','19',762,'45','2',1848802.63,1850757.37,1954.74,1251033.60,0.00,0.00,0.00,0.00,0.00),('21','237','6','19',763,'46','2',4609708.85,4615370.71,5661.86,3623590.40,0.00,0.00,0.00,0.00,0.00),('21','237','6','19',764,'47','2',3902968.93,3908256.24,5287.31,3383878.40,0.00,0.00,0.00,0.00,0.00),('21','237','7','19',765,'48','2',2344140.20,2346085.87,1945.67,1245228.80,0.00,0.00,0.00,0.00,0.00),('21','237','7','19',766,'49','2',2659972.12,2662144.84,2172.72,1390540.80,0.00,0.00,0.00,0.00,0.00),('21','237','1','19',767,'50','1',930202.26,930205.31,3.05,503.25,0.00,0.00,0.00,0.00,0.00),('21','237','1','19',768,'51','1',671676.14,673062.68,1386.54,228779.10,0.00,0.00,0.00,0.00,0.00),('21','237','1','19',769,'52','1',730887.10,732634.88,1747.78,288383.70,0.00,0.00,0.00,0.00,0.00),('21','237','1','19',770,'53','1',864846.96,869623.26,4776.30,788089.50,0.00,0.00,0.00,0.00,0.00),('21','237','2','19',771,'54','1',583638.06,586334.55,2696.49,444920.85,0.00,0.00,0.00,0.00,0.00),('21','237','2','19',772,'55','1',420776.59,421097.55,320.96,52958.40,0.00,0.00,0.00,0.00,0.00),('21','237','2','19',773,'56','1',341840.14,344716.51,2876.37,474601.05,0.00,0.00,0.00,0.00,0.00),('21','237','2','19',774,'57','1',682309.55,684665.55,2356.00,388740.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','19',775,'58','1',659104.46,660927.53,1823.07,300806.55,0.00,0.00,0.00,0.00,0.00),('21','237','3','19',776,'59','1',308430.97,309553.82,1122.85,185270.25,0.00,0.00,0.00,0.00,0.00),('21','237','3','19',777,'60','1',423890.36,426161.73,2271.37,374776.05,0.00,0.00,0.00,0.00,0.00),('21','237','3','19',778,'61','1',578220.68,582502.50,4281.82,706500.30,0.00,0.00,0.00,0.00,0.00),('21','237','4','19',779,'62','1',210398.36,210398.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','19',780,'63','1',505625.99,510523.13,4897.14,808028.10,0.00,0.00,0.00,0.00,0.00),('21','237','4','19',781,'64','1',388077.06,391054.78,2977.72,491323.80,0.00,0.00,0.00,0.00,0.00),('21','237','4','19',782,'65','1',155599.95,157702.96,2103.01,346996.65,0.00,0.00,0.00,0.00,0.00),('21','237','1','20',783,'1','1',1318710.40,1320765.93,2055.53,339162.45,0.00,0.00,0.00,0.00,0.00),('21','237','1','20',784,'3','1',792776.71,794722.99,1946.28,321136.20,0.00,0.00,0.00,0.00,0.00),('21','237','1','20',785,'5','1',637368.39,638491.20,1122.81,185263.65,0.00,0.00,0.00,0.00,0.00),('21','237','1','20',786,'7','1',1349172.38,1350460.61,1288.23,212557.95,0.00,0.00,0.00,0.00,0.00),('21','237','2','20',787,'9','1',662069.74,662069.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','20',788,'11','1',505745.22,505745.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','20',789,'13','1',332353.63,332353.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','20',790,'15','1',535957.61,535957.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','20',791,'17','1',373488.77,373488.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','20',792,'18','1',318086.70,318086.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','20',793,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','20',794,'23','1',399084.09,399084.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','20',795,'25','1',149861.23,150669.96,808.73,133440.45,0.00,0.00,0.00,0.00,0.00),('21','237','4','20',796,'27','1',188072.88,188072.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','20',797,'29','1',164472.97,164486.19,13.22,2181.30,0.00,0.00,0.00,0.00,0.00),('21','237','4','20',798,'31','1',240609.74,240937.98,328.24,54159.60,0.00,0.00,0.00,0.00,0.00),('21','237','5','20',799,'33','2',3339519.91,3343632.82,4112.91,2632262.40,0.00,0.00,0.00,0.00,0.00),('21','237','5','20',800,'35','2',3767381.53,3770046.56,2665.03,1705619.20,0.00,0.00,0.00,0.00,0.00),('21','237','5','20',801,'42','2',2750720.10,2751241.66,521.56,333798.40,0.00,0.00,0.00,0.00,0.00),('21','237','5','20',802,'43','2',2765193.21,2768264.67,3071.46,1965734.40,0.00,0.00,0.00,0.00,0.00),('21','237','6','20',803,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','20',804,'45','2',1850757.37,1854266.79,3509.42,2246028.80,0.00,0.00,0.00,0.00,0.00),('21','237','6','20',805,'46','2',4615370.71,4619005.85,3635.14,2326489.60,0.00,0.00,0.00,0.00,0.00),('21','237','6','20',806,'47','2',3908256.24,3911642.40,3386.16,2167142.40,0.00,0.00,0.00,0.00,0.00),('21','237','7','20',807,'48','2',2346085.87,2347524.17,1438.30,920512.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','20',808,'49','2',2662144.84,2663397.96,1253.12,801996.80,0.00,0.00,0.00,0.00,0.00),('21','237','1','20',809,'50','1',930205.31,930434.41,229.10,37801.50,0.00,0.00,0.00,0.00,0.00),('21','237','1','20',810,'51','1',673062.68,674518.93,1456.25,240281.25,0.00,0.00,0.00,0.00,0.00),('21','237','1','20',811,'52','1',732634.88,734337.53,1702.65,280937.25,0.00,0.00,0.00,0.00,0.00),('21','237','1','20',812,'53','1',869623.26,871301.76,1678.50,276952.50,0.00,0.00,0.00,0.00,0.00),('21','237','2','20',813,'54','1',586334.55,586334.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','20',814,'55','1',421097.55,421097.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','20',815,'56','1',344716.51,344716.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','20',816,'57','1',684665.55,684665.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','20',817,'58','1',660927.53,660927.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','20',818,'59','1',309553.82,309553.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','20',819,'60','1',426161.73,426189.48,27.75,4578.75,0.00,0.00,0.00,0.00,0.00),('21','237','3','20',820,'61','1',582502.50,582502.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','20',821,'62','1',210398.36,210413.54,15.18,2504.70,0.00,0.00,0.00,0.00,0.00),('21','237','4','20',822,'63','1',510523.13,511442.16,919.03,151639.95,0.00,0.00,0.00,0.00,0.00),('21','237','4','20',823,'64','1',391054.78,391843.52,788.74,130142.10,0.00,0.00,0.00,0.00,0.00),('21','237','4','20',824,'65','1',157702.96,158246.71,543.75,89718.75,0.00,0.00,0.00,0.00,0.00),('21','237','1','21',825,'1','1',1320765.93,1320765.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','21',826,'3','1',794722.99,794722.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','21',827,'5','1',638491.20,638491.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','21',828,'7','1',1350460.61,1350460.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','21',829,'9','1',662069.74,662069.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','21',830,'11','1',505745.22,505745.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','21',831,'13','1',332353.63,332353.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','21',832,'15','1',535957.61,535957.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','21',833,'17','1',373488.77,378244.18,4755.41,784642.65,0.00,0.00,0.00,0.00,0.00),('21','237','3','21',834,'18','1',318086.70,321454.22,3367.52,555640.80,0.00,0.00,0.00,0.00,0.00),('21','237','3','21',835,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','21',836,'23','1',399084.09,403741.09,4657.00,768405.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','21',837,'25','1',150669.96,152785.82,2115.86,349116.90,0.00,0.00,0.00,0.00,0.00),('21','237','4','21',838,'27','1',188072.88,188072.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','21',839,'29','1',164486.19,164875.40,389.21,64219.65,0.00,0.00,0.00,0.00,0.00),('21','237','4','21',840,'31','1',240937.98,241596.62,658.64,108675.60,0.00,0.00,0.00,0.00,0.00),('21','237','5','21',841,'33','2',3343632.82,3349230.69,5597.87,3582636.80,0.00,0.00,0.00,0.00,0.00),('21','237','5','21',842,'35','2',3770046.56,3774477.52,4430.96,2835814.40,0.00,0.00,0.00,0.00,0.00),('21','237','5','21',843,'42','2',2751241.66,2755549.40,4307.74,2756953.60,0.00,0.00,0.00,0.00,0.00),('21','237','5','21',844,'43','2',2768264.67,2774186.87,5922.20,3790208.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','21',845,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','21',846,'45','2',1854266.79,1857895.24,3628.45,2322208.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','21',847,'46','2',4619005.85,4627508.05,8502.20,5441408.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','21',848,'47','2',3911642.40,3919820.94,8178.54,5234265.60,0.00,0.00,0.00,0.00,0.00),('21','237','7','21',849,'48','2',2347524.17,2349774.11,2249.94,1439961.60,0.00,0.00,0.00,0.00,0.00),('21','237','7','21',850,'49','2',2663397.96,2668147.21,4749.25,3039520.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','21',851,'50','1',930434.41,930434.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','21',852,'51','1',674518.93,674518.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','21',853,'52','1',734337.53,734337.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','21',854,'53','1',871301.76,871301.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','21',855,'54','1',586334.55,586334.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','21',856,'55','1',421097.55,421097.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','21',857,'56','1',344716.51,344716.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','21',858,'57','1',684665.55,684665.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','21',859,'58','1',660927.53,665680.84,4753.31,784296.15,0.00,0.00,0.00,0.00,0.00),('21','237','3','21',860,'59','1',309553.82,315097.39,5543.57,914689.05,0.00,0.00,0.00,0.00,0.00),('21','237','3','21',861,'60','1',426189.48,430154.06,3964.58,654155.70,0.00,0.00,0.00,0.00,0.00),('21','237','3','21',862,'61','1',582502.50,588404.66,5902.16,973856.40,0.00,0.00,0.00,0.00,0.00),('21','237','4','21',863,'62','1',210413.54,210465.06,51.52,8500.80,0.00,0.00,0.00,0.00,0.00),('21','237','4','21',864,'63','1',511442.16,513648.59,2206.43,364060.95,0.00,0.00,0.00,0.00,0.00),('21','237','4','21',865,'64','1',391843.52,393025.06,1181.54,194954.10,0.00,0.00,0.00,0.00,0.00),('21','237','4','21',866,'65','1',158246.71,159545.40,1298.69,214283.85,0.00,0.00,0.00,0.00,0.00),('21','237','1','22',867,'1','1',1320765.93,1327622.72,6856.79,1131370.35,0.00,0.00,0.00,0.00,0.00),('21','237','1','22',868,'3','1',794722.99,799225.11,4502.12,742849.80,0.00,0.00,0.00,0.00,0.00),('21','237','1','22',869,'5','1',638491.20,641604.07,3112.87,513623.55,0.00,0.00,0.00,0.00,0.00),('21','237','1','22',870,'7','1',1350460.61,1353461.29,3000.68,495112.20,0.00,0.00,0.00,0.00,0.00),('21','237','2','22',871,'9','1',662069.74,664434.53,2364.79,390190.35,0.00,0.00,0.00,0.00,0.00),('21','237','2','22',872,'11','1',505745.22,507789.72,2044.50,337342.50,0.00,0.00,0.00,0.00,0.00),('21','237','2','22',873,'13','1',332353.63,333077.84,724.21,119494.65,0.00,0.00,0.00,0.00,0.00),('21','237','2','22',874,'15','1',535957.61,537652.99,1695.38,279737.70,0.00,0.00,0.00,0.00,0.00),('21','237','3','22',875,'17','1',378244.18,378244.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','22',876,'18','1',321454.22,321454.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','22',877,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','22',878,'23','1',403741.09,403741.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','22',879,'25','1',152785.82,153797.63,1011.81,166948.65,0.00,0.00,0.00,0.00,0.00),('21','237','4','22',880,'27','1',188072.88,188072.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','22',881,'29','1',164875.40,166060.33,1184.93,195513.45,0.00,0.00,0.00,0.00,0.00),('21','237','4','22',882,'31','1',241596.62,241596.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','22',883,'33','2',3349230.69,3353277.45,4046.76,2589926.40,0.00,0.00,0.00,0.00,0.00),('21','237','5','22',884,'35','2',3774477.52,3778538.60,4061.08,2599091.20,0.00,0.00,0.00,0.00,0.00),('21','237','5','22',885,'42','2',2755549.40,2759740.88,4191.48,2682547.20,0.00,0.00,0.00,0.00,0.00),('21','237','5','22',886,'43','2',2774186.87,2779596.82,5409.95,3462368.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','22',887,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','22',888,'45','2',1857895.24,1863237.61,5342.37,3419116.80,0.00,0.00,0.00,0.00,0.00),('21','237','6','22',889,'46','2',4627508.05,4633525.72,6017.67,3851308.80,0.00,0.00,0.00,0.00,0.00),('21','237','6','22',890,'47','2',3919820.94,3926512.32,6691.38,4282483.20,0.00,0.00,0.00,0.00,0.00),('21','237','7','22',891,'48','2',2349774.11,2354605.52,4831.41,3092102.40,0.00,0.00,0.00,0.00,0.00),('21','237','7','22',892,'49','2',2668147.21,2670717.22,2570.01,1644806.40,0.00,0.00,0.00,0.00,0.00),('21','237','1','22',893,'50','1',930434.41,930440.31,5.90,973.50,0.00,0.00,0.00,0.00,0.00),('21','237','1','22',894,'51','1',674518.93,677761.57,3242.64,535035.60,0.00,0.00,0.00,0.00,0.00),('21','237','1','22',895,'52','1',734337.53,737085.23,2747.70,453370.50,0.00,0.00,0.00,0.00,0.00),('21','237','1','22',896,'53','1',871301.76,877698.34,6396.58,1055435.70,0.00,0.00,0.00,0.00,0.00),('21','237','2','22',897,'54','1',586334.55,588163.01,1828.46,301695.90,0.00,0.00,0.00,0.00,0.00),('21','237','2','22',898,'55','1',421097.55,423171.31,2073.76,342170.40,0.00,0.00,0.00,0.00,0.00),('21','237','2','22',899,'56','1',344716.51,347021.52,2305.01,380326.65,0.00,0.00,0.00,0.00,0.00),('21','237','2','22',900,'57','1',684665.55,686795.24,2129.69,351398.85,0.00,0.00,0.00,0.00,0.00),('21','237','3','22',901,'58','1',665680.84,665680.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','22',902,'59','1',315097.39,315097.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','22',903,'60','1',430154.06,430154.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','22',904,'61','1',588404.66,588404.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','22',905,'62','1',210465.06,210471.15,6.09,1004.85,0.00,0.00,0.00,0.00,0.00),('21','237','4','22',906,'63','1',513648.59,514902.04,1253.45,206819.25,0.00,0.00,0.00,0.00,0.00),('21','237','4','22',907,'64','1',393025.06,393505.32,480.26,79242.90,0.00,0.00,0.00,0.00,0.00),('21','237','4','22',908,'65','1',159545.40,160853.43,1308.03,215824.95,0.00,0.00,0.00,0.00,0.00),('21','237','1','23',909,'1','1',1327622.72,1327622.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','23',910,'3','1',799225.11,799225.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','23',911,'5','1',641604.07,641604.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','23',912,'7','1',1353461.29,1353461.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','23',913,'9','1',664434.53,666924.98,2490.45,410924.25,0.00,0.00,0.00,0.00,0.00),('21','237','2','23',914,'11','1',507789.72,508567.31,777.59,128302.35,0.00,0.00,0.00,0.00,0.00),('21','237','2','23',915,'13','1',333077.84,334005.70,927.86,153096.90,0.00,0.00,0.00,0.00,0.00),('21','237','2','23',916,'15','1',537652.99,538471.69,818.70,135085.50,0.00,0.00,0.00,0.00,0.00),('21','237','3','23',917,'17','1',378244.18,381370.47,3126.29,515837.85,0.00,0.00,0.00,0.00,0.00),('21','237','3','23',918,'18','1',321454.22,323715.44,2261.22,373101.30,0.00,0.00,0.00,0.00,0.00),('21','237','3','23',919,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','23',920,'23','1',403741.09,407199.14,3458.05,570578.25,0.00,0.00,0.00,0.00,0.00),('21','237','4','23',921,'25','1',153797.63,157387.57,3589.94,592340.10,0.00,0.00,0.00,0.00,0.00),('21','237','4','23',922,'27','1',188072.88,188072.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','23',923,'29','1',166060.33,168108.76,2048.43,337990.95,0.00,0.00,0.00,0.00,0.00),('21','237','4','23',924,'31','1',241596.62,244179.83,2583.21,426229.65,0.00,0.00,0.00,0.00,0.00),('21','237','5','23',925,'33','2',3353277.45,3362413.78,9136.33,5847251.20,0.00,0.00,0.00,0.00,0.00),('21','237','5','23',926,'35','2',3778538.60,3778544.91,6.31,4038.40,0.00,0.00,0.00,0.00,0.00),('21','237','5','23',927,'42','2',2759740.88,2762428.69,2687.81,1720198.40,0.00,0.00,0.00,0.00,0.00),('21','237','5','23',928,'43','2',2779596.82,2785274.04,5677.22,3633420.80,0.00,0.00,0.00,0.00,0.00),('21','237','6','23',929,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','23',930,'45','2',1863237.61,1864774.49,1536.88,983603.20,0.00,0.00,0.00,0.00,0.00),('21','237','6','23',931,'46','2',4633525.72,4639633.51,6107.79,3908985.60,0.00,0.00,0.00,0.00,0.00),('21','237','6','23',932,'47','2',3926512.32,3932688.76,6176.44,3952921.60,0.00,0.00,0.00,0.00,0.00),('21','237','7','23',933,'48','2',2354605.52,2358178.77,3573.25,2286880.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','23',934,'49','2',2670717.22,2673187.04,2469.82,1580684.80,0.00,0.00,0.00,0.00,0.00),('21','237','1','23',935,'50','1',930440.31,930440.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','23',936,'51','1',677761.57,677761.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','23',937,'52','1',737085.23,737085.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','23',938,'53','1',877698.34,877698.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','23',939,'54','1',588163.01,589465.96,1302.95,214986.75,0.00,0.00,0.00,0.00,0.00),('21','237','2','23',940,'55','1',423171.31,423702.62,531.31,87666.15,0.00,0.00,0.00,0.00,0.00),('21','237','2','23',941,'56','1',347021.52,348363.77,1342.25,221471.25,0.00,0.00,0.00,0.00,0.00),('21','237','2','23',942,'57','1',686795.24,689979.91,3184.67,525470.55,0.00,0.00,0.00,0.00,0.00),('21','237','3','23',943,'58','1',665680.84,668980.03,3299.19,544366.35,0.00,0.00,0.00,0.00,0.00),('21','237','3','23',944,'59','1',315097.39,318060.60,2963.21,488929.65,0.00,0.00,0.00,0.00,0.00),('21','237','3','23',945,'60','1',430154.06,432515.12,2361.06,389574.90,0.00,0.00,0.00,0.00,0.00),('21','237','3','23',946,'61','1',588404.66,591651.75,3247.09,535769.85,0.00,0.00,0.00,0.00,0.00),('21','237','4','23',947,'62','1',210471.15,210471.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','23',948,'63','1',514902.04,521440.54,6538.50,1078852.50,0.00,0.00,0.00,0.00,0.00),('21','237','4','23',949,'64','1',393505.32,398602.91,5097.59,841102.35,0.00,0.00,0.00,0.00,0.00),('21','237','4','23',950,'65','1',160853.43,164736.69,3883.26,640737.90,0.00,0.00,0.00,0.00,0.00),('21','237','1','24',951,'1','1',1327622.72,1327622.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','24',952,'3','1',799225.11,799225.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','24',953,'5','1',641604.07,641604.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','24',954,'7','1',1353461.29,1353461.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','24',955,'9','1',666924.98,672523.24,5598.26,923712.90,0.00,0.00,0.00,0.00,0.00),('21','237','2','24',956,'11','1',508567.31,511490.77,2923.46,482370.90,0.00,0.00,0.00,0.00,0.00),('21','237','2','24',957,'13','1',334005.70,336358.66,2352.96,388238.40,0.00,0.00,0.00,0.00,0.00),('21','237','2','24',958,'15','1',538471.69,541903.07,3431.38,566177.70,0.00,0.00,0.00,0.00,0.00),('21','237','3','24',959,'17','1',381370.47,383608.60,2238.13,369291.45,0.00,0.00,0.00,0.00,0.00),('21','237','3','24',960,'18','1',323715.44,323715.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','24',961,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','24',962,'23','1',407199.14,409407.13,2207.99,364318.35,0.00,0.00,0.00,0.00,0.00),('21','237','4','24',963,'25','1',157387.57,161502.95,4115.38,679037.70,0.00,0.00,0.00,0.00,0.00),('21','237','4','24',964,'27','1',188072.88,188072.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','24',965,'29','1',168108.76,168770.87,662.11,109248.15,0.00,0.00,0.00,0.00,0.00),('21','237','4','24',966,'31','1',244179.83,245266.94,1087.11,179373.15,0.00,0.00,0.00,0.00,0.00),('21','237','5','24',967,'33','2',3362413.78,3371022.39,8608.61,5509510.40,0.00,0.00,0.00,0.00,0.00),('21','237','5','24',968,'35','2',3778544.91,3783891.78,5346.87,3421996.80,0.00,0.00,0.00,0.00,0.00),('21','237','5','24',969,'42','2',2762428.69,2768197.56,5768.87,3692076.80,0.00,0.00,0.00,0.00,0.00),('21','237','5','24',970,'43','2',2785274.04,2789047.72,3773.68,2415155.20,0.00,0.00,0.00,0.00,0.00),('21','237','6','24',971,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','24',972,'45','2',1864774.49,1868343.25,3568.76,2284006.40,0.00,0.00,0.00,0.00,0.00),('21','237','6','24',973,'46','2',4639633.51,4645800.27,6166.76,3946726.40,0.00,0.00,0.00,0.00,0.00),('21','237','6','24',974,'47','2',3932688.76,3936676.48,3987.72,2552140.80,0.00,0.00,0.00,0.00,0.00),('21','237','7','24',975,'48','2',2358178.77,2360543.24,2364.47,1513260.80,0.00,0.00,0.00,0.00,0.00),('21','237','7','24',976,'49','2',2673187.04,2677255.24,4068.20,2603648.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','24',977,'50','1',930440.31,930440.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','24',978,'51','1',677761.57,677761.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','24',979,'52','1',737085.23,737085.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','24',980,'53','1',877698.34,877698.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','24',981,'54','1',589465.96,591910.93,2444.97,403420.05,0.00,0.00,0.00,0.00,0.00),('21','237','2','24',982,'55','1',423702.62,425766.57,2063.95,340551.75,0.00,0.00,0.00,0.00,0.00),('21','237','2','24',983,'56','1',348363.77,350408.60,2044.83,337396.95,0.00,0.00,0.00,0.00,0.00),('21','237','2','24',984,'57','1',689979.91,695269.33,5289.42,872754.30,0.00,0.00,0.00,0.00,0.00),('21','237','3','24',985,'58','1',668980.03,671013.91,2033.88,335590.20,0.00,0.00,0.00,0.00,0.00),('21','237','3','24',986,'59','1',318060.60,318060.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','24',987,'60','1',432515.12,434827.94,2312.82,381615.30,0.00,0.00,0.00,0.00,0.00),('21','237','3','24',988,'61','1',591651.75,595055.38,3403.63,561598.95,0.00,0.00,0.00,0.00,0.00),('21','237','4','24',989,'62','1',210471.15,210471.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','24',990,'63','1',521440.54,526075.43,4634.89,764756.85,0.00,0.00,0.00,0.00,0.00),('21','237','4','24',991,'64','1',398602.91,402038.30,3435.39,566839.35,0.00,0.00,0.00,0.00,0.00),('21','237','4','24',992,'65','1',164736.69,166039.27,1302.58,214925.70,0.00,0.00,0.00,0.00,0.00),('21','237','1','25',993,'1','1',1327622.72,1327622.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','25',994,'3','1',799225.11,799225.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','25',995,'5','1',641604.07,641604.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','25',996,'7','1',1353461.29,1353461.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','25',997,'9','1',672523.24,674116.23,1592.99,262843.35,0.00,0.00,0.00,0.00,0.00),('21','237','2','25',998,'11','1',511490.77,512255.34,764.57,126154.05,0.00,0.00,0.00,0.00,0.00),('21','237','2','25',999,'13','1',336358.66,337390.82,1032.16,170306.40,0.00,0.00,0.00,0.00,0.00),('21','237','2','25',1000,'15','1',541903.07,542850.94,947.87,156398.55,0.00,0.00,0.00,0.00,0.00),('21','237','3','25',1001,'17','1',383608.60,388141.18,4532.58,747875.70,0.00,0.00,0.00,0.00,0.00),('21','237','3','25',1002,'18','1',323715.44,324582.87,867.43,143125.95,0.00,0.00,0.00,0.00,0.00),('21','237','3','25',1003,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','25',1004,'23','1',409407.13,411902.14,2495.01,411676.65,0.00,0.00,0.00,0.00,0.00),('21','237','4','25',1005,'25','1',161502.95,164886.25,3383.30,558244.50,0.00,0.00,0.00,0.00,0.00),('21','237','4','25',1006,'27','1',188072.88,188072.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','25',1007,'29','1',168770.87,169943.46,1172.59,193477.35,0.00,0.00,0.00,0.00,0.00),('21','237','4','25',1008,'31','1',245266.94,245266.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','25',1009,'33','2',3371022.39,3375771.93,4749.54,3039705.60,0.00,0.00,0.00,0.00,0.00),('21','237','5','25',1010,'35','2',3783891.78,3790428.81,6537.03,4183699.20,0.00,0.00,0.00,0.00,0.00),('21','237','5','25',1011,'42','2',2768197.56,2770773.30,2575.74,1648473.60,0.00,0.00,0.00,0.00,0.00),('21','237','5','25',1012,'43','2',2789047.72,2793158.51,4110.79,2630905.60,0.00,0.00,0.00,0.00,0.00),('21','237','6','25',1013,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','25',1014,'45','2',1868343.25,1875632.52,7289.27,4665132.80,0.00,0.00,0.00,0.00,0.00),('21','237','6','25',1015,'46','2',4645800.27,4651892.21,6091.94,3898841.60,0.00,0.00,0.00,0.00,0.00),('21','237','6','25',1016,'47','2',3936676.48,3942181.43,5504.95,3523168.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','25',1017,'48','2',2360543.24,2364575.35,4032.11,2580550.40,0.00,0.00,0.00,0.00,0.00),('21','237','7','25',1018,'49','2',2677255.24,2684724.59,7469.35,4780384.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','25',1019,'50','1',930440.31,930440.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','25',1020,'51','1',677761.57,677761.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','25',1021,'52','1',737085.23,737085.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','25',1022,'53','1',877698.34,877698.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','25',1023,'54','1',591910.93,592739.98,829.05,136793.25,0.00,0.00,0.00,0.00,0.00),('21','237','2','25',1024,'55','1',425766.57,426701.34,934.77,154237.05,0.00,0.00,0.00,0.00,0.00),('21','237','2','25',1025,'56','1',350408.60,351054.39,645.79,106555.35,0.00,0.00,0.00,0.00,0.00),('21','237','2','25',1026,'57','1',695269.33,696257.36,988.03,163024.95,0.00,0.00,0.00,0.00,0.00),('21','237','3','25',1027,'58','1',671013.91,675971.98,4958.07,818081.55,0.00,0.00,0.00,0.00,0.00),('21','237','3','25',1028,'59','1',318060.60,321298.96,3238.36,534329.40,0.00,0.00,0.00,0.00,0.00),('21','237','3','25',1029,'60','1',434827.94,440470.76,5642.82,931065.30,0.00,0.00,0.00,0.00,0.00),('21','237','3','25',1030,'61','1',595055.38,598881.48,3826.10,631306.50,0.00,0.00,0.00,0.00,0.00),('21','237','4','25',1031,'62','1',210471.15,210471.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','25',1032,'63','1',526075.43,533067.78,6992.35,1153737.75,0.00,0.00,0.00,0.00,0.00),('21','237','4','25',1033,'64','1',402038.30,407770.69,5732.39,945844.35,0.00,0.00,0.00,0.00,0.00),('21','237','4','25',1034,'65','1',166039.27,167723.75,1684.48,277939.20,0.00,0.00,0.00,0.00,0.00),('21','237','1','26',1035,'1','1',1327622.72,1327622.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','26',1036,'3','1',799225.11,799225.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','26',1037,'5','1',641604.07,641604.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','26',1038,'7','1',1353461.29,1353461.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','26',1039,'9','1',674116.23,674116.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','26',1040,'11','1',512255.34,514071.29,1815.95,299631.75,0.00,0.00,0.00,0.00,0.00),('21','237','2','26',1041,'13','1',337390.82,338701.02,1310.20,216183.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','26',1042,'15','1',542850.94,543347.95,497.01,82006.65,0.00,0.00,0.00,0.00,0.00),('21','237','3','26',1043,'17','1',388141.18,389884.38,1743.20,287628.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','26',1044,'18','1',324582.87,324696.80,113.93,18798.45,0.00,0.00,0.00,0.00,0.00),('21','237','3','26',1045,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','26',1046,'23','1',411902.14,414792.42,2890.28,476896.20,0.00,0.00,0.00,0.00,0.00),('21','237','4','26',1047,'25','1',164886.25,170301.00,5414.75,893433.75,0.00,0.00,0.00,0.00,0.00),('21','237','4','26',1048,'27','1',188072.88,188072.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','26',1049,'29','1',169943.46,172462.53,2519.07,415646.55,0.00,0.00,0.00,0.00,0.00),('21','237','4','26',1050,'31','1',245266.94,249582.41,4315.47,712052.55,0.00,0.00,0.00,0.00,0.00),('21','237','5','26',1051,'33','2',3375771.93,3380589.52,4817.59,3083257.60,0.00,0.00,0.00,0.00,0.00),('21','237','5','26',1052,'35','2',3790428.81,3796296.49,5867.68,3755315.20,0.00,0.00,0.00,0.00,0.00),('21','237','5','26',1053,'42','2',2770773.30,2772453.30,1680.00,1075200.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','26',1054,'43','2',2793158.51,2800206.47,7047.96,4510694.40,0.00,0.00,0.00,0.00,0.00),('21','237','6','26',1055,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','26',1056,'45','2',1875632.52,1877839.96,2207.44,1412761.60,0.00,0.00,0.00,0.00,0.00),('21','237','6','26',1057,'46','2',4651892.21,4657945.70,6053.49,3874233.60,0.00,0.00,0.00,0.00,0.00),('21','237','6','26',1058,'47','2',3942181.43,3947238.22,5056.79,3236345.60,0.00,0.00,0.00,0.00,0.00),('21','237','7','26',1059,'48','2',2364575.35,2365789.91,1214.56,777318.40,0.00,0.00,0.00,0.00,0.00),('21','237','7','26',1060,'49','2',2684724.59,2690335.30,5610.71,3590854.40,0.00,0.00,0.00,0.00,0.00),('21','237','1','26',1061,'50','1',930440.31,930440.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','26',1062,'51','1',677761.57,677761.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','26',1063,'52','1',737085.23,737085.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','26',1064,'53','1',877698.34,877698.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','26',1065,'54','1',592739.98,592739.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','26',1066,'55','1',426701.34,427923.63,1222.29,201677.85,0.00,0.00,0.00,0.00,0.00),('21','237','2','26',1067,'56','1',351054.39,351054.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','26',1068,'57','1',696257.36,698257.24,1999.88,329980.20,0.00,0.00,0.00,0.00,0.00),('21','237','3','26',1069,'58','1',675971.98,678766.23,2794.25,461051.25,0.00,0.00,0.00,0.00,0.00),('21','237','3','26',1070,'59','1',321298.96,321435.32,136.36,22499.40,0.00,0.00,0.00,0.00,0.00),('21','237','3','26',1071,'60','1',440470.76,442357.18,1886.42,311259.30,0.00,0.00,0.00,0.00,0.00),('21','237','3','26',1072,'61','1',598881.48,601646.94,2765.46,456300.90,0.00,0.00,0.00,0.00,0.00),('21','237','4','26',1073,'62','1',210471.15,210471.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','26',1074,'63','1',533067.78,539654.29,6586.51,1086774.15,0.00,0.00,0.00,0.00,0.00),('21','237','4','26',1075,'64','1',407770.69,412918.18,5147.49,849335.85,0.00,0.00,0.00,0.00,0.00),('21','237','4','26',1076,'65','1',167723.75,170398.68,2674.93,441363.45,0.00,0.00,0.00,0.00,0.00),('21','237','1','27',1077,'1','1',1327622.72,1327622.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','27',1078,'3','1',799225.11,799225.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','27',1079,'5','1',641604.07,641604.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','27',1080,'7','1',1353461.29,1353461.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','27',1081,'9','1',674116.23,674116.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','27',1082,'11','1',514071.29,514071.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','27',1083,'13','1',338701.02,338701.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','27',1084,'15','1',543347.95,543347.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','27',1085,'17','1',389884.38,391086.46,1202.08,198343.20,0.00,0.00,0.00,0.00,0.00),('21','237','3','27',1086,'18','1',324696.80,325348.48,651.68,107527.20,0.00,0.00,0.00,0.00,0.00),('21','237','3','27',1087,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','27',1088,'23','1',414792.42,417602.05,2809.63,463588.95,0.00,0.00,0.00,0.00,0.00),('21','237','4','27',1089,'25','1',170301.00,171986.78,1685.78,278153.70,0.00,0.00,0.00,0.00,0.00),('21','237','4','27',1090,'27','1',188072.88,188072.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','27',1091,'29','1',172462.53,173418.94,956.41,157807.65,0.00,0.00,0.00,0.00,0.00),('21','237','4','27',1092,'31','1',249582.41,251640.17,2057.76,339530.40,0.00,0.00,0.00,0.00,0.00),('21','237','5','27',1093,'33','2',3380589.52,3384050.80,3461.28,2215219.20,0.00,0.00,0.00,0.00,0.00),('21','237','5','27',1094,'35','2',3796296.49,3800717.34,4420.85,2829344.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','27',1095,'42','2',2772453.30,2774776.74,2323.44,1487001.60,0.00,0.00,0.00,0.00,0.00),('21','237','5','27',1096,'43','2',2800206.47,2802661.60,2455.13,1571283.20,0.00,0.00,0.00,0.00,0.00),('21','237','6','27',1097,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','27',1098,'45','2',1877839.96,1880486.31,2646.35,1693664.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','27',1099,'46','2',4657945.70,4664892.78,6947.08,4446131.20,0.00,0.00,0.00,0.00,0.00),('21','237','6','27',1100,'47','2',3947238.22,3952577.36,5339.14,3417049.60,0.00,0.00,0.00,0.00,0.00),('21','237','7','27',1101,'48','2',2365789.91,2368220.26,2430.35,1555424.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','27',1102,'49','2',2690335.30,2694556.89,4221.59,2701817.60,0.00,0.00,0.00,0.00,0.00),('21','237','1','27',1103,'50','1',930440.31,930440.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','27',1104,'51','1',677761.57,677761.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','27',1105,'52','1',737085.23,737085.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','27',1106,'53','1',877698.34,877698.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','27',1107,'54','1',592739.98,592739.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','27',1108,'55','1',427923.63,427923.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','27',1109,'56','1',351054.39,351054.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','27',1110,'57','1',698257.24,698257.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','27',1111,'58','1',678766.23,683162.16,4395.93,725328.45,0.00,0.00,0.00,0.00,0.00),('21','237','3','27',1112,'59','1',321435.32,323530.03,2094.71,345627.15,0.00,0.00,0.00,0.00,0.00),('21','237','3','27',1113,'60','1',442357.18,442357.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','27',1114,'61','1',601646.94,604527.38,2880.44,475272.60,0.00,0.00,0.00,0.00,0.00),('21','237','4','27',1115,'62','1',210471.15,210471.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','27',1116,'63','1',539654.29,545457.34,5803.05,957503.25,0.00,0.00,0.00,0.00,0.00),('21','237','4','27',1117,'64','1',412918.18,415416.58,2498.40,412236.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','27',1118,'65','1',170398.68,174234.52,3835.84,632913.60,0.00,0.00,0.00,0.00,0.00),('21','237','1','28',1119,'1','1',1327622.72,1334135.23,6512.51,1074564.15,0.00,0.00,0.00,0.00,0.00),('21','237','1','28',1120,'3','1',799225.11,799225.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','28',1121,'5','1',641604.07,643363.80,1759.73,290355.45,0.00,0.00,0.00,0.00,0.00),('21','237','1','28',1122,'7','1',1353461.29,1357498.45,4037.16,666131.40,0.00,0.00,0.00,0.00,0.00),('21','237','2','28',1123,'9','1',674116.23,674856.76,740.53,122187.45,0.00,0.00,0.00,0.00,0.00),('21','237','2','28',1124,'11','1',514071.29,517317.85,3246.56,535682.40,0.00,0.00,0.00,0.00,0.00),('21','237','2','28',1125,'13','1',338701.02,340881.90,2180.88,359845.20,0.00,0.00,0.00,0.00,0.00),('21','237','2','28',1126,'15','1',543347.95,543347.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','28',1127,'17','1',391086.46,391086.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','28',1128,'18','1',325348.48,325348.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','28',1129,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','28',1130,'23','1',417602.05,417602.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','28',1131,'25','1',171986.78,177413.15,5426.37,895351.05,0.00,0.00,0.00,0.00,0.00),('21','237','4','28',1132,'27','1',188072.88,188072.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','28',1133,'29','1',173418.94,174713.08,1294.14,213533.10,0.00,0.00,0.00,0.00,0.00),('21','237','4','28',1134,'31','1',251640.17,252710.59,1070.42,176619.30,0.00,0.00,0.00,0.00,0.00),('21','237','5','28',1135,'33','2',3384050.80,3390240.65,6189.85,3961504.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','28',1136,'35','2',3800717.34,3808173.09,7455.75,4771680.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','28',1137,'42','2',2774776.74,2777541.82,2765.08,1769651.20,0.00,0.00,0.00,0.00,0.00),('21','237','5','28',1138,'43','2',2802661.60,2806335.32,3673.72,2351180.80,0.00,0.00,0.00,0.00,0.00),('21','237','6','28',1139,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','28',1140,'45','2',1880486.31,1881099.43,613.12,392396.80,0.00,0.00,0.00,0.00,0.00),('21','237','6','28',1141,'46','2',4664892.78,4670743.94,5851.16,3744742.40,0.00,0.00,0.00,0.00,0.00),('21','237','6','28',1142,'47','2',3952577.36,3956435.32,3857.96,2469094.40,0.00,0.00,0.00,0.00,0.00),('21','237','7','28',1143,'48','2',2368220.26,2371781.45,3561.19,2279161.60,0.00,0.00,0.00,0.00,0.00),('21','237','7','28',1144,'49','2',2694556.89,2700394.88,5837.99,3736313.60,0.00,0.00,0.00,0.00,0.00),('21','237','1','28',1145,'50','1',930440.31,930795.73,355.42,58644.30,0.00,0.00,0.00,0.00,0.00),('21','237','1','28',1146,'51','1',677761.57,677761.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','28',1147,'52','1',737085.23,740372.18,3286.95,542346.75,0.00,0.00,0.00,0.00,0.00),('21','237','1','28',1148,'53','1',877698.34,881315.85,3617.51,596889.15,0.00,0.00,0.00,0.00,0.00),('21','237','2','28',1149,'54','1',592739.98,592739.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','28',1150,'55','1',427923.63,428231.54,307.91,50805.15,0.00,0.00,0.00,0.00,0.00),('21','237','2','28',1151,'56','1',351054.39,354513.17,3458.78,570698.70,0.00,0.00,0.00,0.00,0.00),('21','237','2','28',1152,'57','1',698257.24,698257.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','28',1153,'58','1',683162.16,683162.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','28',1154,'59','1',323530.03,323530.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','28',1155,'60','1',442357.18,442357.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','28',1156,'61','1',604527.38,604527.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','28',1157,'62','1',210471.15,210471.56,0.41,67.65,0.00,0.00,0.00,0.00,0.00),('21','237','4','28',1158,'63','1',545457.34,549602.74,4145.40,683991.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','28',1159,'64','1',415416.58,420389.63,4973.05,820553.25,0.00,0.00,0.00,0.00,0.00),('21','237','4','28',1160,'65','1',174234.52,175936.20,1701.68,280777.20,0.00,0.00,0.00,0.00,0.00),('21','237','1','29',1161,'1','1',1334135.23,1337868.98,3733.75,616068.75,0.00,0.00,0.00,0.00,0.00),('21','237','1','29',1162,'3','1',799225.11,799225.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','29',1163,'5','1',643363.80,643764.66,400.86,66141.90,0.00,0.00,0.00,0.00,0.00),('21','237','1','29',1164,'7','1',1357498.45,1359985.67,2487.22,410391.30,0.00,0.00,0.00,0.00,0.00),('21','237','2','29',1165,'9','1',674856.76,677713.38,2856.62,471342.30,0.00,0.00,0.00,0.00,0.00),('21','237','2','29',1166,'11','1',517317.85,521882.94,4565.09,753239.85,0.00,0.00,0.00,0.00,0.00),('21','237','2','29',1167,'13','1',340881.90,342173.18,1291.28,213061.20,0.00,0.00,0.00,0.00,0.00),('21','237','2','29',1168,'15','1',543347.95,544232.05,884.10,145876.50,0.00,0.00,0.00,0.00,0.00),('21','237','3','29',1169,'17','1',391086.46,391086.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','29',1170,'18','1',325348.48,325348.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','29',1171,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','29',1172,'23','1',417602.05,417602.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','29',1173,'25','1',177413.15,180816.52,3403.37,561556.05,0.00,0.00,0.00,0.00,0.00),('21','237','4','29',1174,'27','1',188072.88,188072.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','29',1175,'29','1',174713.08,174730.05,16.97,2800.05,0.00,0.00,0.00,0.00,0.00),('21','237','4','29',1176,'31','1',252710.59,252710.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','29',1177,'33','2',3390240.65,3394621.19,4380.54,2803545.60,0.00,0.00,0.00,0.00,0.00),('21','237','5','29',1178,'35','2',3808173.09,3815047.72,6874.63,4399763.20,0.00,0.00,0.00,0.00,0.00),('21','237','5','29',1179,'42','2',2777541.82,2780892.14,3350.32,2144204.80,0.00,0.00,0.00,0.00,0.00),('21','237','5','29',1180,'43','2',2806335.32,2813038.76,6703.44,4290201.60,0.00,0.00,0.00,0.00,0.00),('21','237','6','29',1181,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','29',1182,'45','2',1881099.43,1883059.43,1960.00,1254400.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','29',1183,'46','2',4670743.94,4678212.29,7468.35,4779744.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','29',1184,'47','2',3956435.32,3963375.51,6940.19,4441721.60,0.00,0.00,0.00,0.00,0.00),('21','237','7','29',1185,'48','2',2371781.45,2374964.00,3182.55,2036832.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','29',1186,'49','2',2700394.88,2703351.43,2956.55,1892192.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','29',1187,'50','1',930795.73,930795.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','29',1188,'51','1',677761.57,677761.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','29',1189,'52','1',740372.18,744578.07,4205.89,693971.85,0.00,0.00,0.00,0.00,0.00),('21','237','1','29',1190,'53','1',881315.85,885268.12,3952.27,652124.55,0.00,0.00,0.00,0.00,0.00),('21','237','2','29',1191,'54','1',592739.98,593496.82,756.84,124878.60,0.00,0.00,0.00,0.00,0.00),('21','237','2','29',1192,'55','1',428231.54,430641.92,2410.38,397712.70,0.00,0.00,0.00,0.00,0.00),('21','237','2','29',1193,'56','1',354513.17,357713.92,3200.75,528123.75,0.00,0.00,0.00,0.00,0.00),('21','237','2','29',1194,'57','1',698257.24,700404.18,2146.94,354245.10,0.00,0.00,0.00,0.00,0.00),('21','237','3','29',1195,'58','1',683162.16,683162.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','29',1196,'59','1',323530.03,323530.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','29',1197,'60','1',442357.18,442357.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','29',1198,'61','1',604527.38,604527.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','29',1199,'62','1',210471.56,210471.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','29',1200,'63','1',549602.74,553960.56,4357.82,719040.30,0.00,0.00,0.00,0.00,0.00),('21','237','4','29',1201,'64','1',420389.63,425897.28,5507.65,908762.25,0.00,0.00,0.00,0.00,0.00),('21','237','4','29',1202,'65','1',175936.20,180163.34,4227.14,697478.10,0.00,0.00,0.00,0.00,0.00),('21','237','1','30',1203,'1','1',1337868.98,1339534.56,1665.58,274820.70,0.00,0.00,0.00,0.00,0.00),('21','237','1','30',1204,'3','1',799225.11,799232.25,7.14,1178.10,0.00,0.00,0.00,0.00,0.00),('21','237','1','30',1205,'5','1',643764.66,643764.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','30',1206,'7','1',1359985.67,1361683.42,1697.75,280128.75,0.00,0.00,0.00,0.00,0.00),('21','237','2','30',1207,'9','1',677713.38,682263.68,4550.30,750799.01,0.00,0.00,0.00,0.00,0.00),('21','237','2','30',1208,'11','1',521882.94,521882.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','30',1209,'13','1',342173.18,343382.60,1209.42,199554.30,0.00,0.00,0.00,0.00,0.00),('21','237','2','30',1210,'15','1',544232.05,546362.12,2130.07,351461.55,0.00,0.00,0.00,0.00,0.00),('21','237','3','30',1211,'17','1',391086.46,391510.64,424.18,69989.70,0.00,0.00,0.00,0.00,0.00),('21','237','3','30',1212,'18','1',325348.48,325910.43,561.95,92721.75,0.00,0.00,0.00,0.00,0.00),('21','237','3','30',1213,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','30',1214,'23','1',417602.05,419146.70,1544.65,254867.25,0.00,0.00,0.00,0.00,0.00),('21','237','4','30',1215,'25','1',180816.52,180816.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','30',1216,'27','1',188072.88,188072.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','30',1217,'29','1',174730.05,174730.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','30',1218,'31','1',252710.59,253621.76,911.17,150343.05,0.00,0.00,0.00,0.00,0.00),('21','237','5','30',1219,'33','2',3394621.19,3398787.17,4165.98,2666227.20,0.00,0.00,0.00,0.00,0.00),('21','237','5','30',1220,'35','2',3815047.72,3819600.01,4552.29,2913465.60,0.00,0.00,0.00,0.00,0.00),('21','237','5','30',1221,'42','2',2780892.14,2786958.53,6066.39,3882489.60,0.00,0.00,0.00,0.00,0.00),('21','237','5','30',1222,'43','2',2813038.76,2819412.69,6373.93,4079315.20,0.00,0.00,0.00,0.00,0.00),('21','237','6','30',1223,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','30',1224,'45','2',1883059.43,1887537.95,4478.52,2866252.80,0.00,0.00,0.00,0.00,0.00),('21','237','6','30',1225,'46','2',4678212.29,4685462.80,7250.51,4640326.40,0.00,0.00,0.00,0.00,0.00),('21','237','6','30',1226,'47','2',3963375.51,3970684.99,7309.48,4678067.20,0.00,0.00,0.00,0.00,0.00),('21','237','7','30',1227,'48','2',2374964.00,2379487.14,4523.14,2894809.60,0.00,0.00,0.00,0.00,0.00),('21','237','7','30',1228,'49','2',2703351.43,2711209.14,7857.71,5028934.40,0.00,0.00,0.00,0.00,0.00),('21','237','1','30',1229,'50','1',930795.73,932452.32,1656.59,273337.35,0.00,0.00,0.00,0.00,0.00),('21','237','1','30',1230,'51','1',677761.57,677792.88,31.31,5166.15,0.00,0.00,0.00,0.00,0.00),('21','237','1','30',1231,'52','1',744578.07,747031.50,2453.43,404815.95,0.00,0.00,0.00,0.00,0.00),('21','237','1','30',1232,'53','1',885268.12,886226.39,958.27,158114.55,0.00,0.00,0.00,0.00,0.00),('21','237','2','30',1233,'54','1',593496.82,595040.12,1543.30,254644.50,0.00,0.00,0.00,0.00,0.00),('21','237','2','30',1234,'55','1',430641.92,430641.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','30',1235,'56','1',357713.92,359170.21,1456.29,240287.85,0.00,0.00,0.00,0.00,0.00),('21','237','2','30',1236,'57','1',700404.18,702948.10,2543.92,419746.80,0.00,0.00,0.00,0.00,0.00),('21','237','3','30',1237,'58','1',683162.16,686297.82,3135.66,517383.90,0.00,0.00,0.00,0.00,0.00),('21','237','3','30',1238,'59','1',323530.03,324722.71,1192.68,196792.20,0.00,0.00,0.00,0.00,0.00),('21','237','3','30',1239,'60','1',442357.18,444779.61,2422.43,399700.95,0.00,0.00,0.00,0.00,0.00),('21','237','3','30',1240,'61','1',604527.38,607022.84,2495.46,411750.90,0.00,0.00,0.00,0.00,0.00),('21','237','4','30',1241,'62','1',210471.56,210471.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','30',1242,'63','1',553960.56,558377.64,4417.08,728818.20,0.00,0.00,0.00,0.00,0.00),('21','237','4','30',1243,'64','1',425897.28,430165.66,4268.38,704282.70,0.00,0.00,0.00,0.00,0.00),('21','237','4','30',1244,'65','1',180163.34,182050.20,1886.86,311331.90,0.00,0.00,0.00,0.00,0.00),('21','237','1','31',1245,'1','1',1339534.56,1339534.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','31',1246,'3','1',799232.25,799232.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','31',1247,'5','1',643764.66,643764.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','31',1248,'7','1',1361683.42,1361683.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','31',1249,'9','1',682263.68,682263.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','31',1250,'11','1',521882.94,521882.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','31',1251,'13','1',343382.60,343382.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','31',1252,'15','1',546362.12,546362.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','31',1253,'17','1',391510.64,391510.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','31',1254,'18','1',325910.43,325910.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','31',1255,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','31',1256,'23','1',419146.70,419146.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','31',1257,'25','1',180816.52,180816.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','31',1258,'27','1',188072.88,188072.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','31',1259,'29','1',174730.05,174730.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','31',1260,'31','1',253621.76,253621.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','31',1261,'33','2',3398787.17,3398787.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','31',1262,'35','2',3819600.01,3819600.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','31',1263,'42','2',2786958.53,2786958.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','31',1264,'43','2',2819412.69,2819412.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','31',1265,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','31',1266,'45','2',1887537.95,1887537.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','31',1267,'46','2',4685462.80,4685462.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','31',1268,'47','2',3970684.99,3970684.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','31',1269,'48','2',2379487.14,2379487.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','31',1270,'49','2',2711209.14,2711209.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','31',1271,'50','1',932452.32,932452.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','31',1272,'51','1',677792.88,677792.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','31',1273,'52','1',747031.50,747031.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','31',1274,'53','1',886226.39,886226.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','31',1275,'54','1',595040.12,595040.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','31',1276,'55','1',430641.92,430641.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','31',1277,'56','1',359170.21,359170.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','31',1278,'57','1',702948.10,702948.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','31',1279,'58','1',686297.82,686297.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','31',1280,'59','1',324722.71,324722.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','31',1281,'60','1',444779.61,444779.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','31',1282,'61','1',607022.84,607022.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','31',1283,'62','1',210471.56,210471.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','31',1284,'63','1',558377.64,558377.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','31',1285,'64','1',430165.66,430165.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','31',1286,'65','1',182050.20,182050.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','32',1287,'1','1',1339534.56,1342369.38,2834.82,467745.30,0.00,0.00,0.00,0.00,0.00),('21','237','1','32',1288,'3','1',799232.25,801904.62,2672.37,440941.05,0.00,0.00,0.00,0.00,0.00),('21','237','1','32',1289,'5','1',643764.66,643764.82,0.16,26.40,0.00,0.00,0.00,0.00,0.00),('21','237','1','32',1290,'7','1',1361683.42,1364007.61,2324.19,383491.35,0.00,0.00,0.00,0.00,0.00),('21','237','2','32',1291,'9','1',682263.68,683743.22,1479.54,244124.10,0.00,0.00,0.00,0.00,0.00),('21','237','2','32',1292,'11','1',521882.94,523578.79,1695.85,279815.25,0.00,0.00,0.00,0.00,0.00),('21','237','2','32',1293,'13','1',343382.60,343648.44,265.84,43863.60,0.00,0.00,0.00,0.00,0.00),('21','237','2','32',1294,'15','1',546362.12,547862.70,1500.58,247595.70,0.00,0.00,0.00,0.00,0.00),('21','237','3','32',1295,'17','1',391510.64,391964.62,453.98,74906.70,0.00,0.00,0.00,0.00,0.00),('21','237','3','32',1296,'18','1',325910.43,326449.76,539.33,88989.45,0.00,0.00,0.00,0.00,0.00),('21','237','3','32',1297,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','32',1298,'23','1',419146.70,420806.56,1659.86,273876.90,0.00,0.00,0.00,0.00,0.00),('21','237','4','32',1299,'25','1',180816.52,182727.99,1911.47,315392.55,0.00,0.00,0.00,0.00,0.00),('21','237','4','32',1300,'27','1',188072.88,188072.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','32',1301,'29','1',174730.05,174871.82,141.77,23392.05,0.00,0.00,0.00,0.00,0.00),('21','237','4','32',1302,'31','1',253621.76,253621.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','32',1303,'33','2',3398787.17,3401878.87,3091.70,1978688.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','32',1304,'35','2',3819600.01,3826280.18,6680.17,4275308.80,0.00,0.00,0.00,0.00,0.00),('21','237','5','32',1305,'42','2',2786958.53,2790687.85,3729.32,2386764.80,0.00,0.00,0.00,0.00,0.00),('21','237','5','32',1306,'43','2',2819412.69,2826678.30,7265.61,4649990.40,0.00,0.00,0.00,0.00,0.00),('21','237','6','32',1307,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','32',1308,'45','2',1887537.95,1892235.15,4697.20,3006208.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','32',1309,'46','2',4685462.80,4693758.48,8295.68,5309235.20,0.00,0.00,0.00,0.00,0.00),('21','237','6','32',1310,'47','2',3970684.99,3975589.60,4904.61,3138950.40,0.00,0.00,0.00,0.00,0.00),('21','237','7','32',1311,'48','2',2379487.14,2384069.81,4582.67,2932908.80,0.00,0.00,0.00,0.00,0.00),('21','237','7','32',1312,'49','2',2711209.14,2716215.37,5006.23,3203987.20,0.00,0.00,0.00,0.00,0.00),('21','237','1','32',1313,'50','1',932452.32,934020.90,1568.58,258815.70,0.00,0.00,0.00,0.00,0.00),('21','237','1','32',1314,'51','1',677792.88,677792.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','32',1315,'52','1',747031.50,748838.15,1806.65,298097.25,0.00,0.00,0.00,0.00,0.00),('21','237','1','32',1316,'53','1',886226.39,889402.25,3175.86,524016.90,0.00,0.00,0.00,0.00,0.00),('21','237','2','32',1317,'54','1',595040.12,595649.88,609.76,100610.40,0.00,0.00,0.00,0.00,0.00),('21','237','2','32',1318,'55','1',430641.92,431613.96,972.04,160386.60,0.00,0.00,0.00,0.00,0.00),('21','237','2','32',1319,'56','1',359170.21,360954.39,1784.18,294389.70,0.00,0.00,0.00,0.00,0.00),('21','237','2','32',1320,'57','1',702948.10,704682.63,1734.53,286197.45,0.00,0.00,0.00,0.00,0.00),('21','237','3','32',1321,'58','1',686297.82,688982.54,2684.72,442978.80,0.00,0.00,0.00,0.00,0.00),('21','237','3','32',1322,'59','1',324722.71,325936.85,1214.14,200333.10,0.00,0.00,0.00,0.00,0.00),('21','237','3','32',1323,'60','1',444779.61,446419.30,1639.69,270548.85,0.00,0.00,0.00,0.00,0.00),('21','237','3','32',1324,'61','1',607022.84,608444.11,1421.27,234509.55,0.00,0.00,0.00,0.00,0.00),('21','237','4','32',1325,'62','1',210471.56,210471.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','32',1326,'63','1',558377.64,561620.85,3243.21,535129.65,0.00,0.00,0.00,0.00,0.00),('21','237','4','32',1327,'64','1',430165.66,435691.54,5525.88,911770.20,0.00,0.00,0.00,0.00,0.00),('21','237','4','32',1328,'65','1',182050.20,184459.06,2408.86,397461.90,0.00,0.00,0.00,0.00,0.00),('21','237','1','33',1329,'1','1',1342369.38,1344015.35,1645.97,271585.05,0.00,0.00,0.00,0.00,0.00),('21','237','1','33',1330,'3','1',801904.62,807759.72,5855.10,966091.50,0.00,0.00,0.00,0.00,0.00),('21','237','1','33',1331,'5','1',643764.82,643796.70,31.88,5260.20,0.00,0.00,0.00,0.00,0.00),('21','237','1','33',1332,'7','1',1364007.61,1366043.93,2036.32,335992.80,0.00,0.00,0.00,0.00,0.00),('21','237','2','33',1333,'9','1',683743.22,686794.10,3050.88,503395.20,0.00,0.00,0.00,0.00,0.00),('21','237','2','33',1334,'11','1',523578.79,524039.70,460.91,76050.15,0.00,0.00,0.00,0.00,0.00),('21','237','2','33',1335,'13','1',343648.44,345511.23,1862.79,307360.35,0.00,0.00,0.00,0.00,0.00),('21','237','2','33',1336,'15','1',547862.70,548828.21,965.51,159309.15,0.00,0.00,0.00,0.00,0.00),('21','237','3','33',1337,'17','1',391964.62,393013.85,1049.23,173122.95,0.00,0.00,0.00,0.00,0.00),('21','237','3','33',1338,'18','1',326449.76,326449.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','33',1339,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','33',1340,'23','1',420806.56,422346.04,1539.48,254014.20,0.00,0.00,0.00,0.00,0.00),('21','237','4','33',1341,'25','1',182727.99,182727.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','33',1342,'27','1',188072.88,188072.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','33',1343,'29','1',174871.82,174871.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','33',1344,'31','1',253621.76,256196.87,2575.11,424893.15,0.00,0.00,0.00,0.00,0.00),('21','237','5','33',1345,'33','2',3401878.87,3405277.57,3398.70,2175168.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','33',1346,'35','2',3826280.18,3833897.06,7616.88,4874803.20,0.00,0.00,0.00,0.00,0.00),('21','237','5','33',1347,'42','2',2790687.85,2794794.96,4107.11,2628550.40,0.00,0.00,0.00,0.00,0.00),('21','237','5','33',1348,'43','2',2826678.30,2833256.32,6578.02,4209932.80,0.00,0.00,0.00,0.00,0.00),('21','237','6','33',1349,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','33',1350,'45','2',1892235.15,1897181.36,4946.21,3165574.40,0.00,0.00,0.00,0.00,0.00),('21','237','6','33',1351,'46','2',4693758.48,4699327.95,5569.47,3564460.80,0.00,0.00,0.00,0.00,0.00),('21','237','6','33',1352,'47','2',3975589.60,3981086.35,5496.75,3517920.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','33',1353,'48','2',2384069.81,2389678.15,5608.34,3589337.60,0.00,0.00,0.00,0.00,0.00),('21','237','7','33',1354,'49','2',2716215.37,2720679.94,4464.57,2857324.80,0.00,0.00,0.00,0.00,0.00),('21','237','1','33',1355,'50','1',934020.90,935168.14,1147.24,189294.60,0.00,0.00,0.00,0.00,0.00),('21','237','1','33',1356,'51','1',677792.88,677794.37,1.49,245.85,0.00,0.00,0.00,0.00,0.00),('21','237','1','33',1357,'52','1',748838.15,753708.39,4870.24,803589.60,0.00,0.00,0.00,0.00,0.00),('21','237','1','33',1358,'53','1',889402.25,890479.19,1076.94,177695.10,0.00,0.00,0.00,0.00,0.00),('21','237','2','33',1359,'54','1',595649.88,596482.62,832.74,137402.10,0.00,0.00,0.00,0.00,0.00),('21','237','2','33',1360,'55','1',431613.96,432416.93,802.97,132490.05,0.00,0.00,0.00,0.00,0.00),('21','237','2','33',1361,'56','1',360954.39,362759.46,1805.07,297836.55,0.00,0.00,0.00,0.00,0.00),('21','237','2','33',1362,'57','1',704682.63,705961.31,1278.68,210982.20,0.00,0.00,0.00,0.00,0.00),('21','237','3','33',1363,'58','1',688982.54,691846.31,2863.77,472522.05,0.00,0.00,0.00,0.00,0.00),('21','237','3','33',1364,'59','1',325936.85,325936.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','33',1365,'60','1',446419.30,446419.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','33',1366,'61','1',608444.11,609824.89,1380.78,227828.70,0.00,0.00,0.00,0.00,0.00),('21','237','4','33',1367,'62','1',210471.56,210471.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','33',1368,'63','1',561620.85,565576.47,3955.62,652677.30,0.00,0.00,0.00,0.00,0.00),('21','237','4','33',1369,'64','1',435691.54,440329.72,4638.18,765299.70,0.00,0.00,0.00,0.00,0.00),('21','237','4','33',1370,'65','1',184459.06,186097.87,1638.81,270403.65,0.00,0.00,0.00,0.00,0.00),('21','237','1','34',1371,'1','1',1344015.35,1345845.76,1830.41,302017.65,0.00,0.00,0.00,0.00,0.00),('21','237','1','34',1372,'3','1',807759.72,808631.81,872.09,143894.85,0.00,0.00,0.00,0.00,0.00),('21','237','1','34',1373,'5','1',643796.70,643796.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','34',1374,'7','1',1366043.93,1368860.83,2816.90,464788.50,0.00,0.00,0.00,0.00,0.00),('21','237','2','34',1375,'9','1',686794.10,690942.24,4148.14,684443.10,0.00,0.00,0.00,0.00,0.00),('21','237','2','34',1376,'11','1',524039.70,525279.37,1239.67,204545.55,0.00,0.00,0.00,0.00,0.00),('21','237','2','34',1377,'13','1',345511.23,346667.68,1156.45,190814.25,0.00,0.00,0.00,0.00,0.00),('21','237','2','34',1378,'15','1',548828.21,550187.09,1358.88,224215.20,0.00,0.00,0.00,0.00,0.00),('21','237','3','34',1379,'17','1',393013.85,393727.60,713.75,117768.75,0.00,0.00,0.00,0.00,0.00),('21','237','3','34',1380,'18','1',326449.76,326449.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','34',1381,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','34',1382,'23','1',422346.04,423335.49,989.45,163259.25,0.00,0.00,0.00,0.00,0.00),('21','237','4','34',1383,'25','1',182727.99,184037.56,1309.57,216079.05,0.00,0.00,0.00,0.00,0.00),('21','237','4','34',1384,'27','1',188072.88,188072.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','34',1385,'29','1',174871.82,174871.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','34',1386,'31','1',256196.87,257851.54,1654.67,273020.55,0.00,0.00,0.00,0.00,0.00),('21','237','5','34',1387,'33','2',3405277.57,3409359.12,4081.55,2612192.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','34',1388,'35','2',3833897.06,3843088.30,9191.24,5882393.60,0.00,0.00,0.00,0.00,0.00),('21','237','5','34',1389,'42','2',2794794.96,2800535.00,5740.04,3673625.60,0.00,0.00,0.00,0.00,0.00),('21','237','5','34',1390,'43','2',2833256.32,2838785.78,5529.46,3538854.40,0.00,0.00,0.00,0.00,0.00),('21','237','6','34',1391,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','34',1392,'45','2',1897181.36,1902095.70,4914.34,3145177.60,0.00,0.00,0.00,0.00,0.00),('21','237','6','34',1393,'46','2',4699327.95,4709297.49,9969.54,6380505.60,0.00,0.00,0.00,0.00,0.00),('21','237','6','34',1394,'47','2',3981086.35,3987266.19,6179.84,3955097.60,0.00,0.00,0.00,0.00,0.00),('21','237','7','34',1395,'48','2',2389678.15,2394093.03,4414.88,2825523.20,0.00,0.00,0.00,0.00,0.00),('21','237','7','34',1396,'49','2',2720679.94,2723818.85,3138.91,2008902.40,0.00,0.00,0.00,0.00,0.00),('21','237','1','34',1397,'50','1',935168.14,937482.59,2314.45,381884.25,0.00,0.00,0.00,0.00,0.00),('21','237','1','34',1398,'51','1',677794.37,677794.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','34',1399,'52','1',753708.39,754148.98,440.59,72697.35,0.00,0.00,0.00,0.00,0.00),('21','237','1','34',1400,'53','1',890479.19,894006.36,3527.17,581983.05,0.00,0.00,0.00,0.00,0.00),('21','237','2','34',1401,'54','1',596482.62,598424.80,1942.18,320459.70,0.00,0.00,0.00,0.00,0.00),('21','237','2','34',1402,'55','1',432416.93,433068.61,651.68,107527.20,0.00,0.00,0.00,0.00,0.00),('21','237','2','34',1403,'56','1',362759.46,364964.89,2205.43,363895.95,0.00,0.00,0.00,0.00,0.00),('21','237','2','34',1404,'57','1',705961.31,709733.25,3771.94,622370.10,0.00,0.00,0.00,0.00,0.00),('21','237','3','34',1405,'58','1',691846.31,695566.39,3720.08,613813.20,0.00,0.00,0.00,0.00,0.00),('21','237','3','34',1406,'59','1',325936.85,325936.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','34',1407,'60','1',446419.30,446419.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','34',1408,'61','1',609824.89,612038.79,2213.90,365293.50,0.00,0.00,0.00,0.00,0.00),('21','237','4','34',1409,'62','1',210471.56,210471.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','34',1410,'63','1',565576.47,568396.36,2819.89,465281.85,0.00,0.00,0.00,0.00,0.00),('21','237','4','34',1411,'64','1',440329.72,443788.35,3458.63,570673.95,0.00,0.00,0.00,0.00,0.00),('21','237','4','34',1412,'65','1',186097.87,189240.24,3142.37,518491.05,0.00,0.00,0.00,0.00,0.00),('21','237','1','35',1413,'1','1',1345845.76,1347382.96,1537.20,253638.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','35',1414,'3','1',808631.81,808631.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','35',1415,'5','1',643796.70,643796.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','35',1416,'7','1',1368860.83,1372252.60,3391.77,559642.05,0.00,0.00,0.00,0.00,0.00),('21','237','2','35',1417,'9','1',690942.24,693020.54,2078.30,342919.50,0.00,0.00,0.00,0.00,0.00),('21','237','2','35',1418,'11','1',525279.37,527928.64,2649.27,437129.55,0.00,0.00,0.00,0.00,0.00),('21','237','2','35',1419,'13','1',346667.68,347163.56,495.88,81820.20,0.00,0.00,0.00,0.00,0.00),('21','237','2','35',1420,'15','1',550187.09,550935.04,747.95,123411.75,0.00,0.00,0.00,0.00,0.00),('21','237','3','35',1421,'17','1',393727.60,393727.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','35',1422,'18','1',326449.76,326449.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','35',1423,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','35',1424,'23','1',423335.49,423335.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','35',1425,'25','1',184037.56,184037.63,0.07,11.55,0.00,0.00,0.00,0.00,0.00),('21','237','4','35',1426,'27','1',188072.88,188072.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','35',1427,'29','1',174871.82,174871.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','35',1428,'31','1',257851.54,257851.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','35',1429,'33','2',3409359.12,3413189.66,3830.54,2451545.60,0.00,0.00,0.00,0.00,0.00),('21','237','5','35',1430,'35','2',3843088.30,3851144.19,8055.89,5155769.60,0.00,0.00,0.00,0.00,0.00),('21','237','5','35',1431,'42','2',2800535.00,2802125.97,1590.97,1018220.80,0.00,0.00,0.00,0.00,0.00),('21','237','5','35',1432,'43','2',2838785.78,2844109.52,5323.74,3407193.60,0.00,0.00,0.00,0.00,0.00),('21','237','6','35',1433,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','35',1434,'45','2',1902095.70,1903520.71,1425.01,912006.40,0.00,0.00,0.00,0.00,0.00),('21','237','6','35',1435,'46','2',4709297.49,4716364.09,7066.60,4522624.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','35',1436,'47','2',3987266.19,3992060.00,4793.81,3068038.40,0.00,0.00,0.00,0.00,0.00),('21','237','7','35',1437,'48','2',2394093.03,2401847.95,7754.92,4963148.80,0.00,0.00,0.00,0.00,0.00),('21','237','7','35',1438,'49','2',2723818.85,2723829.70,10.85,6944.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','35',1439,'50','1',937482.59,939334.27,1851.68,305527.20,0.00,0.00,0.00,0.00,0.00),('21','237','1','35',1440,'51','1',677794.37,677794.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','35',1441,'52','1',754148.98,754148.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','35',1442,'53','1',894006.36,896793.71,2787.35,459912.75,0.00,0.00,0.00,0.00,0.00),('21','237','2','35',1443,'54','1',598424.80,599887.45,1462.65,241337.25,0.00,0.00,0.00,0.00,0.00),('21','237','2','35',1444,'55','1',433068.61,434104.38,1035.77,170902.05,0.00,0.00,0.00,0.00,0.00),('21','237','2','35',1445,'56','1',364964.89,367031.57,2066.68,341002.20,0.00,0.00,0.00,0.00,0.00),('21','237','2','35',1446,'57','1',709733.25,711492.26,1759.01,290236.65,0.00,0.00,0.00,0.00,0.00),('21','237','3','35',1447,'58','1',695566.39,697400.75,1834.36,302669.40,0.00,0.00,0.00,0.00,0.00),('21','237','3','35',1448,'59','1',325936.85,326148.58,211.73,34935.45,0.00,0.00,0.00,0.00,0.00),('21','237','3','35',1449,'60','1',446419.30,448649.58,2230.28,367996.20,0.00,0.00,0.00,0.00,0.00),('21','237','3','35',1450,'61','1',612038.79,614046.91,2008.12,331339.80,0.00,0.00,0.00,0.00,0.00),('21','237','4','35',1451,'62','1',210471.56,210471.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','35',1452,'63','1',568396.36,571712.43,3316.07,547151.55,0.00,0.00,0.00,0.00,0.00),('21','237','4','35',1453,'64','1',443788.35,446402.41,2614.06,431319.90,0.00,0.00,0.00,0.00,0.00),('21','237','4','35',1454,'65','1',189240.24,190123.93,883.69,145808.85,0.00,0.00,0.00,0.00,0.00),('21','237','1','36',1455,'1','1',1347382.96,1349007.98,1625.02,268128.30,0.00,0.00,0.00,0.00,0.00),('21','237','1','36',1456,'3','1',808631.81,809932.45,1300.64,214605.60,0.00,0.00,0.00,0.00,0.00),('21','237','1','36',1457,'5','1',643796.70,643799.73,3.03,499.95,0.00,0.00,0.00,0.00,0.00),('21','237','1','36',1458,'7','1',1372252.60,1375504.46,3251.86,536556.90,0.00,0.00,0.00,0.00,0.00),('21','237','2','36',1459,'9','1',693020.54,696568.95,3548.41,585487.65,0.00,0.00,0.00,0.00,0.00),('21','237','2','36',1460,'11','1',527928.64,529310.88,1382.24,228069.60,0.00,0.00,0.00,0.00,0.00),('21','237','2','36',1461,'13','1',347163.56,347442.82,279.26,46077.90,0.00,0.00,0.00,0.00,0.00),('21','237','2','36',1462,'15','1',550935.04,552979.84,2044.80,337392.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','36',1463,'17','1',393727.60,393727.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','36',1464,'18','1',326449.76,327570.67,1120.91,184950.15,0.00,0.00,0.00,0.00,0.00),('21','237','3','36',1465,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','36',1466,'23','1',423335.49,423335.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','36',1467,'25','1',184037.63,185417.13,1379.50,227617.50,0.00,0.00,0.00,0.00,0.00),('21','237','4','36',1468,'27','1',188072.88,188072.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','36',1469,'29','1',174871.82,175369.17,497.35,82062.75,0.00,0.00,0.00,0.00,0.00),('21','237','4','36',1470,'31','1',257851.54,259535.01,1683.47,277772.55,0.00,0.00,0.00,0.00,0.00),('21','237','5','36',1471,'33','2',3413189.66,3415655.16,2465.50,1577920.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','36',1472,'35','2',3851144.19,3857709.99,6565.80,4202112.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','36',1473,'42','2',2802125.97,2806997.78,4871.81,3117958.40,0.00,0.00,0.00,0.00,0.00),('21','237','5','36',1474,'43','2',2844109.52,2846108.63,1999.11,1279430.40,0.00,0.00,0.00,0.00,0.00),('21','237','6','36',1475,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','36',1476,'45','2',1903520.71,1905846.90,2326.19,1488761.60,0.00,0.00,0.00,0.00,0.00),('21','237','6','36',1477,'46','2',4716364.09,4722782.97,6418.88,4108083.20,0.00,0.00,0.00,0.00,0.00),('21','237','6','36',1478,'47','2',3992060.00,3996885.31,4825.31,3088198.40,0.00,0.00,0.00,0.00,0.00),('21','237','7','36',1479,'48','2',2401847.95,2405881.08,4033.13,2581203.20,0.00,0.00,0.00,0.00,0.00),('21','237','7','36',1480,'49','2',2723829.70,2726250.19,2420.49,1549113.60,0.00,0.00,0.00,0.00,0.00),('21','237','1','36',1481,'50','1',939334.27,941001.72,1667.45,275129.25,0.00,0.00,0.00,0.00,0.00),('21','237','1','36',1482,'51','1',677794.37,677849.19,54.82,9045.30,0.00,0.00,0.00,0.00,0.00),('21','237','1','36',1483,'52','1',754148.98,755838.46,1689.48,278764.20,0.00,0.00,0.00,0.00,0.00),('21','237','1','36',1484,'53','1',896793.71,899555.48,2761.77,455692.05,0.00,0.00,0.00,0.00,0.00),('21','237','2','36',1485,'54','1',599887.45,601299.71,1412.26,233022.90,0.00,0.00,0.00,0.00,0.00),('21','237','2','36',1486,'55','1',434104.38,435218.24,1113.86,183786.90,0.00,0.00,0.00,0.00,0.00),('21','237','2','36',1487,'56','1',367031.57,367711.44,679.87,112178.55,0.00,0.00,0.00,0.00,0.00),('21','237','2','36',1488,'57','1',711492.26,713620.84,2128.58,351215.70,0.00,0.00,0.00,0.00,0.00),('21','237','3','36',1489,'58','1',697400.75,701724.66,4323.91,713445.15,0.00,0.00,0.00,0.00,0.00),('21','237','3','36',1490,'59','1',326148.58,326148.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','36',1491,'60','1',448649.58,448649.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','36',1492,'61','1',614046.91,616240.34,2193.43,361915.95,0.00,0.00,0.00,0.00,0.00),('21','237','4','36',1493,'62','1',210471.56,210471.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','36',1494,'63','1',571712.43,574673.13,2960.70,488515.50,0.00,0.00,0.00,0.00,0.00),('21','237','4','36',1495,'64','1',446402.41,449154.29,2751.88,454060.20,0.00,0.00,0.00,0.00,0.00),('21','237','4','36',1496,'65','1',190123.93,193116.54,2992.61,493780.65,0.00,0.00,0.00,0.00,0.00),('21','237','1','37',1497,'1','1',1349007.98,1349007.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','37',1498,'3','1',809932.45,809932.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','37',1499,'5','1',643799.73,643799.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','37',1500,'7','1',1375504.46,1375504.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','37',1501,'9','1',696568.95,696568.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','37',1502,'11','1',529310.88,529310.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','37',1503,'13','1',347442.82,347442.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','37',1504,'15','1',552979.84,552979.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','37',1505,'17','1',393727.60,393727.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','37',1506,'18','1',327570.67,327570.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','37',1507,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','37',1508,'23','1',423335.49,423335.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','37',1509,'25','1',185417.13,185417.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','37',1510,'27','1',188072.88,188072.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','37',1511,'29','1',175369.17,175369.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','37',1512,'31','1',259535.01,259535.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','37',1513,'33','2',3415655.16,3415655.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','37',1514,'35','2',3857709.99,3857709.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','37',1515,'42','2',2806997.78,2806997.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','37',1516,'43','2',2846108.63,2846108.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','37',1517,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','37',1518,'45','2',1905846.90,1905846.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','37',1519,'46','2',4722782.97,4722782.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','37',1520,'47','2',3996885.31,3996885.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','37',1521,'48','2',2405881.08,2405881.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','37',1522,'49','2',2726250.19,2726250.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','37',1523,'50','1',941001.72,941001.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','37',1524,'51','1',677849.19,677849.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','37',1525,'52','1',755838.46,755838.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','37',1526,'53','1',899555.48,899555.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','37',1527,'54','1',601299.71,601299.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','37',1528,'55','1',435218.24,435218.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','37',1529,'56','1',367711.44,367711.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','37',1530,'57','1',713620.84,713620.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','37',1531,'58','1',701724.66,701724.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','37',1532,'59','1',326148.58,326148.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','37',1533,'60','1',448649.58,448649.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','37',1534,'61','1',616240.34,616240.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','37',1535,'62','1',210471.56,210471.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','37',1536,'63','1',574673.13,574673.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','37',1537,'64','1',449154.29,449154.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','37',1538,'65','1',193116.54,193116.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','38',1539,'1','1',1349007.98,1352552.33,3544.35,584817.75,0.00,0.00,0.00,0.00,0.00),('21','237','1','38',1540,'3','1',809932.45,810466.12,533.67,88055.55,0.00,0.00,0.00,0.00,0.00),('21','237','1','38',1541,'5','1',643799.73,643799.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','38',1542,'7','1',1375504.46,1378218.28,2713.82,447780.30,0.00,0.00,0.00,0.00,0.00),('21','237','2','38',1543,'9','1',696568.95,698877.71,2308.76,380945.40,0.00,0.00,0.00,0.00,0.00),('21','237','2','38',1544,'11','1',529310.88,530431.71,1120.83,184936.95,0.00,0.00,0.00,0.00,0.00),('21','237','2','38',1545,'13','1',347442.82,347959.10,516.28,85186.20,0.00,0.00,0.00,0.00,0.00),('21','237','2','38',1546,'15','1',552979.84,554352.60,1372.76,226505.40,0.00,0.00,0.00,0.00,0.00),('21','237','3','38',1547,'17','1',393727.60,394037.23,309.63,51088.95,0.00,0.00,0.00,0.00,0.00),('21','237','3','38',1548,'18','1',327570.67,329047.19,1476.52,243625.80,0.00,0.00,0.00,0.00,0.00),('21','237','3','38',1549,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','38',1550,'23','1',423335.49,423707.78,372.29,61427.85,0.00,0.00,0.00,0.00,0.00),('21','237','4','38',1551,'25','1',185417.13,186473.29,1056.16,174266.40,0.00,0.00,0.00,0.00,0.00),('21','237','4','38',1552,'27','1',188072.88,188072.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','38',1553,'29','1',175369.17,175369.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','38',1554,'31','1',259535.01,261165.39,1630.38,269012.70,0.00,0.00,0.00,0.00,0.00),('21','237','5','38',1555,'33','2',3415655.16,3421929.41,6274.25,4015520.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','38',1556,'35','2',3857709.99,3864813.27,7103.28,4546099.20,0.00,0.00,0.00,0.00,0.00),('21','237','5','38',1557,'42','2',2806997.78,2812674.25,5676.47,3632940.80,0.00,0.00,0.00,0.00,0.00),('21','237','5','38',1558,'43','2',2846108.63,2851501.78,5393.15,3451616.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','38',1559,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','38',1560,'45','2',1905846.90,1912924.93,7078.03,4529939.20,0.00,0.00,0.00,0.00,0.00),('21','237','6','38',1561,'46','2',4722782.97,4726289.19,3506.22,2243980.80,0.00,0.00,0.00,0.00,0.00),('21','237','6','38',1562,'47','2',3996885.31,4006612.63,9727.32,6225484.80,0.00,0.00,0.00,0.00,0.00),('21','237','7','38',1563,'48','2',2405881.08,2411737.48,5856.40,3748096.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','38',1564,'49','2',2726250.19,2733424.60,7174.41,4591622.40,0.00,0.00,0.00,0.00,0.00),('21','237','1','38',1565,'50','1',941001.72,942010.08,1008.36,166379.40,0.00,0.00,0.00,0.00,0.00),('21','237','1','38',1566,'51','1',677849.19,677849.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','38',1567,'52','1',755838.46,757491.23,1652.77,272707.05,0.00,0.00,0.00,0.00,0.00),('21','237','1','38',1568,'53','1',899555.48,901971.85,2416.37,398701.05,0.00,0.00,0.00,0.00,0.00),('21','237','2','38',1569,'54','1',601299.71,602508.69,1208.98,199481.70,0.00,0.00,0.00,0.00,0.00),('21','237','2','38',1570,'55','1',435218.24,435789.95,571.71,94332.15,0.00,0.00,0.00,0.00,0.00),('21','237','2','38',1571,'56','1',367711.44,370416.16,2704.72,446278.80,0.00,0.00,0.00,0.00,0.00),('21','237','2','38',1572,'57','1',713620.84,716290.81,2669.97,440545.05,0.00,0.00,0.00,0.00,0.00),('21','237','3','38',1573,'58','1',701724.66,704312.39,2587.73,426975.45,0.00,0.00,0.00,0.00,0.00),('21','237','3','38',1574,'59','1',326148.58,326281.34,132.76,21905.40,0.00,0.00,0.00,0.00,0.00),('21','237','3','38',1575,'60','1',448649.58,449609.84,960.26,158442.90,0.00,0.00,0.00,0.00,0.00),('21','237','3','38',1576,'61','1',616240.34,618191.92,1951.58,322010.70,0.00,0.00,0.00,0.00,0.00),('21','237','4','38',1577,'62','1',210471.56,210472.30,0.74,122.10,0.00,0.00,0.00,0.00,0.00),('21','237','4','38',1578,'63','1',574673.13,577685.21,3012.08,496993.20,0.00,0.00,0.00,0.00,0.00),('21','237','4','38',1579,'64','1',449154.29,452095.99,2941.70,485380.50,0.00,0.00,0.00,0.00,0.00),('21','237','4','38',1580,'65','1',193116.54,195110.66,1994.12,329029.80,0.00,0.00,0.00,0.00,0.00),('21','237','1','39',1581,'1','1',1352552.33,1352552.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','39',1582,'3','1',810466.12,810466.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','39',1583,'5','1',643799.73,643799.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','39',1584,'7','1',1378218.28,1378218.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','39',1585,'9','1',698877.71,701407.83,2530.12,417469.80,0.00,0.00,0.00,0.00,0.00),('21','237','2','39',1586,'11','1',530431.71,531961.19,1529.48,252364.20,0.00,0.00,0.00,0.00,0.00),('21','237','2','39',1587,'13','1',347959.10,348537.58,578.48,95449.20,0.00,0.00,0.00,0.00,0.00),('21','237','2','39',1588,'15','1',554352.60,555067.42,714.82,117945.30,0.00,0.00,0.00,0.00,0.00),('21','237','3','39',1589,'17','1',394037.23,394696.29,659.06,108744.90,0.00,0.00,0.00,0.00,0.00),('21','237','3','39',1590,'18','1',329047.19,330385.03,1337.84,220743.60,0.00,0.00,0.00,0.00,0.00),('21','237','3','39',1591,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','39',1592,'23','1',423707.78,424185.05,477.27,78749.55,0.00,0.00,0.00,0.00,0.00),('21','237','4','39',1593,'25','1',186473.29,188226.01,1752.72,289198.80,0.00,0.00,0.00,0.00,0.00),('21','237','4','39',1594,'27','1',188072.88,188072.94,0.06,9.90,0.00,0.00,0.00,0.00,0.00),('21','237','4','39',1595,'29','1',175369.17,175579.75,210.58,34745.70,0.00,0.00,0.00,0.00,0.00),('21','237','4','39',1596,'31','1',261165.39,262379.88,1214.49,200390.85,0.00,0.00,0.00,0.00,0.00),('21','237','5','39',1597,'33','2',3421929.41,3421929.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','39',1598,'35','2',3864813.27,3864813.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','39',1599,'42','2',2812674.25,2812674.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','39',1600,'43','2',2851501.78,2851501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','39',1601,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','39',1602,'45','2',1912924.93,1913745.19,820.26,524966.40,0.00,0.00,0.00,0.00,0.00),('21','237','6','39',1603,'46','2',4726289.19,4726292.76,3.57,2284.80,0.00,0.00,0.00,0.00,0.00),('21','237','6','39',1604,'47','2',4006612.63,4007388.63,776.00,496640.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','39',1605,'48','2',2411737.48,2429733.81,17996.33,11517651.20,0.00,0.00,0.00,0.00,0.00),('21','237','7','39',1606,'49','2',2733424.60,2751705.16,18280.56,11699558.40,0.00,0.00,0.00,0.00,0.00),('21','237','1','39',1607,'50','1',942010.08,942010.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','39',1608,'51','1',677849.19,677849.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','39',1609,'52','1',757491.23,757491.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','39',1610,'53','1',901971.85,901971.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','39',1611,'54','1',602508.69,603170.19,661.50,109147.50,0.00,0.00,0.00,0.00,0.00),('21','237','2','39',1612,'55','1',435789.95,436434.87,644.92,106411.80,0.00,0.00,0.00,0.00,0.00),('21','237','2','39',1613,'56','1',370416.16,370933.69,517.53,85392.45,0.00,0.00,0.00,0.00,0.00),('21','237','2','39',1614,'57','1',716290.81,717787.20,1496.39,246904.35,0.00,0.00,0.00,0.00,0.00),('21','237','3','39',1615,'58','1',704312.39,706504.04,2191.65,361622.25,0.00,0.00,0.00,0.00,0.00),('21','237','3','39',1616,'59','1',326281.34,326656.79,375.45,61949.25,0.00,0.00,0.00,0.00,0.00),('21','237','3','39',1617,'60','1',449609.84,451596.34,1986.50,327772.50,0.00,0.00,0.00,0.00,0.00),('21','237','3','39',1618,'61','1',618191.92,619222.36,1030.44,170022.60,0.00,0.00,0.00,0.00,0.00),('21','237','4','39',1619,'62','1',210472.30,210472.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','39',1620,'63','1',577685.21,582175.06,4489.85,740825.25,0.00,0.00,0.00,0.00,0.00),('21','237','4','39',1621,'64','1',452095.99,454158.69,2062.70,340345.50,0.00,0.00,0.00,0.00,0.00),('21','237','4','39',1622,'65','1',195110.66,198180.65,3069.99,506548.35,0.00,0.00,0.00,0.00,0.00),('21','237','1','40',1623,'1','1',1352552.33,1352890.89,338.56,55862.40,0.00,0.00,0.00,0.00,0.00),('21','237','1','40',1624,'3','1',810466.12,812530.24,2064.12,340579.80,0.00,0.00,0.00,0.00,0.00),('21','237','1','40',1625,'5','1',643799.73,643830.02,30.29,4997.85,0.00,0.00,0.00,0.00,0.00),('21','237','1','40',1626,'7','1',1378218.28,1379877.56,1659.28,273781.20,0.00,0.00,0.00,0.00,0.00),('21','237','2','40',1627,'9','1',701407.83,704042.30,2634.47,434687.55,0.00,0.00,0.00,0.00,0.00),('21','237','2','40',1628,'11','1',531961.19,532967.67,1006.48,166069.20,0.00,0.00,0.00,0.00,0.00),('21','237','2','40',1629,'13','1',348537.58,351757.38,3219.80,531267.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','40',1630,'15','1',555067.42,555920.46,853.04,140751.60,0.00,0.00,0.00,0.00,0.00),('21','237','3','40',1631,'17','1',394696.29,396209.79,1513.50,249727.50,0.00,0.00,0.00,0.00,0.00),('21','237','3','40',1632,'18','1',330385.03,331417.79,1032.76,170405.40,0.00,0.00,0.00,0.00,0.00),('21','237','3','40',1633,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','40',1634,'23','1',424185.05,424328.06,143.01,23596.65,0.00,0.00,0.00,0.00,0.00),('21','237','4','40',1635,'25','1',188226.01,188226.31,0.30,49.50,0.00,0.00,0.00,0.00,0.00),('21','237','4','40',1636,'27','1',188072.94,188072.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','40',1637,'29','1',175579.75,176734.20,1154.45,190484.25,0.00,0.00,0.00,0.00,0.00),('21','237','4','40',1638,'31','1',262379.88,263550.87,1170.99,193213.35,0.00,0.00,0.00,0.00,0.00),('21','237','5','40',1639,'33','2',3421929.41,3421929.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','40',1640,'35','2',3864813.27,3864813.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','40',1641,'42','2',2812674.25,2812674.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','40',1642,'43','2',2851501.78,2851501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','40',1643,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','40',1644,'45','2',1913745.19,1913745.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','40',1645,'46','2',4726292.76,4726292.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','40',1646,'47','2',4007388.63,4007388.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','40',1647,'48','2',2429733.81,2429733.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','40',1648,'49','2',2751705.16,2751705.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','40',1649,'50','1',942010.08,942630.26,620.18,102329.70,0.00,0.00,0.00,0.00,0.00),('21','237','1','40',1650,'51','1',677849.19,677849.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','40',1651,'52','1',757491.23,758631.02,1139.79,188065.35,0.00,0.00,0.00,0.00,0.00),('21','237','1','40',1652,'53','1',901971.85,902706.21,734.36,121169.40,0.00,0.00,0.00,0.00,0.00),('21','237','2','40',1653,'54','1',603170.19,604120.82,950.63,156853.95,0.00,0.00,0.00,0.00,0.00),('21','237','2','40',1654,'55','1',436434.87,438318.35,1883.48,310774.20,0.00,0.00,0.00,0.00,0.00),('21','237','2','40',1655,'56','1',370933.69,373738.67,2804.98,462821.70,0.00,0.00,0.00,0.00,0.00),('21','237','2','40',1656,'57','1',717787.20,718428.21,641.01,105766.65,0.00,0.00,0.00,0.00,0.00),('21','237','3','40',1657,'58','1',706504.04,709302.48,2798.44,461742.60,0.00,0.00,0.00,0.00,0.00),('21','237','3','40',1658,'59','1',326656.79,327229.67,572.88,94525.20,0.00,0.00,0.00,0.00,0.00),('21','237','3','40',1659,'60','1',451596.34,453972.92,2376.58,392135.70,0.00,0.00,0.00,0.00,0.00),('21','237','3','40',1660,'61','1',619222.36,621305.49,2083.13,343716.45,0.00,0.00,0.00,0.00,0.00),('21','237','4','40',1661,'62','1',210472.30,210472.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','40',1662,'63','1',582175.06,584684.29,2509.23,414022.95,0.00,0.00,0.00,0.00,0.00),('21','237','4','40',1663,'64','1',454158.69,457377.90,3219.21,531169.65,0.00,0.00,0.00,0.00,0.00),('21','237','4','40',1664,'65','1',198180.65,199713.77,1533.12,252964.80,0.00,0.00,0.00,0.00,0.00),('21','237','1','41',1665,'1','1',1352890.89,1355316.43,2425.54,400214.10,0.00,0.00,0.00,0.00,0.00),('21','237','1','41',1666,'3','1',812530.24,812557.51,27.27,4499.55,0.00,0.00,0.00,0.00,0.00),('21','237','1','41',1667,'5','1',643830.02,644376.39,546.37,90151.05,0.00,0.00,0.00,0.00,0.00),('21','237','1','41',1668,'7','1',1379877.56,1382586.51,2708.95,446976.75,0.00,0.00,0.00,0.00,0.00),('21','237','2','41',1669,'9','1',704042.30,706463.02,2420.72,399418.80,0.00,0.00,0.00,0.00,0.00),('21','237','2','41',1670,'11','1',532967.67,533499.19,531.52,87700.80,0.00,0.00,0.00,0.00,0.00),('21','237','2','41',1671,'13','1',351757.38,351757.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','41',1672,'15','1',555920.46,556913.10,992.64,163785.60,0.00,0.00,0.00,0.00,0.00),('21','237','3','41',1673,'17','1',396209.79,397418.21,1208.42,199389.30,0.00,0.00,0.00,0.00,0.00),('21','237','3','41',1674,'18','1',331417.79,331417.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','41',1675,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','41',1676,'23','1',424328.06,424898.33,570.27,94094.55,0.00,0.00,0.00,0.00,0.00),('21','237','4','41',1677,'25','1',188226.31,188227.15,0.84,138.60,0.00,0.00,0.00,0.00,0.00),('21','237','4','41',1678,'27','1',188072.94,188072.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','41',1679,'29','1',176734.20,177274.87,540.67,89210.55,0.00,0.00,0.00,0.00,0.00),('21','237','4','41',1680,'31','1',263550.87,264281.84,730.97,120610.05,0.00,0.00,0.00,0.00,0.00),('21','237','5','41',1681,'33','2',3421929.41,3424086.43,2157.02,1380492.80,0.00,0.00,0.00,0.00,0.00),('21','237','5','41',1682,'35','2',3864813.27,3865073.27,260.00,166400.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','41',1683,'42','2',2812674.25,2813774.25,1100.00,704000.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','41',1684,'43','2',2851501.78,2852031.78,530.00,339200.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','41',1685,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','41',1686,'45','2',1913745.19,1919061.64,5316.45,3402528.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','41',1687,'46','2',4726292.76,4730220.41,3927.65,2513696.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','41',1688,'47','2',4007388.63,4011855.13,4466.50,2858560.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','41',1689,'48','2',2429733.81,2435410.19,5676.38,3632883.20,0.00,0.00,0.00,0.00,0.00),('21','237','7','41',1690,'49','2',2751705.16,2757601.75,5896.59,3773817.60,0.00,0.00,0.00,0.00,0.00),('21','237','1','41',1691,'50','1',942630.26,945817.10,3186.84,525828.60,0.00,0.00,0.00,0.00,0.00),('21','237','1','41',1692,'51','1',677849.19,677849.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','41',1693,'52','1',758631.02,761059.81,2428.79,400750.35,0.00,0.00,0.00,0.00,0.00),('21','237','1','41',1694,'53','1',902706.21,904822.66,2116.45,349214.25,0.00,0.00,0.00,0.00,0.00),('21','237','2','41',1695,'54','1',604120.82,604537.44,416.62,68742.30,0.00,0.00,0.00,0.00,0.00),('21','237','2','41',1696,'55','1',438318.35,439046.85,728.50,120202.50,0.00,0.00,0.00,0.00,0.00),('21','237','2','41',1697,'56','1',373738.67,373738.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','41',1698,'57','1',718428.21,721032.55,2604.34,429716.10,0.00,0.00,0.00,0.00,0.00),('21','237','3','41',1699,'58','1',709302.48,711885.28,2582.80,426162.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','41',1700,'59','1',327229.67,331027.65,3797.98,626666.70,0.00,0.00,0.00,0.00,0.00),('21','237','3','41',1701,'60','1',453972.92,455921.77,1948.85,321560.25,0.00,0.00,0.00,0.00,0.00),('21','237','3','41',1702,'61','1',621305.49,622197.28,891.79,147145.35,0.00,0.00,0.00,0.00,0.00),('21','237','4','41',1703,'62','1',210472.30,210472.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','41',1704,'63','1',584684.29,588627.69,3943.40,650661.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','41',1705,'64','1',457377.90,458127.55,749.65,123692.25,0.00,0.00,0.00,0.00,0.00),('21','237','4','41',1706,'65','1',199713.77,201880.90,2167.13,357576.45,0.00,0.00,0.00,0.00,0.00),('21','237','1','42',1707,'1','1',1355316.43,1355316.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','42',1708,'3','1',812557.51,812557.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','42',1709,'5','1',644376.39,644376.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','42',1710,'7','1',1382586.51,1382586.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','42',1711,'9','1',706463.02,706463.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','42',1712,'11','1',533499.19,533499.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','42',1713,'13','1',351757.38,351757.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','42',1714,'15','1',556913.10,556913.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','42',1715,'17','1',397418.21,397418.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','42',1716,'18','1',331417.79,331417.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','42',1717,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','42',1718,'23','1',424898.33,424898.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','42',1719,'25','1',188227.15,188227.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','42',1720,'27','1',188072.94,188072.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','42',1721,'29','1',177274.87,177274.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','42',1722,'31','1',264281.84,264281.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','42',1723,'33','2',3424086.43,3424086.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','42',1724,'35','2',3865073.27,3865073.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','42',1725,'42','2',2813774.25,2813774.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','42',1726,'43','2',2852031.78,2852031.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','42',1727,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','42',1728,'45','2',1919061.64,1919061.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','42',1729,'46','2',4730220.41,4730220.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','42',1730,'47','2',4011855.13,4011855.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','42',1731,'48','2',2435410.19,2435410.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','42',1732,'49','2',2757601.75,2757601.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','42',1733,'50','1',945817.10,945817.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','42',1734,'51','1',677849.19,677849.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','42',1735,'52','1',761059.81,761059.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','42',1736,'53','1',904822.66,904822.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','42',1737,'54','1',604537.44,604537.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','42',1738,'55','1',439046.85,439046.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','42',1739,'56','1',373738.67,373738.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','42',1740,'57','1',721032.55,721032.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','42',1741,'58','1',711885.28,711885.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','42',1742,'59','1',331027.65,331027.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','42',1743,'60','1',455921.77,455921.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','42',1744,'61','1',622197.28,622197.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','42',1745,'62','1',210472.30,210472.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','42',1746,'63','1',588627.69,588627.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','42',1747,'64','1',458127.55,458127.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','42',1748,'65','1',201880.90,201880.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','43',1749,'1','1',1355316.43,1360279.53,4963.10,818911.50,0.00,0.00,0.00,0.00,0.00),('21','237','1','43',1750,'3','1',812557.51,812583.40,25.89,4271.85,0.00,0.00,0.00,0.00,0.00),('21','237','1','43',1751,'5','1',644376.39,644589.25,212.86,35121.90,0.00,0.00,0.00,0.00,0.00),('21','237','1','43',1752,'7','1',1382586.51,1385986.83,3400.32,561052.80,0.00,0.00,0.00,0.00,0.00),('21','237','2','43',1753,'9','1',706463.02,709161.50,2698.48,445249.20,0.00,0.00,0.00,0.00,0.00),('21','237','2','43',1754,'11','1',533499.19,535058.72,1559.53,257322.45,0.00,0.00,0.00,0.00,0.00),('21','237','2','43',1755,'13','1',351757.38,352749.66,992.28,163726.20,0.00,0.00,0.00,0.00,0.00),('21','237','2','43',1756,'15','1',556913.10,558159.69,1246.59,205687.35,0.00,0.00,0.00,0.00,0.00),('21','237','3','43',1757,'17','1',397418.21,397733.48,315.27,52019.55,0.00,0.00,0.00,0.00,0.00),('21','237','3','43',1758,'18','1',331417.79,333056.97,1639.18,270464.70,0.00,0.00,0.00,0.00,0.00),('21','237','3','43',1759,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','43',1760,'23','1',424898.33,426638.02,1739.69,287048.85,0.00,0.00,0.00,0.00,0.00),('21','237','4','43',1761,'25','1',188227.15,188227.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','43',1762,'27','1',188072.94,188072.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','43',1763,'29','1',177274.87,177654.87,380.00,62700.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','43',1764,'31','1',264281.84,264281.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','43',1765,'33','2',3424086.43,3429232.82,5146.39,3345153.50,0.00,0.00,0.00,0.00,0.00),('21','237','5','43',1766,'35','2',3865073.27,3870331.84,5258.57,3418070.50,0.00,0.00,0.00,0.00,0.00),('21','237','5','43',1767,'42','2',2813774.25,2817789.13,4014.88,2609672.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','43',1768,'43','2',2852031.78,2858512.79,6481.01,4212656.50,0.00,0.00,0.00,0.00,0.00),('21','237','6','43',1769,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','43',1770,'45','2',1919061.64,1924330.55,5268.91,3424791.50,0.00,0.00,0.00,0.00,0.00),('21','237','6','43',1771,'46','2',4730220.41,4738703.57,8483.16,5514054.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','43',1772,'47','2',4011855.13,4018180.15,6325.02,4111263.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','43',1773,'48','2',2435410.19,2443377.86,7967.67,5178985.50,0.00,0.00,0.00,0.00,0.00),('21','237','7','43',1774,'49','2',2757601.75,2766004.70,8402.95,5461917.50,0.00,0.00,0.00,0.00,0.00),('21','237','1','43',1775,'50','1',945817.10,948362.34,2545.24,419964.60,0.00,0.00,0.00,0.00,0.00),('21','237','1','43',1776,'51','1',677849.19,677849.26,0.07,11.55,0.00,0.00,0.00,0.00,0.00),('21','237','1','43',1777,'52','1',761059.81,762607.44,1547.63,255358.95,0.00,0.00,0.00,0.00,0.00),('21','237','1','43',1778,'53','1',904822.66,906809.65,1986.99,327853.35,0.00,0.00,0.00,0.00,0.00),('21','237','2','43',1779,'54','1',604537.44,605169.22,631.78,104243.70,0.00,0.00,0.00,0.00,0.00),('21','237','2','43',1780,'55','1',439046.85,440779.04,1732.19,285811.35,0.00,0.00,0.00,0.00,0.00),('21','237','2','43',1781,'56','1',373738.67,377922.35,4183.68,690307.20,0.00,0.00,0.00,0.00,0.00),('21','237','2','43',1782,'57','1',721032.55,724110.19,3077.64,507810.60,0.00,0.00,0.00,0.00,0.00),('21','237','3','43',1783,'58','1',711885.28,716122.42,4237.14,699128.10,0.00,0.00,0.00,0.00,0.00),('21','237','3','43',1784,'59','1',331027.65,331552.45,524.80,86592.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','43',1785,'60','1',455921.77,455921.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','43',1786,'61','1',622197.28,625045.67,2848.39,469984.35,0.00,0.00,0.00,0.00,0.00),('21','237','4','43',1787,'62','1',210472.30,210472.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','43',1788,'63','1',588627.69,590391.48,1763.79,291025.35,0.00,0.00,0.00,0.00,0.00),('21','237','4','43',1789,'64','1',458127.55,459166.68,1039.13,171456.45,0.00,0.00,0.00,0.00,0.00),('21','237','4','43',1790,'65','1',201880.90,204055.00,2174.10,358726.50,0.00,0.00,0.00,0.00,0.00),('21','237','1','44',1791,'1','1',1360279.53,1360279.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','44',1792,'3','1',812583.40,812583.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','44',1793,'5','1',644589.25,644589.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','44',1794,'7','1',1385986.83,1385986.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','44',1795,'9','1',709161.50,709161.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','44',1796,'11','1',535058.72,539255.83,4197.11,692523.15,0.00,0.00,0.00,0.00,0.00),('21','237','2','44',1797,'13','1',352749.66,354602.74,1853.08,305758.20,0.00,0.00,0.00,0.00,0.00),('21','237','2','44',1798,'15','1',558159.69,558159.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','44',1799,'17','1',397733.48,399631.57,1898.09,313184.85,0.00,0.00,0.00,0.00,0.00),('21','237','3','44',1800,'18','1',333056.97,334323.78,1266.81,209023.65,0.00,0.00,0.00,0.00,0.00),('21','237','3','44',1801,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','44',1802,'23','1',426638.02,427904.46,1266.44,208962.60,0.00,0.00,0.00,0.00,0.00),('21','237','4','44',1803,'25','1',188227.15,188227.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','44',1804,'27','1',188072.94,188072.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','44',1805,'29','1',177654.87,177828.12,173.25,28586.25,0.00,0.00,0.00,0.00,0.00),('21','237','4','44',1806,'31','1',264281.84,264281.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','44',1807,'33','2',3429232.82,3429232.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','44',1808,'35','2',3870331.84,3870331.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','44',1809,'42','2',2817789.13,2817789.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','44',1810,'43','2',2858512.79,2858512.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','44',1811,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','44',1812,'45','2',1924330.55,1932862.80,8532.25,5545962.50,0.00,0.00,0.00,0.00,0.00),('21','237','6','44',1813,'46','2',4738703.57,4745823.53,7119.96,4627974.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','44',1814,'47','2',4018180.15,4023220.98,5040.83,3276539.50,0.00,0.00,0.00,0.00,0.00),('21','237','7','44',1815,'48','2',2443377.86,2443377.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','44',1816,'49','2',2766004.70,2766004.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','44',1817,'50','1',948362.34,948362.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','44',1818,'51','1',677849.26,677849.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','44',1819,'52','1',762607.44,762607.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','44',1820,'53','1',906809.65,906809.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','44',1821,'54','1',605169.22,605169.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','44',1822,'55','1',440779.04,441384.04,605.00,99825.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','44',1823,'56','1',377922.35,381257.63,3335.28,550321.20,0.00,0.00,0.00,0.00,0.00),('21','237','2','44',1824,'57','1',724110.19,724110.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','44',1825,'58','1',716122.42,719796.12,3673.70,606160.50,0.00,0.00,0.00,0.00,0.00),('21','237','3','44',1826,'59','1',331552.45,331609.36,56.91,9390.15,0.00,0.00,0.00,0.00,0.00),('21','237','3','44',1827,'60','1',455921.77,459707.97,3786.20,624723.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','44',1828,'61','1',625045.67,626971.21,1925.54,317714.10,0.00,0.00,0.00,0.00,0.00),('21','237','4','44',1829,'62','1',210472.30,210472.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','44',1830,'63','1',590391.48,594544.65,4153.17,685273.05,0.00,0.00,0.00,0.00,0.00),('21','237','4','44',1831,'64','1',459166.68,462191.81,3025.13,499146.45,0.00,0.00,0.00,0.00,0.00),('21','237','4','44',1832,'65','1',204055.00,206211.59,2156.59,355837.35,0.00,0.00,0.00,0.00,0.00),('21','237','1','45',1833,'1','1',1360279.53,1360279.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','45',1834,'3','1',812583.40,812583.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','45',1835,'5','1',644589.25,644589.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','45',1836,'7','1',1385986.83,1385986.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','45',1837,'9','1',709161.50,709161.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','45',1838,'11','1',539255.83,542666.97,3411.14,562838.10,0.00,0.00,0.00,0.00,0.00),('21','237','2','45',1839,'13','1',354602.74,354602.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','45',1840,'15','1',558159.69,560532.25,2372.56,391472.40,0.00,0.00,0.00,0.00,0.00),('21','237','3','45',1841,'17','1',399631.57,401311.21,1679.64,277140.60,0.00,0.00,0.00,0.00,0.00),('21','237','3','45',1842,'18','1',334323.78,334323.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','45',1843,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','45',1844,'23','1',427904.46,429359.08,1454.62,240012.30,0.00,0.00,0.00,0.00,0.00),('21','237','4','45',1845,'25','1',188227.15,188227.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','45',1846,'27','1',188072.94,188670.18,597.24,98544.60,0.00,0.00,0.00,0.00,0.00),('21','237','4','45',1847,'29','1',177828.12,178221.89,393.77,64972.05,0.00,0.00,0.00,0.00,0.00),('21','237','4','45',1848,'31','1',264281.84,264281.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','45',1849,'33','2',3429232.82,3433169.02,3936.20,2558530.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','45',1850,'35','2',3870331.84,3877550.91,7219.07,4692395.50,0.00,0.00,0.00,0.00,0.00),('21','237','5','45',1851,'42','2',2817789.13,2825059.35,7270.22,4725643.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','45',1852,'43','2',2858512.79,2864943.68,6430.89,4180078.50,0.00,0.00,0.00,0.00,0.00),('21','237','6','45',1853,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','45',1854,'45','2',1932862.80,1932862.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','45',1855,'46','2',4745823.53,4745823.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','45',1856,'47','2',4023220.98,4023220.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','45',1857,'48','2',2443377.86,2444013.59,635.73,413224.50,0.00,0.00,0.00,0.00,0.00),('21','237','7','45',1858,'49','2',2766004.70,2766004.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','45',1859,'50','1',948362.34,948362.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','45',1860,'51','1',677849.26,677849.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','45',1861,'52','1',762607.44,762607.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','45',1862,'53','1',906809.65,906809.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','45',1863,'54','1',605169.22,605169.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','45',1864,'55','1',441384.04,441384.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','45',1865,'56','1',381257.63,381257.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','45',1866,'57','1',724110.19,724110.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','45',1867,'58','1',719796.12,719796.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','45',1868,'59','1',331609.36,331609.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','45',1869,'60','1',459707.97,459707.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','45',1870,'61','1',626971.21,626971.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','45',1871,'62','1',210472.30,210472.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','45',1872,'63','1',594544.65,594544.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','45',1873,'64','1',462191.81,462191.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','45',1874,'65','1',206211.59,206211.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','46',1875,'1','1',1360279.53,1362963.26,2683.73,442815.45,0.00,0.00,0.00,0.00,0.00),('21','237','1','46',1876,'3','1',812583.40,816896.37,4312.97,711640.05,0.00,0.00,0.00,0.00,0.00),('21','237','1','46',1877,'5','1',644589.25,644589.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','46',1878,'7','1',1385986.83,1388879.84,2893.01,477346.65,0.00,0.00,0.00,0.00,0.00),('21','237','2','46',1879,'9','1',709161.50,716802.03,7640.53,1260687.45,0.00,0.00,0.00,0.00,0.00),('21','237','2','46',1880,'11','1',542666.97,542959.23,292.26,48222.90,0.00,0.00,0.00,0.00,0.00),('21','237','2','46',1881,'13','1',354602.74,354871.01,268.27,44264.55,0.00,0.00,0.00,0.00,0.00),('21','237','2','46',1882,'15','1',560532.25,561365.30,833.05,137453.25,0.00,0.00,0.00,0.00,0.00),('21','237','3','46',1883,'17','1',401311.21,402636.31,1325.10,218641.50,0.00,0.00,0.00,0.00,0.00),('21','237','3','46',1884,'18','1',334323.78,334323.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','46',1885,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','46',1886,'23','1',429359.08,429359.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','46',1887,'25','1',188227.15,188227.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','46',1888,'27','1',188670.18,188670.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','46',1889,'29','1',178221.89,178221.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','46',1890,'31','1',264281.84,264281.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','46',1891,'33','2',3433169.02,3433169.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','46',1892,'35','2',3877550.91,3877550.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','46',1893,'42','2',2825059.35,2825059.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','46',1894,'43','2',2864943.68,2864943.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','46',1895,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','46',1896,'45','2',1932862.80,1932862.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','46',1897,'46','2',4745823.53,4745823.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','46',1898,'47','2',4023220.98,4023220.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','46',1899,'48','2',2444013.59,2445263.59,1250.00,812500.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','46',1900,'49','2',2766004.70,2766424.72,420.02,273013.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','46',1901,'50','1',948362.34,950337.94,1975.60,325974.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','46',1902,'51','1',677849.26,677849.76,0.50,82.50,0.00,0.00,0.00,0.00,0.00),('21','237','1','46',1903,'52','1',762607.44,766480.85,3873.41,639112.65,0.00,0.00,0.00,0.00,0.00),('21','237','1','46',1904,'53','1',906809.65,909924.70,3115.05,513983.25,0.00,0.00,0.00,0.00,0.00),('21','237','2','46',1905,'54','1',605169.22,608433.17,3263.95,538551.75,0.00,0.00,0.00,0.00,0.00),('21','237','2','46',1906,'55','1',441384.04,444150.38,2766.34,456446.10,0.00,0.00,0.00,0.00,0.00),('21','237','2','46',1907,'56','1',381257.63,381633.00,375.37,61936.05,0.00,0.00,0.00,0.00,0.00),('21','237','2','46',1908,'57','1',724110.19,733170.30,9060.11,1494918.15,0.00,0.00,0.00,0.00,0.00),('21','237','3','46',1909,'58','1',719796.12,725355.48,5559.36,917294.40,0.00,0.00,0.00,0.00,0.00),('21','237','3','46',1910,'59','1',331609.36,331609.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','46',1911,'60','1',459707.97,459707.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','46',1912,'61','1',626971.21,635610.89,8639.68,1425547.20,0.00,0.00,0.00,0.00,0.00),('21','237','4','46',1913,'62','1',210472.30,210472.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','46',1914,'63','1',594544.65,596589.78,2045.13,337446.45,0.00,0.00,0.00,0.00,0.00),('21','237','4','46',1915,'64','1',462191.81,465459.01,3267.20,539088.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','46',1916,'65','1',206211.59,208056.33,1844.74,304382.10,0.00,0.00,0.00,0.00,0.00),('21','237','1','47',1917,'1','1',1362963.26,1365520.88,2557.62,422007.30,0.00,0.00,0.00,0.00,0.00),('21','237','1','47',1918,'3','1',816896.37,816896.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','47',1919,'5','1',644589.25,644589.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','47',1920,'7','1',1388879.84,1389976.37,1096.53,180927.45,0.00,0.00,0.00,0.00,0.00),('21','237','2','47',1921,'9','1',716802.03,720992.77,4190.74,691472.10,0.00,0.00,0.00,0.00,0.00),('21','237','2','47',1922,'11','1',542959.23,542959.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','47',1923,'13','1',354871.01,354871.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','47',1924,'15','1',561365.30,562684.07,1318.77,217597.05,0.00,0.00,0.00,0.00,0.00),('21','237','3','47',1925,'17','1',402636.31,405103.68,2467.37,407116.05,0.00,0.00,0.00,0.00,0.00),('21','237','3','47',1926,'18','1',334323.78,334323.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','47',1927,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','47',1928,'23','1',429359.08,429971.84,612.76,101105.40,0.00,0.00,0.00,0.00,0.00),('21','237','4','47',1929,'25','1',188227.15,188227.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','47',1930,'27','1',188670.18,188976.37,306.19,50521.35,0.00,0.00,0.00,0.00,0.00),('21','237','4','47',1931,'29','1',178221.89,178892.99,671.10,110731.50,0.00,0.00,0.00,0.00,0.00),('21','237','4','47',1932,'31','1',264281.84,264281.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','47',1933,'33','2',3433169.02,3433923.03,754.01,490106.50,0.00,0.00,0.00,0.00,0.00),('21','237','5','47',1934,'35','2',3877550.91,3878612.45,1061.54,690001.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','47',1935,'42','2',2825059.35,2826240.35,1181.00,767650.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','47',1936,'43','2',2864943.68,2867313.55,2369.87,1540415.50,0.00,0.00,0.00,0.00,0.00),('21','237','6','47',1937,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','47',1938,'45','2',1932862.80,1935390.14,2527.34,1642771.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','47',1939,'46','2',4745823.53,4748731.92,2908.39,1890453.50,0.00,0.00,0.00,0.00,0.00),('21','237','6','47',1940,'47','2',4023220.98,4024680.07,1459.09,948408.50,0.00,0.00,0.00,0.00,0.00),('21','237','7','47',1941,'48','2',2445263.59,2448420.73,3157.14,2052141.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','47',1942,'49','2',2766424.72,2769674.73,3250.01,2112506.50,0.00,0.00,0.00,0.00,0.00),('21','237','1','47',1943,'50','1',950337.94,952095.74,1757.80,290037.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','47',1944,'51','1',677849.76,677851.76,2.00,330.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','47',1945,'52','1',766480.85,768301.64,1820.79,300430.35,0.00,0.00,0.00,0.00,0.00),('21','237','1','47',1946,'53','1',909924.70,911839.22,1914.52,315895.80,0.00,0.00,0.00,0.00,0.00),('21','237','2','47',1947,'54','1',608433.17,609789.12,1355.95,223731.75,0.00,0.00,0.00,0.00,0.00),('21','237','2','47',1948,'55','1',444150.38,444150.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','47',1949,'56','1',381633.00,381633.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','47',1950,'57','1',733170.30,735505.88,2335.58,385370.70,0.00,0.00,0.00,0.00,0.00),('21','237','3','47',1951,'58','1',725355.48,727590.66,2235.18,368804.70,0.00,0.00,0.00,0.00,0.00),('21','237','3','47',1952,'59','1',331609.36,331609.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','47',1953,'60','1',459707.97,459922.19,214.22,35346.30,0.00,0.00,0.00,0.00,0.00),('21','237','3','47',1954,'61','1',635610.89,639460.30,3849.41,635152.65,0.00,0.00,0.00,0.00,0.00),('21','237','4','47',1955,'62','1',210472.30,210472.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','47',1956,'63','1',596589.78,598805.57,2215.79,365605.35,0.00,0.00,0.00,0.00,0.00),('21','237','4','47',1957,'64','1',465459.01,467450.27,1991.26,328557.90,0.00,0.00,0.00,0.00,0.00),('21','237','4','47',1958,'65','1',208056.33,208056.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','48',1959,'1','1',1365520.88,1368659.71,3138.83,517906.95,0.00,0.00,0.00,0.00,0.00),('21','237','1','48',1960,'3','1',816896.37,816896.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','48',1961,'5','1',644589.25,644589.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','48',1962,'7','1',1389976.37,1391907.76,1931.39,318679.35,0.00,0.00,0.00,0.00,0.00),('21','237','2','48',1963,'9','1',720992.77,725148.43,4155.66,685683.90,0.00,0.00,0.00,0.00,0.00),('21','237','2','48',1964,'11','1',542959.23,542959.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','48',1965,'13','1',354871.01,355662.69,791.68,130627.20,0.00,0.00,0.00,0.00,0.00),('21','237','2','48',1966,'15','1',562684.07,562684.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','48',1967,'17','1',405103.68,405103.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','48',1968,'18','1',334323.78,335562.90,1239.12,204454.80,0.00,0.00,0.00,0.00,0.00),('21','237','3','48',1969,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','48',1970,'23','1',429971.84,429971.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','48',1971,'25','1',188227.15,188227.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','48',1972,'27','1',188976.37,190779.70,1803.33,297549.45,0.00,0.00,0.00,0.00,0.00),('21','237','4','48',1973,'29','1',178892.99,178892.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','48',1974,'31','1',264281.84,264875.01,593.17,97873.05,0.00,0.00,0.00,0.00,0.00),('21','237','5','48',1975,'33','2',3433923.03,3436629.82,2706.79,1759413.50,0.00,0.00,0.00,0.00,0.00),('21','237','5','48',1976,'35','2',3878612.45,3883769.25,5156.80,3351920.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','48',1977,'42','2',2826240.35,2829654.08,3413.73,2218924.50,0.00,0.00,0.00,0.00,0.00),('21','237','5','48',1978,'43','2',2867313.55,2871863.11,4549.56,2957214.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','48',1979,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','48',1980,'45','2',1935390.14,1939416.18,4026.04,2616926.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','48',1981,'46','2',4748731.92,4755976.37,7244.45,4708892.50,0.00,0.00,0.00,0.00,0.00),('21','237','6','48',1982,'47','2',4024680.07,4029362.60,4682.53,3043644.50,0.00,0.00,0.00,0.00,0.00),('21','237','7','48',1983,'48','2',2448420.73,2452942.50,4521.77,2939150.50,0.00,0.00,0.00,0.00,0.00),('21','237','7','48',1984,'49','2',2769674.73,2773272.58,3597.85,2338602.50,0.00,0.00,0.00,0.00,0.00),('21','237','1','48',1985,'50','1',952095.74,953840.66,1744.92,287911.80,0.00,0.00,0.00,0.00,0.00),('21','237','1','48',1986,'51','1',677851.76,677851.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','48',1987,'52','1',768301.64,775067.64,6766.00,1116390.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','48',1988,'53','1',911839.22,912301.68,462.46,76305.90,0.00,0.00,0.00,0.00,0.00),('21','237','2','48',1989,'54','1',609789.12,611338.35,1549.23,255622.95,0.00,0.00,0.00,0.00,0.00),('21','237','2','48',1990,'55','1',444150.38,444150.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','48',1991,'56','1',381633.00,386449.77,4816.77,794767.05,0.00,0.00,0.00,0.00,0.00),('21','237','2','48',1992,'57','1',735505.88,735505.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','48',1993,'58','1',727590.66,727590.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','48',1994,'59','1',331609.36,333400.51,1791.15,295539.75,0.00,0.00,0.00,0.00,0.00),('21','237','3','48',1995,'60','1',459922.19,461797.08,1874.89,309356.85,0.00,0.00,0.00,0.00,0.00),('21','237','3','48',1996,'61','1',639460.30,639838.60,378.30,62419.50,0.00,0.00,0.00,0.00,0.00),('21','237','4','48',1997,'62','1',210472.30,210472.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','48',1998,'63','1',598805.57,601942.22,3136.65,517547.25,0.00,0.00,0.00,0.00,0.00),('21','237','4','48',1999,'64','1',467450.27,467450.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','48',2000,'65','1',208056.33,209370.89,1314.56,216902.40,0.00,0.00,0.00,0.00,0.00),('21','237','1','49',2001,'1','1',1368659.71,1372278.00,3618.29,597017.85,0.00,0.00,0.00,0.00,0.00),('21','237','1','49',2002,'3','1',816896.37,816896.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','49',2003,'5','1',644589.25,644628.65,39.40,6501.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','49',2004,'7','1',1391907.76,1393817.31,1909.55,315075.75,0.00,0.00,0.00,0.00,0.00),('21','237','2','49',2005,'9','1',725148.43,725148.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','49',2006,'11','1',542959.23,545511.37,2552.14,421103.10,0.00,0.00,0.00,0.00,0.00),('21','237','2','49',2007,'13','1',355662.69,356243.59,580.90,95848.50,0.00,0.00,0.00,0.00,0.00),('21','237','2','49',2008,'15','1',562684.07,563700.81,1016.74,167762.10,0.00,0.00,0.00,0.00,0.00),('21','237','3','49',2009,'17','1',405103.68,405103.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','49',2010,'18','1',335562.90,335714.78,151.88,25060.20,0.00,0.00,0.00,0.00,0.00),('21','237','3','49',2011,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','49',2012,'23','1',429971.84,430764.60,792.76,130805.40,0.00,0.00,0.00,0.00,0.00),('21','237','4','49',2013,'25','1',188227.15,188227.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','49',2014,'27','1',190779.70,191733.31,953.61,157345.65,0.00,0.00,0.00,0.00,0.00),('21','237','4','49',2015,'29','1',178892.99,178892.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','49',2016,'31','1',264875.01,266052.14,1177.13,194226.45,0.00,0.00,0.00,0.00,0.00),('21','237','5','49',2017,'33','2',3436629.82,3442643.53,6013.71,3908911.50,0.00,0.00,0.00,0.00,0.00),('21','237','5','49',2018,'35','2',3883769.25,3888331.63,4562.38,2965547.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','49',2019,'42','2',2829654.08,2831681.09,2027.01,1317556.50,0.00,0.00,0.00,0.00,0.00),('21','237','5','49',2020,'43','2',2871863.11,2875658.96,3795.85,2467302.50,0.00,0.00,0.00,0.00,0.00),('21','237','6','49',2021,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','49',2022,'45','2',1939416.18,1943087.48,3671.30,2386345.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','49',2023,'46','2',4755976.37,4761199.08,5222.71,3394761.50,0.00,0.00,0.00,0.00,0.00),('21','237','6','49',2024,'47','2',4029362.60,4036599.15,7236.55,4703757.50,0.00,0.00,0.00,0.00,0.00),('21','237','7','49',2025,'48','2',2452942.50,2456647.57,3705.07,2408295.50,0.00,0.00,0.00,0.00,0.00),('21','237','7','49',2026,'49','2',2773272.58,2776836.95,3564.37,2316840.50,0.00,0.00,0.00,0.00,0.00),('21','237','1','49',2027,'50','1',953840.66,955970.19,2129.53,351372.45,0.00,0.00,0.00,0.00,0.00),('21','237','1','49',2028,'51','1',677851.76,677851.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','49',2029,'52','1',775067.64,780846.21,5778.57,953464.05,0.00,0.00,0.00,0.00,0.00),('21','237','1','49',2030,'53','1',912301.68,914192.60,1890.92,312001.80,0.00,0.00,0.00,0.00,0.00),('21','237','2','49',2031,'54','1',611338.35,611338.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','49',2032,'55','1',444150.38,449158.64,5008.26,826362.90,0.00,0.00,0.00,0.00,0.00),('21','237','2','49',2033,'56','1',386449.77,387365.01,915.24,151014.60,0.00,0.00,0.00,0.00,0.00),('21','237','2','49',2034,'57','1',735505.88,740822.06,5316.18,877169.70,0.00,0.00,0.00,0.00,0.00),('21','237','3','49',2035,'58','1',727590.66,727590.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','49',2036,'59','1',333400.51,333606.86,206.35,34047.75,0.00,0.00,0.00,0.00,0.00),('21','237','3','49',2037,'60','1',461797.08,461797.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','49',2038,'61','1',639838.60,641029.14,1190.54,196439.10,0.00,0.00,0.00,0.00,0.00),('21','237','4','49',2039,'62','1',210472.30,210472.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','49',2040,'63','1',601942.22,603612.27,1670.05,275558.25,0.00,0.00,0.00,0.00,0.00),('21','237','4','49',2041,'64','1',467450.27,467450.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','49',2042,'65','1',209370.89,211234.33,1863.44,307467.60,0.00,0.00,0.00,0.00,0.00),('21','237','1','50',2043,'1','1',1372278.00,1375400.30,3122.30,515179.50,0.00,0.00,0.00,0.00,0.00),('21','237','1','50',2044,'3','1',816896.37,816896.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','50',2045,'5','1',644628.65,644628.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','50',2046,'7','1',1393817.31,1397561.29,3743.98,617756.70,0.00,0.00,0.00,0.00,0.00),('21','237','2','50',2047,'9','1',725148.43,727690.42,2541.99,419428.35,0.00,0.00,0.00,0.00,0.00),('21','237','2','50',2048,'11','1',545511.37,545511.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','50',2049,'13','1',356243.59,356243.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','50',2050,'15','1',563700.81,566052.58,2351.77,388042.05,0.00,0.00,0.00,0.00,0.00),('21','237','3','50',2051,'17','1',405103.68,407300.63,2196.95,362496.75,0.00,0.00,0.00,0.00,0.00),('21','237','3','50',2052,'18','1',335714.78,335714.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','50',2053,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','50',2054,'23','1',430764.60,432477.86,1713.26,282687.90,0.00,0.00,0.00,0.00,0.00),('21','237','4','50',2055,'25','1',188227.15,188227.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','50',2056,'27','1',191733.31,192496.43,763.12,125914.80,0.00,0.00,0.00,0.00,0.00),('21','237','4','50',2057,'29','1',178892.99,178892.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','50',2058,'31','1',266052.14,267725.85,1673.71,276162.15,0.00,0.00,0.00,0.00,0.00),('21','237','5','50',2059,'33','2',3442643.53,3446754.46,4110.93,2672104.50,0.00,0.00,0.00,0.00,0.00),('21','237','5','50',2060,'35','2',3888331.63,3891001.22,2669.59,1735233.50,0.00,0.00,0.00,0.00,0.00),('21','237','5','50',2061,'42','2',2831681.09,2835808.72,4127.63,2682959.50,0.00,0.00,0.00,0.00,0.00),('21','237','5','50',2062,'43','2',2875658.96,2877352.25,1693.29,1100638.50,0.00,0.00,0.00,0.00,0.00),('21','237','6','50',2063,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','50',2064,'45','2',1943087.48,1944511.79,1424.31,925801.50,0.00,0.00,0.00,0.00,0.00),('21','237','6','50',2065,'46','2',4761199.08,4767705.43,6506.35,4229127.50,0.00,0.00,0.00,0.00,0.00),('21','237','6','50',2066,'47','2',4036599.15,4041313.65,4714.50,3064425.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','50',2067,'48','2',2456647.57,2459228.64,2581.07,1677695.50,0.00,0.00,0.00,0.00,0.00),('21','237','7','50',2068,'49','2',2776836.95,2779741.59,2904.64,1888016.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','50',2069,'50','1',955970.19,958912.43,2942.24,485469.60,0.00,0.00,0.00,0.00,0.00),('21','237','1','50',2070,'51','1',677851.76,677851.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','50',2071,'52','1',780846.21,780846.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','50',2072,'53','1',914192.60,917741.78,3549.18,585614.70,0.00,0.00,0.00,0.00,0.00),('21','237','2','50',2073,'54','1',611338.35,613124.28,1785.93,294678.45,0.00,0.00,0.00,0.00,0.00),('21','237','2','50',2074,'55','1',449158.64,449158.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','50',2075,'56','1',387365.01,387365.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','50',2076,'57','1',740822.06,744378.14,3556.08,586753.20,0.00,0.00,0.00,0.00,0.00),('21','237','3','50',2077,'58','1',727590.66,731191.49,3600.83,594136.95,0.00,0.00,0.00,0.00,0.00),('21','237','3','50',2078,'59','1',333606.86,333606.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','50',2079,'60','1',461797.08,461797.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','50',2080,'61','1',641029.14,643577.00,2547.86,420396.90,0.00,0.00,0.00,0.00,0.00),('21','237','4','50',2081,'62','1',210472.30,210472.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','50',2082,'63','1',603612.27,605487.57,1875.30,309424.50,0.00,0.00,0.00,0.00,0.00),('21','237','4','50',2083,'64','1',467450.27,467450.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','50',2084,'65','1',211234.33,212691.15,1456.82,240375.30,0.00,0.00,0.00,0.00,0.00),('21','237','1','51',2085,'1','1',1375400.30,1378252.71,2852.41,470647.65,0.00,0.00,0.00,0.00,0.00),('21','237','1','51',2086,'3','1',816896.37,816896.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','51',2087,'5','1',644628.65,644628.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','51',2088,'7','1',1397561.29,1400862.82,3301.53,544752.45,0.00,0.00,0.00,0.00,0.00),('21','237','2','51',2089,'9','1',727690.42,732862.41,5171.99,853378.35,0.00,0.00,0.00,0.00,0.00),('21','237','2','51',2090,'11','1',545511.37,547497.65,1986.28,327736.20,0.00,0.00,0.00,0.00,0.00),('21','237','2','51',2091,'13','1',356243.59,357279.40,1035.81,170908.65,0.00,0.00,0.00,0.00,0.00),('21','237','2','51',2092,'15','1',566052.58,567362.98,1310.40,216216.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','51',2093,'17','1',407300.63,407892.87,592.24,97719.60,0.00,0.00,0.00,0.00,0.00),('21','237','3','51',2094,'18','1',335714.78,335714.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','51',2095,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','51',2096,'23','1',432477.86,434023.69,1545.83,255061.95,0.00,0.00,0.00,0.00,0.00),('21','237','4','51',2097,'25','1',188227.15,188227.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','51',2098,'27','1',192496.43,192773.92,277.49,45785.85,0.00,0.00,0.00,0.00,0.00),('21','237','4','51',2099,'29','1',178892.99,178892.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','51',2100,'31','1',267725.85,267725.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','51',2101,'33','2',3446754.46,3450189.56,3435.10,2232815.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','51',2102,'35','2',3891001.22,3895516.27,4515.05,2934782.50,0.00,0.00,0.00,0.00,0.00),('21','237','5','51',2103,'42','2',2835808.72,2837504.49,1695.77,1102250.50,0.00,0.00,0.00,0.00,0.00),('21','237','5','51',2104,'43','2',2877352.25,2883301.81,5949.56,3867214.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','51',2105,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','51',2106,'45','2',1944511.79,1946872.29,2360.50,1534325.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','51',2107,'46','2',4767705.43,4775374.32,7668.89,4984778.50,0.00,0.00,0.00,0.00,0.00),('21','237','6','51',2108,'47','2',4041313.65,4045239.77,3926.12,2551978.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','51',2109,'48','2',2459228.64,2461042.40,1813.76,1178944.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','51',2110,'49','2',2779741.59,2784979.04,5237.45,3404342.50,0.00,0.00,0.00,0.00,0.00),('21','237','1','51',2111,'50','1',958912.43,961011.64,2099.21,346369.65,0.00,0.00,0.00,0.00,0.00),('21','237','1','51',2112,'51','1',677851.76,677851.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','51',2113,'52','1',780846.21,780846.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','51',2114,'53','1',917741.78,919581.15,1839.37,303496.05,0.00,0.00,0.00,0.00,0.00),('21','237','2','51',2115,'54','1',613124.28,614612.20,1487.92,245506.80,0.00,0.00,0.00,0.00,0.00),('21','237','2','51',2116,'55','1',449158.64,450313.91,1155.27,190619.55,0.00,0.00,0.00,0.00,0.00),('21','237','2','51',2117,'56','1',387365.01,388858.04,1493.03,246349.95,0.00,0.00,0.00,0.00,0.00),('21','237','2','51',2118,'57','1',744378.14,746353.71,1975.57,325969.05,0.00,0.00,0.00,0.00,0.00),('21','237','3','51',2119,'58','1',731191.49,733036.87,1845.38,304487.70,0.00,0.00,0.00,0.00,0.00),('21','237','3','51',2120,'59','1',333606.86,333606.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','51',2121,'60','1',461797.08,463728.48,1931.40,318681.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','51',2122,'61','1',643577.00,647083.30,3506.30,578539.50,0.00,0.00,0.00,0.00,0.00),('21','237','4','51',2123,'62','1',210472.30,210472.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','51',2124,'63','1',605487.57,607503.06,2015.49,332555.85,0.00,0.00,0.00,0.00,0.00),('21','237','4','51',2125,'64','1',467450.27,467450.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','51',2126,'65','1',212691.15,212691.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','52',2127,'1','1',1378252.71,1381185.41,2932.70,483895.50,0.00,0.00,0.00,0.00,0.00),('21','237','1','52',2128,'3','1',816896.37,818929.23,2032.86,335421.90,0.00,0.00,0.00,0.00,0.00),('21','237','1','52',2129,'5','1',644628.65,644964.64,335.99,55438.35,0.00,0.00,0.00,0.00,0.00),('21','237','1','52',2130,'7','1',1400862.82,1403338.38,2475.56,408467.40,0.00,0.00,0.00,0.00,0.00),('21','237','2','52',2131,'9','1',732862.41,735157.11,2294.70,378625.50,0.00,0.00,0.00,0.00,0.00),('21','237','2','52',2132,'11','1',547497.65,548677.69,1180.04,194706.60,0.00,0.00,0.00,0.00,0.00),('21','237','2','52',2133,'13','1',357279.40,357279.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','52',2134,'15','1',567362.98,568993.83,1630.85,269090.25,0.00,0.00,0.00,0.00,0.00),('21','237','3','52',2135,'17','1',407892.87,408237.49,344.62,56862.30,0.00,0.00,0.00,0.00,0.00),('21','237','3','52',2136,'18','1',335714.78,335714.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','52',2137,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','52',2138,'23','1',434023.69,434030.07,6.38,1052.70,0.00,0.00,0.00,0.00,0.00),('21','237','4','52',2139,'25','1',188227.15,188228.71,1.56,257.40,0.00,0.00,0.00,0.00,0.00),('21','237','4','52',2140,'27','1',192773.92,192914.89,140.97,23260.05,0.00,0.00,0.00,0.00,0.00),('21','237','4','52',2141,'29','1',178892.99,179072.41,179.42,29604.30,0.00,0.00,0.00,0.00,0.00),('21','237','4','52',2142,'31','1',267725.85,268378.35,652.50,107662.50,0.00,0.00,0.00,0.00,0.00),('21','237','5','52',2143,'33','2',3450189.56,3453055.08,2865.52,1862588.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','52',2144,'35','2',3895516.27,3899679.09,4162.82,2705833.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','52',2145,'42','2',2837504.49,2839922.99,2418.50,1572025.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','52',2146,'43','2',2883301.81,2885831.87,2530.06,1644539.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','52',2147,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','52',2148,'45','2',1946872.29,1948324.98,1452.69,944248.50,0.00,0.00,0.00,0.00,0.00),('21','237','6','52',2149,'46','2',4775374.32,4783371.29,7996.97,5198030.50,0.00,0.00,0.00,0.00,0.00),('21','237','6','52',2150,'47','2',4045239.77,4048487.21,3247.44,2110836.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','52',2151,'48','2',2461042.40,2464261.73,3219.33,2092564.50,0.00,0.00,0.00,0.00,0.00),('21','237','7','52',2152,'49','2',2784979.04,2789243.81,4264.77,2772100.50,0.00,0.00,0.00,0.00,0.00),('21','237','1','52',2153,'50','1',961011.64,962666.28,1654.64,273015.60,0.00,0.00,0.00,0.00,0.00),('21','237','1','52',2154,'51','1',677851.76,677853.23,1.47,242.55,0.00,0.00,0.00,0.00,0.00),('21','237','1','52',2155,'52','1',780846.21,783312.71,2466.50,406972.50,0.00,0.00,0.00,0.00,0.00),('21','237','1','52',2156,'53','1',919581.15,920893.85,1312.70,216595.50,0.00,0.00,0.00,0.00,0.00),('21','237','2','52',2157,'54','1',614612.20,616248.34,1636.14,269963.10,0.00,0.00,0.00,0.00,0.00),('21','237','2','52',2158,'55','1',450313.91,451763.89,1449.98,239246.70,0.00,0.00,0.00,0.00,0.00),('21','237','2','52',2159,'56','1',388858.04,389758.90,900.86,148641.90,0.00,0.00,0.00,0.00,0.00),('21','237','2','52',2160,'57','1',746353.71,747988.81,1635.10,269791.50,0.00,0.00,0.00,0.00,0.00),('21','237','3','52',2161,'58','1',733036.87,734871.89,1835.02,302778.30,0.00,0.00,0.00,0.00,0.00),('21','237','3','52',2162,'59','1',333606.86,333606.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','52',2163,'60','1',463728.48,464110.36,381.88,63010.20,0.00,0.00,0.00,0.00,0.00),('21','237','3','52',2164,'61','1',647083.30,648324.44,1241.14,204788.10,0.00,0.00,0.00,0.00,0.00),('21','237','4','52',2165,'62','1',210472.30,210472.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','52',2166,'63','1',607503.06,609341.72,1838.66,303378.90,0.00,0.00,0.00,0.00,0.00),('21','237','4','52',2167,'64','1',467450.27,468675.86,1225.59,202222.35,0.00,0.00,0.00,0.00,0.00),('21','237','4','52',2168,'65','1',212691.15,214753.97,2062.82,340365.30,0.00,0.00,0.00,0.00,0.00),('21','237','1','53',2169,'1','1',1381185.41,1383658.78,2473.37,408106.05,0.00,0.00,0.00,0.00,0.00),('21','237','1','53',2170,'3','1',818929.23,821778.28,2849.05,470093.25,0.00,0.00,0.00,0.00,0.00),('21','237','1','53',2171,'5','1',644964.64,645444.47,479.83,79171.95,0.00,0.00,0.00,0.00,0.00),('21','237','1','53',2172,'7','1',1403338.38,1405709.45,2371.07,391226.55,0.00,0.00,0.00,0.00,0.00),('21','237','2','53',2173,'9','1',735157.11,737218.96,2061.85,340205.25,0.00,0.00,0.00,0.00,0.00),('21','237','2','53',2174,'11','1',548677.69,549777.12,1099.43,181405.95,0.00,0.00,0.00,0.00,0.00),('21','237','2','53',2175,'13','1',357279.40,358512.93,1233.53,203532.45,0.00,0.00,0.00,0.00,0.00),('21','237','2','53',2176,'15','1',568993.83,569704.49,710.66,117258.90,0.00,0.00,0.00,0.00,0.00),('21','237','3','53',2177,'17','1',408237.49,411236.41,2998.92,494821.80,0.00,0.00,0.00,0.00,0.00),('21','237','3','53',2178,'18','1',335714.78,335714.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','53',2179,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','53',2180,'23','1',434030.07,434030.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','53',2181,'25','1',188228.71,188230.18,1.47,242.55,0.00,0.00,0.00,0.00,0.00),('21','237','4','53',2182,'27','1',192914.89,193117.07,202.18,33359.70,0.00,0.00,0.00,0.00,0.00),('21','237','4','53',2183,'29','1',179072.41,179072.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','53',2184,'31','1',268378.35,268636.68,258.33,42624.45,0.00,0.00,0.00,0.00,0.00),('21','237','5','53',2185,'33','2',3453055.08,3457853.26,4798.18,3118817.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','53',2186,'35','2',3899679.09,3909268.25,9589.16,6232954.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','53',2187,'42','2',2839922.99,2845813.85,5890.86,3829059.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','53',2188,'43','2',2885831.87,2892921.43,7089.56,4608214.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','53',2189,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','53',2190,'45','2',1948324.98,1952926.76,4601.78,2991157.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','53',2191,'46','2',4783371.29,4790509.74,7138.45,4639992.50,0.00,0.00,0.00,0.00,0.00),('21','237','6','53',2192,'47','2',4048487.21,4058308.53,9821.32,6383858.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','53',2193,'48','2',2464261.73,2470629.73,6368.00,4139200.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','53',2194,'49','2',2789243.81,2798304.06,9060.25,5889162.50,0.00,0.00,0.00,0.00,0.00),('21','237','1','53',2195,'50','1',962666.28,964160.38,1494.10,246526.50,0.00,0.00,0.00,0.00,0.00),('21','237','1','53',2196,'51','1',677853.23,677853.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','53',2197,'52','1',783312.71,786205.04,2892.33,477234.45,0.00,0.00,0.00,0.00,0.00),('21','237','1','53',2198,'53','1',920893.85,921553.25,659.40,108801.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','53',2199,'54','1',616248.34,616846.27,597.93,98658.45,0.00,0.00,0.00,0.00,0.00),('21','237','2','53',2200,'55','1',451763.89,453174.67,1410.78,232778.70,0.00,0.00,0.00,0.00,0.00),('21','237','2','53',2201,'56','1',389758.90,391046.48,1287.58,212450.70,0.00,0.00,0.00,0.00,0.00),('21','237','2','53',2202,'57','1',747988.81,749368.24,1379.43,227605.95,0.00,0.00,0.00,0.00,0.00),('21','237','3','53',2203,'58','1',734871.89,735422.78,550.89,90896.85,0.00,0.00,0.00,0.00,0.00),('21','237','3','53',2204,'59','1',333606.86,334323.08,716.22,118176.30,0.00,0.00,0.00,0.00,0.00),('21','237','3','53',2205,'60','1',464110.36,464876.96,766.60,126489.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','53',2206,'61','1',648324.44,649142.17,817.73,134925.45,0.00,0.00,0.00,0.00,0.00),('21','237','4','53',2207,'62','1',210472.30,210472.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','53',2208,'63','1',609341.72,610762.19,1420.47,234377.55,0.00,0.00,0.00,0.00,0.00),('21','237','4','53',2209,'64','1',468675.86,470248.35,1572.49,259460.85,0.00,0.00,0.00,0.00,0.00),('21','237','4','53',2210,'65','1',214753.97,216312.65,1558.68,257182.20,0.00,0.00,0.00,0.00,0.00),('21','237','1','54',2211,'1','1',1383658.78,1386927.80,3269.02,539388.30,0.00,0.00,0.00,0.00,0.00),('21','237','1','54',2212,'3','1',821778.28,823919.42,2141.14,353288.10,0.00,0.00,0.00,0.00,0.00),('21','237','1','54',2213,'5','1',645444.47,645565.99,121.52,20050.80,0.00,0.00,0.00,0.00,0.00),('21','237','1','54',2214,'7','1',1405709.45,1407492.22,1782.77,294157.05,0.00,0.00,0.00,0.00,0.00),('21','237','2','54',2215,'9','1',737218.96,739849.90,2630.94,434105.10,0.00,0.00,0.00,0.00,0.00),('21','237','2','54',2216,'11','1',549777.12,551926.29,2149.17,354613.05,0.00,0.00,0.00,0.00,0.00),('21','237','2','54',2217,'13','1',358512.93,358888.59,375.66,61983.90,0.00,0.00,0.00,0.00,0.00),('21','237','2','54',2218,'15','1',569704.49,569704.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','54',2219,'17','1',411236.41,411236.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','54',2220,'18','1',335714.78,335714.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','54',2221,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','54',2222,'23','1',434030.07,434543.49,513.42,84714.30,0.00,0.00,0.00,0.00,0.00),('21','237','4','54',2223,'25','1',188230.18,188230.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','54',2224,'27','1',193117.07,193117.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','54',2225,'29','1',179072.41,179072.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','54',2226,'31','1',268636.68,268636.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','54',2227,'33','2',3457853.26,3459184.26,1331.00,865150.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','54',2228,'35','2',3909268.25,3918925.62,9657.37,6277290.50,0.00,0.00,0.00,0.00,0.00),('21','237','5','54',2229,'42','2',2845813.85,2848307.70,2493.85,1621002.50,0.00,0.00,0.00,0.00,0.00),('21','237','5','54',2230,'43','2',2892921.43,2895457.59,2536.16,1648504.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','54',2231,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','54',2232,'45','2',1952926.76,1958711.92,5785.16,3760354.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','54',2233,'46','2',4790509.74,4798524.30,8014.56,5209464.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','54',2234,'47','2',4058308.53,4063104.71,4796.18,3117517.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','54',2235,'48','2',2470629.73,2476779.57,6149.84,3997396.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','54',2236,'49','2',2798304.06,2803572.58,5268.52,3424538.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','54',2237,'50','1',964160.38,965990.15,1829.77,301912.05,0.00,0.00,0.00,0.00,0.00),('21','237','1','54',2238,'51','1',677853.23,677853.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','54',2239,'52','1',786205.04,789880.42,3675.38,606437.70,0.00,0.00,0.00,0.00,0.00),('21','237','1','54',2240,'53','1',921553.25,923569.52,2016.27,332684.55,0.00,0.00,0.00,0.00,0.00),('21','237','2','54',2241,'54','1',616846.27,619043.48,2197.21,362539.65,0.00,0.00,0.00,0.00,0.00),('21','237','2','54',2242,'55','1',453174.67,453553.44,378.77,62497.05,0.00,0.00,0.00,0.00,0.00),('21','237','2','54',2243,'56','1',391046.48,392523.30,1476.82,243675.30,0.00,0.00,0.00,0.00,0.00),('21','237','2','54',2244,'57','1',749368.24,751411.44,2043.20,337128.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','54',2245,'58','1',735422.78,736814.91,1392.13,229701.45,0.00,0.00,0.00,0.00,0.00),('21','237','3','54',2246,'59','1',334323.08,334323.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','54',2247,'60','1',464876.96,466067.43,1190.47,196427.55,0.00,0.00,0.00,0.00,0.00),('21','237','3','54',2248,'61','1',649142.17,649740.12,597.95,98661.75,0.00,0.00,0.00,0.00,0.00),('21','237','4','54',2249,'62','1',210472.30,210474.14,1.84,303.60,0.00,0.00,0.00,0.00,0.00),('21','237','4','54',2250,'63','1',610762.19,612580.08,1817.89,299951.85,0.00,0.00,0.00,0.00,0.00),('21','237','4','54',2251,'64','1',470248.35,472395.62,2147.27,354299.55,0.00,0.00,0.00,0.00,0.00),('21','237','4','54',2252,'65','1',216312.65,218223.32,1910.67,315260.55,0.00,0.00,0.00,0.00,0.00),('21','237','1','55',2253,'1','1',1386927.80,1388659.29,1731.49,285695.85,0.00,0.00,0.00,0.00,0.00),('21','237','1','55',2254,'3','1',823919.42,827258.66,3339.24,550974.60,0.00,0.00,0.00,0.00,0.00),('21','237','1','55',2255,'5','1',645565.99,645951.61,385.62,63627.30,0.00,0.00,0.00,0.00,0.00),('21','237','1','55',2256,'7','1',1407492.22,1411167.56,3675.34,606431.10,0.00,0.00,0.00,0.00,0.00),('21','237','2','55',2257,'9','1',739849.90,742472.85,2622.95,432786.75,0.00,0.00,0.00,0.00,0.00),('21','237','2','55',2258,'11','1',551926.29,551926.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','55',2259,'13','1',358888.59,359954.56,1065.97,175885.05,0.00,0.00,0.00,0.00,0.00),('21','237','2','55',2260,'15','1',569704.49,569704.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','55',2261,'17','1',411236.41,411236.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','55',2262,'18','1',335714.78,335714.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','55',2263,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','55',2264,'23','1',434543.49,434902.44,358.95,59226.75,0.00,0.00,0.00,0.00,0.00),('21','237','4','55',2265,'25','1',188230.18,188230.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','55',2266,'27','1',193117.07,193439.22,322.15,53154.75,0.00,0.00,0.00,0.00,0.00),('21','237','4','55',2267,'29','1',179072.41,179072.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','55',2268,'31','1',268636.68,268636.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','55',2269,'33','2',3459184.26,3464128.70,4944.44,3213886.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','55',2270,'35','2',3918925.62,3926557.87,7632.25,4960962.50,0.00,0.00,0.00,0.00,0.00),('21','237','5','55',2271,'42','2',2848307.70,2851997.12,3689.42,2398123.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','55',2272,'43','2',2895457.59,2903452.94,7995.35,5196977.50,0.00,0.00,0.00,0.00,0.00),('21','237','6','55',2273,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','55',2274,'45','2',1958711.92,1963207.93,4496.01,2922406.50,0.00,0.00,0.00,0.00,0.00),('21','237','6','55',2275,'46','2',4798524.30,4807028.39,8504.09,5527658.50,0.00,0.00,0.00,0.00,0.00),('21','237','6','55',2276,'47','2',4063104.71,4069177.11,6072.40,3947060.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','55',2277,'48','2',2476779.57,2481540.91,4761.34,3094871.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','55',2278,'49','2',2803572.58,2812974.40,9401.82,6111183.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','55',2279,'50','1',965990.15,968002.62,2012.47,332057.55,0.00,0.00,0.00,0.00,0.00),('21','237','1','55',2280,'51','1',677853.23,677853.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','55',2281,'52','1',789880.42,792862.88,2982.46,492105.90,0.00,0.00,0.00,0.00,0.00),('21','237','1','55',2282,'53','1',923569.52,924374.03,804.51,132744.15,0.00,0.00,0.00,0.00,0.00),('21','237','2','55',2283,'54','1',619043.48,621255.56,2212.08,364993.20,0.00,0.00,0.00,0.00,0.00),('21','237','2','55',2284,'55','1',453553.44,454346.15,792.71,130797.15,0.00,0.00,0.00,0.00,0.00),('21','237','2','55',2285,'56','1',392523.30,395272.43,2749.13,453606.45,0.00,0.00,0.00,0.00,0.00),('21','237','2','55',2286,'57','1',751411.44,751791.35,379.91,62685.15,0.00,0.00,0.00,0.00,0.00),('21','237','3','55',2287,'58','1',736814.91,739056.11,2241.20,369798.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','55',2288,'59','1',334323.08,334323.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','55',2289,'60','1',466067.43,467171.39,1103.96,182153.40,0.00,0.00,0.00,0.00,0.00),('21','237','3','55',2290,'61','1',649740.12,650880.61,1140.49,188180.85,0.00,0.00,0.00,0.00,0.00),('21','237','4','55',2291,'62','1',210474.14,210795.39,321.25,53006.25,0.00,0.00,0.00,0.00,0.00),('21','237','4','55',2292,'63','1',612580.08,614535.25,1955.17,322603.05,0.00,0.00,0.00,0.00,0.00),('21','237','4','55',2293,'64','1',472395.62,473687.45,1291.83,213151.95,0.00,0.00,0.00,0.00,0.00),('21','237','4','55',2294,'65','1',218223.32,220220.20,1996.88,329485.20,0.00,0.00,0.00,0.00,0.00),('21','237','1','56',2295,'1','1',1388659.29,1388659.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','56',2296,'3','1',827258.66,827258.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','56',2297,'5','1',645951.61,645951.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','56',2298,'7','1',1411167.56,1411167.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','56',2299,'9','1',742472.85,742472.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','56',2300,'11','1',551926.29,551926.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','56',2301,'13','1',359954.56,359954.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','56',2302,'15','1',569704.49,569704.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','56',2303,'17','1',411236.41,411236.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','56',2304,'18','1',335714.78,335714.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','56',2305,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','56',2306,'23','1',434902.44,434902.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','56',2307,'25','1',188230.18,188230.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','56',2308,'27','1',193439.22,193439.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','56',2309,'29','1',179072.41,179072.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','56',2310,'31','1',268636.68,268636.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','56',2311,'33','2',3464128.70,3464128.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','56',2312,'35','2',3926557.87,3926557.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','56',2313,'42','2',2851997.12,2851997.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','56',2314,'43','2',2903452.94,2903452.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','56',2315,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','56',2316,'45','2',1963207.93,1963207.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','56',2317,'46','2',4807028.39,4807028.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','56',2318,'47','2',4069177.11,4069177.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','56',2319,'48','2',2481540.91,2481540.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','56',2320,'49','2',2812974.40,2812974.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','56',2321,'50','1',968002.62,968002.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','56',2322,'51','1',677853.23,677853.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','56',2323,'52','1',792862.88,792862.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','56',2324,'53','1',924374.03,924374.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','56',2325,'54','1',621255.56,621255.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','56',2326,'55','1',454346.15,454346.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','56',2327,'56','1',395272.43,395272.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','56',2328,'57','1',751791.35,751791.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','56',2329,'58','1',739056.11,739056.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','56',2330,'59','1',334323.08,334323.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','56',2331,'60','1',467171.39,467171.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','56',2332,'61','1',650880.61,650880.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','56',2333,'62','1',210795.39,210795.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','56',2334,'63','1',614535.25,614535.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','56',2335,'64','1',473687.45,473687.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','56',2336,'65','1',220220.20,220220.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','57',2337,'1','1',1388659.29,1390013.44,1354.15,223434.75,0.00,0.00,0.00,0.00,0.00),('21','237','1','57',2338,'3','1',827258.66,830850.81,3592.15,592704.75,0.00,0.00,0.00,0.00,0.00),('21','237','1','57',2339,'5','1',645951.61,646244.66,293.05,48353.25,0.00,0.00,0.00,0.00,0.00),('21','237','1','57',2340,'7','1',1411167.56,1413249.54,2081.98,343526.70,0.00,0.00,0.00,0.00,0.00),('21','237','2','57',2341,'9','1',742472.85,743058.36,585.51,96609.15,0.00,0.00,0.00,0.00,0.00),('21','237','2','57',2342,'11','1',551926.29,553203.86,1277.57,210799.05,0.00,0.00,0.00,0.00,0.00),('21','237','2','57',2343,'13','1',359954.56,359954.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','57',2344,'15','1',569704.49,569777.35,72.86,12021.90,0.00,0.00,0.00,0.00,0.00),('21','237','3','57',2345,'17','1',411236.41,411987.12,750.71,123867.15,0.00,0.00,0.00,0.00,0.00),('21','237','3','57',2346,'18','1',335714.78,335714.82,0.04,6.60,0.00,0.00,0.00,0.00,0.00),('21','237','3','57',2347,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','57',2348,'23','1',434902.44,435530.43,627.99,103618.35,0.00,0.00,0.00,0.00,0.00),('21','237','4','57',2349,'25','1',188230.18,188231.36,1.18,194.70,0.00,0.00,0.00,0.00,0.00),('21','237','4','57',2350,'27','1',193439.22,193639.45,200.23,33037.95,0.00,0.00,0.00,0.00,0.00),('21','237','4','57',2351,'29','1',179072.41,179072.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','57',2352,'31','1',268636.68,270729.88,2093.20,345378.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','57',2353,'33','2',3464128.70,3470381.66,6252.96,4064424.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','57',2354,'35','2',3926557.87,3932770.77,6212.90,4038385.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','57',2355,'42','2',2851997.12,2854515.20,2518.08,1636752.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','57',2356,'43','2',2903452.94,2906362.98,2910.04,1891526.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','57',2357,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','57',2358,'45','2',1963207.93,1967352.19,4144.26,2693769.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','57',2359,'46','2',4807028.39,4813360.28,6331.89,4115728.50,0.00,0.00,0.00,0.00,0.00),('21','237','6','57',2360,'47','2',4069177.11,4072926.50,3749.39,2437103.50,0.00,0.00,0.00,0.00,0.00),('21','237','7','57',2361,'48','2',2481540.91,2485010.39,3469.48,2255162.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','57',2362,'49','2',2812974.40,2817980.69,5006.29,3254088.50,0.00,0.00,0.00,0.00,0.00),('21','237','1','57',2363,'50','1',968002.62,970548.46,2545.84,420063.60,0.00,0.00,0.00,0.00,0.00),('21','237','1','57',2364,'51','1',677853.23,677853.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','57',2365,'52','1',792862.88,795324.55,2461.67,406175.55,0.00,0.00,0.00,0.00,0.00),('21','237','1','57',2366,'53','1',924374.03,925631.37,1257.34,207461.10,0.00,0.00,0.00,0.00,0.00),('21','237','2','57',2367,'54','1',621255.56,622864.52,1608.96,265478.40,0.00,0.00,0.00,0.00,0.00),('21','237','2','57',2368,'55','1',454346.15,456678.42,2332.27,384824.55,0.00,0.00,0.00,0.00,0.00),('21','237','2','57',2369,'56','1',395272.43,397466.91,2194.48,362089.20,0.00,0.00,0.00,0.00,0.00),('21','237','2','57',2370,'57','1',751791.35,753108.43,1317.08,217318.20,0.00,0.00,0.00,0.00,0.00),('21','237','3','57',2371,'58','1',739056.11,740429.44,1373.33,226599.45,0.00,0.00,0.00,0.00,0.00),('21','237','3','57',2372,'59','1',334323.08,335860.41,1537.33,253659.45,0.00,0.00,0.00,0.00,0.00),('21','237','3','57',2373,'60','1',467171.39,467171.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','57',2374,'61','1',650880.61,652420.78,1540.17,254128.05,0.00,0.00,0.00,0.00,0.00),('21','237','4','57',2375,'62','1',210795.39,210795.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','57',2376,'63','1',614535.25,616089.18,1553.93,256398.45,0.00,0.00,0.00,0.00,0.00),('21','237','4','57',2377,'64','1',473687.45,473687.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','57',2378,'65','1',220220.20,221258.90,1038.70,171385.50,0.00,0.00,0.00,0.00,0.00),('21','237','1','58',2379,'1','1',1390013.44,1392383.81,2370.37,391111.05,0.00,0.00,0.00,0.00,0.00),('21','237','1','58',2380,'3','1',830850.81,833657.59,2806.78,463118.70,0.00,0.00,0.00,0.00,0.00),('21','237','1','58',2381,'5','1',646244.66,646244.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','58',2382,'7','1',1413249.54,1415217.73,1968.19,324751.35,0.00,0.00,0.00,0.00,0.00),('21','237','2','58',2383,'9','1',743058.36,744658.09,1599.73,263955.45,0.00,0.00,0.00,0.00,0.00),('21','237','2','58',2384,'11','1',553203.86,555833.55,2629.69,433898.85,0.00,0.00,0.00,0.00,0.00),('21','237','2','58',2385,'13','1',359954.56,359954.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','58',2386,'15','1',569777.35,569777.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','58',2387,'17','1',411987.12,411987.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','58',2388,'18','1',335714.82,335714.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','58',2389,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','58',2390,'23','1',435530.43,435530.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','58',2391,'25','1',188231.36,188231.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','58',2392,'27','1',193639.45,193944.55,305.10,50341.50,0.00,0.00,0.00,0.00,0.00),('21','237','4','58',2393,'29','1',179072.41,179072.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','58',2394,'31','1',270729.88,272018.37,1288.49,212600.85,0.00,0.00,0.00,0.00,0.00),('21','237','5','58',2395,'33','2',3470381.66,3474204.48,3822.82,2637745.80,0.00,0.00,0.00,0.00,0.00),('21','237','5','58',2396,'35','2',3932770.77,3939908.46,7137.69,4925006.10,0.00,0.00,0.00,0.00,0.00),('21','237','5','58',2397,'42','2',2854515.20,2860732.59,6217.39,4289999.10,0.00,0.00,0.00,0.00,0.00),('21','237','5','58',2398,'43','2',2906362.98,2913442.45,7079.47,4884834.30,0.00,0.00,0.00,0.00,0.00),('21','237','6','58',2399,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','58',2400,'45','2',1967352.19,1972421.80,5069.61,3498030.90,0.00,0.00,0.00,0.00,0.00),('21','237','6','58',2401,'46','2',4813360.28,4822119.91,8759.63,6044144.70,0.00,0.00,0.00,0.00,0.00),('21','237','6','58',2402,'47','2',4072926.50,4078612.16,5685.66,3923105.40,0.00,0.00,0.00,0.00,0.00),('21','237','7','58',2403,'48','2',2485010.39,2491120.69,6110.30,4216107.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','58',2404,'49','2',2817980.69,2824706.77,6726.08,4640995.20,0.00,0.00,0.00,0.00,0.00),('21','237','1','58',2405,'50','1',970548.46,972237.09,1688.63,278623.95,0.00,0.00,0.00,0.00,0.00),('21','237','1','58',2406,'51','1',677853.23,677853.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','58',2407,'52','1',795324.55,798181.61,2857.06,471414.90,0.00,0.00,0.00,0.00,0.00),('21','237','1','58',2408,'53','1',925631.37,927568.11,1936.74,319562.10,0.00,0.00,0.00,0.00,0.00),('21','237','2','58',2409,'54','1',622864.52,624134.39,1269.87,209528.55,0.00,0.00,0.00,0.00,0.00),('21','237','2','58',2410,'55','1',456678.42,457181.95,503.53,83082.45,0.00,0.00,0.00,0.00,0.00),('21','237','2','58',2411,'56','1',397466.91,401086.75,3619.84,597273.60,0.00,0.00,0.00,0.00,0.00),('21','237','2','58',2412,'57','1',753108.43,757285.72,4177.29,689252.85,0.00,0.00,0.00,0.00,0.00),('21','237','3','58',2413,'58','1',740429.44,740710.24,280.80,46332.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','58',2414,'59','1',335860.41,335860.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','58',2415,'60','1',467171.39,467923.68,752.29,124127.85,0.00,0.00,0.00,0.00,0.00),('21','237','3','58',2416,'61','1',652420.78,652420.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','58',2417,'62','1',210795.39,212890.49,2095.10,345691.50,0.00,0.00,0.00,0.00,0.00),('21','237','4','58',2418,'63','1',616089.18,618510.66,2421.48,399544.20,0.00,0.00,0.00,0.00,0.00),('21','237','4','58',2419,'64','1',473687.45,475890.86,2203.41,363562.65,0.00,0.00,0.00,0.00,0.00),('21','237','4','58',2420,'65','1',221258.90,223324.55,2065.65,340832.25,0.00,0.00,0.00,0.00,0.00),('21','237','1','59',2421,'1','1',1392383.81,1394084.73,1700.92,280651.80,0.00,0.00,0.00,0.00,0.00),('21','237','1','59',2422,'3','1',833657.59,833657.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','59',2423,'5','1',646244.66,648660.58,2415.92,398626.80,0.00,0.00,0.00,0.00,0.00),('21','237','1','59',2424,'7','1',1415217.73,1417407.67,2189.94,361340.10,0.00,0.00,0.00,0.00,0.00),('21','237','2','59',2425,'9','1',744658.09,747097.15,2439.06,402444.90,0.00,0.00,0.00,0.00,0.00),('21','237','2','59',2426,'11','1',555833.55,558478.82,2645.27,436469.55,0.00,0.00,0.00,0.00,0.00),('21','237','2','59',2427,'13','1',359954.56,360114.91,160.35,26457.75,0.00,0.00,0.00,0.00,0.00),('21','237','2','59',2428,'15','1',569777.35,569777.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','59',2429,'17','1',411987.12,412580.31,593.19,97876.35,0.00,0.00,0.00,0.00,0.00),('21','237','3','59',2430,'18','1',335714.82,335714.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','59',2431,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','59',2432,'23','1',435530.43,435530.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','59',2433,'25','1',188231.36,188231.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','59',2434,'27','1',193944.55,193944.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','59',2435,'29','1',179072.41,179072.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','59',2436,'31','1',272018.37,272024.43,6.06,999.90,0.00,0.00,0.00,0.00,0.00),('21','237','5','59',2437,'33','2',3474204.48,3477722.54,3518.06,2427461.40,0.00,0.00,0.00,0.00,0.00),('21','237','5','59',2438,'35','2',3939908.46,3943957.89,4049.43,2794106.70,0.00,0.00,0.00,0.00,0.00),('21','237','5','59',2439,'42','2',2860732.59,2862363.38,1630.79,1125245.10,0.00,0.00,0.00,0.00,0.00),('21','237','5','59',2440,'43','2',2913442.45,2920099.21,6656.76,4593164.40,0.00,0.00,0.00,0.00,0.00),('21','237','6','59',2441,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','59',2442,'45','2',1972421.80,1974173.71,1751.91,1208817.90,0.00,0.00,0.00,0.00,0.00),('21','237','6','59',2443,'46','2',4822119.91,4828262.10,6142.19,4238111.10,0.00,0.00,0.00,0.00,0.00),('21','237','6','59',2444,'47','2',4078612.16,4081967.38,3355.22,2315101.80,0.00,0.00,0.00,0.00,0.00),('21','237','7','59',2445,'48','2',2491120.69,2493365.70,2245.01,1549056.90,0.00,0.00,0.00,0.00,0.00),('21','237','7','59',2446,'49','2',2824706.77,2827494.22,2787.45,1923340.50,0.00,0.00,0.00,0.00,0.00),('21','237','1','59',2447,'50','1',972237.09,974358.72,2121.63,350068.95,0.00,0.00,0.00,0.00,0.00),('21','237','1','59',2448,'51','1',677853.23,677853.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','59',2449,'52','1',798181.61,798181.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','59',2450,'53','1',927568.11,929668.94,2100.83,346636.95,0.00,0.00,0.00,0.00,0.00),('21','237','2','59',2451,'54','1',624134.39,626485.10,2350.71,387867.15,0.00,0.00,0.00,0.00,0.00),('21','237','2','59',2452,'55','1',457181.95,458434.37,1252.42,206649.30,0.00,0.00,0.00,0.00,0.00),('21','237','2','59',2453,'56','1',401086.75,401811.22,724.47,119537.55,0.00,0.00,0.00,0.00,0.00),('21','237','2','59',2454,'57','1',757285.72,760723.66,3437.94,567260.10,0.00,0.00,0.00,0.00,0.00),('21','237','3','59',2455,'58','1',740710.24,741794.13,1083.89,178841.85,0.00,0.00,0.00,0.00,0.00),('21','237','3','59',2456,'59','1',335860.41,335860.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','59',2457,'60','1',467923.68,468816.05,892.37,147241.05,0.00,0.00,0.00,0.00,0.00),('21','237','3','59',2458,'61','1',652420.78,654237.92,1817.14,299828.10,0.00,0.00,0.00,0.00,0.00),('21','237','4','59',2459,'62','1',212890.49,214164.22,1273.73,210165.45,0.00,0.00,0.00,0.00,0.00),('21','237','4','59',2460,'63','1',618510.66,621107.85,2597.19,428536.35,0.00,0.00,0.00,0.00,0.00),('21','237','4','59',2461,'64','1',475890.86,478064.68,2173.82,358680.30,0.00,0.00,0.00,0.00,0.00),('21','237','4','59',2462,'65','1',223324.55,225495.61,2171.06,358224.90,0.00,0.00,0.00,0.00,0.00),('21','237','1','60',2463,'1','1',1394084.73,1394084.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','60',2464,'3','1',833657.59,833657.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','60',2465,'5','1',648660.58,648660.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','60',2466,'7','1',1417407.67,1417407.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','60',2467,'9','1',747097.15,747097.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','60',2468,'11','1',558478.82,558478.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','60',2469,'13','1',360114.91,360114.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','60',2470,'15','1',569777.35,569777.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','60',2471,'17','1',412580.31,412580.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','60',2472,'18','1',335714.82,335714.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','60',2473,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','60',2474,'23','1',435530.43,435530.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','60',2475,'25','1',188231.36,188231.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','60',2476,'27','1',193944.55,193944.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','60',2477,'29','1',179072.41,179072.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','60',2478,'31','1',272024.43,272024.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','60',2479,'33','2',3477722.54,3477722.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','60',2480,'35','2',3943957.89,3943957.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','60',2481,'42','2',2862363.38,2862363.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','60',2482,'43','2',2920099.21,2920099.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','60',2483,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','60',2484,'45','2',1974173.71,1974173.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','60',2485,'46','2',4828262.10,4828262.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','60',2486,'47','2',4081967.38,4081967.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','60',2487,'48','2',2493365.70,2493365.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','60',2488,'49','2',2827494.22,2827494.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','60',2489,'50','1',974358.72,974358.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','60',2490,'51','1',677853.23,677853.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','60',2491,'52','1',798181.61,798181.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','60',2492,'53','1',929668.94,929668.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','60',2493,'54','1',626485.10,626485.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','60',2494,'55','1',458434.37,458434.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','60',2495,'56','1',401811.22,401811.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','60',2496,'57','1',760723.66,760723.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','60',2497,'58','1',741794.13,741794.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','60',2498,'59','1',335860.41,335860.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','60',2499,'60','1',468816.05,468816.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','60',2500,'61','1',654237.92,654237.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','60',2501,'62','1',214164.22,214164.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','60',2502,'63','1',621107.85,621107.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','60',2503,'64','1',478064.68,478064.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','60',2504,'65','1',225495.61,225495.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','61',2505,'1','1',1394084.73,1394084.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','61',2506,'3','1',833657.59,833657.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','61',2507,'5','1',648660.58,648660.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','61',2508,'7','1',1417407.67,1417407.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','61',2509,'9','1',747097.15,747097.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','61',2510,'11','1',558478.82,558478.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','61',2511,'13','1',360114.91,360114.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','61',2512,'15','1',569777.35,569777.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','61',2513,'17','1',412580.31,412580.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','61',2514,'18','1',335714.82,335714.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','61',2515,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','61',2516,'23','1',435530.43,435530.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','61',2517,'25','1',188231.36,188231.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','61',2518,'27','1',193944.55,193944.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','61',2519,'29','1',179072.41,179072.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','61',2520,'31','1',272024.43,272024.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','61',2521,'33','2',3477722.54,3477722.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','61',2522,'35','2',3943957.89,3943957.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','61',2523,'42','2',2862363.38,2862363.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','61',2524,'43','2',2920099.21,2920099.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','61',2525,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','61',2526,'45','2',1974173.71,1974173.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','61',2527,'46','2',4828262.10,4828262.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','61',2528,'47','2',4081967.38,4081967.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','61',2529,'48','2',2493365.70,2493365.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','61',2530,'49','2',2827494.22,2827494.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','61',2531,'50','1',974358.72,974358.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','61',2532,'51','1',677853.23,677853.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','61',2533,'52','1',798181.61,798181.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','61',2534,'53','1',929668.94,929668.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','61',2535,'54','1',626485.10,626485.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','61',2536,'55','1',458434.37,458434.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','61',2537,'56','1',401811.22,401811.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','61',2538,'57','1',760723.66,760723.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','61',2539,'58','1',741794.13,741794.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','61',2540,'59','1',335860.41,335860.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','61',2541,'60','1',468816.05,468816.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','61',2542,'61','1',654237.92,654237.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','61',2543,'62','1',214164.22,214164.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','61',2544,'63','1',621107.85,621107.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','61',2545,'64','1',478064.68,478064.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','61',2546,'65','1',225495.61,225495.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','62',2547,'1','1',1394084.73,1395463.52,1378.79,227500.35,0.00,0.00,0.00,0.00,0.00),('21','237','1','62',2548,'3','1',833657.59,838151.71,4494.12,741529.80,0.00,0.00,0.00,0.00,0.00),('21','237','1','62',2549,'5','1',648660.58,649033.27,372.69,61493.85,0.00,0.00,0.00,0.00,0.00),('21','237','1','62',2550,'7','1',1417407.67,1419540.43,2132.76,351905.40,0.00,0.00,0.00,0.00,0.00),('21','237','2','62',2551,'9','1',747097.15,748437.19,1340.04,221106.60,0.00,0.00,0.00,0.00,0.00),('21','237','2','62',2552,'11','1',558478.82,560533.92,2055.10,339091.50,0.00,0.00,0.00,0.00,0.00),('21','237','2','62',2553,'13','1',360114.91,360302.39,187.48,30934.20,0.00,0.00,0.00,0.00,0.00),('21','237','2','62',2554,'15','1',569777.35,569777.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','62',2555,'17','1',412580.31,412992.47,412.16,68006.40,0.00,0.00,0.00,0.00,0.00),('21','237','3','62',2556,'18','1',335714.82,335722.09,7.27,1199.55,0.00,0.00,0.00,0.00,0.00),('21','237','3','62',2557,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','62',2558,'23','1',435530.43,435530.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','62',2559,'25','1',188231.36,188231.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','62',2560,'27','1',193944.55,194274.90,330.35,54507.75,0.00,0.00,0.00,0.00,0.00),('21','237','4','62',2561,'29','1',179072.41,179072.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','62',2562,'31','1',272024.43,272303.39,278.96,46028.40,0.00,0.00,0.00,0.00,0.00),('21','237','5','62',2563,'33','2',3477722.54,3479402.12,1679.58,1158910.20,0.00,0.00,0.00,0.00,0.00),('21','237','5','62',2564,'35','2',3943957.89,3945301.45,1343.56,927056.40,0.00,0.00,0.00,0.00,0.00),('21','237','5','62',2565,'42','2',2862363.38,2863962.88,1599.50,1103655.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','62',2566,'43','2',2920099.21,2921777.25,1678.04,1157847.60,0.00,0.00,0.00,0.00,0.00),('21','237','6','62',2567,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','62',2568,'45','2',1974173.71,1975972.71,1799.00,1241310.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','62',2569,'46','2',4828262.10,4831731.48,3469.38,2393872.20,0.00,0.00,0.00,0.00,0.00),('21','237','6','62',2570,'47','2',4081967.38,4084894.66,2927.28,2019823.20,0.00,0.00,0.00,0.00,0.00),('21','237','7','62',2571,'48','2',2493365.70,2496800.75,3435.05,2370184.50,0.00,0.00,0.00,0.00,0.00),('21','237','7','62',2572,'49','2',2827494.22,2828547.10,1052.88,726487.20,0.00,0.00,0.00,0.00,0.00),('21','237','1','62',2573,'50','1',974358.72,976167.51,1808.79,298450.35,0.00,0.00,0.00,0.00,0.00),('21','237','1','62',2574,'51','1',677853.23,677853.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','62',2575,'52','1',798181.61,801593.57,3411.96,562973.40,0.00,0.00,0.00,0.00,0.00),('21','237','1','62',2576,'53','1',929668.94,931499.18,1830.24,301989.60,0.00,0.00,0.00,0.00,0.00),('21','237','2','62',2577,'54','1',626485.10,627686.45,1201.35,198222.75,0.00,0.00,0.00,0.00,0.00),('21','237','2','62',2578,'55','1',458434.37,459271.46,837.09,138119.85,0.00,0.00,0.00,0.00,0.00),('21','237','2','62',2579,'56','1',401811.22,402817.85,1006.63,166093.95,0.00,0.00,0.00,0.00,0.00),('21','237','2','62',2580,'57','1',760723.66,763690.29,2966.63,489493.95,0.00,0.00,0.00,0.00,0.00),('21','237','3','62',2581,'58','1',741794.13,742210.15,416.02,68643.30,0.00,0.00,0.00,0.00,0.00),('21','237','3','62',2582,'59','1',335860.41,336723.90,863.49,142475.85,0.00,0.00,0.00,0.00,0.00),('21','237','3','62',2583,'60','1',468816.05,470627.19,1811.14,298838.10,0.00,0.00,0.00,0.00,0.00),('21','237','3','62',2584,'61','1',654237.92,654237.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','62',2585,'62','1',214164.22,214848.33,684.11,112878.15,0.00,0.00,0.00,0.00,0.00),('21','237','4','62',2586,'63','1',621107.85,622635.58,1527.73,252075.45,0.00,0.00,0.00,0.00,0.00),('21','237','4','62',2587,'64','1',478064.68,479852.21,1787.53,294942.45,0.00,0.00,0.00,0.00,0.00),('21','237','4','62',2588,'65','1',225495.61,227026.17,1530.56,252542.40,0.00,0.00,0.00,0.00,0.00),('21','237','1','63',2589,'1','1',1395463.52,1395463.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','63',2590,'3','1',838151.71,838151.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','63',2591,'5','1',649033.27,649033.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','63',2592,'7','1',1419540.43,1419540.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','63',2593,'9','1',748437.19,748437.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','63',2594,'11','1',560533.92,560533.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','63',2595,'13','1',360302.39,360302.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','63',2596,'15','1',569777.35,569777.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','63',2597,'17','1',412992.47,412992.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','63',2598,'18','1',335722.09,335722.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','63',2599,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','63',2600,'23','1',435530.43,435530.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','63',2601,'25','1',188231.36,188231.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','63',2602,'27','1',194274.90,194274.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','63',2603,'29','1',179072.41,179072.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','63',2604,'31','1',272303.39,272303.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','63',2605,'33','2',3479402.12,3479402.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','63',2606,'35','2',3945301.45,3945301.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','63',2607,'42','2',2863962.88,2863962.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','63',2608,'43','2',2921777.25,2921777.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','63',2609,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','63',2610,'45','2',1975972.71,1975972.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','63',2611,'46','2',4831731.48,4831731.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','63',2612,'47','2',4084894.66,4084894.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','63',2613,'48','2',2496800.75,2496800.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','63',2614,'49','2',2828547.10,2828547.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','63',2615,'50','1',976167.51,976167.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','63',2616,'51','1',677853.23,677853.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','63',2617,'52','1',801593.57,801593.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','63',2618,'53','1',931499.18,931499.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','63',2619,'54','1',627686.45,627686.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','63',2620,'55','1',459271.46,459271.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','63',2621,'56','1',402817.85,402817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','63',2622,'57','1',763690.29,763690.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','63',2623,'58','1',742210.15,742210.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','63',2624,'59','1',336723.90,336723.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','63',2625,'60','1',470627.19,470627.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','63',2626,'61','1',654237.92,654237.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','63',2627,'62','1',214848.33,214848.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','63',2628,'63','1',622635.58,622635.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','63',2629,'64','1',479852.21,479852.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','63',2630,'65','1',227026.17,227026.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','64',2631,'1','1',1395463.52,1395463.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','64',2632,'3','1',838151.71,838151.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','64',2633,'5','1',649033.27,649033.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','64',2634,'7','1',1419540.43,1419540.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','64',2635,'9','1',748437.19,748437.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','64',2636,'11','1',560533.92,560533.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','64',2637,'13','1',360302.39,360302.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','64',2638,'15','1',569777.35,569777.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','64',2639,'17','1',412992.47,412992.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','64',2640,'18','1',335722.09,335722.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','64',2641,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','64',2642,'23','1',435530.43,435530.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','64',2643,'25','1',188231.36,188231.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','64',2644,'27','1',194274.90,194274.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','64',2645,'29','1',179072.41,179072.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','64',2646,'31','1',272303.39,272303.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','64',2647,'33','2',3479402.12,3481363.88,1961.76,1333996.80,0.00,0.00,0.00,0.00,0.00),('21','237','5','64',2648,'35','2',3945301.45,3947633.09,2331.64,1585515.20,0.00,0.00,0.00,0.00,0.00),('21','237','5','64',2649,'42','2',2863962.88,2865072.88,1110.00,754800.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','64',2650,'43','2',2921777.25,2924522.72,2745.47,1866919.60,0.00,0.00,0.00,0.00,0.00),('21','237','6','64',2651,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','64',2652,'45','2',1975972.71,1978162.84,2190.13,1489288.40,0.00,0.00,0.00,0.00,0.00),('21','237','6','64',2653,'46','2',4831731.48,4836020.00,4288.52,2916193.60,0.00,0.00,0.00,0.00,0.00),('21','237','6','64',2654,'47','2',4084894.66,4088389.79,3495.13,2376688.40,0.00,0.00,0.00,0.00,0.00),('21','237','7','64',2655,'48','2',2496800.75,2497874.87,1074.12,730401.60,0.00,0.00,0.00,0.00,0.00),('21','237','7','64',2656,'49','2',2828547.10,2830766.63,2219.53,1509280.40,0.00,0.00,0.00,0.00,0.00),('21','237','1','64',2657,'50','1',976167.51,976167.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','64',2658,'51','1',677853.23,677853.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','64',2659,'52','1',801593.57,801593.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','64',2660,'53','1',931499.18,931499.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','64',2661,'54','1',627686.45,627686.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','64',2662,'55','1',459271.46,459271.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','64',2663,'56','1',402817.85,402817.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','64',2664,'57','1',763690.29,763690.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','64',2665,'58','1',742210.15,742210.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','64',2666,'59','1',336723.90,336723.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','64',2667,'60','1',470627.19,470627.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','64',2668,'61','1',654237.92,654237.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','64',2669,'62','1',214848.33,214848.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','64',2670,'63','1',622635.58,622635.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','64',2671,'64','1',479852.21,479852.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','64',2672,'65','1',227026.17,227026.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','65',2673,'1','1',1395463.52,1396993.18,1529.66,252393.90,0.00,0.00,0.00,0.00,0.00),('21','237','1','65',2674,'3','1',838151.71,840108.99,1957.28,322951.20,0.00,0.00,0.00,0.00,0.00),('21','237','1','65',2675,'5','1',649033.27,649275.89,242.62,40032.30,0.00,0.00,0.00,0.00,0.00),('21','237','1','65',2676,'7','1',1419540.43,1421294.18,1753.75,289368.75,0.00,0.00,0.00,0.00,0.00),('21','237','2','65',2677,'9','1',748437.19,749626.76,1189.57,196279.05,0.00,0.00,0.00,0.00,0.00),('21','237','2','65',2678,'11','1',560533.92,561127.68,593.76,97970.40,0.00,0.00,0.00,0.00,0.00),('21','237','2','65',2679,'13','1',360302.39,360422.09,119.70,19750.50,0.00,0.00,0.00,0.00,0.00),('21','237','2','65',2680,'15','1',569777.35,569777.39,0.04,6.60,0.00,0.00,0.00,0.00,0.00),('21','237','3','65',2681,'17','1',412992.47,412992.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','65',2682,'18','1',335722.09,335722.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','65',2683,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','65',2684,'23','1',435530.43,435771.81,241.38,39827.70,0.00,0.00,0.00,0.00,0.00),('21','237','4','65',2685,'25','1',188231.36,188231.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','65',2686,'27','1',194274.90,194373.95,99.05,16343.25,0.00,0.00,0.00,0.00,0.00),('21','237','4','65',2687,'29','1',179072.41,179072.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','65',2688,'31','1',272303.39,272784.88,481.49,79445.85,0.00,0.00,0.00,0.00,0.00),('21','237','5','65',2689,'33','2',3481363.88,3484576.40,3212.52,2184513.60,0.00,0.00,0.00,0.00,0.00),('21','237','5','65',2690,'35','2',3947633.09,3952955.62,5322.53,3619320.40,0.00,0.00,0.00,0.00,0.00),('21','237','5','65',2691,'42','2',2865072.88,2868462.63,3389.75,2305030.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','65',2692,'43','2',2924522.72,2929798.38,5275.66,3587448.80,0.00,0.00,0.00,0.00,0.00),('21','237','6','65',2693,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','65',2694,'45','2',1978162.84,1980679.47,2516.63,1711308.40,0.00,0.00,0.00,0.00,0.00),('21','237','6','65',2695,'46','2',4836020.00,4840856.48,4836.48,3288806.40,0.00,0.00,0.00,0.00,0.00),('21','237','6','65',2696,'47','2',4088389.79,4092371.09,3981.30,2707284.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','65',2697,'48','2',2497874.87,2510102.85,12227.98,8315026.40,0.00,0.00,0.00,0.00,0.00),('21','237','7','65',2698,'49','2',2830766.63,2843427.85,12661.22,8609629.60,0.00,0.00,0.00,0.00,0.00),('21','237','1','65',2699,'50','1',976167.51,977994.47,1826.96,301448.40,0.00,0.00,0.00,0.00,0.00),('21','237','1','65',2700,'51','1',677853.23,677853.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','65',2701,'52','1',801593.57,802624.68,1031.11,170133.15,0.00,0.00,0.00,0.00,0.00),('21','237','1','65',2702,'53','1',931499.18,932493.88,994.70,164125.50,0.00,0.00,0.00,0.00,0.00),('21','237','2','65',2703,'54','1',627686.45,629734.55,2048.10,337936.50,0.00,0.00,0.00,0.00,0.00),('21','237','2','65',2704,'55','1',459271.46,459656.02,384.56,63452.40,0.00,0.00,0.00,0.00,0.00),('21','237','2','65',2705,'56','1',402817.85,403048.71,230.86,38091.90,0.00,0.00,0.00,0.00,0.00),('21','237','2','65',2706,'57','1',763690.29,767627.24,3936.95,649596.75,0.00,0.00,0.00,0.00,0.00),('21','237','3','65',2707,'58','1',742210.15,745069.73,2859.58,471830.70,0.00,0.00,0.00,0.00,0.00),('21','237','3','65',2708,'59','1',336723.90,338209.86,1485.96,245183.40,0.00,0.00,0.00,0.00,0.00),('21','237','3','65',2709,'60','1',470627.19,473009.47,2382.28,393076.20,0.00,0.00,0.00,0.00,0.00),('21','237','3','65',2710,'61','1',654237.92,655838.62,1600.70,264115.50,0.00,0.00,0.00,0.00,0.00),('21','237','4','65',2711,'62','1',214848.33,215368.92,520.59,85897.35,0.00,0.00,0.00,0.00,0.00),('21','237','4','65',2712,'63','1',622635.58,624869.38,2233.80,368577.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','65',2713,'64','1',479852.21,481848.77,1996.56,329432.40,0.00,0.00,0.00,0.00,0.00),('21','237','4','65',2714,'65','1',227026.17,229184.33,2158.16,356096.40,0.00,0.00,0.00,0.00,0.00),('21','237','1','66',2715,'1','1',1396993.18,1399639.77,2646.59,436687.35,0.00,0.00,0.00,0.00,0.00),('21','237','1','66',2716,'3','1',840108.99,842744.37,2635.38,434837.70,0.00,0.00,0.00,0.00,0.00),('21','237','1','66',2717,'5','1',649275.89,649280.74,4.85,800.25,0.00,0.00,0.00,0.00,0.00),('21','237','1','66',2718,'7','1',1421294.18,1423903.18,2609.00,430485.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','66',2719,'9','1',749626.76,750723.19,1096.43,180910.95,0.00,0.00,0.00,0.00,0.00),('21','237','2','66',2720,'11','1',561127.68,561841.02,713.34,117701.10,0.00,0.00,0.00,0.00,0.00),('21','237','2','66',2721,'13','1',360422.09,360720.60,298.51,49254.15,0.00,0.00,0.00,0.00,0.00),('21','237','2','66',2722,'15','1',569777.39,569777.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','66',2723,'17','1',412992.47,412992.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','66',2724,'18','1',335722.09,336256.26,534.17,88138.05,0.00,0.00,0.00,0.00,0.00),('21','237','3','66',2725,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','66',2726,'23','1',435771.81,435915.44,143.63,23698.95,0.00,0.00,0.00,0.00,0.00),('21','237','4','66',2727,'25','1',188231.36,188231.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','66',2728,'27','1',194373.95,194619.94,245.99,40588.35,0.00,0.00,0.00,0.00,0.00),('21','237','4','66',2729,'29','1',179072.41,179072.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','66',2730,'31','1',272784.88,273276.59,491.71,81132.15,0.00,0.00,0.00,0.00,0.00),('21','237','5','66',2731,'33','2',3484576.40,3493082.68,8506.28,5784270.40,0.00,0.00,0.00,0.00,0.00),('21','237','5','66',2732,'35','2',3952955.62,3958737.39,5781.77,3931603.60,0.00,0.00,0.00,0.00,0.00),('21','237','5','66',2733,'42','2',2868462.63,2874171.07,5708.44,3881739.20,0.00,0.00,0.00,0.00,0.00),('21','237','5','66',2734,'43','2',2929798.38,2936257.09,6458.71,4391922.80,0.00,0.00,0.00,0.00,0.00),('21','237','6','66',2735,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','66',2736,'45','2',1980679.47,1983998.49,3319.02,2256933.60,0.00,0.00,0.00,0.00,0.00),('21','237','6','66',2737,'46','2',4840856.48,4848984.78,8128.30,5527244.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','66',2738,'47','2',4092371.09,4095964.40,3593.31,2443450.80,0.00,0.00,0.00,0.00,0.00),('21','237','7','66',2739,'48','2',2510102.85,2518468.61,8365.76,5688716.80,0.00,0.00,0.00,0.00,0.00),('21','237','7','66',2740,'49','2',2843427.85,2850744.00,7316.15,4974982.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','66',2741,'50','1',977994.47,979966.27,1971.80,325347.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','66',2742,'51','1',677853.23,677853.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','66',2743,'52','1',802624.68,803861.03,1236.35,203997.75,0.00,0.00,0.00,0.00,0.00),('21','237','1','66',2744,'53','1',932493.88,933293.31,799.43,131905.95,0.00,0.00,0.00,0.00,0.00),('21','237','2','66',2745,'54','1',629734.55,631349.56,1615.01,266476.65,0.00,0.00,0.00,0.00,0.00),('21','237','2','66',2746,'55','1',459656.02,459656.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','66',2747,'56','1',403048.71,403892.31,843.60,139194.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','66',2748,'57','1',767627.24,770024.70,2397.46,395580.90,0.00,0.00,0.00,0.00,0.00),('21','237','3','66',2749,'58','1',745069.73,747452.38,2382.65,393137.25,0.00,0.00,0.00,0.00,0.00),('21','237','3','66',2750,'59','1',338209.86,338422.68,212.82,35115.30,0.00,0.00,0.00,0.00,0.00),('21','237','3','66',2751,'60','1',473009.47,474427.87,1418.40,234036.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','66',2752,'61','1',655838.62,657979.28,2140.66,353208.90,0.00,0.00,0.00,0.00,0.00),('21','237','4','66',2753,'62','1',215368.92,216350.51,981.59,161962.35,0.00,0.00,0.00,0.00,0.00),('21','237','4','66',2754,'63','1',624869.38,626257.18,1387.80,228987.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','66',2755,'64','1',481848.77,483699.57,1850.80,305382.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','66',2756,'65','1',229184.33,229418.35,234.02,38613.30,0.00,0.00,0.00,0.00,0.00),('21','237','1','67',2757,'1','1',1399639.77,1401537.45,1897.68,313117.20,0.00,0.00,0.00,0.00,0.00),('21','237','1','67',2758,'3','1',842744.37,845801.74,3057.37,504466.05,0.00,0.00,0.00,0.00,0.00),('21','237','1','67',2759,'5','1',649280.74,649675.51,394.77,65137.05,0.00,0.00,0.00,0.00,0.00),('21','237','1','67',2760,'7','1',1423903.18,1427100.88,3197.70,527620.50,0.00,0.00,0.00,0.00,0.00),('21','237','2','67',2761,'9','1',750723.19,752434.32,1711.13,282336.45,0.00,0.00,0.00,0.00,0.00),('21','237','2','67',2762,'11','1',561841.02,563469.68,1628.66,268728.90,0.00,0.00,0.00,0.00,0.00),('21','237','2','67',2763,'13','1',360720.60,360884.76,164.16,27086.40,0.00,0.00,0.00,0.00,0.00),('21','237','2','67',2764,'15','1',569777.39,569869.06,91.67,15125.55,0.00,0.00,0.00,0.00,0.00),('21','237','3','67',2765,'17','1',412992.47,413175.49,183.02,30198.30,0.00,0.00,0.00,0.00,0.00),('21','237','3','67',2766,'18','1',336256.26,336256.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','67',2767,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','67',2768,'23','1',435915.44,435941.40,25.96,4283.40,0.00,0.00,0.00,0.00,0.00),('21','237','4','67',2769,'25','1',188231.36,188231.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','67',2770,'27','1',194619.94,194619.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','67',2771,'29','1',179072.41,179072.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','67',2772,'31','1',273276.59,273276.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','67',2773,'33','2',3493082.68,3496994.84,3912.16,2660268.80,0.00,0.00,0.00,0.00,0.00),('21','237','5','67',2774,'35','2',3958737.39,3965662.59,6925.20,4709136.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','67',2775,'42','2',2874171.07,2877917.54,3746.47,2547599.60,0.00,0.00,0.00,0.00,0.00),('21','237','5','67',2776,'43','2',2936257.09,2943271.37,7014.28,4769710.40,0.00,0.00,0.00,0.00,0.00),('21','237','6','67',2777,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','67',2778,'45','2',1983998.49,1988914.94,4916.45,3343186.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','67',2779,'46','2',4848984.78,4857202.86,8218.08,5588294.40,0.00,0.00,0.00,0.00,0.00),('21','237','6','67',2780,'47','2',4095964.40,4104512.23,8547.83,5812524.40,0.00,0.00,0.00,0.00,0.00),('21','237','7','67',2781,'48','2',2518468.61,2523347.90,4879.29,3317917.20,0.00,0.00,0.00,0.00,0.00),('21','237','7','67',2782,'49','2',2850744.00,2858944.98,8200.98,5576666.40,0.00,0.00,0.00,0.00,0.00),('21','237','1','67',2783,'50','1',979966.27,981466.22,1499.95,247491.75,0.00,0.00,0.00,0.00,0.00),('21','237','1','67',2784,'51','1',677853.23,677853.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','67',2785,'52','1',803861.03,806139.76,2278.73,375990.45,0.00,0.00,0.00,0.00,0.00),('21','237','1','67',2786,'53','1',933293.31,934572.12,1278.81,211003.65,0.00,0.00,0.00,0.00,0.00),('21','237','2','67',2787,'54','1',631349.56,632270.97,921.41,152032.65,0.00,0.00,0.00,0.00,0.00),('21','237','2','67',2788,'55','1',459656.02,460148.79,492.77,81307.05,0.00,0.00,0.00,0.00,0.00),('21','237','2','67',2789,'56','1',403892.31,404455.45,563.14,92918.10,0.00,0.00,0.00,0.00,0.00),('21','237','2','67',2790,'57','1',770024.70,772859.30,2834.60,467709.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','67',2791,'58','1',747452.38,749132.96,1680.58,277295.70,0.00,0.00,0.00,0.00,0.00),('21','237','3','67',2792,'59','1',338422.68,338422.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','67',2793,'60','1',474427.87,475000.19,572.32,94432.80,0.00,0.00,0.00,0.00,0.00),('21','237','3','67',2794,'61','1',657979.28,660087.23,2107.95,347811.75,0.00,0.00,0.00,0.00,0.00),('21','237','4','67',2795,'62','1',216350.51,216766.08,415.57,68569.05,0.00,0.00,0.00,0.00,0.00),('21','237','4','67',2796,'63','1',626257.18,628152.29,1895.11,312693.15,0.00,0.00,0.00,0.00,0.00),('21','237','4','67',2797,'64','1',483699.57,485761.77,2062.20,340263.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','67',2798,'65','1',229418.35,230500.63,1082.28,178576.20,0.00,0.00,0.00,0.00,0.00),('21','237','1','68',2799,'1','1',1401537.45,1402330.19,792.74,130802.10,0.00,0.00,0.00,0.00,0.00),('21','237','1','68',2800,'3','1',845801.74,848628.86,2827.12,466474.80,0.00,0.00,0.00,0.00,0.00),('21','237','1','68',2801,'5','1',649675.51,649675.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','68',2802,'7','1',1427100.88,1429609.74,2508.86,413961.90,0.00,0.00,0.00,0.00,0.00),('21','237','2','68',2803,'9','1',752434.32,753563.22,1128.90,186268.50,0.00,0.00,0.00,0.00,0.00),('21','237','2','68',2804,'11','1',563469.68,564770.12,1300.44,214572.60,0.00,0.00,0.00,0.00,0.00),('21','237','2','68',2805,'13','1',360884.76,362763.03,1878.27,309914.55,0.00,0.00,0.00,0.00,0.00),('21','237','2','68',2806,'15','1',569869.06,570483.33,614.27,101354.55,0.00,0.00,0.00,0.00,0.00),('21','237','3','68',2807,'17','1',413175.49,413822.12,646.63,106693.95,0.00,0.00,0.00,0.00,0.00),('21','237','3','68',2808,'18','1',336256.26,336256.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','68',2809,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','68',2810,'23','1',435941.40,435941.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','68',2811,'25','1',188231.36,188231.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','68',2812,'27','1',194619.94,194810.89,190.95,31506.75,0.00,0.00,0.00,0.00,0.00),('21','237','4','68',2813,'29','1',179072.41,179072.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','68',2814,'31','1',273276.59,274611.19,1334.60,220209.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','68',2815,'33','2',3496994.84,3498939.98,1945.14,1322695.20,0.00,0.00,0.00,0.00,0.00),('21','237','5','68',2816,'35','2',3965662.59,3972465.68,6803.09,4626101.20,0.00,0.00,0.00,0.00,0.00),('21','237','5','68',2817,'42','2',2877917.54,2881744.79,3827.25,2602530.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','68',2818,'43','2',2943271.37,2948747.55,5476.18,3723802.40,0.00,0.00,0.00,0.00,0.00),('21','237','6','68',2819,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','68',2820,'45','2',1988914.94,1990839.34,1924.40,1308592.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','68',2821,'46','2',4857202.86,4863932.55,6729.69,4576189.20,0.00,0.00,0.00,0.00,0.00),('21','237','6','68',2822,'47','2',4104512.23,4110484.50,5972.27,4061143.60,0.00,0.00,0.00,0.00,0.00),('21','237','7','68',2823,'48','2',2523347.90,2527011.44,3663.54,2491207.20,0.00,0.00,0.00,0.00,0.00),('21','237','7','68',2824,'49','2',2858944.98,2865148.22,6203.24,4218203.20,0.00,0.00,0.00,0.00,0.00),('21','237','1','68',2825,'50','1',981466.22,983097.30,1631.08,269128.20,0.00,0.00,0.00,0.00,0.00),('21','237','1','68',2826,'51','1',677853.23,677853.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','68',2827,'52','1',806139.76,808913.70,2773.94,457700.10,0.00,0.00,0.00,0.00,0.00),('21','237','1','68',2828,'53','1',934572.12,936067.57,1495.45,246749.25,0.00,0.00,0.00,0.00,0.00),('21','237','2','68',2829,'54','1',632270.97,633057.27,786.30,129739.50,0.00,0.00,0.00,0.00,0.00),('21','237','2','68',2830,'55','1',460148.79,461214.06,1065.27,175769.55,0.00,0.00,0.00,0.00,0.00),('21','237','2','68',2831,'56','1',404455.45,405556.54,1101.09,181679.85,0.00,0.00,0.00,0.00,0.00),('21','237','2','68',2832,'57','1',772859.30,773589.03,729.73,120405.45,0.00,0.00,0.00,0.00,0.00),('21','237','3','68',2833,'58','1',749132.96,750028.73,895.77,147802.05,0.00,0.00,0.00,0.00,0.00),('21','237','3','68',2834,'59','1',338422.68,340440.02,2017.34,332861.10,0.00,0.00,0.00,0.00,0.00),('21','237','3','68',2835,'60','1',475000.19,476611.01,1610.82,265785.30,0.00,0.00,0.00,0.00,0.00),('21','237','3','68',2836,'61','1',660087.23,662311.73,2224.50,367042.50,0.00,0.00,0.00,0.00,0.00),('21','237','4','68',2837,'62','1',216766.08,216766.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','68',2838,'63','1',628152.29,629176.71,1024.42,169029.30,0.00,0.00,0.00,0.00,0.00),('21','237','4','68',2839,'64','1',485761.77,487264.33,1502.56,247922.40,0.00,0.00,0.00,0.00,0.00),('21','237','4','68',2840,'65','1',230500.63,231746.91,1246.28,205636.20,0.00,0.00,0.00,0.00,0.00),('21','237','1','69',2841,'1','1',1402330.19,1404040.61,1710.42,282219.30,0.00,0.00,0.00,0.00,0.00),('21','237','1','69',2842,'3','1',848628.86,851907.59,3278.73,540990.45,0.00,0.00,0.00,0.00,0.00),('21','237','1','69',2843,'5','1',649675.51,649922.67,247.16,40781.40,0.00,0.00,0.00,0.00,0.00),('21','237','1','69',2844,'7','1',1429609.74,1431023.51,1413.77,233272.05,0.00,0.00,0.00,0.00,0.00),('21','237','2','69',2845,'9','1',753563.22,756014.43,2451.21,404449.65,0.00,0.00,0.00,0.00,0.00),('21','237','2','69',2846,'11','1',564770.12,566319.04,1548.92,255571.80,0.00,0.00,0.00,0.00,0.00),('21','237','2','69',2847,'13','1',362763.03,362954.47,191.44,31587.60,0.00,0.00,0.00,0.00,0.00),('21','237','2','69',2848,'15','1',570483.33,571103.28,619.95,102291.75,0.00,0.00,0.00,0.00,0.00),('21','237','3','69',2849,'17','1',413822.12,413822.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','69',2850,'18','1',336256.26,336256.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','69',2851,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','69',2852,'23','1',435941.40,435941.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','69',2853,'25','1',188231.36,188231.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','69',2854,'27','1',194810.89,194892.42,81.53,13452.45,0.00,0.00,0.00,0.00,0.00),('21','237','4','69',2855,'29','1',179072.41,179072.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','69',2856,'31','1',274611.19,274611.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','69',2857,'33','2',3498939.98,3501672.75,2732.77,1858283.60,0.00,0.00,0.00,0.00,0.00),('21','237','5','69',2858,'35','2',3972465.68,3975727.18,3261.50,2217820.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','69',2859,'42','2',2881744.79,2883843.13,2098.34,1426871.20,0.00,0.00,0.00,0.00,0.00),('21','237','5','69',2860,'43','2',2948747.55,2955993.41,7245.86,4927184.80,0.00,0.00,0.00,0.00,0.00),('21','237','6','69',2861,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','69',2862,'45','2',1990839.34,1994900.37,4061.03,2761500.40,0.00,0.00,0.00,0.00,0.00),('21','237','6','69',2863,'46','2',4863932.55,4869394.42,5461.87,3714071.60,0.00,0.00,0.00,0.00,0.00),('21','237','6','69',2864,'47','2',4110484.50,4114898.78,4414.28,3001710.40,0.00,0.00,0.00,0.00,0.00),('21','237','7','69',2865,'48','2',2527011.44,2532189.03,5177.59,3520761.20,0.00,0.00,0.00,0.00,0.00),('21','237','7','69',2866,'49','2',2865148.22,2871844.38,6696.16,4553388.80,0.00,0.00,0.00,0.00,0.00),('21','237','1','69',2867,'50','1',983097.30,985067.94,1970.64,325155.60,0.00,0.00,0.00,0.00,0.00),('21','237','1','69',2868,'51','1',677853.23,677853.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','69',2869,'52','1',808913.70,811441.28,2527.58,417050.70,0.00,0.00,0.00,0.00,0.00),('21','237','1','69',2870,'53','1',936067.57,936393.17,325.60,53724.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','69',2871,'54','1',633057.27,634194.87,1137.60,187704.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','69',2872,'55','1',461214.06,462352.54,1138.48,187849.20,0.00,0.00,0.00,0.00,0.00),('21','237','2','69',2873,'56','1',405556.54,406880.85,1324.31,218511.15,0.00,0.00,0.00,0.00,0.00),('21','237','2','69',2874,'57','1',773589.03,775846.51,2257.48,372484.20,0.00,0.00,0.00,0.00,0.00),('21','237','3','69',2875,'58','1',750028.73,750321.98,293.25,48386.25,0.00,0.00,0.00,0.00,0.00),('21','237','3','69',2876,'59','1',340440.02,340440.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','69',2877,'60','1',476611.01,476611.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','69',2878,'61','1',662311.73,664448.86,2137.13,352626.45,0.00,0.00,0.00,0.00,0.00),('21','237','4','69',2879,'62','1',216766.08,217393.09,627.01,103456.65,0.00,0.00,0.00,0.00,0.00),('21','237','4','69',2880,'63','1',629176.71,630057.53,880.82,145335.30,0.00,0.00,0.00,0.00,0.00),('21','237','4','69',2881,'64','1',487264.33,490249.17,2984.84,492498.60,0.00,0.00,0.00,0.00,0.00),('21','237','4','69',2882,'65','1',231746.91,233292.48,1545.57,255019.05,0.00,0.00,0.00,0.00,0.00),('21','237','1','70',2883,'1','1',1404040.61,1406498.11,2457.50,405487.50,0.00,0.00,0.00,0.00,0.00),('21','237','1','70',2884,'3','1',851907.59,853409.44,1501.85,247805.25,0.00,0.00,0.00,0.00,0.00),('21','237','1','70',2885,'5','1',649922.67,649922.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','70',2886,'7','1',1431023.51,1432857.53,1834.02,302613.30,0.00,0.00,0.00,0.00,0.00),('21','237','2','70',2887,'9','1',756014.43,757998.36,1983.93,327348.45,0.00,0.00,0.00,0.00,0.00),('21','237','2','70',2888,'11','1',566319.04,568399.74,2080.70,343315.50,0.00,0.00,0.00,0.00,0.00),('21','237','2','70',2889,'13','1',362954.47,363378.90,424.43,70030.95,0.00,0.00,0.00,0.00,0.00),('21','237','2','70',2890,'15','1',571103.28,572129.89,1026.61,169390.65,0.00,0.00,0.00,0.00,0.00),('21','237','3','70',2891,'17','1',413822.12,413822.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','70',2892,'18','1',336256.26,336256.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','70',2893,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','70',2894,'23','1',435941.40,435941.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','70',2895,'25','1',188231.36,188231.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','70',2896,'27','1',194892.42,194892.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','70',2897,'29','1',179072.41,179072.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','70',2898,'31','1',274611.19,274611.22,0.03,4.95,0.00,0.00,0.00,0.00,0.00),('21','237','5','70',2899,'33','2',3501672.75,3506469.90,4797.15,3262062.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','70',2900,'35','2',3975727.18,3980834.29,5107.11,3472834.80,0.00,0.00,0.00,0.00,0.00),('21','237','5','70',2901,'42','2',2883843.13,2887337.32,3494.19,2376049.20,0.00,0.00,0.00,0.00,0.00),('21','237','5','70',2902,'43','2',2955993.41,2960239.63,4246.22,2887429.60,0.00,0.00,0.00,0.00,0.00),('21','237','6','70',2903,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','70',2904,'45','2',1994900.37,1996722.77,1822.40,1239232.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','70',2905,'46','2',4869394.42,4873544.25,4149.83,2821884.40,0.00,0.00,0.00,0.00,0.00),('21','237','6','70',2906,'47','2',4114898.78,4119932.53,5033.75,3422950.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','70',2907,'48','2',2532189.03,2536753.52,4564.49,3103853.20,0.00,0.00,0.00,0.00,0.00),('21','237','7','70',2908,'49','2',2871844.38,2879094.61,7250.23,4930156.40,0.00,0.00,0.00,0.00,0.00),('21','237','1','70',2909,'50','1',985067.94,987652.31,2584.37,426421.05,0.00,0.00,0.00,0.00,0.00),('21','237','1','70',2910,'51','1',677853.23,677853.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','70',2911,'52','1',811441.28,811441.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','70',2912,'53','1',936393.17,937682.52,1289.35,212742.75,0.00,0.00,0.00,0.00,0.00),('21','237','2','70',2913,'54','1',634194.87,634245.78,50.91,8400.15,0.00,0.00,0.00,0.00,0.00),('21','237','2','70',2914,'55','1',462352.54,463286.69,934.15,154134.75,0.00,0.00,0.00,0.00,0.00),('21','237','2','70',2915,'56','1',406880.85,408771.54,1890.69,311963.85,0.00,0.00,0.00,0.00,0.00),('21','237','2','70',2916,'57','1',775846.51,778466.36,2619.85,432275.25,0.00,0.00,0.00,0.00,0.00),('21','237','3','70',2917,'58','1',750321.98,750321.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','70',2918,'59','1',340440.02,340440.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','70',2919,'60','1',476611.01,477783.71,1172.70,193495.50,0.00,0.00,0.00,0.00,0.00),('21','237','3','70',2920,'61','1',664448.86,664448.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','70',2921,'62','1',217393.09,217393.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','70',2922,'63','1',630057.53,633090.53,3033.00,500445.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','70',2923,'64','1',490249.17,492792.35,2543.18,419624.70,0.00,0.00,0.00,0.00,0.00),('21','237','4','70',2924,'65','1',233292.48,236008.43,2715.95,448131.75,0.00,0.00,0.00,0.00,0.00),('21','237','1','71',2925,'1','1',1406498.11,1408878.68,2380.57,392794.05,0.00,0.00,0.00,0.00,0.00),('21','237','1','71',2926,'3','1',853409.44,855522.73,2113.29,348692.85,0.00,0.00,0.00,0.00,0.00),('21','237','1','71',2927,'5','1',649922.67,650002.06,79.39,13099.35,0.00,0.00,0.00,0.00,0.00),('21','237','1','71',2928,'7','1',1432857.53,1435584.24,2726.71,449907.15,0.00,0.00,0.00,0.00,0.00),('21','237','2','71',2929,'9','1',757998.36,759170.71,1172.35,193437.75,0.00,0.00,0.00,0.00,0.00),('21','237','2','71',2930,'11','1',568399.74,569734.51,1334.77,220237.05,0.00,0.00,0.00,0.00,0.00),('21','237','2','71',2931,'13','1',363378.90,363378.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','71',2932,'15','1',572129.89,572783.27,653.38,107807.70,0.00,0.00,0.00,0.00,0.00),('21','237','3','71',2933,'17','1',413822.12,414114.39,292.27,48224.55,0.00,0.00,0.00,0.00,0.00),('21','237','3','71',2934,'18','1',336256.26,336256.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','71',2935,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','71',2936,'23','1',435941.40,435941.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','71',2937,'25','1',188231.36,188231.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','71',2938,'27','1',194892.42,195270.94,378.52,62455.80,0.00,0.00,0.00,0.00,0.00),('21','237','4','71',2939,'29','1',179072.41,179292.21,219.80,36267.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','71',2940,'31','1',274611.22,274611.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','71',2941,'33','2',3506469.90,3510356.00,3886.10,2720270.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','71',2942,'35','2',3980834.29,3986214.44,5380.15,3766105.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','71',2943,'42','2',2887337.32,2889562.67,2225.35,1557745.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','71',2944,'43','2',2960239.63,2964066.85,3827.22,2679054.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','71',2945,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','71',2946,'45','2',1996722.77,2002068.49,5345.72,3742004.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','71',2947,'46','2',4873544.25,4877961.93,4417.68,3092376.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','71',2948,'47','2',4119932.53,4124463.03,4530.50,3171350.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','71',2949,'48','2',2536753.52,2541023.51,4269.99,2988993.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','71',2950,'49','2',2879094.61,2883269.23,4174.62,2922234.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','71',2951,'50','1',987652.31,989850.93,2198.62,362772.30,0.00,0.00,0.00,0.00,0.00),('21','237','1','71',2952,'51','1',677853.23,677853.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','71',2953,'52','1',811441.28,814689.88,3248.60,536019.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','71',2954,'53','1',937682.52,938932.20,1249.68,206197.20,0.00,0.00,0.00,0.00,0.00),('21','237','2','71',2955,'54','1',634245.78,635545.45,1299.67,214445.55,0.00,0.00,0.00,0.00,0.00),('21','237','2','71',2956,'55','1',463286.69,464436.16,1149.47,189662.55,0.00,0.00,0.00,0.00,0.00),('21','237','2','71',2957,'56','1',408771.54,409960.40,1188.86,196161.90,0.00,0.00,0.00,0.00,0.00),('21','237','2','71',2958,'57','1',778466.36,779531.83,1065.47,175802.55,0.00,0.00,0.00,0.00,0.00),('21','237','3','71',2959,'58','1',750321.98,751607.09,1285.11,212043.15,0.00,0.00,0.00,0.00,0.00),('21','237','3','71',2960,'59','1',340440.02,340440.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','71',2961,'60','1',477783.71,478518.91,735.20,121308.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','71',2962,'61','1',664448.86,666575.13,2126.27,350834.55,0.00,0.00,0.00,0.00,0.00),('21','237','4','71',2963,'62','1',217393.09,217393.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','71',2964,'63','1',633090.53,635110.56,2020.03,333304.95,0.00,0.00,0.00,0.00,0.00),('21','237','4','71',2965,'64','1',492792.35,494971.74,2179.39,359599.35,0.00,0.00,0.00,0.00,0.00),('21','237','4','71',2966,'65','1',236008.43,237192.94,1184.51,195444.15,0.00,0.00,0.00,0.00,0.00),('21','237','1','72',2967,'1','1',1408878.68,1409325.38,446.70,73705.50,0.00,0.00,0.00,0.00,0.00),('21','237','1','72',2968,'3','1',855522.73,858083.04,2560.31,422451.15,0.00,0.00,0.00,0.00,0.00),('21','237','1','72',2969,'5','1',650002.06,650432.06,430.00,70950.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','72',2970,'7','1',1435584.24,1437845.62,2261.38,373127.70,0.00,0.00,0.00,0.00,0.00),('21','237','2','72',2971,'9','1',759170.71,761362.05,2191.34,361571.10,0.00,0.00,0.00,0.00,0.00),('21','237','2','72',2972,'11','1',569734.51,571772.82,2038.31,336321.15,0.00,0.00,0.00,0.00,0.00),('21','237','2','72',2973,'13','1',363378.90,363378.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','72',2974,'15','1',572783.27,573300.15,516.88,85285.20,0.00,0.00,0.00,0.00,0.00),('21','237','3','72',2975,'17','1',414114.39,414114.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','72',2976,'18','1',336256.26,336256.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','72',2977,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','72',2978,'23','1',435941.40,436693.18,751.78,124043.70,0.00,0.00,0.00,0.00,0.00),('21','237','4','72',2979,'25','1',188231.36,188301.30,69.94,11540.10,0.00,0.00,0.00,0.00,0.00),('21','237','4','72',2980,'27','1',195270.94,195343.67,72.73,12000.45,0.00,0.00,0.00,0.00,0.00),('21','237','4','72',2981,'29','1',179292.21,179292.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','72',2982,'31','1',274611.22,274794.12,182.90,30178.50,0.00,0.00,0.00,0.00,0.00),('21','237','5','72',2983,'33','2',3510356.00,3510735.27,379.27,265489.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','72',2984,'35','2',3986214.44,3988564.44,2350.00,1645000.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','72',2985,'42','2',2889562.67,2891214.10,1651.43,1156001.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','72',2986,'43','2',2964066.85,2967312.58,3245.73,2272011.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','72',2987,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','72',2988,'45','2',2002068.49,2003108.42,1039.93,727951.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','72',2989,'46','2',4877961.93,4879724.79,1762.86,1234002.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','72',2990,'47','2',4124463.03,4126512.59,2049.56,1434692.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','72',2991,'48','2',2541023.51,2543175.52,2152.01,1506407.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','72',2992,'49','2',2883269.23,2884821.52,1552.29,1086603.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','72',2993,'50','1',989850.93,991791.94,1941.01,320266.65,0.00,0.00,0.00,0.00,0.00),('21','237','1','72',2994,'51','1',677853.23,677853.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','72',2995,'52','1',814689.88,817022.22,2332.34,384836.10,0.00,0.00,0.00,0.00,0.00),('21','237','1','72',2996,'53','1',938932.20,939710.95,778.75,128493.75,0.00,0.00,0.00,0.00,0.00),('21','237','2','72',2997,'54','1',635545.45,637242.05,1696.60,279939.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','72',2998,'55','1',464436.16,464779.01,342.85,56570.25,0.00,0.00,0.00,0.00,0.00),('21','237','2','72',2999,'56','1',409960.40,411461.75,1501.35,247722.75,0.00,0.00,0.00,0.00,0.00),('21','237','2','72',3000,'57','1',779531.83,781473.66,1941.83,320401.95,0.00,0.00,0.00,0.00,0.00),('21','237','3','72',3001,'58','1',751607.09,753051.23,1444.14,238283.10,0.00,0.00,0.00,0.00,0.00),('21','237','3','72',3002,'59','1',340440.02,340773.70,333.68,55057.20,0.00,0.00,0.00,0.00,0.00),('21','237','3','72',3003,'60','1',478518.91,479616.34,1097.43,181075.95,0.00,0.00,0.00,0.00,0.00),('21','237','3','72',3004,'61','1',666575.13,667216.28,641.15,105789.75,0.00,0.00,0.00,0.00,0.00),('21','237','4','72',3005,'62','1',217393.09,218120.27,727.18,119984.70,0.00,0.00,0.00,0.00,0.00),('21','237','4','72',3006,'63','1',635110.56,636181.99,1071.43,176785.95,0.00,0.00,0.00,0.00,0.00),('21','237','4','72',3007,'64','1',494971.74,496695.01,1723.27,284339.55,0.00,0.00,0.00,0.00,0.00),('21','237','4','72',3008,'65','1',237192.94,238426.13,1233.19,203476.35,0.00,0.00,0.00,0.00,0.00),('21','237','1','73',3009,'1','1',1409325.38,1411293.74,1968.36,324779.40,0.00,0.00,0.00,0.00,0.00),('21','237','1','73',3010,'3','1',858083.04,860438.27,2355.23,388612.95,0.00,0.00,0.00,0.00,0.00),('21','237','1','73',3011,'5','1',650432.06,650791.16,359.10,59251.50,0.00,0.00,0.00,0.00,0.00),('21','237','1','73',3012,'7','1',1437845.62,1438790.23,944.61,155860.65,0.00,0.00,0.00,0.00,0.00),('21','237','2','73',3013,'9','1',761362.05,763059.11,1697.06,280014.90,0.00,0.00,0.00,0.00,0.00),('21','237','2','73',3014,'11','1',571772.82,571911.47,138.65,22877.25,0.00,0.00,0.00,0.00,0.00),('21','237','2','73',3015,'13','1',363378.90,363378.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','73',3016,'15','1',573300.15,574035.94,735.79,121405.35,0.00,0.00,0.00,0.00,0.00),('21','237','3','73',3017,'17','1',414114.39,414495.76,381.37,62926.05,0.00,0.00,0.00,0.00,0.00),('21','237','3','73',3018,'18','1',336256.26,336256.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','73',3019,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','73',3020,'23','1',436693.18,436693.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','73',3021,'25','1',188301.30,188301.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','73',3022,'27','1',195343.67,195358.82,15.15,2499.75,0.00,0.00,0.00,0.00,0.00),('21','237','4','73',3023,'29','1',179292.21,179292.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','73',3024,'31','1',274794.12,275137.75,343.63,56698.95,0.00,0.00,0.00,0.00,0.00),('21','237','5','73',3025,'33','2',3510735.27,3512665.27,1930.00,1351000.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','73',3026,'35','2',3988564.44,3991117.11,2552.67,1786869.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','73',3027,'42','2',2891214.10,2892612.24,1398.14,978698.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','73',3028,'43','2',2967312.58,2970034.68,2722.10,1905470.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','73',3029,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','73',3030,'45','2',2003108.42,2006388.38,3279.96,2295972.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','73',3031,'46','2',4879724.79,4883030.92,3306.13,2314291.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','73',3032,'47','2',4126512.59,4129647.62,3135.03,2194521.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','73',3033,'48','2',2543175.52,2549072.39,5896.87,4127809.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','73',3034,'49','2',2884821.52,2890139.96,5318.44,3722908.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','73',3035,'50','1',991791.94,992720.07,928.13,153141.45,0.00,0.00,0.00,0.00,0.00),('21','237','1','73',3036,'51','1',677853.23,677853.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','73',3037,'52','1',817022.22,819362.79,2340.57,386194.05,0.00,0.00,0.00,0.00,0.00),('21','237','1','73',3038,'53','1',939710.95,940701.50,990.55,163440.75,0.00,0.00,0.00,0.00,0.00),('21','237','2','73',3039,'54','1',637242.05,638606.71,1364.66,225168.90,0.00,0.00,0.00,0.00,0.00),('21','237','2','73',3040,'55','1',464779.01,465335.43,556.42,91809.30,0.00,0.00,0.00,0.00,0.00),('21','237','2','73',3041,'56','1',411461.75,412592.43,1130.68,186562.20,0.00,0.00,0.00,0.00,0.00),('21','237','2','73',3042,'57','1',781473.66,782816.12,1342.46,221505.90,0.00,0.00,0.00,0.00,0.00),('21','237','3','73',3043,'58','1',753051.23,754067.28,1016.05,167648.25,0.00,0.00,0.00,0.00,0.00),('21','237','3','73',3044,'59','1',340773.70,340773.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','73',3045,'60','1',479616.34,480638.15,1021.81,168598.65,0.00,0.00,0.00,0.00,0.00),('21','237','3','73',3046,'61','1',667216.28,668544.51,1328.23,219157.95,0.00,0.00,0.00,0.00,0.00),('21','237','4','73',3047,'62','1',218120.27,219058.75,938.48,154849.20,0.00,0.00,0.00,0.00,0.00),('21','237','4','73',3048,'63','1',636181.99,637677.31,1495.32,246727.80,0.00,0.00,0.00,0.00,0.00),('21','237','4','73',3049,'64','1',496695.01,497897.93,1202.92,198481.80,0.00,0.00,0.00,0.00,0.00),('21','237','4','73',3050,'65','1',238426.13,239967.61,1541.48,254344.20,0.00,0.00,0.00,0.00,0.00),('21','237','1','74',3051,'1','1',1411293.74,1412889.14,1595.40,263241.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','74',3052,'3','1',860438.27,863399.46,2961.19,488596.35,0.00,0.00,0.00,0.00,0.00),('21','237','1','74',3053,'5','1',650791.16,652008.95,1217.79,200935.35,0.00,0.00,0.00,0.00,0.00),('21','237','1','74',3054,'7','1',1438790.23,1440900.14,2109.91,348135.15,0.00,0.00,0.00,0.00,0.00),('21','237','2','74',3055,'9','1',763059.11,764147.16,1088.05,179528.25,0.00,0.00,0.00,0.00,0.00),('21','237','2','74',3056,'11','1',571911.47,573627.75,1716.28,283186.20,0.00,0.00,0.00,0.00,0.00),('21','237','2','74',3057,'13','1',363378.90,363810.51,431.61,71215.65,0.00,0.00,0.00,0.00,0.00),('21','237','2','74',3058,'15','1',574035.94,574035.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','74',3059,'17','1',414495.76,414495.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','74',3060,'18','1',336256.26,336256.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','74',3061,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','74',3062,'23','1',436693.18,438095.08,1401.90,231313.50,0.00,0.00,0.00,0.00,0.00),('21','237','4','74',3063,'25','1',188301.30,188301.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','74',3064,'27','1',195358.82,195358.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','74',3065,'29','1',179292.21,179292.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','74',3066,'31','1',275137.75,275359.24,221.49,36545.85,0.00,0.00,0.00,0.00,0.00),('21','237','5','74',3067,'33','2',3512665.27,3517042.93,4377.66,3064362.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','74',3068,'35','2',3991117.11,3994867.62,3750.51,2625357.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','74',3069,'42','2',2892612.24,2896179.39,3567.15,2497005.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','74',3070,'43','2',2970034.68,2972876.05,2841.37,1988959.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','74',3071,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','74',3072,'45','2',2006388.38,2011076.24,4687.86,3281502.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','74',3073,'46','2',4883030.92,4886819.24,3788.32,2651824.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','74',3074,'47','2',4129647.62,4136318.76,6671.14,4669798.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','74',3075,'48','2',2549072.39,2553054.22,3981.83,2787281.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','74',3076,'49','2',2890139.96,2895916.18,5776.22,4043354.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','74',3077,'50','1',992720.07,994746.69,2026.62,334392.30,0.00,0.00,0.00,0.00,0.00),('21','237','1','74',3078,'51','1',677853.23,677853.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','74',3079,'52','1',819362.79,819946.63,583.84,96333.60,0.00,0.00,0.00,0.00,0.00),('21','237','1','74',3080,'53','1',940701.50,941900.39,1198.89,197816.85,0.00,0.00,0.00,0.00,0.00),('21','237','2','74',3081,'54','1',638606.71,641050.35,2443.64,403200.60,0.00,0.00,0.00,0.00,0.00),('21','237','2','74',3082,'55','1',465335.43,465950.06,614.63,101413.95,0.00,0.00,0.00,0.00,0.00),('21','237','2','74',3083,'56','1',412592.43,412904.20,311.77,51442.05,0.00,0.00,0.00,0.00,0.00),('21','237','2','74',3084,'57','1',782816.12,785658.03,2841.91,468915.15,0.00,0.00,0.00,0.00,0.00),('21','237','3','74',3085,'58','1',754067.28,755055.75,988.47,163097.55,0.00,0.00,0.00,0.00,0.00),('21','237','3','74',3086,'59','1',340773.70,341990.39,1216.69,200753.85,0.00,0.00,0.00,0.00,0.00),('21','237','3','74',3087,'60','1',480638.15,481491.43,853.28,140791.20,0.00,0.00,0.00,0.00,0.00),('21','237','3','74',3088,'61','1',668544.51,669771.21,1226.70,202405.50,0.00,0.00,0.00,0.00,0.00),('21','237','4','74',3089,'62','1',219058.75,219885.03,826.28,136336.20,0.00,0.00,0.00,0.00,0.00),('21','237','4','74',3090,'63','1',637677.31,637756.39,79.08,13048.20,0.00,0.00,0.00,0.00,0.00),('21','237','4','74',3091,'64','1',497897.93,498491.75,593.82,97980.30,0.00,0.00,0.00,0.00,0.00),('21','237','4','74',3092,'65','1',239967.61,240321.69,354.08,58423.20,0.00,0.00,0.00,0.00,0.00),('21','237','1','75',3093,'1','1',1412889.14,1412889.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','75',3094,'3','1',863399.46,863399.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','75',3095,'5','1',652008.95,652008.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','75',3096,'7','1',1440900.14,1440900.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','75',3097,'9','1',764147.16,764147.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','75',3098,'11','1',573627.75,573627.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','75',3099,'13','1',363810.51,363810.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','75',3100,'15','1',574035.94,574035.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','75',3101,'17','1',414495.76,414495.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','75',3102,'18','1',336256.26,336256.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','75',3103,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','75',3104,'23','1',438095.08,438095.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','75',3105,'25','1',188301.30,188301.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','75',3106,'27','1',195358.82,195358.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','75',3107,'29','1',179292.21,179292.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','75',3108,'31','1',275359.24,275359.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','75',3109,'33','2',3517042.93,3520682.45,3639.52,2620454.40,0.00,0.00,0.00,0.00,0.00),('21','237','5','75',3110,'35','2',3994867.62,3997661.27,2793.65,2011428.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','75',3111,'42','2',2896179.39,2896179.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','75',3112,'43','2',2972876.05,2972948.83,72.78,52401.60,0.00,0.00,0.00,0.00,0.00),('21','237','6','75',3113,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','75',3114,'45','2',2011076.24,2012176.24,1100.00,792000.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','75',3115,'46','2',4886819.24,4888324.24,1505.00,1083600.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','75',3116,'47','2',4136318.76,4138485.43,2166.67,1560002.40,0.00,0.00,0.00,0.00,0.00),('21','237','7','75',3117,'48','2',2553054.22,2553974.43,920.21,662551.20,0.00,0.00,0.00,0.00,0.00),('21','237','7','75',3118,'49','2',2895916.18,2899162.24,3246.06,2337163.20,0.00,0.00,0.00,0.00,0.00),('21','237','1','75',3119,'50','1',994746.69,994746.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','75',3120,'51','1',677853.23,677853.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','75',3121,'52','1',819946.63,819946.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','75',3122,'53','1',941900.39,941900.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','75',3123,'54','1',641050.35,641050.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','75',3124,'55','1',465950.06,465950.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','75',3125,'56','1',412904.20,412904.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','75',3126,'57','1',785658.03,785658.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','75',3127,'58','1',755055.75,755055.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','75',3128,'59','1',341990.39,341990.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','75',3129,'60','1',481491.43,481491.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','75',3130,'61','1',669771.21,669771.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','75',3131,'62','1',219885.03,219885.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','75',3132,'63','1',637756.39,637756.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','75',3133,'64','1',498491.75,498491.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','75',3134,'65','1',240321.69,240321.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','76',3135,'1','1',1412889.14,1416012.54,3123.40,515361.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','76',3136,'3','1',863399.46,863669.93,270.47,44627.55,0.00,0.00,0.00,0.00,0.00),('21','237','1','76',3137,'5','1',652008.95,652008.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','76',3138,'7','1',1440900.14,1443597.37,2697.23,445042.95,0.00,0.00,0.00,0.00,0.00),('21','237','2','76',3139,'9','1',764147.16,765474.81,1327.65,219062.25,0.00,0.00,0.00,0.00,0.00),('21','237','2','76',3140,'11','1',573627.75,575252.20,1624.45,268034.25,0.00,0.00,0.00,0.00,0.00),('21','237','2','76',3141,'13','1',363810.51,364665.30,854.79,141040.35,0.00,0.00,0.00,0.00,0.00),('21','237','2','76',3142,'15','1',574035.94,575282.80,1246.86,205731.90,0.00,0.00,0.00,0.00,0.00),('21','237','3','76',3143,'17','1',414495.76,415549.23,1053.47,173822.55,0.00,0.00,0.00,0.00,0.00),('21','237','3','76',3144,'18','1',336256.26,336256.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','76',3145,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','76',3146,'23','1',438095.08,438552.79,457.71,75522.15,0.00,0.00,0.00,0.00,0.00),('21','237','4','76',3147,'25','1',188301.30,188301.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','76',3148,'27','1',195358.82,196120.81,761.99,125728.35,0.00,0.00,0.00,0.00,0.00),('21','237','4','76',3149,'29','1',179292.21,179292.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','76',3150,'31','1',275359.24,275359.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','76',3151,'33','2',3520682.45,3524428.65,3746.20,2697264.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','76',3152,'35','2',3997661.27,4002424.01,4762.74,3429172.80,0.00,0.00,0.00,0.00,0.00),('21','237','5','76',3153,'42','2',2896179.39,2897482.16,1302.77,937994.40,0.00,0.00,0.00,0.00,0.00),('21','237','5','76',3154,'43','2',2972948.83,2978223.62,5274.79,3797848.80,0.00,0.00,0.00,0.00,0.00),('21','237','6','76',3155,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','76',3156,'45','2',2012176.24,2017908.84,5732.60,4127472.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','76',3157,'46','2',4888324.24,4892886.07,4561.83,3284517.60,0.00,0.00,0.00,0.00,0.00),('21','237','6','76',3158,'47','2',4138485.43,4142840.00,4354.57,3135290.40,0.00,0.00,0.00,0.00,0.00),('21','237','7','76',3159,'48','2',2553974.43,2559146.06,5171.63,3723573.60,0.00,0.00,0.00,0.00,0.00),('21','237','7','76',3160,'49','2',2899162.24,2904872.57,5710.33,4111437.60,0.00,0.00,0.00,0.00,0.00),('21','237','1','76',3161,'50','1',994746.69,996556.88,1810.19,298681.35,0.00,0.00,0.00,0.00,0.00),('21','237','1','76',3162,'51','1',677853.23,677853.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','76',3163,'52','1',819946.63,819946.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','76',3164,'53','1',941900.39,944159.67,2259.28,372781.20,0.00,0.00,0.00,0.00,0.00),('21','237','2','76',3165,'54','1',641050.35,643266.91,2216.56,365732.40,0.00,0.00,0.00,0.00,0.00),('21','237','2','76',3166,'55','1',465950.06,468087.88,2137.82,352740.30,0.00,0.00,0.00,0.00,0.00),('21','237','2','76',3167,'56','1',412904.20,414074.57,1170.37,193111.05,0.00,0.00,0.00,0.00,0.00),('21','237','2','76',3168,'57','1',785658.03,788629.20,2971.17,490243.05,0.00,0.00,0.00,0.00,0.00),('21','237','3','76',3169,'58','1',755055.75,756556.23,1500.48,247579.20,0.00,0.00,0.00,0.00,0.00),('21','237','3','76',3170,'59','1',341990.39,341990.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','76',3171,'60','1',481491.43,482905.83,1414.40,233376.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','76',3172,'61','1',669771.21,671019.56,1248.35,205977.75,0.00,0.00,0.00,0.00,0.00),('21','237','4','76',3173,'62','1',219885.03,219885.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','76',3174,'63','1',637756.39,639235.77,1479.38,244097.70,0.00,0.00,0.00,0.00,0.00),('21','237','4','76',3175,'64','1',498491.75,500376.40,1884.65,310967.25,0.00,0.00,0.00,0.00,0.00),('21','237','4','76',3176,'65','1',240321.69,240321.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','77',3177,'1','1',1416012.54,1418293.60,2281.06,376374.90,0.00,0.00,0.00,0.00,0.00),('21','237','1','77',3178,'3','1',863669.93,865019.61,1349.68,222697.20,0.00,0.00,0.00,0.00,0.00),('21','237','1','77',3179,'5','1',652008.95,652148.21,139.26,22977.90,0.00,0.00,0.00,0.00,0.00),('21','237','1','77',3180,'7','1',1443597.37,1445980.43,2383.06,393204.90,0.00,0.00,0.00,0.00,0.00),('21','237','2','77',3181,'9','1',765474.81,766824.25,1349.44,222657.60,0.00,0.00,0.00,0.00,0.00),('21','237','2','77',3182,'11','1',575252.20,576871.32,1619.12,267154.80,0.00,0.00,0.00,0.00,0.00),('21','237','2','77',3183,'13','1',364665.30,366121.26,1455.96,240233.40,0.00,0.00,0.00,0.00,0.00),('21','237','2','77',3184,'15','1',575282.80,575582.41,299.61,49435.65,0.00,0.00,0.00,0.00,0.00),('21','237','3','77',3185,'17','1',415549.23,416748.31,1199.08,197848.20,0.00,0.00,0.00,0.00,0.00),('21','237','3','77',3186,'18','1',336256.26,336256.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','77',3187,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','77',3188,'23','1',438552.79,438592.70,39.91,6585.15,0.00,0.00,0.00,0.00,0.00),('21','237','4','77',3189,'25','1',188301.30,188301.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','77',3190,'27','1',196120.81,196120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','77',3191,'29','1',179292.21,179292.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','77',3192,'31','1',275359.24,275778.89,419.65,69242.25,0.00,0.00,0.00,0.00,0.00),('21','237','5','77',3193,'33','2',3524428.65,3528214.88,3786.23,2726085.60,0.00,0.00,0.00,0.00,0.00),('21','237','5','77',3194,'35','2',4002424.01,4007444.07,5020.06,3614443.20,0.00,0.00,0.00,0.00,0.00),('21','237','5','77',3195,'42','2',2897482.16,2900438.61,2956.45,2128644.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','77',3196,'43','2',2978223.62,2981150.57,2926.95,2107404.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','77',3197,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','77',3198,'45','2',2017908.84,2022608.53,4699.69,3383776.80,0.00,0.00,0.00,0.00,0.00),('21','237','6','77',3199,'46','2',4892886.07,4894865.06,1978.99,1424872.80,0.00,0.00,0.00,0.00,0.00),('21','237','6','77',3200,'47','2',4142840.00,4148033.43,5193.43,3739269.60,0.00,0.00,0.00,0.00,0.00),('21','237','7','77',3201,'48','2',2559146.06,2561199.19,2053.13,1478253.60,0.00,0.00,0.00,0.00,0.00),('21','237','7','77',3202,'49','2',2904872.57,2910841.70,5969.13,4297773.60,0.00,0.00,0.00,0.00,0.00),('21','237','1','77',3203,'50','1',996556.88,998318.69,1761.81,290698.65,0.00,0.00,0.00,0.00,0.00),('21','237','1','77',3204,'51','1',677853.23,677853.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','77',3205,'52','1',819946.63,820169.52,222.89,36776.85,0.00,0.00,0.00,0.00,0.00),('21','237','1','77',3206,'53','1',944159.67,945864.35,1704.68,281272.20,0.00,0.00,0.00,0.00,0.00),('21','237','2','77',3207,'54','1',643266.91,645899.16,2632.25,434321.25,0.00,0.00,0.00,0.00,0.00),('21','237','2','77',3208,'55','1',468087.88,468708.66,620.78,102428.70,0.00,0.00,0.00,0.00,0.00),('21','237','2','77',3209,'56','1',414074.57,414533.53,458.96,75728.40,0.00,0.00,0.00,0.00,0.00),('21','237','2','77',3210,'57','1',788629.20,790478.75,1849.55,305175.75,0.00,0.00,0.00,0.00,0.00),('21','237','3','77',3211,'58','1',756556.23,758791.70,2235.47,368852.55,0.00,0.00,0.00,0.00,0.00),('21','237','3','77',3212,'59','1',341990.39,341990.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','77',3213,'60','1',482905.83,483838.76,932.93,153933.45,0.00,0.00,0.00,0.00,0.00),('21','237','3','77',3214,'61','1',671019.56,672646.62,1627.06,268464.90,0.00,0.00,0.00,0.00,0.00),('21','237','4','77',3215,'62','1',219885.03,220769.83,884.80,145992.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','77',3216,'63','1',639235.77,640102.29,866.52,142975.80,0.00,0.00,0.00,0.00,0.00),('21','237','4','77',3217,'64','1',500376.40,502843.27,2466.87,407033.55,0.00,0.00,0.00,0.00,0.00),('21','237','4','77',3218,'65','1',240321.69,241745.20,1423.51,234879.15,0.00,0.00,0.00,0.00,0.00),('21','237','1','78',3219,'1','1',1418293.60,1419977.09,1683.49,277775.85,0.00,0.00,0.00,0.00,0.00),('21','237','1','78',3220,'3','1',865019.61,865128.12,108.51,17904.15,0.00,0.00,0.00,0.00,0.00),('21','237','1','78',3221,'5','1',652148.21,652363.16,214.95,35466.75,0.00,0.00,0.00,0.00,0.00),('21','237','1','78',3222,'7','1',1445980.43,1447585.02,1604.59,264757.35,0.00,0.00,0.00,0.00,0.00),('21','237','2','78',3223,'9','1',766824.25,767868.84,1044.59,172357.35,0.00,0.00,0.00,0.00,0.00),('21','237','2','78',3224,'11','1',576871.32,578771.35,1900.03,313504.95,0.00,0.00,0.00,0.00,0.00),('21','237','2','78',3225,'13','1',366121.26,366259.70,138.44,22842.60,0.00,0.00,0.00,0.00,0.00),('21','237','2','78',3226,'15','1',575582.41,575797.58,215.17,35503.05,0.00,0.00,0.00,0.00,0.00),('21','237','3','78',3227,'17','1',416748.31,416748.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','78',3228,'18','1',336256.26,336536.30,280.04,46206.60,0.00,0.00,0.00,0.00,0.00),('21','237','3','78',3229,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','78',3230,'23','1',438592.70,438592.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','78',3231,'25','1',188301.30,188301.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','78',3232,'27','1',196120.81,196120.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','78',3233,'29','1',179292.21,179292.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','78',3234,'31','1',275778.89,275778.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','78',3235,'33','2',3528214.88,3532143.64,3928.76,2828707.20,0.00,0.00,0.00,0.00,0.00),('21','237','5','78',3236,'35','2',4007444.07,4013806.13,6362.06,4580683.20,0.00,0.00,0.00,0.00,0.00),('21','237','5','78',3237,'42','2',2900438.61,2901793.63,1355.02,975614.40,0.00,0.00,0.00,0.00,0.00),('21','237','5','78',3238,'43','2',2981150.57,2982167.53,1016.96,732211.20,0.00,0.00,0.00,0.00,0.00),('21','237','6','78',3239,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','78',3240,'45','2',2022608.53,2024311.67,1703.14,1226260.80,0.00,0.00,0.00,0.00,0.00),('21','237','6','78',3241,'46','2',4894865.06,4896025.66,1160.60,835632.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','78',3242,'47','2',4148033.43,4151693.21,3659.78,2635041.60,0.00,0.00,0.00,0.00,0.00),('21','237','7','78',3243,'48','2',2561199.19,2564088.37,2889.18,2080209.60,0.00,0.00,0.00,0.00,0.00),('21','237','7','78',3244,'49','2',2910841.70,2914868.93,4027.23,2899605.60,0.00,0.00,0.00,0.00,0.00),('21','237','1','78',3245,'50','1',998318.69,999090.83,772.14,127403.10,0.00,0.00,0.00,0.00,0.00),('21','237','1','78',3246,'51','1',677853.23,677853.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','78',3247,'52','1',820169.52,820169.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','78',3248,'53','1',945864.35,947813.15,1948.80,321552.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','78',3249,'54','1',645899.16,648776.65,2877.49,474785.85,0.00,0.00,0.00,0.00,0.00),('21','237','2','78',3250,'55','1',468708.66,470117.10,1408.44,232392.60,0.00,0.00,0.00,0.00,0.00),('21','237','2','78',3251,'56','1',414533.53,414533.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','2','78',3252,'57','1',790478.75,793809.41,3330.66,549558.90,0.00,0.00,0.00,0.00,0.00),('21','237','3','78',3253,'58','1',758791.70,761252.52,2460.82,406035.30,0.00,0.00,0.00,0.00,0.00),('21','237','3','78',3254,'59','1',341990.39,343317.28,1326.89,218936.85,0.00,0.00,0.00,0.00,0.00),('21','237','3','78',3255,'60','1',483838.76,485087.59,1248.83,206056.95,0.00,0.00,0.00,0.00,0.00),('21','237','3','78',3256,'61','1',672646.62,672646.65,0.03,4.95,0.00,0.00,0.00,0.00,0.00),('21','237','4','78',3257,'62','1',220769.83,222709.93,1940.10,320116.50,0.00,0.00,0.00,0.00,0.00),('21','237','4','78',3258,'63','1',640102.29,641893.89,1791.60,295614.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','78',3259,'64','1',502843.27,502843.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','78',3260,'65','1',241745.20,244356.71,2611.51,430899.15,0.00,0.00,0.00,0.00,0.00),('21','237','1','79',3261,'1','1',1419977.09,1422866.01,2888.92,476671.80,0.00,0.00,0.00,0.00,0.00),('21','237','1','79',3262,'3','1',865128.12,866143.79,1015.67,167585.55,0.00,0.00,0.00,0.00,0.00),('21','237','1','79',3263,'5','1',652363.16,653150.75,787.59,129952.35,0.00,0.00,0.00,0.00,0.00),('21','237','1','79',3264,'7','1',1447585.02,1450429.05,2844.03,469264.95,0.00,0.00,0.00,0.00,0.00),('21','237','2','79',3265,'9','1',767868.84,769326.13,1457.29,240452.85,0.00,0.00,0.00,0.00,0.00),('21','237','2','79',3266,'11','1',578771.35,580358.54,1587.19,261886.35,0.00,0.00,0.00,0.00,0.00),('21','237','2','79',3267,'13','1',366259.70,368868.55,2608.85,430460.25,0.00,0.00,0.00,0.00,0.00),('21','237','2','79',3268,'15','1',575797.58,576058.82,261.24,43104.60,0.00,0.00,0.00,0.00,0.00),('21','237','3','79',3269,'17','1',416748.31,417189.66,441.35,72822.75,0.00,0.00,0.00,0.00,0.00),('21','237','3','79',3270,'18','1',336536.30,336536.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','79',3271,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','79',3272,'23','1',438592.70,438592.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','79',3273,'25','1',188301.30,188301.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','79',3274,'27','1',196120.81,196318.20,197.39,32569.35,0.00,0.00,0.00,0.00,0.00),('21','237','4','79',3275,'29','1',179292.21,179292.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','79',3276,'31','1',275778.89,275778.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','79',3277,'33','2',3532143.64,3533774.75,1631.11,1174399.20,0.00,0.00,0.00,0.00,0.00),('21','237','5','79',3278,'35','2',4013806.13,4019670.45,5864.32,4222310.40,0.00,0.00,0.00,0.00,0.00),('21','237','5','79',3279,'42','2',2901793.63,2902730.22,936.59,674344.80,0.00,0.00,0.00,0.00,0.00),('21','237','5','79',3280,'43','2',2982167.53,2984165.18,1997.65,1438308.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','79',3281,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','79',3282,'45','2',2024311.67,2026649.31,2337.64,1683100.80,0.00,0.00,0.00,0.00,0.00),('21','237','6','79',3283,'46','2',4896025.66,4900269.55,4243.89,3055600.80,0.00,0.00,0.00,0.00,0.00),('21','237','6','79',3284,'47','2',4151693.21,4156295.58,4602.37,3313706.40,0.00,0.00,0.00,0.00,0.00),('21','237','7','79',3285,'48','2',2564088.37,2566496.97,2408.60,1734192.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','79',3286,'49','2',2914868.93,2918922.05,4053.12,2918246.40,0.00,0.00,0.00,0.00,0.00),('21','237','1','79',3287,'50','1',999090.83,1000102.90,1012.07,166991.55,0.00,0.00,0.00,0.00,0.00),('21','237','1','79',3288,'51','1',677853.23,677853.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','79',3289,'52','1',820169.52,821101.91,932.39,153844.35,0.00,0.00,0.00,0.00,0.00),('21','237','1','79',3290,'53','1',947813.15,948388.09,574.94,94865.10,0.00,0.00,0.00,0.00,0.00),('21','237','2','79',3291,'54','1',648776.65,650714.21,1937.56,319697.40,0.00,0.00,0.00,0.00,0.00),('21','237','2','79',3292,'55','1',470117.10,471620.44,1503.34,248051.10,0.00,0.00,0.00,0.00,0.00),('21','237','2','79',3293,'56','1',414533.53,414980.14,446.61,73690.65,0.00,0.00,0.00,0.00,0.00),('21','237','2','79',3294,'57','1',793809.41,796979.22,3169.81,523018.65,0.00,0.00,0.00,0.00,0.00),('21','237','3','79',3295,'58','1',761252.52,761252.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','79',3296,'59','1',343317.28,343717.87,400.59,66097.35,0.00,0.00,0.00,0.00,0.00),('21','237','3','79',3297,'60','1',485087.59,486783.04,1695.45,279749.25,0.00,0.00,0.00,0.00,0.00),('21','237','3','79',3298,'61','1',672646.65,672771.57,124.92,20611.80,0.00,0.00,0.00,0.00,0.00),('21','237','4','79',3299,'62','1',222709.93,223598.93,889.00,146685.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','79',3300,'63','1',641893.89,643612.05,1718.16,283496.40,0.00,0.00,0.00,0.00,0.00),('21','237','4','79',3301,'64','1',502843.27,507743.43,4900.16,808526.40,0.00,0.00,0.00,0.00,0.00),('21','237','4','79',3302,'65','1',244356.71,246096.64,1739.93,287088.45,0.00,0.00,0.00,0.00,0.00),('21','237','1','80',3303,'1','1',1422866.01,1426139.50,3273.49,540125.85,0.00,0.00,0.00,0.00,0.00),('21','237','1','80',3304,'3','1',866143.79,867354.75,1210.96,199808.40,0.00,0.00,0.00,0.00,0.00),('21','237','1','80',3305,'5','1',653150.75,653197.41,46.66,7698.90,0.00,0.00,0.00,0.00,0.00),('21','237','1','80',3306,'7','1',1450429.05,1452325.33,1896.28,312886.20,0.00,0.00,0.00,0.00,0.00),('21','237','2','80',3307,'9','1',769326.13,770585.49,1259.36,207794.40,0.00,0.00,0.00,0.00,0.00),('21','237','2','80',3308,'11','1',580358.54,581909.91,1551.37,255976.05,0.00,0.00,0.00,0.00,0.00),('21','237','2','80',3309,'13','1',368868.55,369334.34,465.79,76855.35,0.00,0.00,0.00,0.00,0.00),('21','237','2','80',3310,'15','1',576058.82,576615.52,556.70,91855.50,0.00,0.00,0.00,0.00,0.00),('21','237','3','80',3311,'17','1',417189.66,418134.30,944.64,155865.60,0.00,0.00,0.00,0.00,0.00),('21','237','3','80',3312,'18','1',336536.30,337335.64,799.34,131891.10,0.00,0.00,0.00,0.00,0.00),('21','237','3','80',3313,'21','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','3','80',3314,'23','1',438592.70,438592.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','80',3315,'25','1',188301.30,188301.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','80',3316,'27','1',196318.20,196318.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','80',3317,'29','1',179292.21,179292.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','80',3318,'31','1',275778.89,276170.86,391.97,64675.05,0.00,0.00,0.00,0.00,0.00),('21','237','5','80',3319,'33','2',3533774.75,3535137.80,1363.05,981396.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','80',3320,'35','2',4019670.45,4025933.15,6262.70,4509144.00,0.00,0.00,0.00,0.00,0.00),('21','237','5','80',3321,'42','2',2902730.22,2907757.03,5026.81,3619303.20,0.00,0.00,0.00,0.00,0.00),('21','237','5','80',3322,'43','2',2984165.18,2988628.26,4463.08,3213417.60,0.00,0.00,0.00,0.00,0.00),('21','237','6','80',3323,'44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','80',3324,'45','2',2026649.31,2027069.31,420.00,302400.00,0.00,0.00,0.00,0.00,0.00),('21','237','6','80',3325,'46','2',4900269.55,4904915.87,4646.32,3345350.40,0.00,0.00,0.00,0.00,0.00),('21','237','6','80',3326,'47','2',4156295.58,4159019.23,2723.65,1961028.00,0.00,0.00,0.00,0.00,0.00),('21','237','7','80',3327,'48','2',2566496.97,2569698.21,3201.24,2304892.80,0.00,0.00,0.00,0.00,0.00),('21','237','7','80',3328,'49','2',2918922.05,2923569.89,4647.84,3346444.80,0.00,0.00,0.00,0.00,0.00),('21','237','1','80',3329,'50','1',1000102.90,1001256.27,1153.37,190306.05,0.00,0.00,0.00,0.00,0.00),('21','237','1','80',3330,'51','1',677853.23,677853.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','80',3331,'52','1',821101.91,821101.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','1','80',3332,'53','1',948388.09,949844.82,1456.73,240360.45,0.00,0.00,0.00,0.00,0.00),('21','237','2','80',3333,'54','1',650714.21,653300.95,2586.74,426812.10,0.00,0.00,0.00,0.00,0.00),('21','237','2','80',3334,'55','1',471620.44,473126.80,1506.36,248549.40,0.00,0.00,0.00,0.00,0.00),('21','237','2','80',3335,'56','1',414980.14,417062.40,2082.26,343572.90,0.00,0.00,0.00,0.00,0.00),('21','237','2','80',3336,'57','1',796979.22,800421.00,3441.78,567893.70,0.00,0.00,0.00,0.00,0.00),('21','237','3','80',3337,'58','1',761252.52,762881.27,1628.75,268743.75,0.00,0.00,0.00,0.00,0.00),('21','237','3','80',3338,'59','1',343717.87,344185.04,467.17,77083.05,0.00,0.00,0.00,0.00,0.00),('21','237','3','80',3339,'60','1',486783.04,487630.54,847.50,139837.50,0.00,0.00,0.00,0.00,0.00),('21','237','3','80',3340,'61','1',672771.57,672771.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('21','237','4','80',3341,'62','1',223598.93,224051.63,452.70,74695.50,0.00,0.00,0.00,0.00,0.00),('21','237','4','80',3342,'63','1',643612.05,643991.55,379.50,62617.50,0.00,0.00,0.00,0.00,0.00),('21','237','4','80',3343,'64','1',507743.43,509457.86,1714.43,282880.95,0.00,0.00,0.00,0.00,0.00),('21','237','4','80',3344,'65','1',246096.64,247778.45,1681.81,277498.65,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=161 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('21','237','1','2',640.00,640.00,0.00,0.00,0.00,0.00,0.00,1),('21','237','1','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,2),('21','237','2','2',640.00,640.00,42115.14,0.00,0.00,0.00,0.00,3),('21','237','2','1',165.00,165.00,59602.56,0.00,0.00,0.00,0.00,4),('21','237','3','2',640.00,640.00,42313.46,0.00,0.00,0.00,0.00,5),('21','237','3','1',165.00,165.00,22727.91,0.00,0.00,0.00,0.00,6),('21','237','4','2',640.00,640.00,0.00,0.00,0.00,0.00,0.00,7),('21','237','4','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,8),('21','237','5','2',640.00,640.00,25991.60,0.00,0.00,0.00,0.00,9),('21','237','5','1',165.00,165.00,53227.59,0.00,0.00,0.00,0.00,10),('21','237','6','2',640.00,640.00,24355.08,0.00,0.00,0.00,0.00,11),('21','237','6','1',165.00,165.00,52514.22,0.00,0.00,0.00,0.00,12),('21','237','7','2',640.00,640.00,21977.81,0.00,0.00,0.00,0.00,13),('21','237','7','1',165.00,165.00,39192.21,0.00,0.00,0.00,0.00,14),('21','237','8','2',640.00,640.00,36850.98,0.00,0.00,0.00,0.00,15),('21','237','8','1',165.00,165.00,5508.62,0.00,0.00,0.00,0.00,16),('21','237','9','2',640.00,640.00,42211.09,0.00,0.00,0.00,0.00,17),('21','237','9','1',165.00,165.00,58792.72,0.00,0.00,0.00,0.00,18),('21','237','10','2',640.00,640.00,0.00,0.00,0.00,0.00,0.00,19),('21','237','10','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,20),('21','237','11','2',640.00,640.00,46136.05,0.00,0.00,0.00,0.00,21),('21','237','11','1',165.00,165.00,54462.95,0.00,0.00,0.00,0.00,22),('21','237','12','2',640.00,640.00,32866.18,0.00,0.00,0.00,0.00,23),('21','237','12','1',165.00,165.00,53053.45,0.00,0.00,0.00,0.00,24),('21','237','13','2',640.00,640.00,0.00,0.00,0.00,0.00,0.00,25),('21','237','13','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,26),('21','237','14','2',640.00,640.00,34653.32,0.00,0.00,0.00,0.00,27),('21','237','14','1',165.00,165.00,51374.16,0.00,0.00,0.00,0.00,28),('21','237','15','2',640.00,640.00,33483.83,0.00,0.00,0.00,0.00,29),('21','237','15','1',165.00,165.00,61847.98,0.00,0.00,0.00,0.00,30),('21','237','16','2',640.00,640.00,39229.27,0.00,0.00,0.00,0.00,31),('21','237','16','1',165.00,165.00,53045.21,0.00,0.00,0.00,0.00,32),('21','237','17','2',640.00,640.00,42328.73,0.00,0.00,0.00,0.00,33),('21','237','17','1',165.00,165.00,63105.83,0.00,0.00,0.00,0.00,34),('21','237','18','2',640.00,640.00,35829.70,0.00,0.00,0.00,0.00,35),('21','237','18','1',165.00,165.00,59664.82,0.00,0.00,0.00,0.00,36),('21','237','19','2',640.00,640.00,31234.39,0.00,0.00,0.00,0.00,37),('21','237','19','1',165.00,165.00,66760.00,0.00,0.00,0.00,0.00,38),('21','237','20','2',640.00,640.00,23593.10,0.00,0.00,0.00,0.00,39),('21','237','20','1',165.00,165.00,14923.99,0.00,0.00,0.00,0.00,40),('21','237','21','2',640.00,640.00,47567.15,0.00,0.00,0.00,0.00,41),('21','237','21','1',165.00,165.00,40845.44,0.00,0.00,0.00,0.00,42),('21','237','22','2',640.00,640.00,43162.11,0.00,0.00,0.00,0.00,43),('21','237','22','1',165.00,165.00,50275.65,0.00,0.00,0.00,0.00,44),('21','237','23','2',640.00,640.00,37371.85,0.00,0.00,0.00,0.00,45),('21','237','23','1',165.00,165.00,55832.82,0.00,0.00,0.00,0.00,46),('21','237','24','2',640.00,640.00,43653.94,0.00,0.00,0.00,0.00,47),('21','237','24','1',165.00,165.00,53583.14,0.00,0.00,0.00,0.00,48),('21','237','25','2',640.00,640.00,48360.72,0.00,0.00,0.00,0.00,49),('21','237','25','1',165.00,165.00,52260.71,0.00,0.00,0.00,0.00,50),('21','237','26','2',640.00,640.00,39556.22,0.00,0.00,0.00,0.00,51),('21','237','26','1',165.00,165.00,45833.45,0.00,0.00,0.00,0.00,52),('21','237','27','2',640.00,640.00,34245.21,0.00,0.00,0.00,0.00,53),('21','237','27','1',165.00,165.00,30871.71,0.00,0.00,0.00,0.00,54),('21','237','28','2',640.00,640.00,39805.82,0.00,0.00,0.00,0.00,55),('21','237','28','1',165.00,165.00,48115.41,0.00,0.00,0.00,0.00,56),('21','237','29','2',640.00,640.00,43816.57,0.00,0.00,0.00,0.00,57),('21','237','29','1',165.00,165.00,50404.94,0.00,0.00,0.00,0.00,58),('21','237','30','2',640.00,640.00,52577.95,0.00,0.00,0.00,0.00,59),('21','237','30','1',165.00,165.00,45163.87,0.00,0.00,0.00,0.00,60),('21','237','31','2',640.00,640.00,0.00,0.00,0.00,0.00,0.00,61),('21','237','31','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,62),('21','237','32','2',640.00,640.00,48253.19,0.00,0.00,0.00,0.00,63),('21','237','32','1',165.00,165.00,47269.13,0.00,0.00,0.00,0.00,64),('21','237','33','2',640.00,640.00,47786.05,0.00,0.00,0.00,0.00,65),('21','237','33','1',165.00,165.00,47365.71,0.00,0.00,0.00,0.00,66),('21','237','34','2',640.00,640.00,53159.80,0.00,0.00,0.00,0.00,67),('21','237','34','1',165.00,165.00,48298.29,0.00,0.00,0.00,0.00,68),('21','237','35','2',640.00,640.00,39852.33,0.00,0.00,0.00,0.00,69),('21','237','35','1',165.00,165.00,34961.89,0.00,0.00,0.00,0.00,70),('21','237','36','2',640.00,640.00,35926.22,0.00,0.00,0.00,0.00,71),('21','237','36','1',165.00,165.00,44847.11,0.00,0.00,0.00,0.00,72),('21','237','37','2',640.00,640.00,0.00,0.00,0.00,0.00,0.00,73),('21','237','37','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,74),('21','237','38','2',640.00,640.00,57789.53,0.00,0.00,0.00,0.00,75),('21','237','38','1',165.00,165.00,42769.30,0.00,0.00,0.00,0.00,76),('21','237','39','2',640.00,640.00,37876.72,0.00,0.00,0.00,0.00,77),('21','237','39','1',165.00,165.00,29531.84,0.00,0.00,0.00,0.00,78),('21','237','40','2',640.00,640.00,0.00,0.00,0.00,0.00,0.00,79),('21','237','40','1',165.00,165.00,40688.07,0.00,0.00,0.00,0.00,80),('21','237','41','2',640.00,640.00,29330.59,0.00,0.00,0.00,0.00,81),('21','237','41','1',165.00,165.00,40267.32,0.00,0.00,0.00,0.00,82),('21','237','42','2',640.00,650.00,0.00,0.00,0.00,0.00,0.00,83),('21','237','42','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,84),('21','237','43','2',640.00,650.00,57348.56,0.00,0.00,0.00,0.00,85),('21','237','43','1',165.00,165.00,47465.76,0.00,0.00,0.00,0.00,86),('21','237','44','2',640.00,650.00,20693.04,0.00,0.00,0.00,0.00,87),('21','237','44','1',165.00,165.00,33372.30,0.00,0.00,0.00,0.00,88),('21','237','45','2',640.00,650.00,25492.11,0.00,0.00,0.00,0.00,89),('21','237','45','1',165.00,165.00,9908.97,0.00,0.00,0.00,0.00,90),('21','237','46','2',640.00,650.00,1670.02,0.00,0.00,0.00,0.00,91),('21','237','46','1',165.00,165.00,66035.36,0.00,0.00,0.00,0.00,92),('21','237','47','2',650.00,650.00,18668.39,0.00,0.00,0.00,0.00,93),('21','237','47','1',165.00,165.00,32913.58,0.00,0.00,0.00,0.00,94),('21','237','48','2',650.00,650.00,39899.52,0.00,0.00,0.00,0.00,95),('21','237','48','1',165.00,165.00,37488.11,0.00,0.00,0.00,0.00,96),('21','237','49','2',650.00,650.00,39798.95,0.00,0.00,0.00,0.00,97),('21','237','49','1',165.00,165.00,38761.48,0.00,0.00,0.00,0.00,98),('21','237','50','2',650.00,650.00,30732.31,0.00,0.00,0.00,0.00,99),('21','237','50','1',165.00,165.00,39421.32,0.00,0.00,0.00,0.00,100),('21','237','51','2',650.00,650.00,36602.20,0.00,0.00,0.00,0.00,101),('21','237','51','1',165.00,165.00,37422.92,0.00,0.00,0.00,0.00,102),('21','237','52','2',650.00,650.00,32158.10,0.00,0.00,0.00,0.00,103),('21','237','52','1',165.00,165.00,33850.65,0.00,0.00,0.00,0.00,104),('21','237','53','2',650.00,650.00,64357.56,0.00,0.00,0.00,0.00,105),('21','237','53','1',165.00,165.00,33864.32,0.00,0.00,0.00,0.00,106),('21','237','54','2',650.00,650.00,46032.64,0.00,0.00,0.00,0.00,107),('21','237','54','1',165.00,165.00,35659.28,0.00,0.00,0.00,0.00,108),('21','237','55','2',650.00,650.00,57497.12,0.00,0.00,0.00,0.00,109),('21','237','55','1',165.00,165.00,35485.76,0.00,0.00,0.00,0.00,110),('21','237','56','2',650.00,650.00,0.00,0.00,0.00,0.00,0.00,111),('21','237','56','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,112),('21','237','57','2',650.00,650.00,40595.29,0.00,0.00,0.00,0.00,113),('21','237','57','1',165.00,165.00,33691.72,0.00,0.00,0.00,0.00,114),('21','237','58','2',650.00,690.00,56608.65,0.00,0.00,0.00,0.00,115),('21','237','58','1',165.00,165.00,38840.04,0.00,0.00,0.00,0.00,116),('21','237','59','2',650.00,690.00,32136.82,0.00,0.00,0.00,0.00,117),('21','237','59','1',165.00,165.00,36147.91,0.00,0.00,0.00,0.00,118),('21','237','60','2',650.00,690.00,0.00,0.00,0.00,0.00,0.00,119),('21','237','60','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,120),('21','237','61','2',680.00,690.00,0.00,0.00,0.00,0.00,0.00,121),('21','237','61','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,122),('21','237','62','2',690.00,690.00,18984.27,0.00,0.00,0.00,0.00,123),('21','237','62','1',165.00,165.00,34672.99,0.00,0.00,0.00,0.00,124),('21','237','63','2',690.00,680.00,0.00,0.00,0.00,0.00,0.00,125),('21','237','63','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,126),('21','237','64','2',680.00,680.00,21416.30,0.00,0.00,0.00,0.00,127),('21','237','64','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,128),('21','237','65','2',680.00,680.00,53424.07,0.00,0.00,0.00,0.00,129),('21','237','65','1',165.00,165.00,33899.17,0.00,0.00,0.00,0.00,130),('21','237','66','2',680.00,680.00,57177.74,0.00,0.00,0.00,0.00,131),('21','237','66','1',165.00,165.00,30891.99,0.00,0.00,0.00,0.00,132),('21','237','67','2',680.00,680.00,56360.74,0.00,0.00,0.00,0.00,133),('21','237','67','1',165.00,165.00,32037.54,0.00,0.00,0.00,0.00,134),('21','237','68','2',680.00,680.00,42544.80,0.00,0.00,0.00,0.00,135),('21','237','68','1',165.00,165.00,33327.33,0.00,0.00,0.00,0.00,136),('21','237','69','2',680.00,680.00,41149.40,0.00,0.00,0.00,0.00,137),('21','237','69','1',165.00,165.00,30693.44,0.00,0.00,0.00,0.00,138),('21','237','70','2',680.00,680.00,40465.37,0.00,0.00,0.00,0.00,139),('21','237','70','1',165.00,165.00,30143.22,0.00,0.00,0.00,0.00,140),('21','237','71','2',700.00,700.00,38057.33,0.00,0.00,0.00,0.00,141),('21','237','71','1',165.00,165.00,32281.93,0.00,0.00,0.00,0.00,142),('21','237','72','2',700.00,700.00,16183.08,0.00,0.00,0.00,0.00,143),('21','237','72','1',165.00,165.00,30328.47,0.00,0.00,0.00,0.00,144),('21','237','73','2',700.00,700.00,29539.34,0.00,0.00,0.00,0.00,145),('21','237','73','1',165.00,165.00,26136.71,0.00,0.00,0.00,0.00,146),('21','237','74','2',700.00,700.00,39442.06,0.00,0.00,0.00,0.00,147),('21','237','74','1',165.00,165.00,28903.32,0.00,0.00,0.00,0.00,148),('21','237','75','2',720.00,720.00,15443.89,0.00,0.00,0.00,0.00,149),('21','237','75','1',165.00,165.00,0.00,0.00,0.00,0.00,0.00,150),('21','237','76','2',720.00,720.00,40617.46,0.00,0.00,0.00,0.00,151),('21','237','76','1',165.00,165.00,33510.67,0.00,0.00,0.00,0.00,152),('21','237','77','2',720.00,720.00,34584.06,0.00,0.00,0.00,0.00,153),('21','237','77','1',165.00,165.00,32223.91,0.00,0.00,0.00,0.00,154),('21','237','78','2',720.00,720.00,26102.73,0.00,0.00,0.00,0.00,155),('21','237','78','1',165.00,165.00,28907.12,0.00,0.00,0.00,0.00,156),('21','237','79','2',720.00,720.00,28075.29,0.00,0.00,0.00,0.00,157),('21','237','79','1',165.00,165.00,35134.45,0.00,0.00,0.00,0.00,158),('21','237','80','2',720.00,720.00,32754.69,0.00,0.00,0.00,0.00,159),('21','237','80','1',165.00,165.00,31795.66,0.00,0.00,0.00,0.00,160);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('21',1,'237','PRODUCT TANKS','TANKS CONSTAINING PRODUCTS');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('21','237','1',1,0,'1','PMS TANK 1 & 2',114000.00,0.00,NULL,'TANK CONTAINING PETROLEUM PRODUCTS','764','2022-03-03 18:25:06','2022-03-26 13:24:06','764',5,0),('21','237','1',2,0,'1','PMS TANK 3',57000.00,0.00,NULL,'TANK CONTAINING PETROLEUM PRODUCTS','764','2022-03-03 18:36:04','2022-03-26 13:21:56','764',5,0),('21','237','1',3,0,'1','PMS TANK 4',58000.00,0.00,NULL,'TANK CONTAINING PETROLEUM PRODUCTS','764','2022-03-03 18:42:52','2022-03-26 13:22:49','764',5,0),('21','237','1',4,0,'1','PMS TANK 5',57000.00,0.00,NULL,'TANK CONTAINING PETROLEUM PRODUCTS','764','2022-03-03 18:48:07','2022-03-26 13:37:21','764',5,0),('21','237','1',5,0,'2','AGO TANK 1',57000.00,0.00,NULL,'TANK CONTAINING DEISEL PRODUCTS','764','2022-03-03 20:52:45','2022-03-26 13:26:59','764',5,0),('21','237','1',6,0,'2','AGO TANK 2',58000.00,0.00,NULL,'TANK CONTAINING DEISEL PRODUCTS','764','2022-03-03 23:26:26','2022-03-26 15:09:37','764',5,0),('21','237','1',7,0,'2','AGO TANK 3',58000.00,0.00,NULL,'TANK CONTAINING DEISEL PRODUCTS','764','2022-03-03 23:32:30','2022-03-26 13:27:58','764',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2778 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (1,'21','237','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,0.00,0.00,'2022-03-26 14:02:02','',''),(2,'21','237','1',0,'Inventory adjustment from tank dipping to 2200',0.00,0.00,2200.00,0.00,0.00,'2022-03-26 14:02:02','',''),(3,'21','237','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,0.00,0.00,'2022-03-26 14:02:29','',''),(4,'21','237','2',0,'Inventory adjustment from tank dipping to 29600',0.00,0.00,29600.00,0.00,0.00,'2022-03-26 14:02:29','',''),(5,'21','237','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,0.00,0.00,'2022-03-26 14:03:45','',''),(6,'21','237','3',0,'Inventory adjustment from tank dipping to 27500',0.00,0.00,27500.00,0.00,0.00,'2022-03-26 14:03:45','',''),(7,'21','237','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,0.00,0.00,'2022-03-26 14:04:13','',''),(8,'21','237','4',0,'Inventory adjustment from tank dipping to 43600',0.00,0.00,43600.00,0.00,0.00,'2022-03-26 14:04:13','',''),(9,'21','237','5',0,'Tank level zero out for dipping',0.00,0.00,0.00,0.00,0.00,'2022-03-26 14:04:36','',''),(10,'21','237','5',0,'Inventory adjustment from tank dipping to 8850',0.00,0.00,8850.00,0.00,0.00,'2022-03-26 14:04:36','',''),(11,'21','237','6',0,'Tank level zero out for dipping',0.00,0.00,0.00,0.00,0.00,'2022-03-26 14:04:59','',''),(12,'21','237','6',0,'Inventory adjustment from tank dipping to 4000',0.00,0.00,4000.00,0.00,0.00,'2022-03-26 14:04:59','',''),(13,'21','237','7',0,'Tank level zero out for dipping',0.00,0.00,0.00,0.00,0.00,'2022-03-26 14:05:23','',''),(14,'21','237','7',0,'Inventory adjustment from tank dipping to 10600',0.00,0.00,10600.00,0.00,0.00,'2022-03-26 14:05:23','',''),(15,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,30284800.00,47320.00,0.00,0.00,'2022-03-26 14:58:53','',''),(16,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,28800000.00,45000.00,0.00,0.00,'2022-03-26 14:59:15','',''),(17,'21','237',NULL,2,'Reception corrector for bridging 1',0.00,0.00,0.00,47320.00,0.00,'2022-03-26 15:13:48','',''),(18,'21','237','5',2,'Received from bridging 1',0.00,0.00,47320.00,0.00,0.00,'2022-03-26 15:13:48','',''),(19,'21','237',NULL,2,'Reception corrector for bridging 3',0.00,0.00,0.00,15000.00,0.00,'2022-03-26 15:14:09','',''),(20,'21','237','7',2,'Received from bridging 3',0.00,0.00,15000.00,0.00,0.00,'2022-03-26 15:14:09','',''),(21,'21','237',NULL,2,'Reception corrector for bridging 2',0.00,0.00,0.00,30000.00,0.00,'2022-03-26 15:14:09','',''),(22,'21','237','6',2,'Received from bridging 2',0.00,0.00,30000.00,0.00,0.00,'2022-03-26 15:14:09','',''),(23,'21','237','2',1,'Sale Id shift 2',0.00,0.00,0.00,1825.50,0.00,'2022-03-26 18:03:53','',''),(24,'21','237','2',1,'Sale Id shift 2',0.00,0.00,0.00,136.97,0.00,'2022-03-26 18:03:53','',''),(25,'21','237','2',1,'Sale Id shift 2',0.00,0.00,0.00,2975.24,0.00,'2022-03-26 18:03:53','',''),(26,'21','237','3',1,'Sale Id shift 2',0.00,0.00,0.00,3550.79,0.00,'2022-03-26 18:03:53','',''),(27,'21','237','3',1,'Sale Id shift 2',0.00,0.00,0.00,1522.23,0.00,'2022-03-26 18:03:53','',''),(28,'21','237','3',1,'Sale Id shift 2',0.00,0.00,0.00,1635.85,0.00,'2022-03-26 18:03:53','',''),(29,'21','237','4',1,'Sale Id shift 2',0.00,0.00,0.00,3786.59,0.00,'2022-03-26 18:03:53','',''),(30,'21','237','4',1,'Sale Id shift 2',0.00,0.00,0.00,0.03,0.00,'2022-03-26 18:03:53','',''),(31,'21','237','4',1,'Sale Id shift 2',0.00,0.00,0.00,1972.62,0.00,'2022-03-26 18:03:53','',''),(32,'21','237','4',1,'Sale Id shift 2',0.00,0.00,0.00,1199.92,0.00,'2022-03-26 18:03:53','',''),(33,'21','237','5',2,'Sale Id shift 2',0.00,0.00,0.00,4805.15,0.00,'2022-03-26 18:03:53','',''),(34,'21','237','5',2,'Sale Id shift 2',0.00,0.00,0.00,3722.97,0.00,'2022-03-26 18:03:53','',''),(35,'21','237','5',2,'Sale Id shift 2',0.00,0.00,0.00,3803.16,0.00,'2022-03-26 18:03:53','',''),(36,'21','237','5',2,'Sale Id shift 2',0.00,0.00,0.00,5367.49,0.00,'2022-03-26 18:03:53','',''),(37,'21','237','6',2,'Sale Id shift 2',0.00,0.00,0.00,2770.23,0.00,'2022-03-26 18:03:53','',''),(38,'21','237','6',2,'Sale Id shift 2',0.00,0.00,0.00,4508.97,0.00,'2022-03-26 18:03:53','',''),(39,'21','237','6',2,'Sale Id shift 2',0.00,0.00,0.00,3296.05,0.00,'2022-03-26 18:03:53','',''),(40,'21','237','7',2,'Sale Id shift 2',0.00,0.00,0.00,6812.56,0.00,'2022-03-26 18:03:53','',''),(41,'21','237','7',2,'Sale Id shift 2',0.00,0.00,0.00,7028.56,0.00,'2022-03-26 18:03:53','',''),(42,'21','237','2',1,'Sale Id shift 2',0.00,0.00,0.00,1526.64,0.00,'2022-03-26 18:03:53','',''),(43,'21','237','2',1,'Sale Id shift 2',0.00,0.00,0.00,2187.01,0.00,'2022-03-26 18:03:53','',''),(44,'21','237','2',1,'Sale Id shift 2',0.00,0.00,0.00,1697.65,0.00,'2022-03-26 18:03:53','',''),(45,'21','237','2',1,'Sale Id shift 2',0.00,0.00,0.00,6822.54,0.00,'2022-03-26 18:03:53','',''),(46,'21','237','3',1,'Sale Id shift 2',0.00,0.00,0.00,3575.77,0.00,'2022-03-26 18:03:53','',''),(47,'21','237','3',1,'Sale Id shift 2',0.00,0.00,0.00,1885.41,0.00,'2022-03-26 18:03:53','',''),(48,'21','237','3',1,'Sale Id shift 2',0.00,0.00,0.00,5301.99,0.00,'2022-03-26 18:03:53','',''),(49,'21','237','3',1,'Sale Id shift 2',0.00,0.00,0.00,1335.18,0.00,'2022-03-26 18:03:53','',''),(50,'21','237','4',1,'Sale Id shift 2',0.00,0.00,0.00,0.25,0.00,'2022-03-26 18:03:53','',''),(51,'21','237','4',1,'Sale Id shift 2',0.00,0.00,0.00,5038.57,0.00,'2022-03-26 18:03:53','',''),(52,'21','237','4',1,'Sale Id shift 2',0.00,0.00,0.00,3931.57,0.00,'2022-03-26 18:03:53','',''),(53,'21','237','4',1,'Sale Id shift 2',0.00,0.00,0.00,3370.35,0.00,'2022-03-26 18:03:53','',''),(54,'21','237','2',1,'Sale Id shift 2',0.00,0.00,0.00,4323.89,0.00,'2022-03-26 18:03:53','',''),(55,'21','237',NULL,2,'Sale Id shift 2',26953689.60,0.00,0.00,0.00,0.00,'2022-03-26 18:03:53','',''),(56,'21','237',NULL,1,'Sale Id shift 2',9834422.40,0.00,0.00,0.00,0.00,'2022-03-26 18:03:53','',''),(57,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,19200000.00,30000.00,0.00,0.00,'2022-03-27 11:36:00','',''),(58,'21','237',NULL,2,'Reception corrector for bridging 5',0.00,0.00,0.00,30000.00,0.00,'2022-03-27 11:47:06','',''),(59,'21','237','7',2,'Received from bridging 5',0.00,0.00,30000.00,0.00,0.00,'2022-03-27 11:47:06','',''),(60,'21','237','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,8104.56,0.00,'2022-03-27 12:07:38','',''),(61,'21','237','2',0,'Inventory adjustment from tank dipping to 5800',0.00,0.00,5800.00,0.00,0.00,'2022-03-27 12:07:38','',''),(62,'21','237','2',1,'Sale Id shift 3',0.00,0.00,0.00,530.09,0.00,'2022-03-27 12:31:04','',''),(63,'21','237','2',1,'Sale Id shift 3',0.00,0.00,0.00,654.93,0.00,'2022-03-27 12:31:04','',''),(64,'21','237','2',1,'Sale Id shift 3',0.00,0.00,0.00,366.50,0.00,'2022-03-27 12:31:04','',''),(65,'21','237','3',1,'Sale Id shift 3',0.00,0.00,0.00,226.76,0.00,'2022-03-27 12:31:04','',''),(66,'21','237','3',1,'Sale Id shift 3',0.00,0.00,0.00,1418.91,0.00,'2022-03-27 12:31:04','',''),(67,'21','237','3',1,'Sale Id shift 3',0.00,0.00,0.00,479.80,0.00,'2022-03-27 12:31:04','',''),(68,'21','237','4',1,'Sale Id shift 3',0.00,0.00,0.00,2440.80,0.00,'2022-03-27 12:31:04','',''),(69,'21','237','4',1,'Sale Id shift 3',0.00,0.00,0.00,1332.41,0.00,'2022-03-27 12:31:04','',''),(70,'21','237','4',1,'Sale Id shift 3',0.00,0.00,0.00,1197.07,0.00,'2022-03-27 12:31:04','',''),(71,'21','237','5',2,'Sale Id shift 3',0.00,0.00,0.00,4635.02,0.00,'2022-03-27 12:31:04','',''),(72,'21','237','5',2,'Sale Id shift 3',0.00,0.00,0.00,6264.03,0.00,'2022-03-27 12:31:04','',''),(73,'21','237','5',2,'Sale Id shift 3',0.00,0.00,0.00,92.34,0.00,'2022-03-27 12:31:04','',''),(74,'21','237','5',2,'Sale Id shift 3',0.00,0.00,0.00,5319.99,0.00,'2022-03-27 12:31:04','',''),(75,'21','237','6',2,'Sale Id shift 3',0.00,0.00,0.00,7472.22,0.00,'2022-03-27 12:31:04','',''),(76,'21','237','6',2,'Sale Id shift 3',0.00,0.00,0.00,6128.25,0.00,'2022-03-27 12:31:04','',''),(77,'21','237','6',2,'Sale Id shift 3',0.00,0.00,0.00,6186.44,0.00,'2022-03-27 12:31:04','',''),(78,'21','237','7',2,'Sale Id shift 3',0.00,0.00,0.00,2147.09,0.00,'2022-03-27 12:31:04','',''),(79,'21','237','7',2,'Sale Id shift 3',0.00,0.00,0.00,4068.08,0.00,'2022-03-27 12:31:04','',''),(80,'21','237','2',1,'Sale Id shift 3',0.00,0.00,0.00,320.07,0.00,'2022-03-27 12:31:04','',''),(81,'21','237','2',1,'Sale Id shift 3',0.00,0.00,0.00,838.58,0.00,'2022-03-27 12:31:04','',''),(82,'21','237','2',1,'Sale Id shift 3',0.00,0.00,0.00,718.17,0.00,'2022-03-27 12:31:04','',''),(83,'21','237','2',1,'Sale Id shift 3',0.00,0.00,0.00,603.10,0.00,'2022-03-27 12:31:04','',''),(84,'21','237','3',1,'Sale Id shift 3',0.00,0.00,0.00,314.19,0.00,'2022-03-27 12:31:04','',''),(85,'21','237','3',1,'Sale Id shift 3',0.00,0.00,0.00,1749.07,0.00,'2022-03-27 12:31:04','',''),(86,'21','237','3',1,'Sale Id shift 3',0.00,0.00,0.00,2943.19,0.00,'2022-03-27 12:31:04','',''),(87,'21','237','3',1,'Sale Id shift 3',0.00,0.00,0.00,207.11,0.00,'2022-03-27 12:31:04','',''),(88,'21','237','4',1,'Sale Id shift 3',0.00,0.00,0.00,2200.34,0.00,'2022-03-27 12:31:04','',''),(89,'21','237','4',1,'Sale Id shift 3',0.00,0.00,0.00,1892.95,0.00,'2022-03-27 12:31:04','',''),(90,'21','237','4',1,'Sale Id shift 3',0.00,0.00,0.00,1943.83,0.00,'2022-03-27 12:31:04','',''),(91,'21','237','2',1,'Sale Id shift 3',0.00,0.00,0.00,350.04,0.00,'2022-03-27 12:31:04','',''),(92,'21','237',NULL,2,'Sale Id shift 3',27080614.40,0.00,0.00,0.00,0.00,'2022-03-27 12:31:04','',''),(93,'21','237',NULL,1,'Sale Id shift 3',3750105.15,0.00,0.00,0.00,0.00,'2022-03-27 12:31:04','',''),(94,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9600000.00,15000.00,0.00,0.00,'2022-03-27 12:31:30','',''),(95,'21','237',NULL,2,'Reception corrector for bridging 6',0.00,0.00,0.00,15000.00,0.00,'2022-03-27 12:32:19','',''),(96,'21','237','7',2,'Received from bridging 6',0.00,0.00,15000.00,0.00,0.00,'2022-03-27 12:32:19','',''),(97,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9600000.00,15000.00,0.00,0.00,'2022-03-28 15:11:49','',''),(98,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,32000000.00,50000.00,0.00,0.00,'2022-03-28 15:13:55','',''),(99,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-03-28 15:16:21','',''),(100,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-03-28 15:17:47','',''),(101,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-03-28 15:20:21','',''),(102,'21','237',NULL,1,'Reception corrector for bridging 11',0.00,0.00,0.00,15000.00,0.00,'2022-03-28 15:23:08','',''),(103,'21','237','1',1,'Received from bridging 11',0.00,0.00,15000.00,0.00,0.00,'2022-03-28 15:23:08','',''),(104,'21','237',NULL,1,'Reception corrector for bridging 10',0.00,0.00,0.00,30000.00,0.00,'2022-03-28 15:23:47','',''),(105,'21','237','4',1,'Received from bridging 10',0.00,0.00,30000.00,0.00,0.00,'2022-03-28 15:23:47','',''),(106,'21','237',NULL,1,'Reception corrector for bridging 9',0.00,0.00,0.00,45000.00,0.00,'2022-03-28 15:24:18','',''),(107,'21','237','2',1,'Received from bridging 9',0.00,0.00,45000.00,0.00,0.00,'2022-03-28 15:24:18','',''),(108,'21','237',NULL,2,'Reception corrector for bridging 7',0.00,0.00,0.00,15000.00,0.00,'2022-03-28 15:25:47','',''),(109,'21','237','5',2,'Received from bridging 7',0.00,0.00,15000.00,0.00,0.00,'2022-03-28 15:25:47','',''),(110,'21','237',NULL,2,'Reception corrector for bridging 13',0.00,0.00,0.00,50000.00,0.00,'2022-03-28 15:31:42','',''),(111,'21','237','6',2,'Received from bridging 13',0.00,0.00,50000.00,0.00,0.00,'2022-03-28 15:31:42','',''),(112,'21','237',NULL,1,'Reception corrector for bridging 14',0.00,0.00,0.00,15000.00,0.00,'2022-03-28 16:55:33','',''),(113,'21','237','1',1,'Received from bridging 14',0.00,0.00,15000.00,0.00,0.00,'2022-03-28 16:55:33','',''),(114,'21','237','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,32200.00,0.00,'2022-03-31 14:19:56','',''),(115,'21','237','1',0,'Inventory adjustment from tank dipping to 17200',0.00,0.00,17200.00,0.00,0.00,'2022-03-31 14:19:56','',''),(116,'21','237','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,46418.52,0.00,'2022-03-31 14:20:31','',''),(117,'21','237','2',0,'Inventory adjustment from tank dipping to 46400',0.00,0.00,46400.00,0.00,0.00,'2022-03-31 14:20:31','',''),(118,'21','237','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,1353.75,0.00,'2022-03-31 14:21:11','',''),(119,'21','237','3',0,'Inventory adjustment from tank dipping to 46700',0.00,0.00,46700.00,0.00,0.00,'2022-03-31 14:21:11','',''),(120,'21','237','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,43292.70,0.00,'2022-03-31 14:21:49','',''),(121,'21','237','4',0,'Inventory adjustment from tank dipping to 46400',0.00,0.00,46400.00,0.00,0.00,'2022-03-31 14:21:49','',''),(122,'21','237','5',0,'Tank level zero out for dipping',0.00,0.00,0.00,37159.85,0.00,'2022-03-31 14:22:10','',''),(123,'21','237','5',0,'Inventory adjustment from tank dipping to 38200',0.00,0.00,38200.00,0.00,0.00,'2022-03-31 14:22:10','',''),(124,'21','237','6',0,'Tank level zero out for dipping',0.00,0.00,0.00,53637.84,0.00,'2022-03-31 14:22:28','',''),(125,'21','237','6',0,'Inventory adjustment from tank dipping to 49700',0.00,0.00,49700.00,0.00,0.00,'2022-03-31 14:22:28','',''),(126,'21','237','7',0,'Tank level zero out for dipping',0.00,0.00,0.00,50543.71,0.00,'2022-03-31 14:22:49','',''),(127,'21','237','7',0,'Inventory adjustment from tank dipping to 57000',0.00,0.00,57000.00,0.00,0.00,'2022-03-31 14:22:49','',''),(128,'21','237','3',1,'Sale Id shift 5',0.00,0.00,0.00,4672.54,0.00,'2022-03-31 18:09:16','',''),(129,'21','237','3',1,'Sale Id shift 5',0.00,0.00,0.00,1510.07,0.00,'2022-03-31 18:09:16','',''),(130,'21','237','3',1,'Sale Id shift 5',0.00,0.00,0.00,5839.84,0.00,'2022-03-31 18:09:16','',''),(131,'21','237','4',1,'Sale Id shift 5',0.00,0.00,0.00,4059.42,0.00,'2022-03-31 18:09:16','',''),(132,'21','237','4',1,'Sale Id shift 5',0.00,0.00,0.00,2680.01,0.00,'2022-03-31 18:09:16','',''),(133,'21','237','4',1,'Sale Id shift 5',0.00,0.00,0.00,3101.19,0.00,'2022-03-31 18:09:16','',''),(134,'21','237','5',2,'Sale Id shift 5',0.00,0.00,0.00,2468.93,0.00,'2022-03-31 18:09:16','',''),(135,'21','237','5',2,'Sale Id shift 5',0.00,0.00,0.00,3895.06,0.00,'2022-03-31 18:09:16','',''),(136,'21','237','5',2,'Sale Id shift 5',0.00,0.00,0.00,2019.60,0.00,'2022-03-31 18:09:16','',''),(137,'21','237','5',2,'Sale Id shift 5',0.00,0.00,0.00,3199.04,0.00,'2022-03-31 18:09:16','',''),(138,'21','237','6',2,'Sale Id shift 5',0.00,0.00,0.00,1481.08,0.00,'2022-03-31 18:09:16','',''),(139,'21','237','6',2,'Sale Id shift 5',0.00,0.00,0.00,3332.09,0.00,'2022-03-31 18:09:16','',''),(140,'21','237','6',2,'Sale Id shift 5',0.00,0.00,0.00,4524.63,0.00,'2022-03-31 18:09:16','',''),(141,'21','237','7',2,'Sale Id shift 5',0.00,0.00,0.00,5071.17,0.00,'2022-03-31 18:09:16','',''),(142,'21','237','3',1,'Sale Id shift 5',0.00,0.00,0.00,5897.72,0.00,'2022-03-31 18:09:16','',''),(143,'21','237','3',1,'Sale Id shift 5',0.00,0.00,0.00,3863.76,0.00,'2022-03-31 18:09:16','',''),(144,'21','237','3',1,'Sale Id shift 5',0.00,0.00,0.00,4055.32,0.00,'2022-03-31 18:09:16','',''),(145,'21','237','3',1,'Sale Id shift 5',0.00,0.00,0.00,4015.50,0.00,'2022-03-31 18:09:16','',''),(146,'21','237','4',1,'Sale Id shift 5',0.00,0.00,0.00,0.03,0.00,'2022-03-31 18:09:16','',''),(147,'21','237','4',1,'Sale Id shift 5',0.00,0.00,0.00,5238.85,0.00,'2022-03-31 18:09:16','',''),(148,'21','237','4',1,'Sale Id shift 5',0.00,0.00,0.00,4379.01,0.00,'2022-03-31 18:09:16','',''),(149,'21','237','4',1,'Sale Id shift 5',0.00,0.00,0.00,3914.33,0.00,'2022-03-31 18:09:16','',''),(150,'21','237',NULL,2,'Sale Id shift 5',16634624.00,0.00,0.00,0.00,0.00,'2022-03-31 18:09:16','',''),(151,'21','237',NULL,1,'Sale Id shift 5',8782552.35,0.00,0.00,0.00,0.00,'2022-03-31 18:09:16','',''),(152,'21','237','1',1,'Sale Id shift 6',0.00,0.00,0.00,2853.30,0.00,'2022-04-05 12:26:35','',''),(153,'21','237','3',1,'Sale Id shift 6',0.00,0.00,0.00,3142.73,0.00,'2022-04-05 12:26:35','',''),(154,'21','237','3',1,'Sale Id shift 6',0.00,0.00,0.00,1506.73,0.00,'2022-04-05 12:26:35','',''),(155,'21','237','3',1,'Sale Id shift 6',0.00,0.00,0.00,2168.50,0.00,'2022-04-05 12:26:35','',''),(156,'21','237','4',1,'Sale Id shift 6',0.00,0.00,0.00,4172.67,0.00,'2022-04-05 12:26:35','',''),(157,'21','237','4',1,'Sale Id shift 6',0.00,0.00,0.00,3352.09,0.00,'2022-04-05 12:26:35','',''),(158,'21','237','1',1,'Sale Id shift 6',0.00,0.00,0.00,2022.74,0.00,'2022-04-05 12:26:35','',''),(159,'21','237','4',1,'Sale Id shift 6',0.00,0.00,0.00,4148.67,0.00,'2022-04-05 12:26:35','',''),(160,'21','237','5',2,'Sale Id shift 6',0.00,0.00,0.00,3217.53,0.00,'2022-04-05 12:26:35','',''),(161,'21','237','5',2,'Sale Id shift 6',0.00,0.00,0.00,2505.13,0.00,'2022-04-05 12:26:35','',''),(162,'21','237','5',2,'Sale Id shift 6',0.00,0.00,0.00,1783.14,0.00,'2022-04-05 12:26:35','',''),(163,'21','237','5',2,'Sale Id shift 6',0.00,0.00,0.00,1152.92,0.00,'2022-04-05 12:26:35','',''),(164,'21','237','6',2,'Sale Id shift 6',0.00,0.00,0.00,1788.60,0.00,'2022-04-05 12:26:35','',''),(165,'21','237','6',2,'Sale Id shift 6',0.00,0.00,0.00,5649.26,0.00,'2022-04-05 12:26:35','',''),(166,'21','237','6',2,'Sale Id shift 6',0.00,0.00,0.00,2836.39,0.00,'2022-04-05 12:26:35','',''),(167,'21','237','7',2,'Sale Id shift 6',0.00,0.00,0.00,338.95,0.00,'2022-04-05 12:26:35','',''),(168,'21','237','7',2,'Sale Id shift 6',0.00,0.00,0.00,5083.16,0.00,'2022-04-05 12:26:35','',''),(169,'21','237','1',1,'Sale Id shift 6',0.00,0.00,0.00,2544.45,0.00,'2022-04-05 12:26:35','',''),(170,'21','237','1',1,'Sale Id shift 6',0.00,0.00,0.00,2338.42,0.00,'2022-04-05 12:26:35','',''),(171,'21','237','1',1,'Sale Id shift 6',0.00,0.00,0.00,3043.63,0.00,'2022-04-05 12:26:35','',''),(172,'21','237','1',1,'Sale Id shift 6',0.00,0.00,0.00,0.14,0.00,'2022-04-05 12:26:35','',''),(173,'21','237','3',1,'Sale Id shift 6',0.00,0.00,0.00,3066.57,0.00,'2022-04-05 12:26:35','',''),(174,'21','237','3',1,'Sale Id shift 6',0.00,0.00,0.00,763.54,0.00,'2022-04-05 12:26:35','',''),(175,'21','237','3',1,'Sale Id shift 6',0.00,0.00,0.00,2466.42,0.00,'2022-04-05 12:26:35','',''),(176,'21','237','3',1,'Sale Id shift 6',0.00,0.00,0.00,2394.78,0.00,'2022-04-05 12:26:35','',''),(177,'21','237','4',1,'Sale Id shift 6',0.00,0.00,0.00,3529.55,0.00,'2022-04-05 12:26:35','',''),(178,'21','237','4',1,'Sale Id shift 6',0.00,0.00,0.00,4146.15,0.00,'2022-04-05 12:26:35','',''),(179,'21','237','4',1,'Sale Id shift 6',0.00,0.00,0.00,2601.22,0.00,'2022-04-05 12:26:35','',''),(180,'21','237','1',1,'Sale Id shift 6',0.00,0.00,0.00,2251.92,0.00,'2022-04-05 12:26:35','',''),(181,'21','237',NULL,2,'Sale Id shift 6',15587251.20,0.00,0.00,0.00,0.00,'2022-04-05 12:26:35','',''),(182,'21','237',NULL,1,'Sale Id shift 6',8664846.30,0.00,0.00,0.00,0.00,'2022-04-05 12:26:35','',''),(183,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,28800000.00,45000.00,0.00,0.00,'2022-04-05 12:34:23','',''),(184,'21','237',NULL,2,'Reception corrector for bridging 16',0.00,0.00,0.00,15000.00,0.00,'2022-04-05 12:35:50','',''),(185,'21','237','6',2,'Received from bridging 16',0.00,0.00,15000.00,0.00,0.00,'2022-04-05 12:35:50','',''),(186,'21','237',NULL,2,'Reception corrector for bridging 15',0.00,0.00,0.00,30000.00,0.00,'2022-04-05 12:35:50','',''),(187,'21','237','5',2,'Received from bridging 15',0.00,0.00,30000.00,0.00,0.00,'2022-04-05 12:35:50','',''),(188,'21','237','2',1,'Sale Id shift 7',0.00,0.00,0.00,5067.34,0.00,'2022-04-12 11:05:50','',''),(189,'21','237','2',1,'Sale Id shift 7',0.00,0.00,0.00,4136.72,0.00,'2022-04-12 11:05:50','',''),(190,'21','237','2',1,'Sale Id shift 7',0.00,0.00,0.00,5268.28,0.00,'2022-04-12 11:05:50','',''),(191,'21','237','5',2,'Sale Id shift 7',0.00,0.00,0.00,2290.58,0.00,'2022-04-12 11:05:50','',''),(192,'21','237','5',2,'Sale Id shift 7',0.00,0.00,0.00,2789.22,0.00,'2022-04-12 11:05:50','',''),(193,'21','237','5',2,'Sale Id shift 7',0.00,0.00,0.00,1881.82,0.00,'2022-04-12 11:05:50','',''),(194,'21','237','5',2,'Sale Id shift 7',0.00,0.00,0.00,1588.41,0.00,'2022-04-12 11:05:50','',''),(195,'21','237','6',2,'Sale Id shift 7',0.00,0.00,0.00,568.76,0.00,'2022-04-12 11:05:50','',''),(196,'21','237','6',2,'Sale Id shift 7',0.00,0.00,0.00,4385.69,0.00,'2022-04-12 11:05:50','',''),(197,'21','237','6',2,'Sale Id shift 7',0.00,0.00,0.00,4737.11,0.00,'2022-04-12 11:05:50','',''),(198,'21','237','7',2,'Sale Id shift 7',0.00,0.00,0.00,893.72,0.00,'2022-04-12 11:05:50','',''),(199,'21','237','7',2,'Sale Id shift 7',0.00,0.00,0.00,2842.50,0.00,'2022-04-12 11:05:50','',''),(200,'21','237','2',1,'Sale Id shift 7',0.00,0.00,0.00,5399.15,0.00,'2022-04-12 11:05:50','',''),(201,'21','237','2',1,'Sale Id shift 7',0.00,0.00,0.00,3527.30,0.00,'2022-04-12 11:05:50','',''),(202,'21','237','2',1,'Sale Id shift 7',0.00,0.00,0.00,4652.61,0.00,'2022-04-12 11:05:50','',''),(203,'21','237','2',1,'Sale Id shift 7',0.00,0.00,0.00,4645.70,0.00,'2022-04-12 11:05:50','',''),(204,'21','237','2',1,'Sale Id shift 7',0.00,0.00,0.00,6495.11,0.00,'2022-04-12 11:05:50','',''),(205,'21','237',NULL,2,'Sale Id shift 7',14065798.40,0.00,0.00,0.00,0.00,'2022-04-12 11:05:50','',''),(206,'21','237',NULL,1,'Sale Id shift 7',6466714.65,0.00,0.00,0.00,0.00,'2022-04-12 11:05:50','',''),(207,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,28800000.00,45000.00,0.00,0.00,'2022-04-12 11:54:24','',''),(208,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-04-12 11:56:48','',''),(209,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-04-12 11:59:35','',''),(210,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-04-12 12:03:09','',''),(211,'21','237',NULL,2,'Reception corrector for bridging 17',0.00,0.00,0.00,15000.00,0.00,'2022-04-12 12:06:45','',''),(212,'21','237','5',2,'Received from bridging 17',0.00,0.00,15000.00,0.00,0.00,'2022-04-12 12:06:45','',''),(213,'21','237',NULL,2,'Reception corrector for bridging 18',0.00,0.00,0.00,15000.00,0.00,'2022-04-12 12:07:34','',''),(214,'21','237','6',2,'Received from bridging 18',0.00,0.00,15000.00,0.00,0.00,'2022-04-12 12:07:34','',''),(215,'21','237',NULL,2,'Reception corrector for bridging 19',0.00,0.00,0.00,15000.00,0.00,'2022-04-12 12:08:01','',''),(216,'21','237','7',2,'Received from bridging 19',0.00,0.00,15000.00,0.00,0.00,'2022-04-12 12:08:01','',''),(217,'21','237',NULL,1,'Reception corrector for bridging 20',0.00,0.00,0.00,45000.00,0.00,'2022-04-12 12:08:28','',''),(218,'21','237','2',1,'Received from bridging 20',0.00,0.00,45000.00,0.00,0.00,'2022-04-12 12:08:28','',''),(219,'21','237',NULL,1,'Reception corrector for bridging 22',0.00,0.00,0.00,34000.00,0.00,'2022-04-12 12:09:25','',''),(220,'21','237','3',1,'Received from bridging 22',0.00,0.00,34000.00,0.00,0.00,'2022-04-12 12:09:25','',''),(221,'21','237',NULL,1,'Reception corrector for bridging 23',0.00,0.00,0.00,26000.00,0.00,'2022-04-12 12:09:45','',''),(222,'21','237','4',1,'Received from bridging 23',0.00,0.00,26000.00,0.00,0.00,'2022-04-12 12:09:45','',''),(223,'21','237','2',1,'Sale Id shift 8',0.00,0.00,0.00,552.42,0.00,'2022-04-14 17:21:04','',''),(224,'21','237','2',1,'Sale Id shift 8',0.00,0.00,0.00,586.60,0.00,'2022-04-14 17:21:04','',''),(225,'21','237','2',1,'Sale Id shift 8',0.00,0.00,0.00,604.64,0.00,'2022-04-14 17:21:04','',''),(226,'21','237','5',2,'Sale Id shift 8',0.00,0.00,0.00,6365.23,0.00,'2022-04-14 17:21:04','',''),(227,'21','237','5',2,'Sale Id shift 8',0.00,0.00,0.00,1825.85,0.00,'2022-04-14 17:21:04','',''),(228,'21','237','5',2,'Sale Id shift 8',0.00,0.00,0.00,3203.21,0.00,'2022-04-14 17:21:04','',''),(229,'21','237','5',2,'Sale Id shift 8',0.00,0.00,0.00,2419.71,0.00,'2022-04-14 17:21:04','',''),(230,'21','237','6',2,'Sale Id shift 8',0.00,0.00,0.00,5259.69,0.00,'2022-04-14 17:21:04','',''),(231,'21','237','6',2,'Sale Id shift 8',0.00,0.00,0.00,4998.17,0.00,'2022-04-14 17:21:04','',''),(232,'21','237','6',2,'Sale Id shift 8',0.00,0.00,0.00,5487.95,0.00,'2022-04-14 17:21:04','',''),(233,'21','237','7',2,'Sale Id shift 8',0.00,0.00,0.00,3126.78,0.00,'2022-04-14 17:21:04','',''),(234,'21','237','7',2,'Sale Id shift 8',0.00,0.00,0.00,4164.39,0.00,'2022-04-14 17:21:04','',''),(235,'21','237','2',1,'Sale Id shift 8',0.00,0.00,0.00,559.49,0.00,'2022-04-14 17:21:04','',''),(236,'21','237','2',1,'Sale Id shift 8',0.00,0.00,0.00,761.03,0.00,'2022-04-14 17:21:04','',''),(237,'21','237','2',1,'Sale Id shift 8',0.00,0.00,0.00,873.17,0.00,'2022-04-14 17:21:04','',''),(238,'21','237','2',1,'Sale Id shift 8',0.00,0.00,0.00,609.84,0.00,'2022-04-14 17:21:04','',''),(239,'21','237','2',1,'Sale Id shift 8',0.00,0.00,0.00,961.43,0.00,'2022-04-14 17:21:04','',''),(240,'21','237',NULL,2,'Sale Id shift 8',23584627.20,0.00,0.00,0.00,0.00,'2022-04-14 17:21:05','',''),(241,'21','237',NULL,1,'Sale Id shift 8',908922.30,0.00,0.00,0.00,0.00,'2022-04-14 17:21:05','',''),(242,'21','237','3',1,'Sale Id shift 9',0.00,0.00,0.00,6581.06,0.00,'2022-04-14 17:48:57','',''),(243,'21','237','3',1,'Sale Id shift 9',0.00,0.00,0.00,3201.29,0.00,'2022-04-14 17:48:57','',''),(244,'21','237','3',1,'Sale Id shift 9',0.00,0.00,0.00,1134.75,0.00,'2022-04-14 17:48:57','',''),(245,'21','237','4',1,'Sale Id shift 9',0.00,0.00,0.00,4698.42,0.00,'2022-04-14 17:48:57','',''),(246,'21','237','4',1,'Sale Id shift 9',0.00,0.00,0.00,3799.81,0.00,'2022-04-14 17:48:57','',''),(247,'21','237','4',1,'Sale Id shift 9',0.00,0.00,0.00,4683.13,0.00,'2022-04-14 17:48:57','',''),(248,'21','237','5',2,'Sale Id shift 9',0.00,0.00,0.00,6909.16,0.00,'2022-04-14 17:48:57','',''),(249,'21','237','5',2,'Sale Id shift 9',0.00,0.00,0.00,4473.92,0.00,'2022-04-14 17:48:57','',''),(250,'21','237','5',2,'Sale Id shift 9',0.00,0.00,0.00,4856.08,0.00,'2022-04-14 17:48:57','',''),(251,'21','237','5',2,'Sale Id shift 9',0.00,0.00,0.00,3293.72,0.00,'2022-04-14 17:48:57','',''),(252,'21','237','6',2,'Sale Id shift 9',0.00,0.00,0.00,3779.82,0.00,'2022-04-14 17:48:57','',''),(253,'21','237','6',2,'Sale Id shift 9',0.00,0.00,0.00,6402.23,0.00,'2022-04-14 17:48:57','',''),(254,'21','237','6',2,'Sale Id shift 9',0.00,0.00,0.00,4787.25,0.00,'2022-04-14 17:48:57','',''),(255,'21','237','7',2,'Sale Id shift 9',0.00,0.00,0.00,2885.49,0.00,'2022-04-14 17:48:57','',''),(256,'21','237','7',2,'Sale Id shift 9',0.00,0.00,0.00,4823.42,0.00,'2022-04-14 17:48:57','',''),(257,'21','237','3',1,'Sale Id shift 9',0.00,0.00,0.00,6200.77,0.00,'2022-04-14 17:48:57','',''),(258,'21','237','3',1,'Sale Id shift 9',0.00,0.00,0.00,4184.45,0.00,'2022-04-14 17:48:57','',''),(259,'21','237','3',1,'Sale Id shift 9',0.00,0.00,0.00,5205.56,0.00,'2022-04-14 17:48:57','',''),(260,'21','237','3',1,'Sale Id shift 9',0.00,0.00,0.00,6093.63,0.00,'2022-04-14 17:48:57','',''),(261,'21','237','4',1,'Sale Id shift 9',0.00,0.00,0.00,4934.07,0.00,'2022-04-14 17:48:57','',''),(262,'21','237','4',1,'Sale Id shift 9',0.00,0.00,0.00,5236.31,0.00,'2022-04-14 17:48:57','',''),(263,'21','237','4',1,'Sale Id shift 9',0.00,0.00,0.00,2839.47,0.00,'2022-04-14 17:48:57','',''),(264,'21','237',NULL,2,'Sale Id shift 9',27015097.60,0.00,0.00,0.00,0.00,'2022-04-14 17:48:57','',''),(265,'21','237',NULL,1,'Sale Id shift 9',9700798.80,0.00,0.00,0.00,0.00,'2022-04-14 17:48:57','',''),(266,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8640000.00,13500.00,0.00,0.00,'2022-04-26 11:09:15','',''),(267,'21','237',NULL,1,'Reception corrector for bridging 26',0.00,0.00,0.00,30000.00,0.00,'2022-04-27 15:14:34','',''),(268,'21','237','3',1,'Received from bridging 26',0.00,0.00,30000.00,0.00,0.00,'2022-04-27 15:14:34','',''),(269,'21','237',NULL,1,'Reception corrector for bridging 25',0.00,0.00,0.00,15000.00,0.00,'2022-04-27 15:14:34','',''),(270,'21','237','1',1,'Received from bridging 25',0.00,0.00,15000.00,0.00,0.00,'2022-04-27 15:14:34','',''),(271,'21','237','2',1,'Sale Id shift 11',0.00,0.00,0.00,4818.90,0.00,'2022-04-28 15:11:22','',''),(272,'21','237','2',1,'Sale Id shift 11',0.00,0.00,0.00,5049.88,0.00,'2022-04-28 15:11:22','',''),(273,'21','237','2',1,'Sale Id shift 11',0.00,0.00,0.00,4624.93,0.00,'2022-04-28 15:11:22','',''),(274,'21','237','3',1,'Sale Id shift 11',0.00,0.00,0.00,2812.09,0.00,'2022-04-28 15:11:22','',''),(275,'21','237','3',1,'Sale Id shift 11',0.00,0.00,0.00,523.26,0.00,'2022-04-28 15:11:22','',''),(276,'21','237','3',1,'Sale Id shift 11',0.00,0.00,0.00,1866.43,0.00,'2022-04-28 15:11:22','',''),(277,'21','237','5',2,'Sale Id shift 11',0.00,0.00,0.00,3032.22,0.00,'2022-04-28 15:11:22','',''),(278,'21','237','5',2,'Sale Id shift 11',0.00,0.00,0.00,9934.10,0.00,'2022-04-28 15:11:22','',''),(279,'21','237','5',2,'Sale Id shift 11',0.00,0.00,0.00,4491.17,0.00,'2022-04-28 15:11:22','',''),(280,'21','237','5',2,'Sale Id shift 11',0.00,0.00,0.00,2494.48,0.00,'2022-04-28 15:11:22','',''),(281,'21','237','6',2,'Sale Id shift 11',0.00,0.00,0.00,4601.87,0.00,'2022-04-28 15:11:22','',''),(282,'21','237','6',2,'Sale Id shift 11',0.00,0.00,0.00,7535.99,0.00,'2022-04-28 15:11:22','',''),(283,'21','237','6',2,'Sale Id shift 11',0.00,0.00,0.00,5594.06,0.00,'2022-04-28 15:11:22','',''),(284,'21','237','7',2,'Sale Id shift 11',0.00,0.00,0.00,5175.08,0.00,'2022-04-28 15:11:22','',''),(285,'21','237','7',2,'Sale Id shift 11',0.00,0.00,0.00,3277.08,0.00,'2022-04-28 15:11:22','',''),(286,'21','237','2',1,'Sale Id shift 11',0.00,0.00,0.00,6013.82,0.00,'2022-04-28 15:11:22','',''),(287,'21','237','2',1,'Sale Id shift 11',0.00,0.00,0.00,4989.58,0.00,'2022-04-28 15:11:22','',''),(288,'21','237','2',1,'Sale Id shift 11',0.00,0.00,0.00,4789.13,0.00,'2022-04-28 15:11:22','',''),(289,'21','237','2',1,'Sale Id shift 11',0.00,0.00,0.00,5057.60,0.00,'2022-04-28 15:11:22','',''),(290,'21','237','3',1,'Sale Id shift 11',0.00,0.00,0.00,4110.81,0.00,'2022-04-28 15:11:22','',''),(291,'21','237','3',1,'Sale Id shift 11',0.00,0.00,0.00,1515.46,0.00,'2022-04-28 15:11:22','',''),(292,'21','237','3',1,'Sale Id shift 11',0.00,0.00,0.00,1025.09,0.00,'2022-04-28 15:11:22','',''),(293,'21','237','3',1,'Sale Id shift 11',0.00,0.00,0.00,1481.82,0.00,'2022-04-28 15:11:22','',''),(294,'21','237','2',1,'Sale Id shift 11',0.00,0.00,0.00,5784.15,0.00,'2022-04-28 15:11:22','',''),(295,'21','237',NULL,2,'Sale Id shift 11',29527072.00,0.00,0.00,0.00,0.00,'2022-04-28 15:11:22','',''),(296,'21','237',NULL,1,'Sale Id shift 11',8986386.75,0.00,0.00,0.00,0.00,'2022-04-28 15:11:22','',''),(297,'21','237','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,17145.40,0.00,'2022-04-29 10:22:15','',''),(298,'21','237','1',0,'Inventory adjustment from tank dipping to 2250',0.00,0.00,2250.00,0.00,0.00,'2022-04-29 10:22:15','',''),(299,'21','237','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,5571.18,0.00,'2022-04-29 10:23:53','',''),(300,'21','237','2',0,'Inventory adjustment from tank dipping to 25850',0.00,0.00,25850.00,0.00,0.00,'2022-04-29 10:23:53','',''),(301,'21','237','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,19399.51,0.00,'2022-04-29 10:25:55','',''),(302,'21','237','3',0,'Inventory adjustment from tank dipping to 20250',0.00,0.00,20250.00,0.00,0.00,'2022-04-29 10:25:55','',''),(303,'21','237','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,885.60,0.00,'2022-04-29 10:27:15','',''),(304,'21','237','4',0,'Inventory adjustment from tank dipping to 16400',0.00,0.00,16400.00,0.00,0.00,'2022-04-29 10:27:15','',''),(305,'21','237','5',0,'Tank level zero out for dipping',0.00,0.00,0.00,1109.77,0.00,'2022-04-29 10:28:36','',''),(306,'21','237','5',0,'Inventory adjustment from tank dipping to 14800',0.00,0.00,14800.00,0.00,0.00,'2022-04-29 10:28:36','',''),(307,'21','237','6',0,'Tank level zero out for dipping',0.00,0.00,0.00,1949.36,0.00,'2022-04-29 10:29:45','',''),(308,'21','237','6',0,'Inventory adjustment from tank dipping to 1450',0.00,0.00,1450.00,0.00,0.00,'2022-04-29 10:29:45','',''),(309,'21','237','7',0,'Tank level zero out for dipping',0.00,0.00,0.00,34318.26,0.00,'2022-04-29 10:31:22','',''),(310,'21','237','7',0,'Inventory adjustment from tank dipping to 34600',0.00,0.00,34600.00,0.00,0.00,'2022-04-29 10:31:22','',''),(311,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,28800000.00,45000.00,0.00,0.00,'2022-04-29 12:26:44','',''),(312,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,28800000.00,45000.00,0.00,0.00,'2022-04-29 12:28:10','',''),(313,'21','237',NULL,2,'Reception corrector for bridging 27',0.00,0.00,0.00,45000.00,0.00,'2022-04-29 12:29:43','',''),(314,'21','237','6',2,'Received from bridging 27',0.00,0.00,45000.00,0.00,0.00,'2022-04-29 12:29:43','',''),(315,'21','237',NULL,2,'Reception corrector for bridging 28',0.00,0.00,0.00,30000.00,0.00,'2022-04-29 12:30:06','',''),(316,'21','237','5',2,'Received from bridging 28',0.00,0.00,30000.00,0.00,0.00,'2022-04-29 12:30:06','',''),(317,'21','237',NULL,2,'Reception corrector for bridging 29',0.00,0.00,0.00,15000.00,0.00,'2022-04-29 12:30:26','',''),(318,'21','237','7',2,'Received from bridging 29',0.00,0.00,15000.00,0.00,0.00,'2022-04-29 12:30:26','',''),(319,'21','237','2',1,'Sale Id shift 12',0.00,0.00,0.00,4679.88,0.00,'2022-04-30 19:37:52','',''),(320,'21','237','2',1,'Sale Id shift 12',0.00,0.00,0.00,2774.22,0.00,'2022-04-30 19:37:52','',''),(321,'21','237','2',1,'Sale Id shift 12',0.00,0.00,0.00,1409.52,0.00,'2022-04-30 19:37:52','',''),(322,'21','237','3',1,'Sale Id shift 12',0.00,0.00,0.00,1936.61,0.00,'2022-04-30 19:37:52','',''),(323,'21','237','3',1,'Sale Id shift 12',0.00,0.00,0.00,1752.32,0.00,'2022-04-30 19:37:52','',''),(324,'21','237','3',1,'Sale Id shift 12',0.00,0.00,0.00,905.63,0.00,'2022-04-30 19:37:52','',''),(325,'21','237','4',1,'Sale Id shift 12',0.00,0.00,0.00,5108.84,0.00,'2022-04-30 19:37:52','',''),(326,'21','237','4',1,'Sale Id shift 12',0.00,0.00,0.00,1500.01,0.00,'2022-04-30 19:37:52','',''),(327,'21','237','5',2,'Sale Id shift 12',0.00,0.00,0.00,1040.62,0.00,'2022-04-30 19:37:52','',''),(328,'21','237','5',2,'Sale Id shift 12',0.00,0.00,0.00,4588.56,0.00,'2022-04-30 19:37:52','',''),(329,'21','237','5',2,'Sale Id shift 12',0.00,0.00,0.00,5676.16,0.00,'2022-04-30 19:37:52','',''),(330,'21','237','5',2,'Sale Id shift 12',0.00,0.00,0.00,5342.92,0.00,'2022-04-30 19:37:52','',''),(331,'21','237','6',2,'Sale Id shift 12',0.00,0.00,0.00,605.13,0.00,'2022-04-30 19:37:52','',''),(332,'21','237','6',2,'Sale Id shift 12',0.00,0.00,0.00,1565.72,0.00,'2022-04-30 19:37:52','',''),(333,'21','237','6',2,'Sale Id shift 12',0.00,0.00,0.00,901.57,0.00,'2022-04-30 19:37:52','',''),(334,'21','237','7',2,'Sale Id shift 12',0.00,0.00,0.00,5387.51,0.00,'2022-04-30 19:37:52','',''),(335,'21','237','7',2,'Sale Id shift 12',0.00,0.00,0.00,7757.99,0.00,'2022-04-30 19:37:52','',''),(336,'21','237','2',1,'Sale Id shift 12',0.00,0.00,0.00,1084.51,0.00,'2022-04-30 19:37:52','',''),(337,'21','237','2',1,'Sale Id shift 12',0.00,0.00,0.00,3229.10,0.00,'2022-04-30 19:37:52','',''),(338,'21','237','2',1,'Sale Id shift 12',0.00,0.00,0.00,3541.62,0.00,'2022-04-30 19:37:52','',''),(339,'21','237','2',1,'Sale Id shift 12',0.00,0.00,0.00,2868.89,0.00,'2022-04-30 19:37:52','',''),(340,'21','237','3',1,'Sale Id shift 12',0.00,0.00,0.00,3746.96,0.00,'2022-04-30 19:37:52','',''),(341,'21','237','3',1,'Sale Id shift 12',0.00,0.00,0.00,2730.34,0.00,'2022-04-30 19:37:52','',''),(342,'21','237','3',1,'Sale Id shift 12',0.00,0.00,0.00,2803.59,0.00,'2022-04-30 19:37:52','',''),(343,'21','237','3',1,'Sale Id shift 12',0.00,0.00,0.00,4987.96,0.00,'2022-04-30 19:37:52','',''),(344,'21','237','4',1,'Sale Id shift 12',0.00,0.00,0.00,0.86,0.00,'2022-04-30 19:37:52','',''),(345,'21','237','4',1,'Sale Id shift 12',0.00,0.00,0.00,2636.03,0.00,'2022-04-30 19:37:52','',''),(346,'21','237','4',1,'Sale Id shift 12',0.00,0.00,0.00,2379.63,0.00,'2022-04-30 19:37:52','',''),(347,'21','237','2',1,'Sale Id shift 12',0.00,0.00,0.00,2976.93,0.00,'2022-04-30 19:37:52','',''),(348,'21','237',NULL,2,'Sale Id shift 12',21034355.20,0.00,0.00,0.00,0.00,'2022-04-30 19:37:52','',''),(349,'21','237',NULL,1,'Sale Id shift 12',8753819.25,0.00,0.00,0.00,0.00,'2022-04-30 19:37:52','',''),(350,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-05-06 15:13:04','',''),(351,'21','237',NULL,1,'Reception corrector for bridging 32',0.00,0.00,0.00,20000.00,0.00,'2022-05-06 15:15:59','',''),(352,'21','237','4',1,'Received from bridging 32',0.00,0.00,20000.00,0.00,0.00,'2022-05-06 15:15:59','',''),(353,'21','237',NULL,1,'Reception corrector for bridging 31',0.00,0.00,0.00,20000.00,0.00,'2022-05-06 15:16:47','',''),(354,'21','237','3',1,'Received from bridging 31',0.00,0.00,20000.00,0.00,0.00,'2022-05-06 15:16:47','',''),(355,'21','237',NULL,1,'Reception corrector for bridging 30',0.00,0.00,0.00,20000.00,0.00,'2022-05-06 15:27:49','',''),(356,'21','237','2',1,'Received from bridging 30',0.00,0.00,20000.00,0.00,0.00,'2022-05-06 15:27:49','',''),(357,'21','237','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,2250.00,0.00,'2022-05-07 17:13:22','',''),(358,'21','237','1',0,'Inventory adjustment from tank dipping to 2000',0.00,0.00,2000.00,0.00,0.00,'2022-05-07 17:13:22','',''),(359,'21','237','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,23285.33,0.00,'2022-05-07 17:15:20','',''),(360,'21','237','2',0,'Inventory adjustment from tank dipping to 21000',0.00,0.00,21000.00,0.00,0.00,'2022-05-07 17:15:20','',''),(361,'21','237','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,21386.59,0.00,'2022-05-07 17:16:30','',''),(362,'21','237','3',0,'Inventory adjustment from tank dipping to 21200',0.00,0.00,21200.00,0.00,0.00,'2022-05-07 17:16:30','',''),(363,'21','237','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,24774.63,0.00,'2022-05-07 17:17:06','',''),(364,'21','237','4',0,'Inventory adjustment from tank dipping to 20900',0.00,0.00,20900.00,0.00,0.00,'2022-05-07 17:17:06','',''),(365,'21','237','5',0,'Tank level zero out for dipping',0.00,0.00,0.00,28151.74,0.00,'2022-05-07 17:17:55','',''),(366,'21','237','5',0,'Inventory adjustment from tank dipping to 43800',0.00,0.00,43800.00,0.00,0.00,'2022-05-07 17:17:55','',''),(367,'21','237','6',0,'Tank level zero out for dipping',0.00,0.00,0.00,43377.58,0.00,'2022-05-07 17:18:51','',''),(368,'21','237','6',0,'Inventory adjustment from tank dipping to 32800',0.00,0.00,32800.00,0.00,0.00,'2022-05-07 17:18:51','',''),(369,'21','237','7',0,'Tank level zero out for dipping',0.00,0.00,0.00,36454.50,0.00,'2022-05-07 17:19:25','',''),(370,'21','237','7',0,'Inventory adjustment from tank dipping to 44750',0.00,0.00,44750.00,0.00,0.00,'2022-05-07 17:19:25','',''),(371,'21','237','2',1,'Sale Id shift 14',0.00,0.00,0.00,2959.34,0.00,'2022-05-09 08:44:12','',''),(372,'21','237','2',1,'Sale Id shift 14',0.00,0.00,0.00,705.34,0.00,'2022-05-09 08:44:12','',''),(373,'21','237','2',1,'Sale Id shift 14',0.00,0.00,0.00,2526.80,0.00,'2022-05-09 08:44:12','',''),(374,'21','237','3',1,'Sale Id shift 14',0.00,0.00,0.00,1532.48,0.00,'2022-05-09 08:44:12','',''),(375,'21','237','3',1,'Sale Id shift 14',0.00,0.00,0.00,496.38,0.00,'2022-05-09 08:44:12','',''),(376,'21','237','3',1,'Sale Id shift 14',0.00,0.00,0.00,2128.33,0.00,'2022-05-09 08:44:12','',''),(377,'21','237','4',1,'Sale Id shift 14',0.00,0.00,0.00,3983.53,0.00,'2022-05-09 08:44:12','',''),(378,'21','237','4',1,'Sale Id shift 14',0.00,0.00,0.00,1375.35,0.00,'2022-05-09 08:44:12','',''),(379,'21','237','4',1,'Sale Id shift 14',0.00,0.00,0.00,1309.84,0.00,'2022-05-09 08:44:12','',''),(380,'21','237','5',2,'Sale Id shift 14',0.00,0.00,0.00,1671.28,0.00,'2022-05-09 08:44:12','',''),(381,'21','237','5',2,'Sale Id shift 14',0.00,0.00,0.00,6481.60,0.00,'2022-05-09 08:44:12','',''),(382,'21','237','5',2,'Sale Id shift 14',0.00,0.00,0.00,1938.82,0.00,'2022-05-09 08:44:12','',''),(383,'21','237','5',2,'Sale Id shift 14',0.00,0.00,0.00,4976.88,0.00,'2022-05-09 08:44:12','',''),(384,'21','237','6',2,'Sale Id shift 14',0.00,0.00,0.00,1319.02,0.00,'2022-05-09 08:44:12','',''),(385,'21','237','6',2,'Sale Id shift 14',0.00,0.00,0.00,4285.23,0.00,'2022-05-09 08:44:12','',''),(386,'21','237','6',2,'Sale Id shift 14',0.00,0.00,0.00,6831.89,0.00,'2022-05-09 08:44:12','',''),(387,'21','237','7',2,'Sale Id shift 14',0.00,0.00,0.00,3551.10,0.00,'2022-05-09 08:44:12','',''),(388,'21','237','7',2,'Sale Id shift 14',0.00,0.00,0.00,3597.50,0.00,'2022-05-09 08:44:12','',''),(389,'21','237','2',1,'Sale Id shift 14',0.00,0.00,0.00,1538.54,0.00,'2022-05-09 08:44:12','',''),(390,'21','237','2',1,'Sale Id shift 14',0.00,0.00,0.00,1925.99,0.00,'2022-05-09 08:44:12','',''),(391,'21','237','2',1,'Sale Id shift 14',0.00,0.00,0.00,1016.74,0.00,'2022-05-09 08:44:12','',''),(392,'21','237','2',1,'Sale Id shift 14',0.00,0.00,0.00,3817.59,0.00,'2022-05-09 08:44:12','',''),(393,'21','237','3',1,'Sale Id shift 14',0.00,0.00,0.00,2403.46,0.00,'2022-05-09 08:44:12','',''),(394,'21','237','3',1,'Sale Id shift 14',0.00,0.00,0.00,2274.03,0.00,'2022-05-09 08:44:12','',''),(395,'21','237','3',1,'Sale Id shift 14',0.00,0.00,0.00,3275.41,0.00,'2022-05-09 08:44:12','',''),(396,'21','237','3',1,'Sale Id shift 14',0.00,0.00,0.00,3030.96,0.00,'2022-05-09 08:44:12','',''),(397,'21','237','4',1,'Sale Id shift 14',0.00,0.00,0.00,5650.80,0.00,'2022-05-09 08:44:12','',''),(398,'21','237','4',1,'Sale Id shift 14',0.00,0.00,0.00,3539.12,0.00,'2022-05-09 08:44:12','',''),(399,'21','237','4',1,'Sale Id shift 14',0.00,0.00,0.00,3038.22,0.00,'2022-05-09 08:44:12','',''),(400,'21','237','2',1,'Sale Id shift 14',0.00,0.00,0.00,2845.91,0.00,'2022-05-09 08:44:12','',''),(401,'21','237',NULL,2,'Sale Id shift 14',22178124.80,0.00,0.00,0.00,0.00,'2022-05-09 08:44:12','',''),(402,'21','237',NULL,1,'Sale Id shift 14',8476736.40,0.00,0.00,0.00,0.00,'2022-05-09 08:44:12','',''),(403,'21','237','5',0,'Tank level zero out for dipping',0.00,0.00,0.00,28731.42,0.00,'2022-05-13 17:57:35','',''),(404,'21','237','5',0,'Inventory adjustment from tank dipping to 35400',0.00,0.00,35400.00,0.00,0.00,'2022-05-13 17:57:35','',''),(405,'21','237','6',0,'Tank level zero out for dipping',0.00,0.00,0.00,20363.86,0.00,'2022-05-13 17:57:52','',''),(406,'21','237','6',0,'Inventory adjustment from tank dipping to 45400',0.00,0.00,45400.00,0.00,0.00,'2022-05-13 17:57:52','',''),(407,'21','237','6',0,'Tank level zero out for dipping',0.00,0.00,0.00,45400.00,0.00,'2022-05-13 17:58:06','',''),(408,'21','237','6',0,'Inventory adjustment from tank dipping to 35000',0.00,0.00,35000.00,0.00,0.00,'2022-05-13 17:58:06','',''),(409,'21','237','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,2000.00,0.00,'2022-05-13 17:59:05','',''),(410,'21','237','1',0,'Inventory adjustment from tank dipping to 32000',0.00,0.00,32000.00,0.00,0.00,'2022-05-13 17:59:05','',''),(411,'21','237','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,3663.75,0.00,'2022-05-13 17:59:35','',''),(412,'21','237','2',0,'Inventory adjustment from tank dipping to 48650',0.00,0.00,48650.00,0.00,0.00,'2022-05-13 17:59:35','',''),(413,'21','237','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,32000.00,0.00,'2022-05-13 18:08:48','',''),(414,'21','237','1',0,'Inventory adjustment from tank dipping to 17000',0.00,0.00,17000.00,0.00,0.00,'2022-05-13 18:08:48','',''),(415,'21','237','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,48650.00,0.00,'2022-05-13 18:09:08','',''),(416,'21','237','2',0,'Inventory adjustment from tank dipping to 18650',0.00,0.00,18650.00,0.00,0.00,'2022-05-13 18:09:08','',''),(417,'21','237','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,6058.95,0.00,'2022-05-13 18:09:25','',''),(418,'21','237','3',0,'Inventory adjustment from tank dipping to 41200',0.00,0.00,41200.00,0.00,0.00,'2022-05-13 18:09:25','',''),(419,'21','237','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,2003.14,0.00,'2022-05-13 18:09:40','',''),(420,'21','237','4',0,'Inventory adjustment from tank dipping to 41000',0.00,0.00,41000.00,0.00,0.00,'2022-05-13 18:09:40','',''),(421,'21','237','6',0,'Tank level zero out for dipping',0.00,0.00,0.00,35000.00,0.00,'2022-05-13 18:11:24','',''),(422,'21','237','6',0,'Inventory adjustment from tank dipping to 45400',0.00,0.00,45400.00,0.00,0.00,'2022-05-13 18:11:24','',''),(423,'21','237','7',0,'Tank level zero out for dipping',0.00,0.00,0.00,37601.40,0.00,'2022-05-13 18:11:38','',''),(424,'21','237','7',0,'Inventory adjustment from tank dipping to 35000',0.00,0.00,35000.00,0.00,0.00,'2022-05-13 18:11:38','',''),(425,'21','237','1',1,'Sale Id shift 15',0.00,0.00,0.00,4.04,0.00,'2022-05-14 09:56:18','',''),(426,'21','237','2',1,'Sale Id shift 15',0.00,0.00,0.00,2437.86,0.00,'2022-05-14 09:56:18','',''),(427,'21','237','2',1,'Sale Id shift 15',0.00,0.00,0.00,1167.54,0.00,'2022-05-14 09:56:18','',''),(428,'21','237','2',1,'Sale Id shift 15',0.00,0.00,0.00,1782.17,0.00,'2022-05-14 09:56:18','',''),(429,'21','237','3',1,'Sale Id shift 15',0.00,0.00,0.00,1428.36,0.00,'2022-05-14 09:56:18','',''),(430,'21','237','3',1,'Sale Id shift 15',0.00,0.00,0.00,397.85,0.00,'2022-05-14 09:56:18','',''),(431,'21','237','3',1,'Sale Id shift 15',0.00,0.00,0.00,2661.46,0.00,'2022-05-14 09:56:18','',''),(432,'21','237','4',1,'Sale Id shift 15',0.00,0.00,0.00,711.57,0.00,'2022-05-14 09:56:18','',''),(433,'21','237','4',1,'Sale Id shift 15',0.00,0.00,0.00,0.19,0.00,'2022-05-14 09:56:18','',''),(434,'21','237','4',1,'Sale Id shift 15',0.00,0.00,0.00,1470.52,0.00,'2022-05-14 09:56:18','',''),(435,'21','237','1',1,'Sale Id shift 15',0.00,0.00,0.00,5225.03,0.00,'2022-05-14 09:56:18','',''),(436,'21','237','4',1,'Sale Id shift 15',0.00,0.00,0.00,72.73,0.00,'2022-05-14 09:56:18','',''),(437,'21','237','5',2,'Sale Id shift 15',0.00,0.00,0.00,3778.24,0.00,'2022-05-14 09:56:18','',''),(438,'21','237','5',2,'Sale Id shift 15',0.00,0.00,0.00,2722.52,0.00,'2022-05-14 09:56:18','',''),(439,'21','237','5',2,'Sale Id shift 15',0.00,0.00,0.00,3554.29,0.00,'2022-05-14 09:56:18','',''),(440,'21','237','5',2,'Sale Id shift 15',0.00,0.00,0.00,6384.37,0.00,'2022-05-14 09:56:18','',''),(441,'21','237','6',2,'Sale Id shift 15',0.00,0.00,0.00,1786.95,0.00,'2022-05-14 09:56:18','',''),(442,'21','237','6',2,'Sale Id shift 15',0.00,0.00,0.00,7169.61,0.00,'2022-05-14 09:56:18','',''),(443,'21','237','6',2,'Sale Id shift 15',0.00,0.00,0.00,4357.51,0.00,'2022-05-14 09:56:18','',''),(444,'21','237','7',2,'Sale Id shift 15',0.00,0.00,0.00,2294.13,0.00,'2022-05-14 09:56:18','',''),(445,'21','237','7',2,'Sale Id shift 15',0.00,0.00,0.00,1436.21,0.00,'2022-05-14 09:56:18','',''),(446,'21','237','1',1,'Sale Id shift 15',0.00,0.00,0.00,1756.13,0.00,'2022-05-14 09:56:18','',''),(447,'21','237','1',1,'Sale Id shift 15',0.00,0.00,0.00,0.42,0.00,'2022-05-14 09:56:18','',''),(448,'21','237','1',1,'Sale Id shift 15',0.00,0.00,0.00,3.64,0.00,'2022-05-14 09:56:18','',''),(449,'21','237','1',1,'Sale Id shift 15',0.00,0.00,0.00,1620.44,0.00,'2022-05-14 09:56:18','',''),(450,'21','237','1',1,'Sale Id shift 15',0.00,0.00,0.00,5853.89,0.00,'2022-05-14 09:56:18','',''),(451,'21','237','2',1,'Sale Id shift 15',0.00,0.00,0.00,1955.84,0.00,'2022-05-14 09:56:18','',''),(452,'21','237','2',1,'Sale Id shift 15',0.00,0.00,0.00,1514.96,0.00,'2022-05-14 09:56:18','',''),(453,'21','237','2',1,'Sale Id shift 15',0.00,0.00,0.00,874.13,0.00,'2022-05-14 09:56:18','',''),(454,'21','237','2',1,'Sale Id shift 15',0.00,0.00,0.00,2272.41,0.00,'2022-05-14 09:56:18','',''),(455,'21','237','3',1,'Sale Id shift 15',0.00,0.00,0.00,3317.74,0.00,'2022-05-14 09:56:18','',''),(456,'21','237','3',1,'Sale Id shift 15',0.00,0.00,0.00,4580.68,0.00,'2022-05-14 09:56:18','',''),(457,'21','237','3',1,'Sale Id shift 15',0.00,0.00,0.00,2794.42,0.00,'2022-05-14 09:56:18','',''),(458,'21','237','3',1,'Sale Id shift 15',0.00,0.00,0.00,1496.99,0.00,'2022-05-14 09:56:18','',''),(459,'21','237','4',1,'Sale Id shift 15',0.00,0.00,0.00,4443.32,0.00,'2022-05-14 09:56:18','',''),(460,'21','237','4',1,'Sale Id shift 15',0.00,0.00,0.00,3722.90,0.00,'2022-05-14 09:56:18','',''),(461,'21','237','4',1,'Sale Id shift 15',0.00,0.00,0.00,2029.21,0.00,'2022-05-14 09:56:18','',''),(462,'21','237','1',1,'Sale Id shift 15',0.00,0.00,0.00,766.58,0.00,'2022-05-14 09:56:18','',''),(463,'21','237','2',1,'Sale Id shift 15',0.00,0.00,0.00,5484.96,0.00,'2022-05-14 09:56:18','',''),(464,'21','237',NULL,2,'Sale Id shift 15',21429651.20,0.00,0.00,0.00,0.00,'2022-05-14 09:56:18','',''),(465,'21','237',NULL,1,'Sale Id shift 15',10204916.70,0.00,0.00,0.00,0.00,'2022-05-14 09:56:18','',''),(466,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,5775000.00,35000.00,0.00,0.00,'2022-05-14 10:45:38','',''),(467,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,32000000.00,50000.00,0.00,0.00,'2022-05-14 12:46:24','',''),(468,'21','237',NULL,2,'Reception corrector for bridging 36',0.00,0.00,0.00,17000.00,0.00,'2022-05-14 12:53:28','',''),(469,'21','237','7',2,'Received from bridging 36',0.00,0.00,17000.00,0.00,0.00,'2022-05-14 12:53:28','',''),(470,'21','237',NULL,2,'Reception corrector for bridging 35',0.00,0.00,0.00,33000.00,0.00,'2022-05-14 12:53:28','',''),(471,'21','237','5',2,'Received from bridging 35',0.00,0.00,33000.00,0.00,0.00,'2022-05-14 12:53:28','',''),(472,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-05-14 12:54:22','',''),(473,'21','237',NULL,1,'Reception corrector for bridging 38',0.00,0.00,0.00,23500.00,0.00,'2022-05-14 12:56:12','',''),(474,'21','237','2',1,'Received from bridging 38',0.00,0.00,23500.00,0.00,0.00,'2022-05-14 12:56:12','',''),(475,'21','237',NULL,1,'Reception corrector for bridging 37',0.00,0.00,0.00,16500.00,0.00,'2022-05-14 12:56:39','',''),(476,'21','237','1',1,'Received from bridging 37',0.00,0.00,16500.00,0.00,0.00,'2022-05-14 12:56:39','',''),(477,'21','237','2',1,'Sale Id shift 16',0.00,0.00,0.00,1446.73,0.00,'2022-05-14 14:14:36','',''),(478,'21','237','2',1,'Sale Id shift 16',0.00,0.00,0.00,743.13,0.00,'2022-05-14 14:14:36','',''),(479,'21','237','2',1,'Sale Id shift 16',0.00,0.00,0.00,1938.70,0.00,'2022-05-14 14:14:36','',''),(480,'21','237','3',1,'Sale Id shift 16',0.00,0.00,0.00,818.15,0.00,'2022-05-14 14:14:36','',''),(481,'21','237','3',1,'Sale Id shift 16',0.00,0.00,0.00,1466.79,0.00,'2022-05-14 14:14:36','',''),(482,'21','237','4',1,'Sale Id shift 16',0.00,0.00,0.00,4118.00,0.00,'2022-05-14 14:14:36','',''),(483,'21','237','4',1,'Sale Id shift 16',0.00,0.00,0.00,6.52,0.00,'2022-05-14 14:14:36','',''),(484,'21','237','4',1,'Sale Id shift 16',0.00,0.00,0.00,278.65,0.00,'2022-05-14 14:14:36','',''),(485,'21','237','1',1,'Sale Id shift 16',0.00,0.00,0.00,4619.67,0.00,'2022-05-14 14:14:36','',''),(486,'21','237','5',2,'Sale Id shift 16',0.00,0.00,0.00,3298.08,0.00,'2022-05-14 14:14:36','',''),(487,'21','237','5',2,'Sale Id shift 16',0.00,0.00,0.00,4497.49,0.00,'2022-05-14 14:14:36','',''),(488,'21','237','5',2,'Sale Id shift 16',0.00,0.00,0.00,7003.29,0.00,'2022-05-14 14:14:36','',''),(489,'21','237','5',2,'Sale Id shift 16',0.00,0.00,0.00,2587.10,0.00,'2022-05-14 14:14:36','',''),(490,'21','237','6',2,'Sale Id shift 16',0.00,0.00,0.00,2897.30,0.00,'2022-05-14 14:14:36','',''),(491,'21','237','6',2,'Sale Id shift 16',0.00,0.00,0.00,6648.00,0.00,'2022-05-14 14:14:36','',''),(492,'21','237','6',2,'Sale Id shift 16',0.00,0.00,0.00,2568.69,0.00,'2022-05-14 14:14:36','',''),(493,'21','237','7',2,'Sale Id shift 16',0.00,0.00,0.00,3781.91,0.00,'2022-05-14 14:14:36','',''),(494,'21','237','7',2,'Sale Id shift 16',0.00,0.00,0.00,5947.41,0.00,'2022-05-14 14:14:36','',''),(495,'21','237','1',1,'Sale Id shift 16',0.00,0.00,0.00,3946.23,0.00,'2022-05-14 14:14:36','',''),(496,'21','237','1',1,'Sale Id shift 16',0.00,0.00,0.00,446.23,0.00,'2022-05-14 14:14:36','',''),(497,'21','237','1',1,'Sale Id shift 16',0.00,0.00,0.00,1127.09,0.00,'2022-05-14 14:14:36','',''),(498,'21','237','1',1,'Sale Id shift 16',0.00,0.00,0.00,1473.75,0.00,'2022-05-14 14:14:36','',''),(499,'21','237','2',1,'Sale Id shift 16',0.00,0.00,0.00,678.98,0.00,'2022-05-14 14:14:36','',''),(500,'21','237','2',1,'Sale Id shift 16',0.00,0.00,0.00,2241.36,0.00,'2022-05-14 14:14:36','',''),(501,'21','237','2',1,'Sale Id shift 16',0.00,0.00,0.00,3573.90,0.00,'2022-05-14 14:14:36','',''),(502,'21','237','2',1,'Sale Id shift 16',0.00,0.00,0.00,1729.87,0.00,'2022-05-14 14:14:36','',''),(503,'21','237','3',1,'Sale Id shift 16',0.00,0.00,0.00,3069.91,0.00,'2022-05-14 14:14:36','',''),(504,'21','237','3',1,'Sale Id shift 16',0.00,0.00,0.00,1661.77,0.00,'2022-05-14 14:14:36','',''),(505,'21','237','3',1,'Sale Id shift 16',0.00,0.00,0.00,2354.70,0.00,'2022-05-14 14:14:36','',''),(506,'21','237','4',1,'Sale Id shift 16',0.00,0.00,0.00,4732.07,0.00,'2022-05-14 14:14:36','',''),(507,'21','237','4',1,'Sale Id shift 16',0.00,0.00,0.00,2999.94,0.00,'2022-05-14 14:14:36','',''),(508,'21','237','1',1,'Sale Id shift 16',0.00,0.00,0.00,3464.79,0.00,'2022-05-14 14:14:36','',''),(509,'21','237','2',1,'Sale Id shift 16',0.00,0.00,0.00,4108.28,0.00,'2022-05-14 14:14:36','',''),(510,'21','237',NULL,2,'Sale Id shift 16',25106732.80,0.00,0.00,0.00,0.00,'2022-05-14 14:14:36','',''),(511,'21','237',NULL,1,'Sale Id shift 16',8752459.65,0.00,0.00,0.00,0.00,'2022-05-14 14:14:36','',''),(512,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,28800000.00,45000.00,0.00,0.00,'2022-05-14 14:22:57','',''),(513,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-14 14:27:08','',''),(514,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-14 14:32:14','',''),(515,'21','237',NULL,2,'Reception corrector for bridging 39',0.00,0.00,0.00,15000.00,0.00,'2022-05-14 14:36:16','',''),(516,'21','237','5',2,'Received from bridging 39',0.00,0.00,15000.00,0.00,0.00,'2022-05-14 14:36:16','',''),(517,'21','237',NULL,2,'Reception corrector for bridging 40',0.00,0.00,0.00,30000.00,0.00,'2022-05-14 14:36:53','',''),(518,'21','237','6',2,'Received from bridging 40',0.00,0.00,30000.00,0.00,0.00,'2022-05-14 14:36:53','',''),(519,'21','237',NULL,1,'Reception corrector for bridging 41',0.00,0.00,0.00,30000.00,0.00,'2022-05-14 14:37:17','',''),(520,'21','237','1',1,'Received from bridging 41',0.00,0.00,30000.00,0.00,0.00,'2022-05-14 14:37:17','',''),(521,'21','237',NULL,1,'Reception corrector for bridging 42',0.00,0.00,0.00,15000.00,0.00,'2022-05-14 14:37:43','',''),(522,'21','237','2',1,'Received from bridging 42',0.00,0.00,15000.00,0.00,0.00,'2022-05-14 14:37:43','',''),(523,'21','237',NULL,1,'Reception corrector for bridging 43',0.00,0.00,0.00,30000.00,0.00,'2022-05-14 14:38:05','',''),(524,'21','237','3',1,'Received from bridging 43',0.00,0.00,30000.00,0.00,0.00,'2022-05-14 14:38:05','',''),(525,'21','237',NULL,1,'Reception corrector for bridging 44',0.00,0.00,0.00,15000.00,0.00,'2022-05-14 14:38:28','',''),(526,'21','237','4',1,'Received from bridging 44',0.00,0.00,15000.00,0.00,0.00,'2022-05-14 14:38:28','',''),(527,'21','237','2',1,'Sale Id shift 17',0.00,0.00,0.00,3441.95,0.00,'2022-05-14 17:01:20','',''),(528,'21','237','2',1,'Sale Id shift 17',0.00,0.00,0.00,1769.56,0.00,'2022-05-14 17:01:20','',''),(529,'21','237','2',1,'Sale Id shift 17',0.00,0.00,0.00,1927.41,0.00,'2022-05-14 17:01:20','',''),(530,'21','237','3',1,'Sale Id shift 17',0.00,0.00,0.00,2303.84,0.00,'2022-05-14 17:01:20','',''),(531,'21','237','3',1,'Sale Id shift 17',0.00,0.00,0.00,1297.65,0.00,'2022-05-14 17:01:20','',''),(532,'21','237','3',1,'Sale Id shift 17',0.00,0.00,0.00,1433.36,0.00,'2022-05-14 17:01:20','',''),(533,'21','237','4',1,'Sale Id shift 17',0.00,0.00,0.00,5149.73,0.00,'2022-05-14 17:01:20','',''),(534,'21','237','4',1,'Sale Id shift 17',0.00,0.00,0.00,825.37,0.00,'2022-05-14 17:01:20','',''),(535,'21','237','1',1,'Sale Id shift 17',0.00,0.00,0.00,3698.16,0.00,'2022-05-14 17:01:20','',''),(536,'21','237','5',2,'Sale Id shift 17',0.00,0.00,0.00,1216.25,0.00,'2022-05-14 17:01:20','',''),(537,'21','237','5',2,'Sale Id shift 17',0.00,0.00,0.00,7425.51,0.00,'2022-05-14 17:01:20','',''),(538,'21','237','5',2,'Sale Id shift 17',0.00,0.00,0.00,2720.00,0.00,'2022-05-14 17:01:20','',''),(539,'21','237','5',2,'Sale Id shift 17',0.00,0.00,0.00,3386.65,0.00,'2022-05-14 17:01:20','',''),(540,'21','237','6',2,'Sale Id shift 17',0.00,0.00,0.00,6131.26,0.00,'2022-05-14 17:01:20','',''),(541,'21','237','6',2,'Sale Id shift 17',0.00,0.00,0.00,6452.71,0.00,'2022-05-14 17:01:20','',''),(542,'21','237','6',2,'Sale Id shift 17',0.00,0.00,0.00,6207.07,0.00,'2022-05-14 17:01:20','',''),(543,'21','237','7',2,'Sale Id shift 17',0.00,0.00,0.00,3489.84,0.00,'2022-05-14 17:01:20','',''),(544,'21','237','7',2,'Sale Id shift 17',0.00,0.00,0.00,5299.44,0.00,'2022-05-14 17:01:20','',''),(545,'21','237','1',1,'Sale Id shift 17',0.00,0.00,0.00,1115.57,0.00,'2022-05-14 17:01:20','',''),(546,'21','237','1',1,'Sale Id shift 17',0.00,0.00,0.00,543.94,0.00,'2022-05-14 17:01:20','',''),(547,'21','237','1',1,'Sale Id shift 17',0.00,0.00,0.00,2258.98,0.00,'2022-05-14 17:01:20','',''),(548,'21','237','1',1,'Sale Id shift 17',0.00,0.00,0.00,4805.64,0.00,'2022-05-14 17:01:20','',''),(549,'21','237','2',1,'Sale Id shift 17',0.00,0.00,0.00,2319.98,0.00,'2022-05-14 17:01:20','',''),(550,'21','237','2',1,'Sale Id shift 17',0.00,0.00,0.00,580.47,0.00,'2022-05-14 17:01:20','',''),(551,'21','237','2',1,'Sale Id shift 17',0.00,0.00,0.00,2680.14,0.00,'2022-05-14 17:01:20','',''),(552,'21','237','2',1,'Sale Id shift 17',0.00,0.00,0.00,2351.36,0.00,'2022-05-14 17:01:20','',''),(553,'21','237','3',1,'Sale Id shift 17',0.00,0.00,0.00,3375.68,0.00,'2022-05-14 17:01:20','',''),(554,'21','237','3',1,'Sale Id shift 17',0.00,0.00,0.00,134.71,0.00,'2022-05-14 17:01:20','',''),(555,'21','237','3',1,'Sale Id shift 17',0.00,0.00,0.00,3090.67,0.00,'2022-05-14 17:01:20','',''),(556,'21','237','3',1,'Sale Id shift 17',0.00,0.00,0.00,3290.34,0.00,'2022-05-14 17:01:20','',''),(557,'21','237','4',1,'Sale Id shift 17',0.00,0.00,0.00,4245.09,0.00,'2022-05-14 17:01:20','',''),(558,'21','237','4',1,'Sale Id shift 17',0.00,0.00,0.00,2062.48,0.00,'2022-05-14 17:01:20','',''),(559,'21','237','4',1,'Sale Id shift 17',0.00,0.00,0.00,1962.55,0.00,'2022-05-14 17:01:20','',''),(560,'21','237','1',1,'Sale Id shift 17',0.00,0.00,0.00,1595.77,0.00,'2022-05-14 17:01:20','',''),(561,'21','237','2',1,'Sale Id shift 17',0.00,0.00,0.00,4845.43,0.00,'2022-05-14 17:01:20','',''),(562,'21','237',NULL,2,'Sale Id shift 17',27090387.20,0.00,0.00,0.00,0.00,'2022-05-14 17:01:20','',''),(563,'21','237',NULL,1,'Sale Id shift 17',10412461.95,0.00,0.00,0.00,0.00,'2022-05-14 17:01:20','',''),(564,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,32000000.00,50000.00,0.00,0.00,'2022-05-15 11:33:32','',''),(565,'21','237',NULL,2,'Reception corrector for bridging 47',0.00,0.00,0.00,16000.00,0.00,'2022-05-15 11:36:27','',''),(566,'21','237','7',2,'Received from bridging 47',0.00,0.00,16000.00,0.00,0.00,'2022-05-15 11:36:27','',''),(567,'21','237',NULL,2,'Reception corrector for bridging 46',0.00,0.00,0.00,17000.00,0.00,'2022-05-15 11:37:13','',''),(568,'21','237','6',2,'Received from bridging 46',0.00,0.00,17000.00,0.00,0.00,'2022-05-15 11:37:13','',''),(569,'21','237',NULL,2,'Reception corrector for bridging 45',0.00,0.00,0.00,17000.00,0.00,'2022-05-15 11:37:46','',''),(570,'21','237','5',2,'Received from bridging 45',0.00,0.00,17000.00,0.00,0.00,'2022-05-15 11:37:46','',''),(571,'21','237','3',1,'Sale Id shift 18',0.00,0.00,0.00,2484.64,0.00,'2022-05-15 12:37:11','',''),(572,'21','237','3',1,'Sale Id shift 18',0.00,0.00,0.00,2401.02,0.00,'2022-05-15 12:37:11','',''),(573,'21','237','3',1,'Sale Id shift 18',0.00,0.00,0.00,2959.31,0.00,'2022-05-15 12:37:11','',''),(574,'21','237','4',1,'Sale Id shift 18',0.00,0.00,0.00,3196.20,0.00,'2022-05-15 12:37:11','',''),(575,'21','237','4',1,'Sale Id shift 18',0.00,0.00,0.00,885.07,0.00,'2022-05-15 12:37:11','',''),(576,'21','237','1',1,'Sale Id shift 18',0.00,0.00,0.00,5089.14,0.00,'2022-05-15 12:37:11','',''),(577,'21','237','5',2,'Sale Id shift 18',0.00,0.00,0.00,3806.00,0.00,'2022-05-15 12:37:11','',''),(578,'21','237','5',2,'Sale Id shift 18',0.00,0.00,0.00,4383.89,0.00,'2022-05-15 12:37:11','',''),(579,'21','237','5',2,'Sale Id shift 18',0.00,0.00,0.00,3626.65,0.00,'2022-05-15 12:37:11','',''),(580,'21','237','5',2,'Sale Id shift 18',0.00,0.00,0.00,7029.71,0.00,'2022-05-15 12:37:11','',''),(581,'21','237','6',2,'Sale Id shift 18',0.00,0.00,0.00,1818.43,0.00,'2022-05-15 12:37:11','',''),(582,'21','237','6',2,'Sale Id shift 18',0.00,0.00,0.00,6120.90,0.00,'2022-05-15 12:37:11','',''),(583,'21','237','6',2,'Sale Id shift 18',0.00,0.00,0.00,3209.32,0.00,'2022-05-15 12:37:11','',''),(584,'21','237','7',2,'Sale Id shift 18',0.00,0.00,0.00,2270.27,0.00,'2022-05-15 12:37:11','',''),(585,'21','237','7',2,'Sale Id shift 18',0.00,0.00,0.00,3564.53,0.00,'2022-05-15 12:37:11','',''),(586,'21','237','1',1,'Sale Id shift 18',0.00,0.00,0.00,3219.06,0.00,'2022-05-15 12:37:11','',''),(587,'21','237','1',1,'Sale Id shift 18',0.00,0.00,0.00,112.76,0.00,'2022-05-15 12:37:11','',''),(588,'21','237','1',1,'Sale Id shift 18',0.00,0.00,0.00,3218.45,0.00,'2022-05-15 12:37:11','',''),(589,'21','237','1',1,'Sale Id shift 18',0.00,0.00,0.00,4888.52,0.00,'2022-05-15 12:37:11','',''),(590,'21','237','2',1,'Sale Id shift 18',0.00,0.00,0.00,336.05,0.00,'2022-05-15 12:37:11','',''),(591,'21','237','3',1,'Sale Id shift 18',0.00,0.00,0.00,3337.82,0.00,'2022-05-15 12:37:11','',''),(592,'21','237','3',1,'Sale Id shift 18',0.00,0.00,0.00,2111.46,0.00,'2022-05-15 12:37:11','',''),(593,'21','237','3',1,'Sale Id shift 18',0.00,0.00,0.00,5218.72,0.00,'2022-05-15 12:37:11','',''),(594,'21','237','3',1,'Sale Id shift 18',0.00,0.00,0.00,5946.76,0.00,'2022-05-15 12:37:11','',''),(595,'21','237','4',1,'Sale Id shift 18',0.00,0.00,0.00,4946.38,0.00,'2022-05-15 12:37:11','',''),(596,'21','237','4',1,'Sale Id shift 18',0.00,0.00,0.00,4036.45,0.00,'2022-05-15 12:37:11','',''),(597,'21','237','4',1,'Sale Id shift 18',0.00,0.00,0.00,3309.75,0.00,'2022-05-15 12:37:11','',''),(598,'21','237','1',1,'Sale Id shift 18',0.00,0.00,0.00,1145.05,0.00,'2022-05-15 12:37:11','',''),(599,'21','237','2',1,'Sale Id shift 18',0.00,0.00,0.00,822.21,0.00,'2022-05-15 12:37:11','',''),(600,'21','237',NULL,2,'Sale Id shift 18',22931008.00,0.00,0.00,0.00,0.00,'2022-05-15 12:37:11','',''),(601,'21','237',NULL,1,'Sale Id shift 18',9844695.30,0.00,0.00,0.00,0.00,'2022-05-15 12:37:11','',''),(602,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,28800000.00,45000.00,0.00,0.00,'2022-05-15 12:47:43','',''),(603,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8580000.00,52000.00,0.00,0.00,'2022-05-15 12:51:15','',''),(604,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-15 12:53:53','',''),(605,'21','237',NULL,1,'Reception corrector for bridging 54',0.00,0.00,0.00,17000.00,0.00,'2022-05-15 12:56:08','',''),(606,'21','237','4',1,'Received from bridging 54',0.00,0.00,17000.00,0.00,0.00,'2022-05-15 12:56:08','',''),(607,'21','237',NULL,1,'Reception corrector for bridging 53',0.00,0.00,0.00,33000.00,0.00,'2022-05-15 12:56:29','',''),(608,'21','237','3',1,'Received from bridging 53',0.00,0.00,33000.00,0.00,0.00,'2022-05-15 12:56:29','',''),(609,'21','237',NULL,1,'Reception corrector for bridging 52',0.00,0.00,0.00,19000.00,0.00,'2022-05-15 12:56:57','',''),(610,'21','237','2',1,'Received from bridging 52',0.00,0.00,19000.00,0.00,0.00,'2022-05-15 12:56:57','',''),(611,'21','237',NULL,1,'Reception corrector for bridging 51',0.00,0.00,0.00,33000.00,0.00,'2022-05-15 12:57:39','',''),(612,'21','237','1',1,'Received from bridging 51',0.00,0.00,33000.00,0.00,0.00,'2022-05-15 12:57:39','',''),(613,'21','237',NULL,2,'Reception corrector for bridging 50',0.00,0.00,0.00,15000.00,0.00,'2022-05-15 12:58:13','',''),(614,'21','237','7',2,'Received from bridging 50',0.00,0.00,15000.00,0.00,0.00,'2022-05-15 12:58:13','',''),(615,'21','237',NULL,2,'Reception corrector for bridging 49',0.00,0.00,0.00,15000.00,0.00,'2022-05-15 12:58:41','',''),(616,'21','237','6',2,'Received from bridging 49',0.00,0.00,15000.00,0.00,0.00,'2022-05-15 12:58:41','',''),(617,'21','237',NULL,2,'Reception corrector for bridging 48',0.00,0.00,0.00,15000.00,0.00,'2022-05-15 12:59:24','',''),(618,'21','237','5',2,'Received from bridging 48',0.00,0.00,15000.00,0.00,0.00,'2022-05-15 12:59:24','',''),(619,'21','237','1',1,'Sale Id shift 19',0.00,0.00,0.00,5015.09,0.00,'2022-05-15 14:20:57','',''),(620,'21','237','2',1,'Sale Id shift 19',0.00,0.00,0.00,3600.71,0.00,'2022-05-15 14:20:57','',''),(621,'21','237','2',1,'Sale Id shift 19',0.00,0.00,0.00,2033.47,0.00,'2022-05-15 14:20:57','',''),(622,'21','237','2',1,'Sale Id shift 19',0.00,0.00,0.00,2261.06,0.00,'2022-05-15 14:20:57','',''),(623,'21','237','3',1,'Sale Id shift 19',0.00,0.00,0.00,952.92,0.00,'2022-05-15 14:20:57','',''),(624,'21','237','3',1,'Sale Id shift 19',0.00,0.00,0.00,438.91,0.00,'2022-05-15 14:20:57','',''),(625,'21','237','3',1,'Sale Id shift 19',0.00,0.00,0.00,1.48,0.00,'2022-05-15 14:20:57','',''),(626,'21','237','4',1,'Sale Id shift 19',0.00,0.00,0.00,2303.78,0.00,'2022-05-15 14:20:57','',''),(627,'21','237','4',1,'Sale Id shift 19',0.00,0.00,0.00,256.11,0.00,'2022-05-15 14:20:57','',''),(628,'21','237','1',1,'Sale Id shift 19',0.00,0.00,0.00,4714.46,0.00,'2022-05-15 14:20:57','',''),(629,'21','237','4',1,'Sale Id shift 19',0.00,0.00,0.00,1477.38,0.00,'2022-05-15 14:20:57','',''),(630,'21','237','5',2,'Sale Id shift 19',0.00,0.00,0.00,3391.42,0.00,'2022-05-15 14:20:57','',''),(631,'21','237','5',2,'Sale Id shift 19',0.00,0.00,0.00,5031.09,0.00,'2022-05-15 14:20:57','',''),(632,'21','237','5',2,'Sale Id shift 19',0.00,0.00,0.00,1665.00,0.00,'2022-05-15 14:20:57','',''),(633,'21','237','5',2,'Sale Id shift 19',0.00,0.00,0.00,4124.58,0.00,'2022-05-15 14:20:57','',''),(634,'21','237','6',2,'Sale Id shift 19',0.00,0.00,0.00,1954.74,0.00,'2022-05-15 14:20:57','',''),(635,'21','237','6',2,'Sale Id shift 19',0.00,0.00,0.00,5661.86,0.00,'2022-05-15 14:20:57','',''),(636,'21','237','6',2,'Sale Id shift 19',0.00,0.00,0.00,5287.31,0.00,'2022-05-15 14:20:57','',''),(637,'21','237','7',2,'Sale Id shift 19',0.00,0.00,0.00,1945.67,0.00,'2022-05-15 14:20:57','',''),(638,'21','237','7',2,'Sale Id shift 19',0.00,0.00,0.00,2172.72,0.00,'2022-05-15 14:20:57','',''),(639,'21','237','1',1,'Sale Id shift 19',0.00,0.00,0.00,714.04,0.00,'2022-05-15 14:20:57','',''),(640,'21','237','1',1,'Sale Id shift 19',0.00,0.00,0.00,3.05,0.00,'2022-05-15 14:20:57','',''),(641,'21','237','1',1,'Sale Id shift 19',0.00,0.00,0.00,1386.54,0.00,'2022-05-15 14:20:57','',''),(642,'21','237','1',1,'Sale Id shift 19',0.00,0.00,0.00,1747.78,0.00,'2022-05-15 14:20:57','',''),(643,'21','237','1',1,'Sale Id shift 19',0.00,0.00,0.00,4776.30,0.00,'2022-05-15 14:20:57','',''),(644,'21','237','2',1,'Sale Id shift 19',0.00,0.00,0.00,2696.49,0.00,'2022-05-15 14:20:57','',''),(645,'21','237','2',1,'Sale Id shift 19',0.00,0.00,0.00,320.96,0.00,'2022-05-15 14:20:57','',''),(646,'21','237','2',1,'Sale Id shift 19',0.00,0.00,0.00,2876.37,0.00,'2022-05-15 14:20:57','',''),(647,'21','237','2',1,'Sale Id shift 19',0.00,0.00,0.00,2356.00,0.00,'2022-05-15 14:20:57','',''),(648,'21','237','3',1,'Sale Id shift 19',0.00,0.00,0.00,1823.07,0.00,'2022-05-15 14:20:57','',''),(649,'21','237','3',1,'Sale Id shift 19',0.00,0.00,0.00,1122.85,0.00,'2022-05-15 14:20:57','',''),(650,'21','237','3',1,'Sale Id shift 19',0.00,0.00,0.00,2271.37,0.00,'2022-05-15 14:20:57','',''),(651,'21','237','3',1,'Sale Id shift 19',0.00,0.00,0.00,4281.82,0.00,'2022-05-15 14:20:57','',''),(652,'21','237','4',1,'Sale Id shift 19',0.00,0.00,0.00,4897.14,0.00,'2022-05-15 14:20:57','',''),(653,'21','237','4',1,'Sale Id shift 19',0.00,0.00,0.00,2977.72,0.00,'2022-05-15 14:20:57','',''),(654,'21','237','4',1,'Sale Id shift 19',0.00,0.00,0.00,2103.01,0.00,'2022-05-15 14:20:57','',''),(655,'21','237','1',1,'Sale Id shift 19',0.00,0.00,0.00,3784.92,0.00,'2022-05-15 14:20:57','',''),(656,'21','237','2',1,'Sale Id shift 19',0.00,0.00,0.00,3565.20,0.00,'2022-05-15 14:20:57','',''),(657,'21','237',NULL,2,'Sale Id shift 19',19990009.60,0.00,0.00,0.00,0.00,'2022-05-15 14:20:57','',''),(658,'21','237',NULL,1,'Sale Id shift 19',11015400.00,0.00,0.00,0.00,0.00,'2022-05-15 14:20:57','',''),(659,'21','237','1',1,'Sale Id shift 20',0.00,0.00,0.00,2055.53,0.00,'2022-05-17 11:21:45','',''),(660,'21','237','4',1,'Sale Id shift 20',0.00,0.00,0.00,808.73,0.00,'2022-05-17 11:21:45','',''),(661,'21','237','4',1,'Sale Id shift 20',0.00,0.00,0.00,13.22,0.00,'2022-05-17 11:21:45','',''),(662,'21','237','1',1,'Sale Id shift 20',0.00,0.00,0.00,1946.28,0.00,'2022-05-17 11:21:45','',''),(663,'21','237','4',1,'Sale Id shift 20',0.00,0.00,0.00,328.24,0.00,'2022-05-17 11:21:45','',''),(664,'21','237','5',2,'Sale Id shift 20',0.00,0.00,0.00,4112.91,0.00,'2022-05-17 11:21:45','',''),(665,'21','237','5',2,'Sale Id shift 20',0.00,0.00,0.00,2665.03,0.00,'2022-05-17 11:21:45','',''),(666,'21','237','5',2,'Sale Id shift 20',0.00,0.00,0.00,521.56,0.00,'2022-05-17 11:21:45','',''),(667,'21','237','5',2,'Sale Id shift 20',0.00,0.00,0.00,3071.46,0.00,'2022-05-17 11:21:45','',''),(668,'21','237','6',2,'Sale Id shift 20',0.00,0.00,0.00,3509.42,0.00,'2022-05-17 11:21:45','',''),(669,'21','237','6',2,'Sale Id shift 20',0.00,0.00,0.00,3635.14,0.00,'2022-05-17 11:21:45','',''),(670,'21','237','6',2,'Sale Id shift 20',0.00,0.00,0.00,3386.16,0.00,'2022-05-17 11:21:45','',''),(671,'21','237','7',2,'Sale Id shift 20',0.00,0.00,0.00,1438.30,0.00,'2022-05-17 11:21:45','',''),(672,'21','237','7',2,'Sale Id shift 20',0.00,0.00,0.00,1253.12,0.00,'2022-05-17 11:21:45','',''),(673,'21','237','1',1,'Sale Id shift 20',0.00,0.00,0.00,1122.81,0.00,'2022-05-17 11:21:45','',''),(674,'21','237','1',1,'Sale Id shift 20',0.00,0.00,0.00,229.10,0.00,'2022-05-17 11:21:45','',''),(675,'21','237','1',1,'Sale Id shift 20',0.00,0.00,0.00,1456.25,0.00,'2022-05-17 11:21:45','',''),(676,'21','237','1',1,'Sale Id shift 20',0.00,0.00,0.00,1702.65,0.00,'2022-05-17 11:21:45','',''),(677,'21','237','1',1,'Sale Id shift 20',0.00,0.00,0.00,1678.50,0.00,'2022-05-17 11:21:45','',''),(678,'21','237','3',1,'Sale Id shift 20',0.00,0.00,0.00,27.75,0.00,'2022-05-17 11:21:45','',''),(679,'21','237','4',1,'Sale Id shift 20',0.00,0.00,0.00,15.18,0.00,'2022-05-17 11:21:45','',''),(680,'21','237','4',1,'Sale Id shift 20',0.00,0.00,0.00,919.03,0.00,'2022-05-17 11:21:45','',''),(681,'21','237','4',1,'Sale Id shift 20',0.00,0.00,0.00,788.74,0.00,'2022-05-17 11:21:45','',''),(682,'21','237','4',1,'Sale Id shift 20',0.00,0.00,0.00,543.75,0.00,'2022-05-17 11:21:45','',''),(683,'21','237','1',1,'Sale Id shift 20',0.00,0.00,0.00,1288.23,0.00,'2022-05-17 11:21:45','',''),(684,'21','237',NULL,2,'Sale Id shift 20',15099584.00,0.00,0.00,0.00,0.00,'2022-05-17 11:21:45','',''),(685,'21','237',NULL,1,'Sale Id shift 20',2462458.35,0.00,0.00,0.00,0.00,'2022-05-17 11:21:45','',''),(686,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,28800000.00,45000.00,0.00,0.00,'2022-05-17 14:54:09','',''),(687,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-05-17 14:58:53','',''),(688,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-17 15:01:36','',''),(689,'21','237',NULL,1,'Reception corrector for bridging 60',0.00,0.00,0.00,15000.00,0.00,'2022-05-17 15:04:12','',''),(690,'21','237','2',1,'Received from bridging 60',0.00,0.00,15000.00,0.00,0.00,'2022-05-17 15:04:12','',''),(691,'21','237',NULL,1,'Reception corrector for bridging 59',0.00,0.00,0.00,30000.00,0.00,'2022-05-17 15:04:40','',''),(692,'21','237','1',1,'Received from bridging 59',0.00,0.00,30000.00,0.00,0.00,'2022-05-17 15:04:40','',''),(693,'21','237',NULL,1,'Reception corrector for bridging 58',0.00,0.00,0.00,13000.00,0.00,'2022-05-17 15:05:38','',''),(694,'21','237','4',1,'Received from bridging 58',0.00,0.00,13000.00,0.00,0.00,'2022-05-17 15:05:38','',''),(695,'21','237',NULL,1,'Reception corrector for bridging 57',0.00,0.00,0.00,27000.00,0.00,'2022-05-17 15:06:18','',''),(696,'21','237','3',1,'Received from bridging 57',0.00,0.00,27000.00,0.00,0.00,'2022-05-17 15:06:18','',''),(697,'21','237',NULL,2,'Reception corrector for bridging 56',0.00,0.00,0.00,15000.00,0.00,'2022-05-17 15:06:44','',''),(698,'21','237','6',2,'Received from bridging 56',0.00,0.00,15000.00,0.00,0.00,'2022-05-17 15:06:44','',''),(699,'21','237',NULL,2,'Reception corrector for bridging 55',0.00,0.00,0.00,30000.00,0.00,'2022-05-17 15:07:15','',''),(700,'21','237','5',2,'Received from bridging 55',0.00,0.00,30000.00,0.00,0.00,'2022-05-17 15:07:15','',''),(701,'21','237','3',1,'Sale Id shift 21',0.00,0.00,0.00,4755.41,0.00,'2022-05-17 16:24:58','',''),(702,'21','237','3',1,'Sale Id shift 21',0.00,0.00,0.00,3367.52,0.00,'2022-05-17 16:24:58','',''),(703,'21','237','3',1,'Sale Id shift 21',0.00,0.00,0.00,4657.00,0.00,'2022-05-17 16:24:58','',''),(704,'21','237','4',1,'Sale Id shift 21',0.00,0.00,0.00,2115.86,0.00,'2022-05-17 16:24:58','',''),(705,'21','237','4',1,'Sale Id shift 21',0.00,0.00,0.00,389.21,0.00,'2022-05-17 16:24:58','',''),(706,'21','237','4',1,'Sale Id shift 21',0.00,0.00,0.00,658.64,0.00,'2022-05-17 16:24:58','',''),(707,'21','237','5',2,'Sale Id shift 21',0.00,0.00,0.00,5597.87,0.00,'2022-05-17 16:24:58','',''),(708,'21','237','5',2,'Sale Id shift 21',0.00,0.00,0.00,4430.96,0.00,'2022-05-17 16:24:58','',''),(709,'21','237','5',2,'Sale Id shift 21',0.00,0.00,0.00,4307.74,0.00,'2022-05-17 16:24:58','',''),(710,'21','237','5',2,'Sale Id shift 21',0.00,0.00,0.00,5922.20,0.00,'2022-05-17 16:24:58','',''),(711,'21','237','6',2,'Sale Id shift 21',0.00,0.00,0.00,3628.45,0.00,'2022-05-17 16:24:58','',''),(712,'21','237','6',2,'Sale Id shift 21',0.00,0.00,0.00,8502.20,0.00,'2022-05-17 16:24:58','',''),(713,'21','237','6',2,'Sale Id shift 21',0.00,0.00,0.00,8178.54,0.00,'2022-05-17 16:24:58','',''),(714,'21','237','7',2,'Sale Id shift 21',0.00,0.00,0.00,2249.94,0.00,'2022-05-17 16:24:58','',''),(715,'21','237','7',2,'Sale Id shift 21',0.00,0.00,0.00,4749.25,0.00,'2022-05-17 16:24:58','',''),(716,'21','237','3',1,'Sale Id shift 21',0.00,0.00,0.00,4753.31,0.00,'2022-05-17 16:24:58','',''),(717,'21','237','3',1,'Sale Id shift 21',0.00,0.00,0.00,5543.57,0.00,'2022-05-17 16:24:58','',''),(718,'21','237','3',1,'Sale Id shift 21',0.00,0.00,0.00,3964.58,0.00,'2022-05-17 16:24:58','',''),(719,'21','237','3',1,'Sale Id shift 21',0.00,0.00,0.00,5902.16,0.00,'2022-05-17 16:24:58','',''),(720,'21','237','4',1,'Sale Id shift 21',0.00,0.00,0.00,51.52,0.00,'2022-05-17 16:24:58','',''),(721,'21','237','4',1,'Sale Id shift 21',0.00,0.00,0.00,2206.43,0.00,'2022-05-17 16:24:58','',''),(722,'21','237','4',1,'Sale Id shift 21',0.00,0.00,0.00,1181.54,0.00,'2022-05-17 16:24:58','',''),(723,'21','237','4',1,'Sale Id shift 21',0.00,0.00,0.00,1298.69,0.00,'2022-05-17 16:24:58','',''),(724,'21','237',NULL,2,'Sale Id shift 21',30442976.00,0.00,0.00,0.00,0.00,'2022-05-17 16:24:58','',''),(725,'21','237',NULL,1,'Sale Id shift 21',6739497.60,0.00,0.00,0.00,0.00,'2022-05-17 16:24:58','',''),(726,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,28800000.00,45000.00,0.00,0.00,'2022-05-18 17:03:50','',''),(727,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-18 17:07:01','',''),(728,'21','237',NULL,1,'Reception corrector for bridging 63',0.00,0.00,0.00,45000.00,0.00,'2022-05-18 18:21:39','',''),(729,'21','237','4',1,'Received from bridging 63',0.00,0.00,45000.00,0.00,0.00,'2022-05-18 18:21:39','',''),(730,'21','237','1',1,'Sale Id shift 22',0.00,0.00,0.00,6856.79,0.00,'2022-05-19 14:26:55','',''),(731,'21','237','2',1,'Sale Id shift 22',0.00,0.00,0.00,2044.50,0.00,'2022-05-19 14:26:55','',''),(732,'21','237','2',1,'Sale Id shift 22',0.00,0.00,0.00,724.21,0.00,'2022-05-19 14:26:55','',''),(733,'21','237','2',1,'Sale Id shift 22',0.00,0.00,0.00,1695.38,0.00,'2022-05-19 14:26:55','',''),(734,'21','237','4',1,'Sale Id shift 22',0.00,0.00,0.00,1011.81,0.00,'2022-05-19 14:26:55','',''),(735,'21','237','4',1,'Sale Id shift 22',0.00,0.00,0.00,1184.93,0.00,'2022-05-19 14:26:55','',''),(736,'21','237','1',1,'Sale Id shift 22',0.00,0.00,0.00,4502.12,0.00,'2022-05-19 14:26:55','',''),(737,'21','237','5',2,'Sale Id shift 22',0.00,0.00,0.00,4046.76,0.00,'2022-05-19 14:26:55','',''),(738,'21','237','5',2,'Sale Id shift 22',0.00,0.00,0.00,4061.08,0.00,'2022-05-19 14:26:55','',''),(739,'21','237','5',2,'Sale Id shift 22',0.00,0.00,0.00,4191.48,0.00,'2022-05-19 14:26:55','',''),(740,'21','237','5',2,'Sale Id shift 22',0.00,0.00,0.00,5409.95,0.00,'2022-05-19 14:26:55','',''),(741,'21','237','6',2,'Sale Id shift 22',0.00,0.00,0.00,5342.37,0.00,'2022-05-19 14:26:55','',''),(742,'21','237','6',2,'Sale Id shift 22',0.00,0.00,0.00,6017.67,0.00,'2022-05-19 14:26:55','',''),(743,'21','237','6',2,'Sale Id shift 22',0.00,0.00,0.00,6691.38,0.00,'2022-05-19 14:26:55','',''),(744,'21','237','7',2,'Sale Id shift 22',0.00,0.00,0.00,4831.41,0.00,'2022-05-19 14:26:55','',''),(745,'21','237','7',2,'Sale Id shift 22',0.00,0.00,0.00,2570.01,0.00,'2022-05-19 14:26:55','',''),(746,'21','237','1',1,'Sale Id shift 22',0.00,0.00,0.00,3112.87,0.00,'2022-05-19 14:26:55','',''),(747,'21','237','1',1,'Sale Id shift 22',0.00,0.00,0.00,5.90,0.00,'2022-05-19 14:26:55','',''),(748,'21','237','1',1,'Sale Id shift 22',0.00,0.00,0.00,3242.64,0.00,'2022-05-19 14:26:55','',''),(749,'21','237','1',1,'Sale Id shift 22',0.00,0.00,0.00,2747.70,0.00,'2022-05-19 14:26:55','',''),(750,'21','237','1',1,'Sale Id shift 22',0.00,0.00,0.00,6396.58,0.00,'2022-05-19 14:26:55','',''),(751,'21','237','2',1,'Sale Id shift 22',0.00,0.00,0.00,1828.46,0.00,'2022-05-19 14:26:55','',''),(752,'21','237','2',1,'Sale Id shift 22',0.00,0.00,0.00,2073.76,0.00,'2022-05-19 14:26:55','',''),(753,'21','237','2',1,'Sale Id shift 22',0.00,0.00,0.00,2305.01,0.00,'2022-05-19 14:26:55','',''),(754,'21','237','2',1,'Sale Id shift 22',0.00,0.00,0.00,2129.69,0.00,'2022-05-19 14:26:55','',''),(755,'21','237','4',1,'Sale Id shift 22',0.00,0.00,0.00,6.09,0.00,'2022-05-19 14:26:55','',''),(756,'21','237','4',1,'Sale Id shift 22',0.00,0.00,0.00,1253.45,0.00,'2022-05-19 14:26:55','',''),(757,'21','237','4',1,'Sale Id shift 22',0.00,0.00,0.00,480.26,0.00,'2022-05-19 14:26:55','',''),(758,'21','237','4',1,'Sale Id shift 22',0.00,0.00,0.00,1308.03,0.00,'2022-05-19 14:26:55','',''),(759,'21','237','1',1,'Sale Id shift 22',0.00,0.00,0.00,3000.68,0.00,'2022-05-19 14:26:55','',''),(760,'21','237','2',1,'Sale Id shift 22',0.00,0.00,0.00,2364.79,0.00,'2022-05-19 14:26:55','',''),(761,'21','237',NULL,2,'Sale Id shift 22',27623750.40,0.00,0.00,0.00,0.00,'2022-05-19 14:26:55','',''),(762,'21','237',NULL,1,'Sale Id shift 22',8295482.25,0.00,0.00,0.00,0.00,'2022-05-19 14:26:55','',''),(763,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-19 14:43:05','',''),(764,'21','237',NULL,2,'Reception corrector for bridging 61',0.00,0.00,0.00,15000.00,0.00,'2022-05-19 14:47:23','',''),(765,'21','237','5',2,'Received from bridging 61',0.00,0.00,15000.00,0.00,0.00,'2022-05-19 14:47:23','',''),(766,'21','237',NULL,2,'Reception corrector for bridging 62',0.00,0.00,0.00,30000.00,0.00,'2022-05-19 14:47:56','',''),(767,'21','237','6',2,'Received from bridging 62',0.00,0.00,30000.00,0.00,0.00,'2022-05-19 14:47:56','',''),(768,'21','237',NULL,1,'Reception corrector for bridging 64',0.00,0.00,0.00,45000.00,0.00,'2022-05-19 14:49:24','',''),(769,'21','237','2',1,'Received from bridging 64',0.00,0.00,45000.00,0.00,0.00,'2022-05-19 14:49:24','',''),(770,'21','237','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,1014.22,0.00,'2022-05-19 16:20:24','',''),(771,'21','237','1',0,'Inventory adjustment from tank dipping to 2000',0.00,0.00,2000.00,0.00,0.00,'2022-05-19 16:20:24','',''),(772,'21','237','2',1,'Sale Id shift 23',0.00,0.00,0.00,777.59,0.00,'2022-05-19 17:30:16','',''),(773,'21','237','2',1,'Sale Id shift 23',0.00,0.00,0.00,927.86,0.00,'2022-05-19 17:30:16','',''),(774,'21','237','2',1,'Sale Id shift 23',0.00,0.00,0.00,818.70,0.00,'2022-05-19 17:30:16','',''),(775,'21','237','3',1,'Sale Id shift 23',0.00,0.00,0.00,3126.29,0.00,'2022-05-19 17:30:16','',''),(776,'21','237','3',1,'Sale Id shift 23',0.00,0.00,0.00,2261.22,0.00,'2022-05-19 17:30:16','',''),(777,'21','237','3',1,'Sale Id shift 23',0.00,0.00,0.00,3458.05,0.00,'2022-05-19 17:30:16','',''),(778,'21','237','4',1,'Sale Id shift 23',0.00,0.00,0.00,3589.94,0.00,'2022-05-19 17:30:16','',''),(779,'21','237','4',1,'Sale Id shift 23',0.00,0.00,0.00,2048.43,0.00,'2022-05-19 17:30:16','',''),(780,'21','237','4',1,'Sale Id shift 23',0.00,0.00,0.00,2583.21,0.00,'2022-05-19 17:30:16','',''),(781,'21','237','5',2,'Sale Id shift 23',0.00,0.00,0.00,9136.33,0.00,'2022-05-19 17:30:16','',''),(782,'21','237','5',2,'Sale Id shift 23',0.00,0.00,0.00,6.31,0.00,'2022-05-19 17:30:16','',''),(783,'21','237','5',2,'Sale Id shift 23',0.00,0.00,0.00,2687.81,0.00,'2022-05-19 17:30:16','',''),(784,'21','237','5',2,'Sale Id shift 23',0.00,0.00,0.00,5677.22,0.00,'2022-05-19 17:30:16','',''),(785,'21','237','6',2,'Sale Id shift 23',0.00,0.00,0.00,1536.88,0.00,'2022-05-19 17:30:16','',''),(786,'21','237','6',2,'Sale Id shift 23',0.00,0.00,0.00,6107.79,0.00,'2022-05-19 17:30:16','',''),(787,'21','237','6',2,'Sale Id shift 23',0.00,0.00,0.00,6176.44,0.00,'2022-05-19 17:30:16','',''),(788,'21','237','7',2,'Sale Id shift 23',0.00,0.00,0.00,3573.25,0.00,'2022-05-19 17:30:16','',''),(789,'21','237','7',2,'Sale Id shift 23',0.00,0.00,0.00,2469.82,0.00,'2022-05-19 17:30:16','',''),(790,'21','237','2',1,'Sale Id shift 23',0.00,0.00,0.00,1302.95,0.00,'2022-05-19 17:30:16','',''),(791,'21','237','2',1,'Sale Id shift 23',0.00,0.00,0.00,531.31,0.00,'2022-05-19 17:30:16','',''),(792,'21','237','2',1,'Sale Id shift 23',0.00,0.00,0.00,1342.25,0.00,'2022-05-19 17:30:16','',''),(793,'21','237','2',1,'Sale Id shift 23',0.00,0.00,0.00,3184.67,0.00,'2022-05-19 17:30:16','',''),(794,'21','237','3',1,'Sale Id shift 23',0.00,0.00,0.00,3299.19,0.00,'2022-05-19 17:30:16','',''),(795,'21','237','3',1,'Sale Id shift 23',0.00,0.00,0.00,2963.21,0.00,'2022-05-19 17:30:16','',''),(796,'21','237','3',1,'Sale Id shift 23',0.00,0.00,0.00,2361.06,0.00,'2022-05-19 17:30:16','',''),(797,'21','237','3',1,'Sale Id shift 23',0.00,0.00,0.00,3247.09,0.00,'2022-05-19 17:30:16','',''),(798,'21','237','4',1,'Sale Id shift 23',0.00,0.00,0.00,6538.50,0.00,'2022-05-19 17:30:16','',''),(799,'21','237','4',1,'Sale Id shift 23',0.00,0.00,0.00,5097.59,0.00,'2022-05-19 17:30:16','',''),(800,'21','237','4',1,'Sale Id shift 23',0.00,0.00,0.00,3883.26,0.00,'2022-05-19 17:30:16','',''),(801,'21','237','2',1,'Sale Id shift 23',0.00,0.00,0.00,2490.45,0.00,'2022-05-19 17:30:16','',''),(802,'21','237',NULL,2,'Sale Id shift 23',23917984.00,0.00,0.00,0.00,0.00,'2022-05-19 17:30:16','',''),(803,'21','237',NULL,1,'Sale Id shift 23',9212415.30,0.00,0.00,0.00,0.00,'2022-05-19 17:30:16','',''),(804,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-19 17:34:29','',''),(805,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,32000000.00,50000.00,0.00,0.00,'2022-05-19 17:36:47','',''),(806,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,32000000.00,50000.00,0.00,0.00,'2022-05-19 17:39:24','',''),(807,'21','237',NULL,1,'Reception corrector for bridging 65',0.00,0.00,0.00,50000.00,0.00,'2022-05-19 17:41:58','',''),(808,'21','237','3',1,'Received from bridging 65',0.00,0.00,50000.00,0.00,0.00,'2022-05-19 17:41:58','',''),(809,'21','237',NULL,2,'Reception corrector for bridging 66',0.00,0.00,0.00,25000.00,0.00,'2022-05-19 17:42:52','',''),(810,'21','237','7',2,'Received from bridging 66',0.00,0.00,25000.00,0.00,0.00,'2022-05-19 17:42:52','',''),(811,'21','237',NULL,2,'Reception corrector for bridging 67',0.00,0.00,0.00,41600.00,0.00,'2022-05-19 17:43:42','',''),(812,'21','237','5',2,'Received from bridging 67',0.00,0.00,41600.00,0.00,0.00,'2022-05-19 17:43:42','',''),(813,'21','237',NULL,2,'Reception corrector for bridging 68',0.00,0.00,0.00,8400.00,0.00,'2022-05-19 17:44:40','',''),(814,'21','237','6',2,'Received from bridging 68',0.00,0.00,8400.00,0.00,0.00,'2022-05-19 17:44:40','',''),(815,'21','237',NULL,2,'Reception corrector for bridging 70',0.00,0.00,0.00,25000.00,0.00,'2022-05-19 17:50:56','',''),(816,'21','237','6',2,'Received from bridging 70',0.00,0.00,25000.00,0.00,0.00,'2022-05-19 17:50:56','',''),(817,'21','237','2',1,'Sale Id shift 24',0.00,0.00,0.00,2923.46,0.00,'2022-05-19 19:12:43','',''),(818,'21','237','2',1,'Sale Id shift 24',0.00,0.00,0.00,2352.96,0.00,'2022-05-19 19:12:43','',''),(819,'21','237','2',1,'Sale Id shift 24',0.00,0.00,0.00,3431.38,0.00,'2022-05-19 19:12:43','',''),(820,'21','237','3',1,'Sale Id shift 24',0.00,0.00,0.00,2238.13,0.00,'2022-05-19 19:12:43','',''),(821,'21','237','3',1,'Sale Id shift 24',0.00,0.00,0.00,2207.99,0.00,'2022-05-19 19:12:43','',''),(822,'21','237','4',1,'Sale Id shift 24',0.00,0.00,0.00,4115.38,0.00,'2022-05-19 19:12:43','',''),(823,'21','237','4',1,'Sale Id shift 24',0.00,0.00,0.00,662.11,0.00,'2022-05-19 19:12:43','',''),(824,'21','237','4',1,'Sale Id shift 24',0.00,0.00,0.00,1087.11,0.00,'2022-05-19 19:12:43','',''),(825,'21','237','5',2,'Sale Id shift 24',0.00,0.00,0.00,8608.61,0.00,'2022-05-19 19:12:43','',''),(826,'21','237','5',2,'Sale Id shift 24',0.00,0.00,0.00,5346.87,0.00,'2022-05-19 19:12:43','',''),(827,'21','237','5',2,'Sale Id shift 24',0.00,0.00,0.00,5768.87,0.00,'2022-05-19 19:12:43','',''),(828,'21','237','5',2,'Sale Id shift 24',0.00,0.00,0.00,3773.68,0.00,'2022-05-19 19:12:43','',''),(829,'21','237','6',2,'Sale Id shift 24',0.00,0.00,0.00,3568.76,0.00,'2022-05-19 19:12:43','',''),(830,'21','237','6',2,'Sale Id shift 24',0.00,0.00,0.00,6166.76,0.00,'2022-05-19 19:12:43','',''),(831,'21','237','6',2,'Sale Id shift 24',0.00,0.00,0.00,3987.72,0.00,'2022-05-19 19:12:43','',''),(832,'21','237','7',2,'Sale Id shift 24',0.00,0.00,0.00,2364.47,0.00,'2022-05-19 19:12:43','',''),(833,'21','237','7',2,'Sale Id shift 24',0.00,0.00,0.00,4068.20,0.00,'2022-05-19 19:12:43','',''),(834,'21','237','2',1,'Sale Id shift 24',0.00,0.00,0.00,2444.97,0.00,'2022-05-19 19:12:43','',''),(835,'21','237','2',1,'Sale Id shift 24',0.00,0.00,0.00,2063.95,0.00,'2022-05-19 19:12:43','',''),(836,'21','237','2',1,'Sale Id shift 24',0.00,0.00,0.00,2044.83,0.00,'2022-05-19 19:12:43','',''),(837,'21','237','2',1,'Sale Id shift 24',0.00,0.00,0.00,5289.42,0.00,'2022-05-19 19:12:43','',''),(838,'21','237','3',1,'Sale Id shift 24',0.00,0.00,0.00,2033.88,0.00,'2022-05-19 19:12:43','',''),(839,'21','237','3',1,'Sale Id shift 24',0.00,0.00,0.00,2312.82,0.00,'2022-05-19 19:12:43','',''),(840,'21','237','3',1,'Sale Id shift 24',0.00,0.00,0.00,3403.63,0.00,'2022-05-19 19:12:43','',''),(841,'21','237','4',1,'Sale Id shift 24',0.00,0.00,0.00,4634.89,0.00,'2022-05-19 19:12:43','',''),(842,'21','237','4',1,'Sale Id shift 24',0.00,0.00,0.00,3435.39,0.00,'2022-05-19 19:12:43','',''),(843,'21','237','4',1,'Sale Id shift 24',0.00,0.00,0.00,1302.58,0.00,'2022-05-19 19:12:43','',''),(844,'21','237','2',1,'Sale Id shift 24',0.00,0.00,0.00,5598.26,0.00,'2022-05-19 19:12:43','',''),(845,'21','237',NULL,2,'Sale Id shift 24',27938521.60,0.00,0.00,0.00,0.00,'2022-05-19 19:12:43','',''),(846,'21','237',NULL,1,'Sale Id shift 24',8841218.10,0.00,0.00,0.00,0.00,'2022-05-19 19:12:43','',''),(847,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-19 19:22:20','',''),(848,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-19 19:23:40','',''),(849,'21','237',NULL,1,'Reception corrector for bridging 71',0.00,0.00,0.00,45000.00,0.00,'2022-05-19 19:25:03','',''),(850,'21','237','1',1,'Received from bridging 71',0.00,0.00,45000.00,0.00,0.00,'2022-05-19 19:25:03','',''),(851,'21','237',NULL,1,'Reception corrector for bridging 72',0.00,0.00,0.00,45000.00,0.00,'2022-05-19 19:26:03','',''),(852,'21','237','4',1,'Received from bridging 72',0.00,0.00,45000.00,0.00,0.00,'2022-05-19 19:26:03','',''),(853,'21','237','2',1,'Sale Id shift 25',0.00,0.00,0.00,764.57,0.00,'2022-05-20 19:29:27','',''),(854,'21','237','2',1,'Sale Id shift 25',0.00,0.00,0.00,1032.16,0.00,'2022-05-20 19:29:27','',''),(855,'21','237','2',1,'Sale Id shift 25',0.00,0.00,0.00,947.87,0.00,'2022-05-20 19:29:27','',''),(856,'21','237','3',1,'Sale Id shift 25',0.00,0.00,0.00,4532.58,0.00,'2022-05-20 19:29:27','',''),(857,'21','237','3',1,'Sale Id shift 25',0.00,0.00,0.00,867.43,0.00,'2022-05-20 19:29:27','',''),(858,'21','237','3',1,'Sale Id shift 25',0.00,0.00,0.00,2495.01,0.00,'2022-05-20 19:29:27','',''),(859,'21','237','4',1,'Sale Id shift 25',0.00,0.00,0.00,3383.30,0.00,'2022-05-20 19:29:27','',''),(860,'21','237','4',1,'Sale Id shift 25',0.00,0.00,0.00,1172.59,0.00,'2022-05-20 19:29:27','',''),(861,'21','237','5',2,'Sale Id shift 25',0.00,0.00,0.00,4749.54,0.00,'2022-05-20 19:29:27','',''),(862,'21','237','5',2,'Sale Id shift 25',0.00,0.00,0.00,6537.03,0.00,'2022-05-20 19:29:27','',''),(863,'21','237','5',2,'Sale Id shift 25',0.00,0.00,0.00,2575.74,0.00,'2022-05-20 19:29:27','',''),(864,'21','237','5',2,'Sale Id shift 25',0.00,0.00,0.00,4110.79,0.00,'2022-05-20 19:29:27','',''),(865,'21','237','6',2,'Sale Id shift 25',0.00,0.00,0.00,7289.27,0.00,'2022-05-20 19:29:27','',''),(866,'21','237','6',2,'Sale Id shift 25',0.00,0.00,0.00,6091.94,0.00,'2022-05-20 19:29:27','',''),(867,'21','237','6',2,'Sale Id shift 25',0.00,0.00,0.00,5504.95,0.00,'2022-05-20 19:29:27','',''),(868,'21','237','7',2,'Sale Id shift 25',0.00,0.00,0.00,4032.11,0.00,'2022-05-20 19:29:27','',''),(869,'21','237','7',2,'Sale Id shift 25',0.00,0.00,0.00,7469.35,0.00,'2022-05-20 19:29:27','',''),(870,'21','237','2',1,'Sale Id shift 25',0.00,0.00,0.00,829.05,0.00,'2022-05-20 19:29:27','',''),(871,'21','237','2',1,'Sale Id shift 25',0.00,0.00,0.00,934.77,0.00,'2022-05-20 19:29:27','',''),(872,'21','237','2',1,'Sale Id shift 25',0.00,0.00,0.00,645.79,0.00,'2022-05-20 19:29:27','',''),(873,'21','237','2',1,'Sale Id shift 25',0.00,0.00,0.00,988.03,0.00,'2022-05-20 19:29:27','',''),(874,'21','237','3',1,'Sale Id shift 25',0.00,0.00,0.00,4958.07,0.00,'2022-05-20 19:29:27','',''),(875,'21','237','3',1,'Sale Id shift 25',0.00,0.00,0.00,3238.36,0.00,'2022-05-20 19:29:27','',''),(876,'21','237','3',1,'Sale Id shift 25',0.00,0.00,0.00,5642.82,0.00,'2022-05-20 19:29:27','',''),(877,'21','237','3',1,'Sale Id shift 25',0.00,0.00,0.00,3826.10,0.00,'2022-05-20 19:29:27','',''),(878,'21','237','4',1,'Sale Id shift 25',0.00,0.00,0.00,6992.35,0.00,'2022-05-20 19:29:27','',''),(879,'21','237','4',1,'Sale Id shift 25',0.00,0.00,0.00,5732.39,0.00,'2022-05-20 19:29:27','',''),(880,'21','237','4',1,'Sale Id shift 25',0.00,0.00,0.00,1684.48,0.00,'2022-05-20 19:29:27','',''),(881,'21','237','2',1,'Sale Id shift 25',0.00,0.00,0.00,1592.99,0.00,'2022-05-20 19:29:27','',''),(882,'21','237',NULL,2,'Sale Id shift 25',30950860.80,0.00,0.00,0.00,0.00,'2022-05-20 19:29:27','',''),(883,'21','237',NULL,1,'Sale Id shift 25',8623017.15,0.00,0.00,0.00,0.00,'2022-05-20 19:29:27','',''),(884,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9600000.00,15000.00,0.00,0.00,'2022-05-23 17:24:07','',''),(885,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,32000000.00,50000.00,0.00,0.00,'2022-05-23 17:26:40','',''),(886,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-05-26 19:35:04','',''),(887,'21','237',NULL,1,'Reception corrector for bridging 77',0.00,0.00,0.00,40000.00,0.00,'2022-05-26 19:38:18','',''),(888,'21','237','2',1,'Received from bridging 77',0.00,0.00,40000.00,0.00,0.00,'2022-05-26 19:38:18','',''),(889,'21','237',NULL,2,'Reception corrector for bridging 73',0.00,0.00,0.00,15000.00,0.00,'2022-05-26 19:39:08','',''),(890,'21','237','5',2,'Received from bridging 73',0.00,0.00,15000.00,0.00,0.00,'2022-05-26 19:39:08','',''),(891,'21','237',NULL,2,'Reception corrector for bridging 76',0.00,0.00,0.00,17000.00,0.00,'2022-05-26 19:39:41','',''),(892,'21','237','7',2,'Received from bridging 76',0.00,0.00,17000.00,0.00,0.00,'2022-05-26 19:39:41','',''),(893,'21','237',NULL,2,'Reception corrector for bridging 75',0.00,0.00,0.00,16000.00,0.00,'2022-05-26 19:40:01','',''),(894,'21','237','6',2,'Received from bridging 75',0.00,0.00,16000.00,0.00,0.00,'2022-05-26 19:40:01','',''),(895,'21','237',NULL,2,'Reception corrector for bridging 74',0.00,0.00,0.00,17000.00,0.00,'2022-05-26 19:40:21','',''),(896,'21','237','5',2,'Received from bridging 74',0.00,0.00,17000.00,0.00,0.00,'2022-05-26 19:40:21','',''),(897,'21','237','2',1,'Sale Id shift 26',0.00,0.00,0.00,1815.95,0.00,'2022-05-27 15:08:21','',''),(898,'21','237','2',1,'Sale Id shift 26',0.00,0.00,0.00,1310.20,0.00,'2022-05-27 15:08:21','',''),(899,'21','237','2',1,'Sale Id shift 26',0.00,0.00,0.00,497.01,0.00,'2022-05-27 15:08:21','',''),(900,'21','237','3',1,'Sale Id shift 26',0.00,0.00,0.00,1743.20,0.00,'2022-05-27 15:08:21','',''),(901,'21','237','3',1,'Sale Id shift 26',0.00,0.00,0.00,113.93,0.00,'2022-05-27 15:08:21','',''),(902,'21','237','3',1,'Sale Id shift 26',0.00,0.00,0.00,2890.28,0.00,'2022-05-27 15:08:21','',''),(903,'21','237','4',1,'Sale Id shift 26',0.00,0.00,0.00,5414.75,0.00,'2022-05-27 15:08:21','',''),(904,'21','237','4',1,'Sale Id shift 26',0.00,0.00,0.00,2519.07,0.00,'2022-05-27 15:08:21','',''),(905,'21','237','4',1,'Sale Id shift 26',0.00,0.00,0.00,4315.47,0.00,'2022-05-27 15:08:21','',''),(906,'21','237','5',2,'Sale Id shift 26',0.00,0.00,0.00,4817.59,0.00,'2022-05-27 15:08:21','',''),(907,'21','237','5',2,'Sale Id shift 26',0.00,0.00,0.00,5867.68,0.00,'2022-05-27 15:08:21','',''),(908,'21','237','5',2,'Sale Id shift 26',0.00,0.00,0.00,1680.00,0.00,'2022-05-27 15:08:21','',''),(909,'21','237','5',2,'Sale Id shift 26',0.00,0.00,0.00,7047.96,0.00,'2022-05-27 15:08:21','',''),(910,'21','237','6',2,'Sale Id shift 26',0.00,0.00,0.00,2207.44,0.00,'2022-05-27 15:08:21','',''),(911,'21','237','6',2,'Sale Id shift 26',0.00,0.00,0.00,6053.49,0.00,'2022-05-27 15:08:21','',''),(912,'21','237','6',2,'Sale Id shift 26',0.00,0.00,0.00,5056.79,0.00,'2022-05-27 15:08:21','',''),(913,'21','237','7',2,'Sale Id shift 26',0.00,0.00,0.00,1214.56,0.00,'2022-05-27 15:08:21','',''),(914,'21','237','7',2,'Sale Id shift 26',0.00,0.00,0.00,5610.71,0.00,'2022-05-27 15:08:21','',''),(915,'21','237','2',1,'Sale Id shift 26',0.00,0.00,0.00,1222.29,0.00,'2022-05-27 15:08:21','',''),(916,'21','237','2',1,'Sale Id shift 26',0.00,0.00,0.00,1999.88,0.00,'2022-05-27 15:08:21','',''),(917,'21','237','3',1,'Sale Id shift 26',0.00,0.00,0.00,2794.25,0.00,'2022-05-27 15:08:21','',''),(918,'21','237','3',1,'Sale Id shift 26',0.00,0.00,0.00,136.36,0.00,'2022-05-27 15:08:21','',''),(919,'21','237','3',1,'Sale Id shift 26',0.00,0.00,0.00,1886.42,0.00,'2022-05-27 15:08:21','',''),(920,'21','237','3',1,'Sale Id shift 26',0.00,0.00,0.00,2765.46,0.00,'2022-05-27 15:08:21','',''),(921,'21','237','4',1,'Sale Id shift 26',0.00,0.00,0.00,6586.51,0.00,'2022-05-27 15:08:21','',''),(922,'21','237','4',1,'Sale Id shift 26',0.00,0.00,0.00,5147.49,0.00,'2022-05-27 15:08:21','',''),(923,'21','237','4',1,'Sale Id shift 26',0.00,0.00,0.00,2674.93,0.00,'2022-05-27 15:08:21','',''),(924,'21','237',NULL,2,'Sale Id shift 26',25315980.80,0.00,0.00,0.00,0.00,'2022-05-27 15:08:21','',''),(925,'21','237',NULL,1,'Sale Id shift 26',7562519.25,0.00,0.00,0.00,0.00,'2022-05-27 15:08:21','',''),(926,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9900000.00,60000.00,0.00,0.00,'2022-05-30 19:51:01','',''),(927,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-30 19:54:40','',''),(928,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,20672000.00,32300.00,0.00,0.00,'2022-05-30 19:56:27','',''),(929,'21','237',NULL,1,'Reception corrector for bridging 78',0.00,0.00,0.00,20000.00,0.00,'2022-05-30 19:59:54','',''),(930,'21','237','2',1,'Received from bridging 78',0.00,0.00,20000.00,0.00,0.00,'2022-05-30 19:59:54','',''),(931,'21','237',NULL,1,'Reception corrector for bridging 79',0.00,0.00,0.00,40000.00,0.00,'2022-05-30 20:00:16','',''),(932,'21','237','4',1,'Received from bridging 79',0.00,0.00,40000.00,0.00,0.00,'2022-05-30 20:00:16','',''),(933,'21','237',NULL,1,'Reception corrector for bridging 80',0.00,0.00,0.00,45000.00,0.00,'2022-05-30 20:00:50','',''),(934,'21','237','3',1,'Received from bridging 80',0.00,0.00,45000.00,0.00,0.00,'2022-05-30 20:00:50','',''),(935,'21','237',NULL,2,'Reception corrector for bridging 81',0.00,0.00,0.00,15900.00,0.00,'2022-05-30 20:01:12','',''),(936,'21','237','5',2,'Received from bridging 81',0.00,0.00,15900.00,0.00,0.00,'2022-05-30 20:01:12','',''),(937,'21','237',NULL,2,'Reception corrector for bridging 82',0.00,0.00,0.00,16400.00,0.00,'2022-05-30 20:01:33','',''),(938,'21','237','6',2,'Received from bridging 82',0.00,0.00,16400.00,0.00,0.00,'2022-05-30 20:01:33','',''),(939,'21','237','3',1,'Sale Id shift 27',0.00,0.00,0.00,1202.08,0.00,'2022-05-31 11:32:55','',''),(940,'21','237','3',1,'Sale Id shift 27',0.00,0.00,0.00,651.68,0.00,'2022-05-31 11:32:55','',''),(941,'21','237','3',1,'Sale Id shift 27',0.00,0.00,0.00,2809.63,0.00,'2022-05-31 11:32:55','',''),(942,'21','237','4',1,'Sale Id shift 27',0.00,0.00,0.00,1685.78,0.00,'2022-05-31 11:32:55','',''),(943,'21','237','4',1,'Sale Id shift 27',0.00,0.00,0.00,956.41,0.00,'2022-05-31 11:32:55','',''),(944,'21','237','4',1,'Sale Id shift 27',0.00,0.00,0.00,2057.76,0.00,'2022-05-31 11:32:55','',''),(945,'21','237','5',2,'Sale Id shift 27',0.00,0.00,0.00,3461.28,0.00,'2022-05-31 11:32:55','',''),(946,'21','237','5',2,'Sale Id shift 27',0.00,0.00,0.00,4420.85,0.00,'2022-05-31 11:32:55','',''),(947,'21','237','5',2,'Sale Id shift 27',0.00,0.00,0.00,2323.44,0.00,'2022-05-31 11:32:55','',''),(948,'21','237','5',2,'Sale Id shift 27',0.00,0.00,0.00,2455.13,0.00,'2022-05-31 11:32:55','',''),(949,'21','237','6',2,'Sale Id shift 27',0.00,0.00,0.00,2646.35,0.00,'2022-05-31 11:32:55','',''),(950,'21','237','6',2,'Sale Id shift 27',0.00,0.00,0.00,6947.08,0.00,'2022-05-31 11:32:55','',''),(951,'21','237','6',2,'Sale Id shift 27',0.00,0.00,0.00,5339.14,0.00,'2022-05-31 11:32:55','',''),(952,'21','237','7',2,'Sale Id shift 27',0.00,0.00,0.00,2430.35,0.00,'2022-05-31 11:32:55','',''),(953,'21','237','7',2,'Sale Id shift 27',0.00,0.00,0.00,4221.59,0.00,'2022-05-31 11:32:55','',''),(954,'21','237','3',1,'Sale Id shift 27',0.00,0.00,0.00,4395.93,0.00,'2022-05-31 11:32:55','',''),(955,'21','237','3',1,'Sale Id shift 27',0.00,0.00,0.00,2094.71,0.00,'2022-05-31 11:32:55','',''),(956,'21','237','3',1,'Sale Id shift 27',0.00,0.00,0.00,2880.44,0.00,'2022-05-31 11:32:55','',''),(957,'21','237','4',1,'Sale Id shift 27',0.00,0.00,0.00,5803.05,0.00,'2022-05-31 11:32:55','',''),(958,'21','237','4',1,'Sale Id shift 27',0.00,0.00,0.00,2498.40,0.00,'2022-05-31 11:32:55','',''),(959,'21','237','4',1,'Sale Id shift 27',0.00,0.00,0.00,3835.84,0.00,'2022-05-31 11:32:55','',''),(960,'21','237',NULL,2,'Sale Id shift 27',21916934.40,0.00,0.00,0.00,0.00,'2022-05-31 11:32:55','',''),(961,'21','237',NULL,1,'Sale Id shift 27',5093832.15,0.00,0.00,0.00,0.00,'2022-05-31 11:32:55','',''),(962,'21','237','1',1,'Sale Id shift 28',0.00,0.00,0.00,6512.51,0.00,'2022-05-31 15:48:29','',''),(963,'21','237','2',1,'Sale Id shift 28',0.00,0.00,0.00,3246.56,0.00,'2022-05-31 15:48:29','',''),(964,'21','237','2',1,'Sale Id shift 28',0.00,0.00,0.00,2180.88,0.00,'2022-05-31 15:48:29','',''),(965,'21','237','4',1,'Sale Id shift 28',0.00,0.00,0.00,5426.37,0.00,'2022-05-31 15:48:29','',''),(966,'21','237','4',1,'Sale Id shift 28',0.00,0.00,0.00,1294.14,0.00,'2022-05-31 15:48:29','',''),(967,'21','237','4',1,'Sale Id shift 28',0.00,0.00,0.00,1070.42,0.00,'2022-05-31 15:48:29','',''),(968,'21','237','5',2,'Sale Id shift 28',0.00,0.00,0.00,6189.85,0.00,'2022-05-31 15:48:29','',''),(969,'21','237','5',2,'Sale Id shift 28',0.00,0.00,0.00,7455.75,0.00,'2022-05-31 15:48:29','',''),(970,'21','237','5',2,'Sale Id shift 28',0.00,0.00,0.00,2765.08,0.00,'2022-05-31 15:48:29','',''),(971,'21','237','5',2,'Sale Id shift 28',0.00,0.00,0.00,3673.72,0.00,'2022-05-31 15:48:29','',''),(972,'21','237','6',2,'Sale Id shift 28',0.00,0.00,0.00,613.12,0.00,'2022-05-31 15:48:29','',''),(973,'21','237','6',2,'Sale Id shift 28',0.00,0.00,0.00,5851.16,0.00,'2022-05-31 15:48:29','',''),(974,'21','237','6',2,'Sale Id shift 28',0.00,0.00,0.00,3857.96,0.00,'2022-05-31 15:48:29','',''),(975,'21','237','7',2,'Sale Id shift 28',0.00,0.00,0.00,3561.19,0.00,'2022-05-31 15:48:29','',''),(976,'21','237','7',2,'Sale Id shift 28',0.00,0.00,0.00,5837.99,0.00,'2022-05-31 15:48:29','',''),(977,'21','237','1',1,'Sale Id shift 28',0.00,0.00,0.00,1759.73,0.00,'2022-05-31 15:48:29','',''),(978,'21','237','1',1,'Sale Id shift 28',0.00,0.00,0.00,355.42,0.00,'2022-05-31 15:48:29','',''),(979,'21','237','1',1,'Sale Id shift 28',0.00,0.00,0.00,3286.95,0.00,'2022-05-31 15:48:29','',''),(980,'21','237','1',1,'Sale Id shift 28',0.00,0.00,0.00,3617.51,0.00,'2022-05-31 15:48:29','',''),(981,'21','237','2',1,'Sale Id shift 28',0.00,0.00,0.00,307.91,0.00,'2022-05-31 15:48:29','',''),(982,'21','237','2',1,'Sale Id shift 28',0.00,0.00,0.00,3458.78,0.00,'2022-05-31 15:48:29','',''),(983,'21','237','4',1,'Sale Id shift 28',0.00,0.00,0.00,0.41,0.00,'2022-05-31 15:48:29','',''),(984,'21','237','4',1,'Sale Id shift 28',0.00,0.00,0.00,4145.40,0.00,'2022-05-31 15:48:29','',''),(985,'21','237','4',1,'Sale Id shift 28',0.00,0.00,0.00,4973.05,0.00,'2022-05-31 15:48:29','',''),(986,'21','237','4',1,'Sale Id shift 28',0.00,0.00,0.00,1701.68,0.00,'2022-05-31 15:48:29','',''),(987,'21','237','1',1,'Sale Id shift 28',0.00,0.00,0.00,4037.16,0.00,'2022-05-31 15:48:29','',''),(988,'21','237','2',1,'Sale Id shift 28',0.00,0.00,0.00,740.53,0.00,'2022-05-31 15:48:29','',''),(989,'21','237',NULL,2,'Sale Id shift 28',25475724.80,0.00,0.00,0.00,0.00,'2022-05-31 15:48:29','',''),(990,'21','237',NULL,1,'Sale Id shift 28',7939042.65,0.00,0.00,0.00,0.00,'2022-05-31 15:48:29','',''),(991,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-31 16:31:31','',''),(992,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,38400000.00,60000.00,0.00,0.00,'2022-05-31 16:43:26','',''),(993,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,28800000.00,45000.00,0.00,0.00,'2022-05-31 16:45:01','',''),(994,'21','237',NULL,2,'Reception corrector for bridging 88',0.00,0.00,0.00,45000.00,0.00,'2022-05-31 16:49:20','',''),(995,'21','237','5',2,'Received from bridging 88',0.00,0.00,45000.00,0.00,0.00,'2022-05-31 16:49:20','',''),(996,'21','237',NULL,2,'Reception corrector for bridging 86',0.00,0.00,0.00,20000.00,0.00,'2022-05-31 17:01:22','',''),(997,'21','237','7',2,'Received from bridging 86',0.00,0.00,20000.00,0.00,0.00,'2022-05-31 17:01:22','',''),(998,'21','237',NULL,2,'Reception corrector for bridging 85',0.00,0.00,0.00,40000.00,0.00,'2022-05-31 17:01:43','',''),(999,'21','237','6',2,'Received from bridging 85',0.00,0.00,40000.00,0.00,0.00,'2022-05-31 17:01:43','',''),(1000,'21','237',NULL,1,'Reception corrector for bridging 84',0.00,0.00,0.00,31000.00,0.00,'2022-05-31 17:02:07','',''),(1001,'21','237','4',1,'Received from bridging 84',0.00,0.00,31000.00,0.00,0.00,'2022-05-31 17:02:07','',''),(1002,'21','237',NULL,1,'Reception corrector for bridging 83',0.00,0.00,0.00,19000.00,0.00,'2022-05-31 17:02:26','',''),(1003,'21','237','3',1,'Received from bridging 83',0.00,0.00,19000.00,0.00,0.00,'2022-05-31 17:02:26','',''),(1004,'21','237','1',1,'Sale Id shift 29',0.00,0.00,0.00,3733.75,0.00,'2022-05-31 18:28:08','',''),(1005,'21','237','2',1,'Sale Id shift 29',0.00,0.00,0.00,4565.09,0.00,'2022-05-31 18:28:08','',''),(1006,'21','237','2',1,'Sale Id shift 29',0.00,0.00,0.00,1291.28,0.00,'2022-05-31 18:28:08','',''),(1007,'21','237','2',1,'Sale Id shift 29',0.00,0.00,0.00,884.10,0.00,'2022-05-31 18:28:08','',''),(1008,'21','237','4',1,'Sale Id shift 29',0.00,0.00,0.00,3403.37,0.00,'2022-05-31 18:28:08','',''),(1009,'21','237','4',1,'Sale Id shift 29',0.00,0.00,0.00,16.97,0.00,'2022-05-31 18:28:08','',''),(1010,'21','237','5',2,'Sale Id shift 29',0.00,0.00,0.00,4380.54,0.00,'2022-05-31 18:28:08','',''),(1011,'21','237','5',2,'Sale Id shift 29',0.00,0.00,0.00,6874.63,0.00,'2022-05-31 18:28:08','',''),(1012,'21','237','5',2,'Sale Id shift 29',0.00,0.00,0.00,3350.32,0.00,'2022-05-31 18:28:08','',''),(1013,'21','237','5',2,'Sale Id shift 29',0.00,0.00,0.00,6703.44,0.00,'2022-05-31 18:28:08','',''),(1014,'21','237','6',2,'Sale Id shift 29',0.00,0.00,0.00,1960.00,0.00,'2022-05-31 18:28:08','',''),(1015,'21','237','6',2,'Sale Id shift 29',0.00,0.00,0.00,7468.35,0.00,'2022-05-31 18:28:08','',''),(1016,'21','237','6',2,'Sale Id shift 29',0.00,0.00,0.00,6940.19,0.00,'2022-05-31 18:28:08','',''),(1017,'21','237','7',2,'Sale Id shift 29',0.00,0.00,0.00,3182.55,0.00,'2022-05-31 18:28:08','',''),(1018,'21','237','7',2,'Sale Id shift 29',0.00,0.00,0.00,2956.55,0.00,'2022-05-31 18:28:08','',''),(1019,'21','237','1',1,'Sale Id shift 29',0.00,0.00,0.00,400.86,0.00,'2022-05-31 18:28:08','',''),(1020,'21','237','1',1,'Sale Id shift 29',0.00,0.00,0.00,4205.89,0.00,'2022-05-31 18:28:08','',''),(1021,'21','237','1',1,'Sale Id shift 29',0.00,0.00,0.00,3952.27,0.00,'2022-05-31 18:28:08','',''),(1022,'21','237','2',1,'Sale Id shift 29',0.00,0.00,0.00,756.84,0.00,'2022-05-31 18:28:08','',''),(1023,'21','237','2',1,'Sale Id shift 29',0.00,0.00,0.00,2410.38,0.00,'2022-05-31 18:28:08','',''),(1024,'21','237','2',1,'Sale Id shift 29',0.00,0.00,0.00,3200.75,0.00,'2022-05-31 18:28:08','',''),(1025,'21','237','2',1,'Sale Id shift 29',0.00,0.00,0.00,2146.94,0.00,'2022-05-31 18:28:08','',''),(1026,'21','237','4',1,'Sale Id shift 29',0.00,0.00,0.00,4357.82,0.00,'2022-05-31 18:28:08','',''),(1027,'21','237','4',1,'Sale Id shift 29',0.00,0.00,0.00,5507.65,0.00,'2022-05-31 18:28:08','',''),(1028,'21','237','4',1,'Sale Id shift 29',0.00,0.00,0.00,4227.14,0.00,'2022-05-31 18:28:08','',''),(1029,'21','237','1',1,'Sale Id shift 29',0.00,0.00,0.00,2487.22,0.00,'2022-05-31 18:28:08','',''),(1030,'21','237','2',1,'Sale Id shift 29',0.00,0.00,0.00,2856.62,0.00,'2022-05-31 18:28:08','',''),(1031,'21','237',NULL,2,'Sale Id shift 29',28042604.80,0.00,0.00,0.00,0.00,'2022-05-31 18:28:08','',''),(1032,'21','237',NULL,1,'Sale Id shift 29',8316815.10,0.00,0.00,0.00,0.00,'2022-05-31 18:28:08','',''),(1033,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-05-31 18:28:34','',''),(1034,'21','237',NULL,1,'Reception corrector for bridging 89',0.00,0.00,0.00,45000.00,0.00,'2022-05-31 18:30:24','',''),(1035,'21','237','1',1,'Received from bridging 89',0.00,0.00,45000.00,0.00,0.00,'2022-05-31 18:30:24','',''),(1036,'21','237','1',1,'Sale Id shift 30',0.00,0.00,0.00,1665.58,0.00,'2022-06-01 05:55:50','',''),(1037,'21','237','2',1,'Sale Id shift 30',0.00,0.00,0.00,1209.42,0.00,'2022-06-01 05:55:50','',''),(1038,'21','237','2',1,'Sale Id shift 30',0.00,0.00,0.00,2130.07,0.00,'2022-06-01 05:55:50','',''),(1039,'21','237','3',1,'Sale Id shift 30',0.00,0.00,0.00,424.18,0.00,'2022-06-01 05:55:50','',''),(1040,'21','237','3',1,'Sale Id shift 30',0.00,0.00,0.00,561.95,0.00,'2022-06-01 05:55:50','',''),(1041,'21','237','3',1,'Sale Id shift 30',0.00,0.00,0.00,1544.65,0.00,'2022-06-01 05:55:50','',''),(1042,'21','237','1',1,'Sale Id shift 30',0.00,0.00,0.00,7.14,0.00,'2022-06-01 05:55:50','',''),(1043,'21','237','4',1,'Sale Id shift 30',0.00,0.00,0.00,911.17,0.00,'2022-06-01 05:55:50','',''),(1044,'21','237','5',2,'Sale Id shift 30',0.00,0.00,0.00,4165.98,0.00,'2022-06-01 05:55:50','',''),(1045,'21','237','5',2,'Sale Id shift 30',0.00,0.00,0.00,4552.29,0.00,'2022-06-01 05:55:50','',''),(1046,'21','237','5',2,'Sale Id shift 30',0.00,0.00,0.00,6066.39,0.00,'2022-06-01 05:55:50','',''),(1047,'21','237','5',2,'Sale Id shift 30',0.00,0.00,0.00,6373.93,0.00,'2022-06-01 05:55:50','',''),(1048,'21','237','6',2,'Sale Id shift 30',0.00,0.00,0.00,4478.52,0.00,'2022-06-01 05:55:50','',''),(1049,'21','237','6',2,'Sale Id shift 30',0.00,0.00,0.00,7250.51,0.00,'2022-06-01 05:55:50','',''),(1050,'21','237','6',2,'Sale Id shift 30',0.00,0.00,0.00,7309.48,0.00,'2022-06-01 05:55:50','',''),(1051,'21','237','7',2,'Sale Id shift 30',0.00,0.00,0.00,4523.14,0.00,'2022-06-01 05:55:50','',''),(1052,'21','237','7',2,'Sale Id shift 30',0.00,0.00,0.00,7857.71,0.00,'2022-06-01 05:55:50','',''),(1053,'21','237','1',1,'Sale Id shift 30',0.00,0.00,0.00,1656.59,0.00,'2022-06-01 05:55:50','',''),(1054,'21','237','1',1,'Sale Id shift 30',0.00,0.00,0.00,31.31,0.00,'2022-06-01 05:55:50','',''),(1055,'21','237','1',1,'Sale Id shift 30',0.00,0.00,0.00,2453.43,0.00,'2022-06-01 05:55:50','',''),(1056,'21','237','1',1,'Sale Id shift 30',0.00,0.00,0.00,958.27,0.00,'2022-06-01 05:55:50','',''),(1057,'21','237','2',1,'Sale Id shift 30',0.00,0.00,0.00,1543.30,0.00,'2022-06-01 05:55:50','',''),(1058,'21','237','2',1,'Sale Id shift 30',0.00,0.00,0.00,1456.29,0.00,'2022-06-01 05:55:50','',''),(1059,'21','237','2',1,'Sale Id shift 30',0.00,0.00,0.00,2543.92,0.00,'2022-06-01 05:55:50','',''),(1060,'21','237','3',1,'Sale Id shift 30',0.00,0.00,0.00,3135.66,0.00,'2022-06-01 05:55:50','',''),(1061,'21','237','3',1,'Sale Id shift 30',0.00,0.00,0.00,1192.68,0.00,'2022-06-01 05:55:50','',''),(1062,'21','237','3',1,'Sale Id shift 30',0.00,0.00,0.00,2422.43,0.00,'2022-06-01 05:55:50','',''),(1063,'21','237','3',1,'Sale Id shift 30',0.00,0.00,0.00,2495.46,0.00,'2022-06-01 05:55:50','',''),(1064,'21','237','4',1,'Sale Id shift 30',0.00,0.00,0.00,4417.08,0.00,'2022-06-01 05:55:50','',''),(1065,'21','237','4',1,'Sale Id shift 30',0.00,0.00,0.00,4268.38,0.00,'2022-06-01 05:55:50','',''),(1066,'21','237','4',1,'Sale Id shift 30',0.00,0.00,0.00,1886.86,0.00,'2022-06-01 05:55:50','',''),(1067,'21','237','1',1,'Sale Id shift 30',0.00,0.00,0.00,1697.75,0.00,'2022-06-01 05:55:50','',''),(1068,'21','237','2',1,'Sale Id shift 30',0.00,0.00,0.00,4550.30,0.00,'2022-06-01 05:55:50','',''),(1069,'21','237',NULL,2,'Sale Id shift 30',33649888.00,0.00,0.00,0.00,0.00,'2022-06-01 05:55:50','',''),(1070,'21','237',NULL,1,'Sale Id shift 30',7452038.55,0.00,0.00,0.00,0.00,'2022-06-01 05:55:50','',''),(1071,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-01 09:28:11','',''),(1072,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,32000000.00,50000.00,0.00,0.00,'2022-06-01 09:30:00','',''),(1073,'21','237',NULL,2,'Reception corrector for bridging 94',0.00,0.00,0.00,16000.00,0.00,'2022-06-01 09:31:24','',''),(1074,'21','237','7',2,'Received from bridging 94',0.00,0.00,16000.00,0.00,0.00,'2022-06-01 09:31:24','',''),(1075,'21','237',NULL,2,'Reception corrector for bridging 93',0.00,0.00,0.00,17000.00,0.00,'2022-06-01 09:31:44','',''),(1076,'21','237','6',2,'Received from bridging 93',0.00,0.00,17000.00,0.00,0.00,'2022-06-01 09:31:44','',''),(1077,'21','237',NULL,2,'Reception corrector for bridging 92',0.00,0.00,0.00,16500.00,0.00,'2022-06-01 09:32:06','',''),(1078,'21','237','5',2,'Received from bridging 92',0.00,0.00,16500.00,0.00,0.00,'2022-06-01 09:32:06','',''),(1079,'21','237',NULL,1,'Reception corrector for bridging 91',0.00,0.00,0.00,30000.00,0.00,'2022-06-01 09:32:27','',''),(1080,'21','237','4',1,'Received from bridging 91',0.00,0.00,30000.00,0.00,0.00,'2022-06-01 09:32:27','',''),(1081,'21','237',NULL,1,'Reception corrector for bridging 90',0.00,0.00,0.00,15000.00,0.00,'2022-06-01 09:32:46','',''),(1082,'21','237','2',1,'Received from bridging 90',0.00,0.00,15000.00,0.00,0.00,'2022-06-01 09:32:46','',''),(1083,'21','237','1',1,'Sale Id shift 32',0.00,0.00,0.00,2834.82,0.00,'2022-06-02 11:54:27','',''),(1084,'21','237','2',1,'Sale Id shift 32',0.00,0.00,0.00,1695.85,0.00,'2022-06-02 11:54:27','',''),(1085,'21','237','2',1,'Sale Id shift 32',0.00,0.00,0.00,265.84,0.00,'2022-06-02 11:54:27','',''),(1086,'21','237','2',1,'Sale Id shift 32',0.00,0.00,0.00,1500.58,0.00,'2022-06-02 11:54:27','',''),(1087,'21','237','3',1,'Sale Id shift 32',0.00,0.00,0.00,453.98,0.00,'2022-06-02 11:54:27','',''),(1088,'21','237','3',1,'Sale Id shift 32',0.00,0.00,0.00,539.33,0.00,'2022-06-02 11:54:27','',''),(1089,'21','237','3',1,'Sale Id shift 32',0.00,0.00,0.00,1659.86,0.00,'2022-06-02 11:54:27','',''),(1090,'21','237','4',1,'Sale Id shift 32',0.00,0.00,0.00,1911.47,0.00,'2022-06-02 11:54:27','',''),(1091,'21','237','4',1,'Sale Id shift 32',0.00,0.00,0.00,141.77,0.00,'2022-06-02 11:54:27','',''),(1092,'21','237','1',1,'Sale Id shift 32',0.00,0.00,0.00,2672.37,0.00,'2022-06-02 11:54:27','',''),(1093,'21','237','5',2,'Sale Id shift 32',0.00,0.00,0.00,3091.70,0.00,'2022-06-02 11:54:27','',''),(1094,'21','237','5',2,'Sale Id shift 32',0.00,0.00,0.00,6680.17,0.00,'2022-06-02 11:54:27','',''),(1095,'21','237','5',2,'Sale Id shift 32',0.00,0.00,0.00,3729.32,0.00,'2022-06-02 11:54:27','',''),(1096,'21','237','5',2,'Sale Id shift 32',0.00,0.00,0.00,7265.61,0.00,'2022-06-02 11:54:27','',''),(1097,'21','237','6',2,'Sale Id shift 32',0.00,0.00,0.00,4697.20,0.00,'2022-06-02 11:54:27','',''),(1098,'21','237','6',2,'Sale Id shift 32',0.00,0.00,0.00,8295.68,0.00,'2022-06-02 11:54:27','',''),(1099,'21','237','6',2,'Sale Id shift 32',0.00,0.00,0.00,4904.61,0.00,'2022-06-02 11:54:27','',''),(1100,'21','237','7',2,'Sale Id shift 32',0.00,0.00,0.00,4582.67,0.00,'2022-06-02 11:54:27','',''),(1101,'21','237','7',2,'Sale Id shift 32',0.00,0.00,0.00,5006.23,0.00,'2022-06-02 11:54:27','',''),(1102,'21','237','1',1,'Sale Id shift 32',0.00,0.00,0.00,0.16,0.00,'2022-06-02 11:54:27','',''),(1103,'21','237','1',1,'Sale Id shift 32',0.00,0.00,0.00,1568.58,0.00,'2022-06-02 11:54:27','',''),(1104,'21','237','1',1,'Sale Id shift 32',0.00,0.00,0.00,1806.65,0.00,'2022-06-02 11:54:27','',''),(1105,'21','237','1',1,'Sale Id shift 32',0.00,0.00,0.00,3175.86,0.00,'2022-06-02 11:54:27','',''),(1106,'21','237','2',1,'Sale Id shift 32',0.00,0.00,0.00,609.76,0.00,'2022-06-02 11:54:27','',''),(1107,'21','237','2',1,'Sale Id shift 32',0.00,0.00,0.00,972.04,0.00,'2022-06-02 11:54:27','',''),(1108,'21','237','2',1,'Sale Id shift 32',0.00,0.00,0.00,1784.18,0.00,'2022-06-02 11:54:27','',''),(1109,'21','237','2',1,'Sale Id shift 32',0.00,0.00,0.00,1734.53,0.00,'2022-06-02 11:54:27','',''),(1110,'21','237','3',1,'Sale Id shift 32',0.00,0.00,0.00,2684.72,0.00,'2022-06-02 11:54:27','',''),(1111,'21','237','3',1,'Sale Id shift 32',0.00,0.00,0.00,1214.14,0.00,'2022-06-02 11:54:27','',''),(1112,'21','237','3',1,'Sale Id shift 32',0.00,0.00,0.00,1639.69,0.00,'2022-06-02 11:54:27','',''),(1113,'21','237','3',1,'Sale Id shift 32',0.00,0.00,0.00,1421.27,0.00,'2022-06-02 11:54:27','',''),(1114,'21','237','4',1,'Sale Id shift 32',0.00,0.00,0.00,3243.21,0.00,'2022-06-02 11:54:27','',''),(1115,'21','237','4',1,'Sale Id shift 32',0.00,0.00,0.00,5525.88,0.00,'2022-06-02 11:54:27','',''),(1116,'21','237','4',1,'Sale Id shift 32',0.00,0.00,0.00,2408.86,0.00,'2022-06-02 11:54:27','',''),(1117,'21','237','1',1,'Sale Id shift 32',0.00,0.00,0.00,2324.19,0.00,'2022-06-02 11:54:27','',''),(1118,'21','237','2',1,'Sale Id shift 32',0.00,0.00,0.00,1479.54,0.00,'2022-06-02 11:54:27','',''),(1119,'21','237',NULL,2,'Sale Id shift 32',30882041.60,0.00,0.00,0.00,0.00,'2022-06-02 11:54:27','',''),(1120,'21','237',NULL,1,'Sale Id shift 32',7799406.45,0.00,0.00,0.00,0.00,'2022-06-02 11:54:27','',''),(1121,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-02 11:57:36','',''),(1122,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,28800000.00,45000.00,0.00,0.00,'2022-06-02 11:59:15','',''),(1123,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,32000000.00,50000.00,0.00,0.00,'2022-06-02 12:00:37','',''),(1124,'21','237',NULL,2,'Reception corrector for bridging 99',0.00,0.00,0.00,17000.00,0.00,'2022-06-02 12:03:05','',''),(1125,'21','237','7',2,'Received from bridging 99',0.00,0.00,17000.00,0.00,0.00,'2022-06-02 12:03:05','',''),(1126,'21','237',NULL,1,'Reception corrector for bridging 95',0.00,0.00,0.00,30000.00,0.00,'2022-06-02 12:04:08','',''),(1127,'21','237','2',1,'Received from bridging 95',0.00,0.00,30000.00,0.00,0.00,'2022-06-02 12:04:08','',''),(1128,'21','237',NULL,2,'Reception corrector for bridging 98',0.00,0.00,0.00,33000.00,0.00,'2022-06-02 12:07:50','',''),(1129,'21','237','6',2,'Received from bridging 98',0.00,0.00,33000.00,0.00,0.00,'2022-06-02 12:07:50','',''),(1130,'21','237',NULL,2,'Reception corrector for bridging 97',0.00,0.00,0.00,45000.00,0.00,'2022-06-02 12:08:19','',''),(1131,'21','237','5',2,'Received from bridging 97',0.00,0.00,45000.00,0.00,0.00,'2022-06-02 12:08:19','',''),(1132,'21','237',NULL,1,'Reception corrector for bridging 96',0.00,0.00,0.00,15000.00,0.00,'2022-06-02 12:08:39','',''),(1133,'21','237','3',1,'Received from bridging 96',0.00,0.00,15000.00,0.00,0.00,'2022-06-02 12:08:39','',''),(1134,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-02 12:51:54','',''),(1135,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,28800000.00,45000.00,0.00,0.00,'2022-06-02 12:54:17','',''),(1136,'21','237','1',1,'Sale Id shift 33',0.00,0.00,0.00,1645.97,0.00,'2022-06-02 13:22:39','',''),(1137,'21','237','2',1,'Sale Id shift 33',0.00,0.00,0.00,460.91,0.00,'2022-06-02 13:22:39','',''),(1138,'21','237','2',1,'Sale Id shift 33',0.00,0.00,0.00,1862.79,0.00,'2022-06-02 13:22:39','',''),(1139,'21','237','2',1,'Sale Id shift 33',0.00,0.00,0.00,965.51,0.00,'2022-06-02 13:22:39','',''),(1140,'21','237','3',1,'Sale Id shift 33',0.00,0.00,0.00,1049.23,0.00,'2022-06-02 13:22:39','',''),(1141,'21','237','3',1,'Sale Id shift 33',0.00,0.00,0.00,1539.48,0.00,'2022-06-02 13:22:39','',''),(1142,'21','237','1',1,'Sale Id shift 33',0.00,0.00,0.00,5855.10,0.00,'2022-06-02 13:22:39','',''),(1143,'21','237','4',1,'Sale Id shift 33',0.00,0.00,0.00,2575.11,0.00,'2022-06-02 13:22:39','',''),(1144,'21','237','5',2,'Sale Id shift 33',0.00,0.00,0.00,3398.70,0.00,'2022-06-02 13:22:39','',''),(1145,'21','237','5',2,'Sale Id shift 33',0.00,0.00,0.00,7616.88,0.00,'2022-06-02 13:22:39','',''),(1146,'21','237','5',2,'Sale Id shift 33',0.00,0.00,0.00,4107.11,0.00,'2022-06-02 13:22:39','',''),(1147,'21','237','5',2,'Sale Id shift 33',0.00,0.00,0.00,6578.02,0.00,'2022-06-02 13:22:39','',''),(1148,'21','237','6',2,'Sale Id shift 33',0.00,0.00,0.00,4946.21,0.00,'2022-06-02 13:22:39','',''),(1149,'21','237','6',2,'Sale Id shift 33',0.00,0.00,0.00,5569.47,0.00,'2022-06-02 13:22:39','',''),(1150,'21','237','6',2,'Sale Id shift 33',0.00,0.00,0.00,5496.75,0.00,'2022-06-02 13:22:39','',''),(1151,'21','237','7',2,'Sale Id shift 33',0.00,0.00,0.00,5608.34,0.00,'2022-06-02 13:22:39','',''),(1152,'21','237','7',2,'Sale Id shift 33',0.00,0.00,0.00,4464.57,0.00,'2022-06-02 13:22:39','',''),(1153,'21','237','1',1,'Sale Id shift 33',0.00,0.00,0.00,31.88,0.00,'2022-06-02 13:22:39','',''),(1154,'21','237','1',1,'Sale Id shift 33',0.00,0.00,0.00,1147.24,0.00,'2022-06-02 13:22:39','',''),(1155,'21','237','1',1,'Sale Id shift 33',0.00,0.00,0.00,1.49,0.00,'2022-06-02 13:22:39','',''),(1156,'21','237','1',1,'Sale Id shift 33',0.00,0.00,0.00,4870.24,0.00,'2022-06-02 13:22:39','',''),(1157,'21','237','1',1,'Sale Id shift 33',0.00,0.00,0.00,1076.94,0.00,'2022-06-02 13:22:39','',''),(1158,'21','237','2',1,'Sale Id shift 33',0.00,0.00,0.00,832.74,0.00,'2022-06-02 13:22:39','',''),(1159,'21','237','2',1,'Sale Id shift 33',0.00,0.00,0.00,802.97,0.00,'2022-06-02 13:22:39','',''),(1160,'21','237','2',1,'Sale Id shift 33',0.00,0.00,0.00,1805.07,0.00,'2022-06-02 13:22:39','',''),(1161,'21','237','2',1,'Sale Id shift 33',0.00,0.00,0.00,1278.68,0.00,'2022-06-02 13:22:39','',''),(1162,'21','237','3',1,'Sale Id shift 33',0.00,0.00,0.00,2863.77,0.00,'2022-06-02 13:22:39','',''),(1163,'21','237','3',1,'Sale Id shift 33',0.00,0.00,0.00,1380.78,0.00,'2022-06-02 13:22:40','',''),(1164,'21','237','4',1,'Sale Id shift 33',0.00,0.00,0.00,3955.62,0.00,'2022-06-02 13:22:40','',''),(1165,'21','237','4',1,'Sale Id shift 33',0.00,0.00,0.00,4638.18,0.00,'2022-06-02 13:22:40','',''),(1166,'21','237','4',1,'Sale Id shift 33',0.00,0.00,0.00,1638.81,0.00,'2022-06-02 13:22:40','',''),(1167,'21','237','1',1,'Sale Id shift 33',0.00,0.00,0.00,2036.32,0.00,'2022-06-02 13:22:40','',''),(1168,'21','237','2',1,'Sale Id shift 33',0.00,0.00,0.00,3050.88,0.00,'2022-06-02 13:22:40','',''),(1169,'21','237',NULL,2,'Sale Id shift 33',30583072.00,0.00,0.00,0.00,0.00,'2022-06-02 13:22:40','',''),(1170,'21','237',NULL,1,'Sale Id shift 33',7815342.15,0.00,0.00,0.00,0.00,'2022-06-02 13:22:40','',''),(1171,'21','237','1',1,'Sale Id shift 34',0.00,0.00,0.00,1830.41,0.00,'2022-06-02 16:34:16','',''),(1172,'21','237','2',1,'Sale Id shift 34',0.00,0.00,0.00,1239.67,0.00,'2022-06-02 16:34:16','',''),(1173,'21','237','2',1,'Sale Id shift 34',0.00,0.00,0.00,1156.45,0.00,'2022-06-02 16:34:16','',''),(1174,'21','237','2',1,'Sale Id shift 34',0.00,0.00,0.00,1358.88,0.00,'2022-06-02 16:34:16','',''),(1175,'21','237','3',1,'Sale Id shift 34',0.00,0.00,0.00,713.75,0.00,'2022-06-02 16:34:16','',''),(1176,'21','237','3',1,'Sale Id shift 34',0.00,0.00,0.00,989.45,0.00,'2022-06-02 16:34:16','',''),(1177,'21','237','4',1,'Sale Id shift 34',0.00,0.00,0.00,1309.57,0.00,'2022-06-02 16:34:16','',''),(1178,'21','237','1',1,'Sale Id shift 34',0.00,0.00,0.00,872.09,0.00,'2022-06-02 16:34:16','',''),(1179,'21','237','4',1,'Sale Id shift 34',0.00,0.00,0.00,1654.67,0.00,'2022-06-02 16:34:16','',''),(1180,'21','237','5',2,'Sale Id shift 34',0.00,0.00,0.00,4081.55,0.00,'2022-06-02 16:34:16','',''),(1181,'21','237','5',2,'Sale Id shift 34',0.00,0.00,0.00,9191.24,0.00,'2022-06-02 16:34:16','',''),(1182,'21','237','5',2,'Sale Id shift 34',0.00,0.00,0.00,5740.04,0.00,'2022-06-02 16:34:16','',''),(1183,'21','237','5',2,'Sale Id shift 34',0.00,0.00,0.00,5529.46,0.00,'2022-06-02 16:34:16','',''),(1184,'21','237','6',2,'Sale Id shift 34',0.00,0.00,0.00,4914.34,0.00,'2022-06-02 16:34:16','',''),(1185,'21','237','6',2,'Sale Id shift 34',0.00,0.00,0.00,9969.54,0.00,'2022-06-02 16:34:16','',''),(1186,'21','237','6',2,'Sale Id shift 34',0.00,0.00,0.00,6179.84,0.00,'2022-06-02 16:34:16','',''),(1187,'21','237','7',2,'Sale Id shift 34',0.00,0.00,0.00,4414.88,0.00,'2022-06-02 16:34:16','',''),(1188,'21','237','7',2,'Sale Id shift 34',0.00,0.00,0.00,3138.91,0.00,'2022-06-02 16:34:16','',''),(1189,'21','237','1',1,'Sale Id shift 34',0.00,0.00,0.00,2314.45,0.00,'2022-06-02 16:34:16','',''),(1190,'21','237','1',1,'Sale Id shift 34',0.00,0.00,0.00,440.59,0.00,'2022-06-02 16:34:16','',''),(1191,'21','237','1',1,'Sale Id shift 34',0.00,0.00,0.00,3527.17,0.00,'2022-06-02 16:34:16','',''),(1192,'21','237','2',1,'Sale Id shift 34',0.00,0.00,0.00,1942.18,0.00,'2022-06-02 16:34:16','',''),(1193,'21','237','2',1,'Sale Id shift 34',0.00,0.00,0.00,651.68,0.00,'2022-06-02 16:34:16','',''),(1194,'21','237','2',1,'Sale Id shift 34',0.00,0.00,0.00,2205.43,0.00,'2022-06-02 16:34:16','',''),(1195,'21','237','2',1,'Sale Id shift 34',0.00,0.00,0.00,3771.94,0.00,'2022-06-02 16:34:16','',''),(1196,'21','237','3',1,'Sale Id shift 34',0.00,0.00,0.00,3720.08,0.00,'2022-06-02 16:34:16','',''),(1197,'21','237','3',1,'Sale Id shift 34',0.00,0.00,0.00,2213.90,0.00,'2022-06-02 16:34:16','',''),(1198,'21','237','4',1,'Sale Id shift 34',0.00,0.00,0.00,2819.89,0.00,'2022-06-02 16:34:16','',''),(1199,'21','237','4',1,'Sale Id shift 34',0.00,0.00,0.00,3458.63,0.00,'2022-06-02 16:34:16','',''),(1200,'21','237','4',1,'Sale Id shift 34',0.00,0.00,0.00,3142.37,0.00,'2022-06-02 16:34:16','',''),(1201,'21','237','1',1,'Sale Id shift 34',0.00,0.00,0.00,2816.90,0.00,'2022-06-02 16:34:16','',''),(1202,'21','237','2',1,'Sale Id shift 34',0.00,0.00,0.00,4148.14,0.00,'2022-06-02 16:34:16','',''),(1203,'21','237',NULL,2,'Sale Id shift 34',34022272.00,0.00,0.00,0.00,0.00,'2022-06-02 16:34:16','',''),(1204,'21','237',NULL,1,'Sale Id shift 34',7969217.85,0.00,0.00,0.00,0.00,'2022-06-02 16:34:16','',''),(1205,'21','237',NULL,1,'Reception corrector for bridging 100',0.00,0.00,0.00,15000.00,0.00,'2022-06-02 20:28:49','',''),(1206,'21','237','3',1,'Received from bridging 100',0.00,0.00,15000.00,0.00,0.00,'2022-06-02 20:28:49','',''),(1207,'21','237',NULL,1,'Reception corrector for bridging 101',0.00,0.00,0.00,30000.00,0.00,'2022-06-02 20:30:16','',''),(1208,'21','237','4',1,'Received from bridging 101',0.00,0.00,30000.00,0.00,0.00,'2022-06-02 20:30:16','',''),(1209,'21','237',NULL,2,'Reception corrector for bridging 102',0.00,0.00,0.00,21000.00,0.00,'2022-06-02 20:31:27','',''),(1210,'21','237','5',2,'Received from bridging 102',0.00,0.00,21000.00,0.00,0.00,'2022-06-02 20:31:27','',''),(1211,'21','237',NULL,2,'Reception corrector for bridging 103',0.00,0.00,0.00,12000.00,0.00,'2022-06-02 20:31:48','',''),(1212,'21','237','6',2,'Received from bridging 103',0.00,0.00,12000.00,0.00,0.00,'2022-06-02 20:31:48','',''),(1213,'21','237',NULL,2,'Reception corrector for bridging 104',0.00,0.00,0.00,12000.00,0.00,'2022-06-02 20:32:12','',''),(1214,'21','237','7',2,'Received from bridging 104',0.00,0.00,12000.00,0.00,0.00,'2022-06-02 20:32:12','',''),(1215,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-06-02 20:35:29','',''),(1216,'21','237',NULL,1,'Reception corrector for bridging 105',0.00,0.00,0.00,50000.00,0.00,'2022-06-02 20:36:30','',''),(1217,'21','237','1',1,'Received from bridging 105',0.00,0.00,50000.00,0.00,0.00,'2022-06-02 20:36:30','',''),(1218,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,13888000.00,21700.00,0.00,0.00,'2022-06-02 20:36:57','',''),(1219,'21','237','1',1,'Sale Id shift 35',0.00,0.00,0.00,1537.20,0.00,'2022-06-02 22:13:43','',''),(1220,'21','237','2',1,'Sale Id shift 35',0.00,0.00,0.00,2649.27,0.00,'2022-06-02 22:13:43','',''),(1221,'21','237','2',1,'Sale Id shift 35',0.00,0.00,0.00,495.88,0.00,'2022-06-02 22:13:43','',''),(1222,'21','237','2',1,'Sale Id shift 35',0.00,0.00,0.00,747.95,0.00,'2022-06-02 22:13:43','',''),(1223,'21','237','4',1,'Sale Id shift 35',0.00,0.00,0.00,0.07,0.00,'2022-06-02 22:13:43','',''),(1224,'21','237','5',2,'Sale Id shift 35',0.00,0.00,0.00,3830.54,0.00,'2022-06-02 22:13:43','',''),(1225,'21','237','5',2,'Sale Id shift 35',0.00,0.00,0.00,8055.89,0.00,'2022-06-02 22:13:43','',''),(1226,'21','237','5',2,'Sale Id shift 35',0.00,0.00,0.00,1590.97,0.00,'2022-06-02 22:13:43','',''),(1227,'21','237','5',2,'Sale Id shift 35',0.00,0.00,0.00,5323.74,0.00,'2022-06-02 22:13:43','',''),(1228,'21','237','6',2,'Sale Id shift 35',0.00,0.00,0.00,1425.01,0.00,'2022-06-02 22:13:43','',''),(1229,'21','237','6',2,'Sale Id shift 35',0.00,0.00,0.00,7066.60,0.00,'2022-06-02 22:13:43','',''),(1230,'21','237','6',2,'Sale Id shift 35',0.00,0.00,0.00,4793.81,0.00,'2022-06-02 22:13:43','',''),(1231,'21','237','7',2,'Sale Id shift 35',0.00,0.00,0.00,7754.92,0.00,'2022-06-02 22:13:43','',''),(1232,'21','237','7',2,'Sale Id shift 35',0.00,0.00,0.00,10.85,0.00,'2022-06-02 22:13:43','',''),(1233,'21','237','1',1,'Sale Id shift 35',0.00,0.00,0.00,1851.68,0.00,'2022-06-02 22:13:43','',''),(1234,'21','237','1',1,'Sale Id shift 35',0.00,0.00,0.00,2787.35,0.00,'2022-06-02 22:13:43','',''),(1235,'21','237','2',1,'Sale Id shift 35',0.00,0.00,0.00,1462.65,0.00,'2022-06-02 22:13:43','',''),(1236,'21','237','2',1,'Sale Id shift 35',0.00,0.00,0.00,1035.77,0.00,'2022-06-02 22:13:43','',''),(1237,'21','237','2',1,'Sale Id shift 35',0.00,0.00,0.00,2066.68,0.00,'2022-06-02 22:13:43','',''),(1238,'21','237','2',1,'Sale Id shift 35',0.00,0.00,0.00,1759.01,0.00,'2022-06-02 22:13:43','',''),(1239,'21','237','3',1,'Sale Id shift 35',0.00,0.00,0.00,1834.36,0.00,'2022-06-02 22:13:43','',''),(1240,'21','237','3',1,'Sale Id shift 35',0.00,0.00,0.00,211.73,0.00,'2022-06-02 22:13:43','',''),(1241,'21','237','3',1,'Sale Id shift 35',0.00,0.00,0.00,2230.28,0.00,'2022-06-02 22:13:43','',''),(1242,'21','237','3',1,'Sale Id shift 35',0.00,0.00,0.00,2008.12,0.00,'2022-06-02 22:13:43','',''),(1243,'21','237','4',1,'Sale Id shift 35',0.00,0.00,0.00,3316.07,0.00,'2022-06-02 22:13:43','',''),(1244,'21','237','4',1,'Sale Id shift 35',0.00,0.00,0.00,2614.06,0.00,'2022-06-02 22:13:43','',''),(1245,'21','237','4',1,'Sale Id shift 35',0.00,0.00,0.00,883.69,0.00,'2022-06-02 22:13:43','',''),(1246,'21','237','1',1,'Sale Id shift 35',0.00,0.00,0.00,3391.77,0.00,'2022-06-02 22:13:43','',''),(1247,'21','237','2',1,'Sale Id shift 35',0.00,0.00,0.00,2078.30,0.00,'2022-06-02 22:13:43','',''),(1248,'21','237',NULL,2,'Sale Id shift 35',25505491.20,0.00,0.00,0.00,0.00,'2022-06-02 22:13:43','',''),(1249,'21','237',NULL,1,'Sale Id shift 35',5768711.85,0.00,0.00,0.00,0.00,'2022-06-02 22:13:43','',''),(1250,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-02 22:25:27','',''),(1251,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,32000000.00,50000.00,0.00,0.00,'2022-06-02 22:27:03','',''),(1252,'21','237',NULL,2,'Reception corrector for bridging 110',0.00,0.00,0.00,15000.00,0.00,'2022-06-02 22:28:50','',''),(1253,'21','237','7',2,'Received from bridging 110',0.00,0.00,15000.00,0.00,0.00,'2022-06-02 22:28:50','',''),(1254,'21','237',NULL,2,'Reception corrector for bridging 109',0.00,0.00,0.00,20000.00,0.00,'2022-06-02 22:29:09','',''),(1255,'21','237','6',2,'Received from bridging 109',0.00,0.00,20000.00,0.00,0.00,'2022-06-02 22:29:09','',''),(1256,'21','237',NULL,2,'Reception corrector for bridging 108',0.00,0.00,0.00,15000.00,0.00,'2022-06-02 22:29:32','',''),(1257,'21','237','5',2,'Received from bridging 108',0.00,0.00,15000.00,0.00,0.00,'2022-06-02 22:29:32','',''),(1258,'21','237',NULL,1,'Reception corrector for bridging 107',0.00,0.00,0.00,45000.00,0.00,'2022-06-02 22:29:49','',''),(1259,'21','237','2',1,'Received from bridging 107',0.00,0.00,45000.00,0.00,0.00,'2022-06-02 22:29:49','',''),(1260,'21','237',NULL,2,'Reception corrector for bridging 106',0.00,0.00,0.00,12700.00,0.00,'2022-06-02 22:30:10','',''),(1261,'21','237','5',2,'Received from bridging 106',0.00,0.00,12700.00,0.00,0.00,'2022-06-02 22:30:10','',''),(1262,'21','237','1',1,'Sale Id shift 36',0.00,0.00,0.00,1625.02,0.00,'2022-06-03 05:37:24','',''),(1263,'21','237','2',1,'Sale Id shift 36',0.00,0.00,0.00,1382.24,0.00,'2022-06-03 05:37:24','',''),(1264,'21','237','2',1,'Sale Id shift 36',0.00,0.00,0.00,279.26,0.00,'2022-06-03 05:37:24','',''),(1265,'21','237','2',1,'Sale Id shift 36',0.00,0.00,0.00,2044.80,0.00,'2022-06-03 05:37:24','',''),(1266,'21','237','3',1,'Sale Id shift 36',0.00,0.00,0.00,1120.91,0.00,'2022-06-03 05:37:24','',''),(1267,'21','237','4',1,'Sale Id shift 36',0.00,0.00,0.00,1379.50,0.00,'2022-06-03 05:37:24','',''),(1268,'21','237','4',1,'Sale Id shift 36',0.00,0.00,0.00,497.35,0.00,'2022-06-03 05:37:24','',''),(1269,'21','237','1',1,'Sale Id shift 36',0.00,0.00,0.00,1300.64,0.00,'2022-06-03 05:37:24','',''),(1270,'21','237','4',1,'Sale Id shift 36',0.00,0.00,0.00,1683.47,0.00,'2022-06-03 05:37:24','',''),(1271,'21','237','5',2,'Sale Id shift 36',0.00,0.00,0.00,2465.50,0.00,'2022-06-03 05:37:24','',''),(1272,'21','237','5',2,'Sale Id shift 36',0.00,0.00,0.00,6565.80,0.00,'2022-06-03 05:37:24','',''),(1273,'21','237','5',2,'Sale Id shift 36',0.00,0.00,0.00,4871.81,0.00,'2022-06-03 05:37:24','',''),(1274,'21','237','5',2,'Sale Id shift 36',0.00,0.00,0.00,1999.11,0.00,'2022-06-03 05:37:24','',''),(1275,'21','237','6',2,'Sale Id shift 36',0.00,0.00,0.00,2326.19,0.00,'2022-06-03 05:37:24','',''),(1276,'21','237','6',2,'Sale Id shift 36',0.00,0.00,0.00,6418.88,0.00,'2022-06-03 05:37:24','',''),(1277,'21','237','6',2,'Sale Id shift 36',0.00,0.00,0.00,4825.31,0.00,'2022-06-03 05:37:24','',''),(1278,'21','237','7',2,'Sale Id shift 36',0.00,0.00,0.00,4033.13,0.00,'2022-06-03 05:37:24','',''),(1279,'21','237','7',2,'Sale Id shift 36',0.00,0.00,0.00,2420.49,0.00,'2022-06-03 05:37:24','',''),(1280,'21','237','1',1,'Sale Id shift 36',0.00,0.00,0.00,3.03,0.00,'2022-06-03 05:37:24','',''),(1281,'21','237','1',1,'Sale Id shift 36',0.00,0.00,0.00,1667.45,0.00,'2022-06-03 05:37:24','',''),(1282,'21','237','1',1,'Sale Id shift 36',0.00,0.00,0.00,54.82,0.00,'2022-06-03 05:37:24','',''),(1283,'21','237','1',1,'Sale Id shift 36',0.00,0.00,0.00,1689.48,0.00,'2022-06-03 05:37:24','',''),(1284,'21','237','1',1,'Sale Id shift 36',0.00,0.00,0.00,2761.77,0.00,'2022-06-03 05:37:24','',''),(1285,'21','237','2',1,'Sale Id shift 36',0.00,0.00,0.00,1412.26,0.00,'2022-06-03 05:37:24','',''),(1286,'21','237','2',1,'Sale Id shift 36',0.00,0.00,0.00,1113.86,0.00,'2022-06-03 05:37:24','',''),(1287,'21','237','2',1,'Sale Id shift 36',0.00,0.00,0.00,679.87,0.00,'2022-06-03 05:37:24','',''),(1288,'21','237','2',1,'Sale Id shift 36',0.00,0.00,0.00,2128.58,0.00,'2022-06-03 05:37:24','',''),(1289,'21','237','3',1,'Sale Id shift 36',0.00,0.00,0.00,4323.91,0.00,'2022-06-03 05:37:24','',''),(1290,'21','237','3',1,'Sale Id shift 36',0.00,0.00,0.00,2193.43,0.00,'2022-06-03 05:37:24','',''),(1291,'21','237','4',1,'Sale Id shift 36',0.00,0.00,0.00,2960.70,0.00,'2022-06-03 05:37:24','',''),(1292,'21','237','4',1,'Sale Id shift 36',0.00,0.00,0.00,2751.88,0.00,'2022-06-03 05:37:24','',''),(1293,'21','237','4',1,'Sale Id shift 36',0.00,0.00,0.00,2992.61,0.00,'2022-06-03 05:37:24','',''),(1294,'21','237','1',1,'Sale Id shift 36',0.00,0.00,0.00,3251.86,0.00,'2022-06-03 05:37:24','',''),(1295,'21','237','2',1,'Sale Id shift 36',0.00,0.00,0.00,3548.41,0.00,'2022-06-03 05:37:24','',''),(1296,'21','237',NULL,2,'Sale Id shift 36',22992780.80,0.00,0.00,0.00,0.00,'2022-06-03 05:37:24','',''),(1297,'21','237',NULL,1,'Sale Id shift 36',7399773.15,0.00,0.00,0.00,0.00,'2022-06-03 05:37:24','',''),(1298,'21','237','5',0,'Tank level zero out for dipping',0.00,0.00,0.00,19811.06,0.00,'2022-06-04 18:32:27','',''),(1299,'21','237','5',0,'Inventory adjustment from tank dipping to 24611',0.00,0.00,24611.00,0.00,0.00,'2022-06-04 18:32:27','',''),(1300,'21','237','1',1,'Sale Id shift 38',0.00,0.00,0.00,3544.35,0.00,'2022-06-05 09:37:58','',''),(1301,'21','237','2',1,'Sale Id shift 38',0.00,0.00,0.00,1120.83,0.00,'2022-06-05 09:37:58','',''),(1302,'21','237','2',1,'Sale Id shift 38',0.00,0.00,0.00,516.28,0.00,'2022-06-05 09:37:58','',''),(1303,'21','237','2',1,'Sale Id shift 38',0.00,0.00,0.00,1372.76,0.00,'2022-06-05 09:37:58','',''),(1304,'21','237','3',1,'Sale Id shift 38',0.00,0.00,0.00,309.63,0.00,'2022-06-05 09:37:58','',''),(1305,'21','237','3',1,'Sale Id shift 38',0.00,0.00,0.00,1476.52,0.00,'2022-06-05 09:37:58','',''),(1306,'21','237','3',1,'Sale Id shift 38',0.00,0.00,0.00,372.29,0.00,'2022-06-05 09:37:58','',''),(1307,'21','237','4',1,'Sale Id shift 38',0.00,0.00,0.00,1056.16,0.00,'2022-06-05 09:37:58','',''),(1308,'21','237','1',1,'Sale Id shift 38',0.00,0.00,0.00,533.67,0.00,'2022-06-05 09:37:58','',''),(1309,'21','237','4',1,'Sale Id shift 38',0.00,0.00,0.00,1630.38,0.00,'2022-06-05 09:37:58','',''),(1310,'21','237','5',2,'Sale Id shift 38',0.00,0.00,0.00,6274.25,0.00,'2022-06-05 09:37:58','',''),(1311,'21','237','5',2,'Sale Id shift 38',0.00,0.00,0.00,7103.28,0.00,'2022-06-05 09:37:58','',''),(1312,'21','237','5',2,'Sale Id shift 38',0.00,0.00,0.00,5676.47,0.00,'2022-06-05 09:37:58','',''),(1313,'21','237','5',2,'Sale Id shift 38',0.00,0.00,0.00,5393.15,0.00,'2022-06-05 09:37:58','',''),(1314,'21','237','6',2,'Sale Id shift 38',0.00,0.00,0.00,7078.03,0.00,'2022-06-05 09:37:58','',''),(1315,'21','237','6',2,'Sale Id shift 38',0.00,0.00,0.00,3506.22,0.00,'2022-06-05 09:37:58','',''),(1316,'21','237','6',2,'Sale Id shift 38',0.00,0.00,0.00,9727.32,0.00,'2022-06-05 09:37:58','',''),(1317,'21','237','7',2,'Sale Id shift 38',0.00,0.00,0.00,5856.40,0.00,'2022-06-05 09:37:58','',''),(1318,'21','237','7',2,'Sale Id shift 38',0.00,0.00,0.00,7174.41,0.00,'2022-06-05 09:37:58','',''),(1319,'21','237','1',1,'Sale Id shift 38',0.00,0.00,0.00,1008.36,0.00,'2022-06-05 09:37:58','',''),(1320,'21','237','1',1,'Sale Id shift 38',0.00,0.00,0.00,1652.77,0.00,'2022-06-05 09:37:58','',''),(1321,'21','237','1',1,'Sale Id shift 38',0.00,0.00,0.00,2416.37,0.00,'2022-06-05 09:37:58','',''),(1322,'21','237','2',1,'Sale Id shift 38',0.00,0.00,0.00,1208.98,0.00,'2022-06-05 09:37:58','',''),(1323,'21','237','2',1,'Sale Id shift 38',0.00,0.00,0.00,571.71,0.00,'2022-06-05 09:37:58','',''),(1324,'21','237','2',1,'Sale Id shift 38',0.00,0.00,0.00,2704.72,0.00,'2022-06-05 09:37:58','',''),(1325,'21','237','2',1,'Sale Id shift 38',0.00,0.00,0.00,2669.97,0.00,'2022-06-05 09:37:58','',''),(1326,'21','237','3',1,'Sale Id shift 38',0.00,0.00,0.00,2587.73,0.00,'2022-06-05 09:37:58','',''),(1327,'21','237','3',1,'Sale Id shift 38',0.00,0.00,0.00,132.76,0.00,'2022-06-05 09:37:58','',''),(1328,'21','237','3',1,'Sale Id shift 38',0.00,0.00,0.00,960.26,0.00,'2022-06-05 09:37:58','',''),(1329,'21','237','3',1,'Sale Id shift 38',0.00,0.00,0.00,1951.58,0.00,'2022-06-05 09:37:58','',''),(1330,'21','237','4',1,'Sale Id shift 38',0.00,0.00,0.00,0.74,0.00,'2022-06-05 09:37:58','',''),(1331,'21','237','4',1,'Sale Id shift 38',0.00,0.00,0.00,3012.08,0.00,'2022-06-05 09:37:58','',''),(1332,'21','237','4',1,'Sale Id shift 38',0.00,0.00,0.00,2941.70,0.00,'2022-06-05 09:37:58','',''),(1333,'21','237','4',1,'Sale Id shift 38',0.00,0.00,0.00,1994.12,0.00,'2022-06-05 09:37:58','',''),(1334,'21','237','1',1,'Sale Id shift 38',0.00,0.00,0.00,2713.82,0.00,'2022-06-05 09:37:58','',''),(1335,'21','237','2',1,'Sale Id shift 38',0.00,0.00,0.00,2308.76,0.00,'2022-06-05 09:37:58','',''),(1336,'21','237',NULL,2,'Sale Id shift 38',36985299.20,0.00,0.00,0.00,0.00,'2022-06-05 09:37:58','',''),(1337,'21','237',NULL,1,'Sale Id shift 38',7056934.50,0.00,0.00,0.00,0.00,'2022-06-05 09:37:58','',''),(1338,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-05 11:07:05','',''),(1339,'21','237',NULL,1,'Reception corrector for bridging 111',0.00,0.00,0.00,45000.00,0.00,'2022-06-05 11:09:45','',''),(1340,'21','237','4',1,'Received from bridging 111',0.00,0.00,45000.00,0.00,0.00,'2022-06-05 11:09:45','',''),(1341,'21','237','5',0,'Tank level zero out for dipping',0.00,0.00,0.00,163.85,0.00,'2022-06-05 16:40:24','',''),(1342,'21','237','5',0,'Inventory adjustment from tank dipping to 3900',0.00,0.00,3900.00,0.00,0.00,'2022-06-05 16:40:24','',''),(1343,'21','237','6',0,'Tank level zero out for dipping',0.00,0.00,0.00,485.91,0.00,'2022-06-05 16:41:06','',''),(1344,'21','237','6',0,'Inventory adjustment from tank dipping to 4350',0.00,0.00,4350.00,0.00,0.00,'2022-06-05 16:41:06','',''),(1345,'21','237','7',0,'Tank level zero out for dipping',0.00,0.00,0.00,35866.50,0.00,'2022-06-05 16:41:34','',''),(1346,'21','237','7',0,'Inventory adjustment from tank dipping to 38200',0.00,0.00,38200.00,0.00,0.00,'2022-06-05 16:41:34','',''),(1347,'21','237','2',1,'Sale Id shift 39',0.00,0.00,0.00,1529.48,0.00,'2022-06-06 08:42:26','',''),(1348,'21','237','2',1,'Sale Id shift 39',0.00,0.00,0.00,578.48,0.00,'2022-06-06 08:42:26','',''),(1349,'21','237','2',1,'Sale Id shift 39',0.00,0.00,0.00,714.82,0.00,'2022-06-06 08:42:26','',''),(1350,'21','237','3',1,'Sale Id shift 39',0.00,0.00,0.00,659.06,0.00,'2022-06-06 08:42:26','',''),(1351,'21','237','3',1,'Sale Id shift 39',0.00,0.00,0.00,1337.84,0.00,'2022-06-06 08:42:26','',''),(1352,'21','237','3',1,'Sale Id shift 39',0.00,0.00,0.00,477.27,0.00,'2022-06-06 08:42:26','',''),(1353,'21','237','4',1,'Sale Id shift 39',0.00,0.00,0.00,1752.72,0.00,'2022-06-06 08:42:26','',''),(1354,'21','237','4',1,'Sale Id shift 39',0.00,0.00,0.00,0.06,0.00,'2022-06-06 08:42:26','',''),(1355,'21','237','4',1,'Sale Id shift 39',0.00,0.00,0.00,210.58,0.00,'2022-06-06 08:42:26','',''),(1356,'21','237','4',1,'Sale Id shift 39',0.00,0.00,0.00,1214.49,0.00,'2022-06-06 08:42:26','',''),(1357,'21','237','6',2,'Sale Id shift 39',0.00,0.00,0.00,820.26,0.00,'2022-06-06 08:42:26','',''),(1358,'21','237','6',2,'Sale Id shift 39',0.00,0.00,0.00,3.57,0.00,'2022-06-06 08:42:26','',''),(1359,'21','237','6',2,'Sale Id shift 39',0.00,0.00,0.00,776.00,0.00,'2022-06-06 08:42:26','',''),(1360,'21','237','7',2,'Sale Id shift 39',0.00,0.00,0.00,17996.33,0.00,'2022-06-06 08:42:26','',''),(1361,'21','237','7',2,'Sale Id shift 39',0.00,0.00,0.00,18280.56,0.00,'2022-06-06 08:42:26','',''),(1362,'21','237','2',1,'Sale Id shift 39',0.00,0.00,0.00,661.50,0.00,'2022-06-06 08:42:26','',''),(1363,'21','237','2',1,'Sale Id shift 39',0.00,0.00,0.00,644.92,0.00,'2022-06-06 08:42:26','',''),(1364,'21','237','2',1,'Sale Id shift 39',0.00,0.00,0.00,517.53,0.00,'2022-06-06 08:42:26','',''),(1365,'21','237','2',1,'Sale Id shift 39',0.00,0.00,0.00,1496.39,0.00,'2022-06-06 08:42:26','',''),(1366,'21','237','3',1,'Sale Id shift 39',0.00,0.00,0.00,2191.65,0.00,'2022-06-06 08:42:26','',''),(1367,'21','237','3',1,'Sale Id shift 39',0.00,0.00,0.00,375.45,0.00,'2022-06-06 08:42:26','',''),(1368,'21','237','3',1,'Sale Id shift 39',0.00,0.00,0.00,1986.50,0.00,'2022-06-06 08:42:26','',''),(1369,'21','237','3',1,'Sale Id shift 39',0.00,0.00,0.00,1030.44,0.00,'2022-06-06 08:42:26','',''),(1370,'21','237','4',1,'Sale Id shift 39',0.00,0.00,0.00,4489.85,0.00,'2022-06-06 08:42:26','',''),(1371,'21','237','4',1,'Sale Id shift 39',0.00,0.00,0.00,2062.70,0.00,'2022-06-06 08:42:26','',''),(1372,'21','237','4',1,'Sale Id shift 39',0.00,0.00,0.00,3069.99,0.00,'2022-06-06 08:42:26','',''),(1373,'21','237','2',1,'Sale Id shift 39',0.00,0.00,0.00,2530.12,0.00,'2022-06-06 08:42:26','',''),(1374,'21','237',NULL,2,'Sale Id shift 39',24241100.80,0.00,0.00,0.00,0.00,'2022-06-06 08:42:26','',''),(1375,'21','237',NULL,1,'Sale Id shift 39',4872753.60,0.00,0.00,0.00,0.00,'2022-06-06 08:42:26','',''),(1376,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-06 08:49:07','',''),(1377,'21','237',NULL,1,'Reception corrector for bridging 112',0.00,0.00,0.00,30000.00,0.00,'2022-06-06 08:51:41','',''),(1378,'21','237','1',1,'Received from bridging 112',0.00,0.00,30000.00,0.00,0.00,'2022-06-06 08:51:41','',''),(1379,'21','237',NULL,1,'Reception corrector for bridging 113',0.00,0.00,0.00,15000.00,0.00,'2022-06-06 08:52:11','',''),(1380,'21','237','2',1,'Received from bridging 113',0.00,0.00,15000.00,0.00,0.00,'2022-06-06 08:52:11','',''),(1381,'21','237','1',1,'Sale Id shift 40',0.00,0.00,0.00,338.56,0.00,'2022-06-06 09:32:08','',''),(1382,'21','237','2',1,'Sale Id shift 40',0.00,0.00,0.00,1006.48,0.00,'2022-06-06 09:32:08','',''),(1383,'21','237','2',1,'Sale Id shift 40',0.00,0.00,0.00,3219.80,0.00,'2022-06-06 09:32:08','',''),(1384,'21','237','2',1,'Sale Id shift 40',0.00,0.00,0.00,853.04,0.00,'2022-06-06 09:32:08','',''),(1385,'21','237','3',1,'Sale Id shift 40',0.00,0.00,0.00,1513.50,0.00,'2022-06-06 09:32:08','',''),(1386,'21','237','3',1,'Sale Id shift 40',0.00,0.00,0.00,1032.76,0.00,'2022-06-06 09:32:08','',''),(1387,'21','237','3',1,'Sale Id shift 40',0.00,0.00,0.00,143.01,0.00,'2022-06-06 09:32:08','',''),(1388,'21','237','4',1,'Sale Id shift 40',0.00,0.00,0.00,0.30,0.00,'2022-06-06 09:32:08','',''),(1389,'21','237','4',1,'Sale Id shift 40',0.00,0.00,0.00,1154.45,0.00,'2022-06-06 09:32:08','',''),(1390,'21','237','1',1,'Sale Id shift 40',0.00,0.00,0.00,2064.12,0.00,'2022-06-06 09:32:08','',''),(1391,'21','237','4',1,'Sale Id shift 40',0.00,0.00,0.00,1170.99,0.00,'2022-06-06 09:32:08','',''),(1392,'21','237','1',1,'Sale Id shift 40',0.00,0.00,0.00,30.29,0.00,'2022-06-06 09:32:08','',''),(1393,'21','237','1',1,'Sale Id shift 40',0.00,0.00,0.00,620.18,0.00,'2022-06-06 09:32:08','',''),(1394,'21','237','1',1,'Sale Id shift 40',0.00,0.00,0.00,1139.79,0.00,'2022-06-06 09:32:08','',''),(1395,'21','237','1',1,'Sale Id shift 40',0.00,0.00,0.00,734.36,0.00,'2022-06-06 09:32:08','',''),(1396,'21','237','2',1,'Sale Id shift 40',0.00,0.00,0.00,950.63,0.00,'2022-06-06 09:32:08','',''),(1397,'21','237','2',1,'Sale Id shift 40',0.00,0.00,0.00,1883.48,0.00,'2022-06-06 09:32:08','',''),(1398,'21','237','2',1,'Sale Id shift 40',0.00,0.00,0.00,2804.98,0.00,'2022-06-06 09:32:08','',''),(1399,'21','237','2',1,'Sale Id shift 40',0.00,0.00,0.00,641.01,0.00,'2022-06-06 09:32:08','',''),(1400,'21','237','3',1,'Sale Id shift 40',0.00,0.00,0.00,2798.44,0.00,'2022-06-06 09:32:08','',''),(1401,'21','237','3',1,'Sale Id shift 40',0.00,0.00,0.00,572.88,0.00,'2022-06-06 09:32:08','',''),(1402,'21','237','3',1,'Sale Id shift 40',0.00,0.00,0.00,2376.58,0.00,'2022-06-06 09:32:08','',''),(1403,'21','237','3',1,'Sale Id shift 40',0.00,0.00,0.00,2083.13,0.00,'2022-06-06 09:32:08','',''),(1404,'21','237','4',1,'Sale Id shift 40',0.00,0.00,0.00,2509.23,0.00,'2022-06-06 09:32:08','',''),(1405,'21','237','4',1,'Sale Id shift 40',0.00,0.00,0.00,3219.21,0.00,'2022-06-06 09:32:08','',''),(1406,'21','237','4',1,'Sale Id shift 40',0.00,0.00,0.00,1533.12,0.00,'2022-06-06 09:32:08','',''),(1407,'21','237','1',1,'Sale Id shift 40',0.00,0.00,0.00,1659.28,0.00,'2022-06-06 09:32:08','',''),(1408,'21','237','2',1,'Sale Id shift 40',0.00,0.00,0.00,2634.47,0.00,'2022-06-06 09:32:08','',''),(1409,'21','237',NULL,1,'Sale Id shift 40',6713531.55,0.00,0.00,0.00,0.00,'2022-06-06 09:32:08','',''),(1410,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-06-06 09:32:49','',''),(1411,'21','237',NULL,1,'Reception corrector for bridging 114',0.00,0.00,0.00,50000.00,0.00,'2022-06-06 09:35:03','',''),(1412,'21','237','3',1,'Received from bridging 114',0.00,0.00,50000.00,0.00,0.00,'2022-06-06 09:35:03','',''),(1413,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-06 16:34:29','',''),(1414,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,21440000.00,33500.00,0.00,0.00,'2022-06-06 16:37:10','',''),(1415,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,32000000.00,50000.00,0.00,0.00,'2022-06-06 16:38:25','',''),(1416,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,32000000.00,50000.00,0.00,0.00,'2022-06-06 16:40:12','',''),(1417,'21','237',NULL,1,'Reception corrector for bridging 115',0.00,0.00,0.00,15000.00,0.00,'2022-06-06 16:40:41','',''),(1418,'21','237','2',1,'Received from bridging 115',0.00,0.00,15000.00,0.00,0.00,'2022-06-06 16:40:41','',''),(1419,'21','237',NULL,1,'Reception corrector for bridging 116',0.00,0.00,0.00,30000.00,0.00,'2022-06-06 17:50:14','',''),(1420,'21','237','4',1,'Received from bridging 116',0.00,0.00,30000.00,0.00,0.00,'2022-06-06 17:50:14','',''),(1421,'21','237',NULL,2,'Reception corrector for bridging 117',0.00,0.00,0.00,33500.00,0.00,'2022-06-06 17:54:37','',''),(1422,'21','237','5',2,'Received from bridging 117',0.00,0.00,33500.00,0.00,0.00,'2022-06-06 17:54:37','',''),(1423,'21','237',NULL,2,'Reception corrector for bridging 118',0.00,0.00,0.00,15000.00,0.00,'2022-06-06 18:01:54','',''),(1424,'21','237','5',2,'Received from bridging 118',0.00,0.00,15000.00,0.00,0.00,'2022-06-06 18:01:54','',''),(1425,'21','237',NULL,2,'Reception corrector for bridging 119',0.00,0.00,0.00,20000.00,0.00,'2022-06-06 18:02:44','',''),(1426,'21','237','6',2,'Received from bridging 119',0.00,0.00,20000.00,0.00,0.00,'2022-06-06 18:02:44','',''),(1427,'21','237',NULL,2,'Reception corrector for bridging 120',0.00,0.00,0.00,15000.00,0.00,'2022-06-06 18:03:16','',''),(1428,'21','237','7',2,'Received from bridging 120',0.00,0.00,15000.00,0.00,0.00,'2022-06-06 18:03:16','',''),(1429,'21','237',NULL,2,'Reception corrector for bridging 126',0.00,0.00,0.00,17000.00,0.00,'2022-06-06 18:17:51','',''),(1430,'21','237','7',2,'Received from bridging 126',0.00,0.00,17000.00,0.00,0.00,'2022-06-06 18:17:51','',''),(1431,'21','237',NULL,2,'Reception corrector for bridging 125',0.00,0.00,0.00,33000.00,0.00,'2022-06-07 08:01:01','',''),(1432,'21','237','6',2,'Received from bridging 125',0.00,0.00,33000.00,0.00,0.00,'2022-06-07 08:01:01','',''),(1433,'21','237','1',1,'Sale Id shift 41',0.00,0.00,0.00,2425.54,0.00,'2022-06-07 09:58:22','',''),(1434,'21','237','2',1,'Sale Id shift 41',0.00,0.00,0.00,531.52,0.00,'2022-06-07 09:58:22','',''),(1435,'21','237','2',1,'Sale Id shift 41',0.00,0.00,0.00,992.64,0.00,'2022-06-07 09:58:22','',''),(1436,'21','237','3',1,'Sale Id shift 41',0.00,0.00,0.00,1208.42,0.00,'2022-06-07 09:58:22','',''),(1437,'21','237','3',1,'Sale Id shift 41',0.00,0.00,0.00,570.27,0.00,'2022-06-07 09:58:22','',''),(1438,'21','237','4',1,'Sale Id shift 41',0.00,0.00,0.00,0.84,0.00,'2022-06-07 09:58:22','',''),(1439,'21','237','4',1,'Sale Id shift 41',0.00,0.00,0.00,540.67,0.00,'2022-06-07 09:58:22','',''),(1440,'21','237','1',1,'Sale Id shift 41',0.00,0.00,0.00,27.27,0.00,'2022-06-07 09:58:22','',''),(1441,'21','237','4',1,'Sale Id shift 41',0.00,0.00,0.00,730.97,0.00,'2022-06-07 09:58:22','',''),(1442,'21','237','5',2,'Sale Id shift 41',0.00,0.00,0.00,2157.02,0.00,'2022-06-07 09:58:22','',''),(1443,'21','237','5',2,'Sale Id shift 41',0.00,0.00,0.00,260.00,0.00,'2022-06-07 09:58:22','',''),(1444,'21','237','5',2,'Sale Id shift 41',0.00,0.00,0.00,1100.00,0.00,'2022-06-07 09:58:22','',''),(1445,'21','237','5',2,'Sale Id shift 41',0.00,0.00,0.00,530.00,0.00,'2022-06-07 09:58:22','',''),(1446,'21','237','6',2,'Sale Id shift 41',0.00,0.00,0.00,5316.45,0.00,'2022-06-07 09:58:22','',''),(1447,'21','237','6',2,'Sale Id shift 41',0.00,0.00,0.00,3927.65,0.00,'2022-06-07 09:58:22','',''),(1448,'21','237','6',2,'Sale Id shift 41',0.00,0.00,0.00,4466.50,0.00,'2022-06-07 09:58:22','',''),(1449,'21','237','7',2,'Sale Id shift 41',0.00,0.00,0.00,5676.38,0.00,'2022-06-07 09:58:22','',''),(1450,'21','237','7',2,'Sale Id shift 41',0.00,0.00,0.00,5896.59,0.00,'2022-06-07 09:58:22','',''),(1451,'21','237','1',1,'Sale Id shift 41',0.00,0.00,0.00,546.37,0.00,'2022-06-07 09:58:22','',''),(1452,'21','237','1',1,'Sale Id shift 41',0.00,0.00,0.00,3186.84,0.00,'2022-06-07 09:58:22','',''),(1453,'21','237','1',1,'Sale Id shift 41',0.00,0.00,0.00,2428.79,0.00,'2022-06-07 09:58:22','',''),(1454,'21','237','1',1,'Sale Id shift 41',0.00,0.00,0.00,2116.45,0.00,'2022-06-07 09:58:22','',''),(1455,'21','237','2',1,'Sale Id shift 41',0.00,0.00,0.00,416.62,0.00,'2022-06-07 09:58:22','',''),(1456,'21','237','2',1,'Sale Id shift 41',0.00,0.00,0.00,728.50,0.00,'2022-06-07 09:58:22','',''),(1457,'21','237','2',1,'Sale Id shift 41',0.00,0.00,0.00,2604.34,0.00,'2022-06-07 09:58:22','',''),(1458,'21','237','3',1,'Sale Id shift 41',0.00,0.00,0.00,2582.80,0.00,'2022-06-07 09:58:22','',''),(1459,'21','237','3',1,'Sale Id shift 41',0.00,0.00,0.00,3797.98,0.00,'2022-06-07 09:58:22','',''),(1460,'21','237','3',1,'Sale Id shift 41',0.00,0.00,0.00,1948.85,0.00,'2022-06-07 09:58:22','',''),(1461,'21','237','3',1,'Sale Id shift 41',0.00,0.00,0.00,891.79,0.00,'2022-06-07 09:58:22','',''),(1462,'21','237','4',1,'Sale Id shift 41',0.00,0.00,0.00,3943.40,0.00,'2022-06-07 09:58:22','',''),(1463,'21','237','4',1,'Sale Id shift 41',0.00,0.00,0.00,749.65,0.00,'2022-06-07 09:58:22','',''),(1464,'21','237','4',1,'Sale Id shift 41',0.00,0.00,0.00,2167.13,0.00,'2022-06-07 09:58:22','',''),(1465,'21','237','1',1,'Sale Id shift 41',0.00,0.00,0.00,2708.95,0.00,'2022-06-07 09:58:22','',''),(1466,'21','237','2',1,'Sale Id shift 41',0.00,0.00,0.00,2420.72,0.00,'2022-06-07 09:58:22','',''),(1467,'21','237',NULL,2,'Sale Id shift 41',18771577.60,0.00,0.00,0.00,0.00,'2022-06-07 09:58:22','',''),(1468,'21','237',NULL,1,'Sale Id shift 41',6644107.80,0.00,0.00,0.00,0.00,'2022-06-07 09:58:22','',''),(1469,'21','237','1',1,'Sale Id shift 43',0.00,0.00,0.00,4963.10,0.00,'2022-06-08 10:14:47','',''),(1470,'21','237','2',1,'Sale Id shift 43',0.00,0.00,0.00,1559.53,0.00,'2022-06-08 10:14:47','',''),(1471,'21','237','2',1,'Sale Id shift 43',0.00,0.00,0.00,992.28,0.00,'2022-06-08 10:14:47','',''),(1472,'21','237','2',1,'Sale Id shift 43',0.00,0.00,0.00,1246.59,0.00,'2022-06-08 10:14:47','',''),(1473,'21','237','3',1,'Sale Id shift 43',0.00,0.00,0.00,315.27,0.00,'2022-06-08 10:14:47','',''),(1474,'21','237','3',1,'Sale Id shift 43',0.00,0.00,0.00,1639.18,0.00,'2022-06-08 10:14:47','',''),(1475,'21','237','3',1,'Sale Id shift 43',0.00,0.00,0.00,1739.69,0.00,'2022-06-08 10:14:47','',''),(1476,'21','237','4',1,'Sale Id shift 43',0.00,0.00,0.00,380.00,0.00,'2022-06-08 10:14:47','',''),(1477,'21','237','1',1,'Sale Id shift 43',0.00,0.00,0.00,25.89,0.00,'2022-06-08 10:14:47','',''),(1478,'21','237','5',2,'Sale Id shift 43',0.00,0.00,0.00,5146.39,0.00,'2022-06-08 10:14:47','',''),(1479,'21','237','5',2,'Sale Id shift 43',0.00,0.00,0.00,5258.57,0.00,'2022-06-08 10:14:47','',''),(1480,'21','237','5',2,'Sale Id shift 43',0.00,0.00,0.00,4014.88,0.00,'2022-06-08 10:14:47','',''),(1481,'21','237','5',2,'Sale Id shift 43',0.00,0.00,0.00,6481.01,0.00,'2022-06-08 10:14:47','',''),(1482,'21','237','6',2,'Sale Id shift 43',0.00,0.00,0.00,5268.91,0.00,'2022-06-08 10:14:47','',''),(1483,'21','237','6',2,'Sale Id shift 43',0.00,0.00,0.00,8483.16,0.00,'2022-06-08 10:14:47','',''),(1484,'21','237','6',2,'Sale Id shift 43',0.00,0.00,0.00,6325.02,0.00,'2022-06-08 10:14:47','',''),(1485,'21','237','7',2,'Sale Id shift 43',0.00,0.00,0.00,7967.67,0.00,'2022-06-08 10:14:47','',''),(1486,'21','237','7',2,'Sale Id shift 43',0.00,0.00,0.00,8402.95,0.00,'2022-06-08 10:14:47','',''),(1487,'21','237','1',1,'Sale Id shift 43',0.00,0.00,0.00,212.86,0.00,'2022-06-08 10:14:47','',''),(1488,'21','237','1',1,'Sale Id shift 43',0.00,0.00,0.00,2545.24,0.00,'2022-06-08 10:14:47','',''),(1489,'21','237','1',1,'Sale Id shift 43',0.00,0.00,0.00,0.07,0.00,'2022-06-08 10:14:47','',''),(1490,'21','237','1',1,'Sale Id shift 43',0.00,0.00,0.00,1547.63,0.00,'2022-06-08 10:14:47','',''),(1491,'21','237','1',1,'Sale Id shift 43',0.00,0.00,0.00,1986.99,0.00,'2022-06-08 10:14:47','',''),(1492,'21','237','2',1,'Sale Id shift 43',0.00,0.00,0.00,631.78,0.00,'2022-06-08 10:14:47','',''),(1493,'21','237','2',1,'Sale Id shift 43',0.00,0.00,0.00,1732.19,0.00,'2022-06-08 10:14:47','',''),(1494,'21','237','2',1,'Sale Id shift 43',0.00,0.00,0.00,4183.68,0.00,'2022-06-08 10:14:47','',''),(1495,'21','237','2',1,'Sale Id shift 43',0.00,0.00,0.00,3077.64,0.00,'2022-06-08 10:14:47','',''),(1496,'21','237','3',1,'Sale Id shift 43',0.00,0.00,0.00,4237.14,0.00,'2022-06-08 10:14:47','',''),(1497,'21','237','3',1,'Sale Id shift 43',0.00,0.00,0.00,524.80,0.00,'2022-06-08 10:14:47','',''),(1498,'21','237','3',1,'Sale Id shift 43',0.00,0.00,0.00,2848.39,0.00,'2022-06-08 10:14:47','',''),(1499,'21','237','4',1,'Sale Id shift 43',0.00,0.00,0.00,1763.79,0.00,'2022-06-08 10:14:47','',''),(1500,'21','237','4',1,'Sale Id shift 43',0.00,0.00,0.00,1039.13,0.00,'2022-06-08 10:14:47','',''),(1501,'21','237','4',1,'Sale Id shift 43',0.00,0.00,0.00,2174.10,0.00,'2022-06-08 10:14:47','',''),(1502,'21','237','1',1,'Sale Id shift 43',0.00,0.00,0.00,3400.32,0.00,'2022-06-08 10:14:47','',''),(1503,'21','237','2',1,'Sale Id shift 43',0.00,0.00,0.00,2698.48,0.00,'2022-06-08 10:14:47','',''),(1504,'21','237',NULL,2,'Sale Id shift 43',36703078.40,0.00,0.00,0.00,0.00,'2022-06-08 10:14:47','',''),(1505,'21','237',NULL,1,'Sale Id shift 43',7831850.40,0.00,0.00,0.00,0.00,'2022-06-08 10:14:47','',''),(1506,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,9405000.00,57000.00,0.00,0.00,'2022-06-08 10:41:21','',''),(1507,'21','237',NULL,1,'Reception corrector for bridging 128',0.00,0.00,0.00,40000.00,0.00,'2022-06-08 10:43:45','',''),(1508,'21','237','2',1,'Received from bridging 128',0.00,0.00,40000.00,0.00,0.00,'2022-06-08 10:43:45','',''),(1509,'21','237',NULL,1,'Reception corrector for bridging 127',0.00,0.00,0.00,17000.00,0.00,'2022-06-08 10:44:11','',''),(1510,'21','237','1',1,'Received from bridging 127',0.00,0.00,17000.00,0.00,0.00,'2022-06-08 10:44:11','',''),(1511,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-08 10:45:01','',''),(1512,'21','237',NULL,1,'Reception corrector for bridging 130',0.00,0.00,0.00,14000.00,0.00,'2022-06-08 10:46:47','',''),(1513,'21','237','4',1,'Received from bridging 130',0.00,0.00,14000.00,0.00,0.00,'2022-06-08 10:46:47','',''),(1514,'21','237','2',1,'Sale Id shift 44',0.00,0.00,0.00,4197.11,0.00,'2022-06-08 13:01:48','',''),(1515,'21','237','2',1,'Sale Id shift 44',0.00,0.00,0.00,1853.08,0.00,'2022-06-08 13:01:48','',''),(1516,'21','237','3',1,'Sale Id shift 44',0.00,0.00,0.00,1898.09,0.00,'2022-06-08 13:01:48','',''),(1517,'21','237','3',1,'Sale Id shift 44',0.00,0.00,0.00,1266.81,0.00,'2022-06-08 13:01:48','',''),(1518,'21','237','3',1,'Sale Id shift 44',0.00,0.00,0.00,1266.44,0.00,'2022-06-08 13:01:48','',''),(1519,'21','237','4',1,'Sale Id shift 44',0.00,0.00,0.00,173.25,0.00,'2022-06-08 13:01:48','',''),(1520,'21','237','6',2,'Sale Id shift 44',0.00,0.00,0.00,8532.25,0.00,'2022-06-08 13:01:48','',''),(1521,'21','237','6',2,'Sale Id shift 44',0.00,0.00,0.00,7119.96,0.00,'2022-06-08 13:01:48','',''),(1522,'21','237','6',2,'Sale Id shift 44',0.00,0.00,0.00,5040.83,0.00,'2022-06-08 13:01:48','',''),(1523,'21','237','2',1,'Sale Id shift 44',0.00,0.00,0.00,605.00,0.00,'2022-06-08 13:01:48','',''),(1524,'21','237','2',1,'Sale Id shift 44',0.00,0.00,0.00,3335.28,0.00,'2022-06-08 13:01:48','',''),(1525,'21','237','3',1,'Sale Id shift 44',0.00,0.00,0.00,3673.70,0.00,'2022-06-08 13:01:48','',''),(1526,'21','237','3',1,'Sale Id shift 44',0.00,0.00,0.00,56.91,0.00,'2022-06-08 13:01:48','',''),(1527,'21','237','3',1,'Sale Id shift 44',0.00,0.00,0.00,3786.20,0.00,'2022-06-08 13:01:48','',''),(1528,'21','237','3',1,'Sale Id shift 44',0.00,0.00,0.00,1925.54,0.00,'2022-06-08 13:01:48','',''),(1529,'21','237','4',1,'Sale Id shift 44',0.00,0.00,0.00,4153.17,0.00,'2022-06-08 13:01:48','',''),(1530,'21','237','4',1,'Sale Id shift 44',0.00,0.00,0.00,3025.13,0.00,'2022-06-08 13:01:48','',''),(1531,'21','237','4',1,'Sale Id shift 44',0.00,0.00,0.00,2156.59,0.00,'2022-06-08 13:01:48','',''),(1532,'21','237',NULL,2,'Sale Id shift 44',13243545.60,0.00,0.00,0.00,0.00,'2022-06-08 13:01:48','',''),(1533,'21','237',NULL,1,'Sale Id shift 44',5506429.50,0.00,0.00,0.00,0.00,'2022-06-08 13:01:48','',''),(1534,'21','237',NULL,1,'Reception corrector for bridging 129',0.00,0.00,0.00,31000.00,0.00,'2022-06-08 13:11:22','',''),(1535,'21','237','3',1,'Received from bridging 129',0.00,0.00,31000.00,0.00,0.00,'2022-06-08 13:11:22','',''),(1536,'21','237','2',1,'Sale Id shift 45',0.00,0.00,0.00,3411.14,0.00,'2022-06-08 15:01:09','',''),(1537,'21','237','2',1,'Sale Id shift 45',0.00,0.00,0.00,2372.56,0.00,'2022-06-08 15:01:09','',''),(1538,'21','237','3',1,'Sale Id shift 45',0.00,0.00,0.00,1679.64,0.00,'2022-06-08 15:01:09','',''),(1539,'21','237','3',1,'Sale Id shift 45',0.00,0.00,0.00,1454.62,0.00,'2022-06-08 15:01:09','',''),(1540,'21','237','4',1,'Sale Id shift 45',0.00,0.00,0.00,597.24,0.00,'2022-06-08 15:01:09','',''),(1541,'21','237','4',1,'Sale Id shift 45',0.00,0.00,0.00,393.77,0.00,'2022-06-08 15:01:09','',''),(1542,'21','237','5',2,'Sale Id shift 45',0.00,0.00,0.00,3936.20,0.00,'2022-06-08 15:01:09','',''),(1543,'21','237','5',2,'Sale Id shift 45',0.00,0.00,0.00,7219.07,0.00,'2022-06-08 15:01:09','',''),(1544,'21','237','5',2,'Sale Id shift 45',0.00,0.00,0.00,7270.22,0.00,'2022-06-08 15:01:09','',''),(1545,'21','237','5',2,'Sale Id shift 45',0.00,0.00,0.00,6430.89,0.00,'2022-06-08 15:01:09','',''),(1546,'21','237','7',2,'Sale Id shift 45',0.00,0.00,0.00,635.73,0.00,'2022-06-08 15:01:09','',''),(1547,'21','237',NULL,2,'Sale Id shift 45',16314950.40,0.00,0.00,0.00,0.00,'2022-06-08 15:01:09','',''),(1548,'21','237',NULL,1,'Sale Id shift 45',1634980.05,0.00,0.00,0.00,0.00,'2022-06-08 15:01:09','',''),(1549,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-08 17:50:40','',''),(1550,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-08 17:54:59','',''),(1551,'21','237',NULL,1,'Reception corrector for bridging 131',0.00,0.00,0.00,21000.00,0.00,'2022-06-08 17:56:48','',''),(1552,'21','237','1',1,'Received from bridging 131',0.00,0.00,21000.00,0.00,0.00,'2022-06-08 17:56:48','',''),(1553,'21','237','1',1,'Sale Id shift 46',0.00,0.00,0.00,2683.73,0.00,'2022-06-08 18:38:33','',''),(1554,'21','237','2',1,'Sale Id shift 46',0.00,0.00,0.00,292.26,0.00,'2022-06-08 18:38:33','',''),(1555,'21','237','2',1,'Sale Id shift 46',0.00,0.00,0.00,268.27,0.00,'2022-06-08 18:38:33','',''),(1556,'21','237','2',1,'Sale Id shift 46',0.00,0.00,0.00,833.05,0.00,'2022-06-08 18:38:33','',''),(1557,'21','237','3',1,'Sale Id shift 46',0.00,0.00,0.00,1325.10,0.00,'2022-06-08 18:38:33','',''),(1558,'21','237','1',1,'Sale Id shift 46',0.00,0.00,0.00,4312.97,0.00,'2022-06-08 18:38:33','',''),(1559,'21','237','7',2,'Sale Id shift 46',0.00,0.00,0.00,1250.00,0.00,'2022-06-08 18:38:33','',''),(1560,'21','237','7',2,'Sale Id shift 46',0.00,0.00,0.00,420.02,0.00,'2022-06-08 18:38:33','',''),(1561,'21','237','1',1,'Sale Id shift 46',0.00,0.00,0.00,1975.60,0.00,'2022-06-08 18:38:33','',''),(1562,'21','237','1',1,'Sale Id shift 46',0.00,0.00,0.00,0.50,0.00,'2022-06-08 18:38:33','',''),(1563,'21','237','1',1,'Sale Id shift 46',0.00,0.00,0.00,3873.41,0.00,'2022-06-08 18:38:33','',''),(1564,'21','237','1',1,'Sale Id shift 46',0.00,0.00,0.00,3115.05,0.00,'2022-06-08 18:38:33','',''),(1565,'21','237','2',1,'Sale Id shift 46',0.00,0.00,0.00,3263.95,0.00,'2022-06-08 18:38:33','',''),(1566,'21','237','2',1,'Sale Id shift 46',0.00,0.00,0.00,2766.34,0.00,'2022-06-08 18:38:33','',''),(1567,'21','237','2',1,'Sale Id shift 46',0.00,0.00,0.00,375.37,0.00,'2022-06-08 18:38:33','',''),(1568,'21','237','2',1,'Sale Id shift 46',0.00,0.00,0.00,9060.11,0.00,'2022-06-08 18:38:33','',''),(1569,'21','237','3',1,'Sale Id shift 46',0.00,0.00,0.00,5559.36,0.00,'2022-06-08 18:38:33','',''),(1570,'21','237','3',1,'Sale Id shift 46',0.00,0.00,0.00,8639.68,0.00,'2022-06-08 18:38:33','',''),(1571,'21','237','4',1,'Sale Id shift 46',0.00,0.00,0.00,2045.13,0.00,'2022-06-08 18:38:33','',''),(1572,'21','237','4',1,'Sale Id shift 46',0.00,0.00,0.00,3267.20,0.00,'2022-06-08 18:38:33','',''),(1573,'21','237','4',1,'Sale Id shift 46',0.00,0.00,0.00,1844.74,0.00,'2022-06-08 18:38:33','',''),(1574,'21','237','1',1,'Sale Id shift 46',0.00,0.00,0.00,2893.01,0.00,'2022-06-08 18:38:33','',''),(1575,'21','237','2',1,'Sale Id shift 46',0.00,0.00,0.00,7640.53,0.00,'2022-06-08 18:38:33','',''),(1576,'21','237',NULL,2,'Sale Id shift 46',1068812.80,0.00,0.00,0.00,0.00,'2022-06-08 18:38:33','',''),(1577,'21','237',NULL,1,'Sale Id shift 46',10895834.40,0.00,0.00,0.00,0.00,'2022-06-08 18:38:33','',''),(1578,'21','237',NULL,1,'Reception corrector for bridging 132',0.00,0.00,0.00,12000.00,0.00,'2022-06-08 18:44:17','',''),(1579,'21','237','3',1,'Received from bridging 132',0.00,0.00,12000.00,0.00,0.00,'2022-06-08 18:44:17','',''),(1580,'21','237',NULL,1,'Reception corrector for bridging 133',0.00,0.00,0.00,12000.00,0.00,'2022-06-08 18:45:26','',''),(1581,'21','237','4',1,'Received from bridging 133',0.00,0.00,12000.00,0.00,0.00,'2022-06-08 18:45:26','',''),(1582,'21','237',NULL,1,'Reception corrector for bridging 134',0.00,0.00,0.00,45000.00,0.00,'2022-06-08 18:46:21','',''),(1583,'21','237','2',1,'Received from bridging 134',0.00,0.00,45000.00,0.00,0.00,'2022-06-08 18:46:21','',''),(1584,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,32500000.00,50000.00,0.00,0.00,'2022-06-08 19:38:21','',''),(1585,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,29250000.00,45000.00,0.00,0.00,'2022-06-08 19:56:48','',''),(1586,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,29250000.00,45000.00,0.00,0.00,'2022-06-08 19:59:28','',''),(1587,'21','237',NULL,2,'Reception corrector for bridging 135',0.00,0.00,0.00,48500.00,0.00,'2022-06-08 20:00:50','',''),(1588,'21','237','6',2,'Received from bridging 135',0.00,0.00,48500.00,0.00,0.00,'2022-06-08 20:00:50','',''),(1589,'21','237',NULL,2,'Reception corrector for bridging 136',0.00,0.00,0.00,1500.00,0.00,'2022-06-08 20:01:10','',''),(1590,'21','237','7',2,'Received from bridging 136',0.00,0.00,1500.00,0.00,0.00,'2022-06-08 20:01:10','',''),(1591,'21','237',NULL,2,'Reception corrector for bridging 137',0.00,0.00,0.00,45000.00,0.00,'2022-06-08 20:01:35','',''),(1592,'21','237','5',2,'Received from bridging 137',0.00,0.00,45000.00,0.00,0.00,'2022-06-08 20:01:35','',''),(1593,'21','237',NULL,2,'Reception corrector for bridging 138',0.00,0.00,0.00,45000.00,0.00,'2022-06-08 20:01:56','',''),(1594,'21','237','7',2,'Received from bridging 138',0.00,0.00,45000.00,0.00,0.00,'2022-06-08 20:01:56','',''),(1595,'21','237','1',1,'Sale Id shift 47',0.00,0.00,0.00,2557.62,0.00,'2022-06-08 21:16:42','',''),(1596,'21','237','2',1,'Sale Id shift 47',0.00,0.00,0.00,1318.77,0.00,'2022-06-08 21:16:42','',''),(1597,'21','237','3',1,'Sale Id shift 47',0.00,0.00,0.00,2467.37,0.00,'2022-06-08 21:16:42','',''),(1598,'21','237','3',1,'Sale Id shift 47',0.00,0.00,0.00,612.76,0.00,'2022-06-08 21:16:42','',''),(1599,'21','237','4',1,'Sale Id shift 47',0.00,0.00,0.00,306.19,0.00,'2022-06-08 21:16:42','',''),(1600,'21','237','4',1,'Sale Id shift 47',0.00,0.00,0.00,671.10,0.00,'2022-06-08 21:16:42','',''),(1601,'21','237','5',2,'Sale Id shift 47',0.00,0.00,0.00,754.01,0.00,'2022-06-08 21:16:42','',''),(1602,'21','237','5',2,'Sale Id shift 47',0.00,0.00,0.00,1061.54,0.00,'2022-06-08 21:16:42','',''),(1603,'21','237','5',2,'Sale Id shift 47',0.00,0.00,0.00,1181.00,0.00,'2022-06-08 21:16:42','',''),(1604,'21','237','5',2,'Sale Id shift 47',0.00,0.00,0.00,2369.87,0.00,'2022-06-08 21:16:42','',''),(1605,'21','237','6',2,'Sale Id shift 47',0.00,0.00,0.00,2527.34,0.00,'2022-06-08 21:16:42','',''),(1606,'21','237','6',2,'Sale Id shift 47',0.00,0.00,0.00,2908.39,0.00,'2022-06-08 21:16:42','',''),(1607,'21','237','6',2,'Sale Id shift 47',0.00,0.00,0.00,1459.09,0.00,'2022-06-08 21:16:42','',''),(1608,'21','237','7',2,'Sale Id shift 47',0.00,0.00,0.00,3157.14,0.00,'2022-06-08 21:16:42','',''),(1609,'21','237','7',2,'Sale Id shift 47',0.00,0.00,0.00,3250.01,0.00,'2022-06-08 21:16:42','',''),(1610,'21','237','1',1,'Sale Id shift 47',0.00,0.00,0.00,1757.80,0.00,'2022-06-08 21:16:42','',''),(1611,'21','237','1',1,'Sale Id shift 47',0.00,0.00,0.00,2.00,0.00,'2022-06-08 21:16:42','',''),(1612,'21','237','1',1,'Sale Id shift 47',0.00,0.00,0.00,1820.79,0.00,'2022-06-08 21:16:42','',''),(1613,'21','237','1',1,'Sale Id shift 47',0.00,0.00,0.00,1914.52,0.00,'2022-06-08 21:16:42','',''),(1614,'21','237','2',1,'Sale Id shift 47',0.00,0.00,0.00,1355.95,0.00,'2022-06-08 21:16:42','',''),(1615,'21','237','2',1,'Sale Id shift 47',0.00,0.00,0.00,2335.58,0.00,'2022-06-08 21:16:42','',''),(1616,'21','237','3',1,'Sale Id shift 47',0.00,0.00,0.00,2235.18,0.00,'2022-06-08 21:16:42','',''),(1617,'21','237','3',1,'Sale Id shift 47',0.00,0.00,0.00,214.22,0.00,'2022-06-08 21:16:42','',''),(1618,'21','237','3',1,'Sale Id shift 47',0.00,0.00,0.00,3849.41,0.00,'2022-06-08 21:16:42','',''),(1619,'21','237','4',1,'Sale Id shift 47',0.00,0.00,0.00,2215.79,0.00,'2022-06-08 21:16:42','',''),(1620,'21','237','4',1,'Sale Id shift 47',0.00,0.00,0.00,1991.26,0.00,'2022-06-08 21:16:42','',''),(1621,'21','237','1',1,'Sale Id shift 47',0.00,0.00,0.00,1096.53,0.00,'2022-06-08 21:16:42','',''),(1622,'21','237','2',1,'Sale Id shift 47',0.00,0.00,0.00,4190.74,0.00,'2022-06-08 21:16:42','',''),(1623,'21','237',NULL,2,'Sale Id shift 47',12134453.50,0.00,0.00,0.00,0.00,'2022-06-08 21:16:42','',''),(1624,'21','237',NULL,1,'Sale Id shift 47',5430740.70,0.00,0.00,0.00,0.00,'2022-06-08 21:16:42','',''),(1625,'21','237','1',1,'Sale Id shift 48',0.00,0.00,0.00,3138.83,0.00,'2022-06-10 11:58:35','',''),(1626,'21','237','2',1,'Sale Id shift 48',0.00,0.00,0.00,791.68,0.00,'2022-06-10 11:58:35','',''),(1627,'21','237','3',1,'Sale Id shift 48',0.00,0.00,0.00,1239.12,0.00,'2022-06-10 11:58:35','',''),(1628,'21','237','4',1,'Sale Id shift 48',0.00,0.00,0.00,1803.33,0.00,'2022-06-10 11:58:35','',''),(1629,'21','237','4',1,'Sale Id shift 48',0.00,0.00,0.00,593.17,0.00,'2022-06-10 11:58:35','',''),(1630,'21','237','5',2,'Sale Id shift 48',0.00,0.00,0.00,2706.79,0.00,'2022-06-10 11:58:35','',''),(1631,'21','237','5',2,'Sale Id shift 48',0.00,0.00,0.00,5156.80,0.00,'2022-06-10 11:58:35','',''),(1632,'21','237','5',2,'Sale Id shift 48',0.00,0.00,0.00,3413.73,0.00,'2022-06-10 11:58:35','',''),(1633,'21','237','5',2,'Sale Id shift 48',0.00,0.00,0.00,4549.56,0.00,'2022-06-10 11:58:35','',''),(1634,'21','237','6',2,'Sale Id shift 48',0.00,0.00,0.00,4026.04,0.00,'2022-06-10 11:58:35','',''),(1635,'21','237','6',2,'Sale Id shift 48',0.00,0.00,0.00,7244.45,0.00,'2022-06-10 11:58:35','',''),(1636,'21','237','6',2,'Sale Id shift 48',0.00,0.00,0.00,4682.53,0.00,'2022-06-10 11:58:35','',''),(1637,'21','237','7',2,'Sale Id shift 48',0.00,0.00,0.00,4521.77,0.00,'2022-06-10 11:58:35','',''),(1638,'21','237','7',2,'Sale Id shift 48',0.00,0.00,0.00,3597.85,0.00,'2022-06-10 11:58:35','',''),(1639,'21','237','1',1,'Sale Id shift 48',0.00,0.00,0.00,1744.92,0.00,'2022-06-10 11:58:35','',''),(1640,'21','237','1',1,'Sale Id shift 48',0.00,0.00,0.00,6766.00,0.00,'2022-06-10 11:58:35','',''),(1641,'21','237','1',1,'Sale Id shift 48',0.00,0.00,0.00,462.46,0.00,'2022-06-10 11:58:35','',''),(1642,'21','237','2',1,'Sale Id shift 48',0.00,0.00,0.00,1549.23,0.00,'2022-06-10 11:58:35','',''),(1643,'21','237','2',1,'Sale Id shift 48',0.00,0.00,0.00,4816.77,0.00,'2022-06-10 11:58:35','',''),(1644,'21','237','3',1,'Sale Id shift 48',0.00,0.00,0.00,1791.15,0.00,'2022-06-10 11:58:35','',''),(1645,'21','237','3',1,'Sale Id shift 48',0.00,0.00,0.00,1874.89,0.00,'2022-06-10 11:58:35','',''),(1646,'21','237','3',1,'Sale Id shift 48',0.00,0.00,0.00,378.30,0.00,'2022-06-10 11:58:35','',''),(1647,'21','237','4',1,'Sale Id shift 48',0.00,0.00,0.00,3136.65,0.00,'2022-06-10 11:58:35','',''),(1648,'21','237','4',1,'Sale Id shift 48',0.00,0.00,0.00,1314.56,0.00,'2022-06-10 11:58:35','',''),(1649,'21','237','1',1,'Sale Id shift 48',0.00,0.00,0.00,1931.39,0.00,'2022-06-10 11:58:35','',''),(1650,'21','237','2',1,'Sale Id shift 48',0.00,0.00,0.00,4155.66,0.00,'2022-06-10 11:58:35','',''),(1651,'21','237',NULL,2,'Sale Id shift 48',25934688.00,0.00,0.00,0.00,0.00,'2022-06-10 11:58:35','',''),(1652,'21','237',NULL,1,'Sale Id shift 48',6185538.15,0.00,0.00,0.00,0.00,'2022-06-10 11:58:35','',''),(1653,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,19500000.00,30000.00,0.00,0.00,'2022-06-10 12:09:21','',''),(1654,'21','237',NULL,2,'Reception corrector for bridging 140',0.00,0.00,0.00,15000.00,0.00,'2022-06-10 12:10:59','',''),(1655,'21','237','6',2,'Received from bridging 140',0.00,0.00,15000.00,0.00,0.00,'2022-06-10 12:10:59','',''),(1656,'21','237',NULL,2,'Reception corrector for bridging 139',0.00,0.00,0.00,15000.00,0.00,'2022-06-10 12:11:52','',''),(1657,'21','237','5',2,'Received from bridging 139',0.00,0.00,15000.00,0.00,0.00,'2022-06-10 12:11:52','',''),(1658,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,29250000.00,45000.00,0.00,0.00,'2022-06-11 06:45:23','',''),(1659,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-11 06:47:20','',''),(1660,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-11 06:48:51','',''),(1661,'21','237',NULL,2,'Reception corrector for bridging 141',0.00,0.00,0.00,15000.00,0.00,'2022-06-11 06:51:15','',''),(1662,'21','237','5',2,'Received from bridging 141',0.00,0.00,15000.00,0.00,0.00,'2022-06-11 06:51:15','',''),(1663,'21','237',NULL,1,'Reception corrector for bridging 143',0.00,0.00,0.00,45000.00,0.00,'2022-06-11 07:25:51','',''),(1664,'21','237','1',1,'Received from bridging 143',0.00,0.00,45000.00,0.00,0.00,'2022-06-11 07:25:51','',''),(1665,'21','237',NULL,1,'Reception corrector for bridging 144',0.00,0.00,0.00,28500.00,0.00,'2022-06-11 07:27:29','',''),(1666,'21','237','3',1,'Received from bridging 144',0.00,0.00,28500.00,0.00,0.00,'2022-06-11 07:27:29','',''),(1667,'21','237',NULL,1,'Reception corrector for bridging 145',0.00,0.00,0.00,16500.00,0.00,'2022-06-11 07:27:42','',''),(1668,'21','237','4',1,'Received from bridging 145',0.00,0.00,16500.00,0.00,0.00,'2022-06-11 07:27:42','',''),(1669,'21','237','1',1,'Sale Id shift 49',0.00,0.00,0.00,3618.29,0.00,'2022-06-11 08:39:00','',''),(1670,'21','237','2',1,'Sale Id shift 49',0.00,0.00,0.00,2552.14,0.00,'2022-06-11 08:39:00','',''),(1671,'21','237','2',1,'Sale Id shift 49',0.00,0.00,0.00,580.90,0.00,'2022-06-11 08:39:00','',''),(1672,'21','237','2',1,'Sale Id shift 49',0.00,0.00,0.00,1016.74,0.00,'2022-06-11 08:39:00','',''),(1673,'21','237','3',1,'Sale Id shift 49',0.00,0.00,0.00,151.88,0.00,'2022-06-11 08:39:00','',''),(1674,'21','237','3',1,'Sale Id shift 49',0.00,0.00,0.00,792.76,0.00,'2022-06-11 08:39:00','',''),(1675,'21','237','4',1,'Sale Id shift 49',0.00,0.00,0.00,953.61,0.00,'2022-06-11 08:39:00','',''),(1676,'21','237','4',1,'Sale Id shift 49',0.00,0.00,0.00,1177.13,0.00,'2022-06-11 08:39:00','',''),(1677,'21','237','5',2,'Sale Id shift 49',0.00,0.00,0.00,6013.71,0.00,'2022-06-11 08:39:00','',''),(1678,'21','237','5',2,'Sale Id shift 49',0.00,0.00,0.00,4562.38,0.00,'2022-06-11 08:39:00','',''),(1679,'21','237','5',2,'Sale Id shift 49',0.00,0.00,0.00,2027.01,0.00,'2022-06-11 08:39:00','',''),(1680,'21','237','5',2,'Sale Id shift 49',0.00,0.00,0.00,3795.85,0.00,'2022-06-11 08:39:00','',''),(1681,'21','237','6',2,'Sale Id shift 49',0.00,0.00,0.00,3671.30,0.00,'2022-06-11 08:39:00','',''),(1682,'21','237','6',2,'Sale Id shift 49',0.00,0.00,0.00,5222.71,0.00,'2022-06-11 08:39:00','',''),(1683,'21','237','6',2,'Sale Id shift 49',0.00,0.00,0.00,7236.55,0.00,'2022-06-11 08:39:00','',''),(1684,'21','237','7',2,'Sale Id shift 49',0.00,0.00,0.00,3705.07,0.00,'2022-06-11 08:39:00','',''),(1685,'21','237','7',2,'Sale Id shift 49',0.00,0.00,0.00,3564.37,0.00,'2022-06-11 08:39:00','',''),(1686,'21','237','1',1,'Sale Id shift 49',0.00,0.00,0.00,39.40,0.00,'2022-06-11 08:39:00','',''),(1687,'21','237','1',1,'Sale Id shift 49',0.00,0.00,0.00,2129.53,0.00,'2022-06-11 08:39:00','',''),(1688,'21','237','1',1,'Sale Id shift 49',0.00,0.00,0.00,5778.57,0.00,'2022-06-11 08:39:00','',''),(1689,'21','237','1',1,'Sale Id shift 49',0.00,0.00,0.00,1890.92,0.00,'2022-06-11 08:39:00','',''),(1690,'21','237','2',1,'Sale Id shift 49',0.00,0.00,0.00,5008.26,0.00,'2022-06-11 08:39:00','',''),(1691,'21','237','2',1,'Sale Id shift 49',0.00,0.00,0.00,915.24,0.00,'2022-06-11 08:39:00','',''),(1692,'21','237','2',1,'Sale Id shift 49',0.00,0.00,0.00,5316.18,0.00,'2022-06-11 08:39:00','',''),(1693,'21','237','3',1,'Sale Id shift 49',0.00,0.00,0.00,206.35,0.00,'2022-06-11 08:39:00','',''),(1694,'21','237','3',1,'Sale Id shift 49',0.00,0.00,0.00,1190.54,0.00,'2022-06-11 08:39:00','',''),(1695,'21','237','4',1,'Sale Id shift 49',0.00,0.00,0.00,1670.05,0.00,'2022-06-11 08:39:00','',''),(1696,'21','237','4',1,'Sale Id shift 49',0.00,0.00,0.00,1863.44,0.00,'2022-06-11 08:39:00','',''),(1697,'21','237','1',1,'Sale Id shift 49',0.00,0.00,0.00,1909.55,0.00,'2022-06-11 08:39:00','',''),(1698,'21','237',NULL,2,'Sale Id shift 49',25869317.50,0.00,0.00,0.00,0.00,'2022-06-11 08:39:00','',''),(1699,'21','237',NULL,1,'Sale Id shift 49',6395644.20,0.00,0.00,0.00,0.00,'2022-06-11 08:39:00','',''),(1700,'21','237',NULL,2,'Reception corrector for bridging 142',0.00,0.00,0.00,30000.00,0.00,'2022-06-11 08:52:45','',''),(1701,'21','237','6',2,'Received from bridging 142',0.00,0.00,30000.00,0.00,0.00,'2022-06-11 08:52:45','',''),(1702,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-11 09:22:21','',''),(1703,'21','237','1',1,'Sale Id shift 50',0.00,0.00,0.00,3122.30,0.00,'2022-06-11 10:07:53','',''),(1704,'21','237','2',1,'Sale Id shift 50',0.00,0.00,0.00,2351.77,0.00,'2022-06-11 10:07:53','',''),(1705,'21','237','3',1,'Sale Id shift 50',0.00,0.00,0.00,2196.95,0.00,'2022-06-11 10:07:53','',''),(1706,'21','237','3',1,'Sale Id shift 50',0.00,0.00,0.00,1713.26,0.00,'2022-06-11 10:07:53','',''),(1707,'21','237','4',1,'Sale Id shift 50',0.00,0.00,0.00,763.12,0.00,'2022-06-11 10:07:53','',''),(1708,'21','237','4',1,'Sale Id shift 50',0.00,0.00,0.00,1673.71,0.00,'2022-06-11 10:07:53','',''),(1709,'21','237','5',2,'Sale Id shift 50',0.00,0.00,0.00,4110.93,0.00,'2022-06-11 10:07:53','',''),(1710,'21','237','5',2,'Sale Id shift 50',0.00,0.00,0.00,2669.59,0.00,'2022-06-11 10:07:53','',''),(1711,'21','237','5',2,'Sale Id shift 50',0.00,0.00,0.00,4127.63,0.00,'2022-06-11 10:07:53','',''),(1712,'21','237','5',2,'Sale Id shift 50',0.00,0.00,0.00,1693.29,0.00,'2022-06-11 10:07:53','',''),(1713,'21','237','6',2,'Sale Id shift 50',0.00,0.00,0.00,1424.31,0.00,'2022-06-11 10:07:53','',''),(1714,'21','237','6',2,'Sale Id shift 50',0.00,0.00,0.00,6506.35,0.00,'2022-06-11 10:07:53','',''),(1715,'21','237','6',2,'Sale Id shift 50',0.00,0.00,0.00,4714.50,0.00,'2022-06-11 10:07:53','',''),(1716,'21','237','7',2,'Sale Id shift 50',0.00,0.00,0.00,2581.07,0.00,'2022-06-11 10:07:53','',''),(1717,'21','237','7',2,'Sale Id shift 50',0.00,0.00,0.00,2904.64,0.00,'2022-06-11 10:07:53','',''),(1718,'21','237','1',1,'Sale Id shift 50',0.00,0.00,0.00,2942.24,0.00,'2022-06-11 10:07:53','',''),(1719,'21','237','1',1,'Sale Id shift 50',0.00,0.00,0.00,3549.18,0.00,'2022-06-11 10:07:53','',''),(1720,'21','237','2',1,'Sale Id shift 50',0.00,0.00,0.00,1785.93,0.00,'2022-06-11 10:07:53','',''),(1721,'21','237','2',1,'Sale Id shift 50',0.00,0.00,0.00,3556.08,0.00,'2022-06-11 10:07:53','',''),(1722,'21','237','3',1,'Sale Id shift 50',0.00,0.00,0.00,3600.83,0.00,'2022-06-11 10:07:53','',''),(1723,'21','237','3',1,'Sale Id shift 50',0.00,0.00,0.00,2547.86,0.00,'2022-06-11 10:07:53','',''),(1724,'21','237','4',1,'Sale Id shift 50',0.00,0.00,0.00,1875.30,0.00,'2022-06-11 10:07:53','',''),(1725,'21','237','4',1,'Sale Id shift 50',0.00,0.00,0.00,1456.82,0.00,'2022-06-11 10:07:53','',''),(1726,'21','237','1',1,'Sale Id shift 50',0.00,0.00,0.00,3743.98,0.00,'2022-06-11 10:07:53','',''),(1727,'21','237','2',1,'Sale Id shift 50',0.00,0.00,0.00,2541.99,0.00,'2022-06-11 10:07:53','',''),(1728,'21','237',NULL,2,'Sale Id shift 50',19976001.50,0.00,0.00,0.00,0.00,'2022-06-11 10:07:53','',''),(1729,'21','237',NULL,1,'Sale Id shift 50',6504517.80,0.00,0.00,0.00,0.00,'2022-06-11 10:07:53','',''),(1730,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,29250000.00,45000.00,0.00,0.00,'2022-06-11 10:12:34','',''),(1731,'21','237',NULL,2,'Reception corrector for bridging 146',0.00,0.00,0.00,15000.00,0.00,'2022-06-11 10:14:25','',''),(1732,'21','237','5',2,'Received from bridging 146',0.00,0.00,15000.00,0.00,0.00,'2022-06-11 10:14:25','',''),(1733,'21','237',NULL,2,'Reception corrector for bridging 148',0.00,0.00,0.00,15000.00,0.00,'2022-06-11 10:15:58','',''),(1734,'21','237','7',2,'Received from bridging 148',0.00,0.00,15000.00,0.00,0.00,'2022-06-11 10:15:58','',''),(1735,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-11 10:25:30','',''),(1736,'21','237',NULL,1,'Reception corrector for bridging 149',0.00,0.00,0.00,45000.00,0.00,'2022-06-11 10:26:44','',''),(1737,'21','237','2',1,'Received from bridging 149',0.00,0.00,45000.00,0.00,0.00,'2022-06-11 10:26:44','',''),(1738,'21','237','1',1,'Sale Id shift 51',0.00,0.00,0.00,2852.41,0.00,'2022-06-11 11:03:42','',''),(1739,'21','237','2',1,'Sale Id shift 51',0.00,0.00,0.00,1986.28,0.00,'2022-06-11 11:03:42','',''),(1740,'21','237','2',1,'Sale Id shift 51',0.00,0.00,0.00,1035.81,0.00,'2022-06-11 11:03:42','',''),(1741,'21','237','2',1,'Sale Id shift 51',0.00,0.00,0.00,1310.40,0.00,'2022-06-11 11:03:42','',''),(1742,'21','237','3',1,'Sale Id shift 51',0.00,0.00,0.00,592.24,0.00,'2022-06-11 11:03:42','',''),(1743,'21','237','3',1,'Sale Id shift 51',0.00,0.00,0.00,1545.83,0.00,'2022-06-11 11:03:42','',''),(1744,'21','237','4',1,'Sale Id shift 51',0.00,0.00,0.00,277.49,0.00,'2022-06-11 11:03:42','',''),(1745,'21','237','5',2,'Sale Id shift 51',0.00,0.00,0.00,3435.10,0.00,'2022-06-11 11:03:42','',''),(1746,'21','237','5',2,'Sale Id shift 51',0.00,0.00,0.00,4515.05,0.00,'2022-06-11 11:03:42','',''),(1747,'21','237','5',2,'Sale Id shift 51',0.00,0.00,0.00,1695.77,0.00,'2022-06-11 11:03:42','',''),(1748,'21','237','5',2,'Sale Id shift 51',0.00,0.00,0.00,5949.56,0.00,'2022-06-11 11:03:42','',''),(1749,'21','237','6',2,'Sale Id shift 51',0.00,0.00,0.00,2360.50,0.00,'2022-06-11 11:03:42','',''),(1750,'21','237','6',2,'Sale Id shift 51',0.00,0.00,0.00,7668.89,0.00,'2022-06-11 11:03:42','',''),(1751,'21','237','6',2,'Sale Id shift 51',0.00,0.00,0.00,3926.12,0.00,'2022-06-11 11:03:42','',''),(1752,'21','237','7',2,'Sale Id shift 51',0.00,0.00,0.00,1813.76,0.00,'2022-06-11 11:03:42','',''),(1753,'21','237','7',2,'Sale Id shift 51',0.00,0.00,0.00,5237.45,0.00,'2022-06-11 11:03:42','',''),(1754,'21','237','1',1,'Sale Id shift 51',0.00,0.00,0.00,2099.21,0.00,'2022-06-11 11:03:42','',''),(1755,'21','237','1',1,'Sale Id shift 51',0.00,0.00,0.00,1839.37,0.00,'2022-06-11 11:03:42','',''),(1756,'21','237','2',1,'Sale Id shift 51',0.00,0.00,0.00,1487.92,0.00,'2022-06-11 11:03:42','',''),(1757,'21','237','2',1,'Sale Id shift 51',0.00,0.00,0.00,1155.27,0.00,'2022-06-11 11:03:42','',''),(1758,'21','237','2',1,'Sale Id shift 51',0.00,0.00,0.00,1493.03,0.00,'2022-06-11 11:03:42','',''),(1759,'21','237','2',1,'Sale Id shift 51',0.00,0.00,0.00,1975.57,0.00,'2022-06-11 11:03:42','',''),(1760,'21','237','3',1,'Sale Id shift 51',0.00,0.00,0.00,1845.38,0.00,'2022-06-11 11:03:42','',''),(1761,'21','237','3',1,'Sale Id shift 51',0.00,0.00,0.00,1931.40,0.00,'2022-06-11 11:03:42','',''),(1762,'21','237','3',1,'Sale Id shift 51',0.00,0.00,0.00,3506.30,0.00,'2022-06-11 11:03:42','',''),(1763,'21','237','4',1,'Sale Id shift 51',0.00,0.00,0.00,2015.49,0.00,'2022-06-11 11:03:42','',''),(1764,'21','237','1',1,'Sale Id shift 51',0.00,0.00,0.00,3301.53,0.00,'2022-06-11 11:03:42','',''),(1765,'21','237','2',1,'Sale Id shift 51',0.00,0.00,0.00,5171.99,0.00,'2022-06-11 11:03:42','',''),(1766,'21','237',NULL,2,'Sale Id shift 51',23791430.00,0.00,0.00,0.00,0.00,'2022-06-11 11:03:42','',''),(1767,'21','237',NULL,1,'Sale Id shift 51',6174781.80,0.00,0.00,0.00,0.00,'2022-06-11 11:03:42','',''),(1768,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,39000000.00,60000.00,0.00,0.00,'2022-06-11 11:04:52','',''),(1769,'21','237',NULL,2,'Reception corrector for bridging 150',0.00,0.00,0.00,30000.00,0.00,'2022-06-11 11:10:47','',''),(1770,'21','237','5',2,'Received from bridging 150',0.00,0.00,30000.00,0.00,0.00,'2022-06-11 11:10:47','',''),(1771,'21','237',NULL,2,'Reception corrector for bridging 151',0.00,0.00,0.00,15000.00,0.00,'2022-06-11 11:11:26','',''),(1772,'21','237','6',2,'Received from bridging 151',0.00,0.00,15000.00,0.00,0.00,'2022-06-11 11:11:26','',''),(1773,'21','237',NULL,2,'Reception corrector for bridging 152',0.00,0.00,0.00,15000.00,0.00,'2022-06-11 11:11:56','',''),(1774,'21','237','7',2,'Received from bridging 152',0.00,0.00,15000.00,0.00,0.00,'2022-06-11 11:11:56','',''),(1775,'21','237','1',1,'Sale Id shift 52',0.00,0.00,0.00,2932.70,0.00,'2022-06-11 12:53:49','',''),(1776,'21','237','2',1,'Sale Id shift 52',0.00,0.00,0.00,1180.04,0.00,'2022-06-11 12:53:49','',''),(1777,'21','237','2',1,'Sale Id shift 52',0.00,0.00,0.00,1630.85,0.00,'2022-06-11 12:53:49','',''),(1778,'21','237','3',1,'Sale Id shift 52',0.00,0.00,0.00,344.62,0.00,'2022-06-11 12:53:49','',''),(1779,'21','237','3',1,'Sale Id shift 52',0.00,0.00,0.00,6.38,0.00,'2022-06-11 12:53:49','',''),(1780,'21','237','4',1,'Sale Id shift 52',0.00,0.00,0.00,1.56,0.00,'2022-06-11 12:53:49','',''),(1781,'21','237','4',1,'Sale Id shift 52',0.00,0.00,0.00,140.97,0.00,'2022-06-11 12:53:49','',''),(1782,'21','237','4',1,'Sale Id shift 52',0.00,0.00,0.00,179.42,0.00,'2022-06-11 12:53:49','',''),(1783,'21','237','1',1,'Sale Id shift 52',0.00,0.00,0.00,2032.86,0.00,'2022-06-11 12:53:49','',''),(1784,'21','237','4',1,'Sale Id shift 52',0.00,0.00,0.00,652.50,0.00,'2022-06-11 12:53:49','',''),(1785,'21','237','5',2,'Sale Id shift 52',0.00,0.00,0.00,2865.52,0.00,'2022-06-11 12:53:49','',''),(1786,'21','237','5',2,'Sale Id shift 52',0.00,0.00,0.00,4162.82,0.00,'2022-06-11 12:53:49','',''),(1787,'21','237','5',2,'Sale Id shift 52',0.00,0.00,0.00,2418.50,0.00,'2022-06-11 12:53:49','',''),(1788,'21','237','5',2,'Sale Id shift 52',0.00,0.00,0.00,2530.06,0.00,'2022-06-11 12:53:49','',''),(1789,'21','237','6',2,'Sale Id shift 52',0.00,0.00,0.00,1452.69,0.00,'2022-06-11 12:53:49','',''),(1790,'21','237','6',2,'Sale Id shift 52',0.00,0.00,0.00,7996.97,0.00,'2022-06-11 12:53:49','',''),(1791,'21','237','6',2,'Sale Id shift 52',0.00,0.00,0.00,3247.44,0.00,'2022-06-11 12:53:49','',''),(1792,'21','237','7',2,'Sale Id shift 52',0.00,0.00,0.00,3219.33,0.00,'2022-06-11 12:53:49','',''),(1793,'21','237','7',2,'Sale Id shift 52',0.00,0.00,0.00,4264.77,0.00,'2022-06-11 12:53:49','',''),(1794,'21','237','1',1,'Sale Id shift 52',0.00,0.00,0.00,335.99,0.00,'2022-06-11 12:53:49','',''),(1795,'21','237','1',1,'Sale Id shift 52',0.00,0.00,0.00,1654.64,0.00,'2022-06-11 12:53:49','',''),(1796,'21','237','1',1,'Sale Id shift 52',0.00,0.00,0.00,1.47,0.00,'2022-06-11 12:53:49','',''),(1797,'21','237','1',1,'Sale Id shift 52',0.00,0.00,0.00,2466.50,0.00,'2022-06-11 12:53:49','',''),(1798,'21','237','1',1,'Sale Id shift 52',0.00,0.00,0.00,1312.70,0.00,'2022-06-11 12:53:49','',''),(1799,'21','237','2',1,'Sale Id shift 52',0.00,0.00,0.00,1636.14,0.00,'2022-06-11 12:53:49','',''),(1800,'21','237','2',1,'Sale Id shift 52',0.00,0.00,0.00,1449.98,0.00,'2022-06-11 12:53:49','',''),(1801,'21','237','2',1,'Sale Id shift 52',0.00,0.00,0.00,900.86,0.00,'2022-06-11 12:53:49','',''),(1802,'21','237','2',1,'Sale Id shift 52',0.00,0.00,0.00,1635.10,0.00,'2022-06-11 12:53:49','',''),(1803,'21','237','3',1,'Sale Id shift 52',0.00,0.00,0.00,1835.02,0.00,'2022-06-11 12:53:49','',''),(1804,'21','237','3',1,'Sale Id shift 52',0.00,0.00,0.00,381.88,0.00,'2022-06-11 12:53:49','',''),(1805,'21','237','3',1,'Sale Id shift 52',0.00,0.00,0.00,1241.14,0.00,'2022-06-11 12:53:49','',''),(1806,'21','237','4',1,'Sale Id shift 52',0.00,0.00,0.00,1838.66,0.00,'2022-06-11 12:53:49','',''),(1807,'21','237','4',1,'Sale Id shift 52',0.00,0.00,0.00,1225.59,0.00,'2022-06-11 12:53:49','',''),(1808,'21','237','4',1,'Sale Id shift 52',0.00,0.00,0.00,2062.82,0.00,'2022-06-11 12:53:49','',''),(1809,'21','237','1',1,'Sale Id shift 52',0.00,0.00,0.00,2475.56,0.00,'2022-06-11 12:53:49','',''),(1810,'21','237','2',1,'Sale Id shift 52',0.00,0.00,0.00,2294.70,0.00,'2022-06-11 12:53:49','',''),(1811,'21','237',NULL,2,'Sale Id shift 52',20902765.00,0.00,0.00,0.00,0.00,'2022-06-11 12:53:49','',''),(1812,'21','237',NULL,1,'Sale Id shift 52',5585357.25,0.00,0.00,0.00,0.00,'2022-06-11 12:53:49','',''),(1813,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,6550500.00,39700.00,0.00,0.00,'2022-06-11 17:46:36','',''),(1814,'21','237',NULL,1,'Reception corrector for bridging 153',0.00,0.00,0.00,40000.00,0.00,'2022-06-11 17:50:49','',''),(1815,'21','237','1',1,'Received from bridging 153',0.00,0.00,40000.00,0.00,0.00,'2022-06-11 17:50:49','',''),(1816,'21','237','1',1,'Sale Id shift 53',0.00,0.00,0.00,2473.37,0.00,'2022-06-12 08:00:10','',''),(1817,'21','237','2',1,'Sale Id shift 53',0.00,0.00,0.00,1099.43,0.00,'2022-06-12 08:00:10','',''),(1818,'21','237','2',1,'Sale Id shift 53',0.00,0.00,0.00,1233.53,0.00,'2022-06-12 08:00:10','',''),(1819,'21','237','2',1,'Sale Id shift 53',0.00,0.00,0.00,710.66,0.00,'2022-06-12 08:00:10','',''),(1820,'21','237','3',1,'Sale Id shift 53',0.00,0.00,0.00,2998.92,0.00,'2022-06-12 08:00:10','',''),(1821,'21','237','4',1,'Sale Id shift 53',0.00,0.00,0.00,1.47,0.00,'2022-06-12 08:00:10','',''),(1822,'21','237','4',1,'Sale Id shift 53',0.00,0.00,0.00,202.18,0.00,'2022-06-12 08:00:10','',''),(1823,'21','237','1',1,'Sale Id shift 53',0.00,0.00,0.00,2849.05,0.00,'2022-06-12 08:00:10','',''),(1824,'21','237','4',1,'Sale Id shift 53',0.00,0.00,0.00,258.33,0.00,'2022-06-12 08:00:10','',''),(1825,'21','237','5',2,'Sale Id shift 53',0.00,0.00,0.00,4798.18,0.00,'2022-06-12 08:00:10','',''),(1826,'21','237','5',2,'Sale Id shift 53',0.00,0.00,0.00,9589.16,0.00,'2022-06-12 08:00:10','',''),(1827,'21','237','5',2,'Sale Id shift 53',0.00,0.00,0.00,5890.86,0.00,'2022-06-12 08:00:10','',''),(1828,'21','237','5',2,'Sale Id shift 53',0.00,0.00,0.00,7089.56,0.00,'2022-06-12 08:00:10','',''),(1829,'21','237','6',2,'Sale Id shift 53',0.00,0.00,0.00,4601.78,0.00,'2022-06-12 08:00:10','',''),(1830,'21','237','6',2,'Sale Id shift 53',0.00,0.00,0.00,7138.45,0.00,'2022-06-12 08:00:10','',''),(1831,'21','237','6',2,'Sale Id shift 53',0.00,0.00,0.00,9821.32,0.00,'2022-06-12 08:00:10','',''),(1832,'21','237','7',2,'Sale Id shift 53',0.00,0.00,0.00,6368.00,0.00,'2022-06-12 08:00:10','',''),(1833,'21','237','7',2,'Sale Id shift 53',0.00,0.00,0.00,9060.25,0.00,'2022-06-12 08:00:10','',''),(1834,'21','237','1',1,'Sale Id shift 53',0.00,0.00,0.00,479.83,0.00,'2022-06-12 08:00:10','',''),(1835,'21','237','1',1,'Sale Id shift 53',0.00,0.00,0.00,1494.10,0.00,'2022-06-12 08:00:10','',''),(1836,'21','237','1',1,'Sale Id shift 53',0.00,0.00,0.00,2892.33,0.00,'2022-06-12 08:00:10','',''),(1837,'21','237','1',1,'Sale Id shift 53',0.00,0.00,0.00,659.40,0.00,'2022-06-12 08:00:10','',''),(1838,'21','237','2',1,'Sale Id shift 53',0.00,0.00,0.00,597.93,0.00,'2022-06-12 08:00:10','',''),(1839,'21','237','2',1,'Sale Id shift 53',0.00,0.00,0.00,1410.78,0.00,'2022-06-12 08:00:10','',''),(1840,'21','237','2',1,'Sale Id shift 53',0.00,0.00,0.00,1287.58,0.00,'2022-06-12 08:00:10','',''),(1841,'21','237','2',1,'Sale Id shift 53',0.00,0.00,0.00,1379.43,0.00,'2022-06-12 08:00:10','',''),(1842,'21','237','3',1,'Sale Id shift 53',0.00,0.00,0.00,550.89,0.00,'2022-06-12 08:00:10','',''),(1843,'21','237','3',1,'Sale Id shift 53',0.00,0.00,0.00,716.22,0.00,'2022-06-12 08:00:10','',''),(1844,'21','237','3',1,'Sale Id shift 53',0.00,0.00,0.00,766.60,0.00,'2022-06-12 08:00:10','',''),(1845,'21','237','3',1,'Sale Id shift 53',0.00,0.00,0.00,817.73,0.00,'2022-06-12 08:00:10','',''),(1846,'21','237','4',1,'Sale Id shift 53',0.00,0.00,0.00,1420.47,0.00,'2022-06-12 08:00:10','',''),(1847,'21','237','4',1,'Sale Id shift 53',0.00,0.00,0.00,1572.49,0.00,'2022-06-12 08:00:10','',''),(1848,'21','237','4',1,'Sale Id shift 53',0.00,0.00,0.00,1558.68,0.00,'2022-06-12 08:00:10','',''),(1849,'21','237','1',1,'Sale Id shift 53',0.00,0.00,0.00,2371.07,0.00,'2022-06-12 08:00:10','',''),(1850,'21','237','2',1,'Sale Id shift 53',0.00,0.00,0.00,2061.85,0.00,'2022-06-12 08:00:10','',''),(1851,'21','237',NULL,2,'Sale Id shift 53',41832414.00,0.00,0.00,0.00,0.00,'2022-06-12 08:00:10','',''),(1852,'21','237',NULL,1,'Sale Id shift 53',5587612.80,0.00,0.00,0.00,0.00,'2022-06-12 08:00:10','',''),(1853,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-12 08:29:32','',''),(1854,'21','237',NULL,1,'Reception corrector for bridging 157',0.00,0.00,0.00,15000.00,0.00,'2022-06-12 08:31:51','',''),(1855,'21','237','3',1,'Received from bridging 157',0.00,0.00,15000.00,0.00,0.00,'2022-06-12 08:31:51','',''),(1856,'21','237',NULL,1,'Reception corrector for bridging 156',0.00,0.00,0.00,30000.00,0.00,'2022-06-12 08:32:14','',''),(1857,'21','237','2',1,'Received from bridging 156',0.00,0.00,30000.00,0.00,0.00,'2022-06-12 08:32:14','',''),(1858,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,32500000.00,50000.00,0.00,0.00,'2022-06-12 08:33:14','',''),(1859,'21','237',NULL,2,'Reception corrector for bridging 158',0.00,0.00,0.00,20000.00,0.00,'2022-06-12 08:38:08','',''),(1860,'21','237','5',2,'Received from bridging 158',0.00,0.00,20000.00,0.00,0.00,'2022-06-12 08:38:08','',''),(1861,'21','237',NULL,2,'Reception corrector for bridging 159',0.00,0.00,0.00,15000.00,0.00,'2022-06-12 08:38:20','',''),(1862,'21','237','6',2,'Received from bridging 159',0.00,0.00,15000.00,0.00,0.00,'2022-06-12 08:38:20','',''),(1863,'21','237',NULL,2,'Reception corrector for bridging 160',0.00,0.00,0.00,15000.00,0.00,'2022-06-12 08:38:40','',''),(1864,'21','237','7',2,'Received from bridging 160',0.00,0.00,15000.00,0.00,0.00,'2022-06-12 08:38:40','',''),(1865,'21','237','1',1,'Sale Id shift 54',0.00,0.00,0.00,3269.02,0.00,'2022-06-12 09:23:50','',''),(1866,'21','237','2',1,'Sale Id shift 54',0.00,0.00,0.00,2149.17,0.00,'2022-06-12 09:23:50','',''),(1867,'21','237','2',1,'Sale Id shift 54',0.00,0.00,0.00,375.66,0.00,'2022-06-12 09:23:50','',''),(1868,'21','237','3',1,'Sale Id shift 54',0.00,0.00,0.00,513.42,0.00,'2022-06-12 09:23:50','',''),(1869,'21','237','1',1,'Sale Id shift 54',0.00,0.00,0.00,2141.14,0.00,'2022-06-12 09:23:50','',''),(1870,'21','237','5',2,'Sale Id shift 54',0.00,0.00,0.00,1331.00,0.00,'2022-06-12 09:23:50','',''),(1871,'21','237','5',2,'Sale Id shift 54',0.00,0.00,0.00,9657.37,0.00,'2022-06-12 09:23:50','',''),(1872,'21','237','5',2,'Sale Id shift 54',0.00,0.00,0.00,2493.85,0.00,'2022-06-12 09:23:50','',''),(1873,'21','237','5',2,'Sale Id shift 54',0.00,0.00,0.00,2536.16,0.00,'2022-06-12 09:23:50','',''),(1874,'21','237','6',2,'Sale Id shift 54',0.00,0.00,0.00,5785.16,0.00,'2022-06-12 09:23:50','',''),(1875,'21','237','6',2,'Sale Id shift 54',0.00,0.00,0.00,8014.56,0.00,'2022-06-12 09:23:50','',''),(1876,'21','237','6',2,'Sale Id shift 54',0.00,0.00,0.00,4796.18,0.00,'2022-06-12 09:23:50','',''),(1877,'21','237','7',2,'Sale Id shift 54',0.00,0.00,0.00,6149.84,0.00,'2022-06-12 09:23:50','',''),(1878,'21','237','7',2,'Sale Id shift 54',0.00,0.00,0.00,5268.52,0.00,'2022-06-12 09:23:50','',''),(1879,'21','237','1',1,'Sale Id shift 54',0.00,0.00,0.00,121.52,0.00,'2022-06-12 09:23:50','',''),(1880,'21','237','1',1,'Sale Id shift 54',0.00,0.00,0.00,1829.77,0.00,'2022-06-12 09:23:50','',''),(1881,'21','237','1',1,'Sale Id shift 54',0.00,0.00,0.00,3675.38,0.00,'2022-06-12 09:23:50','',''),(1882,'21','237','1',1,'Sale Id shift 54',0.00,0.00,0.00,2016.27,0.00,'2022-06-12 09:23:50','',''),(1883,'21','237','2',1,'Sale Id shift 54',0.00,0.00,0.00,2197.21,0.00,'2022-06-12 09:23:50','',''),(1884,'21','237','2',1,'Sale Id shift 54',0.00,0.00,0.00,378.77,0.00,'2022-06-12 09:23:50','',''),(1885,'21','237','2',1,'Sale Id shift 54',0.00,0.00,0.00,1476.82,0.00,'2022-06-12 09:23:50','',''),(1886,'21','237','2',1,'Sale Id shift 54',0.00,0.00,0.00,2043.20,0.00,'2022-06-12 09:23:50','',''),(1887,'21','237','3',1,'Sale Id shift 54',0.00,0.00,0.00,1392.13,0.00,'2022-06-12 09:23:50','',''),(1888,'21','237','3',1,'Sale Id shift 54',0.00,0.00,0.00,1190.47,0.00,'2022-06-12 09:23:50','',''),(1889,'21','237','3',1,'Sale Id shift 54',0.00,0.00,0.00,597.95,0.00,'2022-06-12 09:23:50','',''),(1890,'21','237','4',1,'Sale Id shift 54',0.00,0.00,0.00,1.84,0.00,'2022-06-12 09:23:50','',''),(1891,'21','237','4',1,'Sale Id shift 54',0.00,0.00,0.00,1817.89,0.00,'2022-06-12 09:23:50','',''),(1892,'21','237','4',1,'Sale Id shift 54',0.00,0.00,0.00,2147.27,0.00,'2022-06-12 09:23:50','',''),(1893,'21','237','4',1,'Sale Id shift 54',0.00,0.00,0.00,1910.67,0.00,'2022-06-12 09:23:50','',''),(1894,'21','237','1',1,'Sale Id shift 54',0.00,0.00,0.00,1782.77,0.00,'2022-06-12 09:23:50','',''),(1895,'21','237','2',1,'Sale Id shift 54',0.00,0.00,0.00,2630.94,0.00,'2022-06-12 09:23:50','',''),(1896,'21','237',NULL,2,'Sale Id shift 54',29921216.00,0.00,0.00,0.00,0.00,'2022-06-12 09:23:50','',''),(1897,'21','237',NULL,1,'Sale Id shift 54',5883781.20,0.00,0.00,0.00,0.00,'2022-06-12 09:23:50','',''),(1898,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,29250000.00,45000.00,0.00,0.00,'2022-06-12 09:24:59','',''),(1899,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-06-12 09:27:14','',''),(1900,'21','237',NULL,2,'Reception corrector for bridging 161',0.00,0.00,0.00,15000.00,0.00,'2022-06-12 09:30:22','',''),(1901,'21','237','5',2,'Received from bridging 161',0.00,0.00,15000.00,0.00,0.00,'2022-06-12 09:30:22','',''),(1902,'21','237',NULL,2,'Reception corrector for bridging 162',0.00,0.00,0.00,15000.00,0.00,'2022-06-12 09:30:47','',''),(1903,'21','237','6',2,'Received from bridging 162',0.00,0.00,15000.00,0.00,0.00,'2022-06-12 09:30:47','',''),(1904,'21','237',NULL,2,'Reception corrector for bridging 163',0.00,0.00,0.00,15000.00,0.00,'2022-06-12 09:31:04','',''),(1905,'21','237','7',2,'Received from bridging 163',0.00,0.00,15000.00,0.00,0.00,'2022-06-12 09:31:04','',''),(1906,'21','237',NULL,1,'Reception corrector for bridging 164',0.00,0.00,0.00,32000.00,0.00,'2022-06-12 09:31:19','',''),(1907,'21','237','1',1,'Received from bridging 164',0.00,0.00,32000.00,0.00,0.00,'2022-06-12 09:31:19','',''),(1908,'21','237',NULL,1,'Reception corrector for bridging 165',0.00,0.00,0.00,18000.00,0.00,'2022-06-12 09:31:35','',''),(1909,'21','237','2',1,'Received from bridging 165',0.00,0.00,18000.00,0.00,0.00,'2022-06-12 09:31:35','',''),(1910,'21','237','1',1,'Sale Id shift 55',0.00,0.00,0.00,1731.49,0.00,'2022-06-12 11:02:53','',''),(1911,'21','237','2',1,'Sale Id shift 55',0.00,0.00,0.00,1065.97,0.00,'2022-06-12 11:02:53','',''),(1912,'21','237','3',1,'Sale Id shift 55',0.00,0.00,0.00,358.95,0.00,'2022-06-12 11:02:53','',''),(1913,'21','237','4',1,'Sale Id shift 55',0.00,0.00,0.00,322.15,0.00,'2022-06-12 11:02:53','',''),(1914,'21','237','1',1,'Sale Id shift 55',0.00,0.00,0.00,3339.24,0.00,'2022-06-12 11:02:53','',''),(1915,'21','237','5',2,'Sale Id shift 55',0.00,0.00,0.00,4944.44,0.00,'2022-06-12 11:02:53','',''),(1916,'21','237','5',2,'Sale Id shift 55',0.00,0.00,0.00,7632.25,0.00,'2022-06-12 11:02:53','',''),(1917,'21','237','5',2,'Sale Id shift 55',0.00,0.00,0.00,3689.42,0.00,'2022-06-12 11:02:53','',''),(1918,'21','237','5',2,'Sale Id shift 55',0.00,0.00,0.00,7995.35,0.00,'2022-06-12 11:02:53','',''),(1919,'21','237','6',2,'Sale Id shift 55',0.00,0.00,0.00,4496.01,0.00,'2022-06-12 11:02:53','',''),(1920,'21','237','6',2,'Sale Id shift 55',0.00,0.00,0.00,8504.09,0.00,'2022-06-12 11:02:53','',''),(1921,'21','237','6',2,'Sale Id shift 55',0.00,0.00,0.00,6072.40,0.00,'2022-06-12 11:02:53','',''),(1922,'21','237','7',2,'Sale Id shift 55',0.00,0.00,0.00,4761.34,0.00,'2022-06-12 11:02:53','',''),(1923,'21','237','7',2,'Sale Id shift 55',0.00,0.00,0.00,9401.82,0.00,'2022-06-12 11:02:53','',''),(1924,'21','237','1',1,'Sale Id shift 55',0.00,0.00,0.00,385.62,0.00,'2022-06-12 11:02:53','',''),(1925,'21','237','1',1,'Sale Id shift 55',0.00,0.00,0.00,2012.47,0.00,'2022-06-12 11:02:53','',''),(1926,'21','237','1',1,'Sale Id shift 55',0.00,0.00,0.00,2982.46,0.00,'2022-06-12 11:02:53','',''),(1927,'21','237','1',1,'Sale Id shift 55',0.00,0.00,0.00,804.51,0.00,'2022-06-12 11:02:53','',''),(1928,'21','237','2',1,'Sale Id shift 55',0.00,0.00,0.00,2212.08,0.00,'2022-06-12 11:02:53','',''),(1929,'21','237','2',1,'Sale Id shift 55',0.00,0.00,0.00,792.71,0.00,'2022-06-12 11:02:53','',''),(1930,'21','237','2',1,'Sale Id shift 55',0.00,0.00,0.00,2749.13,0.00,'2022-06-12 11:02:53','',''),(1931,'21','237','2',1,'Sale Id shift 55',0.00,0.00,0.00,379.91,0.00,'2022-06-12 11:02:53','',''),(1932,'21','237','3',1,'Sale Id shift 55',0.00,0.00,0.00,2241.20,0.00,'2022-06-12 11:02:53','',''),(1933,'21','237','3',1,'Sale Id shift 55',0.00,0.00,0.00,1103.96,0.00,'2022-06-12 11:02:53','',''),(1934,'21','237','3',1,'Sale Id shift 55',0.00,0.00,0.00,1140.49,0.00,'2022-06-12 11:02:53','',''),(1935,'21','237','4',1,'Sale Id shift 55',0.00,0.00,0.00,321.25,0.00,'2022-06-12 11:02:53','',''),(1936,'21','237','4',1,'Sale Id shift 55',0.00,0.00,0.00,1955.17,0.00,'2022-06-12 11:02:53','',''),(1937,'21','237','4',1,'Sale Id shift 55',0.00,0.00,0.00,1291.83,0.00,'2022-06-12 11:02:53','',''),(1938,'21','237','4',1,'Sale Id shift 55',0.00,0.00,0.00,1996.88,0.00,'2022-06-12 11:02:53','',''),(1939,'21','237','1',1,'Sale Id shift 55',0.00,0.00,0.00,3675.34,0.00,'2022-06-12 11:02:53','',''),(1940,'21','237','2',1,'Sale Id shift 55',0.00,0.00,0.00,2622.95,0.00,'2022-06-12 11:02:53','',''),(1941,'21','237',NULL,2,'Sale Id shift 55',37373128.00,0.00,0.00,0.00,0.00,'2022-06-12 11:02:53','',''),(1942,'21','237',NULL,1,'Sale Id shift 55',5855150.40,0.00,0.00,0.00,0.00,'2022-06-12 11:02:53','',''),(1943,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-06-18 16:41:41','',''),(1944,'21','237',NULL,1,'Reception corrector for bridging 166',0.00,0.00,0.00,16500.00,0.00,'2022-06-18 16:48:50','',''),(1945,'21','237','1',1,'Received from bridging 166',0.00,0.00,16500.00,0.00,0.00,'2022-06-18 16:48:50','',''),(1946,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,29250000.00,45000.00,0.00,0.00,'2022-06-18 16:49:47','',''),(1947,'21','237',NULL,2,'Reception corrector for bridging 168',0.00,0.00,0.00,30000.00,0.00,'2022-06-18 16:51:56','',''),(1948,'21','237','5',2,'Received from bridging 168',0.00,0.00,30000.00,0.00,0.00,'2022-06-18 16:51:56','',''),(1949,'21','237',NULL,2,'Reception corrector for bridging 169',0.00,0.00,0.00,15000.00,0.00,'2022-06-18 16:52:14','',''),(1950,'21','237','6',2,'Received from bridging 169',0.00,0.00,15000.00,0.00,0.00,'2022-06-18 16:52:14','',''),(1951,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-06-18 16:56:39','',''),(1952,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,969210.00,5874.00,0.00,0.00,'2022-06-18 17:02:43','',''),(1953,'21','237','1',1,'Sale Id shift 57',0.00,0.00,0.00,1354.15,0.00,'2022-06-18 17:51:22','',''),(1954,'21','237','2',1,'Sale Id shift 57',0.00,0.00,0.00,1277.57,0.00,'2022-06-18 17:51:22','',''),(1955,'21','237','2',1,'Sale Id shift 57',0.00,0.00,0.00,72.86,0.00,'2022-06-18 17:51:22','',''),(1956,'21','237','3',1,'Sale Id shift 57',0.00,0.00,0.00,750.71,0.00,'2022-06-18 17:51:22','',''),(1957,'21','237','3',1,'Sale Id shift 57',0.00,0.00,0.00,0.04,0.00,'2022-06-18 17:51:22','',''),(1958,'21','237','3',1,'Sale Id shift 57',0.00,0.00,0.00,627.99,0.00,'2022-06-18 17:51:22','',''),(1959,'21','237','4',1,'Sale Id shift 57',0.00,0.00,0.00,1.18,0.00,'2022-06-18 17:51:22','',''),(1960,'21','237','4',1,'Sale Id shift 57',0.00,0.00,0.00,200.23,0.00,'2022-06-18 17:51:22','',''),(1961,'21','237','1',1,'Sale Id shift 57',0.00,0.00,0.00,3592.15,0.00,'2022-06-18 17:51:22','',''),(1962,'21','237','4',1,'Sale Id shift 57',0.00,0.00,0.00,2093.20,0.00,'2022-06-18 17:51:22','',''),(1963,'21','237','5',2,'Sale Id shift 57',0.00,0.00,0.00,6252.96,0.00,'2022-06-18 17:51:22','',''),(1964,'21','237','5',2,'Sale Id shift 57',0.00,0.00,0.00,6212.90,0.00,'2022-06-18 17:51:22','',''),(1965,'21','237','5',2,'Sale Id shift 57',0.00,0.00,0.00,2518.08,0.00,'2022-06-18 17:51:22','',''),(1966,'21','237','5',2,'Sale Id shift 57',0.00,0.00,0.00,2910.04,0.00,'2022-06-18 17:51:22','',''),(1967,'21','237','6',2,'Sale Id shift 57',0.00,0.00,0.00,4144.26,0.00,'2022-06-18 17:51:22','',''),(1968,'21','237','6',2,'Sale Id shift 57',0.00,0.00,0.00,6331.89,0.00,'2022-06-18 17:51:22','',''),(1969,'21','237','6',2,'Sale Id shift 57',0.00,0.00,0.00,3749.39,0.00,'2022-06-18 17:51:22','',''),(1970,'21','237','7',2,'Sale Id shift 57',0.00,0.00,0.00,3469.48,0.00,'2022-06-18 17:51:22','',''),(1971,'21','237','7',2,'Sale Id shift 57',0.00,0.00,0.00,5006.29,0.00,'2022-06-18 17:51:22','',''),(1972,'21','237','1',1,'Sale Id shift 57',0.00,0.00,0.00,293.05,0.00,'2022-06-18 17:51:22','',''),(1973,'21','237','1',1,'Sale Id shift 57',0.00,0.00,0.00,2545.84,0.00,'2022-06-18 17:51:22','',''),(1974,'21','237','1',1,'Sale Id shift 57',0.00,0.00,0.00,2461.67,0.00,'2022-06-18 17:51:22','',''),(1975,'21','237','1',1,'Sale Id shift 57',0.00,0.00,0.00,1257.34,0.00,'2022-06-18 17:51:22','',''),(1976,'21','237','2',1,'Sale Id shift 57',0.00,0.00,0.00,1608.96,0.00,'2022-06-18 17:51:22','',''),(1977,'21','237','2',1,'Sale Id shift 57',0.00,0.00,0.00,2332.27,0.00,'2022-06-18 17:51:22','',''),(1978,'21','237','2',1,'Sale Id shift 57',0.00,0.00,0.00,2194.48,0.00,'2022-06-18 17:51:22','',''),(1979,'21','237','2',1,'Sale Id shift 57',0.00,0.00,0.00,1317.08,0.00,'2022-06-18 17:51:22','',''),(1980,'21','237','3',1,'Sale Id shift 57',0.00,0.00,0.00,1373.33,0.00,'2022-06-18 17:51:22','',''),(1981,'21','237','3',1,'Sale Id shift 57',0.00,0.00,0.00,1537.33,0.00,'2022-06-18 17:51:22','',''),(1982,'21','237','3',1,'Sale Id shift 57',0.00,0.00,0.00,1540.17,0.00,'2022-06-18 17:51:22','',''),(1983,'21','237','4',1,'Sale Id shift 57',0.00,0.00,0.00,1553.93,0.00,'2022-06-18 17:51:22','',''),(1984,'21','237','4',1,'Sale Id shift 57',0.00,0.00,0.00,1038.70,0.00,'2022-06-18 17:51:22','',''),(1985,'21','237','1',1,'Sale Id shift 57',0.00,0.00,0.00,2081.98,0.00,'2022-06-18 17:51:22','',''),(1986,'21','237','2',1,'Sale Id shift 57',0.00,0.00,0.00,585.51,0.00,'2022-06-18 17:51:22','',''),(1987,'21','237',NULL,2,'Sale Id shift 57',26386938.50,0.00,0.00,0.00,0.00,'2022-06-18 17:51:22','',''),(1988,'21','237',NULL,1,'Sale Id shift 57',5559133.80,0.00,0.00,0.00,0.00,'2022-06-18 17:51:22','',''),(1989,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,32500000.00,50000.00,0.00,0.00,'2022-06-18 18:41:16','',''),(1990,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,32500000.00,50000.00,0.00,0.00,'2022-06-18 18:45:17','',''),(1991,'21','237',NULL,1,'Reception corrector for bridging 170',0.00,0.00,0.00,16500.00,0.00,'2022-06-18 18:46:51','',''),(1992,'21','237','3',1,'Received from bridging 170',0.00,0.00,16500.00,0.00,0.00,'2022-06-18 18:46:51','',''),(1993,'21','237',NULL,2,'Reception corrector for bridging 176',0.00,0.00,0.00,31000.00,0.00,'2022-06-18 18:47:32','',''),(1994,'21','237','7',2,'Received from bridging 176',0.00,0.00,31000.00,0.00,0.00,'2022-06-18 18:47:32','',''),(1995,'21','237',NULL,2,'Reception corrector for bridging 175',0.00,0.00,0.00,19000.00,0.00,'2022-06-18 18:47:54','',''),(1996,'21','237','6',2,'Received from bridging 175',0.00,0.00,19000.00,0.00,0.00,'2022-06-18 18:47:54','',''),(1997,'21','237',NULL,2,'Reception corrector for bridging 174',0.00,0.00,0.00,13000.00,0.00,'2022-06-18 18:48:35','',''),(1998,'21','237','6',2,'Received from bridging 174',0.00,0.00,13000.00,0.00,0.00,'2022-06-18 18:48:35','',''),(1999,'21','237',NULL,1,'Reception corrector for bridging 172',0.00,0.00,0.00,5874.00,0.00,'2022-06-18 18:51:56','',''),(2000,'21','237','3',1,'Received from bridging 172',0.00,0.00,5874.00,0.00,0.00,'2022-06-18 18:51:56','',''),(2001,'21','237',NULL,1,'Reception corrector for bridging 171',0.00,0.00,0.00,33500.00,0.00,'2022-06-18 18:52:46','',''),(2002,'21','237','4',1,'Received from bridging 171',0.00,0.00,33500.00,0.00,0.00,'2022-06-18 18:52:46','',''),(2003,'21','237','1',1,'Sale Id shift 58',0.00,0.00,0.00,2370.37,0.00,'2022-06-18 20:56:52','',''),(2004,'21','237','2',1,'Sale Id shift 58',0.00,0.00,0.00,2629.69,0.00,'2022-06-18 20:56:52','',''),(2005,'21','237','4',1,'Sale Id shift 58',0.00,0.00,0.00,305.10,0.00,'2022-06-18 20:56:52','',''),(2006,'21','237','1',1,'Sale Id shift 58',0.00,0.00,0.00,2806.78,0.00,'2022-06-18 20:56:52','',''),(2007,'21','237','4',1,'Sale Id shift 58',0.00,0.00,0.00,1288.49,0.00,'2022-06-18 20:56:52','',''),(2008,'21','237','5',2,'Sale Id shift 58',0.00,0.00,0.00,3822.82,0.00,'2022-06-18 20:56:52','',''),(2009,'21','237','5',2,'Sale Id shift 58',0.00,0.00,0.00,7137.69,0.00,'2022-06-18 20:56:52','',''),(2010,'21','237','5',2,'Sale Id shift 58',0.00,0.00,0.00,6217.39,0.00,'2022-06-18 20:56:52','',''),(2011,'21','237','5',2,'Sale Id shift 58',0.00,0.00,0.00,7079.47,0.00,'2022-06-18 20:56:52','',''),(2012,'21','237','6',2,'Sale Id shift 58',0.00,0.00,0.00,5069.61,0.00,'2022-06-18 20:56:52','',''),(2013,'21','237','6',2,'Sale Id shift 58',0.00,0.00,0.00,8759.63,0.00,'2022-06-18 20:56:52','',''),(2014,'21','237','6',2,'Sale Id shift 58',0.00,0.00,0.00,5685.66,0.00,'2022-06-18 20:56:52','',''),(2015,'21','237','7',2,'Sale Id shift 58',0.00,0.00,0.00,6110.30,0.00,'2022-06-18 20:56:52','',''),(2016,'21','237','7',2,'Sale Id shift 58',0.00,0.00,0.00,6726.08,0.00,'2022-06-18 20:56:52','',''),(2017,'21','237','1',1,'Sale Id shift 58',0.00,0.00,0.00,1688.63,0.00,'2022-06-18 20:56:52','',''),(2018,'21','237','1',1,'Sale Id shift 58',0.00,0.00,0.00,2857.06,0.00,'2022-06-18 20:56:52','',''),(2019,'21','237','1',1,'Sale Id shift 58',0.00,0.00,0.00,1936.74,0.00,'2022-06-18 20:56:52','',''),(2020,'21','237','2',1,'Sale Id shift 58',0.00,0.00,0.00,1269.87,0.00,'2022-06-18 20:56:52','',''),(2021,'21','237','2',1,'Sale Id shift 58',0.00,0.00,0.00,503.53,0.00,'2022-06-18 20:56:52','',''),(2022,'21','237','2',1,'Sale Id shift 58',0.00,0.00,0.00,3619.84,0.00,'2022-06-18 20:56:52','',''),(2023,'21','237','2',1,'Sale Id shift 58',0.00,0.00,0.00,4177.29,0.00,'2022-06-18 20:56:52','',''),(2024,'21','237','3',1,'Sale Id shift 58',0.00,0.00,0.00,280.80,0.00,'2022-06-18 20:56:52','',''),(2025,'21','237','3',1,'Sale Id shift 58',0.00,0.00,0.00,752.29,0.00,'2022-06-18 20:56:52','',''),(2026,'21','237','4',1,'Sale Id shift 58',0.00,0.00,0.00,2095.10,0.00,'2022-06-18 20:56:52','',''),(2027,'21','237','4',1,'Sale Id shift 58',0.00,0.00,0.00,2421.48,0.00,'2022-06-18 20:56:52','',''),(2028,'21','237','4',1,'Sale Id shift 58',0.00,0.00,0.00,2203.41,0.00,'2022-06-18 20:56:52','',''),(2029,'21','237','4',1,'Sale Id shift 58',0.00,0.00,0.00,2065.65,0.00,'2022-06-18 20:56:52','',''),(2030,'21','237','1',1,'Sale Id shift 58',0.00,0.00,0.00,1968.19,0.00,'2022-06-18 20:56:52','',''),(2031,'21','237','2',1,'Sale Id shift 58',0.00,0.00,0.00,1599.73,0.00,'2022-06-18 20:56:52','',''),(2032,'21','237',NULL,2,'Sale Id shift 58',36795622.50,0.00,0.00,0.00,0.00,'2022-06-18 20:56:52','',''),(2033,'21','237',NULL,1,'Sale Id shift 58',6408606.60,0.00,0.00,0.00,0.00,'2022-06-18 20:56:52','',''),(2034,'21','237',NULL,2,'Reception corrector for bridging 173',0.00,0.00,0.00,37000.00,0.00,'2022-06-18 21:30:25','',''),(2035,'21','237','5',2,'Received from bridging 173',0.00,0.00,37000.00,0.00,0.00,'2022-06-18 21:30:25','',''),(2036,'21','237',NULL,1,'Reception corrector for bridging 167',0.00,0.00,0.00,33500.00,0.00,'2022-06-18 21:32:48','',''),(2037,'21','237','2',1,'Received from bridging 167',0.00,0.00,33500.00,0.00,0.00,'2022-06-18 21:32:48','',''),(2038,'21','237','1',1,'Sale Id shift 59',0.00,0.00,0.00,1700.92,0.00,'2022-06-18 22:08:31','',''),(2039,'21','237','2',1,'Sale Id shift 59',0.00,0.00,0.00,2645.27,0.00,'2022-06-18 22:08:31','',''),(2040,'21','237','2',1,'Sale Id shift 59',0.00,0.00,0.00,160.35,0.00,'2022-06-18 22:08:31','',''),(2041,'21','237','3',1,'Sale Id shift 59',0.00,0.00,0.00,593.19,0.00,'2022-06-18 22:08:31','',''),(2042,'21','237','4',1,'Sale Id shift 59',0.00,0.00,0.00,6.06,0.00,'2022-06-18 22:08:31','',''),(2043,'21','237','5',2,'Sale Id shift 59',0.00,0.00,0.00,3518.06,0.00,'2022-06-18 22:08:31','',''),(2044,'21','237','5',2,'Sale Id shift 59',0.00,0.00,0.00,4049.43,0.00,'2022-06-18 22:08:31','',''),(2045,'21','237','5',2,'Sale Id shift 59',0.00,0.00,0.00,1630.79,0.00,'2022-06-18 22:08:31','',''),(2046,'21','237','5',2,'Sale Id shift 59',0.00,0.00,0.00,6656.76,0.00,'2022-06-18 22:08:31','',''),(2047,'21','237','6',2,'Sale Id shift 59',0.00,0.00,0.00,1751.91,0.00,'2022-06-18 22:08:31','',''),(2048,'21','237','6',2,'Sale Id shift 59',0.00,0.00,0.00,6142.19,0.00,'2022-06-18 22:08:31','',''),(2049,'21','237','6',2,'Sale Id shift 59',0.00,0.00,0.00,3355.22,0.00,'2022-06-18 22:08:31','',''),(2050,'21','237','7',2,'Sale Id shift 59',0.00,0.00,0.00,2245.01,0.00,'2022-06-18 22:08:31','',''),(2051,'21','237','7',2,'Sale Id shift 59',0.00,0.00,0.00,2787.45,0.00,'2022-06-18 22:08:31','',''),(2052,'21','237','1',1,'Sale Id shift 59',0.00,0.00,0.00,2415.92,0.00,'2022-06-18 22:08:31','',''),(2053,'21','237','1',1,'Sale Id shift 59',0.00,0.00,0.00,2121.63,0.00,'2022-06-18 22:08:31','',''),(2054,'21','237','1',1,'Sale Id shift 59',0.00,0.00,0.00,2100.83,0.00,'2022-06-18 22:08:31','',''),(2055,'21','237','2',1,'Sale Id shift 59',0.00,0.00,0.00,2350.71,0.00,'2022-06-18 22:08:31','',''),(2056,'21','237','2',1,'Sale Id shift 59',0.00,0.00,0.00,1252.42,0.00,'2022-06-18 22:08:31','',''),(2057,'21','237','2',1,'Sale Id shift 59',0.00,0.00,0.00,724.47,0.00,'2022-06-18 22:08:31','',''),(2058,'21','237','2',1,'Sale Id shift 59',0.00,0.00,0.00,3437.94,0.00,'2022-06-18 22:08:31','',''),(2059,'21','237','3',1,'Sale Id shift 59',0.00,0.00,0.00,1083.89,0.00,'2022-06-18 22:08:31','',''),(2060,'21','237','3',1,'Sale Id shift 59',0.00,0.00,0.00,892.37,0.00,'2022-06-18 22:08:31','',''),(2061,'21','237','3',1,'Sale Id shift 59',0.00,0.00,0.00,1817.14,0.00,'2022-06-18 22:08:31','',''),(2062,'21','237','4',1,'Sale Id shift 59',0.00,0.00,0.00,1273.73,0.00,'2022-06-18 22:08:31','',''),(2063,'21','237','4',1,'Sale Id shift 59',0.00,0.00,0.00,2597.19,0.00,'2022-06-18 22:08:31','',''),(2064,'21','237','4',1,'Sale Id shift 59',0.00,0.00,0.00,2173.82,0.00,'2022-06-18 22:08:31','',''),(2065,'21','237','4',1,'Sale Id shift 59',0.00,0.00,0.00,2171.06,0.00,'2022-06-18 22:08:31','',''),(2066,'21','237','1',1,'Sale Id shift 59',0.00,0.00,0.00,2189.94,0.00,'2022-06-18 22:08:31','',''),(2067,'21','237','2',1,'Sale Id shift 59',0.00,0.00,0.00,2439.06,0.00,'2022-06-18 22:08:31','',''),(2068,'21','237',NULL,2,'Sale Id shift 59',20888933.00,0.00,0.00,0.00,0.00,'2022-06-18 22:08:31','',''),(2069,'21','237',NULL,1,'Sale Id shift 59',5964405.15,0.00,0.00,0.00,0.00,'2022-06-18 22:08:31','',''),(2070,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,6600000.00,40000.00,0.00,0.00,'2022-06-18 22:23:54','',''),(2071,'21','237',NULL,1,'Reception corrector for bridging 177',0.00,0.00,0.00,40000.00,0.00,'2022-06-21 14:58:08','',''),(2072,'21','237','1',1,'Received from bridging 177',0.00,0.00,40000.00,0.00,0.00,'2022-06-21 14:58:08','',''),(2073,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-22 07:43:00','',''),(2074,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,30600000.00,45000.00,0.00,0.00,'2022-06-22 07:44:07','',''),(2075,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,30600000.00,45000.00,0.00,0.00,'2022-06-22 07:45:24','',''),(2076,'21','237',NULL,2,'Reception corrector for bridging 183',0.00,0.00,0.00,30500.00,0.00,'2022-06-22 07:47:06','',''),(2077,'21','237','7',2,'Received from bridging 183',0.00,0.00,30500.00,0.00,0.00,'2022-06-22 07:47:06','',''),(2078,'21','237',NULL,2,'Reception corrector for bridging 181',0.00,0.00,0.00,500.00,0.00,'2022-06-22 07:48:50','',''),(2079,'21','237','6',2,'Received from bridging 181',0.00,0.00,500.00,0.00,0.00,'2022-06-22 07:48:50','',''),(2080,'21','237',NULL,2,'Reception corrector for bridging 184',0.00,0.00,0.00,30000.00,0.00,'2022-06-22 08:05:21','',''),(2081,'21','237','6',2,'Received from bridging 184',0.00,0.00,30000.00,0.00,0.00,'2022-06-22 08:05:21','',''),(2082,'21','237','1',1,'Sale Id shift 62',0.00,0.00,0.00,1378.79,0.00,'2022-06-22 10:20:51','',''),(2083,'21','237','2',1,'Sale Id shift 62',0.00,0.00,0.00,2055.10,0.00,'2022-06-22 10:20:51','',''),(2084,'21','237','2',1,'Sale Id shift 62',0.00,0.00,0.00,187.48,0.00,'2022-06-22 10:20:51','',''),(2085,'21','237','3',1,'Sale Id shift 62',0.00,0.00,0.00,412.16,0.00,'2022-06-22 10:20:51','',''),(2086,'21','237','3',1,'Sale Id shift 62',0.00,0.00,0.00,7.27,0.00,'2022-06-22 10:20:51','',''),(2087,'21','237','4',1,'Sale Id shift 62',0.00,0.00,0.00,330.35,0.00,'2022-06-22 10:20:51','',''),(2088,'21','237','1',1,'Sale Id shift 62',0.00,0.00,0.00,4494.12,0.00,'2022-06-22 10:20:51','',''),(2089,'21','237','4',1,'Sale Id shift 62',0.00,0.00,0.00,278.96,0.00,'2022-06-22 10:20:51','',''),(2090,'21','237','5',2,'Sale Id shift 62',0.00,0.00,0.00,1679.58,0.00,'2022-06-22 10:20:51','',''),(2091,'21','237','5',2,'Sale Id shift 62',0.00,0.00,0.00,1343.56,0.00,'2022-06-22 10:20:51','',''),(2092,'21','237','5',2,'Sale Id shift 62',0.00,0.00,0.00,1599.50,0.00,'2022-06-22 10:20:51','',''),(2093,'21','237','5',2,'Sale Id shift 62',0.00,0.00,0.00,1678.04,0.00,'2022-06-22 10:20:51','',''),(2094,'21','237','6',2,'Sale Id shift 62',0.00,0.00,0.00,1799.00,0.00,'2022-06-22 10:20:51','',''),(2095,'21','237','6',2,'Sale Id shift 62',0.00,0.00,0.00,3469.38,0.00,'2022-06-22 10:20:51','',''),(2096,'21','237','6',2,'Sale Id shift 62',0.00,0.00,0.00,2927.28,0.00,'2022-06-22 10:20:51','',''),(2097,'21','237','7',2,'Sale Id shift 62',0.00,0.00,0.00,3435.05,0.00,'2022-06-22 10:20:51','',''),(2098,'21','237','7',2,'Sale Id shift 62',0.00,0.00,0.00,1052.88,0.00,'2022-06-22 10:20:51','',''),(2099,'21','237','1',1,'Sale Id shift 62',0.00,0.00,0.00,372.69,0.00,'2022-06-22 10:20:51','',''),(2100,'21','237','1',1,'Sale Id shift 62',0.00,0.00,0.00,1808.79,0.00,'2022-06-22 10:20:51','',''),(2101,'21','237','1',1,'Sale Id shift 62',0.00,0.00,0.00,3411.96,0.00,'2022-06-22 10:20:51','',''),(2102,'21','237','1',1,'Sale Id shift 62',0.00,0.00,0.00,1830.24,0.00,'2022-06-22 10:20:51','',''),(2103,'21','237','2',1,'Sale Id shift 62',0.00,0.00,0.00,1201.35,0.00,'2022-06-22 10:20:51','',''),(2104,'21','237','2',1,'Sale Id shift 62',0.00,0.00,0.00,837.09,0.00,'2022-06-22 10:20:51','',''),(2105,'21','237','2',1,'Sale Id shift 62',0.00,0.00,0.00,1006.63,0.00,'2022-06-22 10:20:51','',''),(2106,'21','237','2',1,'Sale Id shift 62',0.00,0.00,0.00,2966.63,0.00,'2022-06-22 10:20:51','',''),(2107,'21','237','3',1,'Sale Id shift 62',0.00,0.00,0.00,416.02,0.00,'2022-06-22 10:20:51','',''),(2108,'21','237','3',1,'Sale Id shift 62',0.00,0.00,0.00,863.49,0.00,'2022-06-22 10:20:51','',''),(2109,'21','237','3',1,'Sale Id shift 62',0.00,0.00,0.00,1811.14,0.00,'2022-06-22 10:20:51','',''),(2110,'21','237','4',1,'Sale Id shift 62',0.00,0.00,0.00,684.11,0.00,'2022-06-22 10:20:51','',''),(2111,'21','237','4',1,'Sale Id shift 62',0.00,0.00,0.00,1527.73,0.00,'2022-06-22 10:20:51','',''),(2112,'21','237','4',1,'Sale Id shift 62',0.00,0.00,0.00,1787.53,0.00,'2022-06-22 10:20:51','',''),(2113,'21','237','4',1,'Sale Id shift 62',0.00,0.00,0.00,1530.56,0.00,'2022-06-22 10:20:51','',''),(2114,'21','237','1',1,'Sale Id shift 62',0.00,0.00,0.00,2132.76,0.00,'2022-06-22 10:20:51','',''),(2115,'21','237','2',1,'Sale Id shift 62',0.00,0.00,0.00,1340.04,0.00,'2022-06-22 10:20:51','',''),(2116,'21','237',NULL,2,'Sale Id shift 62',13099146.30,0.00,0.00,0.00,0.00,'2022-06-22 10:20:51','',''),(2117,'21','237',NULL,1,'Sale Id shift 62',5721043.35,0.00,0.00,0.00,0.00,'2022-06-22 10:20:51','',''),(2118,'21','237','5',2,'Sale Id shift 64',0.00,0.00,0.00,1961.76,0.00,'2022-06-22 12:00:28','',''),(2119,'21','237','5',2,'Sale Id shift 64',0.00,0.00,0.00,2331.64,0.00,'2022-06-22 12:00:28','',''),(2120,'21','237','5',2,'Sale Id shift 64',0.00,0.00,0.00,1110.00,0.00,'2022-06-22 12:00:28','',''),(2121,'21','237','5',2,'Sale Id shift 64',0.00,0.00,0.00,2745.47,0.00,'2022-06-22 12:00:28','',''),(2122,'21','237','6',2,'Sale Id shift 64',0.00,0.00,0.00,2190.13,0.00,'2022-06-22 12:00:28','',''),(2123,'21','237','6',2,'Sale Id shift 64',0.00,0.00,0.00,4288.52,0.00,'2022-06-22 12:00:28','',''),(2124,'21','237','6',2,'Sale Id shift 64',0.00,0.00,0.00,3495.13,0.00,'2022-06-22 12:00:28','',''),(2125,'21','237','7',2,'Sale Id shift 64',0.00,0.00,0.00,1074.12,0.00,'2022-06-22 12:00:28','',''),(2126,'21','237','7',2,'Sale Id shift 64',0.00,0.00,0.00,2219.53,0.00,'2022-06-22 12:00:28','',''),(2127,'21','237',NULL,2,'Sale Id shift 64',14563084.00,0.00,0.00,0.00,0.00,'2022-06-22 12:00:28','',''),(2128,'21','237',NULL,1,'Reception corrector for bridging 178',0.00,0.00,0.00,15000.00,0.00,'2022-06-22 12:04:58','',''),(2129,'21','237','3',1,'Received from bridging 178',0.00,0.00,15000.00,0.00,0.00,'2022-06-22 12:04:58','',''),(2130,'21','237',NULL,1,'Reception corrector for bridging 179',0.00,0.00,0.00,30000.00,0.00,'2022-06-22 12:05:21','',''),(2131,'21','237','4',1,'Received from bridging 179',0.00,0.00,30000.00,0.00,0.00,'2022-06-22 12:05:21','',''),(2132,'21','237',NULL,2,'Reception corrector for bridging 180',0.00,0.00,0.00,44500.00,0.00,'2022-06-22 12:05:43','',''),(2133,'21','237','5',2,'Received from bridging 180',0.00,0.00,44500.00,0.00,0.00,'2022-06-22 12:05:43','',''),(2134,'21','237','1',1,'Sale Id shift 65',0.00,0.00,0.00,1529.66,0.00,'2022-06-22 13:00:39','',''),(2135,'21','237','2',1,'Sale Id shift 65',0.00,0.00,0.00,593.76,0.00,'2022-06-22 13:00:39','',''),(2136,'21','237','2',1,'Sale Id shift 65',0.00,0.00,0.00,119.70,0.00,'2022-06-22 13:00:39','',''),(2137,'21','237','2',1,'Sale Id shift 65',0.00,0.00,0.00,0.04,0.00,'2022-06-22 13:00:39','',''),(2138,'21','237','3',1,'Sale Id shift 65',0.00,0.00,0.00,241.38,0.00,'2022-06-22 13:00:39','',''),(2139,'21','237','4',1,'Sale Id shift 65',0.00,0.00,0.00,99.05,0.00,'2022-06-22 13:00:39','',''),(2140,'21','237','1',1,'Sale Id shift 65',0.00,0.00,0.00,1957.28,0.00,'2022-06-22 13:00:39','',''),(2141,'21','237','4',1,'Sale Id shift 65',0.00,0.00,0.00,481.49,0.00,'2022-06-22 13:00:39','',''),(2142,'21','237','5',2,'Sale Id shift 65',0.00,0.00,0.00,3212.52,0.00,'2022-06-22 13:00:39','',''),(2143,'21','237','5',2,'Sale Id shift 65',0.00,0.00,0.00,5322.53,0.00,'2022-06-22 13:00:39','',''),(2144,'21','237','5',2,'Sale Id shift 65',0.00,0.00,0.00,3389.75,0.00,'2022-06-22 13:00:39','',''),(2145,'21','237','5',2,'Sale Id shift 65',0.00,0.00,0.00,5275.66,0.00,'2022-06-22 13:00:39','',''),(2146,'21','237','6',2,'Sale Id shift 65',0.00,0.00,0.00,2516.63,0.00,'2022-06-22 13:00:39','',''),(2147,'21','237','6',2,'Sale Id shift 65',0.00,0.00,0.00,4836.48,0.00,'2022-06-22 13:00:39','',''),(2148,'21','237','6',2,'Sale Id shift 65',0.00,0.00,0.00,3981.30,0.00,'2022-06-22 13:00:39','',''),(2149,'21','237','7',2,'Sale Id shift 65',0.00,0.00,0.00,12227.98,0.00,'2022-06-22 13:00:39','',''),(2150,'21','237','7',2,'Sale Id shift 65',0.00,0.00,0.00,12661.22,0.00,'2022-06-22 13:00:39','',''),(2151,'21','237','1',1,'Sale Id shift 65',0.00,0.00,0.00,242.62,0.00,'2022-06-22 13:00:39','',''),(2152,'21','237','1',1,'Sale Id shift 65',0.00,0.00,0.00,1826.96,0.00,'2022-06-22 13:00:40','',''),(2153,'21','237','1',1,'Sale Id shift 65',0.00,0.00,0.00,1031.11,0.00,'2022-06-22 13:00:40','',''),(2154,'21','237','1',1,'Sale Id shift 65',0.00,0.00,0.00,994.70,0.00,'2022-06-22 13:00:40','',''),(2155,'21','237','2',1,'Sale Id shift 65',0.00,0.00,0.00,2048.10,0.00,'2022-06-22 13:00:40','',''),(2156,'21','237','2',1,'Sale Id shift 65',0.00,0.00,0.00,384.56,0.00,'2022-06-22 13:00:40','',''),(2157,'21','237','2',1,'Sale Id shift 65',0.00,0.00,0.00,230.86,0.00,'2022-06-22 13:00:40','',''),(2158,'21','237','2',1,'Sale Id shift 65',0.00,0.00,0.00,3936.95,0.00,'2022-06-22 13:00:40','',''),(2159,'21','237','3',1,'Sale Id shift 65',0.00,0.00,0.00,2859.58,0.00,'2022-06-22 13:00:40','',''),(2160,'21','237','3',1,'Sale Id shift 65',0.00,0.00,0.00,1485.96,0.00,'2022-06-22 13:00:40','',''),(2161,'21','237','3',1,'Sale Id shift 65',0.00,0.00,0.00,2382.28,0.00,'2022-06-22 13:00:40','',''),(2162,'21','237','3',1,'Sale Id shift 65',0.00,0.00,0.00,1600.70,0.00,'2022-06-22 13:00:40','',''),(2163,'21','237','4',1,'Sale Id shift 65',0.00,0.00,0.00,520.59,0.00,'2022-06-22 13:00:40','',''),(2164,'21','237','4',1,'Sale Id shift 65',0.00,0.00,0.00,2233.80,0.00,'2022-06-22 13:00:40','',''),(2165,'21','237','4',1,'Sale Id shift 65',0.00,0.00,0.00,1996.56,0.00,'2022-06-22 13:00:40','',''),(2166,'21','237','4',1,'Sale Id shift 65',0.00,0.00,0.00,2158.16,0.00,'2022-06-22 13:00:40','',''),(2167,'21','237','1',1,'Sale Id shift 65',0.00,0.00,0.00,1753.75,0.00,'2022-06-22 13:00:40','',''),(2168,'21','237','2',1,'Sale Id shift 65',0.00,0.00,0.00,1189.57,0.00,'2022-06-22 13:00:40','',''),(2169,'21','237',NULL,2,'Sale Id shift 65',36328367.60,0.00,0.00,0.00,0.00,'2022-06-22 13:00:40','',''),(2170,'21','237',NULL,1,'Sale Id shift 65',5593363.05,0.00,0.00,0.00,0.00,'2022-06-22 13:00:40','',''),(2171,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-22 14:06:47','',''),(2172,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,40800000.00,60000.00,0.00,0.00,'2022-06-22 14:08:34','',''),(2173,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,20400000.00,30000.00,0.00,0.00,'2022-06-22 14:10:38','',''),(2174,'21','237',NULL,2,'Reception corrector for bridging 188',0.00,0.00,0.00,30000.00,0.00,'2022-06-22 14:11:18','',''),(2175,'21','237','6',2,'Received from bridging 188',0.00,0.00,30000.00,0.00,0.00,'2022-06-22 14:11:18','',''),(2176,'21','237',NULL,1,'Reception corrector for bridging 185',0.00,0.00,0.00,15000.00,0.00,'2022-06-22 14:11:54','',''),(2177,'21','237','1',1,'Received from bridging 185',0.00,0.00,15000.00,0.00,0.00,'2022-06-22 14:11:54','',''),(2178,'21','237',NULL,1,'Reception corrector for bridging 186',0.00,0.00,0.00,30000.00,0.00,'2022-06-22 14:12:24','',''),(2179,'21','237','2',1,'Received from bridging 186',0.00,0.00,30000.00,0.00,0.00,'2022-06-22 14:12:24','',''),(2180,'21','237','1',1,'Sale Id shift 66',0.00,0.00,0.00,2646.59,0.00,'2022-06-22 15:49:24','',''),(2181,'21','237','2',1,'Sale Id shift 66',0.00,0.00,0.00,713.34,0.00,'2022-06-22 15:49:24','',''),(2182,'21','237','2',1,'Sale Id shift 66',0.00,0.00,0.00,298.51,0.00,'2022-06-22 15:49:24','',''),(2183,'21','237','3',1,'Sale Id shift 66',0.00,0.00,0.00,534.17,0.00,'2022-06-22 15:49:24','',''),(2184,'21','237','3',1,'Sale Id shift 66',0.00,0.00,0.00,143.63,0.00,'2022-06-22 15:49:24','',''),(2185,'21','237','4',1,'Sale Id shift 66',0.00,0.00,0.00,245.99,0.00,'2022-06-22 15:49:24','',''),(2186,'21','237','1',1,'Sale Id shift 66',0.00,0.00,0.00,2635.38,0.00,'2022-06-22 15:49:24','',''),(2187,'21','237','4',1,'Sale Id shift 66',0.00,0.00,0.00,491.71,0.00,'2022-06-22 15:49:24','',''),(2188,'21','237','5',2,'Sale Id shift 66',0.00,0.00,0.00,8506.28,0.00,'2022-06-22 15:49:24','',''),(2189,'21','237','5',2,'Sale Id shift 66',0.00,0.00,0.00,5781.77,0.00,'2022-06-22 15:49:24','',''),(2190,'21','237','5',2,'Sale Id shift 66',0.00,0.00,0.00,5708.44,0.00,'2022-06-22 15:49:24','',''),(2191,'21','237','5',2,'Sale Id shift 66',0.00,0.00,0.00,6458.71,0.00,'2022-06-22 15:49:24','',''),(2192,'21','237','6',2,'Sale Id shift 66',0.00,0.00,0.00,3319.02,0.00,'2022-06-22 15:49:24','',''),(2193,'21','237','6',2,'Sale Id shift 66',0.00,0.00,0.00,8128.30,0.00,'2022-06-22 15:49:24','',''),(2194,'21','237','6',2,'Sale Id shift 66',0.00,0.00,0.00,3593.31,0.00,'2022-06-22 15:49:24','',''),(2195,'21','237','7',2,'Sale Id shift 66',0.00,0.00,0.00,8365.76,0.00,'2022-06-22 15:49:24','',''),(2196,'21','237','7',2,'Sale Id shift 66',0.00,0.00,0.00,7316.15,0.00,'2022-06-22 15:49:24','',''),(2197,'21','237','1',1,'Sale Id shift 66',0.00,0.00,0.00,4.85,0.00,'2022-06-22 15:49:24','',''),(2198,'21','237','1',1,'Sale Id shift 66',0.00,0.00,0.00,1971.80,0.00,'2022-06-22 15:49:24','',''),(2199,'21','237','1',1,'Sale Id shift 66',0.00,0.00,0.00,1236.35,0.00,'2022-06-22 15:49:24','',''),(2200,'21','237','1',1,'Sale Id shift 66',0.00,0.00,0.00,799.43,0.00,'2022-06-22 15:49:24','',''),(2201,'21','237','2',1,'Sale Id shift 66',0.00,0.00,0.00,1615.01,0.00,'2022-06-22 15:49:24','',''),(2202,'21','237','2',1,'Sale Id shift 66',0.00,0.00,0.00,843.60,0.00,'2022-06-22 15:49:24','',''),(2203,'21','237','2',1,'Sale Id shift 66',0.00,0.00,0.00,2397.46,0.00,'2022-06-22 15:49:24','',''),(2204,'21','237','3',1,'Sale Id shift 66',0.00,0.00,0.00,2382.65,0.00,'2022-06-22 15:49:24','',''),(2205,'21','237','3',1,'Sale Id shift 66',0.00,0.00,0.00,212.82,0.00,'2022-06-22 15:49:24','',''),(2206,'21','237','3',1,'Sale Id shift 66',0.00,0.00,0.00,1418.40,0.00,'2022-06-22 15:49:24','',''),(2207,'21','237','3',1,'Sale Id shift 66',0.00,0.00,0.00,2140.66,0.00,'2022-06-22 15:49:24','',''),(2208,'21','237','4',1,'Sale Id shift 66',0.00,0.00,0.00,981.59,0.00,'2022-06-22 15:49:24','',''),(2209,'21','237','4',1,'Sale Id shift 66',0.00,0.00,0.00,1387.80,0.00,'2022-06-22 15:49:24','',''),(2210,'21','237','4',1,'Sale Id shift 66',0.00,0.00,0.00,1850.80,0.00,'2022-06-22 15:49:24','',''),(2211,'21','237','4',1,'Sale Id shift 66',0.00,0.00,0.00,234.02,0.00,'2022-06-22 15:49:24','',''),(2212,'21','237','1',1,'Sale Id shift 66',0.00,0.00,0.00,2609.00,0.00,'2022-06-22 15:49:24','',''),(2213,'21','237','2',1,'Sale Id shift 66',0.00,0.00,0.00,1096.43,0.00,'2022-06-22 15:49:24','',''),(2214,'21','237',NULL,2,'Sale Id shift 66',38880863.20,0.00,0.00,0.00,0.00,'2022-06-22 15:49:24','',''),(2215,'21','237',NULL,1,'Sale Id shift 66',5097178.35,0.00,0.00,0.00,0.00,'2022-06-22 15:49:24','',''),(2216,'21','237',NULL,2,'Reception corrector for bridging 187',0.00,0.00,0.00,30000.00,0.00,'2022-06-22 16:19:50','',''),(2217,'21','237','5',2,'Received from bridging 187',0.00,0.00,30000.00,0.00,0.00,'2022-06-22 16:19:50','',''),(2218,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,27200000.00,40000.00,0.00,0.00,'2022-06-22 16:24:28','',''),(2219,'21','237',NULL,2,'Reception corrector for bridging 189',0.00,0.00,0.00,13500.00,0.00,'2022-06-22 16:27:39','',''),(2220,'21','237','5',2,'Received from bridging 189',0.00,0.00,13500.00,0.00,0.00,'2022-06-22 16:27:39','',''),(2221,'21','237',NULL,2,'Reception corrector for bridging 190',0.00,0.00,0.00,13000.00,0.00,'2022-06-22 16:36:44','',''),(2222,'21','237','6',2,'Received from bridging 190',0.00,0.00,13000.00,0.00,0.00,'2022-06-22 16:36:44','',''),(2223,'21','237',NULL,2,'Reception corrector for bridging 191',0.00,0.00,0.00,13500.00,0.00,'2022-06-22 16:37:11','',''),(2224,'21','237','7',2,'Received from bridging 191',0.00,0.00,13500.00,0.00,0.00,'2022-06-22 16:37:11','',''),(2225,'21','237','1',1,'Sale Id shift 67',0.00,0.00,0.00,1897.68,0.00,'2022-06-22 17:54:06','',''),(2226,'21','237','2',1,'Sale Id shift 67',0.00,0.00,0.00,1628.66,0.00,'2022-06-22 17:54:06','',''),(2227,'21','237','2',1,'Sale Id shift 67',0.00,0.00,0.00,164.16,0.00,'2022-06-22 17:54:06','',''),(2228,'21','237','2',1,'Sale Id shift 67',0.00,0.00,0.00,91.67,0.00,'2022-06-22 17:54:06','',''),(2229,'21','237','3',1,'Sale Id shift 67',0.00,0.00,0.00,183.02,0.00,'2022-06-22 17:54:06','',''),(2230,'21','237','3',1,'Sale Id shift 67',0.00,0.00,0.00,25.96,0.00,'2022-06-22 17:54:06','',''),(2231,'21','237','1',1,'Sale Id shift 67',0.00,0.00,0.00,3057.37,0.00,'2022-06-22 17:54:06','',''),(2232,'21','237','5',2,'Sale Id shift 67',0.00,0.00,0.00,3912.16,0.00,'2022-06-22 17:54:06','',''),(2233,'21','237','5',2,'Sale Id shift 67',0.00,0.00,0.00,6925.20,0.00,'2022-06-22 17:54:06','',''),(2234,'21','237','5',2,'Sale Id shift 67',0.00,0.00,0.00,3746.47,0.00,'2022-06-22 17:54:06','',''),(2235,'21','237','5',2,'Sale Id shift 67',0.00,0.00,0.00,7014.28,0.00,'2022-06-22 17:54:06','',''),(2236,'21','237','6',2,'Sale Id shift 67',0.00,0.00,0.00,4916.45,0.00,'2022-06-22 17:54:06','',''),(2237,'21','237','6',2,'Sale Id shift 67',0.00,0.00,0.00,8218.08,0.00,'2022-06-22 17:54:06','',''),(2238,'21','237','6',2,'Sale Id shift 67',0.00,0.00,0.00,8547.83,0.00,'2022-06-22 17:54:06','',''),(2239,'21','237','7',2,'Sale Id shift 67',0.00,0.00,0.00,4879.29,0.00,'2022-06-22 17:54:06','',''),(2240,'21','237','7',2,'Sale Id shift 67',0.00,0.00,0.00,8200.98,0.00,'2022-06-22 17:54:06','',''),(2241,'21','237','1',1,'Sale Id shift 67',0.00,0.00,0.00,394.77,0.00,'2022-06-22 17:54:06','',''),(2242,'21','237','1',1,'Sale Id shift 67',0.00,0.00,0.00,1499.95,0.00,'2022-06-22 17:54:06','',''),(2243,'21','237','1',1,'Sale Id shift 67',0.00,0.00,0.00,2278.73,0.00,'2022-06-22 17:54:06','',''),(2244,'21','237','1',1,'Sale Id shift 67',0.00,0.00,0.00,1278.81,0.00,'2022-06-22 17:54:06','',''),(2245,'21','237','2',1,'Sale Id shift 67',0.00,0.00,0.00,921.41,0.00,'2022-06-22 17:54:06','',''),(2246,'21','237','2',1,'Sale Id shift 67',0.00,0.00,0.00,492.77,0.00,'2022-06-22 17:54:06','',''),(2247,'21','237','2',1,'Sale Id shift 67',0.00,0.00,0.00,563.14,0.00,'2022-06-22 17:54:06','',''),(2248,'21','237','2',1,'Sale Id shift 67',0.00,0.00,0.00,2834.60,0.00,'2022-06-22 17:54:06','',''),(2249,'21','237','3',1,'Sale Id shift 67',0.00,0.00,0.00,1680.58,0.00,'2022-06-22 17:54:06','',''),(2250,'21','237','3',1,'Sale Id shift 67',0.00,0.00,0.00,572.32,0.00,'2022-06-22 17:54:06','',''),(2251,'21','237','3',1,'Sale Id shift 67',0.00,0.00,0.00,2107.95,0.00,'2022-06-22 17:54:06','',''),(2252,'21','237','4',1,'Sale Id shift 67',0.00,0.00,0.00,415.57,0.00,'2022-06-22 17:54:06','',''),(2253,'21','237','4',1,'Sale Id shift 67',0.00,0.00,0.00,1895.11,0.00,'2022-06-22 17:54:06','',''),(2254,'21','237','4',1,'Sale Id shift 67',0.00,0.00,0.00,2062.20,0.00,'2022-06-22 17:54:06','',''),(2255,'21','237','4',1,'Sale Id shift 67',0.00,0.00,0.00,1082.28,0.00,'2022-06-22 17:54:06','',''),(2256,'21','237','1',1,'Sale Id shift 67',0.00,0.00,0.00,3197.70,0.00,'2022-06-22 17:54:06','',''),(2257,'21','237','2',1,'Sale Id shift 67',0.00,0.00,0.00,1711.13,0.00,'2022-06-22 17:54:06','',''),(2258,'21','237',NULL,2,'Sale Id shift 67',38325303.20,0.00,0.00,0.00,0.00,'2022-06-22 17:54:06','',''),(2259,'21','237',NULL,1,'Sale Id shift 67',5286194.10,0.00,0.00,0.00,0.00,'2022-06-22 17:54:06','',''),(2260,'21','237',NULL,2,'Reception corrector for bridging 192',0.00,0.00,0.00,30000.00,0.00,'2022-06-23 06:41:54','',''),(2261,'21','237','7',2,'Received from bridging 192',0.00,0.00,30000.00,0.00,0.00,'2022-06-23 06:41:54','',''),(2262,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,31563560.00,46417.00,0.00,0.00,'2022-06-23 06:45:24','',''),(2263,'21','237',NULL,2,'Reception corrector for bridging 193',0.00,0.00,0.00,31417.00,0.00,'2022-06-23 06:53:19','',''),(2264,'21','237','6',2,'Received from bridging 193',0.00,0.00,31417.00,0.00,0.00,'2022-06-23 06:53:19','',''),(2265,'21','237','1',1,'Sale Id shift 68',0.00,0.00,0.00,792.74,0.00,'2022-06-23 11:40:58','',''),(2266,'21','237','2',1,'Sale Id shift 68',0.00,0.00,0.00,1300.44,0.00,'2022-06-23 11:40:58','',''),(2267,'21','237','2',1,'Sale Id shift 68',0.00,0.00,0.00,1878.27,0.00,'2022-06-23 11:40:58','',''),(2268,'21','237','2',1,'Sale Id shift 68',0.00,0.00,0.00,614.27,0.00,'2022-06-23 11:40:58','',''),(2269,'21','237','3',1,'Sale Id shift 68',0.00,0.00,0.00,646.63,0.00,'2022-06-23 11:40:58','',''),(2270,'21','237','4',1,'Sale Id shift 68',0.00,0.00,0.00,190.95,0.00,'2022-06-23 11:40:58','',''),(2271,'21','237','1',1,'Sale Id shift 68',0.00,0.00,0.00,2827.12,0.00,'2022-06-23 11:40:58','',''),(2272,'21','237','4',1,'Sale Id shift 68',0.00,0.00,0.00,1334.60,0.00,'2022-06-23 11:40:58','',''),(2273,'21','237','5',2,'Sale Id shift 68',0.00,0.00,0.00,1945.14,0.00,'2022-06-23 11:40:58','',''),(2274,'21','237','5',2,'Sale Id shift 68',0.00,0.00,0.00,6803.09,0.00,'2022-06-23 11:40:58','',''),(2275,'21','237','5',2,'Sale Id shift 68',0.00,0.00,0.00,3827.25,0.00,'2022-06-23 11:40:58','',''),(2276,'21','237','5',2,'Sale Id shift 68',0.00,0.00,0.00,5476.18,0.00,'2022-06-23 11:40:58','',''),(2277,'21','237','6',2,'Sale Id shift 68',0.00,0.00,0.00,1924.40,0.00,'2022-06-23 11:40:58','',''),(2278,'21','237','6',2,'Sale Id shift 68',0.00,0.00,0.00,6729.69,0.00,'2022-06-23 11:40:58','',''),(2279,'21','237','6',2,'Sale Id shift 68',0.00,0.00,0.00,5972.27,0.00,'2022-06-23 11:40:58','',''),(2280,'21','237','7',2,'Sale Id shift 68',0.00,0.00,0.00,3663.54,0.00,'2022-06-23 11:40:58','',''),(2281,'21','237','7',2,'Sale Id shift 68',0.00,0.00,0.00,6203.24,0.00,'2022-06-23 11:40:58','',''),(2282,'21','237','1',1,'Sale Id shift 68',0.00,0.00,0.00,1631.08,0.00,'2022-06-23 11:40:58','',''),(2283,'21','237','1',1,'Sale Id shift 68',0.00,0.00,0.00,2773.94,0.00,'2022-06-23 11:40:58','',''),(2284,'21','237','1',1,'Sale Id shift 68',0.00,0.00,0.00,1495.45,0.00,'2022-06-23 11:40:58','',''),(2285,'21','237','2',1,'Sale Id shift 68',0.00,0.00,0.00,786.30,0.00,'2022-06-23 11:40:58','',''),(2286,'21','237','2',1,'Sale Id shift 68',0.00,0.00,0.00,1065.27,0.00,'2022-06-23 11:40:58','',''),(2287,'21','237','2',1,'Sale Id shift 68',0.00,0.00,0.00,1101.09,0.00,'2022-06-23 11:40:58','',''),(2288,'21','237','2',1,'Sale Id shift 68',0.00,0.00,0.00,729.73,0.00,'2022-06-23 11:40:58','',''),(2289,'21','237','3',1,'Sale Id shift 68',0.00,0.00,0.00,895.77,0.00,'2022-06-23 11:40:58','',''),(2290,'21','237','3',1,'Sale Id shift 68',0.00,0.00,0.00,2017.34,0.00,'2022-06-23 11:40:58','',''),(2291,'21','237','3',1,'Sale Id shift 68',0.00,0.00,0.00,1610.82,0.00,'2022-06-23 11:40:58','',''),(2292,'21','237','3',1,'Sale Id shift 68',0.00,0.00,0.00,2224.50,0.00,'2022-06-23 11:40:58','',''),(2293,'21','237','4',1,'Sale Id shift 68',0.00,0.00,0.00,1024.42,0.00,'2022-06-23 11:40:58','',''),(2294,'21','237','4',1,'Sale Id shift 68',0.00,0.00,0.00,1502.56,0.00,'2022-06-23 11:40:58','',''),(2295,'21','237','4',1,'Sale Id shift 68',0.00,0.00,0.00,1246.28,0.00,'2022-06-23 11:40:58','',''),(2296,'21','237','1',1,'Sale Id shift 68',0.00,0.00,0.00,2508.86,0.00,'2022-06-23 11:40:58','',''),(2297,'21','237','2',1,'Sale Id shift 68',0.00,0.00,0.00,1128.90,0.00,'2022-06-23 11:40:58','',''),(2298,'21','237',NULL,2,'Sale Id shift 68',28930464.00,0.00,0.00,0.00,0.00,'2022-06-23 11:40:58','',''),(2299,'21','237',NULL,1,'Sale Id shift 68',5499009.45,0.00,0.00,0.00,0.00,'2022-06-23 11:40:58','',''),(2300,'21','237',NULL,2,'Reception corrector for bridging 194',0.00,0.00,0.00,15000.00,0.00,'2022-06-23 14:09:54','',''),(2301,'21','237','7',2,'Received from bridging 194',0.00,0.00,15000.00,0.00,0.00,'2022-06-23 14:09:54','',''),(2302,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,30600000.00,45000.00,0.00,0.00,'2022-06-24 08:34:56','',''),(2303,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,3993000.00,24200.00,0.00,0.00,'2022-06-24 08:38:30','',''),(2304,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-06-24 08:47:09','',''),(2305,'21','237',NULL,2,'Reception corrector for bridging 195',0.00,0.00,0.00,45000.00,0.00,'2022-06-24 08:47:44','',''),(2306,'21','237','5',2,'Received from bridging 195',0.00,0.00,45000.00,0.00,0.00,'2022-06-24 08:47:44','',''),(2307,'21','237',NULL,1,'Reception corrector for bridging 196',0.00,0.00,0.00,24200.00,0.00,'2022-06-24 08:47:55','',''),(2308,'21','237','3',1,'Received from bridging 196',0.00,0.00,24200.00,0.00,0.00,'2022-06-24 08:47:55','',''),(2309,'21','237',NULL,1,'Reception corrector for bridging 198',0.00,0.00,0.00,45000.00,0.00,'2022-06-24 08:50:08','',''),(2310,'21','237','1',1,'Received from bridging 198',0.00,0.00,45000.00,0.00,0.00,'2022-06-24 08:50:08','',''),(2311,'21','237','1',1,'Sale Id shift 69',0.00,0.00,0.00,1710.42,0.00,'2022-06-24 10:37:09','',''),(2312,'21','237','2',1,'Sale Id shift 69',0.00,0.00,0.00,1548.92,0.00,'2022-06-24 10:37:09','',''),(2313,'21','237','2',1,'Sale Id shift 69',0.00,0.00,0.00,191.44,0.00,'2022-06-24 10:37:09','',''),(2314,'21','237','2',1,'Sale Id shift 69',0.00,0.00,0.00,619.95,0.00,'2022-06-24 10:37:09','',''),(2315,'21','237','4',1,'Sale Id shift 69',0.00,0.00,0.00,81.53,0.00,'2022-06-24 10:37:09','',''),(2316,'21','237','1',1,'Sale Id shift 69',0.00,0.00,0.00,3278.73,0.00,'2022-06-24 10:37:09','',''),(2317,'21','237','5',2,'Sale Id shift 69',0.00,0.00,0.00,2732.77,0.00,'2022-06-24 10:37:09','',''),(2318,'21','237','5',2,'Sale Id shift 69',0.00,0.00,0.00,3261.50,0.00,'2022-06-24 10:37:09','',''),(2319,'21','237','5',2,'Sale Id shift 69',0.00,0.00,0.00,2098.34,0.00,'2022-06-24 10:37:09','',''),(2320,'21','237','5',2,'Sale Id shift 69',0.00,0.00,0.00,7245.86,0.00,'2022-06-24 10:37:09','',''),(2321,'21','237','6',2,'Sale Id shift 69',0.00,0.00,0.00,4061.03,0.00,'2022-06-24 10:37:09','',''),(2322,'21','237','6',2,'Sale Id shift 69',0.00,0.00,0.00,5461.87,0.00,'2022-06-24 10:37:09','',''),(2323,'21','237','6',2,'Sale Id shift 69',0.00,0.00,0.00,4414.28,0.00,'2022-06-24 10:37:09','',''),(2324,'21','237','7',2,'Sale Id shift 69',0.00,0.00,0.00,5177.59,0.00,'2022-06-24 10:37:09','',''),(2325,'21','237','7',2,'Sale Id shift 69',0.00,0.00,0.00,6696.16,0.00,'2022-06-24 10:37:09','',''),(2326,'21','237','1',1,'Sale Id shift 69',0.00,0.00,0.00,247.16,0.00,'2022-06-24 10:37:09','',''),(2327,'21','237','1',1,'Sale Id shift 69',0.00,0.00,0.00,1970.64,0.00,'2022-06-24 10:37:09','',''),(2328,'21','237','1',1,'Sale Id shift 69',0.00,0.00,0.00,2527.58,0.00,'2022-06-24 10:37:09','',''),(2329,'21','237','1',1,'Sale Id shift 69',0.00,0.00,0.00,325.60,0.00,'2022-06-24 10:37:09','',''),(2330,'21','237','2',1,'Sale Id shift 69',0.00,0.00,0.00,1137.60,0.00,'2022-06-24 10:37:09','',''),(2331,'21','237','2',1,'Sale Id shift 69',0.00,0.00,0.00,1138.48,0.00,'2022-06-24 10:37:09','',''),(2332,'21','237','2',1,'Sale Id shift 69',0.00,0.00,0.00,1324.31,0.00,'2022-06-24 10:37:09','',''),(2333,'21','237','2',1,'Sale Id shift 69',0.00,0.00,0.00,2257.48,0.00,'2022-06-24 10:37:09','',''),(2334,'21','237','3',1,'Sale Id shift 69',0.00,0.00,0.00,293.25,0.00,'2022-06-24 10:37:09','',''),(2335,'21','237','3',1,'Sale Id shift 69',0.00,0.00,0.00,2137.13,0.00,'2022-06-24 10:37:09','',''),(2336,'21','237','4',1,'Sale Id shift 69',0.00,0.00,0.00,627.01,0.00,'2022-06-24 10:37:09','',''),(2337,'21','237','4',1,'Sale Id shift 69',0.00,0.00,0.00,880.82,0.00,'2022-06-24 10:37:09','',''),(2338,'21','237','4',1,'Sale Id shift 69',0.00,0.00,0.00,2984.84,0.00,'2022-06-24 10:37:09','',''),(2339,'21','237','4',1,'Sale Id shift 69',0.00,0.00,0.00,1545.57,0.00,'2022-06-24 10:37:09','',''),(2340,'21','237','1',1,'Sale Id shift 69',0.00,0.00,0.00,1413.77,0.00,'2022-06-24 10:37:09','',''),(2341,'21','237','2',1,'Sale Id shift 69',0.00,0.00,0.00,2451.21,0.00,'2022-06-24 10:37:09','',''),(2342,'21','237',NULL,2,'Sale Id shift 69',27981592.00,0.00,0.00,0.00,0.00,'2022-06-24 10:37:09','',''),(2343,'21','237',NULL,1,'Sale Id shift 69',5064417.60,0.00,0.00,0.00,0.00,'2022-06-24 10:37:09','',''),(2344,'21','237','1',1,'Sale Id shift 70',0.00,0.00,0.00,2457.50,0.00,'2022-06-25 09:03:46','',''),(2345,'21','237','2',1,'Sale Id shift 70',0.00,0.00,0.00,2080.70,0.00,'2022-06-25 09:03:46','',''),(2346,'21','237','2',1,'Sale Id shift 70',0.00,0.00,0.00,424.43,0.00,'2022-06-25 09:03:46','',''),(2347,'21','237','2',1,'Sale Id shift 70',0.00,0.00,0.00,1026.61,0.00,'2022-06-25 09:03:46','',''),(2348,'21','237','1',1,'Sale Id shift 70',0.00,0.00,0.00,1501.85,0.00,'2022-06-25 09:03:46','',''),(2349,'21','237','4',1,'Sale Id shift 70',0.00,0.00,0.00,0.03,0.00,'2022-06-25 09:03:46','',''),(2350,'21','237','5',2,'Sale Id shift 70',0.00,0.00,0.00,4797.15,0.00,'2022-06-25 09:03:46','',''),(2351,'21','237','5',2,'Sale Id shift 70',0.00,0.00,0.00,5107.11,0.00,'2022-06-25 09:03:46','',''),(2352,'21','237','5',2,'Sale Id shift 70',0.00,0.00,0.00,3494.19,0.00,'2022-06-25 09:03:46','',''),(2353,'21','237','5',2,'Sale Id shift 70',0.00,0.00,0.00,4246.22,0.00,'2022-06-25 09:03:46','',''),(2354,'21','237','6',2,'Sale Id shift 70',0.00,0.00,0.00,1822.40,0.00,'2022-06-25 09:03:46','',''),(2355,'21','237','6',2,'Sale Id shift 70',0.00,0.00,0.00,4149.83,0.00,'2022-06-25 09:03:46','',''),(2356,'21','237','6',2,'Sale Id shift 70',0.00,0.00,0.00,5033.75,0.00,'2022-06-25 09:03:46','',''),(2357,'21','237','7',2,'Sale Id shift 70',0.00,0.00,0.00,4564.49,0.00,'2022-06-25 09:03:46','',''),(2358,'21','237','7',2,'Sale Id shift 70',0.00,0.00,0.00,7250.23,0.00,'2022-06-25 09:03:46','',''),(2359,'21','237','1',1,'Sale Id shift 70',0.00,0.00,0.00,2584.37,0.00,'2022-06-25 09:03:46','',''),(2360,'21','237','1',1,'Sale Id shift 70',0.00,0.00,0.00,1289.35,0.00,'2022-06-25 09:03:46','',''),(2361,'21','237','2',1,'Sale Id shift 70',0.00,0.00,0.00,50.91,0.00,'2022-06-25 09:03:46','',''),(2362,'21','237','2',1,'Sale Id shift 70',0.00,0.00,0.00,934.15,0.00,'2022-06-25 09:03:46','',''),(2363,'21','237','2',1,'Sale Id shift 70',0.00,0.00,0.00,1890.69,0.00,'2022-06-25 09:03:46','',''),(2364,'21','237','2',1,'Sale Id shift 70',0.00,0.00,0.00,2619.85,0.00,'2022-06-25 09:03:46','',''),(2365,'21','237','3',1,'Sale Id shift 70',0.00,0.00,0.00,1172.70,0.00,'2022-06-25 09:03:46','',''),(2366,'21','237','4',1,'Sale Id shift 70',0.00,0.00,0.00,3033.00,0.00,'2022-06-25 09:03:46','',''),(2367,'21','237','4',1,'Sale Id shift 70',0.00,0.00,0.00,2543.18,0.00,'2022-06-25 09:03:46','',''),(2368,'21','237','4',1,'Sale Id shift 70',0.00,0.00,0.00,2715.95,0.00,'2022-06-25 09:03:46','',''),(2369,'21','237','1',1,'Sale Id shift 70',0.00,0.00,0.00,1834.02,0.00,'2022-06-25 09:03:46','',''),(2370,'21','237','2',1,'Sale Id shift 70',0.00,0.00,0.00,1983.93,0.00,'2022-06-25 09:03:46','',''),(2371,'21','237',NULL,2,'Sale Id shift 70',27516451.60,0.00,0.00,0.00,0.00,'2022-06-25 09:03:46','',''),(2372,'21','237',NULL,1,'Sale Id shift 70',4973631.30,0.00,0.00,0.00,0.00,'2022-06-25 09:03:46','',''),(2373,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,30600000.00,45000.00,0.00,0.00,'2022-06-25 09:22:44','',''),(2374,'21','237',NULL,2,'Reception corrector for bridging 200',0.00,0.00,0.00,3377.00,0.00,'2022-06-25 09:34:48','',''),(2375,'21','237','7',2,'Received from bridging 200',0.00,0.00,3377.00,0.00,0.00,'2022-06-25 09:34:48','',''),(2376,'21','237',NULL,2,'Reception corrector for bridging 199',0.00,0.00,0.00,41623.00,0.00,'2022-06-25 09:35:14','',''),(2377,'21','237','6',2,'Received from bridging 199',0.00,0.00,41623.00,0.00,0.00,'2022-06-25 09:35:14','',''),(2378,'21','237','1',1,'Sale Id shift 71',0.00,0.00,0.00,2380.57,0.00,'2022-07-20 17:37:19','',''),(2379,'21','237','2',1,'Sale Id shift 71',0.00,0.00,0.00,1334.77,0.00,'2022-07-20 17:37:19','',''),(2380,'21','237','2',1,'Sale Id shift 71',0.00,0.00,0.00,653.38,0.00,'2022-07-20 17:37:19','',''),(2381,'21','237','3',1,'Sale Id shift 71',0.00,0.00,0.00,292.27,0.00,'2022-07-20 17:37:19','',''),(2382,'21','237','4',1,'Sale Id shift 71',0.00,0.00,0.00,378.52,0.00,'2022-07-20 17:37:19','',''),(2383,'21','237','4',1,'Sale Id shift 71',0.00,0.00,0.00,219.80,0.00,'2022-07-20 17:37:19','',''),(2384,'21','237','1',1,'Sale Id shift 71',0.00,0.00,0.00,2113.29,0.00,'2022-07-20 17:37:19','',''),(2385,'21','237','5',2,'Sale Id shift 71',0.00,0.00,0.00,3886.10,0.00,'2022-07-20 17:37:19','',''),(2386,'21','237','5',2,'Sale Id shift 71',0.00,0.00,0.00,5380.15,0.00,'2022-07-20 17:37:19','',''),(2387,'21','237','5',2,'Sale Id shift 71',0.00,0.00,0.00,2225.35,0.00,'2022-07-20 17:37:19','',''),(2388,'21','237','5',2,'Sale Id shift 71',0.00,0.00,0.00,3827.22,0.00,'2022-07-20 17:37:19','',''),(2389,'21','237','6',2,'Sale Id shift 71',0.00,0.00,0.00,5345.72,0.00,'2022-07-20 17:37:19','',''),(2390,'21','237','6',2,'Sale Id shift 71',0.00,0.00,0.00,4417.68,0.00,'2022-07-20 17:37:19','',''),(2391,'21','237','6',2,'Sale Id shift 71',0.00,0.00,0.00,4530.50,0.00,'2022-07-20 17:37:19','',''),(2392,'21','237','7',2,'Sale Id shift 71',0.00,0.00,0.00,4269.99,0.00,'2022-07-20 17:37:19','',''),(2393,'21','237','7',2,'Sale Id shift 71',0.00,0.00,0.00,4174.62,0.00,'2022-07-20 17:37:19','',''),(2394,'21','237','1',1,'Sale Id shift 71',0.00,0.00,0.00,79.39,0.00,'2022-07-20 17:37:19','',''),(2395,'21','237','1',1,'Sale Id shift 71',0.00,0.00,0.00,2198.62,0.00,'2022-07-20 17:37:19','',''),(2396,'21','237','1',1,'Sale Id shift 71',0.00,0.00,0.00,3248.60,0.00,'2022-07-20 17:37:19','',''),(2397,'21','237','1',1,'Sale Id shift 71',0.00,0.00,0.00,1249.68,0.00,'2022-07-20 17:37:19','',''),(2398,'21','237','2',1,'Sale Id shift 71',0.00,0.00,0.00,1299.67,0.00,'2022-07-20 17:37:19','',''),(2399,'21','237','2',1,'Sale Id shift 71',0.00,0.00,0.00,1149.47,0.00,'2022-07-20 17:37:19','',''),(2400,'21','237','2',1,'Sale Id shift 71',0.00,0.00,0.00,1188.86,0.00,'2022-07-20 17:37:19','',''),(2401,'21','237','2',1,'Sale Id shift 71',0.00,0.00,0.00,1065.47,0.00,'2022-07-20 17:37:19','',''),(2402,'21','237','3',1,'Sale Id shift 71',0.00,0.00,0.00,1285.11,0.00,'2022-07-20 17:37:19','',''),(2403,'21','237','3',1,'Sale Id shift 71',0.00,0.00,0.00,735.20,0.00,'2022-07-20 17:37:19','',''),(2404,'21','237','3',1,'Sale Id shift 71',0.00,0.00,0.00,2126.27,0.00,'2022-07-20 17:37:19','',''),(2405,'21','237','4',1,'Sale Id shift 71',0.00,0.00,0.00,2020.03,0.00,'2022-07-20 17:37:19','',''),(2406,'21','237','4',1,'Sale Id shift 71',0.00,0.00,0.00,2179.39,0.00,'2022-07-20 17:37:19','',''),(2407,'21','237','4',1,'Sale Id shift 71',0.00,0.00,0.00,1184.51,0.00,'2022-07-20 17:37:19','',''),(2408,'21','237','1',1,'Sale Id shift 71',0.00,0.00,0.00,2726.71,0.00,'2022-07-20 17:37:19','',''),(2409,'21','237','2',1,'Sale Id shift 71',0.00,0.00,0.00,1172.35,0.00,'2022-07-20 17:37:19','',''),(2410,'21','237',NULL,2,'Sale Id shift 71',26640131.00,0.00,0.00,0.00,0.00,'2022-07-20 17:37:19','',''),(2411,'21','237',NULL,1,'Sale Id shift 71',5326518.45,0.00,0.00,0.00,0.00,'2022-07-20 17:37:19','',''),(2412,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,6455790.00,39126.00,0.00,0.00,'2022-07-22 10:51:36','',''),(2413,'21','237',NULL,1,'Reception corrector for bridging 201',0.00,0.00,0.00,39126.00,0.00,'2022-07-22 10:53:03','',''),(2414,'21','237','2',1,'Received from bridging 201',0.00,0.00,39126.00,0.00,0.00,'2022-07-22 10:53:03','',''),(2415,'21','237','1',1,'Sale Id shift 72',0.00,0.00,0.00,446.70,0.00,'2022-07-22 15:26:48','',''),(2416,'21','237','2',1,'Sale Id shift 72',0.00,0.00,0.00,2038.31,0.00,'2022-07-22 15:26:48','',''),(2417,'21','237','2',1,'Sale Id shift 72',0.00,0.00,0.00,516.88,0.00,'2022-07-22 15:26:48','',''),(2418,'21','237','3',1,'Sale Id shift 72',0.00,0.00,0.00,751.78,0.00,'2022-07-22 15:26:48','',''),(2419,'21','237','4',1,'Sale Id shift 72',0.00,0.00,0.00,69.94,0.00,'2022-07-22 15:26:48','',''),(2420,'21','237','4',1,'Sale Id shift 72',0.00,0.00,0.00,72.73,0.00,'2022-07-22 15:26:48','',''),(2421,'21','237','1',1,'Sale Id shift 72',0.00,0.00,0.00,2560.31,0.00,'2022-07-22 15:26:48','',''),(2422,'21','237','4',1,'Sale Id shift 72',0.00,0.00,0.00,182.90,0.00,'2022-07-22 15:26:48','',''),(2423,'21','237','5',2,'Sale Id shift 72',0.00,0.00,0.00,379.27,0.00,'2022-07-22 15:26:48','',''),(2424,'21','237','5',2,'Sale Id shift 72',0.00,0.00,0.00,2350.00,0.00,'2022-07-22 15:26:48','',''),(2425,'21','237','5',2,'Sale Id shift 72',0.00,0.00,0.00,1651.43,0.00,'2022-07-22 15:26:48','',''),(2426,'21','237','5',2,'Sale Id shift 72',0.00,0.00,0.00,3245.73,0.00,'2022-07-22 15:26:48','',''),(2427,'21','237','6',2,'Sale Id shift 72',0.00,0.00,0.00,1039.93,0.00,'2022-07-22 15:26:48','',''),(2428,'21','237','6',2,'Sale Id shift 72',0.00,0.00,0.00,1762.86,0.00,'2022-07-22 15:26:48','',''),(2429,'21','237','6',2,'Sale Id shift 72',0.00,0.00,0.00,2049.56,0.00,'2022-07-22 15:26:48','',''),(2430,'21','237','7',2,'Sale Id shift 72',0.00,0.00,0.00,2152.01,0.00,'2022-07-22 15:26:48','',''),(2431,'21','237','7',2,'Sale Id shift 72',0.00,0.00,0.00,1552.29,0.00,'2022-07-22 15:26:48','',''),(2432,'21','237','1',1,'Sale Id shift 72',0.00,0.00,0.00,430.00,0.00,'2022-07-22 15:26:48','',''),(2433,'21','237','1',1,'Sale Id shift 72',0.00,0.00,0.00,1941.01,0.00,'2022-07-22 15:26:48','',''),(2434,'21','237','1',1,'Sale Id shift 72',0.00,0.00,0.00,2332.34,0.00,'2022-07-22 15:26:48','',''),(2435,'21','237','1',1,'Sale Id shift 72',0.00,0.00,0.00,778.75,0.00,'2022-07-22 15:26:48','',''),(2436,'21','237','2',1,'Sale Id shift 72',0.00,0.00,0.00,1696.60,0.00,'2022-07-22 15:26:48','',''),(2437,'21','237','2',1,'Sale Id shift 72',0.00,0.00,0.00,342.85,0.00,'2022-07-22 15:26:48','',''),(2438,'21','237','2',1,'Sale Id shift 72',0.00,0.00,0.00,1501.35,0.00,'2022-07-22 15:26:48','',''),(2439,'21','237','2',1,'Sale Id shift 72',0.00,0.00,0.00,1941.83,0.00,'2022-07-22 15:26:48','',''),(2440,'21','237','3',1,'Sale Id shift 72',0.00,0.00,0.00,1444.14,0.00,'2022-07-22 15:26:48','',''),(2441,'21','237','3',1,'Sale Id shift 72',0.00,0.00,0.00,333.68,0.00,'2022-07-22 15:26:48','',''),(2442,'21','237','3',1,'Sale Id shift 72',0.00,0.00,0.00,1097.43,0.00,'2022-07-22 15:26:48','',''),(2443,'21','237','3',1,'Sale Id shift 72',0.00,0.00,0.00,641.15,0.00,'2022-07-22 15:26:48','',''),(2444,'21','237','4',1,'Sale Id shift 72',0.00,0.00,0.00,727.18,0.00,'2022-07-22 15:26:48','',''),(2445,'21','237','4',1,'Sale Id shift 72',0.00,0.00,0.00,1071.43,0.00,'2022-07-22 15:26:48','',''),(2446,'21','237','4',1,'Sale Id shift 72',0.00,0.00,0.00,1723.27,0.00,'2022-07-22 15:26:48','',''),(2447,'21','237','4',1,'Sale Id shift 72',0.00,0.00,0.00,1233.19,0.00,'2022-07-22 15:26:48','',''),(2448,'21','237','1',1,'Sale Id shift 72',0.00,0.00,0.00,2261.38,0.00,'2022-07-22 15:26:48','',''),(2449,'21','237','2',1,'Sale Id shift 72',0.00,0.00,0.00,2191.34,0.00,'2022-07-22 15:26:48','',''),(2450,'21','237',NULL,2,'Sale Id shift 72',11328156.00,0.00,0.00,0.00,0.00,'2022-07-22 15:26:48','',''),(2451,'21','237',NULL,1,'Sale Id shift 72',5004197.55,0.00,0.00,0.00,0.00,'2022-07-22 15:26:48','',''),(2452,'21','237','1',0,'Tank level zero out for dipping',0.00,0.00,0.00,6334.20,0.00,'2022-07-24 13:47:07','',''),(2453,'21','237','1',0,'Inventory adjustment from tank dipping to 8800',0.00,0.00,8800.00,0.00,0.00,'2022-07-24 13:47:07','',''),(2454,'21','237','2',0,'Tank level zero out for dipping',0.00,0.00,0.00,30210.33,0.00,'2022-07-24 13:47:42','',''),(2455,'21','237','2',0,'Inventory adjustment from tank dipping to 30200',0.00,0.00,30200.00,0.00,0.00,'2022-07-24 13:47:42','',''),(2456,'21','237','3',0,'Tank level zero out for dipping',0.00,0.00,0.00,39030.54,0.00,'2022-07-24 13:48:07','',''),(2457,'21','237','3',0,'Inventory adjustment from tank dipping to 39600',0.00,0.00,39600.00,0.00,0.00,'2022-07-24 13:48:07','',''),(2458,'21','237','4',0,'Tank level zero out for dipping',0.00,0.00,0.00,4321.52,0.00,'2022-07-24 13:48:41','',''),(2459,'21','237','4',0,'Inventory adjustment from tank dipping to 7200',0.00,0.00,7200.00,0.00,0.00,'2022-07-24 13:48:41','',''),(2460,'21','237','5',0,'Tank level zero out for dipping',0.00,0.00,0.00,492.32,0.00,'2022-07-24 13:49:06','',''),(2461,'21','237','5',0,'Inventory adjustment from tank dipping to 2700',0.00,0.00,2700.00,0.00,0.00,'2022-07-24 13:49:06','',''),(2462,'21','237','6',0,'Tank level zero out for dipping',0.00,0.00,0.00,25870.95,0.00,'2022-07-24 13:49:31','',''),(2463,'21','237','6',0,'Inventory adjustment from tank dipping to 3300',0.00,0.00,3300.00,0.00,0.00,'2022-07-24 13:49:31','',''),(2464,'21','237','7',0,'Tank level zero out for dipping',0.00,0.00,0.00,17242.04,0.00,'2022-07-24 13:50:17','',''),(2465,'21','237','7',0,'Inventory adjustment from tank dipping to 1700',0.00,0.00,1700.00,0.00,0.00,'2022-07-24 13:50:17','',''),(2466,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8184000.00,49600.00,0.00,0.00,'2022-07-25 17:56:34','',''),(2467,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,40336100.00,57623.00,0.00,0.00,'2022-07-25 18:39:54','',''),(2468,'21','237',NULL,2,'Reception corrector for bridging 205',0.00,0.00,0.00,16000.00,0.00,'2022-07-25 18:45:45','',''),(2469,'21','237','7',2,'Received from bridging 205',0.00,0.00,16000.00,0.00,0.00,'2022-07-25 18:45:45','',''),(2470,'21','237',NULL,2,'Reception corrector for bridging 204',0.00,0.00,0.00,41623.00,0.00,'2022-07-25 18:46:00','',''),(2471,'21','237','6',2,'Received from bridging 204',0.00,0.00,41623.00,0.00,0.00,'2022-07-25 18:46:00','',''),(2472,'21','237',NULL,1,'Reception corrector for bridging 203',0.00,0.00,0.00,15000.00,0.00,'2022-07-25 18:46:21','',''),(2473,'21','237','4',1,'Received from bridging 203',0.00,0.00,15000.00,0.00,0.00,'2022-07-25 18:46:21','',''),(2474,'21','237',NULL,1,'Reception corrector for bridging 202',0.00,0.00,0.00,30000.00,0.00,'2022-07-25 18:46:36','',''),(2475,'21','237','1',1,'Received from bridging 202',0.00,0.00,30000.00,0.00,0.00,'2022-07-25 18:46:36','',''),(2476,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,31500000.00,45000.00,0.00,0.00,'2022-07-25 18:50:37','',''),(2477,'21','237',NULL,2,'Reception corrector for bridging 206',0.00,0.00,0.00,45000.00,0.00,'2022-07-25 18:52:16','',''),(2478,'21','237','5',2,'Received from bridging 206',0.00,0.00,45000.00,0.00,0.00,'2022-07-25 18:52:16','',''),(2479,'21','237','1',1,'Sale Id shift 73',0.00,0.00,0.00,1968.36,0.00,'2022-07-26 21:34:33','',''),(2480,'21','237','2',1,'Sale Id shift 73',0.00,0.00,0.00,138.65,0.00,'2022-07-26 21:34:33','',''),(2481,'21','237','2',1,'Sale Id shift 73',0.00,0.00,0.00,735.79,0.00,'2022-07-26 21:34:33','',''),(2482,'21','237','3',1,'Sale Id shift 73',0.00,0.00,0.00,381.37,0.00,'2022-07-26 21:34:33','',''),(2483,'21','237','4',1,'Sale Id shift 73',0.00,0.00,0.00,15.15,0.00,'2022-07-26 21:34:33','',''),(2484,'21','237','1',1,'Sale Id shift 73',0.00,0.00,0.00,2355.23,0.00,'2022-07-26 21:34:33','',''),(2485,'21','237','4',1,'Sale Id shift 73',0.00,0.00,0.00,343.63,0.00,'2022-07-26 21:34:33','',''),(2486,'21','237','5',2,'Sale Id shift 73',0.00,0.00,0.00,1930.00,0.00,'2022-07-26 21:34:33','',''),(2487,'21','237','5',2,'Sale Id shift 73',0.00,0.00,0.00,2552.67,0.00,'2022-07-26 21:34:33','',''),(2488,'21','237','5',2,'Sale Id shift 73',0.00,0.00,0.00,1398.14,0.00,'2022-07-26 21:34:33','',''),(2489,'21','237','5',2,'Sale Id shift 73',0.00,0.00,0.00,2722.10,0.00,'2022-07-26 21:34:33','',''),(2490,'21','237','6',2,'Sale Id shift 73',0.00,0.00,0.00,3279.96,0.00,'2022-07-26 21:34:33','',''),(2491,'21','237','6',2,'Sale Id shift 73',0.00,0.00,0.00,3306.13,0.00,'2022-07-26 21:34:33','',''),(2492,'21','237','6',2,'Sale Id shift 73',0.00,0.00,0.00,3135.03,0.00,'2022-07-26 21:34:33','',''),(2493,'21','237','7',2,'Sale Id shift 73',0.00,0.00,0.00,5896.87,0.00,'2022-07-26 21:34:33','',''),(2494,'21','237','7',2,'Sale Id shift 73',0.00,0.00,0.00,5318.44,0.00,'2022-07-26 21:34:33','',''),(2495,'21','237','1',1,'Sale Id shift 73',0.00,0.00,0.00,359.10,0.00,'2022-07-26 21:34:33','',''),(2496,'21','237','1',1,'Sale Id shift 73',0.00,0.00,0.00,928.13,0.00,'2022-07-26 21:34:33','',''),(2497,'21','237','1',1,'Sale Id shift 73',0.00,0.00,0.00,2340.57,0.00,'2022-07-26 21:34:33','',''),(2498,'21','237','1',1,'Sale Id shift 73',0.00,0.00,0.00,990.55,0.00,'2022-07-26 21:34:33','',''),(2499,'21','237','2',1,'Sale Id shift 73',0.00,0.00,0.00,1364.66,0.00,'2022-07-26 21:34:33','',''),(2500,'21','237','2',1,'Sale Id shift 73',0.00,0.00,0.00,556.42,0.00,'2022-07-26 21:34:33','',''),(2501,'21','237','2',1,'Sale Id shift 73',0.00,0.00,0.00,1130.68,0.00,'2022-07-26 21:34:33','',''),(2502,'21','237','2',1,'Sale Id shift 73',0.00,0.00,0.00,1342.46,0.00,'2022-07-26 21:34:33','',''),(2503,'21','237','3',1,'Sale Id shift 73',0.00,0.00,0.00,1016.05,0.00,'2022-07-26 21:34:33','',''),(2504,'21','237','3',1,'Sale Id shift 73',0.00,0.00,0.00,1021.81,0.00,'2022-07-26 21:34:33','',''),(2505,'21','237','3',1,'Sale Id shift 73',0.00,0.00,0.00,1328.23,0.00,'2022-07-26 21:34:33','',''),(2506,'21','237','4',1,'Sale Id shift 73',0.00,0.00,0.00,938.48,0.00,'2022-07-26 21:34:33','',''),(2507,'21','237','4',1,'Sale Id shift 73',0.00,0.00,0.00,1495.32,0.00,'2022-07-26 21:34:33','',''),(2508,'21','237','4',1,'Sale Id shift 73',0.00,0.00,0.00,1202.92,0.00,'2022-07-26 21:34:33','',''),(2509,'21','237','4',1,'Sale Id shift 73',0.00,0.00,0.00,1541.48,0.00,'2022-07-26 21:34:33','',''),(2510,'21','237','1',1,'Sale Id shift 73',0.00,0.00,0.00,944.61,0.00,'2022-07-26 21:34:33','',''),(2511,'21','237','2',1,'Sale Id shift 73',0.00,0.00,0.00,1697.06,0.00,'2022-07-26 21:34:33','',''),(2512,'21','237',NULL,2,'Sale Id shift 73',20677538.00,0.00,0.00,0.00,0.00,'2022-07-26 21:34:33','',''),(2513,'21','237',NULL,1,'Sale Id shift 73',4312557.15,0.00,0.00,0.00,0.00,'2022-07-26 21:34:33','',''),(2514,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,10500000.00,15000.00,0.00,0.00,'2022-07-27 14:56:41','',''),(2515,'21','237',NULL,2,'Reception corrector for bridging 208',0.00,0.00,0.00,15000.00,0.00,'2022-07-27 14:59:09','',''),(2516,'21','237','7',2,'Received from bridging 208',0.00,0.00,15000.00,0.00,0.00,'2022-07-27 14:59:09','',''),(2517,'21','237','1',1,'Sale Id shift 74',0.00,0.00,0.00,1595.40,0.00,'2022-07-27 16:24:38','',''),(2518,'21','237','2',1,'Sale Id shift 74',0.00,0.00,0.00,1716.28,0.00,'2022-07-27 16:24:38','',''),(2519,'21','237','2',1,'Sale Id shift 74',0.00,0.00,0.00,431.61,0.00,'2022-07-27 16:24:38','',''),(2520,'21','237','3',1,'Sale Id shift 74',0.00,0.00,0.00,1401.90,0.00,'2022-07-27 16:24:38','',''),(2521,'21','237','1',1,'Sale Id shift 74',0.00,0.00,0.00,2961.19,0.00,'2022-07-27 16:24:38','',''),(2522,'21','237','4',1,'Sale Id shift 74',0.00,0.00,0.00,221.49,0.00,'2022-07-27 16:24:38','',''),(2523,'21','237','5',2,'Sale Id shift 74',0.00,0.00,0.00,4377.66,0.00,'2022-07-27 16:24:38','',''),(2524,'21','237','5',2,'Sale Id shift 74',0.00,0.00,0.00,3750.51,0.00,'2022-07-27 16:24:38','',''),(2525,'21','237','5',2,'Sale Id shift 74',0.00,0.00,0.00,3567.15,0.00,'2022-07-27 16:24:38','',''),(2526,'21','237','5',2,'Sale Id shift 74',0.00,0.00,0.00,2841.37,0.00,'2022-07-27 16:24:38','',''),(2527,'21','237','6',2,'Sale Id shift 74',0.00,0.00,0.00,4687.86,0.00,'2022-07-27 16:24:38','',''),(2528,'21','237','6',2,'Sale Id shift 74',0.00,0.00,0.00,3788.32,0.00,'2022-07-27 16:24:38','',''),(2529,'21','237','6',2,'Sale Id shift 74',0.00,0.00,0.00,6671.14,0.00,'2022-07-27 16:24:38','',''),(2530,'21','237','7',2,'Sale Id shift 74',0.00,0.00,0.00,3981.83,0.00,'2022-07-27 16:24:38','',''),(2531,'21','237','7',2,'Sale Id shift 74',0.00,0.00,0.00,5776.22,0.00,'2022-07-27 16:24:38','',''),(2532,'21','237','1',1,'Sale Id shift 74',0.00,0.00,0.00,1217.79,0.00,'2022-07-27 16:24:38','',''),(2533,'21','237','1',1,'Sale Id shift 74',0.00,0.00,0.00,2026.62,0.00,'2022-07-27 16:24:38','',''),(2534,'21','237','1',1,'Sale Id shift 74',0.00,0.00,0.00,583.84,0.00,'2022-07-27 16:24:38','',''),(2535,'21','237','1',1,'Sale Id shift 74',0.00,0.00,0.00,1198.89,0.00,'2022-07-27 16:24:38','',''),(2536,'21','237','2',1,'Sale Id shift 74',0.00,0.00,0.00,2443.64,0.00,'2022-07-27 16:24:38','',''),(2537,'21','237','2',1,'Sale Id shift 74',0.00,0.00,0.00,614.63,0.00,'2022-07-27 16:24:38','',''),(2538,'21','237','2',1,'Sale Id shift 74',0.00,0.00,0.00,311.77,0.00,'2022-07-27 16:24:38','',''),(2539,'21','237','2',1,'Sale Id shift 74',0.00,0.00,0.00,2841.91,0.00,'2022-07-27 16:24:38','',''),(2540,'21','237','3',1,'Sale Id shift 74',0.00,0.00,0.00,988.47,0.00,'2022-07-27 16:24:38','',''),(2541,'21','237','3',1,'Sale Id shift 74',0.00,0.00,0.00,1216.69,0.00,'2022-07-27 16:24:38','',''),(2542,'21','237','3',1,'Sale Id shift 74',0.00,0.00,0.00,853.28,0.00,'2022-07-27 16:24:38','',''),(2543,'21','237','3',1,'Sale Id shift 74',0.00,0.00,0.00,1226.70,0.00,'2022-07-27 16:24:38','',''),(2544,'21','237','4',1,'Sale Id shift 74',0.00,0.00,0.00,826.28,0.00,'2022-07-27 16:24:38','',''),(2545,'21','237','4',1,'Sale Id shift 74',0.00,0.00,0.00,79.08,0.00,'2022-07-27 16:24:38','',''),(2546,'21','237','4',1,'Sale Id shift 74',0.00,0.00,0.00,593.82,0.00,'2022-07-27 16:24:38','',''),(2547,'21','237','4',1,'Sale Id shift 74',0.00,0.00,0.00,354.08,0.00,'2022-07-27 16:24:38','',''),(2548,'21','237','1',1,'Sale Id shift 74',0.00,0.00,0.00,2109.91,0.00,'2022-07-27 16:24:38','',''),(2549,'21','237','2',1,'Sale Id shift 74',0.00,0.00,0.00,1088.05,0.00,'2022-07-27 16:24:38','',''),(2550,'21','237',NULL,2,'Sale Id shift 74',27609442.00,0.00,0.00,0.00,0.00,'2022-07-27 16:24:38','',''),(2551,'21','237',NULL,1,'Sale Id shift 74',4769047.80,0.00,0.00,0.00,0.00,'2022-07-27 16:24:38','',''),(2552,'21','237','5',2,'Sale Id shift 75',0.00,0.00,0.00,3639.52,0.00,'2022-07-27 17:23:08','',''),(2553,'21','237','5',2,'Sale Id shift 75',0.00,0.00,0.00,2793.65,0.00,'2022-07-27 17:23:08','',''),(2554,'21','237','5',2,'Sale Id shift 75',0.00,0.00,0.00,72.78,0.00,'2022-07-27 17:23:08','',''),(2555,'21','237','6',2,'Sale Id shift 75',0.00,0.00,0.00,1100.00,0.00,'2022-07-27 17:23:08','',''),(2556,'21','237','6',2,'Sale Id shift 75',0.00,0.00,0.00,1505.00,0.00,'2022-07-27 17:23:08','',''),(2557,'21','237','6',2,'Sale Id shift 75',0.00,0.00,0.00,2166.67,0.00,'2022-07-27 17:23:08','',''),(2558,'21','237','7',2,'Sale Id shift 75',0.00,0.00,0.00,920.21,0.00,'2022-07-27 17:23:08','',''),(2559,'21','237','7',2,'Sale Id shift 75',0.00,0.00,0.00,3246.06,0.00,'2022-07-27 17:23:08','',''),(2560,'21','237',NULL,2,'Sale Id shift 75',11119600.80,0.00,0.00,0.00,0.00,'2022-07-27 17:23:08','',''),(2561,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-07-27 17:32:19','',''),(2562,'21','237',NULL,1,'Reception corrector for bridging 210',0.00,0.00,0.00,31000.00,0.00,'2022-07-27 17:42:41','',''),(2563,'21','237','4',1,'Received from bridging 210',0.00,0.00,31000.00,0.00,0.00,'2022-07-27 17:42:41','',''),(2564,'21','237',NULL,1,'Reception corrector for bridging 209',0.00,0.00,0.00,19000.00,0.00,'2022-07-27 17:43:11','',''),(2565,'21','237','1',1,'Received from bridging 209',0.00,0.00,19000.00,0.00,0.00,'2022-07-27 17:43:11','',''),(2566,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-07-27 17:43:47','',''),(2567,'21','237',NULL,1,'Reception corrector for bridging 212',0.00,0.00,0.00,30000.00,0.00,'2022-07-27 17:47:16','',''),(2568,'21','237','2',1,'Received from bridging 212',0.00,0.00,30000.00,0.00,0.00,'2022-07-27 17:47:16','',''),(2569,'21','237',NULL,1,'Reception corrector for bridging 211',0.00,0.00,0.00,15000.00,0.00,'2022-07-27 17:48:38','',''),(2570,'21','237','1',1,'Received from bridging 211',0.00,0.00,15000.00,0.00,0.00,'2022-07-27 17:48:38','',''),(2571,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,30240000.00,42000.00,0.00,0.00,'2022-07-27 18:04:54','',''),(2572,'21','237',NULL,2,'Reception corrector for bridging 214',0.00,0.00,0.00,8500.00,0.00,'2022-07-27 18:06:33','',''),(2573,'21','237','6',2,'Received from bridging 214',0.00,0.00,8500.00,0.00,0.00,'2022-07-27 18:06:33','',''),(2574,'21','237',NULL,2,'Reception corrector for bridging 213',0.00,0.00,0.00,33500.00,0.00,'2022-07-27 18:07:20','',''),(2575,'21','237','5',2,'Received from bridging 213',0.00,0.00,33500.00,0.00,0.00,'2022-07-27 18:07:20','',''),(2576,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,36000000.00,50000.00,0.00,0.00,'2022-07-27 18:08:43','',''),(2577,'21','237',NULL,2,'Reception corrector for bridging 216',0.00,0.00,0.00,30000.00,0.00,'2022-07-27 18:10:38','',''),(2578,'21','237','7',2,'Received from bridging 216',0.00,0.00,30000.00,0.00,0.00,'2022-07-27 18:10:38','',''),(2579,'21','237',NULL,2,'Reception corrector for bridging 215',0.00,0.00,0.00,20000.00,0.00,'2022-07-27 18:11:04','',''),(2580,'21','237','6',2,'Received from bridging 215',0.00,0.00,20000.00,0.00,0.00,'2022-07-27 18:11:04','',''),(2581,'21','237','1',1,'Sale Id shift 76',0.00,0.00,0.00,3123.40,0.00,'2022-07-27 19:14:12','',''),(2582,'21','237','2',1,'Sale Id shift 76',0.00,0.00,0.00,1624.45,0.00,'2022-07-27 19:14:12','',''),(2583,'21','237','2',1,'Sale Id shift 76',0.00,0.00,0.00,854.79,0.00,'2022-07-27 19:14:12','',''),(2584,'21','237','2',1,'Sale Id shift 76',0.00,0.00,0.00,1246.86,0.00,'2022-07-27 19:14:12','',''),(2585,'21','237','3',1,'Sale Id shift 76',0.00,0.00,0.00,1053.47,0.00,'2022-07-27 19:14:12','',''),(2586,'21','237','3',1,'Sale Id shift 76',0.00,0.00,0.00,457.71,0.00,'2022-07-27 19:14:12','',''),(2587,'21','237','4',1,'Sale Id shift 76',0.00,0.00,0.00,761.99,0.00,'2022-07-27 19:14:12','',''),(2588,'21','237','1',1,'Sale Id shift 76',0.00,0.00,0.00,270.47,0.00,'2022-07-27 19:14:12','',''),(2589,'21','237','5',2,'Sale Id shift 76',0.00,0.00,0.00,3746.20,0.00,'2022-07-27 19:14:12','',''),(2590,'21','237','5',2,'Sale Id shift 76',0.00,0.00,0.00,4762.74,0.00,'2022-07-27 19:14:12','',''),(2591,'21','237','5',2,'Sale Id shift 76',0.00,0.00,0.00,1302.77,0.00,'2022-07-27 19:14:12','',''),(2592,'21','237','5',2,'Sale Id shift 76',0.00,0.00,0.00,5274.79,0.00,'2022-07-27 19:14:12','',''),(2593,'21','237','6',2,'Sale Id shift 76',0.00,0.00,0.00,5732.60,0.00,'2022-07-27 19:14:12','',''),(2594,'21','237','6',2,'Sale Id shift 76',0.00,0.00,0.00,4561.83,0.00,'2022-07-27 19:14:12','',''),(2595,'21','237','6',2,'Sale Id shift 76',0.00,0.00,0.00,4354.57,0.00,'2022-07-27 19:14:12','',''),(2596,'21','237','7',2,'Sale Id shift 76',0.00,0.00,0.00,5171.63,0.00,'2022-07-27 19:14:12','',''),(2597,'21','237','7',2,'Sale Id shift 76',0.00,0.00,0.00,5710.33,0.00,'2022-07-27 19:14:12','',''),(2598,'21','237','1',1,'Sale Id shift 76',0.00,0.00,0.00,1810.19,0.00,'2022-07-27 19:14:12','',''),(2599,'21','237','1',1,'Sale Id shift 76',0.00,0.00,0.00,2259.28,0.00,'2022-07-27 19:14:12','',''),(2600,'21','237','2',1,'Sale Id shift 76',0.00,0.00,0.00,2216.56,0.00,'2022-07-27 19:14:12','',''),(2601,'21','237','2',1,'Sale Id shift 76',0.00,0.00,0.00,2137.82,0.00,'2022-07-27 19:14:12','',''),(2602,'21','237','2',1,'Sale Id shift 76',0.00,0.00,0.00,1170.37,0.00,'2022-07-27 19:14:12','',''),(2603,'21','237','2',1,'Sale Id shift 76',0.00,0.00,0.00,2971.17,0.00,'2022-07-27 19:14:12','',''),(2604,'21','237','3',1,'Sale Id shift 76',0.00,0.00,0.00,1500.48,0.00,'2022-07-27 19:14:12','',''),(2605,'21','237','3',1,'Sale Id shift 76',0.00,0.00,0.00,1414.40,0.00,'2022-07-27 19:14:12','',''),(2606,'21','237','3',1,'Sale Id shift 76',0.00,0.00,0.00,1248.35,0.00,'2022-07-27 19:14:12','',''),(2607,'21','237','4',1,'Sale Id shift 76',0.00,0.00,0.00,1479.38,0.00,'2022-07-27 19:14:12','',''),(2608,'21','237','4',1,'Sale Id shift 76',0.00,0.00,0.00,1884.65,0.00,'2022-07-27 19:14:12','',''),(2609,'21','237','1',1,'Sale Id shift 76',0.00,0.00,0.00,2697.23,0.00,'2022-07-27 19:14:12','',''),(2610,'21','237','2',1,'Sale Id shift 76',0.00,0.00,0.00,1327.65,0.00,'2022-07-27 19:14:12','',''),(2611,'21','237',NULL,2,'Sale Id shift 76',29244571.20,0.00,0.00,0.00,0.00,'2022-07-27 19:14:12','',''),(2612,'21','237',NULL,1,'Sale Id shift 76',5529260.55,0.00,0.00,0.00,0.00,'2022-07-27 19:14:12','',''),(2613,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,32400000.00,45000.00,0.00,0.00,'2022-07-27 19:51:08','',''),(2614,'21','237',NULL,2,'Reception corrector for bridging 217',0.00,0.00,0.00,15000.00,0.00,'2022-07-27 19:52:36','',''),(2615,'21','237','5',2,'Received from bridging 217',0.00,0.00,15000.00,0.00,0.00,'2022-07-27 19:52:36','',''),(2616,'21','237',NULL,2,'Reception corrector for bridging 218',0.00,0.00,0.00,15000.00,0.00,'2022-07-27 19:52:55','',''),(2617,'21','237','6',2,'Received from bridging 218',0.00,0.00,15000.00,0.00,0.00,'2022-07-27 19:52:55','',''),(2618,'21','237',NULL,2,'Reception corrector for bridging 219',0.00,0.00,0.00,15000.00,0.00,'2022-07-27 19:53:12','',''),(2619,'21','237','7',2,'Received from bridging 219',0.00,0.00,15000.00,0.00,0.00,'2022-07-27 19:53:12','',''),(2620,'21','237','1',1,'Sale Id shift 77',0.00,0.00,0.00,2281.06,0.00,'2022-07-27 20:57:18','',''),(2621,'21','237','2',1,'Sale Id shift 77',0.00,0.00,0.00,1619.12,0.00,'2022-07-27 20:57:18','',''),(2622,'21','237','2',1,'Sale Id shift 77',0.00,0.00,0.00,1455.96,0.00,'2022-07-27 20:57:18','',''),(2623,'21','237','2',1,'Sale Id shift 77',0.00,0.00,0.00,299.61,0.00,'2022-07-27 20:57:18','',''),(2624,'21','237','3',1,'Sale Id shift 77',0.00,0.00,0.00,1199.08,0.00,'2022-07-27 20:57:18','',''),(2625,'21','237','3',1,'Sale Id shift 77',0.00,0.00,0.00,39.91,0.00,'2022-07-27 20:57:18','',''),(2626,'21','237','1',1,'Sale Id shift 77',0.00,0.00,0.00,1349.68,0.00,'2022-07-27 20:57:18','',''),(2627,'21','237','4',1,'Sale Id shift 77',0.00,0.00,0.00,419.65,0.00,'2022-07-27 20:57:18','',''),(2628,'21','237','5',2,'Sale Id shift 77',0.00,0.00,0.00,3786.23,0.00,'2022-07-27 20:57:18','',''),(2629,'21','237','5',2,'Sale Id shift 77',0.00,0.00,0.00,5020.06,0.00,'2022-07-27 20:57:18','',''),(2630,'21','237','5',2,'Sale Id shift 77',0.00,0.00,0.00,2956.45,0.00,'2022-07-27 20:57:18','',''),(2631,'21','237','5',2,'Sale Id shift 77',0.00,0.00,0.00,2926.95,0.00,'2022-07-27 20:57:18','',''),(2632,'21','237','6',2,'Sale Id shift 77',0.00,0.00,0.00,4699.69,0.00,'2022-07-27 20:57:18','',''),(2633,'21','237','6',2,'Sale Id shift 77',0.00,0.00,0.00,1978.99,0.00,'2022-07-27 20:57:18','',''),(2634,'21','237','6',2,'Sale Id shift 77',0.00,0.00,0.00,5193.43,0.00,'2022-07-27 20:57:18','',''),(2635,'21','237','7',2,'Sale Id shift 77',0.00,0.00,0.00,2053.13,0.00,'2022-07-27 20:57:18','',''),(2636,'21','237','7',2,'Sale Id shift 77',0.00,0.00,0.00,5969.13,0.00,'2022-07-27 20:57:18','',''),(2637,'21','237','1',1,'Sale Id shift 77',0.00,0.00,0.00,139.26,0.00,'2022-07-27 20:57:18','',''),(2638,'21','237','1',1,'Sale Id shift 77',0.00,0.00,0.00,1761.81,0.00,'2022-07-27 20:57:18','',''),(2639,'21','237','1',1,'Sale Id shift 77',0.00,0.00,0.00,222.89,0.00,'2022-07-27 20:57:18','',''),(2640,'21','237','1',1,'Sale Id shift 77',0.00,0.00,0.00,1704.68,0.00,'2022-07-27 20:57:18','',''),(2641,'21','237','2',1,'Sale Id shift 77',0.00,0.00,0.00,2632.25,0.00,'2022-07-27 20:57:18','',''),(2642,'21','237','2',1,'Sale Id shift 77',0.00,0.00,0.00,620.78,0.00,'2022-07-27 20:57:18','',''),(2643,'21','237','2',1,'Sale Id shift 77',0.00,0.00,0.00,458.96,0.00,'2022-07-27 20:57:18','',''),(2644,'21','237','2',1,'Sale Id shift 77',0.00,0.00,0.00,1849.55,0.00,'2022-07-27 20:57:18','',''),(2645,'21','237','3',1,'Sale Id shift 77',0.00,0.00,0.00,2235.47,0.00,'2022-07-27 20:57:18','',''),(2646,'21','237','3',1,'Sale Id shift 77',0.00,0.00,0.00,932.93,0.00,'2022-07-27 20:57:18','',''),(2647,'21','237','3',1,'Sale Id shift 77',0.00,0.00,0.00,1627.06,0.00,'2022-07-27 20:57:18','',''),(2648,'21','237','4',1,'Sale Id shift 77',0.00,0.00,0.00,884.80,0.00,'2022-07-27 20:57:18','',''),(2649,'21','237','4',1,'Sale Id shift 77',0.00,0.00,0.00,866.52,0.00,'2022-07-27 20:57:18','',''),(2650,'21','237','4',1,'Sale Id shift 77',0.00,0.00,0.00,2466.87,0.00,'2022-07-27 20:57:18','',''),(2651,'21','237','4',1,'Sale Id shift 77',0.00,0.00,0.00,1423.51,0.00,'2022-07-27 20:57:18','',''),(2652,'21','237','1',1,'Sale Id shift 77',0.00,0.00,0.00,2383.06,0.00,'2022-07-27 20:57:18','',''),(2653,'21','237','2',1,'Sale Id shift 77',0.00,0.00,0.00,1349.44,0.00,'2022-07-27 20:57:18','',''),(2654,'21','237',NULL,2,'Sale Id shift 77',24900523.20,0.00,0.00,0.00,0.00,'2022-07-27 20:57:18','',''),(2655,'21','237',NULL,1,'Sale Id shift 77',5316945.15,0.00,0.00,0.00,0.00,'2022-07-27 20:57:18','',''),(2656,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,8250000.00,50000.00,0.00,0.00,'2022-07-30 10:01:13','',''),(2657,'21','237',NULL,1,'Reception corrector for bridging 221',0.00,0.00,0.00,31000.00,0.00,'2022-07-30 10:02:54','',''),(2658,'21','237','3',1,'Received from bridging 221',0.00,0.00,31000.00,0.00,0.00,'2022-07-30 10:02:54','',''),(2659,'21','237',NULL,1,'Reception corrector for bridging 220',0.00,0.00,0.00,19000.00,0.00,'2022-07-30 10:03:14','',''),(2660,'21','237','2',1,'Received from bridging 220',0.00,0.00,19000.00,0.00,0.00,'2022-07-30 10:03:14','',''),(2661,'21','237','1',1,'Sale Id shift 78',0.00,0.00,0.00,1683.49,0.00,'2022-07-30 10:51:55','',''),(2662,'21','237','2',1,'Sale Id shift 78',0.00,0.00,0.00,1900.03,0.00,'2022-07-30 10:51:55','',''),(2663,'21','237','2',1,'Sale Id shift 78',0.00,0.00,0.00,138.44,0.00,'2022-07-30 10:51:55','',''),(2664,'21','237','2',1,'Sale Id shift 78',0.00,0.00,0.00,215.17,0.00,'2022-07-30 10:51:55','',''),(2665,'21','237','3',1,'Sale Id shift 78',0.00,0.00,0.00,280.04,0.00,'2022-07-30 10:51:55','',''),(2666,'21','237','1',1,'Sale Id shift 78',0.00,0.00,0.00,108.51,0.00,'2022-07-30 10:51:55','',''),(2667,'21','237','5',2,'Sale Id shift 78',0.00,0.00,0.00,3928.76,0.00,'2022-07-30 10:51:55','',''),(2668,'21','237','5',2,'Sale Id shift 78',0.00,0.00,0.00,6362.06,0.00,'2022-07-30 10:51:55','',''),(2669,'21','237','5',2,'Sale Id shift 78',0.00,0.00,0.00,1355.02,0.00,'2022-07-30 10:51:55','',''),(2670,'21','237','5',2,'Sale Id shift 78',0.00,0.00,0.00,1016.96,0.00,'2022-07-30 10:51:55','',''),(2671,'21','237','6',2,'Sale Id shift 78',0.00,0.00,0.00,1703.14,0.00,'2022-07-30 10:51:55','',''),(2672,'21','237','6',2,'Sale Id shift 78',0.00,0.00,0.00,1160.60,0.00,'2022-07-30 10:51:55','',''),(2673,'21','237','6',2,'Sale Id shift 78',0.00,0.00,0.00,3659.78,0.00,'2022-07-30 10:51:55','',''),(2674,'21','237','7',2,'Sale Id shift 78',0.00,0.00,0.00,2889.18,0.00,'2022-07-30 10:51:55','',''),(2675,'21','237','7',2,'Sale Id shift 78',0.00,0.00,0.00,4027.23,0.00,'2022-07-30 10:51:55','',''),(2676,'21','237','1',1,'Sale Id shift 78',0.00,0.00,0.00,214.95,0.00,'2022-07-30 10:51:55','',''),(2677,'21','237','1',1,'Sale Id shift 78',0.00,0.00,0.00,772.14,0.00,'2022-07-30 10:51:55','',''),(2678,'21','237','1',1,'Sale Id shift 78',0.00,0.00,0.00,1948.80,0.00,'2022-07-30 10:51:55','',''),(2679,'21','237','2',1,'Sale Id shift 78',0.00,0.00,0.00,2877.49,0.00,'2022-07-30 10:51:55','',''),(2680,'21','237','2',1,'Sale Id shift 78',0.00,0.00,0.00,1408.44,0.00,'2022-07-30 10:51:55','',''),(2681,'21','237','2',1,'Sale Id shift 78',0.00,0.00,0.00,3330.66,0.00,'2022-07-30 10:51:55','',''),(2682,'21','237','3',1,'Sale Id shift 78',0.00,0.00,0.00,2460.82,0.00,'2022-07-30 10:51:55','',''),(2683,'21','237','3',1,'Sale Id shift 78',0.00,0.00,0.00,1326.89,0.00,'2022-07-30 10:51:55','',''),(2684,'21','237','3',1,'Sale Id shift 78',0.00,0.00,0.00,1248.83,0.00,'2022-07-30 10:51:55','',''),(2685,'21','237','3',1,'Sale Id shift 78',0.00,0.00,0.00,0.03,0.00,'2022-07-30 10:51:55','',''),(2686,'21','237','4',1,'Sale Id shift 78',0.00,0.00,0.00,1940.10,0.00,'2022-07-30 10:51:55','',''),(2687,'21','237','4',1,'Sale Id shift 78',0.00,0.00,0.00,1791.60,0.00,'2022-07-30 10:51:55','',''),(2688,'21','237','4',1,'Sale Id shift 78',0.00,0.00,0.00,2611.51,0.00,'2022-07-30 10:51:55','',''),(2689,'21','237','1',1,'Sale Id shift 78',0.00,0.00,0.00,1604.59,0.00,'2022-07-30 10:51:55','',''),(2690,'21','237','2',1,'Sale Id shift 78',0.00,0.00,0.00,1044.59,0.00,'2022-07-30 10:51:55','',''),(2691,'21','237',NULL,2,'Sale Id shift 78',18793965.60,0.00,0.00,0.00,0.00,'2022-07-30 10:51:55','',''),(2692,'21','237',NULL,1,'Sale Id shift 78',4769674.80,0.00,0.00,0.00,0.00,'2022-07-30 10:51:55','',''),(2693,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-07-31 15:33:52','',''),(2694,'21','237',NULL,1,'Reception corrector for bridging 222',0.00,0.00,0.00,30000.00,0.00,'2022-07-31 15:35:48','',''),(2695,'21','237','1',1,'Received from bridging 222',0.00,0.00,30000.00,0.00,0.00,'2022-07-31 15:35:48','',''),(2696,'21','237',NULL,1,'Reception corrector for bridging 223',0.00,0.00,0.00,15000.00,0.00,'2022-07-31 15:36:27','',''),(2697,'21','237','4',1,'Received from bridging 223',0.00,0.00,15000.00,0.00,0.00,'2022-07-31 15:36:27','',''),(2698,'21','237','1',1,'Sale Id shift 79',0.00,0.00,0.00,2888.92,0.00,'2022-07-31 16:43:51','',''),(2699,'21','237','2',1,'Sale Id shift 79',0.00,0.00,0.00,1587.19,0.00,'2022-07-31 16:43:51','',''),(2700,'21','237','2',1,'Sale Id shift 79',0.00,0.00,0.00,2608.85,0.00,'2022-07-31 16:43:51','',''),(2701,'21','237','2',1,'Sale Id shift 79',0.00,0.00,0.00,261.24,0.00,'2022-07-31 16:43:51','',''),(2702,'21','237','3',1,'Sale Id shift 79',0.00,0.00,0.00,441.35,0.00,'2022-07-31 16:43:51','',''),(2703,'21','237','4',1,'Sale Id shift 79',0.00,0.00,0.00,197.39,0.00,'2022-07-31 16:43:51','',''),(2704,'21','237','1',1,'Sale Id shift 79',0.00,0.00,0.00,1015.67,0.00,'2022-07-31 16:43:51','',''),(2705,'21','237','5',2,'Sale Id shift 79',0.00,0.00,0.00,1631.11,0.00,'2022-07-31 16:43:51','',''),(2706,'21','237','5',2,'Sale Id shift 79',0.00,0.00,0.00,5864.32,0.00,'2022-07-31 16:43:51','',''),(2707,'21','237','5',2,'Sale Id shift 79',0.00,0.00,0.00,936.59,0.00,'2022-07-31 16:43:51','',''),(2708,'21','237','5',2,'Sale Id shift 79',0.00,0.00,0.00,1997.65,0.00,'2022-07-31 16:43:51','',''),(2709,'21','237','6',2,'Sale Id shift 79',0.00,0.00,0.00,2337.64,0.00,'2022-07-31 16:43:51','',''),(2710,'21','237','6',2,'Sale Id shift 79',0.00,0.00,0.00,4243.89,0.00,'2022-07-31 16:43:51','',''),(2711,'21','237','6',2,'Sale Id shift 79',0.00,0.00,0.00,4602.37,0.00,'2022-07-31 16:43:51','',''),(2712,'21','237','7',2,'Sale Id shift 79',0.00,0.00,0.00,2408.60,0.00,'2022-07-31 16:43:51','',''),(2713,'21','237','7',2,'Sale Id shift 79',0.00,0.00,0.00,4053.12,0.00,'2022-07-31 16:43:51','',''),(2714,'21','237','1',1,'Sale Id shift 79',0.00,0.00,0.00,787.59,0.00,'2022-07-31 16:43:51','',''),(2715,'21','237','1',1,'Sale Id shift 79',0.00,0.00,0.00,1012.07,0.00,'2022-07-31 16:43:51','',''),(2716,'21','237','1',1,'Sale Id shift 79',0.00,0.00,0.00,932.39,0.00,'2022-07-31 16:43:51','',''),(2717,'21','237','1',1,'Sale Id shift 79',0.00,0.00,0.00,574.94,0.00,'2022-07-31 16:43:51','',''),(2718,'21','237','2',1,'Sale Id shift 79',0.00,0.00,0.00,1937.56,0.00,'2022-07-31 16:43:51','',''),(2719,'21','237','2',1,'Sale Id shift 79',0.00,0.00,0.00,1503.34,0.00,'2022-07-31 16:43:51','',''),(2720,'21','237','2',1,'Sale Id shift 79',0.00,0.00,0.00,446.61,0.00,'2022-07-31 16:43:51','',''),(2721,'21','237','2',1,'Sale Id shift 79',0.00,0.00,0.00,3169.81,0.00,'2022-07-31 16:43:51','',''),(2722,'21','237','3',1,'Sale Id shift 79',0.00,0.00,0.00,400.59,0.00,'2022-07-31 16:43:51','',''),(2723,'21','237','3',1,'Sale Id shift 79',0.00,0.00,0.00,1695.45,0.00,'2022-07-31 16:43:51','',''),(2724,'21','237','3',1,'Sale Id shift 79',0.00,0.00,0.00,124.92,0.00,'2022-07-31 16:43:51','',''),(2725,'21','237','4',1,'Sale Id shift 79',0.00,0.00,0.00,889.00,0.00,'2022-07-31 16:43:51','',''),(2726,'21','237','4',1,'Sale Id shift 79',0.00,0.00,0.00,1718.16,0.00,'2022-07-31 16:43:51','',''),(2727,'21','237','4',1,'Sale Id shift 79',0.00,0.00,0.00,4900.16,0.00,'2022-07-31 16:43:51','',''),(2728,'21','237','4',1,'Sale Id shift 79',0.00,0.00,0.00,1739.93,0.00,'2022-07-31 16:43:51','',''),(2729,'21','237','1',1,'Sale Id shift 79',0.00,0.00,0.00,2844.03,0.00,'2022-07-31 16:43:51','',''),(2730,'21','237','2',1,'Sale Id shift 79',0.00,0.00,0.00,1457.29,0.00,'2022-07-31 16:43:51','',''),(2731,'21','237',NULL,2,'Sale Id shift 79',20214208.80,0.00,0.00,0.00,0.00,'2022-07-31 16:43:51','',''),(2732,'21','237',NULL,1,'Sale Id shift 79',5797184.25,0.00,0.00,0.00,0.00,'2022-07-31 16:43:51','',''),(2733,'21','237',NULL,1,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,7425000.00,45000.00,0.00,0.00,'2022-07-31 16:56:30','',''),(2734,'21','237',NULL,1,'Reception corrector for bridging 225',0.00,0.00,0.00,15000.00,0.00,'2022-07-31 16:58:11','',''),(2735,'21','237','4',1,'Received from bridging 225',0.00,0.00,15000.00,0.00,0.00,'2022-07-31 16:58:11','',''),(2736,'21','237',NULL,2,'Purchased from AYM SHAFA NIGERIA. LTD',0.00,36000000.00,50000.00,0.00,0.00,'2022-07-31 17:40:34','',''),(2737,'21','237',NULL,2,'Reception corrector for bridging 231',0.00,0.00,0.00,15000.00,0.00,'2022-07-31 17:43:58','',''),(2738,'21','237','7',2,'Received from bridging 231',0.00,0.00,15000.00,0.00,0.00,'2022-07-31 17:43:58','',''),(2739,'21','237',NULL,2,'Reception corrector for bridging 230',0.00,0.00,0.00,15000.00,0.00,'2022-07-31 17:51:43','',''),(2740,'21','237','6',2,'Received from bridging 230',0.00,0.00,15000.00,0.00,0.00,'2022-07-31 17:51:43','',''),(2741,'21','237',NULL,2,'Reception corrector for bridging 229',0.00,0.00,0.00,15000.00,0.00,'2022-07-31 17:52:05','',''),(2742,'21','237','5',2,'Received from bridging 229',0.00,0.00,15000.00,0.00,0.00,'2022-07-31 17:52:05','',''),(2743,'21','237','1',1,'Sale Id shift 80',0.00,0.00,0.00,3273.49,0.00,'2022-07-31 18:58:02','',''),(2744,'21','237','2',1,'Sale Id shift 80',0.00,0.00,0.00,1551.37,0.00,'2022-07-31 18:58:02','',''),(2745,'21','237','2',1,'Sale Id shift 80',0.00,0.00,0.00,465.79,0.00,'2022-07-31 18:58:02','',''),(2746,'21','237','2',1,'Sale Id shift 80',0.00,0.00,0.00,556.70,0.00,'2022-07-31 18:58:02','',''),(2747,'21','237','3',1,'Sale Id shift 80',0.00,0.00,0.00,944.64,0.00,'2022-07-31 18:58:02','',''),(2748,'21','237','3',1,'Sale Id shift 80',0.00,0.00,0.00,799.34,0.00,'2022-07-31 18:58:02','',''),(2749,'21','237','1',1,'Sale Id shift 80',0.00,0.00,0.00,1210.96,0.00,'2022-07-31 18:58:02','',''),(2750,'21','237','4',1,'Sale Id shift 80',0.00,0.00,0.00,391.97,0.00,'2022-07-31 18:58:02','',''),(2751,'21','237','5',2,'Sale Id shift 80',0.00,0.00,0.00,1363.05,0.00,'2022-07-31 18:58:02','',''),(2752,'21','237','5',2,'Sale Id shift 80',0.00,0.00,0.00,6262.70,0.00,'2022-07-31 18:58:02','',''),(2753,'21','237','5',2,'Sale Id shift 80',0.00,0.00,0.00,5026.81,0.00,'2022-07-31 18:58:02','',''),(2754,'21','237','5',2,'Sale Id shift 80',0.00,0.00,0.00,4463.08,0.00,'2022-07-31 18:58:02','',''),(2755,'21','237','6',2,'Sale Id shift 80',0.00,0.00,0.00,420.00,0.00,'2022-07-31 18:58:02','',''),(2756,'21','237','6',2,'Sale Id shift 80',0.00,0.00,0.00,4646.32,0.00,'2022-07-31 18:58:02','',''),(2757,'21','237','6',2,'Sale Id shift 80',0.00,0.00,0.00,2723.65,0.00,'2022-07-31 18:58:02','',''),(2758,'21','237','7',2,'Sale Id shift 80',0.00,0.00,0.00,3201.24,0.00,'2022-07-31 18:58:02','',''),(2759,'21','237','7',2,'Sale Id shift 80',0.00,0.00,0.00,4647.84,0.00,'2022-07-31 18:58:02','',''),(2760,'21','237','1',1,'Sale Id shift 80',0.00,0.00,0.00,46.66,0.00,'2022-07-31 18:58:02','',''),(2761,'21','237','1',1,'Sale Id shift 80',0.00,0.00,0.00,1153.37,0.00,'2022-07-31 18:58:02','',''),(2762,'21','237','1',1,'Sale Id shift 80',0.00,0.00,0.00,1456.73,0.00,'2022-07-31 18:58:02','',''),(2763,'21','237','2',1,'Sale Id shift 80',0.00,0.00,0.00,2586.74,0.00,'2022-07-31 18:58:02','',''),(2764,'21','237','2',1,'Sale Id shift 80',0.00,0.00,0.00,1506.36,0.00,'2022-07-31 18:58:02','',''),(2765,'21','237','2',1,'Sale Id shift 80',0.00,0.00,0.00,2082.26,0.00,'2022-07-31 18:58:02','',''),(2766,'21','237','2',1,'Sale Id shift 80',0.00,0.00,0.00,3441.78,0.00,'2022-07-31 18:58:02','',''),(2767,'21','237','3',1,'Sale Id shift 80',0.00,0.00,0.00,1628.75,0.00,'2022-07-31 18:58:02','',''),(2768,'21','237','3',1,'Sale Id shift 80',0.00,0.00,0.00,467.17,0.00,'2022-07-31 18:58:02','',''),(2769,'21','237','3',1,'Sale Id shift 80',0.00,0.00,0.00,847.50,0.00,'2022-07-31 18:58:02','',''),(2770,'21','237','4',1,'Sale Id shift 80',0.00,0.00,0.00,452.70,0.00,'2022-07-31 18:58:02','',''),(2771,'21','237','4',1,'Sale Id shift 80',0.00,0.00,0.00,379.50,0.00,'2022-07-31 18:58:02','',''),(2772,'21','237','4',1,'Sale Id shift 80',0.00,0.00,0.00,1714.43,0.00,'2022-07-31 18:58:02','',''),(2773,'21','237','4',1,'Sale Id shift 80',0.00,0.00,0.00,1681.81,0.00,'2022-07-31 18:58:02','',''),(2774,'21','237','1',1,'Sale Id shift 80',0.00,0.00,0.00,1896.28,0.00,'2022-07-31 18:58:02','',''),(2775,'21','237','2',1,'Sale Id shift 80',0.00,0.00,0.00,1259.36,0.00,'2022-07-31 18:58:02','',''),(2776,'21','237',NULL,2,'Sale Id shift 80',23583376.80,0.00,0.00,0.00,0.00,'2022-07-31 18:58:02','',''),(2777,'21','237',NULL,1,'Sale Id shift 80',5246283.90,0.00,0.00,0.00,0.00,'2022-07-31 18:58:02','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=136 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (1,'21','237',2,'Sale Id shift 2',0.00,26953689.60,640.00,26953689.60,0.00,'2022-03-26 18:03:53'),(2,'21','237',1,'Sale Id shift 2',0.00,9834422.40,165.00,9834422.40,0.00,'2022-03-26 18:03:53'),(3,'21','237',2,'Sale Id shift 3',0.00,27080614.40,640.00,27080614.40,0.00,'2022-03-27 12:31:04'),(4,'21','237',1,'Sale Id shift 3',0.00,3750105.15,165.00,3750105.15,0.00,'2022-03-27 12:31:04'),(5,'21','237',2,'Sale Id shift 5',0.00,16634624.00,640.00,16634624.00,0.00,'2022-03-31 18:09:16'),(6,'21','237',1,'Sale Id shift 5',0.00,8782552.35,165.00,8782552.35,0.00,'2022-03-31 18:09:16'),(7,'21','237',2,'Sale Id shift 6',0.00,15587251.20,640.00,15587251.20,0.00,'2022-04-05 12:26:35'),(8,'21','237',1,'Sale Id shift 6',0.00,8664846.30,165.00,8664846.30,0.00,'2022-04-05 12:26:35'),(9,'21','237',2,'Sale Id shift 7',0.00,14065798.40,640.00,14065798.40,0.00,'2022-04-12 11:05:50'),(10,'21','237',1,'Sale Id shift 7',0.00,6466714.65,165.00,6466714.65,0.00,'2022-04-12 11:05:50'),(11,'21','237',2,'Sale Id shift 8',0.00,23584627.20,640.00,23584627.20,0.00,'2022-04-14 17:21:05'),(12,'21','237',1,'Sale Id shift 8',0.00,908922.30,165.00,908922.30,0.00,'2022-04-14 17:21:05'),(13,'21','237',2,'Sale Id shift 9',0.00,27015097.60,640.00,27015097.60,0.00,'2022-04-14 17:48:57'),(14,'21','237',1,'Sale Id shift 9',0.00,9700798.80,165.00,9700798.80,0.00,'2022-04-14 17:48:57'),(15,'21','237',2,'Sale Id shift 11',0.00,29527072.00,640.00,29527072.00,0.00,'2022-04-28 15:11:22'),(16,'21','237',1,'Sale Id shift 11',0.00,8986386.75,165.00,8986386.75,0.00,'2022-04-28 15:11:22'),(17,'21','237',2,'Sale Id shift 12',0.00,21034355.20,640.00,21034355.20,0.00,'2022-04-30 19:37:52'),(18,'21','237',1,'Sale Id shift 12',0.00,8753819.25,165.00,8753819.25,0.00,'2022-04-30 19:37:52'),(19,'21','237',2,'Sale Id shift 14',0.00,22178124.80,640.00,22178124.80,0.00,'2022-05-09 08:44:12'),(20,'21','237',1,'Sale Id shift 14',0.00,8476736.40,165.00,8476736.40,0.00,'2022-05-09 08:44:12'),(21,'21','237',2,'Sale Id shift 15',0.00,21429651.20,640.00,21429651.20,0.00,'2022-05-14 09:56:18'),(22,'21','237',1,'Sale Id shift 15',0.00,10204916.70,165.00,10204916.70,0.00,'2022-05-14 09:56:18'),(23,'21','237',2,'Sale Id shift 16',0.00,25106732.80,640.00,25106732.80,0.00,'2022-05-14 14:14:36'),(24,'21','237',1,'Sale Id shift 16',0.00,8752459.65,165.00,8752459.65,0.00,'2022-05-14 14:14:36'),(25,'21','237',2,'Sale Id shift 17',0.00,27090387.20,640.00,27090387.20,0.00,'2022-05-14 17:01:20'),(26,'21','237',1,'Sale Id shift 17',0.00,10412461.95,165.00,10412461.95,0.00,'2022-05-14 17:01:20'),(27,'21','237',2,'Sale Id shift 18',0.00,22931008.00,640.00,22931008.00,0.00,'2022-05-15 12:37:11'),(28,'21','237',1,'Sale Id shift 18',0.00,9844695.30,165.00,9844695.30,0.00,'2022-05-15 12:37:11'),(29,'21','237',2,'Sale Id shift 19',0.00,19990009.60,640.00,19990009.60,0.00,'2022-05-15 14:20:57'),(30,'21','237',1,'Sale Id shift 19',0.00,11015400.00,165.00,11015400.00,0.00,'2022-05-15 14:20:57'),(31,'21','237',2,'Sale Id shift 20',0.00,15099584.00,640.00,15099584.00,0.00,'2022-05-17 11:21:45'),(32,'21','237',1,'Sale Id shift 20',0.00,2462458.35,165.00,2462458.35,0.00,'2022-05-17 11:21:45'),(33,'21','237',2,'Sale Id shift 21',0.00,30442976.00,640.00,30442976.00,0.00,'2022-05-17 16:24:58'),(34,'21','237',1,'Sale Id shift 21',0.00,6739497.60,165.00,6739497.60,0.00,'2022-05-17 16:24:58'),(35,'21','237',2,'Sale Id shift 22',0.00,27623750.40,640.00,27623750.40,0.00,'2022-05-19 14:26:55'),(36,'21','237',1,'Sale Id shift 22',0.00,8295482.25,165.00,8295482.25,0.00,'2022-05-19 14:26:55'),(37,'21','237',2,'Sale Id shift 23',0.00,23917984.00,640.00,23917984.00,0.00,'2022-05-19 17:30:16'),(38,'21','237',1,'Sale Id shift 23',0.00,9212415.30,165.00,9212415.30,0.00,'2022-05-19 17:30:16'),(39,'21','237',2,'Sale Id shift 24',0.00,27938521.60,640.00,27938521.60,0.00,'2022-05-19 19:12:43'),(40,'21','237',1,'Sale Id shift 24',0.00,8841218.10,165.00,8841218.10,0.00,'2022-05-19 19:12:43'),(41,'21','237',2,'Sale Id shift 25',0.00,30950860.80,640.00,30950860.80,0.00,'2022-05-20 19:29:27'),(42,'21','237',1,'Sale Id shift 25',0.00,8623017.15,165.00,8623017.15,0.00,'2022-05-20 19:29:27'),(43,'21','237',2,'Sale Id shift 26',0.00,25315980.80,640.00,25315980.80,0.00,'2022-05-27 15:08:21'),(44,'21','237',1,'Sale Id shift 26',0.00,7562519.25,165.00,7562519.25,0.00,'2022-05-27 15:08:21'),(45,'21','237',2,'Sale Id shift 27',0.00,21916934.40,640.00,21916934.40,0.00,'2022-05-31 11:32:55'),(46,'21','237',1,'Sale Id shift 27',0.00,5093832.15,165.00,5093832.15,0.00,'2022-05-31 11:32:55'),(47,'21','237',2,'Sale Id shift 28',0.00,25475724.80,640.00,25475724.80,0.00,'2022-05-31 15:48:29'),(48,'21','237',1,'Sale Id shift 28',0.00,7939042.65,165.00,7939042.65,0.00,'2022-05-31 15:48:29'),(49,'21','237',2,'Sale Id shift 29',0.00,28042604.80,640.00,28042604.80,0.00,'2022-05-31 18:28:08'),(50,'21','237',1,'Sale Id shift 29',0.00,8316815.10,165.00,8316815.10,0.00,'2022-05-31 18:28:08'),(51,'21','237',2,'Sale Id shift 30',0.00,33649888.00,640.00,33649888.00,0.00,'2022-06-01 05:55:50'),(52,'21','237',1,'Sale Id shift 30',0.00,7452038.55,165.00,7452038.55,0.00,'2022-06-01 05:55:50'),(53,'21','237',2,'Sale Id shift 32',0.00,30882041.60,640.00,30882041.60,0.00,'2022-06-02 11:54:27'),(54,'21','237',1,'Sale Id shift 32',0.00,7799406.45,165.00,7799406.45,0.00,'2022-06-02 11:54:27'),(55,'21','237',2,'Sale Id shift 33',0.00,30583072.00,640.00,30583072.00,0.00,'2022-06-02 13:22:40'),(56,'21','237',1,'Sale Id shift 33',0.00,7815342.15,165.00,7815342.15,0.00,'2022-06-02 13:22:40'),(57,'21','237',2,'Sale Id shift 34',0.00,34022272.00,640.00,34022272.00,0.00,'2022-06-02 16:34:16'),(58,'21','237',1,'Sale Id shift 34',0.00,7969217.85,165.00,7969217.85,0.00,'2022-06-02 16:34:16'),(59,'21','237',2,'Sale Id shift 35',0.00,25505491.20,640.00,25505491.20,0.00,'2022-06-02 22:13:43'),(60,'21','237',1,'Sale Id shift 35',0.00,5768711.85,165.00,5768711.85,0.00,'2022-06-02 22:13:43'),(61,'21','237',2,'Sale Id shift 36',0.00,22992780.80,640.00,22992780.80,0.00,'2022-06-03 05:37:24'),(62,'21','237',1,'Sale Id shift 36',0.00,7399773.15,165.00,7399773.15,0.00,'2022-06-03 05:37:24'),(63,'21','237',2,'Sale Id shift 38',0.00,36985299.20,640.00,36985299.20,0.00,'2022-06-05 09:37:58'),(64,'21','237',1,'Sale Id shift 38',0.00,7056934.50,165.00,7056934.50,0.00,'2022-06-05 09:37:58'),(65,'21','237',2,'Sale Id shift 39',0.00,24241100.80,640.00,24241100.80,0.00,'2022-06-06 08:42:26'),(66,'21','237',1,'Sale Id shift 39',0.00,4872753.60,165.00,4872753.60,0.00,'2022-06-06 08:42:26'),(67,'21','237',1,'Sale Id shift 40',0.00,6713531.55,165.00,6713531.55,0.00,'2022-06-06 09:32:08'),(68,'21','237',2,'Sale Id shift 41',0.00,18771577.60,640.00,18771577.60,0.00,'2022-06-07 09:58:22'),(69,'21','237',1,'Sale Id shift 41',0.00,6644107.80,165.00,6644107.80,0.00,'2022-06-07 09:58:22'),(70,'21','237',2,'Sale Id shift 43',0.00,36703078.40,650.00,37276564.00,573485.60,'2022-06-08 10:14:47'),(71,'21','237',1,'Sale Id shift 43',0.00,7831850.40,165.00,7831850.40,0.00,'2022-06-08 10:14:47'),(72,'21','237',2,'Sale Id shift 44',0.00,13243545.60,650.00,13450476.00,206930.40,'2022-06-08 13:01:48'),(73,'21','237',1,'Sale Id shift 44',0.00,5506429.50,165.00,5506429.50,0.00,'2022-06-08 13:01:48'),(74,'21','237',2,'Sale Id shift 45',0.00,16314950.40,650.00,16569871.50,254921.10,'2022-06-08 15:01:09'),(75,'21','237',1,'Sale Id shift 45',0.00,1634980.05,165.00,1634980.05,0.00,'2022-06-08 15:01:09'),(76,'21','237',2,'Sale Id shift 46',0.00,1068812.80,650.00,1085513.00,16700.20,'2022-06-08 18:38:33'),(77,'21','237',1,'Sale Id shift 46',0.00,10895834.40,165.00,10895834.40,0.00,'2022-06-08 18:38:33'),(78,'21','237',2,'Sale Id shift 47',0.00,12134453.50,650.00,12134453.50,0.00,'2022-06-08 21:16:42'),(79,'21','237',1,'Sale Id shift 47',0.00,5430740.70,165.00,5430740.70,0.00,'2022-06-08 21:16:42'),(80,'21','237',2,'Sale Id shift 48',0.00,25934688.00,650.00,25934688.00,0.00,'2022-06-10 11:58:35'),(81,'21','237',1,'Sale Id shift 48',0.00,6185538.15,165.00,6185538.15,0.00,'2022-06-10 11:58:35'),(82,'21','237',2,'Sale Id shift 49',0.00,25869317.50,650.00,25869317.50,0.00,'2022-06-11 08:39:00'),(83,'21','237',1,'Sale Id shift 49',0.00,6395644.20,165.00,6395644.20,0.00,'2022-06-11 08:39:00'),(84,'21','237',2,'Sale Id shift 50',0.00,19976001.50,650.00,19976001.50,0.00,'2022-06-11 10:07:53'),(85,'21','237',1,'Sale Id shift 50',0.00,6504517.80,165.00,6504517.80,0.00,'2022-06-11 10:07:53'),(86,'21','237',2,'Sale Id shift 51',0.00,23791430.00,650.00,23791430.00,0.00,'2022-06-11 11:03:42'),(87,'21','237',1,'Sale Id shift 51',0.00,6174781.80,165.00,6174781.80,0.00,'2022-06-11 11:03:42'),(88,'21','237',2,'Sale Id shift 52',0.00,20902765.00,650.00,20902765.00,0.00,'2022-06-11 12:53:49'),(89,'21','237',1,'Sale Id shift 52',0.00,5585357.25,165.00,5585357.25,0.00,'2022-06-11 12:53:49'),(90,'21','237',2,'Sale Id shift 53',0.00,41832414.00,650.00,41832414.00,0.00,'2022-06-12 08:00:10'),(91,'21','237',1,'Sale Id shift 53',0.00,5587612.80,165.00,5587612.80,0.00,'2022-06-12 08:00:10'),(92,'21','237',2,'Sale Id shift 54',0.00,29921216.00,650.00,29921216.00,0.00,'2022-06-12 09:23:50'),(93,'21','237',1,'Sale Id shift 54',0.00,5883781.20,165.00,5883781.20,0.00,'2022-06-12 09:23:50'),(94,'21','237',2,'Sale Id shift 55',0.00,37373128.00,650.00,37373128.00,0.00,'2022-06-12 11:02:53'),(95,'21','237',1,'Sale Id shift 55',0.00,5855150.40,165.00,5855150.40,0.00,'2022-06-12 11:02:53'),(96,'21','237',2,'Sale Id shift 57',0.00,26386938.50,650.00,26386938.50,0.00,'2022-06-18 17:51:22'),(97,'21','237',1,'Sale Id shift 57',0.00,5559133.80,165.00,5559133.80,0.00,'2022-06-18 17:51:22'),(98,'21','237',2,'Sale Id shift 58',0.00,36795622.50,690.00,39059968.50,2264346.00,'2022-06-18 20:56:52'),(99,'21','237',1,'Sale Id shift 58',0.00,6408606.60,165.00,6408606.60,0.00,'2022-06-18 20:56:52'),(100,'21','237',2,'Sale Id shift 59',0.00,20888933.00,690.00,22174405.80,1285472.80,'2022-06-18 22:08:31'),(101,'21','237',1,'Sale Id shift 59',0.00,5964405.15,165.00,5964405.15,0.00,'2022-06-18 22:08:31'),(102,'21','237',2,'Sale Id shift 62',0.00,13099146.30,690.00,13099146.30,0.00,'2022-06-22 10:20:51'),(103,'21','237',1,'Sale Id shift 62',0.00,5721043.35,165.00,5721043.35,0.00,'2022-06-22 10:20:51'),(104,'21','237',2,'Sale Id shift 64',0.00,14563084.00,680.00,14563084.00,0.00,'2022-06-22 12:00:28'),(105,'21','237',2,'Sale Id shift 65',0.00,36328367.60,680.00,36328367.60,0.00,'2022-06-22 13:00:40'),(106,'21','237',1,'Sale Id shift 65',0.00,5593363.05,165.00,5593363.05,0.00,'2022-06-22 13:00:40'),(107,'21','237',2,'Sale Id shift 66',0.00,38880863.20,680.00,38880863.20,0.00,'2022-06-22 15:49:24'),(108,'21','237',1,'Sale Id shift 66',0.00,5097178.35,165.00,5097178.35,0.00,'2022-06-22 15:49:24'),(109,'21','237',2,'Sale Id shift 67',0.00,38325303.20,680.00,38325303.20,0.00,'2022-06-22 17:54:06'),(110,'21','237',1,'Sale Id shift 67',0.00,5286194.10,165.00,5286194.10,0.00,'2022-06-22 17:54:06'),(111,'21','237',2,'Sale Id shift 68',0.00,28930464.00,680.00,28930464.00,0.00,'2022-06-23 11:40:58'),(112,'21','237',1,'Sale Id shift 68',0.00,5499009.45,165.00,5499009.45,0.00,'2022-06-23 11:40:58'),(113,'21','237',2,'Sale Id shift 69',0.00,27981592.00,680.00,27981592.00,0.00,'2022-06-24 10:37:09'),(114,'21','237',1,'Sale Id shift 69',0.00,5064417.60,165.00,5064417.60,0.00,'2022-06-24 10:37:09'),(115,'21','237',2,'Sale Id shift 70',0.00,27516451.60,680.00,27516451.60,0.00,'2022-06-25 09:03:46'),(116,'21','237',1,'Sale Id shift 70',0.00,4973631.30,165.00,4973631.30,0.00,'2022-06-25 09:03:46'),(117,'21','237',2,'Sale Id shift 71',0.00,26640131.00,700.00,26640131.00,0.00,'2022-07-20 17:37:19'),(118,'21','237',1,'Sale Id shift 71',0.00,5326518.45,165.00,5326518.45,0.00,'2022-07-20 17:37:19'),(119,'21','237',2,'Sale Id shift 72',0.00,11328156.00,700.00,11328156.00,0.00,'2022-07-22 15:26:48'),(120,'21','237',1,'Sale Id shift 72',0.00,5004197.55,165.00,5004197.55,0.00,'2022-07-22 15:26:48'),(121,'21','237',2,'Sale Id shift 73',0.00,20677538.00,700.00,20677538.00,0.00,'2022-07-26 21:34:33'),(122,'21','237',1,'Sale Id shift 73',0.00,4312557.15,165.00,4312557.15,0.00,'2022-07-26 21:34:33'),(123,'21','237',2,'Sale Id shift 74',0.00,27609442.00,700.00,27609442.00,0.00,'2022-07-27 16:24:38'),(124,'21','237',1,'Sale Id shift 74',0.00,4769047.80,165.00,4769047.80,0.00,'2022-07-27 16:24:38'),(125,'21','237',2,'Sale Id shift 75',0.00,11119600.80,720.00,11119600.80,0.00,'2022-07-27 17:23:08'),(126,'21','237',2,'Sale Id shift 76',0.00,29244571.20,720.00,29244571.20,0.00,'2022-07-27 19:14:12'),(127,'21','237',1,'Sale Id shift 76',0.00,5529260.55,165.00,5529260.55,0.00,'2022-07-27 19:14:12'),(128,'21','237',2,'Sale Id shift 77',0.00,24900523.20,720.00,24900523.20,0.00,'2022-07-27 20:57:18'),(129,'21','237',1,'Sale Id shift 77',0.00,5316945.15,165.00,5316945.15,0.00,'2022-07-27 20:57:18'),(130,'21','237',2,'Sale Id shift 78',0.00,18793965.60,720.00,18793965.60,0.00,'2022-07-30 10:51:55'),(131,'21','237',1,'Sale Id shift 78',0.00,4769674.80,165.00,4769674.80,0.00,'2022-07-30 10:51:55'),(132,'21','237',2,'Sale Id shift 79',0.00,20214208.80,720.00,20214208.80,0.00,'2022-07-31 16:43:51'),(133,'21','237',1,'Sale Id shift 79',0.00,5797184.25,165.00,5797184.25,0.00,'2022-07-31 16:43:51'),(134,'21','237',2,'Sale Id shift 80',0.00,23583376.80,720.00,23583376.80,0.00,'2022-07-31 18:58:02'),(135,'21','237',1,'Sale Id shift 80',0.00,5246283.90,165.00,5246283.90,0.00,'2022-07-31 18:58:02');
/*!40000 ALTER TABLE `inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ledgers`
--

DROP TABLE IF EXISTS `ledgers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ledgers` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` int NOT NULL AUTO_INCREMENT,
  `ledgertype` varchar(10) NOT NULL,
  `accounttype` varchar(50) NOT NULL,
  `accountid` varchar(50) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `details` varchar(1000) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `accounttype` (`accounttype`,`accountid`,`credit`,`debit`,`thedate`),
  KEY `cooperative` (`company_id`),
  KEY `depot_id` (`station_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=609 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ledgers`
--

LOCK TABLES `ledgers` WRITE;
/*!40000 ALTER TABLE `ledgers` DISABLE KEYS */;
INSERT INTO `ledgers` VALUES ('21','237',1,'','24','4',0.00,30284800.00,'Purchase Id 5 for 47,320.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-03-26 14:58:53','',''),('21','237',2,'','supplier','1',30284800.00,0.00,'Purchase Id 5 for 47,320.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-03-26 14:58:53','',''),('21','237',3,'','24','4',0.00,28800000.00,'Purchase Id 6 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-03-26 14:59:15','',''),('21','237',4,'','supplier','1',28800000.00,0.00,'Purchase Id 6 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-03-26 14:59:15','',''),('21','237',5,'','20','1',0.00,0.00,'Sales from shift 1 on 2022-03-26 16:07:41 ','2022-03-26 16:07:41','',''),('21','237',6,'','6.1','2',0.00,0.00,'Sales from shift 1 on 2022-03-26 16:07:41 ','2022-03-26 16:07:41','',''),('21','237',7,'','20','1',36788112.00,0.00,'Sales from shift 2 on 2022-03-26 18:03:53 ','2022-03-26 18:03:53','',''),('21','237',8,'','6.1','2',0.00,36788112.00,'Sales from shift 2 on 2022-03-26 18:03:53 ','2022-03-26 18:03:53','',''),('21','237',9,'','6.1','2',9500.00,0.00,'Payment Id 30 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:07:18','',''),('21','237',10,'','supplier','1',0.00,9500.00,'Payment Id 30 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:07:18','',''),('21','237',11,'','6.1','2',518400.00,0.00,'Payment Id 29 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:07:18','',''),('21','237',12,'','supplier','1',0.00,518400.00,'Payment Id 29 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:07:18','',''),('21','237',13,'','6.1','2',783000.00,0.00,'Payment Id 28 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:07:18','',''),('21','237',14,'','supplier','1',0.00,783000.00,'Payment Id 28 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:07:18','',''),('21','237',15,'','6.1','2',586000.00,0.00,'Payment Id 27 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:07:18','',''),('21','237',16,'','supplier','1',0.00,586000.00,'Payment Id 27 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:07:18','',''),('21','237',17,'','6.1','2',729600.00,0.00,'Payment Id 26 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:07:18','',''),('21','237',18,'','supplier','1',0.00,729600.00,'Payment Id 26 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:07:18','',''),('21','237',19,'','6.1','2',480000.00,0.00,'Payment Id 25 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:07:18','',''),('21','237',20,'','supplier','1',0.00,480000.00,'Payment Id 25 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:07:18','',''),('21','237',21,'','6.1','2',480000.00,0.00,'Payment Id 24 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:07:18','',''),('21','237',22,'','supplier','1',0.00,480000.00,'Payment Id 24 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:07:18','',''),('21','237',23,'','6.1','2',367000.00,0.00,'Payment Id 23 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:07:18','',''),('21','237',24,'','supplier','1',0.00,367000.00,'Payment Id 23 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:07:18','',''),('21','237',25,'','6.1','2',751000.00,0.00,'Payment Id 22 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:07:18','',''),('21','237',26,'','supplier','1',0.00,751000.00,'Payment Id 22 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:07:18','',''),('21','237',27,'','6.1','2',847000.00,0.00,'Payment Id 21 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:07:18','',''),('21','237',28,'','supplier','1',0.00,847000.00,'Payment Id 21 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:07:18','',''),('21','237',29,'','6.1','2',416000.00,0.00,'Payment Id 20 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:07:41','',''),('21','237',30,'','supplier','1',0.00,416000.00,'Payment Id 20 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:07:41','',''),('21','237',31,'','6.1','2',32000.00,0.00,'Payment Id 19 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:07:41','',''),('21','237',32,'','supplier','1',0.00,32000.00,'Payment Id 19 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:07:41','',''),('21','237',33,'','6.1','2',448000.00,0.00,'Payment Id 18 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:07:41','',''),('21','237',34,'','supplier','1',0.00,448000.00,'Payment Id 18 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:07:41','',''),('21','237',35,'','6.1','2',93500.00,0.00,'Payment Id 17 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:07:41','',''),('21','237',36,'','supplier','1',0.00,93500.00,'Payment Id 17 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:07:41','',''),('21','237',37,'','6.1','2',245000.00,0.00,'Payment Id 16 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:07:41','',''),('21','237',38,'','supplier','1',0.00,245000.00,'Payment Id 16 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:07:41','',''),('21','237',39,'','6.1','2',768000.00,0.00,'Payment Id 15 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:07:41','',''),('21','237',40,'','supplier','1',0.00,768000.00,'Payment Id 15 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:07:41','',''),('21','237',41,'','6.1','2',416000.00,0.00,'Payment Id 14 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:07:41','',''),('21','237',42,'','supplier','1',0.00,416000.00,'Payment Id 14 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:07:41','',''),('21','237',43,'','6.1','2',128000.00,0.00,'Payment Id 13 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:07:41','',''),('21','237',44,'','supplier','1',0.00,128000.00,'Payment Id 13 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:07:41','',''),('21','237',45,'','6.1','2',691200.00,0.00,'Payment Id 12 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:07:41','',''),('21','237',46,'','supplier','1',0.00,691200.00,'Payment Id 12 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:07:41','',''),('21','237',47,'','6.1','2',1715200.00,0.00,'Payment Id 11 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:07:41','',''),('21','237',48,'','supplier','1',0.00,1715200.00,'Payment Id 11 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:07:41','',''),('21','237',49,'','6.1','2',563200.00,0.00,'Payment Id 10 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:08:31','',''),('21','237',50,'','supplier','1',0.00,563200.00,'Payment Id 10 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:08:31','',''),('21','237',51,'','6.1','2',1500.00,0.00,'Payment Id 9 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:08:31','',''),('21','237',52,'','supplier','1',0.00,1500.00,'Payment Id 9 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:08:31','',''),('21','237',53,'','6.1','2',11000.00,0.00,'Payment Id 8 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:08:31','',''),('21','237',54,'','supplier','1',0.00,11000.00,'Payment Id 8 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:08:31','',''),('21','237',55,'','2','13',17604140.00,0.00,'Payment Id 7 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:08:31','',''),('21','237',56,'','supplier','1',0.00,17604140.00,'Payment Id 7 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:08:31','',''),('21','237',57,'','2','24',851000.00,0.00,'Payment Id 6 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:08:31','',''),('21','237',58,'','supplier','1',0.00,851000.00,'Payment Id 6 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:08:31','',''),('21','237',59,'','2','12',2959820.00,0.00,'Payment Id 5 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:08:31','',''),('21','237',60,'','supplier','1',0.00,2959820.00,'Payment Id 5 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:08:31','',''),('21','237',61,'','2','18',594923.00,0.00,'Payment Id 4 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:08:31','',''),('21','237',62,'','supplier','1',0.00,594923.00,'Payment Id 4 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:08:31','',''),('21','237',63,'','2','9',491034.20,0.00,'Payment Id 3 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:08:31','',''),('21','237',64,'','supplier','1',0.00,491034.20,'Payment Id 3 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:08:31','',''),('21','237',65,'','2','15',1508290.00,0.00,'Payment Id 2 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:08:31','',''),('21','237',66,'','supplier','1',0.00,1508290.00,'Payment Id 2 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:08:31','',''),('21','237',67,'','2','15',1698823.00,0.00,'Payment Id 1 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:08:31','',''),('21','237',68,'','supplier','1',0.00,1698823.00,'Payment Id 1 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-26 19:08:31','',''),('21','237',69,'','24','4',0.00,19200000.00,'Purchase Id 7 for 30,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-03-27 11:36:00','',''),('21','237',70,'','supplier','1',19200000.00,0.00,'Purchase Id 7 for 30,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-03-27 11:36:00','',''),('21','237',71,'','20','1',30830719.55,0.00,'Sales from shift 3 on 2022-03-27 12:31:04 ','2022-03-27 12:31:04','',''),('21','237',72,'','6.1','2',0.00,30830719.55,'Sales from shift 3 on 2022-03-27 12:31:04 ','2022-03-27 12:31:04','',''),('21','237',73,'','24','4',0.00,9600000.00,'Purchase Id 8 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-03-27 12:31:30','',''),('21','237',74,'','supplier','1',9600000.00,0.00,'Purchase Id 8 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-03-27 12:31:30','',''),('21','237',75,'','2','24',20.00,0.00,'Payment Id 68 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:44:23','',''),('21','237',76,'','supplier','1',0.00,20.00,'Payment Id 68 for invoice:2, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:44:23','',''),('21','237',77,'','2','24',73015.00,0.00,'Payment Id 67 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:44:23','',''),('21','237',78,'','supplier','1',0.00,73015.00,'Payment Id 67 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:44:23','',''),('21','237',79,'','2','24',106335.00,0.00,'Payment Id 66 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:44:23','',''),('21','237',80,'','supplier','1',0.00,106335.00,'Payment Id 66 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:44:23','',''),('21','237',81,'','6.1','2',47000.00,0.00,'Payment Id 65 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:44:23','',''),('21','237',82,'','supplier','1',0.00,47000.00,'Payment Id 65 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:44:23','',''),('21','237',83,'','6.1','2',73750.00,0.00,'Payment Id 64 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:44:23','',''),('21','237',84,'','supplier','1',0.00,73750.00,'Payment Id 64 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:44:23','',''),('21','237',85,'','2','13',14471800.00,0.00,'Payment Id 63 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:44:23','',''),('21','237',86,'','supplier','1',0.00,14471800.00,'Payment Id 63 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:44:23','',''),('21','237',87,'','6.1','2',64000.00,0.00,'Payment Id 62 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:44:23','',''),('21','237',88,'','supplier','1',0.00,64000.00,'Payment Id 62 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:44:23','',''),('21','237',89,'','6.1','2',128000.00,0.00,'Payment Id 61 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:44:23','',''),('21','237',90,'','supplier','1',0.00,128000.00,'Payment Id 61 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:44:23','',''),('21','237',91,'','6.1','2',153600.00,0.00,'Payment Id 59 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:44:23','',''),('21','237',92,'','supplier','1',0.00,153600.00,'Payment Id 59 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:44:23','',''),('21','237',93,'','6.1','2',64000.00,0.00,'Payment Id 58 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:44:24','',''),('21','237',94,'','supplier','1',0.00,64000.00,'Payment Id 58 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:44:24','',''),('21','237',95,'','6.1','2',64000.00,0.00,'Payment Id 57 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:44:42','',''),('21','237',96,'','supplier','1',0.00,64000.00,'Payment Id 57 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:44:42','',''),('21','237',97,'','6.1','2',64000.00,0.00,'Payment Id 56 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:44:42','',''),('21','237',98,'','supplier','1',0.00,64000.00,'Payment Id 56 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:44:42','',''),('21','237',99,'','6.1','2',431000.00,0.00,'Payment Id 55 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:44:42','',''),('21','237',100,'','supplier','1',0.00,431000.00,'Payment Id 55 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:44:42','',''),('21','237',101,'','6.1','2',847000.00,0.00,'Payment Id 54 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:44:42','',''),('21','237',102,'','supplier','1',0.00,847000.00,'Payment Id 54 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:44:42','',''),('21','237',103,'','6.1','2',64000.00,0.00,'Payment Id 53 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:44:42','',''),('21','237',104,'','supplier','1',0.00,64000.00,'Payment Id 53 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:44:42','',''),('21','237',105,'','6.1','2',448000.00,0.00,'Payment Id 52 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:44:42','',''),('21','237',106,'','supplier','1',0.00,448000.00,'Payment Id 52 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:44:42','',''),('21','237',107,'','6.1','2',495000.00,0.00,'Payment Id 51 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:44:42','',''),('21','237',108,'','supplier','1',0.00,495000.00,'Payment Id 51 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:44:42','',''),('21','237',109,'','6.1','2',64000.00,0.00,'Payment Id 50 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:44:42','',''),('21','237',110,'','supplier','1',0.00,64000.00,'Payment Id 50 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:44:42','',''),('21','237',111,'','6.1','2',320000.00,0.00,'Payment Id 49 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:44:42','',''),('21','237',112,'','supplier','1',0.00,320000.00,'Payment Id 49 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:44:42','',''),('21','237',113,'','6.1','2',448000.00,0.00,'Payment Id 48 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:44:42','',''),('21','237',114,'','supplier','1',0.00,448000.00,'Payment Id 48 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:44:42','',''),('21','237',115,'','6.1','2',64000.00,0.00,'Payment Id 47 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:45:06','',''),('21','237',116,'','supplier','1',0.00,64000.00,'Payment Id 47 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:45:06','',''),('21','237',117,'','6.1','2',128000.00,0.00,'Payment Id 46 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:45:06','',''),('21','237',118,'','supplier','1',0.00,128000.00,'Payment Id 46 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:45:06','',''),('21','237',119,'','6.1','2',64000.00,0.00,'Payment Id 45 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:45:07','',''),('21','237',120,'','supplier','1',0.00,64000.00,'Payment Id 45 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:45:07','',''),('21','237',121,'','6.1','2',128000.00,0.00,'Payment Id 44 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:45:07','',''),('21','237',122,'','supplier','1',0.00,128000.00,'Payment Id 44 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:45:07','',''),('21','237',123,'','6.1','2',320000.00,0.00,'Payment Id 43 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:45:07','',''),('21','237',124,'','supplier','1',0.00,320000.00,'Payment Id 43 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:45:07','',''),('21','237',125,'','6.1','2',1184000.00,0.00,'Payment Id 42 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:45:07','',''),('21','237',126,'','supplier','1',0.00,1184000.00,'Payment Id 42 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:45:07','',''),('21','237',127,'','6.1','2',2944000.00,0.00,'Payment Id 41 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:45:07','',''),('21','237',128,'','supplier','1',0.00,2944000.00,'Payment Id 41 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:45:07','',''),('21','237',129,'','6.1','2',1280000.00,0.00,'Payment Id 40 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:45:07','',''),('21','237',130,'','supplier','1',0.00,1280000.00,'Payment Id 40 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:45:07','',''),('21','237',131,'','6.1','2',2604800.00,0.00,'Payment Id 39 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:45:07','',''),('21','237',132,'','supplier','1',0.00,2604800.00,'Payment Id 39 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:45:07','',''),('21','237',133,'','6.1','2',838400.00,0.00,'Payment Id 38 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:45:07','',''),('21','237',134,'','supplier','1',0.00,838400.00,'Payment Id 38 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:45:07','',''),('21','237',135,'','6.1','2',390400.00,0.00,'Payment Id 37 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:45:32','',''),('21','237',136,'','supplier','1',0.00,390400.00,'Payment Id 37 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:45:32','',''),('21','237',137,'','2','18',1595340.00,0.00,'Payment Id 35 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:45:32','',''),('21','237',138,'','supplier','1',0.00,1595340.00,'Payment Id 35 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:45:32','',''),('21','237',139,'','2','9',10000.00,0.00,'Payment Id 34 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:45:32','',''),('21','237',140,'','supplier','1',0.00,10000.00,'Payment Id 34 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:45:32','',''),('21','237',141,'','2','9',269480.00,0.00,'Payment Id 33 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:45:32','',''),('21','237',142,'','supplier','1',0.00,269480.00,'Payment Id 33 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:45:32','',''),('21','237',143,'','2','15',402170.00,0.00,'Payment Id 32 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:45:32','',''),('21','237',144,'','supplier','1',0.00,402170.00,'Payment Id 32 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:45:32','',''),('21','237',145,'','2','15',381630.00,0.00,'Payment Id 31 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:45:32','',''),('21','237',146,'','supplier','1',0.00,381630.00,'Payment Id 31 for invoice:3, receipt:  by AYM SHAFA NIGERIA. LTD','2022-03-27 13:45:32','',''),('21','237',147,'','24','4',0.00,9600000.00,'Purchase Id 13 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-03-28 15:11:49','',''),('21','237',148,'','supplier','1',9600000.00,0.00,'Purchase Id 13 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-03-28 15:11:49','',''),('21','237',149,'','24','4',0.00,32000000.00,'Purchase Id 12 for 50,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-03-28 15:13:55','',''),('21','237',150,'','supplier','1',32000000.00,0.00,'Purchase Id 12 for 50,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-03-28 15:13:55','',''),('21','237',151,'','24','4',0.00,7425000.00,'Purchase Id 11 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-03-28 15:16:21','',''),('21','237',152,'','supplier','1',7425000.00,0.00,'Purchase Id 11 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-03-28 15:16:21','',''),('21','237',153,'','24','4',0.00,7425000.00,'Purchase Id 10 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-03-28 15:17:47','',''),('21','237',154,'','supplier','1',7425000.00,0.00,'Purchase Id 10 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-03-28 15:17:47','',''),('21','237',155,'','24','4',0.00,7425000.00,'Purchase Id 9 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-03-28 15:20:21','',''),('21','237',156,'','supplier','1',7425000.00,0.00,'Purchase Id 9 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-03-28 15:20:21','',''),('21','237',157,'','20','1',0.00,0.00,'Sales from shift 4 on 2022-03-31 17:48:42 ','2022-03-31 17:48:42','',''),('21','237',158,'','6.1','2',0.00,0.00,'Sales from shift 4 on 2022-03-31 17:48:42 ','2022-03-31 17:48:42','',''),('21','237',159,'','20','1',25417176.35,0.00,'Sales from shift 5 on 2022-03-31 18:09:16 ','2022-03-31 18:09:16','',''),('21','237',160,'','6.1','2',0.00,25417176.35,'Sales from shift 5 on 2022-03-31 18:09:16 ','2022-03-31 18:09:16','',''),('21','237',161,'','2','24',5062110.00,0.00,'Payment Id 83 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:47:30','',''),('21','237',162,'','supplier','1',0.00,5062110.00,'Payment Id 83 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:47:30','',''),('21','237',163,'','6.1','2',960000.00,0.00,'Payment Id 82 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:47:30','',''),('21','237',164,'','supplier','1',0.00,960000.00,'Payment Id 82 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:47:30','',''),('21','237',165,'','6.1','2',64000.00,0.00,'Payment Id 81 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:47:30','',''),('21','237',166,'','supplier','1',0.00,64000.00,'Payment Id 81 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:47:30','',''),('21','237',167,'','6.1','2',1088000.00,0.00,'Payment Id 80 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:47:30','',''),('21','237',168,'','supplier','1',0.00,1088000.00,'Payment Id 80 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:47:30','',''),('21','237',169,'','6.1','2',64000.00,0.00,'Payment Id 79 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:47:30','',''),('21','237',170,'','supplier','1',0.00,64000.00,'Payment Id 79 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:47:30','',''),('21','237',171,'','6.1','2',562340.00,0.00,'Payment Id 78 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:47:30','',''),('21','237',172,'','supplier','1',0.00,562340.00,'Payment Id 78 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:47:30','',''),('21','237',173,'','6.1','2',448000.00,0.00,'Payment Id 77 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:47:30','',''),('21','237',174,'','supplier','1',0.00,448000.00,'Payment Id 77 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:47:30','',''),('21','237',175,'','6.1','2',115200.00,0.00,'Payment Id 76 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:47:30','',''),('21','237',176,'','supplier','1',0.00,115200.00,'Payment Id 76 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:47:30','',''),('21','237',177,'','2','18',863025.00,0.00,'Payment Id 75 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:47:30','',''),('21','237',178,'','supplier','1',0.00,863025.00,'Payment Id 75 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:47:30','',''),('21','237',179,'','2','9',1480446.00,0.00,'Payment Id 74 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:47:30','',''),('21','237',180,'','supplier','1',0.00,1480446.00,'Payment Id 74 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:47:30','',''),('21','237',181,'','2','15',2461435.00,0.00,'Payment Id 73 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:47:52','',''),('21','237',182,'','supplier','1',0.00,2461435.00,'Payment Id 73 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:47:52','',''),('21','237',183,'','2','13',10572215.00,0.00,'Payment Id 72 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:47:52','',''),('21','237',184,'','supplier','1',0.00,10572215.00,'Payment Id 72 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:47:52','',''),('21','237',185,'','6.1','2',19400.00,0.00,'Payment Id 71 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:47:52','',''),('21','237',186,'','supplier','1',0.00,19400.00,'Payment Id 71 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:47:52','',''),('21','237',187,'','6.1','2',874000.00,0.00,'Payment Id 70 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:47:52','',''),('21','237',188,'','supplier','1',0.00,874000.00,'Payment Id 70 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:47:52','',''),('21','237',189,'','6.1','2',847000.00,0.00,'Payment Id 69 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:47:52','',''),('21','237',190,'','supplier','1',0.00,847000.00,'Payment Id 69 for invoice:5, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-04 16:47:52','',''),('21','237',191,'','20','1',24252097.50,0.00,'Sales from shift 6 on 2022-04-05 12:26:35 ','2022-04-05 12:26:35','',''),('21','237',192,'','6.1','2',0.00,24252097.50,'Sales from shift 6 on 2022-04-05 12:26:35 ','2022-04-05 12:26:35','',''),('21','237',193,'','24','4',0.00,28800000.00,'Purchase Id 14 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-04-05 12:34:23','',''),('21','237',194,'','supplier','1',28800000.00,0.00,'Purchase Id 14 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-04-05 12:34:23','',''),('21','237',195,'','2','13',16373450.00,0.00,'Payment Id 100 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 17:00:32','',''),('21','237',196,'','supplier','1',0.00,16373450.00,'Payment Id 100 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 17:00:32','',''),('21','237',197,'','2','24',328680.00,0.00,'Payment Id 99 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 17:00:32','',''),('21','237',198,'','supplier','1',0.00,328680.00,'Payment Id 99 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 17:00:32','',''),('21','237',199,'','6.1','2',3115.00,0.00,'Payment Id 98 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 17:00:32','',''),('21','237',200,'','supplier','1',0.00,3115.00,'Payment Id 98 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 17:00:32','',''),('21','237',201,'','6.1','2',21000.00,0.00,'Payment Id 97 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 17:00:32','',''),('21','237',202,'','supplier','1',0.00,21000.00,'Payment Id 97 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 17:00:32','',''),('21','237',203,'','6.1','2',448000.00,0.00,'Payment Id 96 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 17:00:32','',''),('21','237',204,'','supplier','1',0.00,448000.00,'Payment Id 96 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 17:00:32','',''),('21','237',205,'','6.1','2',352000.00,0.00,'Payment Id 95 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 17:00:32','',''),('21','237',206,'','supplier','1',0.00,352000.00,'Payment Id 95 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 17:00:32','',''),('21','237',207,'','6.1','2',384000.00,0.00,'Payment Id 94 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 17:00:32','',''),('21','237',208,'','supplier','1',0.00,384000.00,'Payment Id 94 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 17:00:32','',''),('21','237',209,'','6.1','2',416000.00,0.00,'Payment Id 93 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 17:00:32','',''),('21','237',210,'','supplier','1',0.00,416000.00,'Payment Id 93 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 17:00:32','',''),('21','237',211,'','6.1','2',512000.00,0.00,'Payment Id 92 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 17:00:32','',''),('21','237',212,'','supplier','1',0.00,512000.00,'Payment Id 92 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 17:00:32','',''),('21','237',213,'','6.1','2',96000.00,0.00,'Payment Id 91 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 17:00:32','',''),('21','237',214,'','supplier','1',0.00,96000.00,'Payment Id 91 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 17:00:32','',''),('21','237',215,'','6.1','2',448000.00,0.00,'Payment Id 90 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 17:01:09','',''),('21','237',216,'','supplier','1',0.00,448000.00,'Payment Id 90 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 17:01:09','',''),('21','237',217,'','6.1','2',192000.00,0.00,'Payment Id 89 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 17:01:09','',''),('21','237',218,'','supplier','1',0.00,192000.00,'Payment Id 89 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 17:01:09','',''),('21','237',219,'','6.1','2',128000.00,0.00,'Payment Id 88 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 17:01:09','',''),('21','237',220,'','supplier','1',0.00,128000.00,'Payment Id 88 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 17:01:09','',''),('21','237',221,'','6.1','2',3300.00,0.00,'Payment Id 87 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 17:01:09','',''),('21','237',222,'','supplier','1',0.00,3300.00,'Payment Id 87 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 17:01:09','',''),('21','237',223,'','2','18',1782592.62,0.00,'Payment Id 86 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 17:01:09','',''),('21','237',224,'','supplier','1',0.00,1782592.62,'Payment Id 86 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 17:01:09','',''),('21','237',225,'','2','9',587900.00,0.00,'Payment Id 85 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 17:01:09','',''),('21','237',226,'','supplier','1',0.00,587900.00,'Payment Id 85 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 17:01:09','',''),('21','237',227,'','2','15',2176312.19,0.00,'Payment Id 84 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 17:01:09','',''),('21','237',228,'','supplier','1',0.00,2176312.19,'Payment Id 84 for invoice:6, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-05 17:01:09','',''),('21','237',229,'','20','1',20532513.05,0.00,'Sales from shift 7 on 2022-04-12 11:05:50 ','2022-04-12 11:05:50','',''),('21','237',230,'','6.1','2',0.00,20532513.05,'Sales from shift 7 on 2022-04-12 11:05:50 ','2022-04-12 11:05:50','',''),('21','237',231,'','24','4',0.00,28800000.00,'Purchase Id 17 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-04-12 11:54:24','',''),('21','237',232,'','supplier','1',28800000.00,0.00,'Purchase Id 17 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-04-12 11:54:24','',''),('21','237',233,'','24','4',0.00,6600000.00,'Purchase Id 16 for 40,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-12 11:56:48','',''),('21','237',234,'','supplier','1',6600000.00,0.00,'Purchase Id 16 for 40,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-12 11:56:48','',''),('21','237',235,'','24','4',0.00,7425000.00,'Purchase Id 15 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-12 11:59:35','',''),('21','237',236,'','supplier','1',7425000.00,0.00,'Purchase Id 15 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-12 11:59:35','',''),('21','237',237,'','24','4',0.00,9900000.00,'Purchase Id 18 for 60,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-12 12:03:09','',''),('21','237',238,'','supplier','1',9900000.00,0.00,'Purchase Id 18 for 60,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-04-12 12:03:09','',''),('21','237',239,'','2','24',1140620.00,0.00,'Payment Id 102 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-12 18:35:36','',''),('21','237',240,'','supplier','1',0.00,1140620.00,'Payment Id 102 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-12 18:35:36','',''),('21','237',241,'','2','18',1375420.00,0.00,'Payment Id 104 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-12 19:06:50','',''),('21','237',242,'','supplier','1',0.00,1375420.00,'Payment Id 104 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-12 19:06:50','',''),('21','237',243,'','2','24',4888630.00,0.00,'Payment Id 107 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-12 19:14:37','',''),('21','237',244,'','supplier','1',0.00,4888630.00,'Payment Id 107 for invoice:8, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-12 19:14:37','',''),('21','237',245,'','20','1',24493549.50,0.00,'Sales from shift 8 on 2022-04-14 17:21:04 ','2022-04-14 17:21:04','',''),('21','237',246,'','6.1','2',0.00,24493549.50,'Sales from shift 8 on 2022-04-14 17:21:04 ','2022-04-14 17:21:04','',''),('21','237',247,'','20','1',36715896.40,0.00,'Sales from shift 9 on 2022-04-14 17:48:57 ','2022-04-14 17:48:57','',''),('21','237',248,'','6.1','2',0.00,36715896.40,'Sales from shift 9 on 2022-04-14 17:48:57 ','2022-04-14 17:48:57','',''),('21','237',249,'','2','24',2450000.00,0.00,'Payment Id 120 for invoice:9, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-22 09:51:32','',''),('21','237',250,'','supplier','1',0.00,2450000.00,'Payment Id 120 for invoice:9, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-22 09:51:32','',''),('21','237',251,'','2','18',240154.00,0.00,'Payment Id 124 for invoice:9, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-22 09:52:40','',''),('21','237',252,'','supplier','1',0.00,240154.00,'Payment Id 124 for invoice:9, receipt:  by AYM SHAFA NIGERIA. LTD','2022-04-22 09:52:40','',''),('21','237',253,'','24','4',0.00,8640000.00,'Purchase Id 21 for 13,500.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-04-26 11:09:15','',''),('21','237',254,'','supplier','1',8640000.00,0.00,'Purchase Id 21 for 13,500.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-04-26 11:09:15','',''),('21','237',255,'','20','1',0.00,0.00,'Sales from shift 10 on 2022-04-27 15:16:15 ','2022-04-27 15:16:15','',''),('21','237',256,'','6.1','2',0.00,0.00,'Sales from shift 10 on 2022-04-27 15:16:15 ','2022-04-27 15:16:15','',''),('21','237',257,'','20','1',38513458.75,0.00,'Sales from shift 11 on 2022-04-28 15:11:22 ','2022-04-28 15:11:22','',''),('21','237',258,'','6.1','2',0.00,38513458.75,'Sales from shift 11 on 2022-04-28 15:11:22 ','2022-04-28 15:11:22','',''),('21','237',259,'','24','4',0.00,28800000.00,'Purchase Id 25 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-04-29 12:26:44','',''),('21','237',260,'','supplier','1',28800000.00,0.00,'Purchase Id 25 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-04-29 12:26:44','',''),('21','237',261,'','24','4',0.00,28800000.00,'Purchase Id 24 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-04-29 12:28:10','',''),('21','237',262,'','supplier','1',28800000.00,0.00,'Purchase Id 24 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-04-29 12:28:10','',''),('21','237',263,'','20','1',29788174.45,0.00,'Sales from shift 12 on 2022-04-30 19:37:52 ','2022-04-30 19:37:52','',''),('21','237',264,'','6.1','2',0.00,29788174.45,'Sales from shift 12 on 2022-04-30 19:37:52 ','2022-04-30 19:37:52','',''),('21','237',265,'','24','4',0.00,9900000.00,'Purchase Id 26 for 60,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-06 15:13:04','',''),('21','237',266,'','supplier','1',9900000.00,0.00,'Purchase Id 26 for 60,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-06 15:13:04','',''),('21','237',267,'','20','1',0.00,0.00,'Sales from shift 13 on 2022-05-08 10:41:08 ','2022-05-08 10:41:08','',''),('21','237',268,'','6.1','2',0.00,0.00,'Sales from shift 13 on 2022-05-08 10:41:08 ','2022-05-08 10:41:08','',''),('21','237',269,'','20','1',30654861.20,0.00,'Sales from shift 14 on 2022-05-09 08:44:12 ','2022-05-09 08:44:12','',''),('21','237',270,'','6.1','2',0.00,30654861.20,'Sales from shift 14 on 2022-05-09 08:44:12 ','2022-05-09 08:44:12','',''),('21','237',271,'','2','24',1201866.85,0.00,'Payment Id 165 for invoice:12, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-09 08:58:55','',''),('21','237',272,'','supplier','1',0.00,1201866.85,'Payment Id 165 for invoice:12, receipt:  by AYM SHAFA NIGERIA. LTD','2022-05-09 08:58:55','',''),('21','237',273,'','20','1',31634567.90,0.00,'Sales from shift 15 on 2022-05-14 09:56:18 ','2022-05-14 09:56:18','',''),('21','237',274,'','6.1','2',0.00,31634567.90,'Sales from shift 15 on 2022-05-14 09:56:18 ','2022-05-14 09:56:18','',''),('21','237',275,'','24','4',0.00,5775000.00,'Purchase Id 28 for 35,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-14 10:45:38','',''),('21','237',276,'','supplier','1',5775000.00,0.00,'Purchase Id 28 for 35,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-14 10:45:38','',''),('21','237',277,'','24','4',0.00,32000000.00,'Purchase Id 30 for 50,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-14 12:46:24','',''),('21','237',278,'','supplier','1',32000000.00,0.00,'Purchase Id 30 for 50,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-14 12:46:24','',''),('21','237',279,'','24','4',0.00,6600000.00,'Purchase Id 29 for 40,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-14 12:54:22','',''),('21','237',280,'','supplier','1',6600000.00,0.00,'Purchase Id 29 for 40,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-14 12:54:22','',''),('21','237',281,'','20','1',33859192.45,0.00,'Sales from shift 16 on 2022-05-14 14:14:36 ','2022-05-14 14:14:36','',''),('21','237',282,'','6.1','2',0.00,33859192.45,'Sales from shift 16 on 2022-05-14 14:14:36 ','2022-05-14 14:14:36','',''),('21','237',283,'','24','4',0.00,28800000.00,'Purchase Id 33 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-14 14:22:57','',''),('21','237',284,'','supplier','1',28800000.00,0.00,'Purchase Id 33 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-14 14:22:57','',''),('21','237',285,'','24','4',0.00,7425000.00,'Purchase Id 32 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-14 14:27:08','',''),('21','237',286,'','supplier','1',7425000.00,0.00,'Purchase Id 32 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-14 14:27:08','',''),('21','237',287,'','24','4',0.00,7425000.00,'Purchase Id 31 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-14 14:32:14','',''),('21','237',288,'','supplier','1',7425000.00,0.00,'Purchase Id 31 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-14 14:32:14','',''),('21','237',289,'','20','1',37502849.15,0.00,'Sales from shift 17 on 2022-05-14 17:01:20 ','2022-05-14 17:01:20','',''),('21','237',290,'','6.1','2',0.00,37502849.15,'Sales from shift 17 on 2022-05-14 17:01:20 ','2022-05-14 17:01:20','',''),('21','237',291,'','24','4',0.00,32000000.00,'Purchase Id 34 for 50,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-15 11:33:32','',''),('21','237',292,'','supplier','1',32000000.00,0.00,'Purchase Id 34 for 50,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-15 11:33:32','',''),('21','237',293,'','20','1',32775703.30,0.00,'Sales from shift 18 on 2022-05-15 12:37:11 ','2022-05-15 12:37:11','',''),('21','237',294,'','6.1','2',0.00,32775703.30,'Sales from shift 18 on 2022-05-15 12:37:11 ','2022-05-15 12:37:11','',''),('21','237',295,'','24','4',0.00,28800000.00,'Purchase Id 37 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-15 12:47:43','',''),('21','237',296,'','supplier','1',28800000.00,0.00,'Purchase Id 37 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-15 12:47:43','',''),('21','237',297,'','24','4',0.00,8580000.00,'Purchase Id 36 for 52,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-15 12:51:15','',''),('21','237',298,'','supplier','1',8580000.00,0.00,'Purchase Id 36 for 52,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-15 12:51:15','',''),('21','237',299,'','24','4',0.00,32000000.00,'Purchase Id 35 for 50,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-15 12:53:53','',''),('21','237',300,'','supplier','1',32000000.00,0.00,'Purchase Id 35 for 50,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-15 12:53:53','',''),('21','237',301,'','20','1',31005409.60,0.00,'Sales from shift 19 on 2022-05-15 14:20:57 ','2022-05-15 14:20:57','',''),('21','237',302,'','6.1','2',0.00,31005409.60,'Sales from shift 19 on 2022-05-15 14:20:57 ','2022-05-15 14:20:57','',''),('21','237',303,'','20','1',17562042.35,0.00,'Sales from shift 20 on 2022-05-17 11:21:45 ','2022-05-17 11:21:45','',''),('21','237',304,'','6.1','2',0.00,17562042.35,'Sales from shift 20 on 2022-05-17 11:21:45 ','2022-05-17 11:21:45','',''),('21','237',305,'','24','4',0.00,28800000.00,'Purchase Id 40 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-17 14:54:09','',''),('21','237',306,'','supplier','1',28800000.00,0.00,'Purchase Id 40 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-17 14:54:09','',''),('21','237',307,'','24','4',0.00,7425000.00,'Purchase Id 39 for 40,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-17 14:58:53','',''),('21','237',308,'','supplier','1',7425000.00,0.00,'Purchase Id 39 for 40,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-17 14:58:53','',''),('21','237',309,'','24','4',0.00,7425000.00,'Purchase Id 38 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-17 15:01:36','',''),('21','237',310,'','supplier','1',7425000.00,0.00,'Purchase Id 38 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-17 15:01:36','',''),('21','237',311,'','20','1',37182473.60,0.00,'Sales from shift 21 on 2022-05-17 16:24:58 ','2022-05-17 16:24:58','',''),('21','237',312,'','6.1','2',0.00,37182473.60,'Sales from shift 21 on 2022-05-17 16:24:58 ','2022-05-17 16:24:58','',''),('21','237',313,'','24','4',0.00,28800000.00,'Purchase Id 41 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-18 17:03:50','',''),('21','237',314,'','supplier','1',28800000.00,0.00,'Purchase Id 41 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-18 17:03:50','',''),('21','237',315,'','24','4',0.00,7425000.00,'Purchase Id 42 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-18 17:07:01','',''),('21','237',316,'','supplier','1',7425000.00,0.00,'Purchase Id 42 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-18 17:07:01','',''),('21','237',317,'','20','1',35919232.65,0.00,'Sales from shift 22 on 2022-05-19 14:26:55 ','2022-05-19 14:26:55','',''),('21','237',318,'','6.1','2',0.00,35919232.65,'Sales from shift 22 on 2022-05-19 14:26:55 ','2022-05-19 14:26:55','',''),('21','237',319,'','24','4',0.00,7425000.00,'Purchase Id 43 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-19 14:43:05','',''),('21','237',320,'','supplier','1',7425000.00,0.00,'Purchase Id 43 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-19 14:43:05','',''),('21','237',321,'','20','1',33130399.30,0.00,'Sales from shift 23 on 2022-05-19 17:30:16 ','2022-05-19 17:30:16','',''),('21','237',322,'','6.1','2',0.00,33130399.30,'Sales from shift 23 on 2022-05-19 17:30:16 ','2022-05-19 17:30:16','',''),('21','237',323,'','24','4',0.00,8250000.00,'Purchase Id 44 for 50,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-19 17:34:29','',''),('21','237',324,'','supplier','1',8250000.00,0.00,'Purchase Id 44 for 50,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-19 17:34:29','',''),('21','237',325,'','24','4',0.00,32000000.00,'Purchase Id 45 for 50,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-19 17:36:47','',''),('21','237',326,'','supplier','1',32000000.00,0.00,'Purchase Id 45 for 50,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-19 17:36:47','',''),('21','237',327,'','24','4',0.00,32000000.00,'Purchase Id 46 for 50,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-19 17:39:24','',''),('21','237',328,'','supplier','1',32000000.00,0.00,'Purchase Id 46 for 50,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-19 17:39:24','',''),('21','237',329,'','20','1',36779739.70,0.00,'Sales from shift 24 on 2022-05-19 19:12:43 ','2022-05-19 19:12:43','',''),('21','237',330,'','6.1','2',0.00,36779739.70,'Sales from shift 24 on 2022-05-19 19:12:43 ','2022-05-19 19:12:43','',''),('21','237',331,'','24','4',0.00,7425000.00,'Purchase Id 48 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-19 19:22:20','',''),('21','237',332,'','supplier','1',7425000.00,0.00,'Purchase Id 48 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-19 19:22:20','',''),('21','237',333,'','24','4',0.00,7425000.00,'Purchase Id 47 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-19 19:23:40','',''),('21','237',334,'','supplier','1',7425000.00,0.00,'Purchase Id 47 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-19 19:23:40','',''),('21','237',335,'','20','1',39573877.95,0.00,'Sales from shift 25 on 2022-05-20 19:29:27 ','2022-05-20 19:29:27','',''),('21','237',336,'','6.1','2',0.00,39573877.95,'Sales from shift 25 on 2022-05-20 19:29:27 ','2022-05-20 19:29:27','',''),('21','237',337,'','24','4',0.00,9600000.00,'Purchase Id 49 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-23 17:24:07','',''),('21','237',338,'','supplier','1',9600000.00,0.00,'Purchase Id 49 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-23 17:24:07','',''),('21','237',339,'','24','4',0.00,32000000.00,'Purchase Id 50 for 50,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-23 17:26:40','',''),('21','237',340,'','supplier','1',32000000.00,0.00,'Purchase Id 50 for 50,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-23 17:26:40','',''),('21','237',341,'','24','4',0.00,6600000.00,'Purchase Id 51 for 40,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-26 19:35:04','',''),('21','237',342,'','supplier','1',6600000.00,0.00,'Purchase Id 51 for 40,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-26 19:35:04','',''),('21','237',343,'','20','1',32878500.05,0.00,'Sales from shift 26 on 2022-05-27 15:08:21 ','2022-05-27 15:08:21','',''),('21','237',344,'','6.1','2',0.00,32878500.05,'Sales from shift 26 on 2022-05-27 15:08:21 ','2022-05-27 15:08:21','',''),('21','237',345,'','24','4',0.00,9900000.00,'Purchase Id 52 for 60,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-30 19:51:01','',''),('21','237',346,'','supplier','1',9900000.00,0.00,'Purchase Id 52 for 60,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-30 19:51:01','',''),('21','237',347,'','24','4',0.00,7425000.00,'Purchase Id 53 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-30 19:54:40','',''),('21','237',348,'','supplier','1',7425000.00,0.00,'Purchase Id 53 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-30 19:54:40','',''),('21','237',349,'','24','4',0.00,20672000.00,'Purchase Id 54 for 32,300.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-30 19:56:27','',''),('21','237',350,'','supplier','1',20672000.00,0.00,'Purchase Id 54 for 32,300.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-30 19:56:27','',''),('21','237',351,'','20','1',27010766.55,0.00,'Sales from shift 27 on 2022-05-31 11:32:55 ','2022-05-31 11:32:55','',''),('21','237',352,'','6.1','2',0.00,27010766.55,'Sales from shift 27 on 2022-05-31 11:32:55 ','2022-05-31 11:32:55','',''),('21','237',353,'','20','1',33414767.45,0.00,'Sales from shift 28 on 2022-05-31 15:48:29 ','2022-05-31 15:48:29','',''),('21','237',354,'','6.1','2',0.00,33414767.45,'Sales from shift 28 on 2022-05-31 15:48:29 ','2022-05-31 15:48:29','',''),('21','237',355,'','24','4',0.00,8250000.00,'Purchase Id 56 for 50,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-31 16:31:31','',''),('21','237',356,'','supplier','1',8250000.00,0.00,'Purchase Id 56 for 50,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-31 16:31:31','',''),('21','237',357,'','24','4',0.00,38400000.00,'Purchase Id 57 for 60,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-31 16:43:26','',''),('21','237',358,'','supplier','1',38400000.00,0.00,'Purchase Id 57 for 60,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-31 16:43:26','',''),('21','237',359,'','24','4',0.00,28800000.00,'Purchase Id 58 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-31 16:45:01','',''),('21','237',360,'','supplier','1',28800000.00,0.00,'Purchase Id 58 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-05-31 16:45:01','',''),('21','237',361,'','20','1',36359419.90,0.00,'Sales from shift 29 on 2022-05-31 18:28:07 ','2022-05-31 18:28:07','',''),('21','237',362,'','6.1','2',0.00,36359419.90,'Sales from shift 29 on 2022-05-31 18:28:07 ','2022-05-31 18:28:07','',''),('21','237',363,'','24','4',0.00,4950000.00,'Purchase Id 55 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-31 18:28:34','',''),('21','237',364,'','supplier','1',4950000.00,0.00,'Purchase Id 55 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-05-31 18:28:34','',''),('21','237',365,'','20','1',41101926.06,0.00,'Sales from shift 30 on 2022-06-01 05:55:50 ','2022-06-01 05:55:50','',''),('21','237',366,'','6.1','2',0.00,41101926.06,'Sales from shift 30 on 2022-06-01 05:55:50 ','2022-06-01 05:55:50','',''),('21','237',367,'','24','4',0.00,7425000.00,'Purchase Id 60 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-01 09:28:11','',''),('21','237',368,'','supplier','1',7425000.00,0.00,'Purchase Id 60 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-01 09:28:11','',''),('21','237',369,'','24','4',0.00,32000000.00,'Purchase Id 59 for 50,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-01 09:30:00','',''),('21','237',370,'','supplier','1',32000000.00,0.00,'Purchase Id 59 for 50,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-01 09:30:00','',''),('21','237',371,'','20','1',0.00,0.00,'Sales from shift 31 on 2022-06-02 11:24:30 ','2022-06-02 11:24:30','',''),('21','237',372,'','6.1','2',0.00,0.00,'Sales from shift 31 on 2022-06-02 11:24:30 ','2022-06-02 11:24:30','',''),('21','237',373,'','20','1',38681448.05,0.00,'Sales from shift 32 on 2022-06-02 11:54:27 ','2022-06-02 11:54:27','',''),('21','237',374,'','6.1','2',0.00,38681448.05,'Sales from shift 32 on 2022-06-02 11:54:27 ','2022-06-02 11:54:27','',''),('21','237',375,'','24','4',0.00,7425000.00,'Purchase Id 61 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-02 11:57:36','',''),('21','237',376,'','supplier','1',7425000.00,0.00,'Purchase Id 61 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-02 11:57:36','',''),('21','237',377,'','24','4',0.00,28800000.00,'Purchase Id 62 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-02 11:59:15','',''),('21','237',378,'','supplier','1',28800000.00,0.00,'Purchase Id 62 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-02 11:59:15','',''),('21','237',379,'','24','4',0.00,32000000.00,'Purchase Id 63 for 50,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-02 12:00:37','',''),('21','237',380,'','supplier','1',32000000.00,0.00,'Purchase Id 63 for 50,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-02 12:00:37','',''),('21','237',381,'','24','4',0.00,7425000.00,'Purchase Id 64 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-02 12:51:54','',''),('21','237',382,'','supplier','1',7425000.00,0.00,'Purchase Id 64 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-02 12:51:54','',''),('21','237',383,'','24','4',0.00,32000000.00,'Purchase Id 65 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-02 12:54:17','',''),('21','237',384,'','supplier','1',32000000.00,0.00,'Purchase Id 65 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-02 12:54:17','',''),('21','237',385,'','20','1',38398414.15,0.00,'Sales from shift 33 on 2022-06-02 13:22:39 ','2022-06-02 13:22:39','',''),('21','237',386,'','6.1','2',0.00,38398414.15,'Sales from shift 33 on 2022-06-02 13:22:39 ','2022-06-02 13:22:39','',''),('21','237',387,'','20','1',41991489.85,0.00,'Sales from shift 34 on 2022-06-02 16:34:16 ','2022-06-02 16:34:16','',''),('21','237',388,'','6.1','2',0.00,41991489.85,'Sales from shift 34 on 2022-06-02 16:34:16 ','2022-06-02 16:34:16','',''),('21','237',389,'','24','4',0.00,8250000.00,'Purchase Id 66 for 50,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-02 20:35:29','',''),('21','237',390,'','supplier','1',8250000.00,0.00,'Purchase Id 66 for 50,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-02 20:35:29','',''),('21','237',391,'','24','4',0.00,13888000.00,'Purchase Id 67 for 21,700.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-02 20:36:57','',''),('21','237',392,'','supplier','1',13888000.00,0.00,'Purchase Id 67 for 21,700.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-02 20:36:57','',''),('21','237',393,'','20','1',31274203.05,0.00,'Sales from shift 35 on 2022-06-02 22:13:43 ','2022-06-02 22:13:43','',''),('21','237',394,'','6.1','2',0.00,31274203.05,'Sales from shift 35 on 2022-06-02 22:13:43 ','2022-06-02 22:13:43','',''),('21','237',395,'','24','4',0.00,7425000.00,'Purchase Id 69 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-02 22:25:27','',''),('21','237',396,'','supplier','1',7425000.00,0.00,'Purchase Id 69 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-02 22:25:27','',''),('21','237',397,'','24','4',0.00,32000000.00,'Purchase Id 68 for 50,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-02 22:27:03','',''),('21','237',398,'','supplier','1',32000000.00,0.00,'Purchase Id 68 for 50,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-02 22:27:03','',''),('21','237',399,'','20','1',30392553.95,0.00,'Sales from shift 36 on 2022-06-03 05:37:24 ','2022-06-03 05:37:24','',''),('21','237',400,'','6.1','2',0.00,30392553.95,'Sales from shift 36 on 2022-06-03 05:37:24 ','2022-06-03 05:37:24','',''),('21','237',401,'','20','1',0.00,0.00,'Sales from shift 37 on 2022-06-04 19:50:11 ','2022-06-04 19:50:11','',''),('21','237',402,'','6.1','2',0.00,0.00,'Sales from shift 37 on 2022-06-04 19:50:11 ','2022-06-04 19:50:11','',''),('21','237',403,'','20','1',44042233.70,0.00,'Sales from shift 38 on 2022-06-05 09:37:58 ','2022-06-05 09:37:58','',''),('21','237',404,'','6.1','2',0.00,44042233.70,'Sales from shift 38 on 2022-06-05 09:37:58 ','2022-06-05 09:37:58','',''),('21','237',405,'','24','4',0.00,7425000.00,'Purchase Id 70 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-05 11:07:05','',''),('21','237',406,'','supplier','1',7425000.00,0.00,'Purchase Id 70 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-05 11:07:05','',''),('21','237',407,'','20','1',29113854.40,0.00,'Sales from shift 39 on 2022-06-06 08:42:26 ','2022-06-06 08:42:26','',''),('21','237',408,'','6.1','2',0.00,29113854.40,'Sales from shift 39 on 2022-06-06 08:42:26 ','2022-06-06 08:42:26','',''),('21','237',409,'','24','4',0.00,7425000.00,'Purchase Id 71 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-06 08:49:07','',''),('21','237',410,'','supplier','1',7425000.00,0.00,'Purchase Id 71 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-06 08:49:07','',''),('21','237',411,'','20','1',6713531.55,0.00,'Sales from shift 40 on 2022-06-06 09:32:08 ','2022-06-06 09:32:08','',''),('21','237',412,'','6.1','2',0.00,6713531.55,'Sales from shift 40 on 2022-06-06 09:32:08 ','2022-06-06 09:32:08','',''),('21','237',413,'','24','4',0.00,8250000.00,'Purchase Id 72 for 50,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-06 09:32:49','',''),('21','237',414,'','supplier','1',8250000.00,0.00,'Purchase Id 72 for 50,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-06 09:32:49','',''),('21','237',415,'','24','4',0.00,7425000.00,'Purchase Id 73 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-06 16:34:29','',''),('21','237',416,'','supplier','1',7425000.00,0.00,'Purchase Id 73 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-06 16:34:29','',''),('21','237',417,'','24','4',0.00,21440000.00,'Purchase Id 74 for 33,500.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-06 16:37:10','',''),('21','237',418,'','supplier','1',21440000.00,0.00,'Purchase Id 74 for 33,500.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-06 16:37:10','',''),('21','237',419,'','24','4',0.00,32000000.00,'Purchase Id 75 for 50,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-06 16:38:25','',''),('21','237',420,'','supplier','1',32000000.00,0.00,'Purchase Id 75 for 50,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-06 16:38:25','',''),('21','237',421,'','24','4',0.00,32000000.00,'Purchase Id 76 for 50,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-06 16:40:12','',''),('21','237',422,'','supplier','1',32000000.00,0.00,'Purchase Id 76 for 50,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-06 16:40:12','',''),('21','237',423,'','20','1',25415685.40,0.00,'Sales from shift 41 on 2022-06-07 09:58:22 ','2022-06-07 09:58:22','',''),('21','237',424,'','6.1','2',0.00,25415685.40,'Sales from shift 41 on 2022-06-07 09:58:22 ','2022-06-07 09:58:22','',''),('21','237',425,'','20','1',0.00,0.00,'Sales from shift 42 on 2022-06-08 08:49:20 ','2022-06-08 08:49:20','',''),('21','237',426,'','6.1','2',0.00,0.00,'Sales from shift 42 on 2022-06-08 08:49:20 ','2022-06-08 08:49:20','',''),('21','237',427,'','20','1',45108414.40,0.00,'Sales from shift 43 on 2022-06-08 10:14:47 ','2022-06-08 10:14:47','',''),('21','237',428,'','6.1','2',0.00,45108414.40,'Sales from shift 43 on 2022-06-08 10:14:47 ','2022-06-08 10:14:47','',''),('21','237',429,'','24','4',0.00,9405000.00,'Purchase Id 78 for 57,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-08 10:41:21','',''),('21','237',430,'','supplier','1',9405000.00,0.00,'Purchase Id 78 for 57,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-08 10:41:21','',''),('21','237',431,'','24','4',0.00,7425000.00,'Purchase Id 77 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-08 10:45:01','',''),('21','237',432,'','supplier','1',7425000.00,0.00,'Purchase Id 77 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-08 10:45:01','',''),('21','237',433,'','20','1',18956905.50,0.00,'Sales from shift 44 on 2022-06-08 13:01:48 ','2022-06-08 13:01:48','',''),('21','237',434,'','6.1','2',0.00,18956905.50,'Sales from shift 44 on 2022-06-08 13:01:48 ','2022-06-08 13:01:48','',''),('21','237',435,'','20','1',18204851.55,0.00,'Sales from shift 45 on 2022-06-08 15:01:09 ','2022-06-08 15:01:09','',''),('21','237',436,'','6.1','2',0.00,18204851.55,'Sales from shift 45 on 2022-06-08 15:01:09 ','2022-06-08 15:01:09','',''),('21','237',437,'','24','4',0.00,7425000.00,'Purchase Id 79 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-08 17:50:40','',''),('21','237',438,'','supplier','1',7425000.00,0.00,'Purchase Id 79 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-08 17:50:40','',''),('21','237',439,'','24','4',0.00,7425000.00,'Purchase Id 80 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-08 17:54:59','',''),('21','237',440,'','supplier','1',7425000.00,0.00,'Purchase Id 80 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-08 17:54:59','',''),('21','237',441,'','20','1',11981347.40,0.00,'Sales from shift 46 on 2022-06-08 18:38:33 ','2022-06-08 18:38:33','',''),('21','237',442,'','6.1','2',0.00,11981347.40,'Sales from shift 46 on 2022-06-08 18:38:33 ','2022-06-08 18:38:33','',''),('21','237',443,'','24','4',0.00,32500000.00,'Purchase Id 81 for 50,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-08 19:38:21','',''),('21','237',444,'','supplier','1',32500000.00,0.00,'Purchase Id 81 for 50,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-08 19:38:21','',''),('21','237',445,'','24','4',0.00,29250000.00,'Purchase Id 82 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-08 19:56:48','',''),('21','237',446,'','supplier','1',29250000.00,0.00,'Purchase Id 82 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-08 19:56:48','',''),('21','237',447,'','24','4',0.00,29250000.00,'Purchase Id 83 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-08 19:59:28','',''),('21','237',448,'','supplier','1',29250000.00,0.00,'Purchase Id 83 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-08 19:59:28','',''),('21','237',449,'','20','1',17565194.20,0.00,'Sales from shift 47 on 2022-06-08 21:16:42 ','2022-06-08 21:16:42','',''),('21','237',450,'','6.1','2',0.00,17565194.20,'Sales from shift 47 on 2022-06-08 21:16:42 ','2022-06-08 21:16:42','',''),('21','237',451,'','20','1',32120226.15,0.00,'Sales from shift 48 on 2022-06-10 11:58:35 ','2022-06-10 11:58:35','',''),('21','237',452,'','6.1','2',0.00,32120226.15,'Sales from shift 48 on 2022-06-10 11:58:35 ','2022-06-10 11:58:35','',''),('21','237',453,'','24','4',0.00,19500000.00,'Purchase Id 84 for 30,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-10 12:09:21','',''),('21','237',454,'','supplier','1',19500000.00,0.00,'Purchase Id 84 for 30,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-10 12:09:21','',''),('21','237',455,'','24','4',0.00,7425000.00,'Purchase Id 85 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-11 06:45:23','',''),('21','237',456,'','supplier','1',7425000.00,0.00,'Purchase Id 85 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-11 06:45:23','',''),('21','237',457,'','24','4',0.00,7425000.00,'Purchase Id 86 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-11 06:47:20','',''),('21','237',458,'','supplier','1',7425000.00,0.00,'Purchase Id 86 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-11 06:47:20','',''),('21','237',459,'','24','4',0.00,7425000.00,'Purchase Id 87 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-11 06:48:51','',''),('21','237',460,'','supplier','1',7425000.00,0.00,'Purchase Id 87 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-11 06:48:51','',''),('21','237',461,'','20','1',32264961.70,0.00,'Sales from shift 49 on 2022-06-11 08:39:00 ','2022-06-11 08:39:00','',''),('21','237',462,'','6.1','2',0.00,32264961.70,'Sales from shift 49 on 2022-06-11 08:39:00 ','2022-06-11 08:39:00','',''),('21','237',463,'','24','4',0.00,7425000.00,'Purchase Id 88 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-11 09:22:21','',''),('21','237',464,'','supplier','1',7425000.00,0.00,'Purchase Id 88 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-11 09:22:21','',''),('21','237',465,'','20','1',26480519.30,0.00,'Sales from shift 50 on 2022-06-11 10:07:53 ','2022-06-11 10:07:53','',''),('21','237',466,'','6.1','2',0.00,26480519.30,'Sales from shift 50 on 2022-06-11 10:07:53 ','2022-06-11 10:07:53','',''),('21','237',467,'','24','4',0.00,29250000.00,'Purchase Id 89 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-11 10:12:34','',''),('21','237',468,'','supplier','1',29250000.00,0.00,'Purchase Id 89 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-11 10:12:34','',''),('21','237',469,'','24','4',0.00,7425000.00,'Purchase Id 91 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-11 10:25:30','',''),('21','237',470,'','supplier','1',7425000.00,0.00,'Purchase Id 91 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-11 10:25:30','',''),('21','237',471,'','20','1',29966211.80,0.00,'Sales from shift 51 on 2022-06-11 11:03:42 ','2022-06-11 11:03:42','',''),('21','237',472,'','6.1','2',0.00,29966211.80,'Sales from shift 51 on 2022-06-11 11:03:42 ','2022-06-11 11:03:42','',''),('21','237',473,'','24','4',0.00,29250000.00,'Purchase Id 90 for 60,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-11 11:04:52','',''),('21','237',474,'','supplier','1',29250000.00,0.00,'Purchase Id 90 for 60,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-11 11:04:52','',''),('21','237',475,'','20','1',26488122.25,0.00,'Sales from shift 52 on 2022-06-11 12:53:49 ','2022-06-11 12:53:49','',''),('21','237',476,'','6.1','2',0.00,26488122.25,'Sales from shift 52 on 2022-06-11 12:53:49 ','2022-06-11 12:53:49','',''),('21','237',477,'','24','4',0.00,6550500.00,'Purchase Id 92 for 39,700.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-11 17:46:36','',''),('21','237',478,'','supplier','1',6550500.00,0.00,'Purchase Id 92 for 39,700.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-11 17:46:36','',''),('21','237',479,'','20','1',47420026.80,0.00,'Sales from shift 53 on 2022-06-12 08:00:10 ','2022-06-12 08:00:10','',''),('21','237',480,'','6.1','2',0.00,47420026.80,'Sales from shift 53 on 2022-06-12 08:00:10 ','2022-06-12 08:00:10','',''),('21','237',481,'','24','4',0.00,7425000.00,'Purchase Id 94 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-12 08:29:32','',''),('21','237',482,'','supplier','1',7425000.00,0.00,'Purchase Id 94 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-12 08:29:32','',''),('21','237',483,'','24','4',0.00,39000000.00,'Purchase Id 93 for 50,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-12 08:33:14','',''),('21','237',484,'','supplier','1',39000000.00,0.00,'Purchase Id 93 for 50,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-12 08:33:14','',''),('21','237',485,'','20','1',35804997.20,0.00,'Sales from shift 54 on 2022-06-12 09:23:50 ','2022-06-12 09:23:50','',''),('21','237',486,'','6.1','2',0.00,35804997.20,'Sales from shift 54 on 2022-06-12 09:23:50 ','2022-06-12 09:23:50','',''),('21','237',487,'','24','4',0.00,29250000.00,'Purchase Id 95 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-12 09:24:59','',''),('21','237',488,'','supplier','1',29250000.00,0.00,'Purchase Id 95 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-12 09:24:59','',''),('21','237',489,'','24','4',0.00,8250000.00,'Purchase Id 96 for 50,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-12 09:27:14','',''),('21','237',490,'','supplier','1',8250000.00,0.00,'Purchase Id 96 for 50,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-12 09:27:14','',''),('21','237',491,'','20','1',43228278.40,0.00,'Sales from shift 55 on 2022-06-12 11:02:53 ','2022-06-12 11:02:53','',''),('21','237',492,'','6.1','2',0.00,43228278.40,'Sales from shift 55 on 2022-06-12 11:02:53 ','2022-06-12 11:02:53','',''),('21','237',493,'','20','1',0.00,0.00,'Sales from shift 56 on 2022-06-14 10:50:37 ','2022-06-14 10:50:37','',''),('21','237',494,'','6.1','2',0.00,0.00,'Sales from shift 56 on 2022-06-14 10:50:37 ','2022-06-14 10:50:37','',''),('21','237',495,'','24','4',0.00,8250000.00,'Purchase Id 97 for 50,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-18 16:41:41','',''),('21','237',496,'','supplier','1',8250000.00,0.00,'Purchase Id 97 for 50,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-18 16:41:41','',''),('21','237',497,'','24','4',0.00,29250000.00,'Purchase Id 98 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-18 16:49:47','',''),('21','237',498,'','supplier','1',29250000.00,0.00,'Purchase Id 98 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-18 16:49:47','',''),('21','237',499,'','24','4',0.00,8250000.00,'Purchase Id 99 for 50,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-18 16:56:39','',''),('21','237',500,'','supplier','1',8250000.00,0.00,'Purchase Id 99 for 50,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-18 16:56:39','',''),('21','237',501,'','24','4',0.00,969210.00,'Purchase Id 100 for 5,874.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-18 17:02:43','',''),('21','237',502,'','supplier','1',969210.00,0.00,'Purchase Id 100 for 5,874.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-18 17:02:43','',''),('21','237',503,'','20','1',31946072.30,0.00,'Sales from shift 57 on 2022-06-18 17:51:22 ','2022-06-18 17:51:22','',''),('21','237',504,'','6.1','2',0.00,31946072.30,'Sales from shift 57 on 2022-06-18 17:51:22 ','2022-06-18 17:51:22','',''),('21','237',505,'','24','4',0.00,32500000.00,'Purchase Id 102 for 50,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-18 18:41:16','',''),('21','237',506,'','supplier','1',32500000.00,0.00,'Purchase Id 102 for 50,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-18 18:41:16','',''),('21','237',507,'','24','4',0.00,32500000.00,'Purchase Id 101 for 50,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-18 18:45:17','',''),('21','237',508,'','supplier','1',32500000.00,0.00,'Purchase Id 101 for 50,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-18 18:45:17','',''),('21','237',509,'','20','1',45468575.10,0.00,'Sales from shift 58 on 2022-06-18 20:56:52 ','2022-06-18 20:56:52','',''),('21','237',510,'','6.1','2',0.00,45468575.10,'Sales from shift 58 on 2022-06-18 20:56:52 ','2022-06-18 20:56:52','',''),('21','237',511,'','20','1',28138810.95,0.00,'Sales from shift 59 on 2022-06-18 22:08:31 ','2022-06-18 22:08:31','',''),('21','237',512,'','6.1','2',0.00,28138810.95,'Sales from shift 59 on 2022-06-18 22:08:31 ','2022-06-18 22:08:31','',''),('21','237',513,'','24','4',0.00,6600000.00,'Purchase Id 103 for 40,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-18 22:23:54','',''),('21','237',514,'','supplier','1',6600000.00,0.00,'Purchase Id 103 for 40,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-18 22:23:54','',''),('21','237',515,'','24','4',0.00,7425000.00,'Purchase Id 106 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-22 07:43:00','',''),('21','237',516,'','supplier','1',7425000.00,0.00,'Purchase Id 106 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-22 07:43:00','',''),('21','237',517,'','24','4',0.00,30600000.00,'Purchase Id 105 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-22 07:44:07','',''),('21','237',518,'','supplier','1',30600000.00,0.00,'Purchase Id 105 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-22 07:44:07','',''),('21','237',519,'','24','4',0.00,30600000.00,'Purchase Id 104 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-22 07:45:24','',''),('21','237',520,'','supplier','1',30600000.00,0.00,'Purchase Id 104 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-22 07:45:24','',''),('21','237',521,'','20','1',0.00,0.00,'Sales from shift 60 on 2022-06-22 08:32:34 ','2022-06-22 08:32:34','',''),('21','237',522,'','6.1','2',0.00,0.00,'Sales from shift 60 on 2022-06-22 08:32:34 ','2022-06-22 08:32:34','',''),('21','237',523,'','20','1',0.00,0.00,'Sales from shift 61 on 2022-06-22 09:02:04 ','2022-06-22 09:02:04','',''),('21','237',524,'','6.1','2',0.00,0.00,'Sales from shift 61 on 2022-06-22 09:02:04 ','2022-06-22 09:02:04','',''),('21','237',525,'','20','1',18820189.65,0.00,'Sales from shift 62 on 2022-06-22 10:20:51 ','2022-06-22 10:20:51','',''),('21','237',526,'','6.1','2',0.00,18820189.65,'Sales from shift 62 on 2022-06-22 10:20:51 ','2022-06-22 10:20:51','',''),('21','237',527,'','20','1',0.00,0.00,'Sales from shift 63 on 2022-06-22 10:53:24 ','2022-06-22 10:53:24','',''),('21','237',528,'','6.1','2',0.00,0.00,'Sales from shift 63 on 2022-06-22 10:53:24 ','2022-06-22 10:53:24','',''),('21','237',529,'','20','1',14563084.00,0.00,'Sales from shift 64 on 2022-06-22 12:00:27 ','2022-06-22 12:00:27','',''),('21','237',530,'','6.1','2',0.00,14563084.00,'Sales from shift 64 on 2022-06-22 12:00:27 ','2022-06-22 12:00:27','',''),('21','237',531,'','20','1',41921730.65,0.00,'Sales from shift 65 on 2022-06-22 13:00:39 ','2022-06-22 13:00:39','',''),('21','237',532,'','6.1','2',0.00,41921730.65,'Sales from shift 65 on 2022-06-22 13:00:39 ','2022-06-22 13:00:39','',''),('21','237',533,'','24','4',0.00,7425000.00,'Purchase Id 110 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-22 14:06:47','',''),('21','237',534,'','supplier','1',7425000.00,0.00,'Purchase Id 110 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-22 14:06:47','',''),('21','237',535,'','24','4',0.00,40800000.00,'Purchase Id 107 for 60,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-22 14:08:34','',''),('21','237',536,'','supplier','1',40800000.00,0.00,'Purchase Id 107 for 60,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-22 14:08:34','',''),('21','237',537,'','24','4',0.00,20400000.00,'Purchase Id 108 for 30,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-22 14:10:38','',''),('21','237',538,'','supplier','1',20400000.00,0.00,'Purchase Id 108 for 30,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-22 14:10:38','',''),('21','237',539,'','20','1',43978041.55,0.00,'Sales from shift 66 on 2022-06-22 15:49:24 ','2022-06-22 15:49:24','',''),('21','237',540,'','6.1','2',0.00,43978041.55,'Sales from shift 66 on 2022-06-22 15:49:24 ','2022-06-22 15:49:24','',''),('21','237',541,'','24','4',0.00,27200000.00,'Purchase Id 111 for 40,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-22 16:24:28','',''),('21','237',542,'','supplier','1',27200000.00,0.00,'Purchase Id 111 for 40,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-22 16:24:28','',''),('21','237',543,'','20','1',43611497.30,0.00,'Sales from shift 67 on 2022-06-22 17:54:06 ','2022-06-22 17:54:06','',''),('21','237',544,'','6.1','2',0.00,43611497.30,'Sales from shift 67 on 2022-06-22 17:54:06 ','2022-06-22 17:54:06','',''),('21','237',545,'','24','4',0.00,31563560.00,'Purchase Id 112 for 46,417.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-23 06:45:24','',''),('21','237',546,'','supplier','1',31563560.00,0.00,'Purchase Id 112 for 46,417.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-23 06:45:24','',''),('21','237',547,'','20','1',34429473.45,0.00,'Sales from shift 68 on 2022-06-23 11:40:58 ','2022-06-23 11:40:58','',''),('21','237',548,'','6.1','2',0.00,34429473.45,'Sales from shift 68 on 2022-06-23 11:40:58 ','2022-06-23 11:40:58','',''),('21','237',549,'','24','4',0.00,20400000.00,'Purchase Id 109 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-24 08:34:56','',''),('21','237',550,'','supplier','1',20400000.00,0.00,'Purchase Id 109 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-24 08:34:56','',''),('21','237',551,'','24','4',0.00,3993000.00,'Purchase Id 114 for 24,200.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-24 08:38:30','',''),('21','237',552,'','supplier','1',3993000.00,0.00,'Purchase Id 114 for 24,200.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-24 08:38:30','',''),('21','237',553,'','24','4',0.00,7425000.00,'Purchase Id 113 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-24 08:47:09','',''),('21','237',554,'','supplier','1',7425000.00,0.00,'Purchase Id 113 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-06-24 08:47:09','',''),('21','237',555,'','20','1',33046009.60,0.00,'Sales from shift 69 on 2022-06-24 10:37:09 ','2022-06-24 10:37:09','',''),('21','237',556,'','6.1','2',0.00,33046009.60,'Sales from shift 69 on 2022-06-24 10:37:09 ','2022-06-24 10:37:09','',''),('21','237',557,'','20','1',32490082.90,0.00,'Sales from shift 70 on 2022-06-25 09:03:46 ','2022-06-25 09:03:46','',''),('21','237',558,'','6.1','2',0.00,32490082.90,'Sales from shift 70 on 2022-06-25 09:03:46 ','2022-06-25 09:03:46','',''),('21','237',559,'','24','4',0.00,30600000.00,'Purchase Id 115 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-25 09:22:44','',''),('21','237',560,'','supplier','1',30600000.00,0.00,'Purchase Id 115 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-06-25 09:22:44','',''),('21','237',561,'','20','1',31966649.45,0.00,'Sales from shift 71 on 2022-07-20 17:37:19 ','2022-07-20 17:37:19','',''),('21','237',562,'','6.1','2',0.00,31966649.45,'Sales from shift 71 on 2022-07-20 17:37:19 ','2022-07-20 17:37:19','',''),('21','237',563,'','24','4',0.00,6455790.00,'Purchase Id 116 for 39,126.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-07-22 10:51:36','',''),('21','237',564,'','supplier','1',6455790.00,0.00,'Purchase Id 116 for 39,126.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-07-22 10:51:36','',''),('21','237',565,'','20','1',16332353.55,0.00,'Sales from shift 72 on 2022-07-22 15:26:48 ','2022-07-22 15:26:48','',''),('21','237',566,'','6.1','2',0.00,16332353.55,'Sales from shift 72 on 2022-07-22 15:26:48 ','2022-07-22 15:26:48','',''),('21','237',567,'','24','4',0.00,8184000.00,'Purchase Id 117 for 49,600.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-07-25 17:56:34','',''),('21','237',568,'','supplier','1',8184000.00,0.00,'Purchase Id 117 for 49,600.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-07-25 17:56:34','',''),('21','237',569,'','24','4',0.00,40336100.00,'Purchase Id 118 for 57,623.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-07-25 18:39:54','',''),('21','237',570,'','supplier','1',40336100.00,0.00,'Purchase Id 118 for 57,623.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-07-25 18:39:54','',''),('21','237',571,'','24','4',0.00,31500000.00,'Purchase Id 119 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-07-25 18:50:37','',''),('21','237',572,'','supplier','1',31500000.00,0.00,'Purchase Id 119 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-07-25 18:50:37','',''),('21','237',573,'','20','1',24990095.15,0.00,'Sales from shift 73 on 2022-07-26 21:34:33 ','2022-07-26 21:34:33','',''),('21','237',574,'','6.1','2',0.00,24990095.15,'Sales from shift 73 on 2022-07-26 21:34:33 ','2022-07-26 21:34:33','',''),('21','237',575,'','24','4',0.00,10500000.00,'Purchase Id 120 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-07-27 14:56:41','',''),('21','237',576,'','supplier','1',10500000.00,0.00,'Purchase Id 120 for 15,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-07-27 14:56:41','',''),('21','237',577,'','20','1',32378489.80,0.00,'Sales from shift 74 on 2022-07-27 16:24:38 ','2022-07-27 16:24:38','',''),('21','237',578,'','6.1','2',0.00,32378489.80,'Sales from shift 74 on 2022-07-27 16:24:38 ','2022-07-27 16:24:38','',''),('21','237',579,'','20','1',11119600.80,0.00,'Sales from shift 75 on 2022-07-27 17:23:07 ','2022-07-27 17:23:07','',''),('21','237',580,'','6.1','2',0.00,11119600.80,'Sales from shift 75 on 2022-07-27 17:23:07 ','2022-07-27 17:23:07','',''),('21','237',581,'','24','4',0.00,8250000.00,'Purchase Id 121 for 50,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-07-27 17:32:19','',''),('21','237',582,'','supplier','1',8250000.00,0.00,'Purchase Id 121 for 50,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-07-27 17:32:19','',''),('21','237',583,'','24','4',0.00,7425000.00,'Purchase Id 122 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-07-27 17:43:47','',''),('21','237',584,'','supplier','1',7425000.00,0.00,'Purchase Id 122 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-07-27 17:43:47','',''),('21','237',585,'','24','4',0.00,30240000.00,'Purchase Id 123 for 42,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-07-27 18:04:54','',''),('21','237',586,'','supplier','1',30240000.00,0.00,'Purchase Id 123 for 42,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-07-27 18:04:54','',''),('21','237',587,'','24','4',0.00,36000000.00,'Purchase Id 124 for 50,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-07-27 18:08:43','',''),('21','237',588,'','supplier','1',36000000.00,0.00,'Purchase Id 124 for 50,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-07-27 18:08:43','',''),('21','237',589,'','20','1',34773831.75,0.00,'Sales from shift 76 on 2022-07-27 19:14:12 ','2022-07-27 19:14:12','',''),('21','237',590,'','6.1','2',0.00,34773831.75,'Sales from shift 76 on 2022-07-27 19:14:12 ','2022-07-27 19:14:12','',''),('21','237',591,'','24','4',0.00,32400000.00,'Purchase Id 126 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-07-27 19:51:08','',''),('21','237',592,'','supplier','1',32400000.00,0.00,'Purchase Id 126 for 45,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-07-27 19:51:08','',''),('21','237',593,'','20','1',30217468.35,0.00,'Sales from shift 77 on 2022-07-27 20:57:18 ','2022-07-27 20:57:18','',''),('21','237',594,'','6.1','2',0.00,30217468.35,'Sales from shift 77 on 2022-07-27 20:57:18 ','2022-07-27 20:57:18','',''),('21','237',595,'','24','4',0.00,8250000.00,'Purchase Id 127 for 50,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-07-30 10:01:13','',''),('21','237',596,'','supplier','1',8250000.00,0.00,'Purchase Id 127 for 50,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-07-30 10:01:13','',''),('21','237',597,'','20','1',23563640.40,0.00,'Sales from shift 78 on 2022-07-30 10:51:55 ','2022-07-30 10:51:55','',''),('21','237',598,'','6.1','2',0.00,23563640.40,'Sales from shift 78 on 2022-07-30 10:51:55 ','2022-07-30 10:51:55','',''),('21','237',599,'','24','4',0.00,7425000.00,'Purchase Id 128 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-07-31 15:33:52','',''),('21','237',600,'','supplier','1',7425000.00,0.00,'Purchase Id 128 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-07-31 15:33:52','',''),('21','237',601,'','20','1',26011393.05,0.00,'Sales from shift 79 on 2022-07-31 16:43:51 ','2022-07-31 16:43:51','',''),('21','237',602,'','6.1','2',0.00,26011393.05,'Sales from shift 79 on 2022-07-31 16:43:51 ','2022-07-31 16:43:51','',''),('21','237',603,'','24','4',0.00,7425000.00,'Purchase Id 129 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-07-31 16:56:30','',''),('21','237',604,'','supplier','1',7425000.00,0.00,'Purchase Id 129 for 45,000.00 litters of Petrol - PMS from AYM SHAFA NIGERIA. LTD','2022-07-31 16:56:30','',''),('21','237',605,'','24','4',0.00,36000000.00,'Purchase Id 130 for 50,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-07-31 17:40:34','',''),('21','237',606,'','supplier','1',36000000.00,0.00,'Purchase Id 130 for 50,000.00 litters of Diesel - AGO from AYM SHAFA NIGERIA. LTD','2022-07-31 17:40:34','',''),('21','237',607,'','20','1',28829660.70,0.00,'Sales from shift 80 on 2022-07-31 18:58:02 ','2022-07-31 18:58:02','',''),('21','237',608,'','6.1','2',0.00,28829660.70,'Sales from shift 80 on 2022-07-31 18:58:02 ','2022-07-31 18:58:02','','');
/*!40000 ALTER TABLE `ledgers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products`
--

DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `measurement` varchar(20) NOT NULL,
  `quantity2` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`code`,`name`,`measurement`,`quantity2`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `cleanup` (`cleanup`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products`
--

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (1,'21','237','PMS','Petrol','Litres',0,165.00,165.00,165.00,165.00,0.00,0,'2022-03-03 18:25:06','764','764','2022-03-03 18:25:06',0),(2,'21','237','AGO','Diesel','Litres',0,720.00,720.00,720.00,720.00,0.00,0,'2022-03-03 20:52:45','764','772','2022-06-22 11:01:39',0);
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_changevalues`
--

DROP TABLE IF EXISTS `products_changevalues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_changevalues` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `change_id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity` bigint NOT NULL,
  `oldrate` decimal(20,2) NOT NULL,
  `newrate` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`change_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_changevalues`
--

LOCK TABLES `products_changevalues` WRITE;
/*!40000 ALTER TABLE `products_changevalues` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_changevalues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_prices`
--

DROP TABLE IF EXISTS `products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_prices`
--

LOCK TABLES `products_prices` WRITE;
/*!40000 ALTER TABLE `products_prices` DISABLE KEYS */;
INSERT INTO `products_prices` VALUES (1,'21','237',1,165.00,165.00,165.00,165.00,'','2022-03-26 14:00:16','764'),(2,'21','237',2,640.00,640.00,640.00,640.00,'','2022-03-26 14:00:51','764'),(3,'21','237',2,650.00,640.00,0.00,0.00,'Cost from purchase id #81','2022-06-08 19:38:21','772'),(4,'21','237',2,680.00,640.00,0.00,0.00,'Cost from purchase id #105','2022-06-22 07:44:07','772'),(5,'21','237',2,690.00,690.00,690.00,690.00,'Price increase on AGO from 680 to 690','2022-06-22 09:05:12','764'),(6,'21','237',2,680.00,680.00,680.00,680.00,'Price increase on AGO from 690 to 680','2022-06-22 11:01:23','772'),(7,'21','237',2,700.00,700.00,700.00,700.00,'Price increase on AGO from 680 to 700','2022-07-20 12:34:39','772'),(8,'21','237',2,720.00,720.00,720.00,720.00,'Price increase on AGO from 700 to 720','2022-07-27 16:42:39','772');
/*!40000 ALTER TABLE `products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_reconciliations`
--

DROP TABLE IF EXISTS `products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_reconciliations`
--

LOCK TABLES `products_reconciliations` WRITE;
/*!40000 ALTER TABLE `products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_shortages`
--

DROP TABLE IF EXISTS `products_shortages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_shortages` (
  `shortage_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shortagedate` date NOT NULL,
  `product_id` varchar(10) NOT NULL,
  `type` int NOT NULL DEFAULT '0',
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`shortage_id`),
  KEY `companycode` (`company_id`,`shortagedate`,`product_id`,`rate`,`quantity`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_shortages`
--

LOCK TABLES `products_shortages` WRITE;
/*!40000 ALTER TABLE `products_shortages` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_shortages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pts_nozzles`
--

DROP TABLE IF EXISTS `pts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pts_nozzles` (
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pts_id` int NOT NULL,
  `pump` varchar(20) NOT NULL,
  `code` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `last_volume` decimal(20,2) NOT NULL,
  `last_price` decimal(20,2) NOT NULL,
  `last_amount` decimal(20,2) NOT NULL,
  `last_transaction` int NOT NULL DEFAULT '0',
  `total_volume` decimal(20,2) NOT NULL,
  `total_amount` decimal(20,2) NOT NULL,
  `total_transactions` decimal(20,2) NOT NULL,
  `lastconnect` datetime NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `terminal_id` (`pts_id`,`pump`,`code`,`lastconnect`),
  KEY `companycode` (`company_id`,`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pts_nozzles`
--

LOCK TABLES `pts_nozzles` WRITE;
/*!40000 ALTER TABLE `pts_nozzles` DISABLE KEYS */;
/*!40000 ALTER TABLE `pts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases`
--

DROP TABLE IF EXISTS `purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=131 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases`
--

LOCK TABLES `purchases` WRITE;
/*!40000 ALTER TABLE `purchases` DISABLE KEYS */;
INSERT INTO `purchases` VALUES (5,'21','237','2022-03-24',2,1,640.00,47320.00,0.00,0.00,30284800.00,0.00,'','000110','BAU 312 XR','','','','2022-03-26 14:57:34',15,'','764','','0000-00-00 00:00:00','764','2022-03-26 14:58:53'),(6,'21','237','2022-03-24',2,1,640.00,45000.00,0.00,0.00,28800000.00,0.00,'','0000120','JJN 60 YS','','','','2022-03-26 14:58:14',15,'','764','','0000-00-00 00:00:00','764','2022-03-26 14:59:15'),(7,'21','237','2022-03-25',2,1,640.00,30000.00,0.00,0.00,19200000.00,0.00,'','','bau 230 xr ','','','','2022-03-27 11:32:02',15,'','764','','0000-00-00 00:00:00','764','2022-03-27 11:36:00'),(8,'21','237','2022-03-25',2,1,640.00,15000.00,0.00,0.00,9600000.00,0.00,'','','bau 230 xr ','','','','2022-03-27 11:33:46',15,'','764','','0000-00-00 00:00:00','764','2022-03-27 12:31:30'),(9,'21','237','2022-03-26',1,1,165.00,45000.00,0.00,0.00,7425000.00,0.00,'','009','KWL 553 YH','','','','2022-03-28 15:08:17',10,'','772','','0000-00-00 00:00:00','772','2022-03-28 15:20:21'),(10,'21','237','2022-03-26',1,1,165.00,45000.00,0.00,0.00,7425000.00,0.00,'','008','YLA 544 ZV','','','','2022-03-28 15:09:01',15,'','772','','0000-00-00 00:00:00','772','2022-03-28 15:17:47'),(11,'21','237','2022-03-26',1,1,165.00,45000.00,0.00,0.00,7425000.00,0.00,'','','BAU 625 YP','','','','2022-03-28 15:09:41',15,'','772','','0000-00-00 00:00:00','772','2022-03-28 15:16:21'),(12,'21','237','2022-03-26',2,1,640.00,50000.00,0.00,0.00,32000000.00,0.00,'','0999','BAU 204 XR','','','','2022-03-28 15:10:28',15,'','772','','0000-00-00 00:00:00','772','2022-03-28 15:13:55'),(13,'21','237','2022-03-28',2,1,640.00,15000.00,0.00,0.00,9600000.00,0.00,'','0090','JJN 60 YS','','','','2022-03-28 15:11:12',15,'','772','','0000-00-00 00:00:00','772','2022-03-28 15:11:49'),(14,'21','237','2022-03-28',2,1,640.00,45000.00,0.00,0.00,28800000.00,0.00,'','0090','ALK 542 XA','','','','2022-04-05 12:33:52',15,'','772','','0000-00-00 00:00:00','772','2022-04-05 12:34:23'),(15,'21','237','2022-04-29',1,1,165.00,45000.00,0.00,0.00,7425000.00,0.00,'','008','alk 742 xa','','','','2022-04-12 11:19:18',15,'','772','','0000-00-00 00:00:00','772','2022-04-12 11:59:35'),(16,'21','237','2022-04-12',1,1,165.00,40000.00,0.00,0.00,6600000.00,0.00,'','','trr 68 yx','','','','2022-04-12 11:20:21',15,'','772','','0000-00-00 00:00:00','772','2022-04-12 11:56:48'),(17,'21','237','2022-03-29',2,1,640.00,45000.00,0.00,0.00,28800000.00,0.00,'','008','JJN 60 YS','','','','2022-04-12 11:42:35',15,'','772','','0000-00-00 00:00:00','772','2022-04-12 11:54:24'),(18,'21','237','2022-03-29',1,1,165.00,60000.00,0.00,0.00,9900000.00,0.00,'','0999','alk 742 xa','','','','2022-04-12 12:02:22',15,'','772','','0000-00-00 00:00:00','772','2022-04-12 12:03:09'),(21,'21','237','2022-03-31',2,1,640.00,13500.00,0.00,0.00,8640000.00,0.00,'','009','bau 446 ze','','','','2022-04-26 11:08:16',5,'','772','','0000-00-00 00:00:00','772','2022-04-26 11:09:15'),(22,'21','237','2022-03-31',2,1,640.00,45000.00,0.00,0.00,28800000.00,0.00,'','008','JJN 60 YS','','','','2022-04-29 12:24:42',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(23,'21','237','2022-03-31',2,1,640.00,45000.00,0.00,0.00,28800000.00,0.00,'','008','BAU 584 ZE','','','','2022-04-29 12:25:29',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(24,'21','237','2022-03-31',2,1,640.00,45000.00,0.00,0.00,28800000.00,0.00,'','0999','BAU 249 XR','','','','2022-04-29 12:26:23',15,'','772','','0000-00-00 00:00:00','772','2022-04-29 12:28:10'),(25,'21','237','2022-03-31',2,1,640.00,45000.00,0.00,0.00,28800000.00,0.00,'','0999','BAU 249 XR','','','','2022-04-29 12:26:23',15,'','772','','0000-00-00 00:00:00','772','2022-04-29 12:26:44'),(26,'21','237','2022-04-02',1,1,165.00,60000.00,0.00,0.00,9900000.00,0.00,'','0999','BAU 321 XA','','','','2022-05-06 15:12:04',15,'','772','','0000-00-00 00:00:00','772','2022-05-06 15:13:04'),(27,'21','237','2022-04-03',2,1,640.00,50000.00,0.00,0.00,32000000.00,0.00,'','009','BAU 326 XR','','','','2022-05-10 13:32:19',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(28,'21','237','2022-04-06',1,1,165.00,35000.00,0.00,0.00,5775000.00,0.00,'','0999','BAU 310 ZE','','','','2022-05-14 10:45:09',5,'','772','','0000-00-00 00:00:00','772','2022-05-14 10:45:38'),(29,'21','237','2022-04-06',1,1,165.00,40000.00,0.00,0.00,6600000.00,0.00,'','00999','BAU 971 XR','','','','2022-05-14 12:30:42',15,'','772','','0000-00-00 00:00:00','772','2022-05-14 12:54:22'),(30,'21','237','2022-04-05',2,1,640.00,50000.00,0.00,0.00,32000000.00,0.00,'','00999','BAU 296 ZE','','','','2022-05-14 12:44:03',15,'','772','','0000-00-00 00:00:00','772','2022-05-14 12:46:24'),(31,'21','237','2022-04-06',1,1,165.00,45000.00,0.00,0.00,7425000.00,0.00,'','008','JJN 60 YS','','','','2022-05-14 14:20:15',15,'','772','','0000-00-00 00:00:00','772','2022-05-14 14:32:14'),(32,'21','237','2022-04-06',1,1,165.00,45000.00,0.00,0.00,7425000.00,0.00,'','0999','BAU 660 ZE','','','','2022-05-14 14:21:15',15,'','772','','0000-00-00 00:00:00','772','2022-05-14 14:27:08'),(33,'21','237','2022-04-06',2,1,640.00,45000.00,0.00,0.00,28800000.00,0.00,'','0090','ALK 840 XA','','','','2022-05-14 14:22:13',15,'','772','','0000-00-00 00:00:00','772','2022-05-14 14:22:57'),(34,'21','237','2022-04-07',2,1,640.00,50000.00,0.00,0.00,32000000.00,0.00,'','','ALK 836 XH','','','','2022-05-15 11:32:37',15,'','772','','0000-00-00 00:00:00','772','2022-05-15 11:33:32'),(35,'21','237','2022-04-08',1,1,165.00,50000.00,0.00,0.00,32000000.00,0.00,'','0090','BAU 207 XR ','','','','2022-05-15 12:43:19',15,'','772','','0000-00-00 00:00:00','772','2022-05-15 12:53:53'),(36,'21','237','2022-04-08',1,1,165.00,52000.00,0.00,0.00,8580000.00,0.00,'','0090','ALK 833 XA ','','','','2022-05-15 12:44:29',15,'','772','','0000-00-00 00:00:00','772','2022-05-15 12:51:15'),(37,'21','237','2022-04-08',2,1,640.00,45000.00,0.00,0.00,28800000.00,0.00,'','009','ALK 542 XA','','','','2022-05-15 12:46:55',15,'','772','','0000-00-00 00:00:00','772','2022-05-15 12:47:43'),(38,'21','237','2022-04-10',1,1,165.00,45000.00,0.00,0.00,7425000.00,0.00,'','00009','ALK 743 XA','','','','2022-05-17 14:36:11',15,'','772','','0000-00-00 00:00:00','772','2022-05-17 15:01:36'),(39,'21','237','2022-04-10',1,1,165.00,40000.00,0.00,0.00,7425000.00,0.00,'','00009','TRR 68 YX','','','','2022-05-17 14:38:11',15,'','772','772','2022-05-17 14:40:15','772','2022-05-17 14:58:53'),(40,'21','237','2022-04-10',2,1,640.00,45000.00,0.00,0.00,28800000.00,0.00,'','00009','BAU 314 YP','','','','2022-05-17 14:39:43',15,'','772','','0000-00-00 00:00:00','772','2022-05-17 14:54:09'),(41,'21','237','2022-04-11',2,1,640.00,45000.00,0.00,0.00,28800000.00,0.00,'','00009','BAU 241 XR','','','','2022-05-18 17:00:11',15,'','772','','0000-00-00 00:00:00','772','2022-05-18 17:03:50'),(42,'21','237','2022-04-11',1,1,165.00,45000.00,0.00,0.00,7425000.00,0.00,'','00009','BAU 803 ZE','','','','2022-05-18 17:01:06',15,'','772','','0000-00-00 00:00:00','772','2022-05-18 17:07:01'),(43,'21','237','2022-04-11',1,1,165.00,45000.00,0.00,0.00,7425000.00,0.00,'','00009','BAU 786 YP','','','','2022-05-18 17:01:54',15,'','772','','0000-00-00 00:00:00','772','2022-05-19 14:43:05'),(44,'21','237','2022-04-13',1,1,165.00,50000.00,0.00,0.00,8250000.00,0.00,'','00009','BAU 396 ZE','','','','2022-05-19 17:31:47',15,'','772','','0000-00-00 00:00:00','772','2022-05-19 17:34:29'),(45,'21','237','2022-04-13',2,1,640.00,50000.00,0.00,0.00,32000000.00,0.00,'','00009','BAU 340 ZE','','','','2022-05-19 17:32:40',15,'','772','','0000-00-00 00:00:00','772','2022-05-19 17:36:47'),(46,'21','237','2022-04-13',2,1,640.00,50000.00,0.00,0.00,32000000.00,0.00,'','00009','DBM 218 XA','','','','2022-05-19 17:33:36',15,'','772','','0000-00-00 00:00:00','772','2022-05-19 17:39:24'),(47,'21','237','2022-04-14',1,1,165.00,45000.00,0.00,0.00,7425000.00,0.00,'','0000000','BAU 261 XR','','','','2022-05-19 19:12:40',15,'','772','','0000-00-00 00:00:00','772','2022-05-19 19:23:40'),(48,'21','237','2022-04-14',1,1,165.00,45000.00,0.00,0.00,7425000.00,0.00,'','0000000','BAU 59 ZY','','','','2022-05-19 19:15:25',15,'','772','','0000-00-00 00:00:00','772','2022-05-19 19:22:20'),(49,'21','237','2022-04-15',2,1,640.00,15000.00,0.00,0.00,9600000.00,0.00,'','000000009','BAU 584 ZE','','','','2022-05-23 17:19:21',15,'','772','','0000-00-00 00:00:00','772','2022-05-23 17:24:07'),(50,'21','237','2022-04-15',2,1,640.00,50000.00,0.00,0.00,32000000.00,0.00,'','000000009','DBM 217 XA','','','','2022-05-23 17:21:08',15,'','772','772','2022-05-23 17:26:12','772','2022-05-23 17:26:40'),(51,'21','237','2022-04-15',1,1,165.00,40000.00,0.00,0.00,6600000.00,0.00,'','000000009','BAU 274 XR','','','','2022-05-23 17:22:56',15,'','772','','0000-00-00 00:00:00','772','2022-05-26 19:35:04'),(52,'21','237','2022-04-16',1,1,165.00,60000.00,0.00,0.00,9900000.00,0.00,'','0000000','BAU 982XR','','','','2022-05-30 18:44:03',15,'','772','','0000-00-00 00:00:00','772','2022-05-30 19:51:01'),(53,'21','237','2022-04-16',1,1,165.00,45000.00,0.00,0.00,7425000.00,0.00,'','0000000000','JJN 60 YS','','','','2022-05-30 18:46:38',15,'','772','','0000-00-00 00:00:00','772','2022-05-30 19:54:40'),(54,'21','237','2022-04-16',2,1,640.00,32300.00,0.00,0.00,20672000.00,0.00,'','0000000000','BAU 343 ZE','','','','2022-05-30 19:50:07',15,'','772','','0000-00-00 00:00:00','772','2022-05-30 19:56:27'),(55,'21','237','2022-04-19',1,1,165.00,45000.00,0.00,0.00,4950000.00,0.00,'','00097','JJN 60 YS','','','','2022-05-31 14:16:20',15,'','772','772','2022-05-31 18:28:19','772','2022-05-31 18:28:34'),(56,'21','237','2022-04-17',1,1,165.00,50000.00,0.00,0.00,8250000.00,0.00,'','009988','BAU 249 XR','','','','2022-05-31 14:18:47',15,'','772','','0000-00-00 00:00:00','772','2022-05-31 16:31:31'),(57,'21','237','2022-04-18',2,1,640.00,60000.00,0.00,0.00,38400000.00,0.00,'','0000000000','BAU 982XR','','','','2022-05-31 16:37:19',15,'','772','','0000-00-00 00:00:00','772','2022-05-31 16:43:26'),(58,'21','237','2022-04-18',2,1,640.00,45000.00,0.00,0.00,28800000.00,0.00,'','0000000','JJN 60 YS','','','','2022-05-31 16:37:55',15,'','772','','0000-00-00 00:00:00','772','2022-05-31 16:45:01'),(59,'21','237','2022-04-20',2,1,640.00,50000.00,0.00,0.00,32000000.00,0.00,'','00097','BAU 326 XR','','','','2022-06-01 09:24:34',15,'','772','','0000-00-00 00:00:00','772','2022-06-01 09:30:00'),(60,'21','237','2022-04-20',1,1,165.00,45000.00,0.00,0.00,7425000.00,0.00,'','0000000000','BAU 712 ZE','','','','2022-06-01 09:26:29',15,'','772','','0000-00-00 00:00:00','772','2022-06-01 09:28:11'),(61,'21','237','2022-04-21',1,1,165.00,45000.00,0.00,0.00,7425000.00,0.00,'','00097','JJN 60 YS','','','','2022-06-02 11:54:26',15,'','772','','0000-00-00 00:00:00','772','2022-06-02 11:57:36'),(62,'21','237','2022-04-22',2,1,640.00,45000.00,0.00,0.00,28800000.00,0.00,'','00097','BAU 285 YP','','','','2022-06-02 11:55:36',15,'','772','','0000-00-00 00:00:00','772','2022-06-02 11:59:15'),(63,'21','237','2022-04-21',2,1,640.00,50000.00,0.00,0.00,32000000.00,0.00,'','009988','BAU 828 XA ','','','','2022-06-02 11:56:35',15,'','772','','0000-00-00 00:00:00','772','2022-06-02 12:00:37'),(64,'21','237','2022-04-22',1,1,165.00,45000.00,0.00,0.00,7425000.00,0.00,'','00097','JJN 60 YS','','','','2022-06-02 12:50:24',15,'','772','','0000-00-00 00:00:00','772','2022-06-02 12:51:54'),(65,'21','237','2022-04-22',2,1,640.00,45000.00,0.00,0.00,32000000.00,0.00,'','00097','ALK 784 XA','','','','2022-06-02 12:51:32',15,'','772','772','2022-06-02 12:54:01','772','2022-06-02 12:54:17'),(66,'21','237','2022-04-23',1,1,165.00,50000.00,0.00,0.00,8250000.00,0.00,'','0000000000','JMT 53 YR','','','','2022-06-02 20:33:38',15,'','772','','0000-00-00 00:00:00','772','2022-06-02 20:35:29'),(67,'21','237','2022-04-23',2,1,640.00,21700.00,0.00,0.00,13888000.00,0.00,'','0000000','ALK 965 XA','','','','2022-06-02 20:35:04',15,'','772','','0000-00-00 00:00:00','772','2022-06-02 20:36:57'),(68,'21','237','2022-04-24',2,1,640.00,50000.00,0.00,0.00,32000000.00,0.00,'','000000009','BAU 204 XR','','','','2022-06-02 22:20:48',15,'','772','','0000-00-00 00:00:00','772','2022-06-02 22:27:03'),(69,'21','237','2022-04-24',1,1,165.00,45000.00,0.00,0.00,7425000.00,0.00,'','00097','BAU 285 YP','','','','2022-06-02 22:22:25',15,'','772','','0000-00-00 00:00:00','772','2022-06-02 22:25:27'),(70,'21','237','2022-04-26',1,1,165.00,45000.00,0.00,0.00,7425000.00,0.00,'','000000009','BAU 969 XR','','','','2022-06-05 09:53:17',15,'','772','','0000-00-00 00:00:00','772','2022-06-05 11:07:05'),(71,'21','237','2022-04-27',1,1,165.00,45000.00,0.00,0.00,7425000.00,0.00,'','0000000','ALK 965 XA','','','','2022-06-06 08:47:31',15,'','772','','0000-00-00 00:00:00','772','2022-06-06 08:49:07'),(72,'21','237','2022-04-28',1,1,165.00,50000.00,0.00,0.00,8250000.00,0.00,'','0000000000','BAU 249 XR','','','','2022-06-06 09:32:14',15,'','772','','0000-00-00 00:00:00','772','2022-06-06 09:32:49'),(73,'21','237','2022-04-28',1,1,165.00,45000.00,0.00,0.00,7425000.00,0.00,'','009988','BAU 285 YP','','','','2022-06-06 09:45:43',15,'','772','','0000-00-00 00:00:00','772','2022-06-06 16:34:29'),(74,'21','237','2022-04-28',2,1,640.00,33500.00,0.00,0.00,21440000.00,0.00,'','0000000','BAU 296 ZE','','','','2022-06-06 09:47:44',15,'','772','','0000-00-00 00:00:00','772','2022-06-06 16:37:10'),(75,'21','237','2022-04-28',2,1,640.00,50000.00,0.00,0.00,32000000.00,0.00,'','50000','BAU 312 XR','','','','2022-06-06 09:49:10',15,'','772','','0000-00-00 00:00:00','772','2022-06-06 16:38:25'),(76,'21','237','2022-04-28',2,1,640.00,50000.00,0.00,0.00,32000000.00,0.00,'','000000009','BAU 204 YR','','','','2022-06-06 09:52:18',15,'','772','772','2022-06-06 16:39:47','772','2022-06-06 16:40:12'),(77,'21','237','2022-05-01',1,1,165.00,45000.00,0.00,0.00,7425000.00,0.00,'','0000000000','TRR 540 YX','','','','2022-06-08 10:39:47',10,'','772','','0000-00-00 00:00:00','772','2022-06-08 10:45:01'),(78,'21','237','2022-05-01',1,1,165.00,57000.00,0.00,0.00,9405000.00,0.00,'','0000000000','ALK 742 XA','','','','2022-06-08 10:40:47',15,'','772','','0000-00-00 00:00:00','772','2022-06-08 10:41:21'),(79,'21','237','2022-05-03',1,1,165.00,45000.00,0.00,0.00,7425000.00,0.00,'','00000000000000','ALK 784 XA','','','','2022-06-08 17:48:33',15,'','772','','0000-00-00 00:00:00','772','2022-06-08 17:50:40'),(80,'21','237','2022-05-03',1,1,165.00,45000.00,0.00,0.00,7425000.00,0.00,'','0000000','BAU 499 XR ','','','','2022-06-08 17:49:59',15,'','772','','0000-00-00 00:00:00','772','2022-06-08 17:54:59'),(81,'21','237','2022-06-08',2,1,650.00,50000.00,0.00,0.00,32500000.00,0.00,'','00097','BAU 296 ZE','','','','2022-06-08 19:17:28',15,'','772','','0000-00-00 00:00:00','772','2022-06-08 19:38:21'),(82,'21','237','2022-05-04',2,1,650.00,45000.00,0.00,0.00,29250000.00,0.00,'','009988','ALK 784 XA','','','','2022-06-08 19:32:59',15,'','772','','0000-00-00 00:00:00','772','2022-06-08 19:56:48'),(83,'21','237','2022-05-04',2,1,650.00,45000.00,0.00,0.00,29250000.00,0.00,'','009988','BAU 958 ZE','','','','2022-06-08 19:34:16',15,'','772','','0000-00-00 00:00:00','772','2022-06-08 19:59:28'),(84,'21','237','2022-05-05',2,1,650.00,30000.00,0.00,0.00,19500000.00,0.00,'','0000000','JJN 60 YS','','','','2022-06-10 12:08:46',15,'','772','','0000-00-00 00:00:00','772','2022-06-10 12:09:21'),(85,'21','237','2022-05-06',2,1,650.00,45000.00,0.00,0.00,7425000.00,0.00,'','0000000','BAU 969 XR','','','','2022-06-11 06:42:00',15,'','772','','0000-00-00 00:00:00','772','2022-06-11 06:45:23'),(86,'21','237','2022-05-06',1,1,165.00,45000.00,0.00,0.00,7425000.00,0.00,'','0000000','BAU 412 ZE','','','','2022-06-11 06:43:38',15,'','772','','0000-00-00 00:00:00','772','2022-06-11 06:47:20'),(87,'21','237','2022-05-06',1,1,165.00,45000.00,0.00,0.00,7425000.00,0.00,'','0000000000','GKW 128 XA','','','','2022-06-11 06:44:44',15,'','772','','0000-00-00 00:00:00','772','2022-06-11 06:48:51'),(88,'21','237','2022-05-07',1,1,165.00,45000.00,0.00,0.00,7425000.00,0.00,'','00097','GKW 127 XA','','','','2022-06-11 09:20:31',5,'','772','','0000-00-00 00:00:00','772','2022-06-11 09:22:21'),(89,'21','237','2022-05-07',2,1,650.00,45000.00,0.00,0.00,29250000.00,0.00,'','00097','BAU 751 ZE','','','','2022-06-11 09:21:22',10,'','772','','0000-00-00 00:00:00','772','2022-06-11 10:12:34'),(90,'21','237','2022-05-08',2,1,650.00,60000.00,0.00,0.00,29250000.00,0.00,'','00097','BAU 981 XR','','','','2022-06-11 09:21:51',15,'','772','772','2022-06-11 11:04:32','772','2022-06-11 11:04:52'),(91,'21','237','2022-05-07',1,1,165.00,45000.00,0.00,0.00,7425000.00,0.00,'','000000009','GKW 127 XA','','','','2022-06-11 10:23:27',15,'','772','','0000-00-00 00:00:00','772','2022-06-11 10:25:30'),(92,'21','237','2022-05-08',1,1,165.00,39700.00,0.00,0.00,6550500.00,0.00,'','009988','DKA 515 XA','','','','2022-06-11 11:08:56',15,'','772','','0000-00-00 00:00:00','772','2022-06-11 17:46:36'),(93,'21','237','2022-05-10',2,1,650.00,50000.00,0.00,0.00,39000000.00,0.00,'','000000009','BAU 204 XR','','','','2022-06-12 08:27:42',15,'','772','772','2022-06-12 08:29:20','772','2022-06-12 08:33:14'),(94,'21','237','2022-05-10',1,1,165.00,45000.00,0.00,0.00,7425000.00,0.00,'','009988','JJN 60 YS','','','','2022-06-12 08:28:33',15,'','772','','0000-00-00 00:00:00','772','2022-06-12 08:29:32'),(95,'21','237','2022-05-11',2,1,650.00,45000.00,0.00,0.00,29250000.00,0.00,'','00097','JJN 60 YS','','','','2022-06-12 09:23:19',15,'','772','','0000-00-00 00:00:00','772','2022-06-12 09:24:59'),(96,'21','237','2022-05-11',1,1,165.00,50000.00,0.00,0.00,8250000.00,0.00,'','009988','ALK 826 XA','','','','2022-06-12 09:24:22',15,'','772','','0000-00-00 00:00:00','772','2022-06-12 09:27:14'),(97,'21','237','2022-05-12',1,1,165.00,50000.00,0.00,0.00,8250000.00,0.00,'','0000000000','BAU 782 ZE','','','','2022-06-12 12:30:32',15,'','772','','0000-00-00 00:00:00','772','2022-06-18 16:41:41'),(98,'21','237','2022-05-12',2,1,650.00,45000.00,0.00,0.00,29250000.00,0.00,'','000000009','JJN 60 YS','','','','2022-06-12 12:31:14',15,'','772','','0000-00-00 00:00:00','772','2022-06-18 16:49:47'),(99,'21','237','2022-05-12',1,1,165.00,50000.00,0.00,0.00,8250000.00,0.00,'','00097','BAU 677 XR','','','','2022-06-18 16:54:50',15,'','772','','0000-00-00 00:00:00','772','2022-06-18 16:56:39'),(100,'21','237','2022-05-12',1,1,165.00,5874.00,0.00,0.00,969210.00,0.00,'','009988','BAU 677 XR','','','','2022-06-18 16:55:54',15,'','772','','0000-00-00 00:00:00','772','2022-06-18 17:02:43'),(101,'21','237','2022-06-13',2,1,650.00,50000.00,0.00,0.00,32500000.00,0.00,'','0000000000','BAU 397 ZE','','','','2022-06-18 18:17:38',15,'','772','','0000-00-00 00:00:00','772','2022-06-18 18:45:17'),(102,'21','237','2022-05-13',2,1,650.00,50000.00,0.00,0.00,32500000.00,0.00,'','0000000','ALK 838 XA','','','','2022-06-18 18:18:28',15,'','772','','0000-00-00 00:00:00','772','2022-06-18 18:41:16'),(103,'21','237','2022-05-16',1,1,165.00,40000.00,0.00,0.00,6600000.00,0.00,'','000000009','BAU 29 ZE','','','','2022-06-18 22:23:38',15,'','772','','0000-00-00 00:00:00','772','2022-06-18 22:23:54'),(104,'21','237','2022-06-16',2,1,680.00,45000.00,0.00,0.00,30600000.00,0.00,'','0000000000','JJN 60 YS','','','','2022-06-22 07:40:27',15,'','772','','0000-00-00 00:00:00','772','2022-06-22 07:45:24'),(105,'21','237','2022-05-16',2,1,680.00,45000.00,0.00,0.00,30600000.00,0.00,'','000000009','BAU 308 ZE ','','','','2022-06-22 07:41:15',15,'','772','','0000-00-00 00:00:00','772','2022-06-22 07:44:07'),(106,'21','237','2022-06-16',1,1,165.00,45000.00,0.00,0.00,7425000.00,0.00,'','000000009','JJN 60 YS','','','','2022-06-22 07:42:12',15,'','772','','0000-00-00 00:00:00','772','2022-06-22 07:43:00'),(107,'21','237','2022-05-17',2,1,680.00,60000.00,0.00,0.00,40800000.00,0.00,'','0000000000','BAU 981 XR','','','','2022-06-22 14:02:05',15,'','772','','0000-00-00 00:00:00','772','2022-06-22 14:08:34'),(108,'21','237','2022-05-17',2,1,680.00,30000.00,0.00,0.00,20400000.00,0.00,'','009988','JJN 60 YS','','','','2022-06-22 14:03:29',15,'','772','','0000-00-00 00:00:00','772','2022-06-22 14:10:38'),(109,'21','237','2022-05-20',2,1,680.00,45000.00,0.00,0.00,20400000.00,0.00,'','009988','JJN 60 YS','','','','2022-06-22 14:03:29',15,'','772','772','2022-06-23 06:31:43','772','2022-06-24 08:34:56'),(110,'21','237','2022-05-17',1,1,165.00,45000.00,0.00,0.00,7425000.00,0.00,'','00097','JJN 60 YS','','','','2022-06-22 14:05:14',15,'','772','','0000-00-00 00:00:00','772','2022-06-22 14:06:47'),(111,'21','237','2022-05-19',2,1,680.00,40000.00,0.00,0.00,27200000.00,0.00,'','0000000','TRR 540 YX','','','','2022-06-22 16:24:02',15,'','772','','0000-00-00 00:00:00','772','2022-06-22 16:24:28'),(112,'21','237','2022-05-20',2,1,680.00,46417.00,0.00,0.00,31563560.00,0.00,'','009988','BAU 491 YP ','','','','2022-06-23 06:44:41',15,'','772','','0000-00-00 00:00:00','772','2022-06-23 06:45:24'),(113,'21','237','2022-05-21',1,1,165.00,45000.00,0.00,0.00,7425000.00,0.00,'','000000009','JJN 60 YS','','','','2022-06-24 08:33:12',15,'','772','','0000-00-00 00:00:00','772','2022-06-24 08:47:09'),(114,'21','237','2022-05-21',1,1,165.00,24200.00,0.00,0.00,3993000.00,0.00,'','','DBM 213 XA','','','','2022-06-24 08:34:20',15,'','772','','0000-00-00 00:00:00','772','2022-06-24 08:38:30'),(115,'21','237','2022-05-23',2,1,680.00,45000.00,0.00,0.00,30600000.00,0.00,'','00097','TRR 540 YX','','','','2022-06-25 09:21:58',15,'','772','','0000-00-00 00:00:00','772','2022-06-25 09:22:44'),(116,'21','237','2022-05-23',1,1,165.00,39126.00,0.00,0.00,6455790.00,0.00,'','500000','BAU 258 ZE ','','','','2022-07-22 10:49:39',15,'','772','','0000-00-00 00:00:00','772','2022-07-22 10:51:36'),(117,'21','237','2022-05-24',1,1,165.00,49600.00,0.00,0.00,8184000.00,0.00,'','0000000','YLA 50 XM ','','','','2022-07-25 17:56:06',15,'','772','','0000-00-00 00:00:00','772','2022-07-25 17:56:34'),(118,'21','237','2022-05-24',2,1,700.00,57623.00,0.00,0.00,40336100.00,0.00,'','0000000000','BAU 981 XR','','','','2022-07-25 18:39:14',15,'','772','','0000-00-00 00:00:00','772','2022-07-25 18:39:54'),(119,'21','237','2022-05-25',2,1,700.00,45000.00,0.00,0.00,31500000.00,0.00,'','0000000000','TRR 540 YX','','','','2022-07-25 18:50:18',15,'','772','','0000-00-00 00:00:00','772','2022-07-25 18:50:37'),(120,'21','237','2022-07-27',2,1,700.00,15000.00,0.00,0.00,10500000.00,0.00,'','0000000','GKW 128 XA','','','','2022-07-27 14:53:59',15,'','772','','0000-00-00 00:00:00','772','2022-07-27 14:56:41'),(121,'21','237','2022-05-26',1,1,165.00,50000.00,0.00,0.00,8250000.00,0.00,'','0000000000','BAU 249 XR','','','','2022-07-27 17:28:09',15,'','772','','0000-00-00 00:00:00','772','2022-07-27 17:32:19'),(122,'21','237','2022-05-26',1,1,165.00,45000.00,0.00,0.00,7425000.00,0.00,'','0000000000','JJN 60 YS','','','','2022-07-27 17:29:14',15,'','772','','0000-00-00 00:00:00','772','2022-07-27 17:43:47'),(123,'21','237','2022-05-26',2,1,720.00,42000.00,0.00,0.00,30240000.00,0.00,'','0000000000','BAU 491 YP ','','','','2022-07-27 17:56:11',15,'','772','','0000-00-00 00:00:00','772','2022-07-27 18:04:54'),(124,'21','237','2022-05-26',2,1,720.00,50000.00,0.00,0.00,36000000.00,0.00,'','0000000000','BAU 204 XR','','','','2022-07-27 17:57:17',15,'','772','','0000-00-00 00:00:00','772','2022-07-27 18:08:43'),(125,'21','237','2022-05-27',2,1,720.00,45000.00,0.00,0.00,32400000.00,0.00,'','0000000000','BAU 692 ZE ','','','','2022-07-27 19:50:09',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(126,'21','237','2022-05-27',2,1,720.00,45000.00,0.00,0.00,32400000.00,0.00,'','0000000000','BAU 692 ZE ','','','','2022-07-27 19:50:13',15,'','772','','0000-00-00 00:00:00','772','2022-07-27 19:51:08'),(127,'21','237','2022-05-28',1,1,165.00,50000.00,0.00,0.00,8250000.00,0.00,'','0000000000','BAU 249 XR','','','','2022-07-30 10:00:45',15,'','772','','0000-00-00 00:00:00','772','2022-07-30 10:01:13'),(128,'21','237','2022-05-29',1,1,165.00,45000.00,0.00,0.00,7425000.00,0.00,'','0000000000','JJN 60 YS','','','','2022-07-31 15:33:06',15,'','772','','0000-00-00 00:00:00','772','2022-07-31 15:33:52'),(129,'21','237','2022-05-30',1,1,165.00,45000.00,0.00,0.00,7425000.00,0.00,'','0000000000','BAU 285 YP','','','','2022-07-31 16:55:19',10,'','772','','0000-00-00 00:00:00','772','2022-07-31 16:56:30'),(130,'21','237','2022-05-31',2,1,720.00,50000.00,0.00,0.00,36000000.00,0.00,'','0000000000','T98a31LA','','','','2022-07-31 17:36:06',10,'','772','','0000-00-00 00:00:00','772','2022-07-31 17:40:34');
/*!40000 ALTER TABLE `purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_payments`
--

DROP TABLE IF EXISTS `purchases_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `supplier_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`supplier_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=518 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_payments`
--

LOCK TABLES `purchases_payments` WRITE;
/*!40000 ALTER TABLE `purchases_payments` DISABLE KEYS */;
INSERT INTO `purchases_payments` VALUES (1,'21','237','2022-03-24',1,'','','10',1698823.00,'2','','','15','shafa sapale','BA56',36788112.00,'2022-03-26 17:18:13',5,'','764','','0000-00-00 00:00:00','781','2022-03-26 19:08:31'),(2,'21','237','2022-03-24',1,'','','10',1508290.00,'2','','','15','shafa sapale','BA 58',0.00,'2022-03-26 17:18:58',5,'','764','','0000-00-00 00:00:00','781','2022-03-26 19:08:31'),(3,'21','237','2022-03-24',1,'','','10',491034.20,'2','','','9','shafa sapale','20 & 21',0.00,'2022-03-26 17:20:20',5,'','764','','0000-00-00 00:00:00','781','2022-03-26 19:08:31'),(4,'21','237','2022-03-24',1,'','','10',594923.00,'2','','','18','shafa sapale','GT 25',0.00,'2022-03-26 17:21:10',5,'','764','','0000-00-00 00:00:00','781','2022-03-26 19:08:31'),(5,'21','237','2022-03-24',1,'','','5',2959820.00,'2','','','12','shafa sapale','0729',0.00,'2022-03-26 17:35:44',5,'','764','','0000-00-00 00:00:00','781','2022-03-26 19:08:31'),(6,'21','237','2022-03-24',1,'','','5',851000.00,'2','','','24','shafa sapale','1929',0.00,'2022-03-26 17:36:21',5,'','764','','0000-00-00 00:00:00','781','2022-03-26 19:08:31'),(7,'21','237','2022-03-24',1,'','','5',17604140.00,'2','','','13','shafa sapale','00',0.00,'2022-03-26 17:37:03',5,'','764','','0000-00-00 00:00:00','781','2022-03-26 19:08:31'),(8,'21','237','2022-03-24',1,'','','2',11000.00,'2','','','','','',0.00,'2022-03-26 17:37:44',5,'Depot expenses','764','','0000-00-00 00:00:00','781','2022-03-26 19:08:31'),(9,'21','237','2022-03-24',1,'','','2',1500.00,'2','','','','','',0.00,'2022-03-26 17:38:18',5,'Excort to Depot','764','','0000-00-00 00:00:00','781','2022-03-26 19:08:31'),(10,'21','237','2022-03-24',1,'','','2',563200.00,'2','','','','','',0.00,'2022-03-26 17:39:05',5,'hopemark','764','','0000-00-00 00:00:00','781','2022-03-26 19:08:31'),(11,'21','237','2022-03-24',1,'','','2',1715200.00,'2','','','','','',0.00,'2022-03-26 17:39:51',5,'mjo cement ','764','','0000-00-00 00:00:00','781','2022-03-26 19:07:41'),(12,'21','237','2022-03-24',1,'','','2',691200.00,'2','','','','','',0.00,'2022-03-26 17:40:34',5,'muhammed Alberlout','764','','0000-00-00 00:00:00','781','2022-03-26 19:07:41'),(13,'21','237','2022-03-24',1,'','','2',128000.00,'2','','','','','',0.00,'2022-03-26 17:41:07',5,'Kobbs','764','','0000-00-00 00:00:00','781','2022-03-26 19:07:41'),(14,'21','237','2022-03-24',1,'','','2',416000.00,'2','','','','','',0.00,'2022-03-26 17:41:40',5,'Joma Limited ','764','','0000-00-00 00:00:00','781','2022-03-26 19:07:41'),(15,'21','237','2022-03-24',1,'','','2',768000.00,'2','','','','','',0.00,'2022-03-26 17:42:11',5,'AA Bush ','764','','0000-00-00 00:00:00','781','2022-03-26 19:07:41'),(16,'21','237','2022-03-24',1,'','','2',245000.00,'2','','','','','',0.00,'2022-03-26 17:42:57',5,'Paul evans','764','','0000-00-00 00:00:00','781','2022-03-26 19:07:41'),(17,'21','237','2022-03-24',1,'','','2',93500.00,'2','','','','','',0.00,'2022-03-26 17:44:07',5,'BAU 207 XR and BAU 201 XR \r\nJamilu','764','','0000-00-00 00:00:00','781','2022-03-26 19:07:41'),(18,'21','237','2022-03-24',1,'','','2',448000.00,'2','','','','','',0.00,'2022-03-26 17:45:22',5,'consumption RBC 345 YL 700@640 \r\nSaico','764','','0000-00-00 00:00:00','781','2022-03-26 19:07:41'),(19,'21','237','2022-03-24',1,'','','2',32000.00,'2','','','','','',0.00,'2022-03-26 17:46:09',5,'JMT 865 ZH\r\nALLAS','764','','0000-00-00 00:00:00','781','2022-03-26 19:07:41'),(20,'21','237','2022-03-24',1,'','','2',416000.00,'2','','','','','',0.00,'2022-03-26 17:47:00',5,'CONSUMPTION BAU 225 XR 650@640','764','','0000-00-00 00:00:00','781','2022-03-26 19:07:41'),(21,'21','237','2022-03-24',1,'','','2',847000.00,'2','','','','','',0.00,'2022-03-26 17:48:02',5,'GME 490 XU 1300 @ 640 +15,000','764','','0000-00-00 00:00:00','781','2022-03-26 19:07:18'),(22,'21','237','2022-03-24',1,'','','2',751000.00,'2','','','','','',0.00,'2022-03-26 17:49:27',5,'JMT 711 ZH 1150 @640 + 15,000\r\nALLAS','764','','0000-00-00 00:00:00','781','2022-03-26 19:07:18'),(23,'21','237','2022-03-24',1,'','','2',367000.00,'2','','','','','',0.00,'2022-03-26 17:50:29',5,'YLA 558 ZY 550 @ 640 + 15,000\r\nAllas\r\n','764','','0000-00-00 00:00:00','781','2022-03-26 19:07:18'),(24,'21','237','2022-03-24',1,'','','2',480000.00,'2','','','','','',0.00,'2022-03-26 17:51:38',5,'BAU 59 ZY 750 @640 \r\nNingi','764','','0000-00-00 00:00:00','781','2022-03-26 19:07:18'),(25,'21','237','2022-03-24',1,'','','2',480000.00,'2','','','','','',0.00,'2022-03-26 17:52:31',5,'BAU 624 YP 750@640 \r\nNingi','764','','0000-00-00 00:00:00','781','2022-03-26 19:07:18'),(26,'21','237','2022-03-24',1,'','','2',729600.00,'2','','','','','',0.00,'2022-03-26 17:53:39',5,'ABC 207 XB 1140 @ 640 \r\nVas','764','','0000-00-00 00:00:00','781','2022-03-26 19:07:18'),(27,'21','237','2022-03-24',1,'','','2',586000.00,'2','','','','','',0.00,'2022-03-26 17:54:40',5,'JMT 284 ZY 900@640 + 10000\r\nSAICO','764','','0000-00-00 00:00:00','781','2022-03-26 19:07:18'),(28,'21','237','2022-03-24',1,'','','2',783000.00,'2','','','','','',0.00,'2022-03-26 17:55:42',5,'KTG 151 XC 1200@640 +15000','764','','0000-00-00 00:00:00','781','2022-03-26 19:07:18'),(29,'21','237','2022-03-24',1,'','','2',518400.00,'2','','','','','',0.00,'2022-03-26 18:01:51',5,'Abernut','764','','0000-00-00 00:00:00','781','2022-03-26 19:07:18'),(30,'21','237','2022-03-24',1,'','','2',9500.00,'2','','','','','',0.00,'2022-03-26 18:02:38',5,'Air Condition repairs','764','','0000-00-00 00:00:00','781','2022-03-26 19:07:18'),(31,'21','237','2022-03-25',1,'','','10',381630.00,'3','','','15','shafa sapale','BA56',30830719.55,'2022-03-27 12:36:20',5,'','764','','0000-00-00 00:00:00','781','2022-03-27 13:45:32'),(32,'21','237','2022-03-25',1,'','','10',402170.00,'3','','','15','shafa sapale','BA 58',0.00,'2022-03-27 12:38:23',5,'','764','','0000-00-00 00:00:00','781','2022-03-27 13:45:32'),(33,'21','237','2022-03-25',1,'','','10',269480.00,'3','','','9','shafa sapale','ba 20',0.00,'2022-03-27 12:39:41',5,'','764','','0000-00-00 00:00:00','781','2022-03-27 13:45:32'),(34,'21','237','2022-03-25',1,'','','5',10000.00,'3','','','9','shafa sapale','ba 21',0.00,'2022-03-27 12:42:05',5,'','764','','0000-00-00 00:00:00','781','2022-03-27 13:45:32'),(35,'21','237','2022-03-27',1,'','','10',1595340.00,'3','','','18','shafa sapale','ba 20',0.00,'2022-03-27 12:43:20',5,'','764','','0000-00-00 00:00:00','781','2022-03-27 13:45:32'),(37,'21','237','2022-03-27',1,'','','2',390400.00,'3','','','','','',0.00,'2022-03-27 12:46:57',5,'credit to alberlout','764','','0000-00-00 00:00:00','781','2022-03-27 13:45:32'),(38,'21','237','2022-03-25',1,'','','2',838400.00,'3','','','','','',0.00,'2022-03-27 12:47:39',5,'credit to henalink','764','764','2022-03-27 13:15:32','781','2022-03-27 13:45:07'),(39,'21','237','2022-03-25',1,'','','2',2604800.00,'3','','','','','',0.00,'2022-03-27 12:48:13',5,'credit to hope mack','764','764','2022-03-27 13:16:05','781','2022-03-27 13:45:07'),(40,'21','237','2022-03-27',1,'','','2',1280000.00,'3','','','','','',0.00,'2022-03-27 12:48:41',5,'credit to mjo cement','764','764','2022-03-27 13:16:35','781','2022-03-27 13:45:07'),(41,'21','237','2022-03-27',1,'','','2',2944000.00,'3','','','','','',0.00,'2022-03-27 12:49:18',5,'langley ltd','764','764','2022-03-27 13:15:05','781','2022-03-27 13:45:07'),(42,'21','237','2022-03-27',1,'','','2',1184000.00,'3','','','','','',0.00,'2022-03-27 12:51:09',5,'credit to kabiru','764','764','2022-03-27 13:13:43','781','2022-03-27 13:45:07'),(43,'21','237','2022-03-27',1,'','','2',320000.00,'3','','','','','',0.00,'2022-03-27 12:51:39',5,'kobbs','764','764','2022-03-27 13:13:23','781','2022-03-27 13:45:07'),(44,'21','237','2022-03-27',1,'','','2',128000.00,'3','','','','','',0.00,'2022-03-27 12:52:58',5,'','764','','0000-00-00 00:00:00','781','2022-03-27 13:45:07'),(45,'21','237','2022-03-27',1,'','','2',64000.00,'3','','','','','',0.00,'2022-03-27 12:53:32',5,'','764','','0000-00-00 00:00:00','781','2022-03-27 13:45:07'),(46,'21','237','2022-03-27',1,'','','2',128000.00,'3','','','','','',0.00,'2022-03-27 12:55:33',5,'BAU 686 ZE 200@640 \r\niNUSA ','764','','0000-00-00 00:00:00','781','2022-03-27 13:45:06'),(47,'21','237','2022-03-25',1,'','','2',64000.00,'3','','','','','',0.00,'2022-03-27 12:56:46',5,'BAU 498 XR consumption 100@640 \r\nFaisal','764','','0000-00-00 00:00:00','781','2022-03-27 13:45:06'),(48,'21','237','2022-03-25',1,'','','2',448000.00,'3','','','','','',0.00,'2022-03-27 12:57:47',5,'BAU 196 YP consumption 700@640 \r\nkalas','764','','0000-00-00 00:00:00','781','2022-03-27 13:44:42'),(49,'21','237','2022-03-25',1,'','','2',320000.00,'3','','','','','',0.00,'2022-03-27 12:58:44',5,'BAU 420 YP consumption 500@640 \r\nkalas','764','','0000-00-00 00:00:00','781','2022-03-27 13:44:42'),(50,'21','237','2022-03-25',1,'','','2',64000.00,'3','','','','','',0.00,'2022-03-27 12:59:34',5,'BAU 678 ZE consumption 100@640 \r\nInusa','764','','0000-00-00 00:00:00','781','2022-03-27 13:44:42'),(51,'21','237','2022-03-25',1,'','','2',495000.00,'3','','','','','',0.00,'2022-03-27 13:01:01',5,'JMT 865 ZH consumption 750@640 \r\niNUSA','764','','0000-00-00 00:00:00','781','2022-03-27 13:44:42'),(52,'21','237','2022-03-25',1,'','','2',448000.00,'3','','','','','',0.00,'2022-03-27 13:01:49',5,'JMT 42 XF consumption 700@640 \r\nallas','764','','0000-00-00 00:00:00','781','2022-03-27 13:44:42'),(53,'21','237','2022-03-25',1,'','','2',64000.00,'3','','','','','',0.00,'2022-03-27 13:02:35',5,'BAU 582 ZE consumption 100 @ 640 \r\nInusa','764','','0000-00-00 00:00:00','781','2022-03-27 13:44:42'),(54,'21','237','2022-03-25',1,'','','2',847000.00,'3','','','','','',0.00,'2022-03-27 13:04:00',5,'JMT 141 XC consumption 1,300 @ 640 +15,000\r\nAllas','764','','0000-00-00 00:00:00','781','2022-03-27 13:44:42'),(55,'21','237','2022-03-25',1,'','','2',431000.00,'3','','','','','',0.00,'2022-03-27 13:05:28',5,'JJN 498 XB consumption 650@640 + 15,000','764','','0000-00-00 00:00:00','781','2022-03-27 13:44:42'),(56,'21','237','2022-03-25',1,'','','2',64000.00,'3','','','','','',0.00,'2022-03-27 13:06:31',5,'BAU 184 ZE consumption 100@640 \r\nfaisal','764','','0000-00-00 00:00:00','781','2022-03-27 13:44:42'),(57,'21','237','2022-03-25',1,'','','2',64000.00,'3','','','','','',0.00,'2022-03-27 13:07:11',5,'BAU 491 XR consumption 100@640 \r\nfaisal','764','','0000-00-00 00:00:00','781','2022-03-27 13:44:42'),(58,'21','237','2022-03-25',1,'','','2',64000.00,'3','','','','','',0.00,'2022-03-27 13:07:56',5,'BAU 662 ZE consumption 100@640 \r\nFaisa','764','','0000-00-00 00:00:00','781','2022-03-27 13:44:24'),(59,'21','237','2022-03-25',1,'','','2',153600.00,'3','','','','','',0.00,'2022-03-27 13:09:23',5,'AGO to Gen. 240@ 640\r\nDahiru','764','','0000-00-00 00:00:00','781','2022-03-27 13:44:23'),(61,'21','237','2022-03-24',1,'','','2',128000.00,'3','','','','','',0.00,'2022-03-27 13:23:51',5,'BAU 655 ZE consumption 200@640 \r\nInusa','764','','0000-00-00 00:00:00','781','2022-03-27 13:44:23'),(62,'21','237','2022-03-25',1,'','','2',64000.00,'3','','','','','',0.00,'2022-03-27 13:24:44',5,'BAU 678 ZE consumption 100@640\r\nInusa','764','','0000-00-00 00:00:00','781','2022-03-27 13:44:23'),(63,'21','237','2022-03-25',1,'','','5',14471800.00,'3','','','13','shafa sapale','0001',0.00,'2022-03-27 13:25:59',5,'','764','','0000-00-00 00:00:00','781','2022-03-27 13:44:23'),(64,'21','237','2022-03-25',1,'','','2',73750.00,'3','','','','','',0.00,'2022-03-27 13:26:50',5,'station expenses','764','','0000-00-00 00:00:00','781','2022-03-27 13:44:23'),(65,'21','237','2022-03-25',1,'','','2',47000.00,'3','','','','','',0.00,'2022-03-27 13:28:24',5,'staff shortage','764','','0000-00-00 00:00:00','781','2022-03-27 13:44:23'),(66,'21','237','2022-03-25',1,'','','5',106335.00,'3','','','24','shafa sapale','1933',0.00,'2022-03-27 13:35:50',5,'','764','','0000-00-00 00:00:00','781','2022-03-27 13:44:23'),(67,'21','237','2022-03-25',1,'','','5',73015.00,'3','','','24','shafa sapale','1933',0.00,'2022-03-27 13:39:17',5,'','764','','0000-00-00 00:00:00','781','2022-03-27 13:44:23'),(68,'21','237','2022-03-24',1,'','','5',20.00,'2','','','24','shafa sapale','1933',0.00,'2022-03-27 13:42:17',5,'','764','','0000-00-00 00:00:00','781','2022-03-27 13:44:23'),(69,'21','237','2022-03-31',1,'','','2',847000.00,'5','','','','','',0.00,'2022-03-31 18:11:57',5,'jmt 52 yr 1,300@640 +15k','772','764','2022-03-31 18:24:27','781','2022-04-04 16:47:52'),(70,'21','237','2022-03-31',1,'','','2',874000.00,'5','','','','','',0.00,'2022-03-31 18:12:46',5,'yla 962 zv 1,350@640 +10k','772','764','2022-03-31 18:25:32','781','2022-04-04 16:47:52'),(71,'21','237','2022-03-31',1,'','','2',19400.00,'5','','','','','',0.00,'2022-03-31 18:13:26',5,'station expenses','772','764','2022-03-31 18:26:41','781','2022-04-04 16:47:52'),(72,'21','237','2022-03-26',1,'','','5',10572215.00,'5','','','13','aym shafa sapele road','1011',0.00,'2022-03-31 18:15:47',5,'','772','','0000-00-00 00:00:00','781','2022-04-04 16:47:52'),(73,'21','237','2022-03-26',1,'','','10',2461435.00,'5','','','15','aym shafa sapele road','090',0.00,'2022-03-31 18:23:59',5,'','772','','0000-00-00 00:00:00','781','2022-04-04 16:47:52'),(74,'21','237','2022-03-26',1,'','','10',1480446.00,'5','','','9','aym shafa sapele road','1011',0.00,'2022-03-31 18:25:20',5,'','772','','0000-00-00 00:00:00','781','2022-04-04 16:47:30'),(75,'21','237','2022-03-26',1,'','','10',863025.00,'5','','','18','aym shafa sapele road','ba51',0.00,'2022-03-31 18:26:24',5,'','772','','0000-00-00 00:00:00','781','2022-04-04 16:47:30'),(76,'21','237','2022-03-31',1,'','','2',115200.00,'5','','','','','',0.00,'2022-03-31 18:27:04',5,'kobbs','772','','0000-00-00 00:00:00','781','2022-04-04 16:47:30'),(77,'21','237','2022-03-31',1,'','','2',448000.00,'5','','','','','',0.00,'2022-03-31 18:27:52',5,'hope mack','772','','0000-00-00 00:00:00','781','2022-04-04 16:47:30'),(78,'21','237','2022-03-26',1,'','','2',562340.00,'5','','','','','',0.00,'2022-03-31 18:28:39',5,'albalout','772','','0000-00-00 00:00:00','781','2022-04-04 16:47:30'),(79,'21','237','2022-03-31',1,'','','2',64000.00,'5','','','','','',0.00,'2022-03-31 18:29:14',5,'yla 961 zv','772','','0000-00-00 00:00:00','781','2022-04-04 16:47:30'),(80,'21','237','2022-03-31',1,'','','2',1088000.00,'5','','','','','',0.00,'2022-03-31 18:29:53',5,'kabiru','772','','0000-00-00 00:00:00','781','2022-04-04 16:47:30'),(81,'21','237','2022-03-26',1,'','','2',64000.00,'5','','','','','',0.00,'2022-03-31 18:30:31',5,'kaura','772','','0000-00-00 00:00:00','781','2022-04-04 16:47:30'),(82,'21','237','2022-03-26',1,'','','2',960000.00,'5','','','','','',0.00,'2022-03-31 18:30:59',5,'','772','','0000-00-00 00:00:00','781','2022-04-04 16:47:30'),(83,'21','237','2022-03-26',1,'','','5',5062110.00,'5','','','24','aym shafa sapele road','1011',0.00,'2022-03-31 18:33:50',5,'','772','','0000-00-00 00:00:00','781','2022-04-04 16:47:30'),(84,'21','237','2022-04-27',1,'','','5',2176312.19,'6','','','15','aym shafa sapele road','ba 56/57',0.00,'2022-04-05 11:31:36',5,'stanbic pos','772','764','2022-04-05 12:20:06','781','2022-04-05 17:01:09'),(85,'21','237','2022-04-27',1,'','','5',587900.00,'6','','','9','aym shafa sapele road','f22',0.00,'2022-04-05 11:32:42',5,'','772','','0000-00-00 00:00:00','781','2022-04-05 17:01:09'),(86,'21','237','2022-04-27',1,'','','5',1782592.62,'6','','','18','aym shafa sapele road','gt 21',0.00,'2022-04-05 11:34:31',5,'','772','','0000-00-00 00:00:00','781','2022-04-05 17:01:09'),(87,'21','237','2022-04-27',1,'','','2',3300.00,'6','','','','','',0.00,'2022-04-05 11:35:30',5,'ovie pms','772','','0000-00-00 00:00:00','781','2022-04-05 17:01:09'),(88,'21','237','2022-04-27',1,'','','2',128000.00,'6','','','','','',0.00,'2022-04-05 11:36:08',5,'paul evans','772','764','2022-04-05 12:19:36','781','2022-04-05 17:01:09'),(89,'21','237','2022-04-27',1,'','','2',192000.00,'6','','','','','',24252097.50,'2022-04-05 11:36:45',5,'kobbs','772','','0000-00-00 00:00:00','781','2022-04-05 17:01:09'),(90,'21','237','2022-03-27',1,'','','2',448000.00,'6','','','','','',0.00,'2022-04-05 11:37:35',5,'ambassoor','772','','0000-00-00 00:00:00','781','2022-04-05 17:01:09'),(91,'21','237','2022-03-27',1,'','','2',96000.00,'6','','','','','',0.00,'2022-04-05 11:39:37',5,'bau 215 xr 150@640','772','','0000-00-00 00:00:00','781','2022-04-05 17:00:32'),(92,'21','237','2022-03-27',1,'','','2',512000.00,'6','','','','','',0.00,'2022-04-05 11:40:59',5,'alk 727 xr 800@640','772','','0000-00-00 00:00:00','781','2022-04-05 17:00:32'),(93,'21','237','2022-03-27',1,'','','2',416000.00,'6','','','','','',0.00,'2022-04-05 11:42:06',5,'bau 202 xr 650@640','772','','0000-00-00 00:00:00','781','2022-04-05 17:00:32'),(94,'21','237','2022-03-27',1,'','','2',384000.00,'6','','','','','',0.00,'2022-04-05 11:43:42',5,'bau 241 xr 600@640','772','','0000-00-00 00:00:00','781','2022-04-05 17:00:32'),(95,'21','237','2022-04-05',1,'','','2',352000.00,'6','','','','','',0.00,'2022-04-05 11:45:22',5,'trr 68 yx 550@640','772','','0000-00-00 00:00:00','781','2022-04-05 17:00:32'),(96,'21','237','2022-03-27',1,'','','2',448000.00,'6','','','','','',0.00,'2022-04-05 11:50:09',5,'bau 603 ze','772','','0000-00-00 00:00:00','781','2022-04-05 17:00:32'),(97,'21','237','2022-04-05',1,'','','2',21000.00,'6','','','','','',0.00,'2022-04-05 11:51:05',5,'staff short','772','','0000-00-00 00:00:00','781','2022-04-05 17:00:32'),(98,'21','237','2022-04-05',1,'','','2',3115.00,'6','','','','','',0.00,'2022-04-05 11:52:31',5,'staff short','772','','0000-00-00 00:00:00','781','2022-04-05 17:00:32'),(99,'21','237','2022-03-27',1,'','','5',328680.00,'6','','','24','aym shafa sapele road','119',0.00,'2022-04-05 11:54:56',5,'','772','','0000-00-00 00:00:00','781','2022-04-05 17:00:32'),(100,'21','237','2022-03-27',1,'','','5',16373450.00,'6','','','13','aym shafa sapele road','090',0.00,'2022-04-05 12:17:43',5,'lodgement toUBA','772','','0000-00-00 00:00:00','781','2022-04-05 17:00:32'),(101,'21','237','2022-04-12',1,'','','5',10956240.00,'8','','','13','aym shafa sapele road','GOAT',24493549.50,'2022-04-12 12:27:29',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(102,'21','237','2022-03-29',1,'','','5',1140620.00,'8','','','24','aym shafa sapele road','1011',0.00,'2022-04-12 12:28:54',5,'','772','','0000-00-00 00:00:00','780','2022-04-12 18:35:36'),(103,'21','237','2022-04-12',1,'','','5',2346637.00,'8','','','15','aym shafa sapele road','ba 56/57',0.00,'2022-04-12 12:31:14',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(104,'21','237','2022-03-29',1,'','','5',1375420.00,'8','','','18','aym shafa sapele road','ba51',0.00,'2022-04-12 12:32:26',5,'','772','','0000-00-00 00:00:00','780','2022-04-12 19:06:50'),(105,'21','237','2022-04-12',1,'','','2',2291200.00,'8','','','','','',0.00,'2022-04-12 12:33:09',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(106,'21','237','2022-03-29',1,'','','2',6850280.00,'8','','','','','',0.00,'2022-04-12 15:51:28',0,'YLA 433 XU 850@640 +15K\r\nBAU 29 ZE, 650@640 \r\nSHM 380 XA 1,200@640 10K\r\nJMT 949 ZH 900@640 +15K\r\nFUR 213 XA 1,250@640 +10K\r\nJMT 24 XA, 1000@640 +15K \r\nYLA 719 XU, 750@640 +15K\r\nEPE 03 XD, 320@640\r\nJMT 186 XC, 700@640 +10K\r\nALK 824 XA 750@640 +10K\r\nYLA 580 XM, 1,400@ +10K\r\nJRE 570 XA, 750@640 +10K\r\nAGO TO GEN #7,480','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(107,'21','237','2022-03-29',1,'','','5',4888630.00,'8','','','24','aym shafa sapele road','ba 56/57',0.00,'2022-04-12 15:58:28',5,'','772','','0000-00-00 00:00:00','780','2022-04-12 19:14:37'),(108,'21','237','2022-03-30',1,'','','2',10624000.00,'9','','','','','',36715896.40,'2022-04-14 18:16:59',0,'YLA 783 XM 700@640\r\nJMT 660 YR 1,100@640\r\nBAU 304 ZE, 100@640\r\nYLA 403 ZV, 800@640\r\nYLA 46 ZV, 800@640\r\nJMT 25 ZY 900@640\r\nBAU 782 ZE, 600@640\r\nTRR 905 XA, 750@640\r\nYLA 961 ZV, 700@640, 10K FEEDING\r\nALK 824 XA, SPARE PART\r\nJMT 940 ZH, 550@640, 15K\r\nT000 71 JG, 500@640\r\nFUR 198 XA, 700@640 +10K\r\nALK 833 XA, 600@640\r\nJMT 26 ZY, 900@640\r\nJMT 769 YP, 900@640\r\nJMT 76 YR, 900@640\r\nYLA 45 ZV, 800@640\r\nDKA 787 ZV, 900@640\r\nBAU 298 XR, 400@640\r\nHJA 375 XA, 600@640\r\nKZR 502 XA, 600@640, +15K\r\nBAU 489 XR, 200@640\r\nJHN 575 XA, 1,200@640, +15K\r\nBAU 308 ZE, 100@640\r\n','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(109,'21','237','2022-03-30',1,'','','2',778000.00,'9','','','','','',0.00,'2022-04-14 18:24:28',0,'TRUCK HIRE BALANCE\r\nJJN 60 YS\r\nSALARY','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(110,'21','237','2022-03-30',1,'','','2',2572800.00,'9','','','','','',0.00,'2022-04-14 18:25:41',0,'MJO CEMENT','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(111,'21','237','2022-04-14',1,'','','2',1760000.00,'9','','','','','',0.00,'2022-04-14 18:26:25',0,'CHINEDU','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(112,'21','237','2022-04-14',1,'','','2',237000.00,'9','','','','','',0.00,'2022-04-14 18:26:58',0,'PAUL EVANS','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(113,'21','237','2022-03-30',1,'','','2',256000.00,'9','','','','','',0.00,'2022-04-14 18:27:52',0,'KOBBS','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(114,'21','237','2022-03-30',1,'','','2',1104000.00,'9','','','','','',0.00,'2022-04-14 18:29:45',0,'LANGLY','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(115,'21','237','2022-03-30',1,'','','2',716800.00,'9','','','','','',0.00,'2022-04-14 18:30:47',0,'HENALINK','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(116,'21','237','2022-03-30',1,'','','2',484000.00,'9','','','','','',0.00,'2022-04-14 18:31:33',0,'MAI KANO','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(117,'21','237','2022-03-30',1,'','','2',486000.00,'9','','','','','',0.00,'2022-04-14 18:32:14',0,'ALBALOUT','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(118,'21','237','2022-03-30',1,'','','2',320000.00,'9','','','','','',0.00,'2022-04-14 18:32:59',0,'ALH DAIRU','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(119,'21','237','2022-03-30',1,'','','2',70000.00,'9','','','','','',0.00,'2022-04-14 18:33:39',0,'ALH AMIN','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(120,'21','237','2022-03-30',1,'','','5',2450000.00,'9','','','24','aym shafa sapele road','f22',0.00,'2022-04-14 18:35:58',5,'','772','','0000-00-00 00:00:00','780','2022-04-22 09:51:32'),(121,'21','237','2022-03-30',1,'','','5',2061000.00,'9','','','24','aym shafa sapele road','119',0.00,'2022-04-14 18:37:01',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(122,'21','237','2022-03-30',1,'','','10',3782552.00,'9','','','15','aym shafa sapele road','ba 56/57',0.00,'2022-04-14 18:38:28',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(123,'21','237','2022-03-30',1,'','','10',512032.00,'9','','','9','aym shafa sapele road','1011',0.00,'2022-04-14 18:39:40',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(124,'21','237','2022-03-30',1,'','','10',240154.00,'9','','','18','aym shafa sapele road','119',0.00,'2022-04-14 18:40:27',5,'','772','','0000-00-00 00:00:00','780','2022-04-22 09:52:40'),(125,'21','237','2022-03-31',1,'BAU 261 XR','','2',384000.00,'11','','','','','',38513458.75,'2022-04-28 13:35:19',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(126,'21','237','2022-03-31',1,'JMT 145 ZY','','2',256000.00,'11','','','','','',0.00,'2022-04-28 13:39:49',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(127,'21','237','2022-03-31',1,'BAU59 ZY','','2',480000.00,'11','','','','','',0.00,'2022-04-28 13:42:56',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(128,'21','237','2022-03-31',1,'JMT 550 YR','','2',559000.00,'11','','','','','',0.00,'2022-04-28 13:43:45',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(129,'21','237','2022-03-31',1,'BAU 328 XA','','2',64000.00,'11','','','','','',0.00,'2022-04-28 13:44:50',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(130,'21','237','2022-03-31',1,'JMT 222 ZH','','2',591000.00,'11','','','','','',0.00,'2022-04-28 13:46:27',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(131,'21','237','2022-03-31',1,'JMT 03 XE','','2',576000.00,'11','','','','','',0.00,'2022-04-28 13:47:35',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(132,'21','237','2022-03-31',1,'ABC 208 XE','','2',832000.00,'11','','','','','',0.00,'2022-04-28 13:48:35',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(133,'21','237','2022-03-31',1,'FUR 200 XA','','2',778000.00,'11','','','','','',0.00,'2022-04-28 13:49:20',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(134,'21','237','2022-03-31',1,'JMT 192 XC','','2',64000.00,'11','','','','','',0.00,'2022-04-28 13:51:22',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(135,'21','237','2022-03-31',1,'JMT 141 XC','','2',256000.00,'11','','','','','',0.00,'2022-04-28 13:53:56',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(136,'21','237','2022-03-31',1,'SRP 466 XA','','2',559000.00,'11','','','','','',0.00,'2022-04-28 13:54:44',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(137,'21','237','2022-04-28',1,'JMT 873 ZH','','2',495000.00,'11','','','','','',0.00,'2022-04-28 13:56:10',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(138,'21','237','2022-03-31',1,'RBC 345 YL','','2',448000.00,'11','','','','','',0.00,'2022-04-28 13:59:10',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(139,'21','237','2022-03-31',1,'JMT 37 YQ','','2',847000.00,'11','','','','','',0.00,'2022-04-28 14:00:16',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(140,'21','237','2022-03-31',1,'BBR 327','','2',320000.00,'11','','','','','',0.00,'2022-04-28 14:01:06',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(141,'21','237','2022-04-28',1,'STATION EXPENSES','','2',78150.00,'11','','','','','',0.00,'2022-04-28 14:05:08',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(142,'21','237','2022-04-28',1,'SALARY TO STAFF','','2',110000.00,'11','','','','','',0.00,'2022-04-28 14:06:51',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(143,'21','237','2022-03-31',1,'UB 20.0','','5',14871720.00,'11','','','13','aym shafa sapele road','090',0.00,'2022-04-28 14:08:37',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(144,'21','237','2022-03-31',1,'BA 56 & 58','','5',3335532.00,'11','','','15','aym shafa sapele road','BA 56 & 58',0.00,'2022-04-28 14:16:07',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(145,'21','237','2022-03-31',1,'FIRST BANK','','5',192240.00,'11','','','9','aym shafa sapele road','f22',0.00,'2022-04-28 14:19:34',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(146,'21','237','2022-03-31',1,'GTB','','5',2910920.00,'11','','','18','aym shafa sapele road','GTB',0.00,'2022-04-28 14:20:45',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(147,'21','237','2022-03-31',1,'UNITY','','5',4819346.75,'11','','','24','aym shafa sapele road','NILL',0.00,'2022-04-28 14:22:07',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(148,'21','237','2022-04-01',1,'BUU 370 ZL','','2',288000.00,'12','','','','','',29788174.45,'2022-04-29 12:46:20',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(149,'21','237','2022-04-01',1,'YLA 171 XU','','2',847000.00,'12','','','','','',0.00,'2022-04-29 12:47:05',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(150,'21','237','2022-04-01',1,'JMT 11 XC','','2',783000.00,'12','','','','','',0.00,'2022-04-29 12:49:16',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(151,'21','237','2022-04-01',1,'GWA 938 YL','','2',480000.00,'12','','','','','',0.00,'2022-04-29 12:50:20',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(152,'21','237','2022-04-01',1,'BAU 449 ZE','','2',384000.00,'12','','','','','',0.00,'2022-04-29 12:51:08',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(153,'21','237','2022-04-01',1,'YLA 50 XM','','2',458000.00,'12','','','','','',0.00,'2022-04-29 12:52:03',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(154,'21','237','2022-04-01',1,'BAU 249 XR','','2',480000.00,'12','','','','','',0.00,'2022-04-29 12:52:46',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(155,'21','237','2022-04-01',1,'YLA 544 ZV','','2',847000.00,'12','','','','','',0.00,'2022-04-29 13:52:52',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(156,'21','237','2022-04-01',1,'JMT 23 XC','','2',847000.00,'12','','','','','',0.00,'2022-04-29 13:53:54',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(157,'21','237','2022-04-01',1,'BWR 671 XE','','2',384000.00,'12','','','','','',0.00,'2022-04-29 13:54:34',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(158,'21','237','2022-04-01',1,'ALK 836 XA','','2',416000.00,'12','','','','','',0.00,'2022-04-29 13:56:22',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(159,'21','237','2022-04-01',1,'ALK 826 XA','','2',416000.00,'12','','','','','',0.00,'2022-04-29 13:57:41',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(160,'21','237','2022-04-01',1,'AGO TO GEN','','2',216520.00,'12','','','','','',0.00,'2022-04-29 13:58:33',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(161,'21','237','2022-04-01',1,'STATION EXPENSES','','2',179480.00,'12','','','','','',0.00,'2022-04-29 13:59:51',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(162,'21','237','2022-04-01',1,'','','5',2143446.50,'12','','','15','aym shafa sapele road','ba 56/57',0.00,'2022-04-29 14:01:23',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(163,'21','237','2022-04-29',1,'','','5',1330603.00,'12','','','9','aym shafa sapele road','22',0.00,'2022-04-29 14:02:13',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(164,'21','237','2022-04-01',1,'','','5',1324078.50,'12','','','18','aym shafa sapele road','GT 22',0.00,'2022-04-29 14:03:04',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(165,'21','237','2022-04-01',1,'','','5',1201866.85,'12','','','24','aym shafa sapele road','119',0.00,'2022-04-29 14:04:03',5,'','772','','0000-00-00 00:00:00','764','2022-05-09 08:58:55'),(166,'21','237','2022-04-29',1,'','','5',12433240.00,'12','','','13','aym shafa sapele road','1011',0.00,'2022-04-29 14:05:37',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(167,'21','237','2022-04-02',1,'','','2',6965000.00,'14','','','','','',30654861.20,'2022-05-08 11:07:48',0,'BAU 491 YP 600@640\r\nBBR 403 XA 600@640\r\nMKA 218 ZE 900@640\r\nBAU 225 XR 600@640\r\nKWL 553 YH 700@640\r\nJMT 220 ZH 750@640\r\nKTG 151 XC 1200@640\r\nSBG 868 XA 1150@640\r\nYLA 433 XU 400@640\r\nBSA 689 XJ 150@640\r\nJJN 498 XJ 750@640\r\nBDG 114 XX 300@640\r\nYLA 180 ZV 1,300@640\r\nTOOO 70 JG 650@640\r\nJMT 99 XA 6540@640\r\n50 L TO GEN ','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(168,'21','237','2022-04-02',1,'','','2',63870.00,'14','','','','','',0.00,'2022-05-08 11:09:18',0,'DEPORT EXPENSES #6670\r\nRAMADAN FEEDING #15,700\r\nESCORT #1,500\r\nBAYELSA #40,000','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(169,'21','237','2022-04-02',1,'','','5',3973761.75,'14','','','15','aym shafa sapele road','090',0.00,'2022-05-08 11:10:44',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(170,'21','237','2022-04-02',1,'','','5',743916.00,'14','','','9','aym shafa sapele road','f22',0.00,'2022-05-08 11:11:36',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(171,'21','237','2022-04-02',1,'','','5',1014432.00,'14','','','18','aym shafa sapele road','ba 56/57',0.00,'2022-05-08 11:12:23',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(172,'21','237','2022-05-08',1,'','','5',9239388.00,'14','','','13','aym shafa sapele road','1011',0.00,'2022-05-08 11:13:07',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(173,'21','237','2022-04-02',1,'','','5',4458140.00,'14','','','24','aym shafa sapele road','119',0.00,'2022-05-08 11:13:58',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(174,'21','237','2022-05-14',1,'','','2',7465000.00,'15','','','','','',31634567.90,'2022-05-14 08:45:01',0,'JMT 865 ZH 1,200@640 +15K\r\nJMT 307 ZY 600@ 640 +10K\r\nYLA 558 ZV 1,200@640 +15K\r\nBAU 625 YP 1,300@640 +15K\r\nTRR 905 XA 750@640 \r\nKZR 505 XA 600@640\r\nUDU 158 XA 600@640 +10K\r\nYLA 290 ZV 400@640 \r\nBAU 420 YP 550@640 +5K\r\nKAL 217 XA 1,200@640 +15K\r\nJMT 284 ZY 1,200@640 +10K\r\nJMT 299 ZH 1,100@640 +10K\r\nBGR 75 XA 800@640 \r\n','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(175,'21','237','2022-04-05',1,'','','5',799055.00,'15','','','9','aym shafa sapele road','21',0.00,'2022-05-14 08:47:24',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(176,'21','237','2022-04-05',1,'','','5',1836780.00,'15','','','18','aym shafa sapele road','25',0.00,'2022-05-14 08:48:58',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(177,'21','237','2022-04-05',1,'','','5',2544780.00,'15','','','15','aym shafa sapele road','56&58',0.00,'2022-05-14 08:50:30',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(178,'21','237','2022-05-14',1,'','','2',174814.25,'15','','','','','',0.00,'2022-05-14 08:57:50',0,'STATION EXPENSES','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(179,'21','237','2022-04-05',1,'','','5',6253328.50,'15','','','12','aym shafa sapele road','f22',0.00,'2022-05-14 08:58:56',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(180,'21','237','2022-04-05',1,'','','5',7499718.83,'15','','','24','aym shafa sapele road','090',0.00,'2022-05-14 09:00:10',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(181,'21','237','2022-05-14',1,'','','2',6780000.00,'16','','','','','',33859192.45,'2022-05-14 13:54:22',0,'BAU 332 XA 100 @640\r\nMKA 932 ZF 1000 @640\r\nJMT 949 ZH  850 @640\r\nJMT 88 ZY 850 @640\r\nRBC 345 YL 1100 @ 640\r\nJMT 271 ZH 1100 @ 640\r\nMUB 789 XA 650 @ 640\r\nJMT 222 ZH 800 @640\r\nBAU 971 XR 5,000\r\nBAU 603 ZE 600 @640\r\nJMT 25 ZY 1350 @640\r\nALK 731XA 100 @640\r\nJMT 550 YR 400 @640\r\nGME 490 XU 700 @640\r\nJRE 570  XA 900 @640','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(182,'21','237','2022-04-06',1,'','','5',1775570.00,'16','','','15','aym shafa sapele road','56 & 58',0.00,'2022-05-14 13:57:42',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(183,'21','237','2022-04-06',1,'','','5',695476.62,'16','','','9','aym shafa sapele road','21 & 22',0.00,'2022-05-14 13:59:58',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(184,'21','237','2022-04-06',1,'STATION EXPENSES','','2',61500.00,'16','','','','','',0.00,'2022-05-14 14:02:46',0,'CANOPY 30,000\r\nSTATION 30,000\r\nESCORT     1500','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(185,'21','237','2022-04-06',1,'','','5',810865.00,'16','','','18','aym shafa sapele road','25',0.00,'2022-05-14 14:05:01',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(186,'21','237','2022-04-06',1,'','','5',9163800.00,'16','','','13','aym shafa sapele road','090',0.00,'2022-05-14 14:06:38',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(187,'21','237','2022-04-06',1,'','','5',6530490.00,'16','','','24','aym shafa sapele road','090',0.00,'2022-05-14 14:08:10',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(188,'21','237','2022-04-07',1,'','','2',4426200.00,'17','','','','','',37502849.15,'2022-05-14 15:52:06',0,'JMT 24 XC 800 @ 640\r\nBAU 318 XR 300 @640\r\nBWR 671 XE 550 @640\r\nBAU 391 ZE 1000 @640\r\nBAU 231 XR 600 @640\r\nALK 833 XA 650 @640 \r\nBAU 323 XR 1000 @640\r\nBAU 751 ZE 600 @640\r\nGWA 938 YL 750 @640\r\nJJN 498 XB  1150 @640 + 15K\r\nALK 836 XA 650 @640\r\nDKA 787 ZV 550 @640\r\nAGO TO GENERATOR 80 @640 ','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(189,'21','237','2022-04-07',1,'','','2',44900.00,'17','','','','','',0.00,'2022-05-14 15:54:57',0,'MEDICINE 1000\r\nWATER 2400\r\nCANOPY 20000\r\nESCORT 1500\r\nENVIROMENTAL AUDIT 20000','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(190,'21','237','2022-04-07',1,'','','5',16393505.30,'17','','','13','aym shafa sapele road','090',0.00,'2022-05-14 15:56:46',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(191,'21','237','2022-04-07',1,'','','5',3154835.00,'17','','','18','aym shafa sapele road','25',0.00,'2022-05-14 15:58:30',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(192,'21','237','2022-04-07',1,'','','5',1197150.00,'17','','','15','aym shafa sapele road','56 & 58',0.00,'2022-05-14 16:02:20',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(193,'21','237','2022-04-07',1,'','','5',2081164.06,'17','','','9','aym shafa sapele road','21 & 22',37502849.15,'2022-05-14 16:04:12',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(194,'21','237','2022-04-07',1,'','','5',4605190.00,'17','','','24','aym shafa sapele road','25',0.00,'2022-05-14 16:22:27',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(195,'21','237','2022-04-08',1,'','','2',10364000.00,'18','','','','','',32775703.30,'2022-05-15 12:23:56',0,'ALK 836 XA 5000\r\nJJJ 20 XS 200 @ 640\r\nRBC 346 YL 1300 @ 640\r\nDKA 130 XG 1150 @ 640\r\nALK 826 XA  500 @ 640\r\nJMT 26 ZY 900 @ 640\r\nJMT 218 YR 750 @ 640 +15K\r\nBAU 782 ZE 600 @ 640\r\nBAU 838 ZE 100 @ 640\r\nDNG 643 XA 900 @ 640\r\nGME 921 YX  1200 @ 640 + 15K\r\nFUR 198 XA 1000 @ 640 +10K\r\nKTG 276 YG 500 @ 640\r\nYLA 580 XM 1400 @ 640 +10K + 58K\r\nJMT 220 ZH 1300 @ 640 +15K\r\nJMT 660 YR 1150 @ 640 +10K\r\nYLA 961 ZV 1000 @ 640 + 10K\r\nYLA 45 ZV 750 @ 640\r\nDBM 212 XA 600 @ 640\r\nYLA 180 ZV 600 @ 640','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(196,'21','237','2022-04-08',1,'STATION EXPENSES','','2',140420.00,'18','','','','','',0.00,'2022-05-15 12:25:51',0,'NEPABILL 135,420\r\nESCORT    3000\r\nTRANSPORT 2000','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(197,'21','237','2022-04-08',1,'009','','5',5475950.00,'18','','','13','aym shafa sapele road','090',0.00,'2022-05-15 12:28:01',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(198,'21','237','2022-04-08',1,'','','5',1221310.00,'18','','','15','aym shafa sapele road','56 & 58',0.00,'2022-05-15 12:29:44',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(199,'21','237','2022-04-08',1,'','','5',528080.00,'18','','','9','aym shafa sapele road','21 & 22',0.00,'2022-05-15 12:31:24',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(200,'21','237','2022-04-08',1,'','','5',2046269.65,'18','','','18','aym shafa sapele road','25',0.00,'2022-05-15 12:32:39',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(201,'21','237','2022-04-08',1,'','','5',5899275.00,'18','','','24','aym shafa sapele road','119',32775703.30,'2022-05-15 12:34:06',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(202,'21','237','2022-04-09',1,'','','2',3507000.00,'19','','','','','',31005409.60,'2022-05-15 14:10:04',0,'JMT 35 YQ 850 @ 640+ 15K\r\nBAU 225 XR 600 @ 640 + 30k\r\nALK 833 XA 35000\r\nBAU 985 XR 100 @ 640\r\nBAU 672 YP 100 @ 640\r\nBAU 685 ZE 100 @ 640\r\nALK 826 XA 300 @ 640 + 10K\r\nBAU 735 ZE 750 @ 640\r\nBAU 655 ZE 100@ 640\r\nBAU 690 ZE 100 @ 640\r\nBAU 696 ZE 100 @ 640\r\nALK 730 XA 100 @ 640\r\nBAU 59 ZY 750 @ 640\r\nKTG 151 XC 1250 @ 640 + 15K\r\nALK 542 XA 100 @ 640\r\n','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(203,'21','237','2022-04-09',1,'STATION EXPENSES','','2',2500.00,'19','','','','','',0.00,'2022-05-15 14:10:56',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(204,'21','237','2022-04-09',1,'','','5',5636318.00,'19','','','15','aym shafa sapele road','56 & 58',0.00,'2022-05-15 14:12:33',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(205,'21','237','2022-04-09',1,'','','5',10194200.00,'19','','','13','aym shafa sapele road','090',0.00,'2022-05-15 14:15:08',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(206,'21','237','2022-04-09',1,'','','5',6735395.00,'19','','','24','aym shafa sapele road','090',0.00,'2022-05-15 14:17:59',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(207,'21','237','2022-04-10',1,'','','2',1253000.00,'20','','','','','',17562042.35,'2022-05-15 15:11:07',0,'TRR 68 YX 550 @ 640\r\nGAN 08 XA 750 @ 640\r\nBAU 583 ZE 100 @ 640\r\nBAU 450 ZE 100 @ 640\r\nBAU 656 ZE 100 @ 640\r\nBAU 701 ZE 150 @ 640\r\nBAU 684 ZE 150 @ 640\r\nAGO TO GENERATOR 50 @ 640','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(208,'21','237','2022-04-10',1,'','','2',67365.00,'20','','','','','',0.00,'2022-05-15 15:12:55',0,'PRESIDENT 3300\r\nPMS RTT 28.88\r\nPLUMBERING WORK  59200','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(209,'21','237','2022-04-10',1,'','','5',2846142.50,'20','','','15','aym shafa sapele road','56 & 58',0.00,'2022-05-15 15:14:15',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(210,'21','237','2022-04-10',1,'','','5',1267005.00,'20','','','24','aym shafa sapele road','090',0.00,'2022-05-15 15:16:32',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(211,'21','237','2022-04-10',1,'','','5',12565180.00,'20','','','13','aym shafa sapele road','090',17562042.35,'2022-05-15 15:17:40',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(212,'21','237','2022-04-11',1,'','','2',8486000.00,'21','','','','','',37182473.60,'2022-05-17 15:55:33',0,'BWR 671 XE 750  @ 640 \r\nFUR 200 XA 1100@ 640 +10K\r\nMUB 65 XA 750  @ 640  + 15K\r\nJMT 873 ZH 1300  @ 640 +15K \r\nALK 743 XA  5000\r\nEPE 03 XB 1350  @ 640 \r\nTRR 68 YX 5000\r\nT00071 JG 500  @ 640 \r\nBAU 490 ZE 600 @ 640 \r\nKZR 500 XA 500  @ 640  \r\nBAU 285  YP 550  @ 640 +30K\r\nJMT 53 YR 550  @ 640 +15K\r\nBUU 308 ZL 400  @ 640 \r\nJMT 37 YQ 700  @ 640 + 15K\r\nJMT 04 YA 800  @ 640 +15K \r\nGWA 938 YL  750   @ 640 \r\nYLA 479 XU 1300  @ 640 + 15K \r\nAAA 758 XE  1000  @ 640 \r\nAGO TO GENERATOR 93.75  @ 640 \r\nJMT 04 YA  800  @ 640 \r\n','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(213,'21','237','2022-04-11',1,'STATION EXPENSES','','2',37800.00,'21','','','','','',0.00,'2022-05-17 15:57:45',0,'ESCORT 1500\r\nPMS 151.56 25000\r\nDEPORT EXPENSES 11000','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(214,'21','237','2022-04-11',1,'','','5',4525320.00,'21','','','15','AYM SHAFA SAPELE ROAD','56&58',0.00,'2022-05-17 16:00:19',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(215,'21','237','2022-04-11',1,'','','5',9663500.00,'21','','','13','AYM SHAFA SAPELE ROAD','09999',0.00,'2022-05-17 16:08:54',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(216,'21','237','2022-04-11',1,'','','5',6553760.00,'21','','','24','AYM SHAFA SAPELE ROAD','0000',0.00,'2022-05-17 16:10:32',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(217,'21','237','2022-04-12',1,'','','2',10880000.00,'22','','','','','',35919232.65,'2022-05-19 14:13:12',0,'BAU 312 ZE 700 @ 640 \r\nGME 490 XA 1300 @ 640 +15K\r\nJMT 196 ZY  850 @ 640  +15K\r\nJMT 23 XC 1300 @ 640 + 15K\r\nJMT 99 XE 1300@ 640  +15K\r\nRBC 347 YL 1150 @ 640 \r\nDTM 128 XA  800 @ 640 \r\nJMT 949 ZH 800 @ 640  + 15K\r\nJMT 711 ZH 700 @ 640 \r\nYLA 719 XU 1300 @ 640  + 15K\r\nSRP 466 XA 1300 @ 640  + 15K\r\nBAU 353 ZE 650 @ 640 \r\nYLA 171 XU  1300 @ 640  +15K\r\nDUT 343 XC 650 @ 640 \r\nYLA 544 ZV 850 @ 640 + 15K\r\nJMT 191 XC 900@ 640  + 15K\r\nKAL 217 XA 900 @ 640  + 10K','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(218,'21','237','2022-04-12',1,'STATION EXPENSES','','2',1500.00,'22','','','','','',0.00,'2022-05-19 14:14:12',0,'ESCORT','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(219,'21','237','2022-04-12',1,'','','5',12918806.00,'22','','','13','AYM SHAFA SAPELE ROAD','0009',0.00,'2022-05-19 14:15:45',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(220,'21','237','2022-04-12',1,'','','5',1211700.00,'22','','','9','AYM SHAFA SAPELE ROAD','22',0.00,'2022-05-19 14:17:17',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(221,'21','237','2022-04-12',1,'','','5',903285.89,'22','','','15','AYM SHAFA SAPELE ROAD','57 & 58',35919232.65,'2022-05-19 14:19:55',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(222,'21','237','2022-04-12',1,'','','5',4142770.00,'22','','','24','AYM SHAFA SAPELE ROAD','000000',35919232.65,'2022-05-19 14:22:16',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(223,'21','237','2022-04-13',1,'','','2',3103000.00,'23','','','','','',33130399.30,'2022-05-19 17:11:10',0,'BAU 654 ZE 100@ 640 \r\nBAU 661 ZE 100 @ 640 \r\nGUS 499 XA 500 @ 640 \r\nJMT 88 ZY 900@ 640 \r\nBAU 241 XR 500\r\nBAU 312 ZE 500 @ 640 \r\nYLA 83 XU 850 @ 640 +15K\r\nBAU 313 XR 35000\r\nBAU 585 ZE 100 @ 640 \r\nJMT 307 ZY 600@ 640 +10K\r\nSHM 380 XA 700 @ 640 +10K\r\nBAU 803 ZE  5000\r\nBAU 441 ZE 100 @ 640 \r\nJJN 110 YZ 700 @ 640 \r\n\r\n','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(224,'21','237','2022-04-13',1,'STATION EXPENSES','','2',133000.00,'23','','','','','',0.00,'2022-05-19 17:13:12',0,'ESCORT 1500\r\nRAINCOAT 23000\r\nNUPENG  6000\r\nWATER 2500\r\nTOILET EVAC     100000','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(225,'21','237','2022-04-13',1,'','','5',12983630.00,'23','','','13','AYM SHAFA SAPELE ROAD','000000',0.00,'2022-05-19 17:14:41',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(226,'21','237','2022-04-13',1,'','','5',1133400.00,'23','','','9','AYM SHAFA SAPELE ROAD','21',0.00,'2022-05-19 17:21:01',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(227,'21','237','2022-04-13',1,'','','5',5140286.00,'23','','','15','AYM SHAFA SAPELE ROAD','57 & 58',33130399.30,'2022-05-19 17:23:01',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(228,'21','237','2022-04-13',1,'','','5',6189925.00,'23','','','24','AYM SHAFA SAPELE ROAD','000',0.00,'2022-05-19 17:26:34',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(229,'21','237','2022-04-14',1,'','','2',3360500.00,'24','','','','','',36779739.70,'2022-05-19 18:35:30',0,'YLA 15 ZY 750 @ 640\r\nBAU 261 XR 5000\r\nBAU 980 XR 100@ 640\r\nBAU 316 XR 100 @ 640\r\nBAU 692 ZE 100 @ 640\r\nBAU 786 YP 5000\r\nABC 208 XB 650 @ 640\r\nBAU 59 ZY 5000\r\nABC 207 XB 650 @ 640\r\nT9828LA 100 @ 640\r\nJMT 769 YR 750 @ 640\r\nRBC 345 YL 1300 @ 640\r\nBAU 301 ZE 350@ 640\r\nALK 736 XA 100 @ 640\r\nBAU 659 XE 100 @ 640\r\nBAU 317 YP 100 @ 640\r\nBAU 328 XR 9500\r\n','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(230,'21','237','2022-04-14',1,'','','2',36000.00,'24','','','','','',0.00,'2022-05-19 18:37:07',0,'ESCORT  3000\r\nPLUMBER  15000\r\nSALARY  18000','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(231,'21','237','2022-04-14',1,'','','5',12913870.00,'24','','','13','AYM SHAFA SAPELE ROAD','00000',0.00,'2022-05-19 18:38:19',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(232,'21','237','2022-05-14',1,'','','5',935323.00,'24','','','9','AYM SHAFA SAPELE ROAD','21',0.00,'2022-05-19 18:39:48',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(233,'21','237','2022-04-14',1,'','','5',3405850.00,'24','','','15','AYM SHAFA SAPELE ROAD','57 & 58',0.00,'2022-05-19 18:42:17',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(234,'21','237','2022-04-14',1,'','','5',5684846.70,'24','','','24','AYM SHAFA SAPELE ROAD','000000',0.00,'2022-05-19 18:46:22',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(235,'21','237','2022-04-15',1,'','','2',5943000.00,'25','','','','','',39573877.95,'2022-05-19 20:27:42',0,'BAU 274 XR 650 @640\r\nBAU 838 ZE 100 @ 640\r\nBAU 700 ZE. 100 @640\r\nJMT 218 YR 1200 @640+15K\r\nBWR 671 XE 50@640 \r\nGME 921 YX 700@640\r\nBAU 261 XR 5000\r\nALK 738 XA 150 @640 +15K\r\nBAU 584 ZE 150 @640+15K\r\nALK 826 XA 450 @640\r\nKWL 553 YH 850 @640\r\nBAU 479 XR 100@640\r\nBAU 702 ZE 100@640\r\nRBC 346 YL 700 @640\r\nYLA 555 ZV 750@ 640+15K\r\nBAU 237 XR 100 @640\r\nALK 733 XA 100 @640\r\nBAU 26 YP 850@640\r\nKWL 758 YL 750 @640\r\nBAU 49 ZE 600@640\r\nYLA 986 ZV 700@640\r\nAGO TO GENERATOR 50@640\r\n','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(236,'21','237','2022-04-15',1,'STATION EXPENSES','','2',80500.00,'25','','','','','',0.00,'2022-05-19 20:33:21',0,'Sweeping 56000\r\nEscort  3000\r\nDrainage 19000\r\nPlumber. 2500\r\n','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(237,'21','237','2022-04-15',1,'','','5',2108168.00,'25','','','9','AYM SHAFA WARRI SAPELE ROAD','21',0.00,'2022-05-19 20:35:53',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(238,'21','237','2022-04-15',1,'','','5',3944560.25,'25','','','15','AYM SHAFA WARRI SAPELE ROAD','57&58',0.00,'2022-05-19 20:38:57',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(239,'21','237','2022-04-15',1,'','','5',11376916.00,'25','','','13','AYM SHAFA WARRI SAPELE ROAD','00000000',39573877.95,'2022-05-19 20:40:00',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(240,'21','237','2022-04-15',1,'','','5',6715460.00,'25','','','24','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-05-19 20:42:14',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(241,'21','237','2022-04-16',1,'','','2',5177000.00,'26','','','','','',32878500.05,'2022-05-26 20:23:24',0,'HJA 375 XA 500@640\r\nBAU 274 XR 5000\r\nBAU 532 XR 29000\r\nFUR 198 XA 1200@640 +10K\r\nPTN 424 XA 600@640\r\nBWR 671 XE 750@ 640\r\nBKK 968 XA 1200@640\r\nMUB 65 XA 700@640\r\nBAU 218 XR 750@640\r\nGWA 938 YL 750@640\r\nALK 833 XA 650@ 640\r\nBAU 249 XR 850@640\r\nAGO TO GENERATOR 45000','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(242,'21','237','2022-04-16',1,'','','2',34600.00,'26','','','','','',0.00,'2022-05-26 20:25:35',0,'Escort 3000\r\nElectrician 2000\r\nEngr shefiu 5000\r\nGenerator service 23200\r\nRubber band 1400','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(243,'21','237','2022-04-16',1,'','','5',14396100.00,'26','','','13','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-05-26 20:27:34',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(244,'21','237','2022-04-16',1,'','','5',3272585.00,'26','','','24','AYM SHAFA WARRI SAPELE ROAD','0000',0.00,'2022-05-26 20:30:07',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(245,'21','237','2022-04-16',1,'','','5',1207170.00,'26','','','9','AYM SHAFA WARRI SAPELE ROAD','00009988',0.00,'2022-05-26 20:32:45',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(246,'21','237','2022-04-16',1,'','','5',2113847.00,'26','','','15','AYM SHAFA WARRI SAPELE ROAD','57&58',0.00,'2022-05-26 20:33:43',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(247,'21','237','2022-04-17',1,'','','2',5003000.00,'27','','','','','',27010766.55,'2022-05-30 22:24:36',0,'BAU 662 ZE 100 @640\r\nBAU 623 YP 750 @ 640\r\nJMT 271 ZH 650 @ 640\r\nBAU 889 ZE 100 @640\r\nBAU 587 ZE 100 @640\r\nBAU 196 YP 700 @640\r\nBAU 317 XR 100 @ 640\r\nJMT 45 YR 800 @640\r\nJJN 110 YZ 100 @640\r\nKTG 151 XC 1250 @640\r\nBAU 313 XR 100 @640\r\nBAU 481 XR 200 @640\r\nDLG 643 XA 950@ 640\r\nBUU 308 ZL 700 @640\r\nDNG 312 XA 700 @640\r\nBAU 498 XA 200@ 640\r\nBAU 318 YP 200 640\r\nBAU 982 XR  5000\r\nBAU 343 ZE 500\r\n\r\n\r\n','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(248,'21','237','2022-04-17',1,'','','2',53300.00,'27','','','','','',0.00,'2022-05-30 22:28:31',0,'President 3300\r\nShefiu 50000','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(249,'21','237','2022-04-17',1,'','','5',9603540.00,'27','','','13','AYM SHAFA WARRI SAPELE ROAD','0000',0.00,'2022-05-30 22:30:25',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(250,'21','237','2022-04-17',1,'','','5',13245456.00,'27','','','24','AYM SHAFA WARRI SAPELE ROAD','00009988',0.00,'2022-05-30 22:32:47',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(251,'21','237','2022-04-17',1,'','','5',584003.00,'27','','','9','AYM SHAFA WARRI SAPELE ROAD','20',0.00,'2022-05-30 22:34:48',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(252,'21','237','2022-04-17',1,'','','5',4321179.00,'27','','','15','AYM SHAFA WARRI SAPELE ROAD','57&58',0.00,'2022-05-30 22:37:00',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(253,'21','237','2022-04-18',1,'','','2',4133000.00,'28','','','','','',33414767.45,'2022-05-31 15:06:41',0,'DBM 217 XA  5000\r\nBAU 343 ZE 500\r\nDBM 219 XA 750 @640 \r\nUDU 158 XA 800 @640 +10K \r\nBAU 249 XR 5000\r\nJJN 498 XB 700@640\r\nBAU 422 YP 650 @ 640\r\nTRUCK HIRE BALANCE (JJN 60 YS) 78000\r\nMUB 789 XA 600 @ 640 +15K\r\nJMT 865 ZH 650 @ 640 +15K \r\nBAU 446 ZE 550@ 640 \r\nJMT 220 ZH 700@640\r\nALK 836 XA 650 @640\r\nBAU 287 XR 200 @ 640','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(254,'21','237','2022-04-18',1,'STATION EXPENSES','','2',51350.00,'28','','','','','',0.00,'2022-05-31 15:09:31',0,'Sand spreading 25000\r\nWater 2400\r\nPump repair 5000\r\nPms 50 @ 165  8250\r\nEscort 1500\r\nDetergent 9200','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(255,'21','237','2022-04-18',1,'','','5',15082100.00,'28','','','13','AYM SHAFA WARRI SAPELE ROAD','0000',0.00,'2022-05-31 15:11:54',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(256,'21','237','2022-04-18',1,'','','5',2245475.00,'28','','','24','AYM SHAFA WARRI SAPELE ROAD','00000000',33414767.45,'2022-05-31 15:13:12',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(257,'21','237','2022-04-18',1,'','','5',1094436.00,'28','','','9','AYM SHAFA WARRI SAPELE ROAD','21',0.00,'2022-05-31 15:14:56',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(258,'21','237','2022-04-18',1,'','','5',4232786.00,'28','','','15','AYM SHAFA WARRI SAPELE ROAD','57&58',0.00,'2022-05-31 15:16:57',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(259,'21','237','2022-04-19',1,'','','2',7927000.00,'29','','','','','',36359419.90,'2022-05-31 18:14:47',0,'JMT 550 YR 450@ 640+15K\r\nDTF 128 XA 700 @640 \r\nBAU 982 XR 5000\r\nJMT 108 ZY 700@640+10K\r\nJMT 37 YQ 700 @640 +15K\r\nJMT 191 XC 850 @640 +15K\r\nFUR 200 XA  700@640+10K\r\nJMT 222 ZH 450 @640+15K\r\nJMT 116 XC 850 @640+ 15K\r\nKAL 217 XA 700 @640 +10K\r\nYLA 432 XU 1000 @ 640 + 15K\r\nALK 965 XA 650 @ 640\r\nJMT 38 YQ 350 @640 \r\nJMT 940 ZH 600 @640 +15k\r\nYLA 567 XU 350@640+15K\r\nJMT 02 YA 750@640 15K\r\nJJJ 20 XS YR 1200 @  640 + 15K\r\nJMT 990 YR 450 @640 +15K\r\n\r\n','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(260,'21','237','2022-04-19',1,'STATION EXPENSES','','2',17300.00,'29','','','','','',0.00,'2022-05-31 18:16:56',0,'Chair repair 6000\r\nMopper 1600\r\nDepot 9700','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(261,'21','237','2022-04-19',1,'','','5',1276050.00,'29','','','9','AYM SHAFA WARRI SAPELE ROAD','20',0.00,'2022-05-31 18:22:26',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(262,'21','237','2022-04-19',1,'','','5',1650800.00,'29','','','15','AYM SHAFA WARRI SAPELE ROAD','58',0.00,'2022-05-31 18:23:22',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(263,'21','237','2022-04-19',1,'','','5',10958499.90,'29','','','13','AYM SHAFA WARRI SAPELE ROAD','0000',0.00,'2022-05-31 18:24:32',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(264,'21','237','2022-04-19',1,'','','5',465690.00,'29','','','24','AYM SHAFA WARRI SAPELE ROAD','0000',0.00,'2022-05-31 18:25:37',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(265,'21','237','2022-04-20',1,'','','2',6631000.00,'30','','','','','',41101926.06,'2022-05-31 19:27:10',0,'YLA 961 ZV 1200@ 640 +10K\r\nGME 921 YX 1300 @640+15K\r\nEPE 03 XD 850@ 640+10K\r\nGME 48 XC 1300 @ 640 +50K\r\nBAU 712 ZE 5000\r\nRBC 345 YL 800@640\r\nRBC 370 ZN 650@640\r\nJMT 307 ZY 700 @640+10K\r\nBAU 326 XR 5000\r\nBAU 625 YP 800@640+10K\r\nYLA 231 XA 1200 @640+10K\r\nALK 221 XA 100@640 \r\nJMT 70 XC 800 @640\r\nBAU 67 ZY 150 @640\r\nKTG 437 YG 150 @640\r\nMSA 125 XB 150 @ 640\r\n\r\n','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(266,'21','237','2022-04-20',1,'','','2',69644.25,'30','','','','','',0.00,'2022-05-31 19:30:13',0,'Pump repair 10000\r\nSand bucket 52700\r\nPms RTT 6344.25','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(267,'21','237','2022-04-20',1,'','','5',16114320.00,'30','','','13','AYM SHAFA WARRI SAPELE ROAD','0000',0.00,'2022-05-31 19:32:29',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(268,'21','237','2022-04-20',1,'','','5',5965222.95,'30','','','15','AYM SHAFA WARRI SAPELE ROAD','57&58',0.00,'2022-05-31 19:56:02',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(269,'21','237','2022-04-20',1,'','','5',1134827.50,'30','','','24','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-05-31 19:57:34',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(270,'21','237','2022-04-21',1,'','','2',2664000.00,'32','','','','','',38681448.05,'2022-06-02 11:48:16',0,'ALK 965 XA 25000\r\nBAU 59 ZY 70 @640+15K\r\nYLA 580 XM 1450@640 +35\r\nJMT 24 XE 550@640\r\nSRP 466 XA 750@640+ 15K\r\nAGO TO GEN 171.88','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(271,'21','237','2022-04-21',1,'STATION EXPENSES','','2',95500.00,'32','','','','','',0.00,'2022-06-02 11:49:27',0,'Plumber 5000\r\nEscort 1500\r\nFeeding 84 000\r\nSecurity 500','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(272,'21','237','2022-04-21',1,'','','5',4081809.50,'32','','','15','AYM SHAFA WARRI SAPELE ROAD','57&58',0.00,'2022-06-02 11:50:36',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(273,'21','237','2022-04-21',1,'','','5',7726180.00,'32','','','13','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-02 11:51:34',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(274,'21','237','2022-04-21',1,'','','5',9529890.00,'32','','','24','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-02 11:52:38',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(275,'21','237','2022-04-22',1,'','','2',11619116.80,'33','','','','','',38398414.15,'2022-06-02 12:42:39',0,'YLA 544 ZV 750@ 640+15k\r\nJMT 271 ZH 1200@640\r\nYLA 719 XU 750 @640 +15k\r\nGME 490 XU 700@640+10K\r\nALK 833 XA 650 @640\r\nKZR 500 XA 500@640\r\nBAU 285 YP 5000\r\nYLA 558 ZV 1100@640 +15K\r\nRBC 347 YL 900 @640\r\nGWA 938 YL 1200 @640\r\nBWR 671 XE 1000@640\r\nYLA 559 ZV 900 @640+15K\r\nYLA 50 XM 700@64015K\r\nJJN 110 ZY 800@640+30K\r\nJMT 49 ZY 900@640+15K\r\nJMT 42 XF 750@640 +15K \r\nPTN 424 XA 1300@640+12K\r\nJMT 450 YR 750@640\r\nALK 221 XA 750@640\r\nBAU 382 XR  50000\r\nBAU 603 ZE 700@640 \r\nBAU 782 XE 650 @ 640\r\nYLA 783 XA 750 @ 640+15K\r\nALK 828 XA  5000\r\nAGO TO GEN 100 @ 64116.8\r\n\r\n','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(276,'21','237','2022-04-22',1,'','','2',31965.00,'33','','','','','',0.00,'2022-06-02 12:43:37',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(277,'21','237','2022-04-22',1,'','','5',2855349.12,'33','','','15','AYM SHAFA WARRI SAPELE ROAD','57&58',0.00,'2022-06-02 12:44:59',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(278,'21','237','2022-04-22',1,'','','5',15187180.00,'33','','','14','AYM SHAFA WARRI SAPELE ROAD','0000',0.00,'2022-06-02 12:45:49',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(279,'21','237','2022-04-22',1,'','','5',1008730.00,'33','','','24','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-02 12:48:38',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(280,'21','237','2022-04-23',1,'','','2',15085680.00,'34','','','','','',41991489.85,'2022-06-02 16:25:42',0,'JMT 02 YA 750 @640+15K\r\nJMT 141 XC 1300 @ 640 +15K\r\nFUR 202 XA 750 ,@640 +15K\r\nBAU 898 ZE 200@640\r\nBAU 686 ZE 100@640\r\nDBM 221 XA 100@640\r\nBAU 682 ZE 100@ 640\r\nBAU 897 ZE 100@640 \r\nBAU 893 ZE 100@ 640\r\nJMT 385 ZY 550640+15K\r\nBAU 693 ZE 200@640\r\nALK736 XA 200@640\r\nBAU 654 ZE 100@640\r\nJMT 882 ZY 750 @640 +15K\r\nYLA 83 XU 1300@640+15K\r\nJMT 222 ZH 1400@640+15K\r\nBAU 923 YP 100@640\r\nBAU 661 ZE  100@640\r\nBAU 675 ZE  100@640\r\nHNG 83 XA  1250@640\r\nHNG 82 XA 1150@640\r\nBAU 900 ZE 200@640\r\nT000 70 JG 650@ 640\r\nBAU 657 ZE 100@640\r\nALK 735 XA 100@640\r\nMUB 593 XA 650@640+15K\r\nJMT 907 ZH 850 @640 +15K\r\nJMT 949 ZH 700 @640 \r\nALK 785 XA  100@640\r\nBAU 225 XR  600@640\r\nJMT 53 YR    700@640 + 10K\r\nJMT 284 ZY  1100 @640 +10K\r\nBAU 895 ZE 100@640\r\nSBG 868 XA  1200 @ 640\r\nJMT 196 ZY 850 @640+15K \r\nSHM 380 XA 1200 @640+10K\r\nYLA 962 ZV 700@640+10K\r\nBAU 982 XR  200@640+10K\r\nBAU 287 XR  200@640\r\nDKA 808 ZP 750@640\r\nJMT 145 ZY 550@640+15K\r\nALK 841 XA  100@640\r\nBAU 317 YP 150@640\r\nAGO TO GEN 7680\r\n','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(281,'21','237','2022-04-23',1,'','','2',8865.00,'34','','','','','',0.00,'2022-06-02 16:27:20',0,'Escort 1500\r\nWater 2400\r\nMopper 1500\r\nPresident 3300\r\nPms RTT 165','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(282,'21','237','2022-04-23',1,'','','5',6731969.25,'34','','','15','AYM SHAFA WARRI SAPELE ROAD','57&58',0.00,'2022-06-02 16:28:48',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(283,'21','237','2022-04-23',1,'','','5',10761600.00,'34','','','13','AYM SHAFA WARRI SAPELE ROAD','0000',0.00,'2022-06-02 16:29:49',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(284,'21','237','2022-04-23',1,'','','5',1035730.00,'34','','','24','AYM SHAFA WARRI SAPELE ROAD','0000',0.00,'2022-06-02 16:30:48',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(285,'21','237','2022-04-24',1,'','','2',5199000.00,'35','','','','','',31274203.05,'2022-06-02 21:58:53',0,'DBM 197 XA 750@640\r\nALK 316 XA 1050 @640\r\nBAU 969 XR 4000\r\nBAU 353 ZE 650@640\r\nJMT 23 XC 800@640+10K\r\nBUU 370 ZL 650@640\r\nRBC 346 YL 1200 @640\r\nJJN 872 XB 650@640\r\nTRR 905 XA 650 @640\r\nKHL 575 XA 160000\r\nBAU 391 ZE 15000\r\nALK 965 XA 5000\r\nBAU 493 XR 100@640\r\nJMT 04 YA 300@640\r\nJMT 116 XC 950 640+15K\r\nBAU 285 YP 5000\r\nAGO TO GENERATOR 25000','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(286,'21','237','2022-04-24',1,'STATION EXPENSES','','2',39700.00,'35','','','','','',0.00,'2022-06-02 22:01:14',0,'Gate weldering 13400\r\nMass to cp 12300\r\nStaff feeding 14000','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(287,'21','237','2022-04-24',1,'','','5',12682490.00,'35','','','13','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-02 22:04:03',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(288,'21','237','2022-04-24',1,'','','5',5365060.00,'35','','','24','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-02 22:05:21',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(289,'21','237','2022-04-24',1,'','','5',4704607.00,'35','','','15','AYM SHAFA WARRI SAPELE ROAD','57&58',0.00,'2022-06-02 22:06:21',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(290,'21','237','2022-04-25',1,'','','2',5999500.00,'36','','','','','',30392553.95,'2022-06-02 23:04:19',0,'MKA 717 ZF 700@640\r\nJMT 711 ZH 300@ 640\r\nJMT 299 ZH 700 @640+10K\r\nYLA 171 XU 1300@640 +15K \r\nJMT 550 YR 9500@ 640 15K\r\nAAA 758 XE 650 @640 + 10K\r\nJHN 575 XA 100 @640\r\nBAU 204 XR 5000\r\nJMT 99 XE 650 @640+ 15k\r\nBAU 196 YP 750 @640\r\nJMT 940 ZH 800 @ 640 \r\nYLA 180 ZV 600@640\r\nMUB 709 YH 950 @ 640\r\nT000 709 JG 500 @640\r\nAGO TO GENERATOR 186500\r\n','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(291,'21','237','2022-04-25',1,'STATION EXPENSES','','2',50400.00,'36','','','','','',0.00,'2022-06-02 23:06:03',0,'Depot 11400\r\nSalary 36000\r\nEscort 1500\r\nTransport 1500','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(292,'21','237','2022-04-25',1,'','','5',10198250.00,'36','','','13','AYM SHAFA WARRI SAPELE ROAD','0000',0.00,'2022-06-02 23:07:00',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(293,'21','237','2022-04-25',1,'','','5',4157797.25,'36','','','15','AYM SHAFA WARRI SAPELE ROAD','57&58',0.00,'2022-06-02 23:08:09',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(294,'21','237','2022-04-25',1,'','','5',2958335.00,'36','','','24','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-02 23:09:10',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(295,'21','237','2022-04-26',1,'','','2',8104000.00,'38','','','','','',44042233.70,'2022-06-05 09:17:37',0,'FUR 200 XA 700@640+10K\r\nALK 733 XA 200@640\r\nJMT 220 ZH 750@640+15K\r\nJMT 218 YR 750 @640+15K\r\nJJJ 20 XS  800@ 640 +15K\r\nBAU 659 ZE 100@640\r\nBAU 655 ZE 100@640\r\nYLA 986 ZV 750@640 +15K\r\nBAU 585 ZE 100@640\r\nBAU 693 ZE  72000\r\nBAU 189 ZE 100@ 640\r\nJMT 52 YR  1350@640\r\nJMT 864 ZH 600@640+10K\r\nJMT 307 ZY  600@640+10K\r\nBAU 656 ZE  200@640\r\nYLA 45 ZV  850@640\r\nJMT 191 XC 1300 @640+15K\r\nBAU 490 ZE  750 @640 \r\nALK 834 XA  4000\r\nALK 317 XA 750@640\r\nALK 738 XA 100@640\r\nBAU 678 ZE 100@640\r\nJMT 108 ZY  1300@640\r\nAGO TO GENERATOR 48000\r\n','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(296,'21','237','2022-04-26',1,'STATION EXPENSES','','2',96600.00,'38','','','','','',0.00,'2022-06-05 09:27:19',0,'Toilet 10000\r\nPipes 15200\r\nEscort 1500\r\nPms  6900\r\nSalary 25000\r\nBucket 8000\r\nOvie local govt 30000','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(297,'21','237','2022-04-26',1,'','','5',17678620.00,'38','','','13','AYM SHAFA WARRI SAPELE ROAD','0000',0.00,'2022-06-05 09:28:45',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(298,'21','237','2022-04-26',1,'','','5',769110.00,'38','','','24','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-05 09:30:16',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(299,'21','237','2022-04-26',1,'','','5',6403616.00,'38','','','15','AYM SHAFA WARRI SAPELE ROAD','57&58',0.00,'2022-06-05 09:32:17',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(300,'21','237','2022-04-27',1,'','','2',8734000.00,'39','','','','','',29113854.40,'2022-06-06 08:15:32',0,'DBM 217 XA 200@640\r\nDBM 197 XA 200@640\r\nBAU 29 ZE 200@640\r\nBAU 310 ZE 200@640\r\nBAU 986 XR 200@640\r\nBAU 399 ZE 200@640\r\nALK 834 XA 200@640\r\nALK 828 XA 200@ 640\r\nBAU 491 YP 200 @640\r\nABC 208 XB 500@640\r\nALK 965 XA 200@640\r\nABC 207 XB 450 @640\r\nBAU 293 ZE 200@640\r\nBAU 838 ZE 200@640\r\nJMT 45 YR 850@640+10K\r\nALK 965 XA  5000\r\nBAU 969 XR  5000\r\nJJN 265 XB  800@640\r\nBAU 662 ZE 100@640\r\nYLA 432 XU 1250@640+15K\r\nMUB 280 XA 1400@640+15K\r\nBAU 312 ZE 650@640\r\nYLA 567 XU 750@640+15k \r\nJMT 25 ZY 1350@640\r\nJMT 990 YR 850 @640 +15K\r\nBAU 479 XR  200@640\r\nALK 838 XA  200@640+15K\r\nKAL 217 XA 1300@640+15K\r\nBAU 207 XR. 80000\r\nAGO TO GENERATOR 74000','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(301,'21','237','2022-04-27',1,'','','2',42000.00,'39','','','','','',0.00,'2022-06-06 08:17:40',0,'Mopper and bucket 4000\r\nYellow and saidu.    38000','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(302,'21','237','2022-04-27',1,'','','5',4505770.00,'39','','','13','AYM SHAFA WARRI SAPELE ROAD','0000',0.00,'2022-06-06 08:19:20',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(303,'21','237','2022-04-27',1,'','','5',1082390.00,'39','','','24','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-06 08:20:41',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(304,'21','237','2022-04-27',1,'','','5',1315260.00,'39','','','15','AYM SHAFA WARRI SAPELE ROAD','57&58',0.00,'2022-06-06 08:21:56',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(305,'21','237','2022-04-28',1,'','','2',143000.00,'40','','','','','',6713531.55,'2022-06-06 09:13:19',0,'JMT 873 ZH 15000\r\nDBM 213 XA 200@640','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(306,'21','237','2022-04-28',1,'STATION EXPENSES','','2',167565.00,'40','','','','','',6713531.55,'2022-06-06 09:17:42',0,'Steel paint ( Engr shefiu ) 10000\r\nDrainage steel (Engr shefiu) 70000\r\nDrainage evacuation (Engr shefiu) 25000\r\nWater  2400\r\nWeight and measurements 20000\r\nPms 165\r\nSalary 50000','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(307,'21','237','2022-04-28',1,'','','5',2934000.00,'40','','','13','AYM SHAFA WARRI SAPELE ROAD','0000',0.00,'2022-06-06 09:19:49',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(308,'21','237','2022-04-28',1,'','','5',3099951.25,'40','','','15','AYM SHAFA WARRI SAPELE ROAD','58',0.00,'2022-06-06 09:20:56',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(309,'21','237','2022-04-28',1,'','','5',216800.00,'40','','','24','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-06 09:22:41',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(310,'21','237','2022-04-29',1,'Authority expenses','','2',8640500.00,'41','','','','','',25415685.40,'2022-06-07 15:23:14',0,'RBC 345 YL 1300@650\r\nJMT 24 XE  1250@650 +15K\r\nMUB 435 YH 1300 @650 +15K\r\nJMT 145 ZY 1400@650 +15K\r\nJMT 03 XE  900@650\r\nBAU 204 XR 500@650 + 15K\r\nJMT 88 ZY 1300@650+ 15K\r\nJMT 873 ZH 1200@650\r\nBAU 59 ZY 700@650\r\nYLA 962 ZV 1200@650 +10K\r\nMUB 789 XA 600@650+15K\r\nBAU 249 XR 500@650\r\nBAU 312 XR 50 @650 +5K\r\nALK 706 XA 100@640\r\nBAU 285 YP 5000\r\nBLG 120 XA 1300 @650 +15K\r\nBAU 322 XR 18000\r\nBAU 490 XR 100@650\r\nBAU 711 YP 100@ 640\r\nAGO TO GENERATOR 152000\r\n','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(311,'21','237','2022-04-29',1,'STATION EXPENSES','','2',50000.00,'41','','','','','',0.00,'2022-06-07 15:25:03',0,'Jibrin 30000\r\nPms 330\r\nCLO SALARY 20000','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(312,'21','237','2022-04-29',1,'','','5',5955350.00,'41','','','13','AYM SHAFA WARRI SAPELE ROAD','00009988',0.00,'2022-06-07 15:27:18',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(313,'21','237','2022-04-29',1,'','','5',3703354.25,'41','','','15','AYM SHAFA WARRI SAPELE ROAD','58',0.00,'2022-06-07 15:28:30',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(314,'21','237','2022-04-29',1,'','','5',100815.00,'41','','','24','AYM SHAFA WARRI SAPELE ROAD','00009988',25415685.40,'2022-06-07 15:29:18',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(315,'21','237','2022-04-30',1,'','','2',12025500.00,'43','','','','','',45108414.40,'2022-06-08 09:34:12',0,'DGR 75 XK 500@650\r\nJJN 416 XB 750@650\r\nJMT 03 YA 500@650+15K\r\nALK 835 XA 100@ 650\r\nYLA 783 XA 900 @650+ 15K\r\nJMT 116 XC 700 @650+15K\r\nJJN 110 YZ 800 @650\r\nJMT 02 YA 1150 @650+15K\r\nYLA 559 ZV 1200 @650+15K\r\nDBM 220 XA 750@ 650\r\nJMT 196 ZY 1000@650+15K\r\nRBC 346 YL 700@650\r\nHJA 375 XA 500@650\r\nBAU 625 YP  750@650+10K\r\nJMT 42 XF 1200@650+15K\r\nYLA 544 ZV 650@650+15K\r\nYLA 719 XU 750 @650+15K\r\nMUB 709 YH 1300@650 +15K\r\nJMT 222 ZH 850 @650+15K\r\nJMT 385 YM 450 @650+15K\r\nJMT 43 YM 450@650 +15K\r\nSRP 466 XA 750@650+15K\r\nRBC 347 YL 700@650\r\nALK 862 XA 590@650\r\nGAN 08 XA 850@650+15K','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(316,'21','237','2022-04-30',1,'STATION EXPENSES','','2',927219.40,'43','','','','','',0.00,'2022-06-08 09:37:00',0,'Deport 1000 @ 650  650000\r\nDeport(RSH 118 FM)  10000\r\nESCORT  1500\r\nOVIE 3300\r\nSALARY 250136\r\nRTT 4283.4\r\nSTATION 8000','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(317,'21','237','2022-04-30',1,'','','5',11087550.00,'43','','','13','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-08 09:39:02',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(318,'21','237','2022-04-30',1,'','','5',3063547.50,'43','','','15','AYM SHAFA WARRI SAPELE ROAD','58',0.00,'2022-06-08 09:40:07',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(319,'21','237','2022-04-30',1,'','','5',146915.00,'43','','','24','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-08 09:40:52',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(320,'21','237','2022-05-01',1,'','','2',2792500.00,'44','','','','','',18956905.50,'2022-06-08 12:51:40',0,'ALK 742 XA 5000\r\nKWL 526 XA 800@650\r\nBAU 971 XR 100@650\r\nJJJ 20 ZX 500@650\r\nHNG 28 XA  900@650\r\nJMT 23 XC 1300 @650+15K\r\nGME 490 XA 650 @650 +10K','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(321,'21','237','2022-05-01',1,'','','2',153490.00,'44','','','','','',0.00,'2022-06-08 12:52:57',0,'Ramadan feeding 20000\r\nSalary 133490','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(322,'21','237','2022-05-01',1,'','','5',3619121.00,'44','','','15','AYM SHAFA WARRI SAPELE ROAD','58',0.00,'2022-06-08 12:54:06',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(323,'21','237','2022-05-01',1,'','','5',6675000.00,'44','','','13','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-08 12:55:01',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(324,'21','237','2022-05-01',1,'','','5',1307210.00,'44','','','24','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-08 12:57:04',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(325,'21','237','2022-05-02',1,'','','2',383500.00,'45','','','','','',18204851.55,'2022-06-08 15:17:33',0,'BAU 201 XR 250000\r\nLSD 340 XL 102500\r\nTRR 540 YX 5000\r\nAGO TO GEN. 26000','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(326,'21','237','2022-05-02',1,'','','5',5939302.00,'45','','','13','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-08 15:19:12',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(327,'21','237','2022-05-02',1,'','','5',5939302.00,'45','','','13','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-08 15:20:25',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(328,'21','237','2022-05-02',1,'','','5',3192629.00,'45','','','15','AYM SHAFA WARRI SAPELE ROAD','58',0.00,'2022-06-08 15:22:03',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(329,'21','237','2022-05-02',1,'','','5',3119320.00,'45','','','24','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-08 15:23:12',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(330,'21','237','2022-05-02',1,'','','2',173190.00,'45','','','','','',0.00,'2022-06-08 15:24:12',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(331,'21','237','2022-05-03',1,'','','2',1510000.00,'46','','','','','',11981347.40,'2022-06-08 18:18:46',0,'JMT 550 YR  800@650\r\nYLA 986 ZV 700@650\r\nJMT 38 YQ 750@650+15K','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(332,'21','237','2022-05-03',1,'','','5',1498200.00,'46','','','13','AYM SHAFA WARRI SAPELE ROAD','00009988',0.00,'2022-06-08 18:23:53',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(333,'21','237','2022-05-03',1,'','','5',2151365.00,'46','','','15','AYM SHAFA WARRI SAPELE ROAD','58',0.00,'2022-06-08 18:25:17',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(334,'21','237','2022-05-03',1,'','','5',361065.00,'46','','','24','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-08 18:27:32',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(335,'21','237','2022-05-03',1,'STATION EXPENSES','','2',50300.00,'46','','','','','',0.00,'2022-06-08 18:29:45',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(336,'21','237','2022-05-04',1,'','','2',5407500.00,'47','','','','','',17565194.20,'2022-06-08 20:45:07',0,'FUR 202 XA 900@650+15K\r\nYLA 555 ZY 650@650 +15K\r\nJMT 990 YR 800@650\r\nJMT 99 XE 750.  @650 + 15K\r\nJMT 284 ZY  700@650\r\nJMT 299 ZH 1100@650+10K\r\nYLA 567 XU  700@650\r\nYLA 961 ZV 650 @650+ 10K\r\nJMT  864 ZH 700@650+15K\r\nFUR 200 XA  1100@650 10K\r\nBAU 499 XR  5000\r\nBAU 296 ZE 5000\r\nAGO TO. GENERATOR 65000','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(337,'21','237','2022-05-04',1,'STATION EXPENSES','','2',103020.00,'47','','','','','',0.00,'2022-06-08 20:47:53',0,'Escort 3000\r\nEngr shefiu 35000\r\nPms 530\r\nTransport to bank 1500\r\nSalary 62990','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(338,'21','237','2022-05-04',1,'','','5',999500.00,'47','','','13','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-08 20:48:47',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(339,'21','237','2022-05-04',1,'','','5',1361328.45,'47','','','15','AYM SHAFA WARRI SAPELE ROAD','58',0.00,'2022-06-08 20:51:12',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(340,'21','237','2022-05-04',1,'','','5',820.00,'47','','','24','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-08 20:52:04',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(341,'21','237','2022-05-05',1,'Authority expenses','','2',3486150.00,'48','','','','','',32120226.15,'2022-06-10 07:06:25',0,'JMT 218 YR 750@650+ 15K\r\nBAU 698 ZE 550@650\r\nBAU 698 ZE 100@650\r\nLSD 340 XL 700@650\r\nMUB 529 XA 650@650+15K\r\nJJN 498 XB 650@650+15K\r\nJMA 22 XA 571@650\r\nYLA 50 XM 1300@650+15K','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(342,'21','237','2022-05-05',1,'STATION EXPENSES','','2',15950.00,'48','','','','','',0.00,'2022-06-10 07:08:01',0,'RTT 60.30@165 9950\r\nBook and correction pen 5000\r\nPacker 1000','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(343,'21','237','2022-05-05',1,'','','5',6178084.00,'48','','','13','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-10 07:09:02',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(344,'21','237','2022-05-05',1,'','','5',5106972.00,'48','','','15','AYM SHAFA WARRI SAPELE ROAD','58',0.00,'2022-06-10 07:10:05',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(345,'21','237','2022-05-05',1,'','','5',1813445.00,'48','','','24','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-10 07:11:05',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(346,'21','237','2022-05-06',1,'','','2',3409506.00,'49','','','','','',32264961.70,'2022-06-11 08:05:56',0,'JMT 385 XY  800@650\r\nKTG 151 XC 1150@650+7500\r\nJJN 265 XB 800@650\r\nJMT 865 ZH 650@650+32K\r\nJMT 116 XC 800@650\r\nJMT 43 YM 800@650\r\nBAU 968 XR 100@650\r\nAGO TO GENERATOR 55000','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(347,'21','237','2022-05-06',1,'','','2',34970.00,'49','','','','','',0.00,'2022-06-11 08:07:14',0,'Plumbing 16970\r\nEscort 1500\r\nPms 6500\r\nWaste 10000','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(348,'21','237','2022-05-06',1,'','','5',10518650.00,'49','','','8','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-11 08:09:24',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(349,'21','237','2022-05-06',1,'','','5',10518650.00,'49','','','8','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-11 08:09:25',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(350,'21','237','2022-05-06',1,'','','5',10518650.00,'49','','','13','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-11 08:11:14',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(351,'21','237','2022-05-06',1,'','','5',10518650.00,'49','','','13','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-11 08:11:15',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(352,'21','237','2022-05-06',1,'','','5',2648122.25,'49','','','15','AYM SHAFA WARRI SAPELE ROAD','58',0.00,'2022-06-11 08:12:18',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(353,'21','237','2022-05-06',1,'','','5',6611720.00,'49','','','24','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-11 08:13:31',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(354,'21','237','2022-05-07',1,'','','2',3617000.00,'50','','','','','',26480519.30,'2022-06-11 09:54:11',0,'BAU 391 ZE 19000\r\nJMT 446 YR 1100@650\r\nBAU 444 ZE 400@650\r\nRBC 346 YL 700@650\r\nYLA 544 ZY 750@650+15K\r\nALK 836 XA 650@650\r\nBAU 307 ZE 86000\r\nBWR 671 XE  1000@650\r\nJMT 220 ZH 750+15K','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(355,'21','237','2022-05-07',1,'STATION EXPENSES','','2',12400.00,'50','','','','','',0.00,'2022-06-11 09:55:35',0,'Water 2400\r\nPOS paper 10000','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(356,'21','237','2022-05-07',1,'','','5',5602150.00,'50','','','13','AYM SHAFA WARRI SAPELE ROAD','0000',0.00,'2022-06-11 09:56:40',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(357,'21','237','2022-05-07',1,'','','5',3629405.00,'50','','','24','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-11 09:57:39',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(358,'21','237','2022-05-07',1,'','','5',3639865.25,'50','','','15','AYM SHAFA WARRI SAPELE ROAD','58',0.00,'2022-06-11 09:59:11',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(359,'21','237','2022-05-07',1,'','','5',20000.00,'50','','','18','AYM SHAFA WARRI SAPELE ROAD','25',0.00,'2022-06-11 10:00:05',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(360,'21','237','2022-05-08',1,'Authority expenses','','2',2555500.00,'51','','','','','',29966211.80,'2022-06-11 10:53:11',0,'BAU 623 YP 700@650\r\nALK 833 XA  650@650\r\nBAU 234 ZY  800@650\r\nBAU 486 XR 850@650\r\nBAU 450 ZE 750@650\r\nBAU 216 XR  23000\r\nGWA 938 YL 70000\r\nBAU 751 ZE  5000','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(361,'21','237','2022-05-08',1,'','','5',18369120.00,'51','','','13','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-11 10:54:17',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(362,'21','237','2022-05-08',1,'','','5',3484369.50,'51','','','15','AYM SHAFA WARRI SAPELE ROAD','58',0.00,'2022-06-11 10:55:28',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(363,'21','237','2022-05-08',1,'','','5',901490.00,'51','','','24','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-11 10:56:23',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(364,'21','237','2022-05-08',1,'','','2',52000.00,'51','','','','','',0.00,'2022-06-11 10:58:07',0,'Youth leader 3300\r\nPlumber 42000\r\nPms 6700','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(365,'21','237','2022-05-09',1,'','','2',2197500.00,'52','','','','','',26488122.25,'2022-06-11 12:05:41',0,'JMT 660 YR  1250@650+10K\r\nGWA 938 YL 600@650\r\nJAN 575 XA  800@650\r\nBAU 196 YP 700@650\r\nAGO TO GENERATOR. 10000','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(366,'21','237','2022-05-09',1,'STATION EXPENSES','','2',5800.00,'52','','','','','',0.00,'2022-06-11 12:07:21',0,'Escort 1500\r\nCement 4300','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(367,'21','237','2022-05-09',1,'','','5',12618461.00,'52','','','13','AYM SHAFA WARRI SAPELE ROAD','58',0.00,'2022-06-11 12:08:46',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(368,'21','237','2022-05-09',1,'','','5',500000.00,'52','','','15','AYM SHAFA WARRI SAPELE ROAD','58',0.00,'2022-06-11 12:12:19',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(369,'21','237','2022-05-09',1,'','','5',5173960.00,'52','','','24','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-11 12:14:19',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(370,'21','237','2022-05-10',1,'Authority expenses','','2',13037000.00,'53','','','','','',47420026.80,'2022-06-12 07:25:59',0,'YLA 719 XU 750@650+15K\r\nJMT 949 ZH 750@650+15K\r\nKWL 758 ZY 750@650\r\nALK 826 650@650\r\nJMT 907 ZH 850@650+15K\r\nSRP 466 XA 750@650+15K\r\nBAU 625 YP 750@650+15K\r\nDBM 221 XA 550@650\r\nYLA 969 XA 800@650\r\nATN 815 YV 700@10K\r\nTSE 54 XA 350@650\r\nBAU 563 ZE 600@650\r\nBAU 201 XR 70000\r\nAPP 444 XL 700@650+10K \r\nDKA 515 ZP 100@650\r\nBAU 212 XR 18000\r\nBAU 981 XR 5000\r\nGAN 08 XA 750@650+15K\r\nMUB 709 YH 850@650+15K\r\nTKP 589 XA 750@650\r\nJMT 192 XC 850@650+15K\r\nBAU 201 XR 520000\r\nJMT 307 ZY 650@650 +15K\r\nJMT 42 YM 350@650+15K\r\nBAU 274 XR 650@650\r\nYLA 479XU 700@650+15K\r\nT00071 JG 500@650\r\nJMT 271 ZH 700@650\r\nGME 921 YX  700@650\r\nBUU 370 ZL 600@650\r\nJMT 196 ZY 850@650+15K\r\nDKA 189 ZY 700@650\r\nAGO TO GENERATOR 92000','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(371,'21','237','2022-05-10',1,'STATION EXPENSES','','2',18160.00,'53','','','','','',0.00,'2022-06-12 07:28:33',0,'Depot 10500\r\nPms 2660\r\nPump repair 5000','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(372,'21','237','2022-05-10',1,'','','5',17422320.00,'53','','','13','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-12 07:29:21',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(373,'21','237','2022-05-10',1,'','','5',2323290.00,'53','','','15','AYM SHAFA WARRI SAPELE ROAD','56',0.00,'2022-06-12 07:32:14',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(374,'21','237','2022-05-10',1,'','','5',360000.00,'53','','','18','AYM SHAFA WARRI SAPELE ROAD','25',0.00,'2022-06-12 07:33:15',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(375,'21','237','2022-05-10',1,'','','5',4182020.00,'53','','','24','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-12 07:34:11',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(376,'21','237','2022-05-11',1,'Authority expenses','','2',7709670.00,'54','','','','','',35804997.20,'2022-06-12 09:07:28',0,'DKA 130 XG 950@650\r\nBAU 624 YP 750@650\r\nBAU 204 XR 5000\r\nJMT 191 XC 900@650+15K\r\nJJN 498XB 700@650\r\nYLA 180 ZV 1050@650+15K\r\nGME 48 XC 1300@650+15K\r\nJMT 145 ZY 800@650\r\nYLA 559 ZV 750650+15K\r\nJMT 940 400@650\r\nJMT 99 XE 1300@650+15K\r\nBAU 204 XR  50000\r\nJJN 24 XE 800@650\r\nBAU 261 XR 600@650\r\nJMT 36 YP  400@650\r\nAGO TO GENERATOR 19670\r\n','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(377,'21','237','2022-05-11',1,'STATION EXPENSES','','2',3500.00,'54','','','','','',0.00,'2022-06-12 09:08:41',0,'Transport to bank  1500\r\nRubber band 2000','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(378,'21','237','2022-05-11',1,'','','5',10394993.00,'54','','','13','AYM SHAFA WARRI SAPELE ROAD','0000',0.00,'2022-06-12 09:09:32',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(379,'21','237','2022-05-11',1,'','','5',2717636.00,'54','','','15','AYM SHAFA WARRI SAPELE ROAD','56',0.00,'2022-06-12 09:10:37',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(380,'21','237','2022-05-11',1,'','','5',583460.00,'54','','','18','AYM SHAFA WARRI SAPELE ROAD','0000',0.00,'2022-06-12 09:11:59',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(381,'21','237','2022-05-11',1,'','','5',955520.00,'54','','','24','AYM SHAFA WARRI SAPELE ROAD','0000',0.00,'2022-06-12 09:13:24',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(382,'21','237','2022-05-12',1,'','','2',12596750.00,'55','','','','','',43228278.40,'2022-06-12 10:38:10',0,'JJN 20 XS 300@650\r\nKAL 217 XA 1300@650+15K\r\nALK 737 XA 100@650\r\nRBC 370 ZN 950@650\r\nBAU 683 ZE 750@650+10K\r\nBAU 287 XR 100@650\r\nJMT 42 XF 1150@650+15K\r\nGME 745 YX 1350@650+15K\r\nJMT 03 YA  750@650\r\nBAU 891 ZE 100@650\r\nBAU 687 ZE 100@650\r\nBAU 660 ZE 100@650\r\nBAU 675 ZE 100@650\r\nALK 826 XA 5000\r\nBAU 587 ZE 100@650\r\nYLA 962 ZV 1300@650+10K\r\nFUR 198 XA 1150@650+10K\r\nALK 837 XA 200@650\r\nALK 734 XA 750@650+10K\r\nYLA 558 ZV 650@650+15K\r\nJJJ 20 XS 12000\r\nGME 490 XM 1300@@650+15K\r\nJMT 53 YR 1400@650+15K\r\nYLA 555 ZY 850@650+15K\r\nPTN 424 XA 1000@650+15K\r\nYLA 580 XM 1385@@650+10K\r\nRBC 345 YL 750@650+15K\r\nMUB 65 XA 750@650+15K\r\nBDG 112 XX 200@650\r\n','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(383,'21','237','2022-05-12',1,'STATION EXPENSES','','2',4000.00,'55','','','','','',0.00,'2022-06-12 10:41:49',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(384,'21','237','2022-05-12',1,'','','5',14331800.00,'55','','','13','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-12 10:45:25',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(385,'21','237','2022-05-12',1,'','','5',228555.00,'55','','','24','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-12 10:52:21',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(386,'21','237','2022-05-12',1,'','','5',2021510.00,'55','','','15','AYM SHAFA WARRI SAPELE ROAD','56',0.00,'2022-06-12 10:53:42',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(387,'21','237','2022-05-12',1,'','','5',629318.12,'55','','','9','AYM SHAFA WARRI SAPELE ROAD','20',0.00,'2022-06-12 10:54:33',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(388,'21','237','2022-05-12',1,'','','5',2163180.71,'55','','','18','AYM SHAFA WARRI SAPELE ROAD','25&27',0.00,'2022-06-12 10:57:01',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(389,'21','237','2022-05-13',1,'Authority expenses','','2',6678500.00,'57','','','','','',31946072.30,'2022-06-18 17:29:58',0,'YLA 961 ZV 1100@650+10K\r\nDNG 643 XA 700@650\r\nJMT 864 ZH 1100@650+15K\r\nT000 70 JG 600@650\r\nRBC 347 YL 1300@650\r\nJMT 516 YR 1200@650\r\nBWR 671 XE 750@650\r\nJMT 254 ZY 1200@650+ 10K\r\nJMT 03 XE 900@650\r\nFUR 200XA 1200@650+10K\r\nAGO TO GEN 169.23@650','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(390,'21','237','2022-05-13',1,'STATION EXPENSES','','2',3900.00,'57','','','','','',0.00,'2022-06-18 17:41:59',0,'Water 2400\r\nEscort 1500','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(391,'21','237','2022-05-13',1,'','','5',7980200.00,'57','','','13','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-18 17:43:19',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(392,'21','237','2022-05-13',1,'','','5',3234846.25,'57','','','15','AYM SHAFA WARRI SAPELE ROAD','56',0.00,'2022-06-18 17:45:24',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(393,'21','237','2022-05-13',1,'','','5',3069366.55,'57','','','18','AYM SHAFA WARRI SAPELE ROAD','25&27',0.00,'2022-06-18 17:47:24',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(394,'21','237','2022-05-13',1,'','','5',1875900.00,'57','','','24','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-18 17:48:27',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(395,'21','237','2022-05-15',1,'Authority expenses','','2',13332260.00,'58','','','','','',45468575.10,'2022-06-18 20:39:43',0,'BAU 658 ZE 750@690+10K\r\nJMT 38 YQ 1300@690+15K\r\nJMT 711 ZH 504@690+15K\r\nMUB 435 YH 750@690+15K\r\nBAU 986 XR 150@690+5k\r\nBAU 204 XR 25000\r\nBAU 59 ZY 700 @690\r\nAPP 444 XL 1100@690+ 10K\r\nBAU 782 ZE 5000\r\nKWL 525 XA 600@690 \r\nYLA 231 XA 1200@690+10K\r\nYLA 544 ZV 750@690+15K\r\nJMT 220 ZH 750@690+15K\r\nALK 836 XA 650@690\r\nJMT 49 ZY 750@690+ 15K\r\nYLA 152 XA 700@690\r\nBAU 397 ZE 5000\r\nALK. 826 XA 5000\r\nYLA 969 XA 800@690\r\nJMT 37 YQ 750@690+15K\r\nGME 921 YX 700@690+10K\r\nJMT 873 ZH 750 @690+15K\r\nKWL 526 XA 1250@690\r\nHNG 82 XA 1250@690\r\nRBC 346 YL 750@690','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(396,'21','237','2022-05-15',1,'STATION EXPENSES','','2',59700.00,'58','','','','','',0.00,'2022-06-18 20:41:25',0,'Escort 1500\r\nPresident 3300\r\nEngr shefiu 30000\r\nFire extinguisher 19900\r\nDeport 5000','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(397,'21','237','2022-05-15',1,'','','5',11380260.00,'58','','','13','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-18 20:42:11',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(398,'21','237','2022-05-15',1,'','','5',3856140.00,'58','','','9','AYM SHAFA WARRI SAPELE ROAD','20&21',0.00,'2022-06-18 20:44:03',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(399,'21','237','2022-05-15',1,'','','5',8105631.00,'58','','','15','AYM SHAFA WARRI SAPELE ROAD','56',0.00,'2022-06-18 20:44:58',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(400,'21','237','2022-05-15',1,'','','5',2447080.00,'58','','','24','AYM SHAFA WARRI SAPELE ROAD','00009988',0.00,'2022-06-18 20:47:01',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(401,'21','237','2022-05-14',1,'','','2',6516000.00,'59','','','','','',28138810.95,'2022-06-18 21:47:29',0,'ALK 838 XA 2000\r\nBAU 896 ZE 300@650+15K\r\nMUB 529 XA 650@650+15K\r\nGWA 938 YL 750@690+20K\r\nBAU 420 YP 600@690\r\nJMT 108 ZY 700@690+10K\r\nKWL 553 YH 650@690\r\nKZR 509 XA 600@690\r\nJMT 299 ZH 1100 @690+10K\r\nYLA 444 ZY 950@690\r\nBBR 403 XA 600@690\r\nJMT 02 YA 1200@690+15K\r\nJMT 949 ZH 1200@690+15K\r\nAGO TO GENERATOR 7000','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(402,'21','237','2022-05-14',1,'','','2',227100.00,'59','','','','','',0.00,'2022-06-18 21:49:23',0,'Nepa bill 106 000\r\nPresident 3300\r\nGenerator service 48500\r\nRTT 59300\r\nAlhaji hamza 10000','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(403,'21','237','2022-05-14',1,'','','5',7497400.00,'59','','','13','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-18 21:50:47',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(404,'21','237','2022-05-14',1,'','','5',4239397.91,'59','','','24','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-18 21:51:44',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(405,'21','237','2022-05-14',1,'','','5',2644748.00,'59','','','15','AYM SHAFA WARRI SAPELE ROAD','56',0.00,'2022-06-18 21:52:44',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(406,'21','237','2022-05-14',1,'','','5',2146809.04,'59','','','9','AYM SHAFA WARRI SAPELE ROAD','20&21',0.00,'2022-06-18 21:54:25',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(407,'21','237','2022-06-16',1,'','','2',7155100.00,'62','','','','','',18820189.65,'2022-06-22 09:45:18',0,'BAU 314 YP 200@690\r\nALK 829 XA 200@690\r\nBAU 896 ZE 200@690\r\nBAU 324 XR 200@690\r\nALK 740 XA 200@680\r\nALK 741 XA 200@680\r\nDBM 219 XA 200@680\r\nBAU 653 ZE 200 @690\r\nBAU 447 ZE 200@680\r\nBAU 343 ZE 200@680\r\nJMT 307 ZY 600@680+10K\r\nBGR 73 XA 750@680\r\nBAU 588 ZE 200@680\r\nALK 785 XA 100@680\r\nBAU 216 XR 200@680\r\nBAU 307 ZE 200@680\r\nBAU 49 ZE 600@680\r\nBAU 260 XR 450@680\r\nJMT 88 ZY 650+ 15K\r\nBAU 986 XR 200@690\r\nBAU 897 ZE 200@680\r\nBAU 481XR 200@680\r\nBAU 66 YP 200@680\r\nBAU 401 ZE 200@690\r\nJJN 265 XB 800@680\r\nBAU 240 ZE 200@680\r\nBAU 325 XR 200@680\r\nHNG 83 XA 1250@680\r\nMKA 717 ZF 400@680\r\nBAU 314 XR   105200\r\nAGO TO GENERATOR 54,400','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(408,'21','237','2022-05-16',1,'STATION EXPENSES','','2',76000.00,'62','','','','','',0.00,'2022-06-22 09:47:29',0,'Uwie local government 40000\r\nDipping paste 13000\r\nStation exp pms 4800\r\nPms 92.12 @165  5200\r\nEscort 1500\r\nTransport 1500','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(409,'21','237','2022-05-16',1,'','','5',13102900.00,'62','','','13','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-22 09:48:30',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(410,'21','237','2022-05-16',1,'','','5',5892611.00,'62','','','15','AYM SHAFA WARRI SAPELE ROAD','58',0.00,'2022-06-22 09:51:49',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(411,'21','237','2022-05-16',1,'','','5',1763495.00,'62','','','24','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-22 09:52:46',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(412,'21','237','2022-05-17',1,'','','2',13125400.00,'65','','','','','',41921730.65,'2022-06-22 12:47:43',0,'YLA 986 ZV 1150@680+15K\r\nBAU 681 ZE 200@680\r\nATN 708 YV 700@680+10\r\nBAU 308 ZE 5000\r\nBAU 29 ZE 5000\r\nJRE 578 XA 1100@680\r\nRBC 345 YL 1300@680\r\nJMT 191 XC 900@680+15K\r\nBAU 625 YP 1250@680+15K\r\nBSA 911 XA 670@680\r\nYLA 171 XU 1200@680+15K\r\nJMT 218 YR 1200@680+15K\r\nJMT 26 ZY 800@680\r\nMUB 789 XA 600@680+15K\r\nYLA 847 XU 750@680+10K\r\nKTG 151 XC 750@680+15K\r\nKZR 505 XA 300@@680\r\nJMT 25 ZY 880@680\r\nBAU 657 ZE 100@680\r\nTOOO 36 JG 600@680\r\nBAU 330 XA 200@680\r\nBAU 188 ZE 200@680\r\nYLA 479 XU 1300@680\r\nYLA 719 XU 1150@680\r\nBWR 671 XE 750@680\r\nJMT 45 YR 1000@680\r\nAGO TO GENERATOR 40800\r\n','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(413,'21','237','2022-05-17',1,'Authority expenses','','2',25450.00,'65','','','','','',0.00,'2022-06-22 12:49:56',0,'Deport (PF 5213 SPY) 5750\r\nSALARY TO BALA 18000\r\nPMS 2000\r\nESCORT 1500\r\n','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(414,'21','237','2022-05-17',1,'','','5',12550400.00,'65','','','13','AYM SHAFA WARRI SAPELE ROAD','0000',0.00,'2022-06-22 12:50:54',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(415,'21','237','2022-05-17',1,'','','5',3368674.85,'65','','','24','AYM SHAFA WARRI SAPELE ROAD','00009988',0.00,'2022-06-22 12:52:14',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(416,'21','237','2022-05-17',1,'','','5',6723355.00,'65','','','15','AYM SHAFA WARRI SAPELE ROAD','56',0.00,'2022-06-22 12:53:18',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(417,'21','237','2022-05-17',1,'','','5',831462.00,'65','','','18','AYM SHAFA WARRI SAPELE ROAD','25',0.00,'2022-06-22 12:54:34',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(418,'21','237','2022-05-17',1,'','','5',751160.00,'65','','','9','AYM SHAFA WARRI SAPELE ROAD','20',0.00,'2022-06-22 12:55:58',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(419,'21','237','2022-05-18',1,'','','2',11412000.00,'66','','','','','',43978041.55,'2022-06-22 15:25:22',0,'JRE 576 XA 1100@680\r\nBAU 918 XR 5000\r\nJMT 42 YR 1300@680+15K\r\nKZR 500 XA 500@680\r\nSBG 868 XA 800@680\r\nMKA 215 ZE 800@680\r\nKZR 646 ZT 600@680\r\nDUT 343 XE 550@680\r\nJMT 196 ZY 1400@6800+15K\r\nJHN 575 XA 1200@680+15K\r\nDKA. 787 ZU 800@680\r\nGAN 08 XA 750@680+15K\r\nALK 317 XA 1250@680\r\nJRE 579 XA 1250@680\r\nRBC 346 YL 1300@680\r\nKWL 758 ZY 750@680\r\nSRP 466 XA 1300@680+15\r\nEPE 03 XD 1000@680\r\nAGO TO GENERATOR 10000\r\n\r\n','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(420,'21','237','2022-05-18',1,'','','2',11412000.00,'66','','','','','',43978041.55,'2022-06-22 15:25:25',0,'JRE 576 XA 1100@680\r\nBAU 918 XR 5000\r\nJMT 42 YR 1300@680+15K\r\nKZR 500 XA 500@680\r\nSBG 868 XA 800@680\r\nMKA 215 ZE 800@680\r\nKZR 646 ZT 600@680\r\nDUT 343 XE 550@680\r\nJMT 196 ZY 1400@6800+15K\r\nJHN 575 XA 1200@680+15K\r\nDKA. 787 ZU 800@680\r\nGAN 08 XA 750@680+15K\r\nALK 317 XA 1250@680\r\nJRE 579 XA 1250@680\r\nRBC 346 YL 1300@680\r\nKWL 758 ZY 750@680\r\nSRP 466 XA 1300@680+15\r\nEPE 03 XD 1000@680\r\nAGO TO GENERATOR 10000\r\n\r\n','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(421,'21','237','2022-05-18',1,'','','2',49900.00,'66','','','','','',0.00,'2022-06-22 15:28:19',0,'Toilet evacuation 35000\r\nDeport(RSH 118 FM) 10500\r\nEscort 1500\r\nWater 2400\r\nDetergent 500\r\n','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(422,'21','237','2022-05-18',1,'','','5',20453400.00,'66','','','13','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-22 15:29:31',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(423,'21','237','2022-05-18',1,'','','5',20453400.00,'66','','','13','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-22 15:29:33',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(424,'21','237','2022-05-18',1,'','','5',329075.00,'66','','','24','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-22 15:37:27',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(425,'21','237','2022-05-18',1,'','','5',947502.50,'66','','','15','AYM SHAFA WARRI SAPELE ROAD','56',0.00,'2022-06-22 15:41:32',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(426,'21','237','2022-05-18',1,'','','5',1012410.00,'66','','','9','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-22 15:45:42',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(427,'21','237','2022-05-18',1,'','','5',3536200.00,'66','','','18','AYM SHAFA WARRI SAPELE ROAD','25',0.00,'2022-06-22 15:46:50',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(428,'21','237','2022-05-19',1,'Authority expenses','','2',11524800.00,'67','','','','AYM SHAFA WARRI SAPELE ROAD','',43611497.30,'2022-06-22 17:34:23',0,'BAU 313 XR  GEAR OIL 6000\r\nBAU 495 XR 100@680\r\nBAU 496 XR 100@680\r\nALK 832 ZE 100@680\r\nBAU 349 ZE 200@680\r\nBAU 970 XR 100@680\r\nTKP 589 XA1050@680\r\nGWA 358 YE 700@680\r\nJMT 15 XE 700@680+10K\r\nKZR 644 ZT 650@680\r\nKZR 507 XA 650@680\r\nGME 921 YX 1200@680+15K\r\nMUB 65 XA 750@680+15k\r\nYLA 398 XU 1300@680+15k\r\nBAU 347 ZE 200@680\r\nSHM 380 XA 1100@680+10K\r\nJMT 711 ZH 650@680+15K\r\nGML 281XA 650@680\r\nBAU 309 ZE 200@680\r\nBAU 328 XR  11000\r\nBAU 317XR 100@680+27K\r\nGML 282 XX 600@680\r\nJMT 271 ZH 1250@680\r\nYLA 544 ZY 1300@680+15K\r\nJJN 110 YZ 800@680+ 32K\r\nMUB 435 YH 300@680\r\nJMT 108 ZY 700@680\r\nYLA 180 ZV 1100@680\r\nALK 728 XA 100@680\r\n','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(429,'21','237','2022-05-19',1,'','','2',65400.00,'67','','','','','',0.00,'2022-06-22 17:39:54',0,'First aid box drug 5900\r\nEscort 1500\r\nChamber labor 3000\r\nPms 25000\r\nSalary to security enere 30000','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(430,'21','237','2022-05-19',1,'','','5',9896700.00,'67','','','13','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-22 17:42:02',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(431,'21','237','2022-05-19',1,'','','5',1325320.00,'67','','','9','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-22 17:43:17',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(432,'21','237','2022-05-19',1,'','','5',1353150.00,'67','','','15','AYM SHAFA WARRI SAPELE ROAD','56',0.00,'2022-06-22 17:44:55',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(433,'21','237','2022-05-19',1,'','','5',701621.56,'67','','','18','AYM SHAFA WARRI SAPELE ROAD','25',0.00,'2022-06-22 17:46:04',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(434,'21','237','2022-05-19',1,'','','5',414085.00,'67','','','24','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-22 17:48:21',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(435,'21','237','2022-06-23',1,'','','2',9706500.00,'68','','','','AYM SHAFA WARRI SAPELE ROAD','',34429473.45,'2022-06-23 10:11:07',0,'TRR 540 YX 5000\r\nYLA 83 XU 1300@680+15K\r\nYLA 558 ZV 650@680+15K\r\nJRE 569 XA 200@680\r\nMUB 280 XA 1300@680+15K\r\nJJN 498 XB 800@680+ 15K\r\nJMT 23 XC 800@680+10K\r\nJMT 220 ZH 1150@680+15K\r\nFUR 82 XA 850@680+15K\r\nJMT 307 ZY 600@680+10K\r\nJMT 49 ZY 1150@680+15K\r\nBAU 59 ZY 700@680\r\nJRE 568 XA 750@680\r\nGWA 938 YL 750@680\r\nJRE 577 XA 750@680\r\nYLA 555 ZV 900@680+15k\r\nAAA 76 XA  1200@680\r\nAGO to generator 109500\r\n','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(436,'21','237','2022-05-20',1,'','','5',11268000.00,'68','','','13','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-23 10:13:13',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(437,'21','237','2022-05-20',1,'','','2',66600.00,'68','','','','','',0.00,'2022-06-23 11:05:58',0,'Delta state environment 40000\r\nStation exp 8600\r\nShaban salary 18000','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(438,'21','237','2022-05-20',1,'','','5',1575590.00,'68','','','15','AYM SHAFA WARRI SAPELE ROAD','56',0.00,'2022-06-23 11:28:35',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(439,'21','237','2022-05-20',1,'','','5',1785441.00,'68','','','9','AYM SHAFA WARRI SAPELE ROAD','20',0.00,'2022-06-23 11:29:57',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(440,'21','237','2022-05-20',1,'','','5',1152280.00,'68','','','18','AYM SHAFA WARRI SAPELE ROAD','25',0.00,'2022-06-23 11:31:07',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(441,'21','237','2022-05-20',1,'','','5',6805230.00,'68','','','24','AYM SHAFA WARRI SAPELE ROAD','0000',0.00,'2022-06-23 11:32:08',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(442,'21','237','2022-05-21',1,'Authority expenses','','2',7468500.00,'69','','','','','',33046009.60,'2022-06-24 09:59:27',0,'JMT 97 XA 750@680+15K\r\nKWL 553 YH 650@680\r\nGME 745 YX 1550@680+15K\r\nBAU 491 YP 550@680\r\nKAL 217 XA 1300@680+15K\r\nBAU 328 XR 78500\r\nDBM 221 XA 650@680\r\nKZR 630 ZT 650@680\r\nAPP 444 XL 700@680+10K\r\nYLA 152 XA 100@680\r\nJMT 42 XF 750@680+15K\r\nGME 48 XC 700@680+10K\r\nJJJ 20 XS 800@680\r\nBAU 491 YP 5000\r\nNSW 708 XA 750@680','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(443,'21','237','2022-05-21',1,'STATION EXPENSES','','2',33100.00,'69','','','','','',0.00,'2022-06-24 10:01:09',0,'President oview 3300\r\nDeport escort 1500\r\nPms 3300\r\nSalary sule 25000','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(444,'21','237','2022-05-21',1,'','','5',16375575.00,'69','','','13','AYM SHAFA WARRI SAPELE ROAD','0000',0.00,'2022-06-24 10:04:47',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(445,'21','237','2022-05-21',1,'','','5',540110.00,'69','','','17','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-24 10:07:41',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(446,'21','237','2022-05-21',1,'','','5',2231360.00,'69','','','9','AYM SHAFA WARRI SAPELE ROAD','20',0.00,'2022-06-24 10:32:04',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(447,'21','237','2022-05-21',1,'','','5',718700.00,'69','','','15','AYM SHAFA WARRI SAPELE ROAD','56',0.00,'2022-06-24 10:32:57',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(448,'21','237','2022-06-24',1,'','','5',3058010.00,'69','','','18','AYM SHAFA WARRI SAPELE ROAD','25',0.00,'2022-06-24 10:33:46',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(449,'21','237','2022-05-22',1,'','','2',3786500.00,'70','','','','','',32490082.90,'2022-06-25 08:47:53',0,'JMT 865 ZH 1150@680+15K\r\nKTG 151 XC 750+15K\r\nJMT 04 YA 350@680+15K\r\nJMT 191 XC 900@680+15k\r\nALK 833 XA 650@680\r\nBAU 624 YP 750@680\r\nJMT 03 YA 900@680+15K\r\nAGO TO GENERATOR 5500','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(450,'21','237','2022-05-22',1,'STATION EXPENSES','','2',1500.00,'70','','','','','',0.00,'2022-06-25 08:48:51',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(451,'21','237','2022-05-22',1,'','','5',11769545.00,'70','','','13','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-25 08:49:42',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(452,'21','237','2022-05-22',1,'','','5',96617719.00,'70','','','15','AYM SHAFA WARRI SAPELE ROAD','56',0.00,'2022-06-25 08:51:14',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(453,'21','237','2022-05-22',1,'','','5',1570468.00,'70','','','9','AYM SHAFA WARRI SAPELE ROAD','1570',0.00,'2022-06-25 08:52:31',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(454,'21','237','2022-05-22',1,'','','5',2372280.00,'70','','','18','AYM SHAFA WARRI SAPELE ROAD','25',0.00,'2022-06-25 08:53:36',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(455,'21','237','2022-05-22',1,'','','5',3049945.00,'70','','','24','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-06-25 08:56:14',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(456,'21','237','2022-06-23',1,'','','2',5475000.00,'71','','','','','',31966649.45,'2022-07-20 17:06:11',0,'FUR 202 XA 750@700+15K\r\nYLA 969 XA 750@700\r\nBUU 308 ZL 800@700\r\nJMT 88 ZY 750@700\r\nJMT 26 ZY  800@700\r\nJMT 25 ZY 800@700\r\nFUR 200 XA 1150@700\r\nYLA 962 ZY 750@700','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(457,'21','237','2022-06-23',1,'STATION EXPENSES','','2',30200.00,'71','','','','','',31966649.45,'2022-07-20 17:08:02',0,'Stationary, detergent and transport to bank 13800\r\nGate weldering 12000\r\nElectrician 2000\r\nWater 2400','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(458,'21','237','2022-06-23',1,'','','5',7214275.00,'71','','','13','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-07-20 17:09:11',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(459,'21','237','2022-05-23',1,'','','5',1603870.00,'71','','','18','27','27',0.00,'2022-07-20 17:13:33',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(460,'21','237','2022-05-23',1,'','','5',191000.00,'71','','','15','AYM SHAFA WARRI SAPELE ROAD','56',0.00,'2022-07-20 17:29:52',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(461,'21','237','2022-05-23',1,'','','5',1696580.00,'71','','','9','AYM SHAFA WARRI SAPELE ROAD','21',0.00,'2022-07-20 17:31:40',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(462,'21','237','2022-05-23',1,'','','5',4529902.90,'71','','','24','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-07-20 17:33:37',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(463,'21','237','2022-05-24',1,'','','2',3483400.00,'72','','','','','',16332353.55,'2022-07-22 14:53:29',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(464,'21','237','2022-05-24',1,'','','2',29169.05,'72','','','','','',0.00,'2022-07-22 14:57:44',0,'Floor 10000\r\nConcrete 4000\r\nRTT 5000\r\nDepot 9004.05 \r\nPadlock 1000\r\nRTT 165 ','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(465,'21','237','2022-05-24',1,'','','5',4616240.00,'72','','','13','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-07-22 14:58:44',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(466,'21','237','2022-05-24',1,'','','5',1381410.00,'72','','','18','27','0000',0.00,'2022-07-22 15:00:15',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(467,'21','237','2022-05-24',1,'','','5',1320472.00,'72','','','15','AYM SHAFA WARRI SAPELE ROAD','0000',0.00,'2022-07-22 15:01:59',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(468,'21','237','2022-05-24',1,'','','5',395800.00,'72','','','9','21','00000000',0.00,'2022-07-22 15:02:52',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(469,'21','237','2022-05-24',1,'','','5',3608673.25,'72','','','24','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-07-22 15:04:57',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(470,'21','237','2022-05-25',1,'','','2',6370500.00,'73','','','','','',24990095.15,'2022-07-25 21:04:53',0,'BAU 218 XR 750@700\r\nBBR 327 XA 500@700\r\nBAU 353 ZE 650@700\r\nBAU 981 XR 5000\r\nHJA 375 XA  500@700\r\nJJN 110 YZ 800@700+20k\r\nGME 490 XA 1200 @700 +15k\r\nKWL 526 XA 1350@700\r\nHNG 82 XA 1100 @700\r\nALK 825 XA 200 @700\r\nBAU 204 XR 5,000\r\nBAU 213 XR  31,500\r\nYLA 171 XU 1200@700 +15k\r\nAgo to gen 8400\r\n','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(471,'21','237','2022-05-25',1,'','','2',14030.85,'73','','','','','',0.00,'2022-07-25 21:07:55',0,'Escort 1500\r\nDepot 11630.85\r\nStation 500\r\nRTT 400','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(472,'21','237','2022-05-25',1,'','','5',3132000.00,'73','','','13','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-07-25 21:08:53',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(473,'21','237','2022-05-25',1,'','','5',1132909.00,'73','','','9','AYM SHAFA WARRI SAPELE ROAD','20',0.00,'2022-07-25 21:09:54',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(474,'21','237','2022-05-25',1,'','','5',1257175.00,'73','','','15','AYM SHAFA WARRI SAPELE ROAD','56',0.00,'2022-07-25 21:10:46',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(475,'21','237','2022-05-25',1,'','','5',1024520.00,'73','','','18','AYM SHAFA WARRI SAPELE ROAD','25',0.00,'2022-07-25 21:11:54',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(476,'21','237','2022-07-25',1,'','','5',652149.25,'73','','','24','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-07-25 21:14:15',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(477,'21','237','2022-05-26',1,'Authority expenses','','2',7120500.00,'75','','','','','',11119600.80,'2022-07-27 17:04:13',0,'BAU 204 XR  service items  104,000\r\nBAU 249 XR  feeding 5000\r\nRBC 370 ZN 650 @700 \r\nTRR 254 XA 650@700\r\nBAU 782 ZE 650@700\r\nFUR 198 XA 700@700+10k\r\nBSA 326 XA 700@700\r\nKWL 48 XA 700@700\r\nGAN 08 XA 900@720+15k\r\nJMT 949 ZH 750@720+15k\r\nBAU 603 ZE 750@700\r\nBAU 446 ZE 700@700\r\nALK 836 XA 650@700\r\nATN 708 YV 700@720+10k\r\nYLA 580 XM 1300@720+10k\r\nBAU 491 YP feeding 5000','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(478,'21','237','2022-05-26',1,'STATION EXPENSES','','2',43950.00,'75','','','','','',0.00,'2022-07-27 17:05:54',0,'Depot 1650\r\nEscort 1500\r\nCement 8600\r\nSalary 30000\r\nPms 2200','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(479,'21','237','2022-05-26',1,'','','5',14206300.00,'75','','','13','AYM SHAFA WARRI SAPELE ROAD','0000',0.00,'2022-07-27 17:07:20',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(480,'21','237','2022-05-25',1,'','','5',629561.44,'75','','','9','AYM SHAFA WARRI SAPELE ROAD','20',0.00,'2022-07-27 17:12:02',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(481,'21','237','2022-05-26',1,'','','5',1860542.00,'75','','','18','AYM SHAFA WARRI SAPELE ROAD','25',0.00,'2022-07-27 17:13:35',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(482,'21','237','2022-05-26',1,'','','5',3573925.00,'75','','','15','AYM SHAFA WARRI SAPELE ROAD','57&56',0.00,'2022-07-27 17:17:47',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(483,'21','237','2022-05-26',1,'','','5',2708085.00,'75','','','24','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-07-27 17:19:02',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(484,'21','237','2022-05-27',1,'Authority expenses','','2',6640000.00,'76','','','','','',34773831.75,'2022-07-27 18:41:54',0,'BAU 204 XR feeding 5000\r\nBAU 392 ZE service items 57000\r\nBAU 447 ZE service items 12000\r\nBAU 493 XR 100@720\r\nJMT 37 YQ 1150@720+15k\r\nBAU 260 XR 500@720\r\nFUR 213 XA 700@720 + 15k\r\nBAU 485 XR service items 62000\r\nBUU 05 ZL 700@720\r\nRBC 347 YL 750 @720\r\nRBC 345 YL 1100@720\r\nYLA 180 ZY 1100@720\r\nJMT 02 YA 1300@720+15k\r\nTRR 905 XA 750@720\r\nKRD 343 XP 500@720\r\nBAU 498 XR 100@720\r\nAgo to gen 72000\r\n','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(485,'21','237','2022-05-27',1,'','','2',14400.00,'76','','','','','',0.00,'2022-07-27 18:44:59',0,'Weight and measurements 10000\r\nMarket survey 1000\r\nPms RTT 3400','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(486,'21','237','2022-05-27',1,'','','5',14782300.00,'76','','','13','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-07-27 18:47:46',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(487,'21','237','2022-05-27',1,'','','5',1270940.00,'76','','','24','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-07-27 18:49:08',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(488,'21','237','2022-05-27',1,'','','5',1160000.00,'76','','','18','AYM SHAFA WARRI SAPELE ROAD','25',0.00,'2022-07-27 18:50:25',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(489,'21','237','2022-05-27',1,'','','5',509520.00,'76','','','9','20','00000000',0.00,'2022-07-27 18:52:11',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(490,'21','237','2022-05-27',1,'','','5',3639692.50,'76','','','15','AYM SHAFA WARRI SAPELE ROAD','56&57',34773831.75,'2022-07-27 18:54:31',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(491,'21','237','2022-05-28',1,'Authority expenses','','2',8949200.00,'77','','','','','',30217468.35,'2022-07-27 20:38:48',0,'BAU 249 XR feeding 5000\r\nBAU 692 ZE feeding 5000\r\nBAU 420 YP 600@720\r\nJMT 864 ZH  1300@720+15k \r\nJMT 386 ZY 400@720\r\nYLA 969 XA 700@720\r\nJMT 116 XC 800@720\r\nJMT 284 ZY 1200@720+10k\r\nPTN 424 XA 800@720\r\nJMT 22 XA 600@720\r\nBUU 806 ZL 500@720\r\nBAU 942 YP 100@720 \r\nDNG 642 XA 610@720\r\nBAU 196 YP 650@720\r\nGWA 938 YL 850@720\r\nJRE 576 XA 850 720\r\nGME 48 XC 700@720+10k\r\nBGR 71 XA 800@720\r\nBAU 692 ZE 250@720+15k\r\nHNG 83 XA 700@720','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(492,'21','237','2022-05-28',1,'','','5',7243400.00,'77','','','13','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-07-27 20:41:36',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(493,'21','237','2022-05-28',1,'','','5',4701495.00,'77','','','24','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-07-27 20:42:50',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(494,'21','237','2022-05-28',1,'STATION EXPENSES','','2',400640.00,'77','','','','','',0.00,'2022-07-27 20:47:23',0,'Station maintenance 4000\r\nWater 2400\r\nPms 3300\r\nBucket 3500\r\nStation salary 387440','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(495,'21','237','2022-05-28',1,'','','5',1287201.50,'77','','','18','AYM SHAFA WARRI SAPELE ROAD','25',0.00,'2022-07-27 20:48:58',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(496,'21','237','2022-05-28',1,'','','5',1108300.00,'77','','','9','AYM SHAFA WARRI SAPELE ROAD','20',0.00,'2022-07-27 20:50:17',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(497,'21','237','2022-05-28',1,'','','5',2383905.00,'77','','','15','AYM SHAFA WARRI SAPELE ROAD','56&57',0.00,'2022-07-27 20:51:38',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(498,'21','237','2022-05-29',1,'','','2',2834600.00,'78','','','','AYM SHAFA WARRI SAPELE ROAD','',23563640.40,'2022-07-31 15:21:55',0,'Ago to generator 72000\r\nDBM 213 XA 200@720\r\nALK 833 XA 600@720\r\nBAU 322 ZY 200@720\r\nBAU 274 XR 400@720+5K\r\nJRE 571 XA 1000@720\r\nBAU 59 ZY 700@720\r\nGWA 359 YA 730@720\r\n','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(499,'21','237','2022-05-29',1,'','','2',162010.00,'78','','','','','',0.00,'2022-07-31 15:24:21',0,'Station expenses \r\nStationary 1500\r\nSalary 154510\r\nFeeding 6000','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(500,'21','237','2022-05-29',1,'','','5',9466300.00,'78','','','13','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-07-31 15:25:19',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(501,'21','237','2022-05-29',1,'','','5',496200.00,'78','','','9','AYM SHAFA WARRI SAPELE ROAD','20',0.00,'2022-07-31 15:26:20',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(502,'21','237','2022-05-29',1,'','','5',604200.00,'78','','','18','AYM SHAFA WARRI SAPELE ROAD','25',0.00,'2022-07-31 15:27:21',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(503,'21','237','2022-05-29',1,'','','5',1864120.00,'78','','','15','AYM SHAFA WARRI SAPELE ROAD','57&56',0.00,'2022-07-31 15:29:13',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(504,'21','237','2022-05-29',1,'','','5',5041735.00,'78','','','24','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-07-31 15:30:05',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(505,'21','237','2022-05-30',1,'','','2',5131600.00,'79','','','','','',26011393.05,'2022-07-31 16:14:33',0,'COMPANY EXPENSES \r\nBAU 677 XR 500@720\r\nBAU 296 ZE 200@720\r\nALK 834 XA 200@720\r\nBAU 285 YP 5K\r\nBAU 986 XR 200@720\r\nJMT 414 ZY 1200@720+10K\r\nYLA 986 ZV 50@720+15K\r\nYLA 961 ZV 1200@720+10K\r\nYLA 559 ZV 750@720+15K\r\nGME 921 YX 1200@720+15K\r\nBAU 624 YP 750@720\r\nJJJ 20 XS 700@720\r\nAGO TO GENERATOR 80@720','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(506,'21','237','2022-05-30',1,'','','2',101400.00,'79','','','','','',0.00,'2022-07-31 16:23:16',0,'Station expenses \r\nEscort 1500\r\nClo 20000\r\nSalary 18000','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(507,'21','237','2022-05-30',1,'','','5',11467232.00,'79','','','13','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-07-31 16:30:49',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(508,'21','237','2022-05-30',1,'','','5',765860.00,'79','','','24','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-07-31 16:32:18',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(509,'21','237','2022-05-30',1,'','','5',111600.00,'79','','','18','AYM SHAFA WARRI SAPELE ROAD','25',0.00,'2022-07-31 16:34:26',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(510,'21','237','2022-05-30',1,'','','5',635700.00,'79','','','9','AYM SHAFA WARRI SAPELE ROAD','20',0.00,'2022-07-31 16:35:28',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(511,'21','237','2022-05-30',1,'','','5',2629272.00,'79','','','15','AYM SHAFA WARRI SAPELE ROAD','56&57',0.00,'2022-07-31 16:39:31',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(512,'21','237','2022-05-31',1,'','','2',5435000.00,'80','','','','','',28829660.70,'2022-07-31 18:28:48',0,'Company expenses\r\nKZR 502 XA 500@720\r\nALK 844 XA 650@720\r\nJJN 498 XB 550@720+15K\r\nJMT 220 ZH 450@720+15K\r\nDBM 58 XA 700@720\r\nBAU 312 ZE 650@720\r\nKRU 911 ZN 700@720\r\nBAU 490 ZE 650@720\r\nT9831LA 200@720+5K\r\nBAU 490 XR 100@720\r\nKTG 151 YR 700@720+45K\r\nJMT 516 YR 700@720\r\nJMT 307 ZY 600@720+30K\r\nALK 840 XA 200@680+5K','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(513,'21','237','2022-05-31',1,'','','2',101400.00,'80','','','','AYM SHAFA WARRI SAPELE ROAD','',0.00,'2022-07-31 18:35:15',0,'Station expenses\r\nElectrical material and labour 26600\r\nPms 188.60@165\r\nWater 2400\r\nSalary 41280','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(514,'21','237','2022-05-31',1,'','','5',9374500.00,'80','','','13','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-07-31 18:36:21',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(515,'21','237','2022-05-31',1,'','','5',1599810.00,'80','','','24','AYM SHAFA WARRI SAPELE ROAD','00000000',0.00,'2022-07-31 18:37:20',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(516,'21','237','2022-05-31',1,'','','5',304704.00,'80','','','9','AYM SHAFA WARRI SAPELE ROAD','20',0.00,'2022-07-31 18:38:12',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(517,'21','237','2022-05-31',1,'','','5',3832493.50,'80','','','15','AYM SHAFA WARRI SAPELE ROAD','56,57&58',0.00,'2022-07-31 18:39:33',0,'','772','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `purchases_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_receptions`
--

DROP TABLE IF EXISTS `purchases_receptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_receptions` (
  `bridge_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `purchase_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `loadingdate` datetime NOT NULL,
  `loadingpoint` varchar(100) DEFAULT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `received` decimal(20,2) NOT NULL,
  `distributed` decimal(20,2) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `vessel` varchar(50) NOT NULL,
  `drivername` varchar(30) NOT NULL,
  `driverphone` varchar(30) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`bridge_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`supplier_id`,`loadingdate`,`quantity`,`waybill`,`meterno`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`purchase_id`),
  KEY `truck_id` (`tank_id`)
) ENGINE=InnoDB AUTO_INCREMENT=232 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_receptions`
--

LOCK TABLES `purchases_receptions` WRITE;
/*!40000 ALTER TABLE `purchases_receptions` DISABLE KEYS */;
INSERT INTO `purchases_receptions` VALUES (1,'21',5,'237',2,1,'2022-03-26 00:00:00','WARRI',47320.00,47320.00,0.00,'0000110','','5','BAU 312 XR','MUHAMMED','0805645124','Product Received',5,'2022-03-26 15:11:35','764','0000-00-00 00:00:00','','2022-03-26 15:13:48','764'),(2,'21',6,'237',2,1,'2022-03-26 00:00:00','WARRI',30000.00,30000.00,0.00,'111202','','6','JJN 60 YS','auwal','0705653214','product received ',5,'2022-03-26 15:13:21','764','0000-00-00 00:00:00','','2022-03-26 15:14:09','764'),(3,'21',6,'237',2,1,'2022-03-26 00:00:00','WARRI',15000.00,15000.00,0.00,'111202','','7','JJN 60 YS','auwal','0705653214','product received',5,'2022-03-26 15:13:21','764','0000-00-00 00:00:00','','2022-03-26 15:14:09','764'),(5,'21',7,'237',2,1,'2022-03-27 00:00:00','WARRI',30000.00,30000.00,0.00,'111202','','7','bau 230 xr ','MUHAMMED','0805645124','product received',5,'2022-03-27 11:36:42','764','0000-00-00 00:00:00','','2022-03-27 11:47:06','764'),(6,'21',8,'237',2,1,'2022-03-27 00:00:00','WARRI',15000.00,15000.00,0.00,'111202','','7','bau 230 xr ','MUHAMMED','0805645124','product received',5,'2022-03-27 12:32:03','764','0000-00-00 00:00:00','','2022-03-27 12:32:19','764'),(7,'21',13,'237',2,1,'2022-03-28 00:00:00','WARRI',15000.00,15000.00,0.00,'099','','5','JJN 60 YS','MUSA','08067879787','RECEIVED',5,'2022-03-28 15:13:03','772','0000-00-00 00:00:00','','2022-03-28 15:25:47','772'),(9,'21',11,'237',1,1,'2022-03-28 00:00:00','WARRI',45000.00,45000.00,0.00,'009','','2','BAU 625 YP','MUSA','08067879787','BIILS',5,'2022-03-28 15:17:12','772','0000-00-00 00:00:00','','2022-03-28 15:24:18','772'),(10,'21',10,'237',1,1,'2022-03-28 00:00:00','WARRI',30000.00,30000.00,0.00,'900','','4','YLA 544 ZV','MUSA','08067879787','OK',5,'2022-03-28 15:19:40','772','0000-00-00 00:00:00','','2022-03-28 15:23:47','772'),(11,'21',9,'237',1,1,'2022-03-28 00:00:00','WARRI',15000.00,15000.00,0.00,'099','','1','KWL 553 YH','MUSA','08067879787','RECEIVED',5,'2022-03-28 15:22:03','772','0000-00-00 00:00:00','','2022-03-28 15:23:08','772'),(13,'21',12,'237',2,1,'2022-03-28 00:00:00','WARRI',50000.00,50000.00,0.00,'009','','6','BAU 204 XR','MUSA','08067879787','BIILS',5,'2022-03-28 15:31:16','772','0000-00-00 00:00:00','','2022-03-28 15:31:42','772'),(14,'21',10,'237',1,1,'2022-03-28 00:00:00','WARRI',15000.00,15000.00,0.00,'099','','1','YLA 544 ZV','MUSA','08067879787','RECEIVED',5,'2022-03-28 16:54:58','772','0000-00-00 00:00:00','','2022-03-28 16:55:33','772'),(15,'21',14,'237',2,1,'2022-04-05 00:00:00','WARRI',30000.00,30000.00,0.00,'099','','5','ALK 542 XA','MUSA','08067879787','RECEIVED',5,'2022-04-05 12:35:25','772','0000-00-00 00:00:00','','2022-04-05 12:35:50','772'),(16,'21',14,'237',2,1,'2022-04-05 00:00:00','WARRI',15000.00,15000.00,0.00,'009','','6','ALK 542 XA','MUSA','08067879787','RECEIVED',5,'2022-04-05 12:35:25','772','0000-00-00 00:00:00','','2022-04-05 12:35:50','772'),(17,'21',17,'237',2,1,'2022-04-12 00:00:00','WARRI',15000.00,15000.00,0.00,'099','','5','JJN 60 YS','MUSA','08067879787','RECEIVED',5,'2022-04-12 11:56:05','772','0000-00-00 00:00:00','','2022-04-12 12:06:45','772'),(18,'21',17,'237',2,1,'2022-04-12 00:00:00','WARRI',15000.00,15000.00,0.00,'099','','6','JJN 60 YS','MUSA','08067879787','RECEIVED',5,'2022-04-12 11:56:05','772','0000-00-00 00:00:00','','2022-04-12 12:07:34','772'),(19,'21',17,'237',2,1,'2022-04-12 00:00:00','WARRI',15000.00,15000.00,0.00,'099','','7','JJN 60 YS','MUSA','08067879787','RECEIVED',5,'2022-04-12 11:56:05','772','0000-00-00 00:00:00','','2022-04-12 12:08:01','772'),(20,'21',16,'237',1,1,'2022-04-12 00:00:00','WARRI',40000.00,45000.00,0.00,'009','','2','trr 68 yx','MUSA','08067879787','RECEIVED',5,'2022-04-12 11:57:42','772','0000-00-00 00:00:00','','2022-04-12 12:08:28','772'),(22,'21',18,'237',1,1,'2022-04-12 00:00:00','WARRI',34000.00,34000.00,0.00,'0999','','3','alk 742 xa','MUSA','08067879787','RECEIVED',5,'2022-04-12 12:05:30','772','0000-00-00 00:00:00','','2022-04-12 12:09:25','772'),(23,'21',18,'237',1,1,'2022-04-12 00:00:00','WARRI',26000.00,26000.00,0.00,'0999','','4','alk 742 xa','MUSA','08067879787','RECEIVED',5,'2022-04-12 12:05:30','772','0000-00-00 00:00:00','','2022-04-12 12:09:45','772'),(24,'21',21,'237',2,1,'2022-04-26 00:00:00','WARRI',13500.00,13500.00,0.00,'099','','5','bau 446 ze','MUSA','08067879787','RECEIVED',0,'2022-04-26 11:10:39','772','0000-00-00 00:00:00','','0000-00-00 00:00:00',''),(25,'21',15,'237',1,1,'2022-04-27 00:00:00','WARRI',15000.00,15000.00,0.00,'2300010491','','1','alk 742 xa','HASSAN','08061370146','PRODUCT RECIEVED',5,'2022-04-27 15:13:52','764','0000-00-00 00:00:00','','2022-04-27 15:14:34','764'),(26,'21',15,'237',1,1,'2022-04-27 00:00:00','WARRI',30000.00,30000.00,0.00,'2300010491','','3','alk 742 xa','HASSAN','08061370146','product received ',5,'2022-04-27 15:13:52','764','0000-00-00 00:00:00','','2022-04-27 15:14:34','764'),(27,'21',25,'237',2,1,'2022-04-29 00:00:00','WARRI',45000.00,45000.00,0.00,'009','','6','BAU 249 XR','MUSA','08067879787','RECEIVED',5,'2022-04-29 12:27:40','772','0000-00-00 00:00:00','','2022-04-29 12:29:43','772'),(28,'21',24,'237',2,1,'2022-04-29 00:00:00','WARRI',30000.00,30000.00,0.00,'099','','5','BAU 249 XR','MUSA','08067879787','RECEIVED',5,'2022-04-29 12:29:00','772','0000-00-00 00:00:00','','2022-04-29 12:30:06','772'),(29,'21',24,'237',2,1,'2022-04-29 00:00:00','WARRI',15000.00,15000.00,0.00,'009','','7','BAU 249 XR','MUSA','08067879787','RECEIVED',5,'2022-04-29 12:29:00','772','0000-00-00 00:00:00','','2022-04-29 12:30:26','772'),(30,'21',26,'237',1,1,'2022-05-06 00:00:00','WARRI',20000.00,20000.00,0.00,'009','','2','BAU 321 XA','MUSA','08067879787','RECEIVED',5,'2022-05-06 15:15:25','772','0000-00-00 00:00:00','','2022-05-06 15:27:49','772'),(31,'21',26,'237',1,1,'2022-05-06 00:00:00','WARRI',20000.00,20000.00,0.00,'009','','3','BAU 321 XA','MUSA','08067879787','RECEIVED',5,'2022-05-06 15:15:25','772','0000-00-00 00:00:00','','2022-05-06 15:16:47','772'),(32,'21',26,'237',1,1,'2022-05-06 00:00:00','WARRI',20000.00,20000.00,0.00,'009','','4','BAU 321 XA','MUSA','08067879787','RECEIVED',5,'2022-05-06 15:15:25','772','0000-00-00 00:00:00','','2022-05-06 15:15:59','772'),(35,'21',30,'237',2,1,'2022-05-14 00:00:00','WARRI',33000.00,33000.00,0.00,'900','','5','BAU 296 ZE','SHOLA','0805567898','RECEIVE',5,'2022-05-14 12:48:10','772','0000-00-00 00:00:00','','2022-05-14 12:53:28','772'),(36,'21',30,'237',2,1,'2022-05-14 00:00:00','WARRI',17000.00,17000.00,0.00,'900','','7','BAU 296 ZE','SHOLA','0805567898','RECEIVE',5,'2022-05-14 12:48:10','772','0000-00-00 00:00:00','','2022-05-14 12:53:28','772'),(37,'21',29,'237',1,1,'2022-05-14 00:00:00','WARRI',16500.00,16500.00,0.00,'099','','1','BAU 971 XR','MUSA','08067879787','RECEIVED',5,'2022-05-14 12:55:34','772','0000-00-00 00:00:00','','2022-05-14 12:56:39','772'),(38,'21',29,'237',1,1,'2022-05-14 00:00:00','WARRI',23500.00,23500.00,0.00,'009','','2','BAU 971 XR','MUSA','08067879787','RECEIVED',5,'2022-05-14 12:55:34','772','0000-00-00 00:00:00','','2022-05-14 12:56:12','772'),(39,'21',33,'237',2,1,'2022-05-14 00:00:00','WARRI',15000.00,15000.00,0.00,'099','','5','ALK 840 XA','MUSA','08067879787','RECEIVED',5,'2022-05-14 14:26:43','772','0000-00-00 00:00:00','','2022-05-14 14:36:16','772'),(40,'21',33,'237',2,1,'2022-05-14 00:00:00','WARRI',30000.00,30000.00,0.00,'099','','6','ALK 840 XA','MUSA','08067879787','RECEIVED',5,'2022-05-14 14:26:43','772','0000-00-00 00:00:00','','2022-05-14 14:36:53','772'),(41,'21',32,'237',1,1,'2022-05-14 00:00:00','WARRI',30000.00,30000.00,0.00,'099','','1','BAU 660 ZE','MUSA','08067879787','RECEIVED',5,'2022-05-14 14:31:18','772','0000-00-00 00:00:00','','2022-05-14 14:37:17','772'),(42,'21',32,'237',1,1,'2022-05-14 00:00:00','WARRI',15000.00,15000.00,0.00,'099','','2','BAU 660 ZE','MUSA','08067879787','RECEIVED',5,'2022-05-14 14:31:18','772','0000-00-00 00:00:00','','2022-05-14 14:37:43','772'),(43,'21',31,'237',1,1,'2022-05-14 00:00:00','WARRI',30000.00,30000.00,0.00,'009','','3','JJN 60 YS','MUSA','08067879787','RECEIVED',5,'2022-05-14 14:33:58','772','0000-00-00 00:00:00','','2022-05-14 14:38:05','772'),(44,'21',31,'237',1,1,'2022-05-14 00:00:00','WARRI',15000.00,15000.00,0.00,'009','','4','JJN 60 YS','MUSA','08067879787','RECEIVED',5,'2022-05-14 14:33:58','772','0000-00-00 00:00:00','','2022-05-14 14:38:28','772'),(45,'21',34,'237',2,1,'2022-05-15 00:00:00','WARRI',17000.00,17000.00,0.00,'099','','5','ALK 836 XH','MUSA','08067879787','RECEIVED',5,'2022-05-15 11:35:30','772','0000-00-00 00:00:00','','2022-05-15 11:37:46','772'),(46,'21',34,'237',2,1,'2022-05-15 00:00:00','WARRI',17000.00,17000.00,0.00,'009','','6','ALK 836 XH','MUSA','08067879787','RECEIVED',5,'2022-05-15 11:35:30','772','0000-00-00 00:00:00','','2022-05-15 11:37:13','772'),(47,'21',34,'237',2,1,'2022-05-15 00:00:00','WARRI',16000.00,16000.00,0.00,'009','','7','ALK 836 XH','MUSA','08067879787','RECEIVED',5,'2022-05-15 11:35:30','772','0000-00-00 00:00:00','','2022-05-15 11:36:27','772'),(48,'21',37,'237',2,1,'2022-05-15 00:00:00','WARRI',15000.00,15000.00,0.00,'009','','5','ALK 542 XA','MUSA','08067879787','RECEIVED',5,'2022-05-15 12:50:15','772','0000-00-00 00:00:00','','2022-05-15 12:59:24','772'),(49,'21',37,'237',2,1,'2022-05-15 00:00:00','WARRI',15000.00,15000.00,0.00,'009','','6','ALK 542 XA','MUSA','08067879787','RECEIVED',5,'2022-05-15 12:50:15','772','0000-00-00 00:00:00','','2022-05-15 12:58:41','772'),(50,'21',37,'237',2,1,'2022-05-15 00:00:00','WARRI',15000.00,15000.00,0.00,'009','','7','ALK 542 XA','MUSA','08067879787','RECEIVED',5,'2022-05-15 12:50:15','772','0000-00-00 00:00:00','','2022-05-15 12:58:13','772'),(51,'21',36,'237',1,1,'2022-05-15 00:00:00','WARRI',33000.00,33000.00,0.00,'077','','1','ALK 833 XA ','MUSA','08067879787','RECEIVED',5,'2022-05-15 12:53:16','772','0000-00-00 00:00:00','','2022-05-15 12:57:39','772'),(52,'21',36,'237',1,1,'2022-05-15 00:00:00','WARRI',19000.00,19000.00,0.00,'077','','2','ALK 833 XA ','MUSA','08067879787','RECEIVED',5,'2022-05-15 12:53:16','772','0000-00-00 00:00:00','','2022-05-15 12:56:57','772'),(53,'21',35,'237',1,1,'2022-05-15 00:00:00','WARRI',33000.00,33000.00,0.00,'0999','','3','BAU 207 XR ','MUSA','08067879787','RECEIVED',5,'2022-05-15 12:54:58','772','0000-00-00 00:00:00','','2022-05-15 12:56:29','772'),(54,'21',35,'237',1,1,'2022-05-15 00:00:00','WARRI',17000.00,17000.00,0.00,'0999','','4','BAU 207 XR ','MUSA','08067879787','RECEIVED',5,'2022-05-15 12:54:58','772','0000-00-00 00:00:00','','2022-05-15 12:56:08','772'),(55,'21',40,'237',2,1,'2022-05-17 00:00:00','WARRI',30000.00,30000.00,0.00,'0999','','5','BAU 314 YP','SALIHU','07066839140','RECEIVED',5,'2022-05-17 14:58:03','772','0000-00-00 00:00:00','','2022-05-17 15:07:15','772'),(56,'21',40,'237',2,1,'2022-05-17 00:00:00','WARRI',15000.00,15000.00,0.00,'0999','','6','BAU 314 YP','SALIHU','07066839140','RECEIVED',5,'2022-05-17 14:58:03','772','0000-00-00 00:00:00','','2022-05-17 15:06:44','772'),(57,'21',39,'237',1,1,'2022-05-17 00:00:00','WARRI',27000.00,27000.00,0.00,'09999','','3','TRR 68 YX','SALIHU','07066839140','RECEIVED',5,'2022-05-17 15:00:48','772','0000-00-00 00:00:00','','2022-05-17 15:06:18','772'),(58,'21',39,'237',1,1,'2022-05-17 00:00:00','WARRI',13000.00,13000.00,0.00,'09999','','4','TRR 68 YX','SALIHU','07066839140','RECEIVED',5,'2022-05-17 15:00:48','772','0000-00-00 00:00:00','','2022-05-17 15:05:38','772'),(59,'21',38,'237',1,1,'2022-05-17 00:00:00','WARRI',30000.00,30000.00,0.00,'0999','','1','ALK 743 XA','SALIHU','07066839140','RECEIVED',5,'2022-05-17 15:02:24','772','0000-00-00 00:00:00','','2022-05-17 15:04:40','772'),(60,'21',38,'237',1,1,'2022-05-17 00:00:00','WARRI',15000.00,15000.00,0.00,'0999','','2','ALK 743 XA','SALIHU','07066839140','RECEIVED',5,'2022-05-17 15:02:24','772','0000-00-00 00:00:00','','2022-05-17 15:04:12','772'),(61,'21',41,'237',2,1,'2022-05-18 00:00:00','WARRI',15000.00,15000.00,0.00,'0999','','5','BAU 241 XR','MUSA','07066839140','RECEIVED',5,'2022-05-18 17:05:23','772','0000-00-00 00:00:00','','2022-05-19 14:47:23','772'),(62,'21',41,'237',2,1,'2022-05-18 00:00:00','WARRI',30000.00,30000.00,0.00,'0999','','6','BAU 241 XR','MUSA','07066839140','RECEIVED',5,'2022-05-18 17:05:23','772','0000-00-00 00:00:00','','2022-05-19 14:47:56','772'),(63,'21',42,'237',1,1,'2022-05-18 00:00:00','WARRI',45000.00,45000.00,0.00,'09999','','4','BAU 803 ZE','SALIHU','07066839140','RECEIVED',5,'2022-05-18 18:20:14','772','0000-00-00 00:00:00','','2022-05-18 18:21:39','772'),(64,'21',43,'237',1,1,'2022-05-19 00:00:00','WARRI',45000.00,45000.00,0.00,'00000','','2','BAU 786 YP','Musa','07066839140','Received',5,'2022-05-19 14:44:26','772','0000-00-00 00:00:00','','2022-05-19 14:49:24','772'),(65,'21',44,'237',1,1,'2022-05-19 00:00:00','WARRI',50000.00,50000.00,0.00,'09999','','3','BAU 396 ZE','SALIHU','07066839140','RECEIVED',5,'2022-05-19 17:35:19','772','0000-00-00 00:00:00','','2022-05-19 17:41:58','772'),(66,'21',45,'237',2,1,'2022-05-19 00:00:00','WARRI',25000.00,25000.00,0.00,'09999','','7','BAU 340 ZE','SALIHU','07066839140','RECEIVED',5,'2022-05-19 17:38:18','772','0000-00-00 00:00:00','','2022-05-19 17:42:52','772'),(67,'21',46,'237',2,1,'2022-05-19 00:00:00','WARRI',41600.00,41600.00,0.00,'000000','','5','DBM 218 XA','SALIHU','07066839140','RECEIVED',5,'2022-05-19 17:41:28','772','0000-00-00 00:00:00','','2022-05-19 17:43:42','772'),(68,'21',46,'237',2,1,'2022-05-19 00:00:00','WARRI',8400.00,8400.00,0.00,'000000','','6','DBM 218 XA','SALIHU','07066839140','RECEIVED',5,'2022-05-19 17:41:28','772','0000-00-00 00:00:00','','2022-05-19 17:44:40','772'),(70,'21',45,'237',2,1,'2022-05-19 00:00:00','WARRI',25000.00,25000.00,0.00,'000000','','6','BAU 340 ZE','SALIHU','07066839140','RECEIVED',5,'2022-05-19 17:48:19','772','0000-00-00 00:00:00','','2022-05-19 17:50:56','772'),(71,'21',48,'237',1,1,'2022-05-19 00:00:00','WARRI',45000.00,45000.00,0.00,'0000','','1','BAU 59 ZY','Musa','07066839140','Received',5,'2022-05-19 19:23:09','772','0000-00-00 00:00:00','','2022-05-19 19:25:03','772'),(72,'21',47,'237',1,1,'2022-05-19 00:00:00','WARRI',45000.00,45000.00,0.00,'00000000','','4','BAU 261 XR','Musa','07066839140','Received',5,'2022-05-19 19:24:33','772','0000-00-00 00:00:00','','2022-05-19 19:26:03','772'),(73,'21',49,'237',2,1,'2022-05-23 00:00:00','WARRI',15000.00,15000.00,0.00,'00000009','','5','BAU 584 ZE','Musa','07066839140','Received',5,'2022-05-23 17:25:05','772','0000-00-00 00:00:00','','2022-05-26 19:39:08','772'),(74,'21',50,'237',2,1,'2022-05-23 00:00:00','WARRI',17000.00,17000.00,0.00,'00000009','','5','DBM 217 XA','Musa','07066839140','Received',5,'2022-05-23 17:28:29','772','0000-00-00 00:00:00','','2022-05-26 19:40:21','772'),(75,'21',50,'237',2,1,'2022-05-23 00:00:00','WARRI',16000.00,16000.00,0.00,'00000009','','6','DBM 217 XA','Musa','07066839140','Received',5,'2022-05-23 17:28:29','772','0000-00-00 00:00:00','','2022-05-26 19:40:01','772'),(76,'21',50,'237',2,1,'2022-05-23 00:00:00','WARRI',17000.00,17000.00,0.00,'00000009','','7','DBM 217 XA','Musa','07066839140','Received',5,'2022-05-23 17:28:29','772','0000-00-00 00:00:00','','2022-05-26 19:39:41','772'),(77,'21',51,'237',1,1,'2022-05-26 00:00:00','WARRI',40000.00,40000.00,0.00,'00000009','','2','BAU 274 XR','Musa','07066839140','Received',5,'2022-05-26 19:37:23','772','0000-00-00 00:00:00','','2022-05-26 19:38:18','772'),(78,'21',52,'237',1,1,'2022-05-30 00:00:00','WARRI',20000.00,20000.00,0.00,'00000000','','2','BAU 982XR','Musa','07066839140','Received',5,'2022-05-30 19:54:01','772','0000-00-00 00:00:00','','2022-05-30 19:59:54','772'),(79,'21',52,'237',1,1,'2022-05-30 00:00:00','WARRI',40000.00,40000.00,0.00,'00000000','','4','BAU 982XR','Musa','07066839140','Received',5,'2022-05-30 19:54:01','772','0000-00-00 00:00:00','','2022-05-30 20:00:16','772'),(80,'21',53,'237',1,1,'2022-05-30 00:00:00','WARRI',45000.00,45000.00,0.00,'00000009','','3','JJN 60 YS','Musa','07066839140','Received',5,'2022-05-30 19:55:40','772','0000-00-00 00:00:00','','2022-05-30 20:00:50','772'),(81,'21',54,'237',2,1,'2022-05-30 00:00:00','WARRI',15900.00,15900.00,0.00,'0000','','5','BAU 343 ZE','Musa','07066839140','Received',5,'2022-05-30 19:58:50','772','0000-00-00 00:00:00','','2022-05-30 20:01:12','772'),(82,'21',54,'237',2,1,'2022-05-30 00:00:00','WARRI',16400.00,16400.00,0.00,'00000','','6','BAU 343 ZE','Musa','07066839140','Received',5,'2022-05-30 19:58:50','772','0000-00-00 00:00:00','','2022-05-30 20:01:33','772'),(83,'21',56,'237',1,1,'2022-05-31 00:00:00','WARRI',19000.00,19000.00,0.00,'00000009','','3','BAU 249 XR','Musa','07066839140','Received',5,'2022-05-31 16:32:43','772','0000-00-00 00:00:00','','2022-05-31 17:02:26','772'),(84,'21',56,'237',1,1,'2022-05-31 00:00:00','WARRI',31000.00,31000.00,0.00,'00000000','','4','BAU 249 XR','Musa','07066839140','Received',5,'2022-05-31 16:32:43','772','0000-00-00 00:00:00','','2022-05-31 17:02:07','772'),(85,'21',57,'237',2,1,'2022-05-31 00:00:00','WARRI',40000.00,40000.00,0.00,'00000000','','6','BAU 982XR','Musa','07066839140','Received',5,'2022-05-31 16:44:30','772','0000-00-00 00:00:00','','2022-05-31 17:01:43','772'),(86,'21',57,'237',2,1,'2022-05-31 00:00:00','WARRI',20000.00,20000.00,0.00,'00000009','','7','BAU 982XR','Musa','07066839140','Received',5,'2022-05-31 16:44:30','772','0000-00-00 00:00:00','','2022-05-31 17:01:22','772'),(88,'21',58,'237',2,1,'2022-05-31 00:00:00','WARRI',45000.00,45000.00,0.00,'0000','','5','JJN 60 YS','Musa','07066839140','Received',5,'2022-05-31 16:48:38','772','0000-00-00 00:00:00','','2022-05-31 16:49:20','772'),(89,'21',55,'237',1,1,'2022-05-31 00:00:00','WARRI',45000.00,45000.00,0.00,'0000','','1','JJN 60 YS','Musa','07066839140','',5,'2022-05-31 18:29:22','772','0000-00-00 00:00:00','','2022-05-31 18:30:24','772'),(90,'21',60,'237',1,1,'2022-06-01 00:00:00','WARRI',15000.00,15000.00,0.00,'00000000','','2','BAU 712 ZE','Musa','07066839140','Received',5,'2022-06-01 09:29:33','772','0000-00-00 00:00:00','','2022-06-01 09:32:46','772'),(91,'21',60,'237',1,1,'2022-06-01 00:00:00','WARRI',30000.00,30000.00,0.00,'00000000','','4','BAU 712 ZE','Musa','07066839140','Received',5,'2022-06-01 09:29:33','772','0000-00-00 00:00:00','','2022-06-01 09:32:27','772'),(92,'21',59,'237',2,1,'2022-06-01 00:00:00','WARRI',16500.00,16500.00,0.00,'0000','','5','BAU 326 XR','Musa','07066839140','',5,'2022-06-01 09:31:07','772','0000-00-00 00:00:00','','2022-06-01 09:32:06','772'),(93,'21',59,'237',2,1,'2022-06-01 00:00:00','WARRI',17000.00,17000.00,0.00,'00000','','6','BAU 326 XR','Musa','07066839140','',5,'2022-06-01 09:31:07','772','0000-00-00 00:00:00','','2022-06-01 09:31:44','772'),(94,'21',59,'237',2,1,'2022-06-01 00:00:00','WARRI',16500.00,16000.00,0.00,'00000009','','7','BAU 326 XR','Musa','07066839140','',5,'2022-06-01 09:31:07','772','0000-00-00 00:00:00','','2022-06-01 09:31:24','772'),(95,'21',61,'237',1,1,'2022-06-02 00:00:00','WARRI',30000.00,30000.00,0.00,'00000','','2','JJN 60 YS','Musa','07066839140','Received',5,'2022-06-02 11:58:43','772','0000-00-00 00:00:00','','2022-06-02 12:04:08','772'),(96,'21',61,'237',1,1,'2022-06-02 00:00:00','WARRI',15000.00,15000.00,0.00,'00000009','','3','JJN 60 YS','Musa','07066839140','Received',5,'2022-06-02 11:58:43','772','0000-00-00 00:00:00','','2022-06-02 12:08:39','772'),(97,'21',62,'237',2,1,'2022-06-02 00:00:00','WARRI',45000.00,45000.00,0.00,'0000','','5','BAU 285 YP','Musa','07066839140','Received',5,'2022-06-02 12:00:08','772','0000-00-00 00:00:00','','2022-06-02 12:08:19','772'),(98,'21',63,'237',2,1,'2022-06-02 00:00:00','WARRI',33000.00,33000.00,0.00,'00000000','','6','BAU 828 XA ','Musa','07066839140','Received',5,'2022-06-02 12:02:40','772','0000-00-00 00:00:00','','2022-06-02 12:07:50','772'),(99,'21',63,'237',2,1,'2022-06-02 00:00:00','WARRI',17000.00,17000.00,0.00,'00000009','','7','BAU 828 XA ','Musa','07066839140','Received',5,'2022-06-02 12:02:40','772','0000-00-00 00:00:00','','2022-06-02 12:03:05','772'),(100,'21',64,'237',1,1,'2022-06-02 00:00:00','WARRI',15000.00,15000.00,0.00,'00000009','','3','JJN 60 YS','Musa','07066839140','Received',5,'2022-06-02 12:53:02','772','0000-00-00 00:00:00','','2022-06-02 20:28:49','772'),(101,'21',64,'237',1,1,'2022-06-02 00:00:00','WARRI',30000.00,30000.00,0.00,'00000000','','4','JJN 60 YS','Musa','07066839140','Received',5,'2022-06-02 12:53:02','772','0000-00-00 00:00:00','','2022-06-02 20:30:16','772'),(102,'21',65,'237',2,1,'2022-06-02 00:00:00','WARRI',21000.00,21000.00,0.00,'0000','','5','ALK 784 XA','Musa','07066839140','Received',5,'2022-06-02 12:56:02','772','0000-00-00 00:00:00','','2022-06-02 20:31:27','772'),(103,'21',65,'237',2,1,'2022-06-02 00:00:00','WARRI',12000.00,12000.00,0.00,'00000','','6','ALK 784 XA','Musa','07066839140','Received',5,'2022-06-02 12:56:02','772','0000-00-00 00:00:00','','2022-06-02 20:31:48','772'),(104,'21',65,'237',2,1,'2022-06-02 00:00:00','WARRI',12000.00,12000.00,0.00,'00000009','','7','ALK 784 XA','Musa','07066839140','Received',5,'2022-06-02 12:56:02','772','0000-00-00 00:00:00','','2022-06-02 20:32:12','772'),(105,'21',66,'237',1,1,'2022-06-02 00:00:00','WARRI',50000.00,50000.00,0.00,'0000','','1','JMT 53 YR','Musa','07066839140','Received',5,'2022-06-02 20:36:10','772','0000-00-00 00:00:00','','2022-06-02 20:36:30','772'),(106,'21',67,'237',2,1,'2022-06-02 00:00:00','WARRI',21700.00,12700.00,0.00,'0000','','5','ALK 965 XA','Yusuf','08033212397','Received',5,'2022-06-02 20:38:35','772','0000-00-00 00:00:00','','2022-06-02 22:30:10','772'),(107,'21',69,'237',1,1,'2022-06-02 00:00:00','WARRI',45000.00,45000.00,0.00,'00000000','','2','BAU 285 YP','Yusuf','07066839140','Received',5,'2022-06-02 22:26:37','772','0000-00-00 00:00:00','','2022-06-02 22:29:49','772'),(108,'21',68,'237',2,1,'2022-06-02 00:00:00','WARRI',15000.00,15000.00,0.00,'00000000','','5','BAU 204 XR','Yusuf','07066839140','Received',5,'2022-06-02 22:28:20','772','0000-00-00 00:00:00','','2022-06-02 22:29:32','772'),(109,'21',68,'237',2,1,'2022-06-02 00:00:00','WARRI',20000.00,20000.00,0.00,'00000000','','6','BAU 204 XR','Yusuf','07066839140','Received',5,'2022-06-02 22:28:20','772','0000-00-00 00:00:00','','2022-06-02 22:29:09','772'),(110,'21',68,'237',2,1,'2022-06-02 00:00:00','WARRI',15000.00,15000.00,0.00,'00000000','','7','BAU 204 XR','Yusuf','07066839140','Received',5,'2022-06-02 22:28:20','772','0000-00-00 00:00:00','','2022-06-02 22:28:50','772'),(111,'21',70,'237',1,1,'2022-06-05 00:00:00','WARRI',45000.00,45000.00,0.00,'00000000','','4','BAU 969 XR','Yusuf','07066839140','Received',5,'2022-06-05 11:09:09','772','0000-00-00 00:00:00','','2022-06-05 11:09:45','772'),(112,'21',71,'237',1,1,'2022-06-06 00:00:00','WARRI',30000.00,30000.00,0.00,'00000000','','1','ALK 965 XA','Musa','07066839140','Received',5,'2022-06-06 08:50:50','772','0000-00-00 00:00:00','','2022-06-06 08:51:41','772'),(113,'21',71,'237',1,1,'2022-06-06 00:00:00','WARRI',15000.00,15000.00,0.00,'00000','','2','ALK 965 XA','Musa','07066839140','Received',5,'2022-06-06 08:50:50','772','0000-00-00 00:00:00','','2022-06-06 08:52:11','772'),(114,'21',72,'237',1,1,'2022-06-06 00:00:00','WARRI',50000.00,50000.00,0.00,'00000000','','3','BAU 249 XR','Musa','07066839140','Received',5,'2022-06-06 09:33:55','772','0000-00-00 00:00:00','','2022-06-06 09:35:03','772'),(115,'21',73,'237',1,1,'2022-06-06 00:00:00','WARRI',15000.00,15000.00,0.00,'00000','','2','BAU 285 YP','Musa','07066839140','Received',5,'2022-06-06 16:35:57','772','0000-00-00 00:00:00','','2022-06-06 16:40:41','772'),(116,'21',73,'237',1,1,'2022-06-06 00:00:00','WARRI',30000.00,30000.00,0.00,'00000','','4','BAU 285 YP','Musa','07066839140','Received',5,'2022-06-06 16:35:57','772','0000-00-00 00:00:00','','2022-06-06 17:50:14','772'),(117,'21',74,'237',2,1,'2022-06-06 00:00:00','WARRI',33500.00,33500.00,0.00,'00000000','','5','BAU 296 ZE','Yusuf','07066839140','Received',5,'2022-06-06 17:53:41','772','0000-00-00 00:00:00','','2022-06-06 17:54:37','772'),(118,'21',75,'237',2,1,'2022-06-06 00:00:00','WARRI',15000.00,15000.00,0.00,'0000','','5','BAU 312 XR','Yusuf','07066839140','Received',5,'2022-06-06 17:58:00','772','0000-00-00 00:00:00','','2022-06-06 18:01:54','772'),(119,'21',75,'237',2,1,'2022-06-06 00:00:00','WARRI',20000.00,20000.00,0.00,'00000','','6','BAU 312 XR','Yusuf','07066839140','Received',5,'2022-06-06 17:58:00','772','0000-00-00 00:00:00','','2022-06-06 18:02:44','772'),(120,'21',75,'237',2,1,'2022-06-06 00:00:00','WARRI',15000.00,15000.00,0.00,'00000000','','7','BAU 312 XR','Yusuf','07066839140','Received',5,'2022-06-06 17:58:00','772','0000-00-00 00:00:00','','2022-06-06 18:03:16','772'),(125,'21',76,'237',2,1,'2022-06-06 00:00:00','WARRI',33000.00,33000.00,0.00,'00000','','6','BAU 204 YR','Musa','07066839140','Received',5,'2022-06-06 18:17:07','772','0000-00-00 00:00:00','','2022-06-07 08:01:01','772'),(126,'21',76,'237',2,1,'2022-06-06 00:00:00','WARRI',17000.00,17000.00,0.00,'00000000','','7','BAU 204 YR','Musa','07066839140','Received',5,'2022-06-06 18:17:07','772','0000-00-00 00:00:00','','2022-06-06 18:17:51','772'),(127,'21',78,'237',1,1,'2022-06-08 00:00:00','WARRI',17000.00,17000.00,0.00,'0000','','1','ALK 742 XA','Musa','07066839140','Received',5,'2022-06-08 10:42:34','772','0000-00-00 00:00:00','','2022-06-08 10:44:11','772'),(128,'21',78,'237',1,1,'2022-06-08 00:00:00','WARRI',40000.00,40000.00,0.00,'00000','','2','ALK 742 XA','Musa','07066839140','Received',5,'2022-06-08 10:42:34','772','0000-00-00 00:00:00','','2022-06-08 10:43:45','772'),(129,'21',77,'237',1,1,'2022-06-08 00:00:00','WARRI',31000.00,31000.00,0.00,'00000000','','3','TRR 540 YX','Yusuf','07066839140','Received',5,'2022-06-08 10:46:24','772','0000-00-00 00:00:00','','2022-06-08 13:11:22','772'),(130,'21',77,'237',1,1,'2022-06-08 00:00:00','WARRI',14.00,14000.00,0.00,'00000','','4','TRR 540 YX','Yusuf','07066839140','Received',5,'2022-06-08 10:46:24','772','0000-00-00 00:00:00','','2022-06-08 10:46:47','772'),(131,'21',79,'237',1,1,'2022-06-08 00:00:00','WARRI',21000.00,21000.00,0.00,'00000000','','1','ALK 784 XA','Musa','07066839140','Received',5,'2022-06-08 17:53:45','772','0000-00-00 00:00:00','','2022-06-08 17:56:48','772'),(132,'21',79,'237',1,1,'2022-06-08 00:00:00','WARRI',12000.00,12000.00,0.00,'00000000','','3','ALK 784 XA','Musa','07066839140','Received',5,'2022-06-08 17:53:45','772','0000-00-00 00:00:00','','2022-06-08 18:44:17','772'),(133,'21',79,'237',1,1,'2022-06-08 00:00:00','WARRI',12000.00,12000.00,0.00,'00000000','','4','ALK 784 XA','Musa','07066839140','Received',5,'2022-06-08 17:53:45','772','0000-00-00 00:00:00','','2022-06-08 18:45:26','772'),(134,'21',80,'237',1,1,'2022-06-08 00:00:00','WARRI',45000.00,45000.00,0.00,'00000000','','2','BAU 499 XR ','Yusuf','07066839140','Received',5,'2022-06-08 17:55:52','772','0000-00-00 00:00:00','','2022-06-08 18:46:21','772'),(135,'21',81,'237',2,1,'2022-06-08 00:00:00','WARRI',48500.00,48500.00,0.00,'00000009','','6','BAU 296 ZE','Yusuf','07066839140','Received',5,'2022-06-08 19:53:56','772','0000-00-00 00:00:00','','2022-06-08 20:00:50','772'),(136,'21',81,'237',2,1,'2022-06-08 00:00:00','WARRI',1500.00,1500.00,0.00,'00000000','','7','BAU 296 ZE','Yusuf','07066839140','Received',5,'2022-06-08 19:53:56','772','0000-00-00 00:00:00','','2022-06-08 20:01:10','772'),(137,'21',82,'237',2,1,'2022-06-08 00:00:00','WARRI',45000.00,45000.00,0.00,'00000000','','5','ALK 784 XA','Yusuf','07066839140','Received',5,'2022-06-08 19:57:41','772','0000-00-00 00:00:00','','2022-06-08 20:01:35','772'),(138,'21',83,'237',2,1,'2022-06-08 00:00:00','WARRI',45000.00,45000.00,0.00,'00000000','','7','BAU 958 ZE','Musa','07066839140','Received',5,'2022-06-08 20:00:19','772','0000-00-00 00:00:00','','2022-06-08 20:01:56','772'),(139,'21',84,'237',2,1,'2022-06-10 00:00:00','WARRI',15000.00,15000.00,0.00,'00000000','','5','JJN 60 YS','Yusuf','07066839140','Received',5,'2022-06-10 12:10:25','772','0000-00-00 00:00:00','','2022-06-10 12:11:52','772'),(140,'21',84,'237',2,1,'2022-06-10 00:00:00','WARRI',15000.00,15000.00,0.00,'00000000','','6','JJN 60 YS','Yusuf','07066839140','Received',5,'2022-06-10 12:10:25','772','0000-00-00 00:00:00','','2022-06-10 12:10:59','772'),(141,'21',85,'237',2,1,'2022-06-11 00:00:00','WARRI',15000.00,15000.00,0.00,'0000','','5','BAU 969 XR','Musa','07066839140','Received',5,'2022-06-11 06:46:29','772','0000-00-00 00:00:00','','2022-06-11 06:51:15','772'),(142,'21',85,'237',2,1,'2022-06-11 00:00:00','WARRI',30000.00,30000.00,0.00,'0000','','6','BAU 969 XR','Musa','07066839140','Received',5,'2022-06-11 06:46:29','772','0000-00-00 00:00:00','','2022-06-11 08:52:45','772'),(143,'21',86,'237',1,1,'2022-06-11 00:00:00','WARRI',45000.00,45000.00,0.00,'00000000','','1','BAU 412 ZE','Musa','07066839140','Received',5,'2022-06-11 06:47:54','772','0000-00-00 00:00:00','','2022-06-11 07:25:51','772'),(144,'21',87,'237',1,1,'2022-06-11 00:00:00','WARRI',28500.00,28500.00,0.00,'00000000','','3','GKW 128 XA','Musa','07066839140','Received',5,'2022-06-11 06:50:44','772','0000-00-00 00:00:00','','2022-06-11 07:27:29','772'),(145,'21',87,'237',1,1,'2022-06-11 00:00:00','WARRI',16500.00,16500.00,0.00,'00000000','','4','GKW 128 XA','Musa','07066839140','Received',5,'2022-06-11 06:50:44','772','0000-00-00 00:00:00','','2022-06-11 07:27:42','772'),(146,'21',89,'237',2,1,'2022-06-11 00:00:00','WARRI',15000.00,15000.00,0.00,'00000000','','5','BAU 751 ZE','Musa','07066839140','Received',5,'2022-06-11 10:14:00','772','0000-00-00 00:00:00','','2022-06-11 10:14:25','772'),(147,'21',89,'237',2,1,'2022-06-11 00:00:00','WARRI',15000.00,15000.00,0.00,'00000000','','6','BAU 751 ZE','Musa','07066839140','Received',0,'2022-06-11 10:14:00','772','0000-00-00 00:00:00','','0000-00-00 00:00:00',''),(148,'21',89,'237',2,1,'2022-06-11 00:00:00','WARRI',15000.00,15000.00,0.00,'00000000','','7','BAU 751 ZE','Musa','07066839140','Received',5,'2022-06-11 10:14:00','772','0000-00-00 00:00:00','','2022-06-11 10:15:58','772'),(149,'21',91,'237',1,1,'2022-06-11 00:00:00','WARRI',45000.00,45000.00,0.00,'00000009','','2','GKW 127 XA','Yusuf','07066839140','Received',5,'2022-06-11 10:26:17','772','0000-00-00 00:00:00','','2022-06-11 10:26:44','772'),(150,'21',90,'237',2,1,'2022-06-11 00:00:00','WARRI',30000.00,30000.00,0.00,'00000000','','5','BAU 981 XR','Musa','07066839140','Received',5,'2022-06-11 11:06:12','772','0000-00-00 00:00:00','','2022-06-11 11:10:47','772'),(151,'21',90,'237',2,1,'2022-06-11 00:00:00','WARRI',15000.00,15000.00,0.00,'00000000','','6','BAU 981 XR','Musa','07066839140','Received',5,'2022-06-11 11:06:12','772','0000-00-00 00:00:00','','2022-06-11 11:11:26','772'),(152,'21',90,'237',2,1,'2022-06-11 00:00:00','WARRI',15000.00,15000.00,0.00,'00000000','','7','BAU 981 XR','Musa','07066839140','Received',5,'2022-06-11 11:06:12','772','0000-00-00 00:00:00','','2022-06-11 11:11:56','772'),(153,'21',92,'237',1,1,'2022-06-11 00:00:00','WARRI',39700.00,40000.00,0.00,'00000000','','1','DKA 515 XA','Musa','07066839140','Received',5,'2022-06-11 17:48:46','772','0000-00-00 00:00:00','','2022-06-11 17:50:49','772'),(156,'21',94,'237',1,1,'2022-06-12 00:00:00','WARRI',30000.00,30000.00,0.00,'00000009','','2','JJN 60 YS','Yusuf','07066839140','Received',5,'2022-06-12 08:31:30','772','0000-00-00 00:00:00','','2022-06-12 08:32:14','772'),(157,'21',94,'237',1,1,'2022-06-12 00:00:00','WARRI',15000.00,15000.00,0.00,'00000009','','3','JJN 60 YS','Yusuf','07066839140','Received',5,'2022-06-12 08:31:30','772','0000-00-00 00:00:00','','2022-06-12 08:31:51','772'),(158,'21',93,'237',2,1,'2022-06-12 00:00:00','WARRI',20000.00,20000.00,0.00,'00000000','','5','BAU 204 XR','Musa','07066839140','Received',5,'2022-06-12 08:34:17','772','0000-00-00 00:00:00','','2022-06-12 08:38:08','772'),(159,'21',93,'237',2,1,'2022-06-12 00:00:00','WARRI',15000.00,15000.00,0.00,'00000009','','6','BAU 204 XR','Musa','07066839140','Received',5,'2022-06-12 08:34:17','772','0000-00-00 00:00:00','','2022-06-12 08:38:20','772'),(160,'21',93,'237',2,1,'2022-06-12 00:00:00','WARRI',15000.00,15000.00,0.00,'00000009','','7','BAU 204 XR','Musa','07066839140','Received',5,'2022-06-12 08:34:17','772','0000-00-00 00:00:00','','2022-06-12 08:38:40','772'),(161,'21',95,'237',2,1,'2022-06-12 00:00:00','WARRI',15000.00,15000.00,0.00,'00000000','','5','JJN 60 YS','Yusuf','07066839140','Received',5,'2022-06-12 09:26:09','772','0000-00-00 00:00:00','','2022-06-12 09:30:22','772'),(162,'21',95,'237',2,1,'2022-06-12 00:00:00','WARRI',15000.00,15000.00,0.00,'00000000','','6','JJN 60 YS','Yusuf','07066839140','Received',5,'2022-06-12 09:26:09','772','0000-00-00 00:00:00','','2022-06-12 09:30:47','772'),(163,'21',95,'237',2,1,'2022-06-12 00:00:00','WARRI',15000.00,15000.00,0.00,'00000000','','7','JJN 60 YS','Yusuf','07066839140','Received',5,'2022-06-12 09:26:09','772','0000-00-00 00:00:00','','2022-06-12 09:31:04','772'),(164,'21',96,'237',1,1,'2022-06-12 00:00:00','WARRI',32000.00,32000.00,0.00,'00000456','','1','ALK 826 XA','Musa','07066839140','Received',5,'2022-06-12 09:29:46','772','0000-00-00 00:00:00','','2022-06-12 09:31:19','772'),(165,'21',96,'237',1,1,'2022-06-12 00:00:00','WARRI',18000.00,18000.00,0.00,'000003546','','2','ALK 826 XA','Musa','07066839140','Received',5,'2022-06-12 09:29:46','772','0000-00-00 00:00:00','','2022-06-12 09:31:35','772'),(166,'21',97,'237',1,1,'2022-06-18 00:00:00','WARRI',16500.00,16500.00,0.00,'00000000','','1','BAU 782 ZE','Yusuf','07066839140','Received',5,'2022-06-18 16:42:51','772','0000-00-00 00:00:00','','2022-06-18 16:48:50','772'),(167,'21',97,'237',1,1,'2022-06-18 00:00:00','WARRI',33500.00,33500.00,0.00,'00000000','','2','BAU 782 ZE','Yusuf','07066839140','Received',5,'2022-06-18 16:42:51','772','0000-00-00 00:00:00','','2022-06-18 21:32:48','772'),(168,'21',98,'237',2,1,'2022-06-18 00:00:00','WARRI',30000.00,30000.00,0.00,'00000000','','5','JJN 60 YS','Yusuf','07066839140','Received',5,'2022-06-18 16:50:54','772','0000-00-00 00:00:00','','2022-06-18 16:51:56','772'),(169,'21',98,'237',2,1,'2022-06-18 00:00:00','WARRI',15000.00,15000.00,0.00,'00000000','','6','JJN 60 YS','Yusuf','07066839140','Received',5,'2022-06-18 16:50:54','772','0000-00-00 00:00:00','','2022-06-18 16:52:14','772'),(170,'21',99,'237',1,1,'2022-06-18 00:00:00','WARRI',16500.00,16500.00,0.00,'00000000','','3','BAU 677 XR','Yusuf','07066839140','Received',5,'2022-06-18 17:01:41','772','0000-00-00 00:00:00','','2022-06-18 18:46:51','772'),(171,'21',99,'237',1,1,'2022-06-18 00:00:00','WARRI',33500.00,33500.00,0.00,'00000000','','4','BAU 677 XR','Yusuf','07066839140','Received',5,'2022-06-18 17:01:41','772','0000-00-00 00:00:00','','2022-06-18 18:52:46','772'),(172,'21',100,'237',1,1,'2022-06-18 00:00:00','WARRI',5874.00,5874.00,0.00,'00000009','','3','BAU 677 XR','Yusuf','07066839140','Received',5,'2022-06-18 17:03:39','772','0000-00-00 00:00:00','','2022-06-18 18:51:56','772'),(173,'21',102,'237',2,1,'2022-06-18 00:00:00','WARRI',37000.00,37000.00,0.00,'00000000','','5','ALK 838 XA','Musa','07066839140','Received',5,'2022-06-18 18:44:23','772','0000-00-00 00:00:00','','2022-06-18 21:30:25','772'),(174,'21',102,'237',2,1,'2022-06-18 00:00:00','WARRI',13000.00,13000.00,0.00,'00000000','','6','ALK 838 XA','Musa','07066839140','Received',5,'2022-06-18 18:44:23','772','0000-00-00 00:00:00','','2022-06-18 18:48:35','772'),(175,'21',101,'237',2,1,'2022-06-18 00:00:00','WARRI',19000.00,19000.00,0.00,'00000000','','6','BAU 397 ZE','Musa','07066839140','Received',5,'2022-06-18 18:46:26','772','0000-00-00 00:00:00','','2022-06-18 18:47:54','772'),(176,'21',101,'237',2,1,'2022-06-18 00:00:00','WARRI',31000.00,31000.00,0.00,'00000000','','7','BAU 397 ZE','Musa','07066839140','Received',5,'2022-06-18 18:46:26','772','0000-00-00 00:00:00','','2022-06-18 18:47:32','772'),(177,'21',103,'237',1,1,'2022-06-18 00:00:00','WARRI',40000.00,40000.00,0.00,'0000','','1','BAU 29 ZE','Musa','07066839140','Received',5,'2022-06-18 22:24:44','772','0000-00-00 00:00:00','','2022-06-21 14:58:08','772'),(178,'21',106,'237',1,1,'2022-06-22 00:00:00','WARRI',15000.00,15000.00,0.00,'00000000','','3','JJN 60 YS','Yusuf','07066839140','Received',5,'2022-06-22 07:43:48','772','0000-00-00 00:00:00','','2022-06-22 12:04:58','772'),(179,'21',106,'237',1,1,'2022-06-22 00:00:00','WARRI',30000.00,30000.00,0.00,'00000000','','4','JJN 60 YS','Yusuf','07066839140','Received',5,'2022-06-22 07:43:48','772','0000-00-00 00:00:00','','2022-06-22 12:05:21','772'),(180,'21',105,'237',2,1,'2022-06-22 00:00:00','WARRI',44500.00,44500.00,0.00,'00000000','','5','BAU 308 ZE ','Yusuf','07066839140','Received',5,'2022-06-22 07:45:03','772','0000-00-00 00:00:00','','2022-06-22 12:05:43','772'),(181,'21',105,'237',2,1,'2022-06-22 00:00:00','WARRI',500.00,500.00,0.00,'0000','','6','BAU 308 ZE ','Yusuf','07066839140','Received',5,'2022-06-22 07:45:03','772','0000-00-00 00:00:00','','2022-06-22 07:48:50','772'),(183,'21',104,'237',2,1,'2022-06-22 00:00:00','WARRI',15000.00,30500.00,0.00,'00000000','','7','JJN 60 YS','Yusuf','07066839140','Received',5,'2022-06-22 07:46:33','772','0000-00-00 00:00:00','','2022-06-22 07:47:06','772'),(184,'21',104,'237',2,1,'2022-06-22 00:00:00','WARRI',30000.00,30000.00,0.00,'00000009','','6','JJN 60 YS','Musa','07066839140','Received',5,'2022-06-22 08:04:48','772','0000-00-00 00:00:00','','2022-06-22 08:05:21','772'),(185,'21',110,'237',1,1,'2022-06-22 00:00:00','WARRI',15000.00,15000.00,0.00,'0000','','1','JJN 60 YS','Musa','07066839140','Received',5,'2022-06-22 14:07:52','772','0000-00-00 00:00:00','','2022-06-22 14:11:54','772'),(186,'21',110,'237',1,1,'2022-06-22 00:00:00','WARRI',30000.00,30000.00,0.00,'0000','','2','JJN 60 YS','Musa','07066839140','Received',5,'2022-06-22 14:07:52','772','0000-00-00 00:00:00','','2022-06-22 14:12:24','772'),(187,'21',107,'237',2,1,'2022-06-22 00:00:00','WARRI',30000.00,30000.00,0.00,'0000','','5','BAU 981 XR','Musa','07066839140','Received',5,'2022-06-22 14:09:28','772','0000-00-00 00:00:00','','2022-06-22 16:19:50','772'),(188,'21',107,'237',2,1,'2022-06-22 00:00:00','WARRI',30000.00,30000.00,0.00,'0000','','6','BAU 981 XR','Musa','07066839140','Received',5,'2022-06-22 14:09:28','772','0000-00-00 00:00:00','','2022-06-22 14:11:18','772'),(189,'21',111,'237',2,1,'2022-06-22 00:00:00','WARRI',13500.00,13500.00,0.00,'0000','','5','TRR 540 YX','Musa','07066839140','Received',5,'2022-06-22 16:25:43','772','0000-00-00 00:00:00','','2022-06-22 16:27:39','772'),(190,'21',111,'237',2,1,'2022-06-22 00:00:00','WARRI',13000.00,13000.00,0.00,'0000','','6','TRR 540 YX','Musa','07066839140','Received',5,'2022-06-22 16:25:43','772','0000-00-00 00:00:00','','2022-06-22 16:36:44','772'),(191,'21',111,'237',2,1,'2022-06-22 00:00:00','WARRI',13500.00,13500.00,0.00,'0000','','7','TRR 540 YX','Musa','07066839140','Received',5,'2022-06-22 16:25:43','772','0000-00-00 00:00:00','','2022-06-22 16:37:11','772'),(192,'21',108,'237',2,1,'2022-06-23 00:00:00','WARRI',30000.00,30000.00,0.00,'0000','','7','JJN 60 YS','Yusuf','07066839140','Received',5,'2022-06-23 06:41:18','772','0000-00-00 00:00:00','','2022-06-23 06:41:54','772'),(193,'21',112,'237',2,1,'2022-06-23 00:00:00','WARRI',31417.00,31417.00,0.00,'0000','','6','BAU 491 YP ','Musa','07066839140','Received',5,'2022-06-23 06:49:02','772','0000-00-00 00:00:00','','2022-06-23 06:53:19','772'),(194,'21',112,'237',2,1,'2022-06-23 00:00:00','WARRI',15000.00,15000.00,0.00,'0000','','7','BAU 491 YP ','Musa','07066839140','Received',5,'2022-06-23 06:49:02','772','0000-00-00 00:00:00','','2022-06-23 14:09:54','772'),(195,'21',109,'237',2,1,'2022-06-24 00:00:00','WARRI',45000.00,45000.00,0.00,'00000000','','5','JJN 60 YS','Yusuf','07066839140','Received',5,'2022-06-24 08:35:41','772','0000-00-00 00:00:00','','2022-06-24 08:47:44','772'),(196,'21',114,'237',1,1,'2022-06-24 00:00:00','WARRI',24200.00,24200.00,0.00,'0000','','3','DBM 213 XA','Yusuf','07066839140','Received',5,'2022-06-24 08:40:06','772','0000-00-00 00:00:00','','2022-06-24 08:47:55','772'),(198,'21',113,'237',1,1,'2022-06-24 00:00:00','WARRI',45000.00,45000.00,0.00,'0000','','1','JJN 60 YS','Yusuf','07066839140','Received',5,'2022-06-24 08:49:47','772','0000-00-00 00:00:00','','2022-06-24 08:50:08','772'),(199,'21',115,'237',2,1,'2022-06-25 00:00:00','WARRI',41623.00,41623.00,0.00,'00000','','6','TRR 540 YX','Musa','','Received',5,'2022-06-25 09:24:48','772','0000-00-00 00:00:00','','2022-06-25 09:35:14','772'),(200,'21',115,'237',2,1,'2022-06-25 00:00:00','WARRI',3377.00,3377.00,0.00,'0000','','7','TRR 540 YX','Musa','','Received',5,'2022-06-25 09:24:48','772','0000-00-00 00:00:00','','2022-06-25 09:34:48','772'),(201,'21',116,'237',1,1,'2022-07-22 00:00:00','